﻿USE sofia;
DROP TABLE IF EXISTS sofia.yle_vpl;
CREATE TABLE yle_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yle_vpl WRITE;
INSERT INTO yle_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kédisu King Dépidi u tii ńedê pini ngmê, ala u tii. Myenté yi Dépidi Epîlaham u tii ńedê pini. ");
INSERT INTO yle_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Epîlaham tp꞉oo Yisak, Yisak tp꞉oo Njakóp. Njakóp tp꞉oo yoo, Njuda mbwémi knî, yélini Yichip dnyen꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Njuda tp꞉oo dê Pedes mbwémi Seda. Yi pye u pi Tema. Pedes tp꞉oo Hesîdon, Hesîdon tp꞉oo Lamî. ");
INSERT INTO yle_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamî tp꞉oo Aminatap, Aminatap tp꞉oo Nason. Nason tp꞉oo Salîmon. ");
INSERT INTO yle_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salîmon u tii ńedê pi ngmê chópu, u pi Mbówas, u pye Lahap. Mbówas tp꞉oo Opédi, u pye u pi Luti. Opédi tp꞉oo Njési, ");
INSERT INTO yle_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Njési tp꞉oo King Dépidi. Dépidi tp꞉oo Solomon, u pye pyópuni Dépidi ngê Yudaiya kwulo a pwââ. ");
INSERT INTO yle_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon tp꞉oo Lehopówam, Lehopówam tp꞉oo Apaicha. Apaicha tp꞉oo Asa. ");
INSERT INTO yle_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tp꞉oo Njehosîpat. Njehosîpat tp꞉oo Njódam, Njódam tp꞉oo Yusaiya. ");
INSERT INTO yle_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yusaiya tp꞉oo Njótam, Njótam tp꞉oo Ehas. Ehas tp꞉oo Hesîkaiya. ");
INSERT INTO yle_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesîkaiya tp꞉oo Manasa. Manasa tp꞉oo Amon, Amon tp꞉oo Njósaiya. ");
INSERT INTO yle_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Njósaiya tp꞉oo yoo, Njekînaiya mbwémi knî. Yi dini ghi ngê Mbápilon tpémi y꞉oo Njedusalem a pw꞉oo ngópu, Yisîléli tpémi Mbápilon ńuw꞉o tumo. ");
INSERT INTO yle_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","U kuwó dini ghi ngê Njekînaiya tp꞉oo Siyaltiyéli mî pyodo. Siyaltiyéli tp꞉oo Sedapapel. Sedapapel u dye ghi ngê, Yisîléli tpémi Njedusalem mê diyé dniye, p꞉aa mêmî l꞉âmo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sedapapel tp꞉oo Apiyuda. Apiyuda tp꞉oo Elayakim, Elayakim tp꞉oo Asó. ");
INSERT INTO yle_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asó tp꞉oo Sadóki, Sadóki tp꞉oo Akim. Akim tp꞉oo Eliyuda. ");
INSERT INTO yle_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuda tp꞉oo Eliyesa. Eliyesa tp꞉oo Matan, Matan tp꞉oo Njakóp. ");
INSERT INTO yle_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Njakóp tp꞉oo Njósép, pini n꞉ii Méli u moo. Yi Méli Yesu u pye, pini n꞉ii Chóó Lémi ngê a ngmidi ngê, nmî kada pini ngê a pyódu ngê. ");
INSERT INTO yle_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pi dyêêdî y꞉a mê páádi mî loo, kn꞉ââ Epîlaham, nkoo Dépidi. Pi dyêêdî mê y꞉a mê páádi mî loo, kn꞉ââ Dépidi, nkoo Mbápilon tpémi y꞉oo Yisîléli tpémi Mbápilon u ngwo ńuw꞉o tumo. Pi dyêêdî mê y꞉a mê páádi mî loo, yed꞉oo Yesu Kédisu mî ta. ");
INSERT INTO yle_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kédisu alanté ta. U pye Méli, Njósép u yémî p꞉uu yidoo kwo. Ghêlî daangê yéé knopwo, u lama yaa wo, apê, Chóó Lémi u Ghê Dmi ngê tp꞉ee a mênê ngmêdê kââ. ");
INSERT INTO yle_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","U moo Njósép, pi mb꞉aa. U yi u ngwo dêpwo kwo, Méli u pi yoo vy꞉o nî dyênê, u yi u ngwo doo kwo, Méli tumutumu nî kpîpî. ");
INSERT INTO yle_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yi kópu p꞉uu dpodombiy꞉e doo nuw꞉o, mgîdî ngmê ngê nmî Lémi u enjel ngma a wâdîvyîngo, kwo, Njósép, Dépidi u tii ńedê pini. Kwo, Kópuni Méli ngê pyodo, p꞉uu kidimê nuw꞉o. Kwo, Méli dpî nya ngi, ṉgmâm ngê dpî pyódu ngi. Kwo, Chóó Lémi u Ghê Dmi ngê tp꞉ee u mênê yinê dê kââ. ");
INSERT INTO yle_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kwo, Tpémini wa tpyé, u pi dpî ntaa ngi, Yesu, mu kópu u dîy꞉o u yoo yinê wa ngee té, yi yikî dmi u pwo wa ghay. (Yesu u nt꞉u kópu, yoo yi Mbwámê.) ");
INSERT INTO yle_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kópuni Chóó Lémi u komo kapî pyu ngmê ngê a d꞉êê ngê, Chóó Lémi ngê yinté a ntiye ngê. Yi kópu ala, ");
INSERT INTO yle_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Kwodo ngmê mbwili ngê wa ghê, tp꞉ee ngmêwa tpyé, u pi Imanuwel. (Imanuwel u nt꞉u kópu, Chóó Lémi nmî p꞉uu a t꞉a.) ");
INSERT INTO yle_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dini ghi n꞉ii ngê Njósép nyaa wo, kópuni enjel ngê u wóó k꞉oo u kwo mînê vyu, yi kópu d꞉uu ngê, Méli nyââ, u kpâm ngê pyódu ngê, ");
INSERT INTO yle_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ngmênê kópu nongo daangmê mdo ngópu, u dî mî tpamê wo. Njósép ngê tp꞉ee u pi nt꞉ângo, Yesu. ");
INSERT INTO yle_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu p꞉aani n꞉ii ta, u pi Petîlem, Njuda Wee u kwo p꞉aani ngmê. Yi dini ghi ngê Helodi king ngê doo ya. Kââdî kwéli dpo kee, mââwe ndîî knî ngmê y꞉i a ndê dniye, Njedusalem mî taa dniye. Pudu knî yi kakêmê chámêchámê yi tpóknî yi lama mb꞉aamb꞉aa ngê doo ya. ");
INSERT INTO yle_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Dini ghi n꞉ii ngê Njedusalem taa dniye, Nju tpémi yi kada pini knî ye póó dniye, yepê, Tpémini nmyi king ngê wa pyódu, ló y꞉i ta? Yepê, Dini ghi n꞉ii ngê a ta, u pudu nmî p꞉o kînmo módu. Yepê, Yi tpómu yidun꞉aa châpu, u l꞉êê dîy꞉o nmo lee dniye. ");
INSERT INTO yle_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Helodi ngê dini ghi n꞉ii ngê yi kópu nyongo, ghê u mênê ghipé wo, u nuw꞉onuw꞉o u kópu ngê pyodo. Njedusalem tpémi yi nuw꞉onuw꞉o u kópu ngê mye pyodo. ");
INSERT INTO yle_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kpêê yiyé pyu yoo yi kada pini yoo a danê too, dêêpî pyu yoo myedê danê too, ye póó wo, yepê, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, dini ghi n꞉ii ngê wa t꞉aa, ló p꞉aani wa t꞉aa? ");
INSERT INTO yle_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kwo, Petîlem wa t꞉aa, Njuda Wee u kwo. Kwo, Chóó Lémi u kópu dyuu puku yedê alanté a kwo, ");
INSERT INTO yle_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Njuda Wee u kwo p꞉aani n꞉ii u pi têdê, Petîlem, dîyo u pi ndîî ngê wa pyódu, mu kópu u dîy꞉o dîyo yi p꞉aani pi ngmêwa t꞉aa, pini n꞉ii ngê a yoo Yisîléli tpémi adî y꞉enê dé. ");
INSERT INTO yle_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wod꞉oo Helodi ngê yi mââwe yoo tumutumu a danê too, yepê, Ló wéni ngê yi pudu mwiyé nmyinê m꞉uu ngópu? Dini ghi n꞉ii ngê u kakêmê u kwo chámê ngópu, ");
INSERT INTO yle_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","wod꞉oo Petîlem dy꞉ââ too, yepê, Yi tpémi mb꞉aamb꞉aa ngê dpîmo pyw꞉ee yó. Yepê, Dmyinên꞉aa pyw꞉ee knomomê, amêma a ka modo vyi yó, u nkwo wanî lê, an꞉uu châpu. ");
INSERT INTO yle_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Wod꞉oo kada a y꞉ee ngópu. Puduni yi p꞉o a m꞉uu ngópu, maa p꞉uu yi pudu mê m꞉uu ngópu, dnye yâmuyâmu. Yi gha dmi d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê pyodo. Tpómu kwéli doo a ya, yi pudu y꞉i mî ghê wo, yi tpémi u ngwo a pyw꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ngomo k꞉oo yi kee dniye, apê, U pye vyââ mu tóó. Yi yi mbodo dmi ngê k꞉ame u kwo ghê dniye, u ngwo châpu ngópu. Yi péé dmi kpêmî ngópu, tpile mb꞉aa knî u kwo ngmê y꞉ee ngópu, nkól ngmê, pîdánkinsens myomo, mêê pyolo. Yi tpile knî yi pywuu dmi pââ ndîî dé. ");
INSERT INTO yle_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dini ghi n꞉ii ngê yi p꞉o mêdnye diyédiyé, Chóó Lémi ngê wóó k꞉oo yepê, Helodi ka máádi nangê kwolo. Wod꞉oo kn꞉aa máádi m꞉uu kalê ngópu. ");
INSERT INTO yle_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mââwe yoo yi lee dniye, Njósép ngê nmî Lémi u enjel wóó k꞉oo ngmê módu, kwo, A piidi. Kwo, Méli ghee yi k꞉ii mbêpê dmyeno, Yichip ńuw꞉o dé, y꞉i dmyinên꞉aa ya, u dî ṉga am꞉aa vyi. Kwo, Helodi ngê ye tpémi u nmy꞉uu kn꞉ââ daa kêmakêma a chapî. Kwo, Wa a pyw꞉ee knomomê, wa vy꞉a. ");
INSERT INTO yle_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Wod꞉oo yi mgîdî vy꞉o Njósép a pii wo, Méli ghee yi k꞉ii kada a y꞉ee ngópu, Yichip dîyo mî taa dniye. ");
INSERT INTO yle_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Y꞉i dnyen꞉aa ya, u dî Helodi mî pwene. Nmî Lémi ngê chóó u kópu u ngwo a ntiye ngê, kópuni puku yedê alanté a tóó, A tp꞉ee Yichip doon꞉aa ya, y꞉i u kwo nîmo mbwolo, u ngwo a loo. ");
INSERT INTO yle_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helodi ghêlî daangê pwene, dini ghi n꞉ii ngê a w꞉ee ngê, apê, Wu pini knî y꞉oo até dê dóó nê, yi p꞉o maa diyé dmi, wod꞉oo d꞉ud꞉umbiy꞉e nod꞉e wo. Wéni n꞉ii mwiyé u kwo kêma ngópu, nuw꞉o kwólu, apê, Yi tpémi ngê m꞉ââ miyó doongê ndîî. U lede knî ye yepê, Petîlem dmyinê lêpî, tpémini kamî dê taa dmi, n꞉ii knî y꞉oo m꞉ââ miyó doongê ma ngópu, dp꞉uu vya tóó. Wod꞉oo lee dniye, yinté mî d꞉uu ngópu, Petîlem Wee u kwo tp꞉ee mââ kamî yintómu vya tumo. ");
INSERT INTO yle_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kópuni Njedîmaiya ngê yi wee p꞉uu wunê a d꞉êê ngê, yi lede knî y꞉oo yi ngwo ntiye ngópu. Yi kópu ala, ");
INSERT INTO yle_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Laama Wee u kwo mbê ndîî ngê dê pyódu. Lechel u too pee yoo yi tp꞉ee yoo yi l꞉êê dîy꞉o ka mbê té. Ka mbê té. Doo u ntââ pi ngê yi nuw꞉o dmi daawa l꞉âmo, mu kópu u dîy꞉o yi tp꞉ee yoo yi ghê dmi daa pyede. ");
INSERT INTO yle_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Dini ghi n꞉ii ngê Helodi pwene, Njósép mupwoknî Yichip dnye ya. Njósép ngê u wóó k꞉oo nmî Lémi u enjel ngmê módu, ");
INSERT INTO yle_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kwo, A piidi, Méli ghee yi k꞉ii nmyi wee u kwo mê diyé dmyeno, Yisîléli. Kwo, N꞉ii ngê u yi doo kwo, Ye tpémi nî vy꞉a, kêdê pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Wod꞉oo Njósép a pii wo, Méli ghee yi k꞉ii kada a y꞉ee ngópu, yi wee u kwo mê diyé dniye. ");
INSERT INTO yle_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Dini ghi n꞉ii ngê nyongo, apê, Helodi tp꞉oo Akeleyas Helodi ngê u mî u d꞉aa kêdê kââdî, Njuda tpémi yi king ngê dê pyódu, Njósép nkîngê mbê wo, u yi u ngwo dêpwo kwo, Y꞉i nmîn꞉aa ya. U wóó k꞉oo nmî Lémi u enjel mê módu, kwo, Nkálili Wee u kwo dpî lee dmyeno, y꞉i dmyinên꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Wod꞉oo Nkálili Wee u kwo lee dniye, p꞉aa ngmê y꞉i dnyen꞉aa ya, u pi Nasalet. Kópuni Chóó Lémi u komo kapî pyu ngmê ngê wunê a d꞉êê ngê u ngwo ntiye ngê. Yi kópu ala, Pi knî y꞉oo u pi wa ntaa ngmê, Nasalet pi. ");
INSERT INTO yle_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dini ghi n꞉ii ngê Yesu mââwe ngê pyodo, Nasalet doo ya. Yi ngwo Njon Baptist ngê u dpodo kn꞉ââ chópu. Njuda Wee u kwo w꞉amî mbêmê pi knî ye dpîmon꞉aa dêêpî. ");
INSERT INTO yle_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Yipu, Dini ghi n꞉ii nmo t꞉âât꞉ââ, Chóó Lémi ngê chóó u ngwo ada a y꞉enê nmo, yi dini ghi daa kêmakêma a dyimêdyimê. Yipu, Nmyi dono yilî kéé tóó, Chóó Lémi ka diyé dmyeno. ");
INSERT INTO yle_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kópuni Yisaya ngê u puku yedê wunê a d꞉êê ngê, Njon ngê yi ngwo ntiye ngê. Yi kópu ala. W꞉amî mbêmê pi ngma adî kââ, yewo, Nmî Lémi u maa a yé yó, maa mb꞉aa yidó yé yó. ");
INSERT INTO yle_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Chóó Lémi u komo kapî pyu Ilacha ngê kpîdî gh꞉aagh꞉aa ntee dpîmo a t꞉emî, Njon ngê yinté kpîdî myedpîmo t꞉emî, kámêl gh꞉aa kpîdî. Pudumakó too pee u mbalêti ngê pyódu ngê, u paa vyîlo yidpîmo t꞉emî. Mty꞉aa ndâpu kpele numo u ch꞉ee dpîmo kuwo dê, mu kópu u dîy꞉o nté y꞉i dêpwo ya. ");
INSERT INTO yle_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Njedusalem pi yilî Njon ka loo, Njuda Wee u kwo p꞉aa woni knî yi k꞉oo yoo a ndê dniye, Njon ka lee dniye, mbwaa ndîî Njódan u nkîgh꞉ê p꞉aani n꞉ii a pyede, yi p꞉aani tpémi Njon ka mye lee dniye, dnyen꞉aa ng꞉aang꞉aa. ");
INSERT INTO yle_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yi dono yilî yi yuu dmi Njon ka dnyimon꞉aa a y꞉emî dé, wod꞉oo mbwaa ndîî paa Njódan yinê dpîmo kmênêkmênê dé, mbápitisîm ye dpîmo yém, yi dono yilî u ngwo dpîmo ghêêghêê dé. ");
INSERT INTO yle_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Njon ngê yoo kwéli dpîmo mbápitisîm kîgha, yi kêlî ghê Pádisi yoo, Sadyusi yoo yilî u kwo mye loo, u yi y꞉e doo kwo, Nye mbápitisîm kalê nmîne. Njon ngê yi gha dmi módu, yepê, Nmyo k꞉omodanê pyu yoo. Yepê, Lukwe dîy꞉o nmyinê nmye, Mbápitisîm mbêmê Chóó Lémi ngê daawa kpada nmo. Yepê, Nmyi dono yilî mwiyé kéé tóó. ");
INSERT INTO yle_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yepê, Dono kópu n꞉aamungî d꞉uu, kópu mb꞉aa yilî dmyinên꞉aa d꞉uud꞉uu, u ngwo anê w꞉ee, nê, Yi nuw꞉o dmi ndêndê ngê dê ngmêê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yepê, Ala kópu namê tpapê, Epîlaham nmî kn꞉ââ, Chóó Lémi ngê daawa kéé nmo, p꞉ee nmo ada a vyuwo. Yepê, Yi kópu ló dini mwo a vyu, ngmênê nmyi dono yilî yi l꞉êê dîy꞉o ntênê wa kéé nmyo. Yepê, Chóó Lémi u wêdêwêdê ndîî, u ntââ, ala chêêpî dyuu wa a ngî, pi ngê wa pyódu té, nmyi d꞉aa dmi y꞉oo wa a kââdî ngmê. Yepê, Vyîlo yi yéli ye ada a vyuwo. ");
INSERT INTO yle_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yepê, Ala ngwo Chóó Lémi maadî kîyedê kwo, u myângo wumê mumu. Yepê, Yi myângo vy꞉o yini n꞉ii nt꞉u mb꞉aamb꞉aa ngê daa kelekele, wa kpono, pââ ndiya wa kéé. ");
INSERT INTO yle_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yepê, N꞉ii ngê u dono yilî wa kéé té, yi pini mbwaa ngê wanî mbápitisîm kwolo, ngmênê pini n꞉ii a kuwó wunê kwo, yi pini ngê Chóó Lémi u Ghê Dmi ngê wa mbápitisîm kalê nmyo, ndyuw꞉e ngê wamye mbápitisîm kalê nmyo. Yepê, Pini n꞉ii a kuwó wunê kwo, u pi ndîî. Yepê, Nê têdê. Yepê, D꞉oo u ntââ, u nkîgh꞉ê daanî nî. Yepê, Nê tp꞉ee. ");
INSERT INTO yle_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yepê, Pini n꞉ii wunê pwiyé knî, daa kêmakêma a taataa. Dini ghi n꞉ii ngê wa t꞉aa, nmyo yintómu daawa ngee nmyo, wa chámê nmyo. Yepê, N꞉ii yoo mb꞉aamb꞉aa dé, wa a ngî té, n꞉ii yoo dono dé, wa kéé té, ndê ngê wa ma té, yi ndyuw꞉e chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yi dini ghi ngê Yesu ngê Nkálili Wee a kuwo ngê, Njódan mbwááni a ńuwo, Njon ka u ngwo loo, kwo, Mbápitisîm kalê nédi. ");
INSERT INTO yle_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngmênê Njon ngê kwo, P꞉ee wuchi mbápitisîm kalê nê. Kwo, Lukwe dîy꞉o m̱ápitisîm kîgha u pi a ka nye tpapê. ");
INSERT INTO yle_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu ngê kwo, Ala ngwo yenté mwiyé mbápitisîm kalê nédi. Kwo, Kópu yilî yintómu Chóó Lémi ngê nye a vyi too, doo u ntââ yi wépi dmi daanyi puwâ. Wod꞉oo Njon ngê mbápitisîm kwólu. ");
INSERT INTO yle_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu mbwaa lêê u mênê yedê pii wo, apê, Mbóó mêdê kpêmî. Myenté Chóó Lémi u Ghê Dmi vy꞉êmê k꞉ii ntee tpile ngê u pwo a ghêpê wo. ");
INSERT INTO yle_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mbóó p꞉uu dnye ngmê ny꞉ee ngópu, yepê, Kî a tp꞉ee njini, u nuu ghi a nódo a tóó, dye ghi yintómu a nuu u kópu ye d꞉uud꞉uu too. ");
INSERT INTO yle_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yi dini ghi ngê Chóó Lémi u Ghê Dmi ngê Yesu w꞉amî mbêmê ńuwo, apê, Setan ngê y꞉i pêdên꞉aa tókó ngê. ");
INSERT INTO yle_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Y꞉i doon꞉aa ya, wu podoy꞉a wo podoy꞉a nté dêpwo pîpî, dómu ndîî u ngwo yi kele. ");
INSERT INTO yle_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wod꞉oo Setan u kwo loo, kwo, Mumdoo nyi Chóó Lémi Tp꞉oo, ye kî chêêpî knî ngma a ngini, nté ngê pyódu té, ma té. ");
INSERT INTO yle_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu ngê kwo, Puku yedê alanté a tóó, Nté u mo doo u ntââ, pi u ngwo daa ya yédi. Nté daa nté njini, Chóó Lémi u kópu dyuu, yi nté njini. ");
INSERT INTO yle_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","U kuwó dini ghi ngê Yesu ka ngmênê u kwo, Setan ngê Njedusalem dê ńuw꞉o nê, M꞉aa u ngomo pw꞉ono y꞉i d꞉uu kaa nê. ");
INSERT INTO yle_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Setan ngê kwo, Mumdoo nyi Chóó Lémi Tp꞉oo, mumdoo m̱î ngê amyedê ngee ngi, ye ala ngomo pw꞉ono a mbêka, mu kópu u dîy꞉o puku yedê alanté a tóó, Chóó Lémi ngê u enjel yoo wunê dyede té, a ngêêpî ngi. Kwo, Ala kópu puku yedê mye tóó, Enjel yoo yi kêê yedê anyi kwo, ṉyi dê chêêpî u mênê daanyinê dêê dê. ");
INSERT INTO yle_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu ngê kwo, Doo u ntââ M꞉aa yinté daanê tókó, mu kópu u dîy꞉o puku yedê ala kópu mye tóó, Chóó Lémi nmî Yâpwo njini kidima a tókótókó. ");
INSERT INTO yle_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","U kuwó dini ghi ngê Setan ngê mbu mbêmê kmungo, dyámê pee yintómu y꞉i u kwo mînê kêma too, yi kópu mb꞉aa yilî y꞉i u kwo myemînê kêma too. ");
INSERT INTO yle_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Setan ngê kwo, A dnye nye nyêmî knomomê, ṉyi mbodo dê y꞉e k꞉ame a ka nyinê wowo knomomê, ye kî tpile yintómu ṉga wanî kê. ");
INSERT INTO yle_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu ngê kwo, Setan. Kwo, A nkîgh꞉ê a yumwe. Kwo, Puku yedê alanté a tóó, Chóó Lémi nmî Yâpwo njini chi chââchââ, kn꞉aa pini u dnye nangmê ny꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Setan ngê Yesu yedê kuwo ngê, wod꞉oo enjel yoo a lee dniye, Yesu mî ngee ngópu. ");
INSERT INTO yle_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","U kuwó dini ghi ngê Njon ngê king Antipas Helodi ka u dono kópu yilî dpîmo kwódukwódu dé. Yi kwódu yé u l꞉êê dîy꞉o Helodi ngê Njon mbwa k꞉oo kmungo. Dini ghi n꞉ii ngê Yesu ngê yi kópu nyongo, Njuda Wee a kuwo ngê, Nkálili Wee u kwo loo. ");
INSERT INTO yle_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasalet myedê kuwo ngê, Kîpêêniyêm doon꞉aa ya. Yi p꞉aani Nkálili Kpéni Lêê u nkîgh꞉ê a tóó. Yi p꞉aani Sepulun mbwémi Napîtali yi yoo dê yi wee u kwo a tóó. ");
INSERT INTO yle_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kópuni Yisaya ngê wunê a d꞉êê ngê, Yesu ngê yi ngwo ntiye ngê, yi wee u kwo doon꞉aa ya. Yi kópu ala. ");
INSERT INTO yle_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sepulun mbwémi Napîtali yi yoo dê yi p꞉uu n꞉aa mbumu. Ntii kêpa máádi u nkîgh꞉ê yi yoo dê yi wee a tóó, Njódan mbwááni ntii yi kêlî ghê. Yi wee u pi mye Nkálili, yélini daa Nju tpémi yilî y꞉i a tóó. ");
INSERT INTO yle_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yélini y꞉i a pyede, mgîdî vy꞉o a wee, ngmênê dîyo nmî Mbwámê u wuu ndîî wa m꞉uu ngmê. Yi yéli pwopwo u wee dnyimo a pyede, dîyo u wuu ndîî yi pwo wa kéé. ");
INSERT INTO yle_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nyââ, yi dini ghi ngê Yesu ngê u dpodo kn꞉ââ y꞉i mî chópu, pi knî ye yipu, Chóó Lémi ngê u yoo y꞉enê kn꞉ââ daa kêmakêma a chapî. Yipu, Nmyi dono yilî kéé tóó, Chóó Lémi ka diyé dmyeno. ");
INSERT INTO yle_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Dini ghi n꞉ii ngê Yesu Nkálili Kpéni Lêê u nkîgh꞉ê doo m꞉ii, te yâmuyâmu pyu miyó módu, Saimon mbwémi Andru, apê, Mu vyuwó mo. (Yi Saimon u pi mye Pita.) ");
INSERT INTO yle_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu ngê mgongo ye ngmê kwólu, yepê, A ngm꞉êê nódó. Yepê, Te u vyuwó ntee dpî lama a tóó, pi vyuwó yinté dpî lama n꞉aa kîgha. Yepê, Pi yilî Chóó Lémi ka wanmo ńuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yi ngwo dini ghi ngê yi pwoo a kuwo ngópu, Yesu ngm꞉êê ngópu. ");
INSERT INTO yle_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Até yidnye lêpî, mwada y꞉i myenté Yesu ngê pi mbwémi mê miyó até yi m꞉uu doo, Njems mbwémi Njon, Sepédi tp꞉oo dê. Yi mî Sepédi u k꞉ii dinki k꞉oo dnye kwo, yi pwoo dnye l꞉âmol꞉âmo. Dini ghi n꞉ii ngê Yesu ngê m꞉uu doo, yepê, A pwiyé cho. Yepê, A p꞉uu anyi kaa cho. ");
INSERT INTO yle_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wod꞉oo yi mî dinki k꞉oo a kuwo ngópu, Yesu u kuwó ghê knopwo. ");
INSERT INTO yle_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu p꞉uu Nkálili Wee u kwo p꞉aani p꞉aani lee dniye, yoo yi ngêpê ngomo knî yi k꞉oo dnyimon꞉aa koko. Yesu y꞉i ye dpîmon꞉aa dêêpî, kópu mb꞉aa p꞉uu ye dpîmon꞉aa mbumu, yipu, Chóó Lémi ngê chóó u yoo yi y꞉enê kn꞉ââ daa kêmakêma a chapî. Pwopwokopwe yilî mye pyi ngê. Mbii dyêêdî daa ngmidi yi p꞉uu doo ya, ngmênê Yesu ngê pyi too. ");
INSERT INTO yle_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sidiya u wee yintómu knî yi kwo p꞉aani p꞉aani yi kópu yi ny꞉ee ngópu, wod꞉oo pi knî y꞉oo pwopwokopwe yilî u kwo a ńuw꞉o ngópu, mbii dyêêdî daa ngmidi yedoo ya. N꞉ii knî y꞉oo kópu dyêêdî daa ngmidi dnya a vyîmî, u kwo myedê ńuwo tumo, n꞉ii knî y꞉e yi kmêna dnye kwo, n꞉ii knî y꞉e nyuno pwopwo dpîmo kelekele, n꞉ii knî yi kpâlî dmi ntóó dé, u kwo myedê ńuw꞉o tumo, yi yéli yintómu Yesu ngê pyi ngê. ");
INSERT INTO yle_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pi yintómu knî y꞉oo Yesu dnye yâmuyâmu, Nkálili Wee u kwo tpémi, P꞉aa Y꞉a knî yi Wee u kwo tpémi, Njedusalem tpémi, Njuda Wee u kwo tpémi, Pédiya Wee u kwo tpémi. Yi yéli daa wee ngmidi yi kwo a ndê dniye, u ngwo dnye yâmuyâmu. ");
INSERT INTO yle_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu ngê yoo yi módu, wod꞉oo mbu mbêmê kee wo, y꞉i mbwódo mî yaa wo. P꞉uu ndiye pyu knî y꞉oo a yina ngópu, ");
INSERT INTO yle_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","wod꞉oo doo ndiye kîgha dé. ");
INSERT INTO yle_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Yepê, Pinté knî y꞉oo u yi ntee a kwo, Pi knî y꞉oo dny꞉oo ngêêpî nmo, n꞉ii knî y꞉oo u yi yinté mye kwo, Chóó Lémi ngê choo a ngêêpî nmo, yi yéli yi gha dmi dny꞉oo pywelepywele, Chóó Lémi ngê kóó k꞉oo wa kaa té. ");
INSERT INTO yle_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yepê, N꞉ii knî y꞉oo yi dono knî yi l꞉êê dîy꞉o tpéé kópu dpî vyi ngmê, mye mbê nyédi, yi gha dmi dny꞉oo pywelepywele, Chóó Lémi ngê yi dono yilî u kuwó wa kéé té, yi nuw꞉o dmi amê l꞉âmo té. ");
INSERT INTO yle_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Yepê, Yélini daa kadakada nyédi, yi gha dmi dny꞉oo pywelepywele, Chóó Lémi ngê kópuni u pi wunê a vyu, y꞉e wa d꞉uu, kóó k꞉oo wa kaa té. ");
INSERT INTO yle_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Yepê, N꞉ii knî ye kópu mb꞉aa d꞉uud꞉uu yi nté njini ngê a ya yédi, yi yéli yi gha dmi dny꞉oo pywelepywele, Chóó Lémi ngê pi mb꞉aa ngê wa pyódu té, yi ntini ngê wa pile dmi. ");
INSERT INTO yle_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Yepê, N꞉ii knî ye yoo dpî ch꞉anê dmi, yi gha dmi dny꞉oo pywelepywele, Chóó Lémi ka u nkwo wa ch꞉anê dmi. ");
INSERT INTO yle_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Yepê, N꞉ii knî y꞉oo yi nuw꞉o k꞉oo nuw꞉o ghi dono daa kîgha tumo, yi yéli yi gha dmi dny꞉oo pywelepywele, Chóó Lémi ngê kóó k꞉oo wa kaa té, nipi adnyin꞉aa ya kmaapî. ");
INSERT INTO yle_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Yepê, N꞉ii knî y꞉oo yoo wunê kââdîkââdî tumo, yi gha dmi dny꞉oo pywelepywele, mu kópu u dîy꞉o Chóó Lémi ngê ye wa vyi, yewo, Nmyo a tp꞉ee dmââdîma. Yewo, Nê pi kââdîkââdî pyu, a nt꞉anê dmyi yaa dmi. ");
INSERT INTO yle_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Yepê, N꞉ii knî y꞉oo Chóó Lémi u l꞉êê dîy꞉o kópu mb꞉aa adnyi d꞉uud꞉uu dé, k꞉omo tpile mgîdî u yoo knî y꞉oo adnyi kpakakpaka dé, amyednyi vyee dé, ngmênê yi gha dmi dny꞉oo pywelepywele, Chóó Lémi ngê kóó k꞉oo wa kaa té. ");
INSERT INTO yle_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yepê, A l꞉êê dîy꞉o pi knî ye wanmyi diya dmi, k꞉omodanê mbêmê kópu dono yilî nmyi p꞉uu adnyin꞉aa tpapê, amyednyi vyee nmyo. ");
INSERT INTO yle_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yepê, Yi dono vy꞉o nmyi gha dmi dpî pywálî dniye, dono ngê kîngî pyaa dmi, mu kópu u dîy꞉o yi mgînî vyîmî u pywuu mb꞉aa wanmyimo ngee ngmê, mbóó p꞉uu. Yepê, Yi kópu daa nmyi mo nmye wa pyódu. Yepê, Yinté kópu knî yi kn꞉ââ knî y꞉oo Chóó Lémi u komo kapî pyu knî y꞉e wunê kîmyedê d꞉uu tumo. Yepê, Chóó Lémi ngê u komo kapî pyu yoo yi dpodo ntee wa pwila, yinté wamye pwila nmyo. ");
INSERT INTO yle_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesu ngê p꞉uu ndiye pyu knî ye mgongo ngmê kwólu, yepê, Ntii mb꞉aamb꞉aa. Yepê, Nté tpyópu u mênê ntii daanyi yé knomomê, ye u n꞉uu daadî ya, pwópwó ngê wa pyódu, nanê wa ma. Yepê, Wo yéli knî ye ntii ntee tpile ngê dmyinên꞉aa ya. Yepê, Ntii vy꞉êmî têdê nmyi tp꞉ee ngmanmyi dy꞉ââ knomomê, pye nkwodo ntii wa vy꞉êê knomomê, yini pwópwó, u n꞉uu daadî ya, ye lónté mb꞉aamb꞉aa ngê wa pyódu? Yepê, Doo u ntââ. Yepê, U dpodo daadî ya, wanmyi pii ngmê. Yepê, Ntii n꞉ii nmyi mênê a tóó, chedê ngê kîngê pyódu. ");
INSERT INTO yle_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yesu ngê mgongo ye m꞉uu kwólu, yepê, Nmyo yoo wo yéli yi pywápê ntee tpile dé. Yepê, P꞉aani n꞉ii mbu mbêmê anyi gh꞉ii knomomê, doo u ntââ pi daawa ngmo. ");
INSERT INTO yle_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yepê, Lam myenté. Yepê, Dini ghi n꞉ii ngê mgîdî dpo ghay, n꞉ii ngê lam dpo vyuwó, doo u ntââ tpile u pwo k꞉ame daawa kââ, mu kópu u dîy꞉o lukwe ngê mgîdî wa chaa? Yepê, Yi pini ngê lam dpo y꞉oo, ya nkwodo dpî kââ, yoo u ngwo dpî numo m꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yepê, Nmyo mye ntee dé. Yepê, Nmyo yoo yi lam dé, mb꞉aamb꞉aa ngê dmyinê dnyednye, kópu ngmê ngê kîngê dyênê nmyo. Yepê, Kópu mb꞉aa n꞉ii anmyin꞉aa d꞉uud꞉uu dé, pi knî y꞉oo dny꞉oo mumu dé, yi kópu knî yi l꞉êê dîy꞉o nmyi Mî dny꞉oo chaa kîgha, pini n꞉ii mbóó p꞉uu wunê tóó. ");
INSERT INTO yle_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesu ngê yepê, Alanté namê nuw꞉o, Nê ngê Mósisi u dêêpî kópu dyuu, Chóó Lémi u komo kapî pyu yoo yi kópu dé yinê a chedêchedê té. Yepê, Kêle. Yepê, Daa yi chedêchedê u l꞉êê dîy꞉o nê loo, ngmênê yi kópu dyuu yi ntiyentiye u l꞉êê dîy꞉o nê loo. ");
INSERT INTO yle_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yepê, Ndê kópu nmye ngmên꞉aa tpapê, yepê, mbóó dyámê ntee chedê ngê ghêlî k꞉ii daawa pyaa knî, Chóó Lémi u dêêpî kópu dyuu ndêndê yinté chedê ngê myedaawa pyódu, mu ngmidi l꞉âmo myedaawa a ngêpa, u dî kópu yilî yintómu wamî pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yepê, N꞉ii ngê dêêpî kópu dyuu adî chââchââ dé, u pyipe knî ye amyedîn꞉aa tpapê dé, Chóó Lémi kóó k꞉oo yi pini u pi ndîî ngê wa pyódu. Yepê, Ngmênê n꞉ii ngê dêêpî kópu ngmê daadî chââchââ, u pyipe yoo u nt꞉anê wa yé té, k꞉omo tpile yi dêêpî kópu daa ndîî, ngmênê Chóó Lémi kóó k꞉oo yi pini u pi têdê ngê wa a pyódu. ");
INSERT INTO yle_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yepê, Ndê kópu nmye m꞉uu n꞉aa tpapê. Yepê, Dêêpî pyu yoo Pádisi yoo dêêpî kópu dyuu yi too pee mbêmê a chââchââ tumo. Yepê, Dêêpî kópu dyuu ntênê daanmyi chââchââ dé, ye Chóó Lémi kóó k꞉oo daanmyi ghê dmi. ");
INSERT INTO yle_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesu ngê yepê, Mósisi ngê nmî kn꞉ââ knî ye ala kópu wunê mwo a vyu, yepê, Pi nangmê vy꞉a, n꞉ii ngê pi ngmêdê vya knomomê, dpî kóté kalê yó, u nkwo dpî vya yó. ");
INSERT INTO yle_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yepê, Mósisi ngê yi kópu ye a vyu, ngmênê ala kópu nmye n꞉aa tpapê, N꞉ii u mbwó ka dê nod꞉e knomomê, ye dono kópu ayi d꞉uu, kóté têdê dpî lee we. Yepê, N꞉ii ngê u mbwó ka dê vyi knomomê, M̱odo podo, ye dono kópu ndîî ayi d꞉uu, kóté ndîî têdê dpî lee we. Yepê, N꞉ii ngê u mbwó p꞉uu wa vyi, Wu pini dono, Chóó Lémi kóó k꞉oo daawa ghê, yepê, yi pini Chóó Lémi ngê kóó k꞉oo p꞉ee daawa kââ, ndiya wa kéé. Yepê, Noko mb꞉aamb꞉aa ngê dmyinê ya. ");
INSERT INTO yle_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yepê, Dini ghi n꞉ii ngê Chóó Lémi ka tpile ngmanyi y꞉oo, kópu ngmanyi nuw꞉o kwolo, kópuni u l꞉êê dîy꞉o m̱wó ṉga a nod꞉enod꞉e yédi, ");
INSERT INTO yle_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ye yi tpile y꞉i dpo kuwo ngi, m̱wó ka dpî lili, yi kópu dp꞉uu l꞉âmo nyoo, mb꞉aamb꞉aa noko moon꞉aa y꞉ee nyoo. Yepê, U kuwó dini ghi ngê modo dini, Chóó Lémi ka yi tpile moon꞉aa y꞉eni. ");
INSERT INTO yle_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Yepê, Dini ghi n꞉ii ngê ngmanmyi kn꞉aadi ngmê, n꞉ii ngê u yi adî kwo, Nî kóté kalê nmyo, dini ghi n꞉ii ngê kóté têdê adî ńeńe nmyo, yi kópu maa p꞉uu d꞉ââ dpî l꞉âmo yó, yed꞉oo kóté y꞉enê pyu u ngîma mêdaanmy꞉uu ghê dmi, mbwa k꞉oo mêdaamî km꞉êê nmyo. ");
INSERT INTO yle_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yepê, Mbwa k꞉oo wa km꞉êê nmyomomê, ye y꞉i anmyin꞉aa ya, u dî nmyi dono ntênê wanmyi pwila t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesu ngê yepê, Ala kópu nmyi lama ka tóó, wunê Mósisi ngê nmî kn꞉ââ knî ye mwo a vyu, yepê, Pi u kuwó nangmê pwiyé. ");
INSERT INTO yle_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yepê, Mósisi ngê yi kópu ye a vyu, ngmênê ala kópu nmye n꞉aa tpapê, N꞉ii ngê pyââ angmê m꞉uu, u nuw꞉o k꞉oo awo, Kî pyópu u maadî n꞉aa wowo, yepê, yi pini ngê yi pyópu dpî d꞉uu, pyââ ti u kópu u nuw꞉o k꞉oo yu d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yepê, Tpileni nmyi ngwolo knî y꞉oo wa m꞉uu ngmê, yi p꞉uu anmyi nuw꞉odono, u kuwó dini ghi ngê wanmyi d꞉uu ngmê, mu dini ghi ngê ndiya u nkwo anmy꞉uu ghêpê dmi. Yepê, Yi nuw꞉odono u kwee lîmîlîmî ngê anmyi châpwo ngmê, yed꞉oo yi dono daanmyi d꞉uu ngmê. Yepê, Dono kópuni pi knî ye mb꞉aamb꞉aa dé, k꞉omo tpile yi p꞉eeni kópu daanmyi d꞉uu t꞉oo, ngmênê yi l꞉êê dîy꞉o ndiya daanmy꞉uu ghêpê dmi. ");
INSERT INTO yle_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yepê, Kópuni ngmanmyi d꞉uud꞉uu, yi kópu u l꞉êê dîy꞉o dono wanmyi d꞉uu ngmê, mu dini ghi ngê ndiya anmy꞉uu ghêpê dmi. Yepê, Yi kópu u kwee mwiyé anmyinê châpwo ngmê, yed꞉oo yi dono daanmyi d꞉uu ngmê. Yepê, Dono kópuni pi knî ye mb꞉aamb꞉aa dé, k꞉omo tpile yi p꞉eeni kópu daanmyi d꞉uu t꞉oo, ngmênê yi l꞉êê dîy꞉o ndiya daanmy꞉uu ghêpê dmi. ");
INSERT INTO yle_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesu ngê yepê, Mósisi ngê nmî kn꞉ââ knî ye ala kópu wunê mwo a vyu, yepê, Mââ ngê u kpâm dî kpîpî knomomê, u kópu dyuu dpî d꞉êê ngê, u kwo dpî y꞉ee ngê, u ngwo dpî dy꞉ââ ngê. ");
INSERT INTO yle_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yepê, Mósisi ngê yi kópu ye a vyu, ngmênê ala kópu nmye n꞉aa tpapê, Pyópuni u tumu mââ daadî ya, u moo ngê kîngî kpîpî. Yepê, Yi pyópu u moo ngê módó wa kpîpî knomomê, kn꞉aa pini ngê wa nya knomomê, ye yi pini yi pyópu y꞉oo daa yééyéé u kópu ayi d꞉uu ngmê, pyââ ti mââ ti u kópu ayi d꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesu ngê yepê, Mósisi ngê nmî kn꞉ââ knî ye ala kópu wunê mwo a vyu, yepê, Kópuni u l꞉êê dîy꞉o Chóó Lémi u pi ngê anmyi kpaa, yi kópu ntênê dmyinê d꞉uud꞉uu, u pi ngê módó myekidingê kpaa. ");
INSERT INTO yle_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yepê, Mósisi ngê yi kópu ye a vyu, ngmênê ala kópu nmye n꞉aa tpapê, Dmyinê ndê danê, kpaa ngê kêê nangê t꞉oo. Yepê, Chóó Lémi u pi ngê nangê kp꞉aa, mbóó dyámê yi pi ngê myenangê kp꞉aa. ");
INSERT INTO yle_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yepê, Mbóó u pi ngê nangê kp꞉aa, mu kópu u dîy꞉o doo u ntââ mbóó p꞉uu kópu daangmanmyi d꞉uu ngmê, Chóó Lémi ngê yinê a y꞉enê. Yepê, Dyámê myenté, u pi ngê myenangê kp꞉aa, mu kópu u dîy꞉o doo u ntââ dyámê daanmyi ngmêê ngmê. Yepê, Chóó Lémi ngê yinê l꞉âmo ngê, yinê a y꞉enê. Yepê, Njedusalem u pi ngê myenangê kp꞉aa, mu kópu u dîy꞉o daa nmyi chóó nmyi p꞉aa, king ndêndê ngê yinê a y꞉enê. ");
INSERT INTO yle_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yepê, Nmyi mbodo dmi ngê myenangmê kp꞉aa, mu kópu u dîy꞉o doo u ntââ nmyi chóó nmyi mbodo gh꞉aa dmi daanmyi ngmêê t꞉oo, n꞉ii kpêdêkpêdê dé, mbéédi ngê daanmyi pyódu t꞉oo, n꞉ii mbédimbédi dé, kpêdêkpêdê ngê daanmyi pyódu t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yepê, Dmyinê ndêdanê. Yepê, Kópuni p꞉uu nmye adnyi póó, nyââ knomomê, yipid꞉o, Nyââ. Yepê, Kêle knomomê, yipid꞉o, Kêle. Yepê, Anmyi kpaa knomomê, ye Setan u komo ayinmyi kapî. ");
INSERT INTO yle_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesu ngê yepê, Mósisi ngê nmî kn꞉ââ knî ye ala kópu wunê mwo a vyu, yepê, Pi miyó adpî l꞉êê, ngmê ngê woni ngwolo wa dyênê, ye yini ngwolo u nkwo dpî dyênê yó, myenté ngmê ngê woni nyóó ntémwi wa pwââ, yi pini nyóó yi ntémwi u nkwo dpî pwaa yó. ");
INSERT INTO yle_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yepê, Mósisi ngê yi kópu ye a vyu, ngmênê ala kópu nmye n꞉aa tpapê, N꞉ii knî y꞉oo dono kópu nmye angmê d꞉uu ngmê, ntââ ye nangmê vy꞉u. Yepê, Pini n꞉ii ngê nmyi teknâpwo dê dêê knomomê, wopee u kwo my꞉oo y꞉ee yó, y꞉i myedo dêê ngê. ");
INSERT INTO yle_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Yepê, Pi ngmê ngê u yi adî kwo, Mu pini u kpîdî u l꞉êê dîy꞉o nî kóté kwolo, yi pini ngê u nkuwo kpîdî u kwo myoo y꞉ee ngê. ");
INSERT INTO yle_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yepê, Lóma lede knî y꞉oo nmye dê vyi knomomê, Nmî tpile dnyinê tóó, wu p꞉aani nyinê kuwo nmédi, ye yi p꞉aani dp꞉uu lee dmyeno, u kada p꞉aani dpîmo kuwo tóó. ");
INSERT INTO yle_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yepê, N꞉ii ngê tpileni nmye dê dmy꞉ee knomomê, u kwo dpî y꞉ee yó. Yepê, Nmye wa vyi knomomê, A ngópu mwiyé adîn꞉aa ya, ye u kwo dpî y꞉ee yó, u kwo nangê w꞉ono. ");
INSERT INTO yle_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesu ngê yepê, N꞉ii knî y꞉oo a ndiye kîgha nmyoo, ala kópu a tpapê ngópu, nmyedpo, Nmyi yoo yi nuu ghi dmi nmyi nódo dny꞉oo ya, ngmênê n꞉ii yoo nmyi p꞉uu a d꞉uu nyédi, yi p꞉uu u nkwo dmyinê d꞉uu, nmye myedny꞉oo diya. ");
INSERT INTO yle_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yepê, Yi kópu a tpapê ngópu, ngmênê ala kópu nmye n꞉aa tpapê, Yélini nmyi p꞉uu a d꞉uu nyédi, yi nuu ghi dmi nmyi nódo dny꞉oo ya, n꞉ii knî y꞉oo kópu dono nmyi p꞉uu a d꞉uud꞉uu tumo, yi dîy꞉o mêdmyinê ngêpê. ");
INSERT INTO yle_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yepê, Yinté kópu anmyi d꞉uud꞉uu dé, ye nmyi Mî Chóó Lémi nt꞉anê wanmyi yaa dmi, pini n꞉ii mbóó p꞉uu wunê tóó. Yepê, Yoo d꞉uudpî chámê, yoo mb꞉aa yoo dono yi pwo tpii nipi wunê gh꞉aygh꞉ay ngê, kââdî wunê pil꞉apil꞉a ngê. ");
INSERT INTO yle_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yepê, Yélini yi nódo nmyi nuu ghi dmi a tóó, yi yéli yi mo yi nuu ghi dmi nmyi nódo adî ya knomomê, nmyinê nmye kópu ndîî ayinmyi d꞉uud꞉uu? Yepê, Lukwe, nmyinê nmye Chóó Lémi ngê yi kópu mb꞉aamb꞉aa ngê nmye wa pwila? Yepê, Kêle, Tákisi ngêêpî pyu dono knî y꞉oo yi kópu dpî d꞉uu ngmê. Yepê, Ngmênê pi yintómu yi nuu ghi dmi nmyi nódo choo ya. ");
INSERT INTO yle_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yepê, Kn꞉aa yéli knî ye daanmyi vyuwo knomomê, nmyi yoo knî ye yi mo anmyi vyuwo, ye yi kópu Chóó Lémi ka daa ndîî kópu. Yepê, Mgîdî u yoo knî y꞉oo vyîlo yi kópu ye d꞉uud꞉uu ngópu, yi chóó numo ka a vyuwo nyédi. ");
INSERT INTO yle_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yepê, Ala kópu ndîî dmyinê d꞉uud꞉uu, nmyi Mî Chóó Lémi ntee pini ngê pyaa dmyeno. Yepê, Pi yintómu knî ye ntee wunê vyuwo, pi yintómu knî ye yinté myedmyinê vyuwo. ");
INSERT INTO yle_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu ngê yepê, Ala kópu ny꞉ee yó. Yepê, N꞉ii ngê kópu mb꞉aa yoo yi ngîma dpî d꞉uu, dpo, Pi knî y꞉oo chaa kalê nêne, yi pini ngê k꞉omodanê kópu yu d꞉uu, Chóó Lémi ngê d꞉uudpî chaa kwolo. Yepê, Nmyi chaa kîgha u l꞉êê dîy꞉o yinté kópu nangmê d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yepê, Dini ghi n꞉ii ngê ngópuch꞉anê ngmanmyi yeedeyeede, pi knî yi ngópu yinté kópu nangmê d꞉uu, tumu dpî yeede yó. Yepê, K꞉omodanê pyu yoo yi nt꞉anê nangmê yââ. Yepê, K꞉omodanê pyu yoo tumutumu daa yeede nyédi, ngêpê ngomo k꞉oo a yeede nyédi, naa têdê yoo vy꞉o mye yeede nyédi, u yi y꞉e a kwo yédi, Pi knî y꞉oo m꞉uu nmîne, nmî pi dmi ndîî ngê pyódu téne. Yepê, Pi knî y꞉oo dpî chaa kalê t꞉oo, ngmênê Chóó Lémi ngê d꞉uudpî chaa kalê té, yi yeedeyeede u l꞉êê dîy꞉o kópu mb꞉aa y꞉e daangmêwa a d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yepê, Dini ghi n꞉ii ngê ngópuch꞉anê yoo ngmanmyi ngêêpî, tumutumu dmyinê yeedeyeede dé. Yepê, Nmyi pyipe knî y꞉oo yi tuu kââ pee tp꞉oo kîngmê ny꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yepê, Nmyi Mî u lama tumu kópu yilî yintómu u lama a pyede, yinê wa a chaa kalê nmyo, kópu mb꞉aa yilî nmye u ngwo wa d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesu ngê yepê, Dini ghi n꞉ii ngê nmyimo ngêpê knomomê, k꞉omodanê pyu yoo yi nt꞉anê nangmê yââ. Yepê, Dye ghi yintómu ngêpê ngomo k꞉oo a ghodoghodo nyédi, a ngêpê nyédi, yi ngêpê daadîî ngê dpî pyódu t꞉oo, u yi y꞉e a kwo yédi, Pi knî y꞉oo pîdny꞉oo chaa kîgha nmo. Yepê, Yi chaa kîgha u l꞉êê dîy꞉o kuwa myewumê ngêpê nyédi, yoo vy꞉o. Yepê, Ndê kópu nmye ngmên꞉aa tpapê, pi knî y꞉oo a chaa kîgha tumo, ngmênê Chóó Lémi ngê daawa chaa kalê té. ");
INSERT INTO yle_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yepê, Yi nt꞉anê nangmê yââ. Yepê, Dini ghi n꞉ii ngê nmyimo ngêpê knomomê, nmyi ngomo k꞉oo ngomo k꞉oo dmyinê koko, keńe dmyina a kuwokuwo dé, tumutumu nmyi Mî ka y꞉i dmyinên꞉aa ngêpê. Yepê, Nmyi Mî u lama tumu kópu yilî yintómu a pyede, nmyi ngêpê u l꞉êê dîy꞉o kópu mb꞉aa yilî nmye wa d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yepê, Dini ghi n꞉ii ngê nmyimo ngêpê knomomê, nmyi ngêpê daadîî ngê nangmê pyódu. Yepê, N꞉ii knî y꞉oo yâpwo ndêndê daa chââchââ ngópu, módó kópu yilî a tpapê ngópu, yi kópu yilî daa ng꞉êêntómu dpî vyi t꞉oo, yi ngêpê daadîî ngê u ngwo dpî pyódu t꞉oo, yinê ye yi yâpwo ngê yi ngêpê daadîî dpo ny꞉ee té. ");
INSERT INTO yle_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yepê, Yi yéli yi nt꞉anê nangmê yââ, nmyi ngêpê daadîî ngê nangmê pyódu, mu kópu u dîy꞉o kópuni knî yi l꞉êê dîy꞉o u ntââ mbêmê dp꞉ee pyede, ghêlî k꞉ii u kwo dmy꞉oongê dmy꞉ee tumo, nmyi Mî u lama wunê kîyedê pyede. ");
INSERT INTO yle_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yepê, Ala ngêpê yidmyina a ng꞉êênî, apii Munmîkó M꞉aa, nmî pwo nye tóó. Pi knî y꞉oo ntênê dny꞉oo chââchââ ngi. ");
INSERT INTO yle_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nmî y꞉enê kn꞉ââ lîmî k꞉ii a chépi, ṉgîma yéli y꞉oo ṉuu u kópu ntee wunê d꞉uud꞉uu t꞉oo, dyámê mbêmê tpémi y꞉oo yinté myedny꞉oo d꞉uud꞉uu dé. ");
INSERT INTO yle_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Wonêwodiyédiyé u ntââ ntini nmo cha a kuwo. ");
INSERT INTO yle_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pi knî yi dono kópu ntee nmî kuwó nmî kéé too, nmî dono kópu yinté ṉguwó myoo kéé té, mêdaanyi nuw꞉onuw꞉o dé. ");
INSERT INTO yle_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nmî tókótókó ndîî têdê nangê ńuw꞉o nmo, ngmênê Dono u Kn꞉ââ kwulo dpî dyé nmédi. ");
INSERT INTO yle_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yepê, Dono kópuni pi knî y꞉oo nmye a d꞉uud꞉uu tumo, nmyi kuwó wanmyi kéé t꞉oo, ye nmyi Mî ngê nmyi dono kópu dé u kuwó u nkwo wa kéé té, mêdaawa a ngî té. ");
INSERT INTO yle_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yepê, Ngmênê dono kópuni pi knî y꞉oo nmye a d꞉uud꞉uu tumo, nmyi nuw꞉o ńedê adnyi ya, nmyi kuwó daanmyi kéé t꞉oo, ye kópu n꞉ii dono nmyi d꞉uu tumo, Chóó Lémi ngê mbodo kn꞉ââ vyuwo daawa kéé té, yi l꞉êê dîy꞉o ntââ nmye wa vy꞉u. ");
INSERT INTO yle_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesu ngê yepê, Wéni n꞉ii knî yi k꞉oo dpodombiy꞉e nmye ngêpê nyédi, u l꞉êê dîy꞉o nté nmye kpîpîkpîpî ngópu, yepê, k꞉omodanê pyu yoo yi nt꞉anê nangmê yââ, ch꞉anêch꞉anê u pi ngê kîdmyengê ya. Yepê, K꞉omodanê pyu yoo yi ngîma ndîdî dpî kaalî, mu kópu u dîy꞉o dpo, Yoo yi lama ala kópu paa yaa we, Kî tpóknî y꞉oo nté kêdê kpîpî ngmê, u ngwo paa chaa kalê nmîne. Yepê, Ndê kópu nmye ngmên꞉aa tpapê, pi knî y꞉oo dpî chaa kalê t꞉oo, ngmênê Chóó Lémi ngê d꞉uudpî chaa kalê té. ");
INSERT INTO yle_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yepê, Dini ghi n꞉ii ngê nté nmyimo kpîpîkpîpî knomomê, ndîdî nmyi ngîma kîngî kelekele. Yepê, Nmyi kwódo ng꞉oo dmi dmyina a pyw꞉êmî dé, nmyi mbodo dmyinê dyimêdyimê dé, ");
INSERT INTO yle_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mu kópu u dîy꞉o pi knî y꞉oo daapêdê w꞉ee y꞉e, awo, Kî tpóknî y꞉oo nté dê kpîpî ngmê. Yepê, Nmyi Mî mu ngmidi u lama yi kópu wa yââ. Yepê, Nmyi Mî u lama tumu kópu yilî yintómu a pyede, nmyi ngêpê u l꞉êê dîy꞉o kópu mb꞉aa yilî nmye wa d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Dyámê mbêmê tpile yilî nmyi ngópu kîngmê ya. Yepê, Dyámê mbêmê tpile knî yi p꞉uu nmyi nuw꞉o dmi myekîngê kwo. Yepê, Yi tpile yilî kwétikwéti ngê dpî pyaa dmi, tpile we knî y꞉oo woni dpî ma t꞉oo, kpáápi knî y꞉oo myoo t꞉âmo t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","21","Yepê, Nmyi tpile yilî kwéli a pyede, dye ghi yintómu nmyi nuw꞉o dmi y꞉i adî kwo. Yepê, Nmyi nuw꞉o dmi dyámê mbêmê kîngî kwo, ngmênê mbóó p꞉uu choo kwo. Yepê, Ngópuch꞉anê yoo dmyinê yeedeyeede dé, Chóó Lémi ngê mbóó p꞉uu ya mb꞉aa ngê nmye amîmê wumo. Yepê, Doo u ntââ yi yáni mb꞉aa kpáápi knî y꞉oo daawa t꞉âmo ngmê, tpile we knî y꞉oo myedaawa dyênê ngmê, kwétikwéti ngê myedaawa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yepê, Nmyi ngwolo dmi lam ntee tpile dé. Yepê, Mgîdî vy꞉o lam u wo maa p꞉uu ntee anyi m꞉ii, nmyi ngwolo dmi mye yinté dé. Yepê, N꞉ii ngwolo dê mb꞉aamb꞉aa dê, maa d꞉uudpî kn꞉aadi, ngmênê n꞉ii ngwolo dê dono dê, maa dpî kn꞉aadi. ");
INSERT INTO yle_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yepê, Dyámê mbêmê tpile knî yi p꞉uu nmyi ngwolo dmi adnyi kwo knomomê, ngópuch꞉anê yoo daanmyi yeedeyeede dé, ye Chóó Lémi ka máádi wanmyi kn꞉aadi ngmê, mgîdî vy꞉o anmyin꞉aa kwo. ");
INSERT INTO yle_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yepê, Doo u ntââ pi ngmidi lémi miyó yi p꞉uu daadî dpodo. Yepê, Woni u kwo adî diya, woni u nuu u pi ngê adî ya, woni ka dnyinté adî ng꞉aa, woni u dnye mb꞉aamb꞉aa ngê adî nyêmî. Yepê, Doo u ntââ ndapî Chóó Lémi yi p꞉uu kwodonkwodo daanyi dpodo. Yepê, Chóó Lémi chââchââ ndîî kópu ngê nmye choo ya, ndapî kmênêkmênê têdê kópu ngê nmye choo ya. ");
INSERT INTO yle_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Ala kópu mye ny꞉ee yó. Yepê, Ntini n꞉ii nmye pîpî ngmê, mbwááni n꞉ii nmye ndanî ngmê, nmyi nuw꞉onuw꞉o u kópu ngê kîngî pyaa knî, kpîdîni nmye t꞉emî ngmê, nmyi nuw꞉onuw꞉o u kópu ngê myekîngî pyódu. Yepê, Nté kpîdî daa ndîî kópu dê, nmyi ghê dmi yi ndîî kópu. ");
INSERT INTO yle_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yepê, Ńmê knî yi p꞉uu dmyinê nuw꞉o. Yepê, Nté woo d꞉uudpî kaa ngmê, nté nt꞉u d꞉uudpî t꞉ee ngmê, p꞉o d꞉uuwodê ńuw꞉o ngmê, ngomo k꞉oo d꞉uuwumê yé ngmê. Yepê, Kêle, nmyi Mî ngê yinê dpo mbono té, pini n꞉ii mbóó p꞉uu wunê tóó. Yepê, Dp꞉ee ńmê ntee tpile dé, nmyi Mî ngê mb꞉aamb꞉aa ngê wamyedê mbono nmyo. ");
INSERT INTO yle_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yepê, Dini ghi n꞉ii ngê anmya a pwopwo, k꞉omo tpile nmyi nuw꞉onuw꞉o u kópu ngê adî pyodopyodo, ngmênê doo u ntââ nmyi ya daadîî ngê daanmya a pyépi. ");
INSERT INTO yle_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yepê, Lukwe dîy꞉o kpîdî knî yi p꞉uu nmye nuw꞉o nyédi. Yepê, Yinênê knî yi p꞉uu ngî nuw꞉o mbê dmyeno. Yepê, Yi kpîdî p꞉uu daa dpodo nyédi, myedaa kpile nyédi. ");
INSERT INTO yle_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Yepê, K꞉omo tpile Solomon u ndapî ndîî, u kpîdî mb꞉aa dé, ngmênê yinênê knî y꞉oo Solomon u kpîdî mêdê ch꞉ii tumo. ");
INSERT INTO yle_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yepê, K꞉omo tpile chii mênê yi awêde a kwo, mââ m꞉ii ndê ngê dpî ma, ngmênê Chóó Lémi ngê nênê yi nkwodo dpî kââ, kpile ye yinê wunê yémî. Yepê, Dp꞉ee yi ntee tpile dé, Chóó Lémi ngê mb꞉aamb꞉aa ngê wamye kpîlê nmyo. Yepê, Lukwe dîy꞉o dnyinté u kwo nmye kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yepê, Nté mbwaa kpîdî knî yi pyw꞉êmî nmyi nuw꞉onuw꞉o u kópu ngê kîngî ya. ");
INSERT INTO yle_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yepê, Yélini Chóó Lémi ka daa kêlîmî nyédi, vyîlo yi kópu knî yi p꞉uu yi nuw꞉o dmi a mbêpê té. Yepê, Nmyi Mî u lama ka tóó, yi tpile daadnyi ya knomomê, ye nmyi ya dono ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yepê, Chóó Lémi kóó k꞉oo wowo ndîî kópu ngê nmye choo ya, u nuu u kópu yidmyinê d꞉uud꞉uu dé, ye yi tpile dé nmye u ngwo wa a kê té. ");
INSERT INTO yle_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yepê, Kópuni yi yi dmi mââ m꞉ii nmye adî kwo, awêdewêde ngê yi kópu ngê nmyi nuw꞉o dmi kîngî dyênê. Yepê, Yi wéni knî yi k꞉oo nmyi Mî ngê adî ngêêpî nmyo. Yepê, Lukwe, awêde u nuw꞉onuw꞉o u kópu dé nmyinê nmye doo u ntââ dé? Yepê, Mumdoo u yi nmye a kwo, nmyemo, Mââ m꞉ii yi kópu knî y꞉oo awêde mye dyênê nmîne? Yepê, Yinté nuw꞉o ngê kêê nangê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesu ngê yepê, Pi u pi módó nangmê dyênê, nmyi pi dmi u nkwo daawa dyênê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yepê, Pi u pi dyede ngê ntoo wili wanmyi yé ngmê, Chóó Lémi ngê yintoo wili nmye u nkwo amî yé. Yepê, Yoo lîmîlîmî ngê wanmyi kéé ngmê, ye Chóó Lémi ngê lîmîlîmî ngê u nkwo wa kéé nmyo. ");
INSERT INTO yle_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yi kópu p꞉uu mgongo ye ngmê kwólu, yepê, Kn꞉aa pini ngîma tpile kmono pee ngmadî ya knomomê, lukwe dîy꞉o ndîî kópu ngê nmye wa pyódu? Yepê, Nmyi lama daadî ya tpile kmono pee ndîî nmyi ngîma mye pyede. ");
INSERT INTO yle_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Yepê, Lukwe dîy꞉o yi pini ka wanyi vyi ngmê, Tpile kmono pee ṉgîma nmo wupî. Yepê, Lukwe dîy꞉o nmyi lama daa tóó nmyi chóó nmyi ngîma tpile kmono pee ndîî mye pyede. ");
INSERT INTO yle_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yepê, Nmyo k꞉omodanê pyu yoo. Yepê, Tpile kmono pee ndîî nmyi ngîma mwiyé dpo ngî tóó, u kuwó dini ghi ngê yélî mb꞉aamb꞉aa ngê am꞉ii m꞉uu ngmê, nmyi mbwó ngîma tpile kmono pee u ngwo dpî wêê yó. Yepê, Nmyi chóó nmyi dyââpe mwiyé daanmyi pwaa t꞉oo, ye kn꞉aa yéli yi dyââpe nangê pwaa té. ");
INSERT INTO yle_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yesu ngê yepê, Ala kópu wunê kînmyedî vyi, Yoo lîmîlîmî ngê ghêlî k꞉ii nangê kéé té, ngmênê amê pee ngê nuw꞉o mbêmê a p꞉uu dmyinê dpodo, yoo mwiyé dmyinê myeme dé, a p꞉uu u nkwo ye dmyinên꞉aa danê. Yepê, N꞉ii knî y꞉oo yi ngópu dmi nmye wa kpêmî t꞉oo, a kópu dyuu ye dpî vyi yó, ngmênê n꞉ii knî y꞉oo yi ngópu dmi nmye wa nkoko t꞉oo, a kópu dyuu ye nangê vyi. Yepê, Myenté, n꞉ii knî nmyi p꞉uu adnyi d꞉uu, kópu ye namungê vyi, mu kópu u dîy꞉o wadnyi kpakakpaka nmyo. ");
INSERT INTO yle_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Kópuni u l꞉êê dîy꞉o anmyi ngêpê, yi kópu p꞉uu nmyi Mî ka dyaa dmyinê chedêchedê. Yepê, Kópuni u kwo anmyi dmyinê, nmye wa a kê, kópuni anmyi nmy꞉uu, anmyinê pyw꞉ee ngmê, keńeni p꞉uu anmyin꞉aa depedepe, nmye wa kpêmî. ");
INSERT INTO yle_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yepê, Pini n꞉ii ngê u kwo wa dmyinê, yi pini ka wa y꞉oo, pini n꞉ii ngê adî nmy꞉uu, wa a pyw꞉oo, pini n꞉ii adî depedepe, keńe u kwo wa kpêmî. ");
INSERT INTO yle_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Yepê, Nmyi vy꞉o pini ngmê, tp꞉oo ngê nté pee u kwo wa dmyinê, ye chêêpî u kwo daawa y꞉oo, doo u ntââ daawa ma. ");
INSERT INTO yle_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Yepê, Myenté, tp꞉oo ngê te mbyuu u kwo wa dmyinê, tpile pê u kwo daawa y꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yepê, K꞉omo tpile dono nmyi mênê a tóó, ngmênê nmyi tp꞉ee dmââdîma ye tpile mb꞉aa vy꞉ee yémî tumo. Yepê, Pi ka vyuwo têdê nmyi Mî ngê a t꞉ee kîgha nmyoo. Yepê, Mbóó p꞉uu wunê tóó, dono u mênê daa tóó. Yepê, N꞉ii ngê kópu mb꞉aa dé u kwo wa dmy꞉ee té, daawa dóó, ndêndê ngê u kwo wa a y꞉ee té. ");
INSERT INTO yle_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Kópuni yilî Mósisi ngê a d꞉êê too, Chóó Lémi u komo kapî pyu knî y꞉oo myedê d꞉êê tumo, ala yi nt꞉u kópu, ngî ny꞉ee yó. Yepê, Kópuni u yi nmye adnyi kwo, Pi knî y꞉oo nmo dny꞉oo d꞉uud꞉uu dé, yi kópu y꞉e mwiyé dmyinê d꞉uud꞉uu dé. ");
INSERT INTO yle_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Máádini kwólu puu têdê a pyw꞉ee yó, yi máádi dpî kalê yó, ghê ndêndê u ngwo anmyinê pyw꞉ee ngmê. Yepê, Yi máádi u pyw꞉êmî dpodo ndîî, u kîgha mye dpodo ndîî, pi yilî knî y꞉oo yi máádi daa kîgha ngópu. Yepê, Máádini kwólu puu ndîî, yi máádi p꞉uu pi yilî dpî ghê, u kîgha daa dpodo ndîî, ngmênê u dî ndiya. ");
INSERT INTO yle_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Yélini y꞉oo yi chóó yi nuw꞉o mbêmê Chóó Lémi u komo a kapî ngópu, yi yéli y꞉oo kîngê dóó nmyo. Yepê, Yi too pee mbêmê nmyinê nmye sipi ntee yéli ngê ayidnyin꞉aa ya, ngmênê yi gha dono dé, yi nuw꞉o dmi chii w꞉ââ u nuw꞉o dé. ");
INSERT INTO yle_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","18","Yepê, Kópuni adnyi d꞉uud꞉uu dé, yi kópu knî yi mbêmê u ngwo anmyi mya t꞉oo. Yepê, K꞉omo tpile mb꞉aamb꞉aa ngê nmye adnyi danêmbum, ngmênê yi l꞉êê ghi dono ngê adnyi ya. Yepê, Nté kîgha u mgongo nmye ngmên꞉aa kîgha. Yepê, Chikini n꞉ii nkwodo kîgha nj꞉iinj꞉ii yu kaa dmi, pwópwó yi yini nkwodo d꞉uudpî kaalî, myenté pwópwó n꞉ii nkwodo dpî kaa dmi, kîgha nj꞉iinj꞉ii nkwodo mêd꞉uudpî kaalî. Yepê, Chikini n꞉ii chóó dpî pyidu, ḻama daadî ya, mb꞉aamb꞉aa ó dono, nj꞉iinj꞉ii ó pwópwó. Yepê, Dini ghi n꞉ii ngê dpî dââ, kîgha anyi d꞉uu, u ngwo anyinê w꞉ee, anye, Kî chikini mb꞉aamb꞉aa, kîgha nj꞉iinj꞉ii dé. Yepê, Myenté, L꞉êê yini nkwodo kéme kîgha daanyinê ngee, dpumo nkwodo t꞉aa kîgha myedaanyinê ngee. ");
INSERT INTO yle_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yepê, Yini n꞉ii nkwodo nt꞉u mb꞉aa d꞉uudpî kaa knomomê, anyi kpono, pââ ndiya anyi kéé. ");
INSERT INTO yle_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yepê, K꞉omodanê pyu knî y꞉oo kópuni adnyi d꞉uud꞉uu dé, y꞉e anmyinê w꞉ee t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yepê, Pi yilî knî y꞉oo a ka adnyi tpapê, a ka wo, A Lémi, yepê, ngmênê Chóó Lémi kóó k꞉oo daawa ghê dmi. Yepê, N꞉ii knî y꞉oo M꞉aa u nuu u kópu dé ye d꞉uud꞉uu tumo, vyîlo yi yéli kóó k꞉oo wa ghê dmi. ");
INSERT INTO yle_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yepê, Kuwókuwó wéni ngê pi yilî knî y꞉oo a ka wa vyi ngmê, a ka wo, Nmî Lémi, m̱i mbêmê ṉgópu dyuu pi knî ye kînmee a tpapê, m̱i mbêmê pi knî y꞉e yi kmêna yilî nmî ngm꞉ii kwólu, m̱i mbêmê kópu ndîî yilî my꞉oo d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yepê, Ala kópu u nkwo ye wanî vyi, yenê, A nkîgh꞉ê a y꞉ee dmyeno, a lama dp꞉ee pyede. Yenê, K꞉omo tpile kópu mb꞉aa yilî nmyee a tpapê, ngmênê kópu dono yilî nmyee a d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesu ngê pi knî ye mgongo ngmê kwólu, yepê, N꞉ii ngê a kópu dyuu dpî ny꞉ee té, a d꞉uud꞉uu too, yi pini gha pi, u ngomo nuw꞉o mbêmê ngmêdpî wó, k꞉ââ u mgî mb꞉aamb꞉aa ngê dpo tpênê té, k꞉ââ kn꞉ââ mb꞉aamb꞉aa ngê dpî wiye té, ngomo wêdêwêdê kpetekpete yu wó. ");
INSERT INTO yle_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yepê, K꞉omo tpile ló yópu ndîî ngmêdo pwópu, ngmênê yi ngomo d꞉uudpî tpaa. ");
INSERT INTO yle_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yepê, N꞉ii ngê a kópu dyuu dpî ny꞉oo, daa chââchââ too, yi pini ngê u ngomo daa nuw꞉o mbêmê ngmêdpî wó, k꞉ââ u mgî dnyinté dpî ché té, k꞉ââ kn꞉ââ dnyinté dpî wiye té. ");
INSERT INTO yle_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yepê, Yópu ndîî dini ghi n꞉ii ngê dpo pwópu, u ngomo lîmî k꞉ii dpî tpaa, dpî tpikimbiy꞉e. ");
INSERT INTO yle_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Dini ghi n꞉ii ngê Yesu ngê u danêmbum pi knî ye a kêlî ngê, kópuni ye vyi too, yi nyepênyepê u kópu ngê pyaa dniye, ");
INSERT INTO yle_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","mu kópu u dîy꞉o dêêpî pyu yoo ntee dnyimo dêêpî, daa yinté dpîmo dêêpî. Kópuni Yesu ngê ye dpîmo tpapê dé, daa ndiye pyu ndîî yoo yi pi dmi mbêmê dpîmo tpapê dé, chóó u pi mbêmê dpîmo tpapê dé. Noko yipu, U kópu yilî yintómu ndê kópu dé. ");
INSERT INTO yle_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu p꞉uu mbu mbêmê yedê ghêpê dniye, pi yilî tp꞉oo témi tap knî y꞉oo dnye yâmuyâmu. ");
INSERT INTO yle_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pi ngmê Yesu ka loo, too pee mbii leprîsi u ngwo doo ya, yu mbodo dê y꞉e k꞉ame u kwo ghê wo, u kwo nkêpê mbê wo, kwo, A Lémi. Kwo, U yi ṉga choo kwo knomomê, ye u ntââ kópuni ngê tupwótupwó ngê pyódu noo, wanyi chedê. ");
INSERT INTO yle_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ngê kêê p꞉uu yó, kwo, U ya a nga ka kwo. Kwo, Ṉ́upwó dî chedê. Yi ngwo yi mbii ngê yi pini a kuwo ngê. ");
INSERT INTO yle_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu ngê yi pini ka kwo, Kópuni ṉga dî d꞉uu, pi ngmê ka kidingê vyi. Kwo, Njedusalem dpî lili, kpêê yiyé pyu ngê amî m꞉uu ngi. Kwo, Mósisi ngê kópuni a d꞉êê ngê, yi kópu dp꞉uu d꞉uu ngi, ńmê miyó dp꞉uu ńuw꞉o ngi, kpêê yiyé pyu ka dp꞉uu y꞉ee dé, wamî nk꞉êê dê, kópuni ṉga dî d꞉uu u ngwo pêdê w꞉ee y꞉e. ");
INSERT INTO yle_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dini ghi n꞉ii ngê Yesu p꞉uu Kîpêêniyêm mî taa dniye, Lóma lede yoo yi kada pini ngmê Yesu ka a loo, u kwo nkêpê mbê wo, ");
INSERT INTO yle_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kwo, A lémi. Kwo, A dpodo pyu a p꞉aa pee ngmêkîyedê mbii, daa kêmakêma a pwopwo, u dînê daa ghîdî. ");
INSERT INTO yle_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu u kwo póó wo, kwo, Mumdoo ṉgomo k꞉oo anê lê, ṉmodo pyu an꞉uu pyi? ");
INSERT INTO yle_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yi pini ngê kwo, D꞉aa u ntââ. Kwo, doo u ntââ a ngomo k꞉oo daanyinê nî. Kwo, Ngmênê kópu yi vyi, a dpodo pyu u ngwo wumê pyiyépyiyé. ");
INSERT INTO yle_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwo, Kópuni nye tpapê, ndêndê ngê a pyodopyodo. Kwo, Kópuni a kada pini ngê a ka dpo vyi, dpî d꞉uu. Kwo, Kópuni a lede knî ye dpî vyi, dpî d꞉uu ngmê. Kwo, Kópuni a dpodo pyu ka dpî vyi, ntênê dpî d꞉uu. Kwo, A dpodo pyu u l꞉êê dîy꞉o pyiyépyiyé u pi vyi ngi, yed꞉oo u ngwo wumê pyiyépyiyé. ");
INSERT INTO yle_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dini ghi n꞉ii ngê Yesu ngê yi kópu dyuu yi nyongo, u nyepênyepê u kópu ngê u kwo pyaa dniye. Pini n꞉ii knî y꞉oo dnye yâmuyâmu, ye diyé wo, yepê, Yisîléli tpémi yi vy꞉o kîntoo kêlîmî pyu d꞉oongmê módu. ");
INSERT INTO yle_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yepê, Ndê kópu nmye ngmên꞉aa tpapê, kn꞉aa dyámê kn꞉aa dyámê tpémi Chóó Lémi kóó k꞉oo wa ghê dmi, Epîlaham mupwo káámi yi k꞉ii nipi adnyin꞉aa yakmaapî, ");
INSERT INTO yle_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ngmênê yélini yi kn꞉ââ Epîlaham, Chóó Lémi kóó k꞉oo p꞉ee paan꞉aa ghê dmi, ngmênê Chóó Lémi ngê yi yéli kuwa wa kéé té, mgîdî vy꞉o adnyin꞉aa kwo, yi ngwo tpéé kópu amî vyi ngmê, adnyin꞉aa mbê, yi kpéngi ti dmi kelekele adnyin꞉aa paa. ");
INSERT INTO yle_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Wod꞉oo Yesu ngê Lóma lede yoo yi kada pini ka kwo, Ṉgomo k꞉oo mê dini. Kwo, Ṉgêlîmî u l꞉êê dîy꞉o, kópuni u mdoo a ka cha ńuw꞉o, yi kópu n꞉aa d꞉uud꞉uu. Yi kópu yi vyu, yi ngwo yi dpodo pyu u mbii chedê ngê mê pyodo. ");
INSERT INTO yle_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu Pita u p꞉aa pee loo, u ngomo k꞉oo yi kee wo. Pita u mbywé pyââ mbii têdê módu, apê, Ngmîtédmino mu dpî. ");
INSERT INTO yle_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ngê kóó p꞉uu kêê yi yó, wod꞉oo yi mbii ngê a kuwo ngê, yi pyópu mê ghêêdî wo, Yesu ka nté mê y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dini ghi n꞉ii ngê ntumokwodo dini ghi yi yó, pi knî y꞉oo Yesu ka mbii pyu yilî ńuw꞉o ngópu, n꞉ii dé y꞉e yi kmêna dnye kwo, u kwo mye ńuw꞉o tumo. Yesu yi kmêna knî ye mbwolo, u ngwo ngm꞉ii kalê too, mbii pyu yintómu mye pyi too. ");
INSERT INTO yle_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kópuni Yisaya ngê wunê a d꞉êê ngê, Yesu ngê u ngwo ntiye ngê. Yi kópu ala. Chóóchóó nmî mbii yilî amî chedê té. ");
INSERT INTO yle_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Dini ghi n꞉ii ngê Yesu ngê yoo yi módu, apê, Yilî ngê a ka até dê pyódu, p꞉uu ndiye pyu knî ye yepê, Dinki k꞉oo wo dmyeno, kpé lêê mwada pee lee kmêle. ");
INSERT INTO yle_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kada ghêlî dêpangê y꞉ee ngópu, dêêpî pyu ngmê u kwo até yi loo, kwo, Mââwe. Kwo, Kwéli wanyi lê, ana a yâmuyâmu ngi. ");
INSERT INTO yle_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu ngê kwo, Mumdoo anya a yâmuyâmu nê? Kwo, Chii w꞉ââ w꞉uu yi dpî têdê dmi a pyede, y꞉i a dpî nyédi, ńmê knî yi ny꞉uu a pyede, y꞉i a dpî nyédi, ngmênê a ngomo daa kwo, a dpî têdê daa tóó, a ghê vyîmî têdê myedaa tóó. Kwo, Mumdoo nyi u ntââ, anya a yâmuyâmu nê? ");
INSERT INTO yle_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pi m꞉uu, Yesu p꞉uu ndiye pyu ngmê, Yesu ka kwo, M꞉aa a ngópu mwiyé paa pw꞉oo we, an꞉uu kmênê, u ngwo ana a yâmuyâmu ngi. ");
INSERT INTO yle_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu ngê mgongo u kwo ngmê kwólu, kwo, N꞉ii yi ghê daa pyede, yinté kópu p꞉uu dny꞉oo nuw꞉o.");
INSERT INTO yle_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu, p꞉uu ndiye pyu knî yi k꞉ii, dinki k꞉oo yi wo dniye, kada yedê y꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yópu ndîî ngma a pwaa wo, vyuwó dinki k꞉oo dnyen꞉aa kn꞉êê, daa kêmakêma dinki pî vy꞉êê wo, ngmênê Yesu doo dpî. ");
INSERT INTO yle_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","P꞉uu ndiye pyu knî y꞉oo u dpî ny꞉ââ ngópu, kwo, Nmî Lémi, ngee nmédi. Kwo, Awêde nmo pwopwo té. ");
INSERT INTO yle_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu yedê pii wo, yepê, Lukwe dîy꞉o nmye nkîngê té. Yepê, Nmyi kêlîmî lukwe ngê têdê ngê dê pyódu. Wod꞉oo ghêêmî ghê wo, vyuwó yópu ye yepê, Munto. Yi ngwo vyuwó yópu chedê ngê pyaa knopwo, dye ndîî mê kââ. ");
INSERT INTO yle_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","P꞉uu ndiye pyu yoo ngwéti dniye, noko yepê, Kî lónté pini, vyuwó yópu y꞉oo u dnye kêdê ny꞉ee ngmê, kîmyaa châpu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","U kuwó dini ghi ngê Yesu p꞉uu Nkálili Kpéni Lêê mwada pee yimî tee dniye, Nkedîsa tpémi kwéli dnya a ya. Pi miyó dê y꞉oo maadî a pyódu tumo. Yi tpódu y꞉e yi kmêna dnye kwo, kpomo u mênê pi ntóó kwéli dnyimo yiyé dé, y꞉i a ndê knopwo. L꞉êê pyu ndîî ngê dpîmo ya, pi knî y꞉oo yi máádi dêdnyimo kîgha, apu, Angmê vya nmo. ");
INSERT INTO yle_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Dini ghi n꞉ii ngê Yesu m꞉uu ngópu, wod꞉oo dpodombiy꞉e u kwo mbwóó knopwo, kwo, Yâpwo ndîî tp꞉oo. Kwo, Lukwe nye ngmanyi md꞉o? Kwo, Nangê kpada nyo. Kwo, Kpadakpada u wo doongê dyimê wo. ");
INSERT INTO yle_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mbwêmê w꞉uu ndîî yi nkîgh꞉ê ngmêdoo kwo, y꞉i dnye kmaapî. ");
INSERT INTO yle_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yi kmêna yoo Yesu ka nkêpê mbê dniye, kwo, Nye ngm꞉ii kîgha nmo, ye u ntââ kî mbwêmê w꞉uu vy꞉o wanyi dy꞉ââ nmo. ");
INSERT INTO yle_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu ngê yepê, Dmyinê lêpî. Wod꞉oo yi kmêna knî y꞉oo yi pini dê a kuwo dumo, mbwêmê knî yi p꞉uu mî kaa dniye. Yi mbwêmê w꞉uu yintómu paa ghi p꞉uu ghîpîla dniye, kpé lêê u kwo mî dyimê dniye, wod꞉oo vy꞉êê dniye. ");
INSERT INTO yle_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pini n꞉ii yoo mbwêmê w꞉uu ka dnye vyuwo, yi yéli mye mbêpê dniye, yi p꞉o lee dniye, pi knî ye mdoo ńuw꞉o ngópu, kópuni yi pini dê y꞉e pyodo, pi knî ye myemînê nté tumo. ");
INSERT INTO yle_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wod꞉oo yi p꞉aani tpémi yintómu Yesu ka lee dniye. Dini ghi n꞉ii ngê m꞉uu ngópu, u kwo nkêpê mbê dniye, kwo, U ntââ ala wee anyinê kuwo. ");
INSERT INTO yle_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu p꞉uu dinki k꞉oo mê wo dniye, kpé lêê mê ngmêê ngópu, yi p꞉o Kîpêêniyêm mîmê tee dniye, ");
INSERT INTO yle_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","u knêyómu ya pyu y꞉i u kwo ngmê ńuw꞉o ngópu, u ngmîtédmi mbêmê doo dpî. Dini ghi n꞉ii ngê Yesu ngê m꞉uu too, a w꞉ee ngê, apê, N꞉ii knî y꞉oo kî pini a ka da ńuw꞉o ngmê, ndêndê ngê a ka wunê kêlîmî té. Yesu ngê yi pini ka kwo, A tp꞉ee, mêdaanyi ch꞉anêch꞉anê, ṉono yilî yintómu dî chedê, Chóó Lémi ngê mêdaawa kpada ngi. ");
INSERT INTO yle_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dêêpî pyu n꞉ii yoo y꞉i doo kwo, noko yepê, Kî pini ngmênê u kwo n꞉uu, u yi u ngwo a kwo, Chóó Lémi u d꞉aa nê kââdî. ");
INSERT INTO yle_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kópuni tumu dnye nuw꞉onuw꞉o dé, Yesu ngê a w꞉ee too, yepê, Lukwe dîy꞉o yenté nmye nuw꞉o dono té? ");
INSERT INTO yle_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Yepê, Nê Chóó Lémi u Pi Ndêndê, u ntââ ngê yinê a pyódu noo, u ntââ dyámê mbêmê pi ka wanî vyi, Ṉono yilî dî chedê, Chóó Lémi ngê ṉono yilî u kuwó dê kéé té, mêdaawa a ngî té. Yepê, K꞉omo tpile a kópu ka módó daanmyi kêlîmî mbê dmi, ngmênê kópuni kî kpâlî ntóó ngê n꞉aa d꞉uud꞉uu, a kópu ka u ngwo nmye kêlîmî té. Wod꞉oo Yesu ngê yi kpâlî ntóó ka kwo, Gh꞉êêdé, ṉgmîtédmi a ngini, p꞉o lili. ");
INSERT INTO yle_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wod꞉oo yi pini a pii wo, u p꞉o loo. ");
INSERT INTO yle_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pi knî y꞉oo yi m꞉uu ngópu, nkîngê mbê dniye, Chóó Lémi chaa kalê ngópu. Yinê ye Yesu pi ntee pini, ngmênê Chóó Lémi u pi mbêmê mbwudu ndîî ngmêdê chaa. ");
INSERT INTO yle_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu p꞉uu maa p꞉uu até yidnye lêpî, mwada y꞉i tákisi ngêêpî pyu ngmê m꞉uu ngópu, u pi Mátiyu. Yi pini ndapî ngêêpî ngomo ghi k꞉oo doo ya. Yesu ngê kwo, A ngm꞉êê nédi. Wod꞉oo ghêêdî wo, Yesu u kuwó ghê wo. ");
INSERT INTO yle_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","U kuwó dini ghi ngê u ngomo k꞉oo kee dniye, Yesu, p꞉uu ndiye pyu yoo, tákisi ngêêpî pyu yoo, kn꞉aadi te pyu yoo mye yi k꞉ii. Yi ngomo k꞉oo nipi dnye kmaapî. ");
INSERT INTO yle_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pádisi yoo daa yi nuu u kópu ngê pyodo, Yesu p꞉uu ndiye pyu knî ye yepê, Lukwe dîy꞉o nmyi kada pini tákisi ngêêpî pyu yoo kn꞉aadi te pyu yoo yi k꞉ii a kmaapî té. ");
INSERT INTO yle_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ngê yi kópu yi nyongo, yepê, N꞉ii mb꞉aamb꞉aa dé, yi yéli ye kpeede d꞉uudpî nî. Yepê, Kpeede mbii pyu knî ye dpî lê. ");
INSERT INTO yle_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yepê, Chóó Lémi ngê wunê kópuni a vyu, u nt꞉u kópu dmyinên꞉aa a pyw꞉êmî. Yepê, Ala kópu a vyu, Tpile tp꞉oo nk꞉êênî a ka daa ndîî kópu, pi ka vyuwo yi ndîî kópu. Yesu ngê yepê, Yélini yinê ye, Nmo mb꞉aamb꞉aa dé, daa yi yéli yi dîy꞉o al꞉ii nê loo, yepê, ngmênê kn꞉aadi te pyu yoo yi dîy꞉o nê loo. ");
INSERT INTO yle_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yi dini ghi ngê Njon Baptist p꞉uu ndiye pyu knî ngmê Yesu ka lee dniye, kwo, Wiki yintómu wo miyó knî yi k꞉oo nté nmo kpîpîkpîpî ngê, Chóó Lémi ka dpodombiy꞉e u ngwo nmo ngêpê nyédi. Kwo, Pádisi knî y꞉oo yinté mye d꞉uud꞉uu ngópu. Kwo, Lukwe dîy꞉o m̱꞉uu ndiye pyu knî y꞉oo nté d꞉uudpî kpîpî ngmê, dye ghi yintómu a kmaapî nyédi? ");
INSERT INTO yle_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu ngê yepê, Wéni n꞉ii ngê pi cha dpî yéé knî, pi ngê nté pi ka d꞉uudpî kwódu. Yepê, A p꞉uu ndiye pyu yoo yi k꞉ii nmî gha dmi mb꞉aamb꞉aa ngê a pyede, doo u ntââ nté ye daanî kwódu. Yepê, Wéni n꞉ii ngê pi dpî pw꞉onu, u yoo yi gha dmi dono ngê dpî pyódu, dye ghi knî ngmê ngê nté dpî kpîpî ngmê. Yepê, Dini ghi n꞉ii ngê a p꞉uu ndiye pyu yoo yi vy꞉o mêdaanî kwo, yi ngwo yi gha dmi yinté dono ngê wa pyódu. Yepê, Yi wéni ngê yi chóó nté wa kpîpî ngmê. ");
INSERT INTO yle_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yepê, Kópu kamî ngma atéd꞉a ńuw꞉o, nmyi l꞉êê ghi mbwee dmi daa kópu kamî yi pee dé. Mgongo ye ngmê kwólu, yepê, N꞉ii u kpîdî mbwee dpo chópu, doo u ntââ kpîdî pee kamî daawa pwila, kpîdî mbwee p꞉uu daawa t꞉oo. Yepê, Dini ghi n꞉ii ngê ayi ghodo, kpîdî pee kamî dêêkwédi ngê wa a pyódu, kpîdî mbwee d꞉ud꞉umbiy꞉e wa a chópu. Yepê, Kpîdî pee kamî, kpîdî pee mbwee daa numo yi pee dê, myenté l꞉êê ghi mbwee a kópu kamî daa numo yi pee dê. ");
INSERT INTO yle_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yepê, Wain kamî nmye ngmêd꞉a ńuw꞉o, doo u ntââ u yiyé têdê mbwee knî yi k꞉oo daanî yé, wa dyênê té, mbwódo amî d꞉ii. Yepê, U ntââ kamîni knî yi k꞉oo n꞉aa yiyé, daawa dyênê té. Yepê, Nmyi l꞉êê ghi mbwee dmi yi dye ghi machedê. Yepê, Nté kpîpîkpîpî mêdaa ndîî kópu. Yepê, Yi kópu u l꞉êê dîy꞉o a p꞉uu ndiye pyu knî ye nté daanî kwódu. ");
INSERT INTO yle_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dini ghi n꞉ii ngê Yesu pi knî ye doo danêmbum, kada pini ngmê u kwo loo, yu mbodo dê y꞉e k꞉ame u kwo ghê wo, kwo, A tp꞉ee módó ala ngwo kêdê pw꞉onu. Kwo, U ntââ wanyinê lê, ṉgêê dê u pwo any꞉uu yé dê, yed꞉oo ghê mê kelekele. ");
INSERT INTO yle_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Wod꞉oo Yesu ghêêdî wo, p꞉uu ndiye pyu knî yi k꞉ii yi pini u kuwó ghê dniye. ");
INSERT INTO yle_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kada yedê y꞉ee ngópu, maa p꞉uu pyââ ngmê yi p꞉uu kele, doo yâmuyâmu dé. Yi pyópu kmene muwó, dye ghi yintómu yinté dpîmo ya, m꞉ââ y꞉a mê miyó ndîî, wêê p꞉uu dêpê vyâ. Alanté doo nuw꞉o, apê, Pi yilî yi l꞉êê dîy꞉o doo u ntââ ngê a ka dê pyódu, Yesu u kada daan꞉uu ghê knomomê, ye daawa pyi nê. Apê, Ngmênê u nkîgh꞉ê nîmo wowo, u kpîdî p꞉uu kêê n꞉aa yiyé, yed꞉oo u ngwo n꞉aa pyiyépyiyé. Wod꞉oo Yesu u kuwó chono mî ghê wo, u kpîdî kwódo p꞉uu kêê yó. ");
INSERT INTO yle_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Wod꞉oo Yesu u kwo diyé wo, yi módu, kwo, A ch꞉am. Kwo, Ṉga mb꞉aamb꞉aa ngê mê pyaa we. Kwo, A ka che kêlîmî mb꞉anê, u ngwo chi pyiyé. Wod꞉oo yi pyópu yi ngwo mê pyiyé wo. ");
INSERT INTO yle_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Dini ghi n꞉ii ngê kada pini u p꞉aa pee taa dniye, Yesu ngê apê, Yoo mu mbê té, yi dmââdî u l꞉êê dîy꞉o nkéli mbywuu pââ mu wupî t꞉oo, wod꞉oo Yesu yi ngomo k꞉oo kee wo, mgongo ye ngmê kwólu, yepê, Munto mbê. ");
INSERT INTO yle_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yepê, Ye dmââdî doo pwene, ngmênê a dpî. Yepê, Kuwa pwii dmyeno. Yesu dnye yumuyumu, ngmênê kuwa pw꞉ii too. ");
INSERT INTO yle_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yi dmââdî u ngomo ghi k꞉oo mî kee wo, kwulo kele, mêdê pyidu ngê. ");
INSERT INTO yle_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yi wee u kwo p꞉aani p꞉aani pi yintómu knî yi nuwo yi kópu yaa wo. ");
INSERT INTO yle_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dini ghi n꞉ii ngê Yesu ngê yi p꞉aani pee yedê kuwo ngê, pi miyó u kuwó ghê wo. Yi pini dê yi ngwolo páádi knî kopwe dé. Yesu dpîmo yâmuyâmu, u kwo dpîmo a kââ, kópu, N꞉ii Chóó Lémi ngê a ngmidi ngê, Dépidi ntee pini, u ntââ ṉga wanyi ch꞉anê knî? ");
INSERT INTO yle_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dini ghi n꞉ii ngê Yesu ngomo k꞉oo mî kee wo, yi ngwolo kopwe dê y꞉i myemî kee knopwo. Yesu ye póó wo, yepê, Mumdoo dpî kêlîmî mbêmê, dpînê dpo nê u ntââ, n꞉aa pyipyi dp꞉o? Kwo, Nyââ, nmî Lémi. ");
INSERT INTO yle_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wod꞉oo Yesu ngê yi ngwolo páádi knî yi p꞉uu kêê yó, yepê, Kópuni ka dpo kêlîmî mo, yi kópu pyaa we, ");
INSERT INTO yle_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","wod꞉oo yi ngwo yélî mê m꞉uu ngópu. Yesu ngê yepê, Kópuni dpo dî d꞉uu, pi knî yi ngêêdî nangên꞉aa nt꞉o. Yi kópu dnyinté ye daa kwódu ngê, ");
INSERT INTO yle_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ngmênê u dnye daa ny꞉ee ngópu, p꞉aani p꞉aani lee knopwo, pi knî ye yuu mînê y꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Dini ghi n꞉ii ngê Yesu p꞉uu kuwa pwii dniye, pi knî y꞉oo pi ngmê u kwo ńuw꞉o ngópu, u kmêna u ngwo ngmêdoo kwo. Yi kmêna ngê yi pini u dnye l꞉âmo wunê a ngópu. ");
INSERT INTO yle_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dini ghi n꞉ii ngê Yesu ngê yi pini ngê u kmêna ngm꞉ii kwólu, wod꞉oo yi pini modoo danêmbum. Yélini yilî yi ngópu yi kópu pyodo, ghê yi mênê ghipé wo, yi nyepênyepê u kópu ngê mye pyodo, noko yepê, Yisîléli Wee u kwo kînté kópu pi doongmê módu.");
INSERT INTO yle_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngmênê Pádisi knî y꞉oo noko yepê, Setan ntee pini nmye yila, n꞉ii kmêna knî yi kada pini. Noko yepê, Setan u wêdêwêdê mbêmê kmêna yoo yinê a ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu p꞉uu p꞉aani p꞉aani lee dniye, yoo yi ngêpê ngomo knî yi k꞉oo dnyimon꞉aa koko. Yesu y꞉i ye dpîmon꞉aa dêêpî, yipu, Chóó Lémi ngê chóó u yoo yi y꞉enê kn꞉ââ daa kêmakêma a chapî. Pwopwokopwe yilî mye pyi ngê. Mbii dyêêdî daa ngmidi yi p꞉uu doo ya, ngmênê Yesu ngê pyi too. ");
INSERT INTO yle_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Dini ghi n꞉ii ngê yoo ndîî módu, u kwo ch꞉anê dniye, mu kópu u dîy꞉o apê, Na a ka sipi w꞉uu n꞉ii yi y꞉eey꞉ee pyu daa tóó, pi ye daa vyuwo. Apê, Chii w꞉ââ knî ye a nkîngê té, yi ngêêpî pyu daa tóó. ");
INSERT INTO yle_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wod꞉oo p꞉uu ndiye pyu knî ye yepê, Chóó Lémi u yâpwo têdê nté al꞉ii daa ghêdê, ngmênê nté mgîpî pyu mdoo daa tóó. ");
INSERT INTO yle_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yepê, Yâpwo têdê chóó ka dmyinê ngêpê, nté mgîpî u l꞉êê dîy꞉o pi knî nmye mupêdê kê ngê. ");
INSERT INTO yle_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ngê p꞉uu ndiye pyu y꞉a mê miyó nipi a danê ngê, yepê, A pi ngê n꞉aa dyede nmyo, u ntââ ngê myinê pyépi nmyo, n꞉ii knî y꞉e yi kmêna a wee, yi kmêna anmyin꞉aa ngm꞉ii kîgha dé, n꞉ii knî y꞉e mbii dyêêdî daa ngmidi a t꞉a, anmyin꞉aa pyipyi dé. ");
INSERT INTO yle_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yesu u dyépi y꞉a mê miyó yi pi dmi ala, Saimon ngmê, pini n꞉ii u pi mye Pita. Saimon u mbwó Andru myomo, Njems mbwémi Njon pyolo podo, Sepédi tp꞉oo dê. ");
INSERT INTO yle_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipi Mbatolomyu limo wono, Tomas pii, Mátiyu wolo, pini n꞉ii dpîmo a tákisi ngêêpî. Njems tówo, Alîpayas tp꞉oo, Tádiyas yono. ");
INSERT INTO yle_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon mê ngmê, pini n꞉ii yoo woni knî yi k꞉ii u yi y꞉e doo kwo, Lóma lede yoo nmî ngm꞉ii kalê té, mu kópu u dîy꞉o u yi y꞉e dêpwo kwo, Lóma tpémi y꞉oo dny꞉oo y꞉enê nmo. Njudas Kédiyót pi mê myomo, pini n꞉ii Yesu u kwódo ngê ghê wo. ");
INSERT INTO yle_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dini ghi n꞉ii ngê Yesu ngê u dyépi y꞉a mê miyó p꞉aani p꞉aani doo dyede dé, yi dpodo u dy꞉oo ye mwiyé a châpwo, yepê, Samédiya tpémi yi p꞉o p꞉o nangmê lê, kn꞉aa yéli ye myenangmê lê, ");
INSERT INTO yle_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ngmênê Yisîléli tpémi ye p꞉aani p꞉aani dpî lee dmyeno. Yepê, Sipi w꞉uu woni knî y꞉oo yi y꞉enê pyu ntee dpo kuwo ngmê, u dnye daa nyêmî ngópu, kn꞉aa kn꞉aa dpî lee dmi, Yisîléli tpémi mye yinté dé, yi kada pini ndêndê kêdê kuwo ngmê. Yepê, Yi yéli ye dmyinê lêpî. ");
INSERT INTO yle_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yepê, Ye dmyinên꞉aa dêêpî, yipi, Dini ghi n꞉ii nmo t꞉âât꞉ââ, Chóó Lémi ngê chóó u ngwo ada a y꞉enê nmo, yi dini ghi daa kêmakêma a dyimêdyimê. ");
INSERT INTO yle_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yepê, Mbii pyu dpî pyi tóó, pini n꞉ii dê pw꞉oo knomomê, ghó moo t꞉ee yó, yélini yi p꞉uu too pee mbii leprîsi a t꞉a, dpî pyi tóó, n꞉ii knî y꞉e yi kmêna a wee, yi kmêna dpî ngm꞉ii kalê tóó. Yepê, Wêdêwêdêni nmye d꞉a kê, yi wêdêwêdê a ka dmy꞉oo pwila ngópu. Yepê, Kópuni anmyin꞉aa d꞉uud꞉uu dé, pi knî y꞉oo nmye kîngîn꞉aa pwila t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yepê, Nmyi tpile nangmê ńuw꞉o, ndapî myenangmê ńuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yepê, Nmyi péé nangmê ńuw꞉o, nmyi kiyé nangmê ńuw꞉o, nmyi nkuwo kpîdî myomoni nangmê ńuw꞉o, nmyi yi dópo dmi myomoni myenangmê ńuw꞉o. Yepê, Nté ndapî yi p꞉uu nuw꞉o ngê kêê nangê t꞉oo. Yepê, Yélini anmyin꞉aa ngêêpî dé, u nkwo adnyin꞉aa mbonombono nmyo, nmye adnyin꞉aa vyuwo. Yepê, Pi módó daa dpodo yédi, u dpodo u pywuu dpo ngee. ");
INSERT INTO yle_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yepê, P꞉aani p꞉aani pi miyó miyó dpî lee we. Yepê, P꞉aani n꞉ii pini n꞉ii dê d꞉uu taa knomomê, gha pi y꞉i ngmêdo pyw꞉ee y꞉e, p꞉uu dny꞉oo ya, u dî yi p꞉aani mîdny꞉oo a kuwokuwo. ");
INSERT INTO yle_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pini n꞉ii dê n꞉ii u ngomo k꞉oo dpîmo koko knomomê, yi ngomo chóó ka ala kópu dny꞉oo tpapê, Mw꞉ââkó, Chóó Lémi ngê ṉyoo knî yi k꞉ii a ngee nmyine. ");
INSERT INTO yle_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yepê, Yi ngomo chóó ngê yi pini dê yi wépi dê adî pwapî dê, ye kópuni mwiyé u kwo adpî tpapê, yi kópu ye modo diyé we. Yepê, Yi ngomo chóó ngê u yi adî kwo, Chóó Lémi ngê a ngee nmîne, ye wa ngee té. ");
INSERT INTO yle_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yepê, Pini n꞉ii dê p꞉aani n꞉ii adpîn꞉aa taataa, n꞉ii mupwoknî ye amyedpîn꞉aa taataa, yi yéli y꞉oo yi yi dê y꞉e daachoo kwo knomomê, yepê, yi dnye dê daachoo nyêmî knomomê, ye yi pini dê y꞉oo yi yéli dny꞉oo a kuwokuwo, yi p꞉aani u têpê yi yi yodo p꞉uu dny꞉oo vyavya. Yepê, Yi yéli y꞉oo ala kópu u ngwo wa a w꞉ee ngmê, awo, Yinê ye dp꞉oo Nju tpémi, dp꞉oo Chóó Lémi u yoo. ");
INSERT INTO yle_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yepê, Ndê kópu nmye ngmên꞉aa tpapê, Wéni n꞉ii ngê Chóó Lémi ngê Sodom p꞉aani dê Kîmoda a pw꞉oo doo, dnyinté a kpada too. Yepê, P꞉aani n꞉ii tpémi y꞉oo adnya a mb꞉iimb꞉ii nmyo, kuwókuwó wéni ngê Chóó Lémi ngê dnyinté daawa kpada té. ");
INSERT INTO yle_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesu ngê u dyépi knî ye yepê, Dpodo têdê n꞉aa dyede nmyo. Yepê, Y꞉ee tîmêlyu yi vy꞉o kêmkêm tp꞉oo w꞉uu ntee tpile ngê anmyi pyaa dmi. Yepê, Nuw꞉o mbêmê dmyinên꞉aa dpodo, yoo mb꞉aa ngê dmyinên꞉aa kwo. Yepê, Pi knî y꞉oo nmyi kpadakpada u nt꞉u kópu nmyi p꞉uu kîdangmê pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yepê, Mb꞉aamb꞉aa ngê nmye dmyina a vyuwo. Yepê, Dye ghi knî ngmê ngê pi dono knî y꞉oo u yi y꞉e adî kwo, Nê u yoo nmî chedê. Yepê, Yi ngwo dono a l꞉êê dîy꞉o nmye adnyin꞉aa d꞉uud꞉uu. Yepê, Ngêpê ngomo knî yi y꞉enê pyu knî y꞉oo adnyin꞉aa mgîmîmgîmî nmyo, adnyin꞉aa kóté kîgha nmyo, u nkwo adnyin꞉aa kpakakpaka nmyo. ");
INSERT INTO yle_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yepê, A l꞉êê dîy꞉o king knî y꞉oo, kada pini knî y꞉oo amyidnyin꞉aa kóté kîgha nmyo. Yepê, A p꞉uu ye anmyin꞉aa danê, yélini daa Nju tpémi, a p꞉uu ye amyenmyin꞉aa danê. ");
INSERT INTO yle_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yepê, Dini ghi n꞉ii ngê adnyin꞉aa mgîmîmgîmî nmyo, kópuni ye anmyin꞉aa tpapê dé, yi p꞉uu nuw꞉o ngê kêê nangê t꞉oo. Yepê, Dini ghi n꞉ii ngê adnyin꞉aa kóté kîgha nmyo, kópuni ye anmyin꞉aa tpapê dé, yi ngwo anmyin꞉aa a pyw꞉êmî dé. ");
INSERT INTO yle_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yepê, Daa nmyi chóó nmyi kópu ayinmyin꞉aa tpapê dé, ngmênê nmyi Mî u Ghê Dmi u komo ayinmyin꞉aa kapî. ");
INSERT INTO yle_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Yepê, Dini ghi n꞉ii ngê a yoo adnyi vyee dé, pi knî y꞉oo yi chóó yi mbwó yoo wa ch꞉ee t꞉oo, mââ knî y꞉oo yinté yi tp꞉ee yoo amye ch꞉ee t꞉oo, pi knî y꞉oo yinté yi chóó yi pye mî yoo amye ch꞉ee t꞉oo, kada pini knî y꞉oo wamye vya t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yepê, A l꞉êê dîy꞉o pi yintómu knî ye wanmy꞉uu diya dmi, ngmênê yi dono vyîmî têdê daanmyinê mb꞉ii nê, ye mu dini ghi ngê wanî ngee nmyo, a kêê k꞉oo anmy꞉uu ghê dmi. ");
INSERT INTO yle_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yepê, P꞉aani n꞉ii adnyi vyee nmyo, yi p꞉aani dmyina a kuwokuwo, kn꞉aa p꞉aani mêdmyinê mbêpêmbêpê. Yepê, Ndê kópu nmye ngmên꞉aa tpapê, Yisîléli tpémi yi vy꞉o p꞉aani p꞉aani nmyi dpodo ghêlî k꞉ii daanmyinê kêlî ngmê, u ngwo nmye amênê diyé. ");
INSERT INTO yle_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yepê, Ndiye pyu u pi ndîî, yélini p꞉uu a ndiye nyédi, yi pi dmi têdê, myenté kada pini u pi ndîî, u dpodo pyu yoo yi pi dmi têdê. ");
INSERT INTO yle_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yepê, N꞉ii yoo yi kada pini u nt꞉anê dpî yaa dmi, yi yéli yi gha dmi mb꞉aamb꞉aa ngê dny꞉oo ya. Yepê, Setan u pi a pyimo t꞉ee ngópu, nmyi pi dmi dnyinté daawa dyênê ngmê. ");
INSERT INTO yle_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesu ngê yepê, Pi knî ye nkîngê ngê kêê nangên꞉aa t꞉oo. Yepê, Ala ndêndê kópu nmyi lama ka tóó, tumu kópu yintómu dîyo wa a pywálî dmi, ngmee u kópu dyuu wamyedo pywálî dmi. ");
INSERT INTO yle_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yepê, Yi kópu u l꞉êê dîy꞉o tumu kópuni mgîdî vy꞉o nmye n꞉aa tpapê té, dîyo pi knî ye w꞉êênî dp꞉uu vyi tóó. Yepê, Tumu kópuni kwayi ngê nmye n꞉aa tpapê too, dîyo naa têdê tââ dp꞉uu vyi tóó. ");
INSERT INTO yle_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yepê, Pi knî ye namê nkîngê. Yepê, A l꞉êê dîy꞉o wa vya nmyomomê, am꞉ii pw꞉oo dmi, ye ló kópu nmye m꞉uu wa d꞉uu ngmê. Yepê, Doo u ntââ, nmyi ghê ndêndê daawa vya ngmê. Yepê, Ye anmyi nkîngê knomomê, a wépi u ngwo anmyi pwaa ngmê, ye Chóó Lémi ngê nmyi wépi dmi u nkwo wa puwâ, ndiya wa kéé nmyo. Yepê, Chóó Lémi p꞉ee vyîlo, u kwo yidmyinê nkîngê. ");
INSERT INTO yle_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yepê, Mtyîmwe daa ndîî ńméni tp꞉oo, knî ngmêdê pw꞉oo knomomê, nmyinê nmye k꞉omo tpile, ngmênê Chóó Lémi ye wunê vyuwo yédi, doo u lama daangmêwa pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Yepê, Nmye myewunê vyuwo yédi, dp꞉ee mtyîmwe ntee yéli, dnyinté nmye dêdê vyuwo. Yepê, Nmyo yintómu u lama nmye pyede, nmyi mbêmê mbêmê mbodo gh꞉aa ntémwi a kwo, u lama mye tóó, doo u lama daangmêwa a ghay. Yepê, D꞉ud꞉umbiy꞉e pi ka namê nkîngê. ");
INSERT INTO yle_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yepê, Pini n꞉ii ngê pi knî ye daawa a wópu nê, yewo, Nyââ, ye pini p꞉uu n꞉aa dpodo, ye kuwókuwó wéni ngê M꞉aa ngîma yi pini u nkwo daanîmo wópu, a kêê k꞉oo wan꞉uu kââ. ");
INSERT INTO yle_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yepê, N꞉ii ngê pi knî yi ngîma wa a wópu nê, yewo, Ye pini p꞉uu dînê dpodo, ye kuwókuwó wéni ngê M꞉aa ngîma yi pini u nkwo wanîmo wópu, a kêê k꞉oo daan꞉uu kââ. ");
INSERT INTO yle_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesu ye póó wo, yepê, Nmyinê nmye yoo kââdîkââdî u l꞉êê dîy꞉o dyámê mbêmê nê loo, apii? Yepê, Ngmênê kêle, daa yoo kââdîkââdî u l꞉êê dîy꞉o nê loo, nê, Yoo n꞉uu chámê. ");
INSERT INTO yle_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yepê, Yi kópu u l꞉êê dîy꞉o yoo woni a yoo vy꞉o wa ghê dmi, woni knî y꞉oo a wépi wa pwaa ngmê. Yepê, Yi ngwo mââ u mî k꞉ii dnyinté noko adpî ya, pyââ u pye k꞉ii dnyinté noko adpî ya, u ń꞉ââ k꞉ii dnyinté noko amyidu ya. ");
INSERT INTO yle_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yepê, Daa kn꞉aa yéli yi mo ye wanmy꞉uu diya dmi, ngmênê nmyi chóó nmyi yoo knî ye wanmy꞉uu diya dmi. ");
INSERT INTO yle_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yepê, N꞉ii nódo u pye mî yi nuu ghi dê d꞉ud꞉umbiy꞉e nódo adpî ya, a nuu ghi nódo pee tp꞉oo adî ya, yi pini amî dîpî, a kêê k꞉oo daamî ghê. Yepê, N꞉ii nódo tp꞉oo módó tp꞉oo mââ yoo yi nuu ghi dmi ndêndê ngê nódo adî ya, a nuu ghi pee tp꞉oo nódo adî ya, yi pini amye dîpî, a kêê k꞉oo daamî ghê. ");
INSERT INTO yle_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yepê, N꞉ii ngê a l꞉êê dîy꞉o dono daawa a vy꞉u, a l꞉êê dîy꞉o myedaawa pw꞉onu, yepê, yi pini wa dîpî, a kêê k꞉oo daamî ghê. ");
INSERT INTO yle_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yepê, Pini n꞉ii u ghê p꞉uu adî nuw꞉o, awo, Kîngê vya nê, u ngwo wa kede, a yoo vy꞉o daawa ghê, yepê, yi pini ndêndê ngê wa pw꞉onu, ndê ngê amî ma. Yepê, Pini n꞉ii a l꞉êê dîy꞉o wa pw꞉onu, yi pini amêdê pyidu, ghê kamî u ngwo wa a pyw꞉oo, mb꞉aamb꞉aa ngê adîn꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yesu ngê yepê, N꞉ii nmye ada a vyuwo, ye a ka amyeda a vyuwo, amyedê chââchââ nê, n꞉ii ngê a dy꞉ââ noo amyedê chââchââ. ");
INSERT INTO yle_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yepê, Dini ghi n꞉ii ngê M꞉aa ngê u komo kapî pyu knî ye yi pywuu dmi wa y꞉oo, yi ngwo n꞉ii yoo yi yéli ye mwiyé dnyimo a vyuwo, yi pywuu dmi yinté amyedê ngee ngmê. Yepê, Myenté, dini ghi n꞉ii ngê M꞉aa ngê a yoo mb꞉aa knî ye yi dpodo u pywuu dmi ye wa y꞉oo, yi ngwo n꞉ii yoo ye mwiyé adnya a vyuwo, yi pywuu dmi yinté amyedê ngee ngmê. ");
INSERT INTO yle_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yepê, K꞉omo tpile nmyi pi dmi daa ndîî dé, ngmênê n꞉ii ngê a l꞉êê dîy꞉o wa ngee nmyo, kópu mb꞉aa yi pini ngê ngmanî d꞉uu. Yepê, Mbwaa knî nmye angma a kê, k꞉omo tpile daa tpile ndîî nmye ayedê kê, ngmênê kópu mb꞉aa ndêndê ngê yi pini ngê ngmanî d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Dini ghi n꞉ii ngê Yesu ngê u dyépi y꞉a mê miyó knî ye u dy꞉oo a kêlî ngê, wod꞉oo p꞉aani p꞉aani dy꞉ââ too. Yi kuwó kada myedê y꞉ângo, p꞉aani p꞉aani pi knî ye myedoon꞉aa dêêpî. ");
INSERT INTO yle_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yi ngwo Njon Baptist mbwa k꞉oo doo kwo, kópuni Yesu Kédisu ngê doo d꞉uud꞉uu dé, yi pi dmi y꞉i nyongo, wod꞉oo p꞉uu ndiye pyu miyó dê ye mbwolo, nmî Lémi ka dy꞉ââ doo, ");
INSERT INTO yle_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","yepê, U kwo dpî póó cho, kwipi, Pini n꞉ii nmo t꞉âât꞉ââ, mumdoo nyi vyîlo ó kn꞉aa pini yuno t꞉âât꞉ââ? Yi pini dê Yesu ka yi lee knopwo, yi kópu p꞉uu u kwo póó knopwo. ");
INSERT INTO yle_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu ngê yepê, Kópuni dpî m꞉uu t꞉oo, kópuni dpî ny꞉ee t꞉oo, yi kópu yilî Njon ka dpumo nté tóó. Yepê, U kwo dp꞉uu vyi nyoo, kwipi, Kópuni yilî Yisaya ngê wunê a d꞉êê too, nê ngê ka ntiyentiye té. ");
INSERT INTO yle_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kwipi, Yélini dêdnyimo vyuwo, yélî mêka y꞉enê ngmê. Kwipi, Yélini dêdnyimo m꞉ii, mêka paa té. Kwipi, Yélini yi p꞉uu too pee mbii doo ya, kîmaa pyi té. Kwipi, Yélini ngwene pwââ dé, dnye mêka nyêmî ngmê. Kwipi, Yélini pw꞉oo dniye, mêkîyedê pyidupyidu té. Kwipi, Ngópuch꞉anê knî y꞉oo Kópu Mb꞉aa a nyêmî ngmê. ");
INSERT INTO yle_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kwipi, Pini n꞉ii ngê a wépi daawa a puwâ, mb꞉aamb꞉aa wa a pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Dini ghi n꞉ii ngê Njon ka mê diyé knopwo, Yesu pi knî ye Njon p꞉uu doo danêmbum, yepê, Dini ghi n꞉ii ngê Njon w꞉amî mbêmê modoo a dpodo, lukwe u pyinê y꞉i nmyi ngm꞉êê ngópu? Yepê, Mumdoo u yi nmye doo kwo, Nmîn꞉aa yópu u dnye nyêmî? Yepê, Kêle. ");
INSERT INTO yle_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yepê, Lukwe u pyinê y꞉i nmyi ngm꞉êê ngópu? Yepê, Pini n꞉ii u kpîdî mb꞉aa dé u pyinê nmyi ngm꞉êê ngópu? Yepê, Kêle. Yepê, Pini n꞉ii u kpîdî mb꞉aa dé, w꞉amî mbêmê daa dpodo yédi, yi pini king p꞉uu a ya yédi, ngomo mb꞉aa k꞉oo a kwo yédi. ");
INSERT INTO yle_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yepê, A ka vyi yó. Yepê, Lónté pini u pyinê y꞉i nmyi ngm꞉êê ngópu? Yepê, Chóó Lémi u komo kapî pyu ngmê, apii? Yepê, Nyââ, yi pini yi vyîlo, ngmênê Chóó Lémi u komo kapî pyu yintómu mêdê kuwo too, yi pwo pini ngê mê tóó. ");
INSERT INTO yle_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yepê, Dini ghi n꞉ii ngê Chóó Lémi ngê ala kópu a ka a vyu, u komo kapî pyu ngmê ngê yi ngwo a d꞉êê ngê, apê, A kópu y꞉eey꞉ee pyu ṉgada wanî kââ, m̱aa yinê amînê yé. ");
INSERT INTO yle_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yesu ngê yepê, Njon ngê a maa a yó, yoo mbwee yi pwo pini ngê u ngwo pyodo, ngmênê n꞉ii yoo a yoo kamî vy꞉o wa ghê dmi, Njon amêdê kuwo ngmê, u pwo pini ngê amê pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yepê, Dêêpî kópuni Mósisi ngê a d꞉êê too, kópuni Chóó Lémi u komo kapî pyu knî y꞉oo myedê d꞉êê tumo, dye ghi daadîî nmyi kada pini knî y꞉oo yi kópu dyuu nmye dnya a tpapê dé, nmye myednya a tpiye dé. Yepê, Yi chóó yi dêêpî kópu dyuu nmye myednye tpapê dé, ngmênê yi dêêpî kópu dyuu yi chââchââ nmye doo u nt꞉ââ ngê dpîmo pyodopyodo, u nkwo dnyimo kéké nmyo, nmyi yoo kuwa dnyimo kapî nmyo. Yepê, Ngmênê Njon Baptist ngê kópu kamî kn꞉ââ ngmê chópu. Yepê, Ala ngwo nmyenîmo, Nmyi dono a kuwo tóó, Chóó Lémi kóó k꞉oo ghê dmyeno. Yepê, Pi knî y꞉oo yi dono u nkwo wunê kuwokuwo tumo, a kadakada nyédi, apu, Chóó Lémi kóó k꞉oo nmî kee dmi. ");
INSERT INTO yle_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yepê, Chóó Lémi u puku yedê ghi yintómu nmî dye ghi p꞉uu kópu ka pyede. Yepê, Njon Baptist ngê yi kópu yilî yi ntiyentiye kn꞉ââ yinê a chópu. ");
INSERT INTO yle_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","15","Yepê, Nmyinê nmye n꞉ii ngê Chóó Lémi u komo ló dini dpîmo a kapî, Ilacha, yi pini mwiyé wa a diyé, kópu ndîî angmê d꞉uu, Chóó Lémi u Pi Ndêndê u maa yinê wa yé, yed꞉oo u ngwo wa t꞉aa. Yepê, Dp꞉ee ngópu dé, ala kópu ny꞉ee yó, p꞉uu dmyinê nuw꞉o. Yepê, Njon Ilacha ntee pini ngê kêdê pyódu, a maa wunê kêdê yé. ");
INSERT INTO yle_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yepê, Lukwe dîy꞉o nmyi kada pini knî y꞉oo Njon u wépi pwaa ngópu, a wépi myaa pwaa ngmê. Yepê, Nganê pyu yoo. Yepê, Yi p꞉uu n꞉aa mgongo. Yepê, Tp꞉ee ngmê ngê u mbwó knî ye wa vyi, ");
INSERT INTO yle_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","yewo, Tpile we a nté koo, u kwo wa nganê mbê dmi. Yepê, Ala kópu u nkwo ye wa vyi, yewo, Pi ntóó kmênêkmênê a nté koo, yi kópu u wépi u kwo amye pwaa ngmê. Yepê, Nganê pyu yoo. ");
INSERT INTO yle_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yepê, Nmyi kada pini yoo mye yinté yéli, nganê pyu yoo. Yepê, K꞉omo tpile Njon Baptist ngê nté dpîmo kpîpîkpîpî, wain myedêdpîmo ndanî, Chóó Lémi u kópu dyuu ye dpîmo tpapê, ngmênê u wépi pwaa ngópu, ala kópu p꞉uu vyi ngópu, apê, Kmêna u ngwo ngma kwo, kêdê ghéti. ");
INSERT INTO yle_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yepê, K꞉omo tpile nté dînî kpîpîkpîpî ngê, wain n꞉aa ndanî ngê, ngmênê a wépi myaa pwaa ngmê, ala kópu a p꞉uu dpî vyi ngmê, dpo, Nkéli ńuknwe nmye yila, mye nkéli mbwaa ndanî pyu ndîî. Dpo, Tákisi ngêêpî pyu yoo pi dono yoo yi pyipe. Yepê, Njon u wépi kêdê pwaa ngmê, a wépi kîmyaa pwaa ngmê. Yepê, Ló kópu u yi y꞉e m꞉uu a kwo. Yepê, Ngmênê n꞉ii Chóó Lémi u nuw꞉o mbêmê a dpodo yédi, u dpodo nt꞉u dpî kaalî, pi knî y꞉oo u ngwo pêdê w꞉ee y꞉e, yi pini Chóó Lémi u dpodo pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","N꞉ii knî y꞉oo Yesu u wépi pwaa ngópu, yi ngwo Yesu yi p꞉uu doo danê, mu kópu u dîy꞉o k꞉omo tpile mbwudu yi ngópu yilî dpîmo chap, ngmênê u wépi pwaa ngópu, yi dono yilî daa kéé tumo. ");
INSERT INTO yle_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesu ngê pi knî ye yepê, Kódasin tpémi dny꞉oo nkîngê, Mbetîsaida tpémi myedny꞉oo nkîngê. Yepê, K꞉omo tpile mbwudu yi ngópu yilî nî chópu, ngmênê yi dono doongê kéé tumo. Yepê, Taiya p꞉aani dê Saidon tpémi yi ngópu yintoo mbwudu w꞉aangmê chópu, ye k꞉omo tpile daa Nju tpémi, ngmênê yi dono yilî lîmîlîmî ngê pî kéé tumo, yi mbodo dmi pêdê ny꞉ii ngópu, tpéé kópu myepî vyi ngópu. ");
INSERT INTO yle_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yepê, Kuwókuwó wéni ngê Chóó Lémi ngê dnyinté wa kpada té, ngmênê Kódasin p꞉aani dê Mbetîsaida tpémi dnyinté daawa kpada té. ");
INSERT INTO yle_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yepê, Kîpêêniyêm tpémi myedny꞉oo nkîngê. Yepê, Yi chóó yi pi dmi mbóó p꞉uu a kmîmî t꞉oo, ngmênê yi kpadakpada têdê wa lee dmi. Yepê, Kópu ndîî n꞉ii Kîpêêniyêm tpémi yi ngópu nî d꞉uu too, Sodom tpémi yi ngópu w꞉aangmê d꞉uu ngê, ye yi dono yilî lîmîlîmî ngê pî kéé tumo, Chóó Lémi ngê yi p꞉aa daapêdê pw꞉oo ngê, awêde pê tóó. ");
INSERT INTO yle_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yepê, Ndê kópu nmye ngmên꞉aa tpapê, Wéni n꞉ii ngê Chóó Lémi ngê Sodom a pw꞉oo ngê, dnyinté a kpada too. Yepê, Kuwókuwó wéni ngê Kîpêêniyêm tpémi dnyinté daawa kpada té. ");
INSERT INTO yle_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yi dini ghi ngê Yesu ngê u Mî ka kwo, M꞉aa. Kwo, Nyi mbóó dyámê yi kada pini ndêndê. Kwo, Nînê chaa kîgha ngi, mu kópu u dîy꞉o kópuni dyuu a ka nyinê kpo, nyi ngmo too. Kwo, Ndiye pyu ndîî knî y꞉oo dêpê w꞉ee tumo, ngmênê yélini yi pi dmi daa ndîî, y꞉ooda w꞉ee t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kwo, Ṉ́yóó ṉuw꞉o u pono nye vyápê. ");
INSERT INTO yle_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesu ngê pi knî ye yepê, Kópu yilî n꞉ii n꞉aa tpapê too, M꞉aa ngê yinê a ka dpo vyi té. Yepê, Pi ngmê u lama daa tóó, Nê lónté pini, M꞉aa u lama u mo a tóó. Yepê, Pi ngmê u lama daa tóó, M꞉aa lónté pini, a mo a lama a tóó. Yepê, N꞉ii ka M꞉aa mb꞉aamb꞉aa ngê anê kêma, yi pini u lama M꞉aa ndêndê ngê adî ya. ");
INSERT INTO yle_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yepê, Dêêpî kópu yilî yi chââchââ dpodo ndîî ngê nmye dê pyaa knomomê, ye a yoo vy꞉o ghê dmyeno, vyilêvyilê ngê n꞉aa pyépi nmyo. ");
INSERT INTO yle_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yepê, A yoo vy꞉o ghê dmyeno, a p꞉uu dmyinê ndiye, a dnye ny꞉ee yó, mu kópu u dîy꞉o nê pi ka vyuwo pyu, d꞉aa lémilémi pyu. Yepê, Ya mb꞉aa u ngwo anmyinê pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yepê, A kópu dyuu nyêmî dpodo ndîî ngê nmye daawa pyódu, a p꞉uu dpodo vyilêvyilê ngê nmye adî ya. ");
INSERT INTO yle_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yi wiki knî yi k꞉oo lîme wo ngmê ngê Yesu p꞉uu ndiye pyu knî yi k꞉ii witi yâpwo têdê dnyen꞉aa paa. P꞉uu ndiye pyu knî ye dómu kele, wod꞉oo witi w꞉uu mtyé dnya a ngêêpî dé, yi kêê yedê dnye vyuw꞉avyuw꞉a dé, too dnye wupî dé, w꞉uu u nkwo dnye pîpî dé. Daa dpodo ndîî yidnye dódó, ngmênê Pádisi knî y꞉oo yi m꞉uu tumo, noko yepê, Lukwe dîy꞉o nmî lîme wo ngê a dpodo té. ");
INSERT INTO yle_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pádisi knî y꞉oo Yesu ka kwo, Lukwe dîy꞉o m̱꞉uu ndiye pyu yoo nmî lîme wo ngê a dpodo té? ");
INSERT INTO yle_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu ngê yepê, Dini ghi n꞉ii ngê Dépidi u yoo knî yi k꞉ii mudnya a dómudómu, kópuni yi ngwo a d꞉uu ngópu, angênté, yi kópu dp꞉eengê kp꞉aa ngópu? ");
INSERT INTO yle_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yepê, Dini ghi n꞉ii ngê Dépidi ngê Sóól a kuwo ngê, u yoo knî yi k꞉ii mbêpê dniye, nté daa ńuw꞉o ngópu. Yepê, Dómu ngê pî ngee too, wod꞉oo Dépidi Chóó Lémi u wónu ngomo k꞉oo kee wo, yâpwo mbîdédi knî ngma a ngêêdî, u lede knî yi k꞉ii ma tumo. Yepê, Yinté mbîdédi kpêê yiyé pyu knî y꞉oo y꞉oo dnyimo pîpî dé, doo u ntââ kn꞉aa pini ngê daapî ma too. Yepê, Ngmênê Dépidi ka pi ngê yey ngê kêê dêpê t꞉ângo, mu kópu u dîy꞉o Chóó Lémi ngê a ngmidi ngê, king ngê a pyódu ngê. Yepê, My꞉aanté, yepê, Chóó Lémi ngê myedê ngmidi noo, nê u Pi Ndêndê. Yepê, U l꞉êê dîy꞉o nê u ntââ, lîme wo u dêêpî kópu dyuu nmye n꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yepê, Myenté, Chóó Lémi u ngomo u dêêpî kópu ndîî, lîme wo u dêêpî kópu têdê. Yepê, Nmyi lama ka tóó, lîme wo ngê kpêê yiyé pyu yoo Chóó Lémi u ngomo k꞉oo a dpodo nyédi. ");
INSERT INTO yle_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Pini n꞉ii nmyi vy꞉o a kwo, u pi ndîî, Chóó Lémi u ngomo u pi têdê. ");
INSERT INTO yle_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yepê, Chóó Lémi u kópu n꞉ii puku yedê a tóó, p꞉uu dmyinê nuw꞉o, Tpile tp꞉oo nk꞉êênî a ka daa ndîî kópu, pi ka vyuwo yi ndîî kópu. Yepê, Yi kópu wonmyinê w꞉ee ngópu, ye yoo módó daap꞉ee kéké tumo. ");
INSERT INTO yle_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yepê, Chóó Lémi ngê a ngmidi noo, nê u Pi Ndêndê. Yepê, U l꞉êê dîy꞉o nê u ntââ, lîme wo u dêêpî kópu dyuu nmye n꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu p꞉uu y꞉oo yi kêlî ghi a kuwo ngópu, mwada y꞉i ngêpê ngomo ngmê k꞉oo mî kee dniye. ");
INSERT INTO yle_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yi ngomo k꞉oo pi ngmêdoo kwo, kóó ntóó. Pádisi yoo y꞉i myednye kwo, u yi y꞉e doo kwo, Yesu ngê kn꞉aadi te kópu nmî ngópu ngmê d꞉uu ngê, ye u ngwo p꞉oo ndyîko. Yi kópu u l꞉êê dîy꞉o Yesu ka póó dniye, kwo, Nmî dêêpî kópu dyuu angênté a kwo? Kwo, Lîme wo ngê pi ngmanyi pyi, ó doo u ntââ? ");
INSERT INTO yle_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu u nkwo ye póó wo, yepê, Nmyi vy꞉o pini ngmê u sipi lîme wo ngê mgî pââ ndîî k꞉oo wa a ghîî knomomê, doo u ntââ chóó mêdaawa a kee, yepê, lukwe, lîme wo u l꞉êê dîy꞉o yi pini ngê yi sipi yi mgini k꞉oo wa a kuwo? Yepê, Kêle, daawa a kuwo, lîmîlîmî ngê amêdê pêêdî. ");
INSERT INTO yle_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yepê, Kî kóó ntóó daa sipi ye kwo, pi ye kwo. Yepê, Nmî dêêpî kópu dyuu alanté ka kwo, u ntââ lîme wo ngê pi wanyi ngee. ");
INSERT INTO yle_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wod꞉oo Yesu ngê yi pini ka kwo, Ṉgêê kpêd꞉e ngi. Wod꞉oo yi pini ngê kóó kpêd꞉e ngê, yed꞉oo mb꞉aamb꞉aa ngê mê pyodo, woni ntee doo kwo, yinté mê pyodo. ");
INSERT INTO yle_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Wod꞉oo Pádisi yoo pwii dniye, Yesu u vyee u dy꞉oo noko mînê châpwo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Dini ghi n꞉ii ngê Yesu ngê u vyee u pi nyongo, p꞉uu ndiye pyu knî yi k꞉ii yi p꞉aani a kuwo ngópu, kn꞉aa mê lee dniye. Pi yilî knî y꞉oo myednye yâmuyâmu. Yesu ka mbii pyu yilî n꞉ii ńuw꞉o tumo, yintómu pyi too. ");
INSERT INTO yle_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yi yéli ye kwódu ngê, yepê, Kópuni nmye dî d꞉uu, pi knî ye yuu nangên꞉aa y꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yi kópu ye kwódu ngê, Chóó Lémi u kópu n꞉ii Yisaya ngê wunê a d꞉êê ngê, u ngwo ntiye ngê. Yi kópu ala. ");
INSERT INTO yle_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ala a dpodo pyu mb꞉aa, pini n꞉ii nê ngmidi ngê. U nuu ghi a nódo ka tóó, a gha mb꞉aamb꞉aa ngê yinê a pyépi. A ghê dmi u mênê wanî yé, yélini a yoo vy꞉o daa wee, yewo, Mb꞉aamb꞉aa ngê n꞉aa pyépi nmyo, yoo mb꞉aa yi vy꞉o wanî kaa nmyo. ");
INSERT INTO yle_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kwopwepe pyu ngê daadîn꞉aa ya, yoo vy꞉o myedaadîn꞉aa kââkââ. ");
INSERT INTO yle_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yoo kwolo ngmê dé daawa chedê té, ngmênê wa wáti té, n꞉ii dé yi kêlîmî têdê dé, amî kaa té, u dî, u yoo yintómu kamî ngê amî pyódu té. ");
INSERT INTO yle_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pi dyêêdî yintómu knî y꞉oo yi nuw꞉o dmi p꞉uu wa kaa ngmê. ");
INSERT INTO yle_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pi knî y꞉oo Yesu ka pi ngmê ńuw꞉o ngópu. Yi pini ngê u kmêna ngmêdoo kwo, u l꞉êê dîy꞉o dnye dêpwo kîgha, yélî myedêpwo y꞉enê. Yesu ngê yi kmêna ngm꞉ii kwólu, yi pini ngê dnye u ngwo mê kwólu, yélî mê módu. ");
INSERT INTO yle_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yélini y꞉i doo kwo yi nyepênyepê u kópu ngê pyodo, noko yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, Dépidi ntee pini, apê kî vyîlo. ");
INSERT INTO yle_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Dini ghi n꞉ii ngê Pádisi knî y꞉oo ny꞉ee ngópu, pi knî ye yepê, Daa Dépidi ntee pini nmye yila, Setan ntee pini nmye yila, n꞉ii kmêna knî yi kada pini. Yepê, Setan u wêdêwêdê mbêmê kmêna yoo yinê a ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kópuni dnye nuw꞉onuw꞉o dé, yi kópu yilî Yesu ngê yi gha vy꞉o m꞉uu too, mgongo ye u ngwo ngmê kwólu, yepê, Yélini wee ngmidi u kwo a pyede, yoo wa chaa knomomê, numo p꞉uu adnyi l꞉êê knomomê, ye yi chóóchóó yi wee wa dyênê ngmê. Yepê, Myenté, p꞉aa ngmê ó mupwoknî ngmê, numo p꞉uu adnyi l꞉êê knomomê, ye yi chóóchóó yi pi dmi wamye dyênê ngmê. ");
INSERT INTO yle_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Yepê, Setan u yoo mye yinté. Yepê, Numo p꞉uu adnyi l꞉êê knomomê, ye angênté adnyi ya. Yepê, Dmye kn꞉aadi ngmê, daa Setan u wêdêwêdê mbêmê kmêna n꞉aa ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yepê, Nmye ngînî póó. Yepê, Nmyi vy꞉o yéli y꞉oo n꞉uu u wêdêwêdê mbêmê kmêna a ngm꞉ii kîgha tumo? Yepê, Ala kópu nmye tpapê ngmê, N꞉ii ngê kmêna a ngm꞉ii kîgha too, yi pini ngê yi kada pini Setan u wêdêwêdê mbêmê a ngm꞉ii kîgha too. Yepê, Nmyi vy꞉o yéli y꞉oo yi kópu nmye wa wópu ngmê, nmyewo, K꞉omodanê kópu yila. Nmyewo, Chóó Lémi u wêdêwêdê mbêmê kmêna nmo ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yepê, Chóó Lémi u Ghê Dmi u wêdêwêdê mbêmê kmêna ntênê n꞉aa ngm꞉ii kîgha too. Yepê, Yi kópu u l꞉êê dîy꞉o ala kópu nmyi lama choo ya, Chóó Lémi ngê u yoo daa kêmakêma chóó adî y꞉enê. Yepê, U yoo kuwa kîngî kaa nmyo. ");
INSERT INTO yle_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yesu ngê mgongo ye ngmê kwólu, yepê, Tpileni l꞉âmo dy꞉ââ ngê dpî t꞉âmo té, u ngomo k꞉oo dpî km꞉êê té, doo u ntââ u ngomo k꞉oo daanyi kee, mêdaanyimo ngî té. Yepê, Ngmênê n꞉ii u wêdêwêdê ndîî, yi pini u ntââ, yi l꞉âmo dy꞉ââ dpî mgîmî, kóó yu dpî kudu té, u ngomo k꞉oo dpî kee, tpileni mwiyé a t꞉âmo too, tpile chóó knî ye yi tpile moo y꞉ee té. Yepê, Setan l꞉âmo dy꞉ââ ntee pini, u wêdêwêdê ndîî. Yepê, Ala yéli yinê mgîmî ngê, n꞉ii knî y꞉e yi kmêna a wee. Yepê, Chóó Lémi u Ghê Dmi a mênê a tóó, u wêdêwêdê mbêmê Setan kóó yu dî kudu té, yélini y꞉e yi kmêna a wee, dpî pyi té, yi kmêna n꞉aa ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yepê, N꞉ii daa a pee pini, a p꞉uu a d꞉uu yédi. Yepê, A p꞉uu ndiye pyu knî yi k꞉ii nmo vyuwó té. Yepê, N꞉ii ngê daa ngêêpî nmo, te nmo dpî ngm꞉ii kalê té. ");
INSERT INTO yle_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yepê, Ndê kópu nmye ngmên꞉aa tpapê, k꞉omo tpile pi knî y꞉oo ló dono kópu yilî a d꞉uud꞉uu t꞉oo, ló kópu dono Chóó Lémi p꞉uu ngmêdpî vyi ngmê, ngmênê Chóó Lémi ka yi yéli wa diyé dmi, ye Chóó Lémi ngê yi dono kópu yilî u kuwó wa kéé té, ntââ ye mêdaawa a vy꞉u. Yepê, Ngmênê n꞉ii Chóó Lémi u Ghê Dmi u dpodo p꞉uu adî peede tpapê, Chóó Lémi ka yi pini daawa diyé, Chóó Lémi ngê ntââ u kwo wa a vy꞉u. ");
INSERT INTO yle_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yepê, K꞉omo tpile nê Chóó Lémi u Pi Ndêndê, n꞉ii ngê daawa mya nê, a p꞉uu adî peede tpapê, u kuwó dini ghi ngê yi pini ngê yi dono kópu u kuwó amê kéé knomomê, u ntââ Chóó Lémi ngê yi pini u dono u kuwó wa kéé, mêdaawa a ngî, ngmênê n꞉ii Chóó Lémi u Ghê Dmi u dpodo p꞉uu adî peede tpapê, yi pini Chóó Lémi ka daawa diyé, Chóó Lémi ngê u dono yilî u kuwó daawa kéé té. ");
INSERT INTO yle_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesu ngê Pádisi knî ye yepê, Chikini n꞉ii chóó dpî pyidu, ḻama daadî ya, mb꞉aamb꞉aa ó dono, nj꞉iinj꞉ii ó pwópwó. Yepê, Dini ghi n꞉ii ngê dpî dââ, kîgha anyi d꞉uu, u ngwo anyinê w꞉ee, anye, Kî chikini mb꞉aamb꞉aa, kîgha nj꞉iinj꞉ii dé. Yepê, Ngmênê kîgha pwópwó ngê adnyi ya knomomê, anye, Kî chikini dono, kîgha pwópwó dé. ");
INSERT INTO yle_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yepê, Nmyo yoo dono, kópu mb꞉aa nmyi mênê daa tóó, doo u ntââ kópu mb꞉aa daangmanmyi vyi ngmê. Yepê, Kópuni ngê pi u gha dpo nt꞉ono, yi kópu vyîlo ye tpapê ngê. ");
INSERT INTO yle_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yepê, N꞉ii mb꞉aamb꞉aa, kópu mb꞉aa knî y꞉oo u gha dpo nt꞉ee ngmê, kópu mb꞉aa ye tpapê too. Yepê, N꞉ii dono, kópu dono knî y꞉oo u gha dpo nt꞉ee ngmê, kópu dono ye tpapê too. ");
INSERT INTO yle_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, N꞉ii knî y꞉oo kópu dono daa yi nuw꞉o mbêmê a tpapê tumo, kuwókuwó wéni ngê Chóó Lémi ngê vyîlo yi kópu knî yi l꞉êê dîy꞉o wa kóté kalê té, yi l꞉êê dîy꞉o ye adî póó. ");
INSERT INTO yle_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yepê, Kópuni yilî nmye tpapê tumo, Chóó Lémi ngê yi l꞉êê dîy꞉o wa kóté kalê nmyo. Yepê, Yi l꞉êê dîy꞉o woni wa kpada té, woni daawa kpada té. ");
INSERT INTO yle_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pádisi yoo dêêpî pyu yoo yélini y꞉i doo kwo, u yi y꞉e doo kwo, Yesu nmo tókó. Alanté dnye nuw꞉o, apê, Pini n꞉ii nmo t꞉âât꞉ââ kî pini wo vyîlo, ye Chóó Lémi ngê u l꞉êê dîy꞉o kópu ndîî ngmêpaa d꞉uu. Yi kópu u l꞉êê dîy꞉o Yesu ka kwo, Mââwe, u yi nmo a kwo, Mbwudu nmî ngópu ngmê chépi. ");
INSERT INTO yle_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu ngê yepê, Nmyo yoo dono, Chóó Lémi dnyinté nmyi lama a tóó. Yepê, Yinté kópu nmyi ngópu daangmanî d꞉uu, ngmênê dîyo kópu ndîî mu ngmidi wanmyi m꞉uu ngmê. Yepê, Kópuni Chóó Lémi u komo kapî pyu Njóna ngê a pyodo, yinté kópu dîyo a nga ngmêwa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yepê, Njóna ngê te ndîî u mênê wo pyile ntee chedê ngê, pini n꞉ii Chóó Lémi u Pi Ndêndê, yinté wo pyile têpê u mênê wamye chedê. ");
INSERT INTO yle_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yepê, Kuwókuwó wéni ngê, dini ghi n꞉ii ngê pi yintómu wa a pii dmi, Ninipe tpémi y꞉oo wa m꞉uu nmyo, nmyi pi dmi wa dyênê ngmê, wamye ndyîko nmyo, mu kópu u dîy꞉o dini ghi n꞉ii ngê Njóna u kópu dyuu ny꞉ee tumo, yi dono kópu yintómu yi kuwó kéé tumo. Yepê, K꞉omo tpile Njóna dyámê mbêmê pi, ngmênê Ninipe tpémi y꞉oo u dnye ny꞉ee ngópu. Yepê, Nê Njóna u pwo pini, lukwe dîy꞉o a dnye dp꞉ee nyêmî ngmê. ");
INSERT INTO yle_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yepê, Myenté, yepê, kuwókuwó wéni ngê Sipa tpémi yi kwin ngê wamye ndyîko nmyo, mu kópu u dîy꞉o kuughê a ndê wo, Solomon u gha kópu dyuu doon꞉aa ng꞉aang꞉aa dé. Yepê, K꞉omo tpile Solomon dyámê mbêmê pi, ngmênê Sipa tpémi yi kwin ngê châpu ngê. Yepê, Nê Solomon u pwo pini. Yepê, Lukwe dîy꞉o dp꞉ee chââchââ nê. ");
INSERT INTO yle_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yepê, Dyimê pywuu nmye ngmênînê kuwo. Yepê, Dini ghi n꞉ii ngê nmyi vy꞉o yéli y꞉oo pi ka u kmêna dpî ngm꞉ii kalê ngmê, yepê, yi kmêna wee dono u kwo wumê paambwi yédi, u yââyââ têdê ka wumê vyuwo yédi, dpo, Y꞉i n꞉uu yââ. Yepê, U yââyââ têdê d꞉uuwodê pyw꞉ee knomomê, ");
INSERT INTO yle_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ye u nuw꞉o k꞉oo dpo, Kwéli nê ndê wo, y꞉i mênê diyédiyé. Yepê, Dini ghi n꞉ii ngê dpo diyé, dpo, Ngomoni k꞉oo nê pwii wo, kamî ngê aténgê maa pyódu, tpile dono k꞉oo daa tóó, u y꞉enê pyu daa tóó. ");
INSERT INTO yle_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yepê, Wod꞉oo dpî lê, u pyipe mê pyudu dpî nya, n꞉ii knî yi l꞉êê ghi dmi d꞉ud꞉umbiy꞉e dono. Yepê, Yi kmêna wááli knî yi ngomo k꞉oo a kwo nyédi. Yepê, Yi pini u ya d꞉ud꞉umbiy꞉e dono ngê dpî pyódu, wunê ntee dpîmo a ya, mêdaa yinté. Yepê, Nmyo mye yinté dé. Yepê, Mbwudu nmyi ngópu ngmanî chaa knomomê, ye nmyi too pee mbêmê nmyi l꞉êê ghi dmi wanmyi ngmêê t꞉oo, ngmênê nmyi gha dmi daanmyi ngmêê t꞉oo. Yepê, U kuwó dini ghi ngê, dononi nmyi mênê a tóó, d꞉ud꞉umbiy꞉e ndîî ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Dini ghi n꞉ii ngê Yesu pi knî ye ngomo k꞉oo doo danêmbum, u pye ghee knî yi ngwo taa dniye. Pi yilî ngê ye pyodo, doo u ntââ yi ngomo k꞉oo daapî kee dniye. Kuwa dnya a kwo, pi knî ye yepê, U kwo vyi yó, U yi nmo a kwo, U kwo nmo danêmbum té. ");
INSERT INTO yle_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wod꞉oo pi ngmê ngê kwo, M̱ye ghee knî kuwa ka wee, ṉga danêmbum u yi y꞉e a kwo. ");
INSERT INTO yle_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu ngê kwo, N꞉uu ngmê a pye? Kwo, N꞉uu dé ye a mbwó yoo? ");
INSERT INTO yle_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Wod꞉oo p꞉uu ndiye pyu yoo yi p꞉uu kóópyââ kââ, yepê, K꞉omo tpile niye ghee knî kuwa a wee, ngmênê a yoo njini ala ngomo k꞉oo a kwo. ");
INSERT INTO yle_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yepê, N꞉ii knî y꞉oo M꞉aa u nuu u kópu knî ye d꞉uud꞉uu tumo, yi yéli yi niye ghee knî. ");
INSERT INTO yle_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yi wéni ngê Yesu ngomo k꞉oo a pwii wo, Nkálili Kpéni Lêê u nkîgh꞉ê doon꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pi dêpwo a ya, Yesu ka lee dniye. Yesu ka pi yilî ngê pyodo, apê, A pwo wa wó, wod꞉oo dinki k꞉oo wo wo, k꞉oo doon꞉aa ya, y꞉i doon꞉aa ndiye kîgha dé. Pi yilî yi kpéni lêê u nkîgh꞉ê dnyen꞉aa kwo, Yesu y꞉i dnyen꞉aa ng꞉aang꞉aa. ");
INSERT INTO yle_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ye doo mgongo danêmbum, kópu yilî yi nuwo y꞉i doon꞉aa kîgha. Yesu ngê mgongo ye ngmê kwólu, yepê, ");
INSERT INTO yle_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pi ngmê witi w꞉uu nt꞉ene têdê loo, têpê mwiyé chó, witi w꞉uu y꞉i u nkwo doo dimi dé. Yepê, Witi w꞉uu woni dé maa p꞉uu mî dyimê dniye, ńmê knî y꞉oo mî ma tumo. ");
INSERT INTO yle_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yepê, Witi w꞉uu woni dé t꞉aanî mbêmê mî dyimê dniye, têpê mdoo kwéli dêpwo ya. Yepê, Yi witi w꞉uu dé lîmîlîmî ngê pii dniye, ");
INSERT INTO yle_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ngmênê dini ghi n꞉ii ngê kââdî ndîî yi kee wo, wod꞉oo pw꞉oo dniye, mu kópu u dîy꞉o yi km꞉êê dmi têpê mênê yimi daa ghêpê dniye. ");
INSERT INTO yle_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yepê, Witi w꞉uu woni dé tpyé vy꞉o mî dyimê dniye, y꞉i mî pii dniye, tpyé ngê ma too. ");
INSERT INTO yle_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yepê, Witi w꞉uu woni dé têpê ghi mb꞉aa mbêmê mî dyimê dniye, y꞉i mî pii dniye, yi nt꞉u dmi mb꞉aamb꞉aa ngê kaa dniye, yepê, knî ngmê yi nkwodo w꞉uu yonoy꞉a kele, yepê, knî mu yi nkwodo wonoy꞉a kele, yepê, knî m꞉uu yi nkwodo pyoloy꞉a kele. ");
INSERT INTO yle_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yepê, Kópuni nmye dî vyi, yi kópu mb꞉aamb꞉aa ngê dmyinê nuw꞉onuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","U kuwó dini ghi ngê Yesu p꞉uu ndiye pyu yoo Yesu ka lee dniye, u kwo póó dniye, kwo, Dini ghi n꞉ii ngê pi knî ye nye danêmbum, lukwe dîy꞉o ye nye mgongo? ");
INSERT INTO yle_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu ngê yepê, Chóó Lémi kóó k꞉oo wowo, tumu kópu ngê doo ya. Yepê, Yi tumu kópu yilî nmye wanî tpapê dé, ngmênê kn꞉aa yéli ye nt꞉u p꞉uu daana a dêêdêê, ye anî mgongo. ");
INSERT INTO yle_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yepê, N꞉ii ngê ngópu dê dpî kpêmî dê, Chóó Lémi u kópu dyuu mb꞉aamb꞉aa ngê dpî ny꞉oo, yi pini ngê Chóó Lémi u kópu knî m꞉uu dpo w꞉ee. Yepê, N꞉ii ngê ngópu dê d꞉uudpî kpêmî dê, yi pini u mênê Chóó Lémi u kópu dyuu d꞉uudpî kee dmi, yi pini ngê l꞉âmo dpo ngee té. ");
INSERT INTO yle_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yepê, Ye n꞉aa mgongo yédi, mu kópu u dîy꞉o k꞉omo tpile dpî m꞉uu ngmê, d꞉uudpî mya ngmê, dpî ny꞉ee ngmê, myed꞉uuwodê w꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yepê, Chóó Lémi u kópu n꞉ii Yisaya ngê wunê a d꞉êê ngê, wu yéli y꞉oo ala ngwo ka ntiyentiye ngmê. Yepê, Chóó Lémi ngê Yisaya ka kwo, Pi knî ye ala kópu dpî vyi ngi, yipi, U nyêmî ngê anmyi nyêmî, mêdaanmya a wopwe, U mumu ngê anmyi mumu, mêdaanmyi y꞉enê. ");
INSERT INTO yle_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kwo, Yi kópu kî yéli ye dpî vyi ngi, mu kópu u dîy꞉o, yi ngwolo dmi my꞉oo a tóó, nkê kpeme a pyede, yi mbodo podo dé. Wo daa yinté, u mumu ngê pê mumu ngmê, u nyêmî ngê pê nyêmî ngmê, u wopwe ngê pêdê wopwe ngmê, a ka pêdê diyé dmi, pîdî pyi té. ");
INSERT INTO yle_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yepê, Ngmênê dp꞉ee wunté yéli. Yepê, Chóó Lémi ngê nmyi ngwolo dmi a pywálî too, ntênê dmyi mya nê. Yepê, Chóó Lémi ngê nmyi ngópu dmi a kpêmî too, a kópu dyuu u ngwo nmye nyêmî tumo. ");
INSERT INTO yle_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yepê, Ndê kópu nmye ngmên꞉aa tpapê, Yélini y꞉oo Chóó Lémi u komo wunê dnyimo a kapî, yoo mb꞉aa mye yi k꞉ii, u yi y꞉e doo kwo, Nê u kópu yilî nmî ny꞉ee té, my꞉oo m꞉uu té, ngmênê daa m꞉uu tumo, myedaa ny꞉ee tumo, wunê a pw꞉oo dniye. ");
INSERT INTO yle_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Ala kópu ny꞉ee yó. Yepê, Witi nt꞉ene u mgongo danêmbum n꞉ii dî kwolo, u nt꞉u kópu alanté. ");
INSERT INTO yle_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yepê, Witi w꞉uu woni knî maa p꞉uu ntee dpî dyimê dmi, ńmê knî y꞉oo ntee dpî ma t꞉oo, yepê, pi woni knî yinté dé, a kópu dyuu dpî ny꞉ee t꞉oo, d꞉uuwodê w꞉ee t꞉oo, yi gha vy꞉o d꞉uudpî yé t꞉oo, pi dono ngê yi kópu dpî t꞉âmo té. ");
INSERT INTO yle_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Yepê, Witi w꞉uu woni knî t꞉aanî mbêmê ntee dpî dyimê dmi, w꞉uu dpî pii dmi, lîmî k꞉ii ngê moo pw꞉oo dmi, yepê, pi woni knî yinté dé, dini ghi n꞉ii ngê a kópu dyuu dpî ny꞉ee ngmê, yi gha dmi mb꞉aamb꞉aa ngê dpî pyódu, ngmênê yi kópu daa dye ghi daadîî yi gha vy꞉o a ya yédi. Yepê, Dini ghi n꞉ii ngê kn꞉aa yéli y꞉oo a kópu dyuu u l꞉êê dîy꞉o a yoo adnyi kpakakpaka dé, yepê, yi yéli y꞉oo lîmî k꞉ii wa kpîpî nê. ");
INSERT INTO yle_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yepê, Witi woo woni knî tpyé ngê ntee dpî ma té, yepê, pi woni knî yinté dé, a kópu dyuu dpî ny꞉ee ngmê, ngmênê dyámê u tpile knî y꞉oo a kópu dyuu yinté dpî ma ngmê. Yepê, Yi yéli nté ndapî, tpile yilî yi p꞉uu a nuw꞉o nyédi, a p꞉uu daa nuw꞉o nyédi, yi gha vy꞉o a kópu dyuu nt꞉u d꞉uudpî kaalî. ");
INSERT INTO yle_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yepê, Witi woo woni knî têpê mb꞉aa mbêmê yi nt꞉u dmi mb꞉aamb꞉aa ngê ntee dpî kaalî, yepê, pi woni knî yinté dé, a kópu ngê yi gha dmi dpî ntówo té, yi gha vy꞉o nt꞉u yinté mb꞉aamb꞉aa ngê dpî kaalî, woni knî yi mênê yonoy꞉a dé, woni knî yi mênê wonoy꞉a dé, woni knî yi mênê pyoloy꞉a dé. ");
INSERT INTO yle_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu ngê pi knî ye yepê, Chóó Lémi u yoo ndêndê ntee adî kaakaa, yi kópu p꞉uu nmye n꞉aa mgongo. Yepê, Pi ngmê ngê u witi yâpwo têdê ngmê yó, têpê mwiyé chó, witi w꞉uu y꞉i u nkwo doo dimi dé. ");
INSERT INTO yle_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yepê, Mgîdî vy꞉o dini ghi n꞉ii ngê pi yintómu doo dpî, pi dono ngma a loo, yi witi yâpwo têdê kn꞉aa yini w꞉uu mê yilî dyîngo, wod꞉oo p꞉o mê diyé wo. ");
INSERT INTO yle_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yepê, Yi yini witi nipi pii dniye, nipi mye kaa dniye, yi nt꞉u dmi kwodonkwodo mê kele. ");
INSERT INTO yle_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yepê, Dpodo pyu knî y꞉oo yâpwo têdê chóó ka kwo, Mââwe. Kwo, Ṉyâpwo têdê witi u mo nyi ntówo. Kwo, Kî yini w꞉uu anyedê pwiyé dmi? ");
INSERT INTO yle_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yepê, Pi dono ngmê ngê yinê ntówo too. Yepê, U yi u ngwo a kwo, Nê ka dpodo ndîî ngê paa pyaa we. U kwo póó dniye, Kwo, U yi ṉga a kwo wu yini wanmîmo y꞉ee té? ");
INSERT INTO yle_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yepê, Kêle, nangê y꞉ee té. Yepê, Dini ghi n꞉ii ngê wu yini woo nmyinê paapaa t꞉oo, witi woo yi p꞉uu wa kaa dmi, amyenmyinê pêêdî t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yepê, Mudny꞉oo kwo. Yepê, Dini ghi n꞉ii ngê witi kpê wa kyopwo, a dpodo pyu knî ye wanî vyi, yenê, Wu yini woo mwiyé dpo châpwo tóó, dmi dpî kê tóó, ndiya dpî kéé tóó. Yenê, Witi woo kuwó dpo châpwo tóó, w꞉uu péé a ngomo k꞉oo dpo ńuw꞉o tóó. ");
INSERT INTO yle_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Yesu ngê pi knî ye mgongo m꞉uu kwólu, yepê, Kwee ntee dpî k꞉aa, Chóó Lémi u yoo yinté yilî ngê amî pyódu. Yepê, K꞉omo tpile kwee pii tp꞉oo daa ndîî ngê wunê kwo yédi, ngmênê dini ghi n꞉ii ngê yi nkwodo dpî kee, dpî tîpîtîpî mb꞉anê, pywápê ye ya yédi. ");
INSERT INTO yle_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu ngê pi knî ye mgongo m꞉uu kwólu, yepê, Mbîdédi nk꞉êênî têdê pyââ ngê yis knî tp꞉oo dpo ngî, k꞉omo tpile kpo ndîî u mênê dpî yé, ngmênê u kuwó dini ghi ngê kpo yintómu dpî mbó. ");
INSERT INTO yle_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yi kópu knî yi p꞉uu Yesu pi knî ye doo mgongo. Kópu módó ye daangmê vyu. Dye ghi yintómu ye dpîmo mgongo. ");
INSERT INTO yle_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kópuni Chóó Lémi u komo kapî pyu ngmê ngê wunê a d꞉êê ngê, Yesu ngê u ngwo ntiye ngê. Yi kópu ala. Pi knî ye anî mgongo. Kópuni ye anî vyi té, ngmee u kópu dé, Chóó Lémi ngê dini ghi n꞉ii ngê dyámê pê mwo a l꞉âmo ngê, yi ngwo a ngmo too. ");
INSERT INTO yle_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Dini ghi n꞉ii ngê Yesu ngê yoo a kuwo ngê, ngomo k꞉oo mê kee wo. P꞉uu ndiye pyu yoo u kuwó ghê dniye, kwo, Yâpwo têdê dyede p꞉uu mgongoni ye chi kwolo, u nt꞉u lukwe? ");
INSERT INTO yle_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu ngê yepê, A chóó nê yâpwo têdê chóó, ");
INSERT INTO yle_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","a yâpwo têdê u nt꞉u kópu, dyámê pê. Yepê, Witi woo dé yi nt꞉u kópu, yélini a yoo vy꞉o a wee, wu yini woo dé yi nt꞉u kópu, mgîdî u yoo. ");
INSERT INTO yle_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yepê, Pi dono, n꞉ii ngê wu yini w꞉uu mî ntówo too, u pi Setan. Yepê, Wéni n꞉ii ngê witi kpê dpî kyopwo, u nt꞉u kópu kuwókuwó wéni. Yepê, Dpodo pyu yoo yi nt꞉u kópu enjel yoo. ");
INSERT INTO yle_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Dpodo pyu knî y꞉oo wu yini woo dmi ndiya ntee dpî kéé t꞉oo, kuwókuwó wéni ngê yinté kópu angmê pyódu. ");
INSERT INTO yle_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yepê, A enjel yoo dyámê wope wope yinté wanê dy꞉ââ té, yoo dono wa a ngî t꞉oo, ndiya wa kéé t꞉oo. Yepê, N꞉ii knî y꞉oo u yi adî kwo, Nê u yoo nmî dyênê, yi yéli amyedê ngî t꞉oo, ndiya amye kéé t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Y꞉i adnyin꞉aa mbê, yi kpéngi ti dmi kelekele adnyin꞉aa paa. ");
INSERT INTO yle_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yepê, Yi ngwo a yoo M꞉aa kóó k꞉oo wanî kââ. Yepê, Kââdî ntee a pil꞉apil꞉a yédi, mgîdî u mênê daa ya yédi, a yoo mye yinté, dyââpe yi p꞉uu daadîn꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu ngê yepê, Chóó Lémi kóó k꞉oo wowo, yi kópu ndîî kópu. Yepê, Dyámê mbêmê kópu yilî yintómu têdê kópu dé. Yepê, Yi kópu p꞉uu n꞉aa mgongo. Yepê, Pi ngmê, kn꞉aa pini u têpê ghi mbêmê doon꞉aa dpodo, nkól y꞉i ngmêmînê pyw꞉ângo. Yepê, U lama doo ya, nkól u pywuu pââ ndîî, yi têpê ghi u mênê knî m꞉uu ka kwo. Yepê, U gha d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê pyodo, apê, A tpile yilî yintómu mwo p꞉aa dé, pi knî ye y꞉ee too, u kwo pwila tumo, yi ndapî ngê yi têpê ghi u ngwo mî pwila ngê, nkól mê yilî y꞉i a pyw꞉ângo, u ndapî ndîî ngê u ngwo pyodo. ");
INSERT INTO yle_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yepê, Yinté kópu m꞉uu ala. Yepê, Pi ngmê, moodo kpapê pi knî ye dpîmon꞉aa pywupwi dé, ndáápi knî y꞉oo u nkwo u kwo dnyimo pywupwi dé. ");
INSERT INTO yle_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yepê, Dini ghi n꞉ii ngê moodo kpapê pââ ndîî ngma a pyw꞉ângo, u gha d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê pyodo, apê, A tpile yilî yintómu mwo p꞉aa dé, pi knî ye y꞉ee too, u kwo pwila tumo, yi ndapî ngê yi moodo kpapê pââ ndîî u ngwo pwila ngê. ");
INSERT INTO yle_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu ngê yepê, Chóó Lémi kóó k꞉oo wowo p꞉uu dyimê pywuu nmye ngmênînê kuwo. Yepê, Vyuwó têdê pwoo k꞉oo te dyêêdî daa ngmidi dpo ghîî. ");
INSERT INTO yle_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Yepê, Pi knî y꞉oo te mb꞉aa a myeme tumo, n꞉ii mb꞉aamb꞉aa dé nee k꞉oo dpî ché t꞉oo, n꞉ii dono dé dpî kéé t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Yepê, Kuwókuwó wéni ngê mye yinté kópu ayi pyódu, enjel knî y꞉oo yoo yinté amî mya ngmê, n꞉ii mb꞉aamb꞉aa dé Chóó Lémi kóó k꞉oo wa kaa t꞉oo, ");
INSERT INTO yle_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","n꞉ii dono dé ndiya wa kéé t꞉oo. Yepê, Y꞉i adnyin꞉aa mbê, yi kpéngi ti dmi kelekele adnyin꞉aa paa. ");
INSERT INTO yle_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu p꞉uu ndiye pyu knî ye póó wo, yepê, Yi kópu yilî dmyinê w꞉ee t꞉oo? Kwo, Nyââ. ");
INSERT INTO yle_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yepê, N꞉ii u lama Chóó Lémi u kópu dyuu mbwee mb꞉aamb꞉aa ngê a kwo, a yoo vy꞉o myoo ghê, a p꞉uu a ndiye yédi, yi pini u ndiye têdê miyó. Yepê, Yoo yi wátiwáti têdê kópu mbwee dpo ngî té, pi knî ye dpî vyi té, kópu kamî myedo ngî té, pi knî ye myoo vyi té. Yepê, Kópu dyuu mb꞉aa yila, tpileni u pywuu ndîî, mye yinté kópu dyuu. ");
INSERT INTO yle_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Dini ghi n꞉ii ngê Yesu ngê pi knî ye mgongo a kêlî ngê, yi p꞉aani a kuwo ngê, ");
INSERT INTO yle_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","p꞉aani n꞉ii a kaa wo y꞉i mê diyé wo, Nasalet. Y꞉i pi knî ye ngêpê ngomo k꞉oo doon꞉aa dêêpî. Dêêpî kópuni ye vyi too, yi nyepênyepê u kópu ngê pyaa dniye, noko yepê, Kî kópu yilî anyi wunê ng꞉êênî té? Noko yepê, Mumdoo mbwudu yilî mye chapî ngê? ");
INSERT INTO yle_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Noko yepê, Kî daa pi ngmê. Noko yepê, Ngomo wuwó pyu tp꞉oo, u pye u pi Méli, Njems Njósép Saimon Njudas yi mbwó. ");
INSERT INTO yle_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Noko yepê, U tîdê yoo yintómu al꞉ii ka pyede. Noko yepê, Yi kópu yilî anyi m꞉iiwunê ng꞉êênî? ");
INSERT INTO yle_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yi kópu u l꞉êê dîy꞉o Yesu mb꞉ii ngópu. Yesu ngê yepê, Chóó Lémi u komo kapî pyu kn꞉aa p꞉aani dp꞉uu châpu ngmê, ngmênê u p꞉o tpémi y꞉oo d꞉uudpî châpu ngmê, ngmênêni knî y꞉oo myed꞉uudpî châpu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesu ngê mbwudu yilî y꞉i daa chópu, mu kópu u dîy꞉o u kwo dêdnye kêlîmî. ");
INSERT INTO yle_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yi dini ghi ngê Nkálili tpémi yi king ngê Yesu u pi yi nyongo. Yi king u pi Antipas Helodi. ");
INSERT INTO yle_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Dini ghi n꞉ii ngê Yesu p꞉uu kópu dyuu yi nyongo, u dpodo pyu knî ye yepê, Na a ka Njon Baptist mêyedê pyidu. Yepê, Yi kópu u l꞉êê dîy꞉o mbwudu yilî a chapî ngê. Yi kópu ye vyu, mu kópu u dîy꞉o Njon Baptist mbwámê mwiyé a châpwo, u nuw꞉onuw꞉o u kópu ngê u ngwo pyodo. Yi danêmbum ala. ");
INSERT INTO yle_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Mwiyémwiyé, Antipas Helodi ngê u mbwó Pilipi u kpâm t꞉âmo ngê, yi pyópu u pi Helodiyas. Yi kópu Njon ngê Antipas ka dpîmo kwódukwódu. Yi kwódu yé u l꞉êê dîy꞉o Antipas ngê Njon mbwa k꞉oo kmungo. ");
INSERT INTO yle_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","U yi u ngwo doo kwo, Njon nî vy꞉a, ngmênê ghêlî daa vyâ. Apê, Wanî vya knomomê, ye Nju tpémi y꞉oo u nkwo wa vya nê. Apê, Yinê ye pi mb꞉aa, Chóó Lémi u komo kapî pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Antipas Helodi u taataa u wo dini ghi n꞉ii ngê dyimê wo, chóó u l꞉êê dîy꞉o naa ndîî ngmê kpo, mââwe ndîî yoo a danê ngê. Yi nááli têdê Helodiyas tp꞉oo módó yi ngópu doo ndens. Yi dmââdî kwodo mb꞉aa, mââwe yoo a pwaa too, ");
INSERT INTO yle_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","wod꞉oo Antipas u kwo kpaa wo, kwo, Lukwe u yi ṉga ngma a kwo? Kwo, Ntémwi u pi a ka nye tpapê, yi ntémwi ṉga nînê kuwo. ");
INSERT INTO yle_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yi dmââdî u pye ngê yi dmââdî ka kópuni vyu, Antipas ka u nkwo vyu, kwo, Njon Baptist mbodo ala ngwo nmoko yedê a ka a ki. ");
INSERT INTO yle_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wod꞉oo king u gha dono ngê pyodo, ngmênê doo u ntââ wépi daapî puwâ, mu kópu u dîy꞉o yi kópu pi yilî yi ngîma vyu, mye kpaa wo. ");
INSERT INTO yle_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yi kópu u l꞉êê dîy꞉o lede ngmê dy꞉ââ ngê, kwo, Njon Baptist mbwámê nyinê chepwe, mbodo dpo ńuw꞉e. Wod꞉oo yi lede mbwa k꞉oo loo, Njon Baptist mbwámê mînê châpwo, ");
INSERT INTO yle_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","mbodo nmoko yedê a kââ, ńuwo, yi kwodo ka mî y꞉ângo, wod꞉oo yi kwodo ngê u pye ka u nkwo mî y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Njon p꞉uu ndiye pyu yoo lee dniye, Njon ntóó mînê ngî ngópu, mî kmênê ngópu, u kuwó dini ghi ngê Yesu ka mdoo u nkwo ńuw꞉o ngópu. ");
INSERT INTO yle_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Antipas Helodi ngê Yesu p꞉uu kópuni vyu, yi kópu Yesu ngê dini ghi n꞉ii ngê nyongo, p꞉uu ndiye pyu knî yi k꞉ii yi p꞉aani a kuwo ngópu, dinki k꞉oo wo dniye, pi kwéli dêpwo a ya, yi mo y꞉i mî tee dniye. Dini ghi n꞉ii ngê pi knî y꞉oo ny꞉ee ngópu, apê, Yesu p꞉uu y꞉oo kada kêdê y꞉ee ngmê, wod꞉oo pi yilî y꞉oo yi p꞉aa a kuwo tumo, kada a y꞉ee ngópu, yélî maa kalê ngópu, Yesu u kada mwiyé mî taa dniye. ");
INSERT INTO yle_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Dini ghi n꞉ii ngê Yesu dinki k꞉oo a ghay wo, yoo ndîî yi módu, u kwo ch꞉anê dniye, pwopwokopwe n꞉ii yi vy꞉o dnye kwo, pyi too. ");
INSERT INTO yle_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kââdî dini ghi n꞉ii ngê daa kêmakêma doo wupwo, p꞉uu ndiye pyu yoo u kwo lee dniye, kwo, Kââdî daa kêmakêma a wupwo, daa p꞉o nmo pyede. Kwo, Kî yéli dy꞉ââ té, p꞉aani p꞉aani dny꞉oon꞉aa nté pywupwi. ");
INSERT INTO yle_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu ngê yepê, Lukwe dîy꞉o wanî dy꞉ââ té. Yepê, Nmyi chóó nté pee knî ye ngmê y꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kwo, Doo u ntââ. Kwo, Yi ntoo ntini nmî ngópu daa tóó. Kwo, Mbîdédi tp꞉oo limi, te miyó nmî ngópu ka pyede, mê ntini daamo a tóó. ");
INSERT INTO yle_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu ngê yepê, A ka a ńuw꞉o tóó. ");
INSERT INTO yle_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pi knî ye yepê, Mbiye mbêmê mbwódo yaa dmyeno, wod꞉oo mbwódo yaa dniye. Yesu ngê mbîdédi limi knî a ngî too, te dê myedê ngî doo, mbóó p꞉uu vyu wo, Chóó Lémi yi l꞉êê dîy꞉o kwuno ngê, mbîdédi pwaa too, te dê mye pwaa doo, p꞉uu ndiye pyu knî ye y꞉ee too, pi knî ye u nkwo y꞉ee tumo. ");
INSERT INTO yle_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pi yintómu doo kmaapî, yi ghê dmi a kee wo. Nté kmono n꞉ii mî kê wo, Yesu p꞉uu ndiye pyu knî y꞉oo péé y꞉a mê miyó mê ntówo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yélini y꞉i doo kmaapî yintómu limo yono yono y꞉a. Mââ yoo yedê kp꞉aa tumo, ngmênê pyââ yoo, tp꞉ee dmââdîma yi k꞉ii, dêpê kp꞉aa tumo. ");
INSERT INTO yle_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kmaapî u kuwó dini ghi ngê Yesu ngê p꞉uu ndiye pyu knî ye yepê, Dinki k꞉oo wo dmyeno, mwada kpéni pee a kada dmyinê kwo. ");
INSERT INTO yle_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yi kuwó yoo yi p꞉o p꞉o dy꞉ââ too, u mo doo ya, mbu mbêmê kee wo, y꞉i doon꞉aa ngêpê. Mgîdî y꞉i u ngwo a ghay wo. ");
INSERT INTO yle_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yi ngwo dinki kpé lêê ńuknîńuknî u kwo doon꞉aa mbêpê. Yópu yi kêpa doo a wupe, vyuwó vy꞉o dnya a vyile. ");
INSERT INTO yle_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mw꞉aamw꞉aa Yesu ngê yi kêlî ghi a kuwo ngê, kpé mbêmê paa kn꞉ââ chópu, p꞉uu ndiye pyu knî ye doo lêpî. ");
INSERT INTO yle_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dini ghi n꞉ii ngê p꞉uu ndiye pyu knî y꞉oo m꞉uu ngópu, apê, Kpé mbêmê lukwe kîyedê pwiyé knî? Apê, Kmêna? Apê, Mbwee? Ghê yi mênê ghipé wo, nkîngê ngê y꞉ay꞉a pwiyé dniye. ");
INSERT INTO yle_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu ngê yepê, Namê nkîngê, Ala nê. ");
INSERT INTO yle_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita ngê kwo, Mumdoo nyi nmî Lémi knomomê, ye u ntââ ṉga wanî lê? ");
INSERT INTO yle_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu ngê kwo, A pwiyé. Wod꞉oo Pita dinki k꞉oo ghay wo, u yi u ngwo doo kwo, Kpé mbêmê nî paa, Yesu ka u ngwo nî lê. ");
INSERT INTO yle_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngmênê dini ghi n꞉ii ngê vyuwó ndîî yi m꞉uu too, nkîngê mbê wo, kpé lêê u mênê doo a wupwo, Yesu ka ka wo, kwo, A Lémi, anyi ngee nédi. ");
INSERT INTO yle_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yi ngwo Yesu kwulo kele, dpodombiy꞉e mgîmî ngê, kwo, Ṉgêlîmî têdê. Kwo, Lukwe dîy꞉o dnyinté a ka nyinê kêlîmî. ");
INSERT INTO yle_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wod꞉oo dinki k꞉oo mê wo knopwo, yópu machedê ngê mê pyodo. ");
INSERT INTO yle_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yélini dinki k꞉oo dnye kwo Yesu ka yi yi mbodo dmi ngê k꞉ame ghê dniye, kwo, Nyi Chóó Lémi Tp꞉oo, ndêndê ngê nmî pwo nye tóó. ");
INSERT INTO yle_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dini ghi n꞉ii ngê kpé lêê ngmêê ngópu, Nkenesadet mî tee dniye, dinki lyoko a kuwo ngópu, ");
INSERT INTO yle_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","wod꞉oo pi knî y꞉oo Yesu yi mya ngópu, pi knî ngmê p꞉aani p꞉aani dy꞉ââ tumo, yepê, Mbii pyu yintómu Yesu ka a pwiyé dniye. Wod꞉oo mbii pyu yilî Yesu ka dnya a ńeńe dé, ");
INSERT INTO yle_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yesu ka dnye nkêpê, kópu, K꞉omo tpile mbii pyu woni knî yi pwo ṉgêê dê daanyi yé dê, ngmênê u ntââ ṉgmîdî kwódo p꞉uu kêê a yiyé ngmê, yed꞉oo a pyiyépyiyé té. N꞉ii knî y꞉oo Yesu u kpîdî kwódo p꞉uu kêê a t꞉ee ngópu, yintómu pyiyé dniye. ");
INSERT INTO yle_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pádisi knî ngmê, dêêpî pyu ngmê knî yi k꞉ii Njedusalem a ndê dniye, Nkálili Wee u kwo Yesu ka lee dniye, ");
INSERT INTO yle_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","kwo, Lukwe dîy꞉o m̱꞉uu ndiye pyu knî y꞉oo nmî kn꞉ââ yoo yi dêêpî kópu dyuu daa chââchââ tumo. Kwo, Dini ghi n꞉ii ngê kmaapî têdê dpî yaa dmi, yi kêê dmi mwiyé d꞉uudpî ghêê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu ngê yepê, Chóó Lémi ngê yi dêêpî kópu dêpê vyu, pi knî y꞉oo yi chóó y꞉oo néti ngópu. Yepê, Kópu u nkwo nmye ngmêngînî póó. Yepê, Lukwe dîy꞉o Chóó Lémi u dêêpî kópu dyuu woni nmyi kéé tumo, nmyi chóó nmyi dêêpî kópu dyuu nmyinê ngî tumo. ");
INSERT INTO yle_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yepê, Mósisi ngê Chóó Lémi u kópu alanté a d꞉êê ngê, apê, Nmyi pye mî dmyinê chââchââ dé. Yepê, Ala kópu mye d꞉êê ngê, apê, N꞉ii ngê kópu dono u pye mî yi p꞉uu dê vyi knomomê, yi pini dpî vya yó. ");
INSERT INTO yle_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yepê, Mósisi ngê yi kópu d꞉êê ngê, ngmênê nmyi kópu u mo. Yepê, Dyimê pywuu nmye ngmênînê kuwo. Yepê, Pi ngmê u pye mî ye wa a tpêpwo knomomê, mbodo l꞉âmo lîmî k꞉ii wa ngêpa, yewo, Tpileni dpo pîd꞉a kê, Chóó Lémi ka wanî y꞉oo, yewo, yi tpile dpo mêdaanî kê. Yepê, K꞉omo tpile yi pini u nuw꞉o dîyo mb꞉aamb꞉aa ngê moo pyódu, u yi u ngwo adî kwo, Niye M꞉aa ye yi tpile nî y꞉oo, yepê, ngmênê yi pini ka yi kópu nmye kwódukwódu ngópu, u kwo nmye tpapê ngópu, kwonmyimo, Ye tpile m̱ye m̱î ye daanyi y꞉oo, mu kópu u dîy꞉o ṉ́yóó nyi vyu, Chóó Lémi u nêni. Yepê, Pi knî ye yi pye mî chââchââ, têdê kópu ngê nmyi pyódu ngópu. ");
INSERT INTO yle_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yepê, Chóó Lémi u kópu dyuu yinté nmyi kéé ngópu, nmyi chóó nmyi kópu dyuu nmyinê ngî ngópu. ");
INSERT INTO yle_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yepê, Nmyi komo knî y꞉oo Chóó Lémi módó nmye chaa kîgha ngópu, ngmênê nmyi nuw꞉o dmi dono dé. Yepê, Dini ghi n꞉ii ngê Yisaya wunê nmyi p꞉uu doo a d꞉êê, ndêndê ngê dêpê kn꞉aadi ngê. Yepê, Chóó Lémi u kópu dyuu alanté a d꞉êê ngê, apê, ");
INSERT INTO yle_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Kî yéli y꞉oo yi komo ngê wunê chaa kîgha noo, ngmênê yi gha dmi kuughê a ka wunê pyede. ");
INSERT INTO yle_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Apê, Daa ndêndê ngê wunê chaa kîgha noo, mu kópu u dîy꞉o yi chóó yi nuw꞉o ngê pi knî ye a komo dpî kaa ngmê, yi chóó yi dêêpî kópu ngê pi knî ye a dêêpî nyédi. ");
INSERT INTO yle_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu ngê yoo a danê ngê, yepê, Kópu nmye ngmên꞉aa tpapê, dpî ny꞉ee yó, myedo w꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yepê, Tpileni pi u mênê dpî ghîî, doo u ntââ yi tpile ngê yi pini Chóó Lémi ka tupwótupwó ngê daawa pyódu. Yepê, Kêle. Yepê, Kópuni pi u kwo dpo pwii, yi kópu ngê yi pini Chóó Lémi ka tupwótupwó ngê yinê dpî pyódu. ");
INSERT INTO yle_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dini ghi n꞉ii ngê Yesu ngê yoo a kuwo ngê, p꞉uu ndiye pyu yoo u kwo lee dniye, kwo, Ḻama daa tóó, kópuni pi knî ye chi vyi, Pádisi knî ye daa yi nuu u kópu ngê dê pyódu. ");
INSERT INTO yle_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Wod꞉oo Yesu ngê mgongo ye ngmê kwólu, yepê, M꞉aa u myângo vy꞉o yini n꞉ii M꞉aa ngê daa ntówo, dîyo wa kp꞉anê té. ");
INSERT INTO yle_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yepê, Pádisi yoo yi p꞉uu nuw꞉o ngê kêê nangê t꞉oo. Yepê, K꞉omo kada pini yoo, my꞉oo a pyede. Yepê, Ngwolokopwe kwulo pini n꞉ii a ya yédi, yi pini ngwolokopwe ngê adî ya knomomê, ye maa wa kn꞉aadi ngmê, dnyinté ghê amî dyimê knî. ");
INSERT INTO yle_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita ngê kwo, Mgongoni pi knî ye chi kwolo, u kakêmê nmo chámê ngi. ");
INSERT INTO yle_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu ngê yepê, Nmyo wu yéli yi pénta dé? ");
INSERT INTO yle_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yepê, Mumdoo yi kópu myedmy꞉oo w꞉ee ngópu? Yepê, Ntini n꞉ii pi u mênê dpî ghîî, doo u ntââ yi ntini ngê yi pini Chóó Lémi ka tupwótupwó ngê daawa pyódu, yepê, mu kópu u dîy꞉o doo u nuw꞉o mênê dpî lê, ngmênê km꞉oo mênê dpî lê, yepê, u kuwó dini ghi ngê yi ntini moon꞉aa yé. ");
INSERT INTO yle_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yepê, Kópuni pi u kwo wunê pywuwópywuwó yédi, yi kópu ngê yi pini Chóó Lémi ka tupwótupwó ngê yinê dpî pyódu, ");
INSERT INTO yle_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","yepê, mu kópu u dîy꞉o pini n꞉ii u nuw꞉o u mênê nuw꞉o ghi dono a pywuwópywuwó nyédi, yepê, u kuwó dini ghi ngê yi pini ngê kópu dono yilî dpî d꞉uu, yepê, pi dpî vy꞉a, pi u kuwó dpî pwiyé, a pyââ ti yédi, a kpaa yédi, k꞉omodanê mbêmê pi u pi a dyede too, kóté têdê módó myoo ndyîko té. ");
INSERT INTO yle_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yepê, Yi kópu knî y꞉oo Chóó Lémi ka pi tupwótupwó ngê yinê dpî pyódu ngmê, ngmênê n꞉ii ngê Pádisi yoo yi kópu dyuu daa chââchââ ngê, kóó dê mwiyé d꞉uudpî ghêê dê, kmaapî têdê u ngwo dpî yââ, yi kópu ngê Chóó Lémi ka pi tupwótupwó ngê d꞉uudpî pyódu. ");
INSERT INTO yle_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu, p꞉uu ndiye pyu knî yi k꞉ii, Nju tpémi yi dyámê pee a kuwo ngópu, Ntii Pââ Ndîî u kêténi mî lee dniye, Taiya p꞉aani dê Saidon yi wee dê yi kwo mî taa dniye. ");
INSERT INTO yle_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kenan pyââ ngmê ye a loo. Yi pyópu daa Nju pyââ, ngmênê Yesu ka kwo, A lémi, Dépidi ntee pini, u ntââ ṉga wanî ch꞉anê. Kwo, A tp꞉ee módó ngê u kmêna ngma a kwo, u dono yilî wunê vyîmî ngê. ");
INSERT INTO yle_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngmênê Yesu ngê kópu u kwo daa vyu. U kuwó dini ghi ngê p꞉uu ndiye pyu knî y꞉oo kwo, Mwada y꞉i dy꞉ââ ngi. Kwo, Mb꞉uu kîyedê yâmuyâmu nmo. ");
INSERT INTO yle_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu ngê yepê, Yisîléli tpémi y꞉oo yi Lémi ndêndê u maa kêdê kn꞉aadi ngmê. Yepê, Yi diyédiyé kîgha u l꞉êê dîy꞉o M꞉aa ngê al꞉ii a dy꞉ââ noo, daa kn꞉aa yéli yi l꞉êê dîy꞉o nê loo. ");
INSERT INTO yle_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wod꞉oo yi pyópu Yesu ka yu mbodo dê y꞉e k꞉ame u kwo ghê wo, kwo, A lémi, ngee nédi. ");
INSERT INTO yle_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu ngê kwo, Tp꞉ee u nté n꞉êê ntee daanyinê ngî, w꞉ââ ka daanyi y꞉oo, kwo, yinté kn꞉aa yéli daangmanî ngee, kwo, Nju tpémi mwiyé n꞉aa ngêêpî té. ");
INSERT INTO yle_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yi pyópu ngê kwo, Nyââ, a lémi. Kwo, Ndê kópu. Kwo, Ngmênê kmaapî têdê w꞉ââ knî y꞉oo nté kmono ntee a pîpî tumo, kwo, kópuni u pi ṉga dî vyi, mye yinté, kwo, yi kópu ṉga daa ndîî kópu, ṉga myedaa dpodo ndîî. ");
INSERT INTO yle_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Wod꞉oo Yesu ngê yi pyópu ka kwo, Ntênê a ka cha kêlîmî mb꞉anê. Kwo, Kópuni u yi ṉga a kwo, yinté pyaa we. Vyîlo yi dini ghi ngê tp꞉oo módó u mbii machedê ngê a pyodo. ");
INSERT INTO yle_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","U kuwó dini ghi ngê Yesu, p꞉uu ndiye pyu knî yi k꞉ii, yi p꞉aani mêdê kuwo ngópu, P꞉aa Y꞉a Knî yi wee knî yi kwo máádi mî kalê ngópu, Nkálili Kpéni Lêê u nkîgh꞉ê mî taa dniye. Mbu ngmê mbêmê kee dniye, y꞉i mbwódo mî yaa dniye. ");
INSERT INTO yle_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pi yilî tp꞉oo témi tap y꞉i ye a loo. Ngópuch꞉anê yilî Yesu ka ńuw꞉o tumo, knî ngmê yi yu kwolo ngmê dé, knî ngmê yi kêê kwolo ngmê dé, knî ngmê yi ngwolo kopwe dé, knî ngmê knî y꞉oo dnye dêdnye kîgha. Mbii pyu mê yilî u kwo myedê ńuw꞉o tumo. Yi ngópuch꞉anê yoo yintómu Yesu u kêma ngmêngmênté dnyen꞉aa kapî dé, yintómu pyi too. ");
INSERT INTO yle_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yélini y꞉oo yi ngópuch꞉anê yoo ńuw꞉o tumo, yi nyepênyepê u kópu ngê pyodo, apê, Yélini dêdnyimo danêmbum, mêka danêmbum té, apê, yélini yi kêê kwolo ngmê dé, kêdê wáti té, apê, yélini dêdnyimo m꞉ii, mêka m꞉ii té, apê, yélini dêdnyimo vyuwo, yélî mêka y꞉enê ngmê. Noko yepê, Yisîléli tpémi yi yâpwo ngê mbwudu yilî kêdê chaa. Wod꞉oo dnye chaa kîgha. ");
INSERT INTO yle_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","U kuwó dini ghi ngê Yesu ngê p꞉uu ndiye pyu yoo a danê ngê, yepê, Kî yéli a ka atédê ch꞉anê dmi, mu kópu u dîy꞉o wo pyile a p꞉uu kêdê chedê ngmê, yi nté kîmyaa chedê ngmê. Yepê, U ya a nga daa kwo, Dómudómu nî dy꞉ââ té, mu kópu u dîy꞉o maa p꞉uu yi gha l꞉âmo dmi awêde wunê ngêpangêpa. ");
INSERT INTO yle_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","P꞉uu ndiye pyu knî y꞉oo kwo, Daa p꞉o nmo pyede. Kwo, Yintoo yéli yi ntââ ntini ló y꞉i anmo pyw꞉oo? ");
INSERT INTO yle_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu ngê yepê, Mbîdédi nmyi ngópu yémi a kwo? Kwo, Pyudu. Kwo, Te tp꞉oo knî myooka tóó. ");
INSERT INTO yle_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu ngê yi yéli ye yepê, Mbwódo yaa dmyeno, wod꞉oo mbwódo yaa dniye. ");
INSERT INTO yle_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","U kuwó dini ghi ngê Yesu ngê mbîdédi pyudu knî a ngî too, te tp꞉oo knî myedê ngî too, Chóó Lémi yi l꞉êê dîy꞉o kwuno ngê, pwaa too, p꞉uu ndiye pyu knî ye y꞉ee too, pi knî ye u nkwo y꞉ee tumo. ");
INSERT INTO yle_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pi yintómu doo kmaapî, yi ghê dmi a kee wo. Nté kmono n꞉ii mî kê wo, Yesu p꞉uu ndiye pyu knî y꞉oo péé pyudu mê ntówo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yélini y꞉i doo kmaapî, yintómu podo yono yono y꞉a. Mââ yoo yedê kp꞉aa tumo, ngmênê pyââ yoo, tp꞉ee dmââdîma yi k꞉ii, dêpê kp꞉aa tumo. ");
INSERT INTO yle_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","U kuwó dini ghi ngê Yesu ngê yi yéli yi p꞉o yi p꞉o mê dy꞉ââ too, p꞉uu ndiye pyu knî yi k꞉ii dinki k꞉oo wo dniye, Makadan Wee u kwo mî tee dniye. ");
INSERT INTO yle_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wo ngmê ngê Pádisi yoo Sadyusi yoo Yesu ka knî ngma a loo. U yi y꞉e doo kwo, Yesu nmo tókó. Alanté dnye nuw꞉o, apê, Pini n꞉ii nmo t꞉âât꞉ââ kî pini wo vyîlo, ye Chóó Lémi ngê u l꞉êê dîy꞉o mbwudu ngmêpaa chaa. Yi kópu u l꞉êê dîy꞉o Yesu ka kwo, Mââwe, u yi nmo a kwo, Mbwudu nmî ngópu ngmê chépi. ");
INSERT INTO yle_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu ngê yepê, Kââdî dini ghi n꞉ii ngê dpî ghîî, ala kópu nmye tpapê ngópu, nye, Mbu vyuwo kpêm kêdê d꞉ii, mââ kââdî y꞉ay꞉a wa pwiyé. ");
INSERT INTO yle_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yepê, Dini ghi n꞉ii ngê nkalî nmye mumu ngópu, ala kópu nmye tpapê ngópu, nye, Nkalî ngmêka kwo, daa kêmakêma tpii wunê ghayghay. Yepê, Lukwe dîy꞉o my꞉oo nmye pyede. Yepê, Kópuni mbóó p꞉uu nmye mumu tumo, mb꞉aamb꞉aa ngê nmyinê wopwe tumo, ngmênê kópuni n꞉aa d꞉uud꞉uu too, lukwe dîy꞉o dênmyinê wopwe t꞉oo. Yepê, Lukwe dîy꞉o dp꞉ee myeme nê. ");
INSERT INTO yle_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yepê, Nmyo yoo dono, Chóó Lémi dnyinté nmyi lama a tóó. Yepê, Yinté kópu nmyi ngópu daangmanî d꞉uu, ngmênê dîyo kópu ndîî mu ngmidi wanmyi m꞉uu ngmê. Yepê, Kópuni Njóna ngê a pyodo, yinté kópu dîyo a nga ngmêwa pyódu. Wod꞉oo yi yéli a kuwo ngê. ");
INSERT INTO yle_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu, p꞉uu ndiye pyu yoo yi k꞉ii, dinki k꞉oo wo dniye, kpé lêê mwada pee dnye lêpî. Dini ghi n꞉ii ngê mî tee dniye, Yesu p꞉uu ndiye pyu knî y꞉oo mbîdédi yimî nuw꞉o kalê ngópu, noko yepê, Mbîdédi pi doo ńuwo. ");
INSERT INTO yle_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu ngê yepê, Nmye dmyina a vyuwo. Yepê, Pádisi yoo Sadyusi yoo yi yis ngê kîngî dyênê nmyo. ");
INSERT INTO yle_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wod꞉oo yi kópu p꞉uu noko dnye danê, noko yepê, Wu kópu kêdê vyi, mu kópu u dîy꞉o mbîdédi nmî ngópu daa kwo. ");
INSERT INTO yle_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kópuni dnye tpapê dé, Yesu ngê a w꞉ee too, yepê, Lukwe dîy꞉o ala kópu nmye tpapê ngmê, Mbîdédi nmî ngópu daa kwo. Yepê, Lukwe dîy꞉o dnyinté a ka nmye kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yepê, Dini ghi n꞉ii ngê pi yilî nî mbono ngê, yepê, mumdoo yi kópu dmyongê w꞉ee ngópu? Yepê, Dini ghi n꞉ii ngê mbîdédi limi knî munî pwaa too, pi limo yono yono y꞉a u ngwo munî mbono too, yepê, nté kmono péé yémi nmyi ntówo ngópu? ");
INSERT INTO yle_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yepê, Dini ghi n꞉ii ngê mbîdédi pyudu knî mumy꞉aa pwaa too, pi podo yono yono y꞉a u ngwo muy꞉aa mbono too, yepê, nté kmono péé yémi nmyi ntówo ngópu? ");
INSERT INTO yle_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yepê, Lukwe dîy꞉o dmyongê w꞉ee ngópu. Yepê, Dómu ngê daawa ngee nmo. Yepê, Daa mbîdédi p꞉uu nmye n꞉aa mgongo. Yepê, Nmye dmyina a vyuwo. Yepê, Pádisi yoo Sadyusi yoo yi yis ngê kîngî dyênê nmyo. ");
INSERT INTO yle_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yi ngwo p꞉uu ndiye pyu knî y꞉oo yi mgongo mînê w꞉ee ngópu, apê, Daa mbîdédi nk꞉êênî u yis p꞉uu nmo a mgongo. Apê, Pádisi yoo Sadyusi yoo yi kópu dyuu p꞉uu nmo a mgongo. ");
INSERT INTO yle_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu, p꞉uu ndiye pyu knî yi k꞉ii, kada a y꞉ee ngópu, Sisadiya Pilipay wee u kwo lee dniye, wod꞉oo Yesu p꞉uu ndiye pyu knî ye póó wo, yepê, Pi knî ye yinê ye nê n꞉uu? ");
INSERT INTO yle_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kwo, Ngmê knî y꞉oo alanté a tpapê ngmê, Nyi Njon Baptist. Kwo, Ngmê knî y꞉oo alanté a tpapê ngmê, apu, Nyi Ilacha. Kwo, Ngmê knî y꞉oo alanté a tpapê ngmê, apu, Nyi Njedîmaiya. Kwo, Ngmê knî y꞉oo alanté a tpapê ngmê, apu, N꞉ii knî y꞉oo Chóó Lémi u komo wunê dnyimo a kapî, ngmêkêda pyidu, nyi vyîlo. ");
INSERT INTO yle_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu u nkwo ye póó wo, yepê, Nmyinê nmye nê n꞉uu? ");
INSERT INTO yle_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pita ngê kwo, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, nmî Mbwámê ngê a pyódu ngê, nyi vyîlo. Kwo, Yâpwoni ghê a t꞉a, nyi Tp꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu ngê kwo, Saimon, Njóna tp꞉oo. Kwo, M꞉aa ngê ndêndê ngê da ngee ngi. Kwo, Yi kópu daa ṉ́yóó nyinê w꞉ee ngê, daa pi ngê ṉga yinê mye vyu, kwo, M꞉aa ngê yinê ṉga da vyi. ");
INSERT INTO yle_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kwo, Kópu ṉga ngmên꞉aa tpapê. Kwo, Chêêpî kpiyé pââ ndîî ntee a kwo, nyi yinté tpile. Kwo, T꞉ââ ngê d꞉uuwodê y꞉oo, myed꞉uudpî ghêdê kwolo. Kwo, Yinté a yoo kamî yi kn꞉ââ ngê dî pyódu ngi. Kwo, Kópuni u l꞉êê dîy꞉o wanî dy꞉ââ nmyo, yi kópu anmyin꞉aa d꞉uud꞉uu. Kwo, Setan u yoo knî y꞉oo nmyi maa dmi daawa nkoko ngmê, wa dêê dmi, yi pwo wanmyi lee dmi. ");
INSERT INTO yle_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kwo, A yoo yi tpii kââ dmi ṉgêê yedê wanî yé, a ngomo u kii tîpî ṉgêê yedê amy꞉aa yé. Kwo, M꞉aa u pono mb꞉aamb꞉aa ngê anyin꞉aa vyápê. Kwo, Kópuni dyámê mbêmê pi knî ye anyinê kwódu, M꞉aa ngê ye amyedê kwódu. Kwo, Kópuni dyámê mbêmê pi knî ye daanyi kwódu, M꞉aa ngê ye myedaawa a kwódu. ");
INSERT INTO yle_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","U kuwó dini ghi ngê Yesu ngê p꞉uu ndiye pyu knî ye yepê, Pi knî ye nangê vyi, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, n꞉ii nmo t꞉âât꞉ââ, yi pini wunê kî ta. ");
INSERT INTO yle_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Yi ngwo dini ghi ngê Yesu ngê p꞉uu ndiye pyu knî ye u pwopwo p꞉uu danê u kn꞉ââ chópu. Yepê, Dpodoni M꞉aa ngê a ka a kpo, doo u ntââ u wépi daanî puwâ. Yepê, Dîyo Njedusalem wanmî lee dmi, y꞉i nmî kada pini knî y꞉oo wamî mb꞉ii nê. Yepê, Kpêê yiyé pyu yoo yi kada pini knî y꞉oo wa mb꞉ii nê, dêêpî pyu knî y꞉oo wamye mb꞉ii nê. Yepê, Dono kópu yilî a nga wa d꞉uu ngmê, wa vya nê, wo pyoloni ngê amênê pyidu. ");
INSERT INTO yle_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wod꞉oo Pita ngê Yesu u mo kuwa ńuwo, kwo, A Lémi. Kwo, Ye kópu kidimê tpapê. Kwo, Chóó Lémi ka wanyinê ch꞉anê. Kwo, Yinté ṉga daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ngmênê Yesu yi diyé wo, Pita ka kwo, A nkîgh꞉ê a yumwe. Kwo, Nyi Setan ntee pini. Kwo, Kn꞉aa máádi p꞉uu anyi kapî nê. Kwo, Daa Chóó Lémi u komo y꞉ee kapî, ye pi knî yi komo y꞉ee kapî. ");
INSERT INTO yle_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","U kuwó dini ghi ngê Yesu ngê p꞉uu ndiye pyu knî ye yepê, N꞉ii ngê u yi adî kwo, Nê u yoo vy꞉o nî ghê, yi pini ngê choo a yâmuyâmu nê, u gha d꞉ud꞉umbiy꞉e a ka dpo kê ngê, chóó u kópu knî yi p꞉uu mêkîngî nuw꞉o, k꞉omo tpile a l꞉êê dîy꞉o dê pw꞉oo knomomê, ngmênê dpo ngm꞉êê nêne. ");
INSERT INTO yle_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yepê, Pini n꞉ii u ghê p꞉uu adî nuw꞉o, awo, Kîngê vya nê, u ngwo wa kede, a yoo vy꞉o daawa ghê, yepê, yi pini ndêndê ngê wa pw꞉onu, ndê ngê amî ma. Yepê, Pini n꞉ii a l꞉êê dîy꞉o wa pw꞉onu, yi pini amêdê pyidu, ghê kamî u ngwo wa a pyw꞉oo, mb꞉aamb꞉aa ngê adîn꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Yepê, Pini n꞉ii chóó u tpile knî yi p꞉uu adî nuw꞉o, u l꞉êê dîy꞉o Chóó Lémi wa mb꞉ii, yi pini dini ghi n꞉ii ngê wa pw꞉onu, yed꞉oo dono wa a pyw꞉oo. Yepê, K꞉omo tpile dyámê u tpile yintómu yi pini u ngópu adî ya knomomê, ngmênê doo u ntââ ghê kamî u ngwo daawa pwila, dono wa a pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yepê, A kuwó a l꞉êê dîy꞉o adnyi kpadakpada nmyo, ngmênê mu dini ghi ngê a enjel knî yi k꞉ii anmo diyé dmi. Yepê, Yi dini ghi ngê a pi ndîî ngê adî ya, M꞉aa u pi ntoo, a pi yintoo ngê wa pyódu. Yepê, Yoo yi ngwo an꞉uu chámê. Yepê, A yoo mb꞉aa a kêê k꞉oo wanî kaa té, yoo dono wanî kpada té. ");
INSERT INTO yle_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yepê, Ndê kópu nmye ngmên꞉aa tpapê, yepê, Pi knî nmyi vy꞉o ngma a kwo, ghêlî daawa pw꞉oo dmi, noko yewo, Chóó Lémi u Pi Ndêndê u pi ndîî ngê kêdê pyódu, u yoo y꞉enê kn꞉ââ wunê kêdê chaa. ");
INSERT INTO yle_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wo wéni mî loo, u kuwó dini ghi ngê Yesu ngê u dyépi pyile njini mbu mbêmê ńuwo, yi pi dmi Pita, Njems mbwémi Njon. ");
INSERT INTO yle_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","U dyépi pyile knî yi ngópu, Yesu u mo u nâmo ye mînê ghê wo, kââdî ntee a pil꞉apil꞉a yédi, kwódo ng꞉oo dmi yinté ye a pyodo. U kpîdî d꞉ud꞉umbiy꞉e kpaapîkpaapî ngê pyodo, myedoo a wuu mbele. ");
INSERT INTO yle_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yi dini ghi ngê yi pini pyile knî y꞉oo Ilacha pini dê Mósisi Yesu u k꞉ii danêmbum têdê m꞉uu tumo. ");
INSERT INTO yle_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita ngê Yesu ka kwo, A lémi. Kwo, U p꞉o chi yé, cha ńuw꞉o nmo. Kwo, U yi ṉga choo kwo knomomê, ye ngomo pee pyile nînê t꞉emî, kwo, ṉêni ngmê, Mósisi u nêni ngmê, Ilacha u nêni ngmê. ");
INSERT INTO yle_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita ngê danêmbum ghêlî dêpê kêlî ngê, wod꞉oo nkalî too pee kpaapîkpaapî yi pwo ngmê yó. Yi nkalî too pee u mênê dnye ngmê ny꞉ee ngópu, yepê, Kî a tp꞉ee njini, u nuu ghi a nódo a tóó, dye ghi yintómu a nuu u kópu ye d꞉uud꞉uu too. Yepê, U kwo ntênê dmyinê ng꞉aa. ");
INSERT INTO yle_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dini ghi n꞉ii ngê u dyépi pyile knî y꞉oo yi dnyeni yi ny꞉ee ngópu, nkîngê ngê y꞉ay꞉a pwiyé dniye, kwódokwódombiy꞉e têpê mbêmê dyimê dniye. ");
INSERT INTO yle_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Wod꞉oo Yesu ye a loo, kêê yi p꞉uu yó, yepê, Namê nkîngê, a pii dmyeno. ");
INSERT INTO yle_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yi vyu dniye, apê, Pi u chii daa kwo. Apê, Yesu u mo mu kwo. ");
INSERT INTO yle_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mbu paa dini ghi n꞉ii ngê dnya a wupwo, Yesu ngê yepê, Kópuni dmyi m꞉uu ngmê, pi ka ghêlî nangê vyi. Yepê, Kpêênî mwiyé anê pyidu, pi knî ye u ngwo dpî vyi yó. ");
INSERT INTO yle_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wod꞉oo yi tpóknî Yesu ka póó dniye, kwo, Lukwe dîy꞉o dêêpî pyu knî y꞉oo ala kópu a tpapê ngmê, apu, Ilacha mwiyé wa t꞉aa, pini n꞉ii Chóó Lémi ngê a ngmidi ngê, yi pini dîyo kuwó ada a kwo? ");
INSERT INTO yle_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu ngê yepê, Nyââ. Yepê, Ilacha u taataa mwiyé, tpile yintómu yi l꞉âmol꞉âmo u l꞉êê dîy꞉o. ");
INSERT INTO yle_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yepê, Ngmênê ala kópu ny꞉ee yó. Yepê, Ilacha ntee pini wunê kî ta, a maa yinê a yó, ngmênê kada pini knî y꞉oo daa mya ngópu, kópuni dono yi nuw꞉o ngê ye vyu, yi kópu u ngwo d꞉uu ngópu. Yepê, Myenté, yinté kópu a nga amyeyi d꞉uu ngmê. Yepê, K꞉omo tpile nê Chóó Lémi u Pi Ndêndê, ngmênê daa myeme noo. ");
INSERT INTO yle_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ilacha p꞉uu kópuni ye mwiyé a vyu, yi ngwo mînê w꞉ee ngópu, apê, Kî Njon Baptist p꞉uu nmo danêmbum. ");
INSERT INTO yle_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu, u dyépi pyile knî yi k꞉ii, dini ghi n꞉ii ngê yoo vy꞉o mêdê diyé dniye, pi ngmê Yesu ka a loo, yu mbodo dê y꞉e k꞉ame u kwo ghê wo, ");
INSERT INTO yle_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kwo, A lémi. Kwo, U ntââ a tp꞉ee ṉga wa ch꞉anê? Kwo, Nyuno pwopwo u ngwo a t꞉a, a mgînî vyîmî ndîî yédi. Kwo, Dye ghi knî ngmê ngê ndiya dpî d꞉ii, dye ghi knî ngmê ngê mbwaa paa dpî d꞉ii. ");
INSERT INTO yle_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kwo, M̱꞉uu ndiye pyu knî ye kîd꞉a ńuw꞉o, ngmênê a ka doo pyi ngópu. ");
INSERT INTO yle_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu ngê yepê, Nmyo yoo dono, lukwe dîy꞉o Chóó Lémi ka dp꞉ee kêlîmî té? Yepê, M꞉ââ yémi nmyi vy꞉o anî kwo, u dî Chóó Lémi ka mb꞉aamb꞉aa ngê anmyin꞉aa kêlîmî? Yepê, Yi tpémi a ka a ńuw꞉o yó. ");
INSERT INTO yle_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yi tpémi ngê kmênani dpîmo kwo, Yesu ngê ngm꞉ii kwólu, yi tpémi yi ngwo mê pyiyé wo. ");
INSERT INTO yle_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Dini ghi n꞉ii ngê Yesu p꞉uu ndiye pyu knî yi k꞉ii yi mo dnyen꞉aa ya, u kwo póó dniye, kwo, Lukwe dîy꞉o dp꞉oo u ntââ dé, yi kmêna dp꞉oo ngm꞉ii kwólu? ");
INSERT INTO yle_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu ngê yepê, Mu kópu u dîy꞉o nmyi kêlîmî têdê. Yepê, Ndê kópu nmye ngmên꞉aa tpapê, yepê, Chipa w꞉uu u mênê w꞉uu n꞉ii a kwo, yi tpile daa ndîî tp꞉oo, apii? Yepê, Nmyi kêlîmî wo yintoo, ye kî mbwini ka pîdmyi vyi ngmê, Kada a yéni, mwada y꞉i nyi ghé, yepê, yi kópu ntênê paa d꞉uu, mwada y꞉i paan꞉aa ghê. Yepê, Kópu ngmê doo u ntââ ngê nmye daapê tóó. ");
INSERT INTO yle_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(-) ");
INSERT INTO yle_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dini ghi n꞉ii ngê Yesu, p꞉uu ndiye pyu knî yi k꞉ii, Nkálili Wee u kwo mê diyé dniye, Yesu ngê p꞉uu ndiye pyu yoo nipi a danê too, yepê, K꞉omo tpile nê Chóó Lémi u Pi Ndêndê, ngmênê yoo dono yi kêê k꞉oo wanî ghê. ");
INSERT INTO yle_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Yepê, Yi yéli y꞉oo wa vya nê, ngmênê wo pyoloni ngê amênê pyidu. Yi ngwo p꞉uu ndiye pyu yoo yi nuw꞉o dmi d꞉ud꞉umbiy꞉e dono ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Dini ghi n꞉ii ngê Yesu, p꞉uu ndiye pyu knî yi k꞉ii, Kîpêêniyêm mî taa dniye, n꞉ii knî y꞉oo Chóó Lémi u ngomo u l꞉êê dîy꞉o tákisi dnyimo a ngêêpî, yi yéli Pita ka knî ngmê loo, u kwo póó dniye, kwo, Nmyi kada pini ngê Chóó Lémi u ngomo u l꞉êê dîy꞉o tákisi a pywupwi ngê, apii? ");
INSERT INTO yle_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita ngê yepê, Nyââ. Wod꞉oo Pita ngomo k꞉oo mî kee wo. U yi u ngwo doo kwo, Yesu ka n꞉uu póó, ngmênê ghêlî u kwo daa póó wo, Yesu u kwo mwiyé póó wo, kwo, Saimon. Kwo, Ṉuwo lónté a tóó? Kwo, Dyámê mbêmê king knî ye tákisi ló yéli y꞉oo a pywupwi ngópu? Kwo, Yi tp꞉ee knî y꞉oo, ó kn꞉aa yéli y꞉oo? ");
INSERT INTO yle_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita ngê kwo, Kn꞉aa yéli y꞉oo y꞉oo a pywupwi ngópu. Yesu ngê kwo, Ndê kópu. Kwo, Yi chóó yi tp꞉ee knî y꞉oo tákisi ye daa pywupwi ngópu. Kwo, Nê king ndêndê tp꞉oo, u l꞉êê dîy꞉o u ngomo tákisi daanî pwila. Kwo, A yoo kamî mye yi king ndêndê tp꞉oo yoo, u l꞉êê dîy꞉o tákisi myedaawa pwila ngmê. ");
INSERT INTO yle_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kwo, Ngmênê u ya a nga daa kwo, Wu tákisi ngêêpî pyu knî y꞉oo mb꞉ii nmîne. Kwo, Chi lêpî, kpé lêê u nkîgh꞉ê chin꞉aa kpîpî. Kwo, Mwiyémwiyé téni n꞉ii che dóó knomomê, ndapî u kwo ngmênyinê pyw꞉êmî, kwo, nyi tákisi u ntââ ndapî. Kwo, Nyi tákisi u ngwo dp꞉uu pwila ngi. ");
INSERT INTO yle_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yi dini ghi ngê Yesu ka p꞉uu ndiye pyu yoo a lee dniye, u kwo póó dniye, kwo, Ṉyoo kamî yi vy꞉o, n꞉uu kada pini ngê angmê pyódu? ");
INSERT INTO yle_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu tp꞉ee ngmê ka mbwolo, yi ngîma kââ, ");
INSERT INTO yle_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yepê, Ala tpémi u lama lémi lémi daa tóó. Yepê, Lukwe dîy꞉o nmyo ngmêngmênté nmyi nuw꞉o dmi alanté a tóó, nmyimo, Yoo yi kada nmî ghê dmi. Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Nmyi nuw꞉o dmi daanmyi ngmêê knomomê, ala tpémi u nt꞉anê daanmyi yaa knomomê, ye M꞉aa kóó k꞉oo daanmy꞉uu ghê dmi. ");
INSERT INTO yle_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yepê, N꞉ii ngê lémi lémi ngê kêê d꞉uuwodê t꞉oo, ala tpémi ntee tpémi ngê adî ya, yepê, yi pini kada pini ngê vyîlo ayi pyódu. ");
INSERT INTO yle_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yepê, Pini n꞉ii alanté tpémi ka a l꞉êê dîy꞉o adî vyuwo, daa yi tpémi ka u mo adî vyuwo, ngmênê a ka amyeda a vyuwo, amyedî chââchââ nê. ");
INSERT INTO yle_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesu ngê yepê, Tpémi dmââdîni yoo a ka wunê kêlîmî té, pi ngmê ngê yi kêlîmî l꞉âmo kîdangmê ngee. Yepê, Mu dini ghi ngê Chóó Lémi ngê yi pini dnyinté daawa kpada. Yepê, Pi knî y꞉oo yi pini mwiyé wo mgîmî ngópu, chêêpî pââ ndîî nódo ngmêwo kudu ngópu, mbéli u kwo wumê kalê ngópu, ye yi dono ndîî daapî d꞉uu ngê, Chóó Lémi ngê dpodombiy꞉e daapaa kpada. ");
INSERT INTO yle_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yepê, Kópuni knî yi l꞉êê dîy꞉o pi knî y꞉oo maa mb꞉aa wa kn꞉aadi ngmê, yi kópu dyuu maa nkîgh꞉ê adnyi kwo, ngmênê n꞉ii ngê yinté kópu a maa u nkîgh꞉ê ngmada a ńeńe, yi pini d꞉ud꞉umbiy꞉e choo nkîngê. ");
INSERT INTO yle_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yepê, Máádini p꞉uu anmyi ghê dmi, ó kópuni anmyi d꞉uud꞉uu, yi kópu u l꞉êê dîy꞉o wanmyi mb꞉ii nê, mu dini ghi ngê ndiya anmy꞉uu ghêpê dmi, yi ndyuw꞉e daawa pw꞉onu. Yepê, Yi kópu u kwee mwiyé anmyinê châpwo ngmê, yed꞉oo daanmyi mb꞉ii nê, mu dini ghi ngê ghê kamî anmyimo pyw꞉ee ngmê, a kêê k꞉oo anmyin꞉aa kwo. Yepê, K꞉omo tpile maa woni knî nmti lama daadnyi ya, kópu woni knî daanmyi d꞉uu t꞉oo, ngmênê ghê kamî wanmyimo pyw꞉ee ngmê, a kêê k꞉oo anmyin꞉aa kwo. ");
INSERT INTO yle_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yepê, Tpileni nmyi ngwolo knî y꞉oo wa m꞉uu ngmê, yi p꞉uu anmyi nuw꞉odono, yed꞉oo wanmyi mb꞉ii nê, mu dini ghi ngê ndiya anmy꞉uu ghêpê dmi. Yepê, Yi nuw꞉odono u kwee lîmîlîmî ngê anmyi châpwo ngmê, yed꞉oo daanmyi mb꞉ii nê, mu dini ghi ngê mb꞉aamb꞉aa ngê anmyin꞉aa ya, Chóó Lémi mb꞉aamb꞉aa ngê nmye adîn꞉aa a vyuwo. ");
INSERT INTO yle_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesu ngê yepê, Yélini yi pi dmi daa ndîî, ye mb꞉aamb꞉aa ngê dmyina a vyuwo. Yepê, K꞉omo tpile ngê nmye wa pyaa knomomê, ye Chóó Lémi ngê u nkwo wa kpada nmyo. Yepê, Yi yéli yi enjel yoo yi l꞉êê dîy꞉o dye ghi yintómu Chóó Lémi ka a ngêpê nyédi. ");
INSERT INTO yle_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(-) ");
INSERT INTO yle_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yepê, Dyimê pywuu nmye ngmênînê kuwo, p꞉uu dmyinê nuw꞉o. Yepê, Pi ngmê, u sipi yonoy꞉a adî kwo. Yepê, W꞉amî mbêmê wa ńuw꞉o té, y꞉i adnyin꞉aa kmaapî. Yepê, Ntumokwodo dini ghi ngê, awo, P꞉o m꞉aa ńuw꞉o té. Yepê, Dini ghi n꞉ii ngê wa a kp꞉aa té, yonoy꞉a daawa m꞉uu knomomê, tonoy꞉a mê chu ayi m꞉uu knomomê, lukwe, ye ala kópu wa vyi, awo, Yonoy꞉ani mwo a p꞉aa, monyi pw꞉oo we? Yepê, Doo u ntââ, yi kópu daawa vyi. Yepê, Tonoy꞉a mê chu kmaapî têdê wa a kuwo té, yonoy꞉ani adîn꞉aa nmy꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yepê, Ayimênê pyw꞉ee knomomê, u gha d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê wa pyódu, woni knî yi p꞉uu daadî nuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yepê, Myenté, nmyi Mî ngê u yi daa kwo, Yélini yi pi dmi têdê yi l꞉âmo ngmênê ngee. ");
INSERT INTO yle_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Nmyi mbwó ngmê ngê dono kópu nmyi vy꞉o pini ngmê ngê angmê d꞉uu knomomê, ye yi pini u mbwó ka tumu dpî lee we, yi kópu u kwo dp꞉uu vyi ngê, yi pini dê y꞉oo yi kópu yi mo moo chedê y꞉e. Yepê, U mbwó u kwo wa ng꞉aa mbê knomomê, ye nipi modo kââdî y꞉e. ");
INSERT INTO yle_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yepê, U kwo daawa ng꞉aa mbê knomomê, ye yi pini ngê u mbwó ngmidi ó miyó dpî nya ngê, yi mbwó ka dpî lee dniye, yi kópu dp꞉uu l꞉âmo y꞉e. Yepê, Yi pini ye myedaawa ng꞉aa mbê knomomê, ye yi pini pyile knî y꞉oo kópu mu ngmidi pi knî ye dp꞉uu vyi y꞉e. ");
INSERT INTO yle_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yepê, Yélini yi p꞉aani a yoo vy꞉o adnyi kwo, dpo danê teńe, yi ngópu nmyi mbwó dpî kóté kalê yó. Yepê, Yi pini a yoo yintómu knî ye daawa ng꞉aa mbê knomomê, ye yi pini a yoo kuwa dpî kaa y꞉e, pi tupwótupwó ngê ye dpî pyaa we, tákisi ngêêpî pyu ntee pini ngê ye myoo pyaa we. ");
INSERT INTO yle_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yesu ngê p꞉uu ndiye pyu knî ye yepê, M꞉aa u pono mb꞉aamb꞉aa ngê anmyin꞉aa vyápê. Yepê, M꞉aa ngê kópuni a yoo knî yi l꞉êê dîy꞉o mbóó p꞉uu wa a kwódu, yi kópu wanmyinê w꞉ee ngmê, a yoo knî ye dyámê mbêmê anmy꞉uu kwódu ngmê. Yepê, Kópuni M꞉aa ngê yi l꞉êê dîy꞉o mbóó p꞉uu daawa a kwódu, dyámê mbêmê ye daanmy꞉uu kwódu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Kópuni u l꞉êê dîy꞉o nmyi vy꞉o pini miyó dê y꞉oo yi nuw꞉o ngmidi ngê wa pyódu ngmê, dyámê mbêmê u l꞉êê dîy꞉o adpo a ngêpê, M꞉aa ngê yi kópu ndêndê ngê yi l꞉êê dîy꞉o wa a d꞉uu, mbóó p꞉uu, ");
INSERT INTO yle_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","mu kópu u dîy꞉o a yoo vy꞉o pi miyó pyile nipi adnya a ngêpê, daa yi mo adnyi ya, yi vy꞉o amy꞉aa kwo. ");
INSERT INTO yle_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yi ngwo dini ghi ngê Pita Yesu ka póó wo, kwo, A Lémi, a mbwó ngê dono kópu a nga ngmêwa d꞉uu knomomê, ye a kuwó wanî kéé, mêdaanê ngî. Kwo, Ngmênê yi pini ngê yi dono kópu a nga amêdê d꞉uud꞉uu, kwo, mumdoo pyud꞉o yi kópu a nga amê d꞉uu, ntââ myedaanê vy꞉u? ");
INSERT INTO yle_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu ngê kwo, Pyud꞉o doo u ntââ. Kwo, Ye têdê. Kwo, Pyud꞉oy꞉a mye têdê. Kwo, Dye ghi yintómu yi dono ṉguwó chi kéké, ntââ nangê vy꞉u, yi dono ṉódo myekîngê kaalî. ");
INSERT INTO yle_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwo, M꞉aa ngê u yoo ntee wunê y꞉enê, yi kópu p꞉uu dyimê pywuu ṉga ngmênînê kuwo. Kwo, Ala danêmbum p꞉uu chi nuw꞉o. Kwo, King ngmê, u dpodo pyu yilî doo ya. Kwo, Woni knî y꞉oo ndapî knî u kwo ngmê dmy꞉ee ngópu, ghêlî k꞉ii u kwo daa wumo tumo. Kwo, Wo ngmê ngê yi king ngê u yi doo kwo, A dpodo pyu knî y꞉oo yi tp꞉uu dmi a piy꞉e yi chóó wumo teńe. ");
INSERT INTO yle_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kwo, Woni knî y꞉oo yi tp꞉uu yilî chedê tumo, ngmênê pi ngmê doo u ntââ ngê doo ya, u tp꞉uu mo daa mo tp꞉oo komo. ");
INSERT INTO yle_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kwo, Doo u ntââ yi pini ngê u tp꞉uu daapêdê kêlî ngê, wod꞉oo yi king ngê u dpodo pyu knî ye yepê, Kî pini mgîmî yó, u tpile yilî yintómu dpî nya tóó, a ka dpî ńuw꞉o tóó. Yepê, Kn꞉aa yélî y꞉oo a ka wa pwila t꞉oo. Yepê, Kn꞉aa pini ngmê ngê kî pini mupwoknî a ka wa pwila té, wop p꞉uu adnyin꞉aa dpodo. ");
INSERT INTO yle_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kwo, Yi pini yu mbodo dê y꞉e king ka k꞉ame ghê wo, kwo, Ye kópu a nga kidingê d꞉uu, mwiyé chi t꞉ââ, a tp꞉uu yilî dîyo wanê wumo. ");
INSERT INTO yle_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yesu ngê kwo, Yi pini king ka ch꞉anê wo, wod꞉oo yi king ngê yi pini u tp꞉uu yilî chóó mêdê kêlî ngê, yi pini mê kwólu. ");
INSERT INTO yle_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kwo, Dini ghi n꞉ii ngê yi pini kuwa pwii wo, dpodo pyu ngmê módu, pini n꞉ii u tp꞉uu têdê. Kwo, Dpodombiy꞉e u kwo mbwolo, kwo, A piy꞉e chi wumwe. ");
INSERT INTO yle_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yi pini yu mbodo dê y꞉e k꞉ame u kwo ghê wo, kwo, Mwiyé chi t꞉ââ, a tp꞉uu dîyo wanî wumo. ");
INSERT INTO yle_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yesu ngê kwo, Ngmênê yi pini u kwo daa ch꞉anê wo, mgîmî ngê, mbwa k꞉oo kmungo, kwo, Dini ghi n꞉ii ngê a ndapî any꞉uu wumo, kuwa u ngwo any꞉uu pwii. ");
INSERT INTO yle_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yesu ngê kwo, Dini ghi n꞉ii ngê king u dpodo pyu knî y꞉oo yi kópu ny꞉ee ngópu, nod꞉e dniye, king ka yuu mînê y꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kwo, Wod꞉oo king ngê yi pini ka u lede yoo dy꞉ââ too, yepê, Yi pini a ka a ńuw꞉o yó. Kwo, Dini ghi n꞉ii ngê u kwo ńuw꞉o ngópu, kwo, D꞉ii gha pi. Kwo, A piy꞉e ṉ́m꞉uu pââ ndîî ngmêdoo kwo, a chóó m꞉aa chedê ngê. ");
INSERT INTO yle_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kwo, Wu pini u tp꞉uu m̱iy꞉e daa ndîî ye kwo, lukwe dîy꞉o ṉga doo ch꞉anê wo. Kwo, Kópuni ṉga dî d꞉uu, lukwe dîy꞉o wu pini ngê choo d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yesu ngê kwo, Yi king yi pini ka d꞉ud꞉umbiy꞉e nod꞉e wo, mbwa k꞉oo kmungo, kwo, Ṉ́m꞉uu yilî a piy꞉e any꞉uu wumo, mbwa u mênê u ngwo any꞉uu pwii. ");
INSERT INTO yle_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu ngê yepê, Dono kópuni nmyi mbwó knî y꞉oo nmye wa d꞉uu t꞉oo, nmyi kuwó daanmyi kéé t꞉oo, ye M꞉aa ngê yinté kópu nmye ayimî d꞉uu, nmyi dono u kuwó daawa kéé té. Yepê, Myenté, yepê, yoo yi dono kópu nmyi nódo kîngmê ya. ");
INSERT INTO yle_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Dini ghi n꞉ii ngê Yesu ngê yi danêmbum a kêlî ngê, p꞉uu ndiye pyu knî yi k꞉ii Nkálili Wee a kuwo ngópu, Njuda Wee u kwo mî lee dniye, Njódan mbwááni mê ngmêê ngópu, Pédiya Wee u kwo mî taa dniye. ");
INSERT INTO yle_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pi yilî tp꞉oo témi tap knî y꞉oo dnye yâmuyâmu dé. Pwopwokopwe yoo n꞉ii u kwo ńuw꞉o tumo, Yesu ngê pyi too. ");
INSERT INTO yle_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pádisi yoo u kwo ngmê loo, u yi y꞉e doo kwo, Yesu danêmbum têdê nmî dóó, kwo, Nmî dêêpî kópu dyuu lónté a kwo, kwo, u ntââ mââ ngê kópu yilî yintómu yi l꞉êê dîy꞉o u kpâm wa kpîpî? ");
INSERT INTO yle_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu ngê yepê, Kópuni puku yedê a tóó dmyongê kp꞉aa ngópu? Yepê, Mwiyémwiyé dini ghi ngê, Chóó Lémi ngê pyââ mââ l꞉âmo doo, yepê, Noko mb꞉aamb꞉aa ngê choo ya. ");
INSERT INTO yle_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yepê, Yi kópu u l꞉êê dîy꞉o mââ u pye mî yi kêlê dpo pwii, u kpâm k꞉ii ngmidi ngê dpî pyaa knî. ");
INSERT INTO yle_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yepê, Wod꞉oo yéé yepe daa miyó a tóó, ngmênê mu ngmidi. Yepê, Cha cha n꞉ii Chóó Lémi ngê dpo kââdî dê, pi ngê d꞉uudpî chámê dê. ");
INSERT INTO yle_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pádisi knî y꞉oo Yesu ka kwo, Lukwe dîy꞉o Mósisi ngê ala dêêpî kópu dyuu nmo a kpo, apê, Mââ ngê u kpâm dî kpîpî knomomê, u kópu dyuu dpî d꞉êê ngê, u kwo dpî y꞉ee ngê, u ngwo dpî dy꞉ââ ngê. ");
INSERT INTO yle_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu ngê yepê, Mósisi ngê yi kópu nmye mu d꞉êê ngê, mu kópu u dîy꞉o nmyi kpâm knî ye vyuwo dnyinté nmyi lama a tóó, Chóó Lémi u dnye dnyinté my꞉ee nyêmî ngópu. Yepê, Ngmênê mwiyékmîntoo Chóó Lémi ngê u yi u ngwo dêpwo kwo, Mââ ngê u kpâm choo kpîpîkpîpî. ");
INSERT INTO yle_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yepê, Ala kópu nmye n꞉aa tpapê, pini n꞉ii u kpâm u tumu mââ daadî ya, yi pini ngê u kpâm kîngî kpîpî, kn꞉aa pyópu kîmungê nya. Yepê, Wa kpîpî knomomê, kn꞉aa pyópu muwa nya knomomê, ye daa yééyéé u kópu ayi d꞉uu, ngmênê pyââ ti u kópu ayi d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesu p꞉uu ndiye pyu knî y꞉oo Yesu ka kwo, Mumdoo cha cha yi kópu dyuu yinté a kwo knomomê, ye pi ngê pyââ kîmungê nya. ");
INSERT INTO yle_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu ngê yepê, M꞉aa u kópu wunê nmye kîdî vyi, nmyedê, Mââ u pye mî yi kêlê dpo pwii, u kpâm k꞉ii ngmidi ngê dpî pyaa knî. ");
INSERT INTO yle_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yepê, Ngmênê pi woni knî y꞉e yi kópu doo u ntââ, d꞉uudpî yéé dmi. Yepê, Knî ngmê yinté a taa dniye, knî ngmê pi knî y꞉oo doo u ntââ ngê dpî pyódu t꞉oo, knî ngmê a p꞉uu dpodo u l꞉êê dîy꞉o d꞉uudpî yéé dmi. Yepê, N꞉ii ka yi kópu u ntââ, yi pini ngê choo d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pi knî y꞉oo Yesu ka yi tp꞉ee dmââdîma ńuw꞉o tumo, apê, Kóó yi mbêmê nyi yé ngê, yi l꞉êê dîy꞉o myechoo ngêpê. Yesu p꞉uu ndiye pyu knî y꞉oo yi kópu ye kwódu ngópu, ");
INSERT INTO yle_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ngmênê Yesu ngê yepê, A ka a ńuw꞉o teńe, ye namê kwódu yé, mu kópu u dîy꞉o tp꞉ee dmââdîma ntee yéli Chóó Lémi ngê chóó adî y꞉enê dé. ");
INSERT INTO yle_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wod꞉oo Yesu ngê kêê yi mbêmê doo yiyé, yi l꞉êê dîy꞉o myedoo ngêpê. U kuwó dini ghi ngê p꞉uu ndiye pyu yoo yi k꞉ii kada a y꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pi ngmê Yesu ka loo, u kwo póó wo, kwo, Mââwe. Kwo, Ló kópu mb꞉aa ngmanî d꞉uu, ghê kamî u ngwo anê pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu? ");
INSERT INTO yle_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu ngê kwo, Lukwe dîy꞉o kópu mb꞉aa p꞉uu a ka chi póó. Kwo, Pi chóó mb꞉aamb꞉aa ngê daawa pyódu, Chóó Lémi mu ngmidi yi mb꞉aamb꞉aa. Kwo, Ghê kamî u pyw꞉êmî u yi ṉga choo kwo knomomê, ye Chóó Lémi u dêêpî kópu dyuu chi chââchââ. ");
INSERT INTO yle_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yi pini ngê kwo, Ló dêêpî kópu knî yi p꞉uu a ka nye mbumu? Yesu ngê kwo, Pi nangmê vy꞉a, pi u kuwó nangmê pwiyé, pi u tpile nangmê t꞉âmo, pi nangmê yipe, pi nangmê dóó, ");
INSERT INTO yle_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","m̱ye m̱î chi chââchââ dê. Kwo, Ṉ́yóó ṉuu ghi ṉódo ntee a tóó, yoo yi nuu ghi dmi ṉódo yinté myechoo ya. ");
INSERT INTO yle_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yi pini ngê kwo, Yi kópu dyuu n꞉aa chââchââ too, ló kópu ngmê ngê doo u ntââ ngê n꞉aa tóó? ");
INSERT INTO yle_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu ngê kwo, U yi ṉga a kwo, nyimo, D꞉ud꞉umbiy꞉e u ntââ mbêmê nî yââ, kwo, ye chi lêpî, kwo, tpile yilîni ngópu a tóó, ngópuch꞉anê knî ye nyi yéépi, yed꞉oo dpo ngm꞉êê nédi, cha a yâmuyâmu nê, kwo, ya mb꞉aa mbóó p꞉uu u ngwo anyimo pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dini ghi n꞉ii ngê yi pini ngê yi kópu nyongo, u gha dono ngê pyodo, apê, A tpile yilî angênté anî yêê, wod꞉oo Yesu a kuwo ngê, mu kópu u dîy꞉o ndáápi ndîî, u tpile yilî. ");
INSERT INTO yle_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu ngê p꞉uu ndiye pyu knî ye yepê, N꞉ii ndáápi ndîî, a maa p꞉uu paa dpodo ndîî ngê u kwo wa pyódu, Chóó Lémi kóó k꞉oo angênté amî ghê. ");
INSERT INTO yle_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yepê, Ala kópu mye ny꞉ee yó. Yepê, Mbwêmê ndîî, tee kn꞉ââ puu u mênê daawa kee, yepê, myenté Chóó Lémi kóó k꞉oo ndáápi d꞉uudpî ghê. ");
INSERT INTO yle_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","P꞉uu ndiye pyu knî y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, ghê yi mênê ghipé wo, noko yepê, Wu lónté kópu? Noko yepê, Ndáápi yoo Chóó Lémi kóó k꞉oo daangmêwa ghê knomomê, ye n꞉uu ngmê u ntââ y꞉i amî ghê? ");
INSERT INTO yle_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu ngê doo y꞉enê dé, yepê, Doo u ntââ Chóó Lémi kóó k꞉oo pi chóó daangmêmî ghê, ngmênê Chóó Lémi chóó u ntââ, pi chóó kóó k꞉oo wa kââ. Yepê, Kópu yilî yintómu Chóó Lémi u ntââ. ");
INSERT INTO yle_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita ngê Yesu ka kwo, Mââwe. Kwo, Tpile yilî yintómu nmo kuwo ngê, anmînê yâmuyâmu ngi. Kwo, Yi kópu u l꞉êê dîy꞉o ló kópu ngmanmo pyw꞉oo? ");
INSERT INTO yle_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Dini ghi n꞉ii ngê tpile yilî yintómu kamî ngê anî pyódu té, yi ngwo a pi ndîî ngê wa pyódu, pi yintómu yi kada pini ngê anê pyódu, mu kópu u dîy꞉o nê Chóó Lémi u Pi Ndêndê. Yepê, Yi ngwo Yisîléli tpémi yi yoo dyêêdî y꞉a mê miyó wanmyi y꞉enê dé, mu kópu u dîy꞉o nmyinê yâmuyâmu nê. ");
INSERT INTO yle_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yepê, Pini n꞉ii ngê a l꞉êê dîy꞉o u p꞉aa dpo kuwo, u tîdê mbwó yoo dpo kuwo té, u pye mî dpo kuwo dê, u tp꞉ee dmââdîma dpo kuwo té, u yâpwo têdê dmi myedo kuwo té, yepê, yi pini ngê yinté tpile mê yilî amêdê pyw꞉oo. Yepê, Pini n꞉ii ngê a kópu dyuu u l꞉êê dîy꞉o tpile ngmidi wa a kuwo, yepê, yi pini ngê yinté tpile mê yono y꞉a amêdê pyw꞉oo. Yepê, Mu dini ghi ngê yi pini ngê ghê kamî amînê pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yepê, Kada yéli mê kuwó, kuwó yéli mê kada. Yepê, Ala ngwo ndáápi yoo kada a wee, ngmênê dîyo kuwó amêdê ghê dmi. ");
INSERT INTO yle_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu ngê p꞉uu ndiye pyu knî ye mgongo ngmê kwólu, yepê, M꞉aa ngê u yoo ndêndê alanté adî y꞉enê. Yepê, Wain kpê chóó ngmê ngê u yi u ngwo doo kwo, Pi knî ngmê a wain kpê u mênê dny꞉oon꞉aa dpodo. Yepê, Mw꞉aandiye pi knî ngma a pyw꞉ângo, ");
INSERT INTO yle_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","yepê, A wain kpê u mênê dmyinên꞉aa dpodo, awêde nmye mînî pywupwi, pi ngmê ndapî ngmê. ");
INSERT INTO yle_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yesu ngê yepê, U kuwó dini ghi ngê kââdî liy꞉aa pyile mî loo, pi knî m꞉uu a pyw꞉ângo, apê, Módó mu wee, daa dpodo té. ");
INSERT INTO yle_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yepê, A wain kpê u mênê dmyinên꞉aa dpodo, yi dpodo ntênê nmye n꞉aa pywupwi, daanî dóó nmyo. ");
INSERT INTO yle_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yesu ngê yepê, Wod꞉oo lee dniye. Yepê, Kââdî mââ kêlî pi knî m꞉uu a pyw꞉ângo, yi kópu yinté ye mye vyu, dpodo têdê dy꞉ââ too. Yepê, Dini ghi n꞉ii ngê kââdî t꞉ono mî ghê wo, pi knî m꞉uu a pyw꞉ângo, yi kópu yinté ye mye vyu, dpodo têdê dy꞉ââ too. ");
INSERT INTO yle_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yepê, Dini ghi n꞉ii ngê apê, Kââdî liy꞉aa mu ngmidi ngee tóó, apê, kââdî u ngwo a wupwo, yepê, yi ngwo pi knî m꞉uu a pyw꞉ângo, yepê, Lukwe dîy꞉o wo módó dmyi chedê ngmê? ");
INSERT INTO yle_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kwo, Pi ngê doo dpodo kalê nmoo. Yepê, A wain kpê u mênê dmyinê lêpî, y꞉i dmyinên꞉aa dpodo. ");
INSERT INTO yle_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Yesu ngê yepê, Dini ghi n꞉ii ngê ntumokwodo dini ghi yi yó, wain kpê chóó ngê dpodo u y꞉enê pyu ka kwo, Dpodo pyu yoo a pwiyé dniye. Kwo, Yi dpodo u pywuu ye yéni. Kwo, Yélini dpodo têdê kuwó dê lee dmi, yi pywuu ye mwiyé yéni. Kwo, Yélini mwiyé dê lee dmi, yi pywuu kuwó ye dpî yéni. ");
INSERT INTO yle_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Yesu ngê yepê, Yélini dpodo têdê kuwó lee dniye, wo d꞉umu u dpodo u pywuu ngmêngmênté a ngee ngópu, pi ngmê ndapî ngmê. ");
INSERT INTO yle_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yepê, Yélini mw꞉aandiye dpodo têdê mwiyé lee dniye, alanté dnye nuw꞉o, apê ngmênê, Ndapî ndîî yinmînê ngêêpî, ngmênê vyîlo yintoo ndapî myeyedê ngee ngópu, pi ngmê ndapî ngmê. ");
INSERT INTO yle_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yepê, Dini ghi n꞉ii ngê yi ndapî a ngee ngópu, wain kpê chóó ka nod꞉e dniye, ");
INSERT INTO yle_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","kwo, Kî yéli kââdî liy꞉aa mu ngmidi chi dpodo kalê té, ngmênê mw꞉aandiye dpo yaa dmi, kââdî ndîî vy꞉o nmî dpodo té. Kwo, Lukwe dîy꞉o ngmidi mbêmê chi pwila nmo. ");
INSERT INTO yle_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yepê, Wain kpê chóó ngê ngmê ka kwo, Kî pini. Kwo, D꞉oo dóó nyoo. Kwo, Kópuni ṉga dî vyi, ntênê kîdî d꞉uu, ndapî ṉga ngmêkîd꞉a kê. ");
INSERT INTO yle_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kwo, Ṉapî ṉgêê yedê choo ya, p꞉o chi lêpî. Kwo, U ya a nga a kwo, Kuwó pini kada pini mu ngmidi mbêmê nî pwila dê. ");
INSERT INTO yle_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kwo, A chóó a ndapî ngê dî pwila nmyo. Kwo, Ṉ́yóó ṉuw꞉o u pono daanî vyápê mb꞉anê. Kwo, D꞉aa mtîkó pyu, módó dî yeede té. Kwo, Lukwe dîy꞉o ń꞉ee ye chi kââ? ");
INSERT INTO yle_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Wod꞉oo Yesu ngê p꞉uu ndiye pyu knî ye yepê, Kada yéli mê kuwó, kuwó yéli mê kada. Yepê, A yoo vy꞉o mwiyé nmyi ghê dniye, kuwó yéli ye ń꞉ee nangê kââ. ");
INSERT INTO yle_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Dini ghi n꞉ii ngê Yesu p꞉uu Njedusalem dnye lêpî, Yesu ngê p꞉uu ndiye pyu y꞉a mê miyó yoo vy꞉o a pw꞉ii too, maa p꞉uu yepê, ");
INSERT INTO yle_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ala kópu ny꞉ee yó. Yepê, K꞉omo tpile nê Chóó Lémi u Pi Ndêndê, ngmênê dini ghi n꞉ii ngê Njedusalem anm꞉uu taa dmi, kpêê yiyé pyu yoo yi kada pini yoo, dêêpî pyu yoo yi k꞉ii, a vyee u dy꞉oo wa a châpwo ngmê, wa mgîmî nê, wa kóté kalê nê, wamye ch꞉ee nê, Lóma tpémi yi kêê k꞉oo wa kaa nê. ");
INSERT INTO yle_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yepê, Yi tpóknî y꞉oo wadnyi nkwitinkwiti nê, wadnyi kpakakpaka nê, kîdosi ńedê wa t꞉ee nê, yinté wa vya nê, yepê, ngmênê wo pyoloni ngê wamênî pyidu. ");
INSERT INTO yle_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","U kuwó dini ghi ngê Sepédi kpâm ghee knî Yesu ka lee dniye, yi pye yu mbodo dê y꞉e k꞉ame u kwo ghê wo, yi pye ngê kópu ngmê u pyinê u kwo ngwódu. ");
INSERT INTO yle_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu ngê kwo, Lukwe u yi ṉga ngma a kwo? Yi pyópu ngê kwo, Dini ghi n꞉ii ngê m̱i ndîî ngê wa pyódu, Chóó Lémi u yoo anyi y꞉enê, kwo, a tp꞉ee dê ṉyoo yi kada pini ngê dpî pyódu dé. ");
INSERT INTO yle_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu ngê kwo, Kópuni a ka chi dmyinê, daa ḻama chi mbwólu. Tp꞉oo dê ye yepê, Dpî u ntââ dê, pi knî y꞉oo kópuni a nga wa d꞉uu ngmê, u ntââ dpo amye d꞉uu ngmê? Kwo, Nyo u ntââ dê. ");
INSERT INTO yle_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu ngê yepê, Kópuni pi knî y꞉oo a nga wa d꞉uu ngmê, ndêndê ngê dpo amye d꞉uu ngmê, ngmênê doo u ntââ a che p꞉ââ pee a chóó daanî ngmidi. Yepê, M꞉aa ngê yi kópu yinê wa a vyi. Yepê, Pini n꞉ii kada adî kwo, yi pini wunê ka a ngmidi ngê. ");
INSERT INTO yle_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesu p꞉uu ndiye pyu yoo wo y꞉a knî y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, Njems mbwémi Njon ye nod꞉e dniye. ");
INSERT INTO yle_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Wod꞉oo Yesu ngê p꞉uu ndiye pyu yoo nipi a danê ngê, yepê, Nmyi lama a tóó, Yélini daa Nju tpémi, yi vy꞉o pini n꞉ii kada pini ngê dpî pyódu, a lémilémi yédi, yoo yinê a y꞉enê ngê, yinê a dpodo kîgha too. ");
INSERT INTO yle_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Yepê, Ngmênê nmyi vy꞉o yinté daadî ya. Yepê, Nmyi vy꞉o pini n꞉ii ngê u yi adî kwo, Kada pini ngê nî pyódu, yi pini ngê choo ngêêpî nmyo, nmyi p꞉uu choo dpodo. ");
INSERT INTO yle_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yepê, K꞉omo tpile Chóó Lémi ngê a ngmidi noo, nê u Pi Ndêndê, ngmênê daa lémilémi u l꞉êê dîy꞉o nê loo, yoo p꞉ee n꞉aa ngêêpî too, yi l꞉êê dîy꞉o wanî pw꞉onu, pi yilî yi pywuu ngê amy꞉aa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Dini ghi n꞉ii ngê Yesu, p꞉uu ndiye pyu knî yi k꞉ii, Njédikó kada dnya a yém, pi yilî knî y꞉oo dnye yâmuyâmu dé. ");
INSERT INTO yle_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ngwolo kopwe miyó maa nkîgh꞉ê dpîmo ya. Dini ghi n꞉ii ngê ny꞉ee ngópu, apê, Yesu kîyedê pwiyé knî, wod꞉oo u kwo dpîmo kââ, kópu, N꞉ii Chóó Lémi ngê a ngmidi ngê, Dépidi ntee pini, u ntââ ṉga wanyi ch꞉anê knî? ");
INSERT INTO yle_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","K꞉omo tpile pi yilî yintómu ye a tpêpwo dniye, yepê, Tumu choo ya, ngmênê yi dnye dmi daa ny꞉ee ngópu, dpodombiy꞉e mêdpîmo kââ, kópu, Nmî Lémi, Dépidi ntee pini. Kópu, U ntââ ṉga wanyi ch꞉anê knî? ");
INSERT INTO yle_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Wod꞉oo Yesu ngê paa u dî puwâ, yepê, Yi tpódu a ka a pwiyé dniye. Pi knî y꞉oo u kwo yi ńuw꞉o dumo, wod꞉oo Yesu ye póó wo, yepê, Lukwe dpo ngmanî mdo? ");
INSERT INTO yle_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kwo, Nyi Lémi. Kwo, U yi nye a kwo, Yélî m꞉ii m꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu ka ch꞉anê knopwo, wod꞉oo yi ngwolo páádi knî yi p꞉uu kêê yó. Yi ngwo yélî mê m꞉uu ngópu, Yesu u kuwó mye ghê knopwo. ");
INSERT INTO yle_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu, p꞉uu ndiye pyu knî yi k꞉ii, Njedusalem ghêlî daa nî dniye, yi kada p꞉aa ngmê doo ya, u pi Petepake, mbu y꞉i ngma a kwo, u pi Olipi, mu kópu u dîy꞉o nté kn꞉ââ kpê yi mbwini mbêmê ngmêdoo ya, yi yini yi pi dmi mye olipi. Dini ghi n꞉ii ngê yi mbwini mbêmê kee dniye, Yesu ngê p꞉uu ndiye pyu kada miyó kââ, ");
INSERT INTO yle_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yepê, Mu p꞉aani nmî kada choo kwo. Yepê, Dini ghi n꞉ii ngê y꞉i dpo taataa mo, ndonki ghee dpo mumu d꞉oo, yedê ńedê a t꞉a mo. Yepê, Dpo pywálî dóó, a ka dpo ńuw꞉o dóó. ");
INSERT INTO yle_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yepê, Pini n꞉ii ngê kópu dpo ngmêdê vyi knomomê, ye ala kópu u kwo dpî vyi nyoo, kwipi, Nmî lémi ngê yi yi dê u ngwo wunê kwo mo. Yepê, Yi ngwo dpo wunê kuwo dê. ");
INSERT INTO yle_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chóó Lémi u kópu n꞉ii pi ngmê ngê wunê a d꞉êê ngê, Yesu ngê yi ngwo ntiye ngê. Yi kópu ala, ");
INSERT INTO yle_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Njedusalem tpémi, nmyi king wunê pwiyé knî, ndonki pyipwo wunê tóó. Daa l꞉êê pyu ndîî, daa hósi pyipwo wunê tóó, ndonki tp꞉oo pyipwo wunê tóó. ");
INSERT INTO yle_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesu ngê yi tpódu ye kópuni vyu, yinté mî d꞉uu ngópu, ");
INSERT INTO yle_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ndonki ghee Yesu ka a ńuw꞉o dumo, yi nkuwo kpîdî dê yi mbwo a ngee dumo, ndonki ghee yi pyipwo talê dumo, Yesu ndonki pyipwo u nkwo yaa wo. Kada a y꞉ee ngópu, Njedusalem dnye lêpî, maa p꞉uu ndonki ngê Yesu doo dnyinêdnyinê. ");
INSERT INTO yle_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","King ntee dnyimo chââchââ, Yesu yinté mye châpu ngópu, woni knî y꞉oo yi nkuwo kpîdî a ngee tumo, Yesu u kada maa p꞉uu talê tumo, woni knî y꞉oo yi knî ngmê vy꞉êê ngópu, nkoo vyi u kadakada yidi ngópu, ndonki ghee yi mbêmê dpumo paa, Yesu ndonki pyipwo doo ya. ");
INSERT INTO yle_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yoo u kada ngmêdoo kwo, yoo u kuwó mudoo kwo, Yesu yi kêlê ghê doo paa, Njedusalem nipi dnye lêpî, u nkwo dnye kââkââ, kópu, Munmîkó Nmî Lémi, Dépidi ntee pini. Kópu, Chóó Lémi ngê a ngee nyine. Kópu, U pi ngê nyinê loo. Kópu, Chóó Lémi chaa kîgha koo. ");
INSERT INTO yle_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Dini ghi n꞉ii ngê Njedusalem taa dniye, yélini y꞉i doo kwo yintómu ngwéti dniye, noko dnye póó, yipu, Pi knî y꞉oo ló king yi châpu ngmê? ");
INSERT INTO yle_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yoo woni knî y꞉oo yepê, Yesu, pini n꞉ii ngê Chóó Lémi u komo a kapî ngê. Yepê, Nasalet pi, p꞉aani n꞉ii Nkálili Wee u kwo a tóó. ");
INSERT INTO yle_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu p꞉uu Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo mî kee dniye, apê, Pi knî y꞉oo tpile tp꞉oo mu pywupwi t꞉oo, kpêê yiyé u l꞉êê dîy꞉o. Apê, Kn꞉aa dyámê ndapî nmî ndapî ngê mu ngmêêpî t꞉oo. Apê, Yélini al꞉ii a dpodo nyédi, yoo mu dódó t꞉oo, yi ndapî mu chedêchedê t꞉oo. Yi kópu u l꞉êê dîy꞉o Yesu ngê yi yéli a pw꞉oo ngê, kuwa pw꞉ii too, ndapî ngmêêpî têdê yi tépîl ye a pii too, ndapî tpii yi kpópu, ńmê tp꞉oo pywupwi têdê yi p꞉o a ngî too, yi ya têdê dnyi mye dy꞉ee too. ");
INSERT INTO yle_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Chóó Lémi u kópu Yisaya ngê n꞉ii a d꞉êê ngê, yi kópu ye vyu, yepê, Puku yedê ala kópu mu tóó, A ngomo kwéli a kwo, ngêpê têdê ngê choo ya, yepê, ngmênê kpaa têdê ngê dmye pyódu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yélini yi yi dmi kwolo ngmê dé, yi ngwolo kopwe dé, Yesu ka y꞉i ńuw꞉o tumo, yintómu pyi too. ");
INSERT INTO yle_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ngmênê yi kópu u l꞉êê dîy꞉o dêêpî pyu yoo Yesu ka nod꞉e dniye, kpêê yiyé pyu yoo yi kada pini yoo u kwo mye nod꞉e dniye. Noko yepê, Tp꞉ee dmââdîma y꞉oo Chóó Lémi u ngomo chedê lukwe dîy꞉o a chaa kîgha ngmê. Noko yepê, Lukwe dîy꞉o dpodombiy꞉e a kââ té, apu, Dépidi ntee pini chaa kîgha koo. ");
INSERT INTO yle_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wod꞉oo Yesu ka póó dniye, kwo, Kî kópu ka tpapê ngmê, nyi nyêmî? Kwo, Lukwe dîy꞉o a chaa kîgha ngi. Yesu ngê yepê, Nyââ, anî nyêmî. Yepê, Kópuni tp꞉ee dmââdîma y꞉oo a d꞉uud꞉uu ngmê, mumdoo yi kópu puku yedê dmyongê kp꞉aa ngópu? Yepê, Yi kópu alanté a tóó, Dépidi ngê Chóó Lémi ka kwo, U yi ṉga a kwo, Tp꞉ee dmââdîma y꞉oo dny꞉oo chaa kîgha ngi. ");
INSERT INTO yle_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wod꞉oo Yesu ngê a kuwo too, p꞉uu ndiye pyu knî yi k꞉ii Petani lee dniye, Njedusalem u nkîgh꞉ê p꞉aani n꞉ii tp꞉oo a tóó. Y꞉i mî dpî dniye. ");
INSERT INTO yle_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Womumo mw꞉aandiye Yesu, p꞉uu ndiye pyu knî yi k꞉ii, Njedusalem mê diyé dniye. Maa p꞉uu Yesu ngê dómu kele. ");
INSERT INTO yle_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Maa nkîgh꞉ê kuwe kn꞉ââ ngmê módu, apê ngmênê, Kîgha p꞉uu ngma a kwo. Yesu yi yini km꞉ee yi loo, apê, K꞉omo tpile yââ yilî nkwodo mu kwo, ngmênê kîgha p꞉uu daangma a kwo. Wod꞉oo Yesu ngê p꞉uu ndiye pyu yoo yi ngópu mgongo ntee kópu ngmê d꞉uu ngê, yi yini ka kwo, Nté kîgha m̱꞉uu daamuwa ghê. Yi ngwo yi yini pwene. ");
INSERT INTO yle_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Dini ghi n꞉ii ngê p꞉uu ndiye pyu knî y꞉oo yi kópu m꞉uu ngópu, ngwéti dniye. Noko yepê, Kî yini lukwe dîy꞉o lîmîlîmî ngê da yââ? Yi mgongo dnyinté a w꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, A ka dpodombiy꞉e anmya a kêlîmî knomomê, nmyi nuw꞉o dmi ngmidi ngê adnyi ya knomomê, ye kópuni wanmyi vyi t꞉oo, wa pyaa dmi. Yepê, Mgongo ntee kópu n꞉ii wu yini ngê nmyi ngópu dî d꞉uu, u nt꞉u kópu ntênê wanmyi d꞉uu ngmê. Yepê, Myenté, kî mbwini ka wanmyi vyi ngmê, kwonye, A yumwe, nt꞉ee nyi ghé, yepê, yi kópu wa d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yepê, A ka ntênê anmya a kêlîmî knomomê, ye kópuni M꞉aa ka anmyinê dmy꞉ee ngmê, yi kópu nmyi l꞉êê dîy꞉o ntênê wa a d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Dini ghi n꞉ii ngê Yesu p꞉uu Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo kee dniye, Yesu ngê yoo y꞉i doo ndiye kîgha dé. Kada pini yoo, kpêê yiyé pyu yoo yi kada pini yoo yi k꞉ii, Yesu ka a lee dniye, kwo, Chóó Lémi u ngomo nmî chóó nmo y꞉enê. Kwo, Kópuni nye d꞉uud꞉uu too, n꞉uu ngê ṉga vyu, u ngwo nye d꞉uud꞉uu too? Kwo, N꞉uu u pi mbêmê ye kópu yilî nye d꞉uud꞉uu ngê? ");
INSERT INTO yle_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu ngê yepê, Kópu nmye mwiyé ngmên꞉aa poopoo. Yepê, Yi kópu nmyinê vyee ngmê, ye pini n꞉ii ngê a dy꞉ââ noo, u pi nmye u ngwo n꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yepê, N꞉uu u pi mbêmê Njon ngê pi mbwaa lêê u mênê dpîmo kmênêkmênê dé? Yepê, Chóó Lémi u pi mbêmê ó chóó u pi mbêmê? Noko yepê, Ló kópu u kwo ngmanmî vyi? Noko yepê, Ala kópu u kwo nmo tpapê, Chóó Lémi u pi mbêmê, noko yepê, ala kópu nmo a tpapê, Lukwe dîy꞉o Njon ka dpîp꞉e kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Noko yepê, Ala kópu u kwo nmo tpapê, Chóó u pi mbêmê, noko yepê, pi knî y꞉oo ló kópu nmo angmê d꞉uu ngmê, mu kópu u dîy꞉o yinê ye Njon Chóó Lémi u komo kapî pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yi kópu u l꞉êê dîy꞉o kede dniye, Yesu ka kwo, Nmî lama daa tóó. Myenté, Yesu ngê yepê, pini n꞉ii u pi mbêmê kópu yilî n꞉aa d꞉uud꞉uu ngê, nmye myedaanî vyi. ");
INSERT INTO yle_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu ngê kada pini knî ye yepê, Danêmbum ngmê ngî ny꞉ee yó, p꞉uu dmyinê nuw꞉o. Yepê, Pi ngmê, tp꞉oo miyó doo ya. Yepê, Yi pini ngê tp꞉oo kaa ka kwo, A tp꞉ee, wain kpê u mênê chin꞉aa dpodo. ");
INSERT INTO yle_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yepê, Tp꞉oo ngê u mî ka kwo, U p꞉o, ngmênê daa n꞉ee. ");
INSERT INTO yle_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yepê, U kuwó dini ghi ngê yi pini tp꞉oo tpuu ka u nkwo adî lê, kópu mu ngmidi u kwo mye vyu. Yepê, Yi tpémi ngê kwo, Daanî nî, ngmênê u kuwó dini ghi ngê yi tpémi ngê u nuw꞉o mê ngmópu, dpodo têdê mê loo. ");
INSERT INTO yle_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yesu ye póó wo, yepê, Yi tpémi dê yi mî ka n꞉uu ngmê ng꞉aa mbê wo? Kada pini knî y꞉oo kwo, Tp꞉ee tpuu ni. Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Tákisi ngêêpî pyu yoo, téli pyââ yoo, pi dono yilî mye yi k꞉ii, yi nuw꞉o dmi ka ngmêêpî t꞉oo, Chóó Lémi kóó k꞉oo ka wowo té. Yepê, Vyîlo yi yéli u kwo ye ng꞉aa té. Yepê, K꞉omo tpile nmyi komo knî y꞉oo Chóó Lémi nmye chââchââ ngópu, ngmênê u nuu u kópu dp꞉ee d꞉uud꞉uu tumo. Yepê, Doo u ntââ, kóó k꞉oo daangmanmyi ghê. ");
INSERT INTO yle_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yepê, Njon Baptist ngê maa mb꞉aa nmye mênê kêma ngê, ngmênê u kwo dpîp꞉e kêlîmî mbê dniye, u wépi nmyi pwaa ngópu. Yepê, Tákisi ngêêpî pyu yoo, téli pyââ yoo, yoo dono mye yi k꞉ii, vyîlo dé u kwo yi kêlîmî mbê dniye. Yepê, K꞉omo tpile Chóó Lémi u wépi mwiyé a pwaa ngópu, ngmênê kuwó yi nuw꞉o dmi mê ngmêê ngópu, u kwo ntênê ng꞉aa mbê dniye. Yepê, K꞉omo tpile yi kópu nmyi m꞉uu ngópu, ngmênê lukwe dîy꞉o nmyi nuw꞉o dmi dpîp꞉e ngmêê ngópu, Njon ka myedpîp꞉e kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu ngê kada pini knî ye yepê, Danêmbum m꞉uu ala, mye ny꞉ee yó. Yepê, Pi ngmê ngê wain kpê ngmê yó, mbwa ngê a yina ngê, wain kîgha u vyilêvyilê têdê ngmê l꞉âmo ngê. Yepê, Ghi my꞉oo l꞉âmo ngê, yi wain kpê y꞉enê pyu u ya têdê. Yepê, Wain kpê chóó ngê pi ngmê knî ye yepê, A wain kpê ka dmyinê vyuwo, dini ghi n꞉ii ngê nt꞉u dê kaa knomomê, kîgha dmyina a ngêêpî dé, dmyinê vyilêvyilê dé, wain u ngwo dmyinê l꞉âmol꞉âmo, knî a ka ngmêdmyina a dyede, woni nmyi nêni. Yepê, U kuwó dini ghi ngê yi pini ngê wain kpê a kuwo ngê, kn꞉aa p꞉aani loo, dye ghi daadîî y꞉i doon꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Yepê, Wain kpê dini ghi n꞉ii ngê kyopwo wo, wain kpê chóó ngê pi knî ngmê dy꞉ââ ngê, yepê, A wain kpê u mênê dmyinê lêpî, u y꞉enê pyu knî y꞉oo a wain knî nmye ngmêdo kê y꞉e, a ka dpo ńuw꞉o yó. ");
INSERT INTO yle_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yepê, Dini ghi n꞉ii ngê y꞉i mî taa dniye, wain kpê y꞉enê pyu knî y꞉oo mgîmî tumo, ngmê kpaka ngópu, ngmê taa ngê vya ngópu, ngmê chêêpî ngê vya ngópu. ");
INSERT INTO yle_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yepê, Myombó wain kpê chóó ngê pi mê yilî ye dy꞉ââ ngê, ngmênê kópu mu ngmidi y꞉e myemînê d꞉uu ngópu. ");
INSERT INTO yle_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Yepê, U kuwó dini ghi ngê tp꞉oo ye u nkwo dy꞉ââ ngê, apê, A tp꞉ee amînê châpu ngmê, daawa a vya ngmê. ");
INSERT INTO yle_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yepê, Ngmênê yi wain kpê y꞉enê pyu knî y꞉oo daa châpu ngópu. Noko yepê, Kî wain kpê chóó tp꞉oo. Noko yepê, Vya koo, yed꞉oo wain kpê nmo wa ghay. ");
INSERT INTO yle_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yepê, Wod꞉oo mgîmî ngópu, vya ngópu, ntóó chii mênê mî kéé ngópu. ");
INSERT INTO yle_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu ye póó wo, yepê, Dini ghi n꞉ii ngê yi wain kpê chóó wa a lê, yi tpóknî y꞉e ló kópu angmê d꞉uu? ");
INSERT INTO yle_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kada pini knî y꞉oo kwo, Wa a lê, pi dono yoo wa vya té, kn꞉aa yéli y꞉oo yi d꞉aa dmi u nkwo amênê kââdî ngmê. Kwo, Yi yéli y꞉oo mgî daadnyi pwapî, lîmîlîmî ngê nt꞉u knî u kwo angmêdnyi dyede. ");
INSERT INTO yle_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Wod꞉oo Yesu ngê yepê, Kópuni puku yedê a tóó, a w꞉ee yó. Yepê, Yi kópu ala, yepê, Yi pââni ngomo wuwó pyu knî y꞉oo kéé ngópu, yi yini pââ pw꞉eni ngê vyîlo mêyi pyodo. Nmî Lémi ngê yi kópu yinté d꞉uu ngê, nyepênyepê u kópu yi d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu ngê yepê, Pw꞉eni ndêndê nmyi kéé ngópu, Chóó Lémi ngê u nkwo wa kéé nmyo, u wain kpê mêdaanmyi y꞉enê, kn꞉aa yéli y꞉oo nmyi d꞉aa dmi wa a kââdî ngmê. Yepê, Chóó Lémi u kópu dyuu yi yéli yi mênê nt꞉u mb꞉aamb꞉aa ngê wa kaalî. ");
INSERT INTO yle_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yepê, Nê chêêpî kpiyé ntee tpile. Yepê, N꞉ii yi chêêpî kpiyé p꞉uu wa a lvêêdî, mbodo wa pwââ. Yepê, N꞉ii mbêmê yi chêêpî kpiyé wa a ghay, koo dyuu ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pádisi yoo, kpêê yiyé pyu yoo yi kada pini yoo yi k꞉ii, yi ngwo a w꞉ee ngópu, apê, Kî nmî p꞉uu a mgongo. ");
INSERT INTO yle_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","U yi y꞉e doo kwo, Yesu nmî mgîmî, ngmênê kêê u ngwo dêpê t꞉ee ngópu, mu kópu u dîy꞉o pi knî ye nkîngê mbê dniye, yinê ye Chóó Lémi u komo kapî pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu pi knî ye modoo mgongo. ");
INSERT INTO yle_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Yepê, Chóó Lémi kóó k꞉oo wowo alanté. Yepê, King ngmê, tp꞉oo daa kêmakêma doo yééyéé, u l꞉êê dîy꞉o kmaapî ndîî ngma a puwâ. Yepê, Yi kmaapî u wo mwiyé a ngmidi ngê, u lémi ch꞉ama mînê dóó kwólu, yepê, A tp꞉ee u kmaapî têdê dp꞉uu taa dmyeno. ");
INSERT INTO yle_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yesu ngê yepê, Yi wéni dini ghi n꞉ii ngê dyimê wo, u dpodo pyu knî ngmê dy꞉ââ ngê, yepê, Yoo a pwiyé we, ngmênê u yi y꞉e dêpwo kwo. ");
INSERT INTO yle_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yepê, Wod꞉oo dpodo pyu knî m꞉uu dy꞉ââ ngê, yepê, Yélini nê dóó kwólu, ye dp꞉uu vyi yó, yipi, Ala ngwo kmaapî. Yipi, Nê ngê ala kmaapî u l꞉êê dîy꞉o tpile tp꞉oo n꞉ii kaa too, wunê kêdê vya t꞉oo, tpile yilî yintómu u ntââ mbêmê ka pyede. Yipi, A pwiyé dmyeno. ");
INSERT INTO yle_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yesu ngê yepê, Ngmênê yi yéli ye daa ng꞉aa mbê dniye, yinê ye têdê kópu, yi chóó yi dpodo têdê dpodo têdê lee dniye. Yepê, Woni yâpwo têdê lee dniye, woni tpile pywupwi têdê lee dniye. ");
INSERT INTO yle_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yepê, Yoo ngmê ngê king u dpodo pyu yoo mgîmî tumo, dnye nkwitinkwiti dé, u nkwo vya tumo. ");
INSERT INTO yle_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yepê, King yi yéli ye d꞉ud꞉umbiy꞉e nod꞉e wo, wod꞉oo u lede knî ngmê dy꞉ââ ngê, yi ntââ dmi mînê vy꞉ee ngópu, yi yéli u nkwo vya tumo, yi p꞉aa myemînê vyuwó ngópu. ");
INSERT INTO yle_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yepê, U kuwó dini ghi ngê u dpodo pyu yoo a danê ngê, yepê, Kmaapî u tpile yilî u ntââ mbêmê ka pyede, ngmênê yélini nê dóó kwólu, yoo dono, doo u ntââ ala ntini daawa ma ngmê. ");
INSERT INTO yle_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yepê, P꞉aani p꞉aani dmyinê lêpî, pi yimi nmyinê pyw꞉êmî ngmê, dpo ńuw꞉o tóó. ");
INSERT INTO yle_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yesu ngê yepê, Wod꞉oo yi dpodo pyu yoo p꞉aani p꞉aani lee dniye, pi yilî mînê pyw꞉ee ngópu, dono mb꞉aamb꞉aa myedê ńuw꞉o tumo. Yepê, Ngomoni k꞉oo dnye kmaapî, yi ngomo pi ngê a nt꞉ee ngê. ");
INSERT INTO yle_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Yesu ngê yééyéé kmaapî u mgongo ye m꞉uu kwólu, yepê, King kmaapî têdê yi yaa wo, yoo yi k꞉ii dnye yakmaapî, ngmênê pi yi vy꞉o ngmê módu, yi pini ngê u yééyéé kpîdî u mbwo daangmê t꞉ângo. ");
INSERT INTO yle_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yepê, Yi king u kwo póó wo, kwo, Kî pini. Kwo, Al꞉ii lónté cha kee, yééyéé u kpîdî m̱wo daa t꞉a. Yepê, Yi pini ngê kópu u kwo daangmê vyu. ");
INSERT INTO yle_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yepê, King ngê u dpodo pyu knî ye yepê, Mgîmî yó, kóó yu kudu tóó, kuwa d꞉ii yó. Yepê, Mgîdî vy꞉o choon꞉aa mbê, kpéngi ti dmi kelekele mudny꞉oon꞉aa paa. ");
INSERT INTO yle_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu ngê yepê, Pi yintómu knî ye n꞉aa tpapê ngê, yenîmo, A pwiyé dmyeno, ngmênê Chóó Lémi ngê yilî daawa a ngmidi. ");
INSERT INTO yle_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","U kuwó dini ghi ngê Pádisi yoo kuwa pwii dniye, kn꞉aa p꞉aani pee mê lee dniye, Yesu u dódó u l꞉êê dîy꞉o nipi y꞉i dnyen꞉aa danêmbum. ");
INSERT INTO yle_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yi lama doo ya, Lóma tpémi ye tákisi pywupwi Nju tpémi ye daa yi nuu u kópu ngê a tóó, wod꞉oo yi p꞉uu ndiye pyu knî ngmê ngmidi ngópu, king Helodi u kwo téni pee yéli yi k꞉ii Yesu ka dy꞉ââ tumo, kwo, Mââwe, kwo, nmî lama ka tóó, Ndêndê ngê nye danêmbum. Kwo, Pi knî ye d꞉ee nkîngê yédi, ngmênê Chóó Lémi u kópu dyuu pi knî ye ndêndê ngê nye tpapê ngê. ");
INSERT INTO yle_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kwo, Nmo vyi ngi, kwo, nmî dêêpî kópu dyuu lónté a kwo, kwo, u ntââ Lóma tpémi yi king ndîî ka tákisi wanmî pywupwi, ó daanmî pywupwi? ");
INSERT INTO yle_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu ngê yi kópu a w꞉ee ngê, apê, Ngee k꞉omodanê té. Yepê, Nmyo k꞉omodanê pyu yoo, lukwe dîy꞉o nmye dódó nê. ");
INSERT INTO yle_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yepê, Tákisi ndapî a ngópu ngmê tpyé yó, ngmênî m꞉uu. U kwo yi ńuw꞉o ngópu, ");
INSERT INTO yle_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ye póó wo, yepê, Ala ndapî p꞉uu n꞉uu u kââ ye tóó, n꞉uu u pi myeye tóó? ");
INSERT INTO yle_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kwo, Lóma tpémi yi king ndîî u kââ u pi ye tóó mo. Wod꞉oo Yesu ngê yepê, Tpileni Lóma tpémi yi king ndîî ngmênêni, u kwo mêdmyinê yémî. Yepê, Tpileni Chóó Lémi ngmênêni, Chóó Lémi ka mêdmyinê yémî. ");
INSERT INTO yle_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yi kópu yi ny꞉ee ngópu, yi nuw꞉onuw꞉o u kópu ngê pyodo, wod꞉oo Yesu a kuwo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yi wéni ngê yoo ngmê Yesu ka loo, yi yéli Sadyusi yoo. Yi nuw꞉o dmi alanté doo ya, apê, Pi dpî pw꞉onu, mêd꞉uuwodê pyidu. U yi y꞉e doo kwo, Yesu u pi nmî dyênê, u l꞉êê dîy꞉o Yesu alanté dnye dódó. ");
INSERT INTO yle_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Yesu ka kwo, Mósisi ngê ala dêêpî kópu a d꞉êê ngê, apê, Pi angmê pw꞉onu, u kuknwe adî ya knomomê, yi tp꞉ee daadî ya knomomê, ye yi pini u mbwó ngê yi kuknwe moo ndê ngê, u mbwó u l꞉êê dîy꞉o tp꞉ee angmê tpyé ngmê. ");
INSERT INTO yle_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kwo, Pi mbwémi pyudu nmî vy꞉o doo kwo, kaani yéé wo, tp꞉ee daa tpyó, u ngwo pwene. ");
INSERT INTO yle_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kwo, Kaapeeni ngê yi kuknwe mê ndê ngê, yi pyópu ngê tp꞉ee myedêpê ngêêdî, kaapeeni yinté u nkwo mye pwene. Kwo, Yi mbwémi knî yintómu yi pyópu mu ngmidi yinté dnye ny꞉ee, yintómu pw꞉oo dniye, tp꞉ee yi pyópu ngê dêpêngmê ngî ngópu. ");
INSERT INTO yle_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kwo, U kuwó dini ghi ngê yi pyópu mye pwene. ");
INSERT INTO yle_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kwo, Lukwe dîy꞉o pyidepyide u pi nye tpapê. Kwo, Yoo wa a pii knomomê, ye yi pyópu ngê lukwe angmê pyódu, ló pini u kpâm ngê amî pyódu? Kwo, Doo u ntââ, mu kópu u dîy꞉o yi mbwémi pyudu knî yi pyópu mu ngmidi p꞉uu yéé dniye. ");
INSERT INTO yle_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu ngê yepê, Dmye kn꞉aadi ngmê, mu kópu u dîy꞉o Chóó Lémi u kópu dyuu nmyi lama daa kwo, u wêdêwêdê nmyi lama myedaa tóó. ");
INSERT INTO yle_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yepê, Enjel yoo ntee d꞉uudpî yéé dmi, dini ghi n꞉ii ngê yoo wa a pii dmi, yinté adnyi ya, pyââ mââ numo p꞉uu mêdaawa yéé knî. ");
INSERT INTO yle_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yepê, Yoo yi pyidepyide p꞉uu nmye n꞉aa danê. Yepê, Yi kópu p꞉uu kópuni Mósisi ngê wunê a d꞉êê ngê, lukwe, dmyongê kp꞉aa ngópu? Yepê, Yi puku pee yedê alanté a tóó, Chóó Lémi ngê Mósisi ka kwo, ");
INSERT INTO yle_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nê, ṉg꞉ââ Epîlaham u yâpwo, myenté tp꞉oo Yisak u yâpwo, myenté Yisak tp꞉oo Njakóp u yâpwo. Yepê, Chóó Lémi yi tpóknî yi yâpwo, yi kópu u l꞉êê dîy꞉o, k꞉omo tpile a pw꞉oo dniye, ngmênê yi ghê a pyede. Yepê, Chóó Lémi daa ntóó knî yi yâpwo, ngmênê n꞉ii dé yi ghê a pyede, vyîlo yi yéli yi yâpwo. ");
INSERT INTO yle_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pi knî y꞉oo yi kópu yi ny꞉ee ngópu, yi nyepênyepê u kópu ngê ye pyodo. ");
INSERT INTO yle_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Dini ghi n꞉ii ngê Pádisi knî y꞉oo ny꞉ee ngópu, apê, Yesu ngê Sadyusi yoo kêdê châpwo té, wod꞉oo u kwo lee dniye. ");
INSERT INTO yle_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yi vy꞉o pini ngmê ngê u yi doo kwo, Danêmbum têdê Yesu nî dóó. Yi pini ngê dêêpî kópu dyuu pi knî ye dpîmo tpiyé dé. ");
INSERT INTO yle_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Yesu ka póó wo, kwo, Mââwe. Kwo, Dêêpî kópu dyuu yi vy꞉o, lóni kada ngma a tóó? ");
INSERT INTO yle_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Yesu ngê kwo, Ala dêêpî kópu kada a tóó, Chóó Lémi u nuu ghi nmyi nódo mb꞉aamb꞉aa ngê choo ya. Kwo, Chóó Lémi nmyi gha vy꞉o choo ya, dye ghi yintómu p꞉uu dmyinê nuw꞉o, u nuu u kópu yidmyinê d꞉uud꞉uu dé. ");
INSERT INTO yle_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kwo, Yi dêêpî kópu u kuwó alani a tóó, kwo, Ṉ́yóó ṉuu ghi ṉódo ntee a tóó, yoo yi nuu ghi dmi ṉódo yinté myechoo ya. ");
INSERT INTO yle_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kwo, Yi kópu dê yi mbêmê, dêêpî kópu yilî yintómu a pyede. Kwo, Kópuni Mósisi ngê a d꞉êê too, kópuni Chóó Lémi u komo kapî pyu knî y꞉oo myedê d꞉êê tumo, yintómu yi kn꞉ââ yi kópu dê yi mbêmê a kwo. ");
INSERT INTO yle_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yesu Pádisi knî ye póó wo, ");
INSERT INTO yle_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, nmyinê nmye n꞉uu u tii ńedê pini? Kwo, Dépidi u tii ńedê pini ngmê. ");
INSERT INTO yle_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu ngê yepê, Lukwe dîy꞉o Dépidi ngê chóó u pi a ghîpî ngê, yi pini u pi kmungo? Yepê, Yi kópu p꞉uu dmyinê nuw꞉o. Yepê, Yi pini kada a tóó, Dépidi u kuwó a tóó, mu kópu u dîy꞉o Chóó Lémi u Ghê Dmi ngê Dépidi yinê a ngópu, ala kópu u ngwo a d꞉êê ngê, apê, ");
INSERT INTO yle_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Chóó Lémi ngê a kada pini ka kwo, M̱i ndîî ngê n꞉aa pyépi, a wéni pee dpî yey, pi yintómu chi y꞉enê dé. Yélini m̱꞉uu a l꞉êê té, dîyo anî vya té, ṉyi yodo u maknopwo wanî yé té. ");
INSERT INTO yle_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yesu ngê yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, Dépidi ngê apê, Yi pini a kada pini. Yepê, Yi kópu u l꞉êê dîy꞉o, yi pini daa Dépidi ntee pini, ngmênê pi knî yi pwo pini ntee pini. ");
INSERT INTO yle_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu u kópu dyuu pi ngmê ngê daa vyâ. U kuwó dini ghi ngê Yesu ka kópu daamu poo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu p꞉uu ndiye pyu knî ye doo danêmbum, pi knî ye myedoo danêmbum, ");
INSERT INTO yle_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","yepê, Chóó Lémi ngê dêêpî pyu yoo, Pádisi yoo nmyi kada kaa too, Mósisi u dêêpî kópu dyuu nmye y꞉oo a tpiyé tumo. ");
INSERT INTO yle_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yepê, Yi dnye dmi dmyinê nyêmî dé, kópuni nmye dny꞉oo tpapê dé, dmyinê d꞉uud꞉uu dé. Yepê, Ngmênê kópuni a d꞉uud꞉uu tumo, yi kópu yi kêlê nangmê ngee, mu kópu u dîy꞉o kópuni nmye a tpapê tumo, yi chóó daa d꞉uud꞉uu tumo. ");
INSERT INTO yle_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yepê, Mósisi ngê yoo u ntââ dêêpî kópu dyuu yi d꞉êê ngê, ngmênê dêêpî pyu knî y꞉oo yi chóó yilî ngê pyódu tumo, pi knî ye dpodo ndîî ngê u nkwo pyodo, ngmênê yi dpodo têdê yoo daa ngêêpî tumo. ");
INSERT INTO yle_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yepê, Kópu yilî yintómu n꞉ii a d꞉uud꞉uu tumo, yi chaa kîgha u l꞉êê dîy꞉o a d꞉uud꞉uu tumo, dpo, Pi knî y꞉oo dny꞉oo chaa kîgha nmo. Yepê, Yi kópu u l꞉êê dîy꞉o dêêpî kópu dyuu pweepwee pee yedê dpî d꞉êê t꞉oo, yi kêpa dpî t꞉ee t꞉oo. Yepê, Myenté, yedê ghi tp꞉oo n꞉ii yi kpîdî kwódo knî yi p꞉uu dpî t꞉ee t꞉oo, daadîî ngê dpî pyódu t꞉oo, dpo, Pi knî y꞉oo ala kópu nmî p꞉uu pîdny꞉oo tpapê, Dêêpî kópu dyuu mb꞉aamb꞉aa ngê a chââchââ t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yepê, Ngêpê ngomo k꞉oo yi chóó kada dp꞉uu yaa dmi, naa têdê yi chóó kada myoon꞉aa yaa dmi. ");
INSERT INTO yle_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yepê, U yi y꞉e a kwo yédi, Pi knî y꞉oo naa têdê mb꞉aamb꞉aa ngê dny꞉oo chââchââ nmo, ala kópu nmî p꞉uu pîdny꞉oo tpapê, Nmî ndiye kîgha pyu ndîî dé. ");
INSERT INTO yle_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yesu ngê yepê, Pi knî y꞉oo nmyi p꞉uu kîngî vyi ngmê, Nmî ndiye kîgha pyu yoo, mu kópu u dîy꞉o nmyo numo tîdê mbwó yoo, nmyi ndiye kîgha pyu mu ngmidi. ");
INSERT INTO yle_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yepê, Dyámê mbêmê pi ngmê ka nangê vyi, M꞉aa, mu kópu u dîy꞉o nmyi Mî mu ngmidi, mbóó p꞉uu wunê tóó. ");
INSERT INTO yle_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yepê, Myenté, pi knî y꞉oo Kada Pini u pi nmyi pyimo kîngê t꞉ee ngmê, mu kópu u dîy꞉o nmyi kada pini mu ngmidi, pini n꞉ii Chóó Lémi ngê a ngmidi ngê, nmyi kada kââ. ");
INSERT INTO yle_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yepê, Pini n꞉ii nmyi kada pini ngê adî ya, yi pini nmyi p꞉uu choo dpodo. ");
INSERT INTO yle_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yepê, N꞉ii ngê u pi chóó a kmîmî ngê, Chóó Lémi ngê yi pini u pi têdê ngê wa a pyódu, n꞉ii ngê chóó u pi wunê ghîpîghîpî ngê, Chóó Lémi ngê yini u pi ndîî ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesu ngê kada pini knî ye yepê, Pádisi yoo, dêêpî pyu yoo, dmyinê nkîngê. Yepê, Nmyi too pee mbêmê nmyo mb꞉aamb꞉aa dé, ngmênê nmyi gha dmi dono dé. Yepê, Nmyi chóó nmyi dêêpî kópu yilî nmyi d꞉êê ngópu, pi knî ye Chóó Lémi kóó k꞉oo wowo dpodo ndîî ngê u ngwo nmyi pyódu ngópu. Yepê, Nmyi chóó y꞉i dp꞉ee koko nyédi, lukwe dîy꞉o yoo yi maa nmyi nkoko ngópu. ");
INSERT INTO yle_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(-) ");
INSERT INTO yle_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Yepê, Pádisi yoo, dêêpî pyu yoo, dmyinê nkîngê. Yepê, Nmyi too pee mbêmê nmyo mb꞉aamb꞉aa dé, ngmênê nmyi gha dmi dono dé. Yepê, Kn꞉aa dyámê kn꞉aa dyámê nmye lêpî nyédi, nyimo, Ndiye pyu knî m꞉uu nmîmo pyw꞉oo, nmî yoo vy꞉o paa ghê dniye. Yepê, Yi dpodo p꞉uu dpodombiy꞉e nmye dpodo nyédi. Yepê, Pini n꞉ii nmyi yoo vy꞉o dpî ghê, nmyi nt꞉anê dpî yââ. Yepê, Yi pini ngê nmyi dêêpî kópu dyuu mb꞉aamb꞉aa ngê a chââchââ ngê, ngmênê pi ka vyuwo u lama daa ya yédi. Yepê, Yinté pini ngê nmyi maa p꞉uu dpo kp꞉anê nmyo, ngmênê yi máádi u dî ndiya. ");
INSERT INTO yle_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yepê, Dmyinê nkîngê. Yepê, U yi nmye a kwo, Pi knî ye maa nmo kêma, ngmênê nmyi ngwolo dmi kopwe dé. Yepê, Pi knî ye ala kópu nmye tpapê ngópu, yenmyimo, Pi ngmê, kópu ngmê u l꞉êê dîy꞉o Chóó Lémi u ngomo u pi ngê wa kp꞉aa, ye yi kópu daa ndîî kópu, ngmênê yi ngomo k꞉oo nkól n꞉ii a tóó, yi pini yi nkól ngê wa kp꞉aa, ye kópuni u l꞉êê dîy꞉o dpî kp꞉aa, ntênê dpî d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yepê, Nmyi mbodo dmi podo dé, nmyi ngwolo dmi kopwe dé. Yepê, Nkól daa yâpwo. Yepê, Dini ghi n꞉ii ngê Chóó Lémi u ngomo k꞉oo kee wo, yâpwo ngê u ngwo pyodo. ");
INSERT INTO yle_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yepê, Myenté, ala kópu ye my꞉ee tpapê ngópu, yenmyimo, Pi ngmê, kópu ngmê u l꞉êê dîy꞉o kpêê yiyé têdê u pi ngê wa kp꞉aa, ye yi kópu daa ndîî kópu. Yenmyimo, Yi pini ngê yi kópu daawa d꞉uu knomomê, ye u kópu daa tóó. Yenmyimo, Ngmênê tpile tp꞉oo n꞉ii kpêê ngê dpî yé ngmê, yi pini yi tpile tp꞉oo u pi ngê wa kp꞉aa, ye ndîî kópu yu d꞉uu, kópuni u l꞉êê dîy꞉o dpî kp꞉aa, ntênê dpî d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yepê, Nmyi ngwolo dmi kopwe dé. Yepê, Tpile tp꞉oo daa yâpwo. Yepê, Kpêê yiyé têdê yi yâpwo. Yepê, Dini ghi n꞉ii ngê tpile tp꞉oo kpêê ngê dpî yé ngmê, yâpwo ngê u ngwo dpî pyódu. ");
INSERT INTO yle_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yepê, Yi kópu u l꞉êê dîy꞉o n꞉ii kpêê yiyé têdê u pi ngê dpî kp꞉aa, tpile tp꞉oo n꞉ii kpêê ngê dpî yé ngmê, u ngwo myoo kp꞉aa. ");
INSERT INTO yle_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Yepê, N꞉ii Chóó Lémi u ngomo ngê dpî kp꞉aa, ye Chóó Lémi ngê dpî kp꞉aa, mu kópu u dîy꞉o Chóó Lémi y꞉i a tóó. ");
INSERT INTO yle_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yepê, N꞉ii mbóó u pi ngê dpî kp꞉aa, Chóó Lémi ngê dpî kp꞉aa, mu kópu u dîy꞉o Chóó Lémi y꞉i wunê tóó, y꞉i wunê y꞉enê nmo. ");
INSERT INTO yle_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yepê, Pádisi yoo, dêêpî pyu yoo, dmyinê nkîngê. Yepê, Nmyi too pee mbêmê nmyo mb꞉aamb꞉aa dé, ngmênê nmyi gha dmi dono dé. Yepê, Lukwe dîy꞉o pi knî ye dp꞉ee vyuwo nyédi, ngópuch꞉anê knî ye myedp꞉ee vyuwo nyédi, lukwe dîy꞉o yoo nmye dódó tumo. Yepê, Dmyinê nkîngê. Yepê, Têdê kópu ndîî kópu ngê nmyi pyódu tumo, ndîî kópu têdê kópu ngê nmyi pyódu tumo. Yepê, Mósisi ngê nmî kn꞉ââ knî ye ala kópu a vyu, yepê, Ntini n꞉ii pi ngê yâpwo têdê dpo ńuw꞉o, dyuu y꞉a dpo pyidu ngê, yononi dyuu Chóó Lémi u dpodo pyu knî ye dpî y꞉ee ngê. Yepê, Yi kópu dnyinté dp꞉ee chââchââ ngmê. Yepê, K꞉omo tpile nkêpe w꞉uu y꞉a, ó kpono w꞉uu y꞉a nmyinê pyw꞉êmî ngópu, ngmênê myenmyinê kpââ ngópu, Chóó Lémi u dpodo pyu knî ye yononi ntênê nmye yémî ngópu. Yepê, Yi kópu ndîî kópu ngê nmyi pyódu ngópu. Yepê, Kópuni Chóó Lémi ka ndîî kópu, lukwe dîy꞉o têdê kópu ngê nmyi pyódu ngópu. Yepê, Têdê kópu dmyinê d꞉uud꞉uu dé, kópuni Chóó Lémi ka ndîî kópu dé, myedmyinê d꞉uud꞉uu dé. ");
INSERT INTO yle_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yepê, Nmyi ngwolo kopwe dé, yoo dnyinté ghîghê anmyi ńeńe t꞉oo. Yepê, Kpitimw꞉ee ngê dpî kiye nmyo, ye lîmîlîmî ngê nmye vyee tumo, lukwe dîy꞉o kulu yilî nmyi p꞉uu a kiye nyédi, dp꞉ee vyee tumo. Yepê, Têdê kópu ntênê nmye chââchââ tumo, lukwe dîy꞉o ndîî kópu dnyinté nmye chââchââ tumo. ");
INSERT INTO yle_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Yepê, Pádisi yoo, dêêpî pyu yoo, dmyinê nkîngê. Yepê, Nmyi too pee mbêmê nmyo mb꞉aamb꞉aa dé, ngmênê nmyi gha dmi dono dé. Yepê, Nmyi d꞉ââ pîléti yi kpadama yinmye ghêêghêê tumo, lukwe dîy꞉o yi kó dp꞉ee ghêêghêê t꞉oo. Yepê, Nmyi too pee yinmye ghêêghêê tumo, ngmênê nmyi gha dmi tupwótupwó dé. Yepê, Nmyo ndapî u mb꞉aami yoo, nmyi gha dmi dono dé. ");
INSERT INTO yle_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yepê, Pádisi yoo, lukwe dîy꞉o my꞉oo nmye pyede. Yepê, Nmyi gha dmi mb꞉aamb꞉aa ngê pyódu tóó, kópu mb꞉aa yilî u ngwo anmyi d꞉uu t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yepê, Pádisi yoo, dêêpî pyu yoo, dmyinê nkîngê. Yepê, Nmyi too pee mbêmê nmyo mb꞉aamb꞉aa dé, ngmênê nmyi gha dmi dono dé. Yepê, Poki n꞉ii u mênê pi ntóó dpî yé ngmê, nmyo yinté tpile dé. Yepê, Kuwa mb꞉aamb꞉aa, k꞉oo dono. Yepê, Nmyi gha dmi nkîpwi dé. ");
INSERT INTO yle_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yepê, Nmyi too pee mbêmê pi knî ye yinê ye nmyo mb꞉aamb꞉aa dé, ngmênê nmyi gha dmi dono dé, yoo nmye dódó tumo. ");
INSERT INTO yle_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yepê, Pádisi yoo, dêêpî pyu yoo, dmyinê nkîngê. Yepê, Nmyi too pee mbêmê nmyo mb꞉aamb꞉aa dé, ngmênê nmyi gha dmi dono dé. Yepê, Nmyi kn꞉ââ knî y꞉oo Chóó Lémi u komo kapî pyu yoo wunê kwéli a kmênê tumo, ngomo mb꞉aa yi pwo nmyi wuwó tumo, yi mti ngê a pyede. Yepê, Chóó Lémi u nuu u pi yoo yi kpî dmi mb꞉aamb꞉aa ngê my꞉ee kpîlêkpîlê tumo. ");
INSERT INTO yle_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yepê, Ala kópu nmye tpapê ngópu, nmyimo, Nmî kn꞉ââ yoo yi dye ghi ngê wonmee a ya, ye yi vy꞉o daap꞉oo ghê dniye, Chóó Lémi u komo kapî pyu yoo nmî k꞉ii daap꞉oo vya too. ");
INSERT INTO yle_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yepê, Yi kópu mbêmê nmyi chóó nmyi komo knî y꞉oo ala kópu nmye tpapê ngópu, nmyimo, Yélini y꞉oo Chóó Lémi u komo kapî pyu yoo a vya tumo, nmo yi tp꞉ee yoo. Nmyimo, Nmî kn꞉ââ knî y꞉oo kópuni kn꞉ââ a chaa ngópu, nmo chedêchedê. ");
INSERT INTO yle_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yepê, Nmyi kn꞉ââ yoo máádini p꞉uu a ghê dniye, yi máádi p꞉uu my꞉ee wee. Yepê, Lukwe dîy꞉o u yi nmye a kwo, nmyimo, Yi máádi p꞉uu nmî t꞉ee kalê té. Yepê, Lukwe dîy꞉o a vyee u yi nmye a kwo. ");
INSERT INTO yle_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yepê, K꞉omodanê pyu yoo, nkwépi ntee yéli. Yepê, Chóó Lémi ngê ntââ nmye amînê vy꞉u, daamî kede, ndiya amî kéé nmyo. ");
INSERT INTO yle_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yepê, Pi mb꞉aa knî a chóó nmye u nkwo angmanê dy꞉ââ, woni knî y꞉oo a komo adnyin꞉aa kapî, woni yoo nuw꞉o ndîî mbêmê nmye adnyin꞉aa danê, woni yoo a p꞉uu nmye adnyin꞉aa dêêpî. Yepê, Ngmênê yi wépi dmi wanmyi pwaa ngmê, wanmyi mgîmî t꞉oo, woni yoo taa ngê wanmyi vya t꞉oo, woni yoo kîdosi ńedê wanmyi t꞉ee t꞉oo. Yepê, Woni yoo ngêpê ngomo y꞉enê pyu knî y꞉oo wa kóté kalê t꞉oo, wa kpaka t꞉oo, woni yoo p꞉aani p꞉aani wa ngm꞉ii kalê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yepê, Dye ghi yintómu nmyi kn꞉ââ knî y꞉oo pi mb꞉aa yoo yidnya a vyee dé, kn꞉ââ Kéén ngê Epel mwo a vyâ, nkoo nmo, a vyee u yi nmye mye kwo. Yepê, Kêlî ghê, king Njehu u dye ghi ngê, dini ghi n꞉ii ngê Mbadakaiya tp꞉oo Sekîdaiya Chóó Lémi u ngomo chedê vya ngópu, Chóó Lémi ngê dnyinté a kpada too, Sidiya tpémi dy꞉ââ too, Njedusalem tpémi yi ndapî mî t꞉âmo tumo, yi tpile yilî mye t꞉âmo tumo, ngmênê yi p꞉aa dêpê pw꞉oo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yepê, Ala ngwo Chóó Lémi ngê u komo kapî pyu ndêndê nmye da dy꞉ââ, dmy꞉oo mya ngópu. Yepê, Wanmyi vya knomomê, Chóó Lémi ngê dnyinté u nkwo daawa kpada nmyo, nmyi p꞉aa d꞉ud꞉umbiy꞉e wa a pw꞉ono. Yepê, Nmyi kn꞉ââ yoo yi yikî dmi nmyi pwo wa ghay. ");
INSERT INTO yle_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu ngê Njedusalem tpémi ye yepê, Ee Njedusalem tpémi, nmye vyuwo pyu lukwe dîy꞉o dmyongê mya ngópu. Yepê, N꞉ii knî y꞉oo Chóó Lémi u komo nmye dnyimo a kapî, nmyimo a kpadakpada dé, woni yoo chêêpî ngê nmyi vya tumo. Yepê, Kêmkêm ngê tp꞉oo w꞉uu ńuupee dê yi maknopwo ntee dpî w꞉êê té, daa ng꞉êêntómu nê, Yinté nî w꞉êê nmyo, ngmênê a wépi nmyi pwaa ngópu. ");
INSERT INTO yle_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yepê, Mu dini ghi ngê Chóó Lémi ngê nmyi p꞉aa d꞉ud꞉umbiy꞉e wa a kuwo, amyinê kuwo, mêdaamunmyi m꞉uu nê, ");
INSERT INTO yle_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","u dî wéni n꞉ii ngê ala kópu anmyi vyi ngmê, anye, Pini n꞉ii Chóó Lémi u pi mbêmê a m꞉ii, Chóó Lémi ngê ntênê choo a ngêêpî. ");
INSERT INTO yle_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Dini ghi n꞉ii ngê Yesu ngê Chóó Lémi u ngomo doo a kuwokuwo, p꞉uu ndiye pyu knî y꞉oo ngomo u kwo dnya a kêmakêma dé. ");
INSERT INTO yle_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yepê, Ala ngwo mb꞉aamb꞉aa ngê yimi ngî m꞉uu tóó, mu dini ghi ngê chedê ngê wa pyaa dmi. Yepê, Chêêpî pywápê ngmê n꞉ii ngê kî ngomo a wuwó tumo, mu dini ghi ngê numo u pwo u pwo daangmadî ya. Yepê, Kn꞉aa lede knî y꞉oo kî ngomo pê d꞉ud꞉umbiy꞉e wa pwaa t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu, p꞉uu ndiye pyu yoo yi k꞉ii, Njedusalem a kuwo ngópu, mbwaa tp꞉oo ngmê ngmêê ngópu, mbwini n꞉ii u pi Olipi, yi mbwini mbêmê mî kee dniye, y꞉i dnyen꞉aa ya. Yi ngwo p꞉uu ndiye pyu knî ngmê Yesu ka yi mo lee dniye, kwo, Chóó Lémi u ngomo ngî mwini. Kwo, Ló dini ghi ngê wa a pw꞉oo ngmê? Kwo, Ló kópu ngmanmî ny꞉oo, nmî lama u ngwo wa yââ, nê, Nyi daa kêmakêma wunê diyédiyé, dyámê pê machedê ngê a pyodopyodo? ");
INSERT INTO yle_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu ngê yepê, Nmye mb꞉aamb꞉aa ngê dmyina a vyuwo, pi ngmê ngê kîngî dóó nmyo. ");
INSERT INTO yle_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yepê, Pi yilî wa a lê, u yi y꞉e adî kwo, Nê u d꞉aa nmo kââdî, nmyewo, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, ala nê vyîlo. Yepê, Pi yilî yinté wa dóó t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yepê, L꞉êê pââ ndîî u pi ngmanmyi ny꞉ee ngmê, nmyi nkîgh꞉ê amyidnyi l꞉êê, ngmênê nkîngê ngê kêê nangê t꞉oo. Yepê, Yi kópu daawa têda dmi, ngmênê nangê vyi, Ala d꞉o kuwókuwó dini ghi. ");
INSERT INTO yle_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yepê, Kn꞉aa dyámê tpémi kn꞉aa dyámê tpémi yi p꞉uu adnyi l꞉êê, yepê, daa ng꞉êêntómu m꞉uu wa ghîdî, yoo adnyi dómudómu, amyidnyi pwopwo, yepê, dyámê pee knî ngmê wadî ghêdê, pi yilî wa pw꞉oo dmi. ");
INSERT INTO yle_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yepê, K꞉omo tpile yinté kópu yilî yi pi dmi wanmyi ny꞉ee ngmê, ngmênê nangê vyi, Ala d꞉o dyámê pê dpî chedê. Yepê, Yi kópu yilî têdê dé, ngmênê dono kópu ndîî dé dîyo kuwó wa pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yepê, Yi dini ghi ngê pi dono knî y꞉oo u yi y꞉e adî kwo, Nê u yoo nmî chedê, yepê, u l꞉êê dîy꞉o nmyi p꞉uu adnyi d꞉uu. Yepê, Adnyin꞉aa mgîmîmgîmî nmyo, nmyi vy꞉o woni yoo adnyin꞉aa kpadakpada dé, woni yoo wa vya t꞉oo. Yepê, A l꞉êê dîy꞉o pi yintómu knî ye wanmy꞉uu diya dmi. ");
INSERT INTO yle_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Yepê, Yi ngwo pi yilî knî y꞉oo wa kéé nê, yoo dono knî ye a yoo wa kêma t꞉oo, ye anmyi diya dmi. ");
INSERT INTO yle_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yepê, Yi ngwo pi daa ngmidi knî y꞉oo Chóó Lémi u komo k꞉omodanê mbêmê adnyin꞉aa kapî, pi yilî u ngwo wa dóó t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yepê, Yi ngwo yoo yi dono ndîî ngê wa pyódu, yi nuu ghi dmi numo nódo dnyinté adîn꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yepê, Ngmênê n꞉ii knî y꞉oo yi kópu dono adnya a vyîmî dé, myedaawa mb꞉ii nê, mu dini ghi ngê M꞉aa kóó k꞉oo wan꞉uu kaa té. ");
INSERT INTO yle_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yepê, Dyámê pee yintómu knî yi mbêmê Chóó Lémi kóó k꞉oo wowo u pi pi knî y꞉oo mwiyé wa ny꞉ee ngmê, u kuwó dini ghi ngê dyámê pê machedê ngê u ngwo wa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesu ngê yepê, Njuda Wee u kwo yélini adnyi ya, tpile dyede u tpile dono yâpwo ghê angmê m꞉uu ngmê. Yepê, Yi tpile p꞉uu Dániyél ngê Chóó Lémi u komo wunê a kââ. (Pini n꞉ii ngê ala puku choo a kpââ, yi kópu mb꞉aamb꞉aa ngê choo a wopwe.) ");
INSERT INTO yle_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yepê, Yi tpile dono dini ghi n꞉ii ngê wa t꞉aa, Njuda Wee u kwo yélini adnyi ya, dpî mbêpê dniye, mbu knî yi vyuwo dp꞉uu mbwolo dniye. ");
INSERT INTO yle_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yepê, Pini n꞉ii u ngomo maknopwo adî ya, lîmîlîmî ngê dpî mbêpê we, u ngomo k꞉oo mêkîngî kee, u tpile kîdangmên꞉aa ngî. ");
INSERT INTO yle_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yepê, Pini n꞉ii yâpwo têdê adîn꞉aa dpodo, u p꞉o mêkîngî diyé, u tpile kîngmê nya, lîmîlîmî ngê dpî mbêpê we, mbu mbêmê dp꞉uu mbwolo we. ");
INSERT INTO yle_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Yepê, Dini ghi n꞉ii ngê yi kópu wa pyódu, mbwili knî y꞉oo dpodo ndîî wa a pyw꞉ee ngmê, p꞉aa knî y꞉oo dpodo ndîî amyedê pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yepê, Chóó Lémi ka dny꞉oo ngêpê, Tpii yópu yi dye ghi ngê daapîdny꞉oo mbêpê, lîme wo ngê yi kópu daapaa pyaa we. Yepê, Kî p꞉aani u mbwa keńe kuwo ngmê ngê adî ya, ye angênté wa mbêpê dmi. ");
INSERT INTO yle_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yepê, Yi dini ghi ngê Nju tpémi y꞉oo dono ndîî wa a pyw꞉ee ngmê. Yepê, Dono kópuni pi knî y꞉oo wunê a pyw꞉ee tumo, yini têdê dé, kn꞉ââ Chóó Lémi ngê dyámê pê mwo a l꞉âmo ngê, u dî ala ngwo. Yepê, Yi dono ndîî u kuwó dini ghi ngê, yintoo dono daamuwa a pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yepê, Chóó Lémi ngê yinê a vyu, apê, Yélini nê ngmidi ngê yi l꞉êê dîy꞉o, yi yéli yi pw꞉oopw꞉oo u dye ghi dêêkwédi ngê wanî pyódu. Yepê, Wodaa vyu, ye pi yintómu pî pw꞉oo dniye. ");
INSERT INTO yle_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Yepê, Yi dini ghi ngê, pini n꞉ii ngê nmye wa vyi, nmyewo, Chóó Lémi ngê n꞉ii a ngmidi ngê vyîlo ka kwo, yepê, yi pini ka kîdmyongê kêlîmî mbê dmi. ");
INSERT INTO yle_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yepê, Pi yilî knî y꞉oo kêêmî wa kaa t꞉oo, pi knî ye wadnyi k꞉omodanê, yewo, Chóó Lémi ngê a ngmidi noo. Yepê, Pi knî y꞉oo yoo wamye dóó ngmê, Chóó Lémi u komo k꞉omodanê ngê wa kaa ngmê. Yepê, Yi pini knî y꞉oo mbwudu yilî wa chaa ngmê, mu kópu u dîy꞉o u yi y꞉e adî kwo, Chóó Lémi ngê yélini a ngmidi ngê, nmî dóó té. ");
INSERT INTO yle_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yepê, Yi k꞉omodanê pyu knî y꞉oo kîngî dóó nmyo. Yepê, Kópuni wa pyaa dmi, yi kópu knî yi p꞉uu nmyi ng꞉aa dmi yidî t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yepê, Pi knî y꞉oo nmye wa vyi ngmê, Nê chii mênê kîyedê tóó, ye y꞉i nangmê nî. Yepê, Nmye wa vyi ngmê, Ngomo k꞉oo kêdê mbwolî, ye ng꞉aa ngê kêê nangê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yepê, Daa p꞉aa ngmidi tpémi y꞉oo Chóó Lémi u Pi Ndêndê wa m꞉uu ngmê, ngmênê pi yintómu knî y꞉oo wa m꞉uu ngmê. Yepê, Lîmî ntee dpî pywálî, pi yintómu knî y꞉oo ntee dpî m꞉uu ngmê, Chóó Lémi u Pi Ndêndê yinté amye m꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","U kuwó dini ghi ngê Yesu ngê mgongo ye ngmê kwólu, yepê, Chaapyu w꞉uu nt꞉ee ngmanmyi m꞉uu ngmê, anmyinê w꞉ee ngmê, anye, Mgomo k꞉ii a kwo. Yepê, Doo u ntââ yi kópu daanmyi kn꞉aadi ngmê. ");
INSERT INTO yle_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesu ngê yepê, Yi dye ghi dono u kuwó dini ghi ngê, d꞉ââ kââdî wa a mgêdê knî, mêdaadpî pil꞉apil꞉a, pudu yilî yintómu wa a ghay dmi, Chóó Lémi ngê mbóó p꞉uu tpile dé yi dînê dmi wa ghêê té. ");
INSERT INTO yle_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yepê, U kuwó dini ghi ngê dyámê mbêmê pi dyêêdî yintómu knî y꞉oo ayi m꞉uu nê, tpéé kópu amî vyi ngmê, adnyi nkîngê, amyednyi mbê. Yi ngwo wa m꞉uu nê, wamye mya nê, awo, Chóó Lémi u Pi Ndêndê kîyedê pwiyé knî, u pi ndîî ngê dê pyódu, u wêdêwêdê ndîî ngê myaa pyódu, nkalî too pee dmi mbêmê ka kwo. ");
INSERT INTO yle_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yepê, Pi knî y꞉oo nkéli dpuwo u dnye ndîî angmê ny꞉ee ngmê, enjel yoo wanê dy꞉ââ té, dyámê mbêmê ghi yintómu y꞉i wa lee dmi, Chóó Lémi ngê yélini a ngmidi ngê wa a danê t꞉oo, y꞉i ye anîn꞉aa vyuwo. ");
INSERT INTO yle_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesu ngê p꞉uu ndiye pyu knî ye mgongo ngmê kwólu. Yepê, Dini ghi n꞉ii ngê kpêdê vyi dpî ghê, nmyi lama u ngwo dpî yââ, nmyimo, Daa kêmakêma nt꞉eemi wunê mbumu. ");
INSERT INTO yle_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yepê, Kpêdê ngê ntee nmye dpî vyi, Daa kêmakêma nt꞉eemi wunê mbumu, yepê, kópuni p꞉uu nmye nî danê, dini ghi n꞉ii ngê yi kópu wanmyi m꞉uu t꞉oo, yinté nmyi lama u ngwo wa yââ, anye, Yi kópu daa kêmakêma a pyodopyodo. ");
INSERT INTO yle_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Yélini ala ngwo a pyede, ghêlî daawa pw꞉oo dmi, Njedusalem p꞉uu kópuni nmye dî vyi, yi kópu mwiyé wa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yepê, Mbóó dyámê chedê ngê wa pyaa knî, ngmênê a kópu dyuu chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesu ngê yepê, Wéni n꞉ii ngê dyámê mbêmê amênê diyé, yi wéni pi u lama daa tóó. Yepê, Enjel yoo yi lama myedaa tóó. Yepê, K꞉omo tpile nê Chóó Lémi tp꞉oo, a lama myedaa tóó. Yepê, Ngmênê M꞉aa mu ngmidi u lama wunê tóó. ");
INSERT INTO yle_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yepê, Nówa u dye ghi ngê yoo ntee doo a kwo, wéni n꞉ii ngê Chóó Lémi u Pi Ndêndê amêdê diyé, yoo yinté amyaa kwo. ");
INSERT INTO yle_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yepê, Nówa u dye ghi ngê yoo dêdnyimo a nkîngê, dnya a kmaapî, dnya a mbwaa ndanî, dnyimo a yééyéé, u dî wéni n꞉ii ngê Nówa p꞉uu nkéli k꞉oo wo dniye, ");
INSERT INTO yle_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","wo yéli vyi ngê vyâ, daa yi lama pw꞉oo dniye. Yepê, Chóó Lémi u Pi Ndêndê wéni n꞉ii ngê wa a diyé, yinté wa t꞉aa. ");
INSERT INTO yle_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yepê, Yi dini ghi ngê pi miyó yâpwo têdê adpî dpodo, enjel knî y꞉oo woni wa ngî ngmê, woni wa a kuwo ngmê. ");
INSERT INTO yle_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yepê, Pyââ miyó adpî ghee, enjel knî y꞉oo woni wa ngî ngmê, woni wa a kuwo ngmê. ");
INSERT INTO yle_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yepê, Mb꞉aamb꞉aa ngê dmyinê t꞉ââ, mu kópu u dîy꞉o wéni n꞉ii ngê nmyi Lémi wa a diyé, nmyi lama daa tóó. ");
INSERT INTO yle_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yepê, Ala kópu ny꞉ee yó. Yepê, Nmyi lama daa tóó wéni n꞉ii ngê kpáápi ngê nmyi ngomo wa pwââ. Yepê, Yi wéni nmyi lama adî ya knomomê, wanmyi t꞉ââ ngmê, am꞉ii ngm꞉ii kalê ngmê. ");
INSERT INTO yle_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yepê, Yinté myedmyinê t꞉âât꞉ââ nê, mu kópu u dîy꞉o dini ghi n꞉ii ngê nmyinê nmye Chóó Lémi u Pi Ndêndê daawa t꞉aa, yepê, vyîlo yi dini ghi ngê wanê t꞉aa. ");
INSERT INTO yle_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu ngê yepê, Ala kópu ny꞉ee yó. Yepê, Lémi ngmê ngê pi ngmê wa ngmidi, u dpodo pyu yoo yi kada pini ngê wa pyódu, u kwo wa vyi, kwowo, Dy꞉oo ye cha a châpwo, yi nté ndapî ye chi yémî dê. Yepê, Yi lémi kuughê wa lê, dye ghi daadîî y꞉i adîn꞉aa ya. Yepê, Pini n꞉ii wa ngmidi, dpodo pyu yoo yi kada wa kââ, yepê, yi pini u nuw꞉o ndîî ngê adî ya knomomê, u l꞉êê ghi mb꞉aamb꞉aa ngê a myaa ya, ye yi pini lónté adî dpodo? ");
INSERT INTO yle_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yepê, Dini ghi n꞉ii ngê yi lémi u p꞉o amêdê diyé, tpile yilî yintómu mb꞉aamb꞉aa ngê wa m꞉uu té, ye u gha mb꞉aamb꞉aa ngê wa pyódu, ");
INSERT INTO yle_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","dpodo pyu yoo yi kada pini wa chaa kwolo, u tpile yilî yintómu u kwo wa y꞉ee té, yi kada pini ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yepê, Ngmênê yi lémi ghêlî daawa taa knomomê, dpodo pyu knî yi kada pini alanté adî nuw꞉o, awo, Nmî lémi kêma amêdê diyé, yepê, yi pini pi dono ngê wa pyódu, ");
INSERT INTO yle_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","adî ńuknweńuknwe, mbwaa ndanî pyu knî yi vy꞉o adîn꞉aa mbwaa ndanî, dpodo pyu dpodo módó yoo adî kpakakpaka dé, ");
INSERT INTO yle_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ye dpodo pyu yoo yi kada pini doo u lama, yi lémi ayi t꞉aa. ");
INSERT INTO yle_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yepê, Yi kópu dini ghi n꞉ii ngê wa ny꞉ee té, d꞉ud꞉umbiy꞉e yi pini ka wa nod꞉e, dnyinté daawa kpada, k꞉omodanê pyu yoo yi vy꞉o wa kââ, y꞉i adnyin꞉aa mbê, yi kpéngi ti dmi kelekele adnyin꞉aa paa. ");
INSERT INTO yle_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu ngê mgongo ye ngmê kwólu, yepê, Chóó Lémi kóó k꞉oo wowo alanté. Yepê, Pi ngmê, daa kêmakêma doo yééyéé. Yepê, Yééyéé u wo ngmidi ngópu, yi wéni ntumokwodo dmââdî u yoo knî y꞉oo yi pini dnye t꞉âât꞉ââ. Yepê, Yi dmââdî u yoo vy꞉o kwodo y꞉a doo kwo, apê, Nmî mbwó u pyipe dini ghi n꞉ii ngê a taataa, nmî mbwó nmo ng꞉uu, yééyéé kmaapî têdê nipi nmîmo taataa té. Yepê, Yi kwodo y꞉a knî y꞉oo yi lam ńuw꞉o tumo, naa chóó p꞉aa ngmê dnyen꞉aa t꞉âât꞉ââ. ");
INSERT INTO yle_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yepê, Dmââdî limi nuw꞉o mbêmê dnye paa, mê limi daa nuw꞉o mbêmê dnye paa. ");
INSERT INTO yle_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","Yepê, Dmââdîni yoo nuw꞉o mbêmê dnye paa, yi lam ńuw꞉o tumo, yi kedîsin pód꞉a mye ńuw꞉o tumo, wo limi knî y꞉oo yi lam ńuw꞉o tumo, ngmênê yi kedîsin pód꞉a daa ńuw꞉o tumo. ");
INSERT INTO yle_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yepê, Naa chóó ngê mgî a puwâ, wod꞉oo yi dmââdî yoo dnye dpîîdpîî, u kuwó dini ghi ngê dpî dniye. ");
INSERT INTO yle_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Yepê, Mgîdî ńuknîńuknî p꞉uu pi ngmê ngê yepê, A pii dmyeno, naa chóó maadî kîyedê kwo. ");
INSERT INTO yle_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yepê, Wod꞉oo yi dmââdî y꞉a knî a pii dniye, n꞉ii yoo nuw꞉o mbêmê dnye paa, yi lam knî yi k꞉oo kedîsin yé ngópu. ");
INSERT INTO yle_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yepê, N꞉ii yoo daa nuw꞉o mbêmê dnye paa, yi pyipe knî ye yepê, Nmî lam ka pwopwo té, kedîsin knî nmo ngma a kê yó. ");
INSERT INTO yle_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yepê, Yini knî y꞉oo yepê, Doo u ntââ, kedîsin kudu chedê. Yepê, P꞉o dmyinê lêpî, nmyi chóó pi knî ye knî ngmênmyi dmy꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yesu ngê yepê, Wod꞉oo kada a y꞉ee ngópu, kedîsin mgîpî têdê lee dniye. Yepê, Yi kuwó naa chóó p꞉uu taa dniye, dmââdîni limi knî y꞉oo dnye t꞉âât꞉ââ p꞉uu kaa dniye, yééyéé u kmaapî têdê lee dniye. Yepê, Y꞉i taa dniye, ngomo k꞉oo kee dniye, keńe a kuwo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Yepê, U kuwó dini ghi ngê dmââdîni limi knî kedîsin mgîpî têdê lee dniye, yedê diyé dniye, keńe p꞉uu dnye depedepe, naa chóó ka kwo, Keńe nmo a kpêmî ngi. ");
INSERT INTO yle_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Yepê, Ngmênê yi nááli chóó ngê keńe ye daa kpêmî ngê, yepê, Dp꞉ee a lama yéli. ");
INSERT INTO yle_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Wod꞉oo Yesu ngê yepê, Nuw꞉o mbêmê dmyinê paa, u ngwo dmyinê t꞉âât꞉ââ nê. Yepê, Wéni n꞉ii ngê amênê diyé, yi wéni nmyi lama daa tóó. ");
INSERT INTO yle_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu ngê mgongo ye m꞉uu kwólu, yepê, A yoo vy꞉o ya alanté. Yepê, Lémi ngmê, kn꞉aa dyámê pee p꞉uu doo lêpî. Yepê, Ghêlî daa n꞉ee, u dpodo pyu pyile knî a danê too, u ndapî yi kêê yedê yó, yepê, A ndapî ka mb꞉aamb꞉aa ngê a kuwó dmyinê vyuwo. ");
INSERT INTO yle_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yesu ngê yepê, N꞉ii u nuw꞉o ndîî, yi pini ka ndapî ndîî y꞉ângo, n꞉ii u nuw꞉o têdê, ndapî têdê u kwo y꞉ângo. Yepê, N꞉ii u nuw꞉o ndîî, yi pini ka ndapî limo yono yono y꞉a (5,000) y꞉ângo, pi m꞉uu ka my꞉oo yono yono y꞉a (2,000) y꞉ângo, pyoloni ka yono yono y꞉a (1,000) y꞉ângo. Yepê, U kuwó dini ghi ngê yi lémi ngê a kuwo too, kn꞉aa dyámê pee p꞉uu loo. ");
INSERT INTO yle_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yepê, Dpodo pyu n꞉ii ka limo yono yono y꞉a y꞉ângo, yi pini ngê nkéli tp꞉oo u ngwo ngmê pwila ngê. Yepê, Yi pini ngê yi nkéli mb꞉aamb꞉aa ngê doo mbêpê kîgha, ndapî mê limo yono yono y꞉a u ngwo kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yepê, Myenté, pini n꞉ii ka my꞉oo yono yono y꞉a y꞉ângo, yi pini ngê stówa ngmê pyidu ngê. Yepê, Yi stówa mb꞉aamb꞉aa ngê doo mbêpê kîgha, ndapî mê my꞉oo yono yono y꞉a u ngwo kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yepê, Ngmênê n꞉ii ka yono yono y꞉a y꞉ângo, yi pini ngê mgî ngmêmî chó, u lémi u ndapî y꞉i mî ngmo ngê. ");
INSERT INTO yle_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Yesu ngê yepê, Dye ghi daadîî yi lémi kn꞉aa dyámê pee p꞉uu doon꞉aa ya, u kuwó dini ghi ngê mêdê diyé wo, yi dpodo pyu pyile knî a danê too, yepê, Ndapîni nmye nê kê too, mê wumo tóó. ");
INSERT INTO yle_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yepê, N꞉ii ka limo yono yono y꞉a y꞉ângo, yi pini ngê u lémi ka kwo, Limo yono yono y꞉a n꞉ii a ka nyinê kpo, mê limo yono yono y꞉a u ngwo m꞉aa kmênê ngê. Kwo, Yi ndapî ala, wod꞉oo u kwo y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Yepê, Yi lémi ngê kwo, Y꞉ay꞉a chi pwiyé, d꞉ii pi dódó pyu. Kwo, Daa ndîî dpodo ṉga yinî kpo, yi dpodo mb꞉aamb꞉aa ngê nyi dóó, dpodo yilî yi kada pini ngê n꞉aa pyépi ngi. Kwo, Ṉg꞉ii mb꞉aamb꞉aa ngê nyi yakmaapî knî. ");
INSERT INTO yle_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pini n꞉ii ka my꞉oo yono yono y꞉a y꞉ângo, yi pini ngê u lémi ka kwo, My꞉oo yono yono y꞉a n꞉ii a ka nyinê kpo, mê my꞉oo yono yono y꞉a u ngwo m꞉aa kmênê ngê. Kwo, Yi ndapî ala, wod꞉oo u kwo y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yepê, Yi lémi ngê kwo, Y꞉ay꞉a chi pwiyé, d꞉ii pi dódó pyu. Kwo, Daa ndîî dpodo ṉga yinî kpo, yi dpodo mb꞉aamb꞉aa ngê nyi dóó, dpodo yilî yi kada pini ngê n꞉aa pyépi ngi. Kwo, Ṉg꞉ii mb꞉aamb꞉aa ngê nyi yakmaapî kmêle. ");
INSERT INTO yle_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Yepê, Pini n꞉ii ka yono yono y꞉a y꞉ângo, yi pini ngê u lémi ka kwo, A lémi. Kwo, A lama ka tóó, Nyi nkéli kmungo pyu. Kwo, Pi knî ye ntoo ndapî n꞉ii nye yémî ngê, daa yintoo ndapî mêyinyinê pwapî ngê, pââ ndîî yinyinê pwapî ngê, ntini woo n꞉ii d꞉ii kapî ngê, vyîlo y꞉ee pîpî ngê. ");
INSERT INTO yle_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kwo, Ṉga nî nkîngê mbê wo, nê, Ndapî l꞉âmo wanî ngee, nê, angênté a ka wa t꞉aa. Kwo, Yi kópu u l꞉êê dîy꞉o ṉapî mgî k꞉oo nî ngmo ngê. Kwo, Ṉ́yóó ṉapî mê ala. ");
INSERT INTO yle_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Yesu ngê yepê, Yi lémi ngê kwo, D꞉ii dpodo pyu mb꞉aa, nyi pweekaa pyu. Kwo, Ṉ́yóó ṉgópu knî yi l꞉êê dîy꞉o n꞉aa kpadakpada ngi. Kwo, Ḻama modoo ya, Pi knî ye têdê yinî yémî ngê, pââ ndîî mêyinînê pwapî ngê, ntini woo n꞉ii dînî kapî ngê, vyîlo yinî pîpî ngê. ");
INSERT INTO yle_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kwo, Lukwe dîy꞉o a ndapî, ndapî u ngomo k꞉oo dipi yó, ndapî knî m꞉uu pînê puwâ. ");
INSERT INTO yle_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yesu ngê yepê, Yélini yoo y꞉i dnye kwo, yi lémi ngê yepê, A ndapî kwulo a ngee yó, pini n꞉ii u ngópu yono yono yono y꞉a a tóó, u kwo y꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yepê, N꞉ii u ngópu tpile yilî a tóó, mu dini ghi ngê mê yilî wa a pyw꞉oo, n꞉ii u ngópu tpile pyile njini a tóó, yi tpile knî yi l꞉âmo wa a ngee té. ");
INSERT INTO yle_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yepê, Kî dpodo pyu mgee kuwa d꞉ii yó, mgîdî vy꞉o choon꞉aa ya. Yepê, Y꞉i choon꞉aa mbê, u kpéngi ti dmi kelekele choon꞉aa paa. ");
INSERT INTO yle_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu ngê yepê, Dini ghi n꞉ii ngê a pi ndîî ngê wa pyódu, enjel knî yi k꞉ii nipi anmo diyé dmi, a yoo y꞉enê têdê wan꞉uu yââ, ");
INSERT INTO yle_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","dyámê mbêmê pi yintómu anê danê té, a ngîma adnyin꞉aa kwo. Yepê, Tpile tp꞉oo y꞉eey꞉ee pyu ngê sipi nunukwéti ntee dpî chámê té, ");
INSERT INTO yle_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","yoo yintómu yinté wanî chámê té. Yepê, Yoo mb꞉aa, sipi ntee yéli, a wéni pee wanî kaa té, wo yéli nunukwéti ntee yéli, a t꞉anê pee wanî kaa té. ");
INSERT INTO yle_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yepê, A wéni pee yéli ye ala kópu wanî vyi, yenê, M꞉aa ngê a ngmidi nmyoo, myedê ngee nmyoo. Yenê, Dyámê pê ghêlî dêpwo a kwo, M꞉aa ngê apê, A nuu u yoo a kêê k꞉oo wa ghê dmi. Yenê, Ala u dye ghi, kóó k꞉oo anyi ghê dmyeno. ");
INSERT INTO yle_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mu kópu u dîy꞉o, yenê, Dómu a nga mudoo a ya, nmyi mbono noo. Yenê, Mbwaa a nga mudoo a ya, a ka nmyinê kê ngópu. Yenê, Kn꞉aa p꞉aani munê ndê wo, nmyi p꞉o munê ta, a ka nmyee a vyuwo. ");
INSERT INTO yle_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yenê, Kn꞉ââ mbwii munoo a kwo, kpîdî a ka nmyinê kê ngópu. Yenê, Munoo a mbii, mb꞉aamb꞉aa ngê a ka nmyee a vyuwo. Yenê, Mbwa k꞉oo munoo a kwo, a gha nmyeen꞉aa wêdêwêdê kîgha. ");
INSERT INTO yle_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yepê, Yi ngwo yoo mb꞉aa knî y꞉oo a ka wa vyi ngmê, a ka wo, Nmî Lémi. A ka wo, Ló dini ghi ngê dómudómu têdê nmî m꞉uu nyoo, u ngwo nmî mbono nyoo? A ka wo, Ló dini ghi ngê mbwaambwaa têdê nmî m꞉uu nyoo, mbwaa ṉga u ngwo nmo kpo? ");
INSERT INTO yle_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","A ka wo, Ló dini ghi ngê nmî p꞉o ny꞉uu ta, ṉga u ngwo nmee a vyuwo? A ka wo, Ló dini ghi ngê kn꞉ââ mbwii nmî m꞉uu nyoo, kpîdî ṉga u ngwo nmo a kpo? ");
INSERT INTO yle_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","A ka wo, Ló dini ghi ngê mbii têdê ó mbwa k꞉oo nmî m꞉uu nyoo, ṉga u ngwo nm꞉uu wêdêwêdê kwólu? ");
INSERT INTO yle_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yi yéli ye yenê, Ndê kópu nmye ngmên꞉aa tpapê. Yenê, A yoo vy꞉o pini ngmê, k꞉omo tpile u pi daa ndîî, ngmênê yi pini yinté nmyi ngee ngópu, yenê, daa yi pini vy꞉ii ngee ngópu, nê vy꞉ii ngee noo. ");
INSERT INTO yle_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Yepê, Yi ngwo yélini a t꞉anê pee adnyi kwo, yenê, Nmyo Chóó Lémi u vyîda yoo, a nkîgh꞉ê a y꞉ee dmyeno. Yenê, Ndê ngê a pîpî nmyo. Yenê, Yi ndyuw꞉e chedê ngê daawa pyódu. Yenê, Yi ndyuw꞉e M꞉aa ngê Setan u dpodo pyu knî yi k꞉ii yi l꞉êê dîy꞉o kpó, adî pîpî dé, amyaa pîpî nmyo. ");
INSERT INTO yle_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mu kópu u dîy꞉o, yenê, munoo a dómudómu, dpîp꞉e mbono noo. Yenê, Mbwaa a nga mudoo a ya, a ka dpîp꞉e kê ngópu. ");
INSERT INTO yle_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yenê, Kn꞉aa p꞉aani munê ndê wo, nmyi p꞉o munê ta, a ka dênmyee a vyuwo. Yenê, Kn꞉ââ mbwii munoo a kwo, kpîdî a ka dpîp꞉e kê ngópu. Yenê, Mbwa k꞉oo munoo a kwo, mumyenoo a mbii, ngmênê a ka dênmyee a vyuwo. ");
INSERT INTO yle_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yi ngwo yi yéli y꞉oo a ka wo, Nmî Lémi, ló dini ghi ngê dómudómu têdê nmî m꞉uu nyoo, mbwaambwaa têdê nmî m꞉uu nyoo, nmî p꞉o ny꞉uu ta, kn꞉ââ mbwii nmî m꞉uu nyoo, mbii têdê ó mbwa k꞉oo nmî m꞉uu nyoo, ngmênê yi ngwo y꞉i dpîpî ngee nyoo? ");
INSERT INTO yle_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yi yéli ye yenê, Ndê kópu nmye ngmên꞉aa tpapê. Yenê, Pini n꞉ii u pi daa ndîî yinté p꞉ee ngee ngópu, yenê, daa yi pini yip꞉ee ngee ngópu, nê yip꞉ee ngee noo. ");
INSERT INTO yle_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yepê, Yi kpadakpada têdê wanî dy꞉ââ té, y꞉i adnyin꞉aa ya, chedê ngê daawa pyódu. Yepê, Yoo mb꞉aa knî y꞉oo ghê kamî wa a pyw꞉ee ngmê, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu ngê u danêmbum dini ghi n꞉ii ngê pi knî ye a kêlî ngê, p꞉uu ndiye pyu knî ye yepê, ");
INSERT INTO yle_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Nmyi lama ka tóó, Tp꞉ee Kaa W꞉êêw꞉êê u naa m꞉ii wanmî kê. Yepê, Yi ngwo kada pini knî y꞉oo Lóma lede yoo yi kêê k꞉oo wa kaa nê, kîdosi ńedê u nkwo wamî t꞉ee nê. ");
INSERT INTO yle_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yi ngwo kada pini yoo, kpêê yiyé pyu yoo yi kada pini yoo yi k꞉ii, kpêê yiyé pyu yoo yi kada pini ndîî u ngomo k꞉oo mînê wó. Yi pini u pi Kayapas. ");
INSERT INTO yle_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yi kada pini knî y꞉oo Yesu u pwele yi ngwo a châpwo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Noko yepê, Naa ndîî m꞉ii. Noko yepê, Yi kópu naa kpo nakî d꞉uu. Noko yepê, Pi yilî kêdê t꞉aa, wa gheteghete mbê dmi. ");
INSERT INTO yle_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu Petani doon꞉aa ya, Saimon u ngomo k꞉oo doon꞉aa kmaapî. Yi pini p꞉uu too pee mbii leprîsi mwiyé doo ya. ");
INSERT INTO yle_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yi kmaapî têdê pyââ ngmê ngê pód꞉a ngma a ńuwo, tuu mb꞉aamb꞉aa, Yesu mbêmê d꞉ud꞉umbiy꞉e a pii ngê. Yi tpile u pywuu ndîî. ");
INSERT INTO yle_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesu p꞉uu ndiye pyu knî y꞉oo yi kópu yi m꞉uu ngópu, yi pyópu ka nod꞉e dniye, noko yepê, Lukwe dîy꞉o dê dyênê. ");
INSERT INTO yle_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Noko yepê, Kî pyópu ngê nmo woda kê, ye ndapî ndîî pudu kmênê, yi ndapî ndîî pinté knî ye pudu y꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kópuni tumu dnye nyepênyepê, Yesu ngê a w꞉ee ngê, yepê, Lukwe dîy꞉o dmye mywenemywene kalê ngmê. Yepê, A nuu u kópu a nga yi d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yepê, Dye ghi yintómu u ntââ pinté yoo anmya a pyw꞉êmî dé. Yepê, Dini ghi n꞉ii ngê u yi nmye adî kwo, Nmî ngee té, yepê, u ngwo dmyinê ngêêpî dé. Yepê, Mu dini ghi ngê nmyi vy꞉o mêdaanî kwo. ");
INSERT INTO yle_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yepê, Tpileni tuu mb꞉aamb꞉aa pi ntóó p꞉uu ntee anyi d꞉ii, u ngwo any꞉uu kmênê, yepê, kî pyópu ngê yinté kópu a pwopwo u l꞉êê dîy꞉o myeyi d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Pi knî y꞉oo a kópu mb꞉aa dyámê ghi knî yi mbêmê kwéli adnyin꞉aa nyêm, kî pyópu ngê kópuni a nga dê d꞉uu, amyimî ny꞉ee ngmê. Yepê, Kópuni a nga dê d꞉uu, u mgamê ngê adîn꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yesu p꞉uu ndiye pyu y꞉a mê miyó knî yi vy꞉o pi ngmêdoo kwo, u pi Njudas, Kédiyót pi. Yi ngwo kpêê yiyé pyu yoo yi kada pini knî ye loo, ");
INSERT INTO yle_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yepê, Yesu u kwódo ngê anî ghê knomomê, ye lukwe a ka ngmanmyinê kê ngmê? Wod꞉oo ndapî pyoloy꞉a u kwo y꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yi ngwo Njudas ngê dye ghi doo y꞉enê, apê, Yesu kwódo ngê wu dini ghi ngê anî ghê. ");
INSERT INTO yle_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Wéni n꞉ii ngê Mbîdédi Pywápê Ngmê u Naa dnyimo kuwo, Tp꞉ee Kaa W꞉êêw꞉êê u Naa nté u ngwo myednyimo l꞉âmol꞉âmo. Yi wéni ngê Yesu p꞉uu ndiye pyu yoo Yesu ka póó dniye, kwo, Mââwe. Kwo, Tp꞉ee Kaa W꞉êêw꞉êê u nté ló y꞉i nmîmo l꞉âmol꞉âmo? ");
INSERT INTO yle_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu ngê pi miyó pi ngmê ka dy꞉ââ doo, Njedusalem. Yepê, Ala kópu u kwo dp꞉uu vyi nyoo, kwipi, Nyi mââwe ngê ṉga atédê dy꞉ââ nyo. Kwipi, U dye ghi machedê, u p꞉uu ndiye pyu knî yi k꞉ii naa u nté ṉgomo k꞉oo nmîmo pîpî. ");
INSERT INTO yle_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wod꞉oo kada a y꞉ee ngópu, Njedusalem lee knopwo, kópuni Yesu ngê ye vyu, yinté mî d꞉uu ngópu, yi nááli u nté yi ngomo k꞉oo mî l꞉âmo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kââdî dini ghi n꞉ii ngê gho, Yesu, p꞉uu ndiye pyu y꞉a mê miyó knî yi k꞉ii, yi kmaapî têdê yaa dniye. ");
INSERT INTO yle_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dini ghi n꞉ii ngê dnye kmaapî, Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê, yepê, nmyi vy꞉o pini ngmê a kwódo ngê a wowo. ");
INSERT INTO yle_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","P꞉uu ndiye pyu knî yi nuw꞉o dmi dono ngê pyodo, ngmêngmênté u kwo doo póó, kópu, Nê kuu, apii? ");
INSERT INTO yle_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu ngê yepê, K꞉omo tpile d꞉ââ mu ngmidi k꞉oo mbîdédi n꞉êê nmo kmênêkmênê té, ngmênê nmyi vy꞉o pini ngmê a kwódo ngê a wowo. ");
INSERT INTO yle_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yepê, Ala kópu puku yedê ló dini mwo a d꞉êê ngópu, apê, Chóó Lémi u Pi Ndêndê u kwódo ngê pi angmê ghê, pi knî y꞉oo wa mgîmî ngmê, wa kpaka ngmê, wa vya ngmê. Yepê, Pini n꞉ii ngê yi kópu a ntiyentiye, a kwódo ngê a wowo, yi pini d꞉ud꞉umbiy꞉e choo nkîngê, Chóó Lémi ngê dpodombiy꞉e wa kpada. Yepê, Yi pini ngê u kpadakpada têdê ala kópu wamî vyi, awo, L꞉omo m꞉aa ta, yi dono daap꞉aa d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pini n꞉ii Yesu u kwódo ngê doo wowo, Njudas, yi pini ngê kwo, Nê kuu, apii? Yesu ngê kwo, Ṉ́yóó kîchi vyi. ");
INSERT INTO yle_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dini ghi n꞉ii ngê dnye kmaapî, Yesu ngê mbîdédi a ngêêdî, Chóó Lémi kwuno ngê, puwâ, p꞉uu ndiye pyu knî ye y꞉ângo, yepê, Ala a chóóchóó, nê. ");
INSERT INTO yle_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","U kuwó dini ghi ngê kapî a y꞉ângo, wain k꞉oo a pii ngê, kumu mbee ngê, Chóó Lémi kwuno ngê, p꞉uu ndiye pyu knî ye mye y꞉ângo, yepê, Nmyo yintómu nda yó. ");
INSERT INTO yle_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yepê, Ala a wêê. Yepê, Pi yilî yi dono chedêchedê u l꞉êê dîy꞉o, wêê a p꞉uu wa pwii. Yepê, Yi wêê ngê Chóó Lémi ka pi yilî wa a kââdî. ");
INSERT INTO yle_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yepê, Ala kópu ny꞉ee yó. Yepê, Wain daamunî nda, u dî wéni n꞉ii ngê a pi ndîî ngê amî pyódu, pi yintómu anîn꞉aa y꞉enê, M꞉aa kóó k꞉oo kmaapî ndîî u ngwo anm꞉uu dóó, wain kamî u ngwo anm꞉uu nda. ");
INSERT INTO yle_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","U kuwó dini ghi ngê wéti ngma a ngî ngópu, Njedusalem a kuwo ngópu, mbu mbêmê mî kee dniye, mbwini n꞉ii u pi Olipi. ");
INSERT INTO yle_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu ngê yepê, Dini ghi n꞉ii ngê pi knî y꞉oo awêde mgîdî vy꞉o a mgîmîmgîmî nê, nmyinê kuwokuwo nê, nmye mbêpêmbêpê té. Yepê, Puku yedê alanté a tóó, Dini ghi n꞉ii ngê Chóó Lémi ngê Sipi y꞉enê pyu wa vy꞉a, sipi w꞉uu wa mbêpê dmi. ");
INSERT INTO yle_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yesu ngê yepê, Dini ghi n꞉ii ngê amênî pyidu, nmyi kada anî ghê, Nkálili anî lê. ");
INSERT INTO yle_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita ngê kwo, K꞉omo tpile kî tpóknî y꞉oo wunê kuwokuwo ngi, ngmênê nê mu ngmidi daanê kuwo ngi. ");
INSERT INTO yle_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu ngê Pita ka kwo, Ndê kópu ṉga ngmên꞉aa tpapê. Kwo, Mgîdî vy꞉o kêmkêm ghêlî k꞉ii daawa kââ, pyolo nyinê wópuwópu nê, pi knî ye ala kópu nye tpapê, yenye, D꞉aa p꞉uu dniye pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita ngê kwo, A Lémi. Kwo, Yi kópu daanî d꞉uu. Kwo, K꞉omo tpile ḻ꞉êê dîy꞉o wamye vya nê, myedaanê wópu ngi. Yesu p꞉uu ndiye pyu knî y꞉oo Yesu ka yinté mye vyi ngópu. ");
INSERT INTO yle_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","U kuwó dini ghi ngê Yesu, p꞉uu ndiye pyu knî yi k꞉ii, ghi ngmê lee dniye, u pi Nketsemane. Yesu ngê yepê, Al꞉ii dmyinê ya, mwi nîmo ngêpê. ");
INSERT INTO yle_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yesu ngê pi pyile kyedekyede mu mwada y꞉i ńuw꞉o too, Pita Sepédi tp꞉oo dê. Yesu u gha dono ngê pyodo, u ghê myedê kee wo. ");
INSERT INTO yle_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yi pini pyile knî ye yepê, A nuw꞉o dono ngê ayi chedêchedê nê. Yepê, Al꞉ii dmyinê ya, dpî ngê kêê nangê t꞉oo. Yepê, Dmyinê t꞉âât꞉ââ nê, a l꞉êê dîy꞉o myedmyinê ngêpê. ");
INSERT INTO yle_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesu ngê a kuwo too, pee tp꞉oo mwada y꞉i loo, têpê mbêmê kwódokwódombiy꞉e mî dyimê wo, u mî ka doo ngêpê, kwo, M꞉aa. Kwo, Tpile yilî yintómu ṉga u ntââ. Kwo, U ntââ ala dono u mbwaa daanî nda? Kwo, Ngmênê ṉgwépi daanî puwâ. Kwo, K꞉omo tpile ala kópu u ya a nga daa kwo, ngmênê a nga dpî d꞉uu ngi, mu kópu u dîy꞉o a kada nye tóó. ");
INSERT INTO yle_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","U kuwó dini ghi ngê Yesu yedê diyé wo, apê, A p꞉uu ndiye pyu yoo mu dpî té. Pita ka kwo, Lukwe dîy꞉o doo u ntââ, dye ghi dêêkwédi ntênê daanmyi ya? Kwo, Lukwe dîy꞉o a l꞉êê dîy꞉o dp꞉ee ngêpê té. ");
INSERT INTO yle_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yesu ngê yepê, Mb꞉aamb꞉aa ngê dmyinê vyuwo, dpodombiy꞉e dmyinê ngêpê, pi ngê dpodombiy꞉e kêdangê tókó nmyo, dono nmye daapêdê nî we. Yepê, K꞉omo tpile kópu mb꞉aa nmye tpapê tumo, ngmênê nmyi tókótókó têdê wanmyi dêê dmi. ");
INSERT INTO yle_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Myombó Yesu ngêpê têdê mê loo, u mî ka kwo, M꞉aa. Kwo, Kîd꞉a w꞉ee. Kwo, Dono mbwaa daanî nda knomomê, ye yoo angênté wanî ngee. Kwo, Yi dono mbwaa u wépi daanî puwâ, ṉ́yóó ṉuw꞉o u pono n꞉aa vyápê. ");
INSERT INTO yle_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","U kuwó dini ghi ngê p꞉uu ndiye pyu pyile knî ye mê diyé wo, apê, Mu dpî té. Dpî vyîlê ngê dyaa ye chedê ngê. ");
INSERT INTO yle_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pyolombó Yesu modoon꞉aa ngêpê. Mwiyémwiyé ntee doo ngêpê, yinté modoon꞉aa ngêpê. ");
INSERT INTO yle_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","U kuwó dini ghi ngê p꞉uu ndiye pyu knî ye yedê diyé wo, yepê, Mwo anmyi dpî té? Yepê, Angênté, dmyongê nyaa dniye? Yepê, Munto. Yepê, Ala u dye ghi. Yepê, Pi dono knî y꞉oo ala ngwo a mgîmîmgîmî nê. ");
INSERT INTO yle_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yepê, A pii dmyeno. Yepê, Paa ala. Yepê, Óó! Yepê, A kwódo ngê pini n꞉ii dê ghê, yepê, ka pwiyé knî. ");
INSERT INTO yle_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ngê danêmbum ghêlî daa chedê ngê, wod꞉oo lede yoo taa dniye, Njudas yi kada doo kwo, pini n꞉ii Yesu p꞉uu ndiye pyu y꞉a mê miyó knî yi vy꞉o pwii wo, Yesu yinê dóó. Yi lede knî y꞉oo kaa taa ńuw꞉o tumo. Yi yéli Nju tpémi yi kada pini knî y꞉oo dy꞉ââ tumo, yepê, Yesu nyinê mgîmî yó. ");
INSERT INTO yle_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Maa p꞉uu Njudas ngê yepê, Pini n꞉ii nînê chipéchipé, yepê, yi pini yi vyîlo. Yepê, Dpî mgîmî yó. ");
INSERT INTO yle_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dini ghi n꞉ii ngê taa dniye, Njudas Yesu ka loo, kwo, Mw꞉ââkó Mââwe. Njudas ngê Nju tpémi yi chipéchipé ngê Yesu u ngwo a chipé ngê, ń꞉uu Yesu kpââ pee p꞉uu dyîngo. ");
INSERT INTO yle_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu ngê kwo, Kópuni u pyinê cha ngmêê, d꞉uu ngi. Wod꞉oo lede knî y꞉oo Yesu dpodombiy꞉e mgîmî ngópu. ");
INSERT INTO yle_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesu p꞉uu ndiye pyu ngmê ngê u yi doo kwo, Lede yoo nî vya té, wod꞉oo u taa a ngêêdî, lede ngmê mbwámê pêdê châpwo, ngmênê kn꞉aadi ngê, ngwene ngmê ngópu. Yi lede kpêê yiyé pyu yoo yi kada pini u dpodo pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wod꞉oo Yesu ngê kwo, Ṉ́aa u dópo mênê mê kédi. Kwo, N꞉ii ngê taa ngê l꞉êê dpî dóó, yi l꞉êê têdê dpî pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kwo, Ḻama daa tóó M꞉aa ka wodî vyi, ye enjel yilî tp꞉oo témi tap a ka pêdê dy꞉ââ, paan꞉aa ngee nmo. ");
INSERT INTO yle_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kwo, Yi enjel yoo wodî dmy꞉ee té, ye ala yéli y꞉oo angênté paa mgîmî nê, kópuni puku yedê a tóó angênté myepaa ntiye ngmê. ");
INSERT INTO yle_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yesu ngê yi lede knî ye yepê, D꞉aa l꞉êê pyu ngmê. Yepê, Lukwe dîy꞉o kaa taa kêlê a ka dmyinê lee dmi. Yepê, Wo yilî yi k꞉oo Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo nmyi vy꞉o kînoo a kwo, y꞉i nîmon꞉aa dêêpî. Yepê, Lukwe dîy꞉o y꞉i dpîp꞉e mgîmî noo. ");
INSERT INTO yle_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yepê, Ngmênê alanté dmye mgîmî nê, mu kópu u dîy꞉o kópuni Chóó Lémi u komo kapî pyu knî y꞉oo wunê a d꞉êê tumo, doo u ntââ daapîdmye kn꞉aadi ngmê. Yi ngwo Yesu p꞉uu ndiye pyu knî y꞉oo Yesu a kuwo ngópu, mbêpê dniye. ");
INSERT INTO yle_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","N꞉ii knî y꞉oo Yesu mgîmî ngópu, kpêê yiyé pyu yoo yi kada pini ndîî Kayapas u ngomo k꞉oo ńuw꞉o ngópu. Yi ngomo k꞉oo kada pini yoo, dêêpî pyu yoo yi k꞉ii, mwiyé nipi a wó. ");
INSERT INTO yle_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita ngê Yesu doo yâmuyâmu, tumutumu yi kuwó doo a kwo, daa chono doo a paa. Dini ghi n꞉ii ngê Yesu ngomo k꞉oo mî kee wo, Pita yi ngomo mbwa kalê ngmê k꞉oo myimî kee wo, lede knî yi vy꞉o mî yaa wo, apê, Yesu ngê kópuni a d꞉uud꞉uu ngmê, a ngópu paa d꞉uu y꞉e. ");
INSERT INTO yle_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yi ngomo k꞉oo Nju tpémi yi kada pini knî y꞉oo Yesu dnyen꞉aa kóté kîgha. U yi y꞉e doo kwo, Yesu kn꞉ââ nmî ché, u ngwo nmî vy꞉a. Pi yilî knî y꞉oo yi chóó yi yipe tee kópu Yesu p꞉uu yilî t꞉ee ngópu, ");
INSERT INTO yle_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ngmênê pi miyó dê y꞉oo yi kópu ngmidi ngê daa pyódu ngópu, yi kópu u l꞉êê dîy꞉o Nju tpémi ye doo u ntââ ngê pyodo, Yesu daapî ndyîko ngópu. U kuwó dini ghi ngê pi miyó dê y꞉oo kópu mu ngmidi ngmê vyi ngópu, ");
INSERT INTO yle_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kada pini knî ye yepê, Kî pini ngê ala kópu nmo a vyu, nmopê, Nê u ntââ, Chóó Lémi u ngomo anê pw꞉ono, wo pyile amî lê, u ngwo am꞉aa wó. ");
INSERT INTO yle_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wod꞉oo kpêê yiyé pyu yoo yi kada pini ndîî ghêêdî wo, Yesu ka póó wo, kwo, Kópuni m̱꞉uu dê vyi ngmê, daanyinê vy꞉a? ");
INSERT INTO yle_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngmênê Yesu tumu doo ya. Myombó Yesu ka kwo, Yâpwoni ghê a t꞉a, yi yâpwo ngê a y꞉enê ngi. Kwo, Nmo kidimê k꞉omodanê. Kwo, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, Tp꞉oo n꞉ii nmo t꞉âât꞉ââ, kwo, mumdoo nyi vyîlo? ");
INSERT INTO yle_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu ngê kwo, Ṉ́yóó kîchi vyi. Kwo, Mu dini ghi ngê wanmyi m꞉uu nê, wanmyi vyi ngmê, anye, Kî Chóó Lémi u Pi Ndêndê. Anye, U pi ndîî ngê dê pyódu, Chóó Lémi u che p꞉ââ pee ngê dê pyódu, nkalî too pee dmi mbêmê muyedê pwiyé knî. ");
INSERT INTO yle_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesu ngê yi kópu dini ghi n꞉ii ngê u kwo vyu, kpêê yiyé pyu yoo yi kada pini ngê chóó u mbwo kpîdî a chópu, yi mââwe knî ye yepê, Kî pini u châpwo pyu u yi nmo daamu a kwo. Yepê, Chóóchóó kêdê ndyîko. Yepê, Ala kópu nmo dê vyi, Chóó Lémi u d꞉aa anê kââdî. ");
INSERT INTO yle_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yepê, Nmyi nuw꞉o dmi angênté a tóó? Kada pini yintómu knî y꞉oo kwo, Chóó u pye dê yé. Kwo, Vya koo, pw꞉oo we, daadî ya. ");
INSERT INTO yle_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","U kuwó dini ghi ngê kêpa dnye tpyîpwi, kîlî myednye kpakakpaka, ");
INSERT INTO yle_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","dnye nkwitinkwiti, kpîdî pee ngê ngwolo dê wópu dumo, u nkwo dnye vyee, kópu, N꞉aa dê vya ngi? Kópu, Chi dîpî. Kópu, W꞉ii Chóó Lémi u komo kapî pyu ngmê, ye pini n꞉ii ngê dê vya ngi, u pi nmo pîchi vyi. Kwo, Lukwe dîy꞉o nangê Chóó Lémi ngê a ngmidi nyoo. ");
INSERT INTO yle_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Dini ghi n꞉ii ngê Yesu dnye kóté kîgha, yi ngwo Pita yi ngomo mbwa kalê ngmê k꞉oo doo ya. Dpodo módó ngmê u kwo a loo, kwo, Nyi ngmê, Yesu Nkálili pi p꞉uu nye ya yédi. ");
INSERT INTO yle_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngmênê Pita ngê yoo yi ngîma u kwo a wópu ngê, kwo, Ye kópu d꞉oo w꞉ee ngê. ");
INSERT INTO yle_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wod꞉oo Pita pywuwópywuwó têdê u nkîgh꞉ê doon꞉aa kwo. Dpodo módó m꞉uu ngê y꞉i mye módu, pi knî ye yepê, Kî pini Yesu Nasalet pi p꞉uu kîdoo ya. ");
INSERT INTO yle_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Myombó Pita ngê mêdê wópu ngê, ye kpaa wo, yepê, Ye pini daa a lama pini. ");
INSERT INTO yle_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Daa ndîî dye ghi yimî loo, yi yéli Pita ka knî m꞉uu loo, kwo, Nye k꞉omodanê. Kwo, Nyi yi pini p꞉uu ndiye pyu ngmê. Kwo, Ṉye kînga dpî mya. Kwo, Dpî wee mu ngmidi, Nkálili Wee. ");
INSERT INTO yle_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Wod꞉oo Pita ye mê kpaa wo, yepê, Ye pini daa a lama pini. Vyîlo yi dini ghi ngê kêmkêm ngmê ka wo, ");
INSERT INTO yle_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","wod꞉oo Pita ngê Yesu u kópu mî nuw꞉o kwólu, apê, Yesu ngê a ka moda vyi, Kêmkêm ghêlî k꞉ii daawa kââ, pyolo nyinê wópuwópu nê. Wod꞉oo Pita u gha d꞉ud꞉umbiy꞉e dyênê wo, kuwa pwii wo, y꞉i doon꞉aa mbê. ");
INSERT INTO yle_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mw꞉aa mgîdî vy꞉o Nju tpémi yi kada pini yoo nipi dnyen꞉aa danêmbum, kpêê yiyé pyu yoo yi kada pini yoo mye yi k꞉ii. Yi danêmbum têdê Yesu u vyee u dy꞉oo a châpwo ngópu. ");
INSERT INTO yle_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","U kuwó dini ghi ngê Yesu kóó dê kudu dumo, Lóma lede yoo yi mââwe ndîî Paléti ka ńuw꞉o ngópu. ");
INSERT INTO yle_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pini n꞉ii Yesu u kwódo ngê ghê wo, Njudas, dini ghi n꞉ii ngê u lama yaa wo, apê, Yesu kêdê ndyîko ngmê, daa kêmakêma mye vyee ngmê, u nuw꞉o d꞉ud꞉umbiy꞉e dono ngê pyodo, apê, Dono kópu ngma atédî d꞉uu. Wod꞉oo Yesu kwódo ngê wowo u l꞉êê dîy꞉o ye ndapîni u kwo y꞉ee ngópu, yi ndapî pyolo y꞉a kada pini knî ye mêmî y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yepê, Dono ndîî ngmêdî d꞉uu. Yepê, Pini n꞉ii u dono daa tóó mo daa tóó, u kwódo ngê kîdî ghê, daa kêmakêma nmye vyee ngmê. Njudas ka kwo, Nmo mêkidimên꞉aa mbumu. Kwo, Ye kópu ṉ́yóó nyi l꞉âmo ngi. ");
INSERT INTO yle_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wod꞉oo Njudas Chóó Lémi u ngomo k꞉oo kee wo, yi ndapî dyuu y꞉i mî dy꞉ee too, wod꞉oo kuwa pwii wo, chóóchóó mînê nâkâ ngê, yed꞉oo pwene. ");
INSERT INTO yle_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kpêê yiyé pyu yoo yi kada pini knî y꞉oo yi ndapî mêdê ngî tumo, noko yepê, Ala ndapî Chóó Lémi u ngomo k꞉oo daadî ya, mu kópu u dîy꞉o wu pini ngê pi vyee u l꞉êê dîy꞉o kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yi ndapî p꞉uu noko dnye danêmbum, yed꞉oo têpê ghi u ngwo ngmê pwila ngópu, noko yepê, Pi my꞉oo n꞉ii Njedusalem adîn꞉aa pwopwo, y꞉i paan꞉aa kmênêkmênê koo. Yi têpê ghi d꞉ââ l꞉âmol꞉âmo pyu ka pwila ngópu. ");
INSERT INTO yle_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pi knî y꞉oo yi têpê ghi u pi ntaa ngópu, apê, Wêê u têpê ghi. Awêde u pi yinté mwo tóó. ");
INSERT INTO yle_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chóó Lémi u komo kapî pyu Njedîmaiya ngê kópuni wunê a d꞉êê ngê, yi ngwo ntiye ngópu. Yi kópu ala, Ndapîni u pi Yisîléli tpémi y꞉oo yi pini u l꞉êê dîy꞉o vyi ngópu, yi ndapî pyolo y꞉a a ngî ngópu, ");
INSERT INTO yle_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","d꞉ââ l꞉âmol꞉âmo pyu ka u têpê ghi u ngwo pwila ngópu. Nmî Lémi ngê yinté a ka a vyu. ");
INSERT INTO yle_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Dini ghi n꞉ii ngê Yesu Lóma lede yoo yi kada pini Paléti ka ńuw꞉o ngópu, yi ngwo u pwopwo u nt꞉u kópu u kwo mye vyi ngópu. Wod꞉oo Paléti u kwo póó wo, kwo, Mumdoo nyi Nju tpémi yi king? Yesu ngê kwo, Ṉ́yóó kîchi vyi. ");
INSERT INTO yle_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kada pini yoo, kpêê yiyé pyu yoo yi kada pini yoo mye yi k꞉ii, Yesu p꞉uu yipe tee kópu yilî t꞉ee ngópu, ngmênê Yesu ngê kópu daangmê vyu. ");
INSERT INTO yle_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Paléti ngê kwo, Kêêmî m̱꞉uu yilî ngee kapî ngmê. Kwo, Yi kópu yilî nye nyêmî té. Kwo, Lukwe dîy꞉o tumu nye kwo. ");
INSERT INTO yle_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngmênê Yesu tumu doo kwo, kópu daa vyu, wod꞉oo Paléti ngê apê, Kî lónté pini? Apê, Lukwe dîy꞉o kópu daa tpapê? ");
INSERT INTO yle_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","M꞉ââ k꞉oo Nju tpémi yi naa ndîî u dye ghi ngê, yélini mbwa k꞉oo dnyimo kwo, Paléti ngê ngmêdpîmo pw꞉iipw꞉ii, apu, Nju tpémi yi nuw꞉o dmi mb꞉aamb꞉aa ngê paa pyaa we. Pini n꞉ii u pi pi knî y꞉oo u kwo dnyimo tpapê, yini yidpîmo pw꞉iipw꞉ii. ");
INSERT INTO yle_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Yi m꞉aani ngê mbwa u mênê pi ngmêdoo kwo, u pi Mbadapas. Pi yintómu yi lama yi pini u pi doo ya. ");
INSERT INTO yle_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dini ghi n꞉ii ngê yoo kwodonkwodo a wó, Paléti ye póó wo, yepê, Ló pini u yi nmye ngma a kwo, nî pw꞉ii? Yepê, Mbadapas ay꞉aa pw꞉ii ó Yesu ay꞉aa pw꞉ii, pini n꞉ii p꞉uu ala kópu a tpapê ngópu, apu, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, wu vyîlo. ");
INSERT INTO yle_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paléti ngê yi kópu ye poo ngê, mu kópu u dîy꞉o u lama doo ya, Nju tpémi yi kada pini knî y꞉oo Yesu ka ń꞉ee dê kaa ngmê, a kêê k꞉oo u l꞉êê dîy꞉o dê kaa ngmê. ");
INSERT INTO yle_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Yi ngwo Paléti kóté têdê doo ya, u kpâm ngê pi u kwo ngmê dy꞉ââ ngê, Paléti ka kwo, A Lémi. Kwo, Ṉgmâm ngê ṉga até da dy꞉ââ nê, a ka dê, Nyi ngê ye pini ngê kópu kîngmê d꞉uu. A ka dê, Pi mb꞉aa yila. A ka dê, Mgîdî vy꞉o a wóó k꞉oo kîdî m꞉uu, u ngwo dî nkîngê mb꞉anê. ");
INSERT INTO yle_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nju tpémi yi kada pini yoo, kpêê yiyé pyu yoo yi kada pini yoo mye yi k꞉ii, yi tpóknî y꞉oo yoo yi mbodo dmi vyuwo ngópu, yepê, Paléti ngê Mbadapas dpo pw꞉ii ngê, Yesu dpî vya ngê. ");
INSERT INTO yle_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wod꞉oo Paléti ye póó wo, yepê, Ló pini nmyi l꞉êê dîy꞉o ngmanî pw꞉ii? Kwo, Mbadapas yi pw꞉ii ngi. ");
INSERT INTO yle_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yepê, Yesu ngê ló kópu ngmanî md꞉o, pini n꞉ii p꞉uu ala kópu a tpapê ngópu, apu, Chóó Lémi ngê a ngmidi ngê. Kwo, Kîdosi ńedê t꞉ee ngi. ");
INSERT INTO yle_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Paléti ngê yepê, Doo u ntââ. Yepê, Dono kópu ndîî daangmê d꞉uu ngê. Ngmênê pi yilî yintómu Paléti ka dpodombiy꞉e mbwolo, kwo, Vya ngi. Kwo, Kîdosi ńedê t꞉ee ngi. ");
INSERT INTO yle_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wod꞉oo Paléti ngê a w꞉ee ngê, apê, Doo u ntââ yi nuw꞉o dmi daanî ngmêê. Apê, Ye daanî ng꞉aa mbê knomomê, ye wa gheteghete mbê dmi. Apê, Ala pini u vyee têdê módó n꞉aa dyede, ngmênê yi dono a p꞉uu kîngî kaalî. Wod꞉oo u dpodo pyu ngmê ka kwo, Mbwaa d꞉ââ a ka ngma a ńuw꞉e. U kwo yedê ńuwo, Paléti ngê kóó dê pi yintómu yi ngópu ghêê doo, yepê, Ala pini u vyee têdê módó nmye dyede ngmê. Yepê, Yi dono nmyi p꞉uu choo ya. Yepê, Nê kuu, a pi daa t꞉a, a kêê dê dî ghêê dê. ");
INSERT INTO yle_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pi yintómu knî y꞉oo kwo, Pi dono yila, pw꞉oo we. Kwo, Chóó Lémi ngê u ntââ daawa a vy꞉u. Kwo, Mu dini ghi ngê u ntââ wa vy꞉ee a knomomê, ye nmî p꞉uu dpo vy꞉ee ngê, nmî tp꞉ee dmââdîma yi p꞉uu myedo vy꞉ee ngê. ");
INSERT INTO yle_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wod꞉oo Paléti ngê Mbadapas mbwa k꞉oo pw꞉ii ngê, lede knî ye yepê, Yesu kpaka yó. Wod꞉oo yedê kpê dmi ngê kpaka ngópu. U kuwó dini ghi ngê Paléti ngê yepê, Ńuw꞉o yó, kîdosi ńedê nyi t꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Lóma lede knî y꞉oo Yesu Paléti u ngomo mbwa kalê ngmê k꞉oo ńuw꞉o ngópu, ledeni yoo dnyen꞉aa lîme, nipi a danê tumo. ");
INSERT INTO yle_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yesu u mbwo kpîdîni doo ya, a ngee ngópu, kpîdî pee king knî y꞉oo yi mbwo ntee dnyimo t꞉emî dé, yinté kpîdî u mbwo ngmê t꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Noko yepê, King knî yi mbêmê kîdon ntee a kwo nyédi, kî pini mbêmê yinté tpile my꞉oo kaa koo, wod꞉oo yi kóó diidii a ngî tumo, a kmongo tumo, kîdon ntee tpile u ngwo ngmê l꞉âmo ngópu, Yesu mbêmê kaa ngópu. Noko yepê, King knî y꞉oo kiyé ntee a tpyé tumo, kî pini ka yinté tpile my꞉oo y꞉ee koo, wod꞉oo yimbwi ngma a ngî ngópu, u kwo y꞉ee ngópu, kwo, Chi tpyé, nmî kada pini ngê chi ya. U kuwó dini ghi ngê dnye yumuyumu, k꞉omodanê ngê dnya a chipéchipé, kópu, Munmîkó nmî Mââwe ndîî, Nju tpémi yi king. ");
INSERT INTO yle_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","P꞉uu dnye tpyîpwi, yimbwi n꞉ii doo tpyé, u kuwó dini ghi ngê kwulo mêdê ngee ngópu, mbêmê dnye kpêêpî. ");
INSERT INTO yle_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","U nkwitinkwiti dini ghi n꞉ii ngê yé ngópu, kpîdî mb꞉aa n꞉ii u mbwo t꞉ee ngópu, mêdê ngee ngópu, chóó u kpîdî u mbwo mê t꞉ee ngópu, wod꞉oo ńuw꞉o ngópu, apê, Kîdosi ńedê nm꞉uu t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dini ghi n꞉ii ngê Lóma lede knî y꞉oo Yesu u vyee têdê dnye ńeńe, maa p꞉uu Sadéni pi ngmê m꞉uu ngópu, u pi Saimon. Lede knî y꞉oo yi pini ka dpodombiy꞉e kwo, Kî pini u kîdosi dnyinê ngi. ");
INSERT INTO yle_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kwéli lee dniye, yi ghi u pi Mbodo Dînê, Nju tpémi yi dnye ngê, Nkolkota. ");
INSERT INTO yle_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","U yi y꞉e doo kwo, Yesu ka wiwi ndîî ngê daapaa pyaa we, wod꞉oo yi komo ngmê wain d꞉ââ k꞉oo a vyilê ngópu, Yesu ka y꞉ee ngópu, ngmênê Yesu ngê dini ghi n꞉ii ngê d꞉uu ngê, wépi ye puwâ. ");
INSERT INTO yle_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yesu u mbwo kpîdî a ngee tumo, kîdosi ńedê u ngwo t꞉ee ngópu. Wod꞉oo u kpîdî yêê tumo, yi kpîdî knî yi l꞉êê dîy꞉o dnye ng꞉oo, noko yepê, Alani nanê wa a ngî, woni nanê wa a ngî. ");
INSERT INTO yle_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","U kuwó dini ghi ngê mbwódo yaa dniye, dnye y꞉enê, apê, Pi ngê wa a ngee. ");
INSERT INTO yle_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","U pwopwo u nt꞉u kópu kîdosi ńedê u pwo t꞉ee ngópu, apê, Yesu, Nju tpémi yi king. ");
INSERT INTO yle_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pi miyó yi wéni ngê Yesu u nkîgh꞉ê kîdosi ńedê mye t꞉ee dumo. Woni u wéni pee t꞉ee ngópu, woni u t꞉anê pee t꞉ee ngópu. Yi tpódu y꞉oo pi mwiyé dpîmo a vyee dé, yi tpile myedpîmo a t꞉âmot꞉âmo dé. ");
INSERT INTO yle_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yélini maa p꞉uu dnye paa, dini ghi n꞉ii ngê Yesu kîdosi ńedê a m꞉uu ngópu, dnye nkwitinkwiti, ");
INSERT INTO yle_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kópu, Nyi lónté pini? Kópu, U yi ṉga doo kwo, Chóó Lémi u ngomo nê pw꞉ono, wo pyile amî lê, u ngwo am꞉aa wó. Kópu, Mumdoo nyi Chóó Lémi Tp꞉oo, ye ṉ́yóó kîdosi ńedê a ghidi, ṉ́yóóchóó mê ngee ngi. ");
INSERT INTO yle_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kada pini yoo, dêêpî pyu yoo, kpêê yiyé pyu yoo yi kada pini yoo mye yi k꞉ii, yinté myednye nkwitinkwiti. ");
INSERT INTO yle_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Noko yipu, Kn꞉aa pini yoo yidoo ngêêpî dé, ngmênê doo u ntââ chóóchóó daawa ngee. Noko yipu, Mumdoo Chóó Lémi ngê nmî kada pini ngê a pyódu ngê, kîdosi ńedê chóó wunê wupwo knomomê, ye u ngwo u kwo nmo kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Noko yipu, U nuw꞉o Chóó Lémi p꞉uu a kwo, apu, Nê tp꞉oo. Noko yipu, U nuu ghi Chóó Lémi nódo wo tóó, ye pêdê ngee. ");
INSERT INTO yle_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kpaa pyu n꞉ii dê Yesu u nkîgh꞉ê kîdosi ńedê t꞉ee dumo, Yesu yinté myedpîmo nkwitinkwiti. ");
INSERT INTO yle_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kââdî mââ kêlê dini ghi ngê, yi dyámê pee mbêmê mgîdî a ghay wo. Dini ghi n꞉ii ngê kââdî ngê liy꞉aa pyile a kuwo ngê, mê wa wo. ");
INSERT INTO yle_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yi dini ghi ngê Yesu dpodombiy꞉e ka wo, apê, Ilay, Ilay, lama sapaktáni. Yi kópu u nt꞉u kópu, A Yâpwo éé. A Yâpwo éé. Lukwe dîy꞉o a mo cha kuwo nê? Lukwe dîy꞉o ṉga d꞉oo ch꞉anê wo? ");
INSERT INTO yle_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yélini y꞉i doo kwo, Yesu u dnye yi ny꞉ee ngópu. Yi yéli woni knî y꞉oo noko yepê, Ilacha ka ka kââ. ");
INSERT INTO yle_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pi mbêpêmbêpê ngmê loo, tpênê n꞉êê ngmê ńuwo, wain d꞉ââ k꞉oo kmênê ngê, yimbwi ńedê kââ, Yesu komo t꞉âmo mbee ngê, apê, Nda ngê. ");
INSERT INTO yle_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngmênê pi woni knî y꞉oo kwo, Ngî t꞉ââ kmêle. Kwo, Ilacha wunê pwiyé knî, ó daawa nî. Kwo, Ilacha ngê kî pini kîdosi ńedê yinê wunê ngêêpî? ");
INSERT INTO yle_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Myombó Yesu dpodombiy꞉e mêyi ka wo, yed꞉oo pwene. ");
INSERT INTO yle_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yi dini ghi ngê Chóó Lémi u ngomo k꞉oo kpîdî ndîî n꞉ii doo ya, yi kpîdî ngê yoo yi maa dpîmo nkokonkoko, apê, Chóó Lémi u yâpwo ghi k꞉oo daapaa nî dniye. Yesu kîdosi ńedê dini ghi n꞉ii ngê pwene, wod꞉oo yi kpîdî chóó mînê chaa wo, châpwochâpwo ngê nkwodo a yaa wo, knâpwo dî. Yi ngwo yi dyámê pee mye ghêdê mbê wo, t꞉aanî chaa dniye, ");
INSERT INTO yle_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","pi ntóó kpomo n꞉ii knî yi mênê a kmênê tumo, mye kweńe dniye. Chóó Lémi u nuu u yoo, yélini wunê a pw꞉oo dniye, yi ngwo a pii dniye. ");
INSERT INTO yle_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesu dini ghi n꞉ii ngê a pii wo, yi yéli yi kpî k꞉oo a pwii dniye, Njedusalem lee dniye, pi yilî knî y꞉oo mî m꞉uu tumo. ");
INSERT INTO yle_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lede n꞉ii knî y꞉oo Yesu kîdosi ńedê t꞉ee ngópu, yi mââwe ndîî u k꞉ii kîdosi u nkîgh꞉ê dnyen꞉aa kwo, Yesu dnye y꞉enê. Dini ghi n꞉ii ngê dyámê pee ghêdê mbê wo, yi kópu yilî yi ngópu mye pyaa dniye, nkîngê mbê dniye, noko yepê, Kî ndêndê ngê Yâpwo ndîî tp꞉oo. ");
INSERT INTO yle_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pyââ y꞉i yilî doo kwo, daa chono dnya a kwo, y꞉i dnya a vyuwo. Yi pyópu knî y꞉oo Yesu Nkálili Wee u kwo dnyimo a yâmuyâmu, myednyimo a ngêêpî. ");
INSERT INTO yle_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Yi vy꞉o pyââ pyile doo kwo, Méli Makîdala pyââ ngmê, Méli myomo, Njems mbwémi Njósép yi pye, Sepédi u kpâm pyolo, Njems mbwémi Njon yi pye. ");
INSERT INTO yle_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Daa kêmakêma kââdî doo wupwo, Adamátiya pi ngmê ta, u pi Njósép. Yi pini ndáápi ngmê, myenté Yesu p꞉uu ndiye pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Paléti ka loo, Yesu ntóó u kwo mînê ch꞉ee ngê, wod꞉oo Paléti ngê u lede knî ye yepê, Wu pini ntóó ala pini ka nyi y꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Wod꞉oo Njósép adî lê, kpîdî mb꞉aa ngmê pwila ngê, Yesu ntóó kîdosi ńedê a ngópu, yi kpîdî ngê a kmongo ngê. ");
INSERT INTO yle_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ntóó ńuwo, chóó u kpomo u mênê mî yó, chêêpî ndîî yi kpomo t꞉âmo ngmê tpiyé wupu kwólu, u ngwo nkoko ngê, wod꞉oo p꞉o loo. Yi kpomo pi knî y꞉oo t꞉aanî paa mwiyé a ché ngópu, yi Njósép mupwoknî yi ntóó kmênêkmênê u l꞉êê dîy꞉o. ");
INSERT INTO yle_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Méli Makîdala pyââ, u pénta Méli k꞉ii, kpomo chedê dpîmo ya, Njósép ngê Yesu ntóó yi ngópu kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Womumo mw꞉aandiye, Sátîdé ngê, kpêê yiyé pyu yoo yi kada pini yoo, Pádisi yoo yi k꞉ii, Paléti ka lee dniye, ");
INSERT INTO yle_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","kwo, Nmî lémi, k꞉omodanê pyu n꞉ii ma nmyi vya ngmê, u kópu dyuu ngma até dp꞉o nuw꞉o kwolo. Kwo, Pi knî ye ala kópu dpîmo tpapê, yipu, Wa vya nê, wo pyile amî lê, u ngwo amênê pyidu. ");
INSERT INTO yle_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwo, P꞉uu ndiye pyu knî y꞉oo ntóó wa t꞉âmo knomomê, pi knî ye wa vyi ngmê, yewo, Kîmêdê pyidu, ye yi k꞉omodanê kópu mbêmê u pi ndîî ngê wa pyódu. Kwo, U ntââ lede knî ngmanyi dy꞉ââ, ntóó kwéli kmênê ngmê, awêde mââ y꞉i dny꞉oon꞉aa t꞉ââ, yed꞉oo p꞉uu ndiye pyu knî y꞉oo ntóó daawa t꞉âmo ngmê. ");
INSERT INTO yle_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paléti ngê yepê, U ntââ. Yepê, Lede knî ngmê ńuw꞉o yó, yi kópu mb꞉aamb꞉aa ngê dp꞉uu l꞉âmo yó. ");
INSERT INTO yle_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wod꞉oo Paléti ngê lede knî yi p꞉uu ngmê t꞉ângo, kpomo chedê nipi lee dniye. Chêêpîni kpomo t꞉âmo doo kwo, yi chââ u l꞉ii p꞉uu t꞉ee ngópu, noko yepê, Pi ngmê ngê wa kpêmî knomomê, u ngwo anmo w꞉ee. Yed꞉oo yi lede yoo a kuwo tumo, yepê, Mb꞉aamb꞉aa ngê dmyinê vyuwo, kî kpomo u mênê pi kîngmê kee. ");
INSERT INTO yle_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sandé mw꞉aa mgîdî vy꞉o, Méli Makîdala pyââ, u pénta Méli k꞉ii, kpomo chedê lee knopwo, Yesu kwéli kmênê ngópu. ");
INSERT INTO yle_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yi taa knopwo, têpê dpodombiy꞉e doo ghêdê, nmî Lémi u enjel ngmê mbóó p꞉uu a ndê wo, chêêpîni kpomo t꞉âmo doo kwo, tpiyé wupu kwólu, mbêmê yaa wo. ");
INSERT INTO yle_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","U pââ doo a wuu mbele, lîmî u wuu ntoo, mye yintoo. U kpîdî dmi d꞉ud꞉umbiy꞉e kpaapîkpaapî. ");
INSERT INTO yle_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lede n꞉ii knî y꞉oo kpomo dnye y꞉enê, nkîngê ngê y꞉ay꞉a pwiyé dniye, mbwee ntóó k꞉ii pyaa dniye. ");
INSERT INTO yle_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Enjel ngê yi pyópu dê ye yepê, Namê nkîngê. Yepê, A lama ka tóó, Yesu ka dpo vyuwo mo, pini n꞉ii kîdosi ńedê t꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yepê, Al꞉ii daa tóó. Yepê, Kêda pyidu. Yepê, A pwiyé cho, ntóó kwéli yé ngópu, yi ghi anyi m꞉uu nyoo. ");
INSERT INTO yle_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yi ghi yi m꞉uu ngópu, enjel ngê yepê, Lîmîlîmî ngê lee cho, p꞉uu ndiye pyu knî ye mdoo ńuw꞉o nyoo, yipi, Yesu kêda pyidu, nmyi kada a kwo, Nkálili. Yipi, Y꞉i anmy꞉uu m꞉uu ngmê. Enjel ngê yepê, Yi kópu dpo yidîn꞉aa vyi. ");
INSERT INTO yle_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wod꞉oo yi pyópu dê y꞉oo lîmîlîmî ngê kpomo a kuwo ngópu. Dpîmo nkîngê, ngmênê w꞉aa myedê pyw꞉ee ngópu. Mbêpê a pwaa ngópu, apê, P꞉uu ndiye pyu knî ye mdoo nyi ńuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Maa p꞉uu Yesu a pyódu ngópu, yepê, Mw꞉ââkó dp꞉o. U kwo lee knopwo, yu km꞉ee dyimê knopwo, yu dê dpîmo tpyé dê. ");
INSERT INTO yle_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu ngê yepê, Namê nkîngê. Yepê, A mbwó knî ye mdoo ńuw꞉o nyoo, yipi, Nkálili Wee u kwo dmyinê lêpî, yipi, Nê y꞉i anmy꞉uu m꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dini ghi n꞉ii ngê yi pyópu dê maadî dpîmon꞉aa kwo, lede knî ngmê Njedusalem lee dniye, kópuni yi ngópu pyaa dniye, yi kópu yilî yi yuu dmi kpêê yiyé pyu yoo yi kada pini knî ye mînê y꞉ee tumo. ");
INSERT INTO yle_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kada pini yoo yintómu nipi a wó, yi nuw꞉o dmi ngmidi ngê pyódu ngópu, lede knî ye ndapî yilî y꞉ee ngópu, ");
INSERT INTO yle_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","yepê, Kópuni dê pyódu, pi ka nangê vyi. Yepê, Pi knî ye ala kópu dmyinê tpapê, yipi, Dini ghi n꞉ii ngê nmî dpî té, p꞉uu ndiye pyu knî y꞉oo daa nmî lama ntóó kêdê t꞉âmo ngmê. ");
INSERT INTO yle_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yepê, Paléti ngê yi kópu a nyêmî knomomê, nmyi kpadakpada u pi a tpapê knomomê, ye u nuw꞉o nmo l꞉âmol꞉âmo, kópu nmye daangmêwa d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wod꞉oo yi lede knî y꞉oo yi ndapî yi kêlê a ngee ngópu, kópuni ye vyi ngópu, yi kópu pi knî ye ntênê dnyen꞉aa tpapê. Nju tpémi y꞉oo yi k꞉omodanê kópu awêde mu nyepênyepê ngmê. ");
INSERT INTO yle_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesu p꞉uu ndiye pyu y꞉a mê ngmê Nkálili Wee u kwo lee dniye. Yesu ngê mbwini n꞉ii u pi ye vyu, yi mbwini mbêmê lee dniye. ");
INSERT INTO yle_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dini ghi n꞉ii ngê m꞉uu ngópu, yi yi mbodo dmi ngê k꞉ame u kwo ghê dniye, ngmênê knî ngmê yi nuw꞉o miyó ngê dnye ya, yinê ye daa vyîlo. ");
INSERT INTO yle_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu yi nkîgh꞉ê a loo, nipi dnye danêmbum, yepê, M꞉aa ngê mbóó p꞉uu kópu yilî yintómu yi kada pini ngê dê pyódu nê, dyámê mbêmê kópu yilî yintómu yi kada pini ngê myaa pyódu nê. ");
INSERT INTO yle_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yepê, Yi kópu u l꞉êê dîy꞉o dyámê mbêmê ghi yintómu dpî lee dmyeno, pi yilî a p꞉uu ndiye pyu ngê dp꞉uu pyódu tóó. Yepê, Dmyinên꞉aa mbápitisîm kîgha dé. Yepê, M꞉aa u Ghê Dmi, myenté M꞉aa u k꞉ii, nmî kêê k꞉oo dmyinên꞉aa kapî dé. ");
INSERT INTO yle_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yepê, Dêêpî kópu n꞉ii nmye nî vyi too, yi nuwo dp꞉uu kalê tóó, mb꞉aamb꞉aa ngê dny꞉oo chââchââ dé. Yepê, Nkîngê ngê kêê nangê t꞉oo. Yepê, Dye ghi yintómu nmyi p꞉uu anî ya, u dî, kuwókuwó wéni amî d꞉ii. Wu u dî. ");
INSERT INTO yle_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ala Yesu Kédisu u kópu mb꞉aa, pini n꞉ii Chóó Lémi Tp꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chóó Lémi ngê kópuni u kwo a vyu, u komo kapî pyu Yisaya ngê wunê a d꞉êê ngê, apê, A kópu y꞉eey꞉ee pyu ṉgada wanî kââ, m̱aa yinê amînê yé. Yisaya ngê ala kópu mye d꞉êê ngê, ");
INSERT INTO yle_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","W꞉amî mbêmê pi ngma adî kââ, yewo, Nmî Lémi u maa a yé yó, maa mb꞉aa yidó yé yó. ");
INSERT INTO yle_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","M꞉ââ yilî mî loo, Njon ngê Yisaya u kópu u ngwo ntiye ngê. Yesu ngê u dpodo kn꞉ââ ghêlî daangê chópu, Njon ngê Chóó Lémi u kópu pi knî ye doo tpapê, yi nuw꞉o dmi doo ngmêêpî dé, Yesu u maa u ngwo doo a yiyé. Njon w꞉amî mbêmê dpîmo ya, yélini u kwo dpîmo lêpî, ye dpîmo danêmbum. Yipu, Nmyo ndêndê ngê Nju tpémi, ngmênê Chóó Lémi u chââchââ nmyi lama daa tóó, kn꞉aa dyámê tpémi ntee dé, nmyo yinté dé. Yipu, Nmyi dono yilî kéé tóó, mbwaa ngê n꞉aa mbápitisîm kîgha nmyo, Chóó Lémi ngê nmyi dono yilî u kuwó wa kéé té, mêdaawa a ngî té, Chóó Lémi u yoo njini ngê u ngwo wanmyi pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Njuda tpémi Njon ka yilî loo, Njedusalem tpémi yilî mye loo, dnyen꞉aa ng꞉aang꞉aa. Yi dono yilî yi yuu dmi Njon ka dnyimon꞉aa a yémî, wod꞉oo mbwaa ndîî paa Njódan dpîmo kmênêkmênê dé, mbápitisîm ye dpîmo yém, yi dono yilî u ngwo dpîmo ghêêghêê dé. ");
INSERT INTO yle_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Chóó Lémi u komo kapî pyu Ilacha ngê kpîdî gh꞉aagh꞉aa ntee dpîmo t꞉emî, Njon ngê yinté kpîdî myedpîmo t꞉emî, kámêl gh꞉aa kpîdî. Pudumakó too pee u mbalêti ngê pyódu ngê, u paa vyîlo yidpîmo t꞉emî. Mty꞉aa ndâpu kpele numo ch꞉ee dpîmo kuwo dê, mu kópu u dîy꞉o nté y꞉i dêpwo ya. ");
INSERT INTO yle_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pi knî ye yepê, Pini n꞉ii a kuwó wunê kwo, u pi ndîî. Yepê, Nê têdê. Yepê, D꞉oo u ntââ, u nkîgh꞉ê daanî nî. Yepê, Nê tp꞉ee. ");
INSERT INTO yle_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yepê, Mbwaa ngê munî mbápitisîm kîgha nmyo, ngmênê yi pini ngê Chóó Lémi u Ghê Dmi ngê wa mbápitisîm kalê nmyo. ");
INSERT INTO yle_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yi dini ghi ngê Yesu Nkálili doo ya, p꞉aa u pi Nasalet. Yi p꞉aani a kuwo ngê, Nkálili Wee myedê kuwo ngê, Njódan mbwááni a ńuwo, Njon ka u ngwo loo, kwo, Mbápitisîm kalê nédi, yed꞉oo Njon ngê mbwaa lêê u mênê Yesu kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Dini ghi n꞉ii ngê Yesu mbwaa lêê u mênê a pii wo, apê, Mbóó mêdê kpêmî. Myenté Chóó Lémi u Ghê Dmi vy꞉êmê k꞉ii ntee tpile ngê u pwo a ghêpê wo. ");
INSERT INTO yle_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mbóó p꞉uu dnye ngmê ny꞉ee ngópu, kwo, Nyi a tp꞉ee njini, ṉuu ghi a nódo ka tóó, dye ghi yintómu a nuu u kópu nye d꞉uud꞉uu too. ");
INSERT INTO yle_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yi dini ghi ngê Chóó Lémi u Ghê Dmi ngê Yesu w꞉amî mbêmê dy꞉ââ ngê. ");
INSERT INTO yle_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Y꞉i doon꞉aa ya, wo podo y꞉a, Setan ngê y꞉i doon꞉aa tókótókó. Chii tpile tp꞉oo y꞉i myednyen꞉aa kwo, enjel yoo a lee dniye, Yesu mê ngee ngópu. ");
INSERT INTO yle_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","U kuwó dini ghi ngê Njon ngê King Helodi ka u dono kópu yilî dpîmo kwódukwódu dé. Yi kwódu yé u l꞉êê dîy꞉o Helodi ngê Njon mbwa k꞉oo kmungo, Yesu Nkálili u ngwo loo, pi knî ye dpîmon꞉aa danêmbum, Chóó Lémi u kópu mb꞉aa p꞉uu ye dpîmon꞉aa danêmbum. ");
INSERT INTO yle_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yipu, Dye ghi mbwee machedê. Yipu, Chóó Lémi ngê u yoo y꞉enê kn꞉ââ daa kêmakêma a chap. Yipu, Nmyi dono yilî kéé tóó, yipu, Chóó Lémi ka diyé dmyeno, u kópu mb꞉aa ka kêlîmî mbê dmyeno. ");
INSERT INTO yle_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Dini ghi n꞉ii ngê Yesu Nkálili Kpéni Lêê u nkîgh꞉ê doo m꞉ii, te yâmuyâmu pyu miyó módu, Saimon mbwémi Andru, apê, Mu vyuwó mo. ");
INSERT INTO yle_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu ngê mgongo ye ngmê kwólu, yepê, A ngm꞉êê nódó. Yepê, Te u vyuwó ntee dpî lama a tóó, pi vyuwó yinté dpî lama n꞉aa kîgha. Yepê, Pi yilî Chóó Lémi ka wanmo ńuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yi ngwo dini ghi ngê yi pwoo a kuwo ngópu, Yesu ngm꞉êê ngópu. ");
INSERT INTO yle_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Até yidnye lêpî, mwada y꞉i myenté Yesu ngê pi mbwémi mê miyó até yi m꞉uu doo, Njems mbwémi Njon, Sepédi tp꞉oo dê. Yi mî k꞉ii dinki k꞉oo dnye kwo, yi pwoo dnye l꞉âmol꞉âmo. ");
INSERT INTO yle_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dini ghi n꞉ii ngê Yesu ngê m꞉uu doo, yepê, A pwiyé cho. Yepê, A p꞉uu anyi kaa cho. Wod꞉oo yi mî Sepédi, u dpodo pyu yoo yi k꞉ii, dinki k꞉oo a kuwo tumo, wod꞉oo Yesu u kuwó ghê knopwo. ");
INSERT INTO yle_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","P꞉aa ndîî ngmê u pi Kîpêêniyêm, Nkálili Kpéni Lêê u nkîgh꞉ê p꞉aani ngmê. Yi pini páádi knî Yesu u k꞉ii Kîpêêniyêm lee dniye, y꞉i dnyen꞉aa ya. U kuwó dini ghi ngê, lîme wo ngê, ngêpê ngomo k꞉oo kee dniye, Yesu ye doon꞉aa dêêpî. ");
INSERT INTO yle_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kópuni ye vyi too, yi nyepênyepê u kópu ngê pyaa dniye, mu kópu u dîy꞉o dêêpî pyu yoo ntee dnyimo dêêpî, daa yinté dpîmo dêêpî. Kópuni Yesu ngê ye dpîmo tpapê dé, daa ndiye pyu ndîî yoo yi pi dmi mbêmê dpîmo tpapê dé, chóó u pi mbêmê dpîmo tpapê dé. Noko yipu, U kópu yilî yintómu ndê kópu dé. ");
INSERT INTO yle_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pi ngmaté yi ta, u kmêna u ngwo ngmêdoo kwo. Ngêpê ngomo k꞉oo adî kee, yi kmêna u komo kââ, Yesu ka dpodombiy꞉e adî mbwólu, kwo, Yesu Nasalet pi. ");
INSERT INTO yle_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kwo, Lukwe nmo ngmanyi md꞉o? Kwo, Wanyi dyênê nmo? Kwo, A lama nye tóó, Chóó Lémi ngê a ngmidi nyoo, nyi u nuu u pi. ");
INSERT INTO yle_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu ngê yi kmêna ka kwo, Tumu chi ya. Kwo, Ye pini a kuwo ngi. ");
INSERT INTO yle_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yi kmêna ngê yi pini ka nyuno pwopwo adî y꞉oo, dpodombiy꞉e adî kââ, wod꞉oo yi kmêna ngê yi pini a kuwo ngê. ");
INSERT INTO yle_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pi yintómu ngwéti dniye, noko dnye póó, noko yepê, Kî lónté kópu? Ndiye têdê kamî. Noko yepê, Yesu kmêna yoo yi pwo a tóó, u dnye a nyêmî ngmê. ");
INSERT INTO yle_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","U kuwó dini ghi ngê yi kópu u mdoo yedê ńuw꞉o ngópu, Nkálili wee lîmîlîmî ngê a ngêêdî. ");
INSERT INTO yle_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ngêpê ngomo k꞉oo dini ghi n꞉ii ngê a pwii dniye, Yesu p꞉uu ndiye pyu páádi knî yi k꞉ii Saimon mbwémi Andru yi p꞉aa pee lee dniye. ");
INSERT INTO yle_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon u mbywé pyââ ngmîtédmi mbêmê doo dpî, mbii ndîî u ngwo ngmêdoo ya. Dini ghi n꞉ii ngê taa dniye, Yesu ka yi pyópu yuu adê y꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu loo, yi pyópu kwulo kele, a pyidu ngê, wod꞉oo yi mbii ngê a kuwo ngê, yi pyópu ngê nté ye mê y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kââdî dini ghi n꞉ii ngê gho, yi ngwo Nju tpémi yi lîme wo machedê ngê pyodo. U kuwó dini ghi ngê mbii pyu yintómu Yesu ka ńuw꞉o tumo, n꞉ii dé y꞉e yi kmêna dnye kwo, u kwo mye ńuw꞉o tumo. ");
INSERT INTO yle_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Yi ngomo t꞉âmo ghi a nt꞉ee wo, pi dêpwo a ya. ");
INSERT INTO yle_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu ngê pwopwokopwe yilî pyi ngê, mbii dyêêdî daa ngmidi yedoo ya. N꞉ii knî y꞉e yi kmêna dnye kwo, yi kmêna yilî Yesu ngê ngm꞉ii kalê too. Yesu ngê kmêna knî ye danêmbum kwódu ngê, mu kópu u dîy꞉o yi lama doo ya, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, kî yi pini. Yesu ngê u yi dêpwo kwo, Pi yintómu yi lama yi kópu yaa we. ");
INSERT INTO yle_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mw꞉aamw꞉aa ghêlî daa wa wo, Yesu ngê p꞉aa u ngwo a kuwo ngê, pi kwéli dêpwo a paa, y꞉i doon꞉aa ngêpê, u mî ka. ");
INSERT INTO yle_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon mbwémi mbwémi ma adî lee dmi, Yesu dnyen꞉aa nmy꞉uu. ");
INSERT INTO yle_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Dini ghi n꞉ii ngê a pyw꞉ee ngópu, kwo, Pi yilî knî y꞉oo ka nmy꞉uu ngi. ");
INSERT INTO yle_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngmênê Yesu ngê yepê, Kn꞉aa p꞉aani lee kmêle, yepê, kópu mb꞉aa y꞉i ye ngmênîmo tpapê. Yepê, Yi kópu u dîy꞉o até d꞉a lê. ");
INSERT INTO yle_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wod꞉oo lee dniye, Nkálili wope wope yi ngêpê ngomo knî yi k꞉oo dnyimon꞉aa koko, Yesu y꞉i ye dîmon꞉aa dêêpî. N꞉ii knî y꞉e yi kmêna dnyimo kwo, Yesu ngê yi kmêna dpîmo ngm꞉ii kîgha dé. ");
INSERT INTO yle_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pi ngmê Yesu ka loo, too pee mbii leprîsi u ngwo doo ya, yu mbodo dê y꞉e k꞉ame u kwo ghê wo, u kwo nkêpê mbê wo, kwo, A lémi. Kwo, U yi ṉga choo kwo knomomê, ye u ntââ kópuni ngê tupwótupwó ngê pyódu noo, wanyi chedê. ");
INSERT INTO yle_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yi pini Yesu ka ch꞉anê wo, wod꞉oo Yesu ngê kêê p꞉uu yó, kwo, U ya a nga ka kwo. Kwo, Ṉ́upwó dî chedê. ");
INSERT INTO yle_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yi ngwo yi mbii ngê yi pini a kuwo ngê, mb꞉aamb꞉aa ngê mê pyodo. ");
INSERT INTO yle_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesu ngê kwo, Kî pini. Kwo, Ala kópu ny꞉ee ngi. Kwo, Kópuni ṉga dî d꞉uu, pi ngmê ka kidingê vyi. Kwo, Ala ngwo Njedusalem chi lêpî, kpêê yiyé pyu ngê amî m꞉uu ngi. Kwo, Mósisi ngê kópuni a d꞉êê ngê, yi kópu dp꞉uu d꞉uu ngi, ńmê miyó dp꞉uu ńuw꞉o ngi, kpêê yiyé pyu ka dp꞉uu y꞉ee dé, wamî nk꞉êê dê, kópuni ṉga dî d꞉uu, u ngwo pêdê w꞉ee y꞉e. ");
INSERT INTO yle_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngmênê yi pini ngê Yesu u dnye daa nyongo, p꞉aani p꞉aani loo, p꞉êê mî chaa ngê. Yi kópu u l꞉êê dîy꞉o, dini ghi n꞉ii ngê Yesu p꞉aa ndîî n꞉ii dpîmo lêpî, pi yilî yintómu u kwo dnyimo lêpî, u nkîgh꞉ê dnyimon꞉aa wowo, pyiyépyiyé u kwo dnyimo dmyinê. Pi dêdpîmo a ya, Yesu ka doo u ntââ ngê u kwo dpîmo pyodopyodo. Yi kópu u l꞉êê dîy꞉o dye ghi ngmê ngê yintoo p꞉aani k꞉oo daam꞉uu n꞉ee. Pi kwéli dêdpîmo a paa, y꞉i dpîmo a ya, pi yilî yintómu y꞉i u kwo dnyimo a lêpî, daa p꞉aa ngmidi dnyimo a ndiyendiye. ");
INSERT INTO yle_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wo miyó pyile mî loo, Yesu p꞉uu Kîpêêniyêm u ngwo mêdê diyé dniye. Pi knî yi lama yi yaa wo, apê, Yesu p꞉o a tóó. ");
INSERT INTO yle_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pi yintómu u kwo a lee dniye, ngomo a nt꞉ee ngópu, pi kuwa mî ghay wo. Yesu ngê chóó u p꞉êê kópu dyuu ye doo tpapê dé. ");
INSERT INTO yle_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yesu ka mbii pyu ngma a ńuw꞉o ngópu, kpâlî dê ntóó dê. Ngmîtédmi mbêmê a yé ngópu, pi páádi knî y꞉oo dnyinê ngópu. ");
INSERT INTO yle_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Doo u ntââ yi pini Yesu ka daapê ńuw꞉o ngópu, mu kópu u dîy꞉o pi knî y꞉oo maa nkoko ngópu. Yi pini páádi knî y꞉oo yi ngomo pywápê ngmê pw꞉ono adî ńuw꞉o ngmê, Yesu kwéli doo a ya, ngomo pw꞉ono puu y꞉i ngmêmînê t꞉ee ngópu. Ngomo pw꞉ono têpê a wéli ngópu, puu y꞉i ngmêmînê t꞉ee ngópu, yi pini yedê ngê y꞉i ghîpî ngópu, u ngmîtédmi mbêmê doo ya. ");
INSERT INTO yle_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dini ghi n꞉ii ngê Yesu ngê m꞉uu too, a w꞉ee ngê, apê, N꞉ii knî y꞉oo kî pini a ka da ńuw꞉o ngmê, ndêndê ngê a ka wunê kêlîmî té. Yesu ngê yi pini ka kwo, A tp꞉ee. Kwo, Ṉono yilî yintómu dî chedê, Chóó Lémi ngê mêdaawa kpada ngi. ");
INSERT INTO yle_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Nju tpémi yi dêêpî pyu yoo y꞉i ngmêdoo kwo, yi kópu yi ny꞉ee ngópu, yi gha vy꞉o a vyi ngópu, apê, Kî pini ngê lukwe dîy꞉o yi kópu dê vyi? Apê, U yi u ngwo a kwo, Chóó Lémi u d꞉aa nê kââdî. Apê, Chóó Lémi mu ngmidi ngê yinê wa vyi, awo, Ṉono yilî dî chedê. Apê, Doo u ntââ, pi ngmê ngê yinté kópu d꞉uudpî vyi. ");
INSERT INTO yle_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kópuni tumu dnye nuw꞉onuw꞉o dé, Yesu ngê a w꞉ee too, yepê, Lukwe dîy꞉o yenté nmye nuu mbumu té? ");
INSERT INTO yle_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","11","Yepê, Nê Chóó Lémi u Pi Ndêndê, u ntââ ngê yinê a pyódu noo, u ntââ dyámê mbêmê pi ka wanî vyi, Ṉono yilî dî chedê, Chóó Lémi ngê ṉono yilî u kuwó dê kéé té, mêdaawa a ngî té. Yepê, K꞉omo tpile a kópu ka módó daanmyi kêlîmî mbê dmi, ngmênê kópuni kî kpâlî ntóó ngê n꞉aa d꞉uud꞉uu, a kópu ka u ngwo nmye kêlîmî té. Wod꞉oo Yesu ngê yi kpâlî ntóó ka kwo, Gh꞉êêdé, ṉgmîtédmi a ngini, p꞉o lili. ");
INSERT INTO yle_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wod꞉oo yi pini ghêêdî wo, u ngmîtédmi a ngêêdî, pi yintómu yi ngópu mî pwii wo. Pi yintómu ngwéti dniye, Chóó Lémi chaa kalê ngópu, noko yepê, Kînté kópu pi doongmê módu. ");
INSERT INTO yle_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu p꞉uu Nkálili Kpéni Lêê u nkîgh꞉ê mê diyé dniye. Pi yilî yintómu u kwo a lee dniye, y꞉i doon꞉aa ndiye kîgha dé. ");
INSERT INTO yle_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dini ghi n꞉ii ngê kada a y꞉ee ngópu, maa p꞉uu tákisi ngêêpî pyu ngmê m꞉uu ngópu, u pi Lipi, Alîpayas tp꞉oo. Yi pini ndapî ngêêpî ngomo ghi k꞉oo doo ya. Yesu ngê kwo, A ngm꞉êê nédi. Wod꞉oo ghêêdî wo, Yesu u kuwó ghê wo. ");
INSERT INTO yle_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","U kuwó dini ghi ngê u ngomo k꞉oo kee dniye, Yesu, p꞉uu ndiye pyu yoo, tákisi ngêêpî pyu yoo, kn꞉aadi te pyu yoo mye yi k꞉ii. Yinté pini mê yilî Yesu p꞉uu dnye ya. Nipi dnye kmaapî, yi ngomo k꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dêêpî pyu yoo n꞉ii dé Pádisi yoo yi vy꞉o dnye kwo, y꞉i knî ngmê ta. Apê, Yesu kn꞉aadi te pyu yoo yi k꞉ii mu kmaapî té. Yi tpóknî Yesu p꞉uu ndiye pyu knî ye póó dniye, yepê, Lukwe dîy꞉o nmyi kada pini kn꞉aadi te pyu yoo tákisi ngêêpî pyu yoo yi k꞉ii a kmaapî té? ");
INSERT INTO yle_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu ngê yi kópu yi nyongo, yepê, N꞉ii mb꞉aamb꞉aa dé, yi yéli ye kpeede d꞉uudpî nî. Yepê, Kpeede mbii pyu knî ye dpî lê. Yepê, Yélini yinê ye, Nmo mb꞉aamb꞉aa dé, daa yi yéli yi dîy꞉o al꞉ii nê loo, yepê, ngmênê kn꞉aadi te pyu yoo yi dîy꞉o nê loo. ");
INSERT INTO yle_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wo ngmê knî yi k꞉oo Pádisi knî y꞉oo nté dnyimo kpîpîkpîpî. Chóó Lémi ka dpodombiy꞉e u ngwo dnyimo ngêpê. Yi wéni knî ngmê ngê, Njon p꞉uu ndiye pyu knî y꞉oo yi kópu myednyimo d꞉uud꞉uu, nté myednyimo kpîpîkpîpî. Yi wéni ngmê ngê pi knî Yesu ka ngma a loo, u kwo póó dniye, kwo, Lukwe dîy꞉o Pádisi knî y꞉oo nté dê kpîpî ngmê, kwo, Njon p꞉uu ndiye pyu knî y꞉oo nté mya kpîpî ngmê, kwo, ngmênê m̱꞉uu ndiye pyu knî ye nté chuu kwódu ngê? ");
INSERT INTO yle_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ngê yepê, Wéni n꞉ii ngê pi cha dpî yéé knî, pi ngê nté pi ka d꞉uudpî kwódu. Yepê, A p꞉uu ndiye pyu yoo yi k꞉ii nmî gha dmi mb꞉aamb꞉aa ngê a pyede, doo u ntââ nté ye daanî kwódu. Yepê, Wéni n꞉ii ngê pi dpî pw꞉onu, u yoo yi gha dmi dono ngê dpî pyódu, dye ghi knî ngmê ngê nté dpî kpîpî ngmê. ");
INSERT INTO yle_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yepê, Dini ghi n꞉ii ngê a p꞉uu ndiye pyu yoo yi vy꞉o mêdaanî kwo, yi ngwo yi gha dmi yinté dono ngê wa pyódu. Yepê, Yi wéni ngê yi chóó nté wa kpîpî ngmê. ");
INSERT INTO yle_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yepê, Kópu kamî ngma atéd꞉a ńuw꞉o, nmyi l꞉êê ghi mbwee dmi daa kópu kamî yi pee dé. Mgongo ye ngmê kwólu, yepê, N꞉ii u kpîdî mbwee dpo chópu, doo u ntââ kpîdî pee kamî daawa pwila, kpîdî mbwee p꞉uu daawa t꞉oo. Yepê, Dini ghi n꞉ii ngê ayi ghodo, kpîdî pee kamî dêêkwédi ngê wa a pyódu, kpîdî mbwee d꞉ud꞉umbiy꞉e wa a chópu. Yepê, Kpîdî pee kamî, kpîdî pee mbwee daa numo yi pee dê, myenté l꞉êê ghi mbwee a kópu kamî daa numo yi pee dê. ");
INSERT INTO yle_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yepê, Wain kamî nmye ngmêd꞉a ńuw꞉o, doo u ntââ u yiyé têdê mbwee knî yi k꞉oo daanî yé, wa dyênê té, mbwódo amî d꞉ii. Yepê, U ntââ kamîni knî yi k꞉oo n꞉aa yiyé, daawa dyênê té. Yepê, Nmyi l꞉êê ghi mbwee dmi yi dye ghi machedê. Yepê, Nté kpîpîkpîpî mêdaa ndîî kópu. Yepê, Yi kópu u l꞉êê dîy꞉o a p꞉uu ndiye pyu knî ye nté daanî kwódu. ");
INSERT INTO yle_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lîme wo ngmê ngê Yesu p꞉uu ndiye pyu knî yi k꞉ii witi yâpwo têdê dnyen꞉aa paa. P꞉uu ndiye pyu knî y꞉oo witi w꞉uu mtyé dnya a ngêêpî dé, yi kêê yedê dnye vyuw꞉avyuw꞉a dé, too pee dnye wupî dé, w꞉uu u nkwo dnye pîpî dé. Daa dpodo ndîî yidnye dódó, ngmênê Pádisi knî ye yinê ye dnye dpodo, ");
INSERT INTO yle_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yesu ka kwo, Lukwe dîy꞉o m̱꞉uu ndiye pyu yoo nmî lîme wo ngê a dpodo té? ");
INSERT INTO yle_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu ngê yepê, Dini ghi n꞉ii ngê Dépidi u yoo knî yi k꞉ii mudnya a dómudómu, kópuni yi ngwo a d꞉uu ngópu, angênté, yi kópu dp꞉eengê kp꞉aa ngópu? Yepê, Dini ghi n꞉ii ngê Apiyata kpêê yiyé pyu yoo yi kada pini ngê doo a ya, Dépidi ngê Sóól u ngwo a kuwo ngê, u yoo knî yi k꞉ii mbêpê dniye, nté daa ńuw꞉o ngópu. Yepê, Dómu ngê pî ngee too, ");
INSERT INTO yle_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","wod꞉oo Dépidi Chóó Lémi u wónu ngomo k꞉oo kee wo, yâpwo mbîdédi knî ngma a ngêêdî, u lede knî yi k꞉ii ma tumo. Yepê, Yinté mbîdédi kpêê yiyé pyu knî y꞉oo y꞉oo dnyimo pîpî dé, doo u ntââ kn꞉aa pini ngê daapî ma too. ");
INSERT INTO yle_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Yepê, Ngmênê Dépidi ka pi ngê yey ngê kêê dêpê t꞉ângo, mu kópu u dîy꞉o Chóó Lémi ngê a ngmidi ngê, king ngê a pyódu ngê. Yepê, My꞉aanté, yepê, Chóó Lémi ngê myedê ngmidi noo, nê u Pi Ndêndê. Yepê, U l꞉êê dîy꞉o nê u ntââ, lîme wo u dêêpî kópu dyuu nmye n꞉aa tpapê. Yepê, Pádisi yoo. Yepê, Nmyi nuw꞉o dmi alanté, Lîme wo kada a tóó, yoo kuwó a kwo. Yepê, Yinté daa tóó. Yepê, Chóó Lémi ngê lîme wo yó, pi knî yi ghê vyîmî u l꞉êê dîy꞉o, daa lîme wo u l꞉êê dîy꞉o yoo l꞉âmo ngê. ");
INSERT INTO yle_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","U kuwó dini ghi ngê Yesu p꞉uu ngêpê ngomo k꞉oo mê kee dniye. Yi ngomo k꞉oo pi ngmêdoo kwo, kóó ntóó. ");
INSERT INTO yle_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yi ngomo k꞉oo Pádisi yoo myednye kwo. Yi ngwolo dmi Yesu p꞉uu doo kwo, dêpê y꞉ee tumo, apê, Nmî lîme wo ngê pi ngma a pyipyi knomomê, u ngwo nmo ndyîkondyîko. ");
INSERT INTO yle_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ngê yi pini kóó ntóó ka kwo, A pwiyé. Kwo, Pi knî yi ngîma a nkîgh꞉ê anyinê ghé. ");
INSERT INTO yle_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wod꞉oo pi knî ye póó wo, yepê, Nmî dêêpî kópu dyuu lónté? Yepê, Lîme wo ngê kópu mb꞉aa ngmanyi d꞉uu, ó dono kópu ay꞉ii d꞉uu? Yepê, Pi ngmanyi ngee, ó anyi vy꞉a? Ngmênê pi knî y꞉oo kópu u kwo daangmê vyi ngópu. ");
INSERT INTO yle_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu ye nod꞉e wo, kwódo ng꞉oo dmi l꞉âmo a ngêpa wo. U gha vy꞉o vyu, apê, Lukwe dîy꞉o kî pini kóó ntóó ye doo ch꞉anê wo? Apê, Lukwe dîy꞉o yi dêêpî kópu ngmidi p꞉uu a nuw꞉o té? Wod꞉oo yi pini ka kwo, Ṉgêê kpêd꞉e ngi. Wod꞉oo yi pini ngê kóó kpêd꞉e ngê, yed꞉oo mb꞉aamb꞉aa ngê mê pyodo. ");
INSERT INTO yle_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yi ngwo Pádisi yoo pwii dniye, King Helodi u kwo téni pee yéli yi k꞉ii dnyen꞉aa danêmbum, yi danêmbum têdê Yesu u vyee u dy꞉oo mînê châpwo ngópu. ");
INSERT INTO yle_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu p꞉uu ndiye pyu yoo yi k꞉ii Nkálili Kpéni Lêê ndîî u nkîgh꞉ê lee dniye. Pi yilî yintómu knî y꞉oo Yesu myednye yâmuyâmu. Pi yilî tp꞉oo témi tap. Nkálili tpémi, Njuda tpémi, Njedusalem tpémi, Yidumiya tpémi, Pédiya tpémi, Taiya tpémi, Saidon tpémi, daa wee ngmidi tpémi Yesu ka yedê loo, mu kópu u dîy꞉o Yesu ngê kópuni yilî doo d꞉uud꞉uu, yi kópu yilî yi pi dmi a ny꞉ee tumo. ");
INSERT INTO yle_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesu ngê mbii pyu yilî dpîmo pyipyi, yed꞉oo mbii pyu knî y꞉oo pi dpodombiy꞉e dnye papî dé, Yesu ka u ngwo dnye lêpî, u yi y꞉e doo kwo, Yesu p꞉uu kêê nm꞉uu yé, yed꞉oo nmî mbii machedê ngê u ngwo a pyodopyodo. U l꞉êê dîy꞉o Yesu ngê p꞉uu ndiye pyu knî ye u ngwo vyu, yepê, Dinki a ńuw꞉o yó, yepê, yoo a pwo wa a wó. ");
INSERT INTO yle_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","N꞉ii knî y꞉e yi kmêna dnye kwo, dini ghi n꞉ii ngê Yesu m꞉uu ngópu, yu km꞉ee dyimê dnye, dpodombiy꞉e u kwo mbwóó dniye, kwo, Nyi Chóó Lémi tp꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesu ngê kmêna knî ye yepê, Yi kópu daamunmyi vyi ngmê, nê n꞉uu. Yi kópu ye kwódu ngê. ");
INSERT INTO yle_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","U kuwó dini ghi ngê Yesu mbu paa loo, u yoo chóó mî myââ, yélini u yi dmi u ngwo doo kwo, yepê, A pwiyé dmyeno. ");
INSERT INTO yle_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yi yéli yi vy꞉o, pi y꞉a mê miyó ngmidi ngê, u dyépi yoo, u aposêl yoo. Yepê, Dî ngmidi nmyo, a p꞉uu dmyinê ya. Yepê, Dîyo a dpodo têdê wanî dy꞉ââ nmyo, pi knî ye a kópu dyuu anmyin꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yepê, U ntââ ngê wanî pyódu nmyo, pi knî y꞉e yi kmêna anmyin꞉aa ngm꞉ii kîgha dé. ");
INSERT INTO yle_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yesu ngê u dyépi y꞉a mê miyó ngmidi ngê, ala yi pi dmi. Saimon ngmê, pini n꞉ii Yesu ngê u pi nt꞉ângo, apê, Pita. ");
INSERT INTO yle_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Saimon u mbwó Andru myomo, Njems mbwémi Njon pyolo podo, Sepédi tp꞉oo dê. Yesu ngê Njems mbwémi Njon yi pi dê ntaa doo, apê, Komo pwááti dê, yi chóó yi dnye ngê, Mbówanêênjîs. ");
INSERT INTO yle_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pilipi Mbatolomyu limo wono, Mátiyu Tomas pii wolo, Njems tówo, Alîpayas tp꞉oo. Tádiyas yono, Saimon mê ngmê, pini n꞉ii yoo woni knî yi k꞉ii u yi y꞉e doo kwo, Lóma lede yoo nmî ngm꞉ii kalê té, mu kópu u dîy꞉o u yi y꞉e dêpwo kwo, Lóma tpémi y꞉o dny꞉oo y꞉enê nmo. ");
INSERT INTO yle_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Njudas Kédiyót pi mê myomo, pini n꞉ii Yesu u kwódo ngê ghê wo. ");
INSERT INTO yle_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","U kuwó dini ghi ngê Yesu p꞉uu p꞉o mê lee dniye. Wunê ntee u ngwo dpîmo pyodopyodo, yinté u ngwo mîmî pyodo, pi yilî u kwo loo, yi kópu u l꞉êê dîy꞉o u pi knî yi k꞉ii yi kmaapî u dye ghi dêpwo ya. ");
INSERT INTO yle_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Dini ghi n꞉ii ngê u pye ghee knî y꞉oo yi kópu a ny꞉ee ngópu, wod꞉oo lee dniye, apê, Nmî nya. Mu kópu u dîy꞉o pi knî y꞉oo noko yepê, Kêdê ghéti. Yinté dnye tpapê. ");
INSERT INTO yle_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Dêêpî pyu n꞉ii yoo Njedusalem a ndê dniye, noko yepê, Kmêna yoo yi kada pini Setan ngê wu pini yinê a mbêpê kîgha. Noko yepê, Setan u wêdêwêdê mbêmê kmêna yoo yinê a ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wod꞉oo Yesu ngê yi yéli a danê ngê, yepê, Setan ngê pi knî y꞉e kmêna daawa ngm꞉ii kalê té. Yepê, Daa Setan u wêdêwêdê mbêmê kmêna n꞉aa ngm꞉ii kîgha too, ngmênê Chóó Lémi u Ghé Dmi u wêdêwêdê mbêmê n꞉aa ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yesu ngê mgongo ye ngmê kwólu, yepê, Yélini wee ngmidi u kwo a pyede, yoo wa chaa knomomê, numo p꞉uu adnyi l꞉êê knomomê, ye yi chóóchóó yi wee wa dyênê ngmê. ");
INSERT INTO yle_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yepê, Myenté, mupwoknî ngmê, numo p꞉uu adnyi l꞉êê knomomê, ye yi chóóchóó yi pi dmi wamye dyênê ngmê. ");
INSERT INTO yle_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yepê, Setan u yoo mye yinté. Yepê, Numo p꞉uu adnyi l꞉êê knomomê, ye angênté adnyi ya. Yepê, Dmye kn꞉aadi ngmê, daa Setan u wêdêwêdê mbêmê kmêna n꞉aa ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yesu ngê mgongo ye ngmê kwólu, yepê, Tpileni l꞉âmo dy꞉ââ ngê dpî t꞉âmo té, u ngomo k꞉oo dpî km꞉êê té, doo u ntââ u ngomo k꞉oo daanyi kee, mêdaanyimo ngî té. Yepê, Ngmênê n꞉ii u wêdêwêdê ndîî, yi pini u ntââ, yi l꞉âmo dy꞉ââ dpî mgîmî, kóó yu dpî kudu té, u ngomo k꞉oo dpî kee, tpileni mwiyé a t꞉âmo too, tpile chóó knî ye yi tpile moo y꞉ee té. Yepê, Setan l꞉âmo dy꞉ââ ntee pini, u wêdêwêdê ndîî. Yepê, Ala yéli yinê mgîmî ngê, n꞉ii dé y꞉e yi kmêna a wee. Yepê, Chóó Lémi u Ghê Dmi a mênê a tóó, u wêdêwêdê mbêmê Setan kóó yu dî kudu té, yélini y꞉e yi kmêna a wee, dpî pyi té, yi kmêna n꞉aa ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, K꞉omo tpile pi knî y꞉oo ló dono kópu yilî a d꞉uud꞉uu t꞉oo, ló kópu dono Chóó Lémi p꞉uu ngmêdpî vyi ngmê, ngmênê Chóó Lémi ka yi yéli wa diyé dmi, ye Chóó Lémi ngê yi dono kópu yilî u kuwó wa kéé té, ntââ y꞉e mêdaangmêwa a vy꞉u. Yepê, Ngmênê pini n꞉ii Chóó Lémi u Ghê Dmi p꞉uu adî peede tpapê, yi pini Chóó Lémi ka daawa diyé, Chóó Lémi ngê u dono yilî u kuwó daawa kéé té. ");
INSERT INTO yle_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu ngê yi kópu ye vyu, mu kópu u dîy꞉o pi knî y꞉oo noko yepê, Yesu ngê kmêna ngma a kwo. ");
INSERT INTO yle_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yi dini ghi ngê Yesu u pye ghee knî taa dniye. Doo u ntââ Yesu ka daapî nî dniye, mu kópu u dîy꞉o pi yilî, ngomo a nt꞉ee wo. Wod꞉oo kuwa dnya a kwo, kópu u kwo dy꞉ââ ngópu. ");
INSERT INTO yle_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yi yéli y꞉oo Yesu ka y꞉oo vyi ngópu, kwo, M̱ye ghee knî kuwa ka wee, kwo, ka poopoo ngi. ");
INSERT INTO yle_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu ngê yepê, N꞉uu ngmê a pye? Yepê, N꞉uu dé ye a mbwó yoo? ");
INSERT INTO yle_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yélini yi vy꞉o doo kwo, doo y꞉enê dé, yepê, K꞉omo tpile niye ghee knî kuwa a wee, ngmênê a yoo njini ala ngomo k꞉oo a kwo. ");
INSERT INTO yle_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yepê, Yélini y꞉oo Chóó Lémi u nuu u kópu ye d꞉uud꞉uu tumo, yi yéli yi niye ghee knî. ");
INSERT INTO yle_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wo ngmê ngê Yesu Nkálili Kpéni Lêê u nkîgh꞉ê doon꞉aa ya, pi yilî yintómu y꞉i doon꞉aa ndiye kîgha dé. Pi dêpwo a ya, Yesu ka lee dniye. Yesu ka pi yilî ngê pyodo, apê, A pwo wa a wó, wod꞉oo dinki k꞉oo wo wo, k꞉oo doon꞉aa ya, y꞉i doon꞉aa ndiye kîgha dé. Pi yilî yi kpéni lêê u nkîgh꞉ê dnyen꞉aa kwo, Yesu y꞉i dnyen꞉aa ng꞉aang꞉aa. ");
INSERT INTO yle_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ye doo mgongo danêmbum, kópu yilî yi nuwo y꞉i doon꞉aa kîgha. ");
INSERT INTO yle_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Yesu ngê mgongo ye ngmê kwólu, yepê, Pi ngmê witi w꞉uu nt꞉ene têdê loo, têpê mwiyé chó, witi w꞉uu y꞉i u nkwo doo dimi dé. ");
INSERT INTO yle_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yepê, Witi w꞉uu woni dé maa p꞉uu mî dyimê dniye, ńmê knî y꞉oo mî ma tumo. ");
INSERT INTO yle_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yepê, Witi w꞉uu woni dé t꞉aanî mbêmê mî dyimê dniye, têpê mdoo kwéli dêpwo ya. ");
INSERT INTO yle_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yepê, Yi witi w꞉uu dé lîmîlîmî ngê pii dniye, ngmênê dini ghi n꞉ii ngê kââdî ndîî yi kee wo, wod꞉oo pw꞉oo dniye, mu kópu u dîy꞉o yi km꞉êê dmi têpê mênê yimi daa ghêpê dniye. ");
INSERT INTO yle_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yepê, Witi w꞉uu woni dé tpyé vy꞉o mî dyimê dniye, y꞉i mî pii dniye, tpyé ngê ma too, yi nt꞉u dmi daa kaa dniye. ");
INSERT INTO yle_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yepê, Witi w꞉uu woni dé têpê ghi mb꞉aa mbêmê mî dyimê dniye, y꞉i mî pii dniye, yi nt꞉u dmi mb꞉aamb꞉aa ngê kaa dniye, yepê, knî ngmê yi nkwodo w꞉uu pyoloy꞉a kele, yepê, knî m꞉uu yi nkwodo wonoy꞉a kele, yepê, knî m꞉uu yi nkwodo yonoy꞉a kele. ");
INSERT INTO yle_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yepê, Kópuni nmye dî vyi, yi kópu mb꞉aamb꞉aa ngê dmyinê nuw꞉onuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Dini ghi n꞉ii ngê yoo ndîî yi p꞉o p꞉o mê loo, Yesu p꞉uu ndiye pyu yoo, u dyépi y꞉a mê miyó knî yi k꞉ii, yi mgongo danêmbum knî yi dîy꞉o u kwo póó dniye. ");
INSERT INTO yle_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Yesu ngê yepê, Chóó Lémi kóó k꞉oo wowo tumu kópu ngê doo ya. Yepê, Yi tumu kópu yilî nmye wanî tpapê dé, ngmênê kn꞉aa yéli ye nt꞉u p꞉uu daana a dêêdêê, ye anî mgongo, mu kópu u dîy꞉o kópuni Chóó Lémi u komo kapî pyu ngmê ngê a d꞉êê ngê, yi yéli y꞉oo yi kópu paa ntiye y꞉e. Yi kópu ala, U mumu ngê a mumu ngmê, u nyêmî ngê a nyêmî ngmê, u wopwe ngê mêdêdê wopwe ngmê. Wa a w꞉ee ngmê, ye Chóó Lémi ka wa diyé dmi, yi dono yilî u kuwó wa kéé té, mêdaawa a ngî té. ");
INSERT INTO yle_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu ngê yepê, Angênté? Yepê, Yi mgongo danêmbum dmyongê w꞉ee ngópu? Yepê, Ló mgongo ngmanmyinê w꞉ee ngmê? ");
INSERT INTO yle_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yepê, Witi w꞉uu pi ngê ntee a dimi too, yepê, Chóó Lémi u kópu pi knî yi ngîma yinté a yiyé tumo. Yepê, Yi kópu pi woni knî yi mênê nt꞉u dpî kaalî, woni knî yi mênê nt꞉u d꞉uudpî kaalî. ");
INSERT INTO yle_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yepê, Witi w꞉uu woni knî maa p꞉uu ntee dpî dyimê dmi, ńmê knî y꞉oo ntee dpî ma t꞉oo, yepê, pi woni knî yinté wêdêwêdê dé, yi ngópu dpî kuwo t꞉oo, kópu yi gha vy꞉o d꞉uudpî kee, yi nt꞉u dmi d꞉uudpî kaalî, mu kópu u dîy꞉o Setan ngê yi kópu dpî t꞉âmo té. ");
INSERT INTO yle_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Yepê, Witi w꞉uu woni knî t꞉aanî mbêmê ntee dpî dyimê dmi, w꞉uu dpî pii dmi, lîmî k꞉ii ngê moo pw꞉oo dmi, yepê, pi woni knî yinté dé, dini ghi n꞉ii ngê a kópu dyuu dpî ny꞉ee ngmê, yi gha dmi mb꞉aamb꞉aa ngê dpî pyódu, ngmênê yi kópu daa dye ghi daadîî yi gha vy꞉o a ya yédi. Yepê, Dini ghi n꞉ii ngê kn꞉aa yéli y꞉oo a kópu dyuu u l꞉êê dîy꞉o a yoo adnyi kpakakpaka dé, yepê, yi yéli y꞉oo lîmî k꞉ii wa kpîpî nê. ");
INSERT INTO yle_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yepê, Witi woo woni knî tpyé ngê ntee dpî ma té, yepê, pi woni knî yinté dé, a kópu dyuu dpî ny꞉ee ngmê, ngmênê dyámê u tpile knî y꞉oo a kópu dyuu yinté dpî ma ngmê. ");
INSERT INTO yle_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Yepê, Yi yéli nté ndapî, tpile yilî yi p꞉uu a nuw꞉o nyédi, a p꞉uu daa nuw꞉o nyédi, yi gha vy꞉o a kópu dyuu nt꞉u d꞉uudpî kaalî. ");
INSERT INTO yle_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yepê, Witi woo woni knî têpê mb꞉aa mbêmê yi nt꞉u dmi mb꞉aamb꞉aa ngê ntee dpî kaalî, yepê, pi woni knî yinté dé, a kópu ngê yi gha dmi dpî ntówo té, yi gha vy꞉o nt꞉u yinté mb꞉aamb꞉aa ngê dpî kaalî, woni knî yi mênê pyoloy꞉a dé, woni knî yi mênê wonoy꞉a dé, woni knî yi mênê yonoy꞉a dé. ");
INSERT INTO yle_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ngê mgongo ye m꞉uu kwólu, yepê, Dini ghi n꞉ii ngê mgîdî dpo ghay, n꞉ii ngê lam dpo vyuwó, doo u ntââ tpile u pwo k꞉ame daawa kââ, mu kópu u dîy꞉o lukwe ngê mgîdî wa chaa? Yepê, Yi pini ngê lam dpo y꞉oo, ya nkwodo dpî kââ, yoo u ngwo dpî numo m꞉uu. ");
INSERT INTO yle_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yesu ngê yepê, Tumu kópu yintómu dîyo wa a pywálî dmi, ngmee u kópu dyuu wamyedê pywálî dmi. ");
INSERT INTO yle_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yepê, Yi kópu mb꞉aamb꞉aa ngê dmyinê nuw꞉onuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu ngê yepê, A ka ntênê dmyina a ng꞉aa, a kópu dyuu mb꞉aamb꞉aa ngê dmyina a wopwe, ");
INSERT INTO yle_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","mu kópu u dîy꞉o n꞉ii ngê a kópu dyuu wa a w꞉ee, dîyo knî m꞉uu u kwo wanî y꞉oo. Yepê, N꞉ii ngê a kópu dyuu daawa a w꞉ee, têdêni kópu ayedê w꞉ee, yi kópu l꞉âmo wa a ngee, u nuwo wa a kuwo. (Yi dini ghi ngê Nju tpémi yi nuw꞉o ghi dmi alanté doo ya. Noko yepê, Mu dini ghi ngê Chóó Lémi ngê pi ngmê wa a ngmidi, yi pini nmî kada adî kwo, Chóó Lémi ngê l꞉êê têdê wa ngee nmo, nmî mbodo dmi mudu y꞉i wa yââ, kn꞉aa dyámê tpémi yintómu nmî maknopwo adnyi ya. Yepê, Yi dini ghi ngê Chóó Lémi ngê chóó ada a y꞉enê nmo.) ");
INSERT INTO yle_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu Nju tpémi ye doo mgongo, yepê, Chóó Lémi ngê u yoo yi y꞉enê kn꞉ââ lónté wa chaa? Yepê, Yi kópu alanté wa pyódu. Yepê, Dini ghi n꞉ii ngê pi ngê u nté woo a nt꞉ene ngê, u nté woo dpî ntówo, mo dpo kuwo, yi ntini woo chóó a pyidepyide yédi. ");
INSERT INTO yle_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Yepê, Yi pini p꞉o dpî lê, kn꞉aa dpodo p꞉uu mêwumê dpodo yédi, mgîdî vy꞉o a dpî yédi, dye ghi yintómu yi ntini woo chóó a pyidepyide yédi. Yepê, Yi pini u lama daa ya yédi, nté woo lónté dpî pyidu. ");
INSERT INTO yle_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yepê, Têpê ngê chóó dpî pyidepyide kwolo, pii mwiyé dpî chópu, u kuwó dini ghi ngê nté woo ndââ dpî chaa, u kuwó dini ghi ngê nt꞉u dpî kaalî, yed꞉oo dpî mdo. ");
INSERT INTO yle_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yepê, Dini ghi n꞉ii ngê u nté dpî mdo, yed꞉oo dpî ché. ");
INSERT INTO yle_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu ye póó wo, yepê, Chóó Lémi ngê u yoo y꞉enê kn꞉ââ lónté wa chaa? Yepê, Yi kópu p꞉uu lónté anî mgongo? ");
INSERT INTO yle_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Yepê, Kwee ntee dpî k꞉aa, Chóó Lémi u yoo yinté yilî ngê amî pyódu. Yepê, K꞉omo tpile kwee pii tp꞉oo daa ndîî ngê wunê kwo yédi, ngmênê dini ghi n꞉ii ngê yi nkwodo dpî kee, dpî tîpîtîpî mb꞉anê, pywápê ye ya yédi. ");
INSERT INTO yle_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Dini ghi n꞉ii ngê Yesu ngê u kópu dyuu pi knî ye doo tpapê, yinté mgongo yilî ye kwólu, u dî doo u ntââ pi knî y꞉oo yi mgongo daapêdê w꞉ee tumo. ");
INSERT INTO yle_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dini ghi n꞉ii ngê pi yilî knî ye dpîmo danêmbum, dye ghi yintómu ye dpîmo mgongo. U kuwó dini ghi ngê p꞉uu ndiye pyu knî ye yi mgongo u kakêmê mêdpîmo chámêchámê. ");
INSERT INTO yle_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yi wéni ntumokwodo, Yesu ngê p꞉uu ndiye pyu knî ye yepê, Dinki k꞉oo wo dmyeno, kpé lêê mwada pee lee kmêle. ");
INSERT INTO yle_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wod꞉oo dinki k꞉oo wo dniye, yoo a kuwo ngópu. Dinki knî m꞉uu loo, Yesu mye ngm꞉êê ngópu. ");
INSERT INTO yle_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yópu ndîî ngma a pwaa wo, vyuwó dinki k꞉oo dnyen꞉aa kn꞉êê, daa kêmakêma dinki pî vy꞉êê wo. ");
INSERT INTO yle_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu dinki kn꞉ââ ghê doo dpî, u piló mbodo knâpwo doo a ya. P꞉uu ndiye pyu knî y꞉oo u dpî ny꞉ââ ngópu, kwo, Mââwe. Kwo, Ḻama daa tóó ṉga anmî pwopwo té? ");
INSERT INTO yle_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu a pii wo, yópu ka kwo, Munto. Vyuwó knî ye yepê, Dmyinê nd꞉omo. Wod꞉oo yópu a ngópu, dye ndîî mê kââ. ");
INSERT INTO yle_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu ngê yepê, Lukwe dîy꞉o nmye nkîngê té? Yepê, Lukwe dîy꞉o a ka dp꞉ee kêlîmî té? ");
INSERT INTO yle_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nkîngê ngê y꞉ay꞉a pwiyé dniye, noko yepê, Kî lónté pini? Noko yepê, Vyuwó yópu y꞉oo u dnye kêdê ny꞉ee ngmê, kîmyaa châpu ngmê. ");
INSERT INTO yle_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","U kuwó dini ghi ngê Yesu p꞉uu Nkálili Kpéni Lêê mwada pee yimî tee dniye, Nkedîsa tpémi kwéli dnya a ya. ");
INSERT INTO yle_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu dinki k꞉oo a ghay wo, pi ngmê até u kwo yi loo, u kmêna u ngwo ngmêdoo kwo. Yi pini kpomo mênê a pwii wo, pi ntóó kwéli dnyimo yiyé dé. ");
INSERT INTO yle_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Y꞉i dpîmo ya, dye ghi yintómu. Doo u ntââ pi ngê puwóma ti ngê daapî kudu ngê. ");
INSERT INTO yle_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Daa ng꞉êêntómu puwóma ti ngê kóó yu kudu tumo, ngmênê dpîmo pwapî dé, mu kópu u dîy꞉o l꞉âmo dy꞉ââ. Dêê dniye, daa kudu ngópu. ");
INSERT INTO yle_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dye ghi yintómu mbu knî yi mbêmê dpîmo lêpî, kpomo knî yi mênê myedpîmo lêpî, dpîmon꞉aa kââkââ, chóó chêêpî ngê myedpîmo châpwo. ");
INSERT INTO yle_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dini ghi n꞉ii ngê yi pini ngê Yesu kuughê a módu, mbêpê a puwâ, Yesu ka loo, yu mbodo dê y꞉e Yesu ka k꞉ame ghê wo. ");
INSERT INTO yle_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Dpodombiy꞉e u kwo mbwolo, kwo, Yesu. Kwo, Yâpwo ndîî tp꞉oo. Kwo, Lukwe a nga ngmanyi md꞉o? Yesu ngê kwo, Kmêna. Kwo, Ye pini a kuwo ngi. Yi pini ngê Yesu ka kwo, Yâpwo ndîî u pi mbêmê ṉga da mbwólu, nangê kpada nê. ");
INSERT INTO yle_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu u kwo póó wo, kwo, M̱i n꞉uu? Yi pini ngê kwo, Nmî pi dîdyênî, mu kópu u dîy꞉o nmo yilî. ");
INSERT INTO yle_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yesu ka doo dmyinê, kwo, Kn꞉aa dyámê pee p꞉uu nangê dy꞉ââ nmo. ");
INSERT INTO yle_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mbwêmê w꞉uu ndîî yi nkîgh꞉ê ngmêdoo kwo, w꞉amî mbêmê dnye kmaapî. ");
INSERT INTO yle_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yi Kmêna knî yoo Yesu ka nkêpê mbê dniye, kwo, U ntââ kî mbwêmê w꞉uu vy꞉o wanyi dy꞉ââ nmo. ");
INSERT INTO yle_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu ngê yepê, U ntââ. Wod꞉oo yi kmêna knî y꞉oo yi pini a kuwo ngópu, mbwêmê w꞉uu yi p꞉uu mî kaa dniye. Yi mbwêmê yintómu my꞉oo yono yono y꞉a mbêpê dniye, paa ghi p꞉uu ghîpîla dniye, kpé lêê u kwo mî dyimê dniye, wod꞉oo vy꞉êê dniye. ");
INSERT INTO yle_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pini n꞉ii yoo mbwêmê w꞉uu ka dnye vyuwo, yi yéli mye mbêpê wo, yi p꞉o lee dniye, pi knî ye mdoo ńuw꞉o ngópu, ghi yintómu mye lee dniye, pi knî ye mdoo mye ńuw꞉o ngópu. N꞉ii knî y꞉oo yi kópu ny꞉ee ngópu, u yi y꞉e doo kwo, yi kópu nm꞉uu m꞉uu, wod꞉oo Yesu ka lee dniye. ");
INSERT INTO yle_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Apê, Pini n꞉ii kmêna knî y꞉oo mwo a dyênê ngópu, ka tóó. Apê, Nmo ntee pini ngê mêka tóó, mêdaa ghétighéti, kpîdî u paa ngmêka t꞉a. Nkîngê ngê y꞉ay꞉a u ngwo pwiyé dniye. ");
INSERT INTO yle_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yélini yi ngópu yi kópu ghéti ngê pyodo, wo yéli ye yi kópu a nté ngópu, kópuni mbwêmê knî y꞉e pyodo, ye myedê nté ngópu. ");
INSERT INTO yle_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","U l꞉êê dîy꞉o Nkedîsa tpémi Yesu ka nkêpê mbê dniye, kwo, U ntââ ala wee anyinê kuwo. Wod꞉oo Yesu p꞉uu dinki k꞉oo wo dniye, apê, Kada nmo y꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dini ghi n꞉ii ngê Yesu dinki k꞉oo doo wowo, pini n꞉ii ngê u kmêna u ngwo dnye kwo, yi pini ngê Yesu ka kwo, U ntââ wanî ngm꞉êê ngi? ");
INSERT INTO yle_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngmênê Yesu ngê kwo, Kêle. Kwo, Daanyi nî. Kwo, Chóó Lémi ka chi ch꞉anê, awêde mb꞉aamb꞉aa ngê da ngee ngi. Kwo, Po mê dini, yi kópu ṉyoo knî ye dpîmo nté ngi. ");
INSERT INTO yle_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wod꞉oo yi pini adî lê, P꞉aa Y꞉a Knî yi k꞉oo doon꞉aa m꞉ii. Kópuni Yesu ngê u ngwo d꞉uu ngê, pi knî ye doon꞉aa a nj꞉ii. N꞉ii knî y꞉oo ny꞉ee ngópu, ngwéti dniye, noko yepê, Vyuw! Yepê, Kópu kamî. ");
INSERT INTO yle_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Dini ghi n꞉ii ngê Yesu p꞉uu y꞉oo Nkálili Kpéni Lêê ngmêê ngópu, Nkálili Wee u kwo mî tee dniye, pi yilî knî y꞉oo a yina ngópu, kpé lêê u nkîgh꞉ê dnye ya. Pi dêpwo a ya. ");
INSERT INTO yle_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pi ngmê u pi Njayidus, ngêpê ngomo u y꞉enê pyu ngmê, yi ngwo y꞉i mye ta. Dini ghi n꞉ii ngê Yesu módu, yu km꞉ee mî dyimê wo, u kwo nkêpê mbê wo, ");
INSERT INTO yle_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kwo, A tp꞉ee módó kîyedê mbii, kwo, Y꞉ay꞉a dê pwiyé. Kwo, U ntââ wanyinê lê, ṉgêê dê u pwo any꞉uu yé dê, any꞉uu pyi, yed꞉oo mêdaawa pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wod꞉oo Yesu yi pini u kuwó ghê wo. Pi mê yilî yi k꞉ii lee dniye, maa p꞉uu dnye kadakada, u yi y꞉e doo kwo, U nkîgh꞉ê nm꞉uu ghê dmi. ");
INSERT INTO yle_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pyââ yi vy꞉o ngmêdoo kwo, kmene muwó. Dye ghi yintómu yinté dpîmo ya, m꞉ââ y꞉a mê miyó ndîî, wêê p꞉uu dêpê vyâ. ");
INSERT INTO yle_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yi pyópu p꞉uu kpeede yilî dpîmo dpodo, yimi mêdnyimo mgînî vyîmî kîgha, nk꞉ââ ye dpîmo ngêêpî dé, u ndapî yinté chedê ngê, ngmênê dêdnyimo pyipyi, dono ngê p꞉ee mêdnyimo pyépi. ");
INSERT INTO yle_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yi pyópu ngê Yesu u pi dini ghi n꞉ii ngê nyongo, wod꞉oo Yesu u kuwó mî ghê wo. ");
INSERT INTO yle_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Apê, Yesu u kpîdî kwódo p꞉uu a kêê n꞉aa yé, yed꞉oo wêê wunê vyee. ");
INSERT INTO yle_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Dini ghi n꞉ii ngê Yesu u kpîdî kwódo p꞉uu kêê yó, wod꞉oo wêê a vyâ, yi pyópu ngê a w꞉ee ngê, apê, A mbii machedê ngê dê pyódu. ");
INSERT INTO yle_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu u lama até yi yaa wo, apê, Ala a wââ pi ngmê p꞉uu dê kee, wod꞉oo u kuwó até yi diyé wo, yepê, A kpîdî p꞉uu kêê n꞉aa dê yé? ");
INSERT INTO yle_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","P꞉uu ndiye pyu knî y꞉oo kwo, Lukwe dîy꞉o nye póó? Kwo, Lukwe dîy꞉o chi vyi, A kpîdî p꞉uu kêê n꞉aa dê yé? Kwo, Pi kînga dîdyênî. ");
INSERT INTO yle_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu doo yeda vyuwo, yoo doo y꞉enê, apê, Ala kópu n꞉aa dê d꞉uu? ");
INSERT INTO yle_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yi pyópu ngê a w꞉ee ngê, kópuni u ngwo pyodo, wod꞉oo nkîngê mbê wo, Yesu ka adî lê, yu km꞉ee k꞉ame ad꞉uu ghê, u mbii u danêmbum yintómu u kwo adê nt꞉o. ");
INSERT INTO yle_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu ngê kwo, A ch꞉am. Kwo, A ka che kêlîmî mb꞉anê, u ngwo chi pyiyé. Kwo, Chi lêpî, m̱ii chedê ngê dê pyódu, u nuw꞉onuw꞉o ngê kêê kîdangê t꞉oo. Kwo, P꞉o mê dini. ");
INSERT INTO yle_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu ngê u danêmbum ghêlî dêpê kêlî ngê, Njayidus u ngomo k꞉oo pi knî ngma a ndê wo, Njayidus ka kwo, Ṉ́m꞉ee módó ngê pi ṉga da dy꞉ââ. Kwo, Doo u ntââ kî mââwe ngê mêdaawa ngee ngi. Kwo, Ṉgomo k꞉oo mêkidingê ńuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kópuni dnye tpapê dé, Yesu ngê kêê yi kêlê dêpê ngópu, ngmênê Njayidus ka kwo, Namê nkîngê. Kwo, Chi kêlîmî. ");
INSERT INTO yle_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pi daangmê ńuwo, ngmênê Pita, Njems mbwémi Njon vyîlo dé yi ńuw꞉o too. ");
INSERT INTO yle_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Njayidus u p꞉o dini ghi n꞉ii ngê taa dniye, Yesu ngê yoo yi módu, apê, Mu mbê té, mu kââkââ té. ");
INSERT INTO yle_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu ngomo k꞉oo adî kee, mgongo ye ngmê kwólu, yepê, Ala lukwe u dnyengi ayi kwo? Yepê, Lukwe dîy꞉o nmye mbê té? Yepê, Ye dmââdî doo pwene, ngmênê a dpî. ");
INSERT INTO yle_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yesu dnye yumuyumu, ngmênê kuwa pw꞉ii too, yi dmââdî u pye mî, p꞉uu ndiye pyu pyile knî yi k꞉ii, ngomo ghi k꞉oo adî kee dmi, yi dmââdî ntóó kwéli doo ya. ");
INSERT INTO yle_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu yi dmââdî kwulo kele, yi dnye ngê kwo, Tálita kum, u nt꞉u kópu, Kî dmââdî, a piidi. ");
INSERT INTO yle_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wod꞉oo a pii wo, modoo paambwi. Yi dmââdî u m꞉ââ y꞉a mê miyó ngê doo ya. Dini ghi n꞉ii ngê yi dmââdî Yesu ngê a pyidu ngê, ngwéti dniye, apê, Yesu ngê ló kópu adî d꞉uu? ");
INSERT INTO yle_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu ngê yepê, Ala kópu nmyi mênê dpo ghêpê we, pi ka nangê vyi. Yepê, Nté pee u kwo ngmê y꞉ee nyoo. ");
INSERT INTO yle_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu kwéli doo ya, yi ghi a kuwo ngê, p꞉aani n꞉ii a kaa wo y꞉i mê diyé wo, Nasalet, p꞉uu ndiye pyu knî yi k꞉ii. ");
INSERT INTO yle_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lîme wo ngê ngêpê ngomo k꞉oo kee dniye, Yesu ngê doo ndiye kîgha dé. Pi y꞉i mê yilî doo ya. Dini ghi n꞉ii ngê yi kópu yilî ny꞉ee ngópu, ngwéti dniye. Noko yepê, Ala kópu yilî anyi wunê ng꞉êênî? Noko yepê, Nuw꞉o ghi ndîî nanê u kwo a yémî té? Noko yepê, Mbwudu yilî angênté dpî chaa? ");
INSERT INTO yle_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Noko yepê, Kî daa pi ngmê. Noko yepê, Ngomo wuwó pyu. Noko yepê, Kî Méli tp꞉oo, Njems Njósés Njudas Saimon yi mbwó. Noko yepê, U tîdê yoo al꞉ii myeka kwo. Yi kópu u l꞉êê dîy꞉o Yesu mb꞉ii ngópu. ");
INSERT INTO yle_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ngê yepê, Chóó Lémi u komo kapî pyu kn꞉aa p꞉aani dp꞉uu châpu ngmê, ngmênê u p꞉o tpémi y꞉oo d꞉uudpî châpu ngmê, ngmênêni knî y꞉oo myed꞉uudpî châpu ngmê. ");
INSERT INTO yle_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Doo u ntââ Yesu ngê mbwudu yilî y꞉i daapî chópu, ngmênê pwopwokopwe knî ngmê yi mbêmê kêê yó, u ngwo pyi too. ");
INSERT INTO yle_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu ngê u gha vy꞉o apê, Lukwe dîy꞉o kî yéli a ka dêdê kêlîmî té? Yesu ngê Nasalet a kuwo ngê, u nkîgh꞉ê p꞉aani n꞉ii dnye ya, yi wee u kwo loo, Chóó Lémi u kópu p꞉uu doon꞉aa ndiye kîgha dé. ");
INSERT INTO yle_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wo ngmê ngê p꞉uu ndiye pyu yintómu y꞉a mê miyó a danê ngê, p꞉aani p꞉aani miyó miyó doo dyede. Yepê, U ntââ ngê n꞉aa pyépi nmyo, pi knî y꞉e yi kmêna anmyin꞉aa ngm꞉ii kîgha dé. ");
INSERT INTO yle_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yepê, U ntââ nmyi kiyé avy꞉ee ńuw꞉o t꞉oo, ngmênê tpile n꞉aamu ńuw꞉o. Yepê, Nté n꞉aangmê ńuw꞉o, nmyi tpile péé myen꞉aangmê ńuw꞉o, ndapî nmyi mênê myekîngmê kwo. ");
INSERT INTO yle_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yepê, Nmyi yi dópo dmi nmyi yiye yi t꞉ee yó, ngmênê nmyi mbwo kpîdî myomoni n꞉aangmê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yepê, P꞉aani p꞉aani pi miyó miyó dpî lee we. Yepê, P꞉aani n꞉ii pini n꞉ii dê d꞉uu taa knomomê, ngomoni k꞉oo adpî koko, y꞉i dny꞉oo ya, u dî yi p꞉aani mêdny꞉oo a kuwokuwo. ");
INSERT INTO yle_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yepê, Pini n꞉ii dê p꞉aani n꞉ii adpîn꞉aa taataa, yi p꞉aani tpémi y꞉oo yi yi dê y꞉e daachoo kwo knomomê, yepê, yi dnye dê daadnyimo nyêmî knomomê, ye yi pini dê y꞉oo yi p꞉aani dny꞉oo a kuwokuwo, yi p꞉aani u têpê yi yi yodo p꞉uu dny꞉oo vyavya. Yepê, Yi p꞉aani tpémi y꞉oo ala kópu u ngwo wa a w꞉ee ngmê, awo, Yinê ye dp꞉oo Nju tpémi, dp꞉oo Chóó Lémi u yoo. ");
INSERT INTO yle_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wod꞉oo Yesu p꞉uu ndiye pyu y꞉a mê miyó p꞉aani p꞉aani lee dniye, ala kópu pi knî ye dnyen꞉aa tpapê, yipu, Nmyi dono kópu yilî yintómu kéé tóó. ");
INSERT INTO yle_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pi yilî knî y꞉e yi kmêna mî ngm꞉ii kalê tumo, yâpwo wulu mbii pyu yilî yi mbêmê dnyen꞉aa a pipi, u ngwo dnye pyipyi dé. ");
INSERT INTO yle_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesu ngê kópuni doo d꞉uud꞉uu dé, King Antipas Helodi ngê yi kópu yilî nyongo, mu kópu u dîy꞉o Yesu u pi pi yilî yintómu yi lama doo ya, ngmênê Helodi ngê Yesu daangê módu. Pi knî ngmê y꞉oo Yesu p꞉uu apê, Njon Baptist kîmêdê pyidu, wu vyîlo. Apê, Yi kópu u l꞉êê dîy꞉o mbwudu yilî a chapî ngê. ");
INSERT INTO yle_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngmê knî y꞉oo apê, Ilacha kîmaa t꞉aa, wu vyîlo. Ngmê knî y꞉oo apê, Chóó Lémi u komo kapî pyu ngmê, apê, wunê Chóó Lémi u komo ntee dnyimo a kapî, yinté pini ngmê kîmêdê pyidu, wu vyîlo. ");
INSERT INTO yle_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dini ghi n꞉ii ngê King Helodi ngê Yesu u pi nyongo, apê, Njon Baptist. Apê, Mbwámê kînî châpwo, apê, kîmêdê pyidu, wu vyîlo. Ala Njon Baptist u vyee u danêmbum. ");
INSERT INTO yle_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Mwiyémwiyé, Antipas Helodi ngê u mbwó Pilipi u kpâm t꞉âmo ngê, yi pyópu u pi Helodiyas. Yi kópu Njon ngê Antipas ka dpîmo kwódukwódu. Yi kwódu yé u l꞉êê dîy꞉o yi pyópu ka Njon u ngwo diya wo, yed꞉oo Antipas ka u ngwo vyu, kwo, Njon vya ngi. Antipas ngê Njon mbwa k꞉oo adî knî, ngmênê ghêlî daa vyâ. ");
INSERT INTO yle_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Antipas Njon ka dpîmo nkîngê, mu kópu u dîy꞉o u lama dpîmo ya, Njon pi mb꞉aa, ndêndê ngê Chóó Lémi u nuu u pi. Yi kópu u l꞉êê dîy꞉o, pi knî ye kwódu ngê, yepê, Njon nangê vy꞉a. Wo knî ngmê ngê u lede knî ye dpîmo tpapê, yipu, Njon nga a pwiyé we, u kópu dyuu ngmên꞉aa nyêm. K꞉omo tpile Njon u kópu knî yi l꞉êê dîy꞉o Antipas u gha l꞉âmo dpîmo a ngêpw꞉angêpw꞉a, ngmênê u yi u ngwo dpîmo kwo, Njon a ka choon꞉aa dêêpî. ");
INSERT INTO yle_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Antipas Helodi u taataa u wo dini ghi n꞉ii ngê dyimê wo, chóó u l꞉êê dîy꞉o naa ndîî ngmê kpo, mââwe ndîî yoo a danê ngê, mââwe ndîî dêpwo a ya, Nkálili. ");
INSERT INTO yle_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yi nááli têdê Helodiyas tp꞉oo módó doo ndens, kwodo mb꞉aa. Yi kwodo ngê yi nááli têdê mââwe yoo a pwaa too, wod꞉oo Antipas ngê kwo, Lukwe u yi ṉga ngma a kwo? Kwo, K꞉omo tpile lukwe u pi ngmênye tpapê, u ntââ ṉga nînê kuwo. Kwo, Ntémwi u pi a ka nye tpapê, yi ntémwi ṉga nînê kuwo. ");
INSERT INTO yle_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kwo, Daanî dóó ngi, mu kópu u dîy꞉o Chóó Lémi ngê wunê y꞉enê nê. ");
INSERT INTO yle_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wod꞉oo yi kwodo adî lê, u pye ka ad꞉uu póó, kwo, King ka lukwe ngmanî dmyinê? U pye ngê kwo, Njon mbodo yu dmy꞉ee ngi. ");
INSERT INTO yle_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wod꞉oo yi kwodo mbêpêmbêpê ngê mê diyé wo, king ka kwo, Njon mbodo ala ngwo nmoko yedê a ka a ki. ");
INSERT INTO yle_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wod꞉oo king u gha dono ngê pyodo, ngmênê doo u ntââ wépi daapî puwâ, mu kópu u dîy꞉o yi kópu pi yilî yi ngîma vyu, mye kpaa wo. ");
INSERT INTO yle_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wod꞉oo lede ngmê dy꞉ââ ngê, kwo, Njon mbwámê nyinê chepwe, kwo, mbodo dpo ńuw꞉e. Wod꞉oo yi lede mbwa mî k꞉oo kee wo, Njon mbwámê mînê châpwo, ");
INSERT INTO yle_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mbodo nmoko yedê a kââ, ada ńuw꞉o, yi kwodo ka mî y꞉ângo, wod꞉oo yi kwodo ngê u pye ka u nkwo mî y꞉ângo. Helodiyas u gha u ngwo mî pyodo. ");
INSERT INTO yle_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Njon p꞉uu ndiye pyu knî y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, lee dniye, Njon ntóó mînê ngî ngópu, kpomo u mênê mî kmênê ngópu. ");
INSERT INTO yle_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu u dyépi yoo Yesu ka mê diyé dniye, kópuni mî d꞉uu tumo u kwo mînê nté tumo. Pi knî yi lama kópuni dnyen꞉aa kîgha dé, u kwo myedê nté tumo. ");
INSERT INTO yle_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yi dini ghi ngê Yesu u nkîgh꞉ê pi dêpwo ghêdê, a yina ngópu, doo u ntââ kmaapî u dye ghi dêpwo ya, mu kópu u dîy꞉o yoo mudoo a lîwe, Yesu u pyinê dnya a ng꞉uu, yi pyipyi u l꞉êê dîy꞉o. Wod꞉oo Yesu ngê p꞉uu ndiye pyu knî ye yepê, Ghi mb꞉aa ngmênyinê pyw꞉ee koo, pi kwéli daa m꞉ii, ghê y꞉i nye vy꞉êê koo. ");
INSERT INTO yle_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wod꞉oo dinki k꞉oo wo dniye, kada a y꞉ee ngópu, pi kwéli dêpwo a m꞉ii, y꞉i lee dniye. ");
INSERT INTO yle_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ngmênê pi yilî y꞉oo m꞉uu tumo, mya tumo, yi p꞉aa a kuwo tumo, yélî maa kalê ngópu, dinki kwéli doon꞉aa koko, yoo y꞉i mwiyé mî ta. ");
INSERT INTO yle_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Dini ghi n꞉ii ngê Yesu dinki k꞉oo a ghay wo, yoo ndîî yi módu, u kwo ch꞉anê dniye, mu kópu u dîy꞉o apê, Na a ka sipi w꞉uu n꞉ii yi y꞉eey꞉ee pyu daa tóó, pi ye daa vyuwo. Yi kópu u l꞉êê dîy꞉o daa kópu ngmidi yi lama doo kîgha. ");
INSERT INTO yle_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Dini ghi n꞉ii ngê kââdî doo wupwo, p꞉uu ndiye pyu knî y꞉oo kwo, Wunê kââdî kînga dê ghîî, kwo, p꞉aa al꞉ii daa tóó, kwo, kî yéli dy꞉ââ té, ala wee u kwo p꞉aani p꞉aani dny꞉oon꞉aa nté pywupwi. ");
INSERT INTO yle_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu ngê yepê, Nmyi chóó nté pee knî ye ngmê y꞉ee yó. Kwo, Doo u ntââ. Kwo, Yi ntoo ndapî nmî ngópu daa tóó. ");
INSERT INTO yle_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu ngê yepê, Mbîdédi yémi nmyi ngópu a kwo? Yepê, Lee dmyeno, nyinê kp꞉aa yó. Dini ghi n꞉ii ngê mênê kp꞉aa ngópu, kwo, Mbîdédi limi, te miyó. ");
INSERT INTO yle_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wod꞉oo Yesu ngê p꞉uu ndiye pyu knî ye yepê, Pi yêê yó, yoo yoo a pyódu yó, mbiye mbêmê mbwódo yaa dniye. ");
INSERT INTO yle_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wod꞉oo yoo chámê ngópu, yoo yoo a pyidu ngópu, yoo ngmê limoy꞉a, yoo ngmê yonoy꞉a, yinté mbwódo yaa dniye. ");
INSERT INTO yle_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu ngê Mbîdédi limi knî a ngî too, te dê myedê ngî doo, mbóó p꞉uu vyu wo, Chóó Lémi yi l꞉êê dîy꞉o kwuno ngê, mbîdédi pwaa too, p꞉uu ndiye pyu knî ye y꞉ee too, pi knî ye u nkwo y꞉ee tumo. Te dê mye pwaa doo, mbîdédi u ch꞉êê kê dumo. ");
INSERT INTO yle_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pi yintómu doo kmaapî, yi ghê dmi a kee wo. ");
INSERT INTO yle_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nté kmono n꞉ii mî kê wo, Yesu p꞉uu ndiye pyu knî y꞉oo péé y꞉a mê miyó mê ntówo ngópu. ");
INSERT INTO yle_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yélini doo kmaapî yintómu limo yono yono y꞉a. Mââ yoo yi mo yedê kp꞉aa tumo. ");
INSERT INTO yle_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kmaapî u kuwó dini ghi ngê Yesu ngê p꞉uu ndiye pyu knî ye yepê, Dinki k꞉oo wo dmyeno, yepê, Mbetîsaida mwada kpéni lêê pee a kada dmyinê kwo. Yepê, Yoo yi p꞉o p꞉o n꞉aa dyede té. ");
INSERT INTO yle_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yi kuwó yoo yi p꞉o yi p꞉o dy꞉ââ too, mbu mbêmê kee wo, y꞉i doon꞉aa ngêpê. ");
INSERT INTO yle_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dini ghi n꞉ii ngê mgîdî doo a ghayghay, dinki kpé lêê ńuknîńuknî u kwo doon꞉aa mbêpê, Yesu yélî p꞉uu u mo doo a ya. ");
INSERT INTO yle_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yi vyu wo, apê, Dinki ngê dono mînê pyw꞉êmî, mu kópu u dîy꞉o kêpa yópu ngê ye a ghê wo. Yi kópu u l꞉êê dîy꞉o Yesu ngê mw꞉aamw꞉aa yi kêlî ghi a kuwo ngê, kpé mbêmê paa kn꞉ââ chópu, p꞉uu ndiye pyu knî ye doo lêpî. ");
INSERT INTO yle_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yi kêma chono mî m꞉uu ngópu, apê, Kpé mbêmê lukwe kîyedê pwiyé knî? Apê, Kmêna? Apê, Mbwee? Ghê yi mênê ghîpé wo, nkîngê ngê y꞉ay꞉a pwiyé dniye. ");
INSERT INTO yle_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yintómu yi m꞉uu ngópu. Yesu ngê yepê, Namê nkîngê. Yepê, Ala nê. ");
INSERT INTO yle_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wod꞉oo dinki k꞉oo ye wo wo, yi ngwo yópu mêdê ngópu. Yi kópu p꞉uu ndiye pyu yoo yi nyepênyepê u kópu ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","K꞉omo tpile yoo ndîî, nté têdê, Yesu ngê yoo u ngwo mbono ngê, ngmênê p꞉uu ndiye pyu knî y꞉oo myedêpê w꞉ee ngópu, pini n꞉ii ngê tpile yintómu l꞉âmo ngê, yi pini yi vy꞉o doo kwo. Doo u ntââ, daa pêdê w꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Dini ghi n꞉ii ngê kpé lêê ngmêê ngópu, Nkenesadet mî tee dniye, dinki lyoko a kuwo ngópu, wod꞉oo pi knî y꞉oo Yesu adî mya ngmê. ");
INSERT INTO yle_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Dini ghi n꞉ii ngê Yesu mya ngópu, mbêpê dmi a pwaa ngópu, p꞉aani p꞉aani lee dniye, mdoo ńuw꞉o ngópu, wod꞉oo pwopwokopwe Yesu ka a ńuw꞉o tumo. Yesu p꞉o p꞉o kwéli dpîmo lêpî, yi pwopwokopwe dnyimo dnyinêdnyinê dé, Yesu ka dnyimo ńeńe dé, yi ngmîtédmi mbêmê kââ puu ghê dnyimon꞉aa yiyé dé. Yesu ka dnye nkêpê, kópu, K꞉omo tpile mbii pyu woni knî yi pwo ṉgêê dê daanyi yé dê, ngmênê u ntââ ṉgmîdî kwódo p꞉uu kêê a yiyé ngmê, yed꞉oo a pyiyépyiyé té. N꞉ii knî y꞉oo Yesu u kpîdî kwódo p꞉uu kêê a t꞉ee ngópu, yintómu pyiyé dniye. ");
INSERT INTO yle_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Dêêpî pyu ngmê knî y꞉oo Njedusalem a kuwo ngópu, Nkálili lee dniye, Pádisi ngmê knî yi k꞉ii Yesu ka lee dniye. ");
INSERT INTO yle_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yi yéli y꞉oo noko yepê, Lukwe dîy꞉o Yesu p꞉uu ndiye pyu yoo kînté a kmaapî té, yi kêê tupwótupwó dé? Noko yepê, Chóó Lémi ka yoo dono ngê wa pyaa dmi. Noko yepê, Lukwe dîy꞉o nmî kn꞉ââ yoo yi l꞉êê ghi kpîpî tumo? Noko yepê, Lukwe dîy꞉o yi kêê daa ghêêghêê tumo? ");
INSERT INTO yle_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Yi kópu vyi ngópu, mu kópu u dîy꞉o Nju tpémi yintómu knî y꞉oo yi kn꞉ââ yoo yi l꞉êê ghi dmi yedê ngee ngópu, ngmênê Pádisi knî y꞉oo yi lémi ghi dmi ndêndê ngê a ngee ngópu, yi kêê mwiyé dpî ghêê t꞉oo, nté kuwó dpî ma ngmê, nté mwiyé dpî ghêê ngmê, kuwó moo ma ngmê. Yi kn꞉ââ yoo yi tpile ghêêghêê yedê ngee ngópu, yi d꞉ââ ghêêghêê myeyedê ngee ngópu. Ala kópu a tpapê ngmê, Nju tpémi y꞉oo yi tpile mb꞉aamb꞉aa ngê daawa ghêê t꞉oo, ye Chóó Lémi ka yoo dono ngê wa pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yi kópu u l꞉êê dîy꞉o Pádisi yoo dêêpî pyu yoo Yesu ka póó dniye, kwo, Lukwe dîy꞉o m̱꞉uu ndiye pyu knî y꞉oo nmî w꞉êê tpémi yi l꞉êê ghi dmi kpîpî tumo, kwo, lukwe dîy꞉o kêê tupwótupwó ngê a kmaapî té? ");
INSERT INTO yle_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu ngê yepê, Nmyi komo knî y꞉oo Chóó Lémi módó nmye chaa kîgha ngópu, ngmênê nmyi gha dmi tupwótupwó dé. Yepê, Dini ghi n꞉ii ngê Yisaya wunê nmyi p꞉uu doo a d꞉êê, ndêndê ngê dîpê kn꞉aadi ngê. Yepê, Chóó Lémi u kópu dyuu alanté a d꞉êê ngê, apê, Kî yéli y꞉oo yi komo ngê wunê chaa kîgha noo, ngmênê yi gha dmi kuughê a ka wunê pyede. ");
INSERT INTO yle_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Apê, Daa ndêndê ngê wunê chaa kîgha noo, mu kópu u dîy꞉o yi chóó yi nuw꞉o ngê pi knî ye a komo dpî kaa ngmê, yi chóó yi dêêpî kópu ngê pi knî ye a dêêpî nyédi. ");
INSERT INTO yle_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu ngê yepê, Yoo yi dêêpî kópu dyuu nmye nyêmî ngópu, ngmênê Chóó Lémi u dêêpî kópu dyuu dp꞉ee nyêmî ngópu. ");
INSERT INTO yle_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu Pádisi knî ye doo danêmbum, Dêêpî pyu knî ye myedoo danêmbum, yepê, Nmyinê nmye mb꞉aamb꞉aa ngê nmye nuw꞉o té, ngmênê dnyinté nmye nuw꞉o té. Yepê, Lukwe dîy꞉o Chóó Lémi u dêêpî kópu dyuu woni nmyi kéé tumo, nmyi chóó nmyi dêêpî kópu dyuu nmyinê ngî tumo? ");
INSERT INTO yle_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yepê, Mósisi ngê Chóó Lémi u kópu alanté a d꞉êê ngê, apê, Nmyi pye mî dmyinê chââchââ dé. Yepê, Ala kópu mye d꞉êê ngê, apê, N꞉ii ngê kópu dono u pye mî yi p꞉uu dê vyi knomomê, yi pini dpî vya yó. ");
INSERT INTO yle_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yepê, Mósisi ngê yi kópu d꞉êê ngê, ngmênê nmyi kópu u mo. Yepê, Dyimê pywuu nmye ngmênînê kuwo. Yepê, Pi ngmê u pye mî ye wa a tpêpwo knomomê, mbodo l꞉âmo lîmî k꞉ii wa ngêpa, yewo, Tpileni dpo pîd꞉a kê, Chóó Lémi ka wanî y꞉oo, yewo, yi tpile dpo mêdaanî kê. ");
INSERT INTO yle_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yepê, K꞉omo tpile yi pini u nuw꞉o dîyo mb꞉aamb꞉aa ngê moo pyódu, u yi u ngwo adî kwo, Niye M꞉aa ye yi tpile nî y꞉oo, ngmênê yi pini ka yi kópu nmye kwódukwódu ngópu, u kwo nmye tpapê ngópu, kwonmyimo, Ye tpile m̱ye m̱î ye daanyi y꞉oo, mu kópu u dîy꞉o ṉ́yóó nyi vyu, Chóó Lémi u nêni. Yepê, Pi knî ye yi pye mî chââchââ têdê ngê nmyi pyódu ngópu. ");
INSERT INTO yle_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yepê, Yoo yi lama kîgha têdê Chóó Lémi u kópu dyuu yinté nmyi kéé ngópu. Yepê, Dye ghi yintómu yinté kópu nmye d꞉uud꞉uu tumo. ");
INSERT INTO yle_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu ngê yoo mêdê danê ngê, yepê, A ka dmyina a ng꞉aa, nmyo yintómu. Yepê, Ala kópu dpo w꞉ee tóó. ");
INSERT INTO yle_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yepê, Tpileni pi u mênê dpî ghîî, doo u ntââ yi tpile ngê yi pini Chóó Lémi ka tupwótupwó ngê daawa pyódu. Yepê, Kêle. Yepê, Kópuni pi u kwo dpo pwii, yi kópu ngê yi pini Chóó Lémi ka tupwótupwó ngê yinê dpî pyódu. ");
INSERT INTO yle_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yepê, Yi kópu mb꞉aamb꞉aa ngê dmyinê nuw꞉onuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dini ghi n꞉ii ngê Yesu ngê yoo a kuwo ngê, ngomo k꞉oo mî kee wo, p꞉uu ndiye pyu yoo yi mgongo danêmbum p꞉uu u kwo póó dniye. ");
INSERT INTO yle_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesu ngê yepê, Nmyo kî yéli yi pénta dé? Yepê, Myedmyongê w꞉ee ngópu? Yepê, Ntini n꞉ii pi u mênê dpî ghîî, doo u ntââ yi ntini ngê yi pini Chóó Lémi ka tupwótupwó ngê daawa pyódu, yepê, mu kópu u dîy꞉o doo u nuw꞉o mênê dpî lê, ngmênê km꞉oo mênê dpî lê, yepê, u kuwó dini ghi ngê yi ntini moo n꞉aa yé. (Mósisi ngê ntini n꞉ii yilî Nju tpémi ye a kwódu ngê, Yesu ngê yi kwódu yé yinté chedê ngê pyódu ngê.) ");
INSERT INTO yle_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","22","Yesu ngê yepê, Kópuni pi u kwo wunê pywuwópywuwó yédi, yi kópu ngê yi pini Chóó Lémi ka tupwótupwó ngê yinê dpî pyódu, yepê, mu kópu u dîy꞉o pini n꞉ii u nuw꞉o u mênê nuw꞉o ghi dono a pywuwópywuwó nyédi, yepê, u kuwó dini ghi ngê yi pini ngê kópu dono yilî dpî d꞉uu, yepê, a pyââ ti yédi, a kpaa yédi, pi dpî vy꞉a, pi u kuwó dpî pwiyé, a mtîkó yédi, yepê, daa dono kópu ngmidi dpî d꞉uu. Yepê, Pi dpî dóó, pyââ p꞉uu a nuw꞉o yédi, chóó a ya yédi, k꞉omodanê mbêmê pi u pi a dyede too, a chaa yédi, dêêpî u mênê daa ya yédi. ");
INSERT INTO yle_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yepê, Yi dono kópu yintómu yi pini u gha mênê dpo pwii dmi, Chóó Lémi ka pi tupwótupwó ngê u ngwo dpî pyódu. ");
INSERT INTO yle_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","U kuwó dini ghi ngê Yesu ngê Nju tpémi yi dyámê pee a kuwo ngê, Ntii Pââ Ndîî u kêténi mî loo, p꞉aa ndîî ngmê u nkîgh꞉ê loo, u pi Taiya. Ngomo k꞉oo mî kee wo, u yi u ngwo dêpwo kwo, Pi a ka ngma a kee we, ngmênê yi kópu daa pyodo. ");
INSERT INTO yle_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pyââ ngmê, tp꞉oo módó ngê u kmêna ngmêdoo kwo. Yi pyópu ngê dini ghi n꞉ii ngê Yesu u pi yi nyongo, tp꞉oo módó p꞉o a kuwo ngê, Yesu ka loo, yu km꞉ee dyimê wo. ");
INSERT INTO yle_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yi pyópu daa Nju pyââ, Taiya wee u kwo pyââ. Yesu ka kwo, Mw꞉ââkó a Lémi. Kwo, A tp꞉ee módó ngê kmêna ngmêka kwo. Kwo, U ntââ wanyi ngm꞉ii kwolo. ");
INSERT INTO yle_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu ngê kwo, A yoo Nju tpémi mwiyé n꞉aa ngêêpî té. Kwo, Kn꞉aa yéli mwiyé daangmanî ngee, kwo, mu kópu u dîy꞉o tp꞉ee u nté n꞉êê ntee daanyinê ngî, w꞉ââ ka daanyi y꞉oo, kwo, yinté kn꞉aa yéli mwiyé daangmanî ngee, kwo, Nju tpémi mwiyé n꞉aa ngêêpî té. ");
INSERT INTO yle_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yi pyópu ngê kwo, Nyââ, a lémi. Kwo, Ndê kópu. Kwo, Ngmênê kmaapî têdê w꞉ââ knî y꞉oo nté kmono ntee a pîpî tumo, kwo, kópuni u pi ṉga dî vyi, mye yinté, kwo, yi kópu ṉga daa ndîî kópu, ṉga myedaa dpodo ndîî. ");
INSERT INTO yle_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu ngê ala kópu a w꞉ee ngê, apê, Kî pyópu mb꞉aamb꞉aa ngê a ka wunê kêlîmî, wod꞉oo yi pyópu ka kwo, Mb꞉aamb꞉aa ngê kîchi vyi. Kwo, P꞉o mê dini. Kwo, Kmêna ngê ṉ́m꞉ee módó ala ngwo kêda kuwo. ");
INSERT INTO yle_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wod꞉oo yi pyópu p꞉o mê diyé wo, tp꞉oo módó dpî têdê mî módu, apê, Ndê kópu, kmêna ngê atéda kuwo. ");
INSERT INTO yle_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","U kuwó dini ghi ngê Yesu ngê Taiya wee a kuwo ngê, Saidon máádi mî kwólu, P꞉aa Y꞉a Knî yi kwo mî loo, Nkálili Kpéni Lêê u nkîgh꞉ê mî ta. ");
INSERT INTO yle_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yesu ka pi ngmê ńuw꞉o ngópu, yi pini ngê dnye dêpwo nyêm, dnye dnyinté myedoo kîgha. Yesu ka kwo, U ntââ ala pini mbêmê ṉgêê wanyi yé? ");
INSERT INTO yle_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu ngê pi knî yi vy꞉o a pw꞉ii ngê, kóó pyââ dê ngópu mênê kaa doo, kóó tpyîpwi ngê, dóó yedê yó. ");
INSERT INTO yle_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yed꞉oo Yesu mbóó p꞉uu vyu wo, yi pini ka kwo, Kweńe. (Yi dnye ngê, Etpata.) ");
INSERT INTO yle_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yesu ka dpodo ndîî ngê pyodo, yi pini ngê dnye u ngwo nyongo, dnye mb꞉aamb꞉aa ngê u ngwo mye kwólu. ");
INSERT INTO yle_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu ngê yepê, Kópuni dî d꞉uu, yepê, pi knî ye mênangên꞉aa vyi. K꞉omo tpile Yesu ngê ye kwódu ngê, ngmênê u dnye daa ny꞉ee ngópu, pi knî ye mêmînê nté ngópu. ");
INSERT INTO yle_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Dini ghi n꞉ii ngê ny꞉ee ngópu, apê, Vyuw! Apê, Mââwa! Apê, Angênté dê pyi. Apê, Kópu yilî mb꞉aamb꞉aa ngê u lama a tóó. Apê, K꞉omo tpile ngópu dé, dnye daa kîgha ngmê, apê, ngmênê Yesu u ntââ, wa pyi té. ");
INSERT INTO yle_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Yi dini ghi ngê pi dêpwo ghêdê, Yesu kwéli ye doo danêmbum. Yi nté y꞉i chedê ngópu, wod꞉oo Yesu ngê p꞉uu ndiye pyu knî ye yepê, Kî yéli a ka atédê ch꞉anê dmi, mu kópu u dîy꞉o wo pyile a p꞉uu kêdê chedê ngmê, yi nté kîmya chedê ngmê. ");
INSERT INTO yle_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yepê, Yi p꞉o yi p꞉o módó n꞉aa dyede té, ye maa p꞉uu yi gha l꞉âmo dmi wunê ngêpangêpa. Yepê, Woni knî kuughê a ndê dniye. ");
INSERT INTO yle_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","P꞉uu ndiye pyu knî y꞉oo kwo, Nté al꞉ii daa tóó, kwo, yâpwo têdê myedaa tóó, kwo, yi ntoo ntini ló y꞉i anmo pyw꞉oo, yoo u ngwo anmî mbono? ");
INSERT INTO yle_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yepê, Mbîdédi nmyi ngópu yémi a kwo? Kwo, Pyudu. ");
INSERT INTO yle_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu ngê pi knî ye yepê, Mbwódo ya dmyeno. Wod꞉oo mbîdédi pyudu knî a ngî too, Chóó Lémi yi l꞉êê dîy꞉o kwuno ngê, pwaa too, p꞉uu ndiye pyu knî ye y꞉ee too, pi knî ye u nkwo y꞉ee tumo. ");
INSERT INTO yle_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Te tp꞉oo pyile njini myedê ngî too, Chóó Lémi yi l꞉êê dîy꞉o mye kwuno ngê, p꞉uu ndiye pyu knî ye mye y꞉ee too, yoo u ngwo mbono ngópu. ");
INSERT INTO yle_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Pi yintómu podo yono yono y꞉a doo kmaapî, yi ghê dmi a kee wo. Ntini n꞉ii mî kê wo, Yesu p꞉uu ndiye pyu knî y꞉oo a wó ngópu, péé pyudu mê ntówo ngópu, wod꞉oo Yesu ngê yoo yi p꞉o yi p꞉o mê dy꞉ââ too. ");
INSERT INTO yle_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","U kuwó dini ghi ngê Yesu p꞉uu ndiye pyu knî yi k꞉ii dinki k꞉oo wo dniye, Dalîmanuta wee u kwo lee dniye. ");
INSERT INTO yle_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pádisi knî ngma a loo, Yesu ka dnyen꞉aa kwopwepe. U yi y꞉e doo kwo, Yesu nmo tókó. Alanté dnye nuw꞉o, apê, Pini n꞉ii nmo t꞉âât꞉ââ, kî pini wo vyîlo, ye Chóó Lémi ngê u l꞉êê dîy꞉o mbwudu ngmêpaa chaa. Yi kópu u l꞉êê dîy꞉o, Yesu ka kwo, Mbwudu nmî ngópu ngmê chépi. ");
INSERT INTO yle_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wod꞉oo Yesu u gha dono ngê pyodo, yepê, Lukwe dîy꞉o a ka nmye tpapê ngmê, Mbwudu nmî ngópu ngmê chépi. Yepê, Yi kópu daanî d꞉uu. Yepê, Kópu yilî wunê kîdî d꞉uu. Yepê, Yi kópu dmi yi p꞉uu dmyinê nuw꞉o. ");
INSERT INTO yle_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wod꞉oo a kuwo too, p꞉uu ndiye pyu yoo a danê ngê, dinki k꞉oo wo dniye, kada a y꞉ee ngópu, kpé lêê ndîî mwada pee mî tee dniye. ");
INSERT INTO yle_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu p꞉uu ndiye pyu knî y꞉oo mbîdédi mu ngmidi dinki k꞉oo a ńuw꞉o ngópu, yi nuwo a kuwo wo, knî daam꞉uu ńuw꞉o ngópu. ");
INSERT INTO yle_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Dini ghi n꞉ii ngê Nkálili Kpéni Lêê dnye ngmêêpî, Yesu ngê yepê, Nmye dmyina a vyuwo. Yepê, Pádisi yoo yi yis ngê kîngî dyênê nmyo, yepê, King Helodi u yis ngê myekîngî dyênê nmyo. ");
INSERT INTO yle_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yi kópu p꞉uu yi chóó noko dnye danê, noko yepê, Wu kópu kêdê vyi, mu kópu u dîy꞉o mbîdédi dp꞉oom꞉uu ńuwo. ");
INSERT INTO yle_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kópuni p꞉uu dnye danê, Yesu u lama yaa wo, wod꞉oo ye adî póó, yepê, Lukwe dîy꞉o nmye danê té, nmyimo, Mbîdédi nmî ngópu daamu a kwo. Yepê, Mumdoo? Yepê, Nmyi lama daa tóó? Yepê, Lukwe dîy꞉o dmyongê w꞉ee ngópu? ");
INSERT INTO yle_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yepê, K꞉omo tpile nmyi ngwolo dmi a kwo, ngmênê mêdp꞉ee mumu ngmê, yepê, nmyi ngópu a pyede, myedp꞉ee nyêmî ngmê. ");
INSERT INTO yle_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Yepê, Lukwe? Nmyi nuwo da kuwo, dini ghi n꞉ii ngê mbîdédi limi knî munê pwaa too, pi limo yono yono y꞉a u ngwo munê mbono too, yepê, nté kmono péé yémi nmyi ntówo ngópu? Kwo, Y꞉a mê miyó. ");
INSERT INTO yle_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yepê, Dini ghi n꞉ii ngê mbîdédi pyudu knî mumy꞉aa pwaa too, pi podo yono yono y꞉a u ngwo mumy꞉aa mbono too, yepê, nté kmono péé yémi my꞉ee ntówo ngópu? Kwo, Pyudu. ");
INSERT INTO yle_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yepê, Mudmyongê w꞉ee ngópu? Yepê, Dómu ngê daawa ngee nmo. Yepê, Daa mbîdédi p꞉uu nmye n꞉aa mgongo. Yepê, Pádisi yoo yi l꞉êê ghi dé kîdmyongê d꞉uu t꞉oo, Helodi u l꞉êê ghi myekîdmyongê d꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mbetîsaida yi tee dniye, Yesu ka ngwolo kopwe ngmê ńuw꞉o ngópu, kwo, U ntââ ṉgêê p꞉uu wanyi yé. ");
INSERT INTO yle_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu ngwolo kopwe kwulo kele, yi p꞉aani kuwa ńuwo, y꞉i p꞉uu doon꞉aa dpodo, tpî ngîma pywé ngê, kóó dê ngîma yé doo, kwo, Yélî nye y꞉enê? ");
INSERT INTO yle_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yi pini ngê kwo, Nyââ. Kwo, Yoo anî y꞉enê, ngmênê na a ka yi kn꞉ââ ye m꞉ii té. ");
INSERT INTO yle_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Myombó Yesu ngê kóó dê ngîma mê yé doo, wod꞉oo yi pini ngê ngwolo dê dpodombiy꞉e vyuwo kalê doo, tpile yintómu mb꞉aamb꞉aa ngê mê módu. ");
INSERT INTO yle_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","U kuwó dini ghi ngê Yesu ngê yi pini p꞉o mê dy꞉ââ ngê, kwo, Ala ngwo kî p꞉aani mêkidingê diyé. ");
INSERT INTO yle_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu p꞉uu ndiye pyu knî yi k꞉ii kada a y꞉ee ngópu, p꞉aani n꞉ii u pi Sisadiya Pilipay, u wee u kwo lee dniye. Maa p꞉uu ye póó wo, yepê, Pi knî ye yinê ye nê n꞉uu? ");
INSERT INTO yle_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kwo, Ngmê knî y꞉oo alanté a tpapê ngmê, apu, Nyi Njon Baptist. Kwo, Ngmê knî y꞉oo alanté a tpapê ngmê, apu, Nyi Ilacha. Kwo, Ngmê knî y꞉oo alanté a tpapê ngmê, apu, N꞉ii knî y꞉oo Chóó Lémi u komo wunê dnyimo a kapî, ngmê kêda pyidu, nyi vyîlo. ");
INSERT INTO yle_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu u nkwo ye póó wo, yepê, Nmyinê nmye nê n꞉uu? Pita ngê kwo, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, nmî Mbwámê ngê a pyódu ngê, nyi vyîlo. ");
INSERT INTO yle_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yepê, Yi kópu pi knî ye nangê vyi. ");
INSERT INTO yle_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","U kuwó dini ghi ngê Yesu ngê p꞉uu ndiye pyu knî ye u pwopwo p꞉uu danê u kn꞉ââ chópu. Yepê, Nê Chóó Lémi u Pi Ndêndê, yinê a ngmidi noo, ngmênê nmî kada pini knî y꞉oo wa mb꞉ii nê. Yepê, Kpêê yiyé pyu yoo yi kada pini knî y꞉oo wa mb꞉ii nê, dêêpî pyu knî y꞉oo wamye mb꞉ii nê. Yepê, Dono kópu yilî a nga wa d꞉uu ngmê, wa vya nê, wo pyoloni ngê amênê pyidu. ");
INSERT INTO yle_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu ngê p꞉uu ndiye pyu knî ye yi kópu dêpê wópu ngê, mb꞉aamb꞉aa ngê ye vyu, wod꞉oo Pita ngê Yesu u mo kuwa ńuwo, kwo, A Lémi. Kwo, Ye kópu kidimê tpapê. Kwo, Yinté ṉga daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngmênê Yesu yi diyé wo, p꞉uu ndiye pyu knî yi ngópu Pita ka kwo, A nkîgh꞉ê a yumwe. Kwo, Nyi Setan ntee pini. Kwo, Daa Chóó Lémi u komo y꞉ee kapî, ye pi knî yi komo y꞉ee kapî. ");
INSERT INTO yle_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu ngê yoo a danê ngê, p꞉uu ndiye pyu yoo mye yi k꞉ii, yepê, N꞉ii ngê u yi adî kwo, Nê u yoo vy꞉o nî ghê, yi pini ngê choo a yâmuyâmu nê, u gha d꞉ud꞉umbiy꞉e a ka dpo kê ngê, chóó u kópu knî yi p꞉uu mêkîngê nuw꞉o, k꞉omo tpile a l꞉êê dîy꞉o dê pw꞉oo knomomê, ngmênê dpo ngm꞉êê nêne. ");
INSERT INTO yle_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yepê, Pini n꞉ii u ghê p꞉uu adî nuw꞉o, awo, Kîngê vya nê, u ngwo wa kede, a yoo vy꞉o daawa ghê, yepê, yi pini ndêndê ngê wa pw꞉onu, ndê ngê amî ma. Yepê, Pini n꞉ii a l꞉êê dîy꞉o wa pw꞉onu, yi pini amêdê pyidu, ghê kamî u ngwo wa a pyw꞉oo, mb꞉aamb꞉aa ngê adîn꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Yepê, Pini n꞉ii chóó u tpile knî yi p꞉uu adî nuw꞉o, u l꞉êê dîy꞉o Chóó Lémi wa mb꞉ii, yi pini dini ghi n꞉ii ngê wa pw꞉onu, yed꞉oo dono wa a pyw꞉oo. Yepê, K꞉omo tpile dyámê u tpile yintómu yi pini u ngópu adî ya knomomê, ngmênê doo u ntââ ghê kamî u ngwo daawa pwila, dono wa a pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yepê, Mgîdî u yoo yi l꞉êê ghi dmi dono dé, Chóó Lémi yi lama daa tóó. Yepê, Dye ghi knî ngmê ngê a yoo knî yi p꞉uu adnyi d꞉uu. Yepê, Yi dini ghi n꞉ii ngê pini n꞉ii ngê wa mb꞉ii nê, yewo, Nê kuu, nangê kpada nê, yepê, yi pini u nkwo wanî mb꞉ii, dini ghi n꞉ii ngê anê diyé, enjel knî yi k꞉ii. Yepê, Yi dini ghi ngê a pi ndîî ngê wa pyódu, M꞉aa u pi ntoo, a pi yintoo ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Pi knî nmyi vy꞉o ngma a kwo, ghêlî daawa pw꞉oo dmi, Chóó Lémi ngê chóó nmyi y꞉enê kn꞉ââ u wêdêwêdê mbêmê mwiyé wa chaa. ");
INSERT INTO yle_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wo wéni mî loo, u kuwó dini ghi ngê Yesu ngê u dyépi pyile njini mbu mbêmê ńuwo, yi pi dmi Pita, Njems mbwémi Njon. U dyépi pyile knî yi ngópu, Yesu u mo u nâmo mînê ghê wo, ");
INSERT INTO yle_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","u kpîdî d꞉ud꞉umbiy꞉e kpaapîkpaapî ngê pyodo, myedoo a wuu mbele. Doo u ntââ dyámê mbêmê pi ngê yinté kpîdî kpaapîkpaapî ntee kpîdî daawa ghodo. ");
INSERT INTO yle_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yi dini ghi ngê yi pini pyile knî y꞉oo Ilacha pini dê Mósisi Yesu k꞉ii danêmbum têdê m꞉uu tumo. ");
INSERT INTO yle_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita ngê Yesu ka kwo, Mââwe. Kwo, U p꞉o chi yé, cha ńuw꞉o nmo. Kwo, Ngomo pee pyile nmînê t꞉emî, kwo, ṉêni ngmê, Mósisi u nêni ngmê, Ilacha u nêni ngmê. ");
INSERT INTO yle_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yi kópu u kwo vyu, mu kópu u dîy꞉o u pyipe dê yi k꞉ii nkîngê ngê y꞉ay꞉a pwiyé dniye. Yi kópu Pita ka d꞉ud꞉umbiy꞉e ndîî ngê pyodo, apê, Ló kópu ngmanî vyi. ");
INSERT INTO yle_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nkalî too pee yi pwo ngmê yó, yi nkalî too pee u mênê dnye ngmê ny꞉ee ngópu, yepê, Kî a tp꞉ee njini, u nuu ghi a nódo a tóó. Yepê, U kwo ntênê dmyinê ng꞉aa. ");
INSERT INTO yle_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yi vyu dniye, apê, Pi u chii daa kwo. Apê, Yesu u mo mu kwo. ");
INSERT INTO yle_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mbu paa dini ghi n꞉ii ngê dnya a wupwo, Yesu ngê yepê, Kópuni dmye m꞉uu ngmê, pi ka ghêlî nangê vyi. Yepê, Kpêênî mwiyé anê pyidu, pi knî ye u ngwo dpî vyi yó. ");
INSERT INTO yle_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yi wéni ngê kópuni pyodo, pi ka ghêlî daa vyi ngópu, ngmênê yi chóó yi kópu p꞉uu dnyimo danêmbum. Noko yepê, Lukwe dîy꞉o Yesu ngê u pyidepyide u pi nmo dê vyi? ");
INSERT INTO yle_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wod꞉oo Yesu ka póó dniye, kwo, Lukwe dîy꞉o dêêpî pyu knî y꞉oo a tpapê ngmê, apu, Ilacha mwiyé wa t꞉aa, pini n꞉ii Chóó Lémi ngê a ngmidi ngê, yi pini dîyo kuwó ada a kwo? ");
INSERT INTO yle_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu ngê yepê, Nyââ. Yepê, Ilacha u taataa mwiyé, tpile yintómu yi l꞉âmol꞉âmo u l꞉êê dîy꞉o. Yepê, Lukwe dîy꞉o puku yedê alanté a tóó, Pi knî y꞉oo Chóó Lémi u Pi Ndêndê wa mb꞉ii ngmê, dono yilî u ngwo wa d꞉uu ngmê? ");
INSERT INTO yle_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yepê, Ngmênê ala kópu ny꞉ee yó. Yepê, Ilacha ntee pini wunê kî ta, a maa yinê a yó, ngmênê kada pini knî y꞉oo dono u ngwo d꞉uu ngópu, kópuni dono yi nuw꞉o ngê ye vyu, yi kópu u ngwo d꞉uu ngópu. Yepê, Yi kópu puku yedê yinté a tóó. ");
INSERT INTO yle_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu, u dyépi pyile knî yi k꞉ii, dini ghi n꞉ii ngê mbu mbêmê a ndê dniye, mbu vyuwo yedê ghêpê dniye, pi yilî m꞉uu ngópu, Yesu p꞉uu ndiye pyu woni knî yi k꞉ii. Dêêpî pyu yoo Yesu p꞉uu ndiye pyu yoo yi kwo dnye kwopwepe. ");
INSERT INTO yle_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Dini ghi n꞉ii ngê pi knî y꞉oo Yesu m꞉uu ngópu, ngwéti dniye, wod꞉oo mbêpê dmi a pwaa ngópu, u kwo lee dniye, mînê chipé ngópu. ");
INSERT INTO yle_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu p꞉uu ndiye pyu knî ye póó wo, yepê, Lukwe p꞉uu noko nmye kwopwepe té? ");
INSERT INTO yle_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pi ngmê yoo vy꞉o doo kwo, yi pini ngê kwo, Mââwe. Kwo, A tp꞉ee ṉga atéd꞉a ńuw꞉o, kwo, mu kópu u dîy꞉o u kmêna u ngwo ngma a kwo, yi kópu u l꞉êê dîy꞉o daa danêmbum, nyuno pwopwo u ngwo mye t꞉a. ");
INSERT INTO yle_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kwo, Dini ghi n꞉ii ngê u kmêna ngê dpî vy꞉a, ntóó têpê mbêmê dpî d꞉ii, tpî ch꞉aa pee dê u kwo dpî pwii knî, kpéngi ti dê numo kêpa dpî ghê knî. Kwo, A dîdmidîdmi yédi. Kwo, M̱꞉uu ndiye pyu knî ye kîdî vyi, yed꞉ê, A tp꞉ee ka u kmêna ngm꞉ii kalê yó, ngmênê kêdê dêê dmi. ");
INSERT INTO yle_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu ngê yepê, Lukwe dîy꞉o Chóó Lémi ka dp꞉ee kêlîmî té? Yepê, M꞉ââ yémi nmyi vy꞉o anî kwo, u dî Chóó Lémi ka mb꞉aamb꞉aa ngê anmyin꞉aa kêlîmî? Yepê, Yi tpémi a ka a ńuw꞉o yó. ");
INSERT INTO yle_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wod꞉oo yi tpémi u kwo adî ńuw꞉o ngmê. Dini ghi n꞉ii ngê u kmêna ngê Yesu módu, yi tpémi y꞉i vyâ, nyuno pwopwo u kwo y꞉ângo, wod꞉oo yi tpémi têpê mbêmê dyimê wo, doo a kpêpî, tpî ch꞉aa pee dê u kwo pwii knopwo. ");
INSERT INTO yle_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu yi tpémi u mî ka adî póó, kwo, M꞉ââ yémi mî loo, ala kópu u ngwo u kwo a pyodo? Yi pini ngê kwo, Tp꞉ee têdê ngê doo a ya, u ngwo u kwo a pyodo. ");
INSERT INTO yle_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kwo, Daa ng꞉êêntómu u kmêna ngê dpo, Nî vy꞉a, ndiya nî kéé, mbwaa paa nî kéé, d꞉ud꞉umbiy꞉e pw꞉oo we. Kwo, U ntââ ṉga anmî ch꞉anê dmi, nyi u ntââ knomomê, wanyi ngee nmo. ");
INSERT INTO yle_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu ngê kwo, Lukwe dîy꞉o a ka chi vyi, Nyi u ntââ knomomê? Kwo, N꞉ii Chóó Lémi ka a kêlîmî yédi, yi pini ka kópu yintómu u ntââ ngê a ya nyédi. ");
INSERT INTO yle_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wod꞉oo yi pini Yesu ka adî mbwólu, kwo, Chóó Lémi ka anî kêlîmî, ngmênê daa d꞉ud꞉umbiy꞉e. Kwo, Ngee nédi. ");
INSERT INTO yle_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pi yilî Yesu ka loo, wod꞉oo Yesu ngê yi kmêna ka kwo, Kî kmêna. Kwo, Lukwe dîy꞉o ye tpémi ngópu ngê nyi pyódu ngê, dnye lukwe dîy꞉o u mênê nyi chedê ngê? Kwo, Ye tpémi a kuwo ngi, u ngwo mêkidingê ghê. ");
INSERT INTO yle_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wod꞉oo yi kmêna ngê yi tpémi adî vy꞉a, yi tpémi dpodombiy꞉e ka wo, nyuno pwopwo u ngwo y꞉ay꞉a pwiyé wo, wod꞉oo kmêna ngê yi tpémi a kuwo ngê. Dini ghi n꞉ii ngê kmêna ngê yi tpémi a kuwo ngê, yi tpémi mêdêpwo a kpêpî, ntóó têpê mbêmê doo ya, wod꞉oo pi knî y꞉oo apê, E! Kêdê pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngmênê daa pwene. Yesu ngê kóó ngê mgîmî ngê, a pyidu ngê, ghêêmî kââ. ");
INSERT INTO yle_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dini ghi n꞉ii ngê Yesu ngê pi yilî a kuwo ngê, p꞉uu ndiye pyu yoo yi k꞉ii ngomo k꞉oo kee dniye, u kwo póó dniye, kwo, Lukwe dîy꞉o dp꞉oo u ntââ dé, yi kmêna dp꞉oo ngm꞉ii kwólu? ");
INSERT INTO yle_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu ngê yepê, Ngêpê ngê u ntââ. Yepê, Alanté kmêna u ngm꞉ii kîgha daa m꞉uu a tóó. ");
INSERT INTO yle_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Yesu p꞉uu ndiye pyu knî yi k꞉ii yi kêlê ghi a kuwo ngópu, Nkálili Wee dnyen꞉aa chii. Yesu ngê u yi u ngwo dêpwo kwo, Pi knî y꞉oo a pyw꞉ee nmîne, mu kópu u dîy꞉o p꞉uu ndiye pyu yoo u pwopwo p꞉uu doon꞉aa ndiye kîgha dé. Yepê, K꞉omo tpile nê Chóó Lémi u Pi Ndêndê, ngmênê yoo dono yi kêê k꞉oo wanî ghê, yi yéli y꞉oo wa vya nê, yepê, ngmênê wo pyoloni ngê amênê pyidu. ");
INSERT INTO yle_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","P꞉uu ndiye pyu yoo alanté dnye nuw꞉o, apê, Lukwe dîy꞉o kînté nmo a mbumu. Apê, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, u pi ndîî ngê wa pyódu, dono daawa a pyw꞉oo. Yi kópu dêpê w꞉ee ngópu, u kwo myedaa póó dniye, mu kópu u dîy꞉o nkîngê mbê dniye. ");
INSERT INTO yle_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dini ghi n꞉ii ngê Kîpêêniyêm taa dniye, ngomo k꞉oo kee dniye, Yesu p꞉uu ndiye pyu knî ye póó wo, yepê, Maa p꞉uu ló kópu p꞉uu noko nmye kwopwepe té? ");
INSERT INTO yle_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mywenemywene mbê dniye, kópu u kwo daa vyi ngópu, mu kópu u dîy꞉o maa p꞉uu noko kwopwepe n꞉ii a kalê ngópu, apê, Yesu u che p꞉ââ pee ngê n꞉uu angmê yââ. ");
INSERT INTO yle_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Wod꞉oo Yesu mbwódo yaa wo, p꞉uu ndiye pyu yoo a danê ngê, yepê, N꞉ii ngê u yi adî kwo, Yoo yi kada pini ngê nî ya, yepê, yi pini pi yintómu yi kuwó choo kwo, dye ghi yintómu pi knî yi p꞉uu choo dpodo. ");
INSERT INTO yle_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesu ngê tp꞉ee ngma a ngêêdî, p꞉uu ndiye pyu yoo yi ngópu kââ, yi tpémi kóó dê yi kêlê kââ, yepê, ");
INSERT INTO yle_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Pini n꞉ii alanté tpémi ka a l꞉êê dîy꞉o adî vyuwo, daa yi tpémi ka u mo adî vyuwo, ngmênê a ka amyeda a vyuwo, amyedî chââchââ nê. Yepê, Myenté, yepê, pini n꞉ii ngê adî cââchââ nê, daa a mo adî chââchââ nê, ngmênê pini n꞉ii ngê a dy꞉ââ noo, amyedî chââchââ. ");
INSERT INTO yle_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Njon ngê Yesu ka kwo, Mââwe. Kwo, Pi ngmêkudu m꞉uu, kwo, m̱i ngê pi knî yi kmêna kî ngm꞉ii kîgha té. Kwo, Yi kópu u kwo kudu kwódu, mu kópu u dîy꞉o daa nmî yoo vy꞉o pini ngmê. ");
INSERT INTO yle_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu ngê yepê, U kwo nangê kwódu. Yepê, Pini n꞉ii ngê a pi wa vyi, mbwudu u ngwo angmê chaa, doo u ntââ yi pini ngê u kuwó dini ghi ngê kópu dono a p꞉uu daawa vyi. ");
INSERT INTO yle_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yepê, N꞉ii nmî p꞉uu daa d꞉uu yédi, nmî pee pini. ");
INSERT INTO yle_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yepê, Pini n꞉ii ngê a l꞉êê dîy꞉o wa ngee nmyo, kópu mb꞉aa yi pini ngê ngmanî d꞉uu. Yepê, Mbwaa knî nmye angma a kê, k꞉omo tpile daa tpile ndîî nmye ayedê kê, ngmênê kópu mb꞉aa ndêndê ngê yi pini ngê ngmanî d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu ngê yepê, Tpémi dmââdîni yoo a ka wunê kêlîmî té, pi ngmê ngê yi kêlîmî l꞉âmo kîdangmê ngee. Yepê, Mu dini ghi ngê Chóó Lémi ngê yi pini dnyinté daawa kpada. Yepê, Pi knî y꞉oo yi pini mwiyé wo mgîmî ngópu, chêêpî pââ ndîî nódo ngmêwo kudu ngópu, mbéli u kwo wumê kalê ngópu, ye yi dono ndîî daapî d꞉uu ngê, Chóó Lémi ngê dpodombiy꞉e daapaa kpada. ");
INSERT INTO yle_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Yepê, Kópuni ngmanmyi d꞉uud꞉uu, yi kópu u l꞉êê dîy꞉o wanmyi mb꞉ii nê, mu dini ghi ngê ndiya anmy꞉uu ghêpê dmi, yi ndyuw꞉e daawa pw꞉onu. Yepê, Yi kópu u kwee mwiyé anmyinê châpwo ngmê, yed꞉oo daanmyi mb꞉ii nê, mu dini ghi ngê ghê kamî anmyimo pyw꞉ee ngmê, a kêê k꞉oo anmyin꞉aa kwo. Yepê, Dono kópuni pi knî ye mb꞉aamb꞉aa dé, k꞉omo tpile yi p꞉eeni kópu daanmyi d꞉uu t꞉oo, ngmênê ghê kamî wanmyimo pyw꞉ee ngmê, a kêê k꞉oo anmyin꞉aa kwo. ");
INSERT INTO yle_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Yepê, Máádini p꞉uu anmyi ghê dmi, nmyi nuu u maa ngmanmyi kalê ngmê, u l꞉êê dîy꞉o wanmyi mb꞉ii nê, yi máádi dono u maa, u dî ndiya, y꞉i anmy꞉uu ghêpê dmi. Yepê, Nmyi chóó nmyi maa daanmyi kalê ngmê, a maa anmyinê kalê ngmê, ghê kamî wanmyimo pyw꞉ee ngmê, a kêê k꞉oo anmyin꞉aa kwo. Yepê, K꞉omo tpile maa woni knî nmyi lama daadnyi ya, ngmênê ghê kamî anmyimo pyw꞉ee ngmê, a kêê k꞉oo anmyin꞉aa kwo. ");
INSERT INTO yle_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","49","Yepê, Tpileni nmyi ngwolo knî y꞉oo wa m꞉uu ngmê, yi p꞉uu anmyi nuw꞉odono, yed꞉oo wanmyi mb꞉ii nê, mu dini ghi ngê ndiya anmy꞉uu ghêpê dmi, yi ndyuw꞉e daawa pw꞉onu, yimbile knî y꞉oo wamye ma nmyo, chedê ngê daawa pyódu. Yepê, Yi kêlê ghê ndê ngê adî pîpî nmyo. Yepê, Yi nuw꞉odono u kwee lîmîlîmî ngê anmyi châpwo ngmê, yed꞉oo daanmyi mb꞉ii nê, mu dini ghi ngê Chóó Lémi kóó k꞉oo anmy꞉uu ghê dmi. ");
INSERT INTO yle_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yepê, Ntii mb꞉aamb꞉aa. Yepê, Nté tpyópu u mênê ntii daanyi yé knomomê, ye u n꞉uu daadî ya, pwópwó ngê wa pyódu. Yepê, Ntii nté tpyópu u mênê ntee anyi yé, yepê, a kópu dyuu yinté nmyi mênê choo kwo, noko mb꞉aamb꞉aa ngê dmyinê ya. ");
INSERT INTO yle_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","U kuwó dini ghi ngê Yesu p꞉uu ndiye pyu knî yi k꞉ii Nkálili Wee a kuwo ngópu, Njuda Wee u kwo lee dniye, Njódan mbwááni ndîî mî ngmêê ngópu, Pédiya Wee u kwo lee dniye. Nkálili wee u kwo Yesu ngê pi yilî ntee dpîmo ndiye kîgha dé, y꞉i yinté myedoo ndiye kîgha dé. ");
INSERT INTO yle_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pádisi yoo u kwo ngmê loo, u yi y꞉e doo kwo, Yesu danêmbum têdê nmî dóó, kwo, Nmî dêêpî kópu dyuu lónté a kwo, kwo, u ntââ mââ ngê u kpâm wa kpîpî? ");
INSERT INTO yle_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu ngê yepê, Kópuni Mósisi ngê a d꞉êê ngê, yi kópu a ka vyi yó. ");
INSERT INTO yle_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kwo, Mósisi ngê ala kópu nmo kî ch꞉ee ngê, apê, Mââ ngê u kpâm dî kpîpî knomomê, u kópu dyuu dpî d꞉êê ngê, u kwo dpî y꞉ee ngê, u ngwo dpî dy꞉ââ ngê. ");
INSERT INTO yle_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu ngê yepê, Mósisi ngê yi kópu nmye mu d꞉êê ngê, mu kópu u dîy꞉o nmyi kpâm knî ye vyuwo dnyinté nmyi lama a tóó, Chóó Lémi u dnye dnyinté my꞉ee nyêmî ngópu. ");
INSERT INTO yle_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yepê, Mwiyémwiyé dini ghi ngê, Chóó Lémi ngê pyââ mââ l꞉âmo doo, yepê, Noko mb꞉aamb꞉aa ngê choo ya. ");
INSERT INTO yle_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yepê, Yi kópu u l꞉êê dîy꞉o mââ u pye mî yi kêlê dpo pwii, u kpâm k꞉ii ngmidi ngê dpî pyaa knî. ");
INSERT INTO yle_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Yepê, Wod꞉oo yéé yepe daa miyó a tóó, ngmênê mu ngmidi. ");
INSERT INTO yle_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yepê, Cha cha n꞉ii Chóó Lémi ngê dpo kââdî dê, pi ngê d꞉uudpî chámê dê. ");
INSERT INTO yle_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dini ghi n꞉ii ngê ngomo k꞉oo mê diyé dniye, Yesu p꞉uu ndiye pyu yoo yi kópu p꞉uu u kwo póó dniye. ");
INSERT INTO yle_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu ngê yepê, Pini n꞉ii ngê u kpâm dpî kpîpî, yi pini ngê kn꞉aa pyópu kîmungê nya. Yepê, Yi pini ngê kn꞉aa pyópu muwa nya knomomê, ye daa yééyéé u kópu ayi d꞉uu, ngmênê pyââ ti u kópu ayi d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yepê, Myenté, pyópu n꞉ii ngê u moo wa kpîpî, kn꞉aa pini p꞉uu amî yéé, yepê, daa yééyéé u kópu ayi d꞉uu, ngmênê mââ ti u kópu ayi d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pi knî y꞉oo Yesu ka yi tp꞉ee dmââdîma ńuw꞉o tumo, apê, Kóó yi mbêmê nyi yé ngê, ngmênê Yesu p꞉uu ndiye pyu knî y꞉oo ye kwódu ngópu. ");
INSERT INTO yle_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Dini ghi n꞉ii ngê Yesu ngê m꞉uu too, p꞉uu ndiye pyu knî ye nod꞉e wo, yepê, Ye namê kwódu yé, a ka a ńuw꞉o teńe, mu kópu u dîy꞉o tp꞉ee dmââdîma ntee yéli Chóó Lémi ngê chóó adî y꞉enê dé. ");
INSERT INTO yle_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Tp꞉ee ngê u mî u dnye ntee a nyêmî ngê, n꞉ii ngê Chóó Lémi u dnye yinté daadî nyêm, Chóó Lémi ngê yi pini wa mb꞉ii, kóó k꞉oo daawa kââ. ");
INSERT INTO yle_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wod꞉oo Yesu ngê tp꞉ee dmââdîma doo a ng꞉êênî dé, u pa doo t꞉emî dé, kêê yi mbêmê doo yiyé, doo kpaapîkpaapî dé, yipu, Chóó Lémi mb꞉aamb꞉aa ngê nmye choo a vyuwo. ");
INSERT INTO yle_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dini ghi n꞉ii ngê Yesu ngê kada doo a yém, pi ngmê mbêpêmbêpê ngê u kwo loo, yu mbodo dê y꞉e k꞉ame u kwo ghê wo, u kwo póó wo, kwo, Nmî ndiye pyu mb꞉aa. Kwo, Ló kópu ngmanî d꞉uu, ghê kamî u ngwo anê pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu? ");
INSERT INTO yle_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu ngê kwo, Lukwe dîy꞉o mb꞉aamb꞉aa u pi a pyimo chi t꞉oo? Kwo, Pi mb꞉aamb꞉aa daangma a tóó, Chóó Lémi mu ngmidi yi mb꞉aamb꞉aa. ");
INSERT INTO yle_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kwo, Dêêpî kópu dyuu ḻama a kwo, kwo, Pi nangmê vy꞉a, pi u kuwó nangmê pwiyé, pi u tpile nangmê t꞉âmo, pi nangmê yipe, pi nangmê dóó, m̱ye m̱î chi chââchââ dê. ");
INSERT INTO yle_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yi pini ngê kwo, Mââwe, kwo, tp꞉ee têdê noo a ya, yi kópu dyuu noo a chââchââ, ala ngwo myenî chââchââ té. ");
INSERT INTO yle_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu ngê até doo y꞉enê, u gha vy꞉o apê, Kî pini a nuu u pi. Yi pini ka kwo, Kópu mu ngmidi chuungê d꞉uu ngê, kwo, Chi lêpî, kwo, tpile yilîni ṉgópu a tóó, ngópuch꞉anê knî ye nyi yéépi, yed꞉oo dpo ngm꞉êê nédi, cha a yâmuyâmu nê, kwo, ya mb꞉aa mbóó p꞉uu u ngwo anyimo pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dini ghi n꞉ii ngê yi pini ngê yi kópu nyongo, u gha dono ngê pyodo, apê, A tpile yilî angênté anî yêê, wod꞉oo Yesu a kuwo ngê, mu kópu u dîy꞉o ndáápi ndîî, u tpile yilî. ");
INSERT INTO yle_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu yi diyé wo, p꞉uu ndiye pyu knî ye yepê, N꞉ii ndáápi ndîî, a maa p꞉uu paa dpodo ndîî ngê u kwo wa pyódu, Chóó Lémi kóó k꞉oo angênté amî ghê. ");
INSERT INTO yle_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yesu p꞉uu ndiye pyu yoo ngwéti dniye, apê, E! Apê, Kî lónté kópu? Yesu ngê yepê, Kî tp꞉eema. Yepê, Chóó Lémi kóó k꞉oo wowo dpodo ndîî. ");
INSERT INTO yle_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yepê, Mbwêmê ndîî, tee kn꞉ââ puu u mênê daawa kee, yepê, myenté Chóó Lémi kóó k꞉oo ndáápi d꞉uudpî ghê. ");
INSERT INTO yle_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","P꞉uu ndiye pyu knî y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, ghê yi mênê ghipé wo, noko yepê, Wu lónté kópu? Noko yepê, Ndáápi yoo Chóó Lémi kóó k꞉oo daangmêwa ghê knomomê, ye n꞉uu ngmê u ntââ y꞉i amî ghê? ");
INSERT INTO yle_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ngê doo y꞉enê dé, yepê, Doo u ntââ Chóó Lémi kóó k꞉oo pi chóó daangmêmî ghê, ngmênê Chóó Lémi chóó u ntââ, pi chóó kóó k꞉oo wa kââ. Yepê, Kópu yilî yintómu Chóó Lémi u ntââ. ");
INSERT INTO yle_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita ngê Yesu ka kwo, Mââwe. Kwo, Tpile yilî yintómu nmo kuwo ngê, anmînê yâmuyâmu ngi. ");
INSERT INTO yle_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê, Pini n꞉ii ngê a l꞉êê dîy꞉o u p꞉aa dpo kuwo, u tîdê mbwó yoo dpo kuwo té, u pye mî dpo kuwo dê, u tp꞉ee dmââdîma dpo kuwo té, u yâpwo têdê dmi myedo kuwo té, yepê, ala dini ghi ngê yi pini ngê yinté tpile yilî amêdê pyw꞉oo. Yepê, Pini n꞉ii ngê a kópu dyuu u l꞉êê dîy꞉o tpile ngmidi wa a kuwo, yepê, yi pini ngê yinté tpile mê yonoy꞉a amêdê pyw꞉oo, yepê, ngomo dé, u tîdê mbwó yoo, u pye mî yoo, u tp꞉ee dmââdîma, u yâpwo têdê dmi. Yepê, Nyââ, yepê, ala dini ghi ngê yi pini ngê u tpile yilî yinté amêdê pyw꞉ee té, yepê, dye ghi knî ngmê ngê pi knî y꞉oo a l꞉êê dîy꞉o yi pini wamye kpaka ngmê. Yepê, Mu dini ghi ngê yi pini ngê ghê kamî amînê pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yepê, Kada yéli mê kuwó, kuwó yéli mê kada. Yepê, Ala ngwo ndáápi yoo kada a wee, ngmênê dîy꞉o kuwó amêdê ghê dmi. ");
INSERT INTO yle_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Dini ghi n꞉ii ngê Yesu p꞉uu maa p꞉uu dnye m꞉ii, Njedusalem dnye lêpî, Yesu yi kada doo kwo. Yi kópu u dyépi yoo yi nuw꞉onuw꞉o u kópu ngê pyodo, yélini y꞉oo dnye yâmuyâmu dé, mye nkîngê mbê dniye. Yesu ngê p꞉uu ndiye pyu yoo kn꞉aa ńuw꞉o too, u pwopwo p꞉uu yi mo ye doon꞉aa danê. ");
INSERT INTO yle_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yepê, Ala kópu ny꞉ee yó. Yepê, K꞉omo tpile nê Chóó Lémi u Pi Ndêndê, ngmênê dini ghi n꞉ii ngê Njedusalem anm꞉uu taa dmi, Kpêê yiyé pyu yoo yi kada pini yoo, dêêpî pyu yoo yi k꞉ii, a vyee u dy꞉oo wa a châpwo ngmê, wa mgîmî nê, wa kóté kalê nê, wamye ch꞉ee nê, Lóma tpémi yi kêê k꞉oo wa kaa nê. ");
INSERT INTO yle_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yepê, Yi tpóknî y꞉oo wadnyi nkwitinkwiti nê, a p꞉uu wadnyi tpyîpwi, wadnyi kpakakpaka nê, wa vya nê, yepê, ngmênê wo pyoloni ngê wamênî pyidu. ");
INSERT INTO yle_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","U kuwó dini ghi ngê Sepédi tp꞉oo dê Yesu ka lee knopwo, Njems mbwémi Njon. Yesu ka kwo, Mââwe. Kwo, U yi nye a kwo, Kópu nye ngmê d꞉uu ngi. ");
INSERT INTO yle_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu ngê yepê, Ló kópu dp꞉o ngmanî d꞉uu? ");
INSERT INTO yle_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kwo, Dini ghi n꞉ii ngê m̱i ndîî ngê wa pyódu, Chóó Lémi u yoo anyi y꞉enê, u yi nye a kwo, Yoo yi kada dpî kaa nyédi. ");
INSERT INTO yle_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu ngê yepê, Kópuni a ka dpo dmyinê ngmê, daa dpî lama dpo mbumu mo. Yepê, Dpî u ntââ dê, pi knî y꞉oo kópuni a nga wa d꞉uu ngmê, u ntââ dpo amye d꞉uu ngmê? ");
INSERT INTO yle_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kwo, Nyo u ntââ dê. Yesu ngê yepê, Kópuni pi knî y꞉oo a nga wa d꞉uu ngmê, ndêndê ngê dpo amye d꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yepê, Ngmênê doo u ntââ a che p꞉ââ pee a chóó daanî ngmidi. Yepê, Chóó Lémi ngê yi kópu yinê wa a vyi. Yepê, Pini n꞉ii kada adî kwo, yi pini wunê ka a ngmidi ngê. ");
INSERT INTO yle_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesu p꞉uu ndiye pyu yoo wo y꞉a knî y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, Njems mbwémi Njon ye nod꞉e dniye. ");
INSERT INTO yle_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Wod꞉oo Yesu ngê p꞉uu ndiye pyu yoo nipi a danê ngê, yepê, Nmyi lama a tóó, yélini daa Nju tpémi, yi vy꞉o pini n꞉ii kada pini ngê dpî pyódu, yoo yinê a y꞉enê ngê, yinê a dpodo kîgha too. ");
INSERT INTO yle_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Yepê, Ngmênê nmyi vy꞉o yinté daadî ya. Yepê, Nmyi vy꞉o pini n꞉ii ngê u yi adî kwo, Kada pini ngê nî pyódu, yi pini ngê choo ngêêpî nmyo, nmyi p꞉uu choo dpodo. ");
INSERT INTO yle_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yepê, K꞉omo tpile Chóó Lémi ngê a ngmidi noo, nê u Pi Ndêndê, ngmênê daa lémilémi u l꞉êê dîy꞉o nê loo, yoo p꞉ee n꞉aa ngêêpî too, yi l꞉êê dîy꞉o wanî pw꞉onu, pi yilî yi pywuu ngê amy꞉aa pyódu. ");
INSERT INTO yle_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Njédikó taa dniye, y꞉i dnye ya, dini ghi n꞉ii ngê Njédikó dnya a kuwokuwo, pi yilî yi k꞉ii, pi ngmê maa nkîgh꞉ê doo ya, u pi Mbatîmeyas, Tîmeyas tp꞉oo. Yi pini ngwolo dê kopwe dê, daa dpodo u ntââ, maa nkîgh꞉ê dpîmo ya, pi knî ye ndapî dpîmo dmyinê. ");
INSERT INTO yle_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yi pini ngê dini ghi n꞉ii ngê nyongo, apê, Yesu Nasalet pi kîyedê pwiyé knî, wod꞉oo dpodombiy꞉e ka wo, kwo, Yesu. Kwo, N꞉ii Chóó Lémi ngê a ngmidi ngê, Dépidi ntee pini, u ntââ ṉga wanê ch꞉anê? ");
INSERT INTO yle_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","K꞉omo tpile pi yilî yintómu u kwo a tpêpwo dniye, kwo, Tumu chi ya, ngmênê yi dnye dmi daa nyongo, dpodombiy꞉e modoo kââ, kwo, Dépidi ntee pini. Kwo, U ntââ ṉga wanê ch꞉anê? ");
INSERT INTO yle_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wod꞉oo Yesu ngê paa u dî puwâ, yepê, Kî pini a ka a pwiyé we. U kwo até yi mbwóó dniye, kwo, Ṉga mb꞉aamb꞉aa ngê pyaa we, gh꞉êêdé. Kwo, Yesu ngê apu, A ka a pwiyé we. ");
INSERT INTO yle_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ngwolo kopwe ngê u nkuwo kpîdî a pywálî ngê, m꞉ii kéé ngê, mbêka wo, Yesu ka loo. ");
INSERT INTO yle_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu u kwo póó wo, kwo, Lukwe ṉga ngmanî mdo? Yi ngwolo kopwe ngê kwo, Mââwe. Kwo, U ya a nga a kwo, Yélî m꞉aa m꞉uu. ");
INSERT INTO yle_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu ngê kwo, U ntââ, kwo, mêchi lêpî. Kwo, Ṉgêlîmî mbêmê chi pyiyé. Wod꞉oo yi ngwo yélî mê módu, Yesu u kuwó maa p꞉uu mye ghê wo. ");
INSERT INTO yle_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu p꞉uu ndiye pyu yoo yi k꞉ii Njedusalem ghêlî daa nî dniye, yi kada p꞉aa miyó doo ya, Petani p꞉aani dê Petepake, mbu y꞉i ngma a kwo, u pi Olipi, mu kópu u dîy꞉o nté kn꞉ââ kpê yi mbwini mbêmê ngmêdoo ya, yi yini yi pi dmi mye olipi. Dini ghi n꞉ii ngê yi mbwini mbêmê kee dniye, Yesu ngê p꞉uu ndiye pyu kada miyó kââ, ");
INSERT INTO yle_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yepê, Mu p꞉aani nmî kada choo kwo. Yepê, Dini ghi n꞉ii ngê y꞉i dpo taataa mo, ndonki tp꞉oo dpo mumu ngmê, yedê ńedê a t꞉a. Yepê, Yi ndonki tp꞉oo pyipwo pi doongmê yaa wo. Yepê, Dpo pywálî nyoo, a ka dpo ńuw꞉o nyoo. ");
INSERT INTO yle_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yepê, Pini n꞉ii ngê dpo dê vyi knomomê, Ndonki tp꞉oo lukwe dîy꞉o dpo ńeńe ngmê, yepê, ye ala kópu u kwo dpî vyi nyoo, kwipi, Nmî lémi ngê u yi u ngwo wunê kwo. Mgî daawa a puwâ, dîyo mêwunê diyédiyé kîgha. ");
INSERT INTO yle_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wod꞉oo adî lee knî, yi p꞉aani ad꞉uu taa knî, apê, Ndonki tp꞉oo yedê ńedê mu t꞉a, ngomo t꞉âmo. ");
INSERT INTO yle_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Dini ghi n꞉ii ngê dpîmo a pywálîpywálî, pi ngmê knî y꞉oo yepê, Lukwe dîy꞉o ye ndonki tp꞉oo dpo pywálîpywálî ngmê? ");
INSERT INTO yle_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kópuni Yesu ngê ye a vyu, yi tpódu y꞉oo yi p꞉aani tpémi ye yinté vyi ngópu, wod꞉oo yi p꞉aani tpémi y꞉oo kópu mêdaa vyi ngópu, Ka, yepê, d꞉ââ ńuw꞉o nyoo. ");
INSERT INTO yle_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wod꞉oo yi ndonki Yesu ka ńuw꞉o ngópu, yi nkuwo kpîdî dê yi mbwo a ngee dumo, ndonki pyipwo talê dumo, Yesu pyipwo u nkwo yaa wo. Kada a y꞉ee ngópu, Njedusalem dnye lêpî, maa p꞉uu ndonki ngê Yesu doo dnyinêdnyinê. ");
INSERT INTO yle_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","King ntee dnyimo chââchââ, Yesu yinté mye châpu ngópu, woni knî y꞉oo yi nkuwo kpîdî a ngee tumo, Yesu u kada maa p꞉uu talê tumo, woni knî y꞉oo yi knî ngmê vy꞉êê ngópu, nkoo vyi u kadakada yidi ngópu, ndonki yi mbêmê doo paa, Yesu pyipwo doo ya. ");
INSERT INTO yle_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yoo u kada ngmêdoo kwo, yoo u kuwó mudoo kwo, Yesu yi kêlê ghê doo paa, Njedusalem nipi dnye lêpî, u nkwo dnye kââkââ, kópu, Munmîkó Nmî Lémi. Kópu, Chóó Lémi ngê a ngee nyine. Kópu, U pi ngê nyinê loo. ");
INSERT INTO yle_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kópu, Dépidi ntee pini. Kópu, Lîmî k꞉ii yoo yi kada pini ngê paa pyédi. Kópu, Chóó Lémi chaa kîgha koo. ");
INSERT INTO yle_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Dini ghi n꞉ii ngê Yesu yi p꞉aani ndîî mî ta, Njedusalem, Chóó Lémi u ngomo k꞉oo mî kee wo, tpile yilî y꞉i mî módu, wod꞉oo Njedusalem mêda kuwo ngópu, Petani mê diyé dniye, mu kópu u dîy꞉o yi dini ghi ngê kââdî doo wupwo. ");
INSERT INTO yle_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Womumo mw꞉aandiye Petani a kuwo ngópu, Njedusalem dnye lêpî. Maa p꞉uu Yesu ngê dómu kele. ");
INSERT INTO yle_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Maa nkîgh꞉ê kuwe ngmê m꞉uu ngópu, yââ vyi ndîî. Yesu yi yini km꞉ee adî lê, apê ngmênê, Kî yini p꞉uu kîgha ngma a kwo. Y꞉i n꞉ee, apê, Kîgha p꞉uu daa kwo, mu kópu u dîy꞉o doo u kyopwokyopwo u dye ghi ngê módu. ");
INSERT INTO yle_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu ngê yi yini ka kwo, Pi ngê ṉgîgha daamuwa ma. Yi yini ka kópuni vyu, p꞉uu ndiye pyu knî y꞉oo ny꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Dini ghi n꞉ii ngê Njedusalem taa dniye, Yesu p꞉uu Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo mî kee dniye, apê, Pi knî y꞉oo tpile tp꞉oo mu pywupwi t꞉oo, kpêê yiyé u l꞉êê dîy꞉o. Apê, Kn꞉aa dyámê ndapî nmî ndapî ngê mu ngmêêpî t꞉oo. Apê, Yélini al꞉ii a dpodo nyédi, yoo mu dódó t꞉oo, yi ndapî mu chedêchedê t꞉oo. Yi kópu u l꞉êê dîy꞉o Yesu ngê yi yéli a pw꞉oo ngê, kuwa pw꞉ii too, ndapî ngmêêpî têdê yi tépîl ye a pii too, ndapî tpii yi kpópu, ńmê tp꞉oo pywupwi têdê yi p꞉o a ngî too, yi ya têdê dnyi mye dy꞉ee too. ");
INSERT INTO yle_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yélini Njedusalem dnyimo dpodo, tpile dnyimo dnyinêdnyinê dé, u yi y꞉e dêdpîmo kwo, Chóó Lémi u ngomo kuwa máádi nmîmo kwolo, mu kópu u dîy꞉o kuughê, u yi y꞉e dpîmo kwo, Kêlî nmî pwii dmi, Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo máádi nmî kwolo, chono nmî pwii dmi, Yesu ngê yi kópu yi yéli ye kwódu ngê. ");
INSERT INTO yle_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chóó Lémi u kópu Yisaya ngê n꞉ii a d꞉êê ngê, yi kópu ye vyu, yepê, Puku yedê ala kópu mu tóó, A ngomo kwéli a kwo, dyámê pê yintómu pi knî yi ngêpê têdê ngê choo ya, yepê, ngmênê kpaa têdê ngê dmye pyódu ngmê. ");
INSERT INTO yle_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kópuni Yesu ngê d꞉uu ngê, Kpêê yiyé pyu yoo yi kada pini yoo, dêêpî pyu yoo yi k꞉ii, dini ghi n꞉ii ngê ny꞉ee ngópu, u yi y꞉e doo kwo, Yesu nmî vy꞉a. Yesu ka nkîngê mbê dniye, mu kópu u dîy꞉o pi yilî yintómu y꞉oo u dêêpî dnyimon꞉aa nyêm. ");
INSERT INTO yle_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yi ntumokwodo Yesu p꞉uu ndiye pyu knî yi k꞉ii Njedusalem a kuwo ngópu. ");
INSERT INTO yle_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Womumo mw꞉aandiye, dini ghi n꞉ii ngê Njedusalem dnye diyédiyé, yini n꞉ii Yesu ngê nt꞉ââ ngê, yi yini maa nkîgh꞉ê yi m꞉uu ngópu, Apê, Atédê pw꞉onu, d꞉ud꞉umbiy꞉e. ");
INSERT INTO yle_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yi kópu dini ghi n꞉ii ngê Pita ngê nuw꞉o kwólu, Yesu ka kwo, Mââwe. Kwo, Yini n꞉ii nyi nt꞉ââ, ntóó ngî mwini. ");
INSERT INTO yle_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, A ka dpodombiy꞉e anmya a kêlîmî knomomê, nmyi nuw꞉o dmi ngmidi ngê adnyi ya knomomê, ye kópuni wanmyi vyi t꞉oo, wa pyaa dmi. Yepê, Kî mbwini ka wanmyi vyi ngmê, kwonye, A yumwe, nt꞉ee nyi ghé, yepê, yi kópu wa d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yepê, Yi kópu u l꞉êê dîy꞉o nmye n꞉aa tpapê, Dini ghi n꞉ii ngê ngêpê têdê Chóó Lémi ka tpile ngmanmyi dmyinê, nmyi gha vy꞉o wanmyi vyi ngmê, anye, Ndêndê ngê Chóó Lémi ngê nmo wunê kuwo, yepê, yi kópu anmyinê pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Yepê, Dono kópuni pi knî y꞉oo nmye a d꞉uud꞉uu tumo, nmyi nuw꞉o ńedê adnyi ya, nmyi kuwó daanmyi kéé t꞉oo, yepê, k꞉omo tpile Chóó Lémi ka anmyi ngêpê, ngmênê kópu dononi nmyi d꞉uu tumo, Chóó Lémi ngê mbodo kn꞉ââ vyuwo daawa kéé té, yi l꞉êê dîy꞉o ntââ nmye wa vy꞉u. Yepê, Pi knî yi dono nmyi kuwó mwiyé dpî kéé tóó, yed꞉oo Chóó Lémi ngê nmyi dono u kuwó u nkwo wa kéé té, mêdaadî nuw꞉onuw꞉o dé. ");
INSERT INTO yle_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Dini ghi n꞉ii ngê Yesu p꞉uu Njedusalem mê taa dniye, Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo mê kee dniye, wod꞉oo kpêê yiyé pyu yoo yi kada pini yoo, dêêpî pyu yoo, yoo yi kada pini yoo mye yi k꞉ii Yesu ka lee dniye, kwo, Chóó Lémi u ngomo nmî chóó nmo y꞉enê. Kwo, Kópuni nye d꞉uud꞉uu too, n꞉uu ngê ṉga vyu, u ngwo nye d꞉uud꞉uu too? Kwo, N꞉uu u pi mbêmê ye kópu yilî nye d꞉uud꞉uu ngê? ");
INSERT INTO yle_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu ngê yepê, Kópu nmye mwiyé ngmên꞉aa poopoo. Yepê, Yi kópu nmyinê vyee ngmê, ye pini n꞉ii ngê a dy꞉ââ noo, u pi nmye u ngwo n꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yepê, N꞉uu u pi mbêmê Njon ngê pi mbwaa lêê u mênê dpîmo kmênêkmênê dé? Yepê, Chóó Lémi u pi mbêmê ó chóó u pi mbêmê? ");
INSERT INTO yle_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Noko yepê, Ló kópu u kwo ngmanmî vyi? Noko yepê, Ala kópu u kwo nmo tpapê, Chóó Lémi u pi mbêmê, noko yepê, ala kópu nmo a tpapê, Lukwe dîy꞉o Njon ka dpîp꞉e kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Noko yepê, Ala kópu u kwo nmo tpapê, Chóó u pi mbêmê, noko yepê, pi knî y꞉oo ló kópu nmo angmê d꞉uu ngmê. Pi knî ye nkîngê mbê dniye, mu kópu u dîy꞉o yinê ye Njon Chóó Lémi u komo kapî pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yi kópu u l꞉êê dîy꞉o kede dniye, Yesu ka kwo, Nmî lama daa tóó. Myenté, Yesu ngê yepê, Pini n꞉ii u pi mbêmê kópu yilî n꞉aa d꞉uud꞉uu ngê, nmye myedaanî vyi. ");
INSERT INTO yle_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","U kuwó dini ghi ngê Yesu pi yilî knî ye doo mgongo. Yepê, Pi ngmê ngê wain kpê ngmê yó, mbwa ngê a yina ngê, wain kîgha u vyilêvyilê têdê ngmê l꞉âmo ngê. Yepê, Ghi my꞉oo l꞉âmo ngê, yi wain kpê y꞉enê pyu u ya têdê. Yepê, Wain kpê chóó ngê pi ngmê knî ye yepê, A wain kpê ka dmyinê vyuwo, dini ghi n꞉ii ngê nt꞉u dê kaa knomomê, kîgha dmyina a ngêêpî dé, dmyinê vyilêvyilê dé, wain u ngwo dmyinê l꞉âmol꞉âmo, knî a ka ngmêdmyina a dyede, woni nmyi nêni. Yepê, U kuwó dini ghi ngê yi pini ngê wain kpê a kuwo ngê, kn꞉aa p꞉aani loo, dye ghi daadîî y꞉i doon꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Yepê, Wain kpê dini ghi n꞉ii ngê kyopwo wo, wain kpê chóó ngê u dpodo pyu ngmê dy꞉ââ ngê, kwo, A wain kpê mênê chi lêpî, u y꞉enê pyu knî y꞉oo a wain knî ṉga ngmêdo kê y꞉e, a ka dpo ńuw꞉o ngi. ");
INSERT INTO yle_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yepê, Ngmênê yi pini dini ghi n꞉ii ngê wain kpê mênê mî ta, u y꞉enê pyu knî y꞉oo wain knî u kwo daa y꞉ee ngópu, yi pini mgîmî ngópu, kpaka ngópu, wain kpê chóó ka módó mê dy꞉ââ ngópu. ");
INSERT INTO yle_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yepê, U kuwó dini ghi ngê wain kpê chóó ngê u dpodo pyu myomoni dy꞉ââ ngê, yinté kópu mu ngmidi u ngwo myedê d꞉uu ngópu, dpodombiy꞉e kpaka ngópu, wain kpê chóó ka módó mye dy꞉ââ ngópu. ");
INSERT INTO yle_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yepê, Myenté, wain kpê chóó ngê kn꞉aa pini m꞉uu dy꞉ââ ngê, yi pini vya ngópu, daa pyiyé wo. Yepê, Wain kpê chóó ngê pi yilî ye dy꞉ââ ngê, woni kpaka tumo, woni vya tumo, wain u kwo daa dy꞉ââ ngópu. ");
INSERT INTO yle_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yepê, U kuwó dini ghi ngê tp꞉oo ye u nkwo dy꞉ââ ngê, apê, A tp꞉ee amînê châpu ngmê, daawa a vya ngmê. ");
INSERT INTO yle_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yepê, Ngmênê yi wain kpê y꞉enê pyu knî y꞉oo daa châpu ngópu. Noko yepê, Kî wain kpê chóó tp꞉oo. Noko yepê, Vya koo, yed꞉oo wain kpê nmo wa ghay. ");
INSERT INTO yle_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yepê, Wod꞉oo mgîmî ngópu, vya ngópu, ntóó chii mênê mî kéé ngópu. ");
INSERT INTO yle_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu ye póó wo, yepê, Yi wain kpê chóó ngê ló kópu y꞉e angmê d꞉uu? Yepê, Wa a lê, pi dono yoo wa vya té, kn꞉aa yéli y꞉oo yi d꞉aa dmi u nkwo amênê kââdî ngmê. ");
INSERT INTO yle_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yepê, Ala kópu puku yedê nmyinê kp꞉aa ngópu, apii, yepê, Yi pââni ngomo wuwó pyu knî y꞉oo kéé ngópu, yi yini pââ pw꞉eni ngê vyîlo mêyi pyodo. ");
INSERT INTO yle_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nmî Lémi ngê yi kópu yinté d꞉uu ngê, nyepênyepê u kópu yi d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nju tpémi yi kada pini knî y꞉oo u yi y꞉e doo kwo, Yesu nmî mgîmî, mu kópu u dîy꞉o a w꞉ee ngópu, apê, Kî nmî p꞉uu a mgongo. Ngmênê pi yilî knî ye nkîngê mbê dniye, wod꞉oo Yesu mêdaa mgîmî ngópu, a kuwo ngópu, wod꞉oo lee dniye. ");
INSERT INTO yle_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pádisi yoo, Helodi u kwo téni pee yéli yi k꞉ii Yesu ka lee dniye, u yi y꞉e doo kwo, Yesu nmî dóó. ");
INSERT INTO yle_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yi lama doo ya, Lóma tpémi ye tákisi pywupwi Nju tpémi ye daa yi nuu u kópu ngê doo ya, wod꞉oo yi p꞉uu ndiye pyu knî ngmê ngmidi ngópu, king Helodi u kwo téni pee yéli yi k꞉ii Yesu ka dy꞉ââ tumo, kwo, Mââwe, kwo, nmî lama ka tóó, Ndêndê ngê nye danêmbum. Kwo, Pi knî ye d꞉ee nkîngê yédi, ngmênê Chóó Lémi u kópu dyuu pi knî ye ndêndê ngê nye tpapê ngê. Kwo, Nmo vyi ngi, kwo, nmî dêêpî kópu dyuu lónté a kwo, kwo, u ntââ Lóma tpémi yi king ndîî ka tákisi wanmî pywupwi? Kwo, Wanmî pwila, ó daanmî pwila? ");
INSERT INTO yle_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu ngê yi kópu a w꞉ee ngê, apê, Ngee k꞉omodanê té. Yepê, Lukwe dîy꞉o nmye dódó nê? Yepê, Tákisi ndapî a ka ngma a ńuw꞉o yó, ngmênî m꞉uu. ");
INSERT INTO yle_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","U kwo yi ńuw꞉o ngópu, yepê, Ala ndapî p꞉uu n꞉uu u kââ ye tóó, n꞉uu u pi myeye tóó? Kwo, Lóma tpémi yi king ndîî u kââ u pi ye tóó mo. ");
INSERT INTO yle_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wod꞉oo Yesu ngê yepê, Tpileni Lóma tpémi yi king ndîî ngmênêni, u kwo mêdmyinê yémî. Yepê, Tpileni Chóó Lémi ngmênêni, Chóó Lémi ka mêdmyinê yémî. Yi kópu yi ny꞉ee ngópu, yi nuw꞉onuw꞉o u kópu ngê pyodo, wod꞉oo Yesu a kuwo ngópu. ");
INSERT INTO yle_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yoo ngmê Yesu ka loo, yi yéli Sadyusi yoo. Yi nuw꞉o dmi alanté doo ya, apê, Pi dpî pw꞉onu, mêd꞉uuwodê pyidu. U yi y꞉e doo kwo, Yesu u pi nmî dyênê, u l꞉êê dîy꞉o Yesu alanté dnye dódó. ");
INSERT INTO yle_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Yesu ka kwo, Mósisi ngê ala dêêpî kópu a d꞉êê ngê, apê, Pi angmê pw꞉onu, u kuknwe adî ya knomomê, yi tp꞉ee daadî ya knomomê, ye yi pini u mbwó ngê yi kuknwe moo ndê ngê, u mbwó u l꞉êê dîy꞉o tp꞉ee angmê tpyé ngmê. ");
INSERT INTO yle_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kwo, Pi mbwémi pyudu doo ya, kaani yéé wo, tp꞉ee daa tpyó, u ngwo pwene. ");
INSERT INTO yle_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kwo, Kaapeeni ngê yi kuknwe mê ndê ngê, yi pyópu ngê tp꞉ee myedêpê ngêêdî, kaapeeni yinté u nkwo mye pwene. ");
INSERT INTO yle_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kwo, Yi mbwémi knî yintómu yi pyópu mu ngmidi yinté dnye ny꞉ee, yintómu pw꞉oo dniye, tp꞉ee yi pyópu ngê dêpangmê ngî ngópu. Kwo, U kuwó dini ghi ngê yi pyópu mye pwene. ");
INSERT INTO yle_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kwo, Lukwe dîy꞉o pyidepyide u pi nye tpapê. Kwo, Yoo wa a pii knomomê, ye yi pyópu ngê lukwe angmê pyódu, ló pini u kpâm ngê amî pyódu. Kwo, Doo u ntââ, mu kópu u dîy꞉o yi mbwémi pyudu knî yi pyópu mu ngmidi p꞉uu yéé dniye. ");
INSERT INTO yle_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu ngê yepê, Dmye kn꞉aadi ngmê, mu kópu u dîy꞉o Chóó Lémi u kópu dyuu nmyi lama daa kwo, u wêdêwêdê nmyi lama myedaa tóó. ");
INSERT INTO yle_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yepê, Enjel yoo ntee d꞉uudpî yéé dmi, dini ghi n꞉ii ngê yoo wa a pii dmi, yinté adnyi ya, pyââ mââ numo p꞉uu mêdaawa yéé knî. ");
INSERT INTO yle_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yepê, Yoo yi pyidepyide p꞉uu nmye n꞉aa danê. Yepê, Mósisi u puku pee dp꞉eengê w꞉ee ngópu, ndê ngê yi tp꞉oo kwéli doo pîpî. Yepê, Yi puku pee yedê alanté a tóó, Chóó Lémi ngê Mósisi ka kwo, Nê, ṉg꞉ââ Epîlaham u yâpwo, myenté tp꞉oo Yisak u yâpwo, myenté Yisak tp꞉oo Njakóp u yâpwo. ");
INSERT INTO yle_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yepê, Chóó Lémi yi tpóknî yi yâpwo, yi kópu u l꞉êê dîy꞉o, k꞉omo tpile a pw꞉oo dniye, ngmênê yi ghê a pyede. Yepê, Chóó Lémi daa ntóó knî yi yâpwo, ngmênê n꞉ii dé yi ghê a pyede, vyîlo yi yéli yi yâpwo. Yepê, Ndêndê ngê dmye kn꞉aadi ngmê. ");
INSERT INTO yle_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Dêêpî pyu ngmê y꞉i doo ya, Yesu u danêmbum doo ng꞉aang꞉aa. Yi pini ngê apê, Yesu ngê Sadyusi yoo yi kópu dyuu mb꞉aamb꞉aa ngê dê vy꞉a, wod꞉oo Yesu ka póó wo, kwo, Dêêpî kópu dyuu yi vy꞉o, lóni kada ngma a tóó? ");
INSERT INTO yle_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu ngê kwo, Ala dêêpî kópu kada ye tóó, kwo, Yisîléli tpémi. Kwo, Ala kópu ny꞉ee yó. Kwo, Chóó Lémi nmî yâpwo njini, nmî kada pini. Kwo, Daa m꞉uu a tóó. ");
INSERT INTO yle_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kwo, U nuu ghi nmyi nódo mb꞉aamb꞉aa ngê choo ya. Kwo, Chóó Lémi nmyi gha vy꞉o choo ya, dye ghi yintómu p꞉uu dmyinê nuw꞉o, u nuu u kópu yidmyinê d꞉uud꞉uu dé. ");
INSERT INTO yle_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kwo, Yi dêêpî kópu u kuwó alani a tóó, kwo, Ṉ́yóó ṉuu ghi ṉódo ntee a tóó, yoo yi nuu ghi dmi ṉódo yinté myechoo ya. Kwo, Yi dêêpî kópu dê kada a tóó mo. ");
INSERT INTO yle_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yi dêêpî pyu ngê Yesu ka kwo, Mââwe. Kwo, Ndêndê ngê kîchi vyi, Chóó Lémi mu ngmidi yi yâpwo, yâpwo kn꞉aa daa m꞉uu a tóó. ");
INSERT INTO yle_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kwo, Pi nódo Chóó Lémi u nuu ghi mb꞉aamb꞉aa ngê choo ya, Chóó Lémi u gha vy꞉o choo ya, dye ghi yintómu p꞉uu choo nuw꞉o, u dpodo p꞉uu myechoo dpodo. Kwo, Pi nódo chóó u nuu ghi ntee a tóó, yoo yi nuu ghi dmi yi pini nódo yinté myechoo ya. Kwo, Yi dêêpî kópu dê ndîî dê, kwo, Chóó Lémi ka kpêê yiyé ngmênê u kwo têdê. ");
INSERT INTO yle_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu ngê apê, Kî pini ngê gha kópu ngmêkêdê vyi, yi pini ka kwo, Daa kêmakêma Chóó Lémi kóó k꞉oo nye wowo. U kuwó dini ghi ngê Yesu ka kópu daam꞉uu poo ngópu. ");
INSERT INTO yle_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu dini ghi n꞉ii ngê Chóó Lémi u ngomo k꞉oo doon꞉aa dêêpî, pi knî ye póó wo, yepê, Lónté? Yepê, Dêêpî pyu knî y꞉oo lukwe dîy꞉o ala kópu a tpapê ngmê, apu, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, king Dépidi u tii ńedê pini ngmê? ");
INSERT INTO yle_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yesu ngê yepê, Lukwe dîy꞉o Dépidi ngê chóó u pi a ghîpî ngê, yi pini u pi kmungo? Yepê, Yi kópu p꞉uu dmyinê nuw꞉o. Yepê, Yi pini kada a tóó, Dépidi u kuwó a tóó, mu kópu u dîy꞉o Chóó Lémi u Ghê Dmi ngê Dépidi yinê a ngópu, ala kópu u ngwo a d꞉êê ngê, apê, Chóó Lémi ngê a kada pini ka kwo, M̱i ndîî ngê n꞉aa pyépi, a wéni pee dpî yey, pi yintómu chi y꞉enê dé. Yélini m̱꞉uu a l꞉êê té, dîyo anî vya té, ṉyi yodo u maknopwo wanî yé té. ");
INSERT INTO yle_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yesu ngê yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, Dépidi ngê apê, Yi pini a kada pini. Yepê, Yi kópu u l꞉êê dîy꞉o, yi pini daa Dépidi ntee pini, ngmênê pi knî yi pwo pini ntee pini. Yélini dnye lémilémi, Yesu ngê yi pi dmi yinté a ghîpî ngê, yoo yi nuw꞉o dmi d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê u ngwo pyodo. ");
INSERT INTO yle_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Dêêpî têdê Yesu ngê yepê, Dêêpî pyu yoo yi nj꞉ii ngê kêê nangmê t꞉oo, n꞉ii knî y꞉e u yi a kwo, Nmî pi dmi ndîî ngê pyaa we, nmî kpîdî dmi mb꞉aa kêlê nmî m꞉ii, pi knî y꞉oo mb꞉aamb꞉aa ngê pîdny꞉oo chââchââ nmo. ");
INSERT INTO yle_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yepê, Yinté yéli ngêpê ngomo k꞉oo yi chóó kada dp꞉uu yaa dmi, naa têdê yi chóó kada myoon꞉aa yaa dmi. ");
INSERT INTO yle_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yepê, K꞉omo tpile kuknwe dpî dóó t꞉oo, yi tpile dpî t꞉âmo t꞉oo, ngmênê pi knî yi ngîma Chóó Lémi ka a ngêpê nyédi, ngêpê daadîî ngê dpî pyódu t꞉oo. Yepê, K꞉omodanê pyu yoo. Yepê, Chóó Lémi ngê yinté yéli dpodombiy꞉e wa kpada té. ");
INSERT INTO yle_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","42","Wo ngmê ngê Yesu Chóó Lémi u ngomo k꞉oo doo ya, yoo doo y꞉enê, Chóó Lémi ka ndapî kwéli dnye yém. Ndáápi yilî knî y꞉oo ndapî ndîî yilî kéé ngópu, ngmênê kuknwe ngma a loo, ndapî kmono miyó njini kéé ngê. ");
INSERT INTO yle_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Yesu ngê p꞉uu ndiye pyu yoo a danê ngê, yepê, Ndêndê ngê kî kuknwe ngê ndapî ndîî yi kéé, ndáápi knî y꞉oo têdê yi kéé ngmê, mu kópu u dîy꞉o yi yéli yi ngópu ndapî ndîî ye tóó, têdê yi kéé ngmê, yepê, kî kuknwe u ngópu ndapî n꞉ii kmono dê tóó mo, vyîlo dê yi kéé dê, u ngópu mêdêdêmu tóó. ");
INSERT INTO yle_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu, p꞉uu ndiye pyu yoo yi k꞉ii, Chóó Lémi u ngomo dini ghi n꞉ii ngê dnya a kuwokuwo, ngmê ngê kwo, Mââwe. Kwo, Kî lóntoo chêêpî dé, kî ngomo u ngwo kî wó tumo. ");
INSERT INTO yle_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu ngê kwo, Kî ngomo pââ ndîî chi m꞉uu té? Kwo, Mu dini ghi ngê chedê ngê wa pyaa dmi. Kwo, Chêêpî pywápê ngmê n꞉ii ngê kî ngomo a wuwó tumo, mu dini ghi ngê numo u pwo u pwo daangmadî ya. Kwo, Kn꞉aa lede knî y꞉oo kî ngomo pê yintómu wa pwaa t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu, p꞉uu ndiye pyu yoo yi k꞉ii, Njedusalem a kuwo ngópu, mbwaa tp꞉oo ngmê ngmêê ngópu, mbwini n꞉ii u pi Olipi, yi mbwini mbêmê mî kee dniye, y꞉i dnyen꞉aa ya. Yesu ka p꞉uu ndiye pyu páádi loo, yi pi dmi Pita mbwémi Andru, Njems mbwémi Njon. ");
INSERT INTO yle_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Yesu ka kwo, Mââwe. Kwo, Chóó Lémi u ngomo ngî mwini. Kwo, Ló dini ghi ngê wa a pw꞉oo ngmê? Kwo, Ló kópu ngmanmî ny꞉oo, nmî lama u ngwo wa yââ, nê, Yi kópu daa kêmakêma a pyodopyodo? ");
INSERT INTO yle_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu ngê yepê, Nmye mb꞉aamb꞉aa ngê dmyina a vyuwo, pi ngmê ngê kîngî dóó nmyo. ");
INSERT INTO yle_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yepê, Pi yilî wa a lê, u yi y꞉e adî kwo, Nê u d꞉aa nmo kââdî, nmyewo, Ala nê vyîlo. Yepê, Pi yilî yinté wa dóó t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yepê, Dini ghi n꞉ii ngê l꞉êê pââ ndîî u pi ngmanmyi ny꞉ee ngmê, ó nmyi nkîgh꞉ê amyidnyi l꞉êê, yepê, nkîngê ngê kêê nangê t꞉oo. Yepê, Yi kópu daawa têda dmi, ngmênê nangê vyi, Ala d꞉o kuwókuwó dini ghi. ");
INSERT INTO yle_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yepê, Kn꞉aa dyámê tpémi kn꞉aa dyámê tpémi yi p꞉uu adnyi l꞉êê, yepê, dyámê pee knî ngmê wadî ghêdê, pi yilî wa pw꞉oo dmi, daa ng꞉êêntómu m꞉uu wa ghîdî, yoo adnyi dómudómu, amyidnyi pwopwo. Yepê, K꞉omo tpile yinté kópu yilî yi pi dmi wanmyi ny꞉ee ngmê, ngmênê nangê vyi, Ala d꞉o dyámê pê dpî chedê. Yepê, Yi kópu yilî têdê dé, ngmênê dono kópu ndîî dé dîyo kuwó wa pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yepê, Nmye mb꞉aamb꞉aa ngê dmyina a vyuwo. Yepê, Dye ghi knî ngmê ngê pi dono knî y꞉oo u yi y꞉e adî kwo, Nê u yoo nmî chedê. Yepê, Yi ngwo a l꞉êê dîy꞉o nmyi p꞉uu adnyi d꞉uu. Yepê, Ngêpê ngomo knî yi y꞉enê pyu knî y꞉oo adnyin꞉aa mgîmîmgîmî nmyo, adnyin꞉aa kóté kîgha nmyo, u nkwo adnyin꞉aa kpakakpaka nmyo. Yepê, A l꞉êê dîy꞉o king knî y꞉oo, kada pini knî y꞉oo amyidnyin꞉a kóté kîgha nmyo. Yepê, A p꞉uu ye anmyin꞉aa danê. ");
INSERT INTO yle_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yepê, A kópu mb꞉aa pi yilî yintómu knî y꞉oo mwiyé dpî ny꞉ee y꞉e, u kuwó dini ghi ngê dyámê pê chedê ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yepê, Dini ghi n꞉ii ngê adnyin꞉aa mgîmîmgîmî nmyo, kópuni ye anmyin꞉aa tpapê dé, yi kópu knî yi p꞉uu nuw꞉o ngê kêê nangê t꞉oo. Yepê, Dini ghi n꞉ii ngê adnyin꞉aa kóté kîgha nmyo, kópuni Chóó Lémi u Ghê Dmi ngê nmye choo tpapê, yi kópu kada pini knî ye dmyinê tpapê. Yepê, Daa nmyi chóó nmyi kópu ayinmyin꞉aa tpapê dé, ngmênê Chóó Lémi u Ghê Dmi u kópu ayinmyin꞉aa tpapê dé. ");
INSERT INTO yle_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Yepê, Dini ghi n꞉ii ngê a yoo adnyi vyee dé, pi knî y꞉oo yi chóó yi mbwó yoo wa ch꞉ee t꞉oo, mââ knî y꞉oo yinté yi tp꞉ee yoo amye ch꞉ee t꞉oo, pi knî y꞉oo yinté yi chóó yi pye mî yoo amye ch꞉ee t꞉oo, kada pini knî y꞉oo wamye vya t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yepê, A l꞉êê dîy꞉o pi yintómu knî ye wanmyi diya dmi, ngmênê n꞉ii knî y꞉oo myedaawa mb꞉ii nê, mu dini ghi ngê M꞉aa kóó k꞉oo wan꞉uu kaa té. ");
INSERT INTO yle_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu ngê yepê, Njuda Wee u kwo yélini adnyi ya, tpile dyede u tpile dono doo u kwo têdê angmê m꞉uu ngmê. (Pini n꞉ii ngê ala puku choo a kpââ, yi kópu mb꞉aamb꞉aa ngê choo a wopwe.) Yepê, Yi tpile dono dini ghi n꞉ii ngê wa t꞉aa, Njuda Wee u kwo yélini adnyi ya, dpî mbêpê dniye, mbu knî yi vyuwo dp꞉uu mbwolo dniye. ");
INSERT INTO yle_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pini n꞉ii u ngomo maknopwo adî ya, lîmîlîmî ngê dpî mbêpê we, u ngomo k꞉oo mêkîngî kee, u tpile kîdangmên꞉aa ngî. ");
INSERT INTO yle_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yepê, Pini n꞉ii yâpwo têdê adîn꞉aa dpodo, u p꞉o mêkîngî diyé, u tpile kîngmê nya, lîmîlîmî ngê dpî mbêpê we, mbu mbêmê dp꞉uu mbwolo we. ");
INSERT INTO yle_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Yepê, Dini ghi n꞉ii ngê yi kópu wa pyódu, mbwili knî y꞉oo dpodo ndîî wa a pyw꞉ee ngmê, p꞉aa knî y꞉oo dpodo ndîî amyedê pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yepê, Chóó Lémi ka dny꞉oo ngêpê, Tpii yópu yi dye ghi ngê daapîdny꞉oo mbêpê. ");
INSERT INTO yle_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yepê, Yi dini ghi ngê Nju tpémi y꞉oo dono ndîî wa a pyw꞉ee ngmê. Yepê, Dono kópuni pi knî y꞉oo wunê a pyw꞉ee tumo, yini têdê dé, kn꞉ââ Chóó Lémi ngê dyámê pê mwo a l꞉âmo ngê, u dî ala ngwo. Yepê, Yi dono ndîî u kuwó dini ghi ngê, yintoo dono daamuwa a pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yepê, Chóó Lémi ngê yinê a vyu, apê, Yélini nê ngmidi ngê yi l꞉êê dîy꞉o, yi yéli yi pw꞉oopw꞉oo u dye ghi dêêkwédi ngê wanî pyódu. Yepê, Wodaa vyu, ye pi yintómu pî pw꞉oo dniye. ");
INSERT INTO yle_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Yepê, Yi dini ghi ngê, yepê, pini n꞉ii ngê nmye wa vyi, nmyewo, Chóó Lémi ngê n꞉ii a ngmidi ngê vyîlo ka kwo, yepê, yi pini ka kîdmyongê kêlîmî mbê dmi. ");
INSERT INTO yle_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yepê, Pi yilî knî y꞉oo kêêmî wa kaa t꞉oo, pi knî ye wadnyi k꞉omodanê, yewo, Chóó Lémi ngê a ngmidi noo. Yepê, Pi knî y꞉oo yoo wamye dóó ngmê, Chóó Lémi u komo k꞉omodanê ngê wa kaa ngmê. Yepê, Yi pini knî y꞉oo mbwudu yilî wa chaa ngmê, mu kópu u dîy꞉o u yi y꞉e adî kwo, Chóó Lémi ngê yélini a ngmidi ngê, nmî dóó té. ");
INSERT INTO yle_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yepê, Yi k꞉omodanê pyu knî y꞉oo kîngî dóó nmyo. Yepê, Kópuni wa pyaa dmi, ala yi kópu knî yi p꞉uu nmyi ng꞉aa dmi yidî t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Yesu ngê yepê, Yi dye ghi dono u kuwó dini ghi ngê, d꞉ââ kââdî wa mgêdê knî, mêdaadpî pil꞉apil꞉a, pudu yilî yintómu wa a ghay dmi, Chóó Lémi ngê mbóó p꞉uu tpile dé yi dînê dmi wa ghêê té. ");
INSERT INTO yle_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yepê, U kuwó dini ghi ngê pi knî y꞉oo wa m꞉uu nê, wamye mya nê, awo, Chóó Lémi u Pi Ndêndê kîyedê pwiyé knî, u pi ndîî ngê dê pyódu, u wêdêwêdê ndîî ngê myaa pyódu, nkalî too pee dmi mbêmê ka kwo. ");
INSERT INTO yle_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yepê, Enjel yoo wanê dy꞉ââ té, dyámê mbêmê ghi yintómu y꞉i wa lee dmi, Chóó Lémi ngê yélini a ngmidi ngê wa danê t꞉oo, y꞉i ye anîn꞉aa vyuwo. ");
INSERT INTO yle_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesu ngê p꞉uu ndiye pyu knî ye mgongo ngmê kwólu. Yepê, Dini ghi n꞉ii ngê kpêdê vyi dpî ghê, nmyi lama u ngwo dpî yââ, nmyimo, Daa kêmakêma nt꞉eemi wunê mbumu. ");
INSERT INTO yle_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yepê, Kpêdê ngê ntee nmye dpî vyi, Daa kêmakêma nt꞉eemi wunê mbumu, yepê, kópuni p꞉uu nmye nî danê, dini ghi n꞉ii ngê yi kópu wanmyi m꞉uu t꞉oo, yinté nmyi lama u ngwo wa yââ, anye, Yi kópu daa kêmakêma a pyodopyodo. ");
INSERT INTO yle_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Yélini ala ngwo a pyede, ghêlî daawa pw꞉oo dmi, Njedusalem p꞉uu kópuni nmye dî vyi, yi kópu mwiyé wa pyódu. ");
INSERT INTO yle_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yepê, Mbóó dyámê chedê ngê wa pyaa knî, ngmênê a kópu dyuu chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesu ngê yepê, Wéni n꞉ii ngê dyámê mbêmê amênê diyé, yi wéni pi u lama daa tóó. Yepê, Enjel yoo yi lama myedaa tóó. Yepê, K꞉omo tpile nê Chóó Lémi tp꞉oo, a lama myedaa tóó. Yepê, Ngmênê M꞉aa mu ngmidi u lama a tóó. ");
INSERT INTO yle_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yepê, Mb꞉aamb꞉aa ngê dmyinê t꞉ââ, mu kópu u dîy꞉o wéni n꞉ii ngê yi kópu wa pyódu, nmyi lama daa tóó. ");
INSERT INTO yle_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yepê, Alanté adî ya. Yepê, Mââwe ndîî kn꞉aa p꞉aani angmê lê, u dpodo pyu yoo wa a kuwo té, yi dpodo ńedê dpodo ńedê wa kaa té, ngomo y꞉enê pyu ka wa vyi, kwowo, Chi t꞉âât꞉ââ nê. ");
INSERT INTO yle_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yepê, Dmyinê t꞉ââ, mu kópu u dîy꞉o nmyi mââwe ndîî wéni n꞉ii ngê wa t꞉aa, nmyi lama daadî ya. Yepê, Apê ntumokwodo wa t꞉aa, apê mgîdî vy꞉o wa t꞉aa, apê mw꞉aamw꞉aa wa t꞉aa, apê mw꞉aandiye wa t꞉aa. ");
INSERT INTO yle_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yepê, Tumutumu wa a lê, dpî têdê kîngmê m꞉uu nmyo. ");
INSERT INTO yle_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yepê, Kópuni nmye dî vyi, pi yilî yintómu yi l꞉êê dîy꞉o n꞉aa tpapê, yepê, dmyinê t꞉ââ. ");
INSERT INTO yle_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nju tpémi y꞉oo yi naa ndîî dê daa kêmakêma dnye kuwo dê. Yi nááli dê yi pi dê Tp꞉ee Kaa W꞉êêw꞉êê u Naa, Mbîdédi Pywápê Ngmê u Naa. Dêêpî pyu knî ngmê, kpêê yiyé pyu yoo yi kada pini yoo yi k꞉ii Yesu u pwele yi ngwo a châpwo ngópu. ");
INSERT INTO yle_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Noko yepê, Naa ndîî m꞉ii. Noko yepê, Yi kópu naa kpo nakî d꞉uu. Noko yepê, Pi yilî kêdê t꞉aa, wa gheteghete mbê dmi. ");
INSERT INTO yle_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu Petani doon꞉aa ya, Saimon u ngomo k꞉oo doon꞉aa kmaapî. Yi pini p꞉uu too pee mbii leprîsi mwiyé doo ya. Yi kmaapî têdê pyââ ngmê ngê pód꞉a ngma a ńuwo, tuu mb꞉aamb꞉aa. Yi tpile u pywuu ndîî, u pi naadî, tód꞉o ntee tpile, tuu mb꞉aamb꞉aa. Yi pyópu ngê yi pód꞉a komo puwâ, naadî Yesu mbêmê d꞉ud꞉umbiy꞉e a chedê ngê. ");
INSERT INTO yle_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yélini y꞉oo yi kópu m꞉uu ngópu, woni yoo nod꞉e dniye, noko yepê, Kî pyópu ngê lukwe dîy꞉o kî kópu dê d꞉uu? Apê, Naadî lukwe dîy꞉o dê dyênê? ");
INSERT INTO yle_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Apê, Kî pyópu ngê nmo woda kê, ye ndapî pyolo yono y꞉a pudu kmênê, yi ndapî ndîî pinté knî ye pudu y꞉oo. Wod꞉oo yi yéli yi pyópu ka a tpêpwo dniye. ");
INSERT INTO yle_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu ngê yepê, U kwo namê mbumu. Yepê, Lukwe dîy꞉o dmye mywenemywene kalê ngmê. Yepê, A nuu u kópu a nga yi d꞉uu. ");
INSERT INTO yle_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yepê, Dye ghi yintómu u ntââ pinté yoo anmya a pyw꞉êmî dé. Yepê, Dini ghi n꞉ii ngê u yi nmye adî kwo, Nmî ngee té, yepê, u ngwo dmyinê ngêêpî dé. Yepê, Mu dini ghi ngê nmyi vy꞉o mêdaanî kwo. ");
INSERT INTO yle_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yepê, Kî pyópu ngê u ntââ kópu a nga yi d꞉uu. Yepê, Dini ghi n꞉ii ngê anî pw꞉onu, wa kmênê nê. Yepê, Yi kópu u l꞉êê dîy꞉o, tpileni pi ntóó p꞉uu anyi d꞉ii, kî pyópu ngê a p꞉uu vyîlo yii d꞉ii. ");
INSERT INTO yle_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Pi knî y꞉oo a kópu mb꞉aa dyámê ghi knî yi mbêmê kwéli adnyin꞉aa nyêm, kî pyópu ngê kópuni a nga dê d꞉uu, amyimî ny꞉ee ngmê. Yepê, Kópuni a nga dê d꞉uu, u mgamê ngê adîn꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yesu u dyépi y꞉a mê miyó knî yi vy꞉o pi ngmêdoo kwo, u pi Njudas, Kédiyót pi. Yi Njudas kpêê yiyé pyu yoo yi kada pini knî ye loo, yepê, Yesu u vyee u yi nmye a kwo. Yepê, Kwódo ngê anî ghê. ");
INSERT INTO yle_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kada pini knî y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, yi gha dmi mb꞉aamb꞉aa ngê pyodo, Njudas ka kwo, Wanmî yi, u ye ndapî ṉga anmo kê. Wod꞉oo Njudas ngê dye ghi doo y꞉enê, apê, Yesu kwódo ngê wu dini ghi ngê anî ghê. ");
INSERT INTO yle_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wéni n꞉ii ngê Mbîdédi Pywápê Ngmê u Naa dnyimo kuwo, Nju tpémi y꞉oo sipi tp꞉oo u ngwo dnyimo vyee dé, Tp꞉ee Kaa W꞉êêw꞉êê u Naa nté u ngwo dnyimo l꞉âmol꞉âmo. Yi wéni ngê Yesu p꞉uu ndiye pyu yoo Yesu ka póó dniye, kwo, Mââwe. Kwo, Tp꞉ee Kaa W꞉êêw꞉êê u nté ló y꞉i nmîmo l꞉âmol꞉âmo? ");
INSERT INTO yle_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu ngê pi miyó dy꞉ââ ngê, yepê, Njedusalem choo lêpî, pi ngmê ngê maa p꞉uu wunê pyépi dp꞉o, yi pini nkono mbwaa d꞉umu ngmêdpo mumu ngmê. ");
INSERT INTO yle_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yepê, U ngomo k꞉oo dpî ngm꞉êê nyoo, ngomo chóó ka dp꞉uu póó cho, kwipi, Nyi mââwe ngê atédê dy꞉ââ nyo, ada, Naa u nté ló ngomo ghi k꞉oo wanm꞉uu ma, a p꞉uu ndiye pyu knî yi k꞉ii? ");
INSERT INTO yle_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yepê, Yi ngomo chóó ngê podo ngomo ghi ndîî dpo ngmêwunê kêmakêma, yepê, nmî ntââ tpile yilî yintómu y꞉i a tóó. Yepê, Nmî naa nté y꞉i dp꞉uu l꞉âmo nyoo. ");
INSERT INTO yle_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wod꞉oo p꞉uu ndiye pyu dê y꞉oo kada a y꞉ee ngópu, Njedusalem lee knopwo, kópuni Yesu ngê ye vyu, yi tpile yilî mî m꞉uu ngópu, yi nááli u nté yi ngomo k꞉oo adî l꞉âmo ngmê. ");
INSERT INTO yle_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kââdî dini ghi n꞉ii ngê gho, Yesu p꞉uu ndiye pyu y꞉a mê miyó knî yi k꞉ii yi ngomo ghi k꞉oo mî kee dniye, nté kwéli a l꞉âmo ngópu. ");
INSERT INTO yle_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dini ghi n꞉ii ngê dnye kmaapî, Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê, yepê, k꞉omo tpile nipi nmo kmaapî té, ngmênê nmyi vy꞉o pini ngmê daa kêmakêma a kwódo ngê a wowo. ");
INSERT INTO yle_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","P꞉uu ndiye pyu yoo yi nuw꞉o dmi dono ngê pyodo, ngmêngmênté u kwo doo póó, kópu, Nê kuu, apii? ");
INSERT INTO yle_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu ngê yepê, Ye y꞉a mê miyó anmyi tóó, yepê, k꞉omo tpile d꞉ââ mu ngmidi k꞉oo mbîdédi n꞉êê nmo kmênêkmênê té, ngmênê nmyi vy꞉o pini ngmê a kwódo ngê a wowo. ");
INSERT INTO yle_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yepê, Ala kópu puku yedê ló dini mwo a d꞉êê ngópu, apê, Chóó Lémi u Pi Ndêndê u kwódo ngê pi angmê ghê, pi knî y꞉oo wa mgîmî ngmê, wa kpaka ngmê, wa vya ngmê. Yepê, Pini n꞉ii ngê yi kópu a ntiyentiye, a kwódo ngê a wowo, yi pini d꞉ud꞉umbiy꞉e choo nkîngê, Chóó Lémi ngê dpodombiy꞉e wa kpada. Yepê, Yi pini ngê u kpadakpada têdê ala kópu wamî vyi, awo, L꞉omo m꞉aa ta, yi dono daap꞉aa d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dini ghi n꞉ii ngê dnye kmaapî, Yesu ngê mbîdédi a ngêêdî, Chóó Lémi kwuno ngê, puwâ, p꞉uu ndiye pyu knî ye y꞉ângo, yepê, Ala a chóóchóó, nê. ");
INSERT INTO yle_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","U kuwó dini ghi ngê kapî a y꞉ângo, wain k꞉oo a pii ngê, kumu mbee ngê, Chóó Lémi kwuno ngê, p꞉uu ndiye pyu knî ye mye y꞉ângo, yintómu nda ngópu. ");
INSERT INTO yle_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu ngê yepê, Ala a wêê. Yepê, Pi yilî yi l꞉êê dîy꞉o wêê a p꞉uu wa pwii. Yepê, Yi wêê ngê Chóó Lémi ka pi yilî wa a kââdî. ");
INSERT INTO yle_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yepê, Ala kópu ny꞉ee yó. Yepê, Wain daamunî nda, u dî wéni n꞉ii ngê a pi ndîî ngê amî pyódu, pi yintómu anî y꞉enê, Chóó Lémi kóó k꞉oo kmaapî ndîî u ngwo anm꞉uu dóó, wain kamî u ngwo anm꞉uu nda. ");
INSERT INTO yle_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","U kuwó dini ghi ngê wéti ngma a ngî ngópu, Njedusalem a kuwo ngópu, mbu mbêmê mî kee dniye, mbwini n꞉ii u pi Olipi. ");
INSERT INTO yle_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ngê yepê, Dini ghi n꞉ii ngê pi knî y꞉oo a mgîmîmgîmî nê, nmyinê kuwokuwo nê, nmye mbêpêmbêpê té. Yepê, Puku yedê alanté a tóó, Dini ghi n꞉ii ngê Chóó Lémi ngê sipi y꞉enê pyu wa vy꞉a, sipi w꞉uu wa mbêpê dmi. ");
INSERT INTO yle_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yesu ngê yepê, Dini ghi n꞉ii ngê amênî pyidu, nmyi kada anî ghê, Nkálili anî lê. ");
INSERT INTO yle_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita ngê kwo, K꞉omo tpile kî tpóknî y꞉oo wunê kuwokuwo ngi, kwo, nê mu ngmidi daanê kuwo ngi. ");
INSERT INTO yle_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu ngê Pita ka kwo, Ndê kópu ṉga ngmên꞉aa tpapê. Kwo, Mgîdî vy꞉o kêmkêm ghêlî k꞉ii my꞉oo daawa kââ, pyolo nyinê wópuwópu nê, pi knî ye ala kópu nye tpapê, yenye, D꞉aa p꞉uu dniye pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita ngê kwo, A Lémi. Kwo, Yi kópu daanî d꞉uu. Kwo, K꞉omo tpile ḻ꞉êê dîy꞉o amye vya nê, myedaanê wópu ngi. Yesu p꞉uu ndiye pyu knî y꞉oo Yesu ka yinté mye vyi ngópu. ");
INSERT INTO yle_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kwéli lee dniye, yi kêlê ghi u pi Nketsemane. Yesu ngê p꞉uu ndiye pyu knî ye yepê, Al꞉ii dmyinê ya, nîmo ngêpê. ");
INSERT INTO yle_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesu ngê pi pyile ngmidi ngê, Pita ngmê, Njems myomo, Njon pyolo, yi k꞉ii lee dniye. Yesu nkîngê mbê wo, u ghê a kee wo. ");
INSERT INTO yle_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yi pini pyile knî ye yepê, A nuw꞉o dono ngê ayi chedêchedê nê. Yepê, Al꞉ii dmyinê ya, dpî ngê kêê nangê t꞉oo, dmyinê t꞉âât꞉ââ nê, a l꞉êê dîy꞉o myedmyinê ngêpê. ");
INSERT INTO yle_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesu ngê a kuwo too, pee tp꞉oo mwada y꞉i loo, têpê mbêmê mî dyimê wo, u mî ka doo ngêpê, kwo, M꞉aa. Kwo, U ntââ ala dono kópu daanê pyw꞉oo? ");
INSERT INTO yle_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kwo, Tpile yilî yintómu ṉga u ntââ. Kwo, U ntââ ala dono u mbwaa daanî nda? Kwo, Ngmênê ṉgwépi daanî puwâ. Kwo, K꞉omo tpile ala kópu u ya a nga daa kwo, ngmênê a nga dpî d꞉uu ngi, mu kópu u dîy꞉o a kada nye tóó. ");
INSERT INTO yle_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","U kuwó dini ghi ngê Yesu yedê diyé wo, apê, A p꞉uu ndiye pyu yoo mu dpî té. Yesu ngê Pita ka kwo, Saimon. Kwo, Lukwe dîy꞉o nye dpî? Kwo, D꞉ee ngêpê. Kwo, Lukwe dîy꞉o doo u ntââ, dye ghi dêêkwédi ntênê daanyi ya? ");
INSERT INTO yle_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yesu ngê yepê, Mb꞉aamb꞉aa ngê dmyinê vyuwo, dpodombiy꞉e dmyinê ngêpê, pi ngê dpodombiy꞉e kêdangê tókó nmyo, dono nmye daapêdê nî we. Yepê, K꞉omo tpile kópu mb꞉aa wanmyi vyi t꞉oo, ngmênê nmyi tókótókó têdê wanmyi dêê dmi. ");
INSERT INTO yle_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Myombó Yesu ngêpê têdê mê loo, mwiyémwiyé ntee doon꞉aa ngêpê, yinté modoon꞉aa ngêpê. ");
INSERT INTO yle_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","U kuwó dini ghi ngê p꞉uu ndiye pyu pyile knî ye mê diyé wo, apê, Mu dpî té. Dpî vyîlê ngê dyaa ye chedê ngê. Yesu dini ghi n꞉ii ngê m꞉uu ngópu, mywene ye ghê wo, kópu u kwo daa vyi ngópu. ");
INSERT INTO yle_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pyolombó Yesu modon꞉aa ngêpê, p꞉uu ndiye pyu knî ye yedê diyé wo, yepê, Mwo anmyi dpî té? Yepê, Angênté, dmyongê nyaa dniye? Yepê, Munto. Yepê, Ala u dye ghi. Yepê, Pi dono knî y꞉oo ala ngwo a mgîmîmgîmî nê. ");
INSERT INTO yle_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yepê, A pii dmyeno. Yepê, Paa ala. Yepê, Óó! Yepê, A kwódo ngê pini n꞉ii dê ghê, yepê, ka pwiyé knî. ");
INSERT INTO yle_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ngê danêmbum ghêlî daa chedê ngê, wod꞉oo lede yoo taa dniye, Njudas yi kada doo kwo, pini n꞉ii Yesu p꞉uu ndiye pyu y꞉a mê miyó knî yi vy꞉o pwii wo, Yesu yinê dóó. Yi lede knî y꞉oo kaa taa ńuw꞉o tumo. Yi yéli Nju tpémi yi kada pini knî y꞉oo dy꞉ââ tumo, yepê, Yesu nyinê mgîmî yó. ");
INSERT INTO yle_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Maa p꞉uu Njudas ngê yepê, Pini n꞉ii nînê chipéchipé, yepê, yi pini yi vyîlo. Yepê, Dpî mgîmî yó, nmî kada pini knî ye dpî ńuw꞉o yó. ");
INSERT INTO yle_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dini ghi n꞉ii ngê taa dniye, Njudas Yesu ka loo, kwo, Mââwe. Njudas ngê Nju tpémi yi chipéchipé ngê Yesu u ngwo a chipé ngê, ń꞉uu Yesu kpââ pee p꞉uu dyîngo. ");
INSERT INTO yle_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wod꞉oo lede knî y꞉oo Yesu dpodombiy꞉e mgîmî ngópu. ");
INSERT INTO yle_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yesu p꞉uu ndiye pyu ngmê ngê u yi doo kwo, Lede yoo nî vya té, wod꞉oo u taa a ngêêdî, lede ngmê mbwámê pêdê châpwo, ngmênê kn꞉aadi ngê, ngwene ngmê ngópu. Yi lede kpêê yiyé pyu yoo yi kada pini u dpodo pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu ngê yi lede knî ye yepê, D꞉aa l꞉êê pyu ngmê. Yepê, Lukwe dîy꞉o kaa taa kêlê a ka dmyinê lee dmi. ");
INSERT INTO yle_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yepê, Wo yilî yi k꞉oo Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo nmyi vy꞉o kînoo a kwo, y꞉i nîmon꞉aa dêêpî. Yepê, Lukwe dîy꞉o y꞉i dpîp꞉e mgîmî noo. Yepê, Kópuni puku yedê a tóó, awêde até dmye ntiye ngmê. ");
INSERT INTO yle_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wod꞉oo Yesu p꞉uu ndiye pyu knî y꞉oo Yesu a kuwo ngópu, mbêpê dniye. ");
INSERT INTO yle_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","U kuwó dini ghi ngê pi mgêmî ngmê ngê Yesu u yâmuyâmu kn꞉ââ chópu. Lede knî y꞉oo apê, My꞉oo mgîmî. ");
INSERT INTO yle_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Yi pini u kpîdî ngê kaa dniye, mbêpê dini ghi n꞉ii ngê a puwâ, u kpîdî yi kêê yedê a kuwo ngê, wod꞉oo kn꞉ââ mbwii mbêpê wo. ");
INSERT INTO yle_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesu dini ghi n꞉ii ngê mgîmî ngópu, kpêê yiyé pyu yoo yi kada pini ndîî u ngomo k꞉oo ńuw꞉o ngópu. Yi ngomo k꞉oo Nju tpémi yi kada pini yoo nipi lee dniye, dêêpî pyu yoo, kpêê yiyé pyu yoo yi kada pini yoo mye yi k꞉ii. ");
INSERT INTO yle_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ngê Yesu doo yâmuyâmu, tumutumu yi kuwó doo a kwo, daa chono doo a paa. Dini ghi n꞉ii ngê Yesu ngomo k꞉oo mî kee wo, Pita yi ngomo mbwa kalê ngmê k꞉oo myimî kee wo, ndoo chedê yaa wo, lede knî yi k꞉ii dnye ndê vyîlî. ");
INSERT INTO yle_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Yi ngomo k꞉oo Nju tpémi yi kada pini knî y꞉oo Yesu dnyen꞉aa kóté kîgha. U yi y꞉e doo kwo, Yesu kn꞉ââ nmî ché, u ngwo nmî vy꞉a. Pi yilî knî y꞉oo yi chóó yi yipe tee kópu Yesu p꞉uu yilî t꞉ee ngópu, ngmênê pi miyó dê y꞉oo yi kópu ngmidi ngê daa pyódu ngópu, yi kópu u l꞉êê dîy꞉o Nju tpémi ye doo u ntââ ngê pyodo, Yesu daapî ndyîko ngópu. ");
INSERT INTO yle_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","U kuwó dini ghi ngê pi knî ngmê ghêêdî wo, k꞉omo ngê yepê, Kî pini ngê ala kópu mwo a vyu, nmopê, Chóó Lémi u ngomo anê pw꞉ono, pi knî y꞉oo n꞉ii wó ngópu, wo pyile amî lê, kamîni m꞉uu anî wó, daa pi ngê kîlî wa wó. ");
INSERT INTO yle_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Daa ngmidi mbêmê dnye danê, yi kópu u mo u mo dé, wod꞉oo kada pini knî y꞉oo noko yepê, Ka k꞉omodanê té. ");
INSERT INTO yle_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","U kuwó dini ghi ngê kpêê yiyé pyu yoo yi kada pini ndîî ghêêdî wo, Yesu ka póó wo, kwo, Kópuni m̱꞉uu dê vyi ngmê, daanyinê vy꞉a? ");
INSERT INTO yle_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngmênê Yesu tumu doo ya, kópu myedaa vyu. Yi pini myombó u kwo mê póó wo, kwo, Ndêndê ngê Chóó Lémi ngê a ngmidi nyoo? Kwo, Mumdoo nyi Tp꞉oo? ");
INSERT INTO yle_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu ngê kwo, Nyââ. Kwo, Mu dini ghi ngê wanmyi m꞉uu nê, wanmyi vyi ngmê, anye, Kî Chóó Lémi u Pi Ndêndê. Anye, U pi ndîî ngê dê pyódu, Chóó Lémi u che p꞉ââ pee ngê dê pyódu, nkalî too pee dmi mbêmê muyedê pwiyé knî. ");
INSERT INTO yle_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yesu ngê yi kópu dini ghi n꞉ii ngê u kwo vyu, kpêê yiyé pyu yoo yi kada pini ngê chóó u mbwo kpîdî a chópu, yi mââwe knî ye yepê, Kî pini u châpwo pyu u yi nmo daamu a kwo. Yepê, Chóóchóó kêdê ndyîko. ");
INSERT INTO yle_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yepê, Ala kópu nmo dê vyi, Chóó Lémi u d꞉aa anê kââdî. Yepê, Nmyi nuw꞉o dmi angênté a tóó? Kada pini yintómu knî y꞉oo kwo, Chóó u pye dê yé. Kwo, Vya koo, pw꞉oo we, daadî ya. ");
INSERT INTO yle_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Knî ngmê Yesu p꞉uu dnye tpyîpwi. U kuwó dini ghi ngê Yesu ngwolo dê kpîdî pee ngê wópu dumo, u nkwo dnye vyee, kópu, N꞉aa dê vya ngi? Kópu, Chi dîpî. Kópu, W꞉ii Chóó Lémi u komo kapî pyu ngmê, pini n꞉ii ngê dê vya ngi, u pi nmo pîchi vyi. U kuwó dini ghi ngê lede knî ye Yesu y꞉ee ngópu, wod꞉oo dnye kpakakpaka. ");
INSERT INTO yle_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Dini ghi n꞉ii ngê Yesu dnye kóté kîgha, yi dini ghi ngê Pita yi ngomo mbwa kalê ngmê k꞉oo doo ya. Kpêê yiyé pyu yoo yi kada pini ndîî u dpodo módó ngma a loo. ");
INSERT INTO yle_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita dini ghi n꞉ii ngê ndê vyîlî têdê módu, doo myeme, kwo, Nyi ngmê, Yesu Nasalet pi p꞉uu nye ya yédi, apii? ");
INSERT INTO yle_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngmênê Pita ngê u kwo a wópu ngê, kwo, Ye kópu a lama daa tóó, myed꞉oongê w꞉ee ngê. Wod꞉oo Pita pywuwópywuwó têdê u nkîgh꞉ê doon꞉aa kwo, kêmkêm u ngwo ka wo. ");
INSERT INTO yle_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yélini y꞉i doo kwo, yi pyópu ngê yepê, Kî pini Yesu p꞉uu ndiye pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita ngê mêdê wópu ngê. Daa ndîî dye ghi yimî loo, yi yéli y꞉oo Pita ka kwo, Nye k꞉omodanê. Kwo, Nyi yi pini p꞉uu ndiye pyu ngmê. Kwo, Dpî wee mu ngmidi, Nkálili Wee. ");
INSERT INTO yle_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wod꞉oo Pita ye kpaa wo, yepê, Pini n꞉ii u pi a ka nmye tpapê ngmê, yepê, yi pini daa a lama pini. ");
INSERT INTO yle_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Vyîlo yi dini ghi ngê kêmkêm my꞉oo ka wo, wod꞉oo Pita ngê Yesu u kópu mî nuw꞉o kwólu, apê, Yesu ngê a ka moda vyi, Kêmkêm ghêlî k꞉ii my꞉oo daawa kââ, pyolo nyinê wópuwópu nê. Wod꞉oo Pita ngê mbê a puwâ. ");
INSERT INTO yle_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mw꞉aa mgîdî vy꞉o Nju tpémi yi kada pini yoo nipi dnyen꞉aa danêmbum, kpêê yiyé pyu yoo yi kada pini yoo, dêêpî pyu yoo mye yi k꞉ii. Yi danêmbum têdê Yesu u vyee u dy꞉oo a châpwo ngópu. U kuwó dini ghi ngê Yesu kóó dê kudu dumo, Lóma lede yoo yi mââwe ndîî Paléti ka ńuw꞉o ngópu. ");
INSERT INTO yle_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paléti u kwo póó wo, kwo, Mumdoo nyi Nju tpémi yi king? Yesu ngê kwo, Ṉ́yóó kîchi vyi. ");
INSERT INTO yle_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Kpêê yiyé pyu yoo yi kada pini knî y꞉oo Yesu p꞉uu yipe tee kópu yilî t꞉ee ngópu, wod꞉oo Paléti u kwo mê póó wo, kwo, Angênté, yi kópu yilî daanyinê vy꞉a? Kwo, Kêêmî m̱꞉uu yilî kînga dê kaa ngmê. ");
INSERT INTO yle_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngmênê Yesu ngê kópu daa vyu, Paléti ngê apê, Kî lónté pini? Apê, Lukwe dîy꞉o kópu daawa vyi? ");
INSERT INTO yle_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","M꞉ââ k꞉oo Nju tpémi yi naa ndîî u dye ghi ngê, yélini mbwa k꞉oo dnyimo kwo, Paléti ngê ngmêdpîmo pw꞉iipw꞉ii, apu, Nju tpémi yi nuw꞉o dmi mb꞉aamb꞉aa ngê paa pyaa we. Pini n꞉ii u pi pi knî y꞉oo u kwo dnyimo tpapê, yini yidpîmo pw꞉iipw꞉ii. ");
INSERT INTO yle_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yi m꞉aani ngê mbwa u mênê pi ngmêdoo kwo, u pi Mbadapas. Yi pini ngê u yi doo a kwo, Lóma lede yoo nmî ngm꞉ii kalê té. U yoo yi kada mwiyé a ghê wo, Lóma lede woni a vya tumo, u l꞉êê dîy꞉o u yoo knî yi k꞉ii mbwa k꞉oo u ngwo kee dniye. ");
INSERT INTO yle_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dini ghi n꞉ii ngê Tp꞉ee Kaa W꞉êêw꞉êê u Wo dyimê wo, pi yilî Paléti ka lee dniye, kwo, Kópuni nye d꞉uud꞉uu ngê, ala ngwo yinté mê d꞉uu ngi, kwo, mbwa k꞉oo pi ngmê pw꞉ii ngi. ");
INSERT INTO yle_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Wod꞉oo Paléti ye póó wo, yepê, Nju tpémi. Yepê, U yi nmye a kwo, nmyi king anî pw꞉ii? ");
INSERT INTO yle_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paléti ngê yi kópu ye poo ngê, mu kópu u dîy꞉o u lama doo ya, apê, Kpêê yiyé pyu yoo yi kada pini knî y꞉oo Yesu ka ń꞉ee dê kaa ngmê, a kêê k꞉oo u l꞉êê dîy꞉o dê kaa ngmê. ");
INSERT INTO yle_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kpêê yiyé pyu yoo yi kada pini knî y꞉oo yoo yi mbodo dmi vyuwo ngópu, yepê, Paléti ngê yi pini kîngê pw꞉ii, ngmênê Mbadapas yu pw꞉ii ngê. ");
INSERT INTO yle_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Paléti pi knî ye mê póó wo, yepê, Nju tpémi. Yepê, Pini n꞉ii u pi nmye tpapê ngmê, Nmî king, yepê, lukwe u ngwo ngmanî md꞉o? ");
INSERT INTO yle_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","U kwo mbwó dniye, kwo, Kîdosi ńedê t꞉ee ngi. ");
INSERT INTO yle_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Paléti ngê yepê, Doo u ntââ. Yepê, Dono kópu ndîî daangmê d꞉uu ngê. Ngmênê pi yilî yintómu Paléti ka dpodombiy꞉e mbwolo, kwo, Vya ngi. Kwo, Kîdosi ńedê t꞉ee ngi. ");
INSERT INTO yle_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paléti ngê u yi doo kwo, Yoo yi gha dmi mb꞉aamb꞉aa ngê nî pyódu, wod꞉oo Mbadapas mbwa k꞉oo pw꞉ii ngê, lede knî ye yepê, Yesu kpaka yó. Wod꞉oo yedê kpê dmi ngê kpaka ngópu. U kuwó dini ghi ngê Paléti ngê yepê, Ńuw꞉o yó, kîdosi ńedê nyi t꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lóma lede knî y꞉oo Yesu Paléti u ngomo mbwa kalê ngmê k꞉oo ńuw꞉o ngópu. Ledeni yoo dnyen꞉aa lîme, nipi a danê tumo. ");
INSERT INTO yle_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kpîdî pee king knî y꞉oo yi mbwo ntee dnyimo t꞉emî dé, yinté kpîdî u mbwo my꞉oo t꞉ee ngópu. Noko yepê, King knî yi mbêmê kîdon ntee a kwo nyédi, kî pini mbêmê yinté tpile my꞉oo kaa koo, wod꞉oo yi kóó diidii a ngî tumo, a kmongo tumo, kîdon ntee tpile u ngwo ngmê l꞉âmo ngópu, Yesu mbêmê kaa ngópu. ");
INSERT INTO yle_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","U kuwó dini ghi ngê k꞉omodanê ngê dnya a chipéchipé, kópu, Mw꞉ââkó nmî mââwe, Nju tpémi yi king. ");
INSERT INTO yle_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yimbwi mbêmê dnye kpêêpî, p꞉uu dnye tpyîpwi, yi mbodo ngê k꞉ame u kwo dnye wowo, yinté dnye nkwitinkwiti. ");
INSERT INTO yle_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","U nkwitinkwiti dini ghi n꞉ii ngê yé ngópu, kpîdî mb꞉aa n꞉ii u mbwo t꞉ee ngópu, mêdê ngee ngópu, chóó u kpîdî u mbwo mê t꞉ee ngópu, wod꞉oo ńuw꞉o ngópu, apê, Kîdosi ńedê nm꞉uu t꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Maa p꞉uu pi ngmê m꞉uu ngópu, u pi Saimon, Njedusalem doo lêpî. Lede knî y꞉oo yi pini ka dpodombiy꞉e kwo, Kî pini u kîdosi dnyinê ngi. (Yi pini Saimon, Sadéni pi, Aleksándê mbwémi Lupas yi mî.) ");
INSERT INTO yle_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesu ghi ngmê ńuw꞉o ngópu, yi ghi u pi Mbodo Dînê, Nju tpémi yi dnye ngê, Nkolkota. ");
INSERT INTO yle_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","U yi y꞉e doo kwo, Yesu ka wiwi ndîî ngê daapaa pyaa we, wod꞉oo yi komo ngmê wain d꞉ââ k꞉oo a vyilê ngópu, Yesu ka y꞉ee ngópu, ngmênê Yesu ngê wépi ye puwâ. ");
INSERT INTO yle_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yesu u mbwo kpîdî a ngee tumo, kîdosi ńedê u ngwo t꞉ee ngópu, wod꞉oo u kpîdî yêê tumo, yi kpîdî knî yi l꞉êê dîy꞉o dnye ng꞉oo, Noko yepê, Alani nanê wa a ngî, woni nanê wa a ngî? ");
INSERT INTO yle_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yesu mw꞉aandiye u kêténi pee kîdosi ńedê t꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","U pwopwo u nt꞉u kópu kîdosi ńedê u pwo mye t꞉ee ngópu, apê, Nju tpémi yi king. ");
INSERT INTO yle_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pi miyó yi wéni ngê Yesu u nkîgh꞉ê kîdosi ńedê mye t꞉ee dumo. Woni u wéni pee t꞉ee ngópu, woni u t꞉anê pee t꞉ee ngópu. Yi tpódu y꞉oo pi mwiyé dpîmo a vyee dé, yi tpile myedpîmo a t꞉âmot꞉âmo dé. ");
INSERT INTO yle_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(-) ");
INSERT INTO yle_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yélini maa p꞉uu dnye paa, dini ghi n꞉ii ngê Yesu kîdosi ńedê a m꞉uu ngópu, dnye nkwitinkwiti, kópu, Nyi lónté pini? Kópu, U yi ṉga doo kwo, Chóó Lémi u ngomo nê pw꞉ono, wo pyile amî lê, u ngwo am꞉aa wó. ");
INSERT INTO yle_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kópu, Ṉ́yóó kîdosi ńedê a ghidi, ṉ́yóóchóó mê ngee ngi. ");
INSERT INTO yle_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Dêêpî pyu yoo, kpêê yiyé pyu yoo yi kada pini yoo mye yi k꞉ii, yinté myednye nkwitinkwiti. Noko yipu, Kn꞉aa pini yoo yidoo ngêêpî dé, ngmênê doo u ntââ chóóchóó daawa ngee. ");
INSERT INTO yle_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Noko yipu, Mumdoo Chóó Lémi ngê a ngmidi ngê, nmî kada pini ngê a pyódu ngê, kîdosi ńedê chóó wunê wupwo knomomê, ye u ngwo u kwo nmo kêlîmî té. N꞉ii dê Yesu u nkîgh꞉ê kîdosi ńedê t꞉ee dumo, Yesu myedpîmo nkwitinkwiti. ");
INSERT INTO yle_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kââdî mââ kêlê dini ghi ngê, yi dyámê pee mbêmê mgîdî a ghay wo. Dini ghi n꞉ii ngê kââdî ngê liy꞉aa pyile a kuwo ngê, mê wa wo. ");
INSERT INTO yle_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yi dini ghi ngê Yesu dpodombiy꞉e ka wo, apê, Ilay, Ilay, lama sapaktáni. Yi kópu u nt꞉u kópu, A Yâpwo éé. A Yâpwo éé. Lukwe dîy꞉o a mo cha kuwo nê? Lukwe dîy꞉o ṉga d꞉oo ch꞉anê wo? ");
INSERT INTO yle_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yélini y꞉i doo kwo, Yesu u dnye yi ny꞉ee ngópu. Yi yéli woni knî y꞉oo noko yepê, Ilacha ka ka kââ. ");
INSERT INTO yle_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pi mbêpêmbêpê ngmê loo, tpênê n꞉êê ngmê ńuwo, wain d꞉ââ k꞉oo kmênê ngê, yimbwi ńedê kââ, Yesu komo t꞉âmo mbee ngê, apê, Nda ngê. Yi pini ngê yepê, Ngî t꞉ââ kmêle. Yepê, Ilacha wunê pwiyé knî, ó daawa nî. Yepê, Ilacha ngê kî pini kîdosi ńedê yinê wunê ngêêpî? ");
INSERT INTO yle_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu dpodombiy꞉e yi ka wo, yed꞉oo pwene. ");
INSERT INTO yle_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yi dini ghi ngê Chóó Lémi u ngomo k꞉oo kpîdî ndîî n꞉ii doo ya, yi kpîdî ngê yoo yi maa dpîmo nkokonkoko, apê, Chóó Lémi u yâpwo ghi k꞉oo daapaa nî dniye. Yesu kîdosi ńedê dini ghi n꞉ii ngê pwene, wod꞉oo yi kpîdî chóó mînê chaa wo, châpwochâpwo ngê nkwodo a yaa wo, knâpwo dî. ");
INSERT INTO yle_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Lede n꞉ii knî y꞉oo Yesu kîdosi ńedê t꞉ee ngópu, yi mââwe ndîî kîdosi u nkîgh꞉ê doon꞉aa kwo. Dini ghi n꞉ii ngê Yesu u ngópu ka wo, u ngópu pwene, apê, E! Apê, Kî ndêndê ngê Yâpwo ndîî Tp꞉oo. ");
INSERT INTO yle_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pyââ knî y꞉i ngmêdoo kwo, daa chono dnya a kwo, y꞉i dnya a vyuwo. Yi pyópu knî yi vy꞉o pyââ pyile doo kwo, yi pi dmi Salóme ngmê, Méli Makîdala pyââ myomo, Méli pyolo, Njems mbwémi Njósés yi pye. ");
INSERT INTO yle_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yi pyópu knî y꞉oo Yesu dnyimo a yâmuyâmu, myednyimo a ngêêpî, dini ghi n꞉ii ngê Nkálili Wee u kwo dpîmo a paa. Pyââ mê yilî Yesu u pwopwo têdê y꞉i dnye kwo, n꞉ii dé Nkálili a ndê dniye, Yesu k꞉ii Njedusalem lee dniye. ");
INSERT INTO yle_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Daa kêmakêma kââdî doo wupwo, Adamátiya pi ngmê ta, u pi Njósép. U yi u ngwo doo kwo, Yesu ntóó n꞉uu kmênê. ");
INSERT INTO yle_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yi pini Nju tpémi y꞉oo dnyimo chââchââ, yi kada pini knî yi vy꞉o dpîmo kwo. Yi pini ngê apu, Chóó Lémi ngê nmî y꞉enê kn꞉ââ lîmî k꞉ii ngê paa chaa ngê. U gha vy꞉o apê, Awêde Pîdade, mââ nmî lîme wo. Apê, Yi kópu u l꞉êê dîy꞉o kââdî ghêlî kîngî ghîî, Yesu ntóó mwiyé nî kmênê. Wod꞉oo u nkîngê kuwa a kuwo ngê, Paléti ka loo, Yesu ntóó u kwo mînê ch꞉ee ngê. ");
INSERT INTO yle_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paléti ngê apê, Mumdoo? Apê, Ye pini lukwe dîy꞉o lîmîlîmî ngê dê pw꞉onu? Ledeni knî y꞉oo Yesu kîdosi ńedê t꞉ee ngópu, yi mââwe ndîî ka Paléti u kwo póó wo, kwo, Ye pini ló dini ghi ngê dê pw꞉onu? ");
INSERT INTO yle_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yi pini ngê Paléti ka kwo, Wunê modê pw꞉onu. Wod꞉oo Paléti ngê Njósép ka kwo, Chi lêpî, nyi kmênê ngi. ");
INSERT INTO yle_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wod꞉oo Njósép adî lê, kpîdî mb꞉aa ngmê pwila ngê, Yesu ntóó kîdosi ńedê a ngópu, yi kpîdî ngê a kmongo ngê, ntóó ńuwo, kpomo u mênê mî yó, chêêpî ndîî yi kpomo t꞉âmo ngmê tpiyé wupu kwólu, u ngwo nkoko ngê. Yi kpomo pi knî y꞉oo t꞉aanî paa mwiyé ché ngópu, pi ntóó kmênêkmênê u l꞉êê dîy꞉o. ");
INSERT INTO yle_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Méli Makîdala pyââ, Méli Njósés u pye, yi pyópu dê yi ngópu, Njósép ngê Yesu ntóó kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sádêdé ngê kââdî dini ghi n꞉ii ngê gho, Nju tpémi yi lîme wo machedê ngê pyodo. U kuwó dini ghi ngê pyópuni yoo yi ngópu Yesu pwene, yi pyópu pyile knî y꞉oo kponî mtyîmî ntee tpile knî ngmê pwila ngópu, apê, Yesu ntóó p꞉uu nm꞉uu t꞉ee té. Yi pyópu yoo yi pi dmi Salóme ngmê, Méli Makîdala pyââ myomo, Méli Njems u pye pyolo. ");
INSERT INTO yle_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sandé mw꞉aa mgîdî vy꞉o kpomo chedê lee dniye. ");
INSERT INTO yle_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Maa p꞉uu dnye lêpî, noko yepê, Chêêpî kpomo t꞉âmo nanê nmo wa tpiyé wupu kwolo? ");
INSERT INTO yle_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mu kópu u dîy꞉o chêêpî pââ ndîî, doo u ntââ, yi chóó daapî tpiyé wupu kalê ngópu. Yi taa dniye, apê, Chêêpî lukwe ngê atédê tpiyé wupu kwolo? ");
INSERT INTO yle_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kpomo mênê adî kee dmi, pi mgêmî ngmê m꞉uu ngópu, u kpîdî dmi kpaapîkpaapî, apê, Wéni pee u kêténi mu tóó. Ngwéti dniye. ");
INSERT INTO yle_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yepê, Nuku ngwéti. Yepê, A lama ka tóó, Yesu ka nmye vyuwo té, Nasalet pi, pini n꞉ii kîdosi ńedê t꞉ee ngópu. Yepê, Al꞉ii daa tóó. Yepê, Kêda pyidu. Yepê, A pwiyé dmyeno, ntóó kwéli yé ngópu, yi ghi anyi m꞉uu yó. ");
INSERT INTO yle_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yepê, Lee dmyeno, yepê, p꞉uu ndiye pyu knî ye mdoo ńuw꞉o yó, Pita ka mdoo mye ńuw꞉o yó. Yepê, Ye dp꞉uu vyi yó, yipi, Yesu nmyi kada a kwo, Nkálili. Yipi, Y꞉i anmy꞉uu m꞉uu ngmê, wunê ntee nmye a vyu. ");
INSERT INTO yle_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wod꞉oo pyââ yoo pwii wo, kpomo u mênê, mbêpê dmi a pwaa ngópu, kpomo a kuwo ngópu, mu kópu u dîy꞉o nkîngê ngê y꞉ay꞉a pwiyé dniye. Yi nkîngê u l꞉êê dîy꞉o pi ka kópu ghêlî daa vyi ngópu. Kópuni Mak ngê d꞉êê ngê, wu u dî. U kuwó dini ghi ngê kópu daamu d꞉êê ngê. Ala danêmbum pi knî yi lama doo ya, Yesu dini ghi n꞉ii ngê a pii wo, p꞉uu ndiye pyu knî y꞉oo m꞉uu ngópu. Yi danêmbum u kuwó dini ghi ngê d꞉êê ngópu, kópuni Mak ngê d꞉êê ngê, yi danêmbum dê nipi a kââdî dumo. Kópuni pi knî y꞉oo u kuwó dini ghi ngê d꞉êê ngópu, ala yi danêmbum. ");
INSERT INTO yle_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sandé mw꞉aa mgîdî vy꞉o, Yesu dini ghi n꞉ii ngê a pii wo, Méli Makîdala pyââ ka chóóchóó mwiyé a kêma ngê. Wunê yi pyópu u kmêna Yesu ngê pyudu a ngm꞉ii kwólu. ");
INSERT INTO yle_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yi pyópu ngê Yesu dini ghi n꞉ii ngê módu, wod꞉oo loo, p꞉uu ndiye pyu knî ye mdoo ńuwo, yepê, Yesu kêda pyidu. ");
INSERT INTO yle_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Dnye yii, dnye mbê. Dini ghi n꞉ii ngê ny꞉ee ngópu, yi pyópu ka daa kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","U kuwó dini ghi ngê p꞉uu ndiye pyu miyó dê y꞉oo Yesu u nkwo m꞉uu ngópu, dini ghi n꞉ii ngê Njedusalem a kuwo ngópu, p꞉aa tp꞉oo ngmê y꞉i dpîmo lêpî. Yesu u mo u nâmo ye a ghê wo, chóóchóó ye a kêma ngê. ");
INSERT INTO yle_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yi pini dê dini ghi n꞉ii ngê Njedusalem a diyé knopwo, yi pyipe knî ye mî vyi ngópu, yepê, Yesu kîdnye m꞉uu. Yi pyipe yoo ye daa kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","U kuwó dini ghi ngê Yesu p꞉uu ndiye pyu y꞉a mê ngmê knî y꞉oo kmaapî têdê Yesu u nkwo m꞉uu ngópu, chóóchóó ye a kêma ngê. Ye nod꞉e wo, mu kópu u dîy꞉o k꞉omo tpile u pyidepyide p꞉uu daa ng꞉êêntómu ye doo a danêmbum, ngmênê dêdnye kêlîmî, pini n꞉ii knî y꞉oo Yesu m꞉uu ngópu, apê, Kêda pyidu, yi yéli ye myedaa kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yesu ngê yepê, Dyámê pee yintómu knî yi mbêmê dmyinê lêpî, pi knî ye a kópu dyuu dmyinên꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yepê, N꞉ii dé a ka wunê kêlîmî té, a pi ngê mbwaa paa am꞉ii kmênê t꞉oo, yini yoo wanî ngee té, a kêê k꞉oo wanî kaa té. Yepê, N꞉ii dé a ka daadnya a kêlîmî, yi yéli yi dono machedê ngê daawa pyaa dmi, dono wa a pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yepê, N꞉ii dé a ka wadnya a kêlîmî, u ntââ ngê adnyi ya, mbwudu yilî adnyi chap. Yepê, A pi ngê kmêna adnyi ngm꞉ii kîgha dé, daa dyámê ngmidi dnye ngê adnyi mbumu. ");
INSERT INTO yle_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Yepê, K꞉omo tpile tpile pê ngê wa kiye té, ó ló wa nda ngmê, myedaawa pw꞉oo dmi. Yepê, N꞉ii dé a ka wadnya a kêlîmî, yi yéli y꞉oo pwopwokopwe knî yi mbêmê kêê adnyi yiyé dé, yed꞉oo yinté adnyi pyipyi dé. ");
INSERT INTO yle_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","U kuwó dini ghi ngê Yesu u Mî ka kee wo, u che p꞉ââ pee ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","P꞉uu ndiye pyu yoo dyámê mbêmê dyámê mbêmê lee dniye, Yesu u kópu mb꞉aa pi knî ye dnyen꞉aa tpapê. Pi yilî ye kêlîmî mbê wo, mu kópu u dîy꞉o daa yi mo dnyen꞉aa dpodo, nmî Lémi ngê modoo a ngêêpî dé, mbwudu yilî u ngwo dnyimo chap. Wu u dî. ");
INSERT INTO yle_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mw꞉ââkó nmî lémi, Tiyopilas, Yesu u danêmbum nyi nyongo, u kwo nyi kêlîmî mbê wo. Kópuni yilî Yesu ngê dyámê mbêmê d꞉uu too, pi yilî knî y꞉oo yi kópu ka d꞉êêd꞉êê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yélini y꞉oo yi kópu knî yi chóó yi ngwolo ngê m꞉uu tumo, pi knî ye u nkwo a tpapê tumo, u ngwo nmî ny꞉ee too. ");
INSERT INTO yle_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yi kópu yilî yi p꞉uu mb꞉aamb꞉aa ngê noo ndiye, yi kn꞉ââ dmi nî chó, u mâlo nî yé too, ḻ꞉êê dîy꞉o yi danêmbum n꞉aa d꞉êêd꞉êê. ");
INSERT INTO yle_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","A lémi, Yesu p꞉uu kópuni nyi ndê too, u ya a nga a kwo ndê kópu ngê ṉga dny꞉oo ya. ");
INSERT INTO yle_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dini ghi n꞉ii ngê Helodi Njuda tpémi yi king ngê doo ya, kpêê yiyé pyu ngmê, u pi Sekîdaiya, Apaicha u yoo vy꞉o pini ngmê. U kpâm u pi Elisîpet, kpêê yiyé pyu tp꞉oo módó ngmê. ");
INSERT INTO yle_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Chóó Lémi u nuu u pi cha, u nuu u kópu yidpîmo d꞉uud꞉uu dé, u dêêpî kópu yintómu myedpîmo chââchââ dé. ");
INSERT INTO yle_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","K꞉omo tpile pi cha mb꞉aa dê, ngmênê tp꞉ee daa tpyé ngópu. U yi y꞉e doo kwo, Nyi tpamê knî, ngmênê Elisîpet daa tpete u ntââ ngê doo ya, u dî cha miyó dê mî vy꞉ene knopwo. ");
INSERT INTO yle_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wiki n꞉ii ngê Apaicha u yoo Chóó Lémi ka dnyen꞉aa kpêê yiyé, Sekîdaiya yi vy꞉o doo kwo. ");
INSERT INTO yle_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yi l꞉êê ghi alanté dpîmo ya, mtyîmî nk꞉êênî pyu ng꞉oo ngê dnyimo a pyw꞉êmî. Sekîdaiya yinté a pyw꞉ee ngópu, Chóó Lémi u ngomo k꞉oo yâpwo ghê dy꞉ââ ngópu, y꞉i doon꞉aa mtyîmî nk꞉êênî. ");
INSERT INTO yle_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Yi ngomo k꞉oo dini ghi n꞉ii ngê mtyîmî doo nk꞉êênî, yoo kuwa doo a kwo, dnya a ngêpê. ");
INSERT INTO yle_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","12","Yi dini ghi ngê Sekîdaiya ngê Chóó Lémi u enjel ngmê módu, Sekîdaiya ngwéti wo, nkîngê mbê wo, apê, Mtyîmî nk꞉êênî têdê u wéni pee, apê, enjel ngmê kwo. ");
INSERT INTO yle_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Enjel ngê kwo, Sekîdaiya, kwo, namê nkîngê. Kwo, Chóó Lémi ngê ṉgêpê kêda ny꞉oo, kwo, ṉgmâm Elisîpet wa a ngee, tp꞉ee angmê tpyé, Njon u pyimo dpî téni, mu kópu u dîy꞉o yi tpémi Chóó Lémi u módó yeedeyeede. ");
INSERT INTO yle_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kwo, Dini ghi n꞉ii ngê wa t꞉aa, ṉga mb꞉aamb꞉aa ngê wa pyódu, w꞉aa anyinê pyw꞉oo. Kwo, Pi yilî knî y꞉oo w꞉aa amyedê pyw꞉ee ngmê, ");
INSERT INTO yle_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","mu kópu u dîy꞉o Chóó Lémi u komo kapî pyu ndîî ngê wa pyódu. Kwo, Ghêlî daawa t꞉aa, Chóó Lémi u Ghê Dmi u mênê wa yââ, d꞉ud꞉umbiy꞉e wa a nt꞉ono. Kwo, Wain kîngmê nda, yinté mbwááni myekîngmê nda. Kwo, Pi knî y꞉oo u ngwo wa a w꞉ee ngmê, awo, Kî Chóó Lémi u momu pini. ");
INSERT INTO yle_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kwo, Yisîléli tpémi yilî Chóó Lémi ka amêdê diyédiyé kalê té, pini n꞉ii yi yâpwo ndêndê. ");
INSERT INTO yle_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kwo, Yi tpémi nmî Lémi u kada wa ghê, u maa yinê amênê yé. Kwo, Ilacha ntee pini ngê wadî ya, pi mupwo mupwoknî, n꞉ii noko kpeme a pyede, amêdê kââdî té, n꞉ii knî y꞉oo dnye daa nyêmî ngmê, yi nuw꞉o dmi wa ngmêê té, yoo mb꞉aa ngê amîmî pyódu té, nmî Lémi u yoo ndêndê ngê u ngwo wa pyódu té. ");
INSERT INTO yle_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekîdaiya ngê enjel ka kwo, Ye kópu ndê kópu ngê a nga angênté wa pyódu? Kwo, Nê pi vy꞉ee, a kpâm mye pyââ vy꞉ee. ");
INSERT INTO yle_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Enjel ngê kwo, Ḻama daa tóó kî pini, nê Nkepîlel, Chóó Lémi u nkîgh꞉ê n꞉aa kwo, yinê ṉga da dy꞉ââ nê, ala kópu mb꞉aa ṉga yedên꞉aa vyi. ");
INSERT INTO yle_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kwo, K꞉omo tpile a ka chuu kêlîmî mbê wo, ngmênê kópuni ṉga dî vyi, dîyo ndêndê ngê wa pyódu. Kwo, Dnye u kîgha doo u ntââ ngê dî pyódu ngi, kwo, kópu daamunyi vyi, u dî wéni n꞉ii ngê yi kópu wa pyódu. Kwo, Dnye m̱ênê dî chedê, kópu daamunyi vyi, mu kópu u dîy꞉o a ka chuu kêlîmî mbê wo. ");
INSERT INTO yle_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Yélini kuwa doo kwo, yi nuw꞉onuw꞉o u kópu ngê pyodo, apê, Sekîdaiya ngê Chóó Lémi u ngomo k꞉oo lukwe dîy꞉o mgî dîmo puwâ. ");
INSERT INTO yle_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dini ghi n꞉ii ngê a pwii wo, doo u ntââ kópu ye daapî vyu, kóópyââ ngê ye doo danêmbum, u ngwo a w꞉ee ngópu, apê, Kî pini ngê tpile ngmêdê m꞉uu, kî ngomo k꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Apaicha u yoo knî y꞉oo dini ghi n꞉ii ngê yi dpodo u wiki a kêlî ngópu, Chóó Lémi p꞉uu dpodo têdê, yi p꞉o p꞉o mê diyé dniye, Sekîdaiya u p꞉o mye loo. ");
INSERT INTO yle_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","U kuwó dini ghi ngê u kpâm Elisîpet mbwili ngê pyodo, yi gha dê mb꞉aamb꞉aa ngê pyaa knopwo, ");
INSERT INTO yle_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisîpet ngê apê, Chóó Lémi ngê dê ngee nê, kópuni u l꞉êê dîy꞉o yoo a p꞉uu dnye danê, yinê dê chedê, a p꞉uu mêdaadnyi danê. Ngmênê yoo vy꞉o dêdpîmo paa, apê, Pi knî y꞉oo wadnyi yumuyumu nê, a ka daawa a kêlîmî mbê dmi. Yi kópu u l꞉êê dîy꞉o d꞉ââ limi ngomo k꞉oo doo kwo. ");
INSERT INTO yle_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisîpet d꞉ââ wéni u mbwili ngê doo kwo, Chóó Lémi ngê u enjel Nkepîlel kwodo ngmê ka u ngwo dy꞉ââ ngê, u pi Méli. Pini n꞉ii u yémî p꞉uu yidoo kwo, u pi Njósép, king Dépidi u tii ńedê pini ngmê. Nasalet dpîmo ya, p꞉aani n꞉ii Nkálili Wee u kwo a tóó. ");
INSERT INTO yle_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yi enjel Méli ka loo, kwo, Mw꞉ââkó Méli. Kwo, Nmî Lémi ngê da ngmidi ngi, ṉga myewunê vyuwo. ");
INSERT INTO yle_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Méli ngê yi kópu dêpê w꞉ee ngê, u nuw꞉onuw꞉o kópu ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Enjel ngê kwo, Namê nkîngê. Kwo, Chóó Lémi ngê da ngmidi ngi. ");
INSERT INTO yle_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kwo, Mbwili ngê wanyi pyódu, tp꞉ee mââ ngmanyi tpyé, u pi dpî nténi, Yesu. ");
INSERT INTO yle_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kwo, U pi d꞉ud꞉umbiy꞉e ndîî ngê wa pyódu, nmî yâpwo njini ngê u kwo wa a vyi, kwo wo, Nyi a tp꞉ee njini. Kwo, Nmî Lémi ngê yi tpémi king ngê wa pyódu, u kn꞉ââ Dépidi u d꞉aa yinê wa a kââdî. ");
INSERT INTO yle_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kwo, Njakóp u yoo yintómu yi king ngê adî ya, chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Méli ngê enjel ka kwo, Ye kópu a nga angênté wa pyódu? Kwo, Nê kwodo, d꞉oongê yéé wo. ");
INSERT INTO yle_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Enjel ngê kwo, Chóó Lémi u Ghê Dmi ngê wa nt꞉ee ngi, u wêdêwêdê mbêmê yi kópu ṉga wa pyódu. Kwo, Yi kópu u l꞉êê dîy꞉o yi tpémi yâpwo ndîî tp꞉oo, u momu pini ngê adî ya. ");
INSERT INTO yle_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kwo, Elisîpet p꞉uu nuw꞉o ngî kwéli, pyópuni u k꞉ii dpî p꞉uu ngmidi. Kwo, K꞉omo tpile daa tpete módó, mye pyââ vy꞉ee, ngmênê ala ngwo d꞉ââ wéni u mbwili. ");
INSERT INTO yle_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwo, Chóó Lémi ngê kópuni dpî vyi, yi kópu ndêndê ngê dpî d꞉uu, daawa kn꞉aadi. ");
INSERT INTO yle_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Méli ngê kwo, Nmî Lémi p꞉uu mb꞉aamb꞉aa ngê n꞉aa dpodo yédi, u ntââ ye kópu a nga dpî pyaa we. Wod꞉oo enjel ngê Méli a kuwo ngê. ");
INSERT INTO yle_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Daa dye ghi daadîî yimî loo, Méli u yoo knî yi k꞉ii kada a y꞉ee ngópu, Njuda Wee u kwo lee dniye, mbu kwéli a wee. ");
INSERT INTO yle_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sekîdaiya u p꞉o dini ghi n꞉ii ngê taa dniye, u ngomo k꞉oo kee dniye, Méli Elisîpet ka mbwolo. ");
INSERT INTO yle_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Dini ghi n꞉ii ngê Elisîpet ngê Méli u dnye nyongo, tp꞉ee u mênê paa mbê wo. Yi ngwo dini ghi ngê Elisîpet Chóó Lémi u Ghê Dmi ngê a nt꞉ee ngê, ");
INSERT INTO yle_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Méli ka dpodombiy꞉e mbwolo, kwo, Pyââ yintómu knî yi vy꞉o m̱i ndîî ngê dê pyódu, ṉ́m꞉ee u pi ndîî ngê amye pyódu. ");
INSERT INTO yle_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kwo, A pi têdê, nyi nmî Lémi u pye, kwo, lukwe dîy꞉o chin꞉aa m꞉uu nê? ");
INSERT INTO yle_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kwo, Dini ghi n꞉ii ngê ṉye dî ny꞉oo, a tp꞉ee u gha mb꞉aamb꞉aa ngê dê pyódu, a mênê dê mbêka. ");
INSERT INTO yle_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kwo, Ṉga mb꞉aamb꞉aa ngê dê pyódu, mu kópu u dîy꞉o Chóó Lémi u kópu ka chi kêlîmî mb꞉anê. Kwo, Kópuni ṉga vyu, ndêndê ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Méli ngê apê, Chóó Lémi n꞉aa chaa kîgha, ");
INSERT INTO yle_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","a gha mb꞉aamb꞉aa ngê dê pyódu, mu kópu u dîy꞉o Chóó Lémi ngê wa ngee nê, ");
INSERT INTO yle_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","k꞉omo tpile a pi têdê, ngmênê da ngmidi nê, kópu ndîî a nga ngmêdê d꞉uu. Mu dini ghi ngê pi yintómu yi lama yi kópu wadî ya, yi nuwo daawa a kuwo. Chóó Lémi nmî yâpwo ndêndê, u kópu yilî yintómu mb꞉aamb꞉aa dé, ");
INSERT INTO yle_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","yélini y꞉oo ntênê a chââchââ ngmê, yi yéli yi nuu ghi dmi nódo a tóó, daawa kéé té, anyi dî angêw꞉êê. ");
INSERT INTO yle_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","U wêdêwêdê mbêmê kópu ndîî yilî a d꞉uud꞉uu, mbodo ndîî mbodo ndîî u yoo daa kêmakêma a ngm꞉ii kîgha té. ");
INSERT INTO yle_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","King ndîî yilî yi lémilémi a chedêchedê, yélini yi pi dmi têdê, yi pi dmi ndîî ngê a pyépi. ");
INSERT INTO yle_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ngópuch꞉anê knî ye kópu mb꞉aa yilî a yém, ngmênê ndáápi knî ye kópu mb꞉aa daawa y꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nmî kn꞉ââ knî ye ndê kópuni a vyu, atédê ntiye, u nuwo dêpê kuwo wo. U yoo Yisîléli tpémi, yinêwa ngee té. ");
INSERT INTO yle_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chóó Lémi nódo Epîlaham u nuu ghi a tóó, u yoo u nuu ghi dmi nódo mye tóó, chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Méli Elisîpet p꞉uu doon꞉aa ya, d꞉ââ pyile, u kuwó dini ghi ngê u p꞉o mê diyé wo. ");
INSERT INTO yle_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisîpet ngê pwopwo kele, ghêpê wo, tp꞉ee mââ ngmê tpyó. ");
INSERT INTO yle_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisîpet u yoo, p꞉aa tpémi yi k꞉ii, yi kópu yi ny꞉ee ngópu, yi gha dmi mb꞉aamb꞉aa ngê pyodo, apê, Nmî Lémi ngê kópu ndîî u ngwo ngmêdê d꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wo woloni ngê Chóó Lémi u l꞉ii yi tpémi p꞉uu t꞉ee ngópu. U yi y꞉e doo kwo, U mî Sekîdaiya u pi u pyimo nmî t꞉oo, ");
INSERT INTO yle_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ngmênê u pye ngê yepê, Kêle. Yepê, U pi Njon. ");
INSERT INTO yle_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kwo, Ṉ́oo pee vy꞉o pi ngmê u pyimo Njon daa t꞉a. ");
INSERT INTO yle_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sekîdaiya ka yi kêêpyââ ngê póó dniye, kwo, U pi n꞉uu? ");
INSERT INTO yle_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekîdaiya ngê kóópyââ ngê d꞉êê têdê u tpile ye ngmê dmy꞉ee ngê, tp꞉oo u pi y꞉i d꞉êê ngê, apê, U pi Njon. Ngwéti dniye. ");
INSERT INTO yle_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yi ngwo dini ghi ngê Sekîdaiya ngê dnye mê pw꞉ii ngê, wod꞉oo Chóó Lémi doo chaa kîgha. ");
INSERT INTO yle_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yi p꞉aani tpémi ngwéti dniye, mye nkîngê mbê dniye. Yi kópu yilî Njuda Wee u kwo p꞉aani p꞉aani ny꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pi yintómu knî y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, dnye nuw꞉onuw꞉o, apê, Lónté pini ngê wa pyódu, mu kópu u dîy꞉o Chóó Lémi u kwo wunê vyuwo. ");
INSERT INTO yle_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chóó Lémi u Ghê Dmi ngê Njon u mî Sekîdaiya a nt꞉ee ngê, Sekîdaiya ngê Chóó Lémi Tp꞉oo p꞉uu kópu u ngwo a w꞉ee ngê, ala kópu dyuu u ngwo vyu, apê, ");
INSERT INTO yle_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Yisîléli tpémi, nmî Lémi chaa kîgha koo, pini n꞉ii nmî yâpwo njini, mu kópu u dîy꞉o chóó u yoo knî ye a lêpî, yinê wa ngee té. ");
INSERT INTO yle_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nmî Mbwámê ndêndê nmo wunê dyede, u dpodo pyu Dépidi u tii ńedê pini ngmê. ");
INSERT INTO yle_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yi kópu chóó u komo kapî pyu knî y꞉oo ló dini a vyi ngópu, ala ngwo atédê ntiye. ");
INSERT INTO yle_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","N꞉ii knî ye nmî diya dniye, yi kêlê yinê wa dyé nmo. ");
INSERT INTO yle_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Nmî nuu ghi dmi Chóó Lémi nódo ka tóó, mu kópu u dîy꞉o Epîlaham ka ndêndê kópu n꞉ii mwiyé a vyu, kwo, Ṉyoo knî ye ana a vyuwo, yi kópu daa kn꞉aadi ngê, nmî kn꞉ââ knî ye doo a vyuwo. ");
INSERT INTO yle_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Epîlaham ka ala ndêndê kópu mye vyu, kwo, Yélini ṉyoo knî yi p꞉uu adnyi l꞉êê, yi kêlê wanî dyé té, mu kópu u l꞉êê dîy꞉o daapîdny꞉oo nkîngê, a p꞉uu u ngwo pîdny꞉oo dpodo, ");
INSERT INTO yle_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","a yoo mb꞉aa, u momu yéli ngê pîdny꞉oo kwo, chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sekîdaiya ngê tp꞉oo Njon ka kwo, A tp꞉ee. Kwo, Chóó Lémi ngê da ngmidi ngi, u komo kapî pyu ndîî ngê wanyi pyódu, nmî Lémi u kada wanyi ghê, u maa anyimo yé. ");
INSERT INTO yle_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kwo, Ala kópu u yoo knî ye any꞉uu vyi, yenye, Nmyi dono kéé tóó, nmî Lémi ngê u ngwo wa ngee nmyo. ");
INSERT INTO yle_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sekîdaiya ngê yepê, Chóó Lémi ka dpî ch꞉anê dmi. Yepê, Kââdî ngê mgîdî ntee dpî chaa, nmî Mbwámê yinté nmo wa t꞉a. ");
INSERT INTO yle_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yepê, K꞉omo tpile mgîdî vy꞉o nmo pyede, pwopwo ka nmo nkîngê té, ngmênê yi mgîdî yinê wa chaa, Chóó Lémi ka maa nmo yinê wa a kêma. ");
INSERT INTO yle_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dini ghi n꞉ii ngê Njon kaa wo, mââwe ngê pyodo, Chóó Lémi u kópu yilî a w꞉ee too. Daa yoo vy꞉o doo kwo, u dye ghi doo t꞉âât꞉ââ, Yisîléli tpémi ye Chóó Lémi u kópu dyuu u tpapê kn꞉ââ ghêlî daa chópu. ");
INSERT INTO yle_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dini ghi n꞉ii ngê Njon pyodo, Lóma tpémi yi king ndîî Okastas ngê u yi doo kwo, Kada pini knî y꞉oo yoo a kp꞉aa y꞉e. Lóma tpémi y꞉oo Nju tpémi dêpêngê kp꞉aa tumo, ala yi mwiyémwiyé. ");
INSERT INTO yle_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yi dini ghi ngê Kwîdiniyês Sidiya tpémi yi kada pini ngê doo ya. ");
INSERT INTO yle_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pi kpââ u l꞉êê dîy꞉o pi yintómu yi p꞉o p꞉o loo. ");
INSERT INTO yle_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Njósép ka kwo, Nyi Dépidi u tii ńedê pini ngmê, Dépidi kwéli a pyodo, Petîlem, m̱i y꞉i dp꞉uu yé. U yémî p꞉uu Méli k꞉ii Nasalet a kuwo ngópu, Njuda Wee u kwo lee knopwo, Petîlem mî taa knopwo. Pi kpââ têdê p꞉aa a nt꞉ee wo. ");
INSERT INTO yle_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","K꞉omo tpile Méli mbwili pââ ndîî, ngmênê dpî ngomo knî yi k꞉oo yi p꞉aa dêpwo ya, hósi ndonki knî yi ngomo k꞉oo mî kee knopwo. Y꞉i ghêpê wo, tp꞉oo kaa y꞉i tpyó, kpîdî pee ngê kwédi kê ngê, hósi knî yi kmaapî têdê y꞉i yó. ");
INSERT INTO yle_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yi dyámê pee p꞉uu sipi w꞉uu y꞉enê pyu yoo ngmêdoo kwo, mgîdî vy꞉o w꞉amî mbêmê sipi w꞉uu dnye y꞉enê dé. ");
INSERT INTO yle_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nmî Lémi u enjel ye ngmê ta, nmî Lémi u wuu yi pwo mî kéé ngê. D꞉ud꞉umbiy꞉e nkîngê ngê y꞉ay꞉a pwiyé dniye. ");
INSERT INTO yle_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Enjel ngê yepê, Namê nkîngê. Yepê, Kópu mb꞉aa nmye yed꞉a ńuw꞉o, u l꞉êê dîy꞉o pi yintómu knî y꞉oo w꞉aa wa a pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, ala mgîdî vy꞉o Dépidi u p꞉o kêda t꞉aa. Yepê, Yi pini nmî Lémi ndêndê, mye nmyi Mbwámê. ");
INSERT INTO yle_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yepê, Alanté nmye myeme ngmê, tp꞉ee kamî nmyinê pyw꞉êmî ngmê, kpîdî ngê kwédi kê ngmê, hósi knî yi kmaapî têdê a dpî. ");
INSERT INTO yle_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dini ghi ngê enjel ngê u danêmbum ye a kêlî ngê, Chóó Lémi u enjel mê yilî m꞉uu ngópu, dnye wéti, Chóó Lémi dnye chaa kîgha, apu, ");
INSERT INTO yle_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Chóó Lémi nmî pwo a tóó, nmo chaa kîgha. Nmyi Mbwámê dyámê mbêmê da dy꞉ââ, mu kópu u dîy꞉o u kwo nmyi ch꞉anê dniye. ");
INSERT INTO yle_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dini ghi n꞉ii ngê enjel knî y꞉oo sipi w꞉uu y꞉enê pyu yoo a kuwo tumo, Chóó Lémi ka mê diyé dniye, yi tpóknî y꞉oo noko yepê, Petîlem lee kmêle, nmî Lémi ngê kópuni u pi nmo dê vyi, nye m꞉uu koo. ");
INSERT INTO yle_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wod꞉oo kada a y꞉ee ngópu, Petîlem lîmîlîmî ngê mî taa dniye, Méli ghee a pyw꞉ee dumo, Njósép u k꞉ii dnye ya, apê, Tpómu kamî hósi knî yi kmaapî têdê mu dpî. ");
INSERT INTO yle_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yi m꞉uu ngópu, apê, Kî vyîlo. Kópuni enjel ngê yi tpémi p꞉uu ye vyi too, pi knî yi ngêêdî a nté tumo. ");
INSERT INTO yle_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","N꞉ii knî y꞉oo yi kópu dyuu ny꞉ee tumo, ngwéti dniye. ");
INSERT INTO yle_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Méli ngê yi kópu yilî u gha vy꞉o yé too, doo nuw꞉onuw꞉o dé. ");
INSERT INTO yle_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","U kuwó dini ghi ngê sipi w꞉uu y꞉enê pyu yoo mê diyé dniye, maa p꞉uu dnye wéti, kópuni ny꞉ee tumo, kópuni m꞉uu tumo, yi kópu knî yi l꞉êê dîy꞉o Chóó Lémi dnye chaa kîgha. Enjel ngê kópuni ye mî vyi too, yi tpémi yinté mînê pyw꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wo pyudu mî loo, woloni ngê Chóó Lémi u l꞉ii Yesu p꞉uu t꞉ee ngópu, u pi ntaa ngópu, apê, Yesu, enjel ngê n꞉ii u pi Méli ka vyu, ghêlî k꞉ii mbwili ngê daa pyodo. ");
INSERT INTO yle_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Mósisi ngê u dêêpî kópu dyuu vy꞉o kópu ngma a d꞉êê ngê, apê, Pyópuni dê tpamê knomomê, Chóó Lémi ka tupwótupwó ngê a ya yédi, Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo kîngî nî. Apê, Wo podoy꞉a choo t꞉ââ, vy꞉êmê miyó Chóó Lémi ka choo ńeńe dê, kpêê yiyé pyu ngê adî nk꞉êênî dê, u tupwó machedê ngê u ngwo adî pyodopyodo. Yi kópu u ntiyentiye u l꞉êê dîy꞉o Njósép mupwoknî Njedusalem lee dniye. Mósisi ngê kópu m꞉uu a d꞉êê ngê, mye ntiye ngópu. Yi kópu ala. Tp꞉ee mââ kaani yintómu Chóó Lémi u nêni dé, yi pye mî knî y꞉oo Chóó Lémi ka dny꞉oo pywupwi dé. Yi kópu u l꞉êê dîy꞉o Yesu Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo ńuw꞉o ngópu. ");
INSERT INTO yle_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pi vy꞉ee ngmêdoo ya, Njedusalem, u pi Simiyón, k꞉uuchêm u pi, Chóó Lémi mb꞉aamb꞉aa ngê dpîmo chââchââ, alanté dpîmo nuw꞉o, apu, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, pini n꞉ii nmî Mbwámê ngê wa pyódu, lîmîlîmî ngê taa we. Chóó Lémi u Ghê Dmi p꞉uu doo ya, ");
INSERT INTO yle_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ala kópu u kwo a vyu, kwo, Ghêlî daanyi pw꞉onu, ngmênê nmyi Mbwámê mwiyé wa t꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dini ghi n꞉ii ngê Yesu u pye mî y꞉oo Yesu Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo ńuw꞉o ngópu, Chóó Lémi u Ghê Dmi ngê Simiyón y꞉i mye dy꞉ââ ngê. ");
INSERT INTO yle_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyón ngê tpómu yi kêlê a ngópu, u kede paa t꞉ângo, wod꞉oo Chóó Lémi doo chaa kîgha, kwo, ");
INSERT INTO yle_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Mw꞉ââkó a Lémi, dpodoni a ka nyinê kpo, mo kalê nédi. Kwo, Ṉgêê k꞉oo kaa nédi. Kwo, Kópuni a ka nyinê vyu, awêde chi ntiye. ");
INSERT INTO yle_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwo, Pini n꞉ii nyinê ngmidi ngê, nmî Mbwámê, a chóó a ngwolo dê y꞉oo atédî m꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kwo, Pi dyêêdî yintómu yi ngópu nye tpyuu. ");
INSERT INTO yle_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kwo, Yélini daa Nju tpémi yi pywápê ngê wa pyódu, ala tpémi u l꞉êê dîy꞉o ṉyoo Yisîléli tpémi yi pi dmi ndîî ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiyón ngê kópuni vyi too, Yesu p꞉uu, Njósép cha yi ngwétingwéti u kópu ngê pyaa dniye. ");
INSERT INTO yle_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Simiyón yi l꞉êê dîy꞉o doo ngêpê, u kuwó dini ghi ngê Yesu u pye Méli ka kwo, Chóó Lémi ngê ala tpémi a ngmidi ngê, Yisîléli tpémi yinê wa chámê té. Kwo, Yi chóó yi gha dmi yi l꞉êê dîy꞉o wa numo chámê té, woni yoo ala tpémi ngê wa ngee té, woni knî y꞉oo u wépi wa pwaa ngmê, yi chóó wa dyênê dmi. Kwo, Nmî ng꞉aa t꞉emî u l꞉êê dîy꞉o Chóó Lémi ngê da dy꞉ââ, ngmênê pi yilî u kwo adnyi kwopwepe, yinê ye k꞉omodanê pyu ngê adîn꞉aa ya. Kwo, Mu dini ghi ngê anyin꞉aa nyepê, mbê ngê y꞉ay꞉a wanyi pwiyé. ");
INSERT INTO yle_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Pyââ ngmê yi dini ghi ngê myedê loo, u pi Ana, u mî u pi Panuwel, Asê u tii ńedê pyópu ngmê. Pyââ vy꞉ee, u m꞉ââ woloy꞉a mê páádi, u moo k꞉ii m꞉ââ pyudu ma ngópu, yed꞉oo u moo pwene. Yi kuknwe dye ghi yintómu Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo dpîmo ya, yi kêlî ghi dêpê kuwo ngê, w꞉êênî mgîdî vy꞉o Chóó Lémi ka dpîmo ngêpê, u ngêpê wêdêwêdê kîgha u l꞉êê dîy꞉o, dye ghi knî ngmê ngê nté dêdpîmo pîpî. Dini ghi n꞉ii ngê Njósép mupwoknî m꞉uu too, Chóó Lémi kwuno ngê. U kuwó dini ghi ngê Njedusalem tpémi yi vy꞉o, n꞉ii knî y꞉oo nmî Mbwámê dnye t꞉âât꞉ââ, yi yéli ye yi tpémi p꞉uu dpîmo danêmbum. ");
INSERT INTO yle_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mósisi ngê tpómu kamî knî yi p꞉uu kópuni a d꞉êê too, Njósép cha y꞉oo yi kópu dini ghi n꞉ii ngê d꞉uu tumo, yi p꞉o mê diyé dniye, Nasalet, p꞉aani n꞉ii Nkálili Wee u kwo a tóó. ");
INSERT INTO yle_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yi tp꞉ee yi kaa wo, wêdêwêdê u mênê yaa wo, Chóó Lémi u kwo dpîmo a vyuwo, u nuw꞉o myedê ńépwi ngê. ");
INSERT INTO yle_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","M꞉ââ yintómu yi k꞉oo Njósép mupwoknî Njedusalem dnyimo lêpî, Tp꞉ee Kaa W꞉êêw꞉êê u Naa têdê. ");
INSERT INTO yle_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Dini ghi n꞉ii ngê Yesu u m꞉ââ y꞉a mê miyó ngê doo ya, yi nááli têdê mye lee dniye. ");
INSERT INTO yle_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Dini ghi n꞉ii ngê yi nááli machedê ngê pyodo, yoo mê nyalê wo, yi p꞉o p꞉o mê diyé dniye, ngmênê Yesu daa loo, Njedusalem a yaa wo. U pye mî yi lama dêpwo ya, Dpo kuwo ngmê. ");
INSERT INTO yle_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yinê ye, Nyi yoo knî yi k꞉ii kada dê ghê dmi. Yi wéni a kêlî ngópu, dêdpîmo nuw꞉onuw꞉o. Maa p꞉uu p꞉aani n꞉ii dpî dniye, yi p꞉aani dini ghi n꞉ii ngê taa dniye, wod꞉oo yi tp꞉ee dpîmo nmy꞉uu, yi yoo knî ye yi pyipe knî ye dpîmo póó, yipu, Nyi tp꞉ee angênê? ");
INSERT INTO yle_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dêpê pyw꞉ee ngópu, wod꞉oo womumo mw꞉aandiye Njedusalem mê diyé knopwo, ntumokwodo mî taa knopwo, y꞉i dpî knopwo. ");
INSERT INTO yle_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Womumo mw꞉aandiye Chóó Lémi u ngomo chedê mênê pyw꞉ee ngópu, apê, Ndiye pyu ndîî knî yi k꞉ii mu pyede, apê, mu ng꞉aang꞉aa té, apê, ye myeka póó. ");
INSERT INTO yle_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yélini y꞉oo dnye ng꞉aang꞉aa dé, yi nyepênyepê u kópu ngê pyodo, noko yipu, Kî tpémi u nuw꞉o ndîî, mââwe knî yi k꞉ii mb꞉aamb꞉aa ngê ka danêmbum té. ");
INSERT INTO yle_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","U pye mî y꞉oo dini ghi n꞉ii ngê a pyw꞉ee ngópu, ngwéti knopwo, u pye ngê kwo, Kî tpémi. Kwo, Lukwe dîy꞉o ye kópu nye chi d꞉uu. Kwo, M̱î k꞉ii kîny꞉oo nmy꞉uu ngi, nuw꞉onuw꞉o u wo my꞉ee chedê. ");
INSERT INTO yle_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu ngê yepê, Lukwe dîy꞉o dpo nmy꞉uu nê? Yepê, Angênté, dpî lama daa tóó M꞉aa ngê u dpodo têdê dê kaa nê? ");
INSERT INTO yle_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kópuni ye vyu, Njósép cha y꞉oo dêpê w꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nasalet kwéli a ndê dniye, Yesu u k꞉ii y꞉i mê diyé dniye, Yesu ngê yi dnye dê mb꞉aamb꞉aa ngê doo nyêmî dê. U pye ngê yi kópu yilî u gha vy꞉o doo yiyé dé. ");
INSERT INTO yle_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Dini ghi n꞉ii ngê Yesu kaa wo, nuw꞉o ndîî u mênê yi yaa wo, pi knî ye pi mb꞉aa ngê doo ya, Chóó Lémi ka pi mb꞉aa ngê myedoo ya. ");
INSERT INTO yle_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lóma tpémi yi king Okastas dini ghi n꞉ii ngê pwene, u wo tp꞉ee Taipidiyas ngê u d꞉aa a kââdî ngê. M꞉ââ y꞉a mê limi mî loo, Sekîdaiya tp꞉oo Njon ngê u dpodo kn꞉ââ u ngwo chópu. Yi dini ghi ngê Lóma lede knî y꞉oo Nju tpémi dnye y꞉enê dé, yi kada pini u pi Pontiyas Paléti. Antipas Helodi ngê Nkálili tpémi doo y꞉enê dé, mu kópu u dîy꞉o Lóma tpémi y꞉oo yi kada pini ngê y꞉oo pyódu ngópu. U mbwó Pilipi ngê Itudiya tpémi Tîdakonaitis tpémi yinê doo y꞉enê dé, Laisaniyas ngê Apîlini tpémi yinê doo y꞉enê dé. ");
INSERT INTO yle_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yi dini ghi ngê Nju tpémi yi kpêê yiyé pyu ndîî miyó doo ya, Anas pini dê Kayapas. Yi yéli doo kwo, Sekîdaiya tp꞉oo Njon w꞉amî mbêmê doon꞉aa ya, daa yoo vy꞉o. Yi dini ghi ngê Chóó Lémi u kópu dyuu y꞉i mînê nyongo, u dpodo kn꞉ââ u ngwo chópu. ");
INSERT INTO yle_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Njon mbwaa ndîî Njódan wope wope p꞉aani p꞉aani dpîmo lêpî, pi knî ye dpîmon꞉aa dêêpî, yipu, Nmyi dono yilî yi l꞉êê dîy꞉o Chóó Lémi u yoo kuwa nmyi chóó nmyi ghê dniye. Yipu, Nmyi dono yilî kéé tóó, n꞉aa mbápitisîm kîgha nmyo, Chóó Lémi ngê nmyi dono yilî u kuwó u ngwo wa kéé té, mêdaawa a ngî té, Chóó Lémi u yoo njini ngê u ngwo wanmyi pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kópuni Yisaya ngê u puku yedê wunê a d꞉êê ngê, Njon ngê yi ngwo ntiye ngê. Yi kópu ala. W꞉amî mbêmê pi ngma adî kââ, yewo, Nmî Lémi u maa a yé yó, maa mb꞉aa yidó yé yó. ");
INSERT INTO yle_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ghi nkîlînkîlî a nmy꞉ee tóó, paa ghi dpî ché tóó, mbu mbodo myoo ché tóó, maa kwolo ngmê dé ntênê dpo yé tóó, nmî Lémi u maa p꞉uu duu kîngmê kwo. ");
INSERT INTO yle_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","U kuwó dini ghi ngê nmî Mbwámê ngê yi máádi wa a kwolo, pi yintómu knî y꞉oo yi pini u ngwo wa m꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Njon ngê yoo kwéli dpîmo mbápitisîm kîgha, y꞉i pi yilî u kwo loo, u yi y꞉e doo kwo, Nye mbápitisîm kalê nmîne. Njon ngê yi gha dmi módó, yepê, Nmyo k꞉omodanê pyu yoo. Yepê, Lukwe dîy꞉o nmyinê nmye, Mbápitisîm mbêmê Chóó Lémi ngê daawa kpada nmo. ");
INSERT INTO yle_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yepê, Nmyi dono yilî mwiyé kéé tóó. Yepê, Dono kópu n꞉aamungî d꞉uu, kópu mb꞉aa yilî dmyinên꞉aa d꞉uud꞉uu, u ngwo anê w꞉ee, nê, Yi nuw꞉o dmi ndêndê ngê dê ngmêê t꞉oo. Yepê, Ala kópu namê tpapê, Epîlaham nmî kn꞉ââ, Chóó Lémi ngê daawa kéé nmo, p꞉ee nmo ada a vyuwo. Yepê, Yi kópu ló dini mwo a vyu, ngmênê nmyi dono yilî yi l꞉êê dîy꞉o ntênê wa kéé nmyo. Yepê, Chóó Lémi u wêdêwêdê ndîî, u ntââ, ala chêêpî dyuu wa a ngî, pi ngê wa pyódu té, nmyi d꞉aa dmi y꞉oo wa a kââdî ngmê. Yepê, Vyîlo yi yéli ye ada a vyuwo. ");
INSERT INTO yle_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yepê, Ala ngwo Chóó Lémi maadî kîyedê kwo, u myângo wumê mumu. Yepê, Yi myângo vy꞉o yini n꞉ii nt꞉u mb꞉aamb꞉aa ngê daa kelekele, wa kpono, pââ ndiya wa kéé. ");
INSERT INTO yle_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pi knî y꞉oo kwo, Ló kópu ngmanmî d꞉uu? ");
INSERT INTO yle_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yepê, N꞉ii u mb꞉êê pee ndîî, pinté yoo mîchoo a wopwe dé. Yepê, Nté myenté, n꞉ii u ngópu nté a tóó, choo yêêpî. ");
INSERT INTO yle_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tákisi ngêêpî pyu yoo myedê lee dniye, apê, Njon ngê nye mbápitisîm kalê nmîne. Njon ka póó dniye, kwo, Mââwe, ló kópu ngmanmî d꞉uu? ");
INSERT INTO yle_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yepê, Tákisi ndapî u ntââ mbêmê dmyina a ngêêpî. Yepê, Yoo namê dódó, nmyi chóó nmyi ndapî ndîî nama a ngêêpî. ");
INSERT INTO yle_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Helodi u lede ngmê knî y꞉oo kwo, Nmo angênté dé? Kwo, Ló kópu ngmanmî d꞉uu? Yepê, Pi u tpile módó nangmê ngî, pi p꞉uu kêêmî nangmê kââ. Yepê, Nmyi dpodo u pywuu p꞉uu namê danê, u ntââ ngê nmye choo ya. ");
INSERT INTO yle_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pi yintómu yi gha dmi mb꞉aamb꞉aa ngê pyodo, apê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, nmî Mbwámê ngê a pyódu ngê, ndoo apê wu Njon vyîlo. Apê, Nmî kada wa ghê, Lóma tpémi wanmî ngm꞉ii kalê té, yed꞉oo nmî chóó anmî ya. ");
INSERT INTO yle_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Njon ngê pi yintómu knî ye yepê, Nê kuu. Yepê, A kada pini kîyedê pwiyé knî, pini n꞉ii u pi ndîî. Yepê, Nê têdê, d꞉oo u ntââ, u nkîgh꞉ê daanî nî. Yepê, Nê tp꞉ee. Yepê, Mbwaa ngê munî mbápitisîm kîgha nmyo, ngmênê yi pini ngê Chóó Lémi u Ghê Dmi ngê wa mbápitisîm kalê nmyo, ndyuw꞉e ngê wamye mbápitisîm kalê nmyo. ");
INSERT INTO yle_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yepê, Pini n꞉ii wunê pwiyé knî, daa kêmakêma a taataa. Yepê, Dini ghi n꞉ii ngê wa t꞉aa, nmyo yintómu daawa ngee nmyo, wa chámê nmyo. Yepê, N꞉ii yoo mb꞉aamb꞉aa dé, wa a ngî té, n꞉ii yoo dono dé, wa kéé té, ndê ngê wa ma té, yi ndyuw꞉e chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yesu u kópu mb꞉aa p꞉uu Njon ngê yoo daa kópu ngmidi p꞉uu doo ndiye kîgha dé. ");
INSERT INTO yle_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ngmênê Njon Antipas Helodi p꞉uu myedpîmo danê, mu kópu u l꞉êê dîy꞉o Antipas Helodi ngê u kpâm kpîpî ngê, u mbwó kpâm Helodiyas t꞉âmo ngê, kópu dono mê yilî dpîmo d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","U kuwó dini ghi ngê Antipas Helodi ngê kópu dono ndîî ngmê d꞉uu ngê, Njon mbwa k꞉oo kmungo. ");
INSERT INTO yle_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Antipas Helodi ngê Njon mbwa k꞉oo ghêlî daa kmungo, Yesu Njon ka loo. Dini ghi n꞉ii ngê Njon ngê pi yintómu mbwaa paa kmênê too, Yesu mbwaa paa mye kmênê ngê. U kuwó dini ghi ngê Yesu doo ngêpê, u mî ka, mbóó u ngwo u kwo a kpêmî ngê, ");
INSERT INTO yle_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chóó Lémi u Ghê Dmi vy꞉êmê k꞉ii ntee tpile ngê u pwo a ghêpê wo. Mbóó p꞉uu dnye ngmê ny꞉ee ngópu, kwo, Nyi a tp꞉ee njini, ṉuu ghi a nódo ka tóó, dye ghi yintómu a nuu u kópu nye d꞉uud꞉uu too. ");
INSERT INTO yle_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Dini ghi n꞉ii ngê Yesu ngê u dpodo kn꞉ââ chópu, yi ngwo u m꞉ââ pyoloy꞉a ngê doo ya. Yoo alanté dnye nuw꞉o, apê ngmênê, Yesu Njósép tp꞉oo, Eli u kee. ");
INSERT INTO yle_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli u mî Matati. Matati u mî Lipi. Lipi u mî Melîki. Melîki u mî Njanay. Njanay u mî Njósép. ");
INSERT INTO yle_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Njósép u mî Matataiyas. Matataiyas u mî Emos. Emos u mî Nahum. Nahum u mî Esîli. Esîli u mî Nankay. ");
INSERT INTO yle_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nankay u mî Maati. Maati u mî Matataiyas. Matataiyas u mî Seméni. Seméni u mî Njóséki. Njóséki u mî Njóda. ");
INSERT INTO yle_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Njóda u mî Njówanan. Njówanan u mî Lésa. Lésa u mî Sedapapel. Sedapapel u mî Siyaltiyéli. Siyaltiyéli u mî Nédi. ");
INSERT INTO yle_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nédi u mî Melîki. Melîki u mî Adi. Adi u mî Kósam. Kósam u mî Elîmadam. Elîmadam u mî Edi. ");
INSERT INTO yle_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Edi u mî Njósuwa. Njósuwa u mî Eliyesa. Eliyesa u mî Njódim. Njódim u mî Matati. Matati u mî Lipi. ");
INSERT INTO yle_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipi u mî Simiyón. Simiyón u mî Njuda. Njuda u mî Njósép. Njósép u mî Njónam. Njónam u mî Elayakim. ");
INSERT INTO yle_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elayakim u mî Méliya. Méliya u mî Mena. Mena u mî Matata. Matata u mî Natan. Natan u mî Dépidi. ");
INSERT INTO yle_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dépidi u mî Njési. Njési u mî Opédi. Opédi u mî Mbówas. Mbówas u mî Salîmon. Salîmon u mî Nason. ");
INSERT INTO yle_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason u mî Aminatap. Aminatap u mî Adîmin. Adîmin u mî Ani. Ani u mî Hesîdon. Hesîdon u mî Pedes. Pedes u mî Njuda. ");
INSERT INTO yle_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Njuda u mî Njakóp. Njakóp u mî Yisak. Yisak u mî Epîlaham. Epîlaham u mî Tela. Tela u mî Nahó. ");
INSERT INTO yle_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahó u mî Seduki. Seduki u mî Leyu. Leyu u mî Peléki. Peléki u mî Epédi. Epédi u mî Sila. ");
INSERT INTO yle_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila u mî Kainan. Kainan u mî Apakîsadi. Apakîsadi u mî Sem. Sem u mî Nówa. Nówa u mî Laméki. ");
INSERT INTO yle_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laméki u mî Mîtusîla. Mîtusîla u mî Inóki. Inóki u mî Njadédi. Njadédi u mî Mahalalil. Mahalalil u mî Kainan. ");
INSERT INTO yle_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan u mî Inos. Inos u mî Séti. Séti u mî Adam. Adam u mî Chóó Lémi. ");
INSERT INTO yle_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Dini ghi n꞉ii ngê Njon ngê Yesu mbwaa paa kmênê ngê, Chóó Lémi u Ghê Dmi ngê Yesu d꞉ud꞉umbiy꞉e a nt꞉ee ngê. Yesu ngê Njódan mbwááni a kuwo ngê, Chóó Lémi u Ghê Dmi ngê w꞉amî mbêmê ńuwo. ");
INSERT INTO yle_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Setan ngê y꞉i doon꞉aa dódó, u yi u ngwo doo kwo, Dpodoni Chóó Lémi ngê u kwo a y꞉ângo, apê, yi dpodo pêdê kuwo ngê. Wo podoy꞉a Yesu ngê nté dêpwo pîpî. ");
INSERT INTO yle_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dini ghi n꞉ii ngê dómu u ngwo kele, Setan ngê kwo, Mumdoo nyi Chóó Lémi Tp꞉oo, kî chêêpî ngma a ngini, nté ngê pyódu ngi, ma ngi. ");
INSERT INTO yle_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu ngê kwo, Puku yedê alanté a tóó, Nté u mo doo u ntââ, pi u ngwo daa ya yédi. Nté daa nté njini, Chóó Lémi u kópu dyuu, yi nté njini. ");
INSERT INTO yle_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","U kuwó dini ghi ngê Setan ngê Yesu mbu mbêmê kmungo, dyámê pee yintómu lîmîlîmî ngê y꞉i u kwo mênê kêma too. ");
INSERT INTO yle_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Setan ngê kwo, Ala tpile yilî ṉga wanî kê té, yoo yintómu yi kada wanî kaa ngi, wanyi y꞉enê dé. Kwo, Yi tpile yintómu a chóó a nêni dé, a chóó n꞉aa y꞉enê té. Kwo, Pini n꞉ii anî ngmidi, u ntââ adî y꞉enê dé. ");
INSERT INTO yle_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kwo, A dnye nye nyêmî knomomê, ye ala tpile yintómu yi kada pini ngê n꞉aa pyépi ngi. ");
INSERT INTO yle_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu ngê kwo, Puku yedê alanté a tóó, Chóó Lémi nmî Yâpwo njini chi chââchââ, kn꞉aa pini u dnye nangmê ny꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","U kuwó dini ghi ngê Yesu ka ngmênê u kwo, Setan ngê Njedusalem dê ńuw꞉o nê, M꞉aa u ngomo pw꞉ono y꞉i d꞉uu kaa nê. Setan ngê kwo, Mumdoo nyi Chóó Lémi tp꞉oo, mumdoo m̱î ngê amyedê ngee ngi, ye ala ngomo pw꞉ono a mbêka, ");
INSERT INTO yle_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","mu kópu u dîy꞉o puku yedê alanté a tóó, Chóó Lémi ngê u enjel yoo wunê dyede té, a ngêêpî ngi. ");
INSERT INTO yle_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kwo, Ala kópu puku yedê mye tóó, Enjel yoo yi kêê yedê anyi kwo, ṉyi dê chêêpî u mênê daanyinê dêê dê. ");
INSERT INTO yle_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu ngê kwo, Doo u ntââ M꞉aa yinté daanê tókó, mu kópu u dîy꞉o puku yedê ala kópu a tóó, Chóó Lémi nmî Yâpwo njini kidima a tókótókó. ");
INSERT INTO yle_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setan ngê Yesu doo dódó, u kópu yintómu chedê ngê, ngmênê dêê wo, wod꞉oo Yesu mwiyé mêdê kuwo ngê. ");
INSERT INTO yle_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Yesu Nkálili Wee u kwo mê diyé wo, Chóó Lémi u Ghê Dmi u wêdêwêdê mbêmê y꞉i dpîmon꞉aa dpodo, p꞉aani p꞉aani yi ngêpê ngomo knî yi k꞉oo lîme wo ngê myedpîmon꞉aa dêêpî. Yi wee u kwo pi yintómu knî y꞉oo u pi yi ny꞉ee ngópu, dnyimo chaa kîgha. ");
INSERT INTO yle_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu Nasalet kwéli kaa wo, y꞉i mê diyé wo. Lîme wo dini ghi n꞉ii ngê dyimê wo, yoo yi k꞉ii ngêpê ngomo k꞉oo kee dniye. Dnye ngêpê, u kuwó dini ghi ngê kópu yilî n꞉ii Mósisi ngê a d꞉êê too, pi ngmê ngê knî ngma a kp꞉aa ngê, Yesu u nkwo ghêêdî wo, puku kpââ u l꞉êê dîy꞉o yi kada mînê ghê wo. ");
INSERT INTO yle_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chóó Lémi u kópu dyuu n꞉ii Yisaya ngê wunê a d꞉êê ngê, yi ngomo t꞉âât꞉ââ pyu ngê yi puku Yesu ka a ńuwo. Yi puku até yi pywálî ngê, ala kópu dyuu y꞉i a pyw꞉ângo, pi knî yi ngêêdî a kp꞉aa ngê, yepê, ");
INSERT INTO yle_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Chóó Lémi u Ghê Dmi ngê yinê a mbêpê kîgha nê. Yinê a ngmidi noo, a ka pê, Ngópuch꞉anê knî ye a kópu mb꞉aa chin꞉aa tpapê dé. A ka pê, Mbwa k꞉oo yélini a wee, ala kópu ye dp꞉uu vyi, Chóó Lémi ngê a pw꞉iipw꞉ii nmyo. A ka pê, Yélini my꞉oo a pyede, ala kópu ye dp꞉uu vyi, Chóó Lémi ngê nmyi ngwolo dmi a pywálîpywálî té. A ka pê, Yélini pi dono kwulo a pyede, kwulo dp꞉uu dyé té. ");
INSERT INTO yle_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","A ka pê, Pi knî ye dp꞉uu vyi ngi, Daa kêmakêma nmî Lémi ngê u yoo a ngêêpî. ");
INSERT INTO yle_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu ngê puku dmi mê kuwo ngê, ngomo t꞉âât꞉ââ pyu ka mê y꞉ângo. Chóó u ya têdê mêdaa diyé wo, yi kada mînê yaa wo, u ngwo a w꞉ee ngópu, apê, Ala ngwo a dêêpî. Ngêpê ngomo k꞉oo pi yintómu knî y꞉oo dnye y꞉enê. ");
INSERT INTO yle_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wod꞉oo dêêpî kn꞉ââ ye chópu, yepê, Kópuni nmye d꞉a kp꞉aa, awêde a chóó dî ntiye. ");
INSERT INTO yle_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kópu mb꞉aa ye yilî vyu, yi nuu u kópu ngê pyaa dniye. Noko yepê, Kî kópu mb꞉aa lónté a tpapê té, daa ndiye pyu ndîî, Njósép tp꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yi kópu u l꞉êê dîy꞉o Yesu ngê yepê, Ala mgongo kópu a ka wanmyinê vyi ngmê, a ka nye, Mumdoo nyi kpeede, ye ṉ́yóóchóó mê pyi ngi. Yepê, Ala kópu a ka am꞉ii vyi ngmê, Pi knî y꞉oo ala kópu nmo a vyi ngópu, Nê ngê kópu ndîî yilî Kîpêêniyêm a d꞉uud꞉uu ngê, a ka nye, ala ngwo yinté kópu knî nmî ngópu ngmê d꞉uu ngi, ye u ngwo ṉga wanmo kêlîmî mbê dmi. ");
INSERT INTO yle_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Pini n꞉ii ngê Chóó Lémi u komo a kapî ngê, chóó u p꞉aa tpémi y꞉oo d꞉uudpî châpu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yepê, Ala kópu ny꞉ee yó. Yepê, Ilacha u dye ghi ngê Yisîléli tpémi Chóó Lémi ka dêdnya a kêlîmî. Yepê, Chóó Lémi kéé ngópu, u komo kapî pyu Ilacha ka dêdnya a ng꞉aa. Yepê, Yi kópu u l꞉êê dîy꞉o Chóó Lémi ngê tpii dêpê gh꞉ay ngê, m꞉ââ pyile d꞉ââ wéni. Yepê, Yi ngwo m꞉uu ghê wo, nté chedê ngópu, dnye dómudómu. ");
INSERT INTO yle_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yepê, Yisîléli tpémi yi vy꞉o kuknwe yilî doo dómudómu, ngmênê Chóó Lémi ngê Ilacha ngmê ka daa dy꞉ââ ngê, Ilacha ngê daangmê ngópu. Yepê, Chóó Lémi ngê Yisîléli tpémi u ngwo mb꞉ii too, Ilacha kn꞉aa dyámê pee p꞉uu dy꞉ââ ngê, Sadepata pyââ y꞉i ngmêmî ngópu, yi m꞉uu u dye ghi ngê yi pyópu daa pwene. ");
INSERT INTO yle_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Yepê, Yinté kópu mu ala, Ilasa u dye ghi ngê, k꞉omo tpile Yisîléli tpémi yi vy꞉o pi yilî yi p꞉uu too pee mbii leprîsi doo ya, ngmênê Ilasa ngê daangmê ngópu. Yepê, Pi mu ngmidi pyi ngê, daa Yisîléli pi, u pi Naaman, Sidiya pi. ");
INSERT INTO yle_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yi ngêpê ngomo k꞉oo pi yintómu knî y꞉oo dini ghi n꞉ii ngê yi kópu ny꞉ee tumo, a w꞉ee ngópu, apê, Kî pini nmî p꞉uu a mgongo. ");
INSERT INTO yle_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","D꞉ud꞉umbiy꞉e u kwo nod꞉e dniye, ghêêdî dniye, Yesu mgîmî ngópu, kuwa ńuw꞉o ngópu. Yi p꞉aani u maknopwo paa ghi ngmêdoo ya. Yesu y꞉i ńuw꞉o ngópu, apê, Y꞉i nm꞉uu d꞉ii, apê, pw꞉oo we. ");
INSERT INTO yle_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ngmênê yi kêlê a pwii wo, yi vy꞉o mî loo. ");
INSERT INTO yle_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu Kîpêêniyêm loo, p꞉aani n꞉ii Nkálili Wee u kwo a tóó. Lîme wo knî yi k꞉oo yoo dpîmo ndiye kîgha dé. ");
INSERT INTO yle_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kópuni ye vyi too, yi nyepênyepê u kópu ngê pyaa dniye, mu kópu u dîy꞉o kópuni ye dpîmo tpapê dé, daa ndiye pyu ndîî yoo yi pi dmi mbêmê dpîmo tpapê dé, chóó u pi mbêmê dpîmo tpapê dé. Noko yipu, U kópu yilî yintómu ndê kópu dé. ");
INSERT INTO yle_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lîme wo ngmê ngê ngêpê ngomo k꞉oo pi ngmêdoo ya, kmêna u ngwo ngmêdoo kwo. Yi pini ngê yi kmêna u komo kââ, Yesu ka dpodombiy꞉e mbwolo, ");
INSERT INTO yle_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","kwo, Yesu Nasalet pi. Kwo, Lukwe nmo ngmanyi md꞉o? Kwo, Wanyi dyênê nmo? Kwo, A lama nye tóó, Chóó Lémi ngê a ngmidi nyoo, nyi u nuu u pi. ");
INSERT INTO yle_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu ngê yi kmêna ka kwo, Tumu chi ya. Kwo, Ye pini a kuwo ngi. Yi kmêna ngê yi pini yi ngópu mbwódo danê ngê, dyââpe u ngwo daa t꞉ângo, wod꞉oo yi pini a kuwo ngê. ");
INSERT INTO yle_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pi yintómu ngwéti dniye, noko yepê, Kî lónté kópu. Noko yepê, U wêdêwêdê ndîî, u pi mye ndîî, kmêna knî y꞉oo u dnye dpî ny꞉ee ngmê, u ngwo dpî ngm꞉ii kalê té. ");
INSERT INTO yle_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yi kópu dini ghi n꞉ii ngê m꞉uu ngópu, Yesu u pi ngê yi wee a ngêêdî. ");
INSERT INTO yle_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ngêpê ngomo k꞉oo dini ghi n꞉ii ngê a pwii dniye, Yesu Saimon u p꞉aa pee loo, u ngomo k꞉oo kee wo. Saimon u mbywé pyââ doo mbii, Yesu ka yuu até yedê y꞉ee ngópu, kwo, U ntââ wany꞉uu pyi? ");
INSERT INTO yle_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu u kwo loo, u nkîgh꞉ê mî ghê wo, yi mbii ka kwo, Ye pyópu a kuwo ngi. Wod꞉oo yi mbii ngê a kuwo ngê, yi pyópu mê ghêêdî wo, nté ye mê y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kââdî dini ghi n꞉ii ngê gho, yi ngwo Nju tpémi yi lîme wo machedê ngê pyodo. U kuwó dini ghi ngê yélini yi yoo dnye mbii, yi yéli y꞉oo yi pwopwokopwe yoo Yesu ka a ńuw꞉o tumo. K꞉omo tpile daa mbii ngmidi ye doo ya, ngmênê Yesu ngê kêê yi mbêmê ngmêngmênté doo yiyé, doo pyipyi dé. ");
INSERT INTO yle_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mbii pyu yoo yi vy꞉o n꞉ii knî y꞉e yi kmêna dnye kwo, yi kmêna yoo yi komo y꞉oo dnye kapî, dnye kââ, Yesu ka kópu, Nyi Chóó Lémi Tp꞉oo. Yesu ngê danêmbum ye doo kwódukwódu, mu kópu u dîy꞉o ala kópu yi lama doo ya, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, kî vyîlo. U yi u ngwo dêpwo kwo, Yi kópu pi yintómu yi lama ghêlî k꞉ii yaa we. Yesu ngê yi kmêna yintómu ngm꞉ii kalê too. ");
INSERT INTO yle_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Womumo mw꞉aa mgîdî vy꞉o, Yesu ngê kada a y꞉ângo, pi kwéli dêpwo a ya, y꞉i loo. Pi knî y꞉oo dnye nmy꞉uu. Dini ghi n꞉ii ngê a pyw꞉ee ngópu, kwo, Ṉg꞉ii mwiyé mî ya kmêle. ");
INSERT INTO yle_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yepê, Doo u ntââ ala p꞉aani u mo daanî ya. Yepê, P꞉aani p꞉aani kópu mb꞉aa ye myenîn꞉aa tpapê, Chóó Lémi kóó k꞉oo wowo p꞉uu ye nîmo danêmbum. Yepê, Yi dpodo ńedê Chóó Lémi ngê a kaa noo. ");
INSERT INTO yle_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yi dyámê pee p꞉uu p꞉aani p꞉aani dpîmo lêpî, yi ngêpê ngomo knî yi k꞉oo dpîmon꞉aa dêêpî. ");
INSERT INTO yle_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dye ghi ngmê ngê Yesu Nkenesadet Kpé Lêê u nkîgh꞉ê atédoo kwo, Chóó Lémi u kópu dyuu pi knî ye doo tpapê. Pi yilî ngê pyodo, dnye kadakada, u yi y꞉e doo kwo, Yi kópu dyuu mb꞉aamb꞉aa ngê nmî ny꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu ngê tii pââ p꞉uu dinki miyó até yi módu, woni Saimon mbwémi Andru yi dinki, woni Njems mbwémi Njon yi dinki. Yi yéli nipi dnyimo dpodo. Yesu ngê apê, Yi dinki dê atédê pêêdî d꞉oo, apê, yi peede u pwoo dê mu ghêêghêê d꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu ngê Saimon ka kwo, Saimon. Kwo, Ṉinki gh꞉ay yó, k꞉oo n꞉aa wowo, kyedekyede mu mwada y꞉i ńuw꞉o nédi, pi knî ye y꞉i nîmo dêêpî. Saimon p꞉uu y꞉oo yi kópu d꞉uu ngópu, dinki mwada kêténi ńuw꞉o ngópu, Yesu k꞉oo doo a ya, yoo u ngwo doon꞉aa ndiye kîgha dé. ");
INSERT INTO yle_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Dini ghi n꞉ii ngê Yesu ngê pi knî ye u danêmbum a kêlî ngê, Saimon ka kwo, Dinki kpé u kwo ńuw꞉o koo, pwoo y꞉i anyi kéé yó. ");
INSERT INTO yle_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon ngê kwo, Mââwe. Kwo, Ala mgîdî dp꞉o vy꞉u, pwoo k꞉oo te doo gho. Kwo, Ngmênê kópuni a ka chi vyi u l꞉êê dîy꞉o, pwoo kpé u kwo nmono kéké. ");
INSERT INTO yle_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dini ghi n꞉ii ngê pwoo kéé ngópu, te yilî a gho, daa kêmakêma te knî y꞉oo pwoo pî chaa ngópu, ");
INSERT INTO yle_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","wod꞉oo yi pyipe knî ye dnye kpede, yepê, Nmyi dinki al꞉ii a ńuw꞉o yó, anyi ngee nmédi. Wod꞉oo yi pyipe yoo y꞉i loo, mî ngee tumo, dinki dê yi k꞉oo te yilî ché ngópu, daa kêmakêma pî vy꞉êê knopwo. ");
INSERT INTO yle_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Dini ghi n꞉ii ngê Saimon Pita ngê yi kópu yi módu, Yesu yu km꞉ee dyimê wo, yu mbodo dê y꞉e k꞉ame ghê wo, Yesu ka kwo, A Lémi, kwo, nyi nmî pwo pini ndêndê. Kwo, A nkîgh꞉ê a yumwe, mu kópu u dîy꞉o nê pi dono. Kwo, Doo u ntââ a nkîgh꞉ê daanyi kwo. ");
INSERT INTO yle_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimon u yoo knî yi k꞉ii yi ngwétingwéti u kópu ngê pyodo, ");
INSERT INTO yle_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sepédi tp꞉oo dê Njems mbwémi Njon yi ngwétingwéti u kópu ngê mye pyodo. Yesu ngê Saimon ka kwo, Namê nkîngê. Kwo, Ntee nye te vyuwó yédi, mu dini ghi ngê yinté anyin꞉aa pi vyuwó. ");
INSERT INTO yle_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wod꞉oo yi dinki dê tii pââ p꞉uu a pêêdî dumo, yi tpile yilî yintómu y꞉i a kuwo tumo, Yesu u kuwó ghê dniye. ");
INSERT INTO yle_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu p꞉aa ngmê doo ya, y꞉i pi ngmê u kwo a loo. Yi pini p꞉uu too pee mbii leprîsi u ngwo doo ya. Dini ghi n꞉ii ngê Yesu módu, yu km꞉ee dyimê wo, kwodokwodombiy꞉e k꞉ame ghê wo, u kwo nkêpê mbê wo, kwo, Mââwe. Kwo, U yi ṉga choo kwo knomomê, ye u ntââ kópuni ngê tupwótupwó ngê pyódu noo, wanyi chedê. ");
INSERT INTO yle_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu ngê kêê p꞉uu yó, kwo, U ya a nga ka kwo. Kwo, Ṉ́upwó dî chedê. Yi ngwo yi mbii ngê yi pini a kuwo ngê. ");
INSERT INTO yle_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu ngê yi pini ka kwo, Kópuni ṉga dî d꞉uu, pi ngmê ka kidingê vyi. Kwo, Njedusalem dpî lili, kpêê yiyé pyu ngê amî m꞉uu ngi. Kwo, Mósisi ngê kópuni a d꞉êê ngê, yi kópu dp꞉uu d꞉uu ngi, ńmê miyó dp꞉uu ńuw꞉o ngi, kpêê yiyé pyu ka dp꞉uu y꞉ee dé, wamî nk꞉êê dê, kópuni ṉga dî d꞉uu u ngwo pêdê w꞉ee y꞉e. ");
INSERT INTO yle_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ngmênê yi pini ngê Yesu u dnye daa nyongo, p꞉êê mî chaa ngê, pi yintómu knî y꞉oo Yesu u pi mî ny꞉ee ngópu. U kuwó dini ghi ngê pi dêpwo a ya, Yesu dnye yâmuyâmu, woni knî y꞉oo u yi doo kwo, U kópu dyuu nm꞉uu ny꞉oo, woni knî y꞉oo u yi doo kwo, Nyi pyi nmîne. ");
INSERT INTO yle_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesu ngê dpîmo a kuwokuwo dé, pi kwéli dêdpîmo a ya, y꞉i dpîmo lêpî, u Mî ka y꞉i dpîmon꞉aa ngêpê. ");
INSERT INTO yle_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wo ngmê ngê Yesu ngomo ngmê k꞉oo doo kwo, yoo doo ndiye kîgha dé. Pádisi yoo, dêêpî pyu yoo y꞉i myednye kwo. Yi yéli daa p꞉aa ngmidi a ndê dniye, woni yoo Nkálili Wee u kwo a ndê dniye, woni yoo Njuda Wee u kwo a ndê dniye, woni yoo Njedusalem a ndê dniye. Pi pyipyi u l꞉êê dîy꞉o, Chóó Lémi u wêdêwêdê mbêmê Yesu u ntââ ngê doo ya. ");
INSERT INTO yle_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pi ngmê knî y꞉oo ngmîtédmi mbêmê pi ngma a dnyinê ngópu, Yesu kwéli doo ya, yi p꞉aani pee a ńuw꞉o ngópu. Yi pini kpâlî dê ntóó dê. U yi y꞉e doo kwo, Nmî pyipe Yesu u ngópu nm꞉uu tpyé, nyi pyi ngê. ");
INSERT INTO yle_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ngmênê maa dêpwo ya, pi yilî ngê pyodo, ngomo a nt꞉ee ngópu, pi kuwa mî ghay wo. Wod꞉oo yi pini ngomo pw꞉ono km꞉êê ngópu, ngomo pw꞉ono puu ngmêmînê t꞉ee ngópu, yi pini u ngmîtédmi mbêmê yedê ngê y꞉i a ghîpî ngópu, Yesu u ngîma mî yé ngópu. ");
INSERT INTO yle_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dini ghi n꞉ii ngê Yesu ngê m꞉uu too, a w꞉ee ngê, apê, N꞉ii knî y꞉oo kî pini a ka da ńuw꞉o ngmê, ndêndê ngê a ka wunê kêlîmî té. Yesu ngê yi pini ka kwo, A mbwó, ṉono yilî yintómu dî chedê, Chóó Lémi ngê mêdaawa kpada ngi. ");
INSERT INTO yle_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pádisi yoo, dêêpî pyu yoo noko dnye danêmbum, noko yepê, Kî pini ngmênê u kwo n꞉uu, u yi u ngwo a kwo, Chóó Lémi u d꞉aa nê kââdî. Noko yepê, Chóó Lémi mu ngmidi ngê yinê wa vyi, awo, Ṉono yilî dî chedê. Noko yepê, Doo u ntââ pi ngê yinté kópu d꞉uudpî vyi. ");
INSERT INTO yle_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kópuni tumu vyi tumo, Yesu ngê a w꞉ee too, yepê, Lukwe dîy꞉o yenté nmye nuu mbumu té. ");
INSERT INTO yle_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Yepê, Nê Chóó Lémi u Pi Ndêndê, u ntââ ngê yinê a pyódu noo, u ntââ dyámê mbêmê pi ka wanî vyi, Ṉono yilî dî chedê, Chóó Lémi ngê ṉono yilî u kuwó dê kéé té, mêdaawa a ngî té. Yepê, K꞉omo tpile a kópu ka módó daanmyi kêlîmî mbê dmi, ngmênê kópuni kî kpâlî ntóó ngê n꞉aa d꞉uud꞉uu, a kópu ka u ngwo nmye kêlîmî té. Wod꞉oo Yesu ngê yi kpâlî ntóó ka kwo, Gh꞉êêdé, ṉgmîtédmi a ngini, p꞉o lili. ");
INSERT INTO yle_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yi ngwo yi pini yi vy꞉o ghêêdî wo, ngmîtédmi n꞉ii mbêmê doo dpî a ngêêdî, Chóó Lémi u chaa kîgha kn꞉ââ y꞉i a chópu, u p꞉o dî. ");
INSERT INTO yle_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pi yintómu ngwéti dniye, mye nkîngê mbê dniye, apê, Nmî pwo pini nmî vy꞉o ayi kwo. Chóó Lémi chaa kalê ngópu, apê, Nyepênyepê u kópu knî awêde ngmudu m꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","U kuwó dini ghi ngê Yesu p꞉uu ndiye pyu knî yi k꞉ii kada a y꞉ee ngópu, maa p꞉uu tákisi ngêêpî pyu ngmê m꞉uu ngópu, u pi Lipi. Yi pini ndapî ngêêpî u ngomo ghi k꞉oo doo ya. Yesu ngê kwo, A ngm꞉êê nédi. ");
INSERT INTO yle_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Wod꞉oo ghêêdî wo, u tpile yintómu a kuwo ngê, Yesu u kuwó ghê wo. ");
INSERT INTO yle_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","U kuwó dini ghi ngê Lipi ngê Yesu u l꞉êê dîy꞉o kmaapî ndîî ngma a pwââ, u ngomo k꞉oo. Yi kmaapî têdê tákisi ngêêpî pyu yilî mî ta, pi yilî mye ta, nipi dnye kmaapî. ");
INSERT INTO yle_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pádisi yoo dêêpî pyu yoo daa yi nuu u kópu ngê pyodo, Yesu p꞉uu ndiye pyu knî ye yepê, Lukwe dîy꞉o tákisi ngêêpî pyu yoo kn꞉aadi te pyu yoo yi k꞉ii nmye kmaapî té, nmye mbwaa ndanî té. ");
INSERT INTO yle_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu ngê yepê, N꞉ii mb꞉aamb꞉aa dé, yi yéli ye kpeede d꞉uudpî nî. Yepê, Kpeede mbii pyu knî ye dpî lê. ");
INSERT INTO yle_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yepê, Yélini yinê ye, Nmo mb꞉aamb꞉aa dé, daa yi yéli yi dîy꞉o al꞉ii nê loo, yepê, ngmênê kn꞉aadi te pyu yoo yi dîy꞉o nê loo, yenipi, Nmyi dono kéé tóó, Chóó Lémi ka mê diyé dmyeno. ");
INSERT INTO yle_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yesu ka kwo, Njon p꞉uu ndiye pyu knî y꞉oo wiki yintómu wo miyó knî yi k꞉oo nté dpî kpîpî ngmê, Chóó Lémi ka dpodombiy꞉e u ngwo a ngêpê nyédi. Kwo, Pádisi yoo yi p꞉uu ndiye pyu knî y꞉oo yinté mye d꞉uud꞉uu ngópu. Kwo, Lukwe dîy꞉o m̱꞉uu ndiye pyu knî y꞉oo nté d꞉uudpî kpîpî ngê, dye ghi yintómu a kmaapî nyédi, a mbwaa ndanî nyédi. Kwo, Yinté myedny꞉oo d꞉uud꞉uu, nté myedny꞉oo kpîpîkpîpî. ");
INSERT INTO yle_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu ngê yepê, Wéni n꞉ii ngê pi cha dpî yéé knî, pi ngê nté pi ka d꞉uudpî kwódu. Yepê, A p꞉uu ndiye pyu yoo yi k꞉ii nmî gha dmi mb꞉aamb꞉aa ngê a pyede, doo u ntââ nté ye daanî kwódu. Yepê, Wéni n꞉ii ngê pi dpî pw꞉onu, u yoo yi gha dmi dono ngê dpî pyódu, dye ghi knî ngmê ngê nté dpî kpîpî ngmê. ");
INSERT INTO yle_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yepê, Dini ghi n꞉ii ngê a p꞉uu ndiye pyu yoo yi vy꞉o mêdaanî kwo, yi ngwo yi gha dmi yinté dono ngê wa pyódu. Yepê, Yi wéni ngê yi chóó nté wa kpîpî ngmê. ");
INSERT INTO yle_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu ngê yepê, Kópu kamî ngma atéd꞉a ńuw꞉o, nmyi l꞉êê ghi mbwee dmi daa kópu kamî yi pee dé. Mgongo ye ngmê kwólu, yepê, N꞉ii ngê kpîdî kamî dpî pwila, daawa chaa, kpîdî mbwee p꞉uu puu u ngwo daawa a kââdî. Yepê, Yi kópu wa d꞉uu knomomê, u kpîdî kamî wa dyênê, kpîdî pee kamî daa kpîdî mbwee u pee, miyó dê dono ngê wa pyaa knî. Yepê, Kpîdî pee kamî, kpîdî pee mbwee daa numo yi pee dê, myenté l꞉êê ghi mbwee a kópu kamî daa numo yi pee dê. ");
INSERT INTO yle_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yepê, Wain kamî nmye ngmêd꞉a ńuw꞉o, doo u ntââ u yiyé têdê mbwee knî yi k꞉oo daanî yé, wa dyênê té, mbwódo amî d꞉ii. ");
INSERT INTO yle_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yepê, U ntââ kamîni knî yi k꞉oo n꞉aa yiyé, daawa dyênê té. ");
INSERT INTO yle_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yepê, Wain mbwee n꞉ii nmye ndanî ngmê, u nt꞉u kópu nmyi l꞉êê ghi mbwee dé. Yepê, N꞉ii ngê wain mbwee dpî nda, kamîni dini ghi n꞉ii ngê dpî d꞉uu, dpî mb꞉ii, dpo, Wain mbwee yi mb꞉aamb꞉aa. Yepê, N꞉ii ngê u l꞉êê ghi mbwee daawa kéé té, a kópu kamî u mênê daawa yââ. ");
INSERT INTO yle_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lîme wo ngmê ngê Yesu p꞉uu ndiye pyu knî yi k꞉ii witi yâpwo têdê dnyen꞉aa paa. P꞉uu ndiye pyu knî y꞉oo witi w꞉uu mtyé dnya a ngêêpî dé, yi kêê yedê dnye vyuw꞉avyuw꞉a dé, too pee dnye wupî dé, w꞉uu u nkwo dnye pîpî dé. Daa dpodo ndîî yidnye dódó, ngmênê Pádisi knî ye yinê ye dnye dpodo, ");
INSERT INTO yle_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yesu p꞉uu ndiye pyu knî ye yepê, Lukwe dîy꞉o nmî lîme wo ngê nmye dpodo té? ");
INSERT INTO yle_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu ngê yepê, Dini ghi n꞉ii ngê Dépidi u yoo knî yi k꞉ii mudnya a dómudómu, kópuni yi ngwo a d꞉uu ngópu, angênté, yi kópu dp꞉eengê kp꞉aa ngópu? ");
INSERT INTO yle_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yepê, Dini ghi n꞉ii ngê Dépidi ngê Sóól a kuwo ngê, u yoo knî yi k꞉ii mbêpê dniye, nté daa ńuw꞉o ngópu. Yepê, Dómu ngê pî ngee too, wod꞉oo Dépidi Chóó Lémi u wónu ngomo k꞉oo kee wo, yâpwo mbîdédi knî ngma a ngêêdî, u lede knî yi k꞉ii ma tumo. Yepê, Yinté mbîdédi kpêê yiyé pyu knî y꞉oo y꞉oo dnyimo pîpî dé, doo u ntââ kn꞉aa pini ngê daapî ma too. ");
INSERT INTO yle_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yepê, Ngmênê Dépidi ka pi ngê yey ngê kêê dêpê t꞉ângo, mu kópu u dîy꞉o Chóó Lémi ngê a ngmidi ngê, king ngê a pyódu ngê. Yepê, My꞉aanté, yepê, Chóó Lémi ngê myedê ngmidi noo, nê u Pi Ndêndê. Yepê, U l꞉êê dîy꞉o nê u ntââ, lîme wo u dêêpî kópu dyuu nmye n꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lîme wo m꞉uu ngê Yesu p꞉uu ngêpê ngomo k꞉oo kee dniye, yoo doo ndiye kîgha dé. Pi yi vy꞉o ngmêdoo kwo, u wéni pee kóó ntóó. ");
INSERT INTO yle_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dêêpî pyu yoo Pádisi yoo y꞉i myednye kwo. Yi ngwolo dmi Yesu p꞉uu doo kwo, dêpê y꞉ee tumo, apê, Nmî lîme wo ngê pi ngma a pyipyi knomomê, u ngwo nmo ndyîkondyîko. ");
INSERT INTO yle_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kópuni dnye nuw꞉onuw꞉o dé, Yesu ngê a w꞉ee too, kóó ntóó ka kwo, A gh꞉êêdé, pi knî yi ngîma a nkîgh꞉ê anyinê ghé. Wod꞉oo yi pini ghêêdî wo, Yesu ka loo, yoo yi ngîma mînê ghê wo. ");
INSERT INTO yle_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu ye póó wo, yepê, Nmî dêêpî kópu dyuu lónté? Yepê, Lîme wo ngê kópu mb꞉aa ngmanyi d꞉uu, ó dono kópu ay꞉ii d꞉uu? Yepê, Pi ngmanyi ngee, ó anyi vy꞉a? ");
INSERT INTO yle_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Doo y꞉enê dé, kóó ntóó ka kwo, Ṉgêê kpêd꞉e ngi. Yinté d꞉uu ngê, kóó mb꞉aamb꞉aa ngê mê pyodo. ");
INSERT INTO yle_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yi kópu kada pini yoo yi nódo dnyinté daa kele, d꞉ud꞉umbiy꞉e u kwo nod꞉e dniye, noko yepê, Ló kópu u ngwo ngmanmî d꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","U kuwó dini ghi ngê Yesu mbu ngmê mbêmê loo, Chóó Lémi ka doon꞉aa ngêpê, mgîdî mê wââ kwólu. ");
INSERT INTO yle_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dini ghi n꞉ii ngê wa wo, p꞉uu ndiye pyu knî ye ka wo, yepê, Al꞉ii a pwiyé dmyeno. Pi y꞉a mê miyó ngmidi ngê, u dyépi ngê pyódu too. ");
INSERT INTO yle_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yi pi dmi Saimon ngmê, pini n꞉ii Yesu ngê u pi nt꞉ângo, apê, Pita. Saimon u mbwó Andru myomo, Njems mbwémi Njon pyolo podo, Pilipi Mbatolomyu limo wono, ");
INSERT INTO yle_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mátiyu Tomas pii wolo, Njems tówo, Alîpayas tp꞉oo. Saimon yono, pini n꞉ii yoo woni knî yi k꞉ii u yi y꞉e doo kwo, Lóma lede yoo nmî ngm꞉ii kalê té, mu kópu u dîy꞉o u yi y꞉e dêpwo kwo, Lóma lede knî y꞉oo dny꞉oo y꞉enê nmo. ");
INSERT INTO yle_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Njudas mê ngmê, Njems tp꞉oo. Njudas Kédiyót pi mê myomo, pini n꞉ii Yesu u kwódo ngê ghê wo. ");
INSERT INTO yle_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mbu mbêmê dini ghi n꞉ii ngê mêdê ghêpê dniye, mbu vyuwo kuwó ndîî ngmê mbêmê taa dniye. Y꞉i pi dêpwo ghêdê, Yesu u paa u dî pwaa ngópu. Yi yéli yi vy꞉o p꞉uu ndiye pyu yilî doo kwo. Yélini Yesu ka lee dniye, daa p꞉aa ngmidi a ndê dniye, Njuda Wee u kwo p꞉aani p꞉aani a ndê dniye, Njedusalem tpémi myedê lee dniye. Ntii chedê yoo myedê loo, Taiya p꞉aani dê Saidon a ndê dniye. Yi yéli daa Nju tpémi. ");
INSERT INTO yle_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Woni knî y꞉e u yi doo kwo, Yesu u dêêpî kópu dyuu nm꞉uu ny꞉oo, woni knî y꞉e u yi doo kwo, Nyi pyi nmîne. Wod꞉oo Yesu ngê pyi too. Yélini kmêna knî y꞉oo dyênê tumo, mye pyi too. ");
INSERT INTO yle_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","N꞉ii knî y꞉oo kêê p꞉uu dnyimo yiyé, u wêdêwêdê mbêmê dnyimo pyiyépyiyé. Yi kópu u l꞉êê dîy꞉o yoo dnye kadakada. ");
INSERT INTO yle_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","U kuwó dini ghi ngê Yesu ngê p꞉uu ndiye pyu yoo doo y꞉enê dé, yepê, K꞉omo tpile nmyo pinté yoo, ngmênê nmyi gha dmi mb꞉aamb꞉aa ngê choo ya, mu kópu u dîy꞉o Chóó Lémi ngê yinê a ngmidi nmyoo, kóó k꞉oo wa kaa nmyo. ");
INSERT INTO yle_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yepê, K꞉omo tpile ala ngwo nmye dómudómu té, ngmênê nmyi gha dmi mb꞉aamb꞉aa ngê choo ya, mu kópu u dîy꞉o dîyo wanmy꞉uu pile dmi. Yepê, K꞉omo tpile ala ngwo nmye mbê té, ngmênê nmyi gha dmi mb꞉aamb꞉aa ngê choo ya, mu kópu u dîy꞉o dîyo anmyin꞉aa yumu. ");
INSERT INTO yle_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Yepê, K꞉omo tpile nê Chóó Lémi u Pi Ndêndê, ngmênê a l꞉êê dîy꞉o pi knî ye wanmyi diya dmi, wa mb꞉ii nmyo, amye kéé nmyo. ");
INSERT INTO yle_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yepê, Yi dono vy꞉o nmyi gha dmi mb꞉aamb꞉aa ngê dpî pyaa dniye, myoo pywálî dniye, dono ngê kîngî pyaa dmi, mu kópu u dîy꞉o yi mgînî vyîmî u pywuu mb꞉aa wanmyimo ngee ngmê, mbóó p꞉uu. Yepê, Yi kópu daa nmyi mo nmye wa pyódu. Yepê, Yinté kópu knî yi kn꞉ââ knî y꞉oo Chóó Lémi u komo kapî pyu knî y꞉e wunê kîmyedê d꞉uu tumo. ");
INSERT INTO yle_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yepê, N꞉ii dé ndáápi yoo, dmyinê nkîngê. Yepê, K꞉omo tpile nmyi ndapî ndîî dé, mb꞉aamb꞉aa ngê nmye pyede, ngmênê dîyo yi kópu machedê ngê wa pyaa dmi, dono anmyinê pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yepê, N꞉ii dé u ntââ mbêmê nmye pyede, dmyinê nkîngê, dîyo anmyin꞉aa dómudómu. Yepê, N꞉ii dé a yumu té, dmyinê nkîngê, dîyo anmyin꞉aa mbê. ");
INSERT INTO yle_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Yepê, Pi yintómu knî y꞉oo adnyi chaa kîgha nmyomomê, ye dmyinê nkîngê. Yepê, Yélini y꞉oo Chóó Lémi u komo ndêndê ngê dnyimo a kapî, pi knî y꞉oo dêdnyimo a chââchââ dé. Yepê, Yélini y꞉oo yi chóó yi kópu dyuu dnyimo a tpapê dé, pi knî y꞉oo vyîlo yidnyimo chaa kîgha dé. ");
INSERT INTO yle_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu ngê yepê, Yélini a ka nmyinê ng꞉aa té, ala kópu ny꞉ee yó. Yepê, K꞉omo tpile pi knî y꞉oo dono nmye adnyi d꞉uud꞉uu, ngmênê ntââ ye nangê vy꞉u. Yepê, Yélini ye anmyi diya dmi, yi nuu ghi dmi nmyi nódo choo ya, kópu mb꞉aa y꞉e dmyinê d꞉uud꞉uu dé. ");
INSERT INTO yle_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yepê, N꞉ii ngê dono nmye wa d꞉uu, u l꞉êê dîy꞉o dmyinê ngêpê. Yepê, N꞉ii ngê nmyi mgapî u yi adî kwo, u mb꞉aamb꞉aa Chóó Lémi ka moo dmy꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yepê, Pini n꞉ii ngê nmyi teknâpwo dê dêê knomomê, wopee u kwo my꞉oo y꞉ee yó, y꞉i myedo dêê ngê. Yepê, Pi ngê nmyi nkuwo kpîdî dê t꞉âmo knomomê, nmyi mbwo kpîdî myoo t꞉âmo ngê, u kwo nangê kwódu. ");
INSERT INTO yle_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yepê, N꞉ii ngê tpileni nmye dê dmy꞉ee knomomê, u kwo dpî y꞉ee yó. Yepê, Pini n꞉ii ngê nmyi tpile ngmêdê ngî knomomê, u kwo nangê vyi, A ka mêdê ki. ");
INSERT INTO yle_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yepê, Kópuni u yi nmye adnyi kwo, Pi knî y꞉oo nmo dny꞉oo d꞉uud꞉uu dé, yi kópu y꞉e mwiyé dmyinê d꞉uud꞉uu dé. ");
INSERT INTO yle_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yepê, Yélini yi nódo nmyi nuu ghi dmi a tóó, yi yéli yi mo yi nuu ghi dmi nmyi nódo adî ya knomomê, nmyinê nmye kópu ndîî ayinmyi d꞉uud꞉uu? Yepê, Lukwe, nmyinê nmye Chóó Lémi ngê yi kópu mb꞉aamb꞉aa ngê nmye wa pwila? Yepê, Kêle, Pi dono knî y꞉oo yi kópu dpî d꞉uu ngmê. Yepê, Ngmênê pi yintómu yi nuu ghi dmi nmyi nódo choo ya. ");
INSERT INTO yle_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yepê, Nmyi yoo knî yi k꞉ii anmyi numo ngêêpî knomomê, yi kópu Chóó Lémi ka daa ndîî kópu. Yepê, Yoo dono mye yinté dé, a numo ngêêpî nyédi. Yepê, N꞉ii dé doo u ntââ dé, daawa ngee nmyo, wanmyi ngee t꞉oo, ye Chóó Lémi ngê kópu mb꞉aa nmye ngmêwa d꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yepê, Pi ka ndapî anyi y꞉oo, u kuwó dini ghi ngê amoo wumo knomomê, Chóó Lémi ka yi kópu daa ndîî kópu. Yepê, Yoo dono y꞉oo yi kópu mye d꞉uud꞉uu ngópu, noko ndapî a yémî ngópu, numo piy꞉e mê wumwe nyédi. Yepê, Ngópuch꞉anê knî ye ndapî ngmanmyi y꞉ee ngmê, wumwe u pi ye daanmyi vyi ngmê, ye Chóó Lémi ngê kópu mb꞉aa nmye ngmêwa d꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yepê, Ala kópu kamî dmyinê d꞉uud꞉uu. Yepê, Yélini y꞉oo dono nmye a d꞉uud꞉uu ngópu, ye mêdmyinê mb꞉aamb꞉aa. Yepê, Ngópuch꞉anê knî ye ndapî dmyinê yémî, wumwe u pi ye mênangê vyi. Yepê, Yinté anmyi d꞉uud꞉uu, ye u Dîghê Lémi ntee a tóó, yinté anmyi ya. Yepê, K꞉omo tpile yoo dono dé, Chóó Lémi daa kwunokwuno ngópu, ngmênê kópu mb꞉aa ye yilî wunê d꞉uud꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yepê, Nmyi Mî ka yoo ntee dpî ch꞉anê dmi, yinté yoo nmye myedny꞉oo ch꞉anêch꞉anê. ");
INSERT INTO yle_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesu ngê yepê, Pi u pi módó nangmê dyênê, nmyi pi dmi u nkwo daawa dyênê t꞉oo. Yepê, Pi knî yi kn꞉aadi te kópu ndîî ngê nangmê pyódu, nmyi kn꞉aadi te kópu ndîî ngê u nkwo daawa pyódu t꞉oo. Yepê, Pi knî yi dono kópu nmyi kuwó dpî kéé tóó, nmyi dono kópu yinté yi kuwó u nkwo wa kéé t꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yepê, Ngópuch꞉anê yoo dmyinê yeedeyeede dé, Chóó Lémi ngê u nkwo ada a yeedeyeede nmyo, mtîkó ngê kêê nmye daawa a t꞉oo, mb꞉aamb꞉aa ngê wa a nt꞉ââ. Yepê, Pi knî ye angêntoo yeedeyeede ayinmyi kîgha, Chóó Lémi ngê yintoo yeedeyeede nmye amyedê kwolo. ");
INSERT INTO yle_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu ngê mgongo ye ngmê kwólu, yepê, Ngwolokopwe kwulo pini n꞉ii a ya yédi, yi pini ngwolo dê dono ngê myekîngî pyaa knî. Yepê, Miyó dê ngwolo kopwe dê, ye lónté adpî paa? Yepê, Maa wa kn꞉aadi ngmê, dnyinté ghê amî dyimê knî. Yepê, N꞉ii ngê u yi adî kwo, Pi knî ye maa mb꞉aa nê kêma, yi pini u lama maa mb꞉aamb꞉aa ngê choo ya, yi máádi kîngî kn꞉aadi. ");
INSERT INTO yle_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yepê, Pwoo l꞉âmol꞉âmo n꞉ii ngê nmyi nuw꞉o adî kîgha, doo u ntââ yi pini u kada daanmyimo y꞉aa dmi. Yepê, Kópuni yilî u mênê adnyi ya, anmyi ndê t꞉oo, doo u ntââ kn꞉aa kópu daamunmyi ndê ngmê. Yepê, N꞉ii ngê u yi adî kwo, Yoo yi l꞉êê ghi dmi nî wáti té, yi pini u dono kópu kîngmê ya, mu kópu u dîy꞉o yi kópu dmi p꞉uu amye ndê ngmê. ");
INSERT INTO yle_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Yepê, Kn꞉aa pini ngîma tpile kmono pee ngmadî ya knomomê, lukwe dîy꞉o ndîî kópu ngê nmye wa pyódu? Yepê, Nmyi lama daadî ya tpile kmono pee ndîî nmyi ngîma mye pyede. ");
INSERT INTO yle_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Yepê, Lukwe dîy꞉o yi pini ka wanmyi vyi ngmê, Nmî mbwó, tpile kmono pee ṉgîma nmo wupî. Yepê, Lukwe dîy꞉o nmyi lama daa tóó nmyi chóó nmyi ngîma tpile kmono pee ndîî mye pyede. Yepê, Nmyo k꞉omodanê pyu yoo. Yepê, Tpile kmono pee ndîî nmyi ngîma mwiyé dpo ngî tóó, u kuwó dini ghi ngê yélî mb꞉aamb꞉aa ngê am꞉ii m꞉uu ngmê, nmyi mbwó ngîma tpile kmono pee u ngwo dpî wêê yó. Yepê, Nmyi chóó nmyi dyââpe mwiyé daanmyi pwaa t꞉oo, ye kn꞉aa yéli yi dyââpe nangê pwaa té. ");
INSERT INTO yle_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesu ngê mgongo ye ngmê kwólu, yepê, Chikini n꞉ii nkwodo kîgha nj꞉iinj꞉ii yu kaa dmi, pwópwó yi yini nkwodo d꞉uudpî kaalî, myenté pwópwó n꞉ii nkwodo dpî kaa dmi, kîgha nj꞉iinj꞉ii nkwodo mêd꞉uudpî kaalî. ");
INSERT INTO yle_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yepê, Chikini n꞉ii chóó dpî pyidu, ḻama daadî ya, mb꞉aamb꞉aa ó dono, nj꞉iinj꞉ii ó pwópwó. Yepê, Dini ghi n꞉ii ngê dpî dââ, kîgha anyi d꞉uu, u ngwo anyinê w꞉ee, anye, Kî chikini mb꞉aamb꞉aa, kîgha nj꞉iinj꞉ii dé. Yepê, Myenté, L꞉êê yini nkwodo kéme kîgha daanyinê ngee, dpumo nkwodo t꞉aa kîgha myedaanyinê ngee. ");
INSERT INTO yle_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yepê, Yoo myenté. Yepê, Kópuni ngê pi u gha dpo nt꞉ono, yi kópu vyîlo ye tpapê ngê. Yepê, N꞉ii mb꞉aamb꞉aa, kópu mb꞉aa knî y꞉oo u gha dpo nt꞉ee ngmê, kópu mb꞉aa ye tpapê too. Yepê, N꞉ii dono, kópu dono knî y꞉oo u gha dpo nt꞉ee ngmê, kópu dono ye tpapê too. ");
INSERT INTO yle_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesu ngê yepê, Lukwe dîy꞉o a pi ndîî ngê nmye pyépi ngmê, a ka nmyimo, Nmî Lémi. Yepê, A dnye daa nmyi ng꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yepê, Pini n꞉ii a ka wunê lêpî yédi, a kópu dyuu wumê ng꞉aang꞉aa ngê, myewumê chââchââ too, yi pini p꞉uu mgongo nmye ngmên꞉aa kîgha. ");
INSERT INTO yle_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yepê, Ngomo dini ghi ngê dpî wó, k꞉ââ u mgî mb꞉aamb꞉aa ngê dpo tpênê té, k꞉ââ kn꞉ââ mb꞉aamb꞉aa ngê dpî wiye té, ngomo wêdêwêdê kpetekpete yu wó. Yepê, K꞉omo tpile ló yópu ndîî ngmêdo pwópu, ngmênê yi ngomo d꞉uudpî tpaa. ");
INSERT INTO yle_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yepê, N꞉ii ngê a kópu dyuu dpî ny꞉oo, daa chââchââ too, yi pini p꞉uu mgongo nmye my꞉oon꞉aa kîgha. Yepê, Yi pini ngê u ngomo dnyinté dpî wó, k꞉ââ u mgî dnyinté dpî ché té, k꞉ââ kn꞉ââ dnyinté dpî wiye té. Yepê, Yópu ndîî dini ghi n꞉ii ngê dpo pwópu, u ngomo lîmî k꞉ii dpî tpaa, dpî tpikimbiy꞉e. ");
INSERT INTO yle_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Dini ghi n꞉ii ngê Yesu ngê pi knî ye u danêmbum a kêlî ngê, yed꞉oo Kîpêêniyêm loo. ");
INSERT INTO yle_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lóma lede yoo yi kada pini ngmê y꞉i doo ya. Yi pini u dpodo pyu yoo yi vy꞉o u dpodo pyu ngmê, u nuu u pi, doo mbii, daa kêmakêma doo pwopwo. ");
INSERT INTO yle_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Dini ghi n꞉ii ngê kada pini ngê Yesu u pi nyongo, Nju tpémi yi ngêpê ngomo u kada pini knî u kwo ngmê dy꞉ââ ngê, yepê, Ala kópu u kwo nyi vyi yó, U ntââ wa a lê, a dpodo pyu amî pyi. ");
INSERT INTO yle_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yesu ka a lee dniye, yi kópu u kwo mî vyi ngópu, kwo, K꞉omo tpile daa Nju pi, Lóma pi, ngmênê pi mb꞉aa. Kwo, U ntââ u dpodo pyu wany꞉uu pyi. ");
INSERT INTO yle_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kwo, Nmî yoo Nju tpémi yi k꞉ii nmî nuu ghi dmi mb꞉aamb꞉aa ngê u nódo a tóó, chóó u ndapî ndîî kéé ngê, nmî ngêpê ngomo u ngwo nmî wó. ");
INSERT INTO yle_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wod꞉oo Yesu ngê ngm꞉êê too. Kada pini u ngomo chedê daa kêmakêma dnye taataa, kada pini ngê u pyipe yoo Yesu ka m꞉uu dy꞉ââ ngê, kwo, Kada pini ngê atéda dy꞉ââ nmo, nmodê, Nyi a ngomo k꞉oo kîdangê nî, mu kópu u dîy꞉o d꞉aa u ntââ, nmodê, doo u ntââ a ngomo k꞉oo daawa a kee. ");
INSERT INTO yle_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nmodê, Yi kópu u l꞉êê dîy꞉o u kwo d꞉oo n꞉ee. Nmodê, Nyi muchoo a ya, ngmênê kópu ngma a vyi ngê, a dpodo pyu u ngwo a pyiyépyiyé. ");
INSERT INTO yle_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nmodê, Kópuni nyi ngê wunê tpapê, ndêndê ngê a pyodopyodo. Nmodê, Kópuni a kada pini ngê a ka dpo vyi, dpî d꞉uu. Nmodê, Kópuni a lede knî ye dpî vyi, dpî d꞉uu ngmê. Nmodê, Kópuni a dpodo pyu ka dpî vyi, ntênê dpî d꞉uu. Nmodê, Nyi ngê a dpodo pyu u l꞉êê dîy꞉o pyiyépyiyé u pi a vyi ngê, yed꞉oo u ngwo wumê pyiyépyiyé. ");
INSERT INTO yle_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Dini ghi n꞉ii ngê Yesu ngê yi kópu dyuu yi nyongo, u nyepênyepê u kópu ngê u kwo pyaa dniye. Pini n꞉ii knî y꞉oo dnye yâmuyâmu ye diyé wo, yepê, Yisîléli tpémi yi vy꞉o wuntoo kêlîmî pyu d꞉oongmê módu. ");
INSERT INTO yle_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kada pini ngê yélini Yesu ka dy꞉ââ too, dini ghi n꞉ii ngê u ngomo k꞉oo diyé dniye, apê, Kada pini u dpodo pyu kîmaa pyiyé. ");
INSERT INTO yle_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","U kuwó dini ghi ngê Yesu, p꞉uu ndiye pyu yoo, pi mê yilî yi k꞉ii p꞉aa ngmê lee dniye, u pi Néénî. ");
INSERT INTO yle_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Dini ghi n꞉ii ngê yi p꞉aani chêêpî mbwa chedê taa dniye, yi p꞉aani tpémi y꞉oo pi ntóó kuwa ngma a pw꞉ii ngópu, u kmênêkmênê têdê dnye ńeńe. Pini n꞉ii ntóó dnye dnyinêdnyinê, yi pini kuknwe ngmê tp꞉oo, u tîdê mbwó dêpwomu ya, d꞉o mu ngmidi. Yi p꞉aani pi yilî yi kuknwe u k꞉ii dnye ya. ");
INSERT INTO yle_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dini ghi n꞉ii ngê nmî Lémi ngê yi kuknwe módu, u kwo ch꞉anê wo, kwo, Namê mbê. ");
INSERT INTO yle_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wod꞉oo ntóó u pyinê ngwódu, ngmîtédmi p꞉uu kêê yó. N꞉ii knî y꞉oo dnye dnyinêdnyinê yi paa u dî dmi puwâ, wod꞉oo Yesu ngê yi pini ntóó ka kwo, Kî pini, a dnye nyeni, a pyidu, ntênê yey. ");
INSERT INTO yle_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wod꞉oo yi pini a pii wo, ntênê yaa wo, danêmbum kn꞉ââ mê chópu, Yesu ngê u pye ka mê y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pi yintómu nkîngê mbê dniye, Chóó Lémi dnye chaa kîgha, noko yepê, Chóó Lémi u komo kapî pyu ndîî nmî vy꞉o ngmatédê t꞉aa. Noko yepê, Chóó Lémi ngê u yoo y꞉enê kn꞉ââ da chaa. ");
INSERT INTO yle_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kópuni Yesu ngê d꞉uu ngê yi wee u kwo p꞉aani p꞉aani yi nuwo yaa wo, Njuda Wee u kwo p꞉aani p꞉aani yi nuwo mye yaa wo. ");
INSERT INTO yle_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Dini ghi n꞉ii ngê Njon Baptist mbwa k꞉oo doo kwo, chóó p꞉uu ndiye pyu knî y꞉oo Yesu ngê kópuni yilî doo d꞉uud꞉uu, u kwo a nté tumo, wod꞉oo Njon p꞉uu ndiye pyu miyó ye mbwolo, ");
INSERT INTO yle_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nmî Lémi ka dy꞉ââ doo, yepê, U kwo dpî póó cho, kwipi, Pini n꞉ii nmo t꞉âât꞉ââ, mumdoo nyi vyîlo ó kn꞉aa pini yuno t꞉âât꞉ââ? ");
INSERT INTO yle_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dini ghi n꞉ii ngê Yesu ka lee knopwo, kwo, Njon Baptist ngê ṉga atédê dy꞉ââ nyo, nyedê, U kwo dpî póó cho, kwipi, Pini n꞉ii nmo t꞉âât꞉ââ, mumdoo nyi vyîlo ó kn꞉aa pini yuno t꞉âât꞉ââ? ");
INSERT INTO yle_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yi ngwo dini ghi ngê, yi tpódu yi ngópu Yesu ngê mbii pyu daa ngmidi pyi ngê, woni yi mbii u mo u mo dé, ngwolo kopwe daa ngmidi mye pyi ngê. Yélini y꞉e yi kmêna dnyimo kwo, yi kmêna ye ngm꞉ii kalê too. ");
INSERT INTO yle_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Njon p꞉uu ndiye pyu dê ye yepê, Kópuni dpî m꞉uu t꞉oo, kópuni dpî ny꞉ee t꞉oo, yi kópu yilî Njon ka dpumo nté tóó. Yepê, U kwo dp꞉uu vyi nyoo, kwipi, Kópuni yilî Yisaya ngê wunê a d꞉êê too, nê ngê ka ntiyentiye té. Kwipi, Yélini dêdnyimo vyuwo, yélî mêka y꞉enê ngmê. Kwipi, Yélini dêdnyimo m꞉ii, mêka paa té. Kwipi, Yélini yi p꞉uu too pee mbii doo ya, kîmaa pyi té. Kwipi, Yélini ngwene pwââ dé, dnye mêka nyêmî ngmê. Kwipi, Yélini pw꞉oo dniye, mêkîyedê pyidupyidu té. Kwipi, Ngópuch꞉anê knî y꞉oo Kópu Mb꞉aa a nyêmî ngmê. ");
INSERT INTO yle_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kwipi, Pini n꞉ii ngê a wépi daawa a puwâ, mb꞉aamb꞉aa wa a pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Dini ghi n꞉ii ngê Njon p꞉uu ndiye pyu dê y꞉oo kada a y꞉ee ngópu, Njon ka mê diyé knopwo, Yesu pi knî ye Njon p꞉uu doo danêmbum, yepê, Dini ghi n꞉ii ngê Njon w꞉amî mbêmê modoo a dpodo, lukwe u pyinê y꞉i nmyi ngm꞉êê ngópu? Yepê, Mumdoo u yi nmye doo kwo, Nmîn꞉aa yópu u dnye nyêmî? Yepê, Kêle. ");
INSERT INTO yle_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yepê, Lukwe u pyinê y꞉i nmyi ngm꞉êê ngópu? Yepê, Pini n꞉ii u kpîdî mb꞉aa dé u pyinê nmyi ngm꞉êê ngópu? Yepê, Kêle. Yepê, Pini n꞉ii u kpîdî mb꞉aa dé, u nté ndapî yilî, w꞉amî mbêmê daa dpodo yédi, yi pini king p꞉uu a ya yédi, ngomo mb꞉aa k꞉oo a kwo yédi. ");
INSERT INTO yle_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yepê, A ka vyi yó. Yepê, Lónté pini u pyinê y꞉i nmyi ngm꞉êê ngópu? Yepê, Chóó Lémi u komo kapî pyu ngmê, apii? Yepê, Nyââ, yi pini yi vyîlo, ngmênê Chóó Lémi u komo kapî pyu yintómu mêdê kuwo too, yi pwo pini ngê mê tóó. ");
INSERT INTO yle_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yepê, Dini ghi n꞉ii ngê Chóó Lémi ngê ala kópu a ka a vyu, u komo kapî pyu ngmê ngê yi ngwo a d꞉êê ngê, apê, A kópu y꞉eey꞉ee pyu ṉgada wanî kââ, m̱aa yinê amînê yé. ");
INSERT INTO yle_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu ngê yepê, Njon ngê a maa a yó, yoo mbwee yi pwo pini ngê u ngwo pyodo, ngmênê n꞉ii yoo a yoo kamî vy꞉o wa ghê dmi, Njon amêdê kuwo ngmê, u pwo pini ngê amê pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yepê, Tákisi ngêêpî pyu yoo, pi yilî mye yi k꞉ii, Njon u kópu dyuu ny꞉ee ngópu, apê, Ndê kópu, apê, Chóó Lémi u maa mb꞉aa kînmî kn꞉aadi ngê. Yepê, Yi yéli yintómu Njon ngê mbápitisîm kalê too, ");
INSERT INTO yle_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ngmênê Pádisi yoo, dêêpî pyu yoo yi k꞉ii Chóó Lémi u maa kn꞉aadi ngópu, Njon u wépi pwaa ngópu. ");
INSERT INTO yle_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yepê, Yi yéli lónté yéli. Yepê, Lukwe dîy꞉o Njon u wépi pwaa ngópu, a wépi myaa pwaa ngmê. Yepê, Nganê pyu yoo. ");
INSERT INTO yle_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yepê, Yi p꞉uu n꞉aa mgongo. Yepê, Tp꞉ee ngmê ngê u mbwó knî ye wa vyi, yewo, Tpile we a nté koo, u kwo wa nganê mbê dmi. Yepê, Ala kópu u nkwo ye wa vyi, yewo, Pi ntóó kmênêkmênê a nté koo, yi kópu u wépi u kwo amye pwaa ngmê. Yepê, Nganê pyu yoo. ");
INSERT INTO yle_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yepê, Pádisi yoo, dêêpî pyu yoo mye yinté yéli, nganê pyu yoo. Yepê, K꞉omo tpile Njon Baptist ngê nté dpîmo kpîpîkpîpî, wain myedêdpîmo ndanî, Chóó Lémi u kópu dyuu ye dpîmo tpapê, ngmênê u wépi pwaa ngópu, ala kópu p꞉uu vyi ngópu, apê, Kmêna u ngwo ngma kwo, kêdê ghéti. ");
INSERT INTO yle_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yepê, K꞉omo tpile nté dînî kpîpîkpîpî ngê, wain n꞉aa ndanî ngê, ngmênê a wépi myaa pwaa ngmê, ala kópu a p꞉uu dpî vyi ngmê, dpo, Nkéli ńuknwe nmye yila, mye nkéli mbwaa ndanî pyu ndîî. Dpo, Tákisi ngêêpî pyu yoo pi dono yoo yi pyipe. Yepê, Njon u wépi kêdê pwaa ngmê, a wépi kîmyaa pwaa ngmê. Yepê, Ló kópu u yi y꞉e m꞉uu a kwo. ");
INSERT INTO yle_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yepê, Ngmênê n꞉ii Chóó Lémi u nuw꞉o mbêmê a dpodo yédi, u dpodo nt꞉u dpî kaalî, pi knî y꞉oo u ngwo pêdê w꞉ee y꞉e, yi pini Chóó Lémi u dpodo pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pádisi ngmê, u pi Saimon, Yesu ka kwo, A p꞉aa pee nté dp꞉uu ndii, wod꞉oo yi pini u ngomo k꞉oo kee dniye, kmaapî têdê dnye ya. ");
INSERT INTO yle_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yi p꞉aani pyââ ngmêdoo ya, mââ ti módó. Yi pyópu ngê yi nyongo, apê, Yesu Saimon u ngomo k꞉oo ka tóó, u k꞉ii ka kmaapî té. Yi pyópu ngê pód꞉a ngma a ńuwo, tuu mb꞉aamb꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Saimon u ngomo k꞉oo kee wo, Yesu u nkîgh꞉ê mî ghê wo, yu km꞉ee dyimê wo, y꞉i doo mbê, Yesu yu kpâpu dê ngimi ngê a ndê doo. Dini ghi n꞉ii ngê mbê a kêlî ngê, mbodo gh꞉aa dmi pywálî ngê, Yesu yu dê u ngwo mê pyi doo, mye nt꞉uu kalê doo, tpileni d꞉ââ a ńuwo, yu kpâpu dê yi mbêmê a pii ngê. ");
INSERT INTO yle_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yi Pádisi ngê dini ghi n꞉ii ngê módu, u gha vy꞉o apê, Kî pini ngê Chóó Lémi u komo ndêndê ngê wo kapî, ye pyópu n꞉ii ngê a vyêpîvyêpî, pêdê w꞉ee, pêdê, Kî pyópu ngê pyââ dono, u wépi paa puwâ. ");
INSERT INTO yle_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu ngê Pádisi ka kwo, Saimon. Kwo, Kópu ṉga ngmên꞉aa tpapê. Saimon ngê kwo, Mââwe. Kwo, Vyi ngi. ");
INSERT INTO yle_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu ngê kwo, Pi miyó dê y꞉oo ndáápi ngmê ka ndapî knî ngmê dmy꞉ee ngópu, kwo, Dîyo am꞉ii wumo té. Yesu ngê kwo, Woni ngê limoy꞉a dmy꞉ee ngê, woni ngê limo yono y꞉a dmy꞉ee ngê. ");
INSERT INTO yle_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kwo, Yi pini dê y꞉e wumwe doo u ntââ ngê pyodo, wod꞉oo yi ndáápi ngê yi tpódu yi tp꞉uu dê chóó mêdê kêlî doo. Kwo, Saimon. Kwo, Ṉga n꞉aa póó. Kwo, Ló pini nódo yi ndáápi u nuu ghi ntênê wa yââ? ");
INSERT INTO yle_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon ngê kwo, Ndoo. Kwo, N꞉ii u tp꞉uu ndîî yedê kêlî ngê. Yesu ngê kwo, Ndê kópu yichi vyi. ");
INSERT INTO yle_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yi pyópu ka diyé wo, Saimon ka kwo, Ala pyópu p꞉uu chi nuw꞉o. Kwo, Dini ghi n꞉ii ngê ṉgomo k꞉oo d꞉a kee, mbwaa a ka choo kpo, a yi dê u ngwo pîdî ghêê dê, ngmênê ala pyópu ngê mbê n꞉ii dê kwolo, u ngimi ngê a yi dê u ngwo dê ghêê dê, chóó u mbodo gh꞉aa dmi ngê maa pyi dê. ");
INSERT INTO yle_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kwo, Dnyinté che chipé nê, ṉ́꞉uu a kpââ pee p꞉uu choo dyîngo, ngmênê yidî t꞉aa ala pyópu ngê a yi dê yi p꞉uu muka nt꞉uu, doongê yó. ");
INSERT INTO yle_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kwo, Dnyinté che chipé nê, olipi wulu a mbêmê choo yó, ngmênê ala pyópu ngê tpileni d꞉ââ da ńuw꞉o, tuu mb꞉aa, a yi dê yi mbêmê da pii. ");
INSERT INTO yle_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kwo, Ndê kópu ṉga ngmên꞉aa tpapê. Kwo, Ala pyópu ngê kópu mb꞉aa n꞉ii yilî a nga dê d꞉uu, u ngwo d꞉a w꞉ee, d꞉ê, Ala pyópu nódo a nuu ghi dnyinté daa tóó, mu kópu u dîy꞉o u tp꞉uu ndîî kîd꞉a kêlî, u dono yilî dî chedê té. Kwo, N꞉ii u tp꞉uu daa ndîî yed꞉a kêlî, a nuu ghi ṉódo dnyinté a tóó. ");
INSERT INTO yle_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu ngê yi pyópu ka kwo, Ṉono yilî dî chedê té. ");
INSERT INTO yle_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yélini yi kmaapî têdê dnye ya, noko yepê, Kî pini ngmênê u kwo n꞉uu? Noko yepê, Mumdoo dono dpî chedê té? ");
INSERT INTO yle_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ngmênê Yesu ngê yi pyópu ka kwo, A ka che kêlîmî mb꞉anê, ṉono yilî u ngwo dî chedê té. Kwo, Ṉono yilî mênangê nuw꞉onuw꞉o dé, chi lêpî, mb꞉aamb꞉aa ngê mêchin꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","U kuwó dini ghi ngê Yesu p꞉uu ndiye pyu y꞉a mê miyó knî yi k꞉ii p꞉aani p꞉aani lee dniye, Chóó Lémi kóó k꞉oo wowo p꞉uu kópu mb꞉aa pi knî ye dpîmon꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pyââ ngmê knî y꞉oo Yesu mye ngm꞉êê ngópu. Yi pyópu yoo woni knî Yesu ngê wunê a pyi too, woni knî y꞉e yi kmêna mye ngm꞉ii kalê too. Yi pyópu knî yi vy꞉o pyââ pyile doo kwo, yi pi dmi Méli Makîdala pyââ ngmê, Yesu ngê pyópuni u kmêna pyudu knî wunê a ngm꞉ii kalê too. ");
INSERT INTO yle_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Pyââ myomoni u pi Njówana, u moo u pi Chusa, King Helodi p꞉uu dpodo pyu yoo yi kada pini. Pyââ pyoloni u pi Susana. Yi pyópu knî y꞉oo yi chóó yi ndapî dnyimo kéké, Yesu p꞉uu ndiye pyu knî yi k꞉ii u ngwo dnyimo mbonombono dé. ");
INSERT INTO yle_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pi yilî tp꞉oo témi tap Yesu ka loo, daa p꞉aa ngmidi a ndê dniye. Dini ghi n꞉ii ngê nipi a wó, Yesu ngê mgongo ye ngmê kwólu, yepê, ");
INSERT INTO yle_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Pi ngmê witi w꞉uu nt꞉ene têdê loo, têpê mwiyé chó, witi w꞉uu y꞉i u nkwo doo dimi dé. Yepê, Witi w꞉uu woni dé maa p꞉uu mî dyimê dniye, yoo yi pwo doo m꞉ii, ńmê knî y꞉oo ma tumo. ");
INSERT INTO yle_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yepê, Witi w꞉uu woni dé t꞉aanî mbêmê mî dyimê dniye, têpê mdoo kwéli dêpwo ya. Yepê, Dini ghi n꞉ii ngê pii dniye, kââdî ngê nt꞉ââ too, mu kópu u dîy꞉o têpê daa nt꞉umunt꞉umu, nkumu u mênê dêpwo ya. ");
INSERT INTO yle_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yepê, Witi w꞉uu woni dé tpyé vy꞉o mî dyimê dniye, y꞉i mî pii dniye, tpyé ngê ma too. ");
INSERT INTO yle_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yepê, Witi w꞉uu woni dé têpê ghi mb꞉aa mbêmê mî dyimê dniye, y꞉i mî pii dniye, yi nt꞉u dmi mb꞉aamb꞉aa ngê kaa dniye, yintómu yi nkwodo yonoy꞉a yonoy꞉a kele. Dini ghi n꞉ii ngê mgongo ye a kêlî ngê, dpodombiy꞉e ye mbwolo, yepê, Kópuni nmye dî vyi, yi kópu mb꞉aamb꞉aa ngê dmyinê nuw꞉onuw꞉o. ");
INSERT INTO yle_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesu p꞉uu ndiye pyu yoo Yesu ka póó dniye, kwo, Mgongoni chi kwolo, u nt꞉u kópu lukwe? ");
INSERT INTO yle_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu ngê yepê, Chóó Lémi kóó k꞉oo wowo, tumu kópu ngê doo ya. Yepê, Yi tumu kópu yilî nmye wanî tpapê dé, ngmênê kn꞉aa yéli ye nt꞉u p꞉uu daana a dêêdêê, ye anî mgongo, mu kópu u dîy꞉o k꞉omo tpile dpî m꞉uu ngmê, d꞉uudpî mya ngmê, dpî ny꞉ee ngmê, myed꞉uuwodê w꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Mgongoni dî kwolo, ala u nt꞉u kópu. Yepê, Witi w꞉uu pi ngê ntee a dimi too, pi ngê Chóó Lémi u kópu dyuu pi knî ye yinté a tpapê too. Yepê, Yi kópu pi woni knî yi mênê nt꞉u dpî kaalî, woni knî yi mênê nt꞉u d꞉uudpî kaalî. ");
INSERT INTO yle_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yepê, Witi w꞉uu woni knî maa p꞉uu ntee dpî dyimê dmi, ńmê knî y꞉oo ntee dpî ma t꞉oo, yepê, pi woni knî yinté wêdêwêdê dé, yi ngópu dmi dpî kuwo t꞉oo, kópu yi gha vy꞉o d꞉uudpî kee, yi nt꞉u dmi d꞉uudpî kaalî, mu kópu u dîy꞉o Setan ngê yi kópu dpî t꞉âmo té. ");
INSERT INTO yle_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yepê, Witi w꞉uu woni knî t꞉aanî mbêmê ntee dpî dyimê dmi, w꞉uu dpî pii dmi, lîmî k꞉ii ngê moo pw꞉oo dmi, yepê, pi woni knî yinté dé, dini ghi n꞉ii ngê Chóó Lémi u kópu dpî ny꞉ee ngmê, yi gha dmi mb꞉aamb꞉aa ngê dpî pyódu, ngmênê yi kópu daa dye ghi daadîî yi gha vy꞉o a ya yédi. Yepê, Yi tókótókó têdê lîmî k꞉ii ngê dpo ghay dmi, u ngwo dpî kpîpî nê. ");
INSERT INTO yle_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yepê, Witi woo woni knî tpyé ngê ntee dpî ma té, yepê, pi woni knî yinté dé, Chóó Lémi u kópu dyuu dpî ny꞉ee ngmê, ngmênê dyámê u tpile knî y꞉oo Chóó Lémi u kópu dyuu yinté dpî ma ngmê. Yepê, Yi yéli nté ndapî, tpile yilî yi p꞉uu a nuw꞉o nyédi, Chóó Lémi p꞉uu daa nuw꞉o nyédi, yi gha vy꞉o u kópu dyuu nt꞉u d꞉uudpî kaalî. ");
INSERT INTO yle_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yepê, Witi woo woni knî têpê mb꞉aa mbêmê yi nt꞉u dmi mb꞉aamb꞉aa ngê ntee dpî kaalî, yepê, pi woni knî yinté dé, yoo mb꞉aa, Chóó Lémi u dnye y꞉oo a nyêmî ngmê, Chóó Lémi d꞉uudpî kpîpî ngmê, yi nt꞉u dmi mb꞉aamb꞉aa ngê dpî kaalî. ");
INSERT INTO yle_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu ngê mgongo ye m꞉uu kwólu, yepê, Dini ghi n꞉ii ngê mgîdî dpo ghay, n꞉ii ngê lam dpo vyuwó, doo u ntââ tpile u pwo k꞉ame daawa kââ, mu kópu u dîy꞉o lukwe ngê mgîdî wa chaa. Yepê, Yi pini ngê lam dpo y꞉oo, ya nkwodo dpî kââ. Yepê, Yélini u kwo dpî lee dmi, tpile yilî u ngwo dpî m꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yepê, Tumu kópu yintómu dîyo wa a pywálî dmi, ngmee u kópu dyuu wamyedê pywálî dmi. ");
INSERT INTO yle_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yepê, A ka ntênê dmyina a ng꞉aa, a kópu dyuu mb꞉aamb꞉aa ngê dmyina a wopwe, mu kópu u dîy꞉o n꞉ii ngê a kópu dyuu wa a w꞉ee, dîyo knî m꞉uu u kwo wanî y꞉oo. Yepê, N꞉ii ngê a kópu dyuu daawa a w꞉ee, têdêni kópu ayedê w꞉ee, yi kópu l꞉âmo wa ngee, u nuwo wa a kuwo. ");
INSERT INTO yle_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu kwéli doo dêêpî, u pye ghee knî y꞉i taa dniye. U yi y꞉e doo kwo, Nm꞉uu m꞉uu. Doo u ntââ ngê ye pyodo, mu kópu u dîy꞉o Yesu yoo vy꞉o a gho. ");
INSERT INTO yle_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pi ngmê ngê Yesu ka kwo, M̱ye ghee knî kuwa ka wee, ka poopoo ngi. ");
INSERT INTO yle_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ngmênê Yesu ngê yepê, N꞉ii knî y꞉oo Chóó Lémi u kópu dyuu mb꞉aamb꞉aa ngê a nyêmî ngmê, yini yoo yi niye ghee knî. ");
INSERT INTO yle_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wo ngmê ngê Yesu, p꞉uu ndiye pyu knî yi k꞉ii, dinki k꞉oo até yi wo dniye. Yesu ngê yepê, Kpé lêê mwada pee lee kmêle. Wod꞉oo kada a y꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dini ghi n꞉ii ngê kédi ngópu, wod꞉oo Yesu dpî wo. U kuwó dini ghi ngê yópu ndîî ngma a pwaa wo, vyuwó ndîî ngê pyaa dniye, daa kêmakêma dinki pî vy꞉êê wo, pwopwo yidnye nuw꞉onuw꞉o. ");
INSERT INTO yle_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wod꞉oo Yesu u dpî ny꞉ââ ngópu, kwo, Mââwe, Mââwe. Kwo, Awêde nmo pwopwo té. Yesu yedê pii wo, vyuwó yópu ye yepê, Munto. Yi ngwo vyuwó yópu chedê ngê pyaa knopwo, dye ndîî mê kââ. ");
INSERT INTO yle_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","P꞉uu ndiye pyu knî ye yepê, Lukwe dîy꞉o a ka dp꞉ee kêlîmî té. Ngwéti dniye, nkîngê ngê y꞉ay꞉a mye pwiyé dniye, noko yepê, Kî lónté pini? Noko yepê, Vyuwó yópu y꞉oo u dnye kêdê ny꞉ee ngmê, kîmyaa châpu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","U kuwó dini ghi ngê Yesu p꞉uu Nkálili Kpéni Lêê mwada pee yimî tee dniye, Nkedîsa tpémi kwéli dnya a ya. ");
INSERT INTO yle_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu lyoko yi ghay wo, yi p꞉aani pi u kwo ngma a loo, kmêna yilî u ngwo doo kwo. Yi pini ngê u p꞉aa ló dini a kuwo ngê, kn꞉ââ mbwii dpîmo m꞉ii. Kpomo u mênê, pi ntóó kwéli dnyimo yiyé dé, yi kpomo knî yi mênê dpîmo kwo. ");
INSERT INTO yle_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Dini ghi n꞉ii ngê Yesu módu, yu km꞉ee dyimê wo, dpodombiy꞉e u kwo mbwolo, kwo, Yesu. Kwo, Yâpwo Ndîî Tp꞉oo. Kwo, Lukwe a nga ngmanyi md꞉o? Kwo, Ṉga atédê nkêpê mb꞉anê, nangê kpada nê. ");
INSERT INTO yle_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yi kópu u kwo vyu, mu kópu u dîy꞉o Yesu ngê kmêna ka mwiyé vyu, kwo, Ye pini a kuwo ngi. Daa ng꞉êêntómu yi kmêna ngê yi pini dpîmo mbêpê kîgha. K꞉omo tpile yi p꞉aani tpémi y꞉oo yi pini dnyimo mgîmîmgîmî, kóó yu puwóma ti ngê dnyimo kudukudu dé, ngmênê mêdpîmo pwapî dé, pi kwéli dêdpîmo a ya, yi kmêna ngê y꞉i dpîmo ńeńe. ");
INSERT INTO yle_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu u kwo póó wo, kwo, M̱i n꞉uu? Yi pini ngê kwo, Nmî pi dîdyênî. Yi kópu vyu, mu kópu u dîy꞉o kmêna yilî u ngwo doo kwo. ");
INSERT INTO yle_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yi kmêna knî y꞉oo Yesu ka kwo, Munmîkó, nmî kpadakpada têdê nangê dy꞉ââ nmo. ");
INSERT INTO yle_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mbwêmê w꞉uu ndîî yi nkîgh꞉ê ngmêdoo kwo, w꞉amî mbêmê dnye kmaapî. Yi kmêna yoo Yesu ka nkêpê mbê dniye, kwo, U ntââ kî mbwêmê w꞉uu vy꞉o wanyi dy꞉ââ nmo. Yesu ngê yepê, U ntââ. ");
INSERT INTO yle_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wod꞉oo yi kmêna knî y꞉oo yi pini a kuwo ngópu, mbwêmê knî yi p꞉uu mî kaa dniye. Yi mbwêmê w꞉uu yintómu paa ghi p꞉uu ghîpîla dniye, kpé lêê u kwo mî dyimê dniye, wod꞉oo vy꞉êê dniye. ");
INSERT INTO yle_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pini n꞉ii yoo mbwêmê w꞉uu ka dnye vyuwo, dini ghi n꞉ii ngê yi kópu m꞉uu ngópu, mbêpê dniye, yi p꞉o lee dniye, pi knî ye mdoo ńuw꞉o ngópu, ghi yintómu mye lee dniye, pi knî ye mdoo mye ńuw꞉o ngópu. ");
INSERT INTO yle_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","N꞉ii knî y꞉oo yi kópu ny꞉ee ngópu, u yi y꞉e doo kwo, Yi kópu nm꞉uu m꞉uu, wod꞉oo Yesu ka lee dniye. Pini n꞉ii u kmêna ngm꞉ii kalê too, Yesu yu km꞉ee doo ya, apê, Nmo ntee pini ngê mêka tóó, mêdaa ghétighéti, kpîdî u paa mêka t꞉a. Nkîngê ngê y꞉ay꞉a u ngwo pwiyé dniye. ");
INSERT INTO yle_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yélini yi ngópu Yesu ngê yi pini u kmêna ngm꞉ii kalê too, wo yéli ye yi kópu a nté ngópu. ");
INSERT INTO yle_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nkedîsa Wee u kwo tpémi d꞉ud꞉umbiy꞉e nkîngê ngê y꞉ay꞉a pwiyé dniye, wod꞉oo Yesu ka nkêpê mbê dniye, kwo, U ntââ anyinê kuwo nmo. Wod꞉oo Yesu p꞉uu dinki k꞉oo wo dniye, apê, Kada nmo y꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pini n꞉ii u kmêna yoo Yesu ngê ngm꞉ii kalê too, yi pini ngê Yesu ka kwo, U ntââ wanî ngm꞉êê ngi? Ngmênê Yesu ngê kwo, Kêle, chi ya. ");
INSERT INTO yle_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Kwo, P꞉o mê dini, Chóó Lémi ngê kópu ndîî n꞉ii ṉga dê d꞉uu, pi knî ye chin꞉aa tpapê. Wod꞉oo kada a y꞉ee ngópu. U kuwó dini ghi ngê yi pini yi wee u kwo p꞉aani p꞉aani loo, Yesu ngê kópuni u ngwo d꞉uu ngê, pi knî ye doon꞉aa a nj꞉ii. ");
INSERT INTO yle_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Dini ghi n꞉ii ngê Yesu p꞉uu y꞉oo Nkálili Kpéni Lêê ngmêê ngópu, Nkálili Wee u kwo mî tee dniye, pi yilî m꞉uu ngópu. Yi yéli y꞉oo Yesu dnye t꞉âât꞉ââ, mînê tipé ngópu. ");
INSERT INTO yle_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pi ngmê u pi Njayidus, ngêpê ngomo u y꞉enê pyu ngmê, yi ngwo y꞉i mye ta. Yesu yu km꞉ee mî dyimê wo, u kwo nkêpê mbê wo, kwo, U ntââ a p꞉o ṉg꞉ii mwiyé am꞉ii lee knî. ");
INSERT INTO yle_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yi kópu Yesu ka dmy꞉ee ngê, mu kópu u dîy꞉o tp꞉oo módó doo a mbii, daa kêmakêma doo pwopwo. Yi dmââdî u tîdê mbwó dêpwomu ya, u m꞉ââ y꞉a mê miyó ngê doo ya. Wod꞉oo Yesu yi pini u kuwó ghê wo. Pi mê yilî yi k꞉ii lee dniye, maa p꞉uu dnye kadakada, u yi y꞉e doo kwo, U nkîgh꞉ê nm꞉uu ghê dmi. ");
INSERT INTO yle_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pyââ yi vy꞉o ngmêdoo kwo, kmene muwó. Dye ghi yintómu yinté dpîmo ya, m꞉ââ y꞉a mê miyó ndîî, wêê p꞉uu dêpê vyâ. K꞉omo tpile kpeede yilî p꞉uu dnyimo dpodo, ngmênê dêdnyimo pyipyi. ");
INSERT INTO yle_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yi pyópu Yesu u kuwó a ta, u kpîdî p꞉uu kêê a yó, wod꞉oo wêê a vyâ. ");
INSERT INTO yle_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu ngê yepê, Kêê a p꞉uu n꞉aa dê yé? Pi yintómu knî y꞉oo a wópu ngópu. Pita ngê kwo, Mââwe, mêkidimê póó. Kwo, Pi kînga dîdyênî. ");
INSERT INTO yle_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngmênê Yesu ngê kwo, Daa ye kópu p꞉uu n꞉aa danê. Kwo, Pi ngmê ngê kêê a p꞉uu kêdê yé, u l꞉êê dîy꞉o a wââ u ngwo dê kee. ");
INSERT INTO yle_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yi pyópu ngê apê, Até ngê da pywálî nê, wod꞉oo nkîngê mbê wo, Yesu yu km꞉ee mî dyimê wo. Kópuni u l꞉êê dîy꞉o Yesu p꞉uu kêê yó, u ngwo pyiyé wo, pi yintómu yi ngêêdî Yesu ka a nté ngê. ");
INSERT INTO yle_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu ngê kwo, A ch꞉am, a ka che kêlîmî mb꞉anê, u ngwo chi pyiyé. Kwo, Yi kópu machedê, u nuw꞉onuw꞉o ngê kêê kîdangê t꞉oo. Kwo, P꞉o mê dini. ");
INSERT INTO yle_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu ngê u danêmbum ghêlî dêpê kêlî ngê, Njayidus u ngomo k꞉oo pi ngma a ndê wo, Njayidus ka kwo, Ṉ́m꞉ee módó ngê pi ṉga da dy꞉ââ. Kwo, Doo u ntââ kî mââwe ngê mêdaawa ngee ngi. Kwo, Ngomo k꞉oo mêkidingê ńuw꞉o. ");
INSERT INTO yle_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu ngê yi kópu yi nyongo, ngmênê Njayidus ka kwo, Namê nkîngê. Kwo, Chi kêlîmî, mê pyiyépyiyé. ");
INSERT INTO yle_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Dini ghi n꞉ii ngê ngomo chedê taa dniye, Yesu ngê ngomo k꞉oo pi daa kmungo, ngmênê Pita, Njems mbwémi Njon, yi dmââdî u pye mî yi k꞉ii vyîlo dé yi km꞉êê too. ");
INSERT INTO yle_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pi yintómu knî y꞉oo yi dmââdî ntóó dnye mbumu, u l꞉êê dîy꞉o myednye mbê. Yesu ngê mgongo ye ngmê kwólu, yepê, Munto mbê. Yepê, Ye dmââdî doo pwene, ngmênê a dpî. ");
INSERT INTO yle_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yesu dnye yumuyumu, mu kópu u dîy꞉o yi lama doo ya, apê, Kêdê pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ngmênê Yesu yi dmââdî kwulo kele, kwo, Kî dmââdî, a pyidu. ");
INSERT INTO yle_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wod꞉oo u ghê dmi u kwo mêdê diyé wo, yi ngwo mêdê pii wo. Yesu ngê u pye mî ye yepê, Nté pee u kwo ngmê y꞉ee nyoo. ");
INSERT INTO yle_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","U pye mî yi nyepênyepê u kópu ngê pyodo, ngmênê Yesu ngê ye kwódu ngê, yepê, Kópuni dî d꞉uu, pi knî ye nangê vyi. ");
INSERT INTO yle_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu ngê p꞉uu ndiye pyu y꞉a mê miyó nipi a danê ngê, yepê, A pi ngê n꞉aa dyede nmyo, u ntââ ngê myinê pyépi nmyo, anmyin꞉aa pi pyipyi, n꞉ii knî y꞉e yi kmêna a wee, yi kmêna anmyin꞉aa ngm꞉ii kîgha dé. ");
INSERT INTO yle_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yepê, Pi knî ye n꞉aa dyede nmyo, ala kópu ye dmyinên꞉aa tpapê, yipi, Dini ghi n꞉ii nmo t꞉âât꞉ââ, Chóó Lémi ngê chóó u ngwo ada a y꞉enê nmo, yi dini ghi daa kêmakêma a dyimêdyimê. Yepê, Myedmyinên꞉aa pi pyipyi. ");
INSERT INTO yle_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yepê, Nmyi tpile nangmê ńuw꞉o. Yepê, Nmyi kiyé nangmê ńuw꞉o, nmyi tpile péé nangmê ńuw꞉o, nté nangmê ńuw꞉o, ndapî nangmê ńuw꞉o, nmyi nkuwo kpîdî myomoni myenangmê ńuw꞉o. ");
INSERT INTO yle_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yepê, P꞉aani p꞉aani pi miyó miyó dpî lee we. Yepê, P꞉aani n꞉ii pini n꞉ii dê d꞉uu taa knomomê, ngomoni k꞉oo adpî koko, y꞉i dny꞉oo ya, u dî yi p꞉aani mêdny꞉oo a kuwokuwo. ");
INSERT INTO yle_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yepê, Pini n꞉ii dê p꞉aani n꞉ii adpîn꞉aa taataa, yi p꞉aani tpémi y꞉oo yi yi dê y꞉e daachoo kwo knomomê, yepê, yi dnye dê daadnyimo nyêmî knomomê, ye yi pini dê y꞉oo yi p꞉aani dny꞉oo a kuwokuwo, yi p꞉aani u têpê yi yi yodo p꞉uu dny꞉oo vyavya. Yepê, Yi p꞉aani tpémi y꞉oo ala kópu u ngwo wa a w꞉ee ngmê, awo, Yinê ye dp꞉oo Nju tpémi, dp꞉oo Chóó Lémi u yoo. ");
INSERT INTO yle_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wod꞉oo Yesu p꞉uu ndiye pyu knî y꞉oo Yesu a kuwo ngópu, p꞉aani p꞉aani lee dniye, Yesu p꞉uu kópu mb꞉aa pi knî ye dnyen꞉aa tpapê, myednyen꞉aa pi pyipyi. ");
INSERT INTO yle_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Dini ghi n꞉ii ngê yi kópu dnyimo pyodopyodo, Antipas Helodi Nkálili tpémi yi king ngê doo ya. Yi kópu knî yi pi dmi yi nyongo, u nuw꞉o yilî ngê u ngwo u kwo pyodo, mu kópu u dîy꞉o pi ngmê knî y꞉oo kópu, Njon Baptist kîmêdê pyidu. ");
INSERT INTO yle_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Woni knî y꞉oo kópu, Ilacha kîmaa t꞉aa, woni knî y꞉oo kópu, N꞉ii knî y꞉oo Chóó Lémi u komo wunê dnyimo a kapî, ngmê kêda pyidu. ");
INSERT INTO yle_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helodi ngê u gha vy꞉o apê, Njon Baptist mbwámê kînî châpwo. Apê, Pini n꞉ii u kópu dyuu n꞉aa nyêmî té, apê, wu n꞉uu? Apê, Yi pini a chóó u nkwo ngêp꞉aa m꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dini ghi n꞉ii ngê Yesu ka u dyépi yoo mêdê diyé dniye, kópuni mî d꞉uu tumo, u kwo mînê nté tumo. Yesu ngê yi mo ńuw꞉o too, p꞉aa ngmê mî tee dniye, u pi Mbetîsaida. ");
INSERT INTO yle_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yoo yi nt꞉anê kada a y꞉ee ngópu. Kwéli mî tee dniye, yoo ndîî y꞉i mye loo. Yesu ngê a chipé too, Chóó Lémi kóó k꞉oo wowo p꞉uu ye doo danêmbum, n꞉ii dé dnye mgînî vyîmî mye pyi too. ");
INSERT INTO yle_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dini ghi n꞉ii ngê kââdî t꞉ono ghê wo, p꞉uu ndiye pyu y꞉a mê miyó knî u kwo lee dniye, kwo, Kî yéli mê dy꞉ââ té, p꞉aani p꞉aani dny꞉oon꞉aa nté pywupwi, yi chóó yi dpî têdê dmi ngmênyinê pyw꞉ee y꞉e, mu kópu u dîy꞉o daa p꞉o nmo pyede. ");
INSERT INTO yle_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngmênê Yesu ngê yepê, Nmyi chóó nté pee knî ye ngmê y꞉ee yó. Kwo, Doo u ntââ. Kwo, Yintoo ntini nmî ngópu daa tóó. Kwo, Mbîdédi tp꞉oo limi, te miyó nmî ngópu ka pyede, mê ntini daamo a tóó. Kwo, U yi ṉga a kwo, Kî yéli yi ntââ ntini anm꞉uu pwila? ");
INSERT INTO yle_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Mââ limo yono yono y꞉a y꞉i doo ya.) Yesu ngê p꞉uu ndiye pyu knî ye yepê, Pi yêê yó, yoo ngmê limoy꞉a, yoo ngmê limoy꞉a a pyódu yó, mbwódo yaa dniye. ");
INSERT INTO yle_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yinté d꞉uu ngópu, mbwódo yaa kalê tumo. ");
INSERT INTO yle_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu ngê mbîdédi limi knî a ngî too, te dê myedê ngî doo, mbóó p꞉uu vyu wo, Chóó Lémi yi l꞉êê dîy꞉o kwuno ngê, pwaa too, p꞉uu ndiye pyu knî ye y꞉ee too, apê, Pi knî ye yee téne. ");
INSERT INTO yle_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pi yintómu doo kmaapî, yi ghê dmi a kee wo. Nté kmono n꞉ii mî kê wo, Yesu p꞉uu ndiye pyu knî y꞉oo péé y꞉a mê miyó mê ntówo ngópu. ");
INSERT INTO yle_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wo ngmê ngê Yesu u mo até yidoo ngêpê, p꞉uu ndiye pyu yoo u kwo yedê lee dniye, ye póó wo, yepê, Pi knî ye yinê ye nê n꞉uu? ");
INSERT INTO yle_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kwo, Ngmê knî y꞉oo alanté a tpapê ngmê, apu, Nyi Njon Baptist. Kwo, Ngmê knî y꞉oo alanté a tpapê ngmê, apu, Nyi Ilacha. Kwo, Ngmê knî y꞉oo alanté a tpapê ngmê, apu, N꞉ii knî y꞉oo Chóó Lémi u komo wunê dnyimo a kapî, ngmêkêda pyidu, nyi vyîlo. ");
INSERT INTO yle_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu u nkwo ye póó wo, yepê, Nmyinê nmye nê n꞉uu? Pita ngê kwo, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, nmî Mbwámê ngê a pyódu ngê, nyi vyîlo. ");
INSERT INTO yle_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu ngê yi kópu dpodombiy꞉e ye kwódu ngê, yepê, Pi ka nangê vyi. ");
INSERT INTO yle_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu p꞉uu ndiye pyu knî ye chóó p꞉uu ye modoo danêmbum, yepê, K꞉omo tpile nê Chóó Lémi u Pi Ndêndê, yinê a ngmidi noo, ngmênê kada pini knî y꞉oo wa mb꞉ii nê, kpêê yiyé pyu yoo yi kada pini knî y꞉oo wa mb꞉ii nê, dêêpî pyu knî y꞉oo wamye mb꞉ii nê. Yepê, Yi yéli y꞉oo dono kópu yilî a nga wa d꞉uu ngmê, wa vya nê, wo pyoloni ngê amênê pyidu. ");
INSERT INTO yle_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesu ngê pi yintómu knî ye yepê, N꞉ii ngê u yi adî kwo, Nê u yoo vy꞉o nî ghê, yi pini ngê choo a yâmuyâmu nê, u gha d꞉ud꞉umbiy꞉e a ka dpo kê ngê, chóó u kópu knî yi p꞉uu mêkîngê nuw꞉o, k꞉omo tpile a l꞉êê dîy꞉o adî wélîlî mgînî vyîmî, ngmênê dpo ngm꞉êê nêne. ");
INSERT INTO yle_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yepê, Pini n꞉ii u ghê p꞉uu adî nuw꞉o, awo, Kîngî vya nê, u ngwo wa kede, a yoo vy꞉o daawa ghê, yepê, yi pini ndêndê ngê wa pw꞉onu, ndê ngê amî ma. Yepê, Pini n꞉ii a l꞉êê dîy꞉o wa pw꞉onu, yi pini amêdê pyidu, ghê kamî u ngwo wa a pyw꞉oo, mb꞉aamb꞉aa ngê adîn꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yepê, Pini n꞉ii chóó u tpile knî yi p꞉uu adî nuw꞉o, u l꞉êê dîy꞉o Chóó Lémi wa mb꞉ii, yi pini dini ghi n꞉ii ngê wa pw꞉onu, yed꞉oo dono wa a pyw꞉oo. Yepê, K꞉omo tpile dyámê u tpile yintómu yi pini u ngópu adî ya knomomê, ngmênê doo u ntââ ghê kamî u ngwo daawa pwila, dono wa a pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yepê, Dini ghi n꞉ii ngê a l꞉êê dîy꞉o nmyi p꞉uu adnyi d꞉uu, n꞉ii ngê wa mb꞉ii nê, yewo, Nê kuu, nangê kpada nê, yepê, yi pini u nkwo wanî mb꞉ii, dini ghi n꞉ii ngê anê diyé. Yepê, Yi dini ghi ngê a pi ndîî ngê wa pyódu, M꞉aa, u enjel knî yi k꞉ii yi pi dmi ntoo, a pi yintoo ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Pi knî nmyi vy꞉o ngma a kwo, ghêlî daawa pw꞉oo dmi, Chóó Lémi ngê chóó nmyi y꞉enê kn꞉ââ mwiyé wa chaa. ");
INSERT INTO yle_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wiki ngmê mî loo, Yesu ngê u dyépi pyile njini mbu mbêmê ńuwo, y꞉i dnyen꞉aa ngêpê. Yi pini pyile knî yi pi dmi Pita, Njems mbwémi Njon. ");
INSERT INTO yle_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dini ghi n꞉ii ngê Yesu doo ngêpê, kwódo ng꞉oo dmi tpalê wo, u kpîdî d꞉ud꞉umbiy꞉e kpaapîkpaapî ngê pyodo, myedoo a wuu mbele. ");
INSERT INTO yle_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yi ngwo pi miyó Yesu u k꞉ii dnye danêmbum, yi pi dê Mósisi pini dê Ilacha. ");
INSERT INTO yle_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yi tpódu myedpîmo a wuu mbele. Mósisi ngê Nju tpémi dono vy꞉o Yichip u mênê ntee a pw꞉ii too, Yesu u lama doo ya, Daa kêmakêma yinté kópu Njedusalem ngmênîmo d꞉uud꞉uu. Yi kópu p꞉uu dnye danêmbum. ");
INSERT INTO yle_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Yi dini ghi ngê Pita u pyipe dê yi k꞉ii dnye dpî. Yi nyaa dniye, Yesu u wuu yi pwo yimî kéé ngê, Yesu u nkîgh꞉ê Mósisi pini dê Ilacha m꞉uu dumo. ");
INSERT INTO yle_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dini ghi n꞉ii ngê yi tpódu y꞉oo Yesu dpîmo a kuwokuwo, Pita ngê Yesu ka kwo, Mââwe. Kwo, U p꞉o chi yé, cha ńuw꞉o nmo. Kwo, Ngomo pee pyile nmînê t꞉emî, kwo, ṉêni ngmê, Mósisi u nêni ngmê, Ilacha u nêni ngmê. Ngmênê doo u lama doo mbumu. ");
INSERT INTO yle_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita ngê danêmbum ghêlî dêpê kêlî ngê, wod꞉oo nkalî too pee yi pwo ngmê yó, nkîngê ngê y꞉ay꞉a pwiyé dniye. ");
INSERT INTO yle_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yi nkalî too pee u mênê dnye ngmê ny꞉ee ngópu, yepê, Kî a Tp꞉ee, a chóó nê ngmidi ngê, u kwo ntênê dmyinê ng꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yi dnyeni machedê ngê yi pyodo, apê, Yesu u mo mu kwo. Kópuni yi ngópu pyodo, pi ka ghêlî daa vyi ngópu. Yi kópu tumu yi mênê doo ya. ");
INSERT INTO yle_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Womumo mw꞉aandiye, dini ghi n꞉ii ngê Yesu u dyépi pyile knî yi k꞉ii mbu vyuwo a ghêpê dniye, pi yilî Yesu ka loo. ");
INSERT INTO yle_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yi yéli yi vy꞉o Yesu ka pi ngma a ka wo, kwo, Mââwe. Kwo, U ntââ a tp꞉ee mu ngmidi wany꞉uu m꞉uu? Kwo, Ṉga daawa ch꞉anê? ");
INSERT INTO yle_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kwo, Dini ghi n꞉ii ngê u kmêna ngê dpî vy꞉a, a kââ yédi, ntóó têpê mbêmê dpî d꞉ii, tpî ch꞉aa pee dê u kwo dpî pwii knî. Kwo, Dye ghi yintómu yi kmêna ngê a tp꞉ee dpodombiy꞉e a kpakakpaka ngê. ");
INSERT INTO yle_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kwo, M̱꞉uu ndiye pyu knî ye kîdî nkêpê mb꞉anê, yed꞉ê, U ntââ wu kmêna anmyi ngm꞉ii kalê ngmê? Kwo, Ngmênê doo u ntââ ngê y꞉e dê pyódu. ");
INSERT INTO yle_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu ngê yepê, Nmyo lónté yéli. Yepê, Nmyo yoo dono, lukwe dîy꞉o Chóó Lémi ka dp꞉ee kêlîmî té. Yepê, M꞉ââ yémi nmyi vy꞉o anî kwo, u dî Chóó Lémi ka mb꞉aamb꞉aa ngê anmyin꞉aa kêlîmî. Yi pini ka kwo, Ṉ́m꞉ee al꞉ii a ńuw꞉e. ");
INSERT INTO yle_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dini ghi n꞉ii ngê yi tpémi Yesu u kêténi doo lêpî, u kmêna ngê dpodombiy꞉e vyâ, têpê mbêmê danê ngê. Yesu ngê yi kmêna ngm꞉ii kwólu, yi tpémi pyi ngê, u mî ka mê y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pi knî y꞉oo dini ghi n꞉ii ngê yi kópu m꞉uu ngópu, ngwéti dniye, Chóó Lémi u pi ndîî ngê u ngwo pyódu ngópu. Yesu ngê pi knî yi ngópu kópuni doo d꞉uud꞉uu dé, pi knî y꞉oo yi kópu dnyimo nyepênyepê dé, ngmênê Yesu ngê p꞉uu ndiye pyu knî ye yepê, ");
INSERT INTO yle_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ala kópu nmyi nuwo kîdangê kuwo, yepê, K꞉omo tpile nê Chóó Lémi u Pi Ndêndê, ngmênê yoo dono yi kêê k꞉oo wanî ghê. ");
INSERT INTO yle_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","P꞉uu ndiye pyu yoo alanté dnye nuw꞉o, apê, Lukwe dîy꞉o kînté nmo a mbumu. Apê, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, u pi ndîî ngê wa pyódu, dono daawa a pyw꞉oo. Yinê ye ngmee u kópu ye yi vyu, dêpê w꞉ee ngópu, u kwo myedaa póó dniye, mu kópu u dîy꞉o nkîngê mbê dniye. ");
INSERT INTO yle_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesu p꞉uu ndiye pyu yoo noko dnye kwopwepe. Yi vy꞉o pini n꞉ii u pi ndîî ngê doo ya, yi kópu p꞉uu dnye kwopwepe. ");
INSERT INTO yle_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tumu kópuni dnye tpapê dé, Yesu ngê a w꞉ee too, wod꞉oo tp꞉ee ngma a ngêêdî, u nkîgh꞉ê kââ, yepê, ");
INSERT INTO yle_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Pini n꞉ii alanté tpémi ka a l꞉êê dîy꞉o adî vyuwo, daa yi tpémi ka u mo adî vyuwo, ngmênê a ka amyeda a vyuwo, amyedî chââchââ nê. Yepê, Myenté, Pini n꞉ii ngê adî chââchââ nê, daa a mo adî chââchââ nê, ngmênê pini n꞉ii ngê a dy꞉ââ noo, amyedî chââchââ. Yepê, Nmyi vy꞉o pini n꞉ii u pi daa ndîî, vyîlo yi pini yidmyinê chââchââ. ");
INSERT INTO yle_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Njon ngê Yesu ka kwo, Mââwe. Kwo, Pi ngmêkudu m꞉uu, kwo, m̱i ngê pi knî yi kmêna kî ngm꞉ii kîgha té. Kwo, Yi kópu u kwo kudu kwódu, mu kópu u dîy꞉o daa nmî yoo vy꞉o pini ngmê. ");
INSERT INTO yle_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu ngê yepê, U kwo nangê kwódu. Yepê, N꞉ii nmî p꞉uu daa d꞉uu yédi, nmî pee pini. ");
INSERT INTO yle_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dini ghi n꞉ii ngê Yesu ngê a w꞉ee ngê, apê, Daa kêmakêma a dye ghi dyámê mbêmê machedê ngê a pyodopyodo, pi knî y꞉oo Njedusalem wa vya nê, ye daa kede wo, p꞉uu ndiye pyu knî yi k꞉ii paa u nuw꞉o Njedusalem mê yé ngópu. ");
INSERT INTO yle_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Maa p꞉uu p꞉aa ngmê u nkîgh꞉ê taa dniye, Samédiya tpémi yi p꞉aa ngmê. Yesu ngê u yi doo kwo, Y꞉i nm꞉uu dpî dmi, wod꞉oo pi kada miyó kââ, apê, Tpile yilî nmî kada paan꞉aa l꞉âmo y꞉e. ");
INSERT INTO yle_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ngmênê yi p꞉aani tpémi y꞉oo u wépi pwaa ngópu, mu kópu u dîy꞉o Njedusalem dnye lêpî. Apê, Yinê ye nmo yoo dono. Apê, Lukwe dîy꞉o ala p꞉aani wa dpî dmi. ");
INSERT INTO yle_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Dini ghi n꞉ii ngê Njems mbwémi Njon y꞉oo yi kópu ny꞉ee ngópu, nod꞉e knopwo, Yesu ka kwo, Nmî Lémi, Chóó Lémi ka ala kópu vyi koo, Mbóó p꞉uu ndyuw꞉e ngma a ghêpê we, wu p꞉aani tpémi ndê ngê paa ma téne. ");
INSERT INTO yle_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ngmênê Yesu ye diyé wo, yi kópu ye kwódu ngê, ");
INSERT INTO yle_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","wod꞉oo kn꞉aa p꞉aani mê lee dniye. ");
INSERT INTO yle_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dini ghi n꞉ii ngê maa p꞉uu dnye paa, pi ngmê ngê Yesu ka kwo, Kwéli anyi lê, ana a yâmuyâmu ngi. ");
INSERT INTO yle_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu ngê kwo, Mumdoo anya a yâmuyâmu nê? Kwo, Chii w꞉ââ w꞉uu yi dpî têdê dmi a pyede, y꞉i a dpî nyédi, ńmê knî yi ny꞉uu a pyede, y꞉i a dpî nyédi, ngmênê a ngomo daa kwo, a dpî têdê daa tóó, a ghê vyîmî têdê myedaa tóó. Kwo, Mumdoo nyi u ntââ, anya a yâmuyâmu nê? ");
INSERT INTO yle_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pi m꞉uu ka kwo, Cha a yâmuyâmu nê. Ngmênê yi pini ngê kwo, M꞉aa a ngópu mwiyé paa pw꞉oo we, an꞉uu kmênê, u ngwo ana a yâmuyâmu ngi. ");
INSERT INTO yle_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu ngê mgongo u kwo ngmê kwólu, kwo, N꞉ii yi ghê daa pyede, yinté kópu p꞉uu dny꞉oo nuw꞉o, ngmênê nyi, a ngm꞉êê nédi, yoo Chóó Lémi u yoo vy꞉o a chin꞉aa kapî dé. ");
INSERT INTO yle_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pi m꞉uu ngê Yesu ka kwo, A Lémi, ana a yâmuyâmu ngi, ngmênê a yoo knî ye nd꞉uu mwiyé nîmo tpapê. ");
INSERT INTO yle_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu ngê mgongo u kwo ngmê kwólu, kwo, Nee k꞉oo tpiipi kn꞉aa ada a vyuwo, nee wo mbêmê wa knî. Kwo, N꞉ii kn꞉aa adî nuw꞉o, Chóó Lémi p꞉uu angênté adîn꞉aa dpodo. ");
INSERT INTO yle_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","U kuwó dini ghi ngê nmî Lémi ngê pi mê pyud꞉oy꞉a mê miyó ngmidi ngê, yepê, P꞉aani p꞉aani a kada miyó miyó choo kwo. ");
INSERT INTO yle_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yepê, Chóó Lémi u yâpwo têdê y꞉i nté dêdê ghêdê, ngmênê nté mgîpî pyu mdoo daa tóó. Yepê, Yâpwo têdê chóó ka dmyinê ngêpê, nté mgîpî u l꞉êê dîy꞉o pi knî nmye mupêdê kê ngê. ");
INSERT INTO yle_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yepê, Dpî lee dmyeno. Yepê, Y꞉ee tîmêlyu yi vy꞉o kêmkêm tp꞉oo w꞉uu ntee tpile ngê anmyi pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yepê, Ndapî nangmê ńuw꞉o, ndapî yiyé têdê u tpile nangmê ńuw꞉o, nmyi yi dópo kn꞉aani nangmê ńuw꞉o. Yepê, Gha pi yoo nmye adnyin꞉aa a vyuwo. Yepê, Maa p꞉uu danêmbum ngê kêê nangê t꞉oo. Yepê, Lîmîlîmî ngê dmyinên꞉aa dpodo, mgî kîdmyengê pwaa ngmê. ");
INSERT INTO yle_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yepê, P꞉aani p꞉aani a kada miyó miyó choo kwo. Yepê, Pini n꞉ii dê ngomoni k꞉oo dpîmo koko knomomê, yi ngomo chóó ka ala kópu dny꞉oo tpapê, Mw꞉ââkó, Chóó Lémi ngê ṉyoo knî yi k꞉ii a ngee nmyine. ");
INSERT INTO yle_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yepê, Yi ngomo chóó ngê yi pini dê yi wépi dê adî pwapî dê, ye kópuni mwiyé u kwo adpî tpapê, yi kópu ye amêda a diyédiyé. Yepê, Yi ngomo chóó ngê u yi adî kwo, Chóó Lémi ngê a ngee nmîne, ye wa ngee té. ");
INSERT INTO yle_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yepê, Pini n꞉ii dê ngomoni k꞉oo adpî koko, y꞉i dny꞉oo kwo, kn꞉aa mêkîngê lee knî. Yepê, Yi tpódu yi ngomo k꞉oo dny꞉oo kwo, y꞉i dny꞉oo kmaapî, mu kópu u dîy꞉o pi módó daa dpodo yédi, u dpodo u pywuu dpo ngee. ");
INSERT INTO yle_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pini n꞉ii dê p꞉aani n꞉ii dpîmo taataa knomomê, yi p꞉aani tpémi y꞉oo yi tpódu yi dnye dê dpîmo nyêmî knomomê, ntini n꞉ii yi l꞉êê dîy꞉o adnyi l꞉âmol꞉âmo, dny꞉oo pîpî, ");
INSERT INTO yle_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","yi p꞉aani u pwopwokopwe dpî pyi téne, ala kópu ye dny꞉oo tpapê, Dini ghi n꞉ii nmo t꞉âât꞉ââ, Chóó Lémi ngê u yoo chóó u ngwo ada a y꞉enê, yi dini ghi daa kêmakêma a dyimêdyimê. ");
INSERT INTO yle_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yepê, Pini n꞉ii dê p꞉aani n꞉ii adpîn꞉aa taataa, pi knî y꞉oo yi wépi dê adnya a pwapî dê, ye yi ngópu kââ puu ghê dny꞉oo a wowo, ala kópu tââ ye dny꞉oo tpapê, ");
INSERT INTO yle_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Nmyi p꞉aa u têpê nyi yi yodo p꞉uu nye vyavya, ala kópu u ngwo dpo w꞉ee yó, Ala dp꞉oo Chóó Lémi u yoo. Yepê, Ala kópu ye myedny꞉oo tpapê, Dini ghi n꞉ii ngê Chóó Lémi ngê u yoo chóó ada a y꞉enê, yi dini ghi daa kêmakêma a dyimêdyimê, ngmênê Chóó Lémi ngê daada a y꞉enê nmyo, wa mb꞉ii nmyo, mu kópu u dîy꞉o dmyi mb꞉ii nyo. ");
INSERT INTO yle_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Ndê kópu nmye ngmên꞉aa tpapê, Wéni n꞉ii ngê Chóó Lémi ngê Sodom a pw꞉oo ngê, dnyinté a kpada too. Yepê, P꞉aani n꞉ii tpémi y꞉oo adnya a mb꞉iimb꞉ii nmyo, kuwókuwó wéni ngê Chóó Lémi ngê dnyinté daawa kpada té. ");
INSERT INTO yle_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yepê, Kódasin tpémi dny꞉oo nkîngê, Mbetîsaida tpémi myedny꞉oo nkîngê. Yepê, K꞉omo tpile mbwudu yi ngópu yilî nî chópu, ngmênê yi dono doongê kéé tumo. Yepê, Taiya p꞉aani dê Saidon tpémi yi ngópu yinté kópu ndîî w꞉aangmê d꞉uu ngê, ye k꞉omo tpile daa Nju tpémi, ngmênê yi dono yilî lîmîlîmî ngê pî kéé tumo, yi mbodo dmi pêdê ny꞉ii ngópu, tpéé kópu myepî vyi ngópu. ");
INSERT INTO yle_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yepê, Kuwókuwó wéni ngê Chóó Lémi ngê dnyinté wa kpada té, ngmênê Kódasin p꞉aani dê Mbetîsaida tpémi dnyinté daawa kpada té. ");
INSERT INTO yle_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yepê, Kîpêêniyêm tpémi myedny꞉oo nkîngê. Yepê, Yi chóó yi pi dmi mbóó p꞉uu a kmîmî t꞉oo, ngmênê yi kpadakpada têdê wa lee dmi. ");
INSERT INTO yle_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Pini n꞉ii ngê nmyi dnye dmi a nyêmî ngê, daa nmyi mo nmyi dnye dmi ye nyêmî ngê, a dnye myeye nyêmî ngê. Yepê, N꞉ii ngê dpî mb꞉ii nmyo, daa nmyi mo dpî mb꞉ii nmyo, myoo mb꞉ii nê, daa a mo dpî mb꞉ii nê, n꞉ii ngê a dy꞉ââ noo, myoo mb꞉ii. ");
INSERT INTO yle_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dini ghi n꞉ii ngê Yesu ka u dpodo pyu pyud꞉oy꞉a mê miyó mêdê diyé dniye, kwo, Nmî Lémi. Kwo, Dpodo têdê w꞉aa nm꞉uu pyw꞉ângo. Kwo, M̱i mbêmê daa mbii pyu yoo yi mo nmeen꞉aa pyipyi dé, n꞉ii knî y꞉e yi kmêna dnye kwo, my꞉oo pyi too, yi kmêna y꞉e nmî ngm꞉ii kalê too. ");
INSERT INTO yle_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu ngê yepê, Nyââ, Lîmî u wuu ndîî ngê ntee a tóó, ngmênê mêdaa ya yédi, yinté tpile ngmênî módu. Yepê, K꞉omo tpile dyámê mbêmê tpémi yi pwo Setan u pi ndîî ngê doo ya, ngmênê ala ngwo da ghay, mbwódo d꞉uu d꞉ii. ");
INSERT INTO yle_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yepê, U ntââ ngê dî pyódu nmyo, k꞉omo tpile mg꞉ee tpile pê yi vy꞉o anmyin꞉aa m꞉ii, ngmênê kópu nmye daangmêwa pyódu. Yepê, Setan ngê ló kópu nmye ngmadî d꞉uud꞉uu, wa dîpî. ");
INSERT INTO yle_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yepê, Ala kópu nangê vyi, W꞉aa dpo pyw꞉oo, pi knî y꞉e yi kmêna nmî ngm꞉ii kalê too, ngmênê ala kópu dpî vyi yó, W꞉aa dpo pyw꞉oo, mu kópu u dîy꞉o Chóó Lémi ngê u yoo kamî vy꞉o dê kaa nmo. ");
INSERT INTO yle_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yi dini ghi ngê Chóó Lémi u Ghê Dmi ngê Yesu a nt꞉ee ngê, w꞉aa a pyw꞉ângo, u Mî ka kwo, M꞉aa. Kwo, Nyi mbóó dyámê yi kada pini ndêndê. Kwo, Nînê chaa kîgha ngi, mu kópu u dîy꞉o kópuni dyuu a ka nyinê kpo, nyi ngmo too. Kwo, Ndiye pyu ndîî knî y꞉oo dêpê w꞉ee tumo, ngmênê yélini yi pi dmi daa ndîî, y꞉ooda w꞉ee t꞉oo. Kwo, Ṉ́yóó ṉuw꞉o u pono nye vyápê. ");
INSERT INTO yle_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesu ngê pi knî ye yepê, Kópu yilî n꞉ii n꞉aa tpapê too, M꞉aa ngê yinê a ka dpo vyi té. Yepê, Pi ngmê u lama daa tóó, Nê lónté pini, M꞉aa u lama u mo a tóó. Yepê, Pi ngmê u lama daa tóó, M꞉aa lónté pini, a mo a lama a tóó. Yepê, N꞉ii ka M꞉aa mb꞉aamb꞉aa ngê anê kêma, yi pini u lama M꞉aa ndêndê ngê adî ya. ");
INSERT INTO yle_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesu p꞉uu ndiye pyu knî ye yi diyé wo, yi mo ye yepê, Kópuni nmye mumu t꞉oo yi l꞉êê dîy꞉o, nmyi gha dmi mb꞉aamb꞉aa ngê dny꞉oo ya. ");
INSERT INTO yle_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yepê, Yélini y꞉oo Chóó Lémi u komo wunê dnyimo a kapî, king yoo yi k꞉ii, u yi y꞉e doo kwo, Nê u kópu yilî nmî ny꞉ee té, my꞉oo m꞉uu té, ngmênê daa m꞉uu tumo, myedaa ny꞉ee tumo, wunê a pw꞉oo dniye. ");
INSERT INTO yle_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yélini y꞉oo Yesu dnye ng꞉aang꞉aa, yi vy꞉o dêêpî pyu ngmêdoo kwo. U yi u ngwo doo kwo, Yesu nî dóó, wod꞉oo ghêêdî wo, Yesu ka kwo, Mââwe. Kwo, Ló kópu ngmanî d꞉uu, ghê kamî u ngwo anê pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu? ");
INSERT INTO yle_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu ngê kwo, Nangê lónté? Kwo, Puku yedê angênté a tóó? ");
INSERT INTO yle_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yi pini ngê Yesu ka kwo, Ala dêêpî kópu kada a tóó, Chóó Lémi u nuu ghi nmyi nódo mb꞉aamb꞉aa ngê choo ya. Kwo, Chóó Lémi nmyi gha vy꞉o choo ya, dye ghi yintómu p꞉uu dmyinê nuw꞉o, u nuu u kópu yidmyinê d꞉uud꞉uu dé. Kwo, Yi dêêpî kópu u kuwó alani a tóó, kwo, Ṉ́yóó ṉuu ghi ṉódo ntee a tóó, yoo yi nuu ghi dmi ṉódo yinté myechoo ya. ");
INSERT INTO yle_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ngê kwo, Ndê kópu yichi vyi. Kwo, Yi kópu dê anyi d꞉uud꞉uu dê, ye ghê kamî u ngwo anyinê pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pi yilî yi nuu ghi dmi yi dêêpî pyu nódo dêpwo ya, wod꞉oo u yi u ngwo doo kwo, Yesu ngê ala kópu a ka vyi ngê, Daa pi yintómu yi nuu ghi dmi ṉódo yichoo ya. Yi kópu u l꞉êê dîy꞉o Yesu ka póó wo, kwo, Ló yéli yi nuu ghi dmi a nódo ngmadî ya? ");
INSERT INTO yle_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu ngê mgongo u kwo ngmê kwólu, kwo, Nju pi ngmê, Njedusalem a ndê wo, Njédikó doo lêpî. Maa p꞉uu kpáápi knî y꞉oo mgîmî ngópu, dnye vyee, u ndapî t꞉âmo ngópu, u kpîdî mye t꞉âmo tumo, ntóó kéé ngópu, maa p꞉uu a kuwo ngópu, ngmênê ghê tp꞉oo doo ya. ");
INSERT INTO yle_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","U kuwó dini ghi ngê kpêê yiyé pyu ngmê ngê yi máádi a kwólu. Dini ghi n꞉ii ngê yi pini módu, daa ngópu, u kwo mî loo. ");
INSERT INTO yle_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kwo, U kuwó dini ghi ngê Chóó Lémi u ngomo k꞉oo dpodo pyu ngmê ngê yi máádi myedê kwólu. Kwo, Dini ghi n꞉ii ngê yi pini ntóó módu, myedaa ngópu, u kwo myimî loo. ");
INSERT INTO yle_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kwo, U kuwó dini ghi ngê Samédiya pi ngmê ngê yi máádi até myeyedê kwólu. Kwo, K꞉omo tpile Samédiya tpémi nmyinê nmye yoo dono dé, ngmênê yi Nju pi Samédiya pi ka ch꞉anê wo. ");
INSERT INTO yle_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kwo, U kwo loo, yimo knî yi p꞉uu wain a pii ngê, olipi wulu myedê pii ngê, yimo kwéli dnye ya, kpîdî pee ngê kwédi kê too, apê, Mb꞉aamb꞉aa ngê mê paa pyaa we. Kwo, U kuwó dini ghi ngê yi pini ntóó chóó u ndonki pyipwo yó, p꞉aa ngmê ńuwo. Kwo, Yi p꞉aani ngomo ngmêdoo kwo, maa p꞉uu n꞉ii knî ye mgîdî dpîmo a ghayghay, y꞉i dnyimo dpî. Kwo, Yi ngomo k꞉oo kee knopwo, Samédiya pi Nju pi ka y꞉i doo vyuwo. ");
INSERT INTO yle_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kwo, Womumo mw꞉aandiye Samédiya pi ngê yi ngomo chóó ka ndapî miyó y꞉ângo, kwo, Ala pini ka chi vyuwo. Ndapî ntémwi p꞉uu anyi dyênê, amêma amênê wumo té. ");
INSERT INTO yle_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu yi dêêpî pyu ka póó wo, kwo, Kpaa pyu knî y꞉oo pini n꞉ii vya ngópu, u nuu ghi wu pini pyile knî yi vy꞉o n꞉uu nódo yó? ");
INSERT INTO yle_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dêêpî pyu ngê kwo, Pini n꞉ii ka ch꞉anê wo. Yesu ngê kwo, Yinté kópu vyîlo yichin꞉aa d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dini ghi n꞉ii ngê Yesu p꞉uu ndiye pyu knî yi k꞉ii p꞉aani p꞉aani dnye lêpî, p꞉aa ngmê taa dniye. Yi p꞉aani pyââ mbwémi miyó doo ya, yi pi dê Mata mbwémi Méli. Dini ghi n꞉ii ngê Yesu p꞉uu y꞉i taa dniye, Mata ngê mênê dóó kalê too, yepê, Dîyo a ngomo k꞉oo nté dp꞉uu ma yó. ");
INSERT INTO yle_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Y꞉i taa dniye, mbwódo yi yaa dniye, Yesu ngê yoo doo ndiye kîgha dé. Méli a loo, yu km꞉ee mî yaa wo, Yesu doon꞉aa ng꞉aang꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata u nuw꞉o dono ngê pyodo, apê, Kî mââwe yi t꞉aa, lukwe dîy꞉o nté dyêêdî ngmidi dnye chono, wod꞉oo Yesu ka kwo, Mââwe. Kwo, Ṉga d꞉oo ch꞉anê wo, a mo anî nté ch꞉eech꞉ee? Kwo, Méli daanyinê dy꞉ââ, daamî ngee nê? ");
INSERT INTO yle_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu ngê kwo, Mata. Kwo, Kidimê nod꞉enod꞉e. Kwo, Kópu yilî kidimê nuw꞉onuw꞉o. ");
INSERT INTO yle_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kwo, Kópu mu ngmidi u ntââ. Kwo, Méli u nuw꞉o kópuni p꞉uu a kwo, yi kópu yi mb꞉aamb꞉aa. Kwo, Yi kópu u kwo daanî kwódu. ");
INSERT INTO yle_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wo ngmê ngê Yesu ghi ngmê até yedoo ngêpê. Dini ghi n꞉ii ngê u ngêpê a kêlî ngê, p꞉uu ndiye pyu ngmê ngê kwo, Nmî Lémi, Njon Baptist ngê p꞉uu ndiye pyu yoo yi nuwo ngêpê ntee kwólu, kwo, yinté nmî nuwo my꞉oo kwéli. ");
INSERT INTO yle_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu ngê yepê, Ala ngêpê yidmyina a ng꞉êênî, apii Munmîkó M꞉aa, pi knî y꞉oo ntênê dny꞉oo chââchââ ngi. Nmî y꞉enê kn꞉ââ lîmî k꞉ii a chépi. ");
INSERT INTO yle_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wonêwodiyédiyé u ntââ ntini nmo cha a kuwo. ");
INSERT INTO yle_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pi knî yi dono kópu ntee nmî kuwó nmî kéé too, nmî dono kópu yinté ṉguwó myoo kéé té, mêdaanyi nuw꞉onuw꞉o dé. Nmî tókótókó ndîî têdê nangê ńuw꞉o nmo. ");
INSERT INTO yle_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu ngê p꞉uu ndiye pyu knî ye mgongo ngmê kwólu, yepê, Nmyi vy꞉o pini ngmê, mgîdî ńuknîńuknî p꞉uu u mbwó ka wa lê, awo, A mbwó, nté pee a ka ngma a ki. ");
INSERT INTO yle_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kwowo, A pyipe ala ngwo ngmêdê t꞉aa, nté a ngópu daa tóó, ló ntini u kwo ngmanî y꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yepê, Yi pini ngê u mbwó ka ala kópu wa vyi, awo, Ala dpî dye ghi, nté a ka mêkidimên꞉aa dmyinê. Kwowo, Keńe kînga dp꞉o kuwo, nmî mupwoknî aténgê dpî dpî dmi. Kwowo, Daanê pyidu, myedaanî ngee ngi. Kwowo, W꞉êênî wochi t꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yepê, K꞉omo tpile yi pini daawa pyidu, u mbwó ka nté daawa y꞉ee knomomê, ngmênê u mbwó ngê dyaa u kwo wa chedê, mywene u ngwo myedaadî kwo, ye wa pyidu, u mbwó ngê tpileni u yi adî kwo, u kwo wa y꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yepê, Kópuni u l꞉êê dîy꞉o anmyi ngêpê, yi kópu p꞉uu nmyi Mî ka dyaa dmyinê chedêchedê. Yepê, Kópuni u kwo anmyi dmyinê, nmye wa a kê, kópuni anmyi nmy꞉uu, anmyinê pyw꞉ee ngmê, keńeni p꞉uu anmyin꞉aa depedepe, nmye wa kpêmî. ");
INSERT INTO yle_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yepê, Pini n꞉ii ngê u kwo wa dmyinê, yi pini ka wa y꞉oo, pini n꞉ii ngê adî nmy꞉uu, wa a pyw꞉oo, pini n꞉ii adî depedepe, keńe u kwo wa kpêmî. ");
INSERT INTO yle_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Yepê, Nmyi vy꞉o pini ngmê, tp꞉oo ngê te mbyuu u kwo wa dmyinê, ye mt꞉enge mbyuu u kwo daawa y꞉oo, awêde wa pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yepê, Myenté, tp꞉oo ngê kpéé w꞉uu u kwo wa dmyinê, pêla ngê mg꞉ee daawa ngî, u kwo daawa y꞉oo, awêde wa kiye. ");
INSERT INTO yle_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yepê, K꞉omo tpile dono nmyi mênê a tóó, ngmênê nmyi tp꞉ee dmââdîma ye tpile mb꞉aa vy꞉ee yémî tumo. Yepê, Pi ka vyuwo têdê nmyi Mî ngê a t꞉ee kîgha nmyoo. Yepê, Mbóó p꞉uu wunê tóó, dono u mênê daa tóó. Yepê, N꞉ii ngê u Ghê Dmi u kwo wa dmyinê, daawa dóó, ndêndê ngê u kwo wa a y꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wo ngmê ngê Yesu ngê pi ngmê pyi ngê. Yi pini ngê u kmêna ngmêdoo kwo. Yi kmêna ngê yi pini ló dini a dyênê ngê, dnye dêpwo kîgha. Dini ghi n꞉ii ngê kmêna ngê a kuwo ngê, wod꞉oo yi pini modoo danêmbum. Pi knî yi mênê ghê ghipé wo, yi nyepênyepê u kópu ngê mye pyodo. ");
INSERT INTO yle_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ngmênê woni knî y꞉oo noko yepê, Setan ntee pini nmye yila, n꞉ii kmêna knî yi kada pini. Noko yepê, Setan u wêdêwêdê mbêmê kmêna yoo yinê a ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Woni knî y꞉oo Yesu dnya a tókótókó, kwo, Mumdoo Chóó Lémi p꞉uu nye dpodo, ye mbwudu nmî ngópu ngmê chépi. ");
INSERT INTO yle_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kópuni dnye nuw꞉onuw꞉o dé, yi kópu yilî Yesu ngê yi gha vy꞉o m꞉uu too, mgongo ye u ngwo ngmê kwólu, yepê, Yélini wee ngmidi u kwo a pyede, yoo wa chaa knomomê, numo p꞉uu adnyi l꞉êê knomomê, ye yi chóóchóó yi wee wa dyênê ngmê. Yepê, Myenté, mupwoknî ngmê, numo p꞉uu adnyi l꞉êê knomomê, ye yi chóóchóó yi pi dmi wamye dyênê ngmê. ");
INSERT INTO yle_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yepê, Setan u yoo mye yinté. Yepê, Numo p꞉uu adnyi l꞉êê knomomê, ye angênté adnyi ya. Yepê, Dmye kn꞉aadi ngmê, daa Setan u wêdêwêdê mbêmê kmêna n꞉aa ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yepê, Nmye ngênî póó. Yepê, Nmyi vy꞉o yéli y꞉oo n꞉uu u wêdêwêdê mbêmê kmêna a ngm꞉ii kîgha tumo? Yepê, Ala kópu nmye tpapê ngmê, N꞉ii ngê kmêna a ngm꞉ii kîgha too, yi pini ngê yi kada pini Setan u wêdêwêdê mbêmê a ngm꞉ii kîgha too. Yepê, Nmyi vy꞉o yéli y꞉oo yi kópu nmye wa wópu ngmê, nmyewo, K꞉omodanê kópu yila. Nmyewo, Chóó Lémi u wêdêwêdê mbêmê kmêna nmo ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yepê, Chóó Lémi u wêdêwêdê mbêmê kmêna ntênê n꞉aa ngm꞉ii kîgha too. Yepê, Yi kópu u l꞉êê dîy꞉o ala kópu nmyi lama choo ya, Chóó Lémi ngê u yoo daa kêmakêma chóó adî y꞉enê. Yepê, U yoo kuwa kîngî kaa nmyo. ");
INSERT INTO yle_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yesu ngê mgongo ye m꞉uu kwólu, yepê, Tpileni l꞉âmo dy꞉ââ ngê dpî t꞉âmo té, u ngomo k꞉oo dpî km꞉êê té, doo u ntââ u ngomo k꞉oo daanyi kee, mêdaanyimo ngî té, awêde u kaa taa ngê wa vya ngi. ");
INSERT INTO yle_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yepê, Ngmênê n꞉ii u wêdêwêdê ndîî, yi pini u ntââ, yi l꞉âmo dy꞉ââ dpî mgîmî, u kaa taa dpo ngî té, u ngomo k꞉oo dpî kee, tpileni mwiyé a t꞉âmo too, tpile chóó knî ye yi tpile moo y꞉ee té. Yepê, Setan l꞉âmo dy꞉ââ ntee pini, u wêdêwêdê ndîî. Yepê, Ala yéli yinê mgîmî ngê, n꞉ii knî y꞉e yi kmêna a wee. Yepê, Chóó Lémi u Ghê Dmi a mênê a tóó, u wêdêwêdê mbêmê Setan kóó yu dî kudu té, yélini y꞉e yi kmêna a wee, dpî pyi té, yi kmêna n꞉aa ngm꞉ii kîgha too. ");
INSERT INTO yle_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yepê, N꞉ii daa a pee pini, a p꞉uu a d꞉uu yédi. Yepê, A p꞉uu ndiye pyu knî yi k꞉ii nmo vyuwó té. Yepê, N꞉ii ngê daa ngêêpî nmo, te nmo dpî ngm꞉ii kalê té. ");
INSERT INTO yle_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesu ngê yepê, Dini ghi n꞉ii ngê nmyi vy꞉o yéli y꞉oo pi ka u kmêna dpî ngm꞉ii kalê ngmê, yepê, yi kmêna wee dono u kwo wumê paambwi yédi, u yââyââ têdê ka wumê vyuwo yédi, dpo, Y꞉i n꞉uu yââ. Yepê, U yââyââ têdê d꞉uuwodê pyw꞉ee knomomê, ye u nuw꞉o k꞉oo dpo, Kwéli nê ndê wo, y꞉i mînê diyédiyé. ");
INSERT INTO yle_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yepê, Dini ghi n꞉ii ngê dpo diyé, dpo, Ngomoni k꞉oo nê pwii wo, kamî ngê aténgê maa pyódu, tpile dono k꞉oo daa tóó, u y꞉enê pyu daa tóó. ");
INSERT INTO yle_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yepê, Wod꞉oo dpî lê, u pyipe mê pyudu dpî nya, n꞉ii knî yi l꞉êê ghi dmi d꞉ud꞉umbiy꞉e dono. Yepê, Yi kmêna wááli knî yi ngomo k꞉oo a kwo nyédi. Yepê, Yi pini u ya d꞉ud꞉umbiy꞉e dono ngê dpî pyódu, wunê ntee dpîmo a ya, mêdaa yinté. ");
INSERT INTO yle_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dini ghi n꞉ii ngê Yesu pi knî ye doo danêmbum, yi yéli yi vy꞉o pyââ ngmê Yesu ka dpodombiy꞉e a mbwolo, kwo, Pyópuni ngê tpyé nyoo, u ngmo ngê myedê mbono nyoo, u gha mb꞉aamb꞉aa ngê choo ya. ");
INSERT INTO yle_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ngmênê Yesu ngê kwo, N꞉ii knî y꞉oo Chóó Lémi u kópu dyuu adnyi nyêmî dé, amyidnyi chââchââ dé, vyîlo yi yéli Chóó Lémi ngê wa ngee té, yi gha dmi d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê u ngwo wa pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dini ghi n꞉ii ngê pi yilî Yesu ka lee dniye, yepê, Lukwe dîy꞉o dnyinté a ka nmyinê kêlîmî té. Yepê, Nmyo yoo dono. Yepê, Lukwe dîy꞉o a ka dmye vyi ngmê, Mumdoo Chóó Lémi p꞉uu nye dpodo, ye mbwudu nmî ngópu ngmê chépi. Yepê, Yinté kópu nmyi ngópu daangmanî d꞉uu, ngmênê dîyo kópu ndîî mu ngmidi wanmyi m꞉uu ngmê. Yepê, Kópuni Njóna ngê a pyodo, yinté kópu dîyo a nga ngmêwa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yepê, Ninipe tpémi y꞉oo ntee a w꞉ee ngópu, apê, Yâpwo Ndêndê ngê kî Njóna nmo yinê a dy꞉ââ ngê, yepê, yélini ala ngwo a pyede, ala kópu yinté myepêdê w꞉ee y꞉e, awo, Wu Chóó Lémi ngê u Pi Ndêndê nmo yinê a dy꞉ââ ngê. ");
INSERT INTO yle_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Yepê, Kuwókuwó wéni ngê, dini ghi n꞉ii ngê pi yintómu wa a pii dmi, Ninipe tpémi y꞉oo wa m꞉uu nmyo, nmyi pi dmi wa dyênê ngmê, wamye ndyîko nmyo, mu kópu u dîy꞉o dini ghi n꞉ii ngê Njóna u kópu dyuu ny꞉ee tumo, yi dono kópu yintómu yi kuwó kéé tumo. Yepê, K꞉omo tpile Njóna dyámê mbêmê pi, ngmênê Ninipe tpémi y꞉oo u dnye ny꞉ee ngópu. Yepê, Nê Njóna u pwo pini, lukwe dîy꞉o a dnye dp꞉ee nyêmî ngmê. Yepê, Myenté, yepê, kuwókuwó wéni ngê Sipa tpémi yi kwin ngê wamye ndyîko nmyo, mu kópu u dîy꞉o kuughê a ndê wo, Solomon u gha kópu dyuu doon꞉aa ng꞉aang꞉aa dé. Yepê, K꞉omo tpile Solomon dyámê mbêmê pi, ngmênê Sipa tpémi yi kwin ngê châpu ngê. Yepê, Nê Solomon u pwo pini. Yepê, Lukwe dîy꞉o dp꞉ee chââchââ nê. ");
INSERT INTO yle_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu ngê mgongo ye m꞉uu kwólu, yepê, Dini ghi n꞉ii ngê mgîdî dpo ghay, n꞉ii ngê lam dpo vyuwó, doo u ntââ tpile u pwo k꞉ame daawa kââ, myedaawa a mgiye, mu kópu u dîy꞉o lukwe ngê mgîdî wa chaa. Yepê, Yi pini ngê lam dpo y꞉oo, ya nkwodo dpî kââ. Yepê, Yélini u kwo dpî lee dmi, tpile yilî u ngwo dpî m꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yepê, Nmyi ngwolo dmi lam ntee tpile dé. Yepê, N꞉ii ngê u ngwolo dê dê kuwo dê, doo mya noo, yi pini ngê u lam da mgiye, u kópu yilî yintómu mgîdîmgîdî dé. Yepê, N꞉ii ngê u ngwolo dê dê pywálî dê, dê mya nê, yi pini u lam ya nkwodo a kwo, u kópu yilî yintómu lam wo a pyede. ");
INSERT INTO yle_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yepê, Nmyi ngwolo dmi pywálî tóó, nmyi lam kîdmyinêngê mgiye t꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yepê, N꞉ii ngê u lam d꞉uuwodê mgiye, u kópu mgîdî vy꞉o d꞉uungmêdpî ngmo, mu dini ghi ngê yi pini ngê Chóó Lémi u lam wo kópu yilî yintómu wa m꞉uu té. ");
INSERT INTO yle_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Dini ghi n꞉ii ngê Yesu ngê pi knî ye danêmbum a kêlî ngê, Pádisi ngmê ngê u ngomo k꞉oo kmaapî têdê ńuwo. ");
INSERT INTO yle_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yesu ngê kóó dê mwiyé daa ghêê doo, kmaapî têdê u ngwo yaa wo. Pádisi ngê dini ghi n꞉ii ngê módu, ghê u mênê ghipé wo, apê, Kî pini ngê lukwe dîy꞉o nmî dêêpî kópu doo châpu ngê, kmaapî têdê módó dê yââ, kóó dê doo ghêê doo. ");
INSERT INTO yle_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ngmênê nmî Lémi ngê kwo, Nmyo Pádisi yoo nmyi d꞉ââ pîléti yi kpadama yinmye ghêêghêê tumo, lukwe dîy꞉o yi kó dp꞉ee ghêêghêê t꞉oo. Yepê, Nmyi too pee yinmye ghêêghêê tumo, ngmênê nmyi gha dmi tupwótupwó dé. Yepê, Nmyo ndapî u mb꞉aami yoo, nmyi gha dmi dono dé. ");
INSERT INTO yle_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yepê, Nuw꞉o nmyi mênê daa tóó. Yepê, N꞉ii ngê nmyi too pee l꞉âmo too, nmyi gha dmi yinê mye l꞉âmo too. Yepê, Lukwe dîy꞉o too pee u kópu dé nmyinê nmye ndîî kópu dé, gha u kópu dé nmyinê nmye têdê kópu dé. ");
INSERT INTO yle_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yepê, Nmyi kêê yedê tpileni a pyede, ngópuch꞉anê knî ye dmyinê yémî dé, yed꞉oo nmyi gha k꞉oo tupwó mêdaadî ya, nmyi too pee p꞉uu tupwó myedaadî ya. ");
INSERT INTO yle_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yepê, Mósisi ngê nmî kn꞉ââ knî ye ala kópu a vyu, yepê, Ntini n꞉ii pi ngê yâpwo têdê dpo ńuw꞉o, dyuu y꞉a dpo pyidu ngê, yononi dyuu Chóó Lémi u dpodo pyu knî ye dpî y꞉ee ngê. Yepê, Yi kópu dnyinté dp꞉ee chââchââ ngmê. Yepê, K꞉omo tpile nkêpe w꞉uu y꞉a, ó kpono w꞉uu y꞉a nmyinê pyw꞉êmî ngópu, ngmênê myenmyinê kpââ ngópu, Chóó Lémi u dpodo pyu knî ye yononi ntênê nmye yémî ngópu. Yepê, Yi kópu ndîî kópu ngê nmyi pyódu ngópu. Yepê, Kópuni Chóó Lémi ka ndîî kópu, lukwe dîy꞉o têdê kópu ngê nmyi pyódu ngópu. Yepê, Lukwe dîy꞉o pi knî ye dp꞉ee vyuwo nyédi, ngópuch꞉anê knî ye myedp꞉ee vyuwo nyédi, lukwe dîy꞉o nmyi nódo Chóó Lémi u nuu ghi daa tóó. Yepê, Dmyinê nkîngê. Yepê, Têdê kópu ndîî kópu ngê nmyi pyódu tumo, ndîî kópu têdê kópu ngê nmyi pyódu tumo. Yepê, Têdê kópu dmyinê d꞉uud꞉uu dé, kópuni Chóó Lémi ka ndîî kópu dé, myedmyinê d꞉uud꞉uu dé. ");
INSERT INTO yle_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yepê, Pádisi yoo, dmyinê nkîngê. Yepê, Ngêpê ngomo k꞉oo nmyi chóó kada nmyimo yââyââ nyédi, u yi nmye a kwo yédi, Pi knî y꞉oo naa têdê mb꞉aamb꞉aa ngê dny꞉oo chââchââ nmo. ");
INSERT INTO yle_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yepê, Dmyinê nkîngê. Yepê, Kwodombê mbwee maa p꞉uu ngma ya yédi, n꞉ii u lama daa ya yédi, kpî knî yi pwo a m꞉ii yédi. Yepê, Yi kpî ntee dé, nmyo yinté yéli, pi knî yi lama daa ya yédi, tupwó ndîî nmyi gha vy꞉o a tóó. ");
INSERT INTO yle_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dêêpî pyu ngmê ngê Yesu ka kwo, Ye kópu kîchi vyi té, nmî pi dmi myeche ghîpî. ");
INSERT INTO yle_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu ngê kwo, Dêêpî pyu yoo, myedmyinê nkîngê. Yepê, Mósisi ngê yoo u ntââ dêêpî kópu dyuu yi d꞉êê ngê, ngmênê nmyi chóó yilî ngê nmyi pyódu ngópu, pi knî ye dpodo ndîî ngê nmyi pyódu tumo, yi dpodo têdê d꞉ud꞉umbiy꞉e dp꞉ee ngêêpî tumo. ");
INSERT INTO yle_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yepê, Dmyinê nkîngê. Yepê, Nmyi kn꞉ââ knî y꞉oo Chóó Lémi u komo kapî pyu yoo wunê kwéli a kmênê tumo, ngomo mb꞉aa yi pwo nmyi wó tumo, yi mti ngê a pyede. Yepê, Ngmênê nmyi chóó nmyi kn꞉ââ knî y꞉oo y꞉oo a vya tumo. ");
INSERT INTO yle_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yepê, Nmyi kn꞉ââ knî y꞉oo Chóó Lémi u komo kapî pyu yoo mwâ a vya tumo, nmyinê nmye gha kópu yi d꞉uu ngópu, mu kópu u dîy꞉o y꞉oo a vya tumo, yi pwopwo u mti dmi u nkwo nmyi t꞉ee tumo. ");
INSERT INTO yle_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yepê, Yi kópu u l꞉êê dîy꞉o Chóó Lémi ngê ala gha kópu a vyu, apê, Ala yéli ye a komo kapî pyu yoo a dyépi yoo wanê dy꞉ââ té, ngmênê ala yéli y꞉oo wa mb꞉ii t꞉oo, woni wa kpaka t꞉oo, woni amye vya t꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Yepê, Dye ghi yintómu nmyi kn꞉ââ knî y꞉oo Chóó Lémi u komo kapî pyu yoo dnya a vyee dé, kn꞉ââ Chóó Lémi ngê dyámê pê mwâ a l꞉âmo ngê, Kéén ngê Epel mwâ a vyâ, nkoo nmo, a vyee u yi nmye mye kwo. Yepê, Nmyi kn꞉ââ knî y꞉oo Chóó Lémi u komo kapî pyu yoo dnyinté a mya tumo, Chóó Lémi ngê dnyinté u nkwo kpada too. Yepê, Kêlî ghê, king Njehu u dye ghi ngê, dini ghi n꞉ii ngê Sekîdaiya Chóó Lémi u ngomo chedê vya ngópu, Chóó Lémi ngê dnyinté a kpada too, Sidiya tpémi dy꞉ââ too, Njedusalem tpémi yi ndapî mî t꞉âmo tumo, yi tpile yilî mye t꞉âmo tumo, ngmênê yi p꞉aa dêpê pw꞉oo ngópu. Yepê, Ala ngwo Chóó Lémi ngê u komo kapî pyu ndêndê nmye da dy꞉ââ, dmy꞉oo mya ngópu. Yepê, Wanmyi vya knomomê, ye Chóó Lémi ngê dnyinté u nkwo daawa kpada nmyo, nmyi p꞉aa d꞉ud꞉umbiy꞉e wa a pw꞉ono. Yepê, Nmyi kn꞉ââ yoo yi yikî dmi nmyi pwo wa ghay. ");
INSERT INTO yle_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yepê, Dêêpî pyu yoo, dmyinê nkîngê. Yepê, N꞉ii u lama puku kpââ a tóó, yi pini ngê u ntââ Chóó Lémi puku yedê wa a pyw꞉oo. Yepê, Yi puku dmi ngomo ntee tpile, u kii nmyi ngópu a tóó, ngmênê pi knî ye yi ngomo dp꞉ee kpêmîkpêmî ngmê. Yepê, Nmyi chóó yi ngomo k꞉oo dp꞉ee koko nyédi, n꞉ii ngê u yi a kwo, dpo, Yi ngomo u mênê nî kee, u maa u kwo nmye nkokonkoko ngópu. ");
INSERT INTO yle_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pádisi yoo, dêêpî pyu yoo yi k꞉ii, Yesu ka d꞉ud꞉umbiy꞉e nod꞉e dniye, Yesu ngê yi p꞉aani pee u ngwo a kuwo ngê. U kuwó dini ghi ngê dpodombiy꞉e dnya a tókótókó, kópu yilî yi p꞉uu u kwo dnye póó. ");
INSERT INTO yle_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","U yi y꞉e doo kwo, Yesu nmî dóó, kn꞉aadi te kópu ngmê vyi ngê, u ngwo p꞉oo ndyîko. ");
INSERT INTO yle_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pi yilî tp꞉oo témi tap Yesu ka lee dniye, u kwo dnye kadakada. Yesu ngê p꞉uu ndiye pyu knî ye yepê, Pádisi yoo yi nj꞉ii ngê kêê nangê t꞉oo. Yepê, Pi dódó pyu yoo, kópuni a tpapê tumo, daa d꞉uud꞉uu tumo. Yepê, K꞉omo tpile pi dódó daa ndîî nmyi vy꞉o adî ya, ngmênê d꞉ud꞉umbiy꞉e wa dyênê nmyo. ");
INSERT INTO yle_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yepê, Tumu kópu yintómu dîyo wa a pywálî dmi, ngmee u kópu dyuu wamyedê pywálî dmi. ");
INSERT INTO yle_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yepê, Tumu kópuni mgîdî vy꞉o anmyi vyi t꞉oo, w꞉êênî wa ny꞉ee t꞉oo. Yepê, Tumu kópuni d꞉omo yu kn꞉ââ u mênê kwayi ngê anmyi vyi t꞉oo, dîyo naa têdê tââ wa kaa dmi. ");
INSERT INTO yle_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesu ngê yepê, A pyipe yoo, pi knî ye namê nkîngê. Yepê, A l꞉êê dîy꞉o wa vya nmyomomê, am꞉ii pw꞉oo dmi, ye ló kópu nmye m꞉uu wa d꞉uu ngmê. Yepê, Doo u ntââ, kópu nmye daamuwa d꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yepê, Ye anmyi nkîngê knomomê, a wépi u ngwo anmyi pwaa ngmê, ye Chóó Lémi ngê nmyi wépi dmi u nkwo wa puwâ, ndiya wa kéé nmyo. Yepê, Chóó Lémi p꞉ee vyîlo, u kwo yidmyinê nkîngê. ");
INSERT INTO yle_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Yepê, Kópuni dî vyi, nmye mênî tpapê, Pi knî ye namê nkîngê. Yepê, Mtyîmwe daa ndîî ńméni tp꞉oo, knî ngmêdê pw꞉oo knomomê, nmyinê nmye k꞉omo tpile, ngmênê Chóó Lémi ye wunê vyuwo yédi. ");
INSERT INTO yle_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yepê, Nmye myewunê vyuwo yédi, dp꞉ee mtyîmwe ntee yéli, dnyinté nmye dêdê vyuwo. Yepê, Nmyo yintómu u lama nmye pyede, nmyi mbêmê mbêmê mbodo gh꞉aa ntémwi a kwo, u lama mye tóó, doo u lama daangmêwa a ghay. Yepê, D꞉ud꞉umbiy꞉e pi ka namê nkîngê. ");
INSERT INTO yle_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yepê, Pini n꞉ii ngê pi knî ye daawa a wópu nê, yewo, Nyââ, Chóó Lémi u Pi Ndêndê p꞉uu n꞉aa dpodo, ye kuwókuwó wéni ngê Chóó Lémi u enjel knî yi ngîma yi pini u nkwo daanîmo wópu, a kêê k꞉oo wan꞉uu kââ. ");
INSERT INTO yle_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yepê, N꞉ii ngê pi knî yi ngîma wa a wópu nê, yewo, Ye pini daa Chóó Lémi u Pi Ndêndê, p꞉uu dînê dpodo, ye kuwókuwó wéni ngê Chóó Lémi u enjel knî yi ngîma yi pini u nkwo wanîmo wópu, a kêê k꞉oo daan꞉uu kââ. ");
INSERT INTO yle_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yepê, Pini n꞉ii ngê daawa mya nê, a p꞉uu adî peede tpapê, u kuwó dini ghi ngê yi pini ngê yi dono kópu u kuwó amê kéé knomomê, u ntââ Chóó Lémi ngê yi pini u dono u kuwó wa kéé, mêdaawa a ngî, ngmênê n꞉ii Chóó Lémi u Ghê Dmi u dpodo p꞉uu adî peede tpapê, yi pini Chóó Lémi ka daawa diyé, Chóó Lémi ngê u dono yilî u kuwó daawa kéé té. ");
INSERT INTO yle_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Yepê, Dini ghi n꞉ii ngê ngêpê ngomo y꞉enê pyu knî y꞉oo adnyin꞉aa kóté kîgha nmyo, kada pini knî y꞉oo ó king knî y꞉oo adnyin꞉aa kóté kîgha nmyo, kópuni ye anmyin꞉aa tpapê dé, yi kópu knî ye nuw꞉o ngê kêê nangê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yepê, Kópuni ye anmyin꞉aa tpapê dé, yi dini ghi ngê Chóó Lémi u Ghê Dmi ngê nmyi nuw꞉o ńedê mwiyé ada a t꞉emî dé. ");
INSERT INTO yle_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesu yélini ye doo danêmbum, yi vy꞉o pi ngmê ngê kwo, Mââwe. Kwo, M꞉aa dini ghi n꞉ii ngê pwene, a mbwó ngê tpile yintómu u mo a ngî too. Kwo, U kwo vyi ngi, Knî a ka ngma a kê ngê. ");
INSERT INTO yle_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu ngê kwo, Kî pini. Kwo, N꞉uu ngê nmyi kóté kîgha pyu ngê pyódu noo. ");
INSERT INTO yle_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pi knî ye yepê, Kmungo pyu yoo yi nj꞉ii ngê kêê u ngwo nangê t꞉oo, mu kópu u dîy꞉o pi u ghê ndêndê daa tpile knî yi p꞉uu a tóó. ");
INSERT INTO yle_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Wod꞉oo Yesu ngê mgongo ye ngmê kwólu, yepê, Ndáápi ngmê, ndapî u ngópu dêpwo ghêdê, tpile u ngópu myedêpwo ghêdê. ");
INSERT INTO yle_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yepê, Chóó u nuw꞉o k꞉oo apê, Pudumakó w꞉uu ngmên꞉aa kaakaa, ndapî ndîî u ngwo wanî kmênê. ");
INSERT INTO yle_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Apê, A stówa my꞉oon꞉aa pyidupyidu, a ndapî d꞉ud꞉umbiy꞉e ndîî ngê u ngwo wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Apê, U kuwó dini ghi ngê a gha mb꞉aamb꞉aa ngê wa pyódu, anê, Nê pi ngmê, tpile ka mêdînê nuw꞉o, m꞉ââ yilî yi k꞉oo anî lîme, anî kmaapî, daanî dpodo, d꞉ud꞉umbiy꞉e anî gha vyîlê. ");
INSERT INTO yle_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Yesu ngê yepê, Ngmênê Chóó Lémi ngê kwowo, M̱odo podo. Nyi mtîkó pyu ndîî. Awêde mgîdî vy꞉o nye pwopwo, ṉ́mile yintómu n꞉uu ngê wa ghay dmi. ");
INSERT INTO yle_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu ngê yepê, N꞉ii ndapî mu ngmidi p꞉uu adî nuw꞉o, Chóó Lémi p꞉uu daadî nuw꞉o, yi pini yinté pini ngê wa pyódu, mbodo podo. ");
INSERT INTO yle_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Ala kópu mye ny꞉ee yó. Yepê, Ntini n꞉ii nmye pîpî ngmê, nmyi nuw꞉onuw꞉o u kópu ngê kîngî pyódu, kpîdîni nmye t꞉emî ngmê, nmyi nuw꞉onuw꞉o u kópu ngê myekîngî pyódu. ");
INSERT INTO yle_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yepê, Nté kpîdî daa ndîî kópu dê, nmyi ghê dmi yi ndîî kópu. ");
INSERT INTO yle_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yepê, Ńmê knî yi p꞉uu dmyinê nuw꞉o. Yepê, Nté woo d꞉uudpî kaa ngmê, nté nt꞉u d꞉uudpî t꞉ee ngmê, p꞉o d꞉uuwodê ńuw꞉o ngmê, ngomo k꞉oo d꞉uuwumê yé ngmê. Yepê, Kêle, Chóó Lémi ngê yinê dpo mbono té. Yepê, Dp꞉ee ńmê ntee tpile dé, Chóó Lémi ngê mb꞉aamb꞉aa ngê wamyedê mbono nmyo. ");
INSERT INTO yle_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yepê, Dini ghi n꞉ii ngê anmya a pwopwo, k꞉omo tpile nmyi nuw꞉onuw꞉o u kópu ngê adî pyodopyodo, ngmênê doo u ntââ nmyi ya daadîî ngê daanmya a pyépi. ");
INSERT INTO yle_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yepê, Yi kópu nmye doo u ntââ, lukwe dîy꞉o kn꞉aa kópu knî nmyi nuw꞉onuw꞉o u kópu ngê a pyede. ");
INSERT INTO yle_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yepê, Yinênê knî yi p꞉uu ngî nuw꞉o mbê dmyeno. Yepê, Yi kpîdî p꞉uu daa dpodo nyédi, myedaa kpile nyédi. Yepê, K꞉omo tpile Solomon u ndapî ndîî, u kpîdî mb꞉aa dé, ngmênê yinênê knî y꞉oo Solomon u kpîdî mêdê ch꞉ii tumo. ");
INSERT INTO yle_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yepê, K꞉omo tpile chii mênê yi awêde a kwo, mââ m꞉ii ndê ngê dpî ma, ngmênê Chóó Lémi ngê nênê yi nkwodo dpî kââ, kpile ye yinê wunê yémî. Yepê, Dp꞉ee yi ntee tpile dé, Chóó Lémi ngê mb꞉aamb꞉aa ngê wamye kpîlê nmyo. Yepê, Lukwe dîy꞉o dnyinté u kwo nmye kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yepê, Nté mbwaa yi pyw꞉êmî nmyi nuw꞉onuw꞉o u kópu ngê kîngî ya. ");
INSERT INTO yle_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yepê, Yélini Chóó Lémi ka daa kêlîmî nyédi, vyîlo yi kópu knî yi p꞉uu yi nuw꞉o dmi a mbêpê té. Yepê, Nmyi Mî u lama ka tóó, yi tpile daadnyi ya knomomê, ye nmyi ya dono ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yepê, Chóó Lémi kóó k꞉oo wowo ndîî kópu ngê nmye choo ya, yi tpile dé nmye u ngwo wa a kê té. ");
INSERT INTO yle_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yepê, K꞉omo tpile dp꞉ee yoo ndîî, ngmênê pi knî ye nkîngê ngê kêê kîdmyenêngê t꞉ee ngmê. Yepê, Dini ghi n꞉ii ngê nmyi Mî ngê u yoo chóó adî y꞉enê, yi yéli yi kada pini knî y꞉oo wa pyódu nmyo. ");
INSERT INTO yle_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","Yesu ngê yepê, Pini n꞉ii u ngópu ndapî a tóó, dyámê mbêmê, wonêwodiyédiyé a nuw꞉onuw꞉o ngê, dpo, L꞉âmo mokîdangê ngee ó pi ngê kîngî t꞉âmo. Yepê, U kpîdî mb꞉aa knî yi p꞉uu mye nuw꞉o yédi, dpo, Tpile we ngê kîngî dyênê té. Yepê, Nmyi tpile yilî nmyi nuw꞉onuw꞉o u kópu ngê nmye kîngî pyaa dmi, nmyi ndapî nmyi nuw꞉onuw꞉o u kópu ngê myekîngî pyódu. Yepê, Nmyi tpile yilî kwéli a pyede, dye ghi yintómu nmyi nuw꞉o dmi y꞉i adî kwo. Yepê, Nmyi nuw꞉o dmi dyámê mbêmê kîngî kwo, ngmênê mbóó p꞉uu choo kwo. Yepê, Nmyi tpile yilî pi knî ye dpî y꞉ee tóó, nmye wa pwila t꞉oo, yi ndapî dpo ngî yó, ngópuch꞉anê knî ye dpî y꞉ee yó. Yepê, Yi ndapî Chóó Lémi ngê mbóó p꞉uu ya mb꞉aa ngê nmye amîmê wumo. Yepê, Doo u ntââ yi yáni mb꞉aa kpáápi knî y꞉oo daawa t꞉âmo ngmê, tpile we knî y꞉oo myedaawa dyênê ngmê. ");
INSERT INTO yle_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesu ngê p꞉uu ndiye pyu knî ye mgongo ngmê kwólu, yepê, A kuwó mgîdî wa a ghay, ngmênê dpî ngê kêê kîdmyenêngê t꞉ee ngmê, nmyi dpodo u kpîdî dmi nmyi mbwo kîdmyenêngê ngee t꞉oo, nmyi lam dmi kîngî pw꞉oo dmi, dny꞉oo pîpî. ");
INSERT INTO yle_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yepê, Lémi knî y꞉oo yi dpodo pyu yoo wunê kuwokuwo tumo, yedpo, Dmyinê t꞉âât꞉ââ nmo, kîd꞉oongê dpî dmi. Yepê, Dini ghi n꞉ii ngê yi lémi yoo dpo diyé dmi, keńe p꞉uu wunê depedepe nyédi, yi dpodo pyu knî y꞉oo keńe ye dpî kpêmî t꞉oo, yi lémi yoo yi nté dpo têêdî ngmê. ");
INSERT INTO yle_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Yepê, Yi lémi ngmê ngê mgî wa a pwaa knomomê, mgîdî ńuknîńuknî p꞉uu wamî t꞉aa, u dpodo pyu knî yi p꞉uu ada a nuw꞉o, awo, A dpî té, ó a t꞉âât꞉ââ nê? Yepê, N꞉ii u dpodo pyu yoo daadnyi dpî, yi kada pini adnyi t꞉âât꞉ââ, yi pini u gha d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê wa pyódu. Yepê, K꞉omo tpile u dpodo pyu yoo, ngmênê chóó u nté wa a têêdî, ye wa y꞉oo. Yepê, Wamye chaa kalê té, yi gha dmi mb꞉aamb꞉aa ngê wamye pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yi kópu p꞉uu Yesu ye myedoo mgongo, yepê, Ala kópu ny꞉ee yó. Yepê, Nmyi lama daa tóó wéni n꞉ii ngê kpáápi ngê nmyi ngomo wa pwââ. Yepê, Yi wéni nmyi lama adî ya knomomê, wanmyi t꞉ââ ngmê, am꞉ii ngm꞉ii kalê ngmê. ");
INSERT INTO yle_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yepê, Yinté myedmyinê t꞉âât꞉ââ nê, mu kópu u dîy꞉o dini ghi n꞉ii ngê nmyinê nmye Chóó Lémi u Pi Ndêndê daawa t꞉aa, yepê, vyîlo yi dini ghi ngê wanê t꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita Yesu ka póó wo, kwo, Nmî Lémi. Kwo, Ye mgongo nmî mo nmo chi kwolo, ó pi yintómu knî yi k꞉ii? ");
INSERT INTO yle_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nmî Lémi ngê yepê, A yoo yi kada pini ngê wanmyi pyaa dmi. Yepê, Ala kópu ny꞉ee yó. Yepê, Lémi ngmê ngê pi ngmê wa ngmidi, u dpodo pyu yoo yi kada pini ngê wa pyódu, u kwo wa vyi, kwowo, Dy꞉oo ye cha a châpwo, yi nté ndapî ye chi yémî dê. Yepê, Yi lémi kuughê wa lê, dye ghi daadîî y꞉i adîn꞉aa ya. Yepê, Pini n꞉ii wa ngmidi, dpodo pyu yoo yi kada wa kââ, yepê, yi pini u nuw꞉o ndîî ngê adî ya knomomê, u l꞉êê ghi mb꞉aamb꞉aa ngê a myaa ya, ye yi pini lónté adî dpodo? ");
INSERT INTO yle_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yepê, Dini ghi n꞉ii ngê yi lémi u p꞉o amêdê diyé, tpile yilî yintómu mb꞉aamb꞉aa ngê wa m꞉uu té, ye u gha mb꞉aamb꞉aa ngê wa pyódu, ");
INSERT INTO yle_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","dpodo pyu yoo yi kada pini wa chaa kwolo, u tpile yilî yintómu u kwo wa y꞉ee té, yi kada pini ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yepê, Ngmênê yi lémi ghêlî daawa taa knomomê, dpodo pyu knî yi kada pini alanté adî nuw꞉o, awo, Nmî lémi kêma amêdê diyé, yepê, yi pini pi dono ngê wa pyódu, adî ńuknweńuknwe, mbwaa adî ndanî, u ngwo adî ghétighéti, dpodo pyu dpodo módó yoo adî kpakakpaka dé, ");
INSERT INTO yle_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ye dpodo pyu yoo yi kada pini doo u lama, yi lémi ayi t꞉aa. Yepê, Yi kópu dini ghi n꞉ii ngê wa ny꞉ee té, d꞉ud꞉umbiy꞉e yi pini ka wa nod꞉e, dnyinté daawa kpada, kuwa yéli yi vy꞉o wa kââ. ");
INSERT INTO yle_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yesu ngê yepê, Dpodo pyu n꞉ii u lama u lémi u kópu dyuu mb꞉aamb꞉aa ngê a kwo yédi, ngmênê a mgeemgee yédi, u dpodo daawa dóó knomomê, ye u lémi ngê yi pini dpodombiy꞉e wa kpada. ");
INSERT INTO yle_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yepê, Ngmênê n꞉ii u lama dnyinté a ya yédi, ngmêdpî kn꞉aadi, u lémi ngê dpodombiy꞉e d꞉uudpî kpada. Yepê, N꞉ii u lama a kópu dyuu dnyinté a kwo, dnyinté adî chââchââ. Yepê, N꞉ii u lama a kópu dyuu mb꞉aamb꞉aa ngê a kwo, d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê choo chââchââ. ");
INSERT INTO yle_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesu ngê yepê, M꞉aa u yâpwo têdê chââ ntee tpile ngê dê pyódu, nté woo kapî y꞉i doo u ntââ. Yepê, Ala kópu u l꞉êê dîy꞉o nê loo, nê, Yi chéli nîmo vyuwó. Yepê, U ya a nga a kwo, Yi chéli d꞉ââ nîmo vyuwó. ");
INSERT INTO yle_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yepê, Daa kêmakêma dono u mênê anînê wupwo, yi dono p꞉uu nuw꞉o ngê dê dyênê nê, u dî yi p꞉eeni kópu a nga wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yesu ye póó wo, yepê, Nmyinê nmye yoo kââdîkââdî u l꞉êê dîy꞉o dyámê mbêmê nê loo, apii? Yepê, Ngmênê kêle, daa yoo kââdîkââdî u l꞉êê dîy꞉o nê loo, nê, Yoo n꞉uu chámê. ");
INSERT INTO yle_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yepê, Yoo chámêchámê kn꞉ââ wunê kîdî chaa, dye ghi yintómu a l꞉êê dîy꞉o yoo adnyi numo chámêchámê. Yepê Pi mupwoknî limi knî kwéli adnyi ya, a l꞉êê dîy꞉o wanîmo chámê té, pyile miyó dê yi p꞉uu adî d꞉uu, miyó myenté pyile knî yi p꞉uu adî d꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yepê, Yi pini mupwo noko dnyinté adpî ya, u kpâm tp꞉oo módó k꞉ii noko dnyinté adpî ya, u ń꞉ââ k꞉ii noko dnyinté amyidu ya. ");
INSERT INTO yle_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu ngê Nju tpémi ye yepê, Dini ghi n꞉ii ngê nkalî nmye mumu ngópu, nye, Daa kêmakêma tpii wunê ghayghay, yepê, yed꞉oo tpii dpo ghay. ");
INSERT INTO yle_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yepê, Dini ghi n꞉ii ngê mgîdî vy꞉o pudu yilî a kwo yédi, nye, Mââ kââdî y꞉ay꞉a wa pwiyé, yepê, yed꞉oo womumo kââdî y꞉ay꞉a dpî pwiyé. ");
INSERT INTO yle_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yepê, Lukwe dîy꞉o my꞉oo nmye pyede. Yepê, Kópuni mbóó p꞉uu nmye mumu tumo, mb꞉aamb꞉aa ngê nmyinê wopwe tumo, ngmênê kópuni n꞉aa d꞉uud꞉uu too, lukwe dîy꞉o dênmyinê wopwe t꞉oo. Yepê, Lukwe dîy꞉o dp꞉ee myeme nê. ");
INSERT INTO yle_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesu ngê yepê, Lukwe dîy꞉o nmyi nuw꞉o kwolo ngmê dé. ");
INSERT INTO yle_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Yepê, Dini ghi n꞉ii ngê ngmanmyi kn꞉aadi ngmê, n꞉ii ngê u yi adî kwo, Nî kóté kalê nmyo, dini ghi n꞉ii ngê kóté têdê adî ńeńe nmyo, yi kópu maa p꞉uu d꞉ââ dpî l꞉âmo yó, yed꞉oo kóté y꞉enê pyu u ngîma mêdaanmy꞉uu ghê dmi, mbwa k꞉oo mêdaamî km꞉êê nmyo. ");
INSERT INTO yle_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yepê, Mbwa k꞉oo wa km꞉êê nmyomomê, y꞉i anmyin꞉aa ya, u dî nmyi dono ntênê wanmyi pwila t꞉oo. Yepê, Daa kêmakêma kóté têdê n꞉aa ńeńe nmyo, nmyi kópu dmi d꞉ââ l꞉âmo tóó. ");
INSERT INTO yle_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yi dini ghi ngê pi knî ngmê ta, Yesu ka mdoo a ńuwo ngópu, kwo, Nkálili pi knî ngmê y꞉oo Chóó Lémi ka kpêê dnye yiyé, kwo, Lóma lede knî y꞉oo kî vya tumo. ");
INSERT INTO yle_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu ye póó wo, yepê, Lukwe dîy꞉o yinté pw꞉oo dniye? Yepê, Yélini pw꞉oo dniye, nmyinê nmye yi dono ndîî, wo yéli yi dono daa ndîî, apii? ");
INSERT INTO yle_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yepê, Kêle, yinté daa tóó. Yepê, Ala kópu ny꞉ee yó. Yepê, Nmyi dono daanmyinê kuwo t꞉oo, ye yi yéli ntee pw꞉oo dniye, yinté am꞉ii pw꞉oo dmi. ");
INSERT INTO yle_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yepê, Dini ghi n꞉ii ngê ngomo daadîî pwaa wo, Sailówam, pi y꞉a mê wááli vyâ, yepê, lukwe, yi yéli yi dono ndîî, wo yéli yi dono daa ndîî? ");
INSERT INTO yle_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yepê, Kêle. Yepê, Ndê kópu nmye ngmên꞉aa tpapê, nmyi dono yilî daanmyinê kuwo knomomê, ye yi yéli yi nt꞉anê wanmyi yaa dmi, wam꞉ii pw꞉oo dmi. ");
INSERT INTO yle_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu ngê Nju tpémi ye mgongo ngmê kwólu, yepê, Lémi ngmê, u kuwe kn꞉ââ ngmêdoo kwo. Yepê, U yi u ngwo doo kwo, Kuwe kîgha ngmênî ma, ngmênê dêpê pyw꞉ângo, ");
INSERT INTO yle_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","wod꞉oo u dpodo pyu ka kwo, M꞉ââ pyile kî yini kîgha d꞉oongmê ndîî, kwo, kp꞉anê ngi, daadî kwo. ");
INSERT INTO yle_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yepê, Ngmênê yi dpodo pyu ngê kwo, A lémi, ghêlî nangê kpono, m꞉ââ mu ngmidi u kwo yéni. Kwo, Têpê ngê mênî wuwó, tpile tp꞉oo knî yi kn꞉êê u mênê n꞉aa yiyé. ");
INSERT INTO yle_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kwo, Kî m꞉aani ngê nt꞉u nkwodo daawa kaa knomomê, ye u ngwo dpî kp꞉anê ngi. ");
INSERT INTO yle_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lîme wo ngmê ngê Yesu ngêpê ngomo k꞉oo doo dêêpî. ");
INSERT INTO yle_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pyââ y꞉i ngmêdoo ya, kmêna u ngwo ngmêdoo kwo, yi pyópu duwoduwo kwólu, m꞉ââ y꞉a mê wááli yinté doo m꞉ii, ntênê paa doo u ntââ ngê u kwo dpîmo ya. ");
INSERT INTO yle_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Dini ghi n꞉ii ngê Yesu ngê módu, kwo, A pwiyé, wod꞉oo Yesu ka loo. Kwo, A ch꞉am. Kwo, Kópuni ngê dyênê nyoo, dî chedê. ");
INSERT INTO yle_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Wod꞉oo Yesu ngê kóó dê kpadama yé doo, kwo, Mbwó a pyidu ngi. Yi ngwo yi pyópu ngê mbwó yedê pyidu ngê, Chóó Lémi doo chaa kîgha. ");
INSERT INTO yle_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yi ngêpê ngomo u kada pini nod꞉e wo, mu kópu u dîy꞉o Yesu ngê lîme wo ngê yi pyópu pyi ngê, wod꞉oo pi knî ye yepê, Wo wéni dpodo u wo, yi wéni knî y꞉oo nmyi pyipyi u l꞉êê dîy꞉o dmyina a lêpî, ngmênê daa lîme wo ngê. ");
INSERT INTO yle_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","16","Yesu ngê yi pini ka kwo, Nmyo k꞉omodanê pyu yoo, kópuni nmye tpapê tumo, yi kópu dp꞉ee d꞉uud꞉uu tumo. Kwo, Setan ngê ala pyópu ló dini a kudu ngê, m꞉ââ y꞉a mê wááli doo duwoduwo. Kwo, Lîme wo ngê yi yedê dî pywálî, nmyinê nmye dono kópu yidî d꞉uu, ngmênê yinté kópu kîmy꞉ee d꞉uud꞉uu tumo. Kwo, Lîme wo ngê nmyi hósi ndonki knî yi yedê kînmye pywálîpywálî tumo, mbwaa paa nmye ńeńe tumo, mbwaa y꞉i dp꞉uu nda ngmê. Kwo, Daa hósi ntee tpile yidî pywálî, ala lîme wo ngê. Kwo, Epîlaham u tii ńedê pyópu ngmê yidî pywálî. ");
INSERT INTO yle_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yélini Yesu p꞉uu dnye d꞉uu, yi kópu u mywene ye ghê wo, wo yéli yi gha dmi mb꞉aamb꞉aa ngê pyodo, apê, Nmî nuu u kópu ye d꞉uud꞉uu too. Yi kópu knî yi l꞉êê dîy꞉o dnye chaa kîgha. ");
INSERT INTO yle_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu ye póó wo, yepê, Chóó Lémi ngê u yoo y꞉enê kn꞉ââ lónté wa chaa? Yepê, Yi kópu p꞉uu lónté anî mgongo? ");
INSERT INTO yle_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yepê, Kwee ntee dpî k꞉aa, Chóó Lémi u yoo yinté yilî ngê amî pyódu. Yepê, K꞉omo tpile kwee pii tp꞉oo daa ndîî ngê wunê kwo yédi, ngmênê dini ghi n꞉ii ngê yi nkwodo dpî kee, dpî tîpîtîpî mb꞉anê, pywápê ye ya yédi. ");
INSERT INTO yle_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Myombó Yesu ngê yepê, Chóó Lémi u yoo kaakaa p꞉uu lónté anî mgongo. ");
INSERT INTO yle_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yepê, Alanté. Yepê, Mbîdédi nk꞉êênî têdê pyââ ngê yis knî tp꞉oo dpo ngî, k꞉omo tpile kpo ndîî u mênê dpî yé, ngmênê u kuwó dini ghi ngê kpo yintómu dpî mbó. ");
INSERT INTO yle_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","U kuwó dini ghi ngê Yesu, p꞉uu ndiye pyu knî yi k꞉ii Njedusalem dnye lêpî, maa p꞉uu p꞉aani p꞉aani yoo doo ndiye kîgha dé. ");
INSERT INTO yle_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pi ngmê Yesu ka póó wo, kwo, Nmî lémi, pi yilî Chóó Lémi kóó k꞉oo wa ghê, ó daa yilî? ");
INSERT INTO yle_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesu ngê yepê, Chóó Lémi keńeni t꞉âmo wunê tóó, yi keńe kwólu puu daa ndîî. Yepê, Yi keńe t꞉âmo koko, ndîî kópu ngê nmye choo ya, dpodombiy꞉e ghê dmyeno, yi keńe t꞉âmo paa kee dmyeno. Yepê, Ndê kópu nmye ngmên꞉aa tpapê, pi yilî y꞉oo u yi y꞉e wadî kwo, awo, Yi keńe t꞉âmo nm꞉uu kee dmi, ngmênê wa dêê dmi. ");
INSERT INTO yle_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yepê, Ngomo chóó wa gh꞉êêdê, keńe nmye wa a kuwo. Yepê, Kuwa anmya a kwo, keńe p꞉uu anmya a depedepe, kwonye, Nmî Lémi, keńe nmo a kpêmî ngi. Nmyewo, Dp꞉ee a lama yéli, kwéli dmyinê ndê dmi, a lama myedaa tóó. ");
INSERT INTO yle_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kwonye, Ṉg꞉ii kînmee a yakmaapî, nmî p꞉o kînyoo a ndiye kîgha nmo. ");
INSERT INTO yle_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nmyewo, Dp꞉ee a lama yéli, kwéli dmyinê ndê dmi a lama myedaa tóó. Nmyewo, A nkîgh꞉ê a y꞉ee dmyeno, nmyi l꞉êê ghi dmi dono dé. ");
INSERT INTO yle_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yepê, Dini ghi n꞉ii ngê Epîlaham mupwo káámi, Chóó Lémi u komo kapî pyu yoo yi k꞉ii Chóó Lémi kóó k꞉oo wanmyi m꞉uu t꞉oo, ngmênê kuwa anmyi kwo, yi ngwo tpéé kópu wanmyi vyi ngmê, anmyi mbê, anmyi nod꞉enod꞉e, nmyi kpéngi ti dmi kelekele adnyi paa. ");
INSERT INTO yle_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yepê, Kn꞉aa dyámê kn꞉aa dyámê tpémi Chóó Lémi kóó k꞉oo am꞉ii m꞉uu t꞉oo, anye, Nipi ka yakmaapî té. ");
INSERT INTO yle_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yepê, Yi ngwo kada yéli mê kuwó, kuwó yéli mê kada. ");
INSERT INTO yle_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yi dini ghi ngê Yesu Nkálili Wee u kwo modoo ya, ghêlî dêpê kuwo ngê, Pádisi knî u kwo ngmê loo, kwo, Kn꞉aa chi lêpî, king Antipas Helodi u wee a kuwo ngi, u yi u ngwo a kwo, Nyi nî vy꞉a. ");
INSERT INTO yle_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu ngê yepê, Ye pini chii w꞉ââ ntee pini, ala kópu u kwo nyi vyi yó, kwipi, Nê ngê yoo yi kmêna ka ngm꞉ii kîgha té, myeka pi pyipyi, mââ m꞉ii kêlê u dpodo wa chedê, kada u ngwo wa a y꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yepê, Doo u ntââ al꞉ii daanî ya. Yepê, Mââ m꞉ii kêlê Nkálili Wee anê kuwo, Njedusalem anî lê. Yepê, K꞉omo tpile Chóó Lémi ngê Njedusalem a ngmidi ngê, u nuu u p꞉aa ngê pyódu ngê, ngmênê yi p꞉aani tpémi y꞉oo u komo kapî pyu yoo y꞉oodnyimo a vyee dé. Yepê, Chóó Lémi u komo wodînî kapî, ye al꞉ii pîdmyi vya nê. ");
INSERT INTO yle_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yi Pádisi knî ye yepê, Ee Njedusalem tpémi, nmye vyuwo pyu lukwe dîy꞉o dmyongê mya ngópu. Yepê, N꞉ii knî y꞉oo Chóó Lémi u komo nmye dnyimo a kapî, nmyimo a kpadakpada dé, woni yoo chêêpî ngê nmyi vya tumo. Yepê, Kêmkêm ngê tp꞉oo w꞉uu ńuupee dê yi maknopwo ntee dpî w꞉êê té, daa ng꞉êêntómu nê, Yinté nî w꞉êê nmyo, ngmênê a wépi nmyi pwaa ngópu. ");
INSERT INTO yle_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yepê, Mu dini ghi ngê Chóó Lémi ngê nmyi p꞉aa d꞉ud꞉umbiy꞉e wa a kuwo, amyinê kuwo, mêdaamunmyi m꞉uu nê, u dî wéni n꞉ii ngê anmyi vyi ngmê, anye, Pini n꞉ii Chóó Lémi u pi mbêmê a m꞉ii, Chóó Lémi ngê ntênê choo a ngêêpî. ");
INSERT INTO yle_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lîme wo ngmê ngê Pádisi yoo yi kada pini ngmê u ngomo k꞉oo Yesu doon꞉aa kmaapî. Yélini y꞉i dnye ya yi ngwolo dmi Yesu p꞉uu doo kwo, dêpê y꞉ee tumo. ");
INSERT INTO yle_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pi ngmê, kóó kpâlî mbó ngmê dé, Yesu ka loo, ");
INSERT INTO yle_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","wod꞉oo Yesu dêêpî pyu knî ye Pádisi knî ye póó wo, yepê, Nmî dêêpî kópu dyuu angênté a kwo? Yepê, Lîme wo ngê pi ngmanyi pyi, ó doo u ntââ? ");
INSERT INTO yle_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ngmênê u póó u kwo daa vya ngópu, kópu u kwo myedaa vyi ngópu. Wod꞉oo Yesu ngê yi pini pyi ngê, p꞉o mê dy꞉ââ ngê. ");
INSERT INTO yle_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wod꞉oo ye mê póó wo, yepê, Nmyi vy꞉o pini ngmê, tp꞉oo lîme wo ngê mgî k꞉oo wa ghîî knomomê, doo u ntââ chóó mêdaawa a kee, yepê, lukwe, lîme wo u l꞉êê dîy꞉o u mî ngê yi tpémi yi mgini k꞉oo wa a kuwo? Yepê, Kêle, daawa a kuwo, lîmîlîmî ngê amêdê pêêdî. Yepê, K꞉omo tpile daa tp꞉oo yedê ghîî, ngmênê u pudumakó ayedê ghîî, k꞉omo tpile lîme wo, wamyedê pêêdî. Yepê, Daa pudumakó ntee tpile yidî pyi, ngmênê pi yidî pyi. ");
INSERT INTO yle_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yesu ka u kópu daangmê vya ngópu, dêê dniye. ");
INSERT INTO yle_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Dini ghi n꞉ii ngê kmaapî têdê dnye koko, kada pini yoo yââyââ têdê mb꞉aa mî yaa dniye. Wod꞉oo Yesu ngê mgongo ye ngmê kwólu, yepê, ");
INSERT INTO yle_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Dini ghi n꞉ii ngê pi ngmê ngê kmaapî têdê amênê dóó kalê nmyo, yââyââ têdê mb꞉aa ghêlî k꞉ii kada nangmên꞉aa yââ. Yepê, Nmyi lama daadî ya, yi pini ngê kada pini ndîî ngmêdumu dóó kwolo. ");
INSERT INTO yle_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yepê, Yi pini ngê ala kópu nmye wa vyi, nmyewo, Ghêlî k꞉ii kada pini u ya têdê dmyen꞉aa yaa dmi, nmyewo, mwada y꞉i nyinê yaa dmyeno, kada pini yoo al꞉ii a yââyââ té. Yepê, Mywene nmye wa ghê, pi kamî yoo yi vy꞉o anmy꞉uu yaa dmi. ");
INSERT INTO yle_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yepê, Yélini yi pi dmi têdê, yi vy꞉o p꞉ee dmyina a yââyââ, naa chóó ngê ala kópu chóó nmye choo a tpapê, A léma, a pwiyé dmyeno, léma yi vy꞉o myanyi yaa dmyeno. Yepê, Pi knî yi ngîma nmyi pi dmi ndîî ngê u ngwo wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yepê, N꞉ii ngê u pi chóó a kmîmî ngê, Chóó Lémi ngê yi pini u pi têdê ngê wa a pyódu, n꞉ii ngê chóó u pi wunê ghîpîghîpî ngê, Chóó Lémi ngê yini u pi ndîî ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","U kuwó dini ghi ngê Yesu ngê ngomo chóó ka kwo, Dini ghi n꞉ii ngê nté nyimo l꞉âmol꞉âmo knomomê, m̱yipe yoo, m̱wó yoo, ṉêni yoo, ndáápi ndîî yoo nama a dóó kîgha dé, mu kópu u dîy꞉o dîyo yi kmaapî têdê kmaapî têdê u nkwo adnya a dóó kîgha ngi, yi ntini u ngwo moo ngomontaa ngmê. ");
INSERT INTO yle_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kwo, Ngópuch꞉anê yoo, kóó kpêê dé, kpâlî kpêê dé, ngwolo kopwe dé p꞉ee yicha a dóó kîgha dé. ");
INSERT INTO yle_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kwo, K꞉omo tpile doo u ntââ dé, yi ntini daawa ngomontaa ngmê, ngmênê Chóó Lémi ngê dini ghi n꞉ii ngê yoo mb꞉aa kpêênî wa a pyidu té, wamyedê pyidu ngi, ya mb꞉aa u ngwo wanyimu pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yélini y꞉i dnye kmaapî, yi vy꞉o pi ngmê ngê Yesu ka kwo, Dyámê mbêmê nipi kmaapî daa ndîî kópu. Kwo, Dini ghi n꞉ii ngê Chóó Lémi ngê kmaapî têdê kóó k꞉oo wa a dóó kalê nmo, yi ngwo w꞉aa d꞉ud꞉umbiy꞉e wanmîmo pyw꞉oo, apii. ");
INSERT INTO yle_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu ngê mgongo ye ngmê kwólu, yepê, Lémi ngmê ngê kmaapî ndîî u l꞉êê dîy꞉o wo ngmê ngmidi ngê, pi yilî mînê dóó kwólu, yepê, a kmaapî têdê dp꞉uu taa dmyeno. ");
INSERT INTO yle_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yesu ngê yepê, Yi wéni dini ghi n꞉ii ngê dyimê wo, u dpodo pyu ngmê dy꞉ââ ngê, kwo, Yoo a pwiyé we, ala kópu ye nyi vyi, Tpile yilî yintómu machedê, kmaapî ala. ");
INSERT INTO yle_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yepê, Wod꞉oo yi pini ye loo, u lémi u kópu ye doon꞉aa tpapê, ngmênê u kwo nganê mbê dniye. Yepê, Pi ngmê ngê kwo, Doo u ntââ daanî nî. Ṉgada pini ka dpî vyi ngi, A yâpwo têdê kamî kwéli adî ya, yi ghi nîmo mumu. ");
INSERT INTO yle_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yepê, Ngmê ngê kwo, Doo u ntââ daanî nî. Ṉgada pini ka dpî vyi ngi, Pudumakó y꞉a dî pwila, p꞉o nînê ńeńe té. ");
INSERT INTO yle_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yepê, Ngmê ngê kwo, Doo u ntââ daanî nî. Ṉgada pini ka dpî vyi ngi, Ala ngwo até dî yéé. ");
INSERT INTO yle_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yepê, Yi dpodo pyu u lémi ka mê diyé wo, yi kópu yilî u kwo mînê nté ngê, wod꞉oo yi lémi d꞉ud꞉umbiy꞉e nod꞉e wo, apê, A wépi lukwe dîy꞉o da pwaa ngmê. Yepê, U dpodo pyu ka kwo, P꞉aani pee p꞉aani pee chi lêpî, ngópuch꞉anê yoo, kóó kpêê dé, kpâlî kpêê dé, ngwolokopwe dé a ńuw꞉o té. ");
INSERT INTO yle_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Yepê, Wod꞉oo loo, yi ngópuch꞉anê yoo a ńuw꞉o too, u lémi u ngomo k꞉oo km꞉êê too, u kuwó dini ghi ngê u lémi ka kwo, Pi knî m꞉uu yi p꞉aa dmi ka tóó. ");
INSERT INTO yle_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yepê, Wod꞉oo yi lémi ngê kwo, Kn꞉aa p꞉aani tpémi al꞉ii myedê ńuw꞉o té, a ngomo pêdê nt꞉ee y꞉e. ");
INSERT INTO yle_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kwo, Yélini mwiyé nê dóó kalê too, a nté pee tp꞉oo daangmêwa ma ngmê. ");
INSERT INTO yle_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","U kuwó dini ghi ngê Yesu ngê kada a y꞉ângo, doo paa, maa p꞉uu pi yilî knî y꞉oo dnye yâmuyâmu, wod꞉oo ye diyé wo, ");
INSERT INTO yle_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","yepê, N꞉ii ngê a p꞉uu dpodo u l꞉êê dîy꞉o, u pye mî, u kpâm ghee knî, u tîdê mbwó yoo u mbodo kn꞉ââ vyuwó daawa yé té, doo u ntââ a p꞉uu daawa kaalî. Yepê, Myenté, n꞉ii ngê chóó u nuu u kópu dé u mbodo kn꞉ââ vyuwó daawa yé té, doo u ntââ a p꞉uu myedaawa kaalî. ");
INSERT INTO yle_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yepê, Ala kópu ny꞉ee yó. Yepê, Mu dini ghi ngê pi dono knî y꞉oo a yoo vy꞉o yéli adnyin꞉aa kpakakpaka dé, woni amyimî vya t꞉oo. Yepê, N꞉ii ngê a l꞉êê dîy꞉o dono daawa a vy꞉u, a l꞉êê dîy꞉o myedaawa pw꞉onu, yepê, yi pini wa dîpî, a kêê k꞉oo daamî ghê. ");
INSERT INTO yle_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Yepê, A yâmuyâmu ngê ghêlî k꞉ii kêê nangê t꞉oo, yi kópu p꞉uu mb꞉aamb꞉aa ngê mwiyé dmyinê nuw꞉o, anmya a yâmuyâmu nê, ó daanmya a yâmuyâmu nê. Yepê, Dyimê pywuu nmye ngmênînê kuwo. Yepê, N꞉ii ngê u yi adî kwo, Nkéli ndîî ngmênî pwila, lémi ngê u ngwo nî pyódu, yepê, yi pini ngê chóó u ndapî mb꞉aamb꞉aa ngê mwiyé dpo kp꞉aa ngê, mu kópu u dîy꞉o nkéli ńuknî a tóó. ");
INSERT INTO yle_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yepê, Chóó u ndapî mwiyé dnyinté wa a kp꞉aa knomomê, u ndapî doo u ntââ ngê wa pyódu, u nêni knî ye amêdîn꞉aa nkêpê. Yepê, Wa dêê knomomê, nkéli daawa pwila knomomê, ye pi knî y꞉oo wa yumu ngmê, wamye nkwiti ngmê. ");
INSERT INTO yle_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Yepê, Yi pini p꞉uu adnyi danê, noko yewo, U yi u ngwo doo kwo, Kópu ndîî ngmênî d꞉uu, ngmênê kêdê dîpî. Yepê, A yâmuyâmu ngê ghêlî k꞉ii kêê nangê t꞉oo, yi kópu p꞉uu mb꞉aamb꞉aa ngê mwiyé dmyinê nuw꞉o. ");
INSERT INTO yle_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Yepê, Myenté, dyimê pywuu nmye munînê kuwo. Yepê, Lede yoo yi kada pini ngmê, dini ghi n꞉ii ngê ala kópu wa ny꞉oo, awo, Kn꞉aa lede yoo yilî kîyedê pwiyé dniye, nmî lede yoo daa yilî, yepê, yi pini mbwódo wa yââ, mb꞉aamb꞉aa ngê adî nuw꞉o. ");
INSERT INTO yle_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yepê, U yoo doo u ntââ ngê adî ya knomomê, ye yi pini ngê u pi knî angmê dy꞉ââ, wo lede yoo yi kada pini ka kwowo, L꞉êê u yi nmo daa kwo, mb꞉aamb꞉aa u yi nmo ye kwo, kópu mb꞉aamb꞉aa ngê mêpaa l꞉âmo koo. Yepê, Mwiyé daadî nuw꞉o knomomê, u lede yoo l꞉êê têdê wa dy꞉ââ tumomê, wo yéli y꞉oo wa vya t꞉oo, kada pini wamye pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yepê, Myenté, mb꞉aamb꞉aa ngê mwiyé dmyinê nuw꞉o. Yepê, N꞉ii ngê chóó u kópu dé daawa kéé té, doo u ntââ a p꞉uu daawa kaalî. ");
INSERT INTO yle_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yepê, Ntii mb꞉aamb꞉aa. Yepê, Nté tpyópu u mênê ntii daanyi yé knomomê, u n꞉uu daadî ya, pwópwó ngê wa pyódu, nanê wa ma. Yepê, Ntii vy꞉êmî têdê nmyi tp꞉ee ngmanmyi dy꞉ââ knomomê, pye nkwodo ntii wa vy꞉êê knomomê, yini pwópwó, u n꞉uu daadî ya, ye lónté mb꞉aamb꞉aa ngê wa pyódu? ");
INSERT INTO yle_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yepê, Doo u ntââ. Yepê, U dpodo daadî ya, wanmyi pii ngmê. Yepê, N꞉ii knî yi ngópu puu a pyede, yi kópu ny꞉ee y꞉e, p꞉uu dny꞉oo nuw꞉o. Yepê, N꞉ii ngê k꞉omo ngê wunê yâmuyâmu nê, mye yinté pini, u dpodo daadî ya, wanî kéé. ");
INSERT INTO yle_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wo ngmê ngê tákisi ngêêpî pyu yilî Yesu ka lee dniye, yélini Pádisi knî y꞉oo mwiyé kéé tumo, u kwo mye lee dniye, danêmbum têdê dnyen꞉aa ng꞉aang꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yesu yi vy꞉o doo kwo, mywene u ngwo myedêpwo kwo, wod꞉oo Pádisi yoo dêêpî pyu yoo dnye nuu mbumu, noko yepê, Lukwe dîy꞉o kî pini pi dono knî yi k꞉ii a yakmaapî té. ");
INSERT INTO yle_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wod꞉oo Yesu ngê mgongo ye ngmê kwólu, yepê, Kópu nmye ngmên꞉aa poopoo. ");
INSERT INTO yle_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Yepê, Nmyi vy꞉o pini ngmê, u sipi yonoy꞉a adî kwo. Yepê, W꞉amî mbêmê wa ńuw꞉o té, y꞉i adnyin꞉aa kmaapî. Yepê, Ntumokwodo dini ghi ngê, awo, P꞉o m꞉aa ńuw꞉o té. Yepê, Dini ghi n꞉ii ngê wa a kp꞉aa té, yonoy꞉a daawa m꞉uu knomomê, tonoy꞉a mê chu ayi m꞉uu knomomê, lukwe, ye ala kópu wa vyi, awo, Yonoy꞉ani mwo a p꞉aa, monyi pw꞉oo we? Yepê, Doo u ntââ, yi kópu daawa vyi. Yepê, Tonoy꞉a mê chu kmaapî têdê wa a kuwo té, yonoy꞉ani adîn꞉aa nmy꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yepê, Dini ghi n꞉ii ngê amênê pyw꞉oo, u gha mb꞉aamb꞉aa ngê wa pyódu, wa dnyinê, u nkono wa yé, p꞉o wa ńuw꞉o. ");
INSERT INTO yle_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yepê, U kuwó dini ghi ngê u pyipe knî ye, ngmênêni knî mye yi k꞉ii, ye wa mbwólu, yewo, A da we, a sipi tp꞉oo n꞉ii nî nmy꞉uu, kîmêd꞉a pyw꞉oo, u kmaapî tp꞉oo dóó koo. ");
INSERT INTO yle_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yepê, N꞉ii ngê dono u maa dpo kuwo, Chóó Lémi ka dpo diyé, yi pini u l꞉êê dîy꞉o Chóó Lémi u gha d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê dpî pyódu. Yepê, Yini sipi yonoy꞉ani ntee pini. Yepê, N꞉ii yoo yi nuw꞉o dmi alanté a tóó, apu, Nmo mb꞉aamb꞉aa dé, yepê, yi yéli Chóó Lémi ka daawa diyé dmi. Yepê, Yi l꞉êê dîy꞉o Chóó Lémi u gha mb꞉aamb꞉aa ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yepê, Pyââ ngmê u ndapî y꞉a njini adî ya, yononi l꞉âmo wa a ngee knomomê, lukwe, ala kópu wa vyi, Mwo a p꞉aa? Yepê, Kêle, yi kópu daawa vyi. Yepê, Wadî nmy꞉uu, u tpile yintómu wa w꞉ee té, u ngomo maknopwo ghi wa a gh꞉ii, u dî amênê pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yepê, Dini ghi n꞉ii ngê amêdê pyw꞉oo, u pyipe knî ye, ngmênêni knî mye yi k꞉ii, yewo, A da we, ndapî l꞉âmo n꞉ii nê ngópu, até mêd꞉a pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yepê, Myenté, dini ghi n꞉ii ngê pi ngê u dono yilî dpo kuwo té, Chóó Lémi ka dpo diyé, enjel yintómu yi gha dmi mb꞉aamb꞉aa ngê dpî pyódu. Yepê, Yélini a ka wunê lêpî nyédi, yi dono wunê kuwokuwo tumo, Chóó Lémi ka mêwunê diyédiyé té. Yepê, Yi l꞉êê dîy꞉o nmyi gha dmi lukwe dîy꞉o mb꞉aamb꞉aa ngê daa tóó. ");
INSERT INTO yle_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu ngê Pádisi knî ye mgongo ngmê kwólu, yepê, Pi ngmê, tp꞉oo miyó doo ya. ");
INSERT INTO yle_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yepê, Kaapeeni ngê u mî ka kwo, M꞉aa, ṉ́mile yilî a mbwó k꞉ii ala ngwo nye yéépi. Yepê, Wod꞉oo yi mî ngê u tpile yintómu ye yópu. ");
INSERT INTO yle_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Yepê, Wo wéni knî yi k꞉oo kaapeeni ngê u tpile woni pi knî ye y꞉ee too, u kwo pwila tumo, wod꞉oo kada a y꞉ângo. Yepê, Dyámê pee ngmê mbêmê chono daa loo, y꞉i doon꞉aa ya, u ndapî yilî u pyipe knî yi p꞉uu mî dyênê ngê, nipi dnyen꞉aa mbwaa ndanî. ");
INSERT INTO yle_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yepê, U tpile yilî yintómu l꞉âmo mînê ngópu, yed꞉oo yi dyámê pee p꞉uu m꞉uu ndîî ngmê ghê wo, nté chedê ngê pyodo, yi pini ngê dómudómu myedê pyw꞉ângo. ");
INSERT INTO yle_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yepê, Yi p꞉aani pi ngmê p꞉uu doon꞉aa dpodo, u mbwêmê w꞉uu ka dpîmon꞉aa vyuwo, ngmênê u dpodo u pywuu doo u ntââ yidpîmo a ngêêpî, nté pee tp꞉oo yidpîmo pîpî. ");
INSERT INTO yle_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yepê, Ntini n꞉ii mbwêmê knî y꞉oo dnyimo a pyw꞉êmî, u yi u ngwo dpîmo kwo, Yi ntini my꞉aa ma, ngmênê doo u ntââ, yi ntini daapî ndîî. ");
INSERT INTO yle_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yepê, U nuw꞉o u kwo yimênê diyé wo, apê, Ng꞉aanî dómudómu. Apê, M꞉aa p꞉uu dpodo pyu knî y꞉oo dye ghi yintómu u ntââ ntini yiwunê pîpî ngmê. ");
INSERT INTO yle_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Apê, M꞉aa ka p꞉o mênê lêpî, M꞉aa ka ala kópu an꞉uu vyi, M꞉aa, Chóó Lémi ka noo dono, ṉga myenoo dono. ");
INSERT INTO yle_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Doo u ntââ ṉ́m꞉ee ngê mêdaanî ya, ṉmodo pyu ngê pyódu nédi. ");
INSERT INTO yle_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yesu ngê yepê, Wod꞉oo kada a y꞉ângo, u mî ka p꞉o mê diyé wo. Yepê, Chono dêpwo a m꞉ii, u mî ngê y꞉i a módu. Yepê, Tp꞉oo u mî ka ch꞉anê wo, u mî ngê mbêpê a puwâ, maa p꞉uu mînê pyódu ngê, tp꞉oo u kede paa t꞉ângo, dmi ngmidi kpo, ń꞉uu kpââ pee p꞉uu dyîngo. ");
INSERT INTO yle_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yepê, Tp꞉oo ngê kwo, M꞉aa, Chóó Lémi ka noo dono, ṉga myenoo dono, doo u ntââ ṉ́m꞉ee ngê mêdaanî ya. ");
INSERT INTO yle_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yepê, U mî u kwo daa nod꞉e wo, u dpodo pyu knî ye yepê, Ngomo k꞉oo kpîdî mb꞉aa ngmê nya yó, lîmîlîmî ngê u mbwo nyi t꞉ee yó, yu dópo dê yuwo mye t꞉ee dóó, pi yintómu yi lama yaa we, Ala a tp꞉ee njini. ");
INSERT INTO yle_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yepê, Pudumakó tp꞉oo n꞉ii p꞉uu ntênê yilî a t꞉a, ngmênyi vya yó, kmaapî ndîî ngma a pwaa koo, ");
INSERT INTO yle_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","mu kópu u dîy꞉o a tp꞉ee na a ka kî pwene, kîmêdê pyidu, na a ka l꞉âmo a ngêpa wo, ngmênê até maa t꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yesu ngê yepê, Yi dini ghi ngê tp꞉oo kaa dpodo têdê doo ya. Yepê, Dini ghi n꞉ii ngê p꞉o mêdoo a diyédiyé, maa p꞉uu apê, M꞉aa k꞉ii nyi ngomo k꞉oo lukwe u dnyengi ka kwo, lukwe dîy꞉o ka yumu té, ka wéti té, ka kââkââ té. ");
INSERT INTO yle_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yepê, U mî u dpodo pyu ngmê ka kpede mbê wo, u kwo póó wo, kwo, K꞉ii lukwe ngma a pyodopyodo, ló mââwe ngmêyi t꞉aa? ");
INSERT INTO yle_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yepê, Yi dpodo pyu ngê kwo, M̱wó kîmêdê diyé, m̱î ngê nté pee u l꞉êê dîy꞉o ngmêkêdê l꞉âmo, mu kópu u l꞉êê dîy꞉o dîmî pwene, mêkêda diyé, vyîlo yi dnyengi ye kwo. ");
INSERT INTO yle_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yepê, Tp꞉oo kaani d꞉ud꞉umbiy꞉e u mî ka nod꞉e wo, u yi u ngwo dêpwo kwo, Yi ngomo k꞉oo nî kee. Yepê, Wod꞉oo u mî kuwa u kwo a pwii wo, kwo, Ngomo k꞉oo a kee. ");
INSERT INTO yle_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","U mî ka kwo, Kî m꞉aani yilî kînê vy꞉ungo, m̱꞉uu wâpu noo dpodo. Kwo, Ṉgópu yilî dîpîngmê kn꞉aadi ngê, ngmênê yenté kópu a nga dipingmê d꞉uu ngê, nunukwéti a pyipe knî yi k꞉ii nmo myedipengmê kpo. ");
INSERT INTO yle_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kwo, Ṉ́m꞉ee ngê ṉapî yilî téli pyââ knî yi p꞉uu mî dyênê ngê. Dini ghi n꞉ii ngê p꞉o mêdê diyé, pudumakó u l꞉êê dîy꞉o lukwe dîy꞉o ngmêchi vy꞉a. ");
INSERT INTO yle_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","U mî ngê kwo, A tp꞉ee, al꞉ii dye ghi yintómu ṉg꞉ii nye tóó mo, tpile yilîni a ngópu a tóó, ṉêni dé. ");
INSERT INTO yle_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kwo, Doo u ntââ m̱wó módó daapaa t꞉aa, mu kópu u dîy꞉o na a ka mînî pwene, kîmêdê pyidu, l꞉âmo mînê ngêpa wo, kîmêd꞉a pyw꞉oo. Yesu ngê Pádisi knî ye yepê, Nmyo yi pini tp꞉oo kaa ntee pini dé. ");
INSERT INTO yle_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu ngê p꞉uu ndiye pyu knî ye mgongo ngmê kwólu, yepê, Ndáápi ngmê, u stówa ndîî ngmêdoo kwo. Yepê, Pini n꞉ii ngê yi stówa dpîmo y꞉enê, ndáápi p꞉uu dpîmo dpodo, u lémi u ndapî chóó dpîmo pîpî. Yepê, Ndáápi ngê yi kópu u tuu kââ pee dini ghi n꞉ii ngê nyongo, ");
INSERT INTO yle_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","stówa y꞉enê pyu ka pi ngmê dy꞉ââ ngê, kwo, A pwiyé we. Yepê, Ndáápi ka loo, ndáápi ngê kwo, Ṉgópu ngmêkîdî ny꞉oo, lukwe dîy꞉o a ndapî nye pîpî. A stówa k꞉oo tpile yilî mb꞉aamb꞉aa ngê nyi l꞉âmo té, n꞉aa dyede ngi, a p꞉uu mêdaanyi dpodo. ");
INSERT INTO yle_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yepê, Stówa y꞉enê pyu ngê ala kópu vyu, apê, A lémi ngê kuwa ka kapî nê, angênté wanî pyódu. Apê, Nê pi vy꞉ee, mêd꞉aa kîlî dpodo u ntââ, myenté doo u ntââ a nêni knî ye daanîn꞉aa ndapî dmyinê, mywene a nga amî ghê. ");
INSERT INTO yle_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yesu ngê yepê, U kuwó dini ghi ngê nuw꞉o ghi ngma a pyw꞉ângo, apê, Pi yilî a pyipe ngê n꞉aa pyépi, dini ghi n꞉ii ngê a lémi ngê kuwa wa kaa nê, yi ngomo k꞉oo ngomo k꞉oo u nkwo anîn꞉aa kmaapî. ");
INSERT INTO yle_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yepê, N꞉ii dé yi tp꞉uu yilî yi ndáápi u piy꞉e dnye kwo, yini knî ye pi dy꞉ââ ngê, yepê, A pwiyé dniye. Yepê, Ngmêngmênté doo taataa, stówa y꞉enê pyu k꞉ii tumutumu dpîmon꞉aa danêmbum. ");
INSERT INTO yle_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yepê, Stówa y꞉enê pyu ngê ngmê ka kwo, Ṉ́m꞉uuni a lémi u piy꞉e a kwo, yonoy꞉a. Kwo, N꞉aa ngêêpî ngi, puku yedê limoy꞉a módó n꞉aa vyee, mwo mo u p꞉aa, mê limoy꞉a ṉ́yóó modo kêlî ngi. Kwo, Kópuni dî d꞉uu, pi ka nangê vyi. ");
INSERT INTO yle_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yepê, Myomoni ka kwo, Ṉ́m꞉uu yono yonoy꞉a a lémi u piy꞉e a kwo, n꞉aa ngêêpî ngi, puku yedê my꞉oo yonoy꞉a módó n꞉aa vyee, mwo mo u p꞉aa, wolo yonoy꞉a ṉ́yóó modo kêlî ngi. Kwo, Kópuni dî d꞉uu, pi ka nangê vyi. Yepê, Stówa y꞉enê pyu ngê yinté doo kê, pi yilî u pyipe ngê u ngwo pyódu ngê. ");
INSERT INTO yle_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nmî Lémi ngê yi stówa y꞉enê pyu dono chaa kwólu, mu kópu u dîy꞉o nuw꞉o ndîî u kópu yi d꞉uu ngê. Dyámê mbêmê tpémi nuw꞉o ndîî mbêmê yi chóó ye wunê vyuwo nyédi, ngmênê pywápê u yoo, nuw꞉o têdê mbêmê yi chóó ye wunê vyuwo nyédi. ");
INSERT INTO yle_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yi kópu u l꞉êê dîy꞉o Yesu ngê yepê, Chóó Lémi nmyi pyipe ngê pyódu yó. Yepê, Ndapîni nmyi ngópu a tóó, ngópuch꞉anê yoo u ngwo dmyinê ngêêpî dé, Chóó Lémi ngê u nkwo wa ngee nmyo, ya mb꞉aa n꞉ii chedê ngê daawa pyódu, u ngwo anmyimo pyw꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yepê, Tpile pywupwi têdê pi ngmanyi dy꞉ââ, u l꞉êê dîy꞉o ndapî u kwo anyi y꞉oo, n꞉ii ka ndapî têdê ngmanyi y꞉oo, daangmêwa mgîpa kwolo, u ntââ yi pini ka ndapî ndîî am꞉ii y꞉oo, myedaawa mgîpa kwolo. Yepê, Ngmênê n꞉ii ka ndapî têdê ngmanyi y꞉oo, wa dóó ngi, ṉapî wa mgîpa kwolo, yi pini ka ndapî ndîî nangmê y꞉oo, wamye dóó ngi. ");
INSERT INTO yle_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yepê, Chóó Lémi ngê ngópuch꞉anê knî yi l꞉êê dîy꞉o ndapîni nmyeda kê, ye daanmyi y꞉ee knomomê, anmyi mgîpa kalê knomomê, ye tpile mb꞉aa ndêndê nmye daawa a kê. ");
INSERT INTO yle_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yepê, U ndapî wanmyi mgîpa kalê knomomê, ye tpile mb꞉aa nmye daamuwa a kê. ");
INSERT INTO yle_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yepê, Doo u ntââ pi ngmidi lémi miyó dê yi p꞉uu daadî dpodo. Yepê, Woni u kwo adî diya, woni u nuu u pi ngê adî ya, woni ka dnyinté adî ng꞉aa, woni u dnye mb꞉aamb꞉aa ngê adî nyêmî. Yepê, Doo u ntââ ndapî Chóó Lémi yi p꞉uu kwodonkwodo daanyi dpodo. Yepê, Chóó Lémi chââchââ ndîî kópu ngê nmye choo ya, ndapî kmênêkmênê têdê kópu ngê nmye choo ya. ");
INSERT INTO yle_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yi danêmbum têdê Pádisi yoo ngmêdoo kwo, Yesu u danêmbum dini ghi n꞉ii ngê ny꞉ee ngópu, dnye yumuyumu, mu kópu u dîy꞉o ndapî u yi mb꞉aamb꞉aa ngê y꞉e doo kwo. ");
INSERT INTO yle_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wod꞉oo Yesu ngê Pádisi knî ye yepê, Pi knî yi ngîma nmyi chóó nmyi pi dmi nmye kmîmî tumo, ngmênê Chóó Lémi ngê nmyi gha dmi u lama dé. Yepê, Kópuni nmyi gha vy꞉o dpo m꞉uu, ngmênê u kwo dono, mu kópu u dîy꞉o pi knî yi nuu u kópu dé, Chóó Lémi ka ngmênê u kwo doo u nuu u kópu dé. ");
INSERT INTO yle_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesu ngê yepê, Dêêpî kópuni Mósisi ngê a d꞉êê too, kópuni Chóó Lémi u komo kapî pyu knî y꞉oo myedê d꞉êê tumo, dye ghi daadîî pi knî ye yi kópu dyuu kînmyee a tpapê dé, myenmyee a tpiye dé. Yepê, Nmyi chóó nmyi dêêpî kópu dyuu pi knî ye myenmyee tpapê dé, nmyi pi dmi u ngwo nmyee a kmîmî, ngmênê yi dêêpî kópu dyuu yi chââchââ pi knî ye doo u nt꞉ââ ngê dpî pyódu, u nkwo nmyimo kéké dé, yi yoo kuwa nmyimo kapî dé. Yepê, Ngmênê Njon Baptist ngê kópu kamî kn꞉ââ ngmê chópu. Yepê, Ala ngwo pi knî ye yenîmo, Nmyi dono a kuwo tóó, Chóó Lémi kóó k꞉oo ghê dmyeno. Yepê, Yi dono u nkwo wunê kuwokuwo tumo, a kadakada nyédi, apu, Chóó Lémi kóó k꞉oo nmî kee dmi. ");
INSERT INTO yle_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yepê, Ngmênê mbóó dyámê ntee chedê ngê ghêlî k꞉ii daawa pyaa knî, Chóó Lémi u dêêpî kópu dyuu ndêndê yinté chedê ngê daawa pyódu. Yepê, Nmyi dono yilî daanmyinê kuwo knomomê, ye Chóó Lémi ngê yi dêêpî kópu dyuu mbêmê wa ndyîko nmyo, wamye kpada nmyo. ");
INSERT INTO yle_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yepê, Dyimê pywuu nmye ngmênînê kuwo. Yepê, Yééyéé u dêêpî kópu dyuu ndêndê chedê ngê daawa pyódu, doo u ntââ myedaanmyi ngmêê ngmê. Yepê, Pini n꞉ii ngê u kpâm dpî kpîpî, yi pini ngê kn꞉aa pyópu kîmungê nya. Yepê, Yi pini ngê kn꞉aa pyópu muwa nya knomomê, ye daa yééyéé u kópu ayi d꞉uu, ngmênê pyââ ti u kópu ayi d꞉uu. Yepê, Myenté, pyópuni u moo ngê mwiyé dpî kpîpî, n꞉ii ngê yi pyópu wa nya, daa yééyéé u kópu ayi d꞉uu, ngmênê pyââ ti u kópu ayi d꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu ngê Pádisi knî yi p꞉uu mgongo ngmê kwólu, yepê, P꞉êê nmye ngmênînê nj꞉ii, p꞉uu dmyinê nuw꞉o. Yepê, Pi miyó, woni ndáápi ndîî, woni pinté. Yepê, Ndáápi u kpîdî mb꞉aa dé, u nté mb꞉aa, u tpile yilî yintómu mb꞉aamb꞉aa dé. ");
INSERT INTO yle_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yepê, Pinté u pi Lasadas, ngópuch꞉anê, u pââ yimo vyi, dye ghi yintómu ndáápi u ngomo nkîgh꞉ê dpîmon꞉aa ya, y꞉i myedpîmon꞉aa dpî. ");
INSERT INTO yle_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yepê, U yi u ngwo doo kwo, Ndáápi ngê ngee nêne, nté kmononi d꞉uu kê, a ka a kê ngê, ngmênê yi ndáápi ngê dêdpîmo ngêêpî, u kwo myedaa ch꞉anê wo. Yepê, Doo dómudómu, mye mg꞉eme wo, k꞉omo tpile w꞉ââ knî y꞉oo u yimo dnyimon꞉aa dêêdêê dé, ngmênê doo u ntââ daapodo ngm꞉ii kîgha dé, ndáápi ka myedaa ch꞉anê wo. ");
INSERT INTO yle_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yepê, Dini ghi n꞉ii ngê pwene, enjel knî y꞉oo Chóó Lémi kóó k꞉oo ńuw꞉o ngópu, Epîlaham u nkîgh꞉ê mî yé ngópu, y꞉i doon꞉aa ya. Yepê, U kuwó dini ghi ngê ndáápi mye pwene, ntóó kmênê ngópu, yed꞉oo ndiya mî gho, wélîlî ndîî mînê pyw꞉ângo. ");
INSERT INTO yle_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yepê, Yi vyu wo, apê, Lasadas Epîlaham u nkîgh꞉ê moda tóó ó! ");
INSERT INTO yle_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yepê, Wod꞉oo Epîlaham ka mbwolo, kwo, Kââkââ, ṉga d꞉oo ch꞉anê wo, u ntââ Lasadas anyinê dy꞉ââ, mbwaa kuu k꞉oo kóó pyââ a kmênêkmênê, a dêê yedê wumî nkênkê kîgha, mu kópu u dîy꞉o mgînî vyîmî ndîî atéd꞉a pyw꞉oo, ndiya. ");
INSERT INTO yle_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Yepê, Epîlaham ngê kwo, A kee, dyámê mbêmê munyoo a ya, y꞉i nuw꞉o ngî kwéli. Kwo, Tpile mb꞉aa ṉgópu dêpwo a ghêdê, Lasadas u ya dono, tpile u ngópu dêpwo a ya. Kwo, Ala ngwo ya mb꞉aa até dumu pyw꞉oo, ngmênê anyinê wélîlî mgînî vyîmî. ");
INSERT INTO yle_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Myenté, kwo, nmî kêlî ghê nkéli weelyunkoo ntee ghi ye tóó, y꞉i maa daa t꞉a. Kwo, N꞉ii ngê u yi adî kwo, Nmye nê lê, doo u ntââ, nmye daawa a lê, myenté n꞉ii ngê u yi amya a kwo, Al꞉ii nê lê, myedoo u ntââ, daawa a lê. ");
INSERT INTO yle_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yepê, Ndáápi ngê kwo, Kââkââ, u ntââ Lasadas M꞉aa u p꞉o wanyi dy꞉ââ, a mbwó y꞉i limi kîyedê tóó. ");
INSERT INTO yle_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kwo, Ala kópu ye dp꞉uu vyi ngê, Nmyi mbwó nt꞉anê nangmê yââ, mînê wélîlî mgînî vyîmî. ");
INSERT INTO yle_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Yepê, Epîlaham ngê kwo, Kópuni Mósisi ngê a d꞉êê too, kópuni Chóó Lémi u komo kapî pyu knî y꞉oo myedê d꞉êê tumo puku yedê ka pyede. Kwo, M̱wó knî y꞉oo dny꞉oo a kpââ dé. ");
INSERT INTO yle_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yepê, Ndáápi ngê kwo, Kââkââ, kwo, yenté doo u ntââ, ngmênê pi kpêênî ngmêwa a pyidu, ye wa lê, yed꞉oo yi dono wa kéé t꞉oo, a nt꞉anê daawa a yaa dmi. ");
INSERT INTO yle_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Yepê, Epîlaham ngê kwo, Kópuni puku yedê a pyede daawa ny꞉ee t꞉oo, ye k꞉omo tpile pi kpêênî ngmêwa pyidu, u kwo myedaawa ng꞉aa mbê dmi, yi nuw꞉o dmi myedaawa ngmêê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu ngê p꞉uu ndiye pyu knî ye yepê, Kópuni knî yi l꞉êê dîy꞉o pi knî y꞉oo maa mb꞉aa wa kn꞉aadi ngmê, yi kópu dyuu maa nkîgh꞉ê adnyi kwo, ngmênê n꞉ii ngê yinté kópu yi máádi nkîgh꞉ê ngmada a ńeńe, yi pini d꞉ud꞉umbiy꞉e choo nkîngê. ");
INSERT INTO yle_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yepê, Pini n꞉ii u l꞉êê ghi mbêmê pi kamî knî y꞉oo maa mb꞉aa wa kn꞉aadi ngmê, Chóó Lémi ngê yi pini dnyinté daawa kpada. Yepê, Pi knî y꞉oo yi pini mwiyé wo mgîmî ngópu, chêêpî pââ ndîî nódo ngmêwo kudu ngópu, mbéli u kwo wumê kalê ngópu, ye yi dono ndîî daapî d꞉uu ngê, Chóó Lémi ngê dpodombiy꞉e daapaa kpada. ");
INSERT INTO yle_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yepê, Nmyi chóó nmye dmyina a vyuwo. Yepê, Nmyi mbwó ngê dono kópu angmê d꞉uu, ye u kwo dpî kwódu yó. Yepê, U dono dpo kuwo knomomê, ye u dono nmyi mbodo kn꞉ââ vyuwo dpî kéé yó. Yepê, Ntââ u ngwo nangê vy꞉u. ");
INSERT INTO yle_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yepê, K꞉omo tpile wo ngmidi k꞉oo yi pini nmyi p꞉uu pyud꞉o adî dono knomomê, tpéé kópu pyud꞉o wa vyi knomomê, nmyewo, Dî kn꞉aadi, daamunî d꞉uu, ye u dono nmyi mbodo kn꞉ââ vyuwo pyud꞉o dpî kéé yó, mênangê ngî. Yepê, Ntââ u ngwo myenangê vy꞉u. ");
INSERT INTO yle_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesu u dyépi knî y꞉oo nmî Lémi ka kwo, Nmî kêlîmî ndîî ngê pyódu ngi. ");
INSERT INTO yle_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nmî Lémi ngê yepê, Lukwe dîy꞉o nmyi kêlîmî daa ndîî tp꞉oo? Yepê, Chipa w꞉uu u mênê w꞉uu n꞉ii a kwo, yi tpile daa ndîî tp꞉oo, apii? Yepê, Nmyi kêlîmî wo yintoo, ye kî nkêpe ka pîdmyi vyi ngmê, Kada yéni, nt꞉ee nyi ghé, yepê, yi kópu ntênê paa d꞉uu, nt꞉ee paan꞉aa ghê. ");
INSERT INTO yle_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu ngê u yi dêpwo kwo, A yoo knî y꞉oo yi pi dmi dny꞉oo kmîmî dé, yi kópu u l꞉êê dîy꞉o dyimê pywuu ye ngmê y꞉ângo, yepê, Pi mupwoknî ngmê yâpwo têdê adnyin꞉aa dpodo. Yepê, Lukwe, ntumokwodo yi pini ngê u kpâm ka wa vyi, kwowo, Chi lîme, nté n꞉aa ch꞉eech꞉ee? ");
INSERT INTO yle_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yepê, Kêle. Yepê, Yi pini ngê u kpâm ghee knî p꞉o kada wa kaa té, u kpâm ka kwowo, Chin꞉aa nté ch꞉eech꞉ee, kuwó nînê kwo. Yepê, Yi pini p꞉o dini ghi n꞉ii ngê wa t꞉aa, nté tpyópu ndiya wa m꞉uu, lukwe, u kpâm wa chaa kwolo, kwowo, Y꞉ay꞉a chi pwiyé? ");
INSERT INTO yle_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yepê, Kêle, u dpodo y꞉i a tóó. ");
INSERT INTO yle_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yepê, Nmyo myenté dé. Yepê, Chóó Lémi u dêêpî kópu dyuu yintómu wanmyi châpu t꞉oo, ye nmyi chóó nmyi pi dmi nangê knî. Yepê, Ala kópu dpî vyi yó, Dpodoni nmo a kpo, vyîlo yidu dóó, daa chaa kîgha u dpodo yidu dóó. ");
INSERT INTO yle_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dini ghi n꞉ii ngê Yesu, p꞉uu ndiye pyu knî yi k꞉ii, Njedusalem dnye lêpî, Nkálili Wee Samédiya Wee yi kêlî ghê dnye paa. ");
INSERT INTO yle_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Daa kêmakêma p꞉aa ngmê dnye taataa, pi y꞉a maa p꞉uu a pyódu ngópu, too pee mbii leprîsi ye doo ya. Yi pini y꞉a knî y꞉oo Mósisi u dêêpî kópu dyuu châpu ngópu, Yesu p꞉uu yi nkîgh꞉ê daa nî dniye, ");
INSERT INTO yle_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dpodombiy꞉e u kwo mbó dniye, kwo, Yesu, nmî lémi, ṉga dp꞉oo ch꞉anê dniye? ");
INSERT INTO yle_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu ngê yi m꞉uu too, yepê, Njedusalem lee dmyeno, kpêê yiyé pyu ngê amî m꞉uu nmyo, wod꞉oo kada a y꞉ee ngópu. Maa p꞉uu too pee mbii yi p꞉uu machedê ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yi vy꞉o pini ngmê ngê dini ghi n꞉ii ngê a w꞉ee ngê, apê, Aténgê dî pyiyé, mêdê diyé wo, Chóó Lémi dpodombiy꞉e tââ doo chaa kîgha. ");
INSERT INTO yle_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesu yu km꞉ee dyimê wo, doo kwunokwuno. Yi pini daa Nju pi, Samédiya pi. ");
INSERT INTO yle_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ngê pi knî ye yepê, Pi y꞉a kîdî pyi, angênê mê chu. ");
INSERT INTO yle_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yepê, Lukwe dîy꞉o Chóó Lémi u yoo vy꞉o pini chu knî y꞉oo, Chóó Lémi doon꞉aa kwuno ngópu, kn꞉aa p꞉aani pi ngmê ngê u mo até d꞉uu kwuno. ");
INSERT INTO yle_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wod꞉oo Yesu ngê kwo, Gh꞉êêdé, kada a yéni, ṉgêlîmî u l꞉êê dîy꞉o chi pyiyé. ");
INSERT INTO yle_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pádisi knî ngmê Yesu ka póó dniye, kwo, Chóó Lémi ngê u yoo y꞉enê kn꞉ââ chóó anté dini wa chaa? Yesu ngê yepê, Chóó Lémi u yoo y꞉enê doo u ntââ ngwolo ngê daanmyi m꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yepê, Doo u ntââ pi ngê daawa vyi, Al꞉ii kn꞉ââ kêdê chaa, ó mwi kn꞉ââ kêda chaa, mu kópu u dîy꞉o wod꞉oo yi kópu nmyi vy꞉o ka tóó. ");
INSERT INTO yle_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wod꞉oo Yesu ngê p꞉uu ndiye pyu knî ye yepê, Dîyo Chóó Lémi u Pi Ndêndê wanmy꞉uu tpy꞉oo ngmê, anmyi t꞉âât꞉ââ, ngmênê lîmîlîmî ngê daawa t꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yepê, Dye ghi knî ngmê ngê pi knî y꞉oo ala kópu nmye wa vyi ngmê, nmyewo, Chóó Lémi u Pi Ndêndê al꞉ii ka tóó, ó mu p꞉aani kîyedê tóó. Yepê, Ye n꞉uungmê ng꞉aa mb꞉anê, y꞉i nangmê nî. ");
INSERT INTO yle_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yepê, Daa p꞉aa ngmidi tpémi y꞉oo Chóó Lémi u Pi Ndêndê wa m꞉uu ngmê, ngmênê pi yintómu knî y꞉oo wa m꞉uu ngmê. Yepê, Lîmî ntee dpî pywálî, pi yintómu knî y꞉oo ntee dpî m꞉uu ngmê, Chóó Lémi u Pi Ndêndê yinté amye m꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yepê, Ngmênê ala dini ghi u yoo knî y꞉oo mwiyé wa mb꞉ii ngmê, dono u ngwo wa d꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yepê, U kuwó dini ghi ngê Chóó Lémi u Pi Ndêndê amêdê diyé. Wéni n꞉ii ngê amêdê diyé, pi lama daadî ya. Yepê, Nówa u dye ghi ngê yoo ntee doo a kwo, wéni n꞉ii ngê Chóó Lémi u Pi Ndêndê amêdê diyé, yoo yinté amyaa kwo. ");
INSERT INTO yle_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yepê, Nówa u dye ghi ngê yoo dêdnyimo a nkîngê, dnya a kmaapî, dnya a mbwaa ndanî, dnyimo a yééyéé, u dî wéni n꞉ii ngê Nówa p꞉uu nkéli k꞉oo wo dniye, wo yéli vyi ngê vyâ. ");
INSERT INTO yle_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yepê, Nówa u dye ghi ngê yoo daa yi lama ntee a pw꞉oo dniye, Loté u dye ghi ngê mye yinté. Yepê, Yoo dnya a kmaapî, dnya a mbwaa ndanî, dnya a tpile pywupwi, dnya a nté woo kapî, dnya a ngomo wuwó. ");
INSERT INTO yle_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yepê, Wéni n꞉ii ngê Loté ngê Sodom a kuwo ngê, ndê mbóó p꞉uu ngma a ndê wo, yi p꞉aani d꞉ud꞉umbiy꞉e a vyuwó ngê, pi yintómu ma too. ");
INSERT INTO yle_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yepê, Wéni n꞉ii ngê Chóó Lémi u Pi Ndêndê amêdê diyé, mye yinté, yoo dono daa yi lama yi kpadakpada têdê wa lee dmi. ");
INSERT INTO yle_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Yepê, Yi wéni ngê n꞉ii u ngomo maknopwo adî ya, lîmîlîmî ngê dpî mbêpê we, u ngomo k꞉oo mêkîngê kee, u tpile kîdangmên꞉aa ngî. Yepê, Myenté pini n꞉ii u yâpwo têdê adîn꞉aa dpodo, u p꞉o mêkîngê diyé, u tpile kîngmê nya, lîmîlîmî ngê dpî mbêpê we. ");
INSERT INTO yle_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yepê, Loté u kpâm p꞉uu nuw꞉o ngî kalê yó, pyópuni mêdê diyé wo, apê, A p꞉aa ndê ngê modo pîpî, u ngwo pwene. ");
INSERT INTO yle_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yepê, N꞉ii chóó u ghê p꞉uu adî nuw꞉o, u ghê l꞉âmo wa a ngee, n꞉ii u ghê p꞉uu daadî nuw꞉o, ghê ndêndê wa a pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yepê, Yi mgîdî ngê pi miyó ngmîtédmino adpî dpî, enjel knî y꞉oo woni wa ngî ngmê, woni wa a kuwo ngmê. ");
INSERT INTO yle_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yepê, Pyââ miyó adpî ghee, enjel knî y꞉oo woni wa ngî ngmê, woni wa a kuwo ngmê. ");
INSERT INTO yle_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yepê, Pi miyó yâpwo têdê adpî dpodo, enjel knî y꞉oo woni wa ngî ngmê, woni wa a kuwo ngmê. ");
INSERT INTO yle_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesu ka p꞉uu ndiye pyu yoo u kwo póó dniye, kwo, Nmî Lémi, yi kópu ló y꞉i wa pyódu? Yesu ngê yi póó ye daa vyâ, ngmênê ala mgongo ye yi kwólu, yepê, Chaapyu w꞉uu nt꞉ee ngmanmyi m꞉uu ngmê, anmyinê w꞉ee ngmê, anye, mgomo k꞉ii a kwo. Yepê, Doo u ntââ yi kópu daanmyi kn꞉aadi ngmê. ");
INSERT INTO yle_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","U kuwó dini ghi ngê Yesu ngê p꞉uu ndiye pyu knî ye mgongo ngmê kwólu, u nt꞉u kópu, dye ghi yintómu Chóó Lémi ka dny꞉oo ngêpê, kîngî yé ngmê. ");
INSERT INTO yle_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yepê, P꞉aa ngmê, kóté y꞉enê pyu ngmêdoo ya, Chóó Lémi dêdpîmo chââchââ, yoo myedêdpîmo chââchââ. ");
INSERT INTO yle_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Yepê, Yi p꞉aani kuknwe ngmêdoo ya, pi ngmê ngê u tpile knî mwiyé ngma a t꞉âmo ngê. Yi kuknwe kóté y꞉enê pyu ka dpîmo lêpî, kópu, Ngee nédi, pini n꞉ii ngê a tpile t꞉âmo too, u kwo vyi ngi, a ka mêdê kê téne. ");
INSERT INTO yle_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yepê, Dye ghi daadîî kóté y꞉enê pyu ngê yi kuknwe dêdpîmo ngêêpî, u kuwó dini ghi ngê apê, K꞉omo tpile Chóó Lémi dînî chââchââ, yoo myedînî chââchââ, ");
INSERT INTO yle_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ngmênê kî kuknwe ngê dyaa yono a ka dê chedê, a ngîma dê kaalî, ala ngwo n꞉aa ngêêpî, yi kpáápi n꞉aa kóté kîgha, kuknwe ka u tpile yintómu u kwo mêwunê diyédiyé kîgha. ");
INSERT INTO yle_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nmî Lémi ngê yepê, Kópuni yi kóté y꞉enê pyu dono ngê vyu, yi kópu p꞉uu dmyinê nuw꞉o. ");
INSERT INTO yle_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ye póó wo, yepê, W꞉êênî mgîdî vy꞉o Chóó Lémi ka chóó u yoo adnyi ngêpê knomomê, lukwe, u kwo wa ch꞉anê dmi, ó daawa ch꞉anê dmi, lîmîlîmî ngê wa ngee té, ó daawa ngee té? ");
INSERT INTO yle_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yepê, Mgî daawa puwâ, lîmîlîmî ngê wa ngee té. Yepê, Ngmênê dini ghi n꞉ii ngê amênê diyé, a yoo vy꞉o pi yémi adî kwo. Yepê, Kuwa yéli y꞉oo kîngî chedê nmyo. Yepê, Yi kuknwe dmyina a nj꞉ii, ngêpê têdê chaa dmyinê chedêchedê, Chóó Lémi ngê u ngwo wa a ngee nmyo, wo yéli wa dêê dmi, daawa chedê nmyo. ");
INSERT INTO yle_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yélini y꞉oo apu, Nmo mb꞉aamb꞉aa dé, wo yéli dono dé, yi yéli yi p꞉uu Yesu ngê mgongo ngmê kwólu, ");
INSERT INTO yle_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","yepê, Pi miyó, Chóó Lémi u ngomo k꞉oo ngêpê têdê lee knopwo, woni Pádisi, woni tákisi ngêêpî pyu. ");
INSERT INTO yle_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yepê, Pádisi ghêêdî wo, yoo yi ngîma u mo mînê ghê wo, alanté doo ngêpê, Chóó Lémi ka kwo, Mw꞉ââkó a Lémi, dye ghi yintómu nyinê ngêêpî noo, u l꞉êê dîy꞉o a l꞉êê ghi mb꞉aamb꞉aa dé, pi yilî ntee, d꞉aa yinté, d꞉aa kmungo pyu, d꞉aa kêêmî kapî pyu, d꞉aa pyââ ti pyu, d꞉aa kî tákisi ngêêpî pyu ntee pini. ");
INSERT INTO yle_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kwo, Wiki yintómu knî yi k꞉oo wo miyó dê yi k꞉oo nté dînî pîpî ngê, ṉga u ngwo nînê ngêpê yédi. Kwo, Ntini n꞉ii dpo pyw꞉oo, dînî mgîpa kîgha ngê, dyuu y꞉a dp꞉o pyidu, yononi mbwó ṉmodo pyu knî ye dpî y꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yesu ngê yepê, Pádisi yinté doo ngêpê, ngmênê tákisi ngêêpî pyu mwada y꞉i u mo a ghê wo, u dono knî yi l꞉êê dîy꞉o k꞉ame doo kwo, tpéé kópu yilî doo tpapê, mbodo a ny꞉ii ngê, Chóó Lémi ka kwo, A Lémi, ṉga d꞉oo ch꞉anê wo, a dono yilî ṉguwó wanyi kéé té? ");
INSERT INTO yle_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu ngê yepê, Ala kópu ny꞉ee yó. Yepê, Tákisi ngêêpî pyu u dono yilî p꞉ee chedê ngê pyodo, ngmênê daa Pádisi, mu kópu u dîy꞉o n꞉ii ngê chóó u pi a kmîmî ngê, Chóó Lémi ngê yi pini u pi têdê ngê wa a pyódu, n꞉ii ngê chóó u pi wunê ghîpîghîpî ngê, Chóó Lémi ngê yini u pi ndîî ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pi ngmê knî y꞉oo yi tp꞉ee mbópó Yesu ka a ńuw꞉o tumo, apê, Kóó yi mbêmê nyi yé ngê, ngmênê Yesu p꞉uu ndiye pyu knî y꞉oo yi m꞉uu tumo, ye kwódu ngópu. ");
INSERT INTO yle_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ngmênê Yesu ngê yepê, A ka a ńuw꞉o teńe, ye namê kwódu yé, mu kópu u dîy꞉o tp꞉ee dmââdîma ntee yéli Chóó Lémi ngê chóó adî y꞉enê dé. ");
INSERT INTO yle_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yepê, Ndê kópu nmye ngmên꞉aa tpapê, yepê, Tp꞉ee ngê u mî u dnye ntee a nyêmî ngê, n꞉ii ngê Chóó Lémi u dnye yinté daadî nyêmî, Chóó Lémi ngê yi pini wa mb꞉ii, kóó k꞉oo daawa kââ. ");
INSERT INTO yle_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kada pini ngmê Yesu ka póó wo, kwo, Nmî ndiye kîgha pyu mb꞉aa. Kwo, Ló kópu ngmanî d꞉uu, ghê kamî u ngwo anê pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu? ");
INSERT INTO yle_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu ngê kwo, Lukwe dîy꞉o mb꞉aamb꞉aa u pi a pyimo chi t꞉oo? Kwo, Pi mb꞉aamb꞉aa daangma a tóó, Chóó Lémi mu ngmidi yi mb꞉aamb꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kwo, Dêêpî kópu dyuu ḻama a kwo, kwo, Pi u kuwó nangmê pwiyé, pi nangmê vy꞉a, pi u tpile nangmê t꞉âmo, pi nangmê yipe, m̱ye m̱î chi chââchââ dê. ");
INSERT INTO yle_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yi pini ngê kwo, Tp꞉ee têdê noo a ya, yi kópu dyuu noo a chââchââ, ala ngwo myenî chââchââ té. ");
INSERT INTO yle_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu ngê yi kópu yi nyongo, kwo, Kópu mu ngmidi chuungê d꞉uu ngê, tpile yilîni ṉgópu a tóó, ngópuch꞉anê knî ye nyi yéépi, yed꞉oo dpo ngm꞉êê nédi, cha a yâmuyâmu nê, kwo, ya mb꞉aa mbóó p꞉uu u ngwo anyimo pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dini ghi n꞉ii ngê yi pini ngê yi kópu nyongo, u gha dono ngê pyodo, mu kópu u dîy꞉o ndáápi ndîî, u tpile yilî. ");
INSERT INTO yle_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu ngê a w꞉ee ngê, apê, Wu pini u tpile yilî yi p꞉uu a nuw꞉o, wod꞉oo pi knî ye yepê, N꞉ii ndáápi ndîî, a maa p꞉uu paa dpodo ndîî ngê u kwo wa pyódu, Chóó Lémi kóó k꞉oo angênté amî ghê. ");
INSERT INTO yle_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yepê, Mbwêmê ndîî, tee kn꞉ââ puu u mênê daawa kee, yepê, myenté Chóó Lémi kóó k꞉oo ndáápi d꞉uudpî ghê. ");
INSERT INTO yle_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","N꞉ii knî y꞉oo yi kópu ny꞉ee ngópu, noko yepê, Wu lónté kópu? Noko yepê, Ndáápi yoo Chóó Lémi kóó k꞉oo daangmêwa ghê knomomê, ye n꞉uu ngmê u ntââ y꞉i amî ghê? ");
INSERT INTO yle_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu ngê yepê, Doo u ntââ Chóó Lémi kóó k꞉oo pi chóó daangmêmî ghê, ngmênê Chóó Lémi chóó u ntââ, pi chóó kóó k꞉oo wa kââ. Yepê, Kópu yilî yintómu Chóó Lémi u ntââ. ");
INSERT INTO yle_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita ngê Yesu ka kwo, Mââwe. Kwo, Nmî p꞉aa dmi nmo kuwo too, anmînê yâmuyâmu ngi. ");
INSERT INTO yle_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê, pini n꞉ii ngê a l꞉êê dîy꞉o u p꞉aa dpo kuwo, u kpâm ghee knî dpo kuwo té, u tîdê mbwó yoo dpo kuwo té, u pye mî dpo kuwo dê, ");
INSERT INTO yle_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yepê, yi pini ngê yinté tpile mê yilî ala dini ghi ngê amêdê pyw꞉oo, mu dini ghi ngê ghê kamî amyemînê pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ngê u dyépi y꞉a mê miyó kn꞉aa ńuw꞉o too, yi mo yepê, Ala kópu ny꞉ee yó. Yepê, Ala ngwo Njedusalem nmo lêpî té, Chóó Lémi u komo kapî pyu knî y꞉oo Chóó Lémi u Pi Ndêndê p꞉uu kópuni a d꞉êê tumo, yi kópu yilî y꞉i wumê ntiyentiye té. ");
INSERT INTO yle_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yepê, Lóma tpémi yi kêê k꞉oo wa kaa nê, wadnyi nkwitinkwiti nê, a p꞉uu wadnyi peede tpapê, a p꞉uu wadnyi tpyîpwi. ");
INSERT INTO yle_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yepê, Wadnyi kpakakpaka nê, wa vya nê, ngmênê wo pyoloni ngê wamênî pyidu. ");
INSERT INTO yle_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","P꞉uu ndiye pyu knî y꞉oo yi kópu dyuu d꞉ud꞉umbiy꞉e dêpê w꞉ee tumo, apê, Lukwe dîy꞉o kînté nmo a mbumu. Apê, Chóó Lémi u Pi Ndêndê u pi ndîî ngê wa pyódu, dono daawa a pyw꞉oo. Yinê ye ngmee u kópu ye yi vyu, dêpê w꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Daa kêmakêma Yesu p꞉uu Njédikó dnye taataa, maa nkîgh꞉ê pi ngmêdoo ya, ngwolo dê kopwe dê. Daa dpodo u ntââ, dye ghi yintómu maa nkîgh꞉ê dpîmo ya, pi knî ye ndapî dpîmo dmyinê. ");
INSERT INTO yle_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Dini ghi n꞉ii ngê yoo u nkîgh꞉ê doon꞉aa lêpî, yi dnye dmi yi ny꞉ee too, ye póó wo, yepê, Lukwe ngmêdê pyódu? ");
INSERT INTO yle_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kwo, Yesu Nasalet pi kîyedê pwiyé knî. ");
INSERT INTO yle_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wod꞉oo dpodombiy꞉e ka wo, kwo, Yesu. Kwo, N꞉ii Chóó Lémi ngê a ngmidi ngê, Dépidi ntee pini, u ntââ ṉga wanê ch꞉anê? ");
INSERT INTO yle_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","K꞉omo tpile yélini u kada dnye kwo, u kwo a tpêpwo dniye, kwo, Tumu chi ya, ngmênê yi dnye dmi daa nyongo, dpodombiy꞉e modoo kââ, kwo, Dépidi ntee pini. Kwo, U ntââ ṉga wanê ch꞉anê? ");
INSERT INTO yle_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Wod꞉oo Yesu ngê paa u dî puwâ, yepê, Kî pini a ka a ńuw꞉o yó. Dini ghi n꞉ii ngê u kwo a ńuw꞉o ngópu, Yesu u kwo póó wo, ");
INSERT INTO yle_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","kwo, Lukwe ṉga ngmanî mdo? Yi pini ngê kwo, A Lémi. Kwo, U ya a nga a kwo, Yélî m꞉aa m꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu ngê kwo, Yélî mê mwini. Kwo, Ṉgêlîmî mbêmê chi pyiyé. ");
INSERT INTO yle_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wod꞉oo yi ngwo yélî mê módu, Yesu u kuwó mye ghê wo, Chóó Lémi doo chaa kîgha. N꞉ii knî y꞉oo m꞉uu ngópu, Chóó Lémi myednye chaa kîgha. ");
INSERT INTO yle_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Dini ghi n꞉ii ngê Yesu p꞉uu Njédikó taa dniye, tákisi ngêêpî pyu yoo yi kada pini ngê yi nyongo, apê, Yesu Nasalet pi kêdê t꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yi pini u pi Sîkiyîs, ndáápi pââ ndîî. ");
INSERT INTO yle_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","U yi u ngwo doo kwo, Yesu nî m꞉uu, ngmênê u kwo, angênté pini, ngmênê pi ghi dêêkwédi, pi knî yi vy꞉o a dêê wo, ");
INSERT INTO yle_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","wod꞉oo mbêpê a puwâ, Yesu u kada maa nkîgh꞉ê yi ngmêmî vy꞉ungo. ");
INSERT INTO yle_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Dini ghi n꞉ii ngê Yesu p꞉uu yi yini km꞉ee lee dniye, yi vyu dniye, apê, Sîkiyîs yi nkwodo mu kwo. Yesu ngê kwo, Sîkiyîs, lîmî k꞉ii a ghidi, awêde nmyi ngomo k꞉oo nîmo dpî. ");
INSERT INTO yle_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wod꞉oo Sîkiyîs u gha mb꞉aamb꞉aa ngê pyodo, lîmîlîmî ngê a ghêpê wo, Yesu kóó mgîmî ngê, kwo, A p꞉aa pee lee kmêle. ");
INSERT INTO yle_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Njédikó tpémi yélini y꞉i doo kwo, dnye nuu mbumu, noko yepê, Lukwe dîy꞉o kî pini pi dono u p꞉aa pee a lêpî. ");
INSERT INTO yle_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wod꞉oo Sîkiyîs mî ghê wo, nmî Lémi ka kwo, Nmî Lémi. Kwo, Tpileni yilî a ngópu a tóó, dyuu miyó ngê wanî pyódu, woni dyuu ngópuch꞉anê knî ye wanî y꞉oo, woni dyuu a ka wa a mbêpê. Kwo, N꞉ii dé wunê nî dóó too, yi ndapî nê t꞉âmo too, ntémwi nê t꞉âmo ngê, yi ntémwi ye mêdaanî y꞉oo, ngmênê páádi páádi ye am꞉aa y꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu ngê kwo, Chóó Lémi ngê awêde da ngee ngi, ṉono yilî dî chedê té. Pi knî ye yepê, Nmyi mo dp꞉ee Epîlaham u yoo vy꞉o yéli, ala pini mye Epîlaham u tii ńedê pini ngmê. ");
INSERT INTO yle_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yepê, Yélini y꞉oo maa kn꞉aadi ngópu, vyîlo yi yéli yi l꞉êê dîy꞉o Chóó Lémi ngê u Pi Ndêndê nmyi vy꞉o u ngwo a dy꞉ââ ngê, kwo, Chin꞉aa nmy꞉uu dé, a kêê k꞉oo myechin꞉aa kapî dé. ");
INSERT INTO yle_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","N꞉ii knî y꞉oo yi kópu dyuu ny꞉ee tumo, yi nuw꞉o dmi alanté doo ya, apê, Daa kêmakêma Njedusalem nmo taataa té, Chóó Lémi ngê Yesu nmî king ngê u ngwo wunê pyépi. Yesu u lama doo ya, daa yi ngwo king ngê anî pyódu, wod꞉oo yi kópu p꞉uu mgongo ye ngmê kwólu, ");
INSERT INTO yle_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","yepê, Lémi ngmê, king ndîî ngê a ngmidi ngê, pi knî ngmê u kwo dy꞉ââ too, yepê, Yi lémi dpo pwiyé we, chóó u yoo yi king ngê wanî pyódu, u kuwó dini ghi ngê amê diyé, chóó u yoo adîn꞉aa y꞉enê dé. ");
INSERT INTO yle_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yepê, Kada ghêlî dêpê y꞉ângo, u dpodo pyu y꞉a knî a danê too, nkól pee ngmêngmênté ye y꞉ângo, yi nkól pee yi pywuu ndîî dé, d꞉ââ pyile yi dpodo u pywuu ntoo, nkól pee ngmê u pywuu mye yintoo. Yepê, Yi lémi ngê u dpodo pyu knî ye yepê, Ndapîni nmye d꞉a kê té, dpî dpodo kalê tóó, a l꞉êê dîy꞉o knî mu u ngwo dpî kmênê yó, u dî dini ghi n꞉ii ngê amênê diyé. ");
INSERT INTO yle_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yesu ngê yepê, Wod꞉oo kada a y꞉ângo, kn꞉aa dyámê pee p꞉uu king ndîî ka loo. Yepê, Chóó u dyámê tpémi ye diya wo, wod꞉oo kópu u kuwó dy꞉ââ ngópu, king ndîî ka kwo, U yi nmo daa kwo, Yi pini nmî king ngê pyaa we. ");
INSERT INTO yle_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yepê, Ngmênê king ndîî ngê yi kópu daa nyongo, yi pini yi king ngê pyódu ngê. Yepê, U kuwó dini ghi ngê u dyámê pee p꞉uu mêdê diyé wo, u dpodo pyu y꞉a knî até yedê danê too, ye póó wo, yepê, Ndapîni nmye nê kê too, nmyi dpodo kalê tumo, ndapî yémi u ngwo m꞉ii kmênê ngópu? ");
INSERT INTO yle_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yesu ngê yepê, Mwiyémwiyéni u kwo loo, kwo, A lémi, nkól peeni a ka nyinê kpo, mê y꞉a u ngwo nê kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yi lémi ngê kwo, Y꞉ay꞉a chi pwiyé, nyi dpodo pyu mb꞉aa. Kwo, Daa ndîî dpodo ṉga yinî kpo, yi dpodo mb꞉aamb꞉aa ngê nyi dóó, p꞉aa y꞉a knî yi kada pini ngê n꞉aa pyépi ngi. ");
INSERT INTO yle_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yesu ngê yepê, Myomoni u nkwo u kwo até yedê loo, kwo, A lémi, nkól peeni a ka nyinê kpo, mê limi u ngwo nê kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yi lémi ngê kwo, P꞉aa limi knî yi kada pini ngê n꞉aa pyépi ngi. ");
INSERT INTO yle_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Yepê, U kwo m꞉uu até yedê loo, kwo, A lémi, nkól peeni a ka nyinê kpo, mê ala, kînoo ṉg꞉uu ńeńe. ");
INSERT INTO yle_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kwo, Ṉga nî nkîngê mbê wo, mu kópu u dîy꞉o a lama ka tóó, d꞉ii dódó u pi, nê, Ndapî l꞉âmo wanê ngee, nê, angênté a ka wa t꞉aa. Kwo, Pi knî ye ntooni nye yémî ngê, daa yintoo mêyinyinê pwapî ngê, pââ ndîî yinyinê pwapî ngê, ntini woo n꞉ii d꞉ii kapî ngê, vyîlo y꞉ee pîpî ngê. ");
INSERT INTO yle_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yepê, Yi lémi ngê kwo, Nyi dnyinté dpodo pyu. Kwo, Ṉ́yóó ṉgópu knî yi l꞉êê dîy꞉o n꞉aa kpadakpada ngi. Kwo, Ḻama ngee tóó, d꞉aa dódó u pi, pi knî ye ntooni n꞉aa yémî ngê, daa yintoo mêyinînê pwapî ngê, ntini woo n꞉ii dînî kapî ngê, vyîlo yinî pîpî ngê. ");
INSERT INTO yle_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kwo, Lukwe dîy꞉o a ndapî, ndapî u ngomo k꞉oo dipi yó, ndapî knî m꞉uu pînî puwâ. ");
INSERT INTO yle_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yesu ngê yepê, Yélini yoo y꞉i dnye kwo, yi lémi ngê yepê, Nkól pee kwulo a ngee yó, pini n꞉ii u ngópu y꞉a a tóó, u kwo y꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yesu ngê yepê, Yi yéli y꞉oo yi lémi ka kwo, Nmî lémi lukwe dîy꞉o? Kwo, U ngópu y꞉a ka tóó. ");
INSERT INTO yle_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yepê, Ndê kópu nmye ngmên꞉aa tpapê, N꞉ii u ngópu tpile yilî a tóó, mu dini ghi ngê knî m꞉uu wa a pyw꞉oo, n꞉ii u ngópu tpile pyile njini a tóó, yi tpile knî yi l꞉âmo wa a ngee té. ");
INSERT INTO yle_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yepê, N꞉ii knî y꞉oo a wépi pwaa ngópu, apê, Nê nmî king ngê kîngî pyódu, yepê, a ńuw꞉o tóó, a ngópu anyi vya tóó. ");
INSERT INTO yle_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Dini ghi n꞉ii ngê Yesu ngê danêmbum ye a kêlî ngê, kada a y꞉ee ngópu, Njedusalem dnye lêpî, p꞉uu ndiye pyu yoo yi kada doo kwo. ");
INSERT INTO yle_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesu, p꞉uu ndiye pyu knî yi k꞉ii Njedusalem ghêlî daa nî dniye, yi kada p꞉aa miyó doo ya, Petani p꞉aani dê Petepake, mbu y꞉i ngma a kwo, u pi Olipi, mu kópu u dîy꞉o nté kn꞉ââ kpê yi mbwini mbêmê ngmêdoo ya, yi yini yi pi dmi mye olipi. Dini ghi n꞉ii ngê yi mbwini mbêmê kee dniye, Yesu ngê p꞉uu ndiye pyu kada miyó kââ, ");
INSERT INTO yle_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yepê, Mu p꞉aani nmî kada choo kwo. Yepê, Dini ghi n꞉ii ngê y꞉i dpo taataa mo, ndonki tp꞉oo dpo mumu ngmê, yedê ńedê a t꞉a. Yepê, Yi ndonki tp꞉oo pyipwo pi doongmê yaa wo. Yepê, Dpo pywálî nyoo, a ka dpo ńuw꞉o nyoo. ");
INSERT INTO yle_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yepê, Pini n꞉ii ngê dpo dê vyi knomomê, Ndonki tp꞉oo lukwe dîy꞉o dpo ńeńe ngmê, yepê, ala kópu u kwo dpî vyi nyoo, kwipi, Nmî lémi ngê u yi u ngwo wunê kwo. ");
INSERT INTO yle_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pini n꞉ii dê Yesu ngê dy꞉ââ doo, yi p꞉aani lee knopwo, ndonki p꞉uu kópuni ye vyu, yinté a pyw꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yedêni ndonki nódo doo ya, dini ghi n꞉ii ngê k꞉ââ ghi p꞉uu dpîmo a pywálîpywálî, yi ndonki chóó knî y꞉oo yepê, Lukwe dîy꞉o dpo pywálîpywálî ngmê. ");
INSERT INTO yle_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yi tpódu y꞉oo yepê, Nmî lémi ngê u yi u ngwo wunê kwo. ");
INSERT INTO yle_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wod꞉oo Yesu ka ńuw꞉o ngópu, yi nkuwo kpîdî dê yi mbwo a ngee dumo, ndonki pyipwo talê dumo, Yesu pyipwo u nkwo yaa wo. Kada a y꞉ee ngópu, Njedusalem dnye lêpî, maa p꞉uu ndonki ngê Yesu doo dnyinêdnyinê. ");
INSERT INTO yle_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","King ntee dnyimo chââchââ, Yesu yinté mye châpu ngópu, woni knî y꞉oo yi nkuwo kpîdî a ngee tumo, Yesu u kada maa p꞉uu talê tumo. ");
INSERT INTO yle_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dini ghi n꞉ii ngê mbu vyuwo a ghêpê dniye, Njedusalem u nkîgh꞉ê, yélini yilî u kwo dnye kêlîmî, yi yéli y꞉oo Chóó Lémi dpodombiy꞉e dnye kwunokwuno, myednye chaa kîgha, mu kópu u dîy꞉o Yesu ngê kópu ndîî yilî yi ngópu mwiyé a d꞉uu too. ");
INSERT INTO yle_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kópu, Munmîkó Nmî king. Kópu, Chóó Lémi ngê a ngee nyine. Kópu, U pi ngê nyinê loo. Kópu, Chóó Lémi ngê nmî Mbwámê ngê a pyódu nyoo, chaa kîgha koo. ");
INSERT INTO yle_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wod꞉oo Pádisi knî ngmê, yélini yoo vy꞉o dnya a kwo, Yesu ka kwo, Kî pini, m̱꞉uu ndiye pyu knî y꞉oo lukwe dîy꞉o a chaa kîgha ngi. Kwo, Ye kwódu ngi. ");
INSERT INTO yle_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu ngê yepê, Doo u ntââ ala p꞉aani módó daanî vy꞉u. Yepê, Tumu wo pyede, ye chêêpî knî y꞉oo y꞉oopê chaa kîgha nê. ");
INSERT INTO yle_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu p꞉uu Njedusalem modnyen꞉aa lêpî, Yesu ngê Njedusalem doo y꞉enê, u nuw꞉o p꞉uu doo kwo, u yoo u kwo ch꞉anê wo, wod꞉oo yi l꞉êê dîy꞉o doo mbê, myedoo tpyóókaa yiiyaa, ");
INSERT INTO yle_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","apê, Ayii! Njedusalem tpémi ee! Apê, Lukwe dîy꞉o my꞉oo nmye pyede, daanmyi mya nê. Apê, Kópuni a nga wanmyi d꞉uu ngmê, M꞉aa ngê ntââ nmye wa a vy꞉u. Apê, Awêde wodmyi mya nê, ye pîdmyi châpu nê, M꞉aa ngê a ntââ nmye daapêdê vy꞉u. ");
INSERT INTO yle_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Apê, Mu dini ghi ngê Lóma lede knî y꞉oo nmyi p꞉aa téli k꞉oo wa kaa ngmê, mbwa pw꞉ono maa ngmê wa a yé ngmê, mbêmê u ngwo wa lóó dmi, ");
INSERT INTO yle_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","d꞉ud꞉umbiy꞉e wa vya nmyo, nmyi ngomo dé, nmyi p꞉aa u mbwa dé d꞉ud꞉umbiy꞉e wa dyênê t꞉oo, wa pwaa t꞉oo, chêêpîni knî y꞉oo nmyi wó tumo, yi p꞉uu ngmidi myedaadî ya. Apê, Yi kópu nmye wa pyódu, mu kópu u dîy꞉o nmyi Mbwámê dpîp꞉e mya ngópu. ");
INSERT INTO yle_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu p꞉uu Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo yimî kee dniye, apê, Pi knî y꞉oo tpile tp꞉oo mu pywupwi t꞉oo, kpêê yiyé u l꞉êê dîy꞉o. Apê, Yélini al꞉ii a dpodo nyédi, yoo mu dódó t꞉oo, yi ndapî mu chedêchedê t꞉oo. Yi kópu u l꞉êê dîy꞉o Yesu ngê a pw꞉oo too, ");
INSERT INTO yle_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Chóó Lémi u kópu Yisaya ngê n꞉ii a d꞉êê ngê, yi kópu ye vyu, yepê, Puku yedê ala kópu mu tóó, A ngomo kwéli a kwo, ngêpê têdê ngê choo ya, yepê, ngmênê kpaa têdê ngê dmye pyódu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","U kuwó wéni knî yi k꞉oo Yesu ngê Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo yoo doo ndiye kîgha dé. Kpêê yiyé pyu yoo yi kada pini yoo, dêêpî pyu yoo, yoo yi kada pini yoo mye yi k꞉ii, u yi y꞉e doo kwo Yesu nmî vy꞉a, ");
INSERT INTO yle_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ngmênê doo u ntââ ngê ye pyodo, mu kópu u dîy꞉o pi yintómu u kwo dnye ng꞉aa, kada pini knî y꞉oo u mo dêpê pyw꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wo ngmê ngê Yesu Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo doo kwo, yoo doo ndiye kîgha dé, u yi u ngwo doo kwo, Yoo yi nuw꞉o dmi nî ngmêê, Chóó Lémi kóó k꞉oo nî kaa té. Yi ngwo kpêê yiyé pyu yoo yi kada pini yoo, dêêpî pyu yoo, yoo yi kada pini yoo mye yi k꞉ii kwodonkwodo u kwo lee dniye, ");
INSERT INTO yle_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kwo, Chóó Lémi u ngomo nmî chóó nmo y꞉enê. Kwo, Kópuni nye d꞉uud꞉uu too, n꞉uu ngê ṉga vyu, u ngwo nye d꞉uud꞉uu too? Kwo, N꞉uu u pi mbêmê ye kópu yilî nye d꞉uud꞉uu ngê? ");
INSERT INTO yle_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu ngê yepê, Kópu nmye mwiyé ngmên꞉aa poopoo, yepê, a ka vyi yó, ");
INSERT INTO yle_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","n꞉uu u pi mbêmê Njon ngê pi mbwaa lêê u mênê dpîmo kmênêkmênê dé? Yepê, Chóó Lémi u pi mbêmê ó chóó u pi mbêmê? ");
INSERT INTO yle_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Noko yepê, Ló kópu u kwo ngmanmî vyi? Noko yepê, Ala kópu u kwo nmo tpapê, Chóó Lémi u pi mbêmê, noko yepê, ala kópu nmo a tpapê, Lukwe dîy꞉o Njon ka dpîp꞉e kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Noko yepê, Ala kópu u kwo nmo tpapê, Chóó u pi mbêmê, noko yepê, pi knî y꞉oo chêêpî ngê wa vya nmo, mu kópu u dîy꞉o yinê ye Njon Chóó Lémi u komo kapî pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yi kópu u l꞉êê dîy꞉o kede dniye, Yesu ka kwo, Pini n꞉ii u pi ngê a loo, nmî lama daa tóó. ");
INSERT INTO yle_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Myenté, Yesu ngê yepê, Pini n꞉ii u pi mbêmê kópu yilî n꞉aa d꞉uud꞉uu ngê, nmye myedaanî vyi. ");
INSERT INTO yle_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","U kuwó dini ghi ngê Yesu ngê pi knî ye mgongo ngmê kwólu, yepê, Pi ngmê ngê wain kpê ngmê yó, pi ngmê knî ye yepê, A wain kpê ka dmyinê vyuwo, dini ghi n꞉ii ngê nt꞉u dê kaa knomomê, kîgha dmyina a ngêêpî dé, dmyinê vyilêvyilê dé, wain u ngwo dmyinê l꞉âmol꞉âmo, knî a ka ngmêdmyina a dyede, woni nmyi nêni. Yepê, U kuwó dini ghi ngê yi pini ngê wain kpê a kuwo ngê, kn꞉aa p꞉aani loo, dye ghi daadîî y꞉i doon꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yepê, Wain kpê dini ghi n꞉ii ngê kyopwo wo, wain kpê chóó ngê u dpodo pyu ngmê dy꞉ââ ngê, kwo, A wain kpê mênê chi lêpî, u y꞉enê pyu knî y꞉oo a wain knî ṉga ngmêdo kê y꞉e, a ka dpo ńuw꞉o ngi. Yepê, Ngmênê yi pini dini ghi n꞉ii ngê wain kpê mênê mî ta, u y꞉enê pyu knî y꞉oo wain knî u kwo daa y꞉ee ngópu, yi pini mgîmî ngópu, kpaka ngópu, wain kpê chóó ka módó mê dy꞉ââ ngópu. ");
INSERT INTO yle_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yepê, U kuwó dini ghi ngê wain kpê chóó ngê u dpodo pyu myomoni dy꞉ââ ngê, yinté kópu mu ngmidi u ngwo myedê d꞉uu ngópu, dpodombiy꞉e kpaka ngópu, wain kpê chóó ka módó mye dy꞉ââ ngópu. ");
INSERT INTO yle_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yepê, U kuwó dini ghi ngê pyoloni ye mye dy꞉ââ ngê, wain kpê y꞉enê pyu knî y꞉oo myemînê kpaka ngópu, ngm꞉ii kalê ngópu. ");
INSERT INTO yle_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yepê, U kuwó dini ghi ngê wain kpê chóó até yedoo nuw꞉o, apê, Ló kópu ngmanî d꞉uu? Apê, A tp꞉ee njini ye n꞉aa dyede. Apê, U nuu ghi a nódo ka tóó, doo u ntââ, daamînê mb꞉ii ngmê. ");
INSERT INTO yle_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Yepê, Ngmênê dini ghi n꞉ii ngê wain kpê y꞉enê pyu knî y꞉oo m꞉uu ngópu, noko yepê, Kî wain kpê chóó tp꞉oo. Noko yepê, Vya koo, yed꞉oo wain kpê nmo wa ghay. ");
INSERT INTO yle_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yepê, Wod꞉oo vya ngópu, ntóó chii mênê mî kéé ngópu. Yesu ye póó wo, yepê, Yi wain kpê chóó ngê ló kópu y꞉e angmê d꞉uu? ");
INSERT INTO yle_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yepê, Wa a lê, yi tpóknî wa vya té, kn꞉aa yéli y꞉oo yi d꞉aa dmi u nkwo amênê kââdî ngmê. Yi mgongo danêmbum yedê w꞉ee ngópu, Yesu ka kwo, Doo u ntââ, ye kópu nmo kîngê pyódu. ");
INSERT INTO yle_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wod꞉oo Yesu ngê doo y꞉enê dé, ye póó wo, yepê, Yi kópu mumdoo nmye daawa pyódu? Yepê, Kópuni puku yedê a tóó, a w꞉ee yó. Yepê, Yi kópu ala, yepê, Yi pââni ngomo wuwó pyu knî y꞉oo kéé ngópu, yi yini pââ pw꞉eni ngê vyîlo mêyi pyodo. ");
INSERT INTO yle_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yepê, Nê chêêpî kpiyé ntee tpile. Yepê, N꞉ii yi chêêpî kpiyé p꞉uu wa a lvêêdî, mbodo wa pwââ. Yepê, N꞉ii mbêmê yi chêêpî kpiyé wa a ghay, koo dyuu ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yi ngwo dini ghi ngê dêêpî pyu yoo, kpêê yiyé pyu yoo yi kada pini yoo yi k꞉ii, u yi y꞉e doo kwo, Yesu nmî mgîmî, mu kópu u dîy꞉o a w꞉ee ngópu, apê, Kî nmî p꞉uu a mgongo, ngmênê kêê u ngwo dêpê t꞉ee ngópu, mu kópu u dîy꞉o pi knî ye nkîngê mbê dniye. ");
INSERT INTO yle_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Doo u ntââ kada pini knî y꞉oo Yesu yoo vy꞉o daapî mgîmî ngópu, wod꞉oo dpodombiy꞉e dnye y꞉enê, apê, Kn꞉aadi te kópu nmî ngópu ngma a tpapê knomomê, ye Lóma lede yoo yi kada pini ndîî ka yuu nmînê yémî, u ngwo wa kpada. Tumutumu pi knî u kwo ngmê dy꞉ââ ngópu, yepê, Dmyinên꞉aa dódó. ");
INSERT INTO yle_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wod꞉oo Yesu ka yi lee dniye, kwo, Mââwe. Kwo, Nmî lama ka tóó, Ndêndê ngê nye danêmbum. Kwo, Pi knî ye d꞉ee nkîngê yédi, ngmênê Chóó Lémi u kópu dyuu pi knî ye ndêndê ngê nye tpapê ngê. ");
INSERT INTO yle_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kwo, Nmo vyi ngi, kwo, nmî dêêpî kópu dyuu lónté a kwo, kwo, u ntââ Lóma tpémi yi king ndîî ka tákisi wanmî pywupwi, ó daanmî pywupwi? ");
INSERT INTO yle_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ngmênê Yesu ngê yi kópu a w꞉ee ngê, apê, Kînga a dódó nê. ");
INSERT INTO yle_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Yepê, Tákisi ndapî a ngópu ngmê tpyé yó, ngmênî m꞉uu. U ngópu yi tpyé ngópu, ye póó wo, yepê, Ala ndapî p꞉uu n꞉uu u kââ ye tóó, n꞉uu u pi myeye tóó? Kwo, Lóma tpémi yi king ndîî u kââ u pi ye tóó mo. ");
INSERT INTO yle_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Wod꞉oo Yesu ngê yepê, Tpileni Lóma tpémi yi king ndîî ngmênêni, u kwo mêdmyinê yémî. Yepê, Tpileni Chóó Lémi ngmênêni, Chóó Lémi ka mêdmyinê yémî. ");
INSERT INTO yle_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yoo yi ngîma u dódó ngê dêê dniye, kn꞉aadi te kópu daangmê vyu, wod꞉oo tumu yaa dniye, yi nyepênyepê u kópu ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yoo ngmê Yesu ka loo, yi yéli Sadyusi yoo. Yi nuw꞉o dmi alanté doo ya, apê, Pi dpî pw꞉onu, mêd꞉uuwodê pyidu. U yi y꞉e doo kwo, Yesu u pi nmî dyênê, u l꞉êê dîy꞉o Yesu alanté dnye dódó. ");
INSERT INTO yle_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yesu ka kwo, Mósisi ngê ala dêêpî kópu a d꞉êê ngê, apê, Pi angmê pw꞉onu, u kuknwe adî ya knomomê, yi tp꞉ee daadî ya knomomê, ye yi pini u mbwó ngê yi kuknwe moo ndê ngê, u mbwó u l꞉êê dîy꞉o tp꞉ee angmê tpyé ngmê. ");
INSERT INTO yle_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kwo, Pi mbwémi pyudu doo ya, kaani yéé wo, tp꞉ee daa tpyó, u ngwo pwene. ");
INSERT INTO yle_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kwo, Kaapeeni ngê yi kuknwe mê ndê ngê, yi pyópu ngê tp꞉ee myedêpê ngêêdî, kaapeeni yinté u nkwo mye pwene. ");
INSERT INTO yle_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kwo, Yi mbwémi knî yintómu yi pyópu mu ngmidi yinté dnye ny꞉ee, yintómu pw꞉oo dniye, tp꞉ee yi pyópu ngê dêpangmê ngî ngópu. ");
INSERT INTO yle_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kwo, U kuwó dini ghi ngê yi pyópu mye pwene. ");
INSERT INTO yle_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kwo, Lukwe dîy꞉o pyidepyide u pi nye tpapê. Kwo, Yoo wa a pii knomomê, ye yi pyópu ngê lukwe angmê pyódu, ló pini u kpâm ngê amê pyódu? Kwo, Doo u ntââ, mu kópu u dîy꞉o yi mbwémi pyudu knî yi pyópu mu ngmidi p꞉uu yéé dniye. ");
INSERT INTO yle_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu ngê yepê, Ala dini ghi ngê pyââ mââ numo p꞉uu a yééyéé nyédi, ");
INSERT INTO yle_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ngmênê Chóó Lémi ngê yélini yi p꞉uu wa a vyi, awo, Kî a yoo mb꞉aamb꞉aa, kpêênî u ngwo wa a pyidu té, kóó k꞉oo wa kaa té, yi yéli numo p꞉uu mêdaadnyi yééyéé. ");
INSERT INTO yle_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yepê, Mêdaawa pw꞉oo dmi, mu kópu u dîy꞉o enjel ntee pini ngê adnyi ya. Yepê, Chóó Lémi tp꞉oo módó tp꞉oo mââ ngê adnyi ya, mu kópu u dîy꞉o kpêênî chóó wa a pyidu té. ");
INSERT INTO yle_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yepê, W꞉êê mââwe n꞉ii ndêndê ngê nmye chââchââ ngópu, Mósisi, yi pini pyidepyide p꞉uu myedoo a d꞉êê. Yepê, U puku yedê, ndê ngê yi tp꞉oo kwéli doo pîpî, Chóó Lémi p꞉uu ala kópu a d꞉êê ngê, apê, Chóó Lémi, Epîlaham u yâpwo, myenté tp꞉oo Yisak u yâpwo, myenté Yisak tp꞉oo Njakóp u yâpwo. ");
INSERT INTO yle_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yepê, Chóó Lémi yi tpóknî yi yâpwo, yi kópu u l꞉êê dîy꞉o, k꞉omo tpile a pw꞉oo dniye, ngmênê u kwo yi ghê dmi a pyede. Yepê, Chóó Lémi daa ntóó knî yi yâpwo, ngmênê n꞉ii dé yi ghê a pyede, vyîlo yi yéli yi yâpwo. ");
INSERT INTO yle_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dêêpî pyu ngmê knî y꞉oo kwo, Mââwe, yi póó ye mb꞉aamb꞉aa ngê chi vy꞉a, doo dóó nyoo. ");
INSERT INTO yle_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yi ngwo póó u kwo daamu y꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu ngê dêêpî pyu knî ye yepê, Lukwe dîy꞉o ala kópu nmye tpapê ngmê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, King Dépidi u tii ńedê pini ngmê? ");
INSERT INTO yle_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yepê, Yi pini kada a tóó, Dépidi u kuwó a tóó, mu kópu u dîy꞉o wéti u puku yedê Dépidi ngê ala kópu chóó a d꞉êê ngê, apê, Chóó Lémi ngê a kada pini ka kwo, M̱i ndîî ngê n꞉aa pyépi, a wéni pee dpî yey, pi yintómu chi y꞉enê dé. ");
INSERT INTO yle_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Yélini m̱꞉uu a l꞉êê té, dîyo anî vya té, ṉyi yodo u maknopwo wanî yé té. ");
INSERT INTO yle_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yesu ngê yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, Dépidi ngê apê, Yi pini a kada pini. Yepê, Yi kópu u l꞉êê dîy꞉o, yi pini daa Dépidi ntee pini, ngmênê pi knî yi pwo pini ntee pini. ");
INSERT INTO yle_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pi yilî yi ngópu Yesu ngê p꞉uu ndiye pyu knî ye yepê, ");
INSERT INTO yle_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Dêêpî pyu yoo yi nj꞉ii ngê kêê nangê t꞉oo, n꞉ii knî y꞉oo u yi a kwo, Nmî pi dmi ndîî ngê pyaa we, nmî kpîdî dmi mb꞉aa kêlê nmî m꞉ii, pi knî y꞉oo mb꞉aamb꞉aa ngê pîdny꞉oo chââchââ nmo. Yepê, Yinté yéli ngêpê ngomo k꞉oo yi chóó kada dp꞉uu yaa dmi, naa têdê yi chóó kada myoon꞉aa yaa dmi. ");
INSERT INTO yle_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yepê, K꞉omo tpile kuknwe dpî dóó t꞉oo, yi tpile dpî t꞉âmo t꞉oo, ngmênê pi knî yi ngîma Chóó Lémi ka a ngêpê nyédi, ngêpê daadîî ngê dpî pyódu t꞉oo. Yepê, K꞉omodanê pyu yoo. Yepê, Chóó Lémi ngê yinté yéli dpodombiy꞉e wa kpada té. ");
INSERT INTO yle_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu p꞉uu Chóó Lémi u ngomo k꞉oo dnye ya, pi knî y꞉oo ndapî Chóó Lémi ka kwéli dnye yémî. Yesu ngê doo y꞉enê dé, apê, Ndáápi knî y꞉oo ndapî ndîî yilî mu kéké ngmê. ");
INSERT INTO yle_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kuknwe my꞉oo módó, apê, Ndapî kmono miyó njini adî kéé. ");
INSERT INTO yle_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pi knî ye yepê, Ndêndê ngê kî kuknwe ngê ndapî ndîî yi kéé, ndáápi knî y꞉oo têdê yi kéé ngmê, ");
INSERT INTO yle_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","mu kópu u dîy꞉o yi yéli yi ngópu ndapî ndîî ye tóó, têdê yi kéé ngmê, yepê, kî kuknwe u ngópu ndapî n꞉ii kmono dê tóó mo, vyîlo dê yi kéé dê, u ngópu mêdêdêmu tóó. ");
INSERT INTO yle_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu p꞉uu ndiye pyu knî ngmê Chóó Lémi u ngomo p꞉uu dnye danêmbum, apê, Kî lóntoo chêêpî ngomo, k꞉uuchêm u tpile p꞉uu myeka pyede, apê, tpileni pi knî y꞉oo y꞉ee tumo, k꞉ii kî t꞉ee tumo. ");
INSERT INTO yle_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yesu ngê yepê, Ngomoni p꞉uu nmye danêmbum té, mu dini ghi ngê chedê ngê wa pyódu. Yepê, Chêêpî pywápê ngmê n꞉ii ngê kî ngomo a wuwó ngópu, mu dini ghi ngê numo u pwo u pwo daangmadî ya. Yepê, Kn꞉aa lede knî y꞉oo kî ngomo d꞉ud꞉umbiy꞉e wa pwaa ngmê. ");
INSERT INTO yle_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesu p꞉uu ndiye pyu knî ngmê Yesu ka póó dniye, kwo, Mââwe. Kwo, Chóó Lémi u ngomo ló dini ghi ngê wa a pw꞉oo ngmê? Kwo, Ló kópu ngmanmî ny꞉oo, nmî lama u ngwo wa yââ, nê, Yi kópu daa kêmakêma a pyodopyodo? ");
INSERT INTO yle_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ngê yepê, Nmye mb꞉aamb꞉aa ngê dmyina a vyuwo, pi ngmê ngê kîngî dóó nmyo. Yepê, Pi yilî wa a lê, a pi adnyi tpapê, nmyewo, Ala nê vyîlo. Nmyewo, Dini ghi n꞉ii nmo t꞉âât꞉ââ, ala yi dini ghi. Yepê, Ye ng꞉aa ngê kêê nangê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yepê, Dini ghi n꞉ii ngê l꞉êê pââ ndîî u pi ngmanmyi ny꞉ee ngmê, ó yoo yi kada pini knî yi p꞉uu amyidnyi l꞉êê, ye nkîngê ngê kêê nangê t꞉oo, mu kópu u dîy꞉o yinté kópu knî mwiyé angmêdnyi pyodopyodo, daawa têda dmi, yepê, ngmênê nangê vyi, Ala d꞉o kuwókuwó dini ghi. ");
INSERT INTO yle_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yepê, Kn꞉aa dyámê tpémi kn꞉aa dyámê tpémi yi p꞉uu adnyi l꞉êê, yepê, ");
INSERT INTO yle_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","dyámê pee knî ngmê wadî ghêdê, pi yilî wa pw꞉oo dmi, daa ng꞉êêntómu m꞉uu wa ghîdî, yoo adnyi dómudómu, amyidnyi pwopwo, dye ghi knî ngmê ngê mbii ngmê ngê pi yilî adî ńeńe. Yepê, Nkîngê u kópu dé adnyi pyodopyodo, mbóó p꞉uu kópu ndîî amyidnyi pyodopyodo. ");
INSERT INTO yle_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yepê, Yi kópu yilî ghêlî daawa pyódu, pi dono knî y꞉oo u yi y꞉e adî kwo, Nê u yoo nmî chedê, yepê, u l꞉êê dîy꞉o nmyi p꞉uu adnyi d꞉uu. Yepê, Adnyin꞉aa mgîmîmgîmî nmyo, ngêpê ngomo knî yi y꞉enê pyu knî y꞉oo adnyin꞉aa kóté kîgha nmyo, mbwa k꞉oo u ngwo adnyi kmîmî nmyo. Yepê, A l꞉êê dîy꞉o king knî y꞉oo, kada pini knî y꞉oo amyidnyin꞉aa kóté kîgha nmyo. ");
INSERT INTO yle_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yepê, A p꞉uu ye anmyin꞉aa danê. ");
INSERT INTO yle_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yepê, Nmyi kóté kîgha u l꞉êê dîy꞉o, nmyi kópu dyuu u kadakada mwiyé kîdmyinêngê kapî, ");
INSERT INTO yle_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","mu kópu u dîy꞉o a chóó a komo nmyi kwo ayin꞉aa kwo. Yepê, Nmyi nuw꞉o dmi a chóó wana a ńepwińepwi, yélini nmyi p꞉uu adnyi d꞉uu, nmyi kóté kîgha ngê wa dêê dmi, yi pwo anmyin꞉aa a dimi. ");
INSERT INTO yle_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yepê, Nmyi pye mî knî y꞉oo, nmyi tîdê mbwó knî y꞉oo, nmyi nêni knî y꞉oo, nmyi pyipe knî y꞉oo, y꞉oo adnyi ndyîkondyîko nmyo, nmyi vy꞉o woni knî u ngwo adnyi pwopwo. ");
INSERT INTO yle_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yepê, A l꞉êê dîy꞉o pi yintómu knî ye wanmy꞉uu diya dmi, ");
INSERT INTO yle_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ngmênê nmyi vy꞉o pi l꞉âmo daangmêwa a ngêpa. ");
INSERT INTO yle_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yepê, Kîdmyengê kede dmi, myekîdmyengê mb꞉ii nê, nmyi l꞉âmo dmi u nkwo daawa ngêpa. ");
INSERT INTO yle_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesu ngê yepê, Dini ghi n꞉ii ngê lede yilî knî y꞉oo Njedusalem wa a yina ngmê, u ngwo dpo w꞉ee yó, apii, Daa kêmakêma ala p꞉aani wunê pw꞉oopw꞉oo ngmê. ");
INSERT INTO yle_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yepê, Njuda Wee u kwo yélini adnyi ya, dpî mbêpê dniye, mbu knî yi vyuwo dp꞉uu mbwolo dniye. Yepê, Yélini Njedusalem adnyi ya, dpî mbêpê dniye, yélini kn꞉aa adnyin꞉aa m꞉ii, Njedusalem mêkîngê diyé dmi. ");
INSERT INTO yle_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yepê, Yi dini ghi ngê a ntââ u ngwo wa a vy꞉ee ngmê, mu kópu u dîy꞉o kópuni yilî puku yedê a tóó, yi ngwo adnyi ntiyentiye dé. ");
INSERT INTO yle_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yepê, Dini ghi n꞉ii ngê yi kópu wa pyódu, mbwili knî y꞉oo dpodo ndîî wa a pyw꞉ee ngmê, p꞉aa knî y꞉oo dpodo ndîî amyedê pyw꞉ee ngmê. Yepê, Nju tpémini ala wee u kwo adnyi ya, dono ndîî wa a pyw꞉ee ngmê, mu kópu u dîy꞉o Chóó Lémi yi p꞉uu adî d꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yepê, Lede knî y꞉oo wa vya t꞉oo, woni kn꞉aa dyámê pee knî yi p꞉uu wa ńuw꞉o t꞉oo, y꞉i wop adnyin꞉aa dpodo. Yepê, Njedusalem d꞉ud꞉umbiy꞉e wa a pw꞉oo ngmê, yélini daa Nju tpémi dye ghi yintómu Njedusalem y꞉oo adnyi y꞉enê, u dî Chóó Lémi ngê wa vyi, awo, Yi yéli yi dye ghi machedê. ");
INSERT INTO yle_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesu ngê yepê, Pi knî y꞉oo kópu ndîî d꞉ââ kââdî, pudu knî yi p꞉uu adnyi mumu dé, u ngwo wa nkîngê mbê dmi. Yepê, Chaa kwodo chaa kwodo vyuwó ndîî ngê wa pyaa dmi, yi dnye dmi ndîî ngê wa pyaa dmi, yoo amyidnyi nkîngê. ");
INSERT INTO yle_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yepê, Chóó Lémi ngê mbóó p꞉uu tpile dé yi dînê dmi wa ghêê té, pi knî y꞉oo awo, Dyámê mbêmê ló kópu ngma a pyodopyodo, nkîngê ngê y꞉ay꞉a wa pwiyé dmi, yed꞉oo wa a vyóó dmi. ");
INSERT INTO yle_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yepê, U kuwó dini ghi ngê pi knî y꞉oo wa m꞉uu nê, wamye mya nê, awo, Chóó Lémi u Pi Ndêndê kîyedê pwiyé knî, u pi ndîî ngê dê pyódu, u wêdêwêdê ndîî ngê myaa pyódu, nkalî too pee dmi mbêmê ka kwo. ");
INSERT INTO yle_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yepê, Dini ghi n꞉ii ngê yi kópu yilî yi kn꞉ââ dmi adî chapî, dpî ghêêdî dmyeno, mbóó p꞉uu dpî vyu dmyeno, nmyi gha dmi mb꞉aamb꞉aa ngê dpî pyaa we, apii, Nmî Mbwámê kîyedê pwiyé knî. ");
INSERT INTO yle_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu ngê p꞉uu ndiye pyu knî ye mgongo ngmê kwólu. Yepê, Kpêdê p꞉uu ngî nuw꞉o mbê dmyeno, myenté yi woni knî mye yi k꞉ii. ");
INSERT INTO yle_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yepê, Dini ghi n꞉ii ngê kpêdê vyi dpî ghê, nmyi lama u ngwo dpî yââ, nmyimo, Daa kêmakêma nt꞉eemi wunê mbumu. ");
INSERT INTO yle_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yepê, Kpêdê ngê ntee nmye dpî vyi, Daa kêmakêma nt꞉eemi wunê mbumu, yepê, kópuni p꞉uu nmye nî danê, dini ghi n꞉ii ngê yi kópu wanmyi m꞉uu t꞉oo, yinté nmyi lama u ngwo wa yââ, anye, Daa kêmakêma Chóó Lémi ngê kóó k꞉oo a kapî nmo. ");
INSERT INTO yle_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Yélini ala ngwo a pyede, ghêlî daawa pw꞉oo dmi, Njedusalem p꞉uu kópuni nmye dî vyi, yi kópu mwiyé wa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yepê, Mbóó dyámê chedê ngê wa pyaa knî, ngmênê a kópu dyuu chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yesu ngê yepê, Nmyi chóóchóó nmye dmyina a vyuwo. Yepê, Nté ndapî y꞉oo nmyi nuw꞉o dmi kîdangê y꞉ee ngmê, mbwaa ndanî ngê nmyi nuw꞉o dmi myekîdangê y꞉oo. Yepê, Kópuni dyámê mbêmê tpémi y꞉oo a nuw꞉onuw꞉o t꞉oo, yi kópu knî y꞉oo nmyi nuw꞉o dmi kîdangê y꞉ee ngmê. Yepê, Yi kópu knî y꞉oo nmyi nuw꞉o dmi wa y꞉ee knomomê, ye kuwókuwó wéni daa nmyi lama wa d꞉ii. ");
INSERT INTO yle_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Yepê, Chii ngê kpéé ntee dpî lvêêdî, yi wéni ngê yinté kîngê lvêêdî nmyo, mu kópu u dîy꞉o pi yilî yintómu dyámê mbêmê yi wéni ye wa d꞉ii. ");
INSERT INTO yle_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yepê, Namê mgeemgee, dye ghi yintómu dmyinê ngêpê, yi kópu knî yi vy꞉o mb꞉aamb꞉aa ngê paan꞉aa lee dmyeno, Pi Ndêndê u ngîma paan꞉aa ghê dmyeno. ");
INSERT INTO yle_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","W꞉êênî Yesu ngê Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo yoo dpîmon꞉aa ndiye kîgha dé, ntumokwodo dini ghi ngê p꞉uu ndiye pyu knî yi k꞉ii Njedusalem dnyimo a kuwokuwo, mbwini n꞉ii u pi Olipi, yi mbwini mbêmê dnyimo lêpî, kââ puu ghê y꞉i dnyimon꞉aa dpî. ");
INSERT INTO yle_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mw꞉aandiye yintómu pi yilî Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo u kwo mêdnyimo lêpî, y꞉i dnyimon꞉aa ng꞉aang꞉aa. ");
INSERT INTO yle_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nju tpémi y꞉oo yi naa ndîî daa kêmakêma dnye kuwo. Yi nááli u pi Mbîdédi Pywápê Ngmê u Naa, u pi mye Tp꞉ee Kaa W꞉êêw꞉êê u Naa. ");
INSERT INTO yle_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Dêêpî pyu knî ngmê, kpêê yiyé pyu yoo yi kada pini yoo yi k꞉ii Yesu u pwele yi ngwo a châpwo ngópu. U yi y꞉e dêpwo kwo, Yesu yoo vy꞉o nmî mgîmî, mu kópu u dîy꞉o pi knî ye dnyimo nkîngê. ");
INSERT INTO yle_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yesu u dyépi y꞉a mê miyó knî yi vy꞉o pi ngmêdoo kwo, u pi Njudas, Kédiyót pi. Yi dini ghi ngê Setan yi Njudas u mênê kee wo, ");
INSERT INTO yle_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","5","wod꞉oo kpêê yiyé pyu yoo yi kada pini knî ye loo, yepê, Yesu u vyee u yi nmye a kwo. Yepê, Kwódo ngê anî ghê. Kada pini knî y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, yi gha dmi mb꞉aamb꞉aa ngê pyodo, Njudas ka kwo, Wanmî yi, u ye ndapî ṉga anmo kê. U kuwó dini ghi ngê Chóó Lémi u ngomo t꞉âât꞉ââ pyu yoo yi kada pini yoo mye yi k꞉ii nipi dnyen꞉aa danêmbum, Yesu u mgîmîmgîmî u nuw꞉o ghi dyuu yidnya a pyw꞉êmî. ");
INSERT INTO yle_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Njudas u nuw꞉o yi kópu ngmidi mbêmê doo ya, dye ghi doo y꞉enê, apê, Pi yilî kwéli daadî m꞉ii, Yesu kwódo ngê yi ngwo anî ghê. ");
INSERT INTO yle_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Wéni n꞉ii ngê Mbîdédi Pywápê Ngmê u Naa dnyimo kuwo, Nju tpémi y꞉oo sipi tp꞉oo u ngwo dnyimo vyee dé, Tp꞉ee Kaa W꞉êêw꞉êê u Naa nté u ngwo dnyimo l꞉âmol꞉âmo. ");
INSERT INTO yle_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu ngê Pita pini dê Njon dy꞉ââ doo, yepê, Choo lêpî, Tp꞉ee Kaa W꞉êêw꞉êê u nté kwéli nmîmo pîpî, tpile yilî y꞉i nmî kada nyi l꞉âmo nyoo. ");
INSERT INTO yle_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yesu ka póó knopwo, kwo, Tpile yilî ló y꞉i any꞉uu l꞉âmo? ");
INSERT INTO yle_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yepê, Njedusalem choo lêpî, pi ngmê ngê maa p꞉uu wunê pyépi dp꞉o, yi pini nkono mbwaa d꞉umu ngmêdpo mumu ngmê. Yepê, U ngomo k꞉oo dpî ngm꞉êê nyoo, ");
INSERT INTO yle_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ngomo chóó ka dp꞉uu póó cho, kwipi, Nyi mââwe ngê atédê dy꞉ââ nyo, ada, Naa u nté ló ngomo ghi k꞉oo wanm꞉uu ma, a p꞉uu ndiye pyu knî yi k꞉ii? ");
INSERT INTO yle_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yepê, Yi ngomo chóó ngê podo ngomo ghi ndîî dpo ngmêwunê kêmakêma, yepê, nmî ntââ tpile yilî yintómu y꞉i a tóó. Yepê, Nmî naa nté y꞉i dp꞉uu l꞉âmo nyoo. ");
INSERT INTO yle_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wod꞉oo p꞉uu ndiye pyu dê y꞉oo kada a y꞉ee ngópu, Njedusalem lee knopwo, kópuni Yesu ngê ye vyu, yi tpile yilî mî m꞉uu ngópu, yi nááli u nté yi ngomo k꞉oo adî l꞉âmo ngmê. ");
INSERT INTO yle_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kââdî dini ghi n꞉ii ngê gho, Yesu, u dyépi yoo yi k꞉ii, yi ngomo ghi k꞉oo mî kee dniye, kmaapî têdê yi yaa dniye. ");
INSERT INTO yle_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesu ngê yepê, A mgînî vyîmî u dye ghi n꞉ii noo t꞉âât꞉ââ, u ya a nga dêpwo kwo, Yi kópu ghêlî k꞉ii a nga pyaa we. Yepê, Yi ngwo a nga wodê pyodo, ye ala Tp꞉ee Kaa W꞉êêw꞉êê u Naa nté nipi daapudu ma. ");
INSERT INTO yle_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yepê, Ala kópu ny꞉ee yó. Yepê, Ala a kuwókuwó nááli, a k꞉ii mêdaamunmî kê, u dî Chóó Lémi ngê chóó ada a y꞉enê nmyo. Yepê, Kópuni ala nááli u mgamê ngê a tóó, ala yi kópu, Chóó Lémi ngê nmî kn꞉ââ yoo Yichip tpémi yi kêê k꞉oo mwo a pw꞉ii too, apii. Yepê, Mu dini ghi ngê Chóó Lémi ngê dono kwulo yinté d꞉ud꞉umbiy꞉e wa a pw꞉ii nmyo. ");
INSERT INTO yle_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wod꞉oo Yesu ngê kapî ngma a y꞉ângo, wain k꞉oo a pii ngê, kumu mbee ngê, Chóó Lémi kwuno ngê, u dyépi knî ye yepê, Ala wain kapî a ngee yó, knîknî nda yó, ");
INSERT INTO yle_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","mu kópu u dîy꞉o wain daamunî nda, u dî wéni n꞉ii ngê a pi ndîî ngê amî pyódu, pi yintómu anî y꞉enê, kmaapî ndîî u ngwo anm꞉uu dóó. ");
INSERT INTO yle_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","U kuwó dini ghi ngê mbîdédi a ngêêdî, Chóó Lémi kwuno ngê, puwâ, p꞉uu ndiye pyu knî ye y꞉ângo, yepê, Ala a chóóchóó, nê, nmye yed꞉a kê. Yepê, Kópuni dî d꞉uu, myedmyinê d꞉uud꞉uu, a mgamê ngê choo ya. ");
INSERT INTO yle_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kmaapî u kuwó dini ghi ngê kapî mêdê y꞉ângo, wain k꞉oo a pii ngê, ye y꞉ângo, yepê, Ala a wêê. Yepê, Nmyi l꞉êê dîy꞉o wêê a p꞉uu wa pwii, Chóó Lémi ka kââdî te kamî ngê yinê wa a kââdî nmyo. ");
INSERT INTO yle_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yepê, Ngmênê nmyi vy꞉o pini mu ngmidi kuu. Yepê, K꞉omo tpile u k꞉ii nipi nmo kmaapî té, ngmênê daa kêmakêma yi pini a kwódo ngê a wowo. ");
INSERT INTO yle_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yepê, Chóó Lémi ngê kópuni a p꞉uu ló dini a vyu, yi kópu ndêndê ngê a pyodopyodo, ngmênê pini n꞉ii a kwódo ngê a wowo, d꞉ud꞉umbiy꞉e choo nkîngê. ");
INSERT INTO yle_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wod꞉oo noko dnye póó, noko yipu, Nmî vy꞉o pini n꞉uu ngê kî kópu a d꞉uud꞉uu? ");
INSERT INTO yle_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","U kuwó dini ghi ngê Yesu p꞉uu ndiye pyu yoo noko dnye kwopwepe, noko yipu, Yesu u kuwó n꞉uu ngma tóó, nmî kada pini ngê vyîlo ayi pyódu. ");
INSERT INTO yle_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu ngê yepê, Yélini daa Nju tpémi, yi vy꞉o yélini kada pini ngê dpî pyaa dmi, a lémilémi nyédi, yi chóó yi pi dmi a kmîmî tumo, apu, Nmo yoo yi mbwámê dé. ");
INSERT INTO yle_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yepê, Ngmênê yi kópu nmyi vy꞉o kîngê ya. Yepê, Tp꞉ee ngê pyââwe mââwe ntee a chââchââ too, nmyi vy꞉o pini n꞉ii u pi ndîî ngê dê pyaa knomomê, yi pini ngê u tîdê mbwó yoo yinté myechoo chââchââ dé. Yepê, Pini n꞉ii nmyi kada adî kwo, u tîdê mbwó yoo myechoo ngêêpî dé. ");
INSERT INTO yle_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yepê, Nee k꞉oo ló pini yi lémi ndîî, n꞉ii a lîme yédi, ó n꞉ii a mbiye yédi? Yepê, N꞉ii a lîme yédi, yini lémi ndîî, apii, ngmênê nmyi vy꞉o dênoo lîme, myedênoo lémilémi. Yepê, Yinté myedmyinê d꞉uud꞉uu, lémilémi ngê kêê nangê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yepê, Ngmênê mu dini ghi ngê nmyi pi dmi ndîî ngê wa pyódu. Yepê, K꞉omo tpile a tókótókó têdê pi knî y꞉oo a pi têdê ngê a pyódu ngópu, ngmênê dpîp꞉e kuwo noo, nmyi pi dmi têdê ngê myedê pyódu ngópu. ");
INSERT INTO yle_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Yepê, M꞉aa ngê ntee a ngmidi noo, yoo yi kada pini ngê a pyódu noo, yepê, yinté mu dini ghi ngê Yisîléli tpémi yi yoo dyêêdî y꞉a mê miyó wanmyi y꞉enê dé. Yepê, Yi dini ghi ngê a kêê k꞉oo nipi anmîn꞉aa yakmaapî. ");
INSERT INTO yle_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu ngê Pita ka kwo, Saimon. Kwo, Ala kópu ngî nyeni. Kwo, Setan ngê wunê kêda ch꞉ee nmyo, u yi u ngwo a kwo, Nê tókó té. ");
INSERT INTO yle_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kwo, Ngmênê ḻ꞉êê dîy꞉o kîn꞉aa ngêpê yédi, k꞉omo tpile nyinê wópuwópu nê, ngmênê ṉgêlîmî a ka d꞉ud꞉umbiy꞉e chedê ngê daawa pyódu. Kwo, Dini ghi n꞉ii ngê a ka amênyinê tpélimbiy꞉e, m̱wó yoo dpî wêdêwêdê kalê té, yi kêlîmî ndîî ngê dpî pyódu ngi. ");
INSERT INTO yle_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita ngê kwo, A Lémi, daanê wópu ngi. Kwo, K꞉omo tpile mbwa k꞉oo wa km꞉êê ngi, a k꞉ii amy꞉ii kee knî, k꞉omo tpile ḻ꞉êê dîy꞉o wa vya nê, myedaanê wópu ngi. ");
INSERT INTO yle_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu ngê kwo, Pita. Kwo, Ndê kópu ṉga ngmên꞉aa tpapê. Kwo, Kêmkêm ghêlî k꞉ii daawa kââ, pyolo nyinê wópuwópu nê, pi knî ye ala kópu nye tpapê, yenye, Ye pini daa a lama pini. ");
INSERT INTO yle_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu ngê yepê, Dini ghi n꞉ii ngê p꞉aani p꞉aani munî dy꞉ââ nmyoo, nmyi tpile dpîp꞉engmê ńuw꞉o ngópu, ndapî dpîp꞉e ńuw꞉o ngópu, nmyi yi dópo kn꞉aani myedpîp꞉e ńuw꞉o ngópu, yepê, lukwe, tpile ngmê u p꞉aa nmye ngmêmî yó? Kwo, Kêle, u ntââ mbêmê nmeen꞉aa ya, yoo mb꞉aamb꞉aa ngê nmo dnya a vyuwo. ");
INSERT INTO yle_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu ngê yepê, Ngmênê dye ghi kamî ngma ala, yinté nmye mêdaamudnya a vyuwo. Yepê, N꞉ii u ngópu paambwi u tpile n꞉ii a pyede, dpî ńuw꞉o teńe, n꞉ii u ngópu ndapî a tóó, myoo ńuw꞉o ngê. Yepê, N꞉ii u ngópu l꞉êê taa daa tóó, u nkwo kpîdî pi ngmê ka dpî y꞉ee ngê, u kwo wa pwila, u l꞉êê taa u ngwo ngmêpaa pwila ngê, ");
INSERT INTO yle_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","mu kópu u dîy꞉o kópuni a p꞉uu ló dini a d꞉êê ngópu, pi knî y꞉oo a ntiyentiye ngmê. Yi kópu ala, Yi pini p꞉uu pi knî y꞉oo wa vyi ngmê, Pi dono yila. Yepê, Kópu yilî n꞉ii a p꞉uu a d꞉êê tumo, pi knî y꞉oo a ntiyentiye t꞉oo. ");
INSERT INTO yle_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","P꞉uu ndiye pyu knî y꞉oo kwo, Nmî Lémi. Kwo, Nmî l꞉êê taa miyó ala. Yesu ngê yepê, Yinté danêmbum munto. ");
INSERT INTO yle_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu, p꞉uu ndiye pyu yoo yi k꞉ii, mgîdî vy꞉o ntee dnyimo lêpî, yi mgîdî ngê yinté mye lee dniye, Njedusalem a kuwo ngópu, mbwini n꞉ii u pi Olipi, yi mbwini mbêmê lee dniye. ");
INSERT INTO yle_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dini ghi n꞉ii ngê taa dniye, Yesu ngê yepê, Dmyinê ngêpê, nmyi tókótókó ndîî ngê daapaa pyaa we. ");
INSERT INTO yle_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wod꞉oo a kuwo too, ntee daa kuughê loo, yu mbodo dê y꞉e y꞉i mî ghê wo, y꞉i doon꞉aa ngêpê. ");
INSERT INTO yle_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","U Mî ka kwo, M꞉aa. Kwo, U ntââ ala dono u mbwaa daanî nda? Kwo, Ngmênê ṉgwépi daanî puwâ. Kwo, K꞉omo tpile ala kópu u ya a nga daa kwo, ngmênê a nga dpî d꞉uu ngi, mu kópu u dîy꞉o a kada nye tóó. ");
INSERT INTO yle_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Wod꞉oo enjel ngmê mbóó p꞉uu a ndê wo, Yesu yimi mê wêdêwêdê kwólu. ");
INSERT INTO yle_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","U nuw꞉o dyênê wo, u ghê a kee wo, dpodombiy꞉e modoo ngêpê, wod꞉oo kiyé t꞉ââ u ngwo yedoo ya. ");
INSERT INTO yle_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","U kuwó dini ghi ngê ngêpê yedê kêlî ngê, p꞉uu ndiye pyu knî ye yi diyé wo, dpî têdê m꞉uu too, mu kópu u dîy꞉o yi nuw꞉o dmi d꞉ud꞉umbiy꞉e dono ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wod꞉oo yepê, Lukwe dîy꞉o nmye dpî té. Yepê, A pii dmyeno, dmyinê ngêpê, nmyi tókótókó ndîî ngê daapaa pyaa we. ");
INSERT INTO yle_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu ngê danêmbum ghêlî daa chedê ngê, wod꞉oo lede yoo taa dniye, Njudas yi kada doo kwo, pini n꞉ii Yesu p꞉uu ndiye pyu y꞉a mê miyó knî yi vy꞉o pwii wo, Yesu yinê dóó. Dini ghi n꞉ii ngê taa dniye, Njudas Yesu ka loo, Nju tpémi yi chipéchipé ngê Yesu u ngwo a chipé ngê, ń꞉uu Yesu kpââ pee p꞉uu dyîngo. ");
INSERT INTO yle_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ngmênê Yesu ngê kwo, Lukwe dîy꞉o chipéchipé mbêmê Chóó Lémi u Pi Ndêndê pi dono knî ye nyinê kêmakêma? ");
INSERT INTO yle_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu p꞉uu ndiye pyu knî y꞉oo dini ghi n꞉ii ngê a w꞉ee ngópu, apê, Yesu awêde a mgîmîmgîmî ngmê, wod꞉oo Yesu ka póó dniye, kwo, Nmî Lémi, yi p꞉uu l꞉êê kmêle, apii? ");
INSERT INTO yle_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wod꞉oo ngmê ngê u taa a ngêêdî, apê, Lede yoo nî vya té, apê, ngmê mbwámê nê châpwo, ngmênê kn꞉aadi ngê, u wéni pee ngwene ngópu. Yi lede kpêê yiyé pyu yoo yi kada pini u dpodo pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ngmênê Yesu ngê yepê, Yi p꞉uu l꞉êê munto, wod꞉oo yi lede ngwene mê kââ. ");
INSERT INTO yle_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yélini Yesu u mgîmîmgîmî u l꞉êê dîy꞉o a lee dniye, kpêê yiyé pyu yoo yi kada pini yoo, Chóó Lémi u ngomo t꞉âât꞉ââ pyu yoo, kada pini yoo mye yi k꞉ii, yi yéli ye Yesu ngê yepê, D꞉aa l꞉êê pyu ngmê. Yepê, Lukwe dîy꞉o kaa taa kêlê a ka dmyinê lee dmi. ");
INSERT INTO yle_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yepê, Wo yilî yi k꞉oo Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo nmyi vy꞉o kînoo a kwo, y꞉i nîmon꞉aa dêêpî. Yepê, Lukwe dîy꞉o y꞉i w꞉êênî dpîp꞉e mgîmî noo. Yepê, Nmyo mgîdî u yoo, Setan ka nmye ng꞉aa té, mgîdî vy꞉o dmye mgîmî nê. ");
INSERT INTO yle_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dini ghi n꞉ii ngê Yesu mgîmî ngópu, kpêê yiyé pyu yoo yi kada pini ndîî u ngomo k꞉oo ńuw꞉o ngópu, u kóté kîgha u l꞉êê dîy꞉o. Pita ngê doo yâmuyâmu dé, tumutumu yi kuwó doo a kwo, daa chono doo a paa, wod꞉oo yi ngomo mbwa kalê ngmê k꞉oo myimî kee wo. ");
INSERT INTO yle_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nkuwo u l꞉êê dîy꞉o ndyuw꞉e ndîî y꞉i ngmê kpê ngópu, Pita u k꞉ii ndoo chedê yaa dniye. ");
INSERT INTO yle_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dpodo módó ngmê ngê ndyuw꞉e u wo Pita yi módu, doo y꞉enê, pi knî ye yepê, Pini n꞉ii dmyinê ńuw꞉o ngmê, kî pini p꞉uu kîdpîmo ya. ");
INSERT INTO yle_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ngmênê Pita ngê a wópu ngê, kwo, Kî dmââdî, ye pini daa a lama pini. ");
INSERT INTO yle_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","U kuwó dini ghi ngê pi ngmê ngê myeyi módu, kwo, Nyi wu pini p꞉uu ndiye pyu ngmê. Ngmênê Pita ngê kwo, Kî pini, nê kuu. ");
INSERT INTO yle_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Daa ndîî dye ghi yimî loo, pi m꞉uu ngê u pyipe knî ye yepê, Kî pini nmo ka k꞉omodanê, u dnye ngî ny꞉ee yó, Nkálili pi nmye yila, yi dnyeni nmye ka kîgha. ");
INSERT INTO yle_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngmênê Pita ngê kwo, Kî pini, kópuni p꞉uu a ka nye danê, a lama daa tóó. Danêmbum ghêlî dêpê kêlî ngê, wod꞉oo kêmkêm ka wo. ");
INSERT INTO yle_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yesu yi ngwo Pita ka diyé wo, doo y꞉enê, wod꞉oo Pita ngê nmî Lémi u kópu mê nuw꞉o kwólu, apê, Ala kópu a ka moda vyi, Kêmkêm ghêlî k꞉ii daawa kââ, pyolo nyinê wópuwópu nê, ");
INSERT INTO yle_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","wod꞉oo Pita u gha d꞉ud꞉umbiy꞉e dyênê wo, kuwa pwii wo, y꞉i doon꞉aa mbê. ");
INSERT INTO yle_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yélini yi kêê k꞉oo Yesu doo kwo, yi yéli y꞉oo dnye nkwitinkwiti, myednye kpakakpaka. ");
INSERT INTO yle_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Dini ghi n꞉ii ngê dnye nkwitinkwiti, kpîdî pee ngê u ngwolo dê wópu dumo, u nkwo dnye vyee, kópu, N꞉aa dê vya ngi? Kópu, Chi dîpî. Kópu, W꞉ii Chóó Lémi u komo kapî pyu ngmê, ye pini n꞉ii ngê dê vya ngi, u pi nmo pîchi vyi. ");
INSERT INTO yle_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","U pi dyênê ngópu, daa gha kópu u kwo yilî vyi ngópu. ");
INSERT INTO yle_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Dini ghi n꞉ii ngê wa wo, Nju tpémi yi kada pini yoo, kpêê yiyé pyu yoo yi kada pini yoo, dêêpî pyu yoo yi k꞉ii, nipi a da wo, Yesu u ngwo dnye kóté kîgha. ");
INSERT INTO yle_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kwo, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, n꞉ii nmo t꞉âât꞉ââ, nyi vyîlo y꞉ii kwo knomomê, ye nmo vyi ngi. Yepê, Nmye n꞉aa tpapê knomomê, Ala nê vyîlo, ye a ka daanmyinê kêlîmî mbê dmi. ");
INSERT INTO yle_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yepê, Myenté, nmye n꞉aa póó knomomê, kópu a ka myedaanmyinê vyi ngmê, ");
INSERT INTO yle_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ngmênê daa kêmakêma Pi Ndêndê Chóó Lémi u nkîgh꞉ê wumê yââyââ, u ngwo anmyinê w꞉ee ngmê, anye, Kî Chóó Lémi u che p꞉ââ pee. ");
INSERT INTO yle_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","U kwo póó dniye, kwo, Mumdoo nyi Chóó Lémi Tp꞉oo? Yepê, Nmyi chóó kîdmye vyi ngmê. ");
INSERT INTO yle_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wod꞉oo noko yepê, Kî pini u châpwo pyu u yi nmo daamu a kwo, chóóchóó kêdê ndyîko, chóó u kópu dyuu nmî chóó kudu ny꞉oo, u yi u ngwo a kwo, Chóó Lémi u d꞉aa nê kââdî. Noko yepê, Pw꞉oo we, daadî ya. ");
INSERT INTO yle_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kada pini yintómu yi ngwo a ghêêdî dniye, Lóma lede yoo yi kada pini ndîî Paléti ka Yesu ńuw꞉o ngópu, ");
INSERT INTO yle_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","p꞉uu yipe tee kn꞉ââ yi ngwo a chaa ngópu, kwo, Ala pini aténgê dp꞉o mgîmî, pi knî ye ala kópu a tpapê ngê, yipu, Kada pini n꞉ii Lóma wunê tóó, tákisi u kwo namê pywupwi. Kwo, Yi kópu mbêmê pi yilî da pyidu té, u yoo vy꞉o u ngwo dê kaa té. Kwo, Ala kópu ye mye tpapê ngê, Chóó Lémi ngê a ngmidi noo, nmyi king ngê wunê pyépi nê. ");
INSERT INTO yle_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Paléti ngê p꞉oo ngê, kwo, Mumdoo nyi Nju tpémi yi king? Yesu ngê kwo, Ṉ́yóó kîchi vyi. ");
INSERT INTO yle_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wod꞉oo Paléti ngê kpêê yiyé pyu yoo yi kada pini yoo, pi yilî yi k꞉ii, yepê, Ala pini u kpadakpada u kópu d꞉oongmê pyw꞉ângo. ");
INSERT INTO yle_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ngmênê Paléti ka dyaa dnye chedêchedê, kópu, Pi yilî wunê pyidupyidu too, dnyinté wunê tpyuu té. Kópu, Nkálili Wee u kwo kn꞉ââ a chópu, Njuda Wee u kwo p꞉aani p꞉aani yoo myemênê pyidu too, u dî ala Njedusalem myimî ta. ");
INSERT INTO yle_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Dini ghi n꞉ii ngê Paléti ngê yi kópu yi nyongo, pi knî ye póó wo, yepê, Mumdoo ala pini Nkálili pi? Kwo, Nyââ, Nkálili a ndê wo. ");
INSERT INTO yle_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Dini ghi n꞉ii ngê Paléti ngê a w꞉ee ngê, apê, Yesu Helodi kóó k꞉oo pini ngmê, wod꞉oo Helodi ka dy꞉ââ ngê, mwada p꞉aani pee. Yi ngwo Helodi Njedusalem naa têdê myedoo ya. ");
INSERT INTO yle_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helodi ngê Yesu yi módu, u gha mb꞉aamb꞉aa ngê pyodo, mu kópu u dîy꞉o u pi ló dini a nyongo, dye ghi daadîî u yi u ngwo doo kwo, Nî m꞉uu, mbwudu a ngópu ngmê chaa ngê. ");
INSERT INTO yle_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wod꞉oo Helodi ngê Yesu doo póópóó, ngmênê Yesu ngê kópu u kwo daangmê vyu. ");
INSERT INTO yle_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kpêê yiyé pyu yoo yi kada pini yoo, dêêpî pyu yoo mye yi k꞉ii, dpodombiy꞉e ghê dniye, Yesu p꞉uu yipe tee kópu yilî t꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","U kuwó dini ghi ngê Helodi u lede knî yi k꞉ii, Yesu dnye nkwitinkwiti, d꞉ud꞉umbiy꞉e daa châpu ngópu. Kpîdî mb꞉aa u mbwo ngmê t꞉ee ngópu, Paléti ka u ngwo mê dy꞉ââ ngópu. ");
INSERT INTO yle_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Yi wéni ngê Paléti pini dê Helodi numo pyipe ngê mê pyaa knopwo, mu kópu u dîy꞉o Paléti ngê Helodi châpu ngê, kóó k꞉oo pini u kwo ngmê dy꞉ââ ngê. Mwiyé noko dpîmo a diya. ");
INSERT INTO yle_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paléti ngê kpêê yiyé pyu yoo yi kada pini yoo, yoo yi kada pini yoo, pi yilî mye yi k꞉ii, nipi mêdê danê ngê, ");
INSERT INTO yle_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","yepê, Ala pini a ka kîdmyinê ńuw꞉o ngmê, a ka kîdmye vyi ngmê, a ka nyimu, Yoo yilî kîyedê pyidupyidu té, chóó u pee ngê ka kapî té. Yepê, Wunê nmyi ngópu kîdî kóté kwolo, pwopwo u kópu p꞉uu d꞉oongmê pyw꞉ângo, ");
INSERT INTO yle_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Helodi ngê yinté kópu p꞉uu myedoo pyw꞉ângo, a ka kîmêda dy꞉ââ. Yepê, Pwopwo u kópu p꞉uu daa t꞉a mo daa t꞉a. ");
INSERT INTO yle_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yepê, A lede knî y꞉oo a kpakakpaka ngmê, yed꞉oo n꞉aa pw꞉iipw꞉ii. ");
INSERT INTO yle_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","M꞉ââ k꞉oo Nju tpémi yi naa ndîî u dye ghi ngê, yélini mbwa k꞉oo dnyimo kwo, Paléti ngê ngmêdpîmo pw꞉iipw꞉ii, apu, Nju tpémi yi nuw꞉o dmi mb꞉aamb꞉aa ngê paa pyaa we. Pini n꞉ii u pi pi knî y꞉oo u kwo dnyimo tpapê, yini yidpîmo pw꞉iipw꞉ii. ");
INSERT INTO yle_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Paléti ngê u yi doo kwo, Yesu nî pw꞉ii, ngmênê pi yintómu dpodombiy꞉e u kwo mbó dniye, kwo, Daanyi pw꞉ii. Kwo, Vya ngi. Kwo, Mbadapas yi pw꞉ii ngi. ");
INSERT INTO yle_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Yi Mbadapas ngê u yi doo a kwo, Lóma lede yoo nmî ngm꞉ii kalê té. U yoo yi kada mwiyé a ghê wo, Lóma lede woni a vya tumo, u l꞉êê dîy꞉o u yoo knî yi k꞉ii mbwa k꞉oo u ngwo kee dniye.) ");
INSERT INTO yle_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paléti ngê u yi doo kwo, Yesu nî pw꞉ii, wod꞉oo pi knî ye mbwolo, yepê, Kêle. Yepê, Yesu vyîlo yinî pw꞉iipw꞉ii, ");
INSERT INTO yle_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ngmênê pi knî y꞉oo dpodombiy꞉e kwo, Kîdosi ńedê t꞉ee ngi. Kwo, Pw꞉oo we, daadî ya. ");
INSERT INTO yle_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Paléti pyolombó ye mê póó wo, yepê, Ló dono kópu ndîî ngmê d꞉uu ngê? Yepê, Pwopwo u kópu p꞉uu d꞉oongmê pyw꞉ângo. Yepê, A lede knî y꞉oo a kpakakpaka ngmê, yed꞉oo n꞉aa pw꞉iipw꞉ii. ");
INSERT INTO yle_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ngmênê Paléti ka dêdnye ng꞉aa, dpodombiy꞉e u kwo modnye kââ, kópu, Kîdosi ńedê t꞉ee ngi. Yinté dnye kââ ee, u dî yi pono mî vyápê wo, ");
INSERT INTO yle_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","lede knî ye yepê, kîdosi ńedê nyi t꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Paléti yi pono vyápê wo. Pini n꞉ii l꞉êê pyu ndîî Mbadapas, pi vyee u l꞉êê dîy꞉o mbwa k꞉oo mwiyé a kee wo, pwopwo y꞉i doon꞉aa t꞉âât꞉ââ, yi pini pw꞉ii ngê, ngmênê Yesu u vyee têdê dy꞉ââ ngê. ");
INSERT INTO yle_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Lóma lede knî y꞉oo Yesu u vyee têdê ńuw꞉o ngópu. Maa p꞉uu pi ngmê m꞉uu ngópu, u pi Saimon, Sadéni pi, Njedusalem doo lêpî. Lede knî y꞉oo yi pini mgîmî ngópu, Yesu u kîdosi u kîgha yé ngópu, kwo, Kî pini u kîdosi dnyinê ngi. Wod꞉oo Yesu u kuwó doo kwo, u kîdosi doo dnyinêdnyinê. ");
INSERT INTO yle_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pi yilî yi kuwó doo kwo, dnye yâmuyâmu dé. Pyââ knî yi vy꞉o my꞉oodoo kwo, Yesu u l꞉êê dîy꞉o dnye mbê. ");
INSERT INTO yle_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu ye mênê diyé wo, yepê, Njedusalem pyââ yoo. Yepê, A l꞉êê dîy꞉o mbê mu yé yó, nmyi chóó nmyi l꞉êê dîy꞉o dmyinê mbê, nmyi tp꞉ee dmââdîma yi l꞉êê dîy꞉o myedmyinê mbê. ");
INSERT INTO yle_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yepê, Dye ghi ngmê kîyedê pyiyé knî, yi ngwo nmyi kpadakpada ndîî wanmyinê pyw꞉ee ngmê. Yepê, Dini ghi n꞉ii ngê nmyi tp꞉ee dmââdîma nmyi ngópu adnyi vyee dé, ala kópu wanmy꞉uu vyi ngmê, anye, L꞉omo m꞉aa tpamê wo, a tp꞉ee l꞉omo m꞉aa tpyó. ");
INSERT INTO yle_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yepê, Yi ngwo nkîngê ngê y꞉ay꞉a wanmyi pwiyé dmi, u yi nmye adî kwo, anye, Mbu nmî pwo a vyuwó dniye, lîmîlîmî ngê u ngwo p꞉oo pw꞉oo dmi. ");
INSERT INTO yle_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yepê, Ala lede yoo yi p꞉uu dênoo d꞉uu, ngmênê dono a nga a d꞉uud꞉uu ngmê. Yepê, Dini ghi n꞉ii ngê yi p꞉uu anmyin꞉aa d꞉uu, angêntoo dono u nkwo nmye angmê d꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pi mê miyó yi vyee têdê mye ńuw꞉o dumo, pi dono dê. ");
INSERT INTO yle_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kwéli lee dniye, yi ghi u pi Mbodo Dînê. Yesu kîdosi ńedê y꞉i mî t꞉ee ngópu, pi dono dê kîdosi ńedê y꞉i myimî t꞉ee dumo, woni u wéni pee t꞉ee ngópu, woni u t꞉anê pee t꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu ngê u mî ka kwo, M꞉aa. Kwo, Kî yéli y꞉oo kópuni a nga dê d꞉uu ngmê, daa yi lama dê d꞉uu ngmê. Kwo, Yi kópu m̱odo kn꞉ââ vyuwo dpî kéé ngi, mênangê ngî. Yesu u kpîdî yêê tumo, yi kpîdî knî yi l꞉êê dîy꞉o dnye ng꞉oo, noko yepê, Alani nanê wa a ngî, woni nanê wa a ngî? ");
INSERT INTO yle_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yélini y꞉i doo kwo, yi yéli y꞉oo dnye y꞉enê. Yi ngópu Nju tpémi yi kada pini knî y꞉oo dnye nkwitinkwiti, noko yipu, Mumdoo Chóó Lémi ngê kî pini a ngmidi ngê, yoo ntee doo ngêêpî dé, ye chóóchóó yinté mye ngee ngê. ");
INSERT INTO yle_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Lede knî y꞉oo myednye nkwitinkwiti, k꞉omo ngê wain u kwo dnye dp꞉eedp꞉ee, ");
INSERT INTO yle_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kópu, Mumdoo nyi Nju tpémi yi king, ṉ́yóóchóó mê ngee ngi. ");
INSERT INTO yle_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","U pwopwo u nt꞉u kópu kîdosi ńedê u pwo t꞉ee ngópu, apê, Nju tpémi yi king. ");
INSERT INTO yle_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pini n꞉ii dê u nkîgh꞉ê t꞉ee dumo, ngmê ngê kwo, Chi dîpî. Kwo, Nyi lónté kada pini. Kwo, Mumdoo Chóó Lémi ngê a ngmidi nyoo, ye ṉ́yóóchóó mê ngee ngi, mye ngee nyédi. ");
INSERT INTO yle_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ngmênê woni ngê yi kópu u kwo kwódu ngê, kwo, U kwo kidimê mbumu. Kwo, Lukwe, Chóó Lémi ka d꞉ii nkîngê? Kwo, U ngmidi ngmê u pi vyîlo y꞉ii nkwitinkwiti. Kwo, Nipi nganmo mgînî vyîmî té. ");
INSERT INTO yle_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kwo, Kópuni nyi kn꞉aadi too, u dîy꞉o nye mgînî vyîmî mo, ngmênê kî pini ngê kópu daangmê kn꞉aadi ngê. Kwo, Lukwe dîy꞉o nye nkwitinkwiti. ");
INSERT INTO yle_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yesu ka kwo, Yesu, dini ghi n꞉ii ngê king ngê anyi pyódu, ṉgêê k꞉oo dpî kaa nédi. ");
INSERT INTO yle_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu ngê kwo, Ndê kópu ṉga ngmên꞉aa tpapê, awêde ghi mb꞉aa nipi nye lêpî mo. ");
INSERT INTO yle_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yi dini ghi ngê kââdî mbóó ńuknîńuknî p꞉uu doo kwo, yi dyámê pee mbêmê mgîdî a ghay wo. Dini ghi n꞉ii ngê kââdî ngê liy꞉aa pyile a kuwo ngê, mê wa wo. ");
INSERT INTO yle_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yi dini ghi ngê Chóó Lémi u ngomo k꞉oo kpîdî ndîî n꞉ii doo ya, yi kpîdî ngê yoo yi maa dpîmo nkokonkoko, apê, Chóó Lémi u yâpwo ghi k꞉oo daapaa nî dniye. Yesu kîdosi ńedê dini ghi n꞉ii ngê pwene, wod꞉oo yi kpîdî chóó mînê chaa wo, châpwochâpwo ngê nkwodo a yaa wo, knâpwo dî. ");
INSERT INTO yle_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu kîdosi ńedê modoo ya, u mî ka dpodombiy꞉e ka wo, kwo, M꞉aa, a ghê dmi ṉga d꞉a kê, a ngini. Yi kópu yi vyu, wod꞉oo pwene. ");
INSERT INTO yle_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Lede n꞉ii knî y꞉oo Yesu kîdosi ńedê t꞉ee ngópu, yi lede yoo yi mââwe ndîî kîdosi u nkîgh꞉ê doon꞉aa kwo. Dini ghi n꞉ii ngê Yesu u ngópu pwene, Chóó Lémi chaa kwólu, apê, Kî ndêndê ngê pi mb꞉aa, u kn꞉aadi te kópu daa tóó. ");
INSERT INTO yle_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pi yilî, n꞉ii knî y꞉oo Yesu u pwopwo têdê dnyen꞉aa y꞉enê, dini ghi n꞉ii ngê yi ngópu pwene, yi nuw꞉o dmi dono ngê pyodo, u l꞉êê dîy꞉o dnye yii, yi p꞉aa pee p꞉aa pee mê diyé dniye. ");
INSERT INTO yle_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yélini Yesu u lama dnye ya, daa chono dnya a kwo, y꞉i dnya a y꞉enê. Pyópuni yoo Nkálili Wee u kwo Yesu p꞉uu mwiyé a kaa dniye, u k꞉ii Njedusalem lee dniye, yi yéli yi vy꞉o myednye kwo. ");
INSERT INTO yle_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kada pini ngmê, u pi Njósép, Adamátiya pi. Yi p꞉aani Njuda Wee u kwo a tóó. Yi pini pi mb꞉aa, apu, Chóó Lémi ngê nmî y꞉enê kn꞉ââ lîmî k꞉ii ngê paa chaa ngê. K꞉omo tpile kada pini knî yi vy꞉o doo kwo, ngmênê Yesu u pwele châpwo têdê, u vyee têdê yi vy꞉o daa ghê wo. ");
INSERT INTO yle_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yesu dini ghi n꞉ii ngê pwene, yi pini Paléti ka loo, Yesu ntóó u kwo mînê ch꞉ee ngê. ");
INSERT INTO yle_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Paléti ngê kwo, U ntââ, wod꞉oo Njósép loo, Yesu ntóó kîdosi ńedê a ngópu, kpîdî pee ngê a kmongo ngê, ntóó ńuwo, kpomo u mênê mî yó. Yi kpomo pi knî y꞉oo t꞉aanî paa mwiyé a ché ngópu, pi ntóó kmênêkmênê u l꞉êê dîy꞉o. ");
INSERT INTO yle_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yi wéni Pîdade, womumo lîme wo. ");
INSERT INTO yle_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pyópuni knî y꞉oo Yesu Nkálili Wee u kwo dnya a yâmuyâmu, Njedusalem u k꞉ii myimî taa dniye, yi pyópu knî y꞉oo Njósép ngm꞉êê ngópu, Yesu ntóó kpomo u mênê yi ngópu mî kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","U kuwó dini ghi ngê yi p꞉aa pee mê diyé dniye, apê, Tpileni tuu mb꞉aamb꞉aa dé, knî ngmênmî nya, Yesu ntóó p꞉uu nm꞉uu d꞉ii té, ngmênê yi ngwo kââdî gho, yi lîme wo kn꞉ââ chópu, mêdaa lee dniye. Yi dêêpî kópu dyuu châpu ngópu, lîme wo ngê dnye lîme. ");
INSERT INTO yle_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pyópuni knî y꞉oo tpileni tuu mb꞉aa mwiyé a l꞉âmo tumo, Sandé mw꞉aa mgîdî vy꞉o ńuw꞉o tumo, apê, Yesu ntóó p꞉uu nm꞉uu d꞉ii té. ");
INSERT INTO yle_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kpomo chedê dini ghi n꞉ii ngê taa dniye, apê, Chêêpî ndîî kpomo t꞉âmo lukwe ngê atédê tpiyé wupu kwolo, ");
INSERT INTO yle_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","wod꞉oo kpomo u mênê kee dniye, ngmênê nmî Lémi Yesu ntóó daa m꞉uu ngópu. ");
INSERT INTO yle_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yi kópu dêpê w꞉ee ngópu, yi nuw꞉onuw꞉o u kópu ngê pyodo, wod꞉oo pi miyó anya a pwiyé knopwo, apê, Mu kwo mo, yi kpîdî dmi dê muyedê wuu mbele mo. ");
INSERT INTO yle_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nkîngê ngê y꞉ay꞉a pwiyé dniye, yi tpódu châpu dumo, mbwódo dyimê dniye, k꞉ame ye ghê dniye. Yi tpódu y꞉oo yepê, Pini n꞉ii ghê a t꞉a, lukwe dîy꞉o kpêênî m꞉een꞉aa nmy꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yepê, Al꞉ii daa tóó, yepê, kêda pyidu. Yepê, Yi kópu dyuu wunê munmya a vyu, dini ghi n꞉ii ngê nmyi vy꞉o modoo a kwo, Nkálili Wee u kwo. Yepê, Ala kópu nmye mwo a vyu, ");
INSERT INTO yle_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","nmyepê, K꞉omo tpile nê Chóó Lémi u Pi Ndêndê, ngmênê pi dono knî y꞉oo wa mgîmî nê, kîdosi ńedê wa t꞉ee nê, wo pyoloni k꞉oo amênê pyidu. ");
INSERT INTO yle_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wod꞉oo yi pyópu knî y꞉oo yi kópu dyuu yimî nuw꞉o kalê ngópu, ");
INSERT INTO yle_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","kpomo a kuwo ngópu, Yesu u dyépi y꞉a mê ngmê knî ye mdoo ńuw꞉o ngópu, Yesu u yoo woni knî ye mdoo mye ńuw꞉o ngópu. ");
INSERT INTO yle_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yi pyópu knî yi vy꞉o pyââ pyile doo kwo, yi pi dmi Méli Makîdala pyââ ngmê, Njówana myomo, Méli Njems u pye pyolo. K꞉omo tpile yi pyópu knî y꞉oo dyépi knî ye yi kópu yilî mênê nté tumo, ");
INSERT INTO yle_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ngmênê dyépi yoo ye daa kêlîmî mbê dniye, yinê ye daa ndê kópu ye tpapê ngmê. ");
INSERT INTO yle_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ngmênê Pita ngê mbêpê a puwâ, kpomo chedê loo, yedê tepe mbê wo, Yesu ntóó p꞉uu kpîdîni t꞉ee tumo, vyîlo yi m꞉uu too, tpile daamu módu, wod꞉oo u p꞉aa pee mê diyé wo, yi kópu u nuw꞉onuw꞉o u ngwo ghê wo. ");
INSERT INTO yle_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yi Sandé ngê Yesu p꞉uu ndiye pyu miyó dê y꞉oo Njedusalem a kuwo ngópu, p꞉aa tp꞉oo ngmê yidpîmo lêpî, u pi Emeyîs, ntee daa kuughê dpîmo lêpî. (12 km.) ");
INSERT INTO yle_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kópuni yilî Yesu ngê pyaa dniye, maa p꞉uu yi p꞉uu dpîmo danêmbum. ");
INSERT INTO yle_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yi kópu knî yi p꞉uu dini ghi n꞉ii ngê dpîmo danêmbum, Yesu anya a pwiyé wo, yi kuwó doo kwo, dini ghi n꞉ii ngê a kp꞉anê doo, u k꞉ii nipi mîdnye paa. ");
INSERT INTO yle_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yi m꞉uu ngópu, ngmênê daa mya ngópu. ");
INSERT INTO yle_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu ye póó wo, yepê, Maa p꞉uu ló kópu p꞉uu dpo danêmbum mo? Wod꞉oo ghê knopwo, ndîdî yi ngîma kele, ");
INSERT INTO yle_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","u kwo ngmê póó wo, pini n꞉ii u pi Kliyópas, kwo, Njedusalem kópuni pyaa dniye, pi yintómu yi lama a pyede, mumdoo yi kópu knî ḻama daangma tóó? ");
INSERT INTO yle_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu ye póó wo, yepê, Ló kópu dé? Kwo, Yesu Nasalet pi ngê kópuni pyaa dniye. Kwo, Chóó Lémi u komo kapî pyu ngmê, mye u nuu u pi, mb꞉aamb꞉aa ngê dpîmo dêêpî, mbwudu yilî dpîmo chap, pi knî y꞉oo myednyimo chââchââ. ");
INSERT INTO yle_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kwo, Ngmênê nmî kada pini yoo, kpêê yiyé pyu yoo yi kada pini yoo yi k꞉ii, kî mgîmî ngópu, u vyee têdê dy꞉ââ ngópu, lede knî y꞉oo kîdosi ńedê u nkwo mî t꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","22","Kwo, Ngmênê alanté nmee nuw꞉o, Yisîléli tpémi yintómu knî yi k꞉ii nmî kada vyîlo ayi ghê, Lóma tpémi u ngwo wanmî ngm꞉ii kalê té. Kwo, Ala kópu m꞉uu, k꞉omo tpile m꞉ii tuwo a vya ngópu, ngmênê awêde nmî vy꞉o pyââ ngmê knî y꞉oo ghê nmî mênê dê ghipé ngmê, mw꞉aa mgîdî vy꞉o kpomo chedê kêdê lee dmi, ");
INSERT INTO yle_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ngmênê yi pini ntóó doo m꞉uu ngópu. Kwo, Nmo yedê diyé dmi, nmodê, Enjel miyó kudun꞉aa m꞉uu, yedê, Yi pini kîmêda pyidu. ");
INSERT INTO yle_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kwo, Nmî vy꞉o pi knî ngmê kpomo chedê myaa lee dmi, yi pyópu knî y꞉oo ntee nmo dumu nté ngmê, yinté myaan꞉aa m꞉uu ngmê, ngmênê yi pini ntóó doo m꞉uu ngópu. ");
INSERT INTO yle_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wod꞉oo Yesu ngê yepê, Lukwe dîy꞉o dpî mbodo dê dîngîdîngî dê. Yepê, Kópuni yilî Chóó Lémi u komo kapî pyu knî y꞉oo a d꞉êê tumo, lukwe dîy꞉o yi kópu knî ye dêdpîdê kêlîmî mo. ");
INSERT INTO yle_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, doo u ntââ yi dono u wépi daapî puwâ. Yepê, Yi dono u wépi wo puwâ, u dpodo ndêndê lónté pî dóó, u pi ndîî ngê lónté u nkwo pî pyodo. ");
INSERT INTO yle_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wod꞉oo kópuni puku yedê chóó p꞉uu ló dini a d꞉êê tumo, u kakêmê yilî ye chámê ngê, kn꞉ââ Mósisi ngê kópuni a d꞉êê too, nkoo Chóó Lémi u komo kapî pyu knî y꞉oo kópuni myedê d꞉êê tumo. ");
INSERT INTO yle_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","P꞉aani n꞉ii tp꞉oo dpîmo lêpî, y꞉i yimî taa dniye, yi tpódu ye yinê ye yi pini kn꞉aa p꞉aani doo lêpî, ");
INSERT INTO yle_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ngmênê yi tpódu y꞉oo u dî pwaa ngópu, kwo, Nakî nî, kââdî daa kêmakêma a wupwo. Kwo, Ṉg꞉ii dpî kmêle, wod꞉oo ngomo k꞉oo u k꞉ii nipi mê kee dniye. ");
INSERT INTO yle_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dini ghi n꞉ii ngê kmaapî têdê yaa dniye, mbîdédi a ngêêdî, Chóó Lémi kwuno ngê, yi puwâ, ye yi y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yi ngwo mb꞉êê yi ngîma a ngópu, apê, E, kî Yesu, ngmênê y꞉i anyi ye mê pwiyé wo. ");
INSERT INTO yle_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Noko kwo, Maa p꞉uu nyi gha dê kêdê pywálî knî, apii, kópuni puku yedê a pyede u kakêmê yilî nye kêdê chámê. ");
INSERT INTO yle_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yi ngwo dini ghi ngê yi tpódu ghêêdî knopwo, Njedusalem d꞉âmo mê diyé knopwo, Yesu p꞉uu ndiye pyu y꞉a mê ngmê, yi pyipe knî yi k꞉ii, ye yi taa knopwo, ");
INSERT INTO yle_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","yi tpóknî y꞉oo yepê, Nmî Lémi ndêndê ngê kêda pyidu, Saimon ngê kêdê m꞉uu. ");
INSERT INTO yle_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wod꞉oo yi tpódu y꞉oo yepê, Kîmyednye m꞉uu. Yepê, Moma u k꞉ii kudu lee dmi, dny꞉oo myââ. Yepê, Dini ghi n꞉ii ngê kmaapî têdê dpî yaa dmi, mbîdédi yi pwââ, u ngwo dnye mya. ");
INSERT INTO yle_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dini ghi n꞉ii ngê yi kópu p꞉uu dnye danêmbum, Yesu anya a pwiyé wo, yi vy꞉o ghê wo, yepê, Mw꞉ââkó a tîdê mbwó yoo, ala nê, namê nkîngê. ");
INSERT INTO yle_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ngmênê nkîngê ngê y꞉ay꞉a pwiyé dniye, apê ngmênê, Kmêna ye kwo. ");
INSERT INTO yle_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu ngê yepê, Lukwe dîy꞉o nmye nkîngê té. Yepê, Lukwe dîy꞉o dnyinté nmye kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yepê, A kêê yi ngî m꞉uu tóó, nmyi kêê dmi a p꞉uu yé yó, yepê, Ala nê vyîlo. Yepê, D꞉aa kmêna, myed꞉aa mbwee. Yepê, Kmêna mbwee yi mênê dînê daa kwo, yi p꞉uu mbyuu too daa t꞉a mo. ");
INSERT INTO yle_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yi kópu yi vyu, wod꞉oo kóó yu yi ngópu tpyé too. ");
INSERT INTO yle_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ngmênê doo u ntââ u kwo myedaapê kêlîmî mbê dniye, mu kópu u dîy꞉o yi gha dmi d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê pyodo, mye ngwéti dniye. Wod꞉oo ye póó wo, yepê, Nté pee nmyi ngópu ngma tóó, n꞉aa pîpî. ");
INSERT INTO yle_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Te mbyuu ch꞉ee ngmê u kwo ngmê y꞉ee ngópu, ");
INSERT INTO yle_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","yi kêlê a ngópu, yi ngópu ndîî. ");
INSERT INTO yle_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yesu u Mî ka ghêlî daa diyé wo, p꞉uu ndiye pyu yoo modoo ndiye kîgha dé, yepê, Dini ghi n꞉ii ngê nmyi vy꞉o munoo a kwo, a pwopwo p꞉uu munmyenîmo a danê. Yepê, Kópuni Mósisi ngê a p꞉uu a d꞉êê too, Chóó Lémi u komo kapî pyu knî y꞉oo myedê d꞉êê tumo, n꞉ii wéti u puku yedê mye pyede, doo u ntââ yi kópu dyuu daap꞉aa kn꞉aadi ngê. ");
INSERT INTO yle_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","U kuwó dini ghi ngê yi nuw꞉o dmi ńedê mb꞉êê a ngópu, apê, Puku yedê kópuni a pyede, pêdê w꞉ee téne. ");
INSERT INTO yle_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yi kópu yilî yi nt꞉u mu ngmidi, yi nt꞉u dmi alanté, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê dini ghi n꞉ii ngê wa t꞉a, wa mgîmî ngmê, wa vya ngmê, wa kmênê ngmê, wo pyoloni ngê amêdê pyidu, ");
INSERT INTO yle_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","u yoo knî y꞉oo u pi pi knî ye adnyin꞉aa tpapê, kn꞉ââ Njedusalem wa chaa ngmê, nkoo dyámê pê wopee wopee, n꞉ii knî y꞉oo u pi wa ny꞉ee ngmê, u pi mbêmê yi dono yilî wa kéé t꞉oo, Chóó Lémi ngê yi dono yilî mbodo kn꞉ââ vyuwo u nkwo wa kéé té, mêdaawa a ngî té. ");
INSERT INTO yle_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yesu ngê yepê, Yi kópu yilî nmyi chóó kînmyi m꞉uu tumo. Yepê, Pi knî ye dmyinên꞉aa tpapê dé, ");
INSERT INTO yle_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ngmênê n꞉ii ngê a d꞉aa amênê kââdî, mwiyé dmyinê t꞉âât꞉ââ, nmye anîmo dy꞉ââ. Yepê, Yi pini M꞉aa u Ghê Dmi, yinê amî wêdêwêdê kalê nmyo. Yepê, Mwiyé nmye munê vyu, nmyenê, M꞉aa ngê nmyi ngêêpî pyu nmye wa a dy꞉ââ. Yepê, Njedusalem ghêlî k꞉ii kêdmyinêngê kuwo ngmê, nmyi wêdêwêdê kîgha pyu mwiyé dmyinê t꞉âât꞉ââ. ");
INSERT INTO yle_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","U kuwó dini ghi ngê Yesu, p꞉uu ndiye pyu yoo yi kada ghê wo, Njedusalem a kuwo ngópu, Petani u nkîgh꞉ê yi taa dniye, wod꞉oo ghê dniye, kóó dê yi pwo mbee doo, yi l꞉êê dîy꞉o Chóó Lémi ka doo ngêpê. ");
INSERT INTO yle_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Dini ghi n꞉ii ngê yi l꞉êê dîy꞉o doo ngêpê, u Mî ngê a y꞉ângo, mbóó p꞉uu kmungo. ");
INSERT INTO yle_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wod꞉oo p꞉uu ndiye pyu yoo Njedusalem mê diyé dniye, yi gha dmi maa p꞉uu d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê pyodo, ");
INSERT INTO yle_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","wo yintómu Chóó Lémi u ngomo k꞉oo dnyimon꞉aa koko, Chóó Lémi dnyimon꞉aa chaa kîgha. Wu u dî. ");
INSERT INTO yle_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mwiyémwiyé dini ghi ngê, nmî Kêlî Pini doo ya. Yi pini nmî Mî Tp꞉oo, nmî Mî nmo yinê a kêma ngê. Nmî Mî k꞉ii dpîmo ya, yi gha ngmidi ngê doo ya. ");
INSERT INTO yle_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dyámê pê ghêlî daangê l꞉âmo ngê, ngmênê nmî Mî k꞉ii nipi dpîmo ya. ");
INSERT INTO yle_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tpile yilî yintómu nipi l꞉âmo ngópu, wu tpile Kêlî Pini k꞉ii daa l꞉âmo ngópu, daa tóó. ");
INSERT INTO yle_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kêlî Pini Ghê Njini u Kn꞉ââ, kamî ngê yinê dpî pyódu nmo. Yi Ghéni Kn꞉ââ nmî pywápê ngê vyîlo yi pyodo. ");
INSERT INTO yle_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yi pywápê ngê mgîdî yinê chópu. Mgîdî dêê wo, yi pywápê daa nt꞉ââ ngê. ");
INSERT INTO yle_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Yi pywápê, nmî Mî Tp꞉oo. Ghêlî daa ta, u mdoo tpapê pyu ngmê Chóó Lémi ngê a ngmidi ngê, nmo a dy꞉ââ ngê. Yi pini u pi Njon Baptist. Pi knî ye yi pywápê p꞉uu doon꞉aa danêmbum, mu kópu u dîy꞉o apê, Pi yintómu u kwo paa kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Chóó vyîlo daa pywápê, ngmênê pywápê p꞉uu pi knî ye doon꞉aa danêmbum. ");
INSERT INTO yle_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Pywápê njini p꞉uu ye doon꞉aa danêmbum. Pi yintómu yi l꞉êê dîy꞉o yi pywápê dyámê mbêmê doo a lêpî. ");
INSERT INTO yle_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nyââ, nmî pywápê dyámê mbêmê doo ya, dyámêni Chóó Lémi k꞉ii l꞉âmo ngópu, ngmênê yi dyámê tpémi y꞉oo daa mya ngópu. ");
INSERT INTO yle_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Chóó u dyámê pee p꞉uu a loo, chóó u yoo y꞉oo u wépi pwaa ngópu. ");
INSERT INTO yle_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngmênê ngmê knî y꞉oo daa mb꞉ii ngópu, u kwo kêlîmî mbê dniye. Yi yéli Chóó Lémi tp꞉oo módó tp꞉oo mââ ngê pyódu too. ");
INSERT INTO yle_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Daa pi ngê yinté pyódu too, daa yi chóó Chóó Lémi u yoo vy꞉o ghê dniye, ngmênê Chóó Lémi ngê chóó tp꞉oo módó tp꞉oo mââ ngê pyódu too. ");
INSERT INTO yle_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kêlî Pini pi ngê pyodo, nmî vy꞉o doo kwo. Ala kópu nmo w꞉ee ngê, Kî nmî Mî Tp꞉oo mu ngmidi. Nmî ngêêpî pyu ndîî, u kópu yintómu ndê kópu dé. ");
INSERT INTO yle_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nmî Kêlî Pini pi ghêlî daa myââ, Njon Baptist yi pini p꞉uu nmo doo danêmbum. Pi knî yi k꞉ii dpodombiy꞉e nmo mbwolo, nmopê, Pini n꞉ii p꞉uu nmye noo danêmbum, munmyenê, A kuwó wunê kwo, nmopê, yi pini a kada pini ngê a tóó, mu kópu u dîy꞉o ghêlî dîpîngê ta, ngmênê yi pini dye ghi yintómu doo a ya. ");
INSERT INTO yle_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nmo yintómu kópu mb꞉aa yilî Kêlî Pini ngê nmo wunê d꞉uud꞉uu. Kópu mb꞉aa nmo daangmê w꞉êê ngê. ");
INSERT INTO yle_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mósisi ngê kópu mb꞉aa ngmê d꞉uu ngê, Chóó Lémi u dêêpî kópu dyuu nmo a ńuwo, ngmênê Yesu Kédisu ngê daa yintoo kópu yi d꞉uu ngê, kópu ndîî yi d꞉uu ngê. Yesu ngê Chóó Lémi u módó yeedeyeede ndîî nmo a kpo, u Mî ka maa njini u ngwo a yó. ");
INSERT INTO yle_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Pi ngê Chóó Lémi doo u kpêê. Chóó Lémi Tp꞉oo mu ngmidi, pini n꞉ii u nuu ghi Chóó Lémi nódo a tóó, Chóó Lémi nmî nuw꞉o yinê kwólu. ");
INSERT INTO yle_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Dini ghi n꞉ii ngê Njon Baptist mbwaa ndîî Njódan u nkîgh꞉ê doo dpodo, Nju tpémi yi kada pini yoo yi nuw꞉o dmi alanté pyodo, apê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, ndoo apê wu vyîlo. Yi kópu u l꞉êê dîy꞉o Chóó Lémi u ngomo k꞉oo dpodo pyu knî ngmê u kwo a dy꞉ââ tumo, yepê, U kwo nye póó dmyeno, kwipi, Nyi n꞉uu? ");
INSERT INTO yle_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Njon Baptist ngê yepê, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, ndêndê ngê d꞉aa vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kwo, Chóó Lémi ngê wunê kópuni a vyu, apê, Ilacha dîyo dyámê mbêmê amêdê diyé, yi kópu vyîlo yichi ntiye? Yepê, D꞉aa vyîlo. Kwo, Mósisi pini n꞉ii p꞉uu nmî kn꞉ââ knî ye doo a danêmbum, yepê, Chóó Lémi ngê pi ngmê wa a ngmidi, komo yinê adîn꞉aa kapî, kwo, lukwe, nyi vyîlo? Yepê, Kêle. ");
INSERT INTO yle_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kwo, Pini n꞉ii knî y꞉oo a dy꞉ââ nmoo, módó ye mêdaanmî diyé dmi. Kwo, Ṉgakêmê ṉ́yóó nmo mê chámê ngi. ");
INSERT INTO yle_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Njon Baptist ngê yepê, Yisaya ngê ala kópu mwo a d꞉êê ngê, yepê, W꞉amî mbêmê pi ngma adî kââ, yewo, Nmî Lémi u maa mb꞉aamb꞉aa ngê a yé yó. Njon Baptist ngê yepê, Yi kópu vyîlo yinî ntiyentiye. ");
INSERT INTO yle_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Yélini Pádisi knî y꞉oo u kwo a dy꞉ââ tumo, yi yéli y꞉oo kwo, D꞉ii nmî Lémi, d꞉ii Ilacha, d꞉ii Chóó Lémi u komo kapî pyu. Kwo, Lukwe dîy꞉o pi yilî mbwaa paa nye kmênêkmênê? ");
INSERT INTO yle_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Njon Baptist ngê yepê, Yoo mbwaa ngê mun꞉aa mbápitisîm kîgha too, ngmênê yi dpodo daa ndîî, têdê. Yepê, Nmî Lémi nmî vy꞉o ka kwo, ngmênê dmyongê mya ngópu. ");
INSERT INTO yle_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yepê, K꞉omo tpile u kada d꞉a ghê, ngmênê nê têdê. Yepê, N꞉ii a kuwó wunê kwo, u pi ndîî. Yepê, Doo u ntââ u nkîgh꞉ê daanî nî. ");
INSERT INTO yle_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yi kópu yintómu Petani pyodo, daa Njedusalem u nkîgh꞉ê p꞉aani n꞉ii a tóó, ngmênê Njódan mwada mbwááni pee Petani, Njon Baptist ngê mbwaa paa yoo kwéli doo kmênêkmênê dé, yi Petani. ");
INSERT INTO yle_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Womumo Njon Baptist ngê Yesu yi módu, nmopê, Ó. Kî pini kîyedê pwiyé knî, pini n꞉ii p꞉uu nmye noo danê. Nmopê, Sipi tp꞉oo n꞉ii Chóó Lémi ngê nmo a kpo, kî vyîlo. Nmopê, Pi ngê chóó u dono u l꞉êê dîy꞉o sipi tp꞉oo ntee dpî vy꞉a, kî pini yinté sipi tp꞉oo ngê wa pyódu, pi knî y꞉oo wa vya ngmê. Nmopê, Dyámê mbêmê tpémi nmo yintómu nmî yikî dmi u pwo wa ghay. ");
INSERT INTO yle_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nmopê, Pini n꞉ii p꞉uu nmye noo danêmbum, vyîlo nmye kîyedê pwiyé knî. Nmopê, Munmyenê, A kuwó kîyedê kwo, ngmênê a kada pini ngê a tóó, mu kópu u dîy꞉o ghêlî dîpîngê ta, ngmênê yi pini dye ghi yintómu doo a ya. ");
INSERT INTO yle_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nmopê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, ghêlî dîpî módu, Yisîléli tpémi ye noo danêmbum, mbwaa paa myenoo kmênêkmênê dé, mu kópu u dîy꞉o nê, Yi ngwolo dmi paa pywálî y꞉e, yi pini paa mya y꞉e. ");
INSERT INTO yle_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Nmopê, Chóó Lémi ngê a dpodo dini ghi n꞉ii ngê a ka a kpo, a ka pê, Mu dini ghi ngê a Ghê Dmi wanyi m꞉uu, pi ngmê u pwo wa ghîî, p꞉uu adî ya. A ka pê, Yi pini ngê a Ghê Dmi mbêmê yoo yi gha dmi wa ghêê té. Njon Baptist ngê nmopê, Kî pini nmye vyîlo, Chóó Lémi u Ghê Dmi mbóó p꞉uu a ndê wo, vy꞉êmê k꞉ii ntee tpile ngê u pwo a gho, mbêmê doo kwo. ");
INSERT INTO yle_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nmopê, Yi kópu ndêndê ngê kînî módu. Nmopê, Ala kópu ny꞉ee yó, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, kî vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Womumo Njon Baptist u k꞉ii y꞉i nmee ya, p꞉uu ndiye pyu ngmê mye u k꞉ii. ");
INSERT INTO yle_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesu paambwi têdê nmî módu, Njon Baptist ngê nyepê, Sipi tp꞉oo n꞉ii Chóó Lémi ngê nmo a kpo, kî vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Dini ghi n꞉ii ngê nyi nyongo, Njon Baptist nyinê kuwo ngê, Yesu nyi ngm꞉êê ngê. ");
INSERT INTO yle_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu nye mênê diyé wo, nyepê, Lukwe u pyinê dpo ngmêê ngmê? Kwonyenê, Mââwe. Kwonyenê, Ló y꞉i nyinê tóó? ");
INSERT INTO yle_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nyepê, A pwiyé choo, anye m꞉uu nyoo. Wod꞉oo nyi ngm꞉êê ngê, kwéli doo a ya, yi ghi ny꞉uu módu. Ntumokwodo nmî lee dniye, wo y꞉i nm꞉uu chedê ngê. ");
INSERT INTO yle_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Pini n꞉ii k꞉ii Yesu nyi ngm꞉êê ngê, u pi Andru, Saimon Pita u mbwó. ");
INSERT INTO yle_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yi ngwo Andru ngê u mbwó até yedê pyw꞉ângo, kwo, Kédisu kîdnyinê pyw꞉oo. (Kédisu u nt꞉u kópu, Chóó Lémi ngê pini n꞉ii a ngmidi ngê.) ");
INSERT INTO yle_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andru ngê u mbwó Saimon Yesu ka adê ńuw꞉o. Yesu ngê até doo y꞉enê, kwo, Nyi Saimon, Njon tp꞉oo, ngmênê m̱i dî nt꞉ââ, Pita. (Pita u nt꞉u kópu, chêêpî kpiyé.) ");
INSERT INTO yle_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Womumo Yesu ngê u yi doo kwo, Nkálili nî lê. Pilipi ada pyw꞉oo, kwo, A ngm꞉êê nédi. ");
INSERT INTO yle_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Pilipi Mbetîsaida pi, Andru mbwémi Pita yi k꞉ii yi p꞉aa mu ngmidi.) ");
INSERT INTO yle_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipi ngê Nêtániyel ada pyw꞉oo, kwo, Mósisi pini n꞉ii p꞉uu doo a d꞉êê, yi pini kîdp꞉o pyw꞉oo. Kwo, Chóó Lémi u komo kapî pyu yoo p꞉uu myednya a d꞉êê. Kwo, Yi pini Yesu, Njósép tp꞉oo, Nasalet pi. ");
INSERT INTO yle_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nêtániyel ngê kwo, Doo u ntââ. Kwo, Yintoo pini Nasalet daawa chaa. Pilipi ngê kwo, A pwiyé, ṉ́yóó anyi mwini. Wod꞉oo Yesu ka adî lee knî. ");
INSERT INTO yle_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu ngê Nêtániyel yi módu, nmopê, Daa dnyinté Yisîléli pi ngmêkîyedê pwiyé knî, k꞉omodanê pee tp꞉oo p꞉uu daa t꞉a. ");
INSERT INTO yle_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nêtániyel ngê yi kópu yi nyongo, Yesu ka kwo, Lónté ḻama n꞉aa tóó? Yesu ngê kwo, Pilipi ngê ghêlî doon꞉aa pyw꞉ee nyoo, dini ghi n꞉ii ngê yi km꞉ee nyinê ngêpê, a nuw꞉o k꞉oo d꞉a pyw꞉ee ngi, a lama u ngwo chi yââ. ");
INSERT INTO yle_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nêtániyel ngê kwo, A Lémi. Kwo, Nyi Chóó Lémi Tp꞉oo, Yisîléli tpémi yi k꞉ii nyi nmî king. ");
INSERT INTO yle_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu ngê kwo, Kópuni ṉga dî vyi, yi km꞉ee ngêpê têdê mudî m꞉uu ngi, yi kópu u dîy꞉o mumdoo a ka che kêlîmî mb꞉anê? Kwo, Yi kópu têdê. Kwo, Dîyo ndîî kópu knî wanyi m꞉uu té. ");
INSERT INTO yle_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nmopê, Ndê kópu nmye ngmên꞉aa tpapê. Nmopê, Nê Chóó Lémi u Pi Ndêndê. Nmopê, Njakóp ngê máádini a wâdîvyîngo, enjel knî y꞉oo mudnye vy꞉eevy꞉ee ńuw꞉ońuw꞉o, yi máádi ntee máádi ngê wanî pyódu. Nmopê, Chóó Lémi ka u ngwo wanê kââdî nmyo. Nmopê, Yi kópu wanmyinê w꞉ee ngmê, ndê kópu ngê nmye wa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wo miyó mî loo, yééyéé u naa Kéna u ngwo ngmê kê ngópu, p꞉aani n꞉ii Nkálili Wee u kwo a tóó. Yesu u pye yi nááli têdê mî ta. ");
INSERT INTO yle_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Pi knî y꞉oo Yesu u k꞉ii myemînê dóó kalê nmoo, u ngwo nm꞉uu taa dniye. ");
INSERT INTO yle_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yi nááli têdê wain chedê ngópu, Yesu u pye ngê tp꞉oo ka kwo, Wain u ndanî ngê kêdê chedê ngmê. ");
INSERT INTO yle_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu ngê kwo, Mw꞉ââkó Niye. Kwo, A pi lukwe dîy꞉o yenté chi vyi? Kwo, A wêdêwêdê u mumu u dye ghi doongê yó. ");
INSERT INTO yle_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesu u pye ngê naa u dpodo pyu knî ye yepê, Kópuni nmye a tpapê, dpî d꞉uu yó. ");
INSERT INTO yle_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mbwaa d꞉ââ ndîî y꞉i wéni doo kwo, pi knî y꞉oo yi dêêpî kópu dyuu u l꞉êê dîy꞉o yi kêê dmi kwéli dnyimo ghêêghêê dé. Yi d꞉âmu ndîî dé chêêpî ngê l꞉âmo tumo, mu daa mu tp꞉oo k꞉omo dé. ");
INSERT INTO yle_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu ngê naa u dpodo pyu knî ye yepê, Kî d꞉âmu mbwaa ngê ntówo tóó, wod꞉oo d꞉ud꞉umbiy꞉e a nt꞉ee tumo. ");
INSERT INTO yle_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yepê, Yi mbwááni knî ngma a vy꞉êê yó, naa u kada pini ka ńuw꞉o yó, amî d꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yi mbwááni tpalê wo, wain ngê pyodo. Dpodo pyu knî y꞉oo naa u kada pini ka knî ngmê ńuw꞉o ngópu, yi d꞉uu ngê, apê, Wain mb꞉aa ala. U lama dêpwo ya, Ala wain anye da pwiyé, ngmênê dpodo pyu n꞉ii knî y꞉oo a vy꞉êê ngópu, yi lama doo ya. ");
INSERT INTO yle_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Naa u kada pini ngê naa chóó ka kwo, A pwiyé. Kwo, Ala wain até dî d꞉uu, mb꞉aamb꞉aa. Kwo, Kópu kamî ngmêchi d꞉uu. Kwo, Pi ngmudu yéé, u pyipe knî ye wain mb꞉aa ye mwiyé dpî y꞉oo, n꞉ii pee tp꞉oo mb꞉aamb꞉aa kuwó ye dpî y꞉oo, mu kópu u dîy꞉o yi dini ghi ngê d꞉uuwodê w꞉ee ngmê, yinê ye lónté wain yuno ndanî. Kwo, Ngmênê yinté chuu d꞉uu ngê. Kwo, Wain n꞉ii d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa kuwó nmo cha kê. ");
INSERT INTO yle_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu ngê u mwiyémwiyé mbwudu yinté chópu, u wêdêwêdê u l꞉ii yinté nmî módu. Yinté nmo w꞉ee ngê, nê, Kî Chóó Lémi Tp꞉oo. U ngwo u kwo nmî kêlîmî mbê dniye. Yi kópu Kéna pyodo, p꞉aani n꞉ii Nkálili Wee u kwo a tóó. ");
INSERT INTO yle_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","U kuwó dini ghi ngê Yesu u pye ghee knî yi k꞉ii Kîpêêniyêm nmî lee dniye, wo knî ngmê y꞉i nmeen꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nmî naa ndîî, Tp꞉ee Kaa W꞉êêw꞉êê u Wo, daa kêmakêma doo dyimêdyimê, wod꞉oo Yesu u k꞉ii Njedusalem nmî lee dniye. ");
INSERT INTO yle_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chóó Lémi u ngomo k꞉oo nmee koko, yi ngomo mbwa kalê ngmê k꞉oo nmî kee dniye. Kwéli nmî kee dniye, yélini daa Nju tpémi, u ntââ Chóó Lémi ka y꞉i pêdyimo ngêpê. Yi kêlî ghê pi yilî nmî módu, nê, Pi knî y꞉oo tpile tp꞉oo mu pywupwi t꞉oo. Nê, Kpêê yiyé u l꞉êê dîy꞉o pudumakó, sipi, ndêêdî mu pywupwi t꞉oo, nê, kn꞉aa dyámê ndapî nmî ndapî ngê mye ngmêêpî t꞉oo. Yesu ngê yi m꞉uu too, doo u nuu u kópu ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesu ngê yedê kpê dmi ngmê l꞉âmo ngê, tpile tp꞉oo yintómu u ngwo ngm꞉ii kalê too, pudumakó sipi yintómu Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo pw꞉ii too. Yélini knî y꞉oo ndapî dnye ngmêêpî dé, yi tépîl ye tpaa too, yi ndapî tpii yi kpópu. ");
INSERT INTO yle_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","N꞉ii knî y꞉oo pywupwi u ńmê tp꞉oo a ńuw꞉o tumo, Yesu ngê yepê, Ye ńmeni tp꞉oo mye pw꞉ii tóó. Yepê, M꞉aa u ngomo lukwe dîy꞉o tpile tp꞉oo u pywupwi u ngomo ngê nmyi pyódu ngópu? ");
INSERT INTO yle_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Chóó Lémi ngê pini n꞉ii a ngmidi ngê u kópu dyuu n꞉ii puku yedê a kwo, yi kópu y꞉i nm꞉uu nuw꞉o kwólu. Ala yi kópu, A Lémi, ṉgomo a nuu u ngomo. Pi ngê wa dyênê, ndyuw꞉e k꞉ii ntee tpile a gha vy꞉o wa dnyapwi. ");
INSERT INTO yle_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nju tpémi yi kada pini yoo Yesu ka póó dniye, kwo, Ye kópu lukwe dîy꞉o chi d꞉uu? Kwo, Lóntoo mbwudu ngmanyi chaa, u ngwo anmo w꞉ee, Chóó Lémi ngê nyi vyîlo yedê ngmidi nyoo? ");
INSERT INTO yle_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu ngê yepê, Ala Chóó Lémi u ngomo anmyinê pw꞉oo ngmê, wo pyile amî lê, u ngwo am꞉aa wó. ");
INSERT INTO yle_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kwo, Nye k꞉om. Kwo, Wo pyile k꞉oo mêdaanyi wó. Kwo, Ḻama daa tóó nmee wuwó, m꞉ââ podoy꞉a mê wéni. ");
INSERT INTO yle_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kópuni Yesu ngê ye vyu, dêpê w꞉ee ngópu. Daa ngomo p꞉uu ye doo danê, chóó p꞉uu ye doo danê. ");
INSERT INTO yle_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesu dini ghi n꞉ii ngê kpêênî a pii wo, u kópu yi ngwo nm꞉uu nuw꞉o kwólu, Chóó Lémi u komo kapî pyu yoo yi kópu ka nmî kêlîmî mbê dniye, Yesu ka my꞉oo kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tp꞉ee Kaa W꞉êêw꞉êê u Naa dye ghi ngê, Njedusalem dini ghi n꞉ii ngê nmee ya, Yesu ngê mbwudu yilî chópu, pi yilî u ngwo u kwo kêlîmî mbê wo. ");
INSERT INTO yle_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ngmênê Yesu ngê p꞉uu daa t꞉ee too, mu kópu u dîy꞉o apê, Kî yéli y꞉oo a dpodo doongê w꞉ee ngópu, apê, daa a nuu u maa p꞉uu wa kaa nê. ");
INSERT INTO yle_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yesu u lama pi yintómu yi gha dmi doo ya. K꞉omo tpile pi ngê Yesu ka yoo yi kakêmê dmi daa chámê ngê, ngmênê yi l꞉êê ghi dmi u lama doo ya. ");
INSERT INTO yle_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nju tpémi yi kada pini ngmê, u pi Nikódimês, mye Pádisi knî yi vy꞉o pini ngmê. ");
INSERT INTO yle_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mgîdî ngmê ngê Yesu ka a loo, kwo, Mââwe. Kwo, Nmî lama ka tóó Chóó Lémi ngê lama kîgha pyu ngê a pyódu nyoo. Kwo, Mbwudu n꞉ii nye chapî té, yinté kópu pi ngê módó daawa d꞉uu, ngmênê Chóó Lémi ngê wa a ngee, yinté kópu u ngwo wa d꞉uu té. ");
INSERT INTO yle_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu ngê kwo, Ndê kópu ṉga ngmên꞉aa tpapê. Kwo, N꞉ii myombó mêdaawa pyódu, yini Chóó Lémi kóó k꞉oo daawa ghê. ");
INSERT INTO yle_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikódimês ngê kwo, Pini n꞉ii dpî k꞉aa, angênté amê pyódu? Kwo, Doo u ntââ pi u pye u mênê mêdaawa kee, yinté mêdaawa t꞉aa. ");
INSERT INTO yle_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu ngê kwo, Ndê kópu ṉga yinî tpapê, Chóó Lémi kóó k꞉oo pi módó daawa ghê. Kwo, Pi cha y꞉oo tp꞉ee kamî ntee dpî tpyé ngmê, Chóó Lémi u Ghê Dmi ngê pini n꞉ii kamî ngê yinté dpî pyódu, vyîlo yi pini Chóó Lémi kóó k꞉oo ayi ghê. ");
INSERT INTO yle_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kwo, Pyââ ngê pi ntee pini yu tpyé, ngmênê Chóó Lémi u Ghê Dmi ngê pini n꞉ii moo pyódu, yi pini u nuw꞉o dpî ngmêê. ");
INSERT INTO yle_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kwo, Yi kópu u l꞉êê dîy꞉o ṉga dê vyi, ṉgadê, Moo pyaa dmyeno. Kwo, Yi kópu lukwe dîy꞉o kópu kamî ngê ṉga dê pyódu? ");
INSERT INTO yle_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kwo, Yópu wunê wupe, chóó u nuw꞉o u pono a vyápê. Kwo, U dnye anyi ny꞉oo, ngmênê daanyi m꞉uu. Kwo, Chóó Lémi u Ghê Dmi mye yinté. Kwo, Ḻama daa tóó pi kamî ngê lónté dpî pyódu. ");
INSERT INTO yle_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikódimês ngê kwo, Yinté kópu lónté dpî pyódu? ");
INSERT INTO yle_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu ngê kwo, Nyi Yisîléli tpémi yi ndiye kîgha pyu ngmê. Kwo, Lukwe dîy꞉o choongê w꞉ee ngê? ");
INSERT INTO yle_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kwo, Ndê kópu ṉga yinî tpapê, kópuni nmye nmo tpapê té, ndêndê ngê vyîlo nmî lama ye pyede, vyîlo myey꞉uu m꞉uu too, ngmênê nmî kópu dyuu ka dp꞉ee kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kwo, Dyámê mbêmê kópu knî yi p꞉uu a ka dp꞉ee kêlîmî té. Kwo, Chóó Lémi u kópu knî yi p꞉uu angênté a ka anmyinê kêlîmî mbê dmi? ");
INSERT INTO yle_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kwo, Pi Chóó Lémi ka doongmê n꞉ee, myedoongmê diyé wo, kwo, ngmênê pi mu ngmidi u kwo a ndê wo, pini n꞉ii u Pi Ndêndê. ");
INSERT INTO yle_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Kwo, Mósisi ngê yoo yi pyipyi u l꞉êê dîy꞉o nkéli chêêpî tpile pê tââ ntee a t꞉ângo, Chóó Lémi u Pi Ndêndê tââ yinté wamye t꞉ee ngmê, mu kópu u dîy꞉o pini n꞉ii u kwo adê kêlîmî, u nuw꞉o kamî ngê paa pyaa we, ghê kamî pêdê pyw꞉ee ngê, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dyámê mbêmê tpémi yi nuu ghi dmi Chóó Lémi nódo dnyinté daa tóó, wod꞉oo chóó Tp꞉oo mu ngmidi nmo a kpo, mu kópu u dîy꞉o n꞉ii u kwo adî kêlîmî, daawa dyênê, u nuw꞉o kamî ngê wa pyódu, ghê kamî wamyedê pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chóó Lémi ngê Tp꞉oo daa nmî kpadakpada u l꞉êê dîy꞉o a dy꞉ââ ngê, ngmênê nmî Mbwámê ngê a pyódu ngê. ");
INSERT INTO yle_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pini n꞉ii u kwo adî kêlîmî, Chóó Lémi ngê daawa kpada. Pini n꞉ii u kwo daa kêlîmî, yi pini ngê u kpadakpada ye t꞉âât꞉ââ, mu kópu u dîy꞉o Chóó Lémi Tp꞉oo mu ngmidi u wépi puwâ, u kwo daa kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yi kpadakpada yi chóó a pyw꞉ee ngópu, mu kópu u dîy꞉o dyámê u pywápê u wépi pwaa ngópu. Chóó Lémi ngê nmî pywápê nmo a dy꞉ââ ngê, nmî vy꞉o a kwo, ngmênê pi knî y꞉oo mgîdî u yi y꞉e mê kwo, mu kópu u dîy꞉o dono a d꞉uud꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","N꞉ii ngê dono kópu a d꞉uud꞉uu té, pywápê u kwo dpî diy꞉a, u wo d꞉uudpî nî, dpo, A dono kópu a p꞉uu angmê m꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","N꞉ii ndê kópu dyuu u pono a vyápê yédi, pywápê u wo dpo lê, dpo, Pi knî y꞉oo pêdê w꞉ee y꞉e, awo, Chóó Lémi ngê nê wunê ngêêpî, kópu mb꞉aa u ngwo a d꞉uud꞉uu té. ");
INSERT INTO yle_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","U kuwó dini ghi ngê Yesu u k꞉ii Njedusalem nmo kuwo ngê, Njuda Wee u kwo nmeen꞉aa ya, mbwaa paa yoo nmee kmênêkmênê dé. ");
INSERT INTO yle_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Njon Baptist Enon doo ya, Sálim u nkîgh꞉ê, Samédiya Wee u kwo, mbwaa paa myedoo pi kmênêkmênê, mu kópu u dîy꞉o mbwaa y꞉i yilî doo ya. ");
INSERT INTO yle_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yi ngwo Njon Baptist mbwa k꞉oo ghêlî daa kee wo. ");
INSERT INTO yle_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Wo ngmê ngê Nju pi ngmê Njon Baptist p꞉uu ndiye pyu knî yi k꞉ii noko dnye kwopwepe. Yi Nju pi ngê yepê, Mbwaa paa pi kmênêkmênê n꞉ii nmye kîgha ngmê, yini ngê Chóó Lémi ka pi mb꞉aamb꞉aa ngê dnyinté a pyépi. Yepê, Yesu ngê n꞉ii a d꞉uud꞉uu, yini yi mb꞉aamb꞉aa. ");
INSERT INTO yle_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wod꞉oo Njon Baptist p꞉uu ndiye pyu yoo yi kada pini ka lee dniye, kwo, Mââwe. Kwo, Pini n꞉ii Njódan mwada pee nmo nyinê kêma ngê, mu nmo nye vyu, nye, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, wu vyîlo, kwo, Lukwe dîy꞉o yi pini myeka pi kmênêkmênê, pi yintómu u kwo ka lêpî té. ");
INSERT INTO yle_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Njon Baptist ngê yepê, Pi ngê kópu u mo daawa d꞉uu, Chóó Lémi ngê yinê dpo ngee, yi kópu u ngwo dpî d꞉uu. Yepê, Chóó Lémi ngê yi pini wunê ngêêpî, yoo u kwo a lêpî té. ");
INSERT INTO yle_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yepê, Nmyi ngêêdî pi knî ye munê vyu, yenê, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, d꞉aa vyîlo. Yepê, U maa yiyé u l꞉êê dîy꞉o u kada nê ghê wo. ");
INSERT INTO yle_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Njon Baptist ngê p꞉uu ndiye pyu knî ye mgongo ngmê kwólu, yepê, Pini n꞉ii dpî yéé, pyââ u kwo dpî lê, u mbwó ka d꞉uudpî nî, ngmênê u mbwó u gha mb꞉aamb꞉aa ngê dpî pyódu. Yepê, Kópuni a ka dmyi vyi ngmê, yi kópu u dîy꞉o a gha d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê dê pyódu. ");
INSERT INTO yle_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yepê, Yi pini u pi ndîî ngê choo pyodopyodo, a pi têdê ngê choo a pyodopyodo. ");
INSERT INTO yle_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Pini n꞉ii Chóó Lémi ka a ndê wo, u pi ndîî, nmo têdêtêdê dé. Nmo dyámê mbêmê tpémi, dyámê mbêmê nmî pyaa dniye, dyámê u kópu knî yi p꞉uu nmo danê té. Chóó Lémi ka pini n꞉ii a ndê wo, nmo yintómu nmî pwo a tóó. ");
INSERT INTO yle_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kópuni a m꞉uu too, kópuni a ny꞉ee too, nmo vyîlo ye tpapê té, ngmênê pi knî y꞉oo yi kópu daa nyêmî ngmê. ");
INSERT INTO yle_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","N꞉ii knî y꞉oo u kópu a nyêmî ngmê, u nuu u kópu dé ye d꞉uud꞉uu t꞉oo, pi knî y꞉oo u ngwo dpo w꞉ee ngmê, apu, Chóó Lémi u kópu dyuu p꞉uu k꞉omodanê pee tp꞉oo daa t꞉a mo daa t꞉a. ");
INSERT INTO yle_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pini n꞉ii Chóó Lémi ngê nmo a dy꞉ââ ngê, Chóó Lémi u kópu dyuu yedoon꞉aa tpapê, mu kópu u dîy꞉o Chóó Lémi ngê u Ghê Dmi d꞉ud꞉umbiy꞉e u kwo a y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","U Mî nódo Tp꞉oo nuu ghi a tóó, tpile yintómu u kada pini ngê a pyódu ngê. ");
INSERT INTO yle_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yélini Tp꞉oo ka a kêlîmî nyédi, yi nuw꞉o dmi kamî ngê dpî pyódu, ghê kamî dpo pyw꞉ee ngmê, ghéni n꞉ii chedê ngê daawa pyódu. Yélini Tp꞉oo ka daa kêlîmî té, u dnye daa nyêmî ngmê, yi yéli yi nuw꞉o dmi kamî ngê daawa pyaa dmi, ngmênê Chóó Lémi ngê adî kpadakpada dé. Yi kpadakpada chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Dini ghi n꞉ii ngê yoo mbwaa paa nmee kmênêkmênê dé, Pádisi knî y꞉oo ala kópu ny꞉ee ngópu, apê, Pi yilî Yesu p꞉uu ka ndiye té, mbwaa paa yinê a kmênêkmênê té, ngmênê Njon ka pi mdoo daa lêpî. ");
INSERT INTO yle_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pi knî y꞉oo mdoo dnyinté ye ńuw꞉o ngópu. Yesu ngê pi mbwaa paa dêpwo kmênêkmênê dé, ngmênê yélini yi k꞉ii Yesu p꞉uu nmee ndiye, nmî chóó nmee kmênêkmênê dé. ");
INSERT INTO yle_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu u lama dini ghi n꞉ii ngê yaa wo, apê, Pádisi knî y꞉oo ala kópu dê ny꞉ee ngmê, Yesu ka pi yilî a lêpî, wod꞉oo Njuda Wee nmo kuwo ngê, Nkálili Wee u kwo m꞉oo diyé dniye. ");
INSERT INTO yle_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","K꞉omo tpile Nju tpémi Samédiya tpémi noko dnye diya, ngmênê Samédiya máádi nm꞉uu kwólu. ");
INSERT INTO yle_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samédiya Wee u kwo, p꞉aa ngmê u pi Saika. Yi p꞉aani ghêlî dpîpî nî dniye, têpê ghi ngmê mbêmê nmî taa dniye, têpê ghini nmî kn꞉ââ Njakóp ngê tp꞉oo Njósép ka wunê a y꞉ângo. Kââdî mââ kêlî dini ghi ngê y꞉i nmî taa dniye. ");
INSERT INTO yle_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Njakóp ngê mbwaa mgî n꞉ii chó, y꞉i nmî módu. Yi mgini k꞉oo mbwaa p꞉ââ y꞉i dpîmo a ya, Samédiya tpémi y꞉oo mbwaa y꞉i dnyimo a vy꞉êmî. Yesu ka paa diya wo, wod꞉oo yi mgini u nkîgh꞉ê yaa wo. Yesu y꞉i nmo kuwo ngê, Saika nté pywupwi têdê nmî lee dniye. ");
INSERT INTO yle_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Nté pywupwi têdê nmeen꞉aa ya, nmî kuwó Saika pyââ ngmê mbwaa vy꞉êmî têdê loo. Yesu yi mgini u nkîgh꞉ê módu, yi pyópu ka kwo, Mbwaa knî a ka ngma a ki. ");
INSERT INTO yle_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yi pyópu ngê kwo, Nyi Nju pi, nê Samédiya pyââ, mumdoo mbwaa a ka chi dmyinê? Yi kópu u kwo vyu, mu kópu u dîy꞉o Samédiya tpémi y꞉oo tpileni k꞉oo mbwaa dpî nda ngmê, Nju tpémi y꞉oo y꞉i d꞉uudpî nda ngmê, mu kópu u dîy꞉o yinê ye tupwótupwó dé. ");
INSERT INTO yle_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu ngê mgongo u kwo ngmê kwólu, kwo, Kópuni Chóó Lémi ngê módó ṉga wa a kê, yi kópu ḻama waa yââ, wuchimye mya nê, ye yi kópu a ka pîchi dmyinê, mbwááni n꞉ii ghê a t꞉a, yi mbwááni ṉga pîd꞉a kê. ");
INSERT INTO yle_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yi pyópu ngê kwo, Mââwe. Kwo, Mbwaa vy꞉êmî u tpile ṉgópu daa tóó, yedê kpê ṉgópu myedaa tóó. Kwo, Mbwaa chono daa tóó, mgî k꞉oo p꞉ââ y꞉i wunê tóó ó! Kwo, Mbwááni n꞉ii ghê a t꞉a, yi mbwááni ló y꞉i anyinê vy꞉oo? ");
INSERT INTO yle_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kwo, Nmî kn꞉ââ Njakóp, u dpodo pyu knî yi k꞉ii ala mbwááni u mgî y꞉oo a tpênê ngópu. Kwo, Mbwááni n꞉ii u mênê a pyw꞉ee ngópu, yi mbwááni chóó ndââ, tp꞉oo knî y꞉oo mye ndaa ngópu, u tpile tp꞉oo knî y꞉oo mye ndaa ngópu. Kwo, Ala kópu mumdoo a ka chi vyi, M̱i ndîî, Njakóp u pi têdê? ");
INSERT INTO yle_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu ngê kwo, Ala mbwaanté mbwaa ala. Kwo, N꞉ii ngê wa nda, mââ m꞉ii amaa mbwaambwaa. ");
INSERT INTO yle_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kwo, N꞉ii ka mbwááni n꞉ii anî y꞉oo, wa nda, yi pini mêdaadî mbwaambwaa. Kwo, Yi mbwááni yi pini u gha vy꞉o ada a kmîmî, yi pini u nuw꞉o kamî ngê u ngwo wa pyódu, ghê kamî u ngwo wa a pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yi pyópu ngê kwo, Mââwe. Kwo, Yi mbwááni knî a ka ngma a ki, daap꞉aa mbwaambwaa, ala mbwááni mêdaapînên꞉aa vy꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu ngê kwo, Chi lêpî, m̱oo a pwiyé we. ");
INSERT INTO yle_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yi pyópu ngê kwo, A moo daa tóó. Yesu ngê kwo, Ndê kópu, m̱oo daa tóó. ");
INSERT INTO yle_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwo, Pi limi yi p꞉uu nyi yéé wo, ala ngwo n꞉ii k꞉ii dpo tóó mo, yini ngê módó a y꞉eńey꞉eńe ngi. Kwo, Ndê kópu a ka yichi vyi. ");
INSERT INTO yle_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yi pyópu ngê kwo, Ala kópu kîd꞉a w꞉ee, nyi Chóó Lémi u komo kapî pyu ngmê, mu kópu u dîy꞉o a nuw꞉o kîchi m꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kwo, Nmo Samédiya tpémi nmî kn꞉ââ knî y꞉oo kî mbwini mbêmê Chóó Lémi ka kpêê dnyimo yiyé, ngmênê nmyo Nju tpémi, nmyinê nmye Njedusalem mu ngmidi Chóó Lémi ka u mo kpêê yiyé têdê. ");
INSERT INTO yle_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","22","Yesu ngê kwo, Nmyo Samédiya tpémi nmyi lama daa tóó pini n꞉ii ka nmye kpêê yiyé té, ngmênê nmo Nju tpémi, n꞉ii ka nmo kpêê yiyé té, nmî lama ka tóó, mu kópu u dîy꞉o nmo Nju tpémi u ngmidi ngmê u yoo, nmî vy꞉o Chóó Lémi ngê pi ngma a ngmidi ngê, daa yoo ngmidi yi Mbwámê ngê vyîlo ayi pyódu. Kwo, A ch꞉am. Kwo, Ala kópu ka chi kêlîmî. Kwo, Mu dini ghi ngê pi knî y꞉oo kî mbwini mbêmê kpêê daamo wa yé ngmê, Njedusalem kpêê myedaamuwa yé ngmê. ");
INSERT INTO yle_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kwo, Mu dini ghi ngê dye ghi kamî ngmêwa d꞉ii, yi dini ghi kn꞉ââ wunê kînî chópu. Kwo, Yi dini ghi ngê yélini y꞉oo Chóó Lémi ndêndê ngê adnyi chââchââ, mêdaadnyi kpêê yiyé, yi yéli yi gha vy꞉o nmî Mî ka ntênê adnyi ngêpê. Kwo, Yinté ngêpê pyu yoo yi yi dmi nmî Mî ngê a kwo. ");
INSERT INTO yle_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kwo, Chóó Lémi, Ghê Dmi ye tóó. Kwo, Yélini u kwo a ngêpê té, daa módó adnyi ngêpê, ngmênê Chóó Lémi u Ghê Dmi ngê choo a ngêêpî dé, ndêndê ngê u ngwo u kwo dny꞉oo ngêpê. ");
INSERT INTO yle_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yi pyópu ngê kwo, Kédisu nmo t꞉âât꞉ââ, pini n꞉ii Chóó Lémi ngê a ngmidi ngê. Kwo, A lama ka tóó, yi pini dini ghi n꞉ii ngê wa t꞉aa, kópu yilî nmî nuwo yinê amî kwolo. ");
INSERT INTO yle_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu ngê kwo, Ala nê vyîlo ṉga yinî danêmbum. ");
INSERT INTO yle_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yi dini ghi ngê nmo diyé dniye, nmî ngwéti dniye, noko nmomo, Kî lukwe? Nmomo, Yesu pyââ k꞉ii ka danêmbum mo. Nmî ngwéti dniye, mu kópu u dîy꞉o pini n꞉ii knî y꞉oo Chóó Lémi u kópu p꞉uu yoo a ndiye kîgha too, Nju tpémi y꞉oo yinté pini knî ye pyââ u k꞉ii danêmbum ye kwódu ngópu. K꞉omo tpile nmî ngwéti dniye, ngmênê yi pyópu ka dpîpî vyu, Lukwe ka nye vyuwo? Yesu ka myedpîpî vyu, Lukwe dîy꞉o ye pyópu k꞉ii dpî danêmbum mo? ");
INSERT INTO yle_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Wod꞉oo yi pyópu ngê u mbwaa pwódo y꞉i a kuwo ngê, yi p꞉aani mê diyé wo, p꞉aa tpémi ye yepê, Nga a pwiyé dmyeno. ");
INSERT INTO yle_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Yepê, Pi ngmê ka tóó, nganyi m꞉uu yó. Yepê, Kópuni yilî nê d꞉uu too, chóó kêda w꞉ee té. Yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê ndoo apê wu vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wod꞉oo yi p꞉aani a kuwo ngópu, Yesu ka a lee dniye. ");
INSERT INTO yle_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yi pyópu u kuwó Yesu ka kwonmo, Nté pee ngmê ma ngi. ");
INSERT INTO yle_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yesu ngê nmopê, Ntini n꞉ii n꞉aa pîpî, nmyi lama daa tóó. ");
INSERT INTO yle_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Noko nmî póó dniye, nmomo, Pi ngmê ngê nté pee u kwo ngmêda ńuw꞉o? ");
INSERT INTO yle_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu ngê nmopê, Ntini n꞉ii p꞉uu nmye anî danê, ala yi ntini. Nmopê, Pini n꞉ii ngê a dy꞉ââ noo, yi pini u pono n꞉aa vyápê, dpodoni a ka a kpo, yi dpodo n꞉aa chedêchedê. Nmopê, Yi kópu ye a nté njini. ");
INSERT INTO yle_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yesu ngê witi nt꞉ene u mgongo nmo ngmê kwólu, nmopê, Ala kópu nmye tpapê ngmê, Nté nt꞉u kêma wa kaalî, ngmênê ala kópu nmye n꞉aa tpapê, Yâpwo têdê n꞉ii u mênê nmo pyede, ngî m꞉uu yó, nt꞉u wunê kêdê kaalî. ");
INSERT INTO yle_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nmopê, Ala nté mgîpî u dye ghi. Nmopê, Yâpwo têdê nté ntee nmo ny꞉ee ngê, ala p꞉aani pi yilî yinté a ńuw꞉o téme, yi nuw꞉o dmi kamî ngê u ngwo paa pyaa we, ghê kamî pêdê pyw꞉ee y꞉e, ghéni n꞉ii chedê ngê daawa pyódu. Nmopê, Nté woo kapî pyu, nté mgîpî pyu y꞉oo wo ngmidi ngê w꞉aa pêdê pyw꞉ee y꞉e. ");
INSERT INTO yle_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nmopê, Pi ngê witi dpî ntówo, dpî k꞉aa, nt꞉u dini ghi n꞉ii ngê dpî kaalî, pi knî y꞉oo dpî ghada ngmê. ");
INSERT INTO yle_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nmopê, Nté woo al꞉ii dpîp꞉e kaa ngópu, ngmênê al꞉ii nmye nté mgîpî té. Nmopê, Kn꞉aa yéli al꞉ii wunê yedoo dpodo, yi dpodo u nt꞉u nmye dê kaalî. ");
INSERT INTO yle_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samédiya Wee u kwo tpémi yi p꞉aani yélini doo kwo, Yesu ka kêlîmî mbê dniye, mu kópu u dîy꞉o yi pyópu ngê yepê, Kópuni yilî nê d꞉uu too, chóó kêda w꞉ee té. ");
INSERT INTO yle_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yesu ka dini ghi n꞉ii ngê a lee dniye, kwo, U ntââ nmî p꞉o anyinê lê, nmî vy꞉o anyin꞉aa kwo. Wod꞉oo yi p꞉aani nmî lee dniye, wo miyó y꞉i nm꞉uu chedê ngê. ");
INSERT INTO yle_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","42","Samédiya pi mê yilî y꞉oo Yesu u kópu ny꞉ee tumo, u ngwo u kwo kêlîmî mbê dniye, yi pyópu ka kwo, Daa ṉgópu dyuu mu ngmidi u l꞉êê dîy꞉o kî pini ka dpî kêlîmî mbê dmi, ngmênê kópuni nmo dê vyi té, yi kópu knî yi l꞉êê dîy꞉o u kwo dpî kêlîmî mbê dmi. Kwo, Nmî lama dê yââ, Kî ndêndê ngê dyámê mbêmê tpémi yintómu nmî Mbwámê. ");
INSERT INTO yle_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Wo miyó Samédiya Wee u kwo nmee ya, womumo Nkálili nmî lee dniye, mu kópu u dîy꞉o Yesu u nuw꞉o alanté doo ya, Pini n꞉ii ngê Chóó Lémi u komo a kapî ngê, chóó u p꞉aa tpémi y꞉oo d꞉uudpî châpu ngmê. ");
INSERT INTO yle_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ngmênê Nkálili dini ghi n꞉ii ngê nmî taa dniye, yi yéli y꞉oo Yesu mb꞉aamb꞉aa ngê châpu ngópu, mu kópu u dîy꞉o kópu ndîî yilî n꞉ii Njedusalem naa têdê mwiyé mî d꞉uu too, yi yéli yi ngópu yi kópu yilî mî d꞉uu too. ");
INSERT INTO yle_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nkálili Wee u kwo nmee paa, Kéna nm꞉uu taa dniye, p꞉aani n꞉ii Yesu ngê mbwaa wain ngê mwiyé kwéli a tpólu. Mââwe ndîî ngmê, Kîpêêniyêm doo a ya, tp꞉oo doo a mbii. ");
INSERT INTO yle_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Dini ghi n꞉ii ngê u lama yaa wo, apê, Yesu ngê Njuda Wee ka a kuwo ngê, Nkálili Wee u kwo ka tóó, wod꞉oo nmo a loo, Yesu ka kwo, A tp꞉ee kîyedê mbii, Kîpêêniyêm, daa kêmakêma ka pwopwo, kwo, u ntââ wany꞉uu pyi. ");
INSERT INTO yle_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu ngê kwo, Mbwudu nmyi ngópu daangmanî chaa knomomê, ye a ka daanmya a kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yi pini ngê Yesu ka kwo, A lémi, mwiyé a ngmêê nédi, a tp꞉ee wa a pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu ngê kwo, M̱o mê dini, ṉ́m꞉ee kêdê pyiyé. Yi pini Yesu u kópu ka kêlîmî mbê wo, wod꞉oo mê diyé wo. ");
INSERT INTO yle_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","U dpodo pyu knî y꞉oo maadî a pyódu ngópu, mdoo u kwo y꞉oo a ńuw꞉o ngópu, kwo, Ṉ́m꞉ee kêda pyiyé. ");
INSERT INTO yle_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yi pini ye póó wo, yepê, Ló dini ghi ngê dê pyiyé? Kwo, Ma, kââdî mââ kêlî u kuwó dini ghi ngê pyiyé. ");
INSERT INTO yle_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yi pini ngê mî nuw꞉o kwólu, apê, Yesu ngê a ka pê, Ṉ́m꞉ee kêda pyiyé, apê, wu vyîlo yi dini ghi. Yi kópu u l꞉êê dîy꞉o u yoo knî yi k꞉ii Yesu ka kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mwiyémwiyé Yesu u k꞉ii Njuda Wee nmo kuwo ngê, Nkálili Wee u kwo nmî lee dniye, Kéna Yesu ngê mbwaa wain ngê a tpólu, u ngwo u kwo nmî kêlîmî mbê dniye. Myombó Njuda Wee mono kuwo ngê, Nkálili Wee u kwo nmî lee dniye, Kéna nmee ya, mââwe ndîî tp꞉oo Yesu ngê u ngwo pyi ngê, yi mââwe u yoo knî yi k꞉ii u ngwo u kwo kêlîmî mbê dniye. ");
INSERT INTO yle_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Njedusalem naa ndîî ngma a pwaa wo, Yesu u k꞉ii yi nááli têdê nm꞉uu taa dniye. ");
INSERT INTO yle_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Njedusalem u chêêpî mbwa u keńe knî yi vy꞉o, ngmê u pi, sipi knî yi koko têdê. Yi keńe u nkîgh꞉ê mbwaa lêê ngma a kwo, u pi Mbetîsaida. Yi mbwááni lêê u nkîgh꞉ê chêêpî ngomo tp꞉oo limi doo kwo. ");
INSERT INTO yle_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yi ngomo knî yi k꞉oo pwopwokopwe yilî dpîmo kwo, ngwolo kopwe dé, yu kwolo ngmê dé, kpâlî kpêê dé. ");
INSERT INTO yle_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Y꞉i pêpê dnyimo ya, Chóó Lémi u enjel dnyimo t꞉âât꞉ââ, mu kópu u dîy꞉o dye ghi knî ngmê ngê yi enjel ngê yi mbwááni lêê dpîmo ghêdê kîgha. Yi dini ghi ngê yi mbwááni lêê u kwo pini n꞉ii mwiyé dpîmo wupwo, yed꞉oo dpîmo pyiyépyiyé. ");
INSERT INTO yle_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pi ngmê y꞉i doo ya, m꞉ââ pyoloy꞉a mê wááli u knêyómu doo ya. ");
INSERT INTO yle_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu ngê yi pini yi módu, a w꞉ee ngê, apê, Kî pini dye ghi daadîî kî kópu u ngwo u ngwo a pyodo, wod꞉oo u kwo póó wo, kwo, Pyiyépyiyé u yi ṉga a kwo? ");
INSERT INTO yle_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yi pini ngê kwo, A lémi. Kwo, A ngêêpî pyu daa tóó. Kwo, Mbwaa dini ghi n꞉ii ngê a ghêdê yédi, a ngêêpî pyu wodoo ya, mbwaa lêê u kwo yinê pî kmênê noo, u ngwo p꞉aa pyiyé wo. Kwo, Mbwaa dini ghi n꞉ii ngê a ghêdê yédi, pi knî y꞉oo dpo kuwo nê, nmî vy꞉o pini ngmê n꞉ii kî mbwááni lêê u kwo mwiyé dpî ghîî, u ngwo dpî pyiyé. ");
INSERT INTO yle_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu ngê yi pini ka kwo, Gh꞉êêdé. Kwo, Ṉgmîtédmi a ngini, a kmongo ngi, yed꞉oo chi paa. ");
INSERT INTO yle_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yi pini até yi pyiyé wo, u ngmîtédmi a ngêêdî, wod꞉oo kada a y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wéni n꞉ii ngê yi kópu pyodo, yi wéni lîme wo, wod꞉oo pini n꞉ii Yesu ngê pyi ngê, Nju tpémi yi kada pini knî y꞉oo dini ghi n꞉ii ngê m꞉uu ngópu, yi pini ka póó dniye, kwo, Nmî lîme wo ngê lukwe dîy꞉o nye dpodo? Kwo, Ṉgmîtédmi lukwe dîy꞉o nye dnyinêdnyinê? Kwo, Apuu! Kwo, Nmî dêêpî kópu dyuu chuu châpu ngê. ");
INSERT INTO yle_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yi pini ngê yepê, Pini n꞉ii ngê dê pyi nê, yi pini ngê a ka dê, Ṉgmîtédmi a ngini, a kmongo ngi, yed꞉oo chi paa. ");
INSERT INTO yle_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","U kwo póó dniye, kwo, Pini n꞉ii ngê yi kópu ṉga dê vyi, u pi n꞉uu? ");
INSERT INTO yle_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngmênê yi pini u lama dêpwo ya, Yesu daa myââ, u chii myedêpwo kwo. Yi kêlî ghê pi dêpwo ghêdê, pi ngê Yesu daa módu. ");
INSERT INTO yle_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yesu ngê pini n꞉ii pyi ngê, u kuwó dini ghi ngê Chóó Lémi u ngomo k꞉oo mîmî módu, kwo, Kî pini. Kwo, Chi pyiyé. Kwo, Dono kópu n꞉aamungê d꞉uu. Kwo, Dono u maa p꞉uu am꞉ii ghê knomomê, dono ndîî u ngwo m꞉uu anyinê pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wod꞉oo yi pini Nju tpémi yi kada pini knî ye loo, yepê, Pini n꞉ii ngê dê pyi nê, u pi Yesu, Nasalet pi. ");
INSERT INTO yle_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yi kópu kn꞉ââ ngê pyodo. Yesu lîme wo ngê dpîmo pi pyipyi, wod꞉oo Nju tpémi yi kada pini yoo p꞉uu u nkwo dnyimo d꞉uu, u dî mîmî vya ngópu. ");
INSERT INTO yle_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu ngê yepê, Lîme wo ngê M꞉aa daa lîme yédi. Yepê, M꞉aa dye ghi yintómu ntee a dpodo, yinté myinê dpodo. ");
INSERT INTO yle_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nju tpémi yi kada pini knî ye yi kópu ndîî kópu ngê pyodo, Yesu u vyee u dîy꞉o u ngwo a châpwo ngópu. Noko yepê, Ala dono kópu a d꞉uud꞉uu, lîme wo u dêêpî kópu dyuu daa chââchââ, ngmênê ala ngwo dono kópu ndîî ngmêkêdê d꞉uu, nmodê, Nê Chóó Lémi Tp꞉oo. Noko yepê, Nmî Mî u pi ntoo, chóó u pi yintoo ngê myeka pyépi. ");
INSERT INTO yle_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, K꞉omo tpile nê Chóó Lémi Tp꞉oo, ngmênê a mo a kópu daangmanî d꞉uu. Yepê, M꞉aa p꞉uu kópuni n꞉aa mumu too, yi kópu yinî d꞉uud꞉uu té. Yepê, M꞉aa ngê kópuni a d꞉uud꞉uu too, yi kópu vyîlo yinî d꞉uud꞉uu té. ");
INSERT INTO yle_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yepê, A nuu ghi M꞉aa nódo a tóó, kópuni chóó a d꞉uud꞉uu too, a ka wunê kêmakêma too. Yepê, Kópu ndîî a ka amyedê kêma té, u nkwo anî d꞉uu té, ghê dmi nmyi mênê u ngwo wa ghipé. ");
INSERT INTO yle_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yepê, Yélini pw꞉oo dniye, M꞉aa ngê ntee dpo pyidu té, yinté yélini anî ch꞉ii, yi yéli ye ghê kamî anî y꞉oo, yi nuw꞉o dmi am꞉aa ngmêê. ");
INSERT INTO yle_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Yepê, M꞉aa ngê chóó pi daawa kóté kwolo, ngmênê pi yilî yintómu yi kóté kîgha pyu ngê dê pyódu nê, mu kópu u dîy꞉o pi yintómu knî y꞉oo M꞉aa ntee a chââchââ ngmê, yinté myedny꞉oo chââchââ nê. Yepê, Pini n꞉ii ngê daadî chââchââ nê, M꞉aa myedaadî chââchââ, n꞉ii ngê a dy꞉ââ noo. ");
INSERT INTO yle_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Yepê, Ala ndê kópu nmye yinî tpapê, N꞉ii ngê a dnye adî nyêm, M꞉aa ka amyedê kêlîmî, yi pini u nuw꞉o kamî ngê wunê dê pyódu, ghê kamî wunê da pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu. Yepê, Yi pini daanî kóté kwolo, myedaanî kpada. Yepê, Yi pini pwopwo u yoo vy꞉o wunê da pwii, ghê kamî u mênê wunê dê yââ. ");
INSERT INTO yle_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yepê, Ala ndê kópu nmye yinî tpapê, Kópu kamî u dye ghi ngmêkîyedê pwiyé knî. Yepê, N꞉ii knî y꞉oo ghê kamî doongê pyw꞉ee ngópu, a dnye yi ngwo wa ny꞉ee ngmê, ghê kamî u ngwo ye wa t꞉aa. Yepê, Yi yéli y꞉oo wa mya nê, awo, Wu Chóó Lémi Tp꞉oo nmo yedê mbwólu. Yepê, Ala kópu nmye yinî tpapê, Yi dini ghi mye ala. ");
INSERT INTO yle_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yepê, M꞉aa Ghê Kamî u Kn꞉ââ ngê ntee a tóó, yinté Ghê Kamî u Kn꞉ââ ngê mye pyódu noo. ");
INSERT INTO yle_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yepê, Pi yintómu yi kóté kîgha pyu ngê mye pyódu noo, mu kópu u dîy꞉o nê u Pi Ndêndê. ");
INSERT INTO yle_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Yepê, Ghê dmi nmyi mênê lukwe dîy꞉o dê ghipé. Yepê, Dye ghi ngmêkîyedê pwiyé knî, dini ghi n꞉ii ngê kpêênî yéli y꞉oo a dnye wa ny꞉ee ngmê, u ngwo wa a pii dmi. Yepê, Yélini y꞉oo mb꞉aamb꞉aa dnyimo d꞉uud꞉uu, yi yéli y꞉oo ghê kamî wa a pyw꞉ee ngmê, yélini y꞉oo dono dnyimo d꞉uud꞉uu, yi kpadakpada têdê wa lee dmi. ");
INSERT INTO yle_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yepê, Doo u ntââ a chóó a kópu daangmanî d꞉uu. Yepê, Yoo ndêndê ngê anî kóté kwolo, mu kópu u dîy꞉o daa a chóó a pono n꞉aa vyápê, ngmênê pini n꞉ii ngê a dy꞉ââ noo, yi pini u pono n꞉aa vyápê. ");
INSERT INTO yle_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesu ngê yepê, Ala kópu a ka anmyi vyi knomomê, a ka nye, Kópuni nmo chi vyi, m̱o nmo chi vyi, ṉgópu dyuu ndê kópu ngê lónté nmo anyi pyódu. ");
INSERT INTO yle_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yepê, Pi ngma tóó, n꞉ii a p꞉uu a danê. Yepê, A lama ka tóó, kópuni a p꞉uu a tpapê, ndê kópu. ");
INSERT INTO yle_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yepê, Njon ka pi knî ngmênmyi dy꞉ââ ngópu, kópuni a p꞉uu ye vyi too, yi kópu ndê kópu dé. ");
INSERT INTO yle_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yepê, K꞉omo tpile pi u kópu a ka daa ndîî kópu, ngmênê yi kópu nmye kîdî vyi, mu kópu u dîy꞉o a ka pêdmyina a kêlîmî, u ngwo p꞉aa ngee nmyo. ");
INSERT INTO yle_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yepê, Njon pywápê k꞉ii ntee tpile yedoo pîpî, u wu ngê nmyi mgîdî mwiyé mî chópu. ");
INSERT INTO yle_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yepê, A ka kêlîmî kn꞉ââ miyó. Yepê, Kópuni Njon ngê a p꞉uu nmye a vyu, wu ngmê. Yepê, Myomoni, kópu ndîî n꞉ii n꞉aa d꞉uud꞉uu too. Yepê, Yini ndîî. Yepê, M꞉aa ngê yi dpodo yilî a ka a kpo, yi dpodo knî y꞉oo nmye yinê wunê kêmakêma noo. ");
INSERT INTO yle_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yepê, M꞉aa ngê ndêndê ngê a dy꞉ââ noo, ndê kópu yilî a p꞉uu yinê a tpapê. Yepê, U dnye dmy꞉oongê ny꞉ee ngópu, myedmy꞉oongê m꞉uu ngópu. ");
INSERT INTO yle_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yepê, K꞉omo tpile nmye yinê a dy꞉ââ noo, ngmênê a ka dp꞉ee kêlîmî té. Yepê, Yi kópu u l꞉êê dîy꞉o u kópu dyuu nmyi mênê daa kwo. ");
INSERT INTO yle_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yepê, M꞉aa u kópu dyuu puku yedê nmyinê kpââ ngópu, mu kópu u dîy꞉o alanté nmye nuw꞉o nyédi, ghê kamî u ngwo anmo pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yepê, K꞉omo tpile yi kópu dyuu ngê wunê kêmakêma noo, ngmênê a wépi nmye pwapî ngmê, yi ghéni kamî dênmyinê pyw꞉êmî ngmê. ");
INSERT INTO yle_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yepê, K꞉omo tpile anmyi chaa kîgha nê, ó daanmyi chaa kîgha nê, yi kópu a ka daa ndîî kópu. ");
INSERT INTO yle_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yepê, A lama ka tóó, Chóó Lémi u nuu ghi nmyi nódo daa tóó. ");
INSERT INTO yle_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yepê, K꞉omo tpile M꞉aa u pi ngê nê loo, ngmênê a wépi nmye pwapî ngmê. Yepê, Pini n꞉ii chóó u pi ngê dpo lê, u wépi dp꞉uuw꞉ee pwaa ngmê. ");
INSERT INTO yle_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yepê, U yi nmye a kwo, Pi knî y꞉oo dny꞉oo chaa kîgha nmo, ngmênê kópuni u l꞉êê dîy꞉o Chóó Lémi ngê choo a chaa kîgha nmyo, yinté kópu dmy꞉oongmê d꞉uu ngópu. Yepê, Pini n꞉ii yâpwo ndêndê ngê a tóó daanmyi chââchââ. Yepê, Yi kópu u l꞉êê dîy꞉o a ka dp꞉ee kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yepê, Nê kuu, M꞉aa ka a chóó daanî ndyîko nmyo, ngmênê Mósisi ngê yinê wa ndyîko nmyo, pini n꞉ii nmyinê nmye nmyi mbwámê. ");
INSERT INTO yle_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yepê, Mósisi u kópu dyuu ka ndêndê ngê w꞉ee kêlîmî té, ye a ka myep꞉ee kêlîmî té, mu kópu u dîy꞉o a p꞉uu doo a d꞉êê. ");
INSERT INTO yle_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Yepê, U kópu dyuu ka dp꞉ee kêlîmî té, a ka myedp꞉ee kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","U kuwó dini ghi ngê Yesu u k꞉ii Nkálili Kpéni Lêê nmî ngmópu. Yi kpéni lêê u pi mye Taipidiyas. ");
INSERT INTO yle_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pi yilî tp꞉oo témi tap knî y꞉oo dnya a yâmuyâmu nmo, mu kópu u dîy꞉o Yesu ngê mbwudu yi ngópu yilî dpîmo chap, pwopwokopwe dpîmo pyipyi dé. ");
INSERT INTO yle_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu u k꞉ii mbu mbêmê nmî kee dniye, y꞉i mbwódo nm꞉uu yaa dniye. ");
INSERT INTO yle_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nju tpémi yi naa ndîî, Tp꞉ee Kaa W꞉êêw꞉êê u Naa, daa kêmakêma doo dyimêdyimê. ");
INSERT INTO yle_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu ngê ngwolo dê yi kalê doo, apê, Yoo ndîî ngmêyedê pwiyé knî. Pilipi ka póó wo, kwo, Nté knî ló y꞉i ngmanmî pwila, kî yéli ndîî u ngwo wanmî mbono té? ");
INSERT INTO yle_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pilipi doo a tókótókó, yi kópu u ngwo u kwo vyu. Yesu u lama doo ya, Kî yéli yi ngópu mbwudu ngmên꞉aa chap, u ngwo n꞉aa mbonombono té. ");
INSERT INTO yle_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipi ngê kwo, Yoo ló mye ntoo. Kwo, Ndapî my꞉oo yono y꞉a doo u ntââ. Kwo, Nté pee tp꞉oo ye pîpî ngmê, awêde daawa pile dmi. ");
INSERT INTO yle_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Yesu p꞉uu ndiye pyu m꞉uu, Saimon Pita u mbwó Andru, yi pini ngê Yesu ka kwo, Tp꞉ee ngmê ala. Kwo, Mbîdédi tp꞉oo limi yi tpyé, te miyó. Kwo, Ngmênê daa yoo u ntââ. ");
INSERT INTO yle_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu ngê nmopê, Ye vyi yó, Mbiye mbêmê yaa dniye. (Yi kêlî ghê mbiye dêpwo ghêdê.) Pi yilî yintómu mbwódo yaa dniye, yintómu limo yono yono y꞉a (5,000). ");
INSERT INTO yle_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu ngê yi mbîdédi limi knî a ngî too, pwaa too, Chóó Lémi yi l꞉êê dîy꞉o kwuno ngê, mbîdédi n꞉êê kuu nmo a kpo, yi yéli ye nmî y꞉ângo, yoo u ngwo nmî mbono ngê. Yi kópu te miyó dê y꞉e mye d꞉uu ngê, pi yintómu dnye kmaapî, pile dniye, nté daa chedê ngópu. ");
INSERT INTO yle_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dini ghi n꞉ii ngê yi ghê dmi a kee wo, Yesu ngê nmopê, Ntini n꞉ii kmono d꞉uu kê, mêdê wó yó, nté kmono pi daawa dyênê. ");
INSERT INTO yle_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wod꞉oo yi ntini kmono nmo wó, péé y꞉a mê miyó nmî ntówo. ");
INSERT INTO yle_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yélini y꞉oo yi ntini ma ngópu noko yepê, Yesu ngê mbwudu nmo ngmêdê chaa. Noko yepê, Chóó Lémi u komo kapî pyu n꞉ii nmo t꞉âât꞉ââ, kî vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu ngê a w꞉ee ngê, apê, Kî yéli y꞉oo wunê ny꞉ee nê, lede knî yi kada pini ngê a pyépi nê. Yesu ngê u yi dêpwo kwo, Yinté kada pini ngê pyódu nêne, wod꞉oo kada a y꞉ângo, mbu mbêmê u mo mî kee wo. ");
INSERT INTO yle_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ntumokwodo dini ghi yi yó, Yesu p꞉uu yélini nmee ndiye, dinki k꞉oo nmî wo dniye, kada nmo y꞉ângo, Kîpêêniyêm nmee lêpî. Mgîdî maa p꞉uu nmo a ghay wo, Yesu nmo dêpêngê loo. ");
INSERT INTO yle_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yópu ndîî nmo ngma a pwaa wo, vyuwó mbêmê kpaapî ghê wo. ");
INSERT INTO yle_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Daa kêmakêma Kîpêêniyêm nmee todotodo, Yesu ntii mbêmê paa têdê nmî módu, nmî nkîngê mbê dniye, noko nmomo, Lukwe nmî kêténi kîyedê pwiyé knî? ");
INSERT INTO yle_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu ngê nmopê, Namê nkîngê, ala nê. ");
INSERT INTO yle_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","U yi nmo doo kwo, Yesu dinki k꞉oo nmî ché, ngmênê lyoko yi dini ghi ngê nmî kee dniye. ");
INSERT INTO yle_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Womumo mw꞉aandiye, Yesu ngê yoo kwéli mbono too, yoo y꞉i nipi a wó, Yesu dnye t꞉âât꞉ââ, mu kópu u dîy꞉o alanté dnye nuw꞉o, Yesu p꞉uu ndiye pyu knî yi k꞉ii ma dinki mu ngmidi ngê a lee dmi, p꞉uu ndiye pyu yoo yi dinki ngê yi mo mê diyé dmi. Noko yepê, Yesu al꞉ii ló y꞉i a tóó? ");
INSERT INTO yle_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","Dnye nmy꞉uu, ngmênê dêpê pyw꞉ee ngópu, noko yepê, Al꞉ii daa tóó, p꞉uu ndiye pyu yoo al꞉ii myedaa pyede. Dinki knî ngmê Taipidiyas a ndê dniye, nmî Lémi ngê Chóó Lémi kwéli kwuno ngê, yoo kwéli mye mbono ngê, y꞉i mî tee dniye. Yoo yi dinki knî yi k꞉oo wo dniye, Kîpêêniyêm u ngwo a lee dniye, Yesu dnyen꞉aa nmy꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pi knî y꞉oo Yesu dini ghi n꞉ii ngê Kîpêêniyêm a pyw꞉ee ngópu, kwo, Mââwe. Kwo, Al꞉ii anté nyi t꞉aa? ");
INSERT INTO yle_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu ngê yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Anmye nmy꞉uu nê, mu kópu u dîy꞉o ma ntini n꞉ii nmye nê kê, yi ntini ngê nmyi pile dmi. Yepê, Yi ntini p꞉uu nmye nuw꞉o té, dpodoni nî dóó, yi kópu p꞉uu dp꞉ee nuw꞉o té. ");
INSERT INTO yle_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yepê, Ntini n꞉ii chedê ngê dpî pyódu, yi ntini p꞉uu namê dpodo, ngmênê ntini n꞉ii chedê ngê daawa pyódu, yi ntini p꞉uu dmyinê dpodo, ghê kamî u ngwo anmyinê pyw꞉ee ngmê, ghéni n꞉ii chedê ngê daawa pyódu. Yepê, Yi ntini Chóó Lémi u Pi Ndêndê ngê nmye yinê wa a kê, pini n꞉ii Chóó Lémi ngê a myââ, nmye myedê kêma ngê. ");
INSERT INTO yle_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yesu ka póó dniye, kwo, Ló dpodo ngmê Chóó Lémi u nuu u dpodo vyîlo ay꞉uu dóó, ghê kamî u ngwo anmo pyw꞉oo? ");
INSERT INTO yle_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu ngê yepê, Chóó Lémi ngê ala dpodo u yi ye kwo, Pini n꞉ii nmye a dy꞉ââ ngê, u kwo dmyinê kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yesu ka kwo, Lóntoo mbwudu nmî ngópu ngmanyi chaa, u ngwo ṉga anmo kêlîmî mbê dmi? Kwo, Ló kópu ngmanyi d꞉uu? ");
INSERT INTO yle_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kwo, Nmî kn꞉ââ knî y꞉oo nko mênê mana yidnya a pîpî. Kwo, Puku yedê alanté a tóó, Ntini n꞉ii mbóó p꞉uu doo a ndiyendiye, vyîlo ye yedoo a yém. ");
INSERT INTO yle_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu ngê yepê, Ala ndê kópu nmye yinî tpapê, Ntini n꞉ii mbóó p꞉uu doo a ndiyendiye, daa Mósisi ngê vyîlo nmye yedê kpo. Yepê, M꞉aa ngê nté njini nmye wunê kuwo. Yepê, Chóó Lémi ngê ntini n꞉ii nmye wunê kuwo, daa nté ntee ntini, ");
INSERT INTO yle_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ngmênê pini n꞉ii mbóó p꞉uu a ndê wo, ghê kamî nmye yinê wunê kuwo, wu vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yesu ka kwo, Mââwe. Kwo, Dye ghi yintómu yinté ntini nmo yicha a kuwo. ");
INSERT INTO yle_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu ngê yepê, Nê nmyi nté njini. Yepê, N꞉ii a yoo vy꞉o dpî ghê, yini daa dómudómu yédi. Yepê, N꞉ii a ka ada a kêlîmî, yini myedaadî mbwaambwaa. ");
INSERT INTO yle_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Yesu ngê yepê, Ala kópu wunê mu nmye nî vyu, K꞉omo tpile nmyi m꞉uu noo, ngmênê a ka dp꞉ee kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yepê, M꞉aa ngê yélini a ka wunê kuwo, yi yéli yintómu a ka wa a lee dmi, yi wépi dmi daanî puwâ, ");
INSERT INTO yle_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","mu kópu u dîy꞉o daa a chóó a pono vyápê u l꞉êê dîy꞉o mbóó p꞉uu nê ndê wo, ngmênê pini n꞉ii ngê a dy꞉ââ noo, yi pini u pono vyápê u l꞉êê dîy꞉o nê loo. ");
INSERT INTO yle_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yepê, Yélini a ka a kpo, l꞉âmo daangmanî ngee, ngmênê kuwókuwó wéni ngê anê pyidu té. Yepê, Vyîlo yi kópu u l꞉êê dîy꞉o nê loo. ");
INSERT INTO yle_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yepê, M꞉aa ngê ala kópu u yi ye kwo, Yélini y꞉oo a tp꞉ee wa m꞉uu ngmê, u kwo amyidnyi kêlîmî, yi yéli yi nuw꞉o dmi kamî ngê pyaa we, ghê kamî a pyw꞉ee y꞉e, ghéni n꞉ii chedê ngê daawa pyódu. Yepê, Kuwókuwó wéni ngê yi yéli wanê pyidu té. ");
INSERT INTO yle_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kópuni Yesu ngê Nju tpémi ye mwiyé vyu, yepê, Ntini n꞉ii mbóó p꞉uu a ndê wo, ala nê vyîlo, yi kópu u l꞉êê dîy꞉o Nju tpémi u ngwo dnye nuu mbumu. ");
INSERT INTO yle_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Noko yepê, Kî pini Njósép tp꞉oo, u pye mî nmî lama dê. Noko yepê, Ala kópu lukwe dîy꞉o dê vyi, Mbóó p꞉uu nê ndê wo. ");
INSERT INTO yle_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu ngê yepê, Noko namê nuu mbumu. ");
INSERT INTO yle_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yepê, Pi módó a yoo vy꞉o daangmêwa a ghê, ngmênê M꞉aa ngê a ka yinê wa a ńuw꞉o, yi pini a yoo vy꞉o u ngwo wa ghê, kuwókuwó wéni ngê yi pini anê pyidu. ");
INSERT INTO yle_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yepê, Chóó Lémi u komo kapî pyu ngmê ngê ala kópu a d꞉êê ngê, apê, Pi yilî yintómu Chóó Lémi p꞉uu adnyi ndiye. Yepê, N꞉ii knî y꞉oo M꞉aa u dnye a nyêmî ngmê, p꞉uu a ndiye té, yi yéli a ka vyîlo yiwunê lêpî. ");
INSERT INTO yle_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yepê, K꞉omo tpile u dnye a nyêmî ngmê, ngmênê daa mumu ngmê. Yepê, Nê mu ngmidi M꞉aa a mo n꞉uu módu, mu kópu u dîy꞉o nipi nyipu a ya. ");
INSERT INTO yle_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yesu ngê yepê, Ala ndê kópu nmye yinî tpapê, N꞉ii a ka ada a kêlîmî, yi pini u nuw꞉o anî ngmêê, ghê kamî u ngwo wa a pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yepê, Nê nmyi nté njini. ");
INSERT INTO yle_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yepê, K꞉omo tpile nmyi kn꞉ââ knî y꞉oo mana nko mênê dnya a pîpî, ngmênê mye pw꞉oo dniye. ");
INSERT INTO yle_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yepê, Nté njini n꞉ii mbóó p꞉uu a ndê wo, daa mana ntee ntini. Yepê, Pini n꞉ii ngê yi ntini ndêndê wa ma, daawa pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yepê, Nê nmyi nté njini, mbóó p꞉uu nê ndê wo, ghê njini a mênê a tóó. Yepê, N꞉ii ngê ala ntini wa ma, u ghê chedê ngê daawa pyódu. Yepê, Ntini n꞉ii u kwo anî y꞉oo, a chóó a mbyuu u kwo ay꞉ii y꞉oo, mu kópu u dîy꞉o dyámê mbêmê tpémi y꞉oo ghê kamî pêdê pyw꞉ee y꞉e. ");
INSERT INTO yle_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesu u kópu dyuu u l꞉êê dîy꞉o Nju tpémi noko kwopwepe mbê dniye, noko yepê, Kî pini ngê chóó u mbyuu pee lónté nmo wa a kê, wanmî ma? ");
INSERT INTO yle_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu ngê yepê, Ala ndê kópu nmye yinî tpapê, Chóó Lémi u Pi Ndêndê mbyuu daanmyi ma knomomê, u wêê myedaanmyi nda knomomê, ye ghê kamî nmyi mênê daawa yââ. ");
INSERT INTO yle_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yepê, N꞉ii ngê a mbyuu wa ma, a wêê amye nda, yini u mênê ghê kamî wa yââ, kuwókuwó wéni ngê anê pyidu. ");
INSERT INTO yle_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yepê, Nté ntee ntini u pîpî daa ndîî kópu, a mbyuu u pîpî yi ndîî kópu. Yepê, Mbwaa ntee mbwááni u ndanî daa ndîî kópu, a wêê u ndanî yi ndîî kópu. ");
INSERT INTO yle_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yepê, N꞉ii ngê a mbyuu wa ma, a wêê amye nda, yini k꞉ii ngmidi ngê anyi pyaa knî. ");
INSERT INTO yle_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yepê, M꞉aa, ghê u kn꞉ââ. Yepê, Yinê a dy꞉ââ noo. Yepê, M꞉aa u ghê a mênê ntee a tóó, pini n꞉ii ngê wa ma nê, a ghê u mênê yinté adî ya. ");
INSERT INTO yle_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yepê, Nté njinini mbóó p꞉uu a ndê wo, ala vyîlo yi ntini. Yepê, Daa mana ntee ntini. Yepê, Nmyi kn꞉ââ knî y꞉oo w꞉amî mbêmê mana dnya a pîpî, myedê pw꞉oo dniye, ngmênê n꞉ii ngê ala ntini wa ma, yini daawa pw꞉onu, adî ya, chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yi kópu dyuu Yesu ngê u dêêpî têdê ye vyu, dini ghi n꞉ii ngê Kîpêêniyêm ngêpê ngomo k꞉oo doo dêêpî. ");
INSERT INTO yle_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesu p꞉uu ndiye pyu woni knî y꞉oo yi kópu dyuu dini ghi n꞉ii ngê ny꞉ee ngópu, noko yepê, Wu kópu dyuu u nyêm nmo doo u ntââ. Nanê wa ny꞉ee té. ");
INSERT INTO yle_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu ngê yi kópu chóó a w꞉ee ngê, apê, A p꞉uu ndiye pyu yoo ka nuu mbumu té. Yesu ngê yepê, Yi kópu dyuu u l꞉êê dîy꞉o a wépi wanmyi pwaa ngmê? ");
INSERT INTO yle_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yepê, Mbóó p꞉uu kwéli nê ndê wo dini ghi n꞉ii ngê nmyi ngópu am꞉aa diyé, ye yi ngwo a ka anmyinê kêlîmî mbê dmi? ");
INSERT INTO yle_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yepê, Kópuni nmyi chóó wanmyi d꞉uu t꞉oo, doo u ntââ dé, ghê kamî u ngwo daanmyinê pyw꞉ee ngmê, ngmênê Chóó Lémi u Ghê Dmi mu ngmidi u ntââ, ghê kamî nmye yinê wa a kê. Yepê, A kópu dyuu Chóó Lémi u Ghê Dmi mbêmê nmye dî vyi, ghê kamî u ngwo wanmyinê pyw꞉ee ngmê, ngmênê nmyi vy꞉o ngmê knî daa kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yesu ngê yi kópu vyu, mu kópu u dîy꞉o yélini u kwo dêdnye kêlîmî, yi yéli wunê mwiyé a m꞉uu too, pini n꞉ii u kwódo ngê ghê wo, wunê myedê módu. ");
INSERT INTO yle_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesu ngê yepê, Yi kópu u l꞉êê dîy꞉o nmyenê, Pi ngmê a yoo vy꞉o módó daangmêwa ghê. M꞉aa ngê u ntââ ngê mwiyé wa a pyódu, a yoo vy꞉o u ngwo wa ghê. ");
INSERT INTO yle_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yi kópu dyuu u l꞉êê dîy꞉o, yélini y꞉oo Yesu dnye yâmuyâmu, yi yéli yi vy꞉o pi yilî knî y꞉oo Yesu a kuwo ngópu, mêdêdnye yâmuyâmu. ");
INSERT INTO yle_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Wod꞉oo nmo y꞉a mê miyó, Yesu ngê nmopê, U yi nmye a kwo, Amy꞉ee lee dmi? ");
INSERT INTO yle_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita ngê kwo, A Lémi. Kwo, N꞉uu ka am꞉oo lee dmi? Kwo, Kópuni dyuu nye tpapê, yi kópu dyuu mbêmê ghê kamî anmo pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kwo, Ṉga dp꞉o kêlîmî mbê dmi. Kwo, Ala kópu nmî lama kêdê yââ, Nyi Chóó Lémi u ngmidi ngmê u pi. ");
INSERT INTO yle_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu ngê nmopê, K꞉omo tpile nmyi y꞉a mê miyó a chóó nê ngmidi nmyoo, ngmênê nmyi vy꞉o Setan u pénta ngma a kwo. ");
INSERT INTO yle_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Njudas p꞉uu nmo doo mbumu, pini n꞉ii Saimon tp꞉oo, Kédiyót pi. K꞉omo tpile nmî y꞉a mê myomoni, ngmênê Yesu u lama doo ya, A kwódo ngê vyîlo ayi ghê. ");
INSERT INTO yle_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesu ngê Nkálili Wee ghêlî dêpê kuwo ngê, p꞉aani p꞉aani y꞉i doon꞉aa dpodo. U yi u ngwo dêpwo kwo, Njuda Wee u kwo nî lê, mu kópu u dîy꞉o Nju tpémi yi kada pini knî y꞉oo u vyee u yi y꞉e doo kwo. ");
INSERT INTO yle_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nju tpémi yi nté ghada u naa daa kêmakêma doo dyimêdyimê, pi yintómu yi nááli têdê Njedusalem dnye lêpî. ");
INSERT INTO yle_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesu u mbwó knî y꞉oo Yesu ka kwo, Ala p꞉aani a kuwo ngi, Njuda Wee u kwo chi lêpî, kópuni nye d꞉uud꞉uu té, m̱꞉uu ndiye pyu knî y꞉oo y꞉i nye m꞉uu téne. ");
INSERT INTO yle_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kwo, N꞉ii ngê u yi adî kwo, Yoo yi lama nî yââ, yi pini mêdaa mbwolombwolo paa yédi. Kwo, Mumdoo yi kópu nye d꞉uud꞉uu té, ye pi knî yi ngópu dp꞉uu d꞉uu té, ṉ́yóóchóó ye nyinê kêma ngi. ");
INSERT INTO yle_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(K꞉omo tpile u mbwó yoo, u kwo myedêdnye kêlîmî.) ");
INSERT INTO yle_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu ngê yepê, Dini ghi n꞉ii n꞉aa t꞉âât꞉ââ, yi dini ghi doongê yó, ngmênê dye ghi yintómu nmyi dye ghi dé. ");
INSERT INTO yle_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yepê, Doo u ntââ pi knî ye daanmyi diya dmi, ngmênê p꞉ee ye dî diy꞉a, mu kópu u dîy꞉o yi kópu dono ye n꞉aa kwódukwódu too. ");
INSERT INTO yle_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yepê, Yi nááli têdê dmyinê lêpî, nê dînî lêpî, mu kópu u dîy꞉o dini ghi n꞉ii n꞉aa t꞉âât꞉ââ, yi dini ghi doongê dyimê wo. ");
INSERT INTO yle_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yi kópu ye vyi too, Nkálili ghêlî dêpê kuwo ngê, y꞉i doo ya. ");
INSERT INTO yle_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu u mbwó yoo nté ghada u naa têdê dini ghi n꞉ii ngê lee dniye, yi kuwó my꞉oo ghê dniye, Yesu u k꞉ii naa têdê my꞉oo lee dniye. Yi nááli têdê daa pi lama nmî taa dniye, ngmênê tumutumu nmî taa dniye. ");
INSERT INTO yle_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nju tpémi y꞉oo yi nááli têdê Yesu dnye nmy꞉uu, noko yepê, Angênê yi pini? ");
INSERT INTO yle_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kwayi ngê p꞉uu dnye danê. Ngmê knî y꞉oo apê, Pi mb꞉aa. Ngmê knî y꞉oo apê, Kêle. Apê, Pi yilî a dódó. ");
INSERT INTO yle_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yesu p꞉uu tââ dêdnye danê, mu kópu u dîy꞉o kada pini knî ye dnye nkîngê. ");
INSERT INTO yle_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yi nááli u wo knî yi ńuknîńuknî p꞉uu dnye ya, Yesu u k꞉ii Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo nm꞉uu kee dniye, Yesu ngê dêêpî kn꞉ââ ye ngmê chópu. ");
INSERT INTO yle_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nju tpémi yi mênê ghê dmi ghipé wo, noko yepê, Kî pini ndiye pyu ndîî p꞉uu dêpwo ndiye, ngmênê puku yedê kópu dyuu u lama mb꞉aamb꞉aa ngê a kwo. ");
INSERT INTO yle_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu ngê yepê, Ala daa a chóó a kópu dyuu nmye yinî tpapê, ngmênê n꞉ii ngê a dy꞉ââ noo, u kópu dyuu nmye yinî tpapê. ");
INSERT INTO yle_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yepê, Pini n꞉ii Chóó Lémi u pono a vyápê, yi pini ngê chóó wa a w꞉ee, awo, Nê ngê daa chóó u kópu dyuu ye tpapê, ngmênê Chóó Lémi u kópu dyuu ye tpapê. ");
INSERT INTO yle_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yepê, Pini n꞉ii ngê chóó u kópu dyuu a tpapê ngê, u yi u ngwo a kwo yédi, A chóó a pi nî knî. Yepê, Ngmênê pini n꞉ii ngê a dy꞉ââ noo, u ya a nga a kwo, Yi pini u pi nî knî. Yepê, Dînî dódó nmyo, myedînî k꞉omodanê. ");
INSERT INTO yle_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Yepê, Ala kópu nmye ndîî kópu, Mósisi ngê Chóó Lémi u dêêpî kópu dyuu daa kn꞉aa yéli ye y꞉ângo, ngmênê nmo a kpo. Yepê, K꞉omo tpile Mósisi u dêêpî kópu dyuu nmyinê nmye ndîî kópu dyuu, ngmênê dp꞉ee chââchââ ngmê. Yepê, Lukwe dîy꞉o a vyee módó nmyi mênê a tóó? ");
INSERT INTO yle_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Pi knî y꞉oo Yesu ka kwo, Chi ghéti. Kwo, M̱yee u yi n꞉uu ngê a kwo? ");
INSERT INTO yle_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","23","Yesu ngê yepê, Lîme wo ngê nmyi ngópu pi ngmênî pyi ngê. Yepê, Lukwe dîy꞉o nmyi nyepênyepê u kópu ngê pyodo? Yepê, Lîme wo ngê kîmy꞉ee dpodo nyédi. Yepê, Mósisi ngê ala kópu a d꞉êê ngê, apê, nmyi tp꞉ee mââ choo taataa, wo woloni ngê Chóó Lémi u l꞉ii p꞉uu dmyinê t꞉emî. (Yi kópu kn꞉ââ daa Mósisi ngê yinê a chópu, ngmênê u kn꞉ââ knî y꞉oo y꞉oo a chaa ngópu.) Yepê, K꞉omo tpile tp꞉ee mââ u wo woloni lîme wo ngê dpî d꞉ii, ngmênê yi wéni ngê Chóó Lémi u l꞉ii yi tpémi u ghi ngmidi p꞉uu mye t꞉emî ngópu, yi ghi mb꞉aamb꞉aa ngê u ngwo dpî pyódu. Yepê, Pini n꞉ii lîme wo ngê nî pyi ngê, u nt꞉u ghi yintómu mb꞉aamb꞉aa ngê nî pyódu too. Yepê, Yi kópu u l꞉êê dîy꞉o lukwe dîy꞉o módó nmye nod꞉enod꞉e té. ");
INSERT INTO yle_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yepê, Too pee pw꞉ono kîdmyemê nuw꞉o, u mênê ntênê dmyinên꞉aa nuw꞉o. ");
INSERT INTO yle_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Njedusalem pi ngmê knî y꞉oo noko yepê, Nmî kada pini knî y꞉oo pini n꞉ii u vyee u yi a kwo, kî vyîlo, apii? ");
INSERT INTO yle_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Noko yepê, Lukwe dîy꞉o tumutumu daa m꞉ii, nmî ngópu pi yintómu knî ye mêka danêmbum, ngmênê kada pini knî y꞉oo kópu u kwo myedaa tpapê ngmê. Noko yepê, Mumdoo nmî kada pini knî ye yinê ye pini n꞉ii Chóó Lémi ngê a ngmidi ngê, kî vyîlo? ");
INSERT INTO yle_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Noko yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, kwéli wa a ndê nmî lama daa tóó, ngmênê kî pini kwéli a ndê wo, nmo yintómu nmî lama ka tóó. ");
INSERT INTO yle_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu ngê Chóó Lémi u ngomo k꞉oo dini ghi n꞉ii ngê yoo doo ndiye kîgha, dpodombiy꞉e ye mbwolo, yepê, Ye mumdoo nmyi lama n꞉aa tóó, kwéli nê ndê wo, yi ghi nmyi lama mye tóó? Yepê, Daa a chóó nê loo, ngmênê pini n꞉ii ngê a dy꞉ââ noo, yi pini pi ndêndê. ");
INSERT INTO yle_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yepê, Daa nmyi lama pini, ngmênê a lama pini, mu kópu u dîy꞉o u kwo nê ndê wo, yinê a dy꞉ââ noo. ");
INSERT INTO yle_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wod꞉oo pi knî y꞉oo u yi doo kwo, Yesu nmî mgîmî, ngmênê kêê u ngwo dêpê t꞉ee ngópu, mu kópu u dîy꞉o u vyee u dye ghi daangê yó. ");
INSERT INTO yle_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yi yéli yi vy꞉o pi yilî u kwo kêlîmî mbê wo, noko yepê, Kî pini ngê mbwudu yilî dê chaa, doo u ntââ pi ngê daawa t꞉ee kwolo. Noko yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, kî vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pi knî y꞉oo Yesu p꞉uu kópuni kwayi ngê dnye tpapê dé, Pádisi knî y꞉oo yi kópu ny꞉ee tumo, wod꞉oo kpêê yiyé pyu yoo yi kada pini knî yi k꞉ii kwodonkwodo a wó, Chóó Lémi u ngomo t꞉âât꞉ââ pyu yoo dy꞉ââ tumo, yepê, Yesu nyinê mgîmî yó, nmo a ńuw꞉o yó. ");
INSERT INTO yle_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ghêlî daa mgîmî ngópu, Yesu ngê pi knî ye yepê, Daa ndîî la ghi tp꞉oo nmyi vy꞉o mwiyé mînê kwo, u kuwó dini ghi ngê n꞉ii ngê a dy꞉ââ noo, yi pini ka am꞉aa diyé. ");
INSERT INTO yle_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yepê, Wanmyi nmy꞉uu nê, ngmênê daanmyinê pyw꞉ee nê, mu kópu u dîy꞉o kwéli anî lê, doo u ntââ y꞉i daangmanmyinê nî. ");
INSERT INTO yle_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nju tpémi y꞉oo noko yepê, Ló y꞉i wa lê, doo u ntââ u ngwo daanmo pyw꞉oo? Noko yepê, Lukwe, kn꞉aa dyámê pee mbêmê wa lê, Kîdiki tpémi y꞉i adîn꞉aa ndiye kîgha dé? ");
INSERT INTO yle_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Noko yepê, Ala kópu a tpapê, Anmyi nmy꞉uu nê, ngmênê daanmyinê pyw꞉ee nê. Kwéli anî lê, doo u ntââ y꞉i daangmanmyinê nî. Noko yepê, Yi kópu knî yi nt꞉u kópu lukwe? ");
INSERT INTO yle_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yi nááli têdê, wéni n꞉ii Nju tpémi ye ndîî ngê doo ya, yi wéni u kuwókuwó wéni. Yi wéni ngê Yesu ghêêdî wo, pi knî ye dpodombiy꞉e mbwolo, yepê, Pini n꞉ii a mbwaambwaa, a ka myewunê kêlîmî, yi pini a pwiyé we, mbwaa knî ngmanyi nda ngê. ");
INSERT INTO yle_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yepê, Puku yedê alanté a tóó, Mbu ngê mbwaa ntee dpî yeede té, yi pini ngê pi yilî mbwaa njini ngê yinté wa yeede té. ");
INSERT INTO yle_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu Chóó Lémi u Ghê Dmi p꞉uu ye doo danê. Yélini yi k꞉ii u kwo nmee kêlîmî, Chóó Lémi ngê yi Ghéni Dmi ghêlî nmo dêpêngê kpo, mu kópu u dîy꞉o Yesu ghêlî k꞉ii u Mî ka daangê diyé wo. ");
INSERT INTO yle_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesu ngê kópuni vyu, pi knî y꞉oo yi kópu yi ny꞉ee ngópu, ngmê knî y꞉oo apê, Chóó Lémi u komo kapî pyu n꞉ii nmo t꞉âât꞉ââ, ndêndê ngê kî vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ngmê knî y꞉oo apê, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, kî vyîlo. Ngmênê woni knî y꞉oo apê, Kêle. Apê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, daa Nkálili wa t꞉aa. ");
INSERT INTO yle_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Apê, Puku yedê alanté a tóó, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, Petîlem wa t꞉aa, Dépidi p꞉aani n꞉ii ta, mu kópu u dîy꞉o Dépidi u tii ńedê pini ngmê. ");
INSERT INTO yle_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wod꞉oo pi knî y꞉oo Yesu u l꞉êê dîy꞉o yoo chaa ngópu. ");
INSERT INTO yle_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ngmê knî y꞉oo u yi doo kwo, Nmî mgîmî, ngmênê kêê p꞉uu daa yé ngópu. ");
INSERT INTO yle_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chóó Lémi u ngomo t꞉âât꞉ââ pyu yoo kada pini knî ye dini ghi n꞉ii ngê diyé dniye, kada pini knî y꞉oo yepê, Lukwe dîy꞉o yi pini dmy꞉oo ńuw꞉o ngópu? ");
INSERT INTO yle_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ngomo t꞉âât꞉ââ pyu knî y꞉oo yepê, Yi pini u momu pini. Yepê, Ntee a mbumu, pi yinté daangma a mbumu. ");
INSERT INTO yle_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pádisi knî y꞉oo yepê, Aa, ye dê dóó nmyo. ");
INSERT INTO yle_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yepê, Kada pini u kwo daangmê kêlîmî mbê wo, Pádisi u kwo myedaangmê kêlîmî mbê wo. ");
INSERT INTO yle_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yepê, Yélini u kwo dê kêlîmî mb꞉anê, dêêpî kópu dyuu yi lama dnyinté a kwo. Yepê, Chóó Lémi u maa dê kn꞉aadi ngmê, yinê amê kpada té. ");
INSERT INTO yle_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikódimês Yesu ka wunê pini n꞉ii loo, yi pini yi yéli yi vy꞉o doo kwo, yepê, A léma. ");
INSERT INTO yle_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Yepê, Dêêpî kópu dyuu mbêmê nmo m꞉ii té, apii? Yepê, Doo u ntââ yi pini módó daanmî ndyîko. Yepê, U kópu dyuu mwiyé ny꞉ee koo, ló kópu ngma a d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nikódimês nkwiti ngópu, kwo, Lukwe dîy꞉o yi Nkálili pi u pee cha ghê. Kwo, Lukwe, m꞉ii Nkálili pi? Kwo, Puku mêdê kp꞉aa té. Kwo, Chóó Lémi u komo kapî pyu Nkálili daangmêwa a ndê. ");
INSERT INTO yle_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pi yintómu p꞉o p꞉o lee dniye, ngmênê Yesu mbu Olipi mbêmê mî kee wo. ");
INSERT INTO yle_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","2","Womumo mw꞉aandiye Yesu Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo mê diyé wo, mbwódo yaa wo. Pi knî y꞉oo a yina ngópu, wod꞉oo doo ndiye kîgha dé. ");
INSERT INTO yle_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dêêpî pyu yoo Pádisi knî yi k꞉ii pyââ ngma a ńuw꞉o ngópu. Yi pyópu u tumu mââ k꞉ii pi knî y꞉oo mgîdî vy꞉o a pywálî dumo. Yi pyópu Yesu ka ńuw꞉o ngópu, pi knî yi ngîma kaa ngópu. ");
INSERT INTO yle_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesu ka kwo, Mââwe. Kwo, Ala pyópu u tumu mââ k꞉ii pi knî y꞉oo da pywálî d꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kwo, Mósisi ngê nmî dêêpî kópu dyuu alanté nmo a kpo, apê, Yinté kópu n꞉ii ngê choo d꞉uud꞉uu knomomê, yini chêêpî ngê dmyinê vyee, ghê dmyina a ng꞉êênî. Kwo, Yi kópu p꞉uu ló kópu nmo ngmanyi vyi? ");
INSERT INTO yle_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yesu dnye dódó, alanté dnye nuw꞉o, apê, Yesu ngê ala kópu nmo a tpapê, Kî pyópu vya yó, ye Lóma tpémi ye u nkwo wanmî vyi, Yesu ngê u yi a kwo, Nmyi d꞉aa dmi nê kââdî. Ngmênê ala kópu wa vyi knomomê, Nangê vy꞉a, ye pi knî ye wanmî vyi, Yesu ngê Mósisi u dêêpî kópu dyuu daa chââchââ. Yinté dnye nuw꞉o, ngmênê Yesu ngê kópu ye daa vyu, k꞉ame ye ghê wo, wod꞉oo kóópyââ ngê têpê mbêmê doo d꞉êê. ");
INSERT INTO yle_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Y꞉i dnye kwo, u kwo mudnye póó, Yesu ngê mbwó ye yedê pyidu ngê, yepê, N꞉ii ngê dono daangmê d꞉uu ngê, yini ngê mwiyémwiyé chêêpî a ngî ngê, ala pyópu ngê d꞉ee ngê, u ngwo vya ngê. ");
INSERT INTO yle_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wod꞉oo k꞉ame mê ghê wo, têpê mbêmê mêdoo d꞉êê. ");
INSERT INTO yle_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yi kópu dini ghi n꞉ii ngê ny꞉ee ngópu, ngmêngmênté doo lêpî, vy꞉ee mwiyé lee dniye. Pi knî y꞉oo yi pyópu Yesu ka a kuwo ngópu. ");
INSERT INTO yle_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu ngê mbwó mêdê pyidu ngê, yi pyópu ka kwo, Pi anyi dê pwiyé dmi? Kwo, Ṉyîkondyîko pyu daangma a tóó? ");
INSERT INTO yle_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yi pyópu ngê kwo, Mââwe, pi daangma a tóó. Yesu ngê kwo, Myedaanî ndyîko ngi. Kwo, Chi lêpî, dono kidimongê d꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","U kuwó dini ghi ngê Yesu pi knî ye modoo danêmbum, yepê, Ala nê, ala dyámê pê u pywápê. Yepê, N꞉ii ngê ada a yâmuyâmu nê, mgîdî vy꞉o daadî paa, pywápê u wo adî paa. Yepê, Yi pywápê Ghê Kamî u Kn꞉ââ. ");
INSERT INTO yle_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pádisi knî y꞉oo kwo, Ye kópu m̱o nmo chi vyi. Kwo, Ló pini m꞉uu ngê dê ngee ngi? Kwo, Doo u ntââ ye kópu ndê kópu ngê nmo daanyi pyódu. ");
INSERT INTO yle_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu ngê yepê, K꞉omo tpile pi ngê daa ngêêpî nê, ngmênê ndê kópu nmye yinî tpapê, mu kópu u dîy꞉o kwéli nê ndê wo a lama ka tóó, kwéli am꞉aa diyé, a lama mye tóó. Yepê, Kwéli nê ndê wo nmyi lama daa tóó, kwéli am꞉aa diyé nmyi lama myedaa tóó. ");
INSERT INTO yle_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yepê, Lukwe dîy꞉o dyámê u l꞉êê ghi dmi mbêmê nmye kóté kîgha nê. ");
INSERT INTO yle_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yepê, Pi dînîngmê kóté kîgha. Yepê, Pi wonî kóté kîgha té, ndêndê ngê pînî kóté kîgha té, mu kópu u dîy꞉o daa a mo n꞉aa tóó. Yepê, N꞉ii ngê a dy꞉ââ noo, u k꞉ii nye tóó mo. ");
INSERT INTO yle_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yepê, Dêêpî kópu dyuu puku yedê alanté a kwo, Pi miyó dê y꞉oo kópu mu ngmidi ayi vyi ngmê, yi kópu ndê kópu. ");
INSERT INTO yle_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yepê, Daa a mo a kópu yidî vyi, ngmênê n꞉ii ngê a dy꞉ââ noo, u kópu vyîlo myeyidê vyi. Yepê, M꞉aa yi vyîlo, myeyinê wunê kêmakêma noo. ");
INSERT INTO yle_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pádisi knî y꞉oo kwo, Angênê m̱î? Yesu ngê yepê, Dmyongê mya noo, M꞉aa nmyi lama myedaa tóó. Yepê, W꞉ee mya noo, ye M꞉aa nmyi lama myepî tóó. ");
INSERT INTO yle_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yi kópu yilî Yesu ngê ye vyi too, dini ghi n꞉ii ngê doo ndiye kîgha dé. Chóó Lémi u ngomo k꞉oo vyi too, pi knî y꞉oo Chóó Lémi ka ndapî kwéli dnyimo yém. Kada pini knî y꞉oo u yi y꞉e doo kwo, Yesu nmî mgîmî, ngmênê daa mgîmî ngópu, mu kópu u dîy꞉o u vyee u dye ghi daangê yó. ");
INSERT INTO yle_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu ngê pi knî ye yepê, Dini ghi n꞉ii ngê anî lê, wanmyi nmy꞉uu nê, daanmyinê pyw꞉ee nê. Yepê, Chóó Lémi ngê nmyi dono u kuwó daawa kéé té, yinté amy꞉ee pw꞉oo dmi. Yepê, Kwéli anî lê, doo u ntââ y꞉i daangmanmyi nî. ");
INSERT INTO yle_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nju tpémi y꞉oo noko yepê, Ala kópu ka tpapê, Kwéli wanî lê, doo u ntââ y꞉i daangmanmyi nî. Noko yepê, Yi kópu u nt꞉u kópu lukwe, ndoo apê chóóchóó wa vy꞉a? ");
INSERT INTO yle_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu ngê yepê, Nmyo dyámê mbêmê tpémi. Yepê, D꞉aa dyámê mbêmê pi, ngmênê nmyi pwo nê ndê wo. ");
INSERT INTO yle_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yepê, Yi kópu u l꞉êê dîy꞉o u ngwo nmye dî vyi, nmyed꞉ê, Chóó Lémi ngê nmyi dono u kuwó daawa kéé té, yinté amy꞉ee pw꞉oo dmi. Yepê, A pi, A chóó n꞉aa tóó. Yepê, Yi kópu ka daanmyi kêlîmî mbê dmi, ye Chóó Lémi ngê nmyi dono u kuwó daawa kéé té, yinté amy꞉ee pw꞉oo dmi. ");
INSERT INTO yle_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nju tpémi y꞉oo kwo, Nyi n꞉uu? Yesu ngê yepê, A pi dye ghi yintómu munmyenoo a tpapê, ngmênê a ka dp꞉ee kêlîmî té. ");
INSERT INTO yle_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yepê, Kópu yilî nmyi p꞉uu anî vyi, u ngwo anî ndyîko nmyo, ngmênê a chóó a kópu dyuu nmye daanî vyi té. Yepê, Pini n꞉ii ngê a dy꞉ââ noo, k꞉omodanê pee tp꞉oo p꞉uu daa t꞉a. Yepê, Kópuni a ka a vyi too, yi kópu vyîlo nmye yinî tpapê too. ");
INSERT INTO yle_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nmî Mî p꞉uu ye doo danê, ngmênê pini n꞉ii p꞉uu ye doo danê, yi pini dêpê w꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Dêpê w꞉ee ngópu, wod꞉oo Yesu ngê yepê, Dini ghi n꞉ii ngê Chóó Lémi u Pi Ndêndê mudu y꞉i wanmyi km꞉êê ngmê, u ngwo anmyinê w꞉ee ngmê, a pi, A chóó n꞉aa tóó. Yepê, Ala kópu amyenmyinê w꞉ee ngmê, A mo kópu daangmanî d꞉uu, M꞉aa ngê kópuni a ka a vyi too, vyîlo nmye yinî tpapê té, kópu nmye daamonî vyi. ");
INSERT INTO yle_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yepê, N꞉ii ngê a dy꞉ââ noo a p꞉uu a t꞉a, a mo dêpê kuwo noo, mu kópu u dîy꞉o dye ghi yintómu u nuu u kópu yinî d꞉uud꞉uu too. ");
INSERT INTO yle_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yélini y꞉oo yi kópu ny꞉ee tumo, yi yéli yi vy꞉o pi yilî Yesu ka kêlîmî mbê wo. ");
INSERT INTO yle_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","32","Nju tpémi yi vy꞉o yélini Yesu ka kêlîmî mbê wo, Yesu ngê yepê, Dye ghi yintómu a ka anmya a ng꞉aa, ye ndêndê ngê a p꞉uu ndiye pyu ngê anmyi pyaa dmi, Pi Ndêndê nmyi lama wa yââ, dpodoni módó nmye dódó ngmê, yinêwa chedê. ");
INSERT INTO yle_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yesu ka kwo, Nmî kn꞉ââ mu ngmidi Epîlaham, nmo u yoo. Kwo, Pi p꞉uu módó dênmee dpodo. Kwo, Lukwe dîy꞉o módó dpodo u pi nmo chi vyi? ");
INSERT INTO yle_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu ngê yepê, Ndê kópu nmye yinî tpapê, pini n꞉ii ngê dono a d꞉uud꞉uu, yini Setan p꞉uu módó a dpodo, doo u ntââ u módó dpodo u wépi daawa puwâ. ");
INSERT INTO yle_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","36","Yepê, Doo u ntââ yi módó dpodo u mênê daanmyi pwii dmi, ngmênê mââwe ndîî tp꞉oo u ntââ, yinêwa pw꞉ii nmyo. ");
INSERT INTO yle_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yepê, K꞉omo tpile nmyo Epîlaham u yoo, ngmênê a vyee u yi nmye a kwo, mu kópu u dîy꞉o a kópu dyuu u wépi dmye pwaa ngmê. ");
INSERT INTO yle_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yepê, M꞉aa ngê kópuni a ka kêma too, yi kópu vyîlo nmye yinî tpapê té, ngmênê kópuni nmyi mî ngê nmye a vyi too, vyîlo vy꞉ee d꞉uud꞉uu t꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yesu ka kwo, Nmî mî Epîlaham, nmo u yoo. Yesu ngê yepê, Nmyi too pee dmi Epîlaham u tii ńedê a pyede, ngmênê na a ka dp꞉ee u yoo vy꞉o yéli. Yepê, W꞉ee Epîlaham u yoo ndêndê, ye kópuni doo d꞉uud꞉uu dé, yi kópu myep꞉ee d꞉uud꞉uu t꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yepê, Chóó Lémi ngê ndê kópu n꞉ii a ka vyi too, dye ghi yintómu yi ndê kópu vyîlo nmye yinî tpapê too, ngmênê a vyee nmyi mênê a tóó. Yepê, Epîlaham ngê yinté kópu daangmê d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yepê, Nmyi mî ngê kópuni a d꞉uud꞉uu too, yi kópu vyîlo vy꞉ee d꞉uud꞉uu t꞉oo. Yesu ka kwo, Dp꞉oo maadî tp꞉ee dé. Kwo, Nmî Mî mu ngmidi, Chóó Lémi. ");
INSERT INTO yle_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu ngê yepê, Chóó Lémi ndêndê ngê wo nmyi mî, ye a nuu ghi nmyi nódo pê tóó, mu kópu u dîy꞉o Chóó Lémi ngê yinê a dy꞉ââ noo, al꞉ii u ngwo nê loo. Yepê, Daa a chóó nê loo, ngmênê yinê a dy꞉ââ noo. ");
INSERT INTO yle_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yepê, Kópuni nmye n꞉aa tpapê too, lukwe dîy꞉o dênmyinê wopwe t꞉oo? Yepê, Mu kópu u dîy꞉o a kópu dyuu u yi nmye daa kwo. ");
INSERT INTO yle_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yepê, Nmyi mî Setan, nmyo u yoo. Yepê, U kópu dyuu vyîlo vy꞉ee yâmuyâmu ngmê. Yepê, Mwiyémwiyé dini ghi ngê pi vyee pyu ngê doo a ya, k꞉omodanê pyu ndîî, ndê kópu pee tp꞉oo u mênê daa tóó. Yepê, Dini ghi n꞉ii ngê a k꞉omodanê yédi, chóó u nuu u kópu ye d꞉uud꞉uu too, mu kópu u dîy꞉o k꞉omodanê pyu, mye k꞉omodanê u kn꞉ââ. ");
INSERT INTO yle_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yepê, Ndê kópu nmye yinî tpapê ngê, yi kópu u l꞉êê dîy꞉o a ka dênmyinê kêlîmî nyédi. ");
INSERT INTO yle_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yepê, Nmyi vy꞉o n꞉uu ngê dono a p꞉uu ngmêdê m꞉uu? Yepê, A dono daa tóó. Yepê, A kópu yintómu ndê kópu dé, lukwe dîy꞉o a ka dp꞉ee kêlîmî té? ");
INSERT INTO yle_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yepê, Yélini Chóó Lémi u yoo, Chóó Lémi u dnye a nyêmî ngmê. Yepê, W꞉ee Chóó Lémi u yoo, a dnye p꞉ee nyêmî ngmê. ");
INSERT INTO yle_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nju tpémi y꞉oo Yesu ka kwo, Ala kópu ndêndê ngê m̱꞉uu nmî vyu, Nyi pi dódó pyu, my꞉ii ghéti. ");
INSERT INTO yle_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu ngê yepê, Kêle, d꞉aa ghéti. Yepê, M꞉aa u pi n꞉aa kmîmî, a pi nmyinê ghîpîghîpî ngmê. ");
INSERT INTO yle_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yepê, A chóó a pi daanî kmîmî. Yepê, Pi ngmêka tóó, n꞉ii ngê u yi a kwo, Nê u pi ndîî ngê pyaa we, yi pini ngê nmyi kópu dyuu yinêwa vya té. ");
INSERT INTO yle_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yepê, Ndê kópu nmye yinî tpapê, N꞉ii ngê a kópu dyuu adî d꞉uud꞉uu, yini daawa pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nju tpémi y꞉oo kwo, Ala ngwo ntênê nmî lama kêdê yââ, Ndêndê ngê chi ghéti. Kwo, K꞉omo tpile Epîlaham pwene, Chóó Lémi u komo kapî pyu yoo mye pw꞉oo dniye, ngmênê ala kópu nmo chi vyi, N꞉ii ngê a kópu dyuu adî d꞉uud꞉uu, yini daawa pw꞉onu. Kwo, Chi ghéti. ");
INSERT INTO yle_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kwo, Nmî kn꞉ââ Epîlaham pwene. Kwo, Lukwe dîy꞉o Epîlaham nye chêêlîchêêlî. Kwo, Chóó Lémi u komo kapî pyu yoo kîmye pw꞉oo dniye. Kwo, M̱i nanê dê knî? ");
INSERT INTO yle_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu ngê yepê, A chóó a chili wonî dimi ngê, ye a pi k꞉omodanê ngê pê koko. Yepê, N꞉ii ngê a chili ndêndê ngê a dimi ngê, yi pini M꞉aa, pini n꞉ii p꞉uu ala kópu nmye tpapê ngmê, yi pini nmî yâpwo. ");
INSERT INTO yle_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yepê, Daa nmyi lama pini, ngmênê a lama pini. Yepê, Ala kópu nmye wudî vyi, Daa a lama pini, ye nmye pînê k꞉omodanê, p꞉aa nmyo ntee pini. Yepê, Ngmênê a lama pini, u kwo n꞉aa ng꞉aa, u pono n꞉aa vyápê. ");
INSERT INTO yle_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yepê, Nmyi kn꞉ââ Epîlaham u nuw꞉o mb꞉aamb꞉aa ngê a pyodo, mu kópu u dîy꞉o a l꞉êê dîy꞉o Chóó Lémi ngê wéni n꞉ii a ngmidi ngê, yi wéni u nuw꞉o k꞉oo doo a y꞉enê, u gha mb꞉aamb꞉aa ngê u ngwo a pyodo. ");
INSERT INTO yle_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nju tpémi y꞉oo kwo, Kidimê k꞉omodanê. Kwo, Nyi tp꞉ee. Kwo, M̱꞉ââ daa limoy꞉a, Epîlaham dipi módu. ");
INSERT INTO yle_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu ngê yepê, Ndê kópu nmye yinî tpapê, Epîlaham ghêlî daa ta, ngmênê a pi alanté doo a ya, A chóó n꞉aa tóó. ");
INSERT INTO yle_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nju tpémi y꞉oo noko yepê, Lukwe dîy꞉o kî pini ngê Chóó Lémi u pi u pyimo a t꞉emî. Noko yepê, Vya koo, wod꞉oo chêêpî knî ngma a ngî ngópu, daa kêmakêma Yesu ngê pî dy꞉ee tumo, ngmênê p꞉ee ye y꞉aa wo, Chóó Lémi u ngomo a kuwo ngê. ");
INSERT INTO yle_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yélini yi k꞉ii Yesu p꞉uu nmee ndiye, Yesu u k꞉ii nipi nmee paa. Yi ngwo pi ngmênmî módu, my꞉oo doo ya, yinté a ta. ");
INSERT INTO yle_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nmî vy꞉o pini ngmê Yesu ka póó wo, kwo, Mââwe. Kwo, Kî pini my꞉oo ka tóó, n꞉uu u dono u l꞉êê dîy꞉o my꞉oo ta, chóó u dono u l꞉êê dîy꞉o ó u pye mî yi dono u l꞉êê dîy꞉o? ");
INSERT INTO yle_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu ngê nmopê, Kî pini ngê dono daa d꞉uu ngê, u pye mî y꞉oo dono myedaa d꞉uu ngópu, ngmênê kî pini my꞉oo a ta, mu kópu u dîy꞉o pi knî y꞉oo Chóó Lémi u wêdêwêdê p꞉uu paa m꞉uu y꞉e. ");
INSERT INTO yle_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Nmopê, Pini n꞉ii ngê a dy꞉ââ noo, doo u ntââ u dpodo u wépi daanmo puwâ, mu kópu u dîy꞉o ala w꞉êênî nmo pyede. Nmopê, Nê, ala dyámê u wuu. Nmopê, Dini ghi n꞉ii ngê wa ńuw꞉o nê, yi ngwo mgîdî wa a ghay, doo u ntââ dpodo daamunmyi dóó ngmê. ");
INSERT INTO yle_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yi kópu nmo yi vyu, wod꞉oo tpî kuwó têpê mbêmê pywé ngê, têpê u ngwo kn꞉êê kwólu, yi pini ngwolo dê u ngwo tpidi doo, yi pini ka kwo, Chi lêpî, Sailówam mbwááni lêê u kwo nyi kwidi. ");
INSERT INTO yle_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","(Yi mbwááni lêê u pi nmînê nmo, Dyede u mbwaa.) Wod꞉oo yi pini loo, yi mbwááni lêê u kwo mî kpêê wo, yélî mî módu, u ngwo mêdê diyé wo. ");
INSERT INTO yle_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yélini yi vy꞉o yi pini dpîmo kwo, myenté yélini y꞉oo ndapî dmyinê têdê dnyimo mumu, yi pini u l꞉êê dîy꞉o noko dnye póó, noko yepê, Pini n꞉ii dpîmo ndapî dmyinê, kî vyîlo, apii? ");
INSERT INTO yle_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ngmê knî y꞉oo apê, Kî vyîlo, woni knî y꞉oo apê, Kêle, daa vyîlo, ngmênê yi pini ntee pini. Yi pini ngê chóó yepê, Ala nê vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","U kwo póó dniye, kwo, Ngwolo dê lukwe ngê dê pywálî dê? ");
INSERT INTO yle_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yepê, Pi ngmê u pi Yesu, yi pini ngê têpê dê kn꞉êê kwolo, a ngîma dê d꞉ii, a ka dê, Chi lêpî, Sailówam mbwááni lêê u kwo nyi kwidi. Wod꞉oo dî lê, dîn꞉aa kudu, yélî u ngwo dîn꞉aa m꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kwo, Angênê yi pini? Yepê, Ndoo, a lama daa tóó. ");
INSERT INTO yle_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pini n꞉ii my꞉oo ta, Pádisi knî ye ńuw꞉o ngópu. ");
INSERT INTO yle_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Wéni n꞉ii ngê Yesu ngê têpê kn꞉êê kwólu, yi pini ngîma dyîngo, ngwolo dê u ngwo pyi doo, yi wéni lîme wo. ");
INSERT INTO yle_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pádisi yoo yi pini ka mye póó dniye, kwo, Ṉgwolo dê lónté nyi pywálî dê? Yi pini ngê yepê, Yesu ngê têpê kn꞉êê kwolo, a ngîma d꞉ii, nî lê, n꞉uu kudu, ala ngwo yéli m꞉aanî y꞉enê. ");
INSERT INTO yle_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pádisi ngmê knî y꞉oo apê, Kî kópu pini n꞉ii ngê d꞉uu, daa Chóó Lémi ka a ndê wo, yi dpodo lîme wo ngê dóó. Woni knî y꞉oo apê, Kêle. Apê, Chóó Lémi ngê nmo a dy꞉ââ ngê. Apê, N꞉ii ngê dono dpî d꞉uu, yi pini ngê yinté dpodo ndîî d꞉uudpî dóó. Yi nuw꞉o miyó ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wod꞉oo yi pini ka mê póó dniye, kwo, Pini n꞉ii ngê ṉgwolo dê pywálî dê, nangê lónté pini? Yi pini ngê yepê, Chóó Lémi u komo kapî pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kada pini yoo u kwo daa kêlîmî mbê dniye, apê, Kî pini nmo ka k꞉omodanê, apê, my꞉oo dêpwo a ya u ngwo daa ta. Wod꞉oo yi pini u pye mî ye pi knî ngmê dy꞉ââ ngópu, yepê, A pwiyé dniye. ");
INSERT INTO yle_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","21","Yi taa knopwo, wod꞉oo ye póó dniye, yepê, Mumdoo kî dpî tp꞉ee? Yepê, Nyââ, kî nyi tp꞉ee. Yepê, Mumdoo my꞉oo doo ya, u ngwo a ta? Yepê, Nyââ, my꞉oo doo ya, u ngwo a ta. Yepê, Yélî lónté maa m꞉uu? Yepê, Ndoo, yi kópu nyi lama daa tóó. Yepê, Pini n꞉ii ngê ngwolo dê pywálî dê nyi lama myedaa tóó. Yepê, Mââwe yila, nmyi chóó u kwo póó dmyeno. ");
INSERT INTO yle_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yi kópu vyi ngópu, mu kópu u dîy꞉o kada pini knî ye nkîngê mbê knopwo. Kada pini knî y꞉oo ala kópu wunê mwiyé a vyi ngópu, apê, N꞉ii ngê wa vyi, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, vyîlo yi Yesu, yi pini dpî kéé yó, u yoo kuwa dpî kaa yó. ");
INSERT INTO yle_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yi kópu u l꞉êê dîy꞉o yi pini u pye mî nkîngê mbê knopwo, kada pini knî ye yepê, Mââwe yila, nmyi chóó u kwo póó dmyeno. ");
INSERT INTO yle_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pini n꞉ii my꞉oo doo ya myombó kwo, Chóó Lémi ngê kp꞉aani, ndêndê ngê chi danê. Kwo, Nmî lama ka tóó, pini n꞉ii u pi nmo chi vyi, yi pini dono pyu. ");
INSERT INTO yle_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yi pini ngê yepê, A lama daa tóó, dono pyu ó daa dono pyu. Yepê, Kópu mu ngmidi a lama ka tóó, my꞉oo noo ya, ala ngwo yélî mênî y꞉enê. ");
INSERT INTO yle_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","U kwo póó dniye, kwo, Lukwe ṉga ngmê md꞉o? Kwo, Ṉgwolo dê lónté pywálî dê? ");
INSERT INTO yle_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yi pini ngê nkwiti too, yepê, Wunê nmye kîdî vyi, a ka dpîp꞉e ng꞉aa té. Yepê, Lukwe dîy꞉o yi kópu am꞉ii ny꞉ee ngmê? Yepê, U yi nmye a kwo, P꞉uu ndiye pyu ngê am꞉ii pyaa dmi? ");
INSERT INTO yle_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","U ngwo u kwo a tpêpwo dniye, kwo, Nyi yi pini p꞉uu ndiye pyu, nmo Mósisi p꞉uu ndiye pyu yoo. ");
INSERT INTO yle_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kwo, Nmî lama ka tóó Chóó Lémi Mósisi ka doo a danê, ngmênê yi pini kwéli a ndê wo nmî lama daa tóó. ");
INSERT INTO yle_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yi pini ngê yepê, Ye lónté kópu? Yepê, K꞉omo tpile a ngwolo dê kî pywálî dê, ngmênê kwéli a ndê wo, nmyi lama daa tóó. ");
INSERT INTO yle_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yepê, Nmî lama ka tóó, Chóó Lémi dono pyu ka d꞉uudpî ng꞉aa mb꞉anê, ngmênê pini n꞉ii ngê Chóó Lémi a chââchââ ngê, u nuu u kópu ye d꞉uud꞉uu too, yi pini ka Chóó Lémi dpî ng꞉aa mb꞉anê. ");
INSERT INTO yle_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yepê, K꞉omo tpile my꞉oo nî ta, ngmênê yi pini ngê a ngwolo dê kî pywálî dê. Yepê, Yinté kópu pi doongmê nyongo, pi ngmê ngê doongmê d꞉uu ngê, kn꞉ââ Chóó Lémi ngê dyámê pê mwâ a l꞉âmo ngê, nkoo nmo. ");
INSERT INTO yle_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yepê, Yi pini Chóó Lémi ka wodêpê ndê wo, ye yi kópu ndîî daapî d꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yi pini ka kwo, Nyi pi dono tp꞉oo, dono vy꞉o nyi kaa wo. Kwo, Doo u ntââ daanyi ndiye kîgha nmo. Wod꞉oo yi pini u yoo kuwa kaa ngópu. ");
INSERT INTO yle_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ngê yi kópu dini ghi n꞉ii ngê nyongo, apê, Yi pini u yoo kuwa kêdê kaa ngmê, wod꞉oo y꞉i a pyw꞉ângo, u kwo póó wo, kwo, Chóó Lémi u Pi Ndêndê ka nye kêlîmî? ");
INSERT INTO yle_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yi pini ngê Yesu ka kwo, Mââwe. Kwo, U pi a ka vyi ngi, u ngwo u kwo anî kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu ngê kwo, Awêde chi m꞉uu. Kwo, Pini n꞉ii k꞉ii dpo danêmbum mo, nê vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yi pini Yesu yu km꞉ee yu mbodo dê y꞉e ghê wo, Yesu ka kwo, A Lémi, ṉga nînê kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu ngê kwo, Dyámê mbêmê nê loo, mu kópu u dîy꞉o nê, Yoo n꞉uu chámê. Nê, Yélini my꞉oo a pyede, yi ngwolo an꞉uu pywálî té, yélî amê m꞉uu ngmê, nê, yélini yinê ye kópu mb꞉aamb꞉aa ngê wunê nuw꞉onuw꞉o too, yi nuw꞉o dmi anîmo mbuknwe, pi my꞉oo ntee pini ngê wa pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pádisi knî ngmê y꞉i myednye ya, Yesu ka kwo, Lukwe, ala kópu nye tpapê, My꞉oo nmyeno pyede? ");
INSERT INTO yle_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu ngê yepê, Pini n꞉ii my꞉oo a tóó, maa dpî kn꞉aadi. Yepê, Ala kópu nmye tpapê ngópu, nmyimo, Tpile yintómu mb꞉aamb꞉aa ngê nmo y꞉enê té. Yepê, Lukwe dîy꞉o maa mb꞉aa nmyi kn꞉aadi ngópu. Yepê, Lukwe dîy꞉o nmyi chóó my꞉oo nmyi yaa dniye, maa mb꞉aa u ngwo nmyi kn꞉aadi ngópu. Yepê, Nmyi dono yilî chedê ngê daawa pyaa dmi. Yepê, Maa mb꞉aa u kópu dyuu wodpîp꞉e ny꞉ee ngópu, ye daap꞉ee kn꞉ââ dé, u ntââ nmyi dono chedê ngê pî pyaa dniye. ");
INSERT INTO yle_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu ngê Nju tpémi ye yepê, Ndê kópu nmye ngmên꞉aa tpapê. Yepê, Sipi w꞉uu mbwa k꞉oo dini ghi n꞉ii ngê a wee, n꞉ii ngê keńe ye d꞉uuwodê kpêmî, ngmênê mbwa mbêmê dpî lóó, ye yi pini kpáápi. ");
INSERT INTO yle_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yepê, Pini n꞉ii ngê keńe dpî kpêmî, mbwa k꞉oo u ngwo dpî kee, yi pini sipi y꞉eey꞉ee pyu. ");
INSERT INTO yle_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yepê, Mbwa y꞉enê pyu ngê keńe yi pini ka dpî kpêmî, k꞉oo u ngwo dpî kee, ye dpî mbwólu, yi pi dmi ngmêngmênté a tpapê too, yi kada dpî ghê, nté nmy꞉uu u l꞉êê dîy꞉o u ngwo dpî pwii dmi. ");
INSERT INTO yle_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yepê, Dini ghi n꞉ii ngê dpo pwii dmi, yi kada dpî ghê, a yâmuyâmu ngópu, u dnye yi lama. ");
INSERT INTO yle_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yepê, Kn꞉aa pini p꞉uu daawa kaa dmi, awêde u kwo wa mbêpê dmi, mu kópu u dîy꞉o u dnye daa yi lama. ");
INSERT INTO yle_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yi kópu dêpê w꞉ee ngópu, mu kópu u dîy꞉o Yesu ye doo mgongo, ");
INSERT INTO yle_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","wod꞉oo Yesu ngê mgongo ye m꞉uu kwólu, yepê, Ala ndê kópu nmye yinî tpapê. Yepê, Nê sipi knî yi keńe t꞉âmo ndêndê. ");
INSERT INTO yle_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yepê, Yélini y꞉oo sipi w꞉uu a y꞉enê ngmê, kpáápi pââ ndîî dé, ngmênê sipi knî y꞉oo yi dnye dmi daa nyêmî ngópu. ");
INSERT INTO yle_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yepê, Nê keńe t꞉âmo ndêndê. Yepê, N꞉ii a pi ngê wa a kee, wanî ngee, adî koko, amaa pywuwópywuwó, u nté adîn꞉aa a pyw꞉êmî. ");
INSERT INTO yle_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yepê, Kpáápi u nuw꞉o mu ngmidi, u yi u ngwo a kwo, Sipi w꞉uu nî t꞉âmo té, my꞉aa vya té. Yepê, Ala kópu u l꞉êê dîy꞉o nê loo, nê, Yi nuw꞉o dmi n꞉uu ngmêê, ghê kamî ye n꞉uu y꞉oo, yi ya mb꞉aamb꞉aa ngê u ngwo paa pyaa we. ");
INSERT INTO yle_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yesu ngê yepê, Nê sipi y꞉eey꞉ee pyu mb꞉aa. Yepê, U ntââ a sipi knî yi l꞉êê dîy꞉o wa vya nê, ye daanî mbêpê. ");
INSERT INTO yle_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yepê, N꞉ii daa sipi w꞉uu chóó, n꞉ii ngê sipi ka vyuwo têdê ndapî a kmênêkmênê ngê, yi pini daa sipi y꞉eey꞉ee pyu mb꞉aa. Yepê, N꞉ii ndapî u l꞉êê dîy꞉o a dpodo yédi, dini ghi n꞉ii ngê chii w꞉ââ w꞉uu dpo lê, ye sipi w꞉uu dpo kuwo, dpî mbêpê, dpo, W꞉ââ ngê wa kiye nê. Yepê, Wod꞉oo w꞉ââ knî y꞉oo sipi woni a vyee tumo, woni a ngm꞉ii kîgha tumo. ");
INSERT INTO yle_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yepê, Yi pini dpî mbêpê, mu kópu u dîy꞉o daa yi sipi w꞉uu chóó, u kwo d꞉uudpî ch꞉anê dmi. ");
INSERT INTO yle_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Yepê, Nê sipi w꞉uu chóó. Yepê, M꞉aa u lama ntee n꞉aa tóó, sipi knî yi lama yinté myenî tóó. Yepê, M꞉aa A lama ntee a tóó, sipi w꞉uu a lama yinté mye kwo. Yepê, U ntââ sipi knî yi l꞉êê dîy꞉o wa vya nê, ye daanî mbêpê. ");
INSERT INTO yle_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yepê, Sipini knî kuwa a m꞉ii té, daa ala sipi w꞉uu vy꞉o sipi dé, ngmênê yi sipi mya a sipi dé, yintómu anê ńuw꞉o té, a dnye amyednyi nyêm, ala sipi w꞉uu vy꞉o anê kaa té, sipi w꞉uu mu ngmidi ngê amî pyódu, yi kada pini mu ngmidi ngê yinê adî y꞉eey꞉ee dé. ");
INSERT INTO yle_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yepê, A nuu ghi M꞉aa nódo a tóó, mu kópu u dîy꞉o daanî kede, pwopwo u wépi daanê puwâ. Yepê, A ghê wanî y꞉oo, myombó amênê dy꞉o. ");
INSERT INTO yle_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yepê, A vyee ye wanî kwódu knomomê, ye doo u ntââ daawa vya nê. Yepê, Ngmênê ye daanî kwódu, a chóó a nuw꞉o ngê a ghê wanî y꞉oo. Yepê, M꞉aa u pi ngê a ghê wanî y꞉oo, myombó amênê dy꞉o. Yepê, M꞉aa ngê a ka pê, Yi kópu dê dpî d꞉uu dé. ");
INSERT INTO yle_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yi kópu knî yi l꞉êê dîy꞉o Nju tpémi yi nuw꞉o dmi u mo u mo ngê mê pyaa dniye. ");
INSERT INTO yle_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Woni knî y꞉oo wo yéli ye yepê, Kî pini nkono kmêna ngma a kwo, u ngwo dê ghéti. Yepê, U kwo kîdmyemê ng꞉aa. ");
INSERT INTO yle_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wo yéli y꞉oo u nkwo yepê, Pini n꞉ii u kmêna a kwo yédi, yinté daa danê yédi. Yepê, Doo u ntââ kmêna ngê ngwolo kopwe d꞉uudpî pyi. ");
INSERT INTO yle_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","M꞉ââ yintómu yi k꞉oo tpii yópu yi dye ghi ngê, Nju tpémi y꞉oo naa ngma a kuwo ngópu, Chóó Lémi u ngomo u l꞉êê dîy꞉o. ");
INSERT INTO yle_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu u k꞉ii yi nááli têdê nmî lee dniye, Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo nmî kee dniye, ghini n꞉ii u pi Solomon u ngomo ghi, y꞉i nmee paa. ");
INSERT INTO yle_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nju tpémi yi kada pini knî y꞉oo Yesu a yina ngópu, u kwo póó dniye, kwo, Dye ghi nmo mêkidimê dówodówo. Kwo, T꞉ââ nmo dê diy꞉a. Kwo, Nmo namê k꞉omodanê. Kwo, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, n꞉ii nmo t꞉âât꞉ââ, ye nyi vyîlo? ");
INSERT INTO yle_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu ngê yepê, Wunê nmye monî vyu, ngmênê a ka dpîp꞉e kêlîmî mbê dniye. Yepê, M꞉aa u pi ngê kópuni yilî n꞉aa d꞉uud꞉uu ngê, yi kópu knî y꞉oo nmye yinê wodê kêma noo, ");
INSERT INTO yle_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ngmênê nmyi ngwolo dmi nmyi kuwo ngópu, yi kópu yilî dpîp꞉e m꞉uu ngópu, mu kópu u dîy꞉o dp꞉ee a sipi w꞉uu vy꞉o yéli. ");
INSERT INTO yle_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yepê, A sipi knî y꞉oo a dnye yi ng꞉aa, a lama ka pyede, wunê yâmuyâmu noo. ");
INSERT INTO yle_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yepê, Ghéni n꞉ii chedê ngê daawa pyódu, ye n꞉aa yémî ngê, u l꞉êê dîy꞉o daangmêwa dyênê. Yepê, Pi ngmê ngê a kêlê myedaangmêwa a pwââ. ");
INSERT INTO yle_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yepê, N꞉ii ngê u yi adî kwo, awo, Kwulo nê pwaa té, yepê, yi pini wa dîpî, mu kópu u dîy꞉o u wêdêwêdê têdê. Yepê, M꞉aa ngê a ka yinê a kê too, u wêdêwêdê pââ ndîî, pi ngê kwulo daawa a pwaa té. ");
INSERT INTO yle_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yepê, M꞉aa ntee, nê mye yinté. ");
INSERT INTO yle_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nju tpémi y꞉oo noko yepê, Lukwe dîy꞉o kî pini ngê Chóó Lémi u d꞉aa wunê kââdîkââdî. Noko yepê, Vya koo, wod꞉oo myombó chêêpî knî ngma a ngî ngópu, apê, Yesu ngê nmî dy꞉ee té. ");
INSERT INTO yle_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu ngê yepê, M꞉aa u pi ngê nmyi ngîma kópu mb꞉aa yilî nî d꞉uu ngê. Yepê, Lóni u l꞉êê dîy꞉o a vyee u yi nmye a kwo? ");
INSERT INTO yle_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nju tpémi y꞉oo kwo, Daa kópu mb꞉aa ngmê u l꞉êê dîy꞉o m̱yee u yi nmo a kwo, ngmênê k꞉omo tpile nyi nmo ntee pini, ngmênê ala kópu nye tpapê, Chóó Lémi u pi ntoo, a pi yintoo ngê n꞉aa pyépi. ");
INSERT INTO yle_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","Yesu ngê yepê, Yélini y꞉oo Chóó Lémi u kópu wunê a ny꞉ee ngópu, Chóó Lémi ngê yepê, Nmyo nê ntee yéli. Yepê, Nmyi chóó nmyi puku yedê yi kópu a tóó, doo u ntââ u wépi daanmyi pwaa ngmê. Yepê, Chóó Lémi ngê dyámê mbêmê chóó yinê a dy꞉ââ noo, u ngwo nmye nî vyu, nmyenoo, Nê Chóó Lémi Tp꞉oo, yepê, doo u ntââ yi kópu u wépi myedaanmyi pwaa ngmê. ");
INSERT INTO yle_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yepê, M꞉aa u dpodo wodînî dódó ngê, ye a ka daap꞉ee ng꞉aa té. ");
INSERT INTO yle_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yepê, Ngmênê M꞉aa u dpodo dye ghi yintómu ndêndê ngê n꞉aa dódó ngê. Yepê, Yi kópu u l꞉êê dîy꞉o, k꞉omo tpile a kópu dyuu daanmyi ny꞉ee ngmê, ngmênê kópuni n꞉aa d꞉uud꞉uu too, yi l꞉êê dîy꞉o a ka dmyina a kêlîmî, mu kópu u dîy꞉o ala kópu nmyi lama ndêndê ngê pîchoo ya, M꞉aa ntee a tóó, nê my꞉aa vyîlo, yinté myinî tóó. ");
INSERT INTO yle_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yi kópu u l꞉êê dîy꞉o myombó u yi y꞉e mêdoo kwo, Nmî mgîmî, ngmênê yi kêlê a pwii wo. ");
INSERT INTO yle_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu u k꞉ii Njedusalem nmo kuwo ngê, mbwaa ndîî Njódan nmî ngmópu, Njon Baptist ngê yoo mbwaa paa kwéli dpîmo kmênêkmênê dé, y꞉i nmeen꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pi yilî nmo a loo, noko yepê, K꞉omo tpile Njon ngê mbwudu daangmê chópu, ngmênê kópuni yilî Yesu p꞉uu vyu, yintómu ndê kópu dé, k꞉omodanê kópu yi p꞉uu daa t꞉a. ");
INSERT INTO yle_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wod꞉oo pi yilî y꞉i Yesu ka kêlîmî mbê wo. ");
INSERT INTO yle_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Pi ngmê, u pi Lasadas, u tîdê dê yi k꞉ii p꞉aa ngmê dnyimo ya, Petani. U tîdê dê yi pi dê Mata mbwémi Méli. (Pyópuni ngê nmî Lémi yu p꞉uu mbwááni n꞉ii tuu mb꞉aa a pii ngê, chóó u mbodo gh꞉aa dmi ngê mê pyi ngê, yi pyópu vyîlo yi Méli.) ");
INSERT INTO yle_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yi pyópu dê yi tîdê Lasadas mbila wo, wod꞉oo Yesu ka kópu dy꞉ââ ngópu, kwo, M̱yipe mb꞉aa kêdê mbil꞉a, y꞉ay꞉a dê pwiyé. ");
INSERT INTO yle_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Dini ghi n꞉ii ngê Yesu ngê a nyongo, nmopê, Wu mbii daa pwopwo u mbii, ngmênê u nt꞉u kópu ala, Chóó Lémi u pi ndîî ngê paa pyaa we, Tp꞉oo u pi ndîî ngê u ngwo myepaa pyaa we. ");
INSERT INTO yle_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu nódo Lasadas lémi knî yi nuu ghi dmi mb꞉aamb꞉aa ngê doo ya. ");
INSERT INTO yle_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","K꞉omo tpile Lasadas u mbii u pi a nyongo, ngmênê ghêlî u kwo daa n꞉ee. Kwéli nmee ya, wo mê miyó y꞉i nmî chedê ngê. ");
INSERT INTO yle_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","U kuwó dini ghi ngê nmopê, Njuda Wee u kwo mê diyé kmêle. ");
INSERT INTO yle_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kwonmo, Mââwe. Kwonmo, Nju tpémi y꞉oo m꞉ii tuwo chêêpî ngê mupî vya nyoo, lukwe dîy꞉o y꞉i mono diyédiyé té. ");
INSERT INTO yle_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu ngê nmopê, Ghêlî daawa vya nê. Nmopê, Kââdî nmo doongê ghêpê wo. Nmopê, N꞉ii w꞉êênî a dpodo yédi, ńedê d꞉uudpî kaalî, mu kópu u dîy꞉o w꞉êênî a dpodo yédi, tpile yilî a y꞉enê ngê. ");
INSERT INTO yle_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nmopê, Ngmênê kââdî dini ghi n꞉ii ngê dpî ghîî, n꞉ii ngê u dpodo d꞉uudpo kêlî, mgîdî vy꞉o a dpodo yédi, ńedê u ngwo dpî kaalî, mu kópu u dîy꞉o wo daa ya yédi. ");
INSERT INTO yle_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yi kópu nmo yi vyu, u kuwó dini ghi ngê nmopê, Nmî pyipe Lasadas kîyedê dpî, n꞉aa lêpî, u dpî nîmo ny꞉ââny꞉ââ. ");
INSERT INTO yle_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kwonmo, Mââwe. Kwonmo, Wunê dpî knomomê, ye chóó mê pyiyépyiyé. ");
INSERT INTO yle_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nmînê nmo u mbii machedê ngê wunê pyodopyodo, wunê dpî, ngmênê Yesu Lasadas u pwopwo p꞉uu nmo doo mgongo. ");
INSERT INTO yle_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Wod꞉oo Yesu ngê yimi nmopê, Lasadas kêdê pw꞉onu, ");
INSERT INTO yle_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ngmênê nmyi l꞉êê dîy꞉o a gha mb꞉aamb꞉aa ngê dê pyódu. Nmopê, U kwo w꞉aa loo, ye kópu têdê yip꞉ee m꞉uu ngópu, d꞉ud꞉umbiy꞉e a ka daap꞉ee kêlîmî mbê dniye. Nmopê, U kwo lee kmêle, nmyi kêlîmî ndîî ngê paa pyaa we. ");
INSERT INTO yle_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nmî vy꞉o pini ngmê Tomas, pini n꞉ii u mbwó k꞉ii nipi taa knopwo, yi pini ngê nmopê, Nmî mââwe u k꞉ii nipi lee kmêle, u k꞉ii nipi paa pw꞉oo kmêle. ");
INSERT INTO yle_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Dini ghi n꞉ii ngê Petani nmî taa dniye, nmopê, Lasadas paa tuwo kî kmênê ngópu. ");
INSERT INTO yle_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Nmopê, Pi yilî Njedusalem kêda ndê, Mata mbwémi Méli ye kêdê lee dmi, yi nuw꞉o dê ka l꞉âmol꞉âmo d꞉oo, yi tîdê u l꞉êê dîy꞉o. (Petani Njedusalem u nkîgh꞉ê a tóó, daa kuughê, 3 km.) ");
INSERT INTO yle_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Dini ghi n꞉ii ngê Mata ngê nyongo, apê, Yesu maa p꞉uu kîyedê pwiyé knî, wod꞉oo u mbwó Méli ngomo k꞉oo a kuwo ngê, maa p꞉uu mênê pyódu nmoo. ");
INSERT INTO yle_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Yesu ka kwo, A Lémi. Kwo, Al꞉ii wonyoo ya, a tîdê daapî pwene, ");
INSERT INTO yle_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ngmênê a lama ka tóó Chóó Lémi ka kópuni nye dmyinê, yi kópu vyîlo ye d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu ngê kwo, Ṉ́îdê mêwunê pyidepyide. ");
INSERT INTO yle_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata ngê kwo, A lama ka tóó, kuwókuwó wéni ngê Chóó Lémi ngê pi yintómu wa pyidu té. Kwo, A tîdê u ngwo amêdê pyidu. ");
INSERT INTO yle_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu ngê kwo, A chóó nê yoo yi pyidepyide u kn꞉ââ, mye yi ghê kamî u kn꞉ââ. Kwo, N꞉ii a ka ada a kêlîmî, k꞉omo tpile wa pw꞉onu, ghê amaa ya. ");
INSERT INTO yle_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kwo, N꞉ii u ghê a t꞉a dyámê mbêmê, a ka ada a kêlîmî, ghê kamî wa a pyw꞉oo, ghéni n꞉ii chedê ngê daawa pyódu. Kwo, Yi kópu ka nye kêlîmî? ");
INSERT INTO yle_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata ngê kwo, A Lémi. Kwo, Yi kópu ka n꞉aa kêlîmî. Kwo, A lama ka tóó, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, n꞉ii nmo t꞉âât꞉ââ, nyi vyîlo, Chóó Lémi Tp꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata ngê maa p꞉uu a kuwo nmoo, Petani mê diyé wo, u mbwó Méli ka tumu u kwo mbwolo, kwo, Mââwe kêda t꞉a, ka poopoo ngi. ");
INSERT INTO yle_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Dini ghi n꞉ii ngê Méli ngê nyongo, wod꞉oo ghêêdî wo, Yesu u k꞉ii nmo a loo. ");
INSERT INTO yle_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Ghêlî k꞉ii p꞉o pi dêmî ta, Mata ngê maa p꞉uu kwéli a pyódu nmoo, y꞉i nmee ya.) ");
INSERT INTO yle_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Dini ghi n꞉ii ngê Méli lîmîlîmî ngê ghêêdî wo, ngomo k꞉oo a pwii wo, Nju tpémini Méli u nuw꞉o l꞉âmol꞉âmo u l꞉êê dîy꞉o yi ngomo k꞉oo dnye kwo, mye ghêêdî dniye, Méli mye ngmêê ngópu. Apê ngmênê, Kpê chedê dê lê, wumê mbê. ");
INSERT INTO yle_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Dini ghi n꞉ii ngê Méli ngê Yesu módu, u kwo a loo, yu km꞉ee dyimê wo, kwo, A Lémi. Kwo, Al꞉ii wonyoo ya, ye a tîdê daapî pwene. ");
INSERT INTO yle_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu ngê Méli yi módu, apê, Mu mbê. Apê, Kî yéli myeka mbê té. U gha dyênê wo, kwodo ng꞉oo dmi mye tpalê wo. ");
INSERT INTO yle_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yepê, Ló y꞉i nmyi kmênê ngópu? Kwo, Nmî Lémi. Kwo, Lee kmêle, nga anyi mwini. ");
INSERT INTO yle_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu ngê mbê u ngwo myedê puwâ. ");
INSERT INTO yle_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nju tpémi y꞉oo noko apê, U pyipe mb꞉aa. ");
INSERT INTO yle_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pi ngmê knî y꞉oo apê, Kî pini ngê ngwolo kopwe angênté pyi ngê, lukwe dîy꞉o Lasadas daa pyi ngê. ");
INSERT INTO yle_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Myombó Yesu u gha mê dyênê wo, wod꞉oo kpê chedê nmî lee dniye. Kpomo u mênê ntóó y꞉i mî kmênê ngópu, chêêpî ndîî u kpê komo t꞉âmo ngmê kaa ngópu. ");
INSERT INTO yle_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu ngê yepê, Chêêpî tpiyé wupu kalê yó. Mata ngê Yesu ka kwo, Tuu wunê yiyé. Kwo, Paa tuwo nmî kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu ngê kwo, Ala kópu ṉga dî vyi, A ka nye kêlîmî, ye Chóó Lémi u wêdêwêdê ndîî awêde nye mumu. Kwo, Lukwe. Kwo, Yi kópu ka d꞉ee kêlîmî? ");
INSERT INTO yle_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wod꞉oo chêêpî a tpiyé wupu kalê ngópu. Yesu mbóó p꞉uu vyu wo, u Mî ka kwo, Mw꞉ââkó M꞉aa. Kwo, Kópuni ṉga d꞉a dmyinê, kîcha d꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kwo, A lama ka tóó, dye ghi yintómu a ka nyinê ng꞉aa, ngmênê ala yéli yi l꞉êê dîy꞉o yi kópu dî vyi, mu kópu u dîy꞉o ala kópu ka paa kêlîmî mbê dniye, Pini n꞉ii Chóó Lémi ngê a dy꞉ââ ngê, kî vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yi kópu yi vyu, wod꞉oo dpodombiy꞉e mbwolo, apê, Lasadas, a pwii. ");
INSERT INTO yle_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wod꞉oo ntóó a ghêêdî wo, kpomo u mênê a pwii wo. Ntee kmênê ngópu, yinté mêdê pii wo, kóó yu yi p꞉uu kpîdî pee n꞉ii t꞉ee tumo, yinté p꞉uu dnye ya, kpîdî pee n꞉ii ngê mbodo a kmongo ngópu, yi kpîdî pee mbêmê myedoo ya. Yesu ngê yepê, Kî pini p꞉uu kpîdî pee a ngee tóó. Yepê, Paa wunê yém. ");
INSERT INTO yle_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nju tpémini Méli ka lee dniye, u nuw꞉o l꞉âmol꞉âmo u l꞉êê dîy꞉o, yi yéli yi ngópu Yesu ngê Lasadas a pyidu ngê. ");
INSERT INTO yle_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pi yilî u kwo kêlîmî mbê wo, ngmênê woni knî Njedusalem mê diyé dniye, Pádisi knî ye yi kópu u yuu ye mênê y꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wod꞉oo Pádisi yoo, kpêê yiyé pyu yoo, kada pini yintómu nipi a wó, noko yepê, Lukwe ngmanmî md꞉o, wu pini ngê kópu yilî ka d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Noko yepê, Yi kópu adî d꞉uud꞉uu dé, pi yintómu u kwo wa kêlîmî mb꞉anê, Lóma tpémi y꞉oo wa ny꞉ee ngmê, awo, Wu pini ngê u pi lukwe dîy꞉o mudu y꞉i a kmîmî. Noko yepê, U kuwó dini ghi ngê lede yilî ala Njuda Wee u kwo wa a dy꞉ââ ngmê, wamî vya nmo, Chóó Lémi u ngomo wamye pwaa ngmê. ");
INSERT INTO yle_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pi ngmê yi vy꞉o doo kwo, u pi Kayapas, yi m꞉aani ngê kpêê yiyé pyu yoo yi kada pini ngê doo ya. Yi pini ngê yepê, Nuw꞉o nmyi mênê daa tóó. ");
INSERT INTO yle_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yepê, Ala kópu dmyongê w꞉ee ngópu. Yepê, Pi ngmidi pi yintómu yi l꞉êê dîy꞉o paa pw꞉oo we, ye Lóma tpémi y꞉oo daawa a pw꞉oo nmo. ");
INSERT INTO yle_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yi pini doo u lama doo mbumu, ngmênê ndê kópu yedoo tpapê. Yi m꞉aani ngê kpêê yiyé pyu yoo yi kada pini ngê doo ya, Chóó lémi u komo u ngwo kââ. ");
INSERT INTO yle_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","A tîdê mbwó yoo, nmî lama ka tóó, Yesu Nju tpémi yi l꞉êê dîy꞉o pwene, kn꞉aa yéli yi l꞉êê dîy꞉o mye pwene, mu kópu u dîy꞉o Chóó Lémi tp꞉oo módó tp꞉oo mââ yoo dyámê mbêmê dyámê mbêmê yélini a kwo, yoo ngmidi ngê u ngwo paa pyaa we. Kayapas u lama yi kópu dêpwo ya, ngmênê yinté kópu ye yi vyu. ");
INSERT INTO yle_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yi wéni ngê Nju tpémi yi kada pini knî y꞉oo Yesu u vyee u dy꞉oo a châpwo ngópu, ");
INSERT INTO yle_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","wod꞉oo Yesu tumutumu doo paa, Njuda Wee nmo kuwo ngê, pi kwéli dêpwo paa, y꞉i nmî lee dniye, p꞉aa ngmê u pi Epîdayim y꞉i nmeen꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nju tpémi yi naa ndîî, Tp꞉ee Kaa W꞉êêw꞉êê u Naa, daa kêmakêma doo dyimêdyimê, wod꞉oo pi yilî Njedusalem loo, daa dyámê ghi mu ngmidi tpémi y꞉i mî taa dniye. Yi nááli ghêlî daa kê ngópu, Njedusalem u ngwo lee dniye, Chóó Lémi ka tupwóni yi p꞉uu doo ya, u ngwo chedê ngópu. ");
INSERT INTO yle_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yesu dnye nmy꞉uu, Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo noko dnye póó, noko yipu, Naa têdê daawa t꞉aa, apii? ");
INSERT INTO yle_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yi kópu vyi ngópu, mu kópu u dîy꞉o Pádisi yoo kpêê yiyé pyu yoo yi kada pini knî yi k꞉ii, ala kópu pi knî ye mwiyé vyi ngópu, yepê, N꞉ii u lama Yesu choo ya, yi pini ngê nmo dpî vyi ngê, yed꞉oo nmo mgîmîmgîmî. ");
INSERT INTO yle_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Dini ghi n꞉ii ngê Tp꞉ee Kaa W꞉êêw꞉êê u Naa ndîî nê wámê, Yesu u k꞉ii Petani nmî lee dniye, Lasadas kwéli doo a ya, pini n꞉ii Yesu ngê kpêênî a pyidu ngê. ");
INSERT INTO yle_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesu u l꞉êê dîy꞉o nté pee ngmê l꞉âmo ngópu, Lasadas u k꞉ii nmee kmaapî. Mata ngê nté doo a teetee, nté kuu dmi nmî kêmê doo kapî dé. ");
INSERT INTO yle_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","U mbwó Méli ngê mbwááni n꞉ii tuu mb꞉aa pód꞉a ngma a ńuwo, yi mbwááni u pywuu pââ ndîî, u pi naadî. A ngêêdî, komo puwâ, Yesu mbêmê knî ngma a pii ngê, yu dê u ngwo mye ghêê doo, chóó u mbodo gh꞉aa dmi ngê yu dê u ngwo mê pyi doo. Yi tpile tuu mb꞉aa ngê ngomo kó a ngêêdî. ");
INSERT INTO yle_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nmî vy꞉o pini ngmê, Njudas Kédiyót pi, pini n꞉ii Yesu u kwódo ngê daa kêmakêma doo wowo, yi Njudas ngê nmopê, ");
INSERT INTO yle_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Kî pyópu ngê lukwe dîy꞉o naadî dê dyênê. Nmopê, Nmo woda kê, ndapî ndîî pudu kmênê, yi ndapî pinté knî ye pudu y꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yi kópu vyu, ngmênê daa pinté knî yi p꞉uu doo nuw꞉o, chóó p꞉uu doo nuw꞉o. Kpáápi ngê doo ya, nmî ndapî péé yinê dpîmo y꞉enê, ngmênê yinê mêdpîmo pîpî. ");
INSERT INTO yle_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu ngê kwo, U kwo kidimê mbumu. Kwo, A pwopwo u l꞉êê dîy꞉o wiye ngê. ");
INSERT INTO yle_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nmopê, Dye ghi yintómu u ntââ pinté yoo anmyinê pyw꞉ee t꞉oo. Nmopê, Dini ghi n꞉ii ngê u yi nmye adî kwo, Nmî ngee té, nmopê, u ngwo dmyinê ngêêpî dé. Nmopê, Mu dini ghi ngê nmyi vy꞉o mêdaanî kwo. ");
INSERT INTO yle_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nju tpémi yilî y꞉oo yi ny꞉ee ngópu, apê, Yesu Petani ka tóó, wod꞉oo y꞉i lee dniye. Daa Yesu u mo u l꞉êê dîy꞉o lee dniye, ngmênê u yi y꞉e myedoo kwo, Lasadas nm꞉uu m꞉uu, pini n꞉ii Yesu ngê kpêênî a pyidu ngê. ");
INSERT INTO yle_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Wod꞉oo kpêê yiyé pyu yoo yi kada pini knî y꞉oo Lasadas u vyee u dy꞉oo myedê châpwo ngópu, ");
INSERT INTO yle_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mu kópu u dîy꞉o Lasadas u l꞉êê dîy꞉o Nju pi yilî knî y꞉oo yi chóó yi kada pini dnya a kuwokuwo dé, Yesu ka dnye kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Womumo pi yilî n꞉ii Njedusalem naa têdê ta, yi yéli y꞉oo yi ny꞉ee ngópu, apê, Yesu awêde al꞉ii a taataa. ");
INSERT INTO yle_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wod꞉oo king ntee dnyimo chââchââ, Yesu yinté mye châpu ngópu, dpumo nkoo dmi knî ngma a ńuw꞉o ngópu, maa p꞉uu a pyódu nmoo, dnye kââ, kópu, Munmîkó Nmî Lémi. Kópu, Chóó Lémi ngê a ngee nyine. Kópu, U pi ngê nyinê loo. Kópu, Nmo Yisîléli tpémi, nyi nmî king, Chóó Lémi ngê mb꞉aamb꞉aa ngê choo a ngêêpî ngi. ");
INSERT INTO yle_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu ngê ndonki ngma a pyw꞉ângo, pyipwo yaa wo, Njedusalem u ngwo loo. Kópuni puku yedê a tóó, Yesu ngê vyîlo yi ntiye ngê. Yi kópu ala. ");
INSERT INTO yle_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Njedusalem tpémi, namê nkîngê. Nmyi king wunê pwiyé knî, ndonki tp꞉oo pyipwo wunê tóó. ");
INSERT INTO yle_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","K꞉omo tpile p꞉uu nmee ndiye, ngmênê yi ngwo pi dêpê w꞉ee ngê. Yesu dini ghi n꞉ii ngê pwene, mêdê pii wo, u Mî ka mê kee wo, u ngwo nmo w꞉ee ngê, kópuni Yesu p꞉uu ló dini a d꞉êê ngópu u ngwo nmî nuw꞉o kwólu, noko nmîmo, Yesu ngê yi wéni ngê nmî d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Yi yéli ndîî y꞉oo Yesu châpu ngópu, mu kópu u dîy꞉o Lasadas u danêmbum mwiyé ny꞉ee ngópu. Yélini yi ngópu Yesu ngê Lasadas kpêênî a pyidu ngê, yi yéli y꞉oo pi yintómu knî ye mênê nté ngópu. ");
INSERT INTO yle_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Wod꞉oo Pádisi yoo y꞉oo noko yepê, Dmyinê w꞉ee ngmê, dpî dêê dmi. Noko yepê, Pi yintómu u pee kêdê ghê. ");
INSERT INTO yle_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yélini Njedusalem naa têdê lee dniye, woni knî Kîdiki tpémi. ");
INSERT INTO yle_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pilipi ka lee dniye, pini n꞉ii Mbetîsaida pi, p꞉aani n꞉ii Nkálili Wee u kwo a tóó. Kwo, Mââwe, u yi nmo a kwo, Yesu nmo mumu. ");
INSERT INTO yle_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Yi kópu Pilipi ngê Andru ka mî vyu, yi tpódu nipi lee knopwo, Yesu ka u nkwo mî vyi ngópu. ");
INSERT INTO yle_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu ngê yepê, Wéni n꞉ii ngê Chóó Lémi u Pi Ndêndê u pi ndîî ngê wa pyódu, yi wéni daa kêmakêma a dyimêdyimê, ngmênê u pi têdê ngê mwiyé wunê pyodopyodo. ");
INSERT INTO yle_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mgongo ye ngmê kwólu, ye póó wo, yepê, Witi w꞉uu ngmanyinê ngî, kîlî anyi tpyé, mb꞉aamb꞉aa ngê u kwo anyi vyuwo, lukwe, yilî ngê u ngwo wa pyódu? Yepê, Doo u ntââ. Yepê, Têpê mbêmê wanyi pw꞉ono, têpê u mênê wa kee, ye mu dini ghi ngê wa pyidu, nt꞉u wa kaalî, w꞉uu yilî ngê u ngwo wa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","26","Yepê, N꞉ii ngê a p꞉uu dpodo u yi adî kwo, ye yini a maa p꞉uu choo m꞉ii, choo a yâmuyâmu nê, kwéli anî lê, y꞉i dpo lee we. Yepê, N꞉ii a p꞉uu yinté adî dpodo, yini u pi M꞉aa ngê ndîî ngê wa pyódu. Yepê, Ngmênê n꞉ii chóó u ghê p꞉uu adî nuw꞉o, u l꞉êê dîy꞉o a wépi wa puwâ, yini ngê u ghê kamî l꞉âmo wa a ngee. Yepê, Dyámê mbêmê n꞉ii chóó u ghê p꞉uu daadî nuw꞉o, a p꞉uu dpodo têdê daawa kede, yini ngê u ghê kamî l꞉âmo daawa a ngee, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu ngê nmopê, A ghê da kee. Nmopê, M꞉aa ka ala kópu n꞉aa dmyinê, kwonê, A ngee nédi, pi knî y꞉oo yi dono kópu a nga kîngmê d꞉uu ngmê. Nmopê, Yi kópu M꞉aa ka wanê dmyinê? Nmopê, Kêle. Nmopê, Yi kópu u kwo daanê dmyinê, mu kópu u dîy꞉o yi dono kópu u l꞉êê dîy꞉o dyámê mbêmê nê loo. ");
INSERT INTO yle_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nmopê, M꞉aa ka ala kópu n꞉aa tpapê, M꞉aa, m̱i ndîî ngê pyódu ngi. Yi kópu nmo yi vyu, u kuwó dini ghi ngê, nê, Mbóó p꞉uu dnye ngmê wîle, Yesu ka kwo, A pi ndîî ngê wunê nî pyódu ngê, myombó ndîî ngê mênî pyépi. ");
INSERT INTO yle_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Yélini yi vy꞉o nmee kwo yi dnyeni mye ny꞉ee ngópu, ngmênê dnyinté a w꞉ee ngópu. Ngmê knî y꞉oo apê ngmênê, Mwini yi mbwólu. Woni knî y꞉oo apê ngmênê, Enjel u kwo yi mbwólu. ");
INSERT INTO yle_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu ngê yepê, Wu dnyeni daa a l꞉êê dîy꞉o da kwolo, ngmênê nmyi l꞉êê dîy꞉o da mbwólu. ");
INSERT INTO yle_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yepê, Dyámê mbêmê tpémi yi chámêchámê kn꞉ââ daa kêmakêma a chapî. Yepê, Ala ngwo Setan ngê dyámê pê yintómu yinê a mbêpê kîgha, ngmênê u ngm꞉ii kîgha kn꞉ââ daa kêmakêma n꞉aa chapî. ");
INSERT INTO yle_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yepê, Dini ghi n꞉ii ngê têpê mbêmê wa a ngî nê, tââ wa km꞉êê nê, ye pi yintómu a chóó a kêténi wanê pêêdî. ");
INSERT INTO yle_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yi kópu ye vyu, chóó u pwopwo p꞉uu u ngwo ye doo mgongo. ");
INSERT INTO yle_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pi knî y꞉oo kwo, Puku yedê alanté kópu ngmêka tóó, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, dini ghi n꞉ii ngê wa t꞉a, dyámê pê adî y꞉enê, chedê ngê daawa pyódu. Kwo, Ṉ́yóó m̱꞉uu ala kópu nye tpapê ngê, nyimo, Nê Chóó Lémi u Pi Ndêndê, kwo, ala ngwo ala kópu kîchi vyi, Tââ wa km꞉êê nê. Kwo, Chóó Lémi u Pi Ndêndê u kakêmê nmo chámê ngi. ");
INSERT INTO yle_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu ngê yepê, Nmyi pywápê daa kêmakêma a pwopwo. Yepê, Pywápê wo dmyinê m꞉ii, mgî nangê puwâ. Yepê, Mgîdî nmyi pwo kîdangê ghay. Yepê, N꞉ii mgîdî vy꞉o a m꞉ii, maa dpî kn꞉aadi. ");
INSERT INTO yle_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yepê, Nmyi pywápê a pwopwo, lîmîlîmî ngê u kwo kêlîmî mbê dmyeno, yed꞉oo wo u yoo ngê u ngwo anmyi pyaa dmi. Yesu ngê yi kópu yi vyi too, yi yéli a kuwo ngê, yi vy꞉o mî mbwolo wo. ");
INSERT INTO yle_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","K꞉omo tpile mbwudu yilî yi ngópu chópu, ngmênê u kwo dêdnye kêlîmî, ");
INSERT INTO yle_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","kópuni Yisaya ngê wunê a d꞉êê ngê, yi ngwo mî ntiye ngópu. Yi kópu ala, A Lémi, lukwe dîy꞉o nmî kópu ka daa kêlîmî mbê dniye, ṉgwêdêwêdê ndîî lukwe dîy꞉o daa mya ngópu. ");
INSERT INTO yle_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Doo u ntââ daapê kêlîmî mbê dniye, mu kópu u dîy꞉o Yisaya ngê Chóó Lémi u komo alanté myedê kââ, apê, ");
INSERT INTO yle_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Yi ngwolo dmi my꞉oo nî yó, nê, Yélî daapaa m꞉uu y꞉e, yi nuw꞉o l꞉âmo dmi nê ngópu, nê, Daapêdê w꞉ee y꞉e, a ka daapêdê diyé dniye, yi pyipyi u l꞉êê dîy꞉o. ");
INSERT INTO yle_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yisaya ngê yi kópu a d꞉êê ngê, mu kópu u l꞉êê dîy꞉o Yesu u pi ndîî mwiyé a módu, p꞉uu u ngwo doo a d꞉êê. ");
INSERT INTO yle_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","K꞉omo tpile Nju pi yilî u kwo dêdnye kêlîmî, ngmênê mê yilî u kwo dnye kêlîmî, kada pini knî ngmê yi vy꞉o myednye kwo. Yi yéli y꞉oo kópu daa vyi ngópu, ngmênê tumutumu u kwo dnye kêlîmî, mu kópu u dîy꞉o Pádisi knî ye dnye nkîngê, apu, Wa kéé nmo, nmî yoo kuwa wa kaa nmo. ");
INSERT INTO yle_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yélini tumutumu dnye kêlîmî, u yi y꞉e doo kwo, Pi knî y꞉oo dny꞉oo chaa kîgha nmo. Yi kópu yinê ye ndîî kópu. K꞉omo tpile daa Chóó Lémi u nuu u kópu yidnye d꞉uud꞉uu, ngmênê yi kópu yinê ye têdê kópu. ");
INSERT INTO yle_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","U kuwó dini ghi ngê Yesu pi knî ye dpodombiy꞉e mbwolo, yepê, N꞉ii a ka wunê kêlîmî, daa a mo a ka wunê kêlîmî, ngmênê pini n꞉ii ngê a dy꞉ââ noo, u kwo mye kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yepê, N꞉ii ngê dê mya nê, pini n꞉ii ngê a dy꞉ââ noo, yi pini myaa mya. ");
INSERT INTO yle_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yepê, Dyámê pê u pywápê ngê nê loo, nê, N꞉ii a ka ada a kêlîmî, mgîdî vy꞉o daadî kwo, pywápê u wo adî ya. ");
INSERT INTO yle_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yepê, N꞉ii u lama a kópu dyuu adî kwo, daadî chââchââ dé, nê kuu, a chóó daanî ndyîko. Yepê, Daa yoo yi ndyîkondyîko u l꞉êê dîy꞉o nê loo, ngmênê yi ngêêpî u l꞉êê dîy꞉o nê loo. ");
INSERT INTO yle_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yepê, N꞉ii ngê a wépi wa puwâ, a kópu dyuu u wépi amye puwâ, yini ngê chóóchóó dê ndyîko, kuwókuwó wéni ngê Chóó Lémi ngê wa kpada, ");
INSERT INTO yle_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","mu kópu u dîy꞉o daa a mo a kópu dyuu yinî tpapê, M꞉aa ngê yinê a dy꞉ââ noo, kópuni a ka doo a tpapê dé, nmye vyîlo yinoo tpapê dé. ");
INSERT INTO yle_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yepê, Kópuni M꞉aa ngê a ka a vyu, a lama ka tóó, a ka pê, Ghê kamî pêdê pyw꞉ee y꞉e, ghéni n꞉ii chedê ngê daawa pyódu. Yepê, M꞉aa ngê kópuni a ka a vyi too, vyîlo nmye yinî tpapê té. ");
INSERT INTO yle_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nê mââ Tp꞉ee Kaa W꞉êêw꞉êê u Naa. Yesu u lama doo ya, apê, Daa kêmakêma dyámê pê nînê kuwokuwo, M꞉aa ka mînî diyédiyé. Yélini yi k꞉ii u kwo nmee kêlîmî, nmî nuu ghi dmi ndêndê ngê nódo doo ya. Yi kópu yi wéni ngê ndêndê ngê nmo w꞉ee ngê, dini ghi n꞉ii ngê Yesu ngê ala ndîî kópu nmo d꞉uu ngê. ");
INSERT INTO yle_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu u k꞉ii mgîdî vy꞉o kmaapî têdê nmee ya. Setan ngê Njudas ka Yesu u kwódo ngê wowo u pi wunê mwiyé a vyu. Yi Njudas u mî Saimon, Kédiyót pi. ");
INSERT INTO yle_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu u lama doo ya, apê, M꞉aa ngê tpile yintómu a kêê yedê yó, u kwo nê ndê wo, u kwo mînî diyédiyé. ");
INSERT INTO yle_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wod꞉oo Yesu kmaapî têdê ghêêdî wo, u kpîdî mb꞉aa u mbwo a ngópu, tââli daadîî u paa ngmê t꞉ângo, ");
INSERT INTO yle_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","mbwaa kuu nmoko yedê ngmê ntówo, nmî yi dmi ngmêngmênté doo ghêêghêê, tââli ngê doo pyipyi dé. ");
INSERT INTO yle_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Saimon Pita ka u nkwo yi loo, yu dê daa kêmakêma doo ghêêghêê dê, wod꞉oo Pita ngê kwo, Mââwe. Kwo, Nyi nmî kada pini, nê tp꞉ee. Kwo, Doo u ntââ a yi dê daanyi ghêê dê. ");
INSERT INTO yle_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu ngê kwo, Kópuni n꞉aa d꞉uud꞉uu, choongê w꞉ee ngê, dîyo wanyinê w꞉ee. ");
INSERT INTO yle_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita ngê kwo, A lémi, nê tp꞉ee. Kwo, Doo u ntââ mo doo u ntââ, a yi dê daanyi ghêê dê. Yesu ngê kwo, Ṉyi dê daanî ghêê knomomê, a yoo vy꞉o daamonyi kwo. ");
INSERT INTO yle_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita ngê kwo, A Lémi, a yi dê yi mo kidingê ghêê dê. Kwo, A kêê dê dpî ghêê dé, a mbodo myoo ghêê ngi. ");
INSERT INTO yle_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu ngê kwo, Pini n꞉ii dpî kudu, maa p꞉uu yu dê tupwótupwó ngê moo pyaa knî, yi pini mêd꞉uudpî kudu, yu dê mêyu ghêê dê, yed꞉oo tupwó p꞉uu mêdaa ya yédi. Yesu ngê nmopê, Nmyo yintómu tupwó nmyi p꞉uu daa t꞉a, ngmênê mu ngmidi. ");
INSERT INTO yle_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Pini n꞉ii Yesu u kwódo ngê doo wowo, Yesu u lama mwiyé yaa wo. Yi kópu u l꞉êê dîy꞉o u ngwo nmo vyu, nmopê, Nmyo yintómu tupwó nmyi p꞉uu daa t꞉a, ngmênê mu ngmidi tupwótupwó. ");
INSERT INTO yle_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nmî yi dmi ghêêghêê dini ghi n꞉ii ngê chedê ngê, Yesu ngê tââli u paa mêdê ngópu, u kpîdî mb꞉aa u mbwo mê t꞉ângo, kmaapî têdê mê yaa wo. Nmo póó wo, nmopê, Kópuni nmye dî d꞉uu, yi kópu dmyinê w꞉ee ngmê? ");
INSERT INTO yle_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nmopê, A ka nmyinê mbumu nyédi, nyimo, Nmî ndiye kîgha pyu, nmî Lémi. Nmopê, U ntââ mbêmê a ka nmyinê mbumu té, mu kópu u dîy꞉o ndêndê ngê nê vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nmopê, K꞉omo tpile nê nmyi kada pini, nmyi ndiye kîgha pyu, a pi ndîî, ngmênê tp꞉ee u dpodo ngmêdê dóó, nmyi yi dmi dî ghodo. Nmopê, Lémi lémi ngê kêê nangê t꞉oo, dmyinê numo ngêêpî. ");
INSERT INTO yle_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nmopê, Yi kópu nmye dî d꞉uu, mu kópu u dîy꞉o pêdmyina a nj꞉ii nê. ");
INSERT INTO yle_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nmopê, Ndê kópu nmye ngmên꞉aa tpapê, dpodo pyu u pi têdê, u kada pini u pi ndîî, dyede pi u pi têdê, n꞉ii ngê a dy꞉ââ ngê u pi ndîî. Nmopê, Nê nmyi kada pini, lémi lémi ngê kêê dêp꞉a t꞉ângo, kêê u ngwo myenangê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nmopê, Yi ndê kópu dyuu ala ngwo dmyinê w꞉ee ngmê. Nmopê, Wanmyi d꞉uud꞉uu dé, M꞉aa ngê mb꞉aamb꞉aa ngê adî ngêêpî nmyo, noko mb꞉aamb꞉aa ngê anmyi ya. ");
INSERT INTO yle_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nmopê, Daa nmyo yintómu nmyi p꞉uu yi kópu dî vyi. Nmopê, Nmyi gha dmi a lama dé, a chóó nê ngmidi nmyoo, ngmênê pi nmyi vy꞉o ngma kwo, n꞉ii ngê ala kópu a ntiyentiye, kópuni puku yedê a tóó, apê, A nté pini n꞉ii ngê doo pîpî, dono a nga dê d꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nmopê, Yi kópu ghêlî doongê pyodo, u ngwo nmye dî vyi, mu kópu u dîy꞉o ala kópu nmyi lama choo ya, a pi, A chóó n꞉aa tóó. ");
INSERT INTO yle_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nmopê, Ala kópu nmye kîdî vyi, Namê lémi lémi, ngmênê ndê kópu nmye m꞉uu n꞉aa tpapê, Nmyo a dyede pi yoo. N꞉ii ngê adî chââchââ nmyo, amyedî chââchââ nê. Nmopê, Ndê kópu m꞉uu ala, N꞉ii ngê adî chââchââ nê, M꞉aa amyedî chââchââ, pini n꞉ii ngê a dy꞉ââ noo. ");
INSERT INTO yle_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","U kuwó dini ghi ngê Yesu u ghê a kee wo, nmopê, Ndê kópu nmye ngmên꞉aa tpapê, nmyi vy꞉o pini ngmê a kwódo ngê a wowo. ");
INSERT INTO yle_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Munmye nîmo y꞉enê, nê, Ala n꞉uu p꞉uu a danê? ");
INSERT INTO yle_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yesu u nkîgh꞉ê noo ya, mu kópu u l꞉êê dîy꞉o nê u nuu u pi. ");
INSERT INTO yle_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita ngê u mbodo ngê a ka pê, U kwo ngê péé, N꞉uu p꞉uu a danêmbum. ");
INSERT INTO yle_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wod꞉oo Yesu u nkîgh꞉ê yimi nî loo, tumutumu kwonoo, A Lémi, n꞉uu p꞉uu nye danêmbum? ");
INSERT INTO yle_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A ka pê, Alanté ṉga nînê kêmakêma, Pini n꞉ii ka nté n꞉êê ngmên꞉aa yém, yi pini yi vyîlo. Wod꞉oo nté n꞉êê ngma a ngêêdî, nté nyii kuu k꞉oo kmênê ngê, Njudas ka y꞉ângo, pini n꞉ii Saimon Kédiyót pi tp꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Dini ghi n꞉ii ngê Yesu ngê nté n꞉êê u kwo y꞉ângo, yi ngwo Setan u mênê kee wo. Yesu ngê kwo, Kópuni m̱ênê a tóó, kwo, lîmîlîmî ngê d꞉uu ngi. ");
INSERT INTO yle_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kópuni Njudas ka vyu, a mo nê w꞉ee ngê. A pyipe knî y꞉oo dêpê w꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Woni knî y꞉oo apê ngmênê, Njudas ngê nmî ndapî yinê a y꞉enê. Apê ngmênê, Yesu ngê ala kópu u kwo yi vyi, Mââ naa têdê nté pee n꞉ii u yi nmo adî kwo, knî m꞉uu nyi pwila ngi. Alanté mye nuw꞉o mbê dniye, apê ngmênê, Ala kópu u kwo yi vyi, Pinté knî ye ndapî knî ngmênyi y꞉eni. ");
INSERT INTO yle_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Njudas ngê dini ghi n꞉ii ngê nté n꞉êê ndîî, wod꞉oo kuwa pwii wo, mgîdî vy꞉o. ");
INSERT INTO yle_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Njudas yi loo, Yesu ngê nmopê, Daa kêmakêma pi knî y꞉oo wunê wopwe ngmê, Chóó Lémi u Pi Ndêndê u pi ndîî ngê dê pyódu, Chóó Lémi u pi ndîî ngê u ngwo amye pyódu ngmê. ");
INSERT INTO yle_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nmopê, Yi kópu u l꞉êê dîy꞉o M꞉aa ngê u che p꞉ââ pee ngê wa pyódu nê. Nmopê, Yi kópu daa kêmakêma a d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nmopê, A mbwó yoo. Nmopê, Daa dye ghi daadîî nmyi vy꞉o n꞉aa kwo. Nmopê, Wanmyi nmy꞉uu nê, ngmênê daanmyinê pyw꞉ee nê. Nmopê, Kópuni kada pini knî ye nî vyu, nmye myinê tpapê, kwéli anî lê, doo u ntââ y꞉i daangmênmyinê lê. ");
INSERT INTO yle_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nmopê, Dêêpî kópu kamî nmye ngmên꞉aa tpapê. Nmopê, Nmyi nuu ghi dmi nîmo nódo choo ya, mb꞉aamb꞉aa ngê noko dmyinê vyuwo. Nmopê, Nmye ntee nînê vyuwo, yinté noko myedmyinê vyuwo. ");
INSERT INTO yle_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nmopê, Noko mb꞉aamb꞉aa ngê anmyi vyuwo, ye pi knî yi lama wa yââ, awo, Nmyo a p꞉uu ndiye pyu yoo. ");
INSERT INTO yle_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita Yesu ka póó wo, kwo, Nmî Lémi. Kwo, Ló y꞉i nye lêpî? Yesu ngê kwo, Kwéli n꞉aa lêpî, doo u ntââ ala ngwo daanyinê ngmêê nê, ngmênê dîyo yi máádi anyinê kwolo. ");
INSERT INTO yle_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita ngê kwo, A Lémi, lukwe dîy꞉o ala ngwo daanî ngm꞉êê ngi? Kwo, K꞉omo tpile ḻ꞉êê dîy꞉o amye vya nê, ngmênê myedaanê kuwo ngi. ");
INSERT INTO yle_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu ngê kwo, Mumdoo a l꞉êê dîy꞉o wanyi pw꞉onu? Kwo, Ndê kópu ṉga ngmên꞉aa tpapê. Kwo, Kêmkêm ghêlî k꞉ii daawa kââ, pyolo nyinê wópuwópu nê, yenye, D꞉aa p꞉uu ndiye pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu ngê nmopê, Nmyi ghê dmi kîdangê kee, nmyi nuw꞉o dmi myekîngê dyênê. Nmopê, Chóó Lémi ka dmyinê kêlîmî, a ka myedmyina a kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nmopê, M꞉aa u p꞉o ngomo dêdê ghêdê. Nmopê, N꞉aa lêpî, nmyi p꞉aa dmi nmyi kada nîmo l꞉âmol꞉âmo. Nmopê, Yi kópu wodaa ndê kópu, ye nmye daapîdî vyi. ");
INSERT INTO yle_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nmopê, Nmyi p꞉aa dmi l꞉âmol꞉âmo u kuwó dini ghi ngê, amênê diyé, a chóó anê nya nmyo, p꞉o anî ńuw꞉o nmyo, kwéli anîn꞉aa ya, y꞉i amyenmyin꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nmopê, Kwéli n꞉aa lêpî nê, yi máádi nmyi lama ka t꞉a. ");
INSERT INTO yle_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas ngê kwo, Nmî Lémi. Kwo, Máádini nye kîgha, yi máádi nmî lama daa t꞉a. Kwo, Ló y꞉i nye lêpî? ");
INSERT INTO yle_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu ngê kwo, A chóó nê nmyi maa, ndê kópu yintómu knî yi kn꞉ââ, mye ghê u kn꞉ââ. Kwo, M꞉aa ka maa daamo a t꞉a, nê nmyi maa mu ngmidi. ");
INSERT INTO yle_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nmopê, A kn꞉ââ nmyi lama ndêndê ngê wodoo ya, ye M꞉aa nmyi lama myepê tóó. Nmopê, Ala ngwo M꞉aa ntênê nmyi lama dê yââ, kîmyedmye m꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipi ngê kwo, Nmî Lémi. Kwo, M̱î nmo a kêma ngi, ye u ntââ mbêmê nmo yââyââ té. ");
INSERT INTO yle_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu ngê kwo, Ló dini nmyi vy꞉o nî ghê wo, lukwe dîy꞉o choongê mya noo, kî pini. Kwo, Anmye y꞉enê nê, ye nê vyîlo. Kwo, Lukwe dîy꞉o a ka chi vyi, M꞉aa nmo a kêma ngi. ");
INSERT INTO yle_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kwo, Lukwe dîy꞉o alanté d꞉ee nuw꞉o, Nê, myenté M꞉aa, mu ngmidi. Yesu ngê nmopê, Kópu yilî n꞉ii nmye nî vyi too, daa a chóó a mo a kópu dé. Nmopê, M꞉aa k꞉ii ngmidi ngê nye tóó mo, chóó u dpodo yinoo dódó. ");
INSERT INTO yle_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nmopê, Ala kópu ka dmyinê kêlîmî, M꞉aa k꞉ii ngmidi ngê nye tóó mo. Nmopê, Yi kópu ka kêlîmî dpodo ndîî ngê nmye dê pyaa knomomê, ye kópuni nî d꞉uu too, yi kópu knî yi l꞉êê dîy꞉o a ka dmyina a kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nmopê, Ndê kópu nmye ngmên꞉aa tpapê, Pini n꞉ii a ka ada a kêlîmî, kópuni noo d꞉uud꞉uu dé, yi pini ngê yi kópu amyedî d꞉uud꞉uu dé, kópu ndîî knî myowa d꞉uu, mu kópu u dîy꞉o M꞉aa ka n꞉aa lêpî. ");
INSERT INTO yle_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nmopê, A pi ngê kópuni a ka anmyinê dmy꞉ee ngmê, wanê d꞉uu, M꞉aa u pi ndîî ngê u ngwo wanî pyódu. ");
INSERT INTO yle_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nmopê, A pi ngê kópuni anmyinê dmy꞉ee ngmê, wanê d꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu ngê nmopê, A nuu ghi nmyi nódo adî ya, ye a dêêpî kópu dyuu anmyi chââchââ. ");
INSERT INTO yle_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nmopê, M꞉aa ka nmyi ngêêpî pyu ngmanê dmyinê, chóó u Ghê Dmi. Nmopê, Nmyi p꞉uu adî ya, daawa a kuwo nmyo. ");
INSERT INTO yle_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nmopê, Mgîdî u yoo yi mênê daawa kee, mu kópu u dîy꞉o daawa m꞉uu ngmê, myedaawa mya ngmê. Nmopê, Nmyi lama pini, mu kópu u dîy꞉o nmyi vy꞉o ka kwo, mu dini ghi ngê nmyi mênê amyaa ya. ");
INSERT INTO yle_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nmopê, Nmyi mo daanê kuwo nmyo, ngmênê nmye wamênê diyé. ");
INSERT INTO yle_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nmopê, Mââ m꞉ii mgîdî u yoo knî y꞉oo mêdaamowa m꞉uu nê, ngmênê nmyi mo wanmyi mumu nê. Nmopê, A ghê adî ya, yi kópu u l꞉êê dîy꞉o ghê njini nmyi mênê a myaa ya. ");
INSERT INTO yle_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nmopê, Yi wéni ayi d꞉ii, u ngwo anmyinê w꞉ee ngmê, M꞉aa k꞉ii nye ngmidi, a k꞉ii ngmidi ngê amy꞉oo pyaa dmi. ");
INSERT INTO yle_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nmopê, N꞉ii ngê a dêêpî kópu dyuu a nyêmî too, wunê ng꞉êênî too, u mênê a yii too, a chââchââ too, vyîlo yi pini nódo a nuu ghi a tóó. Nmopê, Yi pini u nuu ghi M꞉aa nódo adî ya, a nódo amyaa ya, a chóóchóó u kwo amyenê kêma. ");
INSERT INTO yle_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nmî vy꞉o pini ngmê, Njudas, daa pini n꞉ii Yesu kwódo ngê ghê wo, yi Njudas Yesu ka póó wo, kwo, Nmî Lémi. Kwo, Lukwe dîy꞉o nmî mo wanmî m꞉uu ngi, wo yéli y꞉oo daawa m꞉uu ngi? ");
INSERT INTO yle_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu ngê kwo, Mu kópu u dîy꞉o n꞉ii nódo a nuu ghi adî ya, yi pini ngê a kópu dyuu adî chââchââ, M꞉aa nódo yi pini nuu ghi adî ya, M꞉aa k꞉ii u kwo anyinê lee knî, u k꞉ii anmîn꞉aa ya. ");
INSERT INTO yle_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kwo, N꞉ii nódo a nuu ghi daa tóó, a kópu dyuu ka myedaa ng꞉aa. Kwo, Kópuni dyuu nmye nî vyi too, daa a mo a kópu dyuu, ngmênê M꞉aa u kópu dyuu, pini n꞉ii ngê a dy꞉ââ noo. ");
INSERT INTO yle_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nmopê, Ala ngwo nmyi vy꞉o anî kwo, yi kópu knî u ngwo nmye dî vyi té. ");
INSERT INTO yle_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nmopê, A kuwó M꞉aa ngê chóó u Ghê Dmi a pi ngê nmye wa a dy꞉ââ, yinê adî ngêêpî nmyo, kópu yilî yintómu yi p꞉uu adî ndiye kîgha nmyo, kópu yintómu n꞉ii nmye nî vyi too, nmyi nuw꞉o ńedê yimi amê t꞉ee té. ");
INSERT INTO yle_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nmopê, Nkîngê nmyi mênê anê ngî, a chóó a gha ntee, nmyi gha dmi yinté adî ya. Nmopê, Pi knî y꞉oo yi komo ngê a tpapê ngópu, apu, Namê nkîngê, ngmênê a chóó nmyi nkîngê machedê ngê n꞉aa pyépi. Nmopê, Nmyi ghê dmi kîdangê kee, myenangmê nkîngê mb꞉anê. ");
INSERT INTO yle_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nmopê, Ala kópu mwiyé nmye kîdî vyi, nmyed꞉a, Nînê kuwokuwo nmyo, dîyo nmye amênê diyé. Nmopê, Nmye wanî yipê, ngmênê nmyi gha dmi mb꞉aamb꞉aa ngê dny꞉oo ya. Nmopê, A nuu ghi ndêndê ngê nmyi nódo wo tóó, ye w꞉aa pêdmyinê pyw꞉ee ngmê, mu kópu u dîy꞉o M꞉aa ka diyédiyé a ka mb꞉aamb꞉aa. Nmopê, Ala ngwo a pi têdê, yi ngwo a pi ndîî ngê wamî pyódu, M꞉aa u che p꞉ââ pee ngê an꞉uu pyódu. ");
INSERT INTO yle_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nmopê, Yi kópu knî ghêlî doongê pyaa dniye, u ngwo nmye dî vyi té, mu kópu u dîy꞉o a ka pêdmyina a kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nmopê, Doo u ntââ dye ghi daadîî noko daanmî danê, mu kópu u dîy꞉o Setan u lede yoo daa kêmakêma wunê pwiyé dniye. ");
INSERT INTO yle_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nmopê, Setan u kópu a p꞉uu daa t꞉a, yinê daa y꞉enê nê, ngmênê kópuni awêde a nga a d꞉uud꞉uu, u kwo daanî kwódu. Nmopê, Yi kópu u l꞉êê dîy꞉o M꞉aa ngê al꞉ii a dy꞉ââ noo. Nmopê, Pi yintómu yi lama pîchoo ya, dye ghi yintómu M꞉aa u dnye n꞉aa nyêmî ngê. Nmopê, Ghêêdî kmêle, kn꞉aa lee kmêle. ");
INSERT INTO yle_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu ngê mgongo nmo ngmê kwólu, nmopê, M꞉aa ngê nté kn꞉ââ ngmê kââ, nê vyîlo. ");
INSERT INTO yle_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nmopê, A kpâlî woni knî yi p꞉uu nt꞉u d꞉uudpî kaalî, M꞉aa ngê dpo châpwo té, dpî kéé té. Nmopê, N꞉ii knî yi p꞉uu nt꞉u dpî kaalî, yini mb꞉aamb꞉aa dé. Nmopê, M꞉aa ngê mb꞉aamb꞉aa ngê dpî pyódu té, dyââpe n꞉ii p꞉uu a ya yédi, dpo châpwo té, dpî kéé té, dpo, Nt꞉u mb꞉aamb꞉aa ngê paa kaa we. ");
INSERT INTO yle_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nmopê, Kópuni nmye nî vyi too, yi kópu knî y꞉oo mb꞉aamb꞉aa ngê wunê kî pyódu nmyoo. ");
INSERT INTO yle_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nmopê, Ngmidi ngê ya kmêle. Nmopê, Nangê kéé nê, myedaanî kéé nmyo. Nmopê, Yi kpâlî ngmanyinê châpwo, dpî pw꞉onu, nt꞉u p꞉uu d꞉uudpî kaalî. Nmopê, Nmyo myentee dé, anmyinê kuwo nê, nmyi nt꞉u dmi daawa kaalî. ");
INSERT INTO yle_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nmopê, Nê nté kn꞉ââ, nmyo a kpâlî dé. Nmopê, N꞉ii ngê daawa a kuwo nê, ngmidi ngê u k꞉ii any꞉oo ya, yi pini nt꞉u mb꞉aamb꞉aa ngê wa kaalî. ");
INSERT INTO yle_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nmopê, Wanmyinê kuwo nê, ye nmyi chóó kópu mb꞉aa daangmanmyi d꞉uu ngmê. Nmopê, N꞉ii ngê wa a kuwo nê, M꞉aa ngê wa kéé. Nmopê, Yi yini kpâlî wa pw꞉onu, ntóó ngê wa pyódu, ndiya wa kéé, ndê ngê wa ma. ");
INSERT INTO yle_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nmopê, A k꞉ii ngmidi ngê anmî ya, a kópu dyuu p꞉uu anmyi nuw꞉o, ye M꞉aa ka kópuni anmya a dmyinê, nmyi l꞉êê dîy꞉o wa a d꞉uu. ");
INSERT INTO yle_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nmopê, Dmyina a nj꞉ii nê, nmyi nt꞉u dmi mb꞉aamb꞉aa ngê dpî kaa we, ye pi knî y꞉oo Chóó Lémi u pi ndîî ngê u ngwo wa pyódu ngmê. ");
INSERT INTO yle_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nmopê, A nuu ghi M꞉aa nódo ntee a tóó, nmyi nuu ghi dmi yinté a nódo mye tóó. Nmopê, Dye ghi yintómu a nuu u yoo ngê dmyinê kwo. ");
INSERT INTO yle_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nmopê, Kópuni nmye nî vyi too, anmyi d꞉uud꞉uu dé, ye a nuu u yoo ngê anmyi kwo. Nmopê, M꞉aa u nuu u pi ngê n꞉aa tóó, mu kópu u dîy꞉o kópuni yintómu a ka a vyi too, nî d꞉uu too. ");
INSERT INTO yle_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nmopê, Yi kópu knî nmye yidî vyi té, mu kópu u dîy꞉o M꞉aa p꞉uu w꞉aa ntee nê pyw꞉ângo, w꞉aa d꞉ud꞉umbiy꞉e a p꞉uu yinté myedmyina a pyw꞉êmî. ");
INSERT INTO yle_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nmopê, Ala a dêêpî kópu, Nmye ntee nînê vyuwo, noko yinté myedmyinê vyuwo. ");
INSERT INTO yle_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nmopê, Nmye nînê vyuwo, kópu ndîî amy꞉aa d꞉uu, nmyi l꞉êê dîy꞉o a ghê wanî y꞉oo, u ngwo anî pw꞉onu, mu kópu u dîy꞉o nmyi nuu ghi dmi a nódo dnyinté daa tóó. Nmopê, Dmyina a nj꞉ii nê, nmyi nuu ghi dmi numo nódo choo ya. ");
INSERT INTO yle_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nmopê, A kópu dyuu anmyi d꞉uud꞉uu dé, ye nmyo ndêndê ngê a pyipe yoo. ");
INSERT INTO yle_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nmopê, Nmyo a pyipe yoo. Nmye daamonî vyi, A dpodo pyu yoo, mu kópu u dîy꞉o kópuni lémi ndîî ngê a d꞉uud꞉uu ngê, u dpodo pyu knî ye daa tpapê ngê, u pyipe knî ye a tpapê ngê. Nmopê, M꞉aa ngê kópuni yilî a ka a vyi too, wunê nmye kîdî vyi té. Nmopê, A pyipe yoo, M꞉aa k꞉ii nuw꞉oni nyi mênê a tóó, nmyi mênê myeka tóó. ");
INSERT INTO yle_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nmopê, Dpîp꞉e ngmidi noo, a chóó p꞉ee nê ngmidi nmyoo. Nmopê, Dpodo têdê n꞉ii nî kaa nmyoo, yi dpodo têdê nmyi nt꞉u dmi mb꞉aamb꞉aa ngê dp꞉uu kaa we, yi dpodo chedê ngê kîngî pyódu. Nmopê, Yi dpodo têdê M꞉aa ka a pi ngê kópuni anmyi dmy꞉ee ngmê, nmye wa a kê. ");
INSERT INTO yle_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nmopê, Ala kópu dmyinê d꞉uud꞉uu, numo ka mb꞉aamb꞉aa ngê dmyinê vyuwo. ");
INSERT INTO yle_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu ngê nmopê, Kópu ngmê p꞉uu nmyi ng꞉aa dmi n꞉aa t꞉emî. Nmopê, Mgîdî u yoo knî ye ntee n꞉aa diya yédi, yinté ye am꞉ii diya dmi. ");
INSERT INTO yle_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nmopê, Mgîdî u yoo knî yi k꞉ii ngmidi ngê w꞉ee pyede, ye yi nuu u yoo ngê p꞉ee pyede, ngmênê yi yéli yi vy꞉o nê ngmidi nmyoo, yi vy꞉o mêdp꞉ee wee, yi kópu u l꞉êê dîy꞉o ye dmyi diya dmi. ");
INSERT INTO yle_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nmopê, Ala kópu wunê nmye kîdî vyi, Dpodo pyu u pi têdê, u kada pini u pi ndîî. Nmopê, Yi kópu p꞉uu dmyinê nuw꞉o, u nt꞉u kópu m꞉uu ala, Mgîdî u yoo knî y꞉oo dono a nga a d꞉uud꞉uu ngmê, nmye amyednyi d꞉uud꞉uu. Nmopê, Wo chââchââ nê, pê chââchââ nmyo, a kópu dyuu wo ny꞉ee ngópu, ye nmyi kópu dyuu myepaa ny꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nmopê, Yi dono kópu yilî nmye wa d꞉uu ngmê, mu kópu u dîy꞉o nmyo a yoo, daa mya noo, n꞉ii ngê a dy꞉ââ noo, yi lama myedaa tóó. ");
INSERT INTO yle_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nmopê, Yi yéli ye danêmbum têdê wodîp꞉a loo, ye daapî mb꞉ii noo, yi dono ndîî ngê daapî pyodo, ngmênê dono ndîî ngmê d꞉uu ngópu, kî mb꞉ii noo, M꞉aa ngê dpodombiy꞉e u ngwo wa kpada té. ");
INSERT INTO yle_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nmopê, Pini n꞉ii knî ye nî diya wo, yi pini knî ye M꞉aa mye diya wo. ");
INSERT INTO yle_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nmopê, Kópu ndîî n꞉ii yi vy꞉o noo d꞉uud꞉uu dé, yintoo kópu wunê pi ngê daangmê d꞉uu ngê. Nmopê, Yi kópu ndîî yi vy꞉o wodîpî d꞉uu too, ye yi dono ndîî ngê daapî pyodo. Nmopê, K꞉omo tpile yi kópu knî m꞉uu tumo, ngmênê mye mb꞉ii noo, ye nî diya wo, M꞉aa ye mye diya wo. ");
INSERT INTO yle_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nmopê, Kópuni puku yedê a tóó ndêndê ngê a ntiyentiye ngmê, doo u ntââ daawa kn꞉aadi ngmê. Nmopê, Yi kópu ala, D꞉ud꞉umbiy꞉e módó ye nî diya wo. ");
INSERT INTO yle_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","27","Yesu ngê nmopê, Wo yéli ye nî diya wo, ngmênê dini ghi n꞉ii ngê M꞉aa u Ghê Dmi nmye wanê dy꞉ââ, yinê wa ngee nmyo, pi knî ye a p꞉uu anmyin꞉aa danê, nmyi kópu dyuu ndê kópu ngê ye yinê wa pyódu té. Nmopê, Kópuni nî vyi too, kópuni nî d꞉uu too, nmyi lama mb꞉aamb꞉aa ngê ka pyede. A dpodo kn꞉ââ dini ghi n꞉ii ngê nê chópu, a p꞉uu u ngwo nmyinê kaa dniye, dye ghi daadîî nipi nmee a ya, u dî awêde. ");
INSERT INTO yle_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nmopê, Dono kópu n꞉ii nmye wadnyi d꞉uud꞉uu dé, nmyi ng꞉aa dmi n꞉aa t꞉emî, ");
INSERT INTO yle_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","mu kópu u dîy꞉o dini ghi n꞉ii ngê nmye wa pyaa dmi, u ya a nga daa kwo, Ala kópu paa vyi yó, Nê ngê lukwe dîy꞉o dóó nmoo, dono vy꞉o anmî wee, u nkwo nmo kpîpîkpîpî. Nmopê, Nju tpémi y꞉oo kópu dono yilî nmye adnyi d꞉uud꞉uu dé, wa kéé nmyo, nmyi yoo kuwa wa kaa nmyo, yi ngêpê ngomo k꞉oo koko nmye wa kwódu ngmê. Nmopê, U kuwó dini ghi ngê amyednyi vyee nmyo, nmyi vy꞉o woni yi ghê wa a ngî t꞉oo, ala kópu u ngwo adnyi tpapê, awo, Ala Chóó Lémi u dpodo yino dódó. ");
INSERT INTO yle_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nmopê, Yi kópu yilî nmye adnyi d꞉uud꞉uu, mu kópu u dîy꞉o M꞉aa k꞉ii yi lama d꞉ii tóó mo. ");
INSERT INTO yle_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nmopê, Yi kópu knî yi pi dmi nmye kîdî vyi té, mu kópu u dîy꞉o dini ghi n꞉ii ngê nmye wa pyaa dmi, nmyinê nmye daa kópu kamî ngê adnyi ya, ngmênê u ngwo anmy꞉uu nuw꞉o kalê ngmê, anye, Nê ngê yi pi dmi mwiyé nmo mwo a vyu. Yesu ngê nmopê, Kópuni nmye dî vyi té, wunê nmye dîpî vyi too, mu kópu u dîy꞉o dye ghi yintómu nmyi vy꞉o noo kwo. ");
INSERT INTO yle_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nmopê, Pini n꞉ii ngê a dy꞉ââ noo, ala ngwo u kwo mênê diyédiyé, ngmênê a ka daanmyi vyi ngmê, Ló y꞉i nye lêpî. ");
INSERT INTO yle_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nmopê, Kópuni nmye dî vyi té yi l꞉êê dîy꞉o nmyi gha dmi dono ngê dê pyódu. ");
INSERT INTO yle_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nmopê, Ndê kópu nmye ngmên꞉aa tpapê, Nmyi mb꞉aamb꞉aa u l꞉êê dîy꞉o n꞉aa lêpî. Nmopê, Daanî nî knomomê, ye nmyi ngêêpî pyu daawa a nî, ngmênê dini ghi n꞉ii ngê anî lê, nmyi ngêêpî pyu nmye anîmo dy꞉ââ. ");
INSERT INTO yle_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Nmopê, Pi yoo yi nuw꞉o dmi ala ngwo alanté a tóó, apu, Nmo Chóó Lémi u yoo mb꞉aa, dono ndîî dpîpîngmê d꞉uu ngê. Nmopê, Chóó Lémi u Ghê Dmi dini ghi n꞉ii ngê wa t꞉aa, yoo woni yi nuw꞉o dmi yinê wa ngmêê, u ngwo wa a w꞉ee ngmê, awo, Chóó Lémi ngê pini n꞉ii a ngmidi ngê, kînmî mb꞉ii ngê, dono ndîî u ngwo ngmênmî d꞉uu ngê. Nmopê, Dini ghi n꞉ii ngê pi knî y꞉oo wa vya nê, ala kópu wa vyi ngmê, awo, Ndêndê kópu yino d꞉uud꞉uu, daa kn꞉aadi te kópu yino d꞉uud꞉uu. Nmopê, Ngmênê Chóó Lémi u Ghê Dmi dini ghi n꞉ii ngê wa t꞉aa, yoo woni yi nuw꞉o dmi yinê wa ngmêê, u ngwo wa a w꞉ee ngmê, awo, Kn꞉aadi te kópu ndîî ngmêkînmî d꞉uu ngê, pini n꞉ii nmî vyâ, pi mb꞉aa, u dono daa tóó, kpêênî daa mgee wo, Chóó Lémi ngê mêdê pyidu ngê, u kwo mê diyé wo, nmî vy꞉o mêdaa kwo. Nmopê, Pi yoo yi nuw꞉o dmi ala ngwo alanté a tóó, Chóó Lémi ngê pi doongmê kóté kwólu, myedaawa kóté kalê nmo. Nmopê, Ngmênê Chóó Lémi u Ghê Dmi dini ghi n꞉ii ngê wa t꞉aa, mgîdî u yoo woni yi nuw꞉o dmi wa ngmêê té, u ngwo wa a w꞉ee ngmê, awo, Chóó Lémi ngê Setan wunê dê kóté kwolo, ntââ u ngwo wa a vy꞉u, nmo amyedê vy꞉u. ");
INSERT INTO yle_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Yesu ngê nmopê, Kópu ndîî yilî a mênê ka tóó. Nmopê, U ya a nga ka kwo, Nmye nî vyi té, ngmênê u nyêmî ngê dp꞉ee ntââ dé ala ngwo. ");
INSERT INTO yle_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","14","Nmopê, Dini ghi n꞉ii ngê Chóó Lémi u Ghê Dmi wa t꞉aa, ndê kópu yintómu knî yi maa komo nmye yinê wa a kêma. Nmopê, Kópuni ghêlî doongê pyaa dniye, nmye u ngwo amî vyi té. Nmopê, Doo u kópu dyuu nmye ayidên꞉aa tpapê, ngmênê a kópu dyuu nmye ayidên꞉aa tpapê, a pi ndîî ngê u ngwo amî pyódu. ");
INSERT INTO yle_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nmopê, Nmye d꞉oo vyu, M꞉aa u kópu dyuu nmye ayidên꞉aa tpapê, ngmênê nmyed꞉ê, A kópu dyuu nmye ayidên꞉aa tpapê, mu kópu u dîy꞉o kópuni M꞉aa u nêni dé, mya a nêni dé. ");
INSERT INTO yle_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu ngê nmopê, Daa ndîî la ghi tp꞉oo ala ngwo nmyi vy꞉o anî kwo, ye daamunmyi m꞉uu nê. Nmopê, U kuwó dini ghi ngê daa ndîî la ghi tp꞉oo ayimî lê, u ngwo am꞉ii m꞉uu nê. ");
INSERT INTO yle_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","P꞉uu ndiye pyu knî ngmê noko dnye póó, apu, Lukwe p꞉uu nmo ka danê? Apu, Ala kópu a tpapê, Daa ndîî la ghi tp꞉oo ala ngwo nmyi vy꞉o anî kwo, ye daamunmyi m꞉uu nê. U kuwó dini ghi ngê daa ndîî la ghi tp꞉oo ayimî lê, u ngwo am꞉ii m꞉uu nê. Apu, Ala kópu mye tpapê, Mu kópu u l꞉êê dîy꞉o M꞉aa ka n꞉aa lêpî. ");
INSERT INTO yle_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Apu, Yi daa ndîî la ghi tp꞉oo u nt꞉u kópu lukwe? Apu, Kópuni a tpapê, dp꞉oongê w꞉ee ngê. ");
INSERT INTO yle_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu u lama doo ya, apê, U yi y꞉e a kwo, Yi kópu u nt꞉u kópu nê ka nmî poo, wod꞉oo nmopê, Ala kópu u l꞉êê dîy꞉o noko nmye póó té, Daa ndîî la ghi tp꞉oo ala ngwo nmyi vy꞉o anî kwo, ye daamunmyi m꞉uu nê, u kuwó dini ghi ngê daa ndîî la ghi tp꞉oo ayimî lê, u ngwo am꞉ii m꞉uu nê. ");
INSERT INTO yle_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nmopê, Ndê kópu nmye ngmên꞉aa tpapê, Anmyi mbê, amyenmyi yii, ngmênê mgîdî u yoo yi nuw꞉o dmi mb꞉aamb꞉aa ngê wa pyódu. Nmopê, Nmyi nuw꞉o dmi dono ngê adî ya, ngmênê u kuwó dini ghi ngê nmyi nuw꞉o dmi mb꞉aamb꞉aa ngê amê pyódu, nmyi gha dmi amye ndê. ");
INSERT INTO yle_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nmopê, Dini ghi n꞉ii ngê mbwili ngê pwopwo dpî kaalî, mgînî vyîmî n꞉ii a kîgha ngê, u nuw꞉o dono ngê dpî pyódu, ngmênê dini ghi n꞉ii ngê tp꞉ee dpî t꞉a, u mgînî vyîmî anyi dpî yé, mu kópu u dîy꞉o u gha mb꞉aamb꞉aa ngê dpî pyódu, dpo, A tp꞉ee kêdê t꞉a. ");
INSERT INTO yle_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nmopê, Nmyo myentee dé, nmyi nuw꞉o dmi dono ngê dê pyódu, ngmênê am꞉aa m꞉uu nmyo, nmyi nuw꞉o dmi mb꞉aamb꞉aa ngê amê pyódu, w꞉aa amyenmyinê pyw꞉ee ngmê, doo u ntââ pi ngmê ngê yi w꞉aa nmyi mênê daawa a ngî. ");
INSERT INTO yle_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nmopê, Yi wéni ngê kópu a ka daangmanmyi poo ngmê. Nmopê, Ndê kópu nmye ngmên꞉aa tpapê, Kópuni M꞉aa ka a pi ngê wanmyi dmy꞉ee ngmê, nmye wa a kê. ");
INSERT INTO yle_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nmopê, Kópu a pi ngê dmy꞉oongmê dmy꞉ee ngópu. Nmopê, A dpodo u l꞉êê dîy꞉o kópuni u yi nmye adî kwo, M꞉aa ka dmyinê dmyinê, nmye ada a kuwo, mu kópu u dîy꞉o w꞉aa ndêndê ngê pêdê pyw꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesu ngê nmopê, Kópu yilî yi p꞉uu nmye noo mgongo, ngmênê mu dini ghi ngê nmye mêdaanî mgongo, M꞉aa p꞉uu ntênê nmye anîn꞉aa danê. ");
INSERT INTO yle_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nmopê, Yi dini ghi ngê kópuni u yi nmye adî kwo, M꞉aa ka a pi ngê dpî dmy꞉ee yó. Nmopê, Ala kópu dînî tpapê, Yi kópu nmyi l꞉êê dîy꞉o M꞉aa ka wanî dmyinê, mu kópu u dîy꞉o M꞉aa chóó nmye wunê vyuwo. ");
INSERT INTO yle_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nmopê, Nmyi nuu ghi dmi M꞉aa nódo a tóó, mu kópu u dîy꞉o a nuu ghi nmyi nódo a tóó, mye ala kópu u l꞉êê dîy꞉o, ala kópu ka nmyi kêlîmî mbê dniye, Nê M꞉aa ka a ndê wo. ");
INSERT INTO yle_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nmopê, Nyââ, M꞉aa ka nê ndê wo, dyámê mbêmê nmye nê loo, ala ngwo dyámê mênînê kuwokuwo, M꞉aa ka mênê diyédiyé. ");
INSERT INTO yle_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yi kópu y꞉oo nyongo, wod꞉oo ala kópu u kwo nmî vyu, kwonmo, Kópu yilî mb꞉aamb꞉aa ngê anmînê wopwe, mêd꞉ee mgongo. ");
INSERT INTO yle_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kwonmo, Ala ngwo nmî lama dê yââ, kópu yintómu ḻama ka tóó. Kwonmo, K꞉omo tpile kópu ṉga daanmî póó, ngmênê kópuni nmî mênê a pyede, wunê kîchi m꞉uu té. Kwonmo, Yi kópu u l꞉êê dîy꞉o ala kópu ka dpî kêlîmî mbê dmi, Chóó Lémi ka nyinê ndê wo. ");
INSERT INTO yle_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","32","Yesu ngê nmopê, Ala ngwo nmye kêlîmî té, ngmênê daa kêmakêma nmyi p꞉o p꞉o nmye mbêpêmbêpê té, a mo nmyinê kuwokuwo nê. Nmopê, Daa d꞉ud꞉umbiy꞉e a mo nmyinê kuwokuwo nê, ngmênê M꞉aa a p꞉uu a t꞉a. ");
INSERT INTO yle_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nmopê, Yi kópu nmye dî vyi té, mu kópu u dîy꞉o nmyi nuw꞉o dmi a p꞉uu daapaa dyênê we. Nmopê, Mgîdî u yoo knî y꞉oo dono kópu nmyi p꞉uu yilî wa d꞉uu ngmê, ngmênê nkîngê ngê kêê nangê t꞉oo, mu kópu u dîy꞉o a wêdêwêdê yi pwo dê lê, wa dêê dmi. ");
INSERT INTO yle_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu ngê u danêmbum dini ghi n꞉ii ngê nmo a kêlî ngê, mbóó p꞉uu vyu wo, Chóó Lémi ka kwo, M꞉aa. Kwo, Kópuni u l꞉êê dîy꞉o dyámê mbêmê nê loo, yi kópu u dye ghi ala. Kwo, Yoo yi ngwolo dmi a pywálî ngi, ala kópu paa vyi y꞉e, Kî Chóó Lémi Tp꞉oo. Kwo, M̱i ndîî ngê u ngwo wa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kwo, Pi yintómu knî yi l꞉êê dîy꞉o nyinê dy꞉ââ noo, mu kópu u dîy꞉o yélini a ka nyinê kpo, nîmo, Yi nuw꞉o dmi kamî ngê p꞉aa pyódu, ghê kamî ye p꞉aa y꞉oo, ghéni n꞉ii chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kwo, N꞉ii ngê ala kópu dpî vyi, dpo, Chóó Lémi nmî yâpwo ndêndê, daamo a tóó, dpo, pini n꞉ii a ngmidi ngê, wu Yesu Kédisu, kwo, yi pini ngê ghê kamî dpo pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kwo, M꞉aa. Kwo, Dpodoni a ka nyinê kê too, kînî chedê too, dyámê mbêmê m̱i ndîî ngê nî pyódu ngê. ");
INSERT INTO yle_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kwo, Dyámê pê ghêlî dêpwo a kwo, dini ghi n꞉ii ngê nipi nyipu a ya, a pi ndîî ngê ntee doo a ya, yintoo ngê mêdê pyódu ngi. ");
INSERT INTO yle_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yesu ngê kwo, M꞉aa, yélini mgîdî u yoo vy꞉o nyinê y꞉ee too, a ka nyinê kê too, yi yéli ye ntênê nê kêma nyoo. Kwo, Yi yéli ṉyoo vy꞉o yéli, a ka nyinê kê too, ṉgópu dyuu ka mb꞉aamb꞉aa ngê ng꞉aa mbê dniye. ");
INSERT INTO yle_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kwo, Yi lama ka tóó, A kópu yintómu daa a mo a kópu dé, ngmênê a ka nyinê kê too. ");
INSERT INTO yle_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kwo, Kópuni a ka nyinê vyi too, ye kînî vyi too, kî ny꞉ee tumo. Kwo, Ala kópu ndêndê ngê yi lama a tóó, Ṉga nê ndê wo, ala kópu ka mye kêlîmî mbê dniye, ṉ́yóó nyinê dy꞉ââ noo. ");
INSERT INTO yle_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Yesu ngê kwo, M꞉aa, Yi kópu knî yi dîy꞉o ala yéli yi l꞉êê dîy꞉o ṉga nînê ngêpê. Kwo, Daa mgîdî u yoo knî yi l꞉êê dîy꞉o ṉga nînê ngêpê, ngmênê yélini a ka nyinê kpo yi l꞉êê dîy꞉o ṉga nînê ngêpê, mu kópu u dîy꞉o ṉ́yóó ṉyoo. ");
INSERT INTO yle_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kwo, Yélini a yoo, myenté ṉyoo, yélini ṉyoo, myenté a yoo. Kwo, Yi l꞉êê dîy꞉o pi knî y꞉oo a pi wa km꞉êê ngmê. ");
INSERT INTO yle_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kwo, Daa kêmakêma ṉga nînê lêpî, mgîdî u yoo vy꞉o a yoo nînê kuwokuwo. Kwo, M꞉aa. Kwo, Nyi mu ngmidi yâpwo ndêndê. Kwo, M̱i ngê nê loo, mb꞉aamb꞉aa ngê ye nê kêma nyoo, ye mb꞉aamb꞉aa ngê micha a vyuwo, a yoo vy꞉o kîngê pwii dmi, mu kópu u dîy꞉o ngmidi ngê ntee nye tóó mo, yinté ngmidi ngê pîdny꞉oo ya. ");
INSERT INTO yle_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kwo, Dini ghi n꞉ii ngê yi vy꞉o noo kwo, m̱i mbêmê mb꞉aamb꞉aa ngê ye noo vyuwo, yi l꞉âmo dêp꞉êngmê ngópu, ngmênê mu ngmidi l꞉âmo d꞉a ngee, pini n꞉ii ngê doo u ntââ dono u maa d꞉uuwodê kuwo. Kwo, Puku yedê kópuni a tóó, yi pini ngê yinê a ntiyentiye. ");
INSERT INTO yle_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kwo, Ala ngwo ṉga anînê lêpî, dyámê pê ghêlî d꞉oongê kuwo ngê, yi kópu knî u ngwo ṉga d꞉a vyi té, mu kópu u dîy꞉o w꞉aani a mênê a tóó, nyi yoo yi mênê d꞉ud꞉umbiy꞉e myepîchoo ya. ");
INSERT INTO yle_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kwo, Kópu dyuu n꞉ii a ka nyinê kpo, yi kópu dyuu ye kînî vyi too, mgîdî u yoo knî ye yi yéli u ngwo wa diya dmi. Kwo, Mgîdî u yoo knî yi nuw꞉o u mo, a nuw꞉o u mo. Kwo, Nyi yoo myenté, yi nuw꞉o u mo, mgîdî u yoo yi nuw꞉o u mo. Kwo, Yi kópu u l꞉êê dîy꞉o mgîdî u yoo knî ye nmî diya dniye. ");
INSERT INTO yle_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kwo, Ṉga dênînê tpapê, Nyi yoo dyámê mbêmê a ngî té, ngmênê Setan kwulo dpî dyé té. ");
INSERT INTO yle_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kwo, Ala kópu ṉga mud꞉a vyi, A nuw꞉o u mo, mgîdî u yoo yi nuw꞉o u mo, nyi yoo myenté, yi nuw꞉o u mo, mgîdî u yoo yi nuw꞉o u mo. ");
INSERT INTO yle_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kwo, M꞉aa. Kwo, Yélini yi l꞉êê dîy꞉o ṉga nînê ngêpê, ṉyoo mb꞉aa ngê a pyódu té. Kwo, Ṉgópu dyuu ndêndê yi mênê choo kwo. Kwo, Yi kópu u l꞉êê dîy꞉o daa yi chóó yi p꞉uu pîdny꞉oo dpodo, ngmênê m̱꞉uu dny꞉oo dpodo. ");
INSERT INTO yle_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kwo, Mgîdî u yoo vy꞉o ntee nyinê dy꞉ââ noo, nyi yoo mgîdî u yoo vy꞉o yinté myidî dy꞉ââ té. ");
INSERT INTO yle_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kwo, A chóóchóó ṉga d꞉a kê, mu kópu u dîy꞉o ṉye ntênê n꞉aa nyêmî, ṉye ntênê myedny꞉oo nyêmî. ");
INSERT INTO yle_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Kwo, Daa ala yéli yi mo yi l꞉êê dîy꞉o ṉga nînê ngêpê, ngmênê ala yéli yi kópu dyuu mbêmê dîyo yélini a ka wa a kêlîmî mbê dmi, yi yéli yi l꞉êê dîy꞉o ṉga myenînê ngêpê. ");
INSERT INTO yle_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kwo, Yi nuw꞉o dmi ngmidi ngê dny꞉oo ya. Kwo, M꞉aa. Kwo, Ngmidi ngê ntee nye tóó mo, yi yéli yi k꞉ii yinté ngmidi ngê myepaa ya kmêle. Kwo, Ngmidi ngê pîdny꞉oo ya, mu kópu u dîy꞉o pi yoo ala kópu ka paa kêlîmî mbê dniye, Ṉ́yóó nyinê dy꞉ââ noo. ");
INSERT INTO yle_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kwo, A nuu ghi ntee ṉódo a tóó, ala yéli yi nuu ghi dmi yinté a nódo my꞉aa yó, mu kópu u dîy꞉o ngmidi ngê ntee nye tóó mo, yinté ngmidi ngê myedny꞉oo ya. ");
INSERT INTO yle_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kwo, Nyi nuw꞉o dê ntee a tóó mo, yi nuw꞉o dmi yinté myedê pyódu ngi, mu kópu u dîy꞉o d꞉ud꞉umbiy꞉e ngmidi ngê pîdny꞉oo ya, yoo yi lama u ngwo paa yaa we, awo, Chóó Lémi ngê nê yinê a dy꞉ââ ngê, nê ka ntee doo a vyuwo, nê u yoo knî ye yinté myekîyedê vyuwo. ");
INSERT INTO yle_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Yesu ngê kwo, M꞉aa. Kwo, Ala yéli a ka nyinê kpo, kwéli n꞉aa lêpî, u ya a nga a kwo y꞉i myepêdê lee dniye, y꞉i ntee noo a lémilémi, yi lémilémi paan꞉aa m꞉uu y꞉e. Kwo, Dyámê pê ghêlî dêpwo a kwo, a nuu ghi ṉódo doo a ya, lémi ngê u ngwo nyinê pyódu noo. ");
INSERT INTO yle_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kwo, M꞉aa. Kwo, Kn꞉aadi te kópu ḻama daa tóó. Kwo, Mgîdî u yoo yi lama d꞉ii tóó, ngmênê a lama nye tóó, ala yéli yi lama ala kópu mye tóó, ṉ́yóó nyinê dy꞉ââ noo. ");
INSERT INTO yle_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kwo, Ntênê ye nê kêma nyoo, ṉgakêmê ye my꞉aa chámê ngê, ngmênê ye am꞉aa a tpapê, mu kópu u dîy꞉o ṉuu u pi ngê ntee noo a ya, ṉuu u yoo ngê yinté myepêdny꞉oo a ya, yi k꞉ii nmî nuw꞉o ngmidi ngê pêchoo ya. ");
INSERT INTO yle_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Dini ghi n꞉ii ngê Yesu ngê u Mî ka ngêpê chedê ngê, Njedusalem nmo kuwo ngê, mbwaa tp꞉oo ngmênmî ngmópu, u pi Kidîlon, myângo ndîî ngmê u mênê nmî ch꞉iy꞉e dniye. ");
INSERT INTO yle_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Pini n꞉ii Yesu u kwódo ngê ghê wo, Njudas, yi pini u lama yi myângo doo ya, mu kópu u dîy꞉o Yesu ngê Njudas u k꞉ii daa ng꞉êêntómu y꞉i ńuw꞉o nmoo. ");
INSERT INTO yle_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Wod꞉oo Njudas ngê yi mgîdî ngê y꞉i a pyw꞉ee nmoo. Yoo ngmê yi kada doo kwo. Yi yéli yi vy꞉o Lóma lede yilî doo kwo, Chóó Lémi u ngomo t꞉âât꞉ââ pyu yoo yi vy꞉o myednye kwo. Kpêê yiyé pyu yoo yi kada pini yoo, Pádisi yoo yi k꞉ii yi yéli y꞉oo a dy꞉ââ tumo. Yi kaa taa a ńuw꞉o tumo, yi pywápê dmi yi lam dé myedê ńuw꞉o tumo, nmo u ngwo a lee dniye. ");
INSERT INTO yle_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu u lama yaa wo, apê, Daa kêmakêma kópu yilî yintómu a nga a d꞉uud꞉uu ngmê, wod꞉oo ye loo, yepê, N꞉uu ka nmye vyuwo té? ");
INSERT INTO yle_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kwo, Yesu, pini n꞉ii Nasalet pi. Yesu ngê yepê, Ala nê vyîlo, a chóó n꞉aa tóó. Pini n꞉ii Yesu u kwódo ngê ghê wo, Njudas, yi vy꞉o doo kwo. ");
INSERT INTO yle_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu ngê Chóó Lémi u pi dini ghi n꞉ii ngê ye vyu, yepê, A chóó n꞉aa tóó, u ngwo ngwéti dniye, wod꞉oo a mbee ngópu, yoo woni têpê mbêmê tpalê dniye. ");
INSERT INTO yle_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Myombó Yesu ye mê póó wo, yepê, N꞉uu ka nmye vyuwo té? Kwo, Yesu, pini n꞉ii Nasalet pi. ");
INSERT INTO yle_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu ngê yepê, Wunê nmye kîdî vyi, Ala nê vyîlo, a chóó n꞉aa tóó. Yepê, Pini n꞉ii ka nmye vyuwo té, kîdmyinê pyw꞉ee ngmê, ngmênê a p꞉uu ndiye pyu knî yi p꞉uu kêê nangmê yé, dpî dy꞉ââ tóó. ");
INSERT INTO yle_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Yi kópu ye vyu, mu kópu u dîy꞉o u Mî ka kópuni vyu, ndê kópu ngê pyaa we, kwo, M꞉aa, yélini a ka nyinê kpo yi l꞉âmo dêpêngmê ngópu.) ");
INSERT INTO yle_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita ngê u yi doo kwo, Lede yoo nî vya té, wod꞉oo u taa a ngêêdî, lede ngmê mbwámê pêdê châpwo, ngmênê kn꞉aadi ngê, u wéni pee ngwene ngópu. Yi lede u pi Mélika, kpêê yiyé pyu yoo yi kada pini u dpodo pyu ngmê. ");
INSERT INTO yle_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu ngê Pita ka kwo, Ṉ́aa u dópo mênê mê kédi. Kwo, Lukwe, u yi ṉga a kwo, M꞉aa ngê dono u mbwaa n꞉ii a ka a kpo u wépi nî puwâ? Kwo, Kêle, n꞉aa ndanî. ");
INSERT INTO yle_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lede yoo yi kada pini ngê yepê, Mgîmî yó, yedê ngê kudu yó, wod꞉oo lede knî y꞉oo Nju tpémi yi k꞉ii Yesu mgîmî ngópu, kóó dê kudu dumo, ");
INSERT INTO yle_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anas ka mwiyé ńuw꞉o ngópu, pini n꞉ii tp꞉oo módó Kayapas ngê nyââ. ");
INSERT INTO yle_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayapas kpêê yiyé pyu yoo yi kada pini ngê doo ya, yi m꞉aani ngê. Yi Kayapas ngê Nju tpémi yi kada pini knî ye mwiyé a vyu, yepê, Maa mb꞉aa ala, pi ngmidi pi yintómu yi l꞉êê dîy꞉o paa pw꞉oo we. ");
INSERT INTO yle_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Dini ghi n꞉ii ngê Yesu mgîmî ngópu, Njedusalem ńuw꞉o ngópu, Saimon Pita k꞉ii nyipu yâmuyâmu dé. Kpêê yiyé pyu yoo yi kada pini u ngomo mbwa kalê ngmê k꞉oo dini ghi n꞉ii ngê Yesu km꞉êê ngópu, Pita kuwa nê kuwo ngê, a k꞉ii nmî kee dniye, mu kópu u dîy꞉o kada pini u lama noo ya. ");
INSERT INTO yle_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Myombó mênê diyé wo, keńe dmââdîni ngê doo t꞉âât꞉ââ, kwonê, Kî pini a kmini. ");
INSERT INTO yle_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pita yedê kee wo, yi dmââdî ngê kwo, D꞉ii wu pini p꞉uu ndiye pyu ngmê, apii? Pita ngê kwo, Nyââ, nê kuu. ");
INSERT INTO yle_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yi dini ghi ngê nkuwo ndîî ngê pyodo, wod꞉oo ndyuw꞉e ngmê kpê ngópu, yi ngomo chóó u dpodo pyu yoo, Chóó Lémi u ngomo t꞉âât꞉ââ pyu yoo yi k꞉ii, ndoo chedê dnye kwo. Pita yi vy꞉o myimî ghê wo, myedoon꞉aa ndê vyîlî. ");
INSERT INTO yle_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kpêê yiyé pyu yoo yi kada pini Yesu ka p꞉uu ndiye pyu knî yi l꞉êê dîy꞉o doo póó, kópuni nmo doo tpapê dé yi l꞉êê dîy꞉o u kwo myedoo póó. ");
INSERT INTO yle_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu ngê kwo, Pi yilî yi ngîma nîmo danêmbum. Kwo, Nju tpémi kwéli wunê wó ngê, Chóó Lémi u ngomo k꞉oo, ngêpê ngomo knî yi k꞉oo, y꞉i ye nîmo a danêmbum. Kwo, Tumu kópu d꞉oongmê vyu. ");
INSERT INTO yle_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kwo, Lukwe dîy꞉o nye p꞉oop꞉oo nê. Kwo, A kópu dyuu n꞉ii knî y꞉oo ny꞉ee tumo, ye ngî péé, yi kópu yi lama a pyede. ");
INSERT INTO yle_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Dini ghi n꞉ii ngê Yesu ngê yi kópu yi vyu, lede ngmê ngê kopwe u te knâpwo puwâ, kwo, Lukwe dîy꞉o nmî kada pini u dnye nye vyee. ");
INSERT INTO yle_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu ngê kwo, Pi knî ye kópu dono w꞉aangmê vyu, ye ala léma ye yi kópu yuu pîcha y꞉oo. Kwo, Ntênê n꞉aa mbumu, lukwe dîy꞉o kopwe a te knâpwo chi puwâ. ");
INSERT INTO yle_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","U kuwó dini ghi ngê Anas ngê Kayapas ka Yesu dy꞉ââ ngê. Yedê kwulo daa pywálî ngópu, p꞉uu modoo ya. ");
INSERT INTO yle_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Yi dini ghi ngê Pita ndoo chedê modoo kwo. Pi ngmê knî y꞉oo kwo, D꞉ii wu pini p꞉uu ndiye pyu ngmê, apii? Pita ngê a wópu ngê, yepê, Nê kuu. ");
INSERT INTO yle_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pita ngê pini n꞉ii ngwene ngópu, yi pini u mbwó kada pini u dpodo pyu ngmê, ndoo chedê myedoo ya, Pita ka kwo, Ndoo apê nyi vyîlo, wu pini p꞉uu myângo vy꞉o kîdî m꞉uu ngi. ");
INSERT INTO yle_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita ngê mêdê wópu ngê, wod꞉oo kêmkêm ka wo. ");
INSERT INTO yle_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kââdî dini ghi n꞉ii ngê a kee wo, Yesu Kayapas u ngomo k꞉oo a pw꞉ii ngópu, Lóma lede yoo yi mââwe ndîî Paléti ka ńuw꞉o ngópu. Nju tpémi yi kada pini yoo Paléti u ngomo k꞉oo daa kee dniye, mu kópu u dîy꞉o apê, Daa Nju pi u ngomo. Apê, Nmo koko té, ye dono pee nmî p꞉uu ngma a kelekele, Chóó Lémi ka dono ngê nmo pyodopyodo té, yed꞉oo Tp꞉ee Kaa W꞉êêw꞉êê u Naa nté doo u ntââ daanmî ma. ");
INSERT INTO yle_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yi Nju tpémi Paléti u ngomo k꞉oo daa kee dniye, wod꞉oo kuwa ye a pwii wo, yepê, Wu pini ngê ló dono kópu ngmêdê d꞉uu? ");
INSERT INTO yle_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Paléti ka kwo, Dono kópu wodaa d꞉uu ngê, ye ṉga daapód꞉oo ńuw꞉o. ");
INSERT INTO yle_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paléti ngê yepê, Ńuw꞉o yó, nmyi chóó nmyi dêêpî kópu dyuu mbêmê nyi kóté kalê yó. Kwo, Machedê. Kwo, Wunê kudu kóté kwolo, ala d꞉o pw꞉oo we. Kwo, Ngmênê pi vyee nmo nmyi kwódu ngópu. Kwo, Nmyi l꞉êê ghi mbêmê nyi vya ngi, kîdosi ńedê nyi t꞉ee ngi. ");
INSERT INTO yle_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Yesu ngê kópuni wunê a vyu, nmopê, Tââ wa km꞉êê nê, u pwopwo p꞉uu kîdosi ńedê u ngwo doo danê, yi kópu Nju tpémi y꞉oo ala ngwo d꞉uu ntiye ngmê.) ");
INSERT INTO yle_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Paléti u ngomo k꞉oo mê diyé wo, lede knî ye yepê, Yesu al꞉ii a ńuw꞉o yó, wod꞉oo u kwo ńuw꞉o ngópu. Yesu ka kwo, Mumdoo nyi Nju tpémi yi king? ");
INSERT INTO yle_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu u kwo póó wo, kwo, Ye kópu ṉ́yóó m̱ênê cha ngî, ó pi knî y꞉oo ṉga y꞉oodê vyi ngmê? ");
INSERT INTO yle_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Paléti ngê kwo, D꞉aa Nju pi. Kwo, Ṉ́yóó ṉyoo knî y꞉oo, yi kpêê yiyé pyu yoo yi kada pini knî yi k꞉ii y꞉oo a ka da ńuw꞉o ngi. Kwo, Ló dono kópu ngmêchi d꞉uu? ");
INSERT INTO yle_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu ngê kwo, Daa dyámê mbêmê tpémi y꞉oo king ngê y꞉oo pyódu noo. Kwo, W꞉aa dyámê pê u king ntee pini, ye a dpodo pyu yoo a l꞉êê dîy꞉o pî l꞉êê té, Nju tpémi y꞉oo daapaa mgîmî nê. Kwo, Daa dyámê mbêmê tpémi y꞉oo king ngê y꞉oo pyódu noo. ");
INSERT INTO yle_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Paléti ngê kwo, Mumdoo nyi king? Kwo, Yi kópu awêde dî ny꞉oo. Yesu ngê kwo, Ṉ́yóó ṉuw꞉o ngê chi vyi, nyimo, Nê king. Kwo, Ngmênê ala kópu mu ngmidi u l꞉êê dîy꞉o dyámê mbêmê nî pyodo, nê, Pi knî y꞉oo ndê kópu yintómu knî yi kn꞉ââ paa m꞉uu y꞉e. Kwo, N꞉ii knî y꞉oo ndê kópu knî yi maa a kîgha ngmê, a dnye y꞉oo nyêmî ngmê. ");
INSERT INTO yle_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Paléti ngê kwo, N꞉uu u ntââ, ndê kópu dé yi kn꞉ââ dpo pyw꞉oo? Wod꞉oo Paléti kuwa mê pwii wo, Nju tpémi ye yepê, Wu pini u kpadakpada u kópu d꞉oongmê pyw꞉ângo. ");
INSERT INTO yle_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yepê, Tp꞉ee Kaa W꞉êêw꞉êê u Naa dye ghi ngê mbwa k꞉oo tpémi yi vy꞉o pi ngmên꞉aa pw꞉iipw꞉ii ngê. Yepê, Nju tpémi. Yepê, U yi nmye a kwo, Nmyi king nî pw꞉ii? ");
INSERT INTO yle_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dpodombiy꞉e u kwo mbwó dniye, kwo, Daa ye pini. Kwo, Mbadapas yi pw꞉ii ngi. (Yi Mbadapas Lóma lede yoo yi p꞉uu mwiyé dpîmo a l꞉êê, mbwa k꞉oo u ngwo kee wo.) ");
INSERT INTO yle_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Wod꞉oo Paléti ngê lede knî ye yepê, Yesu ńuw꞉o yó, yedê kpê dmi ngê nyi kpaka yó, wod꞉oo mî kpaka ngópu. ");
INSERT INTO yle_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lede knî y꞉oo Yesu dnye yumuyumu, noko yipu, King knî yi mbêmê kîdon ntee a kwo nyédi, kî pini mbêmê yinté tpile my꞉oo kaa koo, wod꞉oo yi kóó diidii a ngî tumo, a kmongo tumo, kîdon ntee tpile u ngwo ngmê l꞉âmo ngópu, Yesu mbêmê kaa ngópu. Kpîdî pee mb꞉aa ngmê, king knî y꞉oo yi mbwo ntee dnyimo t꞉emî dé, yinté kpîdî pee mtyemtye u mbwo ngmê t꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","U kuwó dini ghi ngê u kwo dnye lêpî, k꞉omodanê ngê dnya a chipéchipé, kópu, Munmîkó nmî mââwe ndîî, Nju tpémi yi king, u nkwo dnye vyee. ");
INSERT INTO yle_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Paléti kuwa mêdê pwii wo, Nju tpémi ye yepê, Wu pini ngomo k꞉oo nmye mênînê pw꞉iipw꞉ii, nmyi ngîma n꞉aa kapî, mu kópu u dîy꞉o nmyi lama paa yaa we, u kn꞉aadi te kópu d꞉oongmê pyw꞉ângo. ");
INSERT INTO yle_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Wod꞉oo Yesu kuwa a pw꞉ii ngê, yi kóó diidii dmi mbêmê modoo ya, kpîdî mb꞉aa u mbwo myedoo ya. Paléti ngê Nju tpémi ye yepê, Yi pini ala. ");
INSERT INTO yle_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kada pini knî y꞉oo dini ghi n꞉ii ngê m꞉uu ngópu, dpodombiy꞉e mbwó dniye, Paléti ka kwo, Kîdosi ńedê t꞉ee ngi. Kwo, Daadî ya. Wod꞉oo Paléti ye nod꞉e wo, yepê, Yi kópu nmyi lama ma tóó. Yepê, Nmyi chóó nuw꞉o yó, kîdosi ńedê nyi t꞉ee yó. Yepê, U pwopwo u kópu d꞉oo pyw꞉ângo, daa tóó modaa tóó. ");
INSERT INTO yle_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nju tpémi y꞉oo Paléti ka kwo, Nmî dêêpî kópu alanté, Pini n꞉ii ngê Chóó Lémi u pi k꞉omodanê ngê dpî vyi, yi pini anyi vy꞉a. Kwo, Ye pini ngê chóó u komo ngê ala kópu vyu, Nê Chóó Lémi Tp꞉oo. Kwo, Daadî ya, pw꞉oo we. ");
INSERT INTO yle_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Dini ghi n꞉ii ngê Paléti ngê yi kópu nyongo, nkîngê ngê y꞉ay꞉a pwiyé wo, ");
INSERT INTO yle_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","u ngomo k꞉oo mê kee wo, Yesu ka kwo, Ló y꞉i nyinê ndê wo? Yesu ngê kópu u kwo daa vyu. ");
INSERT INTO yle_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Paléti ngê kwo, Lukwe dîy꞉o kópu a ka daanyi vyi. Kwo, Ḻama daa tóó, a kêê k꞉oo nye kwo? Kwo, Ye n꞉aa tpapê, Vya yó, yed꞉oo a vyee ngi. Kwo, Ye n꞉aa tpapê, N꞉aa pw꞉iipw꞉ii, ye kêê ṉga daawa t꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu ngê kwo, Pini n꞉ii nmî pwo a tóó nmî kada pini ngê wodaa pyódu nyoo, ye ṉgêê k꞉oo daapîdî ghê. Kwo, Yi pini u dnye chuu nyongo, módó nye kpadakpada nê. Kwo, Yélini y꞉oo ṉga da ńuw꞉o nê yi dnye dmi yichi ny꞉oo, dono u ngwo chi d꞉uu. Kwo, Ngmênê yi yéli yi dono d꞉ud꞉umbiy꞉e ndîî. ");
INSERT INTO yle_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Paléti ngê yi kópu dini ghi n꞉ii ngê nyongo, d꞉ud꞉umbiy꞉e u yi u ngwo doo kwo, Yesu nî pw꞉ii, ngmênê Nju tpémi dpodombiy꞉e u kwo mbwó dniye, kwo, Ye pini ngê apu, Nê king. Kwo, U yi u ngwo a kwo, Pini n꞉ii nmî king ndîî ngê wunê tóó, Lóma, u d꞉aa nê kââdî. Kwo, Yinté pini king ndîî p꞉uu a d꞉uu yédi. Kwo, Ye pini nye pw꞉iipw꞉ii knomomê, ye king ndîî ngê yi kópu wa a ny꞉oo, doo u nuu u pi ngê anyi pyódu. ");
INSERT INTO yle_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Paléti ngê yi kópu yi nyongo, Yesu kuwa ye a pw꞉ii ngê, pi kwéli dpîmo kóté kîgha dé, y꞉i ńuwo. (Yi kêlî ghê chêêpî u kadakada mwiyé yé tumo, Nju tpémi yi dnye ngê u pi Nkapata.) ");
INSERT INTO yle_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Wéni n꞉ii ngê Tp꞉ee Kaa W꞉êêw꞉êê u Naa u l꞉êê dîy꞉o tpile yilî dnye wiyewiye, yi wéni ngê yi kópu yilî u ngwo pyodo. Kââdî mââ kêlî dini ghi ghêlî daa yó, Paléti ngê Yesu kuwa ye a pw꞉ii ngê, Nju tpémi ye yepê, Ala nmyi king. ");
INSERT INTO yle_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dpodombiy꞉e u kwo mbwó dniye, kwo, Pw꞉oo we. Kwo, Vya ngi. Kwo, Kîdosi ńedê t꞉ee ngi. Paléti ngê yepê, Mumdoo nmyi king kîdosi ńedê wanî t꞉oo? Kpêê yiyé pyu yoo yi kada pini knî y꞉oo kwo, Nmî king mu ngmidi, king ndîî n꞉ii Lóma wunê tóó. ");
INSERT INTO yle_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Wod꞉oo Paléti ngê lede knî ye yepê, Yesu ńuw꞉o yó, kîdosi ńedê nyi t꞉ee yó. Lóma lede knî y꞉oo Yesu ńuw꞉o ngópu, ");
INSERT INTO yle_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Njedusalem a kuwo ngópu, ghi ngmê ńuw꞉o ngópu, yi ghi u pi Mbodo Dînê. (Nju tpémi yi dnye ngê Nkolkota.) Maa p꞉uu Yesu ngê u kîdosi chóó doo dnyinêdnyinê. ");
INSERT INTO yle_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yi mbwini mbêmê Yesu kîdosi ńedê mî t꞉ee ngópu, pi u nkîgh꞉ê mê miyó kîdosi ńedê t꞉ee dumo, u wéni pee ngmê t꞉ee ngópu, u t꞉anê pee ngmê t꞉ee ngópu, Yesu yi kêlî ghê kîdosi ńedê doo ya. ");
INSERT INTO yle_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Paléti ngê u dpodo pyu ngmê ka kwo, Yesu u nt꞉u kópu d꞉êê ngi, apii, Yesu Nasalet pi, Nju tpémi yi king. Yi pini ngê yi kópu dyuu pyolo d꞉êê ngê, Nju dnye ngê d꞉êê ngê, Kîdiki dnye ngê d꞉êê ngê, Lóma dnye ngê mye d꞉êê ngê. Yi kópu dyuu Yesu u pwo kîdosi ńedê t꞉ee ngópu. Nju tpémi yilî knî y꞉oo yi kópu dyuu a kp꞉aa ngópu, mu kópu u dîy꞉o Njedusalem u nkîgh꞉ê Yesu kîdosi ńedê mî t꞉ee ngópu, daa kuughê. ");
INSERT INTO yle_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kpêê yiyé pyu yoo yi kada pini knî y꞉oo Paléti ka kwo, Lukwe dîy꞉o chi d꞉êê, Nju tpémi yi king. Kwo, Alanté wochi d꞉êê, Kî pini ngê apu, Nê Nju tpémi yi king. ");
INSERT INTO yle_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Paléti ngê yepê, Kópuni dî d꞉êê, muchoo ya. Yepê, Daanî ngmêê. ");
INSERT INTO yle_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Dini ghi n꞉ii ngê Yesu kîdosi ńedê t꞉ee ngópu, lede knî y꞉oo u kpîdî yêê tumo, tpile dyuu páádi ngê pyódu ngópu, lede ngmê u tpile dyuu ngmê. U kpîdî ngmê mb꞉aamb꞉aa, kpîdî d꞉umu daadîî, kêlî ghê daa dmy꞉ee ngmê. ");
INSERT INTO yle_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Lede knî y꞉oo noko yepê, nangê chaa, ng꞉oo kmêle, n꞉uu ngê wunê ng꞉êênî. Kópuni nmî Mî u puku yedê a tóó, yi Lóma lede páádi knî y꞉oo daa yi lama yi kópu ntiye ngópu. Yi kópu ala, A tpile dê yêê t꞉oo, A kpîdî mb꞉aa u dîy꞉o mye ng꞉oo té. ");
INSERT INTO yle_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu u kîdosi u nkîgh꞉ê pyââ páádi yi k꞉ii nmee kwo, Niye mbwémi Yesu u pye miyó, Méli Kîlópas u kpâm pyolo, Méli Makîdala pyââ podo. ");
INSERT INTO yle_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu ngê u pye a nkîgh꞉ê módu, kwo, Niye. Kwo, Kî ṉ́m꞉ee. ");
INSERT INTO yle_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A ka pê, Kî m̱ye, u kwo mb꞉aamb꞉aa ngê chi vyuwo. U kuwó dini ghi ngê u kwo noo vyuwo, a ngomo k꞉oo doo kwo. ");
INSERT INTO yle_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu u lama doo ya, A dpodo yilî yintómu daa kêmakêma n꞉aa chedêchedê. U yi u ngwo doo kwo, Kópuni puku yedê a tóó nî ntiye, wod꞉oo yepê, Mbwaa a nga dê chópu. ");
INSERT INTO yle_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wain d꞉ââ y꞉i ngmêdoo kwo. Pi ngmê ngê tpênê n꞉êê ngma a ngêêdî, wain d꞉ââ k꞉oo kmênê ngê, yimbwi ńedê kââ, Yesu komo t꞉âmo mbee ngê. ");
INSERT INTO yle_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu ngê yi wain yi ndââ, yepê, Machedê, wod꞉oo mbodo k꞉ame a ghê wo, pwene. ");
INSERT INTO yle_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Wéni n꞉ii ngê Yesu pwene, yi wéni Pîdaidé, womumo lîme wo ndîî ngmê, ntóó yi wéni ngê kîdosi ńedê daapêdoo ya. Yi kópu u l꞉êê dîy꞉o Nju tpémi yi kada pini knî ngmê Paléti ka lee dniye, kwo, Yélini kîdosi ńedê a pyede, u ntââ yi kpâlî dmi wa pwaa t꞉oo, lîmîlîmî ngê u ngwo paa pw꞉oo dniye, yed꞉oo awêde mîpaa kmênê téne. ");
INSERT INTO yle_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Wod꞉oo lede yoo lee dniye, Yesu u nkîgh꞉ê kîdosi ńedê n꞉ii dê dpîmo ya, yi kpâlî páádi knî pwaa tumo, ");
INSERT INTO yle_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ngmênê Yesu u kîdosi chedê y꞉i nî dniye, yi vyu dniye, apê, Até dê pw꞉onu, wod꞉oo kpâlî dê mêdaa pwaa dumo. ");
INSERT INTO yle_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lede ngmê ngê u kaa a ngêêdî, Yesu podo pee dmi kêpa dóó, u kaa yedê pêêdî ngê, wêê mbwaa kwodonkwodo a mbêpê knopwo. ");
INSERT INTO yle_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yi kópu yilî a chóó a ngwolo dê y꞉oo nî módu, ntênê dî d꞉êê té, mu kópu u dîy꞉o yi kópu knî ye paa kêlîmî mbê dmyeno. ");
INSERT INTO yle_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Lede knî y꞉oo daa yi lama puku yedê kópu miyó ntiye ngópu, ngmê alanté, Dînê daangmêwa pwaa ngmê, woni alanté, Pini n꞉ii wa dmya ngmê, pi knî y꞉oo adnyi y꞉enê. ");
INSERT INTO yle_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pi ngmê, u pi Njósép, Adamátiya pi. Yi pini Yesu ka myedpîmo kêlîmî, ngmênê tumutumu, mu kópu u dîy꞉o kada pini knî ye dpîmo nkîngê. Yesu dini ghi n꞉ii ngê pwene, yed꞉oo yi Njósép Paléti ka loo, kwo, U ntââ Yesu ntóó wan꞉uu kmênê. Paléti ngê kwo, U ntââ, wod꞉oo Yesu u kîdosi chedê nmo a loo, ntóó nmo ngópu. ");
INSERT INTO yle_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pi m꞉uu nmo myeda loo, u pi Nikódimês, pini n꞉ii Yesu ka mgîdî vy꞉o mwiyé a loo. Yi pini ngê, u dpodo pyu knî yi k꞉ii mtyîmî ntee tpile péé knî ngma a ńuw꞉o ngópu, tuu mb꞉aamb꞉aa. Yi tpile péé dmi yi dîngîdîngî ndîî. ");
INSERT INTO yle_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yi mââwe dê y꞉oo yi mtyîmî ntee tpile Yesu ntóó p꞉uu dpîmo t꞉emî, kpîdî ngê ntóó u nkwo dpîmo a kmongokmongo, mu kópu u dîy꞉o nmî Nju tpémi nmî pi ntóó kmênêkmênê yinté a tóó. ");
INSERT INTO yle_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu kîdosi ńedê kwéli pwene u nkîgh꞉ê myângo ngmêdoo ya. Yi myângo vy꞉o kpomo kamî ngmêdoo ya, wunê pi ntóó y꞉i daangmê kmênê ngópu. ");
INSERT INTO yle_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yi lémi dê y꞉oo Yesu ntóó yi kpomo u mênê kmênê ngópu, mu kópu u dîy꞉o mgîdî doo a ghayghay, doo u ntââ kuughê daapî ńuw꞉o ngópu. ");
INSERT INTO yle_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sandé mw꞉aa mgîdî vy꞉o, Méli Makîdala pyââ kpomo chedê yi loo, Yesu kwéli kmênê ngópu. Apê, Chêêpî pââ ndîî n꞉ii kpomo t꞉âmo kaa ngópu, apê, Lukwe ngê atédê tpiyé wupu kwolo. ");
INSERT INTO yle_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wod꞉oo mbêpê a puwâ, Saimon Pita k꞉ii mdoo nye a ńuwo, nyepê, Nmî Lémi ntóó kpomo u mênê kêdê ngî ngmê, kwéli d꞉uu yé ngmê, nmî lama daa tóó. ");
INSERT INTO yle_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pita k꞉ii kpomo u chedê nyi lee knopwo. ");
INSERT INTO yle_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Maa p꞉uu nipi nyipu mbêpê, mbêpê têdê Pita nê kuwo ngê, kpomo u chedê mwiyé n꞉uu ta, ngmênê kpomo u mênê ghêlî dîpî kee wo. ");
INSERT INTO yle_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kpomo u mênê nê tepe mbê wo, Yesu ntóó p꞉uu kpîdîni t꞉ee tumo, nî m꞉uu too. ");
INSERT INTO yle_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pita dini ghi n꞉ii ngê ta, yi ngwo kpomo u mênê kee wo, kpîdî mye m꞉uu too. ");
INSERT INTO yle_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kpîdîni ngê mbodo a kmongo ngópu, apê, U mo mu tóó, kmongo ngmê. ");
INSERT INTO yle_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Myenté kpomo u mênê my꞉aa kee wo, yi kópu knî y꞉aa m꞉uu too, ala kópu ka u ngwo nî kêlîmî mbê wo, nê, Nmî Lémi kêda pyidu. ");
INSERT INTO yle_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yesu u pyidepyide p꞉uu kópuni puku yedê a pyede, yi ngwo ghêlî dpîp꞉o w꞉ee too. ");
INSERT INTO yle_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","U kuwó dini ghi ngê p꞉o m꞉ee diyé knopwo. ");
INSERT INTO yle_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Méli kpomo chedê doo kwo, doo mbê. Kpomo u mênê yedê tepe mbê wo, ");
INSERT INTO yle_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","enjel miyó módu, yi kpîdî dê kpaapîkpaapî dê. Yesu ntóó mwiyé kwéli doo ya, yi kêlî ghê dpîmo ya, mbodo kwéli yé ngópu, woni y꞉i doo ya, woni yu dmyîno doo ya. ");
INSERT INTO yle_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ngmê ngê Méli ka kwo, Lukwe dîy꞉o nye mbê. Yepê, Nmî Lémi ntóó até da ngî ngmê, anyi d꞉uu yé ngmê. ");
INSERT INTO yle_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wod꞉oo Méli yi diyé wo, Yesu yi módu, ngmênê daa myââ. ");
INSERT INTO yle_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu ngê kwo, Lukwe dîy꞉o nye mbê. Kwo, N꞉uu ka nye vyuwo? Méli ngê apê ngmênê, Myângo u y꞉enê pyu ye kwo, kwo, Ala pini ntóó dmyinê ngî ngmê, kwéli dmyin꞉a a yé ngmê a ka vyi ngi, n꞉aa lêpî, ntóó mênîn꞉aa ng꞉êênî. ");
INSERT INTO yle_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu ngê kwo, Méli. Yi ngwo dini ghi ngê Méli ngê myââ, apê, Kîngê Yesu. Nju dnye ngê kwo, Laponi, u nt꞉u kópu nmînê nmo, Nmî Lémi. Wod꞉oo Yesu u nkîgh꞉ê loo. ");
INSERT INTO yle_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu ngê kwo, Kalê nédi, mu kópu u dîy꞉o M꞉aa ka d꞉oongê kee wo. Kwo, A mî mye nmyi Mî, a yâpwo mye nmyi yâpwo. Kwo, Yi pini ka n꞉aa koko. Kwo, A mbwó knî ye yi kópu dp꞉uu vyi ngi. ");
INSERT INTO yle_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Wod꞉oo Méli Makîdala pyââ nmo a loo, nmopê, Nmî Lémi kîdî m꞉uu. Méli ka kópuni a vyi too, nmo mînê nté too. ");
INSERT INTO yle_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yi Sandé ntumokwodo n꞉ii knî yi k꞉ii Yesu p꞉uu nmee ndiye, ngomo k꞉oo nmee kwo. Keńe nmo kuwo too, mu kópu u dîy꞉o Nju tpémi yi kada pini knî ye nmî nkîngê mbê dniye. Wod꞉oo Yesu anya a pwiyé wo, nmî vy꞉o ghê wo, nmopê, Mw꞉ââkó a tîdê mbwó yoo, ala nê, namê nkîngê. ");
INSERT INTO yle_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","U kuwó dini ghi ngê kóó dê nmî ngópu tpyé doo, kaa kwéli dóó ngópu, nmî ngópu mye tpyó. Dini ghi n꞉ii ngê nmî myââ, nmî gha dmi d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Myombó Yesu ngê nmopê, Namê nkîngê. Nmopê, M꞉aa ngê dyámê mbêmê ntee a dy꞉ââ noo, pi knî ye yinté u nkwo n꞉aa dyede nmyo. ");
INSERT INTO yle_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wod꞉oo Yesu nmo kó wââ mbê wo, nmopê, M꞉aa u Ghê Dmi nmyi mênê dî yé. ");
INSERT INTO yle_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nmopê, N꞉ii yi dono wanmyi chedê t꞉oo, M꞉aa ngê yi dono u mbodo kn꞉ââ vyuwo wa kéé té, mêdaawa a ngî té. Nmopê, N꞉ii p꞉uu M꞉aa u Ghê Dmi mbêmê ala kópu wanmyinê w꞉ee ngmê, anye, Kî pini ngê u dono dê mgîmî té, mêdaawa kéé té, nmopê, yi pini ka wanmyi vyi ngmê, Ṉono knî y꞉oo dê dyênê ngi, ye yi pini u dono M꞉aa ngê u mbodo kn꞉ââ vyuwo daawa kéé té. ");
INSERT INTO yle_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Wéni n꞉ii ngê Yesu nmî módu, nmî vy꞉o pini ngmê Tomas, pini n꞉ii u mbwó k꞉ii nipi taa knopwo, yi pini nmî vy꞉o dêpwo kwo, ");
INSERT INTO yle_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","wod꞉oo dini ghi n꞉ii ngê Tomas nmî módu, kwonmo, Nmî Lémi kudu m꞉uu. Tomas ngê nmopê, Kpêêpî u kwéli kóó dê yi p꞉uu daanî m꞉uu knomomê, a kêêpyââ yi kwéli p꞉uu daanî yé knomomê, kaa kwéli dóó ngópu a kêê y꞉i daanî yé knomomê, ye daanî kêlîmî mb꞉anê. ");
INSERT INTO yle_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wiki ngmidi mî loo, Tomas u k꞉ii ngomo k꞉oo nipi nmee kwo. K꞉omo tpile keńe nmo kuwo too, ngmênê Yesu anya a pwiyé wo, nmî vy꞉o ghê wo, Nmopê, Mw꞉ââkó a tîdê mbwó yoo. ");
INSERT INTO yle_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomas ka kwo, A kêê dê ngî m꞉uu dé, ṉgêêpyââ yi p꞉uu kédi, a podo pee dmi kêpa ṉgêê mye yé. Kwo, Lukwe dîy꞉o d꞉ii kêlîmî. Kwo, Chi kêlîmî. ");
INSERT INTO yle_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas ngê kwo, A Lémi, nyi nmî yâpwo ndêndê. ");
INSERT INTO yle_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu ngê kwo, Wochoo m꞉uu noo, daapîchi kêlîmî mb꞉anê. Kwo, Yélini a ka adnya a kêlîmî, k꞉omo tpile daawa m꞉uu nê, a ka amyednya a kêlîmî, yi yéli yi gha dmi M꞉aa ngê d꞉ud꞉umbiy꞉e mb꞉aamb꞉aa ngê wa pyódu té. ");
INSERT INTO yle_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","K꞉omo tpile Yesu ngê mbwudu yilî nmî ngópu chópu, ngmênê ala puku yedê pyile njini nî d꞉êê ngê. ");
INSERT INTO yle_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nî d꞉êê too, mu kópu u dîy꞉o ala kópu ka paa kêlîmî mbê dmyeno, pini n꞉ii Chóó Lémi ngê a ngmidi ngê, nmî kada pini ngê pyódu ngê, yi pini Yesu, pini n꞉ii Chóó Lémi Tp꞉oo. U ya a nga a kwo Yesu ka kêlîmî mbê dmyeno, u pi mbêmê ghê kamî u ngwo pêdê pyw꞉ee yó. ");
INSERT INTO yle_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","U kuwó dini ghi ngê Yesu ngê chóóchóó nmî ngópu mê tpyó. Dini ghi n꞉ii ngê Nkálili Kpéni Lêê u nkîgh꞉ê nmee ya, yi kópu nmo u ngwo pyodo. ");
INSERT INTO yle_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nmî pyudu nmee ya Saimon Pita ngmê, Tomas myomo, pini n꞉ii u mbwó k꞉ii nipi taa knopwo, Nêtániyel pyolo, Kéna pi, Nkálili Wee u kwo p꞉aani n꞉ii a tóó, a mbwó k꞉ii nye podo limo, Yesu p꞉uu ndiye pyu mê miyó yi k꞉ii. ");
INSERT INTO yle_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita ngê nmopê, Vyuwó têdê n꞉aa lêpî. Kwonmo, Nmî k꞉ii lee kmêle. Wod꞉oo dinki k꞉oo nm꞉uu wo dniye, munmeen꞉aa vyuwó. Yi mgîdî nmo dyé ngê, pwoo k꞉oo te dêpê gho. ");
INSERT INTO yle_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mw꞉aamw꞉aa dini ghi ngê Yesu tii vyuwo nmî módu, ngmênê pi daa myââ. ");
INSERT INTO yle_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nmopê, Kî tpóknî. Nmopê, Pwoo k꞉oo te doo gho? Kwonmo, Nyââ, te doo gho. ");
INSERT INTO yle_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nmopê, Nmyi pwoo dinki mwada pee kéé yó, y꞉i knî ngmê wunê wupwo. Wod꞉oo pwoo dinki mwada pee nmî kéé ngê, te yilî a gho, doo u ntââ pwoo dinki k꞉oo daap꞉ono pêêdî ngê. ");
INSERT INTO yle_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pita ka kwonoo, Kî nmî Lémi vyîlo ye kwo. Saimon Pita ngê yi nyongo, apê, Nmî Lémi ye kwo, wod꞉oo u paa kpîdî u paa ngmê t꞉ângo, tpuu a ndê ngê, kpé lêê u kwo mbêka wo, Yesu ka chââchââ mî kee wo. ");
INSERT INTO yle_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dinki k꞉oo a kuwo nmoo, nmînê pwoo nmee a paapaa. Yesu kwéli doo a kwo daa kuughê, pwoo y꞉i nm꞉uu têêdî ngê. ");
INSERT INTO yle_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Dini ghi n꞉ii ngê lyoko nmî tee dniye, nê, Yesu ngê ndyuw꞉e ngmê atédê kpê, te ngmê nk꞉êênî, mbîdédi knî my꞉oo kwo. ");
INSERT INTO yle_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu ngê nmopê, Te n꞉ii da ghêpê dmi, knî ngma a ńuw꞉o yó. ");
INSERT INTO yle_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Pita dinki kn꞉ââ ghê nmo a loo, pwoo nipi lyoko nmo pêêdî ngê. K꞉omo tpile te ndîî yono y꞉a limo y꞉a mê pyile y꞉i a ghê, ngmênê pwoo daa chaa ngópu. ");
INSERT INTO yle_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu ngê nmopê, A pwiyé dmyeno, nté anyi ma yó. U kwo nmî nkîngê mbê dniye, u kwo mêdaap꞉oo póó dniye, Nyi n꞉uu, mu kópu u dîy꞉o nmî lama doo ya, Kî nmî Lémi. ");
INSERT INTO yle_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Wod꞉oo Yesu ngê mbîdédi a ngêêdî, nmo a kpo, te nmo myedê kpo. ");
INSERT INTO yle_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu ngê yinté chóóchóó pyolombó nmo a kêma ngê, kpêênî mwâ a pii wo. ");
INSERT INTO yle_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kmaapî yinmo kêlî ngê, Yesu ngê Saimon Pita ka kwo, Njon tp꞉oo. Kwo, Mumdoo kî yéli yi nódo a nuu ghi dnyinté a tóó, ngmênê nyi mu ngmidi a nuu ghi ndêndê ngê ṉódo a tóó? Pita ngê kwo, Nyââ, a Lémi. Kwo, Ḻama ka tóó nê, ṉuu ghi a nódo ka tóó. Yesu ngê kwo, A sipi w꞉uu chi mbonombono. ");
INSERT INTO yle_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Myombó Yesu ngê Saimon ka kwo, Njon tp꞉oo. Kwo, A nuu ghi ṉódo a tóó? Pita ngê kwo, Nyââ, a Lémi. Kwo, Ḻama ka tóó, ṉuu ghi a nódo ka tóó. Yesu ngê kwo, A sipi w꞉uu chi y꞉enê. ");
INSERT INTO yle_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Pyolombó Yesu ngê Saimon ka kwo, Njon tp꞉oo. Kwo, Mumdoo a nuu ghi ṉódo a tóó? Pita u nuw꞉o dono ngê pyodo, mu kópu u dîy꞉o Yesu u kwo pyolo póó wo, kwo, A nuu ghi ṉódo a tóó. Yesu ka kwo, A Lémi, kópu yilî yintómu ḻama ka pyede. Kwo, Ḻama ka tóó, ṉuu ghi a nódo ka tóó. Yesu ngê kwo, A sipi w꞉uu chi mbonombono, mb꞉aamb꞉aa ngê cha a chedêchedê y꞉amîy꞉amî dé. ");
INSERT INTO yle_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kwo, Ndê kópu ṉga ngmên꞉aa tpapê. Kwo, Dini ghi n꞉ii ngê pi mgêmî ngê nyoo a ya, m̱alêti m̱aa nyimo t꞉emî, ṉuw꞉o ngê ghini u pi dpîmo tpapê, y꞉i nyimo lêpî. Kwo, Dini ghi n꞉ii ngê vy꞉enevy꞉ene kêpa anyin꞉aa kwo, pi ngmê ngê yedê ńedê amî t꞉ee ngi, ghini u yi ṉga daadî kwo, y꞉i wa ńuw꞉o ngi, ṉgêê dê y꞉i wa chámê dê, u ngwo wa km꞉êê ngi. ");
INSERT INTO yle_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kwo, Cha a nj꞉ii nê. Yesu ngê Pita u pwopwo u maa yinté nmo a kêma ngê, u ngwo nmo w꞉ee ngê, nê, Pita ngê Chóó Lémi u pi yi pwopwo têdê wa knî. ");
INSERT INTO yle_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","21","Pita u kuwó yi diyé wo, yi m꞉uu noo, apê, Pini n꞉ii Yesu u nuu u pi ngê a tóó, mu kwo. Apê, Kmaapî têdê Yesu ka vyîlo yi póó wo, kwo, N꞉uu ṉgwódo ngê angmê ghê. Wod꞉oo Pita Yesu ka póó wo, kwo, A Lémi, Kî pini ngê lukwe ngmêwa pyódu? ");
INSERT INTO yle_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu ngê kwo, K꞉omo ngê u ya a nga wo kwo, Kî pini choo ya, u dî anê diyé, ye lukwe dîy꞉o yi kópu p꞉uu nye nuw꞉o. Kwo, Cha a nj꞉ii nê. ");
INSERT INTO yle_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kópuni Yesu ngê Pita ka vyu, yi kópu u l꞉êê dîy꞉o Yesu u yoo knî y꞉oo ala kópu a tpapê ngmê, apu, Nê daawa pw꞉onu. Ngmênê Yesu ngê daa vyu, Nê daawa pw꞉onu. Ala kópu yi vyu, K꞉omo ngê u ya a nga wo kwo, Nê choo ya, u dî anê diyé, ye lukwe dîy꞉o yi kópu p꞉uu nye nuw꞉o. ");
INSERT INTO yle_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yi kópu yilî a ngópu pyodo, a ngwolo dê y꞉oo m꞉uu tumo, u ngwo dî d꞉êê té. K꞉omodanê kópu d꞉oongmê d꞉êê ngê. ");
INSERT INTO yle_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu ngê kópu mê yilî d꞉uu ngê. Yi kópu yilî yintómu w꞉oo d꞉êê too, pi knî ye doo u ntââ ngê paa pyódu, daapêdê kp꞉aa t꞉oo. Wu u dî. ");
INSERT INTO yle_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mw꞉ââkó Tiyopilas. Ala kópu yilî a mwiyémwiyé puku yedê nî d꞉êê ngê, Yesu ngê kópuni yilî d꞉uu ngê, myenté pi knî yi nuwo kópuni yilî kwólu, u dî, wéni n꞉ii ngê u Mî ka mî kee wo. ");
INSERT INTO yle_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Yesu dini ghi n꞉ii ngê pwene, mêda pii wo, Chóó Lémi u Ghê Dmi ngê ngópu, u dyépi knî ye u kópu yilî a kuwo ngê, yélini mwiyé a ngmidi ngê. ");
INSERT INTO yle_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yi dpodo p꞉uu wo podo y꞉a chedê ngê, daa ng꞉êêntómu chóóchóó ye dpîmo a kêmakêma, wod꞉oo yi lama mb꞉aamb꞉aa ngê yaa wo, apê, Kî pini ndêndê ngê mêdê pii wo. Yi dini ghi ngê Yesu ngê daa ng꞉êêntómu chóóchóó ye a kêma ngê, Chóó Lémi kóó k꞉oo wowo p꞉uu ye dpîmo danêmbum. ");
INSERT INTO yle_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dini ghi n꞉ii ngê Yesu p꞉uu ndiye pyu knî yi k꞉ii nipi dnye ya, Yesu ngê yepê, Njedusalem kêdmyenêngê kuwo ngmê. Yepê, M꞉aa u yeedeyeede mwiyé dmyinê t꞉âât꞉ââ, kópuni p꞉uu nmye noo a danêmbum. Yepê, Yinê wa wêdêwêdê kalê nmyo. ");
INSERT INTO yle_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yepê, Njon ngê mbwaa paa yoo dpîmo a kmênêkmênê dé, ngmênê mââ m꞉ii M꞉aa ngê chóó u Ghê Dmi u mênê wa kmênê nmyo. ");
INSERT INTO yle_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Dini ghi n꞉ii ngê Yesu u dyépi knî yi k꞉ii nipi a wó, u kwo póó dniye, kwo, Nmî Lémi. Kwo, W꞉êê tpémi y꞉oo ala kópu m꞉uu ka a vyi ngópu, apê, Dini ghi n꞉ii ngê Chóó Lémi ngê mb꞉aamb꞉aa ngê wa a ngee nmo, nmo Yisîléli tpémi nmî mbodo dmi mudu y꞉i wa yââ, kn꞉aa yéli yi kada pini ngê am꞉oo pyaa dmi. Kwo, Yi kópu ala ngwo a pyodopyodo? ");
INSERT INTO yle_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu ngê yepê, Kópuni wa pyódu, M꞉aa ngê yi dini ghi u kópu chóó wa vyi. Yepê, Yi dini ghi nmyi lama daawa yââ. ");
INSERT INTO yle_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yepê, M꞉aa u Ghê Dmi dini ghi n꞉ii ngê nmyi pwo wa a ghîî, yepê, d꞉ud꞉umbiy꞉e wa wêdêwêdê kalê nmyo, pi knî ye a p꞉uu u nkwo anmyin꞉aa danê, Njedusalem tpémi ye, Njuda tpémi ye, Samédiya tpémi ye, myenté dyámê ghi yintómu knî yi mbêmê. ");
INSERT INTO yle_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","U danêmbum dini ghi n꞉ii ngê a kêlî ngê, wod꞉oo Chóó Lémi ngê mbóó p꞉uu yi ngópu kmungo, apê, Nkalî too pee vy꞉o ad꞉uu t꞉iy꞉e. ");
INSERT INTO yle_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Dini ghi n꞉ii ngê mbóó p꞉uu kee wo, p꞉uu ndiye pyu knî y꞉oo yi ngwolo dmi dêpê y꞉ee ngópu, mbóó p꞉uu mudnye vyuwo, wod꞉oo pi yi nkîgh꞉ê miyó adî m꞉uu ngmê, yi kpîdî dê kpaapîkpaapî dê. ");
INSERT INTO yle_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Yi tpódu y꞉oo yepê, Nkálili tpémi. Yepê, Lukwe dîy꞉o al꞉ii nmye kwo té? Yepê, Lukwe anmye y꞉enê ngmê, mbóó p꞉uu? Yepê, Ye pini Yesu, pini n꞉ii nmyi ngópu dê kee, u Mî ka, yepê, mbóó p꞉uu u Mî ka ntee dê kee, dîyo dyámê mbêmê yinté amêdê diyé. ");
INSERT INTO yle_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","U kuwó dini ghi ngê Yesu u dyépi knî y꞉oo mbu mbodo Olipi a kuwo ngópu, Njedusalem mê diyé dniye, daa ndîî máádi ghi tp꞉oo yi kalê ngópu. (1 km.) ");
INSERT INTO yle_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Dini ghi n꞉ii ngê Njedusalem taa dniye, yi ngomo ghi u mênê mî kee dniye, kwéli dnya a ya. Yi pi dmi Pita ngmê, Njon myomo, Njems pyolo, Andru podo, Pilipi limo, Tomas wono, Mbatolomyu pii, Mátiyu wolo, Njems Alîpayas tp꞉oo tówo, Saimon yono, n꞉ii ngê u yi doo kwo, Lóma tpémi nmî ngm꞉ii kalê té, Njudas Njems tp꞉oo mê ngmê. ");
INSERT INTO yle_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dye ghi yintómu nipi dnyimo ngêpê, pyââ knî yi k꞉ii, myenté Méli Yesu u pye ghee knî mye yi k꞉ii. ");
INSERT INTO yle_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Wo ngmê ngê pi yonoy꞉a mê myoy꞉a nipi dnye ya, yélini Yesu ka dnye kêlîmî. Wod꞉oo Pita yi vy꞉o ghêêdî wo, yepê, A tîdê mbwó yoo. Yepê, Chóó Lémi u Ghê Dmi ngê Dépidi ka Njudas p꞉uu kópuni a vyu, yi kópu Dépidi ngê puku yedê u nkwo a d꞉êê ngê, yepê, doo u ntââ Njudas ngê yi kópu daapî kn꞉aadi ngê, ndêndê ngê ntiye ngê. Yepê, Yi Njudas Yesu u kwódo ngê vyîlo yi ghê wo, dini ghi n꞉ii ngê Yesu mî mgîmî ngópu. ");
INSERT INTO yle_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yepê, Njudas nmî vy꞉o pini ngmê, mu kópu u dîy꞉o Yesu ngê a ngmidi ngê, u k꞉ii nipi nmîmo dpodo. ");
INSERT INTO yle_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Dini ghi n꞉ii ngê Njudas Yesu u kwódo ngê ghê wo, Nju tpémi yi mââwe ndîî knî y꞉oo u kwo yi ngópu, yi ye ndapî ngê Njudas ngê têpê ghi ngmê pwila ngê. Njudas ngê tpéé kópu vyu, apê, Ayii! Yesu u kwódo ngê m꞉aa ghê wo. Wod꞉oo chóóchóó mbwámê a nâkâ ngê, têpê mbêmê dyimê wo, daa pyiyé wo. Ntóó mbwó wo, km꞉oo pwaa wo, ńuknî a pwii wo. ");
INSERT INTO yle_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Njedusalem tpémi y꞉oo yi kópu dini ghi n꞉ii ngê ny꞉ee ngópu, yi têpê ghi u pi ntaa ngópu, apê, Wêê u têpê ghi, yi chóó yi dnye ngê, Akeldama.) ");
INSERT INTO yle_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita ngê yepê, Dépidi ngê wéti puku yedê ala kópu a d꞉êê ngê, apê, U ngomo podo ngê paa pyaa we, pi y꞉i daapîchoo ya. Yepê, ala kópu myedê d꞉êê ngê, apê, Kn꞉aa pini ngmê ngê dpodo têdê u d꞉aa pêdê kââdî ngê, ");
INSERT INTO yle_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Pita ngê yepê, Pi ngmê ngê Njudas u d꞉aa modo kââdî ngê, pini n꞉ii u lama a tóó, Ndêndê ngê Yesu a pii wo. Yepê, Yi pini ngê pi knî ye choon꞉aa tpapê, Yesu ndêndê ngê a pii wo. Yepê, Alanté pini u ntââ, pini n꞉ii dye ghi yintómu nmî vy꞉o doo kwo, kn꞉ââ Njon ngê Yesu mbwaa paa mwo a kmênê ngê, u dî Yesu u Mî ka mî kee wo. ");
INSERT INTO yle_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","U kuwó dini ghi ngê pi miyó a pyw꞉ee ngópu, Mêtayas pini dê Njósép Sapasî tp꞉oo, u pi mo a tóó, Njastas. ");
INSERT INTO yle_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dini ghi n꞉ii ngê a pyw꞉ee dumo, Yesu ka dnye ngêpê, kwo, Mw꞉ââkó nmî Lémi, doo u ntââ ala pini dê daanmî chámê dê, ngmênê nyi u ntââ, mu kópu u dîy꞉o pi yintómu yi gha dmi ḻama dé. Kwo, Pini n꞉ii nyinê ngmidi ngê, kwo, nmî nuw꞉o ńedê yimi a téni. ");
INSERT INTO yle_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Kwo, Yi pini ṉyépi ngê wa pyódu, nipi u k꞉ii anmî dpodo, Njudas u d꞉aa yinê wa a kââdî, mu kópu u dîy꞉o Njudas ngê ka a kuwo nmoo, chóó angênté kî pyodo. ");
INSERT INTO yle_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","U kuwó dini ghi ngê Pita yi ngópu doo ng꞉oo, Mêtayas u ngwo a pyw꞉ângo, wod꞉oo yi pini ngê Njudas u d꞉aa yinê a kââdî ngê, dyépi y꞉a mê ngmê knî yi vy꞉o mî ghê wo. ");
INSERT INTO yle_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dini ghi n꞉ii ngê Yesu pwene, wo limoy꞉a mî loo, Nju tpémi yi naa ngma a pwaa wo, u pi Péntikos. ");
INSERT INTO yle_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","N꞉ii dé Yesu ka dnyimo kêlîmî, yi nááli têdê nipi a da wo, wod꞉oo mbóó p꞉uu yópu ndîî u dnye ngmê ny꞉ee ngópu. Ngomoni k꞉oo dnye kwo, pi yintómu knî y꞉oo mye ny꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Wod꞉oo ndê dóó yilî m꞉uu ngópu, chaa wo, yi ndéni dóó yi mbêmê ntémwintémwi ghê wo. ");
INSERT INTO yle_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Chóó Lémi u Ghê Dmi ngê yi yéli yintómu yi gha dmi a nt꞉ee too, u ntââ ngê pyódu too, wod꞉oo daa dnye ngmidi ngê dnye mbumu. Yélini Njedusalem doo kwo, yi kópu dini ghi n꞉ii ngê ny꞉ee ngópu, wod꞉oo yoo nipi a wó. ");
INSERT INTO yle_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yi dini ghi ngê Nju tpémi daa dyámê pee ngmidi mbêmê dnya a ya. Epîlaham yi kn꞉ââ mu ngmidi, Chóó Lémi yi yâpwo mu ngmidi, ngmênê yi dnye u mo u mo dé. Dye ghi knî ngmê ngê Njedusalem naa têdê dnyimo lêpî. ");
INSERT INTO yle_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","8","Yi yéli y꞉oo Yesu u yoo yi dnye dmi dini ghi n꞉ii ngê ny꞉ee ngópu, apê, Kî lónté kópu? Apê, K꞉omo tpile kî yéli yintómu Nkálili tpémi, yi dnye mu ngmidi, ngmênê nmî dnye ngê nmî dnye ngê ka mbumu té. Apê, Lukwe y꞉e ngmêdê pyódu? ");
INSERT INTO yle_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Apê, Nmo knî ngmê Pátiya tpémi, Midiya tpémi, Elam tpémi, Mbápilon tpémi, Njuda tpémi, Kapadosiya tpémi, Pontós tpémi, Esiya tpémi, Pîdichiya tpémi, Pamîpiliya tpémi, Yichip tpémi. Apê, Nmo knî ngmê Sadéni tpémi, Lipiya wee u kwo nmo ndê dniye. ");
INSERT INTO yle_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Apê, Nmo knî ngmê Lóma tpémi, woni knî yi kn꞉ââ Epîlaham, woni knî yi chóó Nju pi ngê pyaa dniye. Apê, Nmo knî ngmê Kîditi tpémi, nmo knî ngmê Alépiya tpémi. Apê, K꞉omo tpile nmî dnye daa ngmidi, ngmênê kî yéli y꞉oo nmî dnye ngê nmî dnye ngê ka mbumu té, Chóó Lémi ngê ndîî kópuni d꞉uu too, nmo ka tpapê t꞉oo. ");
INSERT INTO yle_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kópuni pyodo d꞉ud꞉umbiy꞉e dêpê w꞉ee ngópu, noko yepê, Kî lónté kópu? ");
INSERT INTO yle_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pi yilî knî y꞉oo yi kópu vyi ngópu, ngmênê woni knî y꞉oo noko yepê, Kêdê ghéti dmi, mbwaa dê nda ngmê. ");
INSERT INTO yle_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","U kuwó dini ghi ngê Yesu u dyépi y꞉a mê miyó yintómu ghêêdî dniye, Pita pi knî ye dpodombiy꞉e mbwolo, yepê, Nju tpémi. Yepê, Yélini Njedusalem dmyinê dââ, yepê, a ka nga a ng꞉aa mbê dmyeno. Yepê, Kópuni dê pyódu, u kakêmê nmye n꞉aa chámêchámê. ");
INSERT INTO yle_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yepê, Ala kópu dmye vyi ngmê, Kî tpóknî y꞉oo mbwaa dê nda ngmê. Yepê, Kêle, ngmênê mbwaa dp꞉oo ndâ, mu kópu u dîy꞉o doo u dye ghi, kââdî ngê daa ndîî mbóó ghi yedê kuwo. ");
INSERT INTO yle_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yepê, Kî tpóknî yi k꞉ii daa mbwaa yidpî nda, ngmênê kópu kamî nmo ngmêyi t꞉aa, Njowel wunê kópuni p꞉uu doo a danê, Chóó Lémi u komo u ngwo mwo a kââ. Yepê, Njowel ngê Chóó Lémi u kópu wunê alanté mwo a d꞉êê ngê, apê, ");
INSERT INTO yle_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dini ghi n꞉ii ngê tpile yilî yintómu machedê ngê wadî pyodopyodo, a Ghê Dmi mwiyé wanê dy꞉ââ, pi yilî yintómu yi mênê wa kee. Nmyi tp꞉ee dmââdîma y꞉oo a komo pi knî ye adnyin꞉aa kapî, mââwe knî ye yi wóó k꞉oo a kópu dyuu ana a tpapê dé. ");
INSERT INTO yle_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yi dini ghi ngê daa kada pini knî ye yi mo a Ghê Dmi wanê dy꞉ââ, ngmênê a yoo yintómu knî ye a Ghê Dmi amyenê dy꞉ââ, yélini a ka adnya a ng꞉aa. Yi yéli y꞉oo a komo y꞉oo adnyin꞉aa kapî. ");
INSERT INTO yle_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Mbóó p꞉uu kópu ndîî yilî anîn꞉aa d꞉uud꞉uu, dyámê mbêmê yinté amyenîn꞉aa d꞉uud꞉uu dé. Yi ngwo dini ghi ngê wêê wa pwii, ndê wa t꞉aa, dpudu ndîî ngê wa pyódu, kââdî mgêê nkaa vy꞉o wa ch꞉iy꞉e, d꞉ââ wêê kuu ngê wa pyódu, u kuwó dini ghi ngê pi yilî wanî kpada. ");
INSERT INTO yle_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yi dini ghi ngê pini n꞉ii ngê a ka wa vyi, Ngee nédi, yi pini wanî ngee. ");
INSERT INTO yle_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita ngê yepê, Yisîléli tpémi. Yepê, A kópu dyuu dpî ny꞉ee yó. Yepê, Chóó Lémi ngê u yi doo kwo, Pi knî yi lama paa yaa we, awo, Chóó Lémi ngê Yesu yinê a dy꞉ââ ngê. Yepê, Yi kópu u l꞉êê dîy꞉o Chóó Lémi ngê Yesu yinê a wêdêwêdê kwólu, mbwudu yilî u ngwo doo chap. Yepê, Yi kópu nmyi lama ka tóó, mu kópu u dîy꞉o Yesu ngê yi kópu yilî nmyi ngópu doo d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yepê, Chóó Lémi ngê u dy꞉oo wunê a châpwo, apê, Dîyo Yesu amî mgîmî ngmê, amî vya ngmê. Yepê, Yi kópu nmyi ntiye ngópu, Yesu nmyi mgîmî ngópu, Lóma tpémi ye nmyi y꞉ee ngópu, vya ngópu, kîdosi ńedê t꞉ee ngópu. ");
INSERT INTO yle_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yepê, Yesu nmyi vya ngópu, ngmênê Chóó Lémi ngê mêdê pyidu ngê. Yepê, Yi dono vy꞉o mêdê y꞉ângo, mu kópu u dîy꞉o doo u ntââ pwopwo ngê daapêdoo tpyé. ");
INSERT INTO yle_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yepê, King Dépidi ngê Yesu u kópu dyuu wunê alanté a d꞉êê ngê, apê, A lama a tóó, A lémi ngê daawa kuwo nê, yinê a ngêêpî nê, dono daangmanê pyw꞉oo. ");
INSERT INTO yle_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yi kópu u l꞉êê dîy꞉o a gha mb꞉aamb꞉aa ngê a tóó, Chóó Lémi n꞉aa chaa kîgha ngê. A Lémi, k꞉omo tpile wanî pw꞉onu, wanyinê ngee nê. ");
INSERT INTO yle_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yélini pw꞉oo dniye, yi yéli yi vy꞉o daanyinê kuwo nê, wanyinê ngî nê, têpê ngê daawa ma nê, mu kópu u dîy꞉o nyi mu ngmidi a kada nye tóó. ");
INSERT INTO yle_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A ghê a ka amênyinê diyédiyé kwolo. Dini ghi n꞉ii ngê am꞉aa m꞉uu ngi, a gha mb꞉aamb꞉aa ngê am꞉ii pyódu. ");
INSERT INTO yle_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita ngê Nju tpémi ye yepê, A tîdê mbwó yoo. Yepê, Nmî mââwe ndîî Dépidi u kakêmê nmye n꞉aa chámêchámê. Yepê, Wunê ló dini mwo a pwene, kî kmênê ngópu, awêde kpê ala p꞉aani ka tóó. ");
INSERT INTO yle_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yepê, Chóó Lémi u komo yinê dpîmo a kapî, kópuni Chóó Lémi ngê u kwo a vyu, yi kópu u lama mb꞉aamb꞉aa ngê doo ya, kwo, Ṉ́ii ńedê pi ngmanê ngmidi, yi pini ṉyoo yi king ngê wa pyódu. Kwo, Ntee nye tóó, yintoo king ngê wa pyódu. ");
INSERT INTO yle_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Yepê, Dépidi u lama doo ya, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, dini ghi n꞉ii ngê wa pw꞉onu, têpê ngê daawa ma, amêdê pyidu. Yepê, U l꞉êê dîy꞉o Dépidi ngê yi kópu u ngwo d꞉êê ngê. ");
INSERT INTO yle_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yepê, Dépidi pini n꞉ii p꞉uu doo a danêmbum, yi pini ndêndê ngê Yesu. Yepê, Dini ghi n꞉ii ngê pwene, Chóó Lémi ngê mêdê pyidu ngê, nmo yintómu nmî ngwolo knî y꞉oo kînmî módu, Yesu mêka a pii wo. ");
INSERT INTO yle_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yepê, Chóó Lémi ka mê kee wo, u nkîgh꞉ê mîmî yaa wo, u che p꞉ââ pee ngê mîmî pyodo. Yepê, Nmî Mî ngê kópuni wunê a vyu, yi kópu u ngwo dê d꞉uu, Yesu ka chóó u Ghê Dmi dê y꞉oo, nmo yinê myedê dy꞉ââ. ");
INSERT INTO yle_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yepê, Yesu mbóó p꞉uu ntee kee wo, Dépidi yinté mêdaa kee wo, ngmênê Dépidi ngê chóó u kópu dyuu alanté wunê a d꞉êê ngê, apê, Chóó Lémi ngê a kada pini ka kwo, M̱i ndîî ngê n꞉aa pyépi a che p꞉ââ pee ngê chi ya, pi yintómu chi y꞉enê dé. ");
INSERT INTO yle_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Yélini m̱꞉uu a l꞉êê té, dîyo anî vya té, ṉyi yodo u maknopwo wanî yé té. ");
INSERT INTO yle_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pita ngê yepê, Yisîléli tpémi. Yepê, Ala kópu ka dmyinê kêlîmî, Yesu pini n꞉ii kîdosi ńedê nmyi t꞉ee ngópu, yi pini Chóó Lémi ngê a ngmidi ngê, nmî kada kââ. ");
INSERT INTO yle_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pi knî y꞉oo yi kópu dini ghi n꞉ii ngê ny꞉ee ngópu, tpéé kópu mî vyi ngópu, yi gha dmi d꞉ud꞉umbiy꞉e dono ngê pyodo, Pita u pyipe knî yi k꞉ii nipi ye póó dniye, yepê, Nmî mbwó yoo, ló kópu ngmanmî d꞉uu? Yepê, Chóó Lémi ngê ntââ nmo awêde wunê vyîmî. ");
INSERT INTO yle_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita ngê yepê, Nmyo ngmêngmênté nmyi dono a kuwo tóó, Yesu u pi ngê mbwaa paa nmo kmênêkmênê nmyo, yed꞉oo nmyi dono mêdaadî ya, Chóó Lémi ngê u kuwó wa kéé té, mêdaawa a ngî té. Yepê, Yi dini ghi ngê Chóó Lémi ngê u módó yeedeyeede nmye wa a kê, chóó u Ghê Dmi nmyi mênê wa kee. ");
INSERT INTO yle_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yepê, Chóó Lémi ngê chóó u Ghê Dmi nmye wa a dy꞉ââ, nmyi tp꞉ee dmââdîma yi k꞉ii, yélini kuughê wunê kwo mye yi k꞉ii. Yepê, Chóó Lémi ngê yélini wa a ngmidi, yi yéli u yoo vy꞉o wa kââ, chóó u Ghê Dmi ye wa a dy꞉ââ, yi mênê wa kee. ");
INSERT INTO yle_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita ngê pi knî ye daa kópu ngmidi vyu, doo kwunokwuno dé, yepê, Mw꞉ââkó a tîdê mbwó yoo, yélini knî y꞉oo Yesu vya ngópu, yi yéli mwo a kuwo tóó, mu kópu u dîy꞉o Chóó Lémi ngê daa pêdê kpada nmyine. ");
INSERT INTO yle_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pi yilî Pita ka kêlîmî mbê dniye, yi yéli dyépi knî y꞉oo Yesu u pi ngê mbwaa paa dnye kmênêkmênê dé, pi pyolo yono yono y꞉a yi wéni ngê Yesu u yoo vy꞉o ghê dniye. ");
INSERT INTO yle_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yi yéli dyépi knî yi p꞉uu dnyimo ndiye, yi nuw꞉o dmi ngmidi ngê dpîmo ya, nipi dnyimo ngêpê, nipi dnyimo kmaapî, Yesu ngê mbîdédi ntee puwâ, wain ntee ye y꞉ângo, yi kópu yinté u nkwo dnyimo d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yesu u dyépi knî y꞉oo mbwudu yilî dnyimo chap, pi yoo yi nyepênyepê u kópu ngê dpîmo pyodopyodo, apu, Kî tpóknî y꞉oo lónté kópu ka d꞉uud꞉uu t꞉oo. ");
INSERT INTO yle_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yélini Yesu ka dnyimo kêlîmî, yi nuw꞉o dmi ngmidi ngê dpîmo ya, yi tpile noko dnyimo yémî dé. ");
INSERT INTO yle_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yi tpile kuwa dnyimon꞉aa yémî dé, pi knî y꞉oo ye dnyimon꞉aa pywupwi dé. Yi tpile knî yi pywuu dnyimo a ńeńe, yi vy꞉o pinté knî ye dnyimon꞉aa yémî. ");
INSERT INTO yle_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Dye ghi yintómu Chóó Lémi u ngomo k꞉oo nipi dnyimo a wó, yi ngomo k꞉oo yi ngomo k꞉oo nté nipi dnyimo pîpî, yi gha dmi mb꞉aamb꞉aa ngê dpîmo ya, dnyimo numo yeedeyeede, noko dêdnyimo mtîkó, Chóó Lémi dnyimo chaa kîgha. ");
INSERT INTO yle_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kuwa tpémi y꞉oo apu, K꞉uuchêm u yoo. Dye ghi yintómu nmî Lémi ngê pi dpîmo ngêêpî dé, u ngwo u kwo dnyimo kêlîmî, u yoo vy꞉o dnyimon꞉aa wowo, u yoo yinté yilî ngê dpîmo pyodopyodo. ");
INSERT INTO yle_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wo yintómu knî yi k꞉oo Nju tpémi Chóó Lémi u ngomo k꞉oo dnyimon꞉aa ngêpê, dini ghi n꞉ii ngê kââdî t꞉ono dpîmo wowo, u ngwo dnyimo koko. Wo ngmê ngê Pita pini dê Njon yi ngêpê têdê até yi lee knopwo. Dini ghi n꞉ii ngê Chóó Lémi u ngomo k꞉oo dpîmo koko, keńe n꞉ii u pi K꞉uuchêm u keńe, ");
INSERT INTO yle_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","yi keńe nkîgh꞉ê pi ngmê m꞉uu ngópu, kpâlî dê kpêê dê. Yi pini dini ghi n꞉ii ngê mwo a ta, yinté dpîmo ya, kpâlî dê kpêê dê, dêdpîmo m꞉ii. Dye ghi yintómu yi pini u pyipe knî y꞉oo dnyimo dnyinêdnyinê, yi keńe nkîgh꞉ê dnyimon꞉aa yiyé. Yélini ngêpê têdê dnyimo koko, yi kpâlî kpêê ngê ndapî ye dpîmo dmyinê. ");
INSERT INTO yle_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Dini ghi n꞉ii ngê yi kpâlî kpêê ngê Pita pini dê Njon m꞉uu doo, yepê, Ndapî a ka ngma a kê nyoo. ");
INSERT INTO yle_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Até yidpîmo y꞉enê, Pita ngê kwo, Ngî m꞉uu nyédi. ");
INSERT INTO yle_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wod꞉oo ye até yi vyu wo, apê ngmênê, Tpile a ka ngmê wunê kuwo ngmê. ");
INSERT INTO yle_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita ngê kwo, Ndapî a ngópu daa tóó, ngmênê kópuni a mênê a tóó, vyîlo ṉga yinînê kuwo. Kwo, Yesu Kédisu Nasalet pi u pi ngê n꞉aa ghêêmî kapî ngi. ");
INSERT INTO yle_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kwo, Gh꞉êêdé. Wod꞉oo u wéni pee kele, ghêêmî kââ. Yi dini ghi ngê yi pini yu nd꞉oo dê wêdêwêdê ngê pyaa knopwo, mbêka wo, ghêêmî ghê wo, wod꞉oo doo paa. ");
INSERT INTO yle_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wod꞉oo yi pini Pita pini dê Njon yi p꞉uu kele, Chóó Lémi u ngomo k꞉oo nipi mê kee dniye. Yi ngomo k꞉oo doo m꞉ii, doo mbêka, Chóó Lémi modoo chaa kîgha. ");
INSERT INTO yle_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Pi knî y꞉oo dini ghi n꞉ii ngê m꞉uu ngópu, mya ngópu, apê, Kî kpâlî kpêê. Apê, Dye ghi yintómu K꞉uuchêm u keńe t꞉âmo kîdpîmo yââyââ, pi knî ye y꞉i dpîmo ndapî dmyinê. Apê, Ala ngwo mb꞉aamb꞉aa ngê mêka m꞉ii, Chóó Lémi myeka chaa kîgha. Apê, Kî lónté kópu? Apê, Lukwe u ngwo ngmêdê pyódu? ");
INSERT INTO yle_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pita Njon y꞉oo pini n꞉ii pyi ngópu, yi pini yi kêlê kele, yi kêê dê mgîmî doo. Chóó Lémi u ngomo dini ghi n꞉ii ngê dnya a kuwokuwo, ghi ngmê y꞉i lee dniye, u pi Solomon u ngomo ghi. Yi kêlî ghê pi yintómu a da wo, Noko yepê, Vyuw! Apê, Kî tpódu y꞉oo kî pini lónté dê pyi ngmê? ");
INSERT INTO yle_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita ngê yoo dini ghi n꞉ii ngê módu, yepê, Yisîléli tpémi. Yepê, Lukwe dîy꞉o nmye liya té? Yepê, Lukwe dîy꞉o nmye y꞉enê nyo? Yepê, Daa nyi chóó nyi wêdêwêdê ngê dnye pyi. Yepê, Daa nyi chóó nyi l꞉êê ghi u dîy꞉o kî pini dê pyiyé. ");
INSERT INTO yle_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yepê, Kêle. Yepê, Chóó Lémi ngê yinê dê pyi. Yepê, Nmî yâpwo njini, pini n꞉ii ka nmî kn꞉ââ Epîlaham dpîmo a ngêpê, tp꞉oo Yisak u kwo myedpîmo a ngêpê, Njakóp u kwo myedpîmo a ngêpê, yepê, pini n꞉ii ka nmî kn꞉ââ yoo dnyimo a ngêpê, yepê, yi yâpwo ngê ala pini yinê dê pyi, mu kópu u dîy꞉o u yi u ngwo a kwo, A dpodo pyu Yesu u pi ndîî ngê paa pyaa we. Yepê, Yi pini nmyi mgîmî ngópu, Paléti ka nmyi y꞉ee ngópu. Yepê, K꞉omo tpile Paléti ngê u yi doo kwo, Yesu nî pw꞉ii, yepê, ngmênê nmyi mb꞉ii ngópu. ");
INSERT INTO yle_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yepê, Yesu ngê Chóó Lémi mu ngmidi u dnye doo nyêm, kópu dono daangmê d꞉uu ngê, ngmênê u wépi nmyi pwaa ngópu, Paléti ka nmyi vyi ngópu, kwonye, Yesu vya ngi, Mbadapas pw꞉ii ngi. ");
INSERT INTO yle_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yepê, Mbadapas pi vyee pyu, yi pini nmyi pw꞉ii ngópu, Ghê u Kn꞉ââ nmyi vya ngópu. Yepê, Nmyi vya ngópu, ngmênê Chóó Lémi ngê mêda pyidu ngê. Yepê, Yi kópu nmî chóó nmî módu. ");
INSERT INTO yle_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yepê, Vyîlo yi Yesu u wêdêwêdê mbêmê ala kpâlî kpêê dnye pyi. Yepê, Kópuni dmye m꞉uu ngmê, kópuni nmyi lama a tóó, yepê, yi kópu Yesu u pi ngê dnye d꞉uu, mu kópu u dîy꞉o u kwo nye kêlîmî mo. Yepê, Yi kópu u l꞉êê dîy꞉o ala pini nmyi ngópu dê pyiyé. Yepê, Nmyo yintómu kîdmye m꞉uu ngmê. ");
INSERT INTO yle_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Yepê, A tîdê mbwó yoo. Yepê, Dini ghi n꞉ii ngê nmyi kada pini knî yi k꞉ii Yesu nmyi vya ngópu, nmyi lama dêpwo ya, Yi pini Chóó lémi ngê a ngmidi ngê. ");
INSERT INTO yle_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yepê, Chóó Lémi u komo kapî pyu knî y꞉oo wunê yinté kópu a vyi ngópu, apê, Dîyo Chóó Lémi ngê pi ngmê wa a ngmidi, yi pini ngê dono wa a pyw꞉oo. Yepê, Chóó Lémi ngê yi kópu yinté ntiye ngê. ");
INSERT INTO yle_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Yepê, Nmyi dono a kuwo tóó, Chóó Lémi ka diyé dmyeno, yed꞉oo nmyi dono yintómu wa chedê, mb꞉aamb꞉aa ngê amê pyódu nmyo, Yesu amyedê dy꞉ââ, pini n꞉ii nmyi l꞉êê dîy꞉o a ngmidi ngê. ");
INSERT INTO yle_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yepê, Mbóó p꞉uu a tóó. Yepê, Kópu yintómu n꞉ii Chóó Lémi u komo kapî pyu knî y꞉oo wunê a vyi tumo dini ghi n꞉ii ngê wa pyaa dmi, yepê, Yesu dyámê mbêmê u ngwo wa a diyé. ");
INSERT INTO yle_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yepê, Mósisi ngê ala kópu a vyu, apê, Nmî Lémi nmî yâpwo ngê ntee a ngmidi noo, nê ntee pini nmyi vy꞉o mu wa a pyw꞉oo, nmye wa a dy꞉ââ. U dnye ka mb꞉aamb꞉aa ngê dmyinê ng꞉aa. ");
INSERT INTO yle_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pini n꞉ii ngê yi pini u dnye daadî nyêm, yi pini Chóó Lémi ngê u yoo vy꞉o wa a pw꞉ii, wamye kpada. ");
INSERT INTO yle_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yepê, Pini n꞉ii knî y꞉oo Chóó Lémi u komo dnyimo a kapî, kn꞉ââ Samuwel, nkoo nmo, yi komo kapî pyu yintómu nmî dye ghi p꞉uu dnyimo a danê. ");
INSERT INTO yle_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yepê, Kópuni Chóó Lémi u komo kapî pyu knî y꞉oo a vyi tumo, yi kópu nmyi vy꞉o a pyodopyodo té. Yepê, Dini ghi n꞉ii ngê Epîlaham pini dê Chóó Lémi a numo kââdî doo, Chóó Lémi ngê Epîlaham ka kwo, Ṉii ńedê pi ngmê ngê dyámê mbêmê pi yintómu wa ngee té. ");
INSERT INTO yle_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yepê, Chóó Lémi ngê yi pini wunê ka a dpodo kwólu, nmye mwiyé a dy꞉ââ ngê, yinê wa ngee nmyo, nmyi l꞉êê ghi dono knî yi vy꞉o yinê amyedê y꞉ee nmyo. ");
INSERT INTO yle_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita pini dê Njon y꞉oo pi knî ye danêmbum ghêlî k꞉ii dêpê kêlî ngópu, kpêê yiyé pyu yoo, Sadyusi yoo, Chóó Lémi u ngomo y꞉enê pyu u k꞉ii y꞉i u ngwo taa dniye. ");
INSERT INTO yle_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yi yéli nod꞉e dniye, Pita pini dê Njon ye, mu kópu u dîy꞉o yi pini dê y꞉oo pi knî ye dpîmo tpapê, yipu, Yesu kî pwene, kîmêdê pii wo. Sadyusi knî y꞉oo noko vyi ngópu, apê, Lukwe dîy꞉o kî pini dê y꞉oo ala kópu a tpapê ngmê, Pi wa pw꞉onu, amêdê pyidu. Apê, Yinté daa tóó. Yi kópu u l꞉êê dîy꞉o nod꞉e dniye. ");
INSERT INTO yle_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Wod꞉oo yi pini pyile knî mgîmî tumo, mbwa k꞉oo kalê tumo, mu kópu u dîy꞉o apê, Mgîdî wunê ghayghay. Apê, Mââ wanmî kóté kalê té. ");
INSERT INTO yle_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","N꞉ii knî y꞉oo Pita u kópu ny꞉ee ngópu, yi yéli yi vy꞉o yilî u kwo kêlîmî mbê wo. Yesu u yoo ndîî ngê u ngwo pyodo, mââ yintómu limo yono yono y꞉a. (5,000) ");
INSERT INTO yle_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Womumo mw꞉aandiye Nju tpémi yi kada pini yoo, mââwe ndîî yoo, dêêpî pyu yoo Njedusalem mênê wó, kpêê yiyé pyu knî yi kada pini ndîî Anas u yoo knî yi k꞉ii, myenté Kayapas, Njon pini dê Aleksándê mye yi k꞉ii. ");
INSERT INTO yle_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Yi yéli y꞉oo Yesu u dyépi dê kóté kalê dumo, yepê, Angênté dpî d꞉uu ngmê? Yepê, Ló wêdêwêdê mbêmê dpî d꞉uu ngmê? Yepê, N꞉uu u pi ngê dpî d꞉uu ngmê? ");
INSERT INTO yle_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wod꞉oo Chóó Lémi u Ghê Dmi ngê Pita a nt꞉ee ngê, yepê, A léma, nmî kada pini yoo. ");
INSERT INTO yle_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yepê, U yi nmye a kwo, Nmyi lama yaa we, kpâlî kpêê nanê pyi, kópu mb꞉aa n꞉uu ngê u ngwo d꞉uu, apii? ");
INSERT INTO yle_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yepê, Nmyi lama choo ya, Yisîléli tpémi yintómu yi lama myechoo ya, Yesu Kédisu Nasalet pi, pini n꞉ii kîdosi ńedê nmyi t꞉ee ngópu, Chóó Lémi ngê mêda pyidu ngê, yi pini u wêdêwêdê mbêmê, u pi mbêmê ala kpâlî kpêê nyi pyi. Yepê, Ngî m꞉uu yó, mb꞉aamb꞉aa ngê mêka m꞉ii. ");
INSERT INTO yle_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yepê, Vyîlo Yesu p꞉uu ala kópu wunê a d꞉êê ngópu, apê, Yi pââni nmyi kéé ngópu, yi yini pââ pw꞉eni ngê vyîlo mêyi pyodo. ");
INSERT INTO yle_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yepê, Yesu mu ngmidi nmî mbwámê. Yepê, Dyámê mbêmê pi yilî yi vy꞉o Chóó Lémi ngê pi mu ngmidi a ngmidi ngê, u ntââ yinê wa ngee nmo. ");
INSERT INTO yle_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nju tpémi yi kada pini knî y꞉oo Pita u kópu dyuu dini ghi n꞉ii ngê ny꞉ee ngópu, ghê dmi yi mênê ghipé wo, apê, Á! Apê, K꞉omo tpile daa ndiye pyu ndîî dê, ngmênê doo kede knopwo, nmo ka danêmbum mo. U kuwó dini ghi ngê a w꞉ee ngópu, apê, Kî pini dê Yesu p꞉uu dpîmo ya. ");
INSERT INTO yle_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yed꞉oo kópu mêdaa vyi ngópu, mu kópu u dîy꞉o Pita pini dê Njon y꞉oo pini n꞉ii pyi ngópu, yi pini yi nkîgh꞉ê m꞉uu ngópu. ");
INSERT INTO yle_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wod꞉oo yi pini pyile knî kuwa mwiyé mê dy꞉ââ tumo. ");
INSERT INTO yle_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Noko yepê, Lukwe y꞉e ngmanmî md꞉o? Noko yepê, Njedusalem pi yintómu yi lama a tóó, Wu pini dê y꞉oo mbwudu ngmê chaa ngmê. Noko yepê, Doo u ntââ daanmî vyi, A k꞉omodanê mo. ");
INSERT INTO yle_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Noko yepê, Ala kópu ndîî ngê kîngê pyódu, mwada y꞉i kîngê nî. Noko yepê, Wu pini dê ye paa kwódu koo, pi knî ye Yesu u pi mêkîngê vyi ngmê. ");
INSERT INTO yle_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wod꞉oo yi pini pyile knî a dyé tumo, Pita Njon ye yepê, Kî tpódu. Yepê, Yesu u pi ngê pi kudungmê ndiye kalê ngmê. ");
INSERT INTO yle_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pita Njon y꞉oo yepê, Nmyi chóó dpî vyi yó, nmyi dnye dmi ayiny꞉oo nyêm, ó Chóó Lémi u dnye ayiny꞉oo nyêm. ");
INSERT INTO yle_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yepê, Kópuni nyinê m꞉uu too, kópuni nyinê ny꞉ee too, pi knî ye vyîlo y꞉ee tpapê té, ye danêmbum daanyi yé. ");
INSERT INTO yle_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nju tpémi yi kada pini knî y꞉oo d꞉ud꞉umbiy꞉e ye kwódu ngópu, yed꞉oo mê kalê tumo. Doo u ntââ daapê kpada dumo, mu kópu u dîy꞉o pi yilî yintómu yi lama doo ya, Kî tpódu y꞉oo kpâlî kpêê y꞉oo pyi ngmê, Chóó Lémi u ngwo dnye chaa kîgha. ");
INSERT INTO yle_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yi kpâlî kpêê mââwe ndîî, u m꞉ââ podo y꞉a ka mê mbêpê wo. ");
INSERT INTO yle_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita Njon kada pini knî y꞉oo dini ghi n꞉ii ngê kalê dumo, Yesu u yoo vy꞉o mê diyé knopwo, Nju tpémi yi kada pini knî y꞉oo kópuni ye vyi ngópu, yi kópu Yesu u yoo knî ye mîmî vyi ngópu. ");
INSERT INTO yle_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yi yéli y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, wod꞉oo Chóó Lémi ka dnye ngêpê, kwo, Nmî Lémi. Kwo, Mbóó dyámê ntii nyi l꞉âmo too, tpileni y꞉i a pyede m꞉ii l꞉âmo too. ");
INSERT INTO yle_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kwo, Nmî kn꞉ââ Dépidi m̱꞉uu doo a dpodo, ṉ́yóó Ṉgê Dmi ngê yinê a ngópu, ala kópu u ngwo a d꞉êê ngê, apê, Kn꞉aa dyámê tpémi lukwe dîy꞉o Chóó Lémi ka a nod꞉enod꞉e nyédi? A Lémi u pwele lukwe dîy꞉o a châpwo ngópu? Dpî dêê dmi. ");
INSERT INTO yle_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Dyámê u kada pini yoo nipi dpo wó, u yi y꞉e a kwo yédi, Chóó Lémi p꞉uu nmî l꞉êê, pini n꞉ii a ngmidi ngê, p꞉uu myenmî l꞉êê. ");
INSERT INTO yle_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kwo, Yi kópu ndêndê ngê pyodo, dini ghi n꞉ii ngê Helodi pini dê Pontiyas Paléti y꞉oo a kââdî ngópu, Yisîléli tpémi kn꞉aa dyámê tpémi mye yi k꞉ii myedê kââdî ngópu, Yesu u ngwo mb꞉ii ngópu. Kwo, K꞉omo tpile nyinê ngmidi ngê, m̱꞉uu doo dpodo, kn꞉aa pini p꞉uu dêpwo dpodo, ngmênê mye mb꞉ii ngópu. ");
INSERT INTO yle_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kwo, Yi kópu d꞉uu ngópu, mu kópu u dîy꞉o wunê nyinê vyu, anye, Yi kópu dîyo wa pyódu. ");
INSERT INTO yle_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kwo, K꞉omo tpile kada pini knî y꞉oo nmo dê kwódu ngmê, nkîngê nmî mênê a ngini, a ngee nmédi, ṉgópu dyuu pi knî ye anmîn꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kwo, Ṉgwêdêwêdê mbêmê pi yilî dpî pyi ngi, dpî ngee nmédi, yed꞉oo ṉmodo pyu mb꞉aa Yesu u pi ngê mbwudu yilî anmî chap. ");
INSERT INTO yle_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Dini ghi n꞉ii ngê ngêpê a kêlî ngópu, kwéli dnye ngêpê, yi ghi doo ghêdê. Chóó Lémi u Ghê Dmi ngê yi gha dmi a nt꞉ee ngê, yed꞉oo dêdnyimo nkîngê, Chóó Lémi u kópu dyuu pi knî ye mêdnyimon꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yesu ka yélini dnyimo ng꞉aa, yi gha dmi mu ngmidi, yi nuw꞉o dmi mu ngmidi. Pi ngê daa vyu, Ala a mo a tpile, ngmênê tpileni yilî yi ngópu dpîmo ya, noko dnyimo yêêpî. ");
INSERT INTO yle_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yesu u dyépi knî y꞉oo pi knî ye dnyimon꞉aa tpapê, yipu, Ndêndê ngê Yesu ka a pii wo, nmî chóó nmî ngwolo knî y꞉oo nmî módu. Chóó Lémi ngê dpîmo wêdêwêdê kîgha dé, mbwudu yilî u ngwo dnyimo chap. ");
INSERT INTO yle_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yesu u yoo vy꞉o pinté dêpwo kwo, mu kópu u dîy꞉o yélini yoo yi chóó yi têpê ghi dnyimo ya, ó yi ngomo dnyimo kwo, kuwa tpémi y꞉oo yi tpile yilî ye dnyimo pywupwi dé. ");
INSERT INTO yle_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Yélini knî y꞉oo ndapî yinté dnyimo kmênêkmênê, yi ndapî dyépi knî ye dnyimo yémî, yi ndapî p꞉uu nipi mêdnyimo kmaapî. ");
INSERT INTO yle_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lipi u tii ńedê pini ngmê ngê yinté kópu ngmê d꞉uu ngê, u pi Njósép. Yi pini Saipîdîs pyodo. Dyépi knî y꞉oo yi pini u pi ntaa ngópu, apê, Mbanapas (u nt꞉u kópu, dêêpî pyu mb꞉aa). ");
INSERT INTO yle_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yi pini ka kn꞉aa pini ngmê ngê u têpê ghi pwila ngê, wod꞉oo Mbanapas ngê yi ndapî dyépi knî ye a ńuwo, ye mî y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pi ngmê u pi Ananayas, u kpâm u pi Sapada. Yi têpê ghi kn꞉aa pini ngmê ka y꞉ee ngópu, ye pwila ngê. ");
INSERT INTO yle_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","U kpâm k꞉ii ndapî knî ngmê mgîpa kalê ngópu, Ananayas ngê woni knî dyépi knî ye ńuw꞉o too, ye mî y꞉ee too, yepê, Ala a têpê ghi u pywuu. ");
INSERT INTO yle_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pita ngê kwo, Ananayas. Kwo, Lukwe dîy꞉o Setan ngê ṉga dê nt꞉ono, ṉga yinê dê vyi, Chóó Lémi u Ghê Dmi u ngwo chi dóó. Kwo, Lukwe dîy꞉o ṉ́êpê ghi u pywuu knî m꞉uu chi mgîpa kwolo. ");
INSERT INTO yle_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kwo, Têpê ghi ṉ́yóó ṉ́êpê ghi, u pywuu nyinê ngópu, ndapî mye ṉapî. Kwo, Dini ghi n꞉ii ngê ndapî knî ngmê muchi mgîpa kwolo, lukwe dîy꞉o nmo chi vyi, Ala a têpê ghi u pywuu d꞉ud꞉umbiy꞉e. Kwo, Daa nmo nye k꞉omodanê, ngmênê Chóó Lémi ka nye k꞉omodanê. ");
INSERT INTO yle_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Dini ghi n꞉ii ngê Ananayas ngê yi kópu nyongo, wod꞉oo a vyóó wo, yed꞉oo y꞉i pwene. Noko yepê, K꞉omo tpile Ananayas ngê tumu kópu yi d꞉uu, ngmênê nmî Lémi ngê da m꞉uu. Noko yepê, Pi ngê dono kópu kîngmê d꞉uu. Pi knî y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, nkîngê mbê dniye. ");
INSERT INTO yle_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pi mgêmî yoo ngma a loo, ntóó mî kwede ngópu, dnyinê ngópu, mî kmênê ngópu. ");
INSERT INTO yle_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kââdî liy꞉aa pyile mî loo, Ananayas u kpâm yi ngomo k꞉oo u nkwo ta. U lama dêpwo ya, M̱oo kêdê pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita ngê kwo, Mumdoo, kwo, têpê ghini dpî y꞉ee ngópu, ala d꞉ud꞉umbiy꞉e u pywuu? Yi pyópu ngê kwo, Nyââ, kwo, ye d꞉ud꞉umbiy꞉e yi têpê ghi u pywuu. ");
INSERT INTO yle_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita ngê kwo, Lukwe dîy꞉o m̱oo k꞉ii nmî Lémi u Ghê Dmi dpî dóó ngmê? Kwo, Wunê u Ghê Dmi ngê até da pywálî dp꞉o. Kwo, Pini n꞉ii knî y꞉oo m̱oo dê kmênê ngmê keńe t꞉âmo ngee wee, ṉ́óó mye kmênêkmênê ngmê. ");
INSERT INTO yle_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wod꞉oo yi pyópu y꞉i myedê vyóó wo, mye pwene. Pi mgêmî yoo a lee dniye, ntóó yi m꞉uu ngópu, apê, Atémya pw꞉onu. Wod꞉oo mye dnyinê ngópu, u moo u nkîgh꞉ê mî kmênê ngópu. ");
INSERT INTO yle_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yesu u yoo yintómu knî y꞉oo dini ghi n꞉ii ngê ny꞉ee ngópu, nkîngê mbê dniye, pi woni knî y꞉oo myeyi ny꞉ee ngópu, mye nkîngê mbê dniye, nkîngê ngê y꞉ay꞉a pwiyé dniye. ");
INSERT INTO yle_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Dyépi knî y꞉oo pi knî yi ngópu mbwudu yilî dnyimo chap. Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo, ngomo ghi ngmêdoo ya, u pi Solomon u ngomo ghi. Yesu u yoo yintómu yi ngomo ghi k꞉oo nipi dnyimon꞉aa a wó. ");
INSERT INTO yle_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","K꞉omo tpile kuwa tpémi y꞉oo Yesu u yoo dnyimo chaa kîgha dé, noko yipu, K꞉uuchêm u yoo, ngmênê ye dnyimo nkîngê, yi ngomo ghi k꞉oo dêdnyimo koko, yi vy꞉o dêdnyimon꞉aa wowo, apu, Ngmanmî pw꞉onu. ");
INSERT INTO yle_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ngmênê woni yoo, dini ghi n꞉ii ngê Yesu ka ndêndê ngê kêlîmî mbê dniye, u yoo vy꞉o u ngwo ghê dniye, Yesu u yoo ndîî ngê u ngwo dpîmo pyodopyodo. ");
INSERT INTO yle_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Dyépi knî y꞉oo kópuni dnyimo d꞉uud꞉uu dé, yi kópu knî yi l꞉êê dîy꞉o pi knî y꞉oo mbii pyu yoo dnyimo dnyinêdnyinê dé, maa p꞉uu yi ngmîtédmi yedê dnyimon꞉aa yiyé dé, apu, Pita dini ghi n꞉ii ngê pêdê lee we, u kââ mbii pyu knî yi pwo paan꞉aa kéé ngê, u ngwo paa pyiyé dniye. ");
INSERT INTO yle_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Njedusalem u nkîgh꞉ê p꞉aani n꞉ii dnye ya, yi p꞉aani tpémi y꞉oo yi mbii pyu yoo Njedusalem dnyimo a ńeńe dé. N꞉ii dé y꞉e yi kmêna dnye kwo, Njedusalem myednyimo a ńeńe dé. Dyépi knî y꞉oo yi yéli yintómu dnyimo pyipyi dé. ");
INSERT INTO yle_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yi dini ghi ngê kpêê yiyé pyu knî yi kada pini ndîî, u pyipe yoo Sadyusi yoo yi k꞉ii Yesu u dyépi knî ye ń꞉ee kaa ngópu. ");
INSERT INTO yle_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wod꞉oo Chóó Lémi u ngomo t꞉âât꞉ââ pyu yoo dy꞉ââ tumo, yi yéli y꞉oo dyépi yoo mînê mgîmî tumo, ńuw꞉o tumo, mbwa k꞉oo mî kalê tumo. ");
INSERT INTO yle_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Yi mgîdî ngê, Chóó Lémi u enjel ngmê ngê mbwa keńe ye kpêmî ngê, dyépi yoo kuwa pw꞉ii too, yepê, Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo dmyinê lêpî, pi knî ye ghê kamî dmi p꞉uu dmyinên꞉aa danê. ");
INSERT INTO yle_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Dyépi knî y꞉oo u dnye ny꞉ee ngópu, yi wa wo, wod꞉oo Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo kee dniye, pi knî ye ghê kamî dmi p꞉uu dnyen꞉aa danêmbum. U kuwó dini ghi ngê kpêê yiyé pyu yoo yi kada pini u pyipe knî yi k꞉ii Nju tpémi yi kada pini yintómu a danê ngópu, pi knî ngmê dy꞉ââ ngópu, yepê, Yesu u yoo mbwa k꞉oo nye pw꞉ii tóó, nmo a ńuw꞉o tóó. ");
INSERT INTO yle_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Yi yéli dini ghi n꞉ii ngê taa dniye, mbwa yi kpêmî ngópu, apê, Pi u chii daa kwo. Wod꞉oo mê diyé dniye, Nju tpémi yi kada pini knî ye mdoo ńuw꞉o ngópu, yepê, Dini ghi n꞉ii ngê mbwa chedê dpî taa dmi, keńe kuwo ngmê dpî m꞉uu, d꞉ê, Mbwa t꞉âât꞉ââ pyu dê mu kwo mo. Yepê, Mbwa keńe dini ghi n꞉ii ngê dpî kpêmî, mbwa k꞉oo pi dp꞉oo módu. ");
INSERT INTO yle_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chóó Lémi u ngomo y꞉enê pyu, kpêê yiyé pyu yoo yi k꞉ii yi kópu dêpê w꞉ee ngópu, noko yepê, Lukwe ngê dê pw꞉ii té? Noko yepê, Dîyo lukwe nmo angmê pyódu? ");
INSERT INTO yle_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pi ye ngma até yedê loo, yepê, A léma. Yepê, Pini n꞉ii yoo mbwa k꞉oo munmyi km꞉êê t꞉oo, Chóó Lémi u ngomo mbwa kalê ngmê k꞉oo mêmînê wee, pi knî ye mînê dêêpî té. ");
INSERT INTO yle_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wod꞉oo Chóó Lémi u ngomo y꞉enê pyu u lede knî yi k꞉ii lee dniye, dyépi yoo mê nya tumo. Daa gheteghete ngê nya tumo, mu kópu u dîy꞉o nkîngê mbê dniye, apê, Pi knî y꞉oo chêêpî ngê wa vya nmo. ");
INSERT INTO yle_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Dyépi yoo Nju tpémi yi kada pini knî ye ńuw꞉o tumo, kpêê yiyé pyu yoo yi kada pini ngê yepê, Kî tpóknî. ");
INSERT INTO yle_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Yepê, Yesu u pi tpapê nmye munmî kwódu ngê, ngmênê Njedusalem wope wope u pi yi nuwo kîdmye kalê ngmê. Yepê, Pi knî ye nmye tpapê ngópu, yenmyimo, Nmî kada pini yoo kn꞉ââ dé, Yesu y꞉oo vya ngópu. ");
INSERT INTO yle_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita u pyipe knî yi k꞉ii kada pini knî ye yepê, Daa yoo yi dnye dmi yinmo nyêm, ngmênê Chóó Lémi u dnye vyîlo yinmo nyêm. ");
INSERT INTO yle_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yepê, K꞉omo tpile Yesu nmyi vya ngópu, kîdosi ńedê nmyi t꞉ee ngópu, ngmênê Chóó Lémi ngê mêdê pyidu ngê, yâpwoni ka nmî kn꞉ââ yoo dnyimo a ngêpê, yi yâpwo ngê mêdê pyidu ngê. ");
INSERT INTO yle_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yepê, Chóó Lémi ngê Yesu dini ghi n꞉ii ngê a pyidu ngê, u che p꞉ââ pee ngê pyódu ngê, nmî kada kââ, nmî mbwámê ngê pyódu ngê. Yepê, Yisîléli tpémi yi maa yinê a yó, u yi u ngwo a kwo, Yi dono mwiyé kéé téne, ala máádi u ngwo pêdê kalê y꞉e, Chóó Lémi yi dono p꞉uu mêdaapîchoo nuw꞉o. ");
INSERT INTO yle_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yepê, Yi kópu yilî ndêndê ngê nmî chóó kînmî módu. Yepê, Chóó Lémi u Ghê Dmi ngê Yesu myewunê kêmakêma, mu kópu u dîy꞉o daa Yisîléli tpémi yintómu ye Chóó Lémi ngê u Ghê Dmi a dy꞉ââ ngê, ngmênê Yesu u yoo mu ngmidi u Ghê Dmi ye a dy꞉ââ ngê, yélini y꞉oo Chóó Lémi u dnye a nyêmî ngmê. ");
INSERT INTO yle_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dini ghi n꞉ii ngê Nju tpémi yi kada pini knî y꞉oo Pita u kópu ny꞉ee ngópu, dyépi knî ye nod꞉e dniye, u yi y꞉e doo kwo, Nmî vya té. ");
INSERT INTO yle_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ngmênê pi yi vy꞉o ngmê ghêêdî wo, u pi Nkamaliyel. Yi pini Pádisi yoo yi vy꞉o pini ngmê, pi knî ye Chóó Lémi u dêêpî kópu dyuu mb꞉aamb꞉aa ngê dpîmo tpapê, pi knî y꞉oo u nkwo dnyimo chââchââ. Yi pini ngê Chóó Lémi u ngomo t꞉âât꞉ââ pyu knî ye yepê, Yesu u dyépi yoo mwiyé mê pw꞉ii tóó. Wod꞉oo kuwa pw꞉ii tumo. ");
INSERT INTO yle_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","U kuwó dini ghi ngê Nkamaliyel ngê kada pini knî ye yepê, Yisîléli tpémi. Yepê, Kî tpóknî ghêlî k꞉ii nangê vya té. ");
INSERT INTO yle_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yepê, M꞉ââ pyolo y꞉a d꞉uu lê, pi ngmê ngê u pi ndîî ngê chóó doo pyépi, yi pini u pi Téyódas. Yepê, K꞉omo tpile pi podo yono y꞉a yi Téyódas dnye yâmuyâmu, dini ghi n꞉ii ngê yi pini mî vya ngópu, u yoo mbêpê wo, yi kópu dmi machedê ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yepê, Myenté, yepê, u kuwó dini ghi ngê, pi u kpââ u dye ghi ngê, pi ngmê ngê u yoo myedê danê ngê, u pi Njudas, Nkálili pi. Yepê, Yi pini dini ghi n꞉ii ngê vya ngópu, u yoo mye mbêpê wo. ");
INSERT INTO yle_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","Nkamaliyel ngê yepê, Yesu ngê u yoo myedê danê ngê, mye pwene, u yoo wamye mbêpê dmi. Yepê, Chóó Lémi ngê daadî ngêêpî dé, ye yi kópu dmi machedê ngê wa pyódu. Yepê, Ngmênê Chóó Lémi ngê adî ngêêpî dé, ye doo u ntââ yi kópu dmi daanmyi chedê ngmê. Yepê, Nmyi lama daa tóó, Kî tpóknî n꞉uu p꞉uu a dpodo té. Yepê, Doo u ntââ daanmyi vya t꞉oo. Yepê, Chóó Lémi p꞉uu kîdmyemê d꞉uu. ");
INSERT INTO yle_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kada pini knî y꞉oo Nkamaliyel u dnye ny꞉ee ngópu, Chóó Lémi u ngomo t꞉âât꞉ââ pyu yoo dy꞉ââ tumo, yepê, Yesu u dyépi yoo nya tóó, al꞉ii a ńuw꞉o tóó, yedê dmi ngê dpî kpaka tóó. Wod꞉oo ńuw꞉o tumo, mî kpaka tumo. U kuwó dini ghi ngê kada pini knî y꞉oo Yesu u dyépi knî ye yepê, Yesu u pi ngê ndiye ngê kêê namungê t꞉oo. Wod꞉oo dy꞉ââ tumo. ");
INSERT INTO yle_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yesu u dyépi yoo yi lama ala kópu yi yaa wo, Chóó Lémi ngê yinê da vyi, apu, Kî a yoo mb꞉aamb꞉aa. Apu, K꞉omo tpile wa kpaka t꞉oo, ngmênê Yesu u dpodo daawa kalê ngmê. Yi kópu u l꞉êê dîy꞉o yi gha dmi mb꞉aamb꞉aa ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Dye ghi yintómu dyépi yoo pi knî ye dnyimon꞉aa dêêpî, Chóó Lémi u ngomo k꞉oo, ó p꞉o p꞉o. Pi knî ye Yesu p꞉uu kópu mb꞉aa y꞉i ye dnyimon꞉aa tpapê dé, pini n꞉ii Chóó Lémi ngê a ngmidi ngê, yi pini p꞉uu dnyimon꞉aa danêmbum. ");
INSERT INTO yle_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dyépi yoo Yesu p꞉uu yélini ye dnyimon꞉aa danêmbum, woni knî Yesu ka kêlîmî mbê dniye. Yi yéli Yesu u yoo vy꞉o ghê dniye, Yesu u yoo yinté ndîî ngê doo pyodopyodo. Yesu u yoo vy꞉o woni knî Kîdiki dnye ngê dnyimo mbumu, woni knî Nju dnye ngê dnyimo mbumu. Yi yéli yi kêlî dîdîpwódu ngmê ghê wo, mu kópu u dîy꞉o n꞉ii dé Kîdiki dnye ngê dnyimo mbumu, yi yéli y꞉oo woni knî ye yepê, Lukwe dîy꞉o nmyi kuknwe yoo mb꞉aamb꞉aa ngê nmyinê wopwe t꞉oo, ngmênê nmî kuknwe yoo dnyinté nmyinê wopwe t꞉oo? ");
INSERT INTO yle_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yi kópu u l꞉êê dîy꞉o dyépi knî y꞉oo Yesu u yoo yintómu nipi a danê ngópu, yepê, Doo u ntââ pi knî ye Chóó Lémi u kópu tpapê daanmî yé, doo u ntââ ndapî nmî chóó kuknwe knî ye daanmî yêêpî. ");
INSERT INTO yle_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yepê, Nmî tîdê mbwó yoo. Yepê, Nmyi vy꞉o pi pyudu a pyw꞉ee yó, n꞉ii dé Chóó Lémi u Ghê Dmi ngê da nt꞉ee té, n꞉ii dé yi nuw꞉o mbêmê a nuw꞉o té. Yepê, Yi yéli ndapî yêêpî u kada pini ngê anmî pyódu té. ");
INSERT INTO yle_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yepê, U kuwó dini ghi ngê nmî chóó dpodo mu ngmidi ayinmî dódó, Chóó Lémi ka ngêpê, pi knî ye u kópu dyuu tpapê. ");
INSERT INTO yle_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yesu u yoo y꞉oo yi kópu dini ghi n꞉ii ngê ny꞉ee ngópu, yi gha dmi mb꞉aamb꞉aa ngê pyodo, wod꞉oo pi pyudu a pyw꞉ee ngópu, Stipen ngmê, pini n꞉ii Yesu ka dpodombiy꞉e dpîmo kêlîmî, pini n꞉ii Chóó Lémi u Ghê Dmi ngê myedê nt꞉ee ngê, Pilipi myomo, Pîdokodos pyolo, Nikano podo, Timon limo, Pamenas wono, Nikólas pii, Antiyóka pi, pini n꞉ii Nju pi ngê chóó mî pyodo. ");
INSERT INTO yle_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yesu u yoo y꞉oo yi pini pyudu knî dyépi knî ye a ńuw꞉o tumo, dyépi knî y꞉oo yi kêê dmi yi mbêmê yé tumo, Chóó Lémi ka dnye ngêpê, yi dpodo u kada pini ngê u ngwo pyódu tumo. ");
INSERT INTO yle_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","U kuwó dini ghi ngê yélini Chóó Lémi u kópu ka dnye kêlîmî, Njedusalem, yi yéli doo kaakaa, ndîî ngê doo pyodopyodo. Kpêê yiyé pyu yilî yi kópu ka mye kêlîmî mbê dniye, Yesu u yoo vy꞉o mye ghê dniye. ");
INSERT INTO yle_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Chóó Lémi ngê Stipen mb꞉aamb꞉aa ngê doo a ngêêpî, u wêdêwêdê ndîî ngê pyódu ngê, pi knî yi vy꞉o mbwudu yilî dpîmo chap. ");
INSERT INTO yle_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ngmênê Nju tpémi yoo ngmê u kwo dnye kwopwepe, yi yéli yi pi dmi, Lipîtini. Woni yoo Sadéni a ndê dniye, woni yoo Aleksándîdiya a ndê dniye. Nju pi knî ngmê yi vy꞉o ghê dniye, woni yoo Silisiya a ndê dniye, woni yoo Esiya a ndê dniye. Yi yéli yintómu Stipen ka dnye kwopwepe. ");
INSERT INTO yle_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ngmênê Chóó Lémi u Ghê Dmi ngê Stipen ka nuw꞉o mb꞉aa y꞉ângo, wod꞉oo kwopwepe têdê Stipen mbodo mudu y꞉i yaa wo, yi yéli dêê dniye, Stipen dêpê vy꞉oo ngópu. ");
INSERT INTO yle_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yi kópu u l꞉êê dîy꞉o pi ngmê knî ye ndapî y꞉ee ngópu, wod꞉oo yi yéli y꞉oo ala kópu k꞉omo ngê vyi ngópu, Nju tpémi ye yepê, Stipen ngê dono kópu knî ngmê kêdê vyi, Chóó Lémi pini dê Mósisi yi p꞉uu. ");
INSERT INTO yle_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yi kópu u mdoo dini ghi n꞉ii ngê a ńuw꞉o ngópu, yi kópu ngê Nju tpémi yi kada pini yoo yi némi dmi dyênê ngê, dêêpî pyu yoo yi némi dmi mye dyênê ngê, yoo yi némi dmi mye dyênê ngê, wod꞉oo Stipen ka lee dniye, mgîmî ngópu, Nju tpémi yi kada pini yintómu a danê ngópu, Stipen a ngî ngópu, yi ngîma mî kaa ngópu. ");
INSERT INTO yle_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","N꞉ii dé y꞉oo Stipen yipe ngópu, Yi yéli kóté têdê myeda ńuw꞉o tumo, yi yéli y꞉oo yepê, Kî pini ngê Chóó Lémi u ngomo p꞉uu dono kópu yilî ka a tpapê ngê, dêêpî kópuni Mósisi ngê a d꞉êê too, yi dêêpî kópu knî yi p꞉uu dono kópu yilî myeka a tpapê ngê. ");
INSERT INTO yle_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yepê, Ala kópu nmî ngêêdî kî vyu, Yesu Nasalet pi ngê Chóó Lémi u ngomo wa a vy꞉oo, l꞉emi ghi n꞉ii Mósisi ngê nmî kn꞉ââ knî ye y꞉ee too, yi l꞉emi ghi wa ngmêê té. ");
INSERT INTO yle_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pi yilî yintómu y꞉oo Stipen dnye y꞉enê, apê, Kî pini kwodo ng꞉oo dmi kêdê tpâlî, ka dnyednye. Enjel kwodo ng꞉oo dmi ntee, Stipen kwodo ng꞉oo dmi yinté mye pyodo. ");
INSERT INTO yle_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kpêê yiyé pyu knî yi kada pini ngê Stipen ka kwo, Kópuni dê vyi ngmê, yi kópu mumdoo ndê kópu? ");
INSERT INTO yle_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stipen ngê yepê, A léma, a mbwó yoo. Yepê, A ka a ng꞉aa mbê dmyeno. Yepê, Dini ghi n꞉ii ngê nmî kn꞉ââ Epîlaham Mbápilon Wee u kwo doo a ya, Chóó Lémi ngê chóóchóó u kwo a kêma ngê, pini n꞉ii yâpwo, u pi ndîî. Yepê, Chóó Lémi ngê kwo, Ṉyoo a kuwo ngi, ṉyámê pee myedê kuwo ngi. ");
INSERT INTO yle_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kwo, Kn꞉aa dyámê pee p꞉uu chi lêpî, ghi n꞉ii ṉga nîmo kêmakêma, y꞉i dpî lili. ");
INSERT INTO yle_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yepê, Wod꞉oo Epîlaham ngê Mbápilon wee a kuwo ngê, Halan loo, y꞉i doon꞉aa ya. Yepê, Epîlaham u mî dini ghi n꞉ii ngê pwene, u kuwó dini ghi ngê Chóó Lémi ngê ala dyámê pee p꞉uu u ngwo mêda ńuwo, awêde kwéli nmo pyede. ");
INSERT INTO yle_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yepê, Yi dini ghi ngê Chóó Lémi ngê Epîlaham ka têpê ghi daangmê y꞉ângo, têpê ghi tp꞉oo u kwo myedaa y꞉ângo, ngmênê Chóó Lémi ngê Epîlaham ka ndêndê ngê a vyu, kwo, Mu dini ghi ngê ala dyámê pee ṉga wanê kê, mwada dini ghi ngê ala dyámê pee ṉyoo knî yi têpê ghi ngê amyedîn꞉aa ya. Yepê, Dini ghi n꞉ii ngê Chóó Lémi ngê Epîlaham ka yi kópu ndêndê ngê vyu, yi ngwo Epîlaham tp꞉oo dêpwo ya. ");
INSERT INTO yle_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yepê, Ngmênê Chóó Lémi ngê Epîlaham ka kwo, Ṉyoo dini ghi n꞉ii ngê wamî ch꞉aa, kn꞉aa dyámê pee mbêmê adnyin꞉aa ya, wop adnyin꞉aa dpodo, pi knî y꞉oo y꞉i adnyin꞉aa kpakakpaka dé, dono ngê adnyin꞉aa ya, m꞉ââ podo yono y꞉a. ");
INSERT INTO yle_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kwo, Ngmênê u kuwó dini ghi ngê yélini yi p꞉uu wop adnyin꞉aa dpodo, yi yéli wanî kpada, ṉyoo yi vy꞉o wanê pw꞉ii, ala dyámê pee mbêmê wanê ńuw꞉o té, al꞉ii a ka adnyin꞉aa kpêê yiyé, a ka amyednyin꞉aa a ngêpê. ");
INSERT INTO yle_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Stipen ngê yepê, Dini ghi n꞉ii ngê Chóó Lémi ngê Epîlaham ka yi kópu a vyu, u kuwó dini ghi ngê a numo kââdî doo, kwo, Awêde dî ngmidi ngi, ṉyoo ka mb꞉aamb꞉aa ngê amy꞉aa a vyuwo. Kwo, A l꞉ii m̱꞉uu alanté dpî téni, m̱i njini too dpî chepwe, myenté ṉyoo vy꞉o mââ yintómu knî yi p꞉uu a l꞉ii yinté my꞉oon꞉aa kaa we. Kwo, Pini n꞉ii p꞉uu a l꞉ii adî ya, yini ka ana a vyuwo. Stipen ngê yepê, U kuwó dini ghi ngê Epîlaham tp꞉oo Yisak ta, wo wááli mî loo, Epîlaham ngê Chóó Lémi u l꞉ii tp꞉oo p꞉uu u ngwo t꞉ângo. Yepê, Myenté, yepê, Yisak mye tpamê wo, tp꞉oo Njakóp p꞉uu Chóó Lémi u l꞉ii mye t꞉ângo. Yepê, U kuwó dini ghi ngê Njakóp myimî tpamê wo, Chóó Lémi u l꞉ii tp꞉oo y꞉a mê miyó knî yi p꞉uu mye t꞉ângo. ");
INSERT INTO yle_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Yepê, Njakóp tp꞉oo knî y꞉oo yi mbwó Njósép ka ń꞉ee kaa ngópu, wod꞉oo mgîmî ngópu, kn꞉aa pini knî ye y꞉ee ngópu. Yepê, Yi yéli y꞉oo Njósép u mbwó knî ye pwila ngópu, Yichip ńuw꞉o ngópu, pi ngmê ngê ye pwila ngê, yi pini p꞉uu wop doon꞉aa dpodo. ");
INSERT INTO yle_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Yepê, Ngmênê Chóó Lémi ngê Njósép y꞉i doo a ngêêpî, k꞉omo tpile dono kópu yilî u ngwo pyodo, ngmênê Chóó Lémi ngê yi dono chedê too. Yepê, Chóó Lémi ngê Njósép u nuw꞉o ndîî ngê pyódu ngê, Yichip tpémi yi king Pééló ka pi mb꞉aa ngê pyódu ngê, wod꞉oo Pééló ngê Njósép u che p꞉ââ pee ngê pyódu ngê. ");
INSERT INTO yle_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","12","Yepê, Yi dini ghi ngê Chóó Lémi ngê Njósép myedê ngópu, u lama kwólu, kwo, Mu dini ghi ngê kââdî ndîî angmê kee, Yichip tpémi Kenan tpémi yi nté wa chedê. Yepê, Yi kópu u l꞉êê dîy꞉o Njósép ngê witi a danê ngê, king u ngomo knî yi k꞉oo doo a ghada. Yepê, Dini ghi n꞉ii ngê kââdî ndîî kee wo, Yichip tpémi Kenan tpémi yi nté chedê ngê, yi yéli y꞉oo dómudómu a pyw꞉ee ngópu. Yepê, Doo u ntââ nmî kn꞉ââ knî y꞉oo nté daapêdê pyw꞉ee ngópu, ngmênê Yichip tpémi y꞉oo Njósép ka witi dnyimon꞉aa pywupwi. Yepê, Njósép u mî Njakóp ngê yi kópu dini ghi n꞉ii ngê nyongo, tp꞉oo yoo Yichip dy꞉ââ too, Njósép ka dnyen꞉aa witi pywupwi, ngmênê daa mya ngópu, yi lama dêpwo ya, Kî nmî mbwó. Yepê, U kuwó dini ghi ngê Kenan mê diyé dniye. ");
INSERT INTO yle_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Yepê, Witi dini ghi n꞉ii ngê kmaapî ngê mî chedê ngópu, yi mî ngê Yichip mê dy꞉ââ too. Yepê, Yi dini ghi ngê Njósép ngê u mbwó knî ye yepê, A mbwó yoo, ala nê. Stipen ngê yepê, Yi ngwo Pééló u lama yaa wo, apê, Njósép u mî mupwoknî Kenan wunê dómudómu té. ");
INSERT INTO yle_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","15","Yepê, Wod꞉oo Njósép ngê u mbwó knî ye yepê, M꞉aa nya yó, nmyi kpâm gheegheema mye nya tóó, al꞉ii a pwiyé dmyeno. Yepê, Wod꞉oo Njakóp mupwoknî káámi knî ń꞉eemi knî Yichip lee dniye, yintómu pyudu y꞉a mê limi. Dye ghi daadîî y꞉i dnyen꞉aa ya, y꞉i myemî pw꞉oo dniye. ");
INSERT INTO yle_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yepê, Njakóp mupwo Njósép yi ntóó dê Sekem mî kmênê dumo, Epîlaham kwéli kmênê ngópu. Yepê, Wunê yi têpê ghi Epîlaham ngê Hamó u yoo knî ye pwila ngê. ");
INSERT INTO yle_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Stipen ngê kada pini knî ye yepê, Nmî kn꞉ââ yoo m꞉ââ yilî Yichip dnya a ya, yilî ngê y꞉i a pyodo. Yepê, U kuwó dini ghi ngê Chóó Lémi ngê apê, Epîlaham ka wunê kópuni nê vyu, yi kópu daa kêmakêma n꞉aa d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yepê, Yi dini ghi ngê kn꞉aa king m꞉uu yaa wo, yi king u lama Njósép u pi dêpwo ya. ");
INSERT INTO yle_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yepê, Yi king ngê nmî kn꞉ââ yoo wop dpodo kalê too, yi dpodo têdê myednye kpakakpaka dé. Yepê, U kuwó dini ghi ngê Yichip tpémi y꞉oo nmî kn꞉ââ yoo yi tp꞉ee mââ tpómuni dnyimo vyee dé, pye paa dnyimo kéké dé. ");
INSERT INTO yle_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Yepê, Yi dini ghi ngê Mósisi mye ta, k꞉uuchêm u tp꞉ee, d꞉ââ pyile u pye ngê ngomo k꞉oo doo w꞉êêw꞉êê. ");
INSERT INTO yle_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Yepê, U kuwó dini ghi ngê Pééló tp꞉oo módó ngê yinê a nmyââ, chóó tp꞉oo ngê pyódu ngê. ");
INSERT INTO yle_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yepê, Yichip tpémi y꞉oo yi chóó yi kópu yilî Mósisi u lama kalê ngópu, mââwe ndîî ngê pyodo, u nuw꞉o ndîî ngê mye pyodo, kópu ndîî yilî dpîmo d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Yepê, Dini ghi n꞉ii ngê Mósisi u m꞉ââ podo y꞉a ngê doo ya, apê, A yoo Yisîléli tpémi ngîn꞉uu m꞉uu té. ");
INSERT INTO yle_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yepê, Ye y꞉i n꞉ee, apê, Yi dpodo têdê Yichip pi ngmê ngê Yisîléli pi ngmêmî vyee. Yepê, Wod꞉oo Mósisi ngê Yisîléli pi ngópu, ntââ Yichip pi ngê a vy꞉ungo, u nkwo vyâ. ");
INSERT INTO yle_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Yepê, Mósisi ngê u gha vy꞉o apê, Yisîléli tpémi y꞉oo wa a w꞉ee ngmê, Chóó Lémi ngê wa ngee nê, Yichip u mênê wanî pw꞉ii té, ngmênê Yisîléli tpémi y꞉oo dêpê w꞉ee ngópu, Kî nmî dyédyé pyu. ");
INSERT INTO yle_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yepê, Womumu Mósisi ngê Yisîléli pi miyó módu, apê, Mu l꞉êê mo. Apê, Nî dyé dê, nê kââdî dê. Yepê, Wod꞉oo Mósisi ngê yepê, Kî tpódu, dpî mbwémi, lukwe dîy꞉o dpo l꞉êê mo? ");
INSERT INTO yle_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Yepê, Ngmênê n꞉ii ngê woni doo vyee, Mósisi dny꞉ii dyîngo, kwo, N꞉uu ngê nmî kada pini ngê pyódu nyoo, nanê ṉga vyu, Anyi kóté kîgha nmo? ");
INSERT INTO yle_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kwo, Ma Yichip pi ntee nyi vy꞉a, lukwe yinté am꞉ii vya nê? ");
INSERT INTO yle_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Yepê, Yi kópu Mósisi ngê dini ghi n꞉ii ngê nyongo, Yichip tpémi ye nkîngê mbê wo, wod꞉oo mbêpê wo, Yichip Wee a kuwo ngê, Midiyên Wee u kwo loo, y꞉i mî yéé wo, tp꞉ee y꞉i miyó mî tpyó. ");
INSERT INTO yle_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Yepê, M꞉ââ podo y꞉a mî loo, u kuwó dini ghi ngê Mósisi ka enjel ngmê ta. Yepê, Mósisi ngê daa pi ntee tpile yi módu, ngmênê yi vyu wo, apê, Yi tp꞉oo ndê ngê ngmêmî pîpî, ngmênê chedê ngê daa pyodopyodo. Yepê, Pi kwéli dêpwo ya, mbu ndîî vyuwo Sainay, Mósisi ngê yi yini tp꞉oo p꞉uu ndê y꞉i mî módu. ");
INSERT INTO yle_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Yepê, Mósisi ngê yi kópu yi módu, apê, E! Kî lónté tpile? Apê, Ngîn꞉uu m꞉uu, wod꞉oo u nkîgh꞉ê chono loo. ");
INSERT INTO yle_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Yepê, Nmî Lémi ndîî y꞉i u kwo a mbwolo, kwo, Nî ṉg꞉ââ knî yi yâpwo, Epîlaham u yâpwo, tp꞉oo Yisak mupwo Njakóp yi yâpwo. Yepê, Mósisi nkîngê mbê wo, u yi u ngwo dêpwo kwo, Yi ghi m꞉aa m꞉uu. ");
INSERT INTO yle_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yepê, Nmî Lémi ndîî ngê kwo, Ṉyi dupó dê a ngee dé, mu kópu u dîy꞉o yâpwo ghê nye kwo. ");
INSERT INTO yle_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kwo, Ndêndê ngê kîdî m꞉uu, a yoo Yichip dnyinté mînê kwo, kwo, Yichip tpémi y꞉oo dpodo têdê a kpakakpaka t꞉oo. Kwo, A ka dê ch꞉anê dmi, até d꞉a ghîî, dîn꞉aa ngee té. Kwo, Yichip n꞉aa dyede ngi. ");
INSERT INTO yle_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stipen ngê yepê, K꞉omo tpile Chóó Lémi ngê Mósisi a ngmidi ngê, ngmênê Yisîléli tpémi y꞉oo u wépi pwaa ngópu. Yepê, Ala kópu u kwo vyi ngópu, kwo, N꞉uu ngê ṉga vyu, nmî kada pini ngê anyi ya, anyi kóté kîgha nmo? Yepê, Yi pini Chóó Lémi ngê a ngmidi ngê, yi kada pini ngê pyódu ngê, yi mbwámê ngê mye pyódu ngê. Yepê, Daa chóó kada pini ngê pyodo, ngmênê yi yini tp꞉oo p꞉uu enjel n꞉ii módu, yi enjel ngê kada pini ngê yinê pyódu ngê. ");
INSERT INTO yle_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yepê, Mósisi ngê nmî kn꞉ââ yoo Yichip u mênê yinê a pw꞉ii too, mbwudu y꞉i yilî a chópu, Ntii Mtyemtye u nkîgh꞉ê mbwudu m꞉uu a chópu. Yepê, Maa p꞉uu nko mênê mbwudu mê yilî a chópu, m꞉ââ podo y꞉a k꞉oo. ");
INSERT INTO yle_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yepê, Yi Mósisi ngê Yisîléli tpémi ye yepê, Chóó Lémi ngê nê ntee pini nmyi vy꞉o m꞉uu wa a pyw꞉oo, nmye wa a dy꞉ââ, komo yinê amaan꞉aa kapî. ");
INSERT INTO yle_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yepê, Dini ghi n꞉ii ngê nmî kn꞉ââ yoo Sainay mbu ndîî vyuwo dnyen꞉aa kwo, enjel mbu mbêmê u kwo doo a mbumu, yi Mósisi yi kêlî vyîlo yedoo kwo. Yepê, Yi Mósisi ngê Chóó Lémi u kópu dyuu nmo yinê a ńuwo, yi kópu dyuu chedê ngê daawa pyódu. ");
INSERT INTO yle_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Yepê, K꞉omo tpile Mósisi ngê yi kópu yilî d꞉uu ngê, ngmênê nmî kn꞉ââ yoo u kwo daa ng꞉aa mbê dniye, mye mb꞉ii ngópu, u yi y꞉e doo kwo, Yichip moo diyé dmi. ");
INSERT INTO yle_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yepê, Wod꞉oo pi knî y꞉oo Mósisi u mbwó Alon ka kwo, Yâpwo knî ngmê l꞉âmo ngi. Kwo, Yi yâpwo knî nmî kada vyîlo ayi ghê dmi, Yichip y꞉oo amê diyédiyé kalê nmo. Kwo, Nmî lama daa tóó, Mósisi ngê lukwe angmê pyódu, pini n꞉ii ngê Yichip u mênê a pw꞉ii nmoo. ");
INSERT INTO yle_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yepê, Wod꞉oo k꞉omo yâpwo ngmê l꞉âmo ngópu, pudumakó tp꞉oo mââ ntee tpile yi l꞉âmo ngópu. Tpileni yi chóó l꞉âmo ngópu, u kwo dnye kpêê yiyé, u naa mye kê ngópu. ");
INSERT INTO yle_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yepê, Yi dini ghi ngê k꞉omo yâpwo ka ngêpê kn꞉ââ u ngwo a chaa ngópu, m꞉ââ wono yono y꞉a mî loo, u kuwó dini ghi ngê king Manasa u dye ghi ngê yi kópu ndîî ngê yimî pyodo, wod꞉oo Chóó Lémi ngê yi dyaa mbâlâ dyuu yi pwo kéé ngê, pudu knî ye dnyimo ngêpê, yi tp꞉ee dnyimo vyee dé, pudu knî ye kpêê ngê dnyimo yiyé dé. Yepê, Yi kópu u l꞉êê dîy꞉o pi ngmê ngê Chóó Lémi u komo u ngwo kââ, ala kópu d꞉êê ngê, apê, Yisîléli tpémi. Dini ghi n꞉ii ngê nmyi kn꞉ââ yoo w꞉amî mbêmê u ngwo dnya a paa, m꞉ââ podo y꞉a, na a ka daa a ka dnyimo a tpile tp꞉oo nk꞉êênî. ");
INSERT INTO yle_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Apê, Na a ka daa a wónu ngomo yidnyimo a dnyinêdnyinê, ngmênê yi chóó yi k꞉omo yâpwo Molokî u wónu ngomo yidnyimo a dnyinêdnyinê, puduni u pi Lepanî u kwo myednyimo ngêpê. Apê, Na a ka yi chóó tpileni l꞉âmo tumo, yi tpile knî ye dnye ngêpê. Apê, Nmyo yinté yéli, yi kópu u l꞉êê dîy꞉o Mbápilon mwada pee wanî dy꞉ââ nmyo. ");
INSERT INTO yle_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stipen ngê yepê, Dini ghi n꞉ii ngê nmî kn꞉ââ yoo w꞉amî mbêmê dnya a paa, Chóó Lémi u wónu ngomo ngmê l꞉âmo ngópu. Yepê, Chóó Lémi ngê Mósisi u lama ntee kwólu, yinté l꞉âmo ngópu. Yepê, Yi lama doo ya, Chóó Lémi yi wónu ngomo u mênê a kwo. Yepê, Ghi ngmê dini ghi n꞉ii ngê dnyimo a kuwokuwo, yi wónu ngomo dnyimo a kmongokmongo, dnyimo dnyinêdnyinê, kwéli dnyimon꞉aa taataa, wónu ngomo y꞉i dnyimon꞉aa wuwó. ");
INSERT INTO yle_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yepê, Yi yéli dini ghi n꞉ii ngê pw꞉oo dniye, yi tp꞉ee knî y꞉oo Chóó Lémi u wónu ngomo Kenan u nkîgh꞉ê y꞉oo mî t꞉aa ngópu. Yepê, Yi dini ghi ngê Mósisi pwene, Njósuwa ngê u d꞉aa yinê a kââdî ngê, yi yéli yi kada ghê wo, Kenan ńuw꞉o too. Yepê, Chóó Lémi ngê Kenan tpémi ngm꞉ii kalê too, Yisîléli tpémi y꞉oo yi têpê ghi yi kêlê a pwaa tumo. Yepê, Chóó Lémi u wónu ngomo Kenan ńuw꞉o ngópu, y꞉i mî wó ngópu, y꞉i doo kwo, dye ghi daadîî, king Dépidi u dye ghi ngê y꞉i myedoo kwo. ");
INSERT INTO yle_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Yepê, Dépidi Chóó Lémi u nuu u pi ngê pyodo, Chóó Lémi ka kwo, Nmî Lémi, Njakóp u yâpwo, u ntââ ngomo mb꞉aa ngmanî wó, y꞉i anyi kwo. ");
INSERT INTO yle_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yepê, Ngmênê Dépidi ngê Chóó Lémi u ngomo daa wó, tp꞉oo Solomon ngê yinê mî wó. ");
INSERT INTO yle_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yepê, K꞉omo tpile Solomon ngê Chóó Lémi u ngomo wó, ngmênê Chóó Lémi pââ ndîî, dyámê mbêmê ngomo ngmê k꞉oo daawa a vyil꞉a. Yepê, Wunê pi ngmê ngê Chóó Lémi u komo alanté a kââ, apê, ");
INSERT INTO yle_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nmyinê nmye dyámê pê ndîî, na a ka têdê. Apê, A ntââ ngomo lónté ngmanmyi wó ngmê, y꞉i anê vyil꞉a? ");
INSERT INTO yle_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Apê, Kî tpile yilî yintómu a chóó nî l꞉âmo ngê, ló tpile a l꞉êê dîy꞉o ngmanmyi l꞉âmo ngmê? ");
INSERT INTO yle_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stipen ngê yepê, Nmyo nkéli wépi dnyangê pyu yoo. Yepê, Dye ghi yintómu Chóó Lémi nmye mb꞉iimb꞉ii ngópu, u kópu dyuu dp꞉ee nyêmî ngópu. Yepê, Nmyi kn꞉ââ knî y꞉oo Chóó Lémi u Ghê Dmi wépi ntee dnyimo a pwapî, yinté u wépi my꞉ee pwapî ngmê. ");
INSERT INTO yle_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yepê, Pini n꞉ii knî y꞉oo Chóó Lémi u komo dnyimo a kapî, nmyi kn꞉ââ knî y꞉oo daa ngmê châpu ngópu, ngmênê dono kópu yilî y꞉e dnyimo a d꞉uud꞉uu. Yepê, Wunê pini n꞉ii yoo Chóó Lémi u Dpodo Pyu Mb꞉aa p꞉uu dnyimo a danê, n꞉ii knî y꞉oo pi knî ye yipu, Dîyo Chóó Lémi ngê yi pini nmo wa a dy꞉ââ, yepê, yi yéli nmyi kn꞉ââ knî y꞉oo a vya tumo. Yepê, Mwolo yi pini kwódo ngê munmyi ghê dniye, my꞉ee vya ngópu. ");
INSERT INTO yle_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yepê, K꞉omo tpile enjel knî y꞉oo nmî kn꞉ââ knî ye Chóó Lémi u dêêpî kópu dyuu a y꞉ee tumo, nmyi ny꞉ee tumo, ngmênê mêdp꞉ee chââchââ tumo. ");
INSERT INTO yle_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nju tpémi yi kada pini knî y꞉oo yi kópu dini ghi n꞉ii ngê ny꞉ee tumo, yi kópu ngê dyênê too, yi kpéngi ti dmi kelekele dnye paa. ");
INSERT INTO yle_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","56","Ngmênê Chóó Lémi u Ghê Dmi ngê Stipen a nt꞉ee ngê, mbóó p꞉uu vyu wo, Chóó Lémi u wuu ndîî módu, pi knî ye yepê, Mbóó kêdê kpêmî, Yesu Chóó Lémi u nkîgh꞉ê ka kwo, u che p꞉ââ pee ngê dê pyódu. ");
INSERT INTO yle_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Wod꞉oo noko dpodombiy꞉e mbó dniye, noko yepê, Kî pini ngê Chóó Lémi u pi ndîî kn꞉aa pini ka lukwe dîy꞉o dê ńuw꞉o? Noko yepê, Kî pini ka namê ng꞉aa, wod꞉oo yi ngópu nkoko tumo, u kwo tpé dniye, mgîmî ngópu, p꞉aa pee ńuw꞉o ngópu, a ngî ngópu, dny꞉ii d꞉ii ngópu, mwada y꞉i mî danê ngópu, wod꞉oo chêêpî ngê yidnye vyee. Yélini y꞉oo Stipen chêêpî ngê dnye vyee, yi yéli y꞉oo yi nkuwo kpîdî a ngee tumo, pi lvulu ngmê ka y꞉ee tumo, ye doo vyuwo. Yi pini u pi Sóól. ");
INSERT INTO yle_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","U dî daa pwaa ngópu, Stipen chêêpî ngê mudnye vyee, wod꞉oo Stipen doo ngêpê, apê, Yesu a Lémi, a ghê dmi a ngépi. ");
INSERT INTO yle_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yu mbodo dê y꞉e ghê wo, dpodombiy꞉e ka wo, Yesu ka kwo, A Lémi, kópu dononi a nga ka d꞉uud꞉uu ngmê, yi kópu m̱odo kn꞉ââ vyuwo dpî yé té, kidangmê ngî. Yi kópu dyuu dini ghi n꞉ii ngê vyu, wod꞉oo pwene. Pi knî y꞉oo Stipen dini ghi n꞉ii ngê vya ngópu, Sóól u nuu u kópu ngê mye pyodo. ");
INSERT INTO yle_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Yélini y꞉oo Chóó Lémi mb꞉aamb꞉aa ngê dnyimo chââchââ, yi yéli y꞉oo Stipen ntóó kmênê ngópu, u l꞉êê dîy꞉o myednye mbê. Yi wéni ngê Nju tpémi y꞉oo Yesu u yoo yi kpadakpada kn꞉ââ chaa ngópu, Njedusalem. Yesu u yoo yintómu knî y꞉oo Njedusalem a kuwo ngópu, p꞉aani p꞉aani lee dniye, woni Njuda Wee u kwo p꞉aani p꞉aani lee dniye, woni Samédiya Wee u kwo p꞉aani p꞉aani lee dniye, ngmênê dyépi knî y꞉oo Njedusalem dêpê kuwo ngópu. ");
INSERT INTO yle_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sóól ngê u yi dpîmo kwo, Yesu u yoo nî chedê, wod꞉oo ngomo k꞉oo ngomo k꞉oo dpîmon꞉aa koko, Yesu u yoo dpîmon꞉aa mgîmîmgîmî dé, pyââ pyââ mââ mââ mbwa k꞉oo dpîmon꞉aa kmîmî dé. ");
INSERT INTO yle_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesu u yoo yéli n꞉ii mbêpê wo, yi yéli p꞉aani p꞉aani lee dniye, pi knî ye Yesu u kópu mb꞉aa dnyen꞉aa tpapê. ");
INSERT INTO yle_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pini n꞉ii pyudu knî mwiyé a pyw꞉ee tumo, ndapî yêêpî u kada pini ngê a pyódu tumo, yi vy꞉o pini ngmê u pi Pilipi. Yi pini ngê Njedusalem a kuwo ngê, Samédiya loo, pi knî ye yepê, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, yi pini wunê kî ta, ngmênê nmî kada pini knî y꞉oo daa mya ngópu, kî vya ngópu, myombó Chóó Lémi ngê kîmêdê pyidu ngê. Yepê, Yi pini u pi Yesu. ");
INSERT INTO yle_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Samédiya tpémi Pilipi ka mb꞉aamb꞉aa ngê ng꞉aa mbê dniye, mu kópu u dîy꞉o Pilipi ngê yi ngópu mbwudu yilî dpîmo chap. ");
INSERT INTO yle_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pi yilî yi kmêna Pilipi ngê ngm꞉ii kalê too, wod꞉oo yi kmêna yoo dpodombiy꞉e u ngwo dnye kââ. Myenté kóó ntóó kpâlî ntóó yilî mye pyi ngê, yélini dnyinté dnyimo paa, mye pyi too. ");
INSERT INTO yle_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yi kópu u l꞉êê dîy꞉o Samédiya tpémi yi gha dmi mb꞉aamb꞉aa ngê pyodo. ");
INSERT INTO yle_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Yi p꞉aani pi ngmêdoo ya, u pi Saimon, pipi kópu knî yi mbêmê kópu ndîî yilî dpîmo d꞉uud꞉uu, Samédiya tpémi yinté dpîmo liya kîgha dé. Pi knî ye yipu, Nê pi ngmê. ");
INSERT INTO yle_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tp꞉ee vy꞉o, dmââdî vy꞉o, lémi vy꞉o, ch꞉am vy꞉o apu, Vyuw! Apu, Kî pini nmînê nmo Chóó Lémi ntee pini, u wêdêwêdê ndîî. Wod꞉oo yoo yintómu u kwo dnyimo ng꞉aa. ");
INSERT INTO yle_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nyââ, dye ghi daadîî kópu ndîî yilî dpîmo d꞉uud꞉uu, yi kópu u l꞉êê dîy꞉o yoo u ngwo dnyimo liya, u kwo mb꞉aamb꞉aa ngê myednyimo ng꞉aa. ");
INSERT INTO yle_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pilipi Yesu Kédisu p꞉uu ye dpîmo danêmbum, Chóó Lémi kóó k꞉oo wowo p꞉uu ye myedpîmo danêmbum. Dini ghi n꞉ii ngê ny꞉ee ngópu, yi kópu dyuu ka kêlîmî mbê dniye, wod꞉oo Pilipi ngê pyââ pyââ mââ mââ mbwaa paa kmênê too, Yesu u yoo vy꞉o kaa too. ");
INSERT INTO yle_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon myenté mye kêlîmî mbê wo, Pilipi ngê mbwaa paa mye kmênê ngê, wod꞉oo Saimon Pilipi p꞉uu kele. Dini ghi n꞉ii ngê Pilipi ngê mbwudu dpîmo chapî dé, Saimon ngê yidpîmo mumu dé, u ngwo mêdpîmo liya. ");
INSERT INTO yle_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Dini ghi n꞉ii ngê Yesu u dyépi knî y꞉oo yi kópu Njedusalem a ny꞉ee ngópu, apê, Samédiya tpémi Chóó Lémi u kópu dyuu ka kêdê kêlîmî mbê dmi, wod꞉oo Pita pini dê Njon Samédiya dy꞉ââ dumo. ");
INSERT INTO yle_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Dini ghi n꞉ii ngê taa knopwo, a w꞉ee ngópu, apê, K꞉omo tpile Pilipi ngê kî yéli Yesu u pi ngê mbwaa paa kmênê too, ngmênê Chóó Lémi ngê u Ghê Dmi ye doongê y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Wod꞉oo Pita Njon y꞉oo kêê yi mbêmê dpîmo yiyé dé, yi l꞉êê dîy꞉o dpîmo ngêpê, Chóó Lémi ngê u Ghê Dmi u ngwo ye dpîmo yém. ");
INSERT INTO yle_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Dini ghi n꞉ii ngê Saimon ngê yi kópu módu, apê, Dini ghi n꞉ii ngê Pita Njon y꞉oo kêê nmî mbêmê dê yé ngmê, apê, Chóó Lémi ngê u Ghê Dmi u ngwo nmo da kê. ");
INSERT INTO yle_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Wod꞉oo Saimon ngê Pita pini dê Njon ye ndapî kêlê ngmê yó, apê, Ye nî y꞉oo. Yepê, U ntââ u ntââ ngê u nkwo wadpî pyódu nê, pini n꞉ii mbêmê a kêê dê anî yé dê, yi pini ka Chóó Lémi ngê u Ghê Dmi ada a yém. ");
INSERT INTO yle_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ngmênê Pita ngê kwo, Ṉapî ṉgópu choo ya, kumu chi tpyé, ndiya u ngwo nyi ghidi, mu kópu u dîy꞉o ṉga vy꞉o chi vyi, Chóó Lémi u módó yeedeyeede ndapî ngê nî pwila. ");
INSERT INTO yle_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kwo, Doo u ntââ ala dpodo p꞉uu daanyi ngee nyo, mu kópu u dîy꞉o Chóó Lémi u lama a tóó, ṉga daa ntênê a tóó. ");
INSERT INTO yle_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kwo, Yi dono kópu ndîî a kuwo ngi, nmî Lémi ndîî ka chi ngêpê, u kwo dpî vyi ngi, kwipi, A Lémi, dono kópuni dî d꞉uu, u ntââ ṉguwó wanyi kéé, yi kópu mêdaanyi nuw꞉onuw꞉o. ");
INSERT INTO yle_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwo, Ṉga kîdî m꞉uu, ye ń꞉ee nye yichi kââ, doo u ntââ dono u wépi daanyi puwâ. ");
INSERT INTO yle_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon ngê yepê, U ntââ a l꞉êê dîy꞉o amêdpî ngêpê, kópuni a ka dpî vyi t꞉oo, yi kópu a nga kîngmê pyódu. ");
INSERT INTO yle_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita Njon y꞉oo Yesu p꞉uu kópuni m꞉uu tumo, Samédiya tpémi ye yi kópu mî vyi tumo, u kuwó dini ghi ngê Njedusalem mê diyé knopwo. Maa p꞉uu Samédiya Wee u kwo p꞉aa yilî a kêlî ngópu, Yesu p꞉uu kópu mb꞉aa pi knî ye dpîmo tpapê, yed꞉oo Njedusalem mîmî taa knopwo. ");
INSERT INTO yle_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Enjel ngmê ngê nmî Lémi u kópu Pilipi ka a ńuwo, kwo, Gh꞉êêdé, kwo, chi lêpî, Njedusalem Nkaasa yi kêlî máádi dpî kwéli. (Yi wee u kwo pi daa tóó, kpî yi mye daa kwo, mbwaa mye doo u p꞉aa.) ");
INSERT INTO yle_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Wod꞉oo Pilipi ghêêdî wo, kada a y꞉ângo. Yi máádi p꞉uu pi ngmê módu, Njedusalem a ndê wo, Nkaasa doo lêpî. Yi pini mââwe ndîî ngmê, Yitiyópiya tpémi yi ch꞉am ndîî p꞉uu dpîmo dpodo, u ndapî yinê dpîmo y꞉enê. Yi pini Chóó Lémi ka ngêpê têdê a ndê wo, Njedusalem, u p꞉o modoo diyédiyé. U chádiyót mbêmê doo ya, hósi dê y꞉oo dpîmo a paapaa, kópuni Yisaya ngê d꞉êê ngê, yi pini ngê maadî doo a kpââ. ");
INSERT INTO yle_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Chóó Lémi u Ghê Dmi ngê Pilipi ka kwo, Kî pini u nkîgh꞉ê máádi nyi kwéli. ");
INSERT INTO yle_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Wod꞉oo Pilipi mbêpêmbêpê loo, u nkîgh꞉ê máádi mî kwólu, apê, Chóó Lémi u kópuni Yisaya ngê a d꞉êê ngê, apê, muyedê kpââ, wod꞉oo u kwo adî póó, kwo, Kópuni nyinê kpââ, kwo, cha w꞉ee? ");
INSERT INTO yle_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yi pini ngê kwo, Lónté wanê w꞉ee? U kakêmê nanê a ka wa chámê? Kwo, A pwiyé, a chádiyót k꞉oo a kee, a nkîgh꞉ê anyi yey, u kakêmê a ka anyi chámê ngi. Wod꞉oo Pilipi yi chádiyót k꞉oo kee wo. ");
INSERT INTO yle_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kópuni yi pini ngê doo a kpââ, ala yi kópu. Sipi u vyee têdê ntee d꞉uudpî ghete tóp, u vyii têdê myed꞉uudpî kââ, yi pini ngê yinté kópu daangmê vyu. ");
INSERT INTO yle_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pi knî y꞉oo yi pini p꞉uu yipe tee u kópu yilî t꞉ee ngópu, yi kópu u l꞉êê dîy꞉o kpaka ngópu, mye nkwiti ngópu. Tp꞉oo knî yi p꞉uu pi ngê kópu d꞉uudpî vyi, mu kópu u dîy꞉o dyámê mbêmê u ya machedê ngê dê pyódu. ");
INSERT INTO yle_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yitiyópiya pi Pilipi ka póó wo, kwo, Chóó Lémi u komo kapî pyu ló pini p꞉uu doo a danêmbum? Kwo, Chóó p꞉uu doo a danêmbum ó kn꞉aa pini p꞉uu doo a danêmbum? ");
INSERT INTO yle_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pilipi ngê ala kópu a w꞉ee ngê, apê, Chóó Lémi u komo kapî pyu Yesu p꞉uu doo a danêmbum, wod꞉oo Pilipi ngê danêmbum kn꞉ââ Yitiyópiya pi ka adî chaa, Yesu u kópu mb꞉aa u ngwo u kwo vyu. ");
INSERT INTO yle_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","U kuwó dini ghi ngê maa p꞉uu mbwaa ngmê m꞉uu ngópu, wod꞉oo Yitiyópiya pi ngê Pilipi ka kwo, Óó. Kwo, Mbwaa ngmêka t꞉a. Kwo, U ntââ Yesu u pi ngê yi mbwááni paa wanyi kmênê nê? ");
INSERT INTO yle_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(-) ");
INSERT INTO yle_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wod꞉oo chádiyót u tpiipi ka kwo, U dî y꞉i pwáádi, wod꞉oo u dî y꞉i adî puwâ. Pilipi k꞉ii mbwaa paa nipi ghêpê knopwo, Pilipi ngê yi pini y꞉i mî kmênê ngê. ");
INSERT INTO yle_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mbwaa paa dini ghi n꞉ii ngê a kee knopwo, Chóó Lémi u Ghê Dmi ngê Pilipi a y꞉ângo, Yitiyópiya pi ngê Pilipi mêdaa módu, ngmênê u gha mb꞉aamb꞉aa ngê pyodo, chádiyót k꞉oo mê wo wo, wod꞉oo kada mêdê y꞉ângo. ");
INSERT INTO yle_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipi Asîdót mî ta, u kuwó dini ghi ngê p꞉aani p꞉aani doo lêpî, Yesu u kópu mb꞉aa pi knî ye doon꞉aa tpapê, u kuwó dini ghi ngê Sisadiya mî ta. ");
INSERT INTO yle_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Dini ghi n꞉ii ngê yi kópu dnye pyodopyodo, Sóól ngê u yi dpîmo kwo, Yesu u yoo nmî vya té, yi vyee u pi pi knî ye dpodombiy꞉e dpîmo tpapê. ");
INSERT INTO yle_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","U yi u ngwo myedoo kwo, Dîmaskîs nî lê, yélini Yesu u maa p꞉uu a m꞉ii, yi yéli n꞉uu mgîmî té, pyââ mââ yoo yi kpadakpada têdê Njedusalem mênê diyédiyé kalê té. Yi kópu u l꞉êê dîy꞉o kpêê yiyé pyu yoo yi kada pini ka loo, yi kópu u kwo mî vyu, kwo, Nju tpémi yélini a kwo, Dîmaskîs, u ntââ yi kada pini knî ye wanyi dy꞉ââ nê, a kakêmê ye am꞉ii chámê, u ngwo ye n꞉aa lêpî. Kwo, Kópu dyuu ngmê d꞉êê ngi, ye n꞉aa ńeńe. Wod꞉oo Sóól ngê pi knî ngmê ńuwo, Njedusalem a kuwo ngópu, Dîmaskîs dnye lêpî. ");
INSERT INTO yle_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Daa kêmakêma Dîmaskîs dnye taataa, tpile u wuu ndîî mbóó p꞉uu yi pwo ngma a kwólu. ");
INSERT INTO yle_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sóól ngê yi tpile u wuu ndîî dini ghi n꞉ii ngê módu, wod꞉oo têpê mbêmê dyimê wo, dnye ngmê nyongo, kwo, Sóól, Sóól. Kwo, Lukwe dîy꞉o dono kópu ndîî yilî a nga nye d꞉uud꞉uu? ");
INSERT INTO yle_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sóól ngê kwo, A Lémi. Kwo, Nyi n꞉uu? Nmî Lémi ngê kwo, Nê Yesu, pini n꞉ii ngê dono kópu ndîî yilî nye d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kwo, A pyidu, kwo, Dîmaskîs chi lêpî. Kwo, Kópuni u ya a nga a kwo, y꞉i ṉga an꞉uu vyi, dîyo yi kópu anyin꞉aa d꞉uud꞉uu. ");
INSERT INTO yle_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pini n꞉ii knî y꞉oo Sóól dnye yâmuyâmu, mbóó p꞉uu dnye dini ghi n꞉ii ngê ny꞉ee ngópu, yi paa u dî dmi puwâ, noko kópu daa vyi ngópu, myenté pi myedaa m꞉uu ngópu. ");
INSERT INTO yle_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sóól têpê mbêmê yeda pii wo, ngwolo dê yi pywálî doo, ngmênê yélî daa módu, wod꞉oo kwulo kaa dniye, Dîmaskîs ńuw꞉o ngópu. ");
INSERT INTO yle_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Wo pyile knî yi k꞉oo yélî dêpwo y꞉enê, tpéé kópu yi ngwo mî vyu, nté mbwaa chóó u kwo kwódu doo, Chóó Lémi ka doo ngêpê, kwo, U ntââ a dono yilî ṉguwó wanyi kéé. ");
INSERT INTO yle_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yesu u yoo vy꞉o pi ngmê Dîmaskîs doo ya, u pi Ananayas. Yi pini ngê nmî Lémi módu, kwo, Ananayas. Ananayas ngê kwo, A Lémi, ala nê. ");
INSERT INTO yle_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nmî Lémi ngê kwo, Ala p꞉aani ghi a kuwo ngi, máádini u pi Kpêêlî Ghi Daa Tóó, yi máádi dp꞉uu kwéli, yi máádi p꞉uu Njudas u ngomo a kwo. Kwo, Yi ngomo k꞉oo pi ngma a tóó, u pi Sóól, Taasîs pi. Kwo, Yi pini ye dpî poo ngi. ");
INSERT INTO yle_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kwo, Yi pini wunê ngêpê, kwo, u nuw꞉o k꞉oo kêdê m꞉uu ngi, kwo, ala kópu dê vyi, Pi ngmê wunê pwiyé knî, u pi Ananayas, kóó dê a mbêmê wumê yiyé dê, yed꞉oo yélî mb꞉aamb꞉aa ngê mênê mumu. ");
INSERT INTO yle_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananayas ngê kwo, A Lémi. Kwo, Pi yilî knî y꞉oo ye pini u pi a ka ka tpapê ngmê, ṉyoo knî y꞉e kópu dono yilî doo d꞉uud꞉uu, Njedusalem. ");
INSERT INTO yle_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kwo, Kpêê yiyé pyu yoo yi kada pini knî y꞉oo ala kópu u kwo a vyi ngópu, Dîmaskîs chi lêpî, Yesu u yoo nyinê mgîmî tóó. ");
INSERT INTO yle_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nmî Lémi ngê kwo, Chi lêpî, mu kópu u dîy꞉o yi Sóól d꞉a ngmidi, a p꞉uu pîchoo dpodo, Yisîléli tpémi ye, king knî ye, myenté kn꞉aa yéli ye a pi yi lama myepaan꞉aa kalê ngê. ");
INSERT INTO yle_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kwo, Dono kópu yilîni pi knî y꞉oo a l꞉êê dîy꞉o u ngwo wadnyi d꞉uud꞉uu dé, a chóó u kwo wanê kêma té. ");
INSERT INTO yle_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Wod꞉oo Ananayas ngê Sóól yi ngomo k꞉oo a pyw꞉ângo, kóó dê mbêmê yé doo, kwo, Sóól a mbwó. Kwo, Nmî Lémi ngê até dê dy꞉ââ nê, amêma pini n꞉ii nyinê módu, yi pini Yesu, chóó ṉga até dê dy꞉ââ nê. Kwo, Ala p꞉eeni kópu u dîy꞉o até dê dy꞉ââ nê, yélî m꞉ee mumu, Chóó Lémi u Ghê Dmi ngê wunê nt꞉eent꞉ee ngi. ");
INSERT INTO yle_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Te too pee ntee tpile dê Sóól ngîma yi ngwo a ghay knopwo, wod꞉oo yélî mê módu. Yi ghêêdî wo, wod꞉oo Yesu u pi ngê mbwaa paa kmênê ngópu. ");
INSERT INTO yle_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","U kuwó dini ghi ngê nté yi ndîî, u wêdêwêdê u kwo mêdê diyé wo. ");
INSERT INTO yle_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Yesu u yoo yélini Dîmaskîs dnye ya, Sóól ngê wo knî ngmê yi vy꞉o chedê ngê, wod꞉oo Nju tpémi yi ngêpê ngomo knî yi k꞉oo dpîmon꞉aa koko, ye dpîmon꞉aa danêmbum, yipu, Yesu ndêndê ngê Chóó Lémi tp꞉oo. ");
INSERT INTO yle_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","N꞉ii knî y꞉oo yi kópu ny꞉ee ngópu, ghê dmi yi mênê ghipé wo, noko yepê, Pini n꞉ii ngê Yesu u yoo doo vyee dé, Njedusalem, mumdoo kî vyîlo? Apê, Mumdoo al꞉ii a loo, mu kópu u dîy꞉o u yi u ngwo doo kwo, Yesu u yoo n꞉uu mgîmî té, kpêê yiyé pyu knî yi kada pini knî ye n꞉uu y꞉ee té, Njedusalem? Apê, Lukwe dîy꞉o Yesu u pee ngê maa ghê? ");
INSERT INTO yle_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ngmênê Sóól ngê pi knî yi pwo mînê dyîngo. Kópuni Chóó Lémi u komo kapî pyu knî y꞉oo a d꞉êê tumo, Sóól ngê pi knî yi ngópu u nkwo dpîmo a kpââ dé, yipu, Ala kópu yilî Yesu ngê ndêndê ngê ntiye ngê. Yipu, Yi kópu u l꞉êê dîy꞉o, Pini n꞉ii Chóó Lémi ngê a ngmidi ngê, yi pini Yesu. Yi kópu Sóól ngê wêdêwêdê ngê ye dpîmo tpapê dé, Nju tpémini Dîmaskîs dnye ya, doo u ntââ Sóól u dnye daapî vya ngópu. ");
INSERT INTO yle_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wo yilî mî loo, u kuwó dini ghi ngê Nju tpémi nipi a wó, noko yepê, Sóól paa vya koo, ngmênê Sóól ngê yi kópu u tuu kââ pee ngmê nyongo. ");
INSERT INTO yle_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nju tpémi y꞉oo noko yepê, Sóól kîngê mbêpê, Dîmaskîs kîdangê kuwo. Yi kópu u l꞉êê dîy꞉o yi p꞉aani mbwa keńe w꞉êênî dnyimo t꞉âât꞉ââ, mgîdî vy꞉o myednyimo t꞉âât꞉ââ. U yi y꞉e doo kwo, Sóól nmî vy꞉a. ");
INSERT INTO yle_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ngmênê mgîdî ngmê ngê Sóól p꞉uu ndiye pyu knî y꞉oo Sóól a ngî ngópu, kpéni ndîî k꞉oo ché ngópu, yi kpéni kpê t꞉ee ngópu, yi p꞉aani mbwa mbêmê l꞉uu ngópu, kuwa kalê ngópu. P꞉uu ndiye pyu knî yedê kpê p꞉uu dnya a ya, yi yedê ngê kpéni dnye ghîpîghîpî, Sóól k꞉oo doo kwo, dini ghi n꞉ii ngê mbwódo mî ghê wo, wod꞉oo Sóól mbêpê wo. ");
INSERT INTO yle_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Dini ghi n꞉ii ngê Sóól Njedusalem mî ta, u yi u ngwo doo kwo, Yesu u yoo yi p꞉uu n꞉uu kaalî, ngmênê u kwo daa kêlîmî mbê dniye, apê, Ngmênê daa Yesu u yoo vy꞉o pini ngmê. Yintómu u kwo nkîngê mbê dniye. ");
INSERT INTO yle_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ngmênê pi ngmê u kwo daa nkîngê mbê wo, u pi Mbanapas. Mbanapas ngê Yesu u dyépi knî yi vy꞉o yinê ńuwo, yepê, Dini ghi n꞉ii ngê Sóól Dîmaskîs doo lêpî, nmî Lémi maa p꞉uu módu, Sóól ka y꞉i a mbwolo. Yepê, Sóól Dîmaskîs Yesu u pi ngê dpodombiy꞉e doo dêêpî, myedaa nkîngê mbê wo. ");
INSERT INTO yle_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Wod꞉oo Sóól Njedusalem doo ya, p꞉aani pee p꞉aani pee dpîmon꞉aa dêêpî, Yesu u pi ngê dpodombiy꞉e doon꞉aa dêêpî, myedaa nkîngê mbê wo. ");
INSERT INTO yle_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nju tpémini Kîdiki dnye ngê dnyimo mbumu, Sóól ye dpîmon꞉aa dêêpî, Sóól u k꞉ii noko myednyimon꞉aa kwopwepe, ngmênê u yi y꞉e doo kwo, Sóól nmî vy꞉a. ");
INSERT INTO yle_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Yesu u yoo knî y꞉oo yi kópu dini ghi n꞉ii ngê ny꞉ee ngópu, Sóól Sisadiya ńuw꞉o ngópu, u p꞉aa njini Taasîs mî dy꞉ââ ngópu. ");
INSERT INTO yle_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","U kuwó dini ghi ngê Yesu u yoo mb꞉aamb꞉aa ngê dnye ya, pi ngê kópu dono y꞉e daa d꞉uu ngê. Ala wee pyile knî yi kwo dnye ya, Njuda Wee ngmê, Nkálili Wee myomo, Samédiya Wee pyolo. Chóó Lémi u Ghê Dmi ngê doo a ngêêpî dé, pi yilî Yesu ka kêlîmî mbê dniye, u yoo yilî ngê u ngwo doo pyodopyodo. Nmî Lémi mb꞉aamb꞉aa ngê dnyimo chââchââ. ");
INSERT INTO yle_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Dye ghi yintómu Pita p꞉aani p꞉aani dpîmo lêpî, Yesu u yoo dpîmon꞉aa mumu dé. Wo ngmê ngê Lida u nkwo até yi loo. ");
INSERT INTO yle_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yi p꞉aani pi ngmêdoo ya, u pi Aniyês. Yi pini yu dê ntóó dê, paa doo u ntââ ngê u kwo dpîmo ya. M꞉ââ wááli ngmîtédmi mbêmê dpîmo ya. ");
INSERT INTO yle_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita ngê kwo, Aniyês. Kwo, Yesu Kédisu ngê ala ngwo dê pyi ngi, ṉgmîtédmi mbêmê a pyidu, ṉgmîtédmi a kmongo ngi. Wod꞉oo Aniyês ada pyidu. ");
INSERT INTO yle_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Yi wee ndîî u kwo yélini dnye kwo, Aniyês paa têdê dini ghi n꞉ii ngê m꞉uu ngópu, yi yéli nmî Lémi ka u ngwo mêdê diyé dniye. ");
INSERT INTO yle_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Njopa Yesu u yoo vy꞉o pyââ ngmêdoo kwo, u pi Tapîta. (Kîdiki dnye ngê u pi Dókîs.) Dye ghi yintómu yi pyópu ngê kópu mb꞉aa yilî dpîmo d꞉uud꞉uu, pinté knî y꞉e. ");
INSERT INTO yle_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Yi dini ghi ngê mbii u ngwo ngmê kele, yed꞉oo mye pwene. Ntóó ghêê ngópu, a ngî ngópu, ngomo k꞉oo yé ngópu. ");
INSERT INTO yle_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yesu u yoo n꞉ii Njopa doo kwo, yi lama doo ya, Pita chono a tóó, Lida, wod꞉oo pi miyó dê ye yepê, Lida choo lêpî, Pita lîmî k꞉ii ngê dpo pwiyé we. ");
INSERT INTO yle_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Wod꞉oo Pita ka lee knopwo, yi pini dê yi p꞉uu a kele, Njopa lee dniye. Dini ghi n꞉ii ngê taa dniye, yi pyópu ntóó ngomoni k꞉oo doo ya, Pita y꞉i km꞉êê ngópu. Kuknwe knî y꞉oo a yina ngópu, dnye mbê. Yi pyópu ngê kpîdîni dmya too, ye y꞉ee too, yi kpîdî Pita u ngópu dnye tpyuu dé. ");
INSERT INTO yle_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita ngê yi ngomo ghi k꞉oo pi yintómu pw꞉ii ngê, yu mbodo dê y꞉oo ghê wo, wod꞉oo doo ngêpê. Yi pyópu ntóó ka diyé wo, kwo, Tapîta, a pyidu. Wod꞉oo ngwolo dê pywálî doo, Pita yi módu, wod꞉oo ntênê yaa wo. ");
INSERT INTO yle_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Wod꞉oo Pita ngê yi pyópu ka kóó dp꞉ee ngê, kwulo kele, ghêêmî kââ. U kuwó dini ghi ngê Pita Yesu u yoo knî ye mbwolo, kuknwe knî ye mye mbwolo, yepê, A pwiyé dmyeno, ala pyópu ghê até maa kaalî. ");
INSERT INTO yle_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Njopa tpémi ye yi kópu u mdoo yi ńuw꞉o ngópu, pi yilî nmî Lémi ka kêlîmî mbê wo. ");
INSERT INTO yle_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita Njopa doo ya, wo yilî. Pini n꞉ii u ngomo k꞉oo doo kwo, yi pini u pi Saimon, tpile tp꞉oo too pee l꞉âmol꞉âmo pyu. ");
INSERT INTO yle_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Lóma lede Sisadiya yilî doo ya. Yi kada pini knî yi vy꞉o pi ngmêdoo kwo, u pi Kóniliyês. Lede yoo n꞉ii yi vy꞉o Kóniliyês doo kwo, yi yéli yi pi dmi Yitali lede yoo. ");
INSERT INTO yle_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","K꞉omo tpile Kóniliyês daa Nju pi, ngmênê Chóó Lémi ka mb꞉aamb꞉aa ngê dpîmo kêlîmî, dye ghi yintómu u kwo dpîmo ngêpê. Yi pini u kpâm ghee knî, u dpodo pyu yoo Chóó Lémi ka mb꞉aamb꞉aa ngê myednyimo ng꞉aa. Nju tpémi yi vy꞉o pinté yoo yilîni dnyimo kwo, Kóniliyês ngê dpîmo a wopwe dé. ");
INSERT INTO yle_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kóniliyês ngê Nju tpémi yi l꞉êê ghi dmi dpîmo d꞉uud꞉uu dé, kââdî dini ghi n꞉ii ngê t꞉ono dpîmo wowo, Chóó Lémi ka u ngwo dpîmo ngêpê. Wo ngmê ngê u ngêpê têdê enjel ngmê módu, kwo, Kóniliyês. ");
INSERT INTO yle_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kóniliyês ngê enjel dini ghi n꞉ii ngê módu, nkîngê mbê wo, enjel doo y꞉enê, kwo, A lémi, lukwe pyinê ché ngmêê? Enjel ngê kwo, Chóó Lémi ngê ṉgêpê kêdê ny꞉oo, mu kópu u dîy꞉o pinté yoo nyinê wopwe too. Kwo, Ala ngwo u nkwo wunê ngêêpî ngi. ");
INSERT INTO yle_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kwo, Ala ngwo pi knî ngmê dy꞉ââ ngi, Njopa, pi ngmê nya y꞉e, u pi Saimon Pita. ");
INSERT INTO yle_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kwo, Yi pini ntii chedê a tóó, ngomoni k꞉oo a kwo, yi ngomo chóó u pi mye Saimon, tpile tp꞉oo too pee l꞉âmol꞉âmo pyu. ");
INSERT INTO yle_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Enjel ngê Kóniliyês ka danêmbum dini ghi n꞉ii ngê a kêlî ngê, wod꞉oo y꞉aa wo. Kóniliyês u dpodo pyu miyó dê ye adî mbwólu, u lede ngmê ka mya adî mbwólu, yepê, Nga a pwiyé dmyeno. Yi lede Kóniliyês u t꞉âât꞉ââ pyu ngmê, Chóó Lémi ka mb꞉aamb꞉aa ngê myedpîmo kêlîmî. ");
INSERT INTO yle_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kóniliyês ngê kópuni pyodo, yi kópu yi ngêêdî ada nt꞉o, wod꞉oo adî dy꞉ââ té, Njopa. ");
INSERT INTO yle_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Womumo kââdî mââ kêlê, dini ghi n꞉ii ngê Njopa u nkîgh꞉ê dnyen꞉aa paa, Pita yi chêêpî ngomo pywápê ngmê pwono kee wo, y꞉i doon꞉aa ngêpê. ");
INSERT INTO yle_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dómu ndîî u ngwo ngmê kele, u yi u ngwo doo kwo, Nté pee ngmênî ma. ");
INSERT INTO yle_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Dini ghi n꞉ii ngê nté dnye ch꞉eech꞉ee, Pita yi vyu wo, apê, Mbóó ada kpêmî, apê, wónu k꞉ii ntee tpile yélî vyââ yi kêlî ngmêyedê ghêpê knî, kwódo páádi. ");
INSERT INTO yle_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yi wónu k꞉ii ntee tpile k꞉oo tpile tp꞉oo knî ngmêdoo kwo, dyêêdî daa ngmidi, tpile pê dé, pyaa dé, ńmê dé yi tpile k꞉oo myednye kwo. Yi tpile Pita ka p꞉ââp꞉ââ doo a wupwo. Yi tpile tp꞉oo dyêêdî yintómu Nju tpémi ye tupwótupwó dé, Nju tpémi y꞉oo dêdnyimo pîpî dé. ");
INSERT INTO yle_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pita ngê mbóó p꞉uu dnye ngmê nyongo, kwo, Gh꞉êêdé, kî tpile tp꞉oo ngmê vyee, ma ngi. ");
INSERT INTO yle_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ngmênê Pita ngê kwo, A Lémi, kî tpile tp꞉oo dyêêdî yintómu kwódu yé u tpile tp꞉oo dé, nmînê nmo tupwótupwó dé, doo u ntââ daa ngma anî ma. Kwo, Yinté tpile tp꞉oo tupwótupwó d꞉oongmê ndîî. ");
INSERT INTO yle_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pita ngê myombó yi dnyeni mê nyongo, kwo, Chóó Lémi ngê tpileni p꞉uu ala kópu dê vyi, Kî tpile mb꞉aamb꞉aa, kwo, yi tpile p꞉uu ṉ́yóó kidingê vyi, Yi tpile tupwótupwó. ");
INSERT INTO yle_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yi ntini u wépi Pita ngê pyolo puwâ, yi kópu dyuu mu ngmidi pyolo nyongo, wod꞉oo yi wónu k꞉ii ntee tpile mbóó p꞉uu mê kee wo. ");
INSERT INTO yle_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","18","Pita ngê kópuni módu, yi kópu doo nuw꞉onuw꞉o, u nt꞉u kópu dêpêngê pyw꞉ângo, wod꞉oo pini n꞉ii pyile knî Kóniliyês ngê dy꞉ââ too, Saimon u ngomo pi knî y꞉oo ye adê kêma ngmê, wod꞉oo keńe t꞉âmo dnyen꞉aa kwo, yi ngomo chóó ka adî mbwó dmi, kwo, Pi al꞉ii ngma kwo, u pi Saimon Pita? ");
INSERT INTO yle_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita ngê kópuni módu, u yi u ngwo doo kwo, U nt꞉u kópu nê pyw꞉oo, wod꞉oo Chóó Lémi u Ghê Dmi ngê kwo, Pita. Kwo, Pi pyile knî y꞉oo ka nmy꞉uu ngi. ");
INSERT INTO yle_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kwo, Ghidi, kidimê nuw꞉o kîgha nédinuw꞉o, nyi ngm꞉êê té, mu kópu u dîy꞉o a chóó nê dy꞉ââ té. ");
INSERT INTO yle_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Wod꞉oo Pita adî ghîî, yepê, Pini ka nmye vyuwo té, ala nê. Yepê, Lukwe u pyinê dmyinê ngmêê ngmê? ");
INSERT INTO yle_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kwo, Nmî kada pini Kóniliyês ngê yinê a dy꞉ââ nmo. Kwo, Yi pini pi mb꞉aa ngmê, k꞉omo tpile daa Nju pi, ngmênê Chóó Lémi mb꞉aamb꞉aa ngê a chââchââ. Kwo, Nju tpémi yi nuu u pi ngê a tóó. Kwo, Chóó Lémi u enjel ngmê ngê ala kópu u kwo vyi, kwopê, Saimon Pita ṉgomo k꞉oo dpo pwiyé we, ṉga adîn꞉aa danêmbum. ");
INSERT INTO yle_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita ngê kópuni yélî vyââ yi kêlî módu, yi kópu yi nuw꞉o kwólu, wod꞉oo ala kópu daa vyu, Kî pini pyile knî daa Nju pi dé, nmî ngomo k꞉oo kêdangê kee dmi. Yi kópu daa vyu, ngmênê yi pini pyile knî ngomo k꞉oo adî km꞉êê té, yi k꞉ii dpî dniye. Womumo mw꞉aandiye Pita ngê Kóniliyês u dpodo pyu pyile knî adî ngm꞉êê té, Yesu u yoo Njopa yélini doo kwo, yi yéli woni knî yi k꞉ii mye lee dniye. ");
INSERT INTO yle_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Maa p꞉uu dpî dniye, womumo Sisadiya mî taa dniye. Kóniliyês u yoo knî yi k꞉ii yi yéli dnye t꞉âât꞉ââ dé. ");
INSERT INTO yle_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita dini ghi n꞉ii ngê Kóniliyês u ngomo k꞉oo doo koko, Kóniliyês ngê yi módu, yu mbodo dê y꞉e k꞉ame u kwo ghê wo. ");
INSERT INTO yle_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ngmênê Pita ngê ghêêmî mê kââ, kwo, Ghêêmî ghé. Kwo, D꞉aa enjel ntee pini. Kwo, Nê dyámê mbêmê pi. ");
INSERT INTO yle_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita Kóniliyês ka modoo danêmbum, ngomo k꞉oo u ngwo mî kee knopwo, pi yilî y꞉i m꞉uu ngópu. ");
INSERT INTO yle_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita ngê yepê, Nmyi lama ka tóó, Nju pi ngmê kn꞉aa pini u ngomo k꞉oo d꞉uudpî kee, kópu y꞉e myed꞉uudpî d꞉uu, ngmênê Chóó Lémi ngê yi kópu a ka a kwódu ngê, doo u ntââ pi p꞉uu daanî vyi, kî pini tupwótupwó. ");
INSERT INTO yle_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yepê, Yi kópu u l꞉êê dîy꞉o dini ghi n꞉ii ngê nmyinê nya noo, até dâ lê, kópu dîpîngmê vyu. Yepê, Lukwe dîy꞉o nmyinê nya noo? ");
INSERT INTO yle_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kóniliyês ngê kwo, Pyile tuwo alanté dini ghi ngê, dini ghi n꞉ii ngê kââdî t꞉ono ghê wo, a ngomo k꞉oo kînoo ngêpê, pi ngmê até y꞉ii módu, u kpîdî dnye wu mbele, a kada mî ghê wo. ");
INSERT INTO yle_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yi pini ngê a ka pê, Kóniliyês, Chóó Lémi ngê ṉgêpê kîyedê nyêm, tpileni yilî pinté knî ye nye yémî, yi tpile yilî chóó Lémi u nuw꞉o k꞉oo kîyedê pyede. ");
INSERT INTO yle_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","A ka pê, Pi Njopa ngmê dy꞉ââ ngi, pi ngmêdpo pwiyé we, u pi Saimon Pita. A ka pê, Yi pini ntii chedê a tóó, pini n꞉ii u ngomo k꞉oo a kwo, yi pini u pi mye Saimon, tpile tp꞉oo too pee l꞉âmol꞉âmo pyu. ");
INSERT INTO yle_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kóniliyês ngê kwo, Yed꞉oo pi pyile ṉga kînî dy꞉ââ ngê, u ngwo cha lê. Kwo, Awêde al꞉ii até dp꞉o wó, Chóó Lémi u ngîma, kwo, anmî t꞉âât꞉ââ ngi, nmî Lémi ngê kópuni ṉga dê vyi, yi kópu nmo ngmê vyi. ");
INSERT INTO yle_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita ngê danêmbum kn꞉ââ dini ghi n꞉ii ngê chópu, yepê, Ndêndê ngê kîd꞉a w꞉ee, yoo daa ngmidi Chóó Lémi ngê ada a ngêêpî. ");
INSERT INTO yle_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yepê, Pini n꞉ii ngê Chóó Lémi adî chââchââ, kópu mb꞉aa u ngwo adî d꞉uud꞉uu dé, yepê, k꞉omo tpile yi pini daa Nju pi, ngmênê Chóó Lémi ngê wa ngee, u yoo vy꞉o wa kââ. ");
INSERT INTO yle_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yepê, Ala kópu dyuu nmyi lama a kwo, Chóó Lémi ngê kópu mb꞉aa nmo ngma a dy꞉ââ ngê, Yisîléli tpémi yi k꞉ii, nmopê, Yesu Kédisu ngê a ka yinê wa a kââdî nmyo. Yepê, Yi pini Yesu Chóó Lémi ngê nmo yintómu nmî kada kââ. ");
INSERT INTO yle_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yepê, Nkálili wee u kwo, Njuda wee u kwo, kópu ndîî n꞉ii dnye pyodopyodo, yi kópu nmyi lama ka pyede. Yepê, Dini ghi n꞉ii ngê Njon doo a dêêpî, yoo mumyedoo a mbápitisîm kîgha dé, yi dini ghi ngê yi kópu ndîî kn꞉ââ u ngwo a chópu. ");
INSERT INTO yle_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yepê, Yesu Nasalet pi u danêmbum nmyi lama a tóó, Chóó Lémi ngê u Ghê Dmi u mênê u ngwo a yó, u wêdêwêdê ndîî ngê u ngwo pyódu ngê. Yepê, Yi pini p꞉aani p꞉aani dpîmon꞉aa paa, kópu mb꞉aa yilî dpîmon꞉aa d꞉uud꞉uu, pini n꞉ii yoo Setan ngê dyênê too, Yesu ngê mê pyi too, mu kópu u dîy꞉o Chóó Lémi ngê doo a ngêêpî. ");
INSERT INTO yle_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yepê, Yesu ngê Nju tpémi yi vy꞉o kópuni doo d꞉uud꞉uu dé, yi kópu yilî nmî chóó nmî ngwolo ngê nmî módu. ");
INSERT INTO yle_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Yepê, Nju tpémi y꞉oo Yesu vya ngópu, kîdosi ńedê t꞉ee ngópu, ngmênê Chóó Lémi ngê wo pyoloni ngê mêdê pyidu ngê, chóóchóó nmî ngópu mê tpyó. ");
INSERT INTO yle_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Yepê, Dini ghi n꞉ii ngê a pii wo, daa pi yintómu knî y꞉oo m꞉uu ngópu, ngmênê yélini yi k꞉ii nmee yâmuyâmu, Yesu nmî chóó nmî módu. Yepê, Chóó Lémi ngê yi kópu u l꞉êê dîy꞉o mwiyé a ngmidi nmoo. Yepê, Dini ghi n꞉ii ngê a pii wo, u kuwó dini ghi ngê u k꞉ii nmee kmaapî, u k꞉ii nmee mbwaa ndanî. ");
INSERT INTO yle_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yepê, Mu dini ghi ngê yinê wa kóté k