﻿USE sofia;
DROP TABLE IF EXISTS sofia.yka_vpl;
CREATE TABLE yka_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yka_vpl WRITE;
INSERT INTO yka_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Masa ewwal pe, masa gaˈ pe niyaˈ sultan si lahat Israˈel, niyaˈ unus dem lahat miyaˈan. Dembuwaˈ lella amban puweblo Betlehem laˈi si Yahudiya pī dahuˈ hap lahat Moˈab patennaˈ laˈi. Magtuhut duk andane duk duwe anakne lella. ");
INSERT INTO yka_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ēn lellahin Elimelek duk ēn andanen Naˈomi, ēn anakden si Mahlon duk Kilyon. Tubuˈ si Eprata siye amban puweblo Betlehem laˈi si Yahudiya. Pī siye hap lahat Moˈab duk petennaˈ laˈi. ");
INSERT INTO yka_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Manjari pag laˈi siye matey Elimelek ella Naˈomihin, duk taˈamban iye duk duwe anakne lellahin. ");
INSERT INTO yka_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Bu maganda isab siye si dende amban lahat Moˈab miyaˈan, ēn dembuwaˈin si Orpa duk dembuwaˈin si Rut. Pag laˈi siye patennaˈ meˈ sempūˈ tahun ");
INSERT INTO yka_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","matey isab disi Mahlon duk si Kilyon. Ubus luwal Naˈomi matelebbihin, gaˈ ne niyaˈ ellane duk anakne. ");
INSERT INTO yka_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Pag takalene laˈi si Moˈab weˈ tinabangan teˈed weˈ Tuhanin meˈ aˈa Yahudiyahin duk manjari ne teˈed tinanemden, magmemes Naˈomi moleˈ balik magtuhut duk meˈ eyuˈannen. ");
INSERT INTO yka_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Tahalaˈ iye amban lahat bakas patennaˈanden duk harap pī ne siye duk meˈ eyuˈannen tudju lahat Yahudiya. ");
INSERT INTO yka_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Pag laˈi siye si lān paˈin Naˈomi si meˈ eyuˈannen, “Moleˈ kaˈam balik pī hap lumaˈ inaˈbin. Karayaw tumbasan Tuhanin du kēmon hinanganbi mahāp bakas hininangbi si akuhin duk si meˈ ellabi ley. ");
INSERT INTO yka_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Duk karayaw ellahan pe kaˈam balik duk ngasuwaˈ kaˈam kasanyanganbi si lumaˈ ellabin.” Ubus inūkan siye weˈ Naˈomi. Saguwaˈ magtāring siye. ");
INSERT INTO yka_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Duk paˈinde si iye, “Nuhut kami kaˈu pī si lahatnu.” ");
INSERT INTO yka_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Nambung Naˈomi paˈinne, “Balik ne kaˈam meˈ anakku. Weˈey kaˈam mabayaˈ nuhut aku? Paˈinbi ke weˈ nganak pe ku balik duk niyaˈ hinangbi ella? ");
INSERT INTO yka_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Hap lumaˈ ne kaˈam, dende. Bahiˈ ne ku, gey ne ku ellahan. Bisan ku upama ellahan ninaˈ duk anakan, ");
INSERT INTO yka_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","agadbi pe ke siye samantaˈan gey siye hadje? Gey kaˈam magella seddili? Gey makajari, meˈ anakku. Takite ne si meˈ ilabeyankun weˈ pinahunitan ku weˈ Tuhanin duk maˈaseˈ ku si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Nāring siye balik. Ubus inūkan weˈ si Orpa metoˈanen duk moleˈ ne iye balik. Saguwaˈ si Rut gaˈi mabayaˈ tahalaˈ amban metoˈanen. ");
INSERT INTO yka_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Paˈin Naˈomi si iye, “Bilasnun moleˈ ne balik pī si usbanen duk si tuhan-tuhan bakas sinambahayangnen. Pī ne kew nuhut iye.” ");
INSERT INTO yka_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Saguwaˈ nambung si Rut paˈinne, “Daˈa ku sasaˈanun. Nuhut ku kaˈu. Tungan-tungan papīhannu, nuhut ku. Intag-intag palaˈihannu iye isab palaˈihankun. Meˈ usbanun, iye isab meˈ usbakun. Duk Tuhannun iye isab Tuhankun. ");
INSERT INTO yka_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Intag-intag kamateyannun, iye isab kamateyankun. Duk iye du isab pangubulan akuhin. Ambat ku pinagmulkaˈan weˈ Tuhanin bang ku pasapeˈ amban kaˈu seddili amban kamatey.” ");
INSERT INTO yka_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Pag kataˈuhan Naˈomi weˈ gaˈ si Rut magduwe-duwe manuhut iyehin, gaˈ ne iye kebbutan. ");
INSERT INTO yka_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Palanjal ne siye tudju Betlehem. Pag tekka siye laˈi, hiyul meˈ aˈa si puweblo miyaˈan. Duk paˈin meˈ dendehin, “Naˈomi ne hatiˈ!” ");
INSERT INTO yka_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Nambung iye paˈinne, “Daˈa ku ēnanun bi Naˈomi. Ēnanun bi ku si Mara. Peggeˈ Tuhan Mabalakatanin inurungan ku weˈ ne kasigpitan. ");
INSERT INTO yka_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Patahalaˈku mabittuˈuhin, kumpeleto ku. Sakayiˈ ku pinapitu balik weˈ Tuhanin, gaˈ niyaˈ ine-ine. Daˈa ne ku ēnanun bi Naˈomi peggeˈ inurungan kasusehan ku weˈ Tuhanin, pinatekkahan balaˈ ku weˈ Mabalakatanin.” ");
INSERT INTO yka_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Manjari sā miyaˈan Naˈomi tabalik magtuhut duk si Rut, eyuˈannen dende amban lahat Moˈab. Tekka siye si Betlehem beytu nagnaˈ pagpagani barley. ");
INSERT INTO yka_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Manjari, niyaˈ dembuwaˈ usba Naˈomi inēnan si Boˈas. Sugaˈ magusba siye sabab ellane ley si Elimelek. Bu si Boˈas inin dayahan duk pinagaddatan weˈ aˈa. ");
INSERT INTO yka_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Dembuwaˈ ellew maˈid si Rut pu si Naˈomi, “Tiyaˈ ku pī si tanaˈ nimuk mataˈamban weˈ meˈ magpaganihin. Kaw niyaˈ aˈa maˈaseˈ si aku bu daˈakne ku nimuk.” Paˈin Naˈomi, “Aweˈ, Anak, pī ne kew.” ");
INSERT INTO yka_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ubus, pī ne iye si tanaˈ nimuk meˈ taˈamban weˈ meˈ magpaganihin. Katapīhannen si tanaˈ si Boˈas, usba Elimelek. ");
INSERT INTO yka_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ubus, pagtiggel-tiggel ne tekka si Boˈas amban Betlehem laˈi si tanaˈne. Saginane aˈanen paˈinne, “Karayaw ipat Tuhanin kaˈam.” Nambung isab siye, paˈinde, “Karayaw iledjikiˈan kew weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Ubus tilew si Boˈas kapatas magpaganihin, paˈinne, “Sine dende mabataˈ miyaˈan?” ");
INSERT INTO yka_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Nambung kapatasin, “Dende bangsa Moˈabin, iye miyaˈan manuhut Naˈomi amban lahat Moˈabin. ");
INSERT INTO yka_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Maˈid iye bang makajari iye nimuk meˈ mataˈamban weˈ meˈ magpaganihin. Ubus pitu iye si tanaˈ bu gaˈ iye pahali kemuwe salung. Īˈ iye si payad behu pahali du.” ");
INSERT INTO yka_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Ubus paˈin si Boˈas pu si Rut, “Pakale kew, Dende, daˈa kew pī si tanaˈ seddili nimuk. Tuˈu kew hadja nimuk tapit si meˈ bataˈanku dendehin. ");
INSERT INTO yka_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Payamanun bang intag pagpaganihanden duk paturul kew si siye. Gaˈi daˈakku meˈ lellahin nasew kaˈu. Bu sumiyan-sumiyan kew batang nginum, pī kew hadja nginum boheˈ dem poga bakas inindukan weˈ meˈ lellahin.” ");
INSERT INTO yka_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ubus pasujud si Rut duk paˈinne pu si Boˈas, “Weˈey hāp addatnun duk maˈaseˈ kew si aku duk asipnu ku bu aˈa liyu-liyu du ku?” ");
INSERT INTO yka_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Nambung si Boˈas paˈinne, “Kēmon bakas tahinangnu si metoˈanun kemuwe matey ellanu ley taˈaka si aku. Inakahan ku isab weˈ ambanannu saˈi-samanun duk dī lahatnun duk pitu kew patennaˈ si bangsa gaˈ bakas kataˈuhannu. ");
INSERT INTO yka_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Karayaw tumbasan Tuhanin kew sabab tahinangnun, duk karayaw pinahalaˈan kew teˈed weˈ Tuhanin, iye Tuhan bangsa Israˈelin. Tapitu kew si Tuhan mataˈu mangelligan kaˈuhin.” ");
INSERT INTO yka_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Nambung si Rut, paˈinne, “Hāp teˈed addatnun si aku, Tuwan. Hāp ateykun peggeˈ hāp bissānu si akuhin bisan ku diyawaˈ amban meˈ daraˈakannun.” ");
INSERT INTO yka_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Pag sōng mangan siye paˈin si Boˈas pu si Rut, “Dayiˈ kew mangan. Ngeddoˈ kew pan, tottokanun dem binagri.” Ubus ningkoloˈ ne iye duk meˈ daraˈakannen duk urungan si Boˈas iye bēbbed barley. Mangan iye samantaˈan gaˈ iye esso, duk niyaˈ pe lebbine. ");
INSERT INTO yka_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Pag pī si Rut balik nimuk, paˈin si Boˈas si meˈ aˈanen, “Ambat ne iye nimuk bisan si ellet meˈ umpung bu daˈa iye amāhanun bi. ");
INSERT INTO yka_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Onotanun bi iye amban meˈ umpungbi duk ambananun bi. Bang timukne, daˈa iye pagesun bi.” ");
INSERT INTO yka_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Manjari nimuk barley si Rut sampay kohap. Ubus diˈikanne kēmon bakas tinimuknen bu niyaˈ kulang-labi sempukduwe kilu buwaˈ barley. ");
INSERT INTO yka_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Boˈone kēmon buwaˈ barley miyaˈan pī hap puweblo bu pakitehanne metoˈanen. Ginuwaˈan isab weˈ ne lukasnen duk pangurungne iye. ");
INSERT INTO yka_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Tinilew iye weˈ metoˈanen, paˈinne, “Intag timuknu kēmon inin ellew inin? Tanaˈ sine papīhannun? Karayaw inurungan kahāpan aˈa mamaˈaseˈ si kaˈuhin!” Ubus magaka si Rut weˈ bakas maghinang iye si dembuwaˈ tanaˈ depuˈnen inēnan si Boˈas. ");
INSERT INTO yka_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ubus paˈin Naˈomi si eyuˈannen, “Karayaw iledjikiˈan iye weˈ Tuhanin. Bang Tuhanin, gaˈ iye pareheng magpakite aseˈnen si kite maˈellumin duk si mamateyin.” Ubus tambahanne pe, paˈinne, “Lella iyan pingged pe pagusbahanten duk iye. Iye dembuwaˈ meˈ aˈa magkuwiraw nabangan kite. ");
INSERT INTO yka_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ubus paˈin si Rut, “Bu paˈinne pe isab si aku, ‘Patapit kew hadja si meˈ daraˈakankun samantaˈan gaˈi ubus paganihin.’” ");
INSERT INTO yka_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Nambung Naˈomi, paˈinne, “Aweˈ, Anak, hāp pe bang kew nuhut meˈ daraˈakanne dendehin, peggeˈ bang kew pī si tanaˈ seddili kaw niyaˈ hinangde laˈat si kaˈu.” ");
INSERT INTO yka_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Hangkan si Rut nimuk patapit si meˈ daraˈakan si Boˈas dendehin ngeregseˈ ubus pagani barley duk buwaˈ tiriguhin. Bu patennaˈannen laˈi si metoˈanen. ");
INSERT INTO yka_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Dembuwaˈ ellew paˈin si Naˈomi pu si Rut, eyuˈannen, “Subey ne kew paˈellahanku duk ne kew maglumaˈan dīnu. ");
INSERT INTO yka_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Na, bakas kew maghinang nuhut meˈ daraˈakan si Boˈas bu kataˈuhannu hep weˈ usbate iye. Pakale kew, ninaˈ magpalid barley iye laˈi si pagdiˈikan. ");
INSERT INTO yka_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Hangkan mandi kew bu nu magbengngi-bengngi bu asekun semmeknu mahāpin. Ubus padurul kew pī si pagdiˈikan; saguwaˈ daˈa kew pakite si iye samantaˈan gaˈi pe iye ubus mangan duk nginum. ");
INSERT INTO yka_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Bang pabāk ne iye payamanun duk esseb-essebun bang intag. Ubus pī kew, lukahun mantane si bettisnen, duk pabāk kew laˈi. Ubus bugtuˈ akahanne kew bang ine subey hinangnu.” ");
INSERT INTO yka_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Paˈin si Rut, “Hinangku saˈ kēmon pinaˈinnun.” ");
INSERT INTO yka_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Hangkan padurul iye hap pagdiˈikan duk hinangne kēmon dinaˈak weˈ metoˈanen. ");
INSERT INTO yka_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Pag ubus si Boˈas mangan duk nginum duk sinna diyalem ateynen pī iye pabāk si bihing tumpuk barley tuli. Kamaya-maya si Rut hap pī, lukane mantane si bettisnen duk pabāk iye laˈi. ");
INSERT INTO yka_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Pag nengaˈ bahangi ne, takeddut si Boˈas. Pag ngape iye niyaˈ hatiˈ dende pabāk si bettisne! ");
INSERT INTO yka_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","“Sine kew,” paˈinne. Nambung iye, paˈinne, “Si Rut ku, Tuwan. Peggeˈ kaˈu usba kami magkuwiraw nabangan kami hinangun ku anda.” ");
INSERT INTO yka_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Paˈin si Boˈas, “Karayaw iledjikiˈan kew weˈ Tuhanin, Dende. Hāp boˈohannun si metoˈanun bu mās hāp ne kuweˈitu boˈohannun si aku usbanun peggeˈ dumaˈin pinihanun lella bataˈ, miskin ke atawa dayahan. ");
INSERT INTO yka_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Na, daˈa kew suse, Dende. Tuhutku saˈ kēmon kinabayaˈannun. Kataˈuhan du weˈ kēmon aˈa dem puweblohin weˈ kaˈu dende hāp addatnen. ");
INSERT INTO yka_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Saguwaˈ bisan toˈo weˈ pingged pagusbahan kamihin duk metoˈanu lellaley, niyaˈ pe dembuwaˈ lella pesōng pingged amban aku. ");
INSERT INTO yka_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Tuˈu ne kew hadja tiggelan gaˈi pe dantaˈ. Sumu salung payamante saˈ bang ngatu aˈa miyaˈan magkuwiraw ngipat kaˈu. Bang ngatu iye, na hāp; iye ne iyan. Saguwaˈ bang gaˈi iye ngatu - napa ne ku kuweˈitu bu pakale Tuhanin - aku ne iye. Pabāk ne kew hadja tuˈu sampay sumu salung.” ");
INSERT INTO yka_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ubus pabāk si Rut laˈi si antag bettisnen sampay subu-subu. Saguwaˈ dongaˈ iye lindem pe supaya gaˈi iye takilale. Peggeˈ paˈin si Boˈas weˈ gaˈ niyaˈ subey ngataˈuhanne weˈ niyaˈ dende bakas laˈi si pagdiˈikan. ");
INSERT INTO yka_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Paˈin si Boˈas, “Pituhun olosnun duk bellatun.” Ubus isihanne ennem takesan barley duk tinabangan iye weˈ ne pinapī diyataˈ bahane. Ubus pī iye balik hap puweblo. ");
INSERT INTO yka_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Pag tekka si Rut si palaˈihan metoˈanen tinilew iye weˈ Naˈomi, paˈinne, “Saˈingge du kaˈam, Anak?” Ubus inakahan iye kēmon weˈ si Rut bang ine hinang si Boˈas si iyehin. ");
INSERT INTO yka_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ubus paˈinne pe, “Urunganne ku meˈ ennem takesan barley inin peggeˈ gaˈi koˈ makajari weˈ moleˈ ku pitu bu gaˈ niyaˈ taboˈoku.” ");
INSERT INTO yka_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Paˈin Naˈomi, “Daˈa kew sasew, Anak, tiggelan gaˈi pe kataˈuhannu kaˈujudannen. Aˈa iyan gaˈi pahali samantaˈan gaˈi haregla palkalaˈin ellew inin.” ");
INSERT INTO yka_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Si Boˈas manaˈik pī si pagmitingan laˈi si tarangka dinding puweblohin duk ningkoloˈ iye laˈi. Ubus palabey isab usba eymulla Elimelek dembuwaˈin, iye bakas tinaˈat weˈ si Boˈas dehelluhin. Lingananne iye, paˈinne, “Dayiˈ kew pitu, bagay, ningkoloˈ kew tuˈu.” Hangkan pī iye duk ningkoloˈ. ");
INSERT INTO yka_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Ubus daˈak si Boˈas sempūˈ meˈ bahiˈ puweblohin ningkoloˈ isab laˈi. Bu ningkoloˈ siye. ");
INSERT INTO yka_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ubus paˈin si Boˈas si usbane miyaˈan, “Si Naˈomi pitu balik amban lahat Moˈab bu mabayaˈ magpabelli bulak usbate ley Elimelek. ");
INSERT INTO yka_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Tapikilku weˈ subey kew akahanku. Bang bayaˈ bellinu bulakin subey bellinu si harapan meˈ aˈa duk bahiˈ maningkoloˈ matuˈu inin. Saguwaˈ bang gaˈi kew mabayaˈ, magaka kew, supaya kataˈuhanku. Peggeˈ kaˈu mapatut dehellu mangeddoˈ bulakin ubus bu aku.” Nambung lellahin, paˈinne, “Aweˈ, aku ne ngeddoˈne.” ");
INSERT INTO yka_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Ubus paˈin si Boˈas, “Na, bang si kaˈu ne bulakin, subey isab si kaˈu si Rut dende balu bangsa Moˈabin, supaya niyaˈ puliˈ usbate mamateyin duk gaˈi lepas bulakden amban pamilyade.” ");
INSERT INTO yka_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Nambung lellahin paˈinne, “Bang sā īˈ, gaˈi ku. Peggeˈ bang eddoˈku bulakin mekelutang aku. Si kaˈu ne, bang aku, gaˈi takoleˈku.” ");
INSERT INTO yka_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Masa ewwalley iye addat meˈ bangsa Israˈelin bang niyaˈ aˈa malinda kapatutne melli bulakin si saweˈne, subey luwasanne tehompaˈnen duk pangurungne si pamalindahanne kapatutin. Iye inin tandaˈ weˈ puwas ne palkalaˈin. ");
INSERT INTO yka_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Hangkan paˈin usba miyaˈan pu si Boˈas, “Kaˈu ne ngeddoˈne,” bu luwasanne tehompaˈnen. ");
INSERT INTO yka_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ubus paˈin si Boˈas si meˈ bahiˈin duk kēmon aˈa malaˈihin, “Ellew inin kaˈam ne saksiˈkun. Kēmon maniyaˈ pu si eymulla Elimelekley duk si Kilyon duk si Mahlon eddoˈku ne amban Naˈomi. ");
INSERT INTO yka_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Eddoˈku isab si Rut, dende bangsa Moˈab, bakas anda si Mahlonley, duk maganda ku si iye supaya mamateyin tege puliˈ duk gaˈi lepas pusakaˈnen duk ēn mamateyin gaˈi lepas si usbane duk si lahatne. Ellew inin kaˈam ne saksiˈkun.” ");
INSERT INTO yka_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Manjari meˈ bahiˈin duk kēmon aˈa sinduwe malaˈihin missā, paˈinde, “Aweˈ, naksiˈ ne kami. Karayaw pamanjari Tuhanin dende mapaˈasek si lumaˈnun kuweˈ si Rakel duk si Leˈa masaley, siye kapapuˈan kēmon bangsa Israˈelin. Karayaw ngabasagan kew si lahat Eprata duk bantu kew si Betlehem. ");
INSERT INTO yka_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Karayaw urungan Tuhanin kaˈam tubuˈ duk dende mabataˈ inin, duk karayaw pamilyanun kuweˈ pamilya papuˈten bi si Peres, anak si Yahud duk si Tamarin.” ");
INSERT INTO yka_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ubus ineddoˈ weˈ si Boˈas si Rut duk hinangne anda. Pag magdembuwaˈ ne siye iledjikiˈan siye weˈ Tuhanin duk betteng ne si Rut bu nganak lella. ");
INSERT INTO yka_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ubus paˈin meˈ dende si puweblohin pu si Naˈomi, “Pudjite bi Tuhanin, ellew inin inurungan kew weˈ ne ampu. Karayaw ngabantu iye diyalem bangsa Israˈel. ");
INSERT INTO yka_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Karayaw sabab nakanak inin gaˈi ne lemmaˈ lessanu duk ipatne kew bang kew bahiˈ. Peggeˈ inanakan iye weˈ eyuˈannu mamalasa si kaˈuhin duk pesōng iye hāp si kaˈu amban pituˈ anak lella.” ");
INSERT INTO yka_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ubus pinippi nakanakin weˈ Naˈomi duk inipat weˈ ne. ");
INSERT INTO yka_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Meˈ dende saweˈne magtapit lumaˈin missā, paˈinde, “Niyaˈ ne anak Naˈomi lella.” Duk ēnande iye si Obed. Ujudnen si Obed sama si Jesse, duk si Jesse sama si Daˈud. ");
INSERT INTO yka_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Iye inin meˈ tubuˈ si Peresin: si Peres sama si Hesron, ");
INSERT INTO yka_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","si Hesron sama si Aram, si Aram sama Amminadab, ");
INSERT INTO yka_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Amminadab sama si Nahson, si Nahson sama si Salmon, ");
INSERT INTO yka_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","si Salmon sama si Boˈas, si Boˈas sama si Obed, ");
INSERT INTO yka_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","si Obed sama si Jesse, si Jesse sama si Daˈud. ");
INSERT INTO yka_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Niyaˈ lapal Tuhanin pu si Yunus anak si Amittay. ");
INSERT INTO yka_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Paˈinne, “Pī kew si puweblo hadje inēnan Niniba. Magmahalayak kew pī si siye duk akahanun siye weˈ sōng siye pinagmulkaˈan, peggeˈ tiyaˈ ne kiteku hinangde malaˈatin.” ");
INSERT INTO yka_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Saguwaˈ si Yunus lahi amban Tuhan tudju lahat inēnan Tarsis. Pī iye hap pantalan si Joppa duk niyaˈ kitene dembuwaˈ kappal sōng pī hap lahat Tarsis inin. Magsukey ne iye, ubus manaˈik diyataˈ kappal duk palalgaˈ ne iye hap Tarsis supaya iye tapalahi amban Tuhan. ");
INSERT INTO yka_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Ubus inin pinatekka weˈ Tuhanin baliyu pales manamal diyataˈ tahik, duk lahat-lahat manamal. Agen larak kappalin. ");
INSERT INTO yka_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Kēmon aˈa magtarabahu diyataˈ kappal miyaˈan tinalew duk ngalingan siye dangan-dangan si tuhan-tuhanden māku tabang. Ubus bu laboˈde kalgade sinduwehin pī dem tahik supaya ngalampung kappalin. Saguwaˈ si Yunus andang ne laˈi dem mohang kappal; pabāk iye laˈi duk tuli. Leddek tulinen. ");
INSERT INTO yka_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Ubus kapitan kappalin pī si iye mangun iye duk paˈinne, “Tuli pe kew? Dongaˈ kew duk māku tabang kew si tuhannun. Kaw kite bi asipne duk kite bi gaˈi matey.” ");
INSERT INTO yka_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Ubus paˈin meˈ magtarabahu si kappalin, “Magpuwaˈan kite bi duk kataˈuhante bang amban sine jānnen hangkan inin umantag.” Ubus magpuwaˈan siye. Manjari kataˈuhande weˈ si Yunus jānnen. ");
INSERT INTO yka_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ubus paˈinde, “Akahanun kami bang asal kaˈu ke jānnen hangkan inin umantag. Ine pagusahanun? Bakas ambannu? Intag lahatnun? Ine bangsanun?” ");
INSERT INTO yka_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Sambunganne siye, paˈinne, “Aku inin bangsa Hibrani duk sambahayangku Tuhanin, iye Tuhan si surgaˈin duk iye magpapanjari bulak duk tahikin.” ");
INSERT INTO yka_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Paˈinne pe weˈ lahi iye amban Tuhan. Ubus kaˈumāgadan meˈ aˈa maghinang diyataˈ kappalin duk paˈinde, “Laˈat teˈed hinangannu iyan.” ");
INSERT INTO yka_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Sigi-sigi pe ngahadje goyakin. Ubus tilewde iye, “Ine subey hinangte si kaˈu inin duk pateddoˈ balik tahikin?” ");
INSERT INTO yka_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","“Lakasanun bi ku dem tahik,” paˈinne, “ubus ngateddoˈ iyan balik. Kataˈuhanku hep weˈ aku jānnen hangkan tekka lahat-lahat inin si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Saguwaˈ meˈ aˈahin musey pabasag manamal duk siye tapī si higad. Bu gaˈi takoleˈde, peggeˈ pesōng ngabasag tahikin amban tagnaˈin. ");
INSERT INTO yka_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ubus māku-māku isab siye si Tuhan, paˈinde, “O Tuhan, pabuyuˈ-buyuˈ kami, daˈa kami hukumun pinapatey bang bekkat kami niyawa aˈa inin. Daˈa kami dusehun bisan papatey kami aˈa gaˈ niyaˈ dusenen. Peggeˈ kaˈu du magbayaˈin hangkan inin umantag kēmon.” ");
INSERT INTO yka_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Ubus eddoˈde si Yunus duk laboˈde dem tahik. Ubus pateddoˈ ne tahikin. ");
INSERT INTO yka_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Hangkan tinalew siye si Tuhan bu magkurban siye duk niyaˈ tunggaˈde hāp si Tuhan. ");
INSERT INTO yka_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Saguwaˈ Tuhanin, papīne dembuwaˈ kenna hadje manamal ngaloroy si Yunus. Bu laˈi si Yunus diyalem kennahin tellu ellew duk tellun sangem. ");
INSERT INTO yka_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Pag laˈi iye diyalem kennahin ngampun-ngampun si Yunus tudju Tuhan. ");
INSERT INTO yka_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Paˈinne, “Pag laˈi ku dem kasusehan lingananku Tuhanin, ubus bu sambunganne ku. Pag laˈi ku diyalem lahat meˈ pateyin māku tabang ku bu pakale kew si paglingankun. ");
INSERT INTO yka_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Lakasannu ku pī dem kalaleman dem tengngaˈ sellang duk sellegin paliput si aku; kadebbunan ku weˈ kēmon goyaknun duk meˈ goyak mahadjehin. ");
INSERT INTO yka_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Kannalku, ‘Pinatahalaˈ ku amban matanu; gaˈi ne kiteku balik langgalnu masutsihin.’ ");
INSERT INTO yka_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Sōng lambo ku weˈ tahik mapaliput si akuhin tahik malalemin paliput si aku. Meˈ sabet dem tahikin palibed si kōkku. ");
INSERT INTO yka_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Palenneb ku pī si poˈon punuhin. Pakissup bulakin pag dumiyalem ku supaya ku gaˈi lumuwas salama-lama. Saguwaˈ kaˈu, Tuhan, Panuhutankun, boˈonu du ku balik amban dem kalaleman, ellum pe. ");
INSERT INTO yka_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Pag sōng ubus ne umulkun taˈessebte kew, Tuhan; ngampun-ngampun ku si kaˈu duk tapī pangampunkun si kaˈu diyalem langgalnu masutsihin. ");
INSERT INTO yka_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Sine-sine nuhut meˈ tuhan-tuhande manggaˈ niyaˈ balinen lebbahande ne sandelde si kaˈuhin, Tuhan. ");
INSERT INTO yka_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Saguwaˈ aku, magpasalamat ku duk magkurban ku si kaˈu. Meˈ bakas tunggaˈku si kaˈuhin tumananku du. Tuhanin hadja manimbulin.” ");
INSERT INTO yka_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ubus inin dinaˈak weˈ Tuhanin si Yunus pinaluwas si kennahin pī si higad tahik. ");
INSERT INTO yka_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ubus niyaˈ lapal Tuhanin pu si Yunus kaminduwenen, paˈinne, ");
INSERT INTO yka_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Pī kew hap puweblo hadje inēnan Niniba duk akahanun siye meˈ pinaˈinku si kaˈuhin.” ");
INSERT INTO yka_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Tuhut si Yunus pangandaˈakan Tuhanin duk pī iye hap Niniba. Niniba inin luha manamal. Bang kew pabutas amban puweblo iyan subey tellu ellew. ");
INSERT INTO yka_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Pag laˈi si Yunus maglengngan-lengngan de ellew nagnaˈ iye magaka-aka, paˈinne, “Bang palabey ampatpūˈ ellew pinakaˈatan du Ninibahin.” ");
INSERT INTO yka_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Pag kalede inin kahagad meˈ aˈa Ninibahin lapal amban Tuhanin. Magpatawag-tawag siye weˈ subey siye muwase; duk kēmon meˈ aˈahin amban meˈ langkew pagaˈanen taman diyawaˈ pagaˈanen kēmon siye magsemmek karut, tanda weˈ teyikutande ne duseden. ");
INSERT INTO yka_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Pag takale sultan Ninibahin aka-aka sabab inin magtawus iye kuwat amban paningkoloˈanne magbayaˈin. Ānanne semmekne mahāpin duk magsemmek karut iye. Ubus bu ningkoloˈ iye diyataˈ bulak, tandaˈ weˈ magsusun ne iye duk lebbahanne ne dusenen. ");
INSERT INTO yka_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ubus bu masan iye si meˈ aˈa Ninibahin paˈinne, “Daˈakan inin amban sultanin duk meˈ saweˈne magbayaˈin: Gaˈ niyaˈ subey mangan bisan ine. Aˈa atawa hayep, sapiˈ atawa bili-bili gaˈi subey mangan atawa nginum. ");
INSERT INTO yka_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Kēmon meˈ aˈahin subey magsemmek karut duk meˈ hayepin subey du isab bettadande karut. Kēmon siye subey basag ngampun-ngampun si Tuhan māku ampun. Kēmon siye subey teyikutande meˈ hinangande manggaˈi matewwaˈin duk hinangande malaˈatin. ");
INSERT INTO yka_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Gaˈi kataˈuhante; kaw gantiˈan Tuhanin pikilannen duk lebbahanne pagamānen duk maˈaseˈ iye si kite bi supaya kite bi gaˈi magkaˈat.” ");
INSERT INTO yka_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Pag kite Tuhanin meˈ hinanganden duk weˈ teyikutande ne hinangande malaˈatin, maˈaseˈ ne iye duk gaˈ ne palaˈusne malaˈat bakas panunggaˈne siyehin. ");
INSERT INTO yka_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Saguwaˈ si Yunus gaˈi teˈed kahāpan duk astel iye. ");
INSERT INTO yka_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ngampun-ngampun iye si Tuhan paˈinne, “O, Tuhan, iye hep inin bakas tapikilkun pag laˈi pe ku si dī lahatku weˈ sā miyaˈan hinangannun. Iye jānnen hangkan ku lahi palakkes pī hap lahat Tarsis. Kataˈuhanku hep weˈ bētabang kew duk maˈaseˈ, weˈ gaˈi kew mura ngamā duk malasa kew teˈed. Mura gantiˈannu pikilannun duk gaˈi palaˈusnu balaˈ panunggaˈnun. ");
INSERT INTO yka_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Hangkan hep, Tuhan, ambat ne ku matey peggeˈ hāp pe ku matey amban ellum.” ");
INSERT INTO yka_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Saguwaˈ nambung Tuhanin paˈinne, “Tewwaˈ ke bang kew ngamā?” ");
INSERT INTO yka_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Ubus inin paluwas si Yunus amban puweblo miyaˈan duk pī si lugal nampal silangan. Ngahinang iye payad-payad duk ningkoloˈ iye laˈi dem landung ngagad-ngagad supaya kitene bang ine umantag si puweblohin. ");
INSERT INTO yka_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ubus pinatomoˈ weˈ Tuhanin dembuwaˈ jambangan supaya kalandungan kōk si Yunusin duk gaˈi iye kahunitan. Sinna isab si Yunus sabab jambangan miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Saguwaˈ ellew dembuwaˈin, subu-subu pe pinapī weˈ Tuhanin dembuwaˈ olet duk kakanne jambangan miyaˈan. Ubus ngalanes jambanganin. ");
INSERT INTO yka_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Pag langkew ne ellewin pinatihup isab weˈ Tuhanin baliyu amban silangan panas manamal. Peddiˈ ellewin diyataˈ kōk si Yunus duk lamma ne iye teˈed. Mabayaˈ ne iye matey duk paˈinne, “Hāp pe ku matey amban ellum.” ");
INSERT INTO yka_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Saguwaˈ paˈin Tuhanin pu si Yunus, “Tewwaˈ ke bang kew ngamā sabab maˈumantag si jambangan miyaˈan?” “Aweˈ,” paˈinne. “Batang matey ne ku hawal astelkun.” ");
INSERT INTO yka_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Saguwaˈ paˈin Tuhanin, “Keyimanannu jambangan miyaˈan. Gaˈ kew bakas ipatne duk dumaˈin kaˈu matomoˈ iyehin. Bessuwang ne hadja tomoˈ duk bessuwang hadja lanes. ");
INSERT INTO yka_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Pesōng pe ku maˈaseˈ si meˈ aˈa Niniba inin peggeˈ niyaˈ labi da hatus duk duwempūˈ ngibu mākanak, gaˈ niyaˈ kasabutande. Duk ekka isab hayep laˈi.” ");
INSERT INTO yka_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Inin ēn meˈ kapapuˈan Isa Almasihin. Isa Almasi inin tubuˈ si Daˈud duk si Daˈud tubuˈ Ibrahim. ");
INSERT INTO yka_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6","Amban Ibrahim sampay pī pu Sultan Daˈud, inin meˈ kapapuˈan talistahin: Ibrahim sama si Isahak, Isahak sama si Yakub, si Yakub sama si Yuda duk meˈ pungtinaˈinen. Si Yuda sama si Peres duk Sera, (saˈiden si Tamar). Si Peres sama si Hesdon, si Hesdon sama si Aram. Si Aram sama Amminadab, Amminadab sama si Nasson, si Nasson sama si Salmon, si Salmon sama si Bowas (saˈinen si Rahab), si Bowas sama si Obed (saˈinen si Rut), si Obed sama si Jesse, si Jesse sama si Sultan Daˈud. ");
INSERT INTO yka_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Amban si Daˈud pī si masa pamatahalaˈ meˈ aˈa Israˈil pī hap lahat Babilonin, inin meˈ kapapuˈan talistahin: Si Daˈud sama si Sulaiman (saˈinen bakas anda si Uriya), si Sulaiman sama si Robowam, Robowam sama si Abiya, si Abiya sama si Asa, si Asa sama si Josapat. Josapat sama si Joram, si Joram sama si Usiyas, si Usiyas sama si Jotam, si Jotam sama si Ahas, si Ahas sama si Hijikiya, si Hijikiya sama si Manasse, Manasse sama si Amon, si Amon sama si Josiya, si Josiya sama si Jekoniya duk meˈ pungtinaˈinen. ");
INSERT INTO yka_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Amban masa pamatahalaˈ meˈ aˈa Israˈil hap Babilonin, pī si panganak pu si Isahin, inin meˈ kapapuˈan talistahin: Jekoniya sama Salati, Salati sama Serubbabel, Serubbabel sama si Abiyud, Abiyud sama si Eliyakim, Eliyakim sama si Asor, si Asor sama si Sadok, si Sadok sama si Akim, si Akim sama si Eliyud, Eliyud sama si Eleyasar, Eleyasar sama si Mattan, si Mattan sama si Yakub, si Yakub sama si Yusup ella si Mariyamin. Si Mariyam saˈi si Isa inēnan Almasihin. ");
INSERT INTO yka_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Manjari niyaˈ sampuk-ampat pangkat amban Ibrahim sampay si Sultan Daˈud, duk sampuk-ampat pangkat amban Sultan Daˈud sampay masa pamatahalaˈ siye tudju Babilonin duk sampuk-ampat pangkat amban pamatahalaˈ siye tudju Babilonin sampay panganak pu Almasihin. ");
INSERT INTO yka_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Manjari sa inin panganak pu si Isa Almasihin. Saˈinen Mariyam, taga tunang inēnan si Yusup. Gaˈ pe siye takawin betteng Mariyam weˈ balakat Niyawa Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tunangnen, si Yusup, bentel hinangannen. Hangkan pagkataˈuhanne weˈ betteng Mariyam, gaˈi iye bayaˈ weˈ iyaˈ Mariyam. Hangkan tapikilne magbutas ne hadja siye saguwaˈ gaˈi pinabawag. ");
INSERT INTO yka_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sasangne mamikil-mikil inin, paguwaˈ pu si Yusup malaˈikat Tuhanin pataginep si iye. Paˈin malaˈikatin, “O Yusup, tubuˈ Sultan Daˈud, daˈa kew magalang-alang ngawinan Mariyam, peggeˈ puˈunne betteng weˈ balakat Niyawa Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nganak iye iyan lella duk ēnanun iye si Isa (maˈananen manimbulin) peggeˈ iye manimbul meˈ bangsanen amban meˈ duseden.” ");
INSERT INTO yka_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na, kēmon inin pinalabey supaya tuman bakas pinaˈin Tuhan pu si Nabi Isaya awwalley, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Niyaˈ iyan budjang betteng duk nganak iye lella duk inēnan du iye Immanuel.” (Maˈana Immanuelin - Tuhanin palamud si kite bi.) ");
INSERT INTO yka_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pagngape si Yusup, tinuhut weˈ ne pangandaˈakan malaˈikatin. Kinawinan weˈ ne Mariyam. ");
INSERT INTO yka_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Saguwaˈ gaˈ siye magulid samantaˈan gaˈ pe ubus nganak Mariyam. Pagnganak ne Mariyam, lella anaknen duk inēnan iye weˈ si Yusup si Isa. ");
INSERT INTO yka_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Inanakan si Isa si puweblo Betlehem si lahat Yahudiya masa si Herod sultanin. Gaˈ tiggel, niyaˈ meˈ aˈa tekka pī si puweblo Awrusalam amban lahat silangan. Meˈ aˈa inin inadjiˈan weˈ de meˈ poteˈanin. ");
INSERT INTO yka_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pagtekkade laˈi magtilew siye, paˈinde, “Ingge nakanak baˈahu inanakanin, iye ujud manjari sultan meˈ Yahudihin? Peggeˈ niyaˈ takite kami poteˈan paguwaˈ laˈi si silangan duk poteˈan miyaˈan tandaˈ weˈ inanakan ne iye duk pitu kami mudji iye.” ");
INSERT INTO yka_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pagtakale weˈ Sultan Herod inin, sasew teˈed pikilannen duk sampay kēmon aˈa si Awrusalamin sasew du isab. ");
INSERT INTO yka_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Dinaˈak weˈ sultanin magtipun kēmon meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin. Manjari tinilew siye weˈ ne, paˈinne, “Antag lahat panganakan pu Almasihin?” ");
INSERT INTO yka_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Paˈinde, “Si puweblo Betlehem laˈi si Yahudiya, peggeˈ bakas tasulat weˈ Nabi Mika dem kitab sa inin, ");
INSERT INTO yka_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O meˈ aˈa Betlehem luˈu si lahat Yahudiya, bisan dikiˈ lahatbin gaˈi du kaˈam diniyawaˈan si matahan meˈ nakuraˈ Yahudihin, peggeˈ billuˈu paluwas du dambuwaˈ nakuraˈ mangantan meˈ aˈakun bangsa Israˈilin.’” ");
INSERT INTO yka_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pagtakale si Herod inin, pinasan weˈ ne dinaˈak pī meˈ lella amban silangan miyaˈan, bu binoˈo siye weˈ ne magbissā, siye-siye hadja. Tinilew siye weˈ ne bang sumiyan pangitede paguwaˈ poteˈanin. Inakahan iye weˈ de. ");
INSERT INTO yka_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Manjari dinaˈak ne siye hap Betlehem weˈ si Herod, paˈinne, “Pī kaˈam, pihahun bi teˈed nakanakin. Bang takasuwaˈbi ne nakanakin, akahanun bi ku duk ku isab tapī mudji iye.” ");
INSERT INTO yka_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Manjari, pagubus sultanin missā, lumengngan ne meˈ aˈa amban silangan miyaˈan. Sābude maglengnganin, takitede balik poteˈan bakas takitede si lahat silanganin. Pagkitede poteˈanin sinna teˈed siye manamal. Patuhut siye si poteˈanin, ubus bu pahali poteˈanin si atag palaˈihan nakanakin. ");
INSERT INTO yka_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ubus padiyalem siye si lumaˈ miyaˈan duk takitede nakanakin duk saˈinen Mariyam. Pasujud siye duk pinudji weˈ de nakanakin. Lukade pangisihanden duk urungande iye bulawan, kamanyan duk isellan bengngi inēnan mira. ");
INSERT INTO yka_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ubus inin inakahan siye weˈ Tuhanin diyalem taginepde, gaˈi siye dinaˈak balik pī pu si Herod. Manjari moleˈ siye, nuhut lān seddili. ");
INSERT INTO yka_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Manjari paglumikut ne siye, paguwaˈ malaˈikat Tuhanin pu si Yusup diyalem taginepne, paˈinne, “Iyuˈ sōng daˈak si Herod piniha nakanakin dinaˈak pinapatey. Dongaˈ kew, eddoˈun nakanakin duk Mariyam, saˈinen, bu lahi kaˈam hap lahat Misil. Patennaˈ kaˈam laˈi samantaˈan gaˈi pe kaˈam daˈakku tahalaˈ billaˈi.” ");
INSERT INTO yka_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Manjari dongaˈ ne si Yusup, ineddoˈ weˈ ne nakanakin duk Mariyam bu tahalaˈ ne siye hap lahat Misil sangem miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Patennaˈ siye laˈi sampay matey si Herod. Tuman ne lapal Tuhan tasulat Nabi Hosea dem kitabin, pinaˈin, “Daˈakku pitu anakkun amban lahat Misil.” ");
INSERT INTO yka_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Manjari pagkataˈuhan si Herod weˈ inakkalan hatiˈ iye weˈ meˈ aˈa amban silanganin, astel iye manamal. Daˈakne pinapatey kēmon nakanak lella duwen tahun sampay pe kulang amban duwen tahun umulden laˈi si lahat Betlehem duk si meˈ kalahatan matapit si Betlehemin, peggeˈ bakas inakahan iye weˈ meˈ aˈa amban silanganin bang sumiyan paguwaˈ poteˈanin. Ubus pinapatey ne meˈ mākanakin. ");
INSERT INTO yka_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na, tuman bakas pinaˈin Nabi Jeremiyahin, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Niyaˈ suwala takale si lahat Rama magmatey. Nāring teˈed si Rakel sabab meˈ anaknen. Gaˈi iye ngatu pinahemokan peggeˈ matey ne meˈ anaknen.” ");
INSERT INTO yka_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Manjari pagubus ne matey si Herod, paguwaˈ ne isab malaˈikat Tuhanin pu si Yusup pataginep si iye laˈi si lahat Misil. Paˈin malaˈikatin, ");
INSERT INTO yka_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Dongaˈ kew, eddoˈun nakanakin duk Mariyam, saˈinen, duk balik kaˈam pī si lahat Israˈil, peggeˈ ubus ne matey meˈ mabayaˈ mapatey nakanakin.” ");
INSERT INTO yka_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Manjari dongaˈ ne iye ngeddoˈ nakanakin duk Mariyam, duk balik ne siye pī si lahat Israˈil. ");
INSERT INTO yka_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Saguwaˈ pagkale si Yusup weˈ pagantiˈ magsultan laˈi si lahat Yahudiya anak si Herodin inēnan Alkilas, tinalew iye hap pī. Inakahan iye balik dem taginepne, dinaˈak siye pī hap lahat Jalil. ");
INSERT INTO yka_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Hangkan hep pī siye laˈi duk patennaˈ siye si puweblo inēnan Nasaret. Na, tuman binissā meˈ kanabihanin sabab Almasi, paˈinde, “Inēnan iye aˈa Nasaret.” ");
INSERT INTO yka_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Manjari, masa miyaˈan tekka Yahiya magpandi-pandi aˈahin si lahat makagindew-gindew si Yahudiya. Ekka aˈa hap pī si iye duk magmahalayak iye, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pagsusunanun bi dusebin duk lebbahanun bi ne, peggeˈ sōng pitu Tuhanin magbayaˈ si kite bi.” ");
INSERT INTO yka_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Bakas inaka weˈ Nabi Isaya sabab Yahiya inin, paˈinne, “Niyaˈ aˈa maglingan dem lahat makagindew-gindew. Iye inin pinaˈinnen, ‘Sōng tekka ne Panuhutanin. Palanuˈun bi lān palabeyannen. Pabentelun bi lān tinuhutnen.’” ");
INSERT INTO yka_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Semmek Yahiyahin bulu untaˈ tinennun duk kanditnen kuwit sapiˈ. Kinakannen meˈ dulu duk boheˈ buwani. ");
INSERT INTO yka_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hap pī si iye meˈ aˈahin amban Awrusalam duk amban tibuˈukan lahat Yahudiya duk amban meˈ kalahatan si bihing boheˈ Jordan. ");
INSERT INTO yka_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Magbennal siye si meˈ duseden duk pinandi siye weˈ Yahiya dem boheˈ Jordan. ");
INSERT INTO yka_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Niyaˈ isab meˈ Pariseo duk meˈ Sadduseo hap pī, meˈ nakuraˈ āgama siye. Pagkitene ekka Pariseo duk meˈ Sadduseo pī makipandi si iye, paˈinne, “Kaˈam iyan, addatbin kuweˈ addat sawe pangakkal. Kannalbi hatu weˈ gaˈi kaˈam tewwaˈ mulkaˈ Tuhan sōng matekkahin bang kaˈam pinandi. ");
INSERT INTO yka_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hinangun bi hinangan mahāpin duk takite weˈ tayikutanbi ne dusebin. ");
INSERT INTO yka_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Daˈa kaˈam ngandel weˈ gaˈi kaˈam legga Tuhanin sewukat ne kaˈam tubuˈ Apuˈ Ibrahim. Akahante kaˈam, bisan meˈ batu inin tahinang Tuhanin du meˈ tubuˈ Apuˈ Ibrahim. ");
INSERT INTO yka_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kuweˈ dalil kayu kaˈam sōng tinebbengan si gamutne. Kēmon kayu manggaˈi magbuwaˈ mahāpin tinebbengan duk ilakasan dem ebbut ineggas. ");
INSERT INTO yka_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Pinandi kaˈam weˈ ku duk boheˈ duk takite weˈ magsusun ne kaˈam duk lebbahanbi dusebin. Saguwaˈ niyaˈ paturul pitu si aku, balakatan pe iye amban aku. Gaˈi ku bisan pataˈ moˈo tehompaˈnen. Iye inin seddili pamandine kaˈamin. Niyaˈ kaˈam papīhanne Niyawa Sutsihin duk sinduwehin pandine duk ebbut. ");
INSERT INTO yka_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pagpaˈilne meˈ aˈa mahāpin duk meˈ aˈa malaˈatin. Kuweˈ iye dalil aˈa magpalid paley, pagpaˈilne linggasin duk apahin. Meˈ linggasin ennaˈne pinadem lukung saguwaˈ apahin eggasne dem ebbut gaˈ niyaˈ kapalemne.” ");
INSERT INTO yka_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Manjari lumengngan si Isa amban lahat Jalil hap boheˈ Jordan, duk makipandi iye pu si Yahiya. ");
INSERT INTO yka_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Saguwaˈ gaˈi mabayaˈ si Yahiya, paˈinne, “Weˈey kew pitu makipandi si aku? Subey kaˈu mamandi akuhin.” ");
INSERT INTO yka_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Saguwaˈ nambung si Isa, paˈinne, “Pīhun ne, pandihun ne ku kuweˈitu peggeˈ subey teˈed tuhutte kēmon pangandaˈakan Tuhanin.” Ubus sinulut ne si Isa weˈ Yahiya. ");
INSERT INTO yka_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pagubus si Isa pinandi paguwaˈ iye amban dem boheˈ. Manjari paluka langitin duk takitene Niyawa Tuhanin kuweˈ bantuk assang duwaˈi amban surgaˈ duk padapuˈ si iye. ");
INSERT INTO yka_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Niyaˈ isab suwala amban surgaˈ missā, paˈinne, “Inin Anakku kalasahanku. Asal kasulutan ku teˈed si iye.” ");
INSERT INTO yka_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Manjari binoˈo si Isa weˈ Niyawa Sutsihin hap lahat makagindew-gindew supaya iye tasassat weˈ nakuraˈ seyitanin. ");
INSERT INTO yka_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Paglaˈi si Isa gaˈ iye mangan ampatpūˈ ellew duk ampatpūˈ sangem. Pagpuwas miyaˈan inusan ne iye. ");
INSERT INTO yka_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Manjari tekka nakuraˈ seyitanin duk paˈinne pu si Isa, “Bang bennal kew teˈed Anak Tuhanin, daˈakun meˈ batu inin manjari kinakan.” ");
INSERT INTO yka_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nambung si Isa, paˈinne, “Tasulat dem kitab, pinaˈin, ‘Dumaˈin hadja kinakan makaˈellum manusiyaˈin saguwaˈ iye makaˈellum manusiyaˈin meˈ bissā Tuhanin.’” ");
INSERT INTO yka_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ubus miyaˈan binoˈo iye weˈ nakuraˈ seyitanin hap Awrusalam duk pinatengge iye diyataˈ būngan langgal hadjehin. ");
INSERT INTO yka_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Paˈin nakuraˈ seyitanin, “Bang bennal kew teˈed Anak Tuhanin, palaboˈ kew bittuˈu, peggeˈ tasulat du dem kitab pinaˈin, ‘Daˈak Tuhanin kew inipat si meˈ malaˈikatnen duk tayakde kew supaya bisan bettisnun gaˈi peddiˈan weˈ batu.’” ");
INSERT INTO yka_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Paˈin si Isa, “Niyaˈ isab tasulat sa inin, ‘Daˈa suleyanun Tuhanin, Panuhutannun.’” ");
INSERT INTO yka_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pagubus miyaˈan, binoˈo iye weˈ nakuraˈ seyitanin diyataˈ punu langkew manamal. Pinakitehan si iye weˈ nakuraˈ seyitanin kēmon kalahatan dem dunyahin duk alataˈden duk balakat nakuraˈden. ");
INSERT INTO yka_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Paˈin nakuraˈ seyitanin pu si Isa, “Kēmon inin pangurungku kaˈu bang kew pasujud duk nambahayang si aku.” ");
INSERT INTO yka_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Paˈin si Isa, “Tahalaˈ kew, seyitan, peggeˈ tasulat dem kitab, pinaˈin, ‘Subey kaˈam pasujud si Tuhan Panuhutanbin duk subey hadja iye dendangan sinambahayangbin.’” ");
INSERT INTO yka_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ubus miyaˈan tahalaˈ ne nakuraˈ seyitanin duk tekka meˈ malaˈikatin ngahatul iye. ");
INSERT INTO yka_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Manjari inin, pagkale si Isa weˈ kinalabusu Yahiya, pī iye si lahat Jalil. ");
INSERT INTO yka_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gaˈ iye patennaˈ si Nasaret, saguwaˈ pī iye patennaˈ si Kapernaum, puweblo si bihing lamew Jalil laˈi si lahat Sebulun duk Naptali. ");
INSERT INTO yka_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tuman ne binissā Nabi Isaya dem kitabin, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Lahat Sebulunin duk lahat Naptalihin tudju seddepan duk si dambiyaˈ boheˈ Jordan inēnan isab lahat Jalil, magsewusaget meˈ kabangsahan malaˈihin. ");
INSERT INTO yka_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Meˈ aˈa mapatennaˈ dem kalindemanin makakite dantaˈ sahaya manamal. Tekka ne dantaˈin si meˈ aˈa dem kalindemanin, meˈ matinalew mamateyin.” ");
INSERT INTO yka_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Manjari inin, magtagnaˈ ne si Isa magmahalayak, paˈinne, “Pagsusunanun bi dusebin duk lebbahanun bi ne, peggeˈ sōng pitu Tuhanin magbayaˈ si kite bi.” ");
INSERT INTO yka_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Manjari lumengngan-lengngan si Isa laˈi si susulan lamew Jalil. Sasangne malumengnganin, niyaˈ takitene duwangan magpungtinaˈi. Dambuwaˈin si Simon, inēnan isab iye Petros duk dambuwaˈin inēnan Andariyas. Magpokot siye laˈi dem lamew, peggeˈ siye meˈ aˈa magkenna. ");
INSERT INTO yka_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Manjari paˈin si Isa si siye, “Dayiˈ kaˈam nuhut aku. Bahanbin mageddoˈ-eddoˈ kenna. Saguwaˈ bang kaˈam nuhut aku, toloˈante kaˈam mageddoˈ-eddoˈ aˈa pinatuhut si aku.” ");
INSERT INTO yka_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Magtawus inambanan weˈ de meˈ pokotden duk nuhut siye si Isa. ");
INSERT INTO yka_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Palanjal ne si Isa. Niyaˈ isab takitene duwangan magpungtinaˈi disi Yakub duk Yahiya, meˈ anak si Sebedehin. Dem bangkaˈ siye duk samaden, maghatul pokotden. Ilinganan siye weˈ si Isa duk binoˈo weˈ ne. ");
INSERT INTO yka_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Magtawus du isab siye nuhut. Inambanan weˈ de samaden duk bangkaˈden. ");
INSERT INTO yka_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Manjari ilatag weˈ si Isa lahat Jalilin duk magusihat iye si meˈ kalanggal-langgalan duk magmahalayak aka-aka hāp sabab pagbayaˈ Tuhanin. Pinakoleˈ weˈ ne meˈ aˈa masakihin. Bisan ine-ine sakiden pinakawuliˈ weˈ ne. ");
INSERT INTO yka_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Manjari bawag ne si Isa si kēmon kalahatan si Siriya. Hangkan binoˈo isab weˈ meˈ aˈahin pī pu si Isa kēmon aˈa masakihin, meˈ mapeddiˈanin duk meˈ aˈa pasayedan seyitanin, meˈ binabuy-babuyin duk meˈ aˈa mamatey barannen. Kawuliˈan siye kēmon weˈ si Isa. ");
INSERT INTO yka_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tungan-tunganne, ekka aˈa nuhut iye, meˈ aˈa amban lahat Jalil, amban meˈ sampūˈ puweblo, amban Awrusalam duk Yahudiya duk amban dambiyaˈ boheˈ Jordan. ");
INSERT INTO yka_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Manjari pagkite si Isa meˈ aˈa mabanesin, pataked iye diyataˈ kūd duk ningkoloˈ iye. Patapit si iye meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Magusihat iye si siye, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Hāp pe meˈ aˈa mangataˈuhan weˈ gaˈi kasulutan Tuhanin si siye bang gaˈi siye ngandel si iye, peggeˈ pagbayaˈan du siye weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Hāp pe meˈ aˈa madukkahin, peggeˈ pinahemokan du siye weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Hāp pe meˈ aˈa madiyawaˈ ateynen peggeˈ tasangkade du kahāpan pananggup Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Hāp pe meˈ aˈa mamabayaˈ manuhut kabayaˈan Tuhanin, peggeˈ dinuhulan du siye. ");
INSERT INTO yka_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Hāp pe meˈ aˈa mamaˈaseˈ si saweˈden, peggeˈ kinaˈaseˈan du isab siye weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Hāp pe meˈ aˈa mabentel dem ateyden, peggeˈ magkite du siye duk Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Hāp pe meˈ aˈa maghāp saweˈden, peggeˈ inēnan du siye anak Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Hāp pe meˈ aˈa bininasa sabab panuhutde pangandaˈakan Tuhanin, peggeˈ pagbayaˈan siye weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Hāp pe kaˈam bang kaˈam binissā-bissāhan, duk pinapeddiˈan duk ilimutan bu gaˈi toˈo peggeˈ nuhut kaˈam aku. ");
INSERT INTO yka_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Magkēg kaˈam manamal peggeˈ hadje panumbas kaˈamin si surgaˈ. Peggeˈ sa miyaˈan du hep isab paminasa si meˈ kanabihan matuˈuley.” ");
INSERT INTO yka_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kaˈam manuhut akuhin, kuweˈ asin du kaˈam si kēmon manusiyaˈ. Saguwaˈ bang asinin gaˈ ne niyaˈ lessane, gaˈi ne maˈasin balik. Gaˈ ne niyaˈ gunane. Ubus ilakasan hadja duk diˈik-diˈikan aˈa. ");
INSERT INTO yka_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kaˈam manuhut akuhin, kuweˈ dantaˈ du kaˈam si kēmon manusiyaˈ. Bang puweblohin diyataˈ kūd, takite du weˈ meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Gaˈ niyaˈ mekketan payitaˈan bu lekkebanne duk palanggana saguwaˈ bettadne diyataˈ tengenanne duk dantaˈ kēmon dem lumaˈin. ");
INSERT INTO yka_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Damikkiyan isab kaˈam subey ngurung dantaˈ si manusiyaˈ. Hātinen maghinang kaˈam hāp, supaya takite meˈ aˈahin meˈ hinanganbi mahāpin duk pudjide du Samabi si surgaˈin.” ");
INSERT INTO yka_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Daˈa kaˈam magpikil weˈ hangkan ku pitu supaya gaˈi ne binali saraˈ si Musahin duk meˈ panoloˈ kanabihanin. Gaˈi ku pitu ngānan saraˈin duk meˈ panoloˈ kanabihanin saguwaˈ supaya tapahāti teˈed bang ine hātinen. ");
INSERT INTO yka_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sabennal akahante kaˈam, samantaˈan tuˈu pe dunyahin duk langitin, gaˈ niyaˈ bisan dambuwaˈ batang duk dambuwaˈ balis inānan amban saraˈin. Gaˈi makajari weˈ gaˈi binali saraˈin samantaˈan gaˈ pe kiyamat. ");
INSERT INTO yka_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hangkan sine-sine ngalanggalan saraˈin, bisan meˈ saraˈ gaˈ niyaˈ tantu baline, duk toloˈanne isab sinduwehin ngalanggalanne, iye du madiyawaˈ teˈed dem pagbayaˈan Tuhanin. Saguwaˈ sine-sine nuhut saraˈin duk toloˈanne isab sinduwehin nuhut saraˈin, langkew iye si pagbayaˈan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Akahante kaˈam, bang pagtuyuˈbi manuhut pangandaˈakan Tuhanin gaˈi palabi amban pagtuyuˈ meˈ guru si saraˈ āgamahin duk meˈ Pariseohin, gaˈi du kaˈam tapī dem pagbayaˈan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bakas takalebi sabab panoloˈ si meˈ aˈa dehelluhin, pinaˈin, ‘Daˈa kew mapatey. Sine-sine mapatey subey hinukum.’ ");
INSERT INTO yka_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Saguwaˈ aku, paˈinku: sine-sine astel si saweˈnen subey hinukum, duk sine-sine magpaˈin si saweˈne, ‘Babbal kew!’ subey binoˈo si huwis, duk sine-sine magpaˈin si saweˈne, ‘Dupang kew teˈed, gaˈ niyaˈ kagunahannu!’ siya-siya iye hinukum pinadem ebbut narkaˈ. ");
INSERT INTO yka_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Bang kew laˈi si langgal sōng nambahayang bu taˈessebnu weˈ peddiˈ atey saweˈnun si kaˈu, ");
INSERT INTO yka_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pī kew dahuˈ maghāp duk saweˈnun, meke kew pī balik nambahayang. ");
INSERT INTO yka_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Bang niyaˈ aˈa nuntutan kaˈu, boˈohun ne iye maghāp sasangbi pe si lān hap pī si paghukuman. Peggeˈ bang laˈi ne kaˈam si paghukuman, kaw kew daˈak hukumin ineddoˈ si pulis bu pinadem kalabusu kew. ");
INSERT INTO yka_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sabennal akahante kew, weˈ gaˈi teˈed kew lumuwas billaˈi samantaˈan gaˈi tapuwasannu kēmon pinamulta si kaˈuhin. Bisan dambuwaˈ sīn gaˈi kakulangan.” ");
INSERT INTO yka_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Bakas takalebi isab panoloˈ inin, pinaˈin, ‘Daˈa kew magjina.’ ");
INSERT INTO yka_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Saguwaˈ aku, paˈinku: sine-sine mayam si dende bu tapikilnen laˈat, kapagjina ne iye duk dendehin dem ateyne. ");
INSERT INTO yka_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Bang matanu kanawanin mamoˈo kaˈu magdusehin, lebbahanun pagdusenun. Dalilnen kuweˈ du ugitannu matanun bu ngalakasanne. Hāp pe bang gaˈ niyaˈ matanu dambiyaˈ, amban kēmon barannun tinimanan pī dem narkaˈ. ");
INSERT INTO yka_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Duk bang tangannu kanawanin mamoˈo kaˈu magdusehin, lebbahanun pagdusenun. Dalilnen kuweˈ du putukannu tangannun bu ngalakasanne. Hāp pe bang putuk tangannu dambiyaˈin, amban kēmon barannun pinadem narkaˈ.” ");
INSERT INTO yka_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Niyaˈ isab panoloˈ, pinaˈin, ‘Sine-sine nimanan andanen subey niyaˈ sulat pagpilmahande duk kataˈuhan weˈ magbutas ne siye.’ ");
INSERT INTO yka_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Saguwaˈ aku, paˈinku: bang lellahin nimanan andanen, bu gaˈ bakas magjina andanen, lellahin jānnen hangkan magjina dendehin bang magella iye balik. Duk sine-sine maganda si iye magjina du isab.” ");
INSERT INTO yka_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Bakas takalebi isab sabab panoloˈ si meˈ aˈa dehelluhin, pinaˈin, ‘Daˈa kaˈam napa bang gaˈi toˈo. Duk subey tumananbi bang niyaˈ sanggupbi si pakalehan Tuhanin.’ ");
INSERT INTO yka_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Saguwaˈ aku, paˈinku: bang kaˈam nanggup ine-ine, daˈa kaˈam napa nabbut surgaˈin, peggeˈ laˈi paningkoloˈan Tuhanin. Daˈa kaˈam napa nabbut dunyahin, peggeˈ inin pahalihan bettis Tuhanin. Daˈa kaˈam napa nabbut puweblo Awrusalamin, peggeˈ inin puweblo inantanan Sultan Mabalakatanin. ");
INSERT INTO yka_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Daˈa kaˈam napa, kuweˈ upama paˈinbi, ‘Muwekkaˈ kōkkun bang gaˈi toˈo!’ peggeˈ dumaˈin kaˈam mangahinang baranbin. Bisan da lamba kōkbin, gaˈi du kaˈam taˈu matomoˈne pinaˈittem atawa pinapoteˈ. ");
INSERT INTO yka_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Paˈinun bi hadja, ‘Aweˈ’ atawa, ‘Gaˈi.’ Ine-ine panambabi supaya kaˈam kinahagad, iyan amban nakuraˈ seyitanin ne.” ");
INSERT INTO yka_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Bakas takalebi panoloˈ inin, pinaˈin, ‘Bang niyaˈ aˈa makapagkaˈat mata saweˈne, subey isab pinagkaˈat matanen, duk bang niyaˈ aˈa makalupuˈ impen saweˈne, subey isab ilupuˈ impennen.’ ");
INSERT INTO yka_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Saguwaˈ aku, paˈinku: daˈa kaˈam males bang niyaˈ aˈa taga sāˈ si kaˈam. Bang niyaˈ aˈa nampak luwenu dambiyaˈin patampalun isab pī si iye dambiyaˈin, ambat sampakne. ");
INSERT INTO yka_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bang niyaˈ aˈa nuntutan kaˈu supaya taˈeddoˈne badjuˈnun, pangurungun du isab iye ōsnun. ");
INSERT INTO yka_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bang niyaˈ aˈa nganggagahan kaˈu moˈo binoˈonen da kilumetro, boˈohun duwe kilumetro. ");
INSERT INTO yka_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Sine-sine mākuhan kaˈu, urunganun, duk sine-sine ngindam amban kaˈu, paˈindamanun.” ");
INSERT INTO yka_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Bakas takalebi panoloˈ inin, pinaˈin, ‘Kalasahanun bagaynun duk kabunsihanun bantanun.’ ");
INSERT INTO yka_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Saguwaˈ aku, paˈinku: kalasahanun bi bantabin duk māku-māku kaˈam si Tuhan para si meˈ mangalaˈat kaˈamin ");
INSERT INTO yka_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","supaya addatbin neppu addat Tuhanin, Samabi si surgaˈin. Peggeˈ Tuhanin pasilakne ellewin si meˈ aˈa mahāpin duk meˈ aˈa malaˈatin saliˈ-saliˈ. Duk urunganne ulan meˈ aˈa mabentelin duk meˈ aˈa maghinangan malaˈatin. ");
INSERT INTO yka_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Daˈa kaˈam ngase-ngase weˈ tumbasan Tuhanin kaˈam bang iye hadja kinalasahanbin meˈ mamalasa si kaˈamin. Peggeˈ bisan du meˈ aˈa magpāku-pāku sukey mangalibahin, kalasahande du isab mamalasa si siyehin. ");
INSERT INTO yka_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bang iye hadja inasipbin meˈ bagaybin, na, gaˈ du niyaˈ tahinangbi pasōng hāpnen amban tahinang meˈ sinduwehin. Bisan meˈ aˈa manggaˈi mangataˈuhan Tuhanin sa iyan du isab addatden. ");
INSERT INTO yka_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hangkan kaˈam, subey kaˈam hāp kuweˈ hāpan Samabi si surgaˈin.” ");
INSERT INTO yka_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pahatul-hatul kaˈam, daˈa kaˈam maghinang hāp supaya hadja kaˈam takite weˈ aˈa. Peggeˈ bang hinangbi inin supaya hadja kaˈam takite weˈ aˈa, gaˈ niyaˈ tumbasbi amban Tuhanin, Samabi si surgaˈin. ");
INSERT INTO yka_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hangkan bang kaˈam ngurung si meˈ aˈa miskin, daˈa kaˈam magpabawag kuweˈ meˈ aˈa mangurung dem langgalin duk si meˈ lānin supaya siye pinudji weˈ aˈa sinduwehin. Sabennal akahante kaˈam, bang siye pudji aˈa, katumbasan ne siye, duk iye miyaˈan tumbas si siyehin. ");
INSERT INTO yka_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Saguwaˈ kaˈam, bang kaˈam ngurung si meˈ aˈa miskin, daˈa kaˈam magaka-aka bisan si bagaybi manamalin ");
INSERT INTO yka_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","duk gaˈi kataˈuhan pangurungbin. Samabi si surgaˈin kataˈuhanne hininangbin bisan sipuk duk tumbasanne du kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Bang kaˈam ngampun si Tuhanin daˈa kaˈam kuweˈ meˈ aˈa magmā-māhin. Peggeˈ sinna siye ngampun si Tuhan si langgal duk si bihing lān supaya siye takite weˈ aˈa. Akahante kaˈam, bang siye pudji aˈa, katumbasan ne siye, duk iye miyaˈan tumbas si siyehin. ");
INSERT INTO yka_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Saguwaˈ bang kew ngampun, pī kew dem bilik duk tambelun gawangin duk ngampun kew si Tuhan, iye Samanu gaˈi takitehin. Samanu inin, takitene du hininangnun duk tumbasanne du kew. ");
INSERT INTO yka_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Bang kaˈam ngampun, daˈa kaˈam missā pinatahaˈ duk binalik-balik kuweˈ meˈ aˈa manggaˈi mangataˈuhan Tuhanin, peggeˈ paˈinde weˈ takale Tuhanin siye bang ekka bissāde. ");
INSERT INTO yka_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Daˈa be kaˈam kuweˈ siyehin peggeˈ kataˈuhan Samabi Tuhanin du andang bang ine meˈ sukalbin. ");
INSERT INTO yka_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bang kaˈam ngampun subey kuweˈ inin: ‘O Ammaˈ, kaˈu sama kami si surgaˈin, karayaw pinagaddatan ēnnun weˈ kēmon manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Karayaw weˈ gaˈi tiggel magbayaˈ ne kew si kēmon manusiyaˈ. Karayaw tinuhut kinabayaˈannun tuˈu si dunya sa maluˈu si surgaˈin. ");
INSERT INTO yka_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Urunganun kami kinakan ellew inin. ");
INSERT INTO yka_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ampunun meˈ duse kamihin kuweˈ du isab pangampun kami meˈ makaduse si kamihin. ");
INSERT INTO yka_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Patalahun kami amban sassat duk elliganun kami amban nakuraˈ seyitanin.’ ");
INSERT INTO yka_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Peggeˈ bang ampunbi duse saweˈbin, inampun isab kaˈam weˈ Samabi si surgaˈin. ");
INSERT INTO yka_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Saguwaˈ bang gaˈi ampunbi duse saweˈbin gaˈi isab dusebin ampun Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Bang kaˈam muwase, daˈa kaˈam kuweˈ bantuk suse kuweˈ meˈ aˈa magmā-māhin hadja. Peggeˈ bang siye muwase, gaˈi siye ngulaˈup atawa magsugley supaya takite weˈ aˈa weˈ magpuwase siye. Sabennal akahante kaˈam, bang siye pudji aˈa, katumbasan ne siye duk iye miyaˈan tumbas si siyehin. ");
INSERT INTO yka_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Saguwaˈ bang kaˈam muwase, ngulaˈup kaˈam duk maglanuˈ-lanuˈ kaˈam ");
INSERT INTO yka_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","supaya gaˈi kataˈuhan sinduwehin weˈ muwase kaˈam. Samabi gaˈi takitehin, takitene du hininangbin duk tumbasanne du kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Daˈa kaˈam magtipun alataˈ tuˈu si dunya peggeˈ mura magkaˈat. Makajari kakan mellek atawa ginahaˈ, atawa tinangkew bang ilangkat lumaˈin. ");
INSERT INTO yka_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Saguwaˈ maghinang kaˈam hāp supaya niyaˈ katekkahanbi si surgaˈ. Duk alataˈbi iyan gaˈi takakan mellek, gaˈi ginahaˈ duk gaˈi tatangkew. ");
INSERT INTO yka_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Peggeˈ antag-antag pangennaˈanbi alataˈbin, laˈi isab patetegan ateybin.” ");
INSERT INTO yka_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mataten dalil payitaˈan si barante. Bang pastiˈ pamayamten, hātinen, bentel hinanganten, kuweˈ dantaˈ tibuˈukan baranten. ");
INSERT INTO yka_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Saguwaˈ bang labut pamayamten, hātinen laˈat hinanganten, kuweˈ lindem tibuˈukan baranten. Bang paˈinte weˈ dantaˈ dem baranten bu lindem hatiˈ, asal lindem manamal.” ");
INSERT INTO yka_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Gaˈ niyaˈ daraˈakan makajari magbanyagaˈ si duwe amu, peggeˈ kabunsihanne iyan dambuwaˈin duk kalasahanne dambuwaˈin, atawa tuhutne teˈed dambuwaˈin duk gaˈi asipne dambuwaˈin. Bang pilakin mamahalgaˈ si kaˈamin, gaˈi kaˈam makajari maghinang isab si Tuhan. ");
INSERT INTO yka_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Hangkan hep paˈinku si kaˈam: daˈa kaˈam magsuse sabab kaˈellumanbin bang ine kinakanbin duk bang ine ininumbin supaya kaˈam ellum, atawa sabab baranbin bang ine panemmekbin. Mahalgaˈ pe hep umulin amban kinakan, duk mahalgaˈ pe hep baranin amban semmek. ");
INSERT INTO yka_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Payamanun bi meˈ manuk-manuk mapalayangin. Gaˈi siye magtanem atawa magpagani duk gaˈi siye magennaˈ saguwaˈ pakan Tuhanin siye. Bu kaˈam, pasōng teˈed kaˈam mahalgaˈ amban meˈ manuk-manukin. ");
INSERT INTO yka_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sine kaˈam tapatahaˈbi umulbin bisan da ora bang kaˈam magsuse? ");
INSERT INTO yka_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Weˈey pe pagsusehanbi sabab semmekbin? Payamanun bi meˈ sumpingin bang saˈingge panuligden. Gaˈi siye maghinang, gaˈi siye magtennun. ");
INSERT INTO yka_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bu paˈin, akahante kaˈam, bisan Sultan Sulaiman madayahan awwalley, gaˈ du makapagsemmek hāpnen kuweˈ dambuwaˈ meˈ sumping inin. ");
INSERT INTO yka_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bang Tuhanin tapasemmekanne pahāp-hāp meˈ sumping sabetin bu gaˈi du siye natas, ellum siye kuweˈitu, pagsumu ineggas, na, kaˈam pe gaˈi tapasemmekanne? Asal kulang sandelbi si Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hangkan daˈa kaˈam magsuse. Daˈa kaˈam magpaˈin, ‘Ine kinakanten bi, ine ininumten bi, ine panemmekten bi.’ ");
INSERT INTO yka_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Meˈ aˈa manggaˈi mangataˈuhan Tuhanin, iye hep inin luwal pinikilden. Saguwaˈ kaˈam, subey kaˈam gaˈi magsuse peggeˈ kataˈuhan Samabi Tuhanin weˈ iye inin meˈ sukalbin. ");
INSERT INTO yka_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Saguwaˈ iye subey pikilun bi sabab pagbayaˈan Tuhanin duk sabab panuhut kinabayaˈannen. Manjari urunganne du kaˈam kēmon sukalbi inin. ");
INSERT INTO yka_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hangkan hep daˈa kaˈam magsuse sabab sumuhin, peggeˈ ngaˈekka hadja kasusehanbin. Sarang ne susebi sabab ellew inin.” ");
INSERT INTO yka_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Daˈa kaˈam ngandiyawaˈan saweˈbi duk kaˈam gaˈi hukum Tuhanin, ");
INSERT INTO yka_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","peggeˈ bang kaˈam kuweˈ bantuk ngahukum saweˈbi, damikkiyan du isab kaˈam hukum Tuhanin. Duk bang saˈingge kaˈam nakesan saweˈbi, kuweˈ miyaˈan du isab takesan si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kaˈu, mangandiyawaˈan saweˈnun, weˈey iye tatīknun hapak-hapak dem mata saweˈnun, bu kaˈu batang kayu dem matanun, bu gaˈi tatīknu. ");
INSERT INTO yka_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Saˈingge kapagpaˈinnu si saweˈnun, ‘Bagay, tuhun koˈ, ānante hapak-hapak dem matanu lu,’ bang niyaˈ batang kayu dem di matanun. ");
INSERT INTO yka_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kaˈu iyan magmā-mā hadja. Ānanun dahuˈ batang kayuhin amban dem matanu iyan, ubus pastiˈ ne pamayamnun ngānan hapak-hapak dem mata saweˈnun. ");
INSERT INTO yka_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Daˈa kaˈam ngurung ine-ine sutsi si meˈ asu, kaw kaˈam balikde kinekkeb. Daˈa lakasanun bi meˈ mutsaˈbin si bawi, kaw hadja diˈik-diˈikande.” ");
INSERT INTO yka_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Māku-māku kaˈam ubus inurungan du kaˈam; miha kaˈam ubus ngasuwaˈ du kaˈam; makipadiyalem kaˈam ubus ilukahan du kaˈam. ");
INSERT INTO yka_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Peggeˈ kēmon mamākuhin inurungan du, mamihahin ngasuwaˈ du, duk makipadiyalemin ilukahan du. ");
INSERT INTO yka_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sine kaˈam tuˈu, bang anakbin māku kinakan si kaˈam, urunganbi ke iye batu? ");
INSERT INTO yka_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Atawa bang māku iye kenna, urunganbi ke iye sawe? ");
INSERT INTO yka_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kaˈam, bisan kaˈam dusehan, taˈu du kaˈam ngurungan anakbin meˈ bayuˈ-bayuˈan mahāpin. Pasōng pe teˈed Tuhanin, Samabi si surgaˈin, pangurungne du si kaˈam meˈ bayuˈ-bayuˈan mahāpin bang kaˈam māku si iye. ");
INSERT INTO yka_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ine-ine kabayaˈanbi hinang aˈa si kaˈam, damikkiyan isab hinangun bi si siye, peggeˈ iyan hāti saraˈ si Musahin duk panoloˈ meˈ kanabihanin.” ");
INSERT INTO yka_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Paˈasek kaˈam amban tarangka makiputin. Luha tarangkahin duk mura tinuhut lān hap narkaˈin. Ekka aˈa nuhut lān miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Saguwaˈ kiput tarangkahin duk hunit tinuhut lān tudju surgaˈin. Kulang aˈa mangasuwaˈ iyehin.” ");
INSERT INTO yka_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pahatul-hatul kaˈam, kaw kaˈam taboˈo weˈ meˈ nabi gaˈi bennal. Si luwasan hāp addatden, saguwaˈ dem ateyde, laˈatan siye kuweˈ dalil asu bingis. ");
INSERT INTO yka_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Takilalebi siye si meˈ hinanganden, kuweˈ kayuhin kataˈuhan si buwaˈne. Gaˈi kite bi ngeddoˈ buwaˈ ubas amban puhung atawa buwaˈ biyabas amban sampinit. ");
INSERT INTO yka_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kayu mahāpin hāp buwaˈnen saguwaˈ kayu manggaˈi mahāpin gaˈi isab hāp buwaˈnen. ");
INSERT INTO yka_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kayu mahāpin gaˈi buwaˈ gaˈi hāp duk kayu manggaˈi mahāpin gaˈi buwaˈ hāp. ");
INSERT INTO yka_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kēmon kayu manggaˈi magbuwaˈ mahāpin tinebbengan duk ilakasan dem ebbut ineggas. ");
INSERT INTO yka_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sa iyan du isab takilalebi meˈ nabi manggaˈi mabennalin si meˈ hinanganden.” ");
INSERT INTO yka_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Dumaˈin kēmon luwal manabbut ēnkun tapī si pagbayaˈan Tuhanin, saguwaˈ luwal hadja meˈ aˈa manuhut kabayaˈan Samaku si surgaˈin. ");
INSERT INTO yka_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bang taˈabut ne ellew pangahukum manusiyaˈin, ekka iyan aˈa magpaˈin si aku, ‘Kaˈu Panuhutan kamihin, peggeˈ bakas kami magpalataˈ bissā Tuhanin weˈ balakat ēnnun, duk bakas kami magpaluwas meˈ seyitan duk bakas kami maghinang ekka hinangan makaˈulaliˈ weˈ balakat ēnnun.’ ");
INSERT INTO yka_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ubus paˈinku iyan si siye, ‘Gaˈi kaˈam takilaleku. Tahalaˈ kaˈam amban aku, kēmon kaˈam maghinangan malaˈatin.’” ");
INSERT INTO yka_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Manjari, sasuku pakale si meˈ bissāku miyaˈan duk tuhutne, kuweˈ iye aˈa pandey teˈed mikil ngahinang lumaˈne diyataˈ batu. ");
INSERT INTO yka_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Manjari tekka ulanin duk dunuk boheˈin duk tewwaˈ lumaˈin weˈ baliyu mabasagin. Saguwaˈ gaˈ hebbaˈ lumaˈin peggeˈ hininang diyataˈ batu. ");
INSERT INTO yka_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Duk sasuku pakale si meˈ bissāku miyaˈan bu gaˈi du tuhutne, kuweˈ iye aˈa dupang maghinang lumaˈ diyataˈ umus. ");
INSERT INTO yka_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Manjari tekka ulanin duk dunuk boheˈin duk tewwaˈ lumaˈin weˈ baliyu mabasagin. Magtawus hebbaˈ lumaˈin duk jadjag teˈed.” ");
INSERT INTO yka_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagubus inin bissā si Isa, ulaliˈ meˈ aˈahin pagkalede usihatnen, ");
INSERT INTO yka_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","peggeˈ magbiddaˈ teˈed usihat si Isahin duk usihat meˈ guru si saraˈ āgamahin. Peggeˈ taga balakat si Isa bang iye missā. ");
INSERT INTO yka_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pagdurul si Isa amban diyataˈ kūd, asal banes manamal aˈa nuhut iye. ");
INSERT INTO yka_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Manjari, niyaˈ pī pu si Isa dambuwaˈ aˈa inipul. Nengge aˈahin duk tuˈutne magpadiyawaˈ pu si Isa duk paˈinne, “O Tuwan, bang kew mabayaˈ tapakawuliˈnu ku.” ");
INSERT INTO yka_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Pinasōng weˈ si Isa tangannen duk inantan weˈ ne aˈa inipulin, duk paˈinne, “Asal mabayaˈ ku. Kawuliˈan ne kew.” Magtawus kawuliˈan ipulnen. ");
INSERT INTO yka_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Paˈin si Isa si iye, “Pakale kew, daˈa kew magaka-aka bisan pu sine. Saguwaˈ pī kew, pakitehanun barannun si imamin duk magkuluban kew sa pangandaˈakan si Musahin, hinang tandaˈ si meˈ aˈahin weˈ asal kawuliˈan ne kew.” ");
INSERT INTO yka_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pagsakaliˈ si Isa padiyalem si puweblo Kapernaum, niyaˈ dambuwaˈ kapitan si armi bangsa Roma pasampang si iye māku tabang, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“O Tuwan, niyaˈ dambuwaˈ daraˈakanku si lumaˈ. Saki teˈed iye, gaˈi umusaˈ duk peddiˈan teˈed manamal.” ");
INSERT INTO yka_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Paˈin si Isa, “Aweˈ, nuhut ku kaˈu makoleˈ iye.” ");
INSERT INTO yka_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Saguwaˈ nambung kapitanin, paˈinne, “Tuwan, daˈa ne. Gaˈi ku pataˈ papituhannu si lumaˈku peggeˈ bangsahan kew teˈed. Missā kew hadja duk koleˈ du daraˈakankun. ");
INSERT INTO yka_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kataˈuhanku, peggeˈ bisan aku, pagbayaˈan ku weˈ malangkew amban akuhin duk magbayaˈ ku si meˈ sundalukun. Bang paˈinku si dangan, ‘Pī kew,’ na, pī iye. Bang paˈinku si seddili, ‘Pitu kew,’ pitu iye. Duk bang paˈinku si daraˈakankun, ‘Hinangun inin,’ hinangne ne.” ");
INSERT INTO yka_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagkale si Isa inin, ulaliˈ iye si binissā kapitanin. Manjari paˈinne si meˈ aˈa mapatuhut si iyehin, “Sabennal akahante kaˈam, bisan si bangsa Israˈil gaˈ ku bakas makadugpak aˈa kuweˈ kapitan inin asal sandel manamal. ");
INSERT INTO yka_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pakale kaˈam, si pasōngan ekka iyan aˈa bayuˈ-bayuˈan bangsa amban meˈ lahat silangan duk seddepan ningkoloˈ magkakanan duk disi Ibrahim, Isahak duk si Yakub laˈi dem pagbayaˈan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Saguwaˈ meˈ aˈa bangsa Israˈilin, siye subey meˈ maˈumasek dem pagbayaˈan Tuhanin, gaˈi siye umasek. Pinapī siye si luwasan dem kalindeman, pinatahalaˈ amban Tuhan. Magmatey siye laˈi duk magtageˈot meˈ impenden hawal pagsusunden.” ");
INSERT INTO yka_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ubus paˈin si Isa si kapitanin, “Pī ne kew hap lumaˈ. Tahinang ne si kaˈu sa kinahagadnun.” Manjari magtawus kawuliˈan daraˈakannen laˈi si lumaˈ. ");
INSERT INTO yka_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ubus hap pī si Isa padiyalem si lumaˈ si Petros. Takitene matoˈa si Petros dendehin pabāk laˈi, saki, ilemmun. ");
INSERT INTO yka_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Inantanan weˈ ne tangan dendehin, manjari kawuliˈan ne iye. Ubus dongaˈ iye duk pinakan siye weˈ ne. ");
INSERT INTO yka_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pagseddep ne ellewin, binoˈo weˈ meˈ aˈahin ekka meˈ aˈa pasayedan seyitan pu si Isa. Pinaluwas weˈ ne meˈ seyitanin amban pangandaˈakanne hadja. Duk pinakawuliˈ weˈ ne kēmon aˈa masakihin. ");
INSERT INTO yka_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hinangne inin duk tuman bissā Nabi Isaya dem kitabin, pinaˈin, “Iye mangānan peddiˈten bi duk iye mangānan sakiten bi.” ");
INSERT INTO yka_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pagkite si Isa meˈ aˈa mabanes mapaliput si iyehin, paˈinne si meˈ tindegnen, “Sūng kite bi palipag pī si dambiyaˈ lamew.” ");
INSERT INTO yka_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Gaˈ pe siye tumahalaˈ, niyaˈ tekka guru si saraˈ āgama pī pu si Isa, paˈinne, “Tuwan, mabayaˈ ku nuhut kaˈu tungan-tungan papīhannu.” ");
INSERT INTO yka_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nambung si Isa, paˈinne, “Gam pe meˈ pāhangin niyaˈ lowangde, duk meˈ manuk-manukin niyaˈ sabakande. Saguwaˈ aku, Anak Manusiyaˈin, gaˈ niyaˈ pahalihanku.” ");
INSERT INTO yka_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Niyaˈ isab dambuwaˈ meˈ manuhut si Isahin missā, paˈinne, “Tuwan, pī ku dahuˈ hap lumaˈ. Pagubus kubulku samakun, balik saˈ ku pitu nuhut kaˈu.” ");
INSERT INTO yka_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Saguwaˈ paˈin si Isa si iye, “Ambat mamateyin kinubul weˈ meˈ aˈa manggaˈ niyaˈ umulde salama-lamahin.” ");
INSERT INTO yka_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ubus miyaˈan, pasakey si Isa dem bangkaˈ duk nuhut du isab meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Manjari bessuwang nihup baliyu mabasagin hangkan piligdu teˈed bangkaˈin palenneb, saguwaˈ sasang tuli si Isa. ");
INSERT INTO yka_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pī meˈ tindegnen mangun si Isa, paˈinde, “Timbulun kite bi, Tuwan; matey kite bi inin.” ");
INSERT INTO yka_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Paˈinne si siye, “Weˈey kaˈam tinalew? Kulang sandelbi si akuhin.” Manjari dongaˈ si Isa duk daˈakne padeheng baliyuhin duk goyakin. Magtawus lamewin teddoˈ ne teˈed. ");
INSERT INTO yka_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ulaliˈ teˈed siye. “Aˈahey inin?” paˈinde. “Bisan baliyuhin duk goyakin nuhut pangandaˈakannen.” ");
INSERT INTO yka_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pagtekka disi Isa laˈi si dambiyaˈ lamew, laˈi si lahat meˈ aˈa Gadara, niyaˈ pasampang si iye duwe aˈa pasayedan meˈ seyitan. Paguwaˈ siye amban meˈ lingab pagkubulan. Laˈatan siye manamal, hangkan gaˈ niyaˈ bahani palabey billaˈi. ");
INSERT INTO yka_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Magtawus maggasud siye, paˈinde, “O Anak Tuhan, gaˈ niyaˈ lamudnu si kami. Pitu ke kew minasa kami bu gaˈ pe taˈabut janjiˈ kamihin?” ");
INSERT INTO yka_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Niyaˈ tala-tala billaˈi panenan bawi magsungkal. ");
INSERT INTO yka_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pabuyuˈ-buyuˈ meˈ seyitanin pu si Isa, paˈinde, “Bang daˈaknu kami tahalaˈ, padiyalemun kami magdem baran meˈ bawi miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Paˈin si Isa, “Pī ne kaˈam.” Manjari paluwas meˈ seyitanin amban aˈahin duk padiyalem siye pī magdem baran meˈ bawihin. Magtawus panenan bawihin magubas padurul pī si pampang magdem lamew duk lambo siye kēmon. ");
INSERT INTO yka_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Manjari meˈ aˈa magipat meˈ bawihin, magubas pī si puweblo, magaka-aka si meˈ aˈa malaˈihin sabab bakas hininang si Isa si meˈ aˈa pasayedan seyitanin. ");
INSERT INTO yka_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Manjari pī meˈ aˈa puweblo miyaˈan pu si Isa. Buyuˈ-buyuˈde si Isa dinaˈak tahalaˈ amban lahatde. ");
INSERT INTO yka_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pasakey si Isa magdem bangkaˈ duk palipag siye pī si dambiyaˈ lamew, pī balik si puweblone. ");
INSERT INTO yka_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Niyaˈ meˈ aˈa pī si iye moˈo aˈa matey barannen. Pabāk iye diyataˈ pabākanne. Pagtakite si Isa weˈ sandel teˈed siye si iye, paˈinne si aˈa mamatey barannen, “Pahāpun ateynun, bagay, taˈampun ne meˈ dusenun.” ");
INSERT INTO yka_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Niyaˈ laˈi meˈ guru si saraˈ āgama. Paˈinde dem ateyde, “Missā aˈa inin kuweˈ Tuhanin iye.” ");
INSERT INTO yka_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Saguwaˈ kataˈuhan si Isa bang ine pinikilden duk paˈinne si siye, “Weˈey teˈ laˈat tapikilbin? ");
INSERT INTO yka_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ine mamurahin, pinaˈin, ‘Inampun ne dusenun,’ atawa, ‘Dongaˈ kew bu nu ne lumengngan.’ ");
INSERT INTO yka_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pakoleˈku aˈa inin supaya kataˈuhanbi weˈ aku, Anak Manusiyaˈin, taga kapatut tuˈu si dunya ngampun meˈ duse.” Manjari paˈin si Isa si aˈa mamatey barannen, “Dongaˈ kew, boˈohun pabākannun bu nu ne hap lumaˈ.” ");
INSERT INTO yka_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Manjari dongaˈ aˈa masakihin duk hap lumaˈ ne iye. ");
INSERT INTO yka_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pagkite meˈ aˈahin miyaˈan, asekan talew siye. Pinudji weˈ de Tuhanin peggeˈ ngurung iye kapatut si manusiyaˈ ngahinang kuweˈ miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Palanjal ne si Isa billaˈi. Na, paglanjalne, ngite iye dambuwaˈ aˈa inēnan Mateo ningkoloˈ laˈi si upisinane pagbayed-bayedan sukeyin. Paˈin si Isa si iye, “Dayiˈ kew, nuhut kew aku.” Manjari kuwat si Mateo duk nuhut ne iye si Isa. ");
INSERT INTO yka_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Manjari mangan si Isa laˈi si lumaˈ Mateo. Ekka isab meˈ aˈa magpāku-pāku sukey duk meˈ aˈa dusehan sinduwehin hap pī duk ningkoloˈ siye mangan pasumbayaˈ pu si Isa duk meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Niyaˈ meˈ Pariseo laˈi. Pagkitede inin, paˈinde si meˈ tindeg si Isahin, “Weˈey gurubin palamud magkakanan duk meˈ aˈa magpāku-pāku sukey duk meˈ aˈa dusehan sinduwehin?” ");
INSERT INTO yka_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pagkale si Isa inin, paˈinne si siye, “Meˈ aˈa saki hep hap doktolin. Bang meˈ makoleˈin, gaˈ niyaˈ gunane hap doktol. ");
INSERT INTO yka_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hapalun bi bang ine hāti bissā inin tasulat dem kitab, pinaˈin, ‘Gaˈi mahalgaˈ si aku kulubanin. Saguwaˈ iye kabayaˈankun weˈ maˈaseˈ kaˈam si saweˈbi.’” Paˈin si Isa pe, “Dumaˈin ku pitu miha meˈ aˈa mabentelin, saguwaˈ pitu ku miha meˈ aˈa dusehanin.” ");
INSERT INTO yka_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Manjari hap pī meˈ tindeg Yahiyahin pu si Isa duk paˈinde, “Saˈingge iyan, kami duk meˈ Pariseohin magpuwase. Weˈey gaˈi magpuwase meˈ tindegnun?” ");
INSERT INTO yka_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sambungan si Isa siye si dalilan. Pasaliˈne meˈ tindegnen si meˈ aˈa si pagkawinan. Paˈinne, “Suse ke meˈ aˈa si pagkawinanin samantaˈan laˈi pe si siye pangantin lellahin? Gaˈi. Saguwaˈ si sinōng inin, bang ineddoˈ ne amban siye pangantin lellahin, meke ne siye muwase.” ");
INSERT INTO yka_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Manjari magdalilan si Isa sabab panoloˈ matuˈuhin duk panoloˈnen. Paˈinne, “Gaˈ niyaˈ aˈa matopak tela baˈahu, gaˈ pe kadekdakan, pī si semmek andang. Peggeˈ bang sa īˈne, garet balik semmek maˈandangin duk namba ngaluha garetnen.” ");
INSERT INTO yka_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pinasaliˈ isab weˈ si Isa toloˈnen si boheˈ ubas baˈahu inisi dem puyuˈ kuwit kambing. Paˈinne, “Gaˈ du isab niyaˈ ngisi boheˈ ubas baˈahu, mukal-mukal pe, dem puyuˈ andang. Peggeˈ bang sa īˈne, buslad puyuˈin. Manjari buˈus boheˈ ubasin duk magkaˈat puyuˈin. Saguwaˈ subey inisi boheˈ ubas baˈahuhin dem puyuˈ baˈahu. Manjari saliˈ-saliˈ siye gaˈi magkaˈat.” ");
INSERT INTO yka_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sasangne pe mamissā si siyehin, niyaˈ tekka pī dambuwaˈ nakuraˈ si langgal. Pasujud iye pu si Isa duk paˈinne, “Bahu matey du anakku dende-dendehin. Saguwaˈ bisan sa īˈen, dayiˈ kew bettadun tangannun si iye duk ellum du iye.” ");
INSERT INTO yka_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Manjari pī ne si Isa nuhut duk meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Manjari, niyaˈ laˈi dende saki, luwal paguwaˈan lahaˈ. Sampūˈ duk duwen tahun ne kemuwe kasakinen. Pī iye patapit si bukutan si Isa bu pī inantan weˈ ne tuggu badjuˈ si Isahin. ");
INSERT INTO yka_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Paˈinne dem pikilanne, “Bang hadja taˈantanku badjuˈnen asal kawuliˈan ku.” ");
INSERT INTO yka_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Manjari padeheng si Isa duk hinarap weˈ ne meˈ aˈa si dambulihannen. Pagkitene dendehin, paˈinne si iye, “Pahāpun ateynun, dende. Kawuliˈan ne kew peggeˈ sandel kew si aku.” Duk magtawus kawuliˈan dendehin. ");
INSERT INTO yka_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pagtekka si Isa laˈi si lumaˈ nakuraˈin, ngite iye meˈ aˈa magsuling duk banes aˈa magmatey. ");
INSERT INTO yka_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Paˈinne si siye, “Pī kaˈam tahalaˈ. Dumaˈin hep matey dendehin, saguwaˈ tuli hadja.” Pinagsayehan iye weˈ de. ");
INSERT INTO yka_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pagubus ne dinaˈak pabukut meˈ aˈahin, padiyalem si Isa si bilik dendehin duk inantan weˈ ne tangannen duk dongaˈ ne dendehin. ");
INSERT INTO yka_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Manjari, aka-aka sabab inin ngabawag si tibuˈukan lahat miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Palanjal ne si Isa billaˈi. Sasangne si lānin, niyaˈ duwe aˈa pessek paturul si iye. Ngalingan siye papales, paˈinde, “O tubuˈ Sultan Daˈud, maˈaseˈ ne kew si kami.” ");
INSERT INTO yka_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Manjari pagdiyalem si Isa dem lumaˈ, patapit pī si iye meˈ aˈa pessek miyaˈan. Paˈin si Isa si siye, “Kahagad ke kaˈam weˈ tapakawuliˈku kaˈam?” “Aweˈ, Tuwan,” paˈinde. ");
INSERT INTO yka_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Manjari inantan weˈ si Isa mataden. Paˈinne, “Tahinang ne si kaˈam sa kinahagadbin.” ");
INSERT INTO yka_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Manjari ngite ne siye. Sinessaˈan siye weˈ si Isa gaˈi dinaˈak magaka-aka bisan pu sine. ");
INSERT INTO yka_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Saguwaˈ tahalaˈ siye duk magaka-aka siye sabab si Isa si meˈ kalahat-lahatan laˈi. ");
INSERT INTO yka_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pagtahalaˈ meˈ aˈa miyaˈan, niyaˈ ne isab meˈ aˈa tekka pī duk niyaˈ aˈa umew binoˈo weˈ de. Puˈunne umew peggeˈ pasayedan seyitan iye. ");
INSERT INTO yka_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pagubus pinaluwas weˈ si Isa seyitanin, kapamissā ne aˈa maˈumewin. Ulaliˈ teˈed meˈ aˈa mabanesin. Paˈinde, “Gaˈ pe kite bi bakas ngite sa inin si kēmon lahat Israˈil.” ");
INSERT INTO yka_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Saguwaˈ paˈin meˈ Pariseohin, “Kaˈurungan iye balakat weˈ nakuraˈ meˈ seyitanin hangkan iye kapagpaluwas meˈ seyitan.” ");
INSERT INTO yka_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Manjari lumengngan si Isa ngalatag kēmon meˈ puweblohin duk meˈ kalumaˈanin. Magtoloˈ iye dem meˈ langgal duk magmahalayak iye aka-aka hāp sabab pagbayaˈ Tuhan si meˈ aˈahin. Pinakoleˈ weˈ ne meˈ aˈahin bisan ine bayuˈan sakiden. ");
INSERT INTO yka_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pagkitene meˈ aˈa mabanesin, maˈaseˈ iye manamal si siye, peggeˈ sasew siye bu gaˈ niyaˈ nabang siye. Kuweˈ siye meˈ bili-bili gaˈ niyaˈ ngipat siye. ");
INSERT INTO yka_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Manjari paˈinne si meˈ tindegnen, “Meˈ aˈahin kuweˈ dalil tanaˈ sarang ne pinagani. Luha tanaˈin saguwaˈ kulang mamaganihin. ");
INSERT INTO yka_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hangkan subey kaˈam māku-māku si Tuhan, iye dapuˈ tanaˈin, supaya iye ngandaˈak meˈ aˈa pī maganine.” ");
INSERT INTO yka_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Manjari ilinganan weˈ ne tindegne sampūˈ duk duwehin pī si iye duk inurungan siye weˈ ne kapatut magpaluwas meˈ seyitan duk magpakawuliˈ kēmon bayuˈ-bayuˈan saki. ");
INSERT INTO yka_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Inin ēn meˈ sampuk-duwe tindegne kawakilannen: kaˈissaˈ si Simon inēnan isab si Petros duk pungtinaˈinen si Andariyas, ubus si Yakub duk pungtinaˈinen si Yahiya, meˈ anak Sebedehin. ");
INSERT INTO yka_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Si Pilip duk Bartolome, si Tomas duk Mateo magpāku-pāku sukeyin, duk si Yakub anak Alpahin. Sinduwehin si Taddeo duk ");
INSERT INTO yka_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon, iye aˈa pangangatuhin, duk si Judas Iskariyot. Si Judas inin iye mamuddihan si Isahin. ");
INSERT INTO yka_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dinaˈak weˈ si Isa tindegne sampuk-duwe miyaˈan lumengngan. Sinessaˈan siye weˈ ne, paˈinne, “Daˈa kaˈam pī si lahat bangsa seddili atawa si meˈ puweblo bangsa Samariya. ");
INSERT INTO yka_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Saguwaˈ pī kaˈam si meˈ aˈa bangsa Israˈil hadja. Iyuˈ siye kuweˈ meˈ bili-bili lepas. ");
INSERT INTO yka_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pī kaˈam magmahalayak weˈ tapit ne waktu pagbayaˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pakoleˈun bi meˈ masakihin, pakellumun bi bang niyaˈ aˈa matey, pakoleˈun bi meˈ aˈa inipulin, paluwasun bi meˈ seyitanin. Inurungan kaˈam kapatut weˈ ku gaˈ kaˈam magbayed, hangkan nabang kaˈam gaˈi subey binayedan. ");
INSERT INTO yka_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Daˈa kaˈam magboˈo sīn, bisan sinsilyu dem sabitanbi. ");
INSERT INTO yka_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Daˈa kaˈam magboˈo bāg atawa badjuˈ pagsayinanbi atawa tehompaˈ atawa tungkud. Aˈa maghinangin subey tinabang sukalnen. ");
INSERT INTO yka_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pagtekka kaˈam si puweblo atawa kalumaˈan, miha kaˈam aˈa hāp addatnen. Laˈi kaˈam patennaˈ si iye tiggelanbi laˈi si lahat miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bang kaˈam manaˈik si lumaˈ, paˈinun bi, ‘Karayaw urungan Tuhanin kaˈam kasanyangan.’ ");
INSERT INTO yka_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bang kaˈam inaddatan weˈ aˈa lumaˈin, paˈamban du kasanyangan pinākubin si iye. Saguwaˈ bang gaˈi kaˈam inaddatan, gaˈ du niyaˈ kaˈujudan pinaˈinbi miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bang meˈ aˈahin gaˈi ngaddatan kaˈam duk gaˈi mabayaˈ pakale si kaˈam, tahalaˈ kaˈam amban lumaˈ miyaˈan atawa puweblo miyaˈan. Pagpaganun bi dahuˈ leppug bettisbin tandaˈ weˈ muwas ne kaˈam si siye, ubus bu tahalaˈ ne kaˈam. ");
INSERT INTO yka_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sabennal akahante kaˈam weˈ pagtaˈabut ellew pangahukum Tuhan manusiyaˈin, pasōng teˈed bohat hukuman si meˈ aˈa si puweblo miyaˈan amban hukuman si meˈ lahat Sodom duk Gomorahin, meˈ lahat mabawag sabab duse meˈ aˈanen.” ");
INSERT INTO yka_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pahatul-hatul kaˈam peggeˈ palengngante kaˈam pī si meˈ aˈa laˈatan. Kuweˈ kaˈam dalil meˈ anak bili-bili pī dem kaˈekkahan asu bingis. Hangkan subey lalem akkalbin duk hāp hadja dem ateybin. ");
INSERT INTO yka_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Papateng-pateng kaˈam peggeˈ niyaˈ iyan meˈ aˈa niggew kaˈam. Sōngande du kaˈam si meˈ hukum duk paglubakande kaˈam dem meˈ langgalde. ");
INSERT INTO yka_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Boˈode kaˈam si harapan meˈ gubnul duk meˈ sultan peggeˈ nuhut kaˈam aku duk kaˈam makapagaka aka-aka mahāpin si siye duk si meˈ aˈa bangsa seddili. ");
INSERT INTO yka_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bang kaˈam boˈode hinukum, daˈa kaˈam magsuse bang ine binissābin. Pinangurung du si kaˈam waktu miyaˈan bang ine binissābin. ");
INSERT INTO yka_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Peggeˈ dumaˈin amban kaˈam binissābin saguwaˈ iye mamissāhin, Niyawa Samabi Tuhanin maluˈu diyalem baranbin. ");
INSERT INTO yka_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Si pasōngan, niyaˈ iyan meˈ aˈa, sōngan meˈ pungtinaˈiden siye dinaˈak pinapatey. Niyaˈ isab iyan meˈ anak sōngan samaden siye dinaˈak pinapatey. Duk meˈ anakin bantahande matettoˈaden duk daˈakde matettoˈaden pinapatey. ");
INSERT INTO yka_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Duk kaˈam, meˈ tindegkun,” paˈin si Isa, “kabunsihan du kaˈam weˈ kēmon aˈa peggeˈ nuhut kaˈam aku. Saguwaˈ sine-sine nandal sampay si tamanan kabinasahan inin, taga umul du si surgaˈ gaˈ niyaˈ tamananne. ");
INSERT INTO yka_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bang kaˈam bininasa si puweblo dambuwaˈ, lahi kaˈam pī si puweblo seddili. Akahante kaˈam, gaˈi pe talatagbi magmahalayak si kēmon kalahat-lahatan si Israˈilin, pitu ne ku balik, aku Anak Manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mulidin gaˈi langkew amban gurunen. Duk daraˈakanin gaˈi langkew amban amunen. ");
INSERT INTO yka_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Hangkan mulidin subey magsukul bang saliˈ ne iye duk gurunen, duk daraˈakanin subey magsukul bang saliˈ ne iye duk amunen. Bang aku, panuhutanbin ēnande nakuraˈ seyitanin, pasōng pe laˈat pangēnde kaˈamin, meˈ tindegkun.” ");
INSERT INTO yka_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Daˈa kaˈam tinalew si aˈa. Gaˈ niyaˈ dinebbunan weˈ gaˈi ujud paguwaˈ, gaˈ niyaˈ tinapukan weˈ gaˈi ujud kataˈuhan. ");
INSERT INTO yka_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ine-ine akaku si kaˈam sangem, akahun bi bang ellew, duk ine-ine takalebi bang kaˈam hadja, palataˈun bi si meˈ aˈa si tabuˈan. ");
INSERT INTO yka_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Daˈa kaˈam tinalew si meˈ makapapatey baranin bu bang niyawahin gaˈi du tapapateyde. Saguwaˈ iye subey katalewanbin, Tuhanin, peggeˈ dumaˈin hadja baran saguwaˈ sampay niyawa makajari pakaˈatanne dem narkaˈ. ");
INSERT INTO yka_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Niyaˈ meˈ manuk-manuk dikiˈ tabellite duwek kayuˈ dambuwaˈ sīn. Bisan mura halgaˈden, gaˈ niyaˈ siye laboˈ si bulak bang gaˈi amban kabayaˈan Tuhan. ");
INSERT INTO yka_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na, pasōng ne kaˈam, gaˈi kaˈam takayipat weˈ Tuhanin. Bisan kōkbin kataˈuhanne bang piye lamba ekkahannen. ");
INSERT INTO yka_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hangkan daˈa kaˈam tinalew. Mahalgaˈ pe kaˈam amban meˈ manuk-manuk maˈekkahin.” ");
INSERT INTO yka_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Sine-sine magbennal si harapan aˈa weˈ patuhut iye si aku, asal magbennal du ku isab si harapan Tuhan, Samaku si surgaˈin, weˈ patuhut iye si aku. ");
INSERT INTO yka_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Saguwaˈ sine-sine masuwey si harapan aˈa weˈ gaˈi iye patuhut si aku, masuwey du ku isab si harapan Samaku si surgaˈin weˈ gaˈi iye patuhut si aku.” ");
INSERT INTO yka_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Weˈ kannalbi pitu ku moˈo kasanyangan si dunya? Gaˈi ku pitu moˈo kasanyangan saguwaˈ pitu ku moˈo jān pagsaggaˈan. ");
INSERT INTO yka_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sababku anak lellahin nguntarahan samanen duk anak dendehin nguntarahan saˈinen duk eyuˈan dendehin nguntarahan matoˈane dendehin. ");
INSERT INTO yka_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Aˈahin, iye bantane teˈedin meˈ usbanen. ");
INSERT INTO yka_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Bang aˈahin kalasahanne saˈi-samanen pasōng amban aku, gaˈi iye pataˈ manjari tindegku, duk bang aˈahin kalasahanne anaknen pasōng amban aku, gaˈi iye pataˈ manjari tindegku. ");
INSERT INTO yka_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bang aˈahin gaˈi nuhut aku duk moˈo olom pamapateyan iyehin, hātinen gaˈi iye maglillaˈ nandal kabinasahan duk bisan pe matey, gaˈi iye pataˈ manjari tindegku. ");
INSERT INTO yka_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bang aˈahin ellegne umulnen, gaˈ niyaˈ umulne salama-lama. Saguwaˈ bang aˈahin gaˈi ellegne umulnen duk maglillaˈ pe iye matey hawal tuyuˈne manuhut akuhin, taga umul du iye salama-lama.” ");
INSERT INTO yka_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Bang niyaˈ aˈa ngaddatan kaˈam, aku inaddatannen. Duk bang niyaˈ ngaddatan aku, addatanne isab Tuhanin, mamapitu aku si dunyahin. ");
INSERT INTO yka_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bang niyaˈ ngaddatan aˈa magpalataˈ bissā Tuhanin peggeˈ magpalataˈ hep iye bissā Tuhanin, tinumbasan du iye kuweˈ panumbas si aˈa magpalataˈ bissā Tuhanin. Bang niyaˈ ngaddatan aˈa bentel peggeˈ aˈa bentel iye, tinumbasan du iye kuweˈ panumbas si aˈa bentelin. ");
INSERT INTO yka_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Duk sine-sine ngurungan dambuwaˈ meˈ manuhut aku madiyawaˈ pagaˈanen bisan da sawan boheˈ peggeˈ nuhut aku iye, sabennal akahante kaˈam, asal tinumbasan teˈed iye hāp.” ");
INSERT INTO yka_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagubus inin tinoloˈan weˈ si Isa si meˈ tindegne sampuk-duwehin, tahalaˈ iye billaˈi duk hap pī iye si meˈ puweblo matapitin magtoloˈ duk magusihat laˈi. ");
INSERT INTO yka_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yahiya magpandi-pandi aˈahin kinalabusu ne. Kaˈakahan Yahiya sabab meˈ hinangan Almasihin ubus bu daˈakne meˈ tindegnen hap pī pu si Isa. ");
INSERT INTO yka_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Paglaˈi ne siye, tilewde si Isa bang iye ne ke bakas pinaˈal mapitu si dunyahin atawa bang niyaˈ pe ke seddili subey ase-asede pitu. ");
INSERT INTO yka_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Manjari sambungan si Isa meˈ tindeg Yahiyahin, paˈinne, “Pī ne kaˈam duk akahanun bi Yahiya meˈ bakas takalebi binissākun duk takitebi hininangkun. ");
INSERT INTO yka_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Akahanun bi iye weˈ ngite ne meˈ mapessekin, lumengngan ne meˈ makukuˈin, kawuliˈan ne meˈ inipulin, makakale ne meˈ mabisuhin, ellum ne balik meˈ mamateyin duk minahalayak ne aka-aka mahāpin si meˈ aˈa makaˈaseˈ-aseˈin. ");
INSERT INTO yka_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Duk kēgan du sasuku gaˈi magduwe-duwe si akuhin.” ");
INSERT INTO yka_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Paglumikut ne meˈ dinaˈak Yahiyahin, missā si Isa si meˈ aˈa mabanesin sabab Yahiya. Paˈinne, “Ine teˈ bakas kabayaˈanbi pinayamanin papībi pu si Yahiya si lahat makagindew-gindewin? Kabayaˈanbi ke pinayamanin aˈa gaˈi teteg pamikilnen kuweˈ dalil udjung-udjung magpalehan weˈ baliyu? ");
INSERT INTO yka_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Dumaˈin? Na, weˈey kaˈam hap pī? Mayaman aˈa magsemmek mahalgaˈ? Meˈ aˈa magsemmek mamahalgaˈin laˈi patennaˈanden dem meˈ astanaˈ. ");
INSERT INTO yka_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na, weˈey teˈ kaˈam hap pī? Mayaman nabi? Aweˈ, akahante kaˈam nabi takitebin pasōng amban nabi sinduwehin. ");
INSERT INTO yka_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Si Yahiya hep inin aˈa sinulat dem kitabin, pinaˈin laˈi, ‘Paˈin Tuhanin, daˈakku pī pamasanankun dehellu amban kaˈu duk memesne lānnun.’ ");
INSERT INTO yka_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sabennal, akahante kaˈam,” paˈin si Isa, “gaˈ niyaˈ aˈa bakas inanakan tuˈu si dunya bangsahan amban Yahiya magpandi-pandi aˈahin. Saguwaˈ dem pagbayaˈan Tuhanin bisan aˈahin diyawaˈ teˈed pagaˈanen, bangsahan pe iye amban Yahiya. ");
INSERT INTO yka_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kemuwe tagnaˈ magmahalayak si Yahiya sampay maˈin, basag pagmahalayak sabab pagbayaˈan Tuhanin, duk meˈ aˈahin magtuyuˈ teˈed duk siye umasek pī si pagbayaˈan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Meˈ kanabihanin duk saraˈ si Musahin magaka sabab pagbayaˈan Tuhanin ngeregseˈ katekka Yahiyahin. ");
INSERT INTO yka_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Bakas pinaˈal hep weˈ pitu balik si dunya Nabi Eliyas. Bang kaˈam mabayaˈ kahagad si bissā meˈ kanabihanin, si Yahiya ne hep si Nabi Eliyas. ");
INSERT INTO yka_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Amey-amey pakalehun bi bang niyaˈ pinaˈin si kaˈam. ");
INSERT INTO yka_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Manjari,” paˈin si Isa, “ine pangandalilanku meˈ aˈa ellum kuweˈitu inin? Kuweˈ siye mākanak magtingkoloˈ si tabuˈan magdagey magkawin duk magkubul. Maglingan siye si meˈ saweˈden, paˈinde, ");
INSERT INTO yka_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Magtambul kami si kaˈam, saguwaˈ gaˈ du kaˈam mansak. Magmatey kami saguwaˈ gaˈ du kaˈam magtangis.’ ");
INSERT INTO yka_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kuweˈ kaˈam mākanak miyaˈan. Peggeˈ pitu Yahiya bu daran iye muwase duk gaˈi iye nginum makalango, na, paˈin meˈ aˈahin weˈ pasayedan seyitan iye. ");
INSERT INTO yka_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ubus aku, Anak Manusiyaˈin, pitu ku bu mangan ku duk nginum, na, paˈin meˈ aˈahin, ‘Payamanun bi aˈa iyan, dahagaˈ teˈed duk palalango. Meˈ bagaynen meˈ aˈa magpāku-pāku sukey duk meˈ aˈa dusehan sinduwehin.’ Saguwaˈ,” paˈin si Isa, “meˈ hinangan Tuhanin naksiˈ weˈ lalem teˈed kataˈu Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Manjari nagnaˈ inamāhan weˈ si Isa meˈ aˈa si meˈ puweblo bakas pangahinanganne meˈ hinanganne maˈekka makaˈulaliˈin, peggeˈ gaˈ pindahande ateyden. ");
INSERT INTO yka_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Paˈinne, “Kaˈaseˈ-aseˈ kaˈam meˈ aˈa Korasinin. Kaˈaseˈ-aseˈ kaˈam meˈ aˈa Betsaidahin. Peggeˈ bang laˈi miyaˈan si lahat Tiros duk Sidon pangahinanganku meˈ hinangan makaˈulaliˈ tahinangku luˈu si kaˈamin, tiggel ne miyaˈan meˈ aˈa malaˈihin magsusun duk lebbahande duseden duk sa addatden magsemmek karut siye duk mandi duk abu pamakitede pagsusunden. ");
INSERT INTO yka_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Akahante kaˈam, pagtaˈabut ellew pangahukum Tuhan manusiyaˈin, pasōng teˈed bohat hukuman si kaˈamin amban hukuman si meˈ aˈa Tiros duk Sidonin. ");
INSERT INTO yka_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Duk kaˈam, meˈ aˈa Kapernaumin,” paˈin si Isa, “kannalbi pinalangkew kaˈam pī si surgaˈ? Pinadiyawaˈ du kaˈam pī dem narkaˈ. Bang meˈ aˈa si Sodomin takitede meˈ hinangan makaˈulaliˈ takitebin, tuˈu pe siˈ lahatden ngeregseˈ kuweˈitu. ");
INSERT INTO yka_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Akahante kaˈam,” paˈin si Isa, “weˈ pagtaˈabut ellew pangahukum Tuhan manusiyaˈin, pasōng teˈed bohat hukuman si kaˈamin amban hukuman si lahat Sodomin, lahat mabawag sabab duse meˈ aˈanen.” ");
INSERT INTO yka_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Manjari, waktu miyaˈan paˈin si Isa, “O Ammaˈ, kaˈu magbayaˈ si langit duk bulakin. Pudjite kew teˈed peggeˈ urungannu kataˈu meˈ aˈa maˈawamin duk tapukannu kataˈu inin amban meˈ aˈa malangkew pangadjiˈnen duk amban meˈ makasabutin. ");
INSERT INTO yka_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aweˈ, Ammaˈ, asal pudjite kew peggeˈ kuweˈ inin kinabayaˈannun.” ");
INSERT INTO yka_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Duk paˈin si Isa pe, “Bakas pinangandel ne si aku kēmon-kēmonin weˈ Samaku Tuhanin. Gaˈ niyaˈ ngataˈuhan bang sine ku, aku Anak Tuhanin, luwal hadja Samaku Tuhanin. Duk gaˈ isab niyaˈ ngataˈuhan bang sine Samakun, luwal hadja aku, Anaknen duk sine-sine pineneˈku pamakilalehanku Samakun. ");
INSERT INTO yka_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Pitu kaˈam si aku, sine-sine kaˈam pekkeng duk kabohatan supaya kaˈam humali. ");
INSERT INTO yka_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tayimaˈun bi panoloˈkun duk ngaya kaˈam amban aku, peggeˈ hāp ku duk diyawaˈ ateykun, manjari humali ne dem ateybin. ");
INSERT INTO yka_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Peggeˈ pangandaˈakankun mura tinuhut duk gaˈi hunit hininang.” ");
INSERT INTO yka_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dambuwaˈ Sabtuˈ, ellew liˈi meˈ Yahudihin, pabutas disi Isa dem tanaˈ. Peggeˈ inusan meˈ tindegnen, ngalupuˈ siye buwaˈ tanaˈin bu inintaˈ weˈ de. ");
INSERT INTO yka_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pagkite meˈ Pariseohin miyaˈan, paˈinde pu si Isa, “Payamanun be. Meˈ tindegnun hinangde tinaggahan saraˈ si ellew liˈihin.” ");
INSERT INTO yka_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Paˈin si Isa si siye, “Gaˈ ke bakas tabatsabi bang ine hininang Sultan Daˈudin masaley paginusan iye duk meˈ saweˈnen? ");
INSERT INTO yka_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Padiyalem hep iye pī si lumaˈ Tuhanin duk ineddoˈ weˈ ne pan binettad laˈi pangurung si Tuhanin duk kinakan weˈ ne duk meˈ saweˈnen. Bu tinaggahan hep weˈ saraˈ kinakan pan miyaˈan, luwal hadja para si meˈ imam. ");
INSERT INTO yka_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Duk gaˈ ke isab tabatsabi dem kitab Tawrat weˈ meˈ imam si langgal hadjehin maghinang kahabaˈ ellew liˈi bisan tinaggahan maghinangin weˈ saraˈ? Saguwaˈ gaˈi du siye magduse. ");
INSERT INTO yka_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Akahante kaˈam, niyaˈ ne tuˈu pasōng kapatutnen amban saraˈ si langgal hadjehin. ");
INSERT INTO yka_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Niyaˈ tasulat dem kitab, pinaˈin, ‘Gaˈi mahalgaˈ si aku kulubanin saguwaˈ iye kabayaˈankun weˈ maˈaseˈ kaˈam si saweˈbi.’ Bang tasabutbi teˈed hātine inin, gaˈi laboˈanbi hukuman aˈa manggaˈ niyaˈ dusenen. ");
INSERT INTO yka_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aku, Anak Manusiyaˈin, taga kapatut ku magpaˈin bang ine-ine mapatut hininang si ellew liˈihin.” ");
INSERT INTO yka_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Manjari palanjal si Isa billaˈi duk padiyalem iye dem langgalde. ");
INSERT INTO yka_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Laˈi dem langgal niyaˈ aˈa sapik tangannen. Niyaˈ isab laˈi meˈ aˈa batang miha duse si Isa supaya iye katuntutande. Hangkan tilewde iye, paˈinde, “Ngalanggalan saraˈ ke magpakoleˈ si ellew liˈihin?” ");
INSERT INTO yka_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nambung si Isa, paˈinne, “Ine hinangbi bang upama niyaˈ bili-bilibi dambuwaˈ du bu laboˈ pe dem kupung baytu ellew liˈi? Gaˈi ke eddoˈbi maluwas bisan ne ellew liˈi? ");
INSERT INTO yka_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pasōng hep mahalgaˈ aˈahin amban bili-bili. Hangkan patut maghinang makahāp si ellew liˈi.” ");
INSERT INTO yka_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Manjari paˈinne si aˈa masapik tangannen, “Pahintengun tangannun.” Na, pinahinteng weˈ ne, manjari kawuliˈan ne tangannen kuweˈ tanganne dambuwaˈin. ");
INSERT INTO yka_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Manjari paluwas meˈ Pariseohin amban langgal duk magisun siye bang saˈingge si Isa tapapateyde. ");
INSERT INTO yka_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pagkataˈuhan si Isa sabab isun meˈ Pariseohin, tahalaˈ iye amban lahat miyaˈan. Ekka aˈa paturul si iye. Pinakawuliˈ weˈ ne kēmon meˈ aˈa masakihin ");
INSERT INTO yka_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","duk sinessaˈan siye weˈ ne gaˈi dinaˈak magaka-aka sabab iye. ");
INSERT INTO yka_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sabab inin, tuman ne bissā Tuhan sinulat weˈ Nabi Isayahin, pinaˈin, ");
INSERT INTO yka_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Inin daraˈakanku bakas pineneˈkun. Kalasahanku iye duk kasulutan ku teˈed si iye. Papīku Niyawakun si iye duk magmahalayak du iye sabab hukumanku mabentelin si kēmon bangsa. ");
INSERT INTO yka_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Gaˈi iye iyan magsasaˈ atawa maggasud duk gaˈi iye missā papales si meˈ lān. ");
INSERT INTO yka_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Asigne meˈ makulang sandelnen duk tabangne meˈ aˈa gaˈ ne teˈed niyaˈ ase-asede. Gaˈi iye padeheng samantaˈan gaˈi tadaˈag kēmon malaˈatin. ");
INSERT INTO yka_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iye pangandelan kēmon kabangsahan si dunyahin.” ");
INSERT INTO yka_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Manjari, niyaˈ binoˈo pī pu si Isa dambuwaˈ aˈa pessek duk umew peggeˈ pasayedan seyitan iye. Kawuliˈan iye weˈ si Isa, hangkan kapamissā ne iye duk ngite ne iye. ");
INSERT INTO yka_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kēmon aˈahin ulaliˈ duk paˈinde, “Inin ne enteˈ tubuˈ Sultan Daˈudin?” ");
INSERT INTO yka_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pagkale meˈ Pariseohin inin, paˈinde, “Kaˈurungan iye balakat weˈ Belsebul, nakuraˈ meˈ seyitanin, hangkan iye kapagpaluwas meˈ seyitan.” ");
INSERT INTO yka_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kataˈuhan si Isa bang ine dem pikilanden, hangkan paˈinne si siye, “Bang niyaˈ pagsultanan bu magbonoˈ meˈ aˈanen, magkaˈat pagsultanan miyaˈan. Duk bang meˈ aˈa si dambuwaˈ puweblohin atawa meˈ magtewtey-anakin gaˈi magtuhut pikilan saguwaˈ luwal magsasaˈ, ujudnen magkanat-kanat siye. ");
INSERT INTO yka_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Hangkan bang nakuraˈ seyitanin maluwas tindegne seyitanin, hātinen weˈ magkuntara ne siye duk gaˈi layun pagbayaˈan seyitanin. ");
INSERT INTO yka_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Paˈinbi weˈ magpaluwas ku seyitan peggeˈ kaˈurungan ku balakat weˈ Belsebul, nakuraˈ seyitanin. Bang bennal inin, na, meˈ tindegbin, amban balakat sine pagpaluwasde seyitanin? Siye ne iyan magpaˈinin weˈ salaˈ pamikilbin. ");
INSERT INTO yka_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Saguwaˈ iye matoˈohin, asal amban Niyawa Tuhanin balakatku magpaluwas seyitanin. Hātine inin, Tuhanin magbayaˈ ne tuˈu si kaˈam. ");
INSERT INTO yka_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nakuraˈ seyitanin, dalilnen aˈa basag. Gaˈ niyaˈ tapī ngahawas si lumaˈ aˈa basag bang gaˈi dahuˈ ingketanne aˈa mabasag miyaˈan, ubus meke ne iye tapangahawas.” ");
INSERT INTO yka_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Paˈin si Isa pe, “Manggaˈi mamēbbegan akuhin nguntarahan aku. Duk manggaˈi manabangan aku magtipunin, nganat-nganat du. ");
INSERT INTO yka_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hangkan hep akahante kaˈam,” paˈin si Isa, “ampun Tuhanin du kēmon duse aˈahin duk meˈ bissāde kupul si Tuhanin. Saguwaˈ bang missā siye kupul si Niyawa Sutsihin, asal gaˈi teˈed siye inampun. ");
INSERT INTO yka_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sine-sine missāhan aku, Anak Manusiyaˈin laˈat, makajari du iye inampun, saguwaˈ bang Niyawa Sutsihin binissā-bissāhannen, asal gaˈi teˈed iye inampun bisan sumiyan-sumiyan.” ");
INSERT INTO yka_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Bang upama hāp kayuhin, hāp isab buwaˈnen. Damikkiyan bang gaˈi hāp kayuhin, gaˈi hāp buwaˈnen. Kayuhin kataˈuhan si buwaˈne. ");
INSERT INTO yka_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kaˈam iyan meˈ aˈa pangakkal. Gaˈi kaˈam makabissā hāp peggeˈ laˈat dem ateybin. Ine-ine dem atey manusiyaˈ, iye miyaˈan mapaluwas amban behenen. ");
INSERT INTO yka_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Aˈa mahāpin, hāp kawul-piˈilnen duk hāp bissānen peggeˈ hāp dem ateynen. Saguwaˈ aˈa malaˈatin, peggeˈ laˈat dem ateynen hangkan gaˈi hāp kawul-piˈilnen duk bissānen. ");
INSERT INTO yka_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Akahante kaˈam, bang tekka ne ellew pangahukum Tuhan manusiyaˈin, subey ne meˈ aˈahin magaka sabab kēmon bakas binissāde manggaˈ niyaˈ gunanen. ");
INSERT INTO yka_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Amban meˈ bissānun kataˈuhan bang ine hukuman si kaˈuhin, bang inampun ke kew atawa ilegga.” ");
INSERT INTO yka_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Manjari, niyaˈ meˈ guru si saraˈ āgama duk meˈ Pariseo laˈi duk paˈinde pu si Isa, “Tuwan, mabayaˈ kami ngite tandaˈ balakatnun.” ");
INSERT INTO yka_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Saguwaˈ sambunganne siye, paˈinne, “Kaˈam meˈ aˈa maˈellum kuweˈitu inin laˈat kaˈam duk gaˈi kaˈam nuhut Tuhan. Makapakite tandaˈ hatiˈ kaˈam. Saguwaˈ gaˈ niyaˈ tandaˈ pinakitehan si kaˈam luwal hadja tandaˈ Nabi Yunus awwalley. ");
INSERT INTO yka_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Peggeˈ kuweˈ Nabi Yunusin laˈi dem betteng kenna mahadjehin tellu ellew duk tellu sangem, damikkiyan aku, Anak Manusiyaˈin, si sinōng laˈi ku dem bulak tellu ellew duk tellu sangem. ");
INSERT INTO yka_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bang tekka ellew pangahukum Tuhan meˈ manusiyaˈin, pī iyan nengge meˈ aˈa si lahat Niniba awwalley duk taksilde kaˈam. Peggeˈ siye, pagsusunande duk lebbahande duseden sakaliˈ takalede usihat Nabi Yunusin. Akahante kaˈam, kuweˈitu niyaˈ tuˈu si kaˈam pasōng langkew amban Nabi Yunus, saguwaˈ gaˈi tayimaˈbi panoloˈnen duk gaˈi pagsusunanbi dusebin. ");
INSERT INTO yka_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bang tekka ellew pangahukum Tuhan meˈ manusiyaˈin, pī iyan nengge sultan dende amban lahat Seba masa awwalley duk taksilne kaˈam. Peggeˈ iye, pitu iye amban higad dunya peggeˈ bayaˈ pakalene meˈ bissā Sultan Sulaimanin, aˈa lalem teˈed kataˈunen masaley. Akahante kaˈam, kuweˈitu niyaˈ tuˈu si kaˈam pasōng kataˈunen amban Sulaiman, saguwaˈ gaˈi tayimaˈbi panoloˈnen.” ");
INSERT INTO yka_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Bang niyaˈ seyitan,” paˈin si Isa, “paluwas amban aˈa, maglengngan-lengngan iye dem lahat makagindew-gindew miha pahalihanne, saguwaˈ gaˈi iye ngasuwaˈ. ");
INSERT INTO yka_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Manjari paˈinne dem pikilanne, ‘Tiyaˈ ku balik pī si bakas patennaˈankun.’ Pagtekkane laˈi takitene weˈ gaˈ niyaˈ patennaˈ laˈi duk bakas pinahidan ne duk memes ne. ");
INSERT INTO yka_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ubus pī iye ngeddoˈ pituˈ meˈ seyitan seddili, pasōng pe laˈatden amban iye, duk paˈasek siye kēmon pī dem baran aˈahin patennaˈ laˈi. Kaˈujudan aˈa miyaˈan, pasōng pe laˈatan maˈumantag si iye kuweˈituhin amban tagnaˈin. Kuweˈ iyan du isab maˈumantag si meˈ aˈa malaˈat kuweˈitu inin.” ");
INSERT INTO yka_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sasang si Isa pe mamissā si meˈ aˈahin, tekka saˈinen duk meˈ pungtinaˈine lellahin laˈi si bukut. Batang boˈode si Isa magbissā. ");
INSERT INTO yka_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Manjari niyaˈ ngakahan iye, paˈinne, “Tuwan, īˈ laˈi saˈinun duk meˈ pungtinaˈinun si bukut miha kaˈu.” ");
INSERT INTO yka_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Saguwaˈ paˈin si Isa si mangakahan iyehin, “Sine saˈikun duk sine meˈ pungtinaˈikun?” ");
INSERT INTO yka_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Manjari tinoloˈ weˈ ne meˈ tindegnen, paˈinne, “Siye inin saˈikun duk meˈ pungtinaˈikun. ");
INSERT INTO yka_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Peggeˈ sasuku maghinang kinabayaˈan Samaku malaˈi si surgaˈin, iye iyan pungtinaˈiku lella duk pungtinaˈiku dende duk saˈiku.” ");
INSERT INTO yka_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ellew miyaˈan hap pī si Isa si higad lamew Jalil ningkoloˈ magtoloˈ. ");
INSERT INTO yka_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Banes aˈa patipun si iye laˈi. Hangkan pasakey iye duk ningkoloˈ iye dem bangkaˈ. Meˈ aˈa mabanesin nengge laˈi si higad lamew. ");
INSERT INTO yka_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Magusihat iye si meˈ aˈahin duk ekka usihatne si dalilan. Paˈinne, “Niyaˈ aˈa pī si tanaˈne magsabulak binihiˈ. ");
INSERT INTO yka_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pagsabulakne, niyaˈ binihiˈ tapisik si 1ān. Manjari pī meˈ manuk-manukin manganne. ");
INSERT INTO yka_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Meˈ binihiˈ sinduwehin laboˈ diyataˈ batu pānas, gaˈi lalem bulaknen. Mura tomoˈ binihiˈin peggeˈ gaˈi lalem bulaknen. ");
INSERT INTO yka_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pagsilak ellewin magtawus ngingking duk peggeˈ gaˈi lalem gamutnen, manjari lanes. ");
INSERT INTO yka_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Laboˈ binihiˈ sinduwehin dem kasampinitan. Samet nulig sampinitin duk katalungan tinanemin. ");
INSERT INTO yka_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Na, binihiˈ sinduwehin laboˈ si kahāpan bulak duk moˈo buwaˈne. Jarinen niyaˈ ne ekka manamal, niyaˈ ne ekka, duk niyaˈ isab sarang-sarang. ");
INSERT INTO yka_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Amey-amey pakalehun bi bang niyaˈ pinaˈin si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Manjari hap pī si iye meˈ tindegnen duk paˈinde, “Weˈey kew magdalilan bang kew magtoloˈ?” ");
INSERT INTO yka_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sambungan si Isa siye, paˈinne, “Kaˈurungan ne kaˈam kataˈu supaya tahātibi meˈ tinapukan Tuhan dem pikilannen sabab bang saˈingge pagbayaˈne si meˈ aˈanen. Saguwaˈ meˈ aˈa sinduwehin gaˈ kaˈurungan. ");
INSERT INTO yka_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Peggeˈ aˈahin, bang pakale pahāp-hāp, pasōng pangahātinen. Saguwaˈ bang aˈahin gaˈi pakale pahāp-hāp, bisan niyaˈ kataˈuhanne kuweˈahat, ujud tahalaˈ du amban iye. ");
INSERT INTO yka_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Inin sababnen hangkan ku magdalilan bang ku magtoloˈ si siye, peggeˈ mayam siye saguwaˈ gaˈi takitede, duk pakale siye saguwaˈ gaˈi takalede teˈed duk gaˈi tasabutde. ");
INSERT INTO yka_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na, tuman ne tasulat Nabi Isaya dem kitabin, pinaˈin, ‘Asal pakale du kaˈam saguwaˈ gaˈi tahātibi. Asal mayam du kaˈam saguwaˈ gaˈi takilalebi. ");
INSERT INTO yka_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Peggeˈ ngatuwas ne atey meˈ aˈa inin. Tampengde tayingeden duk pakeddemde mataden. Bang dumaˈin hinanganden sa iyan, takitede siˈ duk matade, takalede siˈ duk tayingede, tasabutde siˈ dem ateyde duk pabalik siˈ siye si aku, paˈin Tuhanin, duk ampunku siˈ meˈ duseden.’ ");
INSERT INTO yka_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Saguwaˈ bang kaˈam, asal hāp pe kaˈam,” paˈin si Isa, “peggeˈ takilalebi takitebin duk tahātibi takalebin. ");
INSERT INTO yka_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sabennal akahante kaˈam, ekka meˈ nabi duk meˈ aˈa sukuˈ si Tuhan awwalley mabayaˈ teˈed ngite takitebi kuweˈitu inin, saguwaˈ gaˈ inin takitede. Mabayaˈ teˈed isab takalede meˈ takalebi kuweˈitu inin, saguwaˈ gaˈ takalede.” ");
INSERT INTO yka_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kuweˈitu pakale teˈed kaˈam duk tasabutbi bang ine hāti dalilan sabab aˈa magsabulak binihiˈin. ");
INSERT INTO yka_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Meˈ binihiˈ tapisik si lānin dalil meˈ aˈa makakale lapal sabab pagbayaˈan Tuhanin bu gaˈ tasabutde. Manjari pī nakuraˈ seyitanin ngagew lapalin amban dem pikilan meˈ aˈa miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Meˈ binihiˈ malaboˈ diyataˈ batu pānasin dalil meˈ aˈa makakale lapal Tuhanin duk magtawus kinahagad weˈ de duk kēgan siye. ");
INSERT INTO yka_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Saguwaˈ gaˈ nganggamut palalem lapal Tuhanin dem ateyde. Hangkan gaˈ siye makatatas tiggel. Pagtekka kasusehanin atawa bang bininasa siye sabab panuhutde lapalin, gaˈi ne siye kahagad. ");
INSERT INTO yka_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Duk meˈ binihiˈ malaboˈ dem kasampinitanin dalil meˈ aˈa makakale lapal Tuhanin, saguwaˈ luwal siye mikil sabab kasusehande si dunyahin. Iye mamahalgaˈ si siyehin meˈ pangalataˈden. Hangkan bang dalil tinanemin, katalungan lapal Tuhan bakas takaleden duk gaˈ magbuwaˈ. ");
INSERT INTO yka_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Duk meˈ sinabulakan dem bulak mahāpin, siye dalil meˈ aˈa makakale lapal Tuhanin duk kinahagad weˈ de. Bang dalil tinanemin, lapal Tuhan bakas takaleden magbuwaˈ diyalem ateyde. Sinduwehin buwaˈnen ekka manamal, sinduwehin ekka, duk sinduwehin sarang-sarang.” ");
INSERT INTO yka_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Manjari magdalilan ne isab si Isa si meˈ aˈahin, paˈinne, “Pagbayaˈ Tuhan si meˈ aˈanen kuweˈ dalil binihiˈ sabulakan aˈa dem tanaˈne. ");
INSERT INTO yka_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dambuwaˈ sangem sasang tuli ne kēmon aˈahin, hap pī bantanen bu binubudan weˈ ne bigi sabet pinaturul si binihiˈin, ubus bu tahalaˈ iye. ");
INSERT INTO yka_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Manjari pagtomoˈ ne binihiˈin duk nagnaˈ ne buwaˈ, takite isab meˈ sabetin. ");
INSERT INTO yka_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Meˈ daraˈakannen pī si dapuˈ tanaˈin duk paˈinde, ‘O Tuwan, hāp hep meˈ binihiˈ tinanemnu si tanaˈnun. Amban meˈ sabet miyaˈan?’ ");
INSERT INTO yka_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nambung dapuˈ tanaˈin, paˈinne, ‘Hinangan bantakun iyan.’ Paˈin meˈ daraˈakannen, ‘Mabayaˈ ke kew bang kami harap pī meddutan meˈ sabet miyaˈan?’ ");
INSERT INTO yka_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Daˈa,’ paˈinne, ‘peggeˈ bang beddutbi sabetin, kaw tabeddut tinanemin isab. ");
INSERT INTO yka_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ambat siye nulig kaduwe sampay pagani. Manjari pagtaˈabut ne pinagani, paˈinku saˈ si meˈ mamaganihin: Beddutun bi dahuˈ meˈ sabet iyan duk pekkesun bi bu bi ne ngeggasne. Ubus bu paganihun bi ne buwaˈ tanaˈin duk ennaˈun bi dem kamaligku.’” ");
INSERT INTO yka_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ubus magdalilan iye balik si siye, paˈinne, “Pagbayaˈ Tuhan si meˈ aˈanen kuweˈ dalil da bayuˈ bigi dikiˈ-dikiˈ tinanem weˈ aˈa si tanaˈne. ");
INSERT INTO yka_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nahut manamal bigi inin saguwaˈ bang nulig ne, ngahadje amban kēmon jambangan duk manjari kayu ne. Hangkan makajari meˈ manuk-manukin pī ngahinang sabakande diyataˈ meˈ pangene.” ");
INSERT INTO yka_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Magdalilan pe iye seddili, paˈinne, “Pagbayaˈ Tuhan si meˈ aˈanen kuweˈ dalil pasulig ineddoˈ weˈ dende bu pinasaget weˈ ne dem tirigu duwempuk-lime kilu. Ubus inaddun weˈ ne. Ubus nulig ne kēmon addunin.” ");
INSERT INTO yka_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kahabaˈ si Isa magtoloˈ si meˈ aˈa mabanesin, magdalilan hadja iye. Gaˈ iye missā si siye bang dumaˈin si dalilan. ");
INSERT INTO yka_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na, tuman ne sinulat dambuwaˈ nabi dem kitabin, pinaˈin, “Magdalilan ku bang ku magtoloˈ si siye. Akahanku siye sabab meˈ manggaˈ kinataˈuhan kemuwe tagnaˈ pinapanjari dunyahin.” ");
INSERT INTO yka_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Manjari inambanan weˈ si Isa meˈ aˈa mabanesin duk padiyalem iye dem lumaˈ. Hap pī isab meˈ tindegnen duk paˈinde si iye, “Pahātihanun koˈ kami dalilan sabab sabet si tanaˈin.” ");
INSERT INTO yka_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nambung iye, paˈinne, “Aku, Anak Manusiyaˈin, dalil aˈa magsabulak binihiˈ mahāpin. ");
INSERT INTO yka_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tanaˈin dunyahin. Hāti binihiˈ mahāpin, meˈ aˈa manuhut pagbayaˈan Tuhanin. Sabetin meˈ aˈa manuhut nakuraˈ seyitanin. ");
INSERT INTO yka_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Banta aˈahin, bakas mamubudan sabetin, iye nakuraˈ seyitanin. Waktu pagpaganihin, hātinen bang kiyamat ne dunyahin. Mamaganihin meˈ malaˈikatin. ");
INSERT INTO yka_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na, bang sabetin, tinipun du hadja duk ineggas. Kuweˈ miyaˈan du isab maˈumantagin bang taˈabut ne ellew kiyamat. ");
INSERT INTO yka_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aku, Anak Manusiyaˈin, daˈakku du meˈ malaˈikatkun pitu dem dunya nipun kēmon meˈ aˈa makapaduse saweˈden duk kēmon meˈ aˈa maghinangan malaˈatin. ");
INSERT INTO yka_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Duk ilakasan du siye dem ebbut narkaˈ. Magmatey siye iyan laˈi duk magtageˈot meˈ impenden hawal pagsusunden. ");
INSERT INTO yka_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Saguwaˈ meˈ aˈa sukuˈ si Tuhanin sahaya kuweˈ mata ellewin laˈi si pagbayaˈan Samade Tuhanin. Amey-amey pakalehun bi bang niyaˈ pinaˈin si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Magdalilan ne isab si Isa, paˈinne, “Pagbayaˈ Tuhan si meˈ aˈanen kuweˈ dalil alataˈ tinapukan dem bulak bu takasuwaˈ weˈ dambuwaˈ aˈa. Dinebbunan balik weˈ ne duk kēgan iye manamal hangkan pinabellihan weˈ ne kēmon-kēmonnen. Ubus bu binelli weˈ ne bulak palaˈihan alataˈ takasuwaˈne miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Damikkiyan,” paˈin si Isa, “pagbayaˈ Tuhan si meˈ aˈanen kuweˈ dalil aˈa magpiha, batang melli meˈ mutsaˈ hāp. ");
INSERT INTO yka_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bang iye ngasuwaˈ dambuwaˈ mutsaˈ mahalgaˈ manamal, pabellihanne kēmon-kēmonnen duk belline mutsaˈ dambuwaˈ miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Damikkiyan,” paˈin si Isa, “pagbayaˈ Tuhan si meˈ aˈanen kuweˈ dalil pokot tineppadan dem tahik duk makaˈeddoˈ ekka bayuˈ-bayuˈan kenna. ");
INSERT INTO yka_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pagpennoˈ ne pokotin, onot meˈ aˈahin ne tudju higad tahik ubus ningkoloˈ siye bu peneˈde kennahin. Meˈ kenna mahāpin pinadem pangisihande duk meˈ manggaˈi mahāpin ilakasan hadja. ");
INSERT INTO yka_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sa iyan du isab bang kiyamat ne. Paguwaˈ meˈ malaˈikatin duk paseddilide meˈ aˈa malaˈatin amban meˈ aˈa mabentelin. ");
INSERT INTO yka_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Meˈ aˈa malaˈatin laboˈde dem ebbut narkaˈ. Magmatey siye iyan laˈi duk magtageˈot meˈ impenden hawal pagsusunden.” ");
INSERT INTO yka_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tinilew weˈ si Isa meˈ tindegnen, paˈinne, “Tasabutbi ke kēmon binissāku si kaˈam miyaˈan?” “Aweˈ,” paˈinde. ");
INSERT INTO yka_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Manjari paˈin si Isa, “Bang niyaˈ guru si saraˈ āgama bu nuhut ne iye pagbayaˈan Tuhanin, kuweˈ dalil aˈa dayahan iye, ekka alataˈne magbaˈahu-andang peggeˈ taˈu ne iye manoloˈ toloˈ matuˈuhin duk toloˈ baˈahuhin.” ");
INSERT INTO yka_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pagubus si Isa magdalilan inin, tahalaˈ iye amban lahat miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hap pī iye balik si lahatne duk magusihat iye laˈi dem langgal. Ulaliˈ meˈ aˈahin, paˈinde, “Amban taˈeddoˈ aˈa inin kataˈunen duk balakatne paghinangne meˈ hinangan makaˈulaliˈin? ");
INSERT INTO yka_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Takilalete bi hep aˈa inin; iye inin anak kalpenterohin. Saˈinen si Mariyam. Pungtinaˈine hep disi Yakub duk si Yoses duk si Simon duk si Judas. ");
INSERT INTO yka_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Duk meˈ pungtinaˈine dendehin tiyaˈ du hep tuˈu si lahatte bi. Amban enteˈ taˈeddoˈne meˈ kataˈune inin?” ");
INSERT INTO yka_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Duk peddiˈ ateyde pu si Isa. Manjari paˈin si Isa si siye, “Pagaddatan nabihin antag-antag. Saguwaˈ bang si lahatne duk si lumaˈne gaˈi iye pagaddatan.” ");
INSERT INTO yka_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Gaˈi du ekka hinangan makaˈulaliˈ hininang si Isa si lahatnen peggeˈ meˈ aˈa malaˈihin gaˈi kahagad si iye. ");
INSERT INTO yka_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Masa miyaˈan Sultan Herod magbayaˈ si lahat Jalilin. Manjari takalene sabab meˈ hinangan si Isahin. ");
INSERT INTO yka_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Paˈin si Herod si meˈ bagellalnen, “Aˈa miyaˈan asal iye ne teˈed si Yahiya magpandi-pandi meˈ aˈahin. Ellum iye balik. Hangkan hep tahinangne meˈ hinangan balakatan miyaˈ an.” ");
INSERT INTO yka_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Peggeˈ bakas dinaˈak hep weˈ Sultan Herod siniggew si Yahiya duk iningketan duk kinalabusu. Kuweˈ inin kahalanne miyaˈan: Si Sultan Herod inin magkabayaˈ duk ipalnen Herodiyas, bu ellum pe salinen si Pilip, ella Herodiyasin. Manjari sakaliˈ ne siye magdambuwaˈ, inamāhan sultanin weˈ si Yahiya. Paˈin Yahiya si iye, “Gaˈi halal bang kew magdambuwaˈ duk anda pungtinaˈinun. Magduse kew.” ");
INSERT INTO yka_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kemuwe miyaˈan mabayaˈ papatey si Herod Yahiya, saguwaˈ tinalew iye si meˈ aˈahin peggeˈ kahagad meˈ aˈahin weˈ nabi si Yahiya. ");
INSERT INTO yka_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Manjari dambuwaˈ ellew ngahinang si Herod pagjamu-jamuhan panābu ellew panganak si iyehin. Mansak anak Herodiyas dendehin duk mayam meˈ aˈa malaˈihin. Sinna manamal si Herod ");
INSERT INTO yka_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hangkan paˈinne si dendehin, “Sapahanku ine-ine pākunu, asal pangurungku teˈed kaˈu.” ");
INSERT INTO yka_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Peggeˈ bakas sinessaˈan andang weˈ saˈinen dendehin, hangkan paˈinne si sultanin, “Pangurungun aku kuweˈitu kōk Yahiya magpandi-pandi aˈahin binettad diyataˈ talam.” ");
INSERT INTO yka_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Magsusun teˈed sultanin, saguwaˈ peggeˈ bakas iye napa si panaˈanan meˈ bisitanen, hangkan dinaˈak ne weˈ ne pinangurung si dendehin pinākunen. ");
INSERT INTO yka_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Dinaˈak weˈ ne dambuwaˈ sundalunen munggelan Yahiya laˈi dem kalabusu. ");
INSERT INTO yka_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ubus binoˈo ne kōknen diyataˈ talam duk pinangurung si budjangin. Manjari binoˈo weˈ budjangin pī si saˈinen. ");
INSERT INTO yka_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pagubus miyaˈan, tekka meˈ tindeg Yahiyahin ngeddoˈ bangkeynen duk kinubul weˈ de. Ubus hap pī siye ngakahan si Isa. ");
INSERT INTO yka_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pagkale si Isa aka-aka sabab Yahiyahin, tahalaˈ iye magbangkaˈ pī si lahat makagindew-gindew, iye dendangan. Sakaliˈ inin takale weˈ meˈ aˈa mabanesin, tahalaˈ siye amban meˈ kalumaˈanin duk paturul siye amban higad lamew. ");
INSERT INTO yka_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagtakas si Isa, banes teˈed aˈa kitene duk maˈaseˈ iye si siye duk pinakoleˈ weˈ ne meˈ masakihin. ");
INSERT INTO yka_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pagkohap ne, pī meˈ tindegnen si iye duk paˈinde, “Lahat gaˈi hep inin tantu papituhan aˈa bu iyuˈ ne kohap teˈed. Daˈakun meˈ aˈa inin pī si meˈ kalumaˈan duk siye makabelli kinakande.” ");
INSERT INTO yka_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Paˈin si Isa, “Gaˈi siye subey tahalaˈ. Kaˈam ne mamakan siyehin.” ");
INSERT INTO yka_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Paˈin meˈ tindegnen, “Luwal maniyaˈ si kamitu, lime kayuˈ pan duk duwe kenna.” ");
INSERT INTO yka_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Paˈin si Isa, “Boˈohun bi pitu si aku.” ");
INSERT INTO yka_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Manjari dinaˈak weˈ si Isa meˈ aˈahin ningkoloˈ diyataˈ balili. Ubus miyaˈan ineddoˈ weˈ ne pan lime kayuˈin duk kenna duwehin duk mayam iye magdiyataˈ langit magpasalamat si Tuhan. Ubus bu binahagiˈ-bahagiˈ weˈ ne panin duk pinangurung weˈ ne si meˈ tindegnen duk pangurungde isab si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mangan siye kēmon duk esso siye. Pagubus siye mangan tinipun weˈ meˈ tindeg si Isahin lukasden, sampūˈ duk duwe bakaˈ pennoˈ. ");
INSERT INTO yka_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Meˈ aˈa bakas mamanganin niyaˈ siye lime ngibu lellahin bukut meˈ dendehin duk meˈ mākanakin. ");
INSERT INTO yka_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Puwas miyaˈan dinaˈak weˈ si Isa meˈ tindegnen pasakey dem bangkaˈ. Pinadehellu siye weˈ ne pī si dambiyaˈ lamew sābune pe mapoleˈ meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pagubus ne siye patahalaˈne, pī iye si punu dendang-dendangan missā si Tuhan. Pagsangem ne, laˈi iye dendangan. ");
INSERT INTO yka_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na, bangkaˈin tala ne amban higad bu tewwaˈ weˈ goyak peggeˈ pasumbal si siye baliyuhin. ");
INSERT INTO yka_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pagdayiˈ ellew ne, pī si Isa si siye lumengngan diyataˈ kuwit-kuwit lamewin. ");
INSERT INTO yka_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pagkite meˈ tindegnen iye lumengngan diyataˈ kuwit-kuwit lamewin, kadahitan siye manamal peggeˈ kannalde weˈ panyataˈ iye. Magkilahap teˈed siye peggeˈ kaˈumagadan siye. ");
INSERT INTO yka_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Saguwaˈ magtawus missā si Isa si siye, paˈ inne, “Pahagetun bi ateybin. Aku hep ituˈ. Daˈa kaˈam tinalew.” ");
INSERT INTO yka_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Manjari ngalingan si Petros, paˈinne, “Tuwan, bang kaˈu iyan, daˈakun ku piyu si kaˈu lumengngan diyataˈ boheˈ.” ");
INSERT INTO yka_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Paˈin si Isa, “Pitu ne kew.” Hangkan duwaˈi si Petros amban bangkaˈ bu lumengngan diyataˈ boheˈ hap pī pu si Isa. ");
INSERT INTO yka_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Saguwaˈ pagkitene goyak mahadjehin, tinalew iye duk palenneb ne iye. Magtawus iye ngalingan, paˈinne, “Tuwan, timbulun ku.” ");
INSERT INTO yka_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Manjari magtawus iye inantan weˈ si Isa bu inonot. Ubus paˈin si Isa, “Gaˈi kew tantu sandel si aku. Weˈey magduwe-duwe pikilannun?” ");
INSERT INTO yka_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Manjari pagdiyalemde dem bangkaˈ, padeheng ne baliyuhin. ");
INSERT INTO yka_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pasujud si iye meˈ lella dem bangkaˈin duk paˈinde, “Bennal Anak Tuhanin kew.” ");
INSERT INTO yka_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pagsakaliˈ ne siye lumipag, tekka siye si lahat Gennesaret. ");
INSERT INTO yka_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Takilale si Isa weˈ meˈ aˈa lahat miyaˈan, hangkan pinasan weˈ de meˈ aˈa masaki si meˈ kalahatan mapaliputin duk binoˈo weˈ de pu si Isa. ");
INSERT INTO yka_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pabuyuˈ-buyuˈ siye pu si Isa bang makajari antan meˈ masakihin bisan hadja tuggu semmeknen. Na, kēmon makaˈantan iyehin kawuliˈan. ");
INSERT INTO yka_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Manjari niyaˈ meˈ Pariseo duk meˈ guru si saraˈ āgama amban Awrusalam hap pī pu si Isa duk paˈinde, ");
INSERT INTO yka_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Weˈey meˈ tindegnun gaˈi nuhut biˈat-biˈatan meˈ kapapuˈanten bi? Mangan siye bisan siye gaˈ bakas ngosoˈ tangan makasutsi.” ");
INSERT INTO yka_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nambung si Isa, paˈinne, “Na, kaˈam, weˈey gaˈi tuhutbi pangandaˈakan Tuhanin supaya iye tatuhutbin meˈ biˈat-biˈatan kapapuˈanbin? ");
INSERT INTO yka_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Peggeˈ bakas ngandaˈak Tuhanin, paˈinne, ‘Pagaddatanun bi saˈi-samabin,’ duk ‘Sine-sine missāhan saˈinen atawa samanen laˈatan, subey teˈed iye pinapatey.’ ");
INSERT INTO yka_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Saguwaˈ kaˈam,” paˈin si Isa, “si saraˈ hininang-hinangbin hadja, paˈinbi weˈ bang niyaˈ aˈa magpaˈin si saˈi-samanen, ‘Gaˈ ne niyaˈ panabangku kaˈam, Ammaˈ atawa Inaˈ; tapangurungku ne alataˈkun si Tuhan,’ ");
INSERT INTO yka_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","makajari ne bisan gaˈi tabangne matettoˈanen. Sa hinanganbi iyan gaˈi pinagmasi weˈ bi pangandaˈakan Tuhanin peggeˈ iye tinuhutbin meˈ biˈat-biˈatan kapapuˈanbin. ");
INSERT INTO yka_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kaˈam iyan magmā-mā nuhut Tuhan bu gaˈi du. Asal bennal teˈed sinulat Nabi Isaya sabab kaˈamin, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Meˈ aˈa inin, pahadjede ku duk behede saguwaˈ ateyden gaˈi nuhut aku. ");
INSERT INTO yka_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gaˈ gunane pagsambahayangde si akuhin peggeˈ meˈ pamanoloˈden hinang-hinang aˈa hadja bu paˈinde amban aku,’ paˈin Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Puwas miyaˈan, ilinganan ne isab weˈ si Isa meˈ aˈahin pī si iye duk paˈinne si siye, “Pakale kaˈam duk tahātibi bissāku inin: ");
INSERT INTO yka_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dumaˈin kinakan mapadiyalem dem behe aˈahin makaharam iyehin, saguwaˈ iye makaharam iyehin meˈ bissā laˈatan mapaguwaˈ amban behenen.” ");
INSERT INTO yka_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Manjari hap pī meˈ tindegnen si iye duk paˈinde, “Kataˈuhannu ke weˈ laˈat atey meˈ Pariseohin sabab binissānu miyaˈan?” ");
INSERT INTO yka_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nambung iye, paˈinne, “Kēmon jambangan gaˈ tinanem weˈ Samaku si surgaˈin bineddutan du. ");
INSERT INTO yka_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Daˈa kaˈam suse sabab siye. Meˈ nakuraˈ siye saguwaˈ kuweˈ siye meˈ aˈa pessek. Bang aˈa pessekin nundan aˈa pessek du isab, na, laboˈ siye kaduwangan dem lowang.” ");
INSERT INTO yka_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Manjari missā si Petros, paˈinne, “Pahātihanun kami bang ine hāti binissānu miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Paˈin si Isa, “Sampay kaˈam isab, gaˈi pe tahātibi? ");
INSERT INTO yka_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Gaˈi ke tahātibi weˈ bisan kinakan ine padiyalem dem behe, pī dem betteng ubus bu pinaluwas du? ");
INSERT INTO yka_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Saguwaˈ mapaluwas amban dem behe aˈahin, paguwaˈ amban dem ateyne, duk iye iyan makaharam aˈahin. ");
INSERT INTO yka_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Peggeˈ amban dem ateyin paguwaˈ meˈ pikilan malaˈatanin kuweˈ mapatey, magjina, duk maghinangan laˈat seddili, magtangkew, magdustaˈ, duk maglimut. ");
INSERT INTO yka_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kēmon iyan makaharam aˈahin, dumaˈin bang mangan iye bu gaˈ bakas ngosoˈ tangan sa pangandaˈakan meˈ Pariseohin.” ");
INSERT INTO yka_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Manjari tahalaˈ si Isa billaˈi duk hap pī iye si antag puweblo Tiros duk Sidon. ");
INSERT INTO yka_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Niyaˈ dende bangsa Kanaˈan patennaˈ laˈi si lahat miyaˈan. Hap pī iye pu si Isa duk ngalingan iye, paˈinne, “O Tuwan, tubuˈ si Daˈud, maˈaseˈ kew si aku, peggeˈ anakku dende-dendehin pasayedan seyitan duk tiniksaˈ teˈed iye weˈ seyitanin.” ");
INSERT INTO yka_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Saguwaˈ gaˈ nambung si Isa bisan da tegtang. Manjari meˈ tindegnen pī pu si Isa duk paˈinde, “Daˈakun iye tahalaˈ, peggeˈ iyuˈ iye paturul-turul ngalingan si kite bi.” ");
INSERT INTO yka_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nambung si Isa, paˈinne, “Pinapitu ku nabang meˈ aˈa bangsa Israˈil hadja. Kuweˈ siye dalil meˈ bili-bili lepas.” ");
INSERT INTO yka_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Saguwaˈ pagtakale inin weˈ dendehin, patapit iye pu si Isa bu pasujud, paˈinne, “Tuwan, tabanganun ku.” ");
INSERT INTO yka_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sambungan si Isa iye si dalilan, paˈinne, “Gaˈi patut ineddoˈ kinakan meˈ anakin bu ilakasan pī si meˈ asu.” ");
INSERT INTO yka_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Bennal, Tuwan,” paˈin dendehin, “saguwaˈ bisan du meˈ asuhin kakande du mapagpag amban lamisahanin.” ");
INSERT INTO yka_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sambungan si Isa iye, paˈinne, “O dende, basag teˈed sandelnun. Pangurung kaˈu ne pinākunun.” Na waktu miyaˈan du magtawus kawuliˈan anakne dendehin. ");
INSERT INTO yka_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Manjari palanjal si Isa billaˈi bu nusul lamew Jalilin. Ubus manaˈik iye diyataˈ punu duk ningkoloˈ iye laˈi. ");
INSERT INTO yka_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Banes aˈa hap pī si iye, duk binoˈo weˈ de meˈ mapengkaˈin, meˈ makukuˈin, meˈ mapessekin, meˈ maˈumewin duk ekka aˈa taga saki seddili. Pinapī weˈ de meˈ aˈa masaki inin si antag bettis si Isa duk pinakawuliˈ siye kēmon weˈ ne. ");
INSERT INTO yka_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ulaliˈ teˈed meˈ aˈahin pagkitede weˈ maˈumewin makabissā ne, makukuˈin kawuliˈan ne, mapengkaˈin makalengngan ne pahāp-hāp, duk mapessekin ngite ne. Manjari pinudji weˈ de Tuhan inisbat bangsa Israˈilin. ");
INSERT INTO yka_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Manjari ilinganan weˈ si Isa meˈ tindegnen pī si iye duk paˈinne, “Maˈaseˈ ku si meˈ aˈa mabanes inin, peggeˈ tellum bahangi ne kuweˈitu patuˈude si akuhin bu gaˈ ne niyaˈ kakande. Gaˈi ku mabayaˈ mapoleˈ siye bang gaˈi bakas mangan, kaw siye kinawugtuˈ si lān.” ");
INSERT INTO yka_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Paˈin meˈ tindegnen si iye, “Antag kite bi ngeddoˈ kinakan sarang pamakan meˈ aˈa mabanes inin tuˈu si lahat makagindew-gindew inin?” ");
INSERT INTO yka_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Paˈin si Isa si siye, “Piyek kayuˈ panbi lu?” Paˈinde, “Pituˈ pan duk kenna dikiˈ bang piyek kayuˈ.” ");
INSERT INTO yka_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Manjari dinaˈak weˈ si Isa meˈ aˈa mabanesin ningkoloˈ diyataˈ bulak. ");
INSERT INTO yka_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ineddoˈ weˈ ne pan pituˈin duk meˈ kennahin, duk magpasalamat iye si Tuhan. Ubus bu binahagiˈ-bahagiˈ weˈ ne duk pinangurung weˈ ne si meˈ tindegnen duk pangurungde isab si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mangan siye kēmon duk esso siye. Ubus bu tinipun weˈ de lukasin, pituˈ bakaˈ pennoˈ. ");
INSERT INTO yka_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Meˈ aˈa mamanganin niyaˈ siye ampat ngibu lellahin bukut meˈ dendehin duk meˈ mākanakin. ");
INSERT INTO yka_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Manjari pinapoleˈ ne meˈ aˈahin weˈ si Isa duk pasakey iye dem bangkaˈ bu hap pī si lahat Magadan. ");
INSERT INTO yka_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Manjari niyaˈ meˈ Pariseo duk meˈ Sadduseo pī pu si Isa. Batang iye kuhi-kuhide, hangkan makapakite siye tandaˈ bang bennal taga kapatut iye amban Tuhan. ");
INSERT INTO yka_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sambungan si Isa siye, paˈinne, “Bang seddep ellewin paˈinbi, ‘Hāp lahatin sumu, peggeˈ peyat-peyat langitin.’ ");
INSERT INTO yka_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bang salung-salung paˈinbi, ‘Ulan ellew inin peggeˈ peyat-peyat langitin duk maglindem lahatin.’ Kataˈuhanbi hatiˈ bang ine hāti meˈ tapandogabi si bantuk langitin saguwaˈ gaˈi kataˈuhanbi hāti meˈ maˈumantag si waktu kuweˈitu inin. ");
INSERT INTO yka_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Meˈ aˈa kuweˈitu inin laˈat duk gaˈi nuhut Tuhan duk māku tandaˈ. Saguwaˈ gaˈ niyaˈ tandaˈ pinakitehan si kaˈam luwal hadja tandaˈ Nabi Yunus awwalley.” Ubus miyaˈan inambanan siye weˈ si Isa bu tahalaˈ iye. ");
INSERT INTO yka_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pagtekka meˈ tindeg si Isahin si dambiyaˈ lamew, gaˈ siye makaˈesseb moˈo pan. ");
INSERT INTO yka_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Paˈin si Isa si siye, “Pahatul-hatul kaˈam. Halliˈanun bi pasulig meˈ Pariseohin duk meˈ Sadduseohin.” ");
INSERT INTO yka_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Magbissā-bissā meˈ tindegnen sabab pinaˈinne miyaˈan peggeˈ gaˈ tahātide. Paˈinde, “Hangkan hatu iye missā kuweˈ miyaˈan, peggeˈ gaˈ kite bi makaboˈo pan.” ");
INSERT INTO yka_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kataˈuhan si Isa bang ine pagbissā-bissāden. Hangkan paˈinne si siye, “Weˈey pagbissā-bissābin sabab gaˈ niyaˈ panbi? Asal kulang teˈed sandelbi si akuhin. ");
INSERT INTO yka_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gaˈi pe ke tahātibi? Gaˈ ke taˈessebbi pamahagiˈ-mahagiˈku pan limehin si meˈ aˈa lime ngibuhin duk bang piye bakaˈ pennoˈ weˈ lukas tinipunbin? ");
INSERT INTO yka_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Duk gaˈ ke taˈessebbi pan pituˈ binahagiˈ-bahagiˈku si meˈ aˈa ampat ngibuhin duk bang piye bakaˈ pennoˈ weˈ lukas tinipunbin? ");
INSERT INTO yka_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ulaliˈ ku bang weˈey gaˈ tasabutbi weˈ bissāku miyaˈan dumaˈin sabab pan. Halliˈanun bi pasulig meˈ Pariseohin duk meˈ Sadduseohin.” ");
INSERT INTO yka_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Manjari bahu tahātide weˈ dumaˈin pinaˈinnen sabab pasulig dem pan, saguwaˈ subey halliˈande meˈ panoloˈ meˈ Pariseohin duk meˈ Sadduseohin. ");
INSERT INTO yka_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Manjari pī disi Isa si lahat tapit si puweblo Kesarea Pilipi. Paglaˈi siye tinilew weˈ ne meˈ tindegnen, paˈinne, “Ine paˈin meˈ aˈahin? Aku, Anak Manusiyaˈin, sine koˈ ku?” ");
INSERT INTO yka_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Paˈinde, “Niyaˈ meˈ aˈa magpaˈin weˈ kaˈu koˈ si Yahiya magpandi-pandi meˈ aˈahin ellum balik. Sinduwehin isab magpaˈin weˈ Nabi Eliyas koˈ kew duk niyaˈ pe isab magpaˈin weˈ Nabi Jeremiya koˈ kew atawa dambuwaˈ meˈ nabi awwalley.” ");
INSERT INTO yka_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Saguwaˈ bang kaˈam,” paˈin si Isa, “ine paˈinbi? Sine teˈ ku?” ");
INSERT INTO yka_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nambung si Simon Petros, paˈinne, “Kaˈu Almasihin, tapeneˈ Tuhan magbayaˈin. Kaˈu Anak Tuhan maˈellumin.” ");
INSERT INTO yka_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Paˈin si Isa si iye, “Hāp pe kew, Simon, anak Yahiyahin. Peggeˈ dumaˈin amban manusiyaˈ puˈunnu ngataˈuhanne inin saguwaˈ pinakataˈu inin si kaˈu weˈ Samaku si surgaˈin. ");
INSERT INTO yka_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na, inin paˈinku si kaˈu, Petros. Kuweˈ batu kew, duk diyataˈ batu inin hinangku langgalkun, hāti langgalkun meˈ aˈa manuhut akuhin. Gaˈi siye tadaˈag weˈ nakuraˈ seyitanin. ");
INSERT INTO yka_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Urungante kew kapatut magmahalayak si kēmon manusiyaˈ aka-aka hāp sabab pagbayaˈ Tuhanin. Kuweˈ kew dalil kaˈurunganku kunsiˈ gawang padiyaleman pī si pagbayaˈan Tuhanin. Ine-ine pamagesannu tuˈu si dunya, pamagesan du isab iyan si surgaˈ, duk ine-ine pangandaˈakannu tuˈu si dunya, pangandaˈakan du isab iyan si surgaˈ.” ");
INSERT INTO yka_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Manjari sinessaˈan weˈ si Isa meˈ tindegnen weˈ subey siye gaˈi magaka-aka bisan pu sine weˈ Almasihin iye. ");
INSERT INTO yka_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Manjari puwas miyaˈan, nagnaˈ pahāti si Isa si meˈ tindegnen weˈ iye kahandak Tuhanin, subey iye hap pī si Awrusalam duk ekka kabinasahan sandalanne amban meˈ kabahiˈanin duk meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin. Ubus pinapatey du iye duk ellum du iye balik katellum bahanginen. ");
INSERT INTO yka_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Binoˈo si Isa weˈ si Petros patala-tala bu inamāhan iye weˈ ne, paˈinne, “Karayaw gaˈi paˈatag Tuhanin, Tuwan. Gaˈi iyan umantag si kaˈu.” ");
INSERT INTO yka_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Saguwaˈ paharap si Isa duk paˈinne pu si Petros, “Tahalaˈ kew amban aku, Seyitan. Iyuˈ kew nassat aku si kalaˈatan, peggeˈ pikilannun pikilan amban manusiyaˈ hadja dumaˈin amban Tuhan.” ");
INSERT INTO yka_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ubus paˈinne si meˈ tindegnen, “Bang niyaˈ aˈa mabayaˈ nuhut aku subey iye tuhutne kinabayaˈankun dumaˈin kinabayaˈannen. Duk subey isab iye moˈo olom pamapateyan iyehin, hātinen maglillaˈ iye nandal kabinasahan duk bisan pe matey. Manjari makajari ne iye nuhut aku. ");
INSERT INTO yka_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Peggeˈ,” paˈin si Isa, “bang aˈahin ellegne umulnen, gaˈ niyaˈ umulne salama-lama. Saguwaˈ bang aˈahin gaˈi ellegne umulnen duk maglillaˈ pe iye matey hawal tuyuˈne manuhut akuhin, na, aˈa iyan taga umul du salama-lama. ");
INSERT INTO yka_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Peggeˈ aˈahin, bisan pe tepe si iye kēmon alataˈ dem dunyahin, gaˈ du niyaˈ gunane bang gaˈi tepe si iye umul salama-lamahin. Peggeˈ gaˈ niyaˈ alataˈ si dunya makalekkat iye supaya tepe si iye umul salama-lamahin. ");
INSERT INTO yka_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aku, Anak Manusiyaˈin, pitu du ku balik duk meˈ malaˈikatkun, liput weˈ sahaya Samaku Tuhanin. Ubus tumbasanku du kēmon aˈahin matalep si meˈ hinanganden.” ");
INSERT INTO yka_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Paˈin si Isa pe, “Sabennal akahante kaˈam, niyaˈ kaˈam matuˈu inin gaˈi matey bang gaˈi dahuˈ takitebi ku, Anak Manusiyaˈin, pitu magbayaˈ si meˈ aˈahin.” ");
INSERT INTO yka_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Manjari ennem bahangi puwas miyaˈan, binoˈo weˈ si Isa si Petros, si Yakub, duk si Yahiya pī diyataˈ punu langkew, siye-siye hadja. ");
INSERT INTO yka_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sābude malaˈihin, pinda teˈed bantuk si Isahin si pagmatahande. Luwenen sahaya kuweˈ mata ellewin duk semmeknen makasilew hawal poteˈnen. ");
INSERT INTO yka_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Manjari bessuwang paguwaˈ si siye laˈi si Musa duk si Nabi Eliyas duk magbissā siye duk si Isa. ");
INSERT INTO yka_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sābude magbissāhin, paˈin si Petros pu si Isa, “Tuwan, hāp teˈed peggeˈ tiyaˈ kami tuˈu. Bang kew mabayaˈ, ngahinang ku tuˈu tellu payad. Dambuwaˈ si kaˈu, dambuwaˈ pu si Musa, duk dambuwaˈ pu Nabi Eliyas.” ");
INSERT INTO yka_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Manjari sasang missā pe si Petros, niyaˈ inalak dantaˈ paguwaˈ si atagde duk kalandungan siye duk niyaˈ suwala amban inalakin magpaˈin, “Inin Anakku kalasahanku teˈed. Kasulutan ku teˈed si iye. Pakalehun bi iye.” ");
INSERT INTO yka_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagkale meˈ tindegnen suwala miyaˈan, kadahitan siye manamal duk magtawus siye pakusu diyataˈ bulak. ");
INSERT INTO yka_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Saguwaˈ pī si Isa si meˈ tindegnen duk inantan siye weˈ ne, paˈinne, “Nengge kaˈam duk daˈa kaˈam tinalew.” ");
INSERT INTO yka_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pagtongasde, gaˈ niyaˈ seddili kitede luwal saˈ si Isa. ");
INSERT INTO yka_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Manjari sasangde padurul amban diyataˈ punu, sinessaˈan siye weˈ si Isa, paˈinne, “Daˈa kaˈam magaka-aka sabab bakas takitebi diyataˈ punu inin, samantaˈan aku, Anak Manusiyaˈin, gaˈi pe ku ellum balik amban kamateykun.” ");
INSERT INTO yka_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tinilew iye weˈ meˈ tindegnen, paˈinde, “Weˈey teˈ paˈin meˈ guru magtoloˈ saraˈ āgamahin weˈ subey koˈ pitu dehellu Eliyas meke Almasihin?” ");
INSERT INTO yka_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nambung si Isa, paˈinne, “Bennal iyan. Eliyas pitu dehellu amban Almasihin manyap kēmonin. ");
INSERT INTO yka_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Saguwaˈ akahante kaˈam,” paˈin si Isa, “bakas pitu ne Eliyas bu gaˈ iye takilale meˈ aˈahin. Duk tahinangde ne sasuku kabayaˈanden si iye. Damikkiyan aku, Anak Manusiyaˈin, binasade du ku isab.” ");
INSERT INTO yka_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na, bahu kataˈuhan meˈ tindegnen weˈ bissānen hatiˈ sabab Yahiya magpandi-pandi meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pagbalik disi Isa pī si meˈ aˈa mabanesin, niyaˈ aˈa pī pasujud pu si Isa makitabang, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“O Tuwan, maˈaseˈ kew si anakkun. Binabuy-babuy iye duk makalanduˈ sakinen peggeˈ daran iye hebbaˈ dem ebbut duk dem boheˈ. ");
INSERT INTO yka_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Bakas boˈoku iye pī si meˈ tindegnun, saguwaˈ gaˈi iye tapakawuliˈde.” ");
INSERT INTO yka_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nambung si Isa, paˈinne, “Kaˈam meˈ aˈa kuweˈitu inin, salaˈ teˈed pamikilbin. Gaˈ teˈed niyaˈ sandelbi si Tuhan. Taman sumiyan pe ku tuˈu si kaˈam? Taman sumiyan pe ku nandalan addatbin meke kaˈam kahagad?” Manjari paˈinne si sama nakanakin, “Boˈohun anaknun pitu.” ");
INSERT INTO yka_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pagtekka nakanakin laˈi, inamāhan weˈ si Isa seyitanin, manjari paluwas seyitanin amban nakanakin duk magtawus nakanakin kawuliˈan. ");
INSERT INTO yka_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ubus binoˈo si Isa magbissā weˈ meˈ tindegnen, siye-siye hadja, paˈinde, “Weˈey teˈ gaˈ tapaluwas kami seyitanin?” ");
INSERT INTO yka_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Paˈin si Isa, “Puˈunne gaˈi tapaluwasbi peggeˈ kulang pe teˈed sandelbi si Tuhanin. Akahante kaˈam sabennal-bennal, bang sandel kaˈam si Tuhan bisan hadja kuweˈahat, dalilnen kuweˈ hadja hadjehan bigi mustasa, duk daˈakbi punuhin palinda, asal palinda du. Gaˈ niyaˈ hunit si kaˈam bang kaˈam sandel. ( ");
INSERT INTO yka_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Saguwaˈ seyitan da bayuˈ miyaˈan, gaˈi tapaluwas luwal hadja bang kaˈam ngampun duk muwase.)” ");
INSERT INTO yka_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dambuwaˈ ellew paglaˈi siye si Jalil, paˈin si Isa si meˈ tindegnen, “Aku, Anak Manusiyaˈin, sinōngan du ku iyan si antanan meˈ aˈa. ");
INSERT INTO yka_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Papateyde du ku. Tellum bahangi puwas kamateykun, ellum du ku balik.” Pagtakalede inin, suse manamal meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagtekka siye laˈi si Kapernaum, hap pī pu si Petros meˈ aˈa magpāku-pāku sukey si langgalin, paˈinde, “Magbayed sukey ke gurubin?” ");
INSERT INTO yka_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nambung si Petros, paˈinne, “Aweˈ.” Pagdiyalem si Petros dem lumaˈ, magtawus si Isa missā si iye, paˈinne, “Ine paˈinnu, Simon. Sine magbayed sukey si meˈ sultan si dunyahin, meˈ anak-usbaden atawa meˈ aˈa seddilihin?” ");
INSERT INTO yka_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Paˈin si Petros, “Meˈ aˈa seddilihin.” Paˈin si Isa, “Iye hep, hātinen gaˈi magbayed meˈ usbanen. Manjari, kite bi inin meˈ usba Tuhanin, hangkan makajari bisan kite bi gaˈi magbayed. ");
INSERT INTO yka_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Saguwaˈ gaˈi hāp bang laˈat ateyden si kite. Pī kew hap lamew messi. Lukahun behe kenna tagnaˈ taˈeddoˈnun duk ngasuwaˈ kew iyan laˈi sīn sarang pamayed sukeyte si langgalin. Eddoˈun sīn iyan bu nu pī si langgal mayedan sukeyten.” ");
INSERT INTO yka_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Baytu miyaˈan hap pī pu si Isa meˈ tindegnen, paˈinde, “Sine tamanan malangkewin si meˈ aˈa manuhut pagbayaˈan Tuhanin?” ");
INSERT INTO yka_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Manjari ngandaˈak si Isa dambuwaˈ nakanak pī si siye bu pinatengge weˈ ne si tengngaˈde. ");
INSERT INTO yka_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ubus paˈinne, “Sabennal akahante kaˈam, gaˈi kaˈam sumakup dem pagbayaˈan Tuhanin bang gaˈi pindahanbi pikilanbin duk kaˈam manjari kuweˈ nakanak dikiˈin, gaˈi malangkew dine. ");
INSERT INTO yka_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sine-sine madiyawaˈ ateyne kuweˈ nakanak inin, iye tamanan malangkewin si pagbayaˈan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Bang niyaˈ aˈa bu sabab sandelne si akuhin ngaddatan dambuwaˈ nakanak dikiˈ kuweˈ inin, aku inaddatannen.” ");
INSERT INTO yka_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Bang niyaˈ aˈa makapaduse si dambuwaˈ nakanak dikiˈ kuweˈ inin makahagad si akuhin, hāp pe siˈ iye miyaˈan tapatowengan batu hadje si kellongne bu ilaboˈ pī dem tahik, duk hadja gaˈi taboˈone magduse. ");
INSERT INTO yka_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Makaˈaseˈ-aseˈ meˈ manusiyaˈin peggeˈ niyaˈ teˈed meˈ sassat makapaduse siye. Bugtuˈ niyaˈ teˈed meˈ sassat tekka. Saguwaˈ kaˈaseˈ-aseˈ aˈa manassat saweˈnen duk saweˈnen magduse, peggeˈ asal legga Tuhanin iye. ");
INSERT INTO yka_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Bang tangannun atawa bettisnun mamoˈo kaˈu magdusehin, lebbahanun ne pagdusenun. Dalilnen, kuweˈ du putukannu tangannun duk bettisnun bu nu ngalakasanne. Hāp pe kew paˈasek dem surgaˈ bisan kew putuk, amban duwe tangannun atawa duwe bettisnun saguwaˈ tinimanan kew pī dem ebbut gaˈ niyaˈ kapalemne. ");
INSERT INTO yka_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Duk bang matanun isab mamoˈo kaˈu magdusehin, lebbahanun pagdusenun. Dalilnen, kuweˈ du ugitannu matanun bu nu ngalakasanne. Hāp pe kew paˈasek dem surgaˈ bisan dambuwaˈ saˈ matanun amban duwe matanun saguwaˈ tinimanan kew pī dem ebbut narkaˈ.” ");
INSERT INTO yka_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Pahatul-hatul kaˈam,” paˈin si Isa, “daˈa diyawaˈanun bi bisan dambuwaˈ meˈ nakanak madikiˈ inin peggeˈ akahante kaˈam, meˈ malaˈikat mangipat siyehin luwal laˈi si harapan Samaku si surgaˈin. ( ");
INSERT INTO yka_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Aku, Anak Manusiyaˈin, akaku mapitu si dunyahin nimbul meˈ aˈa matala amban Tuhanin.) ");
INSERT INTO yka_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ine paˈinbi? Saˈupama, bang niyaˈ dambuwaˈ aˈa taga bili-bili dahatus ekkahannen bu ne niyaˈ dambuwaˈ sumapeˈ, ine enteˈ hinangne? Bugtuˈ ambananne siyampūˈ duk siyamin laˈi diyataˈ punu, duk pī iye miha dambuwaˈ masumapeˈin. ");
INSERT INTO yka_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sabennal akahante kaˈam, bang takasuwaˈne ne, sinna teˈed iye. Pasōng kasinnahanne dambuwaˈ miyaˈan amban siyampūˈ duk siyam manggaˈ bakas masumapeˈin. ");
INSERT INTO yka_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aˈahin gaˈi mabayaˈ weˈ lepas dambuwaˈ hayepnen. Na, sa iyan du isab Samabi si surgaˈin, gaˈi iye mabayaˈ weˈ niyaˈ bisan dambuwaˈ meˈ mākanak madikiˈ inin tumala amban Tuhan.” ");
INSERT INTO yka_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Bang saweˈnun kapagduse si kaˈu, akahanun iye salaˈnen. Saguwaˈ subey kaˈam hadja duwangan. Bang tuhutne bissānun bu magsusun iye, tatabangnu ne iye duk gaˈi du usaˈ sandelne si Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Saguwaˈ bang gaˈi tuhutne bissānun, moˈo kew pī dambuwaˈ atawa duwe saweˈnu seddili duk niyaˈ naksiˈan kēmon bissābin. ");
INSERT INTO yka_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bang gaˈi iye pakale si siye, akahanun kēmon meˈ aˈa malaˈi si langgalin. Bang gaˈi pe iye pakale bisan naksiˈ kēmon anak-apuˈ langgalin, subey ne addatbi si iyehin kuweˈ addatbi si aˈa manggaˈi manuhut Tuhanin atawa si meˈ aˈa magpāku-pāku sukeyin.” ");
INSERT INTO yka_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Sabennal akahante kaˈam, ine-ine pamagesanbi si dunya, pamagesan du isab iyan si surgaˈ. Ine-ine pangandaˈakanbi tuˈu si dunya, pangandaˈakan du isab iyan si surgaˈ. ");
INSERT INTO yka_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Akahante du isab kaˈam, bang niyaˈ duwangan aˈa amban kaˈam magtewwaˈ isunden sabab ine-ine batang pākude si Tuhan, asal pangurung du si siye pinākuden weˈ Samaku si surgaˈin. ");
INSERT INTO yka_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Peggeˈ bang duwangan atawa tellungan aˈa magtipun, iye sababnen, peggeˈ nuhut siye aku, laˈi du ku isab si siye.” ");
INSERT INTO yka_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Manjari pī si Petros pu si Isa duk paˈinne, “O Tuwan, mimpiye ampunku saweˈkun bang magduse iye si aku? Mimpituˈ?” ");
INSERT INTO yka_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Paˈin si Isa, “Dumaˈin mimpituˈ saguwaˈ mimpitumpuk-pituˈ.” ");
INSERT INTO yka_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Manjari magdalilan si Isa, paˈinne, “Pagbayaˈ Tuhanin kuweˈ inin. Niyaˈ dambuwaˈ sultan bayaˈ lilingne meˈ libru daraˈakannen bang hāp du ke pagantande sīnnen. ");
INSERT INTO yka_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tagnaˈne ngaliling meˈ libruhin, niyaˈ binoˈo pī si sultanin dambuwaˈ daraˈakanne utangnen ibu-ibuhan pilak. ");
INSERT INTO yka_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Manjari gaˈi umabut pilaknen pamayed utangnen. Hangkan dinaˈak weˈ sultanin pinabellihan lellahin hinang banyagaˈ sampay andanen duk meˈ anaknen, duk dinaˈak pinabellihan isab kēmon alataˈnen, supaya tabayedan utangnen. ");
INSERT INTO yka_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Magtawus daraˈakan miyaˈan nengge duk tuˈutne paharap si sultanin, muyuˈ-muyuˈ, paˈinne, ‘Tuwan, tangguhun ku dahuˈ. Bayedanku du kēmon utangku si kaˈuhin.’ ");
INSERT INTO yka_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Manjari maˈaseˈ sultanin si daraˈakannen, hangkan gaˈ ne daˈakne binayedan utangnen, duk dinaˈak ne iye hap lumaˈ. ");
INSERT INTO yka_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Pagluwas daraˈakan miyaˈan, niyaˈ tasampangne pagkasine daraˈakan taga utang si iye saguwaˈ kulang du. Magtawus siniggew weˈ ne bu sinekkel duk paˈinne, ‘Bayedanun ne utangnu si akuhin.’ ");
INSERT INTO yka_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Magtawus daraˈakan dambuwaˈin nengge duk tuˈutne muyuˈ-muyuˈ si iye, paˈinne, ‘Tangguhun ku dahuˈ. Asal bayedante du kew.’ ");
INSERT INTO yka_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Saguwaˈ gaˈi ngatu daraˈakan miyaˈan. Dinaˈak weˈ ne kinalabusu samantaˈan gaˈi tabayedanne kēmon utangnen. ");
INSERT INTO yka_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Manjari pagkite meˈ daraˈakan sinduwehin maˈumantag miyaˈan, gagal teˈed siye. Hap pī siye si sultanin magaka sabab miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hangkan daˈak sultanin hap pī si iye balik daraˈakan taga utang maˈekkahin. ‘Dupang kew teˈed,’ paˈinne. ‘Gaˈ ne kew hatiˈ daˈakku magbayed utangnun peggeˈ magpaˈaseˈ-aseˈ kew si aku. ");
INSERT INTO yka_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Subey siˈ kew miyaˈan maˈaseˈ isab si pagkasinu daraˈakanin kuweˈ pamaˈaseˈku si kaˈuhin.’ ");
INSERT INTO yka_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Astel teˈed sultanin duk dinaˈak weˈ ne kinalabusu daraˈakan miyaˈan pangalegga iye samantaˈan gaˈi tabayedanne kēmon utangnen.” ");
INSERT INTO yka_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Manjari paˈin si Isa, “Sa iyan du isab hinang Samaku si surgaˈin si kaˈam bang gaˈi ampunbi amban dem ateybi saweˈbi makaduse si kaˈamin.” ");
INSERT INTO yka_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Manjari pagubus miyaˈan bissā si Isa, tahalaˈ iye amban Jalil duk hap pī iye si meˈ kalahat-lahatan laˈi si Yahudiya si lipag boheˈ Jordan. ");
INSERT INTO yka_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Banes teˈed aˈa nuhut iye duk pinakoleˈ weˈ ne meˈ aˈa masakihin laˈi. ");
INSERT INTO yka_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Niyaˈ meˈ Pariseo patapit pī si iye duk panguhi-nguhide iye, tilewde iye, paˈinde, “Dem saraˈ, makajari ke bang aˈahin timananne andanen bisan ine jānnen?” ");
INSERT INTO yka_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nambung si Isa, paˈinne, “Gaˈ ke bakas tabatsabi dem kitab weˈ tagnaˈ pamapanjari Tuhan manusiyaˈin, pinapanjari siye weˈ ne lella duk dende ");
INSERT INTO yka_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","duk paˈin Tuhanin, ‘Hangkan hep tahalaˈ lellahin amban saˈi-samanen bu padambuwaˈ iye si andanen duk bakas duwehin magdambuwaˈ baran ne.’ ");
INSERT INTO yka_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Manjari dumaˈin ne siye duwe baran,” paˈin si Isa, “saguwaˈ dambuwaˈ baran ne. Hangkan subey teˈed gaˈi magbutas aˈa bakas pinagdambuwaˈ weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Manjari paˈin meˈ Pariseohin si iye, “Na, weˈey dem saraˈ pangandūsan si Musa lellahin milmahan sulat pagbutasan ubus makajari ne timananne andanen?” ");
INSERT INTO yka_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Paˈin si Isa, “Peggeˈ gaˈi kaˈam ngatu nuhut toloˈ, hangkan dinūsan kaˈam weˈ si Musa nimanan andabin. Saguwaˈ amban tagnaˈ dumaˈin sa iyan. ");
INSERT INTO yka_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Akahante kaˈam, sine-sine nimanan andanen bu gaˈ du bakas magkadupangan andanen bu maganda iye seddili, magjina iye.” ");
INSERT INTO yka_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Manjari paˈin meˈ tindegnen si iye, “Bang sa iyan magella-andahin, hāp pe gaˈi maganda.” ");
INSERT INTO yka_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Saguwaˈ paˈin si Isa, “Gaˈi kēmon makatuhut iyan, luwal hadja meˈ kaˈurungan basag weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Magseddili-seddili jānnen hangkan gaˈi maganda meˈ aˈahin. Niyaˈ meˈ aˈa gaˈi makajari maganda peggeˈ niyaˈ sallaˈde amban dem betteng. Niyaˈ isab meˈ aˈa bakas kinapun weˈ aˈa. Niyaˈ isab meˈ aˈa gaˈi maganda sabab pinikilden hadja paghinangde si Tuhanin. Sine-sine makatuhutne, subey ne tuhutne usihatku inin.” ");
INSERT INTO yka_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Manjari niyaˈ meˈ aˈa moˈo meˈ anakde pī pu si Isa supaya tabettadne tangannen si siye bu pākuhanne kahāpan amban Tuhan. Saguwaˈ inamāhan meˈ aˈahin weˈ meˈ tindeg si Isahin. ");
INSERT INTO yka_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Saguwaˈ paˈin si Isa, “Ambat pitu si aku meˈ mākanakin, duk daˈa siye saggaˈun bi. Peggeˈ aˈa kuweˈ mākanakin ngatu du pinagbayaˈan weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Manjari binettad weˈ ne meˈ tangannen si siye. Ubus bu tahalaˈ ne iye. ");
INSERT INTO yka_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Manjari niyaˈ dambuwaˈ aˈa pī pu si Isa duk paˈinne, “Tuwan, ine hinangan hāp subey hinangku supaya niyaˈ umulku salama-lama?” ");
INSERT INTO yka_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Paˈin si Isa si iye, “Weˈey tilewnu bang ine mahāpin? Tunggal du Tuhanin mahāpin. Bang kew mabayaˈ taga umul salama-lama, tuhutun meˈ pangandaˈakan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Paˈin lellahin, “Pangandaˈakan inggehin?” Paˈin si Isa, “Daˈa kew monoˈ; daˈa kew magjina; daˈa kew nangkew; daˈa kew naksiˈ gaˈi bennal; ");
INSERT INTO yka_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pagaddatanun saˈi-samanun; duk subey kalasahannu saweˈnun kuweˈ pangalasanu dinun.” ");
INSERT INTO yka_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Paˈin lellahin, “Tatuhutku ne iyan kēmon. Ine pe subey hininangkun?” ");
INSERT INTO yka_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Paˈin si Isa, “Bang kew mabayaˈ weˈ hāp kew teˈed, pī kew pabellihanun kēmon alataˈnun bu pangurungun ulinen si meˈ mamiskinin. Manjari niyaˈ du iyan alataˈnu laˈi si surgaˈ. Pagubus, balik kew pitu, nuhut kew aku.” ");
INSERT INTO yka_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagkale lellahin inin, tahalaˈ iye dukka, peggeˈ ekka teˈed alataˈne. ");
INSERT INTO yka_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ubus paˈin si Isa si meˈ tindegnen, “Sabennal akahante kaˈam, asal hunit teˈed meˈ madayahanin pinagbayaˈan weˈ Tuhan. ");
INSERT INTO yka_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aweˈ, akahante kaˈam, mura pe untaˈin palabey si lowang dalum amban aˈa dayahanin ngatu pinagbayaˈan weˈ Tuhan.” ");
INSERT INTO yka_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pagkale meˈ tindegnen inin, ulaliˈ siye manamal duk paˈinde, “Bang sa iyan, sine ne tapī si surgaˈin?” ");
INSERT INTO yka_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Manjari mayam si Isa si meˈ tindegnen duk paˈinne, “Bang manusiyaˈ gaˈi teˈed makajari, saguwaˈ bang Tuhan, gaˈ niyaˈ hunit si iye. Tahinangne kēmon.” ");
INSERT INTO yka_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Manjari missā si Petros, “Payamanun kami inin,” paˈinne, “ubus ne ambanan kami kēmon-kēmonin duk nuhut ne kami kaˈu. Ine panumbas kamihin?” ");
INSERT INTO yka_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Paˈin si Isa, “Sabennal akahante kaˈam, bang aku, Anak Manusiyaˈin, ningkoloˈ ne magbayaˈ si dunya baˈahuhin, kaˈam meˈ tindegku sampuk-duwehin ningkoloˈ du isab magbayaˈ si sampuk-duwe bangsa tubuˈ Israˈilin. ");
INSERT INTO yka_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bang niyaˈ aˈa ngambanan lumaˈnen atawa meˈ pungtinaˈinen lella-dende atawa saˈi-samanen atawa meˈ anaknen atawa bulaknen, bang ambananne meˈ inin sabab lasane si akuhin, asal tumbasan Tuhanin iye paˈekka, duk inurungan du iye umul gaˈ niyaˈ tamananne. ");
INSERT INTO yka_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Saguwaˈ ekka meˈ dumehellu kuweˈituhin dumambuli du si pasōngan, duk ekka dumambuli kuweˈituhin dumehellu du si pasōngan.” ");
INSERT INTO yka_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Pagbayaˈ Tuhanin kuweˈ inin. Niyaˈ aˈa taga bulak luha tinaneman bāhan ubas. Subu pe dambuwaˈ ellew hap pī iye miha meˈ aˈa magtarabahu si bulaknen. ");
INSERT INTO yka_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pagsanggupanden weˈ tangdananne siye asal tangdan para si hinang da ellewin, ubus dinaˈak ne siye pī maghinang si bulaknen. ");
INSERT INTO yka_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ellet lettu duk salung hap pī iye si tabuˈan, duk ngite iye laˈi meˈ aˈa nengge-nengge gaˈ niyaˈ hinangde. ");
INSERT INTO yka_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Paˈinne si siye, ‘Pī kaˈam isab magtarabahu si bulakku duk tangdanante du kaˈam patut si kaˈamin.’ ");
INSERT INTO yka_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ubus hap pī ne siye. Paglettu ne ellewin, pī ne isab iye miha meˈ aˈa maghinang si bulakne. Kuweˈ miyaˈan du isab hininangnen sakaliˈ taˈabut lisag tellu kohapin. ");
INSERT INTO yka_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Manjari pagkohap-kohap ne, pī iye balik hap tiyanggi duk ngite iye meˈ aˈa magtengge-tengge pe laˈi. Paˈinne si siye, ‘Weˈey kaˈam nengge-nengge hadja tuˈu kekkohapan gaˈ niyaˈ hinangbi?’ ");
INSERT INTO yka_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Paˈinde, ‘Peggeˈ gaˈ niyaˈ ngeddoˈ kami magtarabahu.’ ‘Na, pī kaˈam isab magtarabahu si bulakku,’ paˈinne. ");
INSERT INTO yka_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pagsangem ne, paˈin dapuˈ bulakin si kapatasnen, ‘Tawagun meˈ aˈa magtarabahuhin duk tangdananun ne siye. Iye padambulihun meˈ aˈa taˈeddoˈku dehelluhin.’ ");
INSERT INTO yka_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ubus hap pī ne meˈ aˈa taˈeddoˈ kohapin duk tinangdanan siye bali kekkohapan. ");
INSERT INTO yka_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pagpī ne meˈ aˈa taˈeddoˈ dehelluhin, kannalde weˈ pasōng pangurung siyehin. Saguwaˈ inurungan du isab siye tangdan bali kekkohapan. ");
INSERT INTO yka_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagsangkade tangdanden, puggutande dapuˈ bulakin, ");
INSERT INTO yka_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","paˈinde, ‘Meˈ aˈa miyaˈan maghinang hadja da ora bu kami inin maghinang kekkohapan magsandal panas ellew, ubus pagsaliˈnu tangdan kamihin duk si siyehin.’ ");
INSERT INTO yka_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Saguwaˈ paˈin dapuˈ bulakin si dambuwaˈin, ‘Bagay, gaˈ kaˈam akkalanku. Pagsanggupanten weˈ tangdanante kaˈam para si hinang da ellewin. ");
INSERT INTO yka_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eddoˈun bi tangdanbin bu bi ne hap lumaˈ. Kabayaˈankun tangdananku meˈ madambulihin saliˈ du duk tangdan si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Weˈ gaˈi ku kapagbayaˈ si sīnkun? Hatu ngimbū kaˈam peggeˈ sayuˈ ku?’” ");
INSERT INTO yka_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Manjari paˈin si Isa, “Hangkan hep meˈ dumambuli kuweˈituhin dumehellu du si pasōngan, duk dumehellu kuweˈituhin dumambuli du si pasōngan.” ");
INSERT INTO yka_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Manjari inin, sasang disi Isa si lān pataked tudju Awrusalam, binoˈo weˈ si Isa patala-tala meˈ tindegne sampuk-duwehin duk paˈinne si siye, ");
INSERT INTO yka_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pakale kaˈam, kite bi inin pataked hap Awrusalam. Paglaˈi ne kite bi, aku, Anak Manusiyaˈin, sinōngan du pī si antanan meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin. Manjari hukumande si akuhin weˈ pinapatey ku. ");
INSERT INTO yka_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ubus sōngande du ku isab pī si antanan meˈ aˈa dumaˈin Yahudi. Duk meˈ bangsa seddili inin hinangde du ku dagey, duk lubakande ku ubus bu lansangde ku diyataˈ olom. Saguwaˈ katellum bahanginen, ellum du ku balik.” ");
INSERT INTO yka_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Manjari anda Sebedehin pī pu si Isa magtuhut duk meˈ anakne lellahin. Pasujud iye pu si Isa peggeˈ niyaˈ pākune. ");
INSERT INTO yka_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Ine kabayaˈannun?” paˈin si Isa. Paˈin dendehin, “Kabayaˈankun bang ne kew ningkoloˈ magbayaˈ, patingkoloˈnu meˈ anakku inin si bihingnu, dambuwaˈ si kanawanannu duk dambuwaˈ si bibangannu.” ");
INSERT INTO yka_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nambung si Isa, paˈinne, “Gaˈi kataˈuhanbi bang ine pinākubi inin. Ngatu ke kaˈam bininasa kuweˈ sōng paminasa akuhin?” “Aweˈ, ngatu kami,” paˈinde. ");
INSERT INTO yka_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Paˈin si Isa, “Asal bininasa du kaˈam kuweˈ sōng paminasa akuhin. Saguwaˈ bang pagpatingkoloˈ si kanawanankun atawa si bibangankun,” paˈin si Isa, “dumaˈin aku magbayaˈin. Saguwaˈ meˈ paningkoloˈan miyaˈan sukuˈ si meˈ pinanyapan Samaku Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pagkale meˈ tindeg si Isa sampūˈin sabab pināku duwangan magpungtinaˈihin, astel siye. ");
INSERT INTO yka_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Saguwaˈ ilinganan weˈ si Isa meˈ tindegnen kēmon duk paˈinne, “Kataˈuhanbi addat meˈ aˈa si dunyahin. Meˈ nakuraˈ meˈ kabangsahan seddilihin magmanda teˈed si meˈ aˈahin duk meˈ aˈa malangkewin magbayaˈ teˈed si meˈ aˈaden. ");
INSERT INTO yka_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Saguwaˈ kaˈam,” paˈin si Isa, “subey gaˈi magsa miyaˈan. Sine-sine kaˈam mabayaˈ pinalangkew, subey iye daraˈakanbi. ");
INSERT INTO yka_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Duk sine-sine kaˈam mabayaˈ manjari tamanan malangkewin, subey iye kuweˈ banyagaˈ nabangan saweˈnen. ");
INSERT INTO yka_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Peggeˈ bisan aku, Anak Manusiyaˈin,” paˈin si Isa, “dumaˈin papituhankun makitabang si manusiyaˈ, saguwaˈ nabang manusiyaˈ. Duk pitu ku paglillaˈku umulkun pangalekkat meˈ aˈa maˈekkahin, supaya siye gaˈi ilegga sabab duseden.” ");
INSERT INTO yka_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Manjari, pagtahalaˈ siye amban puweblo Ariha, banes teˈed aˈa nuhut iye. ");
INSERT INTO yka_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Niyaˈ laˈi duwe aˈa pessek ningkoloˈ si higad lān palabeyanden. Pagkalede weˈ palabey ne si Isa, ngalingan siye papales, paˈinde, “O tubuˈ Sultan Daˈud, maˈaseˈ ne kew si kami.” ");
INSERT INTO yka_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Inamāhan siye weˈ meˈ aˈa maˈekkahin, gaˈi siye dinaˈak magbukag. Saguwaˈ namba ne papalesde paglinganden, paˈinde, “O tubuˈ Sultan Daˈud, maˈaseˈ ne kew si kami.” ");
INSERT INTO yka_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Padeheng si Isa duk ilinganan weˈ ne duwangan mapessekin duk paˈinne si siye, “Ine kabayaˈanbi hinangku si kaˈam?” ");
INSERT INTO yka_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Tuwan,” paˈinde, “kabayaˈan kamihin makakite ne kami.” ");
INSERT INTO yka_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Maˈaseˈ si Isa si siye duk inantan weˈ ne mataden. Na, magtawus siye makakite duk nuhut ne siye si Isa. ");
INSERT INTO yka_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Pagtapit ne disi Isa si Awrusalam, duk takitede ne kalumaˈan Betpagehin laˈi si kūd Jaitun, dinaˈak padehellu weˈ si Isa duwangan tindegnen. ");
INSERT INTO yka_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Paˈinne si siye, “Pī kaˈam si kalumaˈan si dehelluhanbi miyaˈan. Pagtekkabi laˈi, magtawus kaˈam iyan ngite dambuwaˈ asnu duk anakne dinagtel laˈi. Lekkahun bi duk boˈohun bi pitu si aku. ");
INSERT INTO yka_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bang niyaˈ nilew kaˈam bang weˈey eddoˈbi, paˈinun bi, ‘Niyaˈ kagunahan Panuhutanin si iye,’ duk daˈakne du iyan binoˈo magtawus.” (Asnuhin kuweˈ bantuk kuraˈ.) ");
INSERT INTO yka_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pinalabey inin duk tuman binissā nabi dem kitabin, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Akahanun bi meˈ aˈa Awrusalamin, ‘Payamanun bi, tekka du sultanbin, diyawaˈ ateynen duk pasakey iye diyataˈ anak asnu.’” ");
INSERT INTO yka_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Manjari hap pī ne meˈ tindegnen duk hininang weˈ de sa pangandaˈakan si Isa siyehin. ");
INSERT INTO yka_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Binoˈo ne weˈ de asnuhin duk anaknen duk ilampiruhan weˈ de duk meˈ semmekde, ubus bu pasakey ne si Isa. ");
INSERT INTO yka_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ekka isab meˈ aˈa laˈi. Binellat weˈ de meˈ semmekden si lān palabeyannen. Sinduwehin notoˈ meˈ pange dawenan duk kinanat weˈ de si lān pamahadjede si Isa. ");
INSERT INTO yka_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Magellang-ellang meˈ aˈa si dehelluhan si Isahin duk meˈ si dambulihannen. Ngalingan siye, paˈinde, “Pudjite bi tubuˈ Sultan Daˈudin. Pudjite bi pinapitu weˈ Tuhanin. Pudjite bi teˈed Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Manjari pagtekka si Isa si Awrusalam, bengngangan aˈahin kēmon duk paˈinde, “Sine aˈa inin?” ");
INSERT INTO yka_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Paˈin meˈ aˈa mabanesin, “Inin si Isa, nabi amban Nasaret si lahat Jalil.” ");
INSERT INTO yka_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Manjari padiyalem si Isa dem langgal hadjehin duk binudjew weˈ ne kēmon meˈ aˈa magdagang duk meˈ magbelli diyalem lumaˈ Tuhanin. Ilintuwadan weˈ ne meˈ lamisahan meˈ aˈa magsambiˈ-sambiˈ sīnin. Ilintuwadan isab weˈ ne meˈ paningkoloˈan meˈ aˈa magdagang assang pagkulubanin. ");
INSERT INTO yka_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Paˈinne si siye, “Tasulat dem kitab, paˈin Tuhanin, ‘Lumaˈkun inēnan du lumaˈ pangampunan.’ Saguwaˈ kaˈam,” paˈin si Isa, “hininang weˈ bi lumaˈ Tuhanin kuweˈ lumaˈ patapukan meˈ aˈa panangkew.” ");
INSERT INTO yka_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Meˈ aˈa mapessekin duk meˈ makukuˈin pī si iye dem langgal hadjehin duk pinakoleˈ siye weˈ ne. ");
INSERT INTO yka_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Saguwaˈ astel teˈed meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin pu si Isa pagkitede meˈ hinanganne makaˈulaliˈin, duk pagkalede meˈ mākanakin ngalingan laˈi dem langgal magpaˈin, “Pudjite bi tubuˈ Sultan Daˈudin.” ");
INSERT INTO yka_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Paˈinde pu si Isa, “Takalenu ke bissā meˈ mākanak miyaˈan?” “Aweˈ,” paˈin si Isa, “takaleku. Gaˈ ke bakas tabatsabi tasulat dem kitabin, pinaˈin, ‘Bisan meˈ mākanak dikiˈin tinoloˈan du mudji Tuhanin.’” ");
INSERT INTO yka_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ubus inambanan siye weˈ si Isa duk hap pī iye si kalumaˈan Betani. Patennaˈ iye laˈi. ");
INSERT INTO yka_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagsalung ne sasang pī iye balik si Awrusalam, inusan iye. ");
INSERT INTO yka_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Niyaˈ kitene poˈon kayu ēnande igira si bihing lān. Hap pī iye, saguwaˈ gaˈ niyaˈ takitene buwaˈne luwal hadja dawen. Paˈin si Isa, “Tinagnaˈan maˈin gaˈi ne buwaˈ balik kayu inin.” Magtawus ngalanes kayuhin. ");
INSERT INTO yka_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pagkite meˈ tindegnen miyaˈan, ulaliˈ siye, paˈinde, “Weˈey enteˈ magtawus lanes kayu iyan?” ");
INSERT INTO yka_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Paˈin si Isa si siye, “Sabennal akahante kaˈam, bang kaˈam sandel duk gaˈi teˈed duwe-duwehan, makajari hinangbi kuweˈ bakas hininangku si kayu iyan. Duk dumaˈin hadja iyan tahinangbin. Bang paˈinbi si punu inin, ‘O punu, tahalaˈ kew duk pateppad kew pī dem tahik,’ tuhutne du bissābin. ");
INSERT INTO yka_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Bang kaˈam sandel, tasangkabi du ine-ine pākubi amban Tuhan.” ");
INSERT INTO yka_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Manjari hap pī si Isa balik si langgal hadjehin duk magtoloˈ iye si meˈ aˈahin. Sasangne magtoloˈin, pī meˈ nakuraˈ imamin duk meˈ kabahiˈanin si iye duk paˈinde, “Ine kapatutnu ngahinang meˈ hininangnu ellew miyaˈan? Duk sine mangurungan kaˈu kapatutin?” ");
INSERT INTO yka_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sambungan si Isa siye, paˈinne, “Niyaˈ isab tilewku si kaˈam. Bang ku sambunganbi, akahante kaˈam isab bang ine kapatutku maghinang meˈ hininangku miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pamandi Yahiya meˈ aˈahin, amban kapatutnen? Amban Tuhan ke atawa amban manusiyaˈ hadja?” Magisun-isun siye, paˈinde, “Bang saˈupama paˈinte bi weˈ kapatut Yahiya pamandine meˈ aˈahin amban Tuhan, paˈinne iyan, ‘Na, weˈey Yahiya gaˈ kahagadbi?’ ");
INSERT INTO yka_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Saguwaˈ bang paˈinte bi, ‘Amban manusiyaˈ,’ na tinalew kite bi si meˈ aˈahin, peggeˈ kēmon aˈahin kahagad weˈ Yahiya nabi Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hangkan nambung siye, paˈinde, “Inday, gaˈi kataˈuhan kami bang amban kapatut Yahiyahin.” Manjari paˈin si Isa si siye, “Na, gaˈi isab kaˈam akahanku bang amban kapatutku maghinang meˈ hinangku miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Magdalilan si Isa, paˈinne, “Ine paˈinbi sabab inin? Niyaˈ dambuwaˈ aˈa duwe anaknen. Paˈinne si sakahin, ‘Totoˈ, pī kew ellew inin maghinang si bulakte bi.’ ");
INSERT INTO yka_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Paˈin sakahin, ‘Gaˈi ku.’ Saguwaˈ ubus miyaˈan, pinda du pikilannen duk harap pī ne iye si bulakde. ");
INSERT INTO yka_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Manjari hap pī isab aˈahin si anakne salihin duk daˈakne isab kuweˈ pangandaˈakanne sakahin. Nambung salihin, paˈinne, ‘Aweˈ, Ammaˈ, pī saˈ ku.’ Saguwaˈ gaˈ iye hap pī.” ");
INSERT INTO yka_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ubus paˈin si Isa, “Sine siye manuhut kabayaˈan samanen?” Paˈinde, “Sakahin.” Manjari paˈin si Isa si siye, “Sabennal akahante kaˈam, meˈ aˈa madusehanin kuweˈ meˈ aˈa magpāku-pāku sukeyin duk meˈ dende madupangin, tayimaˈ Tuhanin pe siye dehellu amban kaˈam. ");
INSERT INTO yka_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Peggeˈ pitu si kaˈam Yahiya magpandi-pandi aˈahin duk toloˈanne kaˈam lān mabentelin bu gaˈi kahagadbi. Saguwaˈ meˈ aˈa magpāku-pāku sukeyin duk meˈ dende madupangin kinahagad iye weˈ de. Duk bisan inin takitebi, gaˈ du pindahanbi pikilanbin bu kahagad si iye.” ");
INSERT INTO yka_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pakale kaˈam, niyaˈ pe isab dalilan seddili,” paˈin si Isa. “Niyaˈ aˈa magtanem bāhan ubas pinaluha duk binirang weˈ ne. Ilowangan weˈ ne diyawaˈ pagpeggaˈan ubasin panawutan boheˈ ubasin. Ngahinang isab iye payad langkew pamantew-mantewan likusin. Manjari pinatungguˈan weˈ ne likusnen si meˈ aˈa, pagbahagiˈan uli tinanemnen. Ubus bu tahalaˈ iye pī si lahat tala. ");
INSERT INTO yka_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pagtaˈabut pagbuwaˈ ubasin, dinaˈak weˈ dapuˈ likusin meˈ daraˈakannen pī si meˈ aˈa tatungguˈnen māku bahagiˈne si meˈ buwaˈ ubasin. ");
INSERT INTO yka_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pagtekka meˈ daraˈakannen laˈi, siniggew siye weˈ meˈ tatungguˈin. Dambuwaˈin pinapeddiˈan weˈ de, dambuwaˈin pinapatey duk dambuwaˈin pinagtibagan weˈ de. ");
INSERT INTO yka_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ubus ngandaˈak ne isab dapuˈ likusin meˈ daraˈakanne seddili hap pī si siye. Ekka siye amban meˈ dehelluhin. Hininang weˈ meˈ aˈa tatungguˈnen si siye kuweˈ hininangde si meˈ daraˈakan dehelluhin. ");
INSERT INTO yka_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ujudnen daˈakne hap pī anaknen. Paˈinne dem ateyne, ‘Bugtuˈ pagaddatande anakkun.’ ");
INSERT INTO yka_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Saguwaˈ pagkite meˈ tatungguˈ likusin anakne miyaˈan, magisun siye, paˈinde, ‘Iye hep inin pinusakaˈanin. Dayiˈ kaˈam papateyte bi duk taˈeddoˈte bi likusin.’ ");
INSERT INTO yka_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Manjari siniggew iye weˈ de duk sinōgadan pī si bukut birang likusin duk pinapatey weˈ de. ");
INSERT INTO yka_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Manjari,” paˈin si Isa, “bang tekka dapuˈ likus miyaˈan, ine enteˈ hinangne si meˈ tatungguˈnen?” ");
INSERT INTO yka_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nambung siye, paˈinde, “Bugtuˈ papateyne meˈ aˈa malaˈat miyaˈan, duk patungguˈne likusnen si meˈ aˈa seddili, meˈ mangurungan iye bahagiˈnen pagtaˈabut pagbuwaˈ ubasin.” ");
INSERT INTO yka_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Paˈin si Isa si siye, “Gaˈ ke bakas tabatsabi dem kitab, pinaˈin, ‘Batu tinayikutan weˈ meˈ pandey maghinang lumaˈ batuhin, peggeˈ kannalde gaˈi taguna, kuweˈitu iye ne miyaˈan batu tamanan maniyaˈ kagunahannen. Hinangan Tuhanin inin duk landuˈ teˈed hāp.’ ");
INSERT INTO yka_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hangkan akahante kaˈam,” paˈin si Isa, “tagnaˈ kaˈam tapeneˈ Tuhanin, saguwaˈ pinagantiˈ du iyan si kaˈam meˈ bangsa seddilihin duk tuhutde du iyan pangandaˈakan Tuhanin.” ( ");
INSERT INTO yka_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Paˈin si Isa pe, “Kēmon malaboˈ diyataˈ batu inin posak-posak barannen. Duk sasuku kalaboˈan batu inin, pipis iye.”) ");
INSERT INTO yka_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pagkale meˈ nakuraˈ imamin duk meˈ Pariseohin meˈ dalilan miyaˈan, tahātide weˈ siye inandigan si Isahin. ");
INSERT INTO yka_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Batang si Isa siggewde, saguwaˈ tinalew siye si meˈ aˈa mabanesin, peggeˈ kahagad meˈ aˈahin weˈ nabi si Isa. ");
INSERT INTO yka_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Manjari magdalilan ne isab si Isa si siye, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Pagbayaˈ Tuhanin kuweˈ inin. Niyaˈ dambuwaˈ sultan magpanyap pagjamu-jamuhan hadje peggeˈ kinawin anakne lellahin. ");
INSERT INTO yka_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pagtekka ellew pagjamu-jamuhin, dinaˈak weˈ ne meˈ daraˈakannen pī ngeddoˈ meˈ aˈa bakas tabatikin. Saguwaˈ gaˈi siye mabayaˈ pī si pagkawinan. ");
INSERT INTO yka_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ubus ngandaˈak ne isab iye meˈ daraˈakanne seddili hap pī, paˈinne, ‘Akahanun bi meˈ aˈa bakas tabatikin weˈ tahak ne kinakanin, ubus ne sinumbaliˈ meˈ sapiˈ lellahin duk meˈ anak sapiˈ malemmekin duk panyap ne kēmon. Hangkan subey ne siye pitu si pagjamuhan.’ ");
INSERT INTO yka_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Saguwaˈ gaˈ ngasip meˈ aˈa tabatikin. Tahalaˈ siye, dambuwaˈin hap pī si tanaˈne, dambuwaˈin si tindane, ");
INSERT INTO yka_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","duk sinduwehin siniggew weˈ de meˈ daraˈakan sultanin bu pinogpog duk pinapatey weˈ de. ");
INSERT INTO yka_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Manjari astel teˈed sultanin. Dinaˈak weˈ ne meˈ sundalunen pī monoˈ meˈ aˈa mapatey meˈ daraˈakannen. Daˈakne isab ineggas puwebloden. ");
INSERT INTO yka_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ubus miyaˈan paˈin sultanin si meˈ daraˈakannen, ‘Memes ne kinakanin saguwaˈ meˈ bakas tabatikin gaˈi ne pataˈ pitu. ");
INSERT INTO yka_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Na, kuweˈitu pī kaˈam si meˈ kalān-lānan duk boˈohun bi kēmon aˈa takasuwaˈbin pitu si pagjamuhan.’ ");
INSERT INTO yka_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Manjari pī ne meˈ daraˈakannen si meˈ kalān-lānan duk binoˈo weˈ de kēmon aˈa takasuwaˈden, dupang duk petten, gaˈ biddaˈ. Hangkan pennoˈ weˈ aˈa lumaˈ pagkawinanin. ");
INSERT INTO yka_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Pagdiyalem sultanin mayaman meˈ aˈa malaˈihin, niyaˈ takitene laˈi lella semmeknen gaˈi talep para si pagkawinan. ");
INSERT INTO yka_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Paˈin sultanin si lella miyaˈan, ‘Bagay, saˈingge kaˈumaseknu mapituhin, bu gaˈ kew magbadjuˈ para si pagkawinan?’ Gaˈ nambung aˈahin. ");
INSERT INTO yka_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Manjari paˈin sultanin si meˈ daraˈakannen, ‘Ingketanun bi tangan aˈa iyan duk bettisnen duk pabukutun bi pinadem lindem. Magmatey meˈ aˈahin laˈi duk magtageˈot meˈ impenden hawal pagsusunden.’” ");
INSERT INTO yka_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Manjari paˈin si Isa, “Ekka aˈa ilinganan weˈ Tuhanin dinaˈak patuhut si iye, saguwaˈ kulang du tapeneˈin.” ");
INSERT INTO yka_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Manjari tahalaˈ meˈ Pariseohin duk magisun-isun siye bang saˈingge panguhi-nguhide si Isahin si meˈ bissānen. ");
INSERT INTO yka_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ubus dinaˈak weˈ de meˈ tindegden duk meˈ tindeg Sultan Herodin pī pu si Isa. Pagtekkade laˈi paˈinde pu si Isa, “Tuwan, kataˈuhan kami weˈ bennal hadja meˈ bissānun duk bennal meˈ panoloˈnu sabab meˈ kabayaˈan Tuhan hininang manusiyaˈin. Gaˈi kew suse bisan ine tapikil aˈa si kaˈuhin, bisan pe siye meˈ aˈa taga kapatut. ");
INSERT INTO yka_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hangkan akahanun kami bang ine paˈinnu. Patuhut ke si saraˈte bi magbayed sukey si Sultan Nakuraˈ bangsa Romahin atawa gaˈi?” ");
INSERT INTO yka_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Saguwaˈ kataˈuhan si Isa pangakkalden. Paˈinne si siye, “Kaˈam iyan magmā-mā hadja. Bayaˈ ku kuhi-kuhibi. ");
INSERT INTO yka_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakitehanun bi ku sīn pagbayed sukeyin.” Ubus binoˈohan iye weˈ de sīn tuwas. ");
INSERT INTO yka_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Paˈin si Isa si siye, “Pattaˈ sine teˈ duk sulat sine si sīn inin?” ");
INSERT INTO yka_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Paˈinde, “Pattaˈ Sultan Nakuraˈin duk sulatnen.” Manjari paˈin si Isa si siye, “Hangkan pangurungun bi si Sultan Nakuraˈin sukuˈ si iyehin, duk pangurungun bi si Tuhan sukuˈ si Tuhanin.” (Hātinen, magbayed kaˈam sukey duk pangurungun bi dibin dambūs-būs si Tuhan.) ");
INSERT INTO yka_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagkalede inin, ulaliˈ siye manamal duk tahalaˈ ne siye. ");
INSERT INTO yka_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ellew miyaˈan niyaˈ pī pu si Isa meˈ Sadduseo, meˈ Yahudi gaˈi kahagad weˈ ellum balik meˈ pateyin si ellew dambuli. ");
INSERT INTO yka_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tilewde iye, paˈinde, “Tuwan, bakas sinulat weˈ si Musa, paˈinne, ‘Bang niyaˈ lella, bu matey iye gaˈ niyaˈ anakne, subey ne maganda salinen si balu miyaˈan duk niyaˈ tubuˈ sakanen.’ ");
INSERT INTO yka_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Manjari niyaˈ miyaˈan pituˈ lella magpungtinaˈi bakas patennaˈ tuˈu si kami. Maganda sakahin saguwaˈ matey iye gaˈ niyaˈ anakde. Ubus salinen maganda si baluhin. ");
INSERT INTO yka_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Matey iye gaˈ du isab niyaˈ anakde. Damikkiyan du isab mapasunuˈ si iyehin. Kapituˈ magpungtinaˈihin maggantiˈ nganda baluhin duk matey siye gaˈ niyaˈ anakde. ");
INSERT INTO yka_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ujudnen matey isab dendehin. ");
INSERT INTO yka_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, Tuwan,” paˈinde, “si ellew pagellum balik meˈ pateyin, anda sine iye, bu pituˈ magpungtinaˈihin makaˈanda iye?” ");
INSERT INTO yka_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nambung si Isa, paˈinne, “Salaˈ kaˈam. Hangkan kaˈam salaˈ peggeˈ gaˈi tasabutbi tasulat dem kitabin duk gaˈi isab kataˈuhanbi balakat Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Peggeˈ bang ellum ne balk meˈ pateyin,” paˈin si Isa, “kuweˈ ne siye meˈ malaˈikat si surgaˈin. Gaˈi ne siye maganda atawa magella. ");
INSERT INTO yka_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na, pasal meˈ aˈa matey weˈ pinakellum balk, gaˈ ke bakas tabatsabi bang ine pinaˈin Tuhan si kaˈamin? ");
INSERT INTO yka_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Paˈin Tuhanin, ‘Aku Tuhan pagtuhanan disi Ibrahim duk Isahak duk si Yakub.’ Tuhanin Tuhan meˈ maˈellumin, dumaˈin Tuhan meˈ pateyin.” (Hātinen weˈ bisan disi Ibrahim duk Isahak duk si Yakub tiggel ne matey, ellum siye si surgaˈ peggeˈ inisbat pe weˈ de Tuhanin.) ");
INSERT INTO yka_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pagkale inin weˈ meˈ aˈa mabanesin, ulaliˈ teˈed siye sabab panoloˈnen. ");
INSERT INTO yka_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pagkale meˈ Pariseohin weˈ gaˈ taˈu meˈ Sadduseohin nambungan si Isa, magtipun siye duk pī siye pu si Isa. ");
INSERT INTO yka_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dangan siye guru pandey si saraˈ āgama. Niyaˈ tilewne panuleyanne si Isa. ");
INSERT INTO yka_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tuwan,” paˈinne, “dem saraˈ, inggehin daˈakan malangkew amban kēmonin?” ");
INSERT INTO yka_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nambung si Isa, paˈinne, “Inin, ‘Subey kalasahannu Tuhanin, Panuhutannun dambūs-būs ateynun duk pikilannun duk basagnun.’ ");
INSERT INTO yka_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iye inin,” paˈin si Isa, “daˈakan malangkew amban kēmonin. ");
INSERT INTO yka_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Duk pangandaˈakan mapasunuˈin saliˈ du isab langkewnen, ‘Subey kalasahannu saweˈnun kuweˈ pangalasanu dinun.’ ");
INSERT INTO yka_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kēmon meˈ daˈakan dem saraˈ pangurung Tuhan si Musahin duk kēmon panoloˈ kanabihanin sakup dem duwe daˈakan inin.” ");
INSERT INTO yka_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Manjari paˈin si Isa si meˈ Pariseo bakas magtipunin, ");
INSERT INTO yka_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ine paˈinbi sabab Almasihin, tubuˈ sine iye?” Paˈinde, “Tubuˈ Sultan Daˈud.” ");
INSERT INTO yka_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Bang bennal iyan,” paˈinne, “weˈey paˈin si Daˈud sābu pagbayaˈan iye weˈ Niyawa Sutsihin weˈ Almasihin Panuhutannen? ");
INSERT INTO yka_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Paˈinne dem kitab, ‘Missā Tuhanin si Panuhutankun. Paˈin Tuhanin, dayiˈ kew, ningkoloˈ kew tuˈu si kanawananku, tuˈu si paningkoloˈan mabangsahanin. Bettadku du meˈ bantanun diyawaˈ pat bettisnu.’” ");
INSERT INTO yka_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Paˈin si Isa, “Bang Almasihin inēnan Panuhutan weˈ si Daˈud, saˈingge kajarinen weˈ tubuˈ Sultan Daˈud iye?” ");
INSERT INTO yka_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ubus gaˈi ne siye taˈu nambungan iye duk kemuwe ellew miyaˈan gaˈ ne niyaˈ aˈa makatawakkal nilew iye ine-ine. ");
INSERT INTO yka_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Manjari missā si Isa si meˈ aˈa mabanesin duk si meˈ tindegnen, paˈinne, ");
INSERT INTO yka_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Meˈ guru si saraˈ āgamahin duk meˈ Pariseohin taga kapatut magtoloˈ meˈ saraˈ si Musahin. ");
INSERT INTO yka_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hangkan kahagadun bi duk tuhutun bi kēmon panoloˈden, saguwaˈ daˈa kaˈam nuhut hinanganden, peggeˈ gaˈi du tuhutde meˈ panoloˈden. ");
INSERT INTO yka_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pinabohatan weˈ de meˈ aˈahin duk meˈ saraˈ gaˈi takoleˈde, bu gaˈi siye nabang moˈone bisan kuweˈahat. ");
INSERT INTO yka_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kēmon hininangden hinangde duk siye takite weˈ aˈa. Payamanun bi be meˈ pangisihande sulat ilekkat amban dem kitabin pinekkes si lendoˈde duk lengngende, hadje amban si meˈ sinduwehin duk tahaˈ isab meˈ jambu semmekden. ");
INSERT INTO yka_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bang siye si meˈ pagjamu-jamuhan, kabayaˈanden ningkoloˈ si meˈ paningkoloˈan mabangsahanin. Bang dem langgal, mabayaˈ siye ningkoloˈ si meˈ paningkoloˈan para si meˈ aˈa pinagaddatanin. ");
INSERT INTO yka_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sinna siye sinalam si meˈ tabuˈan duk bang siye inēnan ‘Guru.’ ");
INSERT INTO yka_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Bang kaˈam, daˈa kaˈam mabayaˈ inēnan ‘Guru,’ peggeˈ kuweˈ du kaˈam kēmon magpungtinaˈi duk dambuwaˈ du hadja gurubin, aku. ");
INSERT INTO yka_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Daˈa ēnanun bi ‘Ammaˈ’ sine-sine tuˈu si dunya, peggeˈ dambuwaˈ du samabin, iye Tuhan si surgaˈin. ");
INSERT INTO yka_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Duk gaˈi kaˈam makajari inēnan ‘Nakuraˈ’ peggeˈ dambuwaˈ hadja nakuraˈbin, Almasihin. ");
INSERT INTO yka_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sine-sine kaˈam mabayaˈ pinalangkew teˈedin subey iye daraˈakanbi. ");
INSERT INTO yka_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sine-sine mahadje dine pinadiyawaˈ du, duk sine-sine madiyawaˈ dine pinahadje du.” ");
INSERT INTO yka_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kaˈaseˈ-aseˈ kaˈam, meˈ guru si saraˈ āgamahin duk meˈ Pariseohin peggeˈ asal legga Tuhanin du kaˈam. Magmā-mā hadja kaˈam nuhut Tuhanin. Binembelan weˈ bi meˈ aˈahin supaya siye gaˈi tumuhut pī si pagbayaˈan Tuhanin. Gaˈi du tuhutbi lān miyaˈan duk pagesbi pe sasuku mabayaˈ nuhut lān miyaˈan. ( ");
INSERT INTO yka_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kaˈaseˈ-aseˈ kaˈam, meˈ guru si saraˈ āgamahin duk meˈ Pariseohin peggeˈ asal legga Tuhanin du kaˈam. Magmā-mā hadja kaˈam nuhut Tuhanin. Sinigpitan weˈ bi meˈ dende baluhin supaya taˈeddoˈbi meˈ lumaˈden duk magsambahayang kaˈam patahaˈ, magmā-mā weˈ aˈa hāp kaˈam. Bugtuˈ hukuman hadje tasangkabin si ahilat.) ");
INSERT INTO yka_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kaˈaseˈ-aseˈ kaˈam meˈ guru si saraˈ āgamahin duk meˈ Pariseohin peggeˈ asal legga Tuhanin kaˈam. Magmā-mā hadja kaˈam nuhut Tuhanin. Butasanbi tahikin pī si kalahatan seddili duk lumengngan kaˈam tala magtoloˈ supaya niyaˈ bisan dambuwaˈ aˈa nuhut panoloˈbin. Saguwaˈ bang nuhut ne iye, pasōng pe iye pataˈ pinadem narkaˈ amban kaˈam sabab meˈ panoloˈbi si iyehin. ");
INSERT INTO yka_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kaˈaseˈ-aseˈ kaˈam. Kuweˈ kaˈam meˈ aˈa pessek nundan pagkasibi pessek. Magtoloˈ kaˈam, paˈinbi, ‘Bang napa aˈahin bu hinangne saksiˈ langgal hadjehin, makajari bisan gaˈi tumananne. Saguwaˈ bang iye hinangne saksiˈ, meˈ bulawan dem langgal hadjehin, gaˈi makajari bang gaˈi tumananne.’ ");
INSERT INTO yka_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dupang kaˈam duk pessek. Inggehin malangkewin, bulawanin atawa langgalin? Sutsi hadja bulawanin peggeˈ diyalem langgal. ");
INSERT INTO yka_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Magtoloˈ isab kaˈam, paˈinbi, ‘Bang napa aˈahin bu hinangne saksiˈ pagkulubananin, makajari bisan gaˈi tumananne. Saguwaˈ bang iye hinangne saksiˈ kuluban diyataˈ pamettadan iyehin, gaˈi makajari bang gaˈi tumananne.’ ");
INSERT INTO yka_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pessek kaˈam manamal. Inggehin malangkewin, kulubanin atawa pagbettadan kulubanin? Bang gaˈi binettad hayepin diyataˈ pagbettadan kulubanin, dumaˈin hep kuluban. ");
INSERT INTO yka_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hangkan hep bang niyaˈ aˈa napa bu hinangne saksiˈ pagbettadan kulubanin, sinakup du kēmon binettad diyataˈnen, ");
INSERT INTO yka_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","duk sine-sine napa, bu hinangne saksiˈ langgal hadjehin, sinakup du isab mapatennaˈ dem langgalin, hātinen, Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Duk sine-sine napa bu hinangne saksiˈ surgaˈin, iye saksiˈnen paningkoloˈan Tuhanin. Duk asal Tuhanin ne teˈed panapahannen peggeˈ Tuhanin maningkoloˈ malaˈihin. ");
INSERT INTO yka_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kaˈaseˈ-aseˈ kaˈam meˈ guru si saraˈ āgamahin duk meˈ Pariseohin peggeˈ asal legga Tuhanin du kaˈam. Magmā-mā hadja kaˈam nuhut Tuhanin. Magjakat kaˈam bisan sampay jambanganbi pagpā-pā kinakanin. Saguwaˈ gaˈi kaˈam nuhut meˈ daˈakan malangkewin. Gaˈi kaˈam bentel, gaˈi kaˈam maˈaseˈ si saweˈbi, duk gaˈi kaˈam tapangandelan. Hāp bang kaˈam magjakat, saguwaˈ subey gaˈi tayikutanbi meˈ hinangan pinaˈinku miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Pagtuyuˈanbi nuhut daˈakan manggaˈi malangkewin saguwaˈ bang daˈakan malangkewin gaˈi hinangbi. Kuweˈ kaˈam aˈa pessek manduˈan saweˈbin. Kuweˈ kaˈam aˈa magsāˈ boheˈ duk gaˈi taˈinumne sanamin saguwaˈ taloroyne untaˈin. ");
INSERT INTO yka_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kaˈaseˈ-aseˈ kaˈam meˈ guru si saraˈ āgamahin duk meˈ Pariseohin peggeˈ legga Tuhanin du kaˈam. Magmā-mā hadja kaˈam nuhut Tuhanin. Kinosoˈan weˈ bi tikungin duk laleyin saguwaˈ diyalemnen haram, peggeˈ taˈeddoˈbi meˈ kinakan iyan sabab pangakkalbin duk pagnapsubin. ");
INSERT INTO yka_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pessek kaˈam, meˈ Pariseohin. Limpiyuhanun bi dahuˈ meˈ inisibin ubus limpiyu du isab laleybin duk tikungbin. ");
INSERT INTO yka_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kaˈaseˈ-aseˈ kaˈam meˈ guru si saraˈ āgamahin duk meˈ Pariseohin peggeˈ legga Tuhanin du kaˈam. Magmā-mā hadja kaˈam nuhut Tuhanin. Kuweˈ kubul pininta kaˈam. Hāp-hāp bantuknen amban luwasan saguwaˈ diyalemnen pennoˈ weˈ tolang duk isi buhuk. ");
INSERT INTO yka_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Damikkiyan du isab kaˈam, si meˈ aˈa kuweˈ bantuk bentel kaˈam, saguwaˈ dem ateybin magdustaˈ hadja kaˈam duk ngalanggalan saraˈ.” ");
INSERT INTO yka_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kaˈaseˈ-aseˈ kaˈam meˈ guru si saraˈ āgamahin duk meˈ Pariseohin. Magmā-mā hadja kaˈam nuhut Tuhanin. Mahāpan kaˈam meˈ kubul meˈ nabihin duk meˈ aˈa mabentelin pangaddatbi siye. ");
INSERT INTO yka_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Duk paˈinbi, ‘Bang ellum ne kami masa kapapuˈan kamiley gaˈi teˈed kami matuk si hinanganden mapatey meˈ nabihin.’ ");
INSERT INTO yka_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Weˈ bissābi iyan magbennal ne kaˈam weˈ tubuˈ meˈ mamapatey nabihin kaˈam. ");
INSERT INTO yka_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pīhun bi, ubusanun bi hininang meˈ kapapuˈanbi ley. ");
INSERT INTO yka_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Laˈat teˈed kaˈam. Gaˈi kaˈam makajari patapuk amban hukuman pinadem narkaˈ. ");
INSERT INTO yka_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Akahante kaˈam, ngandaˈak du ku iyan pī si kaˈam meˈ nabi duk meˈ lella lalem kataˈunen, duk meˈ guru. Sinduwehin papateybi iyan duk sinduwehin lansangbi si olom. Sinduwehin lubakanbi laˈi dem langgalbi duk turul-turulbi pī si meˈ puweblo palahihanden. ");
INSERT INTO yka_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hangkan tewwaˈ hukuman kaˈam sabab pamapatey meˈ aˈa manggaˈ niyaˈ dusenen, tinagnaˈan amban si Habil anak Apuˈ Adamin sampay Jakariya anak Barakihin bakas pinapateybi si ellet langgal hadjehin duk pagkuluban-kulubananin. ");
INSERT INTO yka_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sabennal akahante kaˈam, kēmon meˈ hininangde miyaˈan, moleˈ si kaˈam, meˈ aˈa maˈellum kuweˈitu inin.” ");
INSERT INTO yka_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O, meˈ aˈa Awrusalam, suse ku sabab kaˈam. Luwal papateybi meˈ nabihin duk pagtibaganbi meˈ dinaˈak Tuhan mapiyu si kaˈamin. Mimpiye ne kaˈam batang pagtipunku duk ipatku kuweˈ dalil bukaran magtipun meˈ usuynen diyawaˈ peppikne, saguwaˈ gaˈi kaˈam mabayaˈ. ");
INSERT INTO yka_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Payamanun bi, tinayikutan ne lahatbin weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Akahante kaˈam weˈ gaˈi ne ku teˈed kitebi balik samantaˈan gaˈi tekka ellew pagpaˈinbi, ‘Pudjite bi pinapitu Tuhanin.’” ");
INSERT INTO yka_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pagluwas si Isa amban dem langgal hadjehin, hap pī si iye meˈ tindegnen duk pinakitehan weˈ de si iye langgalin. ");
INSERT INTO yka_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Paˈin si Isa si siye, “Aweˈ, payamanun bi ne iyan, peggeˈ sabennal akahante kaˈam, niyaˈ ellew si pasōngan gaˈ du iyan niyaˈ talebbi tuˈu meˈ batu magbangkat-bangkat iyan, saguwaˈ kēmon kinanat-kanat du.” ");
INSERT INTO yka_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Manjari sasang si Isa ningkoloˈ si kūd Jaitun, hap pī si iye meˈ tindegnen, siye-siye hadja duk paˈinde, “Akahanun kami, sumiyan umantag meˈ pinaˈinnu iyan, duk me tandaˈ mapaguwaˈin bang sōng pitu ne kew balik duk bang sōng kiyamat ne dunyahin?” ");
INSERT INTO yka_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nambung si Isa, paˈinne, “Pahatul-hatul kaˈam duk kaˈam gaˈi kaˈakkalan. ");
INSERT INTO yka_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Peggeˈ ekka iyan pitu magēnan ēnkun magpaˈin weˈ siye ne Almasihin. Duk ekka iyan kaˈakkalande. ");
INSERT INTO yka_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makakale kaˈam iyan sabab magbonoˈ dem lahat duk suwi-suwi sabab magbonoˈ si lahat tala, saguwaˈ daˈa kaˈam tinalew. Kēmon inin subey umantag saguwaˈ dumaˈin pe inin ellew kiyamat. ");
INSERT INTO yka_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dambuwaˈ bangsa magbonoˈ duk bangsa seddili, duk dambuwaˈ pagsultanan magbonoˈ duk pagsultanan seddili. Niyaˈ iyan meˈ unus duk meˈ linug si meˈ kalahat-lahatan si dunya. ");
INSERT INTO yka_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Saguwaˈ kēmon inin panagnaˈan meˈ katiksaˈanin hadja, kuweˈ dalil dende sōng nganak duk nagnaˈ peddiˈan ne. ");
INSERT INTO yka_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ubus siggew meˈ aˈa du kaˈam duk sōngande kaˈam ilegga duk pinapatey. Kabunsihan du kaˈam weˈ kēmon manusiyaˈ peggeˈ nuhut kaˈam aku. ");
INSERT INTO yka_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ellew iyan ekka gaˈi ne nuhut aku. Pagbuddihande saweˈden duk kabunsihande saweˈden. ");
INSERT INTO yka_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ekka iyan aˈa tekka magmā-mā nabi siye pinapitu weˈ Tuhanin duk ekka aˈa kaˈakkalande. ");
INSERT INTO yka_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Peggeˈ lumanduˈ ne kalaˈatan dem dunyahin, meˈ aˈa maˈekkahin gaˈi ne malasa si saweˈde. ");
INSERT INTO yka_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Saguwaˈ sine-sine nandal sampay si tamanan kabinasahan inin, taga umul du si surgaˈ gaˈ niyaˈ tamananne. ");
INSERT INTO yka_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Duk meˈ aka-aka mahāp sabab pagbayaˈ Tuhanin minahalayak du iyan si tibuˈukan dunya, supaya kataˈuhan manusiyaˈin kēmon. Ubus iyan kiyamat ne dunyahin.” ");
INSERT INTO yka_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Bakas pinaˈal andang weˈ Nabi Daniyel weˈ si pasōngan niyaˈ laˈi dem langgal hadje makapagkaˈat, duk ngandiyawaˈan Tuhanin. (Ambat mamatsa inin sabutanne.) ");
INSERT INTO yka_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bang takitebi inin subey ne meˈ aˈa malaˈi si Yahudiyahin lahi pī si meˈ kapunuhan. ");
INSERT INTO yka_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bang niyaˈ aˈa si luwasan lumaˈne subey ne iye gaˈi padiyalem ngeddoˈ panyapnen. ");
INSERT INTO yka_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Duk malaˈi si tanaˈnen subey ne gaˈi balik pī si lumaˈne ngeddoˈ semmeknen, saguwaˈ subey ne iye lahi. ");
INSERT INTO yka_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Andūˈ, makaˈaseˈ-aseˈ meˈ mabettengin duk meˈ maganak dikiˈin laˈi si meˈ ellew īˈ. ");
INSERT INTO yka_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Māku-māku kaˈam si Tuhan karayaw ellew palahibin dumaˈin si tempo gaˈi hāp lahatin atawa si ellew liˈi. ");
INSERT INTO yka_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Peggeˈ si meˈ ellew īˈ,” paˈin si Isa, “niyaˈ iyan katiksaˈan hadje, gaˈ niyaˈ saliˈne kemuwe tagnaˈ dunyahin sampay kuweˈitu. Duk puwas inin, gaˈi ne teˈed kabalikan. ");
INSERT INTO yka_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bang gaˈi kulangan Tuhanin meˈ ellew katiksaˈan īˈ, gaˈ niyaˈ aˈa ellum. Saguwaˈ sabab meˈ aˈa tapeneˈnen kulangan Tuhanin du meˈ ellew īˈ. ");
INSERT INTO yka_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Bang niyaˈ si ellew īˈ magpaˈin si kaˈam, ‘Oy, payamanun bi, tiyaˈ Almasihin,’ atawa ‘īˈ iye laˈi,’ daˈa teˈed kahagadun bi. ");
INSERT INTO yka_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Peggeˈ si meˈ ellew īˈ, niyaˈ iyan paguwaˈ meˈ aˈa magpaˈin weˈ Almasihin siye bu gaˈi bennal. Niyaˈ isab iyan meˈ aˈa magpaˈin weˈ nabi siye bu gaˈi toˈo. Duk magpakite siye iyan meˈ tandaˈ balakatan duk meˈ hinangan makaˈulaliˈ supaya bang makajari taboˈode pasapeˈ bisan meˈ aˈa tapeneˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pakale kaˈam,” paˈin si Isa, “bakas ne kaˈam akahanku andang sabab meˈ inin pādpād gaˈ pe umantag. ");
INSERT INTO yka_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Hangkan hep bang paˈinde si kaˈam, ‘Payamanun be, īˈ iye laˈi si lahat makagindew-gindew,’ daˈa kaˈam hap pī. Bang paˈinde, ‘Payamanun be, tiyaˈ iye patapuk tuˈu,’ daˈa kaˈam kahagad. ");
INSERT INTO yka_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Peggeˈ aku, Anak Manusiyaˈin, bang ne ku pitu, takite papitukun kuweˈ lalat ninagan langitin amban silangan tudju seddepan.” ");
INSERT INTO yka_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Manjari mageliˈan si Isa, paˈinne, “Antag-antag kaniyaˈan bangkeyin laˈi magtipun meˈ owakin.” ");
INSERT INTO yka_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Manjari si meˈ ellew īˈ,” paˈin si Isa, “pagubus meˈ katiksaˈan miyaˈan, ngalindem mata ellewin duk bulanin gaˈi ne dantaˈ, duk meˈ poteˈanin magkalaboˈ-laboˈ amban diyataˈ langit duk meˈ bayuˈan diyataˈ langitin tahalaˈ amban lugalden. ");
INSERT INTO yka_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Manjari pagubus inin, kitede du ku, Anak Manusiyaˈin, pitu dem inalak. Takite meˈ aˈahin du sahayakun duk balakatku mahadjehin, duk magmatey kēmon aˈa amban kabangsa-bangsahan si dunyahin. ");
INSERT INTO yka_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ubus niyaˈ iyan helling kuweˈ helling tabuliˈ pales manamal duk daˈakku pitu meˈ malaˈikatkun nipun meˈ aˈa tapeneˈkun amban kaˈampat pidjū alamin.” ");
INSERT INTO yka_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Pandogahanun bi kayu igirahin,” paˈin si Isa. “Bang numbuˈ ne dawennen, kataˈuhanbi weˈ sōng baytu panas ne. ");
INSERT INTO yka_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Damikkiyan isab bang takitebi ne umantag meˈ pinaˈinku miyaˈan, kataˈuhanbi weˈ asal tapit ne teˈed pabalikkun. ");
INSERT INTO yka_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sabennal akahante kaˈam,” paˈin si Isa, “gaˈi pe ubus matey kēmon aˈa maˈellum kuweˈitu inin, tekka ne meˈ bakas pinaˈinku inin. ");
INSERT INTO yka_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Palabey hadja langitin duk dunyahin, saguwaˈ bang bissākun asal gaˈi usaˈ.” ");
INSERT INTO yka_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Saguwaˈ gaˈ niyaˈ ngataˈu bang ellew ine atawa waktu ine papituku balik si pasōnganin. Bisan meˈ malaˈikat si surgaˈin gaˈi kataˈuhande. Bisan aku, Anak Tuhanin, gaˈi du isab kataˈuhanku. Luwal Samaku Tuhanin mangataˈuhin. ");
INSERT INTO yka_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bang ne ku pitu balik si dunya, meˈ hinangan meˈ aˈahin kuweˈ du hinangan meˈ aˈa masa si Nu ley. ");
INSERT INTO yka_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Masa miyaˈan, gaˈ pe tekka laseyin, gaˈ niyaˈ tapikil meˈ aˈahin luwal mangan duk nginum, maganda duk magella sampay taˈabut ellew padiyalem si Nu dem kappalin. ");
INSERT INTO yka_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Gaˈ kataˈuhande bang ine maˈumantagin duk bessuwang hadja tekka laseyin duk lambo siye kēmon. Na, kuweˈ iyan du isab meˈ aˈahin bang aku, Anak Manusiyaˈin, pitu balik. ");
INSERT INTO yka_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ellew pabalikkun niyaˈ iyan duwangan lella maghinang si tanaˈ, dambuwaˈin ineddoˈ duk dambuwaˈin taˈamban. ");
INSERT INTO yka_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Niyaˈ iyan duwangan dende magtabang maggiling, dambuwaˈin ineddoˈ duk dambuwaˈin taˈamban. ");
INSERT INTO yka_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Hangkan papateng-pateng kaˈam, peggeˈ gaˈi kataˈuhanbi bang ellew ine papitukun. ");
INSERT INTO yka_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Saguwaˈ essebun bi inin, weˈ bang kataˈuhan dapuˈ lumaˈin bang waktu ine katekka panangkewin, tapagjaga iye duk gaˈi tapasagadanne lumaˈnen ilangkat duk inasek. ");
INSERT INTO yka_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Damikkiyan isab kaˈam, subey kaˈam luwal papateng-pateng peggeˈ aku, Anak Manusiyaˈin, tekka du ku pitu baytu gaˈi ku ase-asebi.” ");
INSERT INTO yka_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Bang niyaˈ daraˈakan tapangandelan duk hantap maghinang, iye iyan tahinang amunen nakuraˈ meˈ daraˈakanne sinduwehin. Bang taˈabut gantaˈ pagurung-urungin, iye mangurung bānyaˈ si meˈ daraˈakanin. ");
INSERT INTO yka_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pagtekka amunen balik, sinna manamal daraˈakan miyaˈan bang takite amunen weˈ tuhutne kēmon pangandaˈakan iyehin. ");
INSERT INTO yka_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sabennal akahante kaˈam weˈ pangandel amunen du si iye kēmon alataˈnen. ");
INSERT INTO yka_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Saguwaˈ bang saˈupama laˈat daraˈakan miyaˈan, duk paˈinne dem ateyne weˈ tiggel pe du tekka amunen, ");
INSERT INTO yka_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ubus papeddiˈanne meˈ pagkasine daraˈakanin, duk iye bahannen, magkakan duk maginuman duk meˈ luwal maglangohanin. ");
INSERT INTO yka_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Manjari bessuwang tekka amunen ellew gaˈ ase-asene duk waktu gaˈ kataˈuhanne. ");
INSERT INTO yka_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na, manjari bininasa teˈed iye weˈ amunen duk pinatuhut iye pī si lugal pinasukuˈ si meˈ aˈa magmā-mā manuhut Tuhanin. Laˈi magmatey meˈ aˈahin duk magtageˈot impenden.” ");
INSERT INTO yka_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Manjari magdalilan si Isa balik, paˈinne, “Bang pitu ne ku balik, pagbayaˈ Tuhanin kuweˈ inin. Niyaˈ sampūˈ budjang moˈo payitaˈanden dangan-dangan hap pī nampang pangantin lellahin. ");
INSERT INTO yka_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lime budjangin babbal duk limehin lalem pikilannen. ");
INSERT INTO yka_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Meˈ mababbalin boˈode payitaˈanden saguwaˈ gaˈ siye moˈo isellan pangiside balik bang ubus ne isellan dem payitaˈanden. ");
INSERT INTO yka_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Saguwaˈ meˈ budjang malalem pikilannen boˈode payitaˈanden sampay isellan dem pangisihanden. ");
INSERT INTO yka_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Peggeˈ tiggel tekka pangantin lellahin kinaruˈ siye duk ujud tumuli siye kēmon. ");
INSERT INTO yka_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pagnengaˈ bahangihin niyaˈ ngalingan, paˈinne, ‘Tiyaˈ ne pangantin lellahin, dayiˈ kaˈam sampangun bi iye.’ ");
INSERT INTO yka_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Manjari dongaˈ meˈ budjangin duk memesde payitaˈanden. ");
INSERT INTO yka_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Paˈin meˈ budjang mababbalin si meˈ malalem pikilannen, ‘Urunganun bi kami isellan, peggeˈ sōng pandem ne payitaˈan kamihin.’ ");
INSERT INTO yka_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Saguwaˈ nambung meˈ budjang malalem pikilannen, paˈinde, ‘Kaw gaˈi umabut si kite bi kēmon. Pī kaˈam si tinda bu bi melli isellan.’ ");
INSERT INTO yka_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Na, hap pī ne meˈ mababbalin melli. Sasangde mapīhin tekka ne pangantin lellahin. Meˈ lime budjang mamemesin nuhut padiyalem pī dem lumaˈ pagkawinanin ubus bu dininding ne gawangin. ");
INSERT INTO yka_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Gaˈ du tiggel tekka isab meˈ budjang sinduwehin duk paˈinde, ‘O Tuwan, lukahanun koˈ kami.’ ");
INSERT INTO yka_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Saguwaˈ nambung pangantin lellahin, paˈinne, ‘Gaˈi lukaku. Gaˈi kaˈam takilaleku.’ ");
INSERT INTO yka_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hangkan hep,” paˈin si Isa, “papateng-pateng kaˈam, peggeˈ gaˈi kataˈuhanbi bang ellew ine atawa waktu ine ku pitu balik.” ");
INSERT INTO yka_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Bang pitu ne ku balik, pagbayaˈ Tuhanin kuweˈ inin. Niyaˈ dambuwaˈ aˈa lumengngan hap lahat seddili. Sōng patahalaˈnen, daˈakne pī si iye meˈ daraˈakannen duk pinangandel weˈ ne si siye sīnnen. ");
INSERT INTO yka_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sīn pinangandelne si siyehin pinagtuhut duk kataˈuden. Dambuwaˈin inurungan weˈ ne lime ngibu pilak, dambuwaˈin duwe ngibu, duk dambuwaˈin da ngibu pilak. Ubus tahalaˈ ne iye. ");
INSERT INTO yka_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Daraˈakan bakas inurungan lime ngibu pilakin magtawus hap pī maglitu, duk makaˈuntung iye lime ngibu pilak. ");
INSERT INTO yka_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Damikkiyan du isab daraˈakan taga duwe ngibuhin, makaˈuntung isab iye duwe ngibu. ");
INSERT INTO yka_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Saguwaˈ dambuwaˈ bakas inurungan da ngibu pilakin, hap pī magkali bu tinapukan weˈ ne sīn amunen dem bulak. ");
INSERT INTO yka_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagtiggel ne teˈed, tekka ne balik amu meˈ daraˈakan miyaˈan. Manjari tilewne siye bang ine bakas hininangde duk sīnnen. ");
INSERT INTO yka_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Daraˈakanne bakas inurungan lime ngibu pilakin pī moˈo untungne lime ngibuhin duk paˈinne, ‘Tuwan, bakas urungannu ku lime ngibu pilak, makaˈuntung ku lime ngibu isab.’ ");
INSERT INTO yka_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Paˈin amunen si iye, ‘Hāp hininangnun. Daraˈakan hāp kew duk tapangandelan kew. Tapangandelan kew si meˈ kuweˈahat hangkan pangandelku du si kaˈu alataˈkun pinaˈekka. Dayiˈ kew, patuhut kew si aku magkēg.’ ");
INSERT INTO yka_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ubus hap pī isab daraˈakan bakas inurungan duwe ngibu pilakin. Paˈinne, ‘Tuwan, bakas urungannu ku duwe ngibu pilak. Makaˈuntung ku duwe ngibu isab.’ ");
INSERT INTO yka_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Paˈin amunen si iye, ‘Hāp hininangnun. Daraˈakan hāp kew duk tapangandelan kew. Tapangandelan kew si meˈ kuweˈahat, hangkan pangandelku du si kaˈu alataˈkun pinaˈekka. Dayiˈ kew, patuhut kew si aku magkēg.’ ");
INSERT INTO yka_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ubus hap pī isab daraˈakan bakas inurungan da ngibu pilakin duk paˈinne, ‘Tuwan, kataˈuhanku weˈ gaˈi kew maˈaseˈ si aˈa. Eddoˈnu dumaˈin si kaˈuhin duk paganinu manggaˈ bakas pagluˈugannun. ");
INSERT INTO yka_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tinalew ku si kaˈu, hangkan hap pī ku napukan sīnnun dem bulak. Tiyaˈ ne sīnnun.’ ");
INSERT INTO yka_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nambung amunen, paˈinne, ‘Kaˈu iyan daraˈakan laˈat duk bulasan. Kataˈuhannu hatiˈ weˈ eddoˈku dumaˈin si akuhin duk paganiku manggaˈ bakas pagluˈugankun. ");
INSERT INTO yka_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na, weˈey gaˈ papīnu sīnkun si bangku duk nganak? Manjari pagbalikku pitu taˈeddoˈku siˈ sīnkun sampay anaknen.’ ");
INSERT INTO yka_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Manjari paˈinne si daraˈakanne seddilihin, ‘Eddoˈun sīnin amban iye duk pangurungun pī si dambuwaˈ taga sampūˈ ngibu pilakin. ");
INSERT INTO yka_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aˈa tapangandelanin, inurungan pe namba duk ekka manamal si iyehin. Saguwaˈ manggaˈi tapangandelanin, bisan kuweˈahat bakas pinangandel si iyehin, ineddoˈ du amban iye. ");
INSERT INTO yka_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na, daraˈakan manggaˈ niyaˈ kagunahanne inin, pabukutun bi pinadem lindem. Magmatey meˈ aˈahin laˈi duk magtageˈot meˈ impenden.’” ");
INSERT INTO yka_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Manjari paˈin si Isa, “Bang aku, Anak Manusiyaˈin, pitu balik magtuhut duk meˈ malaˈikatin kēmon, aku ne magbayaˈin. Manjari ningkoloˈ ku si paghukuman. ");
INSERT INTO yka_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kēmon aˈa amban kabangsa-bangsahan si dunyahin pinagtipun du si harapanku duk pagsapeˈku siye, kuweˈ aˈa magipat hayepin pagsapeˈne meˈ bili-bilihin duk meˈ kambingin. ");
INSERT INTO yka_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Meˈ aˈa mabentelin papīku si kanawananku duk meˈ sinduwehin si bibanganku. ");
INSERT INTO yka_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Manjari aku, magbayaˈin, paˈinku iyan si meˈ aˈa si kanawanankun, ‘Kaˈam, meˈ kaˈurungan kahāpan weˈ Samaku Tuhanin, pitu kaˈam, patennaˈ tuˈu si pagbayaˈanku peggeˈ inin andang pinanyap para si kaˈam kemuwe tagnaˈ dunyahin. ");
INSERT INTO yka_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Peggeˈ bakas inusan ku bu pinakan ku weˈ bi, duk lekkakan ku bu inurungan ku ininum weˈ bi, aˈa liyu-liyu ku bu inaddatan ku weˈ bi. ");
INSERT INTO yka_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Gaˈ niyaˈ semmekku bu pinasemmekan ku weˈ bi, bakas ku saki bu inipat ku weˈ bi, bakas ku kinalabusu bu binisita ku weˈ bi.’ ");
INSERT INTO yka_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ubus magpaˈin iyan meˈ aˈa bentel laˈi si kanawanankun, ‘Tuwan, sumiyan kew bakas takite kami inusan duk urungan kami kew kinakan, atawa lekkakan duk urungan kami kew ininum? ");
INSERT INTO yka_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Sumiyan kew takite kami kuweˈ aˈa liyu-liyu duk inaddatan kew weˈ kami? Sumiyan kew kanggaˈan semmek duk inurungan kew weˈ kami? ");
INSERT INTO yka_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Duk sumiyan kasakinun duk pangalabusu si kaˈuhin duk pī kami misita kaˈu?’ ");
INSERT INTO yka_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Manjari aku, magbayaˈin, nambung du ku, paˈinku, ‘Sabennal akahante kaˈam, sumiyan-sumiyan hinangbi inin si meˈ tindegku madiyawaˈ pagaˈanen, hinangbi du teˈed si aku.’ ");
INSERT INTO yka_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ubus paˈinku du iyan si meˈ aˈa si bibangankun, ‘Kaˈam, meˈ pagmulkaˈan Tuhanin, tahalaˈ kaˈam amban aku duk pī kaˈam dem ebbut narkaˈ pinanyap andang para si nakuraˈ seyitanin duk si meˈ daraˈakannen. ");
INSERT INTO yka_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Peggeˈ bakas inusan ku bu gaˈ ku urunganbi kinakan, lekkakan ku bu gaˈ ku urunganbi ininum. ");
INSERT INTO yka_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aˈa liyu-liyu ku bu gaˈ ku addatanbi, gaˈ niyaˈ semmekku bu gaˈ ku urunganbi, bakas ku saki duk dem kalabusu bu gaˈ ku bisitabi.’ ");
INSERT INTO yka_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ubus tilewde du ku iyan, paˈinde, ‘Tuwan, sumiyan kew takite kami inusan atawa lekkakan? Sumiyan kew takite kami kuweˈ aˈa liyu-liyu, atawa gaˈ niyaˈ semmeknu atawa saki atawa dem kalabusu bu gaˈ kew tabangan kami?’ ");
INSERT INTO yka_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ubus nambung ku iyan, paˈinku, ‘Sabennal akahante kaˈam, bang gaˈ tabangbi meˈ tindegku madiyawaˈ pagaˈanen, aku du gaˈ tinabangbin.’ ");
INSERT INTO yka_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Manjari meˈ aˈa inin pinadem narkaˈ du duk magtiksaˈ siye salama-lama, saguwaˈ meˈ aˈa mabentelin pinapī du si surgaˈ duk niyaˈ umulde salama-lama.” ");
INSERT INTO yka_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagubus inin binissā weˈ si Isa kēmon, paˈinne si meˈ tindegnen, ");
INSERT INTO yka_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kataˈuhanbi weˈ sumudde ne ellew Kādjaˈan Pangessebanin. Ellew iyan aku, Anak Manusiyaˈin, sinōngan du ku supaya ku talansang diyataˈ olom.” ");
INSERT INTO yka_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Manjari magtipun ne meˈ nakuraˈ imamin duk meˈ bahiˈin laˈi si astanaˈ si Kayapas, imam nakuraˈin. ");
INSERT INTO yka_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Magisun siye bang saˈingge paniggewde duk pamapateyde si Isahin duk gaˈi kataˈuhan meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Daˈa bang baytu kādjaˈanin,” paˈinde, “kaw hewuhalaˈ meˈ aˈahin.” ");
INSERT INTO yka_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Paglaˈi si Isa si lahat Betani si lumaˈ si Simon aˈa bakas inipulin, ");
INSERT INTO yka_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","niyaˈ dende tekka pī magboˈo isellan bengngi. Pangisihannen batu alabaster hininangin. Sasang si Isa mangan, hap pī dendehin muˈusan isellan bengngihin diyataˈ kōk si Isa. ");
INSERT INTO yka_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pagkite miyaˈan weˈ meˈ tindeg si Isahin, astel siye duk magbissā-bissā siye, paˈinde, “Weˈey isellan bengngi miyaˈan pinakaˈatan sa miyaˈan? ");
INSERT INTO yka_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gam pe miyaˈan pinabellihan langkew bu pangurung ulinen si meˈ mamiskinin.” ");
INSERT INTO yka_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kataˈuhan si Isa pagbissāden duk paˈinne, “Weˈey iye sasewbi? Hāp hininangne si aku inin. ");
INSERT INTO yka_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Peggeˈ mamiskinin,” paˈin si Isa, “gaˈi du usaˈ amban kaˈam, saguwaˈ aku, gaˈi ku teteg tuˈu si kaˈam. ");
INSERT INTO yka_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Binuˈusan weˈ ne isellan bengngi inin si baranku pamanyap aku bang ku kinubul. ");
INSERT INTO yka_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sabennal akahante kaˈam,” paˈin si Isa, “antag-antag si tibuˈukan dunya minahalayak aka-aka mahāpin, inaka-aka du isab tahinang dende si aku inin, pangesseb-ngesseban meˈ aˈahin iye.” ");
INSERT INTO yka_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Manjari pagubus miyaˈan si Judas Iskariyot, dambuwaˈ si meˈ tindeg si Isa sampuk-duwehin, hap pī si meˈ nakuraˈ imamin. ");
INSERT INTO yka_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Paˈinne si siye, “Piye sīn ku urungbi bang sōnganku kaˈam si Isa.” Binayedan iye weˈ de tellumpūˈ kayuˈ sīn tuwas, pilak teˈed. ");
INSERT INTO yka_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Puwas miyaˈan miha ne si Judas waktu hāp panōngne si Isa si siye. ");
INSERT INTO yka_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Manjari taˈabut ne tagnaˈ ellew kādjaˈanin, pagkakande pan gaˈi sinagetan pasuligin. Pī meˈ tindegnen pu si Isa, paˈinde, “Tuwan, antag kami kabayaˈannu pī manyapan kaˈu pamanganannu kādjaˈan inin?” ");
INSERT INTO yka_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Paˈin si Isa, “Pī kaˈam si puweblo si aˈa dambuwaˈ miyaˈan duk paˈinun bi si iye, ‘Paˈin guruhin, mabayaˈ koˈ iye magjamu duk meˈ tindegnen luˈu si lumaˈnu para si Kādjaˈan Pangessebanin peggeˈ tapit ne koˈ kamateynen.’” ");
INSERT INTO yka_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Manjari hap pī ne meˈ tindegnen duk hininang weˈ de sa pangandaˈakan si Isa siyehin duk maghatul ne siye laˈi kinakande para si pagjamu-jamuhan Pangessebanin. ");
INSERT INTO yka_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pagsangem ne, ningkoloˈ ne si Isa magtuhut duk tindegne sampuk-duwehin mangan. ");
INSERT INTO yka_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sasangde mamanganin paˈin si Isa, “Sabennal akahante kaˈam, niyaˈ dangan si kaˈam muddihan aku.” ");
INSERT INTO yka_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dukka teˈed siye duk maggantiˈ siye nilew iye. Paˈin dangan-dangan, “Bugtuˈ dumaˈin aku, Tuwan, ēˈ?” ");
INSERT INTO yka_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nambung iye, paˈinne, “Saweˈku magsawu dem pingganin, iye iyan mamuddihan akuhin. ");
INSERT INTO yka_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Aku inin, Anak Manusiyaˈin,” paˈin si Isa, “matey du ku peggeˈ iye iyan gantaˈankun, sa sinulat dem kitabin. Saguwaˈ makaˈaseˈ-aseˈ teˈed aˈa mamuddihan Anak Manusiyaˈin. Gam pe aˈa miyaˈan gaˈ inanakan.” ");
INSERT INTO yka_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ubus paˈin si Judas, iye sōng mamuddihan si Isahin, “Bugtuˈ dumaˈin aku, Tuwan, ēˈ?” Paˈin si Isa, “Kaˈu hep.” ");
INSERT INTO yka_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sasangde mamanganin, ngeddoˈ si Isa pan, duk pagubus iye magpasalamat si Tuhan, kinepak-kepak weˈ ne bu pinangurung weˈ ne si meˈ tindegnen. Paˈinne, “Ngeddoˈ kaˈam bu mangan kaˈam. Pan inin barankun.” ");
INSERT INTO yka_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Manjari ngeddoˈ iye sawan duk pagubus iye magpasalamat si Tuhan, pinangurung weˈ ne si siye, paˈinne, “Kēmon kaˈam inumun bi inin, ");
INSERT INTO yka_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","peggeˈ inin lahaˈkun sōng buˈus sabab meˈ aˈa ekka supaya inampun meˈ duseden. Inin tandaˈ weˈ tumanan Tuhanin du janjiˈnen. ");
INSERT INTO yka_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Akahante kaˈam, puwas inin gaˈi ne ku nginum boheˈ ubas balik samantaˈan gaˈi pe kite bi magtuhut nginum ininum baˈahuhin dem pagbayaˈan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ubus inin ngalang siye dambuwaˈ kalangan pamudji Tuhan ubus bu paluwas ne siye pī si kūd Jaitun. ");
INSERT INTO yka_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Manjari paˈin si Isa si siye, “Sangem inin kēmon kaˈam ambananbi du ku, peggeˈ tasulat inin dem kitab, pinaˈin, ‘Daˈakku pinapatey magbantey bili-bilihin, manjari meˈ bili-bilinen magkanat-kanat.’ ");
INSERT INTO yka_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Saguwaˈ pagellum ne ku balik, magkasuwaˈ du kite bi. Padehellu ku amban kaˈam pī si lahat Jalil.” ");
INSERT INTO yka_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Manjari paˈin si Petros si iye, “Bisan kēmon siye ngambanan kaˈu, Tuwan, saguwaˈ aku, asal gaˈi kew ambananku.” ");
INSERT INTO yka_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Paˈin si Isa si iye, “Sabennal akahante kew, sangem inin du, gaˈi pe manukin makatingkowak, kapamasuwey ne kew mintellu weˈ gaˈi ku kataˈuhannu.” ");
INSERT INTO yka_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Saguwaˈ paˈin si Petros, “Bisan pe ku matey patuhut si kaˈu, asal gaˈi kew teˈed pasuweyanku.” Duk kēmon tindeg si Isahin kuweˈ inin isab binissāden. ");
INSERT INTO yka_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Manjari palanjal disi Isa pī si kabbun inēnan Getsemane. Paˈin si Isa si meˈ tindegnen, “Ningkoloˈ kaˈam tuˈu tiggelanku laˈi māku-māku si Tuhan.” ");
INSERT INTO yka_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Binoˈo weˈ ne si Petros duk meˈ anak Sebede duwanganin. Nagnaˈ iye kebba-kebbahan duk sasew dem ateynen. ");
INSERT INTO yka_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Manjari paˈinne si siye, “Ateykun dukka teˈed, agen-agen makamatey aku. Paˈamban ne kaˈam tuˈu duk magjaga kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Manjari lumengngan iye patala-tala duk pasujud iye diyataˈ bulak duk ngampun iye si Tuhan, paˈinne, “O Ammaˈ, bang makajari, daˈa ku pasagadanun bininasa. Saguwaˈ dumaˈin tinuhutin kinabayaˈankun saguwaˈ kinabayaˈannun.” ");
INSERT INTO yka_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Manjari balik iye pī si meˈ tindegnen, duk takitene siye kapatuli. Bangunne siye duk paˈinne pu si Petros, “Gaˈi kaˈam kapanuhut aku magjaga bisan da ora? ");
INSERT INTO yka_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Papateng-pateng kaˈam, duk māku-māku kaˈam si Tuhan supaya kaˈam gaˈi taboˈo weˈ sassat. Tapikil weˈ atey saguwaˈ gaˈi kaˈanggawtaˈan weˈ baran.” ");
INSERT INTO yka_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Manjari tahalaˈ ne isab si Isa duk māku-māku iye si Tuhan, paˈ inne, “O Ammaˈ, bang subey teˈed ku lumabey si meˈ kabinasahan inin, na, tuhutku ne kinabayaˈannun.” ");
INSERT INTO yka_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ubus balik ne isab iye pī si meˈ tindegnen duk takitene siye kapatuli peggeˈ kinaruˈ teˈed siye. ");
INSERT INTO yka_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tahalaˈ ne isab iye balik duk māku-māku iye si Tuhanin kamintellunen, binalik weˈ ne bakas binissāne si Samanen. ");
INSERT INTO yka_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagbalik si Isa si meˈ tindegnen, paˈinne si siye, “Tuli pe kaˈam duk pahali pe? Pakale kaˈam, tekka ne waktuhin. Aku, Anak Manusiyaˈin, sōng sinōngan ne si antanan meˈ aˈa dusehan. ");
INSERT INTO yka_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kuwat kaˈam, sūng ne kite bi. Payamanun bi, tiyaˈ ne aˈa mamuddihan akuhin.” ");
INSERT INTO yka_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sasang missā pe si Isa, tekka ne si Judas. Dambuwaˈ iye si meˈ sampuk-duwe tindeg si Isahin. Banes teˈed aˈa nuhut si Judas magbarung duk magboˈo meˈ kakakal. Siye miyaˈan dinaˈak pī weˈ meˈ nakuraˈ imamin duk meˈ kabahiˈanin. ");
INSERT INTO yka_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kaˈurungan siye indan weˈ si Judas. Bakas paˈinne hep si siye, “Sine-sine ūkku, iye ne iyan aˈahin. Siggewun bi iye.” ");
INSERT INTO yka_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pagtekka siye laˈi, magtawus si Judas patapit pu si Isa duk paˈinne, “Na, aku ituˈ, Tuwan.” Ubus bu inūk si Isa weˈ ne. ");
INSERT INTO yka_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Paˈin si Isa si iye, “Bagay, hinangun ne akanu mapituhin.” Manjari patapit meˈ aˈa sinduwehin duk siniggew weˈ de si Isa duk inantan weˈ de pahaget. ");
INSERT INTO yka_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dambuwaˈ meˈ saweˈ si Isahin ngurus barungnen bu pineddang weˈ ne daraˈakan imam nakuraˈin duk butas tayingenen. ");
INSERT INTO yka_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Paˈin si Isa si iye, “Isihun balik bessinun dem tagubanne. Peggeˈ sine-sine ngangguna bessi pagbonoˈ, matey du isab iye weˈ bessi. ");
INSERT INTO yka_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gaˈi ke kataˈuhannu weˈ bang ku māku tabang si Samaku Tuhanin, magtawus ku paboˈohanne ibuhan malaˈikatnen? ");
INSERT INTO yka_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Saguwaˈ bang ku māku tabang gaˈi tuman bissā Tuhan dem kitabin weˈ kēmon inin subey umantag.” ");
INSERT INTO yka_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ubus paˈin si Isa si meˈ aˈa mabanesin, “Weˈ kannalbi mundu ku hangkan kaˈam pitu niggew aku magbarung duk magboˈo meˈ kakakal? Ellew-ellew ningkoloˈ ku laˈi dem langgal hadjehin magtoloˈ, saguwaˈ gaˈ ku siggewbi laˈi. ");
INSERT INTO yka_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Saguwaˈ kuweˈitu inin,” paˈinne, “umantag ne inin kēmon supaya katumanan meˈ tasulat weˈ meˈ kanabihan dem kitabin.” Manjari tinayikutan si Isa weˈ meˈ tindegnen kēmon duk lahi siye. ");
INSERT INTO yka_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Manjari binoˈo si Isa weˈ meˈ aˈa maniggew iyehin pī pu si Kayapas, iye imam nakuraˈin. Meˈ guru si saraˈ āgamahin duk meˈ kabahiˈanin magtipun du isab laˈi. ");
INSERT INTO yka_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na, si Petros paturul pu si Isa saguwaˈ patala-tala, sampay pī si lame lumaˈ imam nakuraˈin. Padiyalem iye si lamehin duk ningkoloˈ iye duk meˈ guwaldiyahin, peggeˈ mabayaˈ payamanne bang ine kaˈujudanne miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Manjari meˈ nakuraˈ imamin duk meˈ guru saraˈin duk meˈ kabahiˈanin miha pureba panuntutande si Isa supaya iye tapapateyde. ");
INSERT INTO yka_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Saguwaˈ gaˈ niyaˈ kasuwaˈde panuntutande iye bisan du ekka naksiˈ gaˈi bennal. Ujudnen niyaˈ duwangan missā, paˈinde, ");
INSERT INTO yka_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Bakas paˈin aˈa iyan weˈ talarakne koˈ langgal hadjehin duk tapatenggene balik dem tellu ellew.” ");
INSERT INTO yka_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Manjari nengge imam nakuraˈin duk paˈinne pu si Isa, “Gaˈ niyaˈ sambungnu si meˈ tuntutde si kaˈu inin?” ");
INSERT INTO yka_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Saguwaˈ gaˈ nambung si Isa. Ubus missā imam nakuraˈin balik, paˈinne, “Napa kew, iyuˈ Tuhanin pakale-kale duk akahanun kami bang Almasihin ke kew, Anak Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Paˈin si Isa si iye, “Toˈo pinaˈinnun, duk akahante kaˈam kēmon, gaˈi tiggel kitebi du ku, Anak Manusiyaˈin, ningkoloˈ si kanawanan Tuhan Mabalakatanin. Duk kitebi du ku iyan pitu nuhut meˈ inalak amban diyataˈ langit.” ");
INSERT INTO yka_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Manjari ginaret weˈ imam nakuraˈin semmeknen hawal peddiˈ ateynen, duk paˈinne, “Missā iye kuweˈ Tuhanin iye. Weˈey pe kite bi subey miha meˈ saksiˈ? Takalebi ne binissāne miyaˈan, kuweˈ Tuhanin iye. ");
INSERT INTO yka_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ine hukumanbin?” Paˈinde, “Hukuman kamihin weˈ pataˈ iye pinapatey.” ");
INSERT INTO yka_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ubus iluraˈan iye weˈ de si luwene duk pinagsuntukan weˈ de. Sinduwehin sampakde iye ");
INSERT INTO yka_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","duk paˈinde, “Bang Almasihin kew, akahanun kami bang sine bakas manampak kaˈuhin.” ");
INSERT INTO yka_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Manjari, si Petros laˈi si lame ningkoloˈ. Niyaˈ dambuwaˈ daraˈakan dende hap pī si iye duk paˈinne, “Kaˈu iyan, saweˈ si Isa, aˈa Jalilin, du isab.” ");
INSERT INTO yka_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Saguwaˈ masuwey iye si harapande kēmon, paˈinne, “Gaˈi kataˈuhanku bang ine binissānu iyan.” ");
INSERT INTO yka_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ubus hap pī iye tudju tarangka. Niyaˈ daraˈakan dende seddili ngite iye. Pagkitene si Petros, paˈinne si meˈ aˈa magtengge malaˈihin, “Aˈa iyan saweˈ si Isa, aˈa amban Nasaretin.” ");
INSERT INTO yka_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Saguwaˈ masuwey ne isab si Petros. Napa pe iye duk paˈinne, “Gaˈi kataˈuhanku aˈa iyan.” ");
INSERT INTO yka_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Gaˈ tiggel pī pu si Petros meˈ aˈa magtengge malaˈihin duk paˈinde si iye, “Gaˈi kew kapamasuwey weˈ dumaˈin kew saweˈde, peggeˈ bissāhannun bissāhan aˈa Jalil.” ");
INSERT INTO yka_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Saguwaˈ suknaˈan si Petros dinen duk napa iye, paˈinne, “Asal gaˈi kataˈuhanku aˈa iyan.” Magtawus tingkowak manukin. ");
INSERT INTO yka_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Manjari taˈesseb si Petros bakas binissā si Isahin, paˈinne, “Gaˈi pe makatingkowak manukin sangem inin, kapamasuwey ne kew mintellu weˈ gaˈi ku kataˈuhannu.” Manjari tahalaˈ si Petros duk magtangis teˈed iye. ");
INSERT INTO yka_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pagsalung ne magisun kēmon meˈ nakuraˈ imamin duk meˈ kabahiˈanin bang saˈingge pamapateyde si Isahin. ");
INSERT INTO yka_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Manjari pagubus siye magisun, iningketan weˈ de si Isa duk binoˈo weˈ de pī sinōngan pu si Pilatus, iye gubnul bangsa Romahin. ");
INSERT INTO yka_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pagkataˈuhan si Judas, iye mamuddihan si Isahin, weˈ ubus ne hinukum si Isa pinapatey, magsusun teˈed iye duk hap pī iye si meˈ nakuraˈ imamin duk meˈ kabahiˈanin mabalik tellumpūˈ kayuˈ sīn tuwasin. ");
INSERT INTO yka_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Paˈinne si siye, “Bakas magduse ku, peggeˈ binuddihan weˈ ku aˈa manggaˈ niyaˈ dusenen bu sōng iye pinapatey.” Nambung siye, paˈinde, “Gaˈ ne niyaˈ lamud kami luˈu. Bayaˈ-bayaˈnu ne.” ");
INSERT INTO yka_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Manjari ilakasan weˈ si Judas sīnin dem langgal hadjehin bu tahalaˈ iye. Pī iye mowet dine duk iye matey. ");
INSERT INTO yka_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Manjari tinimuk weˈ meˈ nakuraˈ imamin sīnin duk paˈinde, “Gaˈi makajari sīn inin pinatampu si sīn langgalin peggeˈ sīn inin bakas pagtangdan mapatey aˈa.” ");
INSERT INTO yka_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Magisun siye weˈ gunade sīn miyaˈan pamellide bulak aˈa maghinang-hinang paliyukin duk hinangde pagkubulan meˈ aˈa liyu-liyu. ");
INSERT INTO yka_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hangkan hep bulak miyaˈan inēnan “Bulak Lahaˈ” sampay kuweˈitu, peggeˈ sīn pamelli iyehin sīn bakas pagtangdan mapatey. ");
INSERT INTO yka_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Manjari tuman ne bissā Nabi Jeremiya bakas sinulat dem kitabin, paˈinne, “Eddoˈde tellumpūˈ kayuˈ sīn tuwasin, iye halgaˈ pagisunan meˈ aˈa Israˈilin, ");
INSERT INTO yka_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","duk gunade inin pamellide bulak aˈa maghinang paliyukin. Inin bakas pangandaˈakan aku weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Manjari paglaˈi ne si Isa si harapan gubnulin, tinilew iye weˈ gubnulin, paˈinne, “Sultan meˈ Yahudihin ke kew?” Nambung si Isa, paˈinne, “Iye du pinaˈinnu iyan.” ");
INSERT INTO yka_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Saguwaˈ sakaliˈ iye tinuntutan weˈ meˈ nakuraˈ imamin duk meˈ kabahiˈanin, gaˈ iye nambung. ");
INSERT INTO yka_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Paˈin Pilatus si iye, “Gaˈi takalenu kēmon tuntutde si kaˈu inin?” ");
INSERT INTO yka_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Saguwaˈ gaˈ nambung si Isa bisan da tegtang, hangkan ulaliˈ teˈed gubnulin. ");
INSERT INTO yka_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na, kahabaˈ tahun bang baytu Kādjaˈan Pangesseban, iye addat gubnulin maluwas iye dambuwaˈ pilisu sine-sine kabayaˈan meˈ aˈahin pinaluwas. ");
INSERT INTO yka_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Masa miyaˈan, niyaˈ dambuwaˈ pilisu bantu, inēnan Barabbas. ");
INSERT INTO yka_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Manjari pagtipun ne meˈ aˈa mabanesin, paˈin Pilatus si siye, “Sine kabayaˈanbi pinaluwaskun, Barabbas atawa si Isa inēnan Almasihin.” ");
INSERT INTO yka_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Hangkan siye tinilew weˈ ne sa miyaˈan peggeˈ kataˈuhanne weˈ sinōngan si Isa weˈ meˈ nakuraˈ meˈ Yahudihin si iye peggeˈ kinimbūhan si Isa weˈ de. ");
INSERT INTO yka_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sasang ningkoloˈ Pilatus si siya paghukumanin, masan andanen si iye, paˈinne, “Daˈa kew maghinang ine-ine si aˈa manggaˈ niyaˈ dusene iyan. Peggeˈ dibuhiˈ niyaˈ taginepku duk magsandal ku teˈed dem taginepkun sabab iye.” ");
INSERT INTO yka_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Saguwaˈ meˈ aˈa mabanesin tasegeˈ weˈ meˈ nakuraˈ imamin duk meˈ kabahiˈanin weˈ subey pākude pinaluwas si Barabbas duk si Isa subey pinapatey. ");
INSERT INTO yka_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tinilew siye balik weˈ Pilatus, paˈinne, “Inggehin si duwangan inin kabayaˈanbi pinaluwaskun?” “Si Barabbas,” paˈinde. ");
INSERT INTO yka_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Paˈin Pilatus si siye, “Na, inumeyku pu si Isa, inēnan Almasihin?” Paˈinde kēmon, “Lansangun iye diyataˈ olom.” ");
INSERT INTO yka_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Saguwaˈ paˈin Pilatus, “Weˈey? Ine laˈat tahinangnen?” Saguwaˈ pasōng ne siye magkalolop, paˈinde, “Lansangun iye diyataˈ olom.” ");
INSERT INTO yka_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kataˈuhan Pilatus weˈ gaˈ niyaˈ gunane magbissā namba, peggeˈ sōng hewuhalaˈ meˈ aˈa mabanesin. Manjari ngeddoˈ iye boheˈ duk kinosoˈan weˈ ne tangannen si harapan meˈ aˈahin, tandaˈ weˈ gaˈ iye palamud si hinanganden. Duk paˈinne, “Bang matey aˈa inin gaˈ niyaˈ duseku. Kaˈam dinusehin.” ");
INSERT INTO yka_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nambung kēmon meˈ aˈahin, paˈinde, “Ambat kamateynen moleˈ si kami duk si meˈ anak kamihin.” ");
INSERT INTO yka_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ubus pinaluwas ne weˈ Pilatus Barabbas pī si siye. Duk si Isa daˈakne ilubakan ubus bu sinōngan ne iye weˈ ne supaya iye talansang diyataˈ olom. ");
INSERT INTO yka_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Manjari binoˈo si Isa weˈ meˈ sundalu Pilatusin pī dem astanaˈ gubnulin duk patipun pī kēmon sundalu da kumpaniyahin. ");
INSERT INTO yka_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Paglaˈi siye kinuwantangan weˈ de si Isa duk pinasemmekan iye weˈ de semmek taluk kuweˈ bantuk semmek sultan masaley. ");
INSERT INTO yka_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ngalakal siye bāhan luhihan hininang kuweˈ korona sultan bu pinapī weˈ de si kōk si Isa. Ubus pinaˈantanan weˈ de si Isa kayu-kayu si tanganne kanawanin. Pagubus miyaˈan pasujud siye magmā-mā mahadje iye duk paˈinde, “Assalamu alaikum Sultan meˈ Yahudihin.” ");
INSERT INTO yka_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ubus pinagluraˈan si Isa weˈ de duk ineddoˈ weˈ de kayu-kayu inantanannen bu pinogpog weˈ de kōknen. ");
INSERT INTO yka_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagubus iye hinangde dagey, iluwasan weˈ de semmek taluk miyaˈan duk pinasemmekan iye balik duk semmeknen. Ubus binoˈo ne iye weˈ de pabukut duk ne iye talansangde diyataˈ olom. ");
INSERT INTO yka_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sasangde paluwas amban puweblo, niyaˈ tadugpakde lella amban lahat Kirene, ēnnen si Simon. Ginagahan iye weˈ meˈ sundaluhin dinaˈak pinanangkit olom sōng pangalansangan si Isahin. ");
INSERT INTO yka_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pagtekka siye laˈi si lugal inēnan Golgota, hātinen, “Lahatan Bungkug,” ");
INSERT INTO yka_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","niyaˈ sōng pamaˈinumde iye boheˈ ubas sinagetan tambal paˈit, saguwaˈ pagtakinamne gaˈ inumne. ");
INSERT INTO yka_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pagubus ne si Isa ilansang diyataˈ olom, maglegot meˈ sundaluhin pagbahagiˈde semmek si Isahin. ");
INSERT INTO yka_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ubus ningkoloˈ siye laˈi manteyan iye. ");
INSERT INTO yka_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sinulat laˈi si atag kōk si Isa tuntut si iyehin, pinaˈin, “Inin si Isa Sultan meˈ Yahudihin.” ");
INSERT INTO yka_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Niyaˈ duwangan mundu pinasumbayaˈ pu si Isa ilansang diyataˈ olomde. Dambuwaˈ olomin pinatengge si kanawananne duk dambuwaˈin si bibanganne. ");
INSERT INTO yka_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Meˈ aˈa mapalabeyin pinagsayehan iye weˈ de. Magkeleng-keleng siye duk paˈinde pu si Isa, ");
INSERT INTO yka_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Aha, bakas paˈinnu weˈ talaraknu langgal hadjehin ubus bu patenggenu balik dem tellu ellew. Na, weˈey gaˈi tabangnu dinun? Bang bennal kew Anak Tuhanin, duwaˈi kew amban diyataˈ olom iyan.” ");
INSERT INTO yka_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Damikkiyan isab meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin duk meˈ kabahiˈanin pagudjiˈande iye, paˈinde, ");
INSERT INTO yka_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Bakas tabangne aˈa seddilihin, saguwaˈ dinen gaˈi tatabangne. Iye koˈ sultan meˈ Israˈilin. Na, ambat iye duwaˈi amban olom iyan kuweˈitu duk kite bi kahagad si iye. ");
INSERT INTO yka_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ngandel iye si Tuhan duk paˈinne weˈ Anak Tuhanin iye. Payamante bi koˈ bang asal tabang Tuhanin iye.” ");
INSERT INTO yka_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bisan meˈ mundu ilansang pinasumbayaˈ si iyehin matuk du isab missā-missāhan iye. ");
INSERT INTO yka_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na, paglettu ne ellewin maglindem dem tibuˈukan lahat miyaˈan sampay lisag tellu kohapin. ");
INSERT INTO yka_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Paglisag tellu ne magkilahap si Isa papales, paˈinne, “Eli, Eli, lama sabachthani?” Hātinen, “O Tuhanku, weˈey ku pasagadannu?” ");
INSERT INTO yka_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pagtakale inin weˈ meˈ aˈa magtengge-tengge malaˈihin, paˈin sinduwehin, “Lingananne Nabi Eliyas.” ");
INSERT INTO yka_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dangan siye magtawus magubas pī ngeddoˈ kuweˈ gapas bu ngaleglebanne magdem ininum. Ubus tinogsokan weˈ ne miyaˈan diyataˈ kayu-kayu bu sinōngan weˈ ne pamasessep pu si Isa. ");
INSERT INTO yka_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Saguwaˈ sinduwehin paˈinde, “Daˈa kew dahuˈ, payamante bi bang pitu ke Nabi Eliyas nabang iye.” ");
INSERT INTO yka_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Manjari magkilahap si Isa balik ubus bu bekkat ne napasnen. ");
INSERT INTO yka_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Magtawus garet semmek subuk hinang ellig dem langgal hadjehin. Garet paduwe amban diyataˈ ngeregseˈ diyawaˈ. Niyaˈ isab linug duk niyaˈ meˈ batu hadje kepak. ");
INSERT INTO yka_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Luka isab meˈ lingab pagkubulanin duk ekka aˈa mamatey makahagad si Tuhanin ellum balik. ");
INSERT INTO yka_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pagellum ne si Isa balik, paluwas siye amban lingab pangubulan siyehin duk hap pī siye si Awrusalam. Ekka aˈa ngite siye. ");
INSERT INTO yka_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kapitanin duk meˈ sundalune mamanteyan si Isahin, pagkitede linugin duk meˈ maˈumantagin, tinalew teˈed siye duk paˈinde, “Sabennal aˈa inin Anak Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ekka isab meˈ dende laˈi mayam-mayam amban katala-talahan. Bakas siye nuhut si Isa amban Jalil duk luwal iye tabangande. ");
INSERT INTO yka_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dem grupu miyaˈan laˈi si Mariyam dende amban Magdalahin duk Mariyam saˈi si Yakub duk si Yusupin duk anda Sebedehin. ");
INSERT INTO yka_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pagkohap ne niyaˈ tekka pī dambuwaˈ aˈa dayahan, aˈa Arimati, inēnan si Yusup. Tindeg si Isa du isab iye. ");
INSERT INTO yka_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aˈa miyaˈan hap pī pu si Pilatus duk pināku weˈ ne bangkey si Isahin. Ubus daˈak Pilatus ne pangurung. ");
INSERT INTO yka_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ineddoˈ bangkeyin weˈ si Yusup duk sinaput weˈ ne duk kakanaˈ. ");
INSERT INTO yka_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ubus pinabāk weˈ ne dem lingab batu pagkubulan baˈahu du hinangne pamanyapne dine. Ngaligid iye batu hadje panampeng gawang lingabin, ubus bu tahalaˈ ne iye. ");
INSERT INTO yka_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Si Mariyam, dende amban Magdalahin duk Mariyam sangeynen ningkoloˈ laˈi paharap si kubulin. ");
INSERT INTO yka_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pagellew dambuwaˈin, hātinen ellew Sabtuˈ, hap pī pu si Pilatus meˈ nakuraˈ imamin duk meˈ Pariseohin. ");
INSERT INTO yka_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Paˈinde, “Tuwan, taˈesseb kami weˈ bakas paˈin aˈa dustaˈan miyaˈan kaˈellumnen, weˈ bang iye matey, pagtaˈabut tellu ellew, ellum iye balik. ");
INSERT INTO yka_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hangkan daˈakun ginuwaldiyahan kubulnen sampay katellu ellewnen, kaw hap pī meˈ tindegnen nangkew bangkeynen ubus paˈinde weˈ ellum iye balik. Bang magdustaˈ siye sa miyaˈan pasōng teˈed laˈat pangakkalden.” ");
INSERT INTO yka_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paˈin Pilatus si siye, “Boˈohun bi meˈ guwaldiya iyan duk guwaldiyahanun bi kubulin manamal.” ");
INSERT INTO yka_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Manjari hap pī ne siye duk papīhande indan gawang lingabin supaya kataˈuhan bang niyaˈ bakas ngalukane duk daˈakde meˈ sundaluhin magguwaldiya. ");
INSERT INTO yka_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pagpuwas ne ellew Sabtuˈ, ellew liˈihin, subu-subu pe ellew Ahad, hap pī si Mariyam dende amban Magdalahin duk sangeynen mayaman kubulin. ");
INSERT INTO yka_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bessuwang linug manamal peggeˈ dambuwaˈ malaˈikat Tuhanin duwaˈi amban surgaˈ. Iligidan weˈ ne batu hadje panampeng gawang lingabin, ubus bu ningkoloˈ iye diyataˈ batuhin. ");
INSERT INTO yka_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bantuknen sahaya kuweˈ lalat duk semmeknen poteˈ manamal. ");
INSERT INTO yka_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tinalew manamal meˈ guwaldiyahin hangkan migpid teˈed siye duk gaˈi siye makasayu; kuweˈ siye aˈa matey. ");
INSERT INTO yka_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Missā malaˈikatin si meˈ dendehin, paˈinne, “Daˈa kaˈam tinalew. Kataˈuhanku pihabi si Isa bakas ilansang diyataˈ olomin. ");
INSERT INTO yka_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Gaˈ ne iye tuˈu, peggeˈ ellum ne iye balik kuweˈ bakas pinaˈinnen. Pitu kaˈam, payamanun bi bakas pabākannen. ");
INSERT INTO yka_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kuweˈitu, palakkes kaˈam pī, akahanun bi meˈ tindegnen weˈ ellum ne iye balik amban kamateynen. Duk padehellu iye amban kaˈam hap lahat Jalil. Kitebi du iye iyan laˈi. Essebun bi bakas inakaku si kaˈamin.” ");
INSERT INTO yka_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hangkan magdayiˈ-dayiˈ siye tahalaˈ amban kubulin. Tinalew siye saguwaˈ kēgan isab siye manamal. Magubas siye pī ngakahan meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bessuwang siye sinampang weˈ si Isa laˈi si lān duk paˈinne, “Na, kaˈam ne?” Patapit siye pu si Isa duk pasujud si iye bu inantan weˈ de bettisnen. ");
INSERT INTO yka_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Daˈa kaˈam tinalew,” paˈin si Isa, “pī ne kaˈam, akahanun bi meˈ kapungtinaˈihankun weˈ subey siye pī hap Jalil. Laˈi takitede du ku.” ");
INSERT INTO yka_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sasang si lān pe meˈ dendehin, hap pī meˈ guwaldiya sinduwehin si puweblo duk inaka-aka weˈ de si meˈ nakuraˈ imamin kēmon bakas maˈumantagin. ");
INSERT INTO yka_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Manjari magtipun meˈ kabahiˈanin duk meˈ nakuraˈ imamin duk magisun siye. Ubus siye magisun, inurungan weˈ de meˈ sundaluhin sīn ekka ");
INSERT INTO yka_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","duk paˈinde, “Akahanun bi meˈ aˈahin, weˈ sasangbi tuli sangemin, pī meˈ tindeg si Isahin nangkew bangkeynen. ");
INSERT INTO yka_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bang takale gubnulin weˈ tuli kaˈam bu dinaˈak kaˈam magguwaldiya, daˈa kaˈam suse. Kami ne taˈu missā si iye duk kaˈam gaˈi amāhanne.” ");
INSERT INTO yka_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ineddoˈ weˈ meˈ sundaluhin sīnin duk tinuhut weˈ de bakas pangandaˈakan siyehin. Sampay ellew inin iye inin suwi-suwi pinalatag weˈ meˈ Yahudihin. ");
INSERT INTO yka_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Manjari, meˈ tindeg si Isa sampuk-dambuwaˈin pī hap Jalil. Pataked siye pī si dambuwaˈ punu sa bakas pangandaˈakan si Isa siyehin. ");
INSERT INTO yka_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pagkitede iye, pasujud siye pu si Isa, saguwaˈ niyaˈ siye duwe-duwehan dem ateyden. ");
INSERT INTO yka_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Patapit si Isa si siye duk paˈinne, “Bakas kaˈurungan ne ku kapatut magbayaˈ si dunya duk si surgaˈ. ");
INSERT INTO yka_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hangkan hep pī kaˈam magaka-aka si kēmon kabangsa-bangsahan duk isab siye nuhut aku. Pandihun bi siye hinang tandaˈ weˈ nuhut ne siye Tuhanin duk aku, Anak Tuhanin, duk Niyawa Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Toloˈanun bi siye weˈ subey tuhutde kēmon bakas pangandaˈakanku kaˈamin. Duk essebun bi inin, luwal du ku luˈu si kaˈam ngeregseˈ kiyamat dunyahin.” ");
INSERT INTO yka_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Inin aka-aka hāp sabab Isa Almasi, Anak Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tagnaˈan aka-aka hāp inin tasulat weˈ Nabi Isaya dem kitab. Paˈinne, “Paˈin Tuhanin, ‘Daˈakku pī pamasanankun dehellu amban kaˈu duk memesne lānnun.’ ");
INSERT INTO yka_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Niyaˈ aˈa maglingan dem lahat makagindew-gindew. Iye inin pinaˈinnen, ‘Sōng tekka ne Panuhutanin. Palanuˈun bi lān palabeyannen! Pabentelun bi lān tinuhutnen!’” ");
INSERT INTO yka_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Manjari inin, tekka si Yahiya laˈi dem lahat makagindew-gindew. Iye hep mamandi meˈ aˈahin sakaliˈ pagsusunande ne duk lebbahande ne meˈ duseden. Magmahalayak si Yahiya laˈi si meˈ aˈahin weˈ sasuku magsusun ne duk ngalebbahan meˈ hinanganne malaˈatin, subey iye pinandi duk ampun Tuhanin du iye. ");
INSERT INTO yka_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Manjari ekka meˈ aˈa amban meˈ kalahat-lahatan laˈi si Yahudiya duk amban Awrusalam hap pī si iye. Magbennal siye si meˈ duseden duk pinandi siye weˈ Yahiya dem boheˈ Jordan. ");
INSERT INTO yka_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Semmek Yahiyahin bulu untaˈ tinennun duk kanditnen kuwit sapiˈ. Kinakannen dulu duk boheˈ buwani. ");
INSERT INTO yka_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Duk magmahalayak iye kuweˈ inin, “Niyaˈ,” paˈinne, “paturul pitu si aku, balakatan pe amban aku. Gaˈi ku bisan pataˈ pakokkoˈ ngalekkahan ingket tehompaˈnen. ");
INSERT INTO yka_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Pinandi kaˈam weˈ ku duk boheˈ saguwaˈ iye inin seddili pamandine kaˈamin. Papiyune si kaˈam Niyawa Sutsihin.” ");
INSERT INTO yka_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Manjari inin, masa īˈ tekka si Isa amban Nasaret, dambuwaˈ puweblo laˈi si lahat Jalil. Duk pinandi iye weˈ Yahiya laˈi si boheˈ Jordan. ");
INSERT INTO yka_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pagpaguwaˈ si Isa amban dem boheˈ, takitene luka langitin duk duwaˈi Niyawa Sutsihin pī si iye kuweˈ bantuk assang. ");
INSERT INTO yka_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Duk niyaˈ suwala amban surgaˈ magpaˈin, “Anakte kew kalasahanku. Kasulutan ku teˈed si kaˈu.” ");
INSERT INTO yka_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Manjari magtawus si Isa binoˈo weˈ Niyawa Sutsihin hap lahat makagindew-gindew. ");
INSERT INTO yka_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ampatpūˈ bahangi iye laˈi sinassat weˈ nakuraˈ seyitanin. Niyaˈ isab meˈ hayep talun laˈi saguwaˈ hinatul si Isa weˈ meˈ malaˈikat. ");
INSERT INTO yka_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pagubus si Yahiya kinalabusu weˈ sultanin, hap pī si Isa si lahat Jalil. Magmahalayak iye sabab aka-aka mahāp amban Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Taˈabut ne waktu bakas pinaˈalin,” paˈinne, “duk tapit ne waktu pagbayaˈ Tuhanin. Pagsusunanun bi dusebin duk lebbahanun bi ne. Duk kahagadun bi aka-aka mahāpin.” ");
INSERT INTO yka_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Manjari inin, sābu lumengngan si Isa si susulan lamew inēnan Jalil, niyaˈ takitene duwangan magpungtinaˈi, si Simon duk Andariyas, magpokot laˈi dem lamew peggeˈ siye meˈ aˈa magkenna. ");
INSERT INTO yka_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Paˈin si Isa si siye, “Dayiˈ kaˈam nuhut aku. Bahanbin mageddoˈ-eddoˈ kenna. Saguwaˈ bang kaˈam nuhut aku, toloˈante kaˈam mageddoˈ-eddoˈ aˈa pinatuhut si aku.” ");
INSERT INTO yka_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na, magtawus inambanan weˈ de meˈ pokotden duk nuhut ne siye si Isa. ");
INSERT INTO yka_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Manjari paglengnganne tala-tala, niyaˈ isab takitene duwangan magpungtinaˈi, disi Yakub duk Yahiya, meˈ anak Sebedehin. Laˈi siye dem bangkaˈde magmemes pokot. ");
INSERT INTO yka_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Magtawus siye ilinganan weˈ si Isa duk binoˈo weˈ ne. Manjari inambanan weˈ de samaden dem bangkaˈ duk meˈ aˈa tinangdananden, duk nuhut ne siye si Isa. ");
INSERT INTO yka_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hap pī disi Isa si puweblo Kapernaum. Pagtaˈabut ellew Sabtuˈ, ellew liˈi meˈ Yahudihin, hap pī si Isa si langgal magusihat si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ula1iˈ meˈ aˈahin pagkalede usihatnen. Peggeˈ magbiddaˈ teˈed usihat si Isahin duk usihat meˈ guru si saraˈ āgamahin. Peggeˈ taga balakat si Isa bang iye missā. ");
INSERT INTO yka_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Manjari niyaˈ padiyalem pī dem langgal aˈa pasayedan seyitan. ");
INSERT INTO yka_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Magkilahap iye, paˈinne, “Daˈa kami sasewun, Isa, aˈa Nasaret. Gaˈ niyaˈ lamudnu si kami. Pitu ke kew makaˈatan kami? Kataˈuhanku du bang sine kew. Kaˈu dambuwaˈ-buwaˈ masutsi mapitu amban Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Saguwaˈ inamāhan weˈ si Isa seyitanin. Paˈinne, “Daˈa kew mabehe. Paguwaˈ kew amban aˈa iyan.” ");
INSERT INTO yka_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Manjari magpaspadan weˈ seyitanin aˈahin duk pagubus seyitanin magkilahap, paguwaˈ ne iye amban aˈahin. ");
INSERT INTO yka_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bengngangan meˈ aˈahin kēmon, hangkan magtilew-tinilew siye, paˈinde, “Ine enteˈ inin? Toloˈ baˈahu hep inin. Taga kapatut iye ngandaˈak bisan meˈ seyitanin, duk tuhutde pangandaˈakannen.” ");
INSERT INTO yka_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Manjari kabantuhannen magtawus bawag si kēmon kalahat-lahatan laˈi si lahat Jalil. ");
INSERT INTO yka_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Puwas miyaˈan, paluwas si Isa amban langgal duk pī iye padiyalem si lumaˈ disi Simon duk Andariyas. Magtuhut iye duk si Yakub duk Yahiya. ");
INSERT INTO yka_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Matoˈa si Simon dendehin pabāk laˈi ilemmun. Manjari magtawus akahan meˈ aˈa malaˈihin si Isa sababne. ");
INSERT INTO yka_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hap pī si Isa duk inantanan weˈ ne tangan dendehin bu pinakuwat weˈ ne. Manjari kawuliˈan ne iye. Ubus bu pinakan siye weˈ ne. ");
INSERT INTO yka_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pagseddep ne ellewin, binoˈo weˈ meˈ aˈahin pī pu si Isa sasuku masakihin duk meˈ aˈa pasayedan weˈ seyitanin. ");
INSERT INTO yka_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Duk meˈ aˈa si puweblo miyaˈan, magtipun si luwasan lumaˈ miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ekka aˈa taga saki bayuˈ-bayuˈan pinakawuliˈ weˈ si Isa duk ekka isab meˈ seyitan pinaluwas weˈ ne. Gaˈi dinaˈak weˈ ne meˈ seyitanin mabehe peggeˈ asal kataˈuhande bang sine si Isa. ");
INSERT INTO yka_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pagsasumu subu-subu pe teˈed, dongaˈ si Isa duk paluwas iye amban lumaˈ. Tahalaˈ iye amban puweblo hap pī si lugal gaˈ niyaˈ aˈane duk missā iye laˈi si Tuhan. ");
INSERT INTO yka_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Manjari, peggeˈ gaˈ iye laˈi si lumaˈ, piniha iye weˈ disi Simon. ");
INSERT INTO yka_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pagtakasuwaˈde ne iye, paˈinde si iye, “Īˈ laˈi meˈ aˈahin kēmon miha kaˈu.” ");
INSERT INTO yka_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Paˈin si Isa si siye, “Sūng kite bi pī si meˈ kalumaˈan seddili matapitin duk ku makapagusihat isab laˈi. Peggeˈ iye hep inin akaku mapitu si dunyahin.” ");
INSERT INTO yka_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Manjari hap pī ne si Isa si kēmon kalahatan si Jalil. Magmahalayak iye dem meˈ kalanggal-langgalande duk magpaluwas iye meˈ seyitan amban meˈ aˈa. ");
INSERT INTO yka_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Manjari niyaˈ pī pu si Isa dambuwaˈ aˈa inipul. Nengge aˈa inin duk tuˈutne magpadiyawaˈ pu si Isa duk pabuyuˈ teˈed, paˈinne, “Bang kew mabayaˈ tapakawuliˈnu ku.” ");
INSERT INTO yka_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Maˈaseˈ teˈed si Isa si iye. Pinasōng weˈ ne tangannen duk inantan weˈ ne aˈa inipulin duk paˈinne, “Asal mabayaˈ ku. Kawuliˈan ne kew.” ");
INSERT INTO yka_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Magtawus ipulnen tahalaˈ duk kawuliˈan ne iye. ");
INSERT INTO yka_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Magtawus iye pinatahalaˈ weˈ si Isa duk sinessaˈan teˈed iye weˈ ne. ");
INSERT INTO yka_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Paˈin si Isa si iye, “Daˈa kew paˈin magaka-aka bisan pu sine sabab pamakawuliˈku kaˈuhin. Saguwaˈ pī kew pakitehanun barannun si imamin duk magkuluban kew sa pangandaˈakan si Musahin, hinang tandaˈ si meˈ aˈahin weˈ asal kawuliˈan ne kew.” ");
INSERT INTO yka_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Saguwaˈ lumengngan aˈa bakas inipulin duk magaka-aka teˈed iye sabab kakawuliˈnen duk binawag weˈ ne inin. Hangkan gaˈi ne si Isa tapī dem meˈ puweblo paguwaˈ si aˈa, saguwaˈ laˈi ne hadja iye si meˈ lugal gaˈi paglahatan aˈa. Saguwaˈ meˈ aˈahin hap pī du si iye amban meˈ kalahat-lahatan. ");
INSERT INTO yka_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Palabey bang piye ellew, balik si Isa pī si puweblo Kapernaum. Taˈaka weˈ laˈi iye si dambuwaˈ lumaˈ. ");
INSERT INTO yka_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ekka meˈ aˈa patipun pī si lumaˈ palaˈihan si Isa miyaˈan. Hangkan gaˈ ne niyaˈ kasiguwehande, bisan pe si behe gawang. Minahalayak weˈ si Isa lapal Tuhanin si siye. ");
INSERT INTO yka_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Manjari niyaˈ binoˈo pī si iye aˈa saki pinagtanggungan weˈ ampat aˈa. Aˈa masaki miyaˈan matey barannen. ");
INSERT INTO yka_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Peggeˈ gaˈi siye tumapit pu si Isa hawal ekka aˈahin, manjari ilarakan weˈ de sapew madatag si atag kōk si Isahin. Pagubus ne siye ngahinang pamalānan, pinatuntun weˈ de aˈa masakihin diyataˈ tanggungannen. ");
INSERT INTO yka_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pagtakite si Isa weˈ sandel teˈed siye si iye, paˈinne si aˈa mamatey barannen, “Bagay, taˈampun ne meˈ dusenun.” ");
INSERT INTO yka_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Saguwaˈ niyaˈ magtingkoloˈ laˈi meˈ guru si saraˈ āgama. Ngutuˈ-ngutuˈ siye dem ateyde peggeˈ missā si Isa sa īˈ. ");
INSERT INTO yka_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Uy!” paˈinde. “Missā iye kuweˈ Tuhanin iye. Sine makaˈampun dusehin bang dumaˈin dambuwaˈ-buwaˈ Tuhan.” ");
INSERT INTO yka_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Magtawus kataˈuhan si Isa bang ine pinikilden duk paˈinne si siye, “Weˈey kaˈam magtilew-tilew sa iyan dem ateybi? ");
INSERT INTO yka_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ine mamurahin, binissā si aˈa mamatey baranne inin, ‘Inampun ne dusenun,’ atawa ‘Dongaˈ kew, boˈohun pabākannun bu nu ne lumengngan.’ ");
INSERT INTO yka_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pakoleˈku aˈa inin supaya kataˈuhanbi weˈ aku, Anak Manusiyaˈin, taga kapatut tuˈu si dunya ngampun meˈ duse.” ");
INSERT INTO yka_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Manjari paˈin si Isa si aˈa mamatey barannen, “Dongaˈ kew, boˈohun pabākannun bu nu ne hap lumaˈ.” ");
INSERT INTO yka_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Manjari dongaˈ aˈa masakihin duk magtawus eddoˈne pabākannen duk pabukut iye si pagmatahande kēmon. Bengngangan meˈ aˈahin kēmon. Pinudji weˈ de Tuhanin, paˈinde, “Gaˈ teˈed kite bi bakas ngite sa inin.” ");
INSERT INTO yka_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Manjari pī ne isab si Isa si susulan lamew Jalil. Patipun pī si iye meˈ aˈa maˈekkahin duk magusihat iye si siye. ");
INSERT INTO yka_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na paglanjalne, takitene si Libi, anak Alpahin, ningkoloˈ laˈi si upisinane pagbayed-bayedan sukeyin. Paˈin si Isa si iye, “Dayiˈ kew, nuhut kew aku.” Manjari kuwat si Libi duk nuhut ne iye si Isa. ");
INSERT INTO yka_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Manjari mangan si Isa laˈi si lumaˈ si Libi. Ekka isab meˈ aˈa magpāku-pāku sukey duk meˈ aˈa dusehan ningkoloˈ mangan pasumbayaˈ si iye duk meˈ tindegnen. Peggeˈ ekka siye manuhut iyehin. ");
INSERT INTO yka_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Niyaˈ laˈi meˈ Pariseo, meˈ guru si saraˈ āgama. Pagkitede weˈ mangan si Isa magsumbayaˈ duk meˈ aˈa dusehan duk meˈ aˈa magpāku-pāku sukey, paˈinde si meˈ tindeg si Isahin, “Weˈey si Isa palamud magkakanan duk meˈ aˈa magpāku-pāku sukeyin duk meˈ aˈa dusehan sinduwehin?” ");
INSERT INTO yka_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pagkale si Isa inin, paˈinne si siye, “Meˈ aˈa saki hep hap doktolin; bang meˈ makoleˈin gaˈ niyaˈ gunane hap doktol. Dumaˈin ku pitu miha meˈ aˈa mabentelin saguwaˈ pitu ku miha meˈ aˈa dusehanin.” ");
INSERT INTO yka_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Manjari baytu magpuwase meˈ tindeg Yahiyahin duk meˈ Pariseohin, niyaˈ meˈ aˈa pī pu si Isa nilew iye, paˈinde, “Weˈey magpuwase meˈ tindeg Yahiyahin duk meˈ tindeg meˈ Pariseohin bu meˈ tindegnun gaˈi magpuwase?” ");
INSERT INTO yka_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sambungan si Isa siye si dalilan. Pasaliˈne meˈ tindegnen si meˈ aˈa si pagkawinan. Paˈinne, “Makapagpuwase ke meˈ aˈa si pagkawinanin samantaˈan laˈi pe si siye pangantin lellahin? Gaˈi. Samantaˈan laˈi pe si siye pangantin lellahin, gaˈi siye makapagpuwase. ");
INSERT INTO yka_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Saguwaˈ si sinōng inin, bang pinatahalaˈ ne pangantin lellahin, meke ne siye muwase.” ");
INSERT INTO yka_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Manjari magdalilan si Isa sabab panoloˈ matuˈuhin duk panoloˈnen. Paˈinne, “Gaˈ niyaˈ aˈa matopak tela baˈahu, gaˈ pe kadekdakan, pī si semmek andang. Peggeˈ bang sa īˈne, pagngekkeˈ tela baˈahuhin, garet balik semmek maˈandangin duk namba ngaluha garetnen.” ");
INSERT INTO yka_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Pinasaliˈ isab weˈ si Isa toloˈnen si boheˈ ubas baˈahu inisi dem puyuˈ kuwit kambing. Paˈinne, “Gaˈ niyaˈ aˈa ngisi boheˈ ubas baˈahu, mukal-mukal pe, dem puyuˈ andang. Peggeˈ bang sa īˈne, buslad puyuˈin weˈ boheˈ ubasin. Manjari buˈus boheˈ ubasin duk magkaˈat puyuˈin. Saguwaˈ subey inisi boheˈ ubas baˈahuhin dem puyuˈ baˈahu.” ");
INSERT INTO yka_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Manjari dambuwaˈ Sabtuˈ, ellew liˈi meˈ Yahudihin, pabutas si Isa duk meˈ tindegnen dem tanaˈ. Paglabey meˈ tindegnen, ngalupuˈ siye meˈ buwaˈ tanaˈin. ");
INSERT INTO yka_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Manjari paˈin meˈ Pariseohin pu si Isa, “Payamanun be. Weˈey teˈ meˈ tindegnun hinangde tinaggahan saraˈ si ellew liˈihin?” ");
INSERT INTO yka_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nambung si Isa, paˈinne, “Gaˈ ke bakas tabatsabi bang ine hininang Sultan Daˈudin masa Imam Abiyatar imam nakuraˈin? Kaˈinusanan hep si Daˈud duk meˈ saweˈnen duk gaˈ niyaˈ kinakande. ");
INSERT INTO yka_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Padiyalem hep iye pī si lumaˈ Tuhanin duk kinakan weˈ ne pan binettad laˈi pangurung si Tuhanin. Bu tinaggahan hep weˈ saraˈ kinakan pan miyaˈan, luwal hadja para si meˈ imam. Duk inurungan isab weˈ si Daˈud meˈ saweˈnen. Saguwaˈ gaˈ du iye makaduse si hininangne miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Duk paˈin si Isa si siye, “Hininang weˈ Tuhanin ellew liˈihin panabang si manusiyaˈ. Dumaˈin hangkan pinapanjari manusiyaˈin supaya hadja tapagaddatanne ellew liˈihin. ");
INSERT INTO yka_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hangkan aku, Anak Manusiyaˈin, taga kapatut ku magpaˈin bang ine-ine mapatut hininang si ellew liˈihin.” ");
INSERT INTO yka_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Manjari, balik si Isa pī dem langgal. Niyaˈ laˈi aˈa sapik tangannen. ");
INSERT INTO yka_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Manjari pinateng-patengan si Isa weˈ meˈ Pariseo malaˈihin bang pakoleˈne ke aˈa masapik tanganne miyaˈan si ellew liˈi, supaya iye katuntutande. ");
INSERT INTO yka_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Paˈin si Isa si aˈa masapik tangannen, “Pitu kew nengge tuˈu.” ");
INSERT INTO yka_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Manjari tinilew weˈ si Isa meˈ aˈahin, paˈinne, “Bang dem saraˈ, ine mapatut hininang si ellew liˈihin? Hinangan makahāp atawa hinangan makalaˈat? Nimbul aˈa atawa mapatey?” Saguwaˈ gaˈ niyaˈ nambung. ");
INSERT INTO yka_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pinayaman siye weˈ si Isa paliput. Dukka teˈed ateynen duk astel iye peggeˈ gaˈ niyaˈ aseˈde si aˈa. Manjari paˈinne si aˈa masapik tangannen, “Pahintengun tangannun.” Na, pinahinteng weˈ ne, manjari kawuliˈan ne tangannen. ");
INSERT INTO yka_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Magtawus paluwas meˈ Pariseohin amban langgal duk pī siye magisun duk meˈ tindeg Sultan Herodin bang saˈingge si Isa tapapateyde. ");
INSERT INTO yka_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Manjari tahalaˈ si Isa duk meˈ tindegnen hap pī si higad lamew Jalil. Banes teˈed aˈa paturul si iye, dumaˈin hadja amban lahat Jalil saguwaˈ amban lahat Yahudiya isab ");
INSERT INTO yka_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","duk amban Awrusalam duk amban lahat Idumeya duk amban dambiyaˈan boheˈ Jordan duk amban meˈ kalahatan si bihing puweblo Tiros duk Sidon. Meˈ aˈa mabanes teˈed miyaˈan pī pu si Isa peggeˈ bakas takalede sabab meˈ tahinangnen. ");
INSERT INTO yka_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Dinaˈak weˈ si Isa meˈ tindegnen malebbes bangkaˈ pasakeyanne supaya iye gaˈi talaray weˈ meˈ aˈa mabanesin. ");
INSERT INTO yka_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Peggeˈ ekka aˈa kawuliˈan weˈ ne, hangkan meˈ maniyaˈ sakinen maglaray pī si iye supaya taˈantande iye. ");
INSERT INTO yka_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Duk hangkan-hangkan iye takite weˈ meˈ aˈa pasayedan seyitanin, pahebbaˈ siye si harapanne duk magkilahap siye, paˈinde, “Kaˈu iyan Anak Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Saguwaˈ sinessaˈan teˈed weˈ si Isa meˈ seyitanin gaˈi dinaˈak magaka si meˈ aˈa bang sine iye. ");
INSERT INTO yka_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Manjari pataked si Isa pī si meˈ kakūdan duk ilinganan weˈ ne pī si iye meˈ kinabayaˈanne manuhut iyehin. Duk pataked siye pī si iye. ");
INSERT INTO yka_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Meneˈ iye sampūˈ duk duwe amban meˈ katindegannen duk ēnanne siye meˈ aˈa kawakilanin. Paˈinne si siye, “Kaˈam meˈ tapeneˈkun naweˈan aku duk daˈakte kaˈam iyan lumengngan magmahalayak lapal Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Taga balakat du kaˈam iyan pagpaluwas meˈ seyitan.” ");
INSERT INTO yka_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iye inin sampūˈ duk duwe pineneˈnen: si Simon, inēnan isab si Petros, ");
INSERT INTO yka_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Yakub duk Yahiya, meˈ anak Sebede, inēnan isab siye weˈ ne Boanerges. Hātine miyaˈan, meˈ aˈa kuweˈ lugung. ");
INSERT INTO yka_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pineneˈ isab weˈ ne si Andariyas, si Pilip, si Bartolome, si Mateo, si Tomas, si Yakub anak Alpahin, si Taddeo, si Simon aˈa pangangatuhin ");
INSERT INTO yka_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","duk si Judas Iskariyot. Si Judas inin iye mamuddihan si Isahin. ");
INSERT INTO yka_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Manjari hap lumaˈ ne si Isa duk meˈ tindegnen. Saguwaˈ magtipun balik pī meˈ aˈa mabanesin, hangkan gaˈi ne disi Isa sumaluˈ bisan mangan. ");
INSERT INTO yka_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pagtakale weˈ meˈ usba si Isahin sabab inin, pī siye ngeddoˈ iye. Peggeˈ paˈin meˈ aˈahin weˈ magkaˈat ne pikilan si Isahin. ");
INSERT INTO yka_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Niyaˈ meˈ guru si saraˈ āgama, meˈ mapadurul amban Awrusalamin missā, paˈinde, “Si Isa iyan pasayedan weˈ Belsebul, nakuraˈ meˈ seyitanin, hangkan iye kapagpaluwas meˈ seyitan.” ");
INSERT INTO yka_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Manjari ilinganan meˈ aˈa miyaˈan weˈ si Isa duk magdalilan iye si siye. Paˈinne, “Na, saˈingge seyitanin maluwas seyitan? Kuweˈ du iye maluwas dine. Gaˈi makajari. ");
INSERT INTO yka_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bang saˈupama niyaˈ pagsultanan bu magbonoˈ meˈ aˈanen, gaˈi layun pagsultanan miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Damikkiyan,” paˈin si Isa, “bang magtewtey-anakin gaˈi magtuhut pikilan saguwaˈ luwal magsasaˈ, ujudnen magkanat-kanat siye. ");
INSERT INTO yka_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hangkan bang nakuraˈ seyitanin magkuntara duk meˈ tindegne seyitanin gaˈi layun pagbayaˈnen saguwaˈ magtamanan du. ");
INSERT INTO yka_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Seyitanin dalilnen aˈa basag. Gaˈ niyaˈ tapī ngahawas si lumaˈ aˈa basag bang gaˈi dahuˈ ingketanne aˈa mabasag miyaˈan, ubus meke ne iye tapangahawas.” ");
INSERT INTO yka_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Sabennal akahante kaˈam,” paˈin si Isa, “ampun Tuhanin du kēmon duse aˈahin duk sasuku bissāne laˈat si Tuhan. ");
INSERT INTO yka_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Saguwaˈ bang Niyawa Sutsihin binissā-bissāhannen, asal gaˈi teˈed iye inampun peggeˈ dusene miyaˈan teteg ne laˈi si iye salama-lama.” ");
INSERT INTO yka_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Hangkan si Isa missā si siye sa miyaˈan, peggeˈ paˈinde weˈ pasayedan seyitan iye. ");
INSERT INTO yka_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na, manjari tekka laˈi saˈi si Isahin duk meˈ pungtinaˈine lellahin. Nengge siye laˈi si luwasan lumaˈ duk daˈakde iye ilinganan. ");
INSERT INTO yka_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na, banes aˈa magtingkoloˈ paliput pu si Isa. Manjari niyaˈ ngakahan iye, paˈinne, “Tuwan, īˈ laˈi saˈinun duk meˈ pungtinaˈinun si bukut miha kaˈu.” ");
INSERT INTO yka_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nambung si Isa, paˈinne, “Sine saˈikun duk sine meˈ pungtinaˈikun?” ");
INSERT INTO yka_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Manjari pinayaman weˈ ne meˈ magtingkoloˈ mapaliput si iyehin duk paˈinne, “Siye inin saˈiku duk meˈ pungtinaˈiku. ");
INSERT INTO yka_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Peggeˈ sasuku maghinang kinabayaˈan Tuhanin, iye iyan pungtinaˈiku lella, pungtinaˈiku dende duk saˈiku.” ");
INSERT INTO yka_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Balik ne isab si Isa magtoloˈ laˈi si higad lamew Jalil. Banes teˈed aˈa patipun si iye laˈi, hangkan pasakey iye duk ningkoloˈ iye dem bangkaˈ diyataˈ lamew. Meˈ aˈa mabanesin laˈi si higad lamew si katakasan. ");
INSERT INTO yka_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Magusihat iye si meˈ aˈahin duk ekka usihatne si dalilan. Pagusihatnen paˈinne si siye, ");
INSERT INTO yka_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pakalehun bi inin. Niyaˈ dambuwaˈ aˈa pī si tanaˈne magsabulak binihiˈ. ");
INSERT INTO yka_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pagsabulakne, niyaˈ binihiˈ tapisik si lān. Manjari pī meˈ manuk-manukin manganne. ");
INSERT INTO yka_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Meˈ binihiˈ sinduwehin laboˈ diyataˈ batu pānas, gaˈi lalem bulaknen. Mura tomoˈ binihiˈin peggeˈ gaˈi lalem bulaknen. ");
INSERT INTO yka_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pagsilak ellewin, magtawus ngingking duk peggeˈ gaˈi lalem gamutnen, manjari lanes. ");
INSERT INTO yka_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Laboˈ binihiˈ sinduwehin dem kasampinitan. Samet nulig sampinitin duk katalungan tinanemin, manjari gaˈ buwaˈ. ");
INSERT INTO yka_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Na, binihiˈ sinduwehin laboˈ si kahāpan bulak. Manjari meˈ binihiˈ inin tomoˈ duk nulig duk moˈo buwaˈne. Jarinen niyaˈ ne sarang-sarang, niyaˈ ne ekka, duk niyaˈ isab ekka manamal. ");
INSERT INTO yka_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na,” paˈin si Isa, “amey-amey pakalehun bi bang niyaˈ pinaˈin si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Manjari pagubus ne tahalaˈ meˈ aˈa maˈekkahin duk luwal saˈ sampūˈ duk duwe tindegnen duk meˈ tindegne sinduwehin malaˈi si iyehin, tinilew iye weˈ de bang ine hāti dalilan panoloˈne miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nambung si Isa, paˈinne, “Kaˈurungan ne kaˈam kataˈu supaya tahātibi meˈ tinapukan Tuhan dem pikilannen sabab bang saˈingge pagbayaˈne si meˈ aˈanen. Saguwaˈ si meˈ aˈa seddilihin, usihatanku siye si meˈ dalilan, ");
INSERT INTO yka_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","supaya siye kuweˈ tasulat dem kitabin, pinaˈin, ‘Asal mayam siye saguwaˈ gaˈi siye makakite. Asal pakale siye saguwaˈ gaˈi siye makahāti. Peggeˈ bang siye makakite duk makahāti kaw siye balik si Tuhan, duk ampun Tuhanin siye.’” ");
INSERT INTO yka_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Na,” paˈin si Isa si siye, “asal gaˈi hatiˈ tasabutbi dalilanku miyaˈan. Bang sa iyan, gaˈi du isab tasabutbi kēmon dalilan pagusihatku si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aˈa magsabulak binihiˈin,” paˈin si Isa, “bang hināti, iye aˈa magusihat lapal Tuhan si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Duk meˈ aˈa sinduwehin dalil lān bakas kapisikan lapal Tuhanin. Pagkalede lapalin, magtawus pī nakuraˈ seyitanin ngagew lapalin amban dem pikilande. ");
INSERT INTO yka_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Meˈ aˈa sinduwehin dalil bulak diyataˈ batu pānasin isab. Sinabulakan lapalin si siye. Pagkalede lapal Tuhanin, magtawus kahagadde duk kēgan siye. ");
INSERT INTO yka_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Saguwaˈ gaˈ nganggamut palalem lapal Tuhanin dem ateyde. Hangkan gaˈ siye makatatas tiggel. Pagtekka kasusehanin atawa bang bininasa siye sabab panuhutde lapalin, gaˈi ne siye kahagad. ");
INSERT INTO yka_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Duk meˈ aˈa sinduwehin isab dalil kasampinitanin. Siye meˈ aˈa makakale lapal Tuhanin ");
INSERT INTO yka_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","saguwaˈ luwal siye mikil sabab kasusehande si dunyahin. Iye mamahalgaˈ si siyehin, meˈ pangalataˈden. Duk ekka bayuˈ-bayuˈan pagnapsuhande. Hangkan bang dalil tinanemin, katalungan lapal Tuhan bakas takaleden duk gaˈ magbuwaˈ. ");
INSERT INTO yka_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Saguwaˈ meˈ aˈa sinduwehin, dalil bulak mahāpin. Takalede lapal Tuhanin duk kinahagad weˈ de. Bang dalil tinanemin, lapal Tuhan bakas takaleden magbuwaˈ diyalem ateyde. Sinduwehin sarang-sarang buwaˈnen, sinduwehin ekka duk sinduwehin ekka manamal.” ");
INSERT INTO yka_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Manjari paˈin si Isa si siye, “Bang kaˈam magpayitaˈan, lekkebanbi ke payitaˈanin duk palanggana atawa bettadbi ke diyawaˈ kantil? Gaˈi. Saguwaˈ bettadbi si tengenanne. ");
INSERT INTO yka_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hāti dalilan inin, kēmon tinapukanin ujud pinaguwaˈ du. Kēmon manggaˈi tahāti kuweˈituhin, ujud pinahāti du. ");
INSERT INTO yka_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Amey-amey pakalehun bi bang niyaˈ pinaˈin si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Paˈin si Isa isab, “Asipun bi teˈed pahāp-hāp ine-ine takalebin. Peggeˈ bang hāp pangasipbin, hāp isab taˈeddoˈbin duk pasōng pe taˈeddoˈbin. ");
INSERT INTO yka_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hātine inin, aˈahin bang pakale pahāp-hāp, pasōng pangahātinen. Saguwaˈ bang aˈahin gaˈi pakale pahāp-hāp, bisan niyaˈ kataˈuhanne kuweˈahat, ujud tahalaˈ du amban iye.” ");
INSERT INTO yka_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Paˈin si Isa pe, “Kuweˈ inin pagbayaˈ Tuhan si meˈ aˈanen. Dalil binihiˈ sabulakan aˈa diyataˈ bulakne. ");
INSERT INTO yka_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pagubus ne sabulakanne, maghinang ne iye meˈ hinangne sinduwehin. Tuli iye bang sangem duk dongaˈ iye bang ellew. Manjari binihiˈin tomoˈ duk nulig dihananne. Gaˈi tasabut aˈahin bang saˈingge panulignen. ");
INSERT INTO yka_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Peggeˈ tomoˈ binihiˈin dihananne duk buwaˈ. Tagnaˈ magtuglus, ubus bu betteng, ubus bu bukbus ne. ");
INSERT INTO yka_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pagtahak ne buwaˈnen, magtawus daˈak dapuˈ tanaˈin pinagani peggeˈ taˈabut ne paganihin.” ");
INSERT INTO yka_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Manjari paˈin si Isa, “Ine pamasaliˈante bi pagbayaˈ Tuhan si meˈ aˈanen? Duk bang dalilte bi, ine pangandalilante bi iyehin? ");
INSERT INTO yka_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pagbayaˈ Tuhan si meˈ aˈanen,” paˈin si Isa, “kuweˈ dalil da bayuˈ bigi dikiˈ-dikiˈ. Bang tinanem nahut manamal bigi inin. ");
INSERT INTO yka_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Saguwaˈ bang tatanem ne, nulig duk ngahadje amban kēmon jambangan. Ngahadje meˈ pangenen, hangkan makajari meˈ manuk-manukin ngahinang sabakande laˈi duk pasayindung laˈi.” ");
INSERT INTO yka_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ekka meˈ dalilan sa miyaˈan guna si Isa pangusihatne lapalin si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Gaˈ iye missā si meˈ aˈahin bang dumaˈin si dalilan, saguwaˈ bang didine hadja duk meˈ tindegnen, pinahāti weˈ ne kēmon meˈ bissānen si siye. ");
INSERT INTO yka_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Manjari ellew miyaˈan pagmagalib ne, paˈin si Isa si meˈ tindegnen, “Sūng kite bi pī palipag si dambiyaˈ lamew.” ");
INSERT INTO yka_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Inambanan weˈ de meˈ aˈa mabanesin. Pasakey meˈ tindeg si Isahin dem bangkaˈ andang paningkoloˈannen duk binoˈo ne weˈ de patulak si Isa. Niyaˈ isab meˈ bangkaˈ sinduwe patuhut si siye. ");
INSERT INTO yka_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bessuwang nihup baliyu mabasagin duk patampoˈ goyakin magdem bangkaˈ, hangkan sōng pennoˈ ne weˈ boheˈ bangkaˈin. ");
INSERT INTO yka_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Si Isa laˈi si buliˈ bangkaˈ tuli. Maguˈan iye. Binangun iye weˈ meˈ tindegnen. Paˈinde, “Tuwan, gaˈi ke kew gagal bisan kite bi matey?” ");
INSERT INTO yka_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Manjari dongaˈ si Isa duk pinadeheng weˈ ne baliyuhin. Duk missā iye si lamewin, paˈinne, “Sarang ne. Pateddoˈ kew.” Magtawus padeheng baliyuhin duk teddoˈ ne teˈed lamewin. ");
INSERT INTO yka_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","“Weˈey kaˈam tinalew?” paˈin si Isa si meˈ tindegnen. “Gaˈi pe kaˈam sandel si aku?” ");
INSERT INTO yka_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tinalew teˈed siye. Hangkan magtilew-tinilew siye, paˈinde, “Aˈahey inin? Bisan baliyuhin duk goyakin nuhut pangandaˈakannen!” ");
INSERT INTO yka_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Manjari tekka si Isa duk meˈ tindegnen si dambiyaˈ lamew Jalil, laˈi si lahat meˈ aˈa Gerasa. ");
INSERT INTO yka_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagduwaˈi si Isa amban dem bangkaˈ, niyaˈ pasampang si iye dambuwaˈ aˈa amban meˈ kakubulan. Aˈa inin pasayedan seyitan. ");
INSERT INTO yka_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Paglahatannen si meˈ lingab pagkubulan duk gaˈi teˈed iye kaˈingketan weˈ aˈa bisan pe karena pangingket iyehin. ");
INSERT INTO yka_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Daran iningketan tangannen duk bettisnen, saguwaˈ ubus hadja bekkat-bekkatne karenahin. Gaˈ niyaˈ aˈa basag makagapus iye. ");
INSERT INTO yka_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ellew-sangem luwal iye magkolehak si meˈ kakubulan duk si kakūdan duk ngehet dine duk batu. ");
INSERT INTO yka_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pagkitene si Isa amban katalahan, magubas iye pī pasujud si iye. ");
INSERT INTO yka_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Manjari paˈin si Isa si seyitanin, “Pa1uwas kew amban aˈa iyan, seyitan.” Maggasud seyitanin papales, paˈinne, “Gaˈ niyaˈ lamudnu si aku, Isa. Kaˈu Anak Tuhanin, iye Tuhan Malangkewin. Iyuˈ pakale Tuhanin, junjungku si kaˈu, daˈa ku binasahun.” ");
INSERT INTO yka_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Manjari tinilew iye weˈ si Isa, paˈinne, “Sine ēnnun?” Nambung iye, paˈinne, “Ēnkun si Ibuhan peggeˈ ekka kami inin.” ");
INSERT INTO yka_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Duk pabuyuˈ-buyuˈ teˈed meˈ seyitanin pu si Isa, gaˈi siye makapatahalaˈ amban lahat miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Manjari niyaˈ magsungkal laˈi diyataˈ bīd panenan bawi, ekka manamal. ");
INSERT INTO yka_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pabuyuˈ-buyuˈ meˈ seyitanin pu si Isa, paˈinde, “Daˈakun kami pī si meˈ bawi miyaˈan duk padiyalemun kami magdem barande.” ");
INSERT INTO yka_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na, dinaˈak ne siye weˈ si Isa. Manjari paluwas meˈ seyitanin amban aˈahin duk padiyalem ne siye pī magdem baran meˈ bawihin. Magtawus panenan bawihin magubas padurul pī si pampang magdem lamew duk lambo siye kēmon. Meˈ bawihin niyaˈ kulang-labi duwe ngibu ekkahanden. ");
INSERT INTO yka_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Manjari meˈ aˈa magipat meˈ bawi miyaˈan, magubas duk magaka-aka siye laˈi si puweblo duk si meˈ lahat diyataˈ. Manjari hap pī meˈ aˈahin mayaman bakas maˈumantag miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagtekkade laˈi pu si Isa, takitede aˈa bakas pasayedan seyitan maˈekkahin. Ningkoloˈ iye laˈi magsemmek ne duk hāp ne pikilannen. Manjari tinalew siye. ");
INSERT INTO yka_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ubus inaka-akahan ne siye weˈ meˈ aˈa bakas mangitehin sabab maˈumantag si aˈa pasayedan seyitanin, duk sabab meˈ bawihin. ");
INSERT INTO yka_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ubus pabuyuˈ-buyuˈ meˈ aˈa lahat miyaˈan pu si Isa, dinaˈak iye tahalaˈ amban lahatde. ");
INSERT INTO yka_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pagsakey si Isa magdem bangkaˈ, aˈa bakas pasayedan seyitanin pabuyuˈ-buyuˈ nuhut iye. ");
INSERT INTO yka_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Saguwaˈ gaˈ iye dinaˈak weˈ si Isa. Paˈin si Isa si iye, “Moleˈ ne kew pī si lahatnu. Akahanun meˈ kaˈusbahannun sabab hinangan hadje bakas tahinang Tuhan si kaˈuhin duk sabab aseˈne si kaˈuhin.” ");
INSERT INTO yka_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Manjari lumengngan ne aˈahin duk ilatag weˈ ne lahat inēnan Sampūˈ Puweblohin duk magaka-aka iye sabab hinangan hadje bakas tahinang si Isa si iyehin. Kēmon meˈ aˈa makakale inin, bengngangan teˈed. ");
INSERT INTO yka_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Manjari palipag ne isab si Isa magbangkaˈ pī si dambiyaˈ lamew Jalil. Banes ne isab teˈed aˈa patipun pī si iye paglaˈi iye si higad lamew. ");
INSERT INTO yka_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Niyaˈ aˈa pī si iye inēnan si Jairus. Aˈa inin dambuwaˈ nakuraˈ si langgal meˈ Yahudihin. Pagkitene si Isa, pī iye pasujud si antag bettisne. ");
INSERT INTO yka_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Duk pabuyuˈ-buyuˈ teˈed iye pu si Isa, paˈinne, “Tuwan, anakku dende-dendehin sōng ne matey. Dayiˈ ne kew duk bettadun meˈ tangannun si iye supaya du iye koleˈ duk ellum du iye.” ");
INSERT INTO yka_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Manjari nuhut ne si Isa iye. Meˈ aˈa mabanes teˈedin patuhut pu si Isa duk maglaray siye pī si iye. ");
INSERT INTO yka_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Manjari niyaˈ isab laˈi dende saki, luwal paguwaˈan lahaˈ. Sampūˈ duk duwen tahun ne kemuwe kasakinen. ");
INSERT INTO yka_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Duk magsandal teˈed iye si antanan meˈ doktol maˈekkahin duk ubus ne tagastune kēmon sīnnen. Saguwaˈ gaˈ du iye ngahāp. Nambahi hadja pasōng sakinen. ");
INSERT INTO yka_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Manjari takalene aka-aka sabab si Isahin. Hangkan pī iye patapit si bukutan si Isa palagumey si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Paˈinne dem pikilanne, “Bang hadja taˈantanku badjuˈnen, asal kawuliˈan ku.” ");
INSERT INTO yka_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pagantanne, magtawus padeheng paglahaˈnen duk takalessane si baranne weˈ kawuliˈan ne sakinen. ");
INSERT INTO yka_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Magtawus isab takalessa si Isa weˈ niyaˈ balakat paluwas amban baranne. Manjari padeheng iye duk hinarap weˈ ne meˈ aˈa si dambulihanin duk paˈinne, “Sine bakas mangantan badjuˈkun?” ");
INSERT INTO yka_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Paˈin meˈ tindegnen si iye, “Kitenu ne, Tuwan, meˈ aˈa mabanes mapalaray si kaˈu inin, magtilew pe kew bang sine bakas mangantan kaˈuhin?” ");
INSERT INTO yka_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Saguwaˈ mayam iye paliput, mayaman bang sine bakas mangantan iyehin. ");
INSERT INTO yka_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Manjari dendehin, peggeˈ kataˈuhanne weˈ kawuliˈan ne sakinen, pī iye patapit pu si Isa migpid peggeˈ tinalew iye. Pasujud iye si antag bettis si Isa duk magaka ne iye magsabennal. ");
INSERT INTO yka_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Paˈin si Isa si iye, “Dende, kawuliˈan ne kew peggeˈ sandel kew si aku. Pī ne kew, daˈa kew suse. Kawuliˈan ne teˈed sakinun.” ");
INSERT INTO yka_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Manjari, sasang si Isa pe mamissā si dendehin, niyaˈ ne meˈ aˈa tekka pī amban lumaˈ si Jairus. Paˈinde pu si Jairus, “Anaknu dendehin gaˈ ne. Daˈa ne sasewun guruhin.” ");
INSERT INTO yka_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Saguwaˈ gaˈ inasip weˈ si Isa inakade miyaˈan. Paˈinne pu si Jairus, “Daˈa kew tinalew. Sandel kew hadja.” ");
INSERT INTO yka_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Gaˈ niyaˈ patuhut si Isa si iye seddili, luwal si Petros duk duwe magpungtinaˈihin, si Yakub duk Yahiya. ");
INSERT INTO yka_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pagtekkade laˈi si lumaˈ si Jairus, takitene meˈ aˈa malaˈihin hewuhalaˈ. Magtāring siye duk magmatey papales. ");
INSERT INTO yka_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Padiyalem si Isa duk paˈinne si siye, “Weˈey kaˈam iyan hewuhalaˈ duk magmatey? Dumaˈin hep matey nakanakin saguwaˈ tuli hadja.” ");
INSERT INTO yka_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pinagsayehan iye weˈ de. Saguwaˈ pinaluwas siye kēmon weˈ si Isa. Ubus bu binoˈo weˈ ne saˈi-sama nakanakin duk tindegne tellunganin padiyalem pī si bilik palaˈihan nakanakin. ");
INSERT INTO yka_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Inantanan weˈ ne tangan nakanakin duk paˈinne si iye, “Talita kumi.” Bang si bissāte bi hātinen, “Endeng, paˈinku si kaˈu, dongaˈ kew.” ");
INSERT INTO yka_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Magtawus nakanakin dongaˈ duk lumengngan ne dem lumaˈ. Umulnen sampūˈ duk duwen tahun. Bengngangan teˈed siye. ");
INSERT INTO yka_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Manjari sinessaˈan teˈed siye weˈ si Isa gaˈi siye dinaˈak magaka-aka si meˈ aˈa sabab inin. Duk dinaˈak weˈ ne pinakan nakanakin. ");
INSERT INTO yka_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tahalaˈ si Isa duk pī iye si lahatne, si Nasaret. Nuhut iye isab meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Manjari pagellew Sabtuˈ, ellew liˈi meˈ Yahudihin, nagnaˈ ne isab iye magusihat dem langgal. Ekka mapakale si iyehin ulaliˈ. Paˈinde, “Uy, antag pangeddoˈanne pangadjiˈne inin? Duk kataˈu ine ne pangurung iye inin? Saˈingge pangahinangne meˈ hinangan balakat īˈen? ");
INSERT INTO yka_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Takilalete bi hep aˈa inin. Iye inin kalpentero, anak Mariyamin. Pungtinaˈine hep disi Yakub duk si Joses duk si Judas duk si Simon. Duk meˈ pungtinaˈine dendehin tiyaˈ du hep tuˈu si lahatte bi.” Duk peddiˈ ateyden pu si Isa. ");
INSERT INTO yka_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hangkan paˈin si Isa si siye, “Pagaddatan nabihin antag-antag. Saguwaˈ bang si lahatne duk dem kaˈusbahanne duk si lumaˈne, gaˈi iye pagaddatan.” ");
INSERT INTO yka_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Duk gaˈ si Isa makahinang hinangan balakatan laˈi, bukut hadja amban pamettadne meˈ tanganne si meˈ aˈa saki bang piyanganin duk pinakoleˈ siye weˈ ne. ");
INSERT INTO yka_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ulaliˈ teˈed iye bang weˈey meˈ aˈa malaˈihin gaˈi kahagad si iye. Manjari lumengngan si Isa ngalatag meˈ kalumaˈan si lahat miyaˈan duk magusihat iye laˈi. ");
INSERT INTO yka_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Manjari ilinganan weˈ ne tindegne sampūˈ duk duwehin pī si iye duk dinaˈak siye weˈ ne lumengngan duwangan-duwangan magmahalayak lapal Tuhanin. Inurungan isab siye weˈ ne balakat maluwas meˈ seyitan. ");
INSERT INTO yka_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Duk sinessaˈan siye weˈ ne subey siye gaˈi magboˈo ine-ine si palengngananden. Subey siye gaˈi magboˈo kinakan atawa puyuˈ pangisi-ngisihan atawa pilak dem sabitande. Luwal hadja tungkud makajari boˈode. ");
INSERT INTO yka_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Makajari siye magtehompaˈ saguwaˈ gaˈi siye makajari magboˈo badjuˈ seddili amban si baranden. ");
INSERT INTO yka_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Duk paˈin si Isa si siye, “Antag-antag kalumaˈan katekkahanbi, bang kaˈam dinaˈak manaˈik weˈ aˈa pī si lumaˈne, daˈa ne kaˈam usaˈ tiggelanbi laˈi si lahat miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Duk bang niyaˈ kalumaˈan papīhanbi bu meˈ aˈahin gaˈi ngaddatan kaˈam, duk gaˈi mabayaˈ pakale si kaˈam, tahalaˈ kaˈam amban kalumaˈan miyaˈan. Pagpaganun bi dahuˈ leppug bettisbin, tandaˈ weˈ muwas ne kaˈam si siye, ubus bu tahalaˈ ne kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Manjari lumengngan ne siye magmahalayak weˈ subey meˈ aˈahin pagsusunande meˈ duseden duk lebbahande ne meˈ hinangande malaˈatin. ");
INSERT INTO yka_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ekka meˈ seyitan tapaluwas weˈ de duk ekka aˈa saki sinusutan weˈ de isellan duk pinakoleˈ weˈ de. ");
INSERT INTO yka_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Manjari takale weˈ Sultan Herod sabab meˈ hinangan balakat tahinang si Isahin peggeˈ bawag ne hep ēn si Isahin. Magbissā-bissā meˈ aˈahin sabab si Isa. Niyaˈ magpaˈin, “Ellum ne balik Yahiya magpandi-pandi aˈahin hangkan hep tahinangne meˈ hinangan balakatan miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Saguwaˈ paˈin sinduwehin isab, “Nabi Eliyas hatu miyaˈan.” Duk niyaˈ pe isab sinduwe magpaˈin, “Nabi hep hatu iye miyaˈan, kuweˈ meˈ nabi awwalley.” ");
INSERT INTO yka_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Saguwaˈ pagkale si Herod inin, paˈinne, “Si Yahiya miyaˈan, bakas dinaˈakku pinunggelanin. Ellum iye balik.” ");
INSERT INTO yka_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Peggeˈ Sultan Herod hep mangandaˈak niggew Yahiyahin duk dinaˈak kinalabusu weˈ ne. Kuweˈ inin kahalanne miyaˈan: Sultan Herod inin, inanda weˈ ne ipalnen, Herodiyas, bu ellum pe salinen si Pilip, ella Herodiyasin. Manjari sakaliˈ ne siye magdambuwaˈ, inamāhan sultanin weˈ Yahiya. Paˈin Yahiya si iye, “Gaˈi halal bang kew magdambuwaˈ duk anda pungtinaˈinun. Magduse kew.” Na, iye miyaˈan sababnen hangkan binantahan weˈ Herodiyas si Yahiya duk batang papateyne. Saguwaˈ gaˈi dinaˈak weˈ sultanin, ");
INSERT INTO yka_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","peggeˈ pagaddatan weˈ Sultan Herod Yahiya. Kataˈuhanne weˈ Yahiya aˈa bentel duk sutsi ateynen. Hangkan inelligan iye weˈ sultanin duk inisi weˈ ne dem kalabusu duk iye gaˈi tapapatey. Mabayaˈ pakale si Herod pu Yahiya magusihat, saguwaˈ pagkalene iye, sasew dem pikilannen. ");
INSERT INTO yka_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Manjari dambuwaˈ ellew katumanan du kinabayaˈan Herodiyasin. Pagtekka ellew pangesseban panganak pu Sultan Herodin, ngahinang si Herod pagjamu-jamuhan para si meˈ bagellal si pagsultanannen duk si meˈ kapitan kasundaluhannen, duk si meˈ aˈa langkew si lahat Jalil miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Manjari paglaˈi ne siye kēmon magtipun, padiyalem pī anak Herodiyas dendehin mansak. Na, kasulutan si Herod duk meˈ bisitanen. Manjari paˈin sultanin si budjangin, “Māku kew si aku. Ine-ine kabayaˈannu, pangurungku kaˈu.” ");
INSERT INTO yka_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Duk napa pe iye, paˈinne, “Ine-ine pākunu si aku, asal pangurungku teˈed kaˈu, bisan pe dan tengaˈ pangalataˈkun.” ");
INSERT INTO yka_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Paluwas budjangin duk tinilew weˈ ne saˈinen, paˈinne, “Inaˈ, ine enteˈ pākuku?” Nambung saˈinen, “Pākuhun kōk si Yahiya magpandi-pandi aˈahin.” ");
INSERT INTO yka_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Magtawus padiyalem balik budjangin magdayiˈ-dayiˈ pī si sultanin māku, paˈinne, “Tuwan, iye inin pinākukun. Pangurungun aku duˈun-duˈun kōk Yahiya magpandi-pandi aˈahin binettad diyataˈ talam.” ");
INSERT INTO yka_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Magsusun teˈed sultanin, saguwaˈ gaˈi iye bayaˈ dapat si bissānen peggeˈ bakas iye napa si panaˈanan meˈ bisitanen. ");
INSERT INTO yka_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Magtawus ne dinaˈak weˈ sultanin dambuwaˈ sundalu amban meˈ guwaldiyanen pī ngeddoˈ kōk Yahiyahin. Manjari pī ne sundaluhin munggelan Yahiya dem kalabusu. ");
INSERT INTO yka_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ubus binoˈo weˈ ne kōknen binettad diyataˈ talam duk pinangurung ne weˈ ne si budjangin. Manjari pinangurung isab weˈ budjangin si saˈinen. ");
INSERT INTO yka_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pagkale meˈ tindeg si Yahiyahin inin, pī siye ngeddoˈ bangkeynen duk kinubul weˈ de. ");
INSERT INTO yka_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Manjari meˈ aˈa bakas kawakilan weˈ si Isahin magtipun ne balik pī si iye. Inaka-akahan weˈ de si Isa kēmon meˈ bakas tahinangden duk meˈ pamanoloˈden. Ekka hep aˈa maggew-gantiˈ pī si siye hangkan gaˈi ne siye bisan makasaluˈ mangan. ");
INSERT INTO yka_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hangkan paˈin si Isa si siye, “Sūng kite bi pī si lahat makagindew-gindew, kite-kite bi hadja duk kaˈam kapahali-hali daddaliˈ.” ");
INSERT INTO yka_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Manjari tahalaˈ siye magbangkaˈ pī si lahat makagindew-gindew, siye-siye hadja. ");
INSERT INTO yka_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Saguwaˈ ekka aˈa ngite siye patahalaˈden duk makakilale siye. Manjari magubas meˈ aˈahin amban meˈ kalumaˈan hap pī duk dumehellu pe siye tekka amban disi Isa laˈi si dambiyaˈ lamew. ");
INSERT INTO yka_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagtakas si Isa, banes teˈed aˈa kitene duk maˈaseˈ iye si siye, peggeˈ kuweˈ siye meˈ bili-bili gaˈ niyaˈ ngipat siye. Manjari ekka pamanoloˈne siye. ");
INSERT INTO yka_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pagkohap ne, pī meˈ tindegnen si iye duk paˈinde, “Lahat gaˈi hep inin tantu papituhan aˈa bu iyuˈ ne kohap teˈed. ");
INSERT INTO yka_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Daˈakun meˈ aˈa inin pī si meˈ aˈa magtinanemin laˈi si kalahatan diyataˈ duk si meˈ kalumaˈan mapaliputin duk siye makabelli kinakande.” ");
INSERT INTO yka_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Saguwaˈ paˈin si Isa si siye, “Kaˈam ne mamakan siyehin.” Paˈinde si iye, “Na, inumey inin? Sa banes aˈa iyan, subey tangdan aˈa maghinang dem walum bulan pamelli panin pamakan siye iyan.” ");
INSERT INTO yka_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tilew si Isa siye, paˈinne, “Piyek kayuˈ panbi lu? Pī koˈ, payamanun bi.” Pagsakaliˈ ne kataˈuhande, paˈinde, “Lime du panin duk duwe kenna.” ");
INSERT INTO yka_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Manjari dinaˈak siye weˈ si Isa ningkoloˈ kēmon magtumpuk-tumpuk diyataˈ balili. ");
INSERT INTO yka_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hangkan ningkoloˈ ne siye magtumpuk-tumpuk, niyaˈ ne dahatus-dahatus duk niyaˈ ne lime-limempūˈ. ");
INSERT INTO yka_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Manjari ineddoˈ weˈ si Isa pan lime kayuˈin duk kenna duwehin, bu mayam iye magdiyataˈ langit magpasalamat si Tuhan. Ubus bu binahagiˈ-bahagiˈ weˈ ne panin duk pinangurung weˈ ne si meˈ tindegnen dinaˈak pangurung si meˈ aˈahin. Damikkiyan isab kenna duwehin binahagiˈ-bahagiˈ weˈ ne si siye kēmon. ");
INSERT INTO yka_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mangan siye kēmon duk esso siye. ");
INSERT INTO yka_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagubus siye mangan, tinipun weˈ meˈ tindeg si Isahin lukasde pan duk kennahin, sampūˈ duk duwe bakaˈ pennoˈ. ");
INSERT INTO yka_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ekkahan mamangan pan miyaˈan, meˈ lellahin hadja niyaˈ lime ngibu. ");
INSERT INTO yka_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Puwas miyaˈan, magtawus dinaˈak weˈ si Isa meˈ tindegnen pasakey dem bangkaˈ. Pinadehellu siye weˈ ne pī si dambiyaˈ lamew si puweblo Betsaida, sābune pe mapoleˈ meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pagubus ne siye patahalaˈne, pī iye diyataˈ kūd missā si Tuhan. ");
INSERT INTO yka_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pagsangem ne, laˈi ne si tengngaˈ lamew bangkaˈin. Si Isa laˈi pe diyataˈ kūd dendangan. ");
INSERT INTO yka_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kitene meˈ tindegnen kahunitan teˈed peggeˈ pasumbal si siye baliyuhin. Pagdayiˈ ellew ne, pī si Isa si siye lumengngan diyataˈ kuwit-kuwit lamew. Sōng hadja siye labeyanne, ");
INSERT INTO yka_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","saguwaˈ takite meˈ tindegnen iye lumengngan diyataˈ kuwit-kuwit lamew duk kannalde weˈ panyataˈ iye. Magkilahap teˈed siye. ");
INSERT INTO yka_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Peggeˈ kēmon siye takitede iye duk kaˈumagadan siye. Saguwaˈ magtawus si Isa missā si siye duk paˈinne, “Pahagetun bi ateybin. Aku hep ituˈ. Daˈa kaˈam tinalew.” ");
INSERT INTO yka_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Manjari pasakey si Isa pī si siye magdem bangkaˈ. Pagsakeyne, padeheng baliyuhin hangkan bengngangan teˈed meˈ tindeg si Isahin. ");
INSERT INTO yka_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Peggeˈ bisan ne bakas takitede balakat si Isahin pamakanne aˈa lime ngibuhin, gaˈi pe teˈed tasabutde bang ine hāti bakas takiteden. ");
INSERT INTO yka_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pagsakaliˈ ne siye lumipag, tekka siye si lahat Gennesaret duk padungguˈ siye si tapiyan. ");
INSERT INTO yka_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagduwaˈide amban bangkaˈ, magtawus si Isa takilale weˈ meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Manjari magubas meˈ aˈahin ngalatag kalahatan mapaliputin duk binoˈo weˈ de meˈ aˈa masakihin diyataˈ tanggungande bisan antag pakakalehande palaˈihan si Isahin. ");
INSERT INTO yka_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Antag-antag katekkahanne, si meˈ kalumaˈan ke, atawa si puweblo, atawa si lahat diyataˈ, pinabāk weˈ de meˈ masakihin si meˈ tabuˈan duk pabuyuˈ-buyuˈ siye pu si Isa bang makajari antan meˈ masakihin bisan hadja tuggu semmeknen. Na, kēmon makaˈantan iyehin kawuliˈan. ");
INSERT INTO yka_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Manjari magtipun meˈ Pariseohin pī pu si Isa magtuhut duk bang piyangan guru si saraˈ āgama amban Awrusalam. ");
INSERT INTO yka_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Takitede meˈ tindeg si Isahin mangan. Kaharaman siye peggeˈ meˈ tindeg si Isahin mangan bu gaˈ siye ngosoˈ tangan makasutsi nuhut addat duk panoloˈ meˈ Pariseohin. ");
INSERT INTO yka_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Addat meˈ Pariseohin duk kēmon ne meˈ Yahudihin, gaˈi hep siye mangan bang gaˈi dahuˈ siye kapangosoˈ tangan nuhut biˈat-biˈatan meˈ kapapuˈanden. ");
INSERT INTO yka_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bang siye tekka amban tabuˈan, gaˈi siye mangan bang gaˈi dahuˈ siye kapangosoˈ kuweˈ miyaˈan. Duk ekka pe meˈ biˈat-biˈatan seddili tuhutde kuweˈ pagkosoˈ meˈ tikung, meˈ kaldero duk meˈ siliˈ. ");
INSERT INTO yka_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hangkan tinilew weˈ meˈ Pariseohin duk meˈ guru si saraˈ āgamahin si Isa, paˈinde, “Weˈey meˈ tindegnun gaˈi nuhut biˈat-biˈatan meˈ kapapuˈanten bi? Weˈey siye mangan bisan siye gaˈ bakas ngosoˈ tangan makasutsi?” ");
INSERT INTO yka_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nambung si Isa, paˈinne, “Kaˈam iyan magmā-mā nuhut Tuhan bu gaˈi du. Asal bennal teˈed bissā Tuhan sinulat Nabi Isaya sabab kaˈamin. Laˈi paˈin Tuhanin, ‘Meˈ aˈa inin pahadjede ku duk behede, saguwaˈ ateyden gaˈi nuhut aku. ");
INSERT INTO yka_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gaˈ gunane pagsambahayangde si akuhin, peggeˈ meˈ pamanoloˈden hinang-hinang aˈa hadja bu paˈinde amban aku,’ paˈin Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Tinayikutan weˈ bi meˈ pangandaˈakan Tuhanin,” paˈin si Isa, “duk iye tinuhutbin meˈ biˈat-biˈatan aˈa. ");
INSERT INTO yka_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Asal pandey kaˈam,” paˈin si Isa. “Tinayikutan weˈ bi meˈ pangandaˈakan Tuhanin supaya tatuhutbi biˈat-biˈatan kapapuˈanbin. ");
INSERT INTO yka_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Peggeˈ, missā hep Tuhanin dem saraˈ pinangurungne pu si Musa para si meˈ aˈahin, paˈinne, ‘Pagaddatanun bi saˈi-samabin.’ Duk ‘Sine-sine missāhan saˈinen atawa samanen laˈatan, subey teˈed iye pinapatey.’ ");
INSERT INTO yka_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Saguwaˈ kaˈam,” paˈin si Isa, “si saraˈ hininang-hinangbin hadja, paˈinbi weˈ bang niyaˈ aˈa magpaˈin si saˈi-samanen, ‘Gaˈ ne niyaˈ panabangku kaˈam, Ammaˈ atawa Inaˈ, kulban ne, hātinen tapangurungku ne alataˈkun si Tuhan,’ ");
INSERT INTO yka_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","na, bang kuweˈ miyaˈan bissā aˈahin,” paˈin si Isa, “gaˈi ne iye pahinangbi ine-ine panabangne meˈ matettoˈanen. ");
INSERT INTO yka_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na, sa hinanganbi iyan, gaˈi du pinagmasi weˈ bi pangandaˈakan Tuhanin peggeˈ iye pamanoloˈbin meˈ biˈat-biˈatan kapapuˈanbin. Duk ekka pe hinanganbi sa miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Puwas miyaˈan, ilinganan ne isab balik weˈ si Isa meˈ aˈahin pī si iye duk paˈinne si siye, “Pakale kaˈam kēmon si aku duk tahātibi bissāku inin: ");
INSERT INTO yka_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dumaˈin kinakan mapadiyalem si baran aˈahin makaharam iyehin. Saguwaˈ iye makaharam iyehin, meˈ mapaluwas amban ateynen. ");
INSERT INTO yka_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Amey-amey pakalehun bi bang niyaˈ pinaˈin si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pagtumahalaˈ ne disi Isa amban meˈ aˈahin, padiyalem siye dem lumaˈ. Tinilew iye weˈ meˈ tindegnen sabab panoloˈne miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Paˈinne si siye, “Sampay kaˈam isab, gaˈi tahātibi? Gaˈi ke tahātibi weˈ bisan kinakan ine padiyalem dem baran aˈa gaˈi makaharam iye? ");
INSERT INTO yka_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Peggeˈ gaˈi hep inin padiyalem dem ateyne saguwaˈ dem bettengne hadja, ubus bu pinaluwas du.” Bissā si Isa miyaˈan magpahāti weˈ gaˈ niyaˈ kinakan haram, kēmon halal. ");
INSERT INTO yka_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Paˈin si Isa pe, “Mapaluwas amban atey aˈahin, iye iyan makaharam iyehin. ");
INSERT INTO yka_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Peggeˈ amban dem ateyne paguwaˈ meˈ pikilanne malaˈatanin, pagjinahin, pagtangkewin duk pagpapateyin. ");
INSERT INTO yka_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Damikkiyan amban dem atey aˈa, paguwaˈ pagnapsuhin, pagakkalin, pagbaˈisin, pagibegin, paglimut-limutin, paglangkew ateyin, pagkadupanganin, duk kēmon ne hinangan malaˈatin. ");
INSERT INTO yka_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kēmon meˈ malaˈat inin paluwas amban dem atey aˈa duk iye makaharam iyehin.” ");
INSERT INTO yka_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Manjari tahalaˈ si Isa billaˈi duk hap pī iye si dambuwaˈ lahat tapit si puweblo Tiros. Paglaˈi iye, padiyalem iye si dambuwaˈ lumaˈ, duk laˈi iye patennaˈ. Kabayaˈannen weˈ gaˈ niyaˈ ngataˈu weˈ laˈi iye. Saguwaˈ ujud kataˈuhan du. ");
INSERT INTO yka_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Niyaˈ dende laˈi bakas takalene sabab si Isa. Pagkalene weˈ īˈ laˈi si Isa, magtawus iye hap pī pasujud si bettis si Isa. Dende miyaˈan taga anak dende-dende pasayedan seyitan. ");
INSERT INTO yka_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dumaˈin Yahudi dende miyaˈan saguwaˈ bangsa Penisiya iye, amban lahat Siriya. Na, manjari pabuyuˈ-buyuˈ iye pu si Isa pakipaluwasne seyitanin amban anaknen. ");
INSERT INTO yka_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Missā si Isa si iye si dalilan, paˈinne, “Subey pinaˈesso dehellu meˈ anakin peggeˈ gaˈi patut ineddoˈ kinakan meˈ anakin bu ilakasan pī si meˈ asu.” ");
INSERT INTO yka_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Bennal, Tuwan,” paˈin dendehin. “Saguwaˈ bisan du meˈ asu diyawaˈ lamisahanin, kakande du mapagpag weˈ meˈ mākanakin.” ");
INSERT INTO yka_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Manjari paˈin si Isa si iye, “Hap lumaˈ ne kew. Sabab bissānu iyan, paluwas ne seyitanin amban anaknun.” ");
INSERT INTO yka_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hap lumaˈ ne dendehin duk kitene anaknen pabāk-bāk diyataˈ kantil. Ubus ne paluwas seyitanin amban iye. ");
INSERT INTO yka_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Manjari tahalaˈ si Isa amban meˈ kalahatan si Tirosin balik pī si antag lamew Jalil. Binutasan weˈ ne lahat Sidonin palabey amban lahat ēnande Sampūˈ Puweblohin. ");
INSERT INTO yka_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Niyaˈ dambuwaˈ aˈa bisu duk engngeˈ binoˈo weˈ aˈa pī pu si Isa. Pabuyuˈ-buyuˈ siye pu si Isa, pakibettad tangannen si iye. ");
INSERT INTO yka_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Manjari binoˈo weˈ si Isa aˈahin tahalaˈ amban dem meˈ kaˈekkahanin. Ubus pinapī weˈ ne meˈ timbōˈnen dem tayinge aˈahin. Ngaluraˈ isab iye ubus bu inantan weˈ ne dellaˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Manjari mayam si Isa magdiyataˈ langit duk magnapas iye pinahadje duk paˈinne si aˈahin, “Eppata!” Hātinen, “Paluka kaˈam!” ");
INSERT INTO yka_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Magtawus tayinge aˈahin makakale duk ngalokaˈ ne dellaˈnen duk pastiˈ ne pamissānen. ");
INSERT INTO yka_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Manjari sinessaˈan meˈ aˈahin weˈ si Isa weˈ subey siye gaˈi magaka-aka pu sine-sine. Saguwaˈ iye-iye panessaˈnen, pasōng pe teˈed pangaka-ngakade sabab inin. ");
INSERT INTO yka_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Duk bengngangan teˈed meˈ aˈahin. Paˈinde, “Uy, asal hāp teˈed kēmon hinanganne inin. Bisan aˈa mabisuhin makakale weˈ ne duk aˈa maˈumewin makabissā weˈ ne.” ");
INSERT INTO yka_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gaˈ tiggel puwas miyaˈan, banes ne teˈed isab aˈa patipun pī pu si Isa bu gaˈ ne niyaˈ kakande. Manjari ilinganan weˈ si Isa meˈ tindegnen pī si iye duk paˈinne si siye, ");
INSERT INTO yka_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Maˈaseˈ ku si meˈ aˈa mabanes inin peggeˈ tellum bahangi ne kuweˈitu patuˈude si akuhin bu gaˈ ne niyaˈ kakande. ");
INSERT INTO yka_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bang siye papoleˈku gaˈ bakas mangan, kinawugtuˈ siye iyan si lān. Bu meˈ sinduwe inin tala pamoleˈanden.” ");
INSERT INTO yka_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Paˈin meˈ tindegnen si iye, “Na, antag kite ngeddoˈ kinakan pamakan siye tuˈu si lahat makagindew-gindew inin?” ");
INSERT INTO yka_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Manjari tilew si Isa siye, “Piyek kayuˈ panbi lu?” Paˈinde, “Pituˈ.” ");
INSERT INTO yka_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Manjari dinaˈak weˈ ne meˈ aˈa mabanesin ningkoloˈ diyataˈ bulak. Ineddoˈ weˈ ne pan pituˈin duk magpasalamat iye si Tuhan. Ubus bu binahagiˈ-bahagiˈ weˈ ne panin duk pinangurung weˈ ne si meˈ tindegnen dinaˈak pinangurung si meˈ aˈahin. Duk pinangurung ne weˈ de. ");
INSERT INTO yka_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Niyaˈ isab kenna dikiˈ bang piyek kayuˈ. Pagubus si Isa magpasalamat si Tuhan, dinaˈak isab weˈ ne pangurung kennahin si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mangan siye kēmon duk esso siye. Ubus bu tinipun weˈ de lukasin, pituˈ bakaˈ pennoˈ. ");
INSERT INTO yka_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Niyaˈ kulang-labi ampat ngibu meˈ aˈa mamanganin. ");
INSERT INTO yka_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Manjari pinapoleˈ ne meˈ aˈahin weˈ si Isa duk magtawus iye pasakey duk meˈ tindegnen dem bangkaˈ pī si lahat Dalmanuta. ");
INSERT INTO yka_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pagtekka si Isa duk meˈ tindegnen si Dalmanuta, hap pī si iye meˈ Pariseohin moˈo iye magsuweyan. Batang iye kuhi-kuhide hangkan makapakite siye tandaˈ bang bennal taga kapatut iye amban Tuhan. ");
INSERT INTO yka_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Magnapas pinahadje si Isa duk paˈinne si siye, “Meˈ aˈa kuweˈitu inin luwal ne hadja māku tandaˈ. Sabennal akahante kaˈam, gaˈ niyaˈ tandaˈ pakitehanku si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Manjari tahalaˈ si Isa amban siye. Pasakey iye balik dem bangkaˈ palipag pī si dambiyaˈ lamew. ");
INSERT INTO yka_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Meˈ tindeg si Isahin gaˈ makaˈesseb moˈo kinakan. Luwal du dambuwaˈ pande dem bangkaˈin. ");
INSERT INTO yka_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Manjari sinessaˈan siye weˈ si Isa si dalilan. Paˈinne, “Pahatul-hatul kaˈam. Halliˈanun bi pasulig meˈ Pariseohin duk pasulig Sultan Herodin.” ");
INSERT INTO yka_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Magbissā-bissā meˈ tindegnen sabab pinaˈinne miyaˈan peggeˈ gaˈ tahātide. Paˈinde, “Hangkan hatu iye missā kuweˈ miyaˈan, peggeˈ gaˈ kite bi makaboˈo pan.” ");
INSERT INTO yka_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kataˈuhan si Isa bang ine pagbissā-bissāden. Hangkan paˈinne si siye, “Weˈey pagbissābin sabab gaˈ niyaˈ panbi? Gaˈi pe ke kataˈuhanbi atawa tahātibi? Gaˈi kaˈam katoloˈan? ");
INSERT INTO yka_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Niyaˈ matabi saguwaˈ kuweˈ gaˈi kaˈam makakite. Niyaˈ tayingebi saguwaˈ kuweˈ gaˈi kaˈam makakale. Gaˈ ke taˈessebbi bakas hininangku ellew īˈen? ");
INSERT INTO yka_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pamahagiˈ-mahagiˈku pan limehin si meˈ aˈa lime ngibuhin, piye bakaˈ pennoˈ weˈ lukas tinipunbin?” Paˈinde, “Sampuk-duwe.” ");
INSERT INTO yka_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Duk gaˈ ke taˈessebbi pan pituˈ binahagiˈ-bahagiˈku si meˈ aˈa ampat ngibuhin? Piye bakaˈ pennoˈ weˈ lukas tinipunbin?” Paˈinde, “Pituˈ.” ");
INSERT INTO yka_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Na,” paˈinne, “bu gaˈi pe tahātibi.” ");
INSERT INTO yka_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Manjari tekka siye si puweblo Betsaida. Niyaˈ meˈ aˈa pī si iye magboˈo aˈa pessek duk pabuyuˈ-buyuˈ siye pu si Isa pakiˈantan si iye. ");
INSERT INTO yka_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Manjari inantanan ne weˈ si Isa tangan aˈa mapessekin duk tinundan weˈ ne binoˈo paluwas amban meˈ kalumaˈan miyaˈan. Paglaˈi ne siye, pineppaˈan weˈ si Isa meˈ mata aˈahin duk binettad weˈ ne meˈ tangannen si mata aˈahin. Ubus bu tinilew weˈ ne aˈahin, “Niyaˈ ke takitenu?” ");
INSERT INTO yka_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mayam aˈahin patongas duk paˈinne, “Ngite ku meˈ aˈa lumengngan-lengngan, saguwaˈ kuweˈ siye bantuk kayu.” ");
INSERT INTO yka_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Manjari binettad balik weˈ si Isa meˈ tangannen si meˈ mata aˈahin. Mayam aˈahin pahantap, manjari kawuliˈan iye duk pastiˈ ne pamayamne kēmonin. ");
INSERT INTO yka_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Manjari pinapoleˈ ne iye weˈ si Isa. Paˈin si Isa si iye, “Daˈa ne kew balik pī si kalumaˈan miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Manjari palanjal ne si Isa duk meˈ tindegnen pī si meˈ kalumaˈan mapaliput si puweblo Kesarea Pilipihin. Sasangde si lān, tinilew weˈ ne meˈ tindegnen, paˈinne, “Ine paˈin meˈ aˈahin, sine koˈ ku?” ");
INSERT INTO yka_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nambung siye, paˈinde, “Niyaˈ meˈ aˈa magpaˈin weˈ kaˈu koˈ si Yahiya magpandi-pandi meˈ aˈahin ellum balik. Sinduwehin isab magpaˈin weˈ Nabi Eliyas koˈ kew. Duk niyaˈ pe isab magpaˈin weˈ kaˈu koˈ dambuwaˈ meˈ nabi awwalley.” ");
INSERT INTO yka_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Saguwaˈ bang kaˈam,” paˈin si Isa, “ine paˈinbi? Sine teˈ ku?” Nambung si Petros, paˈinne, “Kaˈu Almasihin, tapeneˈ Tuhan magbayaˈin.” ");
INSERT INTO yka_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Manjari sinessaˈan teˈed siye weˈ si Isa weˈ subey siye gaˈi magaka-aka bisan pu sine bang sine iye. ");
INSERT INTO yka_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na, nagnaˈ si Isa magtoloˈ si meˈ tindegnen sabab dinen. “Aku inin,” paˈinne, “Anak Manusiyaˈin, subey ekka kabinasahan sandalanku duk gaˈi du ku pinagmasi weˈ meˈ kabahiˈanin duk meˈ nakuraˈ meˈ imamin duk meˈ guru si saraˈ āgamahin. Pinapatey du ku iyan duk pagpuwas tellum bahangi, ellum du ku balik.” ");
INSERT INTO yka_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Binissā inin weˈ si Isa pinapastiˈ, hangkan binoˈo si Isa weˈ si Petros patala-tala bu inamāhan iye weˈ ne bang weˈey iye missā sa miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Saguwaˈ paharap si Isa si meˈ tindegnen duk pinayaman siye weˈ ne. Manjari inamāhan weˈ ne si Petros duk paˈinne si iye, “Tahalaˈ kew amban aku, Seyitan. Peggeˈ pikilannun pikilan amban manusiyaˈ hadja, dumaˈin amban Tuhan.” ");
INSERT INTO yka_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Manjari ilinganan weˈ si Isa pī si iye meˈ aˈa mabanesin duk meˈ tindegnen. Paˈinne si siye, “Bang niyaˈ aˈa mabayaˈ nuhut aku, subey iye tuhutne kinabayaˈankun, dumaˈin kinabayaˈannen. Duk subey isab iye moˈo olom pamapateyan iyehin, hātinen maglillaˈ iye nandal kabinasahan duk bisan pe matey. Manjari makajari ne iye nuhut aku. ");
INSERT INTO yka_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Peggeˈ,” paˈin si Isa, “bang aˈahin ellegne umulnen, gaˈ niyaˈ umulne salama-lama. Saguwaˈ bang aˈahin gaˈi ellegne umulnen duk maglillaˈ pe iye matey hawal tuyuˈne manuhut akuhin duk magmahalayak aka-aka mahāpin, na, aˈa iyan taga umul du salama-lama. ");
INSERT INTO yka_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Peggeˈ aˈahin, bisan pe tepe si iye kēmon alataˈ dem dunyahin, gaˈ du niyaˈ gunane bang gaˈi tepe si iye umul salama-lamahin. ");
INSERT INTO yka_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Peggeˈ gaˈ niyaˈ alataˈ si dunya makalekkat iye supaya tepe si iye umul salama-lamahin. ");
INSERT INTO yka_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Sine-sine iyaˈ magpatampal si meˈ aˈa weˈ tindegku iye, duk weˈ nuhut iye toloˈkun, - bu meˈ aˈa kuweˈitu inin kaˈekkahanden dusehan duk gaˈi nuhut Tuhan, - aku, Anak Manusiyaˈin, iyaˈ du ku isab ngilale iye tindegku, bang ku balik pitu magtuhut duk meˈ malaˈikat masutsihin liput weˈ sahaya Samaku Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Paˈin si Isa pe, “Sabenna1 akahante kaˈam, niyaˈ kaˈam matuˈu inin gaˈi matey bang gaˈi dahuˈ takitebi pagbayaˈ Tuhanin duk balakatan teˈed pagbayaˈnen.” ");
INSERT INTO yka_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Manjari, ennem bahangi puwas miyaˈan, binoˈo weˈ si Isa si Petros, si Yakub duk si Yahiya pī diyataˈ punu langkew siye-siye hadja. Sābude malaˈihin, pinda teˈed bantuk si Isahin si pagmatahande. ");
INSERT INTO yka_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Semmeknen ngillap teˈed duk asal poteˈ manamal. Gaˈ niyaˈ aˈa tuˈu si dunya makapapoteˈ semmek kuweˈ poteˈan semmekne miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Manjari paguwaˈ si siye laˈi si Nabi Eliyas duk si Musa duk magbissā siye duk si Isa. ");
INSERT INTO yka_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sābude magbissāhin, paˈin si Petros pu si Isa, “Tuwan, hāp teˈed peggeˈ tiyaˈ kami tuˈu. Ngahinang kami tellu payad-payad. Dambuwaˈ si kaˈu, dambuwaˈ pu si Musa duk dambuwaˈ pu Nabi Eliyas.” ");
INSERT INTO yka_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hangkan si Petros missā sa miyaˈan, peggeˈ gaˈi iye magkataˈu-taˈu bang ine bissāne sabab tinalew teˈed siye. ");
INSERT INTO yka_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Manjari niyaˈ inalak paguwaˈ duk kalandungan siye duk niyaˈ suwala amban dem inalakin magpaˈin, “Inin Anakku kalasahanku teˈed. Pakalehun bi iye.” ");
INSERT INTO yka_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Manjari, pagpayamde paliput, bessuwang gaˈ ne niyaˈ seddili kitede laˈi, luwal saˈ si Isa. ");
INSERT INTO yka_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Manjari sasangde padurul amban diyataˈ punu, sinessaˈan siye weˈ si Isa weˈ subey siye gaˈi magaka-aka bisan pu sine sabab bakas takiteden. Bang iye, Anak Manusiyaˈin, ellum ne balik amban kamateynen, meke ne siye makajari magaka-aka si aˈa. ");
INSERT INTO yka_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tinuhut weˈ de panessaˈne miyaˈan, saguwaˈ magtilew-tinilew siye tellungan bang ine hāti pinaˈinnen weˈ ellum iye balik amban kamateynen. ");
INSERT INTO yka_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na, tilewde si Isa, paˈinde, “Weˈey teˈ magpaˈin meˈ guru si saraˈ āgamahin weˈ subey koˈ pitu dehellu Nabi Eliyas meke Almasihin?” ");
INSERT INTO yka_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nambung si Isa. “Bennal iyan,” paˈinne, “Nabi Eliyas pitu dehellu amban Almasihin manyap kēmonin. Na, ine teˈ paˈin kitabin sabab aku, Anak Manusiyaˈin? Paˈin kitabin weˈ subey ekka kabinasahan sandalanku duk diniyawaˈan ku teˈed. ");
INSERT INTO yka_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Saguwaˈ akahante kaˈam,” paˈin si Isa, “bakas pitu ne Eliyas duk tahinang ne weˈ meˈ aˈahin sasuku kabayaˈanden si iye, kuweˈ du tasulat dem kitab sabab iyehin.” ");
INSERT INTO yka_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pagbalikde pī si meˈ tindegne sinduwehin, banes teˈed aˈa kitede paliput si siye. Duk niyaˈ meˈ guru si saraˈ āgama laˈi magpasuweyan duk siye. ");
INSERT INTO yka_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Manjari pagkite weˈ meˈ aˈa mabanesin si Isa, ulaliˈ siye peggeˈ gaˈ ase-asede weˈ pī laˈi si Isa. Magubas siye pī nagina iye. ");
INSERT INTO yka_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tinilew weˈ si Isa meˈ tindegnen, paˈinne, “Ine pagpasuweyanbi duk siye miyaˈan?” ");
INSERT INTO yka_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Niyaˈ nambung amban meˈ aˈa mabanesin, paˈinne, “Tuwan, binoˈo weˈ ku anakku inin pitu si kaˈu peggeˈ pasayedan iye seyitan maˈumew iye. ");
INSERT INTO yka_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Duk kahabaˈ iye usaˈ seyitanin, hinantakan iye weˈ ne. Magbukal behenen, magtageˈot meˈ impennen, duk ngoral iye. Manjari pināku weˈ ku si meˈ tindegnun pakipaluwasku seyitanin saguwaˈ gaˈ du tapaluwasde.” ");
INSERT INTO yka_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Paˈin si Isa si meˈ aˈahin, “Oy, kaˈam meˈ aˈa kuweˈitu inin. Gaˈ teˈed niyaˈ sandelbi si Tuhan. Taman sumiyan pe ku tuˈu si kaˈam? Taman sumiyan pe ku nandalan addatbin meke kaˈam kahagad? Boˈohun nakanakin pitu si aku.” ");
INSERT INTO yka_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Binoˈo ne weˈ de pī si iye. Pagkite seyitanin si Isa, magtawus pinapaspad weˈ ne nakanakin. Pahantak nakanakin diyataˈ bulak magligidan duk magbukal behenen. ");
INSERT INTO yka_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tinilew weˈ si Isa sama nakanakin, “Sumiyan pe iye sa inin?” Nambung iye, “Kemuwe dikiˈ pe iye. ");
INSERT INTO yka_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Duk daran ne iye tineppadan weˈ seyitanin pī dem ebbut duk dem boheˈ supaya tapapateyne. Bang tahinangnu, andūˈ Tuwan, maˈaseˈ ne kew si kami duk tabangun kami.” ");
INSERT INTO yka_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Tilewnu bang tahinangku?” paˈin si Isa. “Bang aˈahin sandel si Tuhan,” paˈinne, “kēmon tahinangne.” ");
INSERT INTO yka_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Magtawus sama nakanakin missā pinapales, paˈinne, “Ngandel ne ku, Tuwan. Tabangun ku duk pasōng sandelkun.” ");
INSERT INTO yka_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pagkite si Isa meˈ aˈa mabanesin hap pī patipun si iye, inamāhan weˈ ne seyitanin. “Kaˈu seyitan,” paˈinne, “seyitan magpaˈumew duk magpabisu, daˈakte kew paluwas amban nakanak inin duk daˈa ne kew teˈed padiyalem balik si iye.” ");
INSERT INTO yka_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Manjari magkilahap seyitanin duk pinapaspad manamal weˈ ne nakanakin. Ubus paluwas ne seyitanin amban iye. Nakanakin kuweˈ ne aˈa matey, hangkan kaˈekkahan meˈ aˈahin magpaˈin, “Matey ne iye.” ");
INSERT INTO yka_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Saguwaˈ inantanan weˈ si Isa tangan nakanakin duk pinadongaˈ weˈ ne. Manjari nengge ne nakanakin. ");
INSERT INTO yka_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pagdiyalem si Isa si lumaˈ, tinilew iye weˈ meˈ tindegnen, siye-siye hadja, paˈinde, “Weˈey teˈ gaˈ tapaluwas kami seyitanin?” ");
INSERT INTO yka_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Paˈinne si siye, “Da bayuˈ seyitan miyaˈan gaˈi tapaluwas weˈ ine-ine luwal hadja bang pinākuhan si Tuhan.” ");
INSERT INTO yka_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Manjari palanjal ne disi Isa duk meˈ tindegnen. Pabutas siye si lahat Jalil. Gaˈi mabayaˈ si Isa weˈ niyaˈ ngataˈu bang tungan lengngannen, ");
INSERT INTO yka_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","peggeˈ magtoloˈ iye si meˈ tindegnen. Pagtoloˈnen, paˈinne si siye, “Aku, Anak Manusiyaˈin, sinōngan du ku iyan si antanan meˈ aˈa. Papateyde du ku. Tellum bahangi puwas kamateykun, ellum du ku balik.” ");
INSERT INTO yka_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Saguwaˈ gaˈ tahātide bissāne miyaˈan duk gaˈ siye makatawakkal nilew iye. ");
INSERT INTO yka_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Manjari tekka siye si puweblo Kapernaum. Paglaˈi ne siye dem lumaˈ, tinilew weˈ si Isa meˈ tindegnen. “Ine teˈ pagpasuweyanbi si lānin?” paˈinne. ");
INSERT INTO yka_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Saguwaˈ gaˈ siye nambung peggeˈ pagpasuweyanden sabab bang sine siye tamanan malangkewin. ");
INSERT INTO yka_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Manjari ningkoloˈ si Isa duk ilinganan weˈ ne sampūˈ duk duwe tindegnen pī si bihingne. Paˈinne si siye, “Sine-sine mabayaˈ pinalangkew teˈedin, subey iye magpadiyawaˈ dine supaya iye madiyawaˈ amban kēmonin, duk subey iye daraˈakan kēmon aˈa.” ");
INSERT INTO yka_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Manjari ngeddoˈ si Isa dambuwaˈ nakanak dikiˈ duk pinatengge weˈ ne si tengngaˈde. Ubus kinekkepan weˈ ne nakanakin duk paˈinne si siye, ");
INSERT INTO yka_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Bang niyaˈ aˈa bu sabab sandelne si akuhin ngaddatan dambuwaˈ nakanak dikiˈ kuweˈ inin, aku inaddatannen. Duk bang niyaˈ ngaddatan aku, dumaˈin hadja aku inaddatannen, saguwaˈ damikkiyan addatanne Tuhanin, mamapitu aku si dunyahin.” ");
INSERT INTO yka_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Paˈin Yahiya si iye, “Tuwan, niyaˈ takite kami dambuwaˈ aˈa sabbutne ēnnun pagpaluwasne seyitan amban meˈ aˈa. Pinages iye weˈ kami peggeˈ gaˈi iye nuhut kite bi.” ");
INSERT INTO yka_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Daˈa iye pagesun bi,” paˈin si Isa. “Peggeˈ sine-sine nabbut ēnkun paghinangne hinangan balakatan, gaˈi iye mura-mura makabissā laˈatan sabab aku. ");
INSERT INTO yka_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Peggeˈ aˈa manggaˈi manguntarahan kitehin bin,” paˈinne, “bēbbeg amban kite bi. ");
INSERT INTO yka_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sabennal akahante kaˈam weˈ sine-sine ngurungan kaˈam bisan hadja da sawan boheˈ pamaˈinum kaˈam peggeˈ kaˈam tindeg Almasi, asal katumbasan teˈed iye hāp.” ");
INSERT INTO yka_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Saguwaˈ sine-sine makapaduse si dambuwaˈ nakanak dikiˈ kuweˈ inin makahagad si akuhin, hāp pe siˈ iye miyaˈan tapatowengan batu hadje si kellongne bu ilaboˈ pī dem tahik, duk hadja gaˈi taboˈone magduse. ");
INSERT INTO yka_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bang tangannun mamoˈo kaˈu magdusehin, lebbahanun ne pagdusenun. Dalilnen, kuweˈ du putukannu tangannun. Hāp pe kew paˈasek dem surgaˈ bisan kew putuk, amban duwe tangannun saguwaˈ pī kew dem narkaˈ, dem ebbut gaˈ niyaˈ kapalemne. ( ");
INSERT INTO yka_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Laˈi pangalegga Tuhan aˈahin, gaˈ niyaˈ hāranne duk pagsandalin gaˈ niyaˈ tamananne.) ");
INSERT INTO yka_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Damikkiyan bang bettisnun mamoˈo kaˈu magdusehin, lebbahanun pagdusenun. Dalilnen, kuweˈ du putukannu bettisnun. Hāp pe kew paˈasek dem surgaˈ bisan kew putuk, amban duwe bettisnun saguwaˈ tinimanan kew pī dem narkaˈ, dem ebbut gaˈ niyaˈ kapalemne. ( ");
INSERT INTO yka_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Laˈi pangalegga Tuhan aˈahin, gaˈ niyaˈ hāranne duk pagsandalin gaˈ niyaˈ tamananne.) ");
INSERT INTO yka_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Duk bang matanun isab mamoˈo kaˈu magdusehin, lebbahanun pagdusenun. Dalilnen, kuweˈ du ugitannu matanun. Hāp pe kew paˈasek dem surgaˈ bisan dambuwaˈ saˈ matanun, amban duwe matanun saguwaˈ tinimanan kew pī dem narkaˈ. ");
INSERT INTO yka_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Laˈi pangalegga Tuhan aˈahin gaˈ niyaˈ hāranne, duk pagsandalin gaˈ niyaˈ tamananne.” ");
INSERT INTO yka_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Paˈin si Isa pe, “Kēmon aˈahin subey palabey dem ebbut, hātinen dem katiksaˈan, supaya ngabasag sandelden.” ");
INSERT INTO yka_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Paˈinne isab, “Kataˈuhanbi du weˈ asinin asal hāp. Saguwaˈ bang asinin gaˈ ne niyaˈ lessane, gaˈi ne maˈasin balik. Hangkan kaˈam isab,” paˈinne, “subey kaˈam pahatul-hatul supaya gaˈi lepas pagaddat-inaddatbin duk pagsulut-sulutbin.” ");
INSERT INTO yka_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Manjari tahalaˈ si Isa amban lahat Jalil duk hap pī iye si meˈ kalahat-lahatan laˈi si Yahudiya duk sampay si meˈ kalahatan si lipag boheˈ Jordan. Banes ne isab aˈa patipun si iye laˈi. Manjari tinoloˈan siye weˈ si Isa, sa hinangannen. ");
INSERT INTO yka_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Niyaˈ meˈ Pariseo patapit pī si iye duk panguhi-nguhide iye, tilewde iye, paˈinde, “Dem saraˈ, makajari ke bang aˈahin timananne andanen?” ");
INSERT INTO yka_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sambunganne siye, paˈinne, “Ine teˈ daˈakan pangurung si Musa kaˈamin?” ");
INSERT INTO yka_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Paˈinde, “Pangandūsan si Musa lellahin milmahan sulat pagbutasan, ubus makajari ne timananne andanen.” ");
INSERT INTO yka_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Bennal iyan,” paˈin si Isa. “Saguwaˈ hangkan sinulat weˈ ne si kaˈam pangandaˈakan iyan, sabab gaˈi kaˈam ngatu nuhut toloˈ. ");
INSERT INTO yka_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Saguwaˈ kemuwe tagnaˈ pamapanjari Tuhan kēmon-kēmonin, ‘pinapanjari weˈ ne manusiyaˈin lella duk dende,’ sa pinaˈin dem kitabin. ");
INSERT INTO yka_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Hangkan tahalaˈ lellahin amban saˈi-samanen bu padambuwaˈ iye si andanen, ");
INSERT INTO yka_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","duk bakas duwehin magdambuwaˈ baran ne.’ Manjari dumaˈin ne siye duwe baran,” paˈin si Isa, “saguwaˈ dambuwaˈ baran ne. ");
INSERT INTO yka_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hangkan subey teˈed gaˈi pagbutas aˈa bakas pinagdambuwaˈ weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Paglaˈi ne balik meˈ tindeg si Isahin dem lumaˈ patennaˈanden, tinilew isab weˈ de si Isa sabab toloˈne miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sambunganne siye, paˈinne, “Sine-sine nimanan andanen bu maganda seddili, magjina iye duk kapagduse iye si andane poˈonin. ");
INSERT INTO yka_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Damikkiyan bang dendehin isab timananne ellanen bu magella iye seddili, magjina iye.” ");
INSERT INTO yka_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Niyaˈ meˈ aˈa moˈo meˈ anakde pī pu si Isa supaya siye antananne. Saguwaˈ pinagamāhan siye weˈ meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkite si Isa inin, astel iye. “Ambat pitu si aku meˈ mākanakin,” paˈinne, “duk daˈa siye saggaˈun bi. Peggeˈ aˈa kuweˈ rnākanakin ngatu du pinagbayaˈan weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sabennal akahante kaˈam,” paˈin si Isa, “bang pangandel aˈa si Tuhanin dumaˈin kuweˈ pangandel mākanakin, na aˈa iyan asal gaˈi sumakup dem pagbayaˈan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Manjari pinippi weˈ si Isa meˈ mākanakin maggantiˈ-gantiˈ. Binettad weˈ ne tangannen si siye duk māku-māku kahāpan iye si Tuhan para si siye. ");
INSERT INTO yka_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Manjari pagsōng lumengngan disi Isa hap kalahat-lahatan, niyaˈ aˈa magubas pī si iye duk nengge duk tuˈutne magpadiyawaˈ pu si Isa, paˈinne, “Tuwan, aˈa hāp kew. Ine subey hinangku duk ku pinasukuˈan umul salama-lama?” ");
INSERT INTO yka_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sambungan si Isa iye, paˈinne, “Weˈey paˈinnu weˈ hāp ku? Gaˈ niyaˈ hāp luwal Tuhanin dambuwaˈ-buwaˈ. ");
INSERT INTO yka_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kataˈuhannu du,” paˈinne, “meˈ pangandaˈakan Tuhanin. ‘Daˈa kew monoˈ. Daˈa kew magjina. Daˈa kew nangkew. Daˈa kew naksiˈ gaˈi bennal. Daˈa kew ngaliba. Pagaddatanun saˈi-samanun.’” ");
INSERT INTO yka_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Na, Tuwan,” paˈinne, “kēmon iyan tinuhut weˈ ku kemuwe nakanak pe ku.” ");
INSERT INTO yka_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sasang si Isa mayaman iye, kalasahanne iye. Paˈin si Isa, “Niyaˈ pe dambuwaˈ gaˈ tahinangnu. Pī kew, pabellihanun kēmon alataˈnun bu pangurungun ulinen si meˈ mamiskinin. Manjari niyaˈ du iyan alataˈnu laˈi si surgaˈ. Pagubus, balik kew pitu, nuhut kew aku.” ");
INSERT INTO yka_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagkalene bissā si Isa miyaˈan, sengngel luwenen duk tahalaˈ iye dukka, peggeˈ ekka teˈed alataˈne. ");
INSERT INTO yka_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Manjani mayam si Isa paliput si meˈ tindegnen duk paˈinne si siye, “Asal hunit teˈed meˈ madayahanin ngatu pinagbayaˈan weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ulaliˈ teˈed meˈ tindegnen si bissāne miyaˈan. Saguwaˈ paˈinne si siye balik, “Meˈ pungtinaˈi, asal hunit teˈed aˈahin ngatu pinagbayaˈan weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mura pe untaˈin palabey si lowang dalum amban aˈa dayahanin ngatu pinagbayaˈan weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pagkalede bissāne miyaˈan, ulaliˈ teˈed siye manamal duk paˈinde si iye, “Na, sine ne tapī si surgaˈin bang kuweˈ iyan?” ");
INSERT INTO yka_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Manjari mayam si Isa si siye duk paˈinne, “Bang manusiyaˈ gaˈi teˈed makajari, saguwaˈ bang Tuhanin, gaˈ niyaˈ hunit si iye. Tahinangne kēmon.” ");
INSERT INTO yka_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Manjari missā si Petros. “Payamanun kami inin,” paˈinne. “Ubus ne ambanan kami kēmon-kēmonin duk nuhut ne kami kaˈu.” ");
INSERT INTO yka_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Aweˈ,” paˈin si Isa, “sabennal akahante kaˈam, bang niyaˈ aˈa ngambanan lumaˈnen atawa pungtinaˈinen lella-dende, atawa saˈi-samanen, atawa meˈ anaknen, atawa bulaknen, bang ambananne meˈ inin sabab lasane si akuhin duk supaya iye kapalumengngan moˈo aka-aka mahāpin, ");
INSERT INTO yka_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","asal tumbasan Tuhanin iye paˈekka meˈ lumaˈ, duk meˈ pungtinaˈi lella-dende, meˈ saˈi, meˈ anak, duk meˈ bulak, tiggelanne tuˈu si dunya. Saguwaˈ makalabey isab iye kabinasahan bang iye nuhut aku. Saguwaˈ bisan iye bininasa,” paˈin si Isa, “inurungan du iye umul gaˈ tamananne laˈi si ahilat. ");
INSERT INTO yka_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ekka meˈ dumehellu kuweˈituhin, dumambuli du si pasōngan duk ekka dumambuli kuweˈituhin, dumehellu du si pasōngan.” ");
INSERT INTO yka_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Manjari paglaˈi si Isa duk meˈ saweˈnen si lān pataked tudju Awrusalam, lumengngan si Isa padehellu amban siye. Kebba-kebbahan meˈ tindegnen duk meˈ mapatuhut si iye si dambulihanin tinalew. Binoˈo ne isab weˈ si Isa patala-tala tindegne sampūˈ duk duwehin duk inakahan siye weˈ ne sabab sōng maˈumantag si iyehin. ");
INSERT INTO yka_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Paka1e kaˈam,” paˈinne. “Kite bi inin pataked hap Awrusalam. Paglaˈi ne kite bi, aku, Anak Manusiyaˈin, sinōngan du pī si antanan meˈ nakuraˈ meˈ imamin duk meˈ guru si saraˈ āgamahin. Manjari hukumande si akuhin weˈ pinapatey ku. Ubus sōngande du ku isab pī si antanan meˈ aˈa dumaˈin Yahudi. ");
INSERT INTO yka_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Duk meˈ bangsa seddili inin, hinangde du ku dagey duk pagluraˈande ku duk lubakande ku. Ubus bu papateyde ku. Saguwaˈ puwas tellum bahangi, ellum du ku balik.” ");
INSERT INTO yka_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Manjari patapit pī pu si Isa si Yakub duk Yahiya, meˈ anak Sebedehin. Paˈinde si iye, “Tuwan, niyaˈ batang pāku kami si kaˈu hinangnu para si kami.” ");
INSERT INTO yka_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Weˈ ine kabayaˈanbi hininangku para si kaˈamin?” paˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nambung siye, paˈinde, “Kabayaˈan kamihin, bang ne kew ningkoloˈ magbayaˈ, patingkoloˈnu kami si bihingnu, dambuwaˈ si kanawanannu duk dambuwaˈ si bibangannu.” ");
INSERT INTO yka_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Saguwaˈ paˈin si Isa si siye, “Gaˈi kataˈuhanbi bang ine pinākubi inin. Ngatu ke kaˈam bininasa kuweˈ sōng paminasa akuhin? Ngatu ke kaˈam pinapatey kuweˈ sōng pamapatey akuhin?” ");
INSERT INTO yka_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Aweˈ, ngatu kami,” paˈinde. Manjari paˈin si Isa si siye, “Asa1 bininasa du kaˈam kuweˈ sōng paminasa akuhin duk pinapatey du kaˈam kuweˈ pamapatey akuhin. ");
INSERT INTO yka_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Saguwaˈ bang pagpatingkoloˈ si kanawanankun atawa si bibangankun,” paˈin si Isa, “dumaˈin aku magbayaˈin. Saguwaˈ meˈ paningkoloˈan miyaˈan sukuˈ si meˈ pinanyapan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Manjari pagkale tindeg si Isa sampūˈin sabab pināku si Yakub duk Yahiyahin, astel siye. ");
INSERT INTO yka_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Manjari ilinganan weˈ si Isa meˈ tindegnen kēmon. Paˈinne si siye, “Kataˈuhanbi addat meˈ aˈa si dunyahin. Meˈ nakuraˈ meˈ kabangsahan seddilihin magmanda teˈed si meˈ aˈahin, duk meˈ aˈa malangkewin magbayaˈ teˈed si meˈ aˈaden. ");
INSERT INTO yka_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Saguwaˈ kaˈam,” paˈin si Isa, “subey gaˈi magsa miyaˈan. Sine-sine kaˈam mabayaˈ pinalangkew, subey iye daraˈakanbi. ");
INSERT INTO yka_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Duk sine-sine kaˈam asal mabayaˈ manjari tamanan malangkewin, subey iye kuweˈ banyagaˈ nabangan saweˈnen. ");
INSERT INTO yka_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Peggeˈ bisan aku, Anak Manusiyaˈin,” paˈin si Isa, “dumaˈin papituhankun makitabang si manusiyaˈ saguwaˈ nabang manusiyaˈ. Duk pitu ku paglillaˈku umulkun pangalekkat meˈ aˈa maˈekkahin supaya siye gaˈi ilegga sabab duseden.” ");
INSERT INTO yka_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Manjari tekka si Isa duk meˈ tindegnen si puweblo Ariha. Pagtahalaˈde billaˈi, ekka teˈed aˈa nuhut siye. Na, niyaˈ laˈi ningkoloˈ si higad lān palabeyanden aˈa pessek magpāku-pāku sīn. Ēnnen si Bartimiyus, anak Timiyus. ");
INSERT INTO yka_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pagkalene weˈ si Isa, aˈa Nasaretin hatiˈ mapalabey miyaˈan, ngalingan iye papales, paˈinne, “O Isa, tubuˈ Sultan Daˈud, maˈaseˈ ne kew si aku.” ");
INSERT INTO yka_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ekka ngamāhan iye, gaˈi iye dinaˈak magbukag. Saguwaˈ namba ne papalesne paglingannen. “O tubuˈ Sultan Daˈud,” paˈinne, “maˈaseˈ ne kew si aku.” ");
INSERT INTO yka_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Padeheng si Isa duk paˈinne, “Lingananun bi iye.” Manjari ilinganan ne weˈ de aˈa mapessekin. Paˈinde si iye, “Pahāpun ateynun. Kuwat kew, īˈ kew linganan si Isa.” ");
INSERT INTO yka_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Magtawus inānan weˈ ne mantanen bu ne pahulangkad duk patapit iye pī pu si Isa. ");
INSERT INTO yka_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Paˈin si Isa si iye, “Ine kabayaˈannu hinangku si kaˈ u?” “Tuwan,” paˈinne, “kabayaˈankun makakite ne ku.” ");
INSERT INTO yka_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Paˈin si Isa si iye, “Pī ne kew. Kawuliˈan ne kew peggeˈ sandel kew si aku.” Magtawus iye makakite duk nuhut ne iye si Isa lumengngan. ");
INSERT INTO yka_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Manjari tapit ne siye si Awrusalam peggeˈ sōng tekka ne siye si meˈ kalumaˈan Betpage duk Betani laˈi si kūd Jaitun. Dinaˈak weˈ si Isa duwangan tindegnen padehellu. ");
INSERT INTO yka_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Paˈinne si siye, “Pī kaˈam si kalumaˈan si dehelluhanbi miyaˈan. Pagtekkabi laˈi, magtawus kaˈam iyan ngite anak asnu dinagtel, gaˈ pe bakas kasakeyan. Lekkahanun bi duk boˈohun bi pitu. ");
INSERT INTO yka_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bang niyaˈ nilew kaˈam bang weˈey eddoˈbi, paˈinun bi, ‘Niyaˈ kagunahan Panuhutanin si iye; papoleˈne du balik pitu magtawus.’” ");
INSERT INTO yka_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na manjari pī ne duwanganin duk takitede anak asnuhin iningketan si gawang lumaˈ si bihing kalsara. Manjari ilekkahan ne weˈ de. ");
INSERT INTO yka_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Niyaˈ meˈ aˈa magtengge laˈi. Sinduwehin nilew siye, paˈinde, “Hoy, weˈey lekkahanbi anak asnu iyan?” ");
INSERT INTO yka_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nambung siye kuweˈ panessaˈ si Isa siyehin, duk pinasagadan ne weˈ de binoˈo. ");
INSERT INTO yka_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Manjari binoˈo weˈ de anak asnuhin pī pu si Isa. Ilampiruhan weˈ de duk meˈ semmekde, ubus bu pasakey ne si Isa. ");
INSERT INTO yka_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ekka isab meˈ aˈa laˈi. Binellat weˈ meˈ aˈahin meˈ semmekden si 1ān palabeyannen. Meˈ sinduwehin kinanatan weˈ de 1ānin duk meˈ pange dawenan bakas totoˈde amban dem meˈ kabbun, pamahadjede si Isa. ");
INSERT INTO yka_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Magellang-ellang meˈ aˈa si dehelluhanin duk meˈ si dambulihanin. Paˈinde, “Pudjite bi Tuhanin. Pudjite bi pinapitu weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pudjite bi matekka inin, iye mapagantiˈ si papuˈte bi ley, Sultan Daˈud. Pudjite bi teˈed Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Manjari pagtekka si Isa si Awrusalam, paˈasek iye pī dem langgal mahadjehin. Pinayaman weˈ ne paliput kēmon malaˈi diyalemin. Ubus paluwas iye pī si Betani magtuhut duk meˈ tindegne sampūˈ duk duwehin peggeˈ kohap ne. ");
INSERT INTO yka_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagsasumu sābude maglengngan amban Betani balik hap Awrusalam inusan si Isa. ");
INSERT INTO yka_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Manjari amban katalahan niyaˈ kitene poˈon kayu ēnande igira ekka dawenne. Patapit iye pī kaw du paˈin iye ngasuwaˈ buwaˈne. Pagabutne laˈi, luwal hadja dawen takitenen peggeˈ dumaˈin baytu pagbuwaˈ meˈ igira. ");
INSERT INTO yka_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Paˈin si Isa, “Tinagnaˈan maˈin gaˈi ne buwaˈ balik kayu inin.” Duk takale inin weˈ meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pagtekka siye si Awrusalam, padiyalem si Isa dem langgal hadjehin duk binudjew weˈ ne meˈ aˈa magdagang duk meˈ magbelli diyalem lumaˈ Tuhanin. Ilintuwadan weˈ ne meˈ lamisahan meˈ aˈa magsambiˈ-sambiˈ sīnin. Ilintuwadan isab weˈ ne meˈ paningkoloˈan meˈ aˈa magdagang assang pagkulubanin. ");
INSERT INTO yka_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Gaˈi isab iye ngandaˈak bisan sine pabutas diyalem langgal magboˈo meˈ kapanyapanden. ");
INSERT INTO yka_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Magusihat si Isa, paˈinne si meˈ aˈahin, “Tasulat dem kitab, paˈin Tuhanin, ‘Lumaˈkun inēnan du lumaˈ pangampunan meˈ kēmon bangsa.’ Saguwaˈ kaˈam,” paˈin si Isa, “hininang weˈ bi lumaˈ Tuhanin kuweˈ lumaˈ patapukan meˈ aˈa panangkew.” ");
INSERT INTO yka_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Manjari kaˈakahan meˈ nakuraˈ meˈ imamin duk meˈ guru si saraˈ āgamahin sabab hininang si Isa miyaˈan. Tinalew siye si iye peggeˈ kēmon aˈa mabanesin bengngangan si usihatnen. Hangkan miha siye lān supaya tapapateyde si Isa. ");
INSERT INTO yka_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pagmagalib ne, paluwas si Isa duk meˈ tindegnen amban puweblo miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagsalung ellew dambuwaˈin, pagbalikde hap Awrusalam, palabey siye si antag kayu igirahin. Takitede kayuhin lanes ne sampay pī si gamutne. ");
INSERT INTO yka_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Manjari taˈesseb weˈ si Petros bakas binissā si Isa sabab kayuhin. Paˈinne pu si Isa, “Uy, Tuwan, payamanun be. Lanes ne kayu igira bakas sinuknaˈannun.” ");
INSERT INTO yka_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Paˈin si Isa si siye, “Ngandel kaˈam si Tuhan. ");
INSERT INTO yka_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sabennal akahante kaˈam,” paˈinne, “sine-sine magpaˈin si punu inin, ‘O punu, tahalaˈ kew duk pateppad kew pī dem tahik,’ duk bang aˈahin gaˈi duwe-duwehan dem ateynen saguwaˈ ngandel teˈed iye weˈ tuman du binissāne miyaˈan, asal hininang du miyaˈan para si iye. ");
INSERT INTO yka_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hangkan hep paˈinku si kaˈam, ine-ine pākubi si Tuhan, bang kaˈam kahagad weˈ tasangkabi ne pinākubin, asal bugtuˈ tasangkabi du. ");
INSERT INTO yka_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Saguwaˈ bang kaˈam sābu māku-māku si Tuhan bu niyaˈ aˈa kapeddiˈan ateybi subey dahuˈ iye ampunbi supaya isab dusebin ampun Tuhanin, iye Samabi si surgaˈin. ");
INSERT INTO yka_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Peggeˈ,” paˈin si Isa, “bang gaˈi siye ampunbi, gaˈi isab dusebin ampun Tuhanin, iye Samabi si surgaˈin.” ");
INSERT INTO yka_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Manjari tekka ne siye si Awrusalam. Sasang si Isa lumengngan diyalem langgal hadjehin, patapit pī si iye meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin duk meˈ kabahiˈanin. ");
INSERT INTO yka_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Paˈinde si iye, “Ine kapatutnu ngahinang meˈ hininangnu ellew miyaˈan? Sine mangurungan kaˈu kapatutin?” ");
INSERT INTO yka_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sambungan si Isa siye, paˈinne, “Niyaˈ isab tilewku si kaˈam. Sambunganun bi ku meke kaˈam akahanku bang ine kapatutku ngahinang meˈ hinanganku miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Pamandi Yahiya meˈ aˈahin, amban kapatutnen? Amban Tuhan ke atawa amban manusiyaˈ hadja? Sambunganun bi ku.” ");
INSERT INTO yka_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Manjari magisun-isun siye, paˈinde, “Bang saˈupama paˈinte bi weˈ kapatut Yahiya pamandine meˈ aˈahin amban Tuhan, paˈinne iyan, ‘Na weˈey Yahiya gaˈ kahagadbi?’ ");
INSERT INTO yka_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Saguwaˈ bang paˈinte bi, ‘Amban manusiyaˈ,’ na makatalew isab.” Tinalew siye si meˈ aˈahin peggeˈ kēmon aˈahin kahagad weˈ Yahiya asal bennal nabi Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hangkan nambung siye, paˈinde, “Inday, gaˈi kataˈuhan kami bang amban kapatut Yahiyahin.” Manjari paˈin si Isa si siye, “Na, gaˈi isab kaˈam akahanku bang amban kapatutku maghinang meˈ hininangku miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Manjari magusihat si Isa si siye magdalilan. “Niyaˈ,” paˈinne, “aˈa maglikus bāhan ubas duk binirang weˈ ne. Ilowangan weˈ ne diyawaˈ pagpeggaˈan ubasin panawutan boheˈ ubasin. Ngahinang isab iye payad langkew pamantew-mantewan likusin. Manjari pinatungguˈan weˈ ne likusnen si meˈ aˈa, pagbahagiˈan uli tinanemnen. Ubus bu tahalaˈ iye pī si lahat tala. ");
INSERT INTO yka_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pagtaˈabut pagbuwaˈ ubasin, dinaˈak weˈ dapuˈ likusin dambuwaˈ daraˈakanne pī si meˈ aˈa tatungguˈnen, māku bahagiˈne si meˈ buwaˈ ubasin. ");
INSERT INTO yka_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Saguwaˈ siniggew iye weˈ meˈ tatungguˈin duk pinapeddiˈan weˈ de. Pinapoleˈ iye gaˈ niyaˈ taboˈone. ");
INSERT INTO yka_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ubus ngandaˈak ne isab dapuˈ likusin seddili daraˈakanne pī si siye. Kinakal iye weˈ de diyataˈ kōkne duk pinaˈiyaˈ weˈ de. ");
INSERT INTO yka_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Manjari ngandaˈak ne isab iye seddili daraˈakanne saguwaˈ pinapatey weˈ de. Ubus miyaˈan, ekka pe sinduwe daraˈakanne dinaˈak weˈ ne pī. Sinduwehin pinapeddiˈan weˈ de duk sinduwehin pinapatey. ");
INSERT INTO yka_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Na, dambuwaˈ saˈ matalebbi si dapuˈ likusin dinaˈak pī. Inin anakne lella kalasahanne teˈed. Kakapusannen iye dinaˈakne mapī si siyehin. Paˈinne dem ateyne, ‘Bugtuˈ pagaddatande anakkun.’ ");
INSERT INTO yka_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Saguwaˈ pagkite meˈ tatungguˈ likusin anakne miyaˈan, magisun siye. Paˈinde, ‘Iye hep inin pinusakaˈanin. Dayiˈ kaˈam, papateyte bi duk likus inin tepe si kite bi.’ ");
INSERT INTO yka_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Manjari siniggew iye weˈ de, ubus bu pinapatey duk ilakasan weˈ de pī si bukut birang likusin. ");
INSERT INTO yka_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Na,” paˈin si Isa, “ine enteˈ hinang dapuˈ likus miyaˈan si meˈ tatungguˈ likusnen? Hap pī iye duk papateyne siye duk patungguˈanne likusnen si seddili.” ");
INSERT INTO yka_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tinilew siye weˈ si Isa, paˈinne, “Gaˈ ke bakas tabatsabi ayat inin tasulat dem kitab, pinaˈin, ‘Batu tinayikutan weˈ meˈ pandey maghinang lumaˈ batuhin, peggeˈ kannalde gaˈi taguna, kuweˈitu iye ne miyaˈan batu tamanan maniyaˈ kagunahannen. ");
INSERT INTO yka_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hinangan Tuhanin inin, duk landuˈ teˈed hāp!’” ");
INSERT INTO yka_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Manjari, meˈ nakuraˈ meˈ Yahudi miyaˈan batang ne siggewde si Isa, peggeˈ tahātide weˈ siye inandiganne si dalilan sabab likus miyaˈan. Saguwaˈ gaˈ iye siggewde peggeˈ talew siye si meˈ aˈa mabanesin. Hangkan inambanan iye weˈ de duk tahalaˈ ne siye. ");
INSERT INTO yka_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Niyaˈ dinaˈak weˈ de meˈ Pariseo duk meˈ tindeg Sultan Herod pī pu si Isa nguhi-nguhi iye si meˈ bissānen. ");
INSERT INTO yka_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pagtekkade laˈi pu si Isa, paˈinde si iye, “Tuwan, kataˈuhan kami weˈ bennal hadja meˈ binissānun duk gaˈi kew suse bisan ine tapikil aˈa si kaˈuhin, bisan pe siye meˈ aˈa taga kapatut. Duk bennal meˈ panoloˈnu sabab meˈ kabayaˈan Tuhan hininang manusiyaˈin. Akahanun kami,” paˈinde, “patuhut ke si saraˈte bi magbayed sukey si Sultan Nakuraˈ bangsa Romahin atawa gaˈi?” ");
INSERT INTO yka_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Saguwaˈ kataˈuhan si Isa pangakkalden. Paˈinne si siye, “Weˈey ku suleyanbi? Moˈo kaˈam pitu sīn tuwas duk tapayamanku.” ");
INSERT INTO yka_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Manjari binoˈohan ne weˈ de si Isa. Paˈinne si siye, “Pattaˈ sine teˈ duk sulat sine si sīn inin?” Paˈinde, “Pattaˈ Sultan Nakuraˈin duk sulatnen.” ");
INSERT INTO yka_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“Na,” paˈin si Isa si siye, “pangurungun bi si Sultan Nakuraˈin sukuˈ si iyehin, duk pangurungun bi si Tuhan sukuˈ si Tuhanin. (Hātinen, magbayed kaˈam sukey duk pangurungun bi dibin dambūs-būs si Tuhan.)” Manjari ulaliˈ teˈed siye si iye. ");
INSERT INTO yka_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Puwas miyaˈan niyaˈ pī pu si Isa meˈ Sadduseo, meˈ Yahudi gaˈi kahagad weˈ ellum balik meˈ pateyin si ellew dambuli. Tinilew iye weˈ de, paˈinde, ");
INSERT INTO yka_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tuwan, niyaˈ saraˈ pangurung Musa kite bi weˈ bang niyaˈ lella bu matey iye gaˈ niyaˈ anakne, subey ne maganda salinen si balu miyaˈan duk niyaˈ tubuˈ sakanen. ");
INSERT INTO yka_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na manjari, niyaˈ miyaˈan pituˈ lella magpungtinaˈi. Sakahin maganda, manjari matey iye gaˈ anakde. ");
INSERT INTO yka_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mapasunuˈin maganda si baluhin duk matey iye gaˈ du isab niyaˈ anakde. Damikkiyan du isab mapasunuˈ si iyehin. ");
INSERT INTO yka_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kapituˈ magpungtinaˈihin maggantiˈ nganda baluhin duk matey siye gaˈ niyaˈ anakde ambanande. Si kakapusannen, matey isab dendehin. ");
INSERT INTO yka_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, Tuwan,” paˈinde, “si ellew pagellum balik meˈ pateyin, anda sine iye? Bu pituˈ magpungtinaˈihin makaˈanda iye.” ");
INSERT INTO yka_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sambungan si Isa siye, paˈinne, “Salaˈ kaˈam. Hangkan kaˈam salaˈ, peggeˈ gaˈi tasabutbi tasulat dem kitabin duk gaˈi isab kataˈuhanbi balakat Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Peggeˈ bang ellum ne balik meˈ pateyin,” paˈin si Isa, “kuweˈ ne siye meˈ malaˈikat si surgaˈin. Gaˈi ne siye maganda atawa magella. ");
INSERT INTO yka_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na, pasal meˈ aˈa matey weˈ pinakellum balik, gaˈ ke bakas tabatsabi dem kitab Tawrat sabab poˈon puhung makayatin? Tasulat laˈi weˈ missā Tuhanin pu si Musa. Paˈin Tuhanin, ‘Aku Tuhan pagtuhanan disi Ibrahim duk si Isahak duk si Yakubin.’ ");
INSERT INTO yka_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tuhanin Tuhan meˈ maˈellumin dumaˈin Tuhan meˈ pateyin. (Hātinen weˈ bisan disi Ibrahim duk Isahak duk si Yakub tiggel ne matey, ellum siye laˈi si surgaˈ peggeˈ inisbat pe weˈ de Tuhanin.) Salaˈ teˈed kaˈam si pamikilbin.” ");
INSERT INTO yka_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Manjari niyaˈ guru si saraˈ āgama nengge-nengge laˈi duk takalene pagpasuweyanden. Pagtapandogane weˈ hāp panambung si Isa siyehin, patapit iye pī nilew si Isa. “Tuwan,” paˈinne, “inggehin daˈakan malangkew amban kēmonin?” ");
INSERT INTO yka_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nambung si Isa, paˈinne, “Daˈakan malangkew amban kēmonin inin: ‘Meˈ aˈa bangsa Israˈil, pakale kaˈam. Tuhanin, Panuhutanten bi dambuwaˈ-buwaˈ iye Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Subey kalasahannu Tuhanin, Panuhutannun, dambūs-būs ateynun duk pikilannun duk basagnun.’ Iye inin,” paˈin si Isa, “daˈakan malangkew amban kēmonin. ");
INSERT INTO yka_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Duk daˈakan mapasunuˈin inin: ‘Subey kalasahannu saweˈnun kuweˈ pangalasanu dinun.’ Gaˈ niyaˈ palangkew daˈakan amban daˈakan duwe inin.” ");
INSERT INTO yka_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Paˈin guru saraˈin pu si Isa, “Tumuˈun iyan, Tuwan. Bennal binissānun weˈ dambuwaˈ-buwaˈ du Tuhanin duk gaˈ niyaˈ seddili amban iye. ");
INSERT INTO yka_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Duk subey aˈahin kalasahanne Tuhanin dambūs-būs ateynen duk pikilannen duk basagnen. Duk subey isab kalasahanne pagkasinen kuweˈ pangalasane dinen. Bang tuhutne inin, hāp pe teˈed inin amban magkuluban iye hayep ineggas atawa nōngan ine-ine si Tuhan.” ");
INSERT INTO yka_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pagtapandoga si Isa weˈ lalem pikilannen peggeˈ patut teˈed panambungnen, paˈinne si iye, “Bang pasōngnu pamikilnu iyan, mura kew pagbayaˈan Tuhanin.” Puwas miyaˈan, gaˈ ne niyaˈ aˈa makatawakkal nilew si Isa ine-ine. ");
INSERT INTO yka_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Manjari, sābu si Isa magusihat dem langgal hadje, tilewne siye, paˈinne, “Weˈey meˈ guru si saraˈ āgamahin magpaˈin weˈ Almasihin tubuˈ Sultan Daˈud koˈ? ");
INSERT INTO yka_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Bu si Daˈud ne teˈed mamissāhin sābu pagbayaˈan iye weˈ Niyawa Sutsihin, paˈinne, ‘Missā Tuhanin si Panuhutankun. Paˈin Tuhanin, dayiˈ kew, ningkoloˈ kew tuˈu si kanawananku, tuˈu si paningkoloˈan mabangsahanin. Bettadku du meˈ bantanun diyawaˈ pat bettisnu.’ ");
INSERT INTO yka_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na, payamanun bi,” paˈin si Isa, “bang si Daˈud pangēnne Almasihin Panuhutanne, bugtuˈ dumaˈin hadja iye tubuˈne saguwaˈ langkew pe iye amban si Daˈud.” Meˈ aˈa mabanesin kēgan pakale si meˈ usihat si Isahin. ");
INSERT INTO yka_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Manjari sābu magusihat pe si Isa, paˈinne, “Paghalliˈ-halliˈanun bi meˈ guru si saraˈ āgamahin. Sinna siye lumengngan magsemmek tahaˈ duk sinna siye sinalam si meˈ tabuˈan. ");
INSERT INTO yka_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bang dem langgal, mabayaˈ siye ningkoloˈ si meˈ paningkoloˈan para si meˈ aˈa pinagaddatanin. Damikkiyan bang siye si meˈ pagjamu-jamuhan, kabayaˈanden ningkoloˈ si meˈ paningkoloˈan mabangsahanin. ");
INSERT INTO yka_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Saguwaˈ siye,” paˈin si Isa, “sinigpitan weˈ de meˈ dende baluhin supaya taˈeddoˈde meˈ lumaˈden, duk magsambahayang siye patahaˈ magmā-mā weˈ aˈa hāp siye. Bugtuˈ hukuman hadje tasangkaden si ahilat.” ");
INSERT INTO yka_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Manjari ningkoloˈ si Isa paharap si pangisi-ngisihan sīn dem langgal hadjehin. Pinayam-payaman weˈ ne meˈ aˈahin ngalaboˈ sīn dem pangisi-ngisihanin. Ekka meˈ aˈa dayahan ngalaboˈ sīn ekka. ");
INSERT INTO yka_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Manjari niyaˈ tekka pī dambuwaˈ dende balu, miskin teˈed. Ngalaboˈ iye duwek kayuˈ sīn peyat, kulang du halgaˈnen. ");
INSERT INTO yka_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Manjari ilinganan weˈ si Isa meˈ tindegnen pī patapit si iye. Paˈinne si siye, “Sabennal akahante kaˈam, dende balu mamiskin inin, labi pe sīn talaboˈnen amban kēmon siye meˈ mangalaboˈ sīnin. ");
INSERT INTO yka_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Peggeˈ siye kēmon,” paˈin si Isa, “ngurung siye amban alataˈde maglabi-labihin. Saguwaˈ dende inin, bisan iye miskin, pinangurung weˈ ne kēmon sīnnen bisan diddaˈ panabangne sukalnen.” ");
INSERT INTO yka_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Manjari sābu si Isa paluwas amban langgal mahadjehin, dambuwaˈ meˈ tindegnen nambat, paˈinne, “Uy, Tuwan. Makasinna-sinna pahāp meˈ batu hinang langgal inin. Asal hāp teˈed bantuk langgal inin.” ");
INSERT INTO yka_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Paˈin si Isa si siye, “Langga1 mahadje inin ujud hebbaˈ du. Niyaˈ ellew si pasōngan, gaˈ du iyan niyaˈ ta1ebbi tuˈu meˈ batu magbangkat-bangkat iyan, saguwaˈ kēmon kinanat-kanat du.” ");
INSERT INTO yka_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Manjari sasang si Isa ningkoloˈ si kūd Jaitun paharap tudju langgal hadjehin, hap pī si iye si Petros duk si Yakub duk Yahiya duk Andariyas, siye-siye hadja. ");
INSERT INTO yka_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Tinilew si Isa weˈ de, paˈinde, “Akahanun kami, sumiyan umantag meˈ pinaˈinnu miyaˈan? Ine tandaˈ mapaguwaˈin bang sōng ne umantag meˈ kēmon miyaˈan?” ");
INSERT INTO yka_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Paˈin si Isa si siye, “Pahatul-hatul kaˈam duk kaˈam gaˈi kaˈakkalan. ");
INSERT INTO yka_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Peggeˈ ekka iyan pitu magēnan ēnkun duk magpaˈin weˈ siye ne Almasihin. Duk ekka iyan kaˈakkalande. ");
INSERT INTO yka_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Duk bang kaˈam makakale sabab magbonoˈ dem lahat, atawa suwi-suwi sabab magbonoˈ si meˈ lahat tala, daˈa kaˈam tinalew. Kēmon inin subey umantag saguwaˈ dumaˈin pe inin ellew kiyamat. ");
INSERT INTO yka_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Peggeˈ dambuwaˈ bangsa,” paˈin si Isa, “magbonoˈ iyan duk bangsa seddili. Duk dambuwaˈ pagsultanan magbonoˈ iyan duk pagsultanan seddili. Duk niyaˈ iyan meˈ linug si meˈ kalahat-lahatan si dunya duk niyaˈ unus si meˈ kalahatan. Saguwaˈ inin panagnaˈan meˈ katiksaˈan si dunyahin hadja. Kēmon inin, dalil dende sōng nganak duk nagnaˈ peddiˈan ne. ");
INSERT INTO yka_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Subey kaˈam pahatul-hatul si dibi,” paˈin si Isa. “Peggeˈ sōngan meˈ aˈa du kaˈam iyan si meˈ hukum duk paglubakande kaˈam dem meˈ langgal. Niyaˈ ellew si pasōngan, nengge du isab kaˈam iyan si harapan meˈ gubnul duk meˈ sultan peggeˈ nuhut kaˈam aku duk taˈakabi ne si siye aka-aka mahāp sabab akuhin. ");
INSERT INTO yka_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Peggeˈ meke kiyamat dunyahin, subey dahuˈ aka-aka mahāpin pinasampay si kēmon kabangsa-bangsahan,” paˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Na, bang kaˈam siniggew duk boˈode binistiga, daˈa kaˈam magsuse andang bang ine binissābin pamēbbegbi dibin. Saguwaˈ bissāhun bi ine-ine pangurung si kaˈam si waktu miyaˈan, peggeˈ dumaˈin amban kaˈam binissābin saguwaˈ amban Niyawa Sutsihin. ");
INSERT INTO yka_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Si pasōngan,” paˈinne, “niyaˈ iyan meˈ aˈa, sōngan meˈ pungtinaˈiden siye dinaˈak pinapatey. Niyaˈ isab iyan meˈ anak, sōngan samaden siye dinaˈak pinapatey. Duk meˈ anakin bantahande matettoˈaden duk daˈakde matettoˈaden pinapatey. ");
INSERT INTO yka_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Duk kaˈam meˈ tindegkun,” paˈin si Isa, “kabunsihan du kaˈam weˈ kēmon aˈa peggeˈ nuhut kaˈam aku. Saguwaˈ sine-sine nandal sampay si tamanan kabinasahan inin, taga umul du si surgaˈ gaˈ niyaˈ tamananne.” ");
INSERT INTO yka_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Na, si pasōngan, niyaˈ iyan takitebi makapagkaˈat duk ngandiyawaˈan Tuhanin laˈi si antag gaˈi patut palaˈihannen. Bang takitebi inin subey ne meˈ aˈa malaˈi si Yahudiyahin lahi pī si meˈ kapunuhan. (Ambat mamatsa inin sabutanne.) ");
INSERT INTO yka_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Duk bang niyaˈ aˈa si luwasan lumaˈne, subey ne iye gaˈi padiyalem ngeddoˈ ine-ine, saguwaˈ subey ne iye lahi. ");
INSERT INTO yka_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Duk malaˈi si tanaˈnen subey ne gaˈi balik pī si lumaˈne ngeddoˈ meˈ semmeknen. ");
INSERT INTO yka_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Andūˈ, makaˈaseˈ-aseˈ meˈ mabettengin duk meˈ maganak dikiˈin laˈi si meˈ ellew īˈ. ");
INSERT INTO yka_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Māku-māku kaˈam si Tuhan karayaw gaˈi du inin umantag si tempo gaˈi hap lahatin. ");
INSERT INTO yka_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Peggeˈ si meˈ ellew īˈ,” paˈin si Isa, “niyaˈ iyan katiksaˈan hadje, gaˈ niyaˈ saliˈne kemuwe tagnaˈ pinapanjari weˈ Tuhanin dunyahin sampay kuweˈitu. Duk puwas inin, gaˈi ne teˈed kabalikan. ");
INSERT INTO yka_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Duk bang gaˈi kulangan Tuhanin meˈ ellew katiksaˈan īˈ,” paˈin si Isa, “gaˈ niyaˈ aˈa ellum. Saguwaˈ sabab meˈ aˈa tapeneˈnen, meˈ aˈa manuhut iyehin, kulangan Tuhanin du meˈ ellew īˈ. ");
INSERT INTO yka_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Duk bang niyaˈ si ellew īˈ magpaˈin si kaˈam, ‘O, payamanun bi, tiyaˈ Almasihin!’ atawa ‘Payamanun bi, īˈ iye laˈi!’ - daˈa teˈed kahagadun bi. ");
INSERT INTO yka_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Peggeˈ si meˈ ellew īˈ, niyaˈ iyan paguwaˈ meˈ aˈa magpaˈin weˈ Almasihin siye bu gaˈi bennal. Niyaˈ isab iyan meˈ aˈa magpaˈin weˈ nabi siye bu gaˈi toˈo. Duk magpakite siye iyan meˈ tandaˈ duk meˈ hinangan makaˈulaliˈ supaya bang makajari, taboˈode pasapeˈ meˈ aˈa tapeneˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Saguwaˈ subey kaˈam papateng-pateng,” paˈin si Isa. “Bakas ne kaˈam akahanku andang sabab meˈ inin pādpād gaˈ pe umantag.” ");
INSERT INTO yka_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Manjari si meˈ ellew īˈ,” paˈin si Isa, “pagubus meˈ katiksaˈan miyaˈan, ngalindem mata ellewin, duk bulanin gaˈi ne dantaˈ. ");
INSERT INTO yka_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Meˈ poteˈanin magkalaboˈ-laboˈ amban diyataˈ langit duk meˈ bayuˈan diyataˈ langitin tahalaˈ amban lugalden. ");
INSERT INTO yka_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Manjari pagubus inin, kitede du ku, Anak Manusiyaˈin, pitu dem inalak. Takite meˈ aˈahin du sahayakun duk balakatku mahadjehin. ");
INSERT INTO yka_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Duk daˈakku du pitu meˈ malaˈikatin nipun meˈ aˈa tapeneˈkun amban kaˈampat pidjū alamin.” ");
INSERT INTO yka_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Pandogahanun bi kayu igirahin,” paˈin si Isa. “Bang numbuˈ meˈ dawennen, kataˈuhanbi weˈ sōng baytu panas ne. ");
INSERT INTO yka_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Damikkiyan isab, bang takitebi umantag ne meˈ pinaˈinku miyaˈan, kataˈuhanbi weˈ asal tapit ne teˈed pabalikkun. ");
INSERT INTO yka_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sabennal akahante kaˈam,” paˈin si Isa, “gaˈi pe ubus matey kēmon aˈa maˈellum kuweˈitu inin, tekka ne meˈ bakas pinaˈinku inin. ");
INSERT INTO yka_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Palabey hadja langitin duk dunyahin, saguwaˈ bang bissākun asal gaˈi usaˈ.” ");
INSERT INTO yka_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Saguwaˈ gaˈ niyaˈ ngataˈu bang ellew ine atawa waktu ine papituku balik si pasōnganin. Bisan meˈ malaˈikat si surgaˈin gaˈi kataˈuhande. Bisan aku, Anak Tuhanin, gaˈi du isab kataˈuhanku. Luwal Samaku Tuhanin mangataˈuhin. ");
INSERT INTO yka_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hangkan papateng-pateng kaˈam,” paˈin si Isa. “Daˈa kaˈam lipat peggeˈ gaˈi kataˈuhanbi bang sumiyan inin umantag. ");
INSERT INTO yka_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dalilne inin, dambuwaˈ aˈa lumengngan hap lahat seddili. Sōng patahalaˈnen, pinangandel weˈ ne lumaˈnen si meˈ daraˈakannen. Inurungan siye dangan-dangan hinangden. Duk tungguˈ gawangin daˈakne gaˈi lipat. ");
INSERT INTO yka_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hangkan hep,” paˈin si Isa, “daˈa kaˈam lipat peggeˈ gaˈi kataˈuhanbi bang sumiyan tekka dapuˈ lumaˈin. Bang magalib ke, atawa tengaˈ bahangi ke, atawa dayiˈ ellew ke, atawa salung ke. ");
INSERT INTO yka_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Peggeˈ kaw iye bessuwang tekka duk tasaˈutne kaˈam tuli. ");
INSERT INTO yka_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na, pinaˈinku si kaˈam inin, paˈinku isab si kēmon aˈa: Daˈa teˈed kaˈam lipat.” ");
INSERT INTO yka_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na, duwem bahangi pe meke pagkādjaˈan ēnande Kādjaˈan Pangessebanin duk kādjaˈan pagkakande pan gaˈi sinagetan pasuligin. Meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin, pinikil-pikil weˈ de bang saˈingge paniggewde duk pamapateyde si Isahin duk gaˈi kataˈuhan meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Daˈa bang baytu kādjaˈan inin,” paˈinde, “kaw hewuhalaˈ meˈ aˈahin.” ");
INSERT INTO yka_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na, laˈi si Isa si Betani. Laˈi iye mangan si lumaˈ si Simon, aˈa bakas inipulin. Manjari sasangde mamanganin, niyaˈ dende tekka pī magboˈo isellan bengngi. Pangisihannen batu alabaster hininangin. Isellan bengngi miyaˈan inēnan narda, gaˈ lamud-lamudne duk mahalgaˈ teˈed. Manjari pinessaˈ weˈ dendehin pangisihan isellan bengngihin duk binuˈusan weˈ ne isellanin diyataˈ kōk si Isa. ");
INSERT INTO yka_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Saguwaˈ niyaˈ meˈ aˈa malaˈihin astel duk magbissā-bissā siye. “Weˈey isellan bengngi miyaˈan pinakaˈatan sa miyaˈan?” paˈinde. ");
INSERT INTO yka_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“Gam pe miyaˈan pinabellihan labi tellu hatus pilak duk ulinen pangurung si meˈ mamiskinin.” Hangkan inamāhan teˈed weˈ de dendehin. ");
INSERT INTO yka_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Saguwaˈ paˈin si Isa si siye, “Pasagadanun bi iye. Weˈey iye sasewbi? Hāp hininangne si aku inin. ");
INSERT INTO yka_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Peggeˈ mamiskinin,” paˈin si Isa, “gaˈi du usaˈ amban kaˈam, duk sumiyan-sumiyan kaˈam mabayaˈ, kapanabang kaˈam si siye. Saguwaˈ aku, gaˈi ku teteg tuˈu si kaˈam. ");
INSERT INTO yka_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dende inin, hininang weˈ ne tageˈesnen. Inisellanan weˈ ne andang barankun panyap pangubul akuhin. ");
INSERT INTO yka_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Duk sabennal akahante kaˈam,” paˈin si Isa, “antag-antag si tibuˈukan dunya minahalayak aka-aka mahāpin, inaka-aka du isab tahinang dende si aku inin, pangesseb-ngesseban meˈ aˈahin iye.” ");
INSERT INTO yka_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Manjari pagubus miyaˈan, si Judas Iskariyot, dambuwaˈ si meˈ tindeg si Isa sampūˈ duk duwehin, hap pī si meˈ nakuraˈ meˈ imamin supaya tabuddihanne si Isa duk tasōnganne si siye. ");
INSERT INTO yka_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na, pagkalede pinaˈin si Judasin, sinna teˈed siye duk nanggup siye ngurungan iye sīn. Manjari puwas miyaˈan, miha ne si Judas waktu hāp panōngne si Isa si siye. ");
INSERT INTO yka_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na, taˈabut ne tagnaˈ ellew kādjaˈanin pagkakande pan gaˈi sinagetan pasuligin. Ellew miyaˈan subey meˈ aˈahin numbaliˈ anak bili-bili kakande pangessebande pamaluwas Tuhan bangsaden amban kamatey laˈi si lahat Misil awwalley. Tinilew si Isa weˈ meˈ tindegnen, paˈinde, “Tuwan, antag kami kabayaˈannu pī manyapan kaˈu pamanganannu pagkādjaˈan inin?” ");
INSERT INTO yka_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dinaˈak weˈ si Isa meˈ tindegnen duwangan duk paˈinne si siye, “Pī kaˈam dem puweblo miyaˈan. Niyaˈ iyan aˈa tasampangbi laˈi magboˈo komboˈ isihan boheˈ. Nuhut kaˈam iye. ");
INSERT INTO yka_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Duk bang ne iye paˈasek dem lumaˈ, paˈinun bi si dapuˈ lumaˈ miyaˈan, ‘Dinaˈak kew tinilew weˈ guruhin bang antag koˈ bilik pagjamu-jamuhanne duk meˈ tindegnen para si Kādjaˈan Pangessebanin.’ ");
INSERT INTO yka_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Manjari niyaˈ iyan pakitehanne kaˈam bilik luha laˈi diyataˈ lumaˈ,” paˈin si Isa. “Andang ne panyap bilik miyaˈan. Laˈi ne kaˈam maghatul kinakanten bi.” ");
INSERT INTO yka_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Manjari lumengngan ne meˈ tindegne duwanganin pī si puweblo duk takitede laˈi sa pangaka si Isa siyehin. Duk maghatul ne siye laˈi para si pagjamu-jamuhan Pangessebanin. ");
INSERT INTO yka_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pagsangem ne, hap pī ne si Isa si lumaˈ miyaˈan magtuhut duk tindegne sampūˈ duk duwehin. ");
INSERT INTO yka_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sasangde ningkoloˈ si lamisahan magkakan, paˈin si Isa si meˈ tindegnen, “Sabennal akahante kaˈam, niyaˈ dangan si kaˈam muddihan aku, saweˈku magtuhut mangan.” ");
INSERT INTO yka_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Magtawus siye dukka duk maggantiˈ siye nilew iye. Paˈin dangan-dangan, “Bugtuˈ dumaˈin aku, Tuwan, ēˈ?” ");
INSERT INTO yka_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nambung si Isa, paˈinne, “Mamuddihan akuhin dangan kaˈam duk magsawu kami mangan si dambuwaˈ pinggan. ");
INSERT INTO yka_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aku inin, Anak Manusiyaˈin,” paˈin si Isa, “matey du ku peggeˈ iye iyan gantaˈankun sa sinulat dem kitabin. Saguwaˈ makaˈaseˈ-aseˈ teˈed aˈa mamuddihan Anak Manusiyaˈin. Gam pe aˈa miyaˈan gaˈ inanakan.” ");
INSERT INTO yka_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sasangde mamanganin, ngeddoˈ si Isa pan duk pagubus iye magpasalamat si Tuhan, kinepak-kepak weˈ ne bu pinangurung weˈ ne si siye. Paˈinne, “Ngeddoˈ kaˈam. Pan inin barankun.” ");
INSERT INTO yka_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Manjari ngeddoˈ iye sawan duk pagubus iye magpasalamat si Tuhan, pinangurung weˈ ne si siye duk nginum siye kēmon. ");
INSERT INTO yka_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Paˈin si Isa si siye, “Inin lahaˈkun sōng buˈus sabab meˈ aˈa ekka. Inin tandaˈ weˈ tumanan Tuhanin du janjiˈnen. ");
INSERT INTO yka_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sabennal akahante kaˈam, puwas inin gaˈi ne ku nginum boheˈ ubas balik samantaˈan gaˈi pe ku nginum ininum baˈahuhin dem pagbayaˈan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Manjari ngalang siye dambuwaˈ kalangan pamudji Tuhan, ubus bu paluwas ne siye pī si kūd Jaitun. ");
INSERT INTO yka_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Paˈin si Isa si siye, “Kēmon kaˈam, ambananbi du ku. Peggeˈ tasulat inin dem kitab, pinaˈin, ‘Daˈakku pinapatey magbantey bili-bilihin, manjari meˈ bili-bilinen magkanat-kanat.’ ");
INSERT INTO yka_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Saguwaˈ pagellum ne ku balik, magkasuwaˈ du kite bi. Padehellu ku amban kaˈam pī si lahat Jalil.” ");
INSERT INTO yka_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Manjari paˈin si Petros si iye, “Bisan kēmon siye ngambanan kaˈu, Tuwan, saguwaˈ aku, asal gaˈi kew ambananku.” ");
INSERT INTO yka_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Paˈin si Isa si iye, “Sabennal akahante kew, sangem inin du, gaˈi pe manukin makatingkowak minduwe, kapamasuwey ne kew mintellu weˈ gaˈi ku kataˈuhannu.” ");
INSERT INTO yka_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Saguwaˈ pasōng si Petros missā pinamuwakkad, paˈinne, “Bisan pe ku matey patuhut si kaˈu, asal gaˈi kew teˈed pasuweyanku.” Duk kēmon siye, inin isab binissāden. ");
INSERT INTO yka_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Manjari palanjal siye pī si kabbun inēnan Getsemane. Paˈin si Isa si meˈ tindegnen, “Ningkoloˈ kaˈam tuˈu tiggelanku laˈi māku-māku si Tuhan.” ");
INSERT INTO yka_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Duk binoˈo weˈ ne si Petros duk si Yakub duk si Yahiya. Nagnaˈ iye kebba-kebbahan duk sasew dem ateynen. ");
INSERT INTO yka_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Manjari paˈinne si siye, “Ateykun dukka teˈed, agen-agen makamatey aku. Paˈamban ne kaˈam tuˈu duk magjaga kaˈam.” ");
INSERT INTO yka_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Manjari lumengngan iye patala-tala duk pasujud iye diyataˈ bulak duk ngampun iye si Tuhan weˈ bang makajari gaˈi pinaˈantag si iye kabinasahan sōng matekka si iyehin. ");
INSERT INTO yka_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Duk paˈinne, “O Ammaˈ, kēmon tahinangnu. Bang kew mabayaˈ daˈa ku pasagadanun bininasa. Saguwaˈ dumaˈin tinuhutin kinabayaˈankun, saguwaˈ kinabayaˈannun.” ");
INSERT INTO yka_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Manjari balik iye pī si meˈ tindegnen duk takitene siye kapatuli. Paˈinne pu si Petros, “O, Simon, tuli kew? Gaˈi kew kapagjaga bisan da ora? ");
INSERT INTO yka_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Papateng-pateng kaˈam duk māku-māku kaˈam si Tuhan supaya kaˈam gaˈi taboˈo weˈ sassat. Tapikil weˈ atey saguwaˈ gaˈi kaˈanggawtaˈan weˈ baran.” ");
INSERT INTO yka_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Manjari tahalaˈ ne isab si Isa duk māku-māku iye, binalik weˈ ne bakas binissāne si Samanen. ");
INSERT INTO yka_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ubus balik ne isab iye pī si meˈ tindegnen duk takitene siye kapatuli peggeˈ kinaruˈ teˈed siye. Gaˈi kataˈuhande bang ine panambungde si Isahin. ");
INSERT INTO yka_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pagbalik si Isa kamintellunen, paˈinne si siye, “Tuli pe kaˈam duk pahali pe? Sarang ne iyan. Tekka ne waktuhin. Aku, Anak Manusiyaˈin, sōng sinōngan ne si antanan meˈ aˈa dusehan. ");
INSERT INTO yka_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kuwat kaˈam, sūng ne kite bi. Payamanun bi, tiyaˈ ne aˈa mamuddihan akuhin.” ");
INSERT INTO yka_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Manjari sasang si Isa pe mamissāhin, tekka si Judas. Dambuwaˈ iye si meˈ sampūˈ duk duwe tindeg si Isahin. Banes teˈed aˈa nuhut si Judas magbarung duk magboˈo meˈ kakakal. Siye miyaˈan dinaˈak pī weˈ meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin duk meˈ kabahiˈanin. ");
INSERT INTO yka_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kaˈurungan siye indan weˈ si Judas. Bakas paˈinne hep si siye, “Sine-sine ūkku, iye ne iyan aˈahin. Siggewun bi iye duk boˈohun bi tahalaˈ duk banteyanun bi pinahāp-hāp.” ");
INSERT INTO yka_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Manjari pagtekkade laˈi, magtawus si Judas patapit pu si Isa duk paˈinne, “Tuwan.” Bu inūk si Isa weˈ ne. ");
INSERT INTO yka_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Manjari siniggew ne si Isa weˈ de duk inantan weˈ de pahaget. ");
INSERT INTO yka_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Saguwaˈ niyaˈ dambuwaˈ meˈ magtengge matapitin, ngurus barungnen duk pineddang weˈ ne daraˈakan imam nakuraˈin, duk butas tayingenen. ");
INSERT INTO yka_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Manjari paˈin si Isa si meˈ maniggew iyehin, “Weˈ kannalbi mundu ku hangkan kaˈam pitu niggew aku magbarung duk magboˈo meˈ kakakal? ");
INSERT INTO yka_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ellew-ellew laˈi ku magusihat dem langgal hadje. Laˈi du kaˈam saguwaˈ gaˈ ku siggewbi laˈi. Saguwaˈ,” paˈinne, “subey katumanan kēmon tasulat dem kitabin.” ");
INSERT INTO yka_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Manjari kēmon tindeg si Isahin nayikutan iye duk lahi siye. ");
INSERT INTO yka_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Manjari niyaˈ isab laˈi dambuwaˈ subul patuhut pu si Isa. Magdikat hadja iye. Sōng isab iye siniggew weˈ de. ");
INSERT INTO yka_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Saguwaˈ inambanan weˈ ne dikatnen duk magubas iye magkuwantang. ");
INSERT INTO yka_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Manjari binoˈo weˈ de si Isa pī si lumaˈ imam nakuraˈin. Duk magtipun isab laˈi kēmon nakuraˈ imamin duk meˈ kabahiˈanin duk meˈ guru si saraˈ āgamahin. ");
INSERT INTO yka_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na, si Petros paturul pu si Isa saguwaˈ patala-tala, sampay pī diyalem lame lumaˈ imam nakuraˈin. Ningkoloˈ iye duk meˈ guwaldiyahin si bihing ebbut ngindāng. ");
INSERT INTO yka_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Manjari meˈ nakuraˈ imamin duk meˈ kakunsihalanin miha pureba panuntutande si Isa supaya iye tapapateyde. Saguwaˈ gaˈ niyaˈ kasuwaˈde panuntutande iye. ");
INSERT INTO yka_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ekka naksiˈ kuntara pu si Isa saguwaˈ gaˈi bennal duk gaˈi maguyun meˈ bissāden. ");
INSERT INTO yka_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ubus niyaˈ sinduwe kuwat naksiˈ kuntara pu si Isa gaˈi du isab bennal. ");
INSERT INTO yka_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Paˈinde, “Bakas takale kami aˈa inin magpaˈin weˈ larakne koˈ langgal mahadjehin, hininang weˈ manusiyaˈ, duk dem tellu ellew matengge koˈ iye seddili saguwaˈ dumaˈin aˈa mangahinang iyehin.” ");
INSERT INTO yka_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Saguwaˈ bisan pe kuweˈ miyaˈan panaksiˈden, gaˈ du maguyun meˈ bissāden. ");
INSERT INTO yka_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Manjari nengge imam nakuraˈin laˈi si tengngaˈde nilew si Isa. Paˈinne, “Gaˈ niyaˈ sambungnu si meˈ tuntutde si kaˈu inin?” ");
INSERT INTO yka_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Saguwaˈ gaˈ si Isa nambung. Manjari tinilew iye balik weˈ iman nakuraˈin, paˈinne, “Kaˈu ne ke Almasihin, Anak Tuhanin?” ");
INSERT INTO yka_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Aku ne,” sambung si Isahin. “Duk kitebi du ku iyan, aku, Anak Manusiyaˈin, ningkoloˈ si kanawanan Tuhan Mabalakatanin. Duk kitebi du ku iyan pitu magtuhut duk meˈ inalak amban diyataˈ langit.” ");
INSERT INTO yka_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Manjari ginaret weˈ imam nakuraˈin semmeknen hawal peddiˈ ateynen. Duk paˈinne, “Weˈey pe kite bi subey miha meˈ saksiˈ? ");
INSERT INTO yka_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Takalebi ne binissāne miyaˈan, kuweˈ Tuhanin iye. Ine hukumanbin?” Paˈinde kēmon, “Hukuman kamihin weˈ subey iye pinapatey.” ");
INSERT INTO yka_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Manjari sinduwe meˈ aˈahin nagnaˈ ngaluraˈan iye. Binennesan isab weˈ de luwenen duk pinagsuntukan iye weˈ de. Paˈinde si iye, “Na, untukun koˈ, sine manuntuk kaˈuhin.” Duk sinampak isab iye weˈ meˈ guwaldiyahin pangeddoˈde iyehin. ");
INSERT INTO yka_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Manjari sasang si Petros laˈi si lame, niyaˈ dambuwaˈ dende daraˈakan imam nakuraˈin hap pī laˈi. ");
INSERT INTO yka_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagkitene si Petros ngindāng, dinendengan teˈed iye weˈ ne duk paˈinne, “Oy, kaˈu isab bakas saweˈ aˈa Nasaret miyaˈan, si Isa.” ");
INSERT INTO yka_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Saguwaˈ masuwey si Petros, paˈinne, “Gaˈi kataˈuhanku duk gaˈi tasabutku bang ine binissānu iyan.” Duk magtawus iye tahalaˈ tudju tarangka. Manjari ningkowak manukin. ");
INSERT INTO yka_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Takite ne isab iye balik weˈ dende daraˈakan miyaˈan duk paˈin dendehin si meˈ aˈa magtengge malaˈihin, “Aˈa miyaˈan saweˈde isab.” ");
INSERT INTO yka_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Saguwaˈ masuwey ne isab si Petros. Gaˈ du tiggel, meˈ aˈa magtengge malaˈihin magpaˈin pu si Petros, “Gaˈi kew kapamasuwey weˈ dumaˈin kew saweˈde peggeˈ aˈa Jalil du kew isab.” ");
INSERT INTO yka_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Saguwaˈ nuknaˈan si Petros dinen duk napa iye. Paˈinne, “Asal gaˈi kataˈuhanku aˈa pagbissābi iyan.” ");
INSERT INTO yka_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Magtawus tingkowak manukin. Kaminduwenen ne inin. Manjari taˈesseb weˈ si Petros bakas pinaˈin si Isa si iyehin, “Gaˈi pe makatingkowak manukin minduwe, kapamasuwey ne kew mintellu weˈ gaˈi ku kataˈuhannu.” Sakaliˈ tapikil si Petros inin, magtangis iye. ");
INSERT INTO yka_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pagsakaliˈ ne salung, magtipun meˈ nakuraˈ imamin duk meˈ kabahiˈanin duk meˈ guru si saraˈ āgamahin. Siye meˈ kakunsihalan mangahukumin. Magisun siye bang inumeyde pu si Isahin. Manjari pagubus siye magisun, iningketan weˈ de si Isa duk binoˈo weˈ de pī sinōngan pu Pilatus. ");
INSERT INTO yka_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tilew Pilatus iye, paˈinne, “Sultan meˈ Yahudihin ke kew?” Nambung si Isa, paˈinne, “Iye du pinaˈinnu iyan.” ");
INSERT INTO yka_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na, ekka tuntut meˈ nakuraˈ imamin si iye. ");
INSERT INTO yka_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tinilew iye balik weˈ Pilatus, paˈinne, “Gaˈ niyaˈ panambungnu? Payamanun kaˈekka tuntutde si kaˈu.” ");
INSERT INTO yka_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Saguwaˈ gaˈ ne nambung si Isa, hangkan ulaliˈ teˈed Pilatus. ");
INSERT INTO yka_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na kahabaˈ tahun, bang baytu Kādjaˈan Pangesseban, iye addat Pilatusin maluwas iye dambuwaˈ pilisu, sine-sine pāku meˈ aˈahin pinaluwas. ");
INSERT INTO yka_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Masa miyaˈan, niyaˈ laˈi aˈa kinalabusu. Ēnnen Barabbas. Laˈi iye magtuhut duk meˈ saweˈne bakas manguntarahan gubelnohin duk makapapatey iye meˈ aˈa masa miyaˈan. ");
INSERT INTO yka_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ekka meˈ aˈa pī pu si Pilatus duk pināku weˈ de weˈ maluwas iye dambuwaˈ pilisu sa addat luwal hininangne tahun-tahunin. ");
INSERT INTO yka_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tinilew siye weˈ Pilatus, paˈinne, “Mabayaˈ kaˈam paluwasku si kaˈam Sultan meˈ Yahudihin?” ");
INSERT INTO yka_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hangkan siye tinilew weˈ ne sa miyaˈan peggeˈ kataˈuhanne weˈ sinōngan si Isa weˈ meˈ nakuraˈ imamin si iye, peggeˈ kinimbūhan si Isa weˈ de. ");
INSERT INTO yka_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Saguwaˈ meˈ aˈa mabanesin tasegeˈ weˈ meˈ nakuraˈ imamin weˈ subey pākude si Barabbas pinaluwasin, dumaˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Paˈin si Pilatus ne isab si siye, “Inumeyku si aˈa inēnanbi Sultan meˈ Yahudi inin?” ");
INSERT INTO yka_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Magkalolop siye, paˈinde, “Lansangun iye diyataˈ olom.” ");
INSERT INTO yka_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Paˈin Pilatus si siye, “Weˈey? Ine laˈat tahinangnen?” Saguwaˈ pasōng ne siye magkalolop, paˈinde, “Lansangun iye diyataˈ olom.” ");
INSERT INTO yka_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Manjari kabayaˈan Pilatusin weˈ duhulanne kabayaˈan meˈ aˈa mabanesin, hangkan pinaluwas weˈ ne Barabbas si siye. Duk pagubus si Isa daˈakne ilubakan, sinōngan ne iye weˈ Pilatus supaya iye talansang diyataˈ olom. ");
INSERT INTO yka_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Manjari binoˈo si Isa tahalaˈ weˈ meˈ sundaluhin pī si lame astanaˈ gubnulin. Duk ilinganan weˈ de patipun kēmon sundalu da kumpaniyahin. ");
INSERT INTO yka_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Manjari pinasemmekan weˈ de si Isa semmek taluk kuweˈ bantuk semmek sultan. Ubus ngalakal isab siye bāhan luhihan, hininang kuweˈ korona sultan, bu pinapī weˈ de si kōkne. ");
INSERT INTO yka_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Manjari magmā-mā pinahadje si Isa weˈ de, paˈinde, “Assalamu alaikum, Sultan meˈ Yahudihin.” ");
INSERT INTO yka_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pinaglubakan weˈ de kōk si Isahin duk kayu-kayu, duk pinagluraˈan iye weˈ de. Ubus pasujud siye si iye. ");
INSERT INTO yka_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pagubus iye hinangde dagey, iluwasan weˈ de semmek talukin bu pinasemmekan iye balik duk semmekne tagnaˈin. Ubus binoˈo ne iye weˈ de pabukut duk ne iye talansang diyataˈ olom. ");
INSERT INTO yka_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Manjari niyaˈ aˈa pabutas, ēnnen si Simon, aˈa amban lahat Kirene. Bakas amban lahat diyataˈ iye balik pī si puweblo. Si Simon inin sama Iskandal duk si Rupus. Ginagahan iye weˈ meˈ sundaluhin dinaˈak pinanangkit olom sōng pangalansangan si Isahin. ");
INSERT INTO yka_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Binoˈo weˈ de si Isa pī si lugal inēnan Golgota. Hāti ēn miyaˈan, “Lahatan Bungkug.” ");
INSERT INTO yka_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Paglaˈi ne si Isa, niyaˈ sōng pamaˈinumde iye boheˈ ubas sinagetan tambal inēnan mira. Saguwaˈ gaˈ tayimaˈne. ");
INSERT INTO yka_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Manjari ilansang ne iye weˈ de diyataˈ olom bu pinatengge weˈ de olomin. Pinagbahagiˈ-bahagiˈan weˈ meˈ sundaluhin meˈ semmek si Isahin. Maglegot siye magdaˈagan duk kataˈuhande bang semmek inggehin daˈagan dangan-danganin. ");
INSERT INTO yka_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ellet lettu duk salung pangalansangde iye diyataˈ olomin. ");
INSERT INTO yka_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Duk tuntut si iyehin sinulat diyataˈ olom sa inin: “Inin Sultan meˈ Yahudihin.” ");
INSERT INTO yka_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Duk niyaˈ duwangan mundu pinasumbayaˈ pu si Isa ilansang diyataˈ olomde. ");
INSERT INTO yka_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dambuwaˈ olomin pinatengge si kanawanne duk dambuwaˈin si bibanganne. ");
INSERT INTO yka_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Duk meˈ aˈa mapalabeyin, pinagsayehan iye weˈ de. Magkeleng-keleng siye duk paˈinde, “Aha. Paˈinnu talaraknu langgal hadjehin, ubus bu patenggenu balik dem tellu ellew. ");
INSERT INTO yka_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bang tatabangnu dinun, duwaˈi kew amban olom iyan.” ");
INSERT INTO yka_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Damikkiyan isab meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin pagudjiˈande iye, paˈinde, “Tatabangne aˈa seddilihin saguwaˈ dinen gaˈi tatabangne. ");
INSERT INTO yka_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iye koˈ Almasihin, sultan meˈ Israˈilin, na, ambat iye duwaˈi amban olom iyan. Bang takitete iye duwaˈi, na, kahagad ne kite.” Duk meˈ ilansang pinasumbayaˈ si iyehin, missā-missāhan iye du isab. ");
INSERT INTO yka_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na, paglettu ne ellewin, maglindem dem tibuˈukan lahat miyaˈan sampay lisag tellu kohapin. ");
INSERT INTO yka_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Paglisag tellu ne, magkilahap si Isa papales, paˈinne, “Eloi, Eloi, lama sabachthani?” Hātinen, “O Tuhanku, weˈey ku pasagadannu?” ");
INSERT INTO yka_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pagtakale inin weˈ meˈ aˈa magtengge-tengge malaˈihin, salaˈ pakakalehanden. Paˈinde, “Pakalehun bi be. Lingananne Nabi Eliyas.” ");
INSERT INTO yka_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Magtawus niyaˈ aˈa magubas pī moˈo kuweˈ gapas bu ngaleglebanne magdem ininum. Ubus tinogsokan weˈ ne miyaˈan diyataˈ kayu-kayu bu sinōngan weˈ ne pamasessep pu si Isa. Paˈin aˈa miyaˈan, “Daˈa dahuˈ. Payamante bi bang pitu ke Nabi Eliyas maduwaˈi iye amban diyataˈ olomin!” ");
INSERT INTO yka_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Manjari magkilahap si Isa mintedde papales ubus bu bekkat ne napasnen. ");
INSERT INTO yka_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Magtawus garet semmek subuk hinang ellig dem langgal hadjehin. Garet paduwe amban diyataˈ ngeregseˈ diyawaˈ. ");
INSERT INTO yka_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pagkite kapitan manengge mapaharap si olomin weˈ sa miyaˈan kabekkat napas si Isahin, nambat iye, paˈinne, “Sabennal aˈa inin Anak Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Niyaˈ laˈi meˈ dende mayam-mayam amban katala-talahan. Dem grupu miyaˈan laˈi si Mariyam dende amban Magdalahin, duk si Salome. Laˈi isab si Mariyam, saˈi si Joses duk si Yakub bataˈin. ");
INSERT INTO yka_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Meˈ dende miyaˈan manuhut-nuhut si Isahin duk siye manguntul iyehin palaˈine si lahat Jalilin. Duk ekka pe isab meˈ dende seddili laˈi, meˈ bakas manuhut iye hap Awrusalamin. ");
INSERT INTO yka_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ellew Pagpanyap miyaˈan, hātinen, dam bahangi meke ellew liˈi. Pagkohap ne ellew miyaˈan, tekka laˈi si Yusup. ");
INSERT INTO yka_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Si Yusup inin aˈa amban puweblo Arimati. Kunsihal inaddatan iye. Inagad-agad weˈ ne katuman meˈ paˈalan sabab pagbayaˈ Tuhanin. Manjari magtawakkal iye pī pu si Pilatus duk pināku weˈ ne bangkey si Isahin. ");
INSERT INTO yka_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ulaliˈ Pilatus pagkalene weˈ matey ne si Isa. Ilinganan weˈ ne kapitanin duk tinilew weˈ ne bang tiggel ne ke kamateynen. ");
INSERT INTO yka_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pagkataˈuhanne amban kapitanin weˈ asal matey ne si Isa, pinangurung ne weˈ ne bangkeynen pu si Yusup. ");
INSERT INTO yka_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Manjari melli si Yusup kakanaˈ duk pagubus ilebbes weˈ ne si Isa amban diyataˈ olomin, sinaput weˈ ne duk kakanaˈin. Ubus pinabāk weˈ ne dem lingab pagkubulan, batu ilowangan. Ubus bu ngaligid iye batu panampeng gawang lingabin. ");
INSERT INTO yka_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Laˈi mayam-mayam si Mariyam dende amban Magdalahin, duk si Mariyam saˈi si Josesin, duk takitede bang antag pangubulan si Isahin. ");
INSERT INTO yka_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pagpuwas ellew Sabtuˈ, ellew liˈihin, si Mariyam dende amban Magdalahin, duk si Salome, duk Mariyam saˈi si Yakubin, melli laksiˈ duk siye tapī ngalaksiˈan bangkey si Isahin. ");
INSERT INTO yka_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Manjari salung-salung pe ellew Ahad, hap pī siye si kubul. ");
INSERT INTO yka_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Magbissā-bissā siye si lān, paˈinde, “Sine mangaligidan batu tampeng lingabin duk kite bi dumiyalem?” Bu asal hadje batuhin. ");
INSERT INTO yka_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pagtekkade laˈi, takitede batuhin ubus ne iligidan. ");
INSERT INTO yka_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Padiyalem siye dem lingab. Ngite siye laˈi dambuwaˈ lella bataˈ magsemmek poteˈ ningkoloˈ-ningkoloˈ si antag kanawan. Takeddut teˈed siye. ");
INSERT INTO yka_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Paˈinne si siye, “Daˈa kaˈam tinalew. Kataˈuhanku pihabi si Isa, aˈa Nasaret bakas ilansang diyataˈ olomin. Gaˈ ne iye tuˈu. Ellum ne iye balik. Payamanun bi bakas pamabākan iyehin. ");
INSERT INTO yka_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, pī ne kaˈam,” paˈinne, “akahanun bi meˈ tindegnen duk si Petros weˈ padehellu iye amban kaˈam hap lahat Jalil. Kitebi du iye iyan laˈi, sa pangakane kaˈamin.” ");
INSERT INTO yka_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Manjari paluwas siye duk lahi siye amban kubulin peggeˈ migpid siye hawal dahitden. Gaˈ niyaˈ bissāde bisan pu sine peggeˈ tinalew siye. ");
INSERT INTO yka_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pagellum ne balik si Isa amban kamateynen ellew Ahad miyaˈan, paguwaˈ iye dehellu pu Mariyam dende amban Magdalahin, iye ne bakas pinaluwasanne seyitan pituˈin. ");
INSERT INTO yka_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Manjari pī si Mariyam si meˈ tindeg si Isahin sasangde laˈi magsugul duk magtangis. Inakahan siye weˈ Mariyam weˈ ellum si Isa duk bakas takitene, saguwaˈ gaˈ siye kahagad. ");
INSERT INTO yka_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagubus miyaˈan, paguwaˈ si Isa si duwangan tindegnen sasangde lumengngan hap lahat diyataˈ. Saguwaˈ pinda bantuknen. ");
INSERT INTO yka_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Manjari balik siye hap Awrusalam ngakahan meˈ saweˈden. Saguwaˈ gaˈ du isab siye kinahagad weˈ de. ");
INSERT INTO yka_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ubus miyaˈan, paguwaˈ si Isa si sampūˈ duk dambuwaˈ tindegnen sasangde mangan. Inamāhan siye weˈ ne peggeˈ gaˈ siye kahagad duk peggeˈ tuwas kōkden. Paˈinne, bisan siye inakahan weˈ meˈ bakas mangite iyehin weˈ ellum ne iye balik amban kamateynen, gaˈi du siye kahagad. ");
INSERT INTO yka_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Manjari paˈinne si siye, “Pī kaˈam si kēmon kalahat-lahatan si dunya duk mahalayakun bi aka-aka mahāpin si kēmon manusiyaˈ. ");
INSERT INTO yka_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sasuku makahagadin duk tapandi, tandaˈ weˈ sandel ne iye si aku,” paˈin si Isa, “timbul du iye. Saguwaˈ manggaˈi makahagadin, tewwaˈ hukuman Tuhanin du. ");
INSERT INTO yka_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Duk meˈ masandel si akuhin, inurungan du balakat maghinang meˈ hinangan makaˈulaliˈ. Makapaluwas siye iyan meˈ seyitan weˈ balakat ēnkun duk makabissā siye meˈ bissā gaˈi kataˈuhande. ");
INSERT INTO yka_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bang siye bessuwang makaˈantan sawe, duk bang siye bessuwang makaˈinum ine-ine gantaˈ makamatey, gaˈi du makaˈine siye. Duk bang bettadde tanganden si meˈ masakihin, kawuliˈan du siye.” ");
INSERT INTO yka_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Manjari pagubus Panuhutanin si Isa missā si meˈ tindegnen, paˈangkat iye hap surgaˈ duk ningkoloˈ iye si kanawanan Tuhanin, lugal mabangsahanin. ");
INSERT INTO yka_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Manjari lumengngan ne meˈ tindegnen magmahalayak si kēmon kalahat-lahatan. Duk inurungan siye weˈ Panuhutanin balakat maghinang meˈ hinangan balakatan, supaya kataˈuhan meˈ aˈahin weˈ toˈo meˈ panoloˈden. ");
INSERT INTO yka_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ekka ne bakas nulat sabab meˈ bakas malumabey diyalem kamihin, sabab Almasihin. ");
INSERT INTO yka_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sinulat weˈ de meˈ bakas inaka si kamihin weˈ meˈ bakas mangite hininangne kemuwe tagnaˈin, duk siye inin meˈ aˈa magmahalayak lapal Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na, aku isab kuweˈitu, peggeˈ bakas tapaliksaˈku ne teˈed kēmon malumabey miyaˈan kemuwe tagnaˈ, tapikilku isab manulat inin pinagturul-turul para si kaˈu, Tuwan Teopilus, ");
INSERT INTO yka_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","supaya kataˈuhannu weˈ kēmon bakas sinalsila si kaˈuhin asal bennal teˈed. ");
INSERT INTO yka_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kuweˈ inin tagnaˈnen: Matuˈuhin, masa si Herod pe sultan si lahat Yahudiyahin, niyaˈ imam ēnnen Jakariya. Dambuwaˈ iye meˈ imam si grupu Imam Abiya ley. Andanen si Elisabet pangkatan meˈ imam isab. ");
INSERT INTO yka_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kaduwangan siye bentel si pagmatahan Tuhan. Tinuhut teˈed weˈ de kēmon saraˈ duk pangandaˈakan Tuhanin. Gaˈ niyaˈ panallaˈan siye. ");
INSERT INTO yka_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Saguwaˈ gaˈ niyaˈ anakde peggeˈ gaˈi anakan Elisabet duk masa miyaˈan bahiˈ ne teˈed siye saliˈ-saliˈ. ");
INSERT INTO yka_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Manjari dambuwaˈ ellew, pagantiˈ ne magimam Jakariya duk grupunen si langgal mahadjehin. ");
INSERT INTO yka_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sa addat meˈ imamin magpuwaˈan siye, duk Jakariya kapasukuˈan manugtug kamanyanin dem bilik sutsi dem langgalin. Hangkan padiyalem iye pī si lumaˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Meˈ aˈa mabanesin laˈi si bukut ngampun-ngampun sasang panugtug kamanyanin. ");
INSERT INTO yka_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Manjari pabagala si iye dambuwaˈ malaˈikat Tuhanin nengge laˈi si kanawanan antag panugtug-nugtugan kamanyanin. ");
INSERT INTO yka_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pagkite Jakariya malaˈikatin, takeddut iye duk paˈasekan talew iye. ");
INSERT INTO yka_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Saguwaˈ paˈin malaˈikatin si iye, “Daˈa kew tinalew, Jakariya. Pinakale ne weˈ Tuhanin pangampunnun. Andanun Elisabet nganak du weˈ nu dambuwaˈ lella duk ēnanun iye Yahiya. ");
INSERT INTO yka_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Asal sinna kew teˈed iyan duk kēgan kew duk ekka isab aˈa kēgan paginanakan ne iye, ");
INSERT INTO yka_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","peggeˈ bangsahan du iye iyan si pagmatahan Tuhan. Gaˈi iye subey nginum ine-ine makalango. Kemuwe inanakan iye, andang ne iye paˈasekan Niyawa Sutsihin. ");
INSERT INTO yka_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Duk ekka meˈ aˈa Israˈil taboˈone balik si Tuhan Panuhutanden. ");
INSERT INTO yka_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Si Yahiya anaknu inin, iye mapadehellu amban Panuhutanin. Pagbayaˈan iye weˈ Niyawa Sutsihin kuweˈ Nabi Eliyas masaley, duk balakatan iye kuweˈ balakat Nabi Eliyasin masaley. Sabab panoloˈnen, maghāp balik meˈ samahin duk meˈ anakden. Duk meˈ aˈa manggaˈi manuhut pangandaˈakan Tuhanin, sabab meˈ panoloˈnen, pindahande du pikilanden duk bentel ne pamikilden. Ubus niyaˈ ne meˈ aˈa memes bang tekka Panuhutanin.” ");
INSERT INTO yka_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Paˈin Jakariya si malaˈikatin, “Saˈingge pakabugtuˈku inin? Bahiˈ ne ku duk andakun bahiˈ ne du isab.” ");
INSERT INTO yka_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nambung malaˈikatin, paˈinne, “Jibraˈil ku inin. Aku inin luwal ku nengge si panaˈanan Tuhanin. Dinaˈak ku weˈ Tuhanin pitu missā si kaˈu ngakahan kaˈu aka-aka mahāp inin. ");
INSERT INTO yka_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Payamanun be, peggeˈ gaˈ kahagadnu inakakun, ngaˈumew kew iyan duk gaˈi kew makabissā samantaˈan gaˈi tuman pinaˈinku si kaˈu inin. Saguwaˈ kēmon bakas inakaku si kaˈuhin asal tuman du bang taˈabut ne waktunen.” ");
INSERT INTO yka_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sābu miyaˈan, meˈ aˈahin magagad pu si Jakariya duk ulaliˈ siye bang weˈey iye managhāˈ tiggel laˈi diyalem langgal. ");
INSERT INTO yka_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pagpaguwaˈne, gaˈi iye taˈu missā si siye hangkan kataˈuhande weˈ niyaˈ bakas takitene pabagala si iye laˈi dem langgal. Ninyas-ninyas hadja iye si siye peggeˈ umew ne iye. ");
INSERT INTO yka_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Manjari pagjukup ne ellew pagimamnen laˈi si langgal mahadjehin, balik ne iye hap lahatne. ");
INSERT INTO yka_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gaˈ du tiggel, betteng ne si Elisabet, andanen, duk dem limem bulan gaˈ Elisabet paguwaˈ-guwaˈ. ");
INSERT INTO yka_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Paˈinne, “Asal hāp Tuhanin si aku. Inānan ne weˈ ne kaˈiyaˈanku si meˈ aˈahin peggeˈ tiyaˈ ne ku sōng anakan.” ");
INSERT INTO yka_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pagennem bulan ne betteng Elisabetin, dinaˈak weˈ Tuhanin malaˈikat Jibraˈil hap pī si dambuwaˈ puweblo laˈi si lahat Jalil inēnan Nasaret. ");
INSERT INTO yka_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dinaˈak iye pī si dambuwaˈ budjang ēnnen si Mariyam. Si Mariyam inin magtunang duk dambuwaˈ lella ēnnen si Yusup, tubuˈ Sultan Daˈud ley. ");
INSERT INTO yka_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pagtekka malaˈikatin laˈi si palaˈihan Mariyamin, paˈinne si dendehin, “Assalamu alaikum. Tapeneˈ kew weˈ Tuhanin, Mariyam. Luˈu si kaˈu Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pagkale Mariyam pinaˈin malaˈikatin, sasew teˈed dem pikilannen duk pinikil-pikil weˈ ne bang ine hāti pinaˈinne si iye miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Manjari paˈin malaˈikatin si iye, “Daˈa kew tinalew, Mariyam, peggeˈ kasulutan teˈed Tuhanin si kaˈu. ");
INSERT INTO yka_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sōng betteng kew iyan duk nganak kew lella. Ēnanun iye si Isa. ");
INSERT INTO yka_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bangsahan teˈed iye iyan duk inēnan du iye Anak Tuhan Tamanan Malangkewin. Duk pamanjari Tuhanin du iye sultan kuweˈ papuˈne Sultan Daˈud ley. ");
INSERT INTO yka_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Duk magsultan du iye si meˈ bangsa Israˈilin salama-lama. Gaˈ niyaˈ tamanan pagsultannen.” ");
INSERT INTO yka_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Paˈin Mariyam si malaˈikatin, “Saˈingge kajarine inin bu gaˈ pe niyaˈ ellaku?” ");
INSERT INTO yka_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nambung malaˈikatin, paˈinne, “Patekka du piyu si kaˈu Niyawa Sutsihin duk kalandungan du kew weˈ balakat Tuhanin. Hangkan hep nakanak inanakannun sutsi duk inēnan iye Anak Tuhan. ");
INSERT INTO yka_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Payamanun be isab usbanun Elisabet. Betteng iye kuweˈitu bisan ne iye bahiˈ. Dende pinaˈinde gaˈi manganakin, kuweˈitu ennem bulan ne bettengnen. ");
INSERT INTO yka_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Peggeˈ bang si Tuhan gaˈ niyaˈ hunit.” ");
INSERT INTO yka_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Manjari paˈin Mariyam, “Daraˈakan Tuhanin ku inin. Maglillaˈ ku si pinaˈinnun.” Ubus tahalaˈ ne amban iye malaˈikatin. ");
INSERT INTO yka_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gaˈ tiggel puwas miyaˈan, magmemes Mariyam duk magdayiˈ-dayiˈ iye hap pī si dambuwaˈ lahat diyataˈ laˈi si Yahudiya. ");
INSERT INTO yka_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pagtekkane laˈi, hap pī iye si lumaˈ Jakariya duk paˈinne pu si Elisabet, “Assalamu alaikum.” ");
INSERT INTO yka_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pagtakale Elisabet suwala Mariyamin, magtawus usaˈ nakanakin dem bettengne duk pagbayaˈan iye weˈ Niyawa Sutsihin, ");
INSERT INTO yka_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","duk missā iye papales pu si Mariyam, paˈinne, “Gaˈ niyaˈ dende tuˈu si dunya kuweˈ kaˈuhin kaˈurungan kahāpan maglabi-labi weˈ Tuhanin. Damikkiyan nakanak sōng inanakannun maglabi-labi isab kahāpan pangurung si iyehin. ");
INSERT INTO yka_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Weˈey teˈ ku pinahadje weˈ saˈi Panuhutankun, tiyaˈ pitu nindew aku. ");
INSERT INTO yka_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Peggeˈ pagtakaleku suwalanun, magtawus nakanak dem bettengkun usaˈ manamal hawal kēgnen. ");
INSERT INTO yka_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Asal kēgan kew paˈin manamal peggeˈ kinahagad weˈ nu weˈ tumanan Tuhanin du pinaˈinne si kaˈuhin.” ");
INSERT INTO yka_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Manjari paˈin Mariyam, “Asal pahadjeku teˈed Tuhanin amban dem ateyku. ");
INSERT INTO yka_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Pinakēg ku teˈed weˈ Tuhan manimbul akuhin, ");
INSERT INTO yka_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","peggeˈ inasip ku weˈ ne, daraˈakanne madiyawaˈin. Peggeˈ amban kuweˈitu inin, kēmon aˈa magpangkat-mamangkatin ēnande du ku dende asal makēganin. ");
INSERT INTO yka_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Peggeˈ Tuhan Mabalakatanin, hinangan makaˈulaliˈ hininangne si akuhin. Asal sutsi iye. ");
INSERT INTO yka_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Maˈaseˈ teˈed iye si meˈ magpangkat-pangkatan mahadje iyehin. ");
INSERT INTO yka_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pakitehanne basagnen si meˈ hinangannen, pagkanat-kanatne meˈ malangkew ateynen. ");
INSERT INTO yka_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ānanne meˈ sultanin amban pagsultananden duk palangkewne meˈ madiyawaˈ ateynen. ");
INSERT INTO yka_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Duhulanne duk mahāpin meˈ kasukalanin duk patahalaˈne meˈ madayahanin gaˈ niyaˈ taboˈode. ");
INSERT INTO yka_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tinabangan du weˈ Tuhanin daraˈakannen, bangsaten bi Israˈil. Gaˈ du takayipatne janjiˈnen weˈ kaˈaseˈanne kite bi. ");
INSERT INTO yka_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Peggeˈ bakas nanggup iye si meˈ kapapuˈanten bi, pu si Ibrahim duk meˈ tubuˈnen, weˈ kaˈaseˈanne du kite bi salama-lama.” ");
INSERT INTO yka_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Patennaˈ Mariyam tellum bulan laˈi pu si Elisabet, ubus hap lumaˈ ne iye balik. ");
INSERT INTO yka_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Manjari, taˈabut ne ellew panganak Elisabetin duk nganak iye lella. ");
INSERT INTO yka_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pagkale meˈ saweˈne magtapit lumaˈin duk meˈ kaˈusbahannen weˈ hāp teˈed hinangan Tuhanin si iye, magkēg isab siye matuk si iye. ");
INSERT INTO yka_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pagtaˈabut ne nakanakin walum bahangi diyataˈ kāpan, patipun siye pangislam nakanakin duk arak ēnande nakanakin Jakariya, sa ēn samanen. ");
INSERT INTO yka_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Saguwaˈ paˈin saˈinen, “Daˈa. Subey iye inēnan Yahiya.” ");
INSERT INTO yka_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Weˈey?” paˈinde. “Gaˈ hatiˈ niyaˈ bisan dambuwaˈ meˈ kaˈusbahannun magēn iyan.” ");
INSERT INTO yka_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Manjari magsinyas siye si sama nakanakin bang ine kabayaˈanne pangēn nakanakin. ");
INSERT INTO yka_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ninyas isab Jakariya māku panulatan duk sinulatnen inin: “Ēnnen Yahiya.” Ulaliˈ teˈed siye kēmon. ");
INSERT INTO yka_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Manjari magtawus ne Jakariya makabissā duk pinudji weˈ ne Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Paˈasekan talew kēmon saweˈde magtapit lumaˈin duk bawag maˈumantag inin si meˈ kalahat-lahatan diyataˈ laˈi si Yahudiya. ");
INSERT INTO yka_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Duk kēmon makakale inin, luwal pikil-pikilde duk paˈinde, “Ine enteˈ pangagantaˈ Tuhan nakanak miyaˈan?” Peggeˈ pastiˈ weˈ balakat Tuhanin laˈi si nakanak miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Manjari Jakariya, sama nakanakin, pinagbayaˈan weˈ Niyawa Sutsihin duk pasampayne lapal Tuhanin, paˈinne, ");
INSERT INTO yka_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pudjite bi Tuhanin, iye Tuhan sinambahayang bangsate bi Israˈilin, peggeˈ taˈessebne du kite bi meˈ aˈanen duk pinaluwas kite bi weˈ ne. ");
INSERT INTO yka_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Papitune si kite bi dambuwaˈ manimbulin, balakatan du iye duk tubuˈ daraˈakannen Sultan Daˈud ley. ");
INSERT INTO yka_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Asal nanggup Tuhanin awwalley duk pinalataˈ inin weˈ meˈ nabine masutsihin. ");
INSERT INTO yka_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nanggup Tuhanin weˈ asal paluwasne kite bi amban meˈ bantaten bi duk amban antanan meˈ mabunsi si kitehin bi. ");
INSERT INTO yka_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Paˈinne weˈ kaˈaseˈanne meˈ kapapuˈante bi ley duk tumananne du janjiˈne masutsihin, ");
INSERT INTO yka_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","iye janjiˈ sinapahanne si papuˈten bi Ibrahim. ");
INSERT INTO yka_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ngajanjiˈ hep iye weˈ kite bi meˈ tubuˈ Ibrahimin, paluwasne du amban antanan meˈ bantaten bi duk kite bi kapaghinang si Tuhan, gaˈ niyaˈ makatalew kite bi, ");
INSERT INTO yka_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","supaya tiggelante bi maˈellumin kapaghinang kite bi si Tuhan, sutsi pagateyten, duk bentel hinanganten.” ");
INSERT INTO yka_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Manjari missā Jakariya si anaknen, paˈinne, “Kaˈu Totoˈ, inēnan du kew nabi Tuhan Tamanan Malangkewin. Peggeˈ padehellu du kew amban Panuhutanin manyap lān palabeyannen. ");
INSERT INTO yka_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kaˈu iye mangakahan meˈ aˈanen supaya kataˈuhande weˈ bang inampun ne duseden, timbul du siye. ");
INSERT INTO yka_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Peggeˈ Tuhanin maˈaseˈ teˈed duk hāp. Papitune si kite bi dantaˈ amban surgaˈin. ");
INSERT INTO yka_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Sinag dantaˈ inin si kēmon mapatennaˈ dem lindemin, si meˈ aˈa matalew mamateyin, duk panduˈanne kite bi pī si lān tudju kasanyanganin.” ");
INSERT INTO yka_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Manjari anak Jakariyahin nulig ne paˈin duk magkasōng isab pamikilnen. Duk laˈi iye patennaˈ dem lahat makagindew-gindew samantaˈan gaˈ pe iye paguwaˈ patampak si meˈ aˈa Israˈilin. ");
INSERT INTO yka_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Masa īˈ, si Agustus Sultan Nakuraˈ si bangsa Romahin. Manjari ngurung uldin iye weˈ subey magpalista kēmon aˈa dem meˈ kalahat-lahatan si antanannen. ");
INSERT INTO yka_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iye inin tagnaˈ pangalista meˈ aˈahin, duk masa si Kirinu gubnul si lahat Siriyahin paglista inin. ");
INSERT INTO yka_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hangkan kēmon aˈahin balik pī si lahat kapapuˈanden magpalista. ");
INSERT INTO yka_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Si Yusup lumengngan amban puweblo Nasaret laˈi si lahat Jalil pataked hap pī si lahat Yahudiya, si puweblo Betlehem, iye lahat panganakan Sultan Daˈud ley. Pī iye magpalista laˈi peggeˈ tubuˈ si Daˈud iye. ");
INSERT INTO yka_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Magtuhut iye duk Mariyam tunangnen pī magpalista. Si Mariyam betteng. ");
INSERT INTO yka_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Manjari, baytude laˈi si Betlehem, taˈabut nganak Mariyam. ");
INSERT INTO yka_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Inanakan weˈ ne anakne panganayenin, lella. Pinutus weˈ ne nakanakin dem olos duk pinabāk weˈ ne dem kahun pagpakanan hayep dem kamalig peggeˈ gaˈ niyaˈ lānde dem lumaˈ paghegpaˈ-hegpaˈanin. ");
INSERT INTO yka_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na, sangem miyaˈan, niyaˈ meˈ pastul bili-bili si lahat miyaˈan magjaga manteyan meˈ panenan bili-biliden dem kabalilihan si kahayangan. ");
INSERT INTO yka_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bessuwang niyaˈ dambuwaˈ malaˈikat Tuhanin pabagala si siye duk sahaya Tuhanin ninag paliput si siye hangkan kadahitan teˈed siye. ");
INSERT INTO yka_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Saguwaˈ paˈin malaˈikatin, “Daˈa kaˈam tinalew, peggeˈ pitu ku ngakahan kaˈam aka-aka hāp makakēg meˈ aˈahin kēmon. ");
INSERT INTO yka_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Laˈi si Betlehem, puweblo Sultan Daˈud awwalley, inanakan ne ellew inin Manimbul kaˈamin. Iye Almasi, Panuhutanin. ");
INSERT INTO yka_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Duk iye inin indanin weˈ bennal aka-aka inin: kasuwaˈbi du nakanakin pinutus dem olos duk pinabāk dem kahun pagpakanan hayep.” ");
INSERT INTO yka_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Manjari niyaˈ magtawus takitede si bihing malaˈikatin banes teˈed malaˈikat amban surgaˈ. Pinudji weˈ de Tuhanin, paˈinde, ");
INSERT INTO yka_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Pataˈ Tuhanin pinudji si surgaˈ, duk si dunya karayaw sanyang meˈ aˈa makasulut iyehin!” ");
INSERT INTO yka_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ubus tahalaˈ ne meˈ malaˈikatin balik pī si surgaˈ. Pagtumahalaˈ ne siye, paˈin meˈ pastul bili-bilihin, “Sūng kite bi pī si Betlehem. Payamante bi bakas pinagintaˈu weˈ Tuhan si kite inin.” ");
INSERT INTO yka_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Manjari magdayiˈ-dayiˈ siye pī duk takasuwaˈ weˈ de si Mariyam duk si Yusup, duk nakanakin laˈi pinabāk dem kahun pagpakanan hayep. ");
INSERT INTO yka_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pagkitede nakanakin, magaka-aka siye sabab bakas inaka malaˈikat si siyehin pasal nakanak miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Duk kēmon makakale inaka meˈ pastul miyaˈan, ulaliˈ manamal. ");
INSERT INTO yka_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Saguwaˈ si Mariyam inesseb-esseb weˈ ne kēmon inin duk luwal pikil-pikilne. ");
INSERT INTO yka_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Manjari balik ne meˈ pastulin pī si meˈ hayepden. Pinudji duk sinanglitan weˈ de Tuhanin sabab meˈ bakas takaleden duk takiteden, peggeˈ kēmon bakas inaka malaˈikat si siyehin toˈo teˈed. ");
INSERT INTO yka_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pagtaˈabut ne nakanakin walum bahangi diyataˈ kāpan, inislam iye duk inēnan iye si Isa, ēn pangēn malaˈikatin gaˈ pe iniraman nakanakin. ");
INSERT INTO yka_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Puwas ampatpūˈ bahangi bakas panganak Mariyamin, tinuhut ne weˈ si Yusup duk Mariyam addat pagsutsihin sa pangandaˈakan saraˈ si Musahin. Binoˈo weˈ de nakanakin pī si Awrusalam supaya iye kasōngande si Tuhan laˈi. ");
INSERT INTO yka_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tinuhut weˈ de tasulat dem saraˈ pinangurung Tuhanin, pinaˈin, “Kēmon anak lella panganayen subey sinōngan si Tuhan.” ");
INSERT INTO yka_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Duk pī isab siye magkuluban sa pangandaˈakan dem saraˈ Tuhanin weˈ duwe koˈ assang atawa duwe tukmu bahu ilayangan subey sōngande hinang kuluban. ");
INSERT INTO yka_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na, niyaˈ laˈi aˈa si Awrusalam ēnnen si Simiyun. Aˈa inin bentel duk luwal nambahayang si Tuhan. Inagad-agad weˈ ne waktu katekka manimbul bangsa Israˈilin. Duk laˈi si iye Niyawa Sutsihin. ");
INSERT INTO yka_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bakas pinagintaˈu si iye weˈ Niyawa Sutsihin weˈ gaˈi iye matey samantaˈan gaˈi kitene Almasi, bakas pananggup Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Manjari dinaˈak iye pī dem langgal hadjehin weˈ Niyawa Sutsihin. Andang ne iye laˈi dem langgal pagtekka pī saˈi-sama si Isahin moˈo iye supaya tahinang si iye pangandaˈakan saraˈin. ");
INSERT INTO yka_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pagkite si Simiyun nakanakin, ineddoˈ bu pinippi weˈ ne bu magsukul iye si Tuhan, paˈinne, ");
INSERT INTO yka_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Tuhan, makajari ne ku, daraˈakannun, papoleˈnu hap ahilat peggeˈ tuman ne pananggupnu si akuhin. ");
INSERT INTO yka_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Takite mataku ne inin manimbulin ");
INSERT INTO yka_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","pinapitu weˈ nu supaya takite meˈ manusiyaˈin kēmon. ");
INSERT INTO yka_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iye dalil dantaˈ makitehan kabayaˈannun si meˈ kabangsahan sinduwehin duk sababne pinahadje du meˈ aˈanun bangsa Israˈilin.” ");
INSERT INTO yka_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ulaliˈ teˈed saˈi-sama nakanakin si meˈ binissā si Simiyunin sabab anakden. ");
INSERT INTO yka_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Manjari māku-māku si Simiyun kahāpan amban Tuhan para si siye. Ubus missā iye pu si Mariyam, saˈi nakanakin, paˈinne, “Anaknu inin, iye pangagantaˈ Tuhan si iyehin weˈ sababne, ekka aˈa si bangsa Israˈil patapit si Tuhan duk ekka isab patala amban Tuhan. Pinapitu iye weˈ Tuhanin hinang tandaˈ, saguwaˈ gaˈi iye tinayimaˈ weˈ meˈ aˈa maˈekkahin. ");
INSERT INTO yka_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Duk sababne, paluwas du bang ine teˈed pinikilden. Duk kaˈu, Mariyam, hawal dukkanun kuweˈ ilogsok iyan ateynun duk kalis.” ");
INSERT INTO yka_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Niyaˈ isab laˈi dambuwaˈ nabi dende inēnan si Anna, anak Panuˈel, pangkatan si Aser ley. Bahiˈ ne teˈed iye. Pitun tahun hadja pagdambuwaˈne duk ellanen, ");
INSERT INTO yka_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ubus balu iye sampay kuweˈitu walumpūˈ duk ampat tahun ne umulnen. Luwal iye dem langgal hadjehin sampay magpuwase duk ngampun duk magsambahayang dumaˈin hadja ellew saguwaˈ bisan sangem. ");
INSERT INTO yka_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Patapit iye duk magsukul iye si Tuhan duk missā iye sabab nakanakin si meˈ aˈahin, sasuku ngase-ngase weˈ timbul Tuhanin du bangsade Israˈilin. ");
INSERT INTO yka_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pagubus ne tahinangde kēmon pangandaˈakan dem saraˈ Tuhanin, balik ne Mariyam duk si Yusup hap Jalil pī si puwebloden Nasaret. ");
INSERT INTO yka_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nakanakin nulig duk ngabasag. Pasōng kataˈunen duk kasulutan teˈed Tuhanin si iye. ");
INSERT INTO yka_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kahabaˈ tahun meˈ matettoˈa si Isahin hap pī si Awrusalam bang baytu pagkādjaˈan Pangesseban Palabey Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pagsampūˈ duk duwen tahun ne umul si Isahin, hap pī siye si pagkādjaˈan miyaˈan sa hinanganden. ");
INSERT INTO yka_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagubus ne kādjaˈanin, hap lumaˈ ne siye. Saguwaˈ si Isa paˈamban si Awrusalam bu gaˈ inin kataˈuhan meˈ matettoˈanen. ");
INSERT INTO yka_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kannalde laˈi du iye patuhut si meˈ saweˈde maglengnganin. Maglengngan pe siye kekkohapan bahude miha iye laˈi si meˈ kaˈusbahanden duk meˈ kabagayanden saguwaˈ gaˈ iye laˈi. ");
INSERT INTO yka_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Peggeˈ gaˈ iye kasuwaˈde, balik siye hap Awrusalam miha iye. ");
INSERT INTO yka_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pagpuwas tellum bahangi, takasuwaˈde iye diyalem langgal hadjehin magtingkoloˈ duk meˈ guru, pakale si siye duk nilew-nilew siye. ");
INSERT INTO yka_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kēmon makakale iyehin ulaliˈ teˈed peggeˈ lalem kataˈunen duk tewwaˈ meˈ panambungnen. ");
INSERT INTO yka_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ulaliˈ teˈed meˈ matettoˈanen pagkitede iye. Paˈin saˈinen si iye, “Totoˈ, weˈey sa inin hininangnu si kamihin? Samanun duk aku suse teˈed magpiha si kaˈu.” ");
INSERT INTO yka_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Weˈey pe ku pihabi?” paˈin si Isa. “Weˈ gaˈ kataˈuhanbi weˈ subey ku tuˈu si lumaˈ Samakun?” ");
INSERT INTO yka_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Saguwaˈ gaˈ tahātide pinaˈinne miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Manjari nuhut ne si Isa meˈ matettoˈanen hap lumaˈ pī si Nasaret duk tuhutne pangandaˈakande iyehin. Duk kēmon malumabeyin inennaˈ-ennaˈ weˈ Mariyam dem ateyne. ");
INSERT INTO yka_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pasōng panulig si Isahin duk pasōng isab kataˈunen. Pasōng isab kasulutan Tuhanin duk meˈ aˈahin si iye. ");
INSERT INTO yka_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Pagsampūˈ duk limen tahun ne pagsultan si Tiberus, Sultan Nakuraˈ bangsa Romahin, manjari tekka lapal Tuhanin pī pu si Yahiya anak Jakariyahin. Laˈi si Yahiya si lahat makagindew-gindew. Masa miyaˈan si Pontiyus Pilatus gubnul si lahat Yahudiya, si Herod gubnul si lahat Jalil duk pungtinaˈinen si Pilip gubnul si lahat Ituriya duk lahat Tarakuniti, duk Lisani gubnul si lahat Abilen. Meˈ imam nakuraˈin si Annas duk si Kayapas. ");
INSERT INTO yka_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ubus lumengngan Yahiya ngalatag kalahat-lahatan mapaliput si boheˈ Jordanin magmahalayak si meˈ aˈahin weˈ sasuku magsusun ne duk ngalebbahan meˈ hinanganne malaˈatin, subey iye pinandi duk ampun Tuhanin du iye. ");
INSERT INTO yka_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hinang Yahiya inin, andang pinaˈal dem sulat Nabi Isaya awwalley. Pinaˈin laˈi: “Niyaˈ aˈa maglingan dem lahat makagindew-gindew. Iye inin paˈinne: ‘Sōng tekka ne Panuhutanin. Palanuˈun bi lān palabeyannen. Pabentelun bi lān tinuhutnen. ");
INSERT INTO yka_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kēmon lebbakin subey pinennoˈan duk kēmon punu duk kūdin subey dinatagan, mabingkokin pinabentel, lān maglettud-lebbakin pinalanuˈ. ");
INSERT INTO yka_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Manjari takite meˈ manusiyaˈin du kēmon bang saˈingge panimbul Tuhan siyehin.’” ");
INSERT INTO yka_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Banes teˈed aˈa pī pu si Yahiya makipandi si iye. Hangkan paˈinne si siye, “Kaˈam iyan, addatbin kuweˈ addat sawe pangakkal. Weˈey kaˈam pitu? Kannalbi hatu weˈ gaˈi kaˈam tewwaˈ mulkaˈ Tuhan sōng matekkahin bang kaˈam pinandi. ");
INSERT INTO yka_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hinangun bi hinangan mahāpin duk takite weˈ tayikutanbi ne dusebin. Daˈa kaˈam ngandel weˈ gaˈi kaˈam legga Tuhanin sewukat ne kaˈam tubuˈ Apuˈ Ibrahim. Akahante kaˈam, bisan meˈ batu inin tahinang Tuhanin du meˈ tubuˈ Apuˈ Ibrahim. ");
INSERT INTO yka_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kuweˈ dalil kayu kaˈam sōng tinebbengan si gamutne. Kēmon kayu manggaˈi magbuwaˈ mahāpin tinebbengan duk ilakasan dem ebbut ineggas.” ");
INSERT INTO yka_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tinilew iye weˈ meˈ aˈa mabanesin, paˈinde, “Na, ine subey hinang kami?” ");
INSERT INTO yka_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sambunganne siye, paˈinne, “Taga badjuˈ duwehin subey urunganne manggaˈ niyaˈ badjuˈnen. Damikkiyan taga kinakanin subey isab bahagiˈanne manggaˈ niyaˈ kinakannen.” ");
INSERT INTO yka_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Niyaˈ isab meˈ aˈa magpāku-pāku sukey para si gubelno pī pu si Yahiya makipandi duk paˈinde si iye, “Tuwan, kami inin, ine subey hinang kami?” ");
INSERT INTO yka_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nambung iye, paˈinne, “Daˈa kaˈam māku sukey labi amban pangandaˈakan kaˈamin.” ");
INSERT INTO yka_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Niyaˈ isab meˈ sundalu nilew iye, paˈinde, “Na, kami, ine subey hinang kami?” Paˈinne si siye, “Daˈa kaˈam makitalew atawa nuntut gaˈi bennal supaya kaˈam kaˈurungan pilak. Duk magsukul kaˈam si suweldobin.” ");
INSERT INTO yka_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pagkale meˈ aˈahin usihat Yahiyahin, kuweˈ ngase-ngase siye saguwaˈ kuweˈ duwe-duwehan du isab dem ateyden bang si Yahiya miyaˈan asal Almasihin ne ke. ");
INSERT INTO yka_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Saguwaˈ paˈin Yahiya si siye kēmon, “Pinandi kaˈam weˈ ku duk boheˈ saguwaˈ niyaˈ dambuwaˈ lella sōng pitu asal balakatan iye amban aku, gaˈi ku bisan matalep ngalekkahan ingket tehompaˈnen. Iye inin seddili pamandine kaˈamin. Niyaˈ kaˈam papīhanne Niyawa Sutsihin duk sinduwehin pandine duk ebbut. ");
INSERT INTO yka_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pagpaˈilne meˈ aˈa mahāpin duk meˈ aˈa malaˈatin. Kuweˈ iye dalil aˈa magpalid paley, pagpaˈilne linggasin duk apahin. Meˈ linggasin ennaˈne pinadem lukung saguwaˈ apahin eggasne dem ebbut gaˈ niyaˈ kapalemne.” ");
INSERT INTO yka_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ekka pe usihat seddili guna Yahiya pagmahalayakne aka-aka mahāpin si meˈ aˈahin, duk binuyuˈ-buyuˈ siye weˈ ne dinaˈak ginantiˈan kawul-piˈilden. ");
INSERT INTO yka_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Inamāhan isab weˈ Yahiya Gubnul Herod sabab maganda iye pu si Herodiyas, bakas anda pungtinaˈinen, duk sabab hinanganne sinduwe malaˈatin. ");
INSERT INTO yka_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ubus tambahan si Herod pe meˈ hinanganne malaˈatin, kinalabusu weˈ ne Yahiya. ");
INSERT INTO yka_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Masa pamandi Yahiya meˈ aˈahin kēmon, pinandi isab si Isa weˈ ne. Pagubus si Isa pinandi, ngampun iye duk sasangne mangampunin, luka langitin, ");
INSERT INTO yka_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","duk duwaˈi Niyawa Sutsihin pī si iye kuweˈ bantuk assang. Duk niyaˈ suwala amban surgaˈ magpaˈin, “Anakte kew kalasahanku. Kasulutan ku teˈed si kaˈu.” ");
INSERT INTO yka_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Manjari nagnaˈ si Isa magusihat, niyaˈ meˈ tellumpūˈ tahun ne umulnen. Kannal meˈ aˈahin anak si Yusup iye, si Yusup inin anak si Heli. ");
INSERT INTO yka_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Heli anak si Mattat, si Mattat anak si Libi, si Libi anak si Malki, si Malki anak si Janni, si Janni anak si Yusup. ");
INSERT INTO yka_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Yusup inin anak si Mattati, si Mattati anak si Amos, si Amos anak si Nahum, si Nahum anak si Esli, si Esli anak si Naggay. ");
INSERT INTO yka_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Naggay anak si Maˈat, si Maˈat anak Mattati, si Mattati inin anak si Semeˈin, si Semeˈin anak si Yosek, si Yosek anak si Joda. ");
INSERT INTO yka_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Joda anak si Joˈanan, si Joˈanan anak si Resa, si Resa anak si Serubbabel, si Serubbabel anak si Salati, si Salati anak si Neri, ");
INSERT INTO yka_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","si Neri anak si Malki, si Malki inin anak si Addi, si Addi anak si Kosam, si Kosam anak si Elmadam, si Elmadam anak si Er. ");
INSERT INTO yka_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er anak si Yussaˈ, si Yussaˈ anak Eleeser, si Eleeser anak si Jorim, si Jorim anak si Mattat, si Mattat anak si Libi, ");
INSERT INTO yka_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","si Libi anak si Simiyun, si Simiyun anak si Yuda, si Yuda anak si Yusup, si Yusup inin anak si Jonam, si Jonam anak Eliyakim. ");
INSERT INTO yka_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliyakim anak si Meleya, si Meleya anak si Menna, si Menna anak si Mattata, si Mattata anak si Natan, si Natan anak Sultan Daˈud. ");
INSERT INTO yka_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si Daˈud anak si Jesse, si Jesse anak si Obed, si Obed anak si Bowas, si Bowas anak si Salmon, si Salmon anak si Nasson. ");
INSERT INTO yka_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Nasson anak Amminadab, si Amminadab anak si Admin, si Admin anak si Arni, si Arni anak si Hesdon, si Hesdon anak si Peres, si Peres anak si Yuda. ");
INSERT INTO yka_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Yuda anak si Yakub, si Yakub anak si Isahak, si Isahak anak si Ibrahim, si Ibrahim anak si Tera, si Tera anak si Nahor. ");
INSERT INTO yka_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor anak si Serug, si Serug anak si Raga, si Raga anak si Peleg, si Peleg anak si Eber, si Eber anak si Sela. ");
INSERT INTO yka_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sela anak si Kainan, si Kainan anak si Arpaksad, si Arpaksad anak si Sem, si Sem anak si Nu, si Nu anak si Lamek, ");
INSERT INTO yka_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","si Lamek anak Metusela, si Metusela anak si Idris, si Idris anak si Jared, si Jared anak si Mahalalel, si Mahalalel anak si Kenan. ");
INSERT INTO yka_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Kenan anak si Enos, si Enos anak si Set, si Set anak Apuˈ Adam duk si Apuˈ Adam anak Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Manjari pagubus si Isa pinandi weˈ Yahiya, tahalaˈ iye amban boheˈ Jordan. Pagbayaˈan iye weˈ Niyawa Sutsihin duk binoˈo iye weˈ Niyawa Sutsihin hap lahat makagindew-gindew. ");
INSERT INTO yka_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ampatpūˈ bahangi iye laˈi duk sinassat iye laˈi weˈ nakuraˈ seyitanin. Tiggelanne malaˈihin gaˈ iye mangan duk pagpuwas miyaˈan inusan ne iye. ");
INSERT INTO yka_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Manjari paˈin nakuraˈ seyitanin si iye, “Bang bennal kew teˈed Anak Tuhanin, daˈakun batu inin manjari kinakan.” ");
INSERT INTO yka_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sambungan si Isa iye, paˈinne, “Tasulat dem kitab, pinaˈin, ‘Dumaˈin hadja kinakan makaˈellum manusiyaˈin.’” ");
INSERT INTO yka_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Manjari binoˈo si Isa weˈ nakuraˈ seyitanin padiyataˈ pī si lugal langkew manamal bu pinakitehan weˈ ne si iye dem da kilep mata kēmon kalahatan si dunyahin. ");
INSERT INTO yka_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Paˈin nakuraˈ seyitanin si iye, “Urungte kew kapatut duk kew kapagbayaˈ si meˈ kalahatan inin duk si meˈ alataˈden. Peggeˈ bakas sinōngan inin si aku duk makajari pangurungku pu sine-sine kabayaˈanku. ");
INSERT INTO yka_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bang kew pasujud si aku, si kaˈu ne inin kēmon.” ");
INSERT INTO yka_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sambungan si Isa iye, paˈinne, “Tasulat dem kitab, pinaˈin, ‘Subey kaˈam pasujud si Tuhan Panuhutanbin duk subey hadja iye dendangan sinambahayangbin.’” ");
INSERT INTO yka_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ubus miyaˈan binoˈo iye weˈ nakuraˈ seyitanin hap Awrusalam duk pinatengge iye diyataˈ būngan langgal hadjehin, duk paˈinne si iye, “Bang bennal kew teˈed Anak Tuhanin palaboˈ kew bittuˈu, ");
INSERT INTO yka_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","peggeˈ tasulat du dem kitab, pinaˈin, ‘Daˈakne kew inipat si malaˈikatnen supaya gaˈ niyaˈ baya-bayanu.’ ");
INSERT INTO yka_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Duk tasulat du isab, pinaˈin, ‘Tayak meˈ malaˈikatin kew supaya bisan bettisnun gaˈi peddiˈan weˈ batu.’” ");
INSERT INTO yka_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sambungan si Isa iye, paˈinne, “Paˈin kitabin, ‘Daˈa suleyanun Tuhan Panuhutannun.’” ");
INSERT INTO yka_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pagubus ne kēmon bayuˈan panassat nakuraˈ seyitan pu si Isahin, tahalaˈ dahuˈ iye amban si Isa. ");
INSERT INTO yka_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Manjari balik si Isa pī hap Jalil. Laˈi si iye balakat Niyawa Sutsihin, duk aka-aka sabab iyehin palatag si meˈ kalahat-lahatan mapaliputin. ");
INSERT INTO yka_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Magusihat iye si meˈ kalanggal-langgalanden duk sinanglitan iye weˈ meˈ aˈahin kēmon. ");
INSERT INTO yka_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hap pī si Isa si Nasaret, lahat kasuligannen. Pagtaˈabut ellew Sabtuˈ, ellew liˈi meˈ Yahudihin, pī iye si langgal sa hinangannen. Manjari nengge iye supaya iye makabatsa amban dem kitab. ");
INSERT INTO yka_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Sinōngan si iye kitab sinulat Nabi Isayahin. Iluka weˈ ne kitabin duk takasuwaˈ weˈ ne meˈ ayat inin bu binatsa weˈ ne inin, pinaˈin, ");
INSERT INTO yka_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Pagbayaˈan ku weˈ Niyawa Tuhanin, peggeˈ tapeneˈ ku weˈ ne magmahalayak aka-aka mahāpin si meˈ aˈa makaˈaseˈ-aseˈin. Dinaˈak ku weˈ Tuhanin pitu ngakahan meˈ pilisuhin weˈ pinaluwas ne siye, meˈ mapessekin weˈ makakite ne siye balik, duk maluwas ku meˈ tiniksaˈin. ");
INSERT INTO yka_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Dinaˈak ku isab pitu magpalataˈ weˈ taˈabut ne tahun pagtimbul Tuhan meˈ aˈanen.” ");
INSERT INTO yka_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ubus tinambel weˈ ne kitabin duk pinangurung weˈ ne balik pī si bilalin bu ningkoloˈ iye. Kēmon aˈa dem langgal miyaˈan ngadendengan iye. ");
INSERT INTO yka_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Manjari nagnaˈ iye missā si siye. Paˈinne, “Ellew inin meˈ ayat binatsaku miyaˈan tuman ne sasangbi mapakalehin.” ");
INSERT INTO yka_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Meˈ aˈa dem langgalin kahāpan teˈed pu si Isa. Ulaliˈ siye peggeˈ pandey iye missā. Magbissā-bissā siye, paˈinde, “Dumaˈin ke inin anak si Yusupin?” ");
INSERT INTO yka_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Paˈin si Isa si siye, “Bugtuˈ bissābi si aku eliˈan inin: ‘Doktol, pakoleˈun dinun,’ duk paˈinbi isab, ‘Hinangun isab tuˈu si di lahatnu bakas takale kami hininangnu si lahat Kapernaumin.’ ");
INSERT INTO yka_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sabennal akahante kaˈam,” paˈinne pe, “nabihin gaˈi pagaddatan bang si di lahatne. ");
INSERT INTO yka_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Akahante kaˈam, awwalley pe, masa Eliyas nabihin, gaˈ hep ulan dem tellun tahun duk tengngaˈ duk inunus teˈed tibuˈukan lahat inin. Bennal ekka dende balu tuˈu si lahat Israˈil masa unus miyaˈan, ");
INSERT INTO yka_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","saguwaˈ dumaˈin pī si siye pangandaˈakan Tuhan Nabi Eliyasin saguwaˈ dinaˈak iye pī si dende balu dumaˈin bangsa Israˈil laˈi si Sarepta, si lahat Sidon. ");
INSERT INTO yka_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Damikkiyan du isab masa si Elisa nabihin,” paˈin si Isa. “Ekka aˈa inipul si bangsa Israˈil masa miyaˈan saguwaˈ gaˈ niyaˈ siye kawuliˈan bisan dambuwaˈ, luwal iye makawuliˈanin aˈa amban bangsa Siriya, ēnnen si Nayman.” ");
INSERT INTO yka_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pagkalede inin, kēmon siye dem langgal miyaˈan astel manamal. ");
INSERT INTO yka_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kuwat siye duk sinōgadan weˈ de si Isa bu binoˈo weˈ de paluwas amban puweblo pī diyataˈ punu paglahatande miyaˈan, supaya iye talaboˈde pī si pampang. ");
INSERT INTO yka_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Saguwaˈ si Isa lumabey amban tengngaˈde duk tahalaˈ iye. ");
INSERT INTO yka_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Padurul si Isa amban Nasaret pī si Kapernaum, dambuwaˈ puweblo isab si lahat Jalil. Pagtaˈabut ellew Sabtuˈ, ellew liˈi, magusihat iye si meˈ aˈahin dem langgal. ");
INSERT INTO yka_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ulaliˈ siye pagkalede usihatnen peggeˈ taga balakat iye bang iye missā. ");
INSERT INTO yka_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Laˈi dem langgal miyaˈan, niyaˈ aˈa pasayedan seyitan. Magkilahap iye papales, ");
INSERT INTO yka_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","paˈinne, “Allo! Daˈa kami sasewun, Isa aˈa Nasaret. Gaˈ niyaˈ lamudnu si kami. Pitu ke kew makaˈatan kami? Kataˈuhanku du bang sine kew. Kaˈu dambuwaˈ-buwaˈ masutsi mapitu amban Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Saguwaˈ inamāhan weˈ si Isa seyitanin. Paˈinne, “Daˈa kew mabehe. Paguwaˈ kew amban aˈa iyan!” Manjari hinantakan weˈ seyitanin aˈahin dem tengngaˈ meˈ aˈahin duk pagubus, paguwaˈ ne iye amban aˈahin duk gaˈ du makaˈine aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bengngangan meˈ aˈahin kēmon duk magbissā-bissā siye, paˈinde, “Meˈ bissāhey inin? Taga balakat iye duk taga kapatut ngandaˈak meˈ seyitanin. Tuhutde pangandaˈakannen duk paguwaˈ siye.” ");
INSERT INTO yka_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Duk aka-aka sabab si Isahin palatag ne si meˈ kalahatan mapaliputin. ");
INSERT INTO yka_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Puwas miyaˈan, paluwas si Isa amban langgal duk pī iye padiyalem si lumaˈ si Simon. Na, saki hep matoˈa si Simon dendehin maglemmun manamal, duk pākude pu si Isa weˈ pakoleˈne iye. ");
INSERT INTO yka_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pī si Isa nengge si bihing dende masakihin duk daˈakne tahalaˈ lemmunnen duk kawuliˈan ne dendehin. Magtawus iye dongaˈ duk pinakan siye weˈ ne. ");
INSERT INTO yka_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pagseddep ellewin, kēmon meˈ taga bagay masakihin bisan saki ine-ine, binoˈo siye weˈ de pī pu si Isa. Binettad weˈ si Isa tangannen si siye dangan-dangan, duk pakawuliˈne siye. ");
INSERT INTO yka_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Duk ekka isab aˈa paguwaˈan seyitan duk kakilahap-kilahapan meˈ seyitanin, paˈinde, “Kaˈu Anak Tuhanin!” Saguwaˈ inamāhan siye weˈ si Isa gaˈi siye dinaˈak mabehe, peggeˈ kataˈuhande weˈ iye Almasihin. ");
INSERT INTO yka_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pagellew ne, tahalaˈ si Isa pī si lugal gaˈ niyaˈ aˈane. Piniha iye weˈ meˈ aˈahin duk pagtakasuwaˈde iye, inohotan iye weˈ de. ");
INSERT INTO yka_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Saguwaˈ paˈinne si siye, “Subey ku isab pī si meˈ kalahatan seddilihin magmahalayak aka-aka hāp sabab pagbayaˈ Tuhanin peggeˈ iye inin puˈunku pinapitu weˈ Tuhanin si dunya.” ");
INSERT INTO yka_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Duk magmahalayak iye dem meˈ kalanggal-langgalan laˈi si Yahudiya. ");
INSERT INTO yka_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dambuwaˈ ellew laˈi si Isa nengge-nengge si higad lamew Gennesaret. Meˈ aˈahin maglaray pī si iye pakale si lapal Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Niyaˈ kite si Isa duwe bangkaˈ si higad lamew saguwaˈ gaˈ laˈi dem bangkaˈ meˈ aˈa magkennahin. Laˈi siye ngosoˈan meˈ pokotden. ");
INSERT INTO yka_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dambuwaˈin bangkaˈ si Simon. Pasakey si Isa laˈi duk daˈakne pu si Simon sinawunsungan kuweˈahat amban tapiyan. Manjari ningkoloˈ iye duk inusihatan ne paˈin weˈ ne meˈ aˈahin amban dem bangkaˈin. ");
INSERT INTO yka_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagubus ne iye magusihat, paˈinne pu si Simon, “Musey kew duk meˈ saweˈnun pī si kalaleman duk teppadanun bi meˈ pokotbin duk kaˈam makaˈeddoˈ kenna.” ");
INSERT INTO yka_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nambung si Simon, paˈinne, “Tuwan, kellawan kami magtuyuˈ saguwaˈ gaˈ niyaˈ taˈeddoˈ kami. Saguwaˈ peggeˈ paˈinnu ne, teppadan kami saˈ.” ");
INSERT INTO yka_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pagubus teppadande meˈ pokotin, ekka teˈed kenna taˈeddoˈde hangkan agen-agen garet pokotden. ");
INSERT INTO yka_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kinawey weˈ de meˈ saweˈde si bangkaˈ seddilihin dinaˈak pī nabangan siye ngonot. Hap pī ne siye duk pinaˈisi weˈ de meˈ kennahin magdem bangkaˈ. Pennoˈ kaduwe bangkaˈin weˈ kenna hangkan agen-agen palenneb. ");
INSERT INTO yka_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagkite si Simon Petros kenna mabanes inin, pasujud iye si antag bettis si Isa duk paˈinne, “O Tuwan, patala kew amban aku peggeˈ aku inin dusehan.” ");
INSERT INTO yka_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Peggeˈ ulaliˈ teˈed iye duk meˈ saweˈnen sabab ekka kenna taˈeddoˈden. ");
INSERT INTO yka_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ulaliˈ du isab meˈ saweˈ si Simon magkennahin, disi Yakub duk Yahiya, meˈ anak si Sebedehin. Manjari paˈin si Isa pu si Simon, “Daˈa kew tinalew. Tinagnaˈan kuweˈitu bahannun mageddoˈ-eddoˈ aˈa pinatuhut si aku.” ");
INSERT INTO yka_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pinatakas weˈ de meˈ bangkaˈden pī si tapiyan, ubus inambanan weˈ de meˈ kēmonden duk nuhut ne siye si Isa. ");
INSERT INTO yka_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Dambuwaˈ ellew sābu si Isa laˈi si dambuwaˈ puweblo, niyaˈ aˈa laˈi lapat weˈ ipul barannen. Pagkite aˈahin si Isa, pasujud iye muyuˈ-muyuˈ, paˈinne, “O Tuwan, bang kew mabayaˈ, tapakawuliˈnu ku.” ");
INSERT INTO yka_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pinasōng weˈ si Isa tangannen duk inantan weˈ ne aˈa inipulin duk paˈinne, “Asal mabayaˈ ku. Kawuliˈan ne kew.” Magtawus ipulnen tahalaˈ. ");
INSERT INTO yka_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Duk sinessaˈan teˈed iye weˈ si Isa, paˈinne, “Daˈa kew magaka-aka bisan pu sine. Saguwaˈ pī kew pakitehanun barannun si imamin duk magkuluban kew sa pangandaˈakan si Musahin, hinang tandaˈ si meˈ aˈahin weˈ asal kawuliˈan ne kew.” ");
INSERT INTO yka_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Saguwaˈ magkasōng bawag aka-aka sabab si Isahin, hangkan banes teˈed aˈa patipun pī si iye pakale si meˈ panoloˈnen duk makipakawuliˈ meˈ sakiden. ");
INSERT INTO yka_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Saguwaˈ bang patekka tahalaˈ si Isa hap pī si antag gaˈi tantu papīhan aˈa, duk missā iye laˈi si Tuhan. ");
INSERT INTO yka_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dambuwaˈ ellew sasang si Isa magtoloˈ, niyaˈ meˈ Pariseo duk meˈ guru si saraˈ āgama Yahudi magtingkoloˈ laˈi si bihingne. Meˈ aˈa inin amban puweblo Awrusalam duk amban meˈ kalumaˈan si lahat Jalil duk Yahudiya. Laˈi balakat Tuhanin pu si Isa hangkan tapakawuliˈne meˈ masakihin. ");
INSERT INTO yka_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Manjari niyaˈ tekka pī meˈ aˈa moˈo lella saki, matey barannen. Miha siye 1ān supaya iye taboˈode padiyalem duk tabettadde si antag si Isa. ");
INSERT INTO yka_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Saguwaˈ hawal ekka aˈahin gaˈ niyaˈ palānande hangkan manaˈik siye pī diyataˈ sapew lumaˈ madatagin duk ilarakan weˈ de sapewin. Ubus pinatuntun weˈ de aˈa masakihin diyataˈ pabākanne pī diyalem si tengngaˈ meˈ aˈahin, si antag si Isa. ");
INSERT INTO yka_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pagtakite si Isa weˈ sandel teˈed siye si iye, paˈinne si aˈa mamatey barannen, “Bagay, taˈampun ne meˈ dusenun.” ");
INSERT INTO yka_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pagkale meˈ guru si saraˈ āgamahin duk meˈ Pariseohin pinaˈin si Isa inin, magtawus siye magtilew-tinilew, paˈinde, “Aˈahey inin? Missā iye kuweˈ Tuhanin iye. Sine makaˈampun dusehin bang dumaˈin dambuwaˈ-buwaˈ Tuhan.” ");
INSERT INTO yka_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kataˈuhan si Isa bang ine pinikilden duk paˈinne si siye, “Weˈey kaˈam magtilew-tilew sa iyan dem ateybi? ");
INSERT INTO yka_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ine mamurahin, pinaˈin, ‘Inampun ne dusenun,’ atawa ‘Dongaˈ kew, bu nu ne lumengngan.’ ");
INSERT INTO yka_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pakoleˈku aˈa inin supaya kataˈuhanbi weˈ aku, Anak Manusiyaˈin, taga kapatut tuˈu si dunya ngampun meˈ duse.” Manjari paˈin si Isa si aˈa mamatey barannen, “Dongaˈ kew. Boˈohun pabākannun bu nu ne hap lumaˈ.” ");
INSERT INTO yka_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Magtawus dongaˈ aˈa masakihin si pagmatahande, bu ineddoˈ weˈ ne pabākannen, duk hap lumaˈ iye, mudji-mudji Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bengngangan siye kēmon duk pinudji weˈ de Tuhanin. Asekan talew isab siye. Magbissā-bissā siye, paˈinde, “Asal hinangan makaˈulaliˈ takitete bi ellew inin!” ");
INSERT INTO yka_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagubus inin, paluwas iye amban kalumaˈan miyaˈan. Niyaˈ takitene aˈa magpāku-pāku sukey para si gubelno, ēnnen si Libi, ningkoloˈ laˈi si upisinane pagbayed-bayedan sukeyin. Paˈin si Isa si iye, “Dayiˈ kew. Nuhut kew aku.” ");
INSERT INTO yka_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Manjari kuwat iye duk inambanan weˈ ne kēmonne malaˈihin duk nuhut ne iye si Isa. ");
INSERT INTO yka_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Manjari magjamu-jamu disi Libi laˈi si lumaˈne pamahadjene si Isa. Ekka teˈed aˈa magpāku-pāku sukey duk meˈ aˈa seddili magtingkoloˈ mangan pasumbayaˈ si siye. ");
INSERT INTO yka_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Niyaˈ meˈ Pariseo duk meˈ guru si saraˈ āgama, meˈ Pariseo du isab siye, gaˈ siye kasulutan hangkan paˈinde si meˈ tindeg si Isahin, “Weˈey kaˈam palamud magkakanan duk meˈ aˈa magpāku-pāku sukeyin duk meˈ aˈa dusehan sinduwehin?” ");
INSERT INTO yka_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Si Isa manambungan siyehin, paˈinne, “Meˈ aˈa saki hep hap doktolin. Bang meˈ makoleˈin gaˈ niyaˈ gunane hap doktol. ");
INSERT INTO yka_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Dumaˈin ku pitu miha meˈ aˈa mabentelin saguwaˈ pitu ku miha meˈ aˈa dusehanin, supaya pagsusunande duk lebbahande ne meˈ duseden.” ");
INSERT INTO yka_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Manjari paˈin meˈ aˈahin pu si Isa, “Meˈ tindeg Yahiyahin daran magpuwase duk ngampun si Tuhan. Damikkiyan isab meˈ tindeg meˈ Pariseohin, bu meˈ tindegnun luwal ne hadja siye mangan duk nginum.” ");
INSERT INTO yka_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sambungan si Isa siye si dalilan. Pasaliˈne meˈ tindegnen si meˈ aˈa si pagkawinan. Paˈinne, “Tadaˈakbi ke meˈ aˈa si pagkawinanin magpuwase samantaˈan laˈi pe si siye pangantin lellahin? Gaˈi! ");
INSERT INTO yka_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Saguwaˈ si sinōng inin bang ineddoˈ ne amban siye pangantin lellahin, meke ne siye muwase.” ");
INSERT INTO yka_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Manjari magdalilan si Isa sabab panoloˈ matuˈuhin duk panoloˈnen. Paˈinne, “Gaˈ niyaˈ aˈa nganggaret badjuˈ baˈahu panopakne pī si badjuˈ andang. Peggeˈ bang sa īˈne, garet ne mabaˈahuhin duk gaˈi isab patalep mabaˈahuhin panopak semmek maˈandangin.” ");
INSERT INTO yka_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pinasaliˈ isab weˈ si Isa toloˈnen si boheˈ ubas baˈahu inisi dem puyuˈ kuwit kambing. Paˈinne, “Gaˈ niyaˈ aˈa ngisi boheˈ ubas baˈahu, mukal-mukal pe, dem puyuˈ andang. Peggeˈ bang sa īˈne buslad puyuˈin weˈ boheˈ ubasin. Manjari buˈus boheˈ ubasin duk magkaˈat puyuˈin. ");
INSERT INTO yka_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Saguwaˈ subey inisi boheˈ ubas baˈahuhin dem puyuˈ baˈahu. ");
INSERT INTO yka_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aˈa mabiyaksa nginum boheˈ ubas tiggel inennaˈ-ennaˈin, gaˈi pihane boheˈ ubas baˈahuhin. Hāp koˈ lessa boheˈ ubas tiggel inennaˈin.” ");
INSERT INTO yka_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Dambuwaˈ Sabtuˈ, ellew liˈi meˈ Yahudi, pabutas si Isa duk meˈ tindegnen dem tanaˈ. Paglabey meˈ tindegnen, ngalupuˈ siye buwaˈ tanaˈin duk pagubus puliyasde, inintaˈ weˈ de. ");
INSERT INTO yka_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Niyaˈ laˈi meˈ Pariseo duk paˈinde, “Weˈey hinangbi tinaggahan saraˈ si ellew liˈihin?” ");
INSERT INTO yka_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nambung si Isa, paˈinne, “Gaˈ ke bakas tabatsabi bang ine hininang Sultan Daˈudin masaley paginusan iye duk meˈ saweˈnen? ");
INSERT INTO yka_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Padiyalem hep iye pī si lumaˈ Tuhanin, duk ineddoˈ weˈ ne pan binettad laˈi pangurung si Tuhanin, duk kinakan weˈ ne, duk inurungan isab weˈ ne meˈ saweˈnen. Bu tinaggahan hep weˈ saraˈ kinakan pan miyaˈan, luwal hadja para si meˈ imam. Saguwaˈ gaˈ du iye makaduse si hininangne miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Duk paˈin si Isa si siye, “Aku, Anak Manusiyaˈin, taga kapatut ku magpaˈin bang ine-ine mapatut hininang si ellew liˈihin.” ");
INSERT INTO yka_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Dambuwaˈ isab ellew liˈi, pī si Isa padiyalem si langgal magusihat. Niyaˈ laˈi aˈa sapik tanganne kanawanin. ");
INSERT INTO yka_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Niyaˈ isab laˈi meˈ guru si saraˈ āgama duk meˈ Pariseo. Miha siye jān duk niyaˈ panuntutande si Isa hangkan pinateng-patengan iye weˈ de bang makoleˈ ke iye si ellew liˈi. ");
INSERT INTO yka_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Saguwaˈ kataˈuhan si Isa bang ine pinikilden duk paˈinne si aˈa masapik tangannen, “Pitu kew nengge tuˈu.” Manjari kuwat iye duk nengge iye laˈi. ");
INSERT INTO yka_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Manjari paˈin si Isa si meˈ aˈahin, “Tilewte kaˈam, bang dem saraˈ, ine mapatut hininang si ellew liˈihin, hinangan makahāp atawa hinangan makalaˈat? Nimbul aˈa atawa mapatey?” ");
INSERT INTO yka_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pinayaman siye kēmon weˈ si Isa paliput. Manjari paˈinne si aˈahin, “Pahintengun tangannun.” Na, pinahinteng weˈ ne, manjari kawuliˈan ne tangannen. ");
INSERT INTO yka_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Saguwaˈ astel teˈed manamal meˈ Pariseohin duk meˈ guru si saraˈ āgamahin hangkan magisun siye bang inumeyde pu si Isahin. ");
INSERT INTO yka_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Masa īˈ, pataked si Isa pī si kakūdan missā si Tuhan. Laˈi iye kellawan ngampun si Tuhan. ");
INSERT INTO yka_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagellew ne, ilinganan weˈ ne meˈ tindegnen pī si iye duk meneˈ iye sampūˈ duk duwe, ēnanne siye meˈ aˈa kawakilan. ");
INSERT INTO yka_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Meˈ aˈa tapeneˈnen inin: si Simon, inēnan isab Petros weˈ si Isa, duk Andariyas pungtinaˈi si Simonin, si Yakub duk si Yahiya, si Pilip duk Bartolome, ");
INSERT INTO yka_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo duk si Tomas, si Yakub anak Alpahin duk si Simon iye ēnande Pangangatuhin, ");
INSERT INTO yka_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas anak si Yakub duk si Judas Iskariyot, iye mamuddihan si Isahin si pasōngan. ");
INSERT INTO yka_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Manjari puwas miyaˈan padurul si Isa duk meˈ tindegne bakas kawakilannen. Nengge iye laˈi si kadatagan. Banes meˈ tindegne sinduwehin tipun laˈi duk banes isab aˈa ngagad-ngagad laˈi amban kēmon kalahat-lahatan si Yahudiya duk amban puweblo Awrusalam duk amban meˈ puweblo Tiros duk Sidon si higad tahikin. ");
INSERT INTO yka_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pī siye pakale si meˈ panoloˈ si Isahin duk makipakawuliˈ meˈ sakiden. Duk sasuku isab siye pasayedan seyitanin, pinaluwas weˈ si Isa seyitanin. ");
INSERT INTO yka_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Duk kēmon meˈ aˈa mabanesin, inapas ne paˈin weˈ de si Isa inabut duk tangande, peggeˈ niyaˈ balakat paluwas amban baranne hangkan kawuliˈan siye kēmon. ");
INSERT INTO yka_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Manjari pinayaman weˈ si Isa meˈ tindegnen duk paˈinne, “Hāp pe kaˈam meˈ makaˈaseˈ-aseˈin, peggeˈ pagbayaˈan kaˈam weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Hāp pe kaˈam meˈ maˈinusan kuweˈituhin peggeˈ dinuhulan du kaˈam si pasōngan. “Hāp pe kaˈam meˈ magtangis kuweˈituhin peggeˈ magsaye du kaˈam si pasōngan. ");
INSERT INTO yka_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Hāp pe kaˈam bang kaˈam kabunsihan aˈa, duk bang gaˈi kaˈam tayimaˈde, duk bang bissā-bissāhande duk pakaˈatande kaˈam si meˈ saweˈbin peggeˈ nuhut kaˈam aku, Anak Manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sa iyan du hep isab hininang meˈ kamatettoˈahanden si meˈ kanabihanin. Bang tekka ellew kaˈumantagne inin si kaˈam, magkēg kaˈam manamal duk palaksu du kaˈam hawal kēgbin peggeˈ hadje panumbas kaˈamin si surgaˈ. ");
INSERT INTO yka_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Saguwaˈ kaˈam, meˈ madayahan kuweˈituhin, makaˈaseˈ-aseˈ kaˈam peggeˈ talabeybi ne pāsahan mahāpin tuˈu si dunya. ");
INSERT INTO yka_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Kaˈaseˈ-aseˈ kaˈam meˈ magduhul kuweˈituhin, peggeˈ niyaˈ iyan waktu si pasōngan kaˈinusanan du kaˈam. “Kaˈaseˈ-aseˈ kaˈam meˈ magsaye kuweˈituhin peggeˈ niyaˈ iyan waktu si pasōngan magsugul kaˈam duk magtangis. ");
INSERT INTO yka_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kaˈaseˈ-aseˈ kaˈam bang kēmon aˈa nanglitan kaˈam, peggeˈ kuweˈ du kaˈam meˈ nabi gaˈi bennal matuˈuley sinanglitan weˈ meˈ kapapuˈanbin.” ");
INSERT INTO yka_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Saguwaˈ kaˈam meˈ mapakale si akuhin, inin paˈinku si kaˈam: Kalasahanun bi bantabin. Maghinang hāp kaˈam si meˈ mabunsi si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Māku-māku kaˈam kahāpan para si meˈ manuknaˈan kaˈamin duk ngampun kaˈam para si meˈ mangalaˈat kaˈamin. ");
INSERT INTO yka_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bang niyaˈ nampak luwenun dambiyaˈ, patampalun isab pī si iye dambiyaˈin ambat sampakne. Bang niyaˈ ngeddoˈ jaketnun, pasagadanun bisan eddoˈne badjuˈnun. ");
INSERT INTO yka_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Sine-sine mākuhan kaˈu, urunganun. Duk bang niyaˈ ngeddoˈ kēmonnun, daˈa ne pākuhun balik. ");
INSERT INTO yka_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Duk ine-ine kabayaˈanbi hinang aˈa si kaˈam, damikkiyan isab hinangun bi si siye. ");
INSERT INTO yka_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Bang iye hadja kinalasahanbin meˈ mamalasa si kaˈamin, niyaˈ ke pananglitan kaˈam? Gaˈ. Peggeˈ bisan meˈ aˈa dusehanin, kalasahande du meˈ mamalasa si siyehin. ");
INSERT INTO yka_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Duk bang iye hadja tinabanganbin meˈ makatabangan kaˈamin, niyaˈ ke pananglitan kaˈam? Gaˈ. Peggeˈ bisan meˈ aˈa dusehanin sa iyan du isab addatden. ");
INSERT INTO yka_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Duk bang iye hadja pinasambiˈanbin meˈ taˈase-asebi maniyaˈ pagbayedden, niyaˈ ke pananglitan kaˈam? Gaˈ niyaˈ. Peggeˈ bisan meˈ aˈa dusehanin masambiˈ du si pagkaside dusehan, ngase-ngase weˈ kabayedan du siye balik pamasambiˈden. ");
INSERT INTO yka_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Saguwaˈ iye inin pamanoloˈku si kaˈamin: Kalasahanun bi bantabin duk tabanganun bi siye. Bang niyaˈ ngutang si kaˈam, paˈutanganun bi, daˈa kaˈam ngase-ngase bayednen. Bang hinangbi inin, hadje pahalaˈ tasangkabin duk manjari meˈ anak Tuhanin ne kaˈam. Peggeˈ hāp iye bisan si meˈ aˈa malaˈatin duk si meˈ aˈa manggaˈi magsukulin. ");
INSERT INTO yka_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Subey kaˈam maˈaseˈ kuweˈ Samabin du isab maˈaseˈ.” ");
INSERT INTO yka_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Daˈa kaˈam ngandiyawaˈan saweˈbi duk kaˈam gaˈi hukum Tuhanin. Daˈa kaˈam magpaˈin weˈ saweˈbin subey ilegga, duk kaˈam gaˈi legga Tuhanin. Ampunun bi saweˈbin duk isab kaˈam ampun Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ngurung kaˈam duk kaˈam urungan Tuhanin. Dalilnen takesan hāp, dinasek duk jinedjeg pe duk pinennoˈan sampay māsey, iye pinabuˈus piyu si kaˈamin. Ekkahan pangurungbin iye du isab ekkahan pangurung Tuhan si kaˈamin.” ");
INSERT INTO yka_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Inakahan isab siye weˈ si Isa dambuwaˈ dalilan, paˈinne, “Makajari ke aˈa pessekin nundan aˈa pessek isab? Gaˈi ke siye kaduwangan laboˈ pī dem lowang? ");
INSERT INTO yka_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mulidin gaˈi palabi kataˈunen amban gurunen. Saguwaˈ bang jukup ne pangadjiˈnen, magsaliˈ ne iye duk gurunen. ");
INSERT INTO yka_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kaˈu mangandiyawaˈan saweˈnun,” paˈin si Isa, “weˈey iye tatīknun hapak-hapak dem mata saweˈnun, bu kaˈu batang kayu dem matanun, bu gaˈi tatīknu. ");
INSERT INTO yka_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Saˈingge kapagpaˈinnu si saweˈnun, ‘Bagay, tuhun koˈ, ānante hapak-hapak dem matanu lu,’ bang gaˈi kitenu batang kayu dem di matanun? Kaˈu iyan magmā-mā hadja. Ānanun dahuˈ batang kayuhin amban dem matanu iyan, ubus pastiˈ ne pamayamnun ngānan hapak-hapak dem mata saweˈnun.” ");
INSERT INTO yka_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Paˈin si Isa pe, “Kayu mahāpin gaˈi buwaˈ gaˈi hāp duk kayu manggaˈi mahāpin gaˈi buwaˈ hāp. ");
INSERT INTO yka_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kayuhin kataˈuhan si buwaˈne. Gaˈi kite bi mageddoˈ buwaˈ biyabas amban puhung atawa buwaˈ buwahan amban sampinit. ");
INSERT INTO yka_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Manusiyaˈin kuweˈ dalil kayuhin du isab. Aˈa mahāpin hāp kawul-piˈilnen duk hāp bissānen peggeˈ hāp dem ateynen. Saguwaˈ aˈa malaˈatin, peggeˈ laˈat dem ateynen hangkan gaˈi hāp kawul-piˈilnen duk bissānen. Ine-ine dem atey manusiyaˈ, iye miyaˈan mapaluwas amban behenen.” ");
INSERT INTO yka_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Weˈey paˈinbi weˈ aku Panuhutanbin, bu gaˈi du hinangbi meˈ pangandaˈakanku kaˈamin? ");
INSERT INTO yka_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sasuku pitu si aku duk pakalene meˈ bissākun duk tuhutne, pahātihanku si kaˈam bang kuweˈ sine iye. ");
INSERT INTO yka_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kuweˈ iye aˈa maghinang lumaˈ. Ngalowang iye pinalalem sampay niyaˈ batu taˈabutne. Ubus pinatengge weˈ ne meˈ olom lumaˈnen diyataˈ batuhin. Pagubus lumaˈin, dunuk boheˈin duk taˈabut lumaˈin weˈ lasey mabasagin saguwaˈ gaˈ usaˈ lumaˈnen peggeˈ hāp pamatenggehan iyehin. ");
INSERT INTO yka_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na, bang aˈahin pakale si meˈ bissākun bu gaˈi du tuhutne, kuweˈ iye aˈa maghinang lumaˈ, saguwaˈ gaˈ kalihanne meˈ olomin duk gaˈ patenggene diyataˈ batu. Pagtekka lasey mabasagin, magtawus hebbaˈ duk jadjag teˈed lumaˈin.” ");
INSERT INTO yka_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagubus inin kēmon bissā si Isa si meˈ aˈahin, pī iye si puweblo Kapernaum. ");
INSERT INTO yka_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na, laˈi si puweblo miyaˈan niyaˈ dambuwaˈ kapitan si armi bangsa Roma. Niyaˈ daraˈakanne lella legget manamal duk sōng matey ne. Asal kalasahanne teˈed daraˈakanne inin. ");
INSERT INTO yka_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pagkale kapitanin sabab si Isa, ngandaˈak iye meˈ bahiˈ meˈ Yahudihin pī pu si Isa nilew iye, bang makajari iye pī makoleˈ daraˈakanne miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pagtekkade laˈi pu si Isa, boˈode teˈed iye duk paˈinde, “Pataˈ teˈed tabangannu kapitan miyaˈan, ");
INSERT INTO yka_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","peggeˈ pabagay teˈed iye si bangsate bi Yahudi duk iye hep maggastuhin pamatengge langgalte bi si puweblo inin.” ");
INSERT INTO yka_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Manjari nuhut siye ne si Isa. Pagtapit ne siye si lumaˈ, ngandaˈak kapitanin meˈ bagayne pī pasampang pu si Isa moˈo bissānen, pinaˈin, “Tuwan, daˈa ne kew mapekkengan dinu peggeˈ gaˈi ku pataˈ papituhannu si lumaˈku. ");
INSERT INTO yka_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Peggeˈ bangsahan kew teˈed, hangkan pikilku gaˈi ku isab pataˈ paguwaˈ piyu si kaˈu. Saguwaˈ missā kew hadja duk koleˈ du daraˈakankun. ");
INSERT INTO yka_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kataˈuhanku peggeˈ bisan aku inin, pagbayaˈan ku weˈ malangkew amban akuhin duk magbayaˈ ku si meˈ sundalukun. Bang paˈinku si dangan, ‘Pī kew,’ pī iye. Bang paˈinku si seddili, ‘Pitu kew,’ pitu iye. Duk bang paˈinku si daraˈakankun, ‘Hinangun inin,’ hinangne.” ");
INSERT INTO yka_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pagkale si Isa inin, ulaliˈ iye si binissā kapitanin. Manjari hinarap weˈ ne meˈ aˈa mabanes mapatuhut si dambulihannen, duk paˈinne si siye, “Akahante kaˈam, bisan si bangsa Israˈil gaˈ ku bakas makadugpak aˈa kuweˈ kapitan miyaˈan asal sandel manamal.” ");
INSERT INTO yka_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Manjari balik ne meˈ aˈa bakas dinaˈak kapitanin duk pagtekkade si lumaˈ, takitede daraˈakanin koleˈ ne. ");
INSERT INTO yka_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Gaˈ du tiggel puwas miyaˈan, hap pī si Isa si dambuwaˈ puweblo inēnan Nain. Nuhut iye meˈ tindegnen duk banes teˈed meˈ aˈa patuhut si iye. ");
INSERT INTO yka_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pagtekka ne siye si tarangka paˈasekan hap puweblo miyaˈan, niyaˈ meˈ aˈa magtanggung aˈa matey binoˈo paluwas pī si pagkubulan. Lella mamatey miyaˈan anak dambuwaˈ-buwaˈ du duk saˈinen balu ne. Banes aˈa amban puweblo miyaˈan nuhut baluhin pī ngubul anaknen. ");
INSERT INTO yka_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pagkite si Isa, Panuhutanin, dende balu miyaˈan, maˈaseˈ teˈed iye si dendehin duk paˈinne si iye, “Daˈa ne kew magtangis, dende.” ");
INSERT INTO yka_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ubus pasōng iye duk inantanan weˈ ne tanggunganin hangkan padeheng meˈ aˈa magtanggungin. Manjari paˈinne, “Bagay, dongaˈ kew.” ");
INSERT INTO yka_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Magtawus aˈa mamateyin ellum balik duk ningkoloˈ iye duk missā. Duk dinaˈak ne iye weˈ si Isa ineddoˈ si saˈinen. ");
INSERT INTO yka_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kēmon aˈa malaˈihin asekan talew duk pinudji weˈ de Tuhanin. Paˈinde, “Niyaˈ nabi balakatan tuˈu si kite bi! Taˈesseb Tuhanin du kite bi meˈ aˈanen.” ");
INSERT INTO yka_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bawag bakas hininang si Isa inin si meˈ kalahatan si Yahudiya duk si meˈ kalahatan mapaliputin. ");
INSERT INTO yka_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kaˈakahan isab Yahiya weˈ meˈ tindegnen sabab meˈ hinangan si Isahin. ");
INSERT INTO yka_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Manjari ngalingan iye duwangan meˈ tindegne duk daˈakne siye pī pu si Isa, Panuhutanin, nilew iye bang iye ne ke bakas pinaˈal mapitu si dunyahin atawa bang niyaˈ pe ke seddili amban iye subey ase-asede pitu. ");
INSERT INTO yka_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pagtekka duwanganin pī pu si Isa, paˈinde, “Dinaˈak kami pitu si kaˈu weˈ Yahiya magpandi-pandi aˈahin peggeˈ batang kataˈuhanne bang kaˈu ne ke bakas pinaˈal mapitu si dunyahin atawa bang niyaˈ pe ke seddili subey ase-ase kami pitu.” ");
INSERT INTO yka_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Papīden sābu si Isa miyaˈan magpakawuliˈ meˈ aˈa ekka taga saki bayuˈ-bayuˈan, duk pasayedan seyitan. Ekka isab meˈ aˈa pessek ngite balik weˈ ne. ");
INSERT INTO yka_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Manjari sambungan si Isa duwangan tindeg Yahiyahin, paˈinne, “Pī ne kaˈam duk akahanun bi Yahiya meˈ bakas takitebi hininangkun duk bakas takalebi binissākun. Akahanun bi iye weˈ ngite ne meˈ mapessekin, meˈ kukuˈin lumengngan ne, meˈ inipulin kawuliˈan ne, meˈ mabisuhin makakale ne, meˈ mamateyin ellum balik, duk minahalayak ne aka-aka mahāpin si meˈ aˈa makaˈaseˈ-aseˈin. ");
INSERT INTO yka_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Duk kēgan du sasuku gaˈi magduwe-duwe si akuhin.” ");
INSERT INTO yka_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Paglumikut ne meˈ dinaˈak Yahiyahin, missā si Isa si meˈ aˈa mabanesin sabab Yahiya. Paˈinne, “Ine teˈ bakas kabayaˈanbi pinayamanin papībi pu si Yahiya si lahat makagindew-gindewin? Kabayaˈanbin ke mayaman aˈa gaˈi teteg pamikilnen kuweˈ dalil udjung-udjung magpalehan weˈ baliyu? Dumaˈin? ");
INSERT INTO yka_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na, ine teˈ kabayaˈanbi pinayaman mapīhin? Aˈa magsemmek mahalgaˈ? Meˈ aˈa magsemmek mamahalgaˈin duk maparasahan teˈedin laˈi patennaˈanden dem astanaˈ. ");
INSERT INTO yka_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na, ine teˈ pinayamanbi mapīhin? Nabi? Aweˈ, akahante kaˈam, nabi takitebin pasōng amban nabi sinduwehin. ");
INSERT INTO yka_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Si Yahiya hep inin aˈa sinulat dem kitabin, pinaˈin laˈi, ‘Paˈin Tuhanin: Daˈakku pī pamasanankun dehellu amban kaˈu duk memesne 1ānnun.’ ");
INSERT INTO yka_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Akahante kaˈam,” paˈin si Isa, “gaˈ niyaˈ aˈa bakas inanakan tuˈu si dunya bangsahan amban Yahiya inin. Saguwaˈ dem pagbayaˈan Tuhanin, bisan aˈahin diyawaˈ teˈed pagaˈanen, bangsahan pe iye amban Yahiya.” ");
INSERT INTO yka_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kēmon meˈ aˈahin duk pasōng pe meˈ magpāku-pāku sukeyin, pakale teˈed pu si Isa. Siye inin bakas makipandi pu si Yahiya peggeˈ kahagad siye weˈ Tuhanin bentel. ");
INSERT INTO yka_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Saguwaˈ meˈ Pariseohin duk meˈ guru si saraˈ āgamahin, gaˈ siye makipandi pu si Yahiya peggeˈ gaˈi siye mabayaˈ nuhut kinabayaˈan Tuhan para si siyehin. ");
INSERT INTO yka_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Manjari paˈin si Isa, “Ine pangandalilku meˈ aˈa maˈellum kuweˈitu inin? Kuweˈ ine siye? ");
INSERT INTO yka_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kuweˈ siye dalil mākanak magtingkoloˈ si tabuˈan magdagey magkawin duk magkubul. Maglingan siye si saweˈden, paˈinde, ‘Magtambu1 kami si kaˈam saguwaˈ gaˈ du kaˈam mansak. Magmatey kami saguwaˈ gaˈ du kaˈam magtangis.’ ");
INSERT INTO yka_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kaˈam kuweˈ meˈ mākanak miyaˈan. Peggeˈ pitu Yahiya magpandi-pandi aˈahin, bu daran iye muwase duk gaˈi iye nginum makalango, paˈinbi weˈ pasayedan seyitan iye. ");
INSERT INTO yka_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ubus aku, Anak Manusiyaˈin, pitu ku bu mangan ku duk nginum, paˈinbi, ‘Payamanun bi aˈa iyan, dahagaˈ teˈed duk palalango. Meˈ bagaynen meˈ aˈa magpāku-pāku sukey duk meˈ aˈa dusehan sinduwehin.’ ");
INSERT INTO yka_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Saguwaˈ,” paˈin si Isa, “meˈ aˈa manuhut Tuhanin naksiˈ weˈ lalem teˈed kataˈu Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Dambuwaˈ ellew binoˈo si Isa weˈ dambuwaˈ meˈ Pariseohin pī si lumaˈne mangan. Pī ne si Isa duk ningkoloˈ iye sōng mangan. ");
INSERT INTO yka_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na, niyaˈ dende si puweblo miyaˈan bawag weˈ dusehan. Pagkataˈuhan dende inin weˈ īˈ si Isa si lumaˈ Pariseo miyaˈan mangan, pī iye moˈo isellan bengngi mahalgaˈ. Pangisihannen hininangin batu alabaster. ");
INSERT INTO yka_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pī iye nengge si antag bettis si Isa nangis duk basseˈ ne bettis si Isahin weˈ boheˈ matanen. Manjari pinunasan weˈ ne duk bulu kōkne duk inūkan weˈ ne bettis si Isahin, ubus bu tinataˈan weˈ ne duk isellan bengngi mahalgaˈin. ");
INSERT INTO yka_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pagkite inin weˈ Pariseo mamoˈo si Isahin, paˈinne dem ateyne, “Bang toˈo si Isa inin nabi, kataˈuhanne siˈ bang sine dende mangantan bettisne inin. Kataˈuhanne siˈ weˈ dende inin dusehan.” ");
INSERT INTO yka_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Manjari missā si Isa si iye, paˈinne, “Simon, niyaˈ batang paˈinku si kaˈu.” “Ine Tuwan,” paˈin si Simon. ");
INSERT INTO yka_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Manjari paˈin si Isa, “Niyaˈ duwangan aˈa saliˈ-saliˈ taga utang si dambuwaˈ aˈa. Dambuwaˈin utangnen lime hatus pilak duk dambuwaˈin limempūˈ pilak. ");
INSERT INTO yka_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Peggeˈ gaˈ niyaˈ pamayedde, paˈin aˈa pangutanganden, ambat ne bisan ne siye gaˈi magbayed. Na, bang si kaˈu, sine si duwangan miyaˈan asal malasa teˈed si aˈa bakas pangutanganden?” ");
INSERT INTO yka_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nambung si Simon, paˈinne, “Araˈ-araˈku aˈa maˈekka utangnen, iye miyaˈan mamalasa teˈed si iyehin.” “Tewwaˈ sambungnu iyan,” paˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Manjari paharap si Isa si dendehin duk paˈinne pu si Simon, “Kitenu dende inin? Pitu ku dem lumaˈnu ensiniˈ, gaˈ ku bisan panyapannu boheˈ pangosoˈku bettisku. Saguwaˈ dende inin kinosoˈan weˈ ne bettiskun duk boheˈ matane duk pinunasan weˈ ne duk bulu kōkne. ");
INSERT INTO yka_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gaˈ ku ūkannu sa addatten bi saguwaˈ dende inin, kemuwe padiyalem ku pitu, gaˈ iye bakas pahali ngūkan bettiskun. ");
INSERT INTO yka_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gaˈ isellanannu kōkkun pangaddatnu aku, saguwaˈ dende inin isellan bengngi mahalgaˈ pe pangalatagne bettiskun. ");
INSERT INTO yka_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hangkan akahante kew, dende inin hadje lasane si akuhin peggeˈ dusene maˈekkahin taˈampun ne. Bang kulang du duse aˈa taˈampunin, kulang du isab lasa pinakitehannen.” ");
INSERT INTO yka_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Manjari paˈinne si dendehin, “Taˈampun ne meˈ dusenun.” ");
INSERT INTO yka_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Meˈ saweˈ si Isa magtingkoloˈ si lamisahanin magtilew dem ateyde, “Aˈahey inin, ngampun meˈ duse?” ");
INSERT INTO yka_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Saguwaˈ paˈin si Isa si dendehin, “Timbul ne kew peggeˈ sandel kew si aku. Pī ne kew, daˈa kew suse.” ");
INSERT INTO yka_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Gaˈ du tiggel puwas miyaˈan, ilatag weˈ si Isa meˈ puweblohin duk kalumaˈanin magmahalayak aka-aka hāp sabab pagbayaˈ Tuhan si meˈ aˈahin. Nuhut iye tindegne sampūˈ duk duwehin. ");
INSERT INTO yka_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Niyaˈ isab meˈ dende nuhut iye. Meˈ dende miyaˈan, niyaˈ siye bakas pakawuliˈ si Isa sakiden. Niyaˈ isab bakas pasayedan seyitan ubus bu paluwas si Isa meˈ seyitanin. Dambuwaˈ meˈ dende inin si Mariyam, dende amban Magdala, bakas paluwasan seyitan pituˈin. ");
INSERT INTO yka_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Sinduwehin si Joˈanna, anda si Kusa kapatas meˈ daraˈakan Sultan Herodin, duk si Susanna, duk ekka pe meˈ dende seddili. Siye ne inin mangatasan disi Isahin. ");
INSERT INTO yka_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dambuwaˈ ellew pagbanes aˈa patipun pu si Isa, duk magkatekka siye amban meˈ kalumaˈanin, missā si Isa si siye magdalilan. Paˈinne, ");
INSERT INTO yka_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Niyaˈ aˈa pī si tanaˈne magsabulak binihiˈ. Pagsabulakne, niyaˈ binihiˈ tapisik si lān. Manjari tadiˈik-diˈik duk pī meˈ manuk-manukin manganne. ");
INSERT INTO yka_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Meˈ binihiˈ sinduwehin laboˈ diyataˈ batu pānas, duk sakaliˈ ne tomoˈ, lanes peggeˈ gaˈi paˈessepan boheˈ. ");
INSERT INTO yka_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sinduwehin laboˈ dem kasampinitan, duk nuhut nulig sampinitin manjari katalungan tinanemin. ");
INSERT INTO yka_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Niyaˈ isab meˈ binihiˈ sinduwehin laboˈ si kahāpan bulak. Meˈ binihiˈ inin tomoˈ duk nulig duk moˈo buwaˈne. Ekka manamal jarihannen.” Manjari missā si Isa, paˈinne, “Amey-amey pakalehun bi bang niyaˈ pinaˈin si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tinilew si Isa weˈ meˈ tindegnen bang ine hāti dalilan miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Paˈinne, “Kaˈurungan ne kaˈam kataˈu, supaya tahātibi meˈ tinapukan Tuhan dem pikilannen sabab bang saˈingge pagbayaˈne si meˈ aˈanen. Saguwaˈ si meˈ aˈa sinduwehin inaka kēmon si dalilan, supaya payamande saguwaˈ gaˈi takitede, duk supaya takalede saguwaˈ gaˈi tasabutde.” ");
INSERT INTO yka_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Na, iye inin hāti dalilan miyaˈan,” paˈin si Isa. “Binihiˈin lapal Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Meˈ kasabulakan si lānin, dalil meˈ aˈa makakale lapal Tuhanin, manjari pī nakuraˈ seyitanin ngagew lapalin amban dem pikilande supaya siye gaˈi kahagad duk gaˈi siye timbul. ");
INSERT INTO yka_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Duk meˈ kasabulakan diyataˈ batu pānasin, dalil meˈ aˈa makakale lapal Tuhanin duk magtawus kahagadde duk kēgan siye. Saguwaˈ kuweˈ siye dalil binihiˈ gaˈ nganggamut. Kahagad siye daddaliˈ saguwaˈ pagtekka sassatin, gaˈi ne siye kahagad. ");
INSERT INTO yka_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Duk meˈ binihiˈ malaboˈ dem kasampinitanin, dalil meˈ aˈa makakale lapal Tuhanin saguwaˈ sābude mapasōngin, ekka makasuse siye duk alal siye weˈ meˈ alataˈden duk sinna siye magadjak. Kuweˈ siye dalil meˈ tinanem katalungan duk gaˈ abutan toˈe buwaˈden. ");
INSERT INTO yka_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Duk meˈ sinabulakan dem bulak mahāpin, dalil meˈ aˈa makakale lapal Tuhanin, ateyden hāp duk lunuk. Ellegde teˈed lapalin dem ateyde duk magtuyuˈ teˈed siye nuhutne, hangkan dalil tinanemin buwaˈ siye, hātinen hāp kaˈujudanden.” ");
INSERT INTO yka_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Paˈin si Isa pe, “Gaˈ niyaˈ aˈa mekketan payitaˈan ubus bu lekkebanne duk palanggana atawa papīne diyawaˈ kantil. Saguwaˈ papīne payitaˈanin diyataˈ tengenanne, supaya meˈ aˈa mapadiyalemin kitede dantaˈin. ");
INSERT INTO yka_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Peggeˈ gaˈ niyaˈ tinapukan kuweˈitu weˈ gaˈi ujud pinaguwaˈ si pasōngan, duk kēmon manggaˈi tahāti kuweˈituhin, ujud kataˈuhan du si pasōngan. ");
INSERT INTO yka_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hangkan pakalehun bi pahāp-hāp. Peggeˈ sine-sine makasabut, inurungan du iye duk tasabutne namba. Saguwaˈ sine-sine gaˈi makasabut, bisan kannalne niyaˈ kuweˈahat tasabutne, inānan du amban iye.” ");
INSERT INTO yka_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Manjari tekka pī saˈi si Isahin duk meˈ pungtinaˈine lellahin, saguwaˈ gaˈ siye tumapit si iye hawal ekka aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Niyaˈ ngakahan si Isa, paˈinne, “Tuwan, īˈ saˈinun duk meˈ pungtinaˈinun si bukut duk batang kew kitede.” ");
INSERT INTO yka_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Paˈin si Isa si meˈ aˈa malaˈihin, “Sasuku pakale duk nuhut lapal Tuhanin, siye iyan saˈiku duk meˈ pungtinaˈiku.” ");
INSERT INTO yka_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Dambuwaˈ ellew pasakey si Isa duk meˈ tindegnen dem bangkaˈ duk paˈinne si siye, “Sūng kite bi pī palipag si dambiyaˈ lamew.” Hangkan patulak ne siye. ");
INSERT INTO yka_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sasangde mapīhin tumuli si Isa. Bessuwang nihup baliyu mabasagin duk sōng pennoˈ ne bangkaˈden weˈ boheˈ, hangkan piligdu siye palenneb. ");
INSERT INTO yka_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pī siye mangun si Isa, paˈinde, “O Tuwan, matey kite bi inin!” Manjari dongaˈ si Isa duk pinadeheng weˈ ne baliyuhin duk meˈ goyak mabasagin. Magtawus ne padeheng baliyuhin duk teddoˈ ne lamewin. ");
INSERT INTO yka_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ubus paˈin si Isa si meˈ tindegnen, “Weˈey kaˈam gaˈi ngandel si aku?” Tinalew siye duk ulaliˈ teˈed siye. Magtilew-tilew siye, paˈinde, “Aˈahey inin? Tadaˈakne bisan baliyuhin duk goyakin duk tuhutde pangandaˈakannen.” ");
INSERT INTO yka_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Manjari palanjal siye palipag duk tekka siye si lahat Gerasa, magantag du duk lahat Jalil. ");
INSERT INTO yka_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pagduwaˈi si Isa amban dem bangkaˈ, niyaˈ pasampang si iye dambuwaˈ aˈa amban puweblo lahat miyaˈan pasayedan meˈ seyitan. Tiggel ne iye gaˈ magsemmek duk patennaˈannen dumaˈin si lumaˈ saguwaˈ si meˈ lingab pagkubulan. ");
INSERT INTO yka_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pagkitene si Isa, magkolehak iye duk pasujud iye si dehelluhan si Isa duk maggasud iye, paˈinne, “Gaˈ niyaˈ lamudnu si aku, Isa. Kaˈu Anak Tuhanin, iye Tuhan Tamanan Malangkewin. Junjungku si kaˈu, daˈa ku binasahun.” ");
INSERT INTO yka_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Missā iye sa miyaˈan peggeˈ dinaˈak hep weˈ si Isa seyitanin paluwas amban iye. Matuˈuhin daran ne hep iye pagbayaˈan weˈ seyitanin duk bisan iye iningketan duk karena duk binanteyan weˈ meˈ aˈa, ujud bekkat du weˈ ne karenahin duk binoˈo iye tahalaˈ weˈ seyitanin pī si lahat makagindew-gindew. ");
INSERT INTO yka_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Manjari tinilew iye weˈ si Isa, paˈinne, “Sine ēnnun?” Nambung iye, paˈinne, “Ēnkun si Ibuhan.” Peggeˈ ekka hep seyitan mapaˈasek si aˈa miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Duk pabuyuˈ-buyuˈ teˈed meˈ seyitanin pu si Isa, gaˈi siye makipapī dem narkaˈ. ");
INSERT INTO yka_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Niyaˈ magsungkal laˈi diyataˈ bīd panenan bawi, ekka manamal. Pabuyuˈ-buyuˈ meˈ seyitanin pu si Isa weˈ paˈasek siye pī dem meˈ bawihin. Dinaˈak ne siye weˈ si Isa. ");
INSERT INTO yka_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Manjari paluwas meˈ seyitanin amban aˈahin duk padiyalem siye pī magdem baran meˈ bawihin. Magtawus panenan bawihin magubas padurul pī si pampang magdem lamew duk lambo siye kēmon. ");
INSERT INTO yka_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pagkite meˈ aˈa magipat bawihin maˈumantag inin, magubas siye duk magaka-aka siye laˈi si puweblo duk si meˈ lahat diyataˈ. ");
INSERT INTO yka_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Manjari pī meˈ aˈahin mayaman bakas maˈumantag miyaˈan. Pagtekkade laˈi pu si Isa, takitede aˈa bakas pasayedan seyitanin ningkoloˈ laˈi si bihing bettis si Isa. Magsemmek ne iye duk hāp ne pikilannen. Manjari tinalew siye. ");
INSERT INTO yka_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ubus inaka-akahan ne siye weˈ meˈ aˈa bakas mangitehin bang saˈingge pamakawuliˈ si Isa aˈa bakas pasayedan seyitanin. ");
INSERT INTO yka_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Manjari kēmon meˈ aˈa miyaˈan, meˈ amban kalahat-lahatan laˈi si Gerasa, dinaˈak weˈ de si Isa tahalaˈ peggeˈ paˈasekan talew teˈed siye. Hangkan pasakey si Isa dem bangkaˈ duk sōng patulak ne. ");
INSERT INTO yka_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aˈa makawuliˈanin pabuyuˈ-buyuˈ nuhut iye. Saguwaˈ papoleˈ si Isa iye, paˈinne, ");
INSERT INTO yka_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Hap lumaˈ ne kew duk magaka-aka kew si meˈ aˈahin sabab hinangan hadje tahinang Tuhan si kaˈuhin.” Manjari lumengngan ne aˈahin duk ilatag weˈ ne puweblohin magaka-aka sabab hinangan hadje bakas tahinang si Isa si iyehin. ");
INSERT INTO yka_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pagbalik si Isa si dambiyaˈ lamew, sinna meˈ aˈahin pasampang si iye peggeˈ inagad-agad hep iye weˈ de. ");
INSERT INTO yka_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Niyaˈ tekka pī si iye dambuwaˈ nakuraˈ si langgal lahat miyaˈan, ēnnen si Jairus. Pasujud iye si antag bettis si Isa duk pabuyuˈ-buyuˈ teˈed iye moˈo si Isa si lumaˈne. ");
INSERT INTO yka_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Peggeˈ niyaˈ anakne dende dambuwaˈ-buwaˈ, sampūˈ duk duwen tahun umulnen, legget manamal duk sōng matey ne. Nuhut si Isa iye. Sasangde mapīhin, taligpit ne si Isa weˈ meˈ aˈa mabanes mapatuhut si iyehin. ");
INSERT INTO yka_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Niyaˈ laˈi dem kaˈekkahan aˈahin dambuwaˈ dende saki, luwal paguwaˈan lahaˈ. Sampūˈ duk duwen tahun ne kemuwe kasakinen. Ubus ne tagastune kēmon sīnnen si meˈ doktol, saguwaˈ gaˈ niyaˈ makakawuliˈ iye. ");
INSERT INTO yka_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pī iye patapit si bukutan si Isa, duk inantan weˈ ne tuggu badjuˈ si Isahin. Magtawus padeheng paglahaˈnen. ");
INSERT INTO yka_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Sine bakas mangantan akuhin?” paˈin si Isa. Maggaˈ siye kēmon. Manjari paˈin si Petros, “Tuwan, kabanes meˈ aˈa mapalaray si kaˈu inin, magtilew pe kew?” ");
INSERT INTO yka_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Saguwaˈ paˈin si Isa, “Asal niyaˈ bakas ngantan aku, peggeˈ talessaku weˈ niyaˈ balakat paguwaˈ amban dem baranku.” ");
INSERT INTO yka_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sakaliˈ kataˈuhan dendehin weˈ gaˈi katapukanne bakas hininangne miyaˈan, patapit iye pī migpid duk pasujud iye si antag bettis si Isa. Duk inakahan weˈ ne si Isa si pakalehan meˈ aˈahin bang weˈey iye antanne, duk inakahan isab weˈ ne weˈ kawuliˈan iye magtawus. ");
INSERT INTO yka_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Paˈin si Isa si iye, “Dende, kawuliˈan ne kew peggeˈ sandel kew si aku. Pī ne kew, daˈa kew suse.” ");
INSERT INTO yka_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sasang si Isa pe mamissā si dendehin, niyaˈ ne aˈa tekka amban lumaˈ si Jairus. Paˈinne pu si Jairus, “Anaknu dendehin gaˈ ne. Daˈa ne sasewun guruhin.” ");
INSERT INTO yka_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Takale si Isa inin, ubus paˈinne pu si Jairus, “Daˈa kew tinalew. Sandel kew hadja. Ellum du iyan anaknun.” ");
INSERT INTO yka_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pagtekkade laˈi si lumaˈ si Jairus, gaˈ niyaˈ daˈakne padiyalem luwal hadja si Petros, si Yahiya, si Yakub, duk saˈi-sama nakanakin. ");
INSERT INTO yka_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kēmon aˈa malaˈihin magtangis duk magmatey sabab nakanakin. Saguwaˈ paˈin si Isa si siye, “Daˈa kaˈam magtangis. Dumaˈin matey nakanakin saguwaˈ tuli hadja.” ");
INSERT INTO yka_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pinagsayehan iye weˈ de, peggeˈ kataˈuhande weˈ asal matey ne nakanakin. ");
INSERT INTO yka_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Manjari inantanan weˈ si Isa tangan nakanakin duk paˈinne pinapales, “Endeng, dongaˈ kew.” ");
INSERT INTO yka_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na, balik niyawanen duk magtawus iye dongaˈ. Duk dinaˈak iye weˈ si Isa pinakan. ");
INSERT INTO yka_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ulaliˈ manamal saˈi-sama nakanakin. Saguwaˈ sinessaˈan teˈed siye weˈ si Isa, gaˈi dinaˈak inaka bisan pu sine sabab miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Manjari ilinganan weˈ si Isa tindegne sampūˈ duk duwehin pī si iye duk inurungan siye weˈ ne balakat duk kapatut pangandaˈag meˈ seyitan duk magpakawuliˈ meˈ bayuˈ-bayuˈan saki. ");
INSERT INTO yka_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ubus pinalengngan siye weˈ ne magmahalayak sabab pagbayaˈan Tuhanin. Dinaˈak isab siye magpakawuliˈ meˈ masakihin. ");
INSERT INTO yka_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Duk paˈinne si siye, “Daˈa kaˈam magboˈo ine-ine si palengngananbin. Daˈa kaˈam moˈo tungkud atawa bāg atawa kinakan atawa sīn. Duk daˈa kaˈam moˈo badjuˈ pagsayinanbi. ");
INSERT INTO yka_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Antag-antag kalumaˈan katekkahanbi, bang kaˈam dinaˈak manaˈik weˈ aˈa si lumaˈne, laˈi ne kaˈam patennaˈ tiggelanbi laˈi si lahat miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Duk bang niyaˈ kalumaˈan papīhanbi bu meˈ aˈahin gaˈi ngaddatan kaˈam, tahalaˈ kaˈam amban kalumaˈan miyaˈan. Pagpaganun bi dahuˈ leppug bettisbin, tandaˈ weˈ muwas ne kaˈam si siye, ubus bu tahalaˈ ne kaˈam.” ");
INSERT INTO yka_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Manjari lumengngan ne meˈ tindeg si Isahin duk ilatag weˈ de meˈ kalumaˈanin. Antag-antag katekkahande, minahalayak weˈ de aka-aka mahāpin duk pinakawuliˈ weˈ de meˈ masakihin. ");
INSERT INTO yka_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Manjari inin, takale weˈ si Herod, sultan si lahat Jalilin, kēmon meˈ bakas tahinang si Isahin. Gaˈi iye magkataˈu-taˈu peggeˈ niyaˈ meˈ aˈa magpaˈin weˈ si Isa miyaˈan si Yahiya magpandi-pandi aˈahin koˈ, ellum balik amban kamateynen. ");
INSERT INTO yka_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Magpaˈin isab sinduwehin weˈ si Nabi Eliyas miyaˈan pabagala tuˈu si dunya. Niyaˈ pe isab sinduwe magpaˈin weˈ si Isa koˈ miyaˈan dambuwaˈ meˈ nabi awwalley ellum balik. ");
INSERT INTO yka_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Paˈin si Herod, “Si Yahiya bakas daˈakku pinunggelan. Sine enteˈ aˈa takaleku inaka-aka inin?” Duk piha-piha si Herod bang saˈingge pakakitene si Isahin. ");
INSERT INTO yka_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na, meˈ aˈa bakas kawakilan weˈ si Isahin magtipun ne balik pī si iye. Inaka-akahan weˈ de si Isa kēmon meˈ bakas tahinangden. Manjari binoˈo siye weˈ si Isa pī tudju puweblo Betsaida, siye-siye du hadja. ");
INSERT INTO yka_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sakaliˈ inin kataˈuhan weˈ meˈ aˈa mabanesin, paturul siye. Sinagina siye weˈ si Isa duk inusihatan siye weˈ ne sabab pagbayaˈan Tuhanin, duk pinakawuliˈ weˈ ne kēmon meˈ masakihin. ");
INSERT INTO yka_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pagkohap ne teˈed, pī si iye tindegne sampūˈ duk duwehin duk paˈinde si iye, “Daˈakun ne meˈ aˈa inin pī si meˈ kalumaˈan mapaliputin duk si meˈ lahat diyataˈin miha kinakande duk patulihande, peggeˈ lahat gaˈi hep inin tantu papituhan aˈa.” ");
INSERT INTO yka_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Saguwaˈ paˈinne si siye, “Kaˈam ne mamakan siyehin.” Paˈinde, “Luwal maniyaˈ si kamitu, lime kayuˈ pan duk duwe kenna - luwal bang pī kami melli kinakan para si meˈ aˈa mabanes inin.” ");
INSERT INTO yka_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Peggeˈ niyaˈ lime ngibu meˈ lella malaˈihin.) Paˈin si Isa si meˈ tindegnen, “Daˈakun bi siye ningkoloˈ lime-limempūˈ da tumpuk.” ");
INSERT INTO yka_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tinuhut weˈ de pangandaˈakan si Isahin duk pinatingkoloˈ ne weˈ de meˈ aˈahin kēmon. ");
INSERT INTO yka_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Manjari ineddoˈ weˈ si Isa pan lime kayuˈin duk kenna duwehin, bu mayam iye magdiyataˈ langit magpasalamat si Tuhan. Ubus bu binahagiˈ-bahagiˈ weˈ ne panin duk pinangurung weˈ ne si meˈ tindegnen, dinaˈak pangurung si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mangan siye kēmon duk esso siye. Ubus tinipun weˈ meˈ tindeg si Isahin lukas meˈ aˈahin, niyaˈ sampūˈ duk duwe bakaˈ pennoˈ. ");
INSERT INTO yka_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dambuwaˈ ellew sābu si Isa ngampun dendangan, patapit meˈ tindegnen pī si iye. Manjari tilewne siye, paˈinne, “Ine paˈin meˈ aˈahin, sine koˈ ku?” ");
INSERT INTO yka_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nambung siye, paˈinde, “Niyaˈ meˈ aˈa magpaˈin weˈ kaˈu koˈ si Yahiya magpandi-pandi meˈ aˈahin. Saguwaˈ sinduwehin isab magpaˈin weˈ si Nabi Eliyas koˈ kew. Duk niyaˈ pe isab magpaˈin weˈ kaˈu koˈ dambuwaˈ meˈ nabi masaley ellum balik.” ");
INSERT INTO yka_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Saguwaˈ bang kaˈam,” paˈin si Isa, “ine paˈinbi? Sine teˈ ku?” Nambung si Petros, paˈinne, “Kaˈu Almasihin, tapeneˈ Tuhan magbayaˈin.” ");
INSERT INTO yka_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sinessaˈan teˈed siye weˈ si Isa weˈ subey siye gaˈi magaka-aka bisan pu sine bang sine iye. ");
INSERT INTO yka_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Duk paˈin si Isa pe, “Aku inin, Anak Manusiyaˈin, ekka kabinasahan subey sandalanku duk gaˈi du ku pinagmasi weˈ meˈ kabahiˈanin, duk meˈ nakuraˈ imamin, duk meˈ guru si saraˈ āgamahin. Pinapatey du ku duk katellu ellewnen ellum du ku balik.” ");
INSERT INTO yka_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Manjari paˈinne si siye kēmon, “Bang niyaˈ aˈa mabayaˈ nuhut aku, subey iye tuhutne kinabayaˈankun, dumaˈin kinabayaˈannen. Duk subey isab iye moˈo olom pamapateyan iyehin kahabaˈ ellew, hātinen, maglillaˈ nandal kabinasahan duk bisan pe matey. Manjari makajari ne iye nuhut aku. ");
INSERT INTO yka_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Peggeˈ,” paˈin si Isa, “bang aˈahin ellegne umulnen, gaˈ niyaˈ umulne salama-lama. Saguwaˈ bang aˈahin gaˈi ellegne umulnen duk maglillaˈ pe matey hawal tuyuˈne manuhut akuhin, taga umul du iye salama-lama. ");
INSERT INTO yka_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Peggeˈ aˈahin, bisan pe tepe si iye kēmon alataˈ dem dunyahin, gaˈ du niyaˈ gunane bang gaˈi tepe si iye umul salama-lamahin duk ilegga pe iye. ");
INSERT INTO yka_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sine-sine iyaˈ magpatampal si meˈ aˈa weˈ tindegku iye duk weˈ nuhut iye toloˈkun, aku Anak Manusiyaˈin, iyaˈ du ku isab ngilale iye tindegku bang ku balik pitu liput weˈ sahayaku, duk sahaya Samaku Tuhanin, duk meˈ malaˈikatne masutsihin. ");
INSERT INTO yka_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sabennal akahante kaˈam,” paˈin si Isa, “niyaˈ kaˈam matuˈu inin gaˈi matey bang gaˈi dahuˈ takitebi pagbayaˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Palabey walum bahangi amban pamissā si Isa inin, binoˈo weˈ ne si Petros duk Yahiya duk si Yakub pī diyataˈ punu duk ngampun iye laˈi si Tuhan. ");
INSERT INTO yka_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sasangne mangampunin, pinda luwenen duk semmeknen sahaya teˈed duk asal poteˈ manamal. ");
INSERT INTO yka_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Manjari bessuwang niyaˈ duwe lella magbissā duk si Isa. Siye inin disi eymulla Musa duk eymulla Eliyas. ");
INSERT INTO yka_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pabagala siye laˈi duk sahaya du isab kēmon puhuˈden. Magbissā siye sabab sōng kamatey si Isahin laˈi si puweblo Awrusalam sa panganggaraˈ Tuhan iyehin. ");
INSERT INTO yka_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na, disi Petros duk meˈ saweˈnen kapatuli hep, saguwaˈ ngape siye duk takitede sahaya si Isahin duk duwangan manengge si bihingnen. ");
INSERT INTO yka_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Manjari inin, sakaliˈ sōng tahalaˈ ne duwanganin amban si Isa, paˈin si Petros pu si Isa, “Tuwan, hāp peggeˈ tiyaˈ kami tuˈu. Ngahinang kami tellu payad-payad. Dambuwaˈ si kaˈu, dambuwaˈ pu si Musa, duk dambuwaˈ pu Nabi Eliyas.” (Missā ne hadja iye saguwaˈ gaˈ taˈāb-ābne bang ine binissānen.) ");
INSERT INTO yka_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sasangne pe mamissāhin, niyaˈ inalak paguwaˈ duk kalandungan siye, duk kadahitan siye sakaliˈ ne siye kalandungan weˈ inalakin. ");
INSERT INTO yka_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Duk niyaˈ suwala amban dem inalakin magpaˈin, “Anakku inin pineneˈkun. Pakalehun bi iye.” ");
INSERT INTO yka_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pagubus suwala miyaˈan missā, si Isa saˈ dendangan takiteden. Gaˈ siye mabehe, duk masa īˈ gaˈ siye magaka bisan pu sine sabab bakas takitede miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pagsasumuhin, pagdumurul ne siye amban punuhin, banes teˈed aˈa pasampang pu si Isa. ");
INSERT INTO yka_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Niyaˈ lella amban dem kaˈekkahanin ngalingan, paˈinne, “O Tuwan, pabuyuˈ-buyuˈ ku si kaˈu, kaˈaseˈanun anakkun, anakku inin dambuwaˈ-buwaˈ. ");
INSERT INTO yka_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Peggeˈ pasayedan iye weˈ seyitan. Bessuwang hadja iye magkolehak ubus ngoral ne iye duk magpaspadan sampay magbukal behenen. Duk meke iye lebbahan seyitanin bang pekkengan ne iye duk bebbag ne puhuˈnen. ");
INSERT INTO yka_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bakas pināku weˈ ku si meˈ tindegnu inin pakipaluwasku seyitanin, saguwaˈ gaˈ tapaluwasde.” ");
INSERT INTO yka_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Paˈin si Isa si meˈ aˈahin, “Kaˈam, meˈ aˈa kuweˈitu inin, salaˈ teˈed pamikilbin. Gaˈ teˈed niyaˈ sandelbi si Tuhan. Taman sumiyan pe ku tuˈu si kaˈam? Taman sumiyan pe ku nandalan addatbin meke kaˈam kahagad?” Manjari paˈinne si sama nakanakin, “Boˈohun anaknun pitu.” ");
INSERT INTO yka_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sasang hap pī pe nakanakin, hinantakan iye diyataˈ bulak weˈ seyitanin duk magpaspadan iye. Saguwaˈ inamāhan weˈ si Isa seyitanin duk pinakawuliˈ weˈ ne nakanakin. Ubus bu sinōngan weˈ ne si samanen. ");
INSERT INTO yka_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kēmon aˈa malaˈihin ulaliˈ manamal pagkitede balakat Tuhanin. Sābu meˈ aˈahin pe magulaliˈ sabab meˈ hinangan si Isahin, paˈin si Isa si meˈ tindegnen, ");
INSERT INTO yka_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Indananun bi teˈed meˈ bissāku si kaˈam inin. Aku, Anak Manusiyaˈin, sinōngan du ku iyan si antanan meˈ aˈa.” ");
INSERT INTO yka_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Saguwaˈ gaˈ tahātide bissāne miyaˈan peggeˈ tinapukan amban siye supaya gaˈi tahātide. Duk gaˈ siye makatawakkal nilew iye bang ine hāti pinaˈinnen. ");
INSERT INTO yka_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Dambuwaˈ ellew magsuweyan meˈ tindeg si Isahin bang sine siye tamanan malangkewin. ");
INSERT INTO yka_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kataˈuhan si Isa bang ine dem pikilanden, hangkan ngeddoˈ iye dambuwaˈ nakanak dikiˈ duk pinatengge weˈ ne si bihingne. ");
INSERT INTO yka_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Manjari paˈinne si siye, “Bang niyaˈ aˈa bu sabab sandelne si akuhin ngaddatan nakanak dikiˈ kuweˈ inin, aku inaddatannen. Duk bang niyaˈ ngaddatan aku, addatanne isab Tuhanin, mamapitu aku si dunyahin. Sine-sine kaˈam tamanan madiyawaˈ pagateynen, iye iyan tamanan malangkewin.” ");
INSERT INTO yka_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Manjari missā Yahiya, paˈinne, “Tuwan, niyaˈ dambuwaˈ aˈa tadugpak kami, sabbutne ēnnun pagpaluwasne seyitan amban meˈ aˈa. Pinages iye weˈ kami peggeˈ dumaˈin iye saweˈte bi.” ");
INSERT INTO yka_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Saguwaˈ paˈin si Isa si iye, “Daˈa iye pagesun bi. Peggeˈ manggaˈi manguntarahan kaˈamin, bēbbeg amban kaˈam.” ");
INSERT INTO yka_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Manjari inin, peggeˈ sōng taˈabut ne waktu paˈangkat si Isa hap surgaˈin, magtuyuˈ teˈed iye pī hap Awrusalam. ");
INSERT INTO yka_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Niyaˈ meˈ aˈa daˈakne pī padehellu amban iye. Hangkan lumengngan ne meˈ dinaˈakne miyaˈan duk hap pī siye si kalumaˈan laˈi si lahat Samariya manyap pahalihan si Isa laˈi. ");
INSERT INTO yka_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Saguwaˈ meˈ aˈa si kalumaˈan miyaˈan gaˈ ngatu patennaˈan si Isa laˈi, peggeˈ kataˈuhande weˈ tudju Awrusalam lengngannen. ");
INSERT INTO yka_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pagkataˈuhan inin weˈ duwe tindegnen, si Yakub duk Yahiya, paˈinde pu si Isa, “Tuwan, mabayaˈ kew bang kami ngandaˈak ebbut laboˈ amban diyataˈ langit duk siye ubus matey?” ");
INSERT INTO yka_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Saguwaˈ hinarap duwanganin weˈ ne bu inamāhan. ");
INSERT INTO yka_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Manjari palanjal siye pī si kalumaˈan seddili. ");
INSERT INTO yka_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sasangde malumengnganin, niyaˈ aˈa missā pu si Isa, paˈinne, “Tuwan, mabayaˈ ku nuhut kaˈu tungan-tungan papīhannu.” ");
INSERT INTO yka_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nambung si Isa, paˈinne, “Gam pe meˈ pāhangin niyaˈ lowangde duk meˈ manuk-manukin niyaˈ sabakande. Saguwaˈ aku, Anak Manusiyaˈin, gaˈ niyaˈ bisan pahalihanku.” ");
INSERT INTO yka_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Paˈin si Isa si aˈa dambuwaˈin, “Nuhut kew aku.” Saguwaˈ nambung aˈahin, paˈinne, “Aweˈ, Tuwan, saguwaˈ pī ku dahuˈ hap lumaˈ. Pagubus kubulku samakun, balik saˈ ku pitu nuhut kaˈu.” ");
INSERT INTO yka_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Paˈin si Isa, “Ambat mamateyin kinubul weˈ meˈ aˈa manggaˈ niyaˈ umulde salama-lamahin. Saguwaˈ kaˈu, pī kew lumengngan magmahalayak sabab pagbayaˈan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Niyaˈ isab dangan, paˈinne pu si Isa, “Nuhut ku kaˈu, Tuwan, saguwaˈ tiyaˈ ku dahuˈ pī nabiyaˈ si meˈ aˈa lumaˈkun.” ");
INSERT INTO yka_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Saguwaˈ paˈin si Isa si iye, “Bang aˈahin magbadjaˈ bu luwal maghalengan, gaˈi hāp. Damikkiyan bang aˈahin nuhut aku bu alal iye si meˈ taˈambannen, gaˈi iye pataˈ pinagbayaˈan weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Puwas miyaˈan niyaˈ pe pitumpūˈ duk duwe aˈa kawakilan weˈ ne duk dinaˈak weˈ ne padehellu pī si kēmon meˈ kalahat-lahatan sōng papīhannen. Pinalengngan siye weˈ ne duwangan-duwangan. ");
INSERT INTO yka_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Paˈinne si siye, “Meˈ aˈahin kuweˈ dalil tanaˈ sarang ne pinagani. Luha tanaˈin saguwaˈ kulang mamaganihin. Hangkan subey kaˈam māku-māku si Tuhan, iye dapuˈ tanaˈin, supaya iye ngandaˈak meˈ aˈa pī maganine. ");
INSERT INTO yka_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na, lumengngan ne kaˈam. Saguwaˈ pahatul kaˈam, peggeˈ palengngante kaˈam pī si meˈ aˈa laˈatan; kuweˈ kaˈam dalil meˈ anak bili-bili pī dem kaˈekkahan asu bingis. ");
INSERT INTO yka_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Daˈa kaˈam magboˈo pitaka atawa bāg atawa tehompaˈ. Sine-sine tasampangbi si lān, daˈa kaˈam subey pahali missā. ");
INSERT INTO yka_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Duk bang niyaˈ lumaˈ pamanaˈikanbi, paˈinun bi dahuˈ, ‘Karayaw urungan Tuhanin kasanyangan kēmon dem lumaˈ inin.’ ");
INSERT INTO yka_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bang niyaˈ aˈa laˈi pataˈ inurungan kasanyangan, paˈamban du kasanyangan pinākubin laˈi si iye. Saguwaˈ bang gaˈ, gaˈ du niyaˈ kaˈujudan pinaˈinbi miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Patennaˈ kaˈam si dambuwaˈ lumaˈ hadja. Daˈa kaˈam magpinda-pinda patennaˈan. Mangan kaˈam duk nginum kaˈam ine-ine bettadande kaˈam, peggeˈ kuweˈ miyaˈan tangdande si kaˈamin. Aˈa maghinangin pataˈ tinangdanan. ");
INSERT INTO yka_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kalumaˈan antag-antag katekkahanbi, bang addatan meˈ aˈahin du kaˈam, kakanun bi ine-ine bettadande kaˈam. ");
INSERT INTO yka_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pakoleˈun bi meˈ masaki malaˈihin duk paˈinun bi si meˈ aˈahin, ‘Taˈabut ne pagbayaˈ Tuhan si kaˈamin.’ ");
INSERT INTO yka_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Saguwaˈ kalumaˈan antag-antag katekkahanbi, bu gaˈi kaˈam addatan meˈ aˈahin, pī kaˈam si meˈ kalsara duk paˈinun bi, ");
INSERT INTO yka_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Pagpagan kami amban bettis kami bisan leppug bulak kalumaˈanbi inin, tandaˈ weˈ muwas ne kami si kaˈam. Saguwaˈ subey kataˈuhanbi weˈ asal taˈabut ne pagbayaˈ Tuhanin.’ ");
INSERT INTO yka_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Akahante kaˈam,” paˈin si Isa, “weˈ pagtaˈabut ellew pangahukum Tuhan manusiyaˈin, pasōng teˈed bohat hukuman si meˈ aˈa si kalumaˈan miyaˈan amban hukuman si lahat Sodomin, lahat mabawag sabab duse meˈ aˈanen.” ");
INSERT INTO yka_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kaˈaseˈ-aseˈ kaˈam meˈ aˈa Korasinin. Kaˈaseˈ-aseˈ kaˈam meˈ aˈa Betsaidahin. Peggeˈ bang laˈi miyaˈan si lahat Tiros duk Sidon pangahinanganku meˈ hinangan balakatan tahinangku luˈu si kaˈamin, tiggel ne miyaˈan meˈ aˈa malaˈihin magsusun duk ngalebbahan duseden duk sa addatden magsemmek karut siye duk mandi duk abu pamakitede pagsusunden. ");
INSERT INTO yka_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pagtaˈabut ellew paghukumin, pasōng teˈed bohat hukuman si kaˈamin amban hukuman si meˈ aˈa Tiros duk Sidonin. ");
INSERT INTO yka_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Duk kaˈam, meˈ aˈa Kapernaumin,” paˈin si Isa, “weˈ kannalbi pinalangkew kaˈam pī diyataˈ langit? Pinadiyawaˈ du kaˈam pī dem narkaˈ.” ");
INSERT INTO yka_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Paˈin si Isa pe si meˈ tindegnen, “Sine-sine pakale si panoloˈbin, kuweˈ du aku pinakalenen. Sine-sine gaˈi ngasip kaˈam, kuweˈ du aku manggaˈi inasipnen. Duk sine-sine gaˈi ngasip aku, hātinen gaˈi du isab asipne Tuhanin, iye mamapitu aku si dunyahin.” ");
INSERT INTO yka_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Gaˈ du tiggel tekka ne balik pitumpūˈ duk duwehin laˈi pu si Isa. Kēgan siye manamal. Paˈinde pu si Isa, “Tuwan, bisan hatiˈ meˈ seyitanin tuhutde pangandaˈakan kamihin basta taˈat kami ēnnun.” ");
INSERT INTO yka_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Paˈin si Isa si siye, “Asal takiteku nakuraˈ seyitanin laboˈ kuweˈ lalat. Tadaˈag ne basagnen. ");
INSERT INTO yka_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Payamanun bi, kaˈurungan kaˈam weˈ ku balakat supaya bisan kaˈam makadiˈik sawe atawa sipitkāˈ, gaˈi du makaˈine kaˈam. Duk gaˈi isab kaˈam tadaˈag weˈ bantaten bi nakuraˈ seyitanin. Gaˈ isab niyaˈ makapagkaˈat kaˈam bisan ine. ");
INSERT INTO yka_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Daˈa iye kasinnahanbin peggeˈ meˈ seyitanin nuhut pangandaˈakanbin, saguwaˈ subey kasinnahanbin peggeˈ tasulat ne ēnbin weˈ Tuhanin si surgaˈ.” ");
INSERT INTO yka_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Manjari waktu miyaˈan, pinakēg teˈed si Isa weˈ Niyawa Sutsihin duk paˈinne, “O Ammaˈ, kaˈu magbayaˈ si langit duk bulakin, pudjite kew teˈed peggeˈ urungannu kataˈu meˈ aˈa maˈawamin duk tapukannu kataˈu inin amban meˈ aˈa malangkew pangadjiˈnen duk amban meˈ makasabutin. Aweˈ, Ammaˈ, asal pudjite kew peggeˈ kuweˈ inin kinabayaˈannun.” ");
INSERT INTO yka_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Duk paˈin si Isa pe, “Bakas pinangandel ne si aku kēmon-kēmonin weˈ Samaku, Tuhanin. Gaˈ niyaˈ ngataˈuhan bang sine ku, aku Anak Tuhanin, luwal hadja Samakun, Tuhanin. Duk gaˈ isab niyaˈ ngataˈuhan bang sine Samakun, luwal hadja aku, anaknen duk sine-sine pineneˈkun, iye pamakilalehanku Samakun.” ");
INSERT INTO yka_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Manjari paharap si Isa si meˈ tindegnen duk paˈinne si siye hadja, “Asal hāp pe kaˈam peggeˈ takitebi kēmon meˈ takitebi inin. ");
INSERT INTO yka_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Akahante kaˈam, ekka meˈ nabi duk meˈ sultan awwalley mabayaˈ teˈed ngite takitebi kuweˈitu inin, saguwaˈ gaˈ inin takitede. Mabayaˈ teˈed isab takalede meˈ takalebi kuweˈitu inin saguwaˈ gaˈ takalede.” ");
INSERT INTO yka_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Manjari niyaˈ dambuwaˈ guru pandey si saraˈ āgama pī pu si Isa. Niyaˈ tilewne panuleyanne si Isa. Paˈinne, “Tuwan, ine subey hinangku supaya ku pinasukuˈan umul gaˈ niyaˈ tamananne?” ");
INSERT INTO yka_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nambung si Isa, paˈ inne, “Ine teˈ tasulat dem saraˈ Tuhan inambanan si Musahin? Ine tabatsanun laˈi?” ");
INSERT INTO yka_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nambung iye, paˈinne, “Paˈin saraˈin: Subey kalasahannu Tuhanin, Panuhutannun, dambūs-būs ateynun duk pikilannun duk basagnun. Duk subey kalasahannu saweˈnun kuweˈ pangalasanu dinun.” ");
INSERT INTO yka_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Tewwaˈ sambungnun,” paˈin si Isa. “Hinangun iyan duk pinasukuhan du kew umul gaˈ tamananne.” ");
INSERT INTO yka_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Manjari guru miyaˈan gaˈi bayaˈ tadaˈag, hangkan paˈinne pu si Isa, “Sine teˈ saweˈku subey kinalasahankun?” ");
INSERT INTO yka_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nambung si Isa magdalilan, paˈinne, “Niyaˈ dambuwaˈ Yahudi padurul amban Awrusalam hap puweblo Ariha. Sābune si lān, ilaˈugan iye weˈ meˈ mundu. Pinapeddiˈan iye weˈ de duk ineddoˈ weˈ de meˈ kēmonnen sampay semmek si barannen. Sōng matey iye ubus bu inambanan iye weˈ de. ");
INSERT INTO yka_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Duk magsātaˈ, niyaˈ dambuwaˈ imam Yahudi nuhut lān miyaˈan. Pagkitene aˈahin, palibuwad iye amban dambiyaˈ. ");
INSERT INTO yka_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Damikkiyan isab niyaˈ seddili aˈa lumabey si antag miyaˈan. Aˈa inin Yahudi isab, tubuˈ si Libi duk hinangnen nabangan imam si langgalin. Pagkitene aˈahin, palibuwad isab iye. ");
INSERT INTO yka_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Gaˈ du tiggel niyaˈ dambuwaˈ aˈa bangsa Samariya, si paglengngananne tapī iye laˈi si antag miyaˈan. Pagkitene aˈahin, maˈaseˈ teˈed iye. ");
INSERT INTO yka_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Patapit iye pī duk tambalanne bakatnen duk isellan duk boheˈ ubas, ubus bu pinekkes weˈ ne. Ubus binengket weˈ ne bu pinasakey si hayepne duk binoˈo weˈ ne pī si lumaˈ paghegpaˈ-hegpaˈan duk inuntul weˈ ne laˈi. ");
INSERT INTO yka_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagsasumuhin, ngurung iye sīn si dapuˈ lumaˈin duk paˈinne si iye, ‘Ipatun aku aˈa inin. Bang kagastu kew labi amban sīn inin, bayedante saˈ kew pagbalik ku pitu.’” ");
INSERT INTO yka_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Manjari paˈin si Isa si guruhin, “Na, si aˈa tellungan miyaˈan, inggehin pikilnu asal bennal mapasaweˈ si aˈa ilaˈugan weˈ meˈ munduhin?” ");
INSERT INTO yka_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nambung iye, paˈinne, “Mamaˈaseˈ si iyehin duk manabang iyehin.” Manjari paˈin si Isa si iye, “Pī kew, hinangun sa hininang aˈa miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Palanjal disi Isa duk meˈ tindegnen duk tekka siye si dambuwaˈ kalumaˈan. Niyaˈ laˈi dambuwaˈ dende inēnan si Marta. Inaddatan si Isa laˈi si lumaˈne. ");
INSERT INTO yka_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Niyaˈ pungtinaˈi si Marta dende inēnan Mariyam. Si Mariyam inin ningkoloˈ si antag bettis si Isa pakale-kale si meˈ binissānen. ");
INSERT INTO yka_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Si Marta sasew teˈed weˈ hinangne maˈekkahin magpanyap para pu disi Isa. Hangkan patapit iye pu si Isa duk paˈinne, “Tuwan, gaˈi ke hinangnu ine bisan ku tiyaˈ pasagadan pungtinaˈikun maghinang dendang-dendangan? Daˈakun be iye nabangan aku.” ");
INSERT INTO yka_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Saguwaˈ sambungan si Isa iye, paˈinne, “Kaˈu Marta, suse kew duk ekka makasasew kaˈu bu gaˈ du niyaˈ tantu kagunahanne. ");
INSERT INTO yka_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Dambuwaˈ du hadja mahadje kagunahannen. Duk tapeneˈ weˈ Mariyam mahāp inin duk gaˈi inin kaˈānan amban iye.” ");
INSERT INTO yka_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Dambuwaˈ ellew ngampun si Isa. Pagubus iye ngampun, paˈin dangan meˈ tindegnen si iye, “Tuwan, toloˈanun koˈ kami bang saˈingge pangampunin, sa Yahiyahin tinoloˈan weˈ ne meˈ tindegnen.” ");
INSERT INTO yka_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nambung si Isa, paˈinne, “Bang kaˈam ngampun subey kuweˈ inin. Paˈinun bi, ‘O Ammaˈ, karayaw ēnnun pinagaddatan weˈ kēmon manusiyaˈin. Karayaw weˈ gaˈi tiggel, magbayaˈ ne kew si kēmon manusiyaˈ. ");
INSERT INTO yka_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Urunganun kami kinakan ellew-ellew. ");
INSERT INTO yka_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ampunun meˈ duse kamihin kuweˈ du isab pangampun kami meˈ makaduse si kamihin. Patalahun kami amban sassat.’” ");
INSERT INTO yka_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Paˈin si Isa pe si siye, “Saˈupama niyaˈ kaˈam taga bagay duk pī kaˈam si iye tengaˈ bahangi duk paˈinbi, ‘O bagay, pasambiˈun koˈ ku tellu kayuˈ pan, ");
INSERT INTO yka_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","peggeˈ īˈ niyaˈ bagayku bahu tekka amban paglengngananne, bu gaˈ niyaˈ pamakanku iye.’ ");
INSERT INTO yka_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Manjari nambung iye amban diyalem, paˈinne, ‘Daˈa ku sasewun. Bagat ne gawangin duk tiyaˈ ne ku duk meˈ anakkun pabāk. Gaˈi ku makasaggaˈ dongaˈ ngurungan kaˈu ine-ine.’ ");
INSERT INTO yka_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Akahante kaˈam,” paˈin si Isa, “sudda dongaˈ du bagaybi iyan duk urunganne kaˈam kēmon sukalbin, dumaˈin peggeˈ magbagay kaˈam saguwaˈ peggeˈ gaˈi kaˈam padeheng māku. ");
INSERT INTO yka_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hangkan paˈinku si kaˈam: Māku-māku kaˈam, ubus bu inurungan du kaˈam. Miha kaˈam, ubus bu ngasuwaˈ du kaˈam. Makipadiyalem kaˈam, ubus bu ilukahan du kaˈam. ");
INSERT INTO yka_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Peggeˈ kēmon mamākuhin, inurungan du, mamihahin ngasuwaˈ du, duk makipadiyalemin, ilukahan du. ");
INSERT INTO yka_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kaˈam meˈ taga anakin, bang māku anakbin kenna, urunganbi ke iye sawe? ");
INSERT INTO yka_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Atawa bang māku iye pugad, urunganbi ke iye sipitkāˈ? ");
INSERT INTO yka_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kaˈam, bisan kaˈam dusehan, taˈu du kaˈam ngurungan anakbin meˈ bayuˈ-bayuˈan mahāpin. Pasōng pe teˈed Tuhanin, Samabi si surgaˈin, pangurungne si kaˈam Niyawa Sutsihin bang kaˈam māku si iye.” ");
INSERT INTO yka_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mintedde isab, magpaluwas si Isa seyitan makaˈumew. Pagluwas seyitanin, aˈa maˈumewin kapamissā ne. Ulaliˈ teˈed meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Saguwaˈ paˈin meˈ sinduwehin, “Kaˈurungan iye balakat weˈ Belsebul, nakuraˈ meˈ seyitanin, hangkan iye kapagpaluwas meˈ seyitan.” ");
INSERT INTO yka_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Meˈ sinduwehin isab, panuleyande si Isa, makipakite hinangan makaˈulaliˈ duk kataˈuhande bang bennal iye amban Tuhan. ");
INSERT INTO yka_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Saguwaˈ kataˈuhan si Isa bang ine dem pikilanden hangkan paˈinne si siye, “Saˈupama bang niyaˈ pagsultanan bu magbonoˈ meˈ aˈanen, suddanen magkaˈat pagsultanan miyaˈan. Duk bang magtewtey-anakin magkuntara, magkaˈat du isab. ");
INSERT INTO yka_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hangkan, bang nakuraˈ seyitanin maluwas tindegne seyitanin, hātinen weˈ magkuntara ne siye duk gaˈi layun pagbayaˈan seyitanin. Paˈinbi weˈ magpaluwas ku seyitan peggeˈ kaˈurungan ku balakat weˈ Belsebul, nakuraˈ seyitanin. ");
INSERT INTO yka_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bang bennal inin, na meˈ tindegbin, amban balakat sine pagpaluwasde seyitanin? Siye ne iyan magpaˈinin weˈ salaˈ pamikilbin. ");
INSERT INTO yka_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Saguwaˈ iye matoˈohin, asal amban Tuhan balakatku magpaluwas seyitanin. Hātine inin, Tuhanin magbayaˈ ne tuˈu si kaˈam. ");
INSERT INTO yka_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Saˈupama bang niyaˈ aˈa basag duk diyalem bessi manteyan lumaˈnen, gaˈi siya-siya meˈ alataˈnen. ");
INSERT INTO yka_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Saguwaˈ bang niyaˈ pasōng basag amban iye hap pī nekka iye bu tadaˈag iye, ineddoˈ amban iye meˈ bessi pangandelannen, duk binahagiˈ-bahagiˈ meˈ alataˈnen weˈ mangandaˈagin pangurung pī si meˈ saweˈnen.” ");
INSERT INTO yka_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Paˈin si Isa pe, “Manggaˈi mamēbbegan akuhin, nguntarahan aku. Duk manggaˈi manabangan aku magtipunin, nganat-nganat du.” ");
INSERT INTO yka_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Bang niyaˈ seyitan,” paˈin si Isa, “pa1uwas amban aˈa, maglengngan-lengngan iye dem lahat makagindew-gindew miha pahalihanne. Bang gaˈi iye ngasuwaˈ, paˈinne dem pikilanne, ‘Tiyaˈ ku balik pī si bakas patennaˈankun.’ ");
INSERT INTO yka_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pagtekkane laˈi, takitene weˈ bakas pinahidan ne duk memes ne. ");
INSERT INTO yka_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ubus pī iye ngeddoˈ pituˈ meˈ seyitan seddili, pasōng pe laˈatden amban iye duk paˈasek siye kēmon pī dem baran aˈahin patennaˈ laˈi. Kaˈujudan aˈa miyaˈan, pasōng pe laˈatan maˈumantag si iye kuweˈituhin amban tagnaˈin.” ");
INSERT INTO yka_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Manjari, pagubus hadja miyaˈan bissā si Isa, niyaˈ dambuwaˈ dende amban dem kaˈekkahanin missā papales, paˈinne, “Asa1 kēgan manamal dende manganakan kaˈuhin duk mamasusu kaˈuhin.” ");
INSERT INTO yka_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Saguwaˈ nambung si Isa, paˈinne, “Pasōng pe teˈed kēgan aˈa mapakale si lapal Tuhanin duk manuhut meˈ pangandaˈakannen.” ");
INSERT INTO yka_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pagmagkatamba ne paˈin meˈ aˈa mapaliput pu si Isahin, paˈinne si siye, “Kaˈam meˈ aˈa kuweˈitu inin, laˈat kaˈam. Makapakite tandaˈ kaˈam pangilalehanbi aku bang sabennal-bennal ku amban Tuhan. Saguwaˈ gaˈ niyaˈ tandaˈ pinakitehan si kaˈam luwal hadja tandaˈ Nabi Yunus awwalley. ");
INSERT INTO yka_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Peggeˈ kuweˈ si Nabi Yunus hininang weˈ Tuhanin tandaˈ para si meˈ aˈa Ninibahin awwalley, damikkiyan isab aku, Anak Manusiyaˈin, hinang tandaˈ ku para si kaˈam meˈ aˈa kuweˈitu inin. ");
INSERT INTO yka_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bang tekka ellew pangahukum Tuhan meˈ manusiyaˈin, pī iyan nengge sultan dende amban lahat Seba masa awwalley duk taksilne kaˈam. Peggeˈ iye, pitu iye amban higad dunya peggeˈ bayaˈ pakalene meˈ bissā Sultan Sulaimanin, aˈa lalem teˈed kataˈunen masaley. Akahante kaˈam, kuweˈitu niyaˈ tuˈu si kaˈam pasōng kataˈunen amban Sulaiman, saguwaˈ gaˈi tayimaˈbi panoloˈnen. ");
INSERT INTO yka_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bang tekka ellew pangahukum Tuhan meˈ manusiyaˈin, pī iyan nengge meˈ aˈa si lahat Niniba awwalley duk taksilde kaˈam. Peggeˈ siye, pagsusunande duk lebbahande duseden sakaliˈ takalede usihat Nabi Yunusin. Akahante kaˈam, kuweˈitu niyaˈ tuˈu si kaˈam pasōng langkew amban Nabi Yunus, saguwaˈ gaˈi tayimaˈbi panoloˈnen duk gaˈi pagsusunanbi dusebin.” ");
INSERT INTO yka_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Paˈin si Isa pe, “Gaˈ niyaˈ aˈa mekketan payitaˈan ubus bu tapukanne atawa lekkebanne lagaˈ. Saguwaˈ bettadne diyataˈ tengenanne supaya meˈ mapadiyalemin kitede dantaˈin. ");
INSERT INTO yka_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mataten dalil payitaˈan si barante. Bang pastiˈ pamayamten, hātinen bentel hinanganten, kuweˈ dantaˈ tibuˈukan baranten, saguwaˈ bang labut pamayamten, hātinen laˈat hinanganten, kuweˈ lindem tibuˈukan baranten. ");
INSERT INTO yka_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hangkan pahatul kaˈam supaya gaˈi salaˈ pamikilbin. Kaw paˈinbi weˈ dantaˈ dem baranbin, ine kew lindem hatiˈ. ");
INSERT INTO yka_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bang tibuˈukan barannun dantaˈ duk gaˈ niyaˈ bisan kuweˈahat lindem, tibuˈukan barannun dantaˈ du manamal, kuweˈ niyaˈ payitaˈan ninaganne.” ");
INSERT INTO yka_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagubus si Isa missā, binoˈo iye weˈ dambuwaˈ Pariseo hap lumaˈne mangan. Pī iye duk ningkoloˈ sōng mangan. ");
INSERT INTO yka_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ulaliˈ Pariseohin peggeˈ gaˈ si Isa ngosoˈ tangan meke mangan. ");
INSERT INTO yka_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Paˈin si Isa si iye, “Kaˈam meˈ Pariseohin, kinosoˈan weˈ bi tikungin duk laleyin, saguwaˈ dem ateybin pennoˈ weˈ napsu duk laˈat. ");
INSERT INTO yka_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Babbal pahāp kaˈam iyan. Gaˈi ke kataˈuhanbi weˈ dumaˈin hadja pinapanjari Tuhanin meˈ takite si bukutin saguwaˈ pinapanjari isab weˈ ne diyalemin, meˈ manggaˈi takitehin. ");
INSERT INTO yka_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Saguwaˈ pangurungun bi si meˈ mamiskinin meˈ diyalem tikungbin duk laleybin, manjari gī ne kēmon si kaˈam. ");
INSERT INTO yka_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kaˈaseˈ-aseˈ kaˈam meˈ Pariseohin. Magjakat kaˈam bisan sampay meˈ bawing duk saley duk meˈ bayuˈ-bayuˈan pagpā-pā, saguwaˈ gaˈi tapikilbi maghinangan bentel si pagkasibi duk gaˈi tapikilbi malasa si Tuhan. Hāp bang kaˈam magjakat saguwaˈ subey gaˈi tayikutanbi meˈ hinangan pinaˈinku miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kaˈaseˈ-aseˈ kaˈam meˈ Pariseohin. Bang kaˈam dem langgal, kabayaˈanbin ningkoloˈ si kōkan. Bang kaˈam dem tabuˈan, sinna teˈed kaˈam bang kaˈam sinalam weˈ aˈa. ");
INSERT INTO yka_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kaˈaseˈ-aseˈ kaˈam. Peggeˈ kuweˈ kaˈam dalil meˈ kubul pasad ne, hangkan meˈ aˈahin magbutasan diyataˈne bu gaˈ kataˈuhande weˈ makabatal siye.” ");
INSERT INTO yka_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Manjari dangan meˈ guru si saraˈ āgamahin nambungan si Isa, paˈinne, “Tuwan, bang kew missā sa iyan, paˈiyaˈnu isab sampay kami.” ");
INSERT INTO yka_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","“Aweˈ,” paˈin si Isa. “Kaˈaseˈ-aseˈ isab kaˈam, meˈ guru si saraˈ āgamahin. Peggeˈ pinabohatan weˈ bi meˈ aˈahin duk meˈ saraˈ gaˈi takoleˈde, bu gaˈi kaˈam nabang moˈone bisan kuweˈahat. ");
INSERT INTO yka_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Asal kaˈaseˈ-aseˈ kaˈam. Peggeˈ kaˈam mahāpan kubul meˈ nabi - bu siye meˈ nabi pinapatey weˈ meˈ kapapuˈanbi ley. ");
INSERT INTO yka_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pakitehanbi weˈ paˈuyun kaˈam si meˈ hinangan meˈ kapapuˈanbin. Siye mamapatey meˈ nabihin duk kaˈam mahāpan kubulden. ");
INSERT INTO yka_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hangkan hep Tuhanin, iye malalem kataˈunen, paˈinne, ‘Ngandaˈak du ku pī si bangsa Israˈil meˈ nabi duk meˈ aˈa kawakilanku. Saguwaˈ sinduwe pinapīkun, papateyde du duk sinduwehin binasade.’ ");
INSERT INTO yka_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hangkan hep, kaˈam meˈ aˈa kuweˈitu inin, ilegga du kaˈam sabab duse meˈ kapapuˈanbin, pamonoˈde meˈ kanabi-nabihanin kemuwe tagnaˈ dunyahin pinapanjari. ");
INSERT INTO yka_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Asal ilegga du kaˈam sabab kamatey meˈ kanabihan īˈen, tinagnaˈan amban si Habil anak Apuˈ Adamin sampay Jakariya, iye pinapateyde si ellet pagkuluban-kulubananin duk langgal hadjehin. Aweˈ, akahante kaˈam, kēmon meˈ hininangde miyaˈan moleˈ si kaˈam, meˈ aˈa maˈellum kuweˈituhin. ");
INSERT INTO yka_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kaˈaseˈ-aseˈ kaˈam meˈ guru si saraˈ āgamahin. Binembelan weˈ bi meˈ aˈahin supaya gaˈi kataˈuhande lān mabennal tudju Tuhanin. Gaˈi du tuhutbi lān miyaˈan duk pagesbi pe sasuku mabayaˈ manuhut lān miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pagtahalaˈ si Isa amban lumaˈ miyaˈan, kaˈastelan teˈed iye weˈ meˈ guru si saraˈ āgamahin duk meˈ Pariseohin duk ekka tilew-tilewde, ");
INSERT INTO yka_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","panguhi-nguhide iye kaw niyaˈ salaˈ ujud tabissāne, manjari katuntutande iye. ");
INSERT INTO yka_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sābu miyaˈan, ibuhan meˈ aˈa mapatipunin hangkan maglewlaray siye. Manjari missā si Isa dehellu si meˈ tindegnen, paˈinne, “Pahatul-hatul kaˈam kaw kaˈam katimboˈohan weˈ hinangan meˈ Pariseohin. Maghinang hadja siye duk siye takite weˈ aˈa. Addatde iyan kuweˈ pasulig palatag. ");
INSERT INTO yka_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gaˈ niyaˈ dinebbunan weˈ gaˈi ujud paguwaˈ, gaˈ niyaˈ tinapukan weˈ gaˈi ujud kataˈuhan. ");
INSERT INTO yka_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ine-ine pagsuwi-suwibi sangem, takale du bang ellew ne. Ine-ine pagkemotbi dem bilik, pinalataˈ du si meˈ aˈa si tabuˈan.” ");
INSERT INTO yka_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Akahante kaˈam, meˈ bagay, daˈa kaˈam tinalew si meˈ makapapatey baranbin duk ubus gaˈ du niyaˈ tahinangde namba. ");
INSERT INTO yka_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Saguwaˈ akahante kaˈam bang sine subey katalewanbin. Iye subey katalewanbin, Tuhanin, peggeˈ dumaˈin hadja baran tapapateynen, saguwaˈ taga balakat iye ngalakasan niyawabin pī dem narkaˈ. Aweˈ, asal iye subey katalewanbin.” ");
INSERT INTO yka_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Paˈin si Isa pe, “Niyaˈ meˈ manuk-manuk dikiˈ tabellite lime kayuˈ duwe sīn. Bisan mura du halgaˈden saguwaˈ gaˈ niyaˈ siye bisan dambuwaˈ takayipat weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na, pasōng ne kaˈam, gaˈi kaˈam takayipat weˈ Tuhanin. Bisan kōkbin kataˈuhanne bang piye lamba ekkahannen. Hangkan daˈa kaˈam tinalew. Mahalgaˈ pe kaˈam si iye amban meˈ manuk-manuk maˈekkahin.” ");
INSERT INTO yka_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Akahante kaˈam,” paˈin si Isa, “weˈ sine-sine magbennal si harapan aˈa weˈ patuhut iye si aku, Anak Manusiyaˈin, asal magbennal du ku isab si harapan meˈ malaˈikat Tuhanin weˈ patuhut iye si aku. ");
INSERT INTO yka_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Saguwaˈ sine-sine masuwey si harapan aˈa weˈ gaˈi iye patuhut si aku, Anak Manusiyaˈin, masuwey du ku isab si harapan meˈ malaˈikat Tuhanin weˈ gaˈi iye patuhut si aku. ");
INSERT INTO yka_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sine-sine missā laˈat si aku, Anak Manusiyaˈin, makajari du iye inampun. Saguwaˈ bang Niyawa Sutsihin binissā-bissāhannen asal gaˈi teˈed iye inampun. ");
INSERT INTO yka_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bang si pasōngan siggew meˈ aˈa kaˈam bu boˈode pī si meˈ langgalde hinukum, atawa boˈode kaˈam pī si harapan meˈ nakuraˈde duk meˈ magbayaˈ si lahatin, daˈa kaˈam magsuse bang saˈingge pamēbbegbi dibin atawa bang ine binissābin. ");
INSERT INTO yka_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Peggeˈ panoloˈan Niyawa Sutsihin du kaˈam si waktu miyaˈan bang ine subey binissābin.” ");
INSERT INTO yka_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Manjari niyaˈ dangan amban meˈ aˈa mabanesin missā. Paˈinne pu si Isa, “O Tuwan, daˈakun be sakakun ambat ku bahagiˈanne pusakaˈ amban sama kamiley.” ");
INSERT INTO yka_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Saguwaˈ paˈin si Isa si iye, “Oy lella. Gaˈ ku kaˈurungan kapatut ngahukum kaˈam duk gaˈ niyaˈ kapatutku mahagiˈ alataˈbin.” ");
INSERT INTO yka_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Manjari paˈin si Isa si meˈ aˈahin, “Pahatul-hatul kaˈam. Halliˈanun bi kēmon bayuˈ-bayuˈan napsu, peggeˈ bisan aˈahin dayahan manamal, dumaˈin alataˈ maˈekkahin makaˈellum iyehin.” ");
INSERT INTO yka_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ubus inakahan siye weˈ ne dambuwaˈ dalilan, paˈinne, “Niyaˈ dambuwaˈ aˈa dayahan taga meˈ bulakan. Manjari teˈed kēmon meˈ tinanemnen. ");
INSERT INTO yka_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Manjari paˈinne dem ateyne, ‘Ine enteˈ hinangku peggeˈ gaˈ ne niyaˈ pangennaˈanku jari meˈ tinanemkun? ");
INSERT INTO yka_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A, kataˈuhanku bang ine subey hinangku,’ paˈinne. ‘Larakku meˈ kamaligkun bu matengge ku hadje pe amban tagnaˈin, duk ennaˈku laˈi kēmon jari tinanemkun duk kēmon alataˈkun. ");
INSERT INTO yka_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ubus paˈinku si diku: Asal hāp sukudkun. Ekka ne taˈennaˈku para si meˈ tahun maˈekka si pasōnganin. Pahali-hali ne ku. Mangan ku, nginum ku duk magadjak-adjak ku.’ ");
INSERT INTO yka_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Saguwaˈ paˈin Tuhanin si iye, ‘Asal dupang kew iyan! Sangem inin du, ineddoˈ ne amban kaˈu umulnun. Manjari, pu sine ne meˈ alataˈ pinanyapnun?’” ");
INSERT INTO yka_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ubus miyaˈan paˈin si Isa, “Na, asal sa iyan du isab aˈahin bang nipun iye alataˈ para si dine bu miskin iye si matahan Tuhan.” ");
INSERT INTO yka_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Manjari missā si Isa si meˈ tindegnen, paˈinne, “Hangkan hep paˈinku si kaˈam, daˈa kaˈam maggagal sabab kaˈellumanbin, bang ine kinakanbin atawa sabab baranbin, bang ine panemmekbin. ");
INSERT INTO yka_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Peggeˈ mahalgaˈ pe hep umulin amban kinakan duk mahalgaˈ pe hep baranin amban semmek. ");
INSERT INTO yka_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Payamanun bi meˈ owakin. Gaˈi siye magtanem atawa magpagani duk gaˈ niyaˈ pagennaˈ-ennaˈande kinakan. Saguwaˈ pakan Tuhanin du siye. Pasōng teˈed kaˈam mahalgaˈ amban meˈ manuk-manukin. ");
INSERT INTO yka_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sine kaˈam tapatahaˈbi umulbin bisan da ora bang kaˈam magsuse? ");
INSERT INTO yka_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bang gaˈi du tahinangbi bisan kuweˈahat inin, weˈey pe pagsusehanbi sinduwehin? ");
INSERT INTO yka_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Payamanun bi meˈ sumpingin bang saˈingge panuligden. Gaˈi siye maghinang, gaˈi siye magtennun. Bu paˈin akahante kaˈam, bisan Sultan Sulaiman madayahan awwalley, gaˈ bakas makapagsemmek hāpnen kuweˈ dambuwaˈ meˈ sumping inin. ");
INSERT INTO yka_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bang Tuhanin tapasemmekanne pahāp-hāp meˈ sumping sabetin bu gaˈi du siye natas, ellum siye kuweˈitu, pagsumu ineggas, na, kaˈam pe gaˈi tapasemmekanne? Asal kulang sandelbi si Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Daˈa kaˈam suse duk daˈa iye luwal pinikilbin bang ine kinakanbin atawa ininumbin. ");
INSERT INTO yka_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Meˈ aˈa manggaˈi mangataˈuhan Tuhanin, iye hep inin luwal pinikilden. Saguwaˈ kaˈam, subey kaˈam gaˈi magsuse peggeˈ kataˈuhan Samabi Tuhanin weˈ iye inin meˈ sukalbin. ");
INSERT INTO yka_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Saguwaˈ iye subey pinikilbin, sabab pagbayaˈan Tuhanin duk sabab panuhut kinabayaˈannen. Manjari urunganne du kaˈam kēmon sukalbi inin.” ");
INSERT INTO yka_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kaˈam, meˈ tindegkun,” paˈin si Isa, “daˈa kaˈam tinalew bisan kaˈam kulang. Peggeˈ sinna Samabi Tuhanin weˈ magbayaˈ kaˈam kuweˈ iyehin. ");
INSERT INTO yka_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pabellihanun bi alataˈbin duk pangurungun bi ulinen si meˈ mamiskinin. Bang hinangbi inin, kuweˈ du kaˈam dalil ngennaˈ alataˈbin dem pitaka gaˈi ngaˈandang, hātinen alataˈbin gaˈ niyaˈ kaˈubusne laˈi si surgaˈ. Duk laˈi gaˈ niyaˈ aˈa nangkewne duk gaˈ niyaˈ aney makaˈatanne. ");
INSERT INTO yka_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Peggeˈ antag-antag pangennaˈanbi alataˈbin, laˈi isab patetegan ateybin.” ");
INSERT INTO yka_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Manjari paˈin si Isa pe, “Subey kaˈam luwal memes ngagadan pabalikkun, kuweˈ meˈ daraˈakan ngagadan amuden bang moleˈ amban pagkawinan. Magsemmek siye paghinang duk gaˈi palemde payitaˈanin. Pagtekka amuden bu ngalingan amban bukut, magtawus iye lukahande. ");
INSERT INTO yka_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Asal kēgan meˈ daraˈakan miyaˈan bang pagtekka amuden ngape pe siye duk andang siye panyap. Sabennal akahante kaˈam, weˈ patingkoloˈ amuden siye si lamisahan duk tāgadne siye. ");
INSERT INTO yka_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bisan tengaˈ bahangi atawa subu-subu katekkanen, bang kitene pe siye magjaga, bugtuˈ ne kēg meˈ daraˈakan miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Saguwaˈ essebun bi inin, weˈ bang kataˈuhan dapuˈ lumaˈin bang lisag piye katekka panangkewin, tapagjaga iye duk gaˈi tapasagadanne lumaˈnen ilangkat duk inasek. ");
INSERT INTO yka_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Damikkiyan isab kaˈam, subey kaˈam luwal panyap peggeˈ aku, Anak Manusiyaˈin, tekka du ku pitu balik baytu gaˈi ku ase-asebi.” ");
INSERT INTO yka_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Manjari tilew si Petros iye, paˈinne, “Tuwan, dalilan inakanu miyaˈan, para si kami ke hadja atawa para si kēmon?” ");
INSERT INTO yka_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nambung si Isa magdalilan balik, paˈinne, “Bang niyaˈ daraˈakan tapangandelan, duk hantap maghinang, iye iyan tahinang amunen nakuraˈ meˈ daraˈakanne sinduwehin. Bang taˈabut gantaˈ pagurung-urungin, iye mangurung bānyaˈ si meˈ daraˈakanin. ");
INSERT INTO yka_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pagtekka amunen balik, sinna manamal daraˈakan miyaˈan bang kite amunen weˈ tuhutne kēmon pangandaˈakan iyehin. ");
INSERT INTO yka_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sabennal akahante kaˈam, weˈ pangandel amunen du si iye kēmon alataˈnen. ");
INSERT INTO yka_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Saguwaˈ bang saˈupama paˈin daraˈakan miyaˈan dem ateyne, weˈ tiggel pe du tekka amunen, ubus bu papeddiˈanne meˈ pagkasine daraˈakanin sampay meˈ dendehin, duk iye bahannen, magkakan duk maginuman duk maglangohan, ");
INSERT INTO yka_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ubus bu bessuwang tekka amunen ellew gaˈi ase-asene duk waktu gaˈi kataˈuhanne. Na, manjari bininasa teˈed iye weˈ amunen duk pinatuhut iye pī si lugal pinasukuˈ si meˈ manggaˈi makahagad si Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Bang daraˈakanin kataˈuhanne bang ine kinabayaˈan amune hininangnen, bu gaˈi iye magmemes duk hinangne, ilagutan iye manamal. ");
INSERT INTO yka_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Saguwaˈ bang daraˈakanin awam sabab kinabayaˈan amunen, bu niyaˈ tahinangne pataˈ pangaleggahan iye, ilagutan isab iye saguwaˈ gaˈi du kuweˈ ingge. Sine-sine kaˈurungan ekka, ekka isab inase-ase si iyehin. Duk bang pasōng pe ekka pinangandel si iyehin, pasōng pe isab ekka inase-ase si iyehin.” ");
INSERT INTO yka_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Paˈin si Isa pe, “Pitu ku moˈo ebbut si dunya duk kabayaˈankun weˈ asal kayat ne siˈ. ");
INSERT INTO yka_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Niyaˈ meˈ kabinasahan subey talabeyku. Kabohatan ku teˈed samantaˈan gaˈi pe inin puwas. ");
INSERT INTO yka_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Weˈ kannalbi pitu ku moˈo kasanyangan si dunya? Dumaˈin kasanyangan, saguwaˈ akahante kaˈam, pitu ku moˈo jān pagsaggaˈan. ");
INSERT INTO yka_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Peggeˈ tinagnaˈan maˈin, bang niyaˈ lime magdambuwaˈ lumaˈ, magsaggaˈ du siye, tellungan kuntara duwangan duk duwangan kuntara tellungan. ");
INSERT INTO yka_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Magsaggaˈ siye, samahin kuntara anakne lellahin, duk anak lellahin kuntara samanen; saˈihin kuntara anakne dendehin, duk anakne dendehin kuntara saˈinen; matoˈa dendehin kuntara eyuˈanne dendehin, duk eyuˈan dendehin kuntara matoˈane dendehin.” ");
INSERT INTO yka_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Paˈin si Isa isab si meˈ aˈa mabanesin, “Tuˈu si lahatte bi inin, bang maglindem langitin si tampal seddepan, magtawus paˈinbi, ‘Sōng ulan;’ ubus ujud ulan du. ");
INSERT INTO yka_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Duk bang nihup sātanin, paˈinbi, ‘Sōng panas teˈed ellewin;’ duk ujud panas du. ");
INSERT INTO yka_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kaˈam iyan, magmā-mā awam kaˈam. Kataˈuhanbi hatiˈ bang ine hāti meˈ tapandogabi si bantuk langit duk bulakin, weˈey managhāˈ gaˈi kataˈuhanbi hāti meˈ maˈumantag si waktu kuweˈitu inin?” ");
INSERT INTO yka_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Weˈey kaˈam gaˈi taˈu magpikil dihananbi bang ine patut hinangbi? ");
INSERT INTO yka_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bang saˈupama niyaˈ aˈa nuntutan kaˈu sabab utangnu bu binoˈo kew weˈ ne pī si paghukuman, iye mahāpin si kaˈu, bang sābubi pe si lān, boˈonu ne maghāp manuntutan kaˈuhin. Peggeˈ bang gaˈi inin hinangnu, kaw kew lalasne pī si hukum, bu kew sōngan hukumin pī si pulis, duk isi pulisin kew dem kalabusu. ");
INSERT INTO yka_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Akahante kew, weˈ gaˈi teˈed kew lumuwas billaˈi samantaˈan gaˈi tapuwasannu kēmon pinamulta si kaˈuhin. Bisan dambuwaˈ sīn gaˈi kakulangan.” ");
INSERT INTO yka_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sābu miyaˈan, niyaˈ meˈ aˈa tekka pī magaka-aka pu si Isa sabab meˈ aˈa Jalil, dinaˈak koˈ siye pinapatey weˈ Gubnul Pilatus sasangde magsumbaliˈ hayep pagkulubande si langgal mahadjehin. ");
INSERT INTO yka_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sambungan si Isa siye, paˈinne, “Kannalbi ke pasōng duseden amban kēmon meˈ aˈa matuˈu si Jalilin peggeˈ kuweˈ miyaˈan maˈumantag si siyehin? ");
INSERT INTO yka_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Dumaˈin! Saguwaˈ akahante kaˈam, bang gaˈi du pagsusunanbi duk lebbahanbi dusebin, kēmon kaˈam matey du isab. ");
INSERT INTO yka_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Duk meˈ aˈa sampūˈ duk waluˈ mamatey laˈi si Siluwamin, peggeˈ kahebbaˈan siye weˈ lumaˈ malangkewin, kannalbi ke pasōng duseden amban kēmon meˈ aˈa sinduwe mapatennaˈ si Awrusalamin? ");
INSERT INTO yka_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dumaˈin! Saguwaˈ akahante kaˈam, bang gaˈi du pagsusunanbi duk lebbahanbi dusebin, kēmon kaˈam matey du isab.” ");
INSERT INTO yka_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Manjari aka si Isa si siye dalilan inin. Paˈinne, “Niyaˈ dambuwaˈ aˈa taga likus ubas duk laˈi dem likus miyaˈan niyaˈ dam poˈon kayu igira. Dambuwaˈ ellew pī iye laˈi miha buwaˈ igira saguwaˈ gaˈ niyaˈ kasuwaˈne. ");
INSERT INTO yka_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hangkan paˈinne si tungguˈ likusin, ‘Payamanun, tellun tahun ne pagpitu-pituku si poˈon igira inin miha buwaˈne, saguwaˈ gaˈ niyaˈ kasuwaˈku. Tebbenganun ne. Iyuˈ hadja makasimbel meˈ jambangan sinduwehin.’ ");
INSERT INTO yka_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Saguwaˈ nambung tatungguˈ bulakin, paˈinne, ‘Daˈa kew dahuˈ, Tuwan. Ambat tahun inin bungkalku bulakin duk papīhanku pagpalemmek bulak. ");
INSERT INTO yka_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bang buwaˈ iye tahun mapasōng inin, hāp. Saguwaˈ bang gaˈi du buwaˈ, daˈakun saˈ tinebbengan.’” ");
INSERT INTO yka_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dambuwaˈ ellew Sabtuˈ, ellew liˈi, laˈi si Isa magusihat si langgal meˈ Yahudihin. ");
INSERT INTO yka_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Niyaˈ dende laˈi saki weˈ seyitan dem sampūˈ duk walun tahun ne. Bongkok iye duk gaˈi tapatiludne barannen. ");
INSERT INTO yka_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pagkite si Isa iye, ilinganan iye weˈ ne duk paˈinne, “Dende, lumuwas ne kew amban sakinu iyan.” ");
INSERT INTO yka_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Duk binettad weˈ si Isa tangannen si iye. Magtawus iye tumilud duk pinudji weˈ ne Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Saguwaˈ astel manamal nakuraˈ langgal miyaˈan peggeˈ magpakoleˈ si Isa si ellew liˈi. Duk paˈinne si meˈ aˈahin, “Ennem ellew dem da simanahin subey kite bi maghinang. Pitu kaˈam meˈ ellew miyaˈan magpakoleˈ, daˈa bang ellew liˈi.” ");
INSERT INTO yka_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sambungan si Isa iye, paˈinne, “Magmā-mā hadja kaˈam iyan. Weˈ gaˈi kaˈam dangan-dangan lekkahanbi sapiˈbin atawa kuraˈbin amban pangingketanbi iyehin bu boˈobi pinaˈinum bisan si ellew liˈi? ");
INSERT INTO yka_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Dende inin tubuˈ Ibrahim du kuweˈ kaˈamin. Iningketan iye weˈ nakuraˈ seyitanin dem sampūˈ duk walun tahun. Gaˈi ke iye sukat ilekkahan si ellew liˈi?” ");
INSERT INTO yka_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pamissā si Isa miyaˈan, kaˈiyaˈ-iyaˈan teˈed meˈ kuntaranen. Saguwaˈ kēmon meˈ aˈahin kēgan teˈed sabab meˈ hinangan makaˈulaliˈ hininangnen. ");
INSERT INTO yka_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Missā pe si Isa namba, paˈinne, “Ine pamasaliˈante bi pagbayaˈ Tuhan si meˈ aˈanen? Ine pangandalilku iyehin? ");
INSERT INTO yka_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pagbayaˈ Tuhan si meˈ aˈanen,” paˈin si Isa, “kuweˈ dalil da bayuˈ bigi dikiˈ-dikiˈ teˈed tinanem weˈ aˈa dem likusne. Tomoˈ inin duk manjari kayu. Duk meˈ manuk-manukin ngahinang sabakande diyataˈ meˈ pangene.” ");
INSERT INTO yka_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Duk paˈin si Isa balik, “Ine pangandalilku pagbayaˈ Tuhan si meˈ aˈanen? ");
INSERT INTO yka_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pagbayaˈ Tuhan si meˈ aˈanen kuweˈ dalil pasulig ineddoˈ weˈ dende bu pinasaget weˈ ne pī dem tirigu duwempuk-lime kilu. Ubus inaddun weˈ ne. Ubus nulig ne kēmon addunin.” ");
INSERT INTO yka_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Palanjal si Isa tudju Awrusalam duk pabutas iye amban meˈ puweblo duk meˈ kalumaˈan magtoloˈ si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Niyaˈ dangan nilew iye, paˈinne, “Tuwan, kulang du ke meˈ aˈa matimbulin?” Nambung si Isa duk paˈinne si siye, “Pagbayaˈan Tuhanin kuweˈ dalil lumaˈ gawangnen kiput. ");
INSERT INTO yka_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tuyuˈanun bi teˈed paˈasek amban gawang makiputin. Peggeˈ akahante kaˈam, weˈ ekka iyan nuley paˈasek, saguwaˈ gaˈi siye umasek. ");
INSERT INTO yka_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Pagkumuwat ne dapuˈ lumaˈin duk tabagatne ne gawangin, manjari laˈi ne hadja kaˈam si bukut nuttuk si gawang duk ngalingan, ‘O Tuwan, lukahanun kami.’ Sambunganne kaˈam, paˈinne, ‘Gaˈi kataˈuhanku bang amban kaˈam.’ ");
INSERT INTO yka_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Manjari paˈinbi iyan, ‘Gaˈi taˈessebnu? Matuˈuhin magtuhut du kite mangan duk magusihat kew laˈi si puweblo kami.’ ");
INSERT INTO yka_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Saguwaˈ paˈinne iyan si kaˈam, ‘Akahante kaˈam, asal gaˈi kataˈuhanku bang amban kaˈam. Tahalaˈ kaˈam amban aku, kēmon kaˈam maghinangan malaˈatin.’ ");
INSERT INTO yka_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Manjari magmatey kaˈam iyan laˈi duk magtageˈot meˈ impenbin bang kitebi laˈi diyalem kapapuˈanbin disi Ibrahim duk si Isahak duk si Yakub duk kēmon meˈ kanabi-nabihanin, bu kaˈam laˈi hadja si bukut. ");
INSERT INTO yka_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Duk tekka du iyan pī meˈ aˈahin amban ampat pidjū alamin magtipun, duk ningkoloˈ siye laˈi magkakanan dem pagbayaˈan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Duk payamanun bi, niyaˈ meˈ aˈa dumambuli kuweˈituhin, dumehellu du si pasōngan, duk niyaˈ meˈ aˈa dumehellu kuweˈituhin, dumambuli du si pasōngan.” ");
INSERT INTO yka_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Manjari niyaˈ tekka pī meˈ Pariseo duk paˈinde pu si Isa, “Palanjal ne kew, peggeˈ batang koˈ kew papatey Sultan Herod.” ");
INSERT INTO yka_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Paˈin si Isa si siye, “Pī kaˈam, akahanun bi si Herod maˈakkalan miyaˈan weˈ maˈin duk sumu palanjalku hinangkun magpaluwas seyitan duk magpakawuliˈ meˈ masakihin, duk si katellu ellewnen ubus ne hinangkun. ");
INSERT INTO yka_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Saguwaˈ subey ku palanjal si palumengngananku maˈin, duk sumu, duk sampay sumudde. Gaˈ du niyaˈ umantag si aku tuˈu. Peggeˈ meˈ nabi maˈekkahin pinapatey laˈi si Awrusalam.” ");
INSERT INTO yka_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Manjari dukka si Isa sabab hinangan meˈ aˈa si Awrusalamin duk paˈinne, “O meˈ aˈa Awrusalam, suse ku sabab kaˈam. Luwal papateybi meˈ nabihin duk pagtibaganbi meˈ dinaˈak Tuhan mapiyu si kaˈamin. Mimpiye ne kaˈam batang pagtipunku duk ipatku kuweˈ dalil bukaran magtipun meˈ usuynen diyawaˈ peppikne, saguwaˈ gaˈi kaˈam ngatu. ");
INSERT INTO yka_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Payamanun bi, tinayikutan ne lahatbin weˈ Tuhanin. Duk akahante kaˈam weˈ gaˈi ne ku teˈed kitebi samantaˈan gaˈi tekka ellew pagpaˈinbin, ‘Pudjite bi pinapitu Tuhanin!’” ");
INSERT INTO yka_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Dambuwaˈ ellew liˈi, pī si Isa mangan si lumaˈ dambuwaˈ nakuraˈ meˈ Pariseohin. Paglaˈi iye, pinateng-patengan iye weˈ meˈ aˈa malaˈihin. ");
INSERT INTO yka_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Niyaˈ laˈi aˈa saki, bahaˈ lengngennen duk pusuˈnen. ");
INSERT INTO yka_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tinilew weˈ si Isa meˈ guru si saraˈ āgamahin duk meˈ Pariseohin, paˈinne, “Ngalanggalan saraˈ ke magpakoleˈ si ellew liˈihin atawa gaˈi?” ");
INSERT INTO yka_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Saguwaˈ gaˈ siye nambung. Manjari inantan weˈ si Isa aˈa masakihin duk pinakoleˈ weˈ ne, ubus bu pinapoleˈ ne weˈ ne. ");
INSERT INTO yka_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ubus miyaˈan, tilewne meˈ aˈahin, paˈinne, “Ine hinangbi bang upama niyaˈ anakbi atawa sapiˈbi laboˈ dem kupung baytu ellew liˈi? Araˈ-araˈku asal magtawus kaˈam pī nabang iye bisan ne ellew liˈi.” ");
INSERT INTO yka_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gaˈ ne siye kapanganjawab. ");
INSERT INTO yka_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tapandoga si Isa meˈ aˈa tabatikin, weˈ peneˈde meˈ paningkoloˈan para si meˈ mabangsahanin. Hangkan inakahan siye weˈ ne dambuwaˈ dalilan, paˈinne, ");
INSERT INTO yka_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bang kew tabatik pī si pagkawinan, daˈa kew ningkoloˈ si paningkoloˈan para si meˈ mabangsahanin. Kaw-kaw pe niyaˈ bangsahan amban kaˈu tabatik. ");
INSERT INTO yka_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Bu ne pī dapuˈ pagkādjaˈanin duk magpaˈin si kaˈu, ‘Palinda be kew. Ambat aˈa inin ningkoloˈ luˈu.’ Manjari iyaˈ kew bu subey ne kew ningkoloˈ si tindakan. ");
INSERT INTO yka_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Saguwaˈ bang kew tabatik, ningkoloˈ kew si tindakan, duk pagpī dapuˈ pagkādjaˈanin, paˈinne du si kaˈu, ‘Bagay, daˈa kew ningkoloˈ luˈu. Pī kew pakōkan.’ Manjari takite du weˈ meˈ sinduwe tabatikin weˈ pinahadje kew. ");
INSERT INTO yka_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Peggeˈ sine-sine mahadje dine, pinadiyawaˈ du. Duk sine-sine madiyawaˈ dine, pinahadje du.” ");
INSERT INTO yka_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Manjari paˈin si Isa si aˈa makabatik iyehin, “Na, kaˈu isab, bagay, bang kew ngahinang pagjamu-jamuhan, daˈa iye batikun meˈ bagaynun atawa meˈ pungtinaˈinun atawa meˈ usbanun, atawa meˈ saweˈnu magtapit lumaˈ madayahanin. Peggeˈ bang siye binatiknun, batikde du kew isab iyan bang siye magkādjaˈan. Manjari tatumbasande hininangnu si siyehin. ");
INSERT INTO yka_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Saguwaˈ bang kew ngahinang pagjamu-jamuhan, iye batikun meˈ aˈa mamiskinin, makukuˈin, mapengkaˈin, duk mapessekin. ");
INSERT INTO yka_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bang inin hinangnu, kēgan du kew iyan manamal peggeˈ gaˈi kew katumbasande. Tuhanin manumbasan kaˈuhin si ellew dambuli bang pinakellum ne balik meˈ aˈa mabentelin.” ");
INSERT INTO yka_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dangan meˈ mamangan malaˈihin, pagkalene meˈ binissā si Isa miyaˈan, paˈinne, “Asal kēgan paˈin aˈa mamangan si pagjamu-jamuhan dem pagbayaˈan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Manjari inakahan iye weˈ si Isa dambuwaˈ dalilan, paˈinne, “Niyaˈ aˈa bakas magpanyap pagjamu-jamuhan hadje duk ekka tabatiknen. ");
INSERT INTO yka_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pagtekka ellew pagjamu-jamuhin, dinaˈak weˈ ne daraˈakannen pī si meˈ tabatiknen moˈo bissā, pinaˈin, ‘Dayiˈ ne kaˈam, panyap ne kēmon.’ ");
INSERT INTO yka_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Saguwaˈ saliˈ-saliˈ siye kēmon magtubad. Paˈin tagnaˈ papīhannen, ‘Gaˈi ku tapī peggeˈ bakas ku makabelli bulak duk subey dahuˈ payamanku pī. Daˈa ku puggutanun.’ ");
INSERT INTO yka_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Duk paˈin dambuwaˈin, ‘Bakas ku makabelli sapiˈ sampūˈ kayuˈ duk tiyaˈ ku dahuˈ pī nginaman siye bang kapagbadjaˈan ke. Daˈa ku hadja puggutanun.’ ");
INSERT INTO yka_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Duk paˈin dambuwaˈin, ‘Baˈahu du ku bakas kinawin, hangkan gaˈi ku tapiyu.’ ");
INSERT INTO yka_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Manjari hap lumaˈ ne daraˈakanin duk inakahan weˈ ne amunen. Astel teˈed amunen pagkalene miyaˈan duk paˈinne si daraˈakannen, ‘Pakale kew, pī kew palakkes si meˈ kalsara duk si meˈ kalān-lānan tuˈu si lahat inin, duk boˈohun pitu meˈ mamiskinin, meˈ makukuˈin, meˈ mapessekin, duk meˈ mapengkaˈin.’ ");
INSERT INTO yka_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Gaˈ tiggel tekka ne balik daraˈakanin duk paˈinne si amunen, ‘Bakas hinangku ne pangandaˈakannun, Tuwan, saguwaˈ niyaˈ pe lugal.’ ");
INSERT INTO yka_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Manjari paˈin amuhin si daraˈakannen, ‘Pī kew si meˈ kalān-lānan mapadiyataˈin duk si meˈ lahat diyalemin duk buyuˈ-buyuˈun meˈ aˈahin nuhut pitu supaya pennoˈ lumaˈkun. ");
INSERT INTO yka_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Peggeˈ akahante kaˈam,’ paˈinne, ‘gaˈ niyaˈ meˈ aˈa tabatikku dehelluhin makakinam kinakan pinanyapkun.’” ");
INSERT INTO yka_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Palanjal ne isab si Isa si palengngananne duk banes teˈed aˈa nuhut iye. Manjari paharap iye si siye duk paˈinne, ");
INSERT INTO yka_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bang niyaˈ aˈa pitu mabayaˈ patindeg si aku, subey lasane si akuhin hadje amban lasane si saˈi-samanen, duk si anak-andanen, duk si meˈ pungtinaˈinen lella-dende. Duk bisan lasane si dinen subey gaˈi pahadje amban lasane si akuhin. Bang gaˈi du kuweˈ inin, gaˈi iye makajari tindegku. ");
INSERT INTO yka_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Duk subey iye maglillaˈ nandal kabinasahan duk bisan pe pinapatey sabab panuhutne akuhin. Dalilnen, kuweˈ iye moˈo olom pamapateyan iyehin. Bang gaˈi iye maglillaˈ bu nuhut aku, gaˈi iye makajari tindegku. ");
INSERT INTO yka_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bang niyaˈ kaˈam mabayaˈ matengge lumaˈ hadje, ningkoloˈ dahuˈ kaˈam ngalkulane bang piye gastubin, supaya kataˈuhanbi bang araˈ-araˈ takoleˈbi du ke ngagastuhan sampay ubus atawa gaˈi. ");
INSERT INTO yka_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Peggeˈ bang gaˈi kalkulabi dahuˈ, pagtumengge ne meˈ olomnen bu gaˈ niyaˈ pangubusbi, ujudnen kēmon mangite miyaˈan ngahinang kaˈam hadja dagey. ");
INSERT INTO yka_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Paˈinde, ‘Aˈa inin takoleˈne nagnaˈan lumaˈnen matengge saguwaˈ gaˈi taˈubusne.’ ");
INSERT INTO yka_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Atawa bang saˈupama niyaˈ sultan sōng pī magbonoˈ duk sultan seddili, ningkoloˈ iye mikil-mikil dahuˈ bang araˈ-araˈ makaˈatu ke iye duk tindegne sampūˈ ngibuhin magbonoˈ duk sultan duwempūˈ ngibu tindegnen. ");
INSERT INTO yka_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bang araˈ-araˈ gaˈi iye makaˈatu, na, tala pe kuntaranen, ngandaˈak ne iye meˈ aˈane pī pasampang moˈo bissā weˈ mabayaˈ ne iye maghāp. ");
INSERT INTO yka_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Damikkiyan isab kaˈam,” paˈin si Isa, “pikil-pikilun bi dahuˈ peggeˈ bang gaˈi du kaˈam maglillaˈ nayikutan kēmonbin, gaˈi kaˈam makajari tindegku.” ");
INSERT INTO yka_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Magdalilan ne isab si Isa, paˈinne, “Kataˈuhanbi du weˈ asinin asal hāp. Saguwaˈ bang asinin gaˈ ne niyaˈ lessane, gaˈi ne maˈasin balik. ");
INSERT INTO yka_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gaˈ ne niyaˈ kagunahanne. Gaˈi bisan taguna pagpalemmek bulak. Saguwaˈ ilakasan hadja weˈ aˈa. Na,” paˈin si Isa, “amey-amey pakalehun bi bang niyaˈ pinaˈin si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dambuwaˈ ellew ekka meˈ aˈa magpāku-pāku sukey para si gubelno duk meˈ aˈa sinduwehin gaˈi nuhut saraˈ āgama, pī siye patapit pu si Isa peggeˈ bayaˈ siye pakale si usihatnen. ");
INSERT INTO yka_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Manjari meˈ Pariseohin duk meˈ guru si saraˈ āgamahin ngunub-ngunub, paˈinde, “Aˈa inin magtuhut-tuhut duk meˈ aˈa dusehanin duk sampay mangan magsawu siye.” ");
INSERT INTO yka_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hangkan inaka weˈ si Isa si siye dalilan inin, paˈinne, ");
INSERT INTO yka_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Saˈupama, bang niyaˈ kaˈam taga bili-bili dahatus ekkahannen bu ne niyaˈ dambuwaˈ sumapeˈ, ine enteˈ hinangbi? Bugtuˈ ambananbi siyampūˈ duk siyamin laˈi si kahayangan duk pī kaˈam miha dambuwaˈ masumapeˈin tiggelan gaˈi takasuwaˈbi. ");
INSERT INTO yka_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Duk pagtakasuwaˈbi ne, sinna teˈed kaˈam hangkan pinippi weˈ bi binoˈo hap lumaˈ. ");
INSERT INTO yka_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pagtekka si lumaˈ, ilinganan weˈ bi meˈ bagaybin duk meˈ saweˈbi magtapit lumaˈin dinaˈak magtipun laˈi si lumaˈbi, duk paˈinbi si siye, ‘Magkēg kite bi peggeˈ takasuwaˈku ne bili-biliku masumapeˈin.’ ");
INSERT INTO yka_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Akahante kaˈam,” paˈin si Isa, “damikkiyan du isab pasōng magkēg malaˈi si surgaˈin bang niyaˈ dambuwaˈ aˈa dusehan magsusun duk ngalebbahan dusenen amban magkēg siye sabab siyampūˈ duk siyam meˈ aˈa magpaˈin weˈ bentel siye duk gaˈi siye subey magsusun.” ");
INSERT INTO yka_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Atawa,” paˈinne, “saˈupama niyaˈ dende taga sampūˈ dublun bu ne lepas dambuwaˈin, ine enteˈ hinangne? Bugtuˈ mekket iye payitaˈan bu pahidanne dem lumaˈin duk pihane pahāp-hāp tiggelan gaˈi takasuwaˈne. ");
INSERT INTO yka_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Duk pagtakasuwaˈne ne, lingananne meˈ bagaynen duk meˈ saweˈne magtapit lumaˈin dinaˈak magtipun si lumaˈne. Duk paˈinne si siye, ‘Magkēg kite bi, peggeˈ takasuwaˈku ne dublunku malepasin.’ ");
INSERT INTO yka_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Akahante kaˈam,” paˈin si Isa, “damikkiyan magkēg du isab meˈ malaˈikat Tuhanin bang niyaˈ dambuwaˈ aˈa dusehan magsusun duk ngalebbahan dusenen.” ");
INSERT INTO yka_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Manjari paˈin si Isa pe, “Niyaˈ dambuwaˈ aˈa taga anak lella duwangan. ");
INSERT INTO yka_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dambuwaˈ ellew paˈin salihin si samanen, ‘Ammaˈ, bahagiˈun ne alataˈnun duk pangurungun ne aku bahagiˈkun.’ Na, iye ne miyaˈan, binahagiˈ ne weˈ aˈahin alataˈnen si duwangan anaknen. ");
INSERT INTO yka_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Gaˈ tiggel, pinabellihan weˈ salihin bahagiˈnen, eddoˈne sīnnen, ubus bu lumengngan iye pī si lahat tala. Paglaˈi iye, inubus weˈ ne sīnnen si meˈ bayuˈ-bayuˈan gaˈ niyaˈ kagunahanne. ");
INSERT INTO yka_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pagubus ne tagastune kēmon, bessuwang isab inunus teˈed lahat miyaˈan. Manjari kasukalan teˈed iye. ");
INSERT INTO yka_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hangkan pī iye si dambuwaˈ aˈa si lahat miyaˈan duk manjari daraˈakanne. Dinaˈak iye pī weˈ aˈahin si bulakne ngipat meˈ bawi. ");
INSERT INTO yka_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hawal kawugtuˈnen, mabayaˈ ne kakanne bisan kinakan bawihin, saguwaˈ gaˈ niyaˈ ngurungan iye bisan ine. ");
INSERT INTO yka_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Manjari bahune makapikil kadupangannen duk paˈinne dem ateyne, ‘Kēmon daraˈakan samakun, maglabi-labi kinakanden. Bu aku inin tiyaˈ ne ku sōng matey tuˈu weˈ kawugtuˈin. ");
INSERT INTO yka_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Hāp pe ku moleˈ pī pu si Ammaˈ duk paˈinku si iye: Ammaˈ, kapagduse ku si Tuhan duk si kaˈu. ");
INSERT INTO yka_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Gaˈi ne ku pataˈ ēnannu anaknu. Kimmatanun ne ku hadja kuweˈ dambuwaˈ meˈ daraˈakannun.’ ");
INSERT INTO yka_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ubus bu tahalaˈ ne iye duk lumengngan ne iye pī balik si samanen. “Saguwaˈ tala-tala pe iye, takite ne iye weˈ samanen. Maˈaseˈ teˈed samanen si iye duk magubas iye pī ngalipunesan anaknen. ");
INSERT INTO yka_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Paˈin anaknen si iye, ‘Ammaˈ, kapagduse ku si Tuhan duk si kaˈu. Gaˈi ne ku pataˈ ēnannu anaknu.’ ");
INSERT INTO yka_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Saguwaˈ ilinganan weˈ samanen meˈ daraˈakanin duk paˈinne si siye, ‘Palakkes kaˈam, boˈohun bi pitu semmek tamanan mahāp lu duk pasemmekanun bi iye. Pasinsimanun bi isab duk patehompaˈanun bi. ");
INSERT INTO yka_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ubus pī kaˈam, eddoˈun bi anak sapiˈ pinalemmekante bi ley bu sumbaliˈun bi. Magjamu-jamu kite bi duk maglami-lami. ");
INSERT INTO yka_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Peggeˈ anakku inin kuweˈ bakas matey, bu ellum du balik. Kuweˈ iye bakas lepas, bu tapoleˈ du.’ Manjari nagnaˈ ne siye maglami-lami. ");
INSERT INTO yka_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Saguwaˈ anakne sakahin baytu laˈi miyaˈan si tanaˈ. Pag hap lumaˈ ne iye duk sakaliˈ iye tapit, niyaˈ takalene magkulintang duk magpansak laˈi diyalem lumaˈden. ");
INSERT INTO yka_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ilinganan weˈ ne dangan meˈ daraˈakanin duk tinilew weˈ ne bang ine paglami-lamihanin. ");
INSERT INTO yka_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Paˈin daraˈakanin si iye, ‘Tekka ne salinun duk dinaˈak sinumbaliˈ weˈ samanun sapiˈ pinalemmekanin peggeˈ salinu inin gaˈ niyaˈ baya-bayane.’ ");
INSERT INTO yka_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Saguwaˈ astel iye duk gaˈi iye bayaˈ padiyalem. Paluwas samanen pī muyuˈ-muyuˈ iye binoˈo padiyalem. ");
INSERT INTO yka_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Saguwaˈ sambunganne samanen, paˈinne, ‘Payamanun Ammaˈ, piyen tahun ne paghinangku si kaˈuhin kuweˈ dambuwaˈ banyagaˈnu. Gaˈ niyaˈ pangandaˈakannu aku weˈ gaˈi hinangku. Saguwaˈ gaˈ ku bakas kaˈurungannu bisan dambuwaˈ anak kambing duk ku kapagjamu-jamu duk meˈ bagaykun. ");
INSERT INTO yka_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Saguwaˈ pagtekka pitu anaknu iyan, pagubus pakaˈatanne alataˈnun si meˈ dende dupang, sinumbaliˈ ne weˈ nu para si iye sapiˈ pinalemmekannun.’ ");
INSERT INTO yka_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Totoˈ,’ paˈin samanen, ‘luwal du kew tuˈu si aku duk kēmon maniyaˈ si akuhin, si kaˈu du. ");
INSERT INTO yka_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Talep kite maglami-lami duk magkēg, peggeˈ salinu iyan kuweˈ bakas matey, bu ellum du balik. Kuweˈ iye bakas lepas, bu tapoleˈ du.’” ");
INSERT INTO yka_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Manjari inakahan weˈ si Isa meˈ tindegnen dalilan seddili. Paˈinne, “Niyaˈ dambuwaˈ aˈa dayahan, hininang weˈ ne dambuwaˈ meˈ daraˈakannen tatungguˈ si meˈ alataˈnen kēmon. Manjari tasumbung si iye tatungguˈ miyaˈan weˈ luwal koˈ ngakkal duk pakaˈatanne alataˈ amunen. ");
INSERT INTO yka_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hangkan pinasan iye weˈ ne duk pagtekka iye, paˈin amunen si iye, ‘Ine teˈ takaleku sabab kaˈu inin? Sōnganun ne si aku listahan meˈ bayuˈ-bayuˈan si antanannun duk sīn mapaˈasek duk sīn mapaluwasin peggeˈ gaˈi ne kew hinangku tatungguˈ.’ ");
INSERT INTO yka_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Paˈin daraˈakanin si dine, ‘Ine enteˈ hinangku kuweˈitu? Tiyaˈ ne ku patahalaˈ amukun. Gaˈi ne ku basag maghinang si bulak duk leman ku isab māku-māku sīn. ");
INSERT INTO yka_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, kataˈuhanku ne,’ paˈinne, ‘bang ine subey hininangkun, duk bang pinatahalaˈ ne ku amban hinangkun, niyaˈ du meˈ aˈa makajari papīhanku.’ ");
INSERT INTO yka_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Manjari ilinganan weˈ ne dangan-dangan kēmon meˈ taga utang si amunen. Paˈinne si dehellu mapīhin, ‘Piye utangnun si amukun?’ ");
INSERT INTO yka_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Dahatus mital isellan,’ sambungnen. Manjari paˈinne si iye, ‘Tiyaˈ disibunun. Ningkoloˈ kew padayiˈ bu sulatun luˈu limempūˈ mital hadja.’ ");
INSERT INTO yka_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Duk paˈinne si dambuwaˈin, ‘Kaˈu, piye utangnun?’ Paˈinne, ‘Dahatus karut paley.’ Manjari paˈinne si iye, ‘Tiyaˈ disibunun, sulatun luˈu walumpūˈ.’ ");
INSERT INTO yka_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pagkale amunen hininang daraˈakanne mangakkal miyaˈan, sinanglitan pe iye weˈ ne peggeˈ akkalan iye. Taˈu koˈ iye mikil para si pasōngannen.” Manjari paˈin si Isa, “Meˈ aˈa manggaˈi manuhut Tuhanin akkalan teˈed amban meˈ aˈa manuhut Tuhanin, peggeˈ taˈu siye maˈuntungan saweˈden para si di kahāpanden. ");
INSERT INTO yka_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Hangkan akahante kaˈam,” paˈin si Isa, “gunahun bi alataˈbi tuˈu si dunyahin paghinang hāp, supaya bang taˈabut kaˈam matey duk gaˈi ne tagunabi alataˈbin, tinayimaˈ du kaˈam laˈi si lahat patennaˈanbi salama-lamahin. ");
INSERT INTO yka_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Bang kapangandelan aˈahin si alataˈ kuweˈahat, kapangandelan du isab iye si alataˈ ekka. Damikkiyan isab bang aˈahin gaˈi kapangandelan si alataˈ kuweˈahat, gaˈi du isab iye kapangandelan si alataˈ ekka. ");
INSERT INTO yka_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na, bang kaˈam pinasukuˈan alataˈ tuˈu si dunya inin bu gaˈi kaˈam kapangandelan, asal gaˈi pinangandel si kaˈam alataˈ mabennalin. ");
INSERT INTO yka_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Duk bang gaˈi kaˈam kapangandelan ngantan alataˈ dumaˈin si kaˈamin, gaˈi pinangurung si kaˈam sukuˈ si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Gaˈ niyaˈ daraˈakan makajari magbanyagaˈ si duwe amu. Peggeˈ kalasahanne iyan dambuwaˈin duk kabunsihanne dambuwaˈin. Atawa tuhutne teˈed dambuwaˈin duk gaˈi asipne dambuwaˈin. Bang pilakin mamahalgaˈ si kaˈamin, gaˈi kaˈam makajari maghinang isab si Tuhan.” ");
INSERT INTO yka_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Takale weˈ meˈ Pariseohin meˈ pinaˈin si Isa miyaˈan. Pinagsayehan si Isa weˈ de peggeˈ sinna siye si pilak. ");
INSERT INTO yka_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Saguwaˈ paˈin si Isa si siye, “Kaˈam iyan magpakite si aˈa weˈ bentel kaˈam, saguwaˈ kataˈuhan Tuhanin du dem ateybin. Meˈ kinimmatan mahalgaˈ weˈ meˈ aˈahin, gaˈ du niyaˈ kagunahanne bang si Tuhan. ");
INSERT INTO yka_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Masa gaˈ pe pitu si Yahiya magpandi-pandi meˈ aˈahin, iye minahalayakin sabab saraˈ si Musahin duk meˈ tasulat kanabihanin. Saguwaˈ kemuwe pitu Yahiya duk sampay maˈin iye minahalayakin aka-aka hāp sabab pagbayaˈan Tuhanin duk meˈ aˈahin magtuyuˈ teˈed duk siye umasek pī si pagbayaˈan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Saguwaˈ saraˈ si Musahin asal gaˈi du pinda kapatutnen. Mura pe ilūnan bulak duk langitin amban dambuwaˈ balis si saraˈin ginantiˈan.” ");
INSERT INTO yka_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Paˈin si Isa pe, “Sine-sine nimanan andanen bu maganda seddili, magjina iye. Duk sine-sine maganda si dende bituwanan, magjina iye.” ");
INSERT INTO yka_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ubus paˈin si Isa, “Niyaˈ dambuwaˈ aˈa dayahan, luwal magsemmek mahalgaˈ manamal duk kahabaˈ ellew hāp hadja kinakannen. Gaˈ niyaˈ kulang si iye. ");
INSERT INTO yka_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Duk niyaˈ isab aˈa miskin, ēnnen si Lasarus. Lapat puhuˈnen weˈ dugsal. Kahabaˈ ellew binoˈo iye pī si tarangka lumaˈ aˈa madayahan miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Peggeˈ kabayaˈannen bang du siˈ iye kaˈurungan meˈ lebbi-lebbi kinakan aˈa dayahanin duk iye makaˈakan. Bisan meˈ asuhin pī ngandelatan meˈ dugsalnen. ");
INSERT INTO yka_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Manjari matey aˈa mamiskin miyaˈan duk binoˈo iye weˈ meˈ malaˈikatin pī si palaˈihan Ibrahimin si surgaˈ. Ubus matey du isab aˈa dayahanin duk kinubul iye. ");
INSERT INTO yka_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Laˈi si ahilat kapeddiˈan manamal aˈa dayahanin. Pahangad iye duk takitene laˈi si katalahan Ibrahim. Takitene isab si Lasarus laˈi si bihing Ibrahim. ");
INSERT INTO yka_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Magtawus iye ngalingan pu si Ibrahim. ‘O Apuˈ Ibrahim,’ paˈinne. ‘Maˈaseˈ ne kew si aku. Daˈakun Lasarus pitu. Ambat patottokne timbōˈnen dem boheˈ bu pettakanne dellaˈkun peggeˈ peddiˈan ku teˈed tuˈu dem ebbut inin.’ ");
INSERT INTO yka_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Saguwaˈ paˈin Ibrahim, ‘Bagay, essebun weˈ tasangkanu ne kēmon bayuˈ-bayuˈan mahāpin kaˈellumnun, bu si Lasarus tasangkanen malaˈatin. Saguwaˈ kuweˈitu hāp ne pāsahannen tuˈu, bu kaˈu magsandal peddiˈ. ");
INSERT INTO yka_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Duk dumaˈin hadja inin, saguwaˈ si ellette bi niyaˈ kongkong luha pinapī, supaya matuˈu mabayaˈ mapiyuhin gaˈi tapiyu, duk damikkiyan maluˈuhin gaˈi tapitu.’ ");
INSERT INTO yka_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Manjari paˈin aˈa dayahanin, ‘Bang sa iyan, Apuˈ, gaˈ dapatku. Saguwaˈ pabuyuˈ-buyuˈ ku si kaˈu, daˈakun si Lasarus pī si lumaˈ samakun, ");
INSERT INTO yka_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","peggeˈ niyaˈ laˈi lime pungtinaˈiku lella. Daˈakun siye sinessaˈan pu Lasarus subey pindahande kawul-piˈilden supaya siye gaˈi tapitu si lahat pagsandalan peddiˈ inin.’ ");
INSERT INTO yka_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Saguwaˈ paˈin Ibrahim, ‘Laˈi du si siye meˈ tasulat si Musahin duk tasulat meˈ kanabihan sinduwehin. Ambat pakalede.’ ");
INSERT INTO yka_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Gaˈi be pakalede, Apuˈ Ibrahim,’ paˈinne. ‘Saguwaˈ bang niyaˈ dambuwaˈ aˈa matey ellum balik bu pī si siye, asal pagsusunande iyan duseden duk lebbahande ne.’ ");
INSERT INTO yka_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Saguwaˈ paˈin Ibrahim si iye, ‘Bang gaˈi pakalede meˈ tasulat si Musahin duk meˈ kanabihan sinduwehin, gaˈi du siye iyan tasegeˈ bisan pe niyaˈ aˈa bakas matey bu ellum balik hap pī si siye ngakahan siye.’” ");
INSERT INTO yka_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Manjari paˈin si Isa si meˈ tindegnen, “Bugtuˈ niyaˈ teˈed meˈ sassat tekka si manusiyaˈ makapaduse siye. Saguwaˈ kaˈaseˈ-aseˈ aˈa manassat saweˈnen duk iye makaduse, peggeˈ asal legga Tuhanin teˈed iye. ");
INSERT INTO yka_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hāp pe siˈ iye miyaˈan tapatowengan dahuˈ batu hadje si kellongne bu ilaboˈ iye pī dem tahik duk hadja gaˈi tasassatne magduse dangan meˈ madiyawaˈ ateynen duk masandel si akuhin. ");
INSERT INTO yka_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hangkan pahatul-hatul kaˈam. Bang saweˈnun kapagduse si kaˈu, boˈohun magbissā duk toloˈanun. Bang pagsusunanne dusenen duk lebbahanne dusenen ampunun iye. ");
INSERT INTO yka_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bang dem da ellewin kapagduse iye mimpituˈ si kaˈu duk mimpituˈ isab iye piyu si kaˈu māku ampun, subey iye ampunnu.” ");
INSERT INTO yka_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Manjari paˈin meˈ tindeg si Isa bakas kawakilannen si iye, Panuhutanden, “Tuwan, pabasagun sandel kami si Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nambung Panuhutanden, paˈinne, “Bang sandel kaˈam si Tuhan bisan hadja kuweˈahat, dalilnen kuweˈ hadja hadjehan bigi mustasa, makajari paˈinbi si poˈon kayu mahadje miyaˈan, ‘Pabeddut kew duk palinda kew pī dem tahik,’ ubus bu tuhutne du pinaˈinbin.” ");
INSERT INTO yka_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Paˈin si Isa pe, “Bang saˈupama dangan kaˈam taga daraˈakan duk hinangnen magbadjaˈ si tanaˈ atawa magipat hayepbi. Bang tekka iye amban paghinangannen, paˈinbi ke si iye, ‘Na, mangan ne kew?’ ");
INSERT INTO yka_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Asal gaˈi. Saguwaˈ iye paˈinbi si iye, ‘Magsayin ne kew bu panyapun kinakankun duk ku makaˈakan. Bang ku ubus, meke ne kew mangan.’ ");
INSERT INTO yka_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Magsampūˈ-sāmat pe ke kaˈam si daraˈakanbin peggeˈ hinangne pangandaˈakanbin? Gaˈi du. ");
INSERT INTO yka_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Damikkiyan kaˈam isab, bang tahinangbi ne kēmon pangandaˈakan si kaˈamin, paˈinun bi, ‘Kite bi inin meˈ daraˈakan gaˈi pataˈ sinanglitan, peggeˈ iye du hadja tahinangten, sukuˈ hininangten.’” ");
INSERT INTO yka_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Palumengngan si Isa hap Awrusalamin, palabey iye amban ellet lahat Samariya duk lahat Jalil. ");
INSERT INTO yka_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pagtapit ne iye si kalumaˈan, niyaˈ pī si iye sampūˈ aˈa inipul. Nengge siye patala-tala, ");
INSERT INTO yka_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","duk ngalingan siye, paˈinde, “O Isa! Tuwan! Maˈaseˈ ne kew si kami.” ");
INSERT INTO yka_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pagkite si Isa siye, paˈinne si siye, “Pī kaˈam si meˈ imamin, ambat lilingde baranbin weˈ kawuliˈan ne.” Duk sasangde mapīhin, kawuliˈan ne siye. ");
INSERT INTO yka_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dangan siye, pagkitene weˈ kawuliˈan ne iye, magtawus iye balik duk pinudji weˈ ne Tuhanin pinapales. ");
INSERT INTO yka_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pasujud iye si antag bettis si Isa magpasalamat si iye. Aˈa inin bangsa Samariya. ");
INSERT INTO yka_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Paˈin si Isa, “Dumaˈin ke sampūˈ aˈa kawuliˈanin? Antag ne siyamin? ");
INSERT INTO yka_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Weˈey aˈa liyu-liyu inin du hadja mabalik mapitu magpasalamat si Tuhanin?” ");
INSERT INTO yka_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Manjari paˈin si Isa si iye, “Nengge kew, bagay, duk palanjal ne kew. Kawuliˈan kew peggeˈ sandel kew.” ");
INSERT INTO yka_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Dambuwaˈ ellew tinilew si Isa weˈ meˈ Pariseohin bang sumiyan ne Tuhanin magbayaˈ si meˈ aˈahin. Sambunganne siye, paˈinne, “Gaˈ niyaˈ takite bang nagnaˈ ne Tuhanin magbayaˈ. ");
INSERT INTO yka_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Gaˈ iyan niyaˈ magpaˈin, ‘Payamanun bi, tiyaˈ tuˈu pagbayaˈan Tuhanin!’ atawa, ‘Īˈ laˈi!’ Peggeˈ pagbayaˈan Tuhanin luˈu diyalembi.” ");
INSERT INTO yka_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Manjari paˈin si Isa si meˈ tindegnen, “Niyaˈ du iyan meˈ ellew si pasōngan asal bayaˈ teˈed kitebi weˈ aku, Anak Manusiyaˈin, magbayaˈ ne. Bayaˈ takitebi bisan da ellew hadja, saguwaˈ gaˈi pe takitebi. ");
INSERT INTO yka_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Niyaˈ iyan magpaˈin si kaˈam, ‘O, īˈ iye laˈi!’ atawa, ‘Tiyaˈ iye tuˈu!’ Daˈa kaˈam pī miha aku. ");
INSERT INTO yka_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Peggeˈ aku, Anak Manusiyaˈin, bang ne ku pitu, keddut papitukun duk takite meˈ aˈahin kēmon, kuweˈ lalat bessuwang ninagan dunyahin amban dengkepak pī si dengkepak. ");
INSERT INTO yka_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Saguwaˈ meke inin umantag, subey ku dahuˈ magsandal kabinasahan duk gaˈi ku tinayimaˈ weˈ meˈ aˈa kuweˈituhin. ");
INSERT INTO yka_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Si pasōngan, bang ne ku pitu balik si dunya, meˈ hinangan meˈ aˈahin kuweˈ du hinangan meˈ aˈa masa si Nu ley. ");
INSERT INTO yka_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Masa miyaˈan mangan siye duk nginum, maganda siye duk magella sampay taˈabut ellew paˈasek si Nu dem kappalin. Manjari ilaseyan weˈ Tuhanin dunyahin duk magmula siye kēmon. ");
INSERT INTO yka_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Damikkiyan du isab kuweˈ masa si Lot ley. Mangan siye duk nginum, magbelli duk magdagang, magtanem duk magpatengge meˈ lumaˈ. ");
INSERT INTO yka_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Saguwaˈ pagtekka ellew patahalaˈ si Lot amban puweblo Sodomin, laboˈ kuweˈ ulan ebbutin duk meylangin amban diyataˈ langit duk magmula siye kēmon. ");
INSERT INTO yka_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Damikkiyan du isab kuweˈ miyaˈan hinangan meˈ aˈa si dunyahin bang tekka ne ellew pamakite akuhin, aku Anak Manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Pagtekka ellew miyaˈan, bang niyaˈ aˈa si luwasan lumaˈne bu meˈ kēmonnen laˈi diyalem lumaˈ, subey ne iye gaˈi padiyalem ngeddoˈne saguwaˈ subey ne iye lahi. Damikkiyan isab aˈa malaˈi si tanaˈnen subey ne gaˈi balik pī si lumaˈne. ");
INSERT INTO yka_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Essebun bi bang ine maˈumantag si anda si Lot masa awwalley. ");
INSERT INTO yka_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sine-sine ngelleg umulne, gaˈ niyaˈ umulne salama-lama. Saguwaˈ sine-sine gaˈi ngelleg umulne sababku, bisan iye matey, niyaˈ du umulne salama-lama. ");
INSERT INTO yka_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Akahante kaˈam, bang ne ku pitu balik, niyaˈ iyan duwangan magulid sangem, dambuwaˈin ineddoˈ duk dambuwaˈin taˈamban. ");
INSERT INTO yka_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Niyaˈ iyan duwangan dende magtabang maggiling, dambuwaˈin ineddoˈ duk dambuwaˈin taˈamban. ( ");
INSERT INTO yka_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Niyaˈ iyan duwangan lella maghinang si tanaˈ, dambuwaˈin ineddoˈ duk dambuwaˈin taˈamban.)” ");
INSERT INTO yka_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Manjari tilew meˈ tindegnen iye, paˈinde, “Tuwan, antag inin umantag?” Sambungan si Isa siye duk eliˈan, paˈinne, “Antag-antag kaniyaˈan bangkeyin, laˈi magtipun meˈ owakin.” ");
INSERT INTO yka_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Manjari inakahan weˈ si Isa meˈ tindegnen dambuwaˈ dalilan pamintangande supaya siye luwal ngampun si Tuhan duk gaˈi jumuˈ. ");
INSERT INTO yka_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Paˈinne, “Si dambuwaˈ lahat niyaˈ hukum gaˈi tinalew si Tuhan duk gaˈi magaddat si pagkasine manusiyaˈ. ");
INSERT INTO yka_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Niyaˈ isab si lahat miyaˈan dende balu taga palkalaˈ. Dende inin luwal pī si hukum miyaˈan māku tabang si iye duk pabuyuˈ-buyuˈ duk tapakitene kabennalannen. Paˈinne, ‘Tabanganun be ku duk gaˈi ngandaˈag kuntarakun.’ ");
INSERT INTO yka_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tagnaˈ gaˈi ngatu hukum miyaˈan nabangan dendehin saguwaˈ pagtiggel-tiggel ne, paˈinne si dine, ‘Aku inin gaˈi talew si Tuhan duk gaˈi magaddat si manusiyaˈ, ");
INSERT INTO yka_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","saguwaˈ peggeˈ tiyaˈ makasasew aku balu inin, tabanganku iye. Jumuˈ ne ku luwal papituhanne.’” ");
INSERT INTO yka_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Manjari paˈin si Isa, “Na, pakalehun bi pinaˈin hukum manggaˈi mabentel miyaˈan. Tinabangan du weˈ ne dendehin. ");
INSERT INTO yka_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Na, gaˈi ke isab tabangan Tuhanin meˈ aˈa tapeneˈnen, mamāku-māku si iye ellew-sangemin? Magdayan-dayan pe ke iye nabangan siye? ");
INSERT INTO yka_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Akahante kaˈam,” paˈin si Isa, “asal palakkes Tuhanin nabangan siye. Saguwaˈ si pasōngan bang aku, Anak Manusiyaˈin, balik pitu si dunya, ngasuwaˈ enteˈ ku meˈ aˈa sandel si aku?” ");
INSERT INTO yka_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Niyaˈ isab dalilan inaka weˈ si Isa si meˈ aˈa pangimmatde si diden weˈ bentel siye duk diniyawaˈan weˈ de meˈ aˈa sinduwehin. ");
INSERT INTO yka_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Paˈinne, “Niyaˈ duwangan aˈa pataked pī si langgal hadje ngampun. Dambuwaˈin Pariseo duk dambuwaˈin aˈa magpāku-pāku sukey. ");
INSERT INTO yka_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Paglaˈi ne siye dem langgal, nengge Pariseohin duk ngampun iye diyalem ateyne. Paˈinne, ‘O Tuhan, magpasalamat ku si kaˈu weˈ dumaˈin ku kuweˈ meˈ aˈa sinduwehin napsuhan duk ngaliba duk magjina. Duk magpasalamat ku isab weˈ dumaˈin ku kuweˈ aˈa magpāku-pāku sukey miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kahabaˈ simana minduwe ku magpuwase duk jakatanku kēmon usahakun.’ ");
INSERT INTO yka_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Saguwaˈ aˈa magpāku-pāku sukeyin, nengge patala-tala duk gaˈi bisan mayam padiyataˈ saguwaˈ patondok hadja iye. Tineppak-teppak weˈ ne dākannen hawal susenen duk paˈinne, ‘O Tuhan, maˈaseˈ kew si aku, dusehan ku.’ ");
INSERT INTO yka_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Akahante kaˈam,” paˈin si Isa, “weˈ aˈa inin hap lumaˈ kinimmatan ne bentel weˈ Tuhanin duk dumaˈin Pariseohin mabentelin. Peggeˈ sine-sine mahadje dine, pinadiyawaˈ du, duk sine-sine madiyawaˈ dine, pinahadje du.” ");
INSERT INTO yka_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na, niyaˈ meˈ aˈa moˈo meˈ anakde dikiˈ pī pu si Isa supaya siye antananne. Pagkite inin weˈ meˈ tindegnen, pinagamāhan siye weˈ de. ");
INSERT INTO yka_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Saguwaˈ ilinganan weˈ si Isa meˈ mākanakin duk paˈinne si meˈ tindegnen, “Ambat pitu si aku meˈ mākanakin duk daˈa siye saggaˈun bi. Peggeˈ aˈa kuweˈ meˈ mākanakin ngatu du pinagbayaˈan weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sabennal akahante kaˈam,” paˈin si Isa, “bang pangandel aˈa si Tuhanin dumaˈin kuweˈ pangandel mākanakin, na, aˈa iyan asal gaˈi sumakup dem pagbayaˈan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Dambuwaˈ ellew niyaˈ Yahudi bangsahan pī pu si Isa nilew iye, paˈinne, “Tuwan, aˈa hāp kew. Ine subey hinangku duk ku pinasukuˈan umul salama-lama?” ");
INSERT INTO yka_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sambungan si Isa iye, paˈinne, “Weˈey paˈinnu weˈ hāp ku? Gaˈ niyaˈ hāp luwal Tuhan dambuwaˈ-buwaˈ. ");
INSERT INTO yka_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kataˈuhannu du meˈ pangandaˈakan Tuhanin: Daˈa kew magjina. Daˈa kew monoˈ. Daˈa kew nangkew. Daˈa kew naksiˈ gaˈi bennal. Pagaddatanun saˈi-samanun.” ");
INSERT INTO yka_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Paˈin lellahin si iye, “Kēmon iyan, Tuwan, tinuhut weˈ ku kemuwe nakanak pe ku.” ");
INSERT INTO yka_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pagkale si Isa inin, paˈinne si iye, “Niyaˈ pe dambuwaˈ gaˈ tahinangnu. Pī kew, pabellihanun kēmon alataˈnun bu pangurungun ulinen si meˈ mamiskinin. Manjari niyaˈ du iyan alataˈnu laˈi si surgaˈ. Pagubus, balik kew pitu bu nuhut kew aku.” ");
INSERT INTO yka_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pagkalene bissā si Isa miyaˈan, suse teˈed iye peggeˈ dayahan iye manamal. ");
INSERT INTO yka_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Takite si Isa weˈ suse aˈahin, duk paˈinne, “Asal hunit teˈed meˈ madayahanin ngatu pinagbayaˈan weˈ Tuhan. ");
INSERT INTO yka_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mura pe untaˈin palabey si lowang dalum amban aˈa dayahanin ngatu pinagbayaˈan weˈ Tuhan.” ");
INSERT INTO yka_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pagkale meˈ aˈahin pinaˈin si Isa miyaˈan, paˈinde, “Na, sine ne tapī si surgaˈin bang kuweˈ iyan?” ");
INSERT INTO yka_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Saguwaˈ paˈin si Isa, “Meˈ manggaˈi tahinang manusiyaˈin, tahinang du weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Manjari missā si Petros. “Payamanun kami inin,” paˈinne, “ubus ne ambanan kami meˈ lumaˈ kamihin duk nuhut ne kami kaˈu.” ");
INSERT INTO yka_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Aweˈ,” paˈin si Isa si siye, “sabennal akahante kaˈam, bang niyaˈ aˈa ngambanan lumaˈnen, andanen, meˈ pungtinaˈinen, saˈi-samanen atawa meˈ anaknen basta sumakup iye dem pagbayaˈan Tuhanin, ");
INSERT INTO yka_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","asal tumbasan Tuhanin iye tiggelanne tuˈu si dunya labi pe teˈed amban inambanannen, duk inurungan du iye umul gaˈ tamananne laˈi si ahilat.” ");
INSERT INTO yka_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Manjari binoˈo weˈ si Isa tindegne sampūˈ duk duwehin patala-tala duk paˈinne si siye, “Pakale kaˈam, kite bi inin pataked hap Awrusalam. Paglaˈi ne kite bi, tinumanan du kēmon bakas tasulat meˈ kanabihan sabab aku, Anak Manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sinōngan du ku pī si antanan meˈ aˈa dumaˈin Yahudi, duk hinangde du ku dagey duk paˈiyaˈde ku duk pagluraˈande. ");
INSERT INTO yka_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Lubakande ku ubus bu papateyde ku. Saguwaˈ puwas tellum bahangi, ellum du ku balik.” ");
INSERT INTO yka_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Saguwaˈ gaˈ tahāti meˈ tindegnen binissāne miyaˈan. Gaˈ pastiˈ si siye duk gaˈ kataˈuhande bang ine hāti pinaˈinnen. ");
INSERT INTO yka_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sakaliˈ ne siye tapit si puweblo Ariha, niyaˈ laˈi ningkoloˈ si higad lān palabeyanden aˈa pessek magpāku-pāku sīn. ");
INSERT INTO yka_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pagkale aˈa mapessekin meˈ aˈa maˈekka mapalabeyin, tilewne bang weˈey miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Inakahan iye, paˈinde, “Si Isa, aˈa amban Nasaretin mapalabeyin.” ");
INSERT INTO yka_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pagkalene inin magtawus iye ngalingan papales, paˈinne, “O Isa, tubuˈ Sultan Daˈud, maˈaseˈ ne kew si aku.” ");
INSERT INTO yka_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Inamāhan iye weˈ meˈ aˈa si dehelluhanin, gaˈi iye dinaˈak magbukag. Saguwaˈ namba ne papalesne paglingannen. “O tubuˈ Sultan Daˈud,” paˈinne, “maˈaseˈ ne kew si aku.” ");
INSERT INTO yka_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Manjari padeheng si Isa duk daˈakne aˈahin binoˈo pī si iye. Pagtapit ne aˈahin, tilew si Isa iye, paˈinne, ");
INSERT INTO yka_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ine kabayaˈannu hininangku si kaˈuhin?” “Tuwan,” paˈinne, “kabayaˈankun makakite ne ku.” ");
INSERT INTO yka_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Paˈin si Isa si iye, “Makakite ne kew. Kawuliˈan kew peggeˈ sandel kew si aku.” ");
INSERT INTO yka_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Magtawus iye makakite duk nuhut ne iye si Isa lumengngan. Pinudji ne paˈin weˈ ne Tuhanin. Duk meˈ aˈa mangite miyaˈan, pinudji isab weˈ de Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Paˈasek si Isa dem puwebo Ariha duk pabutas iye dem tengngaˈ puweblohin. ");
INSERT INTO yka_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Niyaˈ aˈa maglahat laˈi, ēnnen si Sakkiyas. Iye nakuraˈ meˈ aˈa magpāku-pāku sukeyin duk dayahan iye. ");
INSERT INTO yka_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Batang teˈed kitene si Isa, bang saˈingge bantuknen, saguwaˈ gaˈi takitene peggeˈ ekka teˈed aˈa bu pandak iye. ");
INSERT INTO yka_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hangkan magubas iye padehellu amban meˈ aˈahin duk manaˈik iye diyataˈ kayu sikamol si higad lān, supaya takitene si Isa bang palabey laˈi. ");
INSERT INTO yka_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pagtekka si Isa si antag kayu miyaˈan, padeheng iye duk pahangad duk paˈinne, “O Sakkiyas. Duwaˈi kew palakkes, peggeˈ subey ku pahali si lumaˈnu ellew inin.” ");
INSERT INTO yka_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hangkan magdayiˈ-dayiˈ si Sakkiyas duwaˈi duk kēgan iye moˈo si Isa si lumaˈne. ");
INSERT INTO yka_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pagkale meˈ aˈahin pinaˈin si Isa pu si Sakkiyasin, ngunub-ngunub siye, paˈinde, “Na, weˈey dang iye nuhut pī si lumaˈ aˈa dusehan miyaˈan?” ");
INSERT INTO yka_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ubus nengge Sakkiyas duk paˈinne pu si Isa, “Tuwan, dan tengaˈ alataˈkun pangurungku si meˈ mamiskinin. Duk bang niyaˈ bakas tapalelongku, pabalikku si iye sīnnen ilapisan minampat.” ");
INSERT INTO yka_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Paˈin si Isa si iye, “Ellew inin timbul ne kew duk meˈ anak-andanun, peggeˈ kaˈu hep isab tubuˈ Ibrahim. ");
INSERT INTO yka_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aku, Anak Manusiyaˈin, akaku mapitu si dunyahin miha meˈ aˈa matala amban Tuhanin duk nimbul siye.” ");
INSERT INTO yka_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sasang meˈ aˈahin pakale si meˈ binissā si Isahin, inakahan isab siye weˈ ne dambuwaˈ dalilan peggeˈ tapit ne siye si Awrusalam duk kannalde weˈ pagtekkade laˈi, tagnaˈan Tuhanin ne pagbayaˈne si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hangkan paˈin si Isa magdalilanin, “Niyaˈ dambuwaˈ aˈa bangsahan. Hap pī iye si lahat tala duk iye tagellal sultan laˈi, ubus bu balik du iye si lahatne magsultan. ");
INSERT INTO yka_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sōng pataha1aˈnen, ilinganan dahuˈ weˈ ne sampūˈ meˈ daraˈakannen, duk inurungan siye dangan-dangan weˈ ne dublun. Paˈinne si siye, ‘Paglituhun bi iyan tiggelanku gaˈi tekka.’ ");
INSERT INTO yka_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Saguwaˈ kabunsihan aˈa miyaˈan weˈ meˈ aˈa si lahatnen hangkan paglumikut ne iye, dinaˈak sinduwehin weˈ de pī paturul si iye magaka weˈ gaˈi siye mabayaˈ weˈ magsultan aˈa miyaˈan si siye. ");
INSERT INTO yka_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Saguwaˈ masi du iye ginellal sultan. Pagbalikne si lahatne, daˈakne ilinganan pī si iye meˈ daraˈakanne bakas inurunganne dublunin supaya kataˈuhanne bang piye untungden dangan-dangan. ");
INSERT INTO yka_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pī dehelluhin si iye duk paˈinne, ‘Tuwan, dublunnu dambuwaˈin makaˈuntung sampūˈ dublun.’ ");
INSERT INTO yka_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Hāp hininangnun,’ paˈin amunen, sultanin. ‘Daraˈakan hāp kew. Tapangandelan kew si meˈ kuweˈahat, hangkan urungante kew kapatut magbayaˈ si sampūˈ puweblo.’ ");
INSERT INTO yka_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ubus pī isab kaduwe daraˈakanin si iye duk paˈinne, ‘Tuwan, dublunnu dambuwaˈin makaˈuntung lime dublun.’ ");
INSERT INTO yka_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Paˈin sultanin si iye, ‘Hāp. Kaˈu isab magbayaˈ kew si lime puweblo.’ ");
INSERT INTO yka_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Manjari pī isab dambuwaˈin duk paˈinne, ‘Tuwan, o, tiyaˈ du dublunnun. Pinutus weˈ ku pinahāp-hāp dem panyitu duk inennaˈ weˈ ku. ");
INSERT INTO yka_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tinalew ku si kaˈu peggeˈ gaˈi kew maˈaseˈ si aˈa. Eddoˈnu dumaˈin si kaˈuhin duk paganinu manggaˈ bakas pagluˈugannun.’ ");
INSERT INTO yka_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Paˈin sultanin si iye, ‘Kaˈu iyan daraˈakan laˈat duk bulasan. Si meˈ bissānu miyaˈan hukumte kew. Kataˈuhannu hatiˈ weˈ gaˈi ku maˈaseˈ. Kataˈuhannu weˈ eddoˈku dumaˈin si akuhin, duk paganiku manggaˈ bakas pagluˈugankun. ");
INSERT INTO yka_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na, weˈey gaˈ papīnu sīnkun si bangku duk nganak? Manjari pagbalikku pitu, taˈeddoˈku siˈ sampay anaknen.’ ");
INSERT INTO yka_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Manjari paˈin sultanin si meˈ manengge matapitin, ‘Eddoˈun bi dublunin amban iye duk pangurungun bi pī si manguntung sampūˈin.’ ");
INSERT INTO yka_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Saguwaˈ Tuwan,’ paˈinde, ‘niyaˈ ne sampūˈ dublunnen.’ ");
INSERT INTO yka_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Paˈin sultanin, ‘Akahante kaˈam, weˈ aˈa tapangandelanin, inurungan pe namba. Saguwaˈ manggaˈi tapangandelanin, bisan kuweˈahat bakas pinangandel si iyehin, ineddoˈ du amban iye. ");
INSERT INTO yka_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na, meˈ bantaku miyaˈan,’ paˈin sultanin, ‘meˈ aˈa manggaˈi mabayaˈ weˈ aku magsultan si siyehin, boˈohun bi siye pitu duk papateyun bi tuˈu si matahanku.’” ");
INSERT INTO yka_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pagubus inin bissā si Isa, lumengngan iye padehellu amban siye tudju Awrusalam. ");
INSERT INTO yka_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pagtapit ne iye si meˈ kalumaˈan Betpage duk Betani, laˈi si kūd Jaitun, ngandaˈak iye duwangan tindegne padehellu. ");
INSERT INTO yka_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Paˈinne si siye, “Pī kaˈam si kalumaˈan si dehelluhanbi miyaˈan, duk pagtekkabi laˈi ngite kaˈam iyan anak asnu dinagtel, gaˈ pe bakas kasakeyan. Lekkahanun bi duk boˈohun bi pitu. ");
INSERT INTO yka_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bang niyaˈ nilew kaˈam bang weˈey lekkahanbi, paˈinun bi, ‘Niyaˈ kagunahan Panuhutanin si iye.’” ");
INSERT INTO yka_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Manjari hap pī ne meˈ dinaˈaknen si kalumaˈan miyaˈan duk takitede kēmon sa pangaka si Isa si siyehin. ");
INSERT INTO yka_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sasangde mangalekkahan anak asnuhin, paˈin meˈ dapuˈnen si siye, “Hoy, weˈey lekkahanbi anak asnu iyan?” ");
INSERT INTO yka_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nambung siye, paˈinde, “Niyaˈ guna Panuhutanin si iye.” ");
INSERT INTO yka_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Manjari binoˈo ne weˈ de asnuhin pu si Isa duk ilampiruhan weˈ de duk meˈ semmekde, ubus bu pasakey ne si Isa. ");
INSERT INTO yka_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sasangne mapīhin, binellat weˈ meˈ aˈahin meˈ semmekden si lān palabeyannen. ");
INSERT INTO yka_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pagtapit ne si Isa si Awrusalam, laˈi ne si padurulan kūd Jaitun, kēmon meˈ tindegne mabanesin magsukul si Tuhan duk pinudji iye weˈ de pinapales sabab meˈ hinangan balakat bakas takitede hininang si Isahin. ");
INSERT INTO yka_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Paˈinde, “Pudjite bi sultan inin, iye pinapitu weˈ Tuhanin! Sanyang laˈi si surgaˈ duk pinudji teˈed Tuhanin!” ");
INSERT INTO yka_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Niyaˈ meˈ Pariseo laˈi dem kaˈekkahan meˈ aˈahin. Paˈinde pu si Isa, “Tuwan, pagesun meˈ tindegnun. Daˈakun siye padeheng nanglitan kaˈu.” ");
INSERT INTO yka_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nambung iye, paˈinne, “Akahante kaˈam, weˈ bang gaˈi siye inin mabehe, meˈ batu si lān inin asal ngellang mudji aku.” ");
INSERT INTO yka_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pagtapit-tapit ne si Isa si puweblo Awrusalam duk takitene ne meˈ kalumaˈanin, magtangis iye hawal aseˈne si meˈ aˈa puweblo miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Paˈinne, “Bang siˈ hadja tahātibi bisan ellew inin bang ine subey hininangbin supaya kaˈam ngasuwaˈ kasanyangan. Saguwaˈ asal gaˈi tahātibi. ");
INSERT INTO yka_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Makaˈaseˈ-aseˈ teˈed kaˈam peggeˈ niyaˈ du iyan meˈ ellew tekka, iliput lahatbin weˈ meˈ bantabin. Ngahinang siye iyan kutaˈ bulak liputde kaˈam inelletan duk kaˈam gaˈi lumahi. ");
INSERT INTO yka_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Lubude iyan kēmon kalumaˈanbin hangkan gaˈ iyan niyaˈ nengge meˈ batu pinagbangkat-bangkatin dem puweblobi iyan. Duk kēmon kaˈam maglahat luˈu diyalemin, papateyde du. Umantag du inin si kaˈam peggeˈ gaˈ pegmasibi waktu pamakite Tuhan aseˈne si kaˈamin.” ");
INSERT INTO yka_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Manjari pagtekka si Isa dem puweblo Awrusalam, paˈasek iye pī dem langgal hadjehin duk binudjew weˈ ne meˈ aˈa magdagang-dagang malaˈihin ");
INSERT INTO yka_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","duk paˈinne si siye, “Tasulat dem kitab, paˈin Tuhanin, ‘Lumaˈkun inēnan du lumaˈ pangampunan.’ Saguwaˈ kaˈam,” paˈin si Isa, “hininang weˈ bi lumaˈ Tuhanin kuweˈ lumaˈ patapukan meˈ aˈa panangkew.” ");
INSERT INTO yka_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Magtoloˈ si Isa ellew-ellew dem langgal hadjehin. Meˈ nakuraˈ meˈ imamin duk meˈ guru si saraˈ āgamahin duk sampay meˈ aˈa mabangsahanin miha-miha lān supaya si Isa tapapateyde. ");
INSERT INTO yka_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Saguwaˈ gaˈ niyaˈ tahinangde peggeˈ kēmon aˈahin sinna teˈed pakale si meˈ bissānen. ");
INSERT INTO yka_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dambuwaˈ ellew laˈi si Isa magtoloˈ si meˈ aˈahin dem langgal hadjehin duk magmahalayak isab aka-aka mahāpin si siye. Manjari patapit pī si iye meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin duk meˈ kabahiˈanin. ");
INSERT INTO yka_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Paˈinde si iye, “Ine kapatutnu ngahinang meˈ hininangnu ellew miyaˈan? Sine mangurungan kaˈu kapatutin?” ");
INSERT INTO yka_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sambungan si Isa siye, paˈinne, “Niyaˈ isab tilewku si kaˈam. Akahanun bi ku, ");
INSERT INTO yka_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","pamandi Yahiya meˈ aˈahin, amban Tuhan ke atawa amban manusiyaˈ hadja?” ");
INSERT INTO yka_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Manjari magisun-isun siye. Paˈinde, “Bang saˈupama paˈinte bi weˈ kapatut Yahiya pamandine meˈ aˈahin amban Tuhan, paˈinne iyan, ‘Na, weˈey Yahiya gaˈ kahagadbi?’ ");
INSERT INTO yka_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Saguwaˈ bang paˈinte bi, ‘Amban manusiyaˈ,’ na, pagtibagan kite bi iyan weˈ meˈ aˈahin kēmon, peggeˈ kahagad siye weˈ Yahiya asal nabi Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hangkan nambung siye, “Gaˈi kataˈuhan kami bang amban kapatut Yahiyahin.” ");
INSERT INTO yka_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Manjari paˈin si Isa si siye, “Na, gaˈi isab kaˈam akahanku bang amban kapatutku maghinang meˈ hininangku miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Manjari inakahan weˈ si Isa meˈ aˈahin dalilan inin. “Niyaˈ,” paˈinne, “aˈa maglikus bāhan ubas duk pinatungguˈ weˈ ne si meˈ aˈa, pagbahagiˈan uli tinanemnen. Ubus bu tahalaˈ iye pī si lahat tala duk tiggel iye laˈi. ");
INSERT INTO yka_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pagtaˈabut pagbuwaˈ ubasin, dinaˈak weˈ dapuˈ likusin dambuwaˈ daraˈakanne pī si meˈ aˈa tatungguˈnen māku bahagiˈne si meˈ buwaˈ ubasin. Saguwaˈ pinapeddiˈan daraˈakanin weˈ de duk pinapoleˈ iye gaˈ niyaˈ taboˈone. ");
INSERT INTO yka_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ubus ngandaˈak ne isab dapuˈ likusin seddili daraˈakanne pī si siye. Pinapeddiˈan du isab weˈ de duk pinaˈiyaˈ duk pinapoleˈ gaˈ niyaˈ taboˈone. ");
INSERT INTO yka_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ubus ngandaˈak ne isab iye daraˈakanne pī kamintellunen. Inin bakat-bakat du isab weˈ de, ubus bu sinōgadan weˈ de pī si bukut birang likusin. ");
INSERT INTO yka_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Manjari paˈin dapuˈ likusin, ‘Ine enteˈ hinangku? Gam pe daˈakku pī anakku kinalasahanku teˈedin. Bugtuˈ pagaddatande iye.’ ");
INSERT INTO yka_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Saguwaˈ pagkite meˈ tatungguˈ likusin anakne miyaˈan, magisun siye, paˈinde, ‘Iye hep inin pinusakaˈanin. Dayiˈ kaˈam, papateyte bi duk likus inin tepe si kite bi.’ ");
INSERT INTO yka_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Manjari siniggew iye weˈ de duk sinōgadan pī si bukut birang likusin duk pinapatey weˈ de. Na,” paˈin si Isa, “ine enteˈ hinang dapuˈ likus miyaˈan si siye? ");
INSERT INTO yka_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hap pī iye duk papateyne meˈ tatungguˈ miyaˈan duk patungguˈanne likusnen si seddili.” Pagkale meˈ aˈahin inin, paˈinde, “Karayaw patala Tuhanin!” ");
INSERT INTO yka_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Saguwaˈ pinayaman siye weˈ si Isa duk paˈinne, “Na, ine paˈinbi hāti ayat inin, tasulat dem kitab, pinaˈin, ‘Batu tinayikutan weˈ meˈ pandey maghinang lumaˈ batuhin, peggeˈ kannalde gaˈi taguna, kuweˈitu iye ne miyaˈan batu tamanan maniyaˈ kagunahannen.’” ");
INSERT INTO yka_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Paˈin si Isa pe, “Kēmon malaboˈ diyataˈ batu inin posak-posak barannen. Duk sasuku kalaboˈan batu inin, pipis iye.” ");
INSERT INTO yka_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Meˈ guru si saraˈ āgamahin duk meˈ nakuraˈ imamin, batang ne siggewde si Isa duˈun-duˈun, peggeˈ tahātide weˈ siye inandigne si dalilan sabab likus miyaˈan. Saguwaˈ gaˈ iye siggewde peggeˈ talew siye si meˈ aˈa maˈekkahin. ");
INSERT INTO yka_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hangkan miha-miha siye lān supaya iye tasōngande pī si antanan gubnulin. Nangdan siye meˈ aˈa dinaˈak pī pakale pu si Isa, magmā-mā weˈ siye meˈ aˈa asal nuhut saraˈ, supaya iye takuhide si meˈ bissānen. ");
INSERT INTO yka_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Manjari paˈin meˈ aˈa tinangdanan miyaˈan pu si Isa, “Tuwan, kataˈuhan kami weˈ patut meˈ binissānun duk pamanoloˈnun. Gaˈi pagbiddaˈnu aˈahin duk bennal meˈ panoloˈnu sabab kahandak Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ine paˈinnu. Patuhut ke si saraˈte bi bang kite bi magbayed sukey si Sultan Nakuraˈ bangsa Romahin atawa gaˈi.” ");
INSERT INTO yka_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Saguwaˈ kataˈuhan si Isa pangakkalden. Paˈinne si siye, ");
INSERT INTO yka_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pakitehanun bi ku sīn tuwas.” Paglaˈi ne sīnin, paˈinne, “Pattaˈ sine teˈ duk sulat sine si sīn inin?” Paˈinde, “Pattaˈ Sultan Nakuraˈin duk sulatnen.” ");
INSERT INTO yka_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Na,” paˈin si Isa, “pangurungun bi si Sultan Nakuraˈin sukuˈ si iyehin, duk pangurungun bi si Tuhan sukuˈ si Tuhanin. (Hātinen, magbayed kaˈam sukey duk pangurungun bi dibin dambūs-būs si Tuhan.)” ");
INSERT INTO yka_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gaˈ iye takuhide si meˈ binissāne si harapan meˈ aˈahin. Saguwaˈ ulaliˈ teˈed siye si sambungnen, hangkan gaˈ ne niyaˈ bissāde. ");
INSERT INTO yka_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Puwas miyaˈan, niyaˈ pī pu si Isa meˈ Sadduseo. Siye inin gaˈi kahagad weˈ ellum balik meˈ pateyin si ellew dambuli. ");
INSERT INTO yka_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Paˈinde pu si Isa, “Tuwan, niyaˈ saraˈ pangurung si Musa kite bi, paˈinne, ‘Bang niyaˈ lella bu matey iye gaˈ niyaˈ anakne, subey ne maganda salinen si balu miyaˈan duk niyaˈ tubuˈ sakanen.’ ");
INSERT INTO yka_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na manjari, niyaˈ miyaˈan pituˈ lella magpungtinaˈi. Sakahin maganda, manjari matey iye gaˈ anakde. ");
INSERT INTO yka_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ubus mapasunuˈin maganda si baluhin, duk matey iye gaˈ du isab niyaˈ anakde. ");
INSERT INTO yka_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ubus bu katelluhin pagantiˈ nganda baluhin, sampay kēmon siye kapituˈ magpungtinaˈihin maggantiˈ nganda baluhin, duk matey siye gaˈ niyaˈ anak ambanande. ");
INSERT INTO yka_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Si kakapusannen matey isab dendehin. ");
INSERT INTO yka_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, Tuwan,” paˈinde, “si ellew pagellum balik meˈ pateyin, anda sine iye? Bu pituˈ magpungtinaˈihin makaˈanda iye.” ");
INSERT INTO yka_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nambung si Isa, paˈinne, “Meˈ aˈa si dunya inin maganda duk magella. ");
INSERT INTO yka_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Saguwaˈ meˈ aˈa kinimmatan weˈ Tuhan mapataˈ pinakellum balik amban meˈ pateyin duk maglahat laˈi si surgaˈin, gaˈi ne siye maganda atawa magella. ");
INSERT INTO yka_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Peggeˈ gaˈi ne siye matey saguwaˈ kuweˈ ne siye meˈ malaˈikatin. Meˈ anak Tuhanin ne siye peggeˈ bakas pinakellum ne siye balik amban kamateyden. ");
INSERT INTO yka_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na, pasal meˈ aˈa mamateyin weˈ pinakellum balik, pinapastiˈ inin weˈ si Musa dem kitab. Sinulat hep weˈ ne laˈi sabab poˈon puhung makayatin. Pangēnne Tuhanin laˈi, ‘Tuhan pagtuhanan disi Ibrahim duk si Isahak duk si Yakubin.’ ");
INSERT INTO yka_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tuhanin Tuhan meˈ maˈellumin dumaˈin Tuhan meˈ mamateyin. (Hātinen bisan disi Ibrahim duk Isahak duk si Yakub tiggel ne matey, ellum siye laˈi si surgaˈ peggeˈ inisbat pe weˈ de Tuhanin.) Bang si bistahan Tuhan, ellum kēmon aˈahin.” ");
INSERT INTO yka_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Paˈin sinduwe meˈ guru si saraˈ āgamahin pu si Isa, “Tuwan, hāp sambungnu miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gaˈ ne siye makatawakkal nilew iye namba. ");
INSERT INTO yka_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Manjari paˈin si Isa si siye, “Weˈey meˈ aˈahin magpaˈin weˈ Almasihin tubuˈ Sultan Daˈud koˈ. ");
INSERT INTO yka_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Peggeˈ si Daˈud ne teˈed magpaˈinin dem kitab Jabur, paˈinne, ‘Missā Tuhanin si Panuhutankun. Paˈin Tuhanin: Dayiˈ kew, ningkoloˈ kew tuˈu si kanawananku, tuˈu si paningkoloˈan mabangsahanin. ");
INSERT INTO yka_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Bettadku du meˈ bantanun diyawaˈ pat bettisnu.’ ");
INSERT INTO yka_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na,” paˈin si Isa, “bang Almasihin inēnan Panuhutan weˈ si Daˈud, saˈingge kajarinen weˈ tubuˈ Sultan Daˈud iye?” ");
INSERT INTO yka_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Duk sasang meˈ aˈahin kēmon pakale, paˈin si Isa si meˈ tindegnen, ");
INSERT INTO yka_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Paghalliˈ-halliˈanun bi meˈ guru si saraˈ āgamahin. Sinna siye lumengngan magsemmek tahaˈ duk sinna siye sinalam si meˈ tabuˈan. Bang dem langgal, mabayaˈ siye ningkoloˈ si meˈ paningkoloˈan para si meˈ aˈa pinagaddatanin. Damikkiyan bang siye si meˈ pagjamu-jamuhan, kabayaˈanden ningkoloˈ si meˈ paningkoloˈan mabangsahanin. ");
INSERT INTO yka_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sinigpitan weˈ de meˈ dende baluhin supaya taˈeddoˈde meˈ lumaˈden, duk panapukde hinangande malaˈat inin, magsambahayang siye patahaˈ, magmā-mā weˈ aˈa hāp siye. Bugtuˈ hukuman hadje tasangkaden si ahilat.” ");
INSERT INTO yka_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Manjari mayam si Isa duk takitene meˈ aˈa dayahanin ngalaboˈ meˈ sīn pangurungde si Tuhanin pī dem pangisi-ngisihan sīn laˈi dem langgal hadjehin. ");
INSERT INTO yka_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Niyaˈ isab takitene dambuwaˈ dende balu miskin ngalaboˈ duwe sīn peyat. ");
INSERT INTO yka_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Paˈin si Isa, “Sabennal akahante kaˈam, dende balu mamiskin inin, labi pe sīn talaboˈnen amban kēmon siye. ");
INSERT INTO yka_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Peggeˈ siye kēmon,” paˈin si Isa, “ngurung siye amban alataˈde maglabi-labihin. Saguwaˈ dende inin, bisan iye miskin, pinangurung weˈ ne kēmon sīnnen, bisān diddaˈ panabangne sukalnen.” ");
INSERT INTO yka_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Niyaˈ meˈ tindegne sinduwehin magbissā-bissā sabab langgal hadje miyaˈan. Paˈinde weˈ makasinna-sinna koˈ meˈ batu ginuna pangahinang langgal miyaˈan duk makasinna-sinna isab koˈ meˈ bayuˈan alat-alatne pinangurung weˈ meˈ aˈahin. Pagkale si Isa pinaˈinde miyaˈan, paˈinne, ");
INSERT INTO yka_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kēmon takitebi inin, si pasōngan pinagkaˈat du. Niyaˈ ellew, gaˈ du iyan niyaˈ talebbi tuˈu meˈ batu magbangkat-bangkat iyan, saguwaˈ kēmon kinanat-kanat du.” ");
INSERT INTO yka_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Manjari tinilew si Isa weˈ de, paˈinde, “Tuwan, sumiyan umantag meˈ pinaˈinnu iyan? Duk ine tandaˈ mapaguwaˈin bang sōng ne umantag meˈ kēmon miyaˈan?” ");
INSERT INTO yka_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nambung iye, paˈinne, “Pahatul-hatul kaˈam duk kaˈam gaˈi kaˈakka1an. Peggeˈ ekka iyan pitu magēnan ēnkun duk magpaˈin weˈ siye ne Almasihin. Duk paˈinde isab iyan, ‘Kiyamat ne.’ Saguwaˈ daˈa kaˈam nuhut siye. ");
INSERT INTO yka_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Duk bang kaˈam makakale sabab magbonoˈ duk sabab meˈ sasew, daˈa kaˈam tinalew. Kēmon inin subey umantag dahuˈ, saguwaˈ dumaˈin pe inin ellew kiyamat.” ");
INSERT INTO yka_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Manjari paˈinne si siye, “Dambuwaˈ bangsa magbonoˈ duk bangsa seddili, duk dambuwaˈ pagsultanan magbonoˈ duk pagsultanan seddili. ");
INSERT INTO yka_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Duk tekka iyan meˈ linug mabasagin duk meˈ unusin duk meˈ saki malaˈatin si meˈ kalahat-lahatan tuˈu si dunya. Niyaˈ isab iyan takite meˈ aˈahin meˈ tandaˈ diyataˈ langit makaˈulaliˈ duk makatalew-talew. ");
INSERT INTO yka_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Saguwaˈ meke inin umantag kemōn, siggewde kaˈam duk binasade kaˈam. Boˈode kaˈam pī si meˈ langgalde hinukum duk kalabusude kaˈam. Binoˈo du isab kaˈam iyan si harapan meˈ sultan duk meˈ gubnul duk hukumde kaˈam peggeˈ nuhut kaˈam aku. ");
INSERT INTO yka_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bang laˈi ne kaˈam si harapande, taˈakabi ne si siye aka-aka mahāp sabab akuhin. ");
INSERT INTO yka_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kimmatanun bi teˈed dem ateybi weˈ gaˈi pikilbi andang bang ine panambungbin bang kaˈam binistiga. ");
INSERT INTO yka_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Peggeˈ urunganku du kaˈam kataˈu duk kaˈam taˈu nambungan siye. Duk gaˈ iyan niyaˈ meˈ kuntarabin makasaggaˈ binissābin atawa makajawab kaˈam. ");
INSERT INTO yka_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bisan meˈ matettoˈabin, meˈ pungtinaˈibin, meˈ baˈanbin, duk meˈ bagaybin, sōngande du kaˈam iyan si kuntarabin. Duk niyaˈ kaˈam papateyde du. ");
INSERT INTO yka_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Duk kaˈam, meˈ tindegkun,” paˈin si Isa, “kabunsihan du kaˈam weˈ kēmon aˈa peggeˈ nuhut kaˈam aku. ");
INSERT INTO yka_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Saguwaˈ gaˈ du iyan niyaˈ lepas bisan da lamba kōkbin. ");
INSERT INTO yka_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bang gaˈi usaˈ sandelbin taga umul du kaˈam si surgaˈ gaˈ niyaˈ tamananne.” ");
INSERT INTO yka_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Bang takitebi ne puweblo Awrusalamin liput weˈ meˈ sundalu, na, kataˈuhanbi weˈ sōng tekka ne balaˈnen. ");
INSERT INTO yka_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Manjari meˈ aˈa malaˈi si Yahudiyahin subey ne lahi pī si meˈ kapunuhan. Meˈ malaˈi diyalem puweblo Awrusalamin subey ne paluwas magdayiˈ-dayiˈ, duk meˈ andang malaˈi si luwasanin subey ne gaˈi padiyalem pī dem puweblo. ");
INSERT INTO yka_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Peggeˈ miyaˈan ne meˈ ellew pangalegga Tuhan meˈ aˈahin, duk tinumanan ne kēmon tasulat dem kitabin. ");
INSERT INTO yka_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Andūˈ, makaˈaseˈ-aseˈ teˈed meˈ mabettengin duk meˈ maganak dikiˈin laˈi si meˈ ellew īˈ. Peggeˈ niyaˈ iyan kasigpitan hadje tekka tuˈu si lahat inin duk meˈ aˈanen tewwaˈ mulkaˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Niyaˈ siye matey binonoˈ weˈ meˈ sundaluhin, duk sinduwehin siniggew duk binoˈo hinang pilisu si kēmon kalahatan si dunya. Duk puweblo Awrusalam inin pinagkaˈat du weˈ meˈ kabangsahan seddili, duk gaˈi siye usaˈ bittuˈu samantaˈan gaˈi pe jukup gantaˈan pagbayaˈ meˈ bangsa seddilihin.” ");
INSERT INTO yka_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Duk niyaˈ iyan meˈ tandaˈ takite si mata ellewin duk si bulanin duk si meˈ poteˈanin. Duk tuˈu si dunya kaˈumagadan iyan meˈ kabangsa-bangsahanin duk gaˈi siye magkataˈu-taˈu sabab begeddu tahikin duk meˈ goyak mahadjehin. ");
INSERT INTO yka_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Duk meˈ aˈahin agen matey hawal talewden duk hawal pagsusede sabab meˈ balaˈ inase-asede sōng matekka si dunyahin. Peggeˈ meˈ bayuˈan diyataˈ langitin tahalaˈ amban lugalden. ");
INSERT INTO yka_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Manjari pagubus inin,” paˈin si Isa, “kitede du ku, Anak Manusiyaˈin, pitu dem inalak. Takite meˈ aˈahin du sahayakun duk balakatku mahadjehin. ");
INSERT INTO yka_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na, bang nagnaˈ ne umantag meˈ pinaˈinku inin, nengge kaˈam duk patongas, peggeˈ gaˈi ne tiggel tinimbul ne teˈed kaˈam.” ");
INSERT INTO yka_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ubus magda1ilan si Isa si siye, paˈinne, “Pandogahanun bi kayu igirahin duk meˈ kayu sinduwehin. ");
INSERT INTO yka_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bang takitebi numbuˈ meˈ dawennen, kataˈuhanbi weˈ sōng baytu panas ne. ");
INSERT INTO yka_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Damikkiyan isab bang takitebi ne meˈ pinaˈinku ensiniˈ miyaˈan umantag, na, kataˈuhanbi weˈ tapit ne pagbayaˈ Tuhan tuˈu si dunyahin. ");
INSERT INTO yka_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sabennal akahante kaˈam,” paˈin si Isa, “gaˈi pe ubus matey kēmon aˈa kuweˈitu inin, tekka ne meˈ bakas pinaˈinku inin. ");
INSERT INTO yka_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Palabey hadja langitin duk dunyahin, saguwaˈ bang bissākun asal gaˈi usaˈ.” ");
INSERT INTO yka_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Subey kaˈam papateng-pateng,” paˈin si Isa. “Kaw iye luwal tapikilbin magadjak-adjak duk maginuman duk magsuse sabab kaˈellumanbin. Bu bessuwang tekka ellew pabalikkun, manjari tasaˈut kaˈam si kadupangan. ");
INSERT INTO yka_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Peggeˈ asal bessuwang tekka ellew miyaˈan, kuweˈ dalil tagen tabekkas, duk tewwaˈ kēmon aˈa si babew dunya inin. ");
INSERT INTO yka_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Papateng-pateng kaˈam teˈed. Subey kaˈam luwal ngampun weˈ karayaw pabasag Tuhanin ateybin supaya tasandalbi du kēmon miyaˈan. Ngampun kaˈam karayaw gaˈ niyaˈ kaˈiyaˈanbi bang kaˈam nengge si harapanku, Anak Manusiyaˈin.” ");
INSERT INTO yka_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kahabaˈ ellew magtoloˈ si Isa dem langgal mahadjehin, saguwaˈ bang sangem, paluwas iye amban puweblo miyaˈan duk laˈi iye patennaˈ si antag kūd Jaitun. ");
INSERT INTO yka_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Duk salung-salung pe, pī ne kēmon aˈahin si langgal hadje pakale si usihatnen. ");
INSERT INTO yka_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tapit ne pagkādjaˈan meˈ Yahudihin pamangande pan gaˈi sinagetan pasuligin. Pagkādjaˈan miyaˈan inēnan Kādjaˈan Pangesseban. ");
INSERT INTO yka_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Meˈ nakuraˈ imamin duk meˈ guru si saraˈ āgamahin, pinikil-pikil weˈ de bang saˈingge si Isa tapapateyde duk gaˈi kataˈuhan meˈ aˈahin. Peggeˈ talew siye si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Manjari paˈasek nakuraˈ seyitanin pu si Judas. Iye inin si Judas Iskariyot, dambuwaˈ meˈ tindeg si Isa sampūˈ duk duwehin. ");
INSERT INTO yka_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tahalaˈ iye duk pī iye si meˈ nakuraˈ meˈ imamin duk si meˈ kapitan meˈ guwaldiya si langgal hadjehin moˈo siye magisun bang saˈingge pamuddine si Isahin duk tasōnganne si siye. ");
INSERT INTO yka_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Sinna teˈed siye duk nanggup siye ngurungan iye sīn. ");
INSERT INTO yka_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Magaweˈ ne si Judas. Manjari kemuwe miyaˈan, miha ne iye waktu hāp panōngne si Isa supaya iye tasiggewde duk gaˈi kataˈuhan meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Manjari taˈabut ne kādjaˈan pamangande pan gaˈi sinagetan pasuligin. Duk si ellew miyaˈan subey meˈ aˈahin numbaliˈ anak bili-bili kakande pangessebande masa pamaluwas Tuhan bangsaden amban kamatey laˈi si lahat Misil awwalley. ");
INSERT INTO yka_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dinaˈak weˈ si Isa si Petros duk Yahiya, paˈinne, “Pī kaˈam magpanyap kinakanten bi para si pagjamu-jamuhan Pangesseban inin.” ");
INSERT INTO yka_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Paˈinde si iye, “Tuwan, antag kami kabayaˈannu magpanyapin?” ");
INSERT INTO yka_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Paˈinne si siye, “Pagdiyalembi si puweblo, niyaˈ iyan aˈa tasampangbi magboˈo komboˈ isihan boheˈ. Nuhut kaˈam iye pī si lumaˈ padiyalemannen, ");
INSERT INTO yka_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","duk paˈinun bi si dapuˈ lumaˈin, ‘Dinaˈak kew tinilew weˈ guruhin bang antag koˈ bilik pagjamu-jamuhanne duk meˈ tindegnen para si Kādjaˈan Pangessebanin.’ ");
INSERT INTO yka_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Manjari niyaˈ iyan pakitehanne kaˈam bilik luha laˈi diyataˈ lumaˈ,” paˈin si Isa. “Andang ne panyap bilik miyaˈan. Laˈi kaˈam maghatul kinakanten bi.” ");
INSERT INTO yka_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Manjari hap pī ne siye duk takitede laˈi sa pangaka si Isa si siyehin. Duk maghatul ne siye laˈi kinakande para si pagjamu-jamuhan Pangessebanin. ");
INSERT INTO yka_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pagtekka ne waktu pagjamu-jamuhin, ningkoloˈ ne si Isa duk meˈ kawakilannen mangan. ");
INSERT INTO yka_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Manjari paˈin si Isa si siye, “Asal iye hep teˈed kinabayaˈankun kapagtuhut kite bi mangan kinakan para si pagjamu-jamuhan Pangesseban inin meke ku nandal kabinasahan. ");
INSERT INTO yka_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Peggeˈ akahante kaˈam, puwas inin gaˈi ne ku mangan inin balik. Meke ku mangan inin balik bang Tuhanin ne magbayaˈ si meˈ aˈahin duk tuman ne bang ine asal hāti pagjamu-jamuhan inin.” ");
INSERT INTO yka_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Manjari ngeddoˈ iye sawan duk pagubus iye magpasalamat, paˈinne si siye, “Eddoˈun bi inin duk inumun bi maggantiˈ-gantiˈ. ");
INSERT INTO yka_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Peggeˈ akahante kaˈam, tinagnaˈan maˈin, gaˈi ne ku nginum balik boheˈ ubas samantaˈan gaˈi pe Tuhanin magbayaˈ si meˈ aˈahin.” ");
INSERT INTO yka_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ubus, ngeddoˈ iye pan duk pagubus iye magpasalamat si Tuhan, kinepak-kepak weˈ ne bu pinangurung weˈ ne si siye. Paˈinne, “Pan inin barankun, paglillaˈku sabab kaˈam. Hinangun bi inin supaya ku luwal taˈessebbi.” ");
INSERT INTO yka_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Damikkiyan isab ubus siye mangan, pinangurung weˈ ne sawanin duk paˈinne, “Ininum inin tandaˈ janjiˈ Tuhan si kaˈam mabaˈahuhin. Bugtuˈ janjiˈ Tuhan inin sabab buˈus lahaˈkun para si kaˈam. ");
INSERT INTO yka_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Saguwaˈ, payamanun bi,” paˈin si Isa, “aˈa sōng mamuddihan akuhin, saweˈte bi du magtingkoloˈ tuˈu si lamisahan. ");
INSERT INTO yka_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aku inin, Anak Manusiyaˈin, matey du ku peggeˈ inin pangagantaˈ Tuhan akuhin. Saguwaˈ makaˈaseˈ-aseˈ teˈed aˈa mamuddihan akuhin.” ");
INSERT INTO yka_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Manjari magtilew-tilew siye bang sine enteˈ siye magsakap mamuddihan iyehin. ");
INSERT INTO yka_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na, magsuweyan meˈ tindeg si Isahin bang sine siye subey pinalangkewin. ");
INSERT INTO yka_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Saguwaˈ paˈin si Isa si siye, “Tuˈu si dunya, meˈ sultanin magbayaˈ teˈed si meˈ aˈaden. Duk meˈ aˈa taga kapatutin, kabayaˈanden pinaˈin weˈ siye mangurung kahāpan si lahatin. ");
INSERT INTO yka_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Saguwaˈ kaˈam subey gaˈi magsa miyaˈan. Tamanan mabangsahan si kaˈamin subey boˈohannen kuweˈ iye sali-salihin. Duk nakuraˈin subey tapikilne dinen kuweˈ iye daraˈakanin. ");
INSERT INTO yka_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sine teˈ bangsahan, maningkoloˈ mamanganin atawa manāgad iyehin? Dumaˈin ke maningkoloˈ mamanganin? Saguwaˈ aku inin tuˈu ku si kaˈam kuweˈ daraˈakan. ");
INSERT INTO yka_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kaˈam ne iyan maneteg si akuhin bisan dem meˈ kasusehanku. ");
INSERT INTO yka_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Aku inin kaˈurungan kapatut weˈ Samaku Tuhanin magbayaˈ si pasōngan. Damikkiyan isab urungante kaˈam kapatut magbayaˈ. ");
INSERT INTO yka_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Magtuhut kite bi magkakanan laˈi dem pagsultananku. Duk patingkoloˈku du kaˈam si meˈ paningkoloˈan bangsahan duk magbayaˈ kaˈam si sampūˈ duk duwe bangsa tubuˈ Israˈilin.” ");
INSERT INTO yka_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Manjari paˈin si Isa pu si Petros, “Simon, pakale kew. Bakas kaˈam pāku nakuraˈ seyitanin sinuleyan bang taboˈone ke kaˈam si kalaˈatan. Panuleyannen kuweˈ paley bang tinahapan duk pinagseddili buwasin duk apanen. ");
INSERT INTO yka_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Saguwaˈ bakas kew ampunanku si Tuhan, Simon, karayaw teteg sandelnu si akuhin. Tayikutannu du ku, saguwaˈ pagbalik ne kew si aku, pahagetun sandel meˈ pungtinaˈinun.” ");
INSERT INTO yka_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Paˈin si Petros, “Tuwan, gaˈi kew tayikutanku. Bang kew kinalabusu nuhut ku kaˈu. Bang kew pinapatey, maglillaˈ ku isab pinapatey basta magtuhut kite.” ");
INSERT INTO yka_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Paˈin si Isa, “Akahante kew Petros, gaˈi pe makatingkowak manukin sangem inin, kapamasuwey ne kew mintellu weˈ gaˈi ku kataˈuhannu.” ");
INSERT INTO yka_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Paˈin si Isa pe si siye, “Matuˈuhin pangandaˈakku kaˈam malumengnganin, gaˈi magboˈo pitaka atawa bāg atawa tehompaˈ, niyaˈ ke kulang si kaˈam?” “Gaˈ,” paˈinde. ");
INSERT INTO yka_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Manjari paˈinne si siye, “Saguwaˈ kuweˈitu, bang niyaˈ sīnbi duk semmek pagsayinanbi, boˈohun bi si paglengngananbi. Duk manggaˈ niyaˈ barungnen, ambat pabellihanne jaketnen pamelline barung. ");
INSERT INTO yka_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Peggeˈ akahante kaˈam, subey tinumanan tasulat dem kitab sabab akuhin. Pinaˈin hep laˈi sabab aku, ‘Pinalamud iye si meˈ aˈa ngalanggalan saraˈ.’ Sōng ne taˈabut katumanne inin.” ");
INSERT INTO yka_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Manjari paˈinde, “Tuwan, payamanun, niyaˈ tuˈu duwe barung.” “Sarang ne iyan,” paˈinne. ");
INSERT INTO yka_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Manjari paluwas si Isa amban puweblo hap pī si kūd Jaitun sa hinangannen. Patuhut meˈ tindegnen si iye. ");
INSERT INTO yka_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagtekkane laˈi si lugal papīhannen, paˈinne si meˈ tindegnen, “Māku-māku kaˈam si Tuhan supaya kaˈam gaˈi taboˈo weˈ sassat.” ");
INSERT INTO yka_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ubus patala-tala iye amban siye, talahannen niyaˈ meˈ limempūˈ deppe duk laˈi nengge iye si tuˈutne ngampun si Tuhan. ");
INSERT INTO yka_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Paˈinne, “O Ammaˈ. Bang kew mabayaˈ, daˈa ku pasagadanun bininasa. Saguwaˈ dumaˈin tinuhutin kinabayaˈankun saguwaˈ kinabayaˈannun.” ");
INSERT INTO yka_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Manjari niyaˈ pabagala si iye dambuwaˈ malaˈikat amban surgaˈ ngurungan iye basag. ");
INSERT INTO yka_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Peggeˈ dukka teˈed ateynen, ngampun teˈed iye manamal, hangkan songotnen kuweˈ lahaˈ mettak-mettak si bulak. ");
INSERT INTO yka_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ubus iye ngampun, kuwat iye duk balik iye pī si meˈ tindegnen. Takitene siye kapatuli peggeˈ pannahan siye hawal dukkaden. ");
INSERT INTO yka_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Paˈinne si siye, “Weˈey kaˈam tuli? Kuwat kaˈam duk māku-māku kaˈam si Tuhan supaya kaˈam gaˈi taboˈo weˈ sassat.” ");
INSERT INTO yka_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sasangne pe mamissāhin, banes aˈa tekka. Panuhutanden si Judas, dangan si meˈ sampūˈ duk duwe tindeg si Isahin. Patapit si Judas duk inūk weˈ ne si Isa. ");
INSERT INTO yka_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Paˈin si Isā si iye, “Kuweˈ inin ke, Judas, pamuddinu Anak Manusiyaˈin?” ");
INSERT INTO yka_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pagtahāti meˈ tindeg si Isa mapaliput si iyehin bang ine sōng hininang meˈ aˈahin, paˈinde pu si Isa, “Tuwan, guna kami ne ke barung kamihin?” ");
INSERT INTO yka_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Duk dangan siye, pineddang weˈ ne daraˈakan imam nakuraˈin duk butas tayingene kanawanin. ");
INSERT INTO yka_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Saguwaˈ paˈin si Isa, “Sarang ne iyan.” Manjari inantan weˈ ne tayinge daraˈakanin duk kawuliˈan weˈ ne. ");
INSERT INTO yka_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sinduwe meˈ aˈa mapī maniggew si Isahin, meˈ nakuraˈ meˈ imamin, duk meˈ kapitan guwaldiya si langgal hadjehin, duk meˈ bahiˈ meˈ Yahudihin. Paˈin si Isa si siye, “Weˈ kannalbi mundu ku hangkan kaˈam pitu niggew aku magbarung duk magboˈo meˈ kakakal? ");
INSERT INTO yka_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ellew-ellew laˈi ku si kaˈam dem langgal hadjehin, bu gaˈ ku siggewbi. Saguwaˈ iye ne inin waktu pinasukuˈ si kaˈamin duk ku tasiggewbi, duk inin isab waktu pagbayaˈ nakuraˈ seyitanin.” ");
INSERT INTO yka_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Manjari siggewde si Isa duk boˈode tahalaˈ hap pī si lumaˈ imam nakuraˈin. Si Petros paturul pu si Isa saguwaˈ patala-tala. ");
INSERT INTO yka_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Makellum meˈ sundaluhin ebbut si tengngaˈ lame lumaˈ imam nakuraˈin duk magtingkoloˈ siye paliput. Ningkoloˈ isab si Petros patuhut si siye. ");
INSERT INTO yka_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Manjari takite iye weˈ dambuwaˈ dende daraˈakan sasangne maningkoloˈ-ningkoloˈ dem kasinagan ebbutin. Dinendengan iye weˈ dendehin duk paˈinne, “Aˈa inin saweˈ si Isa du isab.” ");
INSERT INTO yka_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Saguwaˈ masuwey si Petros, paˈinne, “Dende, gaˈi iye kataˈuhanku.” ");
INSERT INTO yka_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gaˈ du tiggel niyaˈ dambuwaˈ lella ngite iye duk paˈinne, “Saweˈde du kew isab.” Saguwaˈ paˈin si Petros, “Dumaˈin, ella.” ");
INSERT INTO yka_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Paglabey niyaˈ da ora, niyaˈ ne isab seddili makatīk si Petros duk paˈinne, “Kataˈuhanku aˈa inin asal bennal saweˈne du isab. Peggeˈ aˈa Jalil du iye inin.” ");
INSERT INTO yka_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Saguwaˈ paˈin si Petros, “Lella, gaˈi kataˈuhanku bang ine pinaˈinnu iyan.” Magtawus tingkowak manukin sasangne pe mamissāhin. ");
INSERT INTO yka_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Manjari pahaleng si Isa duk pinayaman weˈ ne si Petros, duk taˈesseb weˈ si Petros bakas pinaˈin si Isa si iyehin, “Gaˈi pe makatingkowak manukin sangem inin, kapamasuwey ne kew mintellu weˈ gaˈi ku kataˈuhannu.” ");
INSERT INTO yka_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Manjari tahalaˈ si Petros duk magtangis teˈed iye. ");
INSERT INTO yka_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hinang dagey si Isa weˈ meˈ aˈa mamanteyan iyehin, duk pinapeddiˈan weˈ de. ");
INSERT INTO yka_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Binennesan pe weˈ de luwenen duk sinampak weˈ de duk tilewde iye, paˈinde, “Untukun koˈ, sine manampak kaˈuhin?” ");
INSERT INTO yka_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Duk ekka pe bissāde seddili pamaˈiyaˈde iye. ");
INSERT INTO yka_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagsalung ne, magtipun meˈ kabahiˈanin duk meˈ nakuraˈ meˈ imamin duk meˈ guru si saraˈ āgamahin. Siye meˈ kakunsihalan mangahukumin. Binoˈo si Isa pinaharap si siye. ");
INSERT INTO yka_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Paˈinde pu si Isa, “Akahanun kami bang asal kaˈu ne Almasihin.” Paˈin si Isa si siye, “Bisan kaˈam akahanku, gaˈi du ku kahagadbi. ");
INSERT INTO yka_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Duk bang niyaˈ tilewku si kaˈam, gaˈi du kaˈam nambung. ");
INSERT INTO yka_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Saguwaˈ tinagnaˈan kuweˈitu aku, Anak Manusiyaˈin, laˈi du ku ningkoloˈ si kanawanan Tuhan Mabalakatanin.” ");
INSERT INTO yka_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Paˈinde kēmon, “Bang sa īˈ, Anak Tuhanin kew?” Nambung si Isa, paˈinne, “Sa pinaˈinbin, aku ne.” ");
INSERT INTO yka_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Manjari paˈinde, “Weˈey pe kite bi subey miha saksiˈ seddili? Bu kite bi ne du makakale binissānen.” ");
INSERT INTO yka_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Manjari kēmon kakunsihalanin kuwat duk binoˈo weˈ de si Isa pī paharap pu si Pilatus. ");
INSERT INTO yka_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pagtekkade laˈi, tinuntutan si Isa weˈ de. Paˈinde, “Takuhi kami aˈa inin nimboˈohan bangsa kamihin nguntarahan gubelnohin. Gaˈi daˈakne meˈ aˈahin magbayed sukey si Sultan Nakuraˈin. Duk paˈinne pe weˈ iye koˈ Almasihin, hātinen, tapeneˈ Tuhan magsultanin.” ");
INSERT INTO yka_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tilew Pilatus iye, paˈinne, “Sultan meˈ Yahudihin ke kew?” Nambung si Isa, paˈinne, “Iye du pinaˈinnu iyan.” ");
INSERT INTO yka_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Paˈin Pilatus si meˈ nakuraˈ imamin duk si meˈ aˈa mabanesin, “Gaˈ niyaˈ takasuwaˈku duse aˈa inin.” ");
INSERT INTO yka_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Saguwaˈ pasegeˈ teˈed siye, paˈinde, “Magsasew iye si meˈ aˈahin sabab toloˈnen. Tinagnaˈan weˈ ne pagtoloˈnen laˈi si lahat Jalil, duk magtoloˈ isab iye si tibuˈukan Yahudiya, duk kuweˈitu tiyaˈ ne isab iye tuˈu si Awrusalam.” ");
INSERT INTO yka_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pagkale Pilatus inin, paˈinne, “Aˈa Jalil ke aˈa inin?” ");
INSERT INTO yka_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Aweˈ,” paˈinde. Pagkataˈuhan Pilatus weˈ si Isa amban lahat diyalem pagsultanan si Herod, dinaˈak weˈ ne si Isa binoˈo pī pu Sultan Herod, peggeˈ sābu laˈi iye si Awrusalam masa miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pagkite si Herod si Isa, kēgan teˈed iye peggeˈ tiggel ne kabayaˈne mangite iyehin. Ekka aka-aka bakas takalene sabab si Isa duk bayaˈ iye ngite hinangan balakat hinangne. ");
INSERT INTO yka_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hangkan tiggel panilew-nilewne si Isahin, saguwaˈ gaˈ si Isa nambung. ");
INSERT INTO yka_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Manjari meˈ nakuraˈ meˈ imamin duk meˈ guru si saraˈ āgamahin patapit pī duk pinabasag weˈ de panuntutde si Isahin. ");
INSERT INTO yka_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Manjari hinang dagey si Isa weˈ si Herod duk meˈ sundalunen duk diniyawaˈan weˈ de. Pinasemmekan iye weˈ de juba tanam manamal, ubus bu daˈak si Herod ne iye binoˈo balik pī pu si Pilatus. ");
INSERT INTO yka_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ellew miyaˈan magbagay ne Pilatus duk si Herod. Matuˈuhin magbanta hep siye. ");
INSERT INTO yka_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Manjari tinawag weˈ Pilatus patipun meˈ nakuraˈ meˈ imamin duk meˈ bahiˈin duk meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Paˈinne si siye, “Binoˈo weˈ bi aˈa inin pitu si aku duk paˈinbi weˈ katimboˈohan weˈ ne meˈ aˈahin nguntarahan gubelnohin. Bakas ne iye paliksaˈku tuˈu si panaˈananbi, saguwaˈ gaˈ niyaˈ kasuwaˈku duse aˈa inin kuweˈ panuntutanbi iyehin. ");
INSERT INTO yka_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Duk bisan si Herod damikkiyan du isab, peggeˈ daˈakne ne iye binoˈo balik pitu si kite bi. Pastiˈ teˈed weˈ gaˈ niyaˈ laˈat tahinang aˈa inin talep pamapateyan iye. ");
INSERT INTO yka_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hangkan daˈakku hadja iye ilubakan ubus bu paluwasku ne iye.” ( ");
INSERT INTO yka_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hangkan miyaˈan paˈin Pilatus, peggeˈ iye addatnen, kahabaˈ tahun bang magkādjaˈan meˈ Yahudihin inēnande Kādjaˈan Pangessebanin, maluwas iye si meˈ aˈahin dambuwaˈ pilisu.) ");
INSERT INTO yka_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pagka1e meˈ aˈahin pinaˈin si Pilatus miyaˈan, magkalolop siye kēmon, paˈinde, “Papateyun aˈa iyan! Barabbas kabayaˈan kami pinaluwasin.” ( ");
INSERT INTO yka_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Si Barabbas inin tahan dem kalabusu peggeˈ bakas iye nuhut meˈ aˈa nguntarahan gubelnohin laˈi dem puweblo Awrusalam, duk makapapatey iye aˈa.) ");
INSERT INTO yka_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bayaˈ si Isa paluwas Pilatus hangkan ngalingan iye balik si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Saguwaˈ magkalolop siye, paˈinde, “Lansangun iye diyataˈ olom. Lansangun iye diyataˈ olom.” ");
INSERT INTO yka_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kamintellunen paˈin Pilatus si siye, “Weˈey, ine laˈat tahinangnen? Gaˈ niyaˈ takasuwaˈku dusene talep pamapateyan iye. Hangkan daˈakku hadja iye ilubakan ubus bu paluwasku ne iye.” ");
INSERT INTO yka_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Saguwaˈ pasegeˈ teˈed siye duk magkalolop ne paˈin weˈ subey si Isa ilansang diyataˈ olom. Ujudnen tatuhut du kinabayaˈanden. ");
INSERT INTO yka_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hangkan ngalaboˈ hukuman Pilatus weˈ subey tinuhut kinabayaˈanden. ");
INSERT INTO yka_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pinaluwas weˈ ne aˈa pinākude pinaluwasin, aˈa kinalabusu sabab pangatune si gubelnohin duk sabab pamapateynen. Saguwaˈ si Isa sinōngan weˈ ne si meˈ sundalu duk tahinang kinabayaˈan meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Manjari binoˈo ne weˈ de si Isa lumengngan tudju pī si lugal pangalansangan iyehin. Sasangde si lān, niyaˈ tasampangde aˈa amban lahat Kirene, ēnnen si Simon. Bakas amban lahat diyataˈ iye balik pī si puweblo. Ginagahan iye weˈ meˈ sundaluhin duk dinaˈak pinanangkit si iye olom sōng pangalansangan si Isahin, dinaˈak binoˈo si dambulihan si Isa. ");
INSERT INTO yka_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Banes teˈed aˈa patuhut pu si Isa sampay niyaˈ meˈ dende magtangis duk magmatey sababne. ");
INSERT INTO yka_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pahaleng si Isa duk paˈinne si siye, “O meˈ dende Awrusalam, daˈa ku pagtangisanun bi. Iye pagtangisanun bi dibin duk meˈ anakbin. ");
INSERT INTO yka_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Peggeˈ niyaˈ iyan meˈ ellew tekka si pasōngan, paˈin meˈ aˈahin, ‘Hāp sukud meˈ dende manggaˈi manganakin duk meˈ dende manggaˈ bakas manganak duk magpasusuhin.’ ");
INSERT INTO yka_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Duk suknaˈan meˈ aˈahin iyan diden, paˈinde, ‘Weˈey pe ku gaˈi tahanan punu inin. Weˈey pe ku gaˈi lekkeban kūd inin.’ ");
INSERT INTO yka_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Peggeˈ,” paˈin si Isa, “bang kuweˈ inin hininangde si aˈa manggaˈ niyaˈ dusenen, pasōng pe iyan hininangden si meˈ aˈa taga dusehin si meˈ ellew īˈ.” ");
INSERT INTO yka_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Niyaˈ isab duwangan aˈa seddili amban si Isa binoˈo weˈ de pinapatey. Duwangan miyaˈan bakas ngalanggalan saraˈ. ");
INSERT INTO yka_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pagtekkade laˈi si lugal ēnande “Bungkug,” ilansang weˈ de si Isa diyataˈ olom bu pinatengge weˈ de olomin. Ilansang isab weˈ de duwangan ngalanggalan saraˈin si olomde. Dambuwaˈ olomin patenggede si kanawanan si Isa duk dambuwaˈin si bibanganne. ");
INSERT INTO yka_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ngampun si Isa si Tuhan para si meˈ mangalansang iyehin, paˈinne, “O Ammaˈ, ampunun siye peggeˈ gaˈi tahātide hininangde inin.” Meˈ sundaluhin maglegot pagbahagiˈde meˈ semmek si Isahin. ");
INSERT INTO yka_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sasang meˈ aˈa magtengge malaˈihin mayam-mayam, meˈ nakuraˈ meˈ Yahudihin, pinagudjiˈan si Isa weˈ de duk binissāhan. Paˈinde, “Tatabangne meˈ aˈa seddilihin, ambat tabangne dinen bang asal bennal iye Almasihin, tapeneˈ Tuhan magsultanin.” ");
INSERT INTO yka_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Hinang dagey isab iye weˈ meˈ sundaluhin. Patapit siye pī duk sinōngan iye weˈ de ininum pamaˈinum iye. ");
INSERT INTO yka_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Duk paˈinde, “Bang sultan meˈ Yahudihin kew, tabangun dinun.” ");
INSERT INTO yka_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Duk niyaˈ sinulat si olom diyataˈan kōkne pinaˈin, “Inin sultan meˈ Yahudihin.” ");
INSERT INTO yka_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Binissā-bissāhan isab si Isa weˈ dangan meˈ aˈa ngalanggalan saraˈ ilansangin, paˈinne, “Dumaˈin ke kew Almasihin. Na, timbulun be dinun duk sampay kami isab.” ");
INSERT INTO yka_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Saguwaˈ inamāhan iye weˈ saweˈnen, paˈinne, “Weˈey kew missā sa iyan? Weˈ gaˈi kew talew si Tuhan? Saliˈ-saliˈ hep hukuman si kitehin bi tellungan. ");
INSERT INTO yka_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Saguwaˈ kite duwangan patut kite pinapatey kuweˈ inin peggeˈ inin tumbas meˈ hinanganten. Saguwaˈ aˈa inin gaˈ niyaˈ laˈat tahinangne.” ");
INSERT INTO yka_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Manjari paˈinne pu si Isa, “O Isa, daˈa ku kayipatanun bang ne kew magsultan.” ");
INSERT INTO yka_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Paˈin si Isa si iye, “Sabennal akahante kew, ellew inin du, laˈi kite magtuhut si surgaˈ.” ");
INSERT INTO yka_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Paglettu ellew ne, ngalindem mata ellewin duk maglindem dem tibuˈukan lahat miyaˈan sampay lisag tellu kohapin. ");
INSERT INTO yka_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Duk garet isab paduwe semmek subuk hinang ellig dem langgal hadjehin. ");
INSERT INTO yka_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Manjari ngalingan si Isa papales, paˈinne, “O Ammaˈ, sōnganku niyawakun si antanannu.” Pagubus inin bissāne, bekkat ne napasnen. ");
INSERT INTO yka_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pagkite kapitan meˈ sundaluhin maˈumantag miyaˈan, pinudji weˈ ne Tuhanin duk paˈinne, “Asal aˈa hāp teˈed aˈa inin!” ");
INSERT INTO yka_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Duk kēmon aˈa malaˈi magtipun mamayamin, pagkitede maˈumantag miyaˈan, hap lumaˈ siye neppak-neppak dākanden peggeˈ dukka siye manamal. ");
INSERT INTO yka_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kēmon meˈ bagay si Isahin, sampay meˈ dende manuhut iye amban Jalilin, laˈi siye nengge patala-tala duk takitede kēmon bakas maˈumantagin. ");
INSERT INTO yka_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Niyaˈ aˈa laˈi inēnan si Yusup amban puweblo Arimati, laˈi si lahat Yahudiya. Aˈa hāp iye duk bentel kawul-piˈilnen. Inagad-agad weˈ ne katuman meˈ paˈalan sabab pagbayaˈ Tuhanin. Dangan iye si meˈ kakunsihalanin, saguwaˈ gaˈ iye patuhut si meˈ pikilande duk hinangande pamapateyde pu si Isahin. ");
INSERT INTO yka_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Si Yusup inin pī pu si Pilatus duk pināku weˈ ne bangkey si Isahin. ");
INSERT INTO yka_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Manjari ilebbes ne weˈ ne duk sinaput weˈ ne. Ubus bu pinabāk weˈ ne diyalem lingab ilowangan dem batu gaˈ pe bakas pangubulan. ");
INSERT INTO yka_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kohap Jumaˈat ne miyaˈan, duk seddep ne ellewin. Iye ne miyaˈan tagnaˈan ellew liˈihin. ");
INSERT INTO yka_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Meˈ dende manuhut si Isa amban Jalilin, paturul pu si Yusup duk takitede kubulin duk bang saˈingge pamettadne si Isahin diyalem kubul. ");
INSERT INTO yka_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Manjari hap lumaˈ ne siye manyap meˈ laksiˈ duk meˈ isellan bengngi pangalaksiˈde bangkey si Isahin. Pagellew liˈi ne, pahali siye sa pangandaˈakan saraˈin. ");
INSERT INTO yka_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Subu-subu ellew Ahadin, hap pī meˈ dende miyaˈan si kubul moˈo meˈ laksiˈ pinanyapden. ");
INSERT INTO yka_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pagtekkade laˈi, takitede weˈ ubus ne iligidan batu bakas panampeng lingabin. ");
INSERT INTO yka_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Padiyalem siye saguwaˈ takitede weˈ gaˈ ne laˈi bangkey si Isahin. ");
INSERT INTO yka_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Gaˈi siye magkataˈu-taˈu sabab miyaˈan. Manjari bessuwang niyaˈ nengge si bihingde duwangan lella, semmekden makasilew manamal. ");
INSERT INTO yka_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kadahitan teˈed meˈ dendehin duk pakusu siye. Saguwaˈ paˈin meˈ lellahin si siye, “Weˈey pihabi aˈa maˈellumin tuˈu si pangubulande meˈ aˈa mateyin? ");
INSERT INTO yka_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Gaˈ ne tuˈu si Isa. Ubus ne iye ellum balik. Essebun bi pinaˈinne si kaˈamin palaˈine pe si Jalilin. ");
INSERT INTO yka_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Paˈinne hep weˈ iye, Anak Manusiyaˈin, sinōngan du pī si antanan meˈ aˈa dusehan duk lansangde iye diyataˈ olom duk katellu ellewnen ellum du iye balik.” ");
INSERT INTO yka_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Manjari taˈesseb weˈ meˈ dendehin meˈ bakas binissā si Isa miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tahalaˈ siye amban kubulin duk hap lumaˈ ne siye. Inaka weˈ de kēmon inin si meˈ tindeg si Isa sampūˈ duk dambuwaˈin duk si kēmon meˈ tindeg si Isa sinduwehin. ");
INSERT INTO yka_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Meˈ dende inin disi Mariyam, dende amban Magdalahin, si Joˈanna, duk si Mariyam isab, saˈi si Yakubin, duk niyaˈ isab meˈ dende seddili saweˈde. Siye inin mangakahan meˈ tindeg kawakilan si Isahin sabab takiteden. ");
INSERT INTO yka_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Saguwaˈ meˈ kawakilanin, gaˈ kinahagad weˈ de inaka meˈ dendehin peggeˈ paˈinde meˈ koto-koto hadja miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Saguwaˈ paghulangkad si Petros magubas pī si kubul. Pagtekkane laˈi, pakokkoˈ iye pasīp diyalem lingabin. Luwal takitene malaˈihin meˈ saputin. Manjari tahalaˈ iye hap lumaˈ, ulaliˈ teˈed sabab bakas maˈumantagin. ");
INSERT INTO yka_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ellew miyaˈan du isab niyaˈ duwangan tindeg si Isa maglengngan hap pī si kalumaˈan inēnan Emmaus, niyaˈ sampuk-dambuwaˈ kilumetro talahannen amban Awrusalam. ");
INSERT INTO yka_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Magbissā-bissā siye si lān sabab meˈ bakas maˈumantag baˈahu miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sasangde magbissā-bissāhin, pī si Isa patapit duk patuhut iye si siye. ");
INSERT INTO yka_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Takitede iye saguwaˈ gaˈ takilalede si Isa. ");
INSERT INTO yka_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Paˈinne si siye, “Ine pagbissā-bissābi miyaˈan sasangbi malumengnganin?” Padeheng siye duk takite si bantuk luwe duwanganin weˈ suse siye. ");
INSERT INTO yka_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Manjari dangan siye, ēnnen si Kelopas, nambung, paˈinne, “Weˈ gaˈi kataˈuhannu maˈumantag si Awrusalam baˈahu miyaˈan, bu kēmon aˈa laˈi ngataˈu?” ");
INSERT INTO yka_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Weˈey, ine maˈumantagin?” paˈin si Isa. “Maˈumantag pu si Isahin be, aˈa Nasaretin,” paˈinde. “Si Isa inin nabi balakatan si matahan Tuhan duk meˈ aˈahin kēmon. Taga balakat iye si meˈ bissānen duk si meˈ hinangannen. ");
INSERT INTO yka_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sinōngan iye weˈ meˈ nakuraˈ meˈ imam kamihin duk meˈ nakuraˈ lahat kamihin pī si gubnulin duk ilaboˈan iye hukuman pinapatey, ubus bu ilansang iye weˈ de diyataˈ olom duk iye matey. ");
INSERT INTO yka_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bu asal ase-ase kami teˈed miyaˈan, weˈ iye ne pinapitu Tuhan mamaluwas meˈ tubuˈ Israˈilin. Aweˈ, duk dumaˈin hadja miyaˈan, saguwaˈ tellum bahangi ne kuweˈitu kemuwe pamapateyde iyehin. ");
INSERT INTO yka_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Duk niyaˈ isab meˈ dende saweˈ kamihin, niyaˈ inaka weˈ de si kami makaˈulaliˈ kami teˈed. Ensiniˈ salung, subu-subu pe, hap pī koˈ siye si kubul si Isa. ");
INSERT INTO yka_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Saguwaˈ gaˈ ne koˈ laˈi baran si Isahin, duk paˈinde weˈ niyaˈ koˈ takitede pabagala meˈ malaˈikat magpaˈin si siye weˈ ellum ne koˈ si Isa. ");
INSERT INTO yka_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Manjari sinduwe meˈ saweˈ kamihin hap pī si kubul, duk takitede sa pinaˈin meˈ dendehin. Saguwaˈ si Isa gaˈ du isab takitede.” ");
INSERT INTO yka_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Manjari paˈin si Isa si siye, “Babbal pahāp kaˈam iyan. Weˈey gaˈi kahagadbi kēmon pinaˈin meˈ kanabihan dem kitabin? ");
INSERT INTO yka_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Paˈin meˈ kanabihanin hep weˈ Almasihin subey dahuˈ makalabey kabinasahan meke iye magsultan si kēmon-kēmonin.” ");
INSERT INTO yka_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Manjari pinahāti weˈ si Isa si siye kēmon sinulat dem kitab sabab iyehin. Tinagnaˈan weˈ ne amban meˈ tasulat si Musahin hap pī si meˈ tasulat meˈ kanabihanin kēmon. ");
INSERT INTO yka_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pagtapit ne siye si kalumaˈan papīhanden, si Isa magmā-mā kuweˈ sōng patalus, ");
INSERT INTO yka_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","saguwaˈ inohotan teˈed iye weˈ de, paˈinde, “Tuˈu ne kew dahuˈ si kami peggeˈ iyuˈ ne kohap teˈed. Sōng lindem ne.” Hangkan padiyalem ne si Isa nuhut siye. ");
INSERT INTO yka_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Manjari inin, paglaˈi siye magtingkoloˈ sōng mangan, ngeddoˈ si Isa pan duk magpasalamat iye si Tuhan, ubus bu kinepak-kepak weˈ ne duk pinangurung weˈ ne si siye. ");
INSERT INTO yka_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Bessuwang hadja takilalede ne si Isa. Saguwaˈ magtawus iye lanyap amban bihingde. ");
INSERT INTO yka_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Manjari magbissā-bissā siye duwangan, paˈinde, “Hangkan du hatiˈ landuˈ kēgten sābune mamissā si kite si lānin, pagpahātine kitab si kitehin.” ");
INSERT INTO yka_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kuwat siye duˈun-duˈun duk balik siye hap Awrusalam. Pagtekkade laˈi, takasuwaˈde tindeg si Isa sampūˈ duk dambuwaˈin magtipun-tipun duk meˈ sinduwehin. ");
INSERT INTO yka_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Paˈinde si duwanganin, “Asal ellum ne teˈed balik Panuhutanin duk bakas pakite iye pu si Simon.” ");
INSERT INTO yka_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Manjari magsuwi-suwi isab duwanganin sabab malumabey si siye si lānden, duk bang saˈingge pakakilalede pu si Isahin. Paˈinde weˈ pangilalehande iyehin pangepak-ngepakne panin. ");
INSERT INTO yka_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sasang magsuwi-suwi pe duwanganin, bessuwang si Isa laˈi nengge si tengngaˈde. Duk paˈinne si siye, “Karayaw sanyang kaˈam.” ");
INSERT INTO yka_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Takeddut siye duk kadahitan siye peggeˈ kannalde panyataˈ takitede miyaˈan. ");
INSERT INTO yka_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Saguwaˈ paˈinne si siye, “Weˈey kaˈam takeddut duk weˈey pe kaˈam duwe-duwehan? ");
INSERT INTO yka_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Payamanun bi meˈ tangankun duk meˈ bettiskun. Asal aku hep ituˈ. Antanun bi be ku duk kataˈuhanbi weˈ dumaˈin ku ituˈ panyataˈ. Peggeˈ panyataˈin gaˈ hep niyaˈ baranne. Saguwaˈ aku inin takitebi du weˈ niyaˈ baranku.” ");
INSERT INTO yka_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Paˈinne inin duk pinakitehan weˈ ne si siye meˈ tangannen duk meˈ bettisnen. ");
INSERT INTO yka_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Saguwaˈ kuweˈ kahunitan siye kahagad weˈ asal toˈo miyaˈan, peggeˈ kēgan teˈed siye duk ulaliˈ siye. Manjari paˈinne si siye, “Niyaˈ ke tuˈu kinakan ine-ine?” ");
INSERT INTO yka_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sinōngan iye weˈ de dambuwaˈ kenna tinunuˈ. ");
INSERT INTO yka_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ineddoˈ weˈ ne duk kinakan weˈ ne si matahande. ");
INSERT INTO yka_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Puwas miyaˈan, paˈinne si siye, “Iye ne hep inin bakas pinaˈinku si kaˈam matuˈuhin, masa pagtuhut-tuhutten bi pe. Paˈinku hep weˈ subey du tinumanan kēmon bakas tasulat sabab akuhin, iye tasulat dem saraˈ si Musahin duk tasulat meˈ kanabihanin duk dem kitab Jabur. Na, meˈ maˈumantag si aku miyaˈan, katumanan ne meˈ tasulatden.” ");
INSERT INTO yka_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Manjari inurungan siye pikilan supaya tasabutde kitabin, ");
INSERT INTO yka_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","duk paˈinne si siye, “Iye inin tasulat dem kitabin, weˈ Almasihin subey nandalan kabinasahan sampay pinapatey duk katellu ellewnen puwas kamateynen ellum balik. ");
INSERT INTO yka_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tasulat isab laˈi weˈ subey minahalayak si meˈ aˈa amban kēmon kabangsa-bangsahan weˈ bang pagsusunande duk lebbahande meˈ duseden, ampun Tuhanin du siye sabab tahinang Almasihin. Duk subey nagnaˈ minahalayak tuˈu si Awrusalam. ");
INSERT INTO yka_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Peggeˈ kaˈam ne teˈed bakas mangite meˈ maˈumantag si akuhin, hangkan subey kaˈam manaksiˈin,” paˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Duk papituku du si kaˈam,” paˈinne, “pananggup Samaku Tuhanin. Hangkan daˈa dahuˈ kaˈam usaˈ amban puweblo Awrusalam inin samantaˈan gaˈi pe kaˈam paˈasekan balakat amban Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Manjari binoˈo siye weˈ ne paluwas amban Awrusalam hap pī si antag kalumaˈan Betani. Pagtekkade laˈi, pinadiyataˈ weˈ ne meˈ tangannen māku-mākuhan siye kahāpan amban Tuhan. ");
INSERT INTO yka_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sasangne pe mamāku-māku si Tuhanin, tahalaˈ ne iye amban siye duk paˈangkat iye hap surgaˈ. ");
INSERT INTO yka_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pasujud siye pu si Isa laˈi, ubus bu balik ne siye hap Awrusalam. Kēgan teˈed siye manamal, ");
INSERT INTO yka_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","duk luwal siye laˈi dem langgal hadjehin mudji Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gaˈ pe dunya inin pinapanjari asal andang ne Lapalin. Lapalin magdambuwaˈ duk Tuhanin duk Lapalin Tuhanin ne. ");
INSERT INTO yka_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kemuwe awwalley Lapalin duk Tuhanin dambuwaˈ du. ");
INSERT INTO yka_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kēmon-kēmonin pinapanjari weˈ Lapalin amban pangandaˈakan Tuhanin. Gaˈ niyaˈ pinapanjari bisan ine tuˈu dem alam inin bang dumaˈin amban Lapalin. ");
INSERT INTO yka_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lapalin asal poˈon umulin duk umul inin mangurung dantaˈ si pikilan manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Dantaˈ inin ninag dem kalindeman duk dantaˈin gaˈi teˈed tapalem weˈ lindemin. ");
INSERT INTO yka_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Manjari, niyaˈ aˈa kawakilan weˈ Tuhanin, ēnnen Yahiya. ");
INSERT INTO yka_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dinaˈak iye weˈ Tuhanin pitu magaka sabab dantaˈ inin, supaya kēmon aˈahin makakale inakanen duk kahagad. ");
INSERT INTO yka_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dumaˈin Yahiya dantaˈ inin. Saguwaˈ akane mapituhin magaka-aka sabab dantaˈin. ");
INSERT INTO yka_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Dantaˈ mabennal inin, hātinen Lapalin, tiyaˈ ne pitu si dunya ngurung dantaˈ si pikilan manusiyaˈin kēmon. ");
INSERT INTO yka_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Saguwaˈ bisan ne Lapalin tuˈu si dunya duk pinapanjari hep weˈ ne dunyahin, gaˈ du Lapalin takilale weˈ meˈ aˈa si dunyahin. ");
INSERT INTO yka_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pitu iye si lahatne, saguwaˈ gaˈ iye tinayimaˈ weˈ bangsanen. ");
INSERT INTO yka_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Saguwaˈ sine-sine nayimaˈ Lapalin duk makahagad si iyehin, urunganne siye kapatut manjari meˈ anak Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tahinang siye anak Tuhanin dumaˈin kuweˈ paganak manusiyaˈ atawa amban kabayaˈan manusiyaˈ atawa amban napsu manusiyaˈ. Saguwaˈ tahinang siye anak Tuhanin amban kabayaˈan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Manjari, Lapalin palahil tuˈu si dunya taga baran manusiyaˈ duk patennaˈ diyaleman manusiyaˈ. Kēmon lasa duk bennal laˈi si iye. Takite kami balakatnen duk sahayanen, duk balakatne duk sahayane inin talep si iye peggeˈ iye Anak Tuhan dambuwaˈ-buwaˈin. ");
INSERT INTO yka_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si Yahiya magaka-aka sabab Lapalin. Missā iye papales, paˈinne, “Iye ne hep inin bakas inakaku si kaˈamin, paˈinku, ‘Niyaˈ pitu dambuli amban aku. Pasōng iye langkew amban aku peggeˈ gaˈ pe ku inanakan, asal andang ne iye.’” Iye inin inaka Yahiyahin. ");
INSERT INTO yka_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Peggeˈ laˈi si Lapalin kēmon lasahin, kite bi kēmon makahampit isab lasanen duk tabangnen. Lasanen duk tabangnen pinagtamba-tamba si kite bi. ");
INSERT INTO yka_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Saraˈ Tuhanin pinasampay si manusiyaˈ weˈ si Musa, saguwaˈ lasa Tuhanin duk bennalin pinangurung si manusiyaˈ weˈ Isa Almasi, iye inēnan Lapal Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gaˈ niyaˈ bakas ngite Tuhanin. Saguwaˈ pinakataˈu Tuhanin si manusiyaˈ weˈ Anakne dambuwaˈ-buwaˈin, peggeˈ asal Tuhan du iye duk magdambuwaˈ iye duk Samanen. Manjari niyaˈ meˈ aˈa pī pu si Yahiya sābune magpandi meˈ aˈa si lipag boheˈ Jordan, si kalumaˈan Betani. ");
INSERT INTO yka_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Dambuwaˈ ellew niyaˈ meˈ imam duk meˈ tabang meˈ imamin dinaˈak weˈ meˈ nakuraˈ meˈ Yahudi si puweblo Awrusalamin hap pī pu Yahiya nilew iye bang sine iye. ");
INSERT INTO yka_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Gaˈ magellig-ellig Yahiya saguwaˈ magbennal teˈed iye, paˈinne, “Dumaˈin ku Almasihin.” ");
INSERT INTO yka_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Na, sine kew?” paˈinde. “Si Eliyas ke kew?” Paˈin Yahiya, “Dumaˈin.” Paˈin meˈ imamin, “Kaˈu ke nabi inagad-agad bangsate bi Israˈilin?” Nambung Yahiya, “Dumaˈin.” ");
INSERT INTO yka_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Manjari paˈinde si iye, “Akahanun kami bang sine kew teˈed. Subey kami akahannu supaya niyaˈ pangaka kami si meˈ mangandaˈak kami mapituhin. Ine paˈinnu sabab dinun?” ");
INSERT INTO yka_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sambung Yahiyahin saliˈ du teˈed kuweˈ bakas tasulat Nabi Isaya dem kitabin. Paˈin Yahiya, “Aku aˈa maglingan papales dem lahat makagindew-gindewin. Paˈinku: Pabentelun bi lān sōng palabeyan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Meˈ imam inin bakas dinaˈak pī weˈ meˈ Yahudi be-āgama teˈed inēnan meˈ Pariseo. ");
INSERT INTO yka_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Manjari tinilew weˈ de Yahiya balik, paˈinde, “Na, weˈey kew magpandi meˈ aˈa bang dumaˈin kew Almasihin atawa si Nabi Eliyas atawa nabi inagad-agad bangsate bi Israˈilin?” ");
INSERT INTO yka_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Sambungan Yahiya siye, paˈinne, “Aku inin, magpandi ku meˈ aˈa duk boheˈ. Saguwaˈ niyaˈ dambuwaˈ nengge luˈu si tengngaˈbi saguwaˈ gaˈi kataˈuhanbi bang sine. ");
INSERT INTO yka_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","28","Dambuli iye amban aku pitu, saguwaˈ gaˈi ku pataˈ bisan ngalekkahan ingket tehompaˈnen peggeˈ langkew teˈed iye amban aku.” ");
INSERT INTO yka_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pagsasumuhin, kite Yahiya si Isa pī patudju si iye. Pagkitene si Isa, paˈin Yahiya si meˈ aˈa malaˈihin, “Iye ne hep inin dalil gantiˈ bili-bili pangurung Tuhanin pagkuluban para si manusiyaˈ. Iye inin mamuwasan duse manusiyaˈin kēmon. ");
INSERT INTO yka_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iye ne hep inin bakas inakaku si kaˈamin, paˈinku, ‘Niyaˈ pitu dambuli amban aku. Langkew iye amban aku, peggeˈ gaˈ pe ku inanakan asal andang ne iye.’ ");
INSERT INTO yka_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tagnaˈ gaˈ kataˈuhanku bang sine aˈa mapitu dambuli amban akuhin,” paˈin Yahiya. “Saguwaˈ pitu ku magpandi meˈ aˈa duk boheˈ supaya iye tapakilale si bangsa Israˈilin. ");
INSERT INTO yka_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Gaˈ pe iye kataˈuhanku, saguwaˈ paˈin Tuhan mangandaˈak aku magpandi meˈ aˈa duk boheˈin, ‘Bang takitenu Niyawa Sutsihin paduwaˈi pī si dambuwaˈ aˈa duk pateteg laˈi si iye, iye iyan seddili pamandine manusiyaˈin; papīne si siye Niyawa Sutsihin.’” Manjari naksiˈ Yahiya sabab si Isa, paˈinne, “Bakas takiteku teˈed Niyawa Sutsihin duwaˈi amban diyataˈ langit kuweˈ bantuk assang padapuˈ duk pateteg pu si Isa. ");
INSERT INTO yka_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Asal takiteku teˈed,” paˈin Yahiya, “hangkan kasaksiˈanku weˈ bennal-bennal teˈed si Isa inin Anak Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pagsasumuhin, laˈi ne isab si Yahiya si lipag boheˈ Jordan duk duwangan meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Takite Yahiya si Isa palabey. Magtawus paˈinne, “Iye hep miyaˈan dalil bili-bili Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Takale meˈ tindegne duwanganin pinaˈin Yahiya miyaˈan, manjari paturul siye pu si Isa. ");
INSERT INTO yka_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Paghaleng si Isa, takitene duwanganin paturul si iye. Tinilew siye weˈ ne, paˈinne, “Ine akabin?” Nambung siye, paˈinde, “Rabbi, (hātinen Guru) antag patennaˈannun?” ");
INSERT INTO yka_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Paˈin si Isa, “Nuhut kaˈam aku duk takitebi.” Manjari nuhut ne siye si Isa. Hatu ne miyaˈan meˈ lisag ampat kohap. Takite weˈ de patennaˈan si Isahin duk laˈi pe siye ngeregseˈ lindem. ");
INSERT INTO yka_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Dambuwaˈ mapaturul pu si Isahin, ēnnen si Andariyas. Si Andariyas inin pungtinaˈi si Simon Petros. ");
INSERT INTO yka_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Manjari magtawus piniha weˈ Andariyas pungtinaˈinen. Pagtakasuwaˈne ne, paˈinne si iye, “Takasuwaˈ kami ne Almasihin.” (Almasihin iye tapeneˈ Tuhan magsultan matuˈu si dunyahin.) ");
INSERT INTO yka_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ubus binoˈo weˈ ne si Simon pī pu si Isa. Pinayaman si Simon pahantap weˈ si Isa duk paˈinne, “Kaˈu si Simon; ēn samanun Yahiya. Saguwaˈ ēnante kew si Kepas.” (Ēn Kepas inin saliˈ du kuweˈ ēn Petros, hātinen, batu.) ");
INSERT INTO yka_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pagsasumuhin, tapikil si Isa hap pī si lahat Jalil. Takasuwaˈne si Pilip duk paˈinne si iye, “Nuhut kew aku.” ");
INSERT INTO yka_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Pilip inin amban Betsaida, lahat si Andariyas duk si Petrosin. ");
INSERT INTO yka_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Piniha weˈ si Pilip si Natanael. Pagtakasuwaˈne, inakahan weˈ ne, paˈinne, “Takasuwaˈ kami ne aˈa bakas inaka si Musa dem kitab Tawratin duk inaka isab weˈ meˈ kanabi-nabihanin dem sulatden. Iye si Isa anak si Yusupin amban kalumaˈan Nasaret.” ");
INSERT INTO yka_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Paˈin Natanael, “Oy, gaˈ niyaˈ aˈa hāp paguwaˈ amban Nasaret.” Paˈin si Pilip, “Nuhut be kew aku duk kitenu.” ");
INSERT INTO yka_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pagkite si Isa si Natanael tudju pī si iye, paˈin si Isa, “Tiyaˈ niyaˈ dambuwaˈ aˈa Israˈil teˈed. Gaˈi iye ngakkal.” ");
INSERT INTO yka_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Paˈin Natanael pu si Isa, “Saˈingge pangataˈunu akuhin?” Sambungan si Isa iye, paˈinne, “Gaˈ pe kew linganan si Pilip, takitete ne kew diyawaˈ poˈon kayu igirahin.” ");
INSERT INTO yka_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Paˈin Natanael si iye, “Tuwan, kaˈu Anak Tuhanin. Kaˈu sultan bangsa Israˈilin.” ");
INSERT INTO yka_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Paˈin si Isa si iye, “Kahagad ke kew si aku peggeˈ paˈinku weˈ takitete kew diyawaˈ poˈon igirahin? Si pasōngan makakite du kew iyan meˈ hinanganku labi pe makaˈulaliˈ amban inin.” ");
INSERT INTO yka_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Duk paˈin si Isa si siye, “Sabennal akahante kaˈam, si pasōngan takitebi du iyan surgaˈin luka duk takitebi isab meˈ malaˈikat Tuhanin magduwaˈi-manaˈik amban aku, Anak Manusiyaˈin.” ");
INSERT INTO yka_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pagpuwas duwem bahangi kemuwe pagbissā si Isa duk Natanaelin, niyaˈ magkawin laˈi si kalumaˈan Kana, laˈi si lahat Jalil. Saˈi si Isahin laˈi si pagkawinan. ");
INSERT INTO yka_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Si Isa duk meˈ tindegnen tabatik isab pī. ");
INSERT INTO yka_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Manjari laˈi si pagkawinan, ininumden boheˈ ubas bu ubus ne weˈ meˈ aˈahin ininum. Paˈin saˈi si Isahin si iye, “Ubus ne boheˈ ubas ininumden.” ");
INSERT INTO yka_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Paˈin si Isa si saˈinen, “Daˈa kew magsuse sabab iyan. Aku saˈ taˈu si iyan. Gaˈ pe taˈabut waktu pamakiteku balakatkun.” ");
INSERT INTO yka_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Manjari paˈin saˈinen si meˈ daraˈakan si lumaˈ miyaˈan, “Ine-ine pangandaˈakan si Isa kaˈam, hinangun bi.” ");
INSERT INTO yka_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Niyaˈ laˈi ennem poga batu pangisihan boheˈ pangosoˈan meˈ Yahudihin, nuhut addatde pagsutsihin. Dambuwaˈ poga isihan meˈ lime mital. ");
INSERT INTO yka_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Paˈin si Isa si meˈ daraˈakanin, “Pennoˈanun bi meˈ poga iyan duk boheˈ.” Pinennoˈan ne weˈ de, sampay sōng buˈus. ");
INSERT INTO yka_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Manjari daˈak si Isa siye, paˈinne, “Nginduk ne kaˈam amban meˈ poga iyan bu boˈohun bi pī si mangantan pagkādjaˈan inin.” Binoˈo ne weˈ de pī si mangantan pagkādjaˈanin, ");
INSERT INTO yka_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","duk kininaman weˈ ne boheˈ mamanjari boheˈ ubasin. Gaˈ kataˈuhanne bang amban boheˈ ubas miyaˈan, saguwaˈ meˈ daraˈakan bakas manginduk boheˈin kataˈuhande. Manjari magtawus ilinganan weˈ ne pangantin lellahin. ");
INSERT INTO yka_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Paˈinne si iye, “Iye addatin bang magtāgad, pamaˈinum dehellu ininum mahāpin. Manjari bang ekka ne taˈinum meˈ aˈahin, meke ne pamaˈinum ininum manggaˈi mahāpin. Saguwaˈ kaˈu, taˈennaˈnu pe sampay kuweˈitu ininum mahāpin.” ");
INSERT INTO yka_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iye inin hinangan makaˈulaliˈ tagnaˈ hininang si Isahin. Hininang inin weˈ ne laˈi si Kana, si lahat Jalil. Pinakitehan weˈ ne balakatnen, manjari kahagad meˈ tindegnen si iye. ");
INSERT INTO yka_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagubus inin, padurul disi Isa hap pī si puweblo Kapernaum. Saweˈne magtuhutin saˈinen, meˈ pungtinaˈinen, duk meˈ tindegnen. Laˈi siye patennaˈ bang piyem bahangi. ");
INSERT INTO yka_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tapit ne pagkādjaˈan meˈ bangsa Israˈilin ēnande Pangesseban. Hangkan pataked si Isa duk meˈ tindegnen hap Awrusalam, lahat pagkādjaˈanin. ");
INSERT INTO yka_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pagtekkade laˈi, padiyalem siye dem langgal hadjehin. Iye takite si Isahin dem langgal miyaˈan, meˈ aˈa magdagang sapiˈ duk meˈ bili-bili duk meˈ assang para pagkuluban. Duk takitene isab meˈ aˈa magtingkoloˈ si bihing lamisahanden magsambiˈ-sambiˈ sīn. ");
INSERT INTO yka_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pagkite si Isa siye laˈi, ngeddoˈ iye lubid hinangne lalagut bu pinaluwas siye kēmon weˈ ne amban dem langgalin, sampay meˈ bili-biliden duk meˈ sapiˈden. Ilintuwadan isab weˈ ne meˈ lamisahan meˈ aˈa magsambiˈ-sambiˈ sīnin duk kinanat weˈ ne sīnden. ");
INSERT INTO yka_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Duk paˈinne si meˈ aˈa magdagang assangin, “Paluwasun bi meˈ daganganbi iyan amban dem langgal inin! Daˈa hinangun bi tabuˈan langgal inin, peggeˈ inin lumaˈ Samaku, Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pagkite meˈ tindeg si Isahin hininangne inin, taˈessebde weˈ tasulat dem kitab, pinaˈin laˈi, “Ellegku si lumaˈnun, o Tuhan, kuweˈ ebbut dem ateyku makapagkaˈat aku.” ");
INSERT INTO yka_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Manjari tinilew si Isa weˈ meˈ nakuraˈ meˈ Yahudihin, paˈinde, “Ine kapatutnu ngahinang meˈ hininangnu miyaˈan? Pakitehanun kami hinangan makaˈulaliˈ tandaˈ kapatutnun.” ");
INSERT INTO yka_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sambungan si Isa siye, paˈinne, “Larakun bi langgal inin, duk patenggeku balik dem tellu ellew.” ");
INSERT INTO yka_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Uy,” paˈin meˈ nakuraˈin, “langgal inin, ampatpūˈ duk ennem tahun pangahinang inin. Tapatenggenu balik dem tellu ellew hadja?” ");
INSERT INTO yka_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Saguwaˈ hāti langgal pinaˈin si Isahin, dumaˈin langgal miyaˈan, saguwaˈ barannen. ");
INSERT INTO yka_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hangkan pagellum ne balik si Isa amban kamateynen, taˈesseb meˈ tindegnen weˈ bakas bissāne inin. Duk kinahagad ne weˈ de tasulat dem kitabin duk bakas binissā si Isahin. ");
INSERT INTO yka_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Palaˈi si Isa si Awrusalamin, baytu Kādjaˈan Pangessebanin, ekka kahagad si iye pagkitede meˈ hinangan makaˈulaliˈ hininangnen. ");
INSERT INTO yka_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Saguwaˈ si Isa gaˈ ngandel si siye, peggeˈ kataˈuhanne pikilan duk diyalem atey manusiyaˈin kēmon. ");
INSERT INTO yka_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Bisan iye gaˈi inakahan, kataˈuhanne du bang ine dem atey manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Manjari inin, niyaˈ dambuwaˈ nakuraˈ meˈ Yahudihin, ēnnen si Nikodemus. Dambuwaˈ iye Pariseo. ");
INSERT INTO yka_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dambuwaˈ sangem pī iye pu si Isa duk paˈinne, “Tuwan, kataˈuhan kami weˈ kaˈu dambuwaˈ guru dinaˈak weˈ Tuhanin pitu. Peggeˈ gaˈi tahinangnu meˈ hinangan makaˈulaliˈ hininangnun bang gaˈ kew kaˈurungan balakat weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nambung si Isa, paˈinne, “Sabennal akahante kew, bang aˈahin gaˈi inanakan balik, gaˈi takitene pagbayaˈan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Paˈin Nikodemus, “Saˈingge aˈahin inanakan balik bang bahiˈ ne iye? Gaˈi iye umasek balik pī dem betteng saˈinen bu inanakan balik.” ");
INSERT INTO yka_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nambung si Isa, paˈinne, “Sabennal akahante kew, bang aˈahin gaˈi inanakan amban boheˈ duk amban Niyawa Tuhanin, gaˈi iye umasek dem pagbayaˈan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Inanakan weˈ manusiyaˈin, manusiyaˈ du. Saguwaˈ bang aˈahin inanakan balik amban Niyawa Tuhanin, tahinang iye anak Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Daˈa kew ulaliˈ peggeˈ paˈinku si kaˈu weˈ subey kaˈam kēmon inanakan balik,” paˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Dalilnen baliyuhin. Baliyuhin nihup tungan-tungan kabayaˈanne. Gaˈi kataˈuhan bang amban baliyuhin atawa bang tungan, saguwaˈ takalenu begeddunen. Sa miyaˈan du isab bang aˈahin inanakan amban Niyawa Tuhanin, gaˈi kataˈuhan bang saˈingge saguwaˈ toˈo.” ");
INSERT INTO yka_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Saˈingge kajarine inin?” paˈin Nikodemus. ");
INSERT INTO yka_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nambung si Isa, paˈinne, “Gaˈi ke inin tahātinu bu guru bantu kew tuˈu si bangsate Israˈil? ");
INSERT INTO yka_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sabennal akahante kew, kami iye inaka kamihin kinataˈuhan kamihin, duk iye sinaksiˈan kamihin meˈ bakas takite kamihin. Saguwaˈ gaˈi kahagadbi panaksiˈ kamihin. ");
INSERT INTO yka_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Saˈingge pakahagadbi panoloˈku sabab surgaˈin, bang bisan panoloˈku sabab dunyahin gaˈi kahagadbi? ");
INSERT INTO yka_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gaˈ niyaˈ bakas tapī si surgaˈ luwal aku, Anak Manusiyaˈin. Duwaˈi ku pitu amban surgaˈ. ");
INSERT INTO yka_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Si Musa awwalley, masa palaˈine si lahat makagindew-gindewin magtuhut duk meˈ bangsa Israˈilin, ngahinang iye bantuk sawe amban tumbaga duk pinaˈangkat duk binowet weˈ ne diyataˈ olom, supaya bang payaman meˈ aˈa bakas tatigtukin sawe miyaˈan, kawuliˈan siye. Damikkiyan aku, Anak Manusiyaˈin, subey ku isab pinaˈangkat diyataˈ olom duk pinapatey, ");
INSERT INTO yka_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","supaya kēmon masandel si akuhin ellum salama-lama laˈi si panaˈanan Tuhanin.” Iye inin bissā si Isa pu Nikodemusin. ");
INSERT INTO yka_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kinalasahan teˈed weˈ Tuhanin manusiyaˈin, hangkan sinōngan weˈ ne Anakne dambuwaˈ-buwaˈin pinapatey, supaya kēmon masandel si Anaknen gaˈi pasapeˈ amban Tuhan saguwaˈ ellum siye salama-lama laˈi si panaˈanan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pinapitu weˈ Tuhanin Anaknen si dunya dumaˈin ngalaboˈan manusiyaˈin hukuman, saguwaˈ muwasan duseden. ");
INSERT INTO yka_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sine-sine sandel si Anak Tuhanin gaˈi tewwaˈ hukuman Tuhanin. Manggaˈi masandelin, tewwaˈ hukuman Tuhanin ne, peggeˈ gaˈ iye sandel pu si Isa, Anak Tuhan dambuwaˈ-buwaˈin. ");
INSERT INTO yka_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iye inin jānnen hangkan siye tewwaˈ hukuman Tuhanin, peggeˈ tiyaˈ ne pitu si Isa si dunya ngadantaˈan pikilan manusiyaˈin, saguwaˈ gaˈi manusiyaˈin mabayaˈ si dantaˈin. Kabayaˈande lindemin peggeˈ meˈ hinanganden laˈat. ");
INSERT INTO yka_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kēmon maghinang malaˈatin bunsi teˈed si dantaˈin duk gaˈi iye patapit si dantaˈin, peggeˈ gaˈi iye bayaˈ weˈ takite meˈ hinanganne malaˈatin. ");
INSERT INTO yka_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Saguwaˈ kēmon maghinang mabentelin pī dem dantaˈ supaya pastiˈ takite weˈ meˈ hinangannen nuhut pangandaˈakan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagubus inin, hap pī si Isa duk meˈ tindegnen si meˈ kalahatan si Yahudiya. Tiggel-tiggel siye laˈi duk magpandi siye meˈ aˈa laˈi. ");
INSERT INTO yka_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Gaˈ pe miyaˈan si Yahiya takalabusu. Magpandi meˈ aˈa isab Yahiya laˈi si lahat Anon peggeˈ ekka boheˈ laˈi. Lahat Anon inin tapit si lahat Salim. Ekka meˈ aˈa magpīhan si iye duk pinandi siye weˈ ne. ");
INSERT INTO yka_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Manjari meˈ tindeg Yahiyahin magsuˈal duk dambuwaˈ Yahudi sabab addat pagsutsihin. ");
INSERT INTO yka_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hap pī meˈ tindeg Yahiya miyaˈan si iye duk paˈinde si iye, “Tuwan, taˈessebnu ke aˈa saweˈnu magtuhut laˈi si lipag boheˈ Jordanin, iye bakas inakanun? Na kuweˈitu magpandi meˈ aˈa ne iye, duk ekka teˈed aˈa hap pī si iye.” ");
INSERT INTO yka_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nambung Yahiya, paˈinne, “Gaˈ niyaˈ kapatut aˈa bang dumaˈin pangurung Tuhan si iye. ");
INSERT INTO yka_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kaˈam iyan magsaksiˈan aku weˈ bakas tapaˈinku weˈ dumaˈin ku Almasihin. Pinapitu ku hadja dehellu amban iye, magpanyap para si iye. ");
INSERT INTO yka_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bang upama niyaˈ magkawin, pangantin lellahin dapuˈ andahin. Saguwaˈ bagaynen nengge-nengge laˈi duk pakale-kale. Sinna iye pagtakalene missā pangantin lellahin. Kami duk si Isa kuweˈ siye miyaˈan du isab,” paˈin Yahiya. “Kēgan ne ku manamal. ");
INSERT INTO yka_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Subey iye pasōng pinahadje saguwaˈ aku subey ne padiyawaˈ-diyawaˈ,” paˈin Yahiya. ");
INSERT INTO yka_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mapitu amban surgaˈin langkew amban kēmon. Aˈa amban dunyahin, luwal hadja sabab dunya binissānen peggeˈ aˈa dunya iye. Saguwaˈ mapitu amban surgaˈin langkew amban kēmon. ");
INSERT INTO yka_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Meˈ panoloˈnen meˈ bakas takitene duk takalene laˈi si surgaˈin, saguwaˈ gaˈ niyaˈ kahagad si panoloˈnen. ");
INSERT INTO yka_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Bang niyaˈ kahagad si panoloˈnen, magbennal iye sabab inin weˈ kēmon pinaˈin Tuhanin asal bennal. ");
INSERT INTO yka_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Almasi pinapitu weˈ Tuhanin, duk iye binissānen, lapal Tuhanin, peggeˈ pangurung si iye Niyawa Tuhanin, Niyawa Tuhanin gaˈ teˈed niyaˈ kulang pu Almasi. ");
INSERT INTO yka_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Malasa teˈed Tuhanin si Anaknen duk inurungan iye weˈ ne kapatut si kēmon-kēmonin. ");
INSERT INTO yka_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Sine-sine sandel si Anak Tuhanin ellum salama-lama. Saguwaˈ manggaˈi masandel duk manuhut si Anak Tuhanin, gaˈ niyaˈ umulne salama-lama. Bisan miyaˈan, pateteg si iye mulkaˈ Tuhanin salama-lama. ");
INSERT INTO yka_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Manjari, takale meˈ Pariseohin weˈ mas ekka koˈ aˈa patindeg pu si Isa duk tapandi weˈ ne amban meˈ mapatindeg pu si Yahiyahin. ");
INSERT INTO yka_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Saguwaˈ iye matoˈohin, dumaˈin si Isa magpandi meˈ aˈahin saguwaˈ meˈ tindegnen hadja.) ");
INSERT INTO yka_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pagkataˈuhan weˈ si Isa sabab meˈ suwi-suwi inin, tahalaˈ iye duk meˈ tindegnen amban lahat Yahudiya balik pī si lahat Jalil. ");
INSERT INTO yka_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Subey siye pabutas amban lahat Samariya. ");
INSERT INTO yka_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pagtekka siye si lahat Samariya, hap pī siye si dambuwaˈ puweblo inēnan Sikar. Tapit puweblo inin si bulak pinangurung weˈ si Yakub si anaknen Yusup awwalley. ");
INSERT INTO yka_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Laˈi si antag miyaˈan niyaˈ kupung bakas hininang weˈ si Yakub awwalley. Ningkoloˈ si Isa si higad kupungin peggeˈ pekkeng iye si paglengnganan. Lettu ne miyaˈan ellewin. ");
INSERT INTO yka_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Meˈ tindegnen gaˈ laˈi peggeˈ laˈi siye hap puweblo melli kinakande. Gaˈ tiggel niyaˈ tekka pī dende Samariya nginduk boheˈ. Paˈin si Isa si iye, “Dende, urungun ku boheˈ inumku.” ");
INSERT INTO yka_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nambung dendehin, paˈinne, “Oy, bangsa Yahudi kew. Weˈey kew māku boheˈ si aku bu bangsa Samariya ku?” Missā dendehin kuweˈ miyaˈan peggeˈ meˈ Yahudihin gaˈi hep bayaˈ ngangguna meˈ panyap meˈ aˈa Samariyahin. ");
INSERT INTO yka_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nambung si Isa, paˈinne, “Bang hadja kataˈuhannu bang ine pangurung Tuhan si manusiyaˈin duk bang sine ku, mamāku boheˈ si kaˈu kuweˈitu inin, bugtuˈ asal māku kew isab boheˈ si aku duk paˈinumte kew boheˈ makapakellumin.” ");
INSERT INTO yka_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Tuwan,” paˈin dendehin, “antag kew ngeddoˈ boheˈ makapakellumin? Gaˈ hatiˈ niyaˈ panginduknu duk lalem hep kupung inin. ");
INSERT INTO yka_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kupung inin taˈamban si kami weˈ papuˈten bi si Yakub. Siye magtewtey-anakin duk sampay meˈ hayepden, tuˈu si kupung inin panginumanden. Weˈ labi kapatutnun amban kapatut si Yakubin?” ");
INSERT INTO yka_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nambung si Isa, paˈinne, “Kēmon manginum boheˈ kupung inin, lekkakan du balik. ");
INSERT INTO yka_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Saguwaˈ sine-sine makaˈinum boheˈ pamaˈinumku iyehin, gaˈi ne teˈed lekkakan balik. Peggeˈ boheˈ pamaˈinumku iyehin manjari kuweˈ buwal neyibuwa diyalem ateyne, ngurungan iye boheˈ makapakellum iye salama-lama.” ");
INSERT INTO yka_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“Tuwan,” paˈin dendehin, “urungun ku boheˈ pinaˈinnu inin inumku, duk ne ku gaˈi lekkakan balik duk gaˈi ne ku subey magpituhan nginduk boheˈ.” ");
INSERT INTO yka_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Pī kew eddoˈun ellanun,” paˈin si Isa, “bu boˈohun pitu.” ");
INSERT INTO yka_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Gaˈ niyaˈ ellaku,” sambung dendehin. Paˈin si Isa si iye, “Toˈo pinaˈinnu iyan. Gaˈ niyaˈ ellanu. ");
INSERT INTO yka_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Peggeˈ minlime kew bakas magella saguwaˈ saweˈnu magdambuwaˈ kuweˈituhin dumaˈin ellanu. Toˈo pinaˈinnun.” ");
INSERT INTO yka_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Paˈin dendehin pu si Isa, “Tuwan, bahu kataˈuhanku weˈ kaˈu inin nabi hatiˈ. ");
INSERT INTO yka_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Meˈ kapapuˈan kami bangsa Samariyahin,” paˈinne, “tuˈu si punu inin lugal panambahayangande Tuhanin. Saguwaˈ kaˈam meˈ Yahudihin, paˈinbi weˈ subey laˈi si Awrusalam panambahayangante bi Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Paˈin si Isa si iye, “Dende, kahagadun pinaˈinku inin. Niyaˈ du iyan waktu si pasōngan, bang meˈ aˈahin nambahayang si Samate bi Tuhanin, dumaˈin tuˈu si punu inin atawa laˈi si Awrusalam. ");
INSERT INTO yka_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kaˈam meˈ bangsa Samariyahin, magsambahayang kaˈam saguwaˈ awam kaˈam bang ine sinambahayangbin. Kami meˈ Yahudihin, kataˈuhan kami bang sine sinambahayang kamihin, peggeˈ manimbul meˈ manusiyaˈin paguwaˈ hep amban bangsa Yahudi. ");
INSERT INTO yka_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Saguwaˈ tekka du waktuhin duk kuweˈitu ne hep, weˈ meˈ aˈa manambahayang sabennalin, sambahayangde du Samate bi Tuhanin amban dem ateyde duk asal toˈo panambahayangden. Kuweˈ iyan kinabayaˈan Samate bi Tuhanin panambahayang si iyehin.” ");
INSERT INTO yka_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Paˈin si Isa pe, “Tuhanin poˈon niyawa, lagiˈ niyawa du iye, dumaˈin du iye kuweˈ manusiyaˈ taga baran. Duk sasuku manambahayang si iyehin subey sambahayangde iye amban dem ateyde duk subey toˈo panambahayangde si iyehin.” ");
INSERT INTO yka_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Paˈin dendehin pu si Isa, “Asal kataˈuhanku niyaˈ du pitu si pasōngan magsultan si kite bi, iye Almasihin. Pagtekka iye pitu, pahātihanne du si kami kēmon-kēmonin.” ");
INSERT INTO yka_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Paˈin si Isa, “Aku ne hep, iye mamissā si kaˈu inin.” ");
INSERT INTO yka_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bahu ubus bissāne inin, tekka ne meˈ tindeg si Isahin. Ulaliˈ siye peggeˈ kitede niyaˈ dende saweˈne magbissā-bissā. Saguwaˈ gaˈ siye nilew dendehin bang ine akanen, atawa nilew si Isa bang weˈey iye magbissā-bissā duk dende miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Manjari inambanan weˈ dendehin komboˈne pangisi-ngisihanne boheˈin duk balik iye pī si puweblo. Pagtekkane laˈi, missā iye si meˈ aˈa malaˈihin. ");
INSERT INTO yka_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Paˈinne, “Dayiˈ be kaˈam nuhut aku. Payamanun bi, niyaˈ aˈa ngakahan aku kēmon bakas tahinangku ilabeyin. Dumaˈin enteˈ iye Almasihin?” ");
INSERT INTO yka_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Manjari paluwas meˈ aˈa miyaˈan amban puweblo duk lumengngan siye pī mayaman si Isa. ");
INSERT INTO yka_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Paglumikut ne dendehin hap puweblo, binuyuˈ-buyuˈ si Isa weˈ meˈ tindegnen dinaˈak mangan. Paˈinde, “Tuwan, mangan kew.” ");
INSERT INTO yka_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Saguwaˈ sambungan si Isa siye, paˈinne, “Niyaˈ du kinakanku gaˈi kataˈuhanbi.” ");
INSERT INTO yka_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hangkan meˈ tindegnen magtilew-tinilew, paˈinde, “Niyaˈ enteˈ bakas moˈohan iye kinakan?” ");
INSERT INTO yka_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Paˈin si Isa si siye, “Iye makaˈesso akuhin, bang tahinangku kinabayaˈan Tuhanin, iye mamapitu akuhin, duk subey ubusanku hinang pinahinangne si akuhin. ");
INSERT INTO yka_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Dumaˈin ke niyaˈ eliˈanbi, paˈinbi, ‘Ampat bulan pe meke pagani?’ Saguwaˈ akahante kaˈam,” paˈin si Isa, “taˈabut ne paganihin. Pantewun bi be meˈ aˈa mapitu iyan. Bang ibatan paleyin, tahak ne siye duk sarang ne pinagani. Hātinen sōng ne siye kahagad si aku. ");
INSERT INTO yka_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Meˈ aˈa magtipun siyehin binoˈo si aku, tinumbasan du hāp. Duk meˈ aˈa tinipunden inurungan umul du salama-lama. Hangkan saliˈ-saliˈ kēgan magtanemin duk magtipunin. ");
INSERT INTO yka_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Toˈo eliˈan inin, paˈinde, ‘Sakadangan magtanemin, seddili mamaganihin.’ ");
INSERT INTO yka_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Daˈakte kaˈam magani gaˈ pagluˈuganbin. Seddili magluˈugin saguwaˈ makahampit kaˈam amban pagluˈuganden.” ");
INSERT INTO yka_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Manjari ekka meˈ aˈa Samariya amban puweblo Sikarin kahagad pu si Isa sabab pinaˈin dendehin. Paˈinne hep, “Inakahan ku weˈ ne kēmon bakas tahinangku ilabeyin.” ");
INSERT INTO yka_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hangkan pagtekka meˈ aˈa Samariyahin laˈi pu si Isa, inohotan iye weˈ de laˈi dahuˈ si siye patennaˈ. Duk patennaˈ si Isa laˈi duwem bahangi. ");
INSERT INTO yka_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sasang laˈi pe iye, ekka pe meˈ aˈa kahagad pu si Isa sabab panoloˈne si siyehin. ");
INSERT INTO yka_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Paˈinde si dendehin, “Kuweˈitu kahagad ne kami pu si Isa, dumaˈin ne sabab inakanu si kamihin, saguwaˈ peggeˈ asal di kami ne makakale meˈ panoloˈnen, duk kataˈuhan kami weˈ sabennal iye manimbul meˈ manusiyaˈ si dunyahin.” ");
INSERT INTO yka_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagpuwas duwem bahangi laˈi, tahalaˈ si Isa duk meˈ tindegnen amban Sikar hap pī si lahat Jalil. ");
INSERT INTO yka_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bakas tabissā si Isa hep, paˈinne, “Basta nabi, gaˈi pagaddatan weˈ meˈ aˈa lahatnen.” ");
INSERT INTO yka_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pagtekka disi Isa laˈi si lahat Jalil, sinampang siye weˈ meˈ aˈahin peggeˈ bakas siye laˈi si Awrusalam baytu Kādjaˈan Pangessebanin duk bakas takitede kēmon hininang si Isa malaˈihin. ");
INSERT INTO yka_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Manjari balik si Isa pī si Kana, laˈi si lahat Jalil. Laˈi hep si Kana bakas pinamanjari boheˈ ubas weˈ ne boheˈin. Manjari sumābu isab laˈi dambuwaˈ bagellal sultanin. Saki anakne lellahin laˈi si puweblo Kapernaum. ");
INSERT INTO yka_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pagkale bagellal inin weˈ tekka ne si Isa laˈi si lahat Jalil amban lahat Yahudiya, magtawus iye pī pu si Isa. Binuyuˈ-buyuˈ weˈ ne si Isa binoˈo pī hap Kapernaum makoleˈ anaknen, peggeˈ sōng ne matey. ");
INSERT INTO yka_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Paˈin si Isa si iye, “Bang kaˈam gaˈi makakite meˈ tandaˈ duk meˈ hinangan makaˈulaliˈ, gaˈi kaˈam kahagad.” ");
INSERT INTO yka_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Paˈin bagellalin si iye, “Andūˈ, Tuwan, nuhut ne kew aku pādpād gaˈ pe matey anakkun.” ");
INSERT INTO yka_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","“Hap lumaˈ ne kew,” paˈin si Isa. “Koleˈ du anaknun.” Kinahagad weˈ aˈahin pinaˈin si Isahin duk hap lumaˈ ne iye. ");
INSERT INTO yka_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Sasangne pe si lān hap lumaˈin, pasampang si iye meˈ daraˈakannen duk inakahan iye weˈ de, paˈinde, “Koleˈ ne anaknun.” ");
INSERT INTO yka_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tinilew siye weˈ ne bang lisag piye kakoleˈnen duk paˈinde, “Diˈilew lisag dambuwaˈ kohapin, gaˈ ne iye maglemmun.” ");
INSERT INTO yka_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Manjari taˈesseb sama nakanakin weˈ iye ne teˈed miyaˈan ora pagpaˈin si Isa si iyehin, “Anaknun koleˈ du.” Hangkan kahagad ne iye pu si Isa duk sampay kēmon saweˈne dambuwaˈ lumaˈin kahagad du isab. ");
INSERT INTO yka_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kaduwe inin ne tandaˈ makaˈulaliˈ hininang si Isa si lahat Jalilin, pabalikne si Jalil amban Yahudiyahin. ");
INSERT INTO yka_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gaˈ tiggel puwas inin, pataked disi Isa hap Awrusalam peggeˈ niyaˈ kādjaˈan meˈ Yahudihin laˈi. ");
INSERT INTO yka_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Laˈi si Awrusalam niyaˈ limbu, ēnnen bang si bissā Yahudi, limbu Betsata. Limbu inin si bihing dambuwaˈ meˈ tarangka padiyaleman hap Awrusalamin, inēnan tarangka bili-bili. Niyaˈ lime lumaˈ-lumaˈ pasayindungan si bihing limbu miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tuˈu si meˈ lumaˈ-lumaˈ inin, ekka meˈ aˈa saki pabāk. Niyaˈ siye pessek, niyaˈ pengkaˈ duk niyaˈ matey baranden. (Inagad-agad weˈ de paseyibuwa boheˈ dem limbuhin. ");
INSERT INTO yka_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Peggeˈ bang patekka niyaˈ malaˈikat Tuhanin pī dem limbu ngutaˈul boheˈin. Duk madumehellu mapī dem boheˈin, pagubus kutaˈul boheˈin, kawuliˈan bisan ine sakinen.) ");
INSERT INTO yka_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Niyaˈ dambuwaˈ aˈa laˈi tellumpūˈ duk walun tahun ne sakinen. ");
INSERT INTO yka_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Takite si Isa iye pabāk-bāk laˈi duk kataˈuhanne weˈ tiggel ne saki aˈa miyaˈan. Manjari tilew si Isa iye, paˈinne, “Bayaˈ ke kew koleˈ?” ");
INSERT INTO yka_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nambung aˈa sakihin, paˈinne, “Aweˈ, Tuwan. Saguwaˈ gaˈ niyaˈ mengket aku pī dem limbu bang ne kutaˈul boheˈin. Duk sasangku pe paˈinsud pī, niyaˈ ne dumehellu amban aku.” ");
INSERT INTO yka_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Paˈin si Isa si iye, “Kuwat kew, boˈohun pabākannun bu nu ne lumengngan.” ");
INSERT INTO yka_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Magtawus aˈahin koleˈ. Binoˈo weˈ ne pabākannen bu lumengngan ne iye. Na, ellew miyaˈan, ellew Sabtuˈ, ellew liˈi meˈ Yahudihin. ");
INSERT INTO yka_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hangkan pagkite meˈ nakuraˈ Yahudihin aˈa makawuliˈanin magboˈo pabākannen, paˈinde, “Hoy! Ellew liˈi maˈin. Langgalannu saraˈten bi pamoˈonu pabākannu iyan.” ");
INSERT INTO yka_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sambunganne siye, paˈinne, “Aˈa mamakoleˈ akuhin, daˈakne binoˈo si aku pabākankun duk daˈakne ku lumengngan.” ");
INSERT INTO yka_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Sine aˈa mangandaˈak kaˈuhin?” paˈinde. ");
INSERT INTO yka_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Saguwaˈ gaˈ kataˈuhanne bang sine, peggeˈ ekka teˈed aˈa laˈi si higad limbu duk magtawus si Isa tahalaˈ. ");
INSERT INTO yka_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Puwas inin, takasuwaˈ si Isa aˈa bakas masakihin laˈi dem langgal hadjehin. Paˈin si Isa si iye, “Payamanun, koleˈ ne kew. Hangkan lebbahanun ne dusenun, kaw pe niyaˈ pasōng laˈat tekka si kaˈu.” ");
INSERT INTO yka_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Manjari tahalaˈ aˈahin duk pī iye ngakahan meˈ nakuraˈ meˈ Yahudihin weˈ si Isa makoleˈ iyehin. ");
INSERT INTO yka_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hangkan hep si Isa kinuntarahan teˈed weˈ meˈ nakuraˈ meˈ Yahudihin, peggeˈ pinakoleˈ weˈ ne aˈa sakihin baytu ellew liˈi. ");
INSERT INTO yka_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Manjari sambungan si Isa siye, paˈinne, “Samaku Tuhanin luwal maghinang sampay maˈin, damikkiyan aku, maghinang ku isab.” ");
INSERT INTO yka_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Peggeˈ kuweˈ miyaˈan sambung si Isahin, hangkan tinuyuˈan teˈed iye pinapatey weˈ de, dumaˈin hadja peggeˈ langgalanne saraˈ ellew liˈihin, saguwaˈ peggeˈ paˈinne isab weˈ Tuhanin Samanen, hātinen pasaliˈne dinen si Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Sambungan si Isa meˈ nakuraˈ miyaˈan, paˈinne, “Sabennal akahante kaˈam, gaˈ teˈed niyaˈ tahinangku bang baran-baranku hadja. Saguwaˈ ine-ine takiteku hinang Samakun, iye isab miyaˈan hininangkun. Kēmon hininang Samanen iye du isab hininang Anaknen. ");
INSERT INTO yka_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Peggeˈ kinalasahan ku weˈ Samaku Tuhanin, duk pinakitaˈu weˈ ne si aku kēmon hininangnen. Duk si pasōngan pahinangne pe ku iyan meˈ hinangan pasōng balakatan amban meˈ tahinangku ilabeyin, ubus bu kēmon kaˈam ulaliˈ manamal. ");
INSERT INTO yka_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Samaku Tuhanin makapakellum aˈa matey. Damikkiyan isab aku, Anak Tuhanin, tapakellumku sine-sine kabayaˈanku. ");
INSERT INTO yka_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Duk dumaˈin Samakun Tuhanin mangahukum me manusiyaˈin. Saguwaˈ pinangurung weˈ ne si aku kapatut mangahukum manusiyaˈin kēmon, ");
INSERT INTO yka_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","supaya kēmon aˈahin, pahadjede ku kuweˈ pamahadjede Tuhanin. Sine-sine gaˈi mahadje Anak Tuhanin, gaˈi du isab pahadjene Samaku Tuhanin, iye mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Sabennal akahante kaˈam, sine-sine makakale meˈ panoloˈkun duk kahagad si mamapitu akuhin, ellum iye salama-lama. Gaˈi iye tewwaˈ hukuman Tuhanin. Gaˈi ne iye legga Tuhanin saguwaˈ ellum iye salamalama. ");
INSERT INTO yka_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sabennal akahante kaˈam,” paˈin si Isa, “taˈabut ne waktuhin, kēmon manggaˈ pe makahagadin, meˈ dalil pateyin, kalede suwalakun, aku Anak Tuhanin. Duk kēmon makakalehin pinakellum du. ");
INSERT INTO yka_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Samakun poˈon umulin, duk aku inin poˈon umulin kuweˈ Samakun du, sabab kapatut pinangurungne si akuhin. ");
INSERT INTO yka_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Duk kaˈurungan ku isab weˈ Samakun kapatut ngahukum meˈ manusiyaˈin, peggeˈ aku iye inēnan Anak Manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Daˈa kaˈam ulaliˈ si bissāku inin,” paˈin si Isa. “Niyaˈ waktu si pasōngan, kēmon pateyin kalede du suwalakun. ");
INSERT INTO yka_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pagkalede, paguwaˈ siye amban dem kubulde. Meˈ aˈa bakas maghinangan mahāpin, paguwaˈ duk ellum siye salama-lama si surgaˈ. Duk meˈ aˈa bakas maghinangan malaˈatin, paguwaˈ du isab duk tewwaˈ hukuman Tuhanin siye, duk ilegga siye.” ");
INSERT INTO yka_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Paˈin si Isa, “Gaˈ niyaˈ tahinangku bang baran-baranku hadja. Ngahukum ku hadja kuweˈ pangandaˈakan Samaku akuhin. Hangkan bentel hukumankun. Peggeˈ dumaˈin tinuyuˈanku hininangin kinabayaˈankun, saguwaˈ kinabayaˈan Tuhan mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Bang aku hadja missā sabab dikun, gaˈi du ku kahagadbi. ");
INSERT INTO yka_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Saguwaˈ niyaˈ seddili naksiˈan aku. Kataˈuhanku weˈ panaksiˈne si akuhin asal bennal.” ");
INSERT INTO yka_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Paˈin si Isa pe, “Bakas kaˈam ngandaˈak meˈ aˈabi pī pu Yahiya. Duk inaka weˈ Yahiya mabennalin sabab aku. ");
INSERT INTO yka_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Saguwaˈ dumaˈin pangandelankun saksiˈ manusiyaˈ. Bissāku hadja inin sabab Yahiya supaya kaˈam timbul. ");
INSERT INTO yka_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Yahiya kuweˈ dalil payitaˈan kayat ngurung dantaˈ si pikilan manusiyaˈ duk sinna kaˈam si dantaˈnen, hātinen si panoloˈnen, bisan daddaliˈ hadja. ");
INSERT INTO yka_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Saguwaˈ niyaˈ saksiˈ si aku pasōng basagnen amban panaksiˈ Yahiyahin. Iye ne meˈ hinang bakas tahinangkun. Meˈ hinangku inin amban pangandaˈakan Samaku Tuhanin duk daˈakne si aku inubus. Asal meˈ hinang hininangku ne inin naksiˈan aku weˈ Samaku Tuhanin mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Duk Samakun, iye mamapitu akuhin, saksiˈanne ku isab. Saguwaˈ gaˈ bakas takalebi suwalanen duk gaˈ bakas takitebi bayhuˈnen. ");
INSERT INTO yka_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Duk gaˈ lapalnen paˈessep dem ateybi peggeˈ gaˈ kaˈam kahagad si aku, iye pinapitune si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kaˈam iyan, magtuyuˈ teˈed kaˈam ngadjiˈ kitabin, peggeˈ tapikilbi bang kaˈam ngadjiˈ ngasuwaˈ umul kaˈam salama-lama si surgaˈ. Bu kitab inin ne magaka sabab akuhin. ");
INSERT INTO yka_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Saguwaˈ gaˈi kaˈam ngatu patuhut si aku, bu aku makaˈurungan kaˈam umul gaˈ tamanannen.” ");
INSERT INTO yka_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Paˈin si Isa pe si meˈ nakuraˈ meˈ Yahudihin, “Dumaˈin inapaskun sanglitan manusiyaˈ ku. ");
INSERT INTO yka_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Saguwaˈ kataˈuhanku bang ine dem ateybin. Kataˈuhanku gaˈ niyaˈ lasabi si Tuhan. ");
INSERT INTO yka_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bisan ku pitu inurungan kapatut amban Samaku Tuhanin, gaˈi du ku kahagadbi. Saguwaˈ bang niyaˈ aˈa seddili pitu magkapatutan dine, kahagadbi iye. ");
INSERT INTO yka_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Saˈingge pakahagadbi si akuhin bang iye kabayaˈanbin sanglitan saweˈbin kaˈam? Gaˈi iye apasbi sanglit amban Tuhanin, Tuhan dambuwaˈ-buwaˈin. ");
INSERT INTO yka_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Daˈa pikilun bi weˈ sumbungte kaˈam si Samaku Tuhanin laˈi si ellew paghukum. Dumaˈin aku saguwaˈ si Musa, mamasampay si kaˈam saraˈ tinuhutbin, iye manumbung kaˈamin. ");
INSERT INTO yka_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bang bennal kaˈam kahagad pu si Musa, subey kaˈam kahagad si aku peggeˈ sabab aku hep sinulatne dem kitabin. ");
INSERT INTO yka_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Saguwaˈ peggeˈ gaˈi kahagadbi meˈ sinulat si Musahin, saˈingge pakahagadbi meˈ bissākun?” ");
INSERT INTO yka_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Dambuwaˈ ellew, pagtapit ne isab pagkādjaˈan meˈ Yahudi inēnande Kādjaˈan Pangessebanin, palipag si Isa pī si dambiyaˈ lamew Jalil, inēnan isab lamew Tiberi. Banes teˈed aˈa paturul si iye peggeˈ bakas takitede meˈ hinanganne makaˈulaliˈin pagpakoleˈne meˈ aˈa masakihin. Manjari pataked si Isa duk meˈ tindegnen pī si punu duk ningkoloˈ siye laˈi. ");
INSERT INTO yka_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pagpayam si Isa, banes teˈed aˈa takitene hap pī si iye. Hangkan paˈinne pu si Pilip, dambuwaˈ tindegnen, “Antag kite melli kinakan pamakan meˈ aˈa inin kēmon?” ");
INSERT INTO yka_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Paˈin si Isa inin panuleyanne si Pilip bang ngandel ke iye si balakatnen. Bang si Isa, asal kataˈuhanne bang ine sōng hininangnen. ");
INSERT INTO yka_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Sambungan si Pilip iye, paˈinne, “Tangdan aˈa maghinang dem walum bulan gaˈi umabut pamelli kinakan pamakan meˈ aˈa inin, supaya dangan-dangan makaˈakan tadaˈahat.” ");
INSERT INTO yka_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Manjari nambung dambuwaˈ tindeg si Isa seddili, si Andariyas. Si Andariyas inin pungtinaˈi si Simon Petros. ");
INSERT INTO yka_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Paˈinne pu si Isa, “Niyaˈ tuˈu nakanak lella-lella, niyaˈ lime kayuˈ panne duk duwe kennane. Saguwaˈ asal gaˈi umabut pamakan meˈ aˈa inin kēmon.” ");
INSERT INTO yka_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Manjari paˈin si Isa si meˈ tindegnen, “Daˈakun bi meˈ aˈahin ningkoloˈ.” Laˈi si antag miyaˈan luha balilinen. Ningkoloˈ siye kēmon laˈi. Meˈ lellahin hadja, niyaˈ lime ngibu ekkahanden. Seddili pe meˈ dendehin duk meˈ nakanakin. ");
INSERT INTO yka_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Manjari ineddoˈ weˈ si Isa pan nakanakin bu magpasalamat iye si Tuhan, ubus bu binahagiˈ-bahagiˈ weˈ ne si meˈ aˈa magtingkoloˈin. Damikkiyan isab binahagiˈ-bahagiˈ weˈ ne kennahin duk inurungan siye taman kinabayaˈanden. ");
INSERT INTO yka_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pagesso ne siye, paˈin si Isa si meˈ tindegnen, “Tipunun bi meˈ lukasin supaya gaˈ niyaˈ tapakaˈat.” ");
INSERT INTO yka_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Manjari tinipun ne weˈ de kēmon lukasin. Amban pan lime kayuˈ kinakan meˈ aˈahin, lukas tinipunden niyaˈ sampuūˈ duk duwe bakaˈ pennoˈ. ");
INSERT INTO yka_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pagkite meˈ aˈa malaˈihin hinangan makaˈulaliˈ tahinang si Isa miyaˈan, paˈinde, “Asal inin ne teˈed nabi inagad-agadte bi mapitu si dunyahin.” ");
INSERT INTO yka_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kataˈuhan si Isa weˈ meˈ aˈahin sōng pī niggew iye dinaˈak magsultan si siye, hangkan magtawus iye tahalaˈ duk pī iye si punu dendang-dendangan. ");
INSERT INTO yka_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pagsōng magalib ne, padurul meˈ tindegnen pī si higad lamew. ");
INSERT INTO yka_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lindem ne bu gaˈ pe si Isa pī si siye. Manjari pasakey siye si bangkaˈ duk palipag siye pī si dambiyaˈ lamew tudju lahat Kapernaum. ");
INSERT INTO yka_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Gaˈ du tiggel basag ne baliyuhin duk hadje goyakin. ");
INSERT INTO yka_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pagubus ne siye kapamusey lime atawa ennem kilumetro talahannen, takitede si Isa lumengngan diyataˈ kuwit-kuwit lamew patapit pī si bangkaˈde. Kadahitan teˈed siye manamal. ");
INSERT INTO yka_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Saguwaˈ paˈin si Isa si siye, “Daˈa kaˈam tinalew. Aku hep ituˈ.” ");
INSERT INTO yka_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Sinakey weˈ de si Isa duk pagsumakey ne iye, magtawus siye tekka si lahat tinudjuden. ");
INSERT INTO yka_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pagsasumuhin, meˈ aˈa mabanes mapaˈamban si dambiyaˈ lamewin, takitede weˈ dambuwaˈ du bangkaˈ bakas malaˈihin; duk kataˈuhande weˈ gaˈ si Isa pasakey laˈi nuhut meˈ tindegnen, saguwaˈ luwal du meˈ tindegnen mapatulakin. ");
INSERT INTO yka_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Niyaˈ meˈ bangkaˈ bahu tekka amban puweblo Tiberi padungguˈ tapit si antag bakas pagkakanande panin pagubus si Isa magpasalamat. ");
INSERT INTO yka_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Manjari pagkite meˈ aˈahin weˈ gaˈ hatiˈ laˈi si Isa atawa meˈ tindegnen, pasakey siye si meˈ bangkaˈ miyaˈan miha si Isa pī si Kapernaum. ");
INSERT INTO yka_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pagtakasuwaˈde si Isa laˈi si dambiyaˈ lamew, paˈinde si iye, “Tuwan, sumiyan papitunun?” ");
INSERT INTO yka_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Sambungan si Isa siye, paˈinne, “Sabennal akahante kaˈam, hangkan ku pihabi, peggeˈ esso kaˈam weˈ panin. Saguwaˈ gaˈ tahātibi hinangan makaˈulaliˈ tahinangku si matahanbin. ");
INSERT INTO yka_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Daˈa iye pagtuyuˈanun bi kinakan mamagkaˈatin. Saguwaˈ iye subey pagtuyuˈanbin kinakan manggaˈi magkaˈatin, kinakan makaˈellum salama-lamahin. Aku, Anak Manusiyaˈin, mangurungan kaˈam kinakan inin, peggeˈ kaˈurungan ku kapatut weˈ Samaku Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Manjari tinilew weˈ de si Isa, paˈinde, “Na, ine ne paˈin subey hinang kami duk tatuhut kami kinabayaˈan Tuhanin?” ");
INSERT INTO yka_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Sambungan si Isa siye, paˈinne, “Iye inin kabayaˈan Tuhan subey hininangbin, weˈ subey kaˈam kahagad si aku, iye pinapitunen.” ");
INSERT INTO yka_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Paˈinde pu si Isa, “Tandaˈ ine pinakitehannu si kamihin duk kami kahagad si kaˈu? Meˈ kapapuˈanten bi mangan manna laˈi dem lahat makagindew-gindew awwalley. Paˈin kitabin, ‘Inurungan siye weˈ ne kinakan amban surgaˈ.’ Na, kaˈu,” paˈinde pu si Isa, “ine hinang tahinangnun?” ");
INSERT INTO yka_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Paˈin si Isa si siye, “Sabennal akahante kaˈam, mannahin, kinakan pinangurung si Musahin, dumaˈin miyaˈan kinakan mabennal amban surgaˈin. Kinakan amban surgaˈin, iye kinakan pangurung Samaku si kaˈamin, duk pinangurungne inin, kinakan mabennalin. ");
INSERT INTO yka_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Peggeˈ kinakan pangurung Tuhan inin, iye ne mapitu amban Tuhanin duk ngurung umul iye si manusiyaˈ.” ");
INSERT INTO yka_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Manjari māku meˈ aˈa miyaˈan pu si Isa, paˈinde, “Tuwan, tiggelan kami ellum, urungun kami kinakan pinaˈinnu inin.” ");
INSERT INTO yka_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Paˈin si Isa, “Aku ne hep kinakan makaˈellumin. Sasuku manuhut akuhin gaˈi ne teˈed inusan balik. Duk sasuku makahagad si akuhin, gaˈi ne teˈed lekkakan balik. ");
INSERT INTO yka_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na, bakas ne kaˈam akahanku weˈ bisan ku takitebi, gaˈi du kaˈam kahagad. ");
INSERT INTO yka_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kēmon pinasukuˈ Samaku si akuhin, nuhut du si aku. Duk kēmon manuhut si akuhin, gaˈi patahalaˈku, ");
INSERT INTO yka_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","peggeˈ pitu ku dumaˈin ngahinang kinabayaˈankun saguwaˈ ngahinang kinabayaˈan Tuhanin, iye mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kabayaˈan Tuhanin weˈ gaˈ teˈed niyaˈ lepas amban aku meˈ aˈa pinasukuˈne si akuhin. Saguwaˈ subey pakellumku siye kēmon si ellew dambuli. ");
INSERT INTO yka_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Peggeˈ kabayaˈan Samaku Tuhanin, weˈ subey ellum salama-lama kēmon mangite duk makahagad si akuhin, Anaknen. Duk pakellumku siye si ellew dambuli.” ");
INSERT INTO yka_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Manjari ngunub-ngunub meˈ aˈahin sabab pinaˈin si Isa miyaˈan pagpaˈinne, “Aku kinakan amban surgaˈin.” ");
INSERT INTO yka_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Paˈinde, “Dumaˈin ke aˈa inin si Isa, anak si Yusupin? Kataˈuhante bi hep saˈi-samanen. Weˈey iye magpaˈin weˈ amban surgaˈ iye?” ");
INSERT INTO yka_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nambung si Isa paˈinne, “Daˈa kaˈam magkunub-kunub luˈu. ");
INSERT INTO yka_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gaˈ niyaˈ kapanuhut si aku bang gaˈi iye urungan Tuhan mamapitu akuhin bayaˈ nuhut aku. Duk manuhut si akuhin pakellumku du si ellew dambuli. ");
INSERT INTO yka_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Niyaˈ tasulat dem kitab kanabi-nabihanin sa inin, ‘Tinoloˈan du siye kēmon weˈ Tuhanin.’” Paˈin si Isa pe, “Kēmon mapakale si panoloˈ Samaku Tuhanin, siye ne matumuhut si akuhin. ");
INSERT INTO yka_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dumaˈin hātine inin weˈ niyaˈ manusiyaˈ bakas ngite Samaku Tuhanin. Gaˈ niyaˈ bakas ngite Samakun; luwal hadja aku, mapitu amban Tuhanin, bakas mangite iyehin. ");
INSERT INTO yka_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sabennal akahante kaˈam,” paˈin si Isa, “sasuku makahagad si akuhin ellum salama-lama. ");
INSERT INTO yka_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aku kinakan makaˈellumin,” paˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","“Meˈ kapapuˈanbin makaˈakan manna laˈi si lahat makagindew-gindew, saguwaˈ matey du siye. ");
INSERT INTO yka_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Saguwaˈ kinakan amban surgaˈ inin, bang niyaˈ aˈa makaˈakanne, gaˈi iye matey. ");
INSERT INTO yka_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aku ne kinakan amban surgaˈin. Aku ne kinakan makaˈellumin. Bang niyaˈ mangan kinakan inin, ellum iye salama-lama. Duk kinakan pamakanku si iyehin isikun. Paglillaˈku barankun supaya kēmon manusiyaˈin ellum salama-lama,” paˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Manjari magjawab meˈ Yahudihin sabab binissā si Isa miyaˈan. Paˈinde, “Inumey pangurung aˈa inin isinen pamakanne kite?” ");
INSERT INTO yka_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Paˈin si Isa si siye, “Sabennal akahante kaˈam, bang gaˈi du kakanbi isi Anak Manusiyaˈin, hātinen isikun, duk bang gaˈi du inumbi lahaˈkun, gaˈ niyaˈ umulbi bennal. ");
INSERT INTO yka_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mamangan isikun duk manginum lahaˈkun, ellum salama-lama. Duk pakellumku iye si ellew dambuli. ");
INSERT INTO yka_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Peggeˈ isikun asal kinakan teˈedin duk lahaˈkun asal ininum teˈedin. ");
INSERT INTO yka_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sasuku mamangan isikun duk manginum lahaˈkun, teteg si aku, duk teteg ku si iye. ");
INSERT INTO yka_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Samaku Tuhanin, mamapitu akuhin, asal iye poˈon umulin duk ellum ku sababne. Damikkiyan isab aˈa mamangan akuhin ellum du sababku. ");
INSERT INTO yka_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Inin hep kinakan mapitu amban surgaˈin,” paˈin si Isa. “Kinakan inin gaˈi magsaliˈ duk kinakan takakan meˈ kapapuˈanbin, peggeˈ bisan kakande kinakan miyaˈan matey du siye. Bu kinakan amban surgaˈ inin, sasuku manganne ellum salama-lama.” ");
INSERT INTO yka_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Binissā inin weˈ si Isa sābune magtoloˈ dem langgal laˈi si Kapernaum. ");
INSERT INTO yka_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ekka meˈ tindeg si Isahin makakale panoloˈne inin duk paˈinde, “Asal makalanduˈ pamanoloˈne inin. Gaˈ niyaˈ makasandal pakale si iyan.” ");
INSERT INTO yka_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Gaˈ niyaˈ ngakahan si Isa saguwaˈ kataˈuhanne weˈ ngunub-ngunub siye sabab panoloˈne miyaˈan. Hangkan paˈinne si siye, “Laˈat ke ateybin sabab panoloˈku miyaˈan? ");
INSERT INTO yka_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na saˈingge enteˈ, bang kitebi ku, Anak Manusiyaˈin, balik pī si lahat bakas palaˈihanku matuˈuhin? ");
INSERT INTO yka_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Akahante kaˈam,” paˈin si Isa, “Niyawa Tuhanin hep makapakellum kitehin bi. Bang kabasag manusiyaˈin gaˈ niyaˈ gunane, gaˈi makapakellum manusiyaˈ. Meˈ bakas panoloˈku si kaˈamin makapakellum peggeˈ paluwas inin amban Niyawa Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Saguwaˈ niyaˈ kaˈam gaˈi kahagad si aku,” paˈin si Isa. Paˈin si Isa miyaˈan peggeˈ asal kataˈuhanne kemuwe tagnaˈ bang sine manggaˈi makahagad si iyehin duk bang sine mamuddihan iyehin. ");
INSERT INTO yka_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Duk paˈinne pe, “Iye hep inin sababnen hangkan bakas paˈinku si kaˈam weˈ gaˈ niyaˈ tumuhut si aku bang dumaˈin Samaku Tuhanin mangurung bayaˈ si iyehin.” ");
INSERT INTO yka_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sabab miyaˈan ekka meˈ tindeg si Isahin tahalaˈ amban iye duk gaˈi ne nuhut iye. ");
INSERT INTO yka_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hangkan paˈin si Isa si tindegne sampūˈ duk duwehin, “Na, kaˈam, mabayaˈ ke isab kaˈam tahalaˈ?” ");
INSERT INTO yka_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nambung si Simon Petros, paˈinne, “Tuwan, sine panuhutan kamihin bang dumaˈin kaˈu? Luwal du kaˈu makabissā meˈ bissā makapakellum salama-lamahin. ");
INSERT INTO yka_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kahagad ne teˈed kami duk kataˈuhan kami ne teˈed weˈ kaˈu masutsi mapitu amban Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Paˈin si Isa si siye, “Kaˈam ne iyan sampūˈ duk duwe meˈ tindegku tapeneˈkun. Saguwaˈ dangan kaˈam paˈasekan seyitan.” ");
INSERT INTO yka_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Bissā si Isa inin sabab si Judas, anak si Simon Iskariyotin. Peggeˈ si Judas inin dangan si meˈ tindeg si Isa sampūˈ duk duwehin duk iye mamuddihan si Isahin si pasōngan. ");
INSERT INTO yka_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Puwas inin, lumengngan si Isa si meˈ kalahatan laˈi si Jalil hadja. Gaˈi iye mabayaˈ pī si lahat Yahudiya peggeˈ batang iye papatey meˈ nakuraˈ meˈ Yahudi malaˈihin. ");
INSERT INTO yka_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Manjari tapit ne pagkādjaˈan meˈ Yahudihin patennaˈde dem meˈ payad-payadin. ");
INSERT INTO yka_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Paˈin meˈ pungtinaˈi si Isa lellahin si iye, “Hāp pe kew tahalaˈ bittuˈu. Subey kew pī si lahat Yahudiya duk isab takite meˈ tindegnun meˈ hinangnun. ");
INSERT INTO yka_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Peggeˈ bang niyaˈ aˈa mabayaˈ bantu, subey gaˈi tapukanne meˈ hinangannen. Peggeˈ iyuˈ kew maghinang meˈ hinangan makaˈulaliˈ, subey kew pakite si meˈ aˈahin kēmon.” ");
INSERT INTO yka_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bisan hep meˈ pungtinaˈinen, gaˈi kahagad si iye. ");
INSERT INTO yka_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","7","Manjari paˈin si Isa si siye, “Gaˈ pe taˈabut waktu pamakiteku dikun. Bang kaˈam, bisan waktu ine makajari peggeˈ gaˈi du kaˈam kabunsihan weˈ meˈ aˈa si dunyahin. Bu aku, kabunsihan ku weˈ de peggeˈ luwal siye paˈinanku weˈ meˈ hinanganden laˈat. ");
INSERT INTO yka_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pī kaˈam si Awrusalam si pagkādjaˈan,” paˈin si Isa si meˈ pungtinaˈinen. “Gaˈi pe ku hap pī peggeˈ gaˈ pe taˈabut waktukun.” ");
INSERT INTO yka_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ubus inin bissāne, gaˈ iye usaˈ amban lahat Jalil. ");
INSERT INTO yka_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Paglumikut ne meˈ pungtinaˈinen hap pī si pagkādjaˈan miyaˈan, gaˈ du tiggel paturul isab si Isa pī. Saguwaˈ gaˈ iye patuhut si meˈ aˈa maˈekkahin hangkan gaˈ niyaˈ ngataˈu papīnen. ");
INSERT INTO yka_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pinagpiha iye weˈ meˈ nakuraˈ Yahudihin laˈi si pagkādjaˈan. Magtilew siye bang antag iye. ");
INSERT INTO yka_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ekka meˈ aˈa magkemot-kemot sabab si Isa laˈi dem kaˈekkahan meˈ aˈahin. Paˈin sinduwehin, “Aˈa hāp si Isa.” Paˈin sinduwehin isab, “Dumaˈin, iyuˈ padupangne meˈ aˈahin.” ");
INSERT INTO yka_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Saguwaˈ gaˈ niyaˈ missā binawag sabab si Isa, peggeˈ tinalew siye si meˈ nakuraˈden. ");
INSERT INTO yka_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pagsōng nengaˈ ne pagkādjaˈanin, hap pī si Isa si langgal hadjehin duk nagnaˈ iye magtoloˈ si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ulaliˈ manamal meˈ nakuraˈ Yahudihin si panoloˈ si Isahin. Paˈinde, “Gaˈ hatiˈ aˈa inin bakas ngadjiˈ. Antag pangeddoˈanne kataˈune inin?” ");
INSERT INTO yka_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Sambungan si Isa siye, paˈinne, “Panoloˈkun dumaˈin amban di kataˈuku saguwaˈ amban Tuhan, iye mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bang aˈahin ngatu ngahinang kinabayaˈan Tuhanin, kataˈuhanne du bang panoloˈkun amban Tuhan ke atawa bang amban di pikilanku hadja. ");
INSERT INTO yka_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bang aˈahin missā amban di pikilanne, iye inapasnen kabantuhannen. Saguwaˈ bang iye inapasnen weˈ binantu mangandaˈak iyehin, na, aˈa iyan bentel duk gaˈi iye ngakkal.” ");
INSERT INTO yka_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Paˈin si Isa pe si meˈ nakuraˈ miyaˈan, “Dumaˈin ke pinangurung weˈ si Musa si kaˈam saraˈin? Saguwaˈ gaˈ du niyaˈ kaˈam nuhut saraˈin. Weˈey ku batang papateybi?” ");
INSERT INTO yka_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nambung meˈ aˈa maˈekkahin, paˈinde, “Iyuˈ kew kasayedan. Sine batang mapatey kaˈuhin?” ");
INSERT INTO yka_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nambung si Isa, paˈinne, “Mintedde du ku ngahinang hinangan makaˈulaliˈ baytu ellew liˈi, na, iye ne inin pagulaliˈanbin kēmon. ");
INSERT INTO yka_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Dinaˈak weˈ si Musa si kaˈam inislam meˈ anakbi lellahin. (Bu dumaˈin hep amban si Musa daˈakan inin saguwaˈ amban meˈ kapapuˈanbin du.) Manjari bang taˈabut ellew pagislamin, bisan tewwaˈ si ellew liˈi, inislam du weˈ bi meˈ anakbi lellahin. ");
INSERT INTO yka_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kaˈam hatiˈ, magislam kaˈam meˈ anakbin bisan baytu ellew liˈi supaya gaˈi talanggalbi saraˈ si Musahin, na weˈey kaˈam astel si aku peggeˈ makoleˈ ku aˈa si ellew liˈi? ");
INSERT INTO yka_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Daˈa ku magtawus hukumun bi bang gaˈi kaˈam kapastiˈan. Saguwaˈ bang kaˈam ngahukum, tuhutun bi hukuman mabentelin.” ");
INSERT INTO yka_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Manjari niyaˈ meˈ aˈa Awrusalam magbissā-bissā, paˈinde, “Dumaˈin ke inin aˈa batang pinapatey meˈ nakuraˈin? ");
INSERT INTO yka_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Payamanun bi,” paˈinde, “tiyaˈ iye missā patampal saguwaˈ gaˈi du iye saggaˈ meˈ nakuraˈin. Kahagad ne enteˈ siye weˈ iye ne Almasihin? ");
INSERT INTO yka_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Saguwaˈ bang Almasihin pitu,” paˈinde, “gaˈi kataˈuhan bang amban iye. Bu aˈa inin, kataˈuhante bi kēmon bang amban iye.” ");
INSERT INTO yka_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Magtoloˈ pe si Isa dem langgal hadjehin, bu pinapales weˈ ne suwalanen, paˈinne, “Weˈ kataˈuhanbi ku teˈed duk kataˈuhanbi bang amban ku? Gaˈ ku pitu amban di kabayaˈanku. Dinaˈak ku weˈ Tuhanin pitu, duk gaˈi iye magdustaˈ. Gaˈi iye kataˈuhanbi,” paˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","“Saguwaˈ aku, kataˈuhanku iye peggeˈ billaˈi ku amban iye duk iye mangandaˈak aku mapituhin.” ");
INSERT INTO yka_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Manjari batang ne iye siggewde, saguwaˈ gaˈ niyaˈ bisan makaˈantan iye, peggeˈ gaˈ pe taˈabut waktu pamapatey iyehin. ");
INSERT INTO yka_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Saguwaˈ ekka meˈ aˈa malaˈihin kahagad pu si Isa. Paˈinde, “Asal inin ne Almasihin. Peggeˈ gaˈ niyaˈ aˈa makahinang meˈ hinangan makaˈulaliˈ labi amban meˈ hininang si Isa inin.” ");
INSERT INTO yka_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pagkataˈuhan weˈ meˈ Pariseohin bang ine kinemot-kemot meˈ aˈa sabab si Isahin, magtawus siye duk meˈ nakuraˈ meˈ imamin ngandaˈak meˈ guwaldiya pī niggew si Isa. ");
INSERT INTO yka_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Manjari paˈin si Isa si meˈ aˈa mapatipun si iyehin, “Gaˈi ne ku tiggel tuˈu si kaˈam. Sōng ne ku moleˈ pī si mangandaˈak aku mapituhin. ");
INSERT INTO yka_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pihabi du ku iyan, saguwaˈ gaˈi ku takasuwaˈbi, peggeˈ gaˈi kaˈam tapi si palaˈihankun.” ");
INSERT INTO yka_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Manjari magbissā-bissā meˈ nakuraˈ Yahudihin, paˈinde, “Sōng tungan hatu aˈa inin hangkan gaˈi iye takasuwaˈte bi? Pī enteˈ iye si meˈ bangsate bi mapatennaˈ si kalahatan laˈi si lahat Girikin? Duk pī enteˈ iye noloˈan meˈ bangsa Girikin? ");
INSERT INTO yka_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Paˈinne weˈ pihate bi iye saguwaˈ gaˈi koˈ iye takasuwaˈte bi. Duk gaˈi koˈ kite bi tapī laˈi si palaˈihannen. Ine enteˈ hāti pinaˈinne inin?” ");
INSERT INTO yka_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kakapusan ellew pagkādjaˈanin, iye ellew asal mahadjehin, nengge si Isa diyalem langgal hadjehin duk missā iye pinapales, paˈinne, “Sine-sine kaˈam lekkakan, pitu kaˈam si aku duk paˈinumte kaˈam. ");
INSERT INTO yka_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Peggeˈ tasulat dem kitab sabab aˈa makahagad si akuhin; paˈin kitabin, ‘Niyaˈ nubud kuweˈ dalil meˈ boheˈ amban dem ateyne, boheˈ makapakellum.’” ");
INSERT INTO yka_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Boheˈ manubud pinaˈin si Isa inin, hātinen Niyawa Tuhanin sōng pinangurung ne si meˈ makahagad si iyehin. Saguwaˈ masa miyaˈan gaˈ pe tapangurung Niyawa Tuhanin, peggeˈ gaˈ pe taˈabut waktu pamahadje si Isa weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pagkale meˈ aˈahin meˈ bissā si Isa inin, paˈin meˈ sinduwehin, “Asal aˈa inin ne nabi inagad-agadten bi.” ");
INSERT INTO yka_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Paˈin meˈ sinduwehin isab, “Inin ne Almasihin.” Saguwaˈ niyaˈ sinduwe magpaˈin, “Dumaˈin iye Almasihin. Peggeˈ Almasihin dumaˈin amban lahat Jalil. ");
INSERT INTO yka_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Paˈin kitabin hep weˈ Almasihin tubuˈ Sultan Daˈud duk subey iye inanakan si kalurnaˈan Betlehem peggeˈ iye miyaˈan lahat si Sultan Daˈudin.” ");
INSERT INTO yka_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hangkan magseddili-seddili tapikil meˈ aˈahin sabab si Isa. ");
INSERT INTO yka_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Niyaˈ siye mabayaˈ niggew iye saguwaˈ gaˈ niyaˈ bisan makaˈantan iye. ");
INSERT INTO yka_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Manjari balik ne meˈ guwaldiyahin. Tinilew siye weˈ meˈ Pariseohin duk meˈ nakuraˈ meˈ imamin, paˈinde, “Weˈey iye gaˈ boˈobi pitu?” ");
INSERT INTO yka_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nambung meˈ guwaldiyahin, paˈinde, “Gaˈ teˈed niyaˈ aˈa bakas magtoloˈ kuweˈ panoloˈ aˈa miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sambungan meˈ Pariseohin siye, paˈinde, “Sampay kaˈam tapadupang du isab weˈ ne? ");
INSERT INTO yka_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kami meˈ Pariseohin, gaˈ niyaˈ bisan dangan kami kahagad si iye. Duk meˈ nakuraˈ Yahudihin damikkiyan du isab. ");
INSERT INTO yka_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Iye du makahagad si iyehin meˈ aˈa maˈekka īˈen peggeˈ awam siye bang ine pinaˈin dem saraˈ si Musahin. Hangkan kamulkaˈan siye weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dangan meˈ Pariseo malaˈihin si Nikodemus. Iye hep miyaˈan bakas mapī magbissā duk si Isa sangem īˈen. Paˈinne si meˈ saweˈnen, ");
INSERT INTO yka_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Paˈin saraˈten weˈ gaˈi aˈahin makajari laboˈante hukuman bang gaˈi dahuˈ iye pinakale supaya kataˈuhan bang ine bakas tahinangnen.” ");
INSERT INTO yka_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nambung siye, paˈinde, “Weˈ amban Jalil kew isab? Payamanun dem kitab, gaˈ tasulat dem kitab weˈ niyaˈ nabi paguwaˈ amban lahat Jalil.” ");
INSERT INTO yka_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Manjari kaniya-kaniya ne siye moleˈ. ");
INSERT INTO yka_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Saguwaˈ si Isa hap pī pataked si kūd Jaitun. ");
INSERT INTO yka_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Subu-subu pe pagsasumuhin, pī iye balik si langgal hadjehin. Banes aˈa patipun pī si iye ubus ningkoloˈ iye magtoloˈ si siye. ");
INSERT INTO yka_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Manjari niyaˈ dambuwaˈ dende binoˈo weˈ meˈ Pariseohin duk meˈ guru si saraˈ āgamahin pī pu si Isa. Dende inin bakas tasaˈut magjina. Pinaharap iye weˈ de si meˈ aˈa maˈekkahin. ");
INSERT INTO yka_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Paˈinde pu si Isa, “Tuwan, dende inin bakas tasaˈut magjina. ");
INSERT INTO yka_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na, bang dem saraˈ si Musa inambananne si kitehin bi, hukuman si meˈ dende kuweˈ inin, subey siye tinumbuk duk batu sampay matey. Na, bang kaˈu, ine paˈinnu?” ");
INSERT INTO yka_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bissāde inin panguhi-nguhide si Isa kaw salaˈ panambungnen, manjari niyaˈ jān panuntutande iye. Saguwaˈ patondok si Isa duk nulat iye duk timbōˈne diyataˈ bulak. ");
INSERT INTO yka_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pagtinilew ne isab iye weˈ de, patongas iye duk paˈinne si siye, “Sine-sine kaˈam gaˈ niyaˈ dusene, ambat iye dehellu numbuk dende inin duk batu.” ");
INSERT INTO yka_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Manjari patondok iye balik duk nulat ne isab iye duk timbōˈne diyataˈ bulak. ");
INSERT INTO yka_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pagkalede pinaˈin si Isa inin, tahalaˈ siye dangan-dangan tinagnaˈan amban mabahiˈin, duk taˈamban si Isa duk dendehin laˈi si panenggehannen. ");
INSERT INTO yka_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pagtongas si Isa balik, paˈinne si dendehin, “Dende, antag ne siye? Gaˈ ke niyaˈ bisan dangan taˈamban numbuk kaˈu duk batu?” ");
INSERT INTO yka_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Gaˈ niyaˈ, Tuwan,” iye helling dendehin. Paˈin si Isa, “Bisan aku gaˈi du kew laboˈanku hukuman pinapatey. Hap lumaˈ ne kew saguwaˈ daˈa ne kew magduse balik.” ");
INSERT INTO yka_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Puwas miyaˈan, missā si Isa balik si meˈ Pariseohin. Paˈinne, “Aku inin dantaˈ mangurung dantaˈ dem pikilan manusiyaˈin. Sine-sine nuhut aku, salama-lama gaˈi ne teˈed iye lumengngan dem lindem, peggeˈ laˈi dem pikilanne dantaˈ makapakellum manusiyaˈin.” ");
INSERT INTO yka_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Paˈin meˈ Pariseohin pu si Isa, “Naksiˈan kew di nu. Bang aˈahin naksiˈan dine, gaˈ niyaˈ kahagad si iye.” ");
INSERT INTO yka_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nambung si Isa, paˈinne, “Bisan ku naksiˈan diku, toˈo panaksiˈkun peggeˈ kataˈuhanku bang amban ku duk bang tungan ku. Saguwaˈ kaˈam, gaˈi kataˈuhanbi bang amban ku duk bang tungan ku. ");
INSERT INTO yka_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kaˈam, bang kaˈam ngahukum aˈa, iye tinuhutbin pikilan manusiyaˈ hadja. Aku,” paˈin si Isa, “gaˈi ku ngahukum aˈa. ");
INSERT INTO yka_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Saguwaˈ bang saˈupama aku mangahukumin, bentel hukumankun peggeˈ dumaˈin aku dendangan mangahukumin saguwaˈ duwangan kami duk Samakun, Samaku mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tasulat dem saraˈbi,” paˈin Si Isa, “bang duwe aˈa saliˈ panaksiˈden, toˈo pinaˈinden. ");
INSERT INTO yka_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na, bennal bissākun. Niyaˈ duwe saksiˈku. Aku naksiˈan dikun duk Samaku mamapitu akuhin naksiˈan aku du isab.” ");
INSERT INTO yka_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tinilew si Isa weˈ meˈ Pariseohin, paˈinde, “Antag samanun?” Nambung si Isa, paˈinne, “Gaˈi kataˈuhanbi Samakun, duk aku, gaˈi du ku isab kataˈuhanbi. Peggeˈ bang ku miyaˈan kataˈuhanbi, kataˈuhanbi du isab Samakun.” ");
INSERT INTO yka_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Binissā inin weˈ si Isa sasangne magtoloˈ dem langgal hadjehin, laˈi si antag pamettadan meˈ kahun pangalaboˈ-laboˈande pariyahin. Saguwaˈ gaˈ niyaˈ niggew iye peggeˈ gaˈ pe taˈabut gantaˈnen. ");
INSERT INTO yka_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Manjari binalik weˈ si Isa bakas pinaˈinne si meˈ aˈahin, paˈinne, “Sōng tahalaˈ ne ku. Pihabi du ku iyan saguwaˈ gaˈi ku takasuwaˈbi. Matey hadja kaˈam moˈo dusebin. Gaˈi kaˈam tapī si papihankun.” ");
INSERT INTO yka_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hangkan magtilew-tinilew meˈ nakuraˈ Yahudihin, paˈinde, “Ine hāti binissāne miyaˈan weˈ gaˈi koˈ kite tapī si papīhannen? Papateyne enteˈ dinen?” ");
INSERT INTO yka_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Paˈin si Isa pe, “Kaˈam iyan aˈa dunya du, bu aku inin surgaˈ lahatkun. Kēmon pikilanbin amban dunya hadja, bu pikilankun dumaˈin. ");
INSERT INTO yka_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hangkan hep kaˈam akahanku weˈ matey du kaˈam moˈo dusebin. Peggeˈ bang gaˈi kahagadbi pinaˈinku sabab dikun, asal matey kaˈam moˈo dusebin.” ");
INSERT INTO yka_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Sine teˈ kew teˈed?” paˈinde. Paˈin si Isa, “Bakas akahante ne kaˈam kemuwe tagnaˈ. ");
INSERT INTO yka_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ekka pe makajari paˈinku sabab addatbin,” paˈin si Isa. “Duk ekka pe dusebi laboˈanku hukuman. Saguwaˈ iye hadja inakaku tuˈu si dunya inin, meˈ bakas inaka si aku weˈ mamapitu akuhin. Duk kēmon inakanen bennal,” paˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Saguwaˈ gaˈ tahātide weˈ binissā si Isa miyaˈan sabab Tuhanin, Samanen. ");
INSERT INTO yka_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hangkan paˈin si Isa si siye, “Bang ne bakas dangkatbi Anak Manusiyaˈin diyataˈ olom, meke ne kataˈuhanbi weˈ aku ne iye pinaˈinkun. Duk kataˈuhanbi du isab iyan weˈ gaˈ niyaˈ hinangku bang baran-baranku hadja duk kēmon panoloˈkun, iye hadja pangandaˈakan Samaku akuhin. ");
INSERT INTO yka_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tattap tuˈu si aku mamapitu akuhin. Gaˈi ku pasagadanne peggeˈ luwal hinangku kinabayaˈannen.” ");
INSERT INTO yka_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pagkalede pinaˈin si Isa miyaˈan, ekka meˈ aˈahin sandel si iye. ");
INSERT INTO yka_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Manjari missā si Isa si meˈ Yahudi mapadūs si bissānen, paˈinne, “Bang kaˈam matuyuˈ nuhut panoloˈku si kaˈamin, bennal kaˈam tindegku. ");
INSERT INTO yka_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Duk kataˈuhanbi du iyan bang ine mabennal amban Tuhanin. Duk mabennal inin iye mamaluwas kaˈamin amban pamanyagaˈan kaˈamin.” ");
INSERT INTO yka_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nambung siye paˈinde, “Oy, kami inin meˈ tubuˈ Ibrahim. Gaˈ kami bakas tabanyagaˈ weˈ sine-sine. Weˈey kew magpaˈin weˈ lumuwas du kami amban pamanyagaˈan kamihin?” ");
INSERT INTO yka_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sambungan si Isa siye, paˈinne, “Akahante kaˈam matoˈohin, sasuku magduse, binanyagaˈ siye weˈ napsude magdusehin. ");
INSERT INTO yka_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Banyagaˈ aˈahin gaˈi teteg si aˈahin. Iye mateteg si iyehin anaknen. ");
INSERT INTO yka_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hangkan bang Anak Tuhanin mamaluwas kaˈamin, bugtuˈ teˈed kaˈam lumuwas. ");
INSERT INTO yka_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kataˈuhanku weˈ kaˈam iyan meˈ tubuˈ Ibrahim. Saguwaˈ batang ku papateybi peggeˈ gaˈi tatayimaˈbi panoloˈkun. ");
INSERT INTO yka_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Meˈ panoloˈku si kaˈam inin takaleku amban Samakun saguwaˈ kaˈam, hininang weˈ bi meˈ takalebi amban samabin.” ");
INSERT INTO yka_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Paˈin meˈ Yahudihin, “Sama kamihin Ibrahim.” Paˈin si Isa, “Bang kaˈam bennal meˈ tubuˈ Ibrahim, neppu siˈ kaˈam Ibrahim si meˈ hinangannen. ");
INSERT INTO yka_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Saguwaˈ kaˈam iyan, batang ku papateybi sewukat ne kaˈam bakas akahanku mabennal takaleku amban Tuhanin. Gaˈ Ibrahim bakas maghinangan kuweˈ iyan. ");
INSERT INTO yka_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Meˈ hinanganbin saliˈ duk hinangan samabin.” Magtawus meˈ aˈa miyaˈan nambung, paˈinde, “Oy, dambuwaˈ-buwaˈ du sama kamihin, Tuhanin. Duk kami inin bennal meˈ anakne.” ");
INSERT INTO yka_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Paˈin si Isa si siye, “Bang bennal Tuhanin samabin, kalasahanbi siˈ ku peggeˈ aku amban Tuhanin hangkan ne ku tuˈu. Gaˈ ku pitu amban bayaˈku saguwaˈ pinapitu ku weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Weˈey teˈ gaˈi tahātibi binissākun? Hangkan gaˈi tahātibi peggeˈ gaˈi tasandalbi makale binissākun.” ");
INSERT INTO yka_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Paˈin si Isa pe si meˈ aˈa miyaˈan, “Kaˈam, samabin nakuraˈ seyitanin duk iye kabayaˈanbi tinuhutin meˈ kinabayaˈan samabin. Kemuwe amban tagnaˈ asal be-papatey iye. Gaˈ iye bakas nuhut mabennalin peggeˈ gaˈ niyaˈ bennal laˈi si iye. Iye bahannen, magdustaˈ peggeˈ inin addatnen. Dustaˈan teˈed iye duk iye poˈon dustaˈin kēmon. ");
INSERT INTO yka_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Saguwaˈ aku, bennal hadja meˈ bissākun hangkan gaˈi ku kahagadbi. ");
INSERT INTO yka_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Gaˈ niyaˈ kaˈam makapagpaˈin weˈ dusehan ku; kēmon binissākun bennal. Weˈey pe ku gaˈi kahagadbi? ");
INSERT INTO yka_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bang aˈahin sukuˈ si Tuhan, pakalene toloˈ Tuhanin. Saguwaˈ kaˈam dumaˈin kaˈam sukuˈ si Tuhan, hangkan hep gaˈi kaˈam mabayaˈ pakale.” ");
INSERT INTO yka_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sinambungan si Isa weˈ meˈ Yahudihin, paˈinde, “Tewwaˈ teˈed pinaˈin kamihin weˈ dumaˈin kew iyan bennal aˈa Israˈil. Aˈa Samariya kew duk pasayedan seyitan kew.” ");
INSERT INTO yka_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Gaˈ ku ituˈ pasayedan seyitan,” paˈin si Isa. “Pinahadje weˈ ku Samakun saguwaˈ bissā-bissāhanbi ku. ");
INSERT INTO yka_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Dumaˈin inapaskun weˈ pinahadje ku. Niyaˈ seddili makapikilne mahadje aku duk iye mangahukumin. ");
INSERT INTO yka_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sabennal akahante kaˈam,” paˈin si Isa, “sine-sine nuhut panoloˈkun, gaˈi teˈed matey salama-lama.” ");
INSERT INTO yka_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Paˈinde si iye, “Na, kabugtuˈan kami ne teˈed weˈ pasayedan seyitan kew. Bisan Apuˈ Ibrahim duk meˈ kanabihanin kēmon matey du. Hatiˈ paˈinnu weˈ gaˈi teˈed matey salama-lama sasuku manuhut panoloˈnun. ");
INSERT INTO yka_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Weˈey, balakatan pe kew amban papuˈ kamihin, Ibrahim? Bisan meˈ kanabi-nabihanin kēmon duk bisan Apuˈ Ibrahim matey du. Weˈ sine teˈ kew?” ");
INSERT INTO yka_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nambung si Isa, paˈinne, “Bang saˈupama pahadjeku dikun, gaˈ niyaˈ kagunahan pamahadjeku miyaˈan. Iye mahadje akuhin Samakun, iye ne pinaˈinbi Tuhanbin. ");
INSERT INTO yka_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gaˈi bisan kataˈuhanbi Tuhanin. Saguwaˈ aku, kataˈuhanku iye. Bang saˈupama paˈinku weˈ gaˈi Tuhanin kataˈuhanku, na kuweˈ ne ku kaˈamin dustaˈan. Saguwaˈ asal kataˈuhanku teˈed Tuhanin duk tuhutku teˈed kēmon pangandaˈakannen. ");
INSERT INTO yka_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Papuˈbin Ibrahim magkēg peggeˈ kataˈuhanne niyaˈ waktu si pasōngan, kitene du ku pitu si dunya. Manjari pagkitene papitukun kēgan iye.” ");
INSERT INTO yka_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nambung siye, paˈinde, “Saˈingge pagkitebi duk Ibrahimin? Gaˈ pe hatiˈ bisan limempūˈ tahun umulnun.” ");
INSERT INTO yka_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Paˈin si Isa si siye, “Akahante kaˈam matoˈohin, gaˈ pe Ibrahim inanakan, andang ne ku.” ");
INSERT INTO yka_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Manjari meˈ Yahudi miyaˈan nimuk batu panibagde si Isa. Saguwaˈ paˈellig si Isa duk paluwas iye amban dem langgal hadjehin. ");
INSERT INTO yka_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sasang si Isa lumengngan, ngite iye dambuwaˈ aˈa pessek amban dem betteng. ");
INSERT INTO yka_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tinilew si Isa weˈ meˈ tindegnen, paˈinde, “Tuwan, weˈey teˈ aˈa inin pessek amban dem betteng? Sabab dusene ke atawa sabab duse saˈi-samanen?” ");
INSERT INTO yka_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nambung si Isa, paˈinne, “Dumaˈin sabab dusene atawa duse saˈi-samanen hangkan iye pessek. Saguwaˈ pessek iye supaya tapakitehan Tuhanin balakatnen bang ngite ne aˈa inin. ");
INSERT INTO yka_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pādpād ellew pe subey hinangte meˈ hinang Tuhanin, Tuhan mamapitu akuhin,” paˈin si Isa. “Pagtaˈabut ne sangem gaˈ ne niyaˈ kapaghinang. ");
INSERT INTO yka_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tiggelanku tuˈu si dunya, aku mangurung dantaˈ si pikilan manusiyaˈin.” ");
INSERT INTO yka_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pagubus inin bissā si Isa, ngaluraˈ iye diyataˈ bulak duk pinaglagumey weˈ ne luraˈnen duk bulakin hinang pisak. Ubus bu pinasusut weˈ ne pisakin pī si mata aˈahin. ");
INSERT INTO yka_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ubus paˈinne si aˈahin, “Pī kew ngulaˈup si boheˈ Siluwam.” Hāti Siluwamin - pinaboˈohan. Manjari pī ne aˈa pessekin ngulaˈup. Pagbalikne ngite ne iye. ");
INSERT INTO yka_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Takite iye weˈ meˈ saweˈne magtapit lumaˈin duk meˈ aˈa bakas mangite iye magpāku-pāku sīnin. Paˈinde, “Dumaˈin ke inin aˈa bakas maningkoloˈ magpāku-pāku sīnin?” ");
INSERT INTO yka_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Paˈin meˈ sinduwehin, “Aweˈ, iye ne.” Paˈin meˈ sinduwehin isab, “Dumaˈin iye. Kuweˈ bantuknen hadja.” Saguwaˈ nambung ne aˈahin, paˈinne, “Aku ne inin aˈa bakas mapessekin.” ");
INSERT INTO yka_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Saˈingge pangitenun?” paˈinde. ");
INSERT INTO yka_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nambung iye, paˈinne, “Niyaˈ aˈa inēnan si Isa ngahinang pisak bu pinasusut weˈ ne pī si mataku. Ubus daˈakne ku pī si boheˈ Siluwam ngulaˈup. Na, hap pī ne ku ngulaˈup. Pagubus ku hadja ngulaˈup, magtawus ne ku ngite.” ");
INSERT INTO yka_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Antag ne aˈa miyaˈan,” paˈinde. Nambung iye, paˈinne, “Inday, gaˈi kataˈuhanku.” ");
INSERT INTO yka_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Manjari binoˈo weˈ meˈ aˈahin aˈa bakas mapessekin pī si meˈ Pariseohin. ");
INSERT INTO yka_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ellew pangahinang si Isa pisakin duk pamakawuliˈne aˈa pessekin, ellew Sabtuˈ, ellew liˈi. ");
INSERT INTO yka_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tinilew isab aˈa bakas mapessekin weˈ meˈ Pariseohin, bang saˈingge pangitenen. Paˈinne si siye, “Binettadan weˈ si Isa pisak meˈ matakun. Ubus ngulaˈup ku. Pagubus ku ngulaˈup, magtawus ne ku ngite.” ");
INSERT INTO yka_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Paˈin meˈ Pariseo sinduwehin, “Aˈa miyaˈan dumaˈin amban Tuhan peggeˈ hininangne miyaˈan ngalanggalan saraˈ pasal ellew liˈihin.” Saguwaˈ paˈin meˈ sinduwehin, “Bang aˈahin dusehan, gaˈi tahinangne meˈ hinangan makaˈulaliˈ kuweˈ tahinangne miyaˈan.” Manjari magseddili-seddili pikilanden. ");
INSERT INTO yka_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Manjari tinilew ne isab balik aˈahin weˈ meˈ Pariseohin, paˈinde, “Paˈinnu weˈ kawuliˈan matanun weˈ aˈa miyaˈan. Na, bang kaˈu, sine iye?” Paˈin aˈa bakas mapessekin, “Bang aku, dambuwaˈ iye nabi.” ");
INSERT INTO yka_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Saguwaˈ meˈ nakuraˈ Yahudi miyaˈan gaˈi kahagad weˈ aˈa inin asal bakas pessek bu ngite ne, hangkan ilinganan weˈ de saˈi-samanen duk tinilewan weˈ de. ");
INSERT INTO yka_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Paˈin meˈ nakuraˈ miyaˈan si siye, “Anakbi ke aˈa inin? Toˈo ke weˈ pessek koˈ iye amban dem betteng? Weˈey managhāˈ ngite ne iye kuweˈitu?” ");
INSERT INTO yka_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nambung meˈ matettoˈanen, paˈinde, “Aweˈ, anak kami inin. Toˈo pessek iye amban dem betteng. ");
INSERT INTO yka_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Saguwaˈ gaˈi kataˈuhan kami bang saˈingge pangitene kuweˈituhin atawa bang sine makakawuliˈ matanen. Tilewun bi iye. Dumaˈin ne du iye nakanak. Ambat iye ne nambungan kaˈam.” ");
INSERT INTO yka_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kuweˈ miyaˈan panambung meˈ matettoˈanen peggeˈ tinalew siye si meˈ nakuraˈden. Peggeˈ bakas magisun ne meˈ nakuraˈin weˈ bang niyaˈ magpaˈin weˈ kahagad iye si Isa ne Almasihin, gaˈi aˈa miyaˈan pinaˈasek dem langgal. ");
INSERT INTO yka_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hangkan hep paˈin meˈ matettoˈanen, “Tilewun bi iye. Dumaˈin ne du iye nakanak.” ");
INSERT INTO yka_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Manjari ilinganan ne isab balik weˈ meˈ nakuraˈ Yahudihin aˈa bakas mapessekin duk paˈinde si iye, “Akahun matoˈohin. Iyuˈ Tuhanin pakale-kale. Kataˈuhan kami weˈ aˈa magpakawuliˈ si kaˈu miyaˈan dusehan.” ");
INSERT INTO yka_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nambung aˈahin, paˈinne, “Gaˈi kataˈuhanku bang dusehan ke aˈa miyaˈan atawa gaˈi. Iye hadja kataˈuhankun, weˈ tagnaˈ pessek ku saguwaˈ kuweˈitu ngite ne ku.” ");
INSERT INTO yka_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tilewde iye balik, “Inumeyne si kaˈuhin hangkan kew ngite?” ");
INSERT INTO yka_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Sambunganne siye, paˈinne, “Bakas ne kaˈam akahanku bu gaˈ du pakalebi. Weˈey pe batang takalebi balik? Hatu mabayaˈ isab kaˈam patindeg si iye.” ");
INSERT INTO yka_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Binissā-bissāhan iye weˈ meˈ nakuraˈ miyaˈan, paˈinde, “Kaˈu tindegnen. Kami inin tindeg si Musa. ");
INSERT INTO yka_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kataˈuhan kami weˈ Tuhanin missā pu si Musa saguwaˈ bang aˈa miyaˈan, gaˈi bisan kataˈuhan kami bang amban iye.” ");
INSERT INTO yka_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nambung aˈa bakas mapessekin, paˈinne, “Ulaliˈ ku si kaˈam. Gaˈi kataˈuhanbi bang amban iye bu iye makapakite akuhin. ");
INSERT INTO yka_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kataˈuhante bi weˈ gaˈi pakale Tuhanin aˈa dusehanin. Iye pinakale Tuhanin magmātabat si iyehin duk maghinang meˈ kinabayaˈannen. ");
INSERT INTO yka_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kemuwe tagnaˈ dunyahin, gaˈ bakas takale weˈ niyaˈ makapakite aˈa pessek amban dem betteng. ");
INSERT INTO yka_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bang aˈa miyaˈan dumaˈin amban Tuhan, bugtuˈ gaˈi iye kapaghinang meˈ hinangan kuweˈ inin.” ");
INSERT INTO yka_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jinampa iye weˈ de, paˈinde, “Weˈey? Toloˈannu pe kami? Bu kaˈu iyan, amban dem betteng pe, andang ne kew taga duse.” Manjari pinaluwas iye weˈ meˈ nakuraˈ miyaˈan amban dem langgal. ");
INSERT INTO yka_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pagkale si Isa weˈ pinaluwas weˈ meˈ nakuraˈin aˈa bakas mapessekin, magtawus si Isa pī si iye. Pagtakasuwaˈne, paˈinne si aˈahin, “Kahagad ke kew si aˈa inēnan Anak Manusiyaˈin?” ");
INSERT INTO yka_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nambung aˈahin, paˈinne, “Sine teˈ iye, Tuwan? Akahanun ku duk ku kahagad si iye.” ");
INSERT INTO yka_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Paˈin si Isa si iye, “Takitenu ne iye. Duk iye ne mamissā si kaˈu inin.” ");
INSERT INTO yka_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Magtawus aˈahin pasujud pu si Isa duk paˈinne, “O Tuwan, kahagad ku si kaˈu.” ");
INSERT INTO yka_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Paˈin si Isa, “Hangkan ku pitu si dunya, supaya pinagsapeˈ meˈ aˈahin. Meˈ aˈa dalil mapessekin, peggeˈ gaˈi kataˈuhande mabennal sabab Tuhanin, ngite du. Duk meˈ aˈa magpaˈinin weˈ ngite siye, peggeˈ kannalde kataˈuhande mabennal sabab Tuhanin, ngapessek du.” ");
INSERT INTO yka_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Takale pinaˈin si Isa inin weˈ meˈ Pariseo sinduwe malaˈihin duk paˈinde si iye, “Ine pinaˈinnu miyaˈan? Weˈ pessek isab kami? Ngite kami inin.” ");
INSERT INTO yka_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Paˈin si Isa si siye, “Bang kaˈam pessek, hātinen gaˈ teˈed kataˈuhanbi mabennalin, gaˈ ne niyaˈ dusebi. Saguwaˈ peggeˈ paˈinbi ngite du kaˈam, hātinen kataˈuhanbi du mabennalin, taga duse pe kaˈam, peggeˈ gaˈi tuhutbi mabennalin.” ");
INSERT INTO yka_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Manjari magdalilan si Isa, paˈinne, “Sabennal akahante kaˈam, bang aˈahin padiyalem dem kural meˈ bili-bilihin bu gaˈi palabey amban gawang saguwaˈ padiyalem amban lān seddili, aˈa miyaˈan panangkew duk ngalangpas. ");
INSERT INTO yka_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Aˈa mapadiyalem amban gawangin, iye mangipat bili-bilihin. ");
INSERT INTO yka_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Duk ilukahan iye weˈ tatungguˈ gawangin. Pakale meˈ bili-bilihin suwalanen paglingananne ēn meˈ bili-bilinen dambuwaˈ-dambuwaˈ, duk boˈone siye paluwas amban dem kural. ");
INSERT INTO yka_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Paglumuwas ne siye, padehellu iye duk patuhut meˈ bili-bilihin amban dambulihanne peggeˈ takilalede suwalanen. ");
INSERT INTO yka_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bang seddili aˈa, gaˈi tuhut meˈ bili-bili inin saguwaˈ lahi siye amban iye peggeˈ gaˈi takilalede suwalanen.” ");
INSERT INTO yka_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Dalilan inin inaka weˈ si Isa si meˈ aˈahin saguwaˈ gaˈi tasabutde hātinen. ");
INSERT INTO yka_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hangkan missā si Isa si siye balik, paˈinne, “Sabennal akahante kaˈam, aku inin dalil gawang palabeyan bili-bilihin. ");
INSERT INTO yka_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Meˈ aˈa mapitu dehellu amban akuhin, meˈ magtoloˈ manggaˈi matoˈohin, kuweˈ meˈ aˈa panangkew siye duk meˈ aˈa ngalangpas. Saguwaˈ gaˈ siye pinakale weˈ meˈ aˈa sukuˈ si akuhin. ");
INSERT INTO yka_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aku dalil gawangin,” paˈin si Isa. “Sine-sine padiyalem amban aku, timbul iye. Luhaya iye padiyalem-pabukut duk inurungan iye kahāpan. ");
INSERT INTO yka_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Aˈa ngalangpasin, gaˈ niyaˈ akane pitu bang dumaˈin nangkew, duk mapatey, duk makaˈat. Saguwaˈ aku, akaku mapituhin ngurungan meˈ manusiyaˈin umul, maglabi-labi hāpnen. ");
INSERT INTO yka_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aku inin,” paˈin si Isa, “dalil pastul bili-bili hāp pagipatne meˈ bili-bilinen. Pastul bili-bili mahāpin maglillaˈ matey para si meˈ bili-bilinen. ");
INSERT INTO yka_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Aˈa tinangdanan magbantey meˈ bili-bilihin, dumaˈin iye pastulin duk dumaˈin iye dapuˈ meˈ bili-bilihin. Hangkan bang niyaˈ takitene hayep talun hap pī si meˈ bili-bilihin, lahi iye duk ambananne meˈ bili-bilihin. Manjari siggew hayep talunin meˈ bili-bilihin duk kanat-kanatne siye. ");
INSERT INTO yka_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Hangkan iye lahi peggeˈ tinangdanan hadja iye. Gaˈ niyaˈ lasane si meˈ bili-bilihin. ");
INSERT INTO yka_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Aku inin,” paˈin si Isa, “dalil pastul bili-bili, hāp pagipatne meˈ bili-bilinen. Magkinataˈu teˈed kami duk Samakun. Damikkiyan isab, kataˈuhanku meˈ aˈa sukuˈ si akuhin duk kataˈuhande ku isab. Maglillaˈ ku matey para si meˈ aˈa sukuˈ si akuhin. ");
INSERT INTO yka_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Niyaˈ pe meˈ sukuˈku seddili amban meˈ sukuˈku inin, saguwaˈ gaˈ siye tuˈu si pagipatanku inin. Subey isab siye boˈoku. Pakalede du iyan bissākun. Pagdambuwaˈku siye manjari dambuwaˈ hadja pastulden. ");
INSERT INTO yka_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kinalasahan ku teˈed weˈ Samaku Tuhanin peggeˈ maglillaˈ ku matey supaya ku pinakellum balik. ");
INSERT INTO yka_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Gaˈ niyaˈ manusiyaˈ taga kapatut mapatey aku, peggeˈ makapagbayaˈ ku bang matey ku atawa gaˈi. Paglillaˈku umulkun amban kabayaˈanku. Taga kapatut ku maglillaˈ umulkun, duk taga kapatut ku makellum barankun balik. Inin pangandaˈakan Samaku Tuhanin si aku.” ");
INSERT INTO yka_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Pagkale meˈ aˈahin meˈ bissā si Isa inin, magseddili-seddili tapikil ne isab siye balik. ");
INSERT INTO yka_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ekka siye magpaˈin, “Pasayedan seyitan iyan, duk binalew. Weˈey kaˈam pakale si iye?” ");
INSERT INTO yka_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Saguwaˈ paˈin meˈ sinduwehin isab, “Bang aˈa pasayedan seyitan, gaˈi iye makabissā kuweˈ binissāne miyaˈan. Duk bang seyitan, gaˈi tapangitene aˈa pessekin.” ");
INSERT INTO yka_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Manjari taˈabut ne waktu pagkādjaˈan ēnande ‘Pagsutsi langgal hadjehin’ laˈi si Awrusalam. Tempo haggut masa miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Si Isa lumengngan-lengngan dem langgal laˈi si ēnande Simpey Sulaiman. ");
INSERT INTO yka_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Manjari patipun pī si iye meˈ aˈahin duk paˈinde si iye, “Sampay sumiyan pe kami paˈagadnu meke kami akahannu bang sine kew? Bang asal bennal kaˈu Almasihin, tapeneˈ Tuhan magsultan si kamihin, akahanun kami papastiˈ.” ");
INSERT INTO yka_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sambungan si Isa siye, paˈinne, “Bakas ne kaˈam akahanku saguwaˈ gaˈi du ku kahagadbi. Meˈ hinangan bakas hininangku amban kapatut Samakun, kuweˈ ngakahan kaˈam ne bang sine ku. ");
INSERT INTO yka_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Saguwaˈ gaˈi ku kahagadbi peggeˈ dumaˈin kaˈam sukuˈ si aku. ");
INSERT INTO yka_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Meˈ aˈa sukuˈ si akuhin, meˈ dalil bili-bilikun, pakalede suwalakun. Kataˈuhanku siye duk nuhut siye aku. ");
INSERT INTO yka_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Urunganku siye umul gaˈ tamananne. Gaˈi teˈed siye pinasapeˈ amban Tuhan salama-lama. Duk gaˈ teˈed niyaˈ makaˈagew siye amban aku. ");
INSERT INTO yka_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Pinasukuˈ siye weˈ Samakun si aku. Samakun balakatan amban kēmon. Gaˈ niyaˈ makaˈagew meˈ aˈa sukuˈ si akuhin amban iye. ");
INSERT INTO yka_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Samakun duk aku dambuwaˈ du.” ");
INSERT INTO yka_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pagkale meˈ aˈahin binissā si Isa miyaˈan, nimuk ne isab siye batu panibagde si Isa. ");
INSERT INTO yka_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Paˈin si Isa si siye, “Ekka meˈ hinangan hāp tapakitehanku si kaˈam. Meˈ hinangku miyaˈan pinahinang weˈ Tuhanin si aku. Inggehin meˈ hinangku miyaˈan kabunsihanbi hangkan ku batang tibagbi?” ");
INSERT INTO yka_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nambung meˈ aˈahin, paˈinde, “Dumaˈin sabab hinangannu hāp hangkan kew batang tibag kami, saguwaˈ sabab pamissānu kupul si Tuhanin. Manusiyaˈ kew hadja bu paˈinnu Tuhan kew.” ");
INSERT INTO yka_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Paˈin si Isa si siye, “Tasulat bisan dem kitabbi pinaˈin Tuhan si meˈ aˈa mangahukumin masaley. Paˈin Tuhanin si siye, ‘Kaˈam iyan meˈ tuhan.’ ");
INSERT INTO yka_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na, kataˈuhante bi weˈ kēmon tasulat dem kitabin gaˈi teˈed pinda salama-lama. Na, bang meˈ pangurungan Tuhan lapalnen inēnan weˈ ne meˈ tuhan, ");
INSERT INTO yka_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","pasōng ne aku asal talep inēnan Anak Tuhan. Peggeˈ aku inin, tapeneˈ weˈ Tuhanin duk pinapitu ku weˈ ne si dunya. Na, weˈey paˈinbi weˈ bissāhanku Tuhanin kupul peggeˈ magpaˈin ku weˈ Anak Tuhanin ku? ");
INSERT INTO yka_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bang saˈupama meˈ hinangkun gaˈi magsaliˈ duk meˈ hinang Samakun, na, daˈa ku kahagadun bi. ");
INSERT INTO yka_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Saguwaˈ bang magsaliˈ du, bisan ne gaˈi kahagadbi meˈ bissākun basta kahagadbi hadja meˈ hinangkun, ujud kataˈuhanbi du duk tahātibi du teˈed weˈ Samakun duk aku dambuwaˈ du.” ");
INSERT INTO yka_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ubus mabayaˈ ne isab siye niggew si Isa sabab bissāhannen saguwaˈ lumahi iye. ");
INSERT INTO yka_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Manjari pī si Isa balik si dambiyaˈ boheˈ Jordan, laˈi si lugal bakas pagpandihan Yahiya meˈ aˈahin. Patennaˈ iye laˈi bang piyem bahangi. ");
INSERT INTO yka_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ekka meˈ aˈa pī si iye. Magbissā-bissā meˈ aˈahin, paˈinde, “Gaˈ niyaˈ tahinang Yahiya meˈ hinangan makaˈulaliˈ, saguwaˈ kēmon inakane sabab si Isahin bennal.” ");
INSERT INTO yka_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Duk ekka aˈa laˈi kahagad pu si Isa. ");
INSERT INTO yka_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Manjari, niyaˈ dambuwaˈ lella inēnan Lasarus saki. Patennaˈannen laˈi si kalumaˈan Betani. Laˈi du isab patennaˈan duwangan pungtinaˈine dendehin, si Mariyam duk si Marta. ");
INSERT INTO yka_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Si Mariyam hep inin manataˈan isellan bengngihin si bettis si Isa duk pinunasan weˈ ne duk kōkne. Manjari peggeˈ saki pungtinaˈiden, ");
INSERT INTO yka_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","masan duwangan magpungtinaˈihin pī pu si Isa, paˈinde, “Tuwan, saki bagaynu kinalasahannun.” ");
INSERT INTO yka_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pagkale si Isa pasan miyaˈan, paˈinne, “Saki si Lasarus miyaˈan dumaˈin duk iye matey saguwaˈ duk du bawag balakat Tuhanin supaya bantu Anak Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na, kinalasahan weˈ si Isa tellungan magpungtinaˈi miyaˈan, disi Marta duk Mariyam duk Lasarus. ");
INSERT INTO yka_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Saguwaˈ pagkataˈuhan si Isa weˈ saki si Lasarus, ngagad pe iye laˈi duwem bahangi si kalumaˈan palaˈihannen. ");
INSERT INTO yka_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pagpuwas duwem bahangi miyaˈan, paˈin si Isa si meˈ tindegnen, “Sūng kite bi balik pī si lahat Yahudiya.” ");
INSERT INTO yka_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Paˈin meˈ tindegnen si iye, “Tuwan, gaˈ du miyaˈan tiggel arak kew pagtibagan me aˈahin duk kew matey, hatiˈ balik pe kew pī?” ");
INSERT INTO yka_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nambung si Isa magdalilan, paˈinne, “Daˈa kaˈam suse. Dem da ellewin niyaˈ sampūˈ duk duwe ora dantaˈ. Bang kite lumengngan ellew, gaˈi kite sumampuk peggeˈ dantaˈ dunyahin. ");
INSERT INTO yka_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Saguwaˈ bang kite lumengngan sangem, sumampuk kite peggeˈ dem lindem kite.” ");
INSERT INTO yka_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pagubus inin bissā si Isa, paˈinne si meˈ tindegnen, “Si Lasarus bagayten bi, kapatuli ne. Saguwaˈ pī ku mangun iye.” ");
INSERT INTO yka_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Paˈin meˈ tindegnen si iye, “Tuwan, ngakoleˈ du iye bang kapatuli iye.” ");
INSERT INTO yka_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Hāti binissā si Isa miyaˈan weˈ asal matey ne si Lasarus. Saguwaˈ kannal meˈ tindegnen binissānen sabab tuli hadja. ");
INSERT INTO yka_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hangkan papastiˈ si Isa ne si siye, paˈinne, “Si Lasarus matey ne. ");
INSERT INTO yka_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Duk kēgan ku,” paˈin si Isa, “peggeˈ gaˈ ku laˈi. Inin para si kahāpanbi duk kaˈam kahagad. Sūng kite bi pī si iye.” ");
INSERT INTO yka_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Manjari si Tomas, ugey-ugeynen si Kambal, missā si meˈ pagkasine tindeg si Isahin. Paˈinne si siye, “Sūng kite bi kēmon nuhut guruhin duk kite bi matey nuhut iye.” ");
INSERT INTO yka_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pagtekka disi Isa si Betani, kaˈampat ellewnen ne si Lasarus dem kubul. ");
INSERT INTO yka_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tapit du kalumaˈan Betanihin si Awrusalam, kulang-kulang tellu kilumetro hadja. ");
INSERT INTO yka_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Hangkan ekka meˈ Yahudi pī pu si Marta duk Mariyam mahemokan siye peggeˈ matey pungtinaˈiden. ");
INSERT INTO yka_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Manjari pagkale si Marta weˈ īˈ ne si Isa, pī iye pasampang. Si Mariyam laˈi hadja dem lumaˈ. ");
INSERT INTO yka_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pagmagkasuwaˈ ne si Marta duk si Isa, paˈinne pu si Isa, “Tuwan, bang kew miyaˈan tuˈu, gaˈ siˈ matey pungtinaˈi kamihin. ");
INSERT INTO yka_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Saguwaˈ kataˈuhanku, bisan kuweˈitu, duhulan Tuhanin kew bisan ine pākunu.” ");
INSERT INTO yka_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Paˈin si Isa si iye, “Ellum du balik pungtinaˈinun.” ");
INSERT INTO yka_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Paˈin si Marta, “Aweˈ, Tuwan, kataˈuhanku weˈ pinakellum du iye balik si ellew dambuli.” ");
INSERT INTO yka_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Paˈin si Isa si iye, “Aku magpakellum meˈ pateyin duk aku poˈon umulin. Sine-sine sandel si aku, ellum du iye bisan ne iye matey. ");
INSERT INTO yka_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Duk kēmon maˈellumin bu sandel si aku, gaˈi matey salama-lama.” Manjari tilew si Isa si Marta, paˈinne, “Kahagad ke kew?” ");
INSERT INTO yka_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Aweˈ, Tuwan,” paˈin si Marta. “Kahagad ne ku weˈ kaˈu Almasihin, Anak Tuhanin, asal dambuwaˈ-buwaˈ inagad kami mapitu si dunyahin.” ");
INSERT INTO yka_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagubus inin bissā si Marta, pī iye ngalingan pungtinaˈinen, si Mariyam, duk kinemotan weˈ ne, paˈinne, “Tiyaˈ ne guruhin duk pihane kew.” ");
INSERT INTO yka_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagkale Mariyam inin, duwaˈi iye magdayiˈ-dayiˈ duk pī iye pu si Isa. ");
INSERT INTO yka_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Gaˈ pe hep si Isa tekka laˈi si kalumaˈan miyaˈan saguwaˈ laˈi pe iye si antag pakasampangan si Marta iyehin. ");
INSERT INTO yka_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Meˈ Yahudi manaweˈan si Mariyam dem lumaˈin duk mamahemokan iyehin, pagkitede si Mariyam magdayiˈ-dayiˈ duwaˈi, paturul siye. Kannalde pī iye si kubul pungtinaˈinen magtangis laˈi. ");
INSERT INTO yka_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Saguwaˈ papihannen laˈi pu si Isa. Pagkite Mariyam si Isa, pasujud iye si antag bettis si Isa duk paˈinne, “Tuwan, bang kew miyaˈan tuˈu, gaˈ siˈ matey pungtinaˈi kamihin.” ");
INSERT INTO yka_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Magtangis si Mariyam duk sampay meˈ saweˈne Yahudihin magtangis isab. Pagkite si Isa siye magtangis, hansul ateynen duk dukka teˈed iye. ");
INSERT INTO yka_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Paˈ inne, “Antag pangubulanbi iyehin?” Paˈ inde, “Nuhut kew, Tuwan, duk takitenu.” ");
INSERT INTO yka_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Manjari magtangis si Isa. ");
INSERT INTO yka_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Magbissā-bissā meˈ aˈa malaˈihin, paˈinde, “Payamanun bi be, asal kalasahanne teˈed si Lasarus.” ");
INSERT INTO yka_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Saguwaˈ paˈin meˈ sinduwehin isab, “Si Isa inin, tapangitene meˈ aˈa mapessekin. Weˈey gaˈ tabangne si Lasarus duk iye gaˈ matey?” ");
INSERT INTO yka_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Hansul ne isab atey si Isahin sasangne mapī si kubulin. Kubul inin lingab tinampengan duk batu. ");
INSERT INTO yka_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pagtekka siye si kubul, paˈin si Isa, “Ānanun bi batuhin.” Magtawus missā si Marta, pungtinaˈi aˈa mateyin. Paˈinne pu si Isa, “Bewwan ne iye, Tuwan, peggeˈ ampat ellew ne kuweˈitu.” ");
INSERT INTO yka_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Paˈin si Isa si iye, “Bakas ne kew akahanku weˈ bang kew hadja kahagad, asal kitenu balakat Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Manjari inānan weˈ de batu tampeng kubulin. Ubus mayam si Isa padiyataˈ ngampun si Tuhan, paˈinne, “O Ammaˈ, magsalamat ku si kaˈu peggeˈ pinakale ku weˈ nu. ");
INSERT INTO yka_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kataˈuhanku weˈ luwal ku pakalenu. Saguwaˈ bissāku inin si pakalehan meˈ aˈa matuˈu inin, supaya du siye kahagad weˈ asal kaˈu mamapitu akuhin.” ");
INSERT INTO yka_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pagubus inin bissāne, ngalingan iye papales, paˈinne, “Lasarus, paguwaˈ kew pitu.” ");
INSERT INTO yka_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Magtawus paguwaˈ aˈa bakas mamateyin dem saput pe. Meˈ tangannen duk meˈ bettisnen pinekkes pe duk luwenen kinukuban. Paˈin si Isa si siye, “Lekkahanun bi saputnen duk iye tapa hap lumaˈ.” ");
INSERT INTO yka_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ekka meˈ Yahudi manaweˈan si Mariyamin kahagad ne pu si Isa peggeˈ takitede hininang si Isa miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Saguwaˈ meˈ sinduwehin hap pī si meˈ Pariseohin duk inaka weˈ de si siye bakas hininang si Isahin. ");
INSERT INTO yka_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hangkan magtawus magtipun meˈ Pariseohin duk meˈ nakuraˈ meˈ imamin magisun, paˈinde, “Ine enteˈ tahinangte bi si aˈa inin? Iyuˈ ne ekka tandaˈ makaˈulaliˈ tahinangne. ");
INSERT INTO yka_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bang pasagadante bi iye,” paˈinde, “ujud kahagad kēmon aˈahin. Duk pitu iyan meˈ nakuraˈ bangsa Romahin makaˈatan langgalten bi duk sampay bangsaten bi.” ");
INSERT INTO yka_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Niyaˈ dambuwaˈ nambung, ēnnen si Kayapas. Iye imam nakuraˈin tahun miyaˈan. Paˈin Kayapas, “Gaˈ niyaˈ tasabutbi. ");
INSERT INTO yka_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gaˈi tahātibi weˈ si kahāpante bi hep bang dambuwaˈ aˈa hadja mamateyin gantiˈ meˈ aˈahin duk dumaˈin tibuˈukan bangsahin magmulahin.” ");
INSERT INTO yka_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Binissā si Kayapas miyaˈan dumaˈin amban di pikilanne. Saguwaˈ peggeˈ iye imam nakuraˈin tahun miyaˈan, pinaˈal weˈ ne weˈ subey si Isa matey gantiˈ bangsa Israˈilin. ");
INSERT INTO yka_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Duk matey iye dumaˈin hadja ngagantiˈan bangsa Israˈilin, saguwaˈ supaya isab meˈ anak Tuhan makanat-kanat si meˈ kalahatanin tapagdambuwaˈ du weˈ ne. ");
INSERT INTO yka_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Manjari kemuwe ellew miyaˈan, isunden weˈ papateyde si Isa. ");
INSERT INTO yka_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hangkan gaˈ ne si Isa patampal si meˈ aˈa laˈi si Yahudiyahin. Saguwaˈ tahalaˈ iye duk meˈ tindegnen pī si dambuwaˈ kalumaˈan inēnan Epraim. Kalumaˈan inin si sīng lahat gaˈ niyaˈ tantu aˈane. Laˈi siye patennaˈ. ");
INSERT INTO yka_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Manjari tapit ne pagkādjaˈan meˈ Yahudihin ēnande Kādjaˈan Pangesseban. Ekka meˈ aˈa amban meˈ kalahatan pāngkat hap Awrusalam magsutsi baran meke siye sumakup si kādjaˈanin. ");
INSERT INTO yka_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Piniha weˈ de si Isa laˈi si Awrusalam duk pagbissā-bissāde sābude laˈi dem langgal hadjehin. Paˈinde, “Ine pikilbi? Pitu enteˈ si Isa si pagkādjaˈan? Hatu gaˈi, ēˈ?” Iye miyaˈan pagbissā-bissāden, ");
INSERT INTO yka_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","peggeˈ bakas maguldin hep meˈ nakuraˈ meˈ imamin duk meˈ Pariseohin weˈ bang niyaˈ ngataˈuhan palaˈihan si Isahin, subey siye inakahan duk iye tasiggewde. ");
INSERT INTO yka_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ennem ellew pe meke tinagnaˈan Kādjaˈan Pangessebanin, pī si Isa hap Betani, lahat si Lasarus aˈa pinakellumne amban kamateynen. ");
INSERT INTO yka_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Paglaˈi iye si Betani, magjamu-jamu meˈ aˈa malaˈihin pamahadjede si Isa. Si Marta nabang magtāgad si siye. Si Lasarus magtuhut mangan duk si Isa duk meˈ sinduwehin. ");
INSERT INTO yka_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Manjari ngeddoˈ Mariyam isellan bengngi inēnan narda tengaˈ kilu bohatnen. Mahalgaˈ teˈed isellan bengngi inin duk gaˈ niyaˈ lamud-lamudne. Pinatataˈ weˈ Mariyam isellan bengngi inin si bettis si Isa, ubus bu pinunasan weˈ ne duk kōkne. Manyug bengnginen dem lumaˈ. ");
INSERT INTO yka_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Manjari naggaˈ si Judas Iskariyot, dambuwaˈ meˈ tindeg si Isahin. Si Judas hep inin mamuddihan si Isahin. ");
INSERT INTO yka_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Paˈin si Judas, “Gam pe isellan bengngi miyaˈan pinabellihan, bu pangurung sīnin si meˈ mamiskinin. Halgaˈne miyaˈan tangdan hinang dem dan tahun.” ");
INSERT INTO yka_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Dumaˈin weˈ maˈaseˈ si Judas si meˈ mamiskinin hangkan inin bissāne, saguwaˈ peggeˈ panangkew iye. Iye hep pinangandel magantan pangisihan sīnden duk daran iye ngeddoˈ. ");
INSERT INTO yka_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Manjari paˈin si Isa, “Pasagadanun dende inin. Ennaˈne isellan bengngi inin para ellew pangubul akuhin. ");
INSERT INTO yka_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Meˈ mamiskinin gaˈi du usaˈ amban kaˈam duk tatabangbi siye. Saguwaˈ aku, gaˈi ku teteg tuˈu si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ekka meˈ aˈa ngataˈu weˈ laˈi si Isa si Betani, hangkan hap pī siye laˈi. Pī siye dumaˈin sabab si Isa hadja, saguwaˈ batang kitede isab si Lasarus, iye bakas pinakellum si Isa amban kamateynen. ");
INSERT INTO yka_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hangkan magisun meˈ nakuraˈ meˈ imamin weˈ dumaˈin hadja si Isa pinapateyden saguwaˈ sampay si Lasarus isab. ");
INSERT INTO yka_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Hangkan siye magisun kuweˈ miyaˈan, peggeˈ sabab Lasarus ekka meˈ Yahudihin kahagad ne pu si Isa. Gaˈi ne siye nuhut meˈ imamden. ");
INSERT INTO yka_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pagsasumuhin, takale weˈ meˈ aˈa maˈekka si pagkādjaˈan si Awrusalamin weˈ laˈi ne si Isa si lān tudju Awrusalam. ");
INSERT INTO yka_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Manjari ngeddoˈ siye kuweˈ bantuk tuggu dawen lahing duk paguwaˈ siye pī pasampang pu si Isa. Ngalingan-ngalingan siye papales, paˈinde, “Pudjite bi Tuhanin. Pudjite bi pinapitu weˈ Tuhanin. Pudjite bi Sultan bangsa Israˈilin.” ");
INSERT INTO yka_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ngasuwaˈ hep si Isa dambuwaˈ anak asnu (hayep kuweˈ bantuk kuraˈ) duk sinakeyan weˈ ne. Hininang si Isa inin, maguyun duk niyaˈ ayat tasulat dem kitab, pinaˈin, ");
INSERT INTO yka_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kaˈam, meˈ aˈa Awrusalamin, daˈa kaˈam tinalew. Tiyaˈ pitu sultanbin pasakey diyataˈ anak asnu.” ");
INSERT INTO yka_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Waktu miyaˈan, gaˈ tahāti meˈ tindeg si Isahin meˈ kēmon inin. Saguwaˈ pagtapoleˈ ne si Isa si surgaˈ, bahu taˈessebde weˈ meˈ hininangde pu si Isahin asal tasulat hatiˈ dem kitab. ");
INSERT INTO yka_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Hangkan hep pasampang meˈ aˈa mabanesin pu si Isa si lān, peggeˈ bakas takalede sabab hininang si Isa makaˈulaliˈin pangalingan si Isa si Lasarusin amban dem kubulin duk pamakellumne iyehin. Peggeˈ meˈ aˈa masumābu malaˈihin, siye hep magaka-aka si meˈ aˈahin sabab hininang si Isa inin. ");
INSERT INTO yka_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Manjari magbissā-bissā meˈ Pariseohin, paˈinde, “Payamanun bi, kēmon meˈ aˈahin patuhut ne si iye. Gaˈ be niyaˈ tahinangte bi.” ");
INSERT INTO yka_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Niyaˈ meˈ aˈa bangsa Girik patuhut si meˈ aˈahin pī nambahayang si Awrusalam waktu pagkādjaˈan miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pī siye pu si Pilip duk paˈinde si iye, “Tuwan, bayaˈ kami magkite duk si Isa.” Si Pilip inin dambuwaˈ tindeg si Isa amban kalumaˈan Betsaida laˈi si lahat Jalil. ");
INSERT INTO yka_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pī si Pilip ngakahan si Andariyas, ubus pī siye duwangan ngakahan si Isa. ");
INSERT INTO yka_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Sambungan si Isa siye, paˈinne, “Taˈabut ne waktukun. Aku, Anak Manusiyaˈin, sōng pinahadje ne ku. ");
INSERT INTO yka_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sabennal akahante kaˈam, weˈ da lowang binihiˈ tattap da lowang hadja samantaˈan gaˈi pinadem bulak. Saguwaˈ bang pinadem bulak ne, kuweˈ dalil matey bu kinubul, na, manjari tomoˈ duk ekka buwaˈne. ");
INSERT INTO yka_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Damikkiyan isab aˈahin. Bang ellegne teˈed umulne si dunya inin, gaˈ niyaˈ umulne salama-lama. Saguwaˈ bang gaˈi du ellegne umulne si dunya inin, niyaˈ du umulne salama-lama.” ");
INSERT INTO yka_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Paˈin si Isa, “Sine-sine bayaˈ daˈak-daˈakku, subey iye nuhut-nuhut aku. Manjari antag-antagku, laˈi isab iye. Sine-sine ngahinang pangandaˈakankun, pahadje Samakun iye.” ");
INSERT INTO yka_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Missā-missā pe si Isa, paˈinne, “Suse teˈed ateykun kuweˈitu. Na, ine subey paˈinku? Pākuku enteˈ si Samakun weˈ gaˈi patekkane si aku kabinasahan inin? Gaˈi inin pākuku peggeˈ asal inin sababnen hangkan ku pitu, weˈ subey ku makalabey kabinasahan inin.” ");
INSERT INTO yka_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Manjari missā si Isa si Tuhanin, paˈinne, “O Ammaˈ, pahadjehun ēnnun.” Magtawus niyaˈ suwala amban langit magpaˈin, “Bakas ne pahadjeku ēnkun duk pahadjeku du balik.” ");
INSERT INTO yka_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Meˈ aˈa magtengge malaˈihin, takalede suwala inin. Paˈin meˈ sinduwehin, “Uy, lugung hep īˈen.” Paˈin meˈ sinduwehin isab, “Malaˈikat miyaˈan, missā si iye.” ");
INSERT INTO yka_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Saguwaˈ paˈin si Isa si siye, “Suwala miyaˈan pinakale si kaˈam, dumaˈin si kahāpanku saguwaˈ si kahāpanbi.” ");
INSERT INTO yka_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Paˈinne, “Taˈabut ne waktu pangahukum meˈ manusiyaˈ si dunyahin. Taˈabut ne waktu pangānan basag nakuraˈ seyitanin, iye magnakuraˈ tuˈu si dunyahin. ");
INSERT INTO yka_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bang ne ku pinadangkat diyataˈ olom,” paˈin si Isa, “taboˈoku du kēmon aˈahin nuhut aku.” ( ");
INSERT INTO yka_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Binissā si Isa inin, pamahātine si meˈ aˈa malaˈihin bang saˈingge kamateynen.) ");
INSERT INTO yka_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nambung meˈ aˈa mabanesin pu si Isa, paˈinde, “Paˈin kitab kamihin weˈ Almasihin ellum salama-lama. Saguwaˈ paˈinnu weˈ Anak Manusiyaˈin subey pinadangkat duk pinapatey. Sine teˈ Anak Manusiyaˈ inin?” ");
INSERT INTO yka_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nambung si Isa paˈinne, “Tiyaˈ pe tuˈu si kaˈam dantaˈ mangurung dantaˈ si pikilanbin, saguwaˈ gaˈi ne tiggel. Pādpād tuˈu pe si kaˈam dantaˈin, palanjalun bi paglengnganbin duk kaˈam gaˈi taˈabut lindem. Peggeˈ malumengngan dem lindemin, gaˈi kataˈuhanne papīhannen. ");
INSERT INTO yka_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hangkan,” paˈin si Isa, “subey kaˈam sandel si dantaˈin pādpād tuˈu pe si kaˈam dantaˈin duk kaˈam manjari meˈ aˈa sukuˈ si dantaˈin.” Pagubus inin bissā si Isa, tahalaˈ iye duk patapuk iye amban siye. ");
INSERT INTO yka_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bisan du ekka meˈ hinangan makaˈulaliˈ tahinang si Isa si matahan meˈ aˈa malaˈihin, masi du siye gaˈi kahagad si iye. ");
INSERT INTO yka_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Toˈo teˈed tasulat Nabi Isaya dem kitabin. Paˈinne hep laˈi, “O Tuhan, gaˈ niyaˈ kahagad si meˈ inaka kamihin. Meˈ aˈa mangite balakatnun, kulang du siye makahātihin.” ");
INSERT INTO yka_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Lagiˈ pe, sinulat isab weˈ Nabi Isaya jānnen bang weˈey meˈ aˈa manggaˈi mabayaˈ makahagadin ujudnen gaˈi ne makajari kahagad. Paˈin Isaya, ");
INSERT INTO yka_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pinessekan weˈ Tuhanin meˈ mataden duk siye gaˈi ngite, duk pinababbal weˈ ne pikilanden duk siye gaˈi makahāti. Manjari gaˈi pinda ateyden, paˈin Tuhanin, hangkan gaˈi tapuwasanku duseden.” ");
INSERT INTO yka_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Binissā inin weˈ Nabi Isaya peggeˈ takitene sahaya si Isahin duk binissāne inin sabab si Isa. ");
INSERT INTO yka_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Saguwaˈ bisan ne sa miyaˈan, ekka du meˈ nakuraˈ meˈ Yahudihin kahagad pu si Isa, saguwaˈ gaˈ hadja siye missā patampal sabab inin, peggeˈ tinalew siye kaw kataˈuhan meˈ Pariseohin ubus gaˈi ne siye pinaˈasek dem langgal. ");
INSERT INTO yka_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Peggeˈ sinna pe siye bang kasulutan manusiyaˈin si siye amban bang kasulutan Tuhanin si siye. ");
INSERT INTO yka_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Manjari missā si Isa pinapales, paˈinne, “Makahagad si akuhin, dumaˈin hadja aku kinahagadnen, saguwaˈ kahagad isab iye si Tuhan, iye mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Duk mangite akuhin, takitene isab mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Pitu ku si dunya ngurung dantaˈ si pikilan manusiyaˈ supaya sine-sine kahagad si aku gaˈi teteg dem lindem. ");
INSERT INTO yka_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Bang niyaˈ aˈa makakale meˈ panoloˈkun bu gaˈi tuhutne, dumaˈin aku mangahukum iyehin. Peggeˈ dumaˈin ku pitu ngahukum meˈ aˈa si dunyahin, saguwaˈ pitu ku nimbul siye. ");
INSERT INTO yka_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Si ellew dambuli, niyaˈ du ngahukum meˈ manggaˈi manayimaˈ akuhin duk meˈ manggaˈi manuhut meˈ panoloˈkun. Iye pangahukuman siyehin meˈ bakas panoloˈku si siyehin. ");
INSERT INTO yka_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Peggeˈ meˈ panoloˈkun dumaˈin amban di pikilanku, saguwaˈ amban Samaku mamapitu akuhin. Kēmon panoloˈkun, iye hadja dinaˈakne si aku pamanoloˈin. ");
INSERT INTO yka_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Duk kataˈuhanku weˈ meˈ panoloˈnen ngurung umul gaˈ tamananne laˈi si surgaˈ. Hangkan hep gaˈ niyaˈ bissāku si manusiyaˈ seddili amban pangandaˈakan Samaku akuhin.” ");
INSERT INTO yka_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gaˈ pe tinagnaˈan pagjamu-jamuhin, andang ne kataˈuhan si Isa weˈ tekka ne gantaˈannen duk subey ne ambananne dunya inin duk balik pī si Samanen. Asal amban tagnaˈ kinalasahan weˈ si Isa meˈ aˈa sukuˈ si iyehin, duk kuweˈitu pakitehanne du si siye bang saˈingge hadje lasane si siyehin. ");
INSERT INTO yka_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Manjari pagsangem, magkakan disi Isa duk meˈ tindegnen. Si Judas, anak si Simon Iskariyotin, bakas ne kaˈurungan pikilan weˈ seyitan nakuraˈin muddihan si Isa. ");
INSERT INTO yka_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Asal du kataˈuhan si Isa weˈ kēmon kapatut Tuhanin tapangurung ne si iye. Duk kataˈuhanne weˈ pitu iye amban Tuhan duk balik du iye pī si Tuhan. ");
INSERT INTO yka_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Manjari kuwat si Isa amban pagkakananden, bu iluwasan weˈ ne da lapis badjuˈnen duk magdikat iye duk tuwaliya. ");
INSERT INTO yka_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Manjari ngisi iye boheˈ dem palanggana duk kinosoˈan weˈ ne bettis meˈ tindegnen duk pinunasan weˈ ne duk tuwaliya pagdikatnen. ");
INSERT INTO yka_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pagpīne pu si Simon Petros, paˈin si Petros si iye, “Kaˈu, Tuwan, sōng kosoˈannu ke meˈ bettisku inin?” ");
INSERT INTO yka_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Sambungan si Isa iye, paˈinne, “Gaˈi tahātinu kuweˈitu bang ine hininangku inin, saguwaˈ tahātinu iyan si ellew sinōng.” ");
INSERT INTO yka_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Paˈin si Petros, “Gaˈi teˈed pakosoˈku si kaˈu bettiskun.” “Bang gaˈi kosoˈanku bettisnun,” paˈin si Isa, “dumaˈin ne kew tindegku.” ");
INSERT INTO yka_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Manjari paˈin Simon Petros si iye, “O Tuwan, bang kuweˈ iyan, dumaˈin hadja bettiskun saguwaˈ sampay meˈ tangankun duk kōkkun kosoˈanun isab.” ");
INSERT INTO yka_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Paˈin si Isa si iye, “Aˈa bakas mamandihin, gī ne barannen. Luwal hadja bettisnen subey kinosoˈan balik. Kēmon kaˈam sutsi ne dem ateybin, luwal dangan manggaˈi masutsi ateynen.” ");
INSERT INTO yka_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Andang ne hep kataˈuhan si Isa bang sine sōng mamuddihan iyehin hangkan paˈinne, “Kēmon kaˈam sutsi ne dem ateybin, luwal dangan manggaˈi masutsi ateynen.” ");
INSERT INTO yka_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pagubus ne kosoˈan si Isa bettis meˈ tindegnen, inasek weˈ ne badjuˈnen bu ningkoloˈ balik. Paˈinne si meˈ tindegnen, “Tahātibi ke bang ine bakas hininangku si kaˈam miyaˈan? ");
INSERT INTO yka_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pangēnbi akuhin ‘Guru’ duk ‘Panuhutan.’ Patut teˈed, peggeˈ aku asal gurubi duk panuhutanbi. ");
INSERT INTO yka_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na, bang aku panuhutanbin duk gurubin ngosoˈan bettisbin, subey ku lekkatbi. Subey kaˈam magkosoˈ-kinosoˈ bettis. ");
INSERT INTO yka_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Hininangku miyaˈan pinakitehan weˈ ku si kaˈam supaya niyaˈ pamintanganbi weˈ subey diyawaˈ ateybin. Subey lekkatbi hininangku si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sabennal akahante kaˈam weˈ banyagaˈin gaˈi langkew amban amunen. Duk dinaˈakin gaˈi langkew amban mangandaˈak iyehin. ");
INSERT INTO yka_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kuweˈitu tahātibi ne panoloˈku si kaˈam inin. Bang tuhutbi inin, kēgan kaˈam.” ");
INSERT INTO yka_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Paˈin si Isa, “Dumaˈin ku missā sabab kaˈam kēmon. Kataˈuhanku bang sine meˈ aˈa bakas tapeneˈku manuhut akuhin. Saguwaˈ subey du tuman pinaˈin dem kitabin, pinaˈin laˈi, ‘Binuddihan ku weˈ dambuwaˈ saweˈku magsawu manganin.’ ");
INSERT INTO yka_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Akahante kaˈam inin kuweˈitu pādpād gaˈ pe umantag supaya bang umantag ne, kahagadbi du bakas pinaˈinku sabab dikun, bang sine ku. ");
INSERT INTO yka_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sabennal akahante kaˈam,” paˈin si Isa, “weˈ sine-sine ngaddatan aˈa dinaˈakkun, kuweˈ du aku inaddatannen. Duk sine-sine ngaddatan aku, kuweˈ du inaddatan weˈ ne bakas mamapitu akuhin.” ");
INSERT INTO yka_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pagubus inin bissā si Isa, suse teˈed dem ateynen duk paˈinne si meˈ tindegnen, “Sabennal akahante kaˈam, dangan kaˈam muddihan aku du.” ");
INSERT INTO yka_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Magpayam meˈ tindegnen. Gaˈi kataˈuhande bang sine binissāhannen. ");
INSERT INTO yka_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Dangan meˈ tindeg si Isahin, iye kinalasahannen, ningkoloˈ si bihingne. ");
INSERT INTO yka_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sininyasan iye weˈ Simon Petros duk paˈinne si iye, “Tilewun be si Isa bang sine binissāhannen.” ");
INSERT INTO yka_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Manjari tindeg si Isa miyaˈan patapit pu si Isa nilew iye, paˈinne, “Tuwan, sine teˈ sōng mamuddihan kaˈuhin?” ");
INSERT INTO yka_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nambung si Isa, paˈinne, “Aˈa pangurunganku pan inin pagubus lebbaganku dem pinggan, iye ne miyaˈan.” Manjari ilebbagan weˈ si Isa panin ubus bu pinangurung weˈ ne pu si Judas, anak si Simon Iskariyotin. ");
INSERT INTO yka_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pageddoˈ si Judas panin, magtawus paˈasek nakuraˈ seyitanin dem pikilanne. Paˈin si Isa si iye, “Hinangun ne padayiˈ sōng hininangnun.” ");
INSERT INTO yka_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Gaˈ niyaˈ bisan dangan meˈ tindegnen makahāti bang ine pinaˈin si Isa pu si Judas miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Peggeˈ si Judas magantan sīnden, kannal meˈ sinduwehin weˈ daˈak si Isa iye pī melli ginunade si pagkādjaˈanin, atawa dinaˈak iye magsarakka si meˈ mamiskinin. ");
INSERT INTO yka_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Manjari pagsangka si Judas panin, magtawus iye duwaˈi. Duk sangem ne miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Paglumikut ne si Judas, paˈin si Isa, “Kuweˈitu pinakitehan ne pamahadje akuhin, aku Anak Manusiyaˈin. Kuweˈitu pinakitehan ne balakat Tuhanin sabab aku. ");
INSERT INTO yka_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bang tapakitehan balakat Tuhanin sababku, gaˈi du tiggel pakitehan Tuhanin isab pamahadjene akuhin, aku Anak Manusiyaˈin.” ");
INSERT INTO yka_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Paˈin si Isa, “Kaˈam meˈ tindegkun, gaˈi ne ku tiggel tuˈu si kaˈam. Pihabi du ku. Saguwaˈ sa pinaˈinku si meˈ nakuraˈ Yahudihin, paˈinku si kaˈam kuweˈitu, ‘Gaˈi kaˈam tapī si papīhankun.’ ");
INSERT INTO yka_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Niyaˈ daˈakan baˈahu ambananku si kaˈam. Subey kaˈam maglasa-ilasa. Maglasa kaˈam kuweˈ pangalasaku si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bang kaˈam maglasa-ilasa, kataˈuhan meˈ aˈahin kēmon weˈ kaˈam meˈ tindegku.” ");
INSERT INTO yka_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Paˈin si Petros pu si Isa, “Tuwan, hap tungan kew?” Nambung si Isa, paˈinne, “Gaˈi kew kapanuhut aku kuweˈitu si papīhankun, saguwaˈ paturul du kew si sinōng.” ");
INSERT INTO yka_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Paˈin si Petros si iye, “Tuwan, weˈey ku gaˈi kapanuhut si kaˈu kuweˈitu? Maglillaˈ ku bisan ku pinapatey bang sababnu.” ");
INSERT INTO yka_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Sambungan si Isa iye, paˈinne, “Asal maglillaˈ ke kew pinapatey bang sababku? Sabennal akahante kew, gaˈi pe tingkowak manukin, masuwey ne kew iyan mintellu weˈ gaˈi ku kataˈuhannu.” ");
INSERT INTO yka_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Paˈin si Isa si meˈ tindegnen, “Daˈa kaˈam suse dem ateybi sabab meˈ pinaˈinku miyaˈan. Sandel kaˈam si Tuhan duk sandel isab kaˈam si aku. ");
INSERT INTO yka_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Laˈi si lahat Samaku Tuhanin, ekka patennaˈan. Bang inin gaˈi toˈo gaˈi kaˈam akahanku. Pī ku manyap patennaˈanbin. ");
INSERT INTO yka_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Manjari bang ubus ne ku magpanyap patennaˈanbin, balik du ku pitu ngeddoˈ kaˈam duk boˈote kaˈam pī si patennaˈankun duk kite bi magdambuwaˈ patennaˈan. ");
INSERT INTO yka_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Duk kataˈuhanbi du lān hap pī si papīhankun.” ");
INSERT INTO yka_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Paˈin si Tomas si iye, “Tuwan, gaˈi kataˈuhan kami bang tungan papīhannun. Saˈingge pangataˈu kami lān hap pīhin?” ");
INSERT INTO yka_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Paˈin si Isa si iye, “Aku inin lān tudju Tuhanin, aku poˈon sasuku mabennalin, duk aku poˈon umulin. Gaˈ niyaˈ tapī si Samaku Tuhanin bang dumaˈin aku palabeyannen. ");
INSERT INTO yka_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kuweˈitu peggeˈ kataˈuhanbi ne ku,” paˈin si Isa, “kataˈuhanbi du isab Samakun. Tinagnaˈan kuweˈitu, kataˈuhanbi ne Samakun duk takitebi ne iye.” ");
INSERT INTO yka_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Paˈin si Pilip pu si Isa, “Tuwan, pakitehanun si kami Samanun duk kaduhulan ne kami.” ");
INSERT INTO yka_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Sambungan si Isa iye, paˈinne, “Katiggelku ne tuˈu si kaˈam, gaˈi pe kataˈuhannu bang sine ku, Pilip? Sine-sine ngite aku, kuweˈ Samakun ne teˈed takitenen. Hangkan weˈey paˈinnu weˈ subey pinakitehan si kaˈu Samakun? ");
INSERT INTO yka_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Weˈ gaˈi kew kahagad, Pilip, weˈ Samakun duk aku dambuwaˈ du? Meˈ pamanoloˈku si kaˈamin dumaˈin amban aku, saguwaˈ amban Samaku mateteg tuˈu si akuhin. Kēmon meˈ hinangkun iye mangahinangin.” ");
INSERT INTO yka_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Paˈin si Isa, “Subey kahagadbi pinaˈinkun weˈ Samakun duk aku dambuwaˈ du. Bang gaˈi kaˈam kahagad sabab bissāku inin, kahagad kaˈam hadja sabab meˈ hinang bakas hininangkun. ");
INSERT INTO yka_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sabennal akahante kaˈam,” paˈin si Isa, “sine-sine kahagad si aku, hinangne du isab meˈ hinang hininangkun. Duk pasōng pe meˈ tahinangnen amban meˈ hininangkun, peggeˈ pī ne ku si Samaku Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ine-ine pākubi si Samakun sabab sandelbi si akuhin, hinangku si kaˈam supaya tapudji Samakun sabab hininangkun. ");
INSERT INTO yka_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ine-ine pākubi si aku sabab sandelbi si akuhin, hinangku si kaˈam.” ");
INSERT INTO yka_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Paˈin si Isa pe, “Bang bennal ku kalasahanbi, bugtuˈ tuhutbi meˈ pangandaˈakanku si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pākuku du si Samakun duk kaˈam urunganne seddili nabangan kaˈam gantiˈku. Luˈu du iye si kaˈam salama-lama. ");
INSERT INTO yka_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Manabang inin, Niyawa Tuhanin. Iye magaka mabennalin sabab Tuhanin. Saguwaˈ meˈ aˈa manggaˈi manuhut Tuhanin, gaˈi tatayimaˈde Niyawa Tuhanin peggeˈ gaˈi iye tahātide duk gaˈi iye kataˈuhande. Saguwaˈ kaˈam, kataˈuhanbi du Niyawa Tuhanin peggeˈ luˈu iye si kaˈam duk pateteg du iye dem ateybi. ");
INSERT INTO yka_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Bisan ku tahalaˈ, gaˈi du kaˈam siya-siyaku. Balik du ku pitu si kaˈam. ");
INSERT INTO yka_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Gaˈi ne tiggel gaˈi ne ku takite weˈ meˈ aˈa manggaˈi manuhut Tuhanin. Saguwaˈ kaˈam, kitebi du ku. Duk peggeˈ ellum ku salama-lama, kaˈam ellum du isab salama-lama. ");
INSERT INTO yka_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pagtekka ellew miyaˈan, kataˈuhanbi du weˈ Samakun duk aku magdambuwaˈ. Duk kataˈuhanbi isab weˈ kaˈam duk aku magdambuwaˈ. ");
INSERT INTO yka_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Sine-sine nayimaˈ meˈ pangandaˈakankun duk tuhutne du, iye iyan aˈa asal mamalasa si akuhin. Aˈa mamalasa si akuhin kinalasahan du iye weˈ Samakun. Duk kalasahanku isab iye duk pahātiku du dikun si iye.” ");
INSERT INTO yka_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Manjari tinilew si Isa weˈ si Judas, dumaˈin si Judas Iskariyot. Paˈin si Judas, “Tuwan, ine sababnen hangkan pahātinu dinun si kami hadja bu dumaˈin si meˈ manusiyaˈin kēmon?” ");
INSERT INTO yka_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nambung si Isa, paˈinne, “Bang aˈahin malasa si aku, bugtuˈ tuhutne meˈ panoloˈkun. Manjari kalasahan Samakun iye, duk laˈi kami duk Samakun patennaˈ si iye. ");
INSERT INTO yka_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Saguwaˈ aˈa manggaˈi malasa si akuhin, gaˈi du isab tuhutne meˈ pamanoloˈkun. Duk meˈ pamanoloˈku si kaˈamin dumaˈin amban aku saguwaˈ amban Samaku mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Inaka inin kēmon weˈ ku si kaˈam pādpād tiyaˈ pe ku tuˈu si kaˈam. ");
INSERT INTO yka_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Saguwaˈ papitu Samakun du si kaˈam manabangin, gantiˈku. Iye Niyawa Sutsihin. Toloˈanne du kaˈam kēmon-kēmonin duk paˈessebanne kaˈam kēmon bakas panoloˈku si kaˈamin.” ");
INSERT INTO yka_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Paˈin si Isa pe, “Iye pangambanku si kaˈamin atey sanyang. Kasanyangan inin amban aku duk gaˈi inin magsaliˈ duk kasanyangan si dunyahin. Hangkan daˈa kaˈam suse dem ateybi duk daˈa kaˈam tinalew. ");
INSERT INTO yka_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bakas ne kaˈam akahanku weˈ aku inin tahalaˈ ne, saguwaˈ balik du ku pitu si kaˈam. Bang kaˈam asal malasa si aku, bugtuˈ kēgan kaˈam weˈ pī ku si Samakun, peggeˈ langkew iye amban aku. ");
INSERT INTO yka_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Andang ne kaˈam akahanku pādpād gaˈ pe taˈabut waktu patahalaˈkun supaya bang taˈabut ne waktu miyaˈan, asal kahagad ne teˈed kaˈam. ");
INSERT INTO yka_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gaˈi ne ku makajari missā si kaˈam tiggel peggeˈ sōng tekka ne nakuraˈ seyitan magnakuraˈ si dunya inin. Gaˈi du ku kapagbayaˈanne. ");
INSERT INTO yka_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Saguwaˈ subey kataˈuhan meˈ manusiyaˈin kēmon weˈ malasa ku si Samakun, hangkan pagtuyuˈanku kēmon hininang sa pangandaˈakan Samaku akuhin. Na, kuwat ne kaˈam, sūng ne kite bi,” paˈin si Isa. ");
INSERT INTO yka_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Manjari magdalilan si Isa, paˈinne si meˈ tindegnen, “Aku inin dalil poˈon tinanem mahāpin, duk Samakun dalil magipat tinanem inin. ");
INSERT INTO yka_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kēmon pangeku manggaˈi mabuwaˈin totoˈanne, duk kēmon pangeku mabuwaˈin gawasanne duk ngaˈekka buwaˈnen. ");
INSERT INTO yka_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kaˈam iyan dalil kagawasan ne sabab meˈ panoloˈku si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Subey kaˈam pateteg si aku, duk teteg ku isab si kaˈam. Dalil pangehin, gaˈi makajari buwaˈ pangehin amban dihananne, luwal bang gaˈi butas amban poˈonne, buwaˈ du. Damikkiyan kaˈam gaˈi kaˈam kapaghinang si kahāpan bang gaˈi kaˈam teteg si aku. ");
INSERT INTO yka_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Aku inin poˈon tinanemin duk kaˈam dalil meˈ pangehin. Bang kaˈam teteg si aku duk aku isab teteg si kaˈam, ekka tahinangbi kahāpan, peggeˈ bang butas kaˈam amban aku, gaˈ niyaˈ kasuddahan hinangbin. ");
INSERT INTO yka_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bang aˈahin gaˈi teteg si aku, kuweˈ iye dalil pange seppak ilakasan duk ngalanes. Manjari tinipun meˈ pange inin bu ilakasan dem ebbut ineggas. ");
INSERT INTO yka_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Saguwaˈ bang teteg kaˈam si aku duk meˈ panoloˈkun ingketbi teˈed dem ateybi, duhulan Tuhanin kaˈam ine-ine pākubi. ");
INSERT INTO yka_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bang ekka kahāpan tahinangbi, pinudji du Samakun duk kataˈuhan du isab weˈ kaˈam bennal meˈ tindegku. ");
INSERT INTO yka_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Lasaku si kaˈamin kuweˈ du lasa Samaku si akuhin. Patetegun bi lasabin si aku. ");
INSERT INTO yka_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bang tuhutbi meˈ pangandaˈakankun, teteg du lasakun si kaˈam. Kuweˈ du akuhin, tinuhut weˈ ku meˈ pangandaˈakan Samakun duk teteg lasanen si aku. ");
INSERT INTO yka_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Hangkan inin panoloˈku si kaˈam, supaya talessabi isab kuweˈ kēg dem ateykun duk supaya kēgbin jukup. ");
INSERT INTO yka_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iye inin pangandaˈakanku si kaˈamin, subey kaˈam maglasa-ilasa kuweˈ pangalasaku si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bang aˈahin maglillaˈ matey sabab lasane si meˈ bagaynen, gaˈ niyaˈ lasa manusiyaˈ hadje amban inin. ");
INSERT INTO yka_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kaˈam, meˈ bagayku kaˈam, bang hinangbi meˈ pangandaˈakanku si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kuweˈitu gaˈi ne kaˈam ēnanku meˈ daraˈakanku, peggeˈ daraˈakanin gaˈi pinahātihan si siye bang ine ne paˈin hininang amunen. Saguwaˈ kaˈam, bakas pahātiku ne si kaˈam kēmon inaka Samaku si akuhin. Hangkan ēnanku ne kaˈam meˈ bagayku. ");
INSERT INTO yka_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Dumaˈin weˈ peneˈbi ku, saguwaˈ aku mameneˈ kaˈamin, duk kawakilan kaˈam weˈ ku supaya ekka hāp tahinangbi duk meˈ mahāp tahinangbin gaˈi pinda. Manjari, ine-ine pākubi si Samakun sabab sandelbi si akuhin, duhulanne kaˈam. ");
INSERT INTO yka_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na, iye inin pangandaˈakanku kaˈamin, subey kaˈam maglasa-ilasa.” ");
INSERT INTO yka_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Paˈin si Isa si meˈ tindegnen, “Daˈa kaˈam ulaliˈ bang kaˈam kabunsihan weˈ meˈ aˈa manggaˈi manuhut Tuhanin. Essebun bi weˈ kabunsihande ku dehellu amban kaˈam. ");
INSERT INTO yka_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bang saˈupama magdambuwaˈ pikilan kaˈam duk meˈ aˈa iyan, kalasahande hep kaˈam. Saguwaˈ pabiddaˈ kaˈam. Tapeneˈ kaˈam weˈ ku duk pinaseddili kaˈam weˈ ku amban meˈ aˈa iyan. Hangkan hep kaˈam kabunsihan weˈ de. ");
INSERT INTO yka_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Essebun bi bakas pinaˈinku si kaˈamin: ‘Banyagaˈin gaˈi langkew amban amunen.’ Bang ku bakas bininasa weˈ meˈ aˈa iyan, bugtuˈ binasade du isab kaˈam. Bang bakas tuhutde panoloˈkun, bugtuˈ tuhutde du isab panoloˈbin. ");
INSERT INTO yka_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kabunsihande kaˈam duk binasade kaˈam peggeˈ kaˈam sukuˈ si aku duk peggeˈ gaˈ kataˈuhande Tuhanin, Tuhan mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bang ku gaˈ tapitu noloˈan siye, gaˈ pe pastiˈ duseden. Saguwaˈ kuweˈitu gaˈi ne kadaˈawahande duseden. ");
INSERT INTO yka_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sine-sine bunsi si aku bunsi du isab iye si Samakun. ");
INSERT INTO yka_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Meˈ hinang hininangku si matahanden, gaˈ niyaˈ aˈa bakas makahinangne. Bang gaˈ ku kapaghinang meˈ hinangan miyaˈan, gaˈi hep pastiˈ duseden. Saguwaˈ takitede ne meˈ hininangkun, duk kabunsihande ku duk Samakun. ");
INSERT INTO yka_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Saguwaˈ bugtuˈ du ku kabunsihande supaya tuman tasulat dem kitabin. Paˈin kitabin: ‘Kabunsihande ku gaˈ niyaˈ jānne.’ ");
INSERT INTO yka_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pitu du si kaˈam pananabangin. Pananabang inin, Niyawa Tuhanin duk amban Samakun iye. Magtoloˈ du iye mabennal sabab Tuhanin. Papituku du iye si kaˈam amban Samakun duk pagtuˈu ne iye, naksiˈ du iye sabab aku. ");
INSERT INTO yka_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kaˈam isab, naksiˈ du kaˈam sabab aku peggeˈ kemuwe tagnaˈ magtuhut-tuhut kite bi.” ");
INSERT INTO yka_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Paˈin si Isa si meˈ tindegnen, “Inaka weˈ ku kēmon inin si kaˈam, supaya gaˈi usaˈ sandelbi si akuhin. ");
INSERT INTO yka_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Niyaˈ iyan waktu si sinōng, gaˈi ne kaˈam paˈasek meˈ nakuraˈ āgamahin dem langgalde. Duk tekka du waktuhin, bang niyaˈ mapatey kaˈam, kannalanne weˈ hininangne inin kinabayaˈan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hinangde inin si kaˈam peggeˈ gaˈi kataˈuhande Samakun atawa aku. ");
INSERT INTO yka_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Saguwaˈ akahante kaˈam inin supaya bang ne tekka meˈ kabinasahan inin si kaˈam, taˈessebbi du weˈ bakas kaˈakahante kaˈam andang sabab inin.” “Gaˈ kaˈam akahanku inin tagnaˈ, peggeˈ tuˈu pe ku si kaˈam. ");
INSERT INTO yka_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Saguwaˈ kuweˈitu akahante ne kaˈam peggeˈ sōng tahalaˈ ne ku, pī balik si mamapitu akuhin. Bu gaˈ niyaˈ kaˈam nilew aku bang tunganku. ");
INSERT INTO yka_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Dukka teˈed ateybin kuweˈitu sabab bakas inakaku si kaˈam miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Saguwaˈ akahante kaˈam mabennalin, si kahāpanbi du bang ku tahalaˈ. Peggeˈ bang upama gaˈi ku tahalaˈ, gaˈi pitu si kaˈam pananabangin. Saguwaˈ bang ku tahalaˈ, papituku du iye si kaˈam. ");
INSERT INTO yka_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pagtuˈu ne si kaˈam pananabangin, pahātihanne du si meˈ manusiyaˈ si dunyahin hāti dusehin duk hāti mabentelin duk hāti hukuman Tuhanin. ");
INSERT INTO yka_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Papastiˈne si siye weˈ dusehan siye, peggeˈ gaˈi siye kahagad si aku. ");
INSERT INTO yka_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Papastiˈne si siye weˈ bentel ku, peggeˈ tapī ne ku si Samakun duk gaˈi ne ku takitebi. ");
INSERT INTO yka_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Papastiˈne si siye hukuman Tuhanin, peggeˈ tahukum ne nakuraˈ seyitan magnakuraˈ tuˈu si dunyahin. ");
INSERT INTO yka_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ekka pe akaku si kaˈam,” paˈin si Isa, “saguwaˈ gaˈi takoleˈbi bang kuweˈitu. ");
INSERT INTO yka_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pagtekka pitu Niyawa Tuhanin, iye mamagaka mabennalin, panoloˈanne du kaˈam kēmon panoloˈ mabennalin. Gaˈi iye magtoloˈ amban di pikilanne saguwaˈ ine-ine takalene amban Tuhanin, iye miyaˈan panoloˈnen. Duk akahanne du kaˈam bang ine maˈumantag si sinōngin. ");
INSERT INTO yka_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pahadje Niyawa Tuhanin du ku, peggeˈ kēmon inakahanne kaˈamin asal amban aku du. ");
INSERT INTO yka_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ine-ine si Samakun, si aku du, hangkan hep paˈinku si kaˈam weˈ kēmon inakahan Niyawa Tuhan kaˈamin amban aku du.” ");
INSERT INTO yka_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Paˈin si Isa, “Gaˈi ne tiggel, gaˈi ne ku kitebi. Saguwaˈ ubus miyaˈan, gaˈi tiggel kitebi du ku balik.” ");
INSERT INTO yka_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Magbissā-bissā sinduwe meˈ tindeg si Isahin, paˈinde, “Ine enteˈ hāti pinaˈinne inin, ‘Gaˈi tiggel gaˈi ne ku kitebi, ubus miyaˈan gaˈi tiggel kitebi du ku balik?’ Duk iye isab pinaˈinne, ‘Peggeˈ pī ku si Samakun?’ ");
INSERT INTO yka_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ine hatu hāti ‘gaˈi ne tiggel’ pinaˈinne inin? Gaˈi kataˈuhante bi bang ine hāti pinaˈinnen.” ");
INSERT INTO yka_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kataˈuhan si Isa weˈ bayaˈ iye tilew meˈ tindegnen bang ine hāti pinaˈinnen. Hangkan paˈin si Isa si siye, “Ensiniˈ paˈinku, ‘Gaˈi ne tiggel gaˈi ne ku kitebi, ubus miyaˈan gaˈi du tiggel, kitebi du ku balik.’ Magtilew-tilew ke kaˈam bang ine hāti pinaˈinku inin? ");
INSERT INTO yka_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sabennal akahante kaˈam, magtangis kaˈam iyan duk magsugul, saguwaˈ meˈ aˈa manggaˈi manuhut Tuhanin magkēg-kēg. Suse du kaˈam iyan saguwaˈ ginantiˈan du iyan duk kēg. ");
INSERT INTO yka_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Dalilnen kuweˈ dende nganak. Suse iye peggeˈ tekka ne panganaknen. Saguwaˈ pag si luwasan ne anaknen, gaˈi ne taˈessebne peddiˈ talabeynen hawal kēgnen weˈ niyaˈ nakanak palahil si dunya. ");
INSERT INTO yka_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Damikkiyan isab kaˈam, kuweˈitu suse kaˈam. Saguwaˈ magkite du kite bi balik. Manjari asal kēgan du teˈed kaˈam iyan, duk kēgbi iyan gaˈ niyaˈ makaˈānanne amban dem ateybi. ");
INSERT INTO yka_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Pagtekka ellew pagkiteten bi balik, gaˈ ne niyaˈ tilewbi ine-ine amban aku. Sabennal akahante kaˈam, ine-ine pākubi si Samakun peggeˈ sandel kaˈam si aku, duhulanne du kaˈam. ");
INSERT INTO yka_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kemuwe tagnaˈley sampay kuweˈitu gaˈ niyaˈ bakas pākubi sabab sandelbi si akuhin. Māku ne kaˈam ubus bu inurungan du kaˈam supaya jukup kēgbin.” ");
INSERT INTO yka_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Paˈin si Isa si siye, “Meˈ panoloˈku si kaˈam inin si dalilan, saguwaˈ tekka du iyan ellewin gaˈi ne ku magdalilan si kaˈam, duk akahanku ne kaˈam pabentel sabab Samakun. ");
INSERT INTO yka_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pagtekka ellew miyaˈan, bang niyaˈ pākubi, kaˈam ne mamāku amban Samakun peggeˈ sandel kaˈam si aku. Dumaˈin ne aku mamāku para si kaˈamin, ");
INSERT INTO yka_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","peggeˈ Samakun malasa du si kaˈam. Kalasahanne kaˈam peggeˈ malasa kaˈam si aku duk peggeˈ kahagadbi du weˈ pitu ku amban Tuhan. ");
INSERT INTO yka_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Aweˈ, pitu ku amban Samaku Tuhanin si dunya. Duk kuweˈitu ambananku ne dunya inin duk balik ne ku pī si Samakun.” ");
INSERT INTO yka_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Paˈin meˈ tindegnen si iye, “Kuweˈitu bentel ne pamissānun. Dumaˈin ne inin dalilan. ");
INSERT INTO yka_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kabugtuˈan kami ne kuweˈitu weˈ kataˈuhannu kēmon-kēmonin bisan kew gaˈi tinilew. Hangkan kahagad ne teˈed kami weˈ amban Tuhan kew.” ");
INSERT INTO yka_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Paˈin si Isa si siye, “Asal kahagad ne ke teˈed kaˈam kuweˈitu? ");
INSERT INTO yka_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tekka du waktuhin gaˈi ne teˈed tiggel, magsapeˈ-sapeˈ du kaˈam iyan, hap lumaˈne ne dangan-dangan duk ambananbi ku dendangan. Saguwaˈ iye matoˈohin, dumaˈin du ku dendangan peggeˈ Samakun teteg du tuˈu si aku. ");
INSERT INTO yka_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kēmon inin inaka weˈ ku si kaˈam supaya sanyang dem ateybin. Hangkan sanyang dem ateybin, peggeˈ magdambuwaˈ kaˈam duk aku. Tuˈu si dunya inin, bininasa du kaˈam weˈ meˈ aˈa manggaˈi manuhut Tuhanin. Saguwaˈ daˈa kaˈam tinalew. Daˈag ne du nakuraˈden weˈ ku.” ");
INSERT INTO yka_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagubus inin bissā si Isa, mayam iye padiyataˈ langit duk ngampun iye si Tuhan, paˈinne, “O Ammaˈ, taˈabut ne waktuhin. Pahadjehun ku, Anaknun, duk kew isab tapahadjeku. ");
INSERT INTO yka_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kaˈurungan ku weˈ nu kapatut magbayaˈ si kēmon manusiyaˈ, supaya kaˈurunganku umul gaˈ tamananne kēmon aˈa pinasukuˈnu si akuhin. ");
INSERT INTO yka_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Duk meˈ aˈa kaˈurungan umul gaˈ tamanannen, subey kew kataˈuhande, kaˈu Tuhan mabennalin, Tuhan dambuwaˈ-buwaˈin. Duk subey isab kataˈuhande Isa Almasi pinapitunu si dunyahin. ");
INSERT INTO yka_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pinahadje kew weˈ ku tuˈu si dunya peggeˈ ubus ne weˈ ku hinang pinahinangnu si akuhin. ");
INSERT INTO yka_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Ammaˈ, pahadjehun ku luˈu si panaˈanannu lu, sa pamahadje aku maluˈuhin masa gaˈ pe dunya inin pinapanjari. ");
INSERT INTO yka_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Bakas ne kew pinakitaˈu weˈ ku si meˈ aˈa pinasukuˈnu si aku tuˈu si dunyahin. Meˈ sukuˈ si kaˈu du siye, duk pinasukuˈ siye weˈ nu si aku. Tinuhut weˈ de lapalnun, ");
INSERT INTO yka_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","duk bugtuˈ ne si siye weˈ kēmon pangurungnu akuhin asal bennal amban kaˈu. ");
INSERT INTO yka_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bakas ne pasampayku si siye lapal pinangurungnu si akuhin, duk tinayimaˈ ne weˈ de. Bugtuˈ ne si siye weˈ billuˈu ku amban kaˈu, duk kahagad ne teˈed siye weˈ kaˈu asal mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“O Ammaˈ, pāku-pākuhanku siye si kaˈu. Dumaˈin manusiyaˈin kēmon pinākuhankun saguwaˈ meˈ aˈa pinasukuˈnu si aku inin hadja, peggeˈ siye inin asal sukuˈ si kaˈu du. ");
INSERT INTO yka_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kēmon si akuhin, si kaˈu du duk kēmon si kaˈuhin, si aku du. Duk pinahadje ku weˈ de, sabab sandel siye si aku. ");
INSERT INTO yka_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Aku inin sōng balik ne piyu si kaˈu. Sōng ne ambananku dunya inin. Saguwaˈ meˈ aˈa pinasukuˈnu si aku inin, tuˈu pe si dunya. O Ammaˈ, kaˈu masutsihin, pakitehannu ku balakat ēnnun; banteyanun siye duk balakatnu inin, supaya siye magdambuwaˈ atey sa kitehin. ");
INSERT INTO yka_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tiggelanku tuˈu si siye, banteyanku meˈ aˈa pinasukuˈnu si aku inin duk balakat ēnnun. Binanteyan siye weˈ ku hangkan gaˈ niyaˈ siye lepas amban kaˈu, luwal du dambuwaˈ, peggeˈ niyaˈ subey lepas supaya tuman tasulat dem kitabin. ");
INSERT INTO yka_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Sōng balik ne ku inin piyu si kaˈu hangkan pādpād tuˈu pe ku si dunya, bissāku inin supaya jukup kēgden kuweˈ kēgkun. ");
INSERT INTO yka_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Pinasampay weˈ ku si siye lapalnun. Manjari kabunsihan siye weˈ meˈ aˈa manggaˈi manuhut kaˈuhin, peggeˈ gaˈi siye nuhut pikilan meˈ aˈa miyaˈan. Kuweˈ siye akuhin, gaˈi du isab tuhutku pikilan meˈ aˈa manggaˈi manuhut kaˈuhin. ");
INSERT INTO yka_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gaˈi ku māku-māku weˈ eddoˈnu meˈ aˈa pinasukuˈnu si akuhin amban dunya inin. Saguwaˈ māku-māku ku weˈ banteyannu siye duk siye gaˈi kapagbayaˈan weˈ nakuraˈ seyitanin. ");
INSERT INTO yka_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kuweˈ siye akuhin, gaˈi siye nuhut pikilan meˈ aˈa manggaˈi manuhut kaˈuhin. ");
INSERT INTO yka_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Paseddilihun siye duk sutsihun siye. Panutsi siyehin panoloˈnu mabennalin, iye lapalnun. ");
INSERT INTO yka_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Daˈakku ne siye pī si meˈ aˈa si dunyahin, kuweˈ akuhin du isab dinaˈak weˈ nu pitu si dunya. ");
INSERT INTO yka_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Duk si kahāpande paglillaˈku umulkun si kaˈu, supaya siye teˈed meˈ aˈa sukuˈ si kaˈuhin. ");
INSERT INTO yka_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Māku-māku ku dumaˈin hadja para si meˈ tindegku inin,” paˈin si Isa, “saguwaˈ para si kēmon makahagad si aku sabab panoloˈden. ");
INSERT INTO yka_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O Ammaˈ, karayaw magdambuwaˈ atey siye kēmon; kuweˈ kaˈuhin teteg tuˈu si aku, duk aku teteg luˈu si kaˈu, damikkiyan isab karayaw teteg siye tuˈu si kite. Karayaw weˈ asal magdambuwaˈ atey siye, supaya kahagad meˈ aˈa si dunyahin weˈ asal kaˈu mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Pinahadje siye weˈ ku sa pamahadjenu akuhin, supaya siye magdambuwaˈ atey kuweˈ pagdambuwaˈ ateyten, ");
INSERT INTO yka_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","aku teteg luˈu si siye, kuweˈ kaˈuhin teteg tuˈu si aku, supaya siye kēmon asal magdambuwaˈ atey teˈed. Manjari bang asal magdambuwaˈ atey ne teˈed siye, ujud kataˈuhan meˈ aˈa si dunyahin du weˈ kaˈu mamapitu akuhin. Duk kataˈuhande du isab weˈ kalasahannu meˈ makahagad si akuhin sa pangalasanu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O Ammaˈ, pinasukuˈ weˈ nu siye kēmon si aku. Manjari iye kabayaˈankun, subey siye laˈi si aku si palaˈihankun supaya takitede pamahadjenu akuhin duk sahaya pangurungnu akuhin, peggeˈ kinalasahan ku weˈ nu gaˈ pe pinapanjari dunyahin. ");
INSERT INTO yka_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Ammaˈ, kaˈu mabentelin, bisan kew gaˈi kataˈuhan meˈ aˈa manggaˈi manuhut kaˈuhin, saguwaˈ kataˈuhante kew duk meˈ tindegku inin kataˈuhande weˈ kaˈu mamapitu akuhin. ");
INSERT INTO yka_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Bakas ne kew pinakitaˈu weˈ ku si siye, duk pakitaˈute pe kew namba, supaya lasade si saweˈden saliˈ duk lasanu si akuhin duk supaya ku teteg dem ateyde.” ");
INSERT INTO yka_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pagubus si Isa ngampun si Tuhan, tahalaˈ iye duk meˈ tindegnen pī si dambiyaˈ sapaˈ inēnan Kidron. Niyaˈ laˈi kabbun duk hap pī siye dem kabbun miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kataˈuhan si Judas antag miyaˈan peggeˈ daran hep si Isa duk meˈ tindegnen magtipun-tipun laˈi. Si Judas hep inin mamuddihan si Isahin. ");
INSERT INTO yka_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Manjari pinanduˈan weˈ si Judas meˈ sundalu bangsa Romahin duk meˈ guwaldiya langgal hadjehin pī si kabbun miyaˈan. Meˈ guwaldiya inin pinatuhut si iye weˈ meˈ Pariseohin duk meˈ nakuraˈ imamin. Magbessi siye duk maglaˈal duk magboˈo payitaˈan. ");
INSERT INTO yka_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kataˈuhan si Isa kēmon sōng maˈumantag si iyehin hangkan pī iye pasampang si siye duk paˈinne, “Sine pinihabin?” ");
INSERT INTO yka_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Paˈinde, “Piha kami si Isa, aˈa amban lahat Nasaretin.” “Aku ne hep,” paˈin si Isa. Si Judas, mamuddihan si Isahin, laˈi isab nengge-nengge duk meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pagpaˈin si Isa, “Aku ne hep,” pasuhut siye duk hebbaˈ siye. ");
INSERT INTO yka_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Manjari tilew si Isa siye balik, paˈinne, “Sine teˈ pinihabin?” Nambung siye, paˈinde, “Si Isa, aˈa amban Nasaretin.” ");
INSERT INTO yka_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Manjari paˈin si Isa, “Bakas ne kaˈam akahanku weˈ aku ne. Bang asal aku du aˈa pinihabin, na, tiyaˈ ne ku. Daˈa sakupun bi meˈ saweˈku inin.” ");
INSERT INTO yka_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Paˈinne inin supaya tuman bakas pinaˈinne si Samane, Tuhanin, paˈinne, “O Ammaˈ, gaˈ niyaˈ lepas bisan dangan meˈ aˈa pinasukuˈnu si akuhin.” ");
INSERT INTO yka_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Magbessi hep si Simon Petros. Manjari inurus weˈ ne bessinen duk pineddang weˈ ne daraˈakan imam nakuraˈin. Iye matewwaˈin tayingene kanawanin duk magtawus butas. Ēn daraˈakan inin si Malkus. ");
INSERT INTO yka_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Paˈin si Isa pu si Petros, “Isihun balik bessinun dem tagubanne. Akuhanku kēmon kabinasahan inin peggeˈ inin pinasukuˈ si aku weˈ Samakun.” ");
INSERT INTO yka_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Manjari siniggew si Isa weˈ meˈ sundaluhin duk meˈ kapitanden duk meˈ guwaldiya Yahudihin duk iningketan iye weˈ de. ");
INSERT INTO yka_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Binoˈo iye weˈ de pī pu si Annas dehellu. Si Annas inin matoˈa si Kayapas, imam nakuraˈin tahun miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Kayapas hep inin mangurung pikilan si meˈ nakuraˈ Yahudihin pagpaˈinne weˈ si kahāpande bang niyaˈ dambuwaˈ matey gantiˈ meˈ aˈahin kēmon. ");
INSERT INTO yka_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Paturul si Simon Petros pu si Isa duk dambuwaˈ isab tindegne. Tindeg si Isa dambuwaˈ inin magkilale duk imam nakuraˈin hangkan tumuhut iye pu si Isa padiyalem pī si lame lumaˈ imam nakuraˈin. ");
INSERT INTO yka_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Saguwaˈ si Petros taˈamban laˈi si bukut tarangka. Manjari paluwas balik tindeg si Isa magkilale duk imam nakuraˈin, duk maˈid iye si dende tungguˈ tarangkahin, hangkan taboˈone si Petros padiyalem si lame. ");
INSERT INTO yka_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tinilew si Petros weˈ dendehin, paˈinne, “Dumaˈin ke kew dambuwaˈ meˈ tindeg aˈa tasiggew miyaˈan?” Masuwey si Petros, paˈinne, “Dumaˈin.” ");
INSERT INTO yka_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sangem miyaˈan haggut, hangkan meˈ daraˈakanin duk meˈ guwaldiyahin magpakellum ebbut duk laˈi siye magtengge ngaliput ebbutin ngindāng. Pī isab si Petros patuhut si siye ngindāng. ");
INSERT INTO yka_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Manjari si Annas, iye bakas imam nakuraˈin, tinilew-tilew weˈ ne si Isa sabab meˈ tindegnen duk sabab pagtoloˈnen. ");
INSERT INTO yka_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nambung si Isa, paˈinne, “Luwal ku magtoloˈ si meˈ kaˈekkahan aˈa, kuweˈ dem meˈ kalanggal-langgalan duk dem langgal hadje pagtipunan kēmon meˈ Yahudihin. Gaˈ niyaˈ bakas pagtoloˈku tinapuk. ");
INSERT INTO yka_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Weˈey aku tinilewnun? Tilewun meˈ bakas makakale panoloˈkun. Tilewun siye bang ine panoloˈku si siyehin. Kataˈuhande du.” ");
INSERT INTO yka_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pagbissā si Isa inin, magtawus iye sinampak weˈ dambuwaˈ meˈ guwaldiya malaˈihin duk paˈinne pu si Isa, “Gaˈ niyaˈ addatnu. Daˈa sambunganun imam nakuraˈin sa iyan.” ");
INSERT INTO yka_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Paˈin si Isa si guwaldiyahin, “Bang salaˈ binissāku si imam nakuraˈin, akahanun kēmon aˈa si paghukuman inin bang ine masalaˈ si binissākun. Saguwaˈ bang gaˈ salaˈ binissākun, weˈey ku sampaknu?” ");
INSERT INTO yka_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Manjari dinaˈak ne si Isa weˈ si Annas binoˈo pī pu si Kayapas, imam nakuraˈin. Iningketan pe iye. ");
INSERT INTO yka_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Si Simon Petros laˈi pe nengge-nengge ngindāng. Tinilew iye weˈ meˈ saweˈne magtenggehin, paˈinde, “Dumaˈin ke kew isab tindeg aˈa miyaˈan?” Masuwey iye, paˈinne, “Dumaˈin.” ");
INSERT INTO yka_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Manjari dambuwaˈ daraˈakan imam nakuraˈin, baˈan aˈa bakas mabutas tayingene weˈ si Petrosin, missā. Paˈinne pu si Petros, “Dumaˈin ke kew bakas takiteku laˈi si kabbunley nuhut iye?” ");
INSERT INTO yka_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Masuwey balik si Petros, paˈinne, “Dumaˈin aku.” Manjari magtawus tingkowak manukin. ");
INSERT INTO yka_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Subu-subu pe binoˈo si Isa amban lumaˈ si Kayapas pī si astanaˈ gubnul bangsa Romahin, saguwaˈ gaˈ padiyalem meˈ nakuraˈ Yahudihin dem astanaˈ peggeˈ bang siye padiyalem dem lumaˈ dumaˈin Yahudi, batal siye duk gaˈi ne siye makajari palamud magjamu-jamu laˈi si Kādjaˈan Pangessebanin. ");
INSERT INTO yka_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hangkan paluwas Gubnul Pilatus pī si siye duk tilewne siye, paˈinne, “Ine panuntutanbi aˈa inin?” ");
INSERT INTO yka_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nambung siye, paˈinde, “Gaˈi boˈo kami aˈa inin pitu si kaˈu bang gaˈ niyaˈ dusene.” ");
INSERT INTO yka_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paˈin Pilatus si siye, “Kaˈam ne iye ngahukumne nuhut saraˈbin.” Nambung meˈ Yahudihin, paˈinde, “Gaˈ niyaˈ kapatut kami ngalaboˈan sine-sine hukuman pinapatey.” ");
INSERT INTO yka_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kēmon inin umantag supaya tuman bakas pinaˈin si Isahin bang saˈingge kamateynen. ");
INSERT INTO yka_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Manjari padiyalem balik si Pilatus dem astanaˈ duk dinaˈak weˈ ne si Isa binoˈo pī si iye. Paˈinne pu si Isa, “Toˈo ke weˈ kaˈu sultan bangsa Yahudihin?” ");
INSERT INTO yka_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nambung si Isa, paˈinne, “Amban di pikilannu ke manilew aku inin atawa niyaˈ ke meˈ aˈa seddili bakas ngakahan kaˈu sabab aku?” ");
INSERT INTO yka_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nambung Pilatus, paˈinne, “Weˈ Yahudi ku? Meˈ bangsanu du duk meˈ nakuraˈ imambin hep manōngan kaˈu pitu si akuhin. Weˈey, ine teˈ dusenun?” ");
INSERT INTO yka_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nambung si Isa, paˈinne, “Pagsultanankun dumaˈin tuˈu si dunya. Bang pagsultanankun tuˈu si dunya, asal nungkaˈ meˈ tindegkun duk ku gaˈi tasiggew weˈ meˈ nakuraˈ Yahudihin. Aweˈ, pagsultanankun dumaˈin tuˈu si dunya inin.” ");
INSERT INTO yka_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Paˈin Pilatus, “Bang sa iyan, sultan kew hatiˈ?” Paˈin si Isa, “Kaˈu ne magpaˈinin weˈ sultan ku. Iye sababnen hangkan ku inanakan duk hangkan ku pitu si dunya, supaya ku kapagtoloˈ sabab mabennalin. Kēmon manuhut mabennalin pakale du si aku.” ");
INSERT INTO yka_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Paˈin Pilatus, “Ine teˈ mabennalin?” Pagubus inin bissā Pilatus, paguwaˈ iye balik pī si meˈ Yahudihin duk paˈinne si siye, “Gaˈ niyaˈ takasuwaˈku jānne pangahukumanku aˈa inin. ");
INSERT INTO yka_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Saguwaˈ katagamanbin kahabaˈ taˈabut Kādjaˈan Pangessebanin, maluwas ku dambuwaˈ pilisu. Bayaˈ ke kaˈam bang paluwasku kaˈam sultan meˈ Yahudihin?” ");
INSERT INTO yka_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Magkalolop meˈ aˈahin, paˈinde, “Daˈa bang aˈa iyan. Kabayaˈan kamihin si Barabbas.” Si Barabbas inin mundu. ");
INSERT INTO yka_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Manjari dinaˈak weˈ Pilatus si Isa ilagutan. ");
INSERT INTO yka_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ubus miyaˈan ngalakal meˈ sundaluhin bāhan luhihan, hininang kuweˈ korona sultan, duk pinapī weˈ de si kōk si Isa. Pinasemmekan isab iye weˈ de juba taluk kuweˈ juba sultan. ");
INSERT INTO yka_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Manjari hininang dagey iye weˈ de. Magbalik-balik siye pī si iye nalam iye, paˈinde, “Assalamu alaikum, Sultan meˈ Yahudihin,” ubus bu pinagsampakan weˈ de. ");
INSERT INTO yka_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Manjari paluwas balik si Pilatus duk paˈinne si meˈ aˈa maˈekkahin, “Payamanun bi, boˈoku du si Isa paluwas pitu si kaˈam supaya kataˈuhanbi weˈ gaˈ niyaˈ takasuwaˈku jānne pangahukumanku iye.” ");
INSERT INTO yka_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Manjari paluwas isab si Isa, laˈi pe lakal luhihanin diyataˈ kōkne duk magjuba talukin pe iye. Paˈin Pilatus si meˈ aˈahin, “Payamanun bi aˈa inin.” ");
INSERT INTO yka_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagkite meˈ nakuraˈ imamin duk meˈ guwaldiya si langgal mahadjehin si Isa, magkalolop siye, paˈinde, “Papateyun iye. Lansangun diyataˈ olom.” Paˈin Pilatus si meˈ aˈahin, “Bayaˈ-bayaˈbi ne. Boˈohun bi iye duk kaˈam ne ngalansang iye diyataˈ olom. Saguwaˈ bang aku, gaˈ niyaˈ takasuwaˈku jānne pamapateyan iye.” ");
INSERT INTO yka_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Paˈin meˈ nakuraˈ Yahudihin si iye, “Paˈin saraˈ kamihin subey iye pinapatey peggeˈ paˈinne weˈ Anak Tuhanin iye.” ");
INSERT INTO yka_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagkale Pilatus pinaˈinde inin, pasōng ne talewnen. ");
INSERT INTO yka_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Binoˈo weˈ ne si Isa padiyalem balik dem astanaˈ bu tinilew weˈ ne, paˈinne, “Aˈa amban kew?” Saguwaˈ gaˈ nambung si Isa. ");
INSERT INTO yka_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Paˈin Pilatus si iye, “Weˈey kew gaˈi nambung? Gaˈi ke kataˈuhannu weˈ taga kapatut ku maluwas kaˈu? Duk taga kapatut ku isab ngalansang kaˈu diyataˈ olom duk kew matey.” ");
INSERT INTO yka_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nambung si Isa, paˈinne, “Bang dumaˈin Tuhanin mangurungan kaˈu kapatutin, gaˈ niyaˈ kapatutnu ngahukum aku. Hangkan hep aˈa manōngan aku pitu si kaˈuhin, pasōng hadje dusenen amban dusenun.” ");
INSERT INTO yka_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Amban miyaˈan, miha teˈed lān si Pilatus supaya tapaluwasne si Isa. Saguwaˈ magkalolop ne paˈin meˈ nakuraˈ Yahudihin, paˈinde, “Bang paluwasnu aˈa iyan, dumaˈin kew bagay Sultan Nakuraˈin. Sine-sine ngēnan dinen sultan, kuntarahanne Sultan Nakuraˈin.” ");
INSERT INTO yka_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pagkale Pilatus pinaˈinde miyaˈan, binoˈo weˈ ne si Isa paluwas duk ningkoloˈ iye si siya pangahukumanin laˈi si lugal inēnan “Lame Batu.” Bang si bissā Yahudi, ēnnen “Gabbata.” ");
INSERT INTO yka_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ellew miyaˈan ellew pagpanyap si Kādjaˈan Pangessebanin duk sōng lettu ne. Manjari pagtingkoloˈ Pilatus, paˈinne si meˈ aˈahin, “Payamanun bi, tiyaˈ ne sultanbin.” ");
INSERT INTO yka_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Saguwaˈ magkalolop meˈ aˈahin, paˈinde, “Papateyun ne. Papateyun ne. Lansangun diyataˈ olom.” Paˈin Pilatus si siye, “Ine? Bayaˈ kaˈam daˈakku ilansang diyataˈ olom sultanbin?” Nambung meˈ nakuraˈ imamin, paˈinde, “Gaˈ niyaˈ sultan kami seddili amban Sultan Nakuraˈin.” ");
INSERT INTO yka_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Manjari sinōngan ne weˈ Pilatus si Isa pī si siye duk iye talansangde diyataˈ olom pinapatey. ");
INSERT INTO yka_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Manjari ineddoˈ ne weˈ de si Isa duk binoˈo weˈ de paluwas amban puweblo. Pinapanangkit weˈ de pu si Isa olom sōng pangalansangan iyehin, tudju pī si lugal inēnan “Lahat Bungkug,” bang si bissā Yahudi, “Golgota.” ");
INSERT INTO yka_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pagtekka laˈi, ilansang si Isa weˈ meˈ sundaluhin diyataˈ olomin duk pinatengge weˈ de olomin diyataˈ bulak. Niyaˈ isab duwangan aˈa ilansang diyataˈ olomde, dangan si kanawanan si Isa duk dangan si bibanganne. ");
INSERT INTO yka_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Niyaˈ sinulat weˈ Pilatus dinaˈak weˈ ne pinapī diyataˈ olom si Isahin. Iye inin sinulatnen: “Si Isa, aˈa Nasaret, Sultan meˈ Yahudihin.” ");
INSERT INTO yka_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ekka aˈa makabatsa sulat inin peggeˈ lugal pangalansangan si Isahin tapit si Awrusalam duk sinulat inin si bissā Yahudi, si bissā meˈ aˈa Roma, duk si bissā Girik. ");
INSERT INTO yka_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Manjari hap pī meˈ nakuraˈ imamin pu si Pilatus duk paˈinde si iye, “Gaˈi tewwaˈ sinulatnu miyaˈan. Daˈa iye sulatun ‘Sultan meˈ Yahudihin’ saguwaˈ sulatun, ‘Paˈin aˈa inin weˈ iye sultan meˈ Yahudihin.’” ");
INSERT INTO yka_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nambung Pilatus, paˈinne, “Bakas tasulatkun gaˈi ne kapindahan.” ");
INSERT INTO yka_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pagubus ne ilansang weˈ meˈ sundaluhin si Isa, ineddoˈ weˈ de meˈ semmeknen duk binahagiˈ weˈ de pinaˈampat, da bahagiˈ-da bahagiˈ siye dangan. Saguwaˈ niyaˈ pe dambuwaˈ badjuˈ si Isa, gaˈ niyaˈ laˈitanne, tinennun pinadambūs. ");
INSERT INTO yka_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Paˈin meˈ sundaluhin si saweˈden, “Daˈa garette bi badjuˈ inin. Saguwaˈ magpuwaˈan hadja kite bi. Sine-sine ngandaˈag, tepe si iye badjuˈ inin.” Sabab hininang meˈ sundalu miyaˈan, tuman tasulat dem kitabin, pinaˈin laˈi, “Pagbahagiˈande semmekkun duk pagpuwaˈande badjuˈkun.” ");
INSERT INTO yka_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Laˈi si bihing olom pangalansangan si Isahin, magtengge saˈi si Isahin, duk pungtinaˈi saˈinen, duk Mariyam anda Kolopasin, duk Mariyam dende amban lahat Magdalahin. ");
INSERT INTO yka_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Takite si Isa saˈinen duk tindegne kinalasahannen laˈi. Paˈin si Isa si saˈinen, “Tindegku iyan anaknu ne.” ");
INSERT INTO yka_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Duk paˈinne si tindegne miyaˈan, “Iyan ne saˈinun.” Hangkan amban ellew miyaˈan binoˈo ne weˈ tindeg si Isa miyaˈan saˈi si Isahin pinatennaˈ si lumaˈne. ");
INSERT INTO yka_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Manjari inin, kataˈuhan si Isa weˈ kēmon pinahinang si iyehin ubus ne duk jukup ne. Manjari paˈinne, “Lekkakan ku.” Paˈinne inin supaya tuman tasulat dem kitabin. ");
INSERT INTO yka_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Niyaˈ andang laˈi binettad poga isihan ininum. Pagkale meˈ sundaluhin pinaˈin si Isahin, ngeddoˈ siye kuweˈ gapas bu ilebbagan weˈ de dem ininumin. Ubus, pinapī weˈ de si tuggu kayu-kayu bu pinaˈabut pī si behe si Isa. ");
INSERT INTO yka_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pagubus miyaˈan tasessep si Isa, paˈinne, “Ubus ne hinangkun.” Manjari patondok iye duk bekkat ne napasnen. ");
INSERT INTO yka_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Peggeˈ ellew Jumaˈat hep miyaˈan, hap pī meˈ nakuraˈ Yahudihin maˈid pu si Pilatus weˈ daˈakde ne pinolong pusuˈ meˈ aˈa tellungan ilansang diyataˈ olomin duk siye mura matey duk ne talebbes pādpād gaˈ pe taˈabut ellew liˈihin. Gaˈi siye mabayaˈ weˈ inambanan meˈ bangkeyin diyataˈ olom baytu ellew Sabtuˈ, peggeˈ ellew liˈi miyaˈan asal ellew hadje. ");
INSERT INTO yka_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hangkan pī meˈ sundaluhin duk pinolong weˈ de dehellu meˈ pusuˈ saweˈ si Isa duwangan ilansang diyataˈ olomin. ");
INSERT INTO yka_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Saguwaˈ pagtapit ne siye pu si Isa, takitede weˈ matey ne hatiˈ iye, hangkan gaˈ ne polongde pusuˈnen. ");
INSERT INTO yka_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Saguwaˈ dangan meˈ sundaluhin, ilogsok weˈ ne duk budjakne seddi si Isahin. Magtawus pabuˈus lahaˈin magsaget duk boheˈ. ");
INSERT INTO yka_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Aˈa mangite maˈumantag pu si Isa inin, sinulat weˈ ne sabab inin supaya kaˈam kahagad. Aˈa manulat inin kapangandelan duk bennal panaksiˈnen.) ");
INSERT INTO yka_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sabab meˈ maˈumantag pu si Isa miyaˈan, tuman tasulat dem kitabin. Pinaˈin laˈi, “Gaˈ niyaˈ polong bisan dambuwaˈ tolangne.” ");
INSERT INTO yka_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Duk niyaˈ isab da ayat tasulat dem kitab, pinaˈin, “Payamande du aˈa bakas ilogsokden.” ");
INSERT INTO yka_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Manjari, niyaˈ dambuwaˈ aˈa amban lahat Arimati, ēnnen si Yusup. Si Yusup inin tindeg si Isa du isab saguwaˈ gaˈ iye magpatampal peggeˈ tinalew iye si meˈ nakuraˈ Yahudihin. Pī iye pu si Pilatus duk pākune ngeddoˈ bangkey si Isahin. Dinaˈak ne iye weˈ Pilatus, hangkan pī iye duk ilebbes weˈ ne bangkey si Isahin amban diyataˈ olom. ");
INSERT INTO yka_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nuhut isab Nikodemus pu si Yusup. Iye hep aˈa bakas mapī pu si Isa sangemin. Magboˈo Nikodemus duwe bayuˈ laksiˈ ēnnen mira duk alos pinagsaget. Bohatannen niyaˈ limempūˈ kilu. ");
INSERT INTO yka_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ineddoˈ weˈ de bangkey si Isahin duk sinaput weˈ de dem kakanaˈ pinagtuhut duk laksiˈin, sa addat bangsa Yahudihin bang siye magsaput aˈa matey. ");
INSERT INTO yka_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Laˈi si antag pamapateyan si Isahin, niyaˈ kabbun. Laˈi dem kabbun miyaˈan niyaˈ lingab pangubulan, baˈahu pe, gaˈ pe bakas kapangubulan. ");
INSERT INTO yka_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Laˈi si Isa kinubul weˈ de peggeˈ tapit du si lugal pamapateyan iyehin duk peggeˈ sōng ne sangem Sabtuˈ, ellew liˈi meˈ Yahudihin. ");
INSERT INTO yka_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Subu-subu pe teˈed ellew Ahadin, lindem pe, hap pī si kubul si Mariyam, dende amban Magdalahin. Takitene weˈ bakas inānan ne batu tampeng kubulin. ");
INSERT INTO yka_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hangkan magubas iye pī ngakahan si Simon Petros duk tindeg si Isa dambuwaˈ kinalasahannen. Paˈinne si siye, “Gaˈ ne laˈi Panuhutanten bi. Niyaˈ bakas ngānanne amban dem kubul. Inday, gaˈi kataˈuhan kami bang antag pamoˈohande iyehin.” ");
INSERT INTO yka_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Manjari si Petros duk tindeg dambuwaˈin magtawus hap pī si kubul. ");
INSERT INTO yka_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Magubas siye saguwaˈ dambuwaˈin lakkes amban si Petros duk dehellu iye tekka laˈi si kubul. ");
INSERT INTO yka_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pakokkoˈ iye pasīp padiyalem kubul duk takitene saput si Isahin laˈi. Saguwaˈ gaˈ iye padiyalem. ");
INSERT INTO yka_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Manjari tekka ne si Simon Petros amban dambulihanne duk nalus pī padiyalem kubul. Takitene saputin laˈi. ");
INSERT INTO yka_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Takitene isab pīs-pīs bakas pamutus kōk si Isahin, gaˈ magdānun duk saputin saguwaˈ seddilihan dine ilikid. ");
INSERT INTO yka_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Manjari dambuwaˈin, iye madumehellu matekka si kubulin, padiyalem isab. Pagkitene saputin, kahagad iye weˈ ellum ne si Isa balik. ");
INSERT INTO yka_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Niyaˈ du tasulat dem kitab sabab si Isa weˈ subey iye ellum balik amban kamateynen, saguwaˈ gaˈ pe miyaˈan tahātide. ");
INSERT INTO yka_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Manjari hap lumaˈ ne siye. ");
INSERT INTO yka_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Saguwaˈ si Mariyam nengge-nengge ne paˈin laˈi si bihing kubul magtangis. Sasangne magtangisin, pakokkoˈ iye pasīp dem kubul. ");
INSERT INTO yka_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ngite iye duwe malaˈikat magsemmek poteˈ ningkoloˈ laˈi si antag bakas pamabākan si Isahin, dangan si antag kōkne duk dangan si antag bettisne. ");
INSERT INTO yka_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Paˈin meˈ malaˈikatin si iye, “Dende, weˈey kew magtangis?” Nambung Mariyam, paˈinne, “Peggeˈ iyuˈ ubus boˈode tahalaˈ bangkey Panuhutankun, bu gaˈi kataˈuhanku bang antag pamoˈohande iyehin.” ");
INSERT INTO yka_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pagubus inin bissāne, pahaleng iye duk takitene si Isa nengge-nengge laˈi, saguwaˈ gaˈ takilalene weˈ si Isa miyaˈan. ");
INSERT INTO yka_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Paˈin si Isa si iye, “Dende, weˈey kew magtangis? Sine pinihanun?” Kannal Mariyam weˈ aˈa miyaˈan tungguˈ kabbunin. Paˈinne si aˈahin, “Tuwan, bang kaˈu mangeddoˈ bangkey si Isahin, akahanun ku bang antag pamoˈohannu iyehin, duk ku tapī ngeddoˈne balik.” ");
INSERT INTO yka_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Paˈin si Isa si iye, “Mariyam.” Magtawus harapne si Isa duk paˈinne si bissā Yahudi, “O Rabbuni.” Hātinen, “Guru.” ");
INSERT INTO yka_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Paˈin si Isa si iye, “Daˈa ku kaputanun peggeˈ gaˈ pe ku tapoleˈ pī si Samakun. Saguwaˈ pī kew si meˈ pungtinaˈikun duk akahanun siye weˈ moleˈ ku pī si Samakun duk Tuhankun. Iye du isab Samabin duk Tuhanbin.” ");
INSERT INTO yka_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Hangkan hap pī ne Mariyam, dende amban Magdalahin, si meˈ tindeg si Isahin ngakahan siye, paˈinne, “Bakas kiteku Panuhutanten bi.” Duk inakahan ne siye weˈ ne meˈ bakas pinaˈin si Isa si iyehin. ");
INSERT INTO yka_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pagsangem ne ellew Ahad miyaˈan, magtipun meˈ tindeg si Isahin dem lumaˈ. Binagat weˈ de meˈ gawangin peggeˈ tinalew siye si meˈ nakuraˈ Yahudihin. Bessuwang si Isa nengge si tengngaˈde duk paˈinne si siye, “Karayaw sanyang dem ateybin.” ");
INSERT INTO yka_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Manjari pinakitehan weˈ ne si siye meˈ paliˈ tangannen duk paliˈ seddinen. Kēgan teˈed meˈ tindegnen pagkitede Panuhutanden. ");
INSERT INTO yka_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Paˈin si Isa balik si siye, “Karayaw sanyang dem ateybin. Kuweˈ pangandaˈak Samaku aku mapituhin, damikkiyan iye du isab pangandaˈakanku kaˈamin.” ");
INSERT INTO yka_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ubus iye missā, nihup iye pī si siye duk paˈinne, “Tayimaˈun bi ne Niyawa Sutsihin. ");
INSERT INTO yka_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bang ampunbi duse aˈahin ampun Tuhanin du isab duseden. Bang gaˈi ampunbi, gaˈi du isab ampun Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Waktu paguwaˈ si Isa si meˈ tindegne miyaˈan, baytu gaˈ laˈi si Tomas. Si Tomas inin dangan meˈ tindeg si Isa sampūˈ duk duwehin, ugey-ugeynen si Kambal. ");
INSERT INTO yka_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Manjari inakahan si Tomas weˈ de, paˈinde, “Bakas takite kami Panuhutanten bi.” Saguwaˈ paˈin si Tomas, “Bang gaˈi du takiteku duk duwe mataku inin duk tasagsadku meˈ paliˈ lansang si pat tangannen duk bang gaˈi du taˈantanku paliˈ si seddinen, asal gaˈi ku kahagad.” ");
INSERT INTO yka_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Paglabey da simana, magtipun ne isab meˈ tindeg si Isahin dem lumaˈ duk laˈi ne si Tomas. Bagat meˈ gawangin saguwaˈ bessuwang si Isa nengge si tengngaˈde duk paˈinne, “Karayaw sanyang dem ateybin.” ");
INSERT INTO yka_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Manjari paˈinne pu si Tomas, “Payamanun meˈ tangankun. Sagsadun. Pasōngun tangannun pitu duk antanun paliˈ seddikun. Daˈa ne kew duwe-duwehan. Kahagad ne kew teˈed.” ");
INSERT INTO yka_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Sambat si Tomas saˈ, “Kaˈu Panuhutankun duk kaˈu Tuhankun.” ");
INSERT INTO yka_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Paˈin si Isa si iye, “Hangkan ke kew kahagad peggeˈ takitenu ne ku? Asal kēgan teˈed meˈ makahagad si akuhin bisan ku gaˈ kitede.” ");
INSERT INTO yka_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ekka pe meˈ hinangan makaˈulaliˈ seddili tahinang si Isa si pagmatahan meˈ tindegnen, gaˈ tasulat naˈan si kitab inin. ");
INSERT INTO yka_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Saguwaˈ meˈ sinulat matuˈu inin, sinulat supaya du kahagadbi weˈ si Isa asal Almasihin ne, Anak Tuhanin, duk supaya kaˈurungan kaˈam umul salama-lama sabab sandelbi si iyehin. ");
INSERT INTO yka_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pagpuwas bang piyem bahangi, pakite ne isab si Isa balik si meˈ tindegnen laˈi si higad lamew Tiberi. Sa inin pagpakitene dinen si siye. ");
INSERT INTO yka_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Si Simon Petros laˈi miyaˈan magtuhut duk si Tomas, inēnande si Kambalin duk si Natanael, aˈa amban Kana laˈi si lahat Jalilin. Laˈi du isab nuhut siye meˈ anak si Sebedehin duk duwangan pe meˈ tindeg si Isa seddili. ");
INSERT INTO yka_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Paˈin si Simon Petros, “Tiyaˈ ku pī magpokot.” “Nuhut kami,” paˈin meˈ sinduwehin. Manjari pī ne siye duk pasakey siye si bangkaˈ. Saguwaˈ kellawan miyaˈan gaˈ niyaˈ kenna taˈeddoˈde. ");
INSERT INTO yka_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pagkellat mata ellewin, laˈi si Isa nengge-nengge si higad saguwaˈ gaˈ iye takilale weˈ meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ngalingan iye pī si siye, paˈinne, “Meˈ bagay, gaˈ ke niyaˈ taˈeddoˈbi?” “Gaˈ,” paˈinde. ");
INSERT INTO yka_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Paˈin si Isa, “Teppadanun bi pokotbin luˈu si pakanawanan bangkaˈbin duk kaˈam makaˈeddoˈ.” Hangkan tineppadan weˈ de pokotden. Gaˈ takoleˈde ngonot pokotin pī dem bangkaˈ hawal ekka kenna taˈeddoˈden. ");
INSERT INTO yka_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Manjari paˈin tindeg kinalasahan si Isahin pu si Petros, “Panuhutanin hep īˈ.” Pagkale si Simon Petros inin, inasek weˈ ne badjuˈnen peggeˈ bakas magluwas iye, bu patugpaˈ iye dem lamew hap pī pu si Isa. ");
INSERT INTO yka_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Meˈ sinduwehin musey tudju higad ngangguyud pokot pennoˈ weˈ kennahin. Tapit du siye si higad, niyaˈ du meˈ limempūˈ deppe talanen. ");
INSERT INTO yka_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pagduwaˈide si higad, ngite siye kenna tinunuˈ diyataˈ bale duk niyaˈ pan isab. ");
INSERT INTO yka_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Paˈin si Isa si siye, “Boˈohanun bi ku pitu kenna taˈeddoˈbin.” ");
INSERT INTO yka_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hangkan pī si Simon Petros dem bangkaˈ bu ilalas weˈ ne pokotin pī si higad. Pennoˈ pokotin weˈ kenna hadje, dahatus duk limempuk-tellu ekkahannen. Saguwaˈ pokotin gaˈ garet bisan du ekka teˈed isinen. ");
INSERT INTO yka_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Manjari paˈin si Isa si siye, “Dayiˈ kaˈam pitu mangan.” Gaˈ niyaˈ meˈ tindegnen makatawakkal nilew iye bang sine iye, peggeˈ kataˈuhande du weˈ iye Panuhutanden. ");
INSERT INTO yka_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Pī si Isa ngeddoˈ panin duk kennahin duk pinangurung weˈ ne si siye. ");
INSERT INTO yka_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kamintellune ne inin si Isa pakite si meˈ tindegnen kemuwe pinakellum iye balik amban kamateynen. ");
INSERT INTO yka_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pagubus siye mangan, paˈin si Isa pu si Simon Petros, “Simon, anak si Yahiya, hadje ke lasanu si akuhin amban lasa meˈ saweˈnu inin?” “Aweˈ, Tuwan,” paˈinne, “kataˈuhannu weˈ malasa ku si kaˈu.” Paˈin si Isa, “Na, ipatun meˈ aˈa sukuˈ si akuhin, kuweˈ pastul ngipat meˈ anak bili-bilinen.” ");
INSERT INTO yka_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tinilew iye weˈ si Isa kaminduwenen, paˈinne, “Simon, anak si Yahiya, malasa ke kew si aku?” “Aweˈ, Tuwan,” paˈinne, “kataˈuhannu weˈ malasa ku si kaˈu.” Paˈin si Isa si iye, “Na, pastulanun meˈ bili-bilikun, hātinen meˈ aˈa sukuˈ si akuhin.” ");
INSERT INTO yka_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kamintellunen tilew si Isa iye, paˈinne, “Simon, anak si Yahiya, malasa ke kew si aku?” Dukka si Petros peggeˈ tinilew pe iye weˈ si Isa kamintellunen, “Malasa ke kew si aku?” Nambung si Petros, paˈinne, “Tuwan, kataˈuhannu kēmon-kēmonin. Kataˈuhannu weˈ malasa ku si kaˈu.” Paˈin si Isa, “Na, ipatun meˈ bili-bilikun, hātinen meˈ aˈa sukuˈ si akuhin. ");
INSERT INTO yka_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sabennal akahante kew,” paˈin si Isa, “kabataˈnun nemmekan kew dinu, duk lumengngan kew tungan-tungan kabayaˈannu. Saguwaˈ bang bahiˈ ne kew, padeppe du kew duk seddili masemmekan kaˈuhin duk boˈone kew pī si antag gaˈi kabayaˈannu papīhan.” ");
INSERT INTO yka_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Paˈin si Isa inin pangakane bang saˈingge pamapatey si Petrosin supaya tapudji Tuhanin. Duk paˈin si Isa pe si iye, “Nuhut kew aku.” ");
INSERT INTO yka_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Manjari pahaleng si Petros duk kitene paturul tindeg kinalasahan si Isahin. Iye hep miyaˈan mapatapit pu si Isa sasangde mamangan sangemin duk manilew si Isahin, paˈinne, “Tuwan, sine teˈ sōng mamuddihan kaˈuhin?” ");
INSERT INTO yka_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pagkite si Petros tindeg si Isa dambuwaˈ inin, paˈinne pu si Isa, “Tuwan, saˈingge isab iye miyaˈan?” ");
INSERT INTO yka_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Paˈin si Isa pu si Petros, “Bang saˈupama kabayaˈankun weˈ ellum iye sampay balik ku si dunya, gaˈ niyaˈ lamudnu. Nuhut kew hadja aku.” ");
INSERT INTO yka_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Manjari bawag suwi-suwihin pī si meˈ katindegan si Isahin weˈ tindegne dambuwaˈ inin gaˈi matey. Bu paˈin, gaˈ hep si Isa magpaˈin weˈ gaˈi iye matey. Iye hadja pinaˈinnen, weˈ bang saˈupama kabayaˈannen weˈ tindegne inin ellum sampay balik iye pitu si dunya, gaˈ niyaˈ lamud si Petros. ");
INSERT INTO yka_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tindeg si Isa sinuwi-suwi inin, iye ne inin magaka-aka sabab meˈ malumabey inin, duk iye isab manulat inin kēmon. Duk kataˈuhan kami weˈ asal toˈo meˈ inakanen. ");
INSERT INTO yka_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ekka pe teˈed meˈ hinang seddili bakas tahinang si Isa gaˈ tasulat. Bang sinulat kēmon dem kitab, kumpasku gaˈi siguwe tuˈu si dunya kēmon kitab subey sinulatin. ");
INSERT INTO yka_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Sulat inin amban si Lukas pu si Teopilus. Tuwan Teopilus, si sulatku tagnaˈin, inaka weˈ ku si kaˈu kēmon hininang duk pamanoloˈ si Isahin kemuwe tagnaˈ paghinangnen ");
INSERT INTO yka_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ngeregseˈ ellew pamaˈangkat iye hap surgaˈin. Gaˈ pe iye paˈangkat, sinessaˈan weˈ ne meˈ aˈa tapeneˈne duk kawakilanne magmahalayak aka-aka mahāpin. Meˈ sessaˈne miyaˈan amban Niyawa Sutsihin. ");
INSERT INTO yka_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Puwas kamateynen, dem ampatpūˈ bahangi daran hep si Isa paguwaˈ si meˈ aˈa kawakilannen. Ekka meˈ tandaˈ pinakitehan weˈ ne weˈ asal ellum iye. Takitede iye duk missā iye si siye sabab pagbayaˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mintedde sābude magtipunin, sinessaˈan siye weˈ ne, paˈinne, “Daˈa dahuˈ kaˈam tahalaˈ amban Awrusalam. Agadun bi dahuˈ meˈ pananggup Samakun, iye bakas pinaˈinku si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Si Yahiya, boheˈ hep pamandine meˈ aˈahin. Saguwaˈ kaˈam, pamandi si kaˈamin seddili. Palabey piyem bahangi binnaˈan, pinapiyu du si kaˈam Niyawa Sutsihin.” ");
INSERT INTO yka_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Dambuwaˈ ellew, sābu si Isa magtipun duk meˈ aˈa kawakilannen, tinilew iye weˈ de, paˈinde, “Tuwan, paluhayanu ne ke kuweˈitu bangsa kami Israˈilin duk pabaliknu ne pagsultananin si kami?” ");
INSERT INTO yka_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nambung iye, paˈinne, “Gaˈi subey kataˈuhanbi sabab meˈ iyan. Samakun hadja magbayaˈin si meˈ maˈumantag si dunyahin duk bang sumiyan paˈantagne. ");
INSERT INTO yka_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Saguwaˈ inurungan du kaˈam iyan balakat pagtekka ne si kaˈam Niyawa Sutsihin. Duk kaˈam ne magaka-aka sabab akuhin laˈi si Awrusalam, si tibuˈukan lahat Yahudiya, si lahat Samariya, duk sampay si kaˈampat pidjū alam inin.” ");
INSERT INTO yka_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagubus inin bissāne, paˈangkat iye hap surgaˈ sābude mamayam-mayaman iyehin. Manjari kaˈelligan iye weˈ inalak duk gaˈ ne iye takitede. ");
INSERT INTO yka_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sābude pe mamayam-mayaman iyehin paˈangkatne padiyataˈ langitin, bessuwang niyaˈ lella duwangan nengge si bihingde magsemmek poteˈ. ");
INSERT INTO yka_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Paˈin duwanganin si siye, “O meˈ aˈa Jalil! Weˈey kaˈam tuˈu magtengge mayam padiyataˈ langit? Si Isa bakas ineddoˈ amban kaˈam binoˈo hap surgaˈin, balik du pitu kuweˈ pangitebi iye paˈangkatne hap surgaˈ miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Manjari tahalaˈ ne siye amban kūd Jaitun balik hap Awrusalam, tapit da kilumetro talahannen. ");
INSERT INTO yka_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pagtekkade laˈi si Awrusalam, nalus siye manaˈik pī si bilik patennaˈanden. Siye miyaˈan disi Petros, si Yahiya, si Yakub, si Andariyas, si Pilip, si Tomas, si Bartolome, si Mateo, si Yakub anak si Alpahin, si Simon inēnan Pangangatuhin, duk si Judas isab anak si Yakub (Yakub seddilihin). ");
INSERT INTO yka_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Luwal siye magtipun-tipun kēmon ngampun si Tuhan. Patuhut isab si siye meˈ kadendehanin, sampay si Mariyam saˈi si Isahin, duk meˈ pungtinaˈi si Isa lellahin. ");
INSERT INTO yka_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Gaˈ tiggel puwas miyaˈan, magtipun meˈ tindeg si Isahin, niyaˈ siye kulang-labi da hatus duk duwempūˈ. Manjari nengge si Petros si tengngaˈde missā. ");
INSERT INTO yka_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Meˈ kapungtinaˈihanku,” paˈinne, “subey tinumanan lapal Niyawa Sutsi pinasulatne pu si Daˈud ley. Lapal miyaˈan sabab si Judas ley, panduˈ meˈ aˈa maniggew si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Judas ley bakas dambuwaˈ hep saweˈte bi duk bakas isab iye kawakilan weˈ si Isa maghinang kuweˈ hinangte bi inin.” ");
INSERT INTO yka_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Libang helling, Tuwan Teopilus, pamelli bulak hep weˈ si Judas sīn panangdan iye si hinanganne malaˈat pamuddine si Isahin. Pagtabelline bulak miyaˈan, laboˈ iye laˈi duk matey iye. Teddak bettengnen duk paguwaˈ tinaˈinen. ");
INSERT INTO yka_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Duk bawag si kēmon aˈa mapatennaˈ si Awrusalamin sabab si Judas inin. Hangkan inēnan weˈ de bulak miyaˈan si bissāde Yahudi, Akeldama. Hātinen, “Bulak Lahaˈ.”) ");
INSERT INTO yka_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Paˈin si Petros pe, “Niyaˈ ayat tasulat si kitab Jabur, pinaˈin, ‘Subey ne patennaˈannen tinayikutan. Duk subey ne gaˈ niyaˈ patennaˈ laˈi.’ Duk niyaˈ isab seddili tasulat pinaˈin, ‘Subey niyaˈ seddili pinagantiˈ si bakas hinangnen.’ ");
INSERT INTO yka_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Hangkan hep,” paˈin si Petros, “subey niyaˈ ginellal seddili pinatuhut si kite bi naksiˈ weˈ si Isa, Panuhutanten bi, ellum ne balik. Subey iye aˈa bakas tumuhut si kite bi masa paglengngante bi duk si Isahin, tinagnaˈan amban pagpandi si Yahiyahin ngeregseˈ ellew pamaˈangkat pu si Isa hap surgaˈin.” ");
INSERT INTO yka_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Manjari duwe ēn tinaˈatde pameneˈanden. Dambuwaˈin si Yusup, inēnan du isab Barsabbas, (inēnan isab Justus) duk dambuwaˈin si Mattiyas. ");
INSERT INTO yka_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Manjari māku-māku disi Petros si Tuhan, paˈinde, “O Tuhan, kaˈu mangataˈuhan atey manusiyaˈin. Toloˈanun kami bang sine pineneˈnun tuˈu si duwangan inin, ");
INSERT INTO yka_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","supaya tahinangne hinang pinasukuˈnu si meˈ aˈa kawakilannun. Hinang inin inambanan hep weˈ si Judas duk pī iye si lugal matalep si iyehin.” ");
INSERT INTO yka_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ubus miyaˈan, magpuwaˈan siye duk ēn Mattiyasin tapuwaˈin. Hangkan pinatamba iye si meˈ aˈa kawakilan si Isa sampūˈ duk dambuwaˈin. ");
INSERT INTO yka_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pagtekka ellew ēnande Pentekostes, magtipun meˈ tindeg si Isahin kēmon si dambuwaˈ lumaˈ. ");
INSERT INTO yka_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bessuwang niyaˈ megeddu amban langit kuweˈ begeddu baliyu basag. Duk paˈasek begeddu miyaˈan magdem lumaˈ pagtingkoloˈanden. ");
INSERT INTO yka_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Manjari niyaˈ takitede kuweˈ kayat ebbut magkanat-kanat, duk pabettad pī si siye dangan-dangan. ");
INSERT INTO yka_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Manjari kēmon siye paˈasekan weˈ Niyawa Sutsihin duk nagnaˈ siye missā bayuˈ-bayuˈan bissā bangsa seddili. Kapamissā siye kuweˈ miyaˈan weˈ balakat pinangurung si siye weˈ Niyawa Tuhan mapaˈasek si siyehin. ");
INSERT INTO yka_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Masa miyaˈan niyaˈ laˈi si Awrusalam meˈ Yahudi amban meˈ kalahat-lahatan si dunya. Meˈ aˈa be-āgama teˈed siye. ");
INSERT INTO yka_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagkalede paghidjul diyalem lumaˈ pagtipunan meˈ tindeg si Isa miyaˈan, banes teˈed siye pī patipun. Ulaliˈ teˈed siye, peggeˈ takalede meˈ tindeg si Isahin missā kuweˈ bissāhanden dangan-dangan. ");
INSERT INTO yka_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bengngangan siye duk ulaliˈ teˈed, hangkan paˈinde, “Ine inin? Meˈ aˈa amban Jalil hep meˈ mamissā inin. ");
INSERT INTO yka_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Weˈey teˈ siye takalete bi makabissā bissāhanten bi dangan-dangan? ");
INSERT INTO yka_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kite bi matuˈu inin amban kalahat-lahatan tuˈu si dunya. Niyaˈ ne amban lahat Partiya, amban Midda, amban Elam; niyaˈ ne amban Mesopotamiya, amban Yahudiya, amban Kappadoke, amban Pontus, duk amban Asiya. ");
INSERT INTO yka_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Niyaˈ isab kite bi amban Pirigiya, amban Pampiliya, amban Misil, duk amban meˈ kalahatan laˈi si Libiya tapit si lahat Kirene; niyaˈ kite bi amban Roma. ");
INSERT INTO yka_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Sinduwe kite bi inin meˈ bangsa Yahudi duk sinduwe isab dumaˈin Yahudi saguwaˈ patuhut ne si āgama Yahudi. Duk niyaˈ isab kite bi amban lahat Kerete duk amban lahat Arab. Bu kēmon kite bi takalete bi siye missā si bissāhanten bi sabab meˈ hinangan mahadje hininang Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ulaliˈ teˈed siye duk gaˈi siye magkataˈu-taˈu hangkan magtilew-tinilew ne paˈin siye, paˈinde, “Ine enteˈ hātine inin?” ");
INSERT INTO yka_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Saguwaˈ niyaˈ sinduwe, hinangde hadja dagey meˈ tindeg si Isahin. Paˈinde, “Iyuˈ meˈ aˈa iyan maglangohan.” ");
INSERT INTO yka_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Saguwaˈ nengge si Petros magtuhut duk saweˈne sampūˈ duk dambuwaˈin duk missā iye pinapales, paˈinne, “Meˈ pagkasiku Yahudi duk kēmon kaˈam maglahat si Awrusalamin. Pakale kaˈam pahāp-hāp duk pahātihante kaˈam bang ine maˈumantag inin. ");
INSERT INTO yka_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kannalbi meˈ aˈa inin lango, bu dumaˈin, peggeˈ lisag siyam pe hadja salung. ");
INSERT INTO yka_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Saguwaˈ takitebi kuweˈitu inin,” paˈinne, “bakas pinaˈal weˈ Nabi Joel duk kuweˈitu tuman ne. Paˈinne, ");
INSERT INTO yka_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Iye inin hinangku si ellew dambuli,’ paˈin Tuhanin. ‘Papiyuku Niyawakun si kēmon manusiyaˈ. Duk meˈ tubuˈbin lella-dende magpalataˈ du lapalkun. Meˈ lellabi matumbuˈin niyaˈ pabagalaku si siye duk meˈ lellabi mabahiˈin niyaˈ pataginepku si siye. ");
INSERT INTO yka_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aweˈ,’ paˈin Tuhanin, ‘bisan si meˈ daraˈakankun lella-dende, papiyuku du Niyawakun si meˈ ellew īˈ duk magpalataˈ du siye lapalkun. ");
INSERT INTO yka_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Duk magpakite du ku meˈ makaˈulaliˈ diyataˈ langit, duk meˈ tandaˈ tuˈu si dunya: lahaˈ duk ebbut duk umbu subuk. ");
INSERT INTO yka_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mata ellewin,’ paˈinne, ‘ngalindem du, duk bulanin ngapeyat kuweˈ lahaˈ, bang sōng tekka ne ellew mahadje duk makaˈulaliˈin, ellew pangahukumku meˈ manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Duk sine-sine manabbut ēnkun makiˈaseˈ si aku,’ paˈin Tuhanin, ‘timbul du iye.’” ");
INSERT INTO yka_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Paˈin si Petros pe, “Meˈ pagkasiku aˈa Israˈil, pakalehun bi binissāku inin. Si Isa, aˈa Nasaretin, kataˈuhan weˈ asal sabennal iye pinapitu weˈ Tuhanin peggeˈ inurungan balakat iye weˈ Tuhanin, hangkan iye makahinang meˈ hinangan balakatan duk meˈ hinangan makaˈulaliˈ duk meˈ tandaˈ. Inin asal kataˈuhanbi peggeˈ tahinangne inin tuˈu diyalemanbi. ");
INSERT INTO yka_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tuhanin andang kataˈuhanne duk amban bayaˈne weˈ si Isa inin sinōngan pī si antananbi duk inin sakapne pu si Isahin. Duk dinaˈak weˈ bi si meˈ aˈa dusehan ilansang si Isa diyataˈ olom duk pinapatey. ");
INSERT INTO yka_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Saguwaˈ pinakellum iye balik weˈ Tuhanin. Pinaluhaya iye amban katiksaˈanne kamateynen, peggeˈ asal gaˈi kapagbayaˈ si iye kamateyin. ");
INSERT INTO yka_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tasulat hep weˈ si Daˈud sabab Isa Almasi, paˈinne, ‘Luwal talessaku Panuhutankun si bihingku. Tuˈu iye si bihingku hangkan gaˈi ku suse. ");
INSERT INTO yka_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hangkan hep kēgan ateykun duk lapalanku kēgkun. Duk bisan matey barankun, niyaˈ du ase-aseku. ");
INSERT INTO yka_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Peggeˈ gaˈi du ku ambanannu si lahat meˈ pateyin. Gaˈi du pasagadannu barankun mabuhukan. Aku inin daraˈakannu masutsihin. ");
INSERT INTO yka_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pinanoloˈan ku weˈ nu meˈ lān tudju umul salama-lamahin. Basta luˈu ku si antagnu, kēgan ku manamal.’ ");
INSERT INTO yka_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Na, meˈ kapungtinaˈihanku,” paˈin si Petros, “akahante kaˈam papastiˈ sabab papuˈten bi, Sultan Daˈud ley. Matey du iye duk kinubul, duk kubulnen tiyaˈ pe tuˈu si kite bi sampay maˈin. ");
INSERT INTO yka_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Peggeˈ nabi iye, kataˈuhanne weˈ bakas nanggup Tuhanin si iye duk napa pe weˈ si waktu sinōng niyaˈ dangan meˈ tubuˈnen magsultan du kuweˈ iyehin. ");
INSERT INTO yka_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kataˈuhan andang weˈ si Daˈud bang ine matekka si sinōngin, hangkan missā iye sabab kaˈellum Almasi balik amban kamateynen. Paˈinne weˈ gaˈ du Almasi inambanan laˈi si palaˈihan meˈ pateyin, duk gaˈ du barannen buhuk. ");
INSERT INTO yka_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Si Isa inin bakas pinakellum hep balik weˈ Tuhanin duk kami kēmon, kasaksiˈan kami weˈ inin bennal. ");
INSERT INTO yka_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pinahadje teˈed si Isa weˈ Tuhanin laˈi si kanawananne, lugal tamanan mabangsahanin. Duk sa pananggup Tuhanin, tapangurung ne si iye weˈ Samanen Niyawa Sutsihin. Manjari pinapitu weˈ ne Niyawa Sutsi inin si kami meˈ tindegnen. Duk meˈ takitebi duk takalebi kuweˈitu inin, hinangan Niyawa Sutsi bakas pinapitune si kamihin. ");
INSERT INTO yka_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Na, dumaˈin si Daˈud mapaˈangkat si surgaˈin, saguwaˈ tabissāne inin, paˈinne pe, ‘Missā Tuhanin si Panuhutankun, paˈinne: Dayiˈ kew ningkoloˈ kew tuˈu si kanawananku, tuˈu si paningkoloˈan mabangsahanin, ");
INSERT INTO yka_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","duk bettadku du meˈ bantanun diyawaˈ pat bettisnu.’ ");
INSERT INTO yka_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Hangkan hep,” paˈin si Petros, “subey teˈed kataˈuhan meˈ bangsa Israˈilin kēmon, weˈ si Isa, bakas ilansangbi diyataˈ olomin, bakas ginellal ne weˈ Tuhanin Panuhutan duk Almasi, hātinen, pineneˈ weˈ Tuhanin magbayaˈ.” ");
INSERT INTO yka_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pagkale meˈ aˈahin inin, sasew teˈed ateyden. Paˈinde pu si Petros duk si meˈ kawakilan sinduwehin, “Meˈ kapungtinaˈihan, ine subey hininang kamihin?” ");
INSERT INTO yka_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Paˈin si Petros si siye, “Pagsusunanun bi duk lebbahanun bi ne meˈ dusebin, gaˈi ne hininang-hinang balik. Duk subey kaˈam dangan-dangan pinandi, tandaˈ weˈ sandel ne kaˈam pu si Isa, supaya ampun Tuhanin meˈ dusebin. Duk pangurung Tuhanin du si kaˈam Niyawa Sutsihin, lasa-lasahanne si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Peggeˈ inin hep sanggup Tuhanin si kaˈam meˈ Yahudihin duk si meˈ tubuˈbin, duk sampay si kēmon isab si meˈ lahat matalahin, sasuku dinaˈak weˈ Panuhutanten bi Tuhanin nuhut iye.” ");
INSERT INTO yka_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ekka pe bissā si Petros si siye duk binuyuˈ-buyuˈ siye weˈ ne, paˈinne, “Tabangun bi dibin duk kaˈam gaˈi ilegga kuweˈ meˈ aˈa malaˈat kuweˈitu inin.” ");
INSERT INTO yka_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ekka kahagad si binissā si Petros miyaˈan duk pinandi siye, tandaˈ weˈ sandel ne siye pu si Isa. Ellew miyaˈan, kulang-labi tellu ngibu aˈa mapatamba si meˈ masandel pu si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sinna teˈed siye tinoloˈan weˈ meˈ aˈa kawakilan weˈ si Isahin duk magdambuwaˈ dem atey siye kēmon. Patuhut siye si meˈ masandelin magkakanan pan pangessebande kamatey si Isahin, duk patuhut isab siye ngampun-ngampun si Tuhan. ");
INSERT INTO yka_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ekka meˈ hinangan balakatan duk meˈ hinangan makaˈulaliˈ tahinang weˈ meˈ aˈa kawakilan si Isahin, hangkan tinalew teˈed meˈ aˈahin si Tuhan. ");
INSERT INTO yka_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kēmon masandel pu si Isahin magtuhut-tuhut, duk ine-ine niyaˈ si siye, magurung-inurung siye bang niyaˈ kasukalan. ");
INSERT INTO yka_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pinabellihan weˈ de meˈ alataˈden duk meˈ panyapde sinduwehin duk binahagiˈ-bahagiˈ sīnin panabangde sukal dangan-danganin. ");
INSERT INTO yka_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kahabaˈ ellew magsābu-sābu siye laˈi dem langgal hadjehin. Magtuhut siye magkakanan si meˈ kalumaˈande. Magkēg siye mamanganin duk sayuˈ siye magurung-inurung. ");
INSERT INTO yka_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Luwal pinudji weˈ de Tuhanin duk pagaddatan siye weˈ meˈ aˈahin kēmon. Duk kahabaˈ ellew niyaˈ meˈ aˈa baˈahu sandel pu si Isa, pinatamba si siye weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Dambuwaˈ ellew, hap pī si Petros duk Yahiya si langgal mahadjehin waktu asal. ");
INSERT INTO yka_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Laˈi si tarangka langgal ēnande Tarangka Mannisan, niyaˈ dambuwaˈ lella kukuˈ kemuwe amban dem betteng. Kahabaˈ ellew binoˈo iye pī si tarangka miyaˈan supaya iye kapamāku sīn si meˈ aˈa mapadiyalem si langgalin. ");
INSERT INTO yka_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pagkitene si Petros duk Yahiya sōng padiyalem, māku iye amban siye. ");
INSERT INTO yka_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pinayaman teˈed iye pahantap weˈ si Petros duk Yahiya. Manjari paˈin si Petros, “Mayam kew pitu si kami.” ");
INSERT INTO yka_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mayam ne aˈahin pī si siye ngase-ngase weˈ makasangka iye amban siye. ");
INSERT INTO yka_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Saguwaˈ paˈin si Petros, “Gaˈ niyaˈ teˈed sīnku. Saguwaˈ pangurungku kaˈu maniyaˈ si akuhin. Weˈ balakat Isa Almasi, aˈa Nasaretin, daˈakte kew lumengngan.” ");
INSERT INTO yka_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Manjari inantanan iye weˈ si Petros si tanganne kanawan pinakuwat. Magtawus ngabasag bettisnen duk mintelnen. ");
INSERT INTO yka_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Pahulangkad iye nengge duk lumengngan iye. Ubus padiyalem iye nuhut disi Petros pī dem langgal. Lumengngan iye duk maglaksuhan duk pinudji-pudji weˈ ne Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Takite iye weˈ meˈ aˈa dem langgalin kēmon, lumengngan-lengngan mudji-mudji Tuhanin ne paˈin. ");
INSERT INTO yka_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sakaliˈ takilalede weˈ iye ne hatiˈ miyaˈan aˈa bakas maningkoloˈ magpāku-pāku si Tarangka Mannisan si langgalin, bengngangan siye duk ulaliˈ teˈed siye bang weˈey ne iye kapalengngan. ");
INSERT INTO yka_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Paˈantan pe aˈahin pu si Petros duk Yahiya laˈi si ēnande Simpey Sulaiman. Manjari magubas meˈ aˈahin pī si siye laˈi magulaliˈ teˈed. ");
INSERT INTO yka_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pagkite si Petros meˈ aˈahin, missā iye si siye. Paˈinne, “O meˈ aˈa Israˈil. Weˈey kami pagulaliˈanbi? Duk weˈey kami dendenganbi? Weˈ pangannalbi balakat kami makapalengngan aˈa inin, atawa hangkan iye makalengngan sabab sutsi atey kamihin? Dumaˈin. ");
INSERT INTO yka_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kataˈuhanbi, kapapuˈanten bi disi Ibrahim, duk si Isahak, duk si Yakub, dambuwaˈ du Tuhanten bi duk siye. Manjari Tuhan inin, pinahadje weˈ ne daraˈakannen, si Isa, saguwaˈ sinōngan iye weˈ bi si saraˈ. Gaˈ iye tayimaˈbi laˈi si panaˈanan Gubnul Pilatus. Duk bisan iye batang paluwas Pilatus, gaˈi kaˈam mabayaˈ. ");
INSERT INTO yka_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Sutsi iye duk bentel, saguwaˈ gaˈ iye tayimaˈbi. Iye pinākubi pinaluwas gubnulin, dambuwaˈ aˈa bakas mapatey. ");
INSERT INTO yka_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pinapatey weˈ bi mangurung umulin, saguwaˈ pinakellum iye balik weˈ Tuhanin duk kasaksiˈan kami inin. ");
INSERT INTO yka_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na, balakat si Isa hep mangurung basag si aˈa bakas makukuˈ inin,” paˈin si Petros. “Takitebi iye duk takilalebi. Puˈunne inin kawuliˈan, sabab sandel kami pu si Isa. Aweˈ, sandel kami pu si Isahin hep makakawuliˈ aˈa inin tuˈu si matahanbi kēmon. ");
INSERT INTO yka_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Meˈ kapungtinaˈihanku,” paˈin si Petros, “kataˈuhanku weˈ hininangbi duk meˈ nakuraˈbi pu si Isahin, tahinangbi peggeˈ awam kaˈam. ");
INSERT INTO yka_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Saguwaˈ kuweˈ miyaˈan ne panuman Tuhan lapalne pinalataˈ weˈ meˈ kanabihan awwalley. Pinalataˈ weˈ de weˈ Almasihin subey teˈed makalabey kabinasahan. ");
INSERT INTO yka_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na,” paˈin si Petros, “pagsusunanun bi duk lebbahanun bi ne meˈ dusebin, duk balik ne kaˈam si Tuhan supaya ānanne meˈ dusebin. ");
INSERT INTO yka_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Manjari magkatekka du amban Tuhanin meˈ waktu pangasig ateybin, duk papitune du balik si dunya si Isa, iye Almasi tapeneˈne magbayaˈ si kaˈamin. ");
INSERT INTO yka_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Saguwaˈ subey dahuˈ iye laˈi si surgaˈ tiggelan gaˈi pe tekka ellew pamahāp meˈ kēmon-kēmonin balik kuweˈ tagnaˈin. Iye ne inin waktu bakas inaka weˈ Tuhan si meˈ kanabihanne masutsihin awwalley. ");
INSERT INTO yka_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Peggeˈ si Musa bakas missā hep si bangsa Israˈilin, paˈinne, ‘Si pasōngan, mapitu du Tuhanin si kaˈam dambuwaˈ nabi kuweˈ akuhin. Aˈa bangsabi du iye. Subey pakalebi ine-ine paˈinne si kaˈam. ");
INSERT INTO yka_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Sine-sine gaˈi pakale si nabi miyaˈan, pinasapeˈ du iye amban meˈ aˈa sukuˈ si Tuhanin duk magmula iye.’ ");
INSERT INTO yka_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Damikkiyan du isab,” paˈin si Petros, “kēmon meˈ kanabihanin, tinagnaˈan amban Nabi Samuel, bakas makabissā du sabab meˈ ellew kuweˈitu inin. ");
INSERT INTO yka_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Si kaˈam hep meˈ sanggup Tuhan pinasampay meˈ kanabi-nabihanin. Duk sakup kaˈam si janjiˈ Tuhan duk meˈ kapapuˈanbin. Ngajanjiˈ hep Tuhanin si papuˈten bi Ibrahim, paˈinne, ‘Amban tubuˈnun urunganku kahāpan kēmon manusiyaˈ si dunyahin.’ ");
INSERT INTO yka_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Hangkan tapeneˈ weˈ Tuhanin daraˈakannen, Isa Almasi duk pinapitu iye weˈ ne si kaˈam dehellu. Patayikutne kaˈam dangan-dangan amban meˈ hinanganbi malaˈatin peggeˈ mabayaˈ kaˈam urunganne kahāpan.” ");
INSERT INTO yka_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sābu disi Petros duk Yahiya pe mamissā si meˈ aˈahin, niyaˈ patudju pī si siye meˈ imam duk kapitan meˈ guwaldiya si langgal mahadje miyaˈan duk meˈ Sadduseo. ");
INSERT INTO yka_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Astel siye manamal peggeˈ disi Petros magtoloˈ si meˈ aˈahin, bugtuˈande teˈed weˈ peggeˈ ellum ne si Isa balik, ellum du isab balik meˈ pateyin si pasōngan. ");
INSERT INTO yka_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hangkan siniggew weˈ de si Petros duk Yahiya. Peggeˈ bayaˈ kohap ne miyaˈan, kinalabusu siye weˈ de sampay salung. ");
INSERT INTO yka_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Saguwaˈ ekka bakas makakale binissā disi Petrosin kahagad duk sandel ne pu si Isa. Lellahin hadja, ekkahanden niyaˈ kulang-labi lime ngibu. ");
INSERT INTO yka_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pagsasumuhin magtipun meˈ kakunsihalanin laˈi si Awrusalam. Siye miyaˈan meˈ kanakuraˈan meˈ Yahudihin, meˈ kabahiˈanin duk meˈ guru si saraˈ āgama Yahudihin. ");
INSERT INTO yka_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Laˈi isab disi Annas imam nakuraˈin, si Kayapas, duk si Yahiya, duk Iskandal, duk niyaˈ pe seddili meˈ usba imam nakuraˈin. ");
INSERT INTO yka_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Manjari dinaˈak binoˈo weˈ de si Petros duk Yahiya pī si siye. Tinilew siye weˈ de, paˈinde, “Saˈingge paghinangbi miyaˈan? Balakat ine atawa ēn sine ginunabin?” ");
INSERT INTO yka_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Manjari pagbayaˈan si Petros weˈ Niyawa Sutsihin duk nambung iye, paˈinne, “Meˈ kanakuraˈan duk meˈ kabahiˈan, ");
INSERT INTO yka_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","bang sumariyabi kami ellew inin sabab hinangan mahāp tahinang si aˈa bakas makukuˈ inin, duk bang saˈingge kakawuliˈnen, ");
INSERT INTO yka_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","na, subey kaˈam kēmon ngataˈu duk kēmon aˈa Israˈilin isab, weˈ hangkan aˈa inin nengge tuˈu si harapanbi kawuliˈan ne, sabab balakat si Isa Almasi, aˈa Nasaretin. Si Isa inin bakas dinaˈak weˈ bi ilansang diyataˈ olom, duk pinakellum iye balik weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Sabab si Isa hep pinaˈin dem kitabin, ‘Batu tinayikutanbi meˈ pandey maghinang lumaˈ batuhin peggeˈ kannalbi gaˈi taguna, kuweˈitu iye ne miyaˈan tamanan batu maniyaˈ kagunahannen.’ ");
INSERT INTO yka_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Duk asal iye hadja dendangan makatimbul kitehin bi. Peggeˈ tuˈu si tibuˈukan dunya inin, gaˈ niyaˈ seddili pangurung weˈ Tuhanin makatimbul kite bi luwal si Isa hadja.” ");
INSERT INTO yka_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Manjari, ulaliˈ teˈed meˈ kakunsihalanin pagkitede weˈ bahani si Petros duk Yahiya missā, bu siye inin meˈ aˈa pandak du pangadjiˈden duk diyawaˈ du pagaˈaden. Manjari taˈessebde ne weˈ siye inin bakas meˈ saweˈ si Isa. ");
INSERT INTO yka_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Saguwaˈ gaˈ niyaˈ tabissāde panganjawabde siye, peggeˈ laˈi ne takitede aˈa bakas makukuˈin nengge si bihing si Petros duk Yahiya. ");
INSERT INTO yka_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hangkan pinaluwas ne siye weˈ de amban bilik paghukum-hukumanin duk magisun meˈ kakunsihalanin didihande. ");
INSERT INTO yka_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ine enteˈ subey hinangte bi si meˈ aˈa inin?” paˈinde. “Bawag ne tuˈu si Awrusalam weˈ niyaˈ hinangan balakatan tahinangde. Duk inin gaˈi tapasuweyte bi. ");
INSERT INTO yka_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Saguwaˈ,” paˈinde, “supaya inin gaˈi magkasōng bawagnen, sessaˈante bi ne siye weˈ subey siye gaˈi missā sabab si Isa bisan pu sine-sine.” ");
INSERT INTO yka_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Hangkan ilinganan weˈ de balik si Petros duk Yahiya duk sinessaˈan weˈ de, gaˈi teˈed siye dinaˈak missā atawa magtoloˈ sabab si Isa. ");
INSERT INTO yka_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Saguwaˈ sinambungan siye weˈ si Petros duk Yahiya, paˈinde, “Kumpasun bi koˈ, inggehin bentel si matahan Tuhan, kaˈam tuhut kami atawa Tuhanin? ");
INSERT INTO yka_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Peggeˈ gaˈi kami makajari padeheng magaka-aka si meˈ aˈa sabab bakas takite kami duk takale kamihin.” ");
INSERT INTO yka_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Manjari tinunggaˈan pe siye weˈ meˈ nakuraˈin ubus bu pinaluwas ne siye. Gaˈ meˈ nakuraˈin kaˈaraˈ-araˈ ngalegga siye peggeˈ kēmon aˈa malaˈihin, pudjide Tuhanin sabab hinangan balakatan bakas tahinang miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Aˈa makawuliˈan weˈ hinangan balakatan miyaˈan labi ne hep ampatpūˈ tahun umulnen. ");
INSERT INTO yka_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sakaliˈ ne siye pinaluwas, hap pī si Petros duk Yahiya si meˈ saweˈden duk inaka weˈ de si siye kēmon bakas pinaˈin meˈ imam nakuraˈin duk meˈ bahiˈin. ");
INSERT INTO yka_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pagkalede inin, māku-māku siye magsumbayaˈ si Tuhan. Paˈinde, “O Tuhan, kaˈu magbayaˈ-bayaˈin duk kaˈu magpapanjari bulak duk langitin duk tahikin, sampay kēmon bayuˈ-bayuˈan diyalemnen. ");
INSERT INTO yka_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bakas pinabissā weˈ nu daraˈakannun, si Daˈud, papuˈ kamihin, duk pinanoloˈan iye weˈ Niyawa Sutsihin pamissānen, paˈinne, ‘Weˈey teˈ meˈ kabangsahan dumaˈin Yahudihin magastel. Weˈey teˈ meˈ aˈahin magisun makaˈat, bu gaˈ niyaˈ kapūsanne? ");
INSERT INTO yka_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Meˈ kasultan-sultanan si dunyahin duk meˈ nakuraˈin magpanyap duk magtipun nguntarahan Tuhanin duk Almasi, tapeneˈne magbayaˈin.’ ");
INSERT INTO yka_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“O Tuhan,” paˈinde, “bennal pinaˈin si Daˈud miyaˈan, peggeˈ tiyaˈ ne hep tuˈu magtipun si lahat Awrusalam inin meˈ Yahudihin duk meˈ aˈa dumaˈin Yahudihin isab, magtuhut duk disi Sultan Herod duk Gubnul Pontiyus Pilatus. Kuntarahande si Isa, daraˈakannu masutsihin, iye bakas ginellalnu Almasihin. ");
INSERT INTO yka_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hininang inin weˈ de peggeˈ matuˈuhin pe, amban bayaˈnu duk balakatnu, sinakap ne weˈ nu weˈ inin subey maˈumantagin. ");
INSERT INTO yka_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Duk kuweˈitu Tuhan, pakalehun meˈ tunggaˈde si kamihin. Tabanganun kami, meˈ daraˈakannun, supaya kami bahani missā lapalnun. ");
INSERT INTO yka_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pasōngun tangannun makawuliˈ meˈ masakihin duk makite kew meˈ hinangan makaˈulaliˈ duk meˈ hinangan balakatan amban balakat ēn si Isa, daraˈakannu masutsihin.” ");
INSERT INTO yka_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagubus siye māku-māku si Tuhan, jedjeg weˈ Tuhanin lumaˈ pagtipunande miyaˈan, duk pagbayaˈan siye weˈ Niyawa Sutsihin. Manjari minahalayak weˈ de lapal Tuhanin gaˈ teˈed niyaˈ talew-talewde si aˈa. ");
INSERT INTO yka_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kēmon masandel pu si Isahin magdambuwaˈ pikilan duk magtuhut diyalem atey. Ine-ine niyaˈ si dangan, gaˈ niyaˈ magpaˈin weˈ di si iye hadja miyaˈan, saguwaˈ bahagiˈanne isab meˈ saweˈnen. ");
INSERT INTO yka_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Duk meˈ kawakilanin, gaˈ siye pahali naksiˈ sabab si Isa, Panuhutanin, weˈ ellum balik, duk basag teˈed panaksiˈden. Inurungan kahāpan teˈed siye kēmon weˈ Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Gaˈ niyaˈ siye kasukalan bisan dangan peggeˈ magtekka-tekka meˈ taga bulakin atawa lumaˈin pinabellihan inin weˈ de duk binoˈo weˈ de ulinen ");
INSERT INTO yka_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","pī si meˈ kawakilanin. Duk binahagiˈ-bahagiˈ si siye sīnin panabang sukal dangan-danganin. ");
INSERT INTO yka_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na, niyaˈ aˈa laˈi si siye inēnan si Yusup, inanakan laˈi si pūˈ Kiprus. Bangsa Yahudi iye, tubuˈ si Libi. Inēnan isab iye weˈ meˈ kawakilanin si Barnabas, (hātinen, aˈa maˈasig atey). ");
INSERT INTO yka_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Si Barnabas inin, niyaˈ bulakne pinabellihan weˈ ne duk binoˈo weˈ ne ulinen pī si meˈ kawakilanin. ");
INSERT INTO yka_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Saguwaˈ niyaˈ dambuwaˈ aˈa inēnan Ananiyas. Andanen si Sappira. Pinabellihan weˈ ne niyaˈ bulakde, ");
INSERT INTO yka_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","saguwaˈ inennaˈ weˈ ne uline sinduwehin para si iye. Inin kataˈuhan weˈ andanen. Sinduwe sīnin sinōngan weˈ ne pī si meˈ kawakilanin duk paˈinne weˈ iye du miyaˈan ulinen. ");
INSERT INTO yka_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Paˈin si Petros si iye, “Ananiyas, weˈey pasagadannu nakuraˈ seyitanin magbayaˈ dem ateynu, hangkan kew magdustaˈ si Niyawa Sutsihin? Sabab inennaˈ weˈ nu uli bulaknun sinduwe. ");
INSERT INTO yka_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tiggelan gaˈ miyaˈan tapabellinu, dumaˈin ke miyaˈan si kaˈu du? Duk sakaliˈ miyaˈan tapabellinu, dumaˈin ke kaˈu du magbayaˈin bang inumey ulinen? Weˈey tapikilnu maghinang sa inin? Dumaˈin manusiyaˈ pagdustaˈannun saguwaˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pagkale Ananiyas meˈ bissā miyaˈan, magtawus iye hebbaˈ matey. Duk kēmon makakale sabab kamateyne miyaˈan, paˈasekan talew teˈed. ");
INSERT INTO yka_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Manjari padiyalem pī meˈ lella mabataˈin naput Ananiyas duk binoˈo weˈ de paluwas kinubul. ");
INSERT INTO yka_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Paglabey niyaˈ tellu ora, tekka anda Ananiyasin saguwaˈ gaˈ kataˈuhanne bang ine bakas maˈumantagin. ");
INSERT INTO yka_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Paˈin si Petros si iye, “Akahanun ku. Inin du ke halgaˈ tasangkabi ulihan bulakbin?” “Aweˈ,” paˈin dendehin, “iye du iyan ulinen.” ");
INSERT INTO yka_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Manjari paˈin si Petros, “Weˈey teˈ pagisunanbi duk ellanun weˈ suleyanbi ngakkalan Niyawa Tuhanin? Pakalehun,” paˈin si Petros, “iyuˈ ne si behe gawang meˈ bakas mangubul ellanun. Duk boˈode kew isab paluwas.” ");
INSERT INTO yka_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Magtawus dendehin hebbaˈ si antag bettis si Petros duk matey. Pagdiyalem meˈ lella mabataˈin, kasuwaˈde dendehin matey ne. Hangkan binoˈo iye weˈ de paluwas duk kinubul weˈ de si bihing ellanen. ");
INSERT INTO yka_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kēmon masandel pu si Isahin paˈasekan talew teˈed, duk damikkiyan kēmon meˈ makakale sabab bakas maˈumantag miyaˈan talew isab. ");
INSERT INTO yka_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ekka meˈ hinangan balakatan duk meˈ hinangan makaˈulaliˈ tahinang meˈ kawakilan si Isahin si diyaleman meˈ aˈa si Awrusalamin. Kēmon meˈ masandel pu si Isahin daran magtipun laˈi si Simpey Sulaiman. ");
INSERT INTO yka_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gaˈ niyaˈ meˈ aˈa sinduwehin makatawakkal patuhut laˈi si siye, bisan du siye pinagaddatan teˈed weˈ meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Saguwaˈ masi du magkatamba meˈ aˈa masandel pu si Isa, Panuhutanin, maglella-dende siye. ");
INSERT INTO yka_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sabab meˈ hinangan balakatan hininang meˈ kawakilanin, binoˈo weˈ meˈ aˈahin meˈ masakihin pī si meˈ kalān-lānan, pinabāk diyataˈ meˈ tanggungan duk diyataˈ meˈ tapo supaya bang palabey si Petros laˈi, kaw du siye sinduwe-sinduwe tewwaˈ weˈ lingewnen. ");
INSERT INTO yka_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ekka isab meˈ aˈa pī amban meˈ kalahatan mapaliput si Awrusalamin, magboˈo meˈ masakihin duk meˈ pasayedan seyitanin, duk kawuliˈan siye kēmon. ");
INSERT INTO yka_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Manjari, imam nakuraˈin duk meˈ saweˈne meˈ Sadduseo si Awrusalamin, kinimbūhan teˈed weˈ de meˈ kawakilanin. ");
INSERT INTO yka_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hangkan daˈakde siye siniggew duk kinalabusu. ");
INSERT INTO yka_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Saguwaˈ sangem miyaˈan, niyaˈ dambuwaˈ malaˈikat Tuhanin hap pī ngaluka meˈ gawang kalabusuhin maluwas siye. Paˈin malaˈikatin si siye, ");
INSERT INTO yka_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Pī kaˈam nengge dem langgal hadjehin duk akahanun bi meˈ aˈa malaˈihin sabab bang saˈingge duk siye taga umul salama-lama.” ");
INSERT INTO yka_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tinuhut weˈ de pangandaˈakan malaˈikatin duk subu-subu pe hap pī ne siye si langgal hadjehin magtoloˈ. Manjari tinawag weˈ imam nakuraˈin duk meˈ saweˈnen, dinaˈak magtipun meˈ kabahiˈan si bangsa Israˈilin. Siye inin meˈ kakunsihalanin. Ubus ngandaˈak siye meˈ pulis pī si kalabusu ngeddoˈ meˈ kawakilanin. ");
INSERT INTO yka_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Saguwaˈ pagtekka meˈ pulisin laˈi, gaˈ siye kasuwaˈde dem kalabusu. Hangkan balik siye pī si meˈ kakunsihalanin magaka. Paˈin meˈ pulisin, ");
INSERT INTO yka_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Pagtekka kami laˈi si kalabusu, bagat teˈed meˈ gawang kalabusuhin. Duk meˈ guwaldiyahin laˈi du nengge manteyan meˈ gawangin. Saguwaˈ pagluka kami meˈ gawangin, gaˈ siye kasuwaˈ kami diyalem.” ");
INSERT INTO yka_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pagtakale inin weˈ kapitan meˈ guwaldiya si langgalin duk meˈ nakuraˈ meˈ imamin, ulaliˈ teˈed siye bang ine maˈumantag si meˈ kawakilanin. ");
INSERT INTO yka_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Manjari niyaˈ aˈa tekka pī magaka si siye, paˈinne, “Meˈ aˈa bakas kinalabusubin, īˈ laˈi dem langgal hadje magusihat si meˈ aˈahin.” ");
INSERT INTO yka_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Magtawus hap pī kapitanin duk meˈ aˈanen ngeddoˈ disi Petros. Saguwaˈ gaˈ siye papeddiˈande peggeˈ talew siye kaw siye pagtibagan meˈ aˈahin duk batu. ");
INSERT INTO yka_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Binoˈo weˈ de meˈ kawakilanin pī pinaharap si meˈ kakunsihalanin. Manjari sinumariya siye weˈ imam nakuraˈin. Paˈinne, ");
INSERT INTO yka_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Bakas kaˈam sinessaˈan teˈed weˈ kami, gaˈi kaˈam dinaˈak magtoloˈ pasal aˈa panuhutanbi miyaˈan. Bu ine kew, latag ne dem Awrusalamin weˈ toloˈbi inin, duk kami pe tinuksaˈbi makamatey aˈa miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nambung si Petros duk meˈ aˈa kawakilan sinduwehin, paˈinde, “Subey iye tuhut kami pangandaˈakan Tuhanin, dumaˈin pangandaˈakan manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Si Isa miyaˈan,” paˈinde, “dinaˈak weˈ bi pinapatey ilansang diyataˈ olom. Saguwaˈ pinakellum iye balik weˈ Tuhanin, iye asal pagtuhanan meˈ kapapuˈanten bi. ");
INSERT INTO yka_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Duk pinalangkew si Isa weˈ Tuhanin pī si kanawananne, si lugal tamanan mabangsahanin. Kuweˈitu iye Panuhutanin duk iye Manimbulin, supaya meˈ aˈa Israˈilin pagsusunande duk lebbahande duseden duk siye inampun. ");
INSERT INTO yka_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Duk kami inin,” paˈin si Petros, “naksiˈ kami weˈ bennal inin kēmon. Naksiˈ du isab Niyawa Sutsihin, iye pinangurung weˈ Tuhan si kēmon manuhut meˈ pangandaˈakannen.” ");
INSERT INTO yka_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pagkale meˈ kakunsihalanin inin, astel teˈed siye hangkan kabayaˈanden weˈ pinapatey meˈ kawakilanin. ");
INSERT INTO yka_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Saguwaˈ dangan kakunsihalanin kuwat. Ēnnen Gamaliel. Dambuwaˈ iye Pariseo duk guru pandey teˈed si saraˈ āgama Yahudi, duk pagaddatan iye weˈ meˈ aˈahin kēmon. Dinaˈak weˈ ne meˈ aˈa sinumariya miyaˈan binoˈo dahuˈ paluwas. ");
INSERT INTO yka_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Manjari paˈinne si meˈ kakunsihalanin, “Kaˈam, meˈ pagkasiku bangsa Israˈil, pahatul-hatul kaˈam ine-ine sōng hinangbi si meˈ aˈa inin. ");
INSERT INTO yka_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Essebun bi weˈ gaˈ du miyaˈan tiggel, niyaˈ dambuwaˈ aˈa inēnan Tudas mahadje dine. Niyaˈ ampat hatus meˈ aˈa mapatindeg si iyehin. Saguwaˈ ujud pinapatey du si Tudas inin duk meˈ tindegnen kanat-kanat. Gaˈ du niyaˈ kaˈujudande. ");
INSERT INTO yka_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ubus si Tudas, niyaˈ isab pasunuˈ aˈa Jalil inēnan si Judas, masa paglista ēn meˈ aˈahin. Ekka isab meˈ aˈa taboˈone patuhut si iye, saguwaˈ pinapatey du isab iye duk magkanat-kanat kēmon meˈ tindegnen. ");
INSERT INTO yka_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hangkan kuweˈitu sessaˈante kaˈam sabab palkalaˈ inin,” paˈin Gamaliel. “Daˈa usaˈun bi meˈ aˈa inin. Pasagadanun bi siye. Peggeˈ bang pikilande duk hininangde inin amban manusiyaˈ, gaˈ du iyan niyaˈ pasōnganne. ");
INSERT INTO yka_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Saguwaˈ bang inin amban Tuhan, asal gaˈi siye tapagesbi. Bisan miyaˈan kaw pe kaˈam nungkaˈan Tuhanin.” Manjari pinakale weˈ meˈ kakunsihalanin panessaˈne miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tinawag weˈ de balik meˈ kawakilanin duk dinaˈak weˈ de ilagutan. Ubus sinessaˈan siye weˈ de, gaˈi teˈed siye dinaˈak missā balik pasal si Isa. Manjari pinaluwas ne siye weˈ de. ");
INSERT INTO yka_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tahalaˈ meˈ kawakilanin amban meˈ kakunsihalan miyaˈan duk kēgan teˈed siye peggeˈ kuweˈitu kinimmatan ne siye weˈ Tuhanin pataˈ magsandal kabinasahan sabab sandelde pu si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Duk kahabaˈ ellew matuyuˈ siye magusihat laˈi dem langgal hadje duk laˈi si meˈ kalumaˈan meˈ aˈahin. Duk magmahalayak ne paˈin siye aka-aka hāp sabab Isa Almasihin. ");
INSERT INTO yka_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Masa miyaˈan pagmagkaˈekka ne meˈ tindeg si Isahin, magsaggaˈ meˈ Yahudi inanakan si meˈ lahat seddilihin, bissāhanden Girik, duk meˈ Yahudi manggaˈ maˈusaˈ amban lahatden, bissāhanden Hibrani. Muggut meˈ Yahudi amban lahat seddilihin peggeˈ paˈinde weˈ meˈ kadendehande baluhin takayipat koˈ binahagiˈan sīn pagurung-urung kahabaˈ ellewin. ");
INSERT INTO yka_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Hangkan tinawag weˈ sampūˈ duk duwe kawakilanin kēmon meˈ tindeg si Isahin patipun. Duk paˈinde si siye, “Gaˈi sukat bang ambanan kami pagmahalayak lapal Tuhanin supaya kami magbahagiˈ-bahagiˈ sīn paggastuhin. ");
INSERT INTO yka_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hangkan meˈ kapungtinaˈihan,” paˈinde, “subey kaˈam meneˈ pituˈ lella amban kaˈam, meˈ aˈa asal kataˈuhanbi pagbayaˈan weˈ Niyawa Sutsihin duk lalem kataˈuden. Pasukuhan kami siye hinang inin. ");
INSERT INTO yka_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Manjari kami inin,” paˈinde, “dambūs-būs hadja ngampun si Tuhan duk magmahalayak lapal Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kasulutan kēmon tindeg si Isahin si bissāde miyaˈan. Hangkan meneˈ ne siye kēmon. Tapeneˈden si Estepan, aˈa sandel teˈed si Tuhan duk pagbayaˈan weˈ Niyawa Sutsihin. Sinduwe tapeneˈden pe disi Pilip, si Porokorus, si Nikanur, si Timon, si Parmenas, duk si Nikolas, aˈa amban Antiyok. Si Nikolas inin dumaˈin Yahudi saguwaˈ bakas patuhut iye si āgama Yahudi. ");
INSERT INTO yka_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Manjari binoˈo weˈ de aˈa pituˈ miyaˈan pī paharap si meˈ aˈa kawakilanin. Māku-māku meˈ kawakilanin si Tuhan para si aˈa pituˈ miyaˈan duk binettad weˈ de meˈ tanganden si siye, tandaˈ weˈ siye pinasukuhan hinang miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Magkasōng bawag lapal Tuhanin. Pasōng isab magkaˈekka meˈ tindeg si Isa si Awrusalamin. Ekka isab meˈ imamin sandel ne pu si Isa. ");
INSERT INTO yka_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Si Estepan miyaˈan, aˈa tinabangan teˈed weˈ Tuhanin, duk inurungan iye weˈ Tuhanin balakat, hangkan maghinang iye meˈ hinangan balakatan duk meˈ hinangan makaˈulaliˈ diyaleman meˈ aˈa si Awrusalamin. ");
INSERT INTO yka_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Saguwaˈ niyaˈ meˈ aˈa nguntarahan iye. Meˈ aˈa miyaˈan meˈ anak-apuˈ langgal inēnan Langgal meˈ Aˈa Luhaya. Siye meˈ aˈa amban lahat Kirene, amban puweblo Iskandal, amban Kilikiya, duk amban lahat Asiya isab. Jinawab weˈ de si Estepan. ");
INSERT INTO yka_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Saguwaˈ inurungan weˈ Niyawa Tuhanin si Estepan kataˈu hangkan sakaliˈ iye missā, gaˈ siye makaˈatu si iye magjawab. ");
INSERT INTO yka_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Manjari nangdan siye meˈ aˈa dinaˈak magdustaˈ sabab Estepan. Paˈin meˈ aˈa dinaˈakde magdustaˈin, “Bakas iye takale kami missā laˈatan sabab si Musa ley duk sabab Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sabab pagdustaˈde miyaˈan, kannal meˈ aˈahin weˈ asal toˈo pinaˈinde sabab Estepanin. Hangkan astel pu Estepan meˈ aˈahin, duk meˈ kabahiˈanin, duk meˈ guru si saraˈ āgama Yahudihin. Hap pī siye niggew Estepan duk binoˈo weˈ de pī si meˈ kakunsihalanin hinukum. ");
INSERT INTO yka_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Moˈo isab siye pī meˈ aˈa dinaˈak magdustaˈ sabab Estepan. Paˈin meˈ aˈa dinaˈakde magdustaˈ miyaˈan, “Aˈa inin luwal ngandiyawaˈan langgalte bi masutsi inin duk luwal isab iye missā laˈatan sabab saraˈ āgamaten bi. ");
INSERT INTO yka_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Peggeˈ bakas iye takale kami magpaˈin weˈ si Isa, aˈa Nasaret ley, larakne koˈ langgal hadje inin duk pindahanne koˈ kēmon kaˈaddatan panoloˈ si Musa kitehin bi.” ");
INSERT INTO yka_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Manjari pagkale meˈ kakunsihalanin pinaˈinde miyaˈan, mayam siye kēmon pahantap pu si Estepan. Takitede luwe Estepanin ngillap kuweˈ luwe malaˈikat. ");
INSERT INTO yka_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Manjari tinilew Estepan weˈ imam nakuraˈin, paˈinne, “Bennal ke pinaˈinde miyaˈan?” ");
INSERT INTO yka_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nambung Estepan, paˈinne, “Meˈ kapungtinaˈihanku duk meˈ kamatettoˈahan, pakalehun bi ku. Paˈessebante kaˈam sabab hininang meˈ kapapuˈante bi awwalley. Tuhan pinudjihin bakas hep pakite si papuˈten bi Ibrahim paglahatne si Mesopotamiyahin. Gaˈ pe iye miyaˈan maglahat si Haran. ");
INSERT INTO yka_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Paˈin Tuhanin si iye, ‘Ambananun lahatnu iyan duk meˈ kaˈusbahannun, duk hap pī kew si lahat panoloˈanku du kaˈu bang inggehin.’ ");
INSERT INTO yka_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hangkan tahalaˈ Ibrahim amban lahatnen duk laˈi iye maglahat si Haran. Pagmatey ne samanen, dinaˈak iye weˈ Tuhanin maglalin pitu si lahat paglahatanbi ne kuweˈitu inin. ");
INSERT INTO yka_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gaˈ pe miyaˈan Ibrahim kaˈurungan weˈ Tuhanin bisan dan dangew masagiˈ bulak lahat inin. Saguwaˈ nanggup Tuhanin weˈ pangurungne du lahat inin si iye, duk tepe si iye du duk si meˈ tubuˈnen. Pananggup Tuhan masa miyaˈan, gaˈ pe niyaˈ anak Ibrahim. ");
INSERT INTO yka_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Paˈin Tuhanin pe si iye, ‘Maglahat du meˈ tubuˈnun si lahat bangsa seddili duk laˈi hinang banyagaˈ siye duk tiniksaˈ teˈed siye weˈ bangsa miyaˈan dem ampat hatus tahun. ");
INSERT INTO yka_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Saguwaˈ leggaku du bangsa mamanyagaˈ meˈ tubuˈnun. Puwas miyaˈan, paluwasku du siye amban lahat pamanyagaˈan siye miyaˈan duk balik du siye pitu si lahat inin ngisbat aku,’ paˈin Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Manjari magjanjiˈ Tuhanin duk Ibrahim duk paˈin Tuhanin pu Ibrahim weˈ subey meˈ lellahin magislam tandaˈ weˈ pasulut siye si pagjanjiˈan miyaˈan. Hangkan paginanakan ne si Isahak, inislam iye weˈ Ibrahim kawalum bahanginen. Si Isahak isab inislam weˈ ne anaknen si Yakub, duk si Yakub inislam isab weˈ ne anakne sampūˈ duk duwehin. Siye ne inin kapapuˈan bangsate bi Yahudihin. ");
INSERT INTO yka_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Manjari,” paˈin Estepan, “si Yusup kinimbūhan weˈ meˈ sakanen, meˈ anak si Yakub sinduwehin. Hangkan pinabellihan iye weˈ de hinang banyagaˈ laˈi si lahat Misil. Saguwaˈ Tuhanin laˈi si iye. ");
INSERT INTO yka_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Pinaluwas iye weˈ Tuhanin amban kēmon kasusehan matekka si iyehin. Inurungan isab iye weˈ Tuhanin kataˈu duk sakaliˈ iye pī paharap si sultan Misilin, sinna sultanin si iye. Hangkan ginellal iye weˈ sultanin gubnul si lahat Misil miyaˈan duk pinabayaˈ iye si meˈ aˈa dem astanaˈnen. ");
INSERT INTO yka_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Manjari, niyaˈ tekka unus si tibuˈukan lahat Misil duk sampay si lahat Kanaˈan, lahat disi Yakubin. Magtiksaˈ teˈed meˈ aˈahin. Meˈ kapapuˈanten bi gaˈ niyaˈ kapamangan kasuwaˈde. ");
INSERT INTO yka_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Hangkan pagtakale si Yakub weˈ laˈi si lahat Misil niyaˈ kinakan, dinaˈak weˈ ne pī melli kapamangan meˈ anaknen, meˈ kapapuˈan bangsaten bi, duk inin tagnaˈ papīde si Misilin,” paˈin Estepan. ");
INSERT INTO yka_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","“Kaminduwede ne pī, pakilale ne si Yusup si meˈ pungtinaˈinen. Duk inakahan isab weˈ si Yusup sultanin, hangkan kataˈuhan sultanin ne meˈ kaˈusbahan si Yusupin. ");
INSERT INTO yka_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Manjari pinasan weˈ si Yusup samanen si Yakub. Dinaˈak weˈ ne si Yakub pī duk kēmon siye magtewtey-anakin hap Misil. Pitumpūˈ duk lime siye kēmon. ");
INSERT INTO yka_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Hangkan hap pī ne disi Yakub hap Misil. Matey laˈi ne si Yakub si lahat īˈ, duk laˈi du isab matey meˈ anaknen, meˈ kapapuˈan bangsaten bi ne. ");
INSERT INTO yka_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tinuranan meˈ bangkeyden pī si Sekem duk laˈi siye kinubul si pagkubulan bakas binelli weˈ Ibrahim awwalley. Binelli miyaˈan weˈ ne amban meˈ kaˈanakan si Hamor laˈi si lahat Sekem. ");
INSERT INTO yka_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Pagsōng taˈabut ne waktu pamaluwas siye amban Misilin sa pananggup Tuhan pu Ibrahimin, ekka ne teˈed bangsate bi si Misil. ");
INSERT INTO yka_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Manjari, niyaˈ pagantiˈ magsultan si lahat Misil, gaˈ kataˈuhanne sabab si Yusup. ");
INSERT INTO yka_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Inakkalan weˈ ne bangsaten bi duk bininasa manamal weˈ ne meˈ kapapuˈanten bi. Ginagahan siye dinaˈak pinaluwas meˈ anakde madikiˈ-dikiˈin amban dem lumaˈ bu inambanan duk siye ujud matey. ");
INSERT INTO yka_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Masa miyaˈan, iye panganak pu si Musahin. Nakanak hāp teˈed lella si Musa miyaˈan. Dem tellum bulan katapukan pe iye dem lumaˈ matettoˈanen. ");
INSERT INTO yka_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Puwas tellum bulan pinaluwas iye amban dem lumaˈ. Saguwaˈ takasuwaˈ iye weˈ anak sultan dayang-dayangin duk hinangne iye anak. ");
INSERT INTO yka_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kapanoloˈan si Musa kēmon pangadjiˈ bangsa Misilin duk bantu iye sabab meˈ bissānen duk meˈ hinangannen. ");
INSERT INTO yka_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Pagampatptūˈ tahun ne umul si Musahin,” paˈin Estepan, “tapikilne pī mayaman meˈ pagkasine Yahudihin, bangsa Israˈilin. ");
INSERT INTO yka_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Manjari niyaˈ takitene dambuwaˈ pinapeddiˈan weˈ aˈa bangsa Misil. Hap pī iye nabangan pagkasinen duk binalesan weˈ ne pinapatey aˈa Misilin. ");
INSERT INTO yka_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kannalne weˈ tahāti du weˈ meˈ bangsanen weˈ guna Tuhanin iye maluhaya siye, saguwaˈ gaˈ tahātide. ");
INSERT INTO yka_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pagsasumuhin, niyaˈ takitene duwangan aˈa Israˈil magsuntuk. Batang siye paghāpne. ‘Bagay,’ paˈinne, ‘saliˈ kaˈam bangsa Israˈil. Weˈey kaˈam magpapeddiˈ?’ ");
INSERT INTO yka_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Saguwaˈ aˈa mamapeddiˈin, sinōgadan weˈ ne si Musa duk paˈinne, ‘Sine mangurungan kaˈu kapatut magnakuraˈ si kamihin? Weˈey kaˈu subey mangahukum kamihin? ");
INSERT INTO yka_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Weˈ batang ku isab papateynu kuweˈ pamapateynu aˈa Misil diˈilewin?’ ");
INSERT INTO yka_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pagkale si Musa inin, talew iye peggeˈ kataˈuhan hatiˈ bakas pamapateyne aˈa Misilin. Hangkan lahi iye amban Misil duk maglahat iye si Midiyan. Paglaˈi iye, maganda iye duk anakan iye duwe lella. ");
INSERT INTO yka_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Manjari,” paˈin Estepan, “paglabey ampatpūˈ tahun tiggelan si Musa laˈi si lahat Midiyan miyaˈan, niyaˈ malaˈikat Tuhanin pabagala si iye dem kayat ebbut si poˈon puhung. Laˈi miyaˈan si lahat makagindew-gindew tapit si punu Turusina. ");
INSERT INTO yka_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ulaliˈ teˈed si Musa si takitene miyaˈan, hangkan pī iye patapit ngalilingne. Manjari takalene suwala Tuhanin amban dem ebbutin. Paˈin suwalahin, ");
INSERT INTO yka_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Aku Tuhan inisbat weˈ meˈ kapapuˈannun, si Ibrahim, duk Isahak, duk si Yakub.’ Migpid si Musa hawal talewnen duk gaˈ iye makatawakkal mayam. ");
INSERT INTO yka_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Paˈin Tuhanin si iye, ‘Luwasanun tehompaˈnun peggeˈ antag panenggehannu iyan bulak sutsi.’ ");
INSERT INTO yka_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Manjari paˈin Tuhanin pe, ‘Takiteku paminasa si meˈ aˈaku laˈi si lahat Misilin. Takaleku pamuhunden duk duwaˈi ku pitu maluwas siye. Dayiˈ kew, daˈakte kew hap Misil.’ ");
INSERT INTO yka_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Na,” paˈin Estepan, “si Musa hep inin bakas tinayikutan meˈ aˈa Israˈilin. Jinampa iye weˈ de. Paˈinde si iye, ‘Sine mangurungan kaˈu kapatut magnakuraˈ si kamihin? Weˈey kaˈu subey mangahukum kamihin?’ Si Musa hep dinaˈak Tuhan magnakuraˈin duk mamaluhaya meˈ kapapuˈanten bi,” paˈin Estepan. “Duk tinabangan iye weˈ malaˈikat takitene si poˈon puhung makayatin. ");
INSERT INTO yka_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Binoˈo weˈ ne meˈ kapapuˈanten bi, meˈ bangsa Israˈilin, paluwas amban Misil, lahat pamanyagaˈan siyehin. Maghinang iye meˈ hinangan balakatan duk meˈ hinangan makaˈulaliˈ laˈi si Misil duk laˈi si Tahik Peyat, duk damikkiyan laˈi dem lahat makagindew-gindewin dem ampatpūˈ tahun. ");
INSERT INTO yka_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Si Musa ne inin bakas magpaˈin si meˈ kapapuˈanten bi, bangsa Israˈil, ‘Si pasōngan mapiyu du Tuhanin si kaˈam dambuwaˈ nabi kuweˈ akuhin, duk aˈa bangsabi du iye.’ ");
INSERT INTO yka_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Si Musa ne inin,” paˈin Estepan, “malaˈi magtuhut duk meˈ kapapuˈanten bi dem lahat makagindew-gindew īˈ. Duk laˈi isab iye duk malaˈikat mamissā si iye diyataˈ punu Turusinahin. Iye makasangka meˈ lapal Tuhan mangurung umulin supaya tapangurungne si kite bi. ");
INSERT INTO yka_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Saguwaˈ meˈ kapapuˈanten bi,” paˈin Estepan, “gaˈ siye mabayaˈ patuhut pu si Musa. Tinayikutan iye weˈ de duk kabayaˈanden weˈ tabalik siye pī si lahat Misil. ");
INSERT INTO yka_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Manjari peggeˈ tiggel si Musa laˈi diyataˈ punu, paˈinde pu si Harun, ‘Hinanganun kite bi meˈ tuhan-tuhan duk siye padehellu moˈo kite bi. Gaˈi kataˈuhante bi bang ine ne maˈumantag pu si Musa bakas mamoˈo kite bi paluwas amban Misilin.’ ");
INSERT INTO yka_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Masa miyaˈan hep,” paˈin Estepan, “pangahinangde limbagan si bantuk anak sapiˈin. Magkuluban siye si limbagan miyaˈan duk maglami-lami siye pamahadjede hinangan bakas tanganden. ");
INSERT INTO yka_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hangkan hep tinayikutan siye, meˈ bangsa Israˈilin, weˈ Tuhanin. Duk pinasagadan siye weˈ ne numba meˈ poteˈan diyataˈ langitin. Inin pinasulat weˈ Tuhan dem kitab kanabihanin, pinaˈin, ‘O meˈ aˈa Israˈil,’ paˈin Tuhanin. ‘Dumaˈin hep si aku pagkulubananbi meˈ hayep sinumbaliˈbi dem ampatpūˈ tahun kalaˈibi dem lahat makagindew-gindewin. ");
INSERT INTO yka_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Saguwaˈ iye binoˈo-boˈobin pangennaˈanbi limbagan tuhanbin si Molok, duk limbagan bantuk poteˈan tuhanbin si Rompa. Siye meˈ limbagan hininang weˈ bi panumbahanbi. Hangkan patahalaˈte du kaˈam hap pī si dambiyaˈan lahat Babilon.’ ");
INSERT INTO yka_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Laˈi si lahat makagindew-gindew īˈ,” paˈin Estepan, “niyaˈ lumaˈ kuwit hayep panambahayangande Tuhanin peggeˈ si lumaˈ miyaˈan panaˈanan Tuhanin. Hininang lumaˈ miyaˈan sa pangandaˈakan Tuhan si Musahin, ilekkat bakas pinakitehan si iyehin. ");
INSERT INTO yka_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Manjari lumaˈ miyaˈan inambanan weˈ de si meˈ tubuˈde magpangkat-mamangkatin. Duk binoˈo miyaˈan weˈ meˈ kapapuˈanten bi padiyalemde duk si Yussaˈ mapitu si lahat inin, pagubus ne patahalaˈ Tuhanin meˈ kabangsa-bangsahan seddili maglahat matuˈuhin. Duk lumaˈ miyaˈan tuˈu pe sampay masa pagsultan si Daˈudin. ");
INSERT INTO yka_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kasulutan Tuhanin pu si Daˈud. Maˈid si Daˈud ngahinang lumaˈ para si Tuhanin, iye isab asal pagtuhanan papuˈten bi, si Yakub. ");
INSERT INTO yka_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Saguwaˈ iye mangahinangan Tuhan lumaˈin, si Sultan Sulaiman. ");
INSERT INTO yka_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Saguwaˈ Tuhan Tamanan Malangkewin,” paˈin Estepan, “gaˈi patennaˈ dem meˈ lumaˈ hinangan manusiyaˈ. Bakas tasulat weˈ dambuwaˈ nabi pinaˈin Tuhanin. Paˈinne, ");
INSERT INTO yka_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Surgaˈin siya paningkoloˈanku magsultanin. Duk dunyahin pahalihan bettiskun. Gaˈ niyaˈ lumaˈ tahinangbi patennaˈanku, duk gaˈ isab niyaˈ tahinangbi pahalihanku,’ paˈin Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","‘Peggeˈ aku du mangahinang langit duk dunyahin.’” ");
INSERT INTO yka_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Manjari paˈin Estepan si meˈ kakunsihalanin duk si meˈ aˈahin, “Tuwas pahāp kōkbi iyan. Ateybin atey gaˈi nuhut Tuhan. Duk bisu pahāp meˈ tayingebi iyan. Gaˈi pakalebi lapal Tuhanin. Kuweˈ du kaˈam meˈ kapapuˈanbi masaley. Gaˈi du isab pakalebi Niyawa Sutsihin. ");
INSERT INTO yka_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Niyaˈ ke bisan dambuwaˈ nabi gaˈ bininasa weˈ meˈ kapapuˈanbin? Gaˈ. Pinapatey weˈ de masa awwalley meˈ aˈa dinaˈak Tuhan malataˈ sabab papitu daraˈakanne mabentelin. Duk pagtapitu ne daraˈakanne miyaˈan, pinagbuddihan iye weˈ bi duk pinapatey weˈ bi. ");
INSERT INTO yka_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kaˈam iyan, kaˈam ne makasangka saraˈ Tuhan amban malaˈikatin, saguwaˈ kaˈam ne manggaˈi manuhut saraˈin.” ");
INSERT INTO yka_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pagkale meˈ kakunsihalanin pinaˈin Estepan miyaˈan, astel teˈed siye duk pagtageˈotde meˈ impenden hawal astelden. ");
INSERT INTO yka_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Saguwaˈ Estepan pagbayaˈan weˈ Niyawa Sutsihin; mayam iye padiyataˈ langit duk takitene sahaya Tuhanin duk si Isa nengge si kanawanan Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Payamanun bi,” paˈin Estepan. “Takiteku luka surgaˈin duk takiteku si Isa, Anak Manusiyaˈin, nengge si kanawanan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Saguwaˈ magellang meˈ aˈahin papales. Tinampengan weˈ de meˈ tayingeden duk gaˈi takalede binissā Estepanin. Duk magtawus siye kēmon pī nudju iye. ");
INSERT INTO yka_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Pinaglalasan iye weˈ de pī si luwasan puweblo Awrusalam miyaˈan. Manjari paglaˈi si luwasan tinagnaˈan ne weˈ de pinagtibagan si Estepan duk batu. Meˈ aˈa manaksiˈin, hātinen meˈ manibag iye duk batuhin, iluwasan weˈ de meˈ badjuˈden duk binettad weˈ de si antag bettis dambuwaˈ lella bataˈ inēnan si Saul. ");
INSERT INTO yka_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sasang si Estepan pinagtibagan weˈ de, nabbut iye si Panuhutanin, paˈinne, “O Isa, Panuhutankun, tayimaˈun niyawakun.” ");
INSERT INTO yka_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Manjari nengge iye duk tuˈutne duk ngalingan iye papales, paˈinne, “O Tuhan, daˈa siye leggahun sabab dusede inin.” Pagubus inin paˈinne, magtawus iye matey. ");
INSERT INTO yka_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Kinubul si Estepan weˈ meˈ aˈa be-āgama. Magmatey siye duk magtangis sabab iye. Puwas hadja kamatey Estepanin, tinagnaˈan ne paminasa si meˈ masandel pu si Isa si Awrusalamin. Sabab miyaˈan, kēmon katindegan si Isahin kanat-kanat si meˈ kalahat-lahatan laˈi si Yahudiya duk si lahat Samariya. Luwal du meˈ kawakilan sampūˈ duk duwehin manggaˈ maˈusaˈ amban Awrusalamin. ");
INSERT INTO yka_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Duk si Saul miyaˈan, bininasa teˈed weˈ ne meˈ aˈa masandel pu si Isahin. Inasekan weˈ ne meˈ kalumaˈanden dambuwaˈ-dambuwaˈ, duk siniggew weˈ ne siye lella-dende, duk kinalabusu weˈ ne. ");
INSERT INTO yka_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Meˈ masandel pu si Isa makanat-kanatin, ilatag weˈ de kalahatanin duk minahalayak weˈ de aka-aka mahāp sabab si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Pilip hap pī si dambuwaˈ puweblo laˈi si Samariya. Magmahalayak iye laˈi si meˈ aˈahin sabab Almasi, pineneˈ Tuhan magbayaˈin. ");
INSERT INTO yka_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Meˈ aˈa mabanesin pakale teˈed si meˈ binissā si Pilipin, duk takite weˈ de meˈ hinangan balakatan hininangnen. ");
INSERT INTO yka_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ekka meˈ aˈa paguwaˈan meˈ seyitan. Magkilahap meˈ seyitanin papales sakaliˈ siye paluwas. Duk ekka meˈ aˈa matey baranden duk meˈ kukuˈ kawuliˈan. ");
INSERT INTO yka_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Hangkan kēgan teˈed meˈ aˈa si puweblo miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Niyaˈ aˈa maglahat laˈi si puweblo miyaˈan inēnan si Simon. Dambuwaˈ iye landungan duk ulaliˈ teˈed meˈ aˈa Samariyahin sabab meˈ hininangnen. Paˈin si Simon miyaˈan weˈ dambuwaˈ koˈ iye aˈa balakatan. ");
INSERT INTO yka_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kēmon meˈ aˈa si lahat miyaˈan, diyawaˈ ke atawa langkew pagaˈanen, asal pakale teˈed si iye. Paˈin meˈ aˈahin sabab si Simon miyaˈan, “Iye ne hatu inin taga balakat amban Tuhanin ēnande ‘Balakat Mahadjehin.’” ");
INSERT INTO yka_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tiggel ne pagulaliˈde sabab meˈ hinangnen hangkan pinakale teˈed iye weˈ de. ");
INSERT INTO yka_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Saguwaˈ pagkahagad ne meˈ aˈa miyaˈan si aka-aka mahāp minahalayak si Pilip sabab pagbayaˈ Tuhanin duk sabab Isa Almasihin, manjari pinandi siye lella-dende tandaˈ weˈ siye sukuˈ pu si Isa ne. ");
INSERT INTO yka_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Bisan si Simon kahagad isab. Duk pagubus iye pinandi, luwal ne iye nuhut-nuhut si Pilip. Ulaliˈ teˈed iye pagkitene meˈ hinangan balakatan duk makaˈulaliˈ hininang si Pilipin. ");
INSERT INTO yka_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Manjari takale weˈ meˈ kawakilan malaˈi si Awrusalamin weˈ kinahagad ne weˈ meˈ aˈa Samariyahin lapal Tuhanin. Hangkan dinaˈak weˈ de si Petros duk Yahiya hap Samariya. ");
INSERT INTO yka_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pagtekkade laˈi, māku-māku siye si Tuhan para si meˈ masandel pu si Isahin supaya siye paˈasekan weˈ Niyawa Sutsihin. ");
INSERT INTO yka_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Peggeˈ gaˈ pe hep Niyawa Sutsihin bakas paduwaˈi pī si siye bisan dangan. Saguwaˈ bakas hadja siye pinandi tandaˈ weˈ siye sukuˈ pu si Isa. ");
INSERT INTO yka_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ubus binettad weˈ si Petros duk Yahiya tanganden pī si meˈ aˈa Samariya masandelin. Manjari paˈasekan ne siye weˈ Niyawa Sutsihin. ");
INSERT INTO yka_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pagkite si Simon weˈ pinangurung Niyawa Sutsihin si meˈ aˈahin pagbettad meˈ kawakilanin tanganden si siye, pī iye nōngan si Petros duk Yahiya pilak. ");
INSERT INTO yka_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Paˈinne si siye, “Urunganun bi ku isab balakatbi iyan supaya bang bettadku meˈ tangankun bisan pu sine, paˈasekan du iye weˈ Niyawa Sutsihin.” ");
INSERT INTO yka_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Sambungan si Petros iye, paˈinne, “Kamulkaˈan kew sampay pilaknu iyan. Weˈ kannalnu tabellinu balakat pangurung Tuhanin? Gaˈi. ");
INSERT INTO yka_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gaˈ niyaˈ sukuˈnu atawa lamudnu tuˈu si hinang kami inin,” paˈin si Petros, “peggeˈ ateynun gaˈi bentel si matahan Tuhan. ");
INSERT INTO yka_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hangkan pagsusunanun ne tapikilnu malaˈat iyan duk māku kew ampun si Tuhan, kaw du ampunne tapikilnu malaˈat iyan. ");
INSERT INTO yka_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Peggeˈ tahātiku,” paˈin si Petros, “weˈ asal ngimbū kew teˈed duk kuweˈ kew banyagaˈ dusenun.” ");
INSERT INTO yka_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Manjari paˈin si Simon pu si Petros duk Yahiya, “Māku-māku kaˈam si Tuhan para si aku, supaya gaˈi du tekka si aku suknaˈbi miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Minahalayak pe weˈ si Petros duk Yahiya lapal Tuhanin si meˈ aˈa malaˈihin duk naksiˈ siye sabab si Isa. Puwas miyaˈan balik siye hap Awrusalam. Sābude si lān, padeheng siye si meˈ kalumaˈan si Samariya duk minahalayak weˈ de laˈi aka-aka mahāp sabab si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Manjari niyaˈ dambuwaˈ malaˈikat Tuhanin missā pu si Pilip. Paˈinne, “Magmemes kew. Hap pī kew si lān amban Awrusalam tudju Gasaley.” (Lān inin gaˈi ne tantu ginuna kuweˈitu.) ");
INSERT INTO yka_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Hangkan magmemes ne si Pilip duk hap pī ne iye. Paglaˈi ne iye si lān miyaˈan, ngite iye dambuwaˈ aˈa bangsa Etiyopiya bakas amban Awrusalam ngisbat Tuhanin. Aˈa inin bagellal bangsahan, duk iye mangantanan pangalataˈ sultan dende magbayaˈ si lahat Etiyopiyahin. Aˈa inin kapun. ");
INSERT INTO yka_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kuweˈitu lengngan moleˈ ne iye amban Awrusalam duk laˈi iye ningkoloˈ diyataˈ kalesane matsa-matsa kitab sinulat weˈ Nabi Isaya. ");
INSERT INTO yka_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Paˈin Niyawa Sutsihin pu si Pilip, “Patapit kew pī paˈabey si kalesa miyaˈan.” ");
INSERT INTO yka_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Magubas ne si Pilip pī patapit duk takalene aˈahin matsa-matsa amban kitab sinulat weˈ Nabi Isayahin. Tilew si Pilip iye, paˈinne, “Tahātinu ke binatsanu iyan?” ");
INSERT INTO yka_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nambung bagellalin, “Saˈingge pakahātikun bang gaˈ niyaˈ magpahāti si aku?” Duk daˈakne si Pilip pasakey pī ningkoloˈ si bihingne. ");
INSERT INTO yka_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Meˈ ayat binatsanen inin: “Kuweˈ iye bili-bili nuhut hadja bang binoˈo sinumbaliˈ. Kuweˈ iye anak bili-bili gaˈi bisan mabehe bang inurutan bulu. Gaˈ iye bisan kebbutan. ");
INSERT INTO yka_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Diniyawaˈan iye duk gaˈ iye hinukum duk hukuman bentel. Sine saˈ makapagaka-aka sabab meˈ tubuˈnen? Gaˈ niyaˈ. Peggeˈ umulne si dunya inin magtamanan ne.” ");
INSERT INTO yka_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Manjari paˈin bagellalin pu si Pilip, “Akahanun ku. Sabab sine be binissā nabi inin? Sabab dine ke atawa sabab aˈa seddili?” ");
INSERT INTO yka_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Manjari missā si Pilip. Duk tinagnaˈan amban meˈ ayat bakas binatsa miyaˈan, sinuwi-suwihan iye weˈ si Pilip aka-aka mahāp sabab si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Duk sābude mapalanjal si lānin, tekka siye si kaniyaˈan boheˈ. Paˈin bagellalin, “Payamanun, niyaˈ boheˈ tuˈu. Makajari ke ku pinandi tandaˈ weˈ sukuˈ pu si Isa ne ku?” ( ");
INSERT INTO yka_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Paˈin si Pilip si iye, “Makajari kew pinandi bang kahagad kew pu si Isa dambūs-būs ateynun.” Nambung iye, paˈinne, “Aweˈ, asal kahagad ku weˈ Isa Almasi Anak Tuhanin.”) ");
INSERT INTO yka_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Manjari daˈak bagellalin pinadeheng kalesahin si meˈ aˈanen. Duwaˈi siye duwangan pī dem boheˈ duk pinandi ne iye weˈ si Pilip. ");
INSERT INTO yka_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pagguwaˈde amban boheˈ, bessuwang si Pilip binoˈo weˈ Niyawa Tuhanin tahalaˈ. Gaˈ ne iye kite bagellalin balik saguwaˈ palanjal ne bagellalin kēgan manamal. ");
INSERT INTO yka_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Bu si Pilip inin, īˈ ne iye laˈi si lahat Asotus. Minahalayak weˈ ne aka-aka mahāpin si meˈ kalumaˈan malaˈihin duk si kēmon kalahatan palabeyannen sampay tekka iye si lahat Kesarea. ");
INSERT INTO yka_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sābu miyaˈan, si Saul isab gaˈ dehenganne pamantane duk panunggaˈne meˈ tindeg si Isa, Panuhutanin. Pī iye si imam nakuraˈin ");
INSERT INTO yka_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","duk māku iye meˈ sulat boˈone si meˈ kalanggal-langgalan Yahudi laˈi si puweblo Damaskus. Meˈ sulat miyaˈan ngurungan iye kapatut. Bang niyaˈ kasuwaˈne laˈi meˈ aˈa manuhut toloˈ Isa Almasihin, makajari siye siggewne lella-dende binoˈo balik pī si Awrusalam kinalabusu. ");
INSERT INTO yka_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Manjari, sābu laˈi iye si lān tapit ne si Damaskus, bessuwang niyaˈ sahaya amban langit sinag paliput si iye. ");
INSERT INTO yka_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Magtawus iye hebbaˈ diyataˈ bulak. Manjari makakale iye suwala missā si iye. Paˈin suwalahin, “O Saul, Saul. Weˈey ku binasanu?” ");
INSERT INTO yka_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nambung si Saul, paˈinne, “Sine kew, Tuwan?” “Si Isa ku,” paˈin suwalahin. “Aku hep bininasanun. ");
INSERT INTO yka_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saguwaˈ kuwat kew,” paˈinne, “duk pī ne kew dem puweblo miyaˈan. Inakahan du kew laˈi bang ine subey hininangnun.” ");
INSERT INTO yka_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Meˈ saweˈ si Saul maglengnganin, nengge laˈi bengngangan. Takalede suwalahin saguwaˈ gaˈ niyaˈ aˈa takitede. ");
INSERT INTO yka_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Manjari kuwat ne si Saul amban diyataˈ bulak saguwaˈ paglukane matanen, gaˈi ne iye ngite. Hangkan tinundan ne iye weˈ de hap pī si Damaskus. ");
INSERT INTO yka_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tellum bahangi gaˈi iye makakite duk gaˈ iye mangan atawa nginum. ");
INSERT INTO yka_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Laˈi si Damaskus niyaˈ tindeg Isa Almasi inēnan Ananiyas. Pabagala si iye si Isa duk paˈin si Isa, “O Ananiyas.” “Weˈey, Tuwan?” paˈinne. ");
INSERT INTO yka_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Paˈinne pu Ananiyas, “Kuwat kew. Pī kew si kalsara inēnan Kalsara Tiludley duk tilewun laˈi si lumaˈ si Judas sabab dambuwaˈ aˈa amban Tarsus inēnan si Saul. Īˈ iye sasang ngampun-ngampun. ");
INSERT INTO yka_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Bakas pinakite ne weˈ ku si iye bang ine sōng hininangnu si iyehin. Kuweˈ du kew takitene padiyalem pī mettad meˈ tangannun si iye supaya iye ngite balik.” ");
INSERT INTO yka_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Saguwaˈ nambung Ananiyas, paˈinne, “Allo, Tuwan, ekka ne bakas ngakahan aku sabab si Saul miyaˈan. Laˈatan teˈed meˈ hininangne si meˈ tindegnu si Awrusalamin. ");
INSERT INTO yka_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Duk tiyaˈ iye tuˈu si Damaskus kuweˈitu iban kapatutne amban meˈ nakuraˈ meˈ imamin niggew kēmon meˈ mangampun si kaˈuhin.” ");
INSERT INTO yka_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Saguwaˈ paˈin si Isa, Panuhutanin, pu Ananiyas, “Pī kew, peggeˈ tapeneˈku ne si Saul maghinang si aku. Iye magaka-aka sabab akuhin pī si meˈ kabangsa-bangsahan dumaˈin Yahudi, duk si meˈ kasultananden, duk si meˈ bangsa Yahudi du isab. ");
INSERT INTO yka_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Duk pakitehanku du si iye kēmon subey sinandalannen sabab panuhutne akuhin,” paˈin Panuhutanin. ");
INSERT INTO yka_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hangkan hap pī ne Ananiyas duk padiyalem iye pī dem lumaˈ si Judas. Binettad weˈ ne meˈ tangannen laˈi pu si Saul duk paˈinne, “Saul, pungtinaˈite kew. Tiyaˈ ku dinaˈak pitu weˈ Panuhutanten, si Isa, bakas mapakite si kaˈu si lān papitunun. Daˈakne ku pitu supaya kew ngite balik duk supaya kew paˈasekan weˈ Niyawa Sutsihin.” ");
INSERT INTO yka_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Magtawus niyaˈ kuweˈ bantuk meˈ sisik kenna laboˈ amban meˈ mata si Saulin duk makakite ne iye balik. Manjari kuwat iye duk pinandi iye, tandaˈ weˈ sukuˈ pu si Isa ne iye. ");
INSERT INTO yka_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ubus mangan ne iye duk balik ne basagnen. Patennaˈ si Saul bang piyem bahangi laˈi si meˈ tindeg si Isa si Damaskusin. ");
INSERT INTO yka_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Manjari magtawus iye pī si meˈ kalanggal-langgalan Yahudi duk magusihat iye sabab si Isa. “Si Isa inin,” paˈinne, “Anak Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kēmon makakale iyehin ulaliˈ teˈed. Paˈinde, “Iye hep inin aˈa malaˈi si Awrusalam maminasa sasuku mangampun pu si Isahin. Duk iye hep akane mapitu si Damaskusin, asal niggew sasuku manuhut toloˈ si Isahin duk moˈo siye balik pī si Awrusalam si meˈ imamin.” ");
INSERT INTO yka_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saguwaˈ pasōng ne ngabasag pagusihat si Saulin. Pastiˈ teˈed meˈ purebanen weˈ si Isa Almasihin ne, tapeneˈ Tuhan magbayaˈin. Hangkan meˈ Yahudi si Damaskusin gaˈi taˈu nambungan iye. ");
INSERT INTO yka_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pagtiggel-tiggel ne iye laˈi, magisun meˈ Yahudihin weˈ papateyde si Saul. ");
INSERT INTO yka_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saguwaˈ kaˈakahan si Saul sabab isunde miyaˈan. Ellew-sangem binanteyan weˈ meˈ Yahudihin meˈ tarangka paluwasan amban puweblo miyaˈan supaya si Saul tapapateyde. ");
INSERT INTO yka_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Saguwaˈ dambuwaˈ sangem, ineddoˈ si Saul weˈ meˈ tindegnen bu pinatingkoloˈ iye weˈ de dem bakaˈ bu tinuntunan pī padiyawaˈ amban tendewan laˈi si birang batu mapaliput si puweblo miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Hap pī si Saul si Awrusalam. Pagtekkane laˈi, batang iye patuhut si meˈ tindeg si Isa malaˈihin. Saguwaˈ tinalew siye si iye peggeˈ gaˈ siye kahagad weˈ iye asal tindeg si Isa ne. ");
INSERT INTO yka_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Manjari tinabangan si Saul weˈ Barnabas duk binoˈo iye weˈ ne pī si meˈ kawakilanin. Inakahan siye weˈ Barnabas weˈ si Saul inin bakas takitene Panuhutanin, si Isa, sābune si lān hap Damaskus duk missā isab Panuhutanin si iye, duk weˈ laˈi si Damaskus bahani iye magusihat si meˈ aˈahin sabab si Isa. ");
INSERT INTO yka_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hangkan si Saul patennaˈ ne laˈi si siye duk maglengngan iye diyalem Awrusalam. Gaˈ niyaˈ talew-talewne magmahalayak si meˈ aˈa sabab si Isa, Panuhutanin. ");
INSERT INTO yka_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Magbissā isab iye duk magpasuweyan duk meˈ Yahudi bissāhanden Girik. Saguwaˈ batang si Saul papateyde. ");
INSERT INTO yka_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pagkataˈuhan inin weˈ meˈ pagkasine tindeg si Isahin, tinuhutan si Saul weˈ de padurul pī si Kesarea duk dinaˈak iye tahalaˈ pī hap Tarsus. ");
INSERT INTO yka_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Manjari bahune ne sanyang kēmon masandel pu si Isa si tibuˈukan lahat Yahudiyahin, duk si lahat Jalilin duk meˈ malaˈi si lahat Samariyahin. Tinabangan siye weˈ Niyawa Sutsihin hangkan ngabasag sandelden kēmon duk pasōng isab siye magkaˈekka. Magmātabat teˈed siye si Tuhan. ");
INSERT INTO yka_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Manjari maglengngan si Petros ngalatag kalahatan. Mintedde tapī iye si puweblo Lidda nindew meˈ katindegan si Isa maglahat malaˈihin. ");
INSERT INTO yka_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Niyaˈ laˈi takitene aˈa inēnan Aneyas, Aˈa inin gaˈi dumongaˈ amban pabākanne dem walun tahun ne peggeˈ matey barannen. ");
INSERT INTO yka_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Paˈin si Petros si iye, “Aneyas, pakoleˈ Isa Almasi ne kew. Dongaˈ kew duk lūnanun pabākannun.” Magtawus Aneyas dongaˈ. ");
INSERT INTO yka_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ekka teˈed meˈ aˈa maglahat si Liddahin duk meˈ maglahat si Saronin ngite iye duk patuhut ne siye pu si Isa, Panuhutanin. ");
INSERT INTO yka_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na, laˈi si lahat Joppa, niyaˈ dende tindeg si Isa inēnan Tabita. (Bang si bissāhan Girik, ēnnen si Dorkas, hātinen payew.) Luwal iye maghinangan hāp duk nabang teˈed iye si meˈ mamiskinin. ");
INSERT INTO yka_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Masa miyaˈan, tewwaˈ saki iye bu matey. Sinutsi weˈ de barannen duk pinabāk weˈ de si dambuwaˈ bilik diyataˈ lumaˈ. ");
INSERT INTO yka_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lahat Joppa miyaˈan gaˈi du tala teˈed amban Lidda. Pagtakale weˈ meˈ tindeg si Isa malaˈi si Joppahin weˈ īˈ si Petros si Lidda, ngandaˈak siye duwangan aˈa pī pu si Petros ngeddoˈ iye dinaˈak pī dayiˈ-dayiˈ. ");
INSERT INTO yka_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pagkataˈuhan si Petros miyaˈan, magtawus iye magmemes duk nuhut siye ne. Pagtekka laˈi si Joppa, binoˈo iye weˈ de pī si bilik diyataˈ lumaˈin. Paliput pī si iye kēmon meˈ dende baluhin magtangis. Pinakitehan weˈ de si iye meˈ badjuˈ duk meˈ jaket bakas ilaˈit weˈ si Dorkas para si siyehin kaˈellumnen. ");
INSERT INTO yka_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pinaluwas siye kēmon weˈ si Petros amban bilik miyaˈan, ubus bu nengge iye duk tuˈutne diyataˈ kāpan māku-māku si Tuhan. Manjari paharap iye si bangkeyin duk paˈinne, “Tabita, dongaˈ kew.” Pinakellat weˈ dendehin matanen duk pagkitene si Petros, ningkoloˈ iye. ");
INSERT INTO yka_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pinasōng weˈ si Petros tangannen duk pinatengge weˈ ne. Manjari ilinganan weˈ ne meˈ katindegan si Isahin duk meˈ balu dendehin duk sinōngan weˈ ne si Dorkas si siye ellum ne. ");
INSERT INTO yka_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Bawag si tibuˈukan lahat Joppa miyaˈan sabab kaˈellum si Dorkas balikin, hangkan ekka aˈa sandel ne pu si Isa, Panuhutanin. ");
INSERT INTO yka_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Patennaˈ pe si Petros laˈi si Joppa tiggel-tiggel. Laˈi iye si lumaˈ si Simon, aˈa iye hinangnen maghatul-hatul kuwit hayep. ");
INSERT INTO yka_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Laˈi si lahat Kesarea, niyaˈ aˈa inēnan Korneliyus. Dambuwaˈ iye kapitan si kumpaniya meˈ sundalu bangsa Roma inēnan “Kumpaniya Italiya.” ");
INSERT INTO yka_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aˈa inin asal be-āgama. Siye kēmon magtewtey-anakin magsambahayang si Tuhan. Ekka pangurung-ngurungne panabangne meˈ Yahudi mamiskinin, duk luwal iye ngampun si Tuhan. ");
INSERT INTO yka_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dambuwaˈ kohap waktu asal niyaˈ pabagala si iye dambuwaˈ malaˈikat Tuhanin. Takitene pastiˈ malaˈikatin paˈasek dem bilikne duk magpaˈin si iye, “O Korneliyus.” ");
INSERT INTO yka_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Hawal talew Korneliyusin, dinendengan weˈ ne malaˈikatin. Manjari paˈinne, “Weˈey, Tuwan?” Paˈin malaˈikatin, “Takale Tuhanin pangampunnu si iyehin duk takitene panabangnu meˈ mamiskinin duk tapikil du kew weˈ ne. ");
INSERT INTO yka_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kuweˈitu ngandaˈak kew meˈ aˈa pī si Joppa ngeddoˈ dambuwaˈ aˈa inēnan si Simon, inēnan isab si Petros. ");
INSERT INTO yka_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Laˈi iye patennaˈ pu si Simon, aˈa maghatul-hatul kuwit hayepin. Lumaˈnen si higad tahik.” ");
INSERT INTO yka_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Paglumikut ne malaˈikatin, ngalingan Korneliyus duwangan daraˈakanne si lumaˈin duk dambuwaˈ sundalu bataˈanne. Sundalu miyaˈan be-āgama. ");
INSERT INTO yka_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Inakahan siye weˈ Korneliyus sabab paguwaˈ malaˈikatin duk dinaˈak siye weˈ ne pī hap Joppa. ");
INSERT INTO yka_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pagsasumu lettu ellewin, sābude si lān tapit ne si Joppa, manaˈik si Petros pī diyataˈ sapew madatag si lumaˈ palaˈihanne miyaˈan ngampun laˈi. ");
INSERT INTO yka_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Gaˈ tiggel, inusan ne iye duk batang iye mangan. Saguwaˈ sābu pinanyap pe kapamanganin, niyaˈ pabagala si iye amban Tuhan. ");
INSERT INTO yka_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Takitene langitin paluka duk niyaˈ takitene kuweˈ bantuk olos ladjab iningketan pidjūnen kaˈampat pinatuntun pinadiyawaˈ si dunya. ");
INSERT INTO yka_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Diyalem olos miyaˈan laˈi ne meˈ bayuˈ-bayuˈan hayep malumengnganin, meˈ mapalelehin, duk meˈ manuk-manukin. ");
INSERT INTO yka_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Manjari niyaˈ suwala takalene magpaˈin si iye, “Kuwat kew, Petros. Numbaliˈ kew duk mangan kew.” ");
INSERT INTO yka_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Saguwaˈ paˈin si Petros, “O Tuwan, gaˈi ku. Tiggelanku ellum, gaˈ pe ku bakas makaˈakan ine-ine mukalu atawa haram.” ");
INSERT INTO yka_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Takalene ne isab suwalahin magpaˈin si iye, “Daˈa paˈinun haram bakas tahalal weˈ Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mintellu inin pinalabey si iye ubus bu pinaˈangkat ne olos miyaˈan balik pī si langit. ");
INSERT INTO yka_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Sābu si Petros pe magulaliˈ bang ine hāti bakas pinabagala si iye miyaˈan, tekka ne laˈi si lumaˈ si Simon meˈ dinaˈak Korneliyusin. Laˈi ne siye si tarangka. ");
INSERT INTO yka_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ngalingan siye magtilew, paˈinde, “Niyaˈ ke luˈu patennaˈ aˈa inēnan si Simon, inēnan isab si Petros?” ");
INSERT INTO yka_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Sābu miyaˈan laˈi pe si Petros mikil-mikil bang ine hāti bakas takitenen. Manjari paˈin Niyawa Tuhanin si iye, “Pakalehun be. Niyaˈ laˈi tellungan aˈa miha kaˈu. ");
INSERT INTO yka_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kuwat kew duk duwaˈi kew pī. Daˈa kew magalang-alang nuhut siye peggeˈ aku mangandaˈak siye mapituhin.” ");
INSERT INTO yka_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Hangkan duwaˈi ne si Petros duk paˈinne si meˈ aˈahin, “Aku ne hep aˈa pinihabin. Ine teˈ akabi si akuhin?” ");
INSERT INTO yka_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Dinaˈak kami pitu weˈ Kapitan Korneliyus,” paˈinde. “Aˈa hāp iye. Talew iye si Tuhan duk pagaddatan iye weˈ meˈ Yahudihin kēmon. Niyaˈ malaˈikat Tuhanin ngandaˈak iye, dinaˈak kew pinasan pī si lumaˈne, supaya koˈ takalene ine-ine bissānu.” ");
INSERT INTO yka_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Na, dinaˈak dahuˈ siye weˈ si Petros padiyalem duk inohotan siye weˈ ne laˈi ne sangemin. Pagsasumuhin, magmemes iye duk nuhut ne iye siye. Niyaˈ isab meˈ pagkasine tindeg si Isa amban Joppa nuhutan iye. ");
INSERT INTO yka_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pagellew dambuwaˈin, tekka ne siye si lahat Kesarea. Si Korneliyus laˈi ne ngagad si lumaˈne. Pinagtipun isab weˈ ne laˈi meˈ kaˈusbahannen duk meˈ bagayne inessebin. ");
INSERT INTO yka_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pagsōng padiyalem ne si Petros laˈi, pasampang pī Korneliyus duk pasujud iye si antag bettis si Petros. ");
INSERT INTO yka_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Saguwaˈ pinatengge iye weˈ si Petros. Paˈin si Petros si iye, “Nengge kew. Aku inin manusiyaˈ du kuweˈ kaˈuhin.” ");
INSERT INTO yka_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Magbissā-bissā siye duwangan sābude mapadiyalemin. Laˈi diyalem, takite si Petros meˈ aˈa maˈekka magtipunin. ");
INSERT INTO yka_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Paˈinne si siye, “Kataˈuhanbi, bang si āgama kami Yahudi, gaˈi kami makajari palamud si meˈ aˈa dumaˈin Yahudi. Gaˈi kami makajari bisan patindew si meˈ kuweˈ kaˈam inin. Saguwaˈ pinahāti weˈ Tuhanin si aku,” paˈinne, “weˈ subey gaˈ niyaˈ aˈa kimmatanku batal atawa haram. ");
INSERT INTO yka_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hangkan hep sakaliˈ ku pasanbi, gaˈ ne ku magalang-alang pitu. Manjari tilewte kaˈam, ine teˈ pamasananbi akuhin?” ");
INSERT INTO yka_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nambung Korneliyus, paˈinne, “Hatu meˈ sa īˈ, tellu ellew ne palabey, tuˈu ku miyaˈan si lumaˈ ngampun waktu asal. Manjari bessuwang niyaˈ aˈa nengge paharap si aku ngillap teˈed semmeknen. ");
INSERT INTO yka_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Missā aˈa miyaˈan si aku, paˈinne, ‘O Korneliyus. Takale Tuhanin ne meˈ pangampunnu si iyehin duk takitene panabangnu meˈ mamiskinin. ");
INSERT INTO yka_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ngandaˈak kew pī si Joppa ngeddoˈ dambuwaˈ aˈa inēnan si Simon, inēnan isab si Petros. Laˈi iye patennaˈ pu si Simon, aˈa maghatul-hatul kuwit hayepin. Lumaˈnen si higad tahik.’ ");
INSERT INTO yka_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Na, hangkan hep kew pasanku magtawus,” paˈin Korneliyus. “Duk magsukul ku teˈed si kaˈu peggeˈ tiyaˈ ne kew. Duk kuweˈitu tiyaˈ ne kami kēmon tuˈu magtipun si matahan Tuhan pakale ine-ine bissā pangandaˈakan Tuhanin kaˈu.” ");
INSERT INTO yka_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Manjari missā si Petros si siye. Paˈinne, “Kuweˈitu mattan ne si aku weˈ asal bennal Tuhanin gaˈi pagbiddaˈne manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Bisan bangsa ine, sasuku magmātabat si Tuhan duk bentel meˈ hinangannen, kasulutan Tuhanin si iye. ");
INSERT INTO yka_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","37","Bakas takalebi ne hatu sabab aka-aka mahāp pinaboˈohan Tuhan si meˈ bangsa Yahudihin, weˈ niyaˈ ne kasanyangan sabab bakas tahinang Isa Almasihin; iye hep magbayaˈ si kēmon-kēmonin. Kataˈuhanbi bang ine maˈumantag si tibuˈukan lahat Yahudiyahin tinagnaˈan laˈi si Jalil pagubus Yahiya magusihat pasal pandi tawubatin. ");
INSERT INTO yka_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kataˈuhanbi sabab si Isa, aˈa Nasaretin. Pinapī weˈ Tuhanin si iye Niyawa Sutsihin duk inurungan iye balakat. Lumengngan iye duk tungan-tunganne, maghinangan hāp iye. Pinakawuliˈ weˈ ne kēmon pasayedan weˈ nakuraˈ seyitanin, peggeˈ laˈi Tuhanin si iye. ");
INSERT INTO yka_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Duk kami inin,” paˈin si Petros, “kasaksiˈan kami kēmon bakas hininang si Isa si lahat meˈ bangsa Yahudihin duk laˈi si Awrusalamin. Manjari pinapatey iye weˈ meˈ aˈahin, ilansang weˈ de diyataˈ olom. ");
INSERT INTO yka_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Saguwaˈ katellum bahangi puwas kamateynen, pinakellum iye balik weˈ Tuhanin duk pinakitehan iye weˈ ne. ");
INSERT INTO yka_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Gaˈ iye pinakite si kēmon aˈa, luwal hadja si kami meˈ asal andang pineneˈ weˈ Tuhanin hinang saksiˈ. Takite kami iye. Makapagtuhut kami duk si Isa mangan duk nginum kaˈellumne mabalikin. ");
INSERT INTO yka_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Duk dinaˈak kami weˈ ne magmahalayak aka-aka mahāpin si meˈ aˈa. Dinaˈak isab kami naksiˈ weˈ kaˈurungan iye kapatut weˈ Tuhanin ngahukum meˈ manusiyaˈin kēmon, meˈ maˈellumin duk meˈ pateyin. ");
INSERT INTO yka_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kēmon meˈ kanabi-nabihanin bakas missā isab sabab si Isa Almasi. Paˈinde weˈ sasuku masandel pu si Isahin, inampun du meˈ duseden sabab bakas tahinang si Isahin.” ");
INSERT INTO yka_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Sasang missā pe si Petros, paˈasek Niyawa Sutsihin pī si kēmon meˈ aˈa mapakale si bissānen. ");
INSERT INTO yka_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Magulaliˈ teˈed meˈ Yahudi masandel pu si Isahin, iye meˈ saweˈ si Petros amban Joppahin. Ulaliˈ siye peggeˈ pinapī isab weˈ Tuhanin lasa-lasahannen, Niyawa Sutsihin, si meˈ aˈa dumaˈin bangsa Yahudi. ");
INSERT INTO yka_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Takalede hep disi Korneliyus missā nanglitan Tuhanin si bissāhan dumaˈin bissāhande. Manjari paˈin si Petros, ");
INSERT INTO yka_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Meˈ aˈa inin tasangkade ne Niyawa Sutsihin sa kitehin bi isab. Gaˈ ne niyaˈ makasaggaˈ bang siye inin pinandi.” ");
INSERT INTO yka_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Hangkan dinaˈak ne siye weˈ si Petros pinandi, tandaˈ weˈ sukuˈ pu si Isa ne siye. Manjari inohotan weˈ disi Korneliyus si Petros laˈi dahuˈ patennaˈ si siye meˈ piye-piyem bahangi ne. ");
INSERT INTO yka_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Takale weˈ meˈ kawakilanin duk meˈ katindegan si Isa si tibuˈukan Yahudiyahin weˈ kinahagad ne lapal Tuhanin weˈ meˈ aˈa dumaˈin bangsa Yahudihin. ");
INSERT INTO yka_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pagbalik si Petros hap Awrusalam, niyaˈ meˈ Yahudi masandel pu si Isahin nganjawab iye. ");
INSERT INTO yka_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Paˈinde, “Weˈey kew pī si lumaˈ meˈ aˈa gaˈ bakas magislam duk magkakanan kew isab duk siye?” ");
INSERT INTO yka_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Hangkan pinahātihan siye weˈ si Petros kahalannen amban tagnaˈ. ");
INSERT INTO yka_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Paˈinne si siye, “Laˈi ku miyaˈan si lahat Joppa ngampun. Manjari niyaˈ pabagala si aku. Niyaˈ takiteku kuweˈ bantuk olos ladjab iningketan pidjūnen kaˈampat duk pinatuntun amban langit padiyawaˈ pī si bihingku. ");
INSERT INTO yka_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pinayaman weˈ ku papastiˈ bang ine malaˈi diyalem olos miyaˈan. Iye takitekun meˈ hayep, meˈ hayep talun, meˈ mapalele si bulakin, duk meˈ manuk-manuk isab. ");
INSERT INTO yka_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Manjari niyaˈ takaleku suwala missā si aku. Paˈin suwalahin, ‘Kuwat kew, Petros. Numbaliˈ kew duk mangan kew.’ ");
INSERT INTO yka_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Saguwaˈ paˈinku, ‘Gaˈi ku, Tuwan. Tiggelanku ellum gaˈ pe ku bakas makaˈakan ine-ine mukalu atawa haram.’ ");
INSERT INTO yka_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Saguwaˈ takaleku ne isab balik suwalahin, paˈinne, ‘Daˈa paˈinun haram bakas tahalal weˈ Tuhanin.’ ");
INSERT INTO yka_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mintellu inin pinalabey si aku, ubus bu pinaˈangkat ne balik olosin pī si langit. ");
INSERT INTO yka_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Sābu miyaˈan du, niyaˈ tekka pī si lumaˈ patennaˈankun tellungan lella dinaˈak pī si aku amban lahat Kesarea. ");
INSERT INTO yka_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Dinaˈak ku weˈ Niyawa Tuhanin gaˈi magalang-alang nuhut siye. Duk sinaweˈan ku isab weˈ de inin, ennem siye meˈ pagkasite bi tindeg si Isa amban Joppa. Pagtekka kami si Kesarea, hap pī kami padiyalem si lumaˈ Kapitan Korneliyus. ");
INSERT INTO yka_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Inakahan kami weˈ Korneliyus weˈ niyaˈ koˈ takitene malaˈikat nengge laˈi dem lumaˈne duk missā si iye. Paˈin malaˈikatin koˈ, ‘Ngandaˈak kew pī si lahat Joppa ngeddoˈ dambuwaˈ aˈa inēnan si Simon, inēnan isab si Petros. ");
INSERT INTO yka_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Niyaˈ iyuˈ meˈ bissāne si kaˈu makatimbul kaˈu duk kēmon saweˈnu magdambuwaˈ lumaˈin.’ ");
INSERT INTO yka_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Manjari sakaliˈ ne ku missā pu disi Korneliyus,” paˈin si Petros, “paˈasek pī si siye Niyawa Sutsihin kuweˈ si kite bi tagnaˈin. ");
INSERT INTO yka_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Manjari taˈessebku bakas pinaˈin si Isahin. Paˈinne hep, ‘Boheˈ pamandi si Yahiya meˈ aˈahin, saguwaˈ kaˈam,’ paˈin si Isa, ‘pamandi si kaˈamin seddili. Pinapiyu du si kaˈam Niyawa Sutsihin.’ ");
INSERT INTO yka_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na,” paˈin si Petros, “asal pastiˈ ne weˈ pinangurung isab weˈ Tuhanin si meˈ aˈa dumaˈin Yahudi Niyawanen, lasa-lasahan pinangurungne si kite bi meˈ Yahudihin, pagsandel ne kite bi pu Isa Almasi, Panuhutanin. Hangkan gaˈi tasaggaˈku Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pagkale meˈ Yahudihin inin, gaˈ ne niyaˈ bissāde. Bisan miyaˈan pinudji weˈ de Tuhanin. Paˈinde, “Bang sa īˈ, pinapikilan du isab weˈ Tuhanin meˈ kabangsahan dumaˈin Yahudihin supaya pinda pagateyden duk taga umul siye salama-lama.” ");
INSERT INTO yka_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Masa pamapatey si Estepanin, kanat-kanat hep meˈ masandel pu si Isahin sabab paminasa si siyehin. Sinduwehin umabut sampay pī si lahat Penisiya, si pūˈ Kiprus, duk laˈi si Antiyok. Minahalayak weˈ de laˈi aka-aka mahāpin saguwaˈ si meˈ Yahudi hadja. ");
INSERT INTO yka_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Meˈ tindeg si Isa sinduwehin, meˈ aˈa amban Kiprus duk Kirene, hap pī siye inin si Antiyok, duk minahalayak isab weˈ de si meˈ aˈa dumaˈin Yahudi aka-aka mahāp sabab si Isa, Panuhutanin. ");
INSERT INTO yka_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Laˈi si siye balakat Tuhanin duk ekka teˈed aˈa Antiyok kahagad duk nuhut ne pu si Isa, Panuhutanin. ");
INSERT INTO yka_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Takale weˈ meˈ masandel pu si Isa si Awrusalamin sabab inin, hangkan dinaˈak weˈ de Barnabas pī si Antiyok. ");
INSERT INTO yka_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pagtekka Barnabas laˈi, takitene meˈ hininang Tuhan si meˈ aˈahin sabab lasane duk aseˈne si siyehin. Hangkan kēgan iye duk tinoloˈan siye weˈ ne weˈ subey siye pateteg pu si Isa, Panuhutanin, ateyden dambūs-būs. ");
INSERT INTO yka_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Si Barnabas inin, aˈa hāp addatnen. Pagbayaˈan iye weˈ Niyawa Sutsihin duk basag teˈed sandelnen. Ekka aˈa si Antiyok taboˈo weˈ ne sandel pu si Isa, Panuhutanin. ");
INSERT INTO yka_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Manjari si Barnabas inin hap pī si lahat Tarsus miha si Saul. ");
INSERT INTO yka_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pagkasuwaˈne iye, binoˈo iye weˈ ne balik hap Antiyok. Niyaˈ siye dan tahun laˈi duwangan patennaˈ si meˈ masandel pu si Isa si Antiyokin duk magusihat siye si meˈ aˈa banes teˈed. Laˈi hep si Antiyok miyaˈan tagnaˈ inēnan meˈ tindeg si Isahin, meˈ aˈa Almasi. ");
INSERT INTO yka_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Masa miyaˈan, niyaˈ meˈ aˈa magpalataˈ bissā Tuhanin padurul amban Awrusalam hap Antiyok. ");
INSERT INTO yka_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Dangan siye inēnan Agabus, nengge magpaˈal pinanoloˈan weˈ Niyawa Tuhanin. Paˈin Agabus, “Niyaˈ unus sōng tekka si kēmon kalahat-lahatan.” (Tekka unus inin masa Sultan Kalaudi, sultan nakuraˈin.) ");
INSERT INTO yka_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Hangkan meˈ tindeg si Isa si Antiyokin magsakap weˈ magpaboˈo siye dangan-dangan tamanan tapanabangden pī si meˈ pagkaside tindeg si Isa si lahat Yahudiyahin. ");
INSERT INTO yka_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Na, iye inin hininang meˈ katindegan si Isa laˈi si Antiyokin. Magpaboˈo siye pilak pu si Barnabas duk si Saul pī si meˈ kabahiˈan meˈ masandel laˈi si Awrusalamin. ");
INSERT INTO yka_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Masa miyaˈan, tinagnaˈan ne weˈ Sultan Herod bininasa meˈ masandel pu si Isa sinduwehin. ");
INSERT INTO yka_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Dinaˈak weˈ ne pinunggelan si Yakub, pungtinaˈi Yahiyahin. ");
INSERT INTO yka_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Duk pagkitene weˈ kasulutan meˈ Yahudihin si hininangne miyaˈan, dinaˈak isab weˈ ne siniggew si Petros. Masa paniggew si Petros īˈ, baytu kādjaˈan meˈ Yahudi pamangande pan gaˈi sinagetan pasuligin. ");
INSERT INTO yka_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pagubus si Petros siniggew, dinaˈak iye kinalabusu weˈ sultanin. Ampat tumpuk sundalu dinaˈakne ngangguwaldiyahan si Petrosin, ampat-ampat da tumpuk. Sakap si Herodin weˈ puwas hadja kādjaˈan meˈ Yahudi miyaˈan, boˈone si Petros paluwas pī si meˈ aˈahin hinukum. ");
INSERT INTO yka_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hangkan laˈi dahuˈ si Petros tahan dem kalabusu saguwaˈ meˈ masandel pu si Isahin māku-māku teˈed si Tuhan para si iye. ");
INSERT INTO yka_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Malam sōng pamoˈo si Herod si Petros pī si meˈ aˈahin, tuli si Petros si ellet duwe guwaldiya. Kinarena iye duk duwe karena. Niyaˈ isab meˈ guwaldiya laˈi si bukut manteyan tarangka kalabusuhin. ");
INSERT INTO yka_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Manjari inin, bessuwang niyaˈ dambuwaˈ malaˈikat Tuhanin nengge laˈi si bihing si Petros duk dantaˈ dem kalabusuhin. Jinedjeg weˈ malaˈikatin si Petros si bahane duk binangun weˈ ne. “Dongaˈ kew padayiˈ,” paˈin malaˈikatin. Magtawus duddag meˈ karenahin amban meˈ tangan si Petros. ");
INSERT INTO yka_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Paˈin malaˈikatin si iye, “Magkuwero kew duk magtehompaˈ kew.” Magkuwero ne si Petros duk magtehompaˈ ne iye. Ubus paˈin malaˈikatin, “Asekun jaketnun duk nuhut kew aku.” ");
INSERT INTO yka_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Manjari nuhut iye ne si Petros paluwas amban kalabusu. Saguwaˈ gaˈ kataˈuhan si Petros bang toˈo ke meˈ hinangan malaˈikat miyaˈan atawa gaˈi. Kannalne niyaˈ hadja pabagala si iye. ");
INSERT INTO yka_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Paglumabey ne siye amban guwaldiya tagnaˈin, ubus bu si kaduwenen, ujudnen tekka siye si tarangka basiˈ paluwasan hap puweblo miyaˈan. Lukahan dine tarangkahin duk paluwas ne siye. Lumengngan siye nuhut dambuwaˈ kalsara manjari bessuwang lanyap malaˈikatin. ");
INSERT INTO yka_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Paglanyap ne malaˈikatin, bahu tasayu si Petros bakas talabeynen. Paˈinne, “Asal bennal hatiˈ inin. Pinapitu hatiˈ weˈ Tuhanin malaˈikatnen maluwas aku amban antanan si Herod duk amban kēmon laˈat inase-ase meˈ Yahudi sōng maˈumantag si akuhin.” ");
INSERT INTO yka_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pagkataˈuhan si Petros ne inin, hap pī iye si lumaˈ si Mariyam, saˈi Yahiya Markusin. Ekka meˈ aˈa laˈi magtipun māku-māku si Tuhan. ");
INSERT INTO yka_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tinuttuk weˈ ne gawang si luwasanin. Niyaˈ daraˈakan dende inēnan si Roda pī nambag. ");
INSERT INTO yka_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Takilalene suwala si Petrosin. Kēgan teˈed iye duk hawal kēgnen, gaˈ dahuˈ lukane gawangin saguwaˈ magubas iye padiyalem ngakahan siye. Paˈinne, “Īˈ laˈi si Petros nengge si luwasan.” ");
INSERT INTO yka_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Hatu kew iyan magkanap-kanap,” paˈinde pu si Roda. Saguwaˈ luwal balik-balikne weˈ asal toˈo īˈ laˈi si Petros. Manjari paˈinde, “Malaˈikatnen īˈ.” ");
INSERT INTO yka_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Saguwaˈ gaˈ pahali si Petros nuttuk. Ujudnen ilukahan ne weˈ de gawangin. Pagkitede si Petros, asal ulaliˈ teˈed siye. ");
INSERT INTO yka_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Magsinyas si Petros duk tanganne, gaˈi siye dinaˈak magbukag. Manjari inakahan siye weˈ ne bang saˈingge pamaluwas Tuhan iye amban kalabusuhin. Paˈin si Petros, “Akahanun bi saˈ si Yakub duk meˈ pagkasite bi masandel pu si Isa sinduwehin sabab inin.” Manjari tahalaˈ iye hap pī si lugal seddili. ");
INSERT INTO yka_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pagsalung ne, sasew teˈed meˈ guwaldiyahin. Ine enteˈ maˈumantag pu si Petrosin? ");
INSERT INTO yka_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Maguldin Sultan Herod dinaˈak piniha teˈed si Petros si meˈ guwaldiyahin. Saguwaˈ gaˈ iye takasuwaˈde. Manjari sinumariya siye weˈ si Herod duk pagubus, dinaˈak siye weˈ ne pinapatey. Puwas miyaˈan padurul Sultan Herod amban Yahudiya hap Kesarea duk laˈi dahuˈ iye patennaˈ. ");
INSERT INTO yka_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Masa miyaˈan astel hep teˈed Sultan Herod si meˈ aˈa si lahat Tirosin duk si meˈ aˈa si lahat Sidonin. Manjari pī meˈ aˈa duwe lahatan miyaˈan magtuhut mayaman si Herod. Binagay dahuˈ weˈ de Balastus, dambuwaˈ meˈ pangandelan dem astanaˈ sultanin, supaya siye bēbbeganne. Manjari hap pī ne siye pu si Herod moˈo iye maghāp, peggeˈ amban lahat sultanin hep pangeddoˈande kinakanden. ");
INSERT INTO yka_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Manjari inin, pagtekka ellew pangeddew si Herod pamissāne si meˈ aˈahin, inasek weˈ ne semmekne mahāpin duk ningkoloˈ iye diyataˈ siya pagsultanannen. Manjari pinaluwas weˈ ne bissānen si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Magellang-ellang meˈ aˈahin, paˈinde, “Dumaˈin ne manusiyaˈ mamissā iyan, saguwaˈ dambuwaˈ iye tuhan.” ");
INSERT INTO yka_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Magtawus si Herod pinasaki weˈ malaˈikat Tuhanin peggeˈ tinayimaˈ weˈ ne sanglit meˈ aˈahin bu gaˈ sanglitanne Tuhanin. Manjari kinaleg iye sampay tibuˈukan barannen duk matey iye. ");
INSERT INTO yka_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Saguwaˈ lapal Tuhanin pasōng ne paˈin palatag duk pasōng magkaˈekka meˈ aˈa masandel pu si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Peggeˈ ubus ne tahinang disi Barnabas duk si Saul akade laˈi si Awrusalamin, balik ne siye hap Antiyok. Binoˈo weˈ de Yahiya Markus. ");
INSERT INTO yka_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Laˈi si meˈ masandel pu si Isa si Antiyokin, niyaˈ meˈ magpalataˈ bissā Tuhanin duk niyaˈ meˈ magusihat. Siye miyaˈan disi Barnabas, si Simon ugey-ugeynen si Ittem, si Lukiyus aˈa Kirene, si Saul, duk si Manaen, bakas saweˈ-saweˈ Sultan Herod kadikiˈden. ");
INSERT INTO yka_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Missā Niyawa Sutsihin si siye miyaˈan sābude magsambahayang si Tuhan duk magpuwase. Paˈin Niyawa Sutsihin si siye, “Paseddilihun bi aku Barnabas duk si Saul, niyaˈ hinang pamasukuˈanku siye.” ");
INSERT INTO yka_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Magpuwase pe siye balik duk māku-māku si Tuhan, ubus bu binettad weˈ de tanganden pī si duwanganin duk dinaˈak ne siye lumengngan. ");
INSERT INTO yka_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Manjari, peggeˈ dinaˈak siye weˈ Niyawa Sutsihin lumengngan, hangkan padurul ne Barnabas duk si Saul hap lahat Seluki duk patulak siye billaˈi hap pūˈ Kiprus. ");
INSERT INTO yka_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pagtekkade si pūˈ miyaˈan, laˈi si kalumaˈan inēnan Salamis, minahalayak weˈ de lapal Tuhanin dem meˈ kalanggalan Yahudi. Laˈi Yahiya Markus nabangan siye si meˈ hinangden. ");
INSERT INTO yka_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Binutasan weˈ de pūˈ miyaˈan sampay tekka siye si kalumaˈan inēnan Papos. Makadugpak siye laˈi dambuwaˈ landungan, ēnnen si Bar-Isa. Aˈa Yahudi iye duk magmā-mā iye magpalataˈ bissā Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Magbagay Bar-Isa miyaˈan duk si Sergus Paulus, gubnul pūˈ miyaˈan. Gubnul miyaˈan aˈa lalem pikilannen. Tinawag weˈ gubnulin si Barnabas duk si Saul pī si iye peggeˈ bayaˈ iye pakale si lapal Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Saguwaˈ sinaggaˈ duwanganin weˈ landunganin. (Ēnnen bang si bissāhan Girik, si Elimas.) Gaˈi bayaˈ Elimas bang kahagad gubnulin si lapal Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Manjari si Saul pagbayaˈan weˈ Niyawa Sutsihin. Si Saul duwe ēnnen. Ēnne dambuwaˈin si Paul. Pinayaman teˈed pahantap weˈ si Paul landunganin. ");
INSERT INTO yka_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Paˈin si Paul si iye, “Anak nakuraˈ seyitanin kew. Ine-ine hāp kuntarahannu. Pangakkal kew teˈed duk laˈatan ateynun. Luwal hadja kinuyas-kuyas weˈ nu meˈ mabennal amban Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Payamanun,” paˈin si Paul, “kuweˈitu patekkahan Tuhanin kew balaˈ. Ngapessek kew iyan duk tiggel-tiggel kew gaˈi makakite dantaˈ ellew.” Magtawus takalessa Elimas kuweˈ niyaˈ gabun ittem nampengan meˈ matanen duk gaˈi ne iye ngite. Lumengngan iye miha aˈa nundan iye. ");
INSERT INTO yka_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pagkite gubnulin maˈumantag miyaˈan, kahagad ne iye; peggeˈ ulaliˈ teˈed iye si meˈ usihat si Paul sabab si Isa, Panuhutanin. ");
INSERT INTO yka_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Manjari pagubus disi Paul magusihat laˈi si Papos, patulak siye hap Perga, laˈi si lahat Pampiliya. Tekka laˈi, inambanan siye weˈ Yahiya Markus duk moleˈ iye balik hap Awrusalam. ");
INSERT INTO yka_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Amban Perga palanjal si Paul duk Barnabas sampay tekka siye si Antiyok, laˈi si lahat Pisidiya. Pagellew Sabtuˈ, liˈi meˈ Yahudihin, pī siye si langgal Yahudi duk ningkoloˈ siye laˈi diyalem. ");
INSERT INTO yka_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Niyaˈ binatsa amban saraˈ si Musa duk amban kitab kanabi-nabihanin. Pagubus miyaˈan binatsa, ngandaˈak meˈ nakuraˈ langgal miyaˈan pī pu disi Paul magpaˈin, “Meˈ kapungtinaˈihan, bang niyaˈ batang bissābi pangusihatbi si meˈ aˈahin, missā ne kaˈam.” ");
INSERT INTO yka_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Manjari nengge si Paul duk ninyas iye duk tanganne supaya meˈ aˈahin pakale. Ubus bu missā ne iye. Paˈinne, “Meˈ pagkasiku bangsa Israˈil duk sampay kēmon ne kaˈam amban kabangsahan seddili saguwaˈ nambahayang si Tuhan, pakalehun bi ku. ");
INSERT INTO yka_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Meˈ kapapuˈan kamihin tapeneˈ weˈ Tuhanin, iye asal pagtuhanan kami bangsa Israˈilin. Pinahadje weˈ ne bangsa Israˈilin baytu patennaˈde si Misilin, lahat bangsa seddili. Duk binoˈo siye weˈ Tuhanin paluwas amban lahat miyaˈan weˈ balakatne mahadjehin. ");
INSERT INTO yka_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ampatpūˈ tahun panandal-nandal Tuhan manggaˈi panuhut bangsa Israˈil toloˈnen laˈi dem lahat makagindew-gindew īˈ. ");
INSERT INTO yka_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pituˈ bangsa pinakaˈatan weˈ Tuhanin laˈi si lahat Kanaˈan duk pinangurung weˈ ne lahat miyaˈan si meˈ aˈanen, bangsa Israˈilin, pamusakaˈne siye. ");
INSERT INTO yka_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Amban papīde si lahat Misilin ngeregseˈ patennaˈde si lahat Kanaˈanin, niyaˈ ampat hatus duk limempūˈ tahun tiggelannen. Puwas miyaˈan,” paˈin si Paul, “niyaˈ meˈ hukum peneˈ Tuhanin magbayaˈ si siye sampay Nabi Samuel tamanan hukumden. ");
INSERT INTO yka_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Manjari māku bangsa Israˈilin sultan magbayaˈ si siye. Pineneˈ weˈ Tuhanin si Saul, anak si Kis, magsultan si siye dem ampatpūˈ tahun. Si Saul inin tubuˈ Benjamin. ");
INSERT INTO yka_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pagubus si Saul inin inānan weˈ Tuhanin amban pagsultannen, iye pinagantiˈne sultanden, si Daˈud. Iye inin pananglit Tuhan si Daˈudin, paˈin Tuhanin, ‘Si Daˈud, anak si Jessehin, aˈa makasulut ateykun. Hinangne du kēmon kinabayaˈankun.’ ");
INSERT INTO yka_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Amban tubuˈ si Daˈud inin,” paˈin si Paul, “ngurung Tuhanin si bangsa Israˈil dambuwaˈ nimbul siye sa pananggupnen. Manimbul inin, iye ne si Isa. ");
INSERT INTO yka_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Gaˈ pe tapitu si Isi nagnaˈan hinangnen, magusihat ne Nabi Yahiya si kēmon bangsa Israˈilin weˈ subey lebbahande meˈ duseden duk subey siye pinandi tawubat, tandaˈ weˈ pagsusunande ne meˈ duseden. ");
INSERT INTO yka_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Pagsōng ubus ne hinang pinasukuˈ Tuhan pu Yahiyahin, paˈinne si meˈ aˈa Israˈilin, ‘Bang pikilbi, sine teˈ ku? Dumaˈin aku inagad-agadbin. Saguwaˈ niyaˈ du paturul si aku, gaˈi ku bisan pataˈ ngalekkahan ingket tehompaˈnen.’ ");
INSERT INTO yka_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Na, meˈ kapungtinaˈihanku,” paˈin si Paul, “sasuku kaˈam tubuˈ Ibrahimin, duk sampay kaˈam amban kabangsahan seddilihin magsambahayang si Tuhanin, si kite bi hep pinaboˈohan aka-aka mahāpin supaya kite bi lumuwas amban meˈ duseten bi. ");
INSERT INTO yka_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Meˈ aˈa Awrusalamin duk meˈ nakuraˈden, gaˈ hep kataˈuhande weˈ si Isa ne miyaˈan manimbulin. Gaˈ isab tahātide meˈ bissā tasulat meˈ kanabi-nabihan awwalley. Bu meˈ tasulat miyaˈan binatsa du dem langgal kahabaˈ ellew Sabtuˈ. Saguwaˈ bisan gaˈ tahātide, asal katumanan ne weˈ de meˈ tasulat meˈ kanabihan miyaˈan, pagilaboˈan ne weˈ de hukuman si Isa. ");
INSERT INTO yka_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bisan du gaˈ niyaˈ takasuwaˈde sāˈ si Isa pataˈ pamapateyan iye, pākude teˈed pu Gubnul Pilatus weˈ pinapatey iye. ");
INSERT INTO yka_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Duk pagubus ne katumanande kēmon tasulat dem kitab sabab si Isahin, ilebbes iye weˈ de amban diyataˈ olom pangalansangande iyehin duk kinubul iye weˈ de dem lingab batu. ");
INSERT INTO yka_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Saguwaˈ pinakellum iye balik weˈ Tuhanin amban kamateynen. ");
INSERT INTO yka_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Duk bang piyem bahangi puwas kaˈellumne mabalikin, takite iye weˈ meˈ bakas saweˈne magtuhut amban Jalil hap Awrusalamin. Duk kuweˈitu, meˈ aˈa inin naksiˈ sabab si Isa si meˈ bangsa Israˈilin. ");
INSERT INTO yka_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na,” paˈin si Paul, “tiyaˈ kami tuˈu moˈohan kaˈam aka-aka hāp. Aka-aka mahāp inin sabab janjiˈ Tuhan si meˈ kapapuˈanten bi. ");
INSERT INTO yka_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Katumanan ne janjiˈ miyaˈan si kite bi meˈ tubuˈden, sabab tapakellum ne weˈ ne si Isa balik. Tasulat dem kitab Jabur, si kalangan duwe, paˈin Tuhanin laˈi, ‘Anakte kew. Ellew inin pakataˈuku weˈ aku Samanun.’ ");
INSERT INTO yka_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Duk inin isab pinaˈin Tuhanin sabab pamakellumne si Isa balikin, gaˈi makalabey buhuk. Paˈinne, ‘Asal pangurungku si kaˈam meˈ kahāpan pananggupku pu si Daˈudin.’ ");
INSERT INTO yka_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Si ayat seddili si kitab Jabur pinaˈin isab, ‘Gaˈi du pasagadannu ngabuhuk daraˈakannu masutsihin.’ ");
INSERT INTO yka_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Si Daˈud, tiggelanne maˈellumin hininang weˈ ne sakap Tuhan para si iyehin, ubus matey du iye. Kinubul iye tapit si meˈ kamatettoˈahannen duk ngabuhuk du barannen. ");
INSERT INTO yka_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Saguwaˈ aˈa bakas pinakellum Tuhan amban kamateyin, si Isa ne miyaˈan, gaˈ teˈed makalabey buhuk. ");
INSERT INTO yka_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Na, meˈ kapungtinaˈihanku,” paˈin si Paul, “subey teˈed kataˈuhanbi kēmon weˈ bisan tuhutbi saraˈ si Musahin, gaˈi teˈed inin makapuwas dusebin. Saguwaˈ sasuku kaˈam sandel pu si Isa, puwas ne dusebin kēmon. Hangkan hep minahalayak si kaˈam lapal sabab si Isa inin. ");
INSERT INTO yka_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Na, pahatul-hatul kaˈam supaya gaˈi du umantag si kaˈam bakas tasulat meˈ kanabi-nabihanin, pinaˈin, ");
INSERT INTO yka_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kaˈam meˈ manggaˈi makahagadin duk mangahinang dageyin, payamanun bi. Magulaliˈ du teˈed kaˈam si hinangkun duk magmula du kaˈam,’ paˈin Tuhanin, ‘peggeˈ si kaˈellumbi pe, niyaˈ hinangku bu gaˈi kahagadbi, bisan du kaˈam inakahan.’” ");
INSERT INTO yka_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pagubus si Paul missā, duk pagsakaliˈ ne siye duk Barnabas tahalaˈ amban langgal miyaˈan, dinaˈak siye weˈ meˈ aˈahin balik pī Sabtuˈ dambuwaˈ ngakahan siye namba sabab meˈ miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pagtahalaˈ ne meˈ aˈahin amban langgal, ekka siye paturul pu si Paul duk Barnabas. Meˈ mapaturul miyaˈan meˈ Yahudi duk meˈ bangsa seddili nuhut āgama Yahudi. Missā duwanganin si siye duk dinaˈak siye pateteg sandel si Tuhan mamalasa si siyehin. ");
INSERT INTO yka_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pagtaˈabut Sabtuˈ dambuwaˈ, agen kēmon aˈa si puweblo miyaˈan laˈi patipun pakale si lapal Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Saguwaˈ pagkite meˈ Yahudi sinduwehin meˈ aˈa mabanes magtipunin, ngimbū siye duk sinagang weˈ de binissā si Paulin. Pinahinaˈ isab iye weˈ de. ");
INSERT INTO yka_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Saguwaˈ pasōng bahani si Paul duk Barnabas missā. Paˈinde, “Subey hep si kaˈam, meˈ bangsa Israˈilin, inaka dehellu lapal Tuhanin. Saguwaˈ peggeˈ gaˈi du tayimaˈbi, duk gaˈi kimmatanbi dibin pataˈ inurungan umul salama-lama, na, pī ne kami si meˈ aˈa bangsa seddili. ");
INSERT INTO yka_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Peggeˈ iye du isab inin pangandaˈakan Tuhan si kamihin, paˈinne, ‘Kuweˈ kaˈam dantaˈ binettad weˈ ku ninagan meˈ kabangsahan seddilihin, supaya umabut si tibuˈukan dunya lapal inin, weˈ aku manimbul manusiyaˈin.’” ");
INSERT INTO yka_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pagkale meˈ bangsa seddilihin bissā inin, kēgan teˈed siye. Pinudji weˈ de lapal Tuhan miyaˈan. Duk kahagad ne pu si Isa sasuku tapeneˈ weˈ Tuhan inurungan umul gaˈ niyaˈ tamanannen. ");
INSERT INTO yka_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lapal Tuhanin palatag ne paˈin si tibuˈukan lahat miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Saguwaˈ kinawul weˈ meˈ Yahudihin meˈ nakuraˈ si lahat miyaˈan duk meˈ kadendehan mabangsahan dumaˈin Yahudihin saguwaˈ nambahayang si Tuhan, supaya kuntarahande disi Paul duk Barnabas. Hangkan pinatahalaˈ weˈ de duwanganin amban lahatde miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pinagpagan weˈ disi Paul leppug bettisden, tandaˈ weˈ papuwas ne siye amban meˈ aˈa lahat miyaˈan. Ubus hap pī siye si lahat Ikoni. ");
INSERT INTO yka_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Saguwaˈ meˈ masandel pu si Isa si Antiyokin kēgan ne paˈin duk pagbayaˈan siye weˈ Niyawa Sutsihin. ");
INSERT INTO yka_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Laˈi si lahat Ikoni saliˈ du isab maˈumantagin. Hap pī si Paul duk Barnabas dem langgal Yahudi magmahalayak lapal Tuhanin. Basag teˈed pamahātide lapal Tuhanin hangkan banes teˈed meˈ Yahudi duk meˈ aˈa dumaˈin Yahudi sandel ne pu si Isa. ");
INSERT INTO yka_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Saguwaˈ meˈ Yahudi manggaˈi masandelin, kinawul weˈ de meˈ aˈa dumaˈin Yahudihin supaya kuntarahande meˈ masandel pu si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Si Paul duk Barnabas patennaˈ laˈi si Ikoni tiggel-tiggel. Gaˈ niyaˈ talew-talewde missā si meˈ aˈa sabab si Isa, Panuhutanin. Duk pinabugtuˈ weˈ Panuhutanin si meˈ aˈahin weˈ toˈo lapal minahalayakde sabab lasanen, sabab inurungan siye weˈ ne balakat maghinang meˈ hinangan balakatan duk makaˈulaliˈ. ");
INSERT INTO yka_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Magpaˈil meˈ aˈa si puweblo miyaˈan. Sinduwehin binēbbegan weˈ de meˈ Yahudihin duk sinduwehin binēbbegan weˈ de disi Paul. ");
INSERT INTO yka_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Manjari magisun meˈ aˈa bangsa seddilihin duk meˈ Yahudihin magtuhut duk meˈ nakuraˈden, weˈ papeddiˈande duk pagtibagande disi Paul. ");
INSERT INTO yka_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pagkataˈuhan inin weˈ disi Paul, lahi siye duwangan hap lahat Likaona. Paglaˈi ne siye, hap pī siye si puweblo Listara duk si puweblo Derbe duk sampay si kalahatan mapaliputin, ");
INSERT INTO yka_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","duk minahalayak weˈ de laˈi aka-aka mahāp sabab si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Laˈi si Listara niyaˈ aˈa kukuˈ kemuwe amban dem betteng duk gaˈ iye bakas makalengngan. ");
INSERT INTO yka_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pakale teˈed iye si meˈ binissā si Paulin. Pinayaman iye pabentel weˈ si Paul duk kataˈuhan weˈ si Paul dem ateyne weˈ aˈa kukuˈ miyaˈan ngandel weˈ tapakawuliˈ iye weˈ si Isa. ");
INSERT INTO yka_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Manjari missā si Paul pinapales. “Nengge kew,” paˈinne si aˈa makukuˈin. Magtawus pahulangkad aˈahin nengge duk lumengngan ne iye. ");
INSERT INTO yka_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pagkite meˈ aˈa mabanesin hininang si Paul miyaˈan, magellang-ellang siye si bissāde Likaona, paˈinde, “Magbantuk manusiyaˈ ne meˈ tuhanin duk tiyaˈ ne siye duwaˈi pitu si kite bi.” ");
INSERT INTO yka_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Inēnan siye weˈ de ēn meˈ tuhanden. Si Barnabas, ēnande si Seus duk si Paul ēnande si Hermes peggeˈ iye luwal mamissāhin. ");
INSERT INTO yka_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Langgal si Seus tuhanden, laˈi du si bukut tarangka puweblo miyaˈan. Imam si langgal miyaˈan, hap pī si tarangka nundan meˈ sapiˈ lella taga meˈ sumping tinōtō diyataˈ kellongde. Imam inin duk meˈ aˈa maˈekkahin batang sumbaliˈde meˈ sapiˈ miyaˈan pagkulubande pu disi Paul. ");
INSERT INTO yka_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Saguwaˈ pagkataˈuhan weˈ si Paul duk Barnabas sōng hininangde inin, ginaret-garet weˈ de semmekden, tandaˈ weˈ gaˈi siye kasulutan. Magubas siye pī si tengngaˈ meˈ aˈa mabanesin duk maggasud siye, ");
INSERT INTO yka_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","paˈinde, “Weˈey inin hinangbi si kami? Manusiyaˈ du hadja kami kuweˈ kaˈamin. Duk hangkan kami inin pitu, ngakahan kaˈam aka-aka mahāpin supaya tayikutanbi ne meˈ tuhanbi iyan, meˈ manggaˈ niyaˈ kagunahanne iyan. Pitu kami supaya kaˈam papinda nuhut Tuhan maˈellumin, Tuhan mamapanjari langit duk bulakin, tahikin duk kēmon bayuˈan diyalemnen. ");
INSERT INTO yka_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Masa awwalley, pinasagadan weˈ Tuhanin meˈ kabangsa-bangsahanin nuhut ine-ine kinabayaˈanden. ");
INSERT INTO yka_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Saguwaˈ bisan awwalley sampay maˈin, niyaˈ du tandaˈ amban Tuhan supaya iye kataˈuhan meˈ manusiyaˈin. Tandaˈ miyaˈan, meˈ hinanganne mahāpin: urunganne kaˈam ulan, pamanjarine meˈ tinanembin si bulanne, urunganne kaˈam kinakan duk pakēgne meˈ ateybin.” ");
INSERT INTO yka_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kuweˈ miyaˈan meˈ bissā disi Paulin, saguwaˈ agen gaˈi tapagesde meˈ aˈahin duk siye gaˈi magkuluban si siye. ");
INSERT INTO yka_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Manjari inin, niyaˈ tekka pī si Listara meˈ Yahudi amban Antiyok si Pisidiya duk amban Ikoni. Kabumbungan weˈ de meˈ aˈa mabanesin pabēbbeg si siye nguntarahan si Paul. Pinagtibagan weˈ de si Paul duk batu. Ubus bu ilalas iye weˈ de binoˈo paluwas amban puweblo miyaˈan peggeˈ kannalde matey ne iye. ");
INSERT INTO yka_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Saguwaˈ sakaliˈ magtipun meˈ masandel pu si Isahin ngaliputan si Paul, kuwat iye duk balik iye pī dem puweblo miyaˈan. Pagsasumuhin hap pī siye duk Barnabas si lahat Derbe. ");
INSERT INTO yka_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paglaˈi ne siye si Derbe, minahalayak weˈ de aka-aka mahāpin si meˈ aˈa malaˈihin. Ekka meˈ aˈa patindeg pu si Isa laˈi. Ubus balik si Paul duk Barnabas pī si Listara, bu Ikoni, ubus bu palanjal siye hap Antiyok, iye Antiyok si lahat Pisidiyahin. ");
INSERT INTO yka_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Biniˈat weˈ de meˈ tindeg si Isa si meˈ puweblo papīhande miyaˈan duk pinabasag weˈ de sandelden. Dinaˈak isab pinateteg si siye sandelden si Tuhan. “Peggeˈ,” paˈin disi Paul, “subey ekka kasusehan talabeyte bi meke kite bi sakup dem pagbayaˈan Tuhanin.” ");
INSERT INTO yka_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Si meˈ kalahatan papīhanden, antag-antag niyaˈ meˈ masandel pu si Isahin, meneˈ disi Paul meˈ aˈa hinang bahiˈde. Ubus, muwase disi Paul duk māku-māku si Tuhan para si meˈ bahiˈ miyaˈan. Māku-māku siye weˈ karayaw inipat du meˈ masandel pu si Isahin weˈ Panuhutanden, iye pangandelanden. ");
INSERT INTO yka_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pagtabutas weˈ disi Paul lahat Pisidiyahin, tekka siye si lahat Pampiliya. ");
INSERT INTO yka_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pī siye hap puweblo Perga duk minahalayak weˈ de lapal Tuhanin laˈi. Ubus bu padurul siye hap Attaliya. ");
INSERT INTO yka_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Manjari patulak siye balik hap Antiyok. Laˈi hep si Antiyok miyaˈan pamāku-māku meˈ masandel pu si Isahin weˈ ipat Tuhanin disi Paul, sōng palumengngande magmahalayak aka-aka mahāpin. Duk kuweˈitu taˈubusde ne hinangde miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pagtekka disi Paul laˈi si Antiyok, tinipun weˈ de kēmon masandel pu si Isahin. Inaka-akahan siye weˈ de kēmon meˈ tahinangden weˈ tabang Tuhan si siyehin. Inaka-akahan isab siye weˈ de, weˈ kapagmahalayak ne siye si meˈ bangsa dumaˈin Yahudi sabab si Isa duk ekka ne siye sandel pu si Isa. ");
INSERT INTO yka_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tiggel disi Paul patennaˈ laˈi duk meˈ masandel pu si Isa si Antiyokin. ");
INSERT INTO yka_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Manjari inin, niyaˈ meˈ aˈa amban Yahudiya hap pī si Antiyok. Magtoloˈ siye si meˈ masandel pu si Isa malaˈihin. Paˈinde, “Gaˈi kaˈam makajari timbul bang gaˈi kaˈam inislam sa pangandaˈakan si Musahin.” ");
INSERT INTO yka_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Jinawab teˈed weˈ si Paul duk Barnabas meˈ aˈa miyaˈan duk magpasuweyan teˈed siye sabab toloˈde miyaˈan. Hangkan magisun meˈ katindegan si Isa si Antiyokin weˈ subey si Paul duk Barnabas duk sinduwe meˈ kapungtinaˈihanin hap Awrusalam, nilew meˈ kawakilanin duk meˈ bahiˈin sabab palkalaˈ miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pinalengngan ne siye weˈ meˈ masandel pu si Isa si Antiyokin. Pabutas siye amban lahat Penisiya duk amban Samariya. Sābude mapabutasin, inaka-aka weˈ de weˈ meˈ bangsa dumaˈin Yahudihin sandel ne pu si Isa. Kēgan teˈed meˈ masandel pu si Isahin kēmon pagkalede inin. ");
INSERT INTO yka_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pagtekka disi Paul si Awrusalam, sinampang siye weˈ meˈ masandelin duk meˈ kawakilanin duk meˈ kabahiˈanin. Inaka-aka ne weˈ disi Paul si siye kēmon bakas tahinangde weˈ tabang Tuhan si siyehin. ");
INSERT INTO yka_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Saguwaˈ niyaˈ meˈ Pariseo masandel pu si Isahin nengge laˈi missā. Paˈinde, “Meˈ masandel pu si Isa amban meˈ bangsa seddili miyaˈan subey inislam dahuˈ duk subey isab tuhutde saraˈ si Musahin.” ");
INSERT INTO yka_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Manjari magtipun meˈ kawakilanin duk meˈ kabahiˈanin mikil bang inumey palkalaˈ miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pagtiggel-tiggel ne siye magisun, nengge si Petros duk paˈinne, “Meˈ kapungtinaˈihanku, kataˈuhanbi du weˈ matuˈuhin pe, tapeneˈ ku weˈ Tuhanin amban kaˈam dinaˈak magmahalayak pī si meˈ kabangsahan seddili supaya takalede duk kahagadde aka-aka mahāp sabab si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Duk Tuhanin, mangataˈuhan diyalem atey manusiyaˈin, pakitehanne weˈ meˈ kabangsahan seddilihin sukuˈ si iye du isab, sabab pinangurung isab weˈ ne si siye Niyawa Sutsihin sa si kitehin bi. ");
INSERT INTO yka_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Gaˈ siye pagbiddaˈne duk kite bi,” paˈin si Petros. “Inampun du isab weˈ ne meˈ duseden peggeˈ sandel siye pu si Isa. ");
INSERT INTO yka_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Na,” paˈin si Petros, “weˈey batang paˈastelbi Tuhanin sabab pahunitanbi pe meˈ masandel pu si Isahin. Daˈakbi siye nuhut saraˈin bu bisan meˈ kapapuˈante bi ley duk sampay kite bi gaˈ du tahinangte bi. ");
INSERT INTO yka_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Daˈa ne. Sandel kite bi pu si Isa, Panuhutanin, duk pinaluwas ne kite bi amban duseten bi peggeˈ malasa duk maˈaseˈ iye si kite bi. Damikkiyan isab meˈ aˈa amban kabangsahan seddilihin.” ");
INSERT INTO yka_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pagkalede pinaˈin si Petros miyaˈan, gaˈ siye kēmon kumebbut. Duk pinakale weˈ de Barnabas duk si Paul magaka-aka sabab meˈ hinangan balakatan duk makaˈulaliˈ tahinangde weˈ balakat Tuhanin laˈi diyaleman meˈ kabangsahan dumaˈin Yahudihin. ");
INSERT INTO yka_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pagubus siye missā, pagantiˈ missā si Yakub. Paˈinne, “Meˈ kapungtinaˈihanku, pakale kaˈam si aku. ");
INSERT INTO yka_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Bakas pahāti si Petros ne magbaˈahu miyaˈan si kaˈam sabab tagnaˈ pamakite Tuhan lasane si meˈ kabangsahan dumaˈin Yahudihin, supaya isab niyaˈ amban siye meˈ aˈa sukuˈ si Tuhan. ");
INSERT INTO yka_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Maguyun bissā si Petros miyaˈan duk tasulat meˈ kanabi-nabihan awwalley. Tasulat hep dem kitab, pinaˈin, ");
INSERT INTO yka_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Puwas inin, balik du ku, paˈin Tuhanin, duk patenggeku du balik lumaˈ si Daˈud bakas mahebbaˈin. (Hāti lumaˈ Daˈudin pagsultanannen.) Pahāpku du malarakin duk hinangku lumaˈ balik. ");
INSERT INTO yka_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ubus kēmon meˈ aˈa amban kabangsahan seddilihin, pihade du ku isab peggeˈ tapeneˈku isab siye, paˈin Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Inin lapal Tuhanin, pinakataˈu weˈ ne kemuwe awwalley.’ ");
INSERT INTO yka_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Bang si pikilanku,” paˈin si Yakub, “subey gaˈi sasewte bi meˈ aˈa amban kabangsahan seddili mapatuhut si Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Saguwaˈ subey siye paboˈohante bi sulat ngakahan siye weˈ subey siye gaˈi mangan ine-ine bakas paglamas si meˈ limbagan tuhan-tuhan, subey siye gaˈi magjina, subey siye gaˈi mangan hayep pikel, duk subey siye gaˈi mangan lahaˈ. ");
INSERT INTO yka_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Meˈ saraˈ si Musa inin kemuwe matuˈuhin asal minahalayak du si kēmon kalahat-lahatan duk binatsa kahabaˈ ellew Sabtuˈ dem meˈ kalanggal-langgalan bangsaten bi.” ");
INSERT INTO yka_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Manjari magpikilan meˈ kawakilanin duk meˈ kabahiˈanin sampay kēmon meˈ masandel pu si Isahin, weˈ meneˈ siye meˈ aˈa amban siye pinatuhut pu si Paul duk Barnabas hap Antiyok. Pineneˈ weˈ de si Judas Barsabbas duk si Silas. Duwangan inin asal pinagaddatan teˈed weˈ meˈ pagkaside tindeg si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Maboˈo siye sulat duk inin pinaˈin dem sulatin: “Sulat inin amban meˈ kapungtinaˈihanbi matuˈu si Awrusalamin, meˈ kawakilanin, duk meˈ kabahiˈanin. Pinasampay inin weˈ kami si kaˈam kēmon meˈ kapungtinaˈihan kami amban kabangsahan seddilihin, meˈ maglahat luˈu si Antiyokin, si Siriyahin, duk si Kilikiyahin. ");
INSERT INTO yka_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Takale kami weˈ niyaˈ koˈ meˈ katindegan si Isa bittuˈu amban kami bakas piyu nasew meˈ pikilanbin sabab meˈ panoloˈden. Dumaˈin miyaˈan pangandaˈakan kami siye. ");
INSERT INTO yka_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hangkan magisun kami kēmon weˈ meneˈ kami meˈ aˈa tuˈu daˈak kami piyu si kaˈam. Patuhut kami siye pu Barnabas duk si Paul, meˈ bagay kinalasahan teˈed. ");
INSERT INTO yka_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Disi Paul inin, meˈ aˈa gaˈi ngayimanan umulden, bang si hinangde para si Panuhutanten bi, Isa Almasi. ");
INSERT INTO yka_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Manjari tiyaˈ ne daˈak kami piyu si kaˈam si Judas duk si Silas patampak ngakahan kaˈam sa sinulat kami inin. ");
INSERT INTO yka_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Peggeˈ Niyawa Sutsihin duk kami maguyun weˈ gaˈi kaˈam subey pinahunitan palabi amban meˈ daˈakan subey teˈed tinuhut inin: ");
INSERT INTO yka_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","daˈa kaˈam mangan ine-ine bakas paglamas si meˈ limbagan tuhan-tuhan, daˈa kaˈam mangan lahaˈ, daˈa kaˈam mangan hayep pikel, duk daˈa kaˈam magjina. Bang gaˈi inin hinangbi, hāp hinanganbin. Taman inin ne hadja. Wassalam.” ");
INSERT INTO yka_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Manjari lumengngan ne meˈ aˈa dinaˈakde mamoˈo sulat miyaˈan. Pī siye hap Antiyok duk pagtekkade laˈi, tinipun weˈ de meˈ masandel pu si Isahin duk sinōngan weˈ de si siye sulatin. ");
INSERT INTO yka_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pagbatsade sulatin, kēgan teˈed siye sabab sulat makaˈasig-asig ateyde miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Si Judas duk si Silas inin, meˈ aˈa magpalataˈ bissā Tuhanin. Tiggel pangusihatde meˈ masandel pu si Isa malaˈi si Antiyokin panabang siye, supaya ngabasag sandelden duk asig ateyden. ");
INSERT INTO yka_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pagtiggel-tiggel ne disi Judas laˈi, pinapoleˈ ne siye weˈ meˈ masandel pu si Isa malaˈihin. “Karayaw hāp du lengnganbin, gaˈ baya-bayabi,” paˈinde. ");
INSERT INTO yka_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Manjari balik ne disi Judas pī si meˈ bakas mangandaˈak siyehin. ");
INSERT INTO yka_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Saguwaˈ si Paul duk Barnabas paˈamban pe laˈi si Antiyok. Magtoloˈ siye duk magmahalayak lapal Tuhanin magtuhut duk meˈ sinduwehin. ");
INSERT INTO yka_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pagpuwas bang piyem bahangi, paˈin si Paul pu Barnabas, “Sūng kite balik pī nindew meˈ pagkasite tindeg si Isa si kalahat-lahatan bakas pagmahalayakante lapal Tuhanin. Payamante bang saˈingge du siye ley.” ");
INSERT INTO yka_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bayaˈ boˈo Barnabas si Yahiya Markus. ");
INSERT INTO yka_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Saguwaˈ pikilan si Paulin weˈ gaˈi si Markus patut binoˈo peggeˈ bakas inambanan hep siye weˈ ne laˈi si Pampiliya, duk gaˈ iye makatatas nabangan siye sampay ubus hinangden. ");
INSERT INTO yka_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Magjawab teˈed duwanganin hangkan magsapeˈ ne siye. Binoˈo weˈ Barnabas si Markus duk patulak siye hap pūˈ Kiprus. ");
INSERT INTO yka_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Si Paul isab tapeneˈne hinang saweˈin si Silas. Meˈ katindegan si Isa malaˈihin māku-māku si Tuhan para pu disi Paul weˈ ipat Tuhanin du siye. Ubus bu lumengngan ne siye. ");
INSERT INTO yka_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pabutas siye si lahat Siriya duk si lahat Kilikiya. Inusihatan weˈ de meˈ katindegan si Isa si meˈ lahat miyaˈan supaya haget sandelden. ");
INSERT INTO yka_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Manjari palanjal si Paul hap Derbe ubus bu hap Listara. Laˈi si Listara, niyaˈ dambuwaˈ aˈa sandel pu si Isa inēnan Timoteo. Saˈinen bangsa Yahudi, sandel du isab pu si Isa. Samanen bangsa Girik. ");
INSERT INTO yka_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kēmon masandel pu si Isa si lahat Listarahin duk si lahat Ikonihin, hāp bissāde sabab Timoteohin. ");
INSERT INTO yka_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bayaˈ si Paul moˈo Timoteo hinangne saweˈne maglengngan. Saguwaˈ kēmon Yahudi si kalahatan miyaˈan, kataˈuhande weˈ sama Timoteohin bangsa Girik, hangkan inislam dahuˈ weˈ si Paul si Timoteo supaya iye pagaddatan meˈ Yahudihin. ");
INSERT INTO yka_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Manjari lumengngan ne disi Paul pī si meˈ kalahat-lahatan duk inaka weˈ de si meˈ masandel pu si Isahin meˈ daˈakan amban meˈ kawakilanin duk meˈ kabahiˈan si Awrusalamin. Dinaˈak weˈ de tinuhut meˈ daˈakan miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Hangkan hep meˈ masandelin ngabasag sandelden duk pasōng ellewin, pasōng isab ekkaden. ");
INSERT INTO yka_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Na, lumengngan disi Paul pabutas si lahat Pirigiya duk lahat Galatiya peggeˈ gaˈ siye dinaˈak weˈ Niyawa Sutsihin pī si lahat Asiya magmahalayak lapal Tuhanin. ");
INSERT INTO yka_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pagtekkade si sīng lahat Misiya, sōng siye palanjal pī si lahat Bitiniya. Saguwaˈ gaˈ isab siye dinaˈak weˈ Niyawa Sutsihin. ");
INSERT INTO yka_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hangkan pabutas siye amban tengngaˈ lahat Misiya bu padurul tudju lahat Toroas. ");
INSERT INTO yka_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Manjari inin, laˈi si Toroas sangem miyaˈan, niyaˈ pinabagala pu si Paul weˈ Tuhanin dambuwaˈ aˈa amban Makedoniya makitabang si iye. Paˈin aˈa miyaˈan, “Palipag kew pitu si Makedoniya duk tabangun kami.” ");
INSERT INTO yka_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pagubus takite si Paul mapabagala miyaˈan, magtawus kami magmemes peggeˈ tahāti kami weˈ tinawag kami weˈ Tuhanin hap Makedoniya magmahalayak si meˈ aˈa malaˈihin aka-aka mahāp sabab si Isahin. ");
INSERT INTO yka_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Patulak kami amban Toroas nalus tudju pūˈ Samotarake. Pagellew dambuwaˈin, patulak ne isab kami amban pūˈ miyaˈan tudju Neapolis. ");
INSERT INTO yka_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tekka laˈi pataked kami hap Pilipi, puweblo hadje laˈi si Makedoniya. Ekka meˈ aˈa bangsa Roma patennaˈ laˈi. Padeheng kami laˈi bang piyem bahangi pe. ");
INSERT INTO yka_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pagellew Sabtuˈ, paluwas kami amban puweblo miyaˈan pī si ubey boheˈ peggeˈ tatokod kami weˈ niyaˈ laˈi lugal pangampunan meˈ Yahudihin. Ningkoloˈ kami laˈi duk missā kami si meˈ dende magtipun malaˈihin. ");
INSERT INTO yka_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Dambuwaˈ meˈ dende mapakale si kamihin, dende inēnan Lidiya amban puweblo Tatira. Bahannen magdagang-dagang semmek taluk mahalgaˈ teˈed. Dende inin magsambahayang si Tuhan. Sābune mapakale si kamihin, inurungan iye pikilan weˈ si Isa, Panuhutanin, duk kinahagad weˈ ne binissā si Paulin. ");
INSERT INTO yka_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Pinandi disi Lidiya duk meˈ saweˈne dambuwaˈ lumaˈin, tandaˈ weˈ sukuˈ pu si Isa ne siye. Ubus miyaˈan, inohotan kami weˈ si Lidiya, paˈinne, “Bang pikilbi du weˈ aku asal bennal ne teˈed sandel pu si Isa, Panuhutanin, nuhut dahuˈ kaˈam patennaˈ si lumaˈku.” Duk boˈone teˈed kami. ");
INSERT INTO yka_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Dambuwaˈ ellew, sābu kami hap pī si lugal pangampunan, niyaˈ talanggal kami banyagaˈ dende pasayedan seyitan, hangkan taˈu iye magpayam. Ekka sīn kasuwaˈ meˈ amunen sabab pagpayamne miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Paturul-turul iye si kami duk si Paul duk ngalingan-ngalingan iye, paˈinne, “Meˈ aˈa inin daraˈakan Tuhan Tamanan Malangkewin. Akahande kaˈam bang saˈingge katimbulbin.” ");
INSERT INTO yka_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Bang piyem bahangi luwal iye ngalingan kuweˈ miyaˈan. Ujudnen jumuˈ ne si Paul pakale si iye. Hangkan hinarap iye weˈ si Paul duk missā iye si seyitanin, paˈinne, “Si ēn Isa Almasi daˈakte kew paluwas amban dende iyan.” Magtawus seyitanin paluwas. Hangkan gaˈi ne taˈu dendehin magpayam. ");
INSERT INTO yka_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pagkite meˈ amunen weˈ gaˈ ne niyaˈ usahade, siniggew weˈ de si Paul duk si Silas duk ilalas weˈ de binoˈo pī si meˈ nakuraˈin laˈi si tabuˈan. ");
INSERT INTO yka_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Pinaharap siye weˈ de si meˈ bagellal bangsa Romahin bu tinuntutan weˈ de. “Meˈ aˈa inin moˈo sasew si lahatte bi,” paˈinde. “Dagun siye inin meˈ bangsa Yahudi. ");
INSERT INTO yka_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Magtoloˈ siye meˈ addat gaˈi makajari tuhut meˈ aˈa bangsa Roma kuweˈ kitehin bi. Meˈ panoloˈden kuntara si saraˈte bi.” ");
INSERT INTO yka_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Meˈ aˈa magtipun malaˈihin patuhut isab nguntarahan siye. Manjari ilarut weˈ meˈ bagellalin meˈ semmek si Paul duk si Silasin, duk dinaˈak siye ilagutan. ");
INSERT INTO yka_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pagubus siye ilagutan manamal, kinalabusu siye. Dinaˈak weˈ meˈ bagellalin pinahaget teˈed gawang kalabusuhin si guwaldiyahin. ");
INSERT INTO yka_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Pagkale guwaldiyahin uldin miyaˈan, binoˈo weˈ ne disi Paul pī si kalabusu diyalem teˈedin duk pinasungan siye weˈ ne. ");
INSERT INTO yka_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Manjari inin, pagnengaˈ bahangi ne, māku-māku disi Paul si Tuhan duk magkalangan siye meˈ kalangan mudji Tuhanin. Pakale si siye meˈ pilisu sinduwehin. ");
INSERT INTO yka_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bessuwang niyaˈ linug basag teˈed hangkan jedjeg pabettadan kalabusu miyaˈan. Magtawus paluka kēmon gawangin duk tantang meˈ karena pilisuhin kēmon. ");
INSERT INTO yka_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Manjari ngape guwaldiyahin duk pagkitene weˈ luka ne meˈ gawang kalabusuhin, kannalne weˈ lumahi ne meˈ pilisuhin. Hangkan inurus weˈ ne bessinen sōng mapatey dine. ");
INSERT INTO yka_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Saguwaˈ ngalingan si Paul papales paˈinne, “Daˈa kew minasa dinu. Tiyaˈ du kami kēmon.” ");
INSERT INTO yka_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ngalingan guwaldiyahin māku tiyew bu padayiˈ iye padiyalem. Pahebbaˈ iye migpid si antag bettis si Paul duk si Silas. ");
INSERT INTO yka_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Manjari binoˈo siye weˈ ne paluwas duk paˈinne si siye, “Meˈ tuwan, ine subey hinangku duk ku timbul?” ");
INSERT INTO yka_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Paˈin disi Paul, “Sandel kew pu si Isa Almasi, Panuhutanin, duk timbul du kew sampay meˈ saweˈnu dambuwaˈ lumaˈin.” ");
INSERT INTO yka_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ubus bu minahalayak weˈ de lapal sabab si Isa, Panuhutanin, si guwaldiyahin duk si kēmon saweˈne dambuwaˈ lumaˈin. ");
INSERT INTO yka_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Duk bisan lalem bahangi ne, binoˈo siye weˈ guwaldiyahin paluwas duk kinosoˈan weˈ ne meˈ bakatden. Pagubus miyaˈan, pinandi weˈ de guwaldiyahin duk kēmon siye dambuwaˈ lumaˈin, tandaˈ weˈ sukuˈ pu si Isa ne siye. ");
INSERT INTO yka_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ubus binoˈo weˈ guwaldiyahin si Paul duk si Silas pī diyataˈ lumaˈne duk pinakan siye weˈ ne. Kēgan teˈed siye dambuwaˈ lumaˈin peggeˈ Tuhanin ne pangandelanden. ");
INSERT INTO yka_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pagsalung ne, dinaˈak weˈ meˈ bagellalin meˈ pulisin moˈo uldin pī si kalabusu, pinaˈin, “Paluwasun ne meˈ aˈa iyuˈ.” ");
INSERT INTO yka_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Inaka inin weˈ guwaldiyahin pu si Paul. Paˈinne, “Masan meˈ bagellalin dinaˈak ne kaˈam pinaluwas. Hangkan paluwas ne kaˈam duk karayaw hāp du lengnganbin.” ");
INSERT INTO yka_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Saguwaˈ paˈin si Paul si meˈ pulisin, “Diˈilew ilagutan kami weˈ de si kaˈekkahan aˈa bisan kami gaˈ tapaliksaˈde. Bu kami inin, aˈa Roma kami. Ubus kinalabusu pe kami weˈ de. Hatiˈ kuweˈitu kabayaˈanden patahalaˈde kami sipuk? Gaˈi makajari,” paˈin si Paul. “Subey meˈ bagellal miyaˈan pitu maluwas kami.” ");
INSERT INTO yka_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Meˈ bissā si Paul miyaˈan inaka weˈ meˈ pulisin si meˈ bagellalin. Pagkalede weˈ si Paul duk si Silas taga sulat weˈ siye bangsa Roma, tinalew siye. ");
INSERT INTO yka_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Hangkan hap pī siye māku ampun pu disi Paul. Ubus binoˈo weˈ de disi Paul paluwas amban dem kalabusu duk binuyuˈ-buyuˈ siye weˈ de dinaˈak tahalaˈ ne amban puweblo miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Manjari hap pī si Paul duk si Silas si lumaˈ si Lidiya. Magkasuwaˈ siye duk meˈ katindegan si Isahin laˈi duk missā disi Paul si siye pangasig ateyden. Ubus bu tahalaˈ ne siye. ");
INSERT INTO yka_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Manjari inin, lumengngan disi Paul pabutas amban puweblo Ampipolis duk puweblo Appolon. Ubus tekka siye si puweblo Tessalonika. Niyaˈ laˈi dambuwaˈ langgal Yahudi. ");
INSERT INTO yka_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Sa hinangannen, hap pī si Paul si langgal. Tellu Sabtuˈ magturul-turul, magsuˈal iye duk meˈ Yahudihin sabab meˈ panoloˈ dem kitabin. ");
INSERT INTO yka_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pinahātihan weˈ ne si siye duk ngurung isab iye pureba amban dem kitab weˈ subey Almasihin makalabey kabinasahan duk pinapatey duk ellum du iye balik amban kamateynen. Ubus paˈinne, “Si Isa, minahalayakku si kaˈam inin, iye ne Almasihin.” ");
INSERT INTO yka_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Meˈ Yahudi sinduwehin kahagad duk patuhut ne pu si Paul duk si Silas. Duk ekka isab patuhut meˈ bangsa Girik, meˈ aˈa magsambahayang si Tuhan. Duk ekka du isab meˈ dende bangsahan patuhut. ");
INSERT INTO yka_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Saguwaˈ meˈ Yahudi sinduwehin ngimbū, hangkan tinawag weˈ de meˈ aˈa dupang amban meˈ kalān-lānanin duk pinagtipun weˈ de bu jinabu weˈ de puweblo miyaˈan. Ginuhu weˈ de lumaˈ si Jasonin pamihahande si Paul duk si Silas, supaya siye taboˈode pī paluwas si meˈ aˈahin. ");
INSERT INTO yka_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Saguwaˈ peggeˈ gaˈ siye kasuwaˈde, ilalas weˈ de si Jason duk meˈ tindeg si Isa sinduwehin pī si meˈ bagellalin. Ngalingan siye papales, paˈinde, “Tiyaˈ ne tekka si puweblote bi inin meˈ manasew kalahat-lahatanin. ");
INSERT INTO yka_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Duk si Jason inin, inennaˈ siye weˈ ne dem lumaˈne. Kēmon siye inin langgalande saraˈ Sultan Nakuraˈin. Paˈinde weˈ niyaˈ koˈ sultan seddili, ēnnen si Isa.” ");
INSERT INTO yka_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sabab bissāde miyaˈan, hewuhalaˈ ne meˈ aˈa mabanesin duk sampay meˈ bagellalin. ");
INSERT INTO yka_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Manjari si Jason duk meˈ saweˈnen dinaˈak magbayed piyansa weˈ meˈ bagellalin, ubus bu pinapoleˈ ne siye. ");
INSERT INTO yka_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pagsangem ne, dinaˈak si Paul duk si Silas weˈ meˈ pagkaside tindeg si Isahin tahalaˈ hap Berea. Pagtekkade si Berea, hap pī siye si langgal Yahudi. ");
INSERT INTO yka_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Meˈ Yahudi malaˈihin lunuk ateyden amban meˈ Yahudi si Tessalonikahin. Kēgan teˈed siye pakale si meˈ usihat disi Paulin, duk ellew-ellew hinapal weˈ de kitabin pamayamande bang asal toˈo ke panoloˈ si Paulin. ");
INSERT INTO yka_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ekka meˈ aˈa Bereahin sandel ne pu si Isa, sampay meˈ dende bangsahan amban bangsa Girik, duk meˈ lella Girik isab. ");
INSERT INTO yka_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Saguwaˈ pagkale meˈ Yahudi si Tessalonikahin weˈ īˈ si Paul si Berea magmahalayak lapal Tuhanin, hap pī isab siye laˈi nasew duk ngawul meˈ aˈa malaˈihin. ");
INSERT INTO yka_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Magtawus si Paul dinaˈak weˈ meˈ masandel pu si Isahin padurul pī si higad tahik. Saguwaˈ si Silas duk Timoteo paˈamban laˈi si Berea. ");
INSERT INTO yka_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tinuhutan si Paul hap pī si puweblo Aten. Ubus balik ne meˈ manuran iyehin hap Berea moˈo sessaˈ amban si Paul weˈ subey si Silas duk Timoteo paturul si iye mura. ");
INSERT INTO yka_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Manjari inin, sābu si Paul laˈi si Aten ngagadan si Silas duk Timoteo, sasew teˈed ateynen pagkitene weˈ laˈi si puweblo miyaˈan ekka teˈed limbagan tuhan-tuhan. ");
INSERT INTO yka_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hap pī iye dem langgal duk magsuˈal iye laˈi duk meˈ Yahudi, duk meˈ aˈa bangsa seddili isab, meˈ manambahayang si Tuhanin. Ellew-ellew laˈi isab iye si tabuˈan magsuˈal duk meˈ aˈa malaˈihin. ");
INSERT INTO yka_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Duk niyaˈ isab meˈ guru taboˈone magsuˈal. Meˈ guru miyaˈan, iye tinuhutden meˈ panoloˈ aˈa inēnan Epikuru duk panoloˈ meˈ aˈa inēnan Istoik. Pagkalede si Paul magusihat sabab si Isa duk sabab kaˈellumne mabalik amban kamateynen, paˈin meˈ sinduwehin, “Ine be pinoppot aˈa inin?” Paˈin sinduwehin isab, “Aˈa inin kuweˈ magpalataˈ sabab tuhan seddili gaˈi kataˈuhan tuˈu si lahatte bi inin.” ");
INSERT INTO yka_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Manjari binoˈo weˈ de si Paul pī si kakunsihalanin, magtipun laˈi si lugal ēnande Areopagus. Paˈinde pu si Paul, “Batang kami ngataˈu sabab toloˈ baˈahu binissānu miyaˈan. ");
INSERT INTO yka_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Meˈ bissānu miyaˈan gaˈ bakas takale kami, hangkan batang kataˈuhan kami hātinen.” ( ");
INSERT INTO yka_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kēmon hep meˈ aˈa Atenin duk meˈ aˈa liyu-liyu mapatennaˈ malaˈihin, tagihan siye magheto-heto duk pakale-kale sabab ine-ine baˈahu.) ");
INSERT INTO yka_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Manjari nengge si Paul si harapan meˈ kakunsihalanin duk paˈinne, “Kaˈam meˈ aˈa Atenin, tapandogaku weˈ asal be-āgama teˈed kaˈam. ");
INSERT INTO yka_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Peggeˈ sābuku miyaˈan lumengngan-lengngan tuˈu si puweblobi, takiteku meˈ bayuˈ-bayuˈan sinumbabin. Niyaˈ takiteku dambuwaˈ lugal panumbahanbi duk tasulat bissā inin laˈi, pinaˈin, ‘Iye inin lugal panumbahan tuhan manggaˈi kinataˈuhanten bi.’ Na,” paˈin si Paul, “tuhan manggaˈi kinataˈuhanbin saguwaˈ sinumba weˈ bi, iye ne inin Tuhan pinahātiku si kaˈam kuweˈitu inin. ");
INSERT INTO yka_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Iye inin Tuhan magpapanjari dunyahin duk kēmon bayuˈ-bayuˈan dem dunyahin. Iye magbayaˈ si surgaˈin duk si dunyahin. Gaˈi Tuhan inin patennaˈ dem meˈ lumaˈ panumbahan hinangan manusiyaˈ. ");
INSERT INTO yka_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Duk gaˈi isab iye makitabang si manusiyaˈ peggeˈ gaˈ du niyaˈ kulang si iye. Bisan miyaˈan, iye pe mangurung umulin duk napasin duk kēmon bayuˈ-bayuˈan ginuna manusiyaˈin. ");
INSERT INTO yka_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Aˈa tagnaˈ pinapanjari weˈ Tuhanin,” paˈin si Paul, “iye miyaˈan tagnaˈ meˈ kabangsa-bangsahanin kēmon duk pinalahat siye weˈ Tuhanin tuˈu si tibuˈukan dunya. Duk andang ne ginantaˈan weˈ ne bang saˈingge tiggelanden duk bang lahat ingge patennaˈanden. ");
INSERT INTO yka_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Hinang Tuhanin inin si meˈ kabangsa-bangsahanin supaya du iye pihade duk si pagtuyuˈden kaw du iye kasuwaˈde. Saguwaˈ,” paˈin si Paul, “gaˈi du hep Tuhanin tala amban kite bi. ");
INSERT INTO yka_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Peggeˈ hangkan kite bi ellum, hangkan kite bi tapaˈusaˈ, hangkan kite bi taga niyawa, sabab Tuhanin. Kuweˈ du isab pinaˈin meˈ aˈa magkata-katahin, ‘Kite bi inin meˈ anak Tuhanin du.’ ");
INSERT INTO yka_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Na, peggeˈ meˈ anak Tuhanin kite bi,” paˈin si Paul, “subey kite bi gaˈi magpikil weˈ Tuhanin kuweˈ bantuk meˈ limbagan bulawan atawa pilak atawa batu, hininang amban pikilan duk kapandeyan manusiyaˈ. ");
INSERT INTO yka_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Matuˈuhin, peggeˈ awam pe meˈ aˈahin sabab Tuhanin, gaˈ ne hinang ine weˈ Tuhanin meˈ hinangande miyaˈan. Saguwaˈ kuweˈitu, iye pangandaˈakan Tuhanin si kēmon manusiyaˈ antag-antag, weˈ subey ne pagsusunande meˈ duseden duk lebbahande ne, gaˈi ne hininang-hinang balik. ");
INSERT INTO yka_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Peggeˈ bakas kineddewan ne weˈ Tuhanin ellew pangahukumne manusiyaˈin kēmon, duk hukumannen bentel. Duk bakas t