﻿USE sofia;
DROP TABLE IF EXISTS sofia.yer_vpl;
CREATE TABLE yer_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yer_vpl WRITE;
INSERT INTO yer_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Aɗin ovan oga aIsa̱rila ova̱ ga aMasar ká̱ uYakup, udanggo ká̱ nzhi wò te oma ta̱. ");
INSERT INTO yer_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","URuben ká̱ uSimeyon, ká̱ uLawi ká̱ uYahuda, ");
INSERT INTO yer_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ká̱ uYisakar, ká̱ uZebulun, ká̱ uBenjamin, ");
INSERT INTO yer_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ká̱ uDan, ká̱ uNaftali, ká̱ uGat, ká̱ uAsher. ");
INSERT INTO yer_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Akum ìjili aYakup pa̱ kpaktak te, ìsəm pa̱ ifangshat. UYusufu ka̱ yà chit ka̱ ashe mbin aMasar jiwò. ");
INSERT INTO yer_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","UYusufu ká̱ nkpaktak ogənang wò ká̱ nlwàk oza̱ kú. ");
INSERT INTO yer_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ká̱ nna te oga aIsa̱rila myak ga mpyal pa̱ makmak, á kam pa̱ gənggəng kang oza̱ yə́l mələk ashe mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Te uponzhi upipye uro wong yà ka̱ aMasar, uva̱ nyi iya̱m iro ka̱ apal aYusufu ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Uza̱ là onəm wò pa̱, <<Ó dər, onəm oga aIsa̱rila ova̱ ta̱ yə́l kang à kam chit ji yi. ");
INSERT INTO yer_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Re í mwo aghan aga nggəl mmyak oza̱ ka̱t te, onəm oga nkpàng yi á ru yi ká̱ ìkum te, oza̱ i gwang awo ká̱ oza̱ i lung yi. Te i wong i chəng i re mbin yi.>> ");
INSERT INTO yer_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Te uPonzhi uga aMasar ká̱ onəm ochumchum wò nak onəm oga mpángchí ozwal pa̱ á na inok iɗəkɗək ôvan oga aIsa̱rila i va i na idumdùm ôza̱ pa̱ makmak. Á me oga ìtong ka̱kul mɓut iya̱m ûFirona va mí wór pa̱ aFitom ka̱ aRamaset. ");
INSERT INTO yer_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Kap ká̱ nva̱ pa̱ oga aMasar kà̱ nnəm idumdùm oIsa̱rila te, oIsa̱rila ga mpyal ká̱ mmyak ga chu iyə́l oza̱ ɓan nna ayər oga aMasar. ");
INSERT INTO yer_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Te oga aMasar nəm ifan oza̱ pa̱ zhalatzhalat kà̱ nnəm izwal. ");
INSERT INTO yer_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Oza̱ dungshi ìgwak oga aIsa̱rila ká̱ inok iɗəkɗək, i nak oza̱ i kà̱p amyè, i tòng, i nəm abərki ká̱. Kang à nəm ifan ôza̱ kà̱ nnəm inok ka̱ ashe íram oza̱. ");
INSERT INTO yer_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","UPonzhi oga aMasar là ôchar va̱ kà̱ nnəm inok nka̱m amar óchar oHiburu, oma uSifira ka̱ uFuya pa̱, ");
INSERT INTO yer_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","<<O wong nka̱mshi ochar oHiburu kà̱ mmar te, o dər a yà pa̱ uyennunggwan te, o gba̱l, kang a yà pa̱ uyenchar nnyi te, o re na ka̱ irirì.>> ");
INSERT INTO yer_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ka̱kul pa̱ ochar ova̱ ta ra ayər Inan ra te, oza̱ kpak iya̱m iva̱ uponzhi là ka̱t, oza̱ re onunggwan ka̱ irirì kpa. ");
INSERT INTO yer_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Te uponzhi oga aMasar wór ochar ova̱ ta ɓəp oza̱ pa̱, <<Sang kang o nəm wa nva̱ ta̱ yà? Ó nəm sang kang o re ovan onunggwan ka̱ irirì yà?>> ");
INSERT INTO yer_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ochar ova̱ ta là uFirona pa̱, <<Ochar oHiburu wa oga aMasar ka̱t, oza̱ kam byet, kang î ga ka̱ atak oza̱ te, oza̱ mar chit.>> ");
INSERT INTO yer_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Inan nəm inəna̱n ôchar oga nka̱m amar ava̱ ta. Te à nak onəm yə́l kang oza̱ kam pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ka̱kul ochar ova̱ ta̱ oma ka̱ ayər Inan te, Inan na ovan ôza̱ pa̱ makmak. ");
INSERT INTO yer_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Te uFirona nak nkpaktak onəm wò pa̱, <<Nza̱ uyennunggwan nggo mmá mar te, o mang ka̱ ashe awang aNilu. Kang nza̱ uyenchar nggo te, o re ka̱ irirì.>> ");
INSERT INTO yer_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","UNəm uro ka̱ akum aLawi ka̱m uchar ka̱ akum oza̱. ");
INSERT INTO yer_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Uchar uva̱ ta yar anyám te, á mar uyennunggwan. Uza̱ ya ri ìgwak à na te, à bwam na apye pa̱ shatɗing. ");
INSERT INTO yer_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Kang uza̱ ya pa̱ ò kur mbwam na làp ka̱t te, uza̱ yar nya mbanda̱r nro nva ngga nlòk ká̱ amár kang uza̱ ɓam nsəsəm ka̱ njəng ìkáng, te uza̱ nak uyen va̱ ta ka̱ ashishe, à yar gá nak ka̱ ashe oga isəksək ka̱ anung akonkong awang aNilu. ");
INSERT INTO yer_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ugənang ayenba̱k uva̱ ta uchar ta̱l ka̱ atak aro pa̱ gba̱ngba̱ng na ô dər pa̱ iza̱ i nəm na yà. ");
INSERT INTO yer_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Uya aFirona uyenchar fər ga ngwòr izər ka̱ awang aNilu, kang ovan ochar ozwal oga nnəm inok á na nnyi te, oza̱ ka̱ nchen ka̱ anung awang aNilu. Uza̱ ya nya mbanda̱r ka̱ ashe isəksək te, á re uzəngtəng ka̱ ashe ovan ochar va̱ ta à ga yar. ");
INSERT INTO yer_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Uya aFirona uva̱ ta bol te, a ya uyenba̱k ka̱ nyə́ng ka̱ ashishe. Te à rwa ìgwak à na uza̱ là pa̱, <<Uyen uva̱ ta̱ amar oHiburu.>> ");
INSERT INTO yer_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Te ugənangg ayenba̱k uva̱ ta ɓəp uya aFirona pa̱, <<N ga n ram uchar uga nna mbyal uyen ka̱ ashe oHiburu na á ɓa á nak ishi a ɓu ka̱ uyen uva̱ ta ɗak ɓo?>> ");
INSERT INTO yer_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Uya aFirona ma̱n á na pa̱, <<À, ga.>> Te uza̱ ga wór unang ayen ava̱ ta ɓa. ");
INSERT INTO yer_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Uya aFirona là uchar uva̱ ta pa̱, <<Yar uyenba̱k uva̱ ta̱ ga ká̱, nak ishi ka̱ na á mi, te mi mwa ɓu kà̱.>> Unang ayen yar uyen uva̱ ta ga ká̱, nak ishi ka̱ na. ");
INSERT INTO yer_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Uza̱ nyáng te, unənang ga ka̱ na ûya aFirona uyenchar, uza̱ sat uyiyen ununggwan. Uya aFirona sok aɗin á na pa̱ uMusa, <<Ka̱kul n yar na ka̱ ashe ndəng.>> ");
INSERT INTO yer_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Kà̱ nra nva̱ uMusa nyáng unəm te, uza̱ fa ga atak onəm wò. Uza̱ ga ya apir mɓək anung va̱ mí nəm ôza̱. Uza̱ ya unəm oga aMasar ka̱ nnə́m unəm wò uHiburu. ");
INSERT INTO yer_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Te uza̱ dər atak, uza̱ ya unəm uro ka̱t te, uza̱ gba̱l unəm oga aMasar va̱ ta, dəp na ka̱ ashe ashishiri. ");
INSERT INTO yer_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","UMusa fa chit kà̱ɗi ka̱ ìpin ikpa̱kkpa̱k te, uza̱ ya oHiburu pa̱ oparəm ka̱ nlung ìkum. Uza̱ là ûvəngva̱ ka̱ mpat pa̱, <<Sang kang ɓu nə́m ugənang ɓu yà?>> ");
INSERT INTO yer_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Te uza̱ là pa̱, <<Uda nak ɓu uponzhi ká̱ unəm uga nnap-akwali á yi yà? U ɗom pa̱ u gba̱l mi wa nva u gba̱l unəm oga aMasar ɗò?>> Ta byet te ayər nəm uMusa pa̱, <<Ya mmá nyi nnap va̱ chit.>> ");
INSERT INTO yer_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kà̱ nva̱ng nva̱ uFirona fe nnap va̱ ta te, uza̱ mo asa̱l aga ngba̱l uMusa. Te uMusa chər uFirona á ga təm ka̱ mbin aMidiyan ka̱ anung ndəng mɓokɓok. ");
INSERT INTO yer_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Unəm uga mpyal awop oga aMidiyan uwa yà ka̱ ovan ochar pa̱ ofangshat. Oza̱ ɓa nɗyang ndəng na ó yə́ng oga agulong oza̱, ka̱kul nna iya̱m nkang apo oza̱. ");
INSERT INTO yer_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Te onəm oga nkpak iya̱m nkang oro ɓa ɓàk ovan ochar va̱ ta. Te uMusa wong fa ka̱ oza̱ ka̱ awo onəm va̱ ta, ɗyang ndəng na iya̱m nkang oza̱. ");
INSERT INTO yer_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Te oza̱ le atak apo oza̱ uReyuwel (uwa uYeturo), kang upo oza̱ ɓəp oza̱ pa̱, <<Sang kang o le pa̱ kəlak nda va̱ ta̱ yà?>> ");
INSERT INTO yer_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Oza̱ là ûpo oza̱ pa̱, <<Unəm oga aMasar à fa ka̱ yi ka̱ awo onəm oga nkpak iya̱m nkang. Kang uza̱ ɗyang ndəng kpá na iya̱m nkang yi.>> ");
INSERT INTO yer_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Upo oza̱ ɓəp oza̱ pa̱, <<Unəm va̱ ta ka̱ che yà? Sang kang o re na ka̱ ta yà? O ga o wór na á ɓa, na uza̱ á ri iya̱m-nrì nzəng ká̱ yi.>> ");
INSERT INTO yer_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","UMusa ma̱n təm nzəng ka̱ oza̱. Unəm va̱ ta na uyen wò uZipora á na təm uchəchar. ");
INSERT INTO yer_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","UZipora mar uyennunggwan te, uMusa sok aɗin á na pa̱ uGershom, a nyám pa̱, <<Mmami uɗyanəm kà̱ mbin nkak.>> ");
INSERT INTO yer_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Kà̱ nva̱ng izun pa̱ kyák te, uponzhi oga aMasar kú. Te onəm oIsa̱rila shìn ka̱ mɓək anung inok, oza̱ yə́ng ka̱ nkam i ram nka̱mshi, ayə́ng oza̱ aga nram nka̱mshi ka̱ ashe idumdùm á ga chu atak Inan. ");
INSERT INTO yer_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Inan fe ashìn oza̱. Te Inan rəng nsar nnap-nlà wò va̱ ò yar ká̱ uAbəraham, ká̱ uIshaku, ká̱ uYakup á. ");
INSERT INTO yer_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Te Inan ya ovan oga óIsa̱rila, Inan nyi mɓək anung oza̱ kang à dər oza̱ ká̱ aɗor. ");
INSERT INTO yer_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ká̱ nda nro te, uMusa uwa kà̱ nkpak iya̱m nkang ágwar wò uYeturo unəm uga mpyal awop oga aMidiyan. Uza̱ ga ká̱ iya̱m nkang ka̱ asa̱l awu ntar alum ka̱ ashe nzam te, uza̱ ɓa chu aHorep va mí i wór pa̱ aɓam Inan. ");
INSERT INTO yer_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Te uMa̱leka aYawe fa á na wa aməlam apər ka̱ ishimshe ikun iyenyen. Uza̱ dər te, uza̱ ya apər kà̱ nsal ka̱ ashe ikun iyenyen va̱ ta, ká̱ nna kpa te, a ri iya̱m iro ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","UMusa là pa̱, <<Nva̱ ta̱ nnap mpipye, mi səng mi ga dát na ń dər, sang kang apər ka̱ nri kang ikun pwák ka̱t yà?>> ");
INSERT INTO yer_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Nva̱ngva̱ uYawe ya uMusa kà̱ mɓa ndát pa̱ ô dər te, Inan wór na ka̱ ashe ikun va̱ ta pa̱, <<ÁMusa, áMusa.>> UMusa ma̱n pa̱, <<Mmami nà ta̱.>> ");
INSERT INTO yer_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Uza̱ là pa̱, <<Kang wa ɓa dát ka̱t, zəp akwap aga ashar ɓu ka̱kul atak va̱ u sat ka̱ ta te, Atak Ayə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Mmami na Inan okəka ɓu, Inan aAbəraham, Inan aIshaku, ká̱ Inan aYakup.>> Ayər nəm uMusa te, á ká asa̱l awu wò na kang ô dər Inan ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Te uYawe là pa̱, <<Nnandər, n ya idumdùm onəm mi va̱ ya kà̱ mbin aMasar. N fe ayə́ng oza̱ chit ka̱kul onəm oga nkpak ozwal. N nyi mɓək anung oza̱ nyi. ");
INSERT INTO yer_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","N vàng chit pa̱ ń fa ká̱ oza̱ ka̱ ashe awo oga aMasar, kà̱ mbin va̱ ta na ń ga ká̱ oza̱ ka̱ ashe mbin nnəna̱n mbalbal nva mbyal ka̱ mmàl irizhe i nang kà̱. Atak oKanana, ká̱ oHiti, ká̱ oAmori, ká̱ oPerizi ká̱ oHivi, ká̱ oYebusi. ");
INSERT INTO yer_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Dər, ayə́ng aga mɓək anung onəm oga aIsa̱rila ɓa chu atak mi chit. N ya apir mɓək anung va̱ chit oga aMasar kà̱ nnəm ôza̱. ");
INSERT INTO yer_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ka̱kul nva̱ ta te, ga, Mmami ka̱ nre ɓu ka̱ atak aFirona na u fa ká̱ onəm mi oIsa̱rila ka̱ aMasar.>> ");
INSERT INTO yer_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Te uMusa là Inan pa̱, <<Mmami uda kang mi ga mpyal aFirona pa̱ n fa ka̱ onəm oga aIsa̱rila ka̱ aMasar yà?>> ");
INSERT INTO yer_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Uza̱ là pa̱, <<Nna mi yà nzəng ka̱ ɓu. Iya̱m va ta̱ i nyám pa̱ mmami na n re ɓu. Nva̱ngva̱ u fa ka̱ oza̱ ka̱ ashe aMasar te, ó wop Inan ka̱ apal aɓam va ta̱.>> ");
INSERT INTO yer_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Te uMusa là Inan pa̱, <<A yà pa̱ n ga ka̱ atak onəm oga aIsa̱rila n là ôza̱ pa̱, <Inan okəka wo à re mi ka̱ atak wo,> kang oza̱ á ɓəp mi pa̱, <Aɗiɗin pa̱ uda yà?> Te mi là oza̱ sang yà?>> ");
INSERT INTO yer_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Te Inan là uMusa pa̱, <<Mmami na Mmami.>> Iya̱m va ta̱ ɓu là ônəm oga aIsa̱rila, <<Mmami>> Mmami na n re ɓu ka̱ atak wo. ");
INSERT INTO yer_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Inan là uMusa kpa pa̱, <<Iya̱m va ta̱ ɓu là ônəm oga aIsa̱rila, <UYawe, Inan okəka wo, Inan aAbəraham, ká̱ Inan aIshaku, ká̱ Inan uYakup à re mi ka̱ atak wo.> Aɗin mi nata̱, ghar mbyet. Nnà mí rəng ká̱ kà̱ nza̱ nlwàk nggo. ");
INSERT INTO yer_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","<<Ga, ɓut onəmgbak oga aIsa̱rila là ôza̱ pa̱, <UYawe, Inan okəka wo, Inan aAbəraham, ká̱ aIshaku, ká̱ uYakup, fa nyám ishi wò á mi kang uza̱ là pa̱, <<N nak ishi ká̱ wo kang n ya iya̱m va̱ chit mmá nəm a wo ka̱ aMasar. ");
INSERT INTO yer_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","N là pa̱ mi fa ká̱ wo ka̱ ashe idumdùm oga aMasar. Mi ga ka̱ kà̱ mbin oKanana, ká̱ oHiti, ká̱ oAmori, ká̱ oPerizi ká̱ oHivi, ká̱ oYebusi, mbin va mbyal ka̱ mmàl irizhe i nang kà̱.>> > ");
INSERT INTO yer_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","<<Te oza̱ í gwong achwang ka̱ iya̱m va̱ mi là. Ɓu ga nzəng ka̱ onəmgbak oga aIsa̱rila ka̱ atak aponzhi oga aMasar, na o là á na pa̱, <UYawe, Inan oHiburu, á nyám ishi wò á yi chit. Ka̱kul nva̱ ta te, kusukkusuk, re yi na í ga achen aga nra pa̱ nshatɗing ka̱ ashe ǹzam na í na nləfər iya̱m ipápà ûYawe, Inan yi.> ");
INSERT INTO yer_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ká̱ nnà te, n nyinyi pa̱ uponzhi oga aMasar i re wo o ga ka̱t, ya mí nak awo ka̱ na kang. ");
INSERT INTO yer_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Te mi yichi awo, mi lə̀p aMasar ká̱ nkpaktak iya̱m iga nɗaktak va̱ mi nəm ka̱ ashishe. Nna chit te, uza̱ i re wo o ga ɗak. ");
INSERT INTO yer_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","<<Mi nak nchə̀r oIsa̱rila í bà̱l kà̱ mpyal oga aMasar, na o wong nfa te, o fa ká̱ awo alakchi ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Nza̱ uchar nggo i ɓəp oga iya̱m ìsham iga aazurfa ka̱ azənariya ká̱ ílukwan ka̱ atak ochar oga aMasar oga mbəp nzhi oza̱ ka̱ oga ashe ǹzhi oza̱, oga iya̱m ìsham va ta na o mwak ôvan wo onunggwan ka̱ ochar. Wa nnà ta o vyat iya̱m oza̱ ká̱.>> ");
INSERT INTO yer_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Te uMusa ma̱n uYawe pa̱, <<A yà pa̱ oIsa̱rila à na nnandər ká̱ mi ka̱t, á nak ishi ká̱ iya̱m va̱ mi là ka̱t, kang oza̱ a là pa̱, <UYawe nyám ishi wò a ɓu ka̱t> ɗò?>> ");
INSERT INTO yer_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Te uYawe ɓəp na pa̱, <<Iza̱ ta ka̱ awo ɓu yà?>> UMusa là pa̱, <<Idari.>> ");
INSERT INTO yer_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","UYawe là á na pa̱, <<Mandar kà̱ mbin.>> UMusa mandar idari kà̱ mbin te á wal ìzwa, te uza̱ myat fər ka̱ cho. ");
INSERT INTO yer_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","5","UYawe là ûMusa pa̱, <<Yichi awo ɓu kpán ká̱ ka̱ aswal, ka̱kul pa̱ na oza̱ á na nnandər pa̱ uYawe, Inan okəká oza̱, Inan aAbəraham, Inan aIshaku, ká̱ Inan àYakup à nyám ishi wò a ɓu.>> Te uza̱ yichi awo wò kpán ká̱ te á wal idari ka̱ awuwo. ");
INSERT INTO yer_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","UYawe là ûMusa kà̱ɗi pa̱, <<Pá awo ka̱ ashe abasəm ɓu.>> Te uza̱ pá awo ka̱ ashe abasəm wò kang à tur fa te, awo yà ká̱ nlak, fə̀r wa aɗəɗal. ");
INSERT INTO yer_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Te uYawe là pa̱, <<Le ká̱ awo ka̱ ashe abasəm ɓu kà̱ɗi.>> Te uMusa le ká̱ awo wò kang uza̱ fa ka̱ te, awo le yà wa aɓo izəzər. ");
INSERT INTO yer_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Te uYawe là pa̱, <<Kang a yà pa̱ oza̱ á na nnandər ká̱ ɓu ka̱t, kang oza̱ nak ishi ká̱ iya̱m iga nɗaktak iga nggəshi ka̱t te, oza̱ í na nnandər ká̱ iga ipəpar. ");
INSERT INTO yer_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","A yà pa̱ oza̱ na nnandər ká̱ iya̱m iga nɗaktak iga iparəm va̱ ta̱ ka̱t kang oza̱ nak ishi ká̱ ichu ɓu ka̱t te, pá ndəng ka̱ ashe awang aNilu, tar kà̱ mbin, te ndəng va̱ ta i wal nchə̀r.>> ");
INSERT INTO yer_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ká̱ nnà te, uMusa là ûYawe pa̱, <<ÁPonzhinan, mmami ka̱ n yà unəm uga iɓa̱ksok, n nyi nnap-nlà ka̱t, kap ká̱ nva̱ ka̱ u yà kà̱ nlà nnap ká̱ mi, ghar ǹyangmata̱.>> ");
INSERT INTO yer_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Te uYawe ɓəp na pa̱, <<Uda nəm anung anəm, ka̱t te uda nəm na i là nnap ka̱t, ka̱t te i fe achwang ka̱t, ka̱t te i ya atak ka̱t, ka̱t te a fufo yà? Mmami na uYawe ka̱t ɗò? ");
INSERT INTO yer_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Gá ǹyangmata̱. Mi yà nzəng ká̱ anung ɓu, mi ɗyang a ɓu iya̱m va̱ ɓu là.>> ");
INSERT INTO yer_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Te uMusa là pa̱, <<Kusukkusuk, áPonzhinan, re unəm ukak á ga.>> ");
INSERT INTO yer_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Te ìgwak shì uYawe kà̱ uMusa, uza̱ là pa̱, <<Ugənang ɓu uHaruna unəm oLawi sang yà? N nyi pa̱ uza̱ nyi nnap-nlà nyi kang uwa cho kà̱ mɓa nggwang ɓu ka̱ asa̱l. Uza̱ i ya ɓu te ìgwak i chàng na. ");
INSERT INTO yer_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Te ɓu là nnap á na, kang ɓu nak nnap-nlà ka̱ anunung. Mi yà nzəng ká̱ anung ɓu ká̱ anunung kang mi ɗyang á wó iya̱m va̱ ó nəm. ");
INSERT INTO yer_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Uza̱ i là nnap a ɓu ká̱ onəm, kang uza̱ i yà anung ɓu, te ɓu yà wa Inan ka̱tətak. ");
INSERT INTO yer_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Yar idari ata̱ ka̱ awo ɓu, ká̱ í yà ɓu nəm iya̱m iga nɗaktak.>> ");
INSERT INTO yer_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Te uMusa le ga atak agwar wò uYeturo, á là á na pa̱, <<Kusukkusuk, re mi n le atak onal mi va̱ ka̱ aMasar ka̱kul na n dər mo te oma yà ká̱ irirì nggo.>> Te uYeter là ûMusa pa̱, <<Ga ka̱ nnap nnəna̱n.>> ");
INSERT INTO yer_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Te uYawe là ûMusa ka̱ aMidiyan pa̱, <<Le ga aMasar ka̱kul nkpaktak onəm va̱ ka̱ yà kà̱ mmwo irirì ɓu te, oza̱ kú chit.>> ");
INSERT INTO yer_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Te uMusa yar uchar wò ka̱ ovan wò onunggwan nak oza̱ ka̱ apal azhaki, te á kpán asa̱l mbin aMasar. UMusa kpán idari aYawe va̱ ka̱ awo wò. ");
INSERT INTO yer_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Te uYawe là ûMusa kà̱ɗi pa̱, <<Nva̱ngva̱ u le aMasar te, nkpaktak iya̱m iga nɗaktak va̱ n na ichumchumchumchum ka̱ awo ɓu, te ɓu nəm oza̱ kà̱ mpyal aFirona. Ká̱ nnà te, mi nak igugwak i twat, uza̱ i yà ka̱ nre onəm i ga ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Te ɓu là ûFirona pa̱, <Iya̱m va ta̱ uYawe là, uIsa̱rila uwa uyen mi ununggwan uga nggəshi. ");
INSERT INTO yer_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ka̱ n là a ɓu pa̱, <<Re uyen mi ununggwan á ga ka̱kul na uza̱ a wop mi,>> te u yang ka̱ nre na pa̱ á ga. Ka̱kul nva̱ ta te, mi ga ngba̱l uyennunggwan ɓu uga nggəshi.> >> ");
INSERT INTO yer_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ka̱ apal asa̱l ka̱ atak njul te, uYawe gwang ka̱ na te, á mwo pa̱ o gba̱l na. ");
INSERT INTO yer_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Te uZipora yar ikpàl iriri uza̱ pà ache uyen wò ká̱, kang à dok ashishar ká̱. Te là á na pa̱, <<Mmaɓu uɓar mi uga nchə̀r.>> ");
INSERT INTO yer_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Te uYawe re na. (Nva̱ uza̱ là pa̱, <<Mmaɓu uɓar uga nchə̀r,>> te uza̱ kà̱ nlà nnap mpà ache va ta.) ");
INSERT INTO yer_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Te uYawe là ûHaruna pa̱, <<Ga gwang uMusa ka̱ ashe ǹzam.>> Te uza̱ ga gwang na ka̱ aɓam Inan, uza̱ má njàng á na. ");
INSERT INTO yer_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Te uMusa là ûHaruna nkpaktak iya̱m va̱ uYawe re na ká̱, ká̱ nkpaktak iya̱m iga nɗaktak va̱ uza̱ nak na pa̱ á nəm. ");
INSERT INTO yer_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Te uMusa ká̱ uHaruna ga ɓut nkpaktak onəmgbak oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","UHaruna là nkpaktak iya̱m va̱ uYawe là ûMusa, te uMusa nəm oga iya̱m iga nɗaktak va̱ kà̱ mpyal onəm. ");
INSERT INTO yer_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Onəm na nnandər ká̱. Nva̱ngva̱ oza̱ fe pa̱ uYawe nak ishi ká̱ kang à ya mɓək anung oIsa̱rila chit te, oza̱ kúchi nəm awop. ");
INSERT INTO yer_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","UMusa ká̱ uHaruna tar atak áFirona kang à là á na pa̱, <<Iya̱m va ta̱ uYawe, Inan oIsa̱rila là, <Re onəm mi á ga ka̱kul na oza̱ á nəm awop aga nrí ká̱ ngwa á mi ka̱ ashe anyin.> >> ");
INSERT INTO yer_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","UFirona na ama̱n pa̱, <<Uda uYawe va̱ kang mi fe ichəchu mi re uIsa̱rila i ga yà? N nyi uYawe ka̱t, kang mi re uIsa̱rila i ga ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Te oza̱ là pa̱, <<Inan oHiburu à gwang ká̱ yi. Kusukkusuk, re yi í nəm achen aga nra pa̱ nshatɗing ka̱ ashe anyin ka̱kul na i na nləfər iya̱m ipápà ûYawe, Inan yi, le kang uza̱ a lə̀p yi ká̱ arwa aɓá̱ngɓa̱ng ka̱t te ká̱ ndokchi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Te uponzhi uga aMasar là pa̱, <<ÁMusa ká̱ uHaruna, sang kang o yar nnap nnəm onəm ka̱ atak inok oza̱ yà? Ó le atak inok wo.>> ");
INSERT INTO yer_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","UFirona là kpa pa̱, <<Dər, onəm oga mbin va̱ ta̱ yəl byet, kang ó dáng oza̱ kà̱ nnəm inok oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ká̱ nda va ta uFirona nak onəm oga nkpak ozwal nzəng ká̱ ogá nak ishi ká̱ inok pa̱, ");
INSERT INTO yer_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","<<Kang o ga mpyal ka̱ nna ìɗùktum iro ónəm va̱ ta ka̱kul nnəm abərki wa nva̱ kà̱ nra va̱ watar lap ka̱t, re oza̱ á ga á mwo ka̱kul ishi oza̱. ");
INSERT INTO yer_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ká̱ nna te, nak oza̱ á nəm abərki wa kà̱ nra va̱ watar, kang á yen ka̱t. Ka̱kul oza̱ onəm pwompwom, nna nak kang oza̱ kà̱ ǹyə́ng ayə́ng pa̱, <Re yi í ga i na nləfər iya̱m ipápà Inan yi.> ");
INSERT INTO yer_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Kà̱r oza̱ ká̱ inok imakmak, ka̱kul na á dáng oza̱ kà̱ nggwong achwang kà̱ oga akwàm va̱ ta.>> ");
INSERT INTO yer_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Te onəm oga nkpak ozwal ká̱ oga nnak ishi ká̱ inok ga là ônəm pa̱, <<Iya̱m va ta̱ uFirona là, <Mí na ìɗùktum a wo ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","O ga o mwo ìɗùktum ka̱ ishiwo ka̱ atak va̱ o ya kà̱ á, ká̱ nna te, mí yà ká̱ nkəla̱p inok a wo ka̱t.> >> ");
INSERT INTO yer_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Te onəm lyangshin ka̱ ashe nkpaktak mbin aMasar i cák ìɗùktùm. ");
INSERT INTO yer_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Onəm oga nkpak ozwal sat atak ôza̱, í là pa̱, <<O nəm inok wo iga nza̱ nra nggo wa nva mmá ka̱ yà kà̱ nna ìɗùktum a wo á.>> ");
INSERT INTO yer_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Te onəm oga nkpak ozwal aFirona nə́m oIsa̱rila oga nak ishi ká̱ inok va̱ oza̱ kyep ka̱ apal oza̱, ɓəp pa̱, <<Sang kang o yə́l mmák abərki wa nva̱ ka̱ yà ó nəm ká̱ nlam ká̱ nda va̱ ta̱ ka̱t yà?>> ");
INSERT INTO yer_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Te oIsa̱rila oga nak ishi ká̱ inok ga atak áFirona yə́ng á na pa̱, <<Sang kang ɓu nəm ózwal ɓu wa nta̱ yà? ");
INSERT INTO yer_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Mmá kà̱ nna ìɗùktum ózwal ɓu ka̱t, ká̱ nna te, oza̱ là á yi pa̱, <Ó nəm abərki.> Dər, mmá kà̱ nnə́m ózwal ɓu ka̱kul mpat onəm ɓu na.>> ");
INSERT INTO yer_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Te uza̱ là pa̱, <<Ó pwom paɗi. Nna nak kang o là pa̱, <Re yi í ga í na nləfər iya̱m ipápà ûYawe.> ");
INSERT INTO yer_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ǹyangmata̱, o le, o ga atak inok, mí na ìɗùktum a wo ka̱t, ká̱ nnà te, o nəm mmák abərki wa mmatmat.>> ");
INSERT INTO yer_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","OIsa̱rila oga nak ishi ká̱ inok nyi pa̱ mmawó ka̱ ashe nɗaktak, nva̱ mmá là óza̱ pa̱, <<Ó yà ká̱ nnəm mmák abərki va̱ ta i yen aga nza̱ nra nggo ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Nva̱ngva̱ oza̱ fa ka̱ atak áFirona te, oza̱ gwang uMusa ká̱ uHaruna tong kà̱ nlok oza̱. ");
INSERT INTO yer_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Oza̱ là ûMusa ká̱ ûHaruna pa̱, <<Re uYawe á dər wo á nap akwali a wo, nva̱ o nak í tong onəm oɓá̱ngɓa̱ng kà̱ mpyal àFirona ká̱ ozuzwal. O nak ndokchi ka̱ awo oza̱ pa̱ á gbá̱ng yi.>> ");
INSERT INTO yer_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Te uMusa le ga atak áYawe là pa̱, <<Sang kang u na mɓək anung ónəm va̱ ta̱ wa nva̱ ta̱ yà, áPonzhinan? Sang kang u re mi yà? ");
INSERT INTO yer_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Á ɓàn matmat nva̱ n ga atak áFirona pa̱ n là nnap ká̱ aɗin ɓu te, uza̱ nəm mɓək anung ónəm va̱ ta̱, kap ká̱ nnà te, nna u fa ká̱ onəm ɓu chit ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Te uYawe na ama̱n ûMusa pa̱, <<Ǹyangmata̱ te, ɓu ga ǹya iya̱m va̱ mi nəm uFirona. Uza̱ i re oza̱ i ga ka̱kul ìkam awo mi, ka̱kul ìkam awo mi uza̱ i wà oza̱ i fa ka̱ ashe mbin wò.>> ");
INSERT INTO yer_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Te Inan là ûMusa pa̱, <<Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","N nyám ishi mi uAbəraham, ká̱ uIshaku, ká̱ uYakup, wa Inan ìChumchum, kang m bol ôza̱ pa̱ aɗin mi pa̱ uYawe ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","N yar nsar nnap-nlà ká̱ oza̱ pa̱, mi na mbin ngga aKanana ôza̱, mbin nva oza̱ kà̱ ntəm ka̱ ashishe wa onəmchən. ");
INSERT INTO yer_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Kà̱ɗi te, n fe ashìn onəm oIsa̱rila chit, nva̱ oga aMasar í nak nkpak oza̱ í nəm inok wa ozwal, kang n rəng ká̱ nsar nnap nla mi chit. ");
INSERT INTO yer_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","<<Ka̱kul nva̱ ta te, là ôIsa̱rila pa̱, <Mmami na uYawe, mi fa ká̱ wo ka̱ atak inok iga nkpak oga aMasar, mi fən wo ka̱ atak nnəm izwal óza̱, mi ka̱mshi wo ká̱ awo mi akamkam, ká̱ akwali achumchum. ");
INSERT INTO yer_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mi ka̱m wó o yà onəm mi, kang mi yà Inan wo. Te o nyi pa̱ Mmami na uYawe, Inan wó, uva fa ká̱ wó ka̱ atak inok iga nkpak oga aMasar. ");
INSERT INTO yer_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Te mi ɓa ká̱ wó ka̱ ashe mbin va n sóng anung pa̱ mi na ûAbəraham, ká̱ ûIshaku, ká̱ ûYakup, te mi na á wó i yà njiwó. Mmami na uYawe.> >> ");
INSERT INTO yer_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Te uMusa là iya̱m va̱ ta̱ ôIsa̱rila, te oza̱ gwong achwang kà̱ na ka̱t. Á rusok izər óza̱ ka̱kul oza̱ ka̱ ashe inok iɗəkɗək. ");
INSERT INTO yer_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Te uYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","<<Ga là uFirona uponzhi oga aMasar á re oIsa̱rila á fa ka̱ ashe mbibin.>> ");
INSERT INTO yer_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Te uMusa là kà̱ mpyal àYawe pa̱, <<A yà pa̱ oIsa̱rila i gwong achwang kà̱ mi ka̱t te, i yar sang kang uFirona i gwong achwang kà̱ mi yà? Nnà mmami unəm uga aɓələm aɗəkɗək á?>> ");
INSERT INTO yer_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Te uYawe là nnap-nlà ûMusa ká̱ ûHaruna pa̱, <<O ga o là ûIsa̱rila ká̱ ûFirona uponzhi oga aMasar, pa̱ n nak wo chit pa̱ o fa ká̱ oIsa̱rila ka̱ ashe mbin aMasar.>> ");
INSERT INTO yer_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Onəm oga mpyal akum ìjili okəká oza̱ omata̱. Ovan aRuben uya aIsa̱rila uga nggəshi, oma uHanok ká̱ uFalu, ká̱ uHezuron ká̱ uKarmi, omata akum aRuben. ");
INSERT INTO yer_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ovan aSimeyon, oma uYemuyel, ká̱ uYamin, ká̱ uOhat, ká̱ uYakan, ká̱ uZohar, ká̱ uShawul uwa unənang uyen oga aKanana, omata akum aSimeyon. ");
INSERT INTO yer_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Aɗin ovan aLawi omata̱ ká̱ akum oza̱, oma uGershon, ká̱ uKohat, ká̱ uMerari. ULawi nəm ìzun ìgba̱l pa̱ ìzəng ká̱ ìsəm pa̱ ishatɗing ama̱n pa̱ fangshat. ");
INSERT INTO yer_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ovan aGershon oma, uLibəni ká̱ uShimayi, ka̱ atak akum oza̱. ");
INSERT INTO yer_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ovan aKohat oma, uAməram, uIzhar, uHebəron, ká̱ uUza̱yel. UKohat nəm ìzun ìgba̱l pa̱ ìzəng ká̱ ìsəm pa̱ ishatɗing ama̱n pa̱ shatɗing. ");
INSERT INTO yer_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ovan aMerari oma, uMakli ka̱ uMushi. Akum oLawi nata, mmá dàt oza̱ ka̱ akum ka̱ akum. ");
INSERT INTO yer_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","UAməram ka̱m uYokabyet ugənang apupon, kang uza̱ mar uHaruna ká̱ uMusa á na. UAməram nəm ìzun ìgba̱l pa̱ ìzəng ká̱ ìsəm pa̱ ishatɗing ama̱n pa̱ fangshat. ");
INSERT INTO yer_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ovan aIzhar oma, uKora, ká̱ uNefek, ká̱ uZikri. ");
INSERT INTO yer_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ovan aUza̱yel oma, uMishayel, ká̱ uEləzafan, ká̱ uSitəri. ");
INSERT INTO yer_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Te uHaruna ka̱m uElisheba uya aAminadap ugənang aNashon, á mar uNadap, ká̱ uAbihu, ká̱ uEliyaza, ká̱ uItama á na. ");
INSERT INTO yer_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ovan áKora oma, uAshir, ká̱ uElkana, ká̱ uAbiyasap, omata akum oKora. ");
INSERT INTO yer_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Te uEleazar uya áHaruna ka̱m uzəngtəng ka̱ ashe ovan aFutiyel. Uza̱ mar uFinehas á na. Oma onəm oga mpyal onəm aLawi ka̱ atak akum oza̱. ");
INSERT INTO yer_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","UHaruna ká̱ uMusa, oma uYawe là ôza̱ pa̱, <<Ó fa ká̱ oIsa̱rila ka̱ ashe mbin aMasar ìdonkong ìdonkong.>> ");
INSERT INTO yer_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","UMusa ká̱ uHaruna, oma là nnap ûFirona uponzhi oga aMasar pa̱, uza̱ á re onəm oIsa̱rila á fa ka̱ ashe mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ka̱ nda va̱ uYawe kà̱ là nnap ká̱ uMusa ka̱ ashe mbin aMasar te, ");
INSERT INTO yer_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","uza̱ là á na pa̱, <<Mmami na uYawe. Là úFirona uponzhi oga aMasar nkpaktak iya̱m va̱ mmami kà̱ nləla a ɓu.>> ");
INSERT INTO yer_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Te uMusa na ama̱n kà̱ mpyal aYawe pa̱, <<Mmami unəm uga aɓələm aɗəkɗək, n nyi nnap-nlà ka̱t, te i yar sang kang uFirona i gwong achwang kà̱ mi yà?>> ");
INSERT INTO yer_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Te uYawe là ûMusa pa̱, <<Nak nnap nnəm ɓu pa̱ dakdak kà̱ nnap va̱ ta̱. N nak ɓu chit wa Inan kà̱ mpyal aFirona, kang uHaruna ugənang ɓu i yà unəm uga nlà ìchu ɓu. ");
INSERT INTO yer_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ɓu là nkpaktak iya̱m va̱ n là a ɓu ûHaruna ugənang ɓu, kang uza̱ i là ûFirona pa̱ á re oIsa̱rila á fa ka̱ ashe mbin wò. ");
INSERT INTO yer_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Te mi nak ìgwak aFirona i twat ka̱kul na ń nak oga iya̱m iga nɗaktak mi ká̱ iga nnəm ayər á yà pa̱ kyak ka̱ ashe mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Te uFirona i gwong achwang kà̱ wo ka̱t, te mi nak awo mi ka̱ apal aMasar kang mi fa ká̱ nggatək onəm mi oIsa̱rila ka̱ ashe mbin aMasar ká̱ akwali achumchum. ");
INSERT INTO yer_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Te oga aMasar i nyi pa̱ mmami uYawe, nva̱ngva̱ n yichi awo mi ka̱ apal aMasar kang n fa ká̱ oIsa̱rila ka̱ ashe oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Te uMusa ká̱ uHaruna nəm dakdak wa nva uYawe là ôza̱. ");
INSERT INTO yer_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","UMusa ka̱ yà uyen uga ìzun ìsəm na̱nne kang uHaruna uyen uga ìzun ìsəm na̱nne ama̱n pa̱ shatɗing ka̱ ashe nra va̱ oza̱ là nnap ká̱ uFirona. ");
INSERT INTO yer_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Te uYawe là ûMusa ká̱ ûHaruna pa̱, ");
INSERT INTO yer_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","<<Nva̱ngva̱ uFirona á là a wo pa̱, <Ó nəm iya̱m iga nnəm ayər á wò,> te là ûHaruna pa̱, <Yar idari ɓu mandar kà̱ mpyal áFirona.> Te i wal ìzwa.>> ");
INSERT INTO yer_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Te uMusa ká̱ uHaruna tar atak áFirona nəm dakdak wa nva uYawe nak. Te uHaruna mandar idari wò kà̱ mpyal aFirona ká̱ okparikpari, te á wal ìzwa. ");
INSERT INTO yer_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ká̱ nna te, uFirona wór onəm wò oga ntàn, ká̱ onəm omámmàm oga aMasar, oza̱ nəm ka̱ atak nnap inunggwan oza̱ kpa wa nva oza̱ nəm. ");
INSERT INTO yer_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Nza̱ uzəngtəng oza̱ nggo mandar idari wò, te á wal ìzwa, kang idari aHaruna wur ijo oza̱ ma̱ng. ");
INSERT INTO yer_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Káp ká̱ nna te, ìgwak aFirona ì yà tutwat, uza̱ yang ká̱ nggwong achwang kà̱ oza̱, wa nva uYawe ka̱ là. ");
INSERT INTO yer_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Te uYawe là ûMusa pa̱, <<Ìgwak aFirona tutwat, uza̱ yang ǹre onəm pa̱ á ga. ");
INSERT INTO yer_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ga atak aFirona ká̱ ìpin ya uza̱ kà̱ nfa ngga anung awang aNilu, sat ka̱ anung akonkong lok na. Yar idari va̱ kà̱ wal ìzwa ka̱ awo ɓu. ");
INSERT INTO yer_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Là á na pa̱, <UYawe, Inan oHiburu à re mi pa̱ ń là a ɓu pa̱, <<Re onəm mi á ga ka̱kul na oza̱ a wop mi ka̱ ashe anyin.>> Kang ghar ǹyangmata̱ u yang ká̱ nggwong achwang. ");
INSERT INTO yer_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Iya̱m va ta̱ uYawe là, <<Ka̱ apal nnata̱ ɓu nyi pa̱ mmami uYawe.>> Mi ngga mpan ndəng aNilu ká̱ idari va̱ ta̱ ka̱ awo mi, kang i wal nchə̀r. ");
INSERT INTO yer_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Te igwali iga awang aNilu i kú, aNilu i nəng, ndəng awang aNilu i ma̱t oga aMasar kà̱ ngwa.> >> ");
INSERT INTO yer_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Te uYawe là ûMusa pa̱, <<Là ûHaruna pa̱, <Yar idari ɓu na ú yichi awo ɓu ka̱ apal oga ndəng ngga aMasar, ka̱ apal oga awang oza̱, ka̱ apal oga ngwangsang, ka̱ apal oga apyáp, ka̱ apal oga nshənggət, ka̱kul na oza̱ á wal nchə̀r. Te nchə̀r i yà ka̱ ashe nkpaktak mbin aMasar, ká̱ ashe oga iya̱m iga nchwong ndəng iga akún ká̱ iga ipang.> >> ");
INSERT INTO yer_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","UMusa ká̱ uHaruna nəm dakdak wa nva uYawe nak. Uza̱ gha̱p idari pàn ndəng ngga awang aNilu ká̱ kà̱ iwu aFirona ká̱ okparikpari, kang nkpaktak ndəng ngga awang aNilu wal nchə̀r. ");
INSERT INTO yer_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Igwali va̱ ka̱ ashe awang aNilu kú, awang aNilu nnsəng, ndədəng ma̱t oga aMasar kà̱ ngwa. Kang nchə̀r gang ashe mbin aMasar pa̱ lat. ");
INSERT INTO yer_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ká̱ nna te, onəm omámmàm oga aMasar nəm ka̱ atak nnap inunggwan oza̱ kpa wa nva oza̱ nəm. Te ìgwak aFirona twat, kang uza̱ fe oza̱ ka̱t, wa nva uYawe ka̱ là. ");
INSERT INTO yer_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","UFirona ga̱ɓa̱n ga ashe ǹzhi wò, kang uza̱ nak ishi ká̱ nkpaktak oga iya̱m va̱ ta ka̱t na kpa. ");
INSERT INTO yer_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nkpaktak oga aMasar ɓok akonkong awang aNilu pa̱ na o ya ndəng o wá, ka̱kul ndəng ngga awang aNilu ma̱t oza̱ chit kà̱ ngwa. ");
INSERT INTO yer_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Á yə́l nra chit pa̱ nfangshat kà̱ nva̱ngva̱ uYawe pàn awang aNilu á. ");
INSERT INTO yer_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Te uYawe là ûMusa pa̱, <<Ga là ûFirona pa̱, <UYawe là pa̱, <<Re onəm mi á ga ka̱kul na oza̱ a wop mi. ");
INSERT INTO yer_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","A yà pa̱ ɓu yang ká̱ ǹre oza̱ te, mi ga nre ǹre ká̱ oga mpwakap kà̱ nkpaktak aswari mbin ɓu. ");
INSERT INTO yer_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Awang aNilu i yə́l ká̱ mpwakap, kang oza̱ i táng ashe nkəlang iponzhi ɓu ká̱ ashe ǹzhi nra ɓu, ká̱ apal alyer ɓu, ká̱ nzhi okpari ɓu, kang ka̱ apal onəm ɓu ká̱ oga igəng iga ngwang iya̱m ɓu, ká̱ oga asu aga nkál mmá̱k ɓu. ");
INSERT INTO yer_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Oga mpwakap i kyen a ɓu ka̱ izər, ká̱ onəm ɓu, ká̱ nkpaktak okpari ɓu.>> > >> ");
INSERT INTO yer_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Te uYawe là ûMusa pa̱, <<Là ûHaruna pa̱, <Yichi idari ɓu ka̱ apal oga awang, ká̱ ngwangsang, ká̱ oga apyáp na oga mpwakap á fa ka̱ apambin aMasar.> >> ");
INSERT INTO yer_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Te uHaruna yichi awo wò ka̱ apal oga ndəng ngga aMasar, kang oga mpwakap fa dàngchi mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Te onəm omámmàm nəm ka̱ atak nnap inunggwan oza̱ kpa, wa nva oza̱ nəm, oga mpwakap fa ka̱ apambin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Te uFirona wór uMusa ká̱ uHaruna, uza̱ là pa̱, <<Chal uYawe ka̱kul na uza̱ á wur oga mpwakap á le á mi ká̱ onəm mi, te mi re onəm i ga ka̱kul na oza̱ á na nləfər ûYawe.>> ");
INSERT INTO yer_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Te uMusa là ûFirona pa̱, <<Yak awalang va̱ u ɗom pa̱ n chal ka̱kul ɓu, ká̱ okpari ɓu, ká̱ onəm ɓu, pa̱ mmá yar oga mpwakap á le a ɓu ká̱ oga nzhi wó, na oza̱ á yà ka̱ ashe awang aNilu na chwat.>> ");
INSERT INTO yer_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Te uFirona là pa̱, <<Ìpin.>> Te uMusa là pa̱, <<I yà wa nva u là á, ka̱kul na u nyi pa̱, unəm uro yà wa áYawe, Inan yi ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Uza̱ i wur oga mpwakap i le a ɓu, ká̱ okpari ɓu, ká̱ onəm ɓu, i re oza̱ ka̱ ashe awang aNilu nà chwat.>> ");
INSERT INTO yer_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Te uMusa ká̱ uHaruna fa ka̱ atak aFirona, nna chit te, uMusa chal uYawe pa̱ á wur oga mpwakap va̱ uza̱ re ǹre ûFirona ká̱ á le. ");
INSERT INTO yer_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Te uYawe nəm wa nva uMusa ɓəp, kang oga mpwakap ka̱ ashe oga nzhi, ká̱ ashe agəla̱n, ká̱ ashe ǹzam kú. ");
INSERT INTO yer_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Oga aMasar ɓut mpwakap va̱ ta nchələ́ngnchələ́ng, kang à nnəng ashe mbin va̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Te nva̱ngva̱ uFirona ya pa̱ oga mpwakap yà lap ka̱t te, uza̱ twat ìgwak wò, uza̱ gwong achwang kà̱ oza̱ ka̱t, wa nva uYawe là. ");
INSERT INTO yer_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Te uYawe là ûMusa pa̱, <<Là ûHaruna pa̱, <Yichi idari ɓu na ú pàn mɓwang mbin ká̱ na á wal mməsham ka̱ ashe nkpaktak mbin aMasar.> >> ");
INSERT INTO yer_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Te oza̱ nəm wa nnà ta, kang nva̱ngva̱ uHaruna yichi awo wò pàn mbin ká̱ idari wò, te oga mməsham fa kyen unəmləbər ka̱ izər ká̱ iga iya̱m nkang. Nkpaktak mɓwang mbin ka̱ ashe aMasar ga̱ɓa̱n yà mməsham. ");
INSERT INTO yer_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Onəm omámmàm ɗak pa̱ ó fa ká̱ mməsham kpa ka̱ atak nnap inunggwan oza̱, te á ma̱t oza̱. Oga mməsham káp ka̱ izər ánəmləbər ká̱ iya̱m nkang. ");
INSERT INTO yer_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Onəm omámmàm là ûFirona pa̱, <<Ìfang Inan ta̱.>> Kang ìgwak aFirona ì ya à tutwat, te uza̱ gwong achwang kà̱ oza̱ ka̱t, wa nva uYawe kà̱ là. ");
INSERT INTO yer_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Te uYawe là ûMusa pa̱, <<Wong ká̱ iɓotak na ú sat kà̱ mpyal aFirona kà̱ nfə́r ngga awang, là á na pa̱, <Iya̱m va ta̱ uYawe là, <<Re onəm mi á ga ka̱kul na oza̱ a wop mi. ");
INSERT INTO yer_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kang a yà pa̱ ɓu re onəm mi i ga ka̱t, te nyi pa̱ mi ga nre ǹre ká̱ iga ichəngchəng pa̱ makmak ka̱ apal ɓu, ká̱ okpari ɓu, ká̱ onəm ɓu. Ashe nzhi oga aMasar yə́l ká̱ ichəngchəng kang ichəngchəng i dàngchi mbin oza̱ kpa. ");
INSERT INTO yer_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Kang kà̱ ilum va̱ ta te, mi va̱n mbin aGoshen atak va̱ onəm mi ka̱ ntəm kà̱. Mí ya ichəngchəng ka̱ ta juwo ka̱t, ka̱kul na ú nyi pa̱ mmami na uYawe, n na n yà ka̱ ashe mbin va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Mi nak aswari kà̱ ishimshe onəm mi ká̱ onəm ɓu. Iya̱m iga nɗaktak va̱ ta̱ i ga nfa ìpin.>> > >> ");
INSERT INTO yer_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Te uYawe nəm wa nnà ta, ichəngchəng fa pa̱ makmak yə́l ashe nzhi iponzhi áFirona ká̱ oga nzhi okparikpari. Te nkpaktak mbin aMasar vyap ka̱kul iga ichəngchəng. ");
INSERT INTO yer_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Te uFirona wór uMusa ká̱ uHaruna là ôza̱ pa̱, <<O ga o na nləfər Înan wo ka̱ ashe mbin va ta̱.>> ");
INSERT INTO yer_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Te uMusa là pa̱, <<Ì mmá pa ka̱t. Nləfər iya̱m ipápà va̱ í ga nnəna ûYawe, Inan yi te, i yà iya̱m iga nnəm ajan ka̱ atak oga aMasar. A yà pa̱ í na nləfər iya̱m ipápà iga nnəm ajan va̱ ta oza̱ kà̱ ǹyəya te, oza̱ i kwan yi ká̱ ipang í kú ka̱t ɗò? ");
INSERT INTO yer_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nkpak pa̱ í nəm achen aga nra pa̱ nshatɗing ka̱ ashe anyin, na í na nləfər iya̱m ipápà ûYawe, Inan yi, wa nva uza̱ i là á yi.>> ");
INSERT INTO yer_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Te uFirona là pa̱, <<Mi re wo o ga ashe anyin na o na nləfər iya̱m ipápà ûYawe, Inan wo. Ká̱ nna te, kang o ga á gbà̱ng ka̱t. O chal ka̱kul mi.>> ");
INSERT INTO yer_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Te uMusa là pa̱, <<Mi fa ka̱ atak ɓu i gbà̱ng nva̱ng ka̱t te, mi chal uYawe kang ìpin te, uza̱ í nak iga ichəngchəng imakmak va̱ ta̱ i lar i le ka̱ atak aFirona, ká̱ okparikpari, ká̱ nkpaktak onənəm. Ká̱ nna te, kang wa tàng yi kà̱ɗi wa yang ká̱ ǹre onəm pa̱ á ga á na nləfər iya̱m ipápà ûYawe ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Te uMusa fa kà̱ mpyal aFirona te, á chal uYawe, ");
INSERT INTO yer_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","te uYawe nəm wa nva uMusa là, kang à nak ichəngchəng va̱ ta lar ka̱ atak aFirona, ká̱ okparikpari, ká̱ onənəm, kang ichəngchəng iro pa̱ izəng re ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ká̱ nna te, uFirona twat ìgwak wò kà̱ɗi, á yang re onəm ga ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Te uYawe là ûMusa pa̱, <<Ga atak aFirona là á na pa̱, <Iya̱m va ta̱ uYawe, Inan oHiburu là, <<Re onəm mi á ga ka̱kul na oza̱ a wop mi.>> ");
INSERT INTO yer_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kang a yà pa̱ ɓu ga mpyal ká̱ nkpán oza̱, ɓu re oza̱ i ga ka̱t te, ");
INSERT INTO yer_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","uYawe i nak awo wò aga nɗaktak nɗəkɗək ka̱ apal iya̱m nkang wo va̱ ka̱ ashe ǹzam, ka̱ apal ipəri, azhaki, alakəmi, ína, oga inagàm ká̱ iɓəl. ");
INSERT INTO yer_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ká̱ nna te, uYawe i va̱n iya̱m nkang oIsa̱rila ka̱ ashe ijo oga aMasar, kang na iya̱m nkang oIsa̱rila iro pa̱ izəng á kú ka̱t.> >> ");
INSERT INTO yer_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Te uYawe nak awalang, á là pa̱, <<Ìpin te, uYawe i ga nnəm iya̱m ata̱ ka̱ ashe mbin.>> ");
INSERT INTO yer_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ìpin kpa̱k te, uYawe nəm iya̱m ata. Nkpaktak iya̱m nkang oga aMasar kú, nnyi te, iya̱m nkang oga oIsa̱rila iro kú pa̱ izəng ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Te uFirona re onəm ga sòng kang à ya pa̱, iya̱m nkang oga aIsa̱rila iro pa̱ izəng kú ka̱t. Káp ká̱ nna te, ìgwak àFirona twat, te uza̱ yang ká̱ ǹre onəm pa̱ á ga. ");
INSERT INTO yer_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Te uYawe là ûMusa ká̱ uHaruna pa̱, <<Ó kpa̱k ǹchwang ka̱ ashe achər ka̱ awo wà pa̱ súr na uMusa á swang á ga apal kà̱ ìwu aFirona. ");
INSERT INTO yer_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","I wal mɓwang nnəna̱n ka̱ apal nkpaktak mbin aMasar, kang nsòmò nlóklok i fa ka̱ apal onəm ká̱ iya̱m nkang ka̱ ashe nkpaktak mbin aMasar.>> ");
INSERT INTO yer_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Te oza̱ kpa̱k nchwang ngga ashe achər sat ká̱ kà̱ mpyal aFirona, te uMusa swang á ga apaɓur, kang nòmò nlóklok fa ónəm ka̱ izər ká̱ oga iya̱m nkang. ");
INSERT INTO yer_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Onəm omámmàm chu pa̱ o sat kà̱ mpyal aMusa ka̱t ka̱kul oga nsòmò. Oga nsòmò fa ónəm omámmàm ká̱ nkpaktak onəm oga aMasar. ");
INSERT INTO yer_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ká̱ nnà te, uYawe nak ìgwak aFirona twat kang uza̱ yang ka̱ nggwong achwang, wa nva uYawe ka̱là ûMusa. ");
INSERT INTO yer_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Te uYawe là ûMusa pa̱, <<Wong ká̱ iɓotak ga atak aFirona. Là á na pa̱, <Iya̱m va ta̱ uYawe, Inan oHiburu là, <<Re onəm mi á ga ka̱kul na oza̱ a wop mi. ");
INSERT INTO yer_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Pá ka̱t te, mi ga nre ǹre ka̱ nkpaktak nɗaktak mi ka̱ apal ishi ɓu, ká̱ okpari ɓu, ká̱ onəm ɓu. Nnà chit te, ɓu nyi pa̱ unəm uro yà wa njem lap ka̱ ashe nkpaktak apambin ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Wa ǹyangmata̱ te, ká̱ n yichi awo mi chit ká̱ ń ləp ɓu ká̱ onəm ɓu ká̱ nɗaktak, kang ká̱ n zhì wo chit ka̱ apambin. ");
INSERT INTO yer_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ká̱ nnà te, n re ɓu ka̱ irirì ka̱kul ìpir nnap va ta̱, pa̱ na ń nyám ichumchum mi a ɓu, na mmá shet aɗin mi ka̱ ashe nkpaktak apambin. ");
INSERT INTO yer_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ká̱ nnà te, mmaɓu kà̱ nnyám nggá̱r ka̱ apal onəm mi, u yang ka̱ ǹre oza̱ pa̱ á ga. ");
INSERT INTO yer_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ìpin ká̱ atak wa nta̱ te, mi pə̀ng aɗəɗal va nna ka̱ yà chit ka̱t kà̱ ǹra va̱ mmá pak aMasar ká̱ á, ya ǹyangmata̱. ");
INSERT INTO yer_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ka̱kul nva̱ ta te, nak mmá ɓa ká̱ iya̱m nkang ɓu ka̱ afo ká̱ nkpaktak iya̱m va mmaɓu ká̱ ka̱ ashe ǹzam. Nza̱ unəm nggo ká̱ iya̱m nkang va̱ ka̱ ashe ǹzam kang mmá ɓa ká̱ ka̱ ashe ka̱t te, i ga nkú a yà pa̱ aɗəɗal pə̀ng óza̱ á.>> > >> ");
INSERT INTO yer_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Onəm va̱ ka̱ ashe okpari áFirona va̱ nəm ayər nnap-nlà aYawe te, oza̱ nak ozwal oza̱ ká̱ iga iya̱m nkang chəng táng afo. ");
INSERT INTO yer_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Te onəm va̱ gwong achwang kà̱ nnap-nlà aYawe ka̱t te, á re ozwal oza̱ ká̱ iya̱m nkang oza̱ ka̱ ashe ǹzam. ");
INSERT INTO yer_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Te uYawe là ûMusa pa̱, <<Yichi awo ɓu á ga apaɓur na aɗəɗal á pə̀ng kà̱ nkpaktak mbin aMasar, ka̱ apal ánəmləbər ká̱ iya̱m nkang, ká̱ nkpaktak iya̱m nsuk ka̱ ashe íram oga aMasar.>> ");
INSERT INTO yer_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Te uMusa yichi idari wò á ga apaɓur, te uYawe re ǹre ká̱ ìgbarman ká̱ aɗəɗal. UYawe fə́r ká̱ aməlam kang à pə̀ng aɗəɗal kà̱ mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Aɗəɗal ká̱ aməlam fə́r, apipir nnà yà chit ka̱ ashe aMasar ka̱t matmat nva̱ uza̱ ka̱ yà mbin á. ");
INSERT INTO yer_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Aɗəɗal chwan iya̱m va̱ ka̱ ashe ǹzam kà̱ nkpaktak mbin aMasar, á ɓan kà̱ unəmləbər, ká̱ iya̱m nkang, ká̱ iya̱m nsuk, kang à chwan ikún kpa. ");
INSERT INTO yer_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Mbin aGoshen atak va̱ oIsa̱rila təm kà̱, nna byet aɗəɗal yà kà̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Te uFirona re ǹre kà̱ uMusa ká̱ uHaruna là ôza̱ pa̱, <<Ka̱ walang ata̱ mmami ká̱ mpat. UYawe uwa unəna̱n, kang mmami ká̱ onəm mi ì pəpat. ");
INSERT INTO yer_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Chal uYawe, igbarman ká̱ aɗəɗal Inan kúr chit. Mi ga ǹre wó, ó ga, á mal pa̱ o kali lap ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","UMusa là á na pa̱, <<Mi re ìtong va̱ ta̱ i gbà̱ng nva̱ng ka̱t, mi gha̱p oga awo mi ûYawe te, igbarman i sat, kang aɗəɗal i yà lap ka̱t. Te ɓu nyi pa̱ apambin nja aYawe. ");
INSERT INTO yer_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Te n nyinyi pa̱ mmaɓu ká̱ okpari ɓu o nəm ayər áYawe, Inan chit ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Ǹyangmata̱ nfət ká̱ ibəshi chwan, ka̱kul ibəshi yál chit, kang nfət te kà̱ mba̱l. ");
INSERT INTO yer_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Izangzəng jote, á vyap ka̱t, ka̱kul i ya ɓwop chit ka̱t.) ");
INSERT INTO yer_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Te uMusa re uFirona fa re ìtong, te uza̱ gha̱p oga awo wò ûYawe te, igbarman ká̱ aɗəɗal sat, iva̱r pə̀ng ka̱ apambin lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kà̱ nva̱ngva̱ uFirona ya pa̱ iva̱r, ká̱ aɗəɗal, ká̱ igbarman sat chit, te uza̱ nəm nnap mɓá̱ngɓa̱ng kà̱ɗi, uza̱ twat ìgwak, uza̱ ká̱ okpari wò. ");
INSERT INTO yer_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ìgwak aFirona twat, uza̱ yang ká̱ nre oIsa̱rila pa̱ á ga, dakdak wa nva uYawe ka̱ là ka̱ atak aMusa á. ");
INSERT INTO yer_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Te uYawe là ûMusa pa̱, <<Ga atak aFirona, ka̱kul n nak ìgugwak chit twat ká̱ ìgwak okparikpari, ka̱kul na n nyám oga iya̱m iga nɗaktak mi va̱ ta̱ kà̱ ishimshe oza̱. ");
INSERT INTO yer_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","N nəm iya̱m va̱ ta̱ ka̱kul na u shet ôvan ɓu ká̱ ôkəka ɓu nva̱ n nəm ká̱ oga aMasar pa̱ vyakshin ká̱ iya̱m iga nɗaktak va̱ n nəm ka̱ ashe oza̱, na o nyi pa̱ mmami na uYawe.>> ");
INSERT INTO yer_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Te uMusa ká̱ uHaruna ga atak áFirona là á na pa̱, <<Iya̱m va ta̱ uYawe, Inan oHiburu là, <I gbà̱ng wa nsang nna u yang ká̱ ǹyen ká̱ ishi ɓu á mi yà? Re onəm mi á ga ka̱kul na oza̱ a wop mi. ");
INSERT INTO yer_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kang a yà pa̱ u yang ká̱ ǹre onəm mi pa̱ á ga te, nyi pa̱ ìpin te, mi ga nre ǹre ká̱ mbankum kà̱ mbin ɓu. ");
INSERT INTO yer_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Oza̱ i dàngchi apambin, unəm uro i ya mbin ka̱t. Te oza̱ i ri aɓo iya̱m va̱ re á wó kà̱ nva̱ng aɗəɗal, kang i ri nkpaktak ikun wó va̱ kà̱ ntə́p ka̱ ashe ǹzam. ");
INSERT INTO yer_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Oza̱ i yə́l oga ashe ǹzhi ɓu, ká̱ nkpaktak oga ashe ǹzhi okpari ɓu, ká̱ nkpaktak nzhi oga aMasar. OPo ɓu ká̱ okəka ɓu oma ya mbankum chit wa nva̱ ta ka̱t ka̱ ashe nra va̱ oza̱ ɓa ashe apambin ká̱, á ɓa chu nra nva̱ ta̱.> >> Te uza̱ ga̱ɓa̱n fa re mpyal aFirona. ");
INSERT INTO yer_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Te okpari áFirona ɓəp na pa̱, <<I gbà̱ng wa nsang uɓàng va̱ ta̱ i sat nɗaktak á yi yà? Re onəm va̱ ta̱ á ga ka̱kul pa̱ na oza̱ a wop uYawe, Inan oza̱. Nna u nyi chit pa̱ aMasar agúng ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Te mmá le nva̱ng ká̱ uMusa ká̱ uHaruna ka̱ atak áFirona. UFirona là ôza̱ pa̱, <<Ó ga ó wop uYawe Inan wó. Uda ká̱ uda i ga yà?>> ");
INSERT INTO yer_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","UMusa là pa̱, <<Í ga nzəng ká̱ ovannza̱m ká̱ ónəmgbak, kang í ga ká̱ ovan yi onunggwan, ká̱ ochar, ká̱ oga iya̱m nkang ká̱ ína yi ka̱kul na i nəm awop aga nchang izər ûYawe.>> ");
INSERT INTO yer_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","UFirona là pa̱, <<UYawe á yà nzəng ká̱ wó, a yà pa̱ n re wó o ga nzəng ká̱ ovan wó te, á nyám pa̱ nna ó yà ká̱ nrəng nggha ngga ka̱ ashe wó. ");
INSERT INTO yer_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Pa ka̱t. O re onunggwan má chwat á ga a wop uYawe, ka̱kul iya̱m va ta ó pak mɓəɓəp.>> Te mmá ɓak oza̱ re mpyal áFirona. ");
INSERT INTO yer_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Te uYawe là ûMusa pa̱, <<Yichi awo ɓu ka̱ apambin aMasar na oga mbankum á fa kà̱ mbin aMasar na á ri nkpaktak iya̱m nsuk va aɗəɗal ka̱ chwan ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Te uMusa yichi idari wò ka̱ apambin aMasar, kang uYawe nak nyə̀r ngga asa̱l awulum apyep kà̱ nkpaktak ilum iga nda va̱ ta ka̱ nkpaktak ìzwam. Anung ìpin ɓa te, nyə̀r ngga asa̱l awulum ɓa ká̱ oga mbankum. ");
INSERT INTO yer_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Mbankum ɓa dàngchi nkpaktak mbin aMasar, á ru kà̱ nkpaktak aswari mbin aMasar. Mmak mbankum ka̱ yà chit pa ka̱t, kang i yà pa lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Oza̱ dàngchi nkpaktak apambin nva̱ ta kang à nak mbin kpà̱r, kang oza̱ ri nkpaktak oga iya̱m nsuk, ká̱ nkpaktak awar ikún va̱ re kà̱ nva̱ng aɗəɗal. Iya̱m iga ndəng ipəpà iro yà re ka̱ izər ikún, ka̱t te iya̱m nsuk ka̱t, kà̱ nkpaktak mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","UFirona re ǹre kà̱ uMusa ká̱ uHaruna pa̱ kəlak, á là pa̱, <<N nəm nnap mɓá̱ngɓa̱ng ûYawe, Inan wó, ká̱ wó. ");
INSERT INTO yer_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ka̱kul nva̱ ta te, kusukkusuk, o chal uYawe Inan wó á yar nnap mɓá̱ngɓa̱ng á mi ka̱ awalang va̱ ta̱, ka̱kul na uza̱ á yar ikú va̱ ta̱ á le á mi.>> ");
INSERT INTO yer_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Te uMusa re uFirona á ga chal uYawe. ");
INSERT INTO yer_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Te uYawe ga̱ɓa̱n ayə́r wal nyə̀r ngga asa̱l awu ntar alum nkamkam pyep kang à wur oga mbankum swang ka̱ ashe Ìwá Ìsəksək. Ko mbankum nro re pa̱ nzəng ka̱t, ka̱ ashe nkpaktak mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Kang uYawe nak ìgwak aFirona twat, uza̱ re oIsa̱rila ga ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Te uYawe là ûMusa pa̱, <<Yichi awo ɓu á ga apaɓur ka̱kul na atak akpá̱rkpà̱r á zəpchi mbin aMasar, nkpa̱r atak va mí dudok.>> ");
INSERT INTO yer_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Te uMusa yichi awo wò á ga apaɓur te, atak akpá̱rkpà̱r aɗinɗin á yà kà̱ nkpaktak mbin aMasar, nra pa̱ nshatɗing. ");
INSERT INTO yer_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ko unəm uro pa̱ uzəng chu ǹya uwanwò ka̱t, á nəm nra pa̱ nshatɗing oza̱ wong ka̱ atak va̱ oza̱ kà̱ ka̱t. Káp ká̱ nna te, nkpaktak oIsa̱rila ka̱ ashe atak ghanghan ká̱ atak va̱ oza̱ təm kà̱. ");
INSERT INTO yer_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Te uFirona wór uMusa là á na pa̱, <<Ga, wop uYawe. Ovan wó kpa i gəga nzəng ká̱ wó, nnyi te, oga iya̱m nkang wó ka̱ ína nna byet i re kà̱ nva̱ng.>> ");
INSERT INTO yer_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Te uMusa là pa̱, <<Te ɓu na nləfər iya̱m ipápà ká̱ iga nshì pa̱ ɗwot á yi ka̱ awo kpa, na í na ûYawe, Inan yi. ");
INSERT INTO yer_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Iya̱m nkang yi i ga nzəng ká̱ yi kpa, ko ifir í re kà̱ nva̱ng ka̱t. Ka̱kul í wur iro ka̱ ashishe na í wop uYawe, Inan yi ká̱, te nna í nyi iya̱m va̱ chit í ga ngwop uYawe ká̱ ka̱t, ya í chu ka̱ ta kang.>> ");
INSERT INTO yer_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Te uYawe nak ìgwak áFirona twat, uza̱ ma̱n pa̱ o re oza̱ á ga ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","UFirona là ûMusa pa̱, <<Wong fa le á mi ka̱ cho. Kang wa ma̱n wa ya asa̱l awu mi lap ka̱t. Ka̱kul ilum va̱ ɓu ya asa̱l awu mi te, ɓu kú.>> ");
INSERT INTO yer_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Te uMusa là pa̱, <<Wa nva u là. Mi yà ka̱ ǹya asa̱l awu ɓu lap ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","UYawe là ûMusa pa̱, <<Mi ga mɓa ká̱ nɗaktak kà̱ɗi pa̱ nzəng ka̱ apal aFirona ká̱ mbin aMasar. Kà̱ nva̱ng nva̱ ta te, uza̱ i re wó ó ga. Awalang va̱ uza̱ i re wó pa̱ ó ga te, uza̱ i ɓàk wó ó fa ka̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ǹyangmata̱ nak ka̱ chwang oIsa̱rila là oza̱ pa̱, onunggwan ká̱ ochar á ɓəp iya̱m ìsham iga aazurfa ká̱ azənariya ka̱ atak oMasar, onəm oga nggɓa̱k oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","UYawe nak nchə̀r oza̱ bà̱l kà̱ mpyal oga aMasar. UMusa yà unəm uchumchum kà̱ mbin aMasar kà̱ ìwu okpari áFirona ká̱ onəm kpa. ");
INSERT INTO yer_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Te uMusa là pa̱, <<Iya̱m va ta̱ uYawe là, <Ká̱ ishimshe ìzwam te, mi watar ka̱ ashe mbin aMasar, ");
INSERT INTO yer_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","kang nza̱ uyennunggwan nggo amar agəshi ka̱ ashe mbin aMasar i kú. I ɓàn ka̱ apal ayen ununggwan ugəshi áFirona, i ga i chu uyen ugəshi àyen uchar uzwal uva̱ ka̱ apal akò, ká̱ nza̱ amar ágəshi nggo aga iya̱m nkang. ");
INSERT INTO yer_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Te mí fe ayə́ng aga aɗor kà̱ nkpaktak mbin aMasar ava nna mmá ká̱ ya chit ka̱t, ka̱t te pa̱ nna mí ga ǹyiya lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Kang ka̱ atak nkpaktak oIsa̱rila te, ìva ìro ìswak unəm ka̱t, ka̱t te iya̱m nkang ka̱t, ka̱kul na o nyi pa̱ uYawe nyám nva̱n chit kà̱ ishimshe oga aMasar ká̱ oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Nkpaktak okpari ɓu va̱ ta̱, oza̱ i fə́ng i kuchi kà̱ mpyal mi, i là pa̱, <<O fa mmaɓu ká̱ nkpaktak onəm va̱ i yar nva̱ng ɓu,>> kà̱ nva̱ng nva̱ ta te, mi ga.> >> Te ìgwak shì uMusa fa re atak áFirona. ");
INSERT INTO yer_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","UYawe là ûMusa pa̱, <<UFirona i yà ká̱ nggwong achwang ká̱ wó ka̱t, ka̱kul pa̱ na ń nəm oga iya̱m iga nɗaktak ka̱ ashe mbin aMasar.>> ");
INSERT INTO yer_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","UMusa ká̱ uHaruna nəm nkpaktak oga iya̱m iga nɗaktak va̱ ta̱ kà̱ mpyal áFirona, te uYawe nak ìgwak áFirona twat, te uza̱ re oIsa̱rila pa̱ á fa ka̱ ashe mbin wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","UYawe là nnap ká̱ ûMusa ká̱ ûHaruna kà̱ mbin aMasar pa̱, ");
INSERT INTO yer_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","<<Apye va ta̱, i yà apye aga nggəshi á wó ka̱ ashe ìzun. ");
INSERT INTO yer_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Là nkpaktak mɓut ôIsa̱rila pa̱, kà̱ nra ngga ngba̱pchi ka̱ apye va̱ ta̱ te, nza̱ unəm nggo á kpán ìya iya̱m nkang ka̱kul nza̱ ǹzhi nggo. ");
INSERT INTO yer_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kang a yà pa̱ ashe ǹzhi va̱ yə́l kur nrì iya̱m nkang va̱ ta ka̱t te, re uza̱ á kap ka̱ unəm uga ngba̱k ǹzhi wò, ka̱ apal ìyəl onəm oga nrì iya̱m nkang va̱ ta kà̱ nza̱ ǹzhi nggo. ");
INSERT INTO yer_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Iya̱m nkang va̱ ta á yà inunggwan iga ìzun pa̱ ìzəng, ìtam ka̱t te ìɓəl, iva yà ká̱ mbyèt ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","O nak ishi a ga chu nra ngga ngba̱pchi ama̱n pa̱ neɗing aga apye va̱ ta, te nkpaktak mɓut oIsa̱rila i pà iya̱m nkang va̱ ta ká̱ arurong. ");
INSERT INTO yer_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Te oza̱ i dok nchəchər í ɓàp kà̱ oga ndar ngga mparəm ngga oga anung nzhi ká̱ apal oga anung nzhi nva̱ oza̱ í ri kà̱. ");
INSERT INTO yer_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Oza̱ i ri ìzhe iwángwàng va̱ ta ká̱ ìzwam va ta, nzəng ká̱ nzəngkəng ngga ǹyà ká̱ anyer ka̱t ká̱ azang aɗúlɗul. ");
INSERT INTO yer_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kang o ri iro ilulong, ka̱t te ipə́kpə́k ká̱ ndəng ka̱t. Ó wàng ká̱ pər, ishishi ká̱ oga mbwángbwáng, ká̱ oga iya̱mfu. ");
INSERT INTO yer_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kang o re iro achu ìpin ka̱t. O shì ivəngva̱ le kang atak á tàn kà̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Asa̱l va ta̱ o ri ká̱. O ran ilukwan wo ká̱ ngbat, akwap wo ka̱ ashar wo, kang idari wo ka̱ awo wo. O ri ká̱ ngha̱n, iya̱m-nrì áYawe iga nggantal. ");
INSERT INTO yer_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","<<Te mi watar ka̱ ashe mbin aMasar ká̱ ìzwam va̱ ta, kang mi gbá̱ng nkpaktak amar aga nggəshi ka̱ ashe mbin aMasar, unəmləbər ká̱ iya̱m nkang, te mi gəl akwali nkpaktak oga inan iga aMasar. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Nchə̀r va̱ o ɓàp ka̱ anung oga ǹzhi te, i yà iya̱m iga ǹnyám atak va̱ mmawó kà̱, a yà pa̱ n ya nchə̀r te, mi gantal wó. Nɗaktak ikú i dok wó ka̱t, kà̱ awalang va̱ n ləp aMasar á. ");
INSERT INTO yer_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","<<Nra va̱ ta̱ i yà iya̱m iga nrəng ká̱, te ó nak na i yà nchang izər awop ûYawe ka̱ ashe nkpaktak nlwàk wó, o nak ishi ká̱ nnap nnəm va̱ ta̱ ghar mbyet. ");
INSERT INTO yer_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Nra pa̱ nfangshat o ri nzəngkəng nva mmá nəm ka̱ anyer ka̱t. Ka̱ apal nra ngga nggəshi te, o fa ka̱ anyer ka̱ ashe oga nzhi wó, ka̱kul unəm va̱ ari iya̱m iga anyer á ɓàn kà̱ nra ngga nggəshi ga chu ngga nfangshat te, mí tutur í fa ka̱ ashe aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Mɓut nyə́ryər á yà ka̱ apal nra ngga nggəshi, kang mɓut nyə́ryər i yà kà̱ nra ngga nfangshat. Inok iro yà ó nəm ka̱ ashe oga nra va̱ ta ka̱t, ya nnəm iya̱m-nrì chwat pa̱ ko udanggo á ri, nna byet o nəm. ");
INSERT INTO yer_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","<<Ó nəm nchang izər ngga nzəngkəng ngga ǹyà ká̱ anyer ka̱t, ka̱kul kà̱ ilum iva ta̱ n fa ká̱ nggatək wó ka̱ ashe mbin aMasar. O nak ishi ká̱ nnap nnəm va̱ ta̱ ghar mbyet ka̱ ashe oga nlwàk wó. ");
INSERT INTO yer_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ka̱ ashe apye aga nggəshi, á ɓàn ká̱ arurong aga nra ngga ngba̱pchi ama̱n pa̱ neɗing ga chu arurong aga nra ngga ìsəm pa̱ iparəm ama̱n pa̱ zəng te, o ri nzəngkəng ngga anyer ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ka̱kul nra pa̱ nfangshat mí ya anyer ka̱ ashe oga ńzhi wo ka̱t. Unəm va̱ kpaktak i ri iya̱m va̱ ka̱ anyer te, mí fa ká̱ na ka̱ ashe mɓut oIsa̱rila, uɗyanəm ka̱t te uyen uga mbin. ");
INSERT INTO yer_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Iya̱m va pa̱ káp mmá nəm ka̱ anyer te, a sat nkpak o ri ka̱t, kà̱ nkpaktak atak va̱ o təm kà̱ te, o ri nzəngkəng va yà ka̱ anyer ka̱t á.>> ");
INSERT INTO yer_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Te uMusa wór nkpaktak onəmgbak oga aIsa̱rila là ôza̱ pa̱, <<O ga, o yak ivan iya̱m nkang kang ô pà, na nzhi wó á nəm nchang izər ngga nggantal ká̱. ");
INSERT INTO yer_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Te o yar ìzuzul o pá ka̱ ashe nchə̀r va̱ ka̱ ashe asu, ó ɓàp kà̱ oga ndar ngga mparəm ngga anung nzhi ká̱ apal anung nzhi ka̱ nchə̀r va̱ ka̱ ashe asu. Te nkpak kang uro ka̱ ashe wo á fa ka̱ anung ǹzhi ka̱t atak á tàn kang. ");
INSERT INTO yer_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Nva̱ngva̱ uYawe i watar pa̱ ô ləp oMasar, kang i ya nchə̀r kà̱ oga ndar ngga mparəm ngga anung nzhi ká̱ apal anung nzhi te, uYawe i gantal anung nzhi va̱ ta, kang i yà ká̱ ǹre unəm uga nzhì atak i tar nzhi wó pa̱ á ləp wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","<<O nak ishi ká̱ nnap nnəm va̱ ta̱ ka̱kul ishi wo, ká̱ ovan onunggwan wo ghar mbyet. ");
INSERT INTO yer_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Nva̱ng nva̱ o chu mbin va̱ uYawe i ga nnəna a wo wa nva uza̱ là te, o ga mpyal ká̱ nnap nnəm va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Awalang ava̱ ovan wó á ɓəp wó pa̱, <Iza̱ ìpir nnap nnəm va̱ ta̱ ka̱ atak wó yà?> ");
INSERT INTO yer_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","te o là ôza̱ pa̱, <Nləfər iya̱m ipápà iga nggantal ûYawe, uva gantal oga nzhi oIsa̱rila ka̱ ashe aMasar, nva̱ uza̱ ləp oga aMasar kang uza̱ gar oga nzhi yi.> >> Te onəm kúchi nəm awop. ");
INSERT INTO yer_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Te oIsa̱rila nəm wa nva uYawe nak uMusa ká̱ uHaruna. ");
INSERT INTO yer_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ká̱ ishimshe ìzwam te, uYawe ləp nkpaktak ovan onunggwan oga nggəshi ka̱ ashe mbin aMasar. Uza̱ ɓàn kà̱ uya aFirona ununggwan uga nggəshi uva təm ka̱ apal itok iponzhi, ghar ga chu uyennunggwan uga nggəshi anəm uga ashe ìkan uva̱ kà̱ nzhi ìkan, ká̱ nkpaktak ivan iya̱m nkang iga nggəshi. ");
INSERT INTO yer_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","UFirona yenda̱l ka̱ ìzwam, ká̱ nkpaktak onəm ochumchum wò, ká̱ nkpaktak onəm oga aMasar, kang ayə́ng náp pa̱ bóbó ka̱ ashe mbin aMasar, ka̱kul ko nzhi nro pa̱ nzəng nva pa̱ unəm kú kà̱ ka̱t te á yà ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Te uza̱ wór uMusa ká̱ uHaruna ka̱ ashe ìzwam va̱ ta, á là pa̱, <<O wong, o fa ka̱ ashe onəm mi, nkpaktak wó ká̱ oIsa̱rila. O ga o wop uYawe, wa nva o chal á. ");
INSERT INTO yer_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","O wur iya̱m nkang wó, ká̱ ína wó, na ó ga wa nva o chal. O nak nnap nnəna̱n á mi kpa.>> ");
INSERT INTO yer_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Oga aMasar sat atak onəm oga aIsa̱rila pa̱, oza̱ á fa pa̱ kəlak á re mbin va̱ ta, oza̱ là pa̱, <<Nkpaktak yi í ga nkú.>> ");
INSERT INTO yer_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Te onəm wur mmá̱k mɓitɓit nva yà ká̱ anyer ka̱t, ká̱ oga asu oza̱ aga nkál mmá̱k, lur oza̱ ka̱ ashe ilukwan, kang à wur ka̱ apal oga agar oza̱. ");
INSERT INTO yer_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Te oIsa̱rila nəm wa nva uMusa là, oza̱ ɓəp ilukwan, ká̱ oga iya̱m ìsham iga aazurfa ká̱ azənariya ka̱ atak oga aMasar. ");
INSERT INTO yer_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Te uYawe nak nchə̀r onəm va̱ ta̱ bà̱l ka̱ atak oga aMasar, te oza̱ na iya̱m va̱ óIsa̱rila ɓəp kà̱ oza̱. Wa nnà ta oza̱ vyat ndur oga aMasar ká̱. ");
INSERT INTO yer_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","OIsa̱rila nəm achen ká̱ ashar, á ɓàn ka̱ aRamaset ga chu aSukkot. Ìyəl onunggwan ga wa ìkalong ìgba̱l pa̱ ìkpa̱ɗing. Mmá kung ovan ká̱ ochar ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Idonkong onəm oro pa̱ makmak ga nzəng ká̱ oza̱, ká̱ nggatək oga iya̱m nkang ká̱ ína pa̱ makmak. ");
INSERT INTO yer_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Oza̱ wàng nzəngkəng ká̱ mmá̱k mɓiɓit va̱ oza̱ fa ká̱ ka̱ aMasar, ka̱kul á yà ká̱ anyer ka̱t. Awalang va̱ mmá ɓak oza̱ fa ka̱ ashe aMasar te, oza̱ kali ka̱t, kang oza̱ nəm iya̱m-nrì iro ka̱kul ishi oza̱ ka̱t kpa. ");
INSERT INTO yer_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ntəm onəm oga aIsa̱rila ka̱ aMasar nəm ìzun ìgba̱l pa̱ ìneɗing ka̱ ìsəm pa̱ ishatɗing. ");
INSERT INTO yer_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Kà̱ nkur ìzun ìgba̱l pa̱ ineɗing ká̱ ìsəm pa̱ ishatɗing va̱ ta, ká̱ nda va ta nkpaktak nggatək onəm áYawe fa ka̱ ashe mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ìzwam va̱ uYawe pángchí ka̱kul na ó fa ká̱ oza̱ ka̱ ashe mbin áMasar, te nkpaktak oIsa̱rila ra nda ká̱ ìzwam va̱ ta ka̱t, ka̱kul nna ichumchum ûYawe ká̱, ka̱ ashe oga nlwàk ká̱ nlwàk. ");
INSERT INTO yer_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Te uYawe là ûMusa ká̱ ûHaruna pa̱, <<Oga nnap nnəm ngga nggantal nata̱, kang uɗyanəm á ri iya̱m-nrì iga nggantal ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Uzwal va̱ mmá yiyáp te, uza̱ i riri a yà pa̱ mmá pà ache á na chit á. ");
INSERT INTO yer_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Unəm va̱ mmá yar ka̱ inok mbwai, ká̱ unəmchən te, oza̱ i ri ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","<<Mí ri kà̱ nzhi pa̱ nzəng. O yà ká̱ ǹyar ìzhe iro i fa agbai ka̱t, kang o ɓəkchi akúkup aro ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Nkpaktak mɓut oIsa̱rila í nəm nchang izər va̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","<<A yà pa̱ unəmchən təm nzəng ká̱ wó kang á ɗom nnəm nggantal ûYawe te, re nkpaktak onunggwannunggwan á pà ache, nna chit te, uza̱ i nəm nggantal, te uza̱ i yà wa áyen uga mbin. Kang nza̱ ununggwan nggo uva̱ pà ache ka̱t te, i ri nggantal ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Nnap nnəm nzəngtəng va ta̱ i yà ka̱ apal áyen uga mbin, ká̱ unəmchən va̱ təm ka̱ ashe wó.>> ");
INSERT INTO yer_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Te nkpaktak oIsa̱rila nəm dakdak, wa nva̱ uYawe nak uMusa ká̱ uHaruna. ");
INSERT INTO yer_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Kang ká̱ nda va ta uYawe fa ká̱ oIsa̱rila ka̱ ashe mbin aMasar idonkong idonkong. ");
INSERT INTO yer_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Te uYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","<<Gar nkpaktak ovan onunggwan óIsa̱rila amar aga nggəshi á mi, ka̱kul nza̱ amar afu aga nggəshi anəmləbər, ká̱ iya̱m nkang te, i jem.>> ");
INSERT INTO yer_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Te uMusa là ônəm pa̱, <<O rəng ilum va̱ ta̱, iva o fa ká̱ ka̱ ashe mbin aMasar, nzhi izwal, ka̱kul uYawe à fa ká̱ wó ká̱ awo wò akamkam. O rəng, kang o ri iya̱m iga anyer ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","N̂da va̱ ta̱, ka̱ ashe apye aAbip, mmawó kà̱ ngga nfa. ");
INSERT INTO yer_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Awalang va̱ uYawe ɓa ká̱ wo ka̱ ashe mbin oKanana, ká̱ oHiti, ká̱ oAmori, ká̱ oHivi, ká̱ oYebusi, nva uza̱ sóng anung ôpo wó pa̱ ò ga nna á wó, mbin va mbyal ká̱ mmàl irizhe i nang ka̱ ashishe, nkpak o nəm nnap nnəm va̱ ta ka̱ ashe apye va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Nra pa̱ nfangshat o ri nzəngkəng ngga ǹyà ká̱ anyer ka̱t, kang kà̱ ilum iga ifangshat te, o nəm nchang izər ûYawe. ");
INSERT INTO yer_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","O ri nzəngkəng ngga ǹyà ká̱ anyer ka̱t ka̱ ashe oga nra ngga nfangshat, kang mmá ya iya̱m iga anyer ka̱ ashe wó ká̱ nkpaktak aswari wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Kà̱ nra ngga nfangshat va̱ ta te, o là ipipir ôvan wó pa̱, <Ka̱kul iya̱m va uYawe nəm á yi kà̱ ilum va̱ í fa ká̱ ka̱ ashe aMasar.> ");
INSERT INTO yer_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Re á ta̱l á wó wa iya̱m iga nnyám ipir nnap ka̱ awo wó kang wa iya̱m iga nrəng ká̱ kà̱ isu wó, na á nak nnap mpakpak àYawe á yà ka̱ anung wó, ka̱kul uYawe fa ká̱ wó ka̱ ashe aMasar ká̱ awo akamkam. ");
INSERT INTO yer_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","O kpak nnap nnəm nva̱ ta̱ ka̱ apal nra va mmá nak, nza̱ ìzun nggo.>> ");
INSERT INTO yer_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","<<UYawe i ga mɓa ká̱ wó ka̱ ashe mbin oKanana, wa nva uza̱ sóng anung á wó ká̱ ôpo wó. Awalang va̱ uza̱ i na á wó te, ");
INSERT INTO yer_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","o na nza̱ amar afu aga nggəshi nggo ûYawe. Nza̱ amar aga nggəshi iya̱m nkang inunggwan nggo te, i ji áYawe. ");
INSERT INTO yer_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Nza̱ amar azhaki aga nggəshi nggo te, ka̱m ishishi ká̱ iya̱m nkang, kang a yà pa̱ o ka̱m ishishi ka̱t te, o ɓəkchi ishishak. O ka̱mshi nza̱ amar áyen ununggwan uga nggəshi ánəmləbər nggo. ");
INSERT INTO yer_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","<<Ka̱ ashe nra ngga mɓa te, uyen ɓu i ɓəp ɓu pa̱, <Iya̱m va̱ ta̱ ipipir iza̱ yà?> te là á na pa̱, <Ká̱ awo akamkam uYawe fa ká̱ yi ka̱ aMasar, nzhi izwal. ");
INSERT INTO yer_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Nva̱ngva̱ uFirona yang ká̱ nkak ishi pa̱ ò re yi í ga ka̱t te, uYawe gbá̱ng nkpaktak amar aga nggəshi onunggwan ka̱ ashe mbin aMasar, ɓàn ká̱ amar aga nggəshi ánəmləbər ká̱ aga nggəshi iya̱m nkang. Nna nak kang í pà amar afu aga nggəshi ûYawe, kang í ka̱mshi nkpaktak ovan onunggwan yi oga nggəshi.> ");
INSERT INTO yer_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Re á ta̱l á wó wa iya̱m iga nnyám ipir nnap ka̱ awo wó, kang wa iya̱m iga nrəng ká̱ kà̱ isu wó, ka̱kul uYawe fa ká̱ yi ka̱ ashe aMasar ká̱ awo wò akamkam.>> ");
INSERT INTO yer_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Nva̱ngva̱ uFirona re onəm va̱ ta ga te, Inan wòl ká̱ oza̱ ka̱ asa̱l va̱ watar ka̱ ashe mbin oFilitti ka̱t, káp ká̱ nva̱ nna asa̱l adatdat á. Ka̱kul Inan là pa̱, <<A yà pa̱ onəm á ya ìkum te, i ga̱ɓa̱n igwak oza̱, i le aMasar.>> ");
INSERT INTO yer_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Te uza̱ wòl ká̱ onəm ka̱ asa̱l aga ashe anyin ava wòl isu Ìwá Ìsəksək. Kang oIsa̱rila re aMasar wa nra izər ìkum. ");
INSERT INTO yer_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","UMusa wur akup aYusufu ka̱ awo, ka̱kul uYusufu nak oIsa̱rila sóng anung pa̱, <<Nnandər Inan i ka̱mshi wó, te nkpak pa̱ o wur akup mi ká̱ wo o fa ká̱ ka̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Oza̱ wong ka̱ aSukkot oza̱ ga lə̀p apa̱k ka̱ aEtam ka̱ a ranchwang nzam. ");
INSERT INTO yer_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","UYawe ləp mpyal óza̱ ka̱ ashe ǹdáng ìlulu ká̱ alum na ó kpak oza̱ ka̱ asa̱l, kang ká̱ ǹdáng apər ká̱ ìzwam pa̱ á ghan atak oza̱ ka̱kul na oza̱ á chen achen ìzwam ká̱ alum. ");
INSERT INTO yer_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ǹdáng ìlulu ká̱ alum kà̱ mpyal onəm, kang ǹdáng apər ká̱ ìzwam kà̱ mpyal oza̱. ");
INSERT INTO yer_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Te uYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","<<Là ônəm oga aIsa̱rila pa̱, oza̱ a ga̱ɓa̱n oza̱ á lə̀p apa̱k kà̱ mpyal aFi-hahirot kà̱ ishimshe aMikdol ká̱ ìwá, oza̱ á lə̀p apa̱k á nak ìkwoksok ká̱ aBaal Zefon. ");
INSERT INTO yer_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Te uFirona i rəng pa̱, <OIsa̱rila kà̱ nránggang ka̱ ashe mbin, ká̱ nzwar kang ǹzam kuk oza̱ chit.> ");
INSERT INTO yer_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Te mi nak ìgwak aFirona i twat, uza̱ i ɓàk nva̱ng wó. Mí rup ká̱ mi ka̱ atak áFirona ká̱ nkpaktak onəm ikukum, te oga aMasar i nyi pa̱ mmami na uYawe.>> Te oIsa̱rila ga̱ɓa̱n pak apa̱k ka̱ ta wa nva uYawe là ôza̱. ");
INSERT INTO yer_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Awalang va̱ mmá là ûponzhi oga aMasar pa̱, oIsa̱rila chəng chit, te nrəng nnap áFirona ká̱ ókparikpari ga̱ɓa̱n ka̱ apal oza̱. Oza̱ là pa̱, <<Iza̱ í nəm ta̱ yà? Nna í re oIsa̱rila ga kang í lang onəm oga nnəm inok á yi á.>> ");
INSERT INTO yer_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Te uFirona gbar akeke ipəri wò kang à wur onəm ìkum wò nzəng ka̱ na. ");
INSERT INTO yer_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Uza̱ wur oga akeke ipəri anəna̱n igba̱l pa̱ ìkpa̱ɗing nzəng ká̱ aɓo akeke ipəri oga aMasar pa̱ kpaktak ká̱ onəm oga mpyal ìkum ka̱ apəpal. ");
INSERT INTO yer_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","UYawe nak ìgwak aFirona uponzhi oga aMasar twat, kang uza̱ ɓàk nva̱ng oIsa̱rila, ova kà̱ nfa nzəng ká̱ nkam ìgwak. ");
INSERT INTO yer_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Nkpaktak ipəri aFirona ká̱ akeke ipəri ká̱ onəm oga nkwák ipəri, ká̱ onəm ìkum oga aMasar ɓàk nva̱ng oza̱. Oza̱ ɓàn oIsa̱rila lə̀p apa̱k ka̱ anung awang kà̱ ngba̱k aFi-hahirot kà̱ mpyal aBaal Zefon. ");
INSERT INTO yer_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Nva̱ uFirona kà̱ mɓa kang onəm oIsa̱rila wong ká̱ íwu ya oga aMasar kà̱ mɓa kà̱ oza̱ te, ayər nəm oza̱ pa̱ gənggəng kang oza̱ yə́ng ûYawe. ");
INSERT INTO yer_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Te oza̱ là ûMusa pa̱, <<Ka̱kul pa̱ atak nli onəm yà ka̱ aMasar ka̱t kang u fa ká̱ yi pa̱ na i kú ka̱ ashe anyin ɗò? Iza̱ u nəm á yi ta̱, u fa ka̱ yi ka̱ ashe aMasar yà? ");
INSERT INTO yer_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Iya̱m va ta̱ í là a ɓu ka̱ aMasar pa̱, <Re yi na í nəm inok oga aMasar> ka̱t ɗò? Ka̱kul á kapkap á yi pa̱, í nəm inok oga aMasar ká̱ nva̱ pa̱, í kú ka̱ ashe anyin.>> ");
INSERT INTO yer_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","UMusa là ônəm pa̱, <<Kang ayər a nəm wó ka̱t, ó tong pa̱ kwák na ó dər nka̱mshi va̱ uYawe i ga mɓa ká̱ á wó nda va̱ ta̱. Onəm oga aMasar va̱ ó ya nda va̱ ta̱ te, ó yà ká̱ ǹya oza̱ lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","UYawe i lung ìkum ka̱kul wó. Ó má̱ng pa̱ kwák.>> ");
INSERT INTO yer_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Te uYawe là ûMusa pa̱, <<Sang kang ɓu yə́ng á mi yà? Là ôIsa̱rila pa̱ oza̱ á yà kà̱ ngga. ");
INSERT INTO yer_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Mmaɓu te, gha̱p idari ɓu, yichi awo ɓu ka̱ apal ìwá, te i kap na oIsa̱rila á chen kà̱ ishimshe ìwá ka̱ apambin ngwomwom. ");
INSERT INTO yer_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mmami nnyi te, mi nak ìgwak oga áMasar i twat, te oza̱ i táng kà̱ nva̱ng wó, kang mí rup ká̱ mi ka̱ atak áFirona, ká̱ nkpaktak onəm ikukum, ká̱ akeke ipəripəri, ká̱ onəm oga nkwák ipəripəri. ");
INSERT INTO yer_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Oga aMasar i nyi pa̱, mmami na uYawe, nva̱ngva̱ mí rup ká̱ mi ka̱ atak áFirona, ká̱ akeke ipəripəri, ká̱ onəm oga nkwák ipəripəri.>> ");
INSERT INTO yer_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","UMa̱leka Inan, va̱ ka̱ yà kà̱ nchen kà̱ mpyal oIsa̱rila le ga asa̱l nsəm oza̱. Ǹdáng ìlulu le kà̱ mpyal oza̱ ga sat ka̱ asa̱l nsəm oza̱, ");
INSERT INTO yer_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","kà̱ ishimshe onəm oIsa̱rila ká̱ onəm oga aMasar. Te ìlulu va̱ ta na atak akpá̱rkpà̱r kà̱ ngba̱k nro kang atak aghanghan kà̱ ngba̱k nro, kang unəm uro dat ká̱ uwanwò ka̱t, nkpaktak ìzwam. ");
INSERT INTO yer_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Te uMusa yichi awo wò ka̱ apal ìwá kang uYawe dà̱n ìwá ká̱ nyə̀r nkamkam ka̱ asa̱l awu alum nkpaktak ìzwam, te á nak ìwá kap re mbin ngwomwom. ");
INSERT INTO yer_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Kang oIsa̱rila chen kà̱ ishimshe ìwá ka̱ apambin ngwomwom, te ndəng nəm akamsəlang ka̱ awo ari ká̱ awo apəra̱m oza̱. ");
INSERT INTO yer_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Oga aMasar ɓàk nva̱ng oza̱ táng ashe ìwá, nkpaktak ipəri áFirona, ká̱ oga akeke ipəripəri, ká̱ onəm oga nkwák ipəripəri. ");
INSERT INTO yer_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ká̱ iɓotak te, uYawe ka̱ ashe ǹdáng ngga apər, ká̱ ìlulu, á dər onəm ìkum oga aMasar te, á nak onəm oga aMasar ka̱ ashe nzwar. ");
INSERT INTO yer_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Te uza̱ ran ashar akeke ipəri oza̱ á nak nchəng ma̱t oza̱. Oga aMasar là pa̱, <<Re í chəng ka̱ atak oIsa̱rila ka̱kul uYawe kà̱ nlung ìkum ôza̱ ka̱ apal yi.>> ");
INSERT INTO yer_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","UYawe là ûMusa pa̱, <<Yichi awo ɓu ka̱ apal ìwá na ndəng á ledok ka̱ apal oga aMasar, ká̱ oga akeke ipəri, ká̱ onəm oga nkwák ipəri.>> ");
INSERT INTO yer_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","UMusa yichi awo wò ka̱ apal ìwá kang ká̱ ntàn atak te, ìwá le atak nva̱ng wò. Oga aMasar kà̱ nchəng pa̱ o fa te, uYawe gún onəm oga nnəm ìkum ka̱ ashe ndəng. ");
INSERT INTO yer_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ndəng le nva̱ng gún akeke ipəri ká̱ onəm oga nkwák ipəri ká̱ nkpaktak onəm ìkum áFirona, va̱ ɓàk nva̱ng oIsa̱rila ka̱ ashe ìwá. Uro ka̱ ashe oza̱ le pa̱ uzəng ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","OIsa̱rila chen ka̱ apambin ngwomwom kà̱ ishimshe ìwá, ndəng nəm akamsəlang ka̱ awo ari ká̱ awo apəra̱m oza̱. ");
INSERT INTO yer_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Nda va̱ ta te, uYawe fa ká̱ aIsa̱rila ka̱ awo oga aMasar, kang oIsa̱rila ya oga aMasar kú, ra ka̱ anung ìwá. ");
INSERT INTO yer_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Awalang va̱ oIsa̱rila ya inok ichumchum va̱ uYawe nəm ka̱ apal oga aMasar te, onəm nəm ayər aYawe, kang oza̱ na nnandər ká̱ uYawe kang ká̱ uzuzwal uMusa. ");
INSERT INTO yer_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Te uMusa ká̱ ovan oga aIsa̱rila shì nnap-nshì va̱ ta̱ ûYawe pa̱, <<Mi shì nnap-nshì ûYawe, uza̱ kúkúr pa̱ mmá rup ka̱ na. Ipəri ká̱ onəm oga nkúkwák uza̱ swang ka̱ ashe ìwá. ");
INSERT INTO yer_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","UYawe uwa nggwanggwang mi nkamkam, kang uwa nka̱mshi irirì mi. Inan mi yà ta̱, kang mi shep na, Inan apo mi, mi rup ka̱ na. ");
INSERT INTO yer_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","UYawe uwa unəm uga nlung ìkum, aɗiɗin pa̱ uYawe. ");
INSERT INTO yer_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Akeke ipəri áFirona ká̱ onəm ìkukum, uza̱ swang ka̱ ashe ìwá. Onənəm onəna̱n oga mpyal ìkum, zhì ka̱ ashe Ìwá Ìsəksək. ");
INSERT INTO yer_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ngbà̱ng ìwá gún oza̱, oza̱ zhip fa ga ìjili wa ipang. ");
INSERT INTO yer_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Awo ari ɓu, áYawe, ká̱ ìkam ìchumchum. Awo ari ɓu, áYawe, dəshin okpa ìkum. ");
INSERT INTO yer_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ka̱ ashe rup ichumchum ɓu, u túng okpa ìkum ɓu, u re ǹre ká̱ nfə́l ìgwak ɓu kang à ri oza̱ wa akùkwa. ");
INSERT INTO yer_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ka̱ atak mɓur ǹyì ngga alúr ɓu te, ìgum ndəng wong shàng. Ndəng nnángnáng ɓut nchələng, ngbà̱ng ndəng nə́k kà̱ ishimshe ìwá. ");
INSERT INTO yer_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ukpa ìkum là pa̱, <Mi ɓàk oza̱, mi kpán oza̱, mi wur idur oza̱, ká̱ nkpaktak iya̱m iva̱ n ɗom. Mi dapchi ndokchi mi, kang awo mi nzhì oza̱.> ");
INSERT INTO yer_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Te u ɓur ǹyì ɓu, kang ìwá gún oza̱. Oza̱ zhip wa acham aləbər ka̱ ashe ìnang ìwá. ");
INSERT INTO yer_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Uda wa nji ɓu, áYawe, ka̱ ashe oga inan yà? Uda wa nji ɓu, ká̱ ichumchum iga iyə́ryər, uga nəm ayə́r uva yə́l ká̱ ashep, uva i nnəm iya̱m iga nɗaktak yà? ");
INSERT INTO yer_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","U yichi awo ari ɓu, kang mbin ma̱ng oza̱. ");
INSERT INTO yer_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ka̱ ashe mma̱n ɓu ngga nnandər u ləp mpyal ónəm va̱ u fa ká̱ oza̱, ká̱ ìkàm u pángchí oza̱ ka̱ atak ntəm ɓu ayə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Mbin fe te. Oza̱ tán, kang ayər kpán oFilitti. ");
INSERT INTO yer_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Oponzhi oga aEdom təm ká̱ nləp ìchəgwak, ayər kpán onəm oga mpyal aMowap, onəm oga aKanana sərak le, ");
INSERT INTO yer_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ngga̱m ká̱ nləp ìchəgwak ru ka̱ apal oza̱. Ka̱ atak ichumchum ìkàm ɓu oza̱ sat pa̱ chə́k wa ipang onəm ɓu watar kang, áYawe, onəm va̱ u yáp watar kang. ");
INSERT INTO yer_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","U ɓa ká̱ oza̱ kang u ɓal oza̱ ka̱ apal aɓam ɓu, áYawe, atak va u nəm ka̱kul ntəm ɓu, anəm uga nzhi, Atak Ayə́ryər va awo ɓu pak. ");
INSERT INTO yer_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","UYawe i nəm ichumchum mbyet mbyet.>> ");
INSERT INTO yer_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Awalang va̱ ipəri áFirona, ká̱ akeke ipəri, ká̱ onəm oga nkwák ipəri táng ashe ìwá te, uYawe le nva̱ng ká̱ ndəng ìwá gún oza̱, kang oIsa̱rila chen kà̱ ìshimshe ìwá ka̱ apambin ngwomwom. ");
INSERT INTO yer_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Te uMiriya̱m uchar uga nlà ìchu Inan, ugənang aHaruna, yar akəshákkəshák ka̱ awo wò, kang nkpaktak ochar yar nvəva̱ng ká̱ akəshákkəshák ká̱ ngba̱p nza̱m. ");
INSERT INTO yer_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Te uMiriya̱m shì nnap-nshì óza̱. <<Shì nnap-nshì ûYawe, uza̱ kúkúr pa̱ mmá rup ka̱ na. Ipəri ká̱ unəm uga nkúkwák uza̱ swang ka̱ ashe ìwá.>> ");
INSERT INTO yer_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Te uMusa dàp nkpánggang oIsa̱rila ka̱ anung Ìwá Ìsəksək, oza̱ ga ashe anyin aShur. Oza̱ chen ka̱ ashe anyin nra pa̱ nshatɗing, kang oza̱ ya ndəng ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Oza̱ ɓa aMara te, ndədəng ma̱t oza̱ kà̱ ngwa ka̱kul á ɗuɗul. ");
INSERT INTO yer_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Te onəm lwang nnap ka̱ apal áMusa, i là pa̱, <<Iza̱ í wá yà?>> ");
INSERT INTO yer_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Te uza̱ yə́ng ûYawe kang uYawe nyám ìkun iro á na. Uza̱ kakchi mandar ka̱ ashe ndəng te, ndəng chàng. UYawe nak nnap nnəm óza̱, kang uza̱ ma oza̱ ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Te uza̱ là pa̱, <<A yà pa̱ o gwong achwang pa̱ dakdak kà̱ ìchu aYawe Inan wó, kang o nəm iya̱m va inəna̱n kà̱ mpipyal, o nak achwang kà̱ oga nnap mpakpakpakpak, o kpak nkpaktak oga nɗiɗyang te, mi yà ká̱ nlə̀p wó ká̱ arwa va̱ ka̱ n lə̀p oga aMasar ká̱ ka̱t. Ka̱kul mmami uYawe uva tàn wó.>> ");
INSERT INTO yer_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Te oza̱ ɓa aElim, atak va oga acé aga mɓəl ndəng kà̱, pa̱ gba̱pchi ama̱n pa̱ parəm, ká̱ oga ikún akulom ìsəm pa̱ ifangshat, kang oza̱ lə̀p apa̱k ka̱ ta ka̱ anung ndəng. ");
INSERT INTO yer_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Nkpaktak mɓut oIsa̱rila re aElim oza̱ ɓa ǹzam aSin va̱ ká̱ ishimshe aEləp ká̱ aSinayi, kà̱ nra ngga ngba̱pchi ama̱n pa̱ tukun ka̱ apye aga parəm kà̱ nva̱ngva̱ oza̱ re mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Nkpaktak mɓut oIsa̱rila lwang nnap ka̱ apal áMusa ká̱ uHaruna ka̱ ashe ǹzam. ");
INSERT INTO yer_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","AIsa̱rila là óza̱ pa̱, <<Kàpkàp ká̱ í kú ka̱ awo áYawe kà̱ mbin aMasar, kà̱ nra nva̱ í təm ka̱ anung ngbət ìzhe kang í ri iya̱m-nrì kúr yi, kang o ɓa ká̱ yi ka̱ ashe ǹzam va̱ ta̱ na nkpaktak mɓut va̱ ta̱ á kú ká̱ ayang.>> ");
INSERT INTO yer_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Te uYawe là ûMusa pa̱, <<Mi ga npə̀ng nzəngkəng a wo ka̱ paɓuɓur, onəm i fa nza̱ ilum nggo kang i wur i kúr oza̱ nda va̱ ta. Ka̱ asa̱l va ta̱ mi mmá oza̱ mwote oza̱ i kpak nnap mpakpak mi ka̱t te i kpak ka̱t nggo. ");
INSERT INTO yer_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ka̱ apal nra ngga nkpa̱ɗing, nva̱ oza̱ i ɗa̱mshi iya̱m va̱ oza̱ i ɓa ká̱ te, i mak i yà nva̱ng pa̱ mparəm wa nva̱ oza̱ mà wur kà̱ oga ilum.>> ");
INSERT INTO yer_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Te uMusa ká̱ uHaruna là ńkpaktak oIsa̱rila pa̱, <<Ká̱ arurong te ó nyi pa̱ uYawe àfa ká̱ wo ka̱ ashe mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ká̱ ìpin te ó ya ìzhàn àYawe ka̱kul uza̱ fe nlwang nnap wo chit ka̱ apal áYawe. Ka̱kul mmayi oda kang o lwang nnap ka̱ apal ishi yi yà?>> ");
INSERT INTO yer_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","UMusa là pa̱, <<UYawe i na ìzhe pa̱ o ri ká̱ arurong ká̱ nzəngkəng ka̱ ìpin pa̱ na ákur wo ka̱kul uYawe fe nlwang nnap va̱ chit o lwang ka̱ apal ishishi. Mmayi oda yà? Nlwang nnap wo ka̱ apal yi ka̱t ka̱ apal áYawe.>> ");
INSERT INTO yer_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Te uMusa là úHaruna pa̱, <<Là ńkpaktak oIsa̱rila pa̱ <O ɓa datkulung ká̱ mpyal àYawe, ka̱kul uza̱ fe nlwang nnap wo chit.> >> ");
INSERT INTO yer_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Nva̱ uHaruna là nnap ká̱ nkpaktak mɓut oIsa̱rila te, oza̱ ga̱ɓa̱n dər ìsu ǹzam, kang oza̱ ya ìzhàn àYawe fa ka̱ ashe ìlulu. ");
INSERT INTO yer_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","UYawe là nnap ká̱ Musa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","<<N fe nlwang nnap oIsa̱rila chit. Là óza̱ pá̱ <Ká̱ anungrurong te ó ri ìzhe, kang ká̱ ìpin te ó ri nzəngkəng i kúr wo. Te ó nyi pa̱ mmami uYawe, Inan wo.> >> ");
INSERT INTO yer_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ká̱ arurong te, írəkpam wong gún apa̱k, kang ká̱ ìpin te ìmimyang ra gáng apa̱k. ");
INSERT INTO yer_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ìmimyang wong ka̱ apal ǹzam ngwomwom te mmá ya iya̱m ro wa nzəngkəng ndátdàt ka̱ apambin. ");
INSERT INTO yer_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Nva̱ngva̱ oIsa̱rila ya te, oza̱ ɓəp owan oza̱ pa̱, <<Iza̱ ta̱ yà?>> Ka̱kul oza̱ nyi iya̱m ata ka̱t. UMusa là óza̱ pa̱ <<Nzənkəng va uYawe na pa̱ o ri. ");
INSERT INTO yer_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Iya̱m va ta̱ uYawe là, <Nza̱ uzəngtəng wo nggo a ɓut á mal ká̱ ǹri wò. Yə́l ikpáng à nza̱ uzəngtəng nggo ka̱ atak ìyə̀l onəm oga ashe aghəghal.> >> ");
INSERT INTO yer_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Te oIsa̱rila nəm wa nnà ta. Oro ɓut pa̱ makmak oro ɓut pa̱ ɗa̱p. ");
INSERT INTO yer_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Nva̱ mmá ka̱ ikpáng iga mmáya̱m te, ka̱ udánggo ɓut kúr anung ǹri oza̱. Onəm va̱ ɓut pa̱ makmak te, á mak ji nkàm oza̱ ka̱t, kang onəm va̱ ɓut pa̱ ɗa̱p te áyen oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","UMusa là óza̱ pa̱, <<Kang unəm uro are ìpin akpa̱k kà̱ ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Te oza̱ gwong achwang kà̱ uMusa ka̱t, oro re aɓuɓo ìpin fa kpa̱k kà̱, kang áru izur anəng. Te ìgwak lak uMusa kà̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Nza̱ ìpin nggo oza̱ ɓut. Ko udánggo ka̱ anung ǹriri, alum sur te ásərak. ");
INSERT INTO yer_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Kà̱ nra ngga nkpa̱ɗing te oza̱ ɓut nzəngkəng ikpáng iga mmáya̱m pa̱ iparəm ka̱kul á nza̱ unəm nggo. Nkpaktak mɓut onəm oga mpyal ga là ûMusa. ");
INSERT INTO yer_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Uza̱ là óza̱ pa̱, <<Iya̱m va ta̱ uYawe là, <Ìpin ìkpa̱kkpà̱k te ilum njul, aSati ayə́ryər ûYawe. Ndata̱ te o wàng iya̱m va̱ o wàng, o pə́k iya̱m va̱ o pə́k, kang aɓo iya̱m va̱ le te o re íshiwo ka̱kul ìpin.> >> ");
INSERT INTO yer_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Oza̱ nak aɓuɓo chu ìpin ìkpa̱kkpa̱k wa nva̱ uMusa là, te anəng ka̱t kang izur yà ka̱ ashishe ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Te uMusa là pa̱ <<O ri aɓuɓo ata ńdata̱, ka̱kul ńdata̱ aSati ûYawe. O ya iya̱m ka̱ ashe ǹzam ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ka̱ ashe nra pa̱ nkpa̱ɗing ó ɓut, kang kà̱ nra ngga ǹfangshat, aSati, iya̱m iro i yà ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ká̱ nna te, kà̱ nra ngga nfangshat onəm oro fa ga pa̱ na o ɓut, kang oza̱ ya iya̱m ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Te uYawe là ûMusa pa̱, <<Igbà̱ng wa nsang o yang ká̱ nkpak nnap mpakpak mi ká̱ oga nɗyang mi yà? ");
INSERT INTO yer_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","O dər, uYawe na ilum aSati a wo chit, ka̱kul nva̱ ta te uza̱ i na nzəngkəngg a wo ka̱kul nra pa̱ mparəm kà̱ nra ngga nkpa̱ɗing. Ko udánggo átəm ka̱ atak va uza̱ kà̱, kang unəm uro áre atak wò kà̱ ilum iga ìfangshat ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Te onəm jul kà̱ ilum iga ifangshat. ");
INSERT INTO yer_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Nzhi àIsa̱rila na aɗin iya̱m va̱ ta pa̱ amá na. Áfa izər ká̱ nzəngkəng kang à chàng na mmá nəm ká̱ izhin iləfər ká̱ mmàl irizhe. ");
INSERT INTO yer_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","UMusa là pa̱, <<Iya̱m va ta̱ uYawe là, <Yə́l ikpáng ká̱ aMana na mmá gor ka̱kul oga nlwàk wo, na oza̱ á ya nzəngkəng va̱ n ri ká̱ wo ká̱ ka̱ ashe ǹzam nva̱ n fa ká̱ wo kà̱ mbin aMasar.> >> ");
INSERT INTO yer_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Te uMusa là ûHaruna pa̱, <<Yar ìɗyeri nak ikpáng amá na pa̱ izəng ka̱ ashishe. Te gor kà̱ mpyal àYawe ka̱kul oga nlwàk wo.>> ");
INSERT INTO yer_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Wa nva uYawe nak uMusa te, uHaruna nak kà̱ mpyal akwati aga nsar nnap-nlà ka̱kul na mmá gòr. ");
INSERT INTO yer_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","OIsa̱rila ri amá na ìzun ìsəm neɗing, har oza̱ ɓa chu mbin va̱ oza̱ i təm kà̱. Oza̱ ri amá na har oza̱ ɓa chu aswari mbin aKanana. ");
INSERT INTO yer_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ikpáng iga mmá iya̱m pa̱ izəng mí wór ká̱ iHiburu pa̱, <<Omer>> nna uzəng ka̱ ashe agba̱pchi ka̱ ashe nkatəp.) ");
INSERT INTO yer_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Nkpaktak mɓut oIsa̱rila re ǹzam aSin, oza̱ nəm achen ka̱ apal nlà àYawe ága ləp apa̱k ka̱ aRefidəm, ka̱ ta te ndəng yà ónəm pa̱ áwá ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Te onəm kyep nnap-nlà úMusa pa̱, <<Na ndəng á yi na í wá.>> UMusa là óza̱ pa̱, <<Sang kang o kyep nnap á mi yà? Sang kang ó mmá uYawe yà?>> ");
INSERT INTO yer_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ndəng gbá̱l onəm ka̱ ta, te ónəm lwang nnap ka̱ apal áMusa, oza̱ là pa̱, <<Sang kang u fa ká̱ yi ka̱ ashe aMasar pa̱ ú gbá̱ng yi ká̱ ovan yi ká̱ iya̱m nkang yi, ká̱ ndəng gbà̱l yà?>> ");
INSERT INTO yer_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Te uMusa yə́ng ûYawe pa̱, <<Iza̱ mi nəm ká̱ onəm va̱ ta̱ yà? I gbà̱ng ka̱t te oza̱ i kwan mi ká̱ ipáng>> ");
INSERT INTO yer_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","UYawe là ûMusa pa̱, <<Watar mpyal ónəm va̱ ta te wur onəmgbak oIsa̱rila oro nzəng ká̱ ɓu. Yar idari va̱ u pàn aNilu ká̱ ka̱ awo na ú ga. ");
INSERT INTO yer_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mi ga nsat ka̱ ta kà̱ mpyal ɓu ka̱ apal ipáng ka̱ aHorep, te ɓu pàn ipáng va̱ ta kang ndəng i fa ka̱ ashishe te onəm i wá.>> Te ûMusa nəm iya̱m va̱ ta kà̱ ìwú onəmgbak oga aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Uza̱ wór atak ata pa̱ aMasak ká̱ aMeriba, ka̱kul oIsa̱rila kyep nnap, kang oza̱ ma uYawe, i là pa̱, <<UYawe uwa yà ka̱ ashe yi ɗò, ka̱t te yà ka̱t?>> ");
INSERT INTO yer_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","OAmalek ɓa ru oIsa̱rila ká̱ ìkum ka̱ aRefidəm. ");
INSERT INTO yer_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","UMusa là uJoshuwa pa̱, <<Yak onunggwan ayi, na o ga o lung oAmalek. Ìpin te mi ga nsat ka̱ apal aɗuktum ká̱ idari Inan ka̱ awo mi.>> ");
INSERT INTO yer_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Te uJoshuwa nəm wa nva uMusa là á na, uza̱ lung oAmalek. UMusa, uHaruna ká̱ uHur nnyi te kyen itəngtəng aɗuktum. ");
INSERT INTO yer_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Nva̱ngva̱ uMusa i gha̱p awo wò ka̱ apal te uIsa̱rila i nəm igwan, nva̱ngva̱ uza̱ i jul awo wò te uAmalek i nəm igwan. ");
INSERT INTO yer_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kà̱ nva̱ngva̱ awo wom uMusa te oza̱ yar ìpang nak á na kang uza̱ təm ka̱ apəpal. Te uHaruna ká̱ uHur tə́p awuwo, uro ká̱ ngba̱k nro kang uro kà̱ nro te awuwo sat pa̱ kwák har alum ga tar. ");
INSERT INTO yer_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Te uJoshuwa ri uAmalek ká̱ onənəm ká̱ ndokchi. ");
INSERT INTO yer_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Te uYawe là ûMusa pa̱, <<Lir iya̱m va̱ ta̱ ka̱ apal awá na átəm iya̱m iga nrəng ká̱, te kung úJoshuwa, ka̱kul mi dəkən nrəng ká̱ oAmalek pa̱ chatchat ka̱vəng apaɓur. ");
INSERT INTO yer_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Te uMusa me atak nshì iya̱m awop kang à wór aɗiɗin pa̱ <UYawe Nissi,> ");
INSERT INTO yer_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","te uza̱ là pa̱, <Gha̱p atani aYawe ka̱ apal.> UYawe i ga nlung oAmalek nlwàk ka̱ apal nlwàk.>> ");
INSERT INTO yer_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","UYeturo unəm uga mpyal awop oga aMidiyan, ugwar aMusa fe nkpaktak iya̱m va̱ Inan nəm úMusa ká̱ onəm wò oIsa̱rila, ká̱ asa̱l va̱ uYawe fa ka̱ oIsa̱rila ka̱ ashe aMasar. ");
INSERT INTO yer_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Nva̱ngva̱ uMusa nak uchar wò uZipora ga te uYeturo ugugwar ka̱m na ");
INSERT INTO yer_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","nzəng ká̱ ovəvan pa̱ oparəm. (Aɗin áyen ugəshi pa̱ uGershom, ka̱kul uza̱ là pa̱, <<Mmami uɗyanəm kà̱ mbin nkak>>, ");
INSERT INTO yer_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Kang aɗin áyen uga uparəm pa̱ uEliyezer, ka̱kul uza̱ là pa̱, <<Inan àpomi ka̱mshi mi chit ka̱ atak ndokchi aFirona>>). ");
INSERT INTO yer_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Te uYeturo nzəng ká̱ uchar aMusa ká̱ ovəvan ɓa atak aMusa ka̱ ashe ǹzam ka̱ atak va̱ uza̱ ləp apa̱k kà̱ ka̱ aɓam Inan. ");
INSERT INTO yer_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Uza̱ nak ǹre ûMusa, <<Mmami uYeturo ugwar ɓu kà̱ mɓa atak ɓu ká̱ uchar ɓu ká̱ ovəvan pa̱ oparəm.>> ");
INSERT INTO yer_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","UMusa fa ga nggwang ugwar wò, te uza̱ vàng ká̱ izər kang uza̱ má ǹjang á na. Oza̱ ɓəp ikángkáng owan oza̱ te táng aghal. ");
INSERT INTO yer_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","UMusa shal úgwar wo ǹchatchat iya̱m va̱ uYawe nəm ûFirona ká̱ oga aMasar ka̱kul oIsa̱rila, ká̱ nkpaktak nɓəknung va̱ ya oza̱ ka̱ asa̱l, ká̱ asa̱l va̱ uYawe fa ká̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","UYeturo lan ka̱kul nkpaktak iya̱m inəna̱n va̱ uYawe nəm oIsa̱rila nva̱ uza̱ fa ká̱ oza̱ ka̱ awo oga aMasar. ");
INSERT INTO yer_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","UYeturo là pa̱, <<Nnap nnəna̱n təm nja aYawe. Uza̱ va fa ká̱ wo ka̱ awo oga aMasar ká̱ awo áFirona, kang àfa ká̱ onəm ka̱ atak ìkam oga aMasar. ");
INSERT INTO yer_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ǹyangmata̱ n nyi chit pa̱ uYawe rup ji nkpaktak ínan ji, ka̱kul ǹva̱ uza̱ fa ká̱ onəm wò ka̱ atak onəm va̱ nəm nkak ishi óza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","UYeturo ugwar aMusa ɓa ká̱ nləfər iya̱m ipápà ká̱ iga nshì pa̱ ɗwot Inan. Te uHaruna ɓa ká̱ nkpaktak onəmgbak oga aIsa̱rila na o ri ìya̱mnrì ká̱ ugwar àMusa ká̱ mpyal Inan. ");
INSERT INTO yer_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ìpin fa kpa̱k te uMusa təm pa̱ na ó kat akwali ónəm, kang onəm tong gáng uMusa áɓàn ká̱ ìpin har arurong. ");
INSERT INTO yer_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kà̱ nva̱ngva̱ ugwar aMusa ya nkpaktak iya̱m va̱ uza̱ kà̱ nnənəm ónəm te, uza̱ là pa̱, <<Ǹza̱ iya̱m ta̱ ɓu nəm ónəm yà? Sang mmaɓu ká̱ nkukwa kà̱ ntəm kang nkpaktak onəm tong gáng ɓu áɓàn ká̱ ìpin har arurong yà?>> ");
INSERT INTO yer_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","UMusa là úgwar wò pa̱, <<Ka̱kul onəm ɓa atak mi pa̱ ń ɓəp Inan. ");
INSERT INTO yer_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","A yà pa̱ oza̱ a yà ká̱ nɗaktak te oza̱ á ɓa atak mi, te mi kat ishimshe anəm ká̱ ùwangwò, kang mi ɗyang nnap nnəm Inan óza̱ ká̱ nɗiɗyang.>> ");
INSERT INTO yer_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ugwar aMusa là á na pa̱, <<Iya̱m va̱ mmaɓu kà̱ nnənəm te aɓyen ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ɓu ɓə́shì, mmaɓu ká̱ onəm va̱ nzəng ká̱ɓu ta̱, ka̱kul iya̱m ata̱ ji nkàm ɓu ji. U kúr nnənəm ká̱ nkukwa ɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Gong achwang kà̱ ìchu mi ǹyangmata̱, mi na ichən a ɓu, te re Inan á yà nzəng ká̱ ɓu. Ɓu yà unəmsa̱l onəm kà̱ mpyal Inan, kang ɓu ga ká̱ oga nɗaktak oza̱ Ínan. ");
INSERT INTO yer_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ɗyáng nnap mpakpakpakpak ká̱ nɗiɗyang ôza̱, kang ɓù nyám ôza̱ asa̱l va̱ oza̱ i təm ká̱ iya̱m va̱ oza̱ i nəm. ");
INSERT INTO yer_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Te yak ka̱ ashe nkpaktak onəm, onəm va kúkúr, oga nnəm ayər Inan, onəm oga nnandər, ova i yà ká̱ ajan nka̱m iya̱m iga mmulam anung. Te kyep ka̱ apal oza̱ onəm ochumchum oga íkalong, onəm ochumchum oga ìgbá̱l, onəm ochumchum oga ìsəm pa̱ ìtukun, onəm ochumchum oga ngba̱pchi ");
INSERT INTO yer_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Oza̱ i kat akwali ónəm nza̱ awalàng nggo. Nkpaktak nnap-nlà nchumchum te oza̱ i ɓa ká̱ a ɓu, kang nkpaktak nnap-nlà nkəla̱pkə̀la̱p te oza̱ á kat ká̱ ishi oza̱. Ná ákəla̱p a ɓu te oza̱ i yar a ɓu kà̱. ");
INSERT INTO yer_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","A yà pa̱ u nəm iya̱m va̱ ta̱ wa nva Inan nak ɓu, te ɓu ya nkám ìgwak kang nkpaktak onəm va̱ ta̱ kpa i ga ǹzhi ká̱ ikángkáng.>> ");
INSERT INTO yer_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","UMusa gwong achwang kà̱ ichu agwar wò kang à nəm nkpaktak iya̱m va̱ uza̱ là. ");
INSERT INTO yer_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Te uMusa yak onəm va kúkúr ka̱ ashe nkpaktak áIsa̱rila kang uza̱ nak oza̱ onəm oga mpyal ka̱ apal onəm, onəm ochumchum oga íkalong, onəm ochumchum oga ìgbá̱l, onəm ochumchum oga ìsəm pa̱ ìtukun, onəm ochumchum oga ngba̱pchi. ");
INSERT INTO yer_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Oza̱ i kat akwali ónəm nza̱ awàlàng nggo, nnap-nlà nɗəkɗək te oza̱ ga ká̱ ka̱ atak áMusa kang nnap-nlà nkəla̱pkə̀la̱p te oza̱ kat. ");
INSERT INTO yer_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Te uMusa re ùgwar wò, te uYetro kpán asa̱l ga mbin wò. ");
INSERT INTO yer_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ka̱ ashe apye aga shatɗing kà̱ nva̱ngva̱ oIsa̱rila re mbin aMasar, ká̱ nda va̱ ta oza̱ táng ǹzam aSinayi. ");
INSERT INTO yer_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Kà̱ nva̱ngva̱ oza̱ re aRefidəm te, oza̱ táng ǹzam aSinayi kang oza̱ ləp apa̱k ka̱ ashe ǹzam, te oIsa̱rila ləp apa̱k ka̱ ta kà̱ mpyal aɓàm. ");
INSERT INTO yer_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","UMusa kyen ɓa ga atak Inan, te uYawe wór na ka̱ ashe aɓàm là pa̱, <<Iya̱m va ta̱ ɓu là ńzhi àYakup, kang ɓu là oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","<O yəya ká̱ ishi wo iya̱m va̱ n nəm oga aMasar, ká̱ asa̱l va̱ n wur wo ká̱ wa nva̱ nkumàngga̱p i wur ovan wò ka̱ apal abasəm kang n ɓa ká̱ ka̱ atak mi. ");
INSERT INTO yer_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ka̱kul nva̱ ta te, a yà pa̱ o gwong achwang kà̱ ìchu mi pa̱ dakdak kang ó kpak nsar nnap nla mi te, o yà iya̱m mi iga anung anì ka̱ ashe nkpaktak onəm, ka̱kul nkpaktak apambin njem. ");
INSERT INTO yer_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Te o yà iponzhi onəm oga nshì iya̱m awop á mi, akum ayə́ryər.> Oga nnap-nlà va ta̱ ɓu là oIsa̱rila.>> ");
INSERT INTO yer_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Te uMusa ga wór onəmgbak onəm, uza̱ là nkpaktak oga nnap-nlà va̱ ta̱ kà̱ mpyal oza̱ wa nva uYawe nak na. ");
INSERT INTO yer_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Te nkpaktak onəm ma̱n ka̱ anung zəngtəng oza̱ là pa̱, <<Nkpaktak iya̱m va̱ uYawe là te í nənəm.>> Te uMusa le ká̱ nnap-nlà onəm uYawe. ");
INSERT INTO yer_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","UYawe là úMusa pa̱, <<Dər, mi ga mɓa atak ɓu ka̱ ashe ìlulu ìɗinɗin, na onəm áfe awalang va̱ mi là nnap ká̱ ɓu te pa̱ ɗəkər oza̱ i na nnandər ká̱ ɓu.>> Ǹva̱ngva̱ uMusa là uYawe nnap-nlà va̱ onəm là, ");
INSERT INTO yer_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","te uYawe là ûMusa pa̱, <<Ga atak onəm na ú gor oza̱ nda ta̱, kang ìpín te oza̱ i nàl ilukwan oza̱, ");
INSERT INTO yer_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","te oza̱ á gbar izər kà̱ nra ngga nshatɗing, ka̱kul kà̱ nra ngga nshatɗing te uYawe i fə́r ka̱ apal aɓam aSinayi kà̱ ìwu nkpaktak onəm. ");
INSERT INTO yer_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Nak aswari á gáng pa̱ kpaktak ka̱kul onəm, là pa̱, <Ó nəm dakdak kang o kyen oga apal aɓam, ka̱t te o dok ìjilìjili ka̱t. Ko udánggo va̱ dòk aɓàm te uza̱ i kú ikúkú. ");
INSERT INTO yer_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Awo i dòk na ka̱t, ka̱ɗor nva̱ ta te mí kwan na ka̱t te mí tat, ka̱ iya̱m nkang ka̱t te unəmləbər i lár ka̱t.> Awalàng va̱ agbəshi ìtam i nap pa̱ gbá̱ngbá̱ng te, oza̱ i kyen i ga akum aɓàm.>> ");
INSERT INTO yer_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Te uMusa fə́r vàng ka̱ apal aɓàm ka̱ atak onəm kang àgor oza̱, te oza̱ nàl ílukwán oza̱. ");
INSERT INTO yer_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Uza̱ là ónəm pa̱, <<Ó gbar izər ka̱kul nra pa̱ nshatɗing, kang o dat ká̱ ochar ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kà̱ nra ngga nshatɗing ka̱ ìpín te ìgbarman lə́p ká̱ amməlám, ká̱ ìlulu iɗəkɗək ka̱ apal aɓàm, ká̱ nnap agbəshi pa̱ gbá̱ngbá̱ng, kang nkpaktak onəm va̱ ka̱ ashe apa̱k tán. ");
INSERT INTO yer_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Te uMusa fa ká̱ onəm ka̱ ashe apa̱k na oza̱ agwang ká̱ Inan, te oza̱ tong ka̱ akum aɓàm. ");
INSERT INTO yer_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","UYawe vàng ka̱ ashe apər ka̱ apal aɓam aSinayi te nggu gún nkpaktak apəpal. Nggugu wong apal wa nggu ngga achər ala acham, te nkpaktak aɓàm tán pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Agbəshi ga mpyal ká̱ nnap pa̱ gbá̱ngbá̱ng te, uMusa là nnap kang Inan ma̱n á na ká̱ ìchu. ");
INSERT INTO yer_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Te uYawe fə́r ka̱ apal aɓam aSinayi, kà̱ ìtəngtəng aɓàm, kang uYawe wór uMusa kà̱ ìtəngtəng aɓàm, te uMusa kyen. ");
INSERT INTO yer_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","UYawe là ûMusa pa̱, <<Fə́r gá na ú won onəm kang oza̱ a pa̱ng aɓa pa̱ o dər uYawe ka̱t, le kang mmákmak oza̱ atàk. ");
INSERT INTO yer_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Onəm oga mpyal awop kpa, oma i ɓa datkulung ká̱ uYawe te, nkpak pa̱ oza̱ ágor ishi oza̱ le kang uza̱ anyám mmən ìkum wò ka̱ apal oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Te uMusa là uYawe pa̱, <<Onəm i yà ká̱ nkyen aɓam aSinayi ka̱t, ka̱kul u won yi pa̱, <Nak aswari ka̱ aɓàm na ú gor na.> >> ");
INSERT INTO yer_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Te uYawe là á na pa̱, <<Fə́r gá na ú kyen ú ɓa ká̱ uHaruna. Kang onəm oga ǹshi iya̱m awop ká̱ onəm a pa̱ng aɓa atak aYawe ka̱t, le kang uza̱ anyám mmən ìkum wò ka̱ apal oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Te uMusa fə́r ga atak onəm là nnap óza̱. ");
INSERT INTO yer_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Te Inan là nkpaktak oga nnap-nlà va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","<<Mmami na uYawe, Inan ɓu va̱ fa ká̱ ɓu ka̱ ashe mbin aMasar, kà̱ nzhi izwal.>> ");
INSERT INTO yer_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","<<Ɓu yà ká̱ ìnan iro watar mi ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","<<Ɓu yà ká̱ nnəm ìchə̀r ìro ka̱kul ishi ɓu, mwote iga nfa izər ká̱ iya̱m iro ka̱ ashe apaɓur ka̱ apal, ka̱t te iva̱ ka̱ apambin ka̱vəng, ka̱t te iva̱ ka̱ ashe ndəng ka̱vəng ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ɓu yà ká̱ nkúchi óza̱ ka̱t, ka̱t te ɓu wop oza̱, ka̱kul mmami uYawe Inan ɓu, mmami Inan iga ìkpar. Mi pyát mpat opon va yang mi ka̱ apal ovan ka̱ okəká, ka̱ okəká oga ntə́mbərə́ng. ");
INSERT INTO yer_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Nnyi te, mi nyám mma̱n ngga nnandər oga nlwàk ìkalong ova̱ ma̱n mi kang kà̱ nkpak nnap mpakpak mi. ");
INSERT INTO yer_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","<<Ɓu yà ká̱ ǹwór aɗin áYawe, Inan ɓu ka̱ anungmwang ka̱t, ka̱kul uYawe i yà ká̱ ǹre nyám ntàn úka̱ udánggo va wór aɗiɗin ka̱ anungmwang ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","<<Rəng ká̱ ilum aSati, gor na. ");
INSERT INTO yer_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ɓu nəm inok ka̱ apal nra pa̱ nkpa̱ɗing te ɓu nəm nkpaktak inok ɓu. ");
INSERT INTO yer_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Nra ngga nfangshat aSati uYawe, Inan ɓu. Nkpak ɓu yà ka̱ nnəm inok iro ka̱t, mmaɓu, uyen ɓu ununggwan, ka̱t te uyenchar, uzwal ɓu ununggwan, ka̱t te uchar, iya̱m nkang ɓu, ka̱t te uɗyanəm va ka̱ anung nkəlang ɓu. ");
INSERT INTO yer_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ka̱kul ka̱ ashe nra pa̱ nkpa̱ɗing uYawe nəm apa ɓuɓur ká̱ apambin, ìwá ká̱ nkpaktak iya̱m va̱ ka̱ ashe oza̱, te uza̱ jul ka̱ apal ilum iga ifangshat. Ka̱kul nva̱ ta te uYawe nak nnap nnəna̱n ílum aSati kang uza̱ gor na yà ìnəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","<<Ná ichumchum úpo ɓu ká̱ unàng ɓu na ú yà ká̱ nra ǹganggang ka̱ apambin va̱ uYawe, Inan ɓu kà̱ nna a ɓu. ");
INSERT INTO yer_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","<<Ɓu yà ká̱ ǹgbá̱l únəm ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","<<Ɓu yà ká̱ nra uchar anəm ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","<<Ɓu yà ká̱ nnəm ayi ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","<<Ɓu yà ká̱ ǹshet nnap ngga akwam ka̱ apal áwan ɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","<<Ɓu yà ká̱ nnəm ìkpar ǹzhi àwanɓu ka̱t. Ɓu yà ká̱ nnəm ìkpar achar àwanɓu ka̱t, ka̱t te úzuzwal ununggwan ka̱t te uchar, ìnəna ka̱t te azhaki, ka̱t te ka̱ iza̱ nggo iva ija áwanɓu.>> ");
INSERT INTO yer_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nkpaktak onəm ya aməlam ká̱ ìgbarman, nnáp agbəshi, kang aɓàm kà̱ ǹdung nggu. Ǹva̱ngva̱ onəm ya te, oza̱ tán kang oza̱ tong ǹdàchi. ");
INSERT INTO yer_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Te oza̱ là ûMusa pa̱, <<Là nnap ayi, te í gwong achwang. Kang wa re Inan á là nnap ayi ka̱t, ka̱t te í kú.>> ");
INSERT INTO yer_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","UMusa là onəm pa̱, <<Kang ayər a nəm wo ka̱t, ka̱kul Inan vàng pa̱ na ô ma wo, na ayəyər á yà ka̱ apal wo ka̱kul na kang o nəm nnap mɓá̱ngɓa̱ng ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Te onəm tong ǹdàchi kang uMusa ga dat ká̱ atak akpá̱rkpà̱r va̱ Inan kà̱. ");
INSERT INTO yer_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Te uYawe là ûMusa pa̱, <<Iya̱m va ta̱ ɓu là oIsa̱rila, <O ya chit ká̱ ishi wo pa̱ n là nnap ká̱ wo ka̱ apaɓur. ");
INSERT INTO yer_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kang o nəm oga inan iga aazurfa a ban ká̱ mi ka̱t, ka̱t te o nəm inan iga azənariya íshi wo ka̱t.> >> ");
INSERT INTO yer_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","<< <Ɓu me atak nshì iya̱m awop á mi aga amyè, te ɓu pà nləfər iya̱m inana ɓu iga nshì pa̱ ɗwot ká̱ iya̱m inana iga ntəm ikángkáng, ítam ɓu ká̱ ína ɓu ka̱ apəpal. Kà̱ nkpaktak atak va̱ n nak pa̱ mmá rəng ká̱ aɗin mi, mi ɓa atak ɓu kang mi nak nnap nnəna̱n a ɓu. ");
INSERT INTO yer_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","A yà pa̱ ɓu me atak nshì iya̱m awop á mi ká̱ ipáng te, kang wa me ká̱ ipáng ikpákpà ka̱t ka̱kul ɓu ga̱ɓa̱n ìɗangsal ka̱ apəpal te, ɓu vyap na. ");
INSERT INTO yer_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kang wa kyen atak nshì iya̱m awop mi ka̱ asa̱l akyenkyen ka̱t, le kang mmá ya imaləng ɓu.> >> ");
INSERT INTO yer_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","<<Oga nnap-akwali va ta̱ ɓu nak kà̱ mpyal oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","<<A yà pa̱ u yáp uzwal uHiburu te, uza̱ i nəm inok ìzun pa̱ ìkpa̱ɗing, kang kà̱ ìzun iga ifangshat te uza̱ i fa unəm ufənfən nzəng ká̱ amwa ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kang a yà pa̱ uza̱ ɓa ká̱ nkukwa te uza̱ i ga ká̱ nkukwa, a yà pa̱ uza̱ ɓa ká̱ uchar te uchəchar i ga nzəng ka̱ na. ");
INSERT INTO yer_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","A yà pa̱ unəm uga ǹzhizhi na uchar á na kang uza̱ mar ovan onunggwan ka̱t te ovan ochar á na te, uchar va̱ ta ká̱ ovan wò i yà oja anəm uga ǹzhizhi, te unəm va̱ ta i ga ká̱ nkukwa. ");
INSERT INTO yer_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Kang a yà pa̱ uzwal va̱ ta là pa̱, <N ma̱n unəm uga nzhi mi ma̱n, ká̱ uchar mi ká̱ ovan mi, n ɗom pa̱ ń ga wa anəm ufənfən ka̱t,> ");
INSERT INTO yer_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","te unəm uga ǹzhizhi i ɓa ká̱ na ka̱ atak Inan. Uza̱ i ɓa ká̱ na ka̱ anung ǹzhi ka̱t te kà̱ ndar ngga mparəm ngga anung ǹzhi kang unəm uga ǹzhizhi i tul achwang á na ká̱ mɓəmɓəm, te uza̱ i nəm inok á na mbyet mbyet. ");
INSERT INTO yer_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","<<A yà pa̱ unəm yáp ká̱ uyen wò uchar yà uzwal te, uza̱ i yà ka̱ nfa wa ozwal onunggwan ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kang a yà pa̱ unəm uga nzhizhi va yak na ka̱kul ishi wò, kang a ɗom na ka̱t te, uza̱ i re mí ka̱m ishishi. Uza̱ yá ka̱ ichumchum iga ǹyàp ka̱ na úɗyanəm ka̱t, ka̱kul uza̱ nəm ka̱ na chit pa̱ vyakshin. ");
INSERT INTO yer_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kang a yà pa̱ uza̱ yak na ka̱kul ayen wò ununggwan te, uza̱ i nəm ka̱ na wa nva̱ nnap nnəm nyám pa̱ mmá nəm ká̱ ovan ochar. ");
INSERT INTO yer_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","A yà pa̱ unəm va̱ ta yar ùkak kà̱ɗi ka̱kul ishi wò te, uza̱ i ya ká̱ nret iya̱m-nrì, ìlukwan ká̱ ngga atak nra kà̱ na ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kang a yà pa̱ uza̱ i nəm iya̱m iga ishatɗing va̱ ta̱ á na ka̱t te, uza̱ i fa amwa aro yà ká̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","<<Nza̱ unəm nggo va̱ lə̀p unəm kú te, nkpak mí gba̱l na. ");
INSERT INTO yer_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kang a yà pa̱ uza̱ nəm ká̱ avyal ka̱t, Inan re pa̱ á yà pa te, mi nak atak ro ka̱kul ɓu ava ɓu chər ɓu ga kà̱. ");
INSERT INTO yer_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","A yà pa̱ unəm gúp uwangwò gba̱l ká̱ ntàn, kang uza̱ a ga a bwam ka̱ atak nshì iya̱m awop mi te, wa fa ka̱ na mmá gba̱l. ");
INSERT INTO yer_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","<<Nza̱ unəm nggo va̱ lə̀p upo wò ka̱t te unàng wò te, mmá gba̱l na. ");
INSERT INTO yer_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","<<Nza̱ unəm nggo va̱ kpán unəm ká̱ ayi, kang à yáp ka̱ na ka̱t te mmá ya ka̱ awuwo te, mmá gba̱l na. ");
INSERT INTO yer_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","<<Nza̱ unəm nggo va̱ vyap upo wò ka̱t te unàng wò te, mmá gba̱l na. ");
INSERT INTO yer_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","<<A yà pa̱ onəm gba̱ng anung kang uro lə̀p uwan wò ká̱ awo ka̱t te ká̱ ìpang, kang unəm uga aɓáng va̱ ta kú ka̱t, a ra kà̱ ìgban, ");
INSERT INTO yer_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kang a yà pa̱ uza̱ wong chen ra nggang ka̱ agbai ka̱ ìdari wò te, unəm va̱ lə̀p na te i fa ka̱ ashe mpat. Uza̱ i mwa nlak awalangwalang ka̱ ǹtətan pa̱ chatchat. ");
INSERT INTO yer_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","<<A yà pa̱ unəm lə̀p uzwal wò ununggwan ka̱t te uchar ká̱ ìdari kang ùzwal va̱ ta kú ka̱ awuwo te, nkpak mí pyát á na. ");
INSERT INTO yer_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Kang a yà pa̱ uza̱ wong kà̱ nra ngga nzəng ka̱t te ngga mparəm te, mí pyát á na ka̱t ka̱kul uza̱ ǹdudur. ");
INSERT INTO yer_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","<<A yà pa̱ onəm ka̱ ashe nlung ìkum, kang uro lə̀p uchar uga anyám te nak na wak, kang aɓang yà ka̱ ka̱t te, mí nak amwa á na iya̱m va uɓar achar va̱ ta ɗom ka̱tətak. Te uza̱ i mwa wa nva akwali nak. ");
INSERT INTO yer_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Kang a yà pa̱ aɓáng yiyà te, ɓu na irirì ka̱ anung irirì, ");
INSERT INTO yer_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ìwu ka̱ anung ìwú, inyin ka̱ anung inyin, awo ka̱ anung awo, ashar ka̱ anung ashar, ");
INSERT INTO yer_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","nshì ka̱ anung nshì, mmətchi ka̱ anung mmətchi, aɓáng ka̱ anung aɓáng. ");
INSERT INTO yer_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","<<A yà pa̱ unəm lə̀p ìwú úzwal wò ununggwan ka̱t te uchar kang a vyap ìwúwu te, uza̱ i re na i fa ka̱kul ìwúwu. ");
INSERT INTO yer_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kang a yà pa̱ uza̱ lə̀p inyin azwal wò ununggwan ka̱t te uchar tutur te, uza̱ i re na i fa ka̱kul inyinyin. ");
INSERT INTO yer_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","<<A yà pa̱ ìna ta̱p ununggwan ka̱t te uchar kú te, nkpak mí kwan ìna va̱ ta ká̱ ipáng kang izhizhe mí ri ka̱t, te unəm uga ìna i fa ka̱ ashe mpat. ");
INSERT INTO yer_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Kang a yà pa̱ ìna va̱ ta iga ǹtá̱p onəm kang mma won unənəm, káp ká̱ nna uza̱ pángchí ka̱t kang à gba̱l unəm ka̱t te uchar, te mí kwan ìna va̱ ta ka̱ ipáng kang mí gba̱l unənəm kpa. ");
INSERT INTO yer_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","A yà pa̱ mmá nak amwa á na te, uza̱ i mwa ka̱ anung irirì wò pa̱ chur wa ǹva mmá nak á na. ");
INSERT INTO yer_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ka̱ te a yà pa̱ ta̱p uyennunggwan ka̱t te uyenchar, te mí nəm ka̱ na ka̱ apal akwali azəngtəng va ta̱. ");
INSERT INTO yer_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kang a yà pa̱ ìna ta̱p uzwal ununggwan ka̱t te uchar te, uza̱ i na ashekel ìsəm pa̱ ishatɗing aga azənariya unəm uga nzhizhi kang ìna va̱ ta mí kwan ká̱ ipáng. ");
INSERT INTO yer_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","<<A yà pa̱ unəm bòl ache ka̱t te ɓok ache kang à gún ka̱t, te ìna ka̱t te azhaki ru ka̱ ashishe, ");
INSERT INTO yer_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","te unəm uga ache va̱ ta i mwa akəkat, uza̱ i mwa mbubwai ûnənəm kang iya̱m nkang ikukù i yà ijini. ");
INSERT INTO yer_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","<<A yà pa̱ ìna anəm uro nak aɓá̱ng ìna awang wò kang à kú te, oza̱ i yáp ká̱ ìna irirì te oza̱ i kap mbubwai, kang oza̱ i kap ìna ikukù kpa. ");
INSERT INTO yer_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Kang a yà pa̱ mmá nyi ìna va̱ ta nyi ká̱ ntá̱p atak kang ùnənəm pángchí ka̱t, te uza̱ i mwa akəkat pa̱ chur, ìna ka̱ anung ìna kang ikukù i yà ijini.>> ");
INSERT INTO yer_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","<<A yà pa̱ unəm nəm ayi ìna ka̱t te ìtam kang à pà ka̱t te á yáp ká̱ te, uza̱ i mwa ína pa̱ ítukun ka̱ anung ìna, kang ítam pa̱ íneɗing ka̱ anung ìtam. ");
INSERT INTO yer_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kang a yà pa̱ mmá kpán uyi kà̱ nchwan atak kang mmá nə́m na mmá gba̱l te, mí mwo nchəchər ka̱ awo anəm uro ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","A yà pa̱ mmá gba̱l na atak tàn chit te, mpat ǹtar nchə̀r nna yà. A yà pa̱ mmá kpán uyi va̱ ta te, uza̱ i mwa amumwa pa̱ chur, kang a yà pa̱ uza̱ yà ká̱ iya̱m iro ka̱t te, mí yáp ka̱ na ka̱kul ayiyi. ");
INSERT INTO yer_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","A yà pa̱ mmá ya iya̱m ayiyi ka̱ awuwo ka̱ irirì, mwote ìna ka̱t te azhaki ka̱t te ìtam te, uza̱ i mwa ndán pa̱ mparəm.>> ");
INSERT INTO yer_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","<<A yà pa̱ unəm kpak iya̱m nkang wò ka̱ ashe ìram ka̱t te iram ìba̱ngba̱ng, kang uza̱ re iya̱m nkang va̱ ta ga ashe iram anəm uro te, uza̱ i mwa amumwa ká̱ iya̱m inəna̱n iva ji iga ìrəram ka̱t te iga ìram ìba̱ngba̱ng ba̱ngba̱ng. ");
INSERT INTO yer_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","<<A yà pa̱ apər fa rap ka̱ ashe ǹzam, te ri ikur iɓənɓən ká̱ itóngtong, ka̱t te ashe ìram, te unəm va̱ pá apər va̱ ta i mwa amumwa. ");
INSERT INTO yer_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","<<A yà pa̱ unəm na mbwai ka̱t te iya̱m inok ûwan wò pa̱ á nak, te mmá nəm ayiyi ká̱ nzhi anəm va̱ ta, kang a yà pa̱ mmá kpán uyi va̱ ta te, uza̱ i mwa ndán pa̱ mparəm. ");
INSERT INTO yer_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","A yà pa̱ mmá kpán uyi va̱ ta ka̱t, te mí ɓa ká̱ unəm uga nzhi va̱ ta ka̱ atak Inan na mmá dər a yà pa̱ uza̱ uwa wur iya̱m awang wò ka̱t nggo. ");
INSERT INTO yer_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","A yà pa̱ ndap atam wong ka̱ apal nnap ìna, azhaki, ìtam, ìlukwan, ka̱t te iya̱m iro ilárlar iva̱ unəm uro là pa̱, <Ijəm ta̱,> te nnap-nlà nkpaktak oza̱ iga atak Inan. Unəm va̱ Inan i nak mpat á na te uza̱ i mwa ûwan wò ndán pa̱ mparəm. ");
INSERT INTO yer_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","<<A yà pa̱ unəm na azhaki, ka̱t te ìna, ka̱t te ìtam, ka̱t te nza̱ iya̱m nkang nggo ûwan wò pa̱ á nak ishi ká̱, kang à kú, ka̱t te ka̱m aɓang, ka̱t te mmá kpán ka̱ ayi unəm uro ya ka̱t, ");
INSERT INTO yer_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","te nsóng anung ká̱ uYawe i va̱n ishimshe mparəm oza̱, na a nyám pa̱ uza̱ dok iya̱m awang wò ka̱t. Te unəm uga iya̱m va̱ ta i ma̱n ká̱ kang uza̱ i mwa akəkat ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Kang a yà pa̱ nnandər mmá kpán iya̱m nkang va̱ ta ká̱ ayi ka̱ awuwo, te uza̱ i mwa akəkat ûnənəm. ");
INSERT INTO yer_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","A yà pa̱ izhé iga anyin à kan te, uza̱ i ɓa ká̱ aɓuɓo na a nyám nnandərnandər, te uza̱ i yà ká̱ mmwa akəkat ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","<<A yà pa̱ unəm ka̱m iya̱m nkang ka̱ atak áwan wò kang à ka̱m aɓáng ka̱t te á kú ká̱ na ûnənəm yà ka̱ ta ka̱t, te uza̱ i mwa akəkat pa̱ chur. ");
INSERT INTO yer_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Kang a yà pa̱ ùnənəm nzəng ká̱ na te uza̱ i mwa akəkat ka̱t. A yà pa̱ mmá ka̱m ka̱kul mbwai te mbwai va̱ mmá mwa te i təm ka̱ anunung.>> ");
INSERT INTO yer_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","<<A yà pa̱ unəm tàng uyen ɓyen va̱ uwa nyi ununggwan chit ka̱t, ùva̱ unəm uro kà̱ nnəm ngya ká̱ ka̱t, kang à ra ka̱ na te uza̱ i mwa ndudur íshi wò i yà uchəchar. ");
INSERT INTO yer_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Kang a yà pa̱ upupo yang pa̱ kyàk ká̱ nna á na te, uza̱ i mwa ká̱ mbwai i mal dakdak ká̱ ìdur ayenɓyen ùva̱ nyi ununggwan chit ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","<<Kang wa re uchar uga ishe á lár ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","<<Unəm va̱ ra ká̱ iya̱m nkang te nkpak mí gba̱l na. ");
INSERT INTO yer_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","<<Unəm va̱ na nləfər iya̱m pápà inan iro te mí zhì na, ya uYawe chwat. ");
INSERT INTO yer_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","<<Kang wa mwar ka̱t te wa ka̱r uɗyanəm ka̱t, ka̱kul ka̱ o yà oɗyanəm kà̱ mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","<<Kang o ɓək anung uchar ùkpələng ka̱t te uyen ùkpələng ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","A yà pa̱ wa ɓək anung á na kang uza̱ yə́ng a mi te, nnandər mi fe ayiyə́ng aga mɓək anung, ");
INSERT INTO yer_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","kang a shì ìgwak a mi te, mi gbá̱ng wo ká̱ ndokchi te ochar wo i yà okpələng kang ovan wo i yà okpələng. ");
INSERT INTO yer_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","<<A yà pa̱ u na akat mbwai ónəm mi oga nkùn ka̱ ashe wo te, kang wa ram mmákmak kà̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kang a yà pa̱ u ka̱m ìlukwan àwan ɓu ka̱ apal pa̱ uza̱ i mwa kang te, le ká̱ á na kang alum ì tar, ");
INSERT INTO yer_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ka̱kul ìlukwan iga ndàng izəzər yà ta byet, te uza̱ i ra ka̱ ashe iza̱ yà? Kang a yà pa̱ uza̱ yə́ng á mi te mi fe, ka̱kul mmami uga aɗor. ");
INSERT INTO yer_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","<<Kang wa pwat Inan ka̱t te wa vyap aɗin ánəm uga mpyal ka̱ ashe onəm ɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Kang wa kali ká̱ iya̱mmɓən ká̱ ndəng ìba̱ngba̱ng ǹsámsàm ka̱t. Na ovan onunggwan ɓu oga nggəshi á mi. ");
INSERT INTO yer_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Wa nəm iya̱m izəngtəng ká̱ ina, itam ká̱ iɓəl ɓu. Oza̱ i nəm nra pa̱ nfangshat nzəng ká̱ ínang oza̱, kang kà̱ nra ngga nna̱nne te, wá na oza̱ á mi. ");
INSERT INTO yer_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Ó yà onəm ogorgor mi. Kang ô ri izhé iya̱m nkang va̱ izhé iga anyin kan ka̱t, o swang íva.>> ");
INSERT INTO yer_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","<<Kang wa zàl nnap-nlà ngga akwam ka̱t. Kang wa gwang awo ká̱ unəm unga, wa shet akwam ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Kang wa yar nva̱ng nggatək ka̱ ashe nnəm iya̱m inga ka̱t. Kang wa náp akwam ka̱ atak akwali ká̱ ngga̱ɓa̱n asəm ǹyàr nva̱ng nggatək pa̱ ávyap nnandər ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kang wa nyám nɗom ishi únəm uga nkun ka̱ ashe akwalikwali ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","<<A yà pa̱ u ya ìna ka̱t te azhaki ákpa ìkum ɓu lar te, wa le ká̱ á na. ");
INSERT INTO yer_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","A yà pa̱ u ya azhaki ánəm uga ńyang ɓu ru ká̱ iya̱m iɗəkɗək kang u ɗom nnəm nka̱mshi ka̱t, te nkpak pa̱ ú ka̱m ishishi a wong ká̱. ");
INSERT INTO yer_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","<<Kang wa ga̱ɓa̱n nnandər onəm ɓu oga nkun ka̱ ashe akwali oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Wa gbà̱ng ká̱ nnap-nlà ngga akwam. Kang wa gbá̱l unəm uga ǹnyi nnap anəm nro ka̱t, ká̱ unəm ùnəna̱n ka̱t, ka̱kul mi yà ká̱ nlà pa̱ unəm unga unəna̱n ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Kang wa ka̱m imwa iga ǹmulam anung ka̱t, ka̱kul imwa iga ǹmulam anung i fo iwu onəm kang i vyap nnap-nlà onəm onəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Kang wa ka̱r uɗyanəm ka̱t, o nyi ntəm aɗyanəm nyi ka̱kul mmawó ká̱ ishi wo te, ka̱ o yà oɗyanəm ka̱ ashe mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ɓu suk ìram ɓu ìzun pa̱ ìkpa̱ɗing te ɓu ɓən iyəya̱m. ");
INSERT INTO yer_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Kang ka̱ ashe ìzun iga ifangshat te ɓu re i ra afəp, na onəm oga nkun ɓu á ri ka̱ ashishe kang ízhe iga anyin i ri aɓuɓo va̱ oza̱ re, wa nəm iya̱m izəngtəng ka̱ iram ìba̱ngba̱ng ɓu ka̱ iram mpyet ɓu. ");
INSERT INTO yer_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Ka̱ apal nra pa̱ nkpa̱ɗing ɓu nəm inok ɓu, te ɓu jul kà̱ nra ngga nfangshat na ìna ɓu ká̱ azhaki ɓu á yì, kang uya azwal ɓu uchar nzəng ká̱ uɗyanəm á yì. ");
INSERT INTO yer_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Wá nak ishi ká̱ nkpaktak iya̱m va̱ n là a wo. Kang o wór aɗin inan iro ka̱t, kang mmá fe aɗin oza̱ ka̱ anung ɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","<<Nva̱ng pa̱ nshatɗing ka̱ ashe ìzun te, ɓu nəm nchang izər á mi. ");
INSERT INTO yer_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Wa kpak nchang izər nzəngkəng ngga ǹyà ká̱ anyer ka̱t wa nva n nak a ɓu. Wa ri nzəngkəng ngga ǹyà ká̱ anyer ka̱t, nra pa̱ nfangshat ká̱ awalang va mmá nak ka̱ ashe apye aga aAbip, o fa ka̱ ashe mbin aMasar ka̱ ashe apye va ta. Kang oza̱ a ɓa mpyal mi ká̱ awo alakchi ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Nəm nchang izər ngga mɓən iya̱m iga nggəshi ɓu va u suk ka̱ ashe iram. Nəm nchang izər ngga ngwur ikur kà̱ nkùr ìzun ká̱ awalang va̱ u ɓut iya̱m ngwap ɓu ka̱ ashe iram. ");
INSERT INTO yer_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Nva̱ng pa̱ nshatɗing ka̱ ashe ìzun, nkpaktak ovan onunggwan ɓu i ɓa mpyal aPoǹzhinan uYawe.>> ");
INSERT INTO yer_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","<<Wa yichi nchə̀r nləfər iya̱m pápà a mi ká̱ iya̱m iro iga anyer ka̱t. Kang mpip nləfər iya̱m pápà iga nnəm nchang izər mi á kpa̱k ìpin ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","<<Ɓa ká̱ oga awar ikún aga nggəshi va ɓyen ji aga ashe ìram ɓu ka̱ ashe ǹzhi aYawe, Inan ɓu. Kang wa pə́k ìya ìtam ka̱ ashe mbyal ìnənang ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","<<Dər, mmami ká̱ ngga nre ǹre ká̱ uma̱leka kà̱ mpyal ɓu na apángchí ɓu ka̱ apal asa̱l kang ì ɓa ká̱ ɓu ka̱ atak va̱ n ɗa̱mshi chit. ");
INSERT INTO yer_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Nak ishi ka̱ na kang ɓu gwong achwang ká̱ ichəchu. Kang wa fa iya̱m ika̱k ká̱ na ka̱t, ka̱kul uza̱ i yà ká̱ ǹyàr mpat ɓu ka̱t, ka̱kul aɗin mi nna ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","A yà pa̱ u kpak nnap nləlà pa̱ dakdak kang u nəm nkpaktak iya̱m va̱ n là te, mi yà unəm ìkum okpa ìkum ɓu kang mi yang onəm va̱ yang ɓu. ");
INSERT INTO yer_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Nva̱ngva̱ uma̱leka mí lə́p mpyal a ɓu i ɓa ka̱ ɓu ka̱ ashe oAmori, ká̱ oHiti, ká̱ oPerizi, ká̱ oKanana, ká̱ oHivi, ká̱ oYebusi, te mi zhì oza̱. ");
INSERT INTO yer_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Kang wa kuchi ínan oza̱, ka̱t te wa wop oza̱, ka̱t te wa ɗyang nnap nnəm oza̱ ka̱t. Ka̱ɗor nva̱ ta te wa kan oza̱ kang ɓu chwan oga ǹdáng ipáng oza̱ nyə́ryər pa̱ nyimənnyimən. ");
INSERT INTO yer_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","O wop uYawe Inan wo, kang uza̱ i nak nnap nnəna̱n íya̱m nrì wo ká̱ ndəng wo, kang i yar arwa i le ka̱ ashe wo. ");
INSERT INTO yer_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Uchar ro i wak ka̱t, kang i yà usatsat ka̱ ashe mbin wo ka̱t. Mi na nra ngá nggang a ɓu. ");
INSERT INTO yer_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","<<Mi ga kà̱ mpyal ɓu na nnak okpa ìkum ɓu á nəm ayər ɓu. Mi ɓa ká̱ nzwar onəm va̱ ɓu lung oza̱, kang mi nak oza̱ i ga̱ɓa̱n asəm i chəng ɓu. ");
INSERT INTO yer_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mi re ǹre ká̱ iya̱m iga nzwar atak kà̱ mpyal ɓu i ɓàk oHivi, ká̱ oKanana, ká̱ oHiti kà̱ mpyal ɓu. ");
INSERT INTO yer_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mi yà ká̱ mɓəɓak ká̱ mpyal ɓu pa̱ kpaktak ka̱ ashe ìzun pa̱ izəng ka̱t, ka̱t te mbin va̱ ta i yà ashe anyin te ízhe iga anyin i yə́l ka̱ ashishe i ji ɓu. ");
INSERT INTO yer_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mi ɓàk oza̱ kà̱ mpyal ɓu pa̱ ɗa̱pɗa̱p, ɓu yə́l ɓu gang mbin va̱ ta kang. ");
INSERT INTO yer_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mi nak aswari ɓu i ɓàn kà̱ Ìwá Ìsəksək i ga i chu ìwa iga aFilitti kang i ɓàn kà̱ ǹzam aSinayi i ga i chu awang aYufəriti. Te mi na onəm oga ashe mbin va̱ ta ka̱ awo ɓu, kang ɓu ɓàk oza̱ i fa kà̱ mpyal ɓu. ");
INSERT INTO yer_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Kang wa yar nsar nnap-nlà ká̱ oza̱ ka̱t te oga ichər oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kang oza̱ atəm nzəng ká̱ ɓu ka̱t, le kang oza̱ á nak ɓu wa nəm nnap mɓá̱ngɓa̱ng á mi, ka̱kul a yà pa̱ u wop ichər oza̱ te, i sat ajəp a ɓu.>> ");
INSERT INTO yer_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Te uza̱ là ûMusa pa̱, <<Kyen ɓa atak mi, mmaɓu ká̱ uHaruna, ká̱ uNadap, ká̱ uAbihu, ká̱ onəmgbak oIsa̱rila va̱ ìsəm pa̱ ifangshat, o nəm awop ǹdatchi. ");
INSERT INTO yer_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","UMusa uwa chwat á ɓa adatkulung ká̱ uYawe, kang oza̱ á ɓa adatkulung ka̱t, kang onəm á kyen á ga nzəng ka̱ na ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","UMusa ga là ónəm nkpaktak nnap-nlà àYawe ká̱ oga nkpaktak nnap-akwali, te nkpaktak onəm ma̱n ká̱ ìchu pa̱ izəng pa̱, <<Nkpaktak nnap-nlà va̱ uYawe là te í nənəm.>> ");
INSERT INTO yer_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Te uMusa lir nkpaktak oga nnap-nlà àYawe. Uza̱ wong ká̱ iɓotak kà̱ ìpin ikpa̱kkpà̱k kang uza̱ me atak nshì iya̱m awop ka̱ akum aɓàm, te nak ǹdáng ipáng pa̱ igba̱pchi ama̱n pa̱ pa̱rəm ka̱ anung akum oIsa̱rila aga agba̱pchi ama̱n pa̱ aparəm. ");
INSERT INTO yer_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Te uza̱ re ovan ǹza̱m oga aIsa̱rila, oza̱ yichi oga iya̱m inana iga nshì pa̱ ɗwot kang oza̱ na nləfər iya̱m ipápà oga akut iga ntəm ikángkáng uYawe. ");
INSERT INTO yer_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Te uMusa tok nchə̀r ka̱ ashe asu, kang aɓo nchə̀r nro te uza̱ sháng ka̱ izər atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Te uza̱ yar ǹlir ngga nsar nnap-nlà, uza̱ kung ónəm fe. Te oza̱ ma̱n pa̱, <<Nkpaktak iya̱m va̱ uYawe là te í nənəm kang í kpəkpak.>> ");
INSERT INTO yer_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","UMusa yar nchə̀r sháng ka̱ apal onəm, uza̱ là pa̱, <<Dər, nchə̀r ngga nsar nnap-nlà va ta̱ uYawe nəm ká̱ wo ka̱ apal nkpaktak oga nnap-nlà va̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Te uMusa kyen gà ká̱ uHaruna, ká̱ uNadap, ká̱ uAbihu, ká̱ onəmgbak oIsa̱rila oga ìsəm pa̱ ifangshat va̱, ");
INSERT INTO yer_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","te oza̱ ya Inan oIsa̱rila. Ka̱ avəng ashishar te iya̱m iro wa abərki nnəm ngga ipáng iɓyenɓyen iga ndəng izər ìvyau, wa atak ghanghan agbagba apaɓur. ");
INSERT INTO yer_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Inan nak awo wò ka̱ apal onəm ochumchum oga aIsa̱rila va̱ ta̱ ka̱t. Oza̱ ya Inan kang oza̱ ri oza̱ wa. ");
INSERT INTO yer_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","UYawe là ûMusa pa̱, <<Kyen atak mi ka̱ apal aɓam na ú ta̱l ka̱ ta, ka̱kul na ń na oga achuchwal ìpang a ɓu, va n lir oga nɗyang ká̱ nnap mpakpak na ú ɗyang óza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Te uMusa wong ká̱ unəm uga nka̱mshi wò uJoshuwa, te uMusa kyen apal aɓam Inan. ");
INSERT INTO yer_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Uza̱ là ónəmgbak pa̱, <<O lòk yi ka̱ ta̱ kang i le atak wo. UHaruna ká̱ uHur oma yà nzəng ká̱ wo. Nkpaktak onəm va̱ ká̱ ǹdap atam te á ga atak oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","UMusa kyen apal aɓam kang ìlulu gún aɓàm. ");
INSERT INTO yer_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ìzhàn àYawe təm ka̱ apal aɓam aSinayi, kang ìlulu gún na nra pa̱ nkpa̱ɗing. Ka̱ apal nra ngga nfangshat te, uza̱ wór uMusa ka̱ ashe ìlulu. ");
INSERT INTO yer_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ìzhàn àYawe wa apər i ri ka̱ apal itə́ngtə́ng aɓam kà̱ ìwu oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","UMusa tar ashe ìlulu, kyen apal aɓam. UMusa təm ka̱ apal aɓàm nra ìsəm pa̱ ineɗing ká̱ ìzwam ìsəm pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Te uYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","<<Là ónəm oIsa̱rila pa̱ á ɓa ka̱ iya̱m inana á mi. Nza̱ unəm nggo va̱ á yiyar ka̱ ashe ìgwak pa̱ o nəna te, uza̱ á ɓa ká̱ iya̱m inana wò. ");
INSERT INTO yer_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Oga iya̱m inana va ta̱ ɓu ka̱m ka̱ atak oza̱. Oma azənariya, aazurfa, ká̱ acham arəzang, ");
INSERT INTO yer_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ká̱ awulu va wa izər ìvyau, awulu va wa mba̱l akətəkəu arə́zang pa̱ ga̱r, ká̱ alinin va alukutlukut anəna̱n, ká̱ akpap iɓəl ka̱kul ìlukwan, ");
INSERT INTO yer_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","awá inagám va mmá ɓán ká̱ ǹzazí ká̱ awa izhé iro anəna̱n, ká̱ akun akasiya, ");
INSERT INTO yer_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ká̱ mmì ka̱kul apitila, ká̱ oga iya̱m inə́ngnəng ichángchàng ka̱kul mmì ngga nggar kang ka̱kul iya̱m inəngnəng ichángchàng kpa. ");
INSERT INTO yer_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Ká̱ ipáng iza̱mza̱m, ipáng iga mɓam kà̱ izər ìya ìlukwan ìkwoksok, ká̱ ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","<<N ɗom oza̱ pa̱ á me Atak Ayə́ryər á mi na ń təm nzəng ká̱ oza̱ ");
INSERT INTO yer_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Nkpak pa̱ ú nəm aghal áYawe va̱ ta̱ ká̱ nkpaktak iya̱m iga ashishe á yà pa̱ dakdak á mal ká̱ ala̱ka̱n ava̱ mi gà ǹnyinyám a wo.>> ");
INSERT INTO yer_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","<<Oza̱ á nəm akwati ká̱ akun akasiya ava ngwuwang ashar pa̱ shatɗing ká̱ aɓuɓo, mbəbal ashar pa̱ parəm ká̱ aɓuɓo, nrurup ashar pa̱ parəm ká̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Wa ɓam nsəsəm ká̱ ashishe ká̱ azənariya anəna̱n wa rà̱p nza̱m ká̱ azənariya kà̱ nza̱ aranchwang nggo. ");
INSERT INTO yer_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Wa lá nkalɓang azənariya pa̱ nneɗing á gwang ka̱ ashishar kà̱ nza̱ ngba̱k nggo nkalɓang pa̱ mparəm. ");
INSERT INTO yer_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Nəm oga nkpá nggang ngga akun akasiya ɓəl izər oza̱ ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Mwak oga nkpá nggang va̱ ta ka̱ ashe nkalɓang va̱ nna ká̱ nza̱ ngba̱k akwati nggo ka̱kul nyiyar ");
INSERT INTO yer_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Oga nkpá nggang ngga nyiyar va̱ ta mí zə̀p ka̱t, mí re ká̱ izər nkalbang. ");
INSERT INTO yer_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Wa nak achuchwal nnap nshetshet nlìlir nva mi ga nnəna a ɓu ka̱ ashe akwati va̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Te wa nəm anung aga nkuk akwati va̱ ta ká̱ azənariya anəna̱n, ngwuwang ashar pa̱ shatɗing ká̱ aɓuɓo, mbə́bal ashar pa̱ parəm ká̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Wa lá oga akerup pa̱ parəm ká̱ azənariya, wá nak ka̱ apal anung aga nkukuk. ");
INSERT INTO yer_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Nəm akerup pa̱ zəng kà̱ ngba̱k nro kang aro kà̱ ngba̱k nzəntəng. Nəm oga akerup ka̱ anung aga nkukuk ká̱ azənariya azəngtəng va ta kà̱ nkùr oga aranchwangranchwang aga aparəm. ");
INSERT INTO yer_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Oga akerup va̱ ta i bol abasəm oza̱ i gún anung aga nkukuk, kang ì dər owan oza̱. Asa̱l awu oga akerup va̱ ta i dər anung aga nkukuk. ");
INSERT INTO yer_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Nak anung aga nkukuk va̱ ta ka̱ apal akwati, kang ɓù nak nnap nshetshet nva̱ mi ga nnəna a ɓu ka̱ ashe akwati va̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ka̱ atak va ta mi gwang ká̱ ɓu, mi là nnáp ká̱ ɓu, ká̱ ishimshe oga akerup aga aparəm va̱ ka̱ anung aga nkuk akwati nnap nshetshet. Mi na oga nnap mpakpak a ɓu ka̱kul onəm oga aIsa̱rila.>> ");
INSERT INTO yer_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","<<Te wa pak atebəl ká̱ akun akasiya ngwuwang ashar pa̱ shatɗing, mbəbal ashar pa̱ zəng ká̱ aɓuɓo, kang nrurup ashar pa̱ parəm ká̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ɓam ká̱ azənariya anəna̱n, kang ɓu rà̱p nza̱m oga aranchwangranchwang ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Nak ìɗər ka̱ aranchwangranchwang á yà wa mbal awo á gang, kang ɓu rà̱p nza̱m ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Nəm oga nkalɓang azənariya á na pa̱ nneɗing, na ú ɓáp oga nkalɓang va̱ ta kà̱ isu oga nggúlyanggú ngga neɗing va̱ ta ka̱ atak ashishar. ");
INSERT INTO yer_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Oga nkalɓang ngga nkpán nkpá nggang ngga ǹyàr atebəl va̱ ta á dat ká̱ ìɗər. ");
INSERT INTO yer_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Nəm oga nkpá nggang ká̱ akun akasiyá na ú ɓam izər oza̱ ká̱ azənariya. Te mí yar atebəl va̱ ta ká̱ omà. ");
INSERT INTO yer_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Nəm oga adakdai, ká̱ asu, ká̱ oga ibəchi, ka̱kul nna iya̱m inana iga ngwa. Nəm ká̱ azənariya anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Nak nzəngkəng àYawe ka̱ apal atebəl kà̱ mpyal mi pa̱ ɗəkər.>> ");
INSERT INTO yer_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","<<Nəm apitila aga idari ká̱ azənariya anəna̱n. La ìjilijili ká̱ idaridari, ká̱ oga ásusu, ká̱ mɓənggúmɓənggúm, ká̱ mbəba̱l á yà iya̱m pa̱ izəng. ");
INSERT INTO yer_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Oga igwong pa̱ ìkpa̱ɗing i yà kà̱ oga ngba̱k apitila aga ìdari pa̱ ishatɗing kà̱ ngba̱k nro, kang pa̱ ishatɗing kà̱ ngba̱k nzəngtəng. ");
INSERT INTO yer_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Oga asu pa̱ shatɗing wa mɓənggúm mba̱l i yà ka̱ apal ìgwong pa̱ ìzəng, pa̱ shatɗing kà̱ ìgwong ìro, wa nnà ta i yà kà̱ nkpaktak oga igwong iga ìkpa̱ɗing ka̱ igwong izər apitila aga idari. ");
INSERT INTO yer_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Oga asu pa̱ neɗing wa mɓənggum mba̱l ká̱ mba̱l i yà ka̱ apal apitila aga idari. ");
INSERT INTO yer_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Te mɓənggúm mba̱l á yà pa̱ zəng ka̱ akum ígwong pa̱ iparəm iga nggəshi, mɓənggúm mba̱l á yà pa̱ nzəng ka̱ akum ígwong pa̱ iparəm iga ipəpar, kang mbəngúm mba̱l ì yà pa̱ nzəng ka̱ akum ígwong pa̱ iparəm iga ishəshat, ka̱kul oga ígwong iga ìkpa̱ɗing va̱ ka̱ izər apitila aga ìdari. ");
INSERT INTO yer_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Oga mɓənggúm oza̱ ká̱ ígwong oza̱ á yà iya̱m pa̱ izəng. Nkpaktakkpaktak nlá azənariya anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Nəm apitila pa̱ fangshat, te chwong oza̱ ka̱ apəpal na aghan atak kà̱ mpipyal. ");
INSERT INTO yer_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Te mɓəmɓəmɓəmɓəm ká̱ asu apər á yà ká̱ azənariya anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Nəm apitila aga idari ká̱ nkpaktak oga iya̱m inok va̱ ta̱ ká̱ azənariya anəna̱n ava iɗəɗək ìsəm pa̱ ishatɗing. ");
INSERT INTO yer_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Nak ishi ká̱, na u nəm oza̱ á yà pa̱ dakdak á mal ká̱ ala̱ka̱n wa nva mmá nyám a ɓu ka̱ apal aɓam.>> ");
INSERT INTO yer_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","<<Nəm aghal aYawe ká̱ atani pa̱ gba̱pchi ava mmá lok ká̱ alinin anəna̱n, aga ndəng izər ìvyau, ká̱ ndəng nrəzang pa̱ gà̱r, ká̱ ndəng nrəzang. Nəm oza̱ á yà ká̱ ala̱ka̱n oga akerup ka̱ atak aghan anəm uga inok. ");
INSERT INTO yer_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Nwang atani va̱ ta á yà ashar ìsəm pa̱ ineɗing ama̱n pa̱ parəm, mbəbal ashar pa̱ kpa̱ɗing. Nkpaktak oga atani va̱ ta á mal izər. ");
INSERT INTO yer_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Gwang oga atani pa̱ tukun á yà pa̱ zəng, te gwang aɓo aga tukun á yà pa̱ zəng. ");
INSERT INTO yer_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Nəm oga mɓol ká̱ afini ndəng izər ivyau kà̱ nkur arangchwang aga ǹggəshi oga atani va̱ ta. Wa nnà ta kpa nəm oga mɓol kà̱ nkur azəngtəng arangchwang atani. ");
INSERT INTO yer_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Nəm oga mɓol ìsəm pa̱ ìtukun ka̱ izər atani azəngtəng, kang ɓù nəm oga mɓol ìsəm pa̱ ìtukun kà̱ nkùr aranchwang atani azəngtəng. Oga mɓol va̱ ta á mal ikwoksok ká̱ owan oza̱. ");
INSERT INTO yer_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Nəm oga iya̱m iga nzùzong ìsəm pa̱ ìtukun ká̱ azənariya, te gwang oga atani aga aparəm va̱ ta ka̱ anung zəngtəng ka̱ atak nzùzong, na aghal aYawe á yà pa̱ zəng. ");
INSERT INTO yer_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","<<Kà̱p atani pa̱ gba̱pchi ama̱n pa̱ zəng ká̱ akpap íɓəl ka̱kul nkuk aghal aYawe. ");
INSERT INTO yer_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Nwang nza̱ atani nggo á yà ashar ìsəm pa̱ ineɗing ama̱n pa tuka̱n kang mbəbal ashar pa̱ kpa̱ɗing. Nkpaktak atani aga agba̱pchi ama̱n pa̱ zəng va̱ ta á mal izər. ");
INSERT INTO yer_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Gwang atani pa̱ tukun ka̱ anung zəngtəng, kang atani aga kpa̱ɗing ka̱ anung zəngtəng. Te kup atani aga akpa̱ɗing va̱ ta pa̱ mparəm á gún mpyal aghal. ");
INSERT INTO yer_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Nəm oga mɓol ìsəm pa̱ ìtukun ka̱ aranchwang atani azəngtəng, kang ɓù nəm oga mɓol ìsəm pa̱ ìtukun kà̱ nkùr aranchwang atani azəngtəng. ");
INSERT INTO yer_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Nəm oga iya̱m iga nzùzong ìsəm pa̱ ìtukun ká̱ acham arəzang, te mwak oga iya̱m iga nzùzong va̱ ta ka̱ ashe oga mɓol kang ɓù gwang aghal va̱ ta ka̱ anung zəngtəng na á yà pa̱ zəng. ");
INSERT INTO yer_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Te aɓo atani ava̱ le ka̱ apal aghal te i zong kà̱ nsəm aghal aYawe. ");
INSERT INTO yer_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ashar pa̱ zəng ká̱ aɓuɓo kà̱ ngba̱k nro kang ashar pa̱ zəng ká̱ aɓuɓo kà̱ ngba̱k nzəngtəng. Oga aɓo ngwang atani aghal va̱ le te i zong kà̱ oga ngba̱k aghal aYawe na á gún na. ");
INSERT INTO yer_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Nəm iya̱m iga nggún apal aghal ká̱ awá pa̱ parəm, iro ka̱ awá inagám va mmá ɓán ka̱ ǹzazí, kang iro iga nggugún kà̱ awá anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","<<Kyen oga ndar aghal aYawe ngga akun akasiya aga nsat nzwang. ");
INSERT INTO yer_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Nza̱ nzəngtəng nggo ngwuwang á yà ashar pa̱ gba̱pchi ama̱n pa̱ tukun, mbəbal á yà ashar pa̱ parəm ka̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Nza̱ ndar nggo te, á yà ká̱ ǹcà nggang pa̱ mparəm ka̱kul nggwang oza̱ ka̱ anung zəngtəng. Wa nnà ta ɓu kyen nkpaktak oga ndar aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kyen oga ndar aghal áYawe va̱ ta ìsəm pa̱ iparəm ka̱kul ngba̱k ngga nkwandal. ");
INSERT INTO yer_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Te nəm oga atak mmùmwak ká̱ aazurfa ìsəm pa̱ ineɗing ka̱ avəng oga ndar ngga ìsəm pa̱ iparəm va̱ ta. Atak mmùmwak pa̱ mparəm ka̱ akum ndar ǹggəshi ka̱kul oga ncà nggangcà nggang, kang atak mmùmwak pa̱ mparəm ka̱ akum ndar ngga ngbəbak ka̱kul oga ncà nggangcà nggang. ");
INSERT INTO yer_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Nggba̱k ngga mpal aghal áYawe va̱ ta, wa nnà ta kpa oga ndar á yà ìsəm pa̱ iparəm, ");
INSERT INTO yer_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","nzəng ká̱ atak mmwàk oza̱ ngga aazurfa ìsəm pa̱ ineɗing. Oga atak mmùmwak pa̱ mparəm ka̱ akum ndar ǹggəshi, kang oga atak mmùmwak pa̱ mparəm ka̱ akum ndar ngga ngbəgba̱k. ");
INSERT INTO yer_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Te kyen ndar aghal áYawe pa̱ nkpa̱ɗing ka̱kul ngba̱k ngga asa̱l ǹsəm. ");
INSERT INTO yer_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Kyen oga ndar pa̱ mparəm ka̱kul oga nggúlyanggú nsəm aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ɓak oza̱ ka̱ akum á ɓa á chu apal na á yà ka̱ ashe nkalbang pa̱ nzəng. Wa nnà ta i yà ńkpaktak oza̱, oza̱ i yà nggúlyanggú pa̱ mparəm. ");
INSERT INTO yer_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Te ndar á yà pa̱ nna̱nne ká̱ oga atak mmwàk oza̱ ngga aazurfa pa̱ gba̱pchi ama̱n pa̱ kpa̱ɗing. Oga atak mmùmwak á yà pa̱ parəm ka̱ akum ndar ǹggəshi kang oga atak mmùmwak ì yà pa̱ mparəm ka̱ akum ndar ngga ngbəgba̱k. ");
INSERT INTO yer_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","<<Kyen oga ndar nnárnàr ngga akun akasiya pa̱ ntukun ka̱kul oga ndar ngga ngba̱k aghal áYawe, ");
INSERT INTO yer_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ká̱ ndar nnárnàr pa̱ ntukun ka̱kul ndar ngga ngba̱k nzəngtəng, kang ká̱ nro pa̱ ntukun ka̱kul ndar ngga ngba̱k ngga asa̱l ǹsəm aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ndar nnárnàr ngga ishimshe oga ndar i gantal kà̱ nkùr nro i ga i cú nkùr nro. ");
INSERT INTO yer_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Te ɓam oga ndar va̱ ta ká̱ azənariya, kang ɓù nəm oga nkalɓankalɓang ká̱ azənariyá na á kpán oga ndar nnárnàr va̱ ta. Ɓam oga ndar nnárnàr va̱ ta ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Pak aghal áYawe va̱ ta pa̱ dakdak wa nva mmá nyám a ɓu ka̱ apal aɓàm á. ");
INSERT INTO yer_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","<<Nəm atani aga nkap afu ǹzhi aga ndəng ìzər ivyau, ka̱ ndəng nrəzang pa̱ gà̱r, ká̱ ndəng nrəzang, ká̱ alinin anəna̱n. Nəm ká̱ ala̱ka̱n oga akerup ka̱ atak aghan anəm uga inok u va̱ a nyi nchicà pa̱ gənggəng á. ");
INSERT INTO yer_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Zong atani va̱ ta ka̱ apal ǹdar akún akasiya ava mmá ɓam ká̱ azənariya, ká̱ iya̱m iga nzùzong iga azənariya ka̱ apal atak mmùmwak aga aneɗing aga aazurfa. ");
INSERT INTO yer_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Zong atani va̱ ta ka̱ akum oga iya̱m iga nzùzong, te tar ká̱ akwati aga nsar nnap-nlà ká̱ nsəsəm. Atani va̱ ta i kap ishimshe Atak Ayə́ryər ká̱ Atak Ayə́ryər ava ji. ");
INSERT INTO yer_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Nak anung aga nkuk akwati ka̱ apal akwati aga nsar nnap-nlà ka̱ ashe atak ayəryə́r ava ji. ");
INSERT INTO yer_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Yal atebəl kà̱ mpyal atani aga nkap afu ǹzhi ka̱ asa̱l mpal aghal áYawe, te yal apitila aga idari á mal ìkwoksok ká̱ atebəl ka̱ asa̱l nkwandal. ");
INSERT INTO yer_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","<<Nəm atani aga anung asa̱l aghal áYawe ká̱ afini aga ndəng izər ìvyau, ká̱ ndəng nrəzang pa̱ ga̱r, ká̱ ndəng nrəzang, ká̱ alinin anəna̱n ava mmá lok ɓyen pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Kyen oga ndar akún akasiya pa̱ ntukun te ɓam ká̱ azənariya ka̱kul atani va̱ ta. Iya̱m iga nzong oza̱ á yà iga azənariya, te nəm atak mmwàk óza̱ pa̱ ntukun ká̱ acham arəzang.>> ");
INSERT INTO yer_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","UYawe la uMusa pa̱, <<Nəm atak nshì iya̱m awop aga asu, mbəbal ashar pa̱ fangshat ká̱ aɓuɓo, ngwuwang ashar pa̱ fangshat ká̱ aɓuɓo. Atak nshì iya̱m awop va̱ ta á mal izər, te mməmak ashar pa̱ neɗing ká̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Nəm agbəshi á na kà̱ nggulyanggugulyanggu ngga nneɗing, na oga agbəshi va̱ ta ká̱ atak nshì iya̱m awop á yà iya̱m zəngtəng. Ɓam na ká̱ acham arə́zang. ");
INSERT INTO yer_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Nəm oga asu nchwang, ká̱ ashefər, ká̱ asu, ká̱ ìga̱pchi ìga ifáng, ká̱ asu apər. Nəm nkpaktak iya̱m inok va̱ ta ká̱ acham arə́zang. ");
INSERT INTO yer_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Pàntal oga acham arə́zang á na wa alariya, te nəm oga nkalɓang ngga acham arə́zang kà̱ nza̱ nggúlyanggú ngga nneɗing nggo. ");
INSERT INTO yer_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Pá alariya va̱ ta ka̱ akum alə̀gər atak nshì iya̱m awop, ná á yà kà̱ nkap ishimshe atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Nəm oga nkpá nggang ká̱ akún akasiya ka̱kul atak nshì iya̱m awop, te ɓam ká̱ acham arə́zang. ");
INSERT INTO yer_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Mwàk oga nkpá nggang va̱ ta ka̱ ashe nkalɓang, na oza̱ á yà ka̱ ngba̱k ngga mparəm ka̱ izər atak nshì iya̱m awop ka̱kul nyiyar. ");
INSERT INTO yer_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Nəm atak nshì iya̱m awop va̱ ta á yà awong ká̱ akún abalbal. Nəm na pa̱ dakdak wa nva mmá nyám a ɓu ka̱ apal aɓàm á.>> ");
INSERT INTO yer_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","<<Nəm agəla̱n aghal aYawe. Nggba̱k nkwandal á yà ashar igba̱l ká̱ ìsəm pa̱ ìtukun, te atani á yà anəna̱n nlok alinin, ");
INSERT INTO yer_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ká̱ oga ndar ngga acham arə́zang ìsəm pa̱ iparəm, ká̱ oga atak mmumwak aga acham arə́zang ìsəm pa̱ iparəm, kang ká̱ iya̱m iga nzuzong ká̱ iga nrəran ká̱ izər ndáng á yà iga aazurfa. ");
INSERT INTO yer_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Asa̱l mpal agəla̱n va̱ ta ngwuwang á yà ashar igba̱l ká̱ ìsəm pa̱ ìtukun na kpa, kang i yà ká̱ atani, ká̱ ndar ngga acham arə́zang ìsəm pa̱ iparəm, ká̱ atak mmumwak aga acham arə́zang ìsəm pa̱ iparəm, kang ká̱ iya̱m iga nzuzong ká̱ atak nrəran ká̱ izər ndáng iga aazurfa. ");
INSERT INTO yer_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Mbal atani ka̱kul agəla̱n ka̱ asa̱l ntar alum á yà ashar ìsəm pa̱ ifangshat ama̱n pa̱ tukun, ká̱ ndar pa̱ ngba̱pchi ká̱ atak mmwàk oza̱ pa̱ ngba̱pchi. ");
INSERT INTO yer_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ka̱ asa̱l nfa alum agəla̱n te, mbəbal á yà ashar ìsəm pa̱ ifangshat ama̱n pa̱ tukun na kpa. ");
INSERT INTO yer_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Nwang atani á yà ashar ìsəm parəm ama̱n pa̱ parəm ká̱ aɓuɓo kà̱ ngba̱k anung asa̱l, ká̱ oga ndar pa̱ nshatɗing ká̱ atak mmumwak pa̱ nshatɗing. ");
INSERT INTO yer_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Te ngwang atani kà̱ ngba̱k nzəngtəng á yà ashar ìsəm pa̱ iparəm ama̱n pa̱ parəm ka̱ aɓuɓo, ká̱ oga ndar pa̱ nshatɗing ká̱ atak mmumwak pa̱ nshatɗing. ");
INSERT INTO yer_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Nwang atani aga anung asa̱l agəla̱n va̱ ta á yà ashar ìsəm pa̱ ishatɗing ava mmá lok ɓyen pa̱ gənggəng ká̱ afini alinin aga ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ nrəzang. Á yà ká̱ oga ndar pa̱ nneɗing ká̱ atak mmumwak pa̱ nneɗing. ");
INSERT INTO yer_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Nkpaktak oga ndar va̱ ka̱ ashe agəla̱n te, á yà ká̱ iya̱m iga nrəran ká̱ nzuzong iga aazurfa, ká̱ atak mmumwak ngga acham arəzang. ");
INSERT INTO yer_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Nwang agəla̱n va̱ ta á yà ashar igba̱l ka̱ ìsəm pa̱ ìtukun, mbəbal ashar ìsəm pa̱ ifangshat ama̱n pa̱ tukun, mməmak ashar pa̱ fangshat ka̱ aɓuɓo, ká̱ atani aga nlok ká̱ afini alinin anəna̱n, ká̱ atak mmumwak aga acham arəzang. ");
INSERT INTO yer_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Nkpaktak oga iya̱m inok aghal aYawe ka̱kul nza̱ inok nggo, ká̱ nkpaktak oga avan akun aga nrán aghal ká̱ oga avan akun agəla̱n á yà aga acham arəzang. ");
INSERT INTO yer_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","<<Nak oIsa̱rila á ɓa ká̱ mmì mpyet nnəna̱n a ɓu ka̱kul apər, na apitila va̱ ta á yà kà̱ nnrì pa̱ ɗəkər. ");
INSERT INTO yer_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ka̱ ashe Aghal Mɓut kà̱ nsəm atani ava kà̱ mpyal akwati aga nsar nnap-nlà te, uHaruna ká̱ ovan wò á nak ishi ká̱ apitila va̱ ta á yà kà̱ nrí pa̱ ɗəkər kà̱ mpyal aYawe á ɓàn ká̱ arurong á ga á chu ìpin. Nva̱ ta̱ á yà nnap nnəm ngga mbyet mbyet óIsa̱rila ka̱ ashe nkpaktak nlwàk oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","<<Ɓa ká̱ ùgənang ɓu uHaruna ká̱ ovəvan onunggwan ka̱ ashe oIsa̱rila á yà nzəng ká̱ ɓu, uNadap ká̱ uAbihu, uEleazar ká̱ uItama na ó nəm inok onəm oga mpyal awop á mi. ");
INSERT INTO yer_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Dán ílukwán íyə́ryər ugənnang ɓu uHaruna ka̱kul ìzhàn ká̱ iɓyen. ");
INSERT INTO yer_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Là nkpaktak onəm oga nnyi inok awo ova n yə́l oza̱ ká̱ aghan na oza̱ á dán ílukwán iga nggar uHaruna ka̱kul nnəm inok anəm uga mpyal awop á mi. ");
INSERT INTO yer_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Oga ilukwan va ta̱ oza̱ i dán, ìya ìlukwan ìkwoksok, ìlukwan ìkwoksok, ìlukwan iwángwang, ìlukwan iga ashe, iya̱m ishi, ká̱ ngbat. Oza̱ á dán ílukwán iyə́ryər va̱ ta̱ ugənang ɓu uHaruna ká̱ ovəvan onunggwan na oza̱ á nəm inok onəm oga ǹshi iya̱m awop á mi. ");
INSERT INTO yer_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Oza̱ á nəm ká̱ azənariya, ká̱ afini aga ndəng ízər ivyau, ká̱ nrəzang pa̱ gà̱r, ká̱ nrəzang, kang ká̱ alinin anəna̱n.>> ");
INSERT INTO yer_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","<<Oza̱ á dán ìlukwan ìkwoksok va̱ ta, á lok ká̱ afini azənariya aga ndəng ízər ivyau, ká̱ nrəzang pa̱ gà̱r, ká̱ nrəzang, ká̱ alinin anəna̱n, inok ánəm uga aghan. ");
INSERT INTO yer_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Á yà ká̱ ngbat agar pa̱ mparəm ka̱ aranchwangranchwang aga aparəm ka̱kul nrəran. ");
INSERT INTO yer_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Nggbat ìlukwan ikwoksokkwoksok nloklok á yà nnəm nzəngtəng ká̱ afini azənariya aga ndəng ízər ivyau, ká̱ nrəzang pa̱ gà̱r, ká̱ nrəzang, kang ká̱ alinin anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Wur ipáng iza̱mza̱m pa̱ iparəm te gyok aɗin ovan aIsa̱rila ka̱ apal oza̱. ");
INSERT INTO yer_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Aɗin á yà pa̱ kpa̱dəng ka̱ apal ipáng iro kang pa̱ kpa̱dəng ka̱ apal izəngtəng ka̱ atak inəmgbak oza̱. ");
INSERT INTO yer_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Gyok aɗin ovan áIsa̱rila ka̱ apal ipáng iga iparəm va̱ ta wa nva̱ unəm uga nkpà ipáng i gyok asitam. Mwak oza̱ ka̱ ashe iya̱m iga nkpəkpán iga azənariya. ");
INSERT INTO yer_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ɓam oga ipáng iga iparəm va̱ ta ka̱ apal ngbat agar ìlukwan ìkwoksok wa ipáng iga nrəng ká̱ ovan áIsa̱rila. UHaruna á zong oga aɗin va̱ ta ka̱ apal agar wò kà̱ mpyal aYawe ka̱kul nrəng ká̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Nəm iya̱m iga nkpəkpán iga azənariya, ");
INSERT INTO yer_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ká̱ oga nzwar mmyarmyar pa̱ mparəm ngga azənariya anəna̱n. Te ran oga nzwar mmyarmyar va̱ ta ka̱ izər iya̱m iga nkpəkpán iga azənariya va̱ ta.>> ");
INSERT INTO yer_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","<<Te dán mpuluk ka̱kul nva̱n nnap, inok ánəm uga aghan. Nəm wa ìlukwan ìkwoksok ká̱ azənariya, ká̱ afini aga ndəng izər ivyau, ká̱ nrəzang pa̱ gà̱r, ká̱ nrəzang, kang ká̱ alinin amyarmyar anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Mma kùp te á mal izər, ngwuwang ká̱ mbəbal á yà mbal awo nza̱ ngba̱k nggo. ");
INSERT INTO yer_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Te dàt oga ipáng inəna̱n va̱ ta ǹzhi pa̱ nneɗing ka̱ pəpal. Ndàt nggəshi á yà ipáng irəzang va i ya atak pa̱ halakhalak, ká̱ iva̱ wa ndəng ilur, ká̱ iga ndəng ilyanggu. ");
INSERT INTO yer_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ndàt ngga mparəm á yà ipáng va ká̱ nrezang, ká̱ iva̱ ikamkam, ká̱ iva̱ fəfər wa apye. ");
INSERT INTO yer_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ndàt ngga nshatɗing á yà ká̱ ipáng iga ndəng ishan, ká̱ iva̱ wa ndəng agba̱k, ká̱ iva̱ irezang pa̱ ga̱r. ");
INSERT INTO yer_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ndàt ngga nneɗing á yà ká̱ ipáng iga ndəng izər ivyau, ká̱ ipáng iza̱mza̱m, ká̱ iga ndəng ipəpa. Mwak oza̱ ka̱ ashe iya̱m iga nkpəkpán iga azənariya. ");
INSERT INTO yer_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ípang iga igba̱pchi ama̱n pa̱ parəm va̱ ta ámal ka̱ anung aɗin ovan áIsa̱rila oga ogba̱pchi ama̱n pa̱ parəm. Nza̱ ipáng nggo te, mmá gyok aɗin akum pa̱ zəng ka̱ izəzər ka̱ ashe aga agba̱pchi ama̱n pa̱ parəm wa asitam. ");
INSERT INTO yer_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","<<Myar oga nzwar ngga azənariya anəna̱n ka̱kul ìya ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Te nəm nkalɓang azənariya pa̱ mparəm, mwak ka̱ nggulyanggu ngga mparəm ngga apal ìya ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Mwak nzwar azənariya ngga mparəm va̱ ta ká̱ izər nkalɓang ngga mparəm va̱ kà̱ nggulyanggu ìya ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Te mwak ìjili nzwar ngga mparəm va̱ ta kà̱ izər iya̱m iga nkpəkpán iga azənariya. Mwak ka̱ mpyal ngbat agar ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Nəm oga nkalɓang azənariya pa̱ mparəm kà̱ɗi, te mwak oza̱ ka̱ ashe ka̱ avəng nggulyanggu ngga mparəm ngga ìya ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Nəm nkalɓang nkak kà̱ɗi ngga zənariya pa̱ mparəm, te mwak oza̱ ka̱ akum ngbat agar ìlukwan ìkwoksok ká̱ nzwar kà̱ mpipyal á dat ka̱ atak ngugwang. ");
INSERT INTO yer_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Te ran nkalɓang ngga izər ìya ìlukwan ìkwoksok ká̱ izər nkalbang ngga izər ìlukwan ìkwoksok ká̱ asang aga ndəng izər ivyau, á yà ka̱ apal ngbat ìlukwan ìkwoksok ka̱kul na á kpán ìya ìlukwan ìkwoksok kang a yok ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Te uHaruna i yar aɗin ovan aIsa̱rila ka̱ apal ìya ìlukwan ìkwoksok ngga nva̱n nnap kà̱ ìkwoksok wò, awalang va̱ uza̱ i tar Atak Ayə́ryər ka̱kul nva̱n nnap kà̱ mpyal aYawe pa̱ ɗəkər. ");
INSERT INTO yer_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Nak aUrim ká̱ aTummim ka̱ ashe ìya ìlukwan ìkwoksok iga nva̱n nnap. Oza̱ á yà kà̱ ìkwoksok aHaruna awalang va̱ uza̱ i tar mpyal aYawe. Wa nnà ta uHaruna i yar oga iya̱m va̱ ta pa̱ ɗəkər ka̱kul nva̱n nnap ka̱ apal oIsa̱rila kà̱ mpyal aYawe. ");
INSERT INTO yer_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Dán ìlukwan iwángwang iga avəng ìlukwan ìkwoksok á yà ndəng izər ivyau. ");
INSERT INTO yer_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Á yà ká̱ atak mpa ishi kà̱ ishimsheshimshe, lok ishishak ka̱kul kang acha ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ka̱ anunung ka̱ avəng te, nəm oga awar ìkúmkúm iga ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ nrəzang a gang anunung aga avəvəng ká̱ oga iɓa̱ngga̱ng azənariya kà̱ ishimshe oza̱. ");
INSERT INTO yer_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Dàt oza̱, awar ìkúmkúm i le te iɓa̱ngga̱ng azənariya, i le te awar ìkúmkúm, i le te iɓa̱ngga̱ng azənariya, wa nnà ta á ga agang avəvəng pa̱ lat. ");
INSERT INTO yer_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","UHaruna i pá ìlukwan iwángwang va̱ ta̱ awalang va̱ uza̱ kà̱ nnəm inok, kang mí yà kà̱ nfe nnənap nva̱ngva̱ uza̱ tar ashe atak ayəyər kà̱ mpyal aYawe ká̱ nva̱ngva̱ uza̱ i fa, ka̱kul kang uza̱ a kú ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","<<Nəm achuchwal aga azənariya anəna̱n, te gyok na wa nggyok asitam, <Unəna̱n ûYawe.> ");
INSERT INTO yer_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Te ran ka̱ izər iya̱m ishi ká̱ asang aga ndəng izər ivyau, á yà kà̱ mpyal iya̱m ishi. ");
INSERT INTO yer_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Á yà kà̱ isu uHaruna, kang uHaruna i yar nkpaktak mpat ka̱ atak nná oga iya̱m inana inəna̱n va̱ oIsa̱rila gar ka̱ ashe imwa oza̱ inəna̱n. Á yà kà̱ isu aHaruna pa̱ ɗəkər ka̱kul na iya̱m inana á yà iya̱m ikángkáng ka̱ atak aYawe. ");
INSERT INTO yer_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Dán ìlukwan iga ashe ká̱ afini alinin anəna̱n, lok iya̱m ishi ká̱ afini alinin anəna̱n, te Kà̱p ngbat á yà inok ánəm uga nzəza̱m. ");
INSERT INTO yer_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Dán ílukwan iga ashe, kà̱p oga ngbat ká̱ oga iya̱m ishi óvan aHaruna. Dán oza̱ ka̱kul ìɓyen ká̱ ìzhàn. ");
INSERT INTO yer_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Nva̱ngva̱ u mwak ilukwan va̱ ta̱ chit ûHaruna ugənang ɓu ka̱ ovəvan onunggwan, te gor oza̱, nak awo óza̱, na oza̱ á yà o gargar kang oza̱ i nəm inok onəm oga mpyal awop á mi. ");
INSERT INTO yer_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Dán iya̱m aɗək iga afini alinin iva ikùr ka̱ isong ka̱kul ndàng imaləng oza̱. ");
INSERT INTO yer_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","UHaruna ka̱ ovan wò onunggwan a mwak awalang va̱ oza̱ kà̱ ntáng ashe Aghal Mɓut, ka̱t te oza̱ ɓa atak nshì iya̱m awop pa̱ o nəm inok ka̱ ashe atak ayəyər, na kang oza̱ á ɓa ká̱ mpat ishi oza̱ akú ka̱t. Iya̱m va̱ ta̱ á yà nnap nnəm ngga mbyet mbyet ka̱ atak aHaruna ka̱ akum ìjili jili. ");
INSERT INTO yer_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","<<Iya̱m va ta̱ ɓu nəm oza̱ na á gar oza̱ ka̱kul na oza̱ á yà onəm oga ǹshi iya̱m awop mi. Kpán iya inà inunggwan ká̱ inagam pa̱ iparəm iva yà ká̱ mbyèt ka̱t, ");
INSERT INTO yer_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ká̱ nzəngkəng ngga ǹyà ká̱ annyer ka̱t, ká̱ awoina va yà ká̱ annyer ka̱t ká̱ mmì, ká̱ nzəngkəng ndatdat ngga ǹyà ká̱ anyer ka̱t va mmá ɓəl ká̱ mmì. Nəm oza̱ ká̱ mmá̱k izangzəng ǹyalyal. ");
INSERT INTO yer_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Nak oza̱ ka̱ ashe nkatəp kang ɓu ɓa ká̱ ka̱ ashe nkatəp va̱ ta, ɓa ká̱ inà inunggwan ka̱ ínagam iga iparəm va̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ɓa ká̱ uHaruna ká̱ ovəvan onunggwan ka̱ anung asa̱l Aghal Mɓut, te nàl oza̱ ká̱ ndəng. ");
INSERT INTO yer_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Te mwak ilukwan uHaruna, iga ashe, iwangwang, iga ìkwoksok, ka̱ mpuluk, kang ɓu kpán aɗək á na ká̱ ngbat. ");
INSERT INTO yer_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Pá iya̱m ishi á na ká̱ ishishi, te ɓam achuchwal ayə́ryər va̱ ta ka̱ izər iya̱m ishi. ");
INSERT INTO yer_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Yar mmì ngga nggor, zuk á na ka̱ ishi gar na. ");
INSERT INTO yer_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Kà̱ nvəva̱ng te ɓa ká̱ ovəvan, mwak ílukwan iga ashe óza̱, ");
INSERT INTO yer_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Kpán aɗək ûHaruna ká̱ ovan wò ká̱ ngbàt kang ɓu mwak iya̱m ishi óza̱, te inok mpyal awop i yà nji oza̱ mbyet mbyet. Asa̱l va ta̱ ɓu gar uHaruna ká̱ ovan wò.>> ");
INSERT INTO yer_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Te ɓa ká̱ iya inà inunggwan ka̱ anung asa̱l Aghal Mɓut, te uHaruna ká̱ ovan wò i nak awo oza̱ ka̱ apal ishishi. ");
INSERT INTO yer_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Te pà iya inà inunggwan va̱ ta kà̱ mpyal aYawe ka̱ anung asa̱l Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Dok nchə̀r iya inà inunggwan va̱ ta ká̱ ifang ɓu na u ɓàp kà̱ oga nggungung atak nshì iya̱m awop, te tar aɓuɓo pa̱ kpaktak ka̱ akum atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Wur nkpaktak mpip va̱ gún oga iya̱mfu ka̱ nvəngva̱ ka̱ izər anì, ka̱ oga arusok aga aparəm ká̱ mpip oza̱, te shì ka̱ apal atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Te wur izhé iya inà inunggwan va̱ ta ká̱ awuwa ká̱ oga iya̱mfu, shì oza̱ ka̱ apər kà̱ nsəm apa̱k, iya̱m inana nnap mɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","<<Te kpán ìnagam pa̱ izəng, na uHaruna ka̱ ovan wò á nak awo oza̱ ka̱ apal ishi ìnagam va̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Pà ìnagam va̱ ta, te dok nchəchər sháng kà̱ nkpaktak ngba̱k atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Te nyat ìnagam va̱ ta, nàl iya̱mfufu ká̱ oga mbwangbwangbwángbwáng, te gwang oza̱ ka̱ ìnyatnyat va̱ ká̱ ishishi. ");
INSERT INTO yer_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Te shì nkpaktak ìnagam va̱ ta ka̱ apal atak nshì iya̱m awop. Iya̱m inana iga nshì pa̱ ɗwot ûYawe, inəngnəng ichángchàng, iya̱m inana iga nshì ûYawe.>> ");
INSERT INTO yer_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","<<Te kpán ìnagam izəngtəng na uHaruna ká̱ ovan wò á nak awo oza̱ ka̱ apal ishi ìnagam va̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Pà ìnagam va̱ ta te dok nchəchər na u ɓàp ka̱ apal arwangchwang achwang aga awóri aHaruna ka̱ ovəvan onunggwan. Dok kà̱ ífang inunggwan iga awóri, ká̱ ífang inunggwan iga shar ari oza̱. Te shang aɓo nchə̀r va̱ ta kà̱ nkpaktak ngba̱k atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Dok nchə̀r va̱ ka̱ apal atak nshì iya̱m awop, ká̱ mmì ngga nggar, te shang ka̱ apal aHaruna ká̱ ìlukwanlukwan, ká̱ ovəvan onunggwan ká̱ ìlukwan oza̱. Uza̱ ká̱ ovəvan onunggwan ká̱ ílukwan oza̱ i yà oyə́ryər.>> ");
INSERT INTO yer_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Wur mpip ìnagam va̱ ta, mpip aswal, ká̱ ngga iya̱mfu, ká̱ ngga anì, ká̱ arusok aga aparəm ká̱ mpip oza̱, ká̱ isong iga awóri, ka̱kul ìnagam iga nnak awo. ");
INSERT INTO yer_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Yar mɓit nzəngkəng, ká̱ awoina pa̱ zəng ava mmá nəm ká̱ mmì, ká̱ nzəngkəng ndatdat pa̱ nzəng a fa ka̱ ashe nkatəp nzəngkəng va ngga ǹyà ká̱ anyer ka̱t va ká̱ mpyal aYawe. ");
INSERT INTO yer_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Nak nkpaktak oga iya̱m va̱ ta̱ ka̱ ashe awo aHaruna ká̱ ovəvan, na oza̱ á gha̱p, iya̱m inana iga ǹyegye ûYawe. ");
INSERT INTO yer_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ka̱m ka̱ awo oza̱, te shì ka̱ apal atak nshì iya̱m awop, iya̱m inana inəngnəng ichángchàng kà̱ mpyal aYawe. Iya̱m inana iga nshì pa̱ ɗwot ûYawe. ");
INSERT INTO yer_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Yar ǹjat ìnagam iga nnak awo ûHaruna, te gha̱p wa iya̱m inana iga ǹyegye kà̱ mpyal aYawe, na á yà ǹji ɓu. ");
INSERT INTO yer_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","<<Gar ǹjat iya̱m inana iga ǹyegye nva̱ mmá yegye ká̱ isong ngga iya̱m iɓutɓut iva̱ mmá gha̱p ka̱ ashe ìnagam iga nnak awo, ka̱ ashe iya̱m va̱ iji aHaruna ká̱ ovəvan. ");
INSERT INTO yer_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Iya̱m va̱ ta̱ i yà iji aHaruna ká̱ ovəvan ka̱ ashe oIsa̱rila pa̱ ɗəkər ka̱kul iya̱m inana. I yà iya̱m inana ka̱ atak oIsa̱rila ka̱ ashe nləfər oza̱ ngga iya̱m inana iga ntəm ikángkáng, iya̱m inana oza̱ ûYawe.>> ");
INSERT INTO yer_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","<<Ilukwan iyə́ryər aHaruna i yà iji ovəvan kà̱ nvəva̱ng, te mí zuk mmì óza̱ mí nak awo óza̱. ");
INSERT INTO yer_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Unəm va̱ yà unəm uga mpyal awop ka̱ nva̱ng aHaruna ka̱ ashe ovəvan te, uza̱ i mwak oga ílukwan va̱ ta̱ i nəm nra pa̱ nfangshat kang uza̱ i ɓa ashe Aghal Mɓut pa̱ ô nəm inok ka̱ atak ayəryər. ");
INSERT INTO yer_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","<<Yar ìnagam iga nnak awo, te pək izhìzhe ka̱ Atak Ayə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","UHaruna ká̱ ovan wò onunggwan á ri izhé ìnagam va̱ ta nzəng ka̱ nzəngkəng va̱ ka̱ ashe nkatəp ka̱ anung asa̱l Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Te oza̱ á ri iya̱m va̱ mmá mwa ishi ká̱ ka̱kul nnak awo ká̱ nggar oza̱. Unəm ugafak i ri oza̱ ka̱t ka̱kul oza̱ iya̱m iyə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","A yà pa̱ izhé, ka̱t te nzəngkəng ka̱kul nnak awo achu ìpin kpa̱kkpa̱k te, shì ká̱ apər, mí ri ka̱t ka̱kul iyə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","<<Asa̱l va ta̱ ɓu nəm ká̱ uHaruna ká̱ ovan wò wa nva̱ ka̱ n nak ɓu, nnak awo óza̱ i yar nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Nza̱ ilum nggo te na iya inà inunggwan iya̱m inana nnap mɓá̱ngɓa̱ng ka̱kul mmwa ishi. Jen atak nshì iya̱m awop ka̱ atak mmwa ishi ka̱kukul, te gor na u gar na. ");
INSERT INTO yer_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mwa ishi atak nshì iya̱m awop ka̱ apal nra pa̱ nfanshat na u gar na á yà ayə́ryər va ji. Nkpaktak iya̱m va̱ i dok te i yà iyə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","<<Iya̱m va ta̱ ɓu yichi ka̱ apal atak nshì iya̱m awop nza̱ ilum nggo. Itam iga ìzun pa̱ ìzəng pa̱ iparəm. ");
INSERT INTO yer_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Yichi ìtam pa̱ ìzəng ká̱ ìpin, te pa̱ ìzəng ká̱ arurong. ");
INSERT INTO yer_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ìtam iga nggəshi te yichi nzəng ká̱ mma̱k ǹyalyal ka̱ ashe ìkpáng mma̱k pa̱ ìzəng, ká̱ mmì mpyet pa̱ ɗa̱p ká̱ ndəng ìba̱ngba̱ng ǹsámsàm akwaya pa̱ zəng, iya̱m inana iga ngwa. ");
INSERT INTO yer_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Yichi ìtam izəngtəng ká̱ arurong wa nva u yichi iya̱m inana ìpirkur ká̱ iga ngwa ká̱ ìpin, inəngnəng ichángchàng, iya̱m inana iga nshì ûYawe. ");
INSERT INTO yer_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","I yà iya̱m inana iga nshì pa̱ ɗwot pa̱ ɗəkər ka̱ ashe oga nlwàk wo ka̱ anung Aghal Mɓut kà̱ mpyal aYawe, ka̱ atak va̱ ta mi gwang ka̱ ɓu kang mi là nnap ká̱ ɓu. ");
INSERT INTO yer_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Mi gwang ká̱ oIsa̱rila ka̱ atak va̱ ta, kang i yà ayə́ryər ka̱ atak ìzhàn mi. ");
INSERT INTO yer_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Mi gar Aghal Mɓut ká̱ atak nshì iya̱m awop, kang uHaruna ká̱ ovan wò te mi gar i nəm inok á mi wa onəm oga ǹshi iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mi təm ka̱ ashe onəm oIsa̱rila mi yà Inan oza̱. ");
INSERT INTO yer_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Kang oza̱ i nyi pa̱ mmami na uYawe, Inan oza̱ ùva̱ fa ká̱ oza̱ ka̱ ashe mbin aMasar ka̱kul na n təm ka̱ ashe oza̱. Mmami na uYawe, Inan oza̱. ");
INSERT INTO yer_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","<<Mye atak nshì iya̱m awop ka̱kul nshì iya̱m inə́ngnəng ichángchàng, nəm ká̱ akun akasiya. ");
INSERT INTO yer_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Mbəbal á yà ashar pa̱ zəng ka̱ aɓuɓo, ngwuwang á yà ashar pa̱ zəng ká̱ aɓuɓo, ngwuwang ká̱ mbəbal á mal izər, te irurup á yà ashar pa̱ shatɗing. Nggúnggúnggúnggúng á yà nnəm iya̱m izəngtəng. ");
INSERT INTO yer_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ɓam aranchwangranchwang ká̱ oga ngbəgba̱k ká̱ nggúnggúnggúnggúng ká̱ azənariya anəna̱n. Rà̱p nza̱m kà̱ nkpaktak oga ngbəgba̱k ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Nəm nkalɓang azənariya ka̱ avəng aranchwangrangchwang pa̱ mparəm kà̱ nza̱ ngba̱k nggo ka̱kul á yà atak mmwàk nkpá nggang ngga ǹyəyar. ");
INSERT INTO yer_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Nəm oga nkpá nggang ngga akun akasiya, te ɓam izəzər ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Nak atak nshì iya̱m awop va̱ ta kà̱ mpyal atani va ká akwati aga nsar nnap-nlà, kà̱ mpyal anung aga nkukuk va ka̱ apal akwati aga nsar nnap-nlà, ka̱ atak va̱ ta mi gwang ká̱ ɓu. ");
INSERT INTO yer_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","UHaruna á dung iya̱m inəngnəng ichángchàng ka̱ apəpal nza̱ ìpin nggo, nva̱ uza̱ i ɗa̱mshi oga apitila te, uza̱ á dung. ");
INSERT INTO yer_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","UHaruna á dung ká̱ arurong nva̱ uza̱ i ɗa̱mshi oga apitila, iya̱m inəngnəng ichángchàng iga ndung pa̱ ɗəkər kà̱ mpyal aYawe ka̱ ashe nkpaktak oga nlwàk wo. ");
INSERT INTO yer_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kang wa dung nro pa̱ɗi, ka̱t te wa yichi iya̱m inana iga nshì pa̱ ɗwot, ka̱t te iya̱m inana iga ìpirkur ka̱ apəpal ka̱t. Kang wa tar iya̱m inana iga ngwa ka̱ apəpal ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Nva̱ng pa̱ zəng ka̱ ashe ìzun uHaruna á nəm mmwa ishi ka̱ apal oga nggúnggúnggúnggúng ka̱ ashe nchə̀r iya̱m inana nnap mɓá̱ngɓa̱ng ngga mmwa ishi. Pa̱ nzəng ka̱ ashe ìzun uza̱ i mwa ishishi ka̱ ashe nkpaktak nlwàk wo, ayə́ryər va̱ ji pa̱ kpaktak ûYawe.>> ");
INSERT INTO yer_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Te uYawe là uMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","<<Awalang va ɓu kung iyə̀l oIsa̱rila te, nkpaktak oza̱ i mwa ishi oza̱ ûYawe, na kang arwa aɓá̱ngɓa̱ng aro á ɓa ka̱ apal oza̱ ka̱kul nkung oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Iya̱m va ta̱ nkpaktak unəm va̱ mmà kung na chit te i mwa, agera pa̱ gba̱pchi nna nkap ashekel kà̱ ishimshe ka̱ anung ashekel aga Atak Ayə́ryər. AGera pa̱ gba̱pchi va̱ ta i yà iya̱m iɓutɓut ûYawe. ");
INSERT INTO yer_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Nkpaktak unəm va̱ mmá kung na chit, á ɓan kà̱ ìzun ìsəm pa̱ iparəm ɓa ga apal te, i na iya̱m iɓutɓut ûYawe. ");
INSERT INTO yer_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Unəm uga ndur i na i mak iji agerah pa̱ gba̱pchi ka̱t, kang unəm uga nkun i na iyən agba̱pchi ka̱t, nva̱ ó ɓa ká̱ iya̱m iɓutɓut ûYawe ka̱kul mmwa ishi wo a. ");
INSERT INTO yer_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ka̱m mbwai ngga mmwa ishi va̱ ta ka̱ atak oIsa̱rila, na u nəm inok ká̱ ka̱ Aghal Mɓut, te i yà iya̱m iga nrəng ká̱ óIsa̱rila kà̱ mpyal aYawe ka̱kul mmwa ishi oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Te uYawe là uMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","<<Nəm asu ká̱ izan iga nchəcher ká̱ acham arəzang ka̱kul nnal awo ká̱ ashar. Sung kà̱ mbagar Aghal Mɓut ká̱ atak nshì iya̱m awop, te nak ndəng ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","UHaruna ká̱ ovan wò i nàl awo oza̱ ká̱ ashar oza̱ ká̱ ndəng va̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kang oza̱ i táng ashe Aghal Mɓut ka̱t te i ɓa atak nshì iya̱m awop pa̱ o nəm inok, o yichi iya̱m inana iga apər ûYawe te, oza̱ i nàl ishi oza̱ na kang oza̱ á kú ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Oza̱ i nàl awo ká̱ ashar oza̱ na kang oza̱ á kú ka̱t. I yà nnap nnəm óza̱ mbyet mbyet, ka̱kul aHaruna ká̱ akukum ka̱ ashe nkpaktak oga nlwàk oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Te uYawe là uMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","<<Kwap ishi ɓu oga iya̱m iga nggol iya̱m-nrì inəna̱n, njəng ìkun iɗəɗek ashekel igba̱l pa̱ ìtukun, ká̱ mmá̱kma̱k ikwoksok ìkun ìɗəkɗək ashekel igba̱l pa̱ ìparəm ká̱ ìsəm pa̱ ìtukun, ká̱ nggal iɗəkɗek ashekel igba̱l pa̱ iparəm ká̱ ìsəm pa̱ ìtukun, ");
INSERT INTO yer_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ká̱ mmá̱kma̱k agwal ìkun ìɗəɗək igba̱l pa̱ ìtukun, ka̱ anung ashekel aga Atak Ayə́ryər, ká̱ mmì mpyet pa̱ ɗa̱p. ");
INSERT INTO yer_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Nəm mmì nyə́ryər ngga nggar nggwánggwáng, á yà mmì ngga nggar. ");
INSERT INTO yer_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Te gor Aghal Mɓut ká̱ akwati aga nsar nnap-nlà, ");
INSERT INTO yer_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ká̱ atebəl ká̱ nkpaktak oga iya̱m inunok, ká̱ apitila aga idari ká̱ oga iya̱m inunok, ká̱ atak ndùng nturari, ");
INSERT INTO yer_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ká̱ atak nshì iya̱m inana ká̱ nkpaktak iya̱m inunok, ká̱ asu ká̱ izəzan. ");
INSERT INTO yer_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Gar oza̱ na oza̱ á yà iyə́ryər va ji pa̱ kpaktak. Nkpaktak iya̱m va̱ i dok oza̱ te i yà iyə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Gor uHaruna ká̱ ovəvan na u gar oza̱ á nəm inok á mi wa onəm oga nshi iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Te ɓù là óIsa̱rila pa̱, <Nna ta̱ i yà mmì mi nyə́ryər ngga nggar ka̱ ashe nkpaktak oga nlwàk wo. ");
INSERT INTO yer_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Mí yà ka̱ nzuk unəm ka̱ izər na pa ka̱t, ó yà ka̱ nnəm nro wa nva̱ ta ka̱t, iya̱m iyə́ryər, i yà iya̱m iyə́ryər a wo. ");
INSERT INTO yer_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Unəm va kpaktak nəm apir mmì va̱ ta̱, ka̱t te á zuk unəm ugafak uga mpyal awop ka̱t te, mí tutur na i fa ka̱ ashe onəm mi.> >> ");
INSERT INTO yer_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","UYawe là ûMusa pa̱, <<Wur íshi ɓu, oga iya̱m iga nggol iya̱m-nrì, anatap, aushelet, awehelbənah, ká̱ njeng nnə́ngnəng ichángchàng nnəna̱n, oza̱ á mal izər. ");
INSERT INTO yer_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Te gwang nturari wa ánəm uga nnyi ngugwang, nak mmán kà̱, á yà pa̱ zarara̱, nyə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Kpa̱k ka̱ ashishe kpà pa̱ ɓirəkɓirək, te nak kà̱ mpyal akwati aga nsar nnap-nlà ka̱ ashe Aghal Mɓut, ka̱ atak va ta mi gwang ká̱ ɓu, á yà iyə́ryər va ji pa̱ kpaktak a wo. ");
INSERT INTO yer_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Nturari va̱ ó nəm ka̱ asa̱l ata̱ te, ó yà ka̱ nnənəm ka̱kul ishi wo ka̱t, o nak á yà iya̱m iyə́ryər ûYawe. ");
INSERT INTO yer_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Nkpaktak unəm va̱ nəm wa nva̱ ta̱ ka̱kul ishi wò te, mí tutur na i fa ka̱ ashe onəm mi.>> ");
INSERT INTO yer_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Te uYawe là uMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","<<Dər, n yak uBezalel uya aUri ukà aHur akum aYahuda chit. ");
INSERT INTO yer_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","N nak aRuhu mi á na, ká̱ aghan, ká̱ nkpán ìpir nnàp, ká̱ nnyi, ká̱ nkpaktak nnyi ngga nəm iya̱m iga awo pa̱ ɗongɗong, ");
INSERT INTO yer_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","na uza̱ á fa ká̱ iya̱m nnəm pa̱ ɗongɗong, azənariya, aazurfa, ká̱ acham arəzang, ");
INSERT INTO yer_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ká̱ ipáng igyokgyok ka̱kul atak aga ndədat, ká̱ nkpà akun ká̱ inok iga awo pa̱ ɗongɗong. ");
INSERT INTO yer_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Dər, n yak uOholiyap uya aAhisamak uga akum aDan nzəng ká̱ na. N na aghan aga nnyi nəm inok nkpaktak onəm oga nnyi nnəm inok, na oza̱ á nəm nkpaktak iya̱m iva n nak ɓu pa̱ û nəm, ");
INSERT INTO yer_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Aghal Mɓut, ká̱ akwati aga nsar nnap-nlà, ká̱ anung aga nkukuk ava̱ ka̱ apəpal, ká̱ nkpaktak oga iya̱m iga ashe aghal, ");
INSERT INTO yer_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ateɓəl ká̱ iya̱m inunok, idari apitila, ká̱ atak nshì iya̱m awop inə́ngnəng ichángchàng, ");
INSERT INTO yer_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ká̱ atak nshì iya̱m awop inana ká̱ iya̱m inunok, ká̱ asu ká̱ izəzan, ");
INSERT INTO yer_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ká̱ ìlukwan iloklok inəna̱n, ká̱ ìlukwan iyə́ryər ka̱kul ánəm uga mpyal awop, uHaruna, ká̱ ìlukwan ovəvan onunggwan ka̱kul inok oza̱ onəm oga mpyal awop, ");
INSERT INTO yer_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ká̱ mmì ngga nggor ká̱ nnə́ngnəng ncángchàng ka̱kul atak ayəyər. Oza̱ á nəm oza̱ pa̱ chatchat wa nva n là a ɓu.>> ");
INSERT INTO yer_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Te uYawe là uMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","<<Là óIsa̱rila pa̱, <Nkpak pa̱ o nak ishi ká̱ ilum aSati mi, ka̱kul nnyám ìpir nnàp kà̱ ishimshe mi ká̱ wo ká̱ oga nlwàk wo ngga mɓa ka̱kul na o nyi pa̱ mmami uYawe uva̱ gar wo. ");
INSERT INTO yer_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","<< <O kpak ilum aSati, ka̱kul á yə́yər ka̱ atak wo. Nkpaktak unəm uva̱ nəm vyakshin ká̱ ilum iva̱ ta te, mí gba̱l na. Nkpaktak unəm uva̱ nəm inok kà̱ ilum iva̱ ta te, mí tutur na í fa ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Nra pa̱ nkpa̱ɗing ó nəm inok ka̱ shishe, kang nra ngga nfangshat i yà aSati ilum iga njul, i yə́ryər ûYawe. Nkpaktak unəm uva̱ nəm inok kà̱ ilum iva̱ ta te, nkpak mí gba̱l na. ");
INSERT INTO yer_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","OIsa̱rila á kpak ilum aSati ava̱ ta á nak ishi ká̱ nnap mpakpak ka̱ ashe oga nlwàk oza̱ ngga mɓa ghar mbyet. ");
INSERT INTO yer_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","I yà iya̱m iga nnyám ìpir nnàp kà̱ ishimshe mi ká̱ oIsa̱rila ghar mbyet, ka̱kul ka̱ ashe nra pa̱ nkpa̱ɗing uYawe nəm apaɓur ka̱ apambin, te uza̱ jul kang a yì kà̱ nra ngga nfangshat.> >> ");
INSERT INTO yer_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Nva̱ngva̱ uYawe gba̱l nlà nnap ká̱ uMusa ka̱ apal aƁam aSinayi te, uza̱ na oga achuchwal ìpang nnap nshetshet á na pa̱ iparəm iga nlìr ifang Inan. ");
INSERT INTO yer_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Nva̱ngva̱ onəm ya pa̱ uMusa kali kà̱ nfə́r ka̱ apal aɓam te, oza̱ ɓut gáng uHaruna là á na pa̱, <<Wong, nəm inan á yi na á ləp mpyal á yi, ka̱kul í nyi iya̱m iva̱ ya uMusa uva̱ fa ká̱ yi ka̱ mbin aMasar ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Te uHaruna là óza̱ pa̱, <<O zə̀p iya̱m achwang azənariya ka̱ achwang óchar wo ká̱ ovan wo onunggwan ká̱ ovan ochar ó ɓa ká̱ á mi.>> ");
INSERT INTO yer_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Te nkpaktak onəm zə̀p oga iya̱m achwang oza̱ iga azənariya ka̱ achwang oza̱ ɓa ká̱ ûHaruna. ");
INSERT INTO yer_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Uza̱ ka̱m ka̱ awo oza̱ á tap ka̱ apər te a me ichər gyok izəzər ka̱ iya̱m inok á ya wa iya ìnà. Te oza̱ là pa̱, <<ÓIsa̱rila, inan wo yà ta̱ iva̱ fa ká̱ wo ka̱ ashe mbin aMasar.>> ");
INSERT INTO yer_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Nva̱ng nva̱ uHaruna ya te uza̱ me atak awop kà̱ mpipyal, te uHaruna wór awór là pa̱, <<Ìpin te i yà nnəm nchang izər ûYawe.>> ");
INSERT INTO yer_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Te oza̱ wong ka̱ iɓotak kà̱ ìpin ìkpa̱kkpa̱k kang oza̱ yichi iya̱m ináná iga nshì pa̱ ɗwot ká̱ iya̱m inana iga ntəm ikángkáng. Onəm təm ri iya̱m-nrì ka̱ ngwa iya̱m iwawa te, oza̱ wong gba̱p nza̱m akpit. ");
INSERT INTO yer_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Te uYawe là ûMusa pa, <<Fər kəlak, onəm va̱ u fa ká̱ oza̱ ka̱ ashe mbin aMasar te, oza̱ vyap ishi oza̱ chit. ");
INSERT INTO yer_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Oza̱ gha̱n kà̱ ga̱ɓa̱n nre asa̱l ava̱ n nák ôza̱ kang oza̱ nəm ichər iya ìnà ishi oza̱ ká̱ azənariya. Te oza̱ kuchi na nləfər á na kang oza̱ là pa̱, <ÓIsa̱rila, inan wo yà ta̱, iva fa ká̱ wo ka̱ ashe mbin aMasar.> >> ");
INSERT INTO yer_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Te uYawe là ûMusa pa̱, <<N yà onəm ova̱ ta̱ chit, oza̱ onəm oga nkak ishi. ");
INSERT INTO yer_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ǹyangmata̱ te, re mi na nlak ìgwak mi a vang ka̱ apal ishi oza̱ na n zhì oza̱. Te mi nak ɓu yà akum achumchum.>> ");
INSERT INTO yer_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ka̱ nna te uMusa sak anung uYawe, Inan wo pa̱, <<ÁYawe, sang kang ìgwak lak ɓu ká̱ onəm ɓu va u fa ká̱ ka̱ ashe mbin aMasar ká̱ ikam ichumchum ká̱ awo akamkam yà? ");
INSERT INTO yer_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","U ɗom pa̱ na oga aMasar á là pa̱, <Inan oza̱ fa ká̱ oza̱ ká̱ nrəng mɓá̱ngɓa̱ng pa̱ u gbá̱ng oza̱ ka̱ ashe oga aɓam, na u dərkən oza̱ ká̱ apambin> ɗò? Ga̱ɓa̱n nfə́l ìgwak ɓu, re nrəng nnap ɓu nsusur ngga ǹzhi onəm ɓu. ");
INSERT INTO yer_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Rəng ozwal ɓu, uAbəraham, uIshaku, ká̱ uYakup, ova u sóng anung óza̱ ká̱ ishi ɓu pa̱, <Mi nak àkum wo i yə́l wa izhan iga apaɓur, te nkpaktak mbin nva̱ ta̱ nva̱ n yar nsar nnap-nlà pa̱ mi na ovan wo í yà iya̱m akúp oza̱ mbyet mbyet.> >> ");
INSERT INTO yer_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Te uYawe ga̱ɓa̱n nrəng nnap wò ka̱ apal nɗaktak nva̱ uza̱ ka̱ yar pa̱ o ɓa ká̱ onəm wò. ");
INSERT INTO yer_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Te uMusa fər ka̱ apal aɓam ká̱ oga achuchwal ipang aga nnap nshetshet pa̱ aparəm ka̱ awo wò, achuchwal ava mmá lir iya̱m kà̱ nkpaktak ngba̱k oza̱ ngga mparəm. ");
INSERT INTO yer_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Oga achuchwal ava̱ ta̱ te Inan à nəm oza̱, kang iya̱m ǹlir va̱ ka̱ apəpal te Inan à gyok. ");
INSERT INTO yer_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","uJoshuwa fe nnáp ngham achu onəm te, uza̱ là ûMusa pa̱, <<Nnáp achu ikùm ka̱ ashe apa̱k.>> ");
INSERT INTO yer_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Kang uMusa là pa̱, <<Ìcù igwan ka̱t, ka̱t te ìcù pa̱ mmá ri onəm ká̱ ìkum ka̱t. Nnyi te, mmami kà̱ ǹfe ìcù nnap-nshì.>> ");
INSERT INTO yer_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Nva̱ngva̱ oza̱ ɓa dat ka̱ apa̱k te, uMusa ya ìya inà iva̱ oza̱ nəm kang oza̱ kà̱ ngba̱p nza̱m, ka̱ ashe nfə́l ìgwak pa̱ gənggəng, te uza̱ swang oga achuchwal ava̱ ka̱ awo wò ka̱ avəng aɓam kang oza̱ achwang pa̱ rukutrukut. ");
INSERT INTO yer_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Uza̱ yar ìya inà va oza̱ nəm shì kà̱ apər, uza̱ kpà wal mmá̱k, wung ka̱ apal ndəng, te nak oIsa̱rila wá. ");
INSERT INTO yer_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Te uMusa ɓəp uHaruna pa̱, <<Iza̱ onəm ova̱ ta̱ nəm a ɓu kang u dapchi nnap mɓá̱ngɓa̱ng nchumchum ôza̱ yà?>> ");
INSERT INTO yer_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Te uHaruna là pa̱, <<Kang ìgwak a lak unəm uga ǹzhi mi ka̱t, u nyi onəm va̱ ta̱ nyi ká̱ nɗom nnəm iya̱m iɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Oza̱ là á mi pa̱, <Nəm inan á yi na á ləp mpyal á yi, ka̱kul uMusa ta̱ unəm uva fa ká̱ yi kà̱ mbin aMasar, í nyi iya̱m iva̱ yá na ka̱t.> ");
INSERT INTO yer_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Te n là ôza̱ pa̱, <Nkpaktak unəm va̱ uwa yà ká̱ azənariya te, oza̱ á zèp á ɓa á mi.> Oza̱ ɓa ká̱ á mi kang n swang ka̱ ashe apər te, ìya inà iva̱ ta̱ fa.>> ");
INSERT INTO yer_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ka̱ nva̱ngva̱ uMusa ya chit pa̱ uHaruna nəm onəm ova̱ ta̱ chit í nfe nnap lap ka̱t, kang oza̱ sat iya̱m iga ǹyəl kà̱ mpyal okpà ìkum oza̱ te, ");
INSERT INTO yer_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","uza̱ sat ka̱ anung asa̱l ntar ashe apa̱k, kang uza̱ là pa̱, <<Nkpaktak unəm va̱ uja aYawe te, re uza̱ á ɓa atak mi.>> Te nkpaktak onunggwan oLawi ɓa gang na. ");
INSERT INTO yer_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Uza̱ là ôza̱ pa̱, <<Iya̱m iva ta̱ uYawe, Inan oIsa̱rila là, <Nza̱ unəm nggo á gal ndokchi kà̱ ngba̱k wò. Te o ga anung asa̱l ava̱ ta̱ o le ava̱cho ka̱ ashe apa̱k. Ko udanggo á gba̱l ugənnang wò, ko udanggo á gba̱l ukpa wò, kang ko udanggo í gba̱l unəm uga ngba̱k nzhi wò.> >> ");
INSERT INTO yer_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","OLawi kpak iya̱m iva̱ uMusa là ôza̱, te onəm ìkalong pa̱ ishatɗing ka̱ ashe onəm tàk nda nva̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Te uMusa là pa̱, <<N̂da nva̱ ta̱ o gar ishiwó chit ka̱kul inok áYawe. Ka̱kul ko udanggo gbá̱ng ovan wò ka̱t te ugənnang chit, ka̱kul nva̱ ta te, uYawe nak nnap nnəna̱n á wó chit.>> ");
INSERT INTO yer_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ìpin fa kpa̱k te, uMusa là ônəm pa̱, <<O nəm nnap mɓá̱ngɓa̱ng nchumchum chit. Ǹyangmata̱ te, mi kyen atak áYawe mwote, mi nəm mwa ishi ka̱kul nnap mɓá̱ngɓa̱ng wó nggo.>> ");
INSERT INTO yer_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Te uMusa le atak áYawe á là pa̱, <<Iya̱m iwusa, onəm ata̱ nəm nnap mɓá̱ngɓa̱ng nchumchum, ka̱kul oza̱ nəm ichər iga azənariya îshi oza̱. ");
INSERT INTO yer_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ká̱ nnà te, yar nnap mɓá̱ngɓa̱ng oza̱, a yà pa ka̱t te, yà dəkən aɗin mi á le ka̱ ashe ǹlir ɓu nva̱ u lir á.>> ");
INSERT INTO yer_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","UYawe là ûMusa pa̱, <<Mi dəkən aɗin anəm uva kpaktak nəm nnap mɓá̱ngɓa̱ng á mi ka̱ ashe ǹlir mi. ");
INSERT INTO yer_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ǹyangmata̱ te, ga lə́p mpyal onəm á ga atak va̱ n là a ɓu. Dər, uma̱leka mi i watar mpyal ɓu. Kap ká̱ nnà te, mi nyám ntàn óza̱ ka̱kul nnap mɓá̱ngɓa̱ng oza̱.>> ");
INSERT INTO yer_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Te uYawe la̱p onəm ká̱ arwa aɓá̱ngɓa̱ng ka̱kul oza̱ wop ìchər iva̱ uHaruna nəm. ");
INSERT INTO yer_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","UYawe là ûMusa pa̱, <<Wong re atak va̱ ta̱, mmaɓu ká̱ onəm va̱ u fa ká̱ oza̱ ka̱ ashe mbin aMasar o ga mbin nva̱ n sóng anung ûAbəraham, ká̱ uIshaku, ká̱ uYakup, n là pa̱, <Mi ga nnəna âkum ìjili wó.> ");
INSERT INTO yer_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mi ngga re ǹre ká̱ uma̱leka kà̱ mpyal wó, te mi ɓak oKanana, ká̱ oAmori, ká̱ oHiti, ká̱ oPerizi, ká̱ oHivi, ká̱ oYebusi kpa. ");
INSERT INTO yer_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ga ashe mbin nva mbyal ká̱ mmàl irizhe i nang kà̱. Ká̱ nna te, mi ga nzəng ká̱ wo ka̱t ka̱kul mmawó onəm oga nkak ishi, le kang ma zhì wó ka̱ apal asa̱l.>> ");
INSERT INTO yer_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Nva̱ngva̱ onəm fe nnap-nlà nrwarwa wa nva̱ ta te, oza̱ təm ká̱ aɗor te unəm uro mwak iya̱m ìsham wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ka̱kul uYawe là ûMusa pa̱, <<Là oIsa̱rila pa̱, <Mmawo onəm oga nkak ishi. A yà pa̱ mi ga nzəng ká̱ wó i gba̱ng va̱ng ka̱t, te mi zhì wó. Ǹyangmata̱ o zə̀p iya̱m ìsham wó, te mi yak iya̱m iva̱ mal pa̱ n nəm ká̱ wó.> >> ");
INSERT INTO yer_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Te oIsa̱rila zə̀p iya̱m ìsham oza̱ ka̱ aɓam aHorep. ");
INSERT INTO yer_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","UMusa pa̱ ɗəkər te i yar aghal kang à pak kà̱ nsəm apa̱k pa̱ gbà̱ngbà̱ng, te uza̱ wór pa̱ Aghal Mɓut. Kang nkpaktak unəm uva̱ ɗom mmwo uYawe te, uza̱ i ga Aghal Mɓut nva kà̱ nsəm apa̱k á. ");
INSERT INTO yer_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Nza̱ awalang nggo va̱ uMusa i fa ngga atak aghal te, nkpaktak onəm i wong i tong, nza̱ unəm nggo ka̱ anung aghal wò, i dər uMusa i tar ashe aghal ava̱ ta kang. ");
INSERT INTO yer_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Awalang ava̱ uMusa a tar ashe aghal te, ǹdáng ìlulu i vang i sat ka̱ anung aghal, te uYawe i là nnap ká̱ uMusa. ");
INSERT INTO yer_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Onəm i ya ǹdáng ìlulu sat chit ka̱ anung asa̱l ǹtar aghal te, nkpaktak oza̱ i wong kang nza̱ uzəngtəng oza̱ nggo i kúchi ka̱ anung aghal wò. ");
INSERT INTO yer_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","UYawe i là nnap ká̱ uMusa ìwu ká̱ ìwu wa nva unəm i là nnap ká̱ ukpa wò. Te uMusa i le apa̱k, ká̱ nnà te uJoshuwa ukparikpari, uyenza̱m uya aNun á re ashe aghal ava̱ ta jo ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","UMusa là ûYawe pa̱, <<Dər, u là á mi pa̱, <Lə́p mpyal onəm ova̱ ta̱,> kang nna u là á mi chit unəm uva̱ ɓu re i ga nzəng ká̱ mi ka̱t. Ká̱ nna te, u là á mi chit pa̱, <N nyi ɓu ká̱ aɗin, kang ká̱ nna kpa nchə̀r ɓu bà̱l chit kà̱ mpyal mi.> ");
INSERT INTO yer_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ǹyangmata̱, kusukkusuk a yà pa̱ nchə̀r mi bəbà̱l kà̱ mpyal ɓu te, kusuk, ɗyang oga asa̱l ɓu á mi na ń nyi ɓu, na ń yà ká̱ nchə̀r mbá̱lbà̱l kà̱ mpyal ɓu. Nak ishi ká̱ kpa pa̱ onəm ova̱ ta̱ onəm ɓu.>> ");
INSERT INTO yer_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Te uYawe là pa̱, <<Mi ga nzəng ká̱ ɓu, kang mi na ǹjul a ɓu.>> ");
INSERT INTO yer_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Te uMusa là á na pa̱, <<A yà pa̱ ɓu ga nzəng ká̱ yi ka̱t te, kang a re yi i wong ka̱ atak ava̱ ta̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mí nəm sang mí nyi pa̱ mmami ká̱ nchə̀r mba̱lbà̱l kà̱ mpyal ɓu, mmami ká̱ onəm ɓu, a yà pa̱ u ga nzəng ká̱ yi ka̱t yà? Iza̱ i nyám nɗongɗong mi ká̱ onəm ɓu ka̱ ashe nza̱ onəm nggo va̱ ka̱ apambin yà?>> ");
INSERT INTO yer_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Te uYawe là ûMusa pa̱, <<Mi nəm iya̱m iva̱ ta̱ iva u ɓəp, ka̱kul pa̱ u yà ká̱ nchə̀r mba̱lba̱l chit kà̱ mpyal mi, kang n nyi ɓu ká̱ aɗin.>> ");
INSERT INTO yer_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Te uMusa là pa̱, <<Kusuk, nyám ìzhàn ɓu á mi.>> ");
INSERT INTO yer_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Te uYawe là pa̱, <<Mi nak nkpaktak inəna̱n mi i watar kà̱ mpyal ɓu, te mi wór aɗin mi ayə́ryər kà̱ mpyal ɓu, kang mi nyám nrusok afu unəm uva̱ mi nyám nrusok afu, te mi nyám nrwa ìgwak unəm uva̱ mi nyám nrwa ìgwak. ");
INSERT INTO yer_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ká̱ nnà te, ɓu yà ká̱ n ya asa̱l awu mi ka̱t, ka̱kul unəmləbər uro yà i ya mi kang i lár ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Te uYawe là pa̱, <<Dər, atak nata̱ kà̱ ngba̱k mi, ava ɓu ta̱l kà̱ ka̱ apal aɓam, ");
INSERT INTO yer_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","nva̱ ìzhàn mi i yà kà̱ ngwatar te, mi nak ɓu ká̱ mbagar ìpang iva̱ ta, te mi ka̱ ɓu ka̱ awo mi ya mi watar kang. ");
INSERT INTO yer_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Nna chit te, mi yar awo mi i le te, ɓu ya asəm mi. Ká̱ nnà te, mí ya asa̱l awu mi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","UYawe là ûMusa pa̱, <<Kpà oga achuchwal ìpang pa̱ iparəm wa iga nggəshi nva, te mi lir ka̱ apal oza̱ oga nnap-nlà nzəngtəng nva ka̱ apal achuchwal aga nggəshi nva̱ ka̱ u chwan á. ");
INSERT INTO yer_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Gbar izər na ìpin na u kyen aƁam aSinayi, na u gwang ká̱ mi ka̱ apal itəngtəng aɓam ava̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kang unəm uro á kyen nzəng ká̱ ɓu ka̱t, kang a re mmá ya unəm uro kà̱ nkpaktak izər aɓam ava̱ ta ka̱t. Kang a re iya̱m nkang, ka̱t te ína á ri nrì adatkulung ká̱ aɓam ava̱ ta ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Te uMusa kpà oga achuchwal ìpang pa̱ iparəm wa iga nggəshi nva, kang uza̱ wong ká̱ iɓotak ga aƁam aSinayi, wa nva uYawe kà̱ nak na. Uza̱ wur oga achuchwal ìpang iga iparəm ava̱ ka̱ awo wò. ");
INSERT INTO yer_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","UYawe fər vang ka̱ ashe ǹdáng ìlulu ta̱l ká̱ na ka̱ta, kang à wór aɗin wò ayə́ryər, uYawe. ");
INSERT INTO yer_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Te uYawe watar kà̱ mpipyal kang à wór awór pa̱, <<UYawe, uYawe, Inan iga nrwa ìgwak ká̱ nrusok afu, iga nlak ìgwak pa̱ kəlak ka̱t, ká̱ mma̱n mmákmak ká̱ nnanda̱r. ");
INSERT INTO yer_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Mi nyám mma̱n ngga nkur ka̱t ngga nlwàk íkalong, mi yar mpat ká̱ nfa iya̱mkak ká̱ nnap mɓá̱ngɓa̱ng, kang mi yà ká̱ nre nnyám ntàn ka̱t, mi mwo mpat opon ka̱ apal ovan, ká̱ okəká oga mɓa, ka̱ apal nlwàk ngga nshatɗing ká̱ ngga nneɗing.>> ");
INSERT INTO yer_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Te uMusa ɓəram pa̱ kəlak ka̱ mbin nəm awop. ");
INSERT INTO yer_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Uza̱ là pa̱, <<Kusuk, aPonzhinan, a yà pa̱ nchə̀r mi bəbà̱l kà̱ mpyal ɓu te, re uPonzhinan á ga nzəng ká̱ yi. Káp ka̱ nva̱ pa̱ onəm ova̱ ta̱ oga nkak ishi, yar mpat ká̱ nnap mɓá̱ngɓa̱ng á yi kang ɓu ka̱m yi wa onəm ɓu.>> ");
INSERT INTO yer_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","UYawe là pa̱, <<Dakdak, mmami kà̱ ǹyar nsar nnap-nlà. Mi ga nnəm iya̱m iga nnəm ayər kà̱ mpyal nkpaktak onəm ɓu, iva nna ka̱ fa chit ka̱ ashe apambin ka̱t te oga mbin ka̱t. Te nkpaktak onəm ova̱ mmaɓu kà̱ ishimshe oza̱ í ya inok áYawe, ka̱kul mi ngga nnəm iya̱m iga nnəm ayər ka̱ ashe wó. ");
INSERT INTO yer_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Nak ishi ká̱ nnap mpakpak nva̱ mmami kà̱ nnəna a ɓu nda nva̱ ta̱. Dər, mi ga mɓàk kà̱ mpyal ɓu oAmori, oKanana, ká̱ oHiti, ká̱ oPerizi, ká̱ oHivi ká̱ oYebusi kpa. ");
INSERT INTO yer_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","O nəm dakdak kang o yar nsar nnap-nlà ká̱ onəm oga mbin va̱ mmawó kà̱ ngga ashishe ka̱t, le a yà ajə̀p kà̱ ishimshe wó. ");
INSERT INTO yer_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ka̱ɗor nva̱ ta te, o shin atak awop oza̱, o chwan ǹdáng nyə́ryər oza̱, kang ô kyen oga ndar aAshera oza̱. ");
INSERT INTO yer_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kang o wop inan iro ka̱t, ka̱kul mmami uYawe, uva aɗin mi pa̱ ìkpar, Inan iga ìkpar. ");
INSERT INTO yer_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","<<Kang wa yar nsar nnap-nlà ká̱ onəm ova̱ kà̱ ntəm ka̱ ashe mbin va̱ ta ka̱t, ka̱kul oza̱ í nəm mmai ká̱ inan oza̱, kang í na nləfər iya̱m ipápà ínan oza̱, te oza̱ á chal ɓu pa̱ u ga ká̱ oza̱, te ɓu ri nləfər oza̱. ");
INSERT INTO yer_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kang wa yar nsar nnap-nlà ká̱ onəm ova̱ kà̱ ntəm ka̱ ashe mbin va̱ ta ka̱t, ka̱kul wa ka̱m ovan ochar oza̱ ôvan ɓu onunggwan, ova í nəm mmai ka̱ atak ngwop oga inan oza̱ te, í nak ovan ɓu onunggwan í nəm mmai á mi. ");
INSERT INTO yer_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","<<Ɓu yà ká̱ nlá inan íshiɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","<<Wá nak ishi ká̱ nnəm nchang izər ngga nrì iya̱m-nrì iga ǹyà ká̱ anyer ka̱t. Nra pa̱ nfangshat ká̱ awalang va mmá nak ka̱ ashe apye aAbip, ri iya̱m-nrì iga ǹyà ká̱ anyər ka̱t wa nva̱ kà̱ n nak ɓu, ka̱kul ka̱ ashe apye ava ta na o fa ká̱ ka̱ ashe mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","<<Nza̱ amar aga nggəshi ayen anunggwan nggo te á ja̱m, kang nkpaktak amar iya̱mkang ɓu agəshi inunggwan á ja̱m. ");
INSERT INTO yer_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mwa ishi amar azhaki aga nggəshi ká̱ ìtam, kang a yà pa̱ u mwa ishishi ka̱t te, ɓəkchi ishishak. Wa mwa ishi nkpaktak ovan onunggwan ɓu oga nggəshi. <<Kang unəm uro a ɓa mpyal mi ka̱ awo lakchi ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","<<Wa nəm inok nra pa̱ nkpa̱ɗing kang kà̱ ilum iga ifangshat te, nkpak ɓu jul. Ko ka̱ awalang aga nsuk iya̱m ká̱ aga mɓəɓən kpa. ");
INSERT INTO yer_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","<<Wa nak ishi ká̱ nnəm nchang izər oga asati ká̱ awar aga nggəshi aga ibəshi, ka̱ nnəm nchang izər ngga mɓən iya̱m-nrì kà̱ nkùr ìzun. ");
INSERT INTO yer_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Nkpaktak onunggwan ɓu nkpak í nyám ishi oza̱ kà̱ mpyal uNəm Uga Nzhi uYawe, Inan oIsa̱rila, nva̱ng pa̱ nshatɗing ka̱ ashe ìzun. ");
INSERT INTO yer_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mi ɓak oga mbin kà̱ mpyal ɓu kang mi bol aswari ɓu, te unəm uro kúr nnəm aɗom mbin ɓu ka̱t, a yà pa̱ u ɓa mpyal aYawe, Inan ɓu nva̱ng pa̱ nshatɗing nza̱ ìzun nggo. ");
INSERT INTO yer_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","<<Kang wa yichi nzəngkəng ngga nəm ká̱ anyer ka̱ awalang ava̱ ɓu na nləfər iya̱mkang á mi ka̱t. Kang wa re nləfər ngga nggantal á chu ìpin ìkpa̱kkpa̱k ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","<<Wa ɓa ká̱ oga awar anəna̱n aga nggəshi ìram ɓu kà̱ ǹzhi aYawe, Inan ɓu. <<Kang wa pə́k iya aɓəl ka̱t te ìtam iva̱ kà̱ mma mbyal ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","UYawe là ûMusa kpa pa̱, <<Lir oga nnap-nlà nva̱ ta̱, ka̱kul ka̱ atak oga nnap-nlà nva ta̱ n yar nsar nnap-nlà ká̱ ɓu kang ká̱ oIsa̱rila.>> ");
INSERT INTO yer_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","UMusa təm ka̱ta ká̱ uYawe nra ìsəm pa̱ ineɗing ká̱ ìzwam ìsəm pa̱ ineɗing, á ri ka̱t á wá ka̱t. Te uza̱ lir oga nsar nnap-nlà ka̱ apal oga achuchwal ìpang, nna nnap mpakpak ngga ngba̱pchi. ");
INSERT INTO yer_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Nva̱ uMusa fər ka̱ apal aɓam aSinayi ká̱ oga achuchwal ìpang pa̱ iparəm iga nnap nshetshet ka̱ awo wò te, asa̱l awúwu kà̱ aməlamməlam ka̱kul uza̱ kà̱ là nnap ká̱ uYawe, kang uza̱ nyi ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Nva̱ngva̱ uHaruna ka̱ nkpaktak onəm oIsa̱rila ya asa̱l awu áMusa aməlam te, ayər nəm oza̱ kà̱ ngga ndatkulung ká̱ na. ");
INSERT INTO yer_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ká̱ nnà te, uMusa wór oza̱, kang uHaruna ká̱ nkpaktak onəm oga mpyal mɓut onəm le ɓa atətak, kang uMusa là nnap ká̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ka̱ nvəva̱ng nva̱ ta te, nkpaktak oIsa̱rila ɓa dat, te uMusa na nkpaktak oga nnap mpakpak nva̱ uYawe na á na ka̱ apal aɓam aSinayi. ");
INSERT INTO yer_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Nva̱ngva̱ uMusa gba̱l ká̱ nlà nnap ká̱ oza̱ te, uza̱ dang asa̱l awuwu ká̱ iya̱m iga ndang ishi. ");
INSERT INTO yer_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ká̱ nnà te, awalang ava̱ káp uMusa i ga mpyal aYawe pa̱ ô là nnap ká̱ na te, uza̱ i yar iya̱m iga ndang ishi iva̱ ta i le. Kang nva̱ngva̱ uza̱ i fa te, uza̱ là oIsa̱rila iya̱m iva̱ uYawe kà̱ nak na, ");
INSERT INTO yer_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","kang oIsa̱rila i ya asa̱l awu áMusa i məlam. Te uMusa i dang asa̱l awu wò ká̱ iya̱m iga ndang ishi, ya uza̱ i le i ga nlà nnap ká̱ uYawe kà̱ɗi kang. ");
INSERT INTO yer_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","UMusa wór mɓut nkpaktak oIsa̱rila là ôza̱ pa̱, <<Oga iya̱m iva ta̱ uYawe nak wo pa̱ ó nəm. ");
INSERT INTO yer_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","O nəm inok ka̱ apal nra pa̱ nkpa̱ɗing kang ilum iga ifangshat nnyi te, i yá asati ilum iga njul, i yə́ryər ûYawe. Unəm uva̱ i nəm inok kà̱ ilum iva̱ ta te, mí gba̱l na. ");
INSERT INTO yer_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ko apər te ó ma̱k ka̱ ashe oga nzhi wó kà̱ ilum asati ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Te uMusa là nkpaktak oIsa̱rila pa̱, <<Iya̱m iva ta̱ uYawe nak chit pa̱ mmá nəm. ");
INSERT INTO yer_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","O kwap iya̱m iɓutɓut ûYawe. Re unəm uva̱ yəyar kà̱ ìgwak wò te, uza̱ á ɓa ká̱ azənariya, aazurfa, ká̱ acham arəzang, ");
INSERT INTO yer_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ká̱ iya̱m iga ndəng izər ivyau, ká̱ iga mɓan pa̱ ga̱r, ká̱ irəzang, ká̱ alinin anəna̱n, ka̱ akpap iɓəl, ");
INSERT INTO yer_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ká̱ awá inagám va mmá ɓán ká̱ ǹzazí, ká̱ awá iɓəl anəna̱n ká̱ akun akasiya, ");
INSERT INTO yer_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ká̱ mmì ka̱kul apitila, ká̱ iya̱m iga nggòl iya̱m ka̱kul mmì ngga nggar onəm, ká̱ iya̱m inəngnəng ichángchàng, ");
INSERT INTO yer_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ipáng iza̱mza̱m ká̱ oga ipáng iro iva mi mɓam i dàt ka̱ izər ìlukwan ìkwoksok ká̱ mpuluk. ");
INSERT INTO yer_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","<<Nkpaktak onəm oga nnyi inok awo ka̱ ashe wó á ɓa á nəm nza̱ iya̱m nggo va̱ uYawe nak pa̱ mmá nəm, ");
INSERT INTO yer_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","aghal áYawe ká̱ iya̱m iga nggugún, ká̱ iya̱m iga nzùzong ká̱ ndədar, ká̱ ndədar nnárnàr, ká̱ ndədang, ká̱ atak mmùmwak, ");
INSERT INTO yer_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ká̱ akwati aga nsar nnap-nlà, ká̱ ídari iga ǹyəyar, ká̱ iya̱m iga nkukuk, ká̱ atani aga nká Atak Ayə́ryər ava ji, ");
INSERT INTO yer_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ká̱ atebəl, ká̱ ídari iga ǹyəyar, ká̱ nkpaktak oga iyəya̱m, ká̱ nzəngkəng áYawe, ");
INSERT INTO yer_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ká̱ ìdari apitila ká̱ oga iyəya̱m, ká̱ oga apitila, ká̱ mmì ka̱kul nghan atak, ");
INSERT INTO yer_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ká̱ atak nshì iya̱m inəngnəng ichángchàng, ká̱ oga nkpá nggankpá nggang, ká̱ mmì ngga nggəgar, ká̱ iya̱m inəngnəng ichángchàng iga nshì, ká̱ atani aga nggún anung asa̱l aghal áYawe, ");
INSERT INTO yer_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ká̱ atak awop aga nshì iya̱m awop, ká̱ ìcha iga ngwàng iya̱m, ká̱ oga ídari iga ǹyəyar, ká̱ oga iyəya̱m, ká̱ asu achumchum, ká̱ akəkar, ");
INSERT INTO yer_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ká̱ oga atani aga agəla̱n, ká̱ ídari iga mmùmwak, ká̱ atak mwak oza̱, ká̱ atani anung asa̱l aga ntar ashe agəla̱n, ");
INSERT INTO yer_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ká̱ oga akun aga mpak aghal ká̱ agəla̱n, ká̱ oga asang oza̱, ");
INSERT INTO yer_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ká̱ ílukwan inəna̱n iloklòk iva onəm oga mpyal awop í mwak ka̱kul nnəm inok ka̱ ashe Atak Ayə́ryər, ká̱ ílukwan iyə́ryər ka̱kul aHaruna, unəm uga mpyal awop, ká̱ íji ovəvan onunggwan onəm oga mpyal awop.>> ");
INSERT INTO yer_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Te nkpaktak oIsa̱rila re atak aMusa, ");
INSERT INTO yer_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","kang nkpaktak unəm uva yəyar kà̱ ìgwak wò pa̱ o nəna te, a ɓa ká̱ iya̱m inana ûYawe, ka̱kul mpak aghal aYawe. Kang oza̱ ɓa ká̱ iza̱ nggo iva̱ mmá ɗom ka̱kul nnəm awop, kang ka̱kul nnəm ílukwan ánəm uga mpyal awop kpa. ");
INSERT INTO yer_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Nkpaktak onunggwan ká̱ ochar ova̱ yəyar kà̱ ìgwak ɓa ká̱ oga iya̱m ìsham, oga nkalɓang azənariya ngga ifang, ká̱ ngga achwang, ká̱ ishuwa ishak. Oza̱ na iya̱m pa̱ ɗongɗong iga azənariya iya̱m inana iga ǹyegye ûYawe. ");
INSERT INTO yer_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Unəm uva kpaktak uwa yà ká̱ afini aga ndəng izər ivyau, ká̱ arəzang pa̱ ga̱r, ká̱ arəzang, ká̱ alinin anəna̱n, ká̱ akpap iɓəl, ká̱ oga awá ítam aga mɓán ká̱ ǹzazí, ɓa ká̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ovəngva̱ ká̱ aazurfa ká̱ acham arəzang ɓa ká̱ uYawe, kang nza̱ uzəngtəng oza̱ nggo nva̱ ká̱ akun akasiya aɓyenɓyen ka̱kul nza̱ inok nggo ɓa ká̱. ");
INSERT INTO yer_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Nkpaktak ochar ova̱ ká̱ aghan aga nlòk iya̱m ɓa ká̱ iya̱m iva̱ oza̱ lòk ká̱ awo oza̱, afini anəna̱n aga ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ arəzang, ká̱ ìlukwan alinin anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Nkpaktak ochar oga aghan va̱ lwom oza̱ ka̱ ashe ìgwak lòk akpap íɓəl. ");
INSERT INTO yer_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Onəm oga mpyal ɓa ká̱ ipáng iza̱mza̱m ká̱ oga ipáng íro inəna̱n pa̱ mmá ɓàm ka̱ apal ìya ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Oza̱ ɓa ká̱ oga iya̱m iga nggòl iya̱m kang ká̱ mmì ka̱kul apitila, ká̱ mmì ngga nggar onəm, ká̱ oga iya̱m inəngnəng ichángchàng. ");
INSERT INTO yer_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Nkpaktak oIsa̱rila onunggwan ká̱ ochar ova̱ ɗom pa̱ ó na iya̱m inana ka̱kul inok áYawe va̱ nak ka̱ atak áMusa te, oza̱ ɓa ká̱ iya̱m inana iga nɗom ìgwak oza̱ ûYawe. ");
INSERT INTO yer_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Te uMusa là ôIsa̱rila pa̱, <<O dər, uYawe yak uBezalel chit uya aUri ukà aHur ka̱ akum ìjili aYahuda. ");
INSERT INTO yer_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Uza̱ yə́l na chit ká̱ aRuhu Inan, á na aghan á na, ká̱ nkpán ìpir nnap ká̱ nnyi nnəm nza̱ apir inok awo nggo, ");
INSERT INTO yer_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","pa̱ uza̱ á fa ká̱ iya̱m nnəm pa̱ ɗongɗong iga azənariya, ká̱ aazurfa, ká̱ acham arəzang, ");
INSERT INTO yer_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ká̱ nnyi nggyòk ipáng ka̱kul atak aga ndədat, ká̱ nnyi nkpa akun kang á nnyi nnəm nza̱ apir inok nggo. ");
INSERT INTO yer_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","UYawe nak chit kà̱ igugwak pa̱ uza̱ á ɗyang, uza̱ ká̱ uOholiyap uya aAhisamak ka̱ akum ìjili aDan. ");
INSERT INTO yer_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Uza̱ yə́l oza̱ chit ká̱ aghan aga nnəm nza̱ apir inok nggo wa nkyen nza̱m, ká̱ nlulok ká̱ afini aga ndəng izər ivyau, ká̱ arəzang pa̱ ga̱r, ká̱ arəzang, ká̱ alinin anəna̱n, kang ká̱ ílukwan ikak. Oza̱ nyi nza̱ apir inok nggo nyi iva mmá ɗuɗom ka̱ ashe inok onəm oga inok. ");
INSERT INTO yer_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","<<Te uBezalel ká̱ uOholiyap ká̱ nza̱ unəm uga aghan nggo uva uYawe na aghan ká̱ nnyi nnəm nza̱ apir inok nggo te, oza á ɗa̱mshi Atak Ayə́ryər wa nva uYawe nak.>> ");
INSERT INTO yer_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Te uMusa wór uBezalel ká̱ uOholiyap ká̱ nza̱ unəm nggo nva̱ uYawe na nnyi á na ká̱ aghan aga inok awo, uva lwom na kà̱ ìgwak pa̱ ô ɓa ô nəm inok iva̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Te oza̱ ka̱m nkpaktak iya̱m iɓutɓut ka̱ atak áMusa iva oIsa̱rila ɓa ká̱ ka̱kul nnəm ka̱ Atak Ayə́ryər. Kang oza̱ ga mpyal ká̱ mɓa ká̱ iya̱m inana iga nɗom ìgwak ûMusa nza̱ ìpin nggo. ");
INSERT INTO yer_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Te nkpaktak onəm oga nnyi inok awo va̱ ka̱ yà kà̱ nnəm inok ka̱ Atak Ayə́ryər, nza̱ unəm nggo ka̱ atak inok iva̱ oza̱ kà̱ nnənəm re, ");
INSERT INTO yer_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","kang à ɓa là ûMusa pa̱, <<Onəm kà̱ mɓa ká̱ iya̱m inok watar iva̱ mmá ɗom ka̱kul ngba̱l inok va̱ uYawe nak pa̱ mmá nəm.>> ");
INSERT INTO yer_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Te uMusa nák nre ga ashe apa̱k pa̱, <<Ónunggwan ká̱ ochar, kang unəm uro a ɓa ká̱ iya̱m inana iro lap ka̱kul nnəm Atak Ayə́ryər ka̱t.>> Nna chit te onəm re mɓa ká̱ iya̱m ɗak. ");
INSERT INTO yer_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Iya̱m va̱ mmá ɓa ká̱ chit te, mməmak kúr ngba̱l nkpaktak inok va̱ ta aga watar. ");
INSERT INTO yer_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Nkpaktak onəm oga nnyi inok awo va̱ ka̱ ashe onəm oga nnəm inok nəm aghal áYawe. Oza̱ nəm ká̱ oga atani pa̱ agba̱pchi nlòk alinin anəna̱n, ká̱ afini aga ndəng izər ivyau, ká̱ arəzang pa̱ ga̱r, ká̱ arəzang, ká̱ ala̱ka̱n oga akerup ka̱ izəzər va unəm uga nnyi inok awo à nəm. ");
INSERT INTO yer_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Nza̱ atani nggo te, ngwuwang ashar ìsəm pa̱ ineɗing ama̱n pa̱ aparəm, kang mbəbal ashar pa̱ akpa̱ɗing. Nkpaktak oga atani va̱ ta nrup oza̱ mal izər. ");
INSERT INTO yer_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Oza̱ gwang atani pa̱ atukun ka̱ izər awan oza̱ yà pa̱ zəng kang aɓo aga atukun uza̱ gwang ka̱ izər awan oza̱ na kpa yà pa̱ zəng. ");
INSERT INTO yer_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Oza̱ nəm oga mɓol afini ndəng izər ivyau ka̱ anung atani aga nggəshi ka̱ agbai kang à nəm iya̱m zəngtəng va ta ka̱ anung atani apəpar ka̱ agbai. ");
INSERT INTO yer_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Oza̱ nəm oga mɓol ìsəm pa̱ ìtukun ka̱ apal atani aga nggəshi ka̱ agbai, kang oga mɓol ìsəm pa̱ ìtukun ka̱ arwangchwang atani aga apəpar na oga mɓol va̱ ta á mal ìkwoksok ká̱ owan oza̱. ");
INSERT INTO yer_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Te oza̱ nəm oga iya̱m iga nkam atani iga azənariya ìsəm pa̱ ìtukun ka̱kul ngwang oga atani ka̱ izər awan oza̱, na aghal áYawe va̱ ta á yà iya̱m pa̱ izəng. ");
INSERT INTO yer_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Oza̱ nəm oga atani aga akpap íɓəl pa̱ gba̱pchi ama̱n pa̱ zəng ka̱kul nggún apal ishi aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Nza̱ atani nggo ngwuwang ashar ìsəm pa̱ ìneɗing ama̱n pa̱ atukun kang mbəbal nnyi te ashar pa̱ kpa̱ɗing. Nkpaktak atani aga agba̱pchi ama̱n pa̱ zəng ava̱ ta á mal izər. ");
INSERT INTO yer_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Oza̱ gwang oga atani pa̱ tukun va̱ ta ka̱ anung zəngtəng kang aga akpa̱ɗing ka̱ anung zəngtəng. ");
INSERT INTO yer_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Oza̱ nəm oga mɓol ìsəm pa̱ ìtukun ka̱ arwangchwang atani aga nggəshi ka̱ agbai, kang oga mɓol ìsəm pa̱ ìtukun ka̱ aranchwang aga apəpar. ");
INSERT INTO yer_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Oza̱ nəm oga iya̱m iga nkam atani iga acham arəzang ìsəm pa̱ ìtukun, na á iya̱m iga ndədang pa̱ izəng. ");
INSERT INTO yer_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Oza̱ nəm iya̱m iga nggún aghal ka̱ awá itám va mmá ɓan ká̱ ǹzazí, kang ká̱ aga ndang apəpal ká̱ awá iɓə́l anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Oza̱ nəm oga ndar akasiya aga ntong nzwang ka̱kul aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Nza̱ ngwang ndar va̱ ta nggo te, ashar pa̱ gba̱pchi ama̱n pa̱ tukun, mbəbal ashar pa̱ parəm ká̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Nza̱ ndar nggo te, mmá nəm ká̱ nchak pa̱ mparəm ka̱kul nggwang ngwuwan. Oza̱ nəm nkpaktak oga ndar aghal áYawe wa nnà ta. ");
INSERT INTO yer_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Oza̱ nəm oga ndar ìsəm pa̱ iparəm ka̱kul asa̱l nkwandal aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Oza̱ nəm oga atak mmùmwak aga aazurfa ìsəm pa̱ ìneɗing ka̱ akum ndar ngga ìsəm pa̱ iparəm va̱ ta. Atak mmùmwak pa̱ mparəm ka̱ akum nza̱ ndar nggo ka̱kul nggwang ncà nggangcà nggang ngga mparəm, kang wa nnà ta, atak mmùmwak pa̱ mparəm ka̱kul oga ǹcà nggang ndar nzəngtəng. ");
INSERT INTO yer_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ka̱ ngba̱k asa̱l mpal aghal áYawe te, oza̱ nəm oga ndar ìsəm pa̱ iparəm, ");
INSERT INTO yer_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ká̱ oga atak mmùmwak aga aazurfa ìsəm pa̱ ineɗing. Atak mmùmwak pa̱ mparəm ka̱ akum nza̱ ndar nggo. ");
INSERT INTO yer_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Oza̱ nəm oga ndar pa̱ nkpa̱ɗing ka̱ asa̱l nsəm aghal áYawe, ka̱ asa̱l ntar alum. ");
INSERT INTO yer_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Oza nəm oga ndar nro kà̱ɗi pa̱ mparəm ka̱kul nggulyanggu ngga mparəm ngga nsəm aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kà̱ nggulyanggu ngga mparəm nva̱ ta oza̱ agwang ka̱ akum kang à pá ìkan á na ka̱ apal á yà iya̱m pa̱ izəng ka̱ apal. Iya̱m va ta̱ oza̱ nəm. ");
INSERT INTO yer_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Oga ndar nva̱ oza̱ nəm pa̱ kpaktak ka̱ nsəm aghal te, pa̱ nna̱nne ká̱ atak mwak oza̱ ngga aazurfa pa̱ gba̱pchi ama̱n pa̱ kpa̱ɗing, pa̱ mparəm ka̱ akum nza̱ ndar nggo. ");
INSERT INTO yer_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Oza̱ nəm oga ndar nnárnàr ngga akun akasiya pa̱ ntukun ka̱kul aghal áYawe ka̱ ngba̱k nggəshi, ");
INSERT INTO yer_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ndar nnárnàr pa̱ ntukun ka̱kul ngba̱k nzəngtəng, kang ndar nnárnàr pa̱ ntukun ka̱kul nsəm aghal áYawe, ka̱ asa̱l ntar alum. ");
INSERT INTO yer_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Oza̱ nəm ndar ngga ishimshe nnárnàr, nva ɓan kà̱ ngba̱k nro ga chu nro. ");
INSERT INTO yer_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Oza ɓam oga ndar nva̱ ta ká̱ azənariya, kang à nəm oga nkalɓang ngga nkpán oga ndar nnárnàr nva̱ ta ká̱ azənariya, kang à ɓam ndar nnárnàr nva̱ ta ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Te oza̱ nəm atani aga afini ndəng izər ivyau, ka̱ arəzang pa̱ ga̱r, ká̱ arəzang, ká̱ alinin anəna̱n. Oza̱ lòk ká̱ ala̱ka̱n oga akerup ka̱ izəzər, inok ánəm uga nnyi inok awo. ");
INSERT INTO yer_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Oza̱ nəm ndar pa̱ nneɗing ngga akun akasiya kang à ɓam oza̱ ká̱ azənariya, ká̱ iya̱m iga nzùzong ngga azənariya, kang oza̱ nəm atak mwak oza̱ aga aazurfa pa̱ neɗing. ");
INSERT INTO yer_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Oza̱ nəm atani aga anung asa̱l aghal ká̱ afini aga ndəng izər ivyau, ká̱ arəzang pa̱ ga̱r, ká̱ arəzang, ká̱ alinin anəna̱n, ava mmá lòk ɓyen pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Oza̱ nəm oga ndar pa̱ ntukun ká̱ oga iya̱m iga nzong oza̱. Oza̱ ɓam ishi oza̱ ká̱ iya̱m iga nran oza̱ ká̱ azənariya, kang oza̱ nəm atak mwak oza̱ pa̱ tukun ká̱ acham arəzang. ");
INSERT INTO yer_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","UBezalel nəm akwati aga nsar nnap-nlà ká̱ akun akasiya, ngwuwang ashar pa̱ shatɗing ká̱ aɓuɓo, mbəbal ashar pa̱ parəm ká̱ aɓuɓo, nrurup ashar pa̱ parəm ká̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Uza̱ ɓam ká̱ azənariya anəna̱n ka̱ ashe ká̱ nsəm, kang à me anunung gang ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Uza̱ lá oga nkalɓang azənariya pa̱ nneɗing kang à ran oza̱ ká̱ ka̱ ashar aga nneɗing, oga nkalɓang pa̱ parəm nza̱ ngba̱k nggo. ");
INSERT INTO yer_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Te uza̱ nəm oga ndar akun akasiya kang à ɓam oza̱ ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Uza̱ mwak oga ndar nva̱ ta ka̱ ashe oga nkalɓang nva̱ ka̱ oga ngba̱k akwati ka̱kul ǹyəyar. ");
INSERT INTO yer_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Te uza̱ nəm anung akwati ava̱ ta ká̱ azənariya anəna̱n, ngwuwang ashar pa̱ shatɗing ká̱ aɓuɓo, kang mbəbal ashar pa̱ parəm ká̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Uza̱ lá oga akerup pa̱ parəm ká̱ azənariya kà̱ nkùr anung arwangchwang akwati ava̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","AKerup pa̱ zəng kà̱ ngba̱k nro, kang akerup pa̱ azəng kà̱ nkùr ngba̱k nzəngtəng. Uza̱ lá oga akerup ká̱ iya̱m izəngtəng ká̱ anunung. ");
INSERT INTO yer_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Oga akerup ava̱ ta ɓol oga abasəm oza̱ ka̱ apal kuk anung akwati. Asa̱l awu oga akerup va̱ ta i dər owan oza̱ ka̱ apal anung akwati. ");
INSERT INTO yer_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","UBezalel nəm atebəl aga akun akasiya, ngwuwang ashar pa̱ shatɗing, mbəbal ashar pa̱ zəng ká̱ aɓuɓo, kang nrurup ashar pa̱ parəm ká̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Uza̱ ɓam izəzər ka̱ azənariya anəna̱n kang à me anunung gang ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Uza̱ nəm ìɗər wa mbal awo gang aranchwangranchwang, kang à me azənariya ka̱ apəpal. ");
INSERT INTO yer_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Uza̱ lá oga nkalɓang azənariya pa̱ nneɗing ka̱kukul, kang uza̱ gwang oza̱ ka̱ izər oga arwangchwang atebəl va̱ ta ka̱ atak ashishar. ");
INSERT INTO yer_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Oga nkalɓang va̱ ta mmá mwak datkulung ká̱ ìɗər ka̱kul oga ndar ngga ǹyàr atebəl ava̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Uza̱ nəm oga ndar akun akasiya ka̱kul ǹyàr atebəl, kang à ɓam izər oza̱ ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Uza̱ nəm oga iya̱m inok iga apal atebəl pa̱ kpaktak ká̱ azənariya anəna̱n. Omà oga adakdai, ká̱ asu, ká̱ ibəchi, ka̱kul nnak iya̱m inana iwawa. ");
INSERT INTO yer_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Uza̱ nəm idari apitila ka̱ azənariya anəna̱n, uza̱ lá ìjilijili ká̱ idaridari, ká̱ oga ásusu, ká̱ mɓənggúmɓənggum, ká̱ mbəba̱l, ká̱ iya̱m izəngtəng. ");
INSERT INTO yer_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Idari apitila va̱ ta chak ìgwong pa̱ ìkpa̱ɗing ka̱ izər idari iga ishimshe. Ìgwong pa̱ ishatɗing kà̱ ngba̱k nro kang pa̱ ishatɗing kà̱ ngba̱k nzəngtəng. ");
INSERT INTO yer_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ká̱ oga asu pa̱ shatɗing wa mɓənggum mba̱l ka̱ apal ìgwong iga nggəshi, pa̱ ishatɗing kà̱ ìgwong ìro, wa nnà ta kà̱ nkpaktak oga igwong iga ìkpa̱ɗing ka̱ izər idari apitila va̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ka̱ izər idari apitila te, oga asu pa̱ neɗing wa mɓənggum, ká̱ mɓənggum, ká̱ oga mba̱l, ");
INSERT INTO yer_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ká̱ mɓənggum ka̱ avəng nchak igwong iga iparəm ngga nggəshi, mɓənggum ka̱ avəng nchak igwong iga iparəm ngga mparəm, kang mɓənggum ka̱ avəng nchak igwong iga iparəm ngga nshatɗing, wa nnà ta ka̱ anung nchak igwong iga iparəm iga ishatɗing va̱ ta ka̱ izər idari apitila. ");
INSERT INTO yer_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Nkpaktak oga mɓənggumɓənggum, ká̱ oga igugwong, ká̱ idari apitila mmá lá ká̱ azənariya anəna̱n ká̱ iya̱m izəngtəng. ");
INSERT INTO yer_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Uza̱ nəm oga apitila pa̱ fangshat ka̱kul idari apitila, kang uza̱ nəm mɓəmɓəmɓəmɓəm, ká̱ asusu ká̱ azənariya anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Uza̱ nəm ìdari apitila va̱ ta ká̱ nkpaktak oga iya̱m inunok ká̱ azənariya va iɗəɗək ashekel ìkalong pa̱ ishatɗing. ");
INSERT INTO yer_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Uza̱ nəm atak nshì iya̱m inəngnəng ichángchàng ká̱ akun akasiya. Ngwuwang ashar pa̱ zəng ká̱ aɓuɓo, mbəbal ashar pa̱ zəng ká̱ aɓuɓo, kang nrurup ashar pa̱ shatɗing. Oga agbəshigbəshi mmá nəm ká̱ iya̱m izəngtəng. ");
INSERT INTO yer_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Uza̱ ɓam apəpal, ká̱ nkpaktak ngbəgba̱k, ká̱ oga agbəshi ká̱ azənariya anəna̱n, kang à me ìɗər gang arwangchwang. ");
INSERT INTO yer_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Uza̱ nəm nkalɓang azənariya pa̱ mparəm kà̱ nza̱ ngba̱k nggo kang à mwak ka̱ avəng ìɗər ka̱kul oga ndar ngga ǹyəyar. ");
INSERT INTO yer_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Uza̱ nəm oga ndar ngga ǹyəyar kang à ɓam ká̱ azənariya. ");
INSERT INTO yer_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Te uza̱ nəm mmì nyə́ryər ngga nggor, ká̱ iya̱m inəngnəng ichángchàng, inok ánəm uga nggwang iya̱m inə́ngnəng ichángchàng kpa. ");
INSERT INTO yer_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","UBezalel nəm atak nshi iya̱m awop aga nshì iya̱m inana ká̱ akun akasiya, ngwuwang ashar pa̱ fangshat ká̱ aɓuɓo, mbəbal ashar pa̱ fangshat ká̱ aɓuɓo, kang nrurup ashar pa̱ neɗing ká̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Uza̱ nəm agbəshi pa̱ zəng kà̱ nza̱ nggulyanggugulyanggu ngga nneɗing nggo, oga agbəshi va̱ ta ká̱ atak nshì iya̱m awop yà iya̱m zəngtəng, kang uza̱ ɓam ka̱ acham arəzang. ");
INSERT INTO yer_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Te uza̱ nəm oga iya̱m inok ka̱kul atak nshì iya̱m awop va̱ ta, omà oga ngbət, ká̱ oga ashefər, ká̱ oga asu, ká̱ oga iga̱pchi iga ifang, ká̱ oga asu apər. Nkpaktak oza̱ nnəm acham arəzang. ");
INSERT INTO yer_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Uza̱ nəm alariya ká̱ acham arəzang pá ka̱ akum alə̀gər nkap ishimshe atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Te uza̱ lá nkalɓang pa̱ nneɗing kà̱ nggulyanggu ngga nneɗing ká̱ izər alariya aga acham arəzang va̱ ta ka̱kul nkpán oga ndar. ");
INSERT INTO yer_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Uza̱ nəm oga ndar ká̱ akun akasiya kang à ɓam oza̱ ka̱ acham arəzang. ");
INSERT INTO yer_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Te uza̱ mwak oga ndar va̱ ta ká̱ ashe oga nkalɓang ká̱ ngba̱k atak nshì iya̱m awop ka̱kul ǹyəyar. Uza̱ nəm atak nshì iya̱m awop va̱ ta awulong ká̱ akun. ");
INSERT INTO yer_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Kang uza̱ nəm asu aga acham arəzang ka̱kul nnàl awo ká̱ ashar kang izəzan iga acham arəzang ka̱ atak oga agəlat ochar va i nəm inok ka̱ anung Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","UBezalel nəm agəla̱n ava mmá ká ká̱ atani aga alinin anəna̱n. Ka̱ asa̱l nkwandal te, ngwuwang ashar ìgba̱l pa̱ izəng ká̱ ìsəm pa̱ ìtukun. ");
INSERT INTO yer_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Uza̱ nəm oga ndar ka̱kul atani ìsəm pa̱ ìparəm ká̱ oga atak mmùmwak ngga acham arəzang ìsəm pa̱ ìparəm, kang ká̱ oga iya̱m iga nzuzong ká̱ iga nrəran iga aazurfa. ");
INSERT INTO yer_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Uza̱ nəm oga atani aga asa̱l mpal, ngwuwang ashar igba̱l ka̱ ìsəm pa̱ ìtukun na kpa, ká̱ oga ndar oza̱ ìsəm pa̱ iparəm, ka̱ oga atak mmwàk oza̱ ngga acham arəzang ìsəm pa̱ iparəm, kang ká̱ oga iya̱m iga nzuzong, ká̱ iga nrəran iga aazurfa. ");
INSERT INTO yer_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Uza̱ nəm oga atani ava̱ ka̱ asa̱l ntar alum, mbəbal ashar ìsəm pa̱ ìfangshat ama̱n pa̱ tukun, ká̱ oga ndar oza̱ pa̱ ngba̱pchi, ká̱ oga atak mmùmwak pa̱ ngba̱pchi, kang ká̱ oga iya̱m iga nzuzong ká̱ iga nrəran iga aazurfa. ");
INSERT INTO yer_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ka̱ asa̱l nfa alum te, mbəbal ashar ìsəm pa̱ ifangshat ama̱n pa̱ tukun. ");
INSERT INTO yer_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kà̱ ngba̱k ngga nzəng ngga asa̱l aga ntar uza̱ nəm oga atani aga nzuzong, ngwuwang ashar ìsəm pa̱ ìparəm ama̱n pa̱ parəm ká̱ aɓuɓo, ká̱ oga ndar oza̱ pa̱ nshatɗing ká̱ atak mmwàk oza̱ pa̱ nshatɗing. ");
INSERT INTO yer_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Kang kà̱ ngba̱k nzəntəng, uza̱ nəm oga atani ngwuwang ashar ìsəm pa̱ ìparəm ama̱n pa̱ parəm ká̱ aɓuɓo, ká̱ oga ndar oza̱ pa̱ nshatɗing ká̱ oga atak mmwàk oza̱ pa̱ nshatɗing. ");
INSERT INTO yer_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Nkpaktak oga atani va̱ gáng agəla̱n aghal va̱ ta mmá nəm ká̱ alinin aloklòk anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Oga atak mmwàk oga ndar va̱ ta mmá nəm ká̱ acham arəzang, ká̱ oga atak nzuzong ká̱ oga iya̱m iga nrəran iga aazurfa. Apal oza̱ mmá ɓam ká̱ aazurfa, kang nkpaktak oga ndar agəla̱n va̱ ta mmá ran ká̱ oga nkalɓang ngga aazurfa. ");
INSERT INTO yer_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Uza̱ nəm atani aga anung asa̱l agəla̱n va̱ ta uza̱ lok ká̱ alinin anəna̱n aga ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ arəzang, ká̱ alinin anəna̱n, kang ngwuwang ashar ìsəm pa̱ ishatɗing kang nrurup ashar pa̱ ìfangshat ká̱ aɓuɓo wa nrup atani aga agəla̱n. ");
INSERT INTO yer_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Mmá təp atani ava̱ ta ká̱ ndar pa̱ nneɗing ká̱ atak aga mmwàk oza̱ ngga acham arəzang, ká̱ oga iya̱m iga nzong oza̱, ká̱ iga nrəran iga aazurfa, kang mmá ɓam apal oza̱ ká̱ aazurfa. ");
INSERT INTO yer_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Nkpaktak oga iya̱m iva̱ mmá mpak aghal áYawe ká̱, kang ká̱ agəla̱n te, mmá nəm ká̱ acham arəzang. ");
INSERT INTO yer_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ǹlir ìyəl oga iya̱m iga nəm aghal áYawe nnà ta̱, aghal aga nnap mpakpak nva uMusa nak mmá lir. UMusa nak oLawi ova ka̱ nəm inok ka̱ avəng aItama uya aHaruna, unəm uga mpyal awop, pa̱ á lir ìyəl iya̱m iga nəm aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","UBezalel uya aUri, ukà aHur, uga akum aYahuda, nəm nkpaktak iya̱m iva̱ uYawe là ûMusa. ");
INSERT INTO yer_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Nzəng ká̱ unəm uga ka̱m ishishi, uOholiyap uya aAhisamak uga akum aDan, unəm uga nnyi nggyok iya̱m, nlir nza̱m iya̱m, ká̱ nlok iya̱m ká̱ afini ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ arəzang, ká̱ alinin anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Nkpaktak azənariya va̱ mmá me Atak Ayə́ryər ká̱ te, ka̱ ashe iya̱m inana iga ǹyegye, iɗəɗək ashekel ìkalong ìsəm pa̱ ìna̱nne ama̱n pa̱ fangshat ka̱ ashekel ìgba̱l pa̱ ìfangshat ka̱ ìsəm pa̱ ishatɗing, á mal ká̱ ashekel aga Atak Ayə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ìyəl aazurfa va̱ mmá ya ka̱ atak nkung ìyəl mɓut oIsa̱rila te, iɗəɗək ashekel ìkalong ìgba̱l pa̱ ishatɗing ká̱ ama̱n pa̱ zəng, ká̱ ìgba̱l pa̱ ìfangshat ká̱ ìsəm pa̱ ifangshat ama̱n pa̱ tukun, á mal ká̱ ashekel aga Atak Ayə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Nza̱ unəm nggo na abəka pa̱ azəng, nna aɓo ashekel ka̱ atak mmák ashekel aga Atak Ayə́ryər, ka̱ anung á nza̱ unəm nggo va mmá lir ka̱ ashe nkung iyəl onəm oga ìkalong ìgba̱l pa̱ ìkpa̱ɗing ká̱ ama̱n pa̱ shatɗing, ká̱ ìgba̱l pa̱ ìtukun ká̱ ìsəm pa̱ ìtukun, á ɓan kà̱ unəm uga ìzun ìsəm pa̱ ìparəm. ");
INSERT INTO yer_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Mmá nəm inok ká̱ aazurfa ava ìɗəɗək ashekel ìkalong ìgba̱l pa̱ ishatɗing, nkpaktak oga atak aga mwak oga ndar ngga Atak Ayə́ryər ká̱ atani aga Atak Ayə́ryər ìgba̱l pa̱ ìzəng. Ìɗək ashekel ìkalong pa̱ ishatɗing iga aazurfa ka̱kul nza̱ atak mmwak nggo. ");
INSERT INTO yer_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Aɓo ashekel aga ìkalong pa̱ ìzəng ká̱ ìgba̱l pa̱ ìfangshat ká̱ ìsəm pa̱ ìfangshat ama̱n pa̱ tukun te, uBezalel nəm oga iya̱m iga nzong oga ndar ká̱ oga iya̱m iga nran oza̱ ká̱, kang á ɓam oga apal ndar. ");
INSERT INTO yer_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Acham arəzang iya̱m inana iga ǹyegye va̱ mmá ɓa ká̱ te, iɗəɗək ashekel ìkalong ìgba̱l pa̱ ìparəm ká̱ ugba̱pchi ama̱n pa̱ parəm ká̱ ìgba̱l pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ká̱ nnà ta uza̱ nəm oga atak mmwàk ka̱kul oga ndar ngga anung asa̱l aga aghal aYawe, ká̱ atak nshì iya̱m awop aga acham arəzang, ká̱ alariya aga acham arəzang, ká̱ nkpaktak iya̱m inunok, ");
INSERT INTO yer_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ká̱ oga atak mmwàk gang nkpaktak agəla̱n, ká̱ oga atak mmwàk atani ka̱ anung asa̱l aga ntar agəla̱n, ká̱ nkpaktak oga iya̱m iga mpak aghal áYawe, ká̱ agəla̱n. ");
INSERT INTO yer_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Onəm oga nnəm inok awo nəm oga ilukwan iyə́ryər inəna̱n iga ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ nrəzang iva unəm uga mpyal awop í pa ka̱kul nnəm inok ka̱ ashe Atak Ayə́ryər. Oza̱ nəm oga ilukwan iyə́ryər ka̱kul áHaruna, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Oza̱ nəm ìlukwan ìkwoksok iga azənariya ká̱ afini aga ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ nrəzang, ká̱ alinin anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Oza̱ lá azənariya pa̱ pileppilep kang oza̱ cha pa̱ səlen wa afini ka̱kul ntat kà̱ ishimshe alinin anəna̱n, kang ká̱ ishimshe ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, kang ká̱ afini arəzang, inok ánəm uga aghan. ");
INSERT INTO yer_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Oza̱ nəm iya̱m iga apal agar pa̱ mparəm ka̱kul ìlukwan ìkwoksok kang ɓam ka̱ ngba̱kgba̱k n ngga mparəm ka̱kul nrəran. ");
INSERT INTO yer_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Oza̱ nəm ngbat nnəna̱n ngga nrán ìlukwan ìkwoksok va̱ ta ká̱ iya̱m inok izəngtəng ká̱ azənariya, kang ká̱ afini aga ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ nrəzang, kang ká̱ alinin anəna̱n, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Oza̱ da̱mshi oga ipáng iza̱mza̱m ká̱ iya̱m iga nkpán oza̱ iga azənariya. Te oza̱ gyok aɗin ovan oIsa̱rila ka̱ apəpal. ");
INSERT INTO yer_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Te oza̱ ran oza̱ ka̱ apal iya̱m iga apal agar ìlukwan ìkwoksok, ipáng iga nrəng ká̱ akum oIsa̱rila pa̱ ìgba̱pchi ama̱n pa̱ parəm, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Oza̱ nəm ìya ìlukwan ìkwoksok ka̱ iya̱m inok izəngtəng iva mmá nəm ìlukwan ìkwoksok ká̱, ká̱ azənariya, kang ká̱ afini aga ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ arəzang, ká̱ alinin aloklòk anəna̱n. ");
INSERT INTO yer_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Oza̱ nəm ìya ìlukwan ìkwoksok va̱ ta, te mmá kup ngwuwang ká̱ mbəbal mal izər ká̱ mbal awo. ");
INSERT INTO yer_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Te oza̱ nəm atak ndàt ipang inəna̱n pa̱ nneɗing ka̱ apəpal. Ka̱ atak mwak ngga nggəshi te, ìpang irəzang iva̱ i ya atak pa̱ halakhalak, ká̱ ìpang iga ndəng ilur, kang ká̱ ìpang iga ndəng agwal ikun, ");
INSERT INTO yer_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ka̱ atak ndàt ngga mparəm te, ìpang iga ndəng izər ivyau, ká̱ ìpang ìkámkám, kang ká̱ ìpang ìfərfər wa apye. ");
INSERT INTO yer_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Kà̱ atak ndàt ngga nshatɗing te, ìpang iga ndəng ishàn, ká̱ ìpang ndəng awar agba̱k, kang ká̱ ìpang irəzang pa̱ ga̱r. ");
INSERT INTO yer_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Kang atak ndàt ngga nneɗing te, ìpang iga ndəng ilyanggu, ká̱ ìpang iza̱mza̱m, kang ká̱ ìpang iga ndəng ipəpa. Nkpaktak oga ipang va̱ ta̱ mmá mwak ka̱ ashe iya̱m iga nkpəkpán iga azənariya. ");
INSERT INTO yer_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Nza̱ ìpang nggo iga igba̱pchi ama̱n pa̱ parəm va̱ ta ka̱ anung aɗin ovan oIsa̱rila, kang nza̱ ìpang nggo mmá gyok aɗin akum pa̱ zəng ka̱ izəzər wa asitam. ");
INSERT INTO yer_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Oza̱ nəm oga nzwar ngga azənariya anəna̱n ka̱kul ìya ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Kang oza̱ nəm nkalɓang ngga azənariya pa̱ mparəm, ká̱ iya̱m iga nkpəkpán pa̱ iparəm, kang oza̱ mwak nkalɓang nva̱ ta kà̱ nggulyanggu ngga mparəm ngga apal ìya ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Te oza̱ ran oga nzwar azənariya ngga mparəm va̱ ta kà̱ mɓol nkalɓang ngga mparəm nva̱ kà̱ nggulyanggu ìya ìlukwan ìkwoksok, ");
INSERT INTO yer_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","kang kà̱ ngba̱k ngga mparəm ngga anung oga nzwar nva̱ ta, oza̱ ran ka̱ izər iya̱m iga nkpəkpán kang oza̱ ran ka̱ iya̱m iga apal agar aga ìlukwan ìkwoksok ka̱ asa̱l mpyal. ");
INSERT INTO yer_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Te oza̱ nəm oga nkalɓang ngga azənariya pa̱ mparəm mwak kà̱ nggulyanggu ngga mparəm ngga asa̱l avəng ka̱ ashe aga ìya ìlukwan ìkwoksok dat ká̱ ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Oza̱ nəm oga nkalɓang azənariya pa̱ mparəm, kang oza̱ ran ka̱ asa̱l mpyal iya̱m iga apal agar ìlukwan ìkwoksok a datkulung ka̱ atak ngguwang kang ka̱ asa̱l apal ngbat. ");
INSERT INTO yer_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Te oza̱ ran oga nkalɓang ngga ìya ìlukwan ìkwoksok ká̱ oga nkalɓang ngga ìlukwan ìkwoksok ká̱ asang ngga ndəng izər ivyau, ka̱ asa̱l apal ngbat ngga nran ìlukwan ìkwoksok, na kang ìya ìlukwan ìkwoksok a ra nggang ka̱ izər ìlukwan ìkwoksok ka̱t, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Uza̱ nəm ìlukwan iwangwang iga avəng ìlukwan ìkwoksok ká̱ ìlukwan iga ndəng izər ivyau, inok ánəm uga nlok iya̱m. ");
INSERT INTO yer_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Mmá re mɓol kà̱ ishimshe ìlukwan iwangwang iva̱ ta wa mɓol ishak ìlukwan, mmá lok ishishak á gang pa̱ lat ka̱kul kang a cha ka̱t. ");
INSERT INTO yer_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Oza̱ nəm awar ikumkum ká̱ afini aga ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ arəzang kà̱ nkur ìlukwan iwangwang. ");
INSERT INTO yer_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Oza̱ nəm iɓa̱ngga̱ng ká̱ azənariya anəna̱n mwak kà̱ mbagar awar ikumkum gang kà̱ nkur ìlukwan iwangwang kà̱ ishimshe ikumkum iva̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Oza̱ dat iɓa̱ngga̱ng iva̱ ta ká̱ awar ikumkum kà̱ ishimshe owan oza̱ gang nkpaktak akum ìlukwan iwangwang iva̱ ta iga nnəm inok ánəm uga mpyal awop, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Oza̱ nəm ilukwan iga ashe iga alinin anəna̱n ûHaruna ká̱ ovəvan onunggwan, inok ánəm uga nlok iya̱m, ");
INSERT INTO yer_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ká̱ iya̱m ishi inəna̱n ka̱kul aHaruna kang ká̱ oga iya̱m ishi ka̱kul ovəvan aga alinin anəna̱n, ká̱ ìlukwan iga ashe nlok alinin anəna̱n, ");
INSERT INTO yer_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ká̱ ngbat nlòk alinin anəna̱n ká̱ afini aga ndəng izər ivyau, ká̱ nrəzang pa̱ ga̱r, ká̱ arəzang, inok ánəm uga nlok iya̱m, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Oza̱ nəm achuchwal iya̱m ishi anəna̱n aga azənariya te gyok iya̱m nlir ka̱ izəzər pa̱, <<UNəna̱n ûYawe.>> ");
INSERT INTO yer_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Te oza̱ pá asang aga ndəng izər ivyau kà̱ ka̱kul nran ka̱ apal iya̱m ishi, wa nva uYawe nak uMusa pa̱ á nəm. ");
INSERT INTO yer_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Wa nnà ta nkpaktak inok aghal áYawe, Aghal Mɓut á kur. OIsa̱rila nəm iza̱ nggo, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Te oza̱ ɓa ka̱ aghal áYawe ava̱ ta ûMusa, aghal ká̱ oga iya̱m inunok, oga iya̱m iga nzuzong, ká̱ oga ndar nsungsung, ká̱ oga ndar nnárnàr, ká̱ oga ndar, ká̱ oga atak mmùmwak, ");
INSERT INTO yer_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ká̱ oga awá inagam aga nggugún ava mmá ɓán ká̱ ǹzazí, ká̱ oga awá anəna̱n, ká̱ atani aga nká atak, ");
INSERT INTO yer_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ká̱ akwati aga nsar nnap-nlà ká̱ nkpá nggankpá nggang, ká̱ anunung, ");
INSERT INTO yer_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ká̱ atebəl ká̱ nkpaktak iya̱m inunok ka̱ nzəngkəng aYawe, ");
INSERT INTO yer_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ká̱ idari apitila iga azənariya anəna̱n, ká̱ oga apitilapitila, ká̱ nkpaktak iya̱m inunok, ká̱ mmì oga apitila, ");
INSERT INTO yer_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ká̱ atak nshì iya̱m awop aga azənariya, ká̱ mmì ngga nggar, ká̱ inə́ngnəng ichángchàng kang ká̱ atani aga anung asa̱l aghal, ");
INSERT INTO yer_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ká̱ atak nshì iya̱m awop aga acham arəzang, ká̱ alariya aga acham arəzang, ká̱ oga nkpà nggankpá nggang, ká̱ nkpaktak iya̱m inunok, ká̱ asu, ká̱ izəzan, ");
INSERT INTO yer_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ká̱ oga atani aga agəla̱n, ká̱ oga ndədar, ká̱ oga atak mmùmwak, ká̱ atani aga anung asa̱l agəla̱n, ká̱ oga asəsang, ká̱ oga iya̱m iga mpak aghal, ká̱ nkpaktak iya̱m iga nnəm inok ka̱ atak Aghal Mɓut, ");
INSERT INTO yer_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ká̱ ilukwan iloklok inəna̱n ka̱kul nnəm inok ka̱ ashe Atak Ayə́ryər, ilukwan iyə́ryər ka̱kul áHaruna unəm uga mpyal awop ká̱ ìlukwan ka̱kul ovəvan na oza̱ á nəm inok onəm oga nshì iya̱m awop ká̱. ");
INSERT INTO yer_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","OIsa̱rila nəm nkpaktak oga inok iva̱ uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","UMusa song nkpaktak inok te, á ya oza̱ nəm dakdak wa nva uYawe nak. Te uMusa nak nnap nnəna̱n ôza̱. ");
INSERT INTO yer_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Te uYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","<<Pak aghal áYawe, Aghal Mɓut kà̱ nra ngga nggəshi ka̱ ashe apye aga azəng. ");
INSERT INTO yer_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Te wa nak akwati aga nsar nnap-nlà ka̱ ashishe wa gún ká̱ atani. ");
INSERT INTO yer_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Wa ɓa ká̱ atebəl kang ɓu dàt oga iya̱m inok ka̱ apəpal, kang ɓu ɓa ká̱ idari apitila kang ɓu chwong oga apitila ka̱ apəpal. ");
INSERT INTO yer_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Te wa nak atak nshì iya̱m inəngnəng iga azənariya kà̱ mpyal akwati aga nsar nnap-nlà kang ɓu zong atani aga anung asa̱l aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","<<Wa nak atak nshì iya̱m inana iga nshì pa̱ ɗwot kà̱ anung asa̱l aghal áYawe, Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Wa cher asu kà̱ ishimshe Aghal Mɓut ká̱ atak nshì iya̱m awop, kang ɓu yə́l ndəng ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Wa ká agəla̱n á gang pa̱ kpaktak kang ɓu zong atani aga anung agəla̱n kà̱. ");
INSERT INTO yer_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","<<Te wa yar mmì ngga nggor na u gor aghal áYawe ká̱ nkpaktak oga iya̱m inok iva̱ ka̱ ashishe, na oza̱ á yà iya̱m iyə́ryər. ");
INSERT INTO yer_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Wa shang mmì ngga nggugor ka̱ apal atak nshì iya̱m inana iga nshì ká̱ nkpaktak iya̱m inunok na u gòr atak nshì iya̱m awop á yà atak nshì iya̱m awop ayə́ryər ava ji. ");
INSERT INTO yer_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Te wa gòr asu ká̱ izəzan, na u gar oza̱. ");
INSERT INTO yer_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","<<Wa ɓa ká̱ uHaruna ká̱ ovəvan ka̱ anung Aghal Mɓut, na u wòr oza̱ ká̱ ndəng. ");
INSERT INTO yer_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Te wa mwak ìlukwan iyə́ryər ûHaruna kang ɓu gor na, ɓu gar na uza̱ i yà unəm uga mpyal awop mi. ");
INSERT INTO yer_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Wa ɓa ká̱ ovəvan wa mwak ilukwan iga ashe ôza̱, ");
INSERT INTO yer_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Gor oza̱ wa nva u gor upo oza̱, na oza̱ á yà onəm oga mpyal awop á mi. I yà óza̱ nggor ngga akum onəm oga mpyal awop mbyet mbyet ka̱kul oga nlwàk oza̱ ngga mɓa.>> ");
INSERT INTO yer_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Te uMusa nəm nkpaktak iya̱m va̱ uYawe nak na kà̱. Wa nnà ta uza̱ nəm. ");
INSERT INTO yer_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Te mmá pak aghal áYawe ka̱ apal nra ngga nggəshi ka̱ apye aga zəng ka̱ ashe ìzun iga iparəm. ");
INSERT INTO yer_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","UMusa pak aghal áYawe, à dat oga atak mwak ndar, kang uza̱ mwak oga ndədar, ká̱ oga ndar nnárnàrnárnàr, kang à gha̱p oga ndədar. ");
INSERT INTO yer_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Uza̱ nàr atani aga akpap íɓəl ka̱ apal aghal áYawe kang à nak iya̱m iga nggugún iga awá ka̱ apəpal, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Uza̱ yar oga achuchwal ipang iga nsar nnap-nlà kang à nak oza̱ ka̱ ashe akwati. Te uza̱ mwak oga ndar ka̱ ashe oga nkalɓang ka̱ izər akwati ava̱ ta, kang uza̱ nak anung akwati ava̱ ta ka̱ apəpal. ");
INSERT INTO yer_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Uza̱ tar ká̱ akwati aga nsar nnap-nlà ka̱ ashe aghal, te uza̱ zong atani aga nká atak akwati aga nsar nnap-nlà wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Uza̱ nak atebəl ka̱ ashe Aghal Mɓut ka̱ asa̱l mpal aghal kà̱ mpyal atani. ");
INSERT INTO yer_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Te uza̱ dàt nzəngkəng ka̱ apal atebəl kà̱ mpyal aYawe, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Uza̱ cher idari apitila ka̱ asa̱l nkwandal ka̱ ashe Aghal Mɓut, mal ìkwoksok ká̱ atebəl. ");
INSERT INTO yer_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Te uza̱ ma̱l oga apitila kà̱ mpyal aYawe, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Uza̱ nak atak nshì iya̱m awop aga azənariya ka̱ ashe Aghal Mɓut kà̱ mpyal atani, ");
INSERT INTO yer_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","te uza̱ shì iya̱m inəngnəng ichángchàng ka̱ apəpal, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Uza̱ zong atani ka̱ anung aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Uza̱ nak atak nshì iya̱m inana iga nshì ka̱ anung asa̱l Aghal Mɓut, te uza̱ yichi iya̱m inana iga nshì pa̱ ɗwot ká̱ iga ìpirkur ka̱ apəpal, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Uza̱ cher asu ká̱ ishimshe Aghal Mɓut ká̱ atak nshì iya̱m awop, te uza̱ nak ndəng ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","UMusa ká̱ uHaruna ká̱ ovan aHaruna i nàl awo ká̱ ashar oza̱ ká̱. ");
INSERT INTO yer_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Awalang ava̱ oza̱ i tar Aghal Mɓut kang awalang ava̱ oza̱ i dat atak nshì iya̱m awop te, oza̱ i nàl awo ká̱ ashar oza̱, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Te uMusa dàt agəla̱n gang nkpaktak aghal ká̱ atak nshì iya̱m awop, te uza̱ zong atani ka̱ anung agəla̱n va̱ ta. Wa nnà ta uMusa gba̱l ká̱ inok iva̱ ta. ");
INSERT INTO yer_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Te ìlulu gún Aghal Mɓut, kang ìzhàn aYawe yə́l ashe aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","UMusa chu ntar ashe Aghal Mɓut nva̱ ta ka̱t, ka̱kul ìlulu dàngchi apəpal, kang ìzhàn aYawe yə́l ashe aghal áYawe. ");
INSERT INTO yer_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Nkpaktak awalang va̱ ìlulu i wong ka̱ apal aghal ava̱ ta te, oIsa̱rila i wong achen oza̱. ");
INSERT INTO yer_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","A yà pa̱ ìlulu ya wong chit ka̱t te, oza̱ i wong ka̱t, ya nda va ìlulu i wong kang. ");
INSERT INTO yer_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ka̱kul ìlulu aYawe ka̱ yà ka̱ apal aghal ká̱ alum kang apər ka̱ ashishe ká̱ ìzwam, kà̱ iwu nkpaktak nzhi aIsa̱rila ka̱ ashe nkpaktak achen oza̱.");
INSERT INTO yer_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Nva̱ uMusa ka̱ yà dát ká̱ Aghal Mɓut te uYawe wór na ka̱ ashe aghal va̱ ta là á na pa̱, ");
INSERT INTO yer_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","<<Là ôIsa̱rila pa̱, nkpaktak unəmləbər va̱ i ɓa ká̱ iya̱m inana ûYawe te, uza̱ á ɓa ká̱ ka̱ ashe iya̱m nkang wò, ìtam, ka̱t te ìɓəl, ka̱t te ìna. ");
INSERT INTO yer_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","<<A yà pa̱ iya̱m inananana va̱ ta iga nshì ka̱ ashe ina te, uza̱ á na ìnunggwan ìva yà ká̱ mbyèt ka̱t. Uza̱ á ɓa ká̱ ka̱ anung Aghal Mɓut, ka̱kul na iya̱m inana va̱ ta á sat ika̱mka̱m kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Uza̱ i nak awó wò ka̱ apal ishi iya̱m inana va̱ ta, kang i sat iya̱m inana iga nshì pa̱ ɗwot ika̱mka̱m ka̱kul mmwa ishishi. ");
INSERT INTO yer_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Te uza̱ i pà ìyen ìna ìnunggwan va̱ ta kà̱ mpyal àYawe ka̱ anung Aghal Mɓut. Ovan aHaruna onunggwan onəm oga nshì iya̱m awop i yichi nchə̀chər, i sháng nchə̀r va̱ ta ka̱ izər nkpaktak oga ngba̱k atak nshì iya̱m awop va̱ ka̱ anung asa̱l Aghal Mɓut á. ");
INSERT INTO yer_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Uza̱ i mù iya̱m inana iga nshì pa̱ ɗwot va̱ ta kang i nyat na pa̱ nyimənnyimən. ");
INSERT INTO yer_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ovan aHaruna onunggwan onəm oga mpyal awop i ma̱k apər ka̱ apal atak nshì iya̱m awop kang i nak akun kà̱. ");
INSERT INTO yer_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Te oza̱ i dàt ìzhe ìnyatnyat va̱ ta ká̱ ishíshi ká̱ mpìpip ka̱ apal akun ka̱ apər va̱ ka̱ apal atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Unəm va̱ ta i nàl iya̱m afu ká̱ mbwángbwáng ká̱ ndəng, te unəm uga mpyal awop i shì pa̱ kpaktak ka̱ apal atak nshì iya̱m awop, ka̱kul iya̱m inana iga nshì pa̱ ɗwot va inəngnəng ichángchàng ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","<<Kang a yà pa̱ iya̱m inananana iga nshì pa̱ ɗwot ka̱ ashe iya̱m nkang iɓəl ka̱t te itam te, uza̱ á na ìnunggwan va yà ká̱ mbyèt ka̱t á. ");
INSERT INTO yer_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Te uza̱ i pà iya̱m nkang va̱ ta kà̱ ngba̱k ngga asa̱l mpal atak nshì iya̱m awop kà̱ mpyal àYawe, kang ovan onunggwan aHaruna onəm oga nshì iya̱m awop i sháng nchə̀chər ka̱ izər nkpaktak oga ngba̱k atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Uza̱ i nyat iya̱m nkang va̱ ta pa̱ nyimənnyimən, ishíshi ká̱ mpìpip te unəm uga mpyal awop i dàt ka̱ apal akun ka̱ apər va̱ ka̱ apal atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Unəm va̱ ta i nàl iya̱m afu ká̱ mbwángbwáng ká̱ ndəng. Te unəm uga mpyal awop i shì pa̱ kpaktak ka̱ apal atak nshì iya̱m awop, ka̱kul iya̱m inana iga nshì pa̱ ɗwot va inə́ngnəng ichángchàng ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","<<A yà pa̱ iya̱m inananana iga nshì pa̱ ɗwot ûYawe iga inyil te, uza̱ á na ivan iləkpar ka̱t te ivan iruzum. ");
INSERT INTO yer_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Unəm uga mpyal awop i ga ká̱ ka̱ atak nshì iya̱m awop kang i kandar ishíshi i pətar, kang i shì ka̱ apal atak nshì iya̱m awop, te i wàr nchə̀chər ka̱ izər atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Uza̱ i tur atak nrìri ká̱ alilyang i swang ka̱ ashe atak mɓut nchwang kà̱ ngba̱k atak nshì iya̱m awop ka̱ asa̱l nfa alum. ");
INSERT INTO yer_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Uza̱ i kak kà̱ ìkwoksok i bol afufu nzəng ká̱ nkəkan ka̱t. Te unəm uga mpyal awop i shì ka̱ apal atak nshì iya̱m awop ka̱ apal akun va̱ ka̱ anung apər, ka̱kul iya̱m inana iga nshì pa̱ ɗwot va inə́ngnəng ichángchàng ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","<<Awalang va̱ unəm uro ɓa ká̱ iya̱m inana iga ìpir ìkùr ûYawe, te nkpak iya̱m inana va̱ ta i yà mma̱k ǹyalyal. Uza̱ i zuk mmì mpyet ka̱ apəpal, i nak njəng nnə́ngnəng nchángchàng ka̱ apəpal, ");
INSERT INTO yer_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","kang i ɓa ká̱ ka̱ atak ovan aHaruna onunggwan onəm oga nshì iya̱m awop. Unəm uga mpyal awop i kpa̱k mma̱k nlúkútlùkùt pa̱ súr ka̱ awó ká̱ mmì mpyet nzəng ká̱ nkpaktak njəng nnə́ngnəng nchángchàng, kang uza̱ i shì iya̱m iga nrəng ká̱ ka̱ apal atak nshì iya̱m awop, iya̱m inana iga nshì inə́ngnəng ichángchàng ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Te aɓo iya̱m inana iga ìpir ìkùr va̱ ta i yà iji aHaruna ká̱ ovəvan onunggwan, ka̱kul iyə́ryər va ji ka̱ ashe iya̱m inana iga nshì ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","<<A yà pa̱ u yichi iya̱m inana iga ìpir ìkùr ifórfòr ka̱ ashe achər apər te, á yà ká̱ mma̱k nnəna̱n, i yà nzəngkəng ngga ǹyà ká̱ ayist ka̱t, i gwang ká̱ mmì mpyet, ka̱t te nzəngkəng ndátdàt va yà ká̱ ayist ka̱t nva mmá ɓə́l ká̱ mmì mpyet. ");
INSERT INTO yer_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","A yà pa̱ iya̱m inana ɓu iga ìpir ìkùr va mmá fòr ka̱ ashe asu acham, te nkpak i yà nzəngkəng ngga ayist ka̱t nva mmá nəm ká̱ mma̱k nnəna̱n gwang ká̱ mmì mpyet. ");
INSERT INTO yer_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Nyat na pa̱ nyimənnyimən kang ɓù zuk mmì mpyet ka̱ apəpal, iya̱m inana iga ìpir ìkùr. ");
INSERT INTO yer_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","A yà pa̱ iya̱m inana ɓu iga ìpir ìkùr mmá fòr ka̱ ashe asu te, á yà ká̱ mma̱k ǹyalyal ká̱ mmì mpyet. ");
INSERT INTO yer_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Awalang va̱ ɓu ɓa ká̱ iya̱m inana iga ìpir ìkùr ûYawe iva mmá nəm ká̱ iya̱m va̱ ta̱ te, yichi ûnəm uga mpyal awop kang uza̱ i ga ká̱ ka̱ atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Unəm uga mpyal awop i tur iya̱m inana iga nrəng ká̱ ka̱ ashe iya̱m inana iga ìpir ìkùr, kang uza̱ i shì ka̱ apal atak nshì iya̱m awop, iya̱m inana iga nshì inə́ngnəng ichángchàng ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Te aɓo iya̱m inana iga ìpir ìkùr va̱ ta i yà iji aHaruna ká̱ ovəvan onunggwan, ka̱kul iyə́ryər va ji ka̱ ashe iya̱m inana iga nshì ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","<<Nkpaktak iya̱m inana iga ìpir ìkùr va̱ ɓu yichi ûYawe te mí nəm ká̱ ayist ka̱t, ka̱kul ɓu yà ká̱ nshì iya̱m iga ayist ka̱t, ka̱t te irizhe wa iya̱m inana iga nshì ûYawe ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ɓu yichi oza̱ yichi ûYawe wa iya̱m inana iga ǹyál nggəshi, kang mí yà ká̱ ǹyichi oza̱ ka̱ apal atak nshì iya̱m awop wa iya̱m inə́ngnəng ichángchàng ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Mí nak mmàn n̂za̱ iya̱m inana ɓu nggo iga ìpir ìkùr. Kang wa kong ká̱ nnak mmàn ngga nsar nnap-nlà ɓu ká̱ Inan, ka̱ ashe iya̱m inana ɓu iga ìpir ìkùr ká̱ nza̱ iya̱m inana ɓu nggo va̱ ɓu yichi te, nak mmàn kà̱. ");
INSERT INTO yer_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","<<A yà pa̱ u yichi iya̱m inana iga ìpir ìkùr ǹyál nggəshi ûYawe te, nkpak ɓu yichi ishi ikùr izhakan ipərkənpə̀rkə̀n, iva mmá wàng ká̱ apər, kang mmá kpəkpà. ");
INSERT INTO yer_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Te nkpak ɓu nak mmì mpyet ká̱ njəng nnə́ngnəng nchángchàng ka̱ apəpal, ka̱kul iya̱m inana iga ìpir ìkùr. ");
INSERT INTO yer_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Unəm uga mpyal awop i shì ka̱ ashe ikùr ipərkənpə̀rkə̀n iya̱m inana iga nrəng ká̱, ká̱ mmì mpyet ká̱ nkpaktak njəng nnə́ngnəng nchángchàng iya̱m inana iga nshì ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","<<A yà pa̱ uza̱ kà̱ ǹyichi nləfər wò ngga ntəm ikángkáng ka̱ ashe ina, mo te ìnunggwan ka̱t te ìchar nggo, te uza̱ á yichi ìva yà ká̱ nɗaktak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Uza̱ i nak awó wò ka̱ apal ishi iya̱m inana wò kang ì pà ka̱ anung asa̱l Aghal Mɓut. Te ovan áHaruna onunggwan onəm oga nshì iya̱m awop i yichi nchə̀chər, i sháng nchə̀r va̱ ta ka̱ izər nkpaktak oga ngba̱k atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Uza̱ i yichi ka̱ ashe nləfər iya̱m ipápà iga ikángkáng iya̱m inana iga nshì ûYawe. Mpip va̱ gún iya̱m afu ká̱ nkpaktak mpip va̱ ka̱ apal iya̱m afu, ");
INSERT INTO yer_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ká̱ arùsòk aga aparəm ká̱ mpip va̱ ka̱ apal oza̱ ka̱ atak aɗək, ká̱ mpip ngga apal anì nzəng ká̱ oga arùsòk uza̱ i zə̀p. ");
INSERT INTO yer_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ovan aHaruna onunggwan i shì ka̱ atak nshì iya̱m awop ká̱ iya̱m inana ishíshì va ka̱ apal akun va ka̱ apal apər, iya̱m inana iga nshì inə́ngnəng ichángchàng ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","<<A yà pa̱ nləfər iya̱m inananana iga ntəm ikángkáng ûYawe ka̱ ashe iya̱m nkəkang, uza̱ i yichi ìnunggwan ka̱t te ìchar ìva yà ká̱ nɗaktak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","A yà pa̱ uza̱ kà̱ ǹyichi ìyen ìnagam iya̱m inana wò, te uza̱ i yichi kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Uza̱ i nak awó wò ka̱ apal ishi iya̱m inana wò kang i pà kà̱ mpyal Aghal Mɓut. Te ovan aHaruna onunggwan onəm oga nshì iya̱m awop i sháng nchə̀r va̱ ta kà̱ ngba̱k oga atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Te ka̱ ashe nləfər iya̱m inana iga ntəm ikángkáng, uza̱ i yichi ngba̱k nro wa iya̱m inana iga nshì ûYawe. Mpìpip, nkpaktak mpip aswal uza̱ i tutur. Mpip va̱ gún iya̱m afu, ká̱ nkpaktak mpip va̱ gún iya̱m afu, ");
INSERT INTO yer_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ká̱ arùsòk aga aparəm, ká̱ mpip va̱ ka̱ apal oza̱ ka̱ atak aɗək, ká̱ mpip ngga apal anì nzəng ká̱ oga arùsòk uza̱ i zə̀p. ");
INSERT INTO yer_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Te unəm uga mpyal awop i shì ka̱ apal atak nshì iya̱m awop wa iya̱m-nrì, iya̱m inana iga nshì ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","<<A yà pa̱ uza̱ kà̱ ǹyichi iya̱m inana wò ìɓəl, te uza̱ á yichi kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Uza̱ i nak awó wò ka̱ apal ishi iya̱m inana wò kang i pà ka̱ anung asa̱l Aghal Mɓut. Te ovan aHaruna onunggwan onəm oga nshì iya̱m awop i yichi nchə̀chər, i sháng nchə̀r va̱ ta ka̱ izər nkpaktak oga ngba̱k atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Uza̱ i yichi ka̱ ashe iyəya̱m inana, ngba̱k nro wa iya̱m inana iga nshì ûYawe, mpip va̱ gún oga iya̱m afu, ká̱ nkpaktak mpip va̱ ka̱ apal oga iya̱m afu, ");
INSERT INTO yer_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ká̱ arùsòk aga aparəm, ká̱ mpip va̱ ka̱ apal oza̱ ka̱ atak aɗək, ká̱ mpip ngga apal anì nzəng ká̱ oga arùsòk uza̱ i zə̀p. ");
INSERT INTO yer_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Te unəm uga mpyal awop i shì oza̱ ka̱ apal atak nshì iya̱m awop wa iya̱m-nrì, iya̱m inana iga nshì inə́ngnəng ichángchàng. Nkpaktak mpip nji aYawe. ");
INSERT INTO yer_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Iya̱m va̱ ta̱ nnap mpakpak va təm chit mbyet mbyet ka̱kul oga nlwàk wó, ká̱ nkpaktak atak ntəm wó. Nkpaktak mpip ká̱ nchə̀r, ó ri ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","<<Là ôIsa̱rila, <Awalang va̱ unəm uro nəm nnap mɓá̱ngɓa̱ng ká̱ avyal ka̱t ka̱ ashe nkpaktak nnap mpakpak àYawe nva mmá dang oza̱ kà̱ nnənəm, kang uza̱ nəm. ");
INSERT INTO yer_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","<< <A yà pa̱ unəm uga mpyal awop ugorgor nəm nnap mɓá̱ngɓa̱ng, kang à ɓa ká̱ mpat ka̱ apal onəm, te uza̱ i yichi ìna ìnunggwan ûYawe ìva yà ká̱ nɗaktak ka̱t ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Uza̱ i ɓa ká̱ ìna ìnunggwan ka̱ anung Aghal Mɓut kà̱ mpyal aYawe, kang uza̱ i nak awó wò ka̱ apal ishi ìna ìnunggwan va̱ ta, te i pà kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Te unəm uga mpyal awop ugorgor i pá nchə̀r ìna ìnunggwan va̱ ta uza̱ i ɓa ká̱ ka̱ ashe Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Uza̱ i pá ìfang wò ka̱ ashe nchə̀r va̱ kang i sháng nva̱ng pa̱ nfangshat kà̱ mpyal àYawe ká̱ mpyal atani aga Atak Ayə́ryər. ");
INSERT INTO yer_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Unəm uga mpyal awop i ɓə́l nchə̀r nro ka̱ izər oga nggùnggúng ngga atak nshì iya̱m awop anə́ngnəng achángchàng va̱ kà̱ mpyal àYawe ka̱ ashe Aghal Mɓut. Nkpaktak aɓo nchə̀r ìna ìnunggwan va̱ ta uza̱ i wàr ka̱ avəng ashar atak nshì iya̱m inana iga nshì va̱ ka̱ anung Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Te nkpaktak mpip ìna ìnunggwan iya̱m inana nnap mɓá̱ngɓa̱ng uza̱ i zə̀p. Mpip va̱ gún iya̱m afu, ká̱ nkpaktak mpip va̱ ka̱ apal oga iya̱m afu, ");
INSERT INTO yer_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ká̱ arùsòk aga aparəm ká̱ mpip va̱ ka̱ apal oza̱ ka̱ atak aɗək, ká̱ mpip ngga apal anì nzəng ká̱ oga arùsòk uza̱ i zə̀p. ");
INSERT INTO yer_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Wa nva mí tutur mpip ka̱ ashe ìna ìnunggwan nləfər iya̱m inana iga ntəm ikángkáng, te unəm uga mpyal awop i shì oza̱ ka̱ apal atak nshì iya̱m awop aga iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Kang awá ìna ìnunggwan va̱ ta, ká̱ nkpaktak ìzhìzhe, ká̱ ishíshi, ká̱ mbwángbwángbwangbwang, ká̱ iya̱m afúfu, ká̱ ìbənggangbənggang, ");
INSERT INTO yer_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","uza̱ i fa ká̱ nkpaktak aɓo ìna ìnunggwan va̱ ta kà̱ nsəm apa̱k ka̱ atak anəna̱n, ka̱ atak mɓut nchwang kang uza̱ i shì ka̱ apal anung akun apər. Mí shì ka̱ atak mɓut nchwang. ");
INSERT INTO yer_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","<< <A yà pa̱ nkpaktak mɓut oIsa̱rila nəm mpat ká̱ avyal ka̱t, kang nnap va̱ ta tar achwang nggatək ka̱t, te oza̱ nəm iya̱m va̱ mmá dang oza̱ kà̱ nnənəm ka̱ ashe nnap mpakpak aYawe nro, te oza̱ i yà ká̱ mpat. ");
INSERT INTO yer_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Awalang va̱ nnap mɓá̱ngɓa̱ng va̱ oza̱ nəm ka̱ apal nnap mpakpak fa mbáng, te mɓut i yichi ìna ìnunggwan wa iya̱m inana nnap mɓá̱ngɓa̱ng, oza̱ i ɓa ká̱ kà̱ mpyal Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Onəmgbak mɓut va̱ ta i nak awó oza̱ ka̱ apal ishi ìna ìnunggwan va̱ ta kà̱ mpyal àYawe, kang i pà ìna ìnunggwan va̱ ta kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Te unəm uga mpyal awop ugorgor i ɓa ká̱ nchə̀r ìna ìnunggwan va̱ ta nro ka̱ ashe Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Uza̱ i pá ìfang wò ka̱ ashe nchə̀r va̱ kang i sháng nva̱ng pa̱ nfangshat kà̱ mpyal àYawe kà̱ mpyal atani. ");
INSERT INTO yer_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Uza̱ i ɓə́l nchə̀r nro ka̱ izər oga nggùnggúng ngga atak nshì iya̱m awop va kà̱ mpyal àYawe ka̱ ashe Aghal Mɓut. Nkpaktak aɓo nchə̀r ìna ìnunggwan va̱ ta uza̱ i wàr ka̱ avəng ashar atak nshì iya̱m inana iga nshì va̱ ka̱ anung Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Uza̱ i zə̀p nkpaktak mpìpip, i shì ka̱ apal atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Unəm uga mpyal awop i nəm ká̱ ìna ìnunggwan va̱ ta wa nva uza̱ nəm ká̱ ìna ìnunggwan iga nnap mɓá̱ngɓa̱ng. Uza̱ i nəm mmwa ishi ka̱kul oza̱, te mí yar nnap mɓá̱ngɓa̱ng ôza̱. ");
INSERT INTO yer_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Te uza̱ i fa ká̱ ìna ìnunggwan va̱ ta kà̱ nsəm apa̱k, kang i shì wa nva uza̱ shì ìna ìnunggwan igəshi. Iya̱m inana nnap mɓá̱ngɓa̱ng nggatək. ");
INSERT INTO yer_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","<< <A yà pa̱ unəm uga mpyal nəm iya̱m iɓá̱ngɓa̱ng ká̱ avyal ka̱t, uza̱ nəm iya̱m pa̱ izəng va̱ mmá dang ka̱ ashe nnap mpakpak àYawe Inənan, te uza̱ i yà ká̱ mpat. ");
INSERT INTO yer_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Unəm uro a nyám nnap mɓá̱ngɓa̱ngɓa̱ngɓa̱ng á na te uza̱ i ɓa ká̱ iya̱m inana wò ìɓəl ìnunggwan, ìva yà ká̱ mbyèt ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Uza̱ i nak awó wò ka̱ apal ishi ìɓəl va̱ ta, kang i pà ná ka̱ atak va̱ mí pà iya̱m inana iga nshì kà̱, kà̱ mpyal àYawe. Iya̱m inana iga nnap mɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Te unəm uga mpyal awop i pá ìfang ka̱ ashe nchə̀r iya̱m inana nnap mɓá̱ngɓa̱ng i ɓə́l n̂ggùnggúng ngga atak nshì iya̱m awop. Aɓo nchə̀chər te uza̱ i tar ka̱ avəng atak nshì iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Nkpaktak mpìpip uza̱ i shì ka̱ atak nshì iya̱m awop, wa mpip nləfər iya̱m inana iga ntəm ikángkáng. Te unəm uga mpyal awop i mwa ishíshi ká̱, kang mí yar nnap mɓá̱ngɓa̱ngɓa̱ngɓa̱ng á na. ");
INSERT INTO yer_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","<< <A yà pa̱ unəm uga nkun uro ka̱ ashe mɓut nəm nnap mɓá̱ngɓa̱ng ká̱ avyal ka̱t ka̱ ashe oga nnap mpakpak aYawe nro nva mmá dang nnənəm dang, kang à yà ká̱ mpat, ");
INSERT INTO yer_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","kang mmá nyám mpəpat á na, te uza̱ i ɓa ká̱ iya̱m inana wò ìɓəl ìchar ìva yà ká̱ nɗaktak ka̱t, ka̱kul nnap mɓá̱ngɓa̱ng va̱ uza̱ nəm. ");
INSERT INTO yer_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Uza̱ i nak awó wò ka̱ apal ishi iya̱m inana nnap mɓá̱ngɓa̱ng kang i pà ka̱ atak aga nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Te unəm uga mpyal awop i pá ìfang ka̱ ashe nchə̀r i ɓə́l n̂ggùnggúng ngga atak nshì iya̱m awop. Aɓo nchə̀chər te uza̱ i wàr ka̱ avəng ashar atak nshì iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Kà̱ nvəva̱ng te unəm uga mpyal awop i zə̀p nkpaktak mpìpip, wa nva uza̱ zə̀p ngga iya̱m inana iga ntəm ikángkáng, i shì ka̱ apal atak nshì iya̱m awop wa iya̱m inə́ngnəng ichángchàng ûYawe. Unəm uga mpyal awop i nəm mmwa ishi á na ká̱, te mí yar á na. ");
INSERT INTO yer_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","<< <A yà pa̱ uza̱ ɓa ká̱ ìtam iya̱m inana nnap mɓá̱ngɓa̱ng, te uza̱ á ɓa ká̱ ìchar ìva yà ká̱ nɗaktak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Uza̱ i nak awó wò ka̱ apal ishi iya̱m inana nnap mɓá̱ngɓa̱ng, kang uza̱ i pà ka̱kul nnap mɓá̱ngɓa̱ng, ka̱ atak mpà iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Te unəm uga mpyal awop i pá ìfang ka̱ ashe nchə̀r iya̱m inana nnap mɓá̱ngɓa̱ng i ɓə́l n̂ggùnggúng ngga atak nshì iya̱m awop. Aɓo nchə̀chər te uza̱ i wàr ka̱ avəng ashar atak nshì iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Uza̱ i zə̀p nkpaktak mpìpip wa nva mí zə̀p mpip ìtam nləfər ngga ntəm ikángkáng, te unəm uga mpyal awop i shì oza̱ ka̱ apal atak nshì iya̱m awop, iya̱m inana iga nshì ûYawe. Unəm uga mpyal awop i nəm mmwa ishi á na ká̱, ka̱kul nnap mɓá̱ngɓa̱ngɓa̱ngɓa̱ng va̱ uza̱ nəm, te mí yar á na. ");
INSERT INTO yer_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","UYawe là ônəm kà̱ ɗi pa̱, <<A yà pa̱ unəm uro yang nlà nnàp ka̱ apal nnap mɓá̱ngɓa̱ng va̱ unəm uro nəm va̱ uza̱ yiya, ka̱t te uza̱ nyinyi kang uza̱ là fa mbáng ka̱t, te uza̱ nəm nnap mɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ka̱t te a yà pa̱ unəm uro dok iya̱m iro iga adak, akúm nza̱ ìzhe iga anyin nggo iga adak, ka̱t te akúm iya̱m nkang iga adak, ka̱t te akúm iya̱m iga nkpàng ká̱ afu iga adak, nzəng ká̱ nnyinyi ka̱t, te uza̱ ká̱ adak kang uza̱ pat chit. ");
INSERT INTO yer_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ka̱t te a yà pa̱ uza̱ dok adak ánəmləbər, ká̱ nza̱ apir iya̱m iga adak nggo va̱ i nak uza̱ i yà ká̱ adak nzəng ká̱ nnyinyi ka̱t, kang kà̱ nvəva̱ng uza̱ nyi, te uza̱ ká̱ mpat. ");
INSERT INTO yer_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ka̱t te a yà pa̱ unəm sóng anung ka̱ ashe ngha̱n ka̱ apal nnəm iya̱m inəna̱n, ka̱t te inga, nkpaktak iya̱m va̱ unəmləbər là ká̱ ngha̱n ka̱ ashe nsóng anung nzəng ká̱ nnyinyi ka̱t, kang kà̱ nva̱ngva̱ uza̱ nyi te, uza̱ i yà ká̱ mpat. ");
INSERT INTO yer_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Awalang va̱ unəm yà ká̱ mpat ka̱ ashe izəngtəng oga iya̱m va̱ ta̱, uza̱ i pwa nnap mɓá̱ngɓa̱ng va̱ uza̱ nəm. ");
INSERT INTO yer_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Uza̱ i ɓa ká̱ iya̱m inana mpat wò ûYawe ka̱kul nnap mɓá̱ngɓa̱ng va̱ uza̱ nəm, ìtam ìchar ka̱t te ìɓəl ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng. Te unəm uga mpyal awop i yichi iya̱m inana iga mmwa ishi ka̱ anunung, ka̱kul nnap mɓá̱ngɓa̱ngɓa̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","<<Kang a yà pa̱ uza̱ yà ká̱ ìkam iga nna ìtam ka̱t, te uza̱ i ɓa ká̱ ivan iləkpar pa̱ iparəm ka̱t te ivan iruzum pa̱ iparəm ûYawe, ka̱kul mpat va̱ uza̱ nəm. Ìro ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng kang ìro ka̱kul iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Uza̱ i ɓa ká̱ oza̱ ka̱ atak ánəm uga mpyal awop, uva̱ i yichi ìro iya̱m inana nnap mɓá̱ngɓa̱ng nggəshi. Uza̱ i kandar ìshishak nzəng ká̱ mpətarpətar ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Te uza̱ i sháng nchə̀r nro ngga iya̱m inana nnap mɓá̱ngɓa̱ng kà̱ ngba̱k atak nshì iya̱m awop, kang aɓo nchə̀r te mí wàr ka̱ avəng ashar atak nshì iya̱m awop, iya̱m inana nnap mɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Uza̱ i yichi ipəpar iya̱m inana iga nshì wa nva nnap mpakpak là. Te unəm uga mpyal awop i nəm mmwa ishi ka̱ anunung ka̱kul nnap mɓá̱ngɓa̱ng va̱ uza̱ nəm, te mí yar á na. ");
INSERT INTO yer_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","<<A yà pa̱ iləkpar pa̱ iparəm ka̱t te iruzum pa̱ iparəm ma̱t na ma̱t kà̱ nná te, uza̱ á ɓa ká̱ mma̱k ǹyalyal ìkpang pa̱ ìzəng ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng. Uza̱ i zuk mmì mpyet ká̱ njəng nnə́ngnəng nchángchàng ka̱ apəpal ka̱t, ka̱kul iya̱m inana iga nnap mɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Uza̱ i ɓa ká̱ ûnəm uga mpyal awop, te unəm uga mpyal awop i kpa̱k ka̱ ashishe ka̱ awó pa̱ súr wa iya̱m inana iga nrəng ká̱. Te uza̱ i shì ka̱ apal atak nshì iya̱m awop wa iya̱m inana iga nshì ûYawe. Iya̱m va ta̱ iya̱m inana iga nnap mɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ka̱ asa̱l va ta̱ unəm uga mpyal awop i nəm mmwa ishi ka̱kul nnap mɓá̱ngɓa̱ng va̱ uza̱ nəm ka̱ ashe izəngtəng oga iya̱m va̱ ta̱, te mí yar á na. Aɓo mməma̱k i yà nji ànəm uga mpyal awop, wa nva ka̱ iya̱m inana ìpir ìkùr.>> ");
INSERT INTO yer_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","UYawe là nnàp ká̱ uMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","<<A yà pa̱ unəm uro nəm nnap mɓá̱ngɓa̱ng ká̱ avyal ka̱t ka̱ apal iya̱m iyə́ryər aYawe iro, te uza̱ i ɓa ká̱ iya̱m inana iga mpat ûYawe, ìnagam va yà ká̱ nɗaktak ka̱t ka̱ ashe iya̱m nkang, ìva məmàl ká̱ mbwai ashekel. Kang ì məmàl kpa ká̱ ashekel aga Atak Ayə́ryər ka̱kul mpat. ");
INSERT INTO yer_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Nnap mɓá̱ngɓa̱ng va̱ uza̱ nəm ka̱ ashe iya̱m iyə́ryər, te uza̱ i le ká̱ uzəng ka̱ apal átukun ka̱ apəpal, kang i na unəm uga mpyal awop. Te unəm uga mpyal awop i nəm mmwa ishi ká̱ ka̱kukul ká̱ ìnagam iga iya̱m inana mpat, te mí yar á na. ");
INSERT INTO yer_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","<<A yà pa̱ unəm uro nəm nnap mɓá̱ngɓa̱ng ká̱ avyal ka̱t ka̱ ashe oga nnap mpakpak àYawe nva mmá dang oza̱ kà̱ nnənəm te uza̱ i yà ká̱ mpat káp ká̱ nva̱ uza̱ nyi ka̱t, te uza̱ i yar nsur mpat wò. ");
INSERT INTO yer_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Uza̱ i ɓa ká̱ ìnagam va yà ká̱ nɗaktak ka̱t ka̱ ashe iya̱m nkang, kang á məmàl ka̱kul mpat. Te unəm uga mpyal awop i nəm mmwa ishi á na ká̱ ka̱kul mpəpat va̱ uza̱ nəm ka̱ ashe nnyi ka̱t á, te mí yar á na. ");
INSERT INTO yer_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Iya̱m inana mpat, ka̱kul mmwa ishi ûnəm uga mpat kà̱ mpyal àYawe.>> ");
INSERT INTO yer_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","<<A yà pa̱ unəm uro nəm nnap mɓá̱ngɓa̱ng ûYawe ka̱ atak nlàm uwan wò ka̱ ashe nnap iya̱m iro va̱ mmá na á na pa̱ á kpán á nak ishi ká̱, ka̱t te iya̱m iro va mmá vyat, ka̱t te á mwar uwanwò, ");
INSERT INTO yer_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ka̱t te vyok iya̱m iro va lar kang à náp akwam ka̱ apəpal, ka̱t te sóng anung aga akwam ka̱ apal iya̱m iro va unəmləbər i nəm nnap mɓá̱ngɓa̱ng ka̱ atak oza̱. ");
INSERT INTO yer_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Awalang va̱ uza̱ nəm nnap mɓá̱ngɓa̱ng kang à yà ká̱ mpat, te uza̱ i le ká̱ iya̱m va̱ uza̱ vyat, ka̱t te ivəngva̱ uza̱ mwar, ka̱t te iya̱m va mmá na á na pa̱ á kpán á nak ishi ká̱, ka̱t te iya̱m va lar kang uza̱ vyok, ");
INSERT INTO yer_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ka̱t te ka̱ ashe nza̱ iya̱m nggo va uza̱ sóng anung ka̱ apəpal ká̱ akwam te uza̱ i le ká̱. Te uza̱ i le ká̱ pa̱ chatchat kang i nak ikak kà̱ uzəng ka̱ apal átukun ûnənəm, kang i na á na kà̱ ìlum va̱ uza̱ nyi mpat wò. ");
INSERT INTO yer_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Uza̱ i ɓa ká̱ iya̱m inana mpat wò ûYawe, ìnagam va yà ká̱ mbyèt ka̱t ka̱ ashe iya̱m nkang, iva á məmàl ka̱kul mpat ûnəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Unəm uga mpyal awop i nəm mmwa ishi á na ká̱ kà̱ mpyal àYawe, kang mí yar á na ka̱ apal iya̱m iro ka̱ ashe iva uza̱ nəm mpat kà̱.>> ");
INSERT INTO yer_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","<<Là ûHaruna ká̱ ovəvan onunggwan pa̱, nnap mpakpak iya̱m inana iga nshì nnà ta. Iya̱m inana iga nshì i təm kà̱ ìɗimɗim atak nshì iya̱m awop nkpaktak ìzwam atak i tàn kà̱, kang apər aga atak nshì iya̱m awop ì yà kà̱ nrí ka̱ apəpal. ");
INSERT INTO yer_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Unəm uga mpyal awop i pá ìlukwan alinin wò ìwángwang, ká̱ iga alinin iga ashe ìɓwakan ka̱ izər wò, te uza̱ i wur nchwang ngga iya̱m inana ishishì va̱ apər shì ka̱ apal atak nshì iya̱m awop, uza̱ i nak kà̱ ngba̱k atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Te uza̱ i zə̀p oga ilukwan wò i mwàk ilukwan ikák, kang i fa ká̱ nchwang kà̱ nsəm apa̱k ka̱ atak mɓuɓut anəna̱n. ");
INSERT INTO yer_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Apər va̱ ka̱ apal atak nshì iya̱m awop á pak nsal kang á kú ka̱t. Kang nza̱ ìpin nggo te unəm uga mpyal awop ì gwanggwang akún kang ì dàt iya̱m inana iga nshì kà̱. Uza̱ á shì mpip iya̱m inana iga ntəm ikángkáng ka̱ apəpal. ");
INSERT INTO yer_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Apər va̱ ka̱ apal atak nshì iya̱m awop á pak nsal pa̱ ɗəkər kang á kú ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","<<Nnap mpakpak ngga iya̱m inana ìpir ìkùr nnà ta̱. Ovan aHaruna onunggwan i yichi kà̱ mpyal àYawe, kà̱ mpyal atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Uzəngtəng ka̱ ashe onəm oga mpyal awop i kpa̱k mma̱k nlúkútlùkùt pa̱ súr ka̱ awó ká̱ mmì mpyet nzəng ká̱ nkpaktak njəng nnə́ngnəng nchángchàng, kang uza̱ i shì iya̱m iga nrəng ká̱ ka̱ apal atak nshì iya̱m awop, iya̱m inana iga nshì inə́ngnəng ichángchàng ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","UHaruna ká̱ ovan wò onunggwan i ri aɓuɓo. Mí ri ká̱ nzəngkəng ngga ǹyà ká̱ ayist ka̱t ka̱ Atak Ayə́ryər, oza̱ i ri ka̱ ashe agəla̱n Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Mí fòr ká̱ ayist ka̱t, n na ôza̱ chit təm nji oza̱ ka̱ ashe iya̱m inana mi iga nshì. Iyə́ryər va ji, wa iya̱m inana nnap mɓá̱ngɓa̱ng ká̱ iya̱m inana mpat. ");
INSERT INTO yer_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Nza̱ ununggwan nggo ka̱ ashe ovan aHaruna i riri ka̱ ashe iya̱m inana iga nshì ûYawe. Á təm chit nnap mpakpak ka̱kul oga nlwàk wó mbyet mbyet. Nkpaktak iya̱m va̱ i dok oga iya̱m inana va̱ ta te i yà iyə́ryər.>> ");
INSERT INTO yer_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","<<Iya̱m inana va ta̱ uHaruna ká̱ ovan wò onunggwan i yichi ûYawe kà̱ ìlum va mí gòr na ká̱. Uza̱ i ɓa ká̱ ìkpang pa̱ ìzəng ka̱ ashe agba̱pchi iga mma̱k ǹyalyal wa iya̱m inana ìpir ìkùr pa̱ ɗəkər, mí kap kà̱ ìshimshe aɓuɓo ká̱ ìpin kang aɓuɓo ká̱ arurong. ");
INSERT INTO yer_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Kál ká̱ mmì mpyet te fòr ka̱ ashe asu acham. Nyat na pa̱ nyimənnyimən wa iya̱m inana ìpir ìkùr, kang ɓù yichi iya̱m inana inə́ngnəng ichángchàng ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Unəm uga mpyal awop uva̱ mmá gòr ka̱ ashe ovan aHaruna pa̱ á yar atak nsəsat, te uwà i yichi iya̱m inana va̱ ta ûYawe wa nnap mpakpak mbyet mbyet. Mí shì iya̱m inana va̱ ta pa̱ chatchat. ");
INSERT INTO yer_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Nza̱ iya̱m inana ìpir ìkùr nggo va ka̱kul anəm uga mpyal awop te, mí shì pa̱ chatchat. Mí ri ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","<<Là ûHaruna ká̱ ovan wò onunggwan pa̱, nnap mpakpak ngga iya̱m inana nnap mɓá̱ngɓa̱ng nnà ta̱. Mí pà iya̱m inana nnap mɓá̱ngɓa̱ng kà̱ mpyal àYawe ka̱ atak va mí pà iya̱m inana nnap mɓá̱ngɓa̱ng kà̱. Nnà iyə́ryər va ji pa̱ kpaktak. ");
INSERT INTO yer_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Unəm uga mpyal awop va̱ yichi iya̱m inana va̱ ta wa iya̱m inana nnap mɓá̱ngɓa̱ng te, uza̱ i ri ka̱ Atak Ayə́ryər ka̱ ashe agəla̱n Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Iya̱m va̱ dok ìzhizhe te i yà iyə́ryər, kang a yà pa̱ nchə̀chər sháng ka̱ apal ìlukwan, te uza̱ á nàl ìlukwan va̱ ta ka̱ Atak Ayə́ryər. ");
INSERT INTO yer_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Mí chwan ngbət amè va̱ mmá pə́k iya̱m inana nnap mɓá̱ngɓa̱ng ka̱ ashishe, nnyi te a yà pa̱ mmá pə́k ka̱ ashe ngbət acham arəzang te mí gbàk kang mí zwaktak ká̱ ndəng. ");
INSERT INTO yer_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Nza̱ uyen ununggwan nggo ka̱ ashe onəm oga nshì iya̱m awop i riri. Iyə́ryər va ji. ");
INSERT INTO yer_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Iya̱m inana nnap mɓá̱ngɓa̱ng va̱ mí ɓa ká̱ nchə̀chər ka̱ ashe Aghal Mɓut ka̱kul nnəm mmwa ishi ka̱ Atak Ayə́ryər te, mí ri ka̱t, nkpak mí shì ká̱ apər. ");
INSERT INTO yer_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","<<Nnap mpakpak ngga iya̱m inana iga mpat nnà ta̱. Iyə́ryər va ji. ");
INSERT INTO yer_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Mí pà iya̱m inana iga mpat ka̱ atak va mí pà iya̱m inana iga nshì kà̱, kang mí sháng nchə̀chər kà̱ oga ngba̱k atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Nkpaktak mpìpip mí yichi, mpip aswal ká̱ mpip va̱ gún oga iya̱m afu, ");
INSERT INTO yer_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ká̱ arùsòk aga aparəm ká̱ mpip va̱ ka̱ apal oza̱ ka̱ atak aɗək, ká̱ mpip ngga apal anì nzəng ká̱ oga arùsòk uza̱ i zə̀p. ");
INSERT INTO yer_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Unəm uga mpyal awop i shì oza̱ ka̱ apal atak nshì iya̱m wa iya̱m inana iga nshì ûYawe. Iya̱m va ta̱ iya̱m inana mpat. ");
INSERT INTO yer_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Nza̱ uyen ununggwan nggo ka̱ ashe onəm oga nshì iya̱m awop i riri. Mí ri ka̱ Atak Ayə́ryər, iyə́ryər va ji. ");
INSERT INTO yer_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Iya̱m inana iga mpat wa iya̱m inana nnap mɓá̱ngɓa̱ng, nnap mpakpak nzəngtəng ka̱ apal oza̱. Ìzhe va̱ ta i yà ìji anəm uga mpyal awop va nəm mmwa ishi ká̱. ");
INSERT INTO yer_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Unəm uga mpyal awop va̱ kà̱ ǹyichi iya̱m inana iji ánəm uro iga nshì, te awá iya̱m inana va̱ uza̱ yichi i yà ajini. ");
INSERT INTO yer_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Nza̱ iya̱m inana ìpir ìkùr nggo va mmá wàng ka̱ ashe achər apər aga nwàng iya̱m, ká̱ nkpaktak iya̱m va̱ mmá fòr ka̱ ashe asu ka̱t te ka̱ ashe asu acham, i yà aji ánəm uga mpyal awop va yichi iya̱m inana va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Kang nza̱ iya̱m inana ìpir ìkùr nggo, iva mmá kál ká̱ mmì ka̱t te mpəsək, te i yà iji ovan aHaruna onunggwan. ");
INSERT INTO yer_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","<<Oga iya̱m va ta̱ nnap mpakpak nləfər iya̱m inana iga ntəm ikángkáng va̱ unəm i yichi ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","A yà pa̱ uza̱ yichi chit ka̱kul aɗəngchi wò, te uza̱ á yichi nzəng ká̱ nzəngkəng ngga ǹyà ká̱ ayist ka̱t gwang ká̱ mmì, ká̱ nzəngkəng ndátdàt ngga ǹyà ká̱ ayist ka̱t, kang ká̱ awoina va mmá ɓìt ká̱ mma̱k ǹyalyal mmá ɓə́l ká̱ mmì. ");
INSERT INTO yer_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Nzəng ká̱ nləfər iya̱m inana iga ntəm ikángkáng wò, uza̱ i yichi iya̱m inana iga aɗəngchi ká̱ nzəngkəng ngga ayist. ");
INSERT INTO yer_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ka̱ ashe nza̱ iya̱m inana nggo te uza̱ i yichi nzəngkəng ûYawe pa̱ nzəng. I yà nji ànəm uga mpyal awop va sháng nchə̀r nləfər ngga ntəm ikángkáng. ");
INSERT INTO yer_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ìzhe nləfər ngga aɗəngchiɗəngchi ka̱kul ntəm ikángkáng mí ri n̂da va uza̱ yichi ká̱. Uza̱ i re aɓuɓo i chu ìpín ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","A yà pa̱ uza̱ yichi nləfər wò ngga nyar nsar nnap-nlà ka̱t te ngga nɗòm ìgwak, te mí ri n̂da va uza̱ yichi ká̱, kang aɓuɓo va̱ re te mí riri kà̱ ìpín ìkpa̱kkpà̱k. ");
INSERT INTO yer_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nnyi te aɓo iya̱m va̱ re ka̱ ashe ìzhe nləfər va̱ ta te, mí shì ka̱ apal nra ngga nshatɗing. ");
INSERT INTO yer_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","A yà pa̱ mmá ri ìzhe ìro ka̱ ashe iya̱m inana iga ntəm ikángkángkankang ka̱ apal nra ngga nshatɗing te, unəm va̱ yichi te mí ka̱m na ka̱t, kang iyəya̱m i yà ika̱mka̱m ka̱t. I ta̱l iya̱m iga ajan, kang unəm va̱ ri ka̱ ashishe te uza̱ i yar nsusur. ");
INSERT INTO yer_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","<<Kang wa ri ìzhe va̱ dok iya̱m iga adak ka̱t, ka̱ aɗor nva̱ ta te wa shì á le ká̱ apər. Ìro va̱ yà ká̱ adak ka̱t te unəm uga ǹyà ká̱ adak ka̱t i riri. ");
INSERT INTO yer_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Unəm va̱ ri ìzhe ka̱ ashe nləfər iya̱m inana iga ntəm ikángkáng va̱ iji aYawe ka̱ awalang va̱ uza̱ ká̱ adak te, mí fa ká̱ na ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","A yà pa̱ unəm dok iya̱m iga adak, mo te unəmləbər uga adak, ka̱t te ìzhe iga adak, ka̱t te aɓo iya̱m iga ajan, kang à ri nləfər iya̱m inana iga ntəm ikángkáng iji aYawe, te mí fa ká̱ na ka̱ ashe onənəm.>> ");
INSERT INTO yer_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","<<Là ôIsa̱rila pa̱, ó yà ká̱ nrí mpip ìna ìnunggwan, ka̱t te ìnagam, ka̱t te ìɓəl ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Kang mpip iya̱m nkang va̱ á kúkú ka̱t te ìzhe iga anyin à gba̱l te, mí nəm inok nəm ká̱ kà̱ nza̱ asa̱l awú nggo, nnyi te nkpak ó ri ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Unəm va̱ kpaktak ri mpip iya̱m nkang iya̱m inana iga nshì va̱ uza̱ yichi ûYawe te, mí fa ká̱ na ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Atak va pa̱ kpaktak ó təm kà̱ te, ó yà ká̱ nrí nchə̀r ìnyil ka̱t te iya̱m nkang ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Unəm va kpaktak ri nchə̀r nro te, mí fa ká̱ na ka̱ ashe onənəm.>> ");
INSERT INTO yer_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","<<Là ôIsa̱rila pa̱, unəm va̱ kà̱ ǹyichi nləfər iya̱m inana iga ntəm ikángkáng ûYawe te, uza̱ á ɓa ká̱ ka̱ ashe nləfər iya̱m inana iga ntəm ikángkáng wò. ");
INSERT INTO yer_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ká̱ awúwo uza̱ i ɓa ká̱ oga iya̱m inana iga nshì ûYawe. Uza̱ i ɓa ká̱ mpip nzəng ká̱ afòr, ka̱kul á yà afor iya̱m inana iga ǹyege kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Unəm uga mpyal awop i shì mpìpip ka̱ apal atak nshì iya̱m awop, kang afufor i yà aji aHaruna ká̱ ovəvan onunggwan. ");
INSERT INTO yer_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ɓu na ìsong iga awó ari ûnəm uga mpyal awop ka̱ ashe nləfər iya̱m ipápà iga ntəm ikángkáng ɓu, wa iya̱m iɓutɓut. ");
INSERT INTO yer_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Uyen aHaruna va̱ yichi nchə̀r ká̱ mpip iya̱m inana ipápà te, ìsong iga awó ari i yà ijini. ");
INSERT INTO yer_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ka̱ ashe nləfər ngga ntəm ikángkáng oIsa̱rila, n yar afòr chit ava̱ mmá yichi á mi ká̱ ìsong iga awó ari ka̱ ashe iya̱m inana iɓutɓut. N na oza̱ ûHaruna unəm uga mpyal awop ká̱ ovan wò onunggwan. Iya̱m va̱ ta̱ nnap mpakpak mbyet mbyet ka̱kul nlwàk ngga mɓa. ");
INSERT INTO yer_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Iya̱m va ta̱ ngba̱k iya̱m inana iga nshì ûYawe va mmá na ûHaruna ká̱ ovəvan onunggwan kà̱ nra va̱ mmá gòr oza̱ wa onəm oga nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","UYawe nak pa̱ oIsa̱rila á na iya̱m va̱ ta̱ ôza̱ á ɓàn kà̱ nra va̱ mmá gòr oza̱ ká̱. Nnap nnəm va̱ ta̱ ka̱kul oga nlwàk oIsa̱rila mbyet mbyet.>> ");
INSERT INTO yer_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Oga nnap mpakpak ngga iya̱m inana ishishì na ta̱, iya̱m inana ìpir ìkùr, iya̱m inana nnap mɓá̱ngɓa̱ng, iya̱m inana mpat, iya̱m inana iga nggòr, kang ká̱ iya̱m inana iga ntəm ikángkáng. ");
INSERT INTO yer_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ka̱ apal aƁam aSinayi ka̱ ashe nzam nà uYawe nak ûMusa oga nnap mpakpak va̱ ta̱ kà̱ ìlum va̱ uza̱ là ôIsa̱rila pa̱ á yichi oga iya̱m inana oza̱. ");
INSERT INTO yer_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","<<Yar uHaruna, ká̱ ovəvan onunggwan, oga ilukwán, mmì ngga nggòr, ìna ìnunggwan iga iya̱m inana nnap mɓá̱ngɓa̱ng, inagam pa̱ iparəm, ká̱ mbandár oga nzəngkəng ngga ǹyà ká̱ ayist ka̱t, ");
INSERT INTO yer_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","te ɓut nkpaktak mɓut onəm ka̱ anung Aghal Mɓut.>> ");
INSERT INTO yer_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Te uMusa á nəm wa nva uYawe nak á na, kang nggatək onəm ɓut ka̱ anung asa̱l Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","UMusa là m̂ɓut onəm pa̱, <<Iya̱m va ta̱ uYawe nak pa̱ mmá nəm.>> ");
INSERT INTO yer_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Te uMusa ɓa ká̱ uHaruna ká̱ ovəvan onunggwan kang à nak oza̱ wòr izər oza̱. ");
INSERT INTO yer_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Uza̱ pá ìlukwan iga ashe ìwángwang ìva ji ûHaruna te uza̱ ran á na ká̱ ngbàt ka̱ aɗək, te uza̱ pá ìro á na ka̱ apəpal, kang à pá ìlukwan ìkoksok á na kà̱. Te uza̱ ran á na ká̱ ngbàt ka̱ aɗək. ");
INSERT INTO yer_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Te uza̱ pá mpuluk ka̱ apal ìlukwan ìkoksok á na, kang à nak aUrim ká̱ aTummim ka̱ ashe ìyen ìlukwan iga apal ìlukwan ìkoksok va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Uza̱ chəp iya̱m ishi á na ka̱ ishi, kang uza̱ pá achuchwal aga azənariya nnà iya̱m ishi iyə́ryər kà̱ mpipyal, wa nva uYawe nak uMusa. ");
INSERT INTO yer_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","UMusa yar mmì ngga nggor kang à gor atak ntəm àYawe ká̱, ká̱ nkpaktak iya̱m va̱ ka̱ ashishe, te uza̱ gar oza̱. ");
INSERT INTO yer_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Uza̱ sháng nro ka̱ apal atak nshì iya̱m awop nva̱ng pa̱ nfangshat, te uza̱ gor atak nshì iya̱m awop ká̱ nkpaktak oga iya̱m inunok, ká̱ adaro, ká̱ atak nchəcher, na á gor oza̱. ");
INSERT INTO yer_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Uza̱ zuk mmì ngga nggor nro ka̱ apal ishi aHaruna kang uza̱ gor na, pa̱ ô gar na. ");
INSERT INTO yer_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Te uMusa ɓa ká̱ ovan aHaruna onunggwan mwàk ilukwan ikoksok ôza̱, ran ngbàt ôza̱ ka̱ aɗək, kang à mwàk iya̱m ishi ôza̱, wa nva uYawe là ûMusa. ");
INSERT INTO yer_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Te uMusa ɓa ká̱ ìna ìnunggwan va̱ ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng, kang uHaruna ká̱ ovan wò onunggwan nak awó oza̱ ka̱ apal ishi ìna ìnunggwan va̱ ta ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Te uMusa pà ìna va̱ ta kang à pá ìfang ka̱ ashe nchə̀r kang à ɓə́l gang ka̱ izər oga nggùnggúng ngga atak nshì iya̱m awop, te uza̱ jen atak nshì iya̱m awop. Uza̱ tar nchə̀r ka̱ akum atak nshì iya̱m awop kang à gar ka̱kul mmwa ishíshi. ");
INSERT INTO yer_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","UMusa wur nkpaktak mpip va̱ ka̱ izər iya̱m afu, ká̱ mpip ngga apal anì, ká̱ arùsòk aga aparəm ká̱ mpip oza̱, kang uza̱ shì oza̱ ka̱ apal atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Nnyi te, uza̱ yar aɓo ìna ìnunggwan va̱ ta, awá, ìzhe ká̱ aməməng, te uza̱ shì ká̱ apər kà̱ nsəm apa̱k wa nva uYawe nak ûMusa. ");
INSERT INTO yer_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Te uza̱ yichi ìnagam va̱ ka̱kul iya̱m inana iga nshì, kang uHaruna ká̱ ovan wò onunggwan nak awó oza̱ ka̱ apal ishi ìnagam va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Te uMusa pà ìnagam va̱ ta, kang à sháng nchə̀chər kà̱ nkpaktak ngba̱k atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Uza̱ nyat ìnagam va̱ ta pa̱ nyimənnyimən, kang uza̱ shì ishíshi, ká̱ ìnyátnyat va̱ ta, ká̱ mpip. ");
INSERT INTO yer_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Te uza̱ nàl oga iya̱m afu ká̱ oga mbwàngbwàng ká̱ ndəng. Uza̱ shì ìnagam va̱ ta pa̱ ɗot ka̱ apal atak nshì iya̱m awop. Á yà chit iya̱m inana iga nshì pa̱ ɗot inə́ngnəng ichángchàng ûYawe, wa nva uYawe nak ûMusa. ");
INSERT INTO yer_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Á le te uza̱ ɓa ká̱ ìnagam iga ìparəm, ìnagam iga nggòr, te uHaruna ká̱ ovan wò onunggwan nak awó oza̱ ka̱ apal ishi ìnagam va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Te uMusa pà ìnagam va̱ ta kang à dok nchə̀chər ɓàp ka̱ achwang aHaruna aga awó ari, ká̱ ìfəfang ìnunggwan iga awó ari, ká̱ ìfəfang ìnunggwan iga ashar ari. ");
INSERT INTO yer_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","UMusa ɓa ká̱ ovan aHaruna kang à ɓàp nchə̀r kà̱ oga achwang oza̱ aga awó ari, ká̱ ifang oza̱ inunggwan iga awó ari, ká̱ ifang oza̱ inunggwan iga ashar ari. Te uMusa sháng nchə̀chər kà̱ nkpaktak ngba̱k atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Te uza̱ yar mpip, ká̱ mpip aswal, ká̱ nkpaktak mpip va̱ ka̱ apal oga iya̱m afu, ká̱ mpip ngga apal anì, ká̱ arùsòk aga aparəm ká̱ mpip oza̱, ká̱ ìsong iga awó ari. ");
INSERT INTO yer_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ka̱ ashe mbandár nzəngkəng ngga ǹyà ká̱ ayist ka̱t nva kà̱ mpyal àYawe te, uza̱ yar nzəngkəng ngga mmì pa̱ nzəng, ká̱ awoina pa̱ zəng, ká̱ nzəngkəng ndátdàt ngga ǹyà ká̱ ayist ka̱t pa̱ nzəng, te uza̱ nak oza̱ ka̱ apal mpip ká̱ ìsong iga awó ari. ");
INSERT INTO yer_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Uza̱ nak nkpaktak oga iya̱m va̱ ta̱ ka̱ ashe awó aHaruna ká̱ ovəvan onunggwan kang à yege oza̱ kà̱ mpyal àYawe wa iya̱m inana iga ǹyege. ");
INSERT INTO yer_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Te uMusa wur oga iya̱m va̱ ta ka̱ awó oza̱ kang à shì ka̱ apal atak nshì iya̱m awop ka̱ apal atak iya̱m inana iga nshì, wa iya̱m inana iga nggòr inə́ngnəng ichángchàng, iya̱m inana iga nshì ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Uza̱ yar afòr te yege na wa iya̱m inana iga ǹyege kà̱ mpyal àYawe. Afòr va aji aMusa ka̱ ashe ìnagam iga nggòr, wa nva uYawe nak ûMusa. ");
INSERT INTO yer_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Te uMusa yar ka̱ ashe mmì ngga nggòr nro ká̱ nchə̀r nro va̱ ka̱ apal atak nshì iya̱m awop kang à sháng ka̱ apal aHaruna ká̱ ilukwanlukwan, ka̱ apal ovəvan onunggwan ká̱ ilukwan oza̱. Te uza̱ gár uHaruna ká̱ ilukwanlukwan, ká̱ ovəvan onunggwan ká̱ ilukwan oza̱. ");
INSERT INTO yer_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Te uMusa là ûHaruna ká̱ ovəvan onunggwan pa̱, <<Pə́k ìzhe ka̱ anung Aghal Mɓut kang ɓù ri ka̱ ta ká̱ nzəngkəng va̱ ka̱ ashe mbandár iya̱m inana iga nggòr, wa nva n nak, pa̱, <UHaruna ká̱ ovan wò onunggwan i ri.> ");
INSERT INTO yer_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Te shì aɓo ìzhe ká̱ nzəngkəng va̱ le. ");
INSERT INTO yer_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ɓu yà ká̱ nré anung Aghal Mɓut ka̱t ka̱ apal nra pa̱ nfangshat, ya nra ngga nggòr ɓu i yə́l kang, ka̱kul nggòr ɓu i yar nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Iya̱m va̱ mmá nəm n̂da va̱ ta̱ te uYawe à nak pa̱ mmá nəm ka̱kul mmwa ishi ɓu. ");
INSERT INTO yer_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Nkpak ɓu ta̱l ka̱ anung Aghal Mɓut ìzwam ká̱ alum ka̱kul nra pa̱ nfangshat kang ɓu kpak nnap nnəm va̱ uYawe là, le kang wa kú ka̱t, ka̱kul iya̱m va ta mmá nak á mi.>> ");
INSERT INTO yer_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Te uHaruna ká̱ ovan wò onunggwan nəm nkpaktak iya̱m va̱ uYawe nak ka̱ atak aMusa. ");
INSERT INTO yer_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ka̱ apal nra ngga nna̱nne te uMusa wór uHaruna ká̱ ovəvan onunggwan, ká̱ onəmgbak oga aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Uza̱ là ûHaruna pa̱, <<Kpán ìyen ìna ìnunggwan ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng ɓu ká̱ ìnagam ka̱kul iya̱m inana iga nshì, nkpaktak oza̱ á yà ká̱ nɗaktak ka̱t, te yichi oza̱ kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Te là ôIsa̱rila pa̱, <Kpán ìɓəl ìnunggwan ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng, ìna ká̱ ìnagam iga ìzun pa̱ ìzəng, ìva yà ká̱ nɗaktak ka̱t, ka̱kul iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Kà̱ ɗi te, yar ìna ìnunggwan ká̱ ìnagam ka̱kul nləfər iya̱m inana iga ntəm ikángkáng kà̱ mpyal àYawe, ká̱ iya̱m inana ìpir ìkùr gwang ká̱ mmì. Ka̱kul n̂da va ta̱ uYawe i ga nnyám ishi wò á wó.> >> ");
INSERT INTO yer_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Oza̱ ɓa ká̱ iya̱m va̱ uMusa nak ôza̱ kà̱ mpyal Aghal Mɓut, kang nkpaktak onəm ɓa tong kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Te uMusa là pa̱, <<Iya̱m va ta̱ uYawe nak wó pa̱ ó nəm, na á nyám ìzhàn àYawe á wó.>> ");
INSERT INTO yer_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Te uMusa là ûHaruna pa̱, <<Ɓa atak nshì iya̱m awop, te yichi iya̱m inana nnap mɓá̱ngɓa̱ng, ká̱ iya̱m inana iga nshì ɓu. Te nəm mmwa ishi nji ɓu ká̱ ishi onəm, te ɓa ká̱ iya̱m inana onəm kang ɓù nəm mmwa ishi oza̱ wa nva uYawe nak.>> ");
INSERT INTO yer_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Te uHaruna ɓa dát ká̱ atak nshì iya̱m awop kang à pà ìna ìnunggwan, ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ngɓa̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Kang ovan aHaruna onunggwan ɓa ká̱ nchə̀r á na, te uza̱ pá ìfang wò ka̱ ashe nchə̀r kang à ɓə́l ka̱ izər oga nggùnggúng ngga atak nshì iya̱m awop. Uza̱ tar aɓo nchə̀r va̱ ta ka̱ akum atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Nnyi te, mpip, oga arùsòk, ká̱ mpip ngga apal anì ka̱ ashe iya̱m inana nnap mɓá̱ngɓa̱ng, uza̱ shì ka̱ apal atak nshì iya̱m awop, wa nva uYawe nak ûMusa. ");
INSERT INTO yer_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Uza̱ shì ìzhe ká̱ awá kà̱ nsəm apa̱k. ");
INSERT INTO yer_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Te uza̱ pà iya̱m inana iga nshì. Ovan aHaruna onunggwan ɓa ká̱ nchə̀r á na, kang uza̱ sháng gang oga ngba̱k izər atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Oza̱ ɓa ká̱ iya̱m inana iga nshì á na, inyatnyat, nzəng ká̱ ishi, kang uza̱ shì oza̱ ka̱ apal atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Uza̱ nàl iya̱m afu ká̱ oga mbwangbwang kang à shì oza̱ ka̱ apal atak nshì iya̱m awop nzəng ká̱ iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","UHaruna yichi iya̱m inana iji onəm. Uza̱ kpán ìɓəl ìnunggwan va̱ ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng onəm pà, kang à yichi na wa iya̱m inana nnap mɓá̱ngɓa̱ng wa nva uza̱ ka̱ nəm ká̱ iga nggəshi. ");
INSERT INTO yer_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Uza̱ ɓa ká̱ iya̱m inana iga nshì kang à yichi wa nva nnap mpakpak là. ");
INSERT INTO yer_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","A le te uza̱ yichi iya̱m inana ìpir ìkùr, uza̱ kpa̱k ka̱ ashishe ka̱ awó pa̱ súr, te shì ka̱ apal atak nshì iya̱m awop kà̱ ngba̱k iya̱m inana iga nshì ká̱ ìpín. ");
INSERT INTO yer_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Te uza̱ pà ìna ìnunggwan ká̱ ìnagam wa nləfər iya̱m inana iga ntəm ikángkáng iji onəm. Ovan aHaruna ɓa ká̱ nchə̀r á na, kang uza̱ sháng kà̱ nkpaktak ngba̱k atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Nnyi te, mpip ìna ká̱ ìnagam, mpip aswal, mpip va̱ gún oga iya̱m afu, oga arùsòk, ká̱ mpip ngga apal anì, ");
INSERT INTO yer_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","oza̱ nak oga mpip va̱ ta̱ ka̱ apal afòr, te uHaruna shì oga mpip va̱ ta ka̱ apal atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Kang uHaruna yege afòr ká̱ ìsong iga awó ari kà̱ mpyal àYawe, wa iya̱m inana iga ǹyege, wa nva uMusa nak. ");
INSERT INTO yer_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","UHaruna yichi awó wò ka̱ apal onəm kang uza̱ nak nnap nnəna̱n ôza̱. Nva̱ngva̱ uza̱ yichi iya̱m inana nnap mɓá̱ngɓa̱ng, ká̱ iga nshì, ká̱ iga ntəm ikángkáng, te uza̱ fə́r vàng. ");
INSERT INTO yer_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","UMusa ká̱ uHaruna táng ashe Aghal Mɓut. Kà̱ nva̱ng va̱ oza̱ fa te, oza̱ nak nnap nnəna̱n ônəm kang ìzhàn àYawe fa n̂kpaktak onəm. ");
INSERT INTO yer_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Apər fa ka̱ atak aYawe kang à ri iya̱m inana iga nshì, ká̱ mpip va̱ ka̱ apal atak nshì iya̱m awop. Awalang va̱ nkpaktak onəm ya te, oza̱ gham achu, ru zəp ká̱ afu kà̱ mbin. ");
INSERT INTO yer_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ǹyangmata̱ uNadap ká̱ uAbihu Ovan aHaruna onunggwan, udanggo yar asu apər wò nak apər ka̱ ashishe kang oza̱ nak njəng nnə́ngnəng ka̱ apəpal, te oza̱ yichi apər agafak kà̱ mpyal àYawe, ava uza̱ nak oza̱ kà̱ ka̱t á. ");
INSERT INTO yer_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Ta byet te, uYawe re nrè ká̱ apər pwák oza̱ kang oza̱ kú kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Te uMusa là ûHaruna pa̱, <<Iya̱m va ta̱ uYawe là nva̱ uza̱ là pa̱, << <Nkpaktak onəm va̱ nəm inok á mi te nkpak i yar mi uyə́ryər, kang mi nyám ìzhàn mi ônəm mi.> >> Nnyi te, uHaruna ma̱r pa̱ kwák. ");
INSERT INTO yer_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","UMusa wór uMishayel ká̱ uEləzafan, ovan aUza̱yel onunggwan ukyan àHaruna, uza̱ là ôza̱ pa̱, <<Ó ɓa ka̱ ta̱, ó wur akúm onal wó á le kà̱ mpyal Atak Ayə́ryər ó ga ká̱ kà̱ nsəm apa̱k.>> ");
INSERT INTO yer_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Te oza̱ ɓa dát kang à wur oza̱ ká̱ ilukwán awop nna à yà ka̱ izər oza̱ fa ká̱ kà̱ nsəm apa̱k wa nva̱ uMusa là. ");
INSERT INTO yer_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Te uMusa là ûHaruna ká̱ ovəvan uEliyaza ká̱ uItama pa̱, <<Kang ó re akpap ishi wó a nyat ka̱t, kang ó kan ilukwán wó ka̱t, ka̱t te ó kú kang mmən ìkum àYawe i fə́r ka̱ apal nkpaktak nzhi àIsa̱rila. Nnyi te, onal wó ká̱ nkpaktak nzhi àIsa̱rila i yiyə́ng ka̱kul onəm va̱ uYawe zhì ká̱ apər. ");
INSERT INTO yer_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kang ó fa agbai Aghal Mɓut ka̱t, le kang ó kú, ka̱kul mmì ngga nggòr àYawe nna yà ka̱ apal wó.>> Te oza̱ nəm wa nva uMusa là. ");
INSERT INTO yer_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Te uYawe là ûHaruna pa̱, ");
INSERT INTO yer_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","<<Kang ó wá ndəng ìba̱ngba̱ng ka̱t, ka̱t te iya̱m iwawa ikamkam, mmaɓu ka̱t te ovan ɓu awalang va̱ ó táng ashe Aghal Mɓut, le kang ó kú. Nva̱ ta̱ nnap mpakpak va təm chit mbyet mbyet ka̱kul nkpaktak oga nlwàk wó. ");
INSERT INTO yer_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Nkpak ɓu va̱n ìshimshe iyə́ryər ká̱ iva̱ yər ka̱t, ìshimshe inəna̱n ká̱ iga adak, ");
INSERT INTO yer_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","te ó ɗyáng ôIsa̱rila nkpaktak oga nnap mpakpak va̱ uYawe na ôza̱ ka̱ atak aMusa.>> ");
INSERT INTO yer_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","UMusa là nnàp ká̱ uHaruna ká̱ aɓo ovəvan onunggwan, uEliyaza ká̱ uItama, <<Yar iya̱m inana ìpir ìkùr va̱ le ka̱ ashe oga iya̱m inana iga nshì ûYawe, te ri ká̱ ayist ka̱t kà̱ ngba̱k atak nshì iya̱m awop, ka̱kul iyə́ryər va ji. ");
INSERT INTO yer_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ó ri iya̱m inana ìpir ìkùr ka̱ Atak Ayə́ryər ka̱kul iya̱m iji ɓu ká̱ ovan ɓu onunggwan ka̱ ashe iya̱m inana iga nshì ûYawe, ka̱kul wa nnà ta mmá nak á mi. ");
INSERT INTO yer_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Nnyi te, mmaɓu ká̱ ovan ɓu onunggwan ká̱ ochar mmá məma̱n á wó pa̱ ó ri afòr iya̱m inana iga ǹyege ká̱ isong va̱ mmá yichi ka̱ atak anəna̱n. Ka̱kul ɓu ká̱ ovan ɓu va̱ ká̱ ɓu, ka̱kul mmá na oza̱ á ɓu chit iji ɓu ká̱ ovan ɓu ka̱ ashe nləfər iya̱m inana iga ntəm ikángkáng oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Isong iɓutɓut ká̱ afòr iya̱m inana iga ǹyege va̱ mmá yege, nkpak mí ɓa ká̱, ká̱ ngba̱k mpip ngga iya̱m inana iga nshì, te mí yege wa iya̱m inana iga ǹyege kà̱ mpyal àYawe. Te iya̱m va̱ ta̱ i yà iji ɓu ká̱ ovan ɓu onunggwan mbyet mbyet, wa nva uYawe nak.>> ");
INSERT INTO yer_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Nva̱ngva̱ uMusa ɓəp nnap ìɓəl ìnunggwan iga iya̱m inana nnap mɓá̱ngɓa̱ng, kang uza̱ ya mmá shì te, ìgwak lak na kà̱ uEliyaza ká̱ uItama, ovan aHaruna va̱ re, te uza̱ ɓəp pa̱, ");
INSERT INTO yer_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","<<Sang kang ó ri iya̱m inana iga nnap mɓá̱ngɓa̱ng ka̱ ashe Atak Ayə́ryər ka̱t yà? Ka̱kul iyə́ryər va ji, kang mmá na á ɓu ka̱kul ǹyar mpat onəm, na ú mwa ishi ká̱ ka̱kul oza̱ kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Dər, nchə̀chər mmá ɓa ká̱ ka̱ ashe Atak Ayə́ryər ka̱t, te á màl pa̱ ká̱ ó ri ka̱ ashe Atak Ayə́ryər wa nva n nak á.>> ");
INSERT INTO yer_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Te uHaruna là ûMusa pa̱, <<Dər, n̂da va̱ ta̱ oza̱ yichi iya̱m inana nnap mɓá̱ngɓa̱ng oza̱ ká̱ iya̱m inana iga nshì oza̱ kà̱ mpyal àYawe. Apir nnap nnəm va̱ ta̱ ya mi chit. Ká̱ yà pa̱ n ri iya̱m inana iga nnap mɓá̱ngɓa̱ng ri n̂da va̱ ta̱, te ká̱ yà dakdak kà̱ mpyal àYawe ɗò?>> ");
INSERT INTO yer_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","UMusa fe nnap va̱ ta te, uza̱ məma̱n ká̱. ");
INSERT INTO yer_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","UYawe là ûMusa ká̱ uHaruna pa̱, ");
INSERT INTO yer_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","<<Là ôIsa̱rila pa̱, ka̱ ashe nkpaktak izhé iga apambin te, iya̱m iga irirì va ta̱ ó ri. ");
INSERT INTO yer_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Ìzhe va̱ ká̱ ifir kap pa̱ iparəm kang i ɓələk nrì ɓələk te ó riri. ");
INSERT INTO yer_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ká̱ nnà te, ó yà ká̱ nrí ka̱ ashe iva̱ ta̱ ka̱t, iva̱ i ɓələk nrì ɓələk kang ififir kap ka̱t. ALakəmi, káp ká̱ nva̱ i ɓələk nrì ɓələk te ififir kap ka̱t. Ká̱ adak ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ìchəm, káp ká̱ nva̱ i ɓələk nrì ɓələk, te ififir kap ka̱t. Ká̱ adak ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ìzum, káp ká̱ nva̱ pa̱ i ɓələk nrì ɓələk, ififir kap ka̱t. Ká̱ adak ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ìrì, káp ká̱ nva̱ pa̱ ififir kəkàp, i ɓələk nrì ka̱t. Ká̱ adak ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ó yà ká̱ nrí ìzhe oza̱, ka̱t te ó dok akúm oza̱ ka̱t, oza̱ ká̱ adak ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","<<Oga iya̱m va ta̱ ó riri ka̱ ashe nkpaktak iya̱m iga ashe ndəng. Nza̱ iya̱m nggo va̱ ka̱ ashe ndəng ká̱ iya̱m iga ǹyel ndəng ká̱ akwarak, mo te ka̱ ashe ìwá ka̱t te oga awáng, ó ri oza̱ ri. ");
INSERT INTO yer_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Nnyi te, nza̱ iya̱m nggo va̱ ka̱ ashe ìwá ka̱t te oga awáng va̱ yà ká̱ iya̱m iga ǹyel ndəng ká̱ akwarak ka̱t ka̱ ashe nkpaktak oga iya̱m va i yiyel ka̱ ashe ndəng, ká̱ nkpaktak iya̱m irirì iga ashe ndəng, oza̱ iya̱m iga ajan ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Oza̱ iya̱m iyə́ryər ka̱ atak wó, ó yà ká̱ nrí ìzhe oza̱ ka̱t. Akúm oza̱ ó nak i sat iya̱m iga ajan ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Nza̱ iya̱m nggo va ka̱ ashe ndəng yà ká̱ iya̱m iga ǹyel ndəng ká̱ akwarak ka̱t te, iya̱m iga ajan ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","<<Ka̱ ashe oga inyil va̱ ta̱ ó nak i yà iya̱m iga ajan, ó ri ka̱t. Oza̱ iya̱m iga nnəm ajan, nkpak pa̱ ó ri oza̱ ka̱t, ka̱kul oza̱ ká̱ adak òmà nkumàngga̱p, nggùlúk, nggùlúk nləbər, ");
INSERT INTO yer_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ìkə̀ka̱p, ká̱ apir oga ikəkàl pa̱ ɗongɗong. ");
INSERT INTO yer_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Nza̱ apir ìgurok nggo, ");
INSERT INTO yer_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ká̱ ajimina, ìzəng, ìnyil ndəng, ìkəkàl, ");
INSERT INTO yer_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ìzəng ìɓwakan, ìtula iga anyin, ká̱ ìwórkú, ");
INSERT INTO yer_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ìzəng ìləfər, ìzəng iga ashe nzam, nggùlúk, ");
INSERT INTO yer_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ká̱ ìɓo, oga mbyapbyap, ìgulyat ká̱ mɓiləm. ");
INSERT INTO yer_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","<<Nza̱ iya̱m nra̱m nggo iga alyàng va i chen ká̱ ashar pa̱ neɗing te, i yà iya̱m iga ajan ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ká̱ nnà te, o ri nkpaktak iya̱m nra̱m iga alyàng iva̱ ká̱ ashar pa̱ neɗing, kang ká̱ agwap ka̱kul mmyatmyat. ");
INSERT INTO yer_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ó rirí ka̱ ashe iva̱ ta̱. Oga mban ìkum nza̱ apir nggo, oga arəgba̱k nza̱ apir nggo, oga igigyak nza̱ apir nggo ká̱ oga akangshat nza̱ apir nggo. ");
INSERT INTO yer_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ká̱ nnà te iya̱m nra̱m iga alyàng va̱ ká̱ ashar pa̱ neɗing te iya̱m iga ajan ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","<<Iga iya̱m va ta̱ i nak wó ó yà ká̱ adak. Nza̱ unəm nggo va̱ dok akúm oza̱ te i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Kang nza̱ unəm nggo va̱ wur oga akúm oza̱ te, uza̱ i nàl ìlukwan wò kang uza̱ i təm ugga adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Nza̱ ìzhe nggo va̱ kak ifir pa̱ iparəm ka̱t, ka̱t te i ɓələk nrì ka̱t, te oza̱ ká̱ adak ka̱ atak wó. Nkpaktak unəm va̱ dok oza̱ te uza̱ i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Nza̱ iya̱m nggo ka̱ ashe ìzhe iga ashar pa̱ neɗing va̱ i chen ká̱ ndong ashar wò te, oza̱ ká̱ adak ka̱ atak wó. Nkpaktak unəm va̱ dok akúm oza̱ te uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Kang nkpaktak unəm va̱ wur akúm oza̱ te, uza̱ i nàl ilukwan wò kang uza̱ i təm uga adak i ga i chu arurong. Oza̱ ká̱ adak ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","<<Oga iya̱m iga nkpàng ká̱ afu ka̱ ashe iya̱m iga nkpàng kà̱ mbin va̱ ta̱ te ká̱ adak ka̱ atak wó. ìshakmən, ìpi, apir oga iɓoli inənang pa̱ ɗongɗong, ");
INSERT INTO yer_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ìɓaligànggang, ìkun, ìɓoli, ìshang, ká̱ ìtasəm. ");
INSERT INTO yer_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Iva ta̱ ka̱ ashe nkpaktak izhé iga nkpàng kà̱ mbin iya̱m iga ajan ka̱ atak wó. Unəm va̱ kpaktak dok oza̱ ya oza̱ kú chit te, uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Nkpaktak iya̱m va̱ oza̱ ru kà̱, ka̱ awalang va̱ oza̱ kú chit te, i yà ká̱ adak. Mo te iya̱m inok iga akun ka̱t te ìlukwan, ka̱t te awá, ka̱t te ìlukwan ìlóklòk, ka̱t te nza̱ iya̱m inok nggo. Kang mí nəm inok ká̱ te, pá ka̱ ashe ndəng, te i yà ká̱ adak i ga i chu arurong, nnà chit te i yà inəna̱n ɗak. ");
INSERT INTO yer_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kang a yà pa̱ iro ka̱ ashe oza̱ ru ka̱ ashe ngbət amè, nza̱ iya̱m nggo va ka̱ ashishe te i yà ká̱ adak, te nkpak ó chwan. ");
INSERT INTO yer_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Iya̱m nrì va̱ ndəng ngga ashe iya̱m inok va̱ ta sháng kà̱ te, i yà ká̱ adak. Kang nza̱ iya̱m iwawa nggo va̱ ka̱ ashe iya̱m inok va̱ ta, i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Iya̱m va kpaktak akúm oza̱ ru kà̱ te i yà ká̱ adak. Achər apər aga nwàng iya̱m, ka̱t te achər, te mí shin, oza̱ ká̱ adak, iya̱m iga adak ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ká̱ nnà kpa te, ìwú ndəng ka̱t te ache agga nkpán ndəng i yà anəna̱n, kang unəm va̱ dok akúm va̱ ka̱ ashishe te uza̱ i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","A yà pa̱ ngba̱k akúm oza̱ nro ru ka̱ apal apir iya̱m nsuk, te i yà inəna̱n, ");
INSERT INTO yer_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","nnyi te a yà pa̱ mmá nak ndəng chit ka̱ apal apir iya̱m nsuk va̱ ta, kang ngba̱k akúm oza̱ nro ru ka̱ apəpal te, ká̱ adak ka̱ atak wó. ");
INSERT INTO yer_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","<<A yà pa̱ ìzəngtəng ka̱ ashe ìzhe va̱ mmá məma̱n á ɓu pa̱ ú ri kang à kú, kang nkpaktak unəm va̱ dok akúkum te uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Kang nza̱ unəm nggo va̱ ri akúkum te i nàl ilukwán wò kang uza̱ i yà ká̱ adak i ga i chu arurong. Kang nza̱ unəm nggo va̱ wur akúkum te i nàl ilukwán wò kang uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","<<Nza̱ iya̱m iga irirì nggo va̱ i kpàng ká̱ afu kà̱ mbin te iya̱m iga nnəm ajan, mí ri oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Nza̱ iya̱m nggo iga nkpàng ká̱ afu, ká̱ iga nchen ká̱ ashar pa̱ neɗing ka̱t te ashar pa̱ kyák ka̱ ashe nkpaktak iya̱m iga irirì iga nkpàng ká̱ afu kà̱ mbin ó ri ka̱t, ka̱kul oza̱ ká̱ ajan. ");
INSERT INTO yer_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Kang ó nak ishi wó a yà iga ajan ká̱ iya̱m va̱ i kpàng ká̱ afu ka̱t. Kang ó nak ishi wó a yà ká̱ adak, na ó yà oga adak ka̱ atak oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ka̱kul mmami na uYawe, Inan wó. Ó gòr ishi wó na ó yà oyə́ryər ka̱kul mmami uyə́ryər. Kang ó vyap ishi wó ka̱ atak oga iya̱m iga nkpàng ká̱ afu kà̱ mbin ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ka̱kul mmami na uYawe, uva̱ fa ká̱ wó kà̱ mbin aMasar na ń yà Inan wó. Ó yà oyə́ryər ka̱kul mmami uyə́ryər.>> ");
INSERT INTO yer_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Nnap mpakpak nà ta̱ ka̱kul iya̱m nkang, inyil, ká̱ nkpaktak iya̱m iga irirì va̱ ka̱ ashe ndəng ká̱ nkpaktak iya̱m iga irirì iga nkpàng ká̱ afu kà̱ mbin. ");
INSERT INTO yer_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ka̱kul na mmá va̱n ìshimshe iya̱m iga adak ká̱ iva̱ iga adak ka̱t, ìshimshe izhé va̱ màl pa̱ mmá ri ká̱ iva̱ màl pa̱ mmá ri ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","<<Là ôIsa̱rila pa̱, a yà pa̱ uchar təm ká̱ anyám kang à mar uyen ununggwan te, uza̱ i yà ká̱ adak nra pa̱ nfangshat. Wa nva uza̱ ka̱ yà kà̱ nra va̱ uza̱ ka̱ yà ká̱ akpar, uza̱ i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Mí pà achè ûyen va̱ ta kà̱ nra ngga nna̱nne. ");
INSERT INTO yer_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Uza̱ i ga mpyal ká̱ nnàl nchə̀r wò i ga i chu nra ìsəm pa̱ ishatɗing ama̱n pa̱ shatɗing. Uza̱ i yà ká̱ ndok iya̱m iro iyə́ryər ka̱t, ka̱t te i tar Atak Ayə́ryər ka̱t, ya uza̱ i gba̱l ká̱ nnàl nchə̀r wò kang. ");
INSERT INTO yer_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Kang a yà pa̱ uza̱ mar uyen uchar te, uza̱ i yà ká̱ adak asati pa̱ parəm wa adak akpar wò. Uza̱ i ga mpyal ká̱ nnàl nchə̀r ka̱ apal nra ìsəm pa̱ ìkpa̱ɗing ama̱n pa̱ kpa̱ɗing. ");
INSERT INTO yer_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","<< <Ìlum va̱ nra ngga nnàl nchə̀r i kùr ka̱kul áyen ununggwan ka̱t te uyen uchar te, uza̱ i ɓa ká̱ ìnagam iga ìzun pa̱ ìzəng ûnəm uga mpyal awop ka̱kul iya̱m inana iga nshì ka̱ anung Aghal Mɓut, kang ká̱ ìləkpar ka̱t te ìruzum ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Unəm uga mpyal awop á yichi oza̱ kà̱ mpyal àYawe kang ì mwa ishishi ká̱. Te uza̱ i yà unálnàl ka̱ atak nzuk nchə̀r wò. Nnap mpakpak va ta̱ ka̱kul áchar va̱ mar ununggwan ka̱t te uchar. ");
INSERT INTO yer_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Kang a yà pa̱ uza̱ yà ká̱ ìnagam ka̱t, te uza̱ á wur ilə́kpár pa̱ iparəm ka̱t te iruzum pa̱ iparəm. Pa̱ ìzəng ka̱kul iya̱m inana iga nshì kang ìzəngtəng ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng. Te unəm uga mpyal awop i mwa ishishi ká̱ kang uza̱ i yà unəna̱n.> >> ");
INSERT INTO yer_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","UYawe là ûMusa ká̱ uHaruna pa̱, ");
INSERT INTO yer_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","<<A yà pa̱ awá izər ánəmləbər mu, ka̱t te izər iwárwár, ka̱t te mɓàp nləfər va̱ á wong á yà arwa nlak ka̱ apal awá izəzər, te mí ɓa ká̱ na ka̱ atak aHaruna unəm uga mpyal awop, ka̱t te ka̱ atak azəngtəng ka̱ ashe ovəvan oga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Unəm uga mpyal awop á nak ìwú ka̱ arwa va̱ ka̱ awá izəzər, kang a yà pa̱ akpap aga ìwú arwa va̱ ta a ga̱ɓa̱n aləfər kang ìwú arwa á gbà̱ng te, arwa nlak. Unəm uga mpyal awop i dər te i shet pa̱ uza̱ ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Nnyi te, a yà pa̱ mɓàp nləfər va̱ ka̱ awá izəzər gbà̱ng ji awá izər ji ka̱t, kang akpàp va̱ ka̱ ashishe ga̱ɓa̱n yà aləfər ka̱t, te unəm uga mpyal awop i kùk na nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ka̱ apal nra ngga nfangshat te unəm uga mpyal awop a dər na pa̱ ɗóng, kang a yà pa̱ arwa va̱ ta ga̱ɓa̱n kà̱ ìwúwu ka̱t, á lok gang izəzər ka̱t, te unəm uga mpyal awop i kùk na kà̱ ɗi nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Unəm uga mpyal awop a dər na pa̱ ɗóng kà̱ nra ngga nfangshat kà̱ ɗi. Kang a yà pa̱ arwa va̱ ta pwar chit a lok gang awá izər ka̱t, te unəm uga mpyal awop i shet pa̱ uza̱ yà ká̱ adak ka̱t, izər iwárwár nà pa mwang. Te uza̱ i nàl ìlukwan wò, te uza̱ i yà ká̱ adak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Kang a yà pa̱ izər iwárwár lok ga mpyal kà̱ nva̱ng va̱ uza̱ nyám ishi wò ûnəm uga mpyal awop chit ka̱kul nnàl izər wò, te uza̱ i nyám ishi wò ûnəm uga mpyal awop kà̱ ɗi. ");
INSERT INTO yer_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Unəm uga mpyal awop i dər na, kang a yà pa̱ izər iwárwár va̱ ta lok chit gang izəzər, te unəm uga mpyal awop i shet pa̱ uza̱ ká̱ adak, arwa nlak.>> ");
INSERT INTO yer_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","<<A yà pa̱ arwa nlak kpán unəmləbər, te mí ɓa ká̱ na ûnəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Unəm uga mpyal awop i dər na, kang a yà pa̱ izər mu iləfər kang à ga̱ɓa̱n akpap chit aləfər, kang izər imúmu va̱ ta tung anunur te, ");
INSERT INTO yer_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","arwa nlak mɓá̱ngɓa̱ng ka̱ awá izəzər. Te unəm uga mpyal awop i shet pa̱ uza̱ ká̱ adak, uza̱ i kuk na ka̱t, ka̱kul uza̱ ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kang a yà pa̱ arwa va̱ ta á fa ka̱ izər, kang à dàngchi nkpaktak awá izər ánəm uga arwa, ɓàn ka̱ ishishi vàng ashishar, va ìwú ànəm uga mpyal awop yiya, ");
INSERT INTO yer_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","unəm uga mpyal awop i dər, kang a yà pa̱ arwa awá izər va̱ ta dàngchi izəzər pa̱ kpaktak, te uza̱ i shet pa̱ unəm uga arwa va̱ ta yà ká̱ adak ka̱t. Ka̱kul á ga̱ɓa̱n chit yà aləfər, uza̱ yà ká̱ adak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Kang nra va̱ ri anunur te, uza̱ i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","A yà pa̱ unəm uga mpyal awop dər anunur va̱ ta te uza̱ i shet pa̱ uza̱ ká̱ adak. Anunur va̱ ta adak, arwa nlak. ");
INSERT INTO yer_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Nnyi te, a yà pa̱ anunur va̱ ta ga̱ɓa̱n nyáng aləfər kà̱ ɗi, te uza̱ i ga atak ánəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Unəm uga mpyal awop i dər pa̱ ɗóng kang a yà pa̱ arwa va̱ ta ga̱ɓa̱n aləfər, te unəm uga mpyal awop i shet pa̱ unəm uga arwa va̱ ta yà ká̱ adak ka̱t. Uza̱ yà ká̱ adak ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","<<A yà pa̱ nsomo fa ûnəm ka̱ izər kang à tàn, ");
INSERT INTO yer_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","kang a yà pa̱ atak nsomo va̱ ta mu ɓàp nləfər ka̱t te nrəzang ká̱ nləfər, te uza̱ i nyám ishi wò ûnəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Unəm uga mpyal awop i nak ìwú kà̱, kang a yà pa̱ á gbà̱ng ka̱ avəng awá izər, kang akpap va̱ ka̱ ashishe ga̱ɓa̱n chit aləfər, te unəm uga mpyal awop i shet pa̱ uza̱ ká̱ adak. Arwa nlak mɓá̱ngɓa̱ng à fa kà̱ ìwú nsomo. ");
INSERT INTO yer_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Kang a yà pa̱ unəm uga mpyal awop dər pa̱ ɗóng, kang akpap aləfər yà ka̱ ashishe ka̱t, kang à gbà̱ng ka̱ avəng awá izər ka̱t, á pwar chit, te unəm uga mpyal awop i kuk na nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","A yà pa̱ lok gà mpyal ka̱ apal awá izər, te unəm uga mpyal awop i shet pa̱ uza̱ ká̱ adak, arwa. ");
INSERT INTO yer_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Nnyi te, a yà pa̱ mɓàp va̱ ta lok ka̱t á sat ka̱ ta, te ya adál nsomo. Te unəm uga mpyal awop i shet pa̱ uza̱ yà ká̱ adak ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","<<Ka̱t te a yà pa̱ apər à shì unəm ka̱ awá izər, kang atətak ɓàp nrəzang ká̱ nləfər ka̱t te ɓàp nləfər te, ");
INSERT INTO yer_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","unəm uga mpyal awop a dər pa̱ ɗóng. Kang a yà pa̱ akpap aga atak mɓàp va̱ ta ga̱ɓa̱n nləfər kang à gbà̱ng ka̱ avəng awá izər te, ya arwa nlak à fa ka̱ atak nlok apər va̱ ta. Unəm uga mpyal awop i shet pa̱ uza̱ ká̱ adak, arwa nlak. ");
INSERT INTO yer_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Nnyi te, a yà pa̱ unəm uga mpyal awop a dər pa̱ ɗóng, kang akpap aləfər yà ka̱ ashishe ka̱t, kang à gbà̱ng ka̱ avəng awá izər ka̱t, á pwar chit, te unəm uga mpyal awop i kuk na nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Unəm uga mpyal awop i dər na kà̱ nra ngga nfangshat, a yà pa̱ kà̱ ngga mpyal ká̱ nlok izər. Te unəm uga mpyal awop i shet pa̱ uza̱ ká̱ adak, arwa nlak. ");
INSERT INTO yer_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Kang a yà pa̱ mɓàp va̱ ta lok ka̱t á sat ka̱ ta kang à pwar chit, te i yà iya̱m mmu ka̱ atak nshì apər. Unəm uga mpyal awop i shet pa̱ uza̱ yà ká̱ adak ka̱t, ka̱kul adál anunur nshì apər.>> ");
INSERT INTO yer_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","<<A yà pa̱ ununggwan ka̱t te uchar ká̱ arwa ka̱ ishi ka̱t te ìgel, ");
INSERT INTO yer_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Unəm uga mpyal awop i dər arwa va̱ ta pa̱ ɗóng, kang a yà pa̱ a gbà̱ng ka̱ avəng awá izər, kang akpap aga ìwúwu wa ndəng ìlur pa̱ shiriri. Te unəm uga mpyal awop i shet pa̱ uza̱ ká̱ adak. Ndangbyat, arwa nlak aga ishi ka̱t te aga ìgel. ");
INSERT INTO yer_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","A yà pa̱ unəm uga mpyal awop a dər arwa va̱ ta pa̱ ɗóng, kang à nyám gbà̱ng ka̱ avəng awá izər ka̱t, kang akpap aləbər yà ka̱ ashishe ka̱t, te unəm uga mpyal awop i kuk unəm uga ndangbyat va̱ ta nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Kà̱ nra ngga nfangshat te, unəm uga mpyal awop i dər arwa va̱ ta. Kang a yà pa̱ ndangbyat va̱ ta lok ka̱t, kang akpap aga ashishe wa ndəng ìlur ka̱t, kang ndangbyat va̱ ta gbà̱ng ka̱ avəng awá izər ka̱t, ");
INSERT INTO yer_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","te unəm va̱ ta i kpat ishi wò, uza̱ i kpat atak ndangbyat va̱ ta ji wò ka̱t. Unəm uga mpyal awop i kuk na nra pa̱ nfanshat kà̱ ɗi. ");
INSERT INTO yer_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Kà̱ nra ngga nfangshat te unəm uga mpyal awop i dər ndangbyat va̱ ta, kang a yà pa̱ lok gbà̱ng ka̱ avəng awá izər ka̱t, te unəm uga mpyal awop i shet pa̱ uza̱ ká̱ adak. Uza̱ i nàl oga ilukwán wò, te uza̱ i yà ká̱ adak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Kang a yà pa̱ ndangbyat va̱ ta ga mpyal ká̱ nlok ka̱ awá izər kà̱ nva̱ng nnàl na, ");
INSERT INTO yer_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","te unəm uga mpyal awop i dər pa̱ ɗóng. Kang a yà pa̱ ndangbyat lok awá izər chit, te unəm uga mpyal awop i ɗak kà̱ mmo akpap aga ndəng ìlúr ka̱t, uza̱ ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Kang a yà pa̱ kà̱ ndər nji ànəm uga mpyal awop te á ga̱ɓa̱n ka̱t kang akpap aləbər fa chit ka̱ ashishe, te ndangbyat tàn chit, uza̱ yà ká̱ adak ka̱t, te unəm uga mpyal awop i shet pa̱ uza̱ yà ká̱ adak ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","<<A yà pa̱ ununggwan ka̱t te uchar yà ká̱ oga mɓàp nləfər ka̱ awá izər, ");
INSERT INTO yer_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","te unəm uga mpyal awop i nak ìwú kà̱, kang a yà pa̱ mɓàp ngga awá izər va̱ ta gba̱l pa̱ bìt wa nchwang te, izər iwárwár iɓá̱ngɓa̱ng ka̱t à fa ka̱ awá izər. Uza̱ yà ká̱ adak ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","<<A yà pa̱ unəm lang akpap aga ishi wò, te uza̱ ká̱ ìsu ìgbatəng, uza̱ yà ká̱ adak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","A yà pa̱ uza̱ lang akpap kà̱ ìsu wò, uza̱ ugbatəng kà̱ ìsu, te uza̱ yà ká̱ adak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Kang a yà pa̱ ishi igbatəng ka̱t te ìsu ìgbatəng ká̱ mɓàp nrəzang ká̱ nləfər, te ya nlak mɓá̱ngɓa̱ng à fa ka̱ ishishi igbatəng, ka̱t te ìsusu ìgbatəng. ");
INSERT INTO yer_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Unəm uga mpyal awop i dər pa̱ ɗóng, kang a yà pa̱ arwa mmu nrəzang ká̱ nləfər ka̱ apal ishishi igbatəng, ka̱t te ìsusu ìgbatəng, wa nfa nlak mɓá̱ngɓa̱ng ngga izər, ");
INSERT INTO yer_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","te unəm va̱ ta ká̱ nlak mɓá̱ngɓa̱ng, uza̱ ká̱ adak. Unəm uga mpyal awop i shet pa̱ uza̱ ká̱ adak, arurwa ka̱ ishishi.>> ");
INSERT INTO yer_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","<<Unəm va̱ ká̱ arwa nlak te uza̱ i pá aryakryak kang i re akpap ishi wò i la, te uza̱ i gún anung wò ká̱ awó kang i nə́m achu pa̱, <Adak, adak.> ");
INSERT INTO yer_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Uza̱ i yà uga adak nkpaktak awalang va̱ arwa va̱ ta nna à yà kà̱ na, uza̱ ká̱ adak. Uza̱ i təm ká̱ nkukwa, atak ntətəm i yà kà̱ nsəm apa̱k.>> ");
INSERT INTO yer_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","<<A yà pa̱ nlak mɓá̱ngɓa̱ng ka̱ izər ìlukwan iga awúlu, ka̱t te iga alinin, ");
INSERT INTO yer_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ka̱t te iya̱m ilóklòk iga awúlu, ka̱t te alinin, ka̱t te awá, ka̱t te iya̱m iga nnəm ká̱ awá. ");
INSERT INTO yer_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Kang a yà pa̱ arwa nyám ndəng ìpəpa, ka̱t te nrəzang ka̱ izər ìlukwan, ka̱t te awá, ka̱t te iya̱m ilóklòk, ka̱t te nza̱ apir iya̱m nggo va̱ mmá nəm ká̱ awá, te arwa nlak, nkpak mí nyám ûnəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Unəm uga mpyal awop i dər arwa va̱ ta pa̱ ɗóng, kang i kùk iya̱m iga arwa va̱ ta nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Kà̱ nra ngga nfangshat te, unəm uga mpyal awop i dər arwa va̱ ta kà̱ ɗi. A yà pa̱ arwa va̱ ta lok ka̱ izər ìlukwan, ka̱t te iya̱m ilóklòk, ka̱t te awá, ka̱t te nza̱ apir iya̱m nggo va̱ mmá nəm ká̱ awá te, ya arwa nlak mɓá̱ngɓa̱ng, ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Uza̱ i shì ìlukwan va̱ ta, ka̱t te iya̱m ilóklòk, ka̱t te itáttát iga awúlu, ka̱t te alinin, ka̱t te nza̱ iya̱m nggo iga awá va̱ arwa kà̱, ka̱kul nlak mɓá̱ngɓa̱ng, nkpak mí shì ká̱ apər. ");
INSERT INTO yer_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","<<Kang a yà pa̱ unəm uga mpyal awop dər arwa va̱ ta pa̱ ɗóng kang à lok ka̱ izər ìlukwan, ka̱t te iya̱m ilóklòk, ka̱t te itáttát, ka̱t te nza̱ iya̱m iga awá nggo ka̱t, ");
INSERT INTO yer_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","te unəm uga mpyal awop i nak mí nàl iya̱m va̱ arwa ka̱ izəzər kang uza̱ i kuk kà̱ ɗi nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Kà̱ nva̱ng va̱ mmá nàl chit te, unəm uga mpyal awop i dər arwa va̱ ta kà̱ ɗi. A yà pa̱ arwa aga izər iya̱m va̱ ta ga̱ɓa̱n ka̱t, kang arwa va̱ ta lok ka̱t, te ká̱ adak. Nkpak ɓu shì ká̱ apər, a yà pa̱ ka̱ ashe, ka̱t te ka̱ asa̱l nsəm ìlukwan. ");
INSERT INTO yer_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","<<Nnyi te, a yà pa̱ unəm uga mpyal awop dər pa̱ ɗóng, kang atak arwa va̱ ta pwar chit, kà̱ nva̱ng va̱ mmá nàl chit, te uza̱ i cha atak va̱ ta i le ka̱ izər ìlukwan, ka̱t te awá, ka̱t te iya̱m ilóklòk, ka̱t te itáttát. ");
INSERT INTO yer_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Kang a yà pa̱ á le fa ka̱ izər ìlukwan, ka̱t te iya̱m ilóklòk, ka̱t te itáttát, ka̱t te nza̱ iya̱m iga awá nggo, kà̱ nlok, te nkpak ɓu shì nza̱ iya̱m nggo va̱ ká̱ arwa. ");
INSERT INTO yer_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Kang a yà pa̱ ìlukwan, ka̱t te iya̱m ilóklòk, ka̱t te itáttát, ka̱t te nza̱ iya̱m iga awá nggo, arwa lar ka̱ izər oza̱ ya u nàl chit, te nàl kà̱ ɗi, te i yà ká̱ adak ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Nnap mpakpak nà ta̱ ngga arwa nlak ngga izər ìlukwan awúlu, ka̱t te alinin, ka̱t te iya̱m ilóklòk, ka̱t te itáttát, ka̱t te nza̱ iya̱m iga awá nggo, pa̱ mmá shet pa̱ iga adak ka̱t, ka̱t te iga adak. ");
INSERT INTO yer_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","<<Nnap mpakpak nà ta̱ ka̱ apal ánəm uga arwa nlak kà̱ ìlum iga nnàl na. Mí ɓa ká̱ na ûnəm uga mpyal awop, ");
INSERT INTO yer_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","kang unəm uga mpyal awop i fa nsəm apa̱k, kang i dər na pa̱ ɗóng. A yà pa̱ arwa nlak va̱ ta tàn chit ka̱ izər ánəm uga arwa nlak, ");
INSERT INTO yer_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","te unəm uga mpyal awop i nak unəm uro i ka̱m inyil pa̱ iparəm iga irirì va yà ká̱ nɗaktak ka̱t, akun asida, atani ɓán pa̱ ga̱r, ká̱ azang aro mí wór pa̱ ahisop ka̱kul anəm va̱ mí nàl. ");
INSERT INTO yer_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Te unəm uga mpyal awop i nak pa̱ mmá pà ìzəngtəng ìnyil va̱ ta ka̱ apal ndəng nnəna̱n ka̱ ashe ngbət amè. ");
INSERT INTO yer_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Uza̱ i yar ìnyil iga irirì va̱ ká̱ akun asida, ká̱ atani ɓán pa̱ gà̱r, ká̱ azang ahisop. Uza̱ i mwàk oza̱ ká̱ inyil iga irirì ka̱ ashe nchə̀r inyil va̱ mmá pà ka̱ apal ndəng nnəna̱n. ");
INSERT INTO yer_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Uza̱ i sháng nchə̀r ìnyil va̱ ta nva̱ng pa̱ nfangshat ka̱ apal ánəm va̱ mmá kà̱ nnàl na ka̱ atak arwa nlak, te uza̱ i shet pa̱ uza̱ yà ká̱ adak ka̱t, te uza̱ i sək ìnyil iga irirì va̱ ta i ga ka̱ agbagba. ");
INSERT INTO yer_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Unəm va̱ mmá kà̱ nnàl na te, uza̱ i nàl ìlukwan wò, i kpat nkpaktak akpap wò, kang i wòr izər ka̱ ashe ndəng te i yà ká̱ adak ka̱t. Kà̱ nvəva̱ng te uza̱ i tar ashe apa̱k kang uza̱ i təm kà̱ nsəm aghal wò nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Kà̱ nra ngga nfangshat te uza̱ i kpat nkpaktak akpap wò, ishi, nggyèr, akpap ìwú, ká̱ nkpaktak akpap. Te uza̱ i nàl ìlukwan wò kang i wòr izər wò ka̱ ashe ndəng te i yà ká̱ adak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","<<Kà̱ nra ngga nna̱nne te uza̱ i wur inagam pa̱ iparəm iva yà ká̱ nɗaktak ka̱t ká̱ ìtam ìchar iga ìzun pa̱ ìzəng ìva yà ká̱ nɗaktak ka̱t, ká̱ iya̱m inana ìpir ìkùr mma̱k ǹyalyal ikpáng pa̱ ishatɗing ka̱ ashe agba̱pchi, mmá gwang ká̱ mmì, ká̱ aɓo afal mmì mpyet pa̱ nzəng. ");
INSERT INTO yer_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Unəm uga mpyal awop va̱ i shet pa̱ uza̱ unəna̱n i nak unəm va̱ mí ga nnə̀nal nzəng ká̱ oga iya̱m va̱ ta̱ kà̱ mpyal àYawe ka̱ anung Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Unəm uga mpyal awop i kpán ìnagam pa̱ ìzəng i yichi wa iya̱m inana mpat nzəng ká̱ mmì mpyet, kang uza̱ i yege oza̱ wa iya̱m inana iga ǹyege kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Uza̱ i pà ìnagam va̱ ta ka̱ atak mpà iya̱m inana iga nnap mɓá̱ngɓa̱ng, ká̱ iga iya̱m inana iga nshì ka̱ ashe Atak Ayə́ryər. Ka̱kul iya̱m inana iga nnap mɓá̱ngɓa̱ng wa iya̱m inana iga mpat, iji ánəm uga mpyal awop, iyə́ryər va ji. ");
INSERT INTO yer_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Unəm uga mpyal awop i pá nchə̀r iya̱m inana mpat i ɓàp ka̱ achwang aga awó ari, ká̱ ìfang ìnunggwan iga awó ari, ká̱ ìfang ìnunggwan iga ashar ari ánəm va̱ mí ga nnə̀nal. ");
INSERT INTO yer_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Unəm uga mpyal awop i yar aɓo mmì mpyet va̱ ka̱ ashe afàl i zuk ka̱ ashe awó wò apa̱m. ");
INSERT INTO yer_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Unəm uga mpyal awop i pá ìfang wò iga awó ari ka̱ ashe mmì va̱ ka̱ ashe awó wò apa̱m, kang i sháng mmì va̱ ta ká̱ ìfang wò nva̱ng pa̱ nfangshat kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ka̱ ashe aɓo mmì va̱ le ka̱ awúwo te, unəm uga mpyal awop i ɓàp ka̱ achwang aga awó ari ánəm va̱ mmá kà̱ ngga nnàl na, ka̱ apal ìfəfang ìnunggwan iga awó ari, ká̱ apal ìfəfang ìnunggwan iga ashar ari, ka̱ apal nchə̀r iya̱m inana iga mpat. ");
INSERT INTO yer_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Aɓo mmì va̱ le ka̱ ashe awó ánəm uga mpyal awop te, uza̱ i nak ka̱ ishi ánəm va̱ mí ga nnə̀nal. Te unəm uga mpyal awop i mwa ishi ká̱ ka̱kúkul kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Unəm uga mpyal awop i yichi iya̱m inana iga nnap mɓá̱ngɓa̱ng kang i mwa ishi ká̱ ka̱kul ánəm va̱ mmá kà̱ nnàl adədak. Kà̱ nvəva̱ng te uza̱ i pà iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Te unəm uga mpyal awop i yichi iya̱m inana iga nshì ká̱ iya̱m inana ìpir ìkùr ka̱ apal atak nshì iya̱m ngwop. Wa nnà ta unəm uga mpyal awop i mwa ishi ká̱ ka̱kúkul, te uza̱ i yà ká̱ adak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","<<Kang a yà pa̱ uza̱ ka̱ ashe nkun va oga iya̱m va̱ ta̱ i ma̱t na kà̱ mɓa ká̱ te, uza̱ i ɓa ká̱ ìnagam pa̱ ìzəng wa iya̱m inana mpat. Ka̱kul iya̱m inana iga ǹyege, na mmá mwa ishi ká̱ ka̱kúkul nzəng ká̱ mma̱k ǹyalyal ìkpáng pa̱ ìzəng ka̱ ashe agba̱pchi gwang ká̱ mmì, ká̱ aɓo afal mmì mpyet ka̱kul iya̱m inana ìpir ìkùr, ");
INSERT INTO yer_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ká̱ iləkpar pa̱ iparəm ka̱t te ivan irúzùm pa̱ iparəm, iva̱ uza̱ ya i na, ìzəngtəng iga iya̱m inana nnap mɓá̱ngɓa̱ng kang ìro iga iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Kà̱ nra ngga nna̱nne te, uza̱ i ɓa ká̱ oza̱ ka̱kul nnàl ishi wò ûnəm uga mpyal awop ka̱ anung Aghal Mɓut kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Unəm uga mpyal awop i ɓa ká̱ ìnagam va̱ ta ká̱ afal mmì ka̱kul iya̱m inana mpat, te unəm uga mpyal awop i yichi oza̱ wa iya̱m inana iga ǹyege kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Unəm uga mpyal awop i pà ìnagam iya̱m inana mpat te i pá nchə̀chər i ɓàp ka̱ achwang aga awó ari, ká̱ ìfang ìnunggwan iga awó ari, ká̱ ìfang ìnunggwan iga ashar ari ánəm va̱ mí ga nnə̀nal. ");
INSERT INTO yer_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Te unəm uga mpyal awop i zuk mmì nro ka̱ awó wò aga apa̱m. ");
INSERT INTO yer_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Unəm uga mpyal awop i pá ìfang wò iga awó ari ka̱ ashe mmì va̱ ka̱ ashe awúwo apa̱m kang i sháng mmì va̱ ta ká̱ ìfang wò nva̱ng pa̱ nfangshat kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ka̱ ashe aɓo mmì va̱ le ka̱ awúwo te, unəm uga mpyal awop i ɓàp ka̱ achwang aga awó ari ánəm va̱ mmá kà̱ ngga nnàl na, ka̱ apal ìfəfang ìnunggwan iga awó ari, ká̱ apal ìfəfang ìnunggwan iga ashar ari, ka̱ atak va̱ mmá nak nchə̀r iya̱m inana iga mpat kà̱. ");
INSERT INTO yer_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Aɓo mmì va̱ le ka̱ ashe awó ánəm uga mpyal awop te, uza̱ i nak ka̱ ishi ánəm va̱ mí ga nnə̀nal. Te unəm uga mpyal awop i mwa ishi ká̱ ka̱kúkul kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Uza̱ i yichi ìro ka̱ ashe iya̱m va uza̱ ya, ka̱ ashe iləkpar ka̱t te ivan iruzum. ");
INSERT INTO yer_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Ìzəngtəng iya̱m inana iga nnap mɓá̱ngɓa̱ng kang ìzəngtəng iya̱m inana iga nshì nzəng ká̱ iya̱m inana ìpir ìkùr. Te unəm uga mpyal awop i mwa ishi ká̱ ka̱kul ánəm va̱ mí ga nnə̀nal kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Nnap mpakpak nnà ta̱ ka̱kul ánəm va̱ ká̱ arwa nlak, kang à yà ká̱ nkàm ngga mmwa iya̱m iga nnàl wò ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","UYawe là ûMusa ká̱ uHaruna pa̱, ");
INSERT INTO yer_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","<<A yà pa̱ ó tar mbin aKanana va mmami kà̱ ngga nna á wó nva i yà nji wó, kang n nak arwa nlak ka̱ ashe nzhi ká̱ mbin va nji wó, ");
INSERT INTO yer_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","unəm uga nzhi va̱ ta i shet ûnəm uga mpyal awop pa̱, <Iya̱m iro nna à fa kà̱ nzhi mi wa arwa.> ");
INSERT INTO yer_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Unəm uga mpyal awop i nak pa̱ oza̱ á wur iya̱m á fa ka̱ ashe nzhi va̱ ta kang uza̱ ì tar ì ga na ô dər arwa va̱ ta pa̱ ɗóng, na kang iya̱m iro ka̱ ashe nzhi va̱ ta a yà ká̱ mbyèt ka̱t, nnà chit te unəm uga mpyal awop i tar ɗak pa̱ ô dər nzhi va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Uza̱ i dər arwa va̱ ta pa̱ ɗóng. Kang a yà pa̱ arwa va̱ ta ka̱ izər nzhi ɓàp ndəng ìpəpa ka̱t te nrəzang, kang à ɓok tar azər nzhi, ");
INSERT INTO yer_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","te unəm uga mpyal awop i fa ka̱ ashe nzhi va̱ ta i ga anung asa̱l, kang uza̱ i kuk nzhi va̱ ta nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Unəm uga mpyal awop i le kà̱ nra ngga nfangshat kà̱ ɗi, kang a dər pa̱ ɗóng. Kang a yà pa̱ arwa va̱ ta myak chit ka̱ izər nzhi te, ");
INSERT INTO yer_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","unəm uga mpyal awop i nak pa̱ mmá zə̀p oga ipáng va̱ ká̱ arwa mmá swang ka̱ atak aga adak kà̱ nsəm ìtong. ");
INSERT INTO yer_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Uza̱ i nak mí pyár ashe nzhi va̱ ta pa̱ chatchat, kang amè va̱ mmá pyár te mí swang ka̱ atak aga adak kà̱ nsəm ìtong. ");
INSERT INTO yer_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Te oza̱ i wur ipáng iro pa̱ ɗi i mwàk ka̱ atak imatmat va̱, kang i wur mbin ngga nwòr nzhi i wòr nzhi va̱ ta ká̱ kà̱ ɗi. ");
INSERT INTO yer_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","<<A yà pa̱ arwa va̱ ta fa ka̱ ashe nzhi kà̱ ɗi nva̱ngva̱ uza̱ zə̀p oga ipáng, pyár azər nzhi kang à wòr, ");
INSERT INTO yer_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","te unəm uga mpyal awop i tar i dər. Kang a yà pa̱ arwa va̱ ta myak ka̱ ashe nzhi, te arwa aɓá̱ngɓa̱ng, nzhi va̱ ta ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Te uza̱ i chwan nzhi va̱ ta, kang ipə́pang, nzəng ká̱ akúkun, ká̱ mbin nva̱ mmá wòr ká̱, uza̱ i wur i fa kà̱ nsəm ìtong ka̱ atak adak. ");
INSERT INTO yer_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Unəm va̱ kpaktak tar ashe nzhi va̱ ta kà̱ nra va̱ mmá kukùk, te i yà ká̱ adak i ga i chu anung arurong. ");
INSERT INTO yer_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Nza̱ unəm nggo va̱ ra ka̱ ashe nzhi va̱ ta te uza̱ i nàl ìlukwan wò, ká̱ uva̱ ri iya̱m ka̱ ashe nzhi va̱ ta te i nàl ìlukwan wò. ");
INSERT INTO yer_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","<<Kang a yà pa̱ unəm uga mpyal awop dər nzhi va̱ ta, kang à ya pa̱ arwa va̱ ta myak ka̱ ashe nzhi va̱ ta ka̱t, kà̱ nva̱ng nwùwór kà̱ ɗi, te unəm uga mpyal awop i shet pa̱ nzhi va̱ ta yà ká̱ adak ka̱t, ka̱kul arwa va̱ ta tàn chit. ");
INSERT INTO yer_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Te uza̱ i wur inyil pa̱ iparəm, ká̱ akun asida, ká̱ afini ɓán pa̱ gà̱r, ká̱ azang ahisop, ka̱kul nnàl adak nzhi va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Kang uza̱ i pà ìnyil pa̱ ìzəng ka̱ ashe ngbət amè ka̱ apal ndəng nnəna̱n. ");
INSERT INTO yer_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Uza̱ i yar akun asida, ká̱ azang ahisop, ká̱ afini ɓán pa̱ gà̱r, ká̱ ìnyil ìrirì i mwàk oza̱ ka̱ ashe nchə̀r ìnyil va̱ mmá pà ka̱ apal ndəng nnəna̱n, kang i shang nchə̀chər n̂zhi va̱ ta nva̱ng pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Uza̱ i nàl adak nzhi va̱ ta ká̱ nchə̀r ìnyil, ká̱ ndəng nnəna̱n, ká̱ ìnyil ìrirì, ká̱ akun asida, ká̱ azang ahisop, ká̱ afini ɓán pa̱ gà̱r. ");
INSERT INTO yer_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Te uza̱ i re ìnyil ìrirì va̱ ta i fa i ga nsəm ìtong ka̱ agbagba. Wa nnà ta̱ uza̱ i mwa ishi n̂zhi va̱ ta, te i yà ká̱ adak ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Nnap mpakpak nà ta̱ ka̱kul nza̱ apir arwa awá izər nggo, ká̱ ndangbyat. ");
INSERT INTO yer_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Ka̱kul nlak ngga izər ìlukwan, ka̱t te ngga nzhi, ");
INSERT INTO yer_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ka̱kul iya̱m mmu, izər iwárwár, ká̱ mɓàp, ");
INSERT INTO yer_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ka̱kul nnyi awalang va̱ iya̱m ká̱ adak ká̱ iga adak ka̱t. Nnap mpakpak nà ta̱ ka̱ apal arwa nlak. ");
INSERT INTO yer_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","UYawe là ûMusa ká̱ uHaruna pa̱, ");
INSERT INTO yer_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","<<Là ôIsa̱rila pa̱, a yà pa̱ afən kà̱ nwàr ûnunggwan ka̱ apyal te, nwùwar va̱ ta nak na uza̱ yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Nnà ta̱ i yà nnap mpakpak ka̱ apal adədak aga nwàr, mo te afən fa ka̱ apipyal ka̱t te á zwan apyal, te uza̱ ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Nza̱ alyér nggo va̱ unəm va̱ ká̱ iya̱m iwárwàr a ra kà̱ te i yà ká̱ adak, kang nza̱ iya̱m nggo va̱ uza̱ təm kà̱ te i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Nza̱ unəm nggo va̱ dok iya̱m nrəra te uza̱ i nàl ilukwán wò kang uza̱ i wòr izər ka̱ ashe ndəng, te uza̱ yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Unəm va̱ təm ka̱ apal nza̱ iya̱m ntəm nggo va̱ unəm uga iya̱m iwárwàr təm kà̱, te uza̱ i nàl ilukwán wò kang uza̱ i wòr izər ka̱ ashe ndəng, te uza̱ i yà ká̱ adak i ga i chu arurong ");
INSERT INTO yer_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Nkpaktak unəm va̱ dok izər ánəm uga iya̱m iwárwàr te uza̱ i nàl ilukwán wò kang uza̱ i wòr izər ka̱ ashe ndəng, te uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","A yà pa̱ unəm uga iya̱m iwárwàr súk nshí ûnəm uga adak ka̱t, te uza̱ i nàl ilukwán wò kang uza̱ i wòr izər ka̱ ashe ndəng, te uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Nza̱ nkòngkòng nggo va̱ unəm uga iya̱m iwárwàr kwák te, i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Nza̱ unəm nggo va̱ dok iya̱m va̱ ka̱ avəng ánəm va̱ ta, te i yà ká̱ adak i ga i chu arurong, kang nkpaktak unəm va̱ wur oza̱, te uza̱ i nàl ilukwán wò kang uza̱ i wòr izər ka̱ ashe ndəng, te uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Kang nza̱ unəm nggo va̱ unəm uga iya̱m iwárwàr i dok nzəng ká̱ nzwaktak awó wò ka̱ ashe ndəng ka̱t, te uza̱ i nàl ilukwán wò kang uza̱ i wòr izər ka̱ ashe ndəng, te uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Te iya̱m inok amè va̱ unəm uga iya̱m iwárwàr dok te mí chwan, kang nza̱ iya̱m inok iga akun nggo mí zwaktak ká̱ ndəng. ");
INSERT INTO yer_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","<<Nva̱ngva̱ unəm uga iya̱m iwárwàr tàn ka̱ atak iya̱m nwàr wò, te uza̱ i kung nra pa̱ nfangshat ka̱kul nnyám ntàn wò, kang uza̱ i nàl ilukwán wò. Kang i wòr izər wò ká̱ ndəng nnəna̱n, te uza̱ i yà ká̱ adak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Kà̱ nra ngga nna̱nne te uza̱ i wur iləkpar pa̱ iparəm ka̱t te ivan iruzum pa̱ iparəm, i ɓa ká̱ kà̱ mpyal àYawe ka̱ anung Aghal Mɓut, kang uza̱ i na oza̱ ûnəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Unəm uga mpyal awop i yichi oza̱, izəngtəng iya̱m inana nnap mɓá̱ngɓa̱ng, kang iro iya̱m inana iga nshì. Te unəm uga mpyal awop i mwa ishíshi ká̱ kà̱ mpyal àYawe ka̱kul iya̱m iwárwàrwarwar. ");
INSERT INTO yer_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","<<A yà pa̱ mpə̀ng amar fa ûnunggwan ka̱ izər, te uza̱ i wòr izər wò pa̱ chatchat ká̱ ndəng, kang uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Nza̱ ìlukwan nggo ka̱t te awá va̱ mpə̀ng amar dok te, mí nàl ká̱ ndəng, kang i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","A yà pa̱ ununggwan ra ká̱ uchar kang mpə̀ng fa te, oza̱ i wòr izər ká̱ ndəng, kang oza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","<<A yà pa̱ uchar ká̱ nchə̀r nva̱ akpàr te, uza̱ i yà ká̱ adak nra pa̱ nfangshat ka̱kul akpəkpar, kang nkpaktak ununggwan va̱ dok na te i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Nkpaktak iya̱m va̱ uza̱ ra ka̱ apəpal ka̱ awalang akpəkpar te i yà ká̱ adak. Kang iya̱m va̱ uza̱ təm ka̱ apəpal te i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Nza̱ unəm nggo va̱ dok iya̱m nrəra te, uza̱ i nàl ilukwan wò kang uza̱ i wòr izər ka̱ ashe ndəng, te uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Nza̱ unəm nggo va̱ dok iya̱m ntəm va̱ uza̱ təm kà̱, te uza̱ i nàl ilukwan wò kang uza̱ i wòr izər ka̱ ashe ndəng, te uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","A yà pa̱ alyér ka̱t te iya̱m ntəm va uza̱ kà̱ ntəm kà̱, uza̱ dok te, i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","A yà pa̱ ununggwan ra ká̱ na, kang akpəkpar dok na, te uza̱ i yà ká̱ adak nra pa̱ nfangshat, kang nza̱ alyér nggo va̱ unəm va̱ ta ra ka̱ apəpal te i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","<<A yà pa̱ nchə̀r vàng ûchar nra pa̱ nkyak, ka̱ awalang akpəkpar ka̱t, ka̱t te a watar nra akpəkpar watar. Te uza̱ i yà ká̱ adak nkpaktak nra nvàng nchə̀chər wa nchə̀r akpəkpar, te uza̱ i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Nkpaktak alyér va̱ uza̱ ra ka̱ apəpal ka̱ awalang aga nvàng nchə̀chər te i yà ká̱ adak. Kang iya̱m va̱ uza̱ təm ka̱ apəpal te i yà ká̱ adak, i yà wa nva̱ ka̱ awalang akpəkpar. ");
INSERT INTO yer_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Nza̱ unəm nggo va̱ dok oza̱ te i yà ká̱ adak, te uza̱ i nàl ilukwan wò kang uza̱ i wòr izər ka̱ ashe ndəng, te uza̱ i yà ká̱ adak i ga i chu arurong. ");
INSERT INTO yer_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Kà̱ nva̱ng va̱ nvàng nchə̀chər sat, te uza̱ i kung nra pa̱ nfanshat kang kà̱ nvəva̱ng te uza̱ i yà ká̱ adak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Kà̱ nra ngga nna̱nne te uza̱ i wur iləkpar pa̱ iparəm ka̱t te ivan iruzum pa̱ iparəm, uza̱ i ɓa ká̱ oza̱ ûnəm uga mpyal awop ka̱ anung Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Unəm uga mpyal awop i yichi izəngtəng iya̱m inana nnap mɓá̱ngɓa̱ng kang iro iya̱m inana iga nshì. Te unəm uga mpyal awop i mwa ishíshi ká̱ kà̱ mpyal àYawe ka̱kul adak akpəkpar. ");
INSERT INTO yer_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","<<Wa nnà ta̱ ɓu va̱n oIsa̱rila ka̱ atak adak oza̱, le kang oza̱ a kú ka̱ atak adak oza̱ ka̱t, ká̱ nvyap nzhi mi va̱ kà̱ ìshimshe oza̱.>> ");
INSERT INTO yer_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Nnap mpakpak va ta̱ ka̱kul ánəm va̱ ká̱ iya̱m iwárwàr, ka̱kul nza̱ unəm nggo va̱ mpə̀ng amar vàng á na, á nak na uza̱ yà ká̱ adak, ");
INSERT INTO yer_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ka̱t te uchar va̱ kà̱ ngba̱l akpar, ka̱kul ada nggo, ununggwan ka̱t te uchar, kang ka̱kul ánəm va̱ ra ká̱ uchar va̱ ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","UYawe là nnàp ká̱ uMusa kà̱ nva̱ng ikú ovan aHaruna pa̱ oparəm, nva̱ oza̱ ɓa mpyal àYawe kang oza̱ kú á. ");
INSERT INTO yer_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","UYawe là ûMusa pa̱, <<Là ûgənang ɓu uHaruna pa̱ kang uza̱ a ɓa ashe Atak Ayə́ryər kà̱ nsəm atani, kà̱ mpyal anung akwati aga nsar nnap-nlà ka̱ awalang va uza̱ ɗòm ka̱t, ka̱t te uza̱ i kú. Ka̱kul mi fa ka̱ ashe ìlulu ka̱ apal anung akwati aga nsar nnap-nlà. ");
INSERT INTO yer_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Asa̱l va ta̱ nà uHaruna i tar Atak Ayə́ryər, uza̱ i tar ká̱ ìya ìna ìnunggwan ka̱kul iya̱m inana iga nnap mɓá̱ngɓa̱ng ká̱ ìnagam ka̱kul iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Uza̱ i pá ìlukwan iga ashe ìyə́ryər iga alinin, kang i yà ká̱ ǹya nwondo ngga ashe ngga alinin ka̱ izər wò. Uza̱ i ran ngbàt alinin kang i sar ishi ká̱ iya̱m ishi iga alinin, iya̱m va̱ ta̱ ìlukwan ìyə́ryər. Uza̱ i wòr izər wò ká̱ ndəng kang uza̱ i mwàk oza̱. ");
INSERT INTO yer_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Uza̱ i wur iɓə́l inunggwan pa̱ iparəm ka̱ atak mɓut oIsa̱rila ka̱kul iya̱m inana iga nnap mɓá̱ngɓa̱ng, ká̱ ìnagam pa̱ ìzəng ka̱kul iya̱m inana iga nshì. ");
INSERT INTO yer_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","<<UHaruna i na ìya ìna ìnunggwan ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng wò, kang i mwa ishi ká̱, ka̱kul ishi wò, ká̱ nzhi wò. ");
INSERT INTO yer_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Nnà chit te uza̱ i wur iɓə́l iga iparəm va̱ i ɓa ká̱ kà̱ mpyal àYawe ka̱ anung Aghal Mɓut. ");
INSERT INTO yer_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Te uHaruna i mang ayàk ka̱ apal iɓəl iga iparəm va̱ ta, ayàk ìzəngtəng ka̱kul áYawe kang ìro ka̱kul aAzazel, ");
INSERT INTO yer_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Uza̱ ɓa ká̱ ìɓəl va̱ mmá yàk ka̱ atak mmang ayàk ka̱kul áYawe, kang uza̱ yichi wa iya̱m inana iga nnap mɓá̱ngɓa̱ng. ");
INSERT INTO yer_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Te ìɓəl va̱ ayàk ru ka̱ apəpal ka̱kul aAzazel, mí yichi kà̱ mpyal àYawe na mmá mwa ishi ká̱, na mmá re ka̱kul aAzazel pa̱ á ga ashe nzam. ");
INSERT INTO yer_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","<<Te uHaruna i yichi ìna ìnunggwan iya̱m inana iga nnap mɓá̱ngɓa̱ng ka̱kul ishi wò, kang i mwa ishi wò ká̱, ká̱ nzhi wò, te uza̱ i pà ìna ìnunggwan va̱ ta iya̱m inana iga nnap mɓá̱ngɓa̱ng ka̱kul ishíshi. ");
INSERT INTO yer_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Te uza̱ i yar asu apər yə́l ká̱ amor apər ka̱ atak nshì iya̱m awop kà̱ mpyal àYawe, ká̱ mməm nnə́ngnəng mma awó pa̱ aparəm pa̱ súr, kang i ɓa ká̱ ka̱ ashe atani. ");
INSERT INTO yer_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Uza̱ i nak mməm nnə́ngnəng va̱ ta ka̱ apal apər kà̱ mpyal àYawe, ka̱kul na nggù mməm va̱ ta á dàngchi apal anung akwati aga nsar nnap-nlà, le kang uza̱ a kú ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Kang uza̱ i pá nchə̀r ìna ìnunggwan va̱ ta kang i sháng ká̱ ìfang wò ka̱ izər anung akwati aga nsar nnap-nlà ka̱ asa̱l nfa alum, kang uza̱ i sháng nchə̀r va̱ ta ká̱ ifang wò kà̱ mpyal anung akwati aga nsar nlà nva̱ng pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","<<Nnà chit te uza̱ i pà ìɓəl iya̱m inana iga nnap mɓá̱ngɓa̱ng ka̱kul onəm. Kang i ɓa ká̱ nchə̀chər ka̱ ashe atani, te uza̱ i nəm iya̱m izəngtəng ká̱ nchə̀chər wa nva uza̱ nəm ká̱ nchə̀r ìna ìnunggwan. Uza̱ i sháng ka̱ izər apal anung akwati aga nsar nnap-nlà ká̱ mpipyal. ");
INSERT INTO yer_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Uza̱ i mwa ishi Atak Ayə́ryər ká̱ ka̱kul adak oIsa̱rila ká̱ mpat oza̱, ká̱ nkpaktak nnap mɓá̱ngɓa̱ng oza̱. Wa nnà ta kpa uza̱ i nəm ká̱ Aghal Mɓut va̱ kà̱ ìshimshe adak oza̱. ");
INSERT INTO yer_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kang unəmləbər uro i yà ka̱ ashe Aghal Mɓut ka̱t, ka̱ awalang va̱ uza̱ i tar pa̱ ô mwa ishi ka̱ ashe Atak Ayə́ryər, ya uza̱ i fa kang. Uza̱ i mwa ishi wò ká̱, ká̱ ishi nzhi wò, ká̱ ishi nkpaktak oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Te uza̱ i fa atak nshì iya̱m awop va̱ kà̱ mpyal àYawe kang i mwa ishi ka̱kúkul, te uza̱ i dok nchə̀r ìna ìnunggwan ká̱ nchə̀r ìɓəl i jen nggùnggúng atak nshì iya̱m awop ká̱ i gang. ");
INSERT INTO yer_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Uza̱ i sháng nchə̀r nro ká̱ ìfang wò ka̱ apəpal nva̱ng pa̱ nfangshat i gòr na ka̱kul adak oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","<<Nva̱ngva̱ uza̱ gba̱l ká̱ nggòr Atak Ayə́ryər, Aghal Mɓut, ka̱ atak nshì iya̱m awop, te uza̱ i yichi ká̱ ìɓəl ìrirì va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","UHaruna i nak nkpaktak awó wò ka̱ apal ishi ìɓəl ìrirì va̱ ta, kang i pwa nkpaktak nnap mɓá̱ngɓa̱ng, mpat, ká̱ adak oIsa̱rila ka̱ apəpal. Te uza̱ i nak oza̱ ka̱ apal ishi ìɓəl va̱ ta kang i re ka̱ ashe awó ánəm uro i ga ashe nzam. ");
INSERT INTO yer_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ìɓəl va̱ ta i yar nkpaktak nnap mɓá̱ngɓa̱ng oza̱ ka̱ ishi wò, te uza̱ i re ìɓəl va̱ ta i ga ashe nzam va unəm uro yà kà̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","<<Te uHaruna i tar ashe Aghal Mɓut, kang i zə̀p ilukwan alinin va̱ uza̱ mwàk kà̱ ìlum va̱ uza̱ tar Atak Ayə́ryər á, uza̱ i re oza̱ ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Uza̱ i wòr izər wò ká̱ ndəng ka̱ Atak Ayə́ryər kang i mwàk ilukwan iji wò. Te uza̱ i fa agbai kang i yichi iya̱m inana iga nshì ka̱kul ishi wò ká̱ iya̱m inana iga nshì ka̱kul ishi onəm, te uza̱ i mwa ishi ká̱ ka̱kul ishi wò ká̱ onəm. ");
INSERT INTO yer_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Uza̱ i shì mpip iya̱m inana iga nnap mɓá̱ngɓa̱ng ka̱ apal atak nshì iya̱m awop. ");
INSERT INTO yer_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Unəm uga nré ìɓəl aAzazel i nàl ilukwan wò kang i wòr izər ká̱ ndəng, nnà chit te uza̱ i tar ashe apa̱k ɗak. ");
INSERT INTO yer_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ìna iya̱m inana iga nnap mɓá̱ngɓa̱ng ká̱ ìɓəl iya̱m inana iga nnap mɓá̱ngɓa̱ng, va̱ mmá ɓa ká̱ nchə̀r oza̱ ka̱ ashe Atak Ayə́ryər pa̱ mmá mwa ishi ká̱, te uza̱ i fa ká̱ kà̱ nsəm apa̱k. Awá oza̱, ká̱ ìzhe oza̱, ká̱ iya̱m afu oza̱, mí shì ká̱ apər. ");
INSERT INTO yer_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Unəm va̱ shì oza̱ te uza̱ i nàl oga ilukwan wò kang i wòr izər ká̱ ndəng, nnà chit te uza̱ i tar ashe apa̱k ɗak. ");
INSERT INTO yer_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","<<Iya̱m va̱ ta̱ i yà nnap mpakpak ka̱ atak wó mbyet. Kà̱ nra ngga ngba̱pchi ka̱ ape aga afangshat, te ó ɗa̱t ishi wó, kang ó nəm inok iro ka̱t, uyen uga mbin ká̱ unəm uchən va̱ kà̱ ìshimshe wó. ");
INSERT INTO yer_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ka̱kul kà̱ ìlum va ta mí ga mmwa ishi wó pa̱ á nàl wó ka̱ atak nkpaktak nnap mɓá̱ngɓa̱ng. Na ó yà ká̱ adak ka̱t ka̱ atak nkpaktak nnap mɓá̱ngɓa̱ng kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ìlum aSati ayə́ryər ka̱kul wó, te ó ɗa̱t ishi wó. Nnap mpakpak mbyet mbyet. ");
INSERT INTO yer_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Unəm uga mpyal awop uva̱ mmá gor kang mmá nak awo a na pa̱ á nəm inok wa ánəm uga mpyal awop uchumchum ka̱ aɗor apupo. Te uza̱ i mwa ishi, kang i mwàk oga ilukwan alinin, oga ilukwan iyə́ryər. ");
INSERT INTO yer_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Te i mwa ishi Atak Ayə́ryər va ji pa̱ kpaktak, ká̱ Aghal Mɓut, ká̱ atak nshì iya̱m awop, kang uza̱ i mwa ishi ka̱kul onəm oga nshì iya̱m awop ká̱ nkpaktak mɓut. ");
INSERT INTO yer_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Iya̱m va̱ ta̱ i yà nnap mpakpak ka̱kul wó mbyet mbyet, pa̱ mmá mwa ishi oIsa̱rila nva̱ng pa̱ nzəng ka̱ ashe ìzun ka̱kul nkpaktak nnap mɓá̱ngɓa̱ng oza̱.>> Te uza̱ nəm wa nva uYawe nak. ");
INSERT INTO yer_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","<<Là ûHaruna ká̱ ovəvan onunggwan ká̱ nkpaktak oIsa̱rila, là ôza̱ pa̱. Nnap va ta̱ uYawe nak, pa̱, ");
INSERT INTO yer_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","nza̱ unəm nggo va̱ kà̱ nzhi àIsa̱rila pà ìna inunggwan, ka̱t te ìnagam, ka̱t te ìɓəl ka̱ ashe apa̱k, ka̱t te á pà kà̱ nsəm apa̱k, ");
INSERT INTO yer_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","kang uza̱ ɓa ká̱ ka̱ anung Aghal Mɓut pa̱ ô yichi iya̱m inana ûYawe kà̱ mpyal atak ntəm àYawe ka̱t, te mí nap akwali ntar nchə̀r ûnəm va̱ ta. Uza̱ tar nchə̀r, ka̱kul nva̱ ta te mí fa ká̱ na ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ka̱kul pa̱ na á dang oIsa̱rila kà̱ ǹyichi nləfər iya̱m ipápà va̱ oza̱ i pà ka̱ agbagba. Na á nak oza̱ á ɓa ká̱ nləfər ûnəm uga mpyal awop ka̱ anung Aghal Mɓut, na uza̱ á yichi ûYawe wa nləfər iya̱m inana iga ntəm ikángkáng. ");
INSERT INTO yer_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Unəm uga mpyal awop i sháng nchə̀chər ka̱ apal atak nshì iya̱m awop aYawe ka̱ anung Aghal Mɓut, kang i shì mpìpip iya̱m inə́ngnəng ichángchàng ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Oza̱ i yà ká̱ ǹyichi nləfər iya̱m ipápà iro ôga ichə́r va wa iɓə́l lap ka̱t, iva oza̱ nəm mmai ká̱ oza̱. Nnap mpakpak va̱ ta i yà ka̱kul oga nlwàk oza̱ mbyet mbyet. ");
INSERT INTO yer_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","<<Là ôza̱ pa̱, nza̱ unəm nggo kà̱ nzhi àIsa̱rila ka̱t te ka̱ ashe onəm ochən va̱ təm ka̱ ashe oza̱, uva̱ i yichi iya̱m inana iga nshì ka̱t te nza̱ apir iya̱m inana nggo, ");
INSERT INTO yer_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","kang à ɓa ká̱ ka̱ anung Aghal Mɓut pa̱ ô yichi ûYawe ka̱t, te mí fa ká̱ na ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","<<Nza̱ unəm nggo kà̱ nzhi àIsa̱rila ka̱t te ka̱ ashe onəm ochən va kà̱ ntəm ka̱ ashe oza̱ i ri nchə̀r nro te, mi nak ìwú kà̱ unəm va̱ ri nchə̀r, kang mi fa ká̱ na ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ka̱kul irirì ìzhe ka̱ ashe nchə̀chər na, kang n na wó chit pa̱ mmá mwà ishi ká̱ ka̱ apal atak nshì iya̱m awop ka̱kul irirì wó, ka̱kul nchə̀r na i yar nnap mɓá̱ngɓa̱ng wó. ");
INSERT INTO yer_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ka̱kul nva̱ ta te, n là ôIsa̱rila chit pa̱, kang unəm uro ka̱ ashe wó, ka̱t te unəm uchən va̱ təm ka̱ ashe wó a ri nchə̀r ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","<<Nza̱ uIsa̱rila nggo ka̱t te unəm uchən va̱ təm ka̱ ashe oza̱, uva̱ i gba̱l ìzhe ka̱t te inyil va mí riri te, uza̱ i wàr nchə̀chər kang i dəp ká̱ mbin. ");
INSERT INTO yer_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ka̱kul irirì ìzhe ka̱ ashe nchə̀chər. Ka̱kul nnà kang n là ôIsa̱rila pa̱, ó yà ká̱ nrí nchə̀r ìzhe ìro ka̱t. Ka̱kul irirì nza̱ ìzhe nggo te ka̱ ashe nchə̀chər, nza̱ unəm nggo va ri te mi fa ká̱ na. ");
INSERT INTO yer_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Nza̱ unəm nggo uyen uga mbin ka̱t te unəm uchən, uva̱ ri iya̱m ikuku ka̱t te ìzhe iga anyin à kan te, uza̱ i nàl ilukwan wò kang i wòr izər ká̱ ndəng, te i yà ká̱ adak i ga i chu arurong, nnà chit te uza̱ i yà ká̱ adak ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Kang a yà pa̱ uza̱ nàl oza̱ ka̱t, ka̱t te uza̱ wòr izər wò ka̱t, te uza̱ i yar mpat wò.>> ");
INSERT INTO yer_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","<<Là nnàp ká̱ oIsa̱rila, là ôza̱ pa̱, mmami uYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kang ó yar nnap nnəm ngga mbin aMasar ka̱t, atak va ka̱ ó təm kà̱, ka̱t te ó yar nnap nnəm ngga mbin aKanana ka̱t, atak va mmami kà̱ ngga ká̱ wó kà̱. Ó yà ká̱ nkpak nnap mpakpak oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ó kpak oga nnap mpakpak mi, kang ó nak ishi ká̱ nɗyáng mi. Mmami uYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ó kpak oga nɗyáng mi ká̱ nnap mpakpak mi. Ka̱kul Unəm i lár a yà pa̱ uza̱ kpak oza̱ á. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","<<Unəm i yà ká̱ mɓa ndát ká̱ unàl wò pa̱ ô ra ichar ká̱ na ka̱t. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Kang wá na ìwuswa ûpo ɓu ka̱ atak nra ká̱ unang ɓu ka̱t, uza̱ unang ɓu, kang wa ra ká̱ na ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Kang wa ra ká̱ uchar àpo ɓu ka̱t, i na ìwuswa ûpo ɓu. ");
INSERT INTO yer_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Kang wa ra ká̱ ugənang ɓu uyen uchar ka̱t, uya àpo ɓu uyen uchar ka̱t te uji ànang ɓu uyen uchar, mmá mar kà̱ nzhi ka̱t te kà̱ nzam, kang wa ra ká̱ oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Kang wa ra ichar ká̱ uya ayen ɓu ununggwan ka̱t, ka̱t te uya ayen ɓu uyen uchar ka̱t, ka̱kul i na ìwuswa á ɓu. ");
INSERT INTO yer_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Kang wa ra ichar ká̱ uya ànangzhi ɓu ka̱t uva̱ upo ɓu à mar. Uza̱ ugənang ɓu. ");
INSERT INTO yer_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Kang wa ra ichar ká̱ ugənang àpo ɓu ka̱t. Uza̱ unàl ɓu uga ndatkulung. ");
INSERT INTO yer_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Kang wa ra ichar ká̱ ugənang ànang ɓu ka̱t, ka̱kul uza̱ unàl ànang ɓu uga ndatkulung. ");
INSERT INTO yer_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Kang wá na ìwuswa ûgənang àpo ɓu ka̱ atak nra kà̱ uchəchar ka̱t. Uza̱ unang ɓu. ");
INSERT INTO yer_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Kang wa ra ichar ká̱ ukà ɓu ka̱t, uza̱ uchar àyen ɓu. ");
INSERT INTO yer_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Kang wa ra ichar ká̱ uchar àgənang ɓu ka̱t. I na ìwuswa ûgənang ɓu. ");
INSERT INTO yer_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Kang wa ra ichar ká̱ uchar ká̱ uyiyen kpa ka̱t. Kang wa ra ichar ká̱ uya àyiyen ununggwan, ka̱t te uya àyiyen uyen uchar ka̱t, oza̱ onal ɓu oga ndatkulung. Aɓəkət ta. ");
INSERT INTO yer_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Kang wa ka̱m ichar ká̱ ugənang àchar ɓu a ta̱l ukpəkpat, ya ugənanggənang uwa yà ká̱ irirì ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","<<Kang wa ram ichar kà̱ uchar ka̱ awalang va̱ uza̱ ká̱ akpar ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Kang wa ra ichar ká̱ uchar àwan ɓu ka̱t, ɓu vyap ishi ɓu ká̱ na. ");
INSERT INTO yer_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Kang wa na uyen ɓu uro nləfər înan va̱ mi wor pa̱ uMolek, ka̱kul i vyap aɗin Inan ɓu. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Kang wa ra ká̱ ununggwan wa nva̱ unəm i ra ká̱ uchar ka̱t, iya̱m iga ajan. ");
INSERT INTO yer_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Kang wa ra ichar ká̱ iya̱m nkang na ú vyap ishi ɓu ka̱t. Kang uchar á na izər wò îya̱m nkang ka̱t te ìzhe iga anyin pa̱ á ra ká̱ wò ka̱t. Nva̱ ta adak. ");
INSERT INTO yer_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","<<Kang ó vyap ishi wó ka̱ atak oga nnap nnəm va̱ ta̱ ka̱t, ka̱kul nkpaktak oga iya̱m va ta̱ mbín va̱ mmami kà̱ ngga mɓàk i le á wó, nak ishi oza̱ yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","A nak te mbin vyap, kang n nyám ntàn á na ka̱kul mpəpat, te mbin va̱ ta yang ká̱ onəm oga ntəm ka̱ ashe wò. ");
INSERT INTO yer_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Te ó kpak oga nɗyáng mi ká̱ oga nnap mpakpak mi. Kang ó nəm oga iya̱m iga nnəm ajan va̱ ta̱ ka̱t, ko uyen uga mbin ka̱t te unəm uchən va̱ kà̱ ntəm ka̱ ashe wó. ");
INSERT INTO yer_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ka̱kul onəm va̱ ka̱ yà ka̱ ashe mbin va̱ ta̱ mpyal wó te, ka̱ nəm nkpaktak oga iya̱m iga ajan va̱ ta̱, kang mbin yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","A yà pa̱ ó vyap mbin va̱ ta te i yang ka̱ wó wa nva ka̱ nyang mbín va̱ ka̱ yà mpyal á wó. ");
INSERT INTO yer_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Nza̱ unəm nggo uva̱ nəm iro ka̱ ashe oga iya̱m iga ajan va̱ ta̱ te, mí fa ká̱ unəm va̱ ta ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Te ó kpak nɗyáng mi na kang ó nəm oga iya̱m iga ajan iva̱ mmá nəm chit ka̱ mbin va̱ ta̱ mpyal wó ka̱t, le kang ó nak ishi wó a yà ká̱ adak ka̱ atak oza̱ ka̱t. Mmami na uYawe, Inan wó.>> ");
INSERT INTO yer_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","là n̂kpaktak mɓut oIsa̱rila pa̱, <<Ó yà onəna̱n ka̱kul mmami, uYawe, Inan wó, mmami unəna̱n. ");
INSERT INTO yer_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Nza̱ uzəngtəng wó nggo á kpak nnap nnəm ûnang wò ká̱ upo wò, kang ó kpak ìlum aSati mi, mmami na uYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Kang ó le atak oga ichər, ka̱t te ó nəm ala̱ka̱n aga ichə̀r ka̱kul ishi wó ka̱t. Mmami na uYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","<<A yà pa̱ ó yichi nləfər iya̱m ipápà iga ntəm ikángkáng ûYawe, te ó yichi ka̱ asal va məma, na á yà ika̱mka̱m. ");
INSERT INTO yer_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Mí ri ìzhe va̱ ta n̂da va mmá pà ká̱, ka̱t te kà̱ ìpin ìkpa̱kkpa̱k. Kang aɓuɓo va̱ le kà̱ ìlum iga ishatɗing te, mkpak mí shì ka̱ ashe apər. ");
INSERT INTO yer_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","A yà pa̱ mmá ri kà̱ nra ngga nshatɗing te, i yà ìzhe iga ajan, mí ka̱m ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Unəm va̱ ri te uza̱ i yar ìɗək mpat wò, ka̱kul uza̱ vyap iya̱m iyə́ryər va iji áYawe. Unəm va̱ ta mí fa ká̱ na ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","<<Kang a yà pa̱ ó ɓən iya̱m mbin wó te, kang wa ɓən anung ìram ɓu ka̱t, kang wa chák nva̱ng iya̱m mɓən ɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Te kang wa chák nva̱ng ìram ìba̱ngba̱ng ka̱t te wa wur oga awúwar va̱ tàk kà̱ mbin pa̱ chatchat ka̱t, re oza̱ ka̱kul onəm oga nkun ká̱ oɗyànəm. Mmami na uYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","<<Kang ó nəm ayí ka̱t. Kang ó lam atak ka̱t. Kang ó nap akwam ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Kang ó sóng anung aga akwam ká̱ aɗin mi ka̱t, na kang ó vyap aɗin Inan wó. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","<<Kang wa kà̱r ka̱t te wa vyat uwan ɓu ka̱t. Kang amwa ánəm va̱ u yar ka̱ inok a ra ka̱ awó ɓu a chu ìpin ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Kang wa pwat unəm va̱ achwang kpəkpa̱ng ká̱ na ka̱t te wa nak iya̱m iga nlə̀p ìfang kà̱ mpyal ànəm ufofo ka̱t. Te ra ayər Inan ɓu, mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","<<Kang wa nəm nlang nnandər ka̱ ashe nnáp akwali ka̱t. Kang wa nyám nɗòm ishi ûnəm uga nkun ka̱t te wa ɗòm nnap ànəm uga ndur na a ji ka̱t. Nap akwali ôwan ɓu ká̱ nnandər. ");
INSERT INTO yer_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Kang wa chen ká̱ nnáp akwam ka̱ apal anəm uro ka̱t, kang wá nak irirì áwan ɓu ka̱ ashe nɗaktak ka̱t. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","<<Kang wa yang ugənang ɓu ka̱ ashe ìgwak ka̱t. Ra̱n ká̱ uwan ɓu ká̱ nnandər, na kang nnap mɓá̱ngɓa̱ngɓa̱ngɓa̱ng á məl ɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Kang wa pyát ka̱t te wa ɓul ká̱ onəm ɓu ka̱t, ma̱n uwan ɓu wa ishi ɓu. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","<<Ó kpak oga nɗyáng mi. Kang ó re iya̱m nkang a kpàm apir aro pa̱ ɗi ka̱t, kang ó suk iram wó ká̱ apir iya̱m nsuk pa̱ iparəm ka̱t, ka̱t te ó pá ìlukwan iga apir atani pa̱ ɗongɗong ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","<<A yà pa̱ unəm ra ichar ká̱ uyen uchar uzwal uva̱ unəm uro kà̱ nnəm nggya ká̱ kang nna mmá ka̱m ishishi ka̱t te mmá fən na chit ka̱t, te mí pyat akə́kat. Mí yà ká̱ ngbá̱ng oza̱ ka̱t, ka̱kul uza̱ uwa ya nfən chit ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Te unəm va̱ ta i ɓa ká̱ ìnagam iya̱m inana iga mpat, ka̱ anung aghal aga mɓut ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Unəm uga mpyal awop i mwa ishishi ká̱ ìnagam iya̱m inana iga mpat kà̱ mpyal àYawe, ka̱kul nnap mɓá̱ngɓa̱ng va̱ uza̱ nəm, te mí yar nnap mɓá̱ngɓa̱ngɓa̱ngɓa̱ng va̱ uza̱ nəm. ");
INSERT INTO yer_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","<<A yà pa̱ ó táng ashe mbin va̱ ta kang ó ɓál nza̱ ikún nggo ka̱kul nrí, te ó dər awúwar ká̱ ajan, ìzun pa̱ ishatɗing i yà ká̱ ajan ka̱ atak wó, mí rí ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ka̱ ashe ìzun iga ineɗing te, nkpaktak awúwar mí gar ka̱kul iya̱m inana ashep ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Kang ka̱ ashe ìzun iga ìtukun te ó ri awúwar. A yà pa̱ ó nəm pa te, oga ìkun wó iwár awár pa̱ makmak. Mmami na uYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","<<Kang ó ri iya̱m iga nchə̀r ka̱t. Kang ó nəm iva̱k ka̱t, kang ó nəm mmàm ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Kang ó kà̱p akum ishi wó ka̱ asa̱l isu ka̱t, ka̱t te ó kpat nggyer wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Kang ó kyen izər wó ka̱kul akúm ka̱t, ka̱t te ó cha nza̱m ka̱ izər wó ka̱t. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","<<Kang wa vyap ovan ɓu ovan ochar ka̱ atak nnak oza̱ kà̱ nnəm mmai kà̱ nzhi awop inan ka̱t, a yà pa̱ ó nəm pa te o ga̱ɓa̱n ka̱ atak inan iro kang mbin yəl ká̱ mmai. ");
INSERT INTO yer_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ó kpak ìlum aSati mi kang ô rup ká̱ atak awop mi. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","<<Kang ó ga atak onəm oga iva̱k ka̱t te aruhu onəm okukù na á nak wó ó vyap ka̱t. Mmami na uYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","<<Ó kpak nnap nnəm ônəm va̱ ya nra chit, ó na ichumchum ônəm gbák, kang ô ra ayər Inan wó. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","<<A yà pa̱ unəmchən ra nzəng ká̱ wó ka̱ ashe mbin wó te, kang ó kà̱r na ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ó nəm ûnəmchən va̱ ra ka̱ ashe wó wa áyen uga mbin, ó ma̱n na wa nva ó ma̱n ishi wó, ka̱kul ka̱ ó yà onəmchən ka̱ ashe mbin aMasar. Mmami na uYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","<<Kang ó kà̱r onəm ká̱ iya̱m iga mmàl iya̱m iga kwam ka̱t, ka̱ awalang va̱ mmawó kà̱ mmàl mbal, ìɗək, ka̱t te iyəl iya̱m. ");
INSERT INTO yer_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Re o iya̱m iga mmàl ìɗək, ká̱ ìkpáng iga mma iya̱m, ká̱ iga mma iya̱m igálákgàlàk a yà iga nnandər. Mmami na uYawe, Inan wó, uva̱ fa ká̱ wó kà̱ mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ó kpak nkpaktak oga nɗyáng mi ká̱ nkpaktak oga nnap mpakpak mi, o nak ishi ká̱ oza̱. Mmami na uYawe.>> ");
INSERT INTO yer_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","là ôIsa̱rila pa̱, <<Nza̱ uIsa̱rila nggo, ka̱t te unəmchən va kà̱ ntəm ka̱ ashe aIsa̱rila, uva̱ i na uyen wò uro înan va mi wor pa̱ uMolek, te nkpak uza̱ i kú ikúku. Onəm oga mbin va̱ ta i kwàn na ká̱ ipáng. ");
INSERT INTO yer_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mi yang unəm va̱ ta, mi fa ká̱ na kà̱ ìshimshe onənəm ka̱kul uza̱ yichi ovan wò ûMolek, uza̱ nak nzhi mi ǹyə́ryər yà ká̱ adak, kang uza̱ vyap aɗin mi ayə́ryər. ");
INSERT INTO yer_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kang a yà pa̱ onəm oga mbin va̱ ta kùk iwú oza̱ ka̱ awalang va̱ unəm va̱ ta na uyen wò ûMolek, kang oza̱ gba̱l na ka̱t, ");
INSERT INTO yer_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","te mi yang unəm va̱ ta ká̱ akukum, mi fa ká̱ oza̱ ka̱ ashe onəm oza̱, ká̱ nkpaktak onəm va̱ yar nvəva̱ng ka̱kul oza̱ nəm mmai ká̱ uMolek. ");
INSERT INTO yer_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","<<Nza̱ unəm nggo va̱ ga atak onəm oga iva̱k, ká̱ aruhu onəm okukù, te mi nak ìwú mi ka̱ apal ánəm va̱ ta, kang mi fa ká̱ na ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ó gar ishi wó, ó yà onəna̱n, ka̱kul mmami na uYawe, Inan wo. ");
INSERT INTO yer_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ó kpak oga nnap mpakpak mi, ó nak ishi ká̱ oza̱. Mmami na uYawe, uva̱ gar wó. ");
INSERT INTO yer_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Nza̱ unəm nggo va pwat upo wò ká̱ unang wò, te nkpak mí gba̱l na. Ka̱kul uza̱ pwat upo wò ká̱ unang wò te, nchə̀r oza̱ i ya ka̱ ishishi. ");
INSERT INTO yer_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","<<A yà pa̱ unəm ra ichar ká̱ uchar àwan wò, te nkpak mí gba̱l unəm uga nnəm mmai ká̱ uchar uga nnəm mmai va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","A yà pa̱ unəm ra ichar ká̱ uchar àpo wò, te uza̱ na ìwuswa ûpo wò. Nkpak mí gbá̱ng mparəm oza̱, nchə̀r oza̱ ka̱ ishi oza̱. ");
INSERT INTO yer_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","A yà pa̱ unəm ra ichar ká̱ uchar àyen wò, te nkpak mí gbá̱ng mparəm oza̱. Oza̱ nəm iya̱m ìwuswa, kang nchə̀r oza̱ ka̱ ishi oza̱. ");
INSERT INTO yer_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","A yà pa̱ ununggwan ra ichar ká̱ ununggwan uwan wò, te oza̱ nəm iya̱m iga ajan. Nkpak oza̱ i kú ikúku, nchə̀r oza̱ ka̱ ishi oza̱. ");
INSERT INTO yer_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","A yà pa̱ unəm ka̱m uchar nzəng ká̱ unənang te, á ɓyen ka̱t. Mí shì nkpaktak oza̱, le kang aɓəkət a yà ka̱ ashe wó ka̱t. Apir nnap nnəm va̱ ta ma pa̱ a ya ká̱ ishimshe wó kat. ");
INSERT INTO yer_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","A yà pa̱ unəm ra ichar ká̱ iya̱m nkang, te nkpak uza̱ ká̱ iya̱m nkang va̱ ta oza̱ i kú ikúku. ");
INSERT INTO yer_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","A yà pa̱ uchar ra ichar ká̱ iya̱m nkang, te mí gba̱l uchar va̱ ta ká̱ iya̱m nkang va̱ ta, nchə̀r oza̱ ka̱ ishi oza̱. ");
INSERT INTO yer_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","<<A yà pa̱ unəm ka̱m ugənang wò, uya àpupo ka̱t te uya ànənang, kang oza̱ ra ichar, te iya̱m ìwuswa. Mí ɓak oza̱ mbang kà̱ ìwú onəm oza̱, ka̱kul uza̱ ra ichar ká̱ ugənang wò. Oza̱ i yar mpat oza̱. ");
INSERT INTO yer_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","A yà pa̱ unəm ra ichar ká̱ uchar va̱ ká̱ akpar te, nnap mɓá̱ngɓa̱ng. Oza̱ kpak nnap mpakpak àYawe ka̱t. Mí ɓak mparəm oza̱ ka̱ ashe onəm oza̱. ");
INSERT INTO yer_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Kang wa ra ichar ká̱ ugənang ànang ɓu ka̱t te ugənang àpon ɓu ka̱t, ka̱kul i yà mpwa imaləng á nàl ɓu uga ndátkulung. Oza̱ i yar mpat oza̱. ");
INSERT INTO yer_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Unəm va̱ ra ichar ká̱ uchar àkyan wò te uza̱ na ìwuswa ûkyan wò. Oza̱ i yar mpat oza̱, oza̱ i kú, i yà ká̱ nva̱ng ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","A yà pa̱ unəm ka̱m uchar àgənang wò, ya uwa yà ká̱ iriri te adak. Uza̱ na ìwuswa ûgənang wò, oza̱ i yà ká̱ nva̱ng ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","<<O kpak nkpaktak oga nɗyáng mi ká̱ oga nnap mpakpak mi, kang ô nak ishi ká̱ oza̱, le kang mbin va̱ mmami kà̱ ngga ká̱ wó kà̱ a yang wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kang ó yar nnap nnəm ngga mbin va̱ mmami kà̱ ngga mɓàk oza̱ kà̱ mpyal wó ka̱t. Ka̱kul oza̱ nəm nkpaktak oga iya̱m va̱ ta̱, kang n yang oza̱. ");
INSERT INTO yer_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Kang n yar nsar nnap-nlà á wó pa̱, <Ó ga nka̱m mbin oza̱, ka̱kul mi ga nnəna á wó i yà iya̱m akúp wó, mbin va ndopdop.> Mmami na uYawe, Inan wó va gar wó ka̱ ashe aɓoshi mbin. ");
INSERT INTO yer_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ka̱kul nva̱ ta te, ó va̱n ìshimshe iya̱m nkang inəna̱n ká̱ ivəngva̱ ìnəna̱n ka̱t, ká̱ ìshimshe inyil inəna̱n ká̱ ivəngva̱ inəna̱n ka̱t. Kang ó vyap ishi wó ka̱ atak izhé, inyil, ká̱ nza̱ iya̱m iga nkpàng kà̱ mbin nggo ka̱t. N va̱n iva̱ ta chit iga adak va ɓyen ka̱kul wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ó yà onəna̱n ka̱ atak mi ka̱kul mmami, uYawe, unəna̱n, kang n gar wó ka̱ ashe onəm pa̱ ó yà oji mi. ");
INSERT INTO yer_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","<<Ununggwan ka̱t te uchar uva̱ i nəm iva̱k ka̱t te i ram aruhu onəm okukù te, nkpak mí kwan oza̱ ká̱ ipáng i kú, nchə̀r oza̱ ka̱ ishi oza̱.>> ");
INSERT INTO yer_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","UYawe là ûMusa pa̱, <<Là ôvan aHaruna, onəm oga nshì iya̱m awop pa̱, <Kang unəm uro a vyap ishi wò ka̱ atak ndok akúm ka̱ ashe onəm wò ka̱t, ");
INSERT INTO yer_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","yà unənal uga ndátkulung ká̱ na wa unənang, upupo, uyiyen ununggwan, uyiyen uchar, ka̱t te ugənanggənang chwat, ");
INSERT INTO yer_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ka̱t te ugənanggənang uyen ɓyen uva̱ uwa à váng chit ka̱t. Ka̱kukul te uza̱ i nak ishi wò i yà ká̱ adak. ");
INSERT INTO yer_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Kang uza̱ a nak ishi wò a yà ká̱ adak ka̱ ashe onənal achəchar ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","<< <Onəm oga mpyal awop i yà ká̱ nkpat ishi igbatəng ka̱t, i kpat nggyer ka̱t te i cha izər oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Oza̱ i yà onəna̱n ka̱ atak Inan oza̱, kang oza̱ i vyap aɗin Inan oza̱ ka̱t, ka̱kul oza̱ i yichi iya̱m inana iya̱m-nrì ûYawe, Inan oza̱, te oza̱ á yà onəna̱n. ");
INSERT INTO yer_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","<< <Kang oza̱ a ka̱m ochar omaimai, ka̱t te uva̱ uɓəɓar á gba̱l ìvang á na, ka̱kul onəm oga nshì iya̱m awop oyə́ryər Înan oza̱. ");
INSERT INTO yer_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Ó dər na unəna̱n ka̱kul uza̱ kà̱ ǹyichi iya̱m inana iya̱m-nrì Înan wó. Uza̱ i yà unəna̱n kà̱ mpyal wó, ka̱kul mmami uYawe uva̱ gar wó, mmami unəna̱n. ");
INSERT INTO yer_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","A yà pa̱ uya ànəm uga mpyal awop uyen uchar nnəm mmai, te uza̱ yen ká̱ upo wò, mí shì na ka̱ apər. ");
INSERT INTO yer_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","<< <Unəm uchumchum onəm oga mpyal awop ka̱ ashe ogənang wò, uva̱ mmá zuk mmì ngga nggòr ka̱ ishishi, kang mmá nak awó á na chit pa̱ á mwàk ilukwan, te uza̱ i kpat ishi, ka̱t te i kan ìlukwan wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Kang uza̱ a ga a dát ká̱ akúm ánəm uro ka̱t, aji apupo ka̱t te unənang, ka̱kul kang uza̱ a vyap ishi wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kang uza̱ a re Atak Ayə́ryər ka̱t, ka̱kul kang uza̱ a vyap Atak Ayə́ryər Inan wò ka̱t, ka̱kul nggar ngga mmì ngga nggòr Inənan nna à yà ka̱ apəpal. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","<< <Uza̱ i ka̱m uchar uva̱ uwa à nyi ununggwan chit ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Uza̱ i ka̱m uchar ukpələng ka̱t, uga ngba̱l ìvang, ka̱t te umaimai ka̱t. Uza̱ i ka̱m uyen ɓyen uva̱ uwa à nyi ununggwan chit ka̱t ka̱ ashe onəm wò, ");
INSERT INTO yer_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","le kang uza̱ a vyap akùm wò ka̱ ashe onəm wò ka̱t. Mmami na uYawe, uva̱ gar na.> >> ");
INSERT INTO yer_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","UYawe là nnap ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","<<Là ûHaruna pa̱, kang unəm uro ka̱ akum wó, ka̱ ashe nkpaktak nlwàk wó uva̱ ká̱ mbyèt a ɓa a dát pa̱ ô yichi iya̱m inana iya̱m-nrì Înan wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Kang unəm uga mbyèt a ɓa a dát, unəm ufofo, ugurum, á vyap ka̱ asa̱l awú, ka̱t te ləlàk, ");
INSERT INTO yer_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ka̱t te unəm uva̱ ashar ka̱t te ìgwal ɓəkchiɓəkchi ká̱ na, ");
INSERT INTO yer_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ka̱t te ìdada asəm, ka̱t te uyenyen, ka̱t te ìwú nak ìkùr, ka̱t te arwa aga nwár izər, ka̱t te anunur, ka̱t te unəm va atutultutul ləlàk. ");
INSERT INTO yer_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Kang unəm uro ka̱ akum aHaruna unəm uga mpyal awop uva̱ ká̱ mbyèt a ɓa a dát pa̱ ô yichi iya̱m inana iya̱m-nrì ûYawe ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Uza̱ i ri iya̱m-nrì Inan wò iva̱ iyə́ryər va̱ ji, ká̱ iyə́ryər ri. ");
INSERT INTO yer_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ká̱ nnà te uza̱ i yà ká̱ ngga ndát ká̱ atani ka̱t te á ɓa á datkulung ka̱ atak nshì iya̱m awop ka̱t, ka̱kul mbyèt ka̱ izəzər. Kang uza̱ a vyap Atak Ayə́ryər mi ka̱t, ka̱kul mmami na uYawe, uva̱ nàl oza̱.>> ");
INSERT INTO yer_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Wa nnà te uMusa là ûHaruna ká̱ ovəvan ká̱ nkpaktak oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","<<Là ûHaruna ká̱ ovəvan pa̱ oza̱ á nak ishi ká̱ oga iya̱m inana iyə́ryər oIsa̱rila, iva oza̱ gar ka̱kul mi, le kang oza̱ a vyap aɗin mi ayə́ryər ka̱t. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Là ôza̱ pa̱, <A yà pa̱ nza̱ unəm nggo ka̱ akum wó ka̱ ashe nkpaktak oga nlwàk wó uva̱ ká̱ adak kang à ɓa à dát ká̱ iya̱m inana iyə́ryər va oIsa̱rila gar ûYawe, te mí fa ká̱ unəm va̱ ta kà̱ mpyal mi.> Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","<< <Kang unəm uro ka̱ akum áHaruna uva̱ ká̱ arwa ka̱ izər, ka̱t te iya̱m kà̱ nwár á na ka̱ izər, te i ri ka̱ ashe iya̱m inana iyə́ryər va̱ ta ka̱t, ya uza̱ i tàn kang. Nza̱ unəm nggo uva̱ dok iza̱ nggo va ká̱ adak, ka̱t te akúm, ka̱t te unəm va mpəng amar wàr á na, te uza̱ ká̱ adak ");
INSERT INTO yer_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ka̱t te unəm dok iya̱m iga nkpàng ká̱ afu iva i nak uza̱ i yà ká̱ mbyèt ka̱t te á dok unəmləbər uva̱ i nak uza̱ i yà ká̱ adak, adədak a yà iza̱ nggo. ");
INSERT INTO yer_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Unəm uga mpyal awop va̱ dok iza̱ nggo ka̱ ashe iya̱m va̱ ta̱, te uza̱ i yà ká̱ adak i ga i chu arurong, kang uza̱ i yà ká̱ nrí ka̱ ashe iya̱m inana iyə́ryər ka̱t, ya uza̱ i wòr izər wò ká̱ ndəng kang. ");
INSERT INTO yer_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Nva̱ngva̱ alum tar chit, te uza̱ i yà ká̱ mbyèt ka̱t, nnà chit te uza̱ i ri ka̱ ashe oga iya̱m inana iyə́ryər va̱, ka̱kul iya̱m-nrìri. ");
INSERT INTO yer_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kang uza̱ a ri ìzhe iya̱m ikuku ka̱t, kat te iva iya̱m iga anyin à kan, le kang uza̱ a yà ká̱ adak. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","<< <Onəm oga mpyal awop á kpak nɗyáng mi, le kang oza̱ a yà ká̱ mpat kang oza̱ ì kú ka̱kul nvivyap ka̱t. Mmami na uYawe, uva̱ gar oza̱. ");
INSERT INTO yer_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","<< <Unəm ugafak i ri ka̱ ashe iya̱m inana iyə́ryər ka̱t. Unəmchən ka̱t te unəm va̱ mmá yar na ka̱ inok i ri iya̱m inana iyə́ryər ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Kang a yà pa̱ unəm uga mpyal awop yap uzwal ká̱ mbwai wò, ka̱t te amar aga nzhízhi te uza̱ i ri iya̱m-nrìri ri. ");
INSERT INTO yer_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","A yà pa̱ uya ánəm uga mpyal awop uyen uchar váng ká̱ unəm ugafak te, uza̱ i yà ká̱ nrí ka̱ ashe iya̱m inana iyə́ryər va̱ ta̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Kang a yà pa̱ uya ànəm uga mpyal awop uyen uchar təm uchar ukpələng ka̱t te gba̱l ìvang, kang à yà ká̱ ovan ka̱t, te uza̱ le nzhi àpo wò wa nva ká̱ ivanɓyen, te uza̱ i ri iya̱m-nrì apo wò ri. Unəm ugafak i ri ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","<< <A yà pa̱ unəm va̱ unəm uga mpyal awop kat, ri iya̱m inana iyə́ryər ka̱ ashe mpat, te uza̱ i na uzəng ka̱ apal atukun ngga mmak iya̱m va̱ ta kang uza̱ i yichi iya̱m inana iyə́ryər ûnəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Kang onəm oga nshì iya̱m awop a vyap oga iya̱m inana iyə́ryər va̱ oIsa̱rila na ûYawe, ");
INSERT INTO yer_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","na kang á nak oza̱ kà̱ nnəm mpat ngga amwa ka̱kul pa̱ oza̱ ri iya̱m inana oza̱ iyə́ryər ka̱t. Mmami na uYawe, uva̱ gar oza̱.> >> ");
INSERT INTO yer_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","<<Là ûHaruna ká̱ ovəvan ká̱ nkpaktak oIsa̱rila, là ôza̱ pa̱, <Nza̱ unəm nggo ka̱ ashe nzhi àIsa̱rila, ka̱t te ka̱ ashe onəmchən va yichi iya̱m inana iga nshì pa̱ ɗwot, ka̱kul nyar nsar nnap-nlà oza̱ ka̱t te iya̱m inana iga nɗòm ìgwak. Iya̱m nkang va̱ ta i yà ká̱ mbyèt ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","A yà pa̱ uza̱ ɗom pa̱ iya̱m inana va̱ ta a yà ika̱mka̱m te, mkpak i yà ìna ìnunggwan, ka̱t te ìnagàm, ka̱t te iɓəl ìnunggwan iva yà ká̱ mbyèt ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Kang ó yichi iya̱m inana iya̱m nkang iva ka̱ mbyèt ka̱t, ka̱kul i yà ika̱mka̱m ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","A yà pa̱ unəm yichi nləfər iya̱m ipápà iga ntəm ikángkáng ûYawe pa̱ ô yə́l nsar nnap-nlà ka̱t te iya̱m inana iga nɗòm ìgwak, ka̱ ashe ina ka̱t te iya̱m nkang, te nkpak pa̱ á yà ká̱ mbyèt ka̱t, ka̱kul na á yà ika̱mka̱m. ");
INSERT INTO yer_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kang ó yichi iya̱m inana ûYawe ká̱ iya̱m nkang ifofo, ka̱t te iɓəkchiɓəkchi, ká̱ igùrum, ka̱t te iva iya̱m i wár á na ka̱ izər, ka̱t te ndangbyat. Ó yà ká̱ ǹyichi oga iya̱m va̱ ta̱ wa iya̱m inana iga apər ûYawe ka̱ apal atak nshì iya̱m awop ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ó yichi iya̱m inana iga nɗòm ìgwak ká̱ ìna ka̱t te itám iva ngɓəgɓək nro wuwang ka̱t te á agəptənggəptəng. Mi yà ká̱ nkəka̱m ka̱kul iya̱m inana iga nsar nnap-nlà ji wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ó yà ká̱ ǹyichi iya̱m iva̱ mmá nə́m atutul, mmá nyár, ka̱t te mmá zə̀p atutultutul ûYawe ka̱t. Ó yà ká̱ nnəm nva̱ ta ka̱ ashe mbin wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ko ka̱ awó aɗyanəm ó yà ká̱ ǹyichi apir iya̱m va̱ ta̱ wa iya̱m-nrì Înan wó ka̱t, ka̱kul mmá vyap chit, oza̱ ká̱ mbyèt, mí ka̱m oza̱ ka̱ anung wó ka̱t.> >> ");
INSERT INTO yer_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","<<A yà pa̱ mmá mar iya ìna ìnunggwan, ìnagam, ka̱t te ìɓəl ìnunggwan, te i təm ká̱ ìnang wò nra pa̱ nfangshat kang kà̱ nra ngga nna̱nne te, mí kəka̱m wa iya̱m inana apər ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Kang ó pà ìna ka̱t te ìtam ká̱ iyəyen n̂da nzəngtəng ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","<<A yà pa̱ u yichi nləfər iya̱m ipápà iga aɗəngchi ûYawe te, yichi nləfər ɓu ka̱ asa̱l va mí kəka̱m ka̱ anung ɓu. ");
INSERT INTO yer_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Nkpak mí ri n̂da va̱ ta, kang mmá re a chu ìpin ìkpa̱kkpa̱k ka̱t. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","<<Ó kpak oga nnap mpakpak mi, ó nak ishi ká̱ oza̱. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kang ó vyap aɗin mi ayə́ryər ka̱t, ka̱kul na n yà uyə́ryər ka̱ ashe oIsa̱rila. Mmami na uYawe uva̱ gar wó, ");
INSERT INTO yer_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","uva̱ fa ká̱ wó ka̱ ashe mbin aMasar pa̱ ô yà Inan wó. Mmami na uYawe.>> ");
INSERT INTO yer_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","<<Là nnàp ká̱ oIsa̱rila, là ôza̱ pa̱, Oga ìlum ìnaknak àYawe omà ta̱, iva ó shet ìyə́ryər iga mɓut, ìlum mi ìnaknak. ");
INSERT INTO yer_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","<<O nəm inok ka̱ apal ra pa̱ nkpa̱ɗing, kang ìlum iga ìfangshat te, i yà ìlum aSati iga njul, ìlum iga mɓut ǹyə́ryər. Kang ó nəm inok iro ka̱t, kà̱ nkpaktak atak va̱ ó təm kà̱, aSati aYawe. ");
INSERT INTO yer_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","<<Omà ta̱ oga ìlum ìnaknak àYawe, oga mɓut ǹyə́ryər, nva ó shet ká̱ ka̱ awalang oza̱ anaknak. ");
INSERT INTO yer_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","<<Kà̱ nra ngga ngba̱pchi ama̱n pa̱ neɗing ka̱ ape aga nggəshi ká̱ arurong te, ìlum nggantal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Kà̱ nra ngga ngba̱pchi ama̱n pa̱ tukun ka̱ ape va̱ ta te nnəm nchang izər ìlum inaknak nzəngkəng ngga ǹyà ká̱ anyer ka̱t ûYawe. Nra pa̱ nfangshat ó yà ká̱ nri nzəngkəng ngga ǹyà ká̱ anyer ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Kà̱ nra nggəshi kà̱ ìlum inaknak te ó nəm mɓut ǹyə́ryər. Kang ó nəm inok wó iga nza̱ nra nggo ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Nra pa̱ nfangshat ó yichi iya̱m inana iga apər ûYawe, mɓut ǹyə́ryər i yà kà̱ nra ngga nfangshat, ó nəm inok iga nza̱ nra nggo ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","<<Là nnàp ôIsa̱rila, là ôza̱ pa̱, A yà pa̱ ó tar mbin va̱ mmami kà̱ ngga nnəna á wó kang ó ɓən iya̱m-nrìri, te ó ɓa ká̱ nsar ngga nggəshi ûnəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Uza̱ i yege nsar va̱ ta kà̱ mpyal àYawe ka̱kul na mmá ka̱m. Unəm uga mpyal awop i yege kà̱ nkpa̱n aSati. ");
INSERT INTO yer_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Kà̱ ìlum va̱ ó yege nsar va̱ ta ká̱ te, ó yichi ìnagam iga ìzun pa̱ izəng iva yà ká̱ mbyèt ka̱t ka̱kul iya̱m inana iga nshì pa̱ ɗwot ûYawe, ");
INSERT INTO yer_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","nzəng ká̱ iya̱m inana ìpir ìkùr, mma̱k ǹyalyal ikpáng pa̱ iparəm mmá zuk mmì mpyet kà̱, iya̱m apər ûYawe inə́ngnəng ichángchàng, ká̱ iya̱m inana iwawa akwaya pa̱ zəng aga ndəng ìba̱ngba̱ng. ");
INSERT INTO yer_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ó yà ká̱ nrí nzəngkəng nro ka̱t te ìpir ìkùr ìfórfòr ka̱t te ìzhakan ka̱t, ya nra va ó ɓa ká̱ iya̱m inana Înan wó chit kang. Nɗyáng ngga mbyet mbyet ka̱kul oga nlwàk wó kà̱ nkpaktak atak va̱ ó təm kà̱. ");
INSERT INTO yer_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","<<Á ɓàn kà̱ nkpa̱n aSati va̱ ó ɓa ká̱ nsar ishi iya̱m inana iga ǹyege, te ó kung aSati pa̱ fangshat pa̱ súr. ");
INSERT INTO yer_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ó kung nra ìsəm pa̱ ìtukun á ga á chu nkpa̱n aSati aga fangshat, nnà chit te ó yichi iya̱m inana ìpir ìkùr izhakan ûYawe ɗak. ");
INSERT INTO yer_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ka̱ atak va̱ ó təm kà̱ te, ó ɓa ká̱ nzəngkəng mɓit pa̱ mparəm nva mmá nəm ká̱ mma̱k ǹyalyal ikpáng pa̱ iparəm, mmá ɓit ká̱ anyər, wa iya̱m inana iyegeyege iga awár aga nggəshi ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Te ó yichi nzəng ká̱ nzəngkəng va̱ ta itam inunggwan iga ìzun pa̱ ìzəng pa̱ ifangshat, iva̱ yà ká̱ mbyèt ka̱t, ká̱ ìya ìna ìnunggwang pa̱ ìzəng, ká̱ inagam pa̱ iparəm. Oza̱ i yà iya̱m inana iga nshì pa̱ ɗwot ûYawe, nzəng ká̱ iya̱m inana ìpir ìkùr oza̱ ká̱ oga iya̱m inana iwawa, iya̱m inana iga apər, inə́ngnəng ichángchàng ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Yichi mbìt pa̱ nzəng ka̱kul iya̱m inana nnap mɓá̱ngɓa̱ng kpa, ká̱ inagam iga ìzun pa̱ ìzəng pa̱ iparəm, ka̱kul nləfər iya̱m inana iga ntəm ikángkáng. ");
INSERT INTO yer_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Unəm uga mpyal awop i yege inagam iga iparəm va̱ ta kà̱ mpyal àYawe wa iya̱m inana iga ǹyege nzəng ká̱ nzəngkəng ngga awár aga nggəshi. Oza̱ i yà iya̱m inana iyə́ryər ûYawe ka̱kul ánəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Kà̱ ìlum ìzəngtəng va ta ó wór mɓut, á yà mɓut ǹyə́ryər á wó, kang ó nəm inok iga nza̱ nra nggo ka̱t. Nnà ta̱ i yà nnap mpakpak ngga mbyet mbyet kà̱ nkpaktak atak ntəm wó ka̱ ashe oga nlwàk wó. ");
INSERT INTO yer_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","<<Kang a yà pa̱ ó ɓən iya̱m iga mbin wó te, kang ó ɓən anung iram wó ka̱t, ka̱t te ó chák nva̱ng iya̱m mɓən wó va̱ tàk kà̱ mbin ka̱t. Ó re oza̱ ka̱kul onəm oga nkun ká̱ oɗyanəm. Mmami na uYawe, Inan wó.>> ");
INSERT INTO yer_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","<<Là ôIsa̱rila pa̱, Kà̱ nra ngga nggəshi ka̱ ape aga afangshat, te ó nak ishi ká̱ aSati njul, mɓut ǹyə́ryər nva mí nəm ká̱ iya̱m iɓúrɓúr. ");
INSERT INTO yer_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Kang ó nəm inok iga nza̱ nra nggo ka̱t, nnyi te ó yichi iya̱m inana iga apər ûYawe.>> ");
INSERT INTO yer_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","<<Nra ngga ngba̱pchi ngga ape aga afangshat va ta̱, nra ngga mmwa ishi. Á yà mɓut ǹyə́ryər á wó, ó dang ishi wó ká̱ iya̱m-nrì, kang ó yichi iya̱m inana iga apər ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Kang ó nəm inok iro n̂da va̱ ta ka̱t, ka̱kul nra ngga mmwa ishi nva mí nəm mmwa ishi ká̱ ka̱kul wó kà̱ mpyal àYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Nza̱ unəm nggo va̱ dang ishi wò ká̱ iya̱m-nrì kà̱ ìlum va̱ ta ka̱t te, mí fa ká̱ na ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Kang nza̱ unəm nggo va̱ nəm inok kà̱ ìlum va̱ ta te, mi zhì na ka̱ ashe onənəm. ");
INSERT INTO yer_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Kang ó nəm inok iro ka̱t. Iva ta̱ na nɗyáng ngga mbyet mbyet ka̱kul oga nlwàk wó kà̱ nkpaktak atak va̱ ó təm kà̱. ");
INSERT INTO yer_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ASati aga njul ka̱kul wó, te ó dang ishi wó ká̱ iya̱m-nrì, ɓàn ká̱ arurong aga nra ngga nfangzəngtəng ngga ape i ga i chu arurong aga ìpin ìkpa̱kkpa̱k, ó nak ishi ká̱ aSati wó.>> ");
INSERT INTO yer_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","<<Là ôIsa̱rila pa̱, Kà̱ nra ngga ngba̱pchi ama̱n pa̱ tukun ka̱ ape aga afangshat te, nnəm nchang izər ìlum Inaknak ngga Aghal ûYawe, nva i yar nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Kà̱ nra nggəshi te ó nəm mɓut ǹyə́ryər, kang ó nəm inok wó iga nza̱ nra nggo ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ka̱ apal nra pa̱ nfangshat ó yichi iya̱m inana apər ûYawe, kang nra ngga nna̱nne te i yà mɓut ǹyə́ryər á wó, te ó yichi iya̱m inana iya̱m apər ûYawe. Ìlum ichumchum iga awop, kang ó nəm inok wó iga nza̱ nra nggo ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","<<Oga ilum inaknak va ta̱ uYawe nak, iva ó shet ká̱ wa oga mɓut ǹyə́ryər ka̱kul ǹyichi iya̱m inana apər ûYawe, iya̱m inana iga nshì pa̱ ɗwot, iya̱m inana ìpir ìkùr, ká̱ nləfər iya̱m inana iya̱m nkang, ká̱ iya̱m inana iwawa. Nza̱ ìlum inaknak nggo ká̱ ìlum iga nchang ìzər wò, ");
INSERT INTO yer_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","oga ìlum inaknak va̱ ta̱ nna yà iro ka̱ apal aSati áYawe ká̱ oga iya̱m inana wó, nkpaktak oga iya̱m inana nsar nnap-nlà wó, ká̱ nkpaktak oga iya̱m inana iga nɗòm ìgwak wó va̱ ó na ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","<<Ka̱ nra ngga agba̱pchi ama̱n pa̱ tukun ka̱ ape aga afangshat, nva̱ngva̱ ó ɓən iya̱m iga mbin chit, te ó nəm nchang izər ìlum Inaknak iga Aghal ûYawe nva̱ i yar nra pa̱ nfangshat. Mí nəm njul kà̱ nkpaktak ìlum iga nggəshi kang njul kà̱ nkpaktak ìlum iga ìna̱nne kpa. ");
INSERT INTO yer_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Kà̱ ìlum iga nggəshi te ó wur ka̱kul ishi wó awár ikún inəna̱n, agwal akulom, oga igwong iga agwal ikun pa̱ zhəkzhək, kang ó nəm nchang ìgwak kà̱ mpyal àYawe, Inan wó nra pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ó nəm nchang izər ìlum inaknak ûYawe nra pa̱ nfangshat ka̱ ashe ìzun. Nɗyáng ngga mbyet mbyet ka̱kul oga nlwàk wó, kang ó nəm nchang ìzər ka̱ ape aga afangshat. ");
INSERT INTO yer_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ó təm ka̱ ashe oga aghal nra pa̱ nfangshat. Nkpaktak ovan omarmar oIsa̱rila i təm ka̱ ashe oga aghal, ");
INSERT INTO yer_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ka̱kul na oga nlwàk wó á nyi pa̱ n nak oIsa̱rila təm ka̱ ashe oga aghal, nva̱ng nva̱ n fa ká̱ oza̱ ka̱ ashe mbin oga aMasar. Mmami na uYawe, Inan wó.>> ");
INSERT INTO yer_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ka̱ asa̱l va ta̱ uMusa shet oga ìlum inaknak àYawe ôIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","UYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","<<Nak oIsa̱rila á ɓa ká̱ mmì mpyet á ɓu nva mmá ka̱m nnəna̱n ka̱kul na apitila á sàl pa̱ ɗəkər. ");
INSERT INTO yer_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","UHaruna i chwong oza̱ kà̱ nsəm atani ka̱ mpyal akwati aga nsar nnap-nlà ka̱ ashe Aghal Mɓut, i ɓàn ká̱ arurong i ga i chu ntàn atak kà̱ mpyal àYawe pa̱ ɗəkər. Nɗyáng ngga mbyet mbyet ka̱kul oga nlwàk wó. ");
INSERT INTO yer_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Uza̱ i nak ishi ká̱ oga apitila va̱ ka̱ apal ìdari azənariya anəna̱n kà̱ mpyal àYawe pa̱ ɗəkər. ");
INSERT INTO yer_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","<<Kpa̱k mma̱k nnəna̱n fòr nzəngkəng ká̱ pa̱ ngba̱pchi ama̱n pa̱ parəm, nza̱ mɓìt nggo mmá nəm na ká̱ mma̱k ikpáng pa̱ iparəm. ");
INSERT INTO yer_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Dàt oza̱ nzhi pa̱ mparəm nza̱ nzhi nggo ká̱ nzəngkəng pa̱ nkpa̱ɗing ka̱ apal atebəl aga azənariya kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Nak njəng nnə́ngnəng nchángchàng kà̱ nza̱ nzhi nggo, na á yà ka̱ aɗor nzəngkəng, wa iya̱m inana apər ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Uza̱ i dàt nzəngkəng va̱ ta kà̱ mpyal àYawe nza̱ aSati nggo, ka̱ anung oIsa̱rila. Nsar nnap-nlà mbyet mbyet. ");
INSERT INTO yer_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","I yà iji áHaruna ká̱ ovəvan onunggwan, oza̱ i ri ka̱ Atak Ayə́ryər, ka̱kul iyə́ryər va ji pa̱ kpaktak ka̱ ashe iya̱m inana apər ûYawe. Nnap mpakpak ngga mbyet mbyet.>> ");
INSERT INTO yer_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Uyen ununggwan uro wa yà unənang uyen oga aIsa̱rila kang upupo unəm oga aMasar á fa ga ashe oIsa̱rila, te ìkum fa uya àyen uchar oIsa̱rila va̱ ta ká̱ unəm oIsa̱rila ka̱ ashe apa̱k. ");
INSERT INTO yer_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Uyen àchar va̱ ta sóng anung pwat aɗin Inan, te oza̱ ɓa ká̱ na ka̱ atak áMusa. Aɗin anənang pa̱ uShelomit uyen àDibəri ka̱ akum áDan. ");
INSERT INTO yer_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Oza̱ kùk na pa̱ ná ó fe iya̱m va̱ uYawe i là ôza̱ pa̱ na o nəm ká̱ na. ");
INSERT INTO yer_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Te uYawe là ûMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","<<Fa ká̱ unəm va̱ pwat mpwat kà̱ nsəm apa̱k, na nkpaktak onəm va̱ fe na á nak awó oza̱ ka̱ ishíshi na mmà nnyi pa̱ uza̱ nəm mpat va̱ ta nəm, na nkpaktak mɓut á kwan na ká̱ ipáng uza̱ á kú. ");
INSERT INTO yer_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Te là ôIsa̱rila pa̱, a yà pa̱ unəm a pwat Inan wò te, uza̱ i yar nsur mpat wò. ");
INSERT INTO yer_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Nza̱ unəm nggo va vyap aɗin aYawe te mí gba̱l na. Nkpaktak mɓut i kwan na ká̱ ipáng, uɗyanəm ka̱t te uyen uga mbin, a yà pa̱ uza̱ vyap aɗin va̱ ta te, mí gba̱l na. ");
INSERT INTO yer_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","<<A yà pa̱ unəm gba̱l unəmləbər te, nkpak mí gba̱l na. ");
INSERT INTO yer_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Nza̱ unəm nggo va gba̱l iya̱m nkang áwan wò te, uza̱ i mwa akə́kat, irirì ka̱kul irirì. ");
INSERT INTO yer_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","A yà pa̱ unəm nak aɓang uwan wò te, mí nəm á na wa nva uza̱ nəm, ");
INSERT INTO yer_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","mɓəkchi ka̱ anung mɓəkchi, ìwú ka̱ anung ìwú, ìnyin ka̱ anung ìnyin, wa nva uza̱ nak aɓáng ûnəmləbər te, wa nnà ta mí nəm á na kpa. ");
INSERT INTO yer_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Nza̱ unəm nggo va gba̱l iya̱m nkang te, uza̱ i mwa akə́kat, kang unəm va̱ gba̱l unəmləbər te, mí gba̱l na. ");
INSERT INTO yer_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ó yà ká̱ nnap mpakpak pa̱ nzəng ka̱kul áɗyanəm ká̱ uyen uga mbin. Mmami na uYawe, Inan wó.>> ");
INSERT INTO yer_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Nva̱ngva̱ uMusa là ôIsa̱rila, te oza̱ fa ká̱ unəm va̱ pwat mpwat kà̱ nsəm apa̱k kang oza̱ kwan na ká̱ ipáng. AIsa̱rila nəm wa nva uYawe nak ûMusa. ");
INSERT INTO yer_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","UYawe là nnàp ká̱ uMusa ka̱ apal aƁam aSinayi pa̱, ");
INSERT INTO yer_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","<<Là nnàp ká̱ oIsa̱rila, là ôza̱ pa̱, Awalang va̱ ó táng ashe mbin va̱ mmami kà̱ ngga nnəna á wó te, mbin va̱ ta i nak ishi ká̱ njul aSati ûYawe. ");
INSERT INTO yer_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ó suk iram wó ìzun pa̱ ìkpa̱ɗing, kang ó gbar iram ìba̱ngba̱ng wó ìzun pa̱ ìkpa̱ɗing, kang ó ɓut awúwar. ");
INSERT INTO yer_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Kang kà̱ ìzun iga ìfangshat te, i yà aSati aga njul mbin, aSati ûYawe. Kang ó suk iram wó, ka̱t te ó gbar iram ìba̱ngba̱ng wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ó yà ká̱ mɓən iya̱m va̱ fa ká̱ ishi wò ka̱ ashe iram wó ka̱t, kang ó páng awár ìba̱ngba̱ng va̱ fa ká̱ ishi wò ka̱t. I yà ìzun iga njul m̂bin va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Nkpaktak iya̱m i va̱ mbin ná kà̱ ìzun aSati aga njul te, i yà iya̱m-nrì ka̱kul wó, ka̱kul ɓu, uzwal ɓu ununggwan ka̱t te uchar, ká̱ unəm va̱ u yar ka̱ inok, ka̱t te uɗyanəm uva̱ kà̱ ntəm ká̱ ɓu, ");
INSERT INTO yer_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ka̱kul iya̱m nkang ká̱ izhé iga anyin va̱ kà̱ mbin ɓu. Nkpaktak iya̱m va̱ mbin i na te i yà iya̱m-nrì.>> ");
INSERT INTO yer_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","<<Te ɓu kung ìzun iga njul aSati pa̱ nfangshat, ufangshat ka̱ apal ìzun pa̱ ìfangshat, ka̱kul na nra aSati pa̱ fangshat nva̱ng pa̱ nfangshat á yà ìzun ìsəm neɗing ama̱n pa̱ fangzəngtəng. ");
INSERT INTO yer_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Te ɓu ɓur agbəshì pa̱ gbá̱ngbá̱ng kà̱ nra ngga ngba̱pchi ka̱ ape aga afangshat. Kà̱ nra ngga Mmwa Ishi te, ɓur agbəshì ka̱ ashe nkpaktak mbin ɓu. ");
INSERT INTO yer_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Te ó gòr ìzun iga ìsəm pa̱ ìtukun kang ó shet ká̱ nfən ka̱ ashe mbin ka̱kul nkpaktak onəm oga ntəm ka̱ ashishe. Kà̱ ìzun i va ta̱ mí le ká̱ nkpaktak iya̱m ádango á na, i yà ìzun iga nfən, kang nza̱ uzəngtəng wó nggo i le atak akum wò. ");
INSERT INTO yer_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ìzun iga ìsəm pa̱ ìtukun i yà iga nfən á wó. Ó suk iya̱m ka̱t, ó ɓən iya̱m va̱ fa ká̱ ishi wò ka̱t, ka̱t te ó páng awár ìba̱ngba̱ng va̱ nəm ká̱ ishi wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","I yà ìyə́ryər ka̱ atak wó, ka̱kul i yà ìzun iga nfən. Ó ri iya̱m va mmá ya ka̱ ashe ìram. ");
INSERT INTO yer_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","<<Ka̱ ashe ìzun iga nfən va̱ ta̱ te, nza̱ uzəngtəng wó nggo i le atak iya̱m wò. ");
INSERT INTO yer_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","<<A yà pa̱ u yáp ká̱ iya̱m ûwan ɓu, ka̱t te u yáp iya̱m kà̱ uwan ɓu te, kang ó mwar owan wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","A yà pa̱ u yáp ìyap kà̱ uwan ɓu te, i yà ka̱ apal ǹyə́l ìzun iga nva̱ng ìzun iga nfən. Uza̱ i yáp ká̱ á ɓu ka̱ apal ìyəl ìzun iga mɓən iya̱m. ");
INSERT INTO yer_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Mmak mbubwai i màl ká̱ mmak ìzun, kang ǹyen mbubwai i màl ká̱ ǹyen ìzun, ka̱kul uza̱ kà̱ ǹyáp ká̱ á ɓu ka̱ apal ǹyə́l ìzun i va̱ ɓu wap ìram va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Kang ó mwar owan wó ka̱t, ó nəm ayər Inan wó, ka̱kul mmami na uYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","<<Ó kpak oga nɗyáng mi ká̱ oga nnap mpakpak mi, ó nak ishi ká̱ oza̱, na ó təm ka̱ ashe mbin va̱ ta ká̱ ikángkáng. ");
INSERT INTO yer_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Te mbin i na awár wò, ó ri i yə́l afu á wó, kang ó təm ká̱ ikángkáng ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","A yà pa̱ ó ɓəp pa̱, <<Iza̱ í ri kà̱ ìzun iga ìfangshat, a yà pa̱ í suk ka̱t, ka̱t te í ɓut iya̱m mɓən yi ka̱t yà?>> ");
INSERT INTO yer_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Te mi nak nnap nnəna̱n mi á wó ka̱ ashe ìzun iga ìkpa̱ɗing, na mbin nva̱ ta á na iya̱m-nrì pa̱ makmak ngga ìzun pa̱ ìparəm. ");
INSERT INTO yer_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","A yà pa̱ ó suk iya̱m kà̱ ìzun iga ìna̱nne te, ó yà kà̱ nrí ka̱ ashe iya̱m mɓən ikpa̱n i ga i chu ìzun iga ìfangzəngtəng, ya iya̱m mɓən izhakan i nəm kang. ");
INSERT INTO yer_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","<<Mí yáp ká̱ mbin mbyet mbyet ka̱t, ka̱kul njem, kang mmawó oɗyanəm oga ntəm ndàtdàt ká̱ mi. ");
INSERT INTO yer_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ka̱ ashe nkpaktak oga mpwom wó te, ó nak asa̱l va̱ mí le ká̱ mbin va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","<<A yà pa̱ ugənang ɓu kun ga mà ɓà̱k kang à yáp ká̱ iya̱m wò iro ka̱ ashe iyəya̱m, te unənal uga ndátkulung ká̱ na i ɓa i mwa iya̱m va̱ ugənanggənang yáp ká̱. ");
INSERT INTO yer_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","A yà pa̱ unəm va̱ ta yà ká̱ unal uga mmumwa á na ka̱t, kang uza̱ wong yà ká̱ iya̱m iga mmumwa îshi wò, ");
INSERT INTO yer_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","te uza̱ i kung mmak ìzun va̱ mmá yáp ká̱, uza̱ i le ká̱ aɓo mbwai ûnəm va̱ uza̱ yáp ká̱ á na, te iyəya̱m i le á na. ");
INSERT INTO yer_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Kang a yà pa̱ uza̱ yà ká̱ iya̱m iga mmumwa ka̱t te, iya̱m va̱ uza̱ yáp ká̱ te i təm ka̱ awó ánəm uga ǹyiyap i ga i chu ìzun iga nfən. Mí le ká̱ kà̱ ìzun iga nfən, te uza̱ i le ká̱ iya̱m wò. ");
INSERT INTO yer_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","<<A yà pa̱ unəm yáp ká̱ nzhi nra wò ka̱ ashe ìtong iga akamsəlang, te i lile kà̱, kà̱ ìzun va̱ uza̱ yáp ká̱. Nra ngga mmumwa na ta. ");
INSERT INTO yer_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","A yà pa̱ uza̱ mwa ka̱ ashe ìzun iga ìzəng va̱ ta ka̱t, te nzhi ngga ashe ìtong iga akamsəlang va̱ ta i yà nji ànəm va yáp kà̱ nkpaktak nlùlwak mbyet mbyet. Mí yà ká̱ nle ká̱ kà̱ ìzun iga nfən ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Kang a yà pa̱ oga nzhi kà̱ ivan ìtong va̱ akamsəlang gáng oza̱ ka̱t, te mí kung oza̱ nzəng ká̱ agbagba mbin. Mí le ká̱ oza̱ le ká̱ ìzun iga nfən. ");
INSERT INTO yer_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","<<Kà̱ ìtong oLawi te, oLawi òma à yà ká̱ atak nsat ngga mbyet mbyet pa̱ ó le ká̱ nzhí nji oza̱ va̱ ka̱ ashe itong oza̱. ");
INSERT INTO yer_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Nza̱ iya̱m ka̱ ashe oLawi nggo te mí lile ká̱. Nzhi va̱ mmá yáp ká̱ ka̱ ashe ìtong va̱ iji oza̱ te, mí le ká̱ ka̱ ìzun iga nfən, ka̱kul nzhi va̱ ka̱ ashe ìtong oLawi te nji oza̱ ka̱ ashe oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Kang atak nkpak iya̱m nkang aga ìtong oza̱ te mí yáp ká̱ ka̱t, ka̱kul aji oza̱ mbyet mbyet. ");
INSERT INTO yer_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","<<A yà pa̱ ugənang ɓu kun ga mà ɓà̱k va i ka̱mshi ishi wò ka̱ ashe wó ka̱t, te ó təp na wa nva ó təp uɗyanəm uga ntəm ka̱ ashe wó, kang uza̱ i təm ká̱ wó. ");
INSERT INTO yer_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Kang wa akát ká̱ nram mmák ka̱t te nkak ka̱ apəpal kà̱ na ka̱t. Te wa nəm ayər Inan ɓu, kang ugənang ɓu ì təm ká̱ ɓu. ");
INSERT INTO yer_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kang wa na akát mbwai á na ká̱ nram mmák kà̱, ka̱t te wa yáp ká̱ iya̱m-nrì ɓu á na ká̱ nram nkak ka̱ apəpal ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mmami na uYawe, Inan wó, uva̱ fa ká̱ wó kà̱ mbin aMasar na ń na mbin aKanana á wó, na ń yà Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","<<A yà pa̱ ugənang ɓu ká̱ ɓu kang à kun, te yáp ká̱ ishi wò á ɓu, te kang wa nak na á nəm inok á ɓu wa ázwal ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Uza̱ á təm ká̱ ɓu wa ánəm uga ǹyar ka̱ inok ka̱t te uga ntəm ndàtdàt, uza̱ i nəm inok á ɓu i ga i chu Ìzun iga Nfən. ");
INSERT INTO yer_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Te uza̱ ká̱ ovan wò i fa ka̱ atak ɓu, kang uza̱ i le atak akum wò ka̱ atak iya̱m ópo wò. ");
INSERT INTO yer_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Ka̱kul oza̱ okpari mi, ova n fa ká̱ oza̱ kà̱ mbin aMasar, kang mmá yáp ká̱ oza̱ wa ǹyáp ká̱ ozwal ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kang wa nəm ichumchum isaisai ka̱ apal oza̱ ka̱t, te nəm ayər Inan ɓu. ");
INSERT INTO yer_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","<<Ozwal ɓu onunggwan ká̱ ochar va̱ i yà oji ɓu te, á yà kà̱ mbin va gáng wó, ó yáp ozwal ka̱ atak oza̱. ");
INSERT INTO yer_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ó yáp ozwal yáp ka̱ ashe ovan oɗyanəm va̱ kà̱ ntəm ká̱ wó, ka̱ ashe akum oza̱ va̱ kà̱ ntəm ka̱ ashe wó kpa. Ova oza̱ mar ka̱ ashe mbin wó, kang oza̱ i yà iya̱m wó. ");
INSERT INTO yer_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ó wur oza̱ á yà iya̱m akup ovan wó va̱ kà̱ nva̱ng wó mbyet mbyet. Ó nəm inok nəm ká̱ oza̱ wa ozwal. Owan wó oIsa̱rila ji wò te, kang unəm a nəm ichumchum isaisai ûwan wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","<<A yà pa̱ uɗyanəm ka̱ ashe wó dur, kang ugənang ɓu wong kun ga mà ɓà̱k ka̱ atətak kang à yáp ká̱ ishi wò ûɗyanəm va̱ kà̱ ntəm ka̱ ashe wó, ka̱t te unəm uga akum áɗyanəm va̱ ta, ");
INSERT INTO yer_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","kà̱ nva̱ng ǹyáp ká̱ ishi wò te uwa à yà ká̱ atak nsat ngga nka̱m ishíshi. Uzəngtəng ka̱ ashe ogənanggənang i ka̱m ishíshi ka̱m. ");
INSERT INTO yer_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Ukikyan ka̱t te uya àkikyan ununggwan ka̱t te unəm uro ka̱ ashe onənal uga ndátkulung ka̱ ashe akukum i mwa ishíshi. A yà pa̱ uza̱ wong dur te uza̱ i mwa ishi wò. ");
INSERT INTO yer_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Uza̱ i kung nzəng ká̱ unəm va̱ yáp na, ìyəl ìzun va̱ uza̱ yáp ká̱ ishi wò á na i ga i chu Ìzun iga Nfən. Mbwai ìyəyap i màl ká̱ mbwai inok ánəm uga ǹyar ká̱ inok ka̱ ashe izun va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","A yà pa̱ nna à ɓur izun pa̱ makmak, te uza̱ i mwa mbwai nka̱m ishi wò i màl ká̱ mbwai va̱ mmá ka̱ yáp na ká̱. ");
INSERT INTO yer_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Kang a yà pa̱ ɓur izun pa̱ ɗa̱p i chu Ìzun iga Nfən, te uza̱ i kung kang i mwa mbwai ngga nka̱m ishi wò i màl ká̱ aɓo izun. ");
INSERT INTO yer_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Uza̱ i təm ká̱ unəm va̱ yáp na wa ánəm va mmá yar ka̱ inok ìzun, ìzun. Uɗyanəm va̱ yáp na te i yà ká̱ nnəm ichumchum isaisai á na ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","<<A yà pa̱ mmá ka̱m ishíshi ka̱ asa̱l ro ka̱ ashe oga ava̱ ta̱ ka̱t, te uza̱ ká̱ ovan wò mí re oza̱ i ga ka̱ ashe Ìzun iga Nfən. ");
INSERT INTO yer_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ka̱kul oIsa̱rila okpari mi. O va n fa ká̱ oza̱ kà̱ mbin aMasar. Mmami na uYawe, Inan wó.>> ");
INSERT INTO yer_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","UYawe là pa, <<Kang ó nəm ichər ka̱kul ishi wó ka̱t te ala̱ka̱n akpákpà, ka̱t te ndar ǹyə́ryər ka̱kul ishi wó ka̱t te ipáng ikpákpà kà̱ mbin wó pa̱ ó kúchì á na, ka̱kul mmami na uYawe, Inan wó. ");
INSERT INTO yer_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ó kpak ìlum aSati mi kang ô rup ká̱ atak awop mi. Mmami na uYawe. ");
INSERT INTO yer_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","<<A yà pa̱ ó kpak oga nɗyáng mi kang ó nak ishi ká̱ oga nnap mpakpak mi ó nəm inok ká̱ oza̱, ");
INSERT INTO yer_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","te mi re nrè ká̱ ìva̱r ka̱ awalang va màl, na mbin i na iya̱m-nrì, kang oga ikún iga ashe iram i na awár oza̱. ");
INSERT INTO yer_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Mpək iya̱m wó i ga i chu awalang aga mpáng ìba̱ngba̱ng, kang mpáng ìba̱ngba̱ng i ga i chu awalang aga nsuk iya̱m, te ó yà ká̱ iya̱m-nrì pa̱ makmak pa̱ ó ri kang ó təm ká̱ ikángkáng ka̱ ashe mbin wó. ");
INSERT INTO yer_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","<<Mi na ntəm ikángkáng kà̱ mbin, kang ó ra ká̱ iya̱m iro i gbək wó ka̱t. Mi fa ká̱ izhé iɓá̱ngɓa̱ng ka̱ ashe mbin, kang ndokchì i yà ká̱ nwatar ka̱ ashe mbin wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ó ɓàk onəm ìkum wó kang oza̱ i tàk kà̱ mpyal wó ka̱ atak ndokchì. ");
INSERT INTO yer_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Pa̱ otukun ka̱ ashe wó i ɓàk ìgba̱l, kang ìgba̱l ka̱ ashe wó i ɓàk ìkalong pa̱ ìgba̱pchi, kang okpa ìkum wó i tàk kà̱ mpyal wó ka̱ atak ndokchì. ");
INSERT INTO yer_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","<<Mi nak nnap nəna̱n á wó, mi nak wó ó myak ó yə́l, kang mi kpan nsar nnap-nlà mi ká̱ wó. ");
INSERT INTO yer_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ó ri iya̱m ikpa̱n iva mmá ɓut chit gbà̱ng, kang ó wur ikpa̱n va̱ ta i fa na á le ká̱ atak îzhakan. ");
INSERT INTO yer_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Mi nak atak ntəm mi ka̱ ashe Aghal ayə́ryər ka̱ ashe wó, kang mi yà ká̱ ǹyang ká̱ wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mi chen kà̱ ìshimshe wó kang mi yà Inan wó, kang ó yà onəm mi. ");
INSERT INTO yer_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mmami na uYawe, Inan wó, uva̱ fa ká̱ wó kà̱ mbin aMasar, na kang ó yà ozwal oza̱ lap ka̱t, kang n cwan ndar ayok wó na á nak wó ó nəm ntəm ngga akul ishi wó. ");
INSERT INTO yer_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","<<A yà pa̱ ó kpak nnap nnəm á mi ka̱t, kang ó nak ishi ká̱ nkpaktak oga nnap mpakpak va̱ ta̱ ka̱t, ");
INSERT INTO yer_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","kang a yà pa̱ ó yang ká̱ oga nɗyáng mi kang ó yen ká̱ oga nnap nkpakkpak mi, o nak ishi ká̱ nkpaktak oga nnap mpakpak ka̱t, kang o ɓəkchi nsar nnap-nlà mi ká̱ wó, ");
INSERT INTO yer_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","te iya̱m va ta̱ mi nəm á wó, mi ɓa ká̱ mɓək anung nnga nnəm ayər ka̱ ashe wó, ká̱ arwa aga nyà ká̱ ntán ka̱t, arwa atak rusok ava i nak iwú wó i fo kang ó yà onəm onəna̱n ka̱t. Ó suk iya̱m nsuk ka̱ anung amwang, ka̱kul okpa ìkum wó i ga nriri. ");
INSERT INTO yer_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Mi nak ìwú mi ka̱ apal wó, kang okpa ìkum wó i nəm igwan ká̱ wó. Onəm oga ǹyáng wó i nəm igwan ká̱ wó. Onəm oga ǹyáng wó i nəm ichumchum ká̱ wó, kang ó chəng nchəng va unəm uro kà̱ nwà wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","<<A yà pa̱ kà̱ nva̱ng oga iya̱m va̱ ta̱ kang ó kpak nnap nnəm á mi ka̱t te, mi nyám ntàn á wó nva̱ng pa̱ nfangshat ka̱kul nnap mɓá̱ngɓa̱ng wó. ");
INSERT INTO yer_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Mi chwan nkak ishi wó ngga nkəɗyar kang mi nak ìva̱r ipəng ka̱t, kang mbin wó i wom i yà wa acham. ");
INSERT INTO yer_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ìkam wó i kùr ka̱ iya̱m ilakchi. Ka̱kul mbin wó i na iya̱m-nrì wò ka̱t, kang oga ikún iga mbin wó i na awár oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","<<Kang a yà pa̱ ó dap ká̱ mi kang ó yang ká̱ nkpak nnap nnəm á mi, te mi nak oga mɓək anung wó i mak nva̱ng pa̱ nfangshat ka̱kul oga nnap mɓá̱ngɓa̱ng wó. ");
INSERT INTO yer_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Mi re nrè ká̱ izhé iga anyin ka̱ ashe wó, iva i gbá̱ng ovan wó, i vyap iya̱m nkang wó, kang i nak ìyəl wó i yen i ga i chu ìva i nak mí chəng oga asa̱l wó. ");
INSERT INTO yer_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","<<Kang a yà pa̱ káp ká̱ oga iya̱m va̱ ta̱, te ó ka̱m nɗyáng ntàn mi ka̱t, ó ga mpyal ká̱ nnəm nkak ishi ká̱ mi, ");
INSERT INTO yer_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","te mi pyat á wó, kang mi mɓək anung á wó nva̱ng pa̱ nfangshat ka̱kul nnap mɓá̱ngɓa̱ng wó. ");
INSERT INTO yer_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Te mi ɓa ká̱ ndokchì ngga mpyát akat mɓəkchi nsar nnap-nlà, kang ó ɓut kà̱ oga ìtong wó te, mi re nrè ká̱ arwa kà̱ ìshimshe wó, kang mí na wó ka̱ ashe awó onəm ìkum wó. ");
INSERT INTO yer_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Nva̱ng va̱ n gəl asa̱l iya̱m-nrì wó te, ochar pa̱ ogba̱pchi i pə́k nzəngkəng wó ka̱ ashe achər apər aga nwàng iya̱m pa̱ ìzəng, kang oza̱ i ɓa ká̱ nzəngkəng ka̱ atak mmàl ìɗək, ó ri kang i kúr wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","<<Kang a yà pa̱ káp ká̱ iya̱m va̱ ta̱, ó kpak nnap nnəm á mi ka̱t, ó nəm nkak ishi á mi, ");
INSERT INTO yer_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","te mi pyat á wó ka̱ ashe nlak ìgwak ìɓá̱ngɓa̱ng, kang mi nyám ntàn á wó nva̱ng pa̱ nfangshat iji mmatmat ji ka̱ apal oga nnap mɓá̱ngɓa̱ng wó. ");
INSERT INTO yer_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ó ri izhé ovan wó onunggwan ká̱ izhé ovan wó ochar. ");
INSERT INTO yer_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Mi chwan oga atak awop wó, mi kyen oga atak ndung nturari wó, kang mi ɓut oga akúm wó ka̱ apal oga ichə̀r wó, mi yang ká̱ wó. ");
INSERT INTO yer_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mi nak oga itong wó i təm agúng kang mi vyap oga atak awop wó. Mi yà ká̱ ka̱m iya̱m inana wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Mmami ká̱ ishi mi mi vyap mbin wó, na okpa ìkum wó va̱ i ɓa ntəm kà̱ te oza̱ á ga̱m. ");
INSERT INTO yer_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Te mi tur ndokchì kà̱ wó, kang mi lyangshin wó ka̱ ashe mbin. Mbin wó i təm nkpələng, kang oga itong wó i ra agúng. ");
INSERT INTO yer_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Kang mbin i fe nchang aSati izún wò aga njul kà̱ nkpaktak awalang va̱ á ra nkpələng, nva̱ nna ka̱ ó yà ka̱ ashe mbin onəm ìkum wó á. ");
INSERT INTO yer_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Nkpaktak awalang va̱ ra nkpələng te i ya njul nva̱ uza̱ ka̱ yà ka̱t, kà̱ nra oga aSati wó, nva̱ ka̱ ó yà kà̱ ntəm ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","<<Aɓo oro va̱ le ka̱ ashe wó te, mi nak ayər ka̱ ashe igwak oza̱ ka̱ ashe mbin onəm ìkum oza̱. Nnáp agwal azang i nak oza̱ kà̱ nchəng. Oza̱ i chəng wa nchəng ndokchì, kang oza̱ i tàk, káp ká̱ nva̱ unəm uro kà̱ mɓàk oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Káp ka̱ nva̱ pa̱ unəm uro kà̱ mɓàk oza̱ ka̱t, oza̱ i nə́m ifang ka̱ apal owan oza̱ wa nchəng ndokchì. Kang ó yà ká̱ ìkam iga ntong kà̱ mpyal okpa ìkum wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ó zhì ka̱ ashe mbín, mbin onəm ìkum wó i ma̱ng wó. ");
INSERT INTO yer_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Aɓo oro va̱ le ka̱ ashe wó te, oza̱ i kú ka̱ mbin okpa ìkum oza̱ ka̱kul nnap mɓá̱ngɓa̱ng oza̱. Kang oza̱ i kú ka̱kul nnap mɓá̱ngɓa̱ng opo oza̱. ");
INSERT INTO yer_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","<<Kang a yà pa̱ oza̱ i pwa nnap mɓá̱ngɓa̱ng oza̱ ká̱ nnap mɓá̱ngɓa̱ng opo oza̱, nlang nnandər oza̱ va̱ oza̱ nəm á mi, ká̱ nkak ishi va̱ oza̱ nəm á mi kpa, ");
INSERT INTO yer_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","nva̱ nak mi n pyat oza̱ kpa kang n ɓa ká̱ oza̱ ka̱ ashe mbin okpa ìkum oza̱, te awalang va̱ oza̱ yen ká̱ ishi oza̱ kang à ma̱n ká̱ nnap mɓá̱ngɓa̱ng oza̱, ");
INSERT INTO yer_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","te mi rəng nsar nnap-nlà mi ká̱ uYakup. Mi rəng nsar nnap-nlà mi ká̱ uIshaku kpa ká̱ nsar nnap-nlà mi ká̱ uAbəraham. Mi rəng ká̱ mbin va̱ ta. ");
INSERT INTO yer_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Kang oza̱ i yang ká̱ mbin i re, te i ya njul oga aSati wò nva̱ uza̱ ra ikpələng, kang oza̱ ma̱n ká̱ imwa nnyám ntàn nnap mɓá̱ngɓa̱ng oza̱, ka̱kul oza̱ yang oga nnap mpakpak mi kang oza̱ jan oga nɗyáng mi. ");
INSERT INTO yer_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Káp ká̱ nnà te, ka̱ awalang va̱ oza̱ ka̱ ashe mbin okpa ìkum oza̱ te, mi yang ká̱ oza̱ ka̱t kang mi nzhì oza̱ pa̱ chatchat ka̱t, kang mi ɓəkchi nsar nnap-nlà mi ká̱ oza̱ ka̱t, ka̱kul mmami na uYawe, Inan oza̱. ");
INSERT INTO yer_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ka̱kul oza̱ te, mi rəng ka̱ nsar nnap-nlà va̱ ká̱ opo oza̱, ova n fa ká̱ kà̱ mbin aMasar kà̱ ìwú mbín pa̱ ń yà Inan oza̱. Mmami na uYawe.>> ");
INSERT INTO yer_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Oga nɗyáng, nnap nkpakkpak, ká̱ oga nnap mpakpak va ta̱ uYawe pak kà̱ ìshimshe wò ká̱ oIsa̱rila ka̱ apal aɓam aSinayi ka̱ atak áMusa. ");
INSERT INTO yer_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","UYawe là nnàp ká̱ uMusa pa̱, ");
INSERT INTO yer_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","<<Là nnàp ká̱ oIsa̱rila, là ôza̱ pa̱, a yà pa̱ unəm uro yar nsar nnap-nlà ûYawe pa̱ o na unəm te uza̱ i mwa ishishi ka̱ atak mmak mbwai va̱ ta̱, ");
INSERT INTO yer_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","te mmak iya̱m va̱ ta ka̱ apal ánunggwan, á ɓàn kà̱ ìzun ìsəm pa̱ ìparəm ga chu ìsəm pa̱ ìkpa̱ɗing te, mməmak i yà mbwai ashekel azurfa ìsəm pa̱ ìtukun ka̱ anung ashekel aga Atak Ayə́ryər. ");
INSERT INTO yer_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Kang a yà pa̱ uchar te, mmak mbwai ashekel azurfa i yà ìsəm pa̱ ishatɗing. ");
INSERT INTO yer_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","A yà pa̱ uyen uga ìzun pa̱ ìtukun ga chu ìsəm pa̱ ìparəm te, mmak mbubwai i yà ashekel azurfa ìsəm pa̱ ìparəm ka̱kul ánunggwan kang ashekel azurfa pa̱ gba̱pchi ka̱kul áchar. ");
INSERT INTO yer_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","A yà pa̱ uyen uga ape pa̱ zəng ga chu ìzun pa̱ ìtukun te, mmak mbwai ka̱kul ánunggwan i yà ashekel azurfa pa̱ tukun, kang ka̱kul áchar i yà ashekel azurfa pa̱ shatɗing. ");
INSERT INTO yer_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","A yà pa̱ unəm uga ìzun ìsəm pa̱ ìkpa̱ɗing ka̱t te á jiji te, mmak mbwai i yà ashekel azurfa pa̱ gba̱pchi ama̱n pa̱ tukun ka̱kul ánunggwan, kang ashekel azurfa pa̱ gba̱pchi ka̱kul áchar. ");
INSERT INTO yer_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kang a yà pa̱ unəm va̱ kà̱ nyar nsar nnap-nlà kang à kun ngga nva̱ pa̱ á mwa mbubwai ka̱t te, uza̱ i ɓa ká̱ unəm va̱ ta kà̱ mpyal ànəm uga mpyal awop kang unəm uga mpyal awop ì nak mmak mbubwai ka̱ atak nkàm ànəm uga nyar nsar nnap-nlà. ");
INSERT INTO yer_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","<<A yà pa̱ nyar nsar nnap-nlà ka̱ apal iya̱m nkang va̱ mí yichi wa iya̱m inana ûYawe te, nkpaktak iya̱m va̱ mí na te i yà iji aYawe. ");
INSERT INTO yer_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Uza̱ i ga̱ɓa̱n, ka̱t te i pa̱l ká̱ iro ka̱t, ko inəna̱n ka̱kul iɓá̱ngɓa̱ng, ka̱t te iɓá̱ngɓa̱ng ka̱kul inəna̱n. Kang a yà pa̱ uza̱ i pa̱l iya̱m nkang ká̱ iya̱m nkang, te nkpaktak oza̱, iva̱ mmá pa̱l ká̱ iva̱ mmá pa̱l iwuwan ká̱ i yà iji aYawe. ");
INSERT INTO yer_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","A yà pa̱ nyar nsar nnap-nlà ka̱ apal iya̱m nkang iga adak iva màl pa̱ mmá yichi wa iya̱m inana ûYawe ka̱t, te mmá ga ká̱ iya̱m nkang va̱ ta kà̱ mpyal ànəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Unəm uga mpyal awop i nak mmak mbubwai, ka̱ atak mɓiɓyen ka̱t te mɓəɓa̱ng, wa nva unəm uga mpyal awop nak mbubwai te, i yà wa nnà ta. ");
INSERT INTO yer_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kang a yà pa̱ uza̱ ɗòm mmwa ishíshi te, i nak uzəng ka̱ apal atukun uga mmak mbubwai kà̱. ");
INSERT INTO yer_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","<<A yà pa̱ unəm gòr nzhi wò təm ǹyə́ryər ûYawe, te unəm uga mpyal awop i nak mmak mbubwai, ka̱ atak mɓiɓyen ka̱t te mɓəɓa̱ng, wa nva unəm uga mpyal awop nak te, i yà wa nnà ta. ");
INSERT INTO yer_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kang a yà pa̱ unəm va̱ gar nzhi wò pa̱ ô ka̱m ishíshi te, uza̱ i nak uzəng ka̱ apal atukun uga mmak mbubwai, te i yà njini. ");
INSERT INTO yer_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","<<A yà pa̱ unəm gar ìram ìro va ijini ûYawe te, mmak mbubwai i màl dakdak ká̱ apir aga nsusuk, ka̱ apal mbwai ashekel azurfa ìsəm pa̱ ìtukun ka̱ anung apir ìbəshi kà̱ ìkpáng iga mma iya̱m. ");
INSERT INTO yer_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","A yà pa̱ uza̱ gar ìram va̱ ta kà̱ ìzun iga nfən te, mbubwai i təm wa nva mmá nak. ");
INSERT INTO yer_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Kang a yà pa̱ uza̱ gar ìram va̱ ta kà̱ nva̱ng ìzun iga nfən, te unəm uga mpyal awop i kung mmak mbubwai i màl dakdak ká̱ oga izun va̱ ɓur i ga i chu ìzun iga nfən, kang mí kpa̱k i le. ");
INSERT INTO yer_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","A yà pa̱ unəm va̱ gar ìram va̱ ta á wong ɗòm pa̱ ômwa ishíshi te, uza̱ i nak uzəng ka̱ apal atukun uga mmak mbubwai, te ìram va̱ ta i le i yà ìjini. ");
INSERT INTO yer_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Kang a yà pa̱ uza̱ mwa ishi ìram va̱ ta ka̱t, uza̱ yáp ká̱ ûnəm uro te, mí mwa ishíshi lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","A yà pa̱ mmá le ká̱ ìram va̱ ta kà̱ ìzun iga nfən te, i yà iji aYawe, i təm iji onəm oga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","<<A yà pa̱ unəm gar ìram ûYawe ìva uza̱ yiyáp ka̱ ashe mpupwom ka̱t, ");
INSERT INTO yer_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","te unəm uga mpyal awop i kung mbubwai á na i ga i chu ìzun iga nfən, kang unəm va̱ ta i mwa mbwai n̂da va ta mbwai va̱ ta nji aYawe. ");
INSERT INTO yer_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Kà̱ ìzun iga nfən te ìram i le i yà ìji ànəm va uza̱ yáp ka̱ atətak, uva̱ ka̱ yà upo ìram á. ");
INSERT INTO yer_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Nkpaktak oga nnak mmak amwa ɓu á màl ká̱ ashekel aga atak awop, agera ìsəm pa̱ ìparəm ka̱ anung ashekel. ");
INSERT INTO yer_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","<<Kang unəm uro a gar amar aga nggəshi ûYawe aga iya̱m nkang, ka̱ ashe ina ka̱t te itam ka̱t, ka̱kul amar aga nggəshi yà chit aji aYawe. ");
INSERT INTO yer_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kang a yà pa̱ izəngtəng ka̱ ashe iya̱m nkang iga adak te, uza̱ i mwa ishíshi wa mmak nnak mbubwai ka̱ atak nnak uzəng ka̱ apal atukun uga mmak mbubwai. A yà pa̱ mmá mwa ishíshi ka̱t te, mí yáp ká̱ ka̱ apal mmak mbubwai. ");
INSERT INTO yer_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","<<Ká̱ nnà te, iya̱m iro yà iva mí yáp ká̱ ka̱t, iva unəm gar chit mbyet ûYawe ka̱ ashe nkpaktak iya̱m va̱ ijini. Unəmləbər ka̱t te iya̱m nkang, ka̱t te mpom, mí mwa ishíshi ka̱t te mí yáp ká̱ ka̱t. Nkpaktak iya̱m va̱ mmá gar te i yà inəna̱n iji aYawe. ");
INSERT INTO yer_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","<<Unəmləbər uro yà uva̱ mmá gar chit ka̱kul nzhì mí mwa ishíshi ka̱t, mí gba̱l na. ");
INSERT INTO yer_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","<<Nza̱ uzəng ka̱ ashe agba̱pchi nggo iga iya̱m-nrì wó iga ashe iram, ìpir ìkùr kà̱ mbin ka̱t te awár ikún te, iji aYawe. ");
INSERT INTO yer_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","A yà pa̱ unəm ɗòm pa̱ ô mwa ishi uzəng ka̱ ashe agba̱pchi wò uro, te uza̱ i nak uzəng ka̱ apal atukun uga mməmak kà̱. ");
INSERT INTO yer_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Nza̱ uzəng ka̱ apal agba̱pchi iya̱m nkang nggo te, ija aYawe. Awalang va̱ mmá kung iya̱m nkang te, iga igba̱pchi iji aYawe. ");
INSERT INTO yer_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Uza̱ i yà ka̱ ndədər pa̱ ô va̱n iɓyenɓyen ká̱ ìɓá̱ngɓa̱ng ka̱t, kang uza̱ i yà ká̱ mpəpa̱l ka̱t. A yà pa̱ uza̱ i pa̱l te, iva̱ mmá pa̱l ká̱ iva̱ mmá pa̱l iwuwan ká̱ i yà iji aYawe, mí mwa ishishi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Oga nnap mpakpak va ta̱ uYawe nak ûMusa ka̱kul oIsa̱rila ka̱ apal aɓam aSinayi.");
INSERT INTO yer_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Kà̱ nva̱ng ikú aMusa uzwal aYawe te, uYawe là nnap ká̱ uJoshuwa uya aNun ununggwan, uva i ka̱mshi ûMusa. ");
INSERT INTO yer_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","Uza̱ là a na pa̱, <<Uzwal mi uMusa kú chit. Ǹyangmata̱ te, mmaɓu ká̱ nkpaktak onəm a ta̱, o gbar izər na o pa̱ng Awang aUrdun na o ga ashe mbin va̱ mmami ka̱ ngga na wó, oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Nkpaktak atak va̱ ashe ashar wó i tongchi te, mi na wó, wa nva ka̱ n yar nsar nnap-nlà ûMusa á. ");
INSERT INTO yer_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Aswari wó i ɓan ka̱ nzam mmaləng i ga aLebanon, kang i ɓan ka̱ awang achumchum, awang aYufriti, ká̱ nkpaktak mbin oHiti, i ga i chu ìWa aMeditereniya ka̱ asa̱l ntar alum. ");
INSERT INTO yer_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Unəm uro i kur nnəm igwan ka̱ apal ishi ɓu ka̱t, ka̱ ashe nkpaktak nra irirì ɓu. Wa nva ka̱ n yà nzəng ká̱ uMusa te, wa nnà ta kpa mi yà nzəng ká̱ ɓu. Mi yà ka̱ mmandar ɓu, ka̱t te mi re ɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Sat pa̱ kakkərak, nəm nkam igwak, ka̱kul ɓu ga nləp mpyal onəm va̱ ta̱, na á ka̱m mbin va̱ ka̱ n sóng anung ôkəka oza̱ pa̱ mi na ôza̱ á. ");
INSERT INTO yer_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","<<Sat pa̱ kakkərak, nəm nkam igwak pa̱ gənggəng. Nəm pa̱ dakdak na u kpak nkpaktak nnap-mpakpak va̱ uzwal mi uMusa nak a ɓu. Kang wa ga̱ɓa̱n nri ka̱t te mpəra̱m ka̱ pəpal ka̱t, na u nəm igwan nkpaktak atak va̱ ɓu ga kà̱. ");
INSERT INTO yer_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Kang nlir ngga nnap-mpakpak va̱ ta̱ a kap ka̱ anung ɓu ka̱t. Rəng nnap ka̱ pəpal ìzwam ka̱ alum pa̱ ɗəkər, na u nəm nkpaktak iya̱m va̱ mmá lir ka̱ ashishe. Nna chit te, ɓu ya ngga mpyal ká̱ igwan pa̱ makmak. ");
INSERT INTO yer_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Rəng, ka̱ n nak ɓu chit pa̱ u sat pa̱ kakkərak, u nəm nkam igwak. Kang ayər a nəm ɓu ka̱t, kang izər a rusok ka̱ ɓu ka̱t, ka̱kul uYawe Inan ɓu i yà nzəng ká̱ ɓu kà̱ nkpaktak atak va̱ ɓu ga kà̱.>> ");
INSERT INTO yer_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Te uJoshuwa nak onəm oga mpyal onəm pa̱, ");
INSERT INTO yer_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","<<A ga ashe apa̱k, na a là ônəm pa̱, <Ó ɗa̱mshi iya̱m-nrì wó ka̱kul ka̱ nva̱ng nra pa̱ nshatɗing te, ó ga mpa̱ng awang aUrdun, na ó ka̱m mbin va̱ uYawe Inan wó ka̱ nna a wó.> >> ");
INSERT INTO yer_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Ǹnyi te, uJoshuwa là âkum ìjili aRuben, ká̱ uGat ká̱ nkap kà̱ ishimshe akum ìjili aManase pa̱, ");
INSERT INTO yer_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","<<Ó rəng nnap-nlà aMusa uzwal aYawe va̱ nak a wó, ka̱ là pa̱, <UYawe Inan wó i ga nna njul a wó ka̱ atak nna mbin va̱ ta̱ a wó.> ");
INSERT INTO yer_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Ochar wó, ká̱ ovan wó, ká̱ oga iya̱mkang wó, i təm ka̱ ashe mbin va uMusa na wó chit ka̱ asa̱l nfa alum Awang aUrdun á, ǹnyi te, nkpaktak onəm oga nyi ashar ìkum wó okamkam va̱ gbar izər ikum te, nkpak oza̱ i pa̱ng mpyal ogənang oza̱ na oza̱ a ka̱mshi ôza̱ ka̱ atak ikum. ");
INSERT INTO yer_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Oza̱ i ka̱m ishi oza̱ i ga i chu awalang va̱ uYawe i na njul ogənang oza̱, wa nva̱ uza̱ ka̱ nəm a wó, kang oza̱ i ka̱m mbin va̱ nji oza̱ kpa, nva uYawe Inan wó ka̱ nna oza̱. Nna chit te, ó le ó ga ó təm ka̱ mbin wó va̱ uMusa uzwal aYawe ka̱ na wó ka̱ gwong Awang aUrdun va̱ dər asa̱l nfa alum.>> ");
INSERT INTO yer_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Te oza̱ na ama̱n ûJoshuwa pa̱, << Iya̱m va pa̱ kap u nak á yi te, i nənəm. Atak va pa̱ kap ɓu re yi kà̱ te, i gəga. ");
INSERT INTO yer_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Wa nva i kpak nnap nnəm uMusa te, wa nnà ta i kpak a ɓu kpa. Ǹnyi te, re uYawe Inan ɓu a ya nzəng ka̱ ɓu, wa nva uza̱ ka̱ ya nzəng ká̱ uMusa á. ");
INSERT INTO yer_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Unəm va pa̱ kap fa iya̱mkak ka̱ nnap-nlà ngga anung ɓu kang a yang ka̱ nkpak nkpaktak iya̱m va̱ u nak oza̱ pa̱ a nəm te, mí gba̱l na. Ǹnyi te, sat pa̱ kakkərak, igwak á kam a ɓu.>> ");
INSERT INTO yer_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","UJoshuwa uya aNun re nre ká̱ onəm oga nsòng mbin ká̱ ayi pa̱ oparəm ka̱ aShitim. Uza̱ là ôza̱ pa̱, <<Ó ga na ó sòng mbin va̱ ta jwakjwak aJariko.>> Te oza̱ ga tar ashe nzhi achar umaimai uro, aɗiɗin pa̱ uRahap, kang oza̱ ra ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Te mma là ûponzhi uga aJariko pa̱, <<Dər, onəm oga aIsa̱rila oro mma táng ka̱ ashe ìtong va̱ ta̱ ka̱ ìzwam pa̱ na ó sòng mbin va̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Te uponzhi uga aJariko re nre ga atak aRahap pa̱, <<Fa ká̱ onungwan va̱ ɓa atak ɓu kang oza̱ táng nzhi ɓu, ka̱kul oza̱ ɓa nsòng nkpaktak mbin yi.>> ");
INSERT INTO yer_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Ǹnyi te, uchar va̱ ta ka̱ bwam onunggwan oga oparəm va̱ ta chit. Uza̱ là pa̱, <<À, onunggwan va̱ ta ɓa atak mi ɓa, ǹnyi te, n nyi atak va̱ oza̱ fa kà̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Kang mí kùk anung asa̱l ìtong ká̱ anung arurong te, onunggwan va̱ ta fa chit. N nyi asa̱l va̱ oza̱ wòl kà̱ ka̱t. Ó ga ká̱ nggha̱n ka̱ nva̱ng oza̱, mwote, ó ɓan oza̱ nggo.>> ");
INSERT INTO yer_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Ǹnyi te, uza̱ ka̱ ga ká̱ oza̱ chit ka̱ apal nzhi, uza̱ bwam oza̱ ka̱ akum akun ǹsàmsam va uza̱ ka̱ nak ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Te onunggwan va̱ ta fa wa nva̱ng onəm oga nsòng mbin, i mwo oza̱ ga chu asa̱l aga mpa̱l Awang aUrdun. Ká̱ nfa onəm va̱ ta byet te, mma kùk anung asa̱l. ");
INSERT INTO yer_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Kang onəm oga nsòng mbin va̱ ta ì ra nda te, uRahap ga ka̱ atak oza̱ ka̱ apal nzhi va̱ ta, ");
INSERT INTO yer_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","uza̱ là oza̱ pa̱, <<N nyinyi pa̱ uYawe na mbin va̱ ta̱ a wo chit, kang ayər wó nəm yi chit, nkpaktak onəm ka̱ ashe mbin va̱ ta̱ ìchəgwak la̱p oza̱ pa gənggəng ka̱kul wó. ");
INSERT INTO yer_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","I fe iya̱m va̱ chit uYawe nəm, á nak ndəng ngga ìWa Isəksək wom ka̱kul wó awalang va̱ ó fa ka̱ aMasar á, ká̱ nkpaktak iya̱m va̱ ó nəm ûSihon ká̱ uOk, oponzhi oga oparəm oga aAmori ova ka̱ asa̱l nfa alum aUrdun, ova ó zhì oza̱ pa̱ kpaktak. ");
INSERT INTO yer_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Awalang va̱ í fe te, ìchəgwak la̱p yi, ayər nəm yi ka̱kul wó kang unəm uro ka̱ ashe yi yà ká̱ nkam igwak lap ka̱t. Ka̱kul uYawe Inan wó, uza̱ Inan ka̱ apaɓur ká̱ apambin. ");
INSERT INTO yer_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","<<Ǹyangmata̱ te, ó sóng anung á mi ka̱ ashe aɗin aYawe pa̱, wa nva n nəm ikin a wó te, wa nnà ta kpa, ó nəm n̂zhi apo mi. Ó nyám ìpir nnàp á mi va̱ i nak mi na nnandər ká̱ wó, ");
INSERT INTO yer_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","pa̱ ó re upo mi, ká̱ unang mi, ká̱ ogənang mi onunggwan, ká̱ ogənang mi ochar ká̱ irirì, ká̱ nkpaktak onəm va̱ oji oza̱. Kang ó re yi i kú ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Te onəm va̱ ta là ûRahap pa̱, <<Irirì yi ka̱ anung irirì ɓu, a yà pa̱ u fa ká̱ ìjili yi kà̱ nnap va̱ ta̱ ka̱t, te i nəm iya̱m inəna̱n a ɓu ká̱ nnandər awalang va̱ uYawe á na mbin va̱ ta̱ á yi chit á.>> ");
INSERT INTO yer_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Nna chit te, uRahap fər ká̱ oza̱ ká̱ asang ka̱ mɓol ayir nzhi, ka̱kul mmá me nzhizhi ka̱ izər akamsəlang ìtong. ");
INSERT INTO yer_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Te uza̱ là ôza̱ pa̱, <<Ó ga ka̱ ashe oga aɗuktum le kang onəm oga ngwa nva̱ng wó a ya wó ka̱t. Ó bwam ka̱ ta nra pa̱ nshatɗing, nva̱ngva̱ onəm oga ngwa nva̱ng wó a le chit, te ó kpán asa̱l wó ɗak.>> ");
INSERT INTO yer_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Te onəm va̱ ta là ûRahap pa̱, <<Nsóng anung va̱ u nak yi i sóng te, i təm wa nnà ta. ");
INSERT INTO yer_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Iya̱m va ta̱ ɓu nəm awalang va̱ i táng ashe mbin va̱ ta̱. Te wa ran afini arəzang va̱ ta̱ ka̱ mɓol ayir nzhi va̱ u re yi i fəng kà̱. Wa ɓa ká̱ upo ɓu, ká̱ unang ɓu, ká̱ ogənang ɓu onunggwan, ká̱ nkpaktak nzhi oza̱ ka̱ nzhi ɓu. ");
INSERT INTO yer_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","A yà pa̱ unəm uro a fa agbai anung nzhi ɓu te, nchə̀r oza̱ i təm ka̱ apal ishishi, í yà ká̱ mpat ka̱t. Ǹnyi te, a yà pa̱ mma nak awo ûnəm uro uva uwa yà nzəng ka̱ ɓu ka̱ ashe nzhi te, nchə̀r oza̱ i təm ka̱ apal ishi yi. ");
INSERT INTO yer_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Ǹnyi te, a yà pa̱ u là ûnəm uro iya̱m va̱ ɓa ká̱ yi, te nsóng anung va̱ u nak yi i sóng te, i kpán yi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","URahap na ama̱n pa̱, <<Re á təm wa nva ó là.>> Te uza̱ re oza̱, kang oza̱ kpán asa̱l ga. Kà̱ nva̱ngva̱ oza̱ ga chit, te uza̱ ran afini arəzang ka̱ mɓol ayir nzhi va̱. ");
INSERT INTO yer_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Awalang va̱ oza̱ fa te, oza̱ ga ashe oga aɗuktum kang oza̱ təm ka̱ ta nra pa̱ nshatɗing, ga chu awalang va̱ onəm oga ngwa nva̱ng mwo oga atak pa̱ kpaktak ka̱ apal asa̱l, kang oza̱ ya oza̱ ka̱t, oza̱ le pa. ");
INSERT INTO yer_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Te onunggwan oga oparəm va̱ ta̱ fəng ka̱ apal oga aɗuktum, pa̱ng awang le ga atak aJoshuwa uya aNun ununggwan, kang oza̱ là á na nkpaktak iya̱m va̱ ya oza̱. ");
INSERT INTO yer_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Oza̱ là ûJoshuwa pa̱, <<Nnandər, uYawe na nkpaktak mbin va̱ ta chit, ka̱ ashe awo yi. Nkpaktak onəm oga mbin va̱ ta ka̱ ntán ká̱ ayər ka̱kul yi.>> ");
INSERT INTO yer_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Ìpin fa kpa̱k ká̱ iɓotak te, uJoshuwa ká̱ nkpaktak oIsa̱rila wong achen ka̱ aShitim kang oza̱ ga aUrdun, ka̱ ta na oza̱ ra apa̱k kang oza̱ wong pa̱ng awang va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Ka̱ nva̱ng nra pa̱ nshatɗing te, onəm oga mpyal onəm ga ashe nkpaktak apa̱k, ");
INSERT INTO yer_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","kang oza̱ nak onəm pa̱, << Awalang va̱ ó ya akwati aga nsar nnap-nlà aYawe Inan wó kang onəm oga mpyal awop oLawi á yar te, ó wong ka̱ atak va̱ mmawó kà̱, ó yar nvəva̱ng. ");
INSERT INTO yer_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Ó re ishimshe wó a gbəgba̱ng ká̱ akwati aga nsar nnap-nlà va̱ ta, ngbəgba̱ng a yà ashar ìkalong pa̱ ishatɗing. Kang ó ɓa datkulung ká̱ ka̱t, te i nak ó nyi asa̱l va̱ ó ga ngwol kà̱, ka̱kul pa̱ nna ka̱ ó wòl asa̱l ata̱ chit ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Te uJoshuwa là ônəm pa̱, <<Ó gar ishi wó ka̱kul ìpin te, uYawe i ga nnəm iya̱m iga nnəm ayər ká̱ ishimshe wó.>> ");
INSERT INTO yer_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Kang uJoshuwa là ônəm oga mpyal awop pa̱, <<Ó yar akwati aga nsar nnap-nlà na ó lyam ká̱ ka̱ mpyal onəm.>> Te oza̱ yar akwati aga nsar nnap-nlà va̱ ta, oza̱ lyam ká̱ ka̱ mpyal onəm. ");
INSERT INTO yer_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Te uYawe là ûJoshuwa pa̱, <<Ka̱ nda va̱ ta̱ mi ga nrup ká̱ ɓu ka̱ mpyal nkpaktak oIsa̱rila, ka̱kul na oza̱ á nyi pa̱, wa nva ka̱ n yà nzəng ká̱ uMusa te, wa nnà ta kpa, mi yà nzəng ká̱ ɓu. ");
INSERT INTO yer_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Nak onəm oga mpyal awop ova̱ yar akwati aga nsar nnap-nlà pa̱, <Awalang va̱ ó táng ka̱ arwangchwang ndəng aUrdun te, ó tong pa̱ kwák ka̱ ta.> >> ");
INSERT INTO yer_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Te uJoshuwa là ôIsa̱rila pa̱, <<Ó ɓa datkulung na ó fe nnap-nlà aYawe Inan wó. ");
INSERT INTO yer_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Wa nnà ta̱ ó nyi ɗak pa̱, Inan iga irirì wa ká̱ ìshimshe wó, te i mai ka̱t uza̱ i ga mɓak oKanana, ká̱ oHiti, ká̱ oHivi, ká̱ oPerizi, ká̱ oGirgashi, ká̱ oAmori, ká̱ oJebusi i le ka̱ mpyal wó. ");
INSERT INTO yer_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Dər, akwati aga nsar nnap-nlà Inan uga nkpaktak apambin ka̱ nlyam ka̱ mpyal wó ka̱ ashe awang aUrdun. ");
INSERT INTO yer_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Ǹyangmata̱ te, yak onunggwan pa̱ ogba̱pchi ama̱n pa̱ aparəm ka̱ ashe akum ìjili oIsa̱rila. Unəm pa̱ uzəng ka̱ ashe nza̱ akum ìjili nggo. ");
INSERT INTO yer_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Kang awalang va̱ ndong ashar onəm oga mpyal awop ova̱ yar akwati aga nsar nnap-nlà aYawe, unəm uga nzhi nkpaktak apambin, á táng ka̱ ashe ndəng aUrdun te, ndəng aUrdun va̱ ta i gəl. Kang ndəng va̱ ka̱ yà ka̱ nnang te, i ɓut ka̱ atak pa̱ zəng.>> ");
INSERT INTO yer_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Kang awalang va̱ onəm fa ka̱ ashe oga aghal pa̱ na ó pa̱ng Awang aUrdun te, onəm oga mpyal awop va̱ yar akwati aga nsar nnap-nlà ləp mpyal ôza̱. ");
INSERT INTO yer_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Ka̱ awalang aga mɓən iya̱m na ndəng i yəl Awang aUrdun ká̱. Awalang va̱ onəm oga mpyal awop chu arwangchwang ndəng kang á táng ka̱ ashishe te, ");
INSERT INTO yer_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ndəng va̱ ta re nnang. Ndəng va̱ ta ɓut atak pa̱ zəng nəm aɗuktum, gba̱ng ká̱ awang, ka̱ ìtong va mi wor pa̱ aAdam dat ká̱ aZaretan. Ndəng va̱ ta re nnang ngga ka̱ ashe ìWa Mman. Ǹna chit te, onəm pa̱ng awang va̱ dat ká̱ aJariko. ");
INSERT INTO yer_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Te onəm oga mpyal awop va̱ yar akwati aga nsar nnap-nlà aYawe tong ka̱ mbin ngwomwom ka̱ ishimshe Awang aUrdun va̱ ta. Kang nkpaktak oIsa̱rila pa̱ng ka̱ mbin ngwomwom ga chu awalang va̱ nkpaktak onəm pa̱ng aUrdun ká̱ á. ");
INSERT INTO yer_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Ka̱ nva̱ngva̱ nkpaktak onəm pa̱ng aUrdun chit kur te, uYawe là ûJoshuwa pa̱, ");
INSERT INTO yer_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","<<Yak onunggwan pa̱ ogba̱pchi ama̱n pa̱ aparəm, yar pa̱ uzəng ka̱ ashe nza̱ akum ìjili nggo, ");
INSERT INTO yer_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","te là ôza̱ pa̱, ó wur ipáng pa̱ igba̱pchi ama̱n pa̱ aparəm ká̱ ishimshe aUrdun va̱ ta̱, dakdak ka̱ atak va̱ onəm oga mpyal awop tong kà̱, te oza̱ á ɓa ka̱ ipáng va̱ ta á nak ka̱ atak va̱ ó ga nra ka̱ nda ta̱.>> ");
INSERT INTO yer_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Te uJoshuwa wór onunggwan oga ogba̱pchi ama̱n pa̱ aparəm va̱ uza̱ yak, unəm pa̱ uzəng ka̱ ashe nza̱ akum ìjili nggo. ");
INSERT INTO yer_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","Kang uza̱ là ôza̱ pa̱, <<Ó lyam ka̱ mpyal akwati aYawe Inan wó, ó ga ishimshe aUrdun, kang nza̱ uzəngtəng wó nggo á yar ìpang ka̱ agar wò, kà̱ iyil akum ìjili oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Nna ta i yà iya̱m iga ǹnyám ìpir nnàp ka̱ ashe wó. Ka̱ ilum iga mɓa, awalang va̱ ovan wó i ɓəp wó pa̱ iza̱ ipir ipáng va̱ ta̱ ka̱ atak wó yà? ");
INSERT INTO yer_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Te ó là ôza̱ pa̱, ka̱kul pa̱ mmá gəl ndəng Awang aUrdun kà̱ nnang ka̱ awalang va̱ onəm oga mpyal awop yar akwati aga nsar nnap-nlà aYawe pa̱ng aUrdun ká̱. Ipáng va̱ ta̱ te, i sat iya̱m iga nrəng ká̱ oIsa̱rila mbyet.>> ");
INSERT INTO yer_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Te onəm oIsa̱rila nəm wa nva uJoshuwa nak oza̱. Oza̱ wur ipáng pa̱ igba̱pchi ama̱n pa̱ parəm ka̱ ishimshe aUrdun. A mal ka̱ iyil akum ìjili oIsa̱rila, wa nva uYawe là ûJoshuwa. Kang oza̱ wur pa̱ng ká̱, ga ká̱ ka̱ atak va̱ oza̱ ra kà̱, te oza̱ nak ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Te uJoshuwa dàt ipáng iga igba̱pchi ama̱n pa̱ parəm va̱ ta ka̱ ishimshe aUrdun, ka̱ atak va̱ ashar onəm oga mpyal awop va̱ yar akwati aga nsar nnap-nlà tong kà̱. Kang nna yà ka̱ ta ɓa chu nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Onəm oga mpyal awop va̱ yar akwati aga nsar nnap-nlà, tong ka̱ ishimshe aUrdun, a ga chu awalang va̱ mmá gba̱l ka̱ nkpaktak iya̱m va̱ uYawe nak uJoshuwa pa̱ á là ônəm, wa nva̱ uMusa nak uJoshuwa. Te onəm wong ka̱ ashe ǹngha̱n pa̱ng aUrdun, ");
INSERT INTO yer_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","ka̱ nva̱ngva̱ nkpaktak onəm gba̱l ka̱ mpa̱ng awang chit te, akwati aYawe ká̱ onəm oga mpyal awop lyam ka̱ mpyal onəm. ");
INSERT INTO yer_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Onəm oga nlung ìkum ka̱ akum ìjili aRuben, ká̱ akum ìjili aGat, ká̱ nkap ishimshe akum ìjili aManase gbar izər ìkum pa̱ng ka̱ mpyal oIsa̱rila, wa nva uMusa là ôza̱. ");
INSERT INTO yer_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Onəm oga nlung ìkum chu ìkalong chu ìsəm pa̱ ineɗing ova̱ pa̱ng ka̱ mpyal akwati aga nsar nnap-nlà aYawe pa̱ ó lung ìkum ka̱ ashe agbagba aJariko. ");
INSERT INTO yer_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Ka̱ nda va̱ ta te, uYawe rup ká̱ uJoshuwa ka̱ mpyal nkpaktak oIsa̱rila. Kang oza̱ na ichumchum a na mbyet, wa nva oza̱ ka̱ na ûMusa ka̱ ashe nkpaktak nra irirìriri á. ");
INSERT INTO yer_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Te uYawe là ûJoshuwa pa̱, ");
INSERT INTO yer_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","<<Nak onəm oga mpyal awop, ova yar akwati aga nsar nnap-nlà pa̱, oza̱ á fa ka̱ ashe aUrdun.>> ");
INSERT INTO yer_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Te uJoshuwa nak onəm oga mpyal awop pa̱, <<Ó fa ka̱ ashe aUrdun.>> ");
INSERT INTO yer_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Kang awalang va̱ onəm oga mpyal awop va̱ yar akwati aga nsar nnap-nlà aYawe fa ká̱ ishimshe aUrdun te, oza̱ chen ka̱ mbin ngwomwom. Kang ndəng aUrdun le nang yəl awang wa nva̱ ka̱ yà á. ");
INSERT INTO yer_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Onəm fa ka̱ ashe aUrdun ka̱ nra ngga ngba̱pchi ngga ape aga nggəshi, te oza̱ la̱p apa̱k ka̱ aGilgal ka̱ asa̱l nfa alum aswari aJariko. ");
INSERT INTO yer_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Kang ipáng iga igba̱pchi ama̱n pa̱ parəm va̱ oza̱ ka̱ wur ka̱ ashe aUrdun te, uJoshuwa dàt ka̱ aGilgal. ");
INSERT INTO yer_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Te uza̱ là ôIsa̱rila pa̱, <<A yà pa̱ ka̱ ashe nra ngga mɓa, kang ovan wó a ɓəp opo oza̱ pa̱, <Iza̱ ipir ipáng va̱ ta̱ yà?> ");
INSERT INTO yer_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Te ó là ôza̱ pa̱, <OIsa̱rila pa̱ng aUrdun kà̱ mbin ngwomwom.> ");
INSERT INTO yer_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Ka̱kul uYawe Inan wó nak ndəng ngga aUrdun wom ka̱kul wó, a ga chu awalang va̱ ó pa̱ng, wa nva uYawe Inan wó nak Ìwa Isəksək wom ka̱kul wó a ga chu awalang va̱ i pa̱ng ka̱ á. ");
INSERT INTO yer_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Uza̱ nəm i va̱ ta̱ ka̱kul pa̱ na nkpaktak onəm oga apambin á nyi pa̱ ichumchum nna ka̱ awo aYawe, na ó nəm ayər aYawe Inan wó mbyet.>> ");
INSERT INTO yer_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Awalang va̱ nkpaktak oponzhi oAmori ovəngva̱ ka̱ asa̱l ntar alum aUrdun, ká̱ nkpaktak oponzhi oKanana va̱ ka̱ anung ìwa fe chit pa̱, uYawe nak ndəng Awang aUrdun wom ka̱kul oIsa̱rila, a ga chu awalang va̱ oza̱ pa̱ng ká̱ te, ìchəgwak la̱p oza̱ kang ayər nəm oza̱ ka̱kul oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Ka̱ awalang va̱ ta te, uYawe là ûJoshuwa pa̱, <<Nəm ikpal iga ipáng na ú pà ache ôIsa̱rila onunggwan ká̱ kà̱ɗi.>> ");
INSERT INTO yer_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Te uJoshuwa nəm ikpal iga ipáng kang uza̱ pà ache ôIsa̱rila ka̱ Gibiyat Haralot. ");
INSERT INTO yer_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Iya̱m va̱ nak kang uJoshuwa pà ache oza̱ te, ka̱kul pa̱ nkpaktak onunggwan ká̱ onunggwan oga nlung ìkum va̱ fa ka̱ ashe aMasar te, a kú chit pa̱ kpaktak ka̱ ashe nzam. ");
INSERT INTO yer_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Nkpaktak onəm va̱ fa ka̱ ashe aMasar te, mmá pà ache pà oza̱, ǹnyi te, ovəngva̱ mmá mar ya oma ka̱ yà ka̱ apal asa̱l ka̱ ashe nzam te, mmá pà ache ôza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Ka̱kul onəm oIsa̱rila nəm ìzun ìsəm pa̱ ineɗing oma ka̱ nchèn ka̱ ashe nzam, a ga chu awalang va̱ nkpaktak onəm ká̱ onunggwan oga nlung ìkum va̱ fa ka̱ ashe aMasar á zhì, ka̱kul pa̱ oza̱ fe ichu aYawe ka̱t. Te uYawe sóng anung ôza̱ chit pa̱, oza̱ i yà ka̱ ya mbin va̱ ò yar nsar nnap-nlà okəka oza̱ pa̱ ò na oza̱ ka̱t. Mbin va mbyal ká̱ irizhe i nang ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Ovan oza̱ va̱ uYawe nak ka̱ anung oza̱ te, oma uJoshuwa pà ache ôza̱. Ka̱kul pa̱ mmá mar oza̱ ka̱ apal asa̱l, te nna mmá ka̱ pà ache ôza̱ chit ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Ka̱ nva̱ngva̱ mmá gba̱l ka̱ mpà ache ônunggwan va̱ ta chit pa̱ kpaktak te, oza̱ təm ka̱ atak oza̱ ka̱ ashe apa̱k a ga chu awalang va̱ oza̱ tàn kang. ");
INSERT INTO yer_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Te uYawe là ûJoshuwa pa̱, <<Nda ta̱ n tutur mpwat oga aMasar le a wó chit ka̱ ishi.>> Ka̱kul nva̱ ta te, nda ta̱ aɗin atak va̱ ta nna mmá kà̱ nwór pa̱ aGilgal. ");
INSERT INTO yer_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Nva̱ onəm oIsa̱rila la̱p apa̱k ka̱ aGilgal te, oza̱ ri iya̱m-nrì iga nrəng ka̱ ilum Nggantal kà̱ nra ngga ngba̱pchi ama̱n pa̱ neɗing ngga ape va̱ ta ká̱ arurong ka̱ agbagba aJariko. ");
INSERT INTO yer_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Ìpin fa kpa̱k ka̱ nva̱ng ilum Nggantal te, ka̱ nda va̱ ta oza̱ ri iya̱m-nrì iga ashe mbin va̱ ta, nzəngkəng va yà ká̱ anyer ka̱t ká̱ ìpirkur iforfor. ");
INSERT INTO yer_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Ká̱ nda va̱ oza̱ ri iya̱m-nrì iga mbin va̱ ta kang ìpin fa kpa̱k te, aMana gəl. OIsa̱rila ya aMana a ta lap ka̱t, te oza̱ ɓan nrì iya̱m-nrì iga mbin aKanana kà̱ ìzun va ta. ");
INSERT INTO yer_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Ka̱ awalang va̱ uJoshuwa ɓa dat ká̱ aJariko te, uza̱ wong ká̱ iwu wò dər te, uza̱ ya unəm sat ka̱ mpyal wò, á tur ndokchi ka̱ awo. Te uJoshuwa ga atətak á ɓəp na pa̱, <<Mmaɓu uji yi, ka̱t te mmaɓu ukpa ìkum yi ɗò?>> ");
INSERT INTO yer_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Te unəm va̱ ta na a ma̱n pa̱, <<Mmami uji wó ka̱t, kang mmami ukpa ikum wo ka̱t kpa. Ǹnyi te, mmami unəm uga mpyal ìkum aYawe. Kang ǹyangmata̱ na m ɓa.>> Te uJoshuwa ru zəp ka̱ afu ka̱ mbin á na ichumchum á na, kang uza̱ ɓəp na pa̱, <<Iza̱ u ɗom pa̱ uzwal ɓu a nəm yà? ANəm uga nzhi mi.>> ");
INSERT INTO yer_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Te unəm uga mpyal ìkum aYawe là ûJoshuwa pa̱, <<Zəp akwap va̱ ka̱ ashar ɓu, ka̱kul atak va̱ mmaɓu ka̱ nsat ka̱ ta te, atak ayə́ryər.>> Te wa nnà ta uJoshuwa nəm. ");
INSERT INTO yer_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Mmá kùk anung asa̱l aJariko ashe ká̱ agbai ka̱kul onəm oIsa̱rila. Unəm uro yà ká̱ nfa ka̱t, kang unəm uro yà ká̱ ntar ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Te uYawe là ûJoshuwa pa̱, <<Dər, n na aJariko chit ka̱ ashe awo ɓu, ká̱ uponzhiponzhi, ká̱ onəm oga nlung ìkukum. ");
INSERT INTO yer_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Mmaɓu ká̱ nkpaktak onəm oga nlung ìkum ɓu, ó chen ó gáng ìtong va̱ ta̱ nva̱ng pa̱ nzəng. Ó nəm wa nnà ta i ga i chu nra pa̱ nkpa̱ɗing. ");
INSERT INTO yer_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Te onəm oga mpyal awop pa̱ ofangshat, i kpán oga agbəshi inagam ka̱ mpyal akwati aga nsar nnap-nlà. Ka̱ nra ngga nfangshat te, ó chen ó gang ìtong va̱ ta̱ nva̱ng pa̱ nfangshat, kang onəm oga mpyal awop i yà kà̱ mɓur oga agbəshi va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Ka̱ nva̱ngva̱ ó fe oza̱ ɓur oga agbəshi chit yar awalang te, nkpaktak onəm i bà achu ká̱ ìkam, te akamsəlang ìtong va̱ ta i shin. Kang onəm i táng ashe ìtong, nza̱ unəm nggo i kpán mpyal wò.>> ");
INSERT INTO yer_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Te uJoshuwa uya aNun ununggwan ɓut onəm oga mpyal awop kang a là ôza̱ pa̱, <<Ó yar akwati aga nsar nnap-nlà aYawe, ǹnyi te, onəm oga mpyal awop oro pa̱ ofangshat a wur oga agbəshi a ləp mpyal ká̱.>> ");
INSERT INTO yer_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Te uza̱ là ôshozha pa̱, <<Ó lyam ó chen ó gáng ìtong va̱ ta, kang onəm va̱ ká̱ iya̱m ìkum te, oza̱ á lyam kà̱ mpyal akwati aga nsar nnap-nlà aYawe va̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Ka̱ nva̱ngva̱ uJoshuwa là nnap ka̱ ônəm chit, te onəm oga mpyal awop va̱ pa̱ ofangshat va̱ wur oga agbəshi pa̱ fangshat ka̱ mpyal aYawe watar mpyal ká̱ i ɓur, kang akwati aga nsar nnap-nlà aYawe ka̱ nyar nva̱ng oza̱. ");
INSERT INTO yer_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Onəm oga iya̱m ikum ka̱ nchen ka̱ mpyal onəm oga mpyal awop ova̱ ka̱ mɓur oga agbəshi, kang onəm oga mpángchí nva̱ng ka̱ mɓa ka̱ nva̱ng akwati. Ka̱ ashe nkpaktak oga awalang va̱ ta te, mmá pak inok mɓur oga agbəshi. ");
INSERT INTO yer_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Ǹnyi te, uJoshuwa ka̱ nak oshozha chit pa̱, <<Kang ó bà achu ka̱t, kang ó ma̱n mmá fe ichu wó, ka̱t te nnap-nlà nro á fa ka̱ anung wó ka̱t, yà i ga i chu nra va̱ mi là a wó pa̱ ó bà achu, nna chit te, ó bà ɗak.>> ");
INSERT INTO yer_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Uza̱ nak mmá yar akwati aYawe mmá gáng ìtong va̱ ta ká̱, nva̱ng pa̱ nzəng. Nna chit te, oza̱ le ka̱ ashe apa̱k kang oza̱ ra ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","UJoshuwa wong ká̱ iɓotak, kang onəm oga mpyal awop yar akwati aYawe. ");
INSERT INTO yer_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Onəm oga mpyal awop oga ofangshat va̱ wur oga agbəshi pa̱ fangshat te, oza̱ watar i chen ká̱ ka̱ mpyal akwati aYawe, oza̱ i nəm inok mɓuɓur. Onəm oga iya̱m ìkum ka̱ mpyal oza̱, kang onəm oga mpángchí nva̱ng ka̱ mɓa ka̱ nva̱ng akwati aYawe. Ka̱ ashe nkpaktak oga awalang va̱ ta te, mmá pak inok mɓur oga agbəshi. ");
INSERT INTO yer_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ka̱ nra ngga mparəm te, oza̱ gáng ìtong va̱ ta nva̱ng pa̱ nzəng, nna chit te, oza̱ le ashe apa̱k. Wa ǹna ta oza̱ nəm nra pa̱ nkpa̱ɗing. ");
INSERT INTO yer_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Kà̱ nra ngga nfangshat te, oza̱ wong ká̱ iɓotak, oza̱ chen gáng ìtong va̱ ta nva̱ng pa̱ nfangshat wa nva oza̱ mmà nəm a. Kà̱ nra va ta na byet, oza̱ chen gang ìtong va̱ ta nva̱ng pa̱ nfangshat. ");
INSERT INTO yer_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Ka̱ nggáng ngga nfangshat te, awalang va̱ onəm oga mpyal awop ɓur oga agbəshi chit, te uJoshuwa nak oshozha pa̱, <<Ó bà achu, ka̱kul uYawe na ìtong va̱ ta̱ a wó chit. ");
INSERT INTO yer_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Ìtong va̱ ta ka̱ nkpaktak iya̱m va̱ ka̱ ashishe te mmá gar ûYawe ka̱kul nzhì. URahap uchar uga nnəm mmai va̱ ta ká̱ nkpaktak onəm va̱ nzəng ká̱ na ka̱ ashe nzhizhi te, oma mí re ká̱ irirì ɓyet ka̱kul pa̱ uza̱ bwam onəm oga nsòng atak yi va̱ í re nre kà̱ ka̱ ashe mbin va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Mmawo ǹnyi te, ó pángchí ishi wó ka̱ atak oga iya̱m va̱ mmá gar chit ka̱kul nzhì. Le kang ó ɓa ká̱ nzhì ká̱ nɗaktak îshi wó ká̱ apa̱k oIsa̱rila ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Kang nkpaktak aazurfa ká̱ azənariya, ká̱ acham aləbər, ká̱ acham arəzang ǹnyi te, iya̱m iyə́ryər ûYawe. Mí táng ká̱ ka̱ ashe nzhi ngga mɓut iya̱m aYawe.>> ");
INSERT INTO yer_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Te onəm oga mpyal awop ɓur oga agbəshi. Onəm fe nnap agbəshi te, oza̱ bà achu pa̱ gbá̱nggbá̱ng, kang akamsəlang va̱ ta shin. Te onəm táng ka̱ ashe ìtong va̱ ta, uda nggo kpán mpyal wò pa̱ dakdak, kang oza̱ kpán ìtong va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Nna chit te, oza̱ zhì nkpaktak iya̱m va̱ ka̱ ashe ìtong va̱ ta ká̱ ndokchi, ochar ká̱ onunggwan, ovan ká̱ onəm gbakgbak, ina ká̱ itam ká̱ azhaki. ");
INSERT INTO yer_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Te uJoshuwa là ônunggwan oga oparəm va̱ oma ka̱ sòng mbin va̱ ta pa̱, <<Ó ga ashe nzhi achar uga nəm mmai va̱, na ó fa ka̱ na ká̱ nkpaktak onəm va̱ ojini wa nva ka̱ ó sóng anung a na á.>> ");
INSERT INTO yer_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Te ovan nza̱m va̱ ka̱ sòng mbin va̱ ta táng fa ká̱ uRahap, ká̱ upupo ká̱ unənang ká̱ ogənanggənang onunggwan ká̱ ochar, ká̱ nkpaktak onəm va̱ ojini. Kang oza̱ fa ká̱ nkpaktak onəm oga nzhizhi, oza̱ nak ka̱ nsəm apa̱k oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Te oza̱ pwak ìtong va̱ ta ká̱ apər, ká̱ nkpaktak iya̱m va̱ ka̱ ashishe, ǹnyi te, mmá nak aazurfa ká̱ azənariya ká̱ oga acham arəzang ká̱ acham aləbər, ka̱ ashe nzhi ngga mɓut iya̱m aYawe. ");
INSERT INTO yer_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Ǹnyi te, uJoshuwa re uRahap uchar uga nnəm mmai, ká̱ onəm oga ashe nzhizhi, ká̱ nkpaktak onəm va̱ ojini ka̱ irirì, ka̱kul pa̱ uza̱ bwam onunggwan va̱ uJoshuwa re ǹre ká̱ pa̱ á sòng mbin aJariko á. Uwa ka̱ ntəm ka̱ ashe aIsa̱rila ɓa chu nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Ka̱ awalang va̱ ta te, uJoshuwa là nnap ôza̱ nzəng ka̱ nsóng anung pa̱, <<Unəm va̱ a wong ka̱kul pa̱ ô me ìtong aJariko kà̱ɗi te, uza̱ sat unəm uvyapvyap chit ka̱ mpyal aYawe, <<ka̱ anung irirì ayiyen ununggwan uga nggəshi, kang uza̱ i bang akukum, ka̱ anung irirì ayiyen ununggwan uga nku irəng kang uza̱ i me oga anung asəsa̱l.>> ");
INSERT INTO yer_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Te uYawe uwa yà nzəng ká̱ uJoshuwa, kang aɗiɗin dam ka̱ ashe nkpaktak mbin va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Ǹnyi te, oIsa̱rila nyám nlang nnandər ka̱ apal iya̱m igargar ka̱kul nzhì. UAkan, uya aKarmi ununggwan, uya aZabdi, uya aZera uga akum ìjili aYahuda, kpa̱k ka̱ ashe iga iya̱m va̱ mmá dang oza̱ kà̱ ngwuwur. Te igwak aYawe lak ka̱ apal ishi oIsa̱rila pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Te uJoshuwa re onunggwan ka̱ aJariko pa̱ oza̱ a ga aAyi, va̱ dat ká̱ aBet-Aven, ka̱ asa̱l nfa alum aBetel, uza̱ là ôza̱ pa̱, <<Ó ga ó sòng mbin va̱ ta.>> Te onunggwan va̱ ta ga nsòng aAyi. ");
INSERT INTO yer_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Awalang va̱ oza̱ le atak aJoshuwa te, oza̱ là á na pa̱, <<Kang nkpaktak oshozha á ga ka̱t, mmá re onəm achu ìkalong pa̱ iparəm ka̱t te pa̱ ishatɗing á ga á ri aAyi ká̱ ìkum, kang mmá nak nkpaktak oshozha á ɓək anung ngga ka̱ ta ka̱t, ka̱kul oza̱ yəl ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Te onəm chu wa ìkalong pa̱ ishatɗing ka̱ ashe onəm ɓa ga, kang onəm oga aAyi ga ɓak oza̱ chəng. ");
INSERT INTO yer_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Onəm oga aAyi gbá̱ng onəm á chu ìsəm pa̱ ishatɗing ama̱n pa̱ kpa̱ɗing ka̱ ashe oIsa̱rila, oza̱ ɓak oza̱ ɓan ka̱ anung asa̱l ìtong a ga chu aShebarim, kang oza̱ nəm inok ngbá̱ng oza̱ ka̱ aba̱nda̱m va̱ ta. Te izər rusok ká̱ onəm wa ndəng. ");
INSERT INTO yer_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Te uJoshuwa ká̱ onəmgbak oIsa̱rila kan ilukwan oza̱, kang oza̱ tak zəp ká̱ afu ka̱ mbin kà̱ mpyal akwati aYawe a ga chu arurong. Kang oza̱ wung mɓwang ka̱ apal ishi oza̱. ");
INSERT INTO yer_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Te uJoshuwa là pa̱, <<Iya̱m iga ngga aɗor ka̱kul yi, áNəm Uga Nzhi uYawe, iza̱ nak kang u pa̱ng ká̱ onəm va̱ ta̱ ɓa igwong aUrdun, ka̱kul pa̱ ú na yi ka̱ ashe awo oga aAmori á gbá̱ng yi yà? Kapkap ká̱ i təm iya̱m yi ka̱ agwong aUrdun va cho. ");
INSERT INTO yer_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Ánəm uga nzhi, iza̱ mi là ka̱ nva̱ngva̱ oIsa̱rila ga̱ɓa̱n asəm ka̱ mpyal okpa ìkum oza̱ yà? ");
INSERT INTO yer_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Ka̱kul oKanana ká̱ nkpaktak onəm va̱ ka̱ ntəm ka̱ ashe mbin va̱ ta̱ i fe nnap va̱ ta̱, te i gáng yi kang i dərkən aɗin yi ka̱ apambin. Te iza̱ ɓu nəm ka̱kul aɗin ɓu achumchum yà?>> ");
INSERT INTO yer_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Te uYawe là ûJoshuwa pa̱, <<Wong, ka̱kul iza̱ kang u ru u zəp ká̱ afu ka̱ mbin yà? ");
INSERT INTO yer_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","AIsa̱rila nəm nnap-mɓá̱ngɓa̱ng chit, oza̱ yəl nsar nnap-nla mi va̱ n nak ôza̱ ka̱t, ka̱kul oza̱ nəm ayi, oza̱ kpa̱k ka̱ ashe oga iya̱m igargar ka̱kul nzhì va̱ mma dang chit, oza̱ nak ka̱ ashe iji oza̱, kang oza̱ nap akwam ka̱ apal iya̱m va̱ oza̱ nəm. ");
INSERT INTO yer_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Ka̱kul nva̱ ta te onəm oIsa̱rila i yà ka̱ nsat ka̱ mpyal okpa ìkum oza̱ lap ka̱t. Oza̱ ga̱ɓa̱n asəm chəng ka̱ mpyal okpa ìkum oza̱, kang oza̱ tong ovyapvyap chit ka̱kul nzhì. Mi yà nzəng ká̱ wo lap ka̱t, yà ó zhì oga iya̱m igargar iga nzhì va̱ ta ka̱ ashe wó kang. ");
INSERT INTO yer_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","<<Wóng, na u gar onəm, là ôza̱ pa̱ <Ó gar ishi wó ka̱kul ìpin, ka̱kul uYawe, Inan oIsa̱rila là pa̱, ÓIsa̱rila, oga iya̱m igargar ka̱kul nzhì na yà ka̱ ishimshe wó. Ó yà ka̱ nsat ka̱ mpyal okpa ìkum wó lap ka̱t, ya ó fa ká̱ oga iya̱m va̱ ta kang. ");
INSERT INTO yer_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","<< <Ká̱ ìpin te, ó nyám ishi wó ka̱ atak oga akum ìjili wó. Akum ìjili va̱ uYawe i yak te, oza̱ i səng i ɓa datkulung ka̱ atak oga akum oza̱. Akum va̱ uYawe i yak te, i səng i ɓa datkulung nzhi ká̱ nzhi. Kang nzhi va̱ uYawe i yak te, i səng i ɓa datkulung unəm ká̱ unəm. ");
INSERT INTO yer_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Unəm va̱ mmá ya na ká̱ iya̱m igargar ka̱kul nzhì te, mí pwak na ká̱ apər, ká̱ nkpaktak iya̱m va̱ uza̱ ká̱. Uza̱ gantal nsar nnap-nlà aYawe chit, kang uza̱ nəm iya̱m iga ìwuswa ka̱ ashe oIsa̱rila.> >> ");
INSERT INTO yer_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Te uJoshuwa wong ká̱ iɓotak, nak oIsa̱rila ɓa datkulung ka̱ atak oga akum ìjili oza̱, te mmá yak akum ìjili aYahuda. ");
INSERT INTO yer_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Uza̱ ɓa ká̱ akum ìjili aYahuda, te mmá yak akum aZera. Uza̱ ɓa ká̱ akum aZera nzhi ká̱ nzhi, te mmá yak nzhi aZabdi. ");
INSERT INTO yer_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","UJoshuwa ɓa ká̱ nzhi aZabdi dat unəm ka̱ unəm, kang mmá yak uAkan uya aKarmi ununggwan, uya aZabdi, uya aZera, ka̱ akum ìjili aYahuda. ");
INSERT INTO yer_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Te uJoshuwa là ûAkan pa̱, <<Áyen mi, n chal ɓu, là mpat ɓu ûYawe, Inan oIsa̱rila, te là á mi iya̱m va̱ u nəm. Kang wa bwam á mi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Te uAkan na ama̱n pa̱, <<À nnandər n nəm nnap-mɓá̱ngɓa̱ng uYawe, Inan oIsa̱rila chit. Iya̱m va̱ n nəm te nnà ta̱. ");
INSERT INTO yer_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Ka̱ ashe oga iya̱m iga ngwur ka̱ atak ìkum te, n ya ìlukwan ìnəna̱n apir iji oga aBabila, ká̱ ashekel ìgba̱l pa̱ ìpa̱rəm aga aazurfa, ká̱ idari azenariya va iɗəɗək ashekel ìsəm pa̱ ìtukun. Te n nəm aɗom oza̱, kang n wur, n li ka̱ ashe mbin ka̱ ashe aghal mi, ká̱ aazurfa ka̱ avəvəng.>> ");
INSERT INTO yer_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Te uJoshuwa re onəm oga nre, kang oza̱ chəng ga ashe aghal va̱ ta, te oza̱ ya nna a bwam ka̱ ashe aghəghal ká̱ aazurfa va̱ ta ka̱ avəvəng. ");
INSERT INTO yer_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Oza̱ wur oga iya̱m va̱ ta fa ka̱ ashe aghal, oza̱ ɓa ka̱ ûJoshuwa ká̱ nkpaktak onəm oIsa̱rila, kang oza̱ nak ka̱ mpyal aYawe. ");
INSERT INTO yer_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Te uJoshuwa ká̱ nkpaktak oIsa̱rila yar uAkan uya aZera ununggwan, ká̱ aazurfa, ká̱ ìlukwan, ká̱ idari azənariya, ká̱ ovəvan onunggwan ká̱ ochar, ká̱ inəna, ká̱ oga azhakizhaki, ká̱ itətam, ká̱ aghəghal, ká̱ nkpaktak iya̱m va̱ uza̱ ka̱, kang oza̱ ɓa ká̱ oza̱ ka̱ mba̱nda̱m ngga aAkor. ");
INSERT INTO yer_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","UJoshuwa là pa̱, <<Ka̱kul iza̱ kang u ɓa ká̱ nɗaktak va̱ ta̱ á yi yà? Ka̱ nda ta̱ uYawe i ɓa ká̱ nɗaktak a ɓu.>> Te nkpaktak oIsa̱rila gwan na ká̱ ipang, kang nva̱ngva̱ oza̱ gwan onənəm chit te, oza̱ pwak oza̱ ká̱ nkpaktak iya̱m oza̱ ká̱ apər. ");
INSERT INTO yer_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Oza̱ ɓut ipang ɓing ka̱ apal ishishi. Mɓing ipang va̱ ta nna yà ka̱ ta nda va̱ ta̱. Te nlak igwak aYawe fər ɗak. Ka̱kul nna kang mí wór atak va̱ ta pa̱ mba̱nda̱m aAkor nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Te uYawe là ûJoshuwa pa̱, <<Kang wa nəm ayər, ka̱t te wa ga̱m ka̱t. Wur nkpaktak onəm oga nlung ìkum nzəng ká̱ ɓu, na ó ga ó ru aAyi ká̱ ìkum. Ka̱kul n na uponzhi uga aAyi chit ka̱ ashe awo ɓu, ká̱ onənəm, ká̱ ìtutong, ká̱ mbibin. ");
INSERT INTO yer_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Nəm a aAyi ká̱ uponzhiponzhi wa nva u nəm aJariko ká̱ uponzhiponzhi á. Ǹnyi te, ìdur oza̱ ká̱ iya̱mkang nnà ó wur i yà iya̱m iga ngwur ka̱ atak ìkum îshi wó. Ó ra anyimnyal ka̱ nsəm ìtong va̱ ta.>> ");
INSERT INTO yer_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Te uJoshuwa ká̱ nkpaktak onəm oga nlung ìkum wong ga pa̱ na ó ru aAyi ká̱ ìkum. Uza̱ yak onəm oga ǹnyi nlung ìkum ova ji ìkalong ìsəm pa̱ ishatɗing kang uza̱ re oza̱ fa ká̱ ìzwam, ");
INSERT INTO yer_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","uza̱ nak oza̱ pa̱, <<Ó gong achwang pa̱ dakdak. Ó ra anyimnyal ìtong va̱ ta ka̱ nsəm. Kang ó gbà̱ng ká̱ ìtong va̱ ta ka̱t. Nkpaktak wó, ó təm ká̱ ngbar izər pa̱ dakdak. ");
INSERT INTO yer_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Mmami ká̱ nkpaktak onəm va̱ nzəng ká̱ mi, i ga i datkulung ká̱ ìtong va̱ ta. Ka̱ nva̱ngva̱ oza̱ i fa nlung yi wa nva ka̱ yà te, í chəng i le ka̱ mpyal oza̱. ");
INSERT INTO yer_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Oza̱ i fa i wa nva̱ng yi, mmayi te, i dap oza̱ i gbà̱ng ká̱ ìtong va̱ ta, ka̱kul oza̱ i là pa̱, <Oza̱ ka̱ nchəng yi wa mmatmat va.> Awalang va̱ i chəng ka̱ mpyal oza̱ te, ");
INSERT INTO yer_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","ó wong ka̱ atak anyimnyal wó kang ó ka̱m ìtong va̱ ta. UYawe Inan wó i na ìtong va̱ ta ka̱ ashe awo wó. ");
INSERT INTO yer_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Ka̱ nva̱ngva̱ ó ka̱m ìtong va̱ ta chit, te ó pa apər ká̱ ìtong va̱ ta. Ó kpak nnap-mpakpak aYawe va̱ ka̱ nak a wó. Nnap-nkpakpak wó na ta̱.>> ");
INSERT INTO yer_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Te uJoshuwa re oza̱ fa ga nra anyimnyal, kang oza̱ ga ra ka̱ ishimshe aBetel ká̱ aAyi, ka̱ asa̱l ntar alum aAyi. Ǹnyi te, uJoshuwa ra nzəng ká̱ onəm va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Ká̱ iɓotak te, uJoshuwa wong ɓut onəm oga nlung ìkum, kang uza̱ ká̱ onəm oga mpyal oIsa̱rila ləp mpyal ôza̱ ga aAyi. ");
INSERT INTO yer_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Nkpaktak onəm oga nlung ìkum va̱ nzəng ka̱ na te, chen ga dat ká̱ ìtong va̱ ta kang oza̱ la̱p apa̱k ka̱ asa̱l mpəpal. Kang aba̱nda̱m nna yà ka̱ ishimshe oza̱ ká̱ aAyi. ");
INSERT INTO yer_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","UJoshuwa wur onunggwan chu ìkalong chu pa̱ ìtukun, kang uza̱ nak oza̱ ra anyimnyal ká̱ ishimshe aBetel ká̱ aAyi, ka̱ asa̱l ntar alum aga ìtong va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Te onəm oga nlung ìkum va̱ ta la̱p apa̱k ka̱ asa̱l mpal ìtong va̱ ta, kang onəm oga nra anyimnyal ra ka̱ asa̱l ntar alulum. Ǹnyi te, uJoshuwa le ashe aba̱nda̱m ka̱ ìzwam va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Awalang va̱ uPonzhi uga aAyi ya chit pa te, uza̱ ká̱ nkpaktak onunggwan oga ìtong va̱ ta fa ka̱ ǹngha̱n ka̱ iɓotak ga pa̱ na ó gwang ka̱ agbagba ka̱ mpyal aAraba, ka̱kul pa̱ na ó lung ìkum ká̱ oIsa̱rila. Ǹnyi te, uza̱ nyi pa̱ nnà mmá ra anyimnyal ka̱ nsəm ìtong va̱ ta ka̱kul wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","UJoshuwa ká̱ nkpaktak oIsa̱rila nəm na oza̱ ji nkàm wó chit, te oza̱ chəng ka̱ mpyal oza̱ le asa̱l ashe ǹzam. ");
INSERT INTO yer_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Nnà chit te, mmá wór nkpaktak onunggwan va̱ ka̱ ashe ìtong va̱ ta ɓut wa oza̱. Wa nnà ta, oIsa̱rila dap oza̱ gbà̱ng ká̱ ìtong va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Ununggwan uro yà bur ka̱ ashe aAyi, ka̱t te aBetel va̱ fa mɓàk oIsa̱rila ka̱t. Oza̱ re anung ìtong va̱ ta abolbol, kang oza̱ ga mɓàk oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Te uYawe là ûJoshuwa pa̱, <<Yichi aɓár va̱ ka̱ awo ɓu a ga ka̱ asa̱l aAyi, ka̱kul mi ga nnəna ka̱ ashe awo ɓu.>> Te uJoshuwa yichi aɓár va̱ ka̱ awo wò a ga ka̱ asa̱l ìtong va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Kang nva̱ngva̱ uza̱ yichi awo wò chit, te onəm va̱ ra anyimnyal wong ká̱ ǹngha̱n, oza̱ chəng táng ìtong va̱ ta kang oza̱ kpán. Te oza̱ rap apər îtong va̱ ta ka̱ ǹngha̱n. ");
INSERT INTO yer_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Ka̱ awalang va̱ onunggwan oga aAyi dər nva̱ng te, oza̱ ya nggù nəngət chit ga apaɓur. Ǹnyi te, oza̱ yà ká̱ asa̱l aga nchəng ngga mpyal, ka̱t te nle nva̱ng ka̱t, ka̱kul onəm va̱ ka̱ chəng le ashe ǹzam te, á ga̱ɓa̱n chit kà̱ nru oza̱ ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Awalang va̱ uJoshuwa ka̱ nkpaktak oIsa̱rila ya pa̱ onəm va̱ ra anyimnyal kpán ìtong va̱ ta chit, kang nggù nəngət chit ka̱ apal, te oza̱ ga̱ɓa̱n le gbá̱ng onəm oga aAyi. ");
INSERT INTO yer_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Onunggwan va̱ kpan ìtong va̱ ta chit, fa ka̱ ashe ìtong va̱ ta ru oza̱ ká̱ ìkum. Kang oIsa̱rila nak oza̱ ká̱ ishimshe. Te oza̱ gbá̱ng oza̱, unəm uro yà lár, ka̱t te chə́r fa ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Ǹnyi te, oza̱ kpán uPonzhi oga aAyi ká̱ irirì, kang oza̱ ɓa ka̱ na ûJoshuwa. ");
INSERT INTO yer_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Ka̱ nva̱ngva̱ oIsa̱rila gba̱l ka̱ ngbá̱ng nkpaktak onəm oga aAyi ovəngva̱ wa nva̱ng oza̱ ka̱ ashe ǹzam mmaləng ká̱ agbagba, kang va̱ oza̱ gbá̱ng oza̱ ká̱ ndokchi tak chit. Te oIsa̱rila le ga aAyi gbá̱ng onəm va̱ ka̱ ashishe ká̱ ndokchi. ");
INSERT INTO yer_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Onəm va̱ mmá gbá̱ng ká̱ nda ta te, ìkalong pa̱ igba̱pchi ama̱n pa̱ ìparəm, onunggwan ka̱ ochar, nkpaktak onəm oga aAyi. ");
INSERT INTO yer_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Ǹnyi te, uJoshuwa le ká̱ awo va̱ uza̱ yichi aɓár ká̱ ka̱t, a ga chu awalang va̱ uza̱ zhì nkpaktak onəm oga ntəm ka̱ ashe aAyi kang. ");
INSERT INTO yer_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Oga Iya̱mkang ká̱ idur iga ashe ìtong va̱ ta nna byet oIsa̱rila wur iya̱m iga ngwur ka̱ atak ìkum îshi oza̱, wa nva uYawe ka̱ nak ûJoshuwa pa̱ á nəm. ");
INSERT INTO yer_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Te uJoshuwa pwak aAyi, kang á nak ɓing sat agúng mbyet, nna yà wa nnà ta nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Uza̱ zong uponzhi uga aAyi ka̱ apal ìkun a ga chu arurong. Ka̱ nva̱ngva̱ alum tar chit, te uJoshuwa nak pa̱ mmá fər ká̱ akúkum ka̱ apal ìkun va̱ ta, mmá máng ka̱ anung asa̱l aga ntar ìtong va̱ ta. Kang mmá ɓing ipáng pa̱ makmak ka̱ apal ishishi, nna yà ka̱ ta nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Te uJoshuwa me atak nshì iya̱m awop ûYawe, Inan oIsa̱rila, ka̱ apal aɓam aEbal, ");
INSERT INTO yer_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","wa nva uMusa, uzwal aYawe ka̱ nak onəm oIsa̱rila á. Uza̱ me wa nva ka̱ ashe nlir nnap-mpakpak aMusa va̱ là pa̱, <<Ó me atak nshì iya̱m awop ká̱ ipang pa̱ chatchat iva na mmá kwat chit ká̱ acham ka̱t.>> Te oza̱ yichi iya̱m inana iga nshì ûYawe, ká̱ iya̱m inana nləfər ngga ntəm ikángkáng ka̱ apəpal. ");
INSERT INTO yer_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Kang ka̱ ta ka̱ mpyal oIsa̱rila, uJoshuwa lir nnap-mpakpak aMusa ka̱ apal ipang va̱ ta, nva uMusa ka̱ lir chit á. ");
INSERT INTO yer_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Nkpaktak oIsa̱rila, ká̱ onəmgbak, ká̱ onəm oga mpyal, ká̱ onəm oga nnap-akwali, nzəng ká̱ oɗyanəm va̱ ka̱ ashe oza̱, ká̱ ovəngva̱ oza̱ mar, tong kà̱ oga ngba̱k akwati aga nsar nnap-nlà, ka̱ mpyal onəm oga mpyal awop oLawi, ovəngva̱ yar akwati aga nsar nnap-nlà aYawe. Kang nkap kà̱ ishimshe onəm tong ka̱ mpyal aƁam aGerizim, kang aɓo nkap nro tong ka̱ mpyal aƁam aEbal, wa nva uMusa, uzwal aYawe ka̱ nak chit, pa̱ mmá nak nnap-nnəna̱n onəm oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Ka̱ nvəva̱ng te, uJoshuwa kung nkpaktak oga nnap-nlà va̱ ka̱ ashe nnap-mpakpak ngga nnak oga nnap-nnəna̱n ká̱ nvyap, mal dakdak ká̱ nkpaktak iya̱m va̱ mmá lir ka̱ ashe nnap-mpakpak. ");
INSERT INTO yer_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Nnap-nlà nro yà nva uMusa nak kang uJoshuwa kung ka̱ mpyal nkpaktak mɓut oIsa̱rila ka̱t te, a yà ka̱t, nzəng ká̱ ochar, ká̱ ovan, ká̱ oɗyanəm va̱ ka̱ ntəm ka̱ ashe oza̱ á. ");
INSERT INTO yer_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Ka̱ awalang va̱ nkpaktak oponzhi va̱ kà̱ ntar alum aUrdun, ká̱ oponzhi va̱ kà̱ mbin ngga aɗuktum ká̱ mba̱nda̱m oIsa̱rila, kang oponzhi va̱ kà̱ mbin ngga anung inang ìwa aMeditereniya a ga chu aLebanon, oma oponzhi oHitti, ká̱ oAmori, ká̱ oKanana, ká̱ oPerizi, ká̱ oHivi, ká̱ oJebusi fe nnap igwan va̱ ta, ");
INSERT INTO yer_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","te oza̱ gwang ishi ka̱ anung zəngtəng ka̱kul pa̱ ó lung uJoshuwa ká̱ oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Ǹnyi te, awalang va̱ onəm oga ntəm ka̱ aGibiyon fe iya̱m va̱ uJoshuwa nəm aJariko ká̱ aAyi te, ");
INSERT INTO yer_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","oza̱ nəm aghan. Oza̱ ɗa̱mshi iya̱m-nrì iga nkpán ka̱ awo, oza̱ wur ijiga igbakgbak ka̱ apal oga azhaki oza̱ ká̱ aba̱ng ndəng ìba̱ngba̱ng ǹsámsàm igbakgbak, va kan chit kang izəzər pa̱ kap mmá dədan. ");
INSERT INTO yer_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Oza̱ mwak oga akwap agbakgbak ka̱ ashar oza̱ va mmá ɓəɓáp, ká̱ ilukwan igbakgbak. Kang nkpaktak nzəngkəng ngga nkpán awo oza̱ a wom chit kang a gum. ");
INSERT INTO yer_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Te oza̱ ga atak aJoshuwa ka̱ ashe apa̱k ka̱ aGilgal, kang oza̱ là á na ká̱ oIsa̱rila pa̱, <<Í fa ka̱ mbin nggbá̱nggbà̱ng, ǹyangmata̱ te, ó yar nsar nnap-nlà ká̱ yi.>> ");
INSERT INTO yer_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Ǹnyi te, oIsa̱rila là ôHivi pa̱, <<Mwote mmawó ka̱ ntəm dát ka̱ yi nggo, te sang kang í yar nsar nnap ká̱ wó yà?>> ");
INSERT INTO yer_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Kang oza̱ là ûJoshuwa pa̱, <<Mmayi ozwal ɓu.>> Ǹnyi te, uJoshuwa ɓəp oza̱ pa̱, <<Mmawó, o da yà? ó fa ka̱ che kang ó ɓa yà?>> ");
INSERT INTO yer_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Te oza̱ na ama̱n á na pa̱, <<Ozwal ɓu fa ka̱ mbin va gbà̱ng byet kang à ɓa, ka̱kul aɗin aYawe Inan ɓu. Ka̱kul i fe nnap-nnənəm chit, ká̱ nkpaktak iya̱m va̱ uza̱ nəm ka̱ aMasar, ");
INSERT INTO yer_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","kang nkpaktak iya̱m va̱ uza̱ nəm ôponzhi oga oparəm oga aAmori va̱ ka̱ asa̱l nfa alum aUrdun, oma uponzhi uSihon uga aHeshbon, ká̱ uponzhi uOg uga aBashan, ova ka̱ nəm iponzhi ka̱ aAshtarot. ");
INSERT INTO yer_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Onəmgbak yi ká̱ nkpaktak onəm oga ntəm ka̱ ashe mbin yi là á yi pa̱, <Ó wur iya̱m-nrì iga nkpán awo ka̱kul nnəm achen, na ó ga ó ya oza̱, kang ó là ôza̱ pa̱, <<Mmayi ozwal wó, ó yar nsar nnap ka̱ yi.>> > ");
INSERT INTO yer_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Nzəngkəng yi nna ka̱ yà susur ka̱ awalang va̱ í wur ka̱ nzhi ka̱ nra va̱ í fa pa̱ í ɓa atak wó. Ǹnyi te, dər ǹyangmata̱, a wom chit kang á gum. ");
INSERT INTO yer_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Kang oga aba̱ng ndəng ìba̱ngba̱ng ǹsámsàm va̱ i yə́l ta̱, te nna ka̱ yà apipye, ǹnyi te, dər asa̱l va̱ oza̱ chwan ká̱. Kang ilukwan ká̱ oga akwap yi á gbák chit ka̱kul ngbà̱ng achen.>> ");
INSERT INTO yer_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Te oIsa̱rila kpa̱k ka̱ ashe iya̱m-nrì onəm oga aGibiyon, ǹnyi te, oza̱ ɓəp ichən ka̱ atak aYawe ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Te uJoshuwa ma̱n yar nsar nnap-nlà ngga ntəm ikángkáng ká̱ oza̱, pa̱ mmá re oza̱ á təm ká̱ irirì. Kang onəm oga mpyal mɓut sóng anung ôza̱. ");
INSERT INTO yer_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Ka̱ nva̱ng nra pa̱ nshatɗing nva̱ oza̱ yar nsar nnap-nlà ká̱ onəm oga aGibiyon chit, te oIsa̱rila fe pa̱ oza̱ onəm oga ngba̱k oza̱, kang oza̱ ka̱ ntəm dát ká̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Te onəm oIsa̱rila fa achen, kang ka̱ nra ngga nshatɗing te, oza̱ chu itong va̱ onəm va̱ ta i təm kà̱. Oma aGibiyon, ká̱ aKefira, ká̱ aBiyerot, ká̱ aKiriyat-Jeyarim. ");
INSERT INTO yer_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Ǹnyi te, oIsa̱rila gbá̱ng oza̱ ka̱t, ka̱kul onəm oga mpyal mɓut ka̱ sóng anung ôza̱ chit ka̱ ashe aɗin aYawe, Inan oIsa̱rila. Te nkpaktak nggatək lwang nnap ka̱ apal onəm oga mpyal va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Ǹnyi te, nkpaktak onəm oga mpyal na ama̱n n̂ggatək va̱ ta pa̱, <<I sóng anung ôza̱ chit ka̱ ashe aɗin aYawe, Inan oIsa̱rila, ka̱kul nva̱ ta te, i yà ka̱ ndok oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Iya̱m va̱ i nəm ôza̱ te, i re oza̱ ká̱ irirì ka̱kul nsóng anung va̱ i sóng ôza̱ chit, le kang í dapchi nlak ìgwak aYawe ka̱ apal ishi yi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Onəm oga mpyal là ôza̱ ka̱ɗi pa̱, <<Mmá re oza̱ ká̱ irirì, ǹnyi te, re oza̱ á tong onəm oga nkyen akun ká̱ nɗyang ndəng n̂ggatək.>> Wa nnà ta onəm oga mpyal yə́l nsar nnap-nlà oza̱. ");
INSERT INTO yer_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Te uJoshuwa wór onəm oga aGibiyon kang á là ôza̱ pa̱, <<Sang kang ó lam yi, ó là pa̱, <I fa gbəgba̱ng,> ǹnyi te, mmawó ka̱ ntəm dát ká̱ yi yà? ");
INSERT INTO yer_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Ǹyangmata̱ te, uYawe vyap wó chit, ka̱ ashe wó unəm uro i yà iya̱m iro lap ka̱t, ozwal na chwat, onəm oga nkyen akun ká̱ nɗyang ndəng ka̱kul nzhi Inan mi.>> ");
INSERT INTO yer_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Te oza̱ ma̱n ûJoshuwa pa̱, << Ozwal ɓu fe nnap va̱ uYawe, Inan ɓu, nak ûzwal wò uMusa chit pa̱, á na nkpaktak mbin va̱ ta̱ a wó, na ó zhì nkpaktak onəm va̱ ka̱ ntəm ka̱ ashishe. Nnà nak te, ayər nəm yi pa̱ gənggəng ka̱kul irirì yi, kang i nəm iya̱m va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Ǹyangmata̱ te, mmayi ka̱ ashe awo ɓu, nəm á yi iya̱m va̱ u ya məmal kang aɓiɓyen ká̱ ɓu á.>> ");
INSERT INTO yer_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Te uJoshuwa ka̱m ishi oza̱ ka̱ ashe awo oIsa̱rila, oza̱ gbá̱ng oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Ǹnyi te, ka̱ nda va̱ ta uJoshuwa nak oGibiyon tong onəm oga nkyen akun ká̱ nɗyang ndəng ka̱kul nggatək, ká̱ atak va̱ uYawe yak ka̱kul nshì iya̱m awop. Kang wa nnà ta oza̱, ɓa chu ká̱ nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Ǹyangmata̱ te, uAdonizedek uPonzhi uga aUrushelima fe chit pa̱ uJoshuwa ri aAyi kang uza̱ zhì na pa̱ chatchat, uza̱ nəm á na wa nva uza̱ ka̱ nəm âJariko ká̱ uponzhiponzhi, kang pa̱ onəm oga aGibiyon nəm ntəm ikángkáng ká̱ oIsa̱rila chit, kang oma ka̱ ntəm ka̱ ashe oza̱. ");
INSERT INTO yer_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Te ayər nəm na nzəng ká̱ onənəm pa̱ gənggəng ka̱kul aGibiyon inang ìtong, wa itong va ká̱ iponzhi, ka̱kul pa̱ á ji aAyi ji ká̱ ìrup, kang nkpaktak onunggwannunggwan te, onunggwan ìkum. ");
INSERT INTO yer_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Te uAdonizedek uponzhi uga aUrushelima, re ǹre ga atak aHoham uPonzhi uga aHebron, ká̱ uPiram uponzhi uga aJarmut, ká̱ uJafiya uponzhi uga aLakish, kang ká̱ uDebir uponzhi uga aEglon, là pa̱, ");
INSERT INTO yer_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","<<Ó ɓa ó ka̱mshi mi, na i lung ìkum ká̱ oga aGibiyon, ka̱kul oza̱ yar nsar nnap-nlà chit ká̱ uJoshuwa ká̱ onəm oIsa̱rila.>> ");
INSERT INTO yer_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Te oPonzhi oga otukun oga aAmori va̱ ta̱, uponzhi uga aUrushelima, ká̱ uponzhi uga aHebron, ká̱ uponzhi uga aJarmut, ká̱ uponzhi uga aLakish, ká̱ uponzhi uga aEglon, ɓut nkpaktak onəm ìkum oza̱ te, a ɓa ga ləp apa̱k gáng aGibiyon kang a ru oza̱ ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Te oGibiyon re ǹre ga atak aJoshuwa ka̱ ashe apa̱k ka̱ aGilgal, oza̱ là pa̱, <<Kang wa swang ozwal ɓu ka̱t. Ɓa atak yi pa̱ kəlak, na ú ka̱m ishi yi. Ka̱mshi yi, ka̱kul pa̱ nkpaktak oponzhi oga oAmori, ova ka̱ ntəm ka̱ ashe mbin ngga aɗuktum, oza̱ gwang ishi chit pa̱ ó lung yi.>> ");
INSERT INTO yer_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Te uJoshuwa wong ka̱ aGilgal ɓa ga, uza̱ ká̱ nkpaktak onəm oga nlung ìkum wò, ká̱ nkpaktak onunggwan oga ǹnyi ìkum. ");
INSERT INTO yer_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","UYawe là ûJoshuwa pa̱, <<Kang a nəm ayər oza̱ ka̱t, ka̱kul n na oza̱ chit ka̱ ashe awo ɓu. Unəm uro yà ka̱ ashe oza̱ chu nsat ka̱ mpyal ɓu ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Te uJoshuwa wong ka̱ aGilgal nəm achen ka̱ ashe nkpaktak ìzwam, kang uza̱ ga mul oAmori. ");
INSERT INTO yer_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","UYawe nak oza̱ zwar ka̱ mpyal oIsa̱rila. Te oza̱ gbá̱ng oAmori pa̱ makmak ka̱ aGibiyon, kang oza̱ ɓak oza̱ ka̱ asa̱l aga nkyen mɓa ngga aBet-Horon oza̱ nəm inok ngbá̱ng oza̱ ga chu aAzeka ká̱ aMakeda. ");
INSERT INTO yer_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Ka̱ awalang va̱ oza̱ ka̱ nchəng ka̱ mpyal oIsa̱rila, ka̱ nvang asa̱l aBet-Horon va iga aAzeka te, uYawe swang oga aɗəɗal va mwal wa inang ipang ka̱ apaɓur vang ka̱ apal oza̱. Ovəngva̱ kú ka̱ atak aɗəɗal va̱ ta te, yə́l ji ovəngva̱ ji onəm oIsa̱rila gbá̱ng ká̱ ndokchi. ");
INSERT INTO yer_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Kà̱ ìlum va̱ uYawe na oAmori ka̱ ashe awo oIsa̱rila te, uJoshuwa là nnap ûYawe, ka̱ mpyal oIsa̱rila pa̱, <<Álum, sat pa̱ kwák ka̱ apal aGibiyon, kang mmaɓu, ápe ka̱ apal mba̱nda̱m aAjalon.>> ");
INSERT INTO yer_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Te alum sat pa̱ kwák, kang ape ta̱l, a ga chu awalang va̱ onəm pyát ka̱ apal ishi okpa ìkum oza̱, wa nva ka̱ ashe nlìr aJashar. Te alum sat ka̱ ishimshe aɓuɓur, a kali ka̱ ntar ga chu ìlum pa̱ izəng. ");
INSERT INTO yer_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Ìlum ya yà chit wa nva̱ ta̱ ka̱t, ka̱ nva̱ng ka̱t te, matmat ka̱t, ìlum nva uYawe fe ìchu anəmləbər ká̱. Nnandər uYawe uwa ka̱ nlung ìkum ka̱kul oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Kà̱ nvəva̱ng te, uJoshuwa ká̱ nkpaktak oIsa̱rila le apa̱k ka̱ aGilgal. ");
INSERT INTO yer_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Ǹyangmata̱ te, oponzhi oga otukun va̱ ta̱ ka̱ chəng chit ka̱ bwam ka̱ ashe agba̱k ka̱ aMakeda. ");
INSERT INTO yer_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Awalang va̱ mmá là ûJoshuwa pa̱, mmá ya oponzhi oga otukun va̱ ta̱ chit, oma bwam ka̱ ashe agba̱k ka̱ aMakeda, ");
INSERT INTO yer_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","te uza̱ là pa̱, <<Ó ɓəndəng ipang imwalmwal á kùk anung agba̱k va̱ ta, kang ó nak onəm apángchí oza̱. ");
INSERT INTO yer_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Ǹnyi te, kang ó sat ka̱ ta ka̱t. Ó wa nva̱ng okpa ìkum wó, kang ó ru oza̱ ka̱ asa̱l nva̱ng. Kang ó re oza̱ a le a táng oga itong oza̱ ka̱t, ka̱kul uYawe Inan wó, a na oza̱ chit ka̱ ashe awo wó.>> ");
INSERT INTO yer_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Te uJoshuwa ká̱ onəm oga aIsa̱rila ngbá̱ng oza̱ pa̱ chatchat, ǹnyi te, aɓo oro pa̱ ɗa̱p chəng táng ashe itong iga akamsəlang oza̱. ");
INSERT INTO yer_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Te nkpaktak onəm le ká̱ ikángkáng ka̱ atak aJoshuwa ka̱ apa̱k ka̱ aMakeda. Kang unəm uro yà ram anung ka̱ oIsa̱rila lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","UJoshuwa là pa̱, <<Ó bol anung agba̱k va̱ ta, na ó fa ká̱ oponzhi oga otukun va̱ ta, ó ɓa ká̱ oza̱ á mi.>> ");
INSERT INTO yer_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Te oza̱ fa ká̱ oponzhi oga otukun va̱ ta ka̱ ashe agba̱k, uponzhi uga aUrushelima, ká̱ uga aHebron, ká̱ uga aJarmut, ká̱ uga aLakish, ká̱ uga aEglon. ");
INSERT INTO yer_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Awalang va̱ oza̱ ɓa ká̱ oponzhi va̱ ta chit ûJoshuwa, te uza̱ ɓut nkpaktak onunggwan oIsa̱rila, kang uza̱ là ônəm oga mpyal ìkum va̱ ɓa nzəng ká̱ na pa̱, <<Ó ɓa ka̱ ta̱, na ó nak ashar wó ka̱ ishak oponzhi va̱ ta̱.>>Te oza̱ ɓa mpyal kang oza̱ nak ashar ka̱ apal ishak oza̱. ");
INSERT INTO yer_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Te uJoshuwa là ôza̱ pa̱, <<Kang ayər a nəm wó ka̱t, kang ichəgwak a la̱p wó ka̱t. Ó nəm nkam ìgwak, ó tong pa̱ kakkərak. Iya̱m va ta̱ uYawe i ga nnəm n̂kpaktak okpa ìkum va̱ mmawó kà ngga nlulung.>> ");
INSERT INTO yer_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Te uJoshuwa gbá̱ng oponzhi va̱ ta, kang a zong oga akúm oza̱ ka̱ apal ikún pa̱ itukun, kang a re oza̱ zong ka̱ apal ikún va̱ ta ga chu arurong. ");
INSERT INTO yer_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Alum kà̱ ntar te, uJoshuwa nak pa̱, mmá fəng ká̱ oza̱ ka̱ apal ikún mmá swang ka̱ ashe agba̱k va̱ oza̱ ka̱ bwam kà̱. Te oza̱ kùk anung agba̱k va̱ ta ká̱ ipang imwalmwal, oma yà ka̱ ta nda ta̱. ");
INSERT INTO yer_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Ká̱ nda va̱ ta uJoshuwa ri aMakeda ká̱ ìkum. Uza̱ gbá̱l uponzhiponzhi ká̱ ndokchi, kang uza̱ zhì nkpaktak onəm va̱ ka̱ ashe ìtong va̱ ta. Unəm uro yà uza̱ re fa ka̱ ashishe ka̱t. Uza̱ nəm ûponzhi uga aMakeda wa nva uza̱ ka̱ nəm ûponzhi uga aJariko. ");
INSERT INTO yer_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Te uJoshuwa ká̱ nkpaktak oIsa̱rila va̱ ká̱ na wong ka̱ aMakeda ga aLibna, kang oza̱ ru oza̱ ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Te uYawe na ìtong va̱ ta ká̱ uponzhiponzhi ka̱ ashe awo oIsa̱rila kpa. Kang ìtong va̱ ta ká̱ nkpaktak onəm va̱ ka̱ ashishe uJoshuwa gbá̱ng ká̱ ndokchi. Uza̱ re unəm uro fa ka̱ ashishe ka̱t. Uza̱ nəm ûponzhiponzhi wa nva uza̱ ka̱ nəm ûponzhi uga aJariko. ");
INSERT INTO yer_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Te uJoshuwa ká̱ nkpaktak oIsa̱rila va̱ ká̱ na wong ka̱ aLibna fər ga aLakish, oza̱ gáng na kang a ru ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Kang uYawe na aLakish ka̱ ashe awo oIsa̱rila, te oza̱ ri na ká̱ ìkum ka̱ nra ngga mparəm. Kang oza̱ gbá̱l nza̱ unəm nggo uva̱ ka̱ ashe ìtong va̱ ta ká̱ ndokchi, wa nva oza̱ ka̱ nəm âLibna á. ");
INSERT INTO yer_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Te uHoram uPonzhi uga aGezer wong ɓa nka̱mshi aLakish, ǹnyi te, uJoshuwa gba̱l na nzəng ká̱ onəm ìkukum, uza̱ re unəm uro ká̱ irirì ka̱ ashe oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Te uJoshuwa ká̱ nkpaktak oIsa̱rila va̱ ká̱ na wong ka̱ aLakish fər ga aEglon. Oza̱ gáng na kang a ru ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Oza̱ ri na ká̱ ìkum ka̱ nda va ta, oza̱ gbá̱ng onənəm ká̱ ndokchi kang oza̱ zhì nza̱ unəm nggo uva̱ ka̱ ashishe, wa nva oza̱ ka̱ nəm aLakish á. ");
INSERT INTO yer_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Te uJoshuwa ka̱ nkpaktak oIsa̱rila va̱ ka̱ na wong ka̱ aEglon ɓa ga aHebron, kang oza̱ ru na ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Oza̱ ri na kang oza̱ gba̱l uponzhiponzhi, ká̱ ivan itutong, ká̱ nza̱ unəm nggo ka̱ ashishe ká̱ ndokchi. Oza̱ re unəm uro fa ka̱t. Oza̱ zhì na pa̱ chatchat ká̱ nza̱ unəm nggo ka̱ ashishe, wa nva oza̱ ka̱ nəm aEglon á. ");
INSERT INTO yer_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Te uJoshuwa ka̱ nkpaktak oIsa̱rila va̱ ka̱ na ga̱ɓa̱n ga ru aDebir ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Oza̱ ri ìtong va̱ ta ká̱ ìkum, ká̱ uponzhiponzhi, ká̱ ivan itutong. Kang oza̱ zhì nza̱ unəm nggo ka̱ ashe ìtong va̱ ta ká̱ ndokchi. Oza̱ re unəm uro fa ka̱t. Oza̱ nəm aDebir ká̱ uponzhiponzhi wa nva oza̱ ka̱ nəm âHebron, ká̱ aLibna ká̱ oponzhiponzhi. ");
INSERT INTO yer_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Te uJoshuwa nəm igwan ká̱ nkpaktak nkap mbin, nzəng ká̱ mbin ngga aɗuktum, ká̱ aNegep, ká̱ ovan oga aɗuktum aga asa̱l ntar alum, ká̱ ngga aba̱nda̱m, ká̱ nkpaktak oponzhi oza̱. Uza̱ re unəm uro fa ka̱t. Uza̱ zhì nkpaktak onəm oga irirì, wa nva uYawe, Inan oIsa̱rila ka̱ nak á. ");
INSERT INTO yer_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","UJoshuwa nəm igwan ká̱ oza̱ ɓan ka̱ aKadesh-Barneya a ga chu aGaza, ká̱ nkpaktak nkap mbin aGoshen, ga chu aGibiyon. ");
INSERT INTO yer_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Kang uJoshuwa nəm igwan ká̱ oponzhi va̱ ta̱ pa̱ kpaktak ká̱ oga mbin oza̱ ka̱ awalang pa̱ zəng, ka̱kul uYawe, Inan oIsa̱rila uwa kà̱ nlung ìkum ka̱kul onəm wò. ");
INSERT INTO yer_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Nnà chit te, uJoshuwa ká̱ nkpaktak oIsa̱rila le apa̱k ka̱ aGilgal ɗak. ");
INSERT INTO yer_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Ka̱ awalang va̱ uJabin uPonzhi uga aHazor fe nnap va̱ ta̱ te, uza̱ re ǹre ga ûJobap uponzhi uga aMadon, ká̱ uponzhi uga aShimron, ká̱ uponzhi uga aAkshap, ");
INSERT INTO yer_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","kang ká̱ oponzhi va̱ ka̱ asa̱l mpal ova ka̱ ashe oga aɓam, ka̱ aAraba aga nkwandal aKinnerot, ka̱ mbin oga avan aɗuktum aga asa̱l ntar alum, kang ká̱ aDor ka̱ asa̱l ntar alum, ");
INSERT INTO yer_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","ká̱ oKanana ka̱ asa̱l nfa alum ká̱ asa̱l ntar alum, ká̱ oAmori, ká̱ oHitti, ká̱ oPerizi, ká̱ oJebusi ka̱ mbin ngga aɗuktum, kang ká̱ oHivi va̱ ka̱ avəng aHermon ka̱ nkap mbin ngga aMizpa. ");
INSERT INTO yer_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Te oza̱ fa nzəng ka̱ nkpaktak onəm oga nnəm ìkum oza̱, nggatək pa̱ makmak wa ashishiri ka̱ anung ìwa, ká̱ oga ipəri, ká̱ oga akeke ipəri pa̱ makmak. ");
INSERT INTO yer_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Nkpaktak oponzhi va̱ ta̱ gwang ishi ka̱ anung nzəngtəng, ɓa ləp apa̱k ka̱ anung ndəng ngga aMerom pa̱ ó lung ìkum ká̱ oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Te uYawe là ûJoshuwa pa̱, <<Kang o nəm ayər oza̱ ka̱t, ka̱kul ìpin ká̱ atak wa nva̱ ta̱ te, mi na nkpaktak oza̱ ôIsa̱rila okúkú. Ó kyèn irəng ipəri oza̱ i gutum, kang ó pwak oga akeke ipəri oza̱.>> ");
INSERT INTO yer_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Te uJoshuwa ká̱ nkpaktak onəm ìkum wò, ɓa ká̱ ǹnyi oza̱ ka̱t, ru oza̱ ká̱ ìkum ka̱ anung ndəng aMerom. ");
INSERT INTO yer_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Kang uYawe na oza̱ ka̱ ashe awo oIsa̱rila. Oza̱ nəm igwan ká̱ oza̱ kang a ɓak oza̱ ga chu aSidon aChumchum, lyam ga aMisrefot Mayim, kang a ga chu aba̱nda̱m aMizpa ka̱ asa̱l nfa alum. Oza̱ re unəm uro fa ká̱ irirì ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","UJoshuwa nəm ôza̱ wa nva uYawe là á na. Uza̱ kyèn irəng ipəri oza̱ gutum, kang uza̱ pwak oga akeke ipəri oza̱. ");
INSERT INTO yer_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Ka̱ awalang va ta uJoshuwa le nva̱ng ga ri aHazor, kang a gbá̱l uponzhiponzhi ká̱ ndokchi. AHazor nna ka̱ yà atak achumchum n̂kpaktak oga iponzhi va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Oza̱ gbá̱ng nkpaktak onəm va̱ ka̱ ashishe ká̱ ndokchi. Oza̱ zhì oza̱ pa̱ chatchat, unəm uro yà oza̱ re ká̱ irirì ka̱t, kang oza̱ pwak aHazor. ");
INSERT INTO yer_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","UJoshuwa ri nkpaktak oga itong iga iponzhi va̱ ta, ká̱ oponzhiponzhi, kang a gbá̱ng oza̱ ká̱ ndokchi. Uza̱ zhì oza̱ pa̱ chatchat, wa nva uMusa uzwal aYawe ka̱ nak á. ");
INSERT INTO yer_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Ká̱ nnà te, itong va̱ mmá me ka̱ apal agəgər te, oIsa̱rila pwak ka̱t, aHazor na byet uJoshuwa pwak. ");
INSERT INTO yer_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Kang oIsa̱rila wur nkpaktak ndur itong va̱ ta ká̱ iya̱mkang, a sat iya̱m iga nwur ka̱ atak ìkum îshi oza̱. Ǹnyi te, oza̱ gbá̱ng nkpaktak onəm ká̱ ndokchi, a ga chu awalang va̱ oza̱ zhì oza̱ pa̱ chatchat. Oza̱ re unəm uro fa ká̱ irirì ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Wa nva uYawe nak ûMusa uzuzwal te, wa nnà ta uMusa nak ûJoshuwa. Kang uJoshuwa nəm wa nnà ta, uza̱ nəm nkpaktak iya̱m va̱ uYawe nak ûMusa. ");
INSERT INTO yer_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Te uJoshuwa nəm igwan ká̱ nkpaktak mbin va̱ ta, mbin ngga aɗuktum, ká̱ nkpaktak aNegep, ká̱ nkpaktak nkap mbin aGoshen, ká̱ mbin oga avan aɗuktum ka̱ asa̱l ntar alum, ká̱ aAraba, ká̱ oga aɓam aIsa̱rila ká̱ oga avan aɗuktum oza̱, ");
INSERT INTO yer_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","aɓang ka̱ aƁam aHalak va̱ ɓa ga asa̱l aSeyir, a ga chu aBal Gat ka̱ mba̱nda̱m aLebanon ka̱ avəng aƁam aHermon. Uza̱ wur nkpaktak oponzhi oza̱, kang a gbá̱ng oza̱. ");
INSERT INTO yer_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","UJoshuwa gba̱ng chit ka̱ nnəm ìkum ká̱ nkpaktak oponzhi va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Ìtong iro yà yar nsar nnap-nlà ntəm ikángkáng ká̱ onəm oga aIsa̱rila ka̱t, oHivi na byet, ova ka̱ ntəm ka̱ aGibiyon á. Nkpaktak aɓoshi itong te, oIsa̱rila ri ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Ka̱kul uYawe uwa nak igwak oza̱ twat, na oza̱ a ɓa ká̱ ìkum ka̱ oIsa̱rila, na ô zhì oza̱ pa̱ chatchat, ô zhì oza̱ nzəng ká̱ nyam nrusok afu ka̱t, wa nva uYawe ka̱ nak uMusa á. ");
INSERT INTO yer_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Ka̱ awalang va ta uJoshuwa ga zhì oAnakim, ova ka̱ ntəm ka̱ ashe mbin ngga aɗuktum, aHebron, ká̱ aDebir, ká̱ aAnap, ká̱ nkpaktak mbin ngga aɗuktum oYahuda, ká̱ nkpaktak mbin ngga aɗuktum oIsa̱rila. uJoshuwa zhì oza̱ pa̱ chatchat ká̱ itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Unəm uro yà le ka̱ ashe oAnakim va̱ ka̱ ntəm ka̱ ashe mbin oIsa̱rila ka̱t. Ka̱ aGaza, ká̱ aGat, ká̱ aAshdot na byet, aɓo oro le. ");
INSERT INTO yer_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Te uJoshuwa nəm igwan ká̱ nkpaktak mbin va̱ ta, wa nva uYawe ka̱ là ûMusa. Kang uJoshuwa na mbin va̱ ta iya̱mkup ôIsa̱rila ka̱ atak oga akum ìjili oza̱. Te mbin va̱ ta jul ka̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","OPonzhi va ta̱ ka̱ ashe oga mbin va̱ onəm oga aIsa̱rila ka̱ ri ká̱ ìkum, ova oza̱ ka̱m mbin oza̱ ka̱ asa̱l nfa alum agwong aUrdun, a ɓan ka̱ mba̱nda̱m ngga aArnon ga chu aƁam aHermon, nzəng ká̱ nkpaktak asa̱l nfa alum aAraba. ");
INSERT INTO yer_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","USihon uponzhi oAmori, uva ka̱ nəm iponzhi ka̱ aHeshbon. Iponzhiponzhi ɓan ka̱ aAroyer, va kà̱ nkur mba̱nda̱m aArnon, ɓan ká̱ ishimshe aba̱nda̱m va̱ ta ga chu awang aJabok ka̱ aswari oAmmon. Oga mbin va ta̱ nzəng ká̱ nkap kà̱ ishimshe aGileyat. ");
INSERT INTO yer_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","Uza̱ nəm iponzhi kpa ka̱ nkap mbin aAraba ka̱ asal nfa alum, a ɓan kà̱ ìWa aGalili, lyam ga ìWa aAraba, nna ìWa mMan á, ka̱ asa̱l nfa alum aBet Jeshimot, ka̱ asa̱l nkwandal ka̱ nkwangtal avəng aɓam aPisga. ");
INSERT INTO yer_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","Ká̱ mbin aOg uponzhi uga aBashan, Uzəngtəng ka̱ ashe aɓo onəm aRefayim, uva ka̱ nəm iponzhi ka̱ aAshtarot ká̱ aEdireyi á. ");
INSERT INTO yer_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","Uza̱ nəm iponzhi ká̱ nkap mbin aɓam aHermon, ká̱ aSaleka, ká̱ nkpaktak aBashan ga chu aswari oGeshuri, ká̱ oMakati, ká̱ nkap ka̱ ishimshe aGileyat ga chu aswari aSihon uponzhi uga aHeshbon. ");
INSERT INTO yer_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","UMusa, uzwal aYawe, ká̱ onəm oga aIsa̱rila ri oza̱ ká̱ ìkum. Kang uMusa, uzwal aYawe na mbin oza̱ iya̱mkup akum ìjili aRuben, ká̱ uGat, ká̱ nkap ka̱ ishimshe akum ìjili aManase. ");
INSERT INTO yer_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","Oponzhi va ta̱ oma mbin oza̱ uJoshuwa ka̱ onəm oga aIsa̱rila ri ká̱ ìkum ka̱ asa̱l ntar alum agwong aUrdun, ɓan ka̱ aBal Gat ka̱ mba̱nda̱m aLebanon ga chu aɓam aHalak, va̱ ga asa̱l aSeyir. Kang uJoshuwa na mbin oza̱ ôIsa̱rila sat iya̱mkup oza̱, ka̱ atak nkap akum ìjili oza̱. ");
INSERT INTO yer_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","Oga mbin nva̱ ta̱ nzəng ká̱ mbin ngga aɗuktum, ká̱ oga avan aɗuktum, ká̱ aAraba, ká̱ mba̱nda̱m, ká̱ ashe ǹzam, kang ká̱ aNegep. Oma oga mbin oHitti, ká̱ oAmori, ká̱ oKanana, ká̱ oPerizi, ká̱ oHivi, kang ká̱ oJebusi. ");
INSERT INTO yer_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","Oponzhi va̱ ta̱ te, oma uponzhi uga aJariko, ká̱ uponzhi uga aAyi, uva datkulung ká̱ aBetel, ");
INSERT INTO yer_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","ká̱ uponzhi uga aUrushelima, ká̱ uponzhi uga aHebron, ");
INSERT INTO yer_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ká̱ uponzhi uga aJarmut, ká̱ uponzhi uga aLakish, ");
INSERT INTO yer_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ká̱ uponzhi uga aEglon, ká̱ uponzhi uga aGezer, ");
INSERT INTO yer_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","ká̱ uponzhi uga aDebir, ká̱ uponzhi uga aGeder, ");
INSERT INTO yer_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ká̱ uponzhi uga aHorma, ká̱ uponzhi uga aArat, ");
INSERT INTO yer_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ká̱ uponzhi uga aLibna, ká̱ uponzhi uga aAdulam, ");
INSERT INTO yer_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","ká̱ uponzhi uga aMakeda, ká̱ uponzhi uga aBetel, ");
INSERT INTO yer_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ká̱ uponzhi uga aTapuwa, ká̱ uponzhi uga aHefer, ");
INSERT INTO yer_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","ká̱ uponzhi uga aAfek, ká̱ uponzhi uga aLasharon, ");
INSERT INTO yer_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","ká̱ uponzhi uga aMadon, ká̱ uponzhi uga aHazor, ");
INSERT INTO yer_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ká̱ uponzhi uga aShimron Meron, ká̱ uponzhi uga aAkshap, ");
INSERT INTO yer_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ká̱ uponzhi uga aTanak, ká̱ uponzhi uga aMegido, ");
INSERT INTO yer_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ká̱ uponzhi uga aKedesh, ká̱ uponzhi uga aJokneyam ka̱ aKarmel, ");
INSERT INTO yer_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ká uponzhi uga aDor ka̱ aNaphot Dor, ká̱ uponzhi uga aGoyim ka̱ aGilgal, ");
INSERT INTO yer_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","ká̱ uponzhi uga aTirza, pa̱ kpaktak te, oponzhi ìsəm pa̱ ishatɗing ama̱n pa̱ zəng. ");
INSERT INTO yer_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","Ka̱ awalang va̱ uJoshuwa gbák chit pa̱ gənggəng te, uYawe là á na pa̱, <<U gbák chit pa̱ gənggəng, kang mbín nna re pa̱ makmak nva̱ nna o ri chit ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","<<Oga mbin va ta̱ oma ɓur, nkpaktak nkap mbin oFilisti, ká̱ oGeshuri, ");
INSERT INTO yer_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","ɓan ka̱ Awang aShihor nna ka̱ asa̱l nfa alum aMasar, ga chu mbin aEkron ka̱ mpal, mmá kung oza̱ wa mbin oKanana. Oma mbin oponzhi pa̱ otukun oji oFilisti va̱ i nəm iponzhi ka̱ aGaza, ká̱ aAshdot, ká̱ aAshkelon, ká̱ aGat, kang ká̱ aEkron va̱ ka̱ mbin oAvi, ");
INSERT INTO yer_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","ka̱ asa̱l nkwandal. Nkpaktak mbin oKanana, va̱ ɓan ka̱ aMeyara va aji oSidon ga aAfek, ɓa chu aswari oAmori, ");
INSERT INTO yer_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","kang mbin oGebali, ká̱ nkpaktak aLebanon, ka̱ asa̱l nfa alum, ɓan ka̱ aBal Gat ka̱ avəng aƁam aHermon ga aLebo Hamat. ");
INSERT INTO yer_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","<<Nkpaktak onəm oga ntəm ka̱ oga nkap mbin ngga aɗuktum ɓan ka̱ aLebanon ga chu aMisrefot Mayim, nnà nkpaktak oSidon, te mmami ka̱ ishi mi, mi ɓak oza̱ ka̱ mpyal onəm oIsa̱rila. Ɗak na u kap mbin va̱ ta ôIsa̱rila a təm iya̱mkup oza̱, wa nva n nak ɓu á. ");
INSERT INTO yer_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","Ǹyangmata̱ te, kap mbin va̱ ta̱ iya̱mkup akum ìjili pa̱ fangzəngtəng va̱ ta̱ ká̱ nkap ka̱ ishimshe akum ìjili aManase.>> ");
INSERT INTO yer_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Aɓo nkap ka̱ ishimshe akum aManase, ká̱ oRuben, ká̱ oGat, ka̱ ka̱m iya̱mkup iji oza̱ chit nna uMusa ka̱ na ôza̱ ka̱ agwong aUrdun ka̱ asa̱l nfa alum. Iya̱m va ta na uMusa uzwal aYawe na ôza̱. ");
INSERT INTO yer_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","Mbin oza̱ ɓan ka̱ aAroyer va̱ ka̱ nkur mba̱nda̱m ngga aArnon, kang a ɓan ká̱ ìtong va̱ ká̱ ishimshe aba̱nda̱m va̱ ta, ka̱ nkpaktak agbagba aga aMedeba ga chu aDibon. ");
INSERT INTO yer_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","Kang ká̱ nkpaktak itong iji aSihon uponzhi oAmori, uva nəm iponzhi ka̱ aHeshbon, ga chu aswari onəm oAmmon. ");
INSERT INTO yer_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","Nzəng ká̱ aGileyat, ká̱ mbin oGeshuri, ká̱ oMakati, nkpaktak aƁam aHermon, kang ká̱ nkpaktak aBashan ga chu aSaleka, ");
INSERT INTO yer_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","nnà nkpaktak atak iponzhi aOg ka̱ aBashan, uva ka̱ nəm iponzhi ka̱ aAshtarot kang ká̱ aEdreyi. UOg uwa uga nkur anung ka̱ ashe oRefayim. Oma uMusa ka̱ ri oza̱ ká̱ ìkum kang a ɓàk oza̱. ");
INSERT INTO yer_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","Ǹnyi te, onəm oIsa̱rila ɓàk oGeshuri ká̱ oMakati ka̱t, nnà nak kang, oma ka̱ ntəm ka̱ ashe oIsa̱rila ɓa chu nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Ǹnyi te, akum ìjili aLawi na byet uMusa na iya̱mkup á na ka̱t. Ka̱ɗor nva̱ ta te, oza̱ i ya iya̱m-nrì oza̱ ka̱ atak oga iya̱m inana nləfər ûYawe, Inan oIsa̱rila, nna ta iya̱mkup iji oza̱, wa nva uYawe là ôza̱. ");
INSERT INTO yer_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","UMusa ka̱ na iya̱mkup chit âkum ìjili aRuben ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","Aswari oza̱ ɓan ka̱ aAroyer, va ka̱ nkur mba̱nda̱m ngga aAmon, kang kà̱ ìtong va̱ ka̱ ishimshe aba̱nda̱m va̱ ta, ká̱ nkpaktak agbagba va̱ lyam aMedeba, ");
INSERT INTO yer_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","ga aHeshbon, ká̱ nkpaktak itutong va̱ ka̱ agbagba, nna aDibon, ká̱ aBamot Bal, ká̱ aBet Bal Meyon, ");
INSERT INTO yer_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","ká̱ aJahaz, ká̱ aKedemot, ká̱ aMefayat, ");
INSERT INTO yer_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","ká̱ aKiriyatayim, ká̱ aSibmak, ká̱ aZeret Shahar va ka̱ apal aɗuktum ka̱ ashe mba̱nda̱m va̱ ta, ");
INSERT INTO yer_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","ká̱ aBet Peyor, mba̱nda̱m ngga aPisga, ká̱ aBet Jeshimot, ");
INSERT INTO yer_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","ká̱ nkpaktak itong va̱ ka̱ agbagba va̱ ta̱, kang ká̱ nkpaktak mbin iponzhi aSihon, uponzhi uga oAmori, uva nəm iponzhi ka̱ aHeshbon. UMusa ka̱ ri na ká̱ ìkum ká̱ onəm oga mpyal oMidiyan, uEvi ká̱ uRekem, ká̱ uZur ká̱ uHur, ká̱ uReba, oma ovan oponzhi va̱ kà̱ ntəm nzəng ká̱ uSihon ka̱ ashe nkap mbin va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","Kang uBalam, uya aBeyor, unəm uga nəm iva̱k, uwa yà ka̱ ashe onəm va̱ oIsa̱rila gbá̱ng ká̱ ndokchi kpa. ");
INSERT INTO yer_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","AUrdun nna aswari akum ìjili aRuben. Itong va̱ ta̱ ká̱ ivan itong oza̱ nna iya̱mkup akum ìjili aRuben ka̱ atak akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","UMusa ka̱ na iya̱mkup chit âkum ìjili aGat kpa, uza̱ na oza̱ ka̱ atak akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","Aswari oza̱ nna aJazer ká̱ nkpaktak itong aGileyat, ká̱ nkap ìshimshe mbin oAmori ga chu aAroyer va ka̱ asa̱l nfa alum dat ká̱ aRaba, ");
INSERT INTO yer_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","kang ɓan ka̱ aHeshbon ga aRamat Mizpa ká̱ aBetonim, kang ɓan ka̱ aMahanayim ɓa chu aswari aga aDebir. ");
INSERT INTO yer_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","Ká̱ mba̱nda̱m va̱ aBet Haram, aBet Nimra, aSukkot, ká̱ aZafon, ká̱ aɓo nkap mbin aSihon, uponzhi uga aHeshbon, awang aUrdun nna nkur aswari mbin oza̱, vang asa̱l mpal ìWa aGalili, kang le ga asa̱l nfa alum. ");
INSERT INTO yer_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","Itong va̱ ta̱ ká̱ ivan itong oza̱ nna iya̱mkup akum ìjili aGat ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","UMusa ka̱ na iya̱mkup chit n̂kap ká̱ ìshimshe akum ìjili aManase, ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","Aswari oza̱ ɓan ka̱ aMahanayim, kang nzəng ká̱ nkpaktak aBashan, nkpaktak nkap mbin iponzhi aOg uponzhi uga aBashan, ká̱ nkpaktak itong ìsəm pa̱ ikpa̱ɗing iga aJayir ka̱ aBashan, ");
INSERT INTO yer_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","kang nkap ká̱ ìshimshe aGileyat, ká̱ aAshtarot, ká̱ aEdreyi, itong iga nnəm iponzhi aOg ka̱ aBashan. Nkpaktak itong va̱ ta̱ mmá na âkum ìjili aMakir uya aManase ununggwan ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","Ka̱ asa̱l va ta̱ uMusa kap iya̱mkup ká̱ ka̱ agbagba aMowap, ka̱ gwong aUrdun ka̱ asa̱l nfa alum aJariko. ");
INSERT INTO yer_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","Ǹnyi te, uMusa na iya̱mkup akum ìjili aLawi ka̱t. ka̱kul uYawe, Inan oIsa̱rila uwa iya̱mkup oza̱, wa nva uza̱ ka̱ yar nsar nnap-nlà ôza̱. ");
INSERT INTO yer_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","Oga atak va ta̱ mma na onəm oga oIsa̱rila iya̱mkup, ka̱ ashe mbin aKanana, va uEleyazar, unəm uga mpyal awop, ká̱ uJoshuwa uya aNun ununggwan, ká̱ onəm oga mpyal akum ìjili oIsa̱rila kap ôza̱ iya̱mkup. ");
INSERT INTO yer_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","Wa nva uYawe ka̱ nak ûMusa te, akum ìjili aga fangzəngtəng va̱ ta̱ ká̱ nkap kà̱ ìshimshe akum ìjili ka̱m iya̱mkup iji oza̱ ká̱, ka̱ asa̱l ntar alum ka̱ atak mmàng ayàk. ");
INSERT INTO yer_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","Ka̱kul uMusa ka̱ na iya̱mkup chit âkum ìjili aga aparəm ká̱ nkap kà̱ ìshimshe akum ìjili va̱ ta ka̱ asa̱l nfa alum awang aUrdun, ǹnyi te, uza̱ na iya̱mkup oLawi ka̱ ashe aɓo oga akum ìjili jiwò ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","Akum ìjili aYusufu, kap akum pa̱ parəm, uManase ká̱ uEfrayim. Mmá na iya̱mkup ôLawi ka̱ ashe mbin va̱ ta ka̱t, ka̱ɗor nva̱ ta te, mmá na itong oza̱ iva̱ oza̱ i təm kà̱, ká̱ oga ǹzam ka̱kul nkpak ina ká̱ iya̱mkang oza̱. ");
INSERT INTO yer_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","OIsa̱rila kap mbin va̱ ta, wa nva uYawe ka̱ nak uMusa á. ");
INSERT INTO yer_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","N̂da nro te, onəm oga aYahuda ɓa atak aJoshuwa ka̱ aGilgal, kang uKalip uya aJefune unəm oKeni, là á na pa̱, << Rəng ká̱ nnap-nlà va̱ uYawe ka̱ là ûMusa, unəm Inan ka̱ apal mi ka̱ ɓu, ka̱ aKadesh Barneya. ");
INSERT INTO yer_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Mmami ká̱ ìzun ìsəm pa̱ ineɗing awalang va̱ uMusa, uzwal aYawe ka̱ re mi ka̱ aKadesh Barneya pa̱ n sòng mbin va̱ ta. Kang m ɓa ká̱ ama̱n aga nnandər va̱ ka̱ ashe igwak mi. ");
INSERT INTO yer_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Ǹnyi te, ogənang mi va̱ ga nzəng ka̱ mi nak igwak onəm rusok. Ka̱ nna te, n kpán uYawe, Inan mi ká̱ nkpaktak ìgwak mi. ");
INSERT INTO yer_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Te n̂da va̱ ta uMusa sóng anung a mi pa̱, <Nkpaktak mbin va̱ ashar ɓu tongchi kà̱ te, i təm iya̱mkup ɓu ká̱ ovan ɓu mbyet, ka̱kul u kpán uYawe Inan mi ká̱ nkpaktak ìgwak ɓu.> ");
INSERT INTO yer_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","<<Dər, wa nva̱ uYawe ka̱ yar nsar nnap-nlà te, uwa a re mi ká̱ irirì ìzun ìsəm pa̱ ineɗing ama̱n pa̱ tukun, á ɓan ka̱ awalang va̱ uza̱ là nnap-nlà va̱ ta̱ ûMusa, ya oIsa̱rila oma ka̱ nranggang ka̱ ashe nzam. Kang ǹyangmata̱ te, mmami ká̱ ìzun ìsəm pa̱ ina̱nne ama̱n pa̱ tukun. ");
INSERT INTO yer_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","N̂da ta̱ na nkəkam wa nra va̱ uMusa ka̱ re mi ká̱, kang ǹyangmata̱ nna n yà ká̱ ìkàm iga ngga ìkum wa nva ka̱ n yà matmat á. ");
INSERT INTO yer_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Ǹyangmata̱ te, na mbin ngga aɗuktum va̱ ta̱ a mi, wa nva uYawe ka̱ yar nsar nnap-nlà a mi ká̱ nda va̱ ta. Mmaɓu ká̱ ishi ɓu, ka̱ u fife pa̱ oAnakim oma ka̱ ta, ká̱ inang itong oza̱ iva ká̱ akamsəlang. Ǹnyi te, ká̱ nka̱mshi aYawe te, mi ɓak oza̱ wa nva uza̱ ka̱ là á.>> ");
INSERT INTO yer_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Te uJoshuwa nak nnap-nnəna̱n ûKalip, uya aJefune ununggwan kang uza̱ na aHebron á na sat iya̱mkukup. ");
INSERT INTO yer_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Te aHebron təm iya̱mkup akum ìjili aKalip uya aJefune ununggwan unəm oKeni ɓa chu nda va̱ ta̱, ka̱kul uza̱ kpán uYawe, Inan oIsa̱rila ká̱ nkpaktak ìgwak wò. ");
INSERT INTO yer_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Ká̱ mmatmat te, mí wor aHebron pa̱ aKiriyat Arba. UArba va̱ ta te, unəm uchumchum ka̱ ashe oAnakim. Te mbin va̱ ta jul ká̱ nlung ìkum. ");
INSERT INTO yer_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","Mbin va̱ mmá na akum ìjili aYahuda ka̱ atak akum oza̱ te, a ɓan ka̱ nkwandal aswari nkap mbin aEdom, a ga chu nkwandal nzam aZin. ");
INSERT INTO yer_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","Aswari oza̱ aga nkwandal ɓan ka̱ nkur akongkong ìWa mMan, va dər nkwandal, ");
INSERT INTO yer_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","a ga mpyal ka̱ nkwandal ka̱ asa̱l aAkrabim, watar ga nzam aZin, ga nkwandal ká̱ aKadesh-Barneya, a watar asa̱l aHezron kyen ga aAdar kang ga̱ɓa̱n ga aKarka. ");
INSERT INTO yer_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","Te a watar ga aAzmon, wòl aWang aMasar a ɓa kur ka̱ ìwa aMeditereniya. Nna ta aswari oza̱ aga asa̱l nkwandal. ");
INSERT INTO yer_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","Aswari aga asa̱l nfa alum a ɓan ka̱ ìWa mMan, a ɓa anung aUrdun. Aswari aga asa̱l mpal te, a ɓan ka̱ anung ìWa mMan ka̱ atak va̱ aWang aUrdun i nang iga ashe ìwa. ");
INSERT INTO yer_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","Te aswari va̱ ta kyen ɓa aBet-Hogla a ga asa̱l mpal aBet-Araba, a le kyen ga ìPang aBohan, uya aRuben ununggwan. ");
INSERT INTO yer_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","Aswari kyen ga aDebir ɓan ka̱ mba̱nda̱m ngga aAkor, kang a ga̱ɓa̱n asa̱l mpal ga aGilgal, va mal ikoksok ká̱ asa̱l aAdummim va ka̱ nkwandal ngba̱k mba̱nda̱m va̱ ta. Te aswari va̱ ta watar ga atak mɓəl ndəng aEn-Shemesh a ɓa fa ka̱ aEn-Rogel. ");
INSERT INTO yer_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","Te aswari kyen ga mba̱nda̱m aBen-Hinnom ka̱ asa̱l nkwandal aba̱nda̱m oJebusi, nna aUrushelima á. A wong ka̱ ta te, a kyen ga apal aɗuktum va̱ ka̱ asa̱l ntar alum aba̱nda̱m aHinnom ka̱ asa̱l mpal nkur mba̱nda̱m ngga aRefayim. ");
INSERT INTO yer_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","A wong ka̱ apal aɗuktum te, aswari va̱ ta lyam ga atak mɓəl ndəng ngga aNeptowa, te a fa ga itong va̱ dat ká̱ aƁam aEpron, kang a ga̱ɓa̱n ga aBayala, nna aKiriyat-Jeyarim. ");
INSERT INTO yer_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","Te a kandar ga asa̱l ntar alum aBayala ga aƁam aSeyir, te a wol asa̱l mpal aƁam aJeyarim, nna aKesalon á, kang a fə́r ga aBet-Shemesh, te a watar ga aTimna. ");
INSERT INTO yer_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","A watar ga nkwangtal aEkron ka̱ asa̱l mpal, kang a ga̱ɓa̱n ga aShikkeron, te a lyam ka̱ ngba̱k aƁam aBayala, a ga chu aJabneyel. Te aswari va̱ ta ɓa kur ka̱ ìWa aMeditereniya. ");
INSERT INTO yer_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","Kang aswari aga asa̱l ntar alum, ka̱ inang ìwa va̱ ta. Nnà ta aswari va̱ gang akum ìjili aYahuda ka̱ atak akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Wa nva uYawe ka̱ nak ûJoshuwa te, uza̱ kpál atak ka̱ ashe mbin onəm aYahuda na ûKalip uya aJefune ununggwan. Kang uza̱ na aKiriyat-Arba á na, nna mí wor pa̱ aHebron. UArba te, uwa upo oAnakim. ");
INSERT INTO yer_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Te uKalip ɓak akum aAnak pa̱ oshatɗing ka̱ aHebron, oma uSheshayi, ká̱ uAhiman, ká̱ uTalmayi. ");
INSERT INTO yer_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Uza̱ wong ka̱ ta te, uza̱ ga ru onəm oga ntəm ka̱ aDebir ká̱ ìkum, ka̱ yà te, mí wor aDebir pa̱ aKiriyat-Sefer. ");
INSERT INTO yer_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Kang uKalip là pa̱, <<Unəm va pa̱ kap a ri aKiriyat-Sefer ká̱ ìkum te, mi na uyen mi uAksa á na kà̱ ivang.>> ");
INSERT INTO yer_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","UOtniyel uya aKenaz ununggwan, ugənang aKalip ri ìtong va̱ ta ká̱ ìkum. Te uKalip na uyen wò uchar uAksa á na kà̱ ivang. ");
INSERT INTO yer_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Ka̱ nva̱ngva̱ uza̱ ga atak aɓar wò te, uza̱ nok na pa̱ uza̱ á ɓəp iram ka̱ upo wò. Awalang va̱ uAksa fər ka̱ apal azhaki wò te, uKalip ɓəp na pa̱, <<Iza̱ mi nəm a ɓu yà?>> ");
INSERT INTO yer_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","Uza̱ na ama̱n a na pa̱, <<pa̱r mi, ka̱kul u na mbin a mi chit ka̱ aNegep, n chal pa̱ u na oga atak mɓəl ndəng á mi kpa.>> Te uKalip na oga atak aga mɓəl ndəng á na ngga apal ká̱ ngga avəng. ");
INSERT INTO yer_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","Iya̱mkup onəm aYahuda nnà ta̱ ka̱ atak akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","Itong va ta̱ mmá na akum ìjili aYahuda iva ka̱ asa̱l nkwandal va̱ datkulung ká̱ aswari aEdom, oma aKapzeyel, ká̱ aEder, ká̱ aJagur, ");
INSERT INTO yer_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","ká̱ aKina, ká̱ aDimona, ká̱ aAdada, ");
INSERT INTO yer_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","ká̱ aKadesh, ká̱ aHazor, ká̱ aItnan, ");
INSERT INTO yer_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","ká̱ aZip, ká̱ aTelem, ká̱ aBeyalot, ");
INSERT INTO yer_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","ká̱ aHazor-Hadata, ká̱ aKiriyot-Hezron, nna aHazor á, ");
INSERT INTO yer_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","ká̱ aAmam, ká̱ aShema, ká̱ aMolada, ");
INSERT INTO yer_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","ká̱ aHazar-Gada, ká̱ aHeshmon, ká̱ aBet-Pelet, ");
INSERT INTO yer_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","ká̱ aHazar-Shuwal, ká̱ aBeyersheba, ká̱ aBiziyotiya, ");
INSERT INTO yer_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","ká̱ aBayala, ká̱ aLim, ká̱ aEzem, ");
INSERT INTO yer_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","ká̱ aEltolat, ká̱ aKesil, ká̱ aHorma, ");
INSERT INTO yer_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","ká̱ aZiklak, ká̱ aMatmanna, ká̱ aSansanna, ");
INSERT INTO yer_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","ká̱ aLebayot, ká̱ aShilhim, ká̱ aAyin, ká̱ aRimmon. Pa̱ kpaktak te, itong ìsəm pa̱ iparəm ama̱n pa̱ fangzəngtəng nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","Itong iga avan aɓam te, oma aEshtawol, ká̱ aZora, ká̱ aAshna, ");
INSERT INTO yer_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","ká̱ aZanowa, ká̱ aEn-Ganim, ká̱ aTapuwa, ká̱ aEnam, ");
INSERT INTO yer_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","ká̱ aJarmut, ká̱ aAdulam, ká̱ aSoko, ká̱ aAzeka, ");
INSERT INTO yer_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","ká̱ aShayarayim, ká̱ aAditayim, ká̱ aGedera, ká̱ aGederotayim. Pa̱ kpaktak te, itong pa̱ igba̱pchi ama̱n pa̱ neɗing nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","Mmá na itong va̱ ta̱ âkum ìjili aYahuda kpa, oma aZenan, ká̱ aHadasha, ká̱ aMikdal-Gat, ");
INSERT INTO yer_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","ká̱ aDileyan, ká̱ aMizpa, ká̱ aJokteyel, ");
INSERT INTO yer_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","ká̱ aLakish, ká̱ aBozkat, ká̱ aEglon, ");
INSERT INTO yer_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","ká̱ aKapbon, ká̱ aLahmas, ká̱ aKitlish, ");
INSERT INTO yer_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","ká̱ aGederot, ká̱ aBet-Dagon, ká̱ aNayama, ká̱ aMakeda. Pa̱ kpaktak te, itong pa̱ igba̱pchi ama̱n pa̱ kpa̱ɗing nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","Mmá na itong va̱ ta̱ âkum ìjili aYahuda kpa, oma aLibna, ká̱ aEter, ká̱ aAshan, ");
INSERT INTO yer_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","ká̱ aIpta, ká̱ aAshna, ká̱ aNezip, ");
INSERT INTO yer_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","ká̱ aKeyila, ká̱ aAkzip, ká̱ aMaresha. Pa̱ kpaktak te, itong pa̱ fangzəngtəng nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","Mmá na aEkron ká̱ itong va̱ gáng na nzəng ká̱ ivan itutong âkum ìjili aYahuda kpa, ");
INSERT INTO yer_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","ká̱ nkpaktak itong va̱ datkulung ká̱ aAshdot, ɓan ka̱ ntar alum aEkron nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","AAshdot, ká̱ itutong nzəng ká̱ ivan itutong, kang aGaza, ká̱ itutong nzəng ká̱ ivan itutong, a ga chu aWang aMasar, ká̱ anung ìWa aMeditereniya. ");
INSERT INTO yer_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","Mmá na itong âkum ìjili aYahuda ka̱ ashe mbin ngga aɗuktum kpa, oma aShamir, ká̱ aJatir, ká̱ aSoko, ");
INSERT INTO yer_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","ká̱ aDanna, ká̱ aKiriyat-Sefer, nna aDebir á, ");
INSERT INTO yer_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","ká̱ aAnap, ká̱ aEshtemo, ká̱ aAnim, ");
INSERT INTO yer_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","ká̱ aGoshen, ká̱ aHolon, ká̱ aGilo. Pa̱ kpaktak te, itong pa̱ igba̱pchi ama̱n pa̱ zəng nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","Mmá na itong va̱ ta̱ âkum ìjili aYahuda kpa, oma aArap, ká̱ aDuma, ká̱ aEshan, ");
INSERT INTO yer_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","ká̱ aJanim, ká̱ aBet-Tapuwa, ká̱ aAfeka, ");
INSERT INTO yer_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","ká̱ aHumta, ká̱ aKiriyat-Arba, nna aHebron á, ká̱ aZiyor. Pa̱ kpaktak te, itong pa̱ fangzəngtəng nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","Mmá na itong va̱ ta̱ âkum ìjili aYahuda kpa, oma aMayon, ká̱ aKarmel, ká̱ aZip, ká̱ aJutta, ");
INSERT INTO yer_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","ká̱ aJezireyel, ká̱ aJokdeyam, ká̱ aZanowa, ");
INSERT INTO yer_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","ká̱ aKayin, ká̱ aGibeya, ká̱ aTimna. Pa̱ kpaktak te, itong pa̱ igba̱pchi ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","Mmá na itong va̱ ta̱ âkum ìjili aYahuda kpa, oma aHalhul, ká̱ aBet-Zur, ká̱ aGedor, ");
INSERT INTO yer_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","ká̱ aMayarat, ká̱ aBet-Anot, ká̱ aEltekon. Pa̱ kpaktak te, itong pa̱ ìkpa̱ɗing nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","Mmá na itong va̱ ta̱ âkum ìjili aYahuda kpa, oma aKiriyat-Bayal, nna aKiriyat-Jeyarim á, ká̱ aRapba. Pa̱ kpaktak te, itong pa̱ iparəm nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","Mmá na itong âkum ìjili aYahuda kpa ka̱ ashe ǹzam, oma aBet-Araba, ká̱ aMitdin, ká̱ aSekaka, ");
INSERT INTO yer_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","ká̱ aNipshan, ká̱ ìtong iga Mman, ká̱ aEn-Gedi. Pa̱ kpaktak te, itong pa̱ ìkpa̱ɗing nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","Ǹnyi te, oJebusi va̱ ka̱ ntəm ka̱ aUrushelima te, a ma̱t onəm aYahuda ka̱ mɓak nfa, a nak te, oJebusi oma ka̱ ntəm nzəng ká̱ onəm aYahuda ka̱ ashe aUrushelima nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","Mbin va̱ mmá na akum ìjili aYusufu te, ɓan ka̱ aUrdun ka̱ asa̱l nfa alum oga atak mɓəl ndəng ngga aJariko, a kyen ga nzam mmaləng a ɓa chu mbin ngga aɗuktum ngga aBetel. ");
INSERT INTO yer_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","A wong ka̱ aBetel, nna aLuz á, kang a watar ɓa chu aAtarot ka̱ mbin oArki. ");
INSERT INTO yer_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","Te a kwangtal ga asa̱l ntar alum ɓa chu mbin oJapleti, ga chu nkap mbin aBet-Horon ngga aVəng te, a lyam ga aGezer kang a kur ka̱ ìWa aMeditereniya. ");
INSERT INTO yer_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","Te akum ìjili aYusufu, uManase ká̱ uEfrayim, ka̱m iya̱mkup iji oza̱. ");
INSERT INTO yer_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","Mbin va ta̱ ka̱ yà nji aEfrayim ka̱ atak oga akukum. Aswari aga mbin ngga iya̱mkup oza̱, wong ka̱ aAtarot-Atdar ka̱ asa̱l nfa alum a kyen ga aBet-Horon aga aPal, ");
INSERT INTO yer_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","te aswari va̱ ta fa ga ìWa aMeditereniya. Ka̱ aMikmetat ka̱ asa̱l mpal te, a ga̱ɓa̱n ga asa̱l nfa alum a ɓa chu aTanat-Shilo, te a watar ka̱ asa̱l nfa alum ɓa chu aJanowa. ");
INSERT INTO yer_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","A wong ka̱ aJanowa te, a kwangtal ga aAtarot ká̱ aNayara, te a ga gwang aJariko, kang a ga fa ka̱ aUrdun. ");
INSERT INTO yer_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","Ka̱ aTapuwa te, aswari wòl asa̱l ntar alum ga aWang aKana, kang a kur ka̱ ìWa aMeditereniya. Nnà ta̱ ka̱ yà iya̱mkup akum ìjili aEfrayim ka̱ atak oga akukum. ");
INSERT INTO yer_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","Mbin va̱ ta gwang ká̱ nkpaktak itong nzəng ká̱ ivan itong oza̱ va̱ mmá ka̱ re ka̱kul akum ìjili aEfrayim ka̱ ashe iya̱mkup akum ìjili aManase. ");
INSERT INTO yer_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","Oza̱ ɓàk oKanana va̱ ka̱ ntəm ka̱ aGezer ka̱t, ka̱kul nva̱ ta te, oKanana oma ka̱ ntəm nzəng ká̱ oEfrayim nda ta̱. Ǹnyi te, mmá nak nkpak ôza̱ pa̱ a nəm inok wa ozwal. ");
INSERT INTO yer_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","Mmá na iya̱mkup âkum ìjili aManase, uya aYusufu uga nggəshi. Mmá na aGileyat ká̱ aBashan ûMakir uya aManase uga nggəshi upo oGileyat, ka̱kul pa̱ oza̱ ununggwan ìkum okamkam. ");
INSERT INTO yer_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","Te mmá kap iya̱mkup aɓo onəm aManase ka̱ atak akum oza̱, oma uAbiyezer, ká̱ uHelek, ká̱ uAsriyel, ká̱ uShekem, ká̱ uHefer, ká̱ uShemida. Oma ta̱ ovan aManase onunggwan uya aYusufu, ka̱ atak akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","Ǹyangmata̱ te, uZelofehat uya aHefer ununggwan, uya aGileyat ununggwan, uya aMakir ununggwan, uya aManase ununggwan yà ka̱ ovan onunggwan ka̱t. Ǹnyi te, ovan ochar ma chwat, oma aɗin oza̱ pa̱, uMala, ká̱ uNowa, ká̱ uHokla, ká̱ uMilka, ká̱ uTirza. ");
INSERT INTO yer_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","Oza̱ ga atak aEleyazar unəm uga mpyal awop, ká̱ uJoshuwa uya aNun ununggwan, ká̱ onəm oga mpyal, oza̱ là pa̱, <<UYawe nak uMusa pa̱ á na iya̱mkup a yi nzəng ká̱ ogənang yi>> Te uJoshuwa na iya̱mkup ôza̱ nzəng ká̱ ogənang apo oza̱ onunggwan, wa nva uYawe nak á. ");
INSERT INTO yer_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","UManase yà nkap pa̱ ngba̱pchi, nzəng ká̱ mbin aGileyat ká̱ aBashan, va̱ ka̱ asa̱l nfa alum agwong aUrdun, ");
INSERT INTO yer_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","ka̱kul ovan ochar oga akum ìjili aManase yà iya̱mkup nzəng ká̱ ovəvan onunggwan. Mbin aGileyat təm nji aɓo akum ìjili aManase. ");
INSERT INTO yer_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","Mbin aManase ɓan ka̱ aAsher a ɓa chu aMikmetat va ka̱ asa̱l nfa alum aShekem á. Kang aswari va̱ ta fa ga asa̱l nkwandal gwang ká̱ onəm oga ntəm ka̱ aEn-Tapuwa. ");
INSERT INTO yer_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","Mbin ngga aTapuwa te, nji aManase, ǹnyi te, ìtong iga aTapuwa ka̱ aswari aManase te, iji onəm aEfrayim. ");
INSERT INTO yer_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","Te aswari lyam ga aWang aKana. Itong na yà iji aEfrayim ka̱ ashe itong aManase. Ǹnyi te, aswari aManase wòl ngba̱k ngga asa̱l mpal awang, kang a ga kur ka̱ ìWa aMeditereniya. ");
INSERT INTO yer_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","Mbin ngga asa̱l nkwandal te, nji aEfrayim, kang ngga asa̱l mpal te, nji aManase. Mbin aManase ga chu ìWa aMeditereniya, kang a nəm aswari ká̱ aAsher ka̱ asa̱l mpal, kang ká̱ aIsakar ka̱ asa̱l nfa alum. ");
INSERT INTO yer_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","Ka̱ ashe mbin akum ìjili aIsakar ká̱ aAsher te, uManase uwa ká̱ aBet-Sheyan, ká̱ aIbleyam, ká̱ onəm oga ntəm ka̱ aDor nna aNafot á, ká̱ aEn-Dor ká̱ aTanak ká̱ aMegitdo nzəng ká̱ ivan itong va̱ gáng oza̱. ");
INSERT INTO yer_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","Ka̱ nna te, nka̱m itong va̱ ta̱ ma̱t onəm aManase ma̱t. Ka̱kul oKanana zhet pa̱ o təm ka̱ ashe mbin va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","Awalang va̱ onəm oIsa̱rila kam pa̱ gənggəng te, oza̱ nak inok iga nkpak oKanana, nnyi te oza̱ ɓak oza̱ fa ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","Te onəm aYusufu là ûJoshuwa pa̱, << Iza̱ nak kang u na nkap iya̱mkup a yi pa̱ nzəng na byet yà? Mmayi pa te, onəm va yəl pa̱ kyák ka̱kul pa̱ uYawe nak nnap-nnəna̱n a yi chit.>> ");
INSERT INTO yer_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","Te uJoshuwa na a ma̱n ôza̱ pa̱, <<A yà pa̱ mmawó onəm yəlyəl kang mbin ngga aɗuktum aEfrayim ayiyen ká̱ wo te, o ga ashe ǹzam mbin oPerizi ká̱ oRefayim, na o mwak mpwom îshi wó ka̱ ta.>> ");
INSERT INTO yer_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","Onəm aYusufu na ama̱n pa̱, << Mbin ngga aɗuktum kur yi ka̱t. Kang nkpaktak oKanana va̱ ka̱ ntəm ka̱ agbagba va̱ ta, oma ká̱ oga akeke ipəri iga acham, ká̱ ovəngva̱ ka̱ aBet-Shan ká̱ ivan itutong, ká̱ ovəngva̱ ka̱ mba̱nda̱m ngga aJezireyel.>> ");
INSERT INTO yer_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","Ǹnyi te, uJoshuwa là âkum ìjili aYusufu, uEfrayim, ká̱ uManase pa̱, << Ó yəl pa̱ kyák, kang ó kam pa̱ gənggəng. Te ó yà ka̱ nya nkap pa̱ nzəng na byet ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","Ǹnyi te, mbin ngga aɗuktum va̱ ka̱ ashe nzam i təm nji wó kpa, o gbá̱ng, kang o ka̱m pa̱ kpaktak i ga i chu aswariswari. Káp ká̱ nva̱, oKanana oma yà ká̱ akeke ipəri iga acham kang oza̱ kam te, o ga mɓàk oza̱ i fa.>> ");
INSERT INTO yer_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","Ka̱ nva̱ngva̱ nkpaktak nggatək onəm oIsa̱rila ri mbin va̱ ta chit te, oza̱ ɓut ka̱ aShilo kang oza̱ pak aghal aga mɓut ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","Ǹnyi te, akum ìjili pa̱ ifangshat ka̱ ashe oIsa̱rila oma ka̱ ka̱m iya̱mkup oza̱ chit ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","Te uJoshuwa là ônəm oIsa̱rila pa̱, <<Ó kali i gbà̱ng nva̱ng wa nsang, kang ó ɓan nka̱m mbin va̱ nna uYawe, Inan okəka wo na wo chit yà? ");
INSERT INTO yer_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","Ó na onunggwan a mi pa̱ oshatɗing ka̱ ashe nza̱ akum nggo. Mi ga nre oza̱ i ranggang i mal mbin va̱ ta ka̱ asa̱l awu va̱ mí kap iya̱mkup ká̱, kang oza̱ i le i ɓa atak mi. ");
INSERT INTO yer_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","Ó ga nkap mbin va̱ ta nkap pa̱ nfangshat. UYahuda i ga mpyal ka̱ ntəm ka̱ mbin ngga asa̱l nkwandal, kang akum ìjili aYusufu i təm ka̱ mbin oza̱ ka̱ asa̱l mpal. ");
INSERT INTO yer_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","Kà̱ nva̱ngva̱ ó cha ala̱ka̱n mbin va̱ ta chit nkap pa̱ ifangshat te, ó ɓa ká̱ á mi. Kang mi máng ayàk a wó ka̱ ta̱, ka̱ mpyal aYawe, Inan yi. ");
INSERT INTO yer_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","OLawi jiwò te, oza̱ yà ka̱ nkap ka̱ ashe wó ka̱t, ka̱kul inok onəm oga mpyal awop aYawe nna iya̱mkup oza̱. Kang uGat, ká̱ uRuben, ká̱ aɓo nkap ka̱ ishimshe akum ìjili aManase te, oza̱ ya iya̱mkup oza̱ chit ka̱ gwong aUrdun ka̱ asa̱l nfa alum, i va uMusa uzwal aYawe na ôza̱ á.>> ");
INSERT INTO yer_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","Onunggwan va̱ ta wong ga pa̱ na ó màl mbin va̱ ta te, uJoshuwa nak oza̱ pa̱, <<Ó ga, ó ranggang ka̱ ashe mbin va̱ ta pa̱ kpaktak, ó màl, ó lir ila̱ka̱n ka̱ apal ishishi, kang ó le atak mi. Te mi máng ayàk a wó ka̱ ta̱ ka̱ mpyal aYawe ka̱ aShilo.>> ");
INSERT INTO yer_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","Te onunggwan va̱ ta ga kang oza̱ ranggang ka̱ ashe mbin va̱ ta. Oza̱ lir ila̱ka̱n ka̱ apəpal ka̱ awa achəndərchəndər, oza̱ kap na ka̱ atak ìtong idongkong pa̱ ifangshat ka̱ ashe nlir, te oza̱ le atak aJoshuwa ka̱ ashe apa̱k ka̱ aShilo. ");
INSERT INTO yer_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","Kang uJoshuwa màng ayàk ôza̱ ka̱ mpyal aYawe ka̱ aShilo. Ka̱ ta na uJoshuwa kap mbin va̱ ta âɓo akum ìjili oIsa̱rila, nza̱ akum nggo ká̱ nkap nji wò. ");
INSERT INTO yer_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","Akum ìjili aBenjamin oma ya ayàk aga nggəshi ka̱ atak oga akum oza̱. Nva̱n mbin va̱ mmá na ôza̱ te, ka̱ ishimshe akum ìjili aYahuda ká̱ uYusufu. ");
INSERT INTO yer_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","Aswari oza̱ ka̱ asa̱l mpal te, a ɓan ka̱ aUrdun, kang a watar ga mba̱nda̱m aJariko ka̱ asa̱l mpal, te a kyen ga mbin ngga aɗuktum ka̱ asa̱l ntar alum, a ɓa chu nzam ngga aBet-Aven. ");
INSERT INTO yer_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","A wong ka̱ ta te, a pa̱l ga asa̱l nkwandal mba̱nda̱m ngga aLuz, nna aBetel á, kang a kwangtal vang aAtarot-Adar ka̱ apal aɗuktum va ka̱ asa̱l nkwandal aBet-Horon aga aVəng. ");
INSERT INTO yer_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","A wong ka̱ ta te, aswari ga̱ɓa̱n ga asa̱l ntar alum, a watar ga nkwandal aɗuktum va̱ ta ka̱ asa̱l ntar alum, kang a ɓa fa ka̱ aKiriyat-Bayal, nna aKiriyat-Jeyarim á. Ìtong va̱ ta̱ iji onəm aYahuda. Nna ta nkur aswari oza̱ ka̱ asa̱l ntar alum. ");
INSERT INTO yer_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","Aswari aga ngba̱k ngga asa̱l nkwandal ɓan ka̱ nkur aKiriyat-Jeyarim ka̱ asa̱l ntar alum, te a watar ga asa̱l nfa alum aEfron ka̱ atak mɓəl ndəng ngga aNeptowa. ");
INSERT INTO yer_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","Aswari va̱ ta kwangtal ga avəng aɗuktum va̱ ka̱ ndər mba̱nda̱m aBen-Hinnom, ka̱ asa̱l mpal mba̱nda̱m aRefayim á. A watar fa ga mba̱nda̱m aHinnom, ka̱ asa̱l nkwandal ìtong oJebusi, kang a ga aEn-Rogel. ");
INSERT INTO yer_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","Te a ga̱ɓa̱n ga asa̱l mpal ɓa aEn-Shemesh, kang a lyam ga aGelilot va̱ ka̱ ndər asa̱l va̱ kyen ga aAdummim. Kang a kwangtal ga ìPáng aBohan, uya aRuben ununggwan. ");
INSERT INTO yer_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","A watar ka̱ asa̱l mpal aBet-Araba kang a kwangtal ga ashe aAraba. ");
INSERT INTO yer_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","Te aswari va̱ ta watar fa ga asa̱l mpal aBet-Hokla, kang a ɓa fa ka̱ asa̱l mpal akongkong ìWa mMan, va̱ ndəng aUrdun i nang i tar ka̱ ashishe ka̱ asa̱l nkwandal. Nna ta ka̱ yà aswari aga asa̱l nkwandal. ");
INSERT INTO yer_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","AWang aUrdun nna aswari aga asa̱l nfa alum. Oma ta aswari iya̱mkup va̱ akum ìjili aBenjamin ya ka̱ nza̱ ngba̱k nggo. ");
INSERT INTO yer_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","Itong akum ìjili aBenjamin ka̱ atak oga akum oza̱, oma, aJariko, ká̱ aBet-Hokla, ká̱ aEmek-Kezit, ");
INSERT INTO yer_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","ká̱ aBet-Araba, ká̱ aZemarayim, ká̱ aBetel, ");
INSERT INTO yer_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","ká̱ aAvim, ká̱ aPara, ká̱ aOfəra, ");
INSERT INTO yer_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","ká̱ aKefar-Ammoni, ká̱ aOfəni, ká̱ aGeba. Pa̱ kpaktak te, itong pa̱ igba̱pchi ama̱n pa̱ parəm nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","Mmá na itong va̱ ta̱ âkum ìjili aBenjamin kpa, oma, aGibiyon, ká̱ aRama, ká̱ aBeyerot, ");
INSERT INTO yer_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","ká̱ aMizpa, ká̱ aKefira, ká̱ aMoza, ");
INSERT INTO yer_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","ká̱ aRekem, ká̱ aLərpeyel, ká̱ aTarala, ");
INSERT INTO yer_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","ká̱ aZela, ká̱ aHayelep, ká̱ ìtong oJebusi, nna aUrushelima á, ká̱ aGibeya, ká̱ aKiriyat. Pa̱ kpaktak te, itong pa̱ ìgba̱pchi ama̱n pa̱ neɗing nzəng ká̱ ivan itong oza̱. Nna ta iya̱mkup akum ìjili aBenjamin ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","Mmàng ayàk ngga mparəm a ru âkum ìjili aSimeyon, ka̱ atak oga akum oza̱. Kang iya̱mkup oza̱ lyam tar ka̱ ashe mbin akum ìjili aYahuda. ");
INSERT INTO yer_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","Oga atak iya̱mkup oza̱ oma, aBeyersheba, ká̱ aSheba, ká̱ aMolada, ");
INSERT INTO yer_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","ká̱ aHazar-Shuwal, ká̱ aBala, ká̱ aEzem, ");
INSERT INTO yer_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","ká̱ aEltolat, ká̱ aBetul, ká̱ aHorma, ");
INSERT INTO yer_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","ká̱ aZiklak, ká̱ aBet-Markabot, ká̱ aHazar-Susa, ");
INSERT INTO yer_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","ká̱ aBet-Lebayot, ká̱ aSharuhen. Pa̱ kpaktak te, itong pa̱ ìgba̱pchi ama̱n pa̱ shatɗing nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","Mmá na itong va̱ ta̱ âkum ìjili aSimeyon kpa, oma, aAyin, ká̱ aRimmon, ká̱ aEter, ká̱ aAshan. Pa̱ nkpaktak te, itong pa̱ ineɗing nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","Nzəng ká̱ nkpaktak ivan itong va̱ gang itong va̱ ta ga chu aBayalat-Beyer, nna aRama aga aNegep. Nna ta ka̱ yà iya̱mkup akum ìjili aSimeyon ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","Iya̱mkup akum ìjili aSimeyon mmá pà ka̱ ashe iya̱mkup aYahuda, ka̱kul nkap nji akum ìjili aYahuda mak ji nkam oza̱ ji. Te akum ìjili aSimeyon ka̱m iya̱mkup iji oza̱ ka̱ ishimshe iya̱mkup akum ìjili aYahuda. ");
INSERT INTO yer_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","Mmàng ayàk ngga nshatɗing a ru âkum ìjili aZebulun ka̱ atak oga akum oza̱. Aswari iya̱mkup oza̱ ga chu ìtong aSarit. ");
INSERT INTO yer_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","A wong ka̱ ta te, a wòl asa̱l ntar alum ga aMarala, ga chu aDapbeshet, ká̱ awang va̱ ka̱ asa̱l nfa alum aJokneyam. ");
INSERT INTO yer_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","Ka̱ aSarit a ga̱ɓa̱n dər asa̱l nfa alum a ga aswari aga aKislot-Tabor. Ka̱ ta te a ga wòl aDaberat, kang a kyen ga aJafiya. ");
INSERT INTO yer_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","Ka̱ ta te, a lyam ka̱ asa̱l nfa alum a ga aGat-Hefer, ká̱ aEt-Kazin, kang a ɓa fa ka̱ aRimmon, a ga̱ɓa̱n dər aNeya. ");
INSERT INTO yer_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","Ka̱ asa̱l mpal te, aswari va̱ ta ga̱ɓa̱n ga aHannaton, kang a kur ka̱ mba̱nda̱m ngga aIftah-El. ");
INSERT INTO yer_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","Oga atak iya̱mkup oza̱ oma, aKattat, ká̱ aNahalal, ká̱ aShimron, ká̱ aIdala, kang ká̱ aBet-Lehem. Pa̱ kpaktak te, itong pa̱ ìgba̱pchi ama̱n pa̱ parəm nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","Itong va̱ ta̱, nzəng ká̱ ivan itong oza̱, oma iya̱mkup akum ìjili aZebulun ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","Mmàng ayàk ngga nneɗing a ru âkum ìjili aIsakar ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","Mbin oza̱ oma, aJezireyel, ká̱ aKesulot, ká̱ aShunem, ");
INSERT INTO yer_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","ká̱ aHafarayim, ká̱ aShiyon, ká̱ aAnaharat, ");
INSERT INTO yer_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","ká̱ aRapbit, ká̱ aKishiyon, ká̱ aEbet, ");
INSERT INTO yer_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","ká̱ aRemet, ká̱ aEn-Gannim, ká̱ aEn-Hatda, ká̱ aBet-Patzet. ");
INSERT INTO yer_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","Aswari va̱ ta ga chu aTabor, ká̱ aShahazuma, ká̱ aBet-Shemesh, kang a ɓa kur ka̱ aWang aUrdun. Pa̱ kpaktak te, itong pa̱ ìgba̱pchi ama̱n pa̱ kpa̱ɗing nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","Itong va̱ ta̱, nzəng ká̱ ivan itong oza̱, oma, iya̱mkup akum ìjili aIsakar ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","Mmàng ayàk ngga ntukun a ru âkum ìjili aAsher ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","Mbin oza̱ oma, aHelkat, ká̱ aHali, ká̱ aBeten, ká̱ aAkshap, ");
INSERT INTO yer_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","ká̱ aAlammelek, ká̱ aAmat, ká̱ aMishal. Ka̱ asa̱l ntar alum te, aswari va̱ ta ga chu aKarmel, ká̱ aShihor-Lipnat, ");
INSERT INTO yer_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","te a ga̱ɓa̱n ga asa̱l nfa alum, kang a lyam ga aBet-Dagon, ga chu aZebulun, ká̱ mba̱nda̱m ngga aIftah-El, kang a ga asa̱l mpal ka̱ aBet-Emek ká̱ aNeyiyel. Te, a watar ka̱ asa̱l mpal ga aKabul. ");
INSERT INTO yer_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","Ká̱ aEbron, ká̱ aRehop, ká̱ aHammon, ká̱ aKana, ga chu aSidon aChumchum. ");
INSERT INTO yer_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","Te aswari va̱ ta ga̱ɓa̱n ga aRama, a ga chu ìtong aTaya iga akamsəlang, kang a ga̱ɓa̱n ga aHosa, te a kur ká̱ ìWa aMeditereniya ka̱ nkap mbin aMahalap ká̱ aAkzip, ");
INSERT INTO yer_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","ká̱ aUmma, ká̱ aAfek, ká̱ aRehop. Pa̱ kpaktak te, itong ìsəm pa̱ ìparəm ama̱n pa̱ parəm nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","Itong va̱ ta̱, nzəng ká̱ ivan itong oza̱, oma, iya̱mkup akum ìjili aAsher ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","Mmàng ayàk ngga nkpa̱ɗing a ru âkum ìjili aNaftali ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","Kang aswari oza̱ wong ka̱ aHelep, ka̱ inang ikún aOak va̱ ka̱ aZayanannim, a watar ga aAdami-Nekep, ká̱ aJapneyel ga chu aLakkum, kang a kur ka̱ aWang aUrdun. ");
INSERT INTO yer_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","Aswari va̱ ta ga̱ɓa̱n ka̱ asa̱l ntar alum ga aAznot-Tabor, kang a lyam ka̱ ta ga aHukkok, ga chu aZebulun ka̱ asa̱l nkwandal, aAsher ka̱ asal ntar alum, kang aYahuda ka̱ atak aWang aUrdun ka̱ asa̱l nfa alum. ");
INSERT INTO yer_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","Itong iga akamsəlang oma, aZitdim, ká̱ aZer, ká̱ aHammat, ká̱ aRakkat, ká̱ aKinneret, ");
INSERT INTO yer_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","ká̱ aAdama, ká̱ aRama, ká̱ aHazor, ");
INSERT INTO yer_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","ká̱ aKadesh, ká̱ aEdreyi, ká̱ aEn-Hazor, ");
INSERT INTO yer_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","ká̱ aYiron, ká̱ aMikdal-El, ká̱ aHorem, ká̱ aBet-Anat, ká̱ aBet-Shemesh. Pa̱ kpaktak te, itong pa̱ ìgba̱pchi ama̱n pa̱ fangzəngtəng nzəng ká̱ ivan itong oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","Itong va̱ ta̱, nzəng ká̱ ivan itong oza̱, oma, iya̱mkup akum ìjili aNaftali ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","Mmàng ayàk ngga nfangshat a ru âkum ìjili aDan, ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","Mbin ngga iya̱mkup oza̱ oma, aZora, ká̱ aEshtawol, ká̱ aIr-Shemesh, ");
INSERT INTO yer_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","ká̱ aShayalapbin, ká̱ aAijalon, ká̱ aItla, ");
INSERT INTO yer_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","ká̱ aElon, ká̱ aTimna, ká̱ aEkron, ");
INSERT INTO yer_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","ká̱ aElteke, ká̱ aGipbeton, ká̱ aBayalat, ");
INSERT INTO yer_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","ká̱ aJehut, ká̱ aBene-Berak, ká̱ aGat-Rimmon, ");
INSERT INTO yer_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","ká̱ aMe-Jarkon, ká̱ aRakkon, ká̱ mbin va̱ mal ìkwoksok ká̱ aJoppa. ");
INSERT INTO yer_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","Ka̱ nva̱ngva̱ akum ìjili aDan lang mbin oza̱ te, oza̱ ga ru aLeshem ká̱ ìkum, oza̱ ri na, oza̱ gbá̱ng onənəm ká̱ ndokchi, kang oza̱ təm ka̱ ashe mbin va̱ ta. Te, oza̱ ga̱ɓa̱n aɗiɗin i wor ká̱ aɗin akəka oza̱ uDan. ");
INSERT INTO yer_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","Itong va̱ ta̱, nzəng ká̱ ivan itong oza̱, oma, iya̱mkup akum ìjili aDan ka̱ atak oga akum oza̱. ");
INSERT INTO yer_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","Ka̱ nva̱ngva̱ oza̱ gba̱l ka̱ nkap mbin va̱ ta chit iya̱mkup ka̱ atak aswari oza̱ te, oIsa̱rila na ûJoshuwa uya aNun ununggwan iya̱mkup ijini ka̱ ashe iji oza̱, ");
INSERT INTO yer_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","wa nva̱ uYawe ka̱ nak. Te, oza̱ na ìtong va á na uza̱ ɓəp, nna aTimnat-Sera ka̱ mbin ngga aɗuktum aEfrayim. Kang uza̱ me ìtong va̱ ta ka̱ɗi, uza̱ təm ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","Oga mbin va ta̱ uEleyazar unəm uga mpyal awop, ká̱ uJoshuwa uya aNun ununggwan, ká̱ onəm oga mpyal oga akum oIsa̱rila kap iya̱mkup ká̱, ka̱ atak mmàng ayàk ka̱ aShilo ka̱ mpyal aYawe, ka̱ anung asa̱l aga ntar Aghal Mɓut. Wa nnà ta oza̱ gba̱l ka̱ nkap mbin va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","Te uYawe là ûJoshuwa pa̱, ");
INSERT INTO yer_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","<<Là ôIsa̱rila pa̱ ó yak itong ka̱kul atak mbwam îshi wó, wa nva ka̱ nlà a wó ka̱ atak aMusa á, ");
INSERT INTO yer_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","ka̱kul unəm va̱ pa̱ kpaktak a gba̱l unəm ka̱ ashe mməma̱n, ka̱t te ka̱ ashe ǹnyinyi ka̱t, te uza̱ i chə́r i ga ka̱ ta. Itong va̱ ta i yà atak mbwam a wó, ka̱ atak anəm uga nɗom mpyát akat nchə̀r. ");
INSERT INTO yer_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","Awalang va̱ uza̱ á chə́r a ga ìtong iro pa̱ izəng ka̱ ashe itong va̱ ta, te uza̱ i sat ka̱ anung asa̱l aga ntar ìtong va̱ ta, kang uza̱ i là ônəmgbak oga ìtong va̱ ta iya̱m va̱ ya na á. Te oza̱ i ka̱m na i tar ka̱ ka̱ ashe ìtong va̱ ta, oza̱ i na atak á na, kang uza̱ i təm ka̱ ashe oza̱. ");
INSERT INTO yer_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","A yà pa̱ unəm uga nɗom mpyát akat nchə̀r va̱ ta a wà nvəva̱ng te, onəmgbak oga ìtong va̱ ta i yà ká̱ nná unəm va̱ gba̱l unəm á na ka̱t, ka̱kul uza̱ gba̱l unəm uga nra datkulung ká̱ na ká̱ ǹnyinyi ka̱t, kang uza̱ ka̱ nkpàng na matmat ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","Uza̱ i təm ka̱ ashe ìtong va̱ ta i ga i chu awalang va̱ uza̱ i sat ka̱ mpyal nggatək ka̱kul nnap-akwali, ká̱ awalang va̱ unəm uchumchum uga mpyal awop uga nra va̱ ta ikú ká̱ kang. Nna chit te, unəm uga ngba̱l unəm va̱ ta i le, i ga nzhi wò ka̱ ashe ìtong va̱ uza̱ ka̱ chə́r kà̱.>> ");
INSERT INTO yer_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","Te oza̱ gar aKadesh ka̱ aGalili ka̱ mbin ngga aɗuktum aNaftali, ká̱ aShekem ka̱ mbin ngga aɗuktum aEfrayim, ká̱ aKiriyat-Arba, nna aHebron á, ka̱ mbin ngga aɗuktum aYahuda. ");
INSERT INTO yer_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","Ka̱ gwong aUrdun ka̱ asa̱l nfa alum aJariko te, oza̱ gar aBezer ka̱ ashe ǹzam ka̱ mbin ngga agbagba, ka̱ akum ìjili aRuben, ká̱ aRamot ka̱ aGileyat, ka̱ akum ìjili aGat, kang aGolan ka̱ aBashan, ka̱ akum ìjili aManase. ");
INSERT INTO yer_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","Itong va ta̱ mmá gar ka̱kul nkpaktak oIsa̱rila, ká̱ onəmchən va̱ ka̱ ntəm ka̱ ashe oza̱. Ka̱kul nkpaktak unəm va̱ gba̱l unəm ka̱ ashe mməma̱n ka̱t, te i chə́r i ga ka̱ ta, na kang unəm uga nɗom mpyát akat nchə̀r a gba̱l na ka̱t. Uza̱ i təm ka̱ ta i ga i chu awalang va̱ uza̱ i sat ka̱ mpyal nggatək ka̱kul akwali kang. ");
INSERT INTO yer_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","Te onəm oga mpyal nzhi oLawi ɓa atak aEleyazar unəm uga mpyal awop, ká̱ uJoshuwa uya aNun ununggwan, ká̱ aɓoshi onəm oga mpyal nzhí akum ìjili oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","Kang oza̱ là ôza̱ ka̱ aShilo ka̱ mbin aKanana pa̱, <<UYawe ka̱ nak ûMusa chit pa̱ mmá na itong iga ntəm á yi, nzəng ka̱ atak nkpak iya̱m ka̱kul iya̱mkang yi.>> ");
INSERT INTO yer_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","Wa nva uYawe ka̱ nak, te oIsa̱rila na itong va̱ ta̱ ôLawi ká̱ oga atak nkpak iya̱m ka̱ ashe iya̱mkup oza̱. ");
INSERT INTO yer_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","Mmàng ayàk nggəshi a ru âkum aKohat. OLawi ova ka̱ akum ìjili aHaruna unəm uga mpyal awop ka̱m itong pa̱ igba̱pchi ama̱n pa̱ shatɗing ka̱ atak oga akum ìjili aYahuda, ká̱ aSimeyon, ká̱ aBenjamin. ");
INSERT INTO yer_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","Kang aɓo akum aKohat ka̱m itong pa̱ igba̱pchi ka̱ atak oga akum ìjili aEfrayim, ká̱ uDan, kang ká̱ nkap ka̱ ishimshe akum ìjili aManase. ");
INSERT INTO yer_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","Akum ìjili aGershon ǹnyi te, ka̱m itong pa̱ igba̱pchi ama̱n pa̱ shatɗing ka̱ atak oga akum ìjili aIsakar, ká̱ uAsher, ká̱ uNaftali, kang ká̱ nkap ka̱ ishimshe akum ìjili aManase ka̱ aBashan. ");
INSERT INTO yer_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","Akum ìjili aMerari ka̱m itong pa̱ igba̱pchi ama̱n pa̱ parəm ka̱ atak oga akum ìjili aRuben, ká̱ uGat, ká̱ uZebulun. ");
INSERT INTO yer_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","Te oIsa̱rila na itong va̱ ta̱ ôLawi nzəng ká̱ atak nkpak iya̱mkang ka̱ atak mmàng ayàk, wa nva uYawe ka̱ nak ûMusa á. ");
INSERT INTO yer_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","Ka̱ ashe oga akum ìjili aYahuda ká̱ uSimeyon te, oza̱ na itong va̱ ta̱ oma aɗin oza̱ pa̱. ");
INSERT INTO yer_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","Mmá na itong va̱ ta̱ âkum ìjili aHaruna, ova ka̱ ashe akum aKohat, ka̱ akum ìjili oLawi, ka̱kul mmàng ayàk aga nggəshi a ru ôma. ");
INSERT INTO yer_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","Te oza̱ na aKiriyat-Arba ôza̱, nna aHebron á, nzəng ká̱ oga atak nkpak iya̱m nkəkang va̱ gang na, ka̱ mbin ngga aɗuktum aYahuda. UArba uwa upo aAnak. ");
INSERT INTO yer_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","Ǹnyi te, oga ǹzam ngga ìtong va̱ ta ká̱ ivan itutong, mmá na uKalip uya aJefune ununggwan a təm iya̱mkukup. ");
INSERT INTO yer_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","Te oza̱ na aHebron âkum ìjili aHaruna, unəm uga mpyal awop, ìtong iga atak mbwam ka̱kul anəm uga gba̱l unəm, ká̱ aLipna, ");
INSERT INTO yer_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","ká̱ aJatir, ká̱ aEshtemowa, ");
INSERT INTO yer_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","ká̱ aHolon, ká̱ aDebir, ");
INSERT INTO yer_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","ká̱ aAyin, ká̱ aJutta, ká̱ aBet-Shemesh, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ ìfangzəngtəng ka̱ ashe oga akum ìjili aga aparəm va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","Ka̱ ashe akum ìjili aBenjamin te, mmá na aGibiyon, ká̱ aGeba, ");
INSERT INTO yer_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","ká̱ aAnatot, ká̱ aAlmon ôza̱, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","Nkpaktak itong va̱ mmá na ônəm oga mpyal awop, ova akum ìjili aHaruna, unəm uga mpyal awop te, pa̱ igba̱pchi ama̱n pa̱ shatɗing nzəng ká̱ oga atak nkpak iya̱mkang oza̱. ");
INSERT INTO yer_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","Aɓo akum aKohat ka̱ ashe akum ìjili óLawi te, mmá na itong ôza̱ ka̱ ashe nkap akum ìjili aEfrayim. ");
INSERT INTO yer_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","Ka̱ ashe mbin ngga aɗuktum aEfrayim te, mmá na aShekem, ìtong iga atak mbwam ka̱kul anəm uga gba̱l unəm, ká̱ aGezer, ");
INSERT INTO yer_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","ká̱ aKipzayim, ká̱ aBet-Horon ôza̱, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","Ka̱ ashe akum ìjili aDan te, mmá na aElteke, ká̱ aGipbeton, ");
INSERT INTO yer_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","ká̱ aAijalon, ká̱ aGat-Rimmon ôza̱, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","Ka̱ ashe nkap ka̱ ishimshe akum ìjili aManase te, mmá na aTayanak, ká̱ aGat-Rimmon ôza̱, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ iparəm. ");
INSERT INTO yer_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","Pa̱ kpaktak te, mmá na itong pa̱ igba̱pchi nzəng ka̱ oga atak nkpak iya̱mkang oza̱, âɓo akum aKohat. ");
INSERT INTO yer_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","Kang akum aGershon, ka̱ ashe akum ìjili oLawi te, mmá na itong ôza̱ ka̱ ashe nkap ka̱ ishimshe akum ìjili aManase, oma, aGolan ka̱ aBashan, ìtong iga atak mbwam ka̱kul anəm uga gba̱l unəm, ká̱ aBe-Eshtera, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ iparəm. ");
INSERT INTO yer_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","Ka̱ ashe akum ìjili aIsakar te, mmá na aKishiyon, ká̱ aDaberat, ");
INSERT INTO yer_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","ká̱ aJarmut, ká̱ aEn-Gannim ôza̱, nzəng ka̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","Ka̱ ashe akum ìjili aAsher te, mmá na aMishal, ká̱ aAbdon, ");
INSERT INTO yer_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","ká̱ aHelkat, ká̱ aRehop ôza̱, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","Ka̱ ashe akum ìjili aNaftali te, mmá na aKadesh ka̱ aGalili, ìtong iga atak mbwam ka̱kul anəm uga gba̱l unəm, ká̱ aHammot-Dor, ká̱ aKartan ôza̱, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ ishatɗing. ");
INSERT INTO yer_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","Nkpaktak itong va̱ mmá na âkum aGershon te, pa̱ ìgba̱pchi ama̱n pa̱ shatɗing nzəng ká̱ oga atak nkpak iya̱mkang oza̱. ");
INSERT INTO yer_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","Akum aMerari, ka̱ ashe aɓo akum ìjili óLawi te, mmá na itong ôza̱ ka̱ ashe akum ìjili aZebulun, oma, aJokneyam, ká̱ aKarta, ");
INSERT INTO yer_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","ká̱ aDimna, ká̱ aNahalal ôza̱, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","Ka̱ ashe akum ìjili aRuben te, mmá na aBezer, ká̱ aJahat, ");
INSERT INTO yer_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","ká̱ aKedemot, ká̱ aMefayat ôza̱, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","Ka̱ ashe akum ìjili aGat te, mmá na aRamot ka̱ aGileyat, ìtong iga atak mbwam ka̱kul anəm uga gba̱l unəm, ká̱ aMahanayim, ");
INSERT INTO yer_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","ká̱ aHeshbon, ká̱ aJazer ôza̱, nzəng ká̱ oga atak nkpak iya̱mkang oza̱. Pa̱ kpaktak te, itong pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","Nkpaktak itong va̱ mmá na âkum aMerari, ka̱ ashe aɓo akum ìjili oLawi, ka̱ atak mmàng ayàk te, pa̱ igba̱pchi ama̱n pa̱ parəm. ");
INSERT INTO yer_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","Nkpaktak itong oLawi ka̱ ashe mbin iji oIsa̱rila te, ìsəm pa̱ ineɗing ama̱n pa̱ na̱nne nzəng ká̱ oga atak nkpak iya̱mkang oza̱. ");
INSERT INTO yer_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","Nza̱ ìtong nggo nna yà ká̱ atak nkpak iya̱mkang va̱ gang na. Wa nnà ta n̂za̱ ìtong nggo. ");
INSERT INTO yer_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Wa nnà ta, uYawe na ôIsa̱rila nkpaktak mbin va̱ uza̱ ka̱ sóng anung pa̱ ò na ôkəka oza̱. Te oza̱ ka̱m mbin va̱ ta kang oza̱ təm ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Te uYawe na njul oza̱ ka̱ nza̱ ngba̱k nggo, wa nva uza̱ ka̱ sóng anung okəka oza̱. Unəm uro yà ka̱ ashe okpa ìkum oza̱ pa̱ a sat a lung oza̱ ka̱t, ka̱kul uYawe na okpa ìkum oza̱ chit pa̱ kpaktak ka̱ ashe awo oza̱. ");
INSERT INTO yer_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","UYawe yəl nkpaktak oga nsar nnap-nlà nnəna̱n va̱ uza̱ yar n̂zhi aIsa̱rila. Nro yà bur ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","Te uJoshuwa wór akum ìjili aRuben, ká̱ uGat, ká̱ nkap ishimshe akum ìjili aManase, ");
INSERT INTO yer_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","kang uza̱ là ôza̱ pa̱, <<O nəm nkpaktak iya̱m va̱ chit uMusa, uzwal aYawe ka̱ nak a wó, kang o kpak nnap-nnəm á mi chit ka̱ ashe nkpaktak iya̱m va̱ n nak a wó. ");
INSERT INTO yer_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Ka̱ ashe nkpaktak oga nra mmakmak va̱ ta̱, a ga chu nda va̱ ta̱ te, nna o yang ogənang wo chit ka̱t. Kang ó kpak nnap-mpakpak aYawe, Inan wó kpak kpa pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Ǹyangmata̱ te, uYawe, Inan wó, á na njul ogənang wó chit, wa nva uza̱ ka̱ yar nsar nnap ôza̱. Ka̱kul nva̱ ta te, ó le ó ga oga nzhi wó, ka̱ mbin va̱ nna təm iya̱mkup wó chit, nva uMusa, uzwal aYawe ka̱ na a wó ka̱ gwong aUrdun á. ");
INSERT INTO yer_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Ǹnyi te, ó nak ishi nak ka̱ nkpak oga nnap-mpakpak ká̱ nnap-nkpakkpak nva uMusa uzwal aYawe ka̱ nak a wó. Nna pa̱ ó ma̱n uYawe Inan wó, ó chen achen ka̱ ashe nnap-nnənəm, ó kpak oga nnap-mpakpakpakpak, ó da̱r nkam ká̱ izəzər, kang ó wop na ka̱ nkpaktak igwak, ka̱ nkpaktak irirì wó.>> ");
INSERT INTO yer_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","Te, uJoshuwa nak nnap-nnəna̱n ôza̱, kang uza̱ re oza̱, nna chit te, oza̱ le oga nzhi oza̱ ɗak. ");
INSERT INTO yer_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","UMusa ka̱ na iya̱mkup n̂kap ishimshe akum ìjili aManase aga azəng chit ka̱ aBashan, kang uJoshuwa na iya̱mkup âɓo nkap ishimshe akum ìjili nro chit ka̱ asa̱l ntar alum a gwong aUrdun nzəng ka̱ ogənang oza̱ oIsa̱rila. Awalang va̱ uJoshuwa re oza̱ pa̱ á ga oga nzhi oza̱ te, uza̱ nak nnap-nnəna̱n ôza̱, ");
INSERT INTO yer_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","kang uza̱ là ôza̱ pa̱, <<Ó le ó ga oga nzhi wó ká̱ ndur pa̱ mmakmak, ká̱ iya̱mkang pa̱ kyák, ká̱ aazurfa, ká̱ azənariya, ká̱ acham arəzang, ká̱ acham, ká̱ ilukwan pa̱ makmak. Ó kap iya̱m iga nwur ka̱ atak ìkum, ka̱ atak okpa ìkum wó ká̱ ogənang wó.>> ");
INSERT INTO yer_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Te oga akum ìjili aRuben, ká̱ uGat, ká̱ nkap ishimshe akum ìjili aManase, re aɓo oIsa̱rila ka̱ aShilo ka̱ mbin aKanana le mbin aGileyat, mbin va oza̱ ka̱m chit sat iya̱mkup oza̱, wa nva uYawe ka̱ nak ka̱ atak aMusa á. ");
INSERT INTO yer_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","Awalang va̱ oza̱ chu aGelilot va̱ dat ká̱ aWang aUrdun ka̱ mbin aKanana te, akum ìjili aRuben, ká̱ uGat, ká̱ nkap ishimshe akum ìjili aManase me atak nshì iya̱m awop dat ká̱ anung awang va̱ ta, a va rúp, kang à ɓyen ndər pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","Ka̱ nva̱ngva̱ aɓo oIsa̱rila fe pa̱ oza̱ me atak nshì iya̱m awop chit ka̱ aGelilot ka̱ anung aWang aUrdun, ka̱ aswari mbin aKanana, ka̱ ngba̱k nji oIsa̱rila, ");
INSERT INTO yer_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","te nkpaktak nggatək oIsa̱rila ɓut ka̱ aShilo ka̱kul pa̱ na ó ga ó lung ìkum ká̱ ôza̱. ");
INSERT INTO yer_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","Te oIsa̱rila re uFinehas uya aEleyazar ununggwan, unəm uga mpyal awop, ka̱ atak akum ìjili aRuben, ká̱ uGat, ká̱ nkap ishimshe akum ìjili aManase ka̱ mbin aGileyat. ");
INSERT INTO yer_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","Mmá re na nzəng ká̱ onəm oga mpyal pa̱ ogba̱pchi, nza̱ unəm nggo te, unəm uga mpyal akum ka̱ ashe oga akum ìjili oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","Awalang va̱ oza̱ ga mbin aGileyat, ka̱ atak akum ìjili aRuben, ká̱ uGat, ká̱ nkap ishimshe akum ìjili aManase te, oza̱ là ôza̱ pa̱, ");
INSERT INTO yer_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","<<Nkpaktak nggatək onəm aYawe ɓəp pa̱, <Nza̱ apir nlang nnandər ta̱ ó nəm ka̱ mpyal Inan oIsa̱rila, nva̱ ó ga̱ɓa̱n asəm ûYawe, ó fa iya̱mkak, ó me atak nshì iya̱m awop îshi wó yà? ");
INSERT INTO yer_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","Nnap-mɓá̱ngɓa̱ng va̱ í nəm ka̱ aFeyor te, nná kúr yi chit ka̱t ɗò? Dər, a ɓa chu nda va̱ ta̱, nna í fa chit ka̱ ashe mɓək anung nnap-mɓá̱ngɓa̱ng va̱ ta ka̱t, kap ka̱ nva̱ uYawe re nrè ká̱ arwa aɓá̱ngɓa̱ng ka̱ apal ishi yi onənəm á. ");
INSERT INTO yer_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","Kang ǹyangmata̱, ó ga̱ɓa̱n asəm ó ná ûYawe ka̱ nda ta̱ ɗò? Kang a yà pa̱ ó fa iya̱mkak ká̱ uYawe nda ta̱, ìpin te, uza̱ i mən ìkum ká̱ nkpaktak nggatək oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","A yà pa̱ mbin nji wó nna ka̱ adak, te ó pa̱ng ó ɓa ashe mbin va aGhal aYawe kà̱, na ó ka̱m mbin îshi wó ka̱ ashe yi. Ǹnyi te, kang ó fa iya̱mkak ká̱ uYawe, ka̱t te, ó fa iya̱mkak ká̱ yi ka̱t, ka̱ atak mme atak nshì iya̱m awop îshi wó pa̱ɗi, ká̱ atak nshì iya̱m awop aYawe, Inan yi ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","Ka̱ awalang va̱ uAkan uya aZera ununggwan nəm nnandər ka̱t ka̱ apal oga iya̱m va̱ mmá gor ka̱kul nzhì te, nfə́l ìgwak Inan fə́r ka̱ apal nkpaktak nggatək oIsa̱rila ka̱t ɗò? UAkan wa ká̱ nkukwa zhì ka̱kul nnap-mɓá̱ngɓa̱ng wò ka̱t.> >> ");
INSERT INTO yer_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","Te akum ìjili aRuben, ká̱ uGat, ká̱ nkap ishimshe akum ìjili aManase na ama̱n ônəm oga mpyal oga akum oIsa̱rila pa̱, ");
INSERT INTO yer_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","<<UYawe, Inan, Uga Ichumchum. UYawe, Inan, Uga Ichumchum. Uza̱ wa nyi iya̱m va̱ nyi nak kang í nnəm iya̱m va̱ ta, kang í ɗom pa̱ oIsa̱rila a nyi kpa. A yà pa̱ i fa iya̱mkak, ka̱t te, i nəm nnandər ûYawe ka̱t, te kang ó re yi ká̱ irirì nda ta̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","A yà pa̱ í ga̱ɓa̱n asəm ûYawe kang í me atak nshì iya̱m awop îshi yi, ka̱kul na í yichi iya̱m inana iga nshì, ka̱t te, iya̱m inana iga ìpirkur, ka̱t te, iya̱m inana iga ntəm ikángkáng te, re uYawe ká̱ ishi wò á pyát a yi. ");
INSERT INTO yer_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","<<Í nəm pa, ka̱kul ayər ka̱ nnəm yi, kang nra ngga mɓa te, ovan wó a là ovan yi pa̱, <Iza̱ gwang wó ká̱ uYawe, Inan oIsa̱rila yà? ");
INSERT INTO yer_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","Ka̱kul mmawó akum ìjili aRuben, ká̱ uGat te, uYawe nak aWang aUrdun chit aswari ka̱ ishimshe yi ká̱ wó. Te wa nnà ta iya̱m ro gwang wó ká̱ uYawe ka̱t.> Le kang ovan wó a nak ovan yi a re nwop uYawe ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","<<Ka̱kul nva̱ ta te, í la pa̱, <Re í gbar izər, í me atak nshì iya̱m awop îshi yi, ǹnyi te, ka̱kul nná iya̱m inana iga nshì, ka̱t te, nná nləfər iya̱m ipápà ka̱t.> ");
INSERT INTO yer_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","Ka̱ɗor nva̱ ta te, i təm iya̱m iga nshet nnàp ka̱ ishimshe yi ká̱ wó, kang ka̱ ishimshe nlwàk ngga mɓa, pa̱ mmayi ka̱ nwop uYawe nna kpa ka̱ mpyal aGhəghal aYəyər ká̱ oga iya̱m inana iga nshì, ká̱ oga nləfər iya̱m ipápà, ká̱ oga iya̱m inana iga ntəm ikángkáng, le kang ovan wo á la ovan yi ka̱ nra ngga mɓa pa̱, <iza̱ gwang wó ká̱ nwop uYawe yà ka̱t.> ");
INSERT INTO yer_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","<<Te í rəng pa̱, a yà pa̱ ka̱ awalang va̱ mmá là a yi, ka̱t te nlwàk ngga mɓa, te í na ama̱n pa̱, <Ó dər ala̱ka̱n atak nshì iya̱m awop aYawe, va̱ ópo yi me, ka̱kul ǹyichi iya̱m inana iga nshì, ka̱t te nləfər iya̱m ipápà ka̱t, pa̱ na a yà iya̱m iga nshet nnàp ká̱ ishimshe yi ká̱ wó.> ");
INSERT INTO yer_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","<<Inan a kap yi ká̱ nva̱ pa̱ i fa iya̱mkak ka̱ ûYawe, i ga̱ɓa̱n asəm a na ka̱ nda va̱ ta̱ ka̱ atak mme atak nshì iya̱m awop aro pa̱ɗi, ka̱kul oga iya̱m inana iga nshì, ká̱ oga iya̱m inana iga ìpirkur, ka̱t te, oga nləfər iya̱m ipápà, iva watar atak nshì iya̱m awop aYawe va̱ ka̱ mpyal aghəghal aga mɓut á.>> ");
INSERT INTO yer_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","Awalang va̱ uFinehas unəm uga mpyal awop, ká̱ onəm oga mpyal nggatək, ká̱ onəm oga mpyal akum oIsa̱rila va̱ nzəng ka̱ na, fe nnap-nlà va̱ akum ìjili aRuben, ká̱ uGat, ká̱ nkap ishimshe akum ìjili aManase là te, igwak chàng oza̱. ");
INSERT INTO yer_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","Kang uFinehas uya aEleyazar ununggwan unəm uga mpyal awop, là ônəm aRuben, ká̱ uGat, ká̱ uManase pa̱, <<Ka̱ nda í nyi pa̱ uYawe uwa yà nzəng ka̱ yi. Ka̱kul pa̱ í nyám nlang nna nnandər ka̱ mpyal aYawe ka̱t. Ǹyangmata̱ te, ó ka̱m ishi oIsa̱rila chit ka̱ ashe awó aYawe.>> ");
INSERT INTO yer_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","Te, uFinehas uya Eleyazar ununggwan unəm uga mpyal awop, ká̱ onəm oga mpyal le ka̱ atak onəm aRuben, ká̱ uGat, ká̱ uManase ka̱ mbin aGileyat, ga mbin aKanana, kang a ɓa ká̱ ama̱n ôIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","Ìgwak chàng oIsa̱rila ka̱ nfe ama̱n va̱ ta, kang oza̱ shep Inan. Kang oza̱ là nnap ngga nəm ìkum nro lap ka̱ apal oza̱ ka̱t, na pa̱ ó zhì onəm aRuben, ká̱ uGat ká̱ mbin va̱ oza̱ təm kà̱. ");
INSERT INTO yer_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","Kang onəm aRuben, ká̱ uGat na aɗin atak nshì iya̱m awop va̱ ta̱ pa̱, Ǹnyám Nnap ka̱ Ishimshe Yi pa̱ uYawe uwa Inan. ");
INSERT INTO yer_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","UYawe na njul ôIsa̱rila chit ka̱ atak nkpaktak okpa ìkum oza̱, ovəngva̱ gang oza̱ á. Oza̱ gba̱ng chit ka̱ ashe njul va̱ ta, kang uJoshuwa gbák chit, a nəm izún chit pa̱ makmak. ");
INSERT INTO yer_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Te uJoshuwa wór nkpaktak oIsa̱rila, ká̱ onəmgbak oza̱, ká̱ onəm oga mpyal oza̱, ká̱ onəm oga nnáp-akwali oza̱, ká̱ onəm oga mpyal ìkum oza̱, kang uza̱ là ôza̱ pa̱, <<Ǹyangmata̱ te, n gbák chit, kang izún mi ga chit. ");
INSERT INTO yer_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Mmawó ká̱ ishi wó, ó ya nkpaktak iya̱m va̱ ya uYawe, Inan wó nəm n̂kpaktak oga mbin va̱ ta̱ ka̱kul wó, ka̱kul uYawe, Inan wó, uwa lung ìkum ka̱kul wó. ");
INSERT INTO yer_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Ó dər, n káp oga mbin va̱ ta̱ chit iya̱mkup ôga akum ìjili wó, nvəngva̱ nná re, ká̱ nkpaktak oga mbin va̱ n ri chit ká̱ ìkum, a ɓan ka̱ aWang aUrdun ka̱ asal nfa alum, ga chu ìWa aMeditereniya ka̱ asa̱l ntar alum. ");
INSERT INTO yer_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","UYawe, Inan wó, uwa ká̱ ishi wò, i nak oza̱ i chəng ka̱ mpyal wó, kang uza̱ i ɓak oza̱ i fa ka̱ ashe mbin va̱ ta. Te ó ka̱m mbin oza̱, wa nva uYawe, Inan wó ka̱ yar nsar nnap-nlà á wó á.>> ");
INSERT INTO yer_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","<<Ka̱kul nva̱ ta̱ te, ó sat pa̱ kakkərak, ó nak ishi, ó kpak nkpaktak iya̱m va̱ mmá lir ka̱ ashe nlir nnap-mpakpak aMusa, kang ó ga̱ɓa̱n awo ari ka̱t te, awo apəra̱m ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Kang ó gwang ishi ká̱ aɓo oga mbin va̱ re ka̱ ashe mbin va̱ ta ka̱t, kang ó wór oga aɗin inan oza̱, ka̱t te ó sóng anung ká̱ oza̱ ka̱t. Kang ó wop oza̱, ka̱t te ó ɓəram ôza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Ǹnyi te, ó da̱r nkàm ka̱ atak aYawe, Inan wó, wa nva ka̱ ó nəm ɓa chu nda ata̱ á.>> ");
INSERT INTO yer_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","<<Ka̱kul uYawe ka̱ ɓak oga nnang mbin nkamkam chit ka̱ mpyal wó, kang a ɓa chu nda va̱ ta̱, unəm uro ya kur ndap ká̱ wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Unəm pa̱ uzəng ka̱ ashe wó, i ɓak okpa ìkum ìkalong, ka̱kul pa̱ uYawe, Inan wó, uwa i lung ìkum ka̱kul wó, wa nva uza̱ ka̱ yar nsar nnap-nlà á wó á. ");
INSERT INTO yer_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Te ó nak ishi ká̱ ishi wó pa̱ dakdak, ó ma̱n uYawe, Inan wó.>> ");
INSERT INTO yer_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","<<Ǹnyi te, a yà pa̱ ó ga̱ɓa̱n, ó gwang ishi ká̱ aɓo oga mbin va̱ re ka̱ ashe wó, kang ó ka̱m ichar ká̱ ôza̱, ");
INSERT INTO yer_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","te ó nyi pa̱ kpátkpát pa̱ uYawe, Inan wó i yà ká̱ mɓak oga mbin va̱ ta̱ ka̱ mpyal wó lap ka̱t. Ka̱ɗor nva̱ ta te, oza̱ i tong ipang iga ləp ìfang, ká̱ oga ajəp a wó, oga nlilyat ka̱ asəm wó, kang izú ka̱ ashe íwu wó, yá ó ga ó zhì pa̱ kpaktak ka̱ ashe mbin nnəna̱n va̱ ta̱, nva̱ uYawe, Inan wó ka̱ na á wó á.>> ");
INSERT INTO yer_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","<<Ǹyangmata̱ te, mmami ka̱ ngga nwòl asa̱l va̱ nkpaktak apambin i wòl kà̱. Ó nyinyi ká̱ nkpaktak igwák wó ká̱ irirì wó pa̱, oga iya̱m inəna̱n va̱ uYawe, Inan wó ka̱ yar nsar nnap-nlà kà̱ ka̱ apal wó pa̱ kpaktak te, iro pa̱ izəng á ɓur ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Ǹnyi te, wa nva nkpaktak oga iya̱m inəna̱n va̱ uYawe, Inan wó ka̱ yar nsar nnap-nlà kà̱ ka̱ apal wó kang iro pa̱ izəng ɓur ka̱t, te wa nnà ta uza̱ i ɓa ka̱ nkpaktak oga iya̱m iɓá̱ngɓa̱ng va̱ uza̱ ka̱ là ka̱ apal wó, i ga chu awalang va̱ uza̱ i zhì wó ka̱ ashe mbin nnəna̱n va̱ ta̱, nva uza̱ ka̱ na á wó á. ");
INSERT INTO yer_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","A yà pa̱ ó gantal nsar nnap-nlà aYawe, Inan wó va̱ ta̱, nva̱ uza̱ nak á wó, kang ó ga ó wop oga inan iro, ó kuchi ôza̱ te, nlak ìgwak aYawe i fə̀r ka̱ apal wó, kang uza̱ i zhì wó pa̱ kəlak ka̱ ashe mbin nnəna̱n va̱ ta̱, nva uza̱ ka̱ na á wó á.>> ");
INSERT INTO yer_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Te uJoshuwa ɓut nkpaktak oga akum ìjili oIsa̱rila ka̱ aShekem. Uza̱ wór onəmgbak, ká̱ onəm oga mpyal, ká̱ onəm oga nnáp-akwali, ká̱ onəm oga mpyal ìkum oIsa̱rila. Kang oza̱ ɓa ka̱ mpyal Inan. ");
INSERT INTO yer_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Te uJoshuwa là n̂kpaktak onəm pa̱, <<Iya̱m va ta̱ uYawe, Inan oIsa̱rila là, ka̱ ashe nra va̱ watar te, okəka wó, oma, uTera upo aIbərahim, ká̱ uNahor va̱ ka̱ təm ka̱ gwong aWang aYufriti te, oza̱ wop oga inan iro. ");
INSERT INTO yer_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Ǹnyi te, n yar ukəka wó uIbərahim ka̱ gwong aWang aYufriti va̱ cho, kang m ɓa ka̱ na ka̱ ashe nkpaktak mbin aKanana, te n nak akukum myak. N na uIshaku á na, ");
INSERT INTO yer_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","kang ûIshaku te, n na uYakubu ká̱ uIsuwa á na. Te n na aɓam aSeyir iya̱mkup ûIsuwa, ǹnyi te, uYakubu ká̱ nzhi wò ga aMasar.>> ");
INSERT INTO yer_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","<<Te, n re uMusa ká̱ uHaruna, kang n la̱p aMasar ka̱ arwa aɓá̱ngɓa̱ng, wa nva̱ ka̱ n nəm ka̱ ishimshe oza̱ á. Ká̱ nvəva̱ng te, n fa ká̱ wó. ");
INSERT INTO yer_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Awalang va̱ n fa ká̱ okəka wó ka̱ ashe aMasar, kang oza̱ fa chu ìwa, te onəm oga aMasar ɓak nva̱ng okəka wó ká̱ oga akeke ipəri, ká̱ onəm oga nkwák ipəri ga chu ìWa iRəzang. ");
INSERT INTO yer_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Ǹnyi te, oza̱ yə́ng ûYawe, te uza̱ nak atak kpa̱rkpa̱r ká̱ ishimshe oza̱ ká̱ onəm oga aMasar, kang uza̱ nak ìwa gún oza̱. Ó yi ya ká̱ iwú wó iya̱m va̱ n nəm onəm oga aMasar. Kang ó tətəm ka̱ ashe ǹzam izún pa̱ makmak. ");
INSERT INTO yer_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Te, m ɓa ká̱ wó ka̱ mbin oAmori ova təm ka̱ asal nfa alum aUrdun. Oza̱ lung wó, ǹnyi te, n na oza̱ ka̱ ashe awo wó. N zhì oza̱ ka̱ mpyal wó, kang ó ka̱m mbin oza̱. ");
INSERT INTO yer_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Ka̱ walang va̱ uBalak uya aZipo ununggwan, uponzhi uga aMowap, a wong pa̱ ò lung oIsa̱rila, kang uza̱ re nre ká̱ ichal ûBalam uya aBeyor ununggwan, pa̱ á ɓa á vyap oza̱. ");
INSERT INTO yer_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Ǹnyi te, n gwong achwang ká̱ uBalam ka̱t, ka̱kul nva̱ ta te, uza̱ pak inok nak nnap-nnəna̱n á wó. Ka̱ asal va̱ ta n fa ká̱ wó ka̱ ashe awuwo.>> ");
INSERT INTO yer_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","<<Ka̱ walang va̱ ó pa̱ng aUrdun ó ɓa aJariko te, onəm oga aJariko lung wó, wa nnà ta kpa oAmori, ká̱ oPerizi, ká̱ oKanana, ká̱ oHitti, ká̱ oGirgasi, ká̱ oHivi, ká̱ oJebusi. Ǹnyi te, n na oza̱ ka̱ ashe awo wó. ");
INSERT INTO yer_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Kang n re nre ka̱ nlàga ka̱ mpyal wó, nva ɓàk oponzhi oga aAmori oga oparəm va̱ ta̱ ka̱ mpyal wó. Ó nəm igwan va̱ ta ka̱ atak ndokchi wó, ka̱t te ìjang wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","N na mbin a wó nva ó ɓək anung ka̱ ka̱t, ká̱ itong iva ó me ka̱t, kang mmawó ka̱ ntəm ka̱ ashishe, ó rì oga awar ìba̱ngba̱ng, ká̱ oga awar mpyet ovəngva mmawó na ó ɓál ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","<<Ǹyangmata̱ te, ó nəm ayər aYawe, ó wop na ka̱ nkpaktak nnandər. Ó swang oga inan va̱ okəka wó ka̱ wop ka̱ gwong aWang aYufriti, ká̱ ashe aMasar, na ó wop uYawe uwa byet. ");
INSERT INTO yer_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Ǹnyi te, a yà pa̱ ó ya pa̱ nwop uYawe iya̱m iɓá̱ngɓa̱ng ka̱ mpyal wó te, ó yak nda va̱ ta̱ unəm va̱ ó wop, mwote oga inan va okəka wó ka̱ wop ka̱ gwong aWang aYufriti, ka̱t te, oga inan oAmori va̱ mmawó ka̱ ntəm ka̱ ashe mbin oza̱. Ǹnyi te, mmami ka̱ nzhi mi jiwò te, í wop uYawe.>> ");
INSERT INTO yer_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Te onəm na ama̱n là pa̱, << Í yà ka̱ nre uYawe, pa̱ í wop inan iro ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Ka̱kul pa̱ uYawe, Inan yi uwa fa ka̱ yi ká̱ okəka yi ka̱ mbin aMasar, nzhi ngga nəm izwal, kang uza̱ nəm oga iya̱m ichumchum iga nɗak atak ká̱ iwu yi. Uza̱ kpak yi ka̱ ashe nkpaktak achen va̱ í nəm, ká̱ nkpaktak onəm va̱ í watar ka̱ ashe oza̱ á. ");
INSERT INTO yer_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Kang uYawe ɓàk nkpaktak onəm á yi, nzəng ká̱ oAmori va̱ ka̱ ntəm ka̱ ashe mbin va̱ ta̱. Ka̱kul nva̱ ta te, mmayi kpa í wop uYawe, ka̱kul uza̱ wa Inan yi.>> ");
INSERT INTO yer_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Te uJoshuwa là ônəm pa̱, <<Ó chu nwop uYawe ka̱t, ka̱kul uza̱ Inan iyə́ryər. Uza̱ Inan iga ìkpar, uza̱ i yà ka̱ nyar nfa iya̱mkak wó, ká̱ oga nnap-mɓá̱ngɓa̱ng wó ka̱t. ");
INSERT INTO yer_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","A yà pa̱ ó kap ká̱ uYawe, ó wop oga inan iro te, uza̱ i ga̱ɓa̱n i na mɓək anung a wó, kang i zhì wó, kap ka̱ nva̱ uza̱ ka̱ nəm inəna̱n a wó chit á.>> ");
INSERT INTO yer_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Ǹnyi te, onəm va̱ ta là ûJoshuwa pa̱, <<Pa ka̱t, mmayi te, uYawe wa í wop.>> ");
INSERT INTO yer_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Te uJoshuwa là ôza̱ pa̱, <<Mmawo na ó ta̱l onəm oga nshet nnàp îshi wó pa̱ ó yak uYawe chit, uwa ó wop á.>> Te oza̱ na ama̱n pa̱, <<Á, mmayi na onəm oga nshet nnàp.>> ");
INSERT INTO yer_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Te, uJoshuwa là ôza̱ pa̱, <<Ǹyangmata̱ te, ó swang oga inan iga mbin nkak va̱ ka̱ ashe wó, ó ga̱ɓa̱n igwák wó ka̱ atak aYawe, Inan oIsa̱rila.>> ");
INSERT INTO yer_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Te onəm va̱ ta là ûJoshuwa pa̱, << UYawe, Inan yi uwa i wop, kang uwa i kpak nnap-nnəm á na.>> ");
INSERT INTO yer_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Ka̱ nda va̱ ta te, uJoshuwa yar nsar nnap-nlà ka̱ onəm, kang uza̱ pak oga nnap-mpakpak ká̱ oga nnap-nnəm ôza̱ ka̱ aShekem. ");
INSERT INTO yer_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Kang uza̱ lir oga nnap-nlà va̱ ta ka̱ ashe nlir ngga nnap-mpakpak Inan. Te uza̱ yar inang ìpang kang uza̱ pak ka̱ ta ka̱ akum ikún aOak ka̱ atak ayə́ryər aYawe. ");
INSERT INTO yer_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Te uJoshuwa là n̂kpaktak onəm pa̱, <<Ó dər, ìpang va̱ ta̱ i yà nshet nnap ka̱ apal yi. Ka̱kul á fe nkpaktak oga nnap-nlà va̱ uYawe là á yi chit. Ka̱kul nva̱ ta te, i ga nyà nshet nnap ka̱ apal wó, á ya pa̱ ó yang ka̱ Inan wó á.>> ");
INSERT INTO yer_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Te uJoshuwa re onəm va̱ ta ga, nza̱ unəm nggo le ka̱ atak iya̱mkup wò. ");
INSERT INTO yer_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Ka̱ nva̱ng oga iya̱m va̱ ta̱ te, uJoshuwa uya aNun ununggwan, uzwal aYawe kú, uza̱ ka̱ ìzun igba̱l pa̱ izəng ka̱ ngba̱pchi. ");
INSERT INTO yer_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Kang oza̱ li na ka̱ mbin iya̱mkukup ka̱ aTimnat-Sera, va ka̱ mbin ngga aɗuktum aEfrayim, ka̱ asa̱l mpal aƁam aGayash. ");
INSERT INTO yer_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","OIsa̱rila wop uYawe ka̱ ashe nkpaktak nra aJoshuwa, ká̱ nkpaktak nra onəmgbak va̱ oma yà ká̱ irirì ka̱ nva̱ng ikuku, ovəngva nyi nkpaktak oga iya̱m va̱ uYawe nəm ka̱kul oIsa̱rila á. ");
INSERT INTO yer_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Kang oga akup aYusufu va̱ onəm oIsa̱rila fa kà̱ ka̱ aMasar te, oza̱ li ka̱ aShekem, ka̱ ashe atak va̱ uYakubu yáp ka̱ ovan aHamor onunggwan, upo aShekem ka̱ apal aazurfa igba̱l pa̱ izəng. Atak va̱ ta təm iya̱mkup akum ìjili aYusufu. ");
INSERT INTO yer_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Kang uEleyazar uya aHaruna ununggwan kú, te oza̱ li na ka̱ aGibeya, ìtong iva mmá ka̱ na ûyiyen uFinehas chit ka̱ mbin aɗuktum aEfrayim.");
INSERT INTO yer_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","Ka̱ nva̱ng ikú aJoshuwa te, oIsa̱rila ɓəp uYawe pa̱, <<Uda ka̱ ashe yi i ɓan ngga nlung onəm oga aKanana mpyal yà?>> ");
INSERT INTO yer_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Te uYawe na ama̱n pa̱, <<Onəm aYahuda oma á ga, ó dər, n na mbin va̱ ta chit ka̱ ashe awo oza̱.>> ");
INSERT INTO yer_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Te onəm aYahuda là ônəm aSimeyon ogənang oza̱ pa̱, <<Ó ga nzəng ká̱ yi ka̱ atak iya̱mkup yi, ka̱kul na í lung onəm oga aKanana. Wa nnà ta kpa í fa í ga nzəng ká̱ wó ka̱ ashe nkap iji wó.>>Te oSimeyon ga nzəng ká̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","Awalang va̱ onəm aYahuda ga ru oza̱ ká̱ ìkum te, uYawe na oKanana, ká̱ oPerizi ka̱ ashe awo oza̱. Oza̱ gbá̱ng onunggwan ìkalong pa̱ ìgba̱pchi ka̱ aBezek. ");
INSERT INTO yer_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","Ka̱ ta na oza̱ ya uAdoni-Bezek, te oza̱ ru na ká̱ ìkum, kang oza̱ ri oKanana ká̱ oPerizi. ");
INSERT INTO yer_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","UAdoni-Bezek chə́r, ǹnyi te, oza̱ wà nvəva̱ng oza̱ kpán na, kang oza̱ kyen ifəfang inunggwan iga ashar ká̱ iga awo. ");
INSERT INTO yer_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","Te uAdoni-Bezek là pa̱, <<Oponzhi ìsəm pa̱ ifangshat ova mmá kyen oga ifang inunggwan iga ashar ká̱ iga awo ôza̱ kang oza̱ pak inok nchák iya̱m-nrì ka̱ avəng atebəl mi á. Wa nva ka̱ n nəm ôza̱ te, wa nnà ta Inan pyát akəkat á mi kpa.>>Te oza̱ ga ká̱ na ka̱ aUrushelima kang uza̱ kú ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","Te onəm aYahuda ru aUrushelima ká̱ ìkum, kang oza̱ ri na. Oza̱ gba̱ng onənəm ká̱ ndokchi, kang oza̱ pwak ìtong va̱ ta ká̱ apər. ");
INSERT INTO yer_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","Ka̱ nvəva̱ng te, onəm aYahuda ga pa̱ na o lung ìkum ká̱ oKanana ova ra ka̱ mbin ngga aɗuktum, ká̱ aNegep, ká̱ oga ovan aɓam aga asa̱l ntar alum. ");
INSERT INTO yer_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","Te aYahuda ga nəm ìkum ká̱ oKanana ova ra ka̱ aHebron. Matmat te, aɗin aHebron ka̱ yà pa̱ aKiriyat-Arba. Kang oza̱ ri uSheshayi, ká̱ uAhiman, ká̱ uTalmayi ká̱ ikum. ");
INSERT INTO yer_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","Oza̱ wong ka̱ ta te, oza̱ ru aDebir. Matmat te, mí wór aɗin aDebir pa̱ aKiriyat-Sefer. ");
INSERT INTO yer_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","Te uKalip là pa̱, <<Mi na uyen mi uAksa ka̱ ìvang ûnəm va̱ i ru aKiriyat-Sefer ka̱ ìkum kang i ri na á.>> ");
INSERT INTO yer_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","Te uOtniyel uya aKenat, uɓwakan aKalip ga ri na ká̱ ìkum. Te uza̱ na uyen wò uAksa á na yà uchichar. ");
INSERT INTO yer_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","Ka̱ nva̱ngva̱ uza̱ ga atak aɓar wò te, uza̱ nok na pa̱ uza̱ á ɓəp iram ka̱ upo wò. Awalang va̱ uAksa fər ka̱ apal azhaki wò te, uKalip ɓəp na pa̱, <<Iza̱ mi nəm a ɓu yà?>> ");
INSERT INTO yer_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","Uza̱ na ama̱n a na pa̱, <<Pa̱r mi, ka̱kul u na mbin á mi chit ka̱ aNegep, n chal pa̱ u na oga atak mɓəl ndəng á mi kpa.>> Te uKalip na oga atak aga mɓəl ndəng á na ngga apal ká̱ ngga avəng. ");
INSERT INTO yer_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","Te akum ìjili oKeni, ugwar aMusa, fa nzəng ká̱ onəm oga aYahuda ka̱ ashe ìtong iga akulom oza̱ ga pa̱ na ó təm nzəng ká̱ onəm ga nzam mmaləng ngga aYahuda, nva ra ka̱ nkwandal aArat. ");
INSERT INTO yer_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","Te oYahuda ká̱ ogənang oza̱ oSimeyon ga ru onəm oga aKanana ova ka̱ ntəm ka̱ aZefat ká̱ ìkum, kang oza̱ zhì ìtong va̱ ta pa̱ chatchat. Kang uza̱ wór aɗin ìtong va̱ ta pa̱ aHorma. ");
INSERT INTO yer_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","Onəm aYahuda ri aGaza kpa, ká̱ aAshkelon, ká̱ aEkron nzəng ká̱ nkpaktak oga mbin oza̱. ");
INSERT INTO yer_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","UYawe uwa ka̱ yà nzəng ká̱ onəm aYahuda. Oza̱ kwom mbin ngga aɗuktum, ǹnyi te, ìkam oza̱ kur mɓak onəm oga ntəm ka̱ mbin ngga agbagba ka̱t, ka̱kul onəm va̱ ta ká̱ akeke ipəri aga acham. ");
INSERT INTO yer_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","Te mmá na aHebron uKalip, wa nva uMusa ka̱ yar nsar nnap-nlà á na. Kang uza̱ ɓak ovan aAnak onunggwan pa̱ oshatɗing fa ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","Ǹnyi te, onəm aBenjamin ɓak oJebusi va̱ təm ka̱ aUrushelima ka̱t, ka̱kul nva̱ ta̱ te, oJebusi oma ka̱ ntəm nzəng ká̱ onəm aBenjamin ka̱ aUrushelima nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","Ǹyangmata̱ te, akum ìjili aYusufu wong ga ru aBetel ka̱ ìkum, kang uYawe uwa yà nzəng ká̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","Awalang va̱ nzhi aYusufu re onəm pa̱ á ga á sóng aBetel (matmat te mí wór ìtong va̱ ta pa̱ aLut) te, ");
INSERT INTO yer_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","onəm oga nsóng atak va̱ ta ya unəm uro ka̱ nfa ka̱ ashe ìtong, te oza̱ là á na pa̱, <<Kusuk, nyám asa̱l aga ntar ashe ìtong va̱ ta̱ á yi, te í nyám ikin á ɓu.>> ");
INSERT INTO yer_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","Te uza̱ nyám asa̱l ôza̱, kang oza̱ táng ashe ìtong va̱ ta gbá̱ng onəm ká̱ ndokchi, ǹnyi te, oza̱ re unəm va̱ ta ká̱ nkpaktak nzhizhi. ");
INSERT INTO yer_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","Te unəm va̱ ta ga mbin oHitti, kang a me ìtong ka̱ ta, uza̱ pa̱ aɗin á na pa̱ aLut. Nna ta aɗiɗin ɓa chu nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","Ǹnyi te, uManase ɓak onəm va̱ ka̱ ntəm ka̱ ashe aBet-Shan, ka̱t te aTayanak, ka̱t te aDor, ka̱t te aMegido, ka̱t te aIbəleyam ká̱ oga ivan ìtong oza̱ va̱ gáng oza̱ ka̱t. Ka̱kul oKanana zhet kà̱ ntəm ka̱ ashe mbin va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","Ka̱ nva̱ngva̱ oIsa̱rila kam chit te, oza̱ nak oKanana ka̱ nnəm inok iga nkpak, ǹnyi te oza̱ ɓak oza̱ fa pa̱ chatchat ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","UEfrayim ɓak oKanana va̱ ka̱ ntəm ka̱ ashe aGezer fa ka̱t, wa nnà ta oKanana ga mpyal ká̱ ntəm ka̱ ashe oza̱ ka̱ aGezer. ");
INSERT INTO yer_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","UZebulun ɓak oKanana va̱ ka̱ ntəm ka̱ aKitron, ka̱t te onəm oga ntəm ka̱ aNahalol fa ka̱t. Á nak te oKanana təm nzəng ká̱ oza̱, ǹnyi te oza̱ nak oza̱ ka̱ nnəm inok iga nkpak. ");
INSERT INTO yer_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","UAsher ɓak onəm oga ntəm ka̱ ashe aAkko, ka̱t te onəm oga ntəm ka̱ aSidon, ka̱t te oga aAlap, ka̱t te oga aAkzip, ka̱t te oga aHelba, ka̱t te oga aAfek, ka̱t te oga aRehop fa ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","Ǹnyi te, onəm oga aAsher təm ka̱ ishimshe oKanana, onəm oga ntəm ka̱ mbin va̱ ta, ka̱kul oza̱ ɓak oza̱ fa ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","Wa nnà ta kpa, akum ìjili aNaftali ɓak onəm oga ntəm ka̱ aBet-Shemesh, ka̱t te oga ntəm ka̱ aBet-Anat fa ka̱t, ǹnyi te, oza̱ təm ka̱ ishimshe oKanana, onəm oga ntəm ka̱ mbin va̱ ta. Káp ká̱ nna te, onəm oga ntəm ka̱ aBet-Shemesh ká̱ aBet-Anat tong onəm oga nəm inok izwal ôza̱. ");
INSERT INTO yer_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","Ǹnyi te, oAmori ka̱r akum ìjili aDan ka̱ mbin ngga aɗuktum, kang oza̱ ma̱n ôza̱ pa̱ á fə́r á vang mbin ngga agbagba ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","Te oAmori zhet kpa ka̱ ntəm ka̱ aƁam aHeret, ká̱ aAijalon, kang ká̱ aShayalbim. Ǹnyi te, awalang va̱ oga akum ìjili aYusufu wong kam te, oza̱ nak oAmori ka̱ inok iga nkpak kpa. ");
INSERT INTO yer_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","Kang aswari oAmori ɓan ka̱ asa̱l aAkrabim ɓa ga aSela, kang á kyen ɓa ga mpyal. ");
INSERT INTO yer_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","<<Te uma̱leka aYawe fa ka̱ aGilgal ga aBokim kang a là pa̱, <<N fa ká̱ wó ka̱ aMasar kang m ɓa ká̱ wó ka̱ ashe mbin va n sóng anung pa̱ mi na ôkəka wó. N là pa̱, <Mi yà ka̱ nfən nsar nnap-nlà mi ka̱ wó ka̱t mbyet, ");
INSERT INTO yer_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","kang mmawó te, ó yà ka̱ ǹyar nsar nnap-nlà ká̱ onəm oga ntəm ka̱ mbin va̱ ta̱ ka̱t, ǹnyi te, ó shin oga atak nshì iya̱m awop oza̱.> Ká̱ nna kpa te, ó kpak nnap-nnəm á mi ka̱t. Iza̱ nak kang ó nəm pa yà? ");
INSERT INTO yer_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Ka̱kul nva̱ ta te, n là pa̱, <<Mi yà ka̱ mɓak oza̱ i le ka̱ mpyal wó ka̱t, ǹnyi te oza̱ i tong wa izú ka̱ atak wó, kang oga inan oza̱ i tong ajəp á wó.>> ");
INSERT INTO yer_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","<<Ka̱ nva̱ngva̱ uma̱leka aYawe là iya̱m va̱ ta̱ chit n̂kpaktak ovan ga aIsa̱rila te, onəm gham ká̱ ayə́ng, ");
INSERT INTO yer_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","kang oza̱ wór aɗin atak va̱ ta pa̱ aBokim. Ka̱ ta te, oza̱ yichi nləfər iya̱m ipápà ûYawe. ");
INSERT INTO yer_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Ka̱ awalang va̱ uJoshuwa lyang ká̱ onəm oga aIsa̱rila chit te, udanggo ga atak wò pa̱ na ô kwom mbin ngga iya̱mkup wò. ");
INSERT INTO yer_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Onəm va̱ ta wop uYawe ka̱ ashe nkpaktak nra aJoshuwa, ká̱ nkpaktak nra onəmgbak va̱ oma yà ká̱ irirì ka̱ nva̱ng ikúku, ovəngva nyi nkpaktak oga iya̱m ichumchum va̱ uYawe nəm ka̱kul oIsa̱rila á. ");
INSERT INTO yer_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Te uJoshuwa uya aNun ununggwan, uzwal aYawe kú, izuzun igba̱l ká̱ ngba̱pchi. ");
INSERT INTO yer_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Kang oza̱ li na ka̱ mbin iya̱mkukup ka̱ ashe aTimnat-Heret, ka̱ mbin ngga aɗuktum aEfrayim, ka̱ asa̱l mpal aƁam aGayash. ");
INSERT INTO yer_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Ka̱ nva̱ng va̱ nkpaktak nlwàk va̱ ta kú te, nlwàk nro wong ka̱ nva̱ng oza̱ nva nyi uYawe ka̱t te, inok va̱ uza̱ nəm ka̱kul oIsa̱rila ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Te ovan oIsa̱rila nəm nnap-mɓá̱ngɓa̱ng ka̱ mpyal aYawe, kang oza̱ wop oga aBaal. ");
INSERT INTO yer_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Oza̱ re ngwop uYawe, Inan okəka oza̱, uva fa ká̱ oza̱ ka̱ mbin aMasar. Oza̱ le i wop oga inan iro ka̱ ashe oga inan onəm va̱ ra gang oza̱, kang oza̱ kuchi oza̱. Te oza̱ lak ìgwak uYawe ");
INSERT INTO yer_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","ka̱kul oza̱ yang ká̱ ngwop uYawe, oza̱ le i wop aBaal ká̱ oga aAshtoret. ");
INSERT INTO yer_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Ka̱ ashe nlak ìgugwak ka̱ apal oIsa̱rila te, uYawe na oza̱ ka̱ ashe awo onəm oga nyán ká̱ oza̱, kang a kwom iya̱m oza̱. Uza̱ yichi oza̱ ka̱ ashe awo okpa ìkum oza̱ ovəngva gang oza̱, ka̱kul nva̱ ta te, oza̱ kur ntong ka̱ mpyal okpa ìkum oza̱ lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Nkpaktak awalang va̱ oIsa̱rila i fa pa̱ ó ga ìkum te, awo aYawe i lung oza̱ wa nva uza̱ ka̱ sóng anung ôza. Kang oza̱ ɓək anung pa̱ makmak. ");
INSERT INTO yer_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Te uYawe wong ká̱ onəm oga nnáp akwali, ova ka̱m ishi oza̱ ka̱ ashe awo onəm oga nkwom iya̱m oza̱ ká̱ ìfan. ");
INSERT INTO yer_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Káp ká̱ nna te, oza̱ gwong achwang ka̱ onəm oga nnap-akwali ôza̱ ka̱t, ǹnyi te, oza̱ nəm mmai ka̱ atak ngwop oga inan iro. Kang oza̱ ga̱ɓa̱n ká̱ nggha̱n re asa̱l va̱ okəka oza̱ wòl kà̱, ova ka̱ kpak nnap-mpakpak aYawe. ");
INSERT INTO yer_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Nkpaktak awalang va̱ uYawe na unəm uga nnap-akwali ôza̱ te, uYawe uwa yà nzəng ká̱ unəm uga nnap-akwali va̱ ta, kang uza̱ ka̱m ishi oza̱ ka̱ ashe awo okpa ìkum oza̱ ka̱ ashe nra anəm uga nnap-akwali va̱ ta. Ka̱kul ayə́ng ká̱ nshìn oza̱ rwa ìgwak ûYawe, nva̱ onəm ka̱r oza̱ kang anyán ká̱ oza̱ á. ");
INSERT INTO yer_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Ǹnyi te, awalang va̱ unəm uga nnap-akwali va̱ ta a kú te, oza̱ i ga̱ɓa̱n i le i nəm nlang nnandər nva ji nji okəka oza̱ ji, oza̱ i le ka̱ oga inan iro, oza̱ i wop oza̱ kang oza̱ i kuchi ôza̱, oza̱ i re oga nnap-mɓá̱ngɓa̱ng oza̱, ka̱t te ntwat ìgwak oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Te ìgwak lak uYawe pa̱ gənggəng ka̱ apal oIsa̱rila, kang uza̱ là pa̱, <<Ka̱kul onəm va̱ ta̱ fən nsar nnap-nlà mi va̱ n nak opo oza̱ chit, kang oza̱ gwong achwang ka̱ mi ka̱t te, ");
INSERT INTO yer_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","mi yà ká̱ mɓak mbin nro i le ka̱ mpyal oza̱ lap ka̱ ashe oga mbin va̱ uJoshuwa kú kang a re ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Mi nəm inok ká̱ oza̱ na m ma oIsa̱rila, mwote oza̱ i nəm achen ka̱ asa̱l aYawe wa nva̱ opo oza̱ ka̱ nəm nggo, ka̱t te oza̱ i nəm pa ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","UYawe ka̱ re oga mbin va̱ ta təm ka̱ ta, uza̱ ɓak oza̱ fa ka̱ ashe awalang pa̱ zəng ka̱ atak nna oza̱ ka̱ ashe awo aJoshuwa ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","Oga mbin va ta̱ uYawe re, pa̱ na o ma oIsa̱rila ká̱, ova ma ka̱ lung ìkum chit ká̱ oKanana ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","Uza̱ nəm pa ka̱kul pa̱ na o ɗyang nlung ìkum ôga akum ìjili oIsa̱rila ovəngva̱ oma ka̱ nyi nlung ìkum chit kang ka̱t á. ");
INSERT INTO yer_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","Oga mbin va̱ oma ta̱, oponzhi pa̱ otukun oga oFilisti, ká̱ nkpaktak oKanana, ká̱ oSidon, ká̱ oHivi ova ra ka̱ oga aɓam aLebanon, a ɓan ka̱ aƁam aBaal-Harmon ga chu aLebo Hamat. ");
INSERT INTO yer_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","Mmá re oza̱ ka̱kul mma oIsa̱rila, mwote oza̱ i kpak nnap-mpakpak aYawe kpak nggo, nva̱ uza̱ nak ôkəka oza̱ ka̱ atak aMusa á. ");
INSERT INTO yer_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","Te onəm oIsa̱rila təm ka̱ ashe oKanana, ká̱ oHitti, ká̱ oAmori, ká̱ oPerizi, ká̱ oHivi, ká̱ oJebusi. ");
INSERT INTO yer_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","Oza̱ ka̱m ichar ká̱ ovan oza̱ ochar, kang oza̱ na ovan oza̱ ìvang ochar ôvan oza̱ onunggwan, kang oza̱ wop oga inan oza̱. ");
INSERT INTO yer_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Kang oIsa̱rila kong ká̱ uYawe, Inan oza̱, oza̱ nəm nnap-mɓá̱ngɓa̱ng ka̱ mpipyal, oza̱ wop oga ichər aBaal ká̱ aAshera. ");
INSERT INTO yer_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Ka̱kul nva̱ ta te, nlak ìgwak aYawe wong ka̱ apal oIsa̱rila, te uza̱ na oza̱ ka̱ ashe awo aKushan-Rishatayim, uponzhi uga aMesopotamiya. Kang oIsa̱rila nəm inok á na ka̱ apal izun pa̱ ina̱nne. ");
INSERT INTO yer_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Ǹnyi te, awalang va̱ oIsa̱rila yar ayə́ng uYawe chit te, uza̱ wong ká̱ unəm uga nka̱m ishi ôza̱, uOtniyel, uya aKenat, uɓwakan aKalip uva ka̱m ishi oza̱. ");
INSERT INTO yer_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","ARuhu aYawe fə́r ka̱ apal ishishi, kang uza̱ sat unəm uga nnap-akwali ôIsa̱rila. Uza̱ fa ga ìkum te, uYawe na uKushan-Rishatayim, uponzhi uga aMesopotamiya ka̱ ashe awuwo. Kang uza̱ nəm igwan ka̱ apal aKushan-Rishatayim. ");
INSERT INTO yer_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Te mbin va̱ ta təm ká̱ ikángkáng ìzun ìsəm pa̱ ineɗing, ga chu awalang va̱ uOtniyel uya aKenat ununggwan kú. ");
INSERT INTO yer_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","Ka̱ɗi te, oIsa̱rila nəm nnap-mɓá̱ngɓa̱ng ka̱ mpyal aYawe. Ka̱kul nva̱ ta te, uYawe na igwan ûEglon, uponzhi uga aMowap ka̱ apal oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","Te uEglon ɓut oAmori ká̱ oAmalek, uza̱ ga ru oIsa̱rila ká̱ ìkum, kang oza̱ ka̱m ìtong iga aKulom. ");
INSERT INTO yer_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","Te oIsa̱rila nəm inok ûEglon, uponzhi uga aMowap izun pa̱ igba̱pchi ama̱n pa̱ na̱nne. ");
INSERT INTO yer_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","Ǹnyi te, awalang va̱ oIsa̱rila yə́ng ûYawe te, uYawe wong ká̱ unəm uga nka̱m ishi ôza̱, uEhut uya aGera, uga akum ìjili aBenjamin, uza̱ unəm uga mpa̱m. OIsa̱rila re na ká̱ imwa pa̱ uza̱ á ga ká̱ ûEglon, uponzhi uga aMowap. ");
INSERT INTO yer_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","Ǹyangmata̱ te, uEhut ka̱ la ndokchi îshi wò chit nva ká̱ ngba̱k pa̱ mparəm, nwuwang te, ashar pa̱ azəng ká̱ aɓuɓo, kang uza̱ sar ka̱ ìsong iga ari ka̱ avəng oga ìlukwan wò. ");
INSERT INTO yer_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","Te uza̱ yar imwa va̱ uza̱ ga ká̱ ûEglon, uponzhi uga aMowap. UEglon pa te, unəm va mwal byet. ");
INSERT INTO yer_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","Nva̱ngva̱ uEhut gba̱l ká̱ nna imwa va̱ chit, te uza̱ re onəm va̱ wur imwa va̱ ta ga. ");
INSERT INTO yer_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","Ǹnyi te, uza̱ ga chu ka̱ atak oga ichə̀r va̱ mmá kpa ká̱ ipang dat ká̱ aGilgal te, uza̱ ga̱ɓa̱n le ga atak aEglon kang a là á na pa̱, <<Áponzhi, na n yà ká̱ nre nro mbwambwam ka̱kul ɓu.>> Te uponzhi là ôkpari wò pa̱, <<Ó fa gbai.>> Kang nkpaktak oza̱ fa gbai. ");
INSERT INTO yer_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","Te uEhut ga ka̱ atətak, ya uwa ka̱ ntəm ká̱ nkukwa ka̱ atak njul wò nrusokrusok ka̱ nzhi ngga apal, kang a là á na pa̱, <<Na n yà ká̱ nre á ɓu ka̱ atak Inan.>> Uponzhi wong ka̱ apal ìtok iponzhi wò te, ");
INSERT INTO yer_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","uEhut ga ká̱ awo apəra̱m wò, á tur ndokchi va̱ uza̱ ka̱ ran ka̱ ìsong iga awo ari wò ká̱, kang á kyer na ká̱ ka̱ afu. ");
INSERT INTO yer_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","Atak nkpan awo ndokchi va̱ ta tar afu kpa nzəng ká̱ ishi, kang oga iya̱m afu fa agbai. UEhut tutur ndokchi va̱ ta ka̱t, kang mpip gún ndokchi va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","Te uEhut fa ka̱ ashe agəla̱n, kang nva̱ngva̱ uza̱ fa chit te, uza̱ kùk oga anung nkəlang aponzhi va̱ ta, kang á vərang oza̱. ");
INSERT INTO yer_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","Ka̱ nva̱ngva̱ uza̱ ga chit te, ozwal aponzhi ɓa, kang oza̱ ya oga anung nzhi ngga nzhi ngga apal nrusokrusok aponzhi mmá avərangvərang te, oza̱ là pa̱, <<Uwa i yà ka̱ mpəngpəng ka̱ afu nzhi ngga ashe ngga nzhi iponzhi.>> ");
INSERT INTO yer_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","Oza̱ lok atak ga rwam oza̱, ǹnyi te, awalang va̱ oza̱ ya pa̱ uza̱ bol atak njul va̱ ta ka̱t te, oza̱ yar iya̱m iga mbol anung nzhi oza̱ bol ká̱, kang oza̱ ya unəm uga nzhi oza̱ kú chit ra ka̱ mbin. ");
INSERT INTO yer_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","Oza̱ ka̱ yà ka̱ nlok te, uEhut bar chit, uza̱ watar oga ichə̀r va̱ mmá kpa ká̱ ipang, kang a ga aSeyira. ");
INSERT INTO yer_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","Awalang va̱ uza̱ chu te, uza̱ ɓur agbəshi ka̱ apal aɗuktum aEfrayim. Te oIsa̱rila fəng nzəng ká̱ na ka̱ apal oga aɗuktum va̱ ta, kang uza̱ ləp mpyal ôza̱. ");
INSERT INTO yer_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","Uza̱ là ôza̱ pa̱, <<Ó yar nva̱ng mi, ka̱kul uYawe na okpa ìkum wó, onəm oga aMowap chit ka̱ ashe awo wó.>> Te oza̱ fəng ka̱ nvəva̱ng, oza̱ vyat atak mpa̱ng awang aUrdun va dər aMowap, kang oza̱ re unəm uro pa̱ uzəng pa̱ á pa̱l ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","Ka̱ awalang va̱ ta te, oza̱ gbá̱ng onunggwan oga aMowap ìkalong pa̱ igba̱pchi, nkpaktak oza̱ oga ǹnyi ìkum okamkam. Unəm uro yà bar ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","Ka̱ nda va̱ ta te, oIsa̱rila nəm igwan ká̱ aMowap, kang mbin va̱ ta təm ká̱ ikángkáng izun ìsəm pa̱ ìna̱nne. ");
INSERT INTO yer_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","Ka̱ nva̱ng aEhut te, uShamgar uya aAnat ununggwan, uva gbá̱ng oFilisti ìgba̱l pa̱ ìkpa̱ɗing ká̱ ayok aga ngwap iram ina. Uza̱ ka̱m ishi oIsa̱rila kpa. ");
INSERT INTO yer_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Ka̱ nva̱ng ikú aEhut te, onəm oga aIsa̱rila nəm nnap-mɓá̱ngɓa̱ng ka̱ mpyal aYawe kà̱ɗi. ");
INSERT INTO yer_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Te uYawe na oza̱ ka̱ ashe awo aJabin uponzhi uga aKanana, uva ka̱ nnəm iponzhi ka̱ aHazor. USisera, unəm uga mpyal oshozhashozha, ka̱ ntəm ka̱ aHaroshet-Hagoyim. ");
INSERT INTO yer_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Te oIsa̱rila yar ayə́ng uYawe, ka̱kul uJabin wa ka̱ yà ká̱ akeke ipəri aga acham ìgba̱l pa̱ ìfangzəngtəng, kang uza̱ pak inok nnyán ká̱ ovan oIsa̱rila chit pa̱ zhalatzhalat ka̱ apal ìzun ìsəm pa̱ iparəm. ");
INSERT INTO yer_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Ǹyangmata̱ te, uDebora uchar aLapidot, uchar uga nka̱m nre ka̱ atak Inan, ka̱ awalang va̱ ta te, uwa uchar uga nnap-akwali ovan oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Uza̱ i təm ka̱ vəng akulom aDebora ka̱ ishimshe aRama ká̱ aBetel ka̱ mbin ngga aɗuktum aEfrayim, kang onəm oIsa̱rila i kyén i ga ka̱ na ka̱kul nnap-akwali. ");
INSERT INTO yer_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Te uza̱ re nre pa̱ mmá wór uBarak, uya aAbinowam ununggwan ka̱ aKadesh aga aNaftali, kang uza̱ là á na pa̱, <<UYawe, Inan oIsa̱rila, nak á ɓu pa̱, <U ga, na u ɓut onəm ìkalong pa̱ igba̱pchi ka̱ ashe onəm aNaftali ká̱ aZebulun na u ləp mpyal ôza̱ na ó ga aƁam aTabor. ");
INSERT INTO yer_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Ǹnyi te, mi dap uSisera, unəm uga mpyal oshozha aJabin, ká̱ oga akeke ipəripəri, ká̱ nggatəkgatək, i ɓa aWang aKishon, te mi ná na ka̱ ashe awo ɓu.> >> ");
INSERT INTO yer_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Te uBarak là á na pa̱, <<A yà pa̱ ɓu ga nzəng ká̱ mi te, mi gəga, ǹnyi te, a yà pa̱ ɓu ga nzəng ká̱ mi ka̱t te, mi ga ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Te uDebora là pa̱, <<Nkpak pa̱ n ga nzəng ká̱ ɓu, ǹnyi te, ka̱kul atak nsat va̱ u yar ta̱ te, igwan achen va̱ ta i yà iji ɓu ka̱t, ka̱kul uYawe i na uSisera ka̱ ashe awo achar.>> Te uDebora wong ga aKedesh nzəng ká̱ uBarak. ");
INSERT INTO yer_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Ka̱ ta te, uBarak wór onəm aZebulun ká̱ onəm aNaftali, kang onunggwan ìkalong pa̱ igba̱pchi yar nvəva̱ng. UDebora ga nzəng ká̱ na kpa. ");
INSERT INTO yer_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Ǹyangmata̱ te, uHeber unəm oKeni va̱n ishi wò pa̱ ɗi ka̱ ashe oKeni, ka̱ akum ìjili aHobap ugwar aMusa, kang uza̱ la̱p apa̱k wò dat ká̱ ikun aoak ka̱ aZayanannim, va dat ká̱ aKedesh. ");
INSERT INTO yer_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Awalang va̱ mmá là ûSisera pa̱ uBarak uya aAbinowam kyén chit ɓa ga aɓam aTabor, ");
INSERT INTO yer_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","te uSisera kwap nkpaktak oga akeke ipəri wò iga acham igba̱l pa̱ ìfangzəngtəng, ká̱ nkpaktak onunggwan va̱ nzəng ká̱ na, ɓan ka̱ aHaroshet-Hagoyim ga chu aWang aKishon. ");
INSERT INTO yer_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Te uDebora là uBarak pa̱, <<Wong, ka̱kul nda va ta̱ uYawe na uSisera chit ka̱ ashe awo ɓu. UYawe ga chit ka̱ mpyal ɓu ka̱t ɗò? Te uBarak fə́r ka̱ apal aɓam aTabor ká̱ onunggwan ìkalong pa̱ igba̱pchi nzəng ká̱ na. ");
INSERT INTO yer_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Te uYawe nak uSisera zwar ká̱ nkpaktak oga akeke ipəripəri, ká̱ nkpaktak onəm oga lung ìkukum ka̱ mpyal aBarak ka̱ atak ndokchi. Kang uSisera fə́r ka̱ apal akeke ipəri wò chə́r ká̱ ashar. ");
INSERT INTO yer_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Kang uBarak wà nva̱ng oga akeke ipəri ká̱ onəm oga nlung ìkukum ga chu aHaroshet-Hagoyim, kang mmá gbá̱ng nkpaktak nggatək aSisera tak ká̱ ndokchi, unəm uro yà lar ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Te uSisera chə́r ká̱ ashar ga aghal aJayel, uchar aHeber, unəm oKeni, ka̱kul ntəm ikángkáng nna yà ka̱ ishimshe aJabin, uponzhi uga aHazor ká̱ nzhi aHeber, unəm oKeni. ");
INSERT INTO yer_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Te uJayel fa gwang uSisera kang a là á na pa̱, <<Ɓa, ɓa ashe aghal mi, anəm uga nzhi mi, kang ayər a nəm ɓu ka̱t.>> Te uza̱ ga ashe aghəghal, kang uza̱ gún na ká̱ agodò. ");
INSERT INTO yer_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","USisera là á na pa̱, <<N chal ɓu, na ndəng á mi ká̱ pa̱ ɗa̱p n wá, ka̱kul ndəng gba̱l mi gba̱l.>> Te uza̱ bol izəmɓa̱r iga nnak mbyal, uza̱ na mbyal á na wá, kang uza̱ gún na. ");
INSERT INTO yer_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Te uza̱ là á na pa̱, <<Sat ka̱ anung asa̱l aga ntar aghal va̱ ta̱, a yà pa̱ unəm uro á ɓa á ɓəp ɓu pa̱,<Unəm uro uwa yà ka̱ ta̱ ɗò?> Te wa là á na pa̱ <O'o.> >> ");
INSERT INTO yer_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Ǹnyi te, uJayel, uchar aHeber, yar iya̱m iga mpak aghal ká̱ nka̱m ala ka̱ awo wò. Kang uza̱ mwom ga atətak, ga pak á na ka̱ mbe achwang ga fu mbin, ka̱kul nda gba̱l na chit, ka̱ atak nrwam ìzər nchə́r va̱ uza̱ chə́r á. Te uza̱ kú. ");
INSERT INTO yer_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Nva̱ uBarak ka̱ mɓak nva̱ng aSisera te, uJayel fa gwang na kang á là á na pa̱, <<Ɓa na n nyám unəm va̱ á ɓu, ɓu ram á.>> Te uBarak tar ashe aghəghal, kang uza̱ ya uSisera kú chit ra, ká̱ iya̱m iga mpak aghal ka̱ mbe achəchwang. ");
INSERT INTO yer_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Ká̱ nda va̱ ta te, Inan na igwan ônəm oga aIsa̱rila ka̱ apal aJabin, uponzhi uga aKanana. ");
INSERT INTO yer_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Kang ovan oga aIsa̱rila pak nnəm igwan kam ka̱ apal aJabin, uponzhi uga aKanana, a ga chu awalang va̱ oza̱ zhì na. ");
INSERT INTO yer_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","Ka̱ ilum va̱ ta te, uDebora ká̱ uBarak uya aAbinowam ununggwan shì nnap-nshì va̱ ta̱ pa̱, ");
INSERT INTO yer_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","<<Awalang va̱ onəm oga mpyal oIsa̱rila yar atak nsat oza̱, awalang va̱ onəm na ishi oza̱ ka̱ ashe mma̱n oza̱ te, ashep təm aji aYawe. ");
INSERT INTO yer_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","Ó fe mmawó oponzhi, ó gwong achwang mmawó ovan oponzhi, mmami, à, mi shì nnap kpa ûYawe, mi shì nnap-nshì ashep ûYawe, Inan oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","<<ÁYawe, ka̱ awalang va̱ u fa ka̱ aSeyir, awalang va̱ u fa ka̱ mbin aEdom te, apambin yənggət, apal apaɓur zùk, oga ìlulu zùk ndəng. ");
INSERT INTO yer_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","Oga aɓam yənggət ka̱ mpyal aYawe uga aSinayi, ka̱ mpyal aYawe, Inan oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","<<Ka̱ ashe nra aShamgar uya aAnat ununggwan, ka̱ ashe nra aJayel te, mmá re ngwol oga anang asa̱l, kang onəm oga nnəm achen wòl oga avan asa̱l aga ashe nzam. ");
INSERT INTO yer_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","ONəm oga ntəm ka̱ ashe ivan ìtong oIsa̱rila yà ka̱ ashishe lap ka̱t, oza̱ yà ka̱ ashishe ka̱t, a ga chu awalang va̱ mmami, uDebora n wong, n wong wa anang ka̱ ashe aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","Awalang va̱ oIsa̱rila yak oga inan ìpipye te, ìkum ɓa fa ka̱ oga anung asa̱l ìtong oza̱. Ǹnyi te, mmá ya nggwanggwang nro, ka̱t te, aɓar aro ka̱ ashe onəm oga nlung ìkum ìkalong ìsəm pa̱ ineɗing ka̱ aIsa̱rila ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","Ìgwak mi ga ka̱ atak onəm oga mpyal ìkum oIsa̱rila, ka̱ atak onəm va na ishi oza̱ ká̱ nchang ìgwak. Ashep təm aji aYawe. ");
INSERT INTO yer_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","<<Mmawó va̱ ó kwak oga azhaki achar aləfər, mmawó va̱ ó təm ka̱ apal oga agodò nkongkong kang mmawó va̱ ó chen ka̱ apal asa̱l, ó nak ishi ");
INSERT INTO yer_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","ká̱ achu onəm oga nshì nnap ka̱ anung ndəng nka̱pka̱p. Oza̱ ka̱ nshal nnap ka̱ apal igwan aYawe, igwan va onəm oga ntəm ka̱ ivan ìtong ka̱ ashe aIsa̱rila nəm á. <<Te onəm aYawe fa ga oga anung asa̱l ìtong oza̱. ");
INSERT INTO yer_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","Yenda̱l, yenda̱l, aDebora. Yenda̱l, yenda̱l, na u shì nnap. Wong, aBarak, wur izwal ká̱ okpa ìkum ɓu, áya aAbinowam. ");
INSERT INTO yer_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","<<Te aɓo onəm chumchum va̱ re á ɓa atak onəm oga mpyal, onəm aYawe fə́r vang atak mi, ka̱kul nlung onəm kamkam. ");
INSERT INTO yer_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","Oro wong ka̱ aEfrayim, ova alə̀ng oza̱ ka̱ aAmalek kang a vàng, akum ìjili aBenjamin oma yà ka̱ ashe onəm va̱ yar nva̱ng ɓu. Onəm oga mpyal ìkum ka̱ aMakir fə́r vang, ka̱ aZebulun te, onəm oga nkpán idari anəm uga mpyal ɓa. ");
INSERT INTO yer_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","Onəm oga mpyal aIsaka oma yà nzəng ká̱ uDebora, nnandər, onəm aIsaka oma ka̱ yà nzəng ká̱ uBarak, oza̱ yar nvəva̱ng fə́ng ga ashe aba̱nda̱m. Ǹnyi te, ka̱ ashe akum ìjili aRuben te, anung gwar ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","Iza̱ nak kang ó təm ka̱ ashe afo itam yà? ka̱kul pa̱ na ó fe mɓur ayər aga ngwór iya̱mkang ɗò? Ǹnyi te, ka̱ ashe akum ìjili aRuben te, anung gwar ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","Akum ìjili aGileyat təm ka̱ agwong aUrdun, sang kang akum ìjili aDan təm ka̱ atak oga agirgi ndəng ji oza̱ yà? UAsher uwa ka̱ ntəm ka̱ anung ìwa, uza̱ təm ka̱ atak mpa̱ng oga agirgi ndəng. ");
INSERT INTO yer_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","Onəm aZebulun ká̱ uNaftali jiwò te, oza̱ yang ká̱ irirì oza̱ fa agbagba ìkum. ");
INSERT INTO yer_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","<<Oponzhi ɓa, oza̱ nəm ìkum, oponzhi oKanana lung ìkum. Ka̱ aTayanak, ka̱ atak oga ndəng ngga aMegido, oza̱ wur iya̱m iga ngwur ka̱ atak ìkum ká̱ aazurfa ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","Ka̱ apaɓur oga izhan lung ìkum, ka̱ ashe oga anang asa̱l oza̱, oza̱ lung uSisera. ");
INSERT INTO yer_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","Awang aKishon wur oza̱ ga ká̱, awang agbakgbak va̱ ta, awang aKishon. Chen ga, áirirì mi, yà ká̱ ikam. ");
INSERT INTO yer_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","Te ashar ipəri i chen i nap mmá ka̱ nfe nnáp ndong ashar oza̱ i chen ká̱ ngghan ka̱kul nkam oga ashar oza̱. ");
INSERT INTO yer_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","<<UMa̱leka aYawe là pa̱, <vyap aMerot>, vyap onəm oga ntəm ka̱ ashishe pa̱ gənggəng, ka̱kul oza̱ ɓa pa̱ na ó ka̱mshi uYawe ka̱t, pa̱ na ó ka̱mshi uYawe ka̱ nlung onəm kamkam ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","UJayel wà ká̱ nnap-nnəna̱n ji pa̱ kpaktak ka̱ ashe ochar, uchar aHeber unəm oKeni, uwà ká̱ nnap-nnəna̱n ji ka̱ ashe ochar oga ntəm ka̱ ashe aghal á. ");
INSERT INTO yer_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","USisera ɓəp ndəng te, uza̱ na mbyal á na. Uza̱ ɓa ká̱ mbyal va̱ ká̱ mmì á na ka̱ ashe ìkpang onəm chumchum. ");
INSERT INTO yer_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","Uza̱ yar acham aga mpak aghal ka̱ awo, uza̱ kpán nka̱m ala anəm uga inok ka̱ awo ari, uza̱ ləp uSisera, uza̱ chwan ishi á na, uza̱ chwan ishishi, kang a kyer na ka̱ mbe achwang. ");
INSERT INTO yer_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","Uza̱ kwangtal ka̱ mpyal achar va̱ ta, uza̱ ru, uza̱ ra pa̱ kwak ka̱ ta, uza̱ kwangtal ka̱ mpipyal, uza̱ ru, ka̱ atak va̱ uza̱ kwangtal kà̱, uza̱ ru kú. ");
INSERT INTO yer_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","<<Unang aSisera dər atak ka̱ mɓol ayə́r nzhi, uza̱ yə́ng ka̱ mɓol ayə́r nzhi va̱ ta pa̱, iza̱ nak kang oga akeke ipəripəri kali ká̱ mɓa yà? Iza̱ nak kang nva̱ng ashar oga akeke ipəripəri kali ka̱ mɓa yà? ");
INSERT INTO yer_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","Ovanchəchar va̱ tàn ji na ama̱n á na pa̱, nnandər, uza̱ pak inok nlà îshi wò pa̱, ");
INSERT INTO yer_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","<Oza̱ ka̱ mmwo kang oza̱ i kap iya̱m iga ngwur ka̱ atak ìkum ka̱t ɗò? Nza̱ unəm nggo ya uyenchar pa̱ uzəng, ka̱t te pa̱ oparəm, ilukwan iɓyenɓyen iga mbwai ûSisera wa iya̱m iga ngwur ka̱ atak ìkum, ilukwan iɓyenɓyen ira̱pra̱p iga mbwai, ilukwan iɓyenɓyen ira̱pra̱p iga mbwai va ji ka̱kul nsham isham nkpaktak oga iya̱m va̱ ta̱ iya̱m iga ngwur ka̱ atak ìkum á?> ");
INSERT INTO yer_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","<<Re nkpaktak okpa ìkum ɓu á zhì, áYawe. Ǹnyi te, re nkpaktak okpa ɓu a yà wa alum awalang va i fa ka̱ ashe ikam wò.>> Te mbin təm ká̱ ikángkáng ìzun ìsəm pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Kang ovan oIsa̱rila nəm nnap-mɓá̱ngɓa̱ng ka̱ mpyal aYawe, te uYawe na oza̱ ka̱ ashe awo oMidiyan ìzun pa̱ ifangshat. ");
INSERT INTO yer_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Ka̱kul oMidiyan nəm igwan ka̱ apal oIsa̱rila te, onəm oga aIsa̱rila ɗa̱mshi oga atak mbwam îshi oza̱ ka̱ ashe oga mbagar aɓam, ká̱ oga agba̱k, ká̱ oga atak mbwam ngga akamsəlang. ");
INSERT INTO yer_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Awalang va pa̱ kpaktak oIsa̱rila i suk iya̱m chit te, oMidiyan, ká̱ oAmalek, ká̱ onəm va̱ ka̱ asa̱l nfa alum i ɓa i ru oza̱ ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Oza̱ ləp apa̱k ka̱ ashe mbin va̱ ta, kang oza̱ vyap iya̱m nsuk ga chu aGaza, oza̱ wur itam, ká̱ ina, ká̱ oga azhaki, kang oza̱ re iya̱m iro ka̱ ashe aIsa̱rila ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Oza̱ ɓa ká̱ iya̱mkang, ká̱ oga aghal oza̱, yə́l wa mban ìkum. Oza̱ ká̱ nkpaktak oga alakəmi oza̱, yə́l yà ká̱ nkung ka̱t, táng ashe mbin va̱ ta pa̱ na ó vyap na. ");
INSERT INTO yer_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","OMidiyan nak nkun ônəm oga aIsa̱rila pa̱ makmak, a nak te, oza̱ yə́ng ûYawe pa̱ á ka̱mshi wó. ");
INSERT INTO yer_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Ka̱ nva̱ngva̱ ovan oIsa̱rila yə́ng ûYawe chit ka̱kul oMidiyan te, ");
INSERT INTO yer_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","uYawe re nre ôza̱ ká̱ unəm uga nka̱m nre ka̱ atak Inan uva là ôza̱ pa̱, <<Iya̱m va ta̱ uYawe, Inan oIsa̱rila là. N fa ká̱ wó ka̱ aMasar, n fa ká̱ wó ka̱ mbin izwal. ");
INSERT INTO yer_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","N fa ká̱ wó ka̱ ashe awo onəm oga aMasar, kang n fa ká̱ wó ka̱ ashe awo nkpaktak onəm oga nyán ká̱ wó. M ɓak oza̱ le ka̱ mpyal wó, kang n na mbin oza̱ á wó. ");
INSERT INTO yer_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","N là á wó pa̱, <Mmami na uYawe, Inan wó, kang ó wop oga inan oAmori ova mmawó ka̱ ntəm ka̱ ashe mbin oza̱ ka̱t.> Ǹnyi te, ó gwong achwang ka̱ mi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Te uma̱leka aYawe fa təm ka̱ avəng ikun aoak ka̱ aOfəra, iva iji aJowash unəm uga akum aAbiyezer, atak va uyiyen uGidiyon ka̱ yà ka̱ mpək ìzangzəng ka̱ atak nkáng ìba̱ngba̱ng, ka̱kul pa̱ na o bwam, le kang oMidiyan á ya ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Awalang va̱ uma̱leka aYawe nyám ishi wò ûGidiyon te, á là á na pa̱, <<UYawe uwa yà nzəng ká̱ ɓu, áyennunggwan ìkum.>> ");
INSERT INTO yer_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Te uGidiyon na ama̱n á na pa̱, <<Kusuk, ánəm uga nzhi mi, a yà pa̱ uYawe uwa ya nzəng ka̱ yi, te sang kang oga nnap va̱ ta̱ i yà yi yà? Te oga nnənap ngga nɗaktak va̱ che, nna opo yi ka̱ shet á yi pa̱, uYawe uwa fa ká̱ wó ka̱ aMasar yà? Kang ǹyangmata̱ te, uza̱ mandar yi chit, kang uza̱ na yi ka̱ ashe awo oMidiyan.>> ");
INSERT INTO yer_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Te uYawe ga̱ɓa̱n là á na pa̱, <<Ga ka̱ ashe nkam ɓu va̱ ta na u ka̱m ishi oIsa̱rila ka̱ ashe awo oMidiyan. Mmami na ka̱ nre ɓu ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Te uGidiyon na ama̱n pa̱, <<Kusuk, ánəm uga nzhi mi, mi ka̱m ishi ôIsa̱rila wa sang yà? Dər, ka̱ ashe akum ìjili aManase te, akum mi na kam ka̱t, kang ka̱ ashe nzhi apo mi te mmami na n nyen ji.>> ");
INSERT INTO yer_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Te uYawe na ama̱n pa̱, <<Mi yà nzəng ká̱ ɓu, kang ɓu gbá̱ng nkpaktak onəm oMidiya unəm uro yà i lar ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","UGidiyon na ama̱n pa̱, <<A yà pa̱ ǹyangmata̱ mi ya nka̱m ishi ya ka̱ mpyal ɓu te, nyám ìpir nnàp á mi na n nyi pa̱, mmaɓu na ka̱ nlà nnap ká̱ mi pa̱ wàt. ");
INSERT INTO yer_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Kang wa re atak va̱ ta̱ chit ka̱t, n chal ɓu, n ga n le m ɓa ká̱ imwa mi kang, mi nak ka̱ mpyal ɓu.>> Te Uza̱ là pa̱, <<Mi lok yà ɓu le kang.>> ");
INSERT INTO yer_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Te uGidiyon tar ashe, kang a ɗa̱mshi ìzhe iya iɓəl, ká̱ nzəngkəng va yà ká̱ anyer ka̱t nva ma nəm ka̱ mma̱k ikpang iga mmà iya̱m pa̱ ìzəng. Uza̱ nak ìzhe ka̱ ashe anap, kang mməmal ka̱ ashe ngbət, te uza̱ fa ká̱ á na ka̱ avəng ikun aoak, uza̱ yichi á na. ");
INSERT INTO yer_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Te uma̱leka Inan là á na pa̱, <<Yar ìzhe va̱ ta ká̱ nzəngkəng ngga nyà ká̱ anyer ka̱t, nak oza̱ ka̱ apal ipang va̱ ta̱, te kwonda̱l mmal ka̱ apal oza̱.>> Te uGidiyon nəm wanta. ");
INSERT INTO yer_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Te uma̱leka aYawe dok ìzhe va̱ ta ká̱ nzəngkəng ngga nyà ká̱ anyer ka̱t ká̱ ishi ìdari va̱ ka̱ awuwo. Te apər fa ká̱ ìpang á ri ìzhe va̱ ta, ká̱ nzəngkəng. Te uma̱leka aYawe lar ka̱ mpipyal. ");
INSERT INTO yer_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Awalang va̱ uGidiyon nyi chit pa̱ uma̱leka aYawe te, uza̱ là pa̱, <<Á làk ká̱ mi chit, áNəm uga Nzhi, uYawe. N ya uma̱leka aYawe chit ìwu ká̱ ìwu.>> ");
INSERT INTO yer_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Te uYawe là á na pa̱, <<Yà ká̱ nra ìgwak, kang ayər a nəm ɓu ka̱t, ɓu yà ká̱ nkú ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Te uGidiyon me atak aga nshì iya̱m awop ûYawe ka̱ ta, kang uza̱ wór pa̱, UYawe uwa ikángkáng. Nda ta̱ nna yà ka̱ aOfəra, ava aga akum ìjili aAbiyezer. ");
INSERT INTO yer_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Ká̱ izwam va̱ ta te, uYawe là á na pa̱, <<Kpán akut apo ɓu, apəpar, ka̱ ashe iya̱m nkəkang ava ìzun pa̱ ifangshat. Shin atak nshì iya̱m awop ìchər aBaal aji apo ɓu, kang ɓu kyen ndar aAshera va̱ ka̱ ngbəgba̱k. ");
INSERT INTO yer_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Te me atak nshì iya̱m awop ava mal ûYawe, Inan ɓu ká̱ ípang ka̱ apal atak mbwam ngga aɗuktum va̱ ta̱. Te yar akut aga aparəm na iya̱m inana iga nshì ká̱ ká̱ akun aAshera va̱ u kyen á.>> ");
INSERT INTO yer_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Te uGidiyon kpa̱k onəm pa̱ ogba̱pchi ka̱ ashe ozwal wò, uza̱ nəm wa nva uYawe là á na. Te ka̱kul pa̱ uza̱ ka̱ nnəm ayər nzhi apo wò ká̱ onəm oga ìtong, te uza̱ nəm inok va̱ ta ká̱ alum ka̱t, uza̱ nəm ká̱ izwam. ");
INSERT INTO yer_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Awalang va̱ onəm oga ìtong wong ká̱ ìpin te, oza̱ ya mmá shin atak nshì iya̱m awop ìchər aBaal chit, kang oga ndar aAshera va̱ ka̱ ngbəgba̱k te, mmá kyen chit tak, kang akut aga parəm mmá yichi chit ka̱ apal atak nshì iya̱m awop va̱ mmá me á. ");
INSERT INTO yer_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Te oza̱ ɓəp owan oza̱ pa̱, <<Uda nəm iya̱m va̱ ta̱ yà? Kang nva̱ngva̱ oza̱ gbap chit, te mmá là oza̱ pa̱, uGidiyon uya aJowash ununggwan wa nəm iya̱m va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Te onəm oga ìtong là ûJowash pa̱, <<Ɓa ká̱ uyen ɓu, na uza̱ á kú, ka̱kul uza̱ shin atak nshì iya̱m awop ìchər aBaal, kang uza̱ kyen oga ndar aAshera va̱ ka̱ ngbəgba̱k tak.>> ");
INSERT INTO yer_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Ǹnyi te, uJowash na ama̱n n̂kpaktak onəm va̱ ka̱ nfa iya̱mkak ká̱ wò pa̱, <<Ó lung nnap aBaal na ɗò? Ka̱t te ó ka̱m ishishi ka̱m ɗò? Unəm va̱ ka̱ nlung nnənap te, re mmá gba̱l na ká̱ ìpin na byet. A yà pa̱ uBaal inan yà nna̱n te, re uza̱ á lung îshi wò, ka̱kul pa̱ unəm uro shin atak nshì iya̱m awuwop chit tak.>> ");
INSERT INTO yer_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Ka̱kul pa̱ uGidiyon shin atak nshì iya̱m awop aBaal chit te, oza̱ na aɗin á na pa̱, uJerup-Baal, ipipir pa̱, <<Re uBaal á lung na.>> ");
INSERT INTO yer_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Ǹyangmata̱ te, nkpaktak oMidiyan, ká̱ oAmalek, ká̱ onəm oga asa̱l nfa alum gwang ishi kang a pa̱ng aUrdun, ləp apa̱k ka̱ mba̱nda̱m aJezireyel. ");
INSERT INTO yer_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Te aRuhu aYawe vàng ka̱ apal aGidiyon, kang uza̱ ɓur agbəshi, te mmá wór akum ìjili aAbiyezer ɓut kang oza̱ yar nvəva̱ng. ");
INSERT INTO yer_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Uza̱ re nre ká̱ onəm oga nre ka̱ ashe nkpaktak aManase, kang oza̱ wór ɓut, oza̱ yar nvəva̱ng kpa. Kang uza̱ re nre ká̱ onəm oga nre ka̱ atak onəm aAsher, ká̱ uZebulun, ká̱ uNaftali, te oza̱ fa ga gwang oza̱. ");
INSERT INTO yer_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Kang uGidiyon là uYawe pa̱, <<A yà pa̱ ɓu nəm inok ká̱ mi ɓu ka̱m ishi aIsa̱rila ka̱m, wa nva̱ ka̱ u là te, ");
INSERT INTO yer_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","dər, mi nak awulu ka̱ atak mpək iya̱m. A yà pa̱ ìmimyang a ra ka̱ apal awulu va̱ ta na ká̱ nkukwa, kang nkpaktak mbin wuwom te, mi nyi pa̱ ɓu nəm inok nəm ká̱ mi ɓu ka̱m ishi aIsa̱rila ka̱m, wa nva̱ ka̱ u là á.>> ");
INSERT INTO yer_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Te wa nnà ta á yà. UGidiyon wong ká̱ ìpin ikpa̱kkpa̱k ká̱ iɓotak te uza̱ káng ìmimyang iga izər awulu va̱ ta, kang ndədəng yə́l ìkpang pa̱ ìzəng. ");
INSERT INTO yer_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Te uGidiyon là Înan pa̱, <<Kang wa mən ìkum ká̱ mi ka̱t. Re mi n là nnap nva̱ng pa̱ nzəng byet kang, re mi m ma nva̱ng pa̱ nzəng kà̱ɗi ká̱ awulu, re awulu na a wom byet, te re ìmimyang a ra ka̱ mbin pa̱ kpaktak.>> ");
INSERT INTO yer_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Inan nəm wanta ká̱ izwam va̱ ta, ka̱kul awulu na təm awomwom byet, kang mbin pa̱ kpaktak te, á ra ìmimyang. ");
INSERT INTO yer_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Te uJerup-Baal, uwa uGidiyon á, wong ká̱ iɓotak ká̱ nkpaktak onəm va̱ nzəng ká̱ na, oza̱ ga ləp apa̱k dat ká̱ ndəng mɓəlɓəl ngga aHarot. Kang apa̱k oMidiyan ka̱ asa̱l mpal oza̱, ka̱ ashe aba̱nda̱m va̱ da̱t ká̱ aɗuktum aMoreh. ");
INSERT INTO yer_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Te uYawe là ûGidiyon pa̱, <<Onəm va̱ nzəng ká̱ ɓu yəl byet. Mi yà ká̱ nna oMidiyan ka̱ ashe awo ôza̱ ka̱t, le kang oIsa̱rila a ləp ìkwoksok pa̱, <i ri oza̱ ká̱ ìkam yi> ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Ǹyangmata̱ te, là ônəm pa̱, unəm va̱ pa̱ káp ayər ka̱ nnəm na kang uza̱ ka̱ ntán te, uza̱ á le, á re aɓam aGileyat na uza̱ á ga iya̱m wò.>> Te onəm ìkalong ìsəm pa̱ iparəm ama̱n pa̱ parəm le, kang aɓo onəm ìkalong pa̱ igba̱pchi tong. ");
INSERT INTO yer_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Ǹnyi te, uYawe là ûGidiyon pa̱, <<Onəm va̱ ta̱ oma yəyəl. Fa ga ká̱ oza̱ ka̱ atak ndəng, na m ma oza̱ á ɓu ka̱ ta, kang uvəngva̱ n là á ɓu pa̱, i ga ká̱ ɓu, te uza̱ i ga ká̱ ɓu, kang uvəngva̱ pa̱ kpaktak n là á ɓu pa̱, i ga ká̱ ɓu ka̱t, te uza̱ i ga ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Te uGidiyon fa ga ká̱ onəm va̱ ta ka̱ atak ndəng, kang uYawe là á na pa̱, <<Ven onəm va̱ i yep ndəng ká̱ aɓələm wa ìva á le pa̱ɗi ka̱ izər onəm va í ɓəram ká̱ irəng kang i wá.>> ");
INSERT INTO yer_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Iyəl onəm va̱ kpa̱k ndəng ká̱ awo kang a wá, i yep wa iva te, oza̱ igba̱l pa̱ ishatɗing, aɓoshi onəm pa̱ kpaktak te, a ɓəram ká̱ irəng kang a wá ndəng. ");
INSERT INTO yer_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Te uYawe là ûGidiyon pa̱, <<Ká̱ onəm oga igba̱l pa̱ ishatɗing va ta̱ ova yep ndəng te, mi ka̱m ishi wó, kang mi na oMidiyan ka̱ ashe awo wó. Re aɓo oza̱ á ga nzhi.>> ");
INSERT INTO yer_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Te uGidiyon re nkpaktak aɓo oIsa̱rila le ga nzhi, ǹnyi te, uza̱ kpan oga igba̱l pa̱ ishatɗing va̱ ta. Oza̱ ka̱m oga iya̱m-nrì ká̱ oga agbəshi ka̱ awo owan oza̱ va̱ le. Ǹyangmata̱ te, apa̱k oMidiyan ka̱ avəng oza̱ ka̱ mba̱nda̱m. ");
INSERT INTO yer_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Ká̱ izwam va ta uYawe là ûGidiyon pa̱, <<Wong, ga ru apa̱k oza̱ ká̱ ìkum, ka̱kul n na chit ka̱ ashe awo ɓu. ");
INSERT INTO yer_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Kang a yà pa̱ ayər ngga nru oza̱ ká̱ ìkum ka̱ nnəm ɓu te, fa ga ashe apa̱k va̱ ta nzəng ká̱ uPura uzwal ɓu, ");
INSERT INTO yer_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","na u fe iya̱m va̱ oza̱ ka̱ nləlà. Ka̱ nvəva̱ng te, ìgwak i kam á ɓu pa̱ u ru apa̱k oza̱ ká̱ ìkum.>> Te uza̱ fə́r vang nzəng ká̱ uPura uzuzwal ga chu aswari apa̱k va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Kang oMidiyan, ká̱ oAmalek, ká̱ nkpaktak onəm oga asa̱l nfa alum ra məl ka̱ ashe aba̱nda̱m yə́l wa mban ìkum. Oga alakəmi oza̱ yə́l yà ká̱ nkung ka̱t, wa nva ashishiri yə́l ka̱ anung awang á. ");
INSERT INTO yer_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Ka̱ awalang va̱ uGidiyon ɓa chu ka̱ ta te, uza̱ fe unəm uro i shal izwam ûwan wò i là pa̱, <<Dər, n lar izwam, te n ya mɓit nzəngkəng ibəshi i ɓəndəng i tar ashe apa̱k oMidiyan. Á ləp aghal va̱ ta ru ga̱ɓa̱n ga nggərgang, kang a shin.>> ");
INSERT INTO yer_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Te ukpəkpa na ama̱n á na pa̱, <<Iya̱m ata̱, iya̱m iro ka̱t, ndokchi aGidiyon uya aJowash ununggwan, unəm oIsa̱rila. Inan na oMidiyan chit ká̱ nkpaktak apa̱k ka̱ ashe awuwo.>> ");
INSERT INTO yer_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Awalang va̱ uGidiyon fe nshal izwam va̱ ta ká̱ nlà ìpipir te, uza̱ kuchi shep Inan. Te uza̱ le apa̱k oIsa̱rila kang uza̱ là pa̱, <<Ó wong, ka̱kul uYawe na apa̱k oMidiyan chit ka̱ ashe awo wó.>> ");
INSERT INTO yer_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Kang uza̱ kap onunggwan oga igba̱l pa̱ ishatɗing va̱ ta idongkong pa̱ ishatɗing, te uza̱ na agbəshi n̂kpaktak oza̱ ka̱ awo, ká̱ ìɗyeri ilakchi, oga apitila na chwat ka̱ ashe oza̱. ");
INSERT INTO yer_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Te uza̱ là ôza̱ pa̱, <<Ó dər mi, iya̱m va̱ mi nəm te, ó nəm kpa. Awalang va̱ mi ga mi chu nkur apa̱k te, iya̱m va̱ mi nəm, te ó nəm wa nnà ta kpa. ");
INSERT INTO yer_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Awalang va̱ mmami ká̱ nkpaktak onəm va̱ nzəng ká̱ mi a ɓur oga agbəshi yi te, ó ɓur oga agbəshi wó kpa ka̱ nza̱ nkpaktak ngba̱k apa̱k va̱ ta nggo, ó là pa̱,<Ka̱kul aYawe kang ka̱kul aGidiyon.> >> ");
INSERT INTO yer_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Te uGidiyon ká̱ onunggwan oga igba̱l pa̱ ìzəng va̱ nzəng ká̱ na ga chu nkur apa̱k va̱ ta ká̱ ishimshe izwam, yà nna mmá pa̱ng onəm oga mpángchí atak chit gbà̱ng nva̱ng ka̱t. Te oza̱ ɓur oga agbəshi oza̱, kang a chwan oga ìɗyeri va̱ ka̱ oga awo oza̱. ");
INSERT INTO yer_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Idongkong iga ishatɗing va̱ ta ɓur oga agbəshi kang oza̱ chwan oga ìɗyeri. Oza̱ kpán oga apitila ka̱ awo apəra̱m oza̱, kang oga agbəshi ka̱ awo ari oza̱ ka̱kul mɓur, i nəm achu pa̱, <<Ndokchi ka̱kul aYawe, kang ka̱kul aGidiyon.>> ");
INSERT INTO yer_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Nza̱ unəm nggo yar atak nsat wò gáng apa̱k, te nkpaktak oMidiya zəp nchəng. Oza̱ i nə́m achu kang i chəng. ");
INSERT INTO yer_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Awalang va̱ onəm aGidiyon ɓur oga agbəshi aga igba̱l pa̱ ishatɗing va̱ ta te, uYawe nak oMidiyan va̱ ka̱ ashe apa̱k va̱ ta le i lung owan oza̱ ká̱ ndokchi. Oza̱ chəng ga chu aBet-Shita va dər asa̱l aZerera, lyam ga chu aswari aAbel-Mehola va dat ká̱ aTabat. ");
INSERT INTO yer_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Te mmá wór oIsa̱rila fa ka̱ ashe aNaftali, aAsher, kang ka̱ ashe nkpaktak aManase ɓut, kang oza̱ ɓak oMidiyan. ");
INSERT INTO yer_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","UGidiyon re nre ká̱ onəm oga nre ka̱ ashe nkpaktak mbin ngga aɗuktum aEfrayim pa̱, <<Ó fa ìkum ká̱ oMidiyan, na ó gəl asa̱l ka̱ atak oga ndəng aUrdun ka̱ mpyal oza̱ á ga á chu aBet-Bara.>> Te mmá wór nkpaktak onunggwan aEfrayim fa, kang oza̱ gəl asa̱l ka̱ atak oga ndəng aUrdun ga chu aBet-Bara. ");
INSERT INTO yer_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Kang oza̱ kpán oponzhi oMidiyan pa̱ oparəm kpa, uOrep ká̱ uZeyep. Oza̱ gba̱l uOrep ka̱ ìpang aOrep, kang oza̱ gba̱l uZeyep ka̱ atak nkáng ndəng ìba̱ngba̱ng aZeyep. Te oza̱ ɓak oMidiyan, kang oza̱ ɓa ká̱ ishi aOrep ká̱ uZeyep ûGidiyon ka̱ gwong awang aUrdun. ");
INSERT INTO yer_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","Te onəm oga aEfrayim là ûGidiyon pa̱, <<Sang kang u nəm á yi wa nta̱, u wór yi ka̱t awalang va̱ mmaɓu ka̱ nlung ìkum ká̱ oMidiyan ka̱t yà?>> Kang oza̱ ra̱n ká̱ na pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","Te uGidiyon na ama̱n ôza̱ pa̱, <<Iza̱ n nəm va̱ ji iji wó yà? Oga iya̱m ìchakchak ìba̱ngba̱ng aEfrayim ɓyen ji iya̱m mɓən iga ìba̱ngba̱ng aAbiyezer ka̱t ɗò? ");
INSERT INTO yer_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","Inan na oponzhi oMidiyan uOrep ká̱ uZeyep ka̱ ashe awo wó na. Iza̱ iya̱m va̱ n nəm va ji ivəngva̱ ó nəm yà?>> Nna chit te, nlak ìgwak oza̱ rusok ɗak. ");
INSERT INTO yer_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","Te uGidiyon ga aUrdun kang a pa̱l, uza̱ ká̱ onunggwan igba̱l pa̱ ishatɗing va̱ nzəng ká̱ na, oza̱ bəlak chit, ká̱ nna te, oza̱ ga mpyal ká̱ nwà nva̱ng okpa ìkum oza̱. ");
INSERT INTO yer_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","Kang uza̱ là ônunggwan oga aSukkot pa̱, <<Kusuk, ó na nzəngkəng ônəm mi va̱ ta̱ va̱ ka̱ nva̱ng mi á, ka̱kul oza̱ bəlak chit, kang na mmami ka̱ mwà nva̱ng aZeba ká̱ uZalmuna, oponzhi oMidiyan.>> ");
INSERT INTO yer_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","Ǹnyi te, onəm oga mpyal aSukkot là pa̱, <<U kpán uZeba ká̱ uZalmuna chit ka̱ ashe awo ɓu ɗò? Ka̱kul iza̱ kang í na nzəngkəng ônəm oga lung ìkum ɓu yà?>> ");
INSERT INTO yer_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","Te uGidiyon na ama̱n pa̱, <<Ka̱kul nva̱ ta te, awalang va̱ uYawe á na uZeba ká̱ uZalmuna ka̱ ashe awo mi te, mi cha izər wó ká̱ izu iga ashe nzam kang ká̱ mmər.>> ");
INSERT INTO yer_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","Te uGidiyon wong ka̱ ta ga aPeniyel, kang uza̱ ɓəp iya̱m izəngtəng va ta ka̱ atak oza̱, kang onunggwan oga aPeniyel na ama̱n á na wa nva̱ onunggwan oga aSukkot ka̱ na ama̱n á na á. ");
INSERT INTO yer_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","Te uza̱ là ônunggwan oga aPeniyel pa̱, <<Awalang va̱ mi le ka̱ ashe igwan te, mi shin nzhi nkúrkúr va̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","Ǹyangmata̱ te, uZeba ká̱ uZalmuna oma ka̱ aKarkor nzəng ká̱ onəm oga nlung ìkum oza̱, onunggwan ìkalong pa̱ igba̱pchi ama̱n pa̱ tukun, oma onəm va̱ re ka̱ ashe nkpaktak onəm ìkum ovan oga asa̱l nfa alum, ka̱kul onəm ìkalong igba̱l ká̱ ìsəm pa̱ ìparəm tak chit ka̱ ashe onunggwan va̱ zəp ndokchi. ");
INSERT INTO yer_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","Te uGidiyon wòl asa̱l onəm oga ntəm ka̱ ashe aghal va ka̱ asa̱l nfa alum aNoba ká̱ aJokbeha, kang uza̱ mul onəm oga nlung ìkum va̱ ta na pa ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","UZeba ká̱ uZalmuna, oponzhi oMidiyan oga oparəm va̱ ta chəng, ǹnyi te, uza̱ ɓak nva̱ng oza̱ ga wur oza̱, kang uza̱ nak nkpaktak onəm oga nlung ìkum va̱ ta zwar. ");
INSERT INTO yer_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","Te uGidiyon uya aJowash ununggwan le ka̱ atak ìkum va̱ ta, uza̱ wòl asa̱l va i kyén i ga aHeret. ");
INSERT INTO yer_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","Uza̱ kpán uyenza̱m uro uga aSukkot kang uza̱ kat na. Te uyenza̱m va̱ ta lir aɗin oponzhi oga aSukkot á na, oma onəmgbak oga ìtong va̱ ta á, onunggwan ìsəm pa̱ ìfangshat ama̱n pa̱ fangshat. ");
INSERT INTO yer_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","Te uGidiyon ɓa chu atak onunggwan oga aSukkot, kang uza̱ là ôza̱ pa̱, <<Ó dər, uZeba ká̱ uZalmuna oma ta̱, ova ka̱ ó nap avyal á mi, nva̱ ó là pa̱,<U kpán uZeba ká̱ uZalmuna chit ka̱ ashe awo ɓu ɗò? Ka̱kul iza̱ kang í na nzəngkəng ônunggwan ɓu va̱ bəlak chit yà? ");
INSERT INTO yer_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","Te uza̱ wur onəmgbak oga ìtong va̱ ta, kang uza̱ ɗyang ntàn ônəm oga aSukkot ká̱ izu iga ashe nzam ká̱ oga mmər. ");
INSERT INTO yer_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","Uza̱ shin nzhi nkúrkúr ngga aPeniyel kpa, kang uza̱ gbá̱ng onunggwan oga ashe ìtong va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","Te uza̱ ɓəp uZeba ká̱ uZalmuna pa̱, <<Nza̱ apir onəm ó gbá̱ng ka̱ aTabor yà?>> Oza̱ na ma̱n á na pa̱, <<Onəm wa mmaɓu, nza̱ uzəngtəng oza̱ nggo wa aya aponzhi.>> ");
INSERT INTO yer_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","Te uGidiyon na ama̱n ôza̱ pa̱, <<Ogənang mi ta, ovan anang mi. N sóng anung ká̱ uYawe, ká̱ yà pa̱ ó re oza̱ re ká̱ irirì te, ka̱ n gbá̱ng wó ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","Uza̱ là ûJeter uyiyen ugəshi pa̱, <<Wóng, na u gbá̱ng oza̱.>> Ǹnyi te, uyenza̱m va̱ ta tur ndokchi wò ka̱t, ka̱kul uza̱ wa yà uyen uga iɓəl, kang ayər ka̱ nnəm na. ");
INSERT INTO yer_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","Te uZeba ká̱ uZalmuna là pa̱ <<Wong ká̱ ishi ɓu na u gba̱l yi, ka̱kul unəm i kur ununggwan kang i nəm nnap onunggwan.>> Te uGidiyon wong gba̱l uZeba ká̱ uZalmuna, kang uza̱ fən oga iya̱m isham va̱ ka̱ ishak oga alakəmi oza̱. ");
INSERT INTO yer_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Te onəm oga aIsa̱rila là ûGidiyon pa̱, <<Nəm iponzhi ka̱ apal yi, mmaɓu ká̱ ovan ɓu, ká̱ okəka ɓu kpa, ka̱kul u ka̱m ishi yi chit ka̱ ashe awo oMidiyan.>> ");
INSERT INTO yer_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Ǹnyi te, uGidiyon là ôza̱ pa̱, <<Mi yà ka̱ nnəm iponzhi ka̱ apal wó ka̱t, kang uyen mi i yà ka̱ nnəm iponzhi ka̱ apal wó ka̱t na kpa, uYawe uwa i nəm iponzhi ka̱ apal wó.>> ");
INSERT INTO yer_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","Kang uza̱ là ôza̱ pa̱, <<Mmami ka̱ nchal wó pa̱, nza̱ unəm nggo ka̱ ashe wó, á na iya̱m achwang á mi ka̱ ashe iyəya̱m iga ngwur ka̱ atak ìkum.>> Ka̱kul oMidiyan oma ka̱ oga iya̱m achwang iga azənariya, wa nva nnap-nnəm oIshəmayel á. ");
INSERT INTO yer_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Te oza̱ na ama̱n pa̱, <<Í məma̱n, í na oza̱ na ká̱ kpaktak ìgwak.>> Te oza̱ nàr inang ìlukwan, kang nza̱ unəm nggo mang iya̱m achwang va̱ uza̱ ya ka̱ atak ìkum ka̱ apəpal. ");
INSERT INTO yer_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","Iɗək iya̱m achwang iga azənariya va̱ uza̱ chal te, ashekel ìkalong pa̱ izəng ká̱ igba̱l pa̱ ifangshat aga azənariya. Iya̱m nza̱m pa̱ kpa te a yà kà̱ ka̱t, wa iya̱m ishak, ká̱ ìlukwan irəzang pa̱ bit iga mpa oponzhi uga aMidiyan, ká̱ oga iya̱m ishak oga alakəmi oza̱ ");
INSERT INTO yer_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","UGidiyon la ìchər ká̱ azənariya va̱ ta, kang uza̱ pak ka̱ ashe ìtong wò, aOfəra. Nkpaktak oIsa̱rila nəm mmai ka̱ atak ngwop ìchər va̱ ta, a le ta̱l ajəp ûGidiyon ká̱ nzhizhi. ");
INSERT INTO yer_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Wa nnà ta, onəm oga aIsa̱rila nəm igwan ká̱ oMidiyan, kang oMidiyan wong ká̱ ishi lap ka̱t. Te, mbin təm ká̱ ikángkáng ìzun ìsəm pa̱ ineɗing ka̱ ashe nra aGidiyon. ");
INSERT INTO yer_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","Te uJerup-Baal uya aJowash ununggwan le ga təm ka̱ nzhi wò. ");
INSERT INTO yer_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","UGidiyon ká̱ ovan onunggwan ìsəm pa̱ ifangshat ova oji na, ka̱kul uza̱ ká̱ ochar pa̱ kyák. ");
INSERT INTO yer_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","Uchəchar va̱ uza̱ nak ka̱ ashe nzhi pa kùk ka̱ aShekem te, á mar uyen ununggwan á na kpa, kang uza̱ sok aɗin á na pa̱ uAbimelek. ");
INSERT INTO yer_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","Te uGidiyon uya aJowash gbák pa̱ gənggəng kang a kú, te oza̱ li na ka̱ awap apupo uJowash, ka̱ aOfəra aga akum aAbiyezer. ");
INSERT INTO yer_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","Ka̱ nva̱ng ikú aGidiyon na byet te, onəm oga aIsa̱rila ga̱ɓa̱n le nəm mmai ka̱ atak ngwop ìchər aBaal. Oza̱ nak ìchər aBaal-Berit sat inan oza̱, ");
INSERT INTO yer_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","kang onəm oga aIsa̱rila rəng uYawe Inan oza̱ lap ka̱t, uva ka̱ fa ká̱ oza̱ ka̱ ashe awo nkpaktak okpa ìkum oza̱, ova gáng oza̱ ka̱ nza̱ ngba̱k nggo á. ");
INSERT INTO yer_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Kà̱ɗi te, oza̱ nəm iya̱m inəna̱n iro n̂zhi aJerup-Baal ka̱t, uwa aGidiyon á, káp ka̱ nkpaktak oga iya̱m inəna̱n va̱ uza̱ ka̱ nəm ôIsa̱rila á. ");
INSERT INTO yer_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","UAbimelek uya aJerup-Baal ununggwan ga atak okyán wò ka̱ aShekem, kang uza̱ là ôza̱ ká̱ nkpaktak akum anang wò pa̱, ");
INSERT INTO yer_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","<<Ó ɓəp nkpaktak onəm oga aShekem pa̱,<Nna ka̱ i ɓyen ká̱ wó yà, nva̱ pa̱ nkpaktak ovan onunggwan aJerup-Baal ìsəm pa̱ ifangshat á nəm iponzhi ka̱ apal wó, ka̱t te, unəm pa̱ uzəng á nəm á.> Ó rəng kpa pa̱ mmami akup ká̱ ìzhè wó.>> ");
INSERT INTO yer_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","Awalang va̱ okyikyán là nkpaktak oga nnap-nlà va̱ ta chit ka̱ ashe achwang onəm oga aShekem te, ìgwak oza̱ le atak aAbimelek, ka̱kul oza̱ là pa̱, <<Uza̱ ugənang yi.>> ");
INSERT INTO yer_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","Oza̱ na aazurfa á na ashekel ìsəm pa̱ ifangshat, ka̱ ashe nzhi awop ìchər aBaal-Berit, ká̱ nna ta uAbimelek yar nsar iyap ká̱ onunggwan oga ayə́r oro, kang oza̱ yar nvəva̱ng. ");
INSERT INTO yer_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","Te uza̱ ga nzhi apo wò ka̱ aOfəra, kang uza̱ gbá̱ng ogənang wò onunggwan ovan aJerup-Baal, onunggwan ìsəm pa̱ ifangshat, ka̱ apal ìpang pa̱ ìzəng. Ǹnyi te, uJotam uya aJerup-Baal ununggwan uga nkú irəng lár, ka̱kul uza̱ bwam ishi wò. ");
INSERT INTO yer_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","Te nkpaktak onəm oga aShekem ká̱ aBet-Milo ɓut ka̱ ngba̱k ìkun aOak ka̱ atak ndar ka̱ aShekem pa̱ na ó kyer iponzhi ûAbimelek. ");
INSERT INTO yer_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","Awalang va̱ mmá là ûJotam te, uza̱ ga kyén ka̱ apal aƁam aGerizim, kang á ləp achu ôza̱ pa̱, <<Ó gwong achwang ka̱ mi, ónəm oga aShekem, na Inan á fe wó kpa. ");
INSERT INTO yer_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","Ka̱ nda aro te, ikún ga pa̱ na ó gor uponzhi îshi oza̱. Te oza̱ là îkun mpyet pa̱, <Nəm iponzhi ka̱ pal yi.> ");
INSERT INTO yer_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","Ǹnyi te, ikun mpyet na ama̱n pa̱,<N re nna mmì mi nva mi na ichumchum Inan ká̱ onəm ká̱, kang mi ga mi yir ka̱ ashe ikun ɗò?> ");
INSERT INTO yer_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","Te ikún là îkun ìpipyan pa̱, <Ɓa na u nəm iponzhi ka̱ apal yi.> ");
INSERT INTO yer_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","Ǹnyi te, ikun ìpipyan na ama̱n ôza̱ pa̱, <N re nna awár mi va̱ ta̱, ava anəna̱n kang a chàng byet, na n ga n yir ka̱ apal ikún ɗò?> ");
INSERT INTO yer_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","<< Te, oga ikún là îkun ìba̱ngba̱ng pa̱, <Ɓa na u nəm iponzhi ka̱ apal yi.> ");
INSERT INTO yer_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","Ǹnyi te, ìkun ìba̱ngba̱ng na ama̱n ôza̱ pa̱,<N re nna ndəng ìba̱ngba̱ng mi nchángchàng nva ka̱ nchàng ká̱ oga inan ká̱ onəmləbər, na ngga ntəm nyir ka̱ ashe ikún pa̱ mi nəm iponzhi á?> ");
INSERT INTO yer_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","<<Ka̱ nkukur te, nkpaktak ikún là îzu pa̱, <Ɓa na u nəm iponzhi ka̱ apal yi.> ");
INSERT INTO yer_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","<<Te ìzu là îkún pa̱, <A yà pa̱ nnandər ó gor mi chit pa̱ n yà uponzhi ka̱ apal wó, te ó ɓa na ó təm ayì ka̱ avəng mi, ǹnyi te, a yà pa ka̱t, te re apər á fa ka̱ ashe izu na á ri oga akun asida iga aLebanon.> ");
INSERT INTO yer_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","<<Ǹyangmata̱ te, ó nəm nnandər nəm ká̱ iva̱ mal, nva̱ ó kyer uAbimelek uponzhi ɗò? Ó nəm ikin nəm ûJerup-Baal ká̱ nzhizhi ɗò? Ó nəm nnap á na nva mal dakdak ɗò? ");
INSERT INTO yer_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","Ó rəng pa̱ upo mi ka̱ lung ìkum á wo, uza̱ yáp ká̱ irirì wò pa̱ na ò fa ká̱ wó ka̱ ashe awo oMidiyan. ");
INSERT INTO yer_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","Ǹnyi te, ka̱ nda va̱ ta̱ te, ó le chit ó fa iya̱mkak ká̱ nzhi apo mi. Ó gbá̱ng ovəvan onunggwan ìsəm pa̱ ifangshat ka̱ apal ìpang pa̱ ìzəng, kang ó kyer uAbimelek uya achar uzwal, uponzhi ka̱ apal onəm oga aShekem, ka̱kul pa̱ uza̱ ugənang wó. ");
INSERT INTO yer_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","Ǹyangmata̱ te, ó nəm nnandər nəm ka̱ iva̱ mal ûJerup-Baal ká̱ nzhizhi ka̱ nda va̱ ta̱ ɗò? A yà pa te, re ó fe nchàng aAbimelek, na uza̱ á fe nchang wó kpa. ");
INSERT INTO yer_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","Ǹnyi te, a yà pa ka̱t, te re apər á fa ka̱ atak aAbimelek, a ri onəm oga aShekem ká̱ aBet-Milo, na apər á fa ka̱ atak onəm oga aShekem ká̱ aBet-Milo a ri uAbimelek.>> ");
INSERT INTO yer_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","Te uJotam chə́r ga aBeyer, kang a təm ka̱ ta, ka̱kul uza̱ nəm ayər agənang wò uAbimelek. ");
INSERT INTO yer_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","Ka̱ nva̱ng va̱ uAbimelek nəm iponzhi chit ka̱ apal oIsa̱rila ìzun pa̱ ishatɗing te, ");
INSERT INTO yer_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","Inan nak nwong ká̱ nnap-nnəm ká̱ ishimshe aAbimelek ká̱ onəm oga aShekem, kang onəm oga aShekem fa iya̱mkak ká̱ uAbimelek. ");
INSERT INTO yer_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","Iya̱m va̱ ta fa ka̱kul pa̱ na mmá pyát inga va mmá nəm ka̱ atak ngbá̱ng ovan aJerup-Baal onunggwan ìsəm pa̱ ifangshat, ká̱ nchə̀r oza̱ va̱ mmá tar ka̱ apal ishi agənang oza̱ uAbimelek, uva gbá̱ng oza̱, kang ka̱ apal onəm oga aShekem, ova ka̱mshishi ká̱ ngbá̱ng ogənanggənang. ");
INSERT INTO yer_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","Te onəm oga aShekem nak onəm ra anyimnyal ka̱ apal oga aɗuktum i vyat iya̱m ka̱ atak nkpaktak onəm va̱ i wòl asa̱l ka̱ ta. Te mmá là iya̱m va̱ ta ûAbimelek. ");
INSERT INTO yer_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","Ǹyangmata̱ te, uGayal uya aEbet ununggwan, ɓa təm ka̱ aShekem ká̱ ogənang wò, kang onəm oga aShekem na nnandər ká̱ na. ");
INSERT INTO yer_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","Ka̱ nva̱ng va̱ onəm oga aShekem ga pang oga awár ìba̱ngba̱ng chit ka̱ ashe oga iram ìba̱ngba̱ng oza̱ kang a káng ndədəng te, oza̱ nəm nchàng izər ka̱ ashe nzhi inan oza̱. Oza̱ ri, oza̱ wá, kang oza̱ pwat uAbimelek. ");
INSERT INTO yer_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","Te uGayal uya aEbet ununggwan là pa̱, <<UAbimelek va̱ uda kang mmayi onəm oga aShekem, í kpak nnap-nnəm á na yà? Uya aJerup-Baal ka̱t ɗò? UZebul uwa unəm uga nvəva̱ng ka̱t ɗò? Ó kpak nnap-nnəm n̂zhi aHamor, upo aShekem. Ka̱kul iza̱ kang í pak nnəm izwal ûAbimelek yà? ");
INSERT INTO yer_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","Ká̱ yà pa̱ onəm va̱ ta̱ ka̱ ashe awo mi te, ká̱ n ngbá̱l uAbimelek. Ka̱ nlà ûAbimelek pa̱, <Ga na u dan iyəl oshozha ɓu, na u fa agbai.> >> ");
INSERT INTO yer_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","Awalang va̱ uZebul unəm uga mpyal aga ìtong va̱ ta fe oga nnap-nlà va̱ uGayal uya aEbet ununggwan ka̱ nləla te, ìgwak lak na pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","Te uza̱ re nre ká̱ onəm oga nre ká̱ ayi ga atak aAbimelek ka̱ aAruma, uza̱ là pa̱, <<Dər, uGayal uya aEbet ununggwan ká̱ ogənanggənang ɓa aShekem chit, kang oza̱ ka̱ nnók onəm oga ìtong va̱ ta ka̱ apal ɓu. ");
INSERT INTO yer_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","Ǹyangmata̱ te, wong ká̱ izwam, mmaɓu ká̱ onəm va̱ nzəng ká̱ ɓu, na ó ra anyimnyal ka̱ ashe oga nzam. ");
INSERT INTO yer_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","Ipin, ká̱ ìɓotak, awalang va̱ alum ka̱ nfa ká̱ te, wa ru ìtong va̱ ta ká̱ ìkum. Kang awalang va̱ uGayal ká̱ onəm va̱ nzəng ká̱ na i fa ìkum ka̱ ɓu te, wa nəm iya̱m va̱ ká̱ na u ɗom.>> ");
INSERT INTO yer_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","Te uAbimelek wong ká̱ nkpaktak onəm va̱ nzəng ká̱ na ká̱ izwam, kang oza̱ ra anyimnyal idongkong pa̱ ineɗing gáng aShekem. ");
INSERT INTO yer_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","Ǹyangmata̱ te, uGayal uya aEbet ununggwan ka̱ fa chit ka̱ nsat ka̱ anung asa̱l aga ntar ìtong va̱ ta, a mal dakdak ká̱ awalang va̱ uAbimelek ká̱ onəm va̱ nzəng ká̱ na wong ka̱ atak va̱ oza̱ ra anyimnyal kà̱. ");
INSERT INTO yer_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","Awalang va̱ uGayal ya onəm chit, te uza̱ là ûZebul pa̱, <<Dər, onəm ka̱ nfəng ka̱ apal oga aɓam.>> UZebul là pa̱, <<Ala̱ka̱n aɓam na u ya kang á nəm ka̱ ɓu na onəm.>> ");
INSERT INTO yer_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","Ǹnyi te, uGayal là nnap kà̱ɗi pa̱, <<Dər, onəm ka̱ nfəng ka̱ oga aɗuktum aga ishimshe mbin ka̱ mɓa, kang idongkong iro ka̱ mɓa ka̱ asa̱l isu ikun aOak va̱ onəm oga iva̱k i nəm iva̱k kà̱.>> ");
INSERT INTO yer_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","Te uZebul là á na pa̱, <<Nnap anung ɓu va̱ nna ka̱ ǹyangmata̱ yà, mmaɓu va u là pa̱, <UAbimelek va̱ uda kang í kpak nnap-nnəm á na yà? Onəm va ta̱ ka̱ u ɓák va̱ ka̱t ɗò? Fa ǹyangmata̱, na u ga u lung oza̱.>> ");
INSERT INTO yer_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","Te uGayal ləp mpyal onəm oga aShekem, kang oza̱ lung uAbimelek. ");
INSERT INTO yer_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","UGayal chə́r, ǹnyi te uAbimelek ɓak na ga chu anung asa̱l ntar ìtong va̱ ta, kang mmá gbá̱ng onəm pa̱ makmak va̱ ka̱ nchəng. ");
INSERT INTO yer_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","Te uAbimelek təm ka̱ aAruma, kang uZebul ɓak uGayal ká̱ ogənanggənang fa ka̱ aShekem. ");
INSERT INTO yer_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","Ipin fa kpa̱k te, onəm oga aShekem fa ga ashe oga agbagba, kang mmá là iya̱m va̱ ta ûAbimelek. ");
INSERT INTO yer_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","Te uza̱ wur onəm wò kang uza̱ kap oza̱ idongkong pa̱ ishatɗing, kang oza̱ ra anyimnyal ka̱ ashe oga agbagba va̱ ta. Awalang va̱ uza̱ ya onəm va̱ ta ka̱ nfa ka̱ ashe ìtong te, uza̱ wong ru oza̱ ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","UAbimelek ká̱ ìdongkong va̱ nzəng ká̱ na gha̱n ga tong ka̱ anung asa̱l aga tar ìtong va̱ ta. Te aɓo idongkong iga ìparəm ga ru onəm va̱ ka̱ ashe oga agbagba ká̱ ìkum kang a gbá̱ng oza̱. ");
INSERT INTO yer_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","UAbimelek lung ìkum ká̱ ìtong va̱ ta ga chu ntar alum. Uza̱ ri ìtong va̱ ta, kang a gbá̱ng onəm va̱ ka̱ ashishe. Te uza̱ shin ìtong va̱ ta, kang a wung mman kà̱. ");
INSERT INTO yer_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","Awalang va̱ nkpaktak onəm oga nzhi nkúrkúr ngga aShekem fe te, oza̱ chəng táng atak mbwam ka̱ nzhi awop ìchər aEl-Berit. ");
INSERT INTO yer_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","Awalang va̱ mmá là ûAbimelek pa̱ nkpaktak onəm va̱ ta ga ɓut chit ka̱ atak azəngtəng te, ");
INSERT INTO yer_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","uza̱, ká̱ nkpaktak onəm va̱ nzəng ká̱ na kyén ga aƁam aZalmon. UAbimelek yar ìkù ka̱ awo kang a gəlchi igwong ìkun yar nak ka̱ agar wò. Te uza̱ là ônəm va̱ nzəng ká̱ na pa̱, <<Kəlak, ó nəm iya̱m va̱ ó ya n nəm ta̱ á.>> ");
INSERT INTO yer_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","Wa nnà ta nza̱ unəm nggo gəlchi igwong iji wò, kang a yar nva̱ng aAbimelek. Oza̱ ɓák oga akun va̱ ta ka̱ izər atak mbwam va̱ ta, kang oza̱ pá apər âtak va̱ ta nzəng ká̱ onəm va̱ ka̱ ashishe. Te nkpaktak onəm va̱ ka̱ ashe nzhi nkúrkúr ngga aShekem kú, onəm dat ká̱ ìkalong pa̱ ìzəng, onunggwan ká̱ ochar. ");
INSERT INTO yer_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","Ka̱ nvəva̱ng te, uAbimelek ga ru aTebet ká̱ ìkum, kang a ri na. ");
INSERT INTO yer_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","Ǹnyi te, nzhi nkúrkúr nkamkam ro nna ka̱ ishimshe ìtong va̱ ta, kang nkpaktak onunggwan ká̱ ochar, oma nkpaktak onəm oga ashe ìtong va̱ ta chəng ga táng ashishe. Oza̱ gún ishi oza̱ ka̱ ashishe, kang oza̱ kyén ga apal nzhi nkúrkúr va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","Te uAbimelek ɓa nzhi nkúrkúr va̱ ta kang a ru na ká̱ ìkum. Ǹnyi te, awalang va̱ uza̱ ɓa dat ká̱ anung asa̱l aga nzhi nkúrkúr va̱ ta pa̱ na o pwak na ká̱ apər te, ");
INSERT INTO yer_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","uchar uro mang awo ako ka̱ apal ishi aAbimelek, kang a chwan ikpáng ishi á na. ");
INSERT INTO yer_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","Ta byet te, uza̱ wór uyenza̱m uga ngwur iya̱m ìkum á na ká̱ nggha̱n, uza̱ là á na pa̱, <<Tur ndokchi ɓu na u gbá̱l mi, le oza̱ a wong a là pa̱, <Uchar a gbá̱l mi> ka̱t.>> Te uyenza̱m va̱ ta kyer na ká̱ ndokchi, kang uza̱ kú. ");
INSERT INTO yer_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","Awalang va̱ oIsa̱rila ya pa̱ uAbimelek kú chit te, udanggo le ga nzhi wò. ");
INSERT INTO yer_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","Wa nnà ta Inan pyát akat nnap-mɓá̱ngɓa̱ng aAbimelek nva̱ uza̱ nəm ûpo wò, ka̱ atak ngbá̱ng ogənanggənang oga ìsəm pa̱ ifangshat va̱ á. ");
INSERT INTO yer_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","Ka̱ asa̱l va ta̱ kpa Inan nak nkpaktak onəm oga aShekem ɓək anung ka̱kul nnap-mɓá̱ngɓa̱ng oza̱. Nvyap va̱ uJotam uya aJerup-Baal ununggwan là ka̱ apal ishi oza̱ te, á ɓa yə́l. ");
INSERT INTO yer_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","Ka̱ nva̱ng aAbimelek, te uTola uya aPuwa ununggwan, uya aDodo ununggwan, unəm uga aIsaka, uva ka̱ ntəm ka̱ aShamir ava ka̱ ìtong iga aɗuktum aEfrayim, wong pa̱ na ô ka̱m ishi oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","Uza̱ nap-akwali ôIsa̱rila ìzun ìsəm pa̱ ìparəm ama̱n pa̱ shatɗing te uza̱ kú, kang mmá li na ka̱ aShamir. ");
INSERT INTO yer_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","Ka̱ nvəva̱ng te, uJayir unəm uga aGileyat, uza̱ nap-akwali ôIsa̱rila ìzun ìsəm pa̱ ìparəm ama̱n pa̱ pa̱rəm. ");
INSERT INTO yer_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","Uwa yà ká̱ ovan onunggwan ìsəm pa̱ ishatɗing, ova i kyén ka̱ apal oga azhaki ìsəm pa̱ ishatɗing. Oza̱ ká̱ oga itong ìsəm pa̱ ishatɗing ka̱ mbin aGileyat, ova mi wór pa̱ itong aJayir ɓa chu nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","Awalang va̱ uJayir kú te, mmá li na ka̱ aKamon. ");
INSERT INTO yer_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","Ovan oga aIsa̱rila nəm nnap-mɓá̱ngɓa̱ng ka̱ mpyal aYawe kà̱ɗi. Oza̱ wop oga ìchər aBaal ká̱ aAshtoret, ká̱ oga inan aSuriya, ká̱ oga inan aSidon, ká̱ oga inan aMowap, ká̱ oga inan oAmmon, ká̱ oga inan oFilisti. Kang ka̱kul oIsa̱rila yang ká̱ uYawe, i wop na lap ka̱t te, ");
INSERT INTO yer_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","uYawe mən ìkum ká̱ oza̱. Uza̱ na oIsa̱rila ka̱ ashe awo oFilisti ká̱ oAmmon, ");
INSERT INTO yer_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","ova nyán ká̱ oza̱ kang a chwan oza̱ ka̱ ashe ìzun va̱ ta. Ka̱ apal ìzun pa̱ igba̱pchi ama̱n pa̱ na̱nne te, oza̱ nyán ká̱ nkpaktak oIsa̱rila va̱ ka̱ asa̱l nfa alum aUrdun ka̱ ashe aGileyat, mbin oAmori á. ");
INSERT INTO yer_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","Te oAmmon pa̱ng aUrdun ka̱kul pa̱ na ó lung akum ìjili aYahuda, ká̱ uBenjamin, ká̱ nzhi aEfrayim. Kang oIsa̱rila táng ashe mɓək anung pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","Te onəm oga aIsa̱rila yə́ng ûYawe, oza̱ là pa̱, <<I nəm nnap-mɓá̱ngɓa̱ng á ɓu chit, ka̱kul i re ngwop Inan yi, i wop oga ìchər aBaal.>> ");
INSERT INTO yer_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","Te uYawe na ama̱n ônəm oga oIsa̱rila pa̱, <<Awalang va̱ onəm oga aMasar, ká̱ oAmori, ká̱ oAmmon, ká̱ oFilisti, ");
INSERT INTO yer_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","ká̱ oga aSidon, ká̱ oAmalek, ká̱ oMawoni ka̱ nyán ká̱ wó, kang ka̱ ó yə́ng á mi te, n ka̱m ishi wó ka̱ ashe awo oza̱ ka̱t ɗò? ");
INSERT INTO yer_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","Káp ká̱ nna te, ó ga̱ɓa̱n asəm á mi chit, ó wop oga inan iro, ka̱kul nva̱ ta te, mi yà ká̱ nka̱m ishi wó lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","Ó ga na ó yə́ng ôga inan va ó yak á. Re oza̱ a fa ká̱ wó ka̱ ashe awalang nɗaktak wó.>> ");
INSERT INTO yer_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","Ǹnyi te, onəm oga oIsa̱rila là ûYawe pa̱, <<I nəm nnap-mɓá̱ngɓa̱ng á ɓu chit. Nəm iya̱m va ká̱ yi u ya ma ká̱ ɓu, ǹnyi te, i chal ɓu chal, ka̱m ishi yi ka̱ nda va̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","Te oza̱ swang oga inan iga mbin nkak va̱ ka̱ ashe oza̱ kang oza̱ wop uYawe. Kang ìgwak lak uYawe ka̱kul mɓək anung va̱ onəm oga aIsa̱rila ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","Te oshozha oga aAmmon gbar izər ka̱kul ìkum, kang oza̱ ləp apa̱k ka̱ ashe aGileyat te, onəm oIsa̱rila ɓut kang oza̱ ləp apa̱k aji oza̱ ka̱ aMizpa. ");
INSERT INTO yer_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","Onəm oga mpyal aGileyat là ôwan oza̱ pa̱, <<Unəm va̱ káp a ga a ru onəm oga aAmmon ká̱ ìkum mpyal te, uza̱ wa i ya unəm uga mpyal n̂kpaktak onəm va̱ ka̱ ntəm ka̱ ashe aGileyat.>> ");
INSERT INTO yer_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","UJefta unəm uga aGileyat pa te, unəm uga ǹnyi ashar ìkum ukamkam. Upupo uGileyat, kang unənang te, uchar umaimai. ");
INSERT INTO yer_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","Uchar aGileyat mar ovan onunggwan á na kpa. Kang awalang va̱ oza̱ rup, te oza̱ wà uJefta pa̱, <<Ɓu ya ká̱ nrì iya̱mkup apo yi nzəng ká̱ yi ka̱t, ka̱kul mmaɓu uya achar ro pa̱ɗi.>> ");
INSERT INTO yer_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","Te uJefta chə́r ka̱ atak ogənang wó, uza̱ ga təm ka̱ mbin aTop. Ka̱ ta te, ovan oga ayə́r oro ɓa ɓut ka̱ atətak kang oza̱ i ranggang nzəng ká̱ na. ");
INSERT INTO yer_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","Mmá ka̱ ashe ntəm te, ovan oga oAmmon ɓa ru oga aIsa̱rila ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","Kang awalang va̱ oAmmon ru onəm oga aIsa̱rila chit ká̱ ìkum te, onəmgbak oga aGileyat ga mbin aTop pa̱ na ó le ká̱ uJefta ka̱ aGileyat. ");
INSERT INTO yer_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","Te oza̱ là ûJefta pa̱, <<Ɓa na u yà unəm uga mpyal ìkum á yi, na i nəm ìkum ká̱ onəm oga aAmmon.>> ");
INSERT INTO yer_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","Te uJefta là ônəmgbak oga aGileyat pa̱, <<Mmawo na ka̱ ó yang ká̱ mi, ó wà mi ka̱ ashe nzhi apo mi ka̱t ɗò? Iza̱ nak kang ó ɓa atak mi ǹyangmata̱ va̱ mmawó ka̱ ashe nɗaktak yà?>> ");
INSERT INTO yer_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","Te onəmgbak oga Gileyat là ûJefta pa, <<Ká̱ nna kpa te, í le chit í ɓa ka̱ atak ɓu ǹyangmata̱. A yà pa̱ ɓu ga nzəng ká̱ yi na i lung ìkum ká̱ onəm oga aAmmon te, mmaɓu na ɓu yà unəm uga mpyal onəm oga aGileyat pa̱ kpaktak.>> ");
INSERT INTO yer_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","Te uJefta na ama̱n ônəmgbak oga aGileyat pa̱, <<A yà pa̱ ó le ká̱ mi ka̱ nzhi pa̱ n lung ìkum ká̱ onəm oga aAmmon, kang uYawe ga na oza̱ ka̱ ashe awo mi te, mi yà unəm uga mpyal wó yà na ɗò?>> ");
INSERT INTO yer_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","Te onəmgbak oga aGileyat na ama̱n ûJefta pa̱, <<UYawe uwa unəm uga nshet nnap ka̱ ishimshe yi. Nnandər, iya̱m va ɓu là te, nna i nəm.>> ");
INSERT INTO yer_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","Te uJefta ga nzəng ká̱ onəmgbak oga aGileyat, kang onəm va̱ ta nak na sat unəm uga mpyal oza̱ ká̱ unəm uga mpyal ìkum oza̱ kpa. Te uJefta le là nkpaktak oga nnap-nlà wò va̱ ka̱ mpyal aYawe ka̱ aMizpa. ");
INSERT INTO yer_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","Te uJefta re nre ká̱ onəm oga nre ka̱ atak aponzhi oga aAmmon pa̱, <<Iza̱ gwang mi ká̱ ɓu, kang ɓu ɓa pa̱ na u lung ìkum ká̱ mbin mi yà?>> ");
INSERT INTO yer_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","Te uponzhi oAmmon na ama̱n ônəm oga nre aJefta pa̱, <<Awalang va̱ oIsa̱rila fa ka̱ aMasar te, oza̱ vyat mbin mi á ɓan ka̱ aArnon ɓa chu aJabok, kang a lyam ga aUrdun. Ǹyangmata̱ te, le ká̱ mbin va̱ ta á mi ka̱ ashe inal.>> ");
INSERT INTO yer_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","Te uJefta re onəm oga nre kà̱ɗi ga atak aponzhi oAmmon, ");
INSERT INTO yer_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","ká̱ nnap-nlà pa̱, <<Iya̱m va ta̱ uJefta là. Onəm oga aIsa̱rila vyat mbin oMowap, ka̱t te oAmmon ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","Ǹnyi te awalang va̱ oza̱ fa ka̱ ashe aMasar te, oIsa̱rila wòl ashe nzam mmaləng ga chu Ìwa Irəzang, kang oza̱ ga aKadesh. ");
INSERT INTO yer_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","Te oIsa̱rila re onəm oga nre ga atak aponzhi oga aEdom pa̱, <Kusuk, re yi na í watar ka̱ ashe mbin ɓu,> ǹnyi te, uponzhi oga aEdom ma̱n ka̱t. Te wa nnà ta oza̱ re nre ûponzhi oga aMowap kpa, kang uza̱ yang. A nak te, oIsa̱rila təm ka̱ aKadesh. ");
INSERT INTO yer_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","Te oza̱ kak ashe nzam oza̱ gang mbin aEdom ká̱ aMowap, oza̱ wòl asa̱l nfa alum mbin aMowap, kang oza̱ ləp apa̱k ka̱ agwong aArnon. Oza̱ tar ashe mbin aMowap ka̱t, ka̱kul aArnon na aswari ga aMowap. ");
INSERT INTO yer_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","Te oIsa̱rila re onəm oga nre ga atak aSihon uponzhi oAmori uva i nəm iponzhi ka̱ aHeshbon, oza̱ là á na pa̱, <Re yi i watar ka̱ ashe mbin ɓu na i ga mbin yi.> ");
INSERT INTO yer_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","Ǹnyi te, uSihon ma̱n ôIsa̱rila pa̱ a watar ka̱ ashe mbin wò ka̱t. Uza̱ ɓut nkpaktak onəm wò, oza̱ ga ləp apa̱k ka̱ aJahat, kang oza̱ ru oIsa̱rila ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","<<Te uYawe, Inan oIsa̱rila, na uSihon ká̱ nkpaktak onəm wò ka̱ ashe awo oIsa̱rila kang oza̱ ri oza̱ ká̱ ìkum. OIsa̱rila kwom nkpaktak mbin oAmori, ova ka̱ ntəm ka̱ ashe mbin va̱ ta, ");
INSERT INTO yer_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","kang oza̱ kwom nkpaktak mbin oAmori va̱ ta, ɓan ka̱ aArnon ga chu aJabok, kang a ɓan ka̱ nzam mmaləng ga chu aUrdun. ");
INSERT INTO yer_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","Ǹyangmata̱ te, uYawe, Inan oIsa̱rila wà oAmori chit fa ka̱ mpyal onəm wò oIsa̱rila. Nza̱ ichumchum mmaɓu ká̱ pa̱ u vyat ká̱ yi yà? ");
INSERT INTO yer_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","Ɓu kpán iya̱m va̱ inan ɓu uKemosh na ɓu ka̱t ɗò? Wa nnà ta kpa í kpán nkpaktak oga iya̱m va̱ uYawe, Inan yi na á yi. ");
INSERT INTO yer_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","U ji uBalak uya aZipo uponzhi oga aMowap ji ɗò? Uza̱ kpán ìkwoksok chit ká̱ oIsa̱rila, ka̱t te, uza̱ lung ìkum ká̱ oza̱ chit ɗak ɓo? ");
INSERT INTO yer_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","Izun chit ìgba̱l pa̱ ishatɗing nva̱ oIsa̱rila ka̱ ntəm ka̱ ashe aHeshbon ká̱ aAroyer, ká̱ oga ivan itong oza̱, ká̱ nkpaktak oga itong va̱ ka̱ anung awang aArnon. Iza̱ nak kang ó ɗak pa̱ na ó ka̱m oza̱ ka̱ ashe awalang va̱ ta ka̱t yà? ");
INSERT INTO yer_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","N nəm mpat nro á ɓu ka̱t, ǹnyi te, mmaɓu ka̱ nnəm mpat á mi, ka̱ atak nru mi ká̱ ìkum. Re uYawe, uga nnap-akwali, a kat ishimshe onəm oga aIsa̱rila ká̱ oga aAmmon ká̱ nda va̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","Ǹnyi te, uponzhi onəm oga aAmmon gwong achwang ka̱ nre va̱ uJefta re nre á na ká̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","Te aRuhu aYawe fə́r ka̱ apal aJefta, kang uza̱ watar aGileyat ká̱ aManase, lyam ga ashe aMizpa aga aGileyat i ɓut oshozha. Kang uza̱ wong ka̱ ta ga ìkum ka̱ onəm oga aAmmon. ");
INSERT INTO yer_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","Kang uJefta sóng anung ûYawe pa̱, <<A yà pa̱ ɓu na onəm oga aAmmon ka̱ ashe awo mi te, ");
INSERT INTO yer_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","iya̱m va pa̱ káp i fa ka̱ anung nzhi mi pa̱ na o gwang mi awalang va̱ n le ká̱ ikángkáng ka̱ atak nlung ìkum ká̱ oAmmon te, mi yichi na iya̱m inana iga nshì ûYawe.>> ");
INSERT INTO yer_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","Te uJefta pa̱l ga atak onəm oga aAmmon pa̱ na o lung ìkum ká̱ oza̱, kang uYawe na oza̱ ka̱ ashe awuwo. ");
INSERT INTO yer_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","Uza̱ lung oza̱ ɓan ka̱ aAroyer ga chu nkap mbin aMinnit, lyam ga chu aAbel-Keramim. Uza̱ zhì oga itong ìsəm pa̱ ìparəm, uza̱ gbá̱ng oza̱ pa̱ makmak. Wa nnà ta onəm oga aIsa̱rila nəm igwan ka̱ apal oAmmon. ");
INSERT INTO yer_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","Awalang va̱ uJefta le nzhi wò ka̱ aMizpa te, uyiyen uyenchar fa pa̱ na ô gwang na, ká̱ iya̱m nnə́m ká̱ nza̱m. Uwa ta uyiyen byet, uza̱ yà ká̱ ovan onunggwan, ka̱t te ovan ochar oro ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","Awalang va̱ uza̱ ya na te, uza̱ kakchi ilukwan wò ka̱ ashe nlak igwak, kang uza̱ ləp achu pa̱, <<Áyen mi, u gbá̱l mi chit. U ɓa ká̱ nɗaktak á mi chit. Ka̱kul n sóng anung ûYawe chit, nva mi ya ká̱ mɓəkchiɓəkchi ka̱t á.>> ");
INSERT INTO yer_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","Te uza̱ na ama̱n á na pa̱, <<Ápo mi, u yar nsar nnap-nlà ûYawe chit. Nəm á mi wa nva u là ká̱ anung ɓu á, ka̱kul uYawe na igwan á ɓu chit ka̱ apal okpa ìkum ɓu oAmmon.>> ");
INSERT INTO yer_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","Ǹnyi te, uza̱ là ûpo wò pa̱, <<Na ape á mi pa̱ parəm na n ga ashe oga aɗuktum, n yə́ng ikú nzəng ká̱ okpa mi, ka̱kul mi ga nkú na nyà uyenɓyen.>> ");
INSERT INTO yer_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","Te uza̱ là á na pa̱, <<Ga.>> Kang uza̱ re na ga nzəng ká̱ okpa wò ape pa̱ parəm. Oza̱ ga ashe oga aɗuktum kang oza̱ yə́ng ikú, ka̱kul pa̱ uza̱ i kú uwa ya uyenɓyen. ");
INSERT INTO yer_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","Kang ka̱ nkur ape pa̱ parəm va̱ ta te, uza̱ le ɓa atak apo wò, kang upupo nəm á na wa nva uza̱ ka̱ sóng anung á. Uza̱ wa nyi ununggwan chit ka̱t. Iya̱m va̱ ta sat nnap-nnəm ka̱ ashe aIsa̱rila pa̱, ");
INSERT INTO yer_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","ka̱ ashe nza̱ ìzun nggo te, ovanchar oga aIsa̱rila i fa i rəng ká̱ ikú aya aJefta uga Gileyat ka̱ apal nra pa̱ nneɗing. ");
INSERT INTO yer_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","Mmá wór onəm oga aEfrayim fa ɓut ká̱ oga iya̱m ìkum, kang oza̱ pa̱ng ga aZafon. Oza̱ là ûJefta pa̱, <<Sang kang u fa u ga u lung ìkum ká̱ oAmmon kang u là á yi pa̱ í ga nzəng ká̱ ɓu ka̱t yà? Ǹyangmata̱ te, í ga mpwak ɓu ká̱ nzhi ɓu ká̱ apər. ");
INSERT INTO yer_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","Te uJefta na ama̱n ôza̱ pa̱, <<Mmami ká̱ onəm mi, í dap ká̱ oAmmon pa̱ gənggəng, kang n wór wó te, ó ɓa pa̱ na ó ka̱m ishi mi ka̱ ashe awo oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","Awalang va̱ n ya pa̱ ó ga nka̱mshi mi ka̱t te, n na ishi mi, m pa̱l pa̱ n lung oAmmon, kang uYawe na igwan á mi ka̱ apal oza̱. Ǹyangmata̱ te, iza̱ nak kang ó ɓa ká̱ nda va̱ ta̱ pa̱ na ó lung mi yà? ");
INSERT INTO yer_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","Te uJefta ɓut nkpaktak onəm oga Gileyat, kang oza̱ lung ìkum ká̱ onəm oga aEfrayim. Onəm oga aGileyat ri oza̱ ká̱ ìkum, ka̱kul onəm oga aEfrayim ka̱ là chit pa̱, <<Mmawo onəm oga aGileyat te, mmawo onəm ova chəng ìkum kang a bwam ka̱ ashe aEfrayim ká̱ aManase.>> ");
INSERT INTO yer_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","Onəm oga aGileyat kpán oga atak va̱ mí pa̱ng awang aUrdun kà̱ kang mí ga aEfrayim, kang nkpaktak awalang va̱ unəm uga aEfrayim uro uva̱ chə́r ìkum a ɓa pa̱ o pa̱l te, onəm oga aGileyat i ɓəp na pa̱, <<Mmaɓu unəm uga aEfrayim ɗò?>>A yà pa̱ uza̱ a là pa̱, <<O'o te,>> ");
INSERT INTO yer_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","oza̱ i là á na pa̱, <<là pa̱, <aShibolet.> >> kang a yà pa̱ uza̱ a là pa̱, <<aSibolet,>> ka̱kul nləlà ka̱ asəsa̱l i ma̱t na ma̱t te, oza̱ i kpán na kang i gba̱l ka̱ atak mpa̱ng awang aUrdun va̱ ta. Onəm oga aEfrayim va̱ mmá gbá̱ng ka̱ awalang va̱ ta te, ìkalong ìsəm pa̱ ineɗing ama̱n pa̱ parəm. ");
INSERT INTO yer_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","UJefta unəm uga Gileyat nap-akwali aIsa̱rila ìzun pa̱ ìkpa̱ɗing te uza̱ kú, kang mmá li na ka̱ ashe ìtong iro ka̱ aGileyat. ");
INSERT INTO yer_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","Ka̱ nva̱ng aJefta te, uIbzan unəm uga aBet-Lehem náp akwali ôIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","Uza̱ ká̱ ovan onunggwan ìsəm pa̱ ishatɗing kang ká̱ ovan ochar ìsəm pa̱ ishatɗing. Te uza̱ na ovan ochar wò va̱ ta ka̱ ìvang ka̱ akum aro pa̱ɗi, kang uza̱ ka̱m ochar ôvan wò onunggwan ka̱ akum aro pa̱ɗi. UIbzan náp akwali âIsa̱rila ìzun pa̱ ifangshat. ");
INSERT INTO yer_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","Te uIbzan kú, kang mmá li na ka̱ aBet-Lehem. ");
INSERT INTO yer_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","Ka̱ nvəva̱ng te, uElon unəm uga aZebulun náp akwali âIsa̱rila ìzun pa̱ igba̱pchi. ");
INSERT INTO yer_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","Te uElon unəm uga aZebulun kú, kang mmá li na ka̱ aAijalon ka̱ ashe mbin aZebulun. ");
INSERT INTO yer_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","Ka̱ nvəva̱ng te, uAbdon uya aHillel unəm uga aPiraton náp akwali âIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","Uza̱ ká̱ ovan onunggwan ìsəm pa̱ ineɗing kang ká̱ okəka ovan onunggwan ìsəm pa̱ ishatɗing, ova i kwak oga azhaki ìsəm pa̱ ifangshat. Kang uza̱ náp akwali âIsa̱rila ìzun pa̱ ina̱nne. ");
INSERT INTO yer_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","Te uAbdon uya aHillel unəm uga aPiraton kú, kang mmá li na ka̱ aPiraton ka̱ ashe mbin aEfrayim ka̱ ìtong iga aɗuktum oAmalek. ");
INSERT INTO yer_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Kang ovan oga aIsa̱rila nəm nnap-mɓá̱ngɓa̱ng ka̱ mpyal aYawe kà̱ɗi, te uYawe na oza̱ ka̱ ashe awo oFilisti ìzun ìsəm pa̱ ineɗing. ");
INSERT INTO yer_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Unəm uro uwa ka̱ yà aɗiɗin pa̱ uManowa ka̱ ìtong aZora ka̱ akum ìjili aDan. Uchəchar asəsat. ");
INSERT INTO yer_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Te uma̱leka aYawe ɓa atak achar va̱ ta kang à là á na pa̱, <<Dər, u səsat u mar ka̱t, ǹnyi te, ɓu ga ǹyar anyam ɓu mar uyen ununggwan. ");
INSERT INTO yer_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Ǹyangmata̱ te, nak ishi ká̱ iya̱m va̱ ta̱, kang wa wá ndəng ìba̱ngba̱ng ǹsámsàm, ka̱t te iya̱m ngwa iro ikamkam, ka̱t te wa ri iya̱m iga ajan ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","Ɓu ga ǹyar anyam, ɓu mar uyen ununggwan, kang mí yà ká̱ nkpan ishi á na ka̱t. Ka̱kul uyen va̱ ta i yà uNazarat, ugargar Înan ka̱ ashe afu na byet. Uwa i ɓan nka̱mshi aIsa̱rila ka̱ ashe awo oFilisti. ");
INSERT INTO yer_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Te uchar va̱ ta ɓa kang là ûɓar wò pa̱, <<Unəm Inan uro ɓa atak mi, a nəm ayər ǹya byet, asa̱l awuwu ɓu là pa̱ asa̱l awu ama̱leka Inan. Mmami te, m ɓəp pa̱ uza̱ fa ka̱ che yà ka̱t, uza̱ là aɗin wò á mi ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Te uza̱ là á mi pa̱, <Ɓu ga ǹyar anyam kang ɓu mar uyen ununggwan. Ǹyangmata̱ te, kang wa wá ndəng ìba̱ngba̱ng ǹsámsàm, ka̱t te iya̱m ngwa iro ikamkam, ka̱t te wa ri iya̱m iga ajan iro ka̱t, ka̱kul uyen va̱ ta i yà uNazarat, ugargar Înan ka̱ ashe afu na byet i ga i chu nra ikúku.> >> ");
INSERT INTO yer_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Te uManowa nəm afar ûYawe pa̱, <<ÁYawe, n chal pa̱ u re unəm Inan va̱ ka̱ u re ɓa atak yi á ɓa kà̱ɗi, na uza̱ a ɗyang á yi asa̱l va̱ i kpán uyen ununggwan va̱ mí ga mməmar á.>> ");
INSERT INTO yer_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Te Inan fe achal aManowa, kang uma̱leka Inan ɓa atak achar va̱ ta kà̱ɗi ka̱ awalang va̱ uza̱ ka̱ ashe mpom. Ǹnyi te, uɓəɓar uManowa ka̱ yà nzəng ká̱ na ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","Uchar va̱ ta gha̱n ga atak á ɓar wò kang uza̱ là á na pa̱, <<Unəm va̱ ka̱ ɓa atak mi ká̱ nda va̱ te, á ɓa chit kà̱ɗi.>> ");
INSERT INTO yer_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Te uManowa wong yar nva̱ng achar wò. Awalang va̱ uza̱ ɓa chu atak anəm va̱ ta te, uza̱ ɓəp na pa̱, <<Mmaɓu na unəm va̱ u là nnap ka̱ uchar mi ɗò?>> Te uza̱ na ama̱n pa̱, <<À, mmami na.>> ");
INSERT INTO yer_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Te uManowa ɓəp na pa̱, <<Awalang va̱ nnap-nlà ɓu i yə́l te, nza̱ apir nnap-nnəm í ɗyang ûyen va̱ ta yà? Iza̱ i yà inok ayen va̱ ta yà? ");
INSERT INTO yer_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Kang uma̱leka aYawe là ûManowa pa̱, <<Nkpaktak iya̱m va̱ n là ûchar ɓu te, re uza̱ nak ishi ká̱ pa̱ dakdak, na uza̱ a kpak. ");
INSERT INTO yer_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Uza̱ i yà ká̱ nrì iya̱m va̱ pa̱ káp fa ka̱ izər ikun ìba̱ngba̱ng ka̱t, kang uza̱ a wá ndəng ìba̱ngba̱ng ǹsámsàm, ka̱t te nchè, ka̱t te uza̱ a ri iya̱m ro iga adak ka̱t. Nkpaktak iya̱m va̱ n nak á na te, uza̱ a kpak pa̱ dakdak.>> ");
INSERT INTO yer_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","Te uManowa là ûma̱leka aYawe pa̱, <<Wa ma̱n te, lok yi pa̱ ɗa̱p na i da̱mshi ìzhe iya iɓəl á ɓu kang.>> ");
INSERT INTO yer_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","UMa̱leka aYawe na ama̱n ûManowa pa̱, <<Ɓu ɗa̱t mi te, mi yà ká̱ nri iya̱m-nrì ɓu ka̱t. Ǹnyi te, a yà pa̱ ɓu da̱mshi iya̱m inana iga nshì te, wa na ûYawe.>> Ka̱kul uManowa uwa nyi chit pa̱ uza̱ uma̱leka aYawe ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Kang uManowa ɓəp ûma̱leka aYawe pa̱, <<Iza̱ aɗin ɓu yà? Ka̱kul na awalang va̱ nnap-nlà ɓu i yə́l te, í na ichumchum á ɓu.>> ");
INSERT INTO yer_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Te uma̱leka aYawe là á na pa̱, <<Ka̱kul iza̱ kang ɓu ɓəp aɗin mi yà? Aɗin mi ɗaktak byet ɓu yà ká̱ nkpan ìpipir ka̱t>> ");
INSERT INTO yer_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Te uManowa kpán iya iɓəl nzəng ká̱ iya̱m inana ipirkur, kang uza̱ yichi ka̱ apal ìpang ûYawe. Kang uYawe nəm iya̱m iga nɗaktak ka̱ mpyal aManowa ká̱ uchar wò. ");
INSERT INTO yer_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","Awalang va̱ aməlam apər wong ka̱ atak nshì iya̱m awop i ga apaɓur te, uma̱leka aYawe wong ka̱ ashe aməlam apər va̱ ta ɓa ga ashe apaɓur. Nva̱ uManowa ká̱ uchichar ya iya̱m va̱ ta te, oza̱ tak ka̱ mbin zəp ká̱ afu. ");
INSERT INTO yer_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Awalang va̱ uma̱leka aYawe nyám ishi wò ûManowa ká̱ uchichar lap ka̱t te, uManowa nyi ɗak pa̱ uma̱leka aYawe. ");
INSERT INTO yer_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Kang uManowa là ûchar wò pa̱, <<Nkpak í ga nkú, ka̱kul í ya Inan chit.>> ");
INSERT INTO yer_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Ǹnyi te, uchichar na ama̱n á na pa̱, <<Ká̱ yà pa̱ uYawe ɗom ngbá̱ng yi te, uza̱ ká̱ ka̱m iya̱m inana iga nshì ká̱ iya̱m inana iga ipirkur ka̱ awo yi, ka̱t te uza̱ ká̱ nyám ká̱ oga iya̱m va̱ ta̱ á yi pa̱ kpaktak ka̱t te, ká̱ là oga iya̱m va̱ ta̱ á yi ka̱ ashe awalang va̱ ta̱ ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Uchar va̱ ta mar uyennunggwan, kang uza̱ sok aɗin á na pa̱ uSamson. Uyen va̱ ta rup, kang uYawe nak nnap-nnəna̱n á na. ");
INSERT INTO yer_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Kang aRuhu aYawe ɓan nnəm inok ká na ka̱ awalang va uza̱ ka̱ ntəm ka̱ aMahane Dan, ka̱ ishimshe aZora ká̱ aEshtawol. ");
INSERT INTO yer_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","USamson fa ga aTimna, kang uza̱ ya uyenɓyen uro ka̱ ta ka̱ ashe ovanchar oFilisti. ");
INSERT INTO yer_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Awalang va̱ uza̱ le nzhi te, uza̱ là ûpo wò ká̱ unang wò pa̱, <<N ya uchar uro chit ka̱ aTimna ka̱ ashe ovanchar oFilisti, kang n ɗom pa̱ ó ka̱m ichar á mi ká̱ na ǹyangmata̱.>> ");
INSERT INTO yer_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Te upupon ká̱ unənang na ama̱n á na pa̱, <<U lang ovanchar uka̱mka̱m ka̱ ashe onəm ɓu, ka̱t te ka̱ ashe nkpaktak onəm yi, kang ɓu ɗom ga nka̱m uchar ka̱ ashe oFilisti, onəm oga ache amulur ɗò?>> Ǹnyi te, uSamson là ûpo wò pa̱, <<Ó ka̱m uwa á mi, ka̱kul uwa ta n ya ɓyen ká̱ mi.>> ");
INSERT INTO yer_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Upupo ká̱ unənang te nyi pa̱ nnap va̱ ta fa ka̱ atak aYawe ka̱t, ka̱kul uYawe ka̱ mmwo asa̱l va o nyám ntàn ôFilisti ká̱. Ka̱kul ka̱ awalang va̱ ta te, oFilisti oma i nəm iponzhi ka̱ apal oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Te uSamson ga aTimna nzəng ká̱ upupo ká̱ unənang. Awalang va̱ oza̱ ɓa chu oga iram ìba̱ngba̱ng iga aTimna te, ìya ìlir iro fa ɓa nggwang oza̱ i ɗúm ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Te aRuhu aYawe vang ka̱ apal aSamson ká̱ ìkam, kang uza̱ kpán ìya ìlir va̱ ta ká̱ awo kakchi ɓu là pa̱ uza̱ kakchi ìya ìɓəl. Ǹnyi te, uza̱ là ûpo wò ká̱ unang wò iya̱m va̱ uza̱ nəm ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Te uza̱ fə́r ga là nnap ká̱ uchar va̱ ta, kang uSamson ya pa̱ uchar va̱ ta ɓiɓyen ká̱ wò. ");
INSERT INTO yer_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Ka̱ nva̱ng oga nra pa̱ ɗa̱p te, uza̱ le pa̱ o ka̱m na. Te uza̱ lyep pa̱ na ô dər akúm ìlir va̱ uza̱ ka̱ gbá̱l, kang uza̱ ga ya irizhe təm chit ka̱ ashishe ká̱ mmàl irizhe. ");
INSERT INTO yer_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Uza̱ zə̀p mmàl irizhe va̱ ta ka̱ ashe awo wò, kang uza̱ ka̱ ngga uza̱ ka̱ nriri. Awalang va̱ uza̱ ɓa chu atak apo wò ká̱ unang wò te, uza̱ na oza̱ ká̱, kang oza̱ ri. Ǹnyi te, uSamson là ôza̱ pa̱ o zəp ka̱ ashe akúm ìlir ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Te, upupo fə́r ga nzhi achar va̱ ta, kang uSamson nak mmá nəm iya̱m-nrì ká̱ iya̱m ngwá iga mɓut ka̱ ta, ka̱kul ovanza̱m i nəm wa nnà ta. ");
INSERT INTO yer_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Awalang va̱ oFilisti ya na te, oza̱ ɓa ká̱ okpa ìsəm pa̱ ishatɗing pa̱ oza̱ a təm nzəng ká̱ na. ");
INSERT INTO yer_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Kang uSamson là ôza̱ pa̱, <<Re n gba achu aro á wó, kang a yà pa̱ unəm uro á là ìpipir á mi ka̱ ashe nra pa̱ nfangshat ngga nəm nchàng izər va̱ ta̱ te, mi na ìlukwan alinin á na ìsəm pa̱ ishatɗing ká̱ oga inang ilukwan ìsəm pa̱ ishatɗing. ");
INSERT INTO yer_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Kang a yà pa̱ nlà ìpipir a ma̱t wó te, ó ga nna ilukwan á mi iga alinin ìsəm pa̱ ishatɗing ká̱ oga inang ìlukwan ìsəm pa̱ ishatɗing.>> Te oza̱ là á na pa̱, <<Là ngba achu ɓu va̱ na í fe.>> ");
INSERT INTO yer_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Te uza̱ là ôza̱ pa̱, <<Ka̱ atak anəm uga nrì iya̱m, iya̱m-nrì fa, ka̱ atak anəm uga nkam, te iya̱m ichangchang fa.>> Kang ka̱ ashe nra pa̱ nshatɗing te, oma nyi ìpir ngba achu va̱ ta chit ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Ka̱ nra ngga nneɗing te, oza̱ là ûchar aSamson pa̱, <<Tàng uɓar ɓu na uza̱ á là ìpir ngba achu va̱ ta á yi, ka̱t te, í ga mpwak ɓu ká̱ nzhi apo ɓu ká̱ apər. Ó wór yi ka̱ ta̱ pa̱ na ó ka̱m idur yi ɗò? ");
INSERT INTO yer_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Te uchar aSamson yə́ng ka̱ mpyal aɓar wò, kang a là pa̱, <<U yang mi yang, u ma̱n mi ka̱t. U gba achu ônəm mi, ǹnyi te, u là ìpipir á mi ka̱t.>> Te, uSamson na ama̱n á na pa̱, <<Dər, n là ìpipir ûpo mi ká̱ unang mi ka̱t, ka̱kul iza̱ kang mi là á ɓu jiwò yà?>> ");
INSERT INTO yer_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Uza̱ pak inok ayə́ng ka̱ mpipyal ka̱ ashe nkpaktak nra pa̱ nfangshat aga nnəm nchang izər va̱ ta. Á nak te, ka̱ nra ngga nfangshat te, uza̱ là ipir ngba achu va̱ ta á na, ka̱kul uza̱ pak nɗak na pa̱ ɗəkər. Nnà chit te uchar va̱ ta ga shal ìpir ngba achu va̱ ta ônəm wò ɗak. ");
INSERT INTO yer_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Ka̱ nra ngga nfangshat kang alum i tar te, onunggwan oga ìtong va̱ ta là ìpipir á na pa̱, <<Iza̱ ji mmàl irizhe ká̱ nchàng yà? Iza̱ ji ìlir ká̱ ìkam yà?>> Te uSamson là ôza̱ pa̱, <<Ká̱ yà pa̱ ó wap iram ká̱ ìya ìna mi ichar ka̱t te, ka̱ ó nyi ìpir ngba achu mi va̱ ta ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Te aRuhu aYawe vang ka̱ apal ishishi ká̱ ìkam, kang uza̱ fa ga aAshkelon, uza̱ gbá̱ng onəm ìsəm pa̱ ishatɗing, uza̱ wur iya̱m oza̱, kang uza̱ na oga ilukwan oza̱ ônunggwan va̱ ka̱ là ìpir ngba achu va̱ ta á na á. Ǹnyi te, ìgwak lak uSamson pa̱ gənggəng ka̱ apal nnap va̱ ta, kang uza̱ le ga nzhi apo wò. ");
INSERT INTO yer_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Te mmá yar uchar aSamson mmá na ûkpəkpa uva nəm ikpa ìvang á na. ");
INSERT INTO yer_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Á gba̱ng nva̱ng pa̱ ɗa̱p, ka̱ ashe awalang aga mɓən ìzangzəng te, uSamson kpán ìya ìɓəl ga nre anung ûchar wò ká̱. Uza̱ là pa̱, <<N ɗom tar ashe mbək achar mi.>> Ǹnyi te, upo achichar ma̱n á na pa̱ uza̱ a tar ashe ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Upo achichar là pa̱, <<Nnandər, ka̱ n rəng pa̱ u yang ka̱ na chit, ka̱kul nva̱ ta te, n na ìvang ká̱ na chit ûkpa ɓu. Ugənanggənang uɓwakan ɓyen ji na ka̱t ɗò? N chal ɓu ka̱m uwa ka̱ anungnung.>> ");
INSERT INTO yer_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Te uSamson là ôza̱ pa̱, <<Ka̱ awalang ava̱ ta̱ jiwò te, mi yà ká̱ mpat nro ka̱kul iya̱m iɓá̱ngɓa̱ng va̱ mi ga nnənəm ôFilisti ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Te uSamson fa ga wur oga nchám ìgba̱l pa̱ ishatɗing, kang uza̱ ga̱ɓa̱n oza̱ ran pa̱ ìparpar aswal ká̱ aswal. Te uza̱ ran apitila aga apər ka̱ ishimshe nza̱ nran nggo. ");
INSERT INTO yer_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Ka̱ nva̱ng va̱ uza̱ mwak apər chit ka̱ oga apitila, te uza̱ re oza̱ ga ashe iram oFilisti. Te a ri iya̱m-nrì va̱ mmá ɓən chit, ká̱ iva̱ na tong ka̱ ashe ìram, kang a pwak oga iram ìba̱ngba̱ng ká̱ oga iram mpyet oza̱ kpa. ");
INSERT INTO yer_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Awalang va̱ oFilisti ɓəp pa̱, <<Uda nəm iya̱m va̱ ta̱ yà?>> te, mmá là ôza̱ pa̱, <<USamson, ugwar aTimna, ka̱kul uza̱ yar uchichar uza̱ na ûkpa ìvəvang.>> Te oFilisti ga pwak uchar va̱ ta ká̱ upupo ká̱ apər, kang oza̱ kú. ");
INSERT INTO yer_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","USamson là ôza̱ pa̱, <<Ka̱kul iya̱m va̱ ó nəm ta̱ te, n sóng anung pa̱ mi yà ká̱ nrəre ka̱t, yà mi pyát akəkat kang.>> ");
INSERT INTO yer_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Kang uza̱ ru oza̱ ká̱ ìkum ká̱ nkam, kang a gbá̱ng oza̱ pa̱ makmak. Te uza̱ le ga təm ka̱ ashe agba̱k ro ka̱ ìpang aEtam. ");
INSERT INTO yer_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Te oFilisti kyén ga ləp apa̱k ka̱ aYahuda, kang oza̱ ga zàl ishi oza̱ ka̱ aLehi. ");
INSERT INTO yer_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Te onəm oga aYahuda ɓəp oza̱ pa̱, <<Iza̱ nak kang ó ɓa ìkum ka̱ yi yà?>> Kang oFilisti na ama̱n pa̱, <<Í ɓa pa̱ í ran uSamson, na í nəm á na wa nva uza̱ ka̱ nəm á yi á.>> ");
INSERT INTO yer_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Te onunggwan oga aYahuda ìkalong pa̱ ishatɗing fəng vang ashe agba̱k va̱ ka̱ ìpang aEtam, kang oza̱ là ûSamson pa̱, <<U nyi pa̱ oFilisti oma i nəm iponzhi ka̱ apal yi ka̱t ɗò? Te sang kang u nəm á yi pa yà?>> USamson na ama̱n ôza̱ pa̱, <<Wa nva oza̱ nəm á mi te, wa nnà ta n nəm oza̱ kpa.>> ");
INSERT INTO yer_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Te oza̱ là á na pa̱, <<Í ɓa pa̱ í ran ɓu, na í na ɓu ka̱ ashe awo oFilisti.>> Te uSamson là ôza̱ pa̱, <<Ó sóng anung á mi pa̱, mmawó na ká̱ ishi wó ó ga ngbá̱l mi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Te oza̱ là á na pa̱, <<Pa ka̱t. Í ga ngbá̱l ɓu ka̱t. Mmayi te, í ga nran ɓu í na oza̱.>> Te oza̱ ran na ká̱ asang apipye pa̱ parəm, kang oza̱ fa ká̱ na ka̱ ashe ìpang va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Awalang va̱ uza̱ ɓa aLehi te, oFilisti wong ká̱ nggha̱n pa̱ ó gwang na oza̱ í nə́m achu. Ta byet te, aRuhu aYawe vang ka̱ apal aSamson ká̱ ikam. Oga asang va̱ mmá ran awuwo ká̱ sərak ɓu là pa̱ afini va ri apər á, kang oga asang va̱ ta ka̱ awuwo tak ka̱ mbin. ");
INSERT INTO yer_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Te uza̱ ya akup apipye aro aga njwalak azhaki, uza̱ yichi awo yar ká̱, kang uza̱ gbá̱ng oFilisti ká̱ ìkalong pa̱ ìzəng. ");
INSERT INTO yer_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Te uSamson shì nnap-nshì pa̱, <<Ká̱ akup njwalak azhaki n gbá̱ng onunggwan ìkalong. Ká̱ akup njwalak azhaki m ɓut oza̱ nchələng ka̱ apal nchələng.>> ");
INSERT INTO yer_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Awalang va̱ uza̱ gbá̱l ká̱ nnap-nlà te, uza̱ mandar akup njwalak azhaki va̱ ta. Kang mmá wór atak va̱ ta pa̱ aRamat-Lehi. ");
INSERT INTO yer_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Kang ka̱kul ndəng gbá̱l na pa̱ gənggəng te, uza̱ chal uYawe, uza̱ là pa̱, <<Mmaɓu na u ná igwan ichumchum va̱ ta̱ ûzwal ɓu. Ǹyangmata̱ te, mi ga nkú ká̱ ndəng ngba̱l, kang mi tar ka̱ ashe awo onəm oga ache amulur va̱ ta̱ ɗò?>> ");
INSERT INTO yer_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Te Inan bol ache aro ka̱ mbin aLehi, kang ndəng shák fa ka̱ ashishe. Nva̱ngva̱ uSamson wá te, nnap-nnənəm le ɓa, kang ìkəkam le kpa. Ka̱kul nva̱ ta te, mmá wór aɗin atak va̱ ta pa̱, <<aEn-Hakore,>> nna yà ka̱ aLehi ɓa chu nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","USamson náp akwali ôIsa̱rila ìzun ìsəm pa̱ ìparəm ka̱ ashe nra va̱ oFilisti ka̱ yà ka̱ nnəm iponzhi ká̱ oza̱ á. ");
INSERT INTO yer_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Ká̱ nda aro te, uSamson ga aGaza, kang uza̱ ya uchar umaimai ro ka̱ ta. Te uza̱ tar ga ra ká̱ na. ");
INSERT INTO yer_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Mmá là ônəm oga aGaza pa̱, <<USamson uwa ɓa ka̱ ta̱.>> Te, oza̱ ga gang atak va̱ ta, kang oza̱ ra anyimnyal ka̱ na ká̱ izwam ka̱ anung asa̱l aga ntar ìtong va̱ ta. Oza̱ ma̱ng pa̱ kwak ka̱ ashe izwam va̱ ta, oza̱ í là pa̱, <<Re í lok atak aghánghàn aga anung ipin kang í gbá̱l na.>> ");
INSERT INTO yer_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Ǹnyi te uSamson ra ka̱ ta ga chu ishimshe izwam. Te, uza̱ wong kpán oga anung nzhi aga ntar ìtong va̱ ta, nzəng ká̱ oga ndədar pa̱ mparəm, kang uza̱ yənggət oza̱ tur le nzəng ká̱ ndar ngga nvərang anunung, ká̱ nkpaktak oga iya̱m va̱ ka̱ izər anung nzhi va̱ ta. Uza̱ wur oza̱ nak ka̱ agar wò, kang uza̱ kyén ká̱ oza̱ ga apal aɗuktum va̱ ka̱ mpyal aHebron. ");
INSERT INTO yer_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Ka̱ nvəva̱ng te, uSamson wong ɓan mma̱n uchar uro ka̱ mBa̱nda̱m aSorek, uva aɗiɗin pa̱ uDelila. ");
INSERT INTO yer_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Te oponzhi oFilisti ɓa ga atak achar va̱ ta, kang oza̱ là á na pa̱, <<Ɗak na u tàng na pa̱ shiriri mwote uza̱ i nyám atak ìkam wò iga nəm ayər va̱ ta̱, ká̱ asa̱l va̱ í nəm kang i ji nkəkam, na í ran na í nəm igwan ká̱ na. Nza̱ uzəngtəng yi nggo i na aazurfa á ɓu ìkalong pa̱ ìzəng ká̱ ìgba̱l pa̱ ìzəng.>> ");
INSERT INTO yer_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Te uDelila là ûSamson pa̱, <<N chal ɓu, nyám á mi atak va̱ nkam ɓu nchumchum va̱ ta̱ i fa kà̱, ká̱ asa̱l va̱ mí ran ɓu ká̱ kang mí ji nkam ɓu á.>> ");
INSERT INTO yer_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","USamson na ama̱n á na pa̱, <<A yà pa̱ unəm a ran mi ká̱ oga asang apipye aga nlyat ìjang pa̱ fangshat ava na wom chit ka̱t te, nkam mi i yà wa nji aɓoshi onəm.>> ");
INSERT INTO yer_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Te oponzhi oFilisti va̱ ta ɓa ká̱ oga asang apipye aga nlyat ìjang va̱ ta á na pa̱ fangshat, ava nna wom chit ka̱t, kang uza̱ ran na ká̱ oga asang va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","Uza̱ wa ka̱ yà ká̱ onəm va̱ ra anyimnyal ka̱ ashe afu nzhi va̱ ta. Te uDelila ləp achu á na pa̱, <<ÁSamson, oFilisti oma ta̱ ka̱ apal ishi ɓu.>> Ǹnyi te, uza̱ páng oga asang aga nlyat ìjang va̱ ta ɓu là pa̱ afini va mmá mang ka̱ ashe apər. Te, mmá nyi atak va̱ ìkəkam bwam kà̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Te uDelila là ûSamson pa̱, <<Dər, u tàng mi, u nap akwam á mi. Ǹyangmata̱ mmami ka̱ nchal ɓu, là á mi asa̱l va̱ mí ran ɓu ká̱.>> ");
INSERT INTO yer_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Te uSamson là á na pa̱, <<A yà pa̱ unəm a ran mi ká̱ oga asang apipye ava na mmá nəm inok ká̱ oza̱ chit ka̱t te, ìkam mi i yà wa nji aɓoshi onəm.>> ");
INSERT INTO yer_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Te uDelila wur oga asang apipye ran na ká̱, kang uza̱ ləp achu á na pa̱, <<ÁSamson, oFilisti oma ta̱ ka̱ apal ishi ɓu.>> Onəm ma ka̱ ra anyimnyal ka̱ na ka̱ ashe afu nzhi va̱ ta. Ǹnyi te, uSamson páng oga asang va̱ ta ka̱ awo wò ɓu là pa̱ oga afini. ");
INSERT INTO yer_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Te uDelila là ûSamson pa̱, <<Nna mmaɓu ka̱ ntàng mi ɓa chu awalang va̱ ta̱, kang mmaɓu ka̱ nnap akwam á mi. Là á mi asa̱l va̱ mí ran ɓu ká̱.>> USamson na ama̱n á na pa̱, <<A yà pa̱ unəm a tát oga nlok akpap ishi mi pa̱ nfangshat va̱ ta̱ ká̱ afini ka̱ izər mɓuyər ngga nlok iya̱m te, nkam mi i yà wa nji aɓoshi onəm.>> Awalang va̱ uza̱ ka̱ nra nda te, uDelila tát oga nlok ishishi aga afangshat va̱ ta ká̱ afini, ");
INSERT INTO yer_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","kang uza̱ ran oza̱ ka̱ izər mɓuyər ngga nlok iya̱m. Te uza̱ ləp achu á na pa̱, <<ÁSamson, oFilisti oma ta̱ ka̱ apal ishi ɓu.>> Uza̱ yenda̱l ka̱ iwu nda kang uza̱ zəp mɓuyər ngga nlok iya̱m va̱ ta, nzəng ká̱ afini va̱ mmá tát ká̱. ");
INSERT INTO yer_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Te, uDelila là á na pa̱, <<Sang kang ɓu là pa̱, <m ma̱n ɓu ma̱n,> ǹnyi te, ìgwak ɓu nzəng ká̱ mi ka̱t yà? U tàng mi chit nva̱ng pa̱ nshatɗing, kang na u là atak va̱ á mi chit nkam ɓu nchumchum va̱ kà̱ ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Wa nnà ta nza̱ nra nggo uza̱ i pak nɗak na, ga chu awalang va̱ ìgwak ga lak na na uza̱ i kukú. ");
INSERT INTO yer_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Ka̱ nkukur te, uSamson là nnandər igwak wò á na, uza̱ là pa̱, <<Nna mmá kpán ishi mi chit ká̱ ikpal ishi ka̱t, ka̱kul mmami uNazarat uva mmá gar Înan ka̱ ashe afu anang mi na byet. A yà pa̱ mmá kpán ishi á mi te, nkam mi i kap ká̱ mi, kang mi yà wa aɓo onəm. ");
INSERT INTO yer_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Awalang va̱ uDelila ya pa̱ uza̱ là nnandər á wò chit te, uza̱ re nre mmá wór oponzhi oFilisti. Uza̱ là pa̱, <<Ó ɓa kà̱ɗi, ka̱kul uza̱ là nnandər ìgwak wò á mi chit.>> Te oponzhi oFilisti ɓa atətak ká̱ mbwai va̱ ka̱ awo oza̱. ");
INSERT INTO yer_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Uza̱ nak na ra nda ka̱ apal oga isong wò, uza̱ wór unəm uro kpat oga nlok akpap ishishi aga afangshat va̱ ta. Te izər ɓan nrusok ká̱ na, kang ìkəkam kap ká̱ na. ");
INSERT INTO yer_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Te uDelila là pa̱, <<ÁSamson, oFilisti oma ta̱ ka̱ apal ishi ɓu.>> Te uza̱ yenda̱l ka̱ iwu nda, kang uza̱ rəng pa̱, <<Mi wong mi fa wa mmatmat, ká̱ nkam izər mi.>> Ka̱kul uza̱ nyi pa̱ uYawe kap ka̱ wò chit ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Te oFilisti kpán na, oza̱ zəp iwu ka̱ na, kang oza̱ ga ká̱ na ka̱ aGaza, te oza̱ ran na ká̱ oga nzwar ngga acham arəzang, kang oza̱ nak na i kpà iya̱m ka̱ ashe nzhi ikan. ");
INSERT INTO yer_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Ǹnyi te, akpap ishishi ɓan nfa ka̱ɗi ka̱ nva̱ngva̱ mmá kpán ishi á na chit á. ");
INSERT INTO yer_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Ǹyangmata̱ te, oponzhi oFilisti ɓut pa̱ na ó yichi nləfər iya̱m ipápà nchumchum, na ó shep inan oza̱ uDagon. Kang oza̱ là pa̱, <<Inan yi na igwan á yi chit ka̱ apal aSamson ukpa ìkum yi.>> ");
INSERT INTO yer_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Awalang va̱ onəm va̱ ta ya na te, oza̱ shep inan oza̱, oza̱ i là pa̱, <<Inan yi na ukpa ìkum yi chit, ka̱ ashe awo yi, unəm uva nak mbin yi ra agung, kang à gbá̱ng onəm yi pa̱ makmak á.>> ");
INSERT INTO yer_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Awalang va̱ oza̱ ka̱ ashe nchàng ìgwak pa̱ makmak te, oza̱ là pa̱, <<Mmá ɓa ká̱ uSamson, na uza̱ á na nchàng ǹyəl á yi.>> Te mmá wór uSamson ka̱ ashe nzhi ikan, kang uza̱ na nchàng ǹyəl ôza̱. Awalang va̱ oza̱ nak na sat ka̱ ishimshe oga ndar ngga nda̱r nzhi va̱ ta pa̱ mparəm te, ");
INSERT INTO yer_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","uSamson là ûyen uga ndap wò pa̱, <<Ga ká̱ mi na n dok izər oga ndar va̱ da̱r nzhi va̱ ta̱, na n da̱r izər ka̱ izər oza̱.>> ");
INSERT INTO yer_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Ǹyangmata̱ te, nzhi va̱ ta yəl ká̱ onunggwan, ká̱ ochar. Nkpaktak oponzhi oFilisti oma yà ka̱ ta, kang onunggwan, ká̱ ochar oma yà ka̱ ta á chu ìkalong pa̱ ishatɗing ka̱ apal ova ka̱ ndər uSamson, nva̱ uza̱ kà̱ nna nchàng nyəl oza̱ á. ");
INSERT INTO yer_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Te uSamson far afar ûYawe pa̱, <<ÁYawe uGa ngGatək, rəng ká̱ mi. ÁInan, n chal ɓu, na ìkam á mi ka̱ɗi nva̱ng pa̱ nzəng byet, na m pyát akat ka̱ apal oFilisti, ka̱kul iwú mi iga ìparəm va̱ oza̱ zəp á.>> ");
INSERT INTO yer_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Kang uSamson kpán oga ndar ngga ishimshe ngga mparəm va̱ na ikam n̂zhi va̱ ta. Awuwo ari ka̱ apal aro, kang awuwo apəra̱m ka̱ apal nro. ");
INSERT INTO yer_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","USamson là pa̱, <<Re n kú nzəng ká̱ oFilisti va̱ ta̱.>> Te uza̱ da̱n ká̱ nkpaktak ikam wò, kang nzhi va̱ ta shin ka̱ apal oponzhi oFilisti, ká̱ nkpaktak onəm va̱ ka̱ ashishe. Onəm va̱ uza̱ gbá̱ng ka̱ awalang ikúku te, á yə́l ji ovəngva̱ ji uza̱ gbá̱ng ka̱ awalang va̱ uwa yà ká̱ irirì. ");
INSERT INTO yer_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Te ogənanggənang ká̱ nkpaktak nzhi apupo fa ga yar akúkum, oza̱ le ga li na ka̱ ishimshe aZora ká̱ aEshtawol ka̱ ashe awap apupo uManowa. USamson ka̱ náp akwali ôIsa̱rila chit izun ìsəm pa̱ ìparəm. ");
INSERT INTO yer_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","Unəm uro uwa ka̱ yà ka̱ ìtong iga aɗuktum aEfrayim aɗiɗin pa̱ uMika. ");
INSERT INTO yer_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","Ká̱ nda nro uza̱ là ûnang wò pa̱, <<N fe u vyap unəm va̱ wur aazurfa ɓu ìkalong pa̱ ìzəng ká̱ ìgba̱l pa̱ ìzəng va̱, dər nna ta̱, mmami nà n wur.>> Te unənang là pa̱, <<UYawe á nak nnap-nnəna̱n á ɓu, áyen mi.>> ");
INSERT INTO yer_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","Awalang va̱ uza̱ le ká̱ aazurfa ìkalong pa̱ ìzəng ká̱ ìgba̱l pa̱ ìzəng va̱ ta ûnang wò te, unənang là pa̱, <<Ka̱kul kang nsur nro a kpán uyen mi ka̱t te, n gor aazurfa mi ûYawe. Mí kpà ala̱ka̱n ìchər ká̱ akun, kang mí ɓam izəzər ká̱ aazurfa. Ǹyangmata̱ te, mi le ká̱ aazurfa va̱ ta á ɓu.>> ");
INSERT INTO yer_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","Te uMika le ká̱ aazurfa va̱ ta ûnang wò, kang unənang kpa̱k aazurfa ìgba̱l pa̱ ìparəm na ûnəm uga nla ala, uva nəm ala̱ka̱n ìchər va̱ ká̱. Te mmá nak oza̱ ka̱ ashe nzhi aMika. ");
INSERT INTO yer_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","Ǹyangmata̱ te, uMika me nzhi iya̱m ngwop ka̱kul ìchər va̱ ta, kang uza̱ nəm ìlukwan ìkwoksok ká̱ oga ichər iro. Te uza̱ kyer uzəngtəng ka̱ ashe ovəvan onunggwan sat unəm uga mpyal iya̱m ngwuwop. ");
INSERT INTO yer_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","Ka̱ ashe oga nra va̱ ta te, oIsa̱rila yà ká̱ uponzhi ka̱t, udanggo i nəm iya̱m va ma ká̱ na. ");
INSERT INTO yer_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","Ka̱ awalang va̱ ta te, uyenza̱m uro ka̱ akum ìjili aLawi, uva ka̱ yà ntəm ka̱ aBet-Lehem aga aYahuda, ");
INSERT INTO yer_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","re ìtong va̱ ta pa̱ na ô ga ô ram atak va̱ o təm kà̱. Uza̱ ka̱ ashe achen te, uza̱ ɓa chu nzhi aMika ka̱ ìtong iga aɗuktum aEfrayim. ");
INSERT INTO yer_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","Te uMika ɓəp na pa̱, <<U fa ka̱ che yà?>> Kang uza̱ là pa̱, <<Mmami akum ìjili aLawi, n fa ka̱ aBet-Lehem aga aYahuda, kang mmami ka̱ nram atak pa̱ n təm kà̱.>> ");
INSERT INTO yer_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","Te uMika là á na pa̱, <<Təm ká̱ mi, na ú yà upo mi ká̱ unəm uga mpyal awop mi, te mi na aazurfa á ɓu pa̱ gba̱pchi ka̱ ashe ìzun, nzəng ká̱ ilukwan ɓu, ká̱ iya̱m-nrì ɓu.>> ");
INSERT INTO yer_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","Te uLawi va̱ ta ma̱n ká̱ iya̱m va̱ uza̱ là, kang uyenza̱m va̱ ta təm wa azəngtəng ka̱ ashe ovəvan onunggwan. ");
INSERT INTO yer_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","Te uMika nak na sat unəm uga mpyal awuwop, kang uyenza̱m va̱ ta təm ka̱ nzhi aMika. ");
INSERT INTO yer_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","Kang uMika là pa̱, <<Ǹyangmata̱ te, n nyi chit pa̱ uYawe iga nnəm inəna̱n á mi, ka̱kul n yà ká̱ uLawi chit unəm uga mpyal awop mi.>> ");
INSERT INTO yer_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","Ka̱ ashe oga nra va̱ ta te, oIsa̱rila yà ká̱ uponzhi ka̱t. Kang akum ìjili aDan oma ka̱ yà ka̱ mmwo atak îshi oza̱ pa̱ na ó təm kà̱, ka̱kul oma ka̱ ya iya̱mkup iji oza̱ chit ka̱ ashe oga akum ìjili oIsa̱rila ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","Te onəm aDan yak onunggwan okamkam pa̱ otukun ka̱ aZora ká̱ aEshtawol pa̱ oza̱ á ga á song kang i gbap mbin va̱ ta. Onəm va̱ ta sat ka̱ anung nkpaktak akum ijili aDan. Oza̱ là ôza̱ pa̱ <<Ó ga na ó song mbin va̱ ta.>> Oza̱ ga chu aɗuktum aEfrayim, te oza̱ ga nzhi aMika, oza̱ ra ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","Awalang va̱ oza̱ ga dat ká̱ nzhi aMika te, oza̱ nyi uyenza̱m uga aLawi va̱ ta ka̱ atak ichəchu, kang oza̱ ga ɓəp na pa̱, <<Uda ɓa ká̱ ɓu ka̱ ta̱ yà? Iza̱ mmaɓu ka̱ nnənəm ka̱ atak va̱ ta̱ yà? Sang mmaɓu ka̱ ta̱ yà?>> ");
INSERT INTO yer_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","Uza̱ là ôza̱ iya̱m va̱ uMika ka̱ nəm á na chit pa̱, <<Uza̱ yar mi chit unəm uga mpyal awuwop, i mwa mi.>> ");
INSERT INTO yer_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","Te oza̱ là á na pa̱, <<Mmayi ka̱ nchal ɓu, ɓəp Inan, na í nyi mwote achen yi va̱ ta̱ i yìyà ká̱ igwan ɗò?>> ");
INSERT INTO yer_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","Te unəm uga mpyal awop va̱ ta na ama̱n ôza̱ pa̱, <<Ó ga ká̱ ikángkáng, ka̱kul uYawe uwa yà nzəng ká̱ wó ka̱ ashe achen wó.>> ");
INSERT INTO yer_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","Te onəm oga otukun va̱ ta wong ga, kang oza̱ ɓa chu aLayish. Oza̱ ya onəm va̱ ta ka̱ ntəm pa̱ shat wa onəm oga aSidon, oza̱ ka̱ ntəm ká̱ ikángkáng kang oza̱ ka̱ ntəm pa̱ shat. Oza̱ lang iya̱m iro ka̱ mbin oza̱ ka̱t, kang oza̱ dur byet. Kà̱ɗi te, oza̱ ra gbà̱ng ká̱ oSidon, kang oza̱ ka̱ nnəm ntəm nzəng ká̱ unəm uro ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","Awalang va̱ onəm va̱ ta le ga atak ogənang oza̱ ka̱ aZora ká̱ aEshtawol te, oza̱ ɓəp oza̱ pa̱, <<Ó ga ó ya sang yà?>> ");
INSERT INTO yer_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","Te oza̱ na ama̱n pa̱, <<Ó wong, í ga í ru oza̱ ká̱ ìkum, ka̱kul í ya mbin va̱ ta chit, kang á ɓyen byet. Kang ó kali pa mwang ka̱t, ó ga na ó ri mbin va̱ ta á yà nji wó. ");
INSERT INTO yer_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","Awalang va̱ ó ga ó chu atak va̱ ta te, ó ga nya onəm va̱ ta ka̱ ntəm pa̱ shat. Mbin va̱ ta bál byet, mbin ndopdop nva mí lang iya̱m iro ka̱ ashishe ka̱t, kang Inan na mbin va̱ ta chit ka̱ ashe awo wó. ");
INSERT INTO yer_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","Te, onunggwan ìgba̱l pa̱ ìkpa̱ɗing ka̱ akum ìjili aDan, ova gbar izər chit ká̱ oga iya̱mɓáng wong ka̱ aZora ká̱ aEshtawol, ");
INSERT INTO yer_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","oza̱ ga ləp apa̱k ka̱ asa̱l ntar alum aKiriyat-Jeyarim ka̱ ashe mbin aYahuda. Nna nak kang mí wór atak va̱ ta pa̱ aMahane Dan ɓa chu nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","Oza̱ wong ka̱ ta te, oza̱ ga ìtong iga aɗuktum aEfrayim, kang oza̱ ɓa chu nzhi aMika. ");
INSERT INTO yer_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","Te onunggwan oga otukun va̱ ka̱ ga ka̱ sòng mbin aLayish, là ôgənang oza̱ pa̱, <<Ó nyinyi pa̱ ka̱ ashe oga nzhi va̱ ta̱ te, nzhi nro na yà ká̱ ìlukwan ìkwoksok, ká̱ oga ichər ikpákpà, ká̱ ala̱ka̱n ìchər va mmá kpà ká̱ akun kang mmá ɓam izəzər ká̱ aazurfa ka̱ ashishe ɗò? Ǹyangmata̱ te, ó rəng iya̱m va̱ ó ga nnənəm.>> ");
INSERT INTO yer_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","Te oza̱ lyep ka̱ ta, oza̱ ga re anung ûyenza̱m uLawi va̱ kà̱ nzhi aMika á. ");
INSERT INTO yer_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","Kang onəm aDan oga ìgba̱l pa̱ ìkpa̱ɗing va̱ ka̱ gbar izər ká̱ iya̱mɓáng ka̱kul ìkum tong ka̱ anung asa̱l aga ntar nzhi va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","Onunggwan oga otukun va̱ ka̱ ga nsòng mbin va̱ ta táng ashe nzhi kang oza̱ wur oga ichər ikpákpà, ká̱ ala̱ka̱n ìchər va̱ mmá kpà ká̱ akun kang mmá ɓam izəzər ká̱ aazurfa, ká̱ ìlukwan ìkwoksok ìyə́ryər. Ǹnyi te, unəm uga mpyal awop uwa sat ka̱ anung asa̱l aga ntar nzhi va̱ ta nzəng ká̱ onəm ìgba̱l pa̱ ìkpa̱ɗing ova gbar izər ká̱ oga iya̱m-wór ka̱kul ìkum va̱ á. ");
INSERT INTO yer_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","Awalang va̱ onunggwan oga otukun va̱ ta̱ táng ashe nzhi aMika wur oga ichər ikpákpà ká̱ ala̱ka̱n ìchər va̱ mmá kpà ká̱ akun kang mmá ɓam izəzər ká̱ aazurfa, ká̱ ìlukwan ìkwoksok ìyə́ryər te, unəm uga mpyal awop ɓəp oza̱ pa̱, <<Iza̱ mmawó ka̱ nnənəm yà?>> ");
INSERT INTO yer_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","Te oza̱ na ama̱n á na pa̱, <<Ma̱r, kpán anung ɓu. Ga nzəng ká̱ yi, na ú yà upo ká̱ unəm uga mpyal awop á yi. Kapkap pa̱ ú yà unəm uga mpyal awop âkum ìjili aIsa̱rila ká̱ nva̱ pa̱ ú yà unəm uga mpyal awop n̂zhi anəm pa̱ uzəng ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","Awalang va̱ unəm uga mpyal awop va̱ ta fe pa te, ìgwak chàng na. Te uza̱ wur oga ichər ikpákpà, ká̱ ala̱ka̱n ìchər va̱ mmá kpà ká̱ akun kang mmá ɓam izəzər ká̱ aazurfa, ká̱ ìlukwan ìkwoksok ìyə́ryər, uza̱ ga nzəng ká̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","Te oza̱ le ga nva̱ng, oza̱ nak ovan oza̱, ká̱ iya̱mkang oza̱, ká̱ nkpaktak iya̱m oza̱ ka̱ mpyal. ");
INSERT INTO yer_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","Awalang va̱ onəm aDan ga chit gbà̱ng ɗa̱p ká̱ nzhi aMika te, mmá wór onəm va̱ ra dát ká̱ nzhi aMika fa ɓut, oza̱ ɓàk nva̱ng onəm aDan ga ɓan oza̱. ");
INSERT INTO yer_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","Nva̱ oza̱ ka̱ nnə́m achu í ɓàk nva̱ng oza̱ te, onəm aDan ga̱ɓa̱n ɓəp uMika pa̱, <<Iza̱ nɗaktak ɓu, kang u ɓut nggatək va̱ ta̱ ɓu ɓàk nva̱ng yi ká̱ yà?>> ");
INSERT INTO yer_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","Te uMika na ama̱n pa̱, <<Ó wur oga inan mi va̱ n nəm ká̱ unəm uga mpyal awop mi ó ga ká̱, ó re iya̱m iro á mi ka̱t. Te sang kang ó ɓəp mi pa̱, <Iza̱ nɗaktak mi yà á?>> ");
INSERT INTO yer_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","Te onəm aDan na ama̱n pa̱, <<Kang wa dap ká̱ yi ka̱t, ka̱t te ìgwak i wong i lak onəm oro kang oza̱ i ru ɓu ká̱ ìkum, te mmaɓu ká̱ nzhi ɓu ó zhì.>> ");
INSERT INTO yer_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","Te onəm aDan ga mpyal ká̱ achen oza̱. Awalang va̱ uMika ya pa̱ oza̱ ji nkam wò ji te, uza̱ ga̱ɓa̱n le ga nzhi wò. ");
INSERT INTO yer_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","Te onəm aDan wur oga ichər aMika ká̱ unəm uga mpyal awuwop, kang oza̱ kyén ga aLayish, atak va onənəm ka̱ ntəm ká̱ ikángkáng kang pa̱ shat á. Oza̱ ru oza̱ ká̱ ìkum gbá̱ng oza̱ ká̱ ndokchi, kang oza̱ pwak ìtong va̱ ta ká̱ apər. ");
INSERT INTO yer_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","Unəm uro yà pa̱ á ka̱m ishi onəm va̱ ta ka̱t, ka̱kul oza̱ ra gbà̱ng ká̱ aSidon, kang oza̱ yà ká̱ ngwang ishi ká̱ unəm uro ka̱t. Ìtong va̱ ta̱ ka̱ ashe aba̱nda̱m aro va dát ká̱ aBet-Rehop. Te onəm aDan le me ìtong va̱ ta kang oza̱ təm ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","Oza̱ ga̱ɓa̱n aɗin îtong va̱ ta le wór pa̱ aDan wa aɗin akəka oza̱ uDan, uva mmá mar ûIsa̱rila. Ka̱ yà te, mí wór ìtong va̱ ta pa̱ aLayish. ");
INSERT INTO yer_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","Te onəm aDan pak ìchər va̱ ka̱ ta, pa̱ na ó wop, kang oza̱ kyer uJonatan uya aGershom ununggwan, uya aMusa ununggwan, ká̱ ovəvan onunggwan sat onəm oga mpyal awop âkum ìjili aDan ga chu awalang va̱ mmá wur oza̱ ka̱ mbin va̱ ta ga izwal. ");
INSERT INTO yer_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","Oza̱ ga mpyal ká̱ ngwop ìchər va̱ aMika ka̱ nəm, ka̱ ashe nkpaktak awalang va̱ nzhi Inan ka̱ aShilo. ");
INSERT INTO yer_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","Ka̱ ashe oga nra va̱ ta te, aIsa̱rila yà ká̱ uponzhi ka̱t. Ǹyangmata̱ te, uLawi uro uva ka̱ ntəm ka̱ ashe iya ìtong iro ka̱ ìtong iga aɗuktum aEfrayim, ka̱m uchar va mí nak ka̱ ashe nzhi pa kùk ka̱ aBet-Lehem aga aYahuda. ");
INSERT INTO yer_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","Ǹnyi te, uchar va̱ ta nəm nlang nnandər á na. Uchar va̱ ta re na, le ga nzhi apo wò ka̱ aBet-Lehem aga aYahuda. Nva̱ngva̱ uza̱ təm chit ka̱ ta ga chu apye pa̱ neɗing te, ");
INSERT INTO yer_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","uɓəɓar wong ga pa̱ na ô chal na, pa̱ uza̱ a le á ɓa nzhi wò. Uza̱ nzəng ká̱ uzwal wò, ká̱ oga azhaki pa̱ aparəm. Uchar va̱ ta tar ká̱ na ka̱ ashe nzhi apo wò, kang awalang va̱ ugugwar ya na te, uza̱ ka̱m na ká̱ nchàng ìgwak pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","Te ugugwar, upo achar va̱ ta kpán na pa̱ uza̱ á təm ká̱ wó pa̱ ɗa̱p kang, te uza̱ təm ká̱ oza̱ nra pa̱ ishatɗing, oza̱ ka̱ nri, oza̱ i wá, kang oza̱ i ra ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","Ka̱ nra ngga nneɗing te, unəm va̱ ta wong ká̱ iɓotak pa̱ na ó ga, ǹnyi te, upo achar va̱ ta là ûgwar wò pa̱, <<Ri iya̱m-nrì iro kang ɓu ga.>> ");
INSERT INTO yer_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","Te mparəm oza̱ le təm kang oza̱ ri, oza̱ wá nzəng. Ka̱ nvəva̱ng te, upo achar va̱ ta là á na pa̱, <<Kusuk, le ra kà̱ɗi, na u na nfe nchàng îzər ɓu.>> ");
INSERT INTO yer_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","Unəm va̱ ta wong pa̱ na ô ga te, ugugwar pak nchal na pa̱ uza̱ sat kang, te uza̱ ma̱n ra kà̱ɗi. ");
INSERT INTO yer_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","Ka̱ nra ngga ntukun te, uza̱ wong ká̱ iɓotak kà̱ɗi pa̱ na ô ga te, upo achar va̱ ta là pa̱, <<Ri iya̱m iro kang, na u lok alum á ɓan ntar kang ɓu ga.>> Te mparəm oza̱ va̱ ta təm kang oza̱ ri iya̱m-nrì nzəng. ");
INSERT INTO yer_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","Awalang va̱ unəm va̱ ta ká̱ uchəchar va̱ uza̱ nak ka̱ ashe nzhi pa kùk, ká̱ uzuzwal wong pa̱ na ó ga, te ugugwar, upo achar va̱ ta la̱ á na pa̱, <<Dər, ǹyangmata̱ alum dát chit i tar, le ra iya̱m ɓu ka̱ ta̱. Atak dát chit i kpà̱r, ra na u na nfe nchang îzər ɓu. Ipin ká̱ ìɓotak te, ɓu wong ɓu kpán asa̱l ɓu.>> ");
INSERT INTO yer_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","Ǹnyi te, unəm va̱ ta ɗom pa̱ ô ra lap ka̱t. Te uza̱ wong kpán asa̱l wòl ìsu aJebus, nna mí wór aUrushelima á. Uza̱ nzəng ká̱ oga azhaki wò aga nkongkong pa̱ mparəm, ká̱ uchəchar va̱ uza̱ nak ka̱ ashe nzhi pa kùk va̱ á. ");
INSERT INTO yer_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","Awalang va̱ oza̱ dát ká̱ aJebus kang alum kwangtal chit te, uzwal va̱ ta là ûnəm uga nzhi wò pa̱, <<Re í tong ka̱ ashe ìtong oJebusi va̱ ta̱, na í ra ka̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","Te unəm uga nzhizhi na ama̱n á na pa̱, <<Í yà ká̱ nra ka̱ mbin oɗyanəm ka̱t, ka̱kul onəm oga ìtong va̱ ta̱ oIsa̱rila ka̱t. Ka̱kul nva̱ ta te, í watar í ga aGibeya.>> ");
INSERT INTO yer_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","Kang uza̱ là ûzwal wò pa̱, <<Ɓa na í ɗak í ga i chu aGibeya, ka̱t te, aRama, kang í ra ka̱ atak aro ka̱ ashe ìtong va̱ ta.>> ");
INSERT INTO yer_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","Te oza̱ watar, oza̱ ɓa chu aGibeya iga mbin aBenjamin yà alum ka̱ ntar, ");
INSERT INTO yer_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","kang oza̱ tong ka̱ ta, pa̱ na oza̱ á ra ka̱ aGibeya. Oza̱ ga təm ka̱ ashe agbagba ìtong va̱ ta, ǹnyi te, unəm uro yà ka̱m oza̱ táng ashe nzhi wò ká̱ pa̱ oza̱ á ra ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","Oma ka̱ ta na te, unəmgbak uro ka̱ ìtong iga aɗuktum aEfrayim, uva ka̱ ntəm ka̱ aGibeya, atak va onəm oga akum ìjili aBenjamin təm kà̱, ka̱ nle ka̱ atak inok ka̱ ashe iram wò ká̱ arurong. ");
INSERT INTO yer_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","Awalang va̱ uza̱ wong ká̱ ìwu kang a ya unəm uga achen va̱ ta təm ka̱ agbagba aga ìtong va̱ ta te, unəmgbak va̱ ta ɓəp na pa̱, <<U fa ka̱ che yà? Mmaɓu ka̱ ngga che yà?>> ");
INSERT INTO yer_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","Te unəm oLawi va̱ ta na ama̱n á na pa̱, <<Í fa ka̱ aBet-Lehem ka̱ ashe aYahuda, mmayi ka̱ ngga iya ìtong iro ka̱ mbin ngga aɗuktum aEfrayim, n fa ka̱ ta na. N ga aBet-Lehem ka̱ aYahuda, kang ǹyangmata̱ te, mmami ka̱ ngga atak nzhi aYawe, kang ǹnyi te, unəm uro yà ka̱m mi tar nzhi wò ká̱, pa̱ na n ra ka̱ ta ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","Na í yà ká̱ ìpəpa ká̱ nrì ka̱kul oga azhaki yi, kang na í yà ká̱ nzəngkəng ká̱ ndəng ìba̱ngba̱ng ka̱kul ishi yi ozwal ɓu, mmami, ká̱ uchar va̱ ta̱, ká̱ uyenza̱m va̱ nzəng ká̱ yi á. Í lang iya̱m iro ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","Te unəmgbak va̱ ta là pa̱, <<Ntəm ikángkáng á yà nzəng ká̱ wó. Re n mwa nkpaktak nɗom wó á wó. Kang ó ra ka̱ ashe agbagba ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","Te uza̱ ka̱m oza̱ ga nzhi wó ká̱, na nrì ôga azhaki oza̱. Ka̱ nva̱ngva̱ oza̱ nal ashar oza̱ chit te, oza̱ ri kang oza̱ wá. ");
INSERT INTO yer_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","Oma ka̱ ashe nfe nchàng oza̱ te, onunggwan onga oro ka̱ ashe ìtong va̱ ta ɓa gang nzhizhi. Oza̱ i nə́m anung nzhi, kang oza̱ i là ûnəmgbak va̱ ta, uwa unəm uga nzhi pa̱, <<Fa ká̱ unəm va̱ ɓa nzhi ɓu, na í ra ichar ká̱ na. ");
INSERT INTO yer_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","Te unəm uga nzhi va̱ ta fa ga atak oza̱, là nnap ká̱ oza̱ pa̱, <<Pa ka̱t ógənang mi. Kang ó nəm inga ka̱t. Unəm va̱ ta̱ unəmchən mi, kang ó nəm apir iya̱m iga ìwuswa va̱ ta̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","Dər, uyen mi uchar uwa ta̱ uva uwa nyi ununggwan chit ka̱t á, ká̱ uchəchar va̱ uza̱ nak ka̱ ashe nzhi pa kùk. Re n fa ká̱ oza̱ á wó, na ó nəm iya̱m va̱ ká̱ oza̱ ó ɗom. Ǹnyi te, kang ó nəm iya̱m ìwuswa ûnəm va̱ ta̱ ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","Ǹnyi te, onəm va̱ ta gwong achwang ka̱ na ka̱t. Te unəm uga aLawi va̱ ta fa ká̱ uchəchar va̱ uza̱ nak ka̱ ashe nzhi pa kùk ôza̱ ka̱ agbai, kang onəm va̱ ta ra ká̱ uchar va̱ ta ká̱ ìfan, oza̱ i pa̱ng izər ká̱ na ka̱ ashe ìzwam va̱ ta ga chu anung ìpin. Nna chit te oza̱ re na ɗak ga. ");
INSERT INTO yer_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","Atak tàn te, uchar va̱ ta le ga nzhi va̱ unəm uga nzhizhi kà̱, ru ka̱ anung asa̱l nzhi, kang uza̱ ra ka̱ ta atak ga ghan. ");
INSERT INTO yer_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","Awalang va̱ unəm uga nzhizhi wong ká̱ ìpin bol anung nzhi pa̱ na ká̱ ò ga mpyal ká̱ achen wò te, uza̱ ya uchəchar va̱ uza̱ nak ka̱ ashe nzhi pa kùk ra chit ka̱ anung asa̱l nzhi i yichi awo i ga izər anung nzhi. ");
INSERT INTO yer_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","Uza̱ là ûchar va̱ ta pa̱, <<Wong, na i ga.>> Ǹnyi te, uza̱ lyen á na ka̱t. Te unəm va̱ ta yar na nak ka̱ apal azhaki wò, kang uza̱ kpán asa̱l ga nzhi wò ká̱. ");
INSERT INTO yer_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","Awalang va̱ uza̱ chu nzhi wò te, uza̱ yar ìkpal, uza̱ nyat ìzhe achəchar va̱ uza̱ nak ka̱ ashe nzhi pa kùk, ngba̱ng ká̱ ngba̱ng pa̱ ngba̱pchi ama̱n pa̱ aparəm, kang uza̱ re nre ká̱ ngba̱ng pa̱ nzəng n̂za̱ akum ìjili nggo ka̱ ashe nkpaktak mbin aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","Kang nza̱ unəm nggo va ya te, i là ûwan wò pa̱, <<Á ɓan ka̱ ilum va̱ í re aMasar te, nna mmá fe apir nnap va̱ ta̱ chit ka̱t, kang nna mmá nəm apipir chit ka̱ ashe mbin aIsa̱rila ka̱t. Ó rəng nnap kà̱. Nkpak pa̱ í nəm iya̱m iro. Í là nnàp kà̱. ");
INSERT INTO yer_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","Te nkpaktak onəm oga aIsa̱rila, ɓan ka̱ aDan ga chu aBeyersheba, kang ká̱ mbin aGileyat fa ɓut ka̱ anung zəngtəng ka̱ mpyal aYawe ka̱ aMizpa. ");
INSERT INTO yer_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","Te onəm oga mpyal nkpaktak oga akum ìjili aIsa̱rila, yar atak nsat oza̱ ka̱ ashe nggatək onəm Inan, onunggwan ìkalong ìgba̱l pa̱ ìneɗing ká̱ oga ndokchi. ");
INSERT INTO yer_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","Onəm aBenjamin fe pa̱ oIsa̱rila ga chit ga ɓut ka̱ aMizpa. Te oIsa̱rila là pa̱, <<Là á yi, nza̱ asa̱l iya̱m inga va̱ ta̱ fa yà?>> ");
INSERT INTO yer_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","Te unəm oLawi, uɓar achar va̱ mmá gbá̱l te, á là pa̱, <<Mmami ká̱ uchar mi va̱ n nak ka̱ ashe nzhi pa kùk í ɓa aGibeya, ìtong va iji onəm aBenjamin pa̱ na í ra ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","Ka̱ ìzwam va̱ ta te, onəm oga aGibeya wong ɓa gang nzhi va̱ n ra kà̱ pa̱ na ó gbá̱l mi. Oza̱ ra ká̱ uchar mi va̱ n nak ka̱ ashe nzhi pa kùk ká̱ ìfan, kang uza̱ kú. ");
INSERT INTO yer_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","Te n yar uchar mi va̱ n nak ka̱ ashe nzhi pa kùk va̱ ta, n nyat na ngba̱ng pa̱ ɗongɗong, kang n re nre ká̱ ngba̱ng pa̱ nzəng n̂za̱ nkap mbin ka̱ ashe iya̱mkup aIsa̱rila, ka̱kul oza̱ nəm iya̱m inga ká̱ iya̱m iga ìwuswa va̱ ta̱ ka̱ ashe aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","Ǹyangmata̱ te, nkpaktak wó onəm oga aIsa̱rila, ó là iya̱m va̱ í ga nnənəm ka̱ apal nnap va̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","Te nkpaktak onəm va̱ ta wong tong wa anəm pa̱ uzəng kang oza̱ là pa̱, <<Unəm uro yà ka̱ ashe yi i ga nzhi ka̱t. I nəm ka̱t, unəm uro yà ka̱ ashe yi i le nzhi wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","Ǹnyi te, iya̱m va ta̱ iga nnənəm âGibeya. Í màng ayàk na í yàk onəm va̱ i ga i ru oza̱ ká̱ ìkum ká̱ asa̱l va̱ mí ga ká̱. ");
INSERT INTO yer_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","Í ga nyak uzəng ka̱ ashe agba̱pchi ka̱ ashe onunggwan oga nza̱ akum ìjili nggo ova i ɓa ká̱ iya̱m-nrì ôshozha. Kang aɓoshi oshozha te, i ga i nyám ntàn ônəm oga aGibeya ka̱ aBenjamin ka̱kul iya̱m ìwuswa va̱ oza̱ nəm ka̱ ashe aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","Wa nnà ta nkpaktak oIsa̱rila ɓut kang oza̱ gwang ishi wa anəm pa̱ uzəng ka̱ apal ìtong va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","Te oga akum ìjili oIsa̱rila re nre ká̱ onəm oga nre ga ashe akum ìjili aBenjamin, kang a là pa̱, <<Nza̱ apir iya̱m inga ó nəm wa nta̱ yà? ");
INSERT INTO yer_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","Ǹyangmata̱ te, ó na onunggwan onga oga aGibeya va̱ ta á yi na í gbá̱ng oza̱, na í fa ká̱ iya̱m inga va̱ ta̱ ka̱ ashe aIsa̱rila.>> Ǹnyi te, onəm aBenjamin gwong achwang kà̱ oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","Te onəm aBenjamin fa ka̱ ashe oga itong oza̱ ɓa ɓut ka̱ aGibeya pa̱ na ó lung ìkum ká̱ oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","Ka̱ nda va̱ ta te, onəm aBenjamin ɓut onəm ìkalong ìsəm pa̱ ìparəm ama̱n pa̱ kpa̱ɗing ova ká̱ oga ndokchi, oza̱ fa ka̱ ashe oga itong oza̱ ga gwang ká̱ onəm ìgba̱l pa̱ ìfangshat oga nnyi ìkum va̱ ka̱ ntəm ka̱ aGibeya á. ");
INSERT INTO yer_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","Ka̱ ashe nkpaktak oshozha va̱ ta te, onəm oyákyàk oga nnəm inok ká̱ awo apəra̱m oma yà ìgba̱l pa̱ ìfangshat. Nza̱ uzəngtəng oza̱ nggo, i màng ìpang ká̱ nchwalak i ləp akpap ishi pa̱ izəng, i yà ká̱ mpat ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","Ǹnyi te, oIsa̱rila ɓut oshozha oga ǹnyi nlung ìkum ìkalong ìgba̱l pa̱ ìneɗing ova ká̱ oga ndokchi, akum ìjili aBenjamin yà ka̱ ashishe ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","OIsa̱rila wong ga aBetel kang oza̱ ɓəp Inan pa̱, <<Nza̱ akum ìjili i ga i ru onəm aBenjamin ká̱ ìkum mpyal yà?>> Te uYawe na ama̱n pa̱, <<Akum ìjili aYahuda oma i ga mpyal.>> ");
INSERT INTO yer_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","Ìpin fa kpa̱k te, onəm oga aIsa̱rila wong kang oza̱ ga ləp apa̱k dát ká̱ aGibeya. ");
INSERT INTO yer_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","OIsa̱rila fa pa̱ na ó ru onəm aBenjamin ká̱ ìkum, kang oza̱ yar atak nsat ka̱kul nlung oza̱ datkulung ká̱ aGibeya. ");
INSERT INTO yer_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","Te onəm aBenjamin fa ka̱ ashe mbin aGibeya kang oza̱ gbá̱ng oIsa̱rila ìkalong ìsəm pa̱ ìparəm ama̱n pa̱ parəm ká̱ nda va̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","Ǹnyi te, oIsa̱rila na nkam irəng ôwan oza̱, kang oza̱ fa ga yar atak nsat oza̱ kà̱ɗi ka̱ atak va̱ oza̱ ka̱ tong kà̱, ka̱ nra ngga nggəshi á. ");
INSERT INTO yer_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","Ka̱kul oIsa̱rila ka̱ ga aBetel chit, kang oza̱ yə́ng ka̱ mpyal aYawe ga chu anung arurong. Kang oza̱ ɓəp uYawe pa̱, <<Í ga na í lung ìkum ká̱ ogənang yi onəm aBenjamin kà̱ɗi ɗò?>> Te uYawe na ama̱n ôza̱ pa̱, <<Ó ga, na ó lung oza̱.>> ");
INSERT INTO yer_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","Te oIsa̱rila fa ga pa̱ na ó lung ìkum ká̱ onəm aBenjamin kà̱ɗi. ");
INSERT INTO yer_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","Ǹnyi te, onəm aBenjamin fa ka̱ ashe mbin aGibeya kà̱ɗi ka̱kul nlung oza̱, kang oza̱ gbá̱ng oIsa̱rila ìkalong pa̱ ìgba̱pchi ama̱n pa̱ na̱nne, nkpaktak oza̱ ká̱ oga ndokchi. ");
INSERT INTO yer_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","Te nkpaktak onəm oga aIsa̱rila, oma nkpaktak oshozha, kyén ɓa ga aBetel, kang oza̱ təm ka̱ ta, i yə́ng ka̱ mpyal aYawe. Oza̱ yar ndəng gba̱l ká̱ nda va̱ ta ga chu anung arurong, kang oza̱ na iya̱m inana iga nshì, ká̱ iya̱m inana iga ntəm ikángkáng ûYawe. ");
INSERT INTO yer_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","27","Te onəm oga aIsa̱rila ɓəp uYawe kà̱ɗi. Ka̱ ashe oga nra va̱ ta te, aakwati aga nsar nnap-nlà Inan nna ka̱ yà ka̱ aBetel, ");
INSERT INTO yer_vpl VALUES ("JG20_28","008_20_28","JDG","20","28","28","kang uFinehas uya aEleyazar uka aHaruna uwa ka̱ yà unəm uga mpyal awop. Kang oIsa̱rila ɓəp uYawe pa̱, <<Í ga na i lung ogənang yi onəm aBenjamin kà̱ɗi ro, ka̱t te, i re ɗò?>> Te uYawe na ama̱n pa̱, <<Ó ga, ka̱kul ìpin te, mi ga nna oza̱ ka̱ ashe awo wó.>> ");
INSERT INTO yer_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","Te oIsa̱rila nak onəm ra anyimnyal gang aGibeya. ");
INSERT INTO yer_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","Ka̱ ìlum ìga ishatɗing te, oIsa̱rila fa ga yar atak nsat oza̱ ka̱kul nlung onəm aBenjamin ka̱ aGibeya wa nva̱ oza̱ ma nəm á. ");
INSERT INTO yer_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","Awalang va̱ onəm aBenjamin fa ìkum ka̱ oza̱ te, mmá dap oza̱ ga gbà̱ng ká̱ ìtong va̱ ta. Oza̱ ɓan ngbá̱ng oIsa̱rila wa mmatmat, kang oIsa̱rila ìsəm pa̱ ishatɗing tàk ka̱ agbagba afini ká̱ oga anang asa̱l va̱ i ga aBetel ká̱ ava̱ i ga aGibeya á. ");
INSERT INTO yer_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","Nva̱ onəm aBenjamin ka̱ nlà pa̱, <<Mmayi ka̱ nnəm igwan ka̱ apal oza̱ wa nva̱ ka̱ i nəm matmat>> te, onəm oga aIsa̱rila ka̱ nlà ǹnyi pa̱, <<Re í dap oza̱ á fa á re ashe ìtong á ga apal oga anang asa̱l.>> ");
INSERT INTO yer_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","Nkpaktak oshozha oIsa̱rila chəng re atak oza̱ kang oza̱ ga wur oga atak nsat ka̱ aBaal Tamar. Te oIsa̱rila va̱ ra anyimnyal ka̱ asa̱l ntar alum aGibeya wong fa ìkum. ");
INSERT INTO yer_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","Te oshozha oIsa̱rila oga nnyi ìkum ìkalong pa̱ ìgba̱pchi ru aGibeya ká̱ ìkum. Ìkum va̱ ta sur byet, ǹnyi te onəm aBenjamin nyi pa̱ nnap va̱ ta i ga mɓa̱ng ôza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","Te uYawe nəm igwan ka̱ apal onəm aBenjamin ka̱ mpyal oIsa̱rila, kang ka̱ ìlum va̱ ta te, oIsa̱rila gbá̱ng onəm aBenjamin ìkalong ìsəm pa̱ ìparəm ama̱n pa̱ tukun ká̱ ìgba̱l pa̱ ìzəng, nkpaktak oza̱ onəm ova ká̱ oga ndokchi. ");
INSERT INTO yer_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","Nna chit te, onəm aBenjamin nyi pa̱ mmá ri wó chit ká̱ ìkum. Ǹyangmata̱ te, oIsa̱rila ka̱ chəng ka̱ mpyal onəm aBenjamin ka̱kul oza̱ da̱r nkam ka̱ oshozha va ka̱ ra anyimnyal dat ká̱ aGibeya á. ");
INSERT INTO yer_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","Ovəngva̱ ka̱ ra anyimnyal fa pa̱ kəlak táng kang a zàl ka̱ ashe ìtong aGibeya, te oza̱ gbá̱ng nkpaktak onəm va̱ ka̱ ashe ìtong va̱ ta ká̱ ndokchi. ");
INSERT INTO yer_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","Oza̱ ka̱ nak chit pa̱ nggù i wong pa̱ makmak ka̱ ashe ìtong va̱ ta wa ìlulu, nna i sat iya̱m iga ǹnyám ìpir nnap ka̱ ishimshe oIsa̱rila ká̱ ovəngva̱ ra anyimnyal. ");
INSERT INTO yer_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","OIsa̱rila i ya nggù va̱ ta te, oza̱ i ga̱ɓa̱n, kang i ru onəm aBenjamin ká̱ ìkum. Onəm aBenjamin ka̱ ɓan ngbá̱ng oIsa̱rila chit ga chu onəm ìsəm pa̱ ishatɗing, kang oza̱ i là pa̱, <<Mmayi ka̱ nnəm igwan ká̱ oza̱, wa ngga nggəshi va.>> ");
INSERT INTO yer_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","Ǹnyi te, awalang va̱ nggù ɓan ǹnənggət chit ka̱ ashe ìtong va̱ ta te, onəm aBenjamin ga̱ɓa̱n, kang oza̱ ya nggù i wong ka̱ ashe nkpaktak ìtong oza̱ i ga apaɓur. ");
INSERT INTO yer_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","Te onəm oga aIsa̱rila ga̱ɓa̱n ru oza̱ ká̱ ìkum, kang onəm aBenjamin tán ká̱ ayər ka̱kul oza̱ nyi ɗak pa̱ nɗaktak ya oza̱ chit. ");
INSERT INTO yer_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","Te oza̱ ga̱ɓa̱n chəng ka̱ mpyal oIsa̱rila, oza̱ wòl asa̱l nzam mmaləng, ǹnyi te, oza̱ bar ka̱ atak ìkum va̱ ta ka̱t. Kang oIsa̱rila va̱ fa ka̱ ashe oga itong gbá̱ng oza̱ ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","OIsa̱rila gang onəm aBenjamin, oza̱ ɓak oza̱ kang oza̱ ga kpán oza̱ ka̱ asa̱l nfa alum aGibeya. ");
INSERT INTO yer_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","Onəm aBenjamin ìkalong pa̱ ìgba̱pchi ama̱n pa̱ na̱nne kú. Nkpaktak oza̱ te, onəm okamkam. ");
INSERT INTO yer_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","Aɓo ovəngva̱ re te, ga̱ɓa̱n, chəng táng ashe nzam mmaləng ga asa̱l ìpang aRimmon, ǹnyi te, oIsa̱rila gbá̱ng oza̱ ìkalong pa̱ ìtukun ka̱ apal oga anang asa̱l. Oza̱ pak inok mɓàk nva̱ng oza̱ ga chu aGidom, kang oza̱ gbá̱ng onəm ìkalong pa̱ ìparəm kà̱ɗi. ");
INSERT INTO yer_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","Ká̱ nda va̱ ta te, mmá gbá̱ng onəm aBenjamin ìkalong ìsəm pa̱ ìparəm ama̱n pa̱ tukun, nkpaktak oza̱ oshozha okamkam ova ká̱ oga ndokchi. ");
INSERT INTO yer_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","Ǹnyi te, onəm ìgba̱l pa̱ ìkpa̱ɗing ga̱ɓa̱n chəng táng nzam mmaləng ga ìpang aRimmon. Oza̱ təm ka̱ ta apye pa̱ neɗing. ");
INSERT INTO yer_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","Te oIsa̱rila le ga mbin aBenjamin, kang oza̱ gbá̱ng nza̱ iya̱m iga irirì nggo ka̱ ashe oga itong va̱ ta ká̱ ndokchi, nzəng ká̱ iya̱mkang, ká̱ nza̱ iya̱m nggo va̱ oza̱ ya á. Kang oza̱ pwak nkpaktak oga itong va̱ oza̱ táng ashishe. ");
INSERT INTO yer_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","Onəm oga aIsa̱rila ka̱ sóng anung chit ka̱ aMizpa pa̱, <<Unəm uro yà ka̱ ashe yi i na ivang ká̱ uyen wò uchar ûnəm uga aBenjamin ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","Te onəm va̱ ta ga aBetel, kang oza̱ təm ka̱ ta ka̱ mpyal Inan ga chu arurong, kang oza̱ gham achu ká̱ ayə́ng pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","Oza̱ là pa̱, <<ÁYawe, Inan iga aIsa̱rila, iza̱ nak kang iya̱m va̱ ta̱ fa ka̱ ashe aIsa̱rila yà? Ka̱kul iza̱ kang mí lang akum ìjili pa̱ izəng ka̱ ashe aIsa̱rila ka̱ nda va̱ ta̱ yà?>> ");
INSERT INTO yer_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","Ìpin fa kpa̱k ká̱ ìɓotak te, oIsa̱rila me atak nshì iya̱m awop, kang oza̱ na oga iya̱m inana iga nshì ká̱ oga iya̱m inana iga ntəm ikángkáng. ");
INSERT INTO yer_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","Te oIsa̱rila ɓəp pa̱, <<Nza̱ akum ìjili ka̱ ashe nkpaktak aIsa̱rila ga nzəng ká̱ yi ka̱ aMizpa ka̱ awalang va̱ í ɓut ka̱ mpyal aYawe ka̱t yà?>> Ka̱kul oza̱ ka̱ yar nsóng anung chit pa̱, unəm va pa̱ káp yang ká̱ mɓa mɓut ka̱ mpyal aYawe te, nkpak mí gbá̱l na. ");
INSERT INTO yer_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","OIsa̱rila dər akum ìjili aBenjamin ugənang oza̱ ká̱ nrwa ìgwak, kang oza̱ là pa̱, <<Mmá gbá̱l akum ìjili iro chit pa̱ izəng le ka̱ ashe aIsa̱rila ká̱ nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","Í nəm sang kang í ya ochar ôvəngva̱ re ta̱ yà? Ka̱kul ka̱ í sóng anung chit ká̱ uYawe pa̱ í yà ká̱ nna ovanchar yi ôza̱ ka̱ ìvang ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","Te oza̱ ɓəp pa̱, <<Nza̱ akum ìjili ka̱ ashe aIsa̱rila yang ga mɓut yi ka̱ mpyal aYawe ka̱ aMizpa ka̱t yà?>> Te oza̱ nyi pa̱ unəm uro yà ɓa mɓut nggatək va̱ ta ka̱ ashe akum aJabesh-Gileyat ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","Ka̱kul awalang va̱ oza̱ kung onəm pa̱ kpaktak te, oza̱ ya unəm uga aJabesh-Gileyat uro ka̱ ta pa̱ uzəng ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","Te nggatək va̱ ta re nre ká̱ onunggwan oga nyi nlung ìkum ìkalong pa̱ ìgba̱pchi ama̱n pa̱ parəm pa̱ oza̱ á ga, na oza̱ á gbá̱ng nkpaktak onəm oga ntəm ka̱ aJabesh-Gileyat ká̱ ndokchi, nzəng ká̱ ochar, ká̱ ovan kpa. ");
INSERT INTO yer_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","Oza̱ là ôza pa̱, <<Iya̱m va ta̱ ó ga nnənəm, ó gba̱l nkpaktak onunggwan, ká̱ nza̱ uchar nggo va̱ nyi ununggwan chit á.>> ");
INSERT INTO yer_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","Ka̱ ashe onəm oga ntəm ka̱ aJabesh-Gileyat te, oza̱ ya ovanɓyen ìgba̱l pa̱ ìneɗing ova oma nyi onunggwan chit ka̱t, kang oza̱ ɓa ká̱ oza̱ ka̱ apa̱k ka̱ aShilo ka̱ ashe mbin ngga aKanana. ");
INSERT INTO yer_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","Te nkpaktak nggatək oIsa̱rila re nre ngga ntəm ikángkáng âɓo onəm aBenjamin va̱ ka̱ ntəm ka̱ ashe ìpang aRimmon pa̱, ìkum kur chit. ");
INSERT INTO yer_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","Te onəm aBenjamin le nzhi ka̱ awalang va̱ ta, kang mmá na ovanɓyen oga aJabesh-Gileyat oga ìgba̱l pa̱ ìneɗing va̱ mmá re ká̱ irirì ôza̱ tong ochar oza̱. Ǹnyi te, ovanɓyen va̱ ta gàng oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","Te aɗor ga onəm va̱ ta ka̱ apal onəm aBenjamin, ka̱kul uYawe re mɓol nro chit ka̱ ashe oga akum ìjili aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","Te onəmgbak oga mɓut ɓəp pa̱, <<Mmá zhì nkpaktak ochar va̱ ka̱ ashe akum ìjili aBenjamin chit. Í nəm sang kang í ya ochar âɓo ovəngva̱ re yà? ");
INSERT INTO yer_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","Nkpak pa̱ mmá yà iya̱mkup âɓo akum ìjili aBenjamin va̱ bar, na kang mmá dəkən akum ìjili iro ka̱ ashe aIsa̱rila ka̱t ");
INSERT INTO yer_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","Káp ka̱ nna te, í yà ká̱ nna ovanchar yi ôza̱ ka̱ ìvang ka̱t, ka̱kul mmayi oIsa̱rila ka̱ í sóng anung chit pa̱, <Unəm va̱ pa̱ káp á na uyen wò ìvang ônəm aBenjamin te, uza̱ sat unəm uvyápvyàp chit.> ");
INSERT INTO yer_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","Ǹnyi te, ó dər, nnəm nchàng izər aYawe, va̱ mí nəm nza̱ ìzun nggo ka̱ aShilo te, á dat chit. Ìtong aShilo ra ka̱ asa̱l mpal aBetel, ka̱ asa̱l nfa alum anang asa̱l va̱ i wong ka̱ aBetel kang i ga aShekem, ka̱ asa̱l nkwandal aLebona á.>> ");
INSERT INTO yer_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","Te oza̱ là ônəm aBenjamin pa̱, <<Ó ga na ó ra anyimnyal ka̱ ashe oga ìram ìba̱ngba̱ng, ");
INSERT INTO yer_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","na ó lok atak. Awalang va̱ ovanɓyen oga aShilo i fa ngba̱p nza̱m te, ó gha̱n ó fa ka̱ ashe oga iram ìba̱ngba̱ng, na udanggo ka̱ ashe wó á kpán uyenchar pa̱ uzəng ka̱ ashe ovanɓyen va̱ ta ká̱ ìfan á ga ká̱, na á yà uchəchar. Te ó le mbin aBenjamin iya̱m wó. ");
INSERT INTO yer_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","Kang awalang va̱ opo oza̱ ká̱ ogənang oza̱ i ɓa ká̱ nnap-nlà ka̱ atak yi te, í là ôza̱ pa̱, <Í chal wó chal, ó ka̱mshi yi ka̱ atak nre oza̱ pa̱ á ka̱m ovanchar wó, ka̱kul í ya ochar ôza̱ ka̱ awalang nlung ìlum ka̱t. Ó yà ká̱ mpat ngga mɓəkchi nsóng anung wó ka̱t, ka̱kul mmawó na ó na ovan wó ôza̱ ka̱ ìvang ka̱t.> >> ");
INSERT INTO yer_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","Te onəm aBenjamin nəm wa nva mmá là ôza̱ á. Awalang va̱ ovanɓyen ka̱ ngba̱p nza̱m te, nza̱ uzəngtəng oza̱ nggo kpán uyenchar pa̱ uzəng ka̱ ashe ovanɓyen va̱ ta ga ká̱ pa̱ á təm uchəchar. Te oza̱ le mbin iya̱mkup oza̱, kang oza̱ me oga itong oza̱ kà̱ɗi, təm ka̱ ashishe. ");
INSERT INTO yer_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","Ka̱ awalang va̱ ta te, oIsa̱rila lyáng ka̱ ta, udanggo ga nzhi ka̱ atak akum ìjili wò ká̱ akum wò, udanggo le atak iya̱mkup wò. ");
INSERT INTO yer_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","Ka̱ ashe oga nra va̱ ta te, oIsa̱rila yà ká̱ uponzhi ka̱t, kang udanggo i nəm iya̱m va ma ká̱ na.");
INSERT INTO yer_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Ka̱ ashe nra va̱ onəm oga nnáp akwali kà̱ nnəm iponzhi te, ayang fa ka̱ ashe mbin, te unəm uga aBet-Lehem ka̱ aYahudi wong ga təm kà̱ mbin aMowap ká̱ uchar wò ká̱ ovan wò onunggwan pa̱ oparəm. ");
INSERT INTO yer_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Aɗin anəm va̱ ta pa̱ uElimelek, aɗin achəchar pa̱ uNa'omi, kang aɗin ovəvan oga oparəm pa̱ uMalon ká̱ uKiliyon. Oza̱ onəm oga aEfraita kà̱ aBet-Lehem ka̱ mbin aYahudi. Oza̱ ga təm ka̱ mbin aMowap. ");
INSERT INTO yer_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Te uElimelek uɓar aNa'omi kú, re na ká̱ ovəvan oga oparəm. ");
INSERT INTO yer_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Te oza̱ ka̱m ichar ká̱ ovan oMowap. Aɗin aro pa̱ uOrfa kang a ji á ro pa̱ uRut. Oza̱ təm ka̱ ta ìzun pa̱ igba̱pchi. ");
INSERT INTO yer_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","UMalon ká̱ uKiliyon mparəm oza̱ kú kpa, kang a re uNa'omi ovan yà ka̱t ubar yà ka̱t. ");
INSERT INTO yer_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","UNa'omi fe pa̱ uYawe song onəm wò chit, na iya̱m-nrì ôza̱ kà̱ mbin aYahudi. Te uza̱ ká̱ oká wò yar pa̱ ó re mbin aMowap. ");
INSERT INTO yer_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Oza̱ re atak va̱ uza̱ ka̱ yà kà̱ ká̱ oká wò pa̱ oparəm, oza̱ kpán asa̱l nle mbin aYahudi. ");
INSERT INTO yer_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Te uNa'omi là oká wò oga oparəm va̱ ta̱ pa̱, <<Nza̱ uzəngtəng wó nggo a le aga nzhi ka̱ atak anang wò. UYawe a nəm ikin a wó wa nva ó nəm á mi ká̱ ôbar wó va̱ kú. ");
INSERT INTO yer_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","UYawe á nak nza̱ uzəngtəng wó nggo á vang ka̱ɗi na a ya njul ka̱ nzhi aɓar wo.>> Te uza̱ bur oza̱ kang oza̱ yə́ng pa̱ gbá̱ngbá̱ng, ");
INSERT INTO yer_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","te oza̱ là á na pa̱, << Í le nzəng ká̱ ɓu ka̱ atak onəm ɓu.>> ");
INSERT INTO yer_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","UNa'omi là oza̱ pa̱, <<Ó le, ovan mi, ka̱kul iza̱ kang ó ga nzəng ká̱ mi yà? Ǹ na ǹyà ka̱ ovan onunggwan oro ka̱ ashe afu mi ova i ga nnyang oɓar wo ɗò? ");
INSERT INTO yer_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Ó le ó ga ovan mi, ka̱kul igbák mi watar nva̱ chit pa̱ n yà ká̱ uɓar. A yà pa̱ nna n yà ká̱ nnak ìgwak kà̱ uɓar ká̱ ìzwam iga nda kang n mar ovan onunggwan, ");
INSERT INTO yer_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","te ó lòk oza̱ i nyang ɗò? Ó váng ka̱t ka̱kul oza̱ ɗò? Pa ka̱t ovan mi, ó nyi pa̱ i nəm kat, ka̱kul nlak ìgwak mi mak ji nji wó byet, ka̱kul uYawe wa ɓa ka̱ mɓək anung va̱ ta̱ á mi.>> ");
INSERT INTO yer_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Te oza̱ yə́ng pa̱ gbá̱ngbá̱ng kà̱ɗi. UOrfa bur ukà wò là nlyang á na, kang uRut yang á na ka̱ izər. ");
INSERT INTO yer_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","<<Dər>> UNa'omi là uRut pa̱, <<Ukpàt ɓu le chit ga atak onal wò ká̱ ínan wò. Le, ga nvəva̱ng.>> ");
INSERT INTO yer_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","URut là á na pa̱ <<Kang wa chál mi pa̱ n le kà̱ nvang ɓu ka̱t, atak va ɓu ga te mi ga nna, kang atak va̱ ɓu təm kà̱ te, mi təm ka̱ ta nà, onəm ɓu i yà onəm mi kang Inan ɓu i yà Inan mi. ");
INSERT INTO yer_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Atak va̱ ɓu kú kà̱ te, ka̱ tá na mi kú, kang ka̱ ta na kpa mí li mi. Inan a pyát á mi a yà pa̱ ikú à kap mi ka̱ ɓu ka̱t á.>> ");
INSERT INTO yer_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Nva̱ngva̱ uNa'omi ya uRut yar chit pa̱ ò ga nzəng ká̱ wò te, uza̱ re nchál na. ");
INSERT INTO yer_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Mparəm oza̱ chen oza̱ ɓa aBet-Lehem. Nva̱ngva̱ oza̱ ɓa chu aBet-Lehem te, nkpaktak ìtong lan ka̱kul oza̱, kang ochar là pa̱, <<uNa'omi wa ta̱ ɗó?>> ");
INSERT INTO yer_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Te uza̱ là oza̱ pa̱, <<Kang ó wór mi pa̱ uNa'omi ka̱t, ó wór mi pa̱ uLakgwak, ka̱kul Uga iChumchum nak irirì mi ka̱ ashe nlak ìgwak pa̱ makmak. ");
INSERT INTO yer_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","N ga ká̱ iya̱m pa̱ kyák kang uYawe le ká̱ mi ulakchi. Sang kang ó wór mi pa̱ uNa'omi yà, nna uYawe nəm avyal ká̱ mi kang Uga iChumchum nak mi ka̱ ashe nɗaktak.>> ");
INSERT INTO yer_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Wa nna ta̱ uNa'omi le ká̱ ukà wò uRut uyen oMowap, uva fa nzəng ka̱ na ka̱ ashe mbin aMowap oza̱ ɓa aBet-Lehem kà̱ mɓan nkpám ibəshi. ");
INSERT INTO yer_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","UNa'omi uwa yà ká̱ unal aɓar wò unəm uga ndur ka̱ akum aElimelek, aɗiɗin pa̱ uBowaz. ");
INSERT INTO yer_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","URut uyen oMowap là ûNa'omi pa̱, <<Re ń ga ashe ìram ń chak nva̱ng ìbəshi kà̱ nva̱ng ànəm va kpaktak nyám ikin á mi.>> Te uza̱ ma̱n á na pa̱, <<Ga, ayen mi.>> ");
INSERT INTO yer_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Te uza̱ ga chu ashe ìram ìro kang à ɓàn nchák nva̱ng ìbəshi kà̱ nva̱ng onəm oga nkpám iya̱m. Ìram va̱ ta iji aBowaz unəm uga akum aElimelek. ");
INSERT INTO yer_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ta byet te, uBowaz vàng ka̱ aBet-Lehem kang uza̱ re anung ônəm oga nkpám iya̱m pa̱, <<UYawe á təm nzəng ká̱ wó.>> Oza̱ là á na pa̱, <<UYawe á nak nnap nnəna̱n á ɓu.>> ");
INSERT INTO yer_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Te uBowaz ɓəp ukpari wò uga ndər ishi onəm oga nkpám iya̱m pa̱, <<Uyen ɓyen à da ta̱ yà?>> ");
INSERT INTO yer_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Te unəm uga ndər ishi onəm oga nkpám iya̱m va̱ ta na á ma̱n á na pa̱, <<Uyen ɓyen uga mbin aMowap va ɓa nzəng ká̱ uNa'omi. ");
INSERT INTO yer_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Uza̱ chál pa̱ mmá ma̱n á wò na ô chák nva̱ng ìbəshi kà̱ nva̱ng onəm oga nkpám iya̱m. Uza̱ ɓàn nchə́chak ká̱ ìpin á jul kà̱ ka̱t, nna ta̱ kang uza̱ kà̱ njul pa̱ ɗa̱p.>> ");
INSERT INTO yer_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Te uBowaz là ûRut pa̱, <<Fe ayen mi, kang wa re ashe ìram iva̱ ta̱ wa ga nchák nva̱ng ìbəshi ka̱ ashe ìram ikak ka̱t, chen nzəng ká̱ ovan ɓyen oga nnəm inok á mi. ");
INSERT INTO yer_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ìwu ɓu á yà ka̱ apal ìram va oza̱ kà̱ nkpə́kpam, kang ɓù chen kà̱ nva̱ng oza̱. N ɗa̱t ovan nza̱m va̱ta chit pa̱ kang oza̱ á dok ɓu ka̱t, kang ndəng á gba̱l ɓu te, ga ɓù tók ka̱ ashe oga aba̱ng va̱ ovan nza̱m ɗyang kang ɓù wá.>> ");
INSERT INTO yer_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Te uRut ɓəram kà̱ mbin kwangtal ishi là á na pa̱, <<Sang kang n ya nnap nnəna̱n ka̱ atak ɓu, u nak ishi ká̱ mi, nnà mmami uɗyanəm yà?>> ");
INSERT INTO yer_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Te uBowaz na ama̱n á na pa̱, <<Mmá shàl á mi chit, nkpaktak iya̱m va̱ u nəm ûkà ɓu nva̱ngva̱ uɓar ɓu kú, ká̱ nva̱ u re upon ɓu ká̱ unang ɓu ká̱ mbin onəm ɓu kang u ɓa atak onəm va̱ u nyi chit ká̱ nlám ka̱t. ");
INSERT INTO yer_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","UYawe á mwa iya̱m va̱ u nəm. Re amwa ɓu á yà pa̱ súr ka̱ atak aYawe Inan oga aIsa̱rila, uva̱ u ɓa nram mbwam ka̱ ashe abasəmbasəm.>> ");
INSERT INTO yer_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Te uRut là pa̱, <<Re ń ga mpyal ká̱ ǹya nnap nnəna̱n ka̱ atak ɓu anəm uga nzhi mi, ka̱kul u sak mi chit kang u là nnap îgwak àzwal ɓu káp ká̱ ǹva̱ pa̱ n yà uzəngtəng ka̱ ashe onəm oga nnəm inok á ɓu ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Awalang aga nrí iya̱m-nrì nəm te, uBowaz là ûRut pa̱, <<Ɓa ta̱ na ú ka̱m iya̱m-nrì, kang ɓù zwap ka̱ ashe ndəng ìba̱ngba̱ng nsámsám.>> Te uza̱ təm dat ká̱ onəm oga nkpám iya̱m kang uBowaz yichi nzəngkəng á na. Uza̱ ri afu yə́l na aɓuɓo le. ");
INSERT INTO yer_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Nva̱ngva̱ uRut wóng pa̱ ô chák nva̱ng ibəshi te, uBowaz na nnap-nlà ônəm wò pa̱, <<Re uza̱ á chák ka̱ atak va̱ mma nak isarsar kà̱ kpa, kang ó na ìwuswa á na ka̱t. ");
INSERT INTO yer_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ó zə̀p isanglang ka̱ ashe isarsar kpa ó re na uza̱ á wur, kang ó ra̱n ká̱ na ka̱t. ");
INSERT INTO yer_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Wa nnà ta uza̱ chák nva̱ng ibəshi á ga chu anung arurong, kang uza̱ pək iya̱m va̱ uza̱ chák te, ibəshi chu ikpáng pa̱ iparəm. ");
INSERT INTO yer_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Uza̱ yar tar ashe ìtong ká̱, kang uza̱ nyám ûkà wò iya̱m va̱ uza̱ chák. Uza̱ fa ká̱ aɓo iya̱m-nrì va̱ uza̱ ri na á na. ");
INSERT INTO yer_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ukə̀ka ɓəp na pa̱, u chák nva̱ng ibəshi va̱ ka̱ chè n̂da yà? U nəm inok ka̱ chè yà? Nnap nnəna̱n á təm nji ànəm va̱ nak ishi ká̱ ɓu.>> Te uRut là ûkà wò unəm va̱ uza̱ nəm inok ka̱ na nda. Uza̱ là pa̱, <<Aɗiɗin pa̱ uBowaz.>> ");
INSERT INTO yer_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","UNa'omi là ûRut pa̱, <<UYawe va̱ kap ká̱ nnəm ikin ônəm oga irirì ká̱ onəm okúkú ka̱t, te á nak nnap nnəna̱n á na.>> Kang uNa'omi ga mpyal ká̱ nlà á na pa̱, <<Unəm va̱ ta unàl yi uga ndatkulung, uza̱ uzəngtəng ka̱ ashe onəm yi oga akup.>> ");
INSERT INTO yer_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Te uRut uyen oMowap á là pa̱, <<Nnà ká̱ nkukwa ka̱t, uza̱ là á mi kpa pa̱, <Chen ká̱ onəm oga inok mi oza̱ á gba̱l ká̱ nkpám nkpaktak iya̱m mi kang.> >> ");
INSERT INTO yer_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","UNa'omi là ûRut ukà wò pa̱, <<Aɓiɓyen, á yen mi, pa̱ ú chen nzəng ká̱ ovan ɓyen oga nnəm inunok, le kang mmá a zul ɓu ka̱ ashe ìram ikak ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Wa nnà ta uza̱ ɓa dát ká̱ ovan ɓyen oga nnəm inok ûBowaz, kà̱ nəm inok nchák nva̱ng iya̱m nkpam, ìbəshi ká̱ ìzangzəng kùr kang uza̱ təm ká̱ ukà wò. ");
INSERT INTO yer_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ka̱ alum sur ro te, uNa'omi ukà aRut là á na pa̱, <<Ayen mi, nkpak pa̱ ń nram uɓar á ɓu na u ya nzhi njul, kang ɓu fe nchang kà̱. ");
INSERT INTO yer_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ǹyangmata̱ te, uBowaz unàl yi va̱ u nəm inok ká̱ ochar oga nnəm inok á na. Dər, uza̱ kà̱ ngwol ibəshi ka̱ atak mpək iya̱m ká̱ ìzwam va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Wor izər, sháng nturari, na u mwak iya̱m ìsham ɓu iɓyenɓyen, te ga atak mpək iya̱m va̱ ta. Kang wa ma̱n uza̱ á nyi mɓa ɓu ka̱t, ya uza̱ á gba̱l ká̱ nrí iya̱m-nrì ká̱ ngwá ndəng kang. ");
INSERT INTO yer_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Nva̱ngva̱ uza̱ a ra te, wa nak ishi ka̱ atak va̱ uza̱ i ra kà̱. Te ga ná ú gha̱l iya̱m iga ndàng izəzər ka̱ asa̱l ashəshar wa ra. Uza̱ i là iya̱m va̱ á ɓu pa̱ ú nəm.>> ");
INSERT INTO yer_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Te uRut là ûkà wò pa̱, <<Nkpaktak iya̱m va̱ u là á mi te, mi nənəm.>> ");
INSERT INTO yer_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Te uza̱ ga atak mpək iya̱m va̱ kang uza̱ nəm nkpaktak iya̱m wa nva ukəka là á na pa̱ uza̱ á nəm. ");
INSERT INTO yer_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Ka̱ nva̱ngva̱ uBowaz ri iya̱m uza̱ wá ndəng kang ìgugwak ra chit te, uza̱ ga ra ka̱ nkùr aɓák, te uRut ɓa gha̱l atak ashəshar te ra. ");
INSERT INTO yer_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ká̱ ishimshe ìzwam te, uBowaz ga̱m kang à ga̱ɓa̱n te, uza̱ ya uchar ra kà̱ ngba̱k ashar wò. ");
INSERT INTO yer_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Uza̱ ɓəp pa̱, <<Mmaɓu uda yà?>> Te uza̱ ma̱n pa̱, <<Mmami uRut, uzwal ɓu. Bol iya̱m iga ndàng izər ɓu ka̱ apal azwal ɓu, ka̱kul mmaɓu ùnal aɓar mi uga akup.>> ");
INSERT INTO yer_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Uza̱ là pa̱, <<UYawe á nak nnap nnəna̱n á ɓu áyen mi. Ikin iva̱ ta̱ u nyám á mi te, á ji iga nggəshi ji. U yar nva̱ng onəm oga ndur, ka̱t te oga nkun ɗò ka̱t. ");
INSERT INTO yer_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ǹyangmata̱ ayen mi kang ayər á nəm ɓu ka̱t. Iya̱m va̱ uchál pa̱ kpaktak te, mi nəm á ɓu, ka̱kul onəm oga ìtong nyinyi pa̱ mmaɓu uchar ukin. ");
INSERT INTO yer_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Nnandər pa̱ mmami ùnal uga akup, ká̱ nnà te ùnal uga akup va̱ datkulung ji mi ji uwa yà. ");
INSERT INTO yer_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ra atak atàn, ìpin kang uza̱ ama̱n nka̱m akup ká̱ ɓu te, ya a ɓyen, uza̱ i ka̱m ɓu. Kang a yà pa̱ uza̱ ama̱n pa̱ ô ka̱m akup ká̱ ɓu ka̱t te, n sóng anung ká̱ uYawe mi ka̱m akup ká̱ ɓu. Ra atak atàn kang.>> ");
INSERT INTO yer_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Te uza̱ ra kà̱ ngba̱k ashəshar atak ka̱ ntàn pa̱ kpəla̱m te uza̱ mor wóng kang unəm ì nyi uwanwò. UBowaz là pa̱ <<Kang unəm uro á nyi pa̱ uchar ɓa ka̱ atak mpək iya̱m ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","UBowaz là á na pa̱, <<Fən ashawulu ɓu nàr ka̱ mbin.>> Uza̱ nàr te uBowaz ma ibəshi á na ikpáng iga mma iya̱m pa̱ ìkpa̱ɗing te uza̱ yar na ká̱. Uza̱ tar ashe ìtong. ");
INSERT INTO yer_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","URut ɓa atak akà wò te, uza̱ ɓəp na pa̱, <<U ya sang yà ayen mi?>> Te uza̱ shal iya̱m va̱ unəm va̱ ta nəm á na pa̱ kpaktak. ");
INSERT INTO yer_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Uza̱ là pa̱, <<Uza̱ wa na ibəshi va̱ ta̱ á mi ìkpáng iga mma iya̱m pa̱ ìkpa̱ɗing, uza̱ là kà̱ pa̱, <Kang wa le ká̱ awo alakchi ka̱ atak akà ɓu ka̱t.> >> ");
INSERT INTO yer_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","UNa'omi là pa̱, <<Lòk ayen mi, kang ɓù dər asa̱l awu nnap va̱ ta̱, ka̱kul ìgwak ànəm va̱ ta i ya ká̱ nra ka̱t, uza̱ i gba̱l nnap va̱ ta̱ nda va ta̱.>> ");
INSERT INTO yer_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","UBowaz fa ga təm ka̱ anung asa̱l ìtong. Te uza̱ ya unəm uga nka̱m akup va̱ uza̱ ka̱ là kà̱ nwatar. Te uBowaz wór na pa̱, <<Ɓa ta̱ anəm va̱ ta̱, təm ká̱ ìjili.>> Te unəm va̱ ta le ga təm. ");
INSERT INTO yer_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Te uza̱ wór onəmgbak oga ìtong pa̱ ogba̱pchi là óza̱ pa̱, <<Ó təm ka̱ ta̱.>> Te oza̱ təm ká̱ ìjili. ");
INSERT INTO yer_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Uza̱ là unəm uga nka̱m akup va̱ ta pa̱, <<UNa'omi va̱ le kà̱ mbin oMowap te, uza̱ ɗom nyap ká̱ ìram agənang yi uElimelek. ");
INSERT INTO yer_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Te n ya màl pa̱ n nyám ka̱ á ɓu. Yap kà̱ mpyal onəm va̱ təm ta̱, ká̱ mpyal onəmgbak onəm mi. A yà pa̱ ɓu yəyap te, yap, kang a yà pa̱ ɓu le ɓu yap ka̱t te, là á mi na n nyi, ka̱kul unəm uga yəyap ya ka̱t mmaɓu na, te mmami kà̱ nva̱ng ɓu.>> Uza̱ là pa̱, <<Mi ka̱m ishishi ka̱m.>> ");
INSERT INTO yer_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Na chit te uBowaz là pa̱, <<Awalang va̱ ɓu yáp iram va̱ ta ká̱ ka̱ awo aNa'omi te, wa ka̱m ka̱ uRut kpa, uyen oMowap uchar ànəm va̱ kú, ka̱kul na aɗiɗin á təm ka̱ apal iya̱m akúkup.>> ");
INSERT INTO yer_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Unəm uga nka̱m akup uga ndatkulung va̱ ta là pa̱, <<Mi yà ká̱ nka̱m ishishi ka̱t, le kang ma vyap nnap iya̱m akup mi ka̱t. Ka̱m iya̱m akup mi va̱ ta á təm iji ɓu, mi ka̱m ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Nnap nnəm va ta̱ ka̱ yà ka̱ ashe oIsa̱rila ka̱ apal nnap nnəm ngga nka̱mshi ká̱ mpəl iya̱m akum, nna pa̱ unəm i tur akwap wo i na ûwanwò. Nna ta̱ mí nəm ka̱ aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Nva̱ ùnal uga nka̱m akup uga ndatkulung va̱ ta là uBowaz pa̱, <<Ka̱m a təm iji ɓu te,>> uza̱ tur akwap wò uza̱ na ûBowaz. ");
INSERT INTO yer_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Te uBowaz là ônəm gbák ká̱ nkpaktak onəm va̱ ta pa̱, <<N̂da va̱ ta̱ kà̱ iwu wó n yap nkpaktak iya̱m aElimelek chit iva̱ iji aKiliyon ká̱ uMalon ka̱ awó aNa'omi. ");
INSERT INTO yer_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ká̱ uRut kpa, uchar aMalon ukpələng, uyen oMowap á yà uchar mi, na n re nva̱ng unəm kukú va̱ ká̱ iya̱m kukup pa̱ kpaktak. Ka̱kul kang aɗiɗin á lar ka̱ ashe ogənanggənang ká̱ ìtutong ka̱t. Mmawo na onəm oga nyar anung mi nda ta̱.>> ");
INSERT INTO yer_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Nkpaktak onəm va̱ ka̱ anung asa̱l ìtong ká̱ onəmgbak là pa̱, <<Mmayi na í yar anung ɓu kà̱ nnap va̱ ta̱. UYawe á nak uchar va̱ kà̱ mɓa ashe nzhi ɓu á yà wa aRahila ká̱ uLaitu, omà pa̱ oparəm me nzhi àIsa̱rila á. Re ú yà unəm uga ìdur ka̱ aEfraita, aɗin ɓu á dam ka̱ ashe aBet-Lehem. ");
INSERT INTO yer_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Re nzhi ɓu á yà wa nzhi aPerez, uva̱ uTamar mar ûYahuda, ka̱ atak apir va̱ uYawe i na ɓu ka̱ atak achar uɓwakan va̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Te uBowaz ka̱m uRut yà uchəchar. Nva̱ngva̱ uza̱ ga atak nra ka̱ na te, uYawe nak uza̱ yar anyám, kang à mar uyen ununggwan. ");
INSERT INTO yer_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Te ochar là ûNa'omi pa̱, <<Ashep á təm a ji aYawe, uva̱ re u lang unàl uga nka̱m akup uga ndatkulung ka̱t. Re aɗin áyen va̱ ta á dam ka̱ ashe aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Uza̱ i yà uyen uga nna nra ìgwak á ɓu ka̱ ashe igbák ɓu, ka̱kul amar á kà ɓu va̱ ma̱n ɓu byet. Ka̱ atak ɓu te, uza̱ ji ovan onunggwan ji pa̱ ofangshat.>> ");
INSERT INTO yer_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Te uNa'omi yar uyen va̱ ta fəkchi uza̱ yà unəm uga nkpán na. ");
INSERT INTO yer_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ochar va̱ ka̱ yà nzəng ka̱ aNa'omi là pa̱, <<Mma mar ukà ununggwan ûNa'omi chit.>> Oza̱ sòk adin á na pa̱ uObet. Uwa upon aJese, upon aDawuda. ");
INSERT INTO yer_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Òma ta̱ akum aPerez, UPerez mar uHezron, ");
INSERT INTO yer_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","uHezron mar uRam, uRam mar uAminadap, ");
INSERT INTO yer_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","uAminadap mar uNashon, uNashon mar uSalmon, ");
INSERT INTO yer_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","uSalmon mar uBowaz, uBowaz mar uObet, ");
INSERT INTO yer_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","uObet mar uJesi, kang uJesi mar uDawuda.");
INSERT INTO yer_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Unəm uro uwa ka̱ yà ka̱ aRama kà̱ mbin aZufim ka̱ ashe mbin ngga aɗuktum aEfrayim. Aɗiɗin pa̱ uElkana uya aJeroham, uya aElihu, uya àTohu, uya àZup ka̱ akum ìjili aEfrayim. ");
INSERT INTO yer_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Uza̱ ká̱ ochar pa̱ oparəm, aɗin oza̱ pa̱ uHana ká̱ uPənina. UPənina ká̱ ovan, uHana ǹnyi te á yà ká̱ ovan ka̱t. ");
INSERT INTO yer_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Nza̱ ìzun nggo te, uElkana i wong kà̱ ìtong wò i ga aShilo, ka̱kul pa̱ na ô nəm awop, kang ô na nləfər ûYawe uGa ngGatək. UEli ká̱ ovan wò oga oparəm uHopəni ká̱ uFinehas òma onəm oga mpyal awop áYawe ka̱ awalang va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Nra va̱ uElkana i yichi nləfər wò te, uza̱ i na ngba̱k ìzhe ìro ûchar wò uPənina, kang ovan aPənina onunggwan ká̱ ochar uza̱ i na ngba̱k pa̱ nzəng udanggo. ");
INSERT INTO yer_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Ǹnyi te, uza̱ i na ûHana ndan pa̱ mparəm, ka̱kul pa̱ uza̱ ma̱n na ma̱n, káp ka̱ nva̱ pa̱ uYawe gún atak amar kà̱ na a. ");
INSERT INTO yer_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Ukpəkpat i wong te, i náp avyal á na, na ô lak ìgwak á na ka̱kul pa̱ uYawe gún atak amar kà̱ na. ");
INSERT INTO yer_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Uza̱ i náp avyal á na nza̱ ìzun nggo. Awalang va káp uHana á ga awop kà̱ nzhi aYawe te, uPənina i náp avyal a na, á nak na uza̱ pak inok ayə́ng kang à yang ká̱ nri iya̱m. ");
INSERT INTO yer_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Te uɓəɓar uElkana i ɓəp na pa̱, <<ÁHana, ɓu yə́ng iza̱ yà? Iza̱ nak kang u ri iya̱m-nrì ka̱t yà? Iza̱ lak ìgwak a ɓu yà? Mmami te, n ji ovan onunggwan a ɓu pa̱ ogba̱pchi ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Ka̱ nda nro te, nva̱ngva̱ oza̱ gba̱l ká̱ nri ká̱ ngwa chit ka̱ aShilo, te uHana wong ka̱ ashe nlak ìgwak i far afar ká̱ ayə́ng ûYawe. Ka̱ awalang va̱ ta te, uEli unəm uga mpyal awop uwa ka̱ yà kà̱ ntəm ka̱ apal itok wò ka̱ izər ndar ngga anung nzhi aYawe. ");
INSERT INTO yer_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","UHana ka̱ ashe nlak ìgwak pa̱ gənggəng, nva̱ uza̱ kà̱ nfar afar ká̱ ayə́ng ûYawe. ");
INSERT INTO yer_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Uza̱ yar nsar nnap-nlà, là pa̱, <<ÁYawe uGa ngGatək, a yà pa̱ u dər mɓək anung ázwal ɓu, kang u rəng ká̱ mi, u kong ká̱ uzwal ɓu ka̱t, wa na uyen ununggwan á mi, te mi le ká̱ na á ɓu. Uza̱ i yà uji ɓu i ga i chu nkur irirìriri, kang ìkpal ishi i yà ká̱ ndok ishishi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Nva̱ uza̱ ka̱ pak inok nfar afar ûYawe, te uEli wa kà̱ ndər anunung. ");
INSERT INTO yer_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","UHana wa kà̱ nfar afar ka̱ ashe ìgwak wò, kang ichəchu mí fe ka̱t, anunung na i gha̱p chwat, te uEli rəng pa̱ nchè à ra̱n na ");
INSERT INTO yer_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","kang uza̱ là á na pa̱, <<Nkpak pa̱ ú wá nchè ú ra̱n ká̱ kang ɓu ɓa ka̱ ta̱ ɗò? Re ngwa ndəng ìba̱ngba̱ng ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","UHana na ama̱n pa̱, <<Ánəm uga nzhi mi, pa ka̱t. Mmami uchar uva ka̱ ashe nlak ìgwak pa̱ gənggəng. Na ngwá ndəng ìba̱ngba̱ng ka̱t te nchè chit ka̱t, mmami kà̱ nlà ìgwak mi ûYawe. ");
INSERT INTO yer_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Kang wa yar uzwal ɓu pa̱ uchar uga nnəm mmai ka̱t. N yar awalang va̱ ta̱ pa̱, ń nəm afar ka̱kul nɗaktak ká̱ nlak ìgwak va̱ n yà ishi mi kà̱ á.>> ");
INSERT INTO yer_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Te uEli là pa̱, <<Ga ká̱ ikángkáng, re Inan iga aIsa̱rila á na iya̱m va̱ a ɓu u chal kà̱ ná.>> ");
INSERT INTO yer_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","UHana là pa̱, <<Re uzwal ɓu á ya nnap-nnəna̱n kà̱ mpyal ɓu.>> Te uza̱ ga iya̱m wò kang a ri iya̱m-nrì, kang ìgugwak lak lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Atak fa tàn ká̱ ìɓotak te, oza̱ wong kang oza̱ wop uYawe. Te oza̱ le nzhi oza̱ ka̱ aRama. UElkana ga atak nra kà̱ uchar wò uHana, kang uYawe rəng ká̱ na. ");
INSERT INTO yer_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Kang awalang ɓa chu te, uHana təm ká̱ anyám, a mar uyen ununggwan, te uza̱ sok aɗin á na pa̱, uSamuwel, uza̱ là pa̱, <<N chál uYawe ka̱kukul.>> ");
INSERT INTO yer_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Te uElkana ká̱ nkpaktak nzhi wò ga pa̱ ô yichi nləfər ngga nza̱ ìzun nggo ûYawe, na ô yə́l nsar nnap-nlà wò kpa, ");
INSERT INTO yer_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","nnyi te, uHana ga ji wò ka̱t. Uza̱ là ûɓar wò pa̱, <<UYen i re mbyal te, mi yar na kang mi ga ká̱ na kà̱ mpyal aYawe, kang uza̱ i təm ka̱ ta mbyetbyet.>> ");
INSERT INTO yer_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","UElkana là á na pa̱, <<Nəm iya̱m va u ya ma ká̱ ɓu. Lòk na uyen á re mbyal kang, re nnap-nlà aYawe á yə́l.>> Te uHana təm kà̱ nzhi dər uyen wò ga chu awalang va̱ uyen re mbyal ká̱. ");
INSERT INTO yer_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Nva̱ngva̱ uyen re mbyal te, uHana yar na, ya uyen va̱ ta uwa uɓwakan nzəng ká̱ ìna ìnunggwan iga ìzun pa̱ ishatɗing, ká̱ mma̱k kà̱ ìkpáng, ká̱ aba̱ng ndəng ìba̱ngba̱ng. Uza̱ ɓa ká̱ kà̱ nzhi aYawe ka̱ aShilo. ");
INSERT INTO yer_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Ka̱ nva̱ngva̱ oza̱ pà ìna va̱ ta chit, te oza̱ ɓa ká̱ uyen va̱ ta ûEli, ");
INSERT INTO yer_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","kang uHana là pa̱, <<Ánəm uga nzhi mi, yar mpat á mi, u rərəng ká̱ mi na ta̱ lap ɗò? Mmami na uchar va̱ ka̱ nsat ka̱ ta̱ kà̱ mpyal ɓu, kang i far afar ûYawe á. ");
INSERT INTO yer_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","UYen va ta̱ ka̱ n far ûYawe pa̱ á na mi, kang uza̱ na iya̱m va̱ á mi chit ka̱ n chal ka̱ atətak. ");
INSERT INTO yer_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Ǹyangmata̱ mmami kà̱ nná na ûYawe. Kang nkpaktak nra irirìriri, uza̱ yà ujini chit.>> Te uza̱ wop uYawe ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Kang uHana nəm afar a là pa̱, <<Mmami ká̱ nchàng ìgwak ka̱kul aYawe. UYawe nak ìkam yà ka̱ mi chit. M ma̱ka̱n okpa ìkum mi chit. Mmami ka̱ nchang ìgwak ka̱kul pa̱ u ka̱m ishi mi. ");
INSERT INTO yer_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Unəm uro yà uyə́ryər wa aYawe ka̱t, uwa byet unəm uro yà lap ka̱t. ÌPang iro yà wa Inan yi ka̱t. ");
INSERT INTO yer_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Kang ó là nnap-nlà ngga nrup ká̱ ishi ka̱t te ó re anung wó á là nnap-nlà ngga nkak ishi ka̱t. Ka̱kul uYawe uwa Inan va nyi, kang uwa i màl nnap nnəm wó. ");
INSERT INTO yer_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Ijang oshozha oga ǹnyi ikum ɓun chit, ǹnyi te, onəm oga nyà ká̱ ikàm ka̱t yà onəm okamkàm chit. ");
INSERT INTO yer_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Onəm va̱ ka̱ yà ká̱ iya̱m-nrì pa̱ makmak matmat te, ǹyangmata̱ oza̱ kà̱ nnəm inok ka̱kul nram iya̱m-nrì, ǹnyi te, onəm va̱ ka̱ yà ká̱ ayang te, afu yə́l oza̱ chit. Uchar va̱ ka̱ səsat te, á mar ovan chit pa̱ ofangshat, ǹnyi te, uchar va̱ ka̱ mar ovan pa̱ kyák te, á təm ulakchi chit. ");
INSERT INTO yer_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","UYawe uwa ɓa ká̱ ikú kang uwa na irirì. Uwa ga ká̱ onəm ka̱ ashe awap kang uwa à wong ká̱ oza̱ kpa. ");
INSERT INTO yer_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","UYawe uwa na nkun oro kang uwa na idur oro. Uza̱ yen ká̱ oro kang à rup ká̱ oro. ");
INSERT INTO yer_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Uza̱ wong ká̱ oga nkun ka̱ ashe mɓwang, kang uza̱ wong ká̱ oga nlang ka̱ apal ìsal, uza̱ nak oza̱ təm nzəng ká̱ onəm oga atak nsat, kang á nak atak ntəm nchumchum yà iya̱mkup oza̱. Oga mbang apambin nji aYawe. Ka̱ apal oza̱ na uza̱ pak apambin. ");
INSERT INTO yer_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Uza̱ i kpak ashar onəm wò oga nnandər, ǹnyi te, onəm oɓá̱ngɓa̱ng i zhì ka̱ ashe atak kpa̱rkpa̱r, ka̱ atak ìkàm na unəm i ya igwan ka̱t. ");
INSERT INTO yer_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Onəm va̱ yang uYawe te, oza̱ i zhì. UGa iChumchum i nə́m ìgbarman ka̱ apaɓur, uYawe i náp akwali n̂kpaktak apambin. Uza̱ i na ìkam ûponzhi wò, kang uza̱ i rup ká̱ agbəshi anəm ugargar wò.>> ");
INSERT INTO yer_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Te uElkana le nzhi ka̱ aRama, ǹnyi te, uSamuwel təm nnəm inok ûYawe ka̱ ashe awo aEli, unəm uga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Ovan aEli onunggwan onga, oza̱ yà ká̱ ayər ûYawe ka̱t. ");
INSERT INTO yer_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Asa̱l va ta̱ na ka̱ yà nnap nnəm onəm oga mpyal awop pa̱, awalang va kap unəm uro i yichi nləfər te, ukpari anəm uga mpyal awop i ɓa ká̱ ìga̱pchi iga ifang pa̱ ishatɗing ká̱ awo wò, ya ìzhe ya kà̱ nfə́l ka̱ apər. ");
INSERT INTO yer_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Uza̱ i kyer ìga̱pchi iga ifang va̱ ta ka̱ ashe ngbət kang iya̱m va ìga̱pchi fa ká̱ te, i yà iji ánəm uga mpyal awop. Asa̱l va ta̱ oza̱ nəm n̂gkpaktak oIsa̱rila va̱ ɓa aShilo. ");
INSERT INTO yer_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Ǹnyi te, kang mí shì mpip te, ukpari anəm uga mpyal awop i ɓa i là ûnəm va̱ kà̱ ǹyichi nləfər pa̱, <<Ná ìzhe ìro na mmá wàng ûnəm uga mpyal awop, uza̱ i yà ká̱ nka̱m ìpəkpək ka̱ atak ɓu ka̱t, ya ìlulong chwat.>> ");
INSERT INTO yer_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","A yà pa̱ unəm uga ǹyichi nləfər a là á na pa̱, <<Re mmá shì mpip mpyal kang ɓu kpa̱k wa nva u ɗom,>> te ukpari anəm uga mpyal awop i na ama̱n pa̱, <<O'o, na mi ǹyangmata̱, kang a yà pa ka̱t, te mi kpa̱k ká̱ ìfan.>> ");
INSERT INTO yer_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Nnap-mɓá̱ngɓa̱ng ovanza̱m va̱ ta̱ mak byet kà̱ mpyal aYawe, ka̱kul oza̱ vyap oga iya̱m inana áYawe. ");
INSERT INTO yer_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Ǹnyi te, uSamuwel, uwa ka̱ nnəm inok ûYawe, uyen va̱ ta pá ìlukwan ìkwoksok iga alinin. ");
INSERT INTO yer_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Nza̱ ìzun nggo te, unənang i dán ìlukwan ìwángwang kang i ga á na ka̱ awalang va̱ uza̱ ká̱ uɓar wò i ga pa̱ ô yichi nləfər ngga nza̱ ìzun nggo. ");
INSERT INTO yer_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","UEli i pa̱r uElkana ká̱ uchar wò, i là pa̱, <<Re uYawe á na ovan oro a ɓu ka̱ atak achar va̱ ta̱ ka̱ anung ava̱ uza̱ far afar kà̱ kang uza̱ na ûYawe á.>> Te oza̱ i le i ga nzhi. ");
INSERT INTO yer_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Kang uYawe dər uHana ká̱ aɗor, uza̱ mar ovan onunggwan pa̱ oshatɗing ká̱ ovan ochar pa̱ oparəm. Ǹnyi te, uyen va̱ ta, uSamuwel rup kà̱ mpyal aYawe. ");
INSERT INTO yer_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Ǹyangmata̱ uEli gbák chit pa̱ gənggəng, kang kà̱ nfe nkpaktak iya̱m va̱ ovəvan onunggwan kà̱ nnənəm n̂kpaktak oIsa̱rila ká̱ nva̱ oza̱ i ra ká̱ ochar va̱ kà̱ nnəm inok ka̱ anung asa̱l Aghal Mɓut á. ");
INSERT INTO yer_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Te uza̱ là óza̱ pa̱, <<Iza̱ nak kang ó nəm oga nnàp wa nva̱ ta̱ yà? Ka̱kul n fe ka̱ atak nkpaktak onəm oga nnap nnəm nnga va̱ mmawó kà̱ nnənəm á. ");
INSERT INTO yer_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Ó re, óvan mi, á ɓyen ka̱t, iya̱m va̱ onəm aYawe ka̱ nləlà ka̱ apal ishi wó te, a ɓa̱ng byet. ");
INSERT INTO yer_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","A yà pa̱ unəm nəm nnap-mɓá̱ngɓa̱ng ûwan wò te, Inan i chal ka̱kukul, ǹnyi te, a yà pa̱ unəm nəm nnap-mɓá̱ngɓa̱ng ûYawe te, uda i chal ka̱kukul yà?>> Ká̱ nna te, ovəvan onunggwan yang ká̱ nkpak nnap-nlà apo oza̱, ka̱kul uYawe ka̱ nak chit pa̱ ô gbá̱ng oza̱. ");
INSERT INTO yer_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Ǹnyi te, uyen ununggwan va̱ ta, uSamuwel ga mpyal ká̱ nrup, kang nchəchər ba̱l kà̱ mpyal aYawe ká̱ onəm. ");
INSERT INTO yer_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","N̂da aro te, unəm Inan ɓa atak aEli kang à là á na pa̱, <<Iya̱m va ta̱ uYawe là, <Ka̱ n nyám ishi mi ôkəka ɓu ka̱ awalang va̱ oza̱ ka̱ yà kà̱ nnəm izwal ûponzhi uga aMasar ka̱t ɗò? ");
INSERT INTO yer_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","N yak akum akəka ɓu ka̱ ashe nkpaktak aIsa̱rila pa̱ á yà onəm oga mpyal awop mi, pa̱ á ga atak nshì iya̱m awop mi, á shì njəng nnə́ngnəng nchángchàng, á pá ìlukwan ìkwoksok ka̱ mpyal mi. Kang n na nzhi akəka ɓu nkpaktak oga nləfər va̱ oIsa̱rila yichi á. ");
INSERT INTO yer_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Iza̱ nak kang ó nəm vyákshin ká̱ nləfər ká̱ iya̱m inana va̱ n nak ka̱kul mi yà? ÁEli, iza̱ nak kang u na ichumchum ôvan ɓu na ji mi ka̱ atak nnak ishi ká̱ ishi wó, ó mwal nva̱ o ri ka̱ ashe iya̱m iyakyak va̱ onəm mi oIsa̱rila yichi á mi yà?> ");
INSERT INTO yer_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Ka̱kul nva̱ ta te, uYawe, Inan iga aIsa̱rila, là pa̱,<Ka̱ n yar nsar nnap-nlà chit pa̱ mmaɓu ká̱ nzhi ɓu ó tong onəm oga mpyal awop á mi mbyet.> Ǹnyi te, ǹyangmata̱ uYawe là pa̱, <Á yà pa lap ka̱t, ka̱kul ovəngva̱ na ichumchum á mi, te mi rup ká̱ oza̱, ǹnyi te, ovəngva̱ ɓak mi, te mi yen ká̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Dər, awalang na kà̱ mɓa ava mi gbá̱ng ovanza̱m oga nzhi ɓu ká̱ akum ìjili ɓu. Ka̱kul nva̱ ta te, mí yà ká̱ ǹya unəm uro i gbák kà̱ nzhi ɓu lap ka̱t, ");
INSERT INTO yer_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","kang ɓu ya nɗaktak. Ka̱ nna te, mi nak nnap-nnəna̱n ka̱ apal aIsa̱rila, ǹnyi te, ka̱ ashe nzhi ɓu te, mí yà ká̱ ǹya unəm uro i təm i ga i gbák ka̱t. ");
INSERT INTO yer_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Mi yà ka̱ mgba̱ng nkpaktak akum ìjili ɓu ka̱t, ǹnyi te, unəm va̱ mi re ká̱ irirì pa̱ a yà unəm uga mpyal awop á mi, te uza̱ i təm ka̱ ashe ìgwak ìlaklak ká̱ aɗor kang uza̱ i fo. Te nkpaktak oga akum ìjili ɓu ó kú ikú iga mɓək anung. ");
INSERT INTO yer_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","<< <Kang iya̱m va̱ i ya ovan ɓu onunggwan oga oparəm, uHopəni ká̱ uFinehas te, i nyám ipir nnap a ɓu, oza̱ i kú ká̱ nda nzəngtəng. ");
INSERT INTO yer_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Kang mi wong ká̱ unəm uga mpyal awop mi uga nnandər, uva i wop mi kang i nəm iya̱m va ìgwak mi ɗom á. Mi nak nnap-nnəna̱n n̂zhizhi, kang oza̱ i təm mbyet kà̱ mpyal aponzhi mi ugargar. ");
INSERT INTO yer_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Kang unəm va̱ re ká̱ irirì kà̱ nzhi ɓu te, i kuchi ka̱ mpipyal i chál mbwai ká̱ iya̱m-nrì. Uza̱ i chál pa̱, <<Mmá na inok iro á mi iga mpyal awop, na n ya iya̱m-nrì n ri.>> > >> ");
INSERT INTO yer_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Ǹnyi te, uyen ununggwan va̱ ta, uSamuwel uwa ka̱ nnəm inok ûYawe, ka̱ ashe awo aEli. Ka̱ ashe oga nra va̱ ta te, uYawe mà ma̱n nlà nnàp ká̱ onəm pe ka̱t, kang oga alár bal pe ka̱t kpa. ");
INSERT INTO yer_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","N̂da nro ká̱ izwam te, uEli va i ya atak dakdak lap ka̱t, uwa kà̱ nra ka̱ atak nra wò. ");
INSERT INTO yer_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Nna mmá gba̱l apitila Inan chit ka̱t, kang uSamuwel uwa ka̱ nra ka̱ ashe nzhi awop aYawe dát ká̱ atak va̱ mí nak akwati aga nsar nnap-nlà Inan kà̱. ");
INSERT INTO yer_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Te uYawe wór uSamuwel, kang uSamuwel ma̱n pa̱, <<Mmami na ta̱.>> ");
INSERT INTO yer_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Kang uza̱ chər ga atak aEli, uza̱ là pa̱, <<Mmami na ta̱, u wór mi.>> Ǹnyi te, uEli là á na pa̱, <<N wór ɓu ka̱t, le ga ra.>> Te uSamuwel le ga ra. ");
INSERT INTO yer_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","UYawe wór kà̱ɗi pa̱, <<ÁSamuwel>> Te uSamuwel wong kang à ga atak aEli, là pa̱, <<Mmami na ta̱, u wór mi.>> Te uEli là pa̱, <<N wór ɓu ka̱t áyen mi, le ga ra.>> ");
INSERT INTO yer_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Ǹnyi te, uSamuwel uwa ka̱ nyi uYawe chit ka̱t, ka̱kul uYawe uwa ka̱ nyám ká̱ nnap nla wò á na chit kang ka̱t. ");
INSERT INTO yer_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Kang uYawe wór uSamuwel kà̱ɗi ngga nshatɗing. Te uSamuwel wong kang a ga atak aEli là pa̱, <<Mmami na ta̱, u wór mi.>> Nna chit te, uEli nyi ɗak pa̱ uYawe i wór uyen ununggwan va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Te uEli là ûSamuwel pa̱, <<Ga, na ú ra kang a yà pa̱ uza̱ a wór ɓu kà̱ɗi te, là pa̱, <Là, áYawe, ka̱kul uzwal ɓu ka̱ nggwong achwang.> >> Te uSamuwel le kang à ga ra ka̱ atak nra wò. ");
INSERT INTO yer_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Te uYawe ɓa sat ka̱ ta i wór awór kà̱ɗi wa nva̱ uza̱ ka̱ wór pa̱, <<ÁSamuwel, áSamuwel.>> Kang uSamuwel là pa̱, <<Là, ka̱kul uzwal ɓu kà̱ nggwong achwang.>> ");
INSERT INTO yer_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Te uYawe là ûSamuwel pa̱, <<Mmami kà̱ ngga nnəm iya̱m iro ka̱ ashe aIsa̱rila iva unəm va̱ pa̱ kap i fe ka̱ achwang wò te, i ga̱m. ");
INSERT INTO yer_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","N̂da va̱ ta te, mi yə́l nkpaktak iya̱m va̱ n là ka̱ apal ishi aEli ka̱ nzhizhi, kà̱ mɓəɓan i ga i chu nkukur. ");
INSERT INTO yer_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Ka̱ nləlà á na pa̱ mi ga nnáp-akwali n̂zhizhi mbyet, ka̱kul nnap-mɓá̱ngɓa̱ng va̱ uza̱ nyi ka̱ apal ovan wò onunggwan nva̱ oza̱ vyap aɗin aYawe, ǹnyi te, uza̱ ɗa̱t oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Ka̱kul nva̱ ta te, ka̱ n sóng anung n̂zhi aEli pa̱, <Nləfər nro ka̱t te iya̱m inana iro yà iva̱ mí yichi pa̱ á yar nsur nnap-mɓá̱ngɓa̱ng n̂zhizhi ka̱t mbyet.> >> ");
INSERT INTO yer_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","USamuwel ra atak fa tan, kang uza̱ bol oga anung nzhi agga ntar nzhi aYawe. Uza̱ nəm ayər nlà ûEli iya̱m va̱ uYawe là á na ka̱ ashe alár, ");
INSERT INTO yer_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","ǹnyi te, uEli wór na kang à là pa̱, <<ÁYen mi, uSamuwel.>> Te uSamuwel ma̱n pa̱, <<Mmami na ta̱.>> ");
INSERT INTO yer_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Te uEli ɓəp na pa̱, <<Iza̱ uYawe là a ɓu yà? Kang wa bwam iya̱m iro ka̱ mi ka̱t. Re Inan á vyap ɓu, a yà pa̱ u bwam iya̱m iro kà̱ mi ka̱ ashe nkpaktak iya̱m va̱ uza̱ la á ɓu á.>> ");
INSERT INTO yer_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Te uSamuwel là iza̱ nggo á na, a bwam iya̱m iro ka̱ na ka̱t. Nna chit te uEli là pa̱, <<Uza̱ uwà uYawe, re uza̱ á nəm iya̱m va uza̱ ya ɓyen á.>> ");
INSERT INTO yer_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","USamuwel rup, kang uYawe uwa yà nzəng ká̱ na, kang nkpaktak iya̱m va̱ uSamuwel là te, Inan nak á yə́l. ");
INSERT INTO yer_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Te nkpaktak oIsa̱rila, ɓàn ka̱ aDan ka̱ asa̱l mpal ga chu aBeyersheba ka̱ asa̱l nkwandal, nyi ɗak pa̱ uSamuwel, unəm uga nka̱m nre ka̱ atak Inan uva uYawe à re. ");
INSERT INTO yer_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","UYawe pak inok nnyám ishi wò ka̱ aShilo, kang ka̱ ta uza̱ nyám ishi wò ûSamuwel ka̱ atak nnap-nlà wò. ");
INSERT INTO yer_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Kang nnap-nlà aSamuwel ɓa n̂kpaktak oIsa̱rila. Te oIsa̱rila fa ìkum kà̱ oFilisti, kang oza̱ ra apa̱k ka̱ aEbenezer, nnyi te oFilisti ra apa̱k ka̱ aAfek. ");
INSERT INTO yer_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","OFilisti gbar izər pa̱ ó lung oIsa̱rila, kang awalang va̱ ìkum sur te, oFilisti nəm igwan ká̱ oIsa̱rila, kang a gbá̱ng oza̱ ìkalong pa̱ ìneɗing ka̱ mpyal ìkum va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Awalang va̱ oshozha le apa̱k te, onəmgbak oIsa̱rila ɓəp pa̱, <<Iza̱ nak kang uYawe re oFilisti nəm igwan ká̱ yi nda ata̱ yà? Re i ɓa ká̱ akwati aga nsar nnap-nlà aYawe ka̱ aShilo, na uza̱ á ka̱m ishi yi ka̱ ashe awo okpa ìkum yi.>> ");
INSERT INTO yer_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Te oza̱ re onəm ga aShilo, kang oza̱ ɓa ká̱ Akwati aga nsar nnap-nlà aYawe uGa ngGatək, uva təm ka̱ ishimshe oga akerup. Kang ovan onunggwan aEli oga oparəm, uHopəni ká̱ uFinehas, oma ka̱ yà ka̱ ta ká̱ akwati aga nsar nnap-nlà Inan. ");
INSERT INTO yer_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Kang awalang va̱ akwati aga nsar nnap-nlà aYawe fa chu ashe apa̱k te, nkpaktak oIsa̱rila bà achu kang mbin yənggət. ");
INSERT INTO yer_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Awalang va̱ oFilisti fe mbà achu te, oza̱ ɓəp pa̱, <<Iza̱ nak kang achu i bà wa nta̱ ka̱ ashe apa̱k onəm aIbərahim yà?>> Nva̱ngva̱ oza̱ fe pa̱ mmá ɓa ká̱ akwati aga nsar nnap-nlà aYawe chit ka̱ ashe apa̱k, ");
INSERT INTO yer_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","te ayər nəm oFilisti, oza̱ là pa̱, <<Inan à ɓa ashe apa̱k.>>Te oza̱ là pa̱ <<Á kùr ká̱ yi chit, ka̱kul nna mmá nəm apir iya̱m chit wa iva̱ ta̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Á lak ká̱ yi chit. Uda i ka̱m ishi yi ka̱ ashe awo oga inan ichumchum va̱ ta̱ yà? Oga inan va ta̱ gbá̱ng onəm oga aMasar ká̱ apir oga nɗaktak pa̱ ɗongɗong ka̱ ashe nzam. ");
INSERT INTO yer_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","ÓFilisti, ó nəm nkám ìpa̱ng, ó lung oza̱, ka̱kul na kang ó nyáng ozwal onəm aIbərahim wa nva̱ oza̱ ka̱ yà ozwal wó ka̱t. Ó tong pa̱ kakkərak wa onunggwan, ó lung ìkum.>> ");
INSERT INTO yer_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Te oFilisti lung ìkum va̱ ta ká̱ nkpaktak nkàm oza̱, kang oza̱ ri oIsa̱rila, oshozha oIsa̱rila chəng, udanggo kpán asa̱l aghal wò. Mmá gbá̱ng oIsa̱rila pa̱ makmak, kang onəm va̱ mmá gbá̱ng te, ìkalong ìsəm pa̱ ishatɗing. ");
INSERT INTO yer_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Mmá vyat akwati aga nsar nnap-nlà Inan, kang ovan onunggwan aEli oga oparəm, uHopəni ká̱ uFinehas, mmá gbá̱ng kpa. ");
INSERT INTO yer_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Unəm uro ka̱ akum ìjili aBenjamin chər ka̱ atak ìkum ɓa chu aShilo ka̱ nda va̱ ta. Uza̱ ká̱ ìlukwan ikankan kang ká̱ mɓwang ka̱ ishi wò. ");
INSERT INTO yer_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Awalang va̱ uza̱ ɓa chu te, uEli uwa ka̱ yà ka̱ ntəm ka̱ apal iya̱m ntəm wò ka̱ ngba̱k asa̱l pa̱ na ô fe nnap ìkum va̱, ka̱kul ìgugwak ra ka̱ apal akwati aga nsar nnap-nlà aYawe va̱ ka̱t. Awalang va̱ unəm va̱ ta tar ashe ìtong kang à là kpaktak iya̱m va̱ fa ônəm te, nkpaktak ìtong bà ká̱ ayə́ng. ");
INSERT INTO yer_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","UEli fe mbà ayə́ng te, uza̱ ɓəp pa̱, <<Iza̱ mí bà ayə́ng kà̱ yà?>> Te unəm va̱ ta gha̱n ɓa kang à là ûEli iya̱m va̱ fa. ");
INSERT INTO yer_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Ka̱ awalang va̱ ta te, uEli ká̱ ìzun ìsəm pa̱ ìfangzəngtəng ama̱n pa̱ na̱nne kang uza̱ fo chit, i ya atak lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Uza̱ là ûEli pa̱, << N chər ka̱ atak ìkum, m ɓa n̂da ata̱.>> Te uEli ɓəp pa̱, <<Áyen mi, iza̱ kà̱ ngga yà?>> ");
INSERT INTO yer_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Te unəm va̱ ɓa ka̱ nggwol va̱ ta na ama̱n pa̱, <<OIsa̱rila chəng kà̱ mpyal oFilisti, kang oFilisti gbá̱ng onəm pa̱ makmak nzəng ká̱ ovan ɓu onunggwan oga oparəm, uHopəni ká̱ uFinehas. Kang mmá vyat akwati aga nsar nnap-nlà Inan kpa.>> ");
INSERT INTO yer_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Nva̱ngva̱ uEli fe nnap akwati aga nsar nnap-nlà Inan va̱ ta te, uza̱ ru ka̱ asa̱l nsəm ka̱ apal ìtok wò ka̱ anung asa̱l ìtong. Kang uza̱ ɓəkchi ìshak, uza̱ kú, ka̱kul uza̱ unəm ugbakgbak umwalmwal. Uza̱ ka̱ yà unəm uga mpyal oIsa̱rila ìzun ìsəm pa̱ ìneɗing. ");
INSERT INTO yer_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Uchar à ya aEli, uFinehas ka̱ yà ká̱ anyám, á dát ká̱ amar chit. Awalang va̱ uchar va̱ ta fe pa̱ mmá vyat akwati aga nsar nnap-nlà Inan chit, kang pa̱ ukəka ká̱ uɓəɓar oza̱ kú chit kpá, te nrwa afu amar wong ka̱ na, uza̱ kúchi mar te, uza̱ kú. ");
INSERT INTO yer_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Uza̱ ka̱ anung ikú te, ochar va̱ kà̱ nnak ishi ká̱ na là á na pa̱, <<Kang ayər á nəm ɓu ka̱t, ka̱kul u mar uyen ununggwan>> Ǹnyi te, uza̱ na ama̱n ka̱t, kang uza̱ nak ishi ká̱ oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Te uza̱ sok aɗin ûyen va̱ ta pa̱ uIkabot, uza̱ là pa̱, <<Ìzhàn kap ká̱ aIsa̱rila chit.>> Ka̱kul mmá vyat akwati aga nsar nnap-nlà Inan chit, kang ukəka ká̱ uɓəɓar kú chit kpá. ");
INSERT INTO yer_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","Uza̱ là pa̱, <<Ìzhàn kap ká̱ aIsa̱rila chit, ka̱kul mmá vyat akwati aga nsar nnap-nlà Inan chit.>> ");
INSERT INTO yer_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Kà̱ nva̱ngva̱ oFilisti vyat akwati aga nsar nnap-nlà Inan chit ka̱ atak ìkum ka̱ aEbenezer, te oza̱ ga ká̱ ka̱ aAshdot. ");
INSERT INTO yer_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Oza̱ yar akwati aga nsar nnap-nlà Inan nak ka̱ ashe nzhi aDagon, oza̱ nak datkulung ká̱ aDagon. ");
INSERT INTO yer_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Nva̱ngva̱ onəm oga aAshdot wong ká̱ ìɓotak te, oza̱ ya aDagon ru chit zəp ká̱ afu kà̱ mpyal akwati aga nsar nnap-nlà aYawe. Te oza̱ yar oza̱ yal ka̱ atak nvəva̱ng. ");
INSERT INTO yer_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Ǹnyi te, atak fa tàn ká̱ ìpin kang oza̱ wong te, oza̱ ya aDagon ru chit zəp ká̱ afu kà̱ mpyal akwati aga nsar nnap-nlà aYawe. Ishishi ká̱ oga awuwo ɓun ra ka̱ anung asa̱l, izəzər na le chwat. ");
INSERT INTO yer_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Iya̱m va ta nak kang ɓa chu n̂da va̱ ta̱ te, onəm oga mpyal awop aDagon ka̱t te nkpaktak ovəngva̱ i táng ashe nzhi awop aDagon pa̱ ó wop na, i tòng anung asa̱l nzhi aDagon ka̱ aAshdot ka̱t. ");
INSERT INTO yer_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","UYawe nyán ká̱ onəm oga aAshdot, ká̱ oga atak va̱ gáng na ká̱ arwa oga nsomo. ");
INSERT INTO yer_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Onəm oga aAshdot ya chit pa te, oza̱ là pa̱, <<Kang i re akwati aga nsar nnap-nlà Inan oIsa̱rila a təm ka̱ atak yi ka̱t. Ka̱kul Inan oIsa̱rila kà̱ nnyán ká̱ yi ká̱ inan yi aDagon.>> ");
INSERT INTO yer_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Te oza̱ re ǹre mmá ɓut nkpaktak oponzhi oFilisti, kang oza̱ ɓəp pa̱, <<Iza̱ í nəm ká̱ akwati aga nsar nnap-nlà Inan oIsa̱rila va̱ ta̱ yà?>> Te oponzhi va̱ ta na ama̱n pa̱, <<Mmá yar akwati aga nsar nnap-nlà Inan oIsa̱rila, mmá ga ká̱ ka̱ aGat.>> Te oza̱ yar ga ká̱ ka̱ aGat, ìtong oFilisti ìro. ");
INSERT INTO yer_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Nva̱ngva̱ oza̱ ga ká̱ chit ka̱ aGat te, uYawe nyán ká̱ onəm oga ìtong va̱ ta. Ovan ká̱ onəmgbak, uza̱ lə̀p kpaktak oza̱ ká̱ arwa oga nsomo. ");
INSERT INTO yer_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Te oza̱ re nre ká̱ akwati aga nsar nnap-nlà Inan ga aEkron. Awalang va̱ akwati aga nsar nnap-nlà Inan va̱ ta ɓa chu aEkron te, onəm bà ayə́ng, oza̱ là pa̱, <<Oza̱ ɓa ká̱ akwati aga nsar nnap-nlà Inan oIsa̱rila ka̱ ta̱ pa̱ na á gbá̱ng yi pa̱ chatchat.>> ");
INSERT INTO yer_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Te oza̱ wór nkpaktak oponzhi oFilisti ka̱ atak zəngtəng, kang oza̱ là pa̱, <<Ó re ǹre ká̱ akwati aga nsar nnap-nlà Inan oIsa̱rila á le atak va̱ fa kà̱, ka̱t te i gbá̱ng yi ká̱ onəm yi.>> Arwa aɓá̱ngɓa̱ng ka̱ atak Inan á ɓàn chit ka̱ ashe ìtong ka̱kul Inan kà̱ nnyán ká̱ ìtong va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Onəm va̱ kú ka̱t te, mmá lə̀p oza̱ ká̱ nsomo, kang ayə́ng onəm ɓa chu apaɓur. ");
INSERT INTO yer_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Kà̱ nva̱ngva̱ akwati aga nsar nnap-nlà aYawe nəm ape pa̱ fangshat ka̱ ashe mbin oFilisti te, ");
INSERT INTO yer_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","oFilisti wór onəm oga mpyal awop ká̱ onəm oga iva̱k, ɓəp oza̱ pa̱, <<Iza̱ í nəm ká̱ akwati aga nsar nnap-nlà aYawe va̱ ta̱ yà? Ó là á yi asa̱l va̱ í nəm kang í le ká̱ ka̱ atak nvəva̱ng.>> ");
INSERT INTO yer_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Oza̱ na ama̱n pa̱, <<A yà pa̱ ó le ká̱ akwati aga nsar nnap-nlà Inan oIsa̱rila te, kang ó re á ga pa alakchi ka̱t, nkpak ó na iya̱m inana iga ǹyar mpat á na. Nna chit te ó ya ikángkáng kà̱ɗi, kang ó nyi ìpir iya̱m va̱ nak kang uYawe re nyán ká̱ wó ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","OFilisti ɓəp pa̱, <<Nza̱ apir iya̱m inana iga ǹyar mpat a màl pa̱ í re nre ká̱ yà?>> Te oza̱ na ama̱n pa̱, <<Ó la oga nsomo ngga azənariya pa̱ ntukun ká̱ ipí pa̱ ìtukun iga azənariya ka̱ apal ìyəl oponzhi oFilisti, ka̱kul arwa azəngtəng na ya wó ká̱ oponzhi wó. ");
INSERT INTO yer_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Ó la apir oga nsomo va̱ nəm wó, ká̱ apir ipí va̱ vyap iya̱m ka̱ mbin wó, na ó na ichumchum Înan oIsa̱rila. Mwote uza̱ i yar mɓək anung va̱ ta i le a wó ká̱ oga inan wó, kang ká̱ mbin wó nggo. ");
INSERT INTO yer_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Iza̱ nak kang ó twat igwak wó wa onəm oga aMasar ká̱ uponzhi oza̱ yà? Nva̱ngva uYawe nyán ká̱ oza̱ chit pa̱ gənggəng te, oza̱ re onəm oIsa̱rila kpan asa̱l ga ka̱t ɗò? ");
INSERT INTO yer_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","<<Ǹyangmata̱ te, ó nəm akeke ina apipe, te ó ran ina pa̱ iparəm iva ivan oza̱ na ka̱ mmá mbyal, iva na mmá ran ayok ôza̱ chit ka̱t, ǹnyi te, ó re ivan oza̱ ka̱ ashe afo. ");
INSERT INTO yer_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Te ó yar akwati aga nsar nnap-nlà aYawe va̱ ta, ó nak ka̱ apal akeke, te ó nak oga iya̱m va̱ ó la ká̱ azənariya ka̱ ashe akwati aro ka̱ ngbəgba̱k, iva ó re nre ká̱ ûYawe wa iya̱m inana iga nyar mpat. Te ó re na á fa á ga asa̱l wò, ");
INSERT INTO yer_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","ǹnyi te, ó dər. A yà pa̱ a kpán asa̱l aBet-Shemesh te, í nyi pa̱ uYawe uwa i nyán ká̱ yi, kang a yà pa ka̱t te, í nyi pa̱ uwa i nyán ká̱ yi ka̱t. Á ya yi pa mwang.>> ");
INSERT INTO yer_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","OFilisti nəm wa nva mmá là ôza̱. Oza̱ wur ina iga ivan pa̱ iparəm ran akeke ina ôza̱, kang oza̱ kùk ivan oza̱ ka̱ ashe afo. ");
INSERT INTO yer_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Te oza̱ nak akwati aga nsar nnap-nlà aYawe ka̱ apal akeke ina ká̱ akwati oga nsomo ngga azənariya ká̱ ipí iga azənariya ka̱ ngba̱k akwati aga nsar nnap-nlà aYawe. ");
INSERT INTO yer_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Oga ina va̱ ta kpán asa̱l nzwang i ga aBet-Shemesh, oza̱ ka̱ ngga oza̱ ka̱ ǹyə́ng. Oza̱ lyep awo ari ka̱t te apəra̱m ka̱t. Oponzhi oFilisti wà nva̱ng oza̱ ga chu aswari aBet-Shemesh. ");
INSERT INTO yer_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Ǹyangmata̱ te, onəm oga aBet-Shemesh ka̱ mɓən ìzangzəng oza̱ ka̱ ashe mba̱nda̱m, kang awalang va̱ oza̱ wong ká̱ iwú, kang oza̱ ya akwati aga nsar nnap-nlà te, ìgwak nchang oza̱ kà̱ nya akwati va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","Akeke ina va̱ ta tar ashe ìram aJoshuwa uga aBet-Shemesh kang à sat ka̱ ta, kà̱ ngba̱k ìnang ìpang. Te onəm ghak akun akeke ina va̱ ta mà̱k apər ká̱ kang oza̱ yichi ina va̱ ta iya̱m inana iga nshì pa̱ ɗwot ûYawe. ");
INSERT INTO yer_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","OLawi yar akwati aga nsar nnap-nlà aYawe va̱ ta ká̱ akwati va̱ kà̱ ngbəgba̱k, ava mmá nak oga ala̱ka̱n va̱ mmá nəm ká̱ azənariya ka̱ ashishe, kang oza̱ nak ka̱ apal ìnang ìpang va̱ ta. Te onəm oga aBet-Shemesh yichi iya̱m inana iga nshì pa̱ ɗwot ká̱ nləfər ûYawe n̂da va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Oponzhi oFilisti oga otukun va̱ ta ya te, oza̱ le n̂da va ta ga aEkron. ");
INSERT INTO yer_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Oga nsomo ngga azənariya va̱ oFilisti re nre ká̱ wa iya̱m inana iga ǹyar mpat ûYawe te, oma ta̱, pa̱ zəng ka̱kul aAshdot, pa̱ zəng ka̱kul aGaza, pa̱ zəng ka̱kul aAshəkelon, pa̱ zəng ka̱kul aGat kang pa̱ zəng ka̱kul aEkron. ");
INSERT INTO yer_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Kang ipí iga azənariya ka̱ anung oga itong oFilisti iga itukun va̱ ta, iva iji oponzhi oga otukun va̱ ta, oga itong iga akamsəlang ká̱ ivan itong iva yà ká̱ akamsəlang ka̱t. Ìnang ìpang va̱ oza̱ nak akwati aga nsar nnap-nlà aYawe kà̱ te, ì ya yà n̂da va̱ ta̱ ka̱ ashe ìram aJoshuwa uga aBet-Shemesh. ");
INSERT INTO yer_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Te uYawe gbá̱ng onəm oga aBet-Shemesh ìsəm pa̱ ìfangshat ka̱kul oza̱ dər ashe akwati aga nsar nnap-nlà aYawe. Iya̱m va̱ ta nak onəm oga aBet-Shemesh yə́ng ikú pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Kang onəm oga aBet-Shemesh ɓəp pa̱, <<Uda kúr nsat ka̱ mpyal aYawe, Inan ìyə́ryər va̱ ta̱ yà? Í re akwati aga nsar nnap-nlà va̱ ta̱ i ga che kang i kap ká̱ yi yà?>> ");
INSERT INTO yer_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Te oza̱ re onəm oga nre ka̱ atak onəm oga ntəm ka̱ aKiriyat-Jeyarim pa̱, <<OFilisti le ká̱ akwati aga nsar nnap-nlà aYawe chit, ó ɓa na ó yar á ga ka̱ atak wó.>> ");
INSERT INTO yer_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Te onəm oga aKiriyat-Jeyarim ɓa yar akwati aga nsar nnap-nlà aYawe ga ká̱ kà̱ nzhi aAbinadap ka̱ apal aɗuktum. Kang oza̱ gár uyiyen uEleyazar pa̱ á pángchí akwati aga nsar nnap-nlà aYawe va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Akwati aga nsar nnap-nlà va̱ ta təm ka̱ aKiriyat-Jeyarim awalang pa̱ makmak, a ga chu ìzun ìsəm pa̱ ìparəm. Ka̱ awalang va̱ ta te, nkpaktak oIsa̱rila ga̱ɓa̱n yə́ng ka̱ mpyal aYawe pa̱ á ka̱mshi wó. ");
INSERT INTO yer_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Te uSamuwel là n̂kpaktak oIsa̱rila pa̱, <<A yà pa̱ mmawó kà̱ nle atak aYawe ká̱ nkpaktak igwak wó te, ó swang oga inan iga mbin nro ká̱ inan aAshtoret ka̱ ashe wó, na ó nak ìgwak ka̱ atak aYawe, ó wop uwa byet, te uza̱ i ka̱mshi wó ka̱ ashe awo oFilisti.>> ");
INSERT INTO yer_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Te oIsa̱rila swang oga aBaal ká̱ oga aAshtoret kang oza̱ wop uYawe wa byet. ");
INSERT INTO yer_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Te uSamuwel là pa̱, <<Ó ɓut nkpaktak oIsa̱rila ka̱ aMizpa, te mi far ûYawe ka̱kul wó.>> ");
INSERT INTO yer_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Awalang va̱ oza̱ ɓut ka̱ aMizpa te, oza̱ dàp ndəng sháng kà̱ mpyal aYawe. Oza̱ yar ndəng gbà̱l ká̱ nda va̱ ta kang oza̱ là pa̱, <<Í nəm nnap-mɓá̱ngɓa̱ng ûYawe chit.>>Ǹyangmata̱ te, uSamuwel ka̱ yà ka̱ nnəm iponzhi oIsa̱rila ka̱ aMizpa. ");
INSERT INTO yer_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Awalang va̱ oFilisti fe pa̱ oIsa̱rila ɓut chit ka̱ aMizpa, te oponzhi oFilisti kyen ga pa̱ na ó ru oza̱ ka̱ ìkum. Kang awalang va̱ oIsa̱rila fe te, ayər nəm oza̱ ka̱kul oFilisti. ");
INSERT INTO yer_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Te oza̱ là ûSamuwel pa̱, <<Í chal ɓu, kang wa re nfar afar ûYawe, Inan yi ka̱kul yi ka̱t, na mwote uza̱ á ka̱mshi yi ka̱ ashe awo oFilisti nggo.>> ");
INSERT INTO yer_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Te uSamuwel kpán ìya ìtam iga mma mbyal kang à yichi na iya̱m inana iga nshì pa̱ ɗwot ûYawe. Te uSamuwel far ûYawe ka̱kul oIsa̱rila, te uYawe ma̱n á na. ");
INSERT INTO yer_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Nva̱ uSamuwel ka̱ ǹyichi nləfər va̱ ta̱ ká̱ iya̱m inana iga nshì pa̱ ɗwot ûYawe te, oFilisti ka̱ mɓa pa̱ ó ru oIsa̱rila ká̱ ìkum. Te uYawe ləp ìgbarman ká̱ nda va̱ ta ka̱ apal oFilisti, te a na ayər ôza̱, kang oza̱ le nva̱ng chəng kà̱ mpyal oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Te oshozha oIsa̱rila fa ka̱ ashe aMizpa kang oza̱ ɓak oFilisti, kang nəm inok ngbá̱ng oza̱ ga dat ká̱ aBetkar. ");
INSERT INTO yer_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Te uSamuwel yar ìpang nak ká̱ ishimshe aMizpa ká̱ aShen kang à na aɗin a na pa̱ aEbenezer, uza̱ là pa̱, <<Á ɓa chu ǹyangmata̱ uYawe wa ka̱ nka̱mshi yi.>> ");
INSERT INTO yer_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Wa nnà ta oIsa̱rila nəm igwan ká̱ oFilisti, kang oza̱ táng aswari mbin oIsa̱rila lap ka̱t. Ǹnyi te, uYawe nəm inok nnyán ká̱ oFilisti ka̱ ashe nkpaktak nra aSamuwel. ");
INSERT INTO yer_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Te mmá le ká̱ oga itong oIsa̱rila va̱ oFilisti vyat ka̱ oza̱ á, ɓàn ká̱ aEkron ga chu aGat, kang oIsa̱rila ka̱m oga aswari mbin oza̱ kpa ka̱ ashe awo oFilisti. Kang ntəm ikángkáng yà ká̱ ishimshe oIsa̱rila ká̱ oAmori. ");
INSERT INTO yer_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","USamuwel nəm iponzhi oIsa̱rila ka̱ ashe nkpaktak nra irirìriri. ");
INSERT INTO yer_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Nza̱ ìzun nggo te, uSamuwel i ranggang i ga aBetel, aGilgal ká̱ aMizpa, kang uza̱ i náp akwali oga itong va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Te uza̱ i le aRama nzhizhi, kang uza̱ i náp akwali ôIsa̱rila ka̱ ta kpa. Kang uSamuwel me atak nshì iya̱m awop ûYawe ka̱ aRama. ");
INSERT INTO yer_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Awalang va̱ uSamuwel gbák chit, te uza̱ kyep ovan wò onunggwan yà onəm oga mpyal oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Aɗin ayiyen uga ngəshi pa̱ uJowel, kang uga uparəm pa̱ uAbijah, kang oza̱ nəm inok ka̱ aBeyersheba. ");
INSERT INTO yer_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Ǹnyi te, ovəvan yar nnap-nnənəm ka̱t. Oza̱ ga̱ɓa̱n ka̱kul nram mmak, oza̱ i ga̱ɓa̱n nnandər ka̱ atak nka̱m iya̱m iga mmulam anung ka̱ atak onəm. ");
INSERT INTO yer_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Te nkpaktak onəm oga mpyal oIsa̱rila ɓut kang a ɓa atak aSamuwel ka̱ aRama. ");
INSERT INTO yer_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Oza̱ là á na pa̱, <<Dər, ǹyangmata̱ u gbák chit, kang ovan ɓu onunggwan yar nnap-nnəm ɓu ka̱t. Ka̱kul nva̱ ta te, kyer uponzhi á yi, uva i nəm ká̱ yi wa aɓoshi oga mbin.>> ");
INSERT INTO yer_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Nva̱ oza̱ là pa̱, <<Kyer uponzhi á yi, uva i nəm ká̱ yi,>> te nnap va̱ ta ɗak uSamuwel, kang uza̱ far afar ûYawe. ");
INSERT INTO yer_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Te uYawe là ûSamuwel pa̱, <<Nəm ôza̱ wa nva oza̱ ɗom á. Ka̱kul oza̱ yang mmaɓu ka̱t, oza̱ yang mmami pa̱ n yà uponzhi oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Á ɓan ka̱ ashe nra va̱ n fa ka̱ oza̱ kà̱ mbin aMasar, á ɓa chu nda va̱ ta̱, oza̱ ga̱ɓa̱n asəm á mi, oza̱ i wop inan iro, te wa nnà ta oza̱ kà̱ nnənəm a ɓu. ");
INSERT INTO yer_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Ǹyangmata̱ te, nəm ôza̱ wa nva̱ oza̱ ɗom, ǹnyi te, dàp achwang oza̱ pa̱ gənggəng, là ôza̱ apir iya̱m va̱ uponzhi va̱ ta i nəm ôza̱.>> ");
INSERT INTO yer_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Te uSamuwel là ônəm va̱ ɓəp pa̱ mmá na uponzhi ôza̱, nkpaktak iya̱m va̱ uYawe là á. ");
INSERT INTO yer_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","USamuwel là ôza̱ pa̱, <<Asa̱l va ta̱ uponzhi va̱ ta i nəm iponzhi wò ka̱ apal wó, uza̱ i wur ovan wó onunggwan i nak i yà onəm oga nkwak akeke ipəripəri, oro i tong onəm oga nkwak ipəripəri, kang oro i chəng ka̱ mpyal akeke ipəripəri. ");
INSERT INTO yer_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Kang uza̱ i nak oro i yà onəm oga mpyal ìkukum ka̱ apal oshozha ìkalong, kang oro ka̱ apal oshozha ìsəm pa̱ itukun, kang oro i wap ìrəram, kang i ɓən iyəya̱m á na kpa, oro i lá iya̱m ìkum á na ká̱ iya̱m akeke ipəripəri. ");
INSERT INTO yer_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","UPonzhi va̱ ta i wur ovan ochar wó i nak i nyang onəm oga nnəm nturari, ká̱ mpə́k iya̱m-nrì, ká̱ ngwang nzəngkəng á na. ");
INSERT INTO yer_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Uza̱ i vyat iram wó inəna̱n, ká̱ iram iba̱ngba̱ng inəna̱n, ká̱ ikun mpyet wó inəna̱n i na ônəm oga nnəm inunok. ");
INSERT INTO yer_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Uza̱ i ka̱m uzəng ka̱ apal agba̱pchi iga ìpirkur ká̱ iga ìba̱ngba̱ng wó i na ônəm oga mpyal wò ká̱ onəm oga nnəm inunok. ");
INSERT INTO yer_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Uza̱ i wur ozwal wó onunggwan ká̱ ochar, ká̱ ina va ɓyen ji ká̱ oga azhaki wó, ka̱kul nnəm inunok. ");
INSERT INTO yer_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Uza̱ i ka̱m uzəng ka̱ apal agba̱pchi iga iya̱mkang wó, kang mmawó ká̱ ishi wó, ó tong ozuzwal. ");
INSERT INTO yer_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Awalang va̱ ta i ɓa i chu te, ó chal pa̱ mmá ka̱m ishi wó ka̱ atak aponzhi va̱ ta, ǹnyi te, uYawe i gwong achwang kà̱ wó n̂da va̱ ta ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Káp ka̱ nna te, onəm va̱ ta gwong achwang ka̱ uSamuwel ka̱t. Oza̱ là pa̱, <<O'o, í ɗom uponzhi pa̱ á nəm ká̱ yi, ");
INSERT INTO yer_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","ka̱kul na í yà wa aɓoshi oga mbin. Í ɗom uponzhi pa̱ á nəm ká̱ yi, kang i ləp mpyal á yi ka̱ atak ìkum.>> ");
INSERT INTO yer_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Ka̱ nva̱ngva̱ uSamuwel fe nkpaktak iya̱m va̱ onəm là te, uza̱ là ûYawe iya̱m va̱ oza̱ là. ");
INSERT INTO yer_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Te uYawe là ûSamuwel pa̱, <<Nəm ôza̱ wa nva̱ oza̱ ɗom, kyer uponzhi ôza̱.>> Te uSamuwel là oIsa̱rila pa̱, <<Udanggo á le nzhi wò.>> ");
INSERT INTO yer_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Unəm uga atak nsat uro uwa ka̱ yà ka̱ akum ìjili aBenjamin, aɗiɗin pa̱ uKish, uya aAbiyel, uya aZeror, uya aBekorat, uya aAfiya, uya aBenjamin. ");
INSERT INTO yer_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","UKish uwa ká̱ uyen ununggwan aɗiɗin pa̱ uShawulu, uyenza̱m uro yà ɓyen ji na ka̱ ashe ovanza̱m oIsa̱rila ka̱t, kang uza̱ mak ji nkpaktak oIsa̱rila ká̱ ìrup ashar pa̱ zəng. ");
INSERT INTO yer_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","N̂da nro te, oga azhaki aKish lar, te uza̱ là uyen wò uShawulu pa̱, <<Ga ká̱ ukpari mi uro na ó mwo oga azhaki va̱ ta.>> ");
INSERT INTO yer_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Te uShawulu ga nzəng ká̱ uzəngtəng ka̱ ashe okpari apupo, oza̱ kyén ga aɗuktum mbin aEfrayim, ká̱ mbin oShalisha te, oza̱ ya azhaki va̱ ta ka̱t. Oza̱ watar ga mbin aShayalim ká̱ nna te, oza̱ ya oga azhaki ka̱ ta ka̱t. Te oza̱ lyam ga ashe mbin aBenjamin, káp ka̱ nna te, oza̱ ya oga azhaki va̱ ta ka̱t. ");
INSERT INTO yer_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Nva̱ngva̱ oza̱ ɓa chu mbin aZup te, uShawulu là ûkpari va̱ ta pa̱, <<Re, í le nzhi ka̱kul kang upo mi a le á ya ka̱ nɗaktak ka̱ apal yi a ji oga azhaki va̱ ta ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Ǹnyi te, ukpari va̱ ta là á na pa̱, <<UNəm Inan uwa ka̱ ashe ìtong va̱ ta̱ uva mmá na ichumchum á na byet, iya̱m va pa̱ kpaktak uza̱ i là te, i yə́l. Í ga atətak, mwote uza̱ a là á yi atak va̱ oga azhaki va̱ ta kà̱ nggo.>> ");
INSERT INTO yer_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Te uShawulu ɓəp ukpari wò va̱ ta pa̱, <<A yà pa̱ í ga atak anəm va̱ ta te, iza̱ í na á na yà? Ka̱kul nzəngkəng va̱ ka̱ ashe oga azhal yi te, á kúr chit, kang i yà ká̱ iya̱m va̱ pa̱ i na á na ka̱t. Mwote iya̱m iro nna yà ɗak ɓo?>> ");
INSERT INTO yer_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Ukpari va̱ ta na ama̱n á na kà̱ɗi pa̱, <<Dər, na n yà ká̱ azurfa pa̱ ɗa̱p, mi na ûnəm Inan va̱ ta, te uza̱ i nyám asa̱l va̱ á yi, í lyep kà̱.>> ");
INSERT INTO yer_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","Kà̱ nra ngga nva̱ng te, ka̱ ashe mbin oIsa̱rila, unəm va̱ i ɗom pa̱ ó ga ó fe ka̱ atak Inan te, i là pa̱, <<Í ga atak anəm uga dər mpyal.>>Ka̱kul unəm va̱ mí wór pa̱ unəm uga nka̱m nre ka̱ atak Inan ǹyangmata̱ te, matmat te, mí wór pa̱ unəm uga dər mpyal. ");
INSERT INTO yer_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Te uShawulu là ukpari wò pa̱, <<Ichən va̱ ta̱ ɓyen byet, í ga.>> Te oza̱ kpan asa̱l aga ngga ashe ìtong va̱ unəm Inan va̱ ta kà̱. ");
INSERT INTO yer_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Nva̱ oza̱ kà̱ nkyén mɓa ngga aɗuktum ìtong va̱ ta te, oza̱ gwang ovanɓyen oro kà̱ nfa pa̱ na ó ga ó dàp ndəng, te oza̱ ɓəp oza̱ pa̱, <<Unəm va̱ i dər mpyal te, uwa ka̱ ta̱ ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Ovanɓyen va̱ ta ma̱n pa̱, <<À, uwa yà, ó gha̱n, ó ga ǹyangmata̱, uwa kà̱ mpyal wó. Uwa tar ìtong yi nda ata̱, ka̱kul mmá kà̱ ngga nnəm nləfər ka̱ atak awop aga aɗuktum. ");
INSERT INTO yer_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Ka̱ ntar wó na byet te, ó ya na kang uza̱ i ga atak awop aga aɗuktum ka̱kul nrì iya̱m-nrì. Onəm i yà ká̱ nri iya̱m ka̱t, ya uza̱ i ɓa i pa̱r nləfər kang. Nna chit te, onəm va̱ mmá chal te, i ri iya̱m ɗak. Ó ga ǹyangmata̱, ó ya na ya ka̱ awalang a ta̱.>> ");
INSERT INTO yer_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Te oza̱ táng ga ashe ìtong va̱ ta, kang nva̱ oza̱ kà̱ ntáng te, oza̱ gwang uSamuwel kà̱ mɓa ka̱ asa̱l isu oza̱ kà̱ ngga atak awop aga aɗuktum. ");
INSERT INTO yer_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Kang uShawulu i ɓa te, uYawe ka̱ là nnap ûSamuwel chit pa̱, ");
INSERT INTO yer_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","<<Ìpin ká̱ awalang wa nta̱, mi re nre a ɓu ká̱ unəm ka̱ ashe mbin aBenjamin. Gòr na á yà unəm uga mpyal oIsa̱rila, uza̱ i fa ká̱ onəm mi ka̱ ashe awo oFilisti. Ka̱kul n ya mɓək anung onəm mi chit, kang ayə́ng oza̱ ɓa chu atak mi chit.>> ");
INSERT INTO yer_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Awalang va̱ uSamuwel ya uShawulu te, uYawe là á na pa̱, <<Unəm va ta̱ ka̱ nlà nnənap a ɓu, uwa i nəm iponzhi ká̱ onəm mi.>> ");
INSERT INTO yer_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Te uShawulu ga atak aSamuwel ka̱ anung asa̱l ìtong kang uza̱ ɓəp na pa̱, <<Mmami ka̱ nchal ɓu, nzhi anəm uga ndər mpyal ka̱ che yà?>> ");
INSERT INTO yer_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","USamuwel na ama̱n á na pa̱, <<Mmami na unəm uga ndər mpyal va̱. Watar mpyal na í ga atak awop, ka̱kul n̂da ata̱ ɓu ga nri iya̱m-nrì nzəng ká̱ mi. Kang ìpin ká̱ ìɓotak te, mi re ɓu na ú ga, kang mi là iya̱m va̱ a ɓu pa̱ kpaktak ka̱ ashe ìgwak ɓu. ");
INSERT INTO yer_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Kang á ɗak ɓu kà̱ nnap oga azhaki va̱ lár nra chit pa̱ nshatɗing nda ata̱ ka̱t, ka̱kul mmá ya oza̱ chit. Mmami ka̱ nlà a ɓu pa̱, mmaɓu ká̱ nzhi apo ɓu na nkpaktak oIsa̱rila kà̱ nnak ìgwak kà̱.>> ");
INSERT INTO yer_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","UShawulu na ama̱n pa̱, <<Mmami ka̱ akum ìjili aBenjamin, akum va yen ji ka̱ ashe akum oIsa̱rila, kang ka̱ ashe akum aBenjamin te, mmami ka̱ ashe nzhi va yen ji ka̱ɗi lap. Te iza̱ nak kang ɓu là nnap á mi wa nva̱ ta̱ yà?>> ");
INSERT INTO yer_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Te uSamuwel ka̱m uShawulu ká̱ ukpari wò táng ká̱ ka̱ ashe nzhi mɓut, kang uza̱ nak oza̱ ka̱ atak ntəm kà̱ mpyal onəm va mmá chal, ova i chu ìsəm pa̱ ishatɗing chu. ");
INSERT INTO yer_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Kang uSamuwel là ûnəm uga pə́k iya̱m-nrì pa̱, <<Ɓa ká̱ ìzhe va̱ ka̱ n ná a ɓu, i va ka̱ nlà a ɓu pa̱, u nak pa̱ɗi á.>> ");
INSERT INTO yer_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Te unəm uga mpə́k iya̱m-nrì va̱ ta yar ìsong ìzhe ká̱ iya̱m va̱ ka̱ apəpal ɓa cher ka̱ mpyal aShawulu. Kang uSamuwel là á na pa̱, <<Ìzhe va ta̱ mmá nak á ɓu, ri, ka̱kul n nak m̂maɓu pa̱ na u ri, ka̱ awalang va̱ ka̱ nlà pa̱, <N chal onəmchən ká̱ á.> >> N̂da va̱ ta te, uShawulu ri iya̱m nzəng ká̱ uSamuwel. ");
INSERT INTO yer_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Ka̱ nva̱ngva̱ oza̱ fəng chit ka̱ atak awop aga aɗuktum kang à táng ashe ìtong te, uSamuwel là nnap ká̱ uShawulu ka̱ apal apal aga nzhi wò. ");
INSERT INTO yer_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Atak fa tan ká̱ ìpin te, uSamuwel wór uShawulu ka̱ apal apal aga nzhi, a là pa̱, <<Gbar izər, mmami kà̱ ngga nre ɓu na u kpan asa̱l.>>Nva̱ngva̱ uShawulu gbar izər chit, te uSamuwel fa ká̱ na ga re ka̱ apal asa̱l. ");
INSERT INTO yer_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Nva̱ oza̱ ga dat ká̱ nkur ìtong te, uSamuwel là ûShawulu pa̱, <<Là ûkpari ɓu pa̱ à gəga kang.>> Te ukparikpari ga. Nna chit te, uSamuwel là á na pa̱, <<Sat ka̱ ta̱, na n là nre Inan á ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Te uSamuwel yar afal mmì mpyet zuk uShawulu ká̱ ishi, uza̱ fəkchi na kang á là pa̱, <<Mmami ka̱ nnəm iya̱m va̱ ta̱ á ɓu ka̱kul uYawe gar ɓu chit pa̱ u yà uponzhi ka̱ apal iya̱mkup wò, oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Nva̱ngva̱ ɓu re mi n̂da ata̱ te, ɓu gwang onəm pa̱ oparəm dat ka̱ awap aRahila ka̱ aZelza, ka̱ aswari mbin aBenjamin. Oza̱ i là a ɓu pa̱, <Oga azhaki va̱ mmá ya chit, kang upo ɓu kong ká̱ nnap oza̱ chit, ǹnyi te, uza̱ ká̱ nɗaktak ka̱ apal wó ǹyangmata̱. Uza̱ ka̱ mɓəp pa̱, <<Mi nəm sang ka̱ apal ayen mi yà?>> > ");
INSERT INTO yer_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","<<Te ɓu ga mpyal ká̱ achen ɓu ga ɓu chu atak ìnang ìkun iga aTabor. Ka̱ ta te, ɓu gwang onəm pa̱ oshatɗing ova ka̱ ngga nnəm awop Înan ka̱ aBetel. Uro ká̱ ivan iɓəl pa̱ shatɗing, uro ká̱ nzəngkəng pa̱ nshatɗing, kang uga ushatɗing ká̱ ndəng ìba̱ngba̱ng ka̱ ashe ìza̱mɓar. ");
INSERT INTO yer_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Oza̱ i re anung a ɓu kang i yichi nzəngkəng a ɓu pa̱ mparəm, te ɓu ka̱m ka̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","<<Ka̱ nvəva̱ng te, ɓu ga aGibeya Inan, atak va oshozha oFilisti ra apa̱k kà̱. Ɓu ga ɓu dat ká̱ ìtong te, ɓu gwang ìdonkong onəm oga nka̱m nre ka̱ atak Inan kà̱ nfəng ka̱ atak awop aga aɗuktum. Kà̱ mpyal oza̱ te, mmá ka̱ nnə́m aɓwa, ká̱ aɓwa acham, ká̱ ìganggáng, ká̱ mɓur ìzur, ká̱ ngba̱p nza̱m, kang oza̱ kà̱ nlà nre Inan. ");
INSERT INTO yer_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","ARuhu aYawe i vàng ka̱ apal ɓu ká̱ ichumchum, te ɓu là nre Inan, kang ɓu ga̱ɓa̱n ɓu wal unəm ukak. ");
INSERT INTO yer_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Ka̱ nva̱ngva̱ oga iya̱m va̱ ta fa chit, te wa nəm iya̱m iva pa̱ kpaktak awo ɓu ya məma pa̱ u nəm, ka̱kul Inan ya yà nzəng ká̱ ɓu. ");
INSERT INTO yer_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","<<Ga aGilgal kang mi ɓa. Mi ɓa mi ya ɓu ka̱ ta kang mi yichi nləfər ngga nshì pa̱ ɗwot ká̱ iya̱m inana iga ntəm ikángkáng. Ǹnyi te, nkpak pa̱ u lok ka̱ ta nra pa̱ nfangshat ya ɓa mi chu, mi nlà iya̱m va̱ a ɓu ɓu nəm kang.>> ");
INSERT INTO yer_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Nva̱ngva̱ uShawulu ga̱ɓa̱n chit kà̱ ngga, te Inan ga̱ɓa̱n ìgugwak. Kang nkpaktak oga ǹnyám ipir nnap va̱ uSamuwel là te, á yə́l n̂da va ta. ");
INSERT INTO yer_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Awalang va̱ uShawulu ká̱ ukpari wò ɓa chu aGibeya te, ìdonkong onəm oga nka̱m nre ka̱ atak Inan ɓa gwang na, kang aRuhu Inan vàng ka̱ apal ishishi ká̱ ichumchum te, uza̱ gwang ishi ká̱ oza̱ ka̱ nlà nre Inan. ");
INSERT INTO yer_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Awalang va̱ nkpaktak onəm va̱ nyi na nyi kang a fe na kà̱ nlà nre Inan nzəng ka̱ onəm oga nka̱m nre ka̱ atak Inan te, oza̱ ɓəp owan oza̱ pa̱, <<Iza̱ ya uya aKish yà? UShawulu yà unəm uga nka̱m nre ka̱ atak Inan chit kpa ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Unəm uro ka̱ ashe onəm oga atak va̱ ta na ama̱n pa̱, <<Uda upo oza̱ yà?>> Ka̱kul nva̱ ta te, á sat ngba nnap pa̱, <<UShawulu ka̱ ashe onəm oga nka̱m nre ka̱ atak Inan kpa ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Nva̱ngva̱ uShawulu gba̱l ká̱ nlà nre Inan chit, te uza̱ kyen ga atak awop aga aɗuktum. ");
INSERT INTO yer_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","UKyan aShawulu ɓəp na ká̱ ukparikpari pa̱, <<Ó ga che yà?>> Te uza̱ là pa̱, <<Í ga mmwo oga azhaki. Kang nva̱ngva̱ í ya pa̱, i ya ka̱t, te í ga atak aSamuwel.>> ");
INSERT INTO yer_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Te uKyan aShawulu là pa̱, <<Là á mi iya̱m va̱ uSamuwel là á ɓu á.>> ");
INSERT INTO yer_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Kang uShawulu là ûkyan wò pa̱, <<Uza̱ là á yi pa̱ mmá ya oga azhaki va̱ chit.>>Ǹnyi te, uza̱ là iya̱m iro ûkyan wò ka̱ apal nnap iponzhi va̱ uSamuwel là á na ka̱t. ");
INSERT INTO yer_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","USamuwel wór nkpaktak oIsa̱rila kà̱ mpyal aYawe ka̱ aMizpa, ");
INSERT INTO yer_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","kang uza̱ là ôza̱ pa̱, <<Iya̱m va ta̱ uYawe, Inan oIsa̱rila là, <N fa ká̱ aIsa̱rila ka̱ ashe aMasar, kang n fa ká̱ wó ka̱ akum ichumchum aMasar ká̱ nkpaktak oga mbin va̱ nyán ká̱ wo á.> ");
INSERT INTO yer_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Ǹnyi te, ǹyangmata̱ ó yang ká̱ Inan wó chit, uva fa ká̱ wó ka̱ ashe nkpaktak mɓək anung ká̱ oga nɗaktak wó. Kang ó là pa̱, <Pa ka̱t, mmá kyer uponzhi á yi.> Ǹyangmata̱ te, ó ɓa mpyal aYawe, akum ká̱ akum, kang nzhi ká̱ nzhi.>> ");
INSERT INTO yer_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Awalang va̱ uSamuwel ɓa ká̱ nkpaktak akum ìjili oIsa̱rila kà̱ mpyal aYawe te, mmá yak akum ìjili aBenjamin ka̱ atak mmàng ayàk. ");
INSERT INTO yer_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Te uza̱ ɓa ká̱ akum ìjili aBenjamin nzhi ká̱ nzhi, kang ayàk ga ru ka̱ apal akum aMatiri. Kà̱ nkukur te, ayàk ga ru ûShawulu uya aKish. Ǹnyi te, oza̱ mwo na kang oza̱ ya na ka̱t. ");
INSERT INTO yer_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Te oza̱ ɓəp uYawe kà̱ɗi pa̱, <<Unəm va̱ ɓa chit ka̱ ta̱ ɗò?>> Kang uYawe là pa̱, <<À, uwa bwam ka̱ ashe iya̱m iɓutɓut.>> ");
INSERT INTO yer_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Te oza̱ ga ɓa ka̱ na, kang nva̱ uza̱ sat ka̱ ìshimshe onəm te, uwa mak ji onəm pa̱ kpaktak ká̱ ìrup ashar pa̱ zəng. ");
INSERT INTO yer_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","USamuwel là n̂gkpaktak onəm pa̱, <<Unəm va ta̱ uYawe yak pa̱ á yà uponzhi wó. Unəm uro yà wa njini ka̱ ashe nkpaktak onəm ka̱t.>> Te nkpaktak onəm bà achu pa̱, <<Re irirì aponzhi á ganggáng.>> ");
INSERT INTO yer_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Te uSamuwel nyám ônəm apir inok va̱ uponzhi i nəm ká̱ iva̱ onəm i nəm ûponzhi. Kang uza̱ lir ka̱ apal awa achəndərchəndər, uza̱ nak kà̱ mpyal aYawe. Kang uSamuwel re onəm le nzhi oza̱ kà̱ɗi. ");
INSERT INTO yer_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","UShawulu ga nzhi wò kpa ka̱ aGibeya, nzəng ká̱ onunggwan oga nkám ìgwak, ovəngva̱ Inan dok igwak oza̱. ");
INSERT INTO yer_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Ǹnyi te, onəm oro oga nɗom ntəm ikángkáng ka̱t là pa̱, <<Wa nsang kang unəm va̱ ta̱ i ka̱m ishi yi yà?>> Oza̱ ɓak na, kang oza̱ yang ká̱ ngga ká̱ imwa á na. Ká̱ nna te, uShawulu nak ishi ká̱ oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","UNahash uponzhi uga aAmmon ɓa ru aJabesh Gileyat ká̱ ìkum. Kang nkpaktak onunggwan oga aJabesh là á na pa̱, <<Yar nsar nnap-nlà ká̱ yi, te í yà ozwal ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Ǹnyi te, uNahash na ama̱n pa̱, <<Mi yar nsar nnap-nlà ká̱ wó ka̱ apal iya̱m va ta̱ na cwat pa̱, nza̱ unəm nggo te, mi tur ìwu iga awo ari á na, na á ta̱l iya̱m ìwuswa n̂gkpaktak oIsa̱rila.>> ");
INSERT INTO yer_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Te onəmgbak oga aJabesh là á na pa̱, <<Ná nra á yi pa̱ nfangshat na í re nre ká̱ onəm oga nre a ga ka̱ ashe nkpaktak aIsa̱rila kang. A yà pa̱, í ya unəm va̱ i ka̱mshi yi ka̱t, te í na ishi yi a ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Awalang va̱ onəm oga nre va̱ ta ɓa chu aGibeya va uShawulu i təm kà̱ kang à là nnap va̱ ta ônəm te, nkpaktak onəm bà ayə́ng. ");
INSERT INTO yer_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","UShawulu kà̱ nle ka̱ atak nshàng ìram ká̱ ina na byet, te uza̱ ɓəp pa̱, <<Iza̱ i ɗak onəm yà? Sang kang mí bà ayə́ng wa nta̱ yà?>> Te oza̱ là á na iya̱m va̱ onəm oga aJabesh là. ");
INSERT INTO yer_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Awalang va̱ uShawulu fe nnap-nlà va̱ ta te, aRuhu Inan vàng ka̱ apal ishishi ká̱ ichumchum, kang ìgwak lak na pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Uza̱ wur ina pa̱ iparəm pà, nyat izhizhe pa̱ nyimənyimən, kang a re onəm oga nre ká̱ pa̱ á ga ká̱ ka̱ ashe nkpaktak oIsa̱rila, oza̱ á là pa̱, <<Iya̱m va ta̱ mí nəm ká̱ ina ánəm va̱ yang ká̱ nyar nva̱ng aShawulu ká̱ uSamuwel ka̱ atak ìkum.>> Te ayər aYawe fər ka̱ apal ishi onəm kang oza̱ fa wa anəm pa̱ uzəng. ");
INSERT INTO yer_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Awalang va̱ uShawulu ɓut oza̱ ka̱ aBezek, kang uza̱ kung onəm te, uza̱ ya onunggwan oga aIsa̱rila ìkalong ìgba̱l pa̱ ishatɗing, kang ovəngva̱ ka̱ aYahudi ìkalong ìsəm pa̱ ishatɗing. ");
INSERT INTO yer_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Oza̱ là ônəm oga nre va̱ mmá re ɓa pa̱, <<Ó là ônunggwan oga aJabesh Gileyat,<Ìpin, awalang va̱ alum i chu apal ndəng chit, te mí ka̱m ishi wó.> >> Nva̱ngva̱ onəm oga nre va̱ ta ga là ônunggwan oga aJabesh chit, te ìgwak chàng oza̱ pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Oza̱ là ôAmmon pa̱, <<Ìpin te, í ga nna ishi yi á wó, na ó nəm iya̱m va pa̱ káp ó ɗom nəm ka̱ yi.>> ");
INSERT INTO yer_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Ká̱ ìzwam te, uShawulu kap onunggwan ìdonkong pa̱ ishatɗing. Kang ká̱ ìɓotak oza̱ ɓa táng ashe apa̱k oAmmon, kang à gbá̱ng oza̱ ga chu alum ka̱ apal ndəng. Ovəngva̱ lár te, oza̱ lyangshin, ɓu yà ká̱ ǹya onəm pa̱ oparəm ka̱ atak azəngtəng ka̱t. ");
INSERT INTO yer_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Te onəm là ûSamuwel pa̱, <<Oda va̱ ka̱ là pa̱, <UShawulu i nəm iponzhi ka̱ apal yi ka̱t> yà? Mmá ɓa ká̱ oza̱ á yi na í gbá̱ng oza̱.>> ");
INSERT INTO yer_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Ǹnyi te, uShawulu là pa̱, <<Mí yà ká̱ ngba̱l unəm uro n̂da ata̱ ka̱t, ka̱kul n̂da ta̱ uYawe ɓa ká̱ nka̱m ishi ngga irirì ôIsa̱rila chit.>> ");
INSERT INTO yer_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Te uSamuwel là ônəm pa̱, <<Ó ɓa, re í ga aGilgal na í nyám ká̱ iponzhiponzhi kà̱ɗi.>> ");
INSERT INTO yer_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Te nkpaktak onəm ɓa ga aGilgal, kang à kyer uShawulu kà̱ mpyal aYawe təm uponzhi. Ka̱ ta te, oza̱ yichi iya̱m inana iga ntəm ikángkáng ûYawe, kang uShawulu ká̱ nkpaktak oIsa̱rila nəm nchàng izər pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Te uSamuwel là n̂kpaktak oIsa̱rila pa̱, <<N gwong achwang chit kà̱ nkpaktak iya̱m va̱ ó là á mi, kang n na uponzhi á wó chit pa̱ á nəm ká̱ wó. ");
INSERT INTO yer_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Ǹyangmata̱ te, na ó yà ká̱ uponzhi, uwa unəm uga mpyal wó. Mmami te, n gbák chit, kang izwál fa á mi chit, ǹnyi te, ovan mi onunggwan oma yà nzəng ká̱ wó. M ɓàn nlə́p mpyal a wó, ya na ka̱ n yà uyenza̱m á ɓa chu n̂da va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Mmami na ta̱, ó nyám ká̱ iya̱m va̱ á mi n nəm ɓa̱ng ka̱ mpyal aYawe ká̱ ugargargargar. ÌNa ada n vyat yà? AZhaki áda n vyat yà? Uda n ka̱r na yà? Uda m mwar na yà? N ka̱m iya̱m ka̱ atak áda pa̱ na ń ka̱r nnandər ká̱ yà? A yà pa̱ n nəm iya̱m iro nəm ka̱ ashe oga iya̱m va̱ ta̱ te, mi mwa anunung.>> ");
INSERT INTO yer_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Oza̱ na ama̱n pa̱, <<U m mwar yi ka̱t, ka̱t te u ka̱r yi ka̱t. U ka̱m iya̱m iro kà̱ unəm uro pa̱ na ú ka̱r nnandər ká̱ ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Te uSamuwel là ôza̱ pa̱, << UYawe uwa kà̱ ǹya wó, kang ugargargargar uwa ka̱ ǹya wó nda va̱ ta̱ kpa, pa̱ ó ya iya̱m iro ka̱ awo mi ka̱t.>> Kang oza̱ là pa̱, <<Uza̱ uwa ka̱ ǹya.>> ");
INSERT INTO yer_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Te uSamuwel là ônəm pa̱, <<UYawe uwa yak uMusa ká̱ uHaruna kang à fa ká̱ okəka wó ka̱ ashe mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Ǹyangmata̱ te, ó tong pa̱ kwak, mmami kà̱ ngga ń rəng ká̱ a wó ka̱ mpyal aYawe, oga nnap-nnəna̱n ngga nka̱m ishi va̱ uYawe nəm ka̱kul wó ká̱ okəka wó á. ");
INSERT INTO yer_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","<<Awalang va̱ uYakup wa ka̱ aMasar te, oza̱ yar ayə́ng ûYawe ka̱kul nka̱m ishi. Kang uYawe re nre ká̱ uMusa ká̱ uHaruna, ova fa ká̱ okəka wó ka̱ ashe aMasar, kang á nak oza̱ təm kà̱ mbin va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Ǹnyi te, oza̱ kong ká̱ uYawe, Inan oza̱. Kang uYawe yap ká̱ oza̱ ka̱ ashe awo aSisəra, unəm uga mpyal oshozha oga aHazor, kang ka̱ ashe awo oFilisti, ká̱ uponzhi uga aMowap, ova lung oza̱. ");
INSERT INTO yer_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","<<Te oza̱ yə́ng ûYawe kang à là pa̱, <Í nəm nnap-mɓá̱ngɓa̱ng chit, ka̱kul í re ngwop uYawe chit, í wop oga aBaal ká̱ oga aAshtoret. Ǹnyi te, ǹyangmata̱, ka̱m ishi yi ka̱ ashe awo okpa ìkum yi, te í le í wop ɓu.> ");
INSERT INTO yer_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Te uYawe re nre ká̱ uJerup-Baal, ká̱ uBarak, ká̱ uJepta, ká̱ uSamuwel, kang uza̱ ka̱m ishi wó ka̱ ashe awo okpa ìkum wó kà̱ nza̱ ngba̱k nggo, kang ó təm ká̱ ikángkáng. ");
INSERT INTO yer_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","<<Ǹnyi te, awalang va̱ ó ya uNahash uponzhi oAmmon kà̱ mɓa ka̱ apal wó, te ó là á mi pa̱, <Pa ka̱t, í ɗom uponzhi pa̱ á nəm iponzhi ka̱ apal yi,> káp ká̱ nva̱ pa̱, uYawe, Inan wó uwa uponzhi wó á. ");
INSERT INTO yer_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Ǹyangmata̱, ó dər uponzhi va̱ ó yak, uva ó ɓəp pa̱ mmá na wó, te uYawe na á wó chit. ");
INSERT INTO yer_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","A yà pa̱ ó nəm ayər aYawe, ó wop na, ó kpak nnap-nnəm á na, ó yáng nkpak nnap-mpakpakpakpak ka̱t, kang a yà pa̱ mmawó ká̱ uponzhi va̱ i nəm ká̱ wó, ó le ó yar nva̱ng aYawe, Inan wó, te ó təm ká̱ ikángkáng. ");
INSERT INTO yer_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Ǹnyi te, a yà pa̱ ó kpak nnap-nnəm ûYawe ka̱t, kang a yà pa̱ ó fa iya̱mkak ka̱ apal oga nnap-mpakpakpakpak, te uza̱ i nyám ntàn á wó wa nva̱ uza̱ ka̱ nyám ôkəka wó á. ");
INSERT INTO yer_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","<<Ǹyangmata̱ te, ó tong pa̱ kwak, na ó ya iya̱m ichumchum va̱ uYawe kà̱ ngga nnənəm kà̱ mpyal wó. ");
INSERT INTO yer_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Ǹyangmata̱, awalang aga nkpám ìbəshi ka̱t ɗò? Mi ngga nfar ûYawe pa̱, á re nre ká̱ ìva̱r ká̱ ìgbarman. Te ó nyi iya̱m inga va̱ ó nəm kà̱ mpyal aYawe, nva̱ ó ɓəp pa̱ mmá na uponzhi a wó á.>> ");
INSERT INTO yer_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Te uSamuwel far ûYawe, kang uYawe re nre ká̱ ìva̱r ká̱ ìgbarman n̂da nva̱ ta. Kang nkpaktak onəm tong nəm ayər aYawe ká̱ uSamuwel. ");
INSERT INTO yer_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Te oza̱ là ûSamuwel pa̱, <<Far ûYawe, Inan ɓu ka̱kul yi, le kang í kú ka̱t. Í nəm nnap-mɓá̱ngɓa̱ng á na chit pa̱ makmak, kang ǹyangmata̱, í nəm á na chit kà̱ɗi ka̱ atak mɓəp uponzhi.>> ");
INSERT INTO yer_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","USamuwel là ônəm pa̱, <<Kang ayər a nəm wó ka̱t. Káp ká̱ nva̱ pa̱ ó nəm nnap-mɓá̱ngɓa̱ng chit, ka̱ nna te, kang ó ga̱ɓa̱n ó re uYawe ka̱t. Ka̱kul nva̱ ta te, ó wop uYawe ká̱ nkpaktak ìgwak wó. ");
INSERT INTO yer_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Kang ó ga̱ɓa̱n ó wop ichər iya̱m ilakchilakchi ka̱t. Oza̱ yà ká̱ nka̱mshi ka̱t, le kang oza̱ i fa ká̱ wó, ka̱kul oza̱ iya̱m ilakchilakchi. ");
INSERT INTO yer_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Ka̱kul aɗin aYawe achumchum te, uza̱ i yà ká̱ ǹyang ká̱ onəm wò ka̱t. Ka̱kul uYawe uwa ya ma pa̱ ô yak wó, ó yà onəm wò. ");
INSERT INTO yer_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Mmami nnyi te, mi yà ká̱ nnəm nnap-mɓá̱ngba̱ng uYawe ka̱ atak nre nfar afar ka̱kul wó ka̱t, kang mi ɗyang asa̱l anəna̱n a wó aga nnəm nnandər. ");
INSERT INTO yer_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Ǹnyi te, ó nəm ayər aYawe, ó wop na ká̱ nnandər ká̱ nkpaktak ìgwak wó. Ó rəng oga iya̱m ichumchum va̱ uza̱ nəm ka̱kul wó á. ");
INSERT INTO yer_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Kang a yà pa̱ ó ga mpyal ká̱ nnəm nnap-mɓá̱ngɓa̱ng, te mmawó ká̱ uponzhi wó ó zhì.>> ");
INSERT INTO yer_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","UShawulu ri iponzhi ya uwa yà ká̱ izun ìsəm pa̱ ishatɗing, kang uza̱ nəm iponzhi ka̱ apal oIsa̱rila ìzun ìsəm pa̱ ineɗing ama̱n pa̱ parəm. ");
INSERT INTO yer_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","UShawulu yak onunggwan ìkalong pa̱ ishatɗing ka̱ ashe oIsa̱rila. Uza̱ nak ìkalong pa̱ ìparəm nzəng ká̱ na ka̱ aMikmat ká̱ mbin aɗuktum aga aBetel, kang ìkalong pa̱ ìzəng nzəng ká̱ uJonatan ka̱ aGibeya kà̱ mbin aBenjamin. Te uza̱ re aɓo onunggwan le nzhi oza̱. ");
INSERT INTO yer_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","UJonatan ru ìdonkong oshozha oFilisti ká̱ ìkum ka̱ apa̱k oza̱ ka̱ aGeba, kang oFilisti fe nnap va̱ ta. Te uShawulu nak mmá ɓur agbəshi ka̱ ashe nkpaktak mbin oIsa̱rila, kang à là pa̱, <<Re oHiburu á fe.>> ");
INSERT INTO yer_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Te nkpaktak oIsa̱rila fe nnap va̱ ta pa̱, <<UShawulu ru ìdonkong oshozha oFilisti chit ká̱ ìkum, kang ǹyangmata̱ te, oIsa̱rila sat onəm oga ajan chit ka̱ mpyal oFilisti.>> Te mmá wor onəm ɓut pa̱ á gwang uShawulu ka̱ aGilgal. ");
INSERT INTO yer_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","OFilisti ɓut pa̱ na ó lung oIsa̱rila, ká̱ oga akeke ipəri ìkalong ìsəm pa̱ ishatɗing, ká̱ onəm oga nkwak ipəri ìkalong pa̱ ìkpa̱ɗing, ká̱ oshozha yə́l yà ká̱ nkung ka̱t. Oza̱ ga ra apa̱k ka̱ aMikmat ka̱ asa̱l nfa alum aBet Aven. ");
INSERT INTO yer_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Awalang va̱ oIsa̱rila ya pa̱ ìkum sur chit, kang okpa ìkum kà̱ nlung oza̱ pa̱ gənggəng, te oza̱ bwam ka̱ ashe oga agba̱k, ká̱ ipəpa, ká̱ ishimshe ipang, ká̱ oga ache, kang ká̱ oga ache ndəng nka̱pka̱p. ");
INSERT INTO yer_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Oro ka̱ ashe oza̱ pa̱ng awang aUrdun, ga mbin aGat ká̱ aGileyat. Ǹnyi te, uShawulu ta̱l ka̱ aGilgal, kang nkpaktak onəm va̱ ká̱ na ka̱ ntán ká̱ ayər. ");
INSERT INTO yer_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Uza̱ lok ka̱ aGilgal nra pa̱ nfangshat pa̱ ô gwang ká̱ uSamuwel, wa nva uSamuwel ka̱ là á na, ǹnyi te, uSamuwel ɓa ka̱t, kang onəm aShawulu ɓàn nlyangshin. ");
INSERT INTO yer_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Te uShawulu là pa̱, <<Mmá ɓa ká̱ iya̱m inana iga nshì pa̱ ɗwot, ká̱ iga ntəm ikángkáng á mi.>> Kang uShawulu yichi nləfər ngga nshì. ");
INSERT INTO yer_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","UShawulu kà̱ ngba̱l ká̱ ǹyichi iya̱m inana iga nshì va̱ ta byet, te uSamuwel ɓa chu, kang uShawulu fa pa̱ ô gwang na, ô re anung á na. ");
INSERT INTO yer_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Te uSamuwel ɓəp na pa̱, <<Iza̱ u nəm ta̱ yà?>> UShawulu na ama̱n pa̱, <<N ya onunggwan kà̱ nlyangshin, kang nna ka̱ u ɓa chit ka̱t, ka̱ awalang va̱ u nak á, kang oFilisti oma ɓut ka̱ aMikmat. ");
INSERT INTO yer_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","Te n rəng pa̱, <OFilisti iga nru mi ká̱ ìkum ǹyangmata̱ ka̱ aGilgal, kang nna ka̱ n chal uYawe chit ka̱kul nka̱mshi ka̱t.> Te n ya məma pa̱ ń yichi nləfər.>> ");
INSERT INTO yer_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","USamuwel là pa̱, <<U nəm mpərək. U kpak nnap-nlà aYawe, Inan ɓu nva̱ uza̱ na a ɓu ka̱t. Ká̱ yà pa̱ u kpəkpak te, uYawe ká̱ pak akum iponzhi ɓu ka̱ apal oIsa̱rila mbyet. ");
INSERT INTO yer_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Te ǹyangmata̱ akum iponzhi ɓu i təm mbyet lap ka̱t, ka̱kul uYawe yak unəm chit uva ɗom ìgugwak. Uza̱ kyer na chit pa̱ á yà unəm uga mpyal onəm wò, ka̱kul u kpak nnap-mpakpak aYawe ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Te uSamuwel wong re aGilgal ga aGibeya kà̱ mbin aBenjamin. Kang uShawulu kung aɓo oshozha va̱ nzəng ká̱ na te, uza̱ ya ìgba̱l pa̱ ìkpa̱ɗing. ");
INSERT INTO yer_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","UShawulu ká̱ uyen wò, uJonatan ká̱ oshozha va̱ nzəng ká̱ oza̱ ka̱ yà ka̱ ntəm ka̱ aGeba ka̱ ashe mbin aBenjamin, ǹnyi te, oFilisti ra apa̱k oza̱ ka̱ aMikmat. ");
INSERT INTO yer_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Oshozha oFilisti fa ka̱ ashe apa̱k, kap ìdonkong pa̱ ishatɗing. Ìdonkong iga ìzəng ga asa̱l mpal aOfəra ka̱ ashe mbin aShuwal, ");
INSERT INTO yer_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","ìdonkong iga ìparəm ga asa̱l aBet Horon, kang ìdonkong iga ishatɗing ga asa̱l ìsu aswari va̱ dər asa̱l mba̱nda̱m aZeboyim ava dər ashe nzam. ");
INSERT INTO yer_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Onəm oga nla ala yà ka̱ ashe mbin oIsa̱rila ka̱t, ka̱kul oFilisti là pa̱ <<Kang oHiburu a la oga ndokchi ká̱ oga aɓár ka̱kul ishi oza̱ ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","A nak te, nkpaktak oIsa̱rila i ga atak onəm oga nla ala oFilisti ka̱kul ntan anung oga ashan, aɗyə̀r, ikù, ká̱ ika oza̱. ");
INSERT INTO yer_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Amwa ka̱kul ntan anung ashan ina ka̱t te aɗyə̀r te, uparəm ka̱ apal ashatɗing ashekel, kang ka̱kul ikù ka̱t te iya̱m iga mɓak ina oza̱ te, uzəng ka̱ apal ashatɗing ashekel. ");
INSERT INTO yer_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","N̂da va̱ ìkum wong te, mmá ya unəm uro ka̱ ashe oIsa̱rila ká̱ ndokchi ka̱t te, ká̱ aɓár ka̱t, uShawulu ká̱ uJonatan, oma ká̱ byet. ");
INSERT INTO yer_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Te oFilisti re nre ká̱ ìdonkong oshozha pa̱ á pángchí asa̱l aga ntar aMikmat. ");
INSERT INTO yer_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","N̂da nro te, uJonatan uya aShawulu là ûkpari wò uga yar iya̱m ìkukum pa̱, <<Ɓa, í pa̱ng mba̱nda̱m í ga apa̱k oFilisti.>> Ǹnyi te, uza̱ là ûpo wò ka̱t. ");
INSERT INTO yer_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","UShawulu ká̱ onunggwan wò ìgba̱l pa̱ ìkpa̱ɗing oma ká̱ nra apa̱k ká̱ nkur aGibiya ka̱ avəng ìkun ìkúmkúm ka̱ aMigron. ");
INSERT INTO yer_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Ka̱ ashe onunggwan aShawulu te, uAhija unəm uga mpyal awop uwa yà ka̱ ashe oza̱, uva pa ìlukwan ìkwoksok. UAhija uya aAhitup, ugənang aIkabot, uya aFinehas, uka aEli, unəm uga mpyal awop ka̱ aShilo. UNəm uro yà nyi pa̱ uJonatan re ashe oIsa̱rila chit ka̱t. ");
INSERT INTO yer_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Asa̱l va̱ uJonatan ɗom n wòl kà̱ kang o ga atak apa̱k oFilisti te, kà̱ ishimshe aɓam pa̱ parəm ava unəm uro i chu nkyen kà̱ oga ngba̱k oza̱ ka̱t. Aɓam aro mí wór pa̱ aBozet, kang azəngtəng mí wór pa̱ aSene. ");
INSERT INTO yer_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Aro ka̱ asa̱l mpal a dər aMikmat, kang aro ka̱ asa̱l nkwandal a dər aGeba. ");
INSERT INTO yer_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","UJonatan là ûnəm uga ǹyar iya̱m ìkum á na pa̱, <<Ɓa, í pa̱ng atak apa̱k onəm oga ache amulur va̱ ta̱. Mwote, uYawe a na igwan a yi nggo. Iya̱m iro yà i gəl uYawe kà̱ nna ìgwan ka̱ atak onəm ìkum pa̱ kyák ka̱t te pa̱ ɗa̱p ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Te unəm uga ǹyar iya̱m ìkum á na là pa̱, <<Nəm iya̱m va u ya məma á, nna n yà nzəng ká̱ ɓu ka̱ ashe iya̱m va̱ u ɗom nnənəm.>> ");
INSERT INTO yer_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","UJonatan là á na pa̱, <<Ɓa na í pa̱ng na oza̱ á ya yi. ");
INSERT INTO yer_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","A yà pa̱ oza̱ là á yi pa̱ í tong ka̱ atak va̱ mmayi kà̱, kang ô ɓa ô ya yi te, í tong í yà ká̱ ngga atak oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Ǹnyi te, a yà pa̱ oza̱ là pa̱ ì ɓa atak oza̱ te, í kyen í ga. Nna ta i nyám pa̱ uYawe i ga nka̱mshi yi, í nəm igwan ká̱ oza̱.>> ");
INSERT INTO yer_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Nna chit te, mparəm oza̱ fa nyám ishi oza̱ ôFilisti. OFilisti là pa̱, <<Dər, oHiburu ka̱ nnár i fa ka̱ ashe ache atak va̱ oza̱ bwam kà̱.>> ");
INSERT INTO yer_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Te onəm ka̱ ashe apa̱k wór uJonatan ká̱ unəm uga ǹyar iya̱m ìkum á na pa̱, <<Ó ɓa, na í ɗyang ntan a wó.>> UJonatan là ûnəm uga ǹyar iya̱m ìkum wò pa̱, <<Kyen, yar nva̱ng mi, ka̱kul uYawe na oza̱ chit ka̱ ashe awo oIsa̱rila.>> ");
INSERT INTO yer_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Te uJonatan kyen aɓam va̱ ta i nár ká̱ irəng ká̱ awo, ká̱ unəm uga ǹyar iya̱m ikum á na. Te oFilisti tak kà̱ mpyal aJonatan kang unəm uga ǹyar iya̱m ikum á na, yar nvəva̱ng gbá̱ng oza̱. ");
INSERT INTO yer_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Onunggwan va̱ uJonatan ká̱ unəm uga ǹyar iya̱m ìkum á na gbá̱ng nggəshi te, á chu ìsəm pa̱ ìparəm chu ka̱ ashe agbagba va á chu nshang iram ina chu ilum pa̱ ìzəng. ");
INSERT INTO yer_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Te ayər nəm nkpaktak oshozha, ovəngva̱ ka̱ ashe apa̱k ká̱ ovəngva̱ ka̱ agbagba ìkum, káp ká̱ oshozha oga mpángchí atak ká̱ oga nlə́p mpyal ìkum, kang mbin tan. Inan uwa nak ayər va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Oshozha oga mpángchí atak aShawulu ka̱ aGibeya aga mbin aBenjamin, ya oshozha oFilisti zwar kang ka̱ nlyangshin. ");
INSERT INTO yer_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Te uShawulu là ônunggwan wò pa̱, <<Ó kung oshozha na ó nyi unəm va̱ yà ka̱t.>> Nva̱ngva̱ oza̱ kung te, oza̱ ya uJonatan ká̱ unəm uga ǹyar iya̱m ìkum á na yà ka̱t. ");
INSERT INTO yer_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","UShawulu là ûAhija pa̱, <<Ɓa ka̱ akwati aga nsar nnap-nlà Inan ka̱ ta̱.>> Ka̱ awalang va̱ ta te, akwati aga nsar nnap-nlà Inan nna ka̱ yà nzəng ká̱ oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Nva̱ uShawulu ka̱ yà ka̱ nlà nnap ká̱ unəm uga mpyal awop te, nzwar ka̱ ngga mpyal ka̱ ashe apa̱k oFilisti. Te uShawulu là ûnəm uga mpyal awop pa̱, <<Kang á ɗak ɓu ka̱t, í ga.>> ");
INSERT INTO yer_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Te uShawulu ká̱ nkpaktak onunggwan wò ɓut kang à ga atak ìkum. Kang oza̱ ga ya oFilisti zwar chit pa̱ makmak, le í gbá̱ng owan oza̱ ká̱ ndokchi. ");
INSERT INTO yer_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","OHiburu va̱ ka̱ yà nzəng ká̱ oFilisti kang a ga nzəng ká̱ oza̱ ka̱ apa̱k oza̱ te, á le ga atak oIsa̱rila va̱ ka̱ yà nzəng ká̱ aShawulu ká̱ uJonatan á. ");
INSERT INTO yer_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Awalang va̱ nkpaktak oIsa̱rila va̱ ka̱ bwam ka̱ ashe aɗuktum aga mbin aEfrayim fe pa̱ oFilisti kà̱ nchəng te, oza̱ fa gwang ɓak oza̱ ká̱ ìkum kpa. ");
INSERT INTO yer_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Te uYawe ka̱m ishi oIsa̱rila n̂da va̱ ta, kang onəm lung ìkum ga watar aBet-Aven. ");
INSERT INTO yer_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Ǹyangmata̱ te, oshozha oIsa̱rila bəlak byet n̂da va̱ ta, ka̱kul uShawulu ka̱ yar nsóng anung chit pa̱, <<Unəm va̱ a ri iya̱m-nrì kang arurong i nəm te, re Inan á vyap na, ya mi pyat nnàp ka̱ apal oFilisti kang.>> Te unəm uro yà ri iya̱m iro n̂da va̱ ta ka̱t. ");
INSERT INTO yer_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Nkpaktak oshozha táng ashe ikun te, oza̱ ya mmàl irizhe kà̱ mbin. ");
INSERT INTO yer_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Awalang va̱ oza̱ táng ashe ikun te, oza̱ ya mmàl irizhe kà̱ nwàr, ǹnyi te, unəm uro yà dok ká̱ ifang ga ká̱ ka̱ anung wò ka̱t. Ka̱kul oza̱ nəm á yər nsóng anung va. ");
INSERT INTO yer_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Ǹnyi te, uJonatan uwa ka̱ fe chit pa̱ upo wò sóng anung chit ka̱t, te uza̱ pa ishi idari va ká̱ awuwo ka̱ ashe mmàl irizhe. Te uza̱ nak ka̱ awo wò tam, kang uza̱ ya ìkam. ");
INSERT INTO yer_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Te uro ka̱ ashe oshozha là ûJonatan pa̱, <<Upo ɓu ka̱ sóng anung oshozha chit kəkam pa̱, <Unəm va̱ i ri iya̱m-nrì n̂da ta̱ te, i vyap.> Nna nak te, onunggwan bəlak á yà ká̱ ikam ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Te uJonatan là pa̱, <<Upo mi ɓa kà̱ nɗaktak chit ka̱ ashe mbin. Dər asa̱l awu va̱ n ya ìkam ká̱, nvəngva̱ n dok irizhe va̱ ta̱ pa̱ ɗa̱p á. ");
INSERT INTO yer_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Ka̱ yà pa̱ mmá ká̱ məma̱n ôshozha pa̱ á ri iya̱m-nrì va̱ oza̱ wur ka̱ atak okpa ìkum oza̱ te, mmá ka̱ gbá̱ng oFilisti ka̱ ji va̱ ta̱ ji ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","N̂da va̱ ta, nva̱ngva̱ oIsa̱rila ɓàn gbá̱ng oFilisti ka̱ aMikmat ga chu aAijalon te, oza̱ bəlak pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Oza̱ gba̱ng izər ka̱ ngwur iya̱m iga ngwur ka̱ atak ìkum, itam, ina, ká̱ ivan ina, kang oza̱ pà oza̱ ri ká̱ nchə̀chər. ");
INSERT INTO yer_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Te unəm uro là ûShawulu pa̱, <<Dər, onunggwan kà̱ nəm nnap-mɓá̱ngɓa̱ng ûYawe ka̱ atak nri izhé va ka̱ nchə̀r.>> UShawulu là pa̱, <<Ó vyap nnap-mpakpak chit. Ó ɓəndəng ìnang ìpang á mi ka̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Te uza̱ là pa̱, <<Ó ga ó là ônunggwan pa̱, <Udanggo á ɓa ká̱ ìna wò ká̱ ìtam wò á mi, kang ó pà oza̱ ka̱ ta̱ ó ri. Kang ó nəm mpat ûYawe ka̱ atak nri izhé kà̱ nchə̀chər ka̱t.> >> Te udanggo ɓa ká̱ ìna wò ká̱ izwam va̱ ta kang à pà ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Te uShawulu me atak nshi iya̱m awop ûYawe, nna ta, atak awop aga nggəshi va̱ uza̱ me. ");
INSERT INTO yer_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Te uShawulu là pa̱, <<Í fəng í ga na í ɓak oFilisti ká̱ izwam va̱ ta̱, í wur iya̱m oza̱ kang atak ì tan, kang í gbá̱ng oza̱, í re unəm uro ka̱ irirì ka̱t.>> Te oza̱ là pa̱, <<Nəm iya̱m va u ya məmal ká̱ ɓu.>> Ǹnyi te, unəm uga mpyal awop là pa̱, <<Re í ɓəp Inan kang.>> ");
INSERT INTO yer_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Te uShawulu ɓəp Inan pa̱, <<N ru oFilisti va̱ ta̱ ɗò? Ɓu na oza̱ na ka̱ ashe awo oIsa̱rila ɗò?>> Ǹnyi te, Inan na ama̱n a na n̂da va̱ ta ka̱t. ");
INSERT INTO yer_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Ka̱kul nva̱ ta te, uShawulu là pa̱, <<Ó ɓa ka̱ ta̱, nkpaktak onəm oga mpyal oshozha, re í mwo nnap-mɓá̱ngɓa̱ng va̱ mmá nəm chit n̂da va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Wa nva uYawe uga nka̱mshi oIsa̱rila wa ya te, n sóng anung ká̱ aɗiɗin, kang a yà pa̱ uyen mi uJonatan uwa nəm mpat va̱ ta̱ te, nkpak uza̱ i kú.>>Ǹnyi te, ushozha uro yà na ama̱n á na ka̱t. ");
INSERT INTO yer_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Te uShawulu là n̂kpaktak oIsa̱rila pa̱, <<Ó tong ka̱ ngba̱k pa̱ nzəng, kang mmami ká̱ uJonatan i tong ka̱ ngba̱k nro.>> Kang oza̱ là á na pa̱, <<Nəm iya̱m va̱ u ya məmal ká̱ ɓu á.>> ");
INSERT INTO yer_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Te uShawulu far ûYawe, Inan oIsa̱rila pa̱, <<Iza̱ nak kang u na ama̱n ûzwal ɓu ká̱ n̂da a ta̱ ka̱t yà? A yà pa̱ mpat kà̱ mmami ka̱t te uyen mi uJonatan te, wa ama̱n ká̱ aUrim ǹnyi te, a yà pa̱ onunggwan oga aIsa̱rila oma ká̱ mpat te, wa ama̱n ká̱ aTumim.>> Kang oza̱ mang ayàk te, ayàk ru ká̱ apal aJonatan ká̱ uShawulu, kang onungwan va̱ ta mmá ya oza̱ ká̱ mpat ka̱t. ");
INSERT INTO yer_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","UShawulu là pa̱, <<Ó mang ayàk ká̱ ishimshe mi ká̱ uyen mi, uJonatan.>> Kang ayàk ga yar uJonatan. ");
INSERT INTO yer_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Te uShawulu là ûJonatan pa̱, <<Là á mi, iza̱ u nəm yà?>> Kang uJonatan là á na pa̱, << N dok mmàl irizhe ká̱ ishi idari mi kang n tàm. Te ǹyangmata̱ nkpak pa̱ ń kú.>> ");
INSERT INTO yer_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","UShawulu là pa̱, << Re uYawe á ɓək anung á mi pa̱ gənggəng, a yà pa̱ u kú ka̱t á, aJonatan.>> ");
INSERT INTO yer_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Ǹnyi te, onunggwan va̱ ta là ûShawulu pa̱, <<A màl pa̱ uJonatan a kúkú á, uza̱ va ɓa ká̱ nnang nka̱mshi ôIsa̱rila ɗò? Nva̱ ta i yà ka̱ nnəm ka̱t. Wa nva uYawe wa ya te, akpap ishishi aro pa̱ zəng i ru ka̱ mbin ka̱t, ka̱kul Inan a ka̱mshi á na kang uza̱ nəm igwan va̱ ta̱ n̂da va̱ ta̱.>> Te onunggwan va̱ ta ka̱m ishi aJonatan, kang mmá gbá̱l na ka̱t. ");
INSERT INTO yer_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Te uShawulu re mɓàk oFilisti, kang oFilisti le nva̱ng ga mbin oza̱. ");
INSERT INTO yer_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Nva̱ngva̱ uShawulu yà uponzhi oIsa̱rila te, uza̱ lung nkpaktak okpa ìkum oza̱ ka̱ nza̱ nggba̱k nggo, oMowap, ká̱ oAmmon, ká̱ oEdom, ká̱ oponzhi oga aZobak, kang ká̱ oFilisti. Kang atak va kpaktak uza̱ ga ìkum kà̱ te, uza̱ nəm igwan. ");
INSERT INTO yer_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","Uza̱ lung ikum ká̱ nkam ipa̱ng, kang à nəm igwan ká̱ oAmalek. Uza̱ ka̱m ishi oIsa̱rila ka̱ ashe awo onəm va̱ ka̱ wur iya̱m oza̱ ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Ovan onunggwan áShawulu oma, uJonatan, ká̱ uYishwi, ká̱ uMalkishuwa. Kang aɗin ovəvan ochar, uMerap uwa uga nggəshi, ká̱ uMikal uwa uɓwakan. ");
INSERT INTO yer_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Aɗin achichar pa̱ uAhinowam, uyen uchar aAhima'az. Aɗin ánəm uga mpyal oshozha aShawulu pa̱ uAbner, uya aNer, kang uNer nnyi te, ukyan aShawulu. ");
INSERT INTO yer_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Upo aShawulu uKish ká̱ upo aAbner uNer, oma ovan aAbiyel onunggwan. ");
INSERT INTO yer_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","UShawulu nəm ìkum pa̱ gənggəng ká̱ oFilisti ka̱ ashe nkpaktak nra iponzhiponzhi. Kang ununggwan va uShawulu ya kəkam, ka̱t te ká̱ nkam ìgwak te, uza̱ i ɓa ká̱ na ka̱ ashe oshozha wò. ");
INSERT INTO yer_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Te uSamuwel là ûShawulu pa̱, <<UYawe re mi pa̱ n gor ɓu uponzhi ka̱ apal onəm wò oIsa̱rila. Ǹyangmata̱ te, gong achwang kà̱ nre va̱ ka̱ atak aYawe. ");
INSERT INTO yer_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Iya̱m va ta̱ uYawe uGa ngGatək là,<Mi ga nnyám ntàn oAmalek ka̱kul oza̱ ru oIsa̱rila ká̱ ìkum ka̱ awalang va̱ oza̱ fa ka̱ ashe mbin aMasar. ");
INSERT INTO yer_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Ǹyangmata̱ te, ga na u ru akum oAmalek ká̱ ìkum kang ɓu zhì nkpaktak iya̱m va̱ iji oza̱. Kang wa re oza̱ ka̱t, gbá̱ng onunggwan, ká̱ ochar, ká̱ ovan, ká̱ ovan oba̱k, ká̱ ina, ká̱ itam, ká̱ oga alakəmi, kang ká̱ oga azhaki.> >> ");
INSERT INTO yer_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Te uShawulu ɓut oshozha wò ka̱ aTəleyim, kang a kung oza̱ te, uza̱ ya ìkalong ìgba̱l pa̱ ìparəm ka̱ aɓoshi akum aIsa̱rila, kang ìkalong pa̱ ìgba̱pchi ka̱ aYahudi. ");
INSERT INTO yer_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Te uShawulu ga ìtong oAmalek ga ra anyimnyal ka̱ ashe aba̱nda̱m. ");
INSERT INTO yer_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Te uza̱ là ôKeni pa̱, <<Ó fa, ó re oAmalek kang mmá gbá̱ng wó nzəng ká̱ oza̱ ka̱t, ka̱kul ka̱ ó nyám ikin n̂gkpaktak oIsa̱rila, ka̱ awalang va̱ oza̱ fa ka̱ aMasar á.>> Te oKeni fa re oAmalek. ");
INSERT INTO yer_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Te uShawulu gbá̱ng oAmalek á ɓàn ka̱ aHavila ga chu aShur, dat ká̱ aswari asa̱l nfa alum ngga aMasar. ");
INSERT INTO yer_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Uza̱ kpán uAgak uponzhi uga aAmalek ká̱ irirì, kang uza̱ zhì aɓoshi onənəm pa̱ kpaktak ká̱ ndokchi. ");
INSERT INTO yer_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Ǹnyi te, uShawulu ká̱ oshozha re uAgak ká̱ irirì, ká̱ itam inəna̱n, ká̱ ina, ká̱ ivan itam ká̱ ivan ina inəna̱n, ká̱ nkpaktak iya̱m va̱ ɓyen ká̱ oza̱, oga iya̱m va̱ ta̱ ri ìgwak ôza̱, oza̱ zhì oza̱ ka̱t. Kang nkpaktak ivəngva̱ ɓyen ká̱ oza̱ ka̱t, te oza̱ zhì oza̱ pa̱ chatchat. ");
INSERT INTO yer_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Te uYawe là ûSamuwel pa̱, ");
INSERT INTO yer_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","<<Mmami ká̱ nlak ìgwak nva̱ n nak uShawulu yà uponzhi á, ka̱kul uza̱ ga̱ɓa̱n asəm á mi chit, kang uza̱ yang ka̱ nkpak nnap-mpakpak mi chit.>> USamuwel fe iya̱m va̱ ta te, ìgwak lak na pa̱ gənggəng kang uza̱ chal uYawe ka̱ ashe nkpaktak ìzwam va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Ìpin fa kpa̱k ká̱ ìɓotak te, uSamuwel wong ga pa̱ na ô ya uShawulu. Te mmá là á na pa̱, <<UShawulu ga aKarmel chit. Uza̱ me iya̱m ka̱kul nrəng ká̱ aɗin wò ka̱ ta, kang uza̱ ga aGilgal chit.>> ");
INSERT INTO yer_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Awalang va̱ uSamuwel ga ya na te, uShawulu là á na pa̱, <<Re uYawe á pa̱r ɓu, n yəl kà̱ nnap-nlà aYawe chit.>> ");
INSERT INTO yer_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Ǹnyi te, uSamuwel là pa̱, <<A ya pa na te, iza̱ mmami kà̱ nfife yà? Ayə́ng itam ká̱ ina ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","UShawulu na ama̱n pa̱, <<OShozha ɓa ká̱ oza̱ ka̱ atak oAmalek, oza̱ yak itam inəna̱n ká̱ ina ka̱kul na mmá yichi nləfər ûYawe, Inan ɓu ká̱. Ǹnyi te, í zhì nkpaktak iza̱ nggo.>> ");
INSERT INTO yer_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Te uSamuwel là ûShawulu pa̱, <<Ma̱r, na n là a ɓu iya̱m va̱ uYawe là á mi ká̱ ìzwam ká̱ nlam.>> UShawulu là pa̱, <<Là á mi.>> ");
INSERT INTO yer_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Te uSamuwel là pa̱, <<Káp ká̱ nva̱ u ya ishi ɓu iya̱m iro ka̱t, ka̱ nna te, u nyang unəm uga mpyal oga akum oIsa̱rila ka̱t ɗò? UYawe gor ɓu chit uponzhi oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Kang uza̱ re ɓu pa̱, <Ga ɓu zhì onəm oɓá̱ngɓa̱ng va̱ ta, oAmalek pa̱ kpaktak, lung oza̱ na u gba̱ng oza̱ pa̱ chatchat.> ");
INSERT INTO yer_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Iza̱ nak kang u kpak nnap-nlà aYawe ka̱t yà? Sang kang u wur iya̱m iga ngwur ka̱ atak ìkum kang u nəm iya̱m iɓá̱ngɓa̱ng wanta̱ kà̱ mpyal aYawe yà?>> ");
INSERT INTO yer_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Ǹnyi te, uShawulu là pa̱, <<N kpak nnap-nlà aYawe kpak, n nəm nre wa nva uza̱ re mi á. N zhì nkpaktak oAmalek kang m ɓa ká̱ uAgak uponzhi oza̱. ");
INSERT INTO yer_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Oshozha wur itam ká̱ ina inəna̱n ka̱ atak ìkum iva mal pa̱ mmá zhì ka̱kul pa̱ ó yichi nləfər ûYawe Inan ɓu ká̱, ka̱ aGilgal.>> ");
INSERT INTO yer_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Te uSamuwel na ama̱n pa̱, <<Iza̱ uYawe ɗom ji yà? Iya̱m inana ɓu iga nshì ká̱ nləfər ka̱t te nkpak nnap-nlà aYawe ɗò? Nkpak nnap-nlà ɓyen ji nna nləfər ji, nfe nnap ɓyen ji mpyìp inagam ji. ");
INSERT INTO yer_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Nfa iya̱mkak ká̱ uYawe á sat wa nnap-mɓá̱ngɓa̱ng iva̱k. Kang nkak ishi te, á ɓa̱ng wa ngwop ìchər. Ka̱kul u yang ká̱ nnap-mpakpak aYawe chit, te wa nnà ta uza̱ yang ɓu chit ká̱ nyà uponzhi.>> ");
INSERT INTO yer_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Te uShawulu là ûSamuwel pa̱, <<N nəm nnap-mɓá̱ngɓa̱ng chit. N kpak nnap-mpakpak aYawe ka̱t, kang n kpak nnap-nlà ɓu ka̱t kpa, ka̱kul n nəm ayər oshozha, nna nak te, n nəm iya̱m va̱ oza̱ ɗom. ");
INSERT INTO yer_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Ǹyangmata̱ n chal ɓu, yar nnap-mɓá̱ngɓa̱ng á mi, na u le nzəng ká̱ mi, na n wop uYawe.>> ");
INSERT INTO yer_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Te uSamuwel là pa̱, <<Mi ya ka̱ nle nzəng ká̱ ɓu ka̱t. Ka̱kul u yang nkpak nnap-nlà aYawe, te uYawe yang ɓu chit ká̱ nyà uponzhi oIsa̱rila.>> ");
INSERT INTO yer_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Awalang va̱ uSamuwel ga̱ɓa̱n pa̱ na ô ga te, uShawulu kpán arwangchwang ìlukwanlukwan te, ìlukwan va̱ ta kakchi. ");
INSERT INTO yer_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","USamuwel là á na pa̱, <<Wa nva̱ u kakchi ìlukwan mi te, wa nnà ta uYawe kakchi iponzhi oIsa̱rila chit ka̱ atak ɓu n̂da ta̱, kang uza̱ na ûnəm uro pa̱ɗi, uva á ɓyen ji ɓu ji. ");
INSERT INTO yer_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Uza̱ va Ìzhàn oIsa̱rila i nap akwam ka̱t, uza̱ i ga̱ɓa̱n nnap-nlà wò ka̱t, ka̱kul uza̱ unəmləbər kang i ga̱ɓa̱n nnap-nlà wò ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Te uShawulu na ama̱n pa̱, <<N nəm nnap-mɓá̱ngɓa̱ng chit. Ka̱ nna kpa te, n chal ɓu, wa ma̱n te, wa na ichumchum á mi kà̱ mpyal onəm oga mpyal onəm mi ká̱ oIsa̱rila, le nzəng ká̱ mi na n wop uYawe, Inan ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","USamuwel ga̱ɓa̱n, a le ga nzəng ká̱ na, kang uShawulu wop uYawe. ");
INSERT INTO yer_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Te uSamuwel là pa̱, <<Ɓa ká̱ uAgak uPonzhi oAmalek á mi.>> Te uAgak ɓa ka̱ mpipyal ka̱ ashe ìkan, uza̱ rəng pa̱, <<Nnandər ikú va̱ ka̱ apal mi te á lyam chit.>> ");
INSERT INTO yer_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Ǹnyi te, uSamuwel là pa̱, <<Wa va̱ ndokchi ɓu nak ochar pa̱ makmak lang ovan oza̱ te, unang ɓu i ga nlang uyen wò kpa.>> Te uSamuwel kyen uAgak ka̱ ndokchi pa̱ nyimənnyimən kà̱ mpyal aYawe ka̱ aGilgal. ");
INSERT INTO yer_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Te uSamuwel le aRama, ǹnyi te, uShawulu le nzhi wò ka̱ aGibeya aShawulu. ");
INSERT INTO yer_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Te uSamuwel ga atak uShawulu lap ka̱t ga chu nra va̱ uSamuwel kú ká̱, ǹnyi te, uSamuwel yà ka̱ aɗor ka̱ apal aShawulu pa̱ makmak. Kang uYawe ká̱ nlak ìgwak ka̱kul nva̱ uza̱ nak uShawulu yà uponzhi oIsa̱rila á. ");
INSERT INTO yer_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","UYawe là ûSamuwel pa̱, <<Ázəmo kang ɓu re nnəm aɗor ka̱ apal ishi aShawulu yà? N yang na chit ká̱ ǹyà uponzhi ka̱ apal oIsa̱rila. Yə́l agbəshi ɓu ká̱ mmì mpyet na u ga aBet-Lehem, mmami kà̱ nre ɓu ka̱ atak aJese, ka̱kul n yak uyiyen uro chit pa̱ a yà uponzhi.>> ");
INSERT INTO yer_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Ǹnyi te, uSamuwel là pa̱, <<Mi nəm sang kang mi nəm iya̱m va̱ ta̱ yà? A yà pa̱ uShawulu i fe te, i gbá̱l mi.>> Te uYawe là pa̱, <<Yar ìya ìna ìchar ka̱ awo, te là pa̱, <M ɓa pa̱ n yichi nləfər ûYawe.> ");
INSERT INTO yer_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Chal uJese kà̱ nləfər va̱ ta, kang mi nyám iya̱m va̱ a ɓu pa̱ u nəm. Ɓu gor uro va̱ mi nyám á ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","USamuwel nəm wa nva uYawe là á na. Awalang va̱ uza̱ chu aBet-Lehem te, onəmgbak oga aBet-Lehem fa gwang na ká̱ ayər. Oza̱ ɓəp pa̱, <<U ɓa amwang na lyát ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","USamuwel ma̱n pa̱, <<M ɓa ikángkáng pa̱ sham. M ɓa pa̱ n yichi nləfər ûYawe. Ó gár ishi wó na ó ɓa nzəng ká̱ mi ka̱ atak nləfər.>> Te uSamuwel gar uJese ká̱ ovəvan onunggwan, kang uza̱ chal oza̱ kpa kà̱ nləfər va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Awalang va̱ oza̱ chu chit kang uSamuwel dər uEliyap uya aJese te, uza̱ rəng pa̱, <<Nkpak uwà uYawe gor.>> ");
INSERT INTO yer_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Ǹnyi te, uYawe là ûSamuwel pa̱, <<Kang wa dər ka̱ acham izər, ka̱t te ìmak ka̱t, ka̱kul n yang na chit. UYawe i dər iya̱m wa nva unəmləbər i dər ka̱t. Onəmləbər i dər ka̱ acham izər, ǹnyi te, uYawe i dər ìgwak.>> ");
INSERT INTO yer_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Te uJese là ûyen wò uAbinadap pa̱ uza̱ a lyam kà̱ mpyal aSamuwel, ǹnyi te, uSamuwel là pa̱, <<UYawe yak uva̱ ta̱ ka̱t na kpa.>> ");
INSERT INTO yer_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Te uJese le nak uShamma lyam kà̱ mpyal aSamuwel, te uSamuwel là pa̱, <<UYawe yak na ka̱t na kpa.>> ");
INSERT INTO yer_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","UJese nak ovan wò onunggwan pa̱ ofangshat, lyam kà̱ mpyal aSamuwel, ǹnyi te, uSamuwel là a na pa̱, <<UYawe yak uro ka̱ ashe oza̱ ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Te uza̱ ɓəp uJese pa̱, <<Ovan ɓu onunggwan oma ta̱ byet ɗò?>> UJese na ama̱n pa̱, <<Uɓwakan oza̱ uwa yà ka̱ atak nkpàk iya̱mkang ka̱ ashe nzam.>> Te uSamuwel là á na pa̱, <<Re nre kà̱ na, í yà kà̱ ntəm ka̱t ya uza̱ i ɓa kang.>> ");
INSERT INTO yer_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Te uJese re nre mmá ɓa ká̱ na. Uza̱ uyenza̱m uga mɓyen ndər uva ká̱ ikángkáng. Te uYawe là pa̱, <<Wóng, uwa ta gor na.>> ");
INSERT INTO yer_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","USamuwel yar agbəshi mmì zuk uDawuda ká̱ ishi kang uza̱ gor na ka̱ kà̱ mpyal ogənanggənang. Ɓan ka̱ n̂da va̱ ta te, aRuhu aYawe vàng ká̱ ìkam ka̱ apal ishi aDawuda. Nna chit te uSamuwel le aRama ɗak. ");
INSERT INTO yer_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","ARuhu aYawe re uShawulu, kang uYawe re nre ka̱ aruhu aɓá̱ngɓa̱ng nyán ká̱ na. ");
INSERT INTO yer_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Oro ka̱ ashe okpari aShawulu là á na pa̱, <<Dər, aruhu aɓá̱ngɓa̱ng vàng chit ka̱ atak Inan kà̱ nyán ká̱ ɓu. ");
INSERT INTO yer_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Re, anəm uga nzhi yi, í mwo unəm uga ǹnyi nnə́m aɓwa, na awalang va̱ aruhu aɓá̱ngɓa̱ng ka̱ atak Inan a vàng ka̱ apal ɓu te, uza̱ i nə́m aɓwa va̱ ta na nnap nəm ɓu á ɓa kà̱ɗi.>> ");
INSERT INTO yer_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Te uShawulu là ôkpari wò pa̱, <<Ó ram unəm va̱ nyi nnə́m aɓwa byet, na ó ɓa ká̱ na á mi.>> ");
INSERT INTO yer_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Uro ka̱ ashe okparikpari na ama̱n pa̱, << Uya aJese unəm uga aBet-Lehem uro wa yà nyi nnə́m aɓwa byet. Uza̱ kam ìgwak, kang i lung ìkum byet. Uza̱ ká̱ aghan nnap-nlà kpa, kang uza̱ uyenza̱m uga mɓyen ndər. UYawe uwa yà nzəng ká̱ na.>> ");
INSERT INTO yer_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Te uShawulu re onəm oga nre ka̱ atak aJese pa̱, <<Re nre á mi ká̱ uyen ɓu uDawuda, uyen uga nkpak iɓəl ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Te uJese re nre ká̱ uDawuda nzəng ká̱ nzəngkəng ka̱ apal azhaki, ká̱ aba̱ng ndəng iba̱ngba̱ng ká̱ iya iɓəl ga ûShawulu. ");
INSERT INTO yer_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","UDawuda ɓa atak aShawulu kang a ɓàn nnəm inok á na. UShawulu ma̱n ká̱ uDawuda byet, kang uDawuda sat uzəngtəng ka̱ ashe onəm oga ǹyar iya̱m ìkukum. ");
INSERT INTO yer_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Te uShawulu re nre ûJese pa̱, << Re uDawuda á təm a nəm inok á mi, ka̱kul m ma̱n ká̱ na pa̱ gənggəng.>> ");
INSERT INTO yer_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Awalang va̱ aruhu aɓá̱ngɓa̱ng ka̱ atak Inan i vàng ka̱ apal ishi aShawulu te, uDawuda i nə́m aɓwa wò. Te aruhu aɓá̱ngɓa̱ng va̱ ta i re uShawulu kang nnap-nnənəm i le i ɓa. ");
INSERT INTO yer_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Te oFilisti ɓut oshozha oza̱ ka̱kul ìkum, ka̱ aSoko ka̱ aYahudi. Oza̱ ra apa̱k ka̱ aEfes Dammim, ka̱ ishimshe aSoko ká̱ aAzeka. ");
INSERT INTO yer_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","UShawulu ká̱ oIsa̱rila ɓut kang a ra apa̱k ka̱ mba̱nda̱m aEla, oza̱ gbar izər ka̱kul ìkum ká̱ oFilisti. ");
INSERT INTO yer_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","OFilisti tong ka̱ aɗuktum aro kang oIsa̱rila tong ka̱ aro, ká̱ mba̱nda̱m ká̱ ishimshe oza̱. ");
INSERT INTO yer_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Te uGoliyat uponzhi ìkum oFilisti unəm uga ìtong aGat, fa ta̱l ká̱ ishimshe oFilisti ká̱ oIsa̱rila, i rurup ji ashar pa̱ fangzəngtəng ji. ");
INSERT INTO yer_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Uza̱ pa atagya aga acham arəzang ká̱ ìlukwan iga acham arəzang, iɗəɗək ìkalong pa̱ ìtukun iga ashekel. ");
INSERT INTO yer_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Uza̱ mwak acham arəzang ka̱ ashar wò, kang uza̱ gantal aɓár akəla̱pkəla̱p aga acham arəzang ka̱ agar. ");
INSERT INTO yer_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Azar aɓəɓar wa ìdari iga nka̱p atani, kang ishi aɓəɓar, iɗəɗək i nəm ashekel igba̱l pa̱ ikpa̱ɗing nəm. Unəm uga ǹyar nggwànggwàng ìkukum i ləp mpyal a na. ");
INSERT INTO yer_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","UGoliyat fa sat kà̱ mpyal oshozha oIsa̱rila kang à lə̀p achu pa̱, <<Ó tong iza̱ yà? Ó ɓa ìkum ka̱t ɗò? Mmami unəm oFilisti, kang mmawó okpari aShawulu ka̱t ɗò? Ó yak unəm uro á ɓa ka̱ ashe mba̱nda̱m na á lung mi ka̱ta̱. ");
INSERT INTO yer_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","A yà pa̱ uza̱ á lung mi kang a gbá̱l mi te, oFilisti i yà ozwal wó, ǹnyi te, a yà pa̱ ma ji nkəka̱m kang n gbá̱l na te, ó yà ozwal yi.>> ");
INSERT INTO yer_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Te unəm oFilisti là pa̱, <<M ɓak oshozha oIsa̱rila n̂da va̱ ta̱. Ó re unəm wó uro á ɓa ná í lung owan yi.>> ");
INSERT INTO yer_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Ká̱ nfe nnap-nlà aFilisti va̱ ta te, ayər nəm uShawulu ká̱ nkpaktak oshozha oIsa̱rila kang oza̱ tán pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Ǹyangmata̱ te, uDawuda uya aJese, unəm uga aEfərata ka̱ aBet-Lehem ka̱ ashe mbin aYahudi. UJese ka̱ ovan onunggwan pa̱ ona̱nne kang ka̱ awalang iponzhi aShawulu te, uza̱ gbák chit. ");
INSERT INTO yer_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Ovan aJese onəmgbak pa̱ oshatɗing ga ìkum chit ká̱ uShawulu. Unəmgbàk te, ka̱ yà uEliyap uga uparəm uAbinadap, kang uga ushatɗing uShamma. ");
INSERT INTO yer_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","UDawuda uwa uyen ka̱ ashe nkpaktak ovan onunggwan aJese. Onəmgbaknəmgbak oga oshatɗing va̱ ta yar nva̱ng aShawulu, ");
INSERT INTO yer_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","ǹnyi te, uDawuda i wong i ga atak apa̱k aShawulu kang i le i ga aBet-Lehem ka̱kul nkpak iya̱m nkang apo wò. ");
INSERT INTO yer_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Nra ìsəm pa̱ ineɗing uFilisti va̱ ta ka̱ nnəm inok mpyar oshozha oIsa̱rila ìpin ká̱ arurong. ");
INSERT INTO yer_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","N̂da nro te, uJese là ûDawuda pa̱, <<Yar ìkur ifórfòr ìkpáng iga mma iya̱m ká̱ nzəngkəng pa̱ ngba̱pchi ga ogənang ɓu pa̱ kəlak ka̱ apa̱k. ");
INSERT INTO yer_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Te yar mbyal ina nva mmá pə́k chit nə́k pa̱ ngba̱pchi ga unəm uga mpyal oza̱. Wa dər ikángkáng ogənang ɓu kang ɓu ɓa ká̱ iya̱m iro a mi iva i nyám pa̱ oma yà ká̱ ikángkáng. ");
INSERT INTO yer_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Ogənang ɓu oma yà nzəng ká̱ uShawulu ká̱ oshozha oIsa̱rila ka̱ mba̱nda̱m aEla kà̱ nnəm ìkum ká̱ oFilisti.>> ");
INSERT INTO yer_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Ipin fa kpa̱k ká̱ iɓotak te, uDawuda wong re iya̱m nkang ka̱ ashe awo anəm uga nkpak iya̱m nkang uro. Uza̱ wur iya̱m va̱ upupo uJese re na ka̱ á. Uza̱ ga chu apa̱k ka̱ awalang va oshozha oIsa̱rila ka̱ ngga agbagba ìkum, kà̱ nnə́m achu ìkum. ");
INSERT INTO yer_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Oshozha oFilisti ká̱ oIsa̱rila fa agbagba ìkum tong i dər owan oza̱. ");
INSERT INTO yer_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Te uDawuda re iya̱m va̱ uza̱ ɓa ká̱ ka̱ atak anəm uga mpángchí iya̱m kang uza̱ chər ga agbagba ìkum re anung ogənang wò. ");
INSERT INTO yer_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Uza̱ ka̱ nlà nnap ka̱ oza̱, ta byet te, uGoliyat unəm oFilisti ka̱ aGat, fa ka̱ ashe oshozha oFilisti, kang i là apir nnap-nlà wò ngga mpyar oza̱ ka̱ anung, te uDawuda fe. ");
INSERT INTO yer_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Nkpaktak awalang va̱ oshozha oIsa̱rila ya na te, oza̱ ɓàn nchəng í le ka̱kul ayər nəm oza̱ byet. ");
INSERT INTO yer_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Ǹyangmata̱ te, oIsa̱rila i là pa̱, <<Ó ya agbar anəm va̱ cho ya fa ta ɗò? Uza̱ fa pa̱ ô ɓak oIsa̱rila. Uponzhi i ga nná idur imakmak ûnəm va̱ i gbá̱l na, uza̱ i na uyen wò uchar uro á na i ka̱m, kang onənəm te, oza̱ imwa mbwai mbin ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Te uDawuda ɓəp onəm va̱ dat ká̱ na pa̱, <<Iza̱ mí nəm unəm va̱ i gbá̱l uFilisti va̱ ta̱ kang ì yar iwuswa va̱ ta̱ i le oIsa̱rila yà? Uda uFilisti va̱ ta̱ unəm uga ache amulur, kang i ɓak oshozha Inan iga irirì yà?>> ");
INSERT INTO yer_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Kang oshozha na ama̱n á na wa nva mmá là á. Oza̱ là pa̱, <<Iya̱m va ta amwa ka̱kul anəm va̱ i gba̱l na.>> ");
INSERT INTO yer_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Awalang va̱ uEliyap unəmgbàk aDawuda fe na ka̱ nlà nnap ka̱ oshozha te, ìgwak lak na kà̱ na kang uza̱ ɓəp na pa̱, <<Iza̱ u ɓa kà̱ ka̱ta̱ yà? U re itam iga nɗa̱p va̱ uda ka̱ ashe nzam yà? N nyi ɓu ká̱ nrup ishi ká̱ nkak ishi nyi. U ɓa pa̱ na u dər nlung ìkum.>> ");
INSERT INTO yer_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","UDawuda ɓəp pa̱, <<Nza̱ mpat n nəm chit ǹyangmata̱ yà? Mi là nnap-nlà lap ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Te uza̱ re na ga̱ɓa̱n atak ashozha uro, kang uza̱ ɓəp na wa nva uza̱ ka̱ ɓəp. Te oshozha va̱ ta na ama̱n á na wa nva mmá ka̱ na á na á. ");
INSERT INTO yer_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Iya̱m va̱ uDawuda là te, oza̱ ga là ûShawulu, kang uShawulu re nre pa̱ mmá ɓa ká̱ na. ");
INSERT INTO yer_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","UDawuda là ûShawulu pa̱, <<Kang ìchəgwak á ləp unəm uro ka̱ uFilisti va̱ ta̱ ka̱t. Uzwal ɓu i ga i lung na.>> ");
INSERT INTO yer_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","UShawulu ma̱n ûDawuda pa̱, <<Ɓu nəm sang kang ɓu lung uFilisti va̱ ta̱ yà? Mmaɓu uyen uɓwakan, kang uza̱ ununggwan ìkum ɓan ká̱ ivanzəza̱m na byet.>> ");
INSERT INTO yer_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Ǹnyi te, uDawuda là ûShawulu pa̱, <<Uzwal ɓu i kpak iya̱m nkang apo wò. Awalang va̱ ìlir ka̱t te abiya ɓa nkpán ìtam ka̱ ashe nggatək iya̱m nkang, ");
INSERT INTO yer_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","mi ɓàk na, mi la̱p kang mi vyat ìtam va̱ ta ka̱ anunung. Awalang va̱ i ga̱ɓa̱n ìkum ká̱ mi te, mi kpán na ka̱ akpap kang mi nə́m ka̱ ikəka̱m ikú. ");
INSERT INTO yer_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Uzwal ɓu gba̱l ìlir ká̱ abiya chit, mi ga nnəm uFilisti uga ache amulur va̱ ta̱ wanta na kpa, ka̱kul nva̱ uza̱ ɓak oshozha Inan iga irirì chit. ");
INSERT INTO yer_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","UYawe va fa ká̱ mi ka̱ ashe awo ìlir ká̱ abiya va̱ ta te, uwa i fa ká̱ mi ka̱ ashe awo aFilisti va̱ ta̱.>> UShawulu là ûDawuda pa̱, <<Ga mpyal ka̱, uYawe a ya nzəng ká̱ ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Te uShawulu mwak iya̱m ìkum wò ûDawuda, uza̱ pa atagya acham arəzang ká̱ ìlukwan acham á na. ");
INSERT INTO yer_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","UDawuda mwak chit, te uza̱ gal ndokchi uza̱ ɗak pa̱ ô chen ká̱ te, a ma̱t na ka̱kul uwa mwak apir ìlukwan va̱ ta̱ chit ka̱t. UDawuda là ûShawulu pa̱, <<Mi nyi nchen ká̱ iya̱m va̱ ta̱ ka̱t, ka̱kul nna mwak apipir chit ka̱t.>> Te uDawuda zəp iya̱m va̱ ta le. ");
INSERT INTO yer_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Te uza̱ yar ìdari wò ka̱ awo, wur ipang pa̱ ìtukun imálkanmalkan ka̱ ashe awang, uza̱ nak ka̱ ashe azhal aga nkpak iya̱m nkang wò, ká̱ nchwalak wò ka̱ awo kang uza̱ ga dát ká̱ unəm oFilisti va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Ǹnyi te, uFilisti va̱ ta nzəng ká̱ unəm uga ǹyar nggwanggwang ìkum á na kà̱ mpyal, fa mɓa nggwang uDawuda. ");
INSERT INTO yer_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Uza̱ dər uDawuda te, uza̱ ya na uwa yà uyen uɓwakan uga mɓyen dər, uva ká̱ ikángkáng, te uza̱ ɓak na. ");
INSERT INTO yer_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Uza̱ là ûDawuda pa̱, <<Mmami iva kang ɓu ɓa ká̱ mi ká̱ idari ɗò?>> Kang uFilisti va̱ ta vyap uDawuda ká̱ aɗin inənan. ");
INSERT INTO yer_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Uza̱ là pa̱, <<Ɓa ka̱ta̱, na n ná ìzhe ɓu inyil ká̱ izhé iga anyin.>> ");
INSERT INTO yer_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","UDawuda là ûFilisti va̱ ta pa̱, <<U ɓa kà̱ mi ka̱ ndokchi, ká̱ aɓár ká̱ aɓár akəla̱pkəla̱p, ǹnyi te, m ɓa kà̱ ɓu ka̱ ashe aɗin aYawe uGa ngGatək, Inan oshozha oIsa̱rila, uva u ɓak á. ");
INSERT INTO yer_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","N̂da va̱ ta̱ uYawe i na ɓu ka̱ ashe awo mi, kang mi gba̱l ɓu mi gəl ishi ɓu. Te n̂da va̱ ta̱ mi na oga akúm oshozha oFilisti înyil ká̱ izhé iga anyin, kang nkpaktak apambin i nyi pa̱, Inan i ya yà ka̱ aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Nna chit te, nkpaktak nggatək va̱ ka̱ta̱ i nyi pa̱ uYawe i ka̱mshi onəm wò ká̱ aɓár ka̱t te ndokchi ka̱t. Ìkum iji àYawe, uza̱ i na nkpaktak wó ka̱ ashe awo yi.>> ");
INSERT INTO yer_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","UFilisti va̱ ta səng ɓa dát pa̱ na ú ru na te, uDawuda gha̱n chər ga dát ká̱ ngba̱k va̱ oFilisti kà̱, pa̱ ô gwang na. ");
INSERT INTO yer_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Kang uDawuda pa awo ka̱ ashe azhal wò yar ìpang ka̱ ashe azhal aga nkpak iya̱m nkang wò, uza̱ nak ka̱ ashe nchwalak kang uza̱ mang ləp uFilisti va̱ ta ká̱ ìsu. Ìpang va̱ ta tar ka̱ ashe ìkpang ishishi, kang uGoliyat ru zəp kà̱ mbin. ");
INSERT INTO yer_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Te uDawuda nəm igwan ka̱ uFilisti va̱ ta ká̱ nchwalak ká̱ ìpang. Uza̱ gbá̱l uFilisti va̱ ta nzəng ká̱ ndokchi ka̱ awuwo ka̱t. ");
INSERT INTO yer_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Te uDawuda chər ga sat ka̱ apal ishishi. Uza̱ tur ndokchi aFilisti va̱ ta ka̱ ashe avakchivakchi. Nva̱ngva̱ uza̱ gba̱l na te, uza̱ gəl ishi á na ká̱ ndokchi va̱ ta. Awalang va̱ oFilisti ya chit pa̱ uponzhi ìkum oza̱ kú chit, te oza̱ chəng le nva̱ng. ");
INSERT INTO yer_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Te oIsa̱rila ká̱ oYahuda bà achu aga igwan, kang oza̱ ɓàk oFilisti ga chu ká̱ ka̱ anung asa̱l aGat, ká̱ anung oga asa̱l aEkron. OFilisti va̱ kú te, a tak ka̱ asa̱l á ga ngga aShayarayim á ga chu aGat ká̱ aEkron. ");
INSERT INTO yer_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Awalang va̱ oshozha oIsa̱rila le ka̱ atak nwà oFilisti te, oza̱ wur iya̱m iga nwur ka̱ atak ikum ka̱ ashe apa̱k oFilisti. ");
INSERT INTO yer_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","UDawuda yar ishi aFilisti va̱ ta ɓa ká̱ ka̱ aUrushelima te, uza̱ nak iya̱m ìkum àGoliyat ka̱ ashe aghal wò. ");
INSERT INTO yer_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Nva̱ uShawulu ka̱ ya uDawuda kà̱ nfa ngga pa̱ ô lung uFilisti te, a ɓəp uAbner unəm uga mpyal oshozhashozha pa̱, <<Uyen va̱ ta̱ uya ada yà?>> Te uAbner là pa̱, <<Irirì aponzhi á təm mbyet, n nyi upupo ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Uponzhi là ûAbner pa̱, << Ga ɓəp, uda upupo yà?>> ");
INSERT INTO yer_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Nva̱ngva̱ uDawuda le chit ka̱ atak ngbá̱l uFilisti te, uAbner ka̱m na ɓa ká̱ ûShawulu ya ishi aFilisti va̱ ta na ka̱ awo aDawuda. ");
INSERT INTO yer_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","UShawulu ɓəp na pa̱, <<Ayen nza̱m, mmaɓu uya ada yà?>> Te uDawuda là pa̱, <<Mmami uya azwal ɓu uJese, unəm uga aBet-Lehem.>> ");
INSERT INTO yer_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Ka̱ nva̱ngva̱ uDawuda gbá̱l kà̱ nlà nnap chit ká̱ uShawulu te, uJonatan, uya aShawulu ɗom uDawuda pa̱ makmak, kang uJonatan ma̱n na wa nva uza̱ ma̱n ishi wò á. ");
INSERT INTO yer_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","A ɓàn n̂da va̱ ta te, uShawulu re uDawuda le nzhi lap ka̱t, uza̱ təm ká̱ na. ");
INSERT INTO yer_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Kang uJonatan yar nsar nnap-nlà ká̱ uDawuda, ka̱kul uza̱ ma̱n na wa ishi wò. ");
INSERT INTO yer_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","UJonatan tur ìlukwan wò uza̱ na ûDawuda, nzəng ká̱ ìlukwan ìkukum, ká̱ ndokchi, ká̱ ìjang, ká̱ ngbat. ");
INSERT INTO yer_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Atak va pa̱ kpaktak uShawulu i re uDawuda pa̱ uza̱ a ga a nəm ìkum te, uDawuda i nəm igwan ká̱. Te uShawulu nak na uzəngtəng ka̱ ashe onəm ochumchum oshozhashozha, kang ìgwak chàng nkpaktak oshozha ká̱ onəm oga mpyal oshozha. ");
INSERT INTO yer_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Awalang va̱ oshozha kà̱ nle nzhi nva̱ngva̱ uDawuda gbá̱l uFilisti va̱ ta chit te, ochar fa ka̱ ashe oga itong oIsa̱rila pa̱ kpaktak pa̱ na ó gwang uponzhi uShawulu. Te oza̱ i shì nnap-nshì kang i gba̱p nza̱m, ká̱ nnap-nshì ngga nchang ìgwak ká̱ iganggáng ká̱ oga aɓwa acham. ");
INSERT INTO yer_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Oza̱ i gba̱p nza̱m kang i shì nnap-nshì i là ka̱ pa̱, <<UShawulu gbá̱ng oji wò ikalong, kang uDawuda gbá̱ng oji wò ikalong pa̱ igba̱pchi.>> ");
INSERT INTO yer_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Nnap nshì va̱ ta̱ lak ìgwak uShawulu pa̱ gənggəng. Kang uza̱ là pa̱, <<Iza̱ wa nva̱ ta̱ yà? Oza̱ là pa̱ n gbá̱ng ikalong na byet, kang pa̱ uDawuda gbá̱ng ikalong pa̱ igba̱pchi. Te iza̱ ɓur lap ɗa, a ɓur iponzhi na á na chwat ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Ka̱ awalang va ta byet te, uShawulu nak iwu uDawuda. ");
INSERT INTO yer_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Ipin fa kpa̱k te, Inan re ǹre ká̱ aruhu aɓá̱ngɓa̱ng ka̱ apal aShawulu ká̱ nkam i nyán ká̱ na. Uza̱ ɓan nnə́m achu wa anəm ura̱nra̱n ka̱ ashe nzhi wò. Te uDawuda ɓàn nnə́m aɓwa á na wa nva̱ uza̱ mà nə́m á na á. Ǹnyi te, uShawulu uwa ka̱ yà ká̱ aɓár ka̱ awo wò, ");
INSERT INTO yer_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","kang uza̱ gha̱p aɓár i là îshi wò pa̱, <<Mi bàng uDawuda ká̱ ka̱ izər nzhi>> Ǹnyi te, uDawuda ra nggà nva̱ng pa̱ mparəm. ");
INSERT INTO yer_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","UShawulu nəm ayər aDawuda, ka̱kul uYawe uwa ya nzəng ká̱ uDawuda, ǹnyi te, uza̱ kap ká̱ uShawulu chit. ");
INSERT INTO yer_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Te uShawulu fa ka̱ uDawuda re nzhi iponzhi, uza̱ nak na ya unəm uga mpyal oshozha ìkalong, kang uDawuda ləp mpyal ôza̱ ka̱ atak ìkum. ");
INSERT INTO yer_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Ka̱ ashe nkpaktak iya̱m va̱ uDawuda nəm te, uza̱ i nəm igwan, ka̱kul uYawe uwa yà nzəng ká̱ na. ");
INSERT INTO yer_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Awalang va̱ uShawulu ya igwan aDawuda chit te, uza̱ nəm ayəyər. ");
INSERT INTO yer_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Ǹnyi te, nkpaktak oIsa̱rila ká̱ oYahuda ma̱n uDawuda, ka̱kul uza̱ ləp mpyal ôshozha ka̱ atak ìkum ka̱ asa̱l va məma. ");
INSERT INTO yer_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","UShawulu là ûDawuda pa̱, <<Mi ga nna uyen mi uchar ugəshi, uMerap a ɓu, ɓu ka̱m ichar ká̱ na. Ǹnyi te, ɓu nyám ishi ɓu á mi pa̱ mmaɓu uyen ununggwan ka̱ atak nlung ìkum àYawe.>> UShawulu ka̱ nrəng ka̱ ashe ìgwak pa̱, << Awo mi i dok na ka̱t, re oFilisti oma á gbá̱l na.>> ");
INSERT INTO yer_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Kang uDawuda là ûShawulu pa̱, <<Mmami uda yà, akum mi iza̱ ka̱ ashe oIsa̱rila kang mi yà ugwar àponzhi yà? Akum apo mi chu iya̱m iro ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Awalang chu chit pa̱ mmá na uMerap ûDawuda pa̱ á ka̱m, te uShawulu yar na ná ûAdəriyel, unəm oMehola. ");
INSERT INTO yer_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Te uya àShawulu uMikal ma̱n uDawuda byet, kang nva̱ngva̱ uShawulu fe te, ìgwak chàng na. ");
INSERT INTO yer_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Te uShawulu là îshi wò pa̱, <<Mi na uMikal ûDawuda, na n lwak na ká̱, na oFilisti á gbá̱l na.>> Kang uShawulu là ûDawuda kà̱ɗi pa̱, <<Ǹyangmata̱ ɓu ga ǹyà ugwar mi.>> ");
INSERT INTO yer_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Te uShawulu là ônəm wò pa̱, <<Ó là ûDawuda ka̱ ayi pa̱, <Dər uponzhi ma̱n ɓu byet kang mmayi kpa. Ǹyangmata̱ ma̱n na u yà ugwar àponzhi.> >> ");
INSERT INTO yer_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Oza̱ là nnap va̱ ta ûDawuda. Ǹnyi te, uDawuda là pa̱, <<Ó rəng pa̱ nnap mɓwakan pa̱ unəm a yà ugwar àponzhi ɗò? Mmami unəm ukunkun u va mmá nyi na mak ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Awalang va̱ onəm aShawulu le ga là ûponzhi iya̱m va̱ uDawuda là te, ");
INSERT INTO yer_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","uza̱ là pa̱, <<Ó là ûDawuda pa̱, n ɗom iya̱m igwar iro ka̱t, iya̱m va̱ n ɗom te, awa anung ache oFilisti ìgba̱l, ka̱kul na mmá pyat akat ka̱ apal okpa ìkum àponzhi.>> Nɗom aShawulu na ta̱ pa̱ oFilisti a gbá̱l uDawuda. ");
INSERT INTO yer_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Awalang va̱ onəm aShawulu là nnap va̱ ta ûDawuda te, ìgwak chàng uDawuda. Te uza̱ ma̱n pa̱ ô yà ugwar àponzhi. Kang ilum va̱ ta i chu, ");
INSERT INTO yer_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","uDawuda wong ká̱ onəm wò ga kang á gbá̱ng oFilisti ìgba̱l pa̱ ìparəm kyèn awa ache oza̱. Oza̱ kung mmak iyəyil ûponzhi na uDawuda a yà ugwar àponzhi. Te uShawulu na uyen wò uchar, uMikal ûDawuda yà uchichar. ");
INSERT INTO yer_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Awalang va̱ uShawulu nyi chit pa̱ uYawe uwa ya nzəng ká̱ uDawuda, kang uyiyen uMikal ɗom uDawuda byet, ");
INSERT INTO yer_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","te ayər nəm uShawulu jujwak ká̱ uDawuda. Uza̱ nak uDawuda sat ukpa ìkum wò kà̱ nkpaktak irirìriri. ");
INSERT INTO yer_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Kang awalang va kpaktak onəm oga mpyal ìkum oFilisti i ru ìkum te, uDawuda i nəm igwan ka̱ apal oza̱ iji aɓo onəm oga mpyal ìkum àShawulu ji. Ka̱kul nva̱ ta̱ te, aɗin aDawuda dam pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","UShawulu nok nkpaktak okpari wò ká̱ uJonatan uyiyen pa̱ oza̱ agba̱l uDawuda. Ǹnyi te uJonatan ma̱n uDawuda byet, ");
INSERT INTO yer_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","uza̱ là á na pa̱, <<Upo mi ka̱ nram ɓu pa̱ ô gbá̱l. Ka̱kul nva̱ ta te, nəm pa̱ dakdak ipin ká̱ iɓotak te, ram atak mbwam kang ɓu təm ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Mi là ûpo mi pa̱ i fa i tong ka̱ agbagba ka̱ atak va̱ u bwam kà̱, kang mi là nnàp á na ka̱ apal ishi ɓu. Te mi là a ɓu iya̱m va̱ pa̱ kpaktak n fe ka̱tətak.>> ");
INSERT INTO yer_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Ipin fa kpa̱k te uJonatan là nnap nnəna̱n ka̱ apal aDawuda ûpo wò. Uza̱ là pa̱, <<Kang wa nəm iya̱m iɓá̱ngɓa̱ng ukpari ɓu uDawuda ka̱t aponzhi, uza̱ uwa a nəm iya̱m iɓá̱ngɓa̱ng iro a ɓu chit ka̱t. Iya̱m va̱ uza̱ nəm te, nna yà ká̱ nka̱mshi á ɓu pa̱ makmak. ");
INSERT INTO yer_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","U kong ka̱ nva̱ uza̱ yang ká̱ irirì wò uza̱ gbá̱l agbar oFilisti, nna nak te uYawe na igwan oIsa̱rila ka̱t ɗò? Iya̱m va̱ ta a chàng ìgwak a ɓu pa̱ gənggəng. Te sang kang ɓu ɗom pa̱ u gbá̱l unəm unəna̱n wa aDawuda yà? Ipir iga ngbá̱l na yà ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Te uShawulu gwong achwang ka̱ nnap-nlà aJonatan kang uza̱ sóng anung pa̱, <<UYawe uwa ya te, unəm uro i gbá̱l uDawuda ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Ka̱ nva̱ng va̱ ta te, uJonatan wór uDawuda a shal á na iya̱m va̱ upupo là á. Te uza̱ ka̱m uDawuda ga ká̱ ka̱ atak aShawulu, ta byet te iya̱m ra pa̱ dakdak wa nva̱ ka̱ yà matmat á. ");
INSERT INTO yer_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","A gba̱ng nva̱ng ka̱t te ìkum fa kà̱ɗi, te uDawuda ga ká̱ oshozha wò ru oFilisti ká̱ ikam. Kang uza̱ gbá̱ng oza̱ pa̱ makmak oza̱ chəng. ");
INSERT INTO yer_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","N̂da nro uShawulu wa ka̱ ntəm ka̱ nzhi wò ka̱ aɓár ka̱ awo, te uYawe re ǹre ka̱ aruhu aɓá̱ngɓa̱ng uShawulu i nyán ká̱ na kà̱ɗi. Te uDawuda ɓàn nnə́m aɓwa á na wa nva uza̱ ma nə́m á, ");
INSERT INTO yer_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","te uShawulu yar aɓár pa̱ ô bàng uDawuda ká̱ ka̱ izər nzhi, ǹnyi te, uDawuda ra nggà kang aɓár ga bàng izər nzhi. Kang uDawuda fa ká̱ izwam va̱ ta chər. ");
INSERT INTO yer_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","UShawulu re ǹre ka̱ onunggwan pa̱ a pángchí nzhi aDawuda, na oza̱ á gbá̱l na ká̱ iɓotak. Ǹnyi te, uMikal uchar aDawuda, là á na pa̱, <<A yà pa̱ ɓu chər ká̱ izwam va̱ ta̱ ka̱kul iriri ɓu ka̱t, ipin i kpa̱k te, mí gbá̱l ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Te uMikal nak uDawuda fa ka̱ mɓol ayir nzhi kang uza̱ chər. ");
INSERT INTO yer_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Te uMikal yar ìchər nak ka̱ apal alyer kang a dang ká̱ iya̱m iga ndang izər kang a nak akpap iɓəl ka̱ ishishi. ");
INSERT INTO yer_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Awalang va̱ uShawulu re ǹre ká̱ onunggwan pa̱ a kpán uDawuda te, uMikal là ôza̱ pa̱, <<Uza̱ rurwa.>> ");
INSERT INTO yer_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Te uShawulu re onunggwan pa̱ á ga á dər uDawuda kang à là ôza̱ pa̱, <<Ó ɓa ká̱ na á mi ka̱ apal aləlyer na ń gbá̱l na.>> ");
INSERT INTO yer_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Ǹnyi te, awalang va̱ oza̱ ɓa táng te, oza̱ ya ìchər ka̱ apal alyer kang ká̱ oga akpap iɓəl ka̱ ishishi. ");
INSERT INTO yer_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","UShawulu là ûMikal pa̱, <<Sang kang u lam mi wa nta̱ yà kang u re ukpa ìkum mi gà yà?>> UMikal là a na pa̱, <<Uza̱ là a mi pa̱, <Re mi ngga. Le kang ma gba̱l ɓu.> >> ");
INSERT INTO yer_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Awalang va̱ uDawuda chər chit, te uza̱ ga atak aSamuwel ka̱ aRama, kang uza̱ là á na nkpaktak iya̱m va̱ uShawulu nəm á na. Te uSamuwel ká̱ uDawuda ga aNayot kang à təm ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Mmá là ûShawulu pa̱, <<UDawuda wa ka̱ aNayot ka̱ aRama,>> ");
INSERT INTO yer_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","te uza̱ re onunggwan pa̱ á ga á kpan na. Ǹnyi te, awalang va̱ oza̱ ga ya idongkong onəm oga nlà ìchu Inan ka̱ nlà iya̱m va̱ ka̱ ngga nfa, kang uSamuwel wa ka̱ ta wa anəm uga mpyal oza̱, te aruhu Inan vàng ka̱ apal onunggwan aShawulu, kang oza̱ ɓàn nlà iya̱m va̱ i ga nfa kpa. ");
INSERT INTO yer_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Mmá là ûShawulu iya̱m va̱ kà̱ nchen te, uza̱ re nre ká̱ onunggwan okak ka̱ɗi kang oza̱ là iya̱m va̱ iga nfa kpa. UShawulu re nre ká̱ onunggwan ngga nshishat kang oza̱ ɓàn nlà iya̱m va̱ i ga nfa kpa. ");
INSERT INTO yer_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Ká̱ nkukur te, uza̱ wong ká̱ ishi wò kà̱ ngga aRama kang uza̱ ga chu ache ndəng nchumchum nka̱pka̱p ka̱ aSeku te, uza̱ ɓəp pa̱, <<USamuwel ká̱ uDawuda ka̱ che yà?>> Mmá là á na pa̱, <<Oma yà ka̱ aNayot ka̱ aRama.>> ");
INSERT INTO yer_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Te uShawulu ga aNayot ka̱ aRama. Ǹnyi te, aRuhu Inan vàng ka̱ apal ishishi kpa kang uza̱ kà̱ nchen kà̱ nlà iya̱m va̱ i ga nfa uza̱ ga chu ká̱, ka̱ aNayot. ");
INSERT INTO yer_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Uza̱ zə̀p ilukwan wò kang uza̱ là iya̱m va̱ i ga nfa kpa kà̱ mpyal aSamuwel. Uza̱ ra umaləng nkpaktak alum ká̱ izwam. Iya̱m va ta̱ nak kang onəm i là pa̱, <<UShawulu ka̱ ashe onəm oga nlà ìchu Inan kpa ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Te uDawuda chər ka̱ aNayot ka̱ aRama ga atak aJonatan. Uza̱ ɓəp na pa̱, <<Iza̱ n nəm yà? Iza̱ mpat mi yà? N nəm mpat ûpo ɓu wa nsang kang uza̱ ɗom pa̱ ô gbá̱l mi yà?>> ");
INSERT INTO yer_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Te uJonatan là pa̱, << Pa ka̱t, mmaɓu kà̱ ngga nkú ka̱t. Dər, upo mi i yà kà̱ nnəm iya̱m iro ichumchum ka̱t te iɓwakan i va uza̱ i nəm mi nyi ka̱t ɗò ka̱t. Ka̱kul iza̱ kang uza̱ i bwam i va̱ ta̱ kà̱ mi yà? Iya̱m iro yà pa ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Ǹnyi te, uDawuda sóng anung là pa̱, <<Upo ɓu nyinyi pa̱ kpátkpát pa̱ nna n yà ká̱ nchə̀r mba̱lba̱l kà̱ mpyal ɓu, te uza̱ là ishi wò pa̱, <A màl pa̱ uJonatan á nyi nnap va̱ ta ka̱t, ka̱t te i lak ìgwak a na.> Nva̱ uYawe wa yà ká̱ iriri kang na u yà ká̱ iriri te, ishimshe mi ká̱ ikú a ɓur ntong ashar.>> ");
INSERT INTO yer_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","UJonatan là ûDawuda pa̱, <<Nkpaktak iya̱m va̱ u ɗom pa̱ n nəm a ɓu te, mi nənəm a ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Te uDawuda là á na pa̱, <<Dər, ipin te mí ga nnəm nchang izər ngga ape apipe, kang a màl pa̱ n təm nrì iya̱m-nrì nzəng ká̱ uponzhi, ǹnyi te, re mi mbwam ka̱ ashe nzam a ga a chu arurong aga nra ngga nshatɗing kang. ");
INSERT INTO yer_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","A yà pa̱ upo ɓu a lang mi te, là a na pa̱, <UDawuda chál mɓa̱r pa̱ ô ga nzhi wò ka̱ aBet-Lehem kəlak kang, ka̱kul nləfər ngga akum ìjili oza̱ ngga nza̱ ìzun nggo.> ");
INSERT INTO yer_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","A yà pa̱ uza̱ là pa̱, <Dakdak,> te i nyám ɗak pa̱ uzwal ɓu yà ká̱ nɗaktak ka̱t. Ǹnyi te, a yà pa̱ uza̱ mən ìkum ká̱ ɓu te, ɓu nyi ɗak pa̱ uza̱ kà̱ nɗom nnəm iɓá̱ngɓa̱ng á mi. ");
INSERT INTO yer_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Mmaɓu te, wa nyám nnap nnəna̱n ûzwal ɓu, ka̱kul u yar nsar nnap-nlà ká̱ mi chit kà̱ mpyal aYawe. A yà pa̱ m pat te, wa gbá̱l mi ká̱ ishi ɓu. Sang kang ɓu na mi ka̱ ashe awó apo ɓu yà?>> ");
INSERT INTO yer_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","UJonatan là pa̱, <<Pa ka̱t, ka̱ yà pa̱ n nyinyi pa̱ upo mi uwa ya ká̱ iɓá̱ngɓa̱ng iro ka̱kul ɓu te, ká̱ nlà a ɓu ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","UDawuda ɓəp uJonatan pa̱, <<A yà pa̱ upo ɓu ma̱n a ɓu ká̱ ìkum te, uda i là á mi yà?>> ");
INSERT INTO yer_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","UJonatan là á na pa̱, <<Fa í ga ashe agbagba.>> Te oza̱ fa ga ashe agbagba. ");
INSERT INTO yer_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Te uJonatan là ûDawuda pa̱, <<N sóng anung kà̱ mpyal àYawe, Inan ìga aIsa̱rila, ká̱ awalang wanta̱ ìpin ka̱t te nlomo te, mi ɗak na n nyi nrəng nnàp àpo mi. A yà pa̱ uza̱ uwa ya ká̱ iya̱m iro ká̱ ìgwak ka̱ apal ɓu te, mi re ǹre mí là a ɓu. ");
INSERT INTO yer_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Ǹnyi te, a yà pa̱ upo mi uwa ɗom nnəm iya̱m iɓá̱ngɓa̱ng iro a ɓu te, re uYawe á nyán ká̱ uJonatan pa̱ gənggəng, a yà pa̱ n nyám ka̱ a ɓu ka̱t kang nre ɓu u ga ká̱ ikangkang. Te re uYawe á yà nzəng ká̱ ɓu wa nva̱ uza̱ ka̱ yà nzəng ká̱ upo mi á. ");
INSERT INTO yer_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Ǹnyi te, nyám ikin ikúrkùr ka̱t á mi wa ikin aYawe a yà pa̱ n na n yà ká̱ irirì á, na kang mmá gba̱l mi ka̱t. ");
INSERT INTO yer_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","Awalang va̱ uYawe á zhì nkpaktak okpa ìkum aDawuda ka̱ apambin te, kang wa re nyám ikin ɓu n̂zhi mi ka̱t mbyet mbyet.>> ");
INSERT INTO yer_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Te uJonatan yar nsàr nnap-nlà ká̱ nzhi àDawuda là pa̱, <<Re uYawe á zhì okpa ìkum aDawuda pa̱ kpaktak.>> ");
INSERT INTO yer_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Kang uJonatan nak uDawuda yar nsóng anung kà̱ɗi ka̱kul ma̱n va̱ uza̱ ká̱ a na, ka̱kul uza̱ ma̱n na wa va uza̱ ma̱n ishi wò. ");
INSERT INTO yer_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Te uJonatan là ûDawuda pa̱, <<Ìpin te, mí nəm nchang izər ngga ape apipe kang mí lang ɓu ka̱kul atak ntəm ɓu i təm nlakchi. ");
INSERT INTO yer_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Nlomo ka̱ arurong te, ga atak va̱ ka̱ u bwam ká̱ awalang va̱ nɗaktak va̱ ta̱ ɓan, kang ɓu lok kà̱ ngba̱k ìpang aEzel. ");
INSERT INTO yer_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Mi tat iwar pa̱ ishatɗing i ga ngba̱k ìpang va̱ ta, na mmami kà̱ mmang ìji. ");
INSERT INTO yer_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Te mi re uyen ununggwan kang mi là a na pa̱, <Ga mwo iwar va̱ ta.> A yà pa̱ n là á na pa̱, <Dər, iwar va̱ ta kà̱ ngba̱k va ta̱, kà̱ ishimshe mi ká̱ ɓu, ɓa ká̱ ka̱ ta̱,> te wa ɓa, ka̱kul wa nva uYawe wa ká̱ iriri te, na u yà ká̱ iriri, nɗaktak nro yà ka̱t. ");
INSERT INTO yer_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Ǹnyi te, a yà pa̱ n là ûyen ununggwan va̱ ta pa̱, <Dər, iwar na yà kà̱ mpyal ɓu,> te nkpak pa̱ u ga, ka̱kul uYawe re ɓu chit pa̱ u ga achen ɓu. ");
INSERT INTO yer_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Kang ka̱ apal iya̱m va̱ ta̱ ká̱ i shal te, i rəng ká̱, uYawe uwa sat ká̱ ishimshe mi ká̱ ɓu mbyet.>> ");
INSERT INTO yer_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Te uDawuda bwam ka̱ ashe nzam, kang awalang va̱ mmá ɓàn nnəm nchang izər ngga ape apipe te, uponzhi təm pa̱ ô ri iya̱m-nrì. ");
INSERT INTO yer_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","Uza̱ təm ka̱ atak va̱ uza̱ mmà təm ka̱ ka̱ izər nzhi, uJonatan təm màl ikwoksok ká̱ na, kang uAbner təm kà̱ ngba̱k aShawulu, ǹnyi te, atak ntəm aDawuda təm nlakchi. ");
INSERT INTO yer_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","UShawulu là iya̱m iro n̂da va̱ ta ka̱t, ka̱kul uza̱ rəng pa̱, <<Iya̱m iro na ya uDawuda va nak na yà ká̱ adak. Nna nak kang uza̱ yà ka̱ atak nchang izər ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Ǹnyi te, ipin fa kpa̱k, kà̱ nra ngga mparəm ngga ape te, atak aDawuda nna a təm nlakchi. Te uShawulu ɓəp uyən wò uJonatan pa̱, <<Iza̱ nak kang uya àJese ɓa atak nri iya̱m-nrì ka̱ nlam ka̱t, ka̱t te n̂da ka̱t yà?>> ");
INSERT INTO yer_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","UJonatan na ama̱n pa̱, <<UDawuda ɓəp mɓa̱r ɓəp ka̱ atak mi pa̱ ô ga aBet-Lehem. ");
INSERT INTO yer_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","Uza̱ là á mi pa̱,<Re mi n ga, ka̱kul nzhi yi ka̱ ngga nnəm nləfər ka̱ ashe ìtong, kang ugənang mi nak pa̱ n yà ka̱ ta. A yà pa̱ nchə̀r mi bəba̱l kà̱ mpyal ɓu te, re mi, n ga n ya ogənang mi.> Nna nak kang uza̱ ɓa atak nri iya̱m-nrì aponzhi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","UShawulu yà ká̱ nlàk ìgwak pa̱ gənggəng kà̱ uJonatan kang uza̱ là á na pa̱, <<Mmaɓu uyen ununggwan ulakchilakchi, amar achar umaimai. N nyinyi pa̱ mmaɓu kà̱ nlə́p asəm uDawuda uya aJese na a yà uponzhi ka̱ anung ɓu, wanta na u ɗom pa̱ u ná iwuswa îshi ɓu ká̱ unang va̱ mar ɓu ɗò? ");
INSERT INTO yer_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Nva̱ pa̱ uya aJese uwa ká̱ irirì ka̱ apambin va̱ ta̱ te, ɓu yà uponzhi ka̱t. Ǹyangmata̱ te, re unəm uro á ɓa ká̱ na a mi, ka̱kul nkpak pa̱ uza̱ a kú.>> ");
INSERT INTO yer_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Te uJonatan ɓəp upo wò pa̱, << Mí gbá̱l na ka̱kul iza̱ yà? Iza̱ uza̱ nəm yà?>> ");
INSERT INTO yer_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Ǹnyi te, uShawulu mang na ká̱ aɓár pa̱ na ô gbá̱l na. Nna chit te, uJonatan nyi ɗak pa̱, upo wò ka̱ nɗom ngbá̱l uDawuda. ");
INSERT INTO yer_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Te uJonatan wong ka̱ apal atebəl ka̱ ashe nlàk ìgwak pa̱ gənggəng, kà̱ nra ngga mparəm ngga nchang izər va̱ ta, uza̱ ri iya̱m-nrì ka̱t, ka̱kul a ɗak na byet ka̱ iya̱m va̱ upupo là a na ka̱ apal aDawuda. ");
INSERT INTO yer_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Ká̱ ìpin te, uJonatan fa ga ashe nzam pa̱ na ô gwang ká̱ uDawuda wa nva oza̱ ka̱ sar á. Uza̱ ga ká̱ uyen ununggwan uɓwakan nzəng ká̱ na, ");
INSERT INTO yer_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","kang uza̱ là ûyen ununggwan va̱ ta pa̱, <<Chə́r na u mwo iwar va̱ n tat.>> Nva̱ uyen ununggwan va̱ ta ka̱ nchə́r te, uza̱ mang ìwar ka̱ mpipyal. ");
INSERT INTO yer_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Awalang va̱ uyen ununggwan va̱ ta ɓa chu atak va̱ ìwar aJonatan ru ka̱ te. UJonatan wor na là pa̱ <<Ìwar yà ka̱ mpyal ɓu ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Te uza̱ ləp achu á na pa̱, <<Ghəgha̱n, ga pa̱ kəlak, kang wa kali ka̱t.>> Te uyen ununggwan va̱ ta yar ìwar va̱ ta kang a ga ká̱ ûnəm uga nzhi wò. ");
INSERT INTO yer_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Uyen ununggwan va̱ ta nyi iya̱m iro ka̱ apal nkpaktak iya̱m va̱ ta ka̱t. UJonatan ká̱ uDawuda oma nyi chwat. ");
INSERT INTO yer_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Te uJonatan na oga iya̱m aɓang wò ûyen ununggwan va̱ ta kang à là a na pa̱, <<Wur, ga ka̱ oza̱ kà̱ ìtong.>> ");
INSERT INTO yer_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Nva̱ngva̱ uyen ununggwan va̱ ta ga chit, te uDawuda fa ka̱ asa̱l nkwandal ìpang va̱ta kang à ɓəram kà̱ mpyal aJonatan nva̱ng pa̱ nshatɗing, uza̱ kwangtal asa̱l awu wò ka̱ avəng. Te oza̱ fəkchi owan oza̱ kang oza̱ yə́ng, ǹnyi te, uDawuda uwa yə́ng ji. ");
INSERT INTO yer_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","UJonatan là ûDawuda pa̱, <<Ga ká̱ ikángkáng, ka̱kul í yar nsar nnap-nlà ikpa owan yi chit ka̱ ashe aɗin aYawe, i là pa̱, <UYawe uwa sat ka̱ ishimshe mi ká̱ ɓu, kang ka̱ ishimshe oga akum ìjili ɓu ká̱ oga akum ìjili mi mbyet.> >> Te uDawuda ga, kang uJonatan le ga ashe ìtong. ");
INSERT INTO yer_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","UDawuda ga aNop ka̱ atak aAhimelek unəm uga mpyal awop. UAhimelek ya na te a tán, kang uza̱ ɓəp na pa̱, <<Sang kang mmaɓu ka̱ nkukwa, unəm uro nzəng ká̱ ɓu ka̱t yà?>> ");
INSERT INTO yer_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","UDawuda na ama̱n ûAhimelek unəm uga mpyal awop pa̱, <<Uponzhi re mi ka̱ nre, kang a là a mi pa̱, <Kang unəm uro a nyi iya̱m iro ka̱ apal nre va̱ mmami kà̱ nre ɓu kà̱ ka̱t.> N là atak va̱ ônəm mi chit pa̱ oza̱ a gwang mi kà̱. ");
INSERT INTO yer_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Ǹyangmata̱ te, iza̱ mmaɓu ká̱ yà? Na nzəngkəng á mi pa̱ ntukun, ka̱t te iya̱m va kap mmaɓu ká̱ á.>> ");
INSERT INTO yer_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Ǹnyi te, unəm uga mpyal awop na ama̱n ûDawuda pa̱, <<N yà ka̱ nzəngkəng ngga nri onəm pa̱ vàvà ka̱t, nva̱ mmami ka̱ te nzəngkəng ǹyəryər, o riri, a yà pa̱ ovan nza̱m va̱ mmaɓu ká̱ oma ra ka̱ ochar chit ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","UDawuda na ama̱n pa̱, << Pa̱ ɗəkər te, í pángchí ishi yi ka̱ nnap ochar a yà pa̱ í wong achen wa nva̱ ta̱. Kang jwak pa̱ achen va̱ ta̱ ká̱ ipipir.>> ");
INSERT INTO yer_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Te unəm uga mpyal awop na nzəngkəng ǹyəryər á na ka̱kul pa̱ nzəngkəng nro yà ka̱ atak ka̱t, nva̱ ka̱ ta te, nva mmá yar chit kà̱ mpyal àYawe ka̱ apal atebəl, kang mmá nak nkak nsur ka̱ atətak. ");
INSERT INTO yer_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","N̂da va̱ ta te uDoyek unəm oEdom, unəm uga mpyal ga nkpak iya̱m nkang àShawulu uwa ka̱ta, uva mmá gəl na kà̱ mpyal àYawe. ");
INSERT INTO yer_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","UDawuda ɓəp uAhimelek pa̱, <<Nna u ya ká̱ aɓár ka̱t te ndokchi ka̱ ta̱ ɗò? N yar ndokchi ka̱t te iya̱m ìkum iro ka̱t, ka̱kul inok aponzhi iga ijəjak, á nak te n fa ka̱ nggha̱n.>> ");
INSERT INTO yer_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","UAhimelek na ama̱n pa̱, <<Ndokchi aGoliyat unəm oFilisti na byet uva u gbá̱l ka̱ mba̱nda̱m aEla, na mmá chəndər mmá nak ka̱ nsəm ìlukwan ìkwoksok. Yar a yà pa̱ u ɗuɗom á, ka̱kul nna mmami ká̱ byet.>> Te uDawuda là pa̱, <<Á ɓyen byet, na á mi.>> ");
INSERT INTO yer_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Ka̱ n̂da va̱ ta te, uDawuda chər ka̱ atak aShawulu kang a ga atak aAkish, uponzhi uga aGat. ");
INSERT INTO yer_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Ǹnyi te, okpari aAkish là á na pa̱, <<UDawuda va ta̱ uponzhi uga mbin ka̱t ɗò? Uwa oIsa̱rila i shì nnap ká̱ na pa̱, << <UShawulu gbá̱ng oji wò ikalong, kang uDawuda gbá̱ng oji wò ikalong pa̱ igba̱pchi> ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","UDawuda kpan oga nnap-nlà va̱ ta̱ ka̱ ìgwak kang ayər nəm na pa̱ gənggəng ka̱kul aAkish uponzhi uga aGat. ");
INSERT INTO yer_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Te uza̱ ga̱ɓa̱n i nəm wa anəm ura̱nra̱n, nkpaktak awalang va̱ uza̱ nzəng ká̱ oza̱ te, uza̱ i nəm wa anəm ura̱nra̱n, uza̱ i cha iya̱m ka̱ izər anung oga asa̱l kang uza̱ re nshí i wàr á na ka̱ nggyer. ");
INSERT INTO yer_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","UAkish là ôkpari wò pa̱, <<Ó dər, unəm va̱ ta̱ á rəra̱n. Sang kang ó ɓa ká̱ na á mi yà? ");
INSERT INTO yer_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","N lang onəm ora̱nra̱n kang o ɓa ka̱ unəm va̱ ta̱ pa̱ a pak inok nnəm nra̱n kà̱ mpyal mi ɗò? Nkpak pa̱ unəm a ta̱ a ɓa mpyal mi ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","UDawuda re aGat kang uza̱ chər ga agba̱k aga aAdulam. Awalang va̱ ogənanggənang ká̱ nkpaktak onəm oga nzhi apupo fe te oza̱ fa ga ya na ka̱ta. ");
INSERT INTO yer_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Nkpaktak onəm va̱ ka̱ ashe mɓək anung, ká̱ ovəngva̱ ká̱ akat, ká̱ ovəngva̱ ká̱ mɓa̱ng ìgwak, oza̱ ɓut ka̱ atak aDawuda. Onəm ga chu ìgba̱l pa̱ ìneɗing kang uza̱ yà unəm uga mpyal oza̱. ");
INSERT INTO yer_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Ka̱ ta te uDawuda wong ga aMizpa kà̱ mbin aMowap, kang uza̱ là ûponzhi oMowap pa̱, << Kusuk ɓu məma̱n pa̱ n re upo mi ká̱ unang mi á təm ka̱ atak ɓu, na ń nyi iya̱m va̱ Inan i ga nnəm á mi kang ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Te uza̱ re oza̱ ká̱ uponzhi oga aMowap kang oza̱ təm ká̱ na ka̱ ashe nkpaktak awalang va̱ uDawuda uwa kà̱ mbwam ka̱ atak mbwam wò á. ");
INSERT INTO yer_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Ǹnyi te, unəm uga nlà ìchu Inan, uGat là ûDawuda pa̱, <<Kang wa təm ka̱ ashe atak va̱ mmaɓu kà̱ mbwam ka̱ ka̱t. Ga ashe mbin aYahuda.>> Te uDawuda ga ashe ikun iga aHeret. ");
INSERT INTO yer_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Ǹyangmata̱ te, uShawulu fe pa̱ mmá ya atak aDawuda ká̱ onəm wò chit. Kang uShawulu uwa ka̱ ntəm ka̱ aGibeya ka̱ avəng ìkun atamariki ka̱ apal aɗuktum, uwa ká̱ aɓár ka̱ awo, kang onəm oga nəm inunok tong ka̱ nggbəgba̱k. ");
INSERT INTO yer_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","Uza̱ là ôza̱ pa̱, <<Ó gwong achwang ônunggwan oga aBenjamin, uya aJese i na iram na ká̱ iram iba̱ngba̱ng nkpaktak wo ɗò? Uza̱ i nak nkpaktak wo nak ó sat onəm oga mpyal oshozha ikalong ka̱t te igba̱l ɗò? ");
INSERT INTO yer_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","Nna nak kang nkpaktak wo ó gwang anung ka̱ apal mi ɗò? Unəm uro yà là á mi ka̱t, awalang va̱ uyen mi yar nsar nnap-nlà ká̱ uya aJese. A ɗak unəm uro ká̱ mi ka̱t, ka̱t te á là á mi pa̱ uyen mi nok ukpari mi pa̱ á ra anyimnyal kà̱ mi, wa nva̱ uza̱ nəm ká̱ nda va̱ ta̱ á.>> ");
INSERT INTO yer_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Ǹnyi te, uDoyek unəm uga aEdom, uva ka̱ yà kà̱ nsat nzəng ká̱ onəm oga nnəm inok aShawulu te, á là pa̱, <<N ya uya aJese ɓa atak aAhimelek uya aAhitub ka̱ aNop. ");
INSERT INTO yer_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","UAhimelek ɓəp uYawe a na. Uza̱ na iya̱m-nrì á na kpa ká̱ ndokchi àGoliyat unəm oFilisti.>> ");
INSERT INTO yer_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Te uPonzhi re ǹre kà̱ uAhimelek uya aAhitub unəm uga mpyal awop ká̱ nkpaktak onəm oga nzhizhi, ova onəm oga mpyal awop ka̱ aNop, kang nkpaktak oza̱ ɓa atak aponzhi. ");
INSERT INTO yer_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","UShawulu là pa̱, <<Gwong achwang kà̱ mi, á ya aAhitub.>> Uza̱ na ama̱n pa̱, <<Mmami kà̱ nfe ɓu ánəm uga nzhi.>> ");
INSERT INTO yer_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","UShawulu là a na pa̱, <<Iza̱ nak kang ó gwang anung kà̱ mi, mmaɓu ká̱ uya aJese, u na iya̱m-nrì á na ká̱ ndokchi, kang u ɓəp Inan á na, nnà kang uza̱ fa iya̱mkak ká̱ mi, kang i ra anyimnyal kà̱ mi, wa nva̱ uza̱ nəm n̂da va̱ ta̱ yà?>> ");
INSERT INTO yer_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","UAhimelek na ama̱n ûponzhi pa̱, <<Unəm uro wa yà ka̱ ashe nkpaktak okpari ɓu ká̱ nnandər wa aDawuda ugwar ɓu, uwa unəm uga mpyal onəm oga mpángchí ɓu, kang uwa mmá na ichumchum á na ji ka̱ ashe nzhi ɓu ɗò? ");
INSERT INTO yer_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Nna ta̱ kang mmami kà̱ mɓəp Inan ka̱kukul nggəshi ɗò? Wanta ka̱t, re kang uponzhi a ná mpat ûkpari wò ka̱t te unəm uro ka̱ ashe nzhizhi ka̱t, ka̱kul ukpari ɓu nyi iya̱m iro ka̱ apal ngwang anung ka̱ apal ɓu ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Ǹnyi te, uponzhi là pa̱, <<ÁAhimelek, nkpak pa̱ u kú mmaɓu ká̱ nkpaktak nzhi apo ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","Te uza̱ là ônəm oga mpángchí na va̱ kà̱ mbəbəp pa̱, <<Ó gbá̱ng onəm oga mpyal awop aYawe va̱ ta̱, ka̱kul oza̱ gwang anung ká̱ uDawuda. Oza̱ nyinyi pa̱ uza̱ ka̱ nchə́r, te unəm uro ka̱ ashe oza̱ là á mi ka̱t.>> Ǹnyi te, onəm oga mpyal àponzhi yang ká̱ ngha̱p awo pa̱ na ó ngbá̱ng onəm oga mpyal awop aYawe va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Te uponzhi là ûDoyek pa̱, <<Ga̱ɓa̱n gbá̱ng onəm oga mpyal awop va̱ ta̱.>> Te uDoyek unəm uga aEdom gbá̱ng oza̱. N̂da va̱ ta te, uza̱ gbá̱ng onəm ìsəm pa̱ na̱nne ama̱n pa̱ tukun, ova̱ mwak ilukwan ikwoksok iga alinin. ");
INSERT INTO yer_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","UShawulu nak kpa mmá gbá̱ng onəm oga aNop, ìtong onəm oga mpyal awop. Mmá gbá̱ng onunggwan ká̱ ochar, ovan ká̱ ovanba̱k, ká̱ ina, ká̱ azhaki, ká̱ itam. ");
INSERT INTO yer_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Ǹnyi te, uAbiyatar uzəngtəng ka̱ ashe ovan onunggwan àAhimelek uya aAhitub, a mulit kang à chər ga atak aDawuda. ");
INSERT INTO yer_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","Uza̱ là ûDawuda pa̱, <<UShawulu gbá̱ng onəm oga mpyal awop aYawe chit.>> ");
INSERT INTO yer_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Te uDawuda là ûAbiyatar pa̱, <<Ka̱ awalang va̱ n ya uDoyek unəm oga Edom ka̱ta n̂da va̱ ta te, n nyi nkpak pa̱ uza̱ i ləlà ûShawulu. Ka̱kul mi na mmá gbá̱ng onəm oga nzhi ɓu pa̱ kpaktak. ");
INSERT INTO yer_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Təm ká̱ mi, kang ayər a nəm ɓu ka̱t. Unəm va̱ kà̱ nɗom ngbá̱l ɓu te, kà̱ nɗom ngba̱l mi na kpa. Nzəng ka̱ mi te, iya̱m iro i nəm ɓu ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Awalang va̱ mmá là ûDawuda pa̱, <<OFilisti ka̱ nlung ìkum ká̱ aKeyila, kang ka̱ ngwur ìpirkur ká̱ ayi ka̱ atak mpə́k iya̱m,>> ");
INSERT INTO yer_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","te uza̱ ɓəp uYawe pa̱, <<N ga na n ru oFilisti va̱ta ká̱ ìkum ɗò?>> UYawe na ama̱n á na pa̱, <<Ga na u ru oFilisti ká̱ ìkum, na u ka̱mshi aKeyila.>> ");
INSERT INTO yer_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Ǹnyi te, onəm aDawuda là á na pa̱, <<Ka̱ ta̱, ka̱ ashe mbin aYahuda te, mmayi ka̱ ntəm ká̱ ayər, te i yà sáng kang pa̱ i ga aKeyila na i lung oshozha oFilisti yà?>> ");
INSERT INTO yer_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","UDawuda ɓəp uYawe kà̱ɗi, kang uYawe na ama̱n á na pa̱, <<Ga aKeyila, ka̱kul mmami kà̱ ngga nna oFilisti ka̱ ashe awo ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Te uDawuda ká̱ onəm wò ga aKeyila. Oza̱ nyán ka̱ oFilisti kang à gbá̱ng oza̱ pa̱ makmak, oza̱ wur iya̱m nkang oza̱, kang oza̱ ka̱mshi onəm oga aKeyila. ");
INSERT INTO yer_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","Awalang va̱ uAbiyatar uya aAhimelek chər ga atak aDawuda ka̱ aKeyila te, uwa ka̱ ya ká̱ ìlukwan ìkwoksok. ");
INSERT INTO yer_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","UShawulu fe pa̱ uDawuda ka̱ aKeyila te, uza̱ là pa̱, <<A ɓyen paɗi, Inan ná na chit ka̱ ashe awo mi. Ka̱kul uza̱ tar ajəp chit, nva̱ uza̱ tar ashe ìtong va mmá ká ká̱ akamsəlang kang mí kùk anunung kùk ká̱ ndar acham nnárnàr.>> ");
INSERT INTO yer_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","Te uShawulu wór nkpaktak oshozha wò ka̱kul ìkum, pa̱ oza̱ á ga aKeyila oza̱ á gang uDawuda ká̱ onənəm. ");
INSERT INTO yer_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Awalang va̱ uDawuda fe iya̱m iɓá̱ngɓa̱ng va̱ uShawulu kà̱ nɗom nnənəm a na te, uza̱ là ûAbiyatar unəm uga mpyal awop pa̱, <<Ɓa ká̱ ìlukwan ìkwoksok va̱ ka̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Te uDawuda far pa̱, << ÁYawe, Inan oIsa̱rila, n fe pa̱ uShawulu kà̱ nɗom pa̱ ô ɓa ô zhì aKeyila ka̱kul mi. ");
INSERT INTO yer_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","Onəm oga aKeyila i na mi na á na ɗò? UShawulu i vəvang wa nva̱ mmami uzwal ɓu nfe ɗò? ÁYawe, Inan oIsa̱rila, là ûzwal ɓu.>> Te uYawe na ama̱n pa̱, <<Uza̱ i vəvang.>> ");
INSERT INTO yer_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","UDawuda ɓəp kà̱ɗi pa̱, <<Onəm oga aKeyila i na mi na ká̱ onəm mi ûShawulu ɗò?>> Te uYawe ma̱n pa̱, <<Oza̱ i na wó na.>> ");
INSERT INTO yer_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","Te uDawuda ká̱ onəm wò ìgba̱l pa̱ ìkpa̱ɗing fa re aKeyila, oza̱ i ranggang atak pa̱ kpakpa. Awalang va̱ uShawulu fe chit pa̱ uDawuda fa chit re ashe aKeyila, te uza̱ ɗak ngga a ta lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","UDawuda təm ka̱ atak mbwam ka̱ aɗuktum aga ashe nzam mmaləng aZif. UShawulu nəm inok nram na ka̱ ashe nzam nra ka̱ apal nra, ǹnyi te, Inan ná na ka̱ ashe awo aShawulu ka̱t. ");
INSERT INTO yer_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","Nva̱ uDawuda uwa ka̱ yà ka̱ aHoresh ka̱ ashe nzam aZif te, uza̱ fe pa̱ uShawulu fa ka̱ nram na pa̱ na ô gbá̱l. ");
INSERT INTO yer_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","Kang uJonatan uya àShawulu ga atak aDawuda ka̱ aHoresh, á na nkám ìrəng á na pa̱ uza̱ á sat kà̱ Inan á kəkam. ");
INSERT INTO yer_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","UJonatan là á na pa̱, <<Kang ayər á nəm ɓu ka̱t. Awo apo mi uShawulu i yà ka̱ ndok ɓu ka̱t. Mmaɓu ka̱ ngga ǹya uponzhi oIsa̱rila, kang mi yà uga uparəm ɓu. Upo mi uShawulu nyi nva̱ ta nyi.>> ");
INSERT INTO yer_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","Mparəm oza̱ yar nsar nnap-nlà owan oza̱ ka̱ mpyal àYawe. Te uJonatan le nzhi ǹnyi te, uDawuda təm ka̱ aHoresh. ");
INSERT INTO yer_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Onəm oga aZif ga atak uShawulu ka̱ aGibeya kang oza̱ là á na pa̱, << UDawuda uwa yà kà̱ mbwam ka̱ ashe yi, ka̱ atak mbwam ngga aHoresh ka̱ aɗuktum aHakila, ava ka̱ nkwandal aJeshimon ka̱t ɗò? ");
INSERT INTO yer_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Irirì aponzhi a gba̱ng, ìlum va̱ wa ɗom te, wa vàng, í kpan na í na ka̱ ashe awo ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","UShawulu na ama̱n pa̱, <<UYawe á nak nnap nnəna̱n á wó, ka̱kul ó nak ishi ká̱ mi. ");
INSERT INTO yer_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","Ó ga na ó ɓəp nnap ka̱ apəpal pa̱ makmak, ó ɓəp atak va̱ uDawuda i ga kà̱, ká̱ onəm va̱ ya na. ka̱kul mmá là á mi pa̱ uza̱ tan byet. ");
INSERT INTO yer_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","Ó ga ó dər na o nyi oga atak va̱ uza̱ i bwam kà̱, na ó ɓa ka̱ nnandərnandər á mi. Te mi ga nzəng ka̱ wó, kang a yà pa̱ u wa ka̱ atak va̱ ta, te mi ram na kà̱ atak va̱ uza̱ bwam kà̱, kà̱ nkpaktak aYahuda.>> ");
INSERT INTO yer_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","Te oza̱ wong ga aZif mpyal uShawulu. UDawuda ká̱ onəm wò oma ka̱ ashe nzam mmaləng aMayon ka̱ mba̱nda̱m aAraba ka̱ nkwandal aJeshimon. ");
INSERT INTO yer_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","UShawulu ká̱ onəm wò fa kà̱ nram uDawuda, kang nva̱ngva̱ uDawuda fe te, uza̱ fər ga anang aɗuktum aga ashe nzam mmaləng aMayon kang uza̱ təm ka̱ta. Awalang va̱ uShawulu fe chit pa te, uza̱ ɓàk nvəva̱ng ka̱ ashe nzam mmaləng va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","UShawulu ká̱ onəm wò kà̱ ngga kà̱ ngba̱k anang aɗuktum nro, ǹnyi te, uDawuda ká̱ onəm wò kà̱ ngba̱k nzəngtəng. UDawuda ka̱ onəm wò kà̱ nggha̱n pa̱ na ó chəng ka̱ atak aShawulu. UShawulu ká̱ onəm wò ɓa dat pa̱ na ó kpán uDawuda ká̱ onənəm te, ");
INSERT INTO yer_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","unəm uga ǹre ɓa là ûShawulu pa̱, <<Ɓa pa̱ kəlak, oFilisti ɓa ru oIsa̱rila chit ká̱ ìkum.>> ");
INSERT INTO yer_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Te uShawulu re ngwà uDawuda kang à le ga nlung oFilisti. Nna nak te, mmá wór aɗin atak va̱ ta pa̱, aƊuktum aga nKap. ");
INSERT INTO yer_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","Te uDawuda kyén ɓa ga atak mbwam ngga aEngedi təm ka̱ta. ");
INSERT INTO yer_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Ka̱ nva̱ngva̱ uShawulu le chit ka̱ atak nnəm ìkum ká̱ oFilisti te, mmá là á na pa̱, <<UDawuda uwa ka̱ ashe nzam mmaləng ngga aEngedi.>> ");
INSERT INTO yer_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Te uShawulu yak oshozha ìkalong pa̱ ishatɗing ka̱ ashe nkpaktak oIsa̱rila pa̱ oza̱ á ga á ram uDawuda ká̱ onəm wò dát ká̱ Ipang Iɓəl iga ashe Nzam. ");
INSERT INTO yer_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Nva̱ uShawulu chu atak oga afo itam ka̱ apal asa̱l te, uza̱ tar ashe agba̱k pa̱ na ô man aməng. UDawuda uwa yà kà̱ nkur agba̱k va̱ ta ká̱ onəm wò kà̱ mbwam ka̱ta. ");
INSERT INTO yer_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Onəm aDawuda là á na pa̱, <<Ìlum va ta̱ uYawe ka̱ là nnap kà̱, nva̱ uza̱ ka̱ là a ɓu pa̱, <Mi na unəm uga nkpang ɓu ka̱ ashe awo ɓu, na u nəm iya̱m va̱ ka̱ na u ɗom á.> >> Te uDawuda nár ga pà arwangchwang ìlukwan aShawulu nzəng ká̱ nnyi aShawulu ka̱t. ");
INSERT INTO yer_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Ka̱ nvəva̱ng te, ìgwak aDawuda ra ka̱t, ka̱kul nva̱ uza̱ pà arwangchwang ìlukwan aShawulu á. ");
INSERT INTO yer_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Uza̱ là ônəm wò pa̱, <<UYawe a kap mi ká̱, nva̱ pa̱ nnəm iya̱m va̱ ta ûnəm uga nzhi mi, ugorgor aYawe, ka̱t te, n dok na ká̱ awo mi ka̱kul uza̱ uwa ugorgor aYawe.>> ");
INSERT INTO yer_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Ká̱ oga nnap-nlà va ta̱ uDawuda ra̱n ká̱ onəm wò, kang uza̱ gəl oza̱ kà̱ ngbá̱l uShawulu. Te uShawulu fa ka̱ ashe agba̱k ga iya̱m wò. ");
INSERT INTO yer_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Te uDawuda fa ka̱ ashe agba̱k kang à wór uShawulu pa̱ gbá̱ngbá̱ng pa̱, <<Ánəm uga nzhi mi, uponzhi.>> Ka̱ awalang va̱ uShawulu ga̱ɓa̱n ya uDawuda te, uDawuda ru zəp ká̱ afu kà̱ mbin. ");
INSERT INTO yer_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Uza̱ là ûShawulu pa̱, <<Sang kang ɓu gwong achwang kà̱ onəm va̱ là pa̱, <UDawuda kà̱ nɗom nnəm inga a ɓu> yà? ");
INSERT INTO yer_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","N̂da va̱ ta̱ u ya chit ká̱ iwu ɓu asa̱l va̱ uYawe na ɓu ka̱ ashe awo mi, awalang va̱ na u yà ka̱ ashe agba̱k. Onəm oro là pa̱ ń gbá̱l ɓu, ǹnyi te, n re ɓu ká̱ iriri. N là pa̱, <Mi nak awo mi ka̱ apal anəm uga nzhi mi ka̱t, ka̱kul uza̱ ugorgor aYawe.> ");
INSERT INTO yer_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Apo mi, dər arwangchwang ìlukwan ɓu ka̱ ashe awo mi. M pà arwangchwang ìlukwan ɓu, ǹnyi te, n gbá̱l ɓu ka̱t. Iya̱m iro yà ka̱ ashe awo mi va̱ nyám pa̱, mmami ká̱ mpat, ka̱t te n fa iya̱mkak ka̱t. N nəm mpat a ɓu ka̱t, ǹnyi te, mmaɓu kà̱ nram mi pa̱ ú gbá̱l. ");
INSERT INTO yer_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Re uYawe á nap akwali ká̱ ishimshe mi ká̱ ɓu. Kang re uYawe a pyat mpat va̱ u nəm a mi, ǹnyi te, awo mi i yà ká̱ ndok ɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Wa nva̱ ntar achu mmatmat là pa̱, <Ka̱ ashe onəm onga na, iya̱m inga i fa.> Ka̱kul nva̱ ta te, awo mi i yà ká̱ ndok ɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","<<Mmaɓu va̱ uPonzhi oIsa̱rila, uda u fa pa̱ u lung yà? Uda ɓu ɓak yà? Aməma pa̱ u lak awalang ɓu kà̱ mɓak ìva ikuku, ka̱t te ìbebe wa nji mi ɗò? ");
INSERT INTO yer_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Re uYawe á nap akwali á yi na uza̱ a va̱n nnandər ká̱ ishimshe yi. Re uza̱ a yà unəm uga nka̱mshi mi, uza̱ i ka̱mshi mi ka̱ ashe awo ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Nva̱ngva̱ uDawuda gba̱l ka̱ nlà nnap va̱ ta̱ te, uShawulu ɓəp pa̱, <<Ìchu ɓu yà ɗò, ayen mi, uDawuda?>> Kang uza̱ yə́ng pa̱ gbá̱nggbá̱ng. ");
INSERT INTO yer_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Uza̱ là ûDawuda pa̱, <<U ji mi ji ká̱ nnandər. U nəm ikin á mi, ǹnyi te, n nəm iɓá̱ngɓa̱ng á ɓu. ");
INSERT INTO yer_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Ǹyangmata̱ u là á mi chit inəna̱n va̱ u nəm á mi, uYawe na mi ka̱ ashe awo ɓu, ǹnyi te, u gbá̱l mi ka̱t. ");
INSERT INTO yer_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Uda pa̱ wat, i ya ukpa ìkum wò ka̱ ashe awo kang i re i ga ká̱ ikángkáng yà? Re uYawe á mwa ɓu ká̱ inəna̱n ka̱kul inəna̱n va̱ u nəm á mi n̂da va̱ ta̱ á. ");
INSERT INTO yer_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","N nyi chit ǹyangmata̱ pa̱ ɓu ga ǹya uponzhi kang iponzhi oIsa̱rila i ga mpyal ka̱ ashe awo ɓu. ");
INSERT INTO yer_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Ǹyangmata̱, sóng anung á mi kà̱ mpyal àYawe pa̱ ɓu yà ká̱ ngbá̱ng akum ìjili mi, ka̱t te ɓu dərkən aɗin mi ka̱ ashe nzhi apo mi ka̱t .>> ");
INSERT INTO yer_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Te uDawuda yar nsar nnap-nlà wò ûShawulu. Te uShawulu ga nzhi, ǹnyi te, uDawuda ká̱ onunggwan wò le kyen ga atak mbwam oza̱. ");
INSERT INTO yer_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Ka̱ nvəva̱ng te, uSamuwel kú, kang nkpaktak oIsa̱rila ɓut ka̱kul ǹyə́ng ikuku. Oza̱ li na ka̱ nzhizhi ka̱ aRama. Te uDawuda wong ga ashe nzam mmaləng aParan. ");
INSERT INTO yer_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","Unəm uro uwa yà ka̱ aMayon ká̱ iya̱m nkang ka̱ aKarmel kang à dur byet. Uza̱ ká̱ iɓəl ìkalong kang itam ìkalong pa̱ ishatɗing kang u wa kà̱ nkpat akpap itam wò ka̱ aKarmel. ");
INSERT INTO yer_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","Unəm va̱ ta aɗiɗin ka̱ yà pa̱ uNabal, uchichar aɗiɗin ka̱ yà pa̱ uAbigel. Uza̱ ka̱ yà uchar uɓyenɓyen uga aghan, ǹnyi te, uɓəɓar unəm uga mɓa̱ng ka̱ afu kang à yà ká̱ aɗor ka̱t ka̱ ashe iya̱m va̱ uza̱ i nəm, uza̱ ka̱ yà ka̱ akum ìjili aKalip. ");
INSERT INTO yer_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","Awalang va̱ uDawuda ka̱ ashe nzam mmaləng te, uza̱ fe pa̱ uNabal kà̱ nkpat akpap itam wò. ");
INSERT INTO yer_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","Te uza̱ re ovan nza̱m wò pa̱ ogba̱pchi, kang à là ôza̱ pa̱, <<O ga atak aNabal ka̱ aKarmel na o re anung á na ka̱ ashe aɗin mi. ");
INSERT INTO yer_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","Ó là á na pa̱, <Irirì ɓu á təm mbyet, nnap nnəna̱n a yà ka̱ apal ishi ɓu ká̱ nzhi ɓu, ká̱ nkpaktak iya̱m va̱ mmaɓu ká̱ á. ");
INSERT INTO yer_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","<< <N fe pa̱ mmaɓu kà̱ nkpat akpap itam ɓu. Awalang va̱ onəm oga nkpak iya̱m nkang ɓu təm ka̱ ashe yi ka̱ aKarmel te, í nyán ká̱ oza̱ ka̱t kang iya̱m oza̱ iro yà lar ka̱t. ");
INSERT INTO yer_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Ɓəp okpari ɓu, te oza̱ i là a ɓu pa̱ wanta na. Ka̱kul nva̱ ta te, nəm nka̱mshi ônəm mi, ka̱kul i ɓa ka̱ awalang aga nnəm nchang izər. Kusuk na ozwal ɓu ká̱ uyen ɓu uDawuda iya̱m va̱ pa̱ kap u ya màl pa̱ u na ôza̱.> >> ");
INSERT INTO yer_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","Nva̱ngva̱ onəm aDawuda chu te, oza̱ là ǹre va̱ ta ûNabal ka̱ ashe aɗin aDawuda. Te oza̱ lok pa̱ ó fe aməma̱n. ");
INSERT INTO yer_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","UNabal na ama̱n ôkpari aDawuda pa̱, <<Uda uDawuda va̱ yà? Uya àJese va̱ uda yà? Ka̱ ashe oga nra va̱ ta̱ te, okpari onəm pa̱ makmak fa iya̱mkak ká̱ onəm oga nzhi oza̱. ");
INSERT INTO yer_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Ka̱kul iza̱ kang mi yar nzəngkəng mi ká̱ ndəng ngwa mi, ká̱ izhé va̱ m pà ka̱kul onəm oga kpat akpap iya̱m nkang mi, mi na onunggwan ova mmá nyi atak va̱ oza̱ fa ka̱ ka̱t yà?>> ");
INSERT INTO yer_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Te ovan nza̱m va̱ uDawuda re te, le ga là á na iya̱m va̱ uNabal là pa̱ kpaktak. ");
INSERT INTO yer_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","Te uDawuda là ôza̱ pa̱, <<Uda nggo á gal ndokchi wò.>> Te nkpaktak oza̱ gal ndokchi oza̱, kang uDawuda gal ndokchi nji wò kpa. Onunggwan chu ìgba̱l chu pa̱ ineɗing yar nva̱ng aDawuda, kang mmá re onunggwan ìgba̱l pa̱ iparəm pa̱ a pángchí iya̱m ìkum oza̱. ");
INSERT INTO yer_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","Uzəngtəng ka̱ ashe okpari aNabal là ûAbigel, uchar aNabal pa̱, <<UDawuda re okpari wò ka̱ ashe nzam mmaləng pa̱ á ná nre anung wò ûnəm uga nzhi yi, ǹnyi te, uza̱ pwat oza̱. ");
INSERT INTO yer_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Ká̱ nna kpa te, onunggwan va̱ ta nəm inəna̱n á yi byet. I ɓək anung ka̱ ashe awo oza̱ ka̱t, nkpaktak awalang va̱ mmayi ka̱ atak nkpak iya̱m nkang nzəng ká̱ oza̱ te, iya̱m iro yà lar ká̱ yi ka̱t. ");
INSERT INTO yer_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Oza̱ gang yi wa akamsəlang izwam ká̱ alum. Oza̱ ipángchí yi nkpaktak awalang va̱ mmayi kà̱ nkpak itam dat ka̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Ǹyangmata̱ rəng nnap pa̱ dakdak kang ɓu dər iya̱m va̱ mal pa̱ u nəm, ka̱kul mɓək anung i ga ǹya ûnəm uga nzhi yi ka̱ nkpaktak nzhizhi. Ka̱kul uza̱ unəm ulakchilakchi uva unəm uro i là nnap á na i ka̱m ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","UAbigel gha̱n wur oga nzəngkəng ìgba̱l pa̱ ìparəm, ká̱ ndəng iba̱ngba̱ng ka̱ ashe awa pa̱ parəm, ká̱ itam pa̱ itukun iva mmá pà mmá pək chit, ká̱ ìpir ikur iforfor ikpang iga mma iya̱m pa̱ igba̱pchi ama̱n pa̱ shatɗing, ká̱ mɓit awar iba̱ngba̱ng va wom chit ìgba̱l, ká̱ mɓit awar ipipyan ìgba̱l pa̱ ìparəm va wom chit. Uza̱ ɓak oza̱ ka̱ apal oga azhaki. ");
INSERT INTO yer_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Te uza̱ là ôkpari wò pa̱, <<Ó gəga kang mi ɓa ka̱ nva̱ng wó.>> Ǹnyi te, uza̱ là atak ngga wò uɓar wò uNabal ka̱t. ");
INSERT INTO yer_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Nva̱ uza̱ kà̱ nkwak azhaki wò ga chu akum aɓam te, uDawuda uwa ta̱ ká̱ onəm wò kà̱ nfəng nvang, te uza̱ gwang oza̱. ");
INSERT INTO yer_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","UDawuda ka̱ là pa̱, <<A sat iya̱m ilakchi nva̱ n pak inok nnak ishi ká̱ iya̱m anəm va̱ ta̱ ka̱ ashe nzam mmaləng, kang iyəya̱m iro yà ka̱ lar ka̱t. N nəm inəna̱n á na ǹnyi te, uza̱ mwa mi ká̱ inga. ");
INSERT INTO yer_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Re Inan á zhì mi, a yà pa̱ ìpin ká̱ ìɓotak kang n re ununggwan uro re ká̱ irirì ka̱ ashe nzhizhi pa̱ uzəng á.>> ");
INSERT INTO yer_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Awalang va̱ uAbigel ya uDawuda te, uza̱ fər ka̱ apal azhaki wò pa̱ kəlak, uza̱ ru zəp ká̱ afu ka̱ mbin ka̱ mpipyal. ");
INSERT INTO yer_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","Uza̱ ru ka̱ apal ashəshar uza̱ là pa̱, <<Yar mpat ûzwal ɓu, anəm uga nzhi mi. Re n là nnap ka̱ ɓu, gwong achwang ká̱ iya̱m va̱ uzwal ɓu ká̱ pa̱ ô là. ");
INSERT INTO yer_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Kang unəm uga nzhi mi á nak ishi ká̱ uNabal unəm ulakchilakchi ka̱t, ka̱kul uza̱ wa aɗiɗin. Ipir aɗiɗin pa̱ mpərək, kang nnəm mpərək i kap ká̱ na ka̱t. Kang wa mmami uzwal ɓu ǹnyi te, n ya onəm va̱ u re nre ká̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","Ǹyangmata̱, ánəm uga nzhi mi, wa nva uYawe Inan ɓu uwa ka̱ irirì, kang wa nva na u ya ka̱ irirì, ka̱kul uYawe ka̱ dang ɓu chit ka̱ ntar nchə̀r ká̱ mpyat mpat, re nkpaktak okpa ìkum ɓu ká̱ ovəngva̱ ka̱ nɗom pa̱ ó nəm inga á ɓu a ya wa aNabal. ");
INSERT INTO yer_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","Re unəm uga nzhi mi a ka̱m imwa va̱ ta̱ uzwal ɓu ɓa ká̱ á ɓu, na u ná ôvan nza̱m va̱ nzəng ká̱ ɓu. ");
INSERT INTO yer_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","<<N chal ɓu yar mpat uzwal ɓu a yà pa̱ m pat a ɓu ká̱ asa̱l aro á. UYawe Inan ɓu, i nak iponzhi iga akum ìjili ɓu i təm mbyet, ka̱kul ìkum va̱ mmaɓu ka̱ nlulung te, iji àYawe. Re mpat nro a yà ka̱ ɓu ka̱t ka̱ ashe nkpaktak irirì ɓu. ");
INSERT INTO yer_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","A yà pa̱ unəm uro wong pa̱ ô ram irirì ɓu te, uYawe, Inan ɓu uwa i kpak irirì ɓu ká̱ ikángkáng ka̱ ashe onəm oga irirì. Ǹnyi te, uYawe i mang irirì okpa ìkum ɓu wa nva mí mang ìpang ká̱ nchwalak á. ");
INSERT INTO yer_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","Nva̱ngva̱ uYawe a yəl nkpaktak iya̱m inəna̱n va̱ uza̱ yar nsar nnap-nlà ûnəm uga nzhi mi kà̱ kang uza̱ nak na chit uponzhi oIsa̱rila te, ");
INSERT INTO yer_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","kang ìgwak ɓu a nak ɓu pa̱ mmaɓu ká̱ mpat ka̱t, ka̱t te, ɓu nak pa̱ na u yà ká̱ nchə̀r ka̱ awo ɓu ka̱t, kang wa pyat mpat ká̱ ishi ɓu ka̱t. Nva̱ngva̱ uYawe Inan ɓu a na igwan ûnəm uga nzhi mi te, wa rəng ká̱ uzwal ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","UDawuda là ûAbigel pa̱, <<Ashep təm aji aYawe, Inan oIsa̱rila, uva re ɓu chit n̂da va̱ ta̱ pa̱ u gwang mi á. ");
INSERT INTO yer_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","Re nnap nnəna̱n a təm ka̱ apal ɓu ka̱kul aghan ɓu, nva̱ u ɗa̱t mi kà̱ ntar nchə̀r kang u ɗa̱t mi ka̱ mpyat mpat ká̱ ishi mi kpa n̂da va̱ ta̱ á. ");
INSERT INTO yer_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","UYawe ɗa̱t mi ka̱ nnəm iɓá̱ngɓa̱ng a ɓu. Ká̱ yà pa̱ u mor u gha̱n u gwang mi ta̱ ka̱t te, n sóng anung a ɓu ká̱ uYawe Inan oIsa̱rila uga irirì pa̱, ìpin te, ununggwan àNabal uro yà pa̱ uzəng uva̱ mmá ká̱ re ká̱ irirì ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","Te uDawuda ka̱m imwa va̱ uza̱ ɓa ká̱ ka̱ awuwo, kang à là á na pa̱, <<Ga nzhi ká̱ ikángkáng. N fe iya̱m va̱ chit u là, kang mi nəm iya̱m va̱ nəm u ɗom.>> ");
INSERT INTO yer_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Awalang va̱ uAbigel le te, á ya uNabal kà̱ nzhi kà̱ nnəm mɓut ngga nchang izər wa apir nja aponzhi. Uza̱ ka̱ ashe nchang izər kang à wa iya̱m iwawa gbá̱l na pa̱ gənggəng te, uAbigel là iya̱m iro á na ka̱t ipin fa kpa̱k kang. ");
INSERT INTO yer_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Ká̱ ipin awalang va̱ nnap nnəm aNabal ɓa izəzər chit, te uchichar là á na iya̱m va̱ fa pa̱ kpaktak te, ìchəgwak ləp na, uza̱ yà wa ìpang. ");
INSERT INTO yer_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Kà̱ nva̱ng nra pa̱ ngba̱pchi te, uYawe ləp uNabal kang uza̱ kú. ");
INSERT INTO yer_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","Awalang va̱ uDawuda fe pa̱ uNabal kú chit, te uza̱ là pa̱, <<Ashep təm aji aYawe, uva sat ka̱ apal mi ka̱ awalang va̱ uNabal ɓak mi. UYawe ɗa̱t mi kà̱ nnəm inga kang uza̱ le ká̱ inga aNabal á na chit ka̱ apal ishishi.>> Te uDawuda re nrè ûAbigel pa̱, uza̱ a ma̱n ô ka̱m na a yà uchar wò. ");
INSERT INTO yer_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","Awalang va̱ onəm oga ǹre àDawuda ga aKarmel te, oza̱ là ûAbigel pa̱, <<UDawuda á re yi pa̱, í ka̱m ɓu i ɓa ká̱ na ú yà uchar wò.>> ");
INSERT INTO yer_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","UAbigel ru zəp ká̱ afu ka̱ mbin, kang à là pa̱, <<Mmami uzuzwal kang m məma̱n pa̱ n nəm inok á na kang mì nàl ashar ozwal anəm uga nzhi mi.>> ");
INSERT INTO yer_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","UAbigel wong pa̱ kəlak kyen azhaki, kang ovan ɓyen oga nnəm inok á na pa̱ otukun yar nvəva̱ng, kang uza̱ ga nzəng ká̱ onəm oga nre va̱ uDawuda re á. Te uza̱ ga təm uchar àDawuda. ");
INSERT INTO yer_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","UDawuda ka̱m ichar ká̱ uAhinowam uga aJezireyel kpa, kang oza̱ pa̱ oparəm va̱ ta tong ochəchar. ");
INSERT INTO yer_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","UShawulu ka̱ yar uyen wò uMikal uchar àDawuda chit, ná ûPalti uya àLayish unəm uga aGalim, a təm uchəchar. ");
INSERT INTO yer_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Onəm oga aZip ga atak aShawulu ka̱ aGibeya oza̱ là á na pa̱, <<UDawuda uwa ka̱ mbwam ka̱ aɗuktum aHakila, ava dər aJeshimon ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Te uShawulu yak oshozha ìkalong pa̱ ishatɗing ka̱ ashe oIsa̱rila va̱ fa ga ká̱ ka̱ ashe nzam mmaləng aZip, pa̱ na ó ram uDawuda. ");
INSERT INTO yer_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","UShawulu ləp apa̱k ka̱ ngba̱k asa̱l ka̱ apal aɗuktum aHakila, a va dər asa̱l awu aJeshimon, ǹnyi te, uDawuda təm ka̱ ashe nzam mmaləng. Awalang va̱ uDawuda fe chit pa̱ uShawulu ka̱ mɓàk nva̱ng wò ka̱ ta, ");
INSERT INTO yer_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","uza̱ re onəm oga nsòng mbin, kang uza̱ ga nyi pa̱ uShawulu uwa ka̱ ta. ");
INSERT INTO yer_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Te uDawuda wong ga atak va̱ uShawulu ləp apa̱k kà̱ te, uza̱ ya atak va̱ uShawulu ká̱ uAbner uya àNer, unəm uga mpyal oshozhashozha ra kà̱. UShawulu kà̱ nra ka̱ ashe apa̱k, ká̱ oshozha ra gang na. ");
INSERT INTO yer_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Te UDawuda ɓəp uAhimelek unəm oHiti ká̱ uAbishayi uya àZeruya, ugənang àJowap pa̱, <<Uda i məma̱n i ga nzəng ká̱ mi ka̱ ashe apa̱k aShawulu yà?>> Te uAbishayi ma̱n pa̱, <<M məma̱n, mi ga nzəng ká̱ ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Te uDawuda ká̱ uAbishayi ga ashe apa̱k aShawulu ká̱ ìzwam, kang oza̱ ya na kà̱ nra nda ka̱ ashe apa̱k kang aɓəɓar na pak ka̱ mbin dat ká̱ ishishi. UAbner ká̱ aɓo oshozha oma kà̱ nra nda gang na. ");
INSERT INTO yer_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","UAbishayi là ûDawuda pa̱, <<Inan na unəm uga nkpang ɓu chit ka̱ ashe awo ɓu n̂da va̱ ta̱. Ǹyangmata̱ re n tar na ká̱ aɓár á ga á fu ka̱ mbin pa̱ nzəng pa̱ ták, mi ya ka̱ ndan pa̱ mparəm ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","Ǹnyi te, uDawuda là ûAbishayi pa̱, <<Kang wa zhì na ka̱t. Uda i nak awo ka̱ apal anəm va̱ uYawe gar kang i yà ká̱ mpat ka̱t yà?>> ");
INSERT INTO yer_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","UDawuda ga mpyal ká̱ nlà pa̱, <<Wa nva̱ uYawe uwa yà ká̱ irirì te, uYawe uwa i gbá̱l na ká̱ ishi wò, ka̱t te nra ngga ikuku na i ɓa kang uza̱ i kú, ka̱t te mí gbá̱l na ka̱ atak ìkum. ");
INSERT INTO yer_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","UYawe á dáng mi nva̱ pa̱ n gbá̱l unəm va̱ uza̱ gar á. Ǹyangmata̱ te, yar aɓəɓar ká̱ aba̱ng ndədəng va̱ dat ká̱ ishishi, na í ga.>> ");
INSERT INTO yer_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Te uDawuda yar aɓəɓar ká̱ aba̱ng ndədəng va̱ dat ká̱ ishishi, kang oza̱ le. Unəm uro ya oza̱ ka̱t te a nnyi iya̱m iro ka̱ apəpal ka̱t, le kang unəm uro ì yenda̱l. Nkpaktak oza̱ oma kà̱ nra nda, ka̱kul uYawe nak oza̱ chit ra nda nɗəkɗək. ");
INSERT INTO yer_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Te uDawuda pa̱l ngba̱k nro kang à sat ka̱ apal ishi aɗuktum a va gbəgba̱ng ka̱ atak apa̱k aShawulu. Kang anang agbagba na yà ka̱ ishimshe oza̱. ");
INSERT INTO yer_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","Te uza̱ ləp achu ôshozha ká̱ uAbner uya àNer pa̱, <<Mmaɓu kà̱ nfe mi ɗò, áAbner.>> Te uAbner na ama̱n pa̱, <<Mmaɓu uda ɓu wór uponzhi yà?>> ");
INSERT INTO yer_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","UDawuda là pa̱, <<Mmaɓu nza̱ apir anəm yà? Uda wa mmaɓu ka̱ ashe oIsa̱rila yà? Iza̱ nak kang u pángchí unəm uga nzhi ɓu uponzhi ka̱t yà? Nna gba̱ng nva̱ng chit ka̱t unəm uro ɓa pa̱ u gbá̱l unəm uga nzhi ɓu uponzhi. ");
INSERT INTO yer_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","ÁAbner, iya̱m va̱ ta̱ u nəm ta̱ á ɓyen ka̱t. Wa nva̱ uYawe uwa yà ká̱ irirì te, mmaɓu ká̱ onunggwan ɓu nkpak pa̱ ó kú, ka̱kul ó pángchí unəm uga nzhi wó, ugargar àYawe ka̱t. Ó dər, aɓár ká̱ aba̱ng ndəng àponzhi va̱ ka̱ dat ká̱ ishishi te, ka̱ che yà?>> ");
INSERT INTO yer_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Nva̱ngva̱ uShawulu nyi ichu àDawuda te, uza̱ là pa̱, <<Ichu ɓu yà ɗò, ayen mi, uDawuda?>> Te uDawuda na ama̱n pa̱, <<À ichu mi yà, anəm uga nzhi mi, áponzhi.>> ");
INSERT INTO yer_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","UDawuda ga mpyal ká̱ nlà pa̱, <<Iza̱ ɓu ɓàk uzwal ɓu ka̱ yà, anəm uga nzhi mi? Iza̱ n nəm yà, kang iza̱ mpat mi yà? ");
INSERT INTO yer_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","Ǹyangmata̱ re unəm uga nzhi mi uponzhi á gwong achwang ka̱ nnap-nlà azwal wò. A yà pa̱ uYawe à nok ɓu pa̱ na u nəm ìkum ká̱ mi te, re uza̱ á ka̱m iya̱m inana mi. Ǹnyi te, a yà pa̱ nnap va̱ ta̱ onəm à nəm te, re uYawe á vyap oza̱. Oza̱ ɓàk mi ká̱ n̂da va̱ ta̱ ka̱kul pa̱ na kang n ya nkap ka̱ ashe iya̱m akup aYawe ka̱t, kang oza̱ là pa̱,<Ga wop inan iro.> ");
INSERT INTO yer_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Ǹyangmata̱ kang wa re mmá gbá̱l mi ka̱ ashe mbin nkak va gbəgba̱ng ká̱ mpyal àYawe ka̱t. Sang kang uponzhi oIsa̱rila i fa nram ìbebe wa mmami pa̱ ô gba̱l yà? Sang kang ɓu fa abar mi wa inyil iro iga apal aɓam yà?>> ");
INSERT INTO yer_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Te uShawulu là pa̱, <<N nəm nnap mɓá̱ngɓa̱ng chit, le ɓa, ayen mi uDawuda. Mi yà ká̱ nnəm iya̱m iro a ɓu lap ka̱t, ka̱kul nva̱ u dər irirì mi ká̱ ichumchum kang u re mi n̂da va̱ ta̱ á. N nəm mpərək, mpat ɓa̱ng byet.>> ");
INSERT INTO yer_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","UDawuda là pa̱, <<Aɓár ɓu na ta̱, áponzhi. Re uro ka̱ ashe ovan nza̱m ɓu á ɓa na á ka̱m. ");
INSERT INTO yer_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","UYawe i mwa udanggo ka̱kul inəna̱nnəna̱n ká̱ nna nnandərnandər. UYawe na ɓu ka̱ ashe awo mi ká̱ n̂da va̱ ta̱, ǹnyi te, n ndok ugargar àYawe ka̱t. ");
INSERT INTO yer_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","Wa nva n dər irirì ɓu ká̱ ichumchum ká̱ n̂da va̱ ta̱ te, re uYawe a dər irirì mi ká̱ ichumchum, kang ì fa ka̱ mi ka̱ ashe nkpaktak mɓək anung.>> ");
INSERT INTO yer_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Te uShawulu là ûDawuda pa̱, <<Re nnap nnəna̱n á yà ka̱ apal ɓu, ayen mi, uDawuda. Ɓu ga nnəm oga iya̱m ichumchum, kang ɓu nəm igwan pa̱ makmak.>> Te uDawuda ga iya̱m wò, kang uShawulu le nzhi. ");
INSERT INTO yer_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","Ǹnyi te, uDawuda kat ka̱ ashe ìgwak wò, á là pa̱, <<N̂da nro na mi wong mi kú ka̱ ashe awo aShawulu. Iya̱m va̱ ɓyen pa̱ n nəm te, mi chər mi ga mbin oFilisti. Te uShawulu i re nram mi ɗak ka̱ ashe mbin oIsa̱rila, kang mi fa ka̱ ashe awuwo.>> ");
INSERT INTO yer_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","Te uDawuda ká̱ onunggwan wò ìgba̱l pa̱ ìkpa̱ɗing oza̱ ga atak aAkish uya aMayok, uponzhi uga aGat. ");
INSERT INTO yer_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","UDawuda ká̱ onunggwan wò ká̱ nzhi oza̱ təm ka̱ atak aAkish ka̱ aGat. UDawuda ga nzəng ká̱ ochar wò oga oparəm, uAhinoyam uyen uga aJezerel, ká̱ uAbigel uyen uga aKarmel, uchar ukpələng àNabal. ");
INSERT INTO yer_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","Nva̱ngva̱ mmá là ûShawulu pa̱ uDawuda chər chit ga aGat te, uza̱ re nram na. ");
INSERT INTO yer_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","Te uDawuda là ûAkish pa̱, <<A yà pa̱ nchə̀r mi bəba̱l kà̱ mpyal ɓu te, na atak aro á mi ka̱ ashe ivan itong n təm kà̱. A màl pa̱ uzwal ɓu a təm nzəng ká̱ ɓu ka̱ ashe ìnang ìtong iga iponzhi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","Te n̂da va̱ ta uAkish na ìtong aZiklak á na, nna nak te, aZiklak təm ajiwo oponzhi oga aYahuda a ɓa chu nda va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","UDawuda təm kà̱ mbin oFilisti ìzun pa̱ ìzəng ká̱ ape pa̱ neɗing. ");
INSERT INTO yer_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","Ǹyangmata̱ uDawuda ká̱ onəm wò nəm inok ngga ka̱ ìkum onəm oga aGeshur, ká̱ aGirzi, ká̱ aAmalek. Ká̱ mmatmat te, onəm va ta̱ təm ka̱ mbin va̱ ta ga chu aShur ká̱ aMasar. ");
INSERT INTO yer_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","Awalang va̱ uDawuda i ru atak ká̱ ìkum te, uza̱ i re ununggwan ka̱t te uchar ká̱ irirì ka̱t. Uza̱ i wur itam, ká̱ ina, ká̱ oga azhaki ká̱ oga alakəmi, ká̱ ilukwan. Te uza̱ i le atak aAkish. ");
INSERT INTO yer_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","Awalang aro te uAkish i ɓəp pa̱, <<U ga ìkum ka̱ che nda va̱ ta̱ yà?>> Te uDawuda i là pa̱, <<N ga kà̱ nkwandal aYahuda>> ka̱t te, <<Kà̱ nkwandal aJerameyel>> ka̱t te, <<Kà̱ nkwandal oKeni.>> ");
INSERT INTO yer_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","UDawuda i re ununggwan ka̱t te uchar ká̱ irirì ka̱t, ka̱kul kang oza̱ a ga aGat a là pa̱, <<Iya̱m va ta̱ uDawuda nəm.>> Nnap nnənəm nata uza̱ i nəm pa̱ ɗəkər nva̱ uza̱ ka̱ ntəm ka̱ ashe oFilisti á. ");
INSERT INTO yer_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","UAkish na nnandər ká̱ uDawuda, kang a là îshi wò pa̱, <<Uza̱ sat iya̱m iga ajan chit ônəm wò oIsa̱rila, ǹyangmata̱ te, uza̱ i yà uzwal mi nkpaktak irirìriri.>> ");
INSERT INTO yer_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Ka̱ ashe oga nra va̱ ta te, oFilisti ɓut oshozha oza̱ pa̱ ó lung ìkum ká̱ oIsa̱rila. Te uAkish là ûDawuda pa̱, <<Á màl pa̱ u nyi pa̱, mmaɓu ká̱ onəm ɓu, i gwang ishi ká̱ mi kà̱ ìkum va̱ ta̱ .>> ");
INSERT INTO yer_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","UDawuda là pa̱, <<Á chàng byet. Ɓu ya ká̱ ishi ɓu iya̱m va̱ mi nənəm.>> Te uAkish na ama̱n pa̱, <<Dakdak, mi ga nnak ɓu yà ushozha uga mpángchí mi mbyet.>> ");
INSERT INTO yer_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Ǹyangmata̱ uSamuwel kú chit, kang nkpaktak oIsa̱rila yə́ng ikuku kang oza̱ li na kà̱ ìtutong ka̱ aRama. UShawulu ka̱ wà onəm oga ishi ibolbol ká̱ onəm oga iva̱k chit ka̱ ashe mbin va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","OFilisti ɓut kang à ɓa pak apa̱k oza̱ ka̱ aShunem. UShawulu ǹnyi te, ɓut nkpaktak oIsa̱rila kang oza̱ pak apa̱k ka̱ aGilbowa. ");
INSERT INTO yer_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Awalang va̱ uShawulu ya oshozha oFilisti te, ìchəgwak ləp na, ayər nəm na pa̱ gənggəng. ");
INSERT INTO yer_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Uza̱ mwo nɗom aYawe, ǹnyi te, uYawe na ama̱n á na ka̱ atak nlár izwam, ka̱t te ka̱ atak aUrim, ka̱t te ka̱ atak onəm oga nlà ìchu Inan ka̱t. ");
INSERT INTO yer_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","UShawulu là ônəm oga nəm inok á na pa̱, <<Ó ram uchar uga ishi ibolbol á mi, na n ga m ɓəp na iya̱m va̱ i ga nfa.>> Oza̱ là pa̱, <<Uchar uga ishi ibolbol uro uwa yà ka̱ aEndor.>> ");
INSERT INTO yer_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Te uShawulu mwak ìlukwan iro pa̱ɗi na ô lar ishi wò, kang uza̱ ga nzhi achar va̱ ta ká̱ ìzwam ká̱ onəm wò oro pa̱ oparəm. UShawulu là pa̱, <<Wór aruhu anəm ukúkú uro á mi, wong ká̱ unəm va̱ á mi, mi wór aɗiɗin.>> ");
INSERT INTO yer_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Ǹnyi te, uchar va̱ ta là á na pa̱, <<Nnandər u nyi iya̱m va̱ nyi uShawulu nəm. Uza̱ ɓàk nkpaktak onəm oga ishi ibolbol ká̱ onəm oga iva̱k ka̱ mbin va̱ ta̱. Te sang kang ɓu lwak ajip á mi ka̱kul pa̱ mmá gbá̱l mi yà?>> ");
INSERT INTO yer_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Te uShawulu sóng anung á na ká̱ aɗin aYawe pa̱, <<Wa nva̱ uYawe uwa yà ká̱ irirì te, iya̱m iro yà i ya ɓu ka̱kul nnap va̱ ta̱ ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Te uchar va̱ ta ɓəp pa̱, << Uda u ɗom pa̱ m ɓa ká̱ na á ɓu yà?>> Te uShawulu là pa̱, <<Le ɓa ká̱ uSamuwel á mi.>> ");
INSERT INTO yer_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Awalang va̱ uchar va̱ ta ya uSamuwel te, uza̱ ləp achu pa̱ gbá̱nggbá̱ng kang à là ûShawulu pa̱, <<Sang kang u lam mi yà? Mmaɓu uShawulu.>> ");
INSERT INTO yer_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Uponzhi là á na pa̱, <<Kang ayər a nəm ɓu ka̱t. Iza̱ u ya yà?>> Uchar va̱ ta là pa̱, <<N ya aruhu aro kà̱ nfa ka̱ ashe mbin.>> ");
INSERT INTO yer_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Uza̱ ɓəp pa̱, <<U ya na wa nsang yà?>> Uchar là pa̱, <<Unəm ugbakgbak pá ìlukwan iwángwang kà̱ nfa.>> Te uShawulu nyi pa̱ uSamuwel, kang uza̱ ru zəp ká̱ afu kà̱ mbin. ");
INSERT INTO yer_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","USamuwel là ûShawulu pa̱, <<Iza̱ nak kang u ɗak mi ka̱ atak ngwong ká̱ mi wanta̱ yà?>> UShawulu là pa̱, << Mmami ka̱ ashe nɗaktak pa̱ gənggəng. OFilisti kà̱ nlung ìkum ká̱ mi, kang Inan re mi chit. Uza̱ na ama̱n a mi ka̱ atak onəm oga nlà ichu Inan, ka̱t te ka̱ atak nlár izwam lap ka̱t. Nna nak te, n wór ɓu pa̱ na u là iya̱m va̱ á mi, n nəm.>> ");
INSERT INTO yer_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","USamuwel là pa̱, <<Ɓu ɓəp mi ka̱ iza̱ yà? Nna uYawe re ɓu chit, kang à sat ukpa ìkum ɓu chit á. ");
INSERT INTO yer_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","UYawe nəm chit wa nva̱ uza̱ ka̱ là ka̱ anung mi á. UYawe kakchi iponzhi chit ka̱ awo ɓu, kang à na ûnəm uro uga ndatkulung ká̱ ɓu, uDawuda. ");
INSERT INTO yer_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Ka̱kul u yang ká̱ nkpak nnap-nlà àYawe ka̱t te ǹnyám nlak ìgugwak ka̱ apal oAmalek te, uYawe nəm iya̱m va̱ ta̱ a ɓu chit n̂da va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","UYawe i ga nna ɓu ká̱ oIsa̱rila ka̱ ashe awo oFilisti, kang ìpin mmaɓu ká̱ ovan ɓu onunggwan ó ga ǹya nzəng ká̱ mi. UYawe i ga nna oshozha oIsa̱rila ka̱ ashe awo oFilisti kpa.>> ");
INSERT INTO yer_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Ká̱ nfe nnap-nlà va̱ uSamuwel là á na byet te, uShawulu ru zəp ká̱ afu ka̱ mbin, ka̱kul ayər nəm na pa̱ gənggəng. Uza̱ bəlak ka̱kul uza̱ ri iya̱m iro ka̱ n̂da va̱ ta ka̱t, izwam ká̱ alum. ");
INSERT INTO yer_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Awalang va̱ uchar va̱ ta ɓa atak uShawulu te, uza̱ ya na ka̱ ashe nɗaktak pa̱ gənggəng, kang à là á na pa̱, <<Dər, uzwal ɓu a kpak nnap nnəm á ɓu chit. N na irirì mi kang n nəm iya̱m va̱ chit u là á mi pa̱ n nəm. ");
INSERT INTO yer_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Ǹyangmata̱, kusuk gwong achwang ka̱ iya̱m va̱ uzwal ɓu i là á ɓu. Re n na iya̱m-nrì á ɓu ú ri na ú ya ìkam iga nle.>> ");
INSERT INTO yer_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Uza̱ yang kang à là pa̱, <<Mi ri ka̱t.>> Ǹnyi te, onənəm ká̱ uchar va̱ ta gwang chál na kang uza̱ ma̱n, te uza̱ wong kà̱ mbin təm ka̱ apal alyer. ");
INSERT INTO yer_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Uchar va̱ ta kpán ìya ìna va̱ uza̱ ka̱ kang ɓyen ka̱ nzhi wò, te uza̱ gha̱n ga kpán pà. Uza̱ kpa̱k mma̱k kál kang uza̱ ɓit nzəngkəng ngga ǹya ká̱ anyer ka̱t. ");
INSERT INTO yer_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Te uza̱ ɓa ká̱ kà̱ mpyal àShawulu ká̱ onənəm, kang oza̱ ri. Te oza̱ wong kang oza̱ ga ká̱ ìzwam va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","OFilisti ɓut nkpaktak oshozha oza̱ ka̱ aAfek, ǹnyi te, oIsa̱rila ra apa̱k ka̱ anung ndəng mɓəlɓəl ka̱ aJezerel. ");
INSERT INTO yer_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Nva̱ onəm oga mpyal oFilisti fa chit ká̱ oshozha ìgba̱l ìgba̱l ká̱ ìkalong ìkalong te, uDawuda ká̱ onunggwan wò ka̱ mɓa ka̱ nva̱ng nzəng ká̱ uAkish. ");
INSERT INTO yer_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Onəm oga mpyal oshozha oFilisti ɓəp pa̱, <<OHiburu va̱ ta̱ i nəm iza̱ ka̱ ta̱ yà?>> UAkish na ama̱n pa̱, <<Unəm va̱ ta̱ uDawuda ukpari aShawulu uponzhi oIsa̱rila. Uza̱ yà chit nzəng ká̱ mi ji ìzun pa̱ izəng, kang na n ya mpat nro chit ka̱ atətak ka̱t ɓàn ka̱ nda va̱ uza̱ re uShawulu ká̱ ɓa chu ǹyangmata̱.>> ");
INSERT INTO yer_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Ǹnyi te, ìgwak lak onəm oga mpyal oshozha oFilisti kà̱ uAkish, kang oza̱ là pa̱, <<Re unəm va̱ ta á le a ga atak va̱ u na á na pa̱ uza̱ a təm ka̱. Uza̱ i yà ká̱ ngga ìkum nzəng ká̱ yi ka̱t, le kang uza̱ a wong a ga̱ɓa̱n ìjili ìjang ká̱ yi kà̱ mpyal ìkum ka̱t. Mwote asa̱l va ta uza̱ a ɗa̱mshi ishimshe wò ká̱ ká̱ unəm uga nzhi wò ka̱ atak ngbá̱ng onəm yi nggo. ");
INSERT INTO yer_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","Rəng, uDawuda va ta̱ mí shì nnap ká̱ na ka̱ ashe ngba̱p nza̱m mí là pa̱, <<UShawulu gbá̱ng oji wò ikalong, kang uDawuda gbá̱ng oji wò ikalong pa̱ igba̱pchi.>> ");
INSERT INTO yer_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Te uAkish wór uDawuda là á na pa̱, <<Nva̱ uYawe uwa ká̱ irirì, mmaɓu unəm ukin, n ɗom pa̱ u ga ìkum nzəng ká̱ oshozha mi. A ɓàn ká̱ nda va̱ u ɓa ká̱ te, na n ya ɓu chit ká̱ mpat nro ka̱t ɓa chu n̂da va̱ ta̱. Ǹnyi te, nkpaktak onəm oga mpyal ma̱n ká̱ ɓu ka̱t. ");
INSERT INTO yer_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Ǹyangmata̱ le ga ká̱ ikángkáng, kang wa nəm iya̱m iro iva i lak ìgwak ônəm oga mpyal oFilisti ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","UDawuda ɓəp pa̱, <<Iza̱ n nəm yà? Nza̱ mpat u ya ukpari ɓu ká̱ ɓan ká̱ n̂da va̱ m ɓa ká̱ ɓa chu ǹyangmata̱ yà? Iza̱ nak kang mi ga mi lung okpa ìkum anəm uga nzhi mi uponzhi ka̱t yà?>> ");
INSERT INTO yer_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","UAkish na ama̱n pa̱, <<Ka̱ atak mi te, nnap nnəm ɓu á ɓyen ká̱ mi wa ama̱leka Inan. Kap ka̱ nna te, onəm oga mpyal oshozha oFilisti là pa̱ ɓu yà ká̱ ngga ìkum nzəng ká̱ yi ka̱t. ");
INSERT INTO yer_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Ǹyangmata̱ te, ipin ká̱ iɓotak wa fa nzəng ká̱ onəm oga nnəm inok unəm uga nzhi ɓu va̱ ɓa nzəng ka̱ ɓu. Nva̱ngva̱ atak ɓan ghan chit, te ó kpán asa̱l.>> ");
INSERT INTO yer_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Te uDawuda ká̱ onəm wò wong ká̱ ìpin kpan asa̱l pa̱ o le o ga mbin oFilisti, ǹnyi te, oFilisti kyen ga aJezerel. ");
INSERT INTO yer_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","Ka̱ nva̱ngva̱ uDawuda ká̱ onunggwan wò ɓa chu aZiklak kà̱ nra ngga nshatɗing te, oza̱ ya oAmalek ru aNegep ká̱ aZiklak chit ká̱ ìkum. Oza̱ pwak aZiklak pa̱ chatchat, ");
INSERT INTO yer_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","kang oza̱ wur ochar ká̱ nkpaktak onəm va̱ ka̱ ashe ìtong va̱ ta, ovan ká̱ onəmgbak. Oza̱ gbá̱l unəm uro ka̱t, ǹnyi te, oza̱ wur oza̱ ga ká̱. ");
INSERT INTO yer_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","Awalang va̱ uDawuda ká̱ onəm wò chu aZiklak te, oza̱ ya mmá pwak ìtong va̱ ta chit, kang mmá wur ochar oza̱ ká̱ ovan ochar, ká̱ ovan onunggwan oza̱ chit ka̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","Te uDawuda nzəng ká̱ onəm wò yə́ng pa̱ gənggəng, oza̱ ga lang ìkam iga ayə́ng. ");
INSERT INTO yer_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","Mmá ka̱ wur ochar aDawuda oga oparəm uAhinoyam uga aJezerel ká̱ uAbigel uwa uɓəɓar ka̱ yà uNabal unəm uga aKarmel á. ");
INSERT INTO yer_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","UDawuda yà ka̱ ashe nɗaktak pa̱ gənggəng, ka̱kul onəm kà̱ nlà pa̱ ó gwan na ká̱ ipang, ka̱kul udanggo ka̱ ashe nlak ìgwak, nva̱ oza̱ lang ovan oza̱ onunggwan ká̱ ochar. Ǹnyi te, uDawuda da̱r nkàm ka̱ atak aYawe Inan wò. ");
INSERT INTO yer_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","Te uDawuda là ûAbiyatar unəm uga mpyal awop uyen nunggwan aAhimelek pa̱, <<Ɓa ká̱ ìlukwan ìkwoksok á mi.>> Kang uAbiyatar ɓa ká̱ á na, ");
INSERT INTO yer_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","kang uDawuda ɓəp uYawe pa̱, <<M ɓàk nva̱ng onəm va̱ ta̱ ɓa ru yi ká̱ ìkum ɗò? Mi ɓàn oza̱ ɓàn ɗò?>> Kang uYawe na ama̱n pa̱, <<Ga, ɓàk nva̱ng oza̱, ɓu ɓàn oza̱ ɓàn kang ɓu vyat nkpaktak iya̱m va̱ oza̱ wur ká̱ ìkum.>> ");
INSERT INTO yer_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","UDawuda ká̱ onunggwan wò ìgba̱l pa̱ ìkpa̱ɗing va̱ nzəng ká̱ na ru asa̱l ngga, kang oza̱ ɓa chu awang aBesor te, oro tong ka̱ta. ");
INSERT INTO yer_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","Onəm ìgba̱l pa̱ ìparəm ɓa bəlak mpa̱ng awang ma̱t oza̱, ǹnyi te, uDawuda ká̱ onəm ìgba̱l pa̱ ìneɗing ga mpyal ká̱ mɓàk oza̱. ");
INSERT INTO yer_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","Onəm aDawuda ga ya unəm uga aMasar uro ka̱ ashe nzam, kang oza̱ ɓa ká̱ na ka̱ atak aDawuda. Oza̱ na ndəng á na ká̱ iya̱m-nrì pa̱ á ri, ");
INSERT INTO yer_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","oza̱ na awar ìpipyan iɓitɓit á na ká̱ awar ìba̱ngba̱ng iɓitɓit pa̱ ìparəm. Nva̱ngva̱ uza̱ ri te, nnap nnənəm ɓa, ka̱kul nra pa̱ ishatɗing uwa ri iya̱m iro ka̱t te wa iya̱m iro chit ka̱t ìzwam ká̱ alum. ");
INSERT INTO yer_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","UDawuda ɓəp na pa̱, <<Uda unəm uga nzhi ɓu yà? U fa ka̱ che yà?>> Uza̱ na ama̱n pa̱, <<Mmami unəm uga aMasar, uzwal anəm uga aAmalek uro. Unəm uga nzhi mi re mi kà̱ nva̱ng nra chit pa̱ nshatɗing ka̱kul n rurwa. ");
INSERT INTO yer_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","I ru aNegep aga aKeret ká̱ ìkum, ká̱ aNegep aga mbin aYahuda, ká̱ aNegep aga mbin aKalep. Kang í pwak aZiklak kpa.>> ");
INSERT INTO yer_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","UDawuda ɓəp na pa̱, <<Ɓu məma̱n ɓu ga ká̱ mi ka̱ atak onəm ìkum va̱ ta ɗò?>> Uza̱ na ama̱n pa̱, <<A yà pa̱ ɓu sóng anung á mi ká̱ aɗin Inan pa̱ ɓu ya ka̱ ngbá̱l mi ka̱t, ka̱t te ɓu na mi ka̱ ashe awo anəm uga nzhi mi ka̱t, te mi ga ká̱ ɓu ka̱ atak oza̱.>> ");
INSERT INTO yer_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","Uza̱ ga ká̱ uDawuda ka̱ atak oza̱, kang uza̱ ya oza̱ pəl chit ka̱ ashe agbagba, oza̱ ka̱ nri ká̱ ngwa ka̱ ngba̱p nza̱m ká̱ nchang izər ka̱kul nkpaktak iya̱m iga ngwur ka̱ atak ìkum va̱ oza̱ wur ka̱ mbin aFilisti ká̱ mbin aYahuda á. ");
INSERT INTO yer_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","UDawuda ru oza̱ ká̱ ìkum ká̱ arurong va̱ ta ga chu arurong aga ìpin ìkpa̱kkpa̱k. Unəm uro yà lár ka̱t, ya ovan nza̱m oro ìgba̱l pa̱ ìneɗing ova chəng ka̱ apal oga alakəmi oza̱ chwat. ");
INSERT INTO yer_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","UDawuda vyat nkpaktak iya̱m va̱ oAmalek wur, nzəng ká̱ ochar wò va̱ pa̱ oparəm. ");
INSERT INTO yer_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","Iya̱m iro yà lar ka̱t, iɓwakan ka̱t te ichumchum, ovan onunggwan ka̱t te ovan ochar. UDawuda le ká̱ nkpaktak iya̱m va̱ oAmalek wur ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","Uza̱ wur nkpaktak itam ká̱ iɓəl, ina ká̱ alakəmi oAmalek nak kà̱ mpyal iji oza̱ kang onənəm wà nggatək iya̱m nkang va̱ ta nzəng ká̱ iji oza̱, i là pa̱, <<Iya̱m iga ngwur ka̱ atak ìkum aDawuda nna ta̱.>> ");
INSERT INTO yer_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","Te uDawuda le atak onunggwan oga igba̱l pa̱ ìparəm ova̱ ka̱ bəlak chit, achen ma̱t oza̱ kang mmá ka̱ re ka̱ nva̱ng ka̱ awang aBesor. Oza̱ fa pa̱ ó gwang uDawuda ká̱ onəm va̱ nzəng ká̱ na. Nva̱ngva̱ uDawuda ká̱ onəm wò ɓa chu te, a re anung ôza̱. ");
INSERT INTO yer_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","Ǹnyi te, nkpaktak onəm onga ká̱ onəm olakchilakchi ka̱ ashe onəm aDawuda là pa̱, << Ka̱kul oza̱ ga nzəng ká̱ yi ka̱t te, i yà ká̱ nkap iya̱m iga ngwur ka̱ atak ìkum nzəng ká̱ oza̱ ka̱t. Ká̱ nna te, nza̱ unəm nggo a yar uchar wò ká̱ ovan wò na á ga.>> ");
INSERT INTO yer_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","Ǹnyi te, uDawuda na ama̱n ôza̱ pa̱, <<Pa ka̱t, ogənang mi, kang o nəm pa ká̱ iya̱m va̱ uYawe na á yi ka̱t. Uza̱ kpak yi kang à na okpa ìkum yi chit ka̱ ashe awo yi, ova̱ ɓa ru yi ká̱ ìkum á. ");
INSERT INTO yer_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Uda i gwong achwang ka̱ iya̱m va̱ ta̱ mmawó ka̱ nləla yà? Unəm va̱ gà ìkum ká̱ unəm va̱ təm mpángchí ayì te, mí kap iya̱m nkár.>> ");
INSERT INTO yer_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Á ɓàn ka̱ n̂da va̱ ta ɓa chu n̂da va̱ ta̱, uDawuda nak iya̱m va̱ ta sat nnap mpakpak ká̱ nnap nnəm ka̱ ashe oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","Awalang va̱ uDawuda chu aZiklak te, uza̱ re ǹre ka̱ iya̱m iga ngwur ka̱ atak ìkum iro ônəm oga mpyal oYahuda, ova okpəkpa, uza̱ là pa̱, <<Imwa nata̱ ka̱kul wó, í wur ka̱ atak okpa ìkum aYawe.>> ");
INSERT INTO yer_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","Uza̱ re ǹre ká̱ imwa va̱ ta ônəm oga mpyal oga itong va̱ ta̱, aBetel, ká̱ aRamot Negep, ká̱ aJatir, ");
INSERT INTO yer_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","ká̱ aAroya, ká̱ aSipmot, ká̱ aEshtemowa, ");
INSERT INTO yer_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","ká̱ aRakal, ká̱ oga itong oJeramel, ká̱ itong oKeni, ");
INSERT INTO yer_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","ká̱ aHorma, ká̱ aBor Ashan, ká̱ aAtak, ");
INSERT INTO yer_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","ká̱ aHebron ká̱ nkpaktak aɓoshi oga atak va̱ uDawuda ká̱ onəm wò chen kà̱. ");
INSERT INTO yer_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Ka̱ ashe ngga te, oFilisti ru oIsa̱rila ká̱ ìkum, kang onunggwan oIsa̱rila chəng ka̱ mpyal oFilisti. OFilisti gbá̱ng oza̱ pa̱ makmak ka̱ agəgər aƁam aGilbowa. ");
INSERT INTO yer_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","OFilisti ɓàk uShawulu ká̱ ovan wò onunggwan, kang oza̱ gbá̱ng ovəvan oga oshatɗing uJonatan ká̱ uAbinadap, ká̱ uMalkishuwa. ");
INSERT INTO yer_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Ìkum sur chit pa̱ gənggəng ka̱ apal aShawulu, kang ovan onunggwan oga ìjang oFilisti nak aɓang á na məmak. ");
INSERT INTO yer_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","UShawulu là ûnəm uga wur iya̱m ìkum wò pa̱, <<Tur ndokchi ɓu na u gbá̱l mi ká̱, le kang onəm oga ache amulur va̱ ta̱ a ɓa a kpan mi a na idumdum á mi, a nap avyal ká̱ mi ka̱t.>> Ǹnyi te, unəm uga ngwur iya̱m ìkukum yang, ka̱kul ayər nəm na nəm. Te uShawulu yar ndokchi kyer ishi wò ká̱ ru kú. ");
INSERT INTO yer_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Awalang va̱ unəm uga ngwur iya̱m ìkum aShawulu ya uza̱ kú chit, te uza̱ yar ndokchi wò kyer ishi wò ká̱, uza̱ ru kú nzəng ká̱ na. ");
INSERT INTO yer_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Wanta na uShawulu ká̱ ovan wò onunggwan oga oshatɗing, ká̱ unəm uga ngwur iya̱m ìkukum, ká̱ nkpaktak oshozhashozha, oza̱ kú n̂da nzəngtəng. ");
INSERT INTO yer_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Ká̱ nva̱ngva̱ oIsa̱rila va̱ ka̱ gwong mba̱nda̱m aJezerel ká̱ ova̱ ka̱ gwong awang aUrdun ya pa̱ oshozha oIsa̱rila chəng chit kà̱ mpyal ìkum kang uShawulu ká̱ ovan wò onunggwan kú chit, te oza̱ re oga itong oza̱, a chəng. Kang oFilisti ɓa ra ka̱ ashe oga itong va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Ipin fa kpa̱k te, oFilisti ga pa̱ na o wur iya̱m onəm va̱ mmá gbá̱ng te, oza̱ ya akúm aShawulu ká̱ ovan wò onunggwan oga oshatɗing ka̱ apal aƁam aGilbowa. ");
INSERT INTO yer_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Kang oza̱ gəl ishi aShawulu oza̱ zəp iya̱m ìkukum. Te oza̱ re ǹre ká̱ onəm oga nre ka̱ ashe nkpaktak mbin oFilisti, pa̱ oza̱ a ga ka̱ nnap-nlà nchángchàng va̱ ta̱ ka̱ atak nzhi ichər oza̱ ká̱ n̂kpaktak onəm oza̱. ");
INSERT INTO yer_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Oza̱ nak iya̱m ìkukum ka̱ ashe nzhi aAshtoret, kang oza̱ ran akúkum ka̱ izər akamsəlang ìtong aBet Shan. ");
INSERT INTO yer_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Kang onəm oga aJabesh Gileyat fe iya̱m va̱ oFilisti nəm ûShawulu te, ");
INSERT INTO yer_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","nkpaktak ovan onunggwan oga nkam ìgwak ka̱ ashe ìtong va̱ ta chen ka̱ ashe izwam va̱ ta ga aBet Shan. Oza̱ ga wur akúm aShawulu ká̱ ovəvan onunggwan va̱ oza̱ ran ká̱ izər akamsəlang aBet Shan á. Oza̱ ɓa ká̱ oza̱ ká̱ aJabesh, oza̱ shì izər oza̱ ka̱ta. ");
INSERT INTO yer_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Te oza̱ wur akup oza̱ kang oza̱ li ka̱ avəng ìkun atamariki ka̱ aJabesh, kang oza̱ yar ndəng gbà̱l nra pa̱ nfangshat.");
INSERT INTO yer_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Kà̱ nva̱ngva̱ uShawulu kú chit kang uDawuda le chit ka̱ atak nnəm igwan ká̱ oAmalek te, uza̱ təm nra pa̱ mparəm ka̱ aZiklak. ");
INSERT INTO yer_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","Kà̱ nra ngga nshatɗing te, unəm fa ka̱ apa̱k aShawulu ká̱ ìlukwan ikankan kang ká̱ mɓwang ka̱ ishi wò. Awalang va̱ uza̱ chu atak aDawuda te, uza̱ ru zəp ká̱ afu kà̱ mbin na ô na ichumchum á na. ");
INSERT INTO yer_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","UDawuda ɓəp na pa̱, <<U fa ka̱ che yà?>> Uza̱ na ama̱n pa̱, <<N chər ka̱ atak apa̱k oIsa̱rila.>> ");
INSERT INTO yer_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","UDawuda ɓəp na pa̱, <<Iza̱ ka̱ ngga yà? Là á mi.>> Uza̱ na ama̱n pa̱, <<Oshozha chəng chit ka̱ atak ìkum. Mmá gbá̱ng oza̱ pa̱ makmak, kang uShawulu ká̱ uyəyen ununggwan uJonatan kú kpa.>> ");
INSERT INTO yer_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","UDawuda ɓəp uyen nza̱m va̱ là iya̱m va̱ ta á na pa̱, <<U nəm sang kang u nyi pa̱ uShawulu ká̱ uyəyen ununggwan uJonatan kú yà?>> ");
INSERT INTO yer_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","UYən nza̱m va̱ ta là á na pa̱, <<Nva̱ngva̱ na ka̱ n yà ka̱ apal aƁam aGilbowa te, n ya uShawulu kà̱ nda̱r izər ka̱ apal aɓár wò, kang oga akeke ipəri okpa ìkukum kà̱ mɓa ndát ká̱ na. ");
INSERT INTO yer_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","Awalang va̱ uza̱ ga̱ɓa̱n kang uza̱ ya mi te, uza̱ wór mi, kang m ma̱n pa̱, <Mmami nata̱, anəm uga nzhi.> ");
INSERT INTO yer_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","<<Uza̱ ɓəp mi pa̱, <Mmaɓu uda yà?> <<N là á na pa̱, <Mmami unəm oAmalek.> ");
INSERT INTO yer_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","<<Te uza̱ là á mi pa̱, <Ɓa dat na u gbá̱l mi, ka̱kul mmami ka̱ ashe izər nrwa pa̱ gənggəng, ǹnyi te, na n yà ká̱ iriri.> ");
INSERT INTO yer_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","<<Te m ɓa dat kang n gbá̱l na, ka̱kul uza̱ ru chit kang n nyi pa̱ uza̱ i lár ka̱t. Kang n tur atagya iponzhi va̱ ka̱ ishishi ká̱ nkalɓang ngga ìgwal va̱ ka̱ ìgugwal kang m ɓa ká̱ pa̱ chatchat a ɓu, anəm uga nzhi mi.>> ");
INSERT INTO yer_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Te uDawuda ká̱ nkpaktak onunggwan va̱ nzəng ká̱ na kpan ilukwan oza̱ kan. ");
INSERT INTO yer_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Oza̱ təm ká̱ aɗor kang oza̱ yə́ng pa̱ gənggəng, oza̱ yar ndəng gbà̱l ga chu arurong ka̱kul aShawulu ká̱ uyəyen ununggwan uJonatan, ká̱ oshozha aYawe, ká̱ nzhi aIsa̱rila, ka̱kul oza̱ kú chit ka̱ atak ndokchi. ");
INSERT INTO yer_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","UDawuda ɓəp uyen nza̱m va̱ ɓa ka̱ nnap-nlà va̱ ta á na pa̱, <<U fa ka̱ che yà?>> Te uza̱ na ama̱n á na pa̱, <<Mmami uɗyanəm, uya anəm uga aAmalek, va ka̱ ntəm ka̱ ashe mbin ɓu á.>> ");
INSERT INTO yer_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","UDawuda ɓəp na pa̱, <<Iza̱ nak kang u gha̱p awo ɓu u gbá̱l ugargar àYawe ká̱, ayər nəm ɓu ka̱ ka̱t yà?>> ");
INSERT INTO yer_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","Te uDawuda là ûro ka̱ ashe onunggwan wò pa̱, <<Ga, gbá̱l na.>> Te uza̱ gəl na ka̱ ndokchi kang uza̱ kú. ");
INSERT INTO yer_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","UDawuda ka̱ là á na chit pa̱, <<Mpyat akat nchə̀r ɓu i təm ka̱ ishiɓu, ka̱kul mmaɓu na ká̱ anung ɓu, u là ka̱ awalang va̱ u là pa̱, <M gbá̱l uva̱ uYawe gar á.> >> ");
INSERT INTO yer_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","UDawuda shì ìpyang va̱ ta̱ ka̱kul ikú aShawulu ká̱ uyiyen uJonatan, ");
INSERT INTO yer_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","kang uza̱ nak pa̱ mmá ɗyang nnap-nshì va̱ ta ônəm oga aYahuda, aɗiɗin pa̱ nnap-nshì ngga ìjang, nna yà ka̱ ashe nlir aJashar. ");
INSERT INTO yer_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","<<Mmá gbá̱ng onəm oga mpyal ɓu chit áIsa̱rila, oma kú ra ka̱ apal oga aɗuktum wó, oshozha okamkam tak chit. ");
INSERT INTO yer_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","Kang mmá shet nnap va̱ ta̱ ka̱ aGat ka̱t, ka̱t te mmá là ka̱ apal oga asa̱l aAshəkelon ka̱t. Le kang ovan ochar oFilisti izər á chàng oza̱ ka̱t, le kang ovan ochar onəm oga ache amulur izər á chàng oza̱ ka̱t. ");
INSERT INTO yer_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","Óga aɓam aGilbowa, re kang ìmimyang á ra, ka̱t te iva̱r a pəng ka̱ apal wó ka̱t, le kang mbin ndopdop wó a na ìpirkur lap ka̱t. Ka̱kul ka̱ta na nggwanggwang ovan onunggwan okamkam mmá vyap kà̱, nggwanggwang aShawulu mí ɓəl mmì a na lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","Ìjang aJonatan iga ngbá̱ng iriri, ndokchi aShawulu ngga ǹya ká̱ aɗor ka̱t. I gbá̱ng oshozha okamkam, i gbá̱ng okpa ìkum. ");
INSERT INTO yer_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","Mma ma̱n uShawulu ká̱ uJonatan byet, ká̱ irirì oza̱ nzəng, ká̱ ikú oza̱ kap ka̱t. Kang oza̱ gha̱n ji oga nkumangga̱p ji, oza̱ kam ji oga ilir ji. ");
INSERT INTO yer_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","Óvanɓyen oga aIsa̱rila, ó yə́ng ka̱kul aShawulu, uva mwak oga ilukwan inəna̱n a wó iga mbwai, uva mwak ilukwan iga iya̱m ìsham iga azənariya a wó. ");
INSERT INTO yer_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","Ovan onunggwan ìkum okamkam tak chit ka̱ atak ìkum. UJonatan ra chit ukúkú ka̱ apal aɗuktum wó. ");
INSERT INTO yer_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","Mmami ká̱ nlak ìgwak pa̱ gənggəng ka̱kul ɓu agənang mi, uJonatan, m ma̱n ɓu byet. Mma̱n ɓu ka̱ atak mi a yà ka̱ mmàl ka̱t, a ji mma̱n achar ji ká̱ ununggwan. ");
INSERT INTO yer_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","Ovan onunggwan ìkum okamkam tak chit, oga iya̱m ìkum zhì chit.>> ");
INSERT INTO yer_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Ka̱ nva̱ng va̱ ta te, uDawuda ɓəp uYawe pa̱, <<N ga ìtong iro ka̱ ashe oga itong aYahuda ɗò?>> Te uYawe na ama̱n pa̱, <<À, ga.>> UDawuda ɓəp kà̱ɗi pa̱, <<Nza̱ ìtong n ga yà?>> Kang uYawe na ama̱n pa̱, <<AHebron.>> ");
INSERT INTO yer_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Te uDawuda ga ka̱ta ká̱ ochar wò oga oparəm, uAhinoyam uga aJezerel, ká̱ uAbigel, uchar ukpələng aNabal, unəm uga aKarmel. ");
INSERT INTO yer_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","UDawuda wur onunggwan va̱ nzəng ká̱ na kpa, uda nggo ká̱ nzhi wò kang oza̱ ga təm ka̱ aHebron ká̱ itutong. ");
INSERT INTO yer_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Te onunggwan oga aYahuda ɓa aHebron kang a gar uDawuda yà uponzhi ka̱ apal oYahuda. Awalang va̱ mmá là ûDawuda pa̱ onunggwan oga aJabesh Gileyat li uShawulu chit, ");
INSERT INTO yer_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","te uza̱ re onəm oga nre ká̱ nre ga ôza̱ pa̱, <<Re uYawe a pa̱r wó ka̱kul ikin va̱ ó nyám unəm uga nzhi wó uShawulu, nva̱ ó li na á. ");
INSERT INTO yer_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","Re uYawe á nyám ikin ká̱ nnandər a wó, kang mi nyám ká̱ a wó kpa, ka̱kul iya̱m va̱ ta̱ ó nəm á. ");
INSERT INTO yer_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","Ǹyangmata̱ te, ó nəm nkam ìgwak, ó sat pa̱ kakkərak, ka̱kul uShawulu unəm uga nzhi wó kú chit, kang onəm oga aYahuda gar mi chit uponzhi oza̱.>> ");
INSERT INTO yer_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","Ǹnyi te, uAbner uya aNer, unəm uga mpyal oshozha aShawulu, ka̱ yar uIshboshet chit uya uShawulu ga ká̱ ka̱ aMahanayim. ");
INSERT INTO yer_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","Ka̱ta uza̱ nak na uponzhi ka̱ apal aGileyat, ká̱ aAshuri ká̱ aJezerel, kang ka̱ apal aEfrayim, ká̱ aBenjamin kpa ká̱ nkpaktak aIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","UIshboshet uya aShawulu ká̱ ìzun ìsəm pa̱ ìneɗing ka̱ awalang va̱ mmá kyer na uponzhi ka̱ apal oIsa̱rila, kang uza̱ nəm iponzhi ìzun pa̱ ìparəm. Ǹnyi te, akum aYahuda ka̱ avəng aDawuda. ");
INSERT INTO yer_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","UDawuda nəm iponzhi ka̱ apal akum aYahuda ka̱ aHebron ìzun pa̱ ìfangshat ká̱ aɓuɓo. ");
INSERT INTO yer_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","UAbner uya aNer, nzəng ká̱ oshozha aIshboshet uya aShawulu, oza̱ wong re aMahanayim ga aGibiyon. ");
INSERT INTO yer_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","UJowap uya aZeruya nzəng ká̱ oshozha aDawuda fa kang à gwang oza̱ ka̱ apyáp aga aGibiyon. Ìdongkong iga ìzəng təm ka̱ a gwong apyáp aro, kang iro təm ka̱ a gwong aro. ");
INSERT INTO yer_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","UAbner là ûJowap pa̱, <<Re í nak ovan nza̱m oro á lung owan oza̱ ka̱ mpyal yi.>> Te uJowap là pa̱, <<Aməma, re oza̱ á lung.>> ");
INSERT INTO yer_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","Te mmá yak onunggwan pa̱ ogba̱pchi ama̱n pa̱ parəm ka̱ anung aBenjamin ká̱ uIshboshet uya aShawulu, kang pa̱ ogba̱pchi ama̱n pa̱ parəm ka̱ anung aDawuda. ");
INSERT INTO yer_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","Udanggo kpán ukpa ìkum wò ka̱ ishi, kang à kyer ká̱ ndokchi ka̱ alyaklyak, te nkpaktak oza̱ tak kú. Mmá pa aɗin atak va̱ ta ka̱ ashe aGibiyon pa̱, aHelkat Hazurim, ipipir pa̱ agbagba aga ndokchi. ");
INSERT INTO yer_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","Te ìkum va̱ ta sur byet n̂da va̱ ta, kang onunggwan aDawuda ri uAbner ká̱ onunggwan oga oIsa̱rila ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","OVan onunggwan aZeruya oga oshatɗing oma ka̱ yà ka̱ ta, uJowap, ká̱ uAbishayi, ká̱ uAsahel. UAsahel, uva i chər wa nkar, ");
INSERT INTO yer_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","a ɓàn ngwà uAbner, uza̱ lyep awo ari ka̱t te awo apəra̱m ka̱t. ");
INSERT INTO yer_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","UAbner ga̱ɓa̱n kang à ɓəp na pa̱, <<Mmaɓu ɗò áAsahel?>> UAsahel na ama̱n pa̱, <<À, mmami na.>> ");
INSERT INTO yer_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","UAbner là á na pa̱, <<Ga̱ɓa̱n awo ari ka̱t te awo apəra̱m, na u ɓàk uro ka̱ ashe ovan nza̱m va̱ ta̱, na u vyat iya̱m ìkukum.>> Ǹnyi te, uAsahel re ngwà na ka̱t. ");
INSERT INTO yer_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","UAbner won na kà̱ɗi pa̱, <<Re mɓàk mi. Mi gba̱l ɓu sang yà? Mi gba̱l ɓu te, mi gwang ìwu ká̱ ugənang ɓu uJowap sang yà?>> ");
INSERT INTO yer_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","Ǹnyi te, uAsahel yang ká̱ nre ngwà na, kang uAbner tar na ká̱ ìjili aɓar ka̱ afu kang aɓar ga fa ka̱ asəsəm. Uza̱ ru ka̱ta kang uza̱ kú. Unəm va pa̱ kpaktak ɓa chu atak va̱ uAsahel ru kú kà̱ te, i sat i dər. ");
INSERT INTO yer_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","Ǹnyi te, uJowap ká̱ uAbishayi ɓàk nva̱ng àAbner. Alum ka̱ ntar te, oza̱ chu aɗuktum aAmma dat ká̱ aGiya, ka̱ asa̱l a ga ngga nzam àGibiyon. ");
INSERT INTO yer_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","Te oshozha aAbner ká̱ akum ìjili aBenjamin gwang ishi oza̱ təm ìdongkong pa̱ ìzəng ka̱ apal aɗuktum pa̱ na ó ga ìkum. ");
INSERT INTO yer_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","UAbner lə́p achu ûJowap pa̱, <<Í ɗa̱mshi nnap yi ká̱ ndokchi na chwat ɗò? U nyi pa̱ nkukur te, iɗuɗul nkpaktak yi ka̱t ɗò? Azəmo ɓu wór onunggwan ɓu i re ngwà oIsa̱rila ogənang oza̱ yà?>> ");
INSERT INTO yer_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","Te uJowap là á na pa̱, <<N sóng anung chit ká̱ Inan iga iriri, ká̱ yà pa̱ u là nnap va̱ ta̱ ka̱t te, í yar chit pa̱ í ɓàk wó atak i ga i tan.>> ");
INSERT INTO yer_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","Te uJowap ɓur agbəshi kang nkpaktak oshozhashozha tong, oza̱ re ngwa oshozha oIsa̱rila, te oza̱ re nlung ìkum. ");
INSERT INTO yer_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","Ka̱ ashe nkpaktak ìzwam va̱ ta uAbner ká̱ onunggwan wò le wòl mba̱nda̱m aUrdun. Oza̱ pa̱ng awang, oza̱ ga mpyal ka̱ achen ga chu ipin ikpa̱kkpa̱k ká̱ ìpin, oza̱ tong ka̱t ga chu aMahanayim. ");
INSERT INTO yer_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","Nva̱ngva̱ uJowap re ngwà uAbner chit, te uza̱ ɓut nkpaktak oshozha wò. Kang uza̱ kúng oza̱ te, uza̱ lang onunggwan wò pa̱ ogba̱pchi ama̱n pa̱ fangzəngtəng gwang ká̱ uAsahel ka̱t. ");
INSERT INTO yer_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","Ǹnyi te, onəm aDawuda gbá̱ng onəm aAbəner ìgba̱l pa̱ ishatɗing ká̱ ìsəm pa̱ ìkpa̱ɗing, nkpaktak oza̱ ka̱ akum ijili àBenjamin. ");
INSERT INTO yer_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","UJowap ká̱ onəm wò yar akúm aAsahel ga aBet-Lehem ka̱, kang oza̱ ga li na ka̱ ashe awap apupon. Te oza̱ wong achen ká̱ izwam va̱ ta, oza̱ ɓa chu aHebron ka̱ atak tantàn. ");
INSERT INTO yer_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","Mmá nəm inok nnəm ìkum gba̱ng nva̱ng pa̱ makmak kà̱ ishimshe onəm oga nzhi àDawuda ká̱ onəm oga nzhi aShawulu. Ǹnyi te, uDawuda kà̱ nkám kà̱ nkám, kang nzhi aShawulu kà̱ nrusok kà̱ nrusok. ");
INSERT INTO yer_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","Ovan onunggwan va ta̱ mmá mar ûDawuda ka̱ aHebron, uyen uga nggəshi te, uAmnon, uwa unənang uAhinoyam uga aJezerel. ");
INSERT INTO yer_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","Uyen uga uparəm te, uKileyap, uwa unənang uAbigel, uchar àNabal ukpələng, uyen uga ushatɗing te, uAbsalom, uwa unənang uMaka uyen uchar àTalmai, uponzhi uga aGeshur. ");
INSERT INTO yer_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","Uyen uga uneɗing te, uAdonija, uwa unənang uHagit. Uga utukun te, uShefatiya, uwa unənang uAbital. ");
INSERT INTO yer_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","Kang uga ukpa̱ɗing te, uItireyam, uwa unənang uEgla. Nkpaktak ovan onunggwan va̱ ta̱ uDawuda mar ka̱ aHebron. ");
INSERT INTO yer_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","Ka̱ awalang va̱ ìkum ka̱ yà ka̱ ishimshe nzhi aDawuda ká̱ nzhi aShawulu te, uAbner ka̱ nnak atak nsat wò kà̱ nkam kà̱ nkam ka̱ ashe nzhi aShawulu. ");
INSERT INTO yer_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","UShawulu uwa ka̱ yà ká̱ uchar uro uva uza̱ nak ka̱ nzhi aɗiɗin pa̱, uRizpa, uya àAya uchar. Ká̱ n̂da nro te, uIshboshet ɓəp uAbner pa̱, <<Sang kang ɓu ra ká̱ uchar va̱ aPo mi nak ka̱ nzhi yà?>> ");
INSERT INTO yer_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","Ìgwak làk uAbner byet ka̱kul iya̱m va̱ uIshboshet là á. Te uza̱ na ama̱n pa̱, <<U rəng pa̱ mi ra ìjili aShawulu ɗò? U rəng pa̱ mmami ka̱ nləp asəm aYahuda ɗò? N̂da va̱ ta̱ na n yà kà̱ nkpak nnap nnəm n̂zhi aPo ɓu uShawulu ká̱ ogənanggənang, ká̱ okpəkpa. Kang na n na ɓu chit ka̱ ashe awo aDawuda ka̱t. Ká̱ nna kpa te, ǹyangmata̱, ka̱ apal achar va ta̱ na ɓu ya mpat mi kà̱ ɗò? ");
INSERT INTO yer_vpl VALUES ("S23_9","011_3_9","2SA","3","9","9","Re Inan á yar irirì mi, a yà pa̱ n nəm ûDawuda iya̱m va̱ uYawe yar nsar nnap nləlà á na ka̱ atak nsóng anung ka̱t á, ");
INSERT INTO yer_vpl VALUES ("S23_10","011_3_10","2SA","3","10","10","nna pa̱ o tur iponzhi ka̱ nzhi aShawulu kang o pak ìtok iponzhi aDawuda ka̱ apal oIsa̱rila ká̱ aYahuda, i ɓàn ka̱ aDan i ga i chu aBeyersheba.>> ");
INSERT INTO yer_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","UIshboshet là iya̱m iro ûAbner lap ka̱t, ka̱kul uza̱ kà̱ nnəm ayəyər. ");
INSERT INTO yer_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","Te uAbner re nre ka̱ onəm oga re ga atak aDawuda pa̱ á ɓəp na pa̱, <<Mbin va̱ ta̱ nji a da yà? Yar nsar nnap-nlà ká̱ mi, te mi ka̱mshi ɓu, mi ɓa ká̱ nkpaktak oIsa̱rila i yà ka̱ avəng ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","UDawuda na ama̱n pa̱, <<A ɓyen byet, mi yar nsar nnap-nlà yar ká̱ ɓu. Ǹnyi te, n ɗom iya̱m iro pa̱ izəng ka̱ atak ɓu, kang wa ɓa mpyal mi ka̱t, ya ɓu ɓa ká̱ uMikal uya aShawulu uchar kang, awalang va̱ ɓu ɓa ǹya mi á.>> ");
INSERT INTO yer_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","Te uDawuda re onəm oga ǹre ûIshboshet uya aShawulu ununggwan, na á là a na pa̱, <<Na uchar mi uMikal á mi, uva n mwa ìdudur ka̱ oga awa ache oFilisti ìgba̱l.>> ");
INSERT INTO yer_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","Te uIshboshet nak ga mma yar uMikal ka̱ atak aɓəɓar uPaltiyel, uya aLayish ununggwan. ");
INSERT INTO yer_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","Uɓəɓar yar nva̱ng achar wò ká̱ ayə́ng á ga chu ká̱ ka̱ aBahurim. Te uAbner là á na pa̱, <<Le nzhi.>> Te uza̱ le nzhi. ");
INSERT INTO yer_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","UAbner nəm ichən ká̱ onəmgbak oIsa̱rila kang à là pa̱, <<A gba̱ng nva̱ng chit nva̱ ka̱ ó ɗom uDawuda pa̱ a yà uPonzhi wó. ");
INSERT INTO yer_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","Ǹyangmata̱ te, o nəm iya̱m va̱ màl, ka̱kul uYawe ka̱ yar nsar nnap-nlà ûDawuda pa̱, <Ka̱ atak aDawuda na mi ka̱mshi onəm mi oIsa̱rila ka̱ ashe awo oFilisti ká̱ nkpaktak aɓo okpa ìkum oza̱.> >> ");
INSERT INTO yer_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","UAbner là nnap ká̱ akum ìjili aBenjamin kpa. Te uza̱ ga aHebron ka̱ atak aDawuda pa̱ ô là á na iya̱m va̱ oIsa̱rila ká̱ nkpaktak akum ijili aBenjamin ɗom pa̱ ó nəm. ");
INSERT INTO yer_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","Awalang va̱ uAbner ká̱ onəm ìsəm pa̱ ìparəm ga aHebron te, uDawuda nəm iya̱m-nrì iga nchang izər ôza̱. ");
INSERT INTO yer_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","Te uAbner là ûDawuda pa̱, <<Re n ga n wór nkpaktak oIsa̱rila á ɓa atak anəm uga nzhi mi, uponzhi na oza̱ á yar nsar nnap-nlà ká̱ ɓu, kang ɓu nəm iponzhi ka̱ apal oza̱, wa nva ìgwak ɓu ɗom.>> Te uDawuda re uAbner, kang uza̱ le nzhi ká̱ ikángkáng. ");
INSERT INTO yer_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","Ta byet te, onəm ìkum aDawuda ká̱ uJowap le ka̱ atak ìkum, kang oza̱ ɓa ká̱ iya̱m iga ngwur ka̱ atak ìkum pa̱ makmak. Ǹnyi te, uAbner yà nzəng ká̱ uDawuda ka̱ aHebron lap ka̱t, ka̱kul uDawuda re na chit, uza̱ ga ká̱ ikángkáng. ");
INSERT INTO yer_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","Awalang va̱ uJowap ká̱ nkpaktak oshozha va̱ nzəng ká̱ na ɓa chu te, uza̱ fe pa̱ uAbner ɓa atak aponzhi kang uza̱ le chit ká̱ ikángkáng. ");
INSERT INTO yer_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","Te uJowap ga atak aponzhi kang à là á na pa̱, <<Iza̱ u nəm ta̱ yà? Dər uAbner ɓa atak ɓu, sang kang u re na ga yà? Ǹyangmata̱ uza̱ ga chit. ");
INSERT INTO yer_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","U nyi pa̱, uAbner uya aNer ununggwan ɓa pa̱ ô lam ɓu na ô ya achen ɓu ká̱ nkpaktak iya̱m va̱ mmaɓu ka̱ nnənəm.>> ");
INSERT INTO yer_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","UJowap fa ka̱ atak aDawuda te, uza̱ re onəm oga ǹre pa̱ a ga á ɓa ka̱ uAbner kang oza̱ ga ya na kà̱ ndəng nka̱pka̱p ngga aSira, oza̱ ɓa ká̱ na. Ǹnyi te, uDawuda nyi iya̱m iro ka̱ apəpal ka̱t. ");
INSERT INTO yer_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","Nva̱ uAbner ɓa chu aHebron te, uJowap tar ká̱ na ka̱ ashe nzhi ngga ngba̱k anung asa̱l aga ntar ìtong wa uza̱ ɗom nnəm ichən ká̱ na. Te uza̱ kyer uAbner ka̱ afu a gba̱l na, ka̱kul mpyát akat agənang wò, uAsahel va̱ uza̱ ka̱ gbá̱l á. ");
INSERT INTO yer_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","UDawuda wong fe nnap va̱ ta̱ te, uza̱ là pa̱, <<UYawe nyinyi pa̱ mmami ká̱ iponzhi mi mbyet, awo yi yà ka̱ ashe ntar nchə̀r aAbner, uya aNer ununggwan ka̱t. ");
INSERT INTO yer_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","Re mpyat akat nchə̀r aAbner á yà ka̱ apal ishi aJowap ká̱ nkpaktak nzhi apupo. Re nza̱ nlwàk nggo ka̱ ashe onəm aJowap kang mma lang unəm uga ngwàr afən, ka̱t te unəm uga nlak, ka̱t te unəm uga nta ká̱ ìdari, ka̱t te unəm va mma gba̱l ka̱ atak ìkum, ka̱t te unəm uga nlang iya̱m-nrì ka̱ ashe onənəm ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","Wa nna ta uJowap ká̱ ugənang wò uAbishayi gbá̱l uAbner ka̱kul agənang oza̱ uAsahel uva uAbner gbá̱l ka̱ atak ìkum ka̱ aGibiyon á. ");
INSERT INTO yer_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","Te uDawuda là ûJowap ká̱ nkpaktak onəm va̱ nzəng ká̱ na pa̱, <<Ó kan ilukwan wó na ó mwak aryakryak na ó yə́ng ikú aAbner.>> Kang uponzhi uDawuda yar nva̱ng akúm ga ká̱ ka̱ atak awap. ");
INSERT INTO yer_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","Oza̱ li uAbner ka̱ aHebron te, uponzhi tul ayə́ng pa̱ bobo ka̱ anung awap aAbner, kang nkpaktak onəm bà ayə́ng kpa. ");
INSERT INTO yer_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","Te uponzhi shì ìpyang va̱ ta̱ ûAbner pa̱, <<Iza̱ nak kang uAbner ikú wa mpərək yà? ");
INSERT INTO yer_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","Mmá ran awo a ɓu ka̱t, mmá pá nzwar a ɓu ka̱ ashar ka̱t. U kú wa anəm va onəm oɓá̱ngɓa̱ng à gbá̱l.>> Kang nkpaktak onəm yə́ng kà̱ɗi ka̱kul aAbner. ");
INSERT INTO yer_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","Te nkpaktak onəm ɓa chal uDawuda pa̱ uza̱ á ri iya̱m-nrì ká̱ alum na byet, ǹnyi te, uDawuda sóng anung pa̱, <<Re Inan á yar irirì mi, a yà pa̱ n ri iya̱m iro kang alum i tar á.>> ");
INSERT INTO yer_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","Nkpaktak onəm dər nnap va̱ ta te, á chàng ká̱ oza̱, nkpaktak iya̱m va̱ uponzhi nəm te, á chəchàng ká̱ oza̱. ");
INSERT INTO yer_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","Ká̱ nda va̱ ta te, nkpaktak onəm va̱ ka̱ ta ká̱ nkpaktak oIsa̱rila nyi pa̱ uponzhi yà ká̱ awo ka̱ ashe ngbá̱l uAbner uya aNer ununggwan ka̱t. ");
INSERT INTO yer_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","Te uponzhi là ônəm wò pa̱, <<Ó nyinyi pa̱ n̂da va̱ ta̱ unəm uga mpyal ìkum uchumchum ka̱ ashe aIsa̱rila kú chit ka̱t ɗò? ");
INSERT INTO yer_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","Kang n̂da va̱ ta̱, káp ká̱ nva̱ mmami na uponzhi ugargar te, ovan aZeruya onunggwan oga oparəm va̱ ta̱, uJowap ká̱ uAbishayi oza̱ ma̱t mi ma̱t. Re uYawe á pyat akat ûnəm uga nnəm inga ka̱kul ingənga va̱ uza̱ nəm á.>> ");
INSERT INTO yer_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","Awalang va̱ uIshboshet, uya aShawulu ununggwan fe ikú aAbner ka̱ aHebron te, igwal rusok ka̱ na, kang ayər nəm nkpaktak oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","Ǹyangmata̱ te, uIshboshet uya aShawulu ununggwan uwa ka̱ yà ká̱ onəm pa̱ oparəm, uBana ká̱ uRekap, ova onəm oga mpyal onəm oga mɓa nru atak ká̱ ìkum. Oma ovan aRimmon onunggwan, unəm uga aBerot ka̱ akum ìjili àBenjamin kang mma nak pa̱ aBerot ka̱ ashe mbin aBenjamin, ");
INSERT INTO yer_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","ka̱kul onəm oga aBerot chəng ga aGitayim, oza̱ ga təm ka̱ta wa onəmchən n̂da va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","UJonatan uya aShawulu ununggwan uwa ka̱ yà ká̱ uyen ununggwan ugurum, aɗiɗin pa̱ uMefiboshet. Uza̱ ka̱ ya ká̱ ìzun pa̱ ìtukun awalang va̱ mmá fe ikú aShawulu ká̱ uJonatan ka̱ atak ìkum ka̱ aJezerel. Te uchar va̱ i nakshi ká̱ uyen va̱ ta yar na ká̱ nggha̱n chə́r ká̱. Uza̱ ka̱ ashe nchə́r te, uyen va̱ ta ru te, yà ugurum. ");
INSERT INTO yer_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","URekap ká̱ uBana, ovan aRimmon onunggwan unəm oga aBerot, oza̱ ga nzhi aIshboshet ká̱ alum ka̱ apal ndəng ya uza̱ wa ka̱ nra ka̱ njul. ");
INSERT INTO yer_vpl VALUES ("S24_6","011_4_6","2SA","4","6","6","Oza̱ táng ashe nzhi na oza̱ kà̱ nɗom pa̱ ó yar ìzangzəng te, oza̱ kyer na ka̱ afu, kang uRekap ká̱ uBana chəng. ");
INSERT INTO yer_vpl VALUES ("S24_7","011_4_7","2SA","4","7","7","Awalang va̱ oza̱ ka̱ ga ashe nzhizhi te, ya uIshboshet uwa ka̱ nra nda ka̱ apal alyer wò. Te oza̱ kyer na, kang oza̱ gbá̱l na, oza̱ gəl ishishi, kang oza̱ yar chen ka̱ ka̱ ashe nkpaktak ìzwam va̱ ta kà̱ mba̱nda̱m aUrdun. ");
INSERT INTO yer_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","Oza̱ ɓa ká̱ ishi aIshboshet ûDawuda ka̱ aHebron, kang oza̱ là ûponzhi pa̱, <<Ishi aIshboshet uya aShawulu ununggwan nata̱, ukpa ìkum ɓu, uva ka̱ ram irirì ɓu á. N̂da va̱ ta̱ uYawe pyát ûnəm uga nzhi yi uponzhi chit ka̱ apal ishi aShawulu ká̱ nzhizhi.>> ");
INSERT INTO yer_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","Te uDawuda na ama̱n ûRekap ká̱ ugənanggənang uBana, ovan aRimmon onunggwan unəm uga aBerot pa̱, <<Ká̱ nva̱ uYawe uwa yà ká̱ irirì, uva fa ká̱ mi ka̱ ashe nkpaktak nɗaktak, ");
INSERT INTO yer_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","awalang aro te, unəm uro ɓa atak mi ka̱ aZiklak là á mi pa̱, <UShawulu kú chit,> kang uza̱ rəng pa̱ ò ɓa ka̱ nnap ngga nchàng nfe á mi, te n kpan na n gbá̱l. Amumwa na n na á na ta ka̱kul nnap va̱ uza̱ ɓa ka̱ á. ");
INSERT INTO yer_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","Kang mmawó onəm oɓá̱ngɓa̱ng va̱ ta̱, ó gbá̱l unəm unəna̱n ka̱ ashe nzhizhi ka̱ apal iya̱m nrəra, i ga mɓa̱ng a wó i jiji. Mí ram nchə̀chər ka̱ ashe awo wó, kang mí dəkən wó ka̱ apambin va̱ ta̱.>> ");
INSERT INTO yer_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","Te uDawuda nak oshozha wò pa̱ á gbá̱ng oza̱, kang oza̱ gbá̱ng oza̱. Oza̱ kyen oga awo ká̱ ashar oza̱, kang oza̱ zong izər oza̱ ka̱ anung apyáp ka̱ aHebron. Ǹnyi te, oza̱ yar ishi aIshboshet ga li ka̱ ashe awap aAbner ka̱ aHebron. ");
INSERT INTO yer_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Nkpaktak akum ìjili oIsa̱rila ga atak aDawuda ka̱ aHebron kang oza̱ là á na pa̱, <<Mmayi ìzhe ɓu, mmayi nchə̀r ɓu. ");
INSERT INTO yer_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Ká̱ mmatmat, awalang va̱ uShawulu wa ka̱ yà uponzhi ka̱ apal yi te, mmaɓu na ka̱ yà unəm uga nlə́p mpyal oIsa̱rila ka̱ ìkum. Kang uYawe là a ɓu pa̱, <Ɓu ga nkpak onəm mi oIsa̱rila, kang ɓu yà unəm uga mpyal oza̱.> >> ");
INSERT INTO yer_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Awalang va̱ nkpaktak onəmgbak oIsa̱rila ɓa atak aPonzhi uDawuda ka̱ aHebron te, uponzhi yar nsar nnap ká̱ oza̱ ka̱ mpyal aYawe, kang oza̱ gar uDawuda uponzhi ka̱ apal oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","UDawuda ka̱ yà ká̱ ìzun ìsəm pa̱ ishatɗing ka̱ awalang va̱ uza̱ yà uponzhi, kang uza̱ nəm iponzhi ìzun ìsəm pa̱ ìneɗing. ");
INSERT INTO yer_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Uza̱ nəm iponzhi ka̱ apal aYahuda ka̱ aHebron ìzun pa̱ ìfangshat ká̱ apye pa̱ kpa̱ɗing, kang ka̱ aUrushelima te, uza̱ nəm iponzhi ka̱ apal nkpaktak aIsa̱rila ká̱ aYahuda ìzun ìsəm pa̱ ishatɗing ama̱n pa̱ shatɗing. ");
INSERT INTO yer_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Uponzhi ká̱ onunggwan wò ga aUrushelima ka̱kul pa̱ na ó ru oJebusi ká̱ ìkum va̱ ka̱ ntəm ka̱ta. OJebusi là ûDawuda pa̱, <<Ɓu yà ka̱ ǹtar ka̱ta̱ ka̱t, onəm ofofo ká̱ onəm ogurumgurum kur mɓak ɓu kur.>> Oza̱ rəng pa̱, << UDawuda i tar ka̱ta̱ ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","ASiyona na yà ká̱ akamsəlang akamkam, kap ka̱ nna te, uDawuda ri ká̱ ìkum, kang a ta̱l ìTong aDawuda. ");
INSERT INTO yer_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","N̂da va̱ ta uDawuda là ônəm wò pa̱, <<Unəm va pa̱ kap ɗom pa̱ ô nəm igwan ká̱ oJebusi te, nkpak pa̱ uza̱ i wòl asa̱l ka̱ asa̱l va ndəng inang kà̱, ka̱ asa̱l va ta o ru <onəm ogurumgurum ká̱ ofofo> ova okpa ìkum aDawuda á.>> Nna nak te, oza̱ i là pa̱, <<Onəm ofofo ká̱ ogurumgurum i táng ashe nzhi iponzhi ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","UDawuda nak ìtong iga akamsəlang akamkam va̱ ta təm atak ntətəm, kang uza̱ wór pa̱ ìTong aDawuda. Uza̱ me akamsəlang abalbal gang ìtong va̱ ta, ɓàn ka̱ aMilo, atak va mma yə́l ká̱ mbin ka̱ asa̱l nfa alum aɗuktum. ");
INSERT INTO yer_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Kang uza̱ yà ká̱ ichumchum pa̱ gənggəng ka̱kul uYawe, Inan uGa ngGatək uwa yà nzəng ká̱ na. ");
INSERT INTO yer_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","Ǹyangmata̱ te, uHiram uponzhi uga aTaya re nre ká̱ onəm oga ǹre ûDawuda, nzəng ká̱ akún asida, ká̱ onəm oga mpak iya̱m ká̱ akún, ká̱ onəm oga mme nzhi ngga ipang, kang oza̱ me nzhi iponzhi ûDawuda. ");
INSERT INTO yer_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","Te uDawuda nyi pa̱ uYawe nak wò chit ò ta̱l uponzhi ka̱ apal oIsa̱rila, kang uza̱ rup ká̱ iponzhiponzhi chit kpa ka̱kul onənəm oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","Ka̱ nva̱ngva̱ uDawuda wong re aHebron te, uza̱ ka̱m ochar va mí nak ka̱ ashe nzhi pa kùk kang uza̱ ka̱m ochar oga ìvang ka̱ aUrushelima, kang oza̱ mar ovan onunggwan ká̱ ovan ochar á na pa̱ makmak. ");
INSERT INTO yer_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","Oga aɗin ovan onunggwan va ta̱ mma mar ûDawuda ka̱ aUrushelima, uShammuwa, ká̱ uShobap, ká̱ uNatan, ká̱ uSolomon, ");
INSERT INTO yer_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","ká̱ uIbhar, ká̱ uElishuwa, ká̱ uNefek, ká̱ uJafiya, ");
INSERT INTO yer_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","ká̱ uElishama, ká̱ uEliyada, ká̱ uElifelet. ");
INSERT INTO yer_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","Awalang va̱ oFilisti fe chit pa̱ mma kyer uDawuda chit uponzhi ka̱ apal oIsa̱rila, te oza̱ fa pa̱ kpaktak ga nram na. Ǹnyi te, uDawuda fe te, a fa ga atak mbwam. ");
INSERT INTO yer_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","OFilisti ɓa chu te, oza̱ zal ka̱ ashe mba̱nda̱m aRefayim. ");
INSERT INTO yer_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","Te uDawuda ɓəp uYawe pa̱, <<N ga n ru oFilisti ká̱ ìkum ɗò? Ɓu na oza̱ na ka̱ ashe awo mi ɗò?>> Te uYawe na ama̱n a na pa̱, <<Ga, nnandər, mi na oza̱ na ka̱ ashe awo ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","Te uDawuda ga aBal Perazim, kang ka̱ta uza̱ nəm igwan ká̱ oFilisti. Uza̱ là pa̱, <<Wa nva ndəng kakchi awang te, uYawe tul onəm ìkum mi chit ka̱ mpyal mi.>> Ka̱kul nva̱ ta te, mí wor atak va̱ ta pa̱, aBal Perazim, ìpipir pa̱ uYawe uwa tul. ");
INSERT INTO yer_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","OFilisti chəng re oga ichər oza̱ ka̱ta, kang uDawuda ká̱ onungwan wò wur oza̱ ga ká̱. ");
INSERT INTO yer_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","OFilisti le ɓa zal ka̱ mba̱nda̱m aRefayim kà̱ɗi. ");
INSERT INTO yer_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","Te uDawuda ɓəp ka̱ atak aYawe, kang uYawe na ama̱n á na pa̱, <<Kang wa ga ka̱ oza̱ nzwang ka̱t, ǹnyi te, fa ôza̱ ka̱ asa̱l nsəm, kang ɓu ru oza̱ ká̱ ìkum ka̱ mpyal ikun abalsam. ");
INSERT INTO yer_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Wa fe na byet atak i pyep i chən ka̱ apal ikun abalsam te, wa ga ká̱ nggha̱n ka̱kul nna ta i nyám pa̱ uYawe watar mpyal a ɓu chit pa̱ na ô gbá̱ng oshozha oFilisti.>> ");
INSERT INTO yer_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","Te uDawuda nəm wa nva uYawe ka̱ nak na, kang uza̱ ɓan ngbá̱ng oFilisti ka̱ aGibiyon ga chu aGezer. ");
INSERT INTO yer_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","UDawuda ɓut nkpaktak oshozha oga ǹnyi nnəm ìkum ka̱ɗi oga aIsa̱rila, ìkalong ìsəm pa̱ ishatɗing. ");
INSERT INTO yer_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","Uza̱ ká̱ nkpaktak oshozha wò ga aBala ka̱ aYahuda pa̱ na o ɓa ká̱ akwati aga nsar nnap-nlà Inan va̱ ka̱ ta, ava mí wór ká̱ Aɗin, aɗin àYawe uGa ngGatək, uva təm ka̱ ìtok iponzhi va ka̱ apal akwati aga nsar nnap-nlà ka̱ ishimshe oga akerup. ");
INSERT INTO yer_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","Oza̱ yar akwati aga nsar nnap-nlà Inan ka̱ nzhi aAbinadap, nva ka̱ apal aɗuktum, oza̱ nak ka̱ apal akeke apipye va ina i dap. UUza ká̱ uAhiyo, ovan aAbinadap onunggwan, oma ka̱ mpángchí akeke apipye va ina i dap á, ");
INSERT INTO yer_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","nzəng ká̱ akwati aga nsar nnap-nlà Inan ka̱ apəpal, kang uAhiyo uwa kà̱ nchen kà̱ mpipyal. ");
INSERT INTO yer_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","UDawuda ka̱ nkpaktak oIsa̱rila kà̱ nnəm nchang izər ká̱ nkpaktak ìkam oza̱ kà̱ mpyal aYawe, oza̱ kà̱ nshì nnap-nshì, ká̱ nnə́m oga iya̱m wa aɓwa, ká̱ aɓwa acham, ká̱ apa̱ngga̱ng, ká̱ aláláji, ká̱ nchanggong. ");
INSERT INTO yer_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Oza̱ ɓa chu atak mpək iya̱m aga aNakon te, uUza yichi awo kpan akwati aga nsar nnap-nlà Inan ká̱ ka̱kul ina va̱ kà̱ ndap akeke va̱ ta ləp ìfang. ");
INSERT INTO yer_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Te ìgwak làk uYawe ka̱ uUza, ka̱kul uza̱ na ichumchum Înan ka̱t, nva̱ uza̱ kpan akwati va̱ ta á. A nak te, Inan ləp na kang uza̱ ru kú ka̱ ngba̱k akwati va̱ ta. ");
INSERT INTO yer_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Te uDawuda mən ìkum, ka̱kul nva̱ uYawe nyám nlak igwak ka̱ apal aUza á, kang ɓa chu n̂da va̱ ta̱ mí wor atak va̱ ta pa̱, aPerez aUza, ìpipir pa̱ ǹnyám nlak ìgwak ka̱ apal aUza. ");
INSERT INTO yer_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","UDawuda nəm ayər aYawe n̂da va̱ ta, kang uza̱ là pa̱, <<Mi nəm sang kang akwati aga nsar nnap-nlà aYawe va̱ ta̱ i ɓa atak mi yà?>> ");
INSERT INTO yer_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","Uza̱ ɗom pa̱ o yar akwati aYawe va̱ ta a yà nzəng ka̱ wò ka̱ ashe ìTong aDawuda ka̱t. Ka̱ɗor nva̱ ta te, uza̱ ga ká̱ ka̱ nzhi aObet Edom unəm uga aGat. ");
INSERT INTO yer_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","Akwati aYawe təm ka̱ ashe nzhi aObet Edom ape pa̱ shatɗing, kang uYawe pa̱r na ká̱ nkpaktak onənəm. ");
INSERT INTO yer_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","UPonzhi uDawuda fe pa̱, <<UYawe pa̱r nzhi aObet Edom chit ká̱ nkpaktak iya̱m va̱ uza̱ ka̱, ka̱kul akwati aga nsar nnap-nlà Inan va̱ ta.>> Te uDawuda fa ga pa̱ ô ɓa ká̱ akwati va̱ ta ka̱ ashe ìTong aDawuda ká̱ nchang ìgwak. ");
INSERT INTO yer_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Ka̱ nva̱ngva̱ onəm oga ǹyar akwati aga nsar nnap-nlà aYawe va̱ ta ga ka̱ chit ntong ashar pa̱ kpa̱ɗing, te uDawuda yichi nləfər ngga akut ká̱ iya ina va̱ mma kang ka̱ nzhi. ");
INSERT INTO yer_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","UDawuda pá ìlukwan ìkwoksok iga alinin, kang uza̱ gba̱p nza̱m ká̱ kà̱ mpyal aYawe ká̱ kpaktak ikam wò, ");
INSERT INTO yer_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","nva̱ uza̱ ká̱ nkpaktak oIsa̱rila kà̱ mɓa ká̱ akwati aga nsar nnap-nlà aYawe te, oza̱ kà̱ ngham achu ká̱ mɓur oga agbəshi. ");
INSERT INTO yer_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Nva̱ akwati aga nsar nnap-nlà aYawe kà̱ ntar ashe ìTong aDawuda te, uMikal uya aShawulu uchar ɓál kà̱ mɓol ayir nzhi. Kang awalang va̱ uza̱ ya uPonzhi uDawuda kà̱ myat kang kà̱ ngba̱p nza̱m kà̱ mpyal aYawe te, uza̱ ɓak na ka̱ ashe ìgwak wò. ");
INSERT INTO yer_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Oza̱ ɓa ká̱ akwati aga nsar nnap-nlà aYawe kang oza̱ nak ka̱ ashe aghal va̱ uDawuda pak ka̱kukul á, kang uDawuda yichi oga iya̱m inana iga nshì pa̱ ɗwot ká̱ iga ntəm ikángkáng kà̱ mpyal aYawe. ");
INSERT INTO yer_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Nva̱ngva̱ uza̱ gba̱l ká̱ ǹyichi oga iya̱m inana iga nshì pa̱ ɗwot ká̱ iga ntəm ikángkáng te, uza̱ pa̱r onəm ka̱ ashe aɗin aYawe uGa ngGatək. ");
INSERT INTO yer_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","Te uza̱ kap nzəngkəng ká̱ awar akulom aɓitɓit ká̱ awar ìba̱ngba̱ng mɓitɓit n̂za̱ unəm nggo ka̱ ashe nkpaktak nggatək oIsa̱rila, nkpaktak onunggwan ká̱ ochar. Kang nkpaktak onəm le oga nzhi oza̱. ");
INSERT INTO yer_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Awalang va̱ uDawuda le nzhi pa̱ na ô pa̱r onəm oga ashe nzhi wò te, uMikal uya aShawulu uchar fa pa̱ na ô gwang na, kang à là pa̱, << Uponzhi oIsa̱rila nəm iya̱m ichumchum chit ká̱ n̂da va̱ ta̱, nva̱ uza̱ bol izər re kà̱ mpyal ozwal ovan ochar ozuzwal wa nva nza̱ uyen uga ayə́r nggo i nəm á.>> ");
INSERT INTO yer_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","UDawuda na ama̱n ûMikal pa̱, <<N gba̱p nza̱m ka̱ mpyal aYawe, uva yak mi ka̱ɗor apo ɓu, ka̱t te nza̱ unəm nggo ka̱ ashe nzhizhi. Uza̱ nak mi chit n sat unəm uga mpyal onəm aYawe chit, oIsa̱rila. Ka̱kul nva̱ ta te, mi nəm nchang izər kà̱ mpyal aYawe. ");
INSERT INTO yer_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","Mi ɓak ishi mi ɓak i ji nva̱ ta̱ kang mi yen ká̱ ishi mi yen ka̱ mpyal ɓu. Ǹnyi te ovan ochar va̱ u là nnap oza̱ te, oza̱ i na ichumchum na á mi.>> ");
INSERT INTO yer_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","Te uMikal, uya aShawulu uchar mar ka̱t ga kú pa. ");
INSERT INTO yer_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Nva̱ngva̱ uPonzhi uDawuda təm chit ka̱ ashe nzhi iponzhi wò, kang uYawe na njul á na chit ka̱ atak nkpaktak okpa ìkukum va̱ gang na, ");
INSERT INTO yer_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","te uza̱ là ûNatan unəm uga nlà ichu Inan pa̱, <<Dər, mmami ka̱ nra ka̱ ashe nzhi iponzhi ngga akun asida, kang akwati aga nsar nnap-nlà Inan na təm ka̱ ashe aghal.>> ");
INSERT INTO yer_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","UNatan na ama̱n ûponzhi pa̱, <<Nkpaktak iya̱m va̱ mmaɓu ká̱ ka̱ ashe ìgwak te, wa ga mpyal ká̱, nəm ka̱kul uYawe wa nzəng ká̱ ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Ká̱ izwam va̱ ta te, uYawe là ûNatan pa̱, ");
INSERT INTO yer_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","<<Ga là ûzwal mi uDawuda pa̱, iya̱m va ta̱ uYawe là, <Mmaɓu na ɓu me nzhi á mi nva̱ mi təm ka̱ ashishe ɗò? ");
INSERT INTO yer_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","N na n təm chit ka̱ ashe nzhi nro ka̱t, ɓàn ka̱ n̂da va̱ n fa ká̱ oIsa̱rila ka̱ ashe aMasar ɓa chu nda va̱ ta̱. Mmami ka̱ nranggang pa̱ ɗəkər ka̱ aghal, nna atak ntəm mi. ");
INSERT INTO yer_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Nkpaktak atak va̱ n ga ka̱ ká̱ oIsa̱rila te, ka̱ n là ûnəm uro chit ka̱ ashe onəm oga mpyal oIsa̱rila va̱ n nak pa̱ á kpak onəm mi oIsa̱rila pa̱, <<Sang kang u me nzhi ngga akun asida a mi ka̱t yà?>> > ");
INSERT INTO yer_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","<<Ǹyangmata̱ te, là ûzwal mi uDawuda pa̱, <Iya̱m va ta̱ uYawe uGa ngGatək là. N yar ɓu ya na mmaɓu kà̱ nkpak iya̱m nkang kang n nak ɓu u yà unəm uga mpyal onəm mi oIsa̱rila. ");
INSERT INTO yer_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Na ka̱ n yà nzəng ká̱ ɓu ka̱ nza̱ atak nggo va̱ u ga, kang n zhì nkpaktak okpa ìkum ɓu ka̱ mpyal ɓu. Ǹyangmata̱ mi ga nnak aɗin ɓu i dam, wa aɗin onəm odamdam ka̱ ashe apambin. ");
INSERT INTO yer_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Kang mi ga nna atak ônəm mi oIsa̱rila kang mi nak oza̱ i təm kà̱ na oza̱ a yà ká̱ nzhi ngga ishi oza̱ kang mí ɗak oza̱ lap ka̱t. Onəm oɓá̱ngɓa̱ng i ka̱r oza̱ lap ka̱t, wa nva̱ oza̱ ka̱ nəm ôza̱ mmatmat á, ");
INSERT INTO yer_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","kang oza̱ ka̱ yà ka̱ nnəm pa ka̱ awalang va̱ n nak onəm oga mpyal ônəm mi oIsa̱rila. Mi ga nna njul a ɓu kpa ka̱ atak nkpaktak okpa ìkum ɓu. << <UYawe là a ɓu pa̱, mmawò na ká̱ ishi wò ò ga nnak nzhi ɓu i nəm iponzhi mbyet. ");
INSERT INTO yer_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Awalang va̱ nra ɓu chu chit kang u kú te, mi ga ngwong ká̱ uro ka̱ ashe akum ijili ɓu pa̱ a yar atak nsat ɓu, kang mi pak iponzhiponzhi ìkam. ");
INSERT INTO yer_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Uza̱ wa i me nzhi ka̱kul aɗin mi. Kang mi pak itok iponzhiponzhi i təm mbyet. ");
INSERT INTO yer_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Mi yà upupo, kang uza̱ i yà uyen mi ununggwan. A yà pa̱ uza̱ á nəm mpat te, mi nəm inok ká̱ onəm i nyám ntàn á na. Onəm oma i sat nlilyat á na. ");
INSERT INTO yer_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Ǹnyi te, mi yar mma̱n mi i le ka̱ apal ishishi ka̱t, wa nva̱ n yar ka̱ le ka̱ apal aShawulu á, uva n tur na le kang n nak ɓu uponzhi á. ");
INSERT INTO yer_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Nzhi ɓu ká̱ iponzhi ɓu i ga ntəm kà̱ mpyal mi mbyet, kang mi ga mpak ìtok iponzhi ɓu mbyet.> >> ");
INSERT INTO yer_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","UNatan là ûDawuda nkpaktak oga iya̱m va̱ ka̱ ashe alár va̱ ta̱. ");
INSERT INTO yer_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","Te uPonzhi uDawuda tar kang à təm kà̱ mpyal aYawe, kang uza̱ là pa̱, <<Mmami uda yà, uNəm Uga Nzhi uYawe, onəm mi oda yà, kang u gha̱p mi wa nta̱ yà? ");
INSERT INTO yer_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","Kang na ka̱ nna à kúr ka̱ ɓu chit ka̱t, uNəm Uga Nzhi uYawe, u là nnap chit kpa ka̱ apal iya̱m va̱ i ga nyà kà̱ nzhi azwal ɓu ká̱ nnap mpakpak va̱ ta̱. uNəm Uga Nzhi uYawe, wanta̱ na ɓu nəm ûnəmləbər ɗò? ");
INSERT INTO yer_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","<<Iza̱ mi là a ɓu lap yà? Ka̱kul u nyi uzwal ɓu nyi, aYawe uGa iChumchum. ");
INSERT INTO yer_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","Ka̱kul nnap-nlà ɓu kang ka̱ atak nɗom ɓu, u nəm iya̱m ichumchum va̱ ta̱, kang u nak uzwal ɓu nyi. ");
INSERT INTO yer_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","<<Mmaɓu na uga uchumchum, aYawe uGa iChumchum. Unəm uro yà wa nji ɓu ka̱t kang Inan iro yà wa nji ɓu ka̱t, wa nva̱ i fe ká̱ oga achwang yi á. ");
INSERT INTO yer_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","Kang uda wa onəm ɓu oIsa̱rila yà? Mbin nro yà ka̱ apambin nva̱ Inan ga pa̱ ô ka̱m ishi oza̱ îshi wò na ô nəm aɗin îshi wò ka̱t. U nəm iya̱m ichumchum ôza̱ ká̱ iga nɗaktak, ka̱ atak mɓak oga mbin ká̱ oga inan oza̱ ka̱ mpyal onəm ɓu ova u ka̱m ishi oza̱ îshi ɓu ka̱ aMasar á. ");
INSERT INTO yer_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","U nak oIsa̱rila chit tong onəm ɓu mbyet, kang mmaɓu, áYawe, u yà Inan oza̱. ");
INSERT INTO yer_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","<<Kang ǹyangmata̱, áYawe Inan, nəm wa nva u yar nsar nnap-nlà ka̱ apal ishi azwal ɓu ká̱ nzhizhi mbyet. Yəl ká̱ wa nva̱ ka̱ u yar chit, ");
INSERT INTO yer_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","na aɗin ɓu a rup mbyet. Te onəm i là pa̱, <UYawe uGa ngGatək uwa Inan oIsa̱rila.> Kang ɓu ga nnak nzhi azwal ɓu uDawuda i təm ka̱ mpyal ɓu. ");
INSERT INTO yer_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","<<ÁYawe uGa ngGatək, Inan oIsa̱rila, u nyám ká̱ iya̱m va̱ ta̱ chit ûzwal ɓu, u là pa̱, <Mi nak nzhi ɓu i nəm iponzhi mbyet.> A nak te, ìgwak kam ûzwal ɓu pa̱ afar afar va̱ ta̱ a ɓu. ");
INSERT INTO yer_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","ÁYawe uGa iChumchum, mmaɓu na Inan. Nsar nnap-nlà ɓu nnandər, kang u yar nsar nnap-nlà iya̱m inəna̱n va̱ ta̱ ûzwal ɓu. ");
INSERT INTO yer_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","Ǹyangmata̱ wa məma̱n te, wa pa̱r nzhi azwal ɓu na á təm ka̱ mpyal ɓu mbyet. Ka̱kul mmaɓu, uNəm Uga Nzhi uYawe ka̱ u là chit, kang ká̱ mpa̱r ɓu, nzhi azwal ɓu i pa̱r mbyet.>> ");
INSERT INTO yer_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","Ka̱ ashe ngga te, uDawuda nəm igwan ká̱ oFilisti kang uza̱ ka̱m ìtong aMetek Amma ka̱ atak oFilisti, kang uza̱ nak oza̱ tong ozwal wò. ");
INSERT INTO yer_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","UDawuda nəm igwan ká̱ oMowap kpa. Uza̱ nak oza̱ ra ka̱ mbin, kang uza̱ màl oza̱ ká̱ mmàl asang. Nza̱ mmàl nggo pa̱ mparəm te, mí gbá̱ng oza̱, kang mmàl ngga nshatɗing te, mí re ká̱ irirì. OMowap təm ozwal aDawuda kang i mwa mbwai mbin á na. ");
INSERT INTO yer_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","Ka̱ɗi te, uDawuda nəm igwan ká̱ uHadadezer uya aRehop ununggwan, uponzhi uga aZoba, ka̱ awalang va̱ uza̱ ga anung awang aYufriti pa̱ na ká̱ ô le ká̱ atak va̱ ta a yà ka̱ akum ichumchum wò á. ");
INSERT INTO yer_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","UDawuda wur oshozha oga akeke ipəri ìkalong ká̱ ìgba̱l pa̱ ifangshat, ká̱ oshozha oga nchèn ká̱ ashar ìkalong ìsəm pa̱ iparəm. Uza̱ kyèn ashar ipəri va̱ ta pa̱ kpaktak tong igùrum, kang uza̱ re ipəri iga ndap akeke ìgba̱l. ");
INSERT INTO yer_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","Awalang va̱ onəm oga aSuriya ka̱ aDimaska ɓa pa̱ na ó ka̱mshi aHadadezer uponzhi uga aZoba te, uDawuda gbá̱ng oza̱ ìkalong ìsəm pa̱ ìparəm ama̱n pa̱ parəm. ");
INSERT INTO yer_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","Uza̱ nak oga idongkong oshozha ka̱ ashe mbin aDimaska ka̱ aSuriya, te oSuriya tong ozwal aDawuda, oza̱ i mwa mbwai mbin á na. UYawe na igwan ûDawuda atak va̱ uza̱ i ga kà̱ pa̱ kpaktak á. ");
INSERT INTO yer_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","UDawuda vyat oga nggwanggwang azənariya onəm oga mpyal ìkum aHadadezer kang à ɓa ká̱ ka̱ aUrushelima. ");
INSERT INTO yer_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","Kang uza̱ wur oga acham arəzang pa̱ makmak ka̱ ashe itong aTeba ká̱ aBerotayi va ka̱ akum iponzhi aHadadezer. ");
INSERT INTO yer_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","Ka̱ nva̱ngva̱ uToyu uponzhi uga aHamat fe pa̱ uDawuda nəm igwan ká̱ nkpaktak oshozha aHadadezer chit, ");
INSERT INTO yer_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","te uza̱ re uyen wò ununggwan, uJoram ka̱ atak aPonzhi uDawuda pa̱ a re anung á na, na shep na ka̱kul igwan va̱ uza̱ nəm ka̱ apal aHadadezer uva pak inok nlung ikum chit ká̱ uToyu. UJoram ɓa ká̱ imwa oga iya̱m aazurfa ká̱ azənariya, ká̱ acham arəzang ûDawuda. ");
INSERT INTO yer_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","UPonzhi uDawuda gor oga iya̱m va̱ ta̱ pa̱ kpaktak ûYawe, wa nva uza̱ ka̱ nəm ká̱ aazurfa ká̱ azənariya va̱ uza̱ wur ka̱ atak oga mbin va̱ uza̱ ri ká̱ ìkum á. ");
INSERT INTO yer_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","Oga mbin va ta̱ uza̱ ri ká̱ ìkum, aEdom ká̱ aMowap ká̱ aAmmon ká̱ aFilisti ká̱ aAmalek. Uza̱ gor oga iya̱m va̱ uza̱ wur ka̱ atak ìkum ka̱ atak aHadadezer uya aRehop ununggwan uponzhi uga aZoba kpa. ");
INSERT INTO yer_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","Kang aɗin aDawuda dam byet, nva̱ngva̱ uza̱ le ka̱ atak ngbá̱ng onəm oga aEdom ìkalong pa̱ igba̱pchi ama̱n pa̱ na̱nne ka̱ ashe Mba̱nda̱m Mman. ");
INSERT INTO yer_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","Uza̱ nak oga idongkong oshozha ka̱ ashe nkpaktak aEdom kang nkpaktak oEdom təm ka̱ avəng aDawuda. UYawe na igwan ûDawuda ka̱ nkpaktak atak va̱ uza̱ ga kà̱. ");
INSERT INTO yer_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","UDawuda nəm iponzhi ka̱ apal nkpaktak oIsa̱rila, uza̱ nap akwali aga nnandər ka̱ apal adanggo. ");
INSERT INTO yer_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","UJowap uya aZeruya ununggwan uwa unəm uga mpyal oshozha, uJehoshafat uya aAhilut ununggwan uwa unəm uga nlir nnap nshetshet ûponzhi. ");
INSERT INTO yer_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","UZadok uya aAhitup ununggwan ká̱ uAhimelek uya aAbiyatar ununggwan oma onəm oga mpyal awop, kang uSeraya uwa unəm uga nlir iya̱m. ");
INSERT INTO yer_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","UBenaya uya aJehoyada ununggwan uwa unəm uga mpyal oKereti ká̱ oPeleti oma oshozha oga mpángchí uponzhi. Kang ovan aDawuda onunggwan tong onəm oga mpyal awop. ");
INSERT INTO yer_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","N̂da nro te, uDawuda ɓəp pa̱, <<Unəm uro uwa yà lap ka̱ ashe nzhi aShawulu pa̱ na n nyám nnap nnəna̱n á na ka̱kul aJonatan ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","Ukpari aShawulu uro uwa yà aɗiɗin pa̱ uZiba, oza̱ ɓa ka̱ na ka̱ atak aDawuda. Kang uponzhi ɓəp na pa̱, <<Mmaɓu na uZiba ɗò?>> Te uza̱ ma̱n pa̱, <<Mmami na ukpari ɓu, áponzhi.>> ");
INSERT INTO yer_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","Uponzhi ɓəp na pa̱, <<Unəm uro uwa yà lap ká̱ irirì ka̱ ashe nzhi aShawulu pa̱ na n nyám nnap nnəna̱n Inan á na ɗò?>> Te uZiba na ama̱n ûponzhi pa̱, <<Uya aJonatan ununggwan uro uwa yà, uva gurumgurum ka̱ ashar pa̱ kpaktak.>> ");
INSERT INTO yer_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","Te uponzhi ɓəp pa̱, <<Uza̱ ka̱ che yà?>> UZiba na ama̱n pa̱, <<Uwa ya ka̱ aLo Debar, ka̱ nzhi àMakir, uya aAmiyel ununggwan.>> ");
INSERT INTO yer_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","Te uPonzhi uDawuda nak pa̱ mma ga mma ɓa ká̱ na ka̱ nzhi àMakir uya aAmiyel ununggwan ka̱ aLo Debar. ");
INSERT INTO yer_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","Awalang va̱ uMefiboshet uya aJonatan ununggwan ukaka aShawulu ɓa ka̱ mpyal àDawuda te, uza̱ kuchi ka̱ mbin uza̱ na ichumchum á na. Te uDawuda là pa̱, <<ÁMefiboshet.>> Kang uza̱ na ama̱n pa̱, <<Mmami nata̱, ukpari ɓu.>> ");
INSERT INTO yer_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","Te uDawuda là á na pa̱, <<Kang ayər a nəm ɓu ka̱t, mi ga nnyám nnap nnəna̱n a ɓu ka̱kul apo ɓu uJonatan. Mi ga nna nkpaktak iram va̱ iji akaka ɓu uShawulu a ɓu, kang ɓu ri iya̱m-nrì nzəng ká̱ mi ka̱ atebəl pa̱ ɗəkər.>> ");
INSERT INTO yer_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","Te uMefiboshet kuchi ka̱ɗi, kang uza̱ là pa̱, <<Uda ukpari ɓu yà? U nyám nnap nnəna̱n á mi, mmami va pa̱ vyakshin á.>> ");
INSERT INTO yer_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Te uponzhi wór ukpari aShawulu uZiba, kang uza̱ là á na pa̱, <<N na ûkaka anəm uga nzhi ɓu chit nkpaktak iya̱m va̱ iji aShawulu ká̱ nzhizhi. ");
INSERT INTO yer_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Mmaɓu ká̱ ovan ɓu onunggwan ká̱ okpari ɓu ó wap iram á na, kang ó ɓa ká̱ iya̱m iram ûkaka anəm uga nzhi wó, na a ya iya̱m-nrì. Kang uMefiboshet, ukaka anəm uga nzhi ɓu, i ri iya̱m-nrì nzəng ká̱ mi pa̱ ɗəkər.>> UZiba ká̱ ovan onunggwan pa̱ ogba̱pchi ama̱n pa̱ tukun, kang ká̱ okpari ìsəm pa̱ ìparəm. ");
INSERT INTO yer_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","Te uZiba là ûponzhi pa̱, <<Iya̱m va̱ u là ûkpari ɓu pa̱ kpaktak te, mi nənəm, ánəm uga nzhi.>> Te uMefiboshet ri iya̱m-nrì ká̱ uponzhi pa̱ ɗəkər ka̱ atebəl, wa uzəngtəng ka̱ ashe ovan aponzhi onunggwan. ");
INSERT INTO yer_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","UMefiboshet uwa yà ká̱ uyen ununggwan uɓwakan aɗiɗin pa̱ uMika. Kang nkpaktak onəm va̱ ka̱ ashe nzhi àZiba te, tong okpari aMefiboshet. ");
INSERT INTO yer_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","UMefiboshet təm ka̱ aUrushelima ka̱kul pa̱ ɗəkər te, uza̱ i ri iya̱m-nrì ka̱ atebəl aponzhi. Uza̱ gurumgurum ka̱ nkpaktak ashar. ");
INSERT INTO yer_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","Ka̱ nva̱ngva̱ uponzhi oAmmon, uNahash kú, te uyiyen uHanun ri iponzhi apo wò. ");
INSERT INTO yer_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","Te uDawuda là pa̱, <<Mi nəm nnap nnəna̱n ûHanun uya aNahash ununggwan, wa nva upupo ka̱ nəm á mi á.>> Te uDawuda re nre ká̱ okpari wò pa̱ na á sak na ka̱kul ikú apupo. Awalang va̱ onəm oga ǹre aDawuda ga ka̱ ashe mbin oAmmon te, ");
INSERT INTO yer_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","onəm oga mpyal oAmmon là ûHanun unəm uga nzhi oza̱ pa̱, <<U rəng pa̱ uDawuda kà̱ nna ichumchum ûpo ɓu nva̱ uza̱ re onəm pa̱, á sak ɓu ka̱kul ikú apo ɓu ɗò? UDawuda re oza̱ pa̱, á ɓa á song ìtong yi, na a dər ìkam yi kang ì kpán ìtong yi ka̱t ɗò?>> ");
INSERT INTO yer_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","Te uHanun wur onəm oga ǹre àDawuda va̱ ta, uza̱ kpat nggyer adanggo ka̱ ashe oza̱ ka̱ ngba̱k kang uza̱ kyen ilukwan oza̱ kà̱ ìjili, kang a ɓàk oza̱ ga. ");
INSERT INTO yer_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","Awalang va̱ mma là iya̱m va̱ ta̱ ûDawuda, te uza̱ re onəm oga ǹre pa̱ á gwang oza̱ ka̱kul pa̱ mma na iwuswa ôza̱ byet. Uponzhi là pa̱, <<Ó təm ka̱ aJeriko ya nggyer wó á fa kang ô ɓa.>> ");
INSERT INTO yer_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","Nva̱ngva̱ onəm oga aAmmon ya pa̱ ó lak ìgwak ûDawuda chit pa̱ gənggəng te, oza̱ ga yar oshozha mbwai ka̱ aSuriya ìkalong ìsəm pa̱ ìparəm ka̱ mbin aBet Rehop ká̱ aZoba, ká̱ uponzhi uga aMaka ká̱ oshozhashozha ìkalong pa̱ ìzəng, kang ká̱ oshozha ìkalong pa̱ ìgba̱pchi ama̱n pa̱ parəm ka̱ mbin aTop. ");
INSERT INTO yer_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","UDawuda kà̱ nfe pa te, uza̱ re uJowap ká̱ nkpaktak oshozha wò pa̱ á lung oza̱. ");
INSERT INTO yer_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","OAmmon gbar izər ka̱kul ìkum fa tong ka̱ anung asa̱l aga ntar ìtong oza̱, ǹnyi te, oSuriya oga aZoba ká̱ aRehop, ká̱ onungwan oga aTop ká̱ aMaka gbar izər ìkum iji oza̱ ka̱ agbagba. ");
INSERT INTO yer_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","Awalang va̱ uJowap ya chit pa̱ onəm oga ìkum yà chit ka̱ mpyal wò ká̱ nva̱ng wò te, uza̱ yak oshozha oga ǹnyi ìkum oro ka̱ aIsa̱rila ɓa ká̱ oza̱ ka̱ atak wò na oza̱ á lung oSuriya. ");
INSERT INTO yer_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","Uza̱ nak ugənang wò uAbishayi unəm uga mpyal aɓo oshozha pa̱ na oza̱ a ga á ru oAmmon ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","UJowap là ûAbishayi pa̱, <<A yà pa̱ u ya oSuriya ka̱ nji nkàm mi te, ɓa na u ka̱mshi mi. Kang a yà pa̱ n ya oAmmon ka̱ nji nkàm ɓu ǹnyi te, mi ɓa mi ka̱mshi ɓu. ");
INSERT INTO yer_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","Nəm nkam ìgwak, kang re í tong akam ka̱kul onəm yi ká̱ oga itong Inan yi. UYawe i nəm iya̱m va̱ uza̱ ya ma ká̱ na.>> ");
INSERT INTO yer_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","Te uJowap ká̱ oshozha wò səng ga na ó lung ìkum, kang oSuriya chəng. ");
INSERT INTO yer_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","Nva̱ngva̱ oAmmon ya oSuriya kà̱ nchəng te, oza̱ chəng kpa ka̱ mpyal aAbishayi le táng ashe ìtong. Te uJowap ká̱ oshozha wò le ka̱ atak nlung oAmmon kang à ɓa aUrushelima. ");
INSERT INTO yer_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","Nva̱ngva̱ oSuriya ya chit pa̱ oIsa̱rila ri wó chit ká̱ ìkum te, oza̱ ɓut ka̱ anung zəngtəng ka̱ɗi. ");
INSERT INTO yer_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","UPonzhi uHadadezer re ǹre mma ɓa ká̱ oSuriya va̱ ka̱ nfa alum awang aYufriti. Oza̱ ga aHelam kang uShobak unəm uga mpyal oshozha aHadadezer ləp mpyal ôza̱. ");
INSERT INTO yer_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","Awalang va̱ uDawuda fe iya̱m va̱ ta̱ te, uza̱ ɓut nkpaktak oIsa̱rila, oza̱ pa̱ng agwong awang aUrdun kang oza̱ ga aHelam. OSuriya gbar izər ìkum kang oza̱ ru uDawuda ká̱ ìkum. ");
INSERT INTO yer_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","Ǹnyi te, oSuriya chəng ka̱ mpyal oIsa̱rila kang uDawuda gbá̱ng onəm oga akeke ipəri ìgba̱l pa̱ ìfangshat, ká̱ oshozha oga ashar ìkalong ìsəm pa̱ ìneɗing. Uza̱ gbá̱l uShobak unəm uga mpyal oshozha oza̱ kpa. ");
INSERT INTO yer_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","Awalang va̱ nkpaktak oponzhi va̱ ka̱ avəng aHadadezer ya chit pa̱ oIsa̱rila ri oza̱ chit ká̱ ìkum te, oza̱ gwang inal ká̱ oIsa̱rila kang oza̱ tong ozwal oza̱. Te ayər nəm oSuriya, oza̱ ka̱mshi oAmmon lap ka̱t. ");
INSERT INTO yer_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Awalang va̱ ìzun ga̱ɓa̱n chit, ka̱ ashe nra va̱ oponzhi i ga ìkum te, uDawuda re uJowap ká̱ onunggwan aponzhi ká̱ nkpaktak oshozha oIsa̱rila pa̱ á ga a lung oAmmon. Te oza̱ ga zhì oAmmon kang oza̱ ra anyimnyal gáng ìtong iga aRaba. Ǹnyi te, uDawuda uwa yà ka̱ aUrushelima. ");
INSERT INTO yer_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","N̂da nro ka̱ arurong te, uDawuda wong ka̱ atak njul ka̱ apal iya̱m nra kang uza̱ ka̱ nchen ka̱ apal nzhi iponzhi. Ka̱ apal nzhi nva̱ ta te, uza̱ ya uchar uro ka̱ ngwór izər. Uchar va̱ ta ɓyen byet, ");
INSERT INTO yer_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","kang uDawuda re unəm uro pa̱ á gbap uchar va̱ ta á wò. Unəm va̱ ta là á na pa̱, <<Uza̱ uBatsheba, uya aEliyam uchar, uchar aUriya unəm oHiti.>> ");
INSERT INTO yer_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Te uDawuda re onəm oga ǹre ga ɓa ká̱ na. Uchar va̱ ta ɓa atətak kang uza̱ ra ká̱ na. Te uchar va̱ ta le ga nzhi. Uza̱ wa gba̱l akpar ka̱ ǹyang, kang uza̱ gba̱l ká̱ nnàl izər ka̱ atak akpar wa nva oIsa̱rila i nəm á. ");
INSERT INTO yer_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Ka̱ nvəva̱ng te, uBatsheba təm ka̱ anyám, kang à re ǹre ûDawuda pa̱, <<Mmami ká̱ izər pa̱ iparəm.>> ");
INSERT INTO yer_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Te uDawuda re ǹre ûJowap pa̱, <<Re ǹre á mi ká̱ uUriya uHiti.>> Te uJowap re ǹre ûDawuda ká̱ uUriya. ");
INSERT INTO yer_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Awalang va̱ uUriya ɓa atətak te, uDawuda ɓəp ikángkáng aJowap ká̱ iji oshozha ká̱ asa̱l awu va̱ ìkum ka̱ ngga ká̱. ");
INSERT INTO yer_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Te uDawuda là ûUriya pa̱, <<Fa ga nzhi ɓu na u nàl ashar na u jul.>> Te, uUriya fa ka̱ ashe nzhi aponzhi, kang uponzhi re ǹre á na ká̱ imwa iya̱m-nrì ka̱ nva̱ng. ");
INSERT INTO yer_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Ǹnyi te, uUriya ga nzhi wò ka̱t, uza̱ ra nzəng ká̱ onəm oga mpángchí uponzhi ka̱ anung nkəlang àponzhi. ");
INSERT INTO yer_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Mma là ûDawuda pa̱, <<UUriya ga nzhi ka̱t.>> Te uDawuda wór na ɓəp na pa̱, <<Nna u le ka̱ chen ta̱, te sang kang u ga nzhi ka̱t yà?>> ");
INSERT INTO yer_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","UUriya na ama̱n pa̱, <<Akwati aga nsar nnap-nlà ká̱ oshozha oIsa̱rila ká̱ oga aYahuda oma kà̱ nra ka̱ ashe oga aghal, kang unəm uga mpyal mi uJowap ká̱ oshozha anəm uga nzhi mi, oma ra apa̱k ka̱ agbagba. Mi yar sang kang mi ga nzhi mi, pa̱ na n ri, n ngwa, n nra ká̱ uchar mi yà? Ká̱ nva̱ nna u yà ká̱ irirì te, mi yà ka̱ nnəm apir nnap wa nva̱ ta ka̱t.>> ");
INSERT INTO yer_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Te uDawuda là ûUriya pa̱, <<Ra ka̱ta̱ nda ká̱ ipin ikpa̱kkpa̱k kà̱ɗi, te mi re ɓu ɓu le.>> Te uUriya ra ka̱ aUrushelima wa nva̱ uponzhi là á. ");
INSERT INTO yer_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","UDawuda chal na ka̱ nri iya̱m-nrì kang à nak na wa nchè kang nchè gba̱l na. Ǹnyi te, atak la te, uUriya ga nzhi ka̱ atak achar wò ka̱t. Uza̱ ra ka̱ apal ndakal wò nzəng ká̱ okpari aponzhi. ");
INSERT INTO yer_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Ka̱ iɓotak te uponzhi lir iya̱m na ûUriya pa̱ a ga a na ûJowap. ");
INSERT INTO yer_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Ka̱ ashe nlir va̱ ta te, uza̱ lir ûJowap pa̱, <<Nak uUriya ka̱ mpyal ìkum, ka̱ atak va ìkum sur ka̱ pa̱ gənggəng. Te ó le ga nva̱ng o re na ká̱ nkukwa na mmá gba̱l na.>> ");
INSERT INTO yer_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Nva̱ uJowap kà̱ nra anyimnyal gáng ìtong va̱ ta te, uza̱ nak uUriya ka̱ atak va onunggwan okpa ìkum oza̱ kà̱. ");
INSERT INTO yer_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Awalang va̱ oshozha okpa ìkum fa pa̱ ó lung ìkum te, mmá gba̱l uUriya unəm oHiti nzəng ká̱ onəm oga mpyal oshozha oIsa̱rila oro. ");
INSERT INTO yer_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","UJowap re ǹre mmá là ûDawuda nkpaktak iya̱m va̱ mmá nəm ka̱ atak ìkum. ");
INSERT INTO yer_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","Uza̱ là ûnəm uga nre va̱ uza̱ re pa̱, <<Awalang va̱ wa gbá̱l ká̱ nshal nkpaktak nnap ìkum va̱ ta̱ ûponzhi chit te, ");
INSERT INTO yer_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","ɗom te ìgwak i lak uponzhi kang uza̱ i ɓəp pa̱,<Sang kang o lung ìkum o ga o dat ká̱ ìtong yà? O nyi pa̱ oza̱ i sat ka̱ apal akamsəlang ìtong kang i tat iwar ka̱t ɗò? ");
INSERT INTO yer_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","Uda ka̱ gba̱l uAbimelek uya aJerubeshet ununggwan yà? Uchar wa ka̱ mang na ká̱ awo ako ka̱ izər akamsəlang ká̱ aTebet uza̱ kú ka̱t ɗò?> A yà pa̱ uza̱ a ɓəp ɓu pa̱, <Sang kang ó ga datkulung ká̱ izər akamsəlang yà?> Te wa là á na pa̱, <Mmá gba̱l ukpari ɓu uUriya unəm oHiti kpa.> >> ");
INSERT INTO yer_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Te unəm uga nre fa ga, kang awalang va̱ uza̱ chu te a là ûDawuda nkpaktak nnap va̱ uJowap re na pa̱ a là a na á. ");
INSERT INTO yer_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","Unəm uga nre va̱ ta là ûDawuda pa̱, <<Okpa ìkum yi ji nkam yi, fa i lung yi ka̱ agbagba, ǹnyi te, í ɓàk oza̱ le ga anung asa̱l ìtong. ");
INSERT INTO yer_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Te onəm oga iwar tong ka̱ apal akamsəlang i tat yi, kang onəm oga mpyal oshozha ɓu oro kú. Ka̱ɗi te, mmá gbá̱l ukpari ɓu uUriya unəm oHiti.>> ");
INSERT INTO yer_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","UDawuda là ûnəm uga nre va̱ ta pa̱, <<Là ûJowap pa̱, <Kang ìchəgwak a ləp ɓu ka̱t, ndokchi i yak onəm yak ka̱t. Ó lung pa̱ gənggəng na ó ri ìtong va̱ ta.> Là a na, na a kám irəng a na.>> ");
INSERT INTO yer_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Awalang va̱ uBatsheba uchar aUriya fe pa̱ uɓar wò kú chit te, uza̱ yə́ng ikuku. ");
INSERT INTO yer_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Nva̱ngva̱ nra nyə́ng ikú watar te, uDawuda re ǹre mmá ɓa ka̱ na ka̱ ashe nzhi wò, uza̱ nyang uchəchar kang a mar uyen nunggwan á na. Ǹnyi te, uYawe fe nchang iya̱m va̱ uDawuda nəm ka̱t. ");
INSERT INTO yer_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","UYawe re uNatan unəm uga nlà ichu Inan ka̱ atak aDawuda. Awalang va̱ uza̱ ɓa atətak te, uza̱ là a na pa̱, <<Onəm oro mmá ka̱ yà pa̱ oparəm ka̱ ashe ìtong iro. Uro unəm uga ìdur kang uro unəm uga nkun. ");
INSERT INTO yer_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Unəm uga idur va̱ ta uwa yà ká̱ itam ká̱ ina pa̱ makmak, ");
INSERT INTO yer_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","ǹnyi te, unəm uga nkun va̱ ta yà ká̱ iya̱m iro ka̱t, iya ìtam pa̱ izəng ya byet va uza̱ yáp. Uza̱ kang à rup nzəng ka̱ ovəvan. I ri iya̱m nzəng ka̱ na, kang i wa ka̱ ashe ikpəkpang iga ngwa ndəng, oza̱ i ra nzəng. A sat a na wa ayiyen uchar. ");
INSERT INTO yer_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","<<N̂da nro te, unəm uga ndur va̱ ta ya unəmchən te, ka̱ɗor nva̱ pa̱ uza̱ á gbá̱l ìtam ka̱t te ìna ka̱ ashe iya̱m nkang wò te, uza̱ ga kpan ija anəm uga nkun va̱ ta gbá̱l nəm iya̱m-nrì ûnəmchən wò va̱ ta ká̱.>> ");
INSERT INTO yer_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","A ra̱m uDawuda pa̱ gənggəng kang uza̱ là ûNatan pa̱, <<N sóng anung ká̱ aɗin aYawe, unəm va̱ nəm nnap nva̱ ta̱ te nkpak pa̱ uza̱ á kú. ");
INSERT INTO yer_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Uza̱ i mwa ìtam va̱ ta nva̱ng pa̱ ineɗing, ka̱kul iya̱m va̱ uza̱ nəm ta, ka̱ atak nyà ká̱ aɗor ka̱t á.>> ");
INSERT INTO yer_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Te uNatan là ûDawuda pa̱, <<Mmaɓu na unəm va̱ ta. Iya̱m va ta̱ uYawe, Inan oIsa̱rila là,<N gar ɓu uponzhi ka̱ apal oIsa̱rila kang m fa ká̱ ɓu ka̱ ashe awo uShawulu. ");
INSERT INTO yer_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","N na nzhi ànəm uga nzhi ɓu, ká̱ ochəchar. N na nkpaktak oIsa̱rila ká̱ oYahuda a ɓu. Kang ká̱ yà pa̱ iya̱m va̱ ta a yiyen ká̱ ɓu te, ká̱ n na iro a ɓu ká̱ jiji. ");
INSERT INTO yer_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Iza̱ nak kang u ɓak nnap-nlà àYawe, kang u nəm iya̱m iɓá̱ngɓa̱ng va̱ ta̱ ka̱ mpipyal yà? U gbá̱l uUriya unəm oHiti ká̱ ndokchi kang u ka̱m uchəchar sat uji ɓu. U gbá̱l na ká̱ ndokchi oAmmon. ");
INSERT INTO yer_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Ka̱kul nva̱ ta te, ndokchi i kap ká̱ nzhi ɓu ka̱t, ka̱kul u ɓak mi, kang u ka̱m uchar aUriya unəm oHiti ta̱l uji ɓu.> ");
INSERT INTO yer_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","<<Iya̱m va ta̱ uYawe là, <Dər, mi ga mɓa ká̱ nɗaktak ka̱ ashe nzhi ɓu. Kà̱ mpyal ɓu mi ga ngwur ochar ɓu mi na ûnəm uro uva dat ká̱ ɓu, kang i ra ká̱ oza̱ ká̱ alum pa̱ agbagba. ");
INSERT INTO yer_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Ka̱ u nəm ka̱ ayi, ǹnyi te, mi ga nnəm iya̱m va̱ ta̱ ká̱ alum pa̱ agbagba ka̱ mpyal nkpaktak oIsa̱rila.> >> ");
INSERT INTO yer_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Te uDawuda là ûNatan pa̱, 