﻿USE sofia;
DROP TABLE IF EXISTS sofia.ydd_vpl;
CREATE TABLE ydd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ydd_vpl WRITE;
INSERT INTO ydd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","דאס בוך פונם שטאמבוים פון יהושע/ישוע המשיחן, דעם זון פון דוד, דעם זון פון אברהם. ");
INSERT INTO ydd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","אברהם האט געבוירן יצחקן, און יצחק האט געבוירן יעקבן, און יעקב האט געבוירן יהודהן און זיינע ברידער. ");
INSERT INTO ydd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","און יהודה האט געבוירן פרצן און זרחן פון תמר. און פרץ האט געבוירן חצרון, און חצרון האט געבוירן רם. ");
INSERT INTO ydd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","און רם האט געבוירן עמינדבן, און עמינדב האט געבוירן נחשון, און נחשון האט געבוירן שלמון, ");
INSERT INTO ydd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","און שלמון האט געבוירן בועזן פון רחב, און בועז האט געבוירן עובדן פון רות, און עובד האט געבוירן ישי, ");
INSERT INTO ydd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","און ישי האט געבוירן דוד המלך. און דוד האט געבוירן שלמהן פון אוריהס ווייב, ");
INSERT INTO ydd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","און שלמה האט געבוירן רחבעם, און רחבעם האט געבוירן אביה, און אביה האט געבוירן אסא, ");
INSERT INTO ydd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","און אסא האט געבוירן יהושפטן, און יהושפט האט געבוירן יורם, און יורם האט געבוירן עזיהו, ");
INSERT INTO ydd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","און עזיהו האט געבוירן יותם, און יותם האט געבוירן אחזן, און אחז האט געבוירן יחזקיהון, ");
INSERT INTO ydd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","און יחזקיהו האט געבוירן מנשהן, און מנשה האט געבוירן אמון, און אמון האט געבוירן יאשיהו, ");
INSERT INTO ydd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","און יאשיהו האט געבוירן יכניהו און זיינע ברידער, צו דער צייט פונם גלות בבל. ");
INSERT INTO ydd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","און נאך דער פארטרייבונג קיין בבל האט יכניהו געבוירן שאלתיאלן, און שאלתיאל האט געבוירן זרובבלען, ");
INSERT INTO ydd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","און זרובבל האט געבוירן אביהודן, און אביהוד האט געבוירן אליקים, און אליקים האט געבוירן עזורן, ");
INSERT INTO ydd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","און עזור האט געבוירן צדוקן, און צדוק האט געבוירן יכין, און יכין האט געבוירן אליהודן, ");
INSERT INTO ydd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","און אליהוד האט געבוירן אלעזרן, און אלעזר האט געבוירן מתן, און מתן האט געבוירן יעקבן, ");
INSERT INTO ydd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","און יעקב האט געבוירן יוספן, דעם מאן פון מרים, פון וועלכער עס איז געבוירן געווארן יהושע/ישוע, וואס ווערט גערופן משיח. ");
INSERT INTO ydd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","און אזוי זענען אלע דורות פון אברהם ביז דוד פערצן דורות; און פון דוד ביז צום גלות בבל פערצן דורות; און פונם גלות בבל ביז צו דעם משיח פערצן דורות. ");
INSERT INTO ydd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","און די געבורט פון יהושע/ישוע המשיחן איז פארגעקומען אויף אזא אופן: ווען זיין מוטער מרים איז געווען פארקנסט צו יוספן, איידער זיי זענען זיך צוזאמענגעקומען, איז זי געפונען געווארן מעוברת פונם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","יוסף, איר מאן, איז אבער געווען א צדיק, און האט איר נישט געוואלט אנטון קיין חרפה, האט ער בדעה געהאט, שטילערהייט מיט איר זיך פאנאנדערצוגיין. ");
INSERT INTO ydd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","און טראכטנדיק אזוי וועגן דעם, זע, א מלאך פון דעם האר (ה׳) האט זיך באוויזן צו אים אין א חלום, אזוי צו זאגן: יוסף בן דוד, פארכט דיך נישט צו נעמען מרים, דיין ווייב; מחמת דאס, וואס איז אין איר געשאפן געווארן, איז פונם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","און זי וועט געבוירן א זון, און דו זאלסט רופן זיין נאמען יהושע/ישוע; מחמת ער וועט ראטעווען זיין פאלק פון זייערע זינד. ");
INSERT INTO ydd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","און דאס אלץ איז געשען, כדי עס זאל דערפילט ווערן, וואס עס איז געזאגט געווארן פון דעם האר (ה׳) דורך דעם נביא, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","זע די עלמה וועט פארגיין אין טראגן, און געבוירן א זון, און מען וועט רופן זיין נאמען עמנואל, (ישעיהו ז, יד.) וואס דער טייטש דערפון איז: ה׳ מיט אונדז. ");
INSERT INTO ydd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","און ווען יוסף איז אויפגעשטאנען פון שלאף, האט ער געטאן, ווי דער מלאך פון דעם האר (ג‑ט) האט אים באפוילן, און ער האט גענומען צו זיך זיין ווייב; ");
INSERT INTO ydd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","און האט זיך מיט איר נישט באהאפטן, ביז זי האט געבוירן א זון, און ער האט גערופן זיין נאמען יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","און ווען יהושע/ישוע איז געבוירן געווארן אין בית‑לחם יהודה, אין די טעג פון קעניג הורדוס, זע, שטערנזעער פונם מזרח זענען אנגעקומען קיין ירושלים, ");
INSERT INTO ydd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","און האבן געזאגט: וואו איז ער, וואס איז געבוירן געווארן, דער מלך פון די יידן? מחמת מיר האבן געזען זיין שטערן אויפן מזרח, און זענען געקומען, זיך צו בוקן צו אים. ");
INSERT INTO ydd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","און ווי דער קעניג הורדוס האט דאס געהערט, האט ער זיך דערשראקן און גאנץ ירושלים מיט אים. ");
INSERT INTO ydd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","און איינזאמלענדיק אלע הויפט כהנים און סופרים פונם פאלק, האט ער זיי געפרעגט, וואו דער משיח דארף געבוירן ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","און זיי האבן צו אים געזאגט: אין בית‑לחם יהודה; מחמת אזוי איז געשריבן געווארן דורך דעם נביא. ");
INSERT INTO ydd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","און דו בית‑לחם, לאנד יהודה, ביסט בשום אופן נישט דאס קלענסטע צווישן די פרינצן פון יהודה; מחמת פון דיר וועט ארויסקומען א מושל, וואס וועט פיטערן מיין פאלק ישראל! ");
INSERT INTO ydd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","דערנאך האט הורדוס שטילערהייט גערופן די שטערנזעער, און גרינטלעך אויסגעפארשט ביי זיי די צייט, ווען דער שטערן האט זיך באוויזן. ");
INSERT INTO ydd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","און ער האט זיי געשיקט קיין בית‑לחם, און געזאגט: גייט און פארשט נאך גענוי וועגן דעם קינד; און ווען איר וועט עס געפינען, דערציילט מיר, כדי איך זאל אויך קומען און מיך בוקן צו אים. ");
INSERT INTO ydd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","און זיי, האבנדיק געהערט דעם קעניג, האבן זיך געווענדט אויף זייער וועג; און זע, דער שטערן, וועלכן זיי האבן געזען אויפן מזרח, איז געגאנגען פאר זיי, ביז ער איז געקומען און זיך געשטעלט איבער דעם ארט, וואו דאס קינד איז געווען. ");
INSERT INTO ydd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","און זעענדיק דעם שטערן, האבן זיי זיך געפריידט מיט א זייער גרויסער שמחה. ");
INSERT INTO ydd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","און זענען אריינגעגאנגען אין הויז און האבן געזען דאס קינד מיט מרים, זיין מוטער; און זענען אנידערגעפאלן און האבן זיך געבוקט צו אים; און האבן אויפגעעפנט זייערע אוצרות און אים געברענגט מתנות, גאלד און וויירויך און מירע. ");
INSERT INTO ydd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","און ווערנדיק געווארנט אין א חלום, זיך נישט אומצוקערן צו הורדוסן, זענען זיי אוועק אויף אן אנדערן וועג אין זייער אייגן לאנד אריין. ");
INSERT INTO ydd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","און נאך זייער אוועקגיין, זע, א מלאך פון דעם האר (ג‑ט) באווייזט זיך צו יוספן אין א חלום, אזוי צו זאגן: שטיי אויף און נעם דאס קינד און זיין מוטער, און אנטלויף קיין מצרים, און זיי דארטן, ביז איך וועל דיר זאגן; מחמת הורדוס וועט זוכן דאס קינד, כדי עס אומצוברענגען. ");
INSERT INTO ydd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","און ער איז אויפגעשטאנען און האט גענומען דאס קינד און זיין מוטער ביינאכט, און איז אוועק קיין מצרים. ");
INSERT INTO ydd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","און איז דארט געווען ביז הורדוס איז געשטארבן, כדי עס זאל דערפילט ווערן, וואס עס איז געזאגט געווארן פון דעם האר דורך דעם נביא, אזוי צו זאגן: פון מצרים האב איך גערופן מיין זון. ");
INSERT INTO ydd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","דעמאלט האט הורדוס געזען, אז ער איז געווארן אפגעשפאט פון די שטערנזעער, איז ער געווארן שרעקלעך צארנדיק, און האט געשיקט, און געלאזט טייטן אלע יינגלעך, וואס זענען געווען אין בית‑לחם און אין אלע אירע געגנטן, פון צוויי יאר און יונגער, לויט דער צייט, וואס ער האט גענוי אויסגעפונען פון די שטערנזעער. ");
INSERT INTO ydd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","דעמאלט איז דערפילט געווארן, וואס עס איז געזאגט געווארן דורך ירמיהו הנביא, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","א קול איז געהערט געווארן אין רמה, א געוויין און ביטער באקלאגן, רחל באוויינט אירע קינדער; און וויל נישט געטרייסט ווערן, ווייל זיי זענען מער נישט פאראן. ");
INSERT INTO ydd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ווען אבער הורדוס איז שוין געווען טויט, זע, א מלאך פון דעם האר (ג‑ט) באווייזט זיך אין א חלום צו יוספן אין מצרים, ");
INSERT INTO ydd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","און זאגט: שטיי אויף און נעם דאס קינד און זיין מוטער, און גיי קיין ארץ ישראל; מחמת עס זענען שוין געשטארבן די, וואס האבן געזוכט דאס לעבן פון דעם קינד. ");
INSERT INTO ydd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","און ער איז אויפגעשטאנען און האט גענומען דאס קינד און זיין מוטער, און איז געקומען קיין ארץ ישראל. ");
INSERT INTO ydd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","נאר הערנדיק, אז ארכעלאוס קעניגט איבער יהודה אויפן ארט פון זיין פאטער הורדוס, האט ער זיך געפארכטן דארט אהינצוגיין; און נאך דעם ווי ער איז געווארנט געווארן אין א חלום, איז ער אוועק אין די מקומות פון גליל, ");
INSERT INTO ydd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","און איז געקומען און האט געוואוינט אין א שטאט, וואס מען רופט זי נצרת, כדי עס זאל דערפילט ווערן, וואס עס איז געזאגט געווארן דורך די נביאים, אז ער וועט גערופן ווערן נצר. (ישעיהו יא, א.) ");
INSERT INTO ydd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","אין יענע טעג קומט יוחנן פון דער (ירדן) מקווה, און רופט אויס אין דער מדבר פון יהודה, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","טוט תשובה; מחמת דאס מלכות השמים האט זיך דערנענטערט. ");
INSERT INTO ydd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","מחמת דאס איז ער, פון וועמען עס איז גערעדט געווארן דורך ישעיה הנביא, אזוי צו זאגן: א קול פון איינעם, וואס רופט אויס אין דער מדבר: מאכט גרייט דעם וועג פון דעם האר (ג‑ט), מאכט גלייך זיינע שטעגן! ");
INSERT INTO ydd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","און יוחנן אליין האט געהאט א מלבוש פון קעמל האר, און א לעדערנער גארטל ארום זיינע לענדן; און זיין שפייז איז געווען היישעריקן און ווילדער האניק. ");
INSERT INTO ydd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","דעמאלט איז צו אים ארויסגעגאנגען ירושלים, און גאנץ יהודה, און די גאנצע אומגעגנט פון ירדן; ");
INSERT INTO ydd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","און האבן זיך געלאזט טובל זיין אין דער מקווה פון אים אין דעם טייך ירדן, מתוודה זייענדיק זיך אויף זייערע זינד. ");
INSERT INTO ydd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ווען אבער ער האט געזען א סך פון די פרושים און פון די צדוקים קומען צו דער מקווה, האט ער צו זיי געזאגט: איר שלאנגענקינדער, ווער האט אייך געגעבן צו פארשטיין, אז איר זאלט אנטלויפן פון דעם קומענדיקן גרימצארן? ");
INSERT INTO ydd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ברענגט דעריבער פרוכט, וואס איז ראוי ביי תשובה! ");
INSERT INTO ydd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","און זאל אייך נישט קומען אויף די געדאנקען צו זאגן: מיר האבן אברהם ווי אונדזער פאטער (זכות‑אבות); מחמת איך זאג אייך, אז ה׳ איז בכוח פון די דאזיקע שטיינער אויפצושטעלן קינדער צו אברהמען. ");
INSERT INTO ydd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","און די האק ליגט שוין ביים שורש פון די ביימער; דעריבער יעדער בוים, וואס ברענגט נישט קיין גוטע פירות, ווערט אפגעהאקט, און געווארפן אין פייער אריין. ");
INSERT INTO ydd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","איך טובל אייך אין א מקווה מיט וואסער צו תשובה; אבער דער, וואס קומט נאך מיר, איז שטארקער פון מיר, וואס איך בין נישט ווערט צו טראגן זיינע שיך; ער וועט אייך טובל זיין אין א מקווה מיט דעם רוח הקודש און מיט פייער. ");
INSERT INTO ydd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","זיין ווינטשויפל איז אין זיין האנט, און ער וועט גוט אויסרייניקן זיין דרעשעריי; און ער וועט איינזאמלען זיין ווייץ אין שייער אריין, אבער די פלעווע וועט ער פארברענען אין פייער, וואס לעשט זיך נישט אויס. ");
INSERT INTO ydd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","דעמאלט קומט יהושע/ישוע פון גליל צום ירדן צו יוחנן, כדי מקווה געטובלט צו ווערן אין א מקווה פון אים. ");
INSERT INTO ydd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ער אבער האט עס אים פארווערט, זאגנדיק: איך האב נייטיק פון דיר געטובלט צו ווערן אין א מקווה, און דו קומסט צו מיר? ");
INSERT INTO ydd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","נאר יהושע/ישוע האט ענטפערנדיק צו אים געזאגט: לאז עס איצט צו; מחמת אזוי געשיקט זיך פאר אונדז מקיים צו זיין יעדע גערעכטיקייט. דעמאלט האט ער אים געלאזט. ");
INSERT INTO ydd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ווי יהושע/ישוע איז געטובלט געווארן אין א מקווה, איז ער באלד ארויסגעשטיגן פון וואסער; און זע, די הימלען האבן זיך אויפגעעפנט, און ער האט געזען ה׳ס גייסט אראפנידערן ווי א טויב, און קומען אויף אים; ");
INSERT INTO ydd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","און זע, א קול פון הימל האט געזאגט: דאס איז מיין געליבטער זון, אין וועמען איך האב א וואוילגעפעלן! ");
INSERT INTO ydd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","דעמאלט איז יהושע/ישוע געפירט געווארן פון דעם גייסט אין דער מדבר אריין, כדי דער שׂטן זאל אים אויספרואוון. ");
INSERT INTO ydd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","און פאסטנדיק פערציק טעג און פערציק נעכט, איז ער דערנאך הונגעריק געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","און דער אויספרואווער איז צוגעקומען און האט צו אים געזאגט: אויב דו ביסט דער זון פון דער אויבערשטער, זאג, אז די דאזיקע שטיינער זאלן ווערן ברויט! ");
INSERT INTO ydd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ער אבער האט ענטפערנדיק געזאגט: עס שטייט געשריבן: נישט פון ברויט אליין זאל דער מענטש לעבן, נאר פון יעדן ווארט, וואס קומט ארויס פון ה׳ס מויל. ");
INSERT INTO ydd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","דעמאלט נעמט אים דער שׂטן אין דער הייליקער שטאט אריין; און האט אים געשטעלט אויפן שפיץ פון בית המקדש, ");
INSERT INTO ydd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","און זאגט צו אים: אויב דו ביסט דער זון פון דער אויבערשטער, ווארף דיך אראפ; מחמת עס שטייט געשריבן: זיינע מלאכים וועט ער באפעלן וועגן דיר, און אויף די הענט וועלן זיי דיך טראגן, טאמער וועסטו דיר אנשטויסן דיין פוס אין א שטיין. ");
INSERT INTO ydd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","האט יהושע/ישוע צו אים געזאגט: עס שטייט אויך געשריבן: דו זאלסט נישט אויספרואוון דעם האר, דיין ג‑ט. ");
INSERT INTO ydd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","נאכאמאל נעמט אים דער שׂטן מיט אויף א זייער הויכן בארג, און ווייזט אים אלע קעניגרייכן פון דער וועלט, און זייער הערלעכקייט; ");
INSERT INTO ydd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","און זאגט צו אים: אלע די דאזיקע וועל איך דיר געבן, אויב דו וועסט אנידערפאלן און זיך בוקן צו מיר. ");
INSERT INTO ydd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","דעמאלט זאגט יהושע/ישוע צו אים: אוועק, דו שׂטן! מחמת עס שטייט געשריבן: צום האר, דיין ג‑ט, זאלסטו זיך בוקן און נאר אים אליין זאלסטו דינען! ");
INSERT INTO ydd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","דעמאלט פארלאזט אים דער שׂטן; און זע, מלאכים זענען געקומען און האבן אים באדינט. ");
INSERT INTO ydd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","און ווען ער האט געהערט, אז יוחנן איז איינגעזעצט געווארן, איז ער אוועק קיין גליל; ");
INSERT INTO ydd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","און האט פארלאזט נצרת, און איז געקומען און האט געוואוינט אין כפר‑נחום, וואס ליגט ביים ים, אין די געביטן פון זבולון און נפתלי; ");
INSERT INTO ydd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","כדי עס זאל דערפילט ווערן, וואס עס איז געזאגט געווארן דורך ישעיהו הנביא, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","לאנד פון זבולון און לאנד פון נפתלי, ביים וועג פונם ים, פון יענער זייט ירדן, גליל פון די פעלקער, ");
INSERT INTO ydd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","דאס פאלק, וואס איז געזעסן אין דער פינסטער, האט געזען א גרויס ליכט, און צו די, וואס זענען געזעסן אין א לאנד און אין שאטן פון טויט, פאר זיי האט א ליכט אויפגעשיינט. ");
INSERT INTO ydd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","פון דעמאלט אָן האט יהושע/ישוע אנגעהויבן אויסצורופן, און צו זאגן: טוט תשובה; מחמת דאס מלכות השמים האט זיך דערנענטערט! ");
INSERT INTO ydd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","און ווי ער איז ארומגעגאנגען ביים ים פון גליל, האט ער געזען צוויי ברידער, שמעון, וואס מען רופט אים פעטרוס, און אנדריי זיין ברודער, ווארפן א נעץ אין ים אריין; מחמת זיי זענען געווען פישערלייט. ");
INSERT INTO ydd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","און ער זאגט צו זיי: קומט, פאלגט מיר נאך, און איך וועל אייך מאכן פאר פישערס פון מענטשן! ");
INSERT INTO ydd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","און זיי האבן גלייך פארלאזן די נעצן, און האבן אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","און ווען ער איז פון דארטן ווייטערגעגאנגען, האט ער געזען אנדערע צוויי ברידער, יעקב בן זבדי, און יוחנן זיין ברודער, אין דעם שיפל מיט זייער פאטער זבדי, פארריכטנדיק זייערע נעצן; און ער האט זיי גערופן. ");
INSERT INTO ydd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","און זיי האבן גלייך פארלאזן דאס שיפל און דעם פאטער זייערן, און האבן אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","און ער איז ארומגעגאנגען אין גאנץ גליל, לערנענדיק אין זייערע שולן, און אויסרופנדיק די גוטע בשורה פונם מלכות, און היילנדיק אלע קראנקייטן און שלאפקייטן צווישן דעם פאלק. ");
INSERT INTO ydd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","און זיין שם האט זיך פארשפרייט אין גאנץ סיריען; און מען האט געברענגט צו אים אלע קראנקע, וואס זענען געווען געפלאגט מיט פארשיידענע מחלות און יסורים, באזעסענע מיט בייזע גייסטער, און חולי‑נופל, און פאראליטיקער; און ער האט זיי געהיילט; ");
INSERT INTO ydd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","און עס האבן אים נאכגעפאלגט גרויסע המונים מענטשן פון גליל און דעקאפאליס און ירושלים און יהודה און פון עבר הירדן. ");
INSERT INTO ydd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","און זעענדיק די המונים מענטשן, איז ער ארויפגעגאנגען אויף דעם בארג; און ווען ער האט זיך אנידערגעזעצט זענען זיינע תלמידים געקומען צו אים. ");
INSERT INTO ydd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","און ער האט אויפגעעפנט זיין מויל און זיי געלערנט, זאגנדיק: ");
INSERT INTO ydd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","וואויל איז די ארעמע אין גייסט; ווייל זייערס איז דאס מלכות השמים. ");
INSERT INTO ydd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","וואויל איז די טרויערנדיקע; ווייל זיי וועלן געטרייסט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","וואויל איז די, וואס האלטן זיך קליין; ווייל זיי וועלן ירשענען די ערד. ");
INSERT INTO ydd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","וואויל איז די, וואס הונגערן און דורשטן נאך גערעכטיקייט; ווייל זיי וועלן געזעטיקט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","וואויל איז די בעלי רחמים; ווייל זיי וועלן דערלאנגען בארמהארציקייט. ");
INSERT INTO ydd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","וואויל איז די, וואס זענען ריין אין הארצן; ווייל זיי וועלן זען ה׳. ");
INSERT INTO ydd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","וואויל איז די, וואס מאכן שלום; ווייל זיי וועלן גערופן ווערן ה׳ס קינדער. ");
INSERT INTO ydd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","וואויל איז די, וואס ווערן פארפאלגט צוליב גערעכטיקייט; ווייל דאס מלכות השמים איז זייערס. ");
INSERT INTO ydd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","וואויל איז אייך, ווען מען טוט אייך אָן בזיונות, און מען פארפאלגט אייך, און מען רעדט אויס פאלש אלדאס בייז אויף אייך, צוליב מיר. ");
INSERT INTO ydd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","פריידט זיך, און זייט זיך זייער משמח, ווייל אייער שכר איז גרויס אין הימל; מחמת אָט אזוי האט מען פארפאלגט די נביאים, וואס זענען געווען פאר אייך. ");
INSERT INTO ydd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","איר זענט דאס זאלץ פון דער ערד; אויב אבער דאס זאלץ זאל פארלירן זיין טעם, מיט וואס וועט עס געזאלצן ווערן? עס טויג מער צו גארנישט, אחוץ ארויסגעווארפן און פון לייטן געטרעטן צו ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","איר זענט דאס ליכט פון דער וועלט. א שטאט, וואס ליגט אויף א בארג, קען נישט בלייבן פארבארגן. ");
INSERT INTO ydd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","מען ליכטבענטשן אויך נישט אויף א ליכט, און שטעלט עס אונטער דעם מאסשעפל, נאר אויף דעם לייכטער; און עס לויכט אלעמען אין הויז. ");
INSERT INTO ydd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","אָט אזוי זאל אייער ליכט שיינען פאר מענטשן, כדי זיי זאלן זען אייערע מעשים טובים, און אפגעבן א לויב צו אייער פאטער, וואס איז אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","איר זאלט נישט מיינען, אז איך בין געקומען צו צעשטערן די תורה אדער די נביאים; איך בין נישט געקומען צו צעשטערן, נאר ממלא צו זיין. ");
INSERT INTO ydd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","מחמת באמת זאג איך אייך, ביז דער הימל און די ערד וועלן פארגיין, וועט קיין איין יוד, אדער א קוצי של יוד פון דער תורה נישט בטל ווערן, ביז אלץ איז געשען. ");
INSERT INTO ydd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","דעריבער ווער עס וועט צעשטערן איינע פון די דאזיקע קלענסטע מצוות, און וועט אָט אזוי לערנען די מענטשן, דער וועט הייסן קלענסטער אין דעם מלכות השמים; ווער אבער עס וועט זיי טאן און לערנען, דער וועט הייסן גרויס אינם מלכות השמים. ");
INSERT INTO ydd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","מחמת איך זאג אייך, אז אויב אייער צדקות וועט נישט איבערשטייגן די צדקות פון די סופרים און די פרושים, וועט איר בשום אופן נישט אריינגיין אינם מלכות השמים. ");
INSERT INTO ydd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","איר האט געהערט, אז עס איז געזאגט געווארן צו די קדמונים: דו זאלסט נישט טייטן; ווער אבער עס טייט, איז חייב צום משפט. ");
INSERT INTO ydd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","איך אבער זאג אייך, אז יעדער איינער, וואס איז צארנדיק אויף זיין ברודער, וועט זיין חייב צום משפט; און ווער עס וועט זאגן רקא צו זיין ברודער, וועט זיין חייב צום סנהדרין; און ווער עס וועט זאגן, דו נאר, וועט זיין חייב צום פייער פון גיהנום. ");
INSERT INTO ydd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","דעריבער ווען דו ברענגסט דיין קרבן צו דעם מזבח, און דארטן דערמאנסטו דיך, אז דיין ברודער האט עפעס קעגן דיר, ");
INSERT INTO ydd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","זאלסטו דארטן איבערלאזן דיין קרבן פאר דעם מזבח, און גיי קודם כל אהין, רעד זיך דורך מיט דיין ברודער, און דאן קום און זיי מקריב דיין קרבן. ");
INSERT INTO ydd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ווער משווה מיט דיין קעגנער געשווינט, בשעת דו ביסט נאך מיט אים אויפן וועג; טאמער וועט דיין קעגנער דיך איבערגעבן צום שופט, און דער שופט צום שוטר, און דו וועסט געווארפן ווערן אין תפיסה אריין. ");
INSERT INTO ydd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","באמת זאג איך דיר, דו וועסט פון דארטן בשום אופן נישט ארויסקומען, ביז דו באצאלסט נישט די לעצטע פרוטה! ");
INSERT INTO ydd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","איר האט געהערט, אז עס איז געזאגט געווארן: זאלסט נישט נואפן! ");
INSERT INTO ydd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","איך אבער זאג אייך, אז יעדער איינער, וואס קוקט אויף א פרוי, זי צו גלוסטן, האט שוין גענואפט מיט איר אין זיין הארצן. ");
INSERT INTO ydd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","און אויב דיין רעכט אויג פארפירט דיך צום שטרויכלען, נעם עס ארויס, און ווארף עס אוועק פון דיר; מחמת עס לוינט זיך דיר, אז איינס פון דיינע אברים זאל פארלוירן גיין, און נישט דיין גאנצער גוף זאל געווארפן ווערן אין גיהנום אריין. ");
INSERT INTO ydd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","און אויב דיין רעכטע האנט פארפירט דיך צום שטרויכלען, האק זי אפ, און ווארף זי אוועק פון דיר; מחמת עס לוינט זיך דיר, אז איינס פון דיינע אברים זאל פארלוירן גיין, און נישט דיין גאנצער גוף זאל גיין אין גיהנום אריין. ");
INSERT INTO ydd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","און עס איז געזאגט געווארן: ווער עס שיידט זיך פון זיין ווייב, זאל ער איר געבן א גט. ");
INSERT INTO ydd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","איך אבער זאג אייך, אז יעדער איינער, וואס שיידט זיך פון זיין ווייב, אחוץ צוליב א פאל פון זנות, מאכט ער זי מזנה צו זיין. און ווער עס האט חתונה מיט א גרושה, דער איז מזנה. ");
INSERT INTO ydd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ווידער האט איר געהערט, אז עס איז געזאגט געווארן צו די קדמונים: זאלסט נישט שווערן פאלש, זאלסט אבער אפצאלן דיינע שבועות צום האר (ג‑ט). ");
INSERT INTO ydd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","איך אבער זאג אייך, שווערט לגמרי נישט; נישט ביים הימל, ווייל עס איז ה׳ס כסא הכבוד. ");
INSERT INTO ydd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","נישט ביי דער ערד, ווייל זי איז א פוסבענקל פאר זיינע פיס; נישט ביי ירושלים, ווייל דאס איז די שטאט פון דעם גרויסן מלך. ");
INSERT INTO ydd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","זאלסט אויך נישט שווערן ביי דיין קאפ, ווייל דו קענסט נישט קיין איינציקע האר ווייס אדער שווארץ מאכן. ");
INSERT INTO ydd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","נאר זאל אייער ווארט זיין; יא, יא; ניין, ניין! און וואס איז מער ווי די דאזיקע איז פונם בייזן. ");
INSERT INTO ydd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","איר האט געהערט, אז עס איז געזאגט געווארן: אן אויג פאר אן אויג, און א צאן פאר א צאן; ");
INSERT INTO ydd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","איך אבער זאג אייך: איר זאלט זיך נישט אנטקעגנשטעלן דעם בייזן; נאר ווען עמיצער פאטשט דיך אויף דיין רעכטער באק, נייג אים אויך די אנדערע צו. ");
INSERT INTO ydd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","און דעם, וואס וויל זיך משפטן מיט דיר און אוועקנעמען דיין העמד, לאז אים אויך דעם אויבער בגד. ");
INSERT INTO ydd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","און ווער עס צווינגט דיך צו גיין א מייל, גיי מיט אים צוויי. ");
INSERT INTO ydd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","גיב צו דעם, וואס בעט ביי דיר, און פון דעם, וואס וויל ביי דיר בארגן, דריי דיך נישט אוועק. ");
INSERT INTO ydd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","איר האט געהערט, אז עס איז געזאגט געווארן: דו זאלסט ליב האבן דיין חבר, און האסן דיין שונא; ");
INSERT INTO ydd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","איך אבער זאג אייך: האט ליב אייערע שונאים, און זייט מתפלל פאר די, וואס פארפאלגן אייך; ");
INSERT INTO ydd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","כדי איר זאלט זיין קינדער פון אייער פאטער, וואס איז אין הימל. ווייל ער לאזט זיין זון שיינען אויף בייזע און אויף גוטע, און לאזט רעגענען אויף צדיקים און אויף רשעים. ");
INSERT INTO ydd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","מחמת אויב איר וועט ליב האבן די, וואס האבן אייך ליב, וואס פאר א שכר האט איר? צי טאן דען די שטייער אויפמאנער נישט דאס זעלביקע? ");
INSERT INTO ydd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","און אויב איר גיט אפ שלום נאר אייערע ברידער אליין, וואס טוט איר דא מער? צי טאן דען די אומות (העולם) נישט אויך דאס זעלביקע? ");
INSERT INTO ydd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","דעריבער זאלט איר זיין פולקום, ווי אייער הימלישער פאטער איז פולקום. ");
INSERT INTO ydd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","גיט אכטונג, אז איר זאלט נישט טאן אייער צדקה פאר לייטן, כדי פון זיי געזען צו ווערן; און אויב נישט, האט איר נישט קיין שכר ביי אייער פאטער, וואס איז אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","דעריבער ווען דו טוסט א גמילות חסד, לאז נישט אויסטראמפייטערן פאר דיר, ווי די צבועקעס טאן אין די שולן און אויף די גאסן, כדי געלויבט צו ווערן פון לייטן. באמת זאג איך אייך, זיי האבן שוין זייער שכר. ");
INSERT INTO ydd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","דו אבער ווען דו טוסט א גמילות חסד זאל דיין לינקע האנט נישט וויסן, וואס די רעכטע טוט, ");
INSERT INTO ydd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","כדי דיין גמילות חסדים זאל בלייבן פארבארגן; און דיין פאטער, וואס זעט אין פארבארגעניש, וועט דיר פארגעלטן. ");
INSERT INTO ydd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","און ווען איר טוט תפילה, זאלט איר נישט זיין ווי די צבועקעס, ווייל זיי האבן ליב תפילה צו טאן ווען זיי שטייען אין די שולן און אויף די עקן פון די גאסן, כדי זיך צו באווייזן פאר מענטשן. באמת זאג איך אייך, זיי האבן שוין זייער שכר. ");
INSERT INTO ydd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","דו אבער, ווען דו טוסט תפילה, גיי אריין אין דיין חדרל, און פארשליס די טיר, און זיי מתפלל צו דיין פאטער, וואס איז פארבארגן, און דיין פאטער, וואס זעט אין פארבארגעניש, וועט דיר פארגעלטן. ");
INSERT INTO ydd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","און תפילה טוענדיק, זאלט איר נישט פלאפלען ווי די אומות (העולם); מחמת זיי מיינען, אז דורך א סך ווערטער זייערע, וועלן זיי דערהערט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","דעריבער זייט נישט גלייך ווי זיי! מחמת ה׳, אייער פאטער, ווייסט וואס איר באדארפט, איידער איר בעט אים. ");
INSERT INTO ydd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","דעריבער זאלט איר אזוי תפילה טאן: אונדזער פאטער, וואס דו ביסט אין הימל, געהייליקט זאל ווערן דיין נאמען. ");
INSERT INTO ydd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","זאל דיין מלכות קומען. זאל דיין רצון געשען, ווי אין הימל, אזוי אויך אויף דער ערד. ");
INSERT INTO ydd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","אונדזער טעגלעך ברויט גיב אונדז היינט. ");
INSERT INTO ydd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","און פארגיב אונדז אונדזערע חובות, ווי אויך מיר האבן פארגעבן די, וואס זענען אונדז שולדיק. ");
INSERT INTO ydd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","און ברענג אונדז נישט צו קיין נסיון, נאר זיי אונדז מציל פון שלעכטס (מחמת דיין איז דאס מלכות, און די מאכט, און די הערלעכקייט, אויף אייביק! אמן.) ");
INSERT INTO ydd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","מחמת אויב איר פארגיט די מענטשן זייערע פעלערן, וועט אייער הימלישער פאטער אייך אויך פארגעבן. ");
INSERT INTO ydd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ווען אבער איר פארגיט די מענטשן נישט, וועט אייער פאטער אייך אויך נישט פארגעבן אייערע עבירות. ");
INSERT INTO ydd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","און ווען איר פאסט, זאלט איר נישט זיין ווי די צבועקעס, מיט א זויער פנים; מחמת זיי פארפינסטערן זייערע פנימער, כדי זיך צו באווייזן פאר מענטשן, אז זיי פאסטן. באמת זאג איך אייך, זיי האבן שוין זייער שכר. ");
INSERT INTO ydd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","דו אבער, ווען דו פאסט, זאלב דיר דעם קאפ מיט אייל, און וואש דיר אפ דאס פנים; ");
INSERT INTO ydd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","כדי זאלסט נישט געזען ווערן פון מענטשן, אז דו פאסט, נאר פאר דיין פאטער, וואס איז פארבארגן; און דיין פאטער, וואס זעט אין פארבארגעניש, וועט דיר פארגעלטן. ");
INSERT INTO ydd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","זאמלט אייך נישט איין קיין אוצרות אויף דער ערד, וואו מילב און זשאווער פארדארבן, און וואו גנבים גראבן אונטער און גנבענען אוועק. ");
INSERT INTO ydd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","נאר זאמלט אייך איין אוצרות אין הימל, וואו נישט די מילב נישט דער זשאווער פארדארבן, און וואו גנבים גראבן נישט אונטער און גנבענען נישט אוועק. ");
INSERT INTO ydd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","מחמת וואו דיין אוצר איז, דארט וועט אויך דיין הארץ זיין. ");
INSERT INTO ydd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","דאס ליכט פון דעם גוף איז דאס אויג. ");
INSERT INTO ydd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","אויב דעריבער דיין אויג איז געזונט, וועט דיין גאנצער גוף זיין ליכטיק. ווען אבער דיין אויג איז בייז, וועט דיין גאנצער גוף זיין פינסטער. דעריבער אויב דאס ליכט, וואס איז אין דיר, איז פינסטער, ווי גרויס איז די חושך! ");
INSERT INTO ydd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","קיינער קען נישט דינען צוויי הארן; מחמת אדער ער וועט דעם איינעם פיינט האבן, און ליב האבן דעם אנדערן, אדער ער וועט זיך האלטן ביי איינעם, און דעם אנדערן פאראכטן. איר קענט נישט דינען ה׳ און ממון. ");
INSERT INTO ydd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","דערפאר זאג איך אייך: זארגט נישט פאר אייער לעבן, וואס איר זאלט עסן, אדער וואס איר זאלט טרינקען; און אויך נישט פאר אייער גוף, וואס איר זאלט אנטאן. צי איז דען נישט דאס לעבן מער ווי די שפייז, און דער גוף מער ווי די קליידונג? ");
INSERT INTO ydd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","קוקט אויף די פייגל פון הימל, אז זיי זייען נישט, און שניידן נישט, און זאמלען אויך נישט אין שייערס אריין; און אייער הימלישער פאטער שפייזט זיי. צי זענט איר דען נישט פיל מער ווערט ווי זיי? ");
INSERT INTO ydd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","און ווער פון אייך זארגנדיק, קען צולייגן אן אייל צו זיין געוואוקס? ");
INSERT INTO ydd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","און פארוואס זארגט איר זיך וועגן א מלבוש? לערנט זיך אראפ פון די ליליעס פון פעלד, ווי זיי וואקסן; זיי ארבעטן נישט און שפינען נישט; ");
INSERT INTO ydd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","איך זאג אייך אבער, אז שלמה מיט זיין גאנצער פראכט איז נישט געווען אזוי אנגעטאן, ווי איינע פון די דאזיקע. ");
INSERT INTO ydd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","און אויב ה׳ קליידט אזוי אָן דאס גראז פון פעלד, וואס היינט איז עס דא, און צומארגנס ווערט עס געווארפן אין אויוון אריין, וועט ער דען נישט פיל מער אייך (קליידן), איר קליינגלויביקע? ");
INSERT INTO ydd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","דעריבער זאלט איר נישט זארגן, אזוי צו זאגן: וואס וועלן מיר עסן, אדער וואס וועלן מיר טרינקען, אדער מיט וואס וועלן מיר זיך קליידן? ");
INSERT INTO ydd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","מחמת די אומות (העולם) זוכן דאס אלץ; יא, אייער הימלישער פאטער ווייסט, אז איר נויטיקט זיך אין דעם אלעם. ");
INSERT INTO ydd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","זוכט אבער צום אלעמערשטן זיין מלכות, און זיין גערעכטיקייט; און דאס אלץ וועט אייך צוגעגעבן ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","זארגט זשע נישט אויף מארגן; מחמת דער מארגנדיקער טאג וועט זארגן פאר זיך אליין. דער טאג האט גענוג זיין אייגן בייז. ");
INSERT INTO ydd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","משפט נישט, כדי איר זאלט נישט געמשפט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","מחמת מיט וואס פאר א משפט איר אורטיילט, וועט איר געמשפט ווערן, און מיט וועלכער מאס איר מעסט, וועט אייך געמאסטן ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","און וואס זעסטו דאס שפענדל אין דיין ברודערס אויג, אבער דעם קלאץ, וואס איז אין דיין אויג, באמערקסטו נישט? ");
INSERT INTO ydd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","אדער ווי אזוי קענסטו זאגן צו דיין ברודער: לאז מיך ארויסנעמען דאס שפענדל פון דיין אויג; און זע, דער קלאץ איז אין דיין אויג? ");
INSERT INTO ydd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","דו צבועק, ווארף צום ערשט ארויס דעם קלאץ פון דיין אויג; און דעמאלט וועסטו זען קלאר ארויסצונעמען דאס שפענדל פון דיין ברודערס אויג. ");
INSERT INTO ydd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","גיט נישט דאס הייליקע צו די הינט, און ווארפט נישט אייערע פערל פאר די חזירים, טאמער וועלן זיי זיי צעטרעטן מיט זייערע פיס, און אומקערנדיק זיך אייך צערייסן. ");
INSERT INTO ydd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","בעט, און עס וועט אייך געגעבן ווערן; זוכט, און איר וועט געפינען; קלאפט אָן, און עס וועט אייך אויפגעמאכט ווערן! ");
INSERT INTO ydd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","מחמת יעדער, וואס בעט, באקומט; און דער, וואס זוכט, געפינט; און דעם, וואס קלאפט אָן, וועט אויפגעמאכט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","אדער וועלכער מענטש צווישן אייך איז עס, וואס, אויב זיין זון זאל אים בעטן ברויט, וועט ער אים געבן א שטיין? ");
INSERT INTO ydd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","אדער אויב ער זאל בעטן א פיש, וועט ער דען אים געבן א שלאנג? ");
INSERT INTO ydd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","אויב דעריבער איר, זייענדיק שלעכט, ווייסט צו געבן גוטע גאב צו אייערע קינדער, וויפל מער וועט אייער פאטער, וואס איז אין הימל, געבן גוטס צו די, וואס בעטן אים? ");
INSERT INTO ydd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","דעריבער אלץ, וואס איר ווילט, אז די מענטשן זאלן אייך טאן, טוט אויך אזוי פאר זיי; מחמת דאס דאזיקע איז די תורה און די נביאים. ");
INSERT INTO ydd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","גייט אריין דורך דעם ענגן טויער; ווייל געראם איז דאס טויער, און אויסגעברייטערט דער וועג, וואס פירט צו פארדארבונג, און א סך זענען עס, וואס גייען אריין דורך דעם דאזיקן. ");
INSERT INTO ydd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ווי ענג איז אבער דאס טויער, און שמאל דער וועג, וואס פירט צום לעבן, און ווייניק זענען די, וואס געפינען אים. ");
INSERT INTO ydd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","היט זיך פאר די פאלשע נביאים, וואס קומען צו אייך אין קליידער פון שאף, אינעווייניק אבער זענען זיי פארצוקנדיקע וועלף. ");
INSERT INTO ydd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","פון זייערע פירות זאלט איר זיי דערקענען. צי קלויבט מען דען וויינטרויבן פון דערנער, אדער פייגן פון שטעכלקעס? ");
INSERT INTO ydd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","אזוי טראגט יעדער גוטער בוים גוטע פירות; דער פארפוילטער בוים אבער גיט ארויס שלעכטע פירות. ");
INSERT INTO ydd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","א גוטער בוים קען נישט ברענגען קיין שלעכטע פירות, און א פארפוילטער בוים נישט ברענגען קיין גוטע פירות. ");
INSERT INTO ydd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","יעדער בוים, וואס גיט נישט ארויס קיין גוטע פירות, ווערט אפגעהאקט, און געווארפן אין פייער אריין. ");
INSERT INTO ydd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","דעריבער זאלט איר זיי דערקענען פון זייערע פירות. ");
INSERT INTO ydd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","נישט יעדער איינער, וואס זאגט צו מיר, האר, האר, וועט אריינגיין אין מלכות השמים, נאר דער, וואס טוט דעם רצון פון מיין פאטער, וואס איז אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","א סך וועלן זאגן צו מיר אין יענעם טאג: האר, האר, צי האבן מיר דען נישט אין דיין נאמען נבואות געזאגט, און אין דיין נאמען ארויסגעטריבן בייזע גייסטער, און אין דיין נאמען געטאן א סך וואונדער? ");
INSERT INTO ydd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","און דעמאלט וועל איך מודה זיין פאר זיי: איך האב אייך קיינמאל נישט געקענט; אוועק פון מיר, איר, וואס טוט רשעות. ");
INSERT INTO ydd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","דעריבער יעדער איינער, וואס הערט די דאזיקע ווערטער מיינע, און טוט זיי, וועט זיין געגליכן צו א מאן א חכם, וואס האט געבויט זיין הויז אויף דעם פעלדזן. ");
INSERT INTO ydd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","און דער פלאצרעגן איז געפאלן, און די וואסער שטורמען זענען געקומען, און די ווינטן האבן געבלאזן, און האבן אנגעגריפן יענע הויז; און עס איז נישט איינגעפאלן; מחמת עס איז געווען געגרינדעט אויף דעם פעלדזן. ");
INSERT INTO ydd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","און יעדער איינער, וואס הערט די דאזיקע ווערטער מיינע, און טוט זיי נישט, וועט זיין געגליכן צו א מאן א נאר, וואס האט געבויט זיין הויז אויפן זאמד. ");
INSERT INTO ydd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","און דער פלאצרעגן איז געפאלן, און די וואסער שטורמען זענען געקומען, און די ווינטן האבן געבלאזן, און האבן געשטויסן אויף יענעם הויז; און עס איז איינגעפאלן, און דער צואמענברוך דערפון איז געווען גרויס. ");
INSERT INTO ydd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","און עס איז געשען, ווען יהושע/ישוע האט געענדיקט די דאזיקע ווערטער, האבן די המונים מענטשן געשטוינט איבער זיין לערנונג. ");
INSERT INTO ydd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","מחמת ער האט זיי געלערנט ווי איינער, וואס האט מאכט, און נישט ווי זייערע סופרים. ");
INSERT INTO ydd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","און ווען ער איז אראפגעשטיגן פון בארג, האבן אים נאכגעפאלגט גרויסע המונים מענטשן, ");
INSERT INTO ydd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","און זע, א מצורעדיקער איז געקומען און איז אנידערגעפאלן פאר אים, און האט געזאגט: האר, אויב דו ווילסט, קענסטו מיך ריין מאכן. ");
INSERT INTO ydd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","און ער האט אויסגעשטרעקט די האנט, און האט אים אנגערירט, אזוי צו זאגן: איך וויל; זיי גערייניקט! און גלייך איז ער ריין געווארן פון זיין צרעת. ");
INSERT INTO ydd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","און יהושע/ישוע זאגט צו אים: היט דיך, אז דו זאלסט עס קיינעם נישט אויסזאגן; נאר גיי, ווייז דיך צום כהן, און זיי מקריב דאס קרבן, וואס משה האט געבאטן, פאר אן עדות צו זיי! ");
INSERT INTO ydd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","און ווי ער איז אריינגעקומען קיין כפר‑נחום, איז געקומען צו אים אן אפיציר, און האט אים געבעטן, ");
INSERT INTO ydd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","און געזאגט: האר, מיין משרת ליגט פאראליזשירט אין הויז, און האט שרעקלעכע יסורים. ");
INSERT INTO ydd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","און ער זאגט צו אים: איך וועל קומען און אים היילן. ");
INSERT INTO ydd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","דער אפיציר אבער האט ענטפערנדיק געזאגט: האר, איך בין נישט ווערט, אז דו זאלסט אריינקומען אונטער מיין דאך, נאר זאג בלויז א ווארט, און מיין משרת וועט געהיילט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","מחמת אויך איך בין א מענטש, וואס שטייט אונטער דער ממשלה, האבנדיק אונטער מיר זעלנער, און איך זאג צו דעם: גיי! און ער גייט; און צו אן אנדערן: קום אהער! און ער קומט; און צו מיין קנעכט: טו דאס! און ער טוט עס. ");
INSERT INTO ydd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","און ווי יהושע/ישוע האט דאס געהערט, האט ער זיך געוואונדערט, און האט געזאגט צו די, וואס האבן נאכגעפאלגט: באמת זאג איך אייך, ביי קיינעם אין ישראל האב איך אזא אמונה נישט געפונען. ");
INSERT INTO ydd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","און איך זאג אייך: א סך וועלן קומען פון מזרח און פון מערב, און וועלן זיך אנידערזעצן מיט אברהם, און מיט יצחקן, און מיט יעקבן, אין דעם מלכות השמים. ");
INSERT INTO ydd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","די קינדער אבער פון דעם מלכות וועלן ארויסגעווארפן ווערן אין דער פינצטערניש אינדרויסן; דארטן וועט זיין דאס קלאגן און דאס קריצן מיט די ציין. ");
INSERT INTO ydd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","און יהושע/ישוע האט געזאגט צו דעם אפיציר: גיי, זאל דיר געשען אזוי, ווי דו האסט געגלויבט! און דער משרת איז געהיילט געווארן אין יענער שעה. ");
INSERT INTO ydd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","און ווען יהושע/ישוע איז געקומען צו פעטרוסן אין הויז אריין, האט ער געזען זיין שוויגער ליגן קראנק אויף א קדחת. ");
INSERT INTO ydd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","און ער האט אנגערירט איר האנט, און דאס פיבער האט זי פארלאזן; און זי איז אויפגעשטאנען, און האט אים באדינט. ");
INSERT INTO ydd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","און ווען עס איז געווארן אוונט, האט מען געברענגט צו אים א סך באזעסענע מיט בייזע גייסטער, און ער האט ארויסגעטריבן די גייסטער מיט א ווארט, און אלע קראנקע געהיילט; ");
INSERT INTO ydd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","כדי עס זאל דערפילט ווערן, וואס עס איז געזאגט געווארן דורך ישעיה הנביא, אזוי צו זאגן: ער אליין האט אוועקגענומען אונדזערע קראנקייטן, און געטראגן די לאסט פון אונדזערע ווייטאקן. (ישעיהו נג, ד.) ");
INSERT INTO ydd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","און אז יהושע/ישוע האט געזען א המון מענטשן ארום זיך, האט ער באפוילן אוועקצופארן אויף דער אנדערער זייט ים. ");
INSERT INTO ydd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","און א סופר איז געקומען, און האט צו אים געזאגט: רבי, איך וועל דיר נאכפאלגן, וואו דו וועסט נאר גיין. ");
INSERT INTO ydd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","און יהושע/ישוע זאגט צו אים: די פוקסן האבן היילן, און די פייגל פון הימל—נעסטן; דער בר אנש אבער האט נישט, וואו דעם קאפ אנידערצולייגן. ");
INSERT INTO ydd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","און אן אנדערער פון די תלמידים האט צו אים געזאגט: האר, גיב מיר רשות קודם כל אוועקצוגיין און קובר צו זיין מיין פאטער. ");
INSERT INTO ydd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","יהושע/ישוע אבער זאגט צו אים: פאלג דו מיר נאך; און לאז די מתים קובר זיין זייערע מתים. ");
INSERT INTO ydd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","און ער איז איינגעשטיגן אין דעם שיפל, און זיינע תלמידים האבן אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","און זע, עס איז געווארן א גרויסער שטורמווינט אויפן ים, אז דאס שיפל איז אזש באדעקט געווארן פון די כוואליעס; ער אבער איז געשלאפן. ");
INSERT INTO ydd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","און זיי זענען געקומען צו אים, און האבן אים אויפגעוועקט, אזוי צו זאגן: האר, ראטעווע; מיר קומען אום! ");
INSERT INTO ydd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","און ער זאגט צו זיי: וואס זענט איר אזוי אנגעשראקן, איר קליינגלויביקע? דאן איז ער אויפגעשטאנען, און האט אנגעשריגן די ווינטן און דעם ים; און עס איז געווארן א גרויסע שטילקייט. ");
INSERT INTO ydd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","און די מענטשן האבן זיך געוואונדערט, און האבן געזאגט: וואס איז דאס פאר א מאן, אז סיי די ווינטן סיי דער ים געהארכן אים? ");
INSERT INTO ydd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","און ווען ער איז געקומען אויף יענער זייט ים אין דעם לאנד פון די גדריים, זענען אים אנטקעגנגעלאפן צוויי באזעסענע, וואס זענען ארויסגעקומען אויס די קברים, זייער געפערלעכע, אז קיינער האט נישט געקענט פארבייגיין דורך יענעם וועג. ");
INSERT INTO ydd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","און זע, זיי האבן א געשריי געטאן, אזוי צו זאגן: וואס האבן מיר מיט דיר, דו זון פון דער אויבערשטער? ביסטו אהערגעקומען אונדז פייניקן פאר דער צייט? ");
INSERT INTO ydd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","און פונדערווייטנס פון זיי האט זיך געפאשעט א גרויסע סטאדע חזירים. ");
INSERT INTO ydd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","און די בייזע גייסטער האבן אים געבעטן, אזוי צו זאגן: אויב דו טרייבסט אונדז ארויס, שיק אונדז אריין אין דער סטאדע חזירים! ");
INSERT INTO ydd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","און ער האט צו זיי געזאגט: גייט! און זיי זענען ארויסגעגאנגען, און זענען אוועק אין די חזירים אריין; און זע, די גאנצע סטאדע האט זיך א ריס אראפ געטאן פון דער משופעדיקייט אין ים אריין, און זענען אומגעקומען אין די וואסערן. ");
INSERT INTO ydd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","די פאסטוכער אבער זענען אנטלאפן, און זענען אריין אין שטאט, און האבן אלץ דערציילט, און וואס (עס האט פאסירט) מיט די באזעסענע. ");
INSERT INTO ydd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","און זע, די גאנצע שטאט איז ארויסגעגאנגען אנטקייגן יהושען/ישוען; און דערזעענדיק אים, האבן זיי אים געבעטן, אז ער זאל אוועקגיין פון זייער גבול. ");
INSERT INTO ydd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","און ער איז איינגעשטיגן אין א שיפל, און איז אריבערגעפארן, און געקומען אין זיין אייגענער שטאט אריין. ");
INSERT INTO ydd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","און זע, מען האט געברענגט צו אים א פאראליזשירטן, וואס איז געלעגן אויף א בעט. און ווי יהושע/ישוע האט געזען זייער אמונה, האט ער געזאגט צום פאראליזשירטן: זיי געטרייסט, מיין קינד, דיינע זינד זענען דיר פארגעבן געווארן! ");
INSERT INTO ydd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","און זע, אייניקע פון די סופרים האבן זיך געטראכט: דער דאזיקער לעסטערט. ");
INSERT INTO ydd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","און זעענדיק זייערע געדאנקען, האט יהושע/ישוע געזאגט: פארוואס טראכט איר בייז אין אייערע הערצער? ");
INSERT INTO ydd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","מחמת וואס איז לייכטער, צו זאגן: דיינע זינד זענען דיר פארגעבן געווארן; אדער צו זאגן: שטיי אויף און גיי? ");
INSERT INTO ydd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","נאר כדי איר זאלט וויסן, אז דער בר אנש האט רשות אויף דער ערד מוחל צו זיין זינד—זאגט ער דעמאלט צו דעם פאראליזשירטן—שטיי אויף, נעם דיין בעט און גיי אהיים! ");
INSERT INTO ydd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","און ער איז אויפגעשטאנען, און איז אוועק אהיים. ");
INSERT INTO ydd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","און ווען די המונים מענטשן האבן דאס געזען, האבן זיי זיך געפארכטן, און האבן אפגעגעבן כבוד צו ה׳, וואס האט געגעבן אזא רשות צו מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","און ווען יהושע/ישוע איז פון דארטן ווייטער געגאנגען, האט ער געזען א מענטשן זיצן ביים הויז פון שטייער, ער האט געהייסן מתתיהו, און ער זאגט צו אים: פאלג מיר נאך! און ער איז אויפגעשטאנען, און האט אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","און עס איז געשען, בשעת ער איז געזעסן אין הויז צום טיש, זע, א סך שטייער אויפמאנער און חוטאים זענען געקומען און האבן זיך אנידערגעזעצט צוזאמען מיט יהושען/ישוען און מיט זיינע תלמידים. ");
INSERT INTO ydd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","און ווען די פרושים האבן עס געזען, האבן זיי געזאגט צו זיינע תלמידים: פארוואס עסט אייער רבי מיט די שטייער אויפמאנער און חוטאים? ");
INSERT INTO ydd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ווען אבער ער האט דאס געהערט, האט ער געזאגט: די געזונטע דארפן נישט האבן קיין רופא, נאר די קראנקע. ");
INSERT INTO ydd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","גייט און לערנט וואס דאס איז: איך וויל בארעמהארציקייט, און נישט קיין קרבן (הושע ו, ו.); מחמת איך בין נישט געקומען רופן צדיקים, נאר חוטאים. ");
INSERT INTO ydd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","דעמאלט קומען צו אים יוחננס תלמידים, און זאגן: פארוואס פאסטן מיר און די פרושים אפט מאל, דיינע תלמידים אבער פאסטן נישט? ");
INSERT INTO ydd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","און יהושע/ישוע האט צו זיי געזאגט: צי קענען דען די אונטערפירערס טרויערן, בשעת דער חתן איז מיט זיי? עס וועלן אבער קומען טעג, ווען דער חתן וועט פון זיי אוועקגענומען ווערן, און דעמאלט וועלן זיי פאסטן. ");
INSERT INTO ydd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","און קיינער לייגט נישט קיין לאטע פון נישט איינגעלאפענעם טוך אויף אן אלטן בגד; מחמת די לאטע רייסט אפ פון דעם קלייד, און עס ווערט אן ערגערער ריס. ");
INSERT INTO ydd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","מען גיסט אויך נישט אריין קיין נייעם וויין אין אלטע לאגלען, טאמער פלאצן די לאגלען, און דער וויין גיסט זיך אויס, און די לאגלען ווערן פארדארבן; נאר מען גיסט אריין נייעם וויין אין נייע לאגלען, און ביידע האלטן זיך. ");
INSERT INTO ydd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","בעת ער האט דאס צו זיי גערעדט, זע, א שר איז געקומען, און איז אנידערגעפאלן פאר אים, און האט געזאגט: מיין טאכטער איז נאר וואס געשטארבן; נאר קום און לייג דיין האנט אויף איר, און זי וועט לעבן. ");
INSERT INTO ydd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","און יהושע/ישוע איז אויפגעשטאנען, און האט אים נאכגעפאלגט מיט זיינע תלמידים. ");
INSERT INTO ydd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","און זע, א פרוי, וואס האט געהאט א בלוט גאנג צוועלף יאר לאנג, איז צוגעקומען פון הינטן, און האט אנגערירט די זוים פון זיין מלבוש. ");
INSERT INTO ydd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","מחמת זי האט צו זיך געזאגט: אויב איך וועל נאר אנרירן זיין מלבוש, וועל איך געהאלפן ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","און יהושע/ישוע האט זיך אויסגעדרייט און זעענדיק זי, האט ער געזאגט: זיי געטרייסט, מיין טאכטער, דיין אמונה האט דיך געראטעוועט! און די פרוי איז געזונט געווארן פון יענער שעה אָן. ");
INSERT INTO ydd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","און ווען יהושע/ישוע איז אריינגעקומען אין הויז פון דעם שר, און האט געזען די פלייטשפילער, און דאס געטומל פון דעם המון, ");
INSERT INTO ydd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","האט ער געזאגט: גייט אוועק! מחמת דאס מיידעלע איז נישט געשטארבן, זי שלאפט נאר. און זיי האבן זיך אויסגעלאכט פון אים. ");
INSERT INTO ydd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ווען אבער דער עולם איז דערווייטערט געווארן, איז ער אריינגעגאנגען, און האט זי אנגענומען ביי דער האנט; און דאס מיידעלע האט זיך אויפגעהויבן. ");
INSERT INTO ydd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","און דער דאזיקער שם האט זיך פארשפרייט איבער יענעם גאנצן לאנד. ");
INSERT INTO ydd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","און ווען יהושע/ישוע איז פונדאנען ווייטער געגאנגען, האבן אים נאכגעפאלגט צוויי בלינדע מענטשן, וואס האבן געשריגן און געזאגט: דערבארם דיך אויף אונדז, בן דוד! ");
INSERT INTO ydd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","און ווען ער איז אריינגעקומען אין הויז, זענען די בלינדע צוגעקומען צו אים. און יהושע/ישוע זאגט צו זיי: גלויבט איר, אז איך קען טאן דאס דאזיקע? זאגן זיי צו אים: יא, האר! ");
INSERT INTO ydd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","האט ער דעמאלט אנגערירט זייערע אויגן, און געזאגט: לויט אייער אמונה, אזוי זאל עס אייך געשען! ");
INSERT INTO ydd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","און זייערע אויגן זענען אויפגעעפנט געווארן. און יהושע/ישוע האט זיי שטרענג געווארנט, אזוי צו זאגן: היט אייך, אז קיינער זאל זיך נישט דערוויסן דערפון. ");
INSERT INTO ydd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","זיי אבער זענען ארויסגעגאנגען, און האבן אים באקאנט געמאכט איבער יענעם גאנצן לאנד. ");
INSERT INTO ydd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","און ווען זיי זענען ארויסגעגאנגען, זע, מען האט געברענגט צו אים א שטומען, באזעסן מיט א בייזן גייסט. ");
INSERT INTO ydd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","און נאך דעם ווי דער בייזער גייסט איז ארויסגעטריבן געווארן, האט דער שטומער גערעדט. און די המונים מענטשן האבן געשטוינט, און געזאגט: נאך קיינמאל איז אזעלכעס נישט געזען געווארן אין ישראל! ");
INSERT INTO ydd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","די פרושים אבער האבן געזאגט: דורך דעם שר פון די בייזע גייסטער טרייבט ער ארויס די בייזע גייסטער! ");
INSERT INTO ydd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","און יהושע/ישוע איז ארומגעגאנגען איבער אלע שטעט און דערפער, לערנענדיק אין זייערע שולן, און אויסרופנדיק די גוטע בשורה פון דעם מלכות, און היילנדיק יעדע מחלה און יעדע שלאפקייט. ");
INSERT INTO ydd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","און ווען ער האט געזען די מאסן מענטשן, האט ער אויף זיי גרויס רחמנות געהאט, ווייל זיי זענען געווען פארשמאכט און פארווארלאזט, ווי שאף, וואס האבן נישט קיין פאסטוך. ");
INSERT INTO ydd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","דעמאלט זאגט ער צו זיינע תלמידים: דער שניט איז גרויס, נאר די ארבעטער זענען ווייניק. ");
INSERT INTO ydd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","בעט זשע דעם האר פון דעם שניט, אז ער זאל ארויסשיקן ארבעטער צו זיין שניט! ");
INSERT INTO ydd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","און ער האט גערופן צו זיך זיינע צוועלף תלמידים, און האט זיי געגעבן מאכט איבער אומריינע גייסטער, זיי ארויסצוטרייבן, און צו היילן יעדע קראנקייט און יעדע שלאפקייט. ");
INSERT INTO ydd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","און אָט די דאזיקע זענען די נעמען פון די צוועלף שליחים: דער ערשטער שמעון, וואס מען האט אים גערופן פעטרוס, און זיין ברודער אנדריי; יעקב בן זבדי, און זיין ברודער יוחנן; ");
INSERT INTO ydd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","פיליפוס און בר‑תלמי; תומא און מתתיהו דער שטייער אויפמאנער; יעקב בן חלפי און תדי; ");
INSERT INTO ydd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","שמעון הקנאי און יהודה איש‑קריות, וואס האט אים אויך פארראטן. ");
INSERT INTO ydd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","די דאזיקע צוועלף האט יהושע/ישוע געשיקט, און האט זיי באפוילן, אזוי צו זאגן: אויף קיין וועג פון די אומות (העולם) זאלט איר נישט גיין, און אין קיין שטאט פון די שומרונים זאלט איר נישט אריינגיין; ");
INSERT INTO ydd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","נאר גייט ליבער צו די פארלוירענע שעפעלעך פון דעם הויז ישראל. ");
INSERT INTO ydd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","גייט, רופט אויס און זאגט: דאס מלכות השמים איז נאענט! ");
INSERT INTO ydd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","היילט די קראנקע, וועקט אויף די טויטע, רייניקט די קרעציקע, טרייבט ארויס די בייזע גייסטער! אומזיסט האט איר באקומען, אומזיסט זאלט איר געבן! ");
INSERT INTO ydd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","נעמט נישט קיין גאלד, נישט קיין זילבער, נישט קיין קופער אין אייערע גארטלען; ");
INSERT INTO ydd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","נישט קיין זאק אויפן וועג, נישט קיין צוויי העמדער, נישט קיין שיך, נישט קיין שטאק; מחמת דער ארבעטער איז ווערט זיין שפייז. ");
INSERT INTO ydd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","און אין וועלכער שטאט אדער דארף איר קומט אריין, פארשט אויס ווער עס האט די ווערדע אין איר; און דארטן זאלט איר איינשטיין ביז איר גייט אוועק. ");
INSERT INTO ydd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","און אריינקומענדיק אין דעם הויז, זאלט איר עס באגריסן. ");
INSERT INTO ydd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","און אויב דאס הויז איז ראוי זאל אייער שלום קומען דערויף, אויב אבער עס איז נישט ראוי זאל אייער שלום זיך אומקערן צו אייך. ");
INSERT INTO ydd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","און ווער עס וועט אייך נישט אויפנעמען, און נישט הערן אייערע ווערטער, זאלט איר ארויסגיין פון יענעם הויז אדער יענער שטאט און אפשאקלען דעם שטויב פון אייערע פיס! ");
INSERT INTO ydd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","באמת זאג איך אייך; עס וועט זיין גרינגער פאר דעם לאנד פון סדום און עמורה אינם טאג פון משפט, ווי פאר יענער שטאט. ");
INSERT INTO ydd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","זע, איך שיק אייך ווי שאף צווישן וועלף. זייט זשע קלוג ווי די שלאנגען, און אָן פאלשקייט ווי די טויבן. ");
INSERT INTO ydd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","היט זיך אבער פאר די מענטשן! מחמת זיי וועלן אייך איבערגעבן צום סנהדרין, און אין זייערע שולן וועלן זיי אייך שמייסן מיט ריטער; ");
INSERT INTO ydd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","אפילו פאר מושלים און מלכים וועט מען אייך פירן צוליב מיר, פאר אן עדות צו זיי און צו די אומות (העולם). ");
INSERT INTO ydd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ווען זיי וועלן אייך אבער איבערגעבן, זאלט איר נישט זארגן, ווי אזוי אדער וואס איר האט צו רעדן; ");
INSERT INTO ydd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","מחמת עס וועט אייך געגעבן ווערן אין יענער שעה, וואס איר זאלט רעדן; מחמת נישט איר זענט עס, וואס רעדן, נאר דער גייסט פון אייער פאטער איז עס, וואס רעדט דורך אייך. ");
INSERT INTO ydd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","און א ברודער וועט איבערגעבן א ברודער צום טויט, און א פאטער זיין קינד, און קינדער וועלן אויפשטיין קעגן די עלטערן און וועלן זיי טייטן. ");
INSERT INTO ydd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","און איר וועט זיין געהאסט פון אלעמען צוליב מיין נאמען. ווער אבער עס וועט אויסהאלטן ביז צום סוף, דער וועט געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","און ווען זיי פארפאלגן אייך אין דער דאזיקער שטאט, אנטלויפט אין דער אנדערער אריין. מחמת באמת זאג איך אייך: איר וועט נישט דורכגיין די שטעט פון ישראל, ביז דער בר אנש וועט קומען. ");
INSERT INTO ydd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","א תלמיד איז נישט איבער זיין רבין, און א קנעכט נישט איבער זיין האר. ");
INSERT INTO ydd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","עס איז גענוג פאר דעם תלמיד, אז ער זאל זיין ווי זיין רבי, און דער קנעכט ווי זיין האר. אויב דעם בעל הבית האט מען גערופן בעל‑זבול, וויפל מער זיינע בני בית! ");
INSERT INTO ydd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","דעריבער זאלט איר זיך נישט פארכטן פאר זיי! מחמת עס איז נישטא קיין באהאלטענע זאך, וואס וועט נישט אנטפלעקט ווערן; און קיין פארבארגענע זאך, וואס וועט נישט באקאנט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","וואס איך זאג אייך אין דער פינסטער, דאס זאלט איר רעדן אינם ליכט, און וואס עס ווערט אייך געשעפטשעט אין אויער אריין, דאס זאלט איר אויסרופן אויף די דעכער. ");
INSERT INTO ydd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","און פארכט זיך נישט פאר די, וואס טייטן דעם גוף, אבער האבן נישט קיין קראפט צו טייטן די נשמה; אמער זאלט איר זיך פארכטן פאר דעם, וואס איז בכוח צו פארדארבן סיי די נשמה סיי דעם גוף אין גיהנום. ");
INSERT INTO ydd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","פארקויפט מען דען נישט צוויי פייגעלעך פאר איין פרוטה? און דאך פאלט נישט קיין איינס פון זיי צו דער ערד אָן אייער פאטער. ");
INSERT INTO ydd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ביי אייך אבער זענען אפילו די האר פון קאפ אלע געציילט. ");
INSERT INTO ydd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","דעריבער זאלט איר נישט מורא האבן; איר זענט ווערט מער ווי א סך פייגעלעך. ");
INSERT INTO ydd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ווער זשע עס וועט מיך מתוודה זיין פאר די מענטשן, וועל איך דעם אויך מתוודה זיין פאר מיין פאטער, וואס איז אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ווער אבער עס וועט מיך פארלייקענען פאר די מענטשן, וועל איך דעם אויך פארלייקענען פאר מיין פאטער, וואס איז אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","איר זאלט נישט מיינען, אז איך בין געקומען, כדי צו ברענגען שלום אויף דער ערד. איך בין נישט געקומען ברענגען שלום, נאר א שווערד. ");
INSERT INTO ydd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","מחמת איך בין געקומען אפצושיידן א מענטשן פון זיין פאטער, און א טאכטער פון איר מוטער, און א שנור פון איר שוויגער, ");
INSERT INTO ydd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","און א מענטשנס שונאים וועלן זיין זיינע אייגענע בני בית. ");
INSERT INTO ydd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ווער עס האט ליב פאטער אדער מוטער מער ווי מיך, דער איז מיך נישט ווערט; און ווער עס האט ליב זון אדער טאכטער מער ווי מיך, דער איז מיך נישט ווערט. ");
INSERT INTO ydd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","און ווער עס נעמט נישט זיין בוים, און פאלגט מיר נאך, איז מיך נישט ווערט. ");
INSERT INTO ydd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ווער עס געפינט זיין לעבן, דער וועט עס פארלירן; און ווער עס פארלירט זיין לעבן פאר מיינעטוועגן, דער וועט עס געפינען. ");
INSERT INTO ydd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","דער, וואס נעמט אייך אויף, נעמט מיך אויף; און דער, וואס נעמט מיך אויף, נעמט אויף דעם. וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","דער, וואס נעמט אויף א נביא אין דעם נאמען פון א נביא, וועט באקומען דעם שכר פון א נביא; און דער, וואס נעמט אויף א צדיק אין דעם נאמען פון א צדיק, וועט ער באקומען דעם שכר פון א צדיק. און דער, ");
INSERT INTO ydd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","וואס וועט געבן צו טרינקען איינעם פון די דאזיקע קליינע בלויז א טעפעלע קאלט וואסער אין דעם נאמען פון א תלמיד, באמת זאג איך אייך; ער וועט בשום אופן נישט פארלירן זיין שכר! ");
INSERT INTO ydd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","און עס איז געשען, ווען יהושע/ישוע האט געענדיקט באפעלן זיינע צוועלף תלמידים, איז ער פון דארטן אוועק צו לערנען און אויסצורופן אין זייערע שטעט. ");
INSERT INTO ydd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ווען אבער יוחנן האט געהערט אין תפיסה די מעשים פון דעם משיח, האט ער געשיקט דורך זיינע תלמידים. ");
INSERT INTO ydd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","און געזאגט צו אים: ביסטו דער, וואס זאל קומען, אדער האבן מיר צו ווארטן אויף אן אנדערן? ");
INSERT INTO ydd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","און יהושע/ישוע האט ענטפערנדיק געזאגט צו זיי: גייט און דערציילט יוחנן וואס איר הערט און זעט: ");
INSERT INTO ydd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","בלינדע זען, און לאמע גייען ארום, מצורעדיקע ווערן גערייניקט, און טויבע הערן, און טויטע שטייען אויף, און צו ארעמעלייט ווערט אנגעזאגט די גוטע בשורה. ");
INSERT INTO ydd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","און וואויל איז דעם, וואס וועט נישט שטרויכלען אין מיר! ");
INSERT INTO ydd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","און בשעת די דאזיקע זענען אוועקגעגאנגען, האט יהושע/ישוע אנגעהויבן צו זאגן צו די המונים מענטשן וועגן יוחנן: וואס זענט איר ארויסגעגאנגען אין דער מדבר אריין זען? א שטעקל געשאקלט פון ווינט? ");
INSERT INTO ydd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","נאר וואס דען זענט איר ארויסגעגאנגען זען? א מענטשן אנגעטאן אין פיינע מלבושים? זע, די וואס טראגן פיינע מלבושים, זענען אין די הייזער פון די מלכים! ");
INSERT INTO ydd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","נאר וואס דען זענט איר ארויסגעגאנגען? צו זען א נביא? יא, איך זאג אייך, און מער ווי א נביא. ");
INSERT INTO ydd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","דאס איז ער, וועגן וועמען עס שטייט געשריבן: זע, איך שיק מיין שליח פאר דיין פנים, ער וועט צוגרייטן דיין וועג פאר דיר. ");
INSERT INTO ydd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","באמת זאג איך אייך, עס איז נישט אויפגעשטאנען צווישן די ילודי אשה קיין גרעסערער ווי יוחנן פון דער (ירדן) מקווה. דאך איז דער קלענסטער אין דעם מלכות השמים גרעסער ווי ער. ");
INSERT INTO ydd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","אבער פון די טעג פון יוחנן פון דער (ירדן) מקווה ביז איצט ליידט דאס מלכות השמים געוואלד, און די, וואס טאן געוואלד רייסן עס צו זיך. ");
INSERT INTO ydd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","מחמת אלע נביאים און די תורה האבן נבואות געזאגט ביז יוחנן. ");
INSERT INTO ydd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","און אויב איר ווילט עס אננעמען, איז ער אליהו, וואס דארף קומען. ");
INSERT INTO ydd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ווער עס האט אויערן, דער זאל הערן! ");
INSERT INTO ydd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","צו וועמען אבער זאל איך פארגלייכן דאס דאזיקע דור? עס איז גלייך צו קינדער, וואס זיצן אויף די מארקן און רופן צו זייערע חברים, ");
INSERT INTO ydd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","און זאגן; מיר האבן געשפילט פאר אייך אויף פייפלעך, און איר האט נישט געטאנצט; מיר האבן געזונגען קלאגלידער, און איר האט נישט געוויינט! ");
INSERT INTO ydd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","מחמת יוחנן איז געקומען, האט נישט געגעסן און נישט געטרונקען, און מען זאגט: ער האט א בייזן גייסט! ");
INSERT INTO ydd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","דער בר אנש איז געקומען, עסט און טרינקט יא; און מען זאגט: זע, א מענטש א זולל וסובא, א פריינד פון שטייער אויפמאנער און חוטאים! און דאך איז די חכמה גערעכטפערטיקט פון אירע מעשים. ");
INSERT INTO ydd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","דעמאלט האט ער אנגעהויבן צו מוסרן די שטעט, אין וועלכע דאס רוב פון זיינע וואונדער זענען געשען, ווייל זיי האבן נישט תשובה געטאן. ");
INSERT INTO ydd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","וויי צו דיר, כורזין! וויי צו דיר, בית‑צידה! ווייל אויב אין צור און צידון וואלטן געשען די וואונדער, וואס זענען געשען ביי אייך, וואלטן זיי שוין לאנג צוריק געהאט תשובה געטאן אין זאק און אין אש. ");
INSERT INTO ydd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","דאך זאג איך אייך, עס וועט זיין גרינגער פאר צור און צידון אין טאג פון משפט, ווי פאר אייך! ");
INSERT INTO ydd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","און דו, כפר‑נחום, ביז צום הימל וועסטו זיין דערהייבט? ביז צו שאול תחתית וועסטו אראפנידערן. ווייל אויב אין סדום וואלטן געשען די וואונדער, וואס זענען געשען אין דיר, וואלט זי שטיין געבליבן ביז צום היינטיקן טאג! ");
INSERT INTO ydd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","דאך זאג איך אייך, אז עס וועט זיין גרינגער פאר דעם לאנד פון סדום אינם טאג פון משפט, ווי פאר דיר! ");
INSERT INTO ydd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","אין יענער צייט האט יהושע/ישוע ענטפערנדיק געזאגט: איך לויב דיך, פאטער, האר פון הימל און ערד, אז דו האסט פארבארגן די דאזיקע זאכן פון די חכמים און נבונים, און זיי אנטפלעקט צו קליינע קינדער! ");
INSERT INTO ydd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","יא, פאטער, ווייל אזוי איז עס געווען וואוילגעפעלן פאר דיר. ");
INSERT INTO ydd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","אלץ איז מיר איבערגעגעבן געווארן פון מיין פאטער, און קיינער קען נישט דעם זון אחוץ דער פאטער; און קיינער קען נישט דעם פאטער אחוץ דער זון, און וועמען דער זון וויל אים מגלה זיין. ");
INSERT INTO ydd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","קומט צו מיר אלע, וואס הארעווען שווער און זענען באלאסטעט, און איך וועל אייך געבן רו. ");
INSERT INTO ydd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","נעמט מיין יאך אויף זיך, און לערנט פון מיר; ווייל איך בין אן ענו און פון א נידריק געמיט, און איר וועט געפינען מנוחה פאר אייערע נשמות. ");
INSERT INTO ydd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","מחמת מיין יאך איז אנגענעם, און מיין לאסט איז גרינג! ");
INSERT INTO ydd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","אין יענער צייט איז יהושע/ישוע א שבת געגאנגען דורך די קארנפעלדער; זיינע תלמידים אבער האט געהונגערט, און זיי האבן אנגעהויבן אפצורייסן זאנגען, און צו עסן. ");
INSERT INTO ydd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","און ווען די פרושים האבן עס געזען, האבן זיי געזאגט צו אים: זע, דיינע תלמידים טאן, וואס מען טאר שבת נישט טאן! ");
INSERT INTO ydd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ער אבער האט צו זיי געזאגט: צי האט איר נישט געלייענט, וואס דוד האט געטאן, ווען עס האט אים געהונגערט און די, וואס זענען געווען מיט אים? ");
INSERT INTO ydd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ווי ער איז אריינגעגאנגען אין ה׳ס הויז, און זיי האבן געגעסן דאס לחם הפנים, וואס עס איז נישט געווען מותר פאר אים צו עסן, נישט פאר די, וואס זענען געווען מיט אים, אחוץ בלויז פאר די כהנים? ");
INSERT INTO ydd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","אדער האט איר נישט געלייענט אין דער תורה, אז אלע שבת זענען די כהנים מחלל שבת אין בית המקדש, און פארזינדיקן זיך דאך נישט? ");
INSERT INTO ydd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","איך זאג אייך אבער, אז דא איז דא איינער, וואס איז גרעסער ווי דאס בית המקדש! ");
INSERT INTO ydd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","און אויב איר וואלט געוואוסט, וואס עס הייסט: איך באגער בארעמהארציקייט, און נישט קיין קרבן, וואלט איר נישט פארמשפט די אומשולדיקע. (הושע ו׳ ו.) ");
INSERT INTO ydd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","מחמת דער בר אנש איז האר איבער דעם שבת. ");
INSERT INTO ydd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","און ער איז אוועק פון דארטן, און איז געגאנגען אין זייער שול אריין. ");
INSERT INTO ydd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","און זע, דארט איז געווען א מענטש מיט א פארדארטער האנט. און זיי האבן אים געפרעגט, אזוי צו זאגן: מעג מען שבת היילן? כדי זיי זאלן קענען אים באשולדיקן. ");
INSERT INTO ydd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ער אבער האט צו זיי געזאגט: וועלכער איז דער מענטש צווישן אייך, וואס וועט האבן איין שאף, און אויב די דאזיקע וועט שבת אריינפאלן אין א גרוב, וועט ער זי דען נישט אנכאפן, און ארויסשלעפן? ");
INSERT INTO ydd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","און וויפל איז א מענטש מער ווערט ווי א שאף! דעריבער מעג מען שבת טאן גוטס. ");
INSERT INTO ydd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","דעמאלט זאגט ער צו דעם מענטשן: שטרעק אויס דיין האנט! און ער האט זי אויסגעשטרעקט; און זי איז ווידער געווארן געזונט ווי די אנדערע. ");
INSERT INTO ydd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","די פרושים אבער זענען ארויסגעגאנגען, און האבן זיך באראטן קעגן אים, ווי אזוי זיי זאלן אים אומברענגען. ");
INSERT INTO ydd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","יהושע/ישוע האט זיך אבער דערפון דערוואוסט, און איז אוועק פונדאנען; און א סך האבן אים נאכגעפאלגט, און ער האט זיי אלע געהיילט, ");
INSERT INTO ydd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","און זיי שטרענג אנגעזאגט, אז זיי זאלן אים נישט מפרסם זיין, ");
INSERT INTO ydd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","כדי עס זאל דערפילט ווערן, וואס עס איז געזאגט געווארן דורך ישעיהו הנביא, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","זע, מיין קנעכט, וועמען איך האב אויסדערוויילט; מיין געליבטער, אין וועמען מיין נפש האט א וואוילגעפעלן; איך וועל געבן מיין גייסט אויף אים, און ער וועט דערקלערן משפט צו די פעלקער. ");
INSERT INTO ydd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ער וועט זיך נישט קריגן, און וועט אויך נישט שרייען; און קיינער וועט נישט הערן זיין קול אויף די גאסן. ");
INSERT INTO ydd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","א צעשפאלטן שטעקל וועט ער נישט צעברעכן, און טליענדיקן פלאקס וועט ער נישט אויסלעשן, ביז ער וועט אויספירן משפט צום זיג. ");
INSERT INTO ydd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","און אויף זיין נאמען וועלן די אומות (העולם) האפן. ");
INSERT INTO ydd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","דעמאלט האט מען צו אים געברענגט א באזעסענעם מיט א בייזן גייסט, בלינד און שטום, און ער האט אים געהיילט, אז דער שטומער האט סיי גערעדט סיי געזען. ");
INSERT INTO ydd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","און די אלע המונים מענטשן האבן געשטוינט, און געזאגט: איז ער נישט אפשר דער בן דוד? ");
INSERT INTO ydd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ווען די פרושים אבער האבן עס געהערט, האבן זיי געזאגט: ער טרייבט נישט ארויס קיין בייזע גייסטער, אחוץ דורך דעם בעל‑זבול, דעם שר פון די בייזע גייסטער! ");
INSERT INTO ydd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","און וויסנדיק זייערע געדאנקען, האט ער צו זיי געזאגט: יעדע מלוכה, וואס איז נישט אייניק מיט זיך אליין, ווערט פארוויסט; און יעדע שטאט אדער הויז, וואס איז נישט אייניק מיט זיך אליין, וועט נישט בלייבן שטיין. ");
INSERT INTO ydd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","און אויב דער שׂטן טרייבט ארויס דעם שׂטן, איז ער נישט אייניק מיט זיך אליין: ווי אזוי זשע וועט זיין קעניגרייך האבן א קיום? ");
INSERT INTO ydd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","און אויב איך טרייב ארויס בייזע גייסטער דורך דעם בעל‑זבול, דורך וועמען טרייבן אייערע קינדער זיי ארויס? דערפאר וועלן זיי זיין אייערע שופטים. ");
INSERT INTO ydd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","אויב אבער איך טרייב ארויס די בייזע גייסטער דורך דעם גייסט פון ה׳, אזוי איז שוין ה׳ס קעניגרייך געקומען צו אייך. ");
INSERT INTO ydd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","אדער ווי אזוי קען עמיצער אריינגיין אין דעם הויז פון דעם גיבור, און אוועקרויבן זיינע זאכן, אויב ער וועט נישט קודם כל בינדן דעם גיבור? און דעמאלט וועט ער אויסרויבן זיין הויז. ");
INSERT INTO ydd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ווער עס איז נישט מיט מיר, דער איז קעגן מיר; און דער, וואס זאמלט נישט איין מיט מיר, צעשפרייט. ");
INSERT INTO ydd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","דערפאר זאג איך אייך: יעדע זינד און לעסטערונג וועט די מענטשן פארגעבן ווערן; נאר די לעסטערונג פון דעם גייסט וועט נישט פארגעבן ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","און אויב עס וועט ווער זאגן א ווארט קעגן דעם בר אנש, וועט עס אים פארגעבן ווערן; נאר ווער עס וועט רעדן קעגן דעם רוח הקודש, וועט עס אים נישט פארגעבן ווערן, נישט אין דער דאזיקער וועלט, נישט לעולם הבא. ");
INSERT INTO ydd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","אדער מאכט דעם בוים גוט, און זיין פרוכט גוט; אדער מאכט דעם בוים שלעכט, און זיין פרוכט שלעכט! מחמת פון די פירות דערקענט מען דעם בוים. ");
INSERT INTO ydd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","איר שלאנגענקינדער, ווי אזוי קענט איר רעדן גוטס, זייענדיק (אליין) בייז? מחמת פון דער שפע פון דעם הארץ, רעדט דאך דאס מויל. ");
INSERT INTO ydd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","דער גוטער מענטש ברענגט ארויס גוטע זאכן פון זיין גוטן אוצר, און דער בייזער מענטש ברענגט ארויס בייז פון זיין בייזן אוצר. ");
INSERT INTO ydd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","איך זאג אייך אבער, אז יעדעס פוסטע ווארט, וואס מענטשן וועלן רעדן, וועלן זיי מוזן אפגעבן א חשבון דערפון אינם יום הדין. ");
INSERT INTO ydd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","מחמת פון דיינע ווערטער וועסטו גערעכטפערטיקט ווערן, און פון דיינע ווערטער וועסטו פארמשפט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","דעמאלט האבן אים אייניקע פון די סופרים און פרושים געענטפערט, אזוי צו זאגן: רבי, מיר ווילן זען א צייכן פון דיר! ");
INSERT INTO ydd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ער אבער האט ענטפערנדיק צו זיי געזאגט: א בייז און נואפדיק דור באגערט א צייכן, און קיין צייכן וועט אים נישט געגעבן ווערן אחוץ דאס צייכן פון יונה הנביא. ");
INSERT INTO ydd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ווייל אזוי ווי יונה איז געווען דריי טעג און דריי נעכט אין די געדערעם פון דעם ריזנפיש, אזוי וועט דער בר אנש זיין דריי טעג און דריי נעכט אין דעם הארץ פון דער ערד. ");
INSERT INTO ydd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","די לייט פון נינוה וועלן אויפשטיין אין דעם משפט מיט דעם דאזיקן דור, און וועלן עס פאראורטיילן; ווייל זיי האבן תשובה געטאן אויף יונהס רוף; און זע, א גרעסערער ווי יונה איז דא דא. ");
INSERT INTO ydd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","די מלכה פון תימן וועט אויפשטיין אין דעם משפט מיט דעם דאזיקן דור, און וועט עס פאראורטיילן; ווייל זי איז געקומען פון עק וועלט צו הערן שלמהס חכמה; און זע, א גרעסערער ווי שלמה איז דא דא. ");
INSERT INTO ydd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ווען אבער דער אומריינער גייסט גייט ארויס פון דעם מענטשן, גייט ער איבער ערטער, וואו עס איז קיין וואסער נישטא, זוכנדיק מנוחה, און געפינט נישט. ");
INSERT INTO ydd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","זאגט ער דעמאלט; איך וועל מיך אומקערן אין מיין הויז אריין, פונוואנען איך בין ארויסגעגאנגען; און ווען ער קומט, געפינט ער עס ליידיק, אויסגעקערט, און אויסגעצירט. ");
INSERT INTO ydd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","דאן גייט ער, און נעמט מיט זיך זיבן אנדערע גייסטער, ערגערע ווי ער אליין, און זיי גייען אריין און וואוינען דארט; און דער סוף פון יענעם מענטשן ווערט ערגער ווי דער אנהויב. אָט אזוי וועט עס זיין מיט דעם דאזיקן בייזן דור. ");
INSERT INTO ydd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","און בשעת ער האט נאך גערעדט צו די המונים מענטשן, זע, זיין מוטער און זיינע ברידער זענען געשטאנען אינדרויסן, און האבן באגערט צו רעדן מיט אים. ");
INSERT INTO ydd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","און עמיצער האט צו אים געזאגט: זע, דיין מוטער און דיינע ברידער שטייען אינדרויסן, און ווילן רעדן מיט דיר. ");
INSERT INTO ydd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ער אבער האט ענטפערנדיק געזאגט צו דעם, וואס האט עס אים געזאגט: ווער איז מיין מוטער, און ווער זענען מיינע ברידער? ");
INSERT INTO ydd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","און האט אויסגעשטרעקט זיין האנט אויף זיינע תלמידים, און געזאגט: זע, מיין מוטער און מיינע ברידער! ");
INSERT INTO ydd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","מחמת ווער עס וועט טאן דעם רצון פון מיין פאטער, וואס איז אין הימל, דער זעלביקער איז מיין ברודער, און שוועסטער, און מוטער! ");
INSERT INTO ydd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","אין יענעם טאג איז יהושע/ישוע ארויסגעגאנגען פון הויז, און האט זיך אנידערגעזעצט ביים ים. ");
INSERT INTO ydd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","און גרויסע המונים מענטשן האבן זיך פארזאמלט צו אים, אז ער איז איינגעשטיגן אין א שיפל, און האט זיך אנידערגעזעצט; און די גאנצע מאסע מענטשן איז געשטאנען ביים ברעג. ");
INSERT INTO ydd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","און ער האט גערעדט צו זיי א סך זאכן מיט משלים, אזוי צו זאגן: זע, דער זייער איז ארויסגעגאנגען צו זייען; ");
INSERT INTO ydd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","און בשעת ער האט געזייט, איז אביסל (פון דער זריעה) געפאלן ביים וועג, און די פייגל זענען געקומען און האבן עס איינגעשלונגען. ");
INSERT INTO ydd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","אן אנדער ביסל איז געפאלן אויף שטייניקע ערטער, וואו עס האט נישט געהאט קיין סך ערד; און עס האט באלד ארויסגעשפראצט, דערפאר וואס עס האט נישט געהאט קיין טיפע ערד; ");
INSERT INTO ydd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ווען אבער די זון איז אויפגעגאנגען, איז עס פארוועלקט געווארן, און צוליב דעם וואס עס האט נישט געהאט קיין ווארצל, איז עס פארדארט געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","און אן אנדער ביסל איז געפאלן צווישן די דערנער; און די דערנער זענען אויפגעוואקסן, און האבן עס דערשטיקט. ");
INSERT INTO ydd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","אן אנדער ביסל איז אבער געפאלן אויף דער גוטער ערד, און עס האט געברענגט פרוכט, איינס הונדערטפאכיק, איינס זעכציקפאכיק, און איינס דרייסיקפאכיק. ");
INSERT INTO ydd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ווער עס האט אויערן, דער זאל הערן! ");
INSERT INTO ydd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","און די תלמידים זענען צוגעקומען, און האבן געזאגט צו אים: פארוואס רעדסטו צו זיי אין משלים? ");
INSERT INTO ydd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","און ער האט ענטפערנדיק געזאגט: ווייל צו אייך איז געגעבן געווארן צו וויסן די סודות פון דעם מלכות השמים, צו יענע אבער איז עס נישט געגעבן געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","מחמת ווער עס האט, דעם וועט געגעבן ווערן, און ער וועט האבן א שפע; ווער אבער עס האט נישט, פון דעם וועט אויך אוועקגענומען ווערן, וואס ער האט יא. ");
INSERT INTO ydd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","דערפאר רעד איך צו זיי אין משלים; ווייל זיי קוקן און זען דאך נישט, און הערן און הערן דאך נישט, און פארשטייען אויך נישט. ");
INSERT INTO ydd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","און אויף זיי ווערט דערפילט ישעיהוס נבואה, וואס זאגט: מיט די אויערן וועט איר הערן, און נישט פארשטיין, און קוקנדיק וועט איר קוקן, און דאך נישט זען! ");
INSERT INTO ydd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","מחמת פעט געווארן איז דאס הארץ פון דעם דאזיקן פאלק, און מיט די אויערן הערן זיי שווער, און זייערע אויגן האבן זיי צוגעמאכט; טאמער וואלטן זיי געזען מיט די אויגן, און מיט די אויערן געהערט, און מיטן הארצן פארשטאנען, און זיך אומגעקערט, און איך וואלט זיי געהיילט. ");
INSERT INTO ydd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","אבער וואויל איז אייערע אויגן, ווייל זיי זען; און אייערע אויערן, ווייל זיי הערן. ");
INSERT INTO ydd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","מחמת באמת זאג איך אייך, אז א סך נביאים און צדיקים האבן געגארט צו זען, וואס איר זעט, און האבן עס נישט געזען; און צו הערן, וואס איר הערט, און האבן עס נישט געהערט. ");
INSERT INTO ydd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","דעריבער זאלט איר הערן דאס משל פון דעם זייער. ");
INSERT INTO ydd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ווען עמיצער הערט דאס ווארט פון דעם מלכות, און פארשטייט עס נישט, קומט דער נישט גוטער און רייסט אויס דאס, וואס איז געזייט געווארן אין זיין הארצן. דאס איז דער, וואס איז געזייט געווארן ביים וועג. ");
INSERT INTO ydd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","און דער, וואס איז געזייט געווארן אויף שטייניקע ערטער, דאס איז דער, וואס הערט דאס ווארט, און נעמט עס גלייך אויף מיט שמחה; ");
INSERT INTO ydd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ער האט אבער נישט קיין שורש אין זיך, נאר איז לפי שעה. און קומט א צרה אדער רדיפה צוליב דעם ווארט, שטרויכלט ער באלד. ");
INSERT INTO ydd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","און דער, וואס איז געזייט צווישן די דערנער, דאס איז דער, וואס הערט דאס ווארט, און די זארג פון דער וועלט, און די פארפירערישקייט פון עשירות דערשטיקט דאס ווארט, און עס בלייבט אָן פירות. ");
INSERT INTO ydd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","דער אבער, וואס איז געזייט אויף דער גוטער ערד, דאס איז דער וואס הערט דאס ווארט, און פארשטייט עס; ער ברענגט שוין יא פירות, און איינער ברענגט הונדערטפאכיק, און איינער זעכציקפאכיק, און איינער דרייסיק. ");
INSERT INTO ydd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","אן אנדער משל האט ער פאר זיי פארגעלייגט, אזוי צו זאגן: דאס מלכות השמים איז גלייך צו א מענטשן, וואס האט געזייט גוטן זאמען אין זיין פעלד. ");
INSERT INTO ydd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","און בשעת די לייט זענען געשלאפן, איז געקומען זיין שונא און האט פארזייט אומקרויט צווישן דעם ווייץ, און איז אוועקגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","און ווען דאס גראז האט אויפגעשפראצט, און געברענגט פרוכט, האט זיך דעמאלט אויך דאס אומקרויט באוויזן. ");
INSERT INTO ydd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","און די קנעכט פון דעם בעל הבית זענען צוגעגאנגען און האבן געזאגט צו אים: האר, צי האסטו דען נישט געזייט גוטע זריעה אין דיין פעלד? פונוואנען זשע האט עס אומקרויט? ");
INSERT INTO ydd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ער אבער האט צו זיי געזאגט: דאס האט א מענטש, א שונא, געטאן! זאגן די קנעכט צו אים: צי ווילסטו זשע אז מיר זאלן גיין און עס אויסרייסן? ");
INSERT INTO ydd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","זאגט ער: ניין, טאמער, אויסרייסנדיק דאס אומקרויט, וועט איר צוגלייך דערמיט אויך אויסווארצלען דעם ווייץ. ");
INSERT INTO ydd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","לאזט ביידע וואקסן צוזאמען ביז צום שניט, און אין דער צייט פון שניט וועל איך זאגן צו די שניטער: רייסט צום ערשט אויס דאס אומקרויט, און בינדט עס אין בינטלעך, כדי מען זאל עס פארברענען; דעם ווייץ אבער זאמלט איין אין מיין שייער אריין. ");
INSERT INTO ydd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","אן אנדער משל האט ער פאר זיי פארגעלייגט, אזוי צו זאגן: דאס מלכות השמים איז גלייך צו א זענעפט קערנדל, וואס א מענטש האט גענומען, און געזייט אין זיין פעלד. ");
INSERT INTO ydd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","דאס איז דאס קלענסטע פון אלע זריעות; נאר ווען עס וואקסט אויף, איז עס גרעסער ווי אלע קרייטעכצער, און עס ווערט א בוים, אז די פייגל פון הימל קומען און מאכן זיך נעסטן אין זיינע צווייגן. ");
INSERT INTO ydd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","אן אנדער משל האט ער צו זיי געזאגט: דאס מלכות השמים איז גלייך צו זויערטייג, וואס א פרוי האט גענומען, און באהאלטן אין דריי מאס זעמל מעל, ביז עס וועט אינגאנגצן דורכגעזויערט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","דאס אלץ האט יהושע/ישוע גערעדט צו די המונים מענטשן אין משלים; און אָן א משל האט ער צו זיי גארנישט גערעדט, ");
INSERT INTO ydd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","כדי עס זאל דערפילט ווערן, וואס איז געזאגט געווארן דורך דעם נביא, אזוי צו זאגן: איך וועל אויפעפענען מיין מויל אין משלים; איך וועל ארויסרעדן רעטענישן פון פארצייטנס. ");
INSERT INTO ydd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","דעמאלט האט ער אוועקגעשיקט די המונים מענטשן, און איז אריינגעגאנגען אין הויז. און זיינע תלמידים זענען געקומען צו אים, און האבן געזאגט: באשייד אונדז דאס משל פון דעם אומקרויט פון פעלד. ");
INSERT INTO ydd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","און ער האט ענטפערנדיק געזאגט: דער, וואס זייט דעם גוטן זאמען, איז דער בר אנש; ");
INSERT INTO ydd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","און דאס פעלד איז די וועלט; און דער גוטער זאמען, דאס זענען די קינדער פון דעם מלכות; דאס אומקרויט אבער זענען די קינדער פון דעם נישט גוטן; ");
INSERT INTO ydd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","און דער שונא, וואס האט עס געזייט, איז דער שׂטן; און דער שניט איז דער קץ פון דער וועלט; און די שניטער זענען מלאכים. ");
INSERT INTO ydd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","דעריבער ווי מען רייסט אויס דאס אומקרויט און מען פארברענט עס אין פייער, וועט עס אויך אזוי זיין ביים קץ פון דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","דער בר אנש וועט ארויסשיקן זיינע מלאכים, און זיי וועלן איינזאמלען פון זיין מלכות אלע מיכשולים און די, וואס טאן רשעות, ");
INSERT INTO ydd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","און וועלן זיי ווארפן אין דעם אויוון פון פייער אריין; דארטן וועט זיין דאס קלאגן און קריצן מיט די ציין. ");
INSERT INTO ydd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","דעמאלט וועלן די צדיקים לויכטן ווי די זון אין דעם קעניגרייך פון זייער פאטער. ווער עס האט אויערן, דער זאל הערן. ");
INSERT INTO ydd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","דאס מלכות השמים איז גלייך צו א פארבארגענעם אוצר אין א פעלד; וואס א מענטש האט געפונען, און פארבארגן; און פאר פרייד גייט ער און פארקויפט אלץ, וואס ער האט, און קויפט יענץ פעלד. ");
INSERT INTO ydd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ווידער איז דאס מלכות השמים גלייך צו א סוחר, וואס זוכט שיינע פערל. ");
INSERT INTO ydd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","און ווען ער האט געפונען איינע, א זייער טייערע פערל, איז ער געגאנגען און פארקויפט אלץ, וואס ער האט געהאט, און האט זי געקויפט. ");
INSERT INTO ydd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ווידער איז דאס מלכות השמים גלייך צו א נעץ, וואס איז אראפגעלאזט געווארן אין ים אריין, און וואס פאנגט פון אלע מינים. ");
INSERT INTO ydd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","וואס, ווען זי איז געווארן פול, האט מען זי ארויסגעצויגן אויפן ברעג, און מען האט זיך אנידערגעזעצט, און געזאמלט די גוטע מינים אין געפעסן אריין, די שלעכטע אבער האט מען אוועקגעווארפן. ");
INSERT INTO ydd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","אָט אזוי וועט עס זיין ביים קץ פון דער וועלט. די מלאכים וועלן ארויסגיין, און וועלן אפשיידן די רשעים פון צווישן די צדיקים, ");
INSERT INTO ydd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","און זיי ווארפן אין דעם אויוון פון פייער אריין. דארטן וועט זיין דאס קלאגן און קריצן מיט די ציין. ");
INSERT INTO ydd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","האט איר דאס אלץ פארשטאנען? זאגן זיי צו אים: יא! ");
INSERT INTO ydd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","און ער האט צו זיי געזאגט: דערפאר איז יעדער איינער סופר, וואס איז געלערנט צום מלכות השמים, גלייך צו א מענטשן א בעל הבית, וואס ברענגט ארויס פון זיין אוצר נייע און אלטע זאכן. ");
INSERT INTO ydd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","און עס איז געשען, ווען יהושע/ישוע האט געענדיקט די דאזיקע משלים, איז ער פון דארטן אוועק. ");
INSERT INTO ydd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","און איז געקומען אין זיין לאנד אריין, און האט זיי געלערנט אין זייער שול, אז זיי האבן געשטוינט און געזאגט: פונוואנען האט ער די דאזיקע חכמה, און די וואונדער? ");
INSERT INTO ydd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","איז ער דען נישט דעם סטאליערס זון? הייסט דען נישט זיין מוטער מרים און זיינע ברידער יעקב און יוסף און שמעון און יהודה? ");
INSERT INTO ydd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","און זענען דען נישט אלע זיינע שוועסטער ביי אונדז? פונוואנען זשע קומט צו אים דאס אלץ? ");
INSERT INTO ydd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","און זיי זענען ניכשל געווארן אין אים. יהושע/ישוע אבער האט צו זיי געזאגט: קיין נביא איז נישט אָן כבוד, אחוץ אין זיין פאטערלאנד, און אין זיין אייגן הויז! ");
INSERT INTO ydd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","און ער האט דארטן נישט געטאן קיין סך וואונדער צוליב זייער אומגלויבן. ");
INSERT INTO ydd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","אין יענער צייט האט הורדוס דער טעטרארך געהערט פון ישועס שם, ");
INSERT INTO ydd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","און האט געזאגט צו זיינע דינער: דאס איז יוחנן פון דער (ירדן) מקווה; ער איז אויפגעשטאנען פון די טויטע; און דערפאר ווירקן אזוי די כוחות אין אים. ");
INSERT INTO ydd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","מחמת הורדוס האט דעם יוחנן געפאנגען גענומען, און אים געבונדן, און איינגעזעצט אין תפיסה, צוליב הורודיה, דאס ווייב פון זיין ברודער פיליפוס. ");
INSERT INTO ydd_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","מחמת יוחנן האט צו אים געזאגט: דו טארסט זי נישט האבן. ");
INSERT INTO ydd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","און ער האט אים געוואלט טייטן, און האט זיך געפארכטן פאר דעם המון, ווייל מען האט אים געהאלטן פאר א נביא. ");
INSERT INTO ydd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","נאר ווען מען האט געפייערט הורדוסנס געבוירנטאג, האט הורודיהס טאכטער געטאנצט פאר די געסט און איז הורדוסן וואוילגעפעלן. ");
INSERT INTO ydd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","דערפאר האט ער צוגעזאגט מיט א שבועה, איר צו געבן, וואס זי וועט פארלאנגען. ");
INSERT INTO ydd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","און ווייל זי איז געווען פון פריער אנגערעדט פון איר מוטער, האט זי געזאגט: גיב מיר דא אויף א טעלער יוחנן פון דער (ירדן) מיקווהס קאפ. ");
INSERT INTO ydd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","און דער קעניג איז טרויעריק געווארן; נאר צוליב די שבועות און די געסט, האט ער באפוילן עס זאל געגעבן ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","און ער האט געשיקט, און געלאזט יוחנן אפהאקן דעם קאפ אין תפיסה. ");
INSERT INTO ydd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","און זיין קאפ איז געברענגט געווארן אויף א טעלער, און געגעבן געווארן דעם מיידל, און זי האט אים געברענגט צו איר מוטער. ");
INSERT INTO ydd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","און זיינע תלמידים זענען געקומען, און האבן גענומען דעם גוף, און אים קובר געווען; און זענען געגאנגען און האבן עס דערציילט יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","און ווי יהושע/ישוע האט דאס געהערט, איז ער פון דארטן אוועק אין א שיפל, אויף א מדבריותדיק ארט איינער אליין. און ווען די המונים מענטשן האבן עס געהערט, האבן זיי אים נאכגעפאלגט צופוס פון די שטעט. ");
INSERT INTO ydd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","און ער איז ארויסגעקומען, און האט געזען א גרויסן המון מענטשן, און זיך דערבארעמט אויף זיי און געהיילט זייערע קראנקע. ");
INSERT INTO ydd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","און אנטקעגן אוונט זענען די תלמידים געקומען צו אים, און האבן געזאגט; דאס איז א וויסט ארט, און די שעה איז שוין פארביי; לאז דעריבער אפ די מאסן מענטשן, כדי זיי זאלן גיין אין די דערפער אריין, און זיך קויפן שפייז. ");
INSERT INTO ydd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","יהושע/ישוע אבער האט צו זיי געזאגט: זיי האבן נישט נייטיק אוועקצוגיין; גיט איר זיי צו עסן! ");
INSERT INTO ydd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","זאגן זיי צו אים: מיר האבן דא גארנישט אחוץ פינף לעבלעך ברויט, און צוויי פיש. ");
INSERT INTO ydd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","און ער האט געזאגט: ברענגט זיי אהער צו מיר. ");
INSERT INTO ydd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","און ער האט באפוילן די המונים מענטשן זיך אנידערצוזעצן אויפן גראז; און האט גענומען די פינף לעבלעך ברויט, און די צוויי פיש, האט ארויפגעבליקט צום הימל און געמאכט א ברכה, און האט צעבראכן און געגעבן די תלמידים די ברויטן, און די תלמידים צו די מאסן מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","און אלע האבן געגעסן, און זענען זאט געווארן, און זיי האבן אויפגעהויבן, וואס איז איבערגעבליבן פון די ברעקלעך, צוועלף קערב פול. ");
INSERT INTO ydd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","און די, וואס האבן געגעסן, זענען געווען אן ערך פינף טויזנט מענער, אחוץ פרויען און קינדער. ");
INSERT INTO ydd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","און ער האט גלייך געצוואונגען די תלמידים איינצושטייגן אין דעם שיפל, און אריבערצופארן פאר אים אויף יענער זייט ים, ביז ער וועט אפלאזן די המונים מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","און ווען ער האט געהאט אוועקגעשיקט די מאסן, איז ער ארויפגעגאנגען אויפן בארג, כדי אליין תפילה צו טאן; און ווען עס איז געווארן אוונט, איז ער דארטן געווען איינער אליין. ");
INSERT INTO ydd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","דאס שיפל אבער איז שוין געווען א סך מיילן פון דער יבשה, הארט געשטויסן פון די כוואליעס; מחמת דער ווינט איז געווען אנטקייגן. ");
INSERT INTO ydd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","און אין דעם פערטן משמר פון דער נאכט איז ער געקומען צו זיי, גייענדיק אויפן ים. ");
INSERT INTO ydd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","און ווי די תלמידים האבן אים דערזען ארומגיין אויפן ים, האבן זיי זיך דערשראקן, און געזאגט: עס איז א געשפענסט! און האבן געשריגן אויס מורא. ");
INSERT INTO ydd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","יהושע/ישוע אבער האט גלייך צו זיי גערעדט, אזוי צו זאגן: זייט געטרייסט! איך בין עס; האט נישט קיין מורא! ");
INSERT INTO ydd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","פעטרוס אבער האט ענטפערנדיק צו אים געזאגט: האר, אויב דו ביסט עס, באפעל מיך קומען צו דיר אויפן וואסער! ");
INSERT INTO ydd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","און ער האט געזאגט: קום! און פעטרוס איז אראפגעגאנגען פון שיפל, און איז געגאנגען אויפן וואסער, און געקומען צו יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","און ווי ער האט געזען דעם שטארקן ווינט, האט ער זיך דערשראקן, און אנהויבנדיק זיך צו טרענקען, האט ער א געשריי געטאן, אזוי צו זאגן: האר, ראטעווע מיך! ");
INSERT INTO ydd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","און יהושע/ישוע האט גלייך אויסגעשטרעקט זיין האנט, האט אים אנגעכאפט, און זאגט צו אים: דו קליינגלויביקער, פארוואס האסטו געצווייפלט? ");
INSERT INTO ydd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","און ווען זיי זענען איינגעשטיגן אין שיפל, האט דער ווינט אויפגעהערט. ");
INSERT INTO ydd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","און די, וואס זענען געווען אין שיפל, האבן זיך געבוקט צו אים, און געזאגט: דו ביסט באמת ה׳ס זון! ");
INSERT INTO ydd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","און זיי זענען אריבערגעפארן, און זענען געקומען צום לאנד גניסרת. ");
INSERT INTO ydd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","און ווי די לייט פון יענעם ארט האבן אים דערקענט, האבן זיי געשיקט אין יענער גאנצער געגנט ארום, און געברענגט צו אים אלע קראנקע; ");
INSERT INTO ydd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","און האבן אים געבעטן, אז זיי זאלן בלויז אנרירן די זוים פון זיין מלבוש; און אלע, וואס האבן אנגערירט, זענען גאנץ געזונט געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","דעמאלט קומען צו יהושען/ישוען פרושים און סופרים פון ירושלים, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","פארוואס זענען דיינע תלמידים עובר אויף דער מסורה פון די זקנים? מחמת זיי וואשן זיך נישט די הענט, ווען זיי עסן ברויט. ");
INSERT INTO ydd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ער אבער האט ענטפערנדיק צו זיי געזאגט: פארוואס זענט איר אויך עובר ה׳ס געבאט צוליב אייער מסורה? ");
INSERT INTO ydd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","מחמת ה׳ האט געזאגט: דו זאלסט אפגעבן כבוד דיין פאטער און דיין מוטער! און: ווער עס פלוכט פאטער אדער מוטער, דער זאל געטייט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","און איר זאגט: ווער עס וועט זאגן צום פאטער אדער צו דער מוטער: דאס איז א קרבן, וואס דו וואלסט פון מיר געקענט נהנה זיין, ");
INSERT INTO ydd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","דער איז מער נישט מחייב אפצוגעבן כבוד זיין פאטער אדער זיין מוטער. און איר האט אפגעשאפט ה׳ס ווארט דורך אייער מסורה. ");
INSERT INTO ydd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","איר צבועקעס! וואויל האט ישעיה אויף אייך נבואות געזאגט, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","דאס דאזיקע פאלק גיט מיר אפ כבוד מיט די ליפן; אבער זייער הארץ איז ווייט פון מיר. ");
INSERT INTO ydd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","אומזיסט איז זייער יראה פאר מיר, ווייל זיי לערנען ווי מצוות מענטשלעכע לערעס. ");
INSERT INTO ydd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","און ער האט גערופן צו זיך דעם המון מענטשן, און צו זיי געזאגט: הערט, און פארשטייט! ");
INSERT INTO ydd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","נישט דאס, וואס גייט אריין אין מויל, מאכט דעם מענטשן טמא; נאר דאס, וואס קומט ארויס פון מויל, דאס דאזיקע מאכט טמא דעם מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","דעמאלט זענען די תלמידים געקומען, און געזאגט צו אים: ווייסט, אז די פרושים האבן געשטרויכלט הערנדיק דאס ווארט? ");
INSERT INTO ydd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ער אבער האט ענטפערנדיק געזאגט: יעדע פלאנץ, וואס מיין הימלישער פאטער האט נישט געפלאנצט, וועט אויסגעווארצלט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","לאזט זיי גיין! זיי זענען בלינדע פירער פון בלינדע. און ווען א בלינדער פירט א בלינדן, וועלן ביידע אריינפאלן אין גרוב אריין. ");
INSERT INTO ydd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","און פעטרוס האט ענטפערנדיק געזאגט צו אים: לייג אונדז אויס דאס משל! ");
INSERT INTO ydd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ער אבער האט געזאגט: זענט איר אויך נאך אָן פארשטאנד? ");
INSERT INTO ydd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","צי זעט איר דען נישט איין, אז אלץ, וואס גייט אריין אין מויל, נידערט אראפ אין בויך, און ווערט ארויסגעווארפן אין בית הכסא אריין? ");
INSERT INTO ydd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","די זאכן אבער וואס קומען ארויס פון מויל קומען אויסן הארצן ארויס; און זיי מאכן דעם מענטשן טמא. ");
INSERT INTO ydd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","מחמת פון הארצן קומען ארויס בייזע מחשבות, מערדערייען, ניאופים, זנות, גנבות, פאלש עדות זאגן, לעסטערונגען. ");
INSERT INTO ydd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","די דאזיקע זאכן זענען עס, וואס זענען מטמא דעם מענטשן; אבער צו עסן מיט אומגעוואשענע הענט מאכט דעם מענטשן נישט טמא. ");
INSERT INTO ydd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","און יהושע/ישוע איז ארויסגעגאנגען פון דארטן, און איז אוועק אין די געגנטן פון צור און צידון. ");
INSERT INTO ydd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","און זע, א כנענישע פרוי איז ארויסגעקומען פון יענע גרענעצן, און האט געשריגן, אזוי צו זאגן: האר, בן דוד, דערבארם דיך אויף מיר! מיין טאכטער ווערט ביטער געפלאגט פון א בייזן גייסט! ");
INSERT INTO ydd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ער אבער האט איר נישט געענטפערט קיין ווארט. און זיינע תלמידים זענען צוגעגאנגען און האבן אים געבעטן, אזוי צו זאגן: שיק זי אוועק; ווייל זי שרייט אונדז נאך! ");
INSERT INTO ydd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ער אבער האט ענטפערנדיק געזאגט: איך בין נישט געשיקט געווארן אחוץ צו די פארלוירענע שעפעלעך פון דעם הויז ישראל. ");
INSERT INTO ydd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","זי איז אבער געקומען, און אנידערגעפאלן פאר אים, און געזאגט: האר, העלף מיר! ");
INSERT INTO ydd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","און ער האט ענטפערנדיק געזאגט: עס איז נישט שיין אוועקצונעמען דאס ברויט פון די קינדער און עס צו ווארפן פאר די הינטלעך! ");
INSERT INTO ydd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","און זי האט געזאגט: יא, האר; מחמת אפילו די הינטלעך עסן פון די ברעקלעך, וואס פאלן אראפ פון זייערע הארנס טיש. ");
INSERT INTO ydd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","דעמאלט האט יהושע/ישוע ענטפערנדיק צו איר געזאגט: אשה, דיין אמונה איז גרויס; זאל דיר געשען אזוי ווי דו ווילסט! און איר טאכטער איז געהיילט געווארן פון יענער שעה אָן. ");
INSERT INTO ydd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","און יהושע/ישוע איז אוועק פון דארטן, און איז געקומען צום ים פון גליל; און איז ארויפגעגאנגען אויפן בארג, און זיך דארט אנידערגעזעצט. ");
INSERT INTO ydd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","און עס זענען געקומען צו אים גרויסע המונים מענטשן, וואס האבן געהאט מיט זיך לאמע, בלינדע, שטומע, קאליקעס, און א סך אנדערע; און האבן זיי אנידערגעווארפן פאר זיינע פיס, און ער האט זיי געהיילט; ");
INSERT INTO ydd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","אז דער המון האט זיך געוואונדערט, זעענדיק, אז די שטומע רעדן, די קאליקעס זענען געזונט, און די לאמע גייען ארום, און די בלינדע זען; און זיי האבן אפגעגעבן א שבח צו דעם ג‑ט פון ישראל. ");
INSERT INTO ydd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","און יהושע/ישוע האט צו זיך גערופן זיינע תלמידים, און געזאגט: איך בין אינערלעך גערירט איבער דעם המון מענטשן, ווייל זיי זענען שוין דריי טעג מיט מיר און האבן נישט וואס צו עסן; און איך וויל נישט זיי אוועקשיקן פאסטנדיק, טאמער וועלן זיי אויסגיין אויפן וועג. ");
INSERT INTO ydd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","און די תלמידים זאגן צו אים: פונוואנען זאלן מיר נעמען אין דער מדבר אזויפיל ברויט, אזש צו זעטיקן אזא מאסע מענטשן? ");
INSERT INTO ydd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","און יהושע/ישוע זאגט צו זיי: וויפל לעבלעך ברויט האט איר? און זיי האבן געזאגט: זיבן, און אייניקע קליינע פישלעך. ");
INSERT INTO ydd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","און ער האט באפוילן דעם המון זיך אנידערצוזעצן אויף דער ערד; ");
INSERT INTO ydd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","און גענומען די זיבן לעבלעך ברויט און די פיש; האט געמאכט א ברכה און זיי צובראכן, און געגעבן צו די תלמידים, און די תלמידים צו די מאסן מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","און אלע האבן געגעסן, און זענען זאט געווארן; און וואס איז איבערגעבליבן פון די ברעקלעך האט מען אויפגעהויבן, זיבן גרויסע קערב. ");
INSERT INTO ydd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","און די, וואס האבן געגעסן, זענען געווען פיר טויזנט מענער, אחוץ פרויען און קינדער. ");
INSERT INTO ydd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","און ער האט אוועקגעשיקט די המונים, און איז איינגעשטיגן אין שיפל, און געקומען צו די גרענעצן פון מגדון. ");
INSERT INTO ydd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","און די פרושים און צדוקים זענען געקומען, כדי אים אויסצופרואוון, און האבן פארלאנגט, אז ער זאל זיי ווייזן אן אות מן השמים. ");
INSERT INTO ydd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ער אבער האט ענטפערנדיק צו זיי געזאגט: אין אוונט זאגט איר; עס וועט זיין שיין וועטער, מחמת דער הימל רויטלט זיך? ");
INSERT INTO ydd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","און אינדערפרי: היינט וועט זיין שטורמדיק, מחמת דער הימל רויטלט זיך און איז טריב. דאס אויסזען פון הימל פארשטייט איר אונטערצושיידן; נאר די צייכנס פון דער צייט קענט איר נישט! ");
INSERT INTO ydd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","א בייז און נואפדיק דור פארלאנגט א צייכן; און קיין צייכן וועט אים נישט געגעבן ווערן, אחוץ דאס צייכן פון יונה. און ער האט זיי איבערגעלאזט, און איז אוועקגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","און די תלמידים זענען אריבערגעקומען אויף יענער זייט ים און האבן פארגעסן מיטצונעמען ברויט. ");
INSERT INTO ydd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","און יהושע/ישוע האט צו זיי געזאגט: גיט אכטונג און היט זיך פארן זויערטייג פון די פרושים און צדוקים. ");
INSERT INTO ydd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","און זיי האבן עס איבערגעלייגט צווישן זיך, און געזאגט: דאס איז ווייל מיר האבן נישט מיטגענומען קיין ברויט. ");
INSERT INTO ydd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","און ווען יהושע/ישוע האט זיך דערוואוסט, האט ער געזאגט: אָ איר קליינגלויביקע, וואס רעדט איר צווישן זיך, ווייל איר האט נישט קיין ברויט? ");
INSERT INTO ydd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","פארשטייט איר נאך נישט, און געדענקט איר נישט די (פארברענגען מיט) פינף ברויט פון די פינף טויזנט, און וויפל קערב איר האט אויפגעהויבן? ");
INSERT INTO ydd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","אויך נישט די זיבן ברויט פאר די פיר טויזנט, און וויפל גרויסע (רביס שיריים) קערב איר האט אויפגעהויבן? ");
INSERT INTO ydd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ווי קומט עס, וואס איר פארשטייט נישט, אז איך האב נישט גערעדט צו אייך פון ברויט? היט אייך אבער פארן זויערטייג פון די פרושים און צדוקים. ");
INSERT INTO ydd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","דעמאלט האבן זיי איינגעזען אז ער האט נישט געזאגט, זיי זאלן זיך היטן פארן זויערטייג פון ברויט, נאר פאר דעם פלפול פון די פרושים און צדוקים. ");
INSERT INTO ydd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","און ווען יהושע/ישוע איז געקומען אין די געגנטן פון קסריה פון פיליפוס, האט ער געפרעגט זיינע תלמידים, אזוי צו זאגן: ווער, זאגן די מענטשן, אז דער בר אנש איז? ");
INSERT INTO ydd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","און זיי האבן געזאגט: אייניקע (זאגן) יוחנן פון דער (ירדן) מקווה; אנדערע אבער, אליהו; נאך אנדערע ירמיהו, אדער איינער פון די נביאים. ");
INSERT INTO ydd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","זאגט ער צו זיי: און ווער, זאגט איר, אז איך בין? ");
INSERT INTO ydd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","האט שמעון פעטרוס ענטפערנדיק געזאגט: דו ביסט דער משיח, דער זון פון דעם לעבעדיקן ג‑ט! ");
INSERT INTO ydd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","און יהושע/ישוע האט ענטפערנדיק צו אים געזאגט: אז וואויל איז דיר, שמעון בר‑יונה; ווייל בשר ודם האט עס דיר נישט אנטפלעקט, נאר מיין פאטער, וואס איז אין הימל! ");
INSERT INTO ydd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","און איך זאג דיר אויך: דו ביסט פעטרוס, און אויף דעם דאזיקן פעלדזן וועל איך בויען מיין קהלה; און די טויערן פון שאול תחתית וועלן זי נישט בייקומען. ");
INSERT INTO ydd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","און דיר וועל איך געבן די שליסלען פון דעם מלכות השמים; און וואס דו וועסט אסרן אויף דער ערד, דאס וועט זיין אסור אין הימל; און וואס דו וועסט מתיר זיין אויף דער ערד, דאס וועט זיין מותר אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","דעמאלט האט ער געבאטן זיינע תלמידים, דאס זיי זאלן קיינעם נישט אויסזאגן, אז ער איז דער משיח. ");
INSERT INTO ydd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","פון דעמאלט אָן האט יהושע/ישוע המשיח אנגעהויבן צו ווייזן זיינע תלמידים, אז ער מוז גיין קיין ירושלים, און ליידן א סך פון די זקנים און הויפט כהנים און סופרים, און געטייט ווערן, און דעם דריטן טאג אויפשטיין. ");
INSERT INTO ydd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","און פעטרוס האט אים גענומען אויף א זייט, און האט אנגעהויבן צו שרייען אויף אים, אזוי צו זאגן: שוין דיך, האר! דאס דאזיקע זאל דיר נישט געשען! ");
INSERT INTO ydd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ער אבער האט זיך אויסגעדרייט און געזאגט צו פעטרוסן: אוועק פון מיר, שׂטן, דו ביסט א מיכשול פאר מיר; ווייל דו האסט נישט אין זינען דאס, וואס געהערט צו ה׳, נאר דאס, וואס געהערט צו מענטשן! ");
INSERT INTO ydd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","דעמאלט האט יהושע/ישוע געזאגט צו זיינע תלמידים! אויב עמיצער וויל מיר נאכגיין, זאל ער זיך אליין פארלייקענען, און נעמען זיין בוים, און מיר נאכפאלגן! ");
INSERT INTO ydd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","מחמת ווער עס וויל מציל זיין זיין לעבן, דער וועט עס פארלירן; ווער אבער עס פארלירט זיין לעבן צוליב מיר, דער וועט עס געפינען. ");
INSERT INTO ydd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","מחמת וואס וועט עס העלפן א מענטשן, אויב ער זאל געווינען די גאנצע וועלט, און פארלירן זיין לעבן? אדער וואס קען א מענטש געבן אויסצולייזן זיין לעבן? ");
INSERT INTO ydd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","מחמת דער בר אנש וועט קומען אין דער הערלעכקייט פון זיין פאטער מיט זיינע מלאכים; און דעמאלט וועט ער פארגעלטן יעדן איינעם לויט זיינע מעשים. ");
INSERT INTO ydd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","באמת זאג איך אייך, אז אייניקע פון די, וואס שטייען דא, וועלן נישט פארזוכן דעם טעם פון טויט, ביז זיי וועלן זען דעם בר אנש קומען אין זיין מלכות. ");
INSERT INTO ydd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","און אין זעקס טעג ארום נעמט יהושע/ישוע מיט זיך פעטרוסן, און יעקבן, און זיין ברודער יוחנן, און פירט זיי אליין ארויף אויף א הויכן בארג. ");
INSERT INTO ydd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","און ער איז פארענדערט געווארן פאר זיי, און זיין פנים האט געלויכטן ווי די זון, און זיינע מלבושים זענען געווארן ווייס ווי דאס ליכט. ");
INSERT INTO ydd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","און זע, משה און אליהו האבן זיך באוויזן צו זיי, רעדנדיק מיט אים. ");
INSERT INTO ydd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","און פעטרוס האט ענטפערנדיק געזאגט צו יהושען/ישוען: האר, עס איז גוט פאר אונדז דא צו זיין! אויב דו ווילסט, וועל איך דא מאכן דריי געצעלטן; איינס פאר דיר, און איינס פאר משהן, און איינס פאר אליהו. ");
INSERT INTO ydd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","און בשעת ער האט נאך גערעדט, זע, א ליכטיקער וואלקן האט זיי באשאטנט; און זע, א קול אויס דעם וואלקן האט געזאגט: דאס איז מיין געליבטער זון, אין וועמען איך האב א וואוילגעפעלן; אים זאלט איר הערן! ");
INSERT INTO ydd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","און ווי די תלמידים האבן עס געהערט, זענען זיי אנידערגעפאלן אויף זייערע פנימער, און האבן זיך זייער געפארכטן. ");
INSERT INTO ydd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","און יהושע/ישוע איז צוגעגאנגען און האט זיי אנגערירט און געזאגט: שטייט אויף, און האט נישט קיין מורא! ");
INSERT INTO ydd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","און ווען זיי האבן אויפגעהויבן זייערע אויגן, האבן זיי קיינעם נישט געזען, אחוץ יהושען/ישוען אליין. ");
INSERT INTO ydd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","און בשעת זיי זענען אראפגעגאנגען פון בארג, האט יהושע/ישוע זיי באפוילן, אזוי צו זאגן: זאגט קיינעם נישט פון דער זעאונג, ביז דער בר אנש איז אויפגעשטאנען פון די טויטע. ");
INSERT INTO ydd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","און די תלמידים האבן אים געפרעגט, אזוי צו זאגן: און פארוואס זאגן די סופרים, אז אליהו דארף צום ערשט קומען? ");
INSERT INTO ydd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ער אבער האט ענטפערנדיק געזאגט: אליהו קומט טאקע, און וועט אלץ צוריקשטעלן; ");
INSERT INTO ydd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","נאר איך זאג אייך, אז אליהו איז שוין געקומען, און זיי האבן אים נישט דערקענט, נאר געמאכט מיט אים, וואס זיי האבן געוואלט. אָט אזוי וועט אויך דער בר אנש האבן צו ליידן פון זיי. ");
INSERT INTO ydd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","דעמאלט האבן די תלמידים פארשטאנען, אז ער האט גערעדט צו זיי וועגן יוחנן פון דער (ירדן) מקווה. ");
INSERT INTO ydd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","און ווען זיי זענען געקומען צו דעם המון עם, איז געקומען צו אים א מענטש, וואס איז אנידערגעפאלן פאר אים אויף די קני, ");
INSERT INTO ydd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","און געזאגט: האר, דערבארם דיך אויף מיין זון; ווייל ער איז א חולי‑נופל, און ליידט שווער; מחמת אפטמאל פאלט ער אין פייער אריין, און אפטמאל אין וואסער אריין. ");
INSERT INTO ydd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","און איך האב אים געברענגט צו דיינע תלמידים, און זיי האבן אים נישט געקענט אויסהיילן. ");
INSERT INTO ydd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","און יהושע/ישוע האט ענטפערנדיק געזאגט: אָ אומגלויביק און פארקרימט דור! ווילאנג זאל איך זיין ביי אייך? ווילאנג זאל איך אייך דערטראגן? ברענגט אים אהער צו מיר! ");
INSERT INTO ydd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","און יהושע/ישוע האט אנגעשריגן אויף אים, און דער בייזער גייסט איז פון אים ארויס, און דאס יינגל איז געזונט געווארן פון יענער שעה אָן. ");
INSERT INTO ydd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","דעמאלט זענען די תלמידים צוגעגאנגען צו יהושען/ישוען, ווען זיי זענען געווען מיט אים אליין, און האבן געזאגט: פארוואס זענען מיר נישט געווען ביכולת אים ארויסצוטרייבן? ");
INSERT INTO ydd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","און ער זאגט צו זיי: צוליב אייער קליינגלויביקייט! מחמת באמת זאג איך אייך: אויב איר וואלט געהאט אמונה ווי א זענעפט קערנדל, וואלט איר געזאגט צו דעם דאזיקן בארג: הויב דיך אויף פונדאנען דארטן אהין! און ער וואלט זיך אויפגעהויבן, און קיין זאך וואלט נישט געווען אוממעגלעך פאר אייך. ");
INSERT INTO ydd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(דער דאזיקער מין אבער גייט נישט ארויס אחוץ דורך תפילה און פאסטן.) ");
INSERT INTO ydd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","און בשעת זיי זענען ארומגעגאנגען אין גליל, האט יהושע/ישוע צו זיי געזאגט: דער בר אנש וועט איבערגעגעבן ווערן אין הענט פון מענטשן; ");
INSERT INTO ydd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","און זיי וועלן אים טייטן, און דעם דריטן טאג וועט ער אויפשטיין. און זיי זענען געווארן זייער באטריבט. ");
INSERT INTO ydd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","און ווען זיי זענען געקומען קיין כפר‑נחום, זענען די איינמאנער פון דעם האלבן שקל צוגעקומען צו פעטרוסן, און געזאגט: אייער רבי צאלט נישט דעם האלבן שקל? ");
INSERT INTO ydd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","זאגט ער: יא! און ווען ער איז אריינגעקומען אין הויז, איז יהושע/ישוע אים אנטקעגנגעקומען, זאגנדיק: וואס מיינסטו, שמעון? די מלכים פון דער ערד, פון וועמען נעמען זיי שטייערן אדער צינזן? פון זייערע קינדער, אדער פון פרעמדע? ");
INSERT INTO ydd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","און ווען ער האט געזאגט: פון פרעמדע, האט יהושע/ישוע צו אים געזאגט: אזוי זענען די קינדער פריי! ");
INSERT INTO ydd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","נאר כדי מיר זאלן נישט זיין קיין מיכשול פאר זיי, גיי צום ים, און ווארף אריין א ווענטקע, און נעם דעם ערשטן פיש, וואס וועט ארויפקומען; און ווען דו וועסט אויפעפענען זיין מויל, וועסטו געפינען א זילבערנע מטבע (א סטאטער); נעם זי, און גיב זי פאר מיר און פאר דיר. ");
INSERT INTO ydd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","אין יענער שעה זענען די תלמידים געקומען צו יהושען/ישוען, און געזאגט: ווער איז אינדעראמתן דער גרעסטער אין דעם מלכות השמים? ");
INSERT INTO ydd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","און ער האט גערופן צו זיך א קינד, און האט עס געשטעלט אין זייער מיט, ");
INSERT INTO ydd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","און געזאגט: באמת זאג איך אייך: אויב איר וועט זיך נישט אומקערן, און ווערן ווי די קינדער, וועט איר בשום אופן נישט אריינגיין אין דעם מלכות השמים! ");
INSERT INTO ydd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","דעריבער ווער עס וועט זיך אליין דערנידעריקן ווי דאס דאזיקע קינד, דער איז דער גרעסטער אין מלכות השמים. ");
INSERT INTO ydd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","און ווער עס וועט אויפנעמען איין קינד אזעלכעס אין מיין נאמען, דער נעמט מיך אויף. ");
INSERT INTO ydd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ווער אבער עס וועט פארפירן צום שטרויכלען איינס פון די דאזיקע קליינע, וואס גלויבן אין מיר, איז בעסער פאר אים וואלט עס געווען, אז א גרויסער מילשטיין וואלט אנגעהאנגען געווארן אויף זיין האלדז, און ער וואלט דערטרונקען געווארן אין דער טיפעניש פון ים. ");
INSERT INTO ydd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","וויי צו דער וועלט מחמת די מיכשולים! מחמת שטרויכלונגען מוזן קומען; נאר וויי איז צו דעם מענטשן, דורך וועמען דאס מיכשול קומט! ");
INSERT INTO ydd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","און אויב דיין האנט אדער דיין פוס פארפירט דיך צום שטרויכלען, האק אים אפ, און ווארף אים אוועק פון דיר! עס איז בעסער פאר דיר אריינצוגיין אין דעם לעבן לאם אדער הינקענדיק, ווי צו האבן ביידע הענט אדער ביידע פיס און געווארפן צו ווערן אין דעם אייביקן פייער אריין. ");
INSERT INTO ydd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","און אויב דיין אויג פארפירט דיך צום שטרויכלען, רייס עס ארויס און ווארף עס אוועק פון דיר! עס איז בעסער פאר דיר אריינצוגיין אין דעם לעבן מיט איין אויג, ווי צו האבן צוויי אויגן און געווארפן צו ווערן אין דעם גיהנום פון פייער. ");
INSERT INTO ydd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","גיט אכטונג, אז איר זאלט נישט מבזה זיין קיין איינס פון די דאזיקע קליינע! מחמת איך זאג אייך, אז זייערע מלאכים אין הימל זען תמיד דאס פנים פון מיין פאטער, וואס איז אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(מחמת דער בר אנש איז געקומען, כדי צו ראטעווען דאס, וואס איז פארלוירן געגאנגען.) ");
INSERT INTO ydd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","וואס מיינט איר? ווען א געוויסער מאן האט הונדערט שאף, און איינע פון זיי וועט פארבלאנדזשען, צי וועט ער דען נישט איבערלאזן די ניין און ניינציק אויף די בערג, און גיין זוכן די פארבלאנדזשעטע? ");
INSERT INTO ydd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","און ווען עס טרעפט זיך, אז ער געפינט זי, באמת זאג איך אייך, ער פריידט זיך מער מיט איר, ווי מיט די ניין און ניינציק, וואס זענען נישט פארבלאנדזשעט געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","אָט אזוי איז עס אויך נישט דער רצון פאר אייער פאטער, וואס איז אין הימל, אז איינס פון די דאזיקע קליינע זאל פארלוירן גיין. ");
INSERT INTO ydd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ווען דיין ברודער וועט זינדיקן (קעגן דיר), זאלסטו גיין, און אים זאגן מוסר בלויז צווישן דיר און אים אליין. ");
INSERT INTO ydd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","וועט ער דיך הערן, האסטו געוואונען דיין ברודער. אויב אבער ער וועט נישט הערן, זאלסטו נעמען מיט דיר נאך איינעם אדער צוויי, כדי פון דעם מויל פון צוויי עדות אדער דריי זאל יעדע זאך פעסטגעשטעלט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","און אויב ער וועט זיי נישט הערן, זאג עס צו דער קהלה. ווען אבער ער וויל די קהלה אויך נישט הערן, זאל ער זיין פאר דיר ווי א גוי און דער שטייער אויפמאנער. ");
INSERT INTO ydd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","באמת זאג איך אייך, וואס איר וועט אסרן אויף דער ערד, דאס וועט זיין אסור אין הימל, און וואס איר וועט מתיר זיין אויף דער ערד, דאס וועט זיין מותר אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ווייטער זאג איך אייך, אויב צוויי פון אייך וועלן מסכים זיין אויף דער ערד וואס שייך וועלכע עס איז זאך, אויף וואס זיי ווילן בעטן, וועט עס זיי געטאן ווערן פון מיין פאטער, וואס איז אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","מחמת וואו צוויי אדער דריי זענען פארזאמלט אין מיין נאמען, דארט בין איך צווישן זיי. ");
INSERT INTO ydd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","דעמאלט איז פעטרוס צוגעגאנגען צו אים, און געזאגט; האר, וויפל מאל, ווען מיין ברודער זינדיקט קעגן מיר, דארף איך אים מוחל זיין? צי ביז צום זיבעטן מאל? ");
INSERT INTO ydd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","זאגט יהושע/ישוע צו אים: איך זאג דיר נישט, ביז צום זיבעטן מאל; נאר, ביז צום זיבעציקסטן מאל זיבעטן מאל! ");
INSERT INTO ydd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","דערפאר איז דאס מלכות השמים געגליכן צו א מלך, וואס האט געוואלט מאכן א חשבון מיט זיינע קנעכט. ");
INSERT INTO ydd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","און ווי ער האט אנגעהויבן צו רעכענען, האט מען געברענגט פאר אים איינעם, וועלכער איז שולדיק געווען צען טויזנט טאלאנטן. ");
INSERT INTO ydd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","און ווייל ער האט נישט געהאט צו באצאלן, האט זיין האר באפוילן, אז מען זאל אים פארקויפן מיט זיין ווייב און קינדער און אלץ, וואס ער האט, און עס זאל באצאלט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","דאן איז דער קנעכט אנידערגעפאלן און האט זיך געבוקט צו אים, אזוי צו זאגן: האב געדולד מיט מיר, און איך וועל דיר אלץ באצאלן! ");
INSERT INTO ydd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","און דער האר פון יענעם קנעכט האט זיך דערבארמט אויף אים, און האט אים געלאזט גיין, און אים מוחל געווען דעם חוב. ");
INSERT INTO ydd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ווען אבער יענער קנעכט איז ארויסגעגאנגען, האט ער געפונען איינעם פון זיינע מיטקנעכט, וואס איז אים שולדיק געווען הונדערט דינרים; און ער האט אים אנגעכאפט, און האט אים געווערגן, און געזאגט: באצאל, וואס דו ביסט שולדיק! ");
INSERT INTO ydd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","דאן איז זיין מיטקנעכט אנידערגעפאלן פאר זיינע פיס, און האט אים געבעטן, אזוי צו זאגן: האב געדולד מיט מיר, און איך וועל דיר באצאלן! ");
INSERT INTO ydd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ער אבער האט נישט געוואלט, נאר איז אוועקגעגאנגען און האט אים אריינגעווארפן אין תפיסה, ביז ער וועט האבן באצאלט, וואס ער איז שולדיק געווען. ");
INSERT INTO ydd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","דעריבער ווען זיינע מיטקנעכט האבן געזען, וואס דא איז געשען, האבן זיי זיך שטארק מצער געווען, און זענען געקומען און דערציילט זייער האר אלץ, וואס האט פאסירט. ");
INSERT INTO ydd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","דעמאלט האט זיין האר אים גערופן צו זיך, און זאגט צו אים: דו געמיינער קנעכט! יענעם גאנצן חוב האב איך דיר פארגעבן, ווייל דו האסט מיך געבעטן; ");
INSERT INTO ydd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","האסטו דען נישט אויך געדארפט רחמנות האבן אויף דיין מיטקנעכט, ווי איך האב אויף דיר רחמנות געהאט? ");
INSERT INTO ydd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","און זיין האר איז צארנדיק געווארן, און האט אים איבערגעגעבן צו די פייניקער, ביז ער וועט באצאלן אלץ, וואס ער איז אים שולדיק. ");
INSERT INTO ydd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","פונקט אזוי וועט אויך מיין הימלישער פאטער טאן צו אייך, ווען איר וועט נישט מוחל זיין יעדער איינער דעם ברודער זיינעם פון אייערע הערצער. ");
INSERT INTO ydd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","­און עס איז געשען, ווען יהושע/ישוע האט געענדיקט די דאזיקע ווערטער, האט ער זיך אויפגעהויבן און איז אוועק פון גליל, און איז געקומען אין דעם גבול פון יהודה, אויף יענער זייט ירדן. ");
INSERT INTO ydd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","און גרויסע המונים מענטשן האבן אים נאכגעפאלגט, און ער האט זיי דארט געהיילט. ");
INSERT INTO ydd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","און פרושים זענען געקומען צו אים, האבן אים אויסגעפרואווט, און געזאגט: צי מעג מען זיך גטן מיטן ווייב צוליב יעדער סיבה? ");
INSERT INTO ydd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ער אבער האט ענטפערנדיק געזאגט: האט איר דען נישט געלייענט, אז דער בורא האט אין אנהויב זיי באשאפן זכר און נקבה, ");
INSERT INTO ydd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","און געזאגט: דערפאר וועט א מענטש פארלאזן דעם פאטער און די מוטער, און זיך באהעפטן מיט זיין ווייב; און די צוויי וועלן ווערן איין פלייש? אזוי זענען זיי שוין מער נישט קיין צוויי, נאר איין פלייש. ");
INSERT INTO ydd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","דעריבער וואס ה׳ האט מזווג געווען, דאס זאל קיין מענטש נישט צעשיידן. ");
INSERT INTO ydd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","זאגן זיי צו אים: און פארוואס האט משה געבאטן איר צו געבן א גט, און זי אוועקצושיקן? ");
INSERT INTO ydd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","זאגט ער צו זיי: משה האט אייך דערלויבט צו גטן אייערע ווייבער, מחמת דער הארטקייט פון אייער הארץ; פון אנהויב איז עס אבער נישט אזוי געווען. ");
INSERT INTO ydd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","און איך זאג אייך: ווער עס גט זיך מיט זיין ווייב, אחוץ צוליב זנות, און האט חתונה מיט אן אנדערער, דער איז מזנה; און ווער עס האט חתונה מיט א גרושה, דער איז מזנה. ");
INSERT INTO ydd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","זאגן די תלמידים צו אים: אויב די זאך איז אזוי צווישן מאן און ווייב, טויג נישט חתונה צו האבן. ");
INSERT INTO ydd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ער אבער האט צו זיי געזאגט: נישט אלע קענען מקבל זיין דאס דאזיקע ווארט, נאר זיי, וועמען עס איז געגעבן געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","מחמת עס זענען פאראן סריסים, וואס זענען אזוי געבוירן געווארן פון זייער מוטערס לייב; און עס זענען פאראן סריסים, וואס זענען מסרס געווארן פון מענטשן; און עס זענען פאראן סריסים, וואס האבן זיך אליין מסרס געווען צוליב דעם מלכות השמים. ווער עס קען עס מקבל זיין, דער זאל עס מקבל זיין! ");
INSERT INTO ydd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","דעמאלט האט מען געברענגט קינדער צו אים, אז ער זאל ארויפלייגן די הענט אויף זיי, און זאגן א תפילה; די תלמידים אבער האבן אנגעשריגן אויף זיי. ");
INSERT INTO ydd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","יהושע/ישוע אבער האט געזאגט: לאזט די קינדער קומען צו מיר, און שטערט זיי נישט; מחמת צו אזעלכע געהערט דאס מלכות השמים. ");
INSERT INTO ydd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","און ער האט ארויפגעלייגט די הענט אויף זיי, און איז אוועקגעגאנגען פון דארטן. ");
INSERT INTO ydd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","און זע, איינער איז געקומען צו אים, און געזאגט: רבי, וואס פאר א גוטס זאל איך טאן, כדי איך זאל האבן אייביק לעבן? ");
INSERT INTO ydd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","און ער האט צו אים געזאגט: וואס פרעגסטו מיך וועגן דעם גוטן? נאר איינער איז דער גוטער! אויב אבער דו ווילסט אריינגיין אין דעם לעבן, האלט די מצוות! ");
INSERT INTO ydd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","זאגט ער צו אים: וועלכע? און יהושע/ישוע האט געזאגט: זאלסט נישט טייטן, זאלסט נישט נואפן, זאלסט נישט גנבענען, זאלסט נישט זאגן פאלש עדות, ");
INSERT INTO ydd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","זאלסט אפגעבן כבוד דעם פאטער און די מוטער, און: דו זאלסט ליב האבן דיין חבר ווי דיך אליין! ");
INSERT INTO ydd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","זאגט צו אים דער בחור: דאס אלץ האב איך אפגעהיטן; וואס פעלט מיר נאך? ");
INSERT INTO ydd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","האט יהושע/ישוע צו אים געזאגט: אויב דו ווילסט זיין שלמותדיק, גיי, פארקויף דיין רכוש, און גיב עס צו ארעמעלייט, און דו וועסט האבן אן אוצר אין הימל; און קום, פאלג מיר נאך. ");
INSERT INTO ydd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ווי אבער דער בחור האט געהערט דאס דאזיקע ווארט, איז ער אוועקגעגאנגען א טרויעריקער; מחמת ער האט געהאט א גרויס פארמעגן. ");
INSERT INTO ydd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","און יהושע/ישוע האט געזאגט צו זיינע תלמידים: באמת זאג איך אייך: עס איז שווער פאר אן עושר אריינצוגיין אין דעם מלכות השמים. ");
INSERT INTO ydd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","און ווידער זאג איך אייך: א קעמל קען לייכטער אריינגיין דורך דעם לאך פון א נאדל, ווי א רייכער אין דעם קעניגרייך פון ה׳! ");
INSERT INTO ydd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","און ווען די תלמידים האבן דאס געהערט, זענען זיי שטארק נשתומם געווארן, און האבן געזאגט: ווער זשע קען דערלייזט ווערן? ");
INSERT INTO ydd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","און יהושע/ישוע האט אויף זיי געקוקט און געזאגט צו זיי: ביי מענטשן איז דאס דאזיקע אוממעגלעך; ביי ה׳ אבער איז אלץ מעגלעך. ");
INSERT INTO ydd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","דעמאלט האט פעטרוס ענטפערנדיק צו אים געזאגט: זע, מיר האבן אלץ פארלאזן, און דיר נאכגעפאלגט; וואס וועלן מיר האבן דערפאר? ");
INSERT INTO ydd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","און יהושע/ישוע האט צו זיי געזאגט: באמת זאג איך אייך, אז איר, וואס האבן מיר נאכגעפאלגט, וועט אין דער נייער וועלט, ווען דער בר אנש וועט זיצן אויף זיין כסא הכבוד, אויך זיצן אויף צוועלף טראנען און משפטן די צוועלף שבטים פון ישראל. ");
INSERT INTO ydd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","און יעדער איינער, וואס האט פארלאזט הייזער אדער ברידער אדער שוועסטער אדער פאטער אדער מוטער אדער קינדער אדער פעלדער צוליב מיין נאמען, וועט א סך מאל מער באקומען, און ירשענען דאס אייביקע לעבן. ");
INSERT INTO ydd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","נאר א סך ערשטע וועלן זיין לעצטע, און לעצטע—ערשטע. ");
INSERT INTO ydd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ווייל דאס מלכות השמים איז גלייך צו א מענטשן, א בעל הבית, וואס איז ארויסגעגאנגען זייער פרי צו דינגען ארבעטער פאר זיין וויינגארטן. ");
INSERT INTO ydd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","און נאך דעם ווי ער האט מסכים געווען מיט די ארבעטער פאר א דינר דעם טאג, האט ער זיי געשיקט אין זיין וויינגארטן אריין. ");
INSERT INTO ydd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","און ער איז ארויסגעגאנגען ארום דער דריטער שעה, און האט געזען אנדערע שטיין אויפן מארק ליידיק; ");
INSERT INTO ydd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","און האט צו יענע געזאגט: גייט איר אויך אין וויינגארטן אריין, און וואס איז רעכט, וועל איך אייך געבן! ");
INSERT INTO ydd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","און זיי זענען געגאנגען און ער איז ווידער ארויסגעגאנגען ארום דער זעקסטער און ניינטער שעה, און האט דאס זעלביקע געטאן. ");
INSERT INTO ydd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","און ארום דער עלפטער שעה איז ער ארויסגעגאנגען, און האט געפונען אנדערע שטיין און זאגט צו זיי: וואס שטייט איר דא ליידיק דעם גאנצן טאג? ");
INSERT INTO ydd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","זאגן זיי צו אים: ווייל קיינער האט אונדז נישט געדונגען: זאגט ער צו זיי: גייט איר אויך אין וויינגארטן אריין. ");
INSERT INTO ydd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","און ווען עס איז געווארן אוונט, זאגט דער האר פון דעם וויינגארטן צו זיין אפוטרופוס: רוף די ארבעטער, און צאל אויס דעם לוין, אנהויבנדיק פון די לעצטע ביז צו די ערשטע. ");
INSERT INTO ydd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","און עס זענען געקומען די, וואס זענען געדונגען געווארן ארום דער עלפטער שעה, און האבן באקומען יעדער איין דינר. ");
INSERT INTO ydd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","און ווען די ערשטע זענען געקומען, האבן זיי געמיינט, אז זיי וועלן באקומען מער; און זיי אליין האבן אויך באקומען יעדער איין דינר. ");
INSERT INTO ydd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","און ווען זיי האבן עס גענומען, האבן זיי געמורמלט אויף דעם בעל הבית, ");
INSERT INTO ydd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","אזוי צו זאגן: די דאזיקע לעצטע האבן געארבעט נאר איין שעה, און דו האסט זיי גלייך געשטעלט מיט אונדז, וואס האבן דערטראגן די לאסט און היץ פון דעם טאג. ");
INSERT INTO ydd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ער אבער האט ענטפערנדיק צו איינעם פון זיי געזאגט: מיין פריינד, איך טו דיר נישט קיין עוולה. האסטו דען נישט איינגעשטימט מיט מיר פאר איין דינר? ");
INSERT INTO ydd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","נעם דאס דייניקע, און גיי; איך וויל אבער געבן דעם דאזיקן לעצטן אזויפיל וויפל דיר. ");
INSERT INTO ydd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","טאר איך דען נישט טאן מיט מיין אייגנס, וואס איך וויל? אדער איז דיין אויג שלעכט, ווייל איך בין גוט? ");
INSERT INTO ydd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","אָט אזוי וועלן די לעצטע זיין ערשטע, און די ערשטע—לעצטע. ");
INSERT INTO ydd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","און ווען יהושע/ישוע האט געהאלטן ביים ארויפגיין קיין ירושלים, האט ער גענומען די צוועלף אליין אויף א זייט, און אויפן וועג צו זיי געזאגט: ");
INSERT INTO ydd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","זע, מיר גייען ארויף קיין ירושלים; און דער בר אנש וועט איבערגעגעבן ווערן צו די הויפט כהנים און סופרים; און זיי וועלן אים פארמשפטן צום טויט, ");
INSERT INTO ydd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","און אים איבערגעבן צו די אומות (העולם) צו פארשפאטן, און שמייסן, און אויפהענגען אויף דער בוים, און דעם דריטן טאג וועט ער אויפשטיין. ");
INSERT INTO ydd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","דעמאלט איז צוגעקומען צו אים די מוטער פון זבדיס קינדער מיט אירע זין, האט זיך געבוקט, און עפעס פארלאנגט פון אים. ");
INSERT INTO ydd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","און ער האט צו איר געזאגט: וואס באגערסטו? זאגט זי צו אים: זאג, אז די דאזיקע ביידע זין מיינע זאלן זיצן איינער אויף דיין רעכטער זייט, און איינער אויף דיין לינקער זייט אין דיין מלכות. ");
INSERT INTO ydd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","יהושע/ישוע האט אבער ענטפערנדיק געזאגט: איר ווייסט נישט, וואס איר בעט! צי קענט איר דען טרינקען דעם כוס, וואס איך גיי טרינקען? זאגן זיי צו אים: מיר קענען! ");
INSERT INTO ydd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","זאגט ער צו זיי: מיין כוס וועט איר טאקע טרינקען; נאר צו זיצן אויף מיין רעכטער זייט, און אויף מיין לינקער זייט, איז נישט מיין זאך צו געבן; עס איז נאר פאר די, פאר וועמען עס איז צוגעגרייט געווארן פון מיין פאטער. ");
INSERT INTO ydd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","און ווען די צען האבן דאס געהערט, זענען זיי געווארן אין כעס אויף די צוויי ברידער. ");
INSERT INTO ydd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","און יהושע/ישוע האט זיי צוגערופן, און געזאגט: איר ווייסט, אז די שרים פון די אומות (העולם) הערשן איבער זיי, און די גרויסע לייט טאן איבער זיי געוועלטיקן. ");
INSERT INTO ydd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","אזוי זאל עס נישט זיין צווישן אייך, נאר ווער צווישן אייך עס וועט וועלן זיין גרויס, דער זאל זיין אייער משרת; ");
INSERT INTO ydd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","און ווער עס וויל צווישן אייך זיין א ראש, דער זאל זיין אייער קנעכט. ");
INSERT INTO ydd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","גלייך ווי דער בר אנש איז נישט געקומען באדינט צו ווערן, נאר צו דינען, און צו געבן זיין לעבן ווי אן אויסלייזונג פאר א סך. ");
INSERT INTO ydd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","און בשעת זיי זענען ארויסגעגאנגען פון יריחו, האט אים נאכגעפאלגט א גרויסער המון מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","און זע, צוויי בלינדע זענען געזעסן ביים וועג; ווי זיי האבן געהערט, אז יהושע/ישוע גייט פארביי, האבן זיי א געשריי געטאן, אזוי צו זאגן: האר, בן דוד, דערבארם דיך אויף אונדז! ");
INSERT INTO ydd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","דער המון אבער האט געשריגן אויף זיי, אז זיי זאלן שווייגן. און זיי האבן נאך מער געשריגן, אזוי צו זאגן: האר, בן דוד, דערבארם דיך אויף אונדז! ");
INSERT INTO ydd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","און יהושע/ישוע האט זיך אפגעשטעלט, און זיי גערופן, און געזאגט: וואס ווילט איר, אז איך זאל טאן פאר אייך? ");
INSERT INTO ydd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","זאגן זיי צו אים: אז אונדזערע אויגן זאלן געעפנט ווערן! ");
INSERT INTO ydd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","און יהושע/ישוע האט זיך דערבארעמט אויף זיי, און אנגערירט זייערע אויגן, און פלוצלונג זענען זיי זעענדיק געווארן, און האבן אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","און ווען זיי האבן זיך דערנענטערט צו ירושלים, און זענען געקומען קיין בית‑פגי, ביים הר הזיתים, האט יהושע/ישוע דעמאלט געשיקט צוויי פון זיינע תלמידים, ");
INSERT INTO ydd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","און געזאגט צו זיי: גייט אריין אין דעם דארף, וואס ליגט אנטקעגנאיבער אייך, און תיכף וועט איר געפינען אן אייזל אנגעבונדן, און א יונג אייזעלע ביי איר, בינדט זיי אויף, און ברענגט זיי צו מיר. ");
INSERT INTO ydd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","און אויב עמיצער וועט אייך עפעס זאגן, זאלט איר זאגן: דער האר דארף זיי האבן; און ער וועט זיי גלייך שיקן. ");
INSERT INTO ydd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","און דאס דאזיקע איז געשען, כדי עס זאל דערפילט ווערן, וואס עס איז געזאגט געווארן דורך דעם נביא, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","זאגט דער טאכטער פון ציון: זע, דיין מלך קומט צו דיר, אן ענו, און רייטנדיק אויף אן אייזל, און אויף אן אייזעלע, דאס יונגע פון אן אייזל. ");
INSERT INTO ydd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","און די תלמידים זענען געגאנגען, און האבן געטאן ווי יהושע/ישוע האט זיי באפוילן, ");
INSERT INTO ydd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","און האבן געברענגט דאס אייזל מיט דעם אייזעלע, און אויף זיי ארויפגעלייגט די מלבושים; און ער האט זיך ארויפגעזעצט אויף זיי. ");
INSERT INTO ydd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","און דאס רוב פון דעם המון האבן אויסגעשפרייט זייערע מלבושים אויפן וועג; און אנדערע האבן אפגעבראכן צווייגן פון די ביימער, ");
INSERT INTO ydd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","און זיי פאנאנדערגעלייגט אויפן וועג. און די המונים, וואס זענען געגאנגען פארויס פאר אים, און וואס האבן נאכגעפאלגט, האבן געשריגן, אזוי צו זאגן: הושענא לבן דוד! געלויבט זאל זיין דער, וואס קומט אין דעם נאמען פון דעם האר. הושענא במרומים! ");
INSERT INTO ydd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","און ווען ער איז אריינגעגאנגען קיין ירושלים, איז די גאנצע שטאט אויפגערודערט געווארן, און געזאגט: ווער איז דאס דער דאזיקער? ");
INSERT INTO ydd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","די המונים אבער האבן געזאגט: דאס איז דער נביא יהושע/ישוע פון נצרת, אין גליל. ");
INSERT INTO ydd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","און יהושע/ישוע איז אריינגעגאנגען אין בית המקדש, און האט ארויסגעטריבן אלע וואס האבן פארקויפט און געקויפט אין בית המקדש, און איבערגעקערט די טישן פון די געלטבייטער, און די בענק פון די, וואס האבן פארקויפט טויבן; ");
INSERT INTO ydd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","און זאגט צו זיי: עס שטייט געשריבן: מיין הויז וועט גערופן ווערן א בית תפילה! (ישעיהו נו, ז.) איר אבער האט עס געמאכט פאר א הייל פון גזלנים. (ירמיהו ז, יא.) ");
INSERT INTO ydd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","און עס זענען געקומען צו אים בלינדע און לאמע אין בית המקדש, און ער האט זיי געהיילט. ");
INSERT INTO ydd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ווי אבער די הויפט כהנים און די סופרים האבן געזען די וואונדער, וואס ער האט געטאן, און די קינדער שרייען אין בית המקדש און זאגן: הושענא לבן דוד, זענען זיי צארנדיק געווארן, ");
INSERT INTO ydd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","און האבן צו אים געזאגט: דו הערסט, וואס זיי זאגן? און יהושע/ישוע זאגט צו זיי: יא! צי האט איר קיינמאל נישט געלייענט: אויס דעם מויל פון קינדער און זייגעדיקע האסטו צוגעגרייט לויב? (תהלים ח, ג.) ");
INSERT INTO ydd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","און האט זיי פארלאזט, און איז ארויסגעגאנגען אויסער דער שטאט קיין בית‑היני. און דארטן איבערגענעכטיקט. ");
INSERT INTO ydd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","און אינדערפרי, אומקערנדיק זיך אין שטאט אריין, איז ער הונגעריק געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","און זעענדיק אן איינציקן פייגנבוים ביים וועג, און איז צוגעגאנגען צו אים, און האט גארנישט געפונען אויף אים אחוץ בלעטער אליין; און ער זאגט צו אים: עס זאל מער נישט וואקסן אויף דיר קיין פירות ביז אויף אייביק! און דער פייגנבוים איז באלד פארדארט געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","און ווען די תלמידים האבן עס געזען, האבן זיי זיך געוואונדערט, און געזאגט: ווי איז דער פייגנבוים אזוי פלוצלונג פארטריקנט געווארן! ");
INSERT INTO ydd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","יהושע/ישוע אבער האט ענטפערנדיק צו זיי געזאגט: באמת זאג איך אייך: ווען איר זאלט האבן אמונה, און נישט צווייפלען, וועט איר טאן נישט נאר דאס מיט דעם פייגנבוים, נאר אפילו אויב איר וועט זאגן צו דעם דאזיקן בארג: הייב דיך אויף און ווארף דיך אין ים אריין, וועט עס געשען. ");
INSERT INTO ydd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","און אלץ, וואס איר וועט בעטן אין תפילה, אויב איר וועט גלויבן, וועט איר עס באקומען. ");
INSERT INTO ydd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","און ווען ער איז געקומען אין בית המקדש אריין, זענען די הויפט כהנים און די זקנים פון דעם פאלק צוגעגאנגען צו אים, בשעת ער האט געלערנט, און האבן געזאגט: מיט וואס פאר א רשות טוסטו די דאזיקע זאכן? און ווער האט דיר געגעבן דעם דאזיקן רשות? ");
INSERT INTO ydd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","און יהושע/ישוע האט ענטפערנדיק צו זיי געזאגט: איך וועל אייך אויך פרעגן איין זאך, וואס אויב איר וועט מיר זאגן, וועל איך אייך אויך זאגן מיט וואס פאר א רשות איך טו די דאזיקע זאכן. ");
INSERT INTO ydd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","יוחננס מקווה—פון וואנען איז געווען? פון הימל אדער פון מענטשן? און זיי האבן עס איבערגעלייגט צווישן זיך, אזוי צו זאגן: וועלן מיר זאגן: פון הימל, וועט ער זאגן צו אונדז: טא פארוואס האט איר אים נישט געגלויבט? ");
INSERT INTO ydd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","וועלן מיר אבער זאגן: פון מענטשן, מוזן מיר מורא האבן פאר דעם המון? מחמת אלע האלטן יוחנן פאר א נביא. ");
INSERT INTO ydd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","און זיי האבן ענטפערנדיק געזאגט צו יהושען/ישוען: מיר ווייסן נישט! האט ער אויך צו זיי געזאגט, זאג איך אייך אויך נישט, מיט וואס פאר א רשות איך טו די דאזיקע זאכן. ");
INSERT INTO ydd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","וואס אבער מיינט איר? א מענטש האט געהאט צוויי קינדער; און ער איז צוגעגאנגען צו דעם ערשטן, און געזאגט: מיין קינד, גיי ארבעט היינט אין וויינגארטן. ");
INSERT INTO ydd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","און ער האט ענטפערנדיק געזאגט: אָט בין איך, האר! און איז נישט געגאנגען! ");
INSERT INTO ydd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","און ער איז צוגעגאנגען צו דעם צווייטן און האט געזאגט דאס זעלביקע. דער אבער האט געזאגט: איך וויל נישט! ");
INSERT INTO ydd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","דערנאך האט ער חרטה געהאט, און איז געגאנגען. ווער פון די ביידע האט געטאן דעם פאטערס רצון? זאגן זיי: דער לעצטער. זאגט יהושע/ישוע צו זיי: באמת זאג איך אייך, אז די שטייער אויפמאנער און די זונות גייען אריין פארויס פאר אייך אין דעם קעניגרייך פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","מחמת יוחנן איז געקומען צו אייך אויף דעם וועג פון גערעכטיקייט און איר האט נישט געגלויבט אין אים. די שטייער אויפמאנער אבער און די זונות האבן אים יא געגלויבט, און איר, הגם איר האט עס געזען, האט אפילו שפעטער נישט חרטה געהאט, כדי אים צו גלויבן. ");
INSERT INTO ydd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","הערט אן אנדער משל: עס איז געווען א מענטש, א בעל הבית, וואס האט געפלאנצט א וויינגארטן, און האט אים ארומגערינגלט מיט א צוים, און געגראבן א וויינקעלטער אין אים, און געבויט א טורם, און האט אים פארדינגען צו גערטנער, און איז אוועקגעפארן. ");
INSERT INTO ydd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","און ווען עס האט זיך דערנענטערט די צייט פון פירות, האט ער געשיקט זיינע קנעכט צו די גערטנער אפצונעמען זיינע פרוכטן. ");
INSERT INTO ydd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","און די גערטנער האבן גענומען זיינע קנעכט, און איינעם געשלאגן, און אן אנדערן געטייט, און א דריטן געשטייניקט. ");
INSERT INTO ydd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ער האט ווידער געשיקט אנדערע קנעכט, מער ווי די ערשטע; און זיי האבן מיט זיי געטאן דאס זעלביקע. ");
INSERT INTO ydd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","דערנאך האט ער געשיקט צו זיי זיין זון, און האט געזאגט: זיי וועלן זיך שעמען פאר מיין זון, ");
INSERT INTO ydd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","די גערטנער אבער, ווי זיי האבן אים דערזען, האבן געזאגט צווישן זיך: דאס איז דער יורש; קומט, לאמיר אים טייטן, און צונעמען זיין ירושה. ");
INSERT INTO ydd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","און האבן אים גענומען, און ארויסגעווארפן אינדרויסן פון וויינגארטן, און געטייט. ");
INSERT INTO ydd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ווען דעריבער דער האר פון דעם וויינגארטן וועט קומען, וואס זשע וועט ער טאן צו יענע גערטנער? ");
INSERT INTO ydd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","זאגן זיי צו אים: ער וועט די רשעים אומברענגען אויף א שרעקלעכן אופן, און דעם וויינגארטן פארדינגען צו אנדערע גערטנער, וואס וועלן אים אפגעבן די פירות אין זייערע זמנים. ");
INSERT INTO ydd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","זאגט יהושע/ישוע צו זיי: האט איר קיינמאל נישט געלייענט אין די כתובים? דער שטיין, וואס די בוימייסטערס האבן פארווארפן, איז געווארן צום הויפט פונם ווינקל. פונם האר (ה׳) איז דאס געשען, און עס איז א וואונדער אין אונדזערע אויגן. ");
INSERT INTO ydd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","דערפאר זאג איך אייך: דאס קעניגרייך פון ה׳ וועט אוועקגענומען ווערן פון אייך, און געגעבן ווערן צו א פאלק, וואס ברענגט זיינע פירות. ");
INSERT INTO ydd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(און ווער עס פאלט אויף דעם דאזיקן שטיין, דער וועט צעשמעטערט ווערן; אויף וועמען אבער ער וועט פאלן, וועט ער אים צעמאלן.) ");
INSERT INTO ydd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","און ווען די הויפט כהנים און די פרושים האבן געהערט זיינע משלים, האבן זיי פארשטאנען, אז ער רעדט וועגן זיי. ");
INSERT INTO ydd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","און האבן געזוכט אים צו כאפן, און האבן זיך געפארכטן פאר די המונים מענטשן, ווייל מען האט אים געהאלטן פאר א נביא. ");
INSERT INTO ydd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","און יהושע/ישוע האט ענטפערנדיק ווידער צו זיי גערעדט אין משלים, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","דאס מלכות השמים איז געגליכן צו א מענטשלעכן קעניג, וואס האט געמאכט א חתונהמאלצייט פאר זיין זון, ");
INSERT INTO ydd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","און געשיקט זיינע קנעכט רופן די פארבעטענע צו דער חתונה; און זיי האבן נישט געוואלט קומען. ");
INSERT INTO ydd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","האט ער נאכאמאל געשיקט אנדערע קנעכט, אזוי צו זאגן: זאגט די פארבעטענע: זע, איך האב צוגעגרייט מיין סעודה; מיינע אקסן און געשטאפטע קעלבער זענען שוין געשאכטן, און אלץ איז פארטיק; קומט אויף דער חתונה! ");
INSERT INTO ydd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","זיי אבער האבן זיך דערפון גארנישט געמאכט, נאר זענען געגאנגען, איינער אין זיין פעלד אריין, און אן אנדערער צו זיין מסחר; ");
INSERT INTO ydd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","און די איבריקע האבן געכאפט זיינע קנעכט, זיי מיאוס באהאנדלט און געטייט. ");
INSERT INTO ydd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","און דער קעניג איז צארנדיק געווארן; און האט געשיקט זיינע חיילות, און אומגעברענגט יענע רוצחים, און זייער שטאט פארברענט. ");
INSERT INTO ydd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","דאן זאגט ער צו זיינע קנעכט: די חתונה איז גרייט, די פארבעטענע אבער זענען עס נישט ווערט געווען. ");
INSERT INTO ydd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","גייט זשע אהין אויף די גאסן, וואו די וועגן שיידן זיך, און וויפל איר וועט געפינען, זאלט איר פארבעטן אויף דער חתונה. ");
INSERT INTO ydd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","און יענע קנעכט זענען ארויסגעגאנגען אויף די גאסן, און האבן איינגעזאמלט אלע, וועמען זיי האבן געפונען, סיי שלעכטע סיי גוטע, און דער חתונה זאל איז פול געווארן מיט געסט. ");
INSERT INTO ydd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","נאר ווען דער קעניג איז אריינגעקומען געזען די געסט, האט ער דערזען דארטן א מענטשן, וואס איז נישט געווען אנגעטאן אין א חתונה מלבוש; ");
INSERT INTO ydd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","און ער זאגט צו אים: פריינד, וויאזוי ביסטו אריינגעקומען אהער, נישט האבנדיק קיין חתונה מלבוש? און ער איז געבליבן שטום. ");
INSERT INTO ydd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","דעמאלט האט דער קעניג געזאגט צו די באדינער: בינדט אים הענט און פיס, און ווארפט אים ארויס אין דער אויסערסטער פינצטערניש! דארט וועט זיין דאס קלאגן און קריצן מיט די ציין. ");
INSERT INTO ydd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","מחמת א סך זענען גערופן, ווייניקע אבער אויסדערוויילט. ");
INSERT INTO ydd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","דעמאלט זענען די פרושים געגאנגען, און האבן זיך געהאלטן אן עצה, ווי אזוי זיי זאלן אים פאנגען מיט א ווארט. ");
INSERT INTO ydd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","און זיי שיקן צו אים זייערע תלמידים מיט הורדוסנס לייט, אזוי צו זאגן: רבי, מיר ווייסן, אז דו ביסט ווארהאפטיק, און אז דו לערנסט באמת דעם וועג פון ה׳, און פרעגסט נישט נאך קיינעם; מחמת דו ביסט נישט נושא פנים קיין מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","זאג זשע אונדז, וואס מיינסטו: מעג מען געבן דעם קיסר מס, אדער נישט? ");
INSERT INTO ydd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","יהושע/ישוע האט אבער פארשטאנען זייער בייזוויליקייט, און האט געזאגט: וואס פרואווט איר מיך אויס, צבועקעס? ");
INSERT INTO ydd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ווייזט מיר די מטבע פון מס! און זיי האבן אים געברענגט א דינר. ");
INSERT INTO ydd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","און ער זאגט צו זיי: וועמעס איז דאס בילד און די אויפשריפט? ");
INSERT INTO ydd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","זאגן זיי; דעם קיסרס. זאגט ער דעמאלט צו זיי: גיט זשע אפ דעם קיסר, וואס איז דעם קיסרס; און צו ה׳, וואס עס געהערט צו ה׳! ");
INSERT INTO ydd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","און ווען זיי האבן דאס געהערט, האבן זיי זיך געוואונדערט, האבן אים פארלאזט, און זענען אוועקגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","אין יענעם טאג זענען געקומען צו אים צדוקים, וואס זאגן, אז עס איז נישטא קיין תחית המתים, און האבן אים געפרעגט, ");
INSERT INTO ydd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","אזוי צו זאגן: רבי, משה האט געזאגט: ווען עמיצער וועט שטארבן, נישט האבנדיק קיין קינדער, זאל זיין ברודער מיבם‑זיין זיין ווייב, און אויפשטעלן זאמען צו זיין ברודער. ");
INSERT INTO ydd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","און ביי אונדז זענען געווען זיבן ברידער. און דער ערשטער האט חתונה געהאט און איז געשטארבן, און ווייל ער האט נישט געהאט קיין זאמען, האט ער איבערגעלאזט זיין ווייב צו זיין ברודער. ");
INSERT INTO ydd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","דעסגלייכן אויך דער אנדערער און דער דריטער, ביז צום זיבעטן. ");
INSERT INTO ydd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","צולעצט, נאך אלע, איז די פרוי געשטארבן. ");
INSERT INTO ydd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","דעריבער, ביי תחית המתים, וועמעס ווייב פון די זיבן וועט זי זיין? מחמת אלע האבן זי דאך געהאט. ");
INSERT INTO ydd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","יהושע/ישוע אבער האט ענטפערנדיק צו זיי געזאגט: איר בלאנדזשעט, ווייל איר קענט נישט די כתבי (הקודש), און אויך נישט די קראפט פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","מחמת ביי תחית המתים נישט מען האט חתונה, נישט מען מאכט חתונה, נאר מען איז ווי מלאכים אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","און וואס שייך תחית המתים, האט איר דען נישט געלייענט, וואס עס איז געזאגט געווארן צו אייך פון ה׳, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","איך בין דער ג‑ט פון אברהם, און דער ג‑ט פון יצחק, און דער ג‑ט פון יעקב? ער איז נישט דער ג‑ט פון טויטע, נאר פון לעבעדיקע. ");
INSERT INTO ydd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","און ווי די המונים מענטשן האבן דאס געהערט, האבן זיי געשטוינט איבער זיין תורה. ");
INSERT INTO ydd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","און ווען די פרושים האבן געהערט, אז ער האט די צדוקים פארשטאפט דאס מויל, האבן זיי זיך פארזאמלט; ");
INSERT INTO ydd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","און איינער פון זיי, א תלמיד חכם, האט אים אויסגעפרואווט און געפרעגט: ");
INSERT INTO ydd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","רבי, וועלכע מצווה איז די גרעסטע אין דער תורה? ");
INSERT INTO ydd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","און ער האט צו אים געזאגט: דו זאלסט ליב האבן דעם האר דיין ג‑ט פון דיין גאנצן הארצן, און מיט דיין גאנצער נשמה, און מיט דיין גאנצן פארשטאנד. (דברים ו, ה.) ");
INSERT INTO ydd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","דאס איז די גרעסטע און די ערשטע מצווה. ");
INSERT INTO ydd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","אן אנדערע, וואס איז גלייך צו דער, איז: דו זאלסט ליב האבן דיין חבר, ווי דיך אליין. (ויקרא יט, יה.) ");
INSERT INTO ydd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","אויף די דאזיקע צוויי מצוות הענגט די גאנצע תורה, און די נביאים. ");
INSERT INTO ydd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","און בשעת די פרושים האבן זיך פארזאמלט, האט יהושע/ישוע זיי געשטעלט א קשיא, ");
INSERT INTO ydd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","אזוי צו זאגן: וואס דענקט איר וועגן דעם משיח? וועמעס זון איז ער? זאגן זיי צו אים דודס. ");
INSERT INTO ydd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","זאגט ער צו זיי: ווי אזוי זשע רופט אים דוד דורך דעם רוח (הקודש) האר, ווען ער זאגט: ");
INSERT INTO ydd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","דער האר האט געזאגט צו מיין האר: זיץ ביי מיין רעכטער זייט, ביז איך וועל אנידערלייגן דיינע פיינט פאר א פוסבענקעלע פאר דיינע פיס? ");
INSERT INTO ydd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","און ווען דוד רופט אים האר, ווי אזוי זשע איז ער זיין זון? ");
INSERT INTO ydd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","און קיינער האט אים נישט געקענט ענטפערן קיין ווארט. און עס האט זיך שוין קיינער אויך מער נישט אונטערגעשטעלט פון יענעם טאג אָן אים עפעס צו פרעגן. ");
INSERT INTO ydd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","דעמאלט האט יהושע/ישוע גערעדט צו די המונים מענטשן און צו זיינע תלמידים, ");
INSERT INTO ydd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","אזוי צו זאגן: די סופרים און די פרושים האבן זיך אנידערגעזעצט אויף משהס שטול. ");
INSERT INTO ydd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","דעריבער אלץ, וואס זיי וועלן אייך זאגן, זאלט איר טאן און אפהיטן; טוט אבער נישט לויט זייערע מעשים; מחמת זיי זאגן, און טאן נישט. ");
INSERT INTO ydd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","זיי בינדן שווערע לאסטן און לייגן זיי אויף מענטשנס שולטערן; אליין אבער ווילן זיי די דאזיקע אפילו מיט דעם פינגער נישט אנרירן. ");
INSERT INTO ydd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","און אלע זייערע מעשים טאן זיי, כדי פון לייטן געזען צו ווערן, מחמת זיי מאכן ברייט זייערע תפילין, און לאנג די ציצית, ");
INSERT INTO ydd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","און האבן ליב דאס ארט אויבנאן אויף סעודות, און די ערשטע ערטער אין שול, ");
INSERT INTO ydd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","און דאס שלום אפגעבן אויף די מערקפלעצער, און פון לייטן גערופן צו ווערן רבי! ");
INSERT INTO ydd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","איר אבער זאלט זיך נישט רופן רבי, מחמת איינער איז אייער רבי, און איר אלע זענט ברידער. ");
INSERT INTO ydd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","און רופט נישט קיינעם אויף דער ערד אייער פאטער; מחמת איינער איז אייער פאטער, וואס איז אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","איר זאלט זיך אויך נישט רופן מדריכים; ווייל איינער איז אייער מדריך, דער משיח. ");
INSERT INTO ydd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","דער גרעסטער צווישן אייך זאל זיין אייער משרת. ");
INSERT INTO ydd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","און ווער עס וועט זיך אליין דערהייבן, דער וועט דערנידעריקט ווערן; און ווער עס וועט זיך אליין דערנידעריקן, דער וועט דערהייבט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","וויי איז אבער צו אייך, סופרים און פרושים, צבועקעס! אז איר פארשליסט דאס מלכות השמים פאר די מענטשן. ווארום איר גייט נישט אריין, און די אריינקומענדיקע לאזט איר נישט אריינגיין. ");
INSERT INTO ydd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(וויי איז צו אייך, סופרים און פרושים, צבועקעס! אז איר שלינגט איין די הייזער פון די אלמנות, און פאר אן אויסרייד דאוונט איר לאנג. דערפאר וועט איר באקומען א הארבער משפט.) ");
INSERT INTO ydd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","וויי איז צו אייך, סופרים און פרושים, צבועקעס! אז איר פארט ארום איבער ים און יבשה, כדי צו מאכן א גר; און ווען ער ווערט עס שוין, מאכט איר אים פאר א בן גיהנום טאפלט מער ווי איר זענט אליין. ");
INSERT INTO ydd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","וויי איז צו אייך, בלינדע מנהיגים, וואס זאגן: ווער עס שווערט ביים היכל, איז עס גארנישט; אבער ווער עס שווערט ביים גאלד פון היכל, דער איז חייב. ");
INSERT INTO ydd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","איר נאראנים און בלינדע; מחמת וואס איז גרעסער, דאס גאלד אדער דער היכל, וואס הייליקט דאס גאלד? ");
INSERT INTO ydd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","און: ווער עס שווערט ביים מזבח, דאס איז גארנישט; ווער אבער עס שווערט ביים קרבן, וואס ליגט דערויף, דער איז חייב. ");
INSERT INTO ydd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","איר בלינדע! מחמת וואס איז גרעסער, דאס קרבן אדער דער מזבח, וואס הייליקט דאס קרבן? ");
INSERT INTO ydd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","דעריבער ווער עס שווערט ביים מזבח, דער שווערט ביי אים און ביי אלעם, וואס איז אויף אים. ");
INSERT INTO ydd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","און ווער עס שווערט ביים היכל, דער שווערט ביי אים, און ביי דעם, וואס וואוינט דרינען. ");
INSERT INTO ydd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","און ווער עס שווערט ביים הימל, דער שווערט ביי ה׳ס כסא הכבוד און ביי דעם, וואס זיצט דערויף. ");
INSERT INTO ydd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","וויי איז צו אייך, סופרים און פרושים, צבועקעס! אז איר גיט אפ מעשר פון דער מיענטע און דעם דיל און דעם קימל, און פארנאכלעסיקט די שווערערע זאכן פון דער תורה: דאס משפט און דעם חסד און די אמונה! די דאזיקע זאכן האט איר געדארפט טאן, און יענע נישט פארנאכלעסיקן. ");
INSERT INTO ydd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","איר בלינדע פירער, וואס זייען דורך די מוק, און שלינגען אראפ דאס קעמל. ");
INSERT INTO ydd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","וויי איז צו אייך, סופרים און פרושים, צבועקעס! אז איר מאכט ריין דאס אויסנווייניקסטע פון דעם בעכער און דער שיסל, פון אינעווייניק אבער זענען זיי פול מיט גזלה און נישט איינגעהאלטנקייט. ");
INSERT INTO ydd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","דו בלינדער פרוש, רייניק קודם כל דאס אינעווייניקסטע פון דעם בעכער, כדי אויך דאס אויסנווייניקסטע זאל ווערן ריין. ");
INSERT INTO ydd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","וויי איז צו אייך, סופרים און פרושים, צבועקעס! אז איר זענט גלייך צו געקאלעכטע קברים, וואס פון אויסנווייניק זען זיי אויס שיין, פון אינעווייניק אבער זענען זיי פול מיט ביינער פון מתים, און יעדער אומריינקייט. ");
INSERT INTO ydd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","אָט אזוי ווייזט איר זיך ארויס פון דרויסן ווי צדיקים פאר די מענטשן, פון אינעווייניק אבער זענט איר פול מיט צביעות און רשעות. ");
INSERT INTO ydd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","וויי איז צו אייך, סופרים און פרושים, צבועקעס! אז איר בויט אויף די קברים פון די נביאים, און באצירט די מצבות פון די צדיקים, ");
INSERT INTO ydd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","און זאגט: אויב מיר וואלטן געלעבט אין די טעג פון אונדזערע עלטערן, וואלטן מיר זיך נישט באטייליקט מיט זיי אין דעם בלוט פון די נביאים. ");
INSERT INTO ydd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","אזוי זענט איר עדות צו זיך אליין, אז איר זענט קינדער פון די נביאים מערדער. ");
INSERT INTO ydd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","און איר מאכט פול די מאס פון אייערע עלטערן! ");
INSERT INTO ydd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","איר שלאנגען! גזע פון להכעיסניקעס! ווי אזוי וועט איר אנטרינען פון דעם משפט פון גיהנום? ");
INSERT INTO ydd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","דערפאר, זע, איך שיק צו אייך נביאים און חכמים, און סופרים; א טייל פון זיי וועט איר טייטן און לאזן אויפהענגען אויף דער בוים; און א טייל פון זיי וועט איר שלאגן מיט ריטער אין אייערע שולן, און פארפאלגן פון שטאט צו שטאט; ");
INSERT INTO ydd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","כדי עס זאל קומען אויף אייך דאס גאנצע רעכטפארטיקע בלוט, וואס איז פארגאסן געווארן אויף דער ערד, פון דעם בלוט פון הבל דעם צדיק ביז צום בלוט פון זכריה בן ברכיה, וועמען איר האט געהרגעט צווישן דעם היכל און דעם מזבח. ");
INSERT INTO ydd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","באמת זאג איך אייך, דאס אלץ וועט קומען אויף דעם דאזיקן דור. ");
INSERT INTO ydd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ירושלים, ירושלים, וואס הרגעסט די נביאים, און שטייניקסט די, וואס זענען געשיקט צו דיר! וויפל מאל האב איך געוואלט איינזאמלען דיינע קינדער, ווי א הון זאמלט איין אירע עופהלעך אונטער די פליגל, און איר האט נישט געוואלט. ");
INSERT INTO ydd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","זע, אייער הויז וועט אייך איבערגעלאזט ווערן פארוויסט. ");
INSERT INTO ydd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","מחמת איך זאג אייך: פון איצט אָן וועט איר מיך מער נישט זען, ביז איר וועט זאגן: ברוך הבא בשם ה׳! ");
INSERT INTO ydd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","און יהושע/ישוע איז ארויסגעגאנגען פון בית המקדש, און איז אוועקגעגאנגען; און זיינע תלמידים זענען צוגעגאנגען צו אים, כדי אים צו ווייזן די בנינים פון בית המקדש. ");
INSERT INTO ydd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ער אבער האט ענטפערנדיק צו זיי געזאגט: איר זעט דאס אלץ? באמת זאג איך אייך, עס וועט דא נישט איבערגעלאזט ווערן א שטיין אויף א שטיין, וואס וועט נישט אנידערגעריסן ווערן! ");
INSERT INTO ydd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","און ווען ער איז געזעסן אויפן הר הזיתים, זענען זיינע תלמידים צוגעקומען צו אים, בשעת זיי זענען געווען אליין, און האבן געזאגט: זאג אונדז, ווען וועט דאס געשען, און וואס וועט זיין דאס אות פון דיין קומען, און פון דעם קץ פון דער וועלט? ");
INSERT INTO ydd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","און יהושע/ישוע האט ענטפערנדיק צו זיי געזאגט: זעט, אז קיינער זאל אייך נישט פארפירן! ");
INSERT INTO ydd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","מחמת א סך וועלן קומען אין מיין נאמען, אזוי צו זאגן: איך בין דער משיח; און פארפירן א סך. ");
INSERT INTO ydd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","און איר וועט הערן פון מלחמות און שמועות פון מלחמות; גיט אכטונג, דערשרעקט זיך נישט; מחמת דאס מוז געשען, נאר עס איז נאך נישט דער קץ. ");
INSERT INTO ydd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","מחמת א פאלק וועט זיך אויפהויבן קעגן א פאלק, און א מלוכה קעגן א מלוכה; און עס וועלן זיין הונגער נויטן און ערדציטערנישן אויף פארשיידענע ערטער. ");
INSERT INTO ydd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","דאס אלץ אבער איז דער אנהויב פון די ווייען. ");
INSERT INTO ydd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","דעמאלט וועט מען אייך איבערגעבן צו באדריקונג, און מען וועט אייך טייטן; און איר וועט זיין געהאסט פון אלע פעלקער צוליב מיין נאמען. ");
INSERT INTO ydd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","און דעמאלט וועלן א סך שטרויכלען, און פארראטן איינס דאס אנדערע, און זיך האסן איינס דאס אנדערע. ");
INSERT INTO ydd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","און עס וועלן אויפשטיין פיל פאלשע נביאים, און פארפירן א סך. ");
INSERT INTO ydd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","און דורך דעם וואס אומגערעכטיקייט וועט זיך פארפילפאכן, וועט די ליבע פון א סך זיך אפקילן. ");
INSERT INTO ydd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ווער אבער עס האלט אויס ביז צום סוף, דער וועט געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","און די דאזיקע גוטע בשורה פון דעם מלכות וועט אויסגערופן ווערן אין דער גאנצער באוואוינטער וועלט, ווי אן עדות צו אלע פעלקער, און דעמאלט וועט קומען דער קץ. ");
INSERT INTO ydd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","דעריבער ווען איר זעט די אומווירדיקייט פון דער פארוויסטונג, וואס איז געזאגט געווארן דורך דניאל הנביא, שטיין אויף דעם מקום קדוש—זאל דער לייענער פארשטיין! (דניאל יב, יא.)— ");
INSERT INTO ydd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","דעמאלט זאלן די, וואס זענען אין יהודה, אנטלויפן צו די בערג; ");
INSERT INTO ydd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","דער, וואס איז אויפן דאך, זאל נישט אראפגיין נעמען עפעס פון זיין הויז; ");
INSERT INTO ydd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","און דער, וואס איז אין פעלד, זאל זיך נישט אומקערן צוריק, צו נעמען זיין בגד. ");
INSERT INTO ydd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","אבער וויי איז צו די מעוברתדיקע און צו די אנזויגערינס אין יענע טעג! ");
INSERT INTO ydd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","און טוט תפילה, אז אייער אנטרינונג זאל נישט געשען אין ווינטער, און נישט שבת. ");
INSERT INTO ydd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","מחמת עס וועס דעמאלט זיין א גרויסע צרה, וואס אויסגלייכן איז נישט געווען פונם אנהויב פון דער וועלט ביז אצונד, ");
INSERT INTO ydd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","און וועט אויך מער נישט זיין. און אויב יענע טעג וואלטן נישט פארקירצט געווארן, וואלט קיין שום בשר (ודם) נישט ניצול געווארן; נאר צוליב די אויסדערוויילטע וועלן יענע טעג יא פארקירצט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ווען עמיצער וועט אייך דעמאלט זאגן: זע, דא איז דער משיח, אדער: דא! זאלט איר עס נישט גלויבן. ");
INSERT INTO ydd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","מחמת עס וועלן אויפשטיין פאלשע משיחים, און פאלשע נביאים, און וועלן געבן גרויסע אותות און מופתים, אזש צו פארפירן, אויב מעגלעך, אפילו די אויסדערוויילטע. ");
INSERT INTO ydd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","זע, איך האב עס אייך פארויסגעזאגט. ");
INSERT INTO ydd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ווען זשע זיי וועלן אייך זאגן: זע, ער איז אין דער מדבר; זאלט איר נישט ארויסגיין; זע, (בחדרי) חדרים; גלויבט עס נישט. ");
INSERT INTO ydd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","מחמת אזויווי דער בליץ קומט ארויס פון מזרח, און שיינט ביז מערב, אזוי וועט זיין דאס קומען פון דעם בר אנש. ");
INSERT INTO ydd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","נאר וואו דער טויטער קערפער איז דארט וועלן זיך פארזאמלען די אדלערס. ");
INSERT INTO ydd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","און באלד נאך דער צרה פון יענע טעג, וועט די זון פארפינסטערט ווערן, און די לבנה וועט נישט געבן איר ליכט, און די שטערן וועלן פאלן פון הימל, און די כוחות פון הימל וועלן דערשיטערט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","און דעמאלט וועט זיך באווייזן דאס צייכן פון דעם בר אנש אין הימל, און דעמאלט וועלן אלע משפחות פון דער ערד קלאגן, און וועלן זען דעם בר אנש קומען אויף די וואלקנס פון הימל מיט גרויס מאכט און הערלעכקייט. (דניאל ז, יג, יד.) ");
INSERT INTO ydd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","און ער וועט שיקן זיינע מלאכים מיט א גרויסן שופר, און זיי וועלן איינזאמלען זיינע אויסדערוויילטע פון די פיר ווינטן, פון איין עק הימל ביז צום אנדערן עק הימל. ");
INSERT INTO ydd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","און פון דעם פייגנבוים לערנט זיך דאס משל: ווען זיין צווייג ווערט שוין זאפטיק, און ברענגט ארויס בלעטער, ווייסט איר, אז זומער איז נאענט. ");
INSERT INTO ydd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","אזוי אויך איר, ווען איר זעט דאס אלץ, זאלט וויסן, אז עס איז נאענט ביי דער טיר. ");
INSERT INTO ydd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","באמת זאג איך אייך, דאס דאזיקע דור וועט נישט פארגיין, ביז דאס אלץ וועט געשען; ");
INSERT INTO ydd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","דער הימל און די ערד וועלן פארגיין, מיינע ווערטער אבער וועלן בשום אופן נישט פארגיין, ");
INSERT INTO ydd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","נאר וואס שייך יענעם טאג און שעה ווייסט קיינער נישט, אפילו נישט די מלאכים אין הימל, אויך דער זון נישט, אחוץ דער פאטער אליין. ");
INSERT INTO ydd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","מחמת אזוי ווי עס איז געווען אין טעג פון נוח, אזוי וועט עס זיין ביי דעם קומען פון דעם בר אנש, ");
INSERT INTO ydd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","מחמת ווי אין יענע טעג פארן מבול האבן זיי געגעסן און געטרונקען, חתונה געהאט און חתונה געמאכט, ביז צו דעם טאג, ווען נוח איז אריינגאנגען אין דער תיבה, ");
INSERT INTO ydd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","און האבן גארנישט געוואוסט ביז דאס מבול איז געקומען, און אלעמען אוועקגעטראגן; אזוי וועט אויך זיין ביים קומען פון דעם בר אנש. ");
INSERT INTO ydd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","דעמאלט וועלן צוויי זיין אין פעלד; איינער ווערט מיטגענומען, און איינער איבערגעלאזט. ");
INSERT INTO ydd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","צוויי פרויען וועלן מאלן אויף דער מיל; איינע ווערט מיטגענומען, און איינע איבערגעלאזט. ");
INSERT INTO ydd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","דעריבער וואכט, ווייל איר ווייסט נישט, וועלכן טאג אייער האר קומט. ");
INSERT INTO ydd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","דאס אבער זאלט איר וויסן, אז אויב דער בעל הבית וואלט געוואוסט אין וועלכן משמר דער גנב קומט, וואלט ער געהאלטן וואך, און נישט דערלאזט אונטערגראבן זיין הויז. ");
INSERT INTO ydd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","דערפאר זאלט איר אויך זיין גרייט! ווייל דער בר אנש קומט אין א שעה, ווען איר מיינט נישט. ");
INSERT INTO ydd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ווער זשע איז דער געטרייער און קלוגער קנעכט, וועמען דער האר האט געזעצט איבער זיין הויזגעזינד, אז ער זאל זיי געבן די שפייז אין דער ריכטיקער צייט? ");
INSERT INTO ydd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","וואויל איז יענעם קנעכט, וואס, ווען זיין האר קומט, געפינט ער אים אזוי טאן. ");
INSERT INTO ydd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","באמת זאג איך אייך, ער וועט אים זעצן איבער אלע זיינע גיטער. ");
INSERT INTO ydd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","אויב אבער יענער שלעכטער קנעכט וועט זאגן אין זיין הארצן: מיין האר זוימט זיך; ");
INSERT INTO ydd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","און וועט אנהויבן צו שלאגן זיינע מיטקנעכט, און עסן און טרינקען מיט די שכורים; ");
INSERT INTO ydd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","אזוי וועט דער האר פון יענעם קנעכט קומען אין א טאג, ווען ער ריכט זיך נישט, און אין א שעה, וואס ער ווייסט נישט, ");
INSERT INTO ydd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","און וועט אים צעשניידן אויף שטיקער, און לייגן זיין חלק מיט די צבועקעס. דארטן וועט זיין דאס קלאגן און קריצן מיט די ציין. ");
INSERT INTO ydd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","דעמאלט וועט דאס מלכות השמים זיין געגליכן צו צען יונגפרויען, וואס האבן גענומען זייערע לאמפן, און זענען אנטקעגנגעגאנגען דעם חתן. ");
INSERT INTO ydd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","און פינף פון זיי זענען געווען נארישע, און פינף קלוגע. ");
INSERT INTO ydd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","מחמת די נארישע האבן גענומען די לאמפן, און נישט מיטגענומען מיט זיך קיין אייל. ");
INSERT INTO ydd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","די קלוגע אבער האבן גענומען אייל אין זייערע געפעסן, צוזאמען מיט זייערע לאמפן. ");
INSERT INTO ydd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","און בשעת דער חתן האט זיך געזאמט, האבן אלע געדרעמלט און זענען איינגעשלאפן. ");
INSERT INTO ydd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ארום האלבער נאכט אבער איז געווארן א געשריי: זע, דער חתן קומט! גייט אים אנטקעגן! ");
INSERT INTO ydd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","דעמאלט האבן זיך יענע אלע יונגפרויען אויפגעכאפט, און האבן געברענגט אין ארדנונג זייערע לאמפן. ");
INSERT INTO ydd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","און די נארישע האבן געזאגט צו די קלוגע: גיט אונדז פון אייער אייל; ווייל אונדזערע לאמפן לעשן זיך אויס. ");
INSERT INTO ydd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","און די קלוגע האבן געענטפערט, און געזאגט: פאר קיין פאל נישט! טאמער וועט נישט גענוג פאר אונדז און פאר אייך! גייט ליבער צו די הענדלער, און קויפט זיך. ");
INSERT INTO ydd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","און בשעת זיי זענען אוועקגעגאנגען קויפן, איז דער חתן געקומען; און די, וואס זענען געווען גרייט, זענען אריינגעגאנגען מיט אים אויף דער חתונה, און די טיר איז פארשלאסן געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","און שפעטער קומען אויך די איבריקע יונגפרויען, און זאגן: האר, האר, עפן אונדז אויף! ");
INSERT INTO ydd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ער אבער האט ענטפערנדיק געזאגט: באמת זאג איך אייך, איך קען אייך נישט! ");
INSERT INTO ydd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","וואכט זשע; ווייל איר ווייסט נישט דעם טאג, און אויך נישט די שעה. ");
INSERT INTO ydd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","מחמת גלייך ווי א מענטש פארן אוועקפארן, האט צונויפגערופן זיינע קנעכט, און זיי איבערגעגעבן זיינע גיטער; ");
INSERT INTO ydd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","און איינעם האט ער געגעבן פינף טאלאנטן, דעם אנדערן צוויי, און דעם דריטן איינעם; יעדן לויט זיין אייגענעם כוח; און איז באלד אוועקגעפארן. ");
INSERT INTO ydd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","און דער, וואס האט באקומען די פינף טאלאנטן, איז געגאנגען און האט געהאנדלט מיט זיי, און פארדינט אנדערע פינף. ");
INSERT INTO ydd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","דעסגלייכן דער, וואס האט באקומען די צוויי טאלאנטן, האט פארדינט אנדערע צוויי. ");
INSERT INTO ydd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","דער אבער, וואס האט באקומען דעם איינעם, איז געגאנגען און האט געגראבן אין דער ערד, און פארבארגן זיין הארס געלט. ");
INSERT INTO ydd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","און נאך א לאנגער צייט קומט דער האר פון יענע קנעכט, און מאכט א חשבון מיט זיי. ");
INSERT INTO ydd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","און עס איז געקומען דער, וואס האט באקומען די פינף טאלאנטן, און האט געברענגט אנדערע פינף טאלאנטן, און געזאגט: האר, דו האסט מיר איבערגעגעבן פינף טאלאנטן; זע, איך האב פארדינט אנדערע פינף טאלאנטן. ");
INSERT INTO ydd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","האט זיין האר געזאגט צו אים: וואויל! דו גוטער און געטרייער קנעכט! ביסט געווען געטריי איבער ווייניק, איך וועל דיך זעצן איבער א סך; גיי אריין צו דיין הארס שמחה! ");
INSERT INTO ydd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","איז געקומען אויך דער, וואס האט באקומען די צוויי טאלאנטן און האט געזאגט: האר, דו האסט מיר איבערגעגעבן צוויי טאלאנטן; זע, איך האב פארדינט אנדערע צוויי טאלאנטן. ");
INSERT INTO ydd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","האט זיין האר צו אים געזאגט: וואויל! דו גוטער און געטרייער קנעכט! ביסט געווען געטריי איבער ווייניק, איך וועל דיך זעצן איבער א סך; גיי אריין צו דיין הארס שמחה! ");
INSERT INTO ydd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","און עס איז געקומען אויך דער, וואס האט באקומען דעם איינעם טאלאנט. און האט געזאגט: האר, איך קען דיך, אז דו ביסט א הארטער מענטש; דו שניידסט, וואו דו האסט נישט געזייט. און זאמלסט, וואו דו האסט נישט צעשפרייט; ");
INSERT INTO ydd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","און ווייל איך האב מורא געהאט, בין איך געגאנגען און האב פארבארגן דיין טאלאנט אין דער ערד. אָט האסטו דאס דייניקע! ");
INSERT INTO ydd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","און זיין האר האט ענטפערנדיק צו אים געזאגט: דו בייזער און פוילער קנעכט! האסט געוואוסט, אז איך שנייד, וואו איך האב נישט געזייט און זאמל, וואו איך האב נישט צעשפרייט; ");
INSERT INTO ydd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","האסטו דעריבער געדארפט איינלייגן מיין געלט ביי די באנקירן, און ביי מיין קומען וואלט איך אפגענומען דאס מייניקע מיט פראצענט. ");
INSERT INTO ydd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","נעמט זשע פון אים אוועק דעם טאלאנט, און גיט אים דעם, וואס האט די צען טאלאנטן! ");
INSERT INTO ydd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","מחמת יעדן איינעם, וואס האט, וועט געגעבן ווערן, און ער וועט האבן א שפע; פון דעם אבער, וואס האט נישט, וועט פון אים אוועקגענומען ווערן אפילו דאס, וואס ער האט יא. ");
INSERT INTO ydd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","און דעם אומנוצלעכן קנעכט ווארפט ארויס אין דער אויסערסטער פינצטערניש. דארטן וועט זיין דאס קלאגן און קריצן מיט די ציין. ");
INSERT INTO ydd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ווען אבער דער בר אנש וועט קומען אין זיין הערלעכקייט, און אלע מלאכים מיט אים, וועט ער דעמאלט זיצן אויף זיין כסא הכבוד; ");
INSERT INTO ydd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","און פאר אים וועלן איינגעזאמלט ווערן אלע פעלקער, און ער וועט זיי אפשיידן איינס פונם אנדערן, אזויווי א פאסטוך שיידט אפ די שאף פון די ציגן. ");
INSERT INTO ydd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","און וועט שטעלן די שאף אויף זיין רעכטער זייט, די ציגן אבער אויף דער לינקער זייט. ");
INSERT INTO ydd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","דאן וועט דער קעניג זאגן צו די אויף זיין רעכטער זייט: קומט אהער, איר געבענטשטע פון מיין פאטער, ירשנט דאס מלכות, וואס איז צוגעגרייט געווארן פאר אייערטוועגן זינט די וועלט איז באשאפן געווארן! ");
INSERT INTO ydd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","מחמת איך בין געווען הונגעריק, און איר האט מיר געגעבן צו עסן; איך בין געווען דורשטיק, און איר האט מיר געגעבן צו טרינקען; איך בין געווען אן אורח, און איר האט מיך אריינגענומען; ");
INSERT INTO ydd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","א נאקעטער, און איר האט מיך באקליידט; איך בין געווען קראנק, און איר האט זיך אומגעקוקט אויף מיר; איך בין געזעסן אין תפיסה, און איר זענט געקומען צו מיר. ");
INSERT INTO ydd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","דעמאלט וועלן די צדיקים אים ענטפערן, אזוי צו זאגן: האר, ווען האבן מיר דיך געזען הונגעריק, און האבן דיך געשפייזט, אדער דורשטיק און האבן דיר געגעבן צו טרינקען? ");
INSERT INTO ydd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ווען האבן מיר דיך געזען אן אורח און דיך אריינגענומען, אדער נאקעט און האבן דיך באקליידט? ");
INSERT INTO ydd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ווען האבן מיר דיך געזען א קראנקן אדער אין תפיסה און זענען געקומען צו דיר? ");
INSERT INTO ydd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","און דער קעניג וועט ענטפערנדיק זאגן צו זיי: באמת זאג איך אייך, אויף וויפל איר האט עס געטאן צו איינעם פון די דאזיקע מיינע ברידער, די קלענסטע, האט איר עס געטאן צו מיר! ");
INSERT INTO ydd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","דעמאלט וועט ער אויך זאגן צו די אויף דער לינקער זייט: גייט אוועק פון מיר, איר פארשאלטענע, אין דעם אייביקן פייער אריין, וואס איז צוגעגרייט געווארן פארן טייוול און זיינע מלאכים! ");
INSERT INTO ydd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","מחמת איך בין געווען הונגעריק, און איר האט מיר נישט געגעבן צו עסן; איך בין געווען דורשטיק, און איר האט מיר נישט געגעבן צו טרינקען: ");
INSERT INTO ydd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","אן אורח בין איך געווען, און איר האט מיך נישט אריינגענומען; נאקעט, און איר האט מיך נישט באקליידט; קראנק און אין תפיסה, און איר האט זיך נישט אומגעקוקט אויף מיר, ");
INSERT INTO ydd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","דאן וועלן אויך זיי ענטפערן, אזוי צו זאגן: האר, ווען האבן מיר דיך געזען הונגעריק אדער דורשטיק אדער אן אורח אדער נאקעט אדער קראנק אדער אין תפיסה, און האבן דיך נישט באדינט? ");
INSERT INTO ydd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","דעמאלט וועט ער זיי ענטפערן, אזוי צו זאגן: אויף וויפל איר האט עס נישט געטאן צו איינעם פון די דאזיקע קלענסטע, האט איר עס אויך נישט געטאן צו מיר! ");
INSERT INTO ydd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","און די דאזיקע וועלן אוועקגיין צו אייביקער שטראף; די צדיקים אבער—צום אייביקן לעבן. ");
INSERT INTO ydd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","און עס איז געשען, ווען יהושע/ישוע האט געענדיקט אלע די דאזיקע ווערטער, האט ער געזאגט צו זיינע תלמידים: ");
INSERT INTO ydd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","איר ווייסט, אז אין צוויי טעג ארום איז פסח, און דער בר אנש ווערט איבערגעגעבן פאר אויפהענגען אויף א בוים צו ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","דעמאלט האבן זיך פארזאמלט די הויפט כהנים, און די זקנים פון פאלק, אין דעם הויף פון דעם כהן גדול, וואס האט געהייסן קיפא; ");
INSERT INTO ydd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","און זיי האבן זיך באראטן, כדי צו כאפן יהושען/ישוען מיט כיטרעקייט, און אים צו טייטן. ");
INSERT INTO ydd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","נאר, האבן זיי געזאגט: נישט יום טוב, כדי עס זאל נישט ווערן קיין מהומה צווישן דעם פאלק. ");
INSERT INTO ydd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","און בשעת יהושע/ישוע איז געווען אין בית‑היני אין שמעון דעם מצורעדיקנס הויז, ");
INSERT INTO ydd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","איז צוגעקומען צו אים א פרוי, וואס האט געהאט אן אלאבאסטער פלאש מיט זייער טייערן זאלבאייל, און דעם האט זי אויסגעגאסן אויף זיין קאפ, ווען ער איז געזעסן צום טיש. ");
INSERT INTO ydd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ווי אבער די תלמידים האבן עס געזען, זענען זיי געווארן בייז, און געזאגט: צו וואס דער דאזיקער שאדן? ");
INSERT INTO ydd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","מחמת דאס דאזיקע האט מען געקענט טייער פארקויפן, און עס געבן צו ארעמעלייט. ");
INSERT INTO ydd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","נאר יהושע/ישוע האט עס באמערקט, און האט צו זיי געזאגט: וואס פארשאפט איר עגמת נפש דער פרוי? זי האט דאך מיר געטאן א טובה! ");
INSERT INTO ydd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","מחמת די ארעמעלייט האט איר תמיד ביי אייך, מיך אבער האט איר נישט אלעמאל! ");
INSERT INTO ydd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","מחמת אויסגיסנדיק דעם דאזיקן זאלבאייל אויף מיין גוף, האט זי עס געטאן צו מיין קבורה. ");
INSERT INTO ydd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","באמת זאג איך אייך: וואו נאר די דאזיקע גוטע בשורה וועט אויסגערופן ווערן אין דער גאנצער וועלט, וועט מען אויך זאגן, וואס זי האט געטאן, איר לזכרון! ");
INSERT INTO ydd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","דעמאלט איז געגאנגען איינער פון די צוועלף, וואס האט געהייסן יהודה איש‑קריות, צו די הויפט כהנים, ");
INSERT INTO ydd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","און האט געזאגט: וואס ווילט איר מיר געבן, ווען איך וועל אים איבערגעבן צו אייך? און זיי האבן אים אפגעוואויגן דרייסיק שטיק זילבער. ");
INSERT INTO ydd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","און פון דעמאלט אן האט ער געזוכט א גוטע געלעגנהייט, כדי ער זאל אים פארראטן. ");
INSERT INTO ydd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","און דעם ערשטן טאג פון חג המצות זענען די תלמידים צוגעגאנגען צו יהושען/ישוען, אזוי צו זאגן: וואו ווילסטו זאלן מיר צוגרייטן פאר דיר צו עסן דאס קרבן פסח? ");
INSERT INTO ydd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","און ער האט געזאגט: גייט אין דער שטאט אריין צו דעם און דעם, און זאגט צו אים: דער רבי זאגט: מיין צייט איז נאענט; ביי דיר וויל איך מאכן פסח מיט מיינע תלמידים. ");
INSERT INTO ydd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","און די תלמידים האבן געטאן, ווי יהושע/ישוע האט זיי באפוילן; און צוגעגרייט דאס קרבן פסח. ");
INSERT INTO ydd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","און ווען עס איז געווארן אוונט, האט ער זיך אנידערגעזעצט צום טיש מיט די צוועלף תלמידים. ");
INSERT INTO ydd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","און בשעת זיי האבן געגעסן, האט ער געזאגט; באמת זאג איך אייך, אז איינער פון אייך וועט מיך פארראטן! ");
INSERT INTO ydd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","און זיי זענען געווארן זייער טרויעריק, און האבן אנגעהויבן, איינער נאכן אנדערן, צו זאגן צו אים: האר, בין איך דאס? ");
INSERT INTO ydd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","און ער האט ענטפערנדיק געזאגט: דער, וואס טונקט איין די האנט מיט מיר אין דער קערה, דער דאזיקער וועט מיך פארראטן. ");
INSERT INTO ydd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","דער בר אנש גייט טאקע לויט ווי עס שטייט געשריבן וועגן אים; וויי איז אבער צו יענעם מענטשן, דורך וועמען דער בר אנש ווערט פארראטן! עס וואלט געווען גוט פאר יענעם מענטשן, אויב ער וואלט גארנישט געבוירן געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","און יהודה, וואס האט אים פארראטן, האט ענטפערנדיק געזאגט: רבי, בין איך דאס? זאגט ער צו אים: דו האסט עס געזאגט! ");
INSERT INTO ydd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","און בשעת זיי האבן געגעסן, האט יהושע/ישוע גענומען ברויט, און האט געמאכט א ברכה, האט עס צעבראכן, און געגעבן צו די תלמידים, און געזאגט: נעמט, עסט! דאס איז מיין גוף. ");
INSERT INTO ydd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","און ער האט גענומען א כוס, געמאכט א ברכה, און געגעבן צו זיי, זאגנדיק: טרינקט אלע דערפון! ");
INSERT INTO ydd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","מחמת דאס איז מיין בלוט פון דעם נייעם בונד, וואס ווערט פארגאסן פאר פילע צו דער פארגעבונג פון זינד. ");
INSERT INTO ydd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","איך זאג אייך אבער, איך וועל מער נישט טרינקען פון איצט אָן פון דער פרוכט פונם וויינשטאק, ביז צו יענעם טאג, ווען איך וועל דאס טרינקען מיט אייך ניי אין דעם קעניגרייך פון מיין פאטער. ");
INSERT INTO ydd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","און זיי האבן אפגעזונגען הלל, און זענען ארויסגעגאנגען צום הר הזיתים. ");
INSERT INTO ydd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","דעמאלט זאגט יהושע/ישוע צו זיי: איר אלע וועט געשטרויכלט ווערן אין מיר אין דער דאזיקער נאכט; מחמת עס שטייט געשריבן: איך וועל שלאגן דעם פאסטוך, און די שאף פון דער סטאדע וועלן צעשפרייט ווערן. (זכריה יג, ז.) ");
INSERT INTO ydd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","נאר נאך מיין אויפשטיין, וועל איך פארויסגיין פאר אייך קיין גליל. ");
INSERT INTO ydd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","פעטרוס אבער האט ענטפערנדיק צו אים געזאגט: אפילו ווען אלע וועלן געשטרויכלט ווערן אין דיר, וועל איך מיך קיינמאל נישט שטרויכלען! ");
INSERT INTO ydd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","האט יהושע/ישוע צו אים געזאגט: באמת זאג איך דיר, אז אין דער דאזיקער נאכט, איידער א האן וועט א קריי טאן, וועסטו מיך דריי מאל פארלייקענען! ");
INSERT INTO ydd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","זאגט פעטרוס צו אים: און אויב איך זאל מוזן שטארבן מיט דיר, וועל איך דיך בשום אופן נישט פארלייקענען! דעסגלייכן האבן אויך אלע תלמידים געזאגט. ");
INSERT INTO ydd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","דאן גייט יהושע/ישוע מיט זיי אויף אן ארט, וואס הייסט גת‑שמני, און זאגט צו די תלמידים: זעצט זיך דא אנידער, ביז איך וועל אהינגיין דארטן און תפילה טאן. ");
INSERT INTO ydd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","און ער האט מיטגענומען פעטרוסן און זבדיס ביידע זין, און האט אנגעהויבן צו טרויערן און צו זיין באטריבט. ");
INSERT INTO ydd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","דעמאלט זאגט ער צו זיי: מיין נפש איז טיף באטריבט, ביז צום טויט! בלייבט דא, און וואכט מיט מיר! ");
INSERT INTO ydd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","און איז געגאנגען אביסל פארויס, און איז אנידערגעפאלן אויף זיין פנים, האט תפילה געטאן און געזאגט: מיין פאטער אויב עס איז מעגלעך, זאל אוועקגיין פון מיר דער דאזיקער בעכער; דאך נישט ווי איך וויל, נאר ווי דו! ");
INSERT INTO ydd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","און ער גייט צו צו די תלמידים, און געפינט זיי שלאפן, און זאגט צו פעטרוסן: אזוי, איר האט נישט געקענט וואכן מיט מיר איין שעה? ");
INSERT INTO ydd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","האלט וואך און טוט תפילה, כדי איר זאלט נישט קומען צו קיין נסיון! דער גייסט איז טאקע וויליק, דאס פלייש אבער איז שוואך. ");
INSERT INTO ydd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ווידער איז ער צום צווייטן מאל אוועקגעגאנגען, און האט תפילה געטאן, אזוי צו זאגן: מיין פאטער, אויב דאס דאזיקע קען נישט פארבייגיין, אחוץ איך זאל עס טרינקען, זאל דיין רצון געשען! ");
INSERT INTO ydd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","און ער איז געקומען און האט זיי ווידער געפונען שלאפן; מחמת זייערע אויגן זענען געווען שווער. ");
INSERT INTO ydd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","און ער האט זיי איבערגעלאזט, איז ווידער אוועקגעגאנגען, און תפילה געטאן צום דריטן מאל, זאגנדיק נאכאמאל די זעלביקע ווערטער. ");
INSERT INTO ydd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","דאן גייט ער צו צו די תלמידים, און זאגט צו זיי: איר שלאפט נאך אלץ, און רוט? זע, די שעה האט זיך דערנענטערט, און דער בר אנש ווערט פארראטן אין די הענט פון חוטאים! ");
INSERT INTO ydd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","שטייט אויף, לאמיר גיין! זע, דער וואס פארראט מיך איז נאענט! ");
INSERT INTO ydd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","און בשעת ער האט נאך גערעדט, זע, יהודה, איינער פון די צוועלף, איז געקומען און מיט אים א גרויסער המון מיט שווערדן און שטאנגען, פון די הויפט כהנים און זקנים פון פאלק. ");
INSERT INTO ydd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","דער אבער, וואס האט אים פארראטן, האט זיי געגעבן א צייכן, און געזאגט: וועמען איך וועל געבן א קוש, דער איז עס, כאפט אים! ");
INSERT INTO ydd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","און גלייך איז ער צוגעגאנגען צו יהושען/ישוען, און געזאגט: שלום, רבי! און האט אים געקושט. ");
INSERT INTO ydd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","יהושע/ישוע אבער האט צו אים געזאגט: פריינד, צו וואס ביסטו געקומען? דעמאלט זענען זיי צוגעגאנגען און האבן ארויפגעלייגט די הענט אויף יהושען/ישוען, און אים גענומען. ");
INSERT INTO ydd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","און זע, איינער פון די, וואס זענען געווען מיט יהושען/ישוען, האט אויסגעשטרעקט די האנט, און ארויסגעצויגן זיין שווערד, און האט געשלאגן דעם כהן גדולס קנעכט, און אים אפגעהאקט אן אויער. ");
INSERT INTO ydd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","דעמאלט זאגט יהושע/ישוע צו אים: קער אום דיין שווערד אויף איר ארט! מחמת אלע, וואס נעמען א שווערד, וועלן אומקומען מיט דער שווערד. ");
INSERT INTO ydd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","אדער אפשר מיינסטו, אז איך קען נישט בעטן מיין פאטער, און ער וועט מיר אפילו איצט געבן מער ווי צוועלף מחנות מלאכים? ");
INSERT INTO ydd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","און וויאזוי זשע וואלטן די כתבי (הקודש) געקענט דערפילט ווערן, אז אָט אזוי מוז עס געשען? ");
INSERT INTO ydd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","אין יענער שעה האט יהושע/ישוע געזאגט צו די המונים מענטשן: ווי אנטקעגן א גזלן זענט איר ארויסגעקומען מיט שווערדן און שטאנגען, מיך צו כאפן. טאג אויס טאג איין בין איך געזעסן אין בית המקדש און געלערנט, און איר האט מיך נישט גענומען. ");
INSERT INTO ydd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","דאס אלץ אבער איז געשען, כדי די שריפטן פון די נביאים זאלן דערפילט ווערן. דעמאלט האבן אלע תלמידים אים פארלאזט, און זענען אנטלאפן. ");
INSERT INTO ydd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","און די, וואס האבן גענומען יהושען/ישוען, האבן אים אוועקגעפירט צו קיפא, דעם כהן גדול, וואו די סופרים און די זקנים זענען געווען פארזאמלט. ");
INSERT INTO ydd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","און פעטרוס האט אים נאכגעפאלגט פונדערווייטנס ביז צום הויף פון כהן גדול, און איז אריינגעגאנגען אינעווייניק, און זיך אנידערגעזעצט מיט די שומרים, צו זען דעם סוף. ");
INSERT INTO ydd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","און די הויפט כהנים און דאס גאנצע סנהדרין האבן געזוכט א פאלש עדות זאגן קעגן יהושען/ישוען, כדי זיי זאלן אים קענען טייטן; ");
INSERT INTO ydd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","און האבן נישט געפונען, הגם א סך פאלשע עדות זענען געקומען. צולעצט אבער זענען געקומען צוויי, ");
INSERT INTO ydd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","און האבן געזאגט: דער דאזיקער האט געזאגט: איך בין בכוח צו צעשטערן דעם היכל פון ה׳, און אים אויפצובויען אין דריי טאג. ");
INSERT INTO ydd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","און דער כהן גדול האט זיך אויפגעשטעלט, און געזאגט צו אים: דו ענטפערסט גארנישט? וואס איז דאס, וואס זיי זאגן עדות קעגן דיר? ");
INSERT INTO ydd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","יהושע/ישוע אבער האט געשוויגן. און דער כהן גדול האט געזאגט צו אים: איך באשווער דיך ביי דעם לעבעדיקן ג‑ט, אז דו זאלסט אונדז זאגן, צי דו ביסט דער משיח, דער זון פון דער אויבערשטער! ");
INSERT INTO ydd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","זאגט יהושע/ישוע צו אים: דו האסט עס געזאגט! דאך זאג איך אייך: פון איצט אָן וועט איר זען דעם בר אנש זיצן אויף דער רעכטער זייט פון דער גבורה, און קומען אויף די וואלקנס פון הימל! (תהלים קי, א; דניאל ז, יג-יד.) ");
INSERT INTO ydd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","דעמאלט האט דער כהן גדול צעריסן זיינע קליידער, זאגנדיק: ער האט געלעסטערט; וואס דארפן מיר נאך האבן עדות? זע, איר האט איצט געהערט די לעסטערונג. ");
INSERT INTO ydd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","וואס מיינט איר? און זיי האבן ענטפערנדיק געזאגט: ער איז חייב מיתה. ");
INSERT INTO ydd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","דאן האבן זיי אים געשפיגן אין פנים אריין און האבן אים געשלאגן מיט די פויסטן; ");
INSERT INTO ydd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","אנדערע האבן אים געגעבן פעטש, און געזאגט: משיח, זאג נבואות צו אונדז! ווער איז עס, וואס האט דיך געשלאגן? ");
INSERT INTO ydd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","און פעטרוס איז געזעסן אינדרויסן אויפן הויף. און א דינסטמויד איז צוגעקומען צו אים, און האט געזאגט: אויך דו ביסט געווען מיט יהושע/ישוע הגלילי! ");
INSERT INTO ydd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ער אבער האט עס געלייקנט פאר אלעמען, אזוי צו זאגן: איך ווייס נישט, וואס דו זאגסט! ");
INSERT INTO ydd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","און איז ארויסגעגאנגען צום פאדערהויז, און אן אנדערע האט אים דערזען, און זאגט צו די מענטשן דארטן: דער דאזיקער איז געווען מיט יהושע/ישוע פון נצרת! ");
INSERT INTO ydd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","און נאכאמאל האט ער עס געלייקנט מיט א שבועה: איך קען נישט דעם מענטשן! ");
INSERT INTO ydd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","און נאך א קליינער וויילע זענען צוגעקומען די, וואס זענען דארט געשטאנען, און האבן געזאגט צו פעטרוסן: עס איז אמת, אויך דו ביסט איינער פון זיי; מחמת אפילו דיין ארט רעדן פארראט דיך. ");
INSERT INTO ydd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","דעמאלט האט ער אנגעהויבן צו שעלטן און שווערן: איך קען נישט דעם מענטשן! און גלייך האט א האן געקרייט. ");
INSERT INTO ydd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","און פעטרוס האט זיך דערמאנט דאס ווארט פון יהושע/ישוע, וואס ער האט אים געהאט געזאגט: איידער א האן וועט א קריי טאן, וועסטו מיך דריי מאל פארלייקענען. און ער איז ארויסגעגאנגען אינדרויסן, און האט ביטער געוויינט. ");
INSERT INTO ydd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","און צומארגנס אינדערפרי האבן אלע הויפט כהנים און זקנים פון פאלק אנגענומען א באשלוס קעגן יהושען/ישוען, כדי אים צו טייטן; ");
INSERT INTO ydd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","און האבן אים געבונדן, און אוועקגעפירט, און איבערגעגעבן צו פילאטוסן, דעם גובערנאטאר. ");
INSERT INTO ydd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","דעמאלט אז יהודה, וואס האט אים פארראטן, האט געזען, דאס ער איז פארמשפט געווארן, האט ער חרטה געהאט, און אומגעקערט די דרייסיק שטיק זילבער צו די הויפט כהנים און זקנים, ");
INSERT INTO ydd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","אזוי צו זאגן: איך האב געזינדיקט, פארראטנדיק אומשולדיק בלוט! זיי אבער האבן געזאגט: וואס גייט דאס אונדז אָן? זארג דו וועגן דעם! ");
INSERT INTO ydd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","און ער האט א ווארף געטאן די זילבער שטיק אין היכל אריין, און איז אוועק! און איז געגאנגען און האט זיך אויפגעהאנגען. ");
INSERT INTO ydd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","און די הויפט כהנים האבן גענומען די זילבער שטיק, און געזאגט: מען טאר זיי נישט אריינלייגן אין דעם אוצר הקרבנות, ווייל עס איז בלוט געלט. ");
INSERT INTO ydd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","און נאך דעם ווי זיי האבן זיך באראטן, האבן זיי דערמיט געקויפט דעם טעפערס פעלד, א קבורה פאר די גרים. ");
INSERT INTO ydd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","דערפאר הייסט יענץ פעלד דאס בלוט פעלד ביז צום היינטיקן טאג. ");
INSERT INTO ydd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","דעמאלט איז דערפילט געווארן, וואס עס איז געווארן געזאגט דורך ירמיהו הנביא, אזוי צו זאגן: און זיי האבן גענומען די דרייסיק שטיק זילבער, דעם ווערט פון דעם געשעצטן, וועמען זיי האבן געשאצט, פון די קינדער ישראל; ");
INSERT INTO ydd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","און האבן זיי געגעבן פאר דעם טעפערס פעלד, לויט ווי דער האר האט מיר געבאטן. ");
INSERT INTO ydd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","און יהושע/ישוע איז געשטעלט געווארן פאר דעם גובערנאטאר, און דער גובערנאטאר האט אים געפרעגט, אזוי צו זאגן: צי ביסט דו דער קעניג פון די יידן? און יהושע/ישוע האט געזאגט; דו זאגסט עס! ");
INSERT INTO ydd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","און ווען ער איז אנגעקלאגט געווארן דורך די הויפט כהנים און זקנים, האט ער גארנישט געענטפערט. ");
INSERT INTO ydd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","דעמאלט זאגט פילאטוס צו אים: דו הערסט נישט, וואס זיי זאגן אלץ אויס קעגן דיר? ");
INSERT INTO ydd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","און ער האט אים נישט געענטפערט, אפילו נישט אויף איין איינציק ווארט, אזוי, אז דער גובערנאטאר האט זיך זייער געוואונדערט. ");
INSERT INTO ydd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","און אויף יעדן יום טוב איז דער גובערנאטאר געווען געוואוינט צו באפרייען פאר דעם פאלק איין געפאנגענעם, וועמען זיי האבן געוואלט. ");
INSERT INTO ydd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","און זיי האבן דעמאלט געהאט א גוט באקאנטן געפאנגענעם, וואס האט געהייסן בר‑אבא. ");
INSERT INTO ydd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","דעריבער ווען זיי האבן זיך פארזאמלט, האט פילאטוס צו זיי געזאגט: וועמען ווילט איר, אז איך זאל אייך באפרייען, בר‑אבאן אדער יהושען/ישוען, וואס מען רופט אים משיח? ");
INSERT INTO ydd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","מחמת ער האט געוואוסט, אז צוליב קנאה האבן זיי אים איבערגעגעבן. ");
INSERT INTO ydd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","און בשעת ער איז געזעסן אויף דעם כסא המשפט, האט זיין ווייב צו אים געשיקט, אזוי צו זאגן: זאלסט גארנישט האבן צו טאן מיט דעם דאזיקן צדיק; מחמת איך האב היינט א סך געליטן אין א חלום דורך אים! ");
INSERT INTO ydd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","די הויפט כהנים אבער און די זקנים האבן איבערגערעדט די המונים מענטשן, אז זיי זאלן פארלאנגען בר‑אבאן, יהושען/ישוען אבער צו לאזן אומברענגען. ");
INSERT INTO ydd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","און דער גובערנאטאר האט ענטפערנדיק צו זיי געזאגט: וועלכן פון די ביידע ווילט איר, אז איך זאל אייך באפרייען? און זיי האבן געזאגט: בר‑אבאן! ");
INSERT INTO ydd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","זאגט פילאטוס צו זיי: און וואס זאל איך טאן מיט יהושען/ישוען, וואס מען רופט אים משיח? זאגן אלע: ער זאל אויפהענגען אויף דער בוים! ");
INSERT INTO ydd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","און ער האט געזאגט: וואס פאר א בייז האט ער דען געטאן? זיי אבער האבן נאך מער געשריגן, אזוי צו זאגן: ער זאל אויפהענגען אויף דער בוים! ");
INSERT INTO ydd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","און ווען פילאטוס האט געזען, אז ער פועלט גארנישט, נאר אז עס ווערט א גרעסערע מהומה, האט ער גענומען וואסער און זיך אפגעוואשן די הענט פאר דעם המון מענטשן, און געזאגט: איך בין אומשולדיק וואס שייך דעם דאזיקן צדיקס בלוט; איר זעט. ");
INSERT INTO ydd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","און דער גאנצער עולם האט ענטפערנדיק געזאגט; זיין בלוט אויף אונדז, און אויף אונדזערע קינדער! ");
INSERT INTO ydd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","דאן האט ער זיי באפרייט בר‑אבאן; יהושען/ישוען אבער האט ער געלאזט שמייסן און אים איבערגעגעבן, אז ער זאל אויפהענגען אויף דער בוים ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","דערנאך האבן דעם גובערנאטארס זעלנער גענומען יהושען/ישוען אין פרעטאריום אריין, און האבן פארזאמלט ארום אים די גאנצע אפטיילונג. ");
INSERT INTO ydd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","און זיי האבן אים אויסגעטאן, און ארויפגעלייגט אויף אים א פורפור מאנטל. ");
INSERT INTO ydd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","און געפלאכטן א קרוין פון דערנער און זי ארויפגעזעצט אויף זיין קאפ, און האבן אים געגעבן א רוט אין זיין רעכטער האנט; האבן געבויגן די קני פאר אים, און אפגעשפאט פון אים, אזוי צו זאגן: שלום צו דיר, קעניג פון די יידן! ");
INSERT INTO ydd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","און האבן געשפיגן אויף אים, און גענומען די רוט און אים געשלאגן אויפן קאפ. ");
INSERT INTO ydd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","און ווען זיי האבן געהאט אפגעשפאט פון אים, האבן זיי אים אויסגעטאן דעם מאנטל, און אים אנגעטאן זיינע אייגענע מלבושים, און האבן אים אוועקגעפירט אויפהענגען אויף דער בוים צו ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","און ווי זיי זענען ארויסגעגאנגען, האבן זיי געפונען א מענטשן, א מאן פון קירניה, מיט דעם נאמען שמעון; דעם דאזיקן האבן זיי געצוואונגען, אז ער זאל טראגן זיין בוים. ");
INSERT INTO ydd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","און זענען געקומען צו אן ארט, וואס הייסט גלגלתא, דאס באטייט אן ארט פון א שארבן, ");
INSERT INTO ydd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","און האבן אים געגעבן צו טרינקען וויין געמישט מיט גאל; און ער האט עס טועם געווען און נישט געוואלט טרינקען. ");
INSERT INTO ydd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","און נאך דעם ווי זיי האבן אים אויפגעהאנגען אויף דער בוים, האבן זיי זיך צעטיילט זיינע מלבושים, ווארפנדיק גורל, ");
INSERT INTO ydd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","און האבן זיך אנידערגעזעצט און אים דארט באוואכט. ");
INSERT INTO ydd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","און זיי האבן געזעצט איבער זיין קאפ זיין באשולדיקונג, געשריבן: דאס איז יהושע/ישוע דער קעניג פון די יידן. ");
INSERT INTO ydd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","צו דער צייט ווערן מיט אים אויפגעהאנגען אויף א בוים צוויי גזלנים, איינער פון דער רעכטער זייט, און איינער פון דער לינקער זייט. ");
INSERT INTO ydd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","און די פארבייגייער האבן אים געלעסטערט, שאקלענדיק מיט זייערע קעפ, ");
INSERT INTO ydd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","און זאגנדיק; דו, וואס צעשטערסט דעם היכל, און בויסט אים אויף אין דריי טאג, ראטעווע דיך אליין! אויב דו ביסט דער זון פון דער אויבערשטער, קום אראפ פון בוים! ");
INSERT INTO ydd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","דעסגלייכן האבן אויך די הויפט כהנים מיט די סופרים און זקנים אפגעשפאט פון אים, און געזאגט: ");
INSERT INTO ydd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","אנדערע האט ער געהאלפן, זיך אליין קען ער נישט העלפן. ער איז דער מלך פון ישראל; זאל ער איצט אראפקומען פון בוים, און מיר וועלן גלויבן אין אים! ");
INSERT INTO ydd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ער האט געהאט בטחון אויף ה׳; זאל ער אים איצט מציל זיין, אויב ער וויל אים. ער האט דאך געזאגט: איך בין דער זון פון דער אויבערשטער! ");
INSERT INTO ydd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","און דאס זעלביקע האבן אויך די גזלנים, וואס זענען אויפגעהאנגען אויף א בוים געווארן מיט אים, אים פארגעווארפן. ");
INSERT INTO ydd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","און פון דער זעקסטער שעה אן איז געווארן א פינצטערניש איבערן גאנצן לאנד ביז דער ניינטער שעה. ");
INSERT INTO ydd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","און ארום דער ניינטער שעה האט יהושע/ישוע א געשריי געטאן מיט א הויך קול, אזוי צו זאגן: אלי אלי למה שבקתני! דאס באטייט: ג‑ט מיינער, ג‑ט מיינער, פארוואס האסטו מיך פארלאזט? ");
INSERT INTO ydd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","און ווען אייניקע פון די, וואס זענען דארט געשטאנען, האבן עס געהערט, האבן זיי געזאגט: ער רופט אליהון! ");
INSERT INTO ydd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","און באלד איז איינער פון זיי געלאפן, און גענומען א שוואם, און זי אנגעפילט מיט עסיק, און ארויפגעטאן אויף א שטעקן, און האט אים געגעבן צו טרינקען. ");
INSERT INTO ydd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","די איבריקע אבער האבן געזאגט: ווארט, לאמיר זען, צי אליהו קומט אים ראטעווען. ");
INSERT INTO ydd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","און יהושע/ישוע האט נאכאמאל א געשריי געטאן מיט א הויך קול, און האט אפגעגעבן זיין גייסט. ");
INSERT INTO ydd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","און זע, דאס פרוכת פון היכל האט זיך צעריסן אין צווייען פון אויבן ביז אראפ; און די ערד האט געציטערט; און די פעלדזן האבן זיך געשפאלטן; ");
INSERT INTO ydd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","און די קברים האבן זיך געעפנט; און א סך לייבער פון די איינגעשלאפענע קדושים זענען אויפגעשטאנען; ");
INSERT INTO ydd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","און זענען ארויס פון די קברים נאך זיין תחית המתים און זענען אריינגעקומען אין דער הייליקער שטאט אריין און האבן זיך באוויזן צו א סך. ");
INSERT INTO ydd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","און דער אפיציר און די מיט אים, וואס האבן באוואכט יהושען/ישוען, ווען זיי האבן געזען די ערדציטערניש, און וואס עס איז געשען, האבן זיך זייער געפארכטן, און געזאגט: ער איז באמת געווען דער זון פון דער אויבערשטער! ");
INSERT INTO ydd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","און דארט זענען געווען א סך פרויען, וואס האבן זיך צוגעקוקט פונדערווייטנס, וועלכע האבן נאכגעפאלגט יהושען/ישוען פון גליל, באדינענדיק אים; ");
INSERT INTO ydd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","צווישן זיי איז געווען מרים פון מגדלה, און מרים, די מוטער פון יעקב און יוסי, און די מוטער פון זבדיס קינדער. ");
INSERT INTO ydd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","און ווען עס איז געווארן אוונט, איז געקומען א רייכער מאן פון הרמתים, זיין נאמען איז געווען יוסף, וואס איז אליין אויך געווען ישועס תלמיד. ");
INSERT INTO ydd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","דער דאזיקער איז געגאנגען צו פילאטוסן, און האט באגערט ישועס קערפער. דעמאלט האט פילאטוס באפוילן, אז עס זאל אים געגעבן ווערן. ");
INSERT INTO ydd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","און יוסף האט גענומען דעם קערפער, און אים איינגעוויקלט אין א ריין ליילעך, ");
INSERT INTO ydd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","און האט אים אריינגעלייגט אין זיין נייעם קבר, וואס ער האט אויסגעהאקט אין דעם פעלדזן, און האט ארויפגעוועלגערט א גרויסן שטיין אויף דער טיר פון קבר, און איז אוועקגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","עס איז אבער דארטן געווען מרים פון מגדלה, און די אנדערע מרים, וועלכע האבן זיך אנידערגעזעצט אנטקעגנאיבער דעם קבר. ");
INSERT INTO ydd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","און צומארגנס, וואס איז נאך ערב שבת, האבן די הויפט כהנים און די פרושים זיך פארזאמלט ביי פילאטוסן, ");
INSERT INTO ydd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","און האבן געזאגט: האר, מיר דערמאנען זיך, אז יענער פארפירער האט געזאגט, בשעת ער האט נאך געלעבט: אין דריי טעג ארום וועל איך אויפשטיין. ");
INSERT INTO ydd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","באפעל זשע, אז דאס קבר זאל געהאלטן ווערן זיכער ביז צום דריטן טאג, טאמער וועלן די תלמידים קומען און אים אוועקגנבענען, און זאגן דעם פאלק: ער איז אויפגעשטאנען פון די טויטע; און דער לעצטער באטרוג וועט זיין ערגער פונם ערשטן. ");
INSERT INTO ydd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","האט פילאטוס צו זיי געזאגט: איר זאלט האבן א וואך! גייט און מאכט זיכער ווי איר פארשטייט. ");
INSERT INTO ydd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","און זיי זענען געגאנגען, און האבן פארזיכערט דאס קבר מיט דער וואך, און פארחתמעט דעם שטיין. ");
INSERT INTO ydd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","און נאך מוצאי שבת, ווען עס האט אנגעהויבן טאגן דעם ערשטן טאג פון דער וואך, איז געקומען מרים פון מגדלה און די אנדערע מרים צו זען דאס קבר. ");
INSERT INTO ydd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","און זע, עס איז געווארן א גרויסע ערדציטערניש; מחמת א מלאך פון דעם האר (ה׳) איז אראפגעקומען פון הימל, און איז צוגעגאנגען און האט אוועקגעקייקלט דעם שטיין, און זיך אנידערגעזעצט אויף אים. ");
INSERT INTO ydd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","און זיין געשטאלט איז געווען ווי דער בליץ, און זיין קלייד ווייס ווי שניי; ");
INSERT INTO ydd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","און פון מורא פאר אים האבן די היטער געציטערט, און זענען געווארן ווי מתים. ");
INSERT INTO ydd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","און דער מלאך האט ענטפערנדיק געזאגט צו די פרויען: האט נישט קיין מורא! מחמת איך ווייס, אז איר זוכט יהושען/ישוען וואס איז אויפגעהאנגען אויף א בוים געווארן. ");
INSERT INTO ydd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ער איז דא נישטא; מחמת ער איז אויפגעשטאנען, לויט ווי ער האט געזאגט. קומט אהער, און זעט דאס ארט, וואו דער האר איז געלעגן. ");
INSERT INTO ydd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","און גייט גיך, און זאגט זיינע תלמידים, אז ער איז אויפגעשטאנען פון די טויטע: און זע, ער גייט פארויס פאר אייך קיין גליל; דארטן וועט איר אים זען. זע, איך האב עס אייך געזאגט. ");
INSERT INTO ydd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","און זיי זענען איילנדיק אוועק פון קבר מיט מורא און גרויסער שמחה, און זענען געלאפן עס אנצוזאגן צו זיינע תלמידים. ");
INSERT INTO ydd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","און זע, יהושע/ישוע איז זיי אנטקעגנגעקומען, און געזאגט: שלום! און זיי זענען צוגעגאנגען און האבן אים אנגענומען ביי די פיס, און זיך געבוקט צו אים. ");
INSERT INTO ydd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","דאן זאגט יהושע/ישוע צו זיי: האט נישט קיין מורא! גייט און זאגט מיינע ברידער, אז זיי זאלן גיין קיין גליל, און דארטן וועלן זיי מיך זען. ");
INSERT INTO ydd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","און בשעת זיי זענען געגאנגען, זע, אייניקע פון דער וואך זענען געקומען אין דער שטאט אריין, און דערציילט די הויפט כהנים אלץ, וואס איז געשען. ");
INSERT INTO ydd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","און זיי האבן זיך פארזאמלט מיט די זקנים, און נאך דעם ווי זיי האבן זיך געהאלטן אן עצה, האבן זיי געגעבן די זעלנער געלט גענוג, ");
INSERT INTO ydd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","און געזאגט: איר זאלט זאגן: זיינע תלמידים זענען געקומען ביינאכט, און האבן אים אוועקגעגנבעט, ווען מיר זענען געשלאפן. ");
INSERT INTO ydd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","און אויב דאס דאזיקע וועט קומען צום גובערנאטארס אויערן, וועלן מיר אים איבעררעדן און מאכן, אז איר זאלט נישט האבן קיין זארגן. ");
INSERT INTO ydd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","און זיי האבן גענומען דאס געלט, און געטאן ווי זיי זענען געלערנט געווארן. און די דאזיקע רייד האבן זיך פארשפרייט ביי יידן ביז צום היינטיקן טאג. ");
INSERT INTO ydd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","די עלף תלמידים אבער זענען געגאנגען קיין גליל צו דעם בארג, וואואהין יהושע/ישוע האט זיי באשטימט. ");
INSERT INTO ydd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","און ווען זיי האבן אים געזען, האבן זיי זיך געבוקט; א טייל אבער האבן געצווייפלט. ");
INSERT INTO ydd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","און יהושע/ישוע איז צוגעגאנגען און האט מיט זיי גערעדט, אזוי צו זאגן: עס איז מיר געגעבן געווארן יעדע מאכט אין הימל און אויף דער ערד. ");
INSERT INTO ydd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","גייט דעריבער און מאכט אלע פעלקער פאר תלמידים, און זיי מיט דער מקווה געגאנגען אונטער די וואסער אין דעם נאמען פון דעם פאטער און דעם זון און דעם רוח הקודש, ");
INSERT INTO ydd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","און לערנט זיי האלטן אלץ, וואס איך האב אייך געבאטן. און זע, איך בין מיט אייך אלע טעג, ביז צום קץ פון דער וועלט. אמן.");
INSERT INTO ydd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","דאס איז דער אנהויב פון דער בשורה טובה פון יהושע/ישוע המשיח, דעם זון פון דער אויבערשטער. ");
INSERT INTO ydd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","לויט ווי עס שטייט געשריבן אין ישעיהו הנביא: זע, איך שיק מיין שליח פאר דיין פנים, ער וועט צוגרייטן דיין וועג; (מלאכי ג, א.) ");
INSERT INTO ydd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","א קול פון איינעם, וואס רופט אויס אין דער מדבר: מאכט פארטיק דעם הארס וועג, גלייכט אויס זיינע שטעגן! (ישעיהו מ, ג.) ");
INSERT INTO ydd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","יוחנן איז געקומען, וואס האט טובל געווען אין דער מדבר, אויסרופנדיק א מקווה פון תשובה צו דער פארגעבונג פון זינד. ");
INSERT INTO ydd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","און עס איז ארויסגעגאנגען צו אים דאס גאנצע לאנד יהודה, און אלע לייט פון ירושלים; און זענען געטובלט געווארן אין א מקווה פון אים אין דעם טייך ירדן, און האבן זיך מתוודה געווען אויף זייערע זינד. ");
INSERT INTO ydd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","און דער יוחנן איז געווען אנגעטאן אין קעמל האר, און א לעדערנער גארטל ארום זיינע לענדן, און האט געגעסן היישעריקן און ווילדן האניק. ");
INSERT INTO ydd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","און ער האט אויסגערופן, אזוי צו זאגן: עס קומט נאך מיר דער, וואס איז שטארקער פון מיר; וואס איך בין נישט ווערט זיך איינצובייגן און אויפצובינדן דאס שנירל פון זיינע שיך. ");
INSERT INTO ydd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","איך האב אייך טובל געווען מיט וואסער אין א מקווה, ער אבער וועט אייך טובל זיין אין א מקווה מיט דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","און עס איז געשען, אין יענע טעג איז יהושע/ישוע געקומען פון נצרת אין גליל, און איז געטובלט געווארן אין א מקווה פון יוחנן אינם ירדן. ");
INSERT INTO ydd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","און גלייך ווי ער איז ארויסגעשטיגן אויס דעם וואסער, האט ער געזען דעם הימל געשפאלטן, און דעם גייסט ווי א טויב אראפשוועבן אויף אים; ");
INSERT INTO ydd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","און עס איז געקומען א קול אויס דעם הימל: דו ביסט מיין געליבטער זון, אין דיר האב איך א וואוילגעפעלן! ");
INSERT INTO ydd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","און גלייך טרייבט אים דער גייסט אין דער מדבר אריין. ");
INSERT INTO ydd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","און ער איז געווען אין דער מדבר פערציק טעג, ווערנדיק אויסגעפרואווט פונם שׂטן; און איז געווען מיט די ווילדע חיות; און די מלאכים האבן אים באדינט. ");
INSERT INTO ydd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","און נאך דעם ווי יוחנן איז איבערגעגעבן געווארן, איז יהושע/ישוע געקומען קיין גליל, און האט אויסגערופן די בשורה טובה פון ה׳, ");
INSERT INTO ydd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","און געזאגט: די צייט איז שוין דערפילט, און דאס קעניגרייך פון ה׳ האט זיך דערנענטערט; טוט תשובה, און גלויבט אין דער גוטער בשורה! ");
INSERT INTO ydd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","און פארבייגייענדיק ביים ים פון גליל, האט ער געזען שמעונען און אנדריי שמעונס ברודער ווארפן א נעץ אין ים אריין; ווארום זיי זענען געווען פישערלייט. ");
INSERT INTO ydd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","און יהושע/ישוע האט צו זיי געזאגט: קומט, פאלגט מיר נאך, און איך וועל אייך מאכן צו ווערן פישערס פון מענטשן! ");
INSERT INTO ydd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","און גלייך האבן זיי פארלאזט די נעצן און האבן אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","און גייענדיק אביסל ווייטער, האט ער געזען יעקב בן זבדי און יוחנן זיין ברודער, אויך זיי זענען געווען אינם שיפל פארריכטנדיק די נעצן. ");
INSERT INTO ydd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","און גלייך האט ער זיי גערופן; און זיי האבן פארלאזט זייער פאטער זבדי און דעם שיפל צוזאמען מיט די טאג לוינער, און זענען אוועק נאך אים. ");
INSERT INTO ydd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","און זיי זענען געגאנגען קיין כפר‑נחום; און גלייך שבת איז ער אריינגעגאנגען אין דער שול און האט געלערנט. ");
INSERT INTO ydd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","און מען האט געשטוינט איבער זיין תורה; ווארום ער האט זיי געלערנט ווי איינער, וואס האט מאכט, און נישט ווי די סופרים. ");
INSERT INTO ydd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","און גראד איז אין זייער שול געווען א מענטש מיט אן אומריינעם גייסט; און ער האט א געשריי געטאן, ");
INSERT INTO ydd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","אזוי צו זאגן: וואס האבן מיר מיט דיר, יהושע/ישוע פון נצרת? דו ביסט געקומען אונדז צו פארטיליקן! איך ווייס ווער דו ביסט: דער קדוש אלקים. ");
INSERT INTO ydd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","און יהושע/ישוע האט אויף אים אנגעשריגן, אזוי צו זאגן: שווייג, און גיי ארויס פון אים! ");
INSERT INTO ydd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","און דער אומריינער גייסט האט אים א ריס געטאן, האט געשריגן מיט א הויך קול און איז פון אים ארויס. ");
INSERT INTO ydd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","און אלע זענען אזוי דערשטוינט געווארן, אז זיי האבן דאס איבערגעפרעגט צווישן זיך, אזוי צו זאגן: וואס איז דאס דאזיקע? א נייע לערנונג מיט מאכט! אפילו די אומריינע גייסטער באפעלט ער, און זיי געהארכן אים. ");
INSERT INTO ydd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","און גלייך האט זיך זיין שם פארשפרייט אומעטום אין דער גאנצער געגנט ארום גליל. ");
INSERT INTO ydd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","און גלייך ווי זיי זענען ארויסגעקומען פון דער שול, זענען זיי אריינגעגאנגען אינם הויז פון שמעון און אנדריי, צוזאמען מיט יעקבן און יוחנן. ");
INSERT INTO ydd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","שמעונס שוויגער אבער איז געלעגן קראנק מיט א פיבער; און זיי האבן אים תיכף געזאגט וועגן איר. ");
INSERT INTO ydd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","און ער איז צוגעגאנגען און האט זי אנגענומען ביי דער האנט, און זי אויפגעשטעלט; און דאס פיבער איז פון איר אוועק, און זי האט זיי באדינט. ");
INSERT INTO ydd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","און ווען עס איז געווארן אוונט, ווען די זון איז אונטערגעגאנגען, האט מען געברענגט צו טראגן צו אים אלע קראנקע, און באזעסענע מיט בייזע גייסטער. ");
INSERT INTO ydd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","און די גאנצע שטאט איז זיך צוזאמענגעקומען ביי דער טיר. ");
INSERT INTO ydd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","און ער האט געהיילט א סך, וואס האבן געהאט פארשיידענע קראנקייטן, און פיל בייזע גייסטער האט ער ארויסגעטריבן; און האט די בייזע גייסטער נישט געלאזט רעדן, ווייל זיי האבן אים געקענט. ");
INSERT INTO ydd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","און אינדערפרי, בשעת עס איז נאך געווען זייער טונקל, איז ער אויפגעשטאנען, איז ארויסגעגאנגען און איז אוועק אויף א וויסט ארט, און האט דארט תפילה געטאן. ");
INSERT INTO ydd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","און שמעון און די, וואס זענען געווען ביי אים, האבן נאכגעאיילט נאך אים; ");
INSERT INTO ydd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","און האבן אים געפונען, און זאגן צו אים: אלע זוכן דיך! ");
INSERT INTO ydd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","און ער זאגט צו זיי: לאמיר גיין ערגעץ אנדערשוואו אין די שכנותדיקע שטעטלעך אריין, כדי איך זאל אויך דארטן דרשענען; ווארום דערצו בין איך געקומען. ");
INSERT INTO ydd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","און ער איז געגאנגען און האט אויסגערופן אין זייערע שולן אין גאנץ גליל און האט ארויסגעטריבן די בייזע גייסטער. ");
INSERT INTO ydd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","און א מצורע איז געקומען צו אים, האט אים געבעטן, און איז אנידערגעפאלן פאר אים אויף די קני און געזאגט צו אים: אויב דו ווילסט, קענסטו מיך ריין מאכן! ");
INSERT INTO ydd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","און ער האט זיך דערבארעמט, האט אויסגעשטרעקט די האנט, האט אים אנגערירט און זאגט צו אים: איך וויל; זיי ריין! ");
INSERT INTO ydd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","און גלייך איז די צרעת פון אים אוועק, און ער איז געווארן ריין. ");
INSERT INTO ydd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","און ער האט שארף צו אים גערעדט, האט אים תיכף אוועקגעשיקט, ");
INSERT INTO ydd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","און זאגט צו אים: גיב אכטונג, זאלסט קיינעם גארנישט זאגן; נאר גיי ווייז דיך דעם כהן, און ברענג א קרבן פאר דיין רייניקונג, וואס משה האט געבאטן, פאר אן עדות צו זיי (ויקרא יד, א-לב.) ");
INSERT INTO ydd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ער אבער איז ארויסגעגאנגען, און האט אנגעהויבן א סך דערפון צו דערציילן, און צו פארשפרייטן די זאך, אז ער האט שוין מער נישט געקענט אפן אריינגיין אין א שטאט, נאר איז געווען אינדרויסן אין מדבריותדיקע ערטער; און מען איז געקומען צו אים פון אומעטום. ");
INSERT INTO ydd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","און אין אייניקע טעג ארום איז ער ווידער געגאנגען קיין כפר‑נחום; און מען האט געהערט, אז ער איז אינם הויז. ");
INSERT INTO ydd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","און א סך לייט האבן זיך פארזאמלט, אזוי אז עס איז שוין מער נישט געווען קיין ארט, אפילו נישט ביי דער טיר; און ער האט צו זיי גערעדט דאס ווארט. ");
INSERT INTO ydd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","און אייניקע זענען געקומען, ברענגענדיק צו אים א פאראליזשירטן, וואס איז געטראגן געווארן פון פיר. ");
INSERT INTO ydd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","און נישט קענענדיק אים צוברענגען צו אים צוליב דעם המון מענטשן, האבן זיי אראפגעריסן דעם דאך וואו ער איז געווען, און נאך דעם ווי זיי האבן דורכגעבראכן, האבן זיי אראפגעלאזט דאס בעט, אויף וועלכן דער פאראליזשירטער איז געלעגן. ");
INSERT INTO ydd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","און ווי יהושע/ישוע האט געזען זייער גלויבן, זאגט ער צום פאראליטיקער: קינד, דיינע זינד זענען דיר פארגעבן געווארן! ");
INSERT INTO ydd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","עס זענען אבער דארט געזעסן אייניקע פון די סופרים, וואס האבן נאכגעטראכט אין זייערע הערצער, ");
INSERT INTO ydd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","פארוואס רעדט ער אזוי? ער לעסטערט דאך! ווער קען מוחל זיין זינד אחוץ נאר ה׳ אליין? ");
INSERT INTO ydd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","און גלייך דערוויסנדיק זיך אין זיין גייסט, אז זיי האבן אזוי געטראכט, זאגט ער צו זיי: פארוואס טראכט איר די דאזיקע זאכן אין אייערע הערצער? ");
INSERT INTO ydd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","וואס איז לייכטער: צו זאגן צום פאראליזשירטן: דיינע זינד זענען דיר פארגעבן געווארן; אדער צו זאגן: שטיי אויף, נעם דיין בעט און גיי? ");
INSERT INTO ydd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","כדי אבער איר זאלט וויסן, אז דער בר אנש האט רשות מוחל צו זיין זינד אויף דער ערד—זאגט ער צום פאראליזשירטן: ");
INSERT INTO ydd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","דיר זאג איך: שטיי אויף, נעם דיין בעט און גיי אהיים! ");
INSERT INTO ydd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","און ער איז אויפגעשטאנען, און האט באלד גענומען דאס בעט און איז ארויסגעגאנגען פאר אלעמען, אזוי אז אלע זענען געווען אויסער זיך פון דערשטוינונג, און האבן געלויבט ה׳, אזוי צו זאגן: נאך קיינמאל האבן מיר אזעלכעס נישט געזען! ");
INSERT INTO ydd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","און ער איז ווידער ארויסגעגאנגען צום ברעג ים, און דער גאנצער המון מענטשן איז געקומען צו אים, און ער האט זיי געלערנט. ");
INSERT INTO ydd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","און פארבייגייענדיק האט ער געזען לוי בן חלפי זיצן אינם שטייער אמט, און ער זאגט צו אים; פאלג מיר נאך! און ער איז אויפגעשטאנען און האט אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","און עס איז געשען, בשעת ער (יהושע/ישוע) איז געזעסן אין זיין (לויס) הויז צום טיש, און א סך שטייער אויפמאנער און חוטאים האבן זיך אנידערגעזעצט מיט יהושען/ישוען און מיט זיינע תלמידים; ווארום עס זענען געווען א סך, און זיי האבן אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","און די סופרים פון די פרושים האבן געזען, אז ער עסט צוזאמען מיט חוטאים און מיט שטייער אויפמאנער, האבן זיי געזאגט צו די תלמידים זיינע: פארוואס עסט ער צוזאמען מיט די שטייער אויפמאנער און חוטאים? ");
INSERT INTO ydd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","און ווען יהושע/ישוע האט דאס געהערט, זאגט ער צו זיי: די געזונטע האבן נישט נייטיק קיין רופא, נאר די, וואס זענען קראנק: איך בין נישט געקומען רופן צדיקים, נאר חוטאים. ");
INSERT INTO ydd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","און יוחננס תלמידים און די פרושים פלעגן פאסטן; און זיי קומען און זאגן צו אים: פארוואס פאסטן יוחננס תלמידים און די תלמידים פון די פרושים, און דיינע תלמידים פאסטן נישט? ");
INSERT INTO ydd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","און יהושע/ישוע האט צו זיי געזאגט: צי קענען דען די געסט אויף דער חתונה פאסטן בשעת דער חתן איז מיט זיי? כל זמן זיי האבן דעם חתן מיט זיך, קענען זיי נישט פאסטן. ");
INSERT INTO ydd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","עס וועלן אבער קומען טעג, ווען דער חתן וועט פון זיי אוועקגענומען ווערן, און דעמאלט וועלן זיי פאסטן אין יענעם טאג. ");
INSERT INTO ydd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","קיינער לייגט נישט קיין לאטע פון נישט איינגעלאפענעם טוך אויף אן אלטן בגד; טאמער רייסט די נייע לאטע אפ פונם אלטן, און דער ריס ווערט ערגער. ");
INSERT INTO ydd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","און קיינער גיסט נישט אריין קיין נייעם וויין אין אלטע לאגלען; טאמער צעשפאלט דער וויין די לאגלען, און סאי דער וויין און סאי די לאגלען ווערן פארלוירן; נאר נייער וויין געהערט אין נייע לאגלען אריין. ");
INSERT INTO ydd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","און עס איז געשען, אז א שבת איז ער געגאנגען דורך די קארנפעלדער, און זיינע תלמידים האבן אנגעהויבן אויפן וועג אפצורייסן די זאנגען. ");
INSERT INTO ydd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","און די פרושים האבן געזאגט צו אים: זע, פארוואס טוען זיי אום שבת וואס מען טאר נישט? ");
INSERT INTO ydd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","און ער זאגט צו זיי: צי האט איר קיינמאל נישט געלייענט, וואס דוד האט געטאן, ווען ער איז געווען אין נויט, און איז געווען הונגעריק, ער אליין און די לייט מיט אים? ");
INSERT INTO ydd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ווי ער איז אריינגעגאנגען אין ה׳ס הויז (משכן), ווען אביתר איז געווען כהן גדול, און האט געגעסן דאס לחם הפנים, וואס קיינער טאר נישט עסן אחוץ די כהנים, און האט עס אויך געגעבן צו די, וואס זענען געווען מיט אים? (שמואל א כא, א-ו.) ");
INSERT INTO ydd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","און ער האט צו זיי געזאגט: דער שבת איז באשאפן געווארן צוליב דעם מענטשן, און נישט דער מענטש צוליב דעם שבת. ");
INSERT INTO ydd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","דערפאר איז דער בר אנש אויך האר איבער דעם שבת. ");
INSERT INTO ydd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","און ער איז ווידער אריינגעגאנגען אין שול; און עס איז דארטן געווען א מענטש, וואס האט געהאט א פארדארטע האנט. ");
INSERT INTO ydd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","און זיי האבן געלויערט אויף אים, צי ער וועט אים שבת היילן, כדי זיי זאלן אים אנקלאגן. ");
INSERT INTO ydd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","און ער זאגט צו דעם מענטשן, וואס האט געהאט די פארדארטע האנט: שטיי אויף און שטעל דיך אין דער מיטן! ");
INSERT INTO ydd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","און זאגט צו זיי; צי מעג מען שבת טאן גוטס, אדער טאן שלעכטס? ראטעווען א נפש, אדער טייטן? זיי אבער האבן געשוויגן. ");
INSERT INTO ydd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","און ער האט זיך ארומגעקוקט אויף זיי מיט צארן, זייער באטריבט איבער דער שטיינהארטקייט פון זייערע הארץ, און זאגט צו דעם מענטשן: שטרעק אויס די האנט! און ער האט זי אויסגעשטרעקט; און זיין האנט איז ווידער געזונט געווארן. ");
INSERT INTO ydd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","און די פרושים זענען ארויסגעגאנגען, און האבן זיך גלייך באראטן מיט הורדוסנס לייט קעגן אים, וויאזוי זיי זאלן אים אומברענגען. ");
INSERT INTO ydd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","און יהושע/ישוע איז אוועקגעגאנגען מיט זיינע תלמידים צום ים, און א גרויסער עולם מענטשן פון גליל האט נאכגעפאלגט; און פון יהודה, ");
INSERT INTO ydd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","און פון ירושלים, און פון אדום, און פון עבר הירדן, און פון ארום צור און צידון, א גרויסע מאסע מענטשן, הערנדיק די מעשים, וואס ער האט געטאן, זענען זיי געקומען צו אים, ");
INSERT INTO ydd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","און ער האט געזאגט צו זיינע תלמידים, אז א קליין שיפל זאל זיין גרייט פאר אים מחמת דעם המון, כדי מען זאל זיך נישט דרענגען אויף אים; ");
INSERT INTO ydd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ווארום ער האט א סך געהיילט, אזוי אז אלע, וואס האבן געהאט א פלאג, זענען געפאלן אויף אים, כדי אים אנצורירן. ");
INSERT INTO ydd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","און די אומריינע גייסטער, ווען זיי האבן אים געזען, זענען אנידערגעפאלן פאר אים, און האבן געשריגן, אזוי צו זאגן: דו ביסט דער זון פון דער אויבערשטער! ");
INSERT INTO ydd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","און ער האט זיי שטרענג באפוילן, אז זיי זאלן אים נישט מגלה זיין. ");
INSERT INTO ydd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","און ער איז ארויפגעשטיגן אויף דעם בארג, און האט גערופן צו זיך די, וועלכע ער האט געוואלט; און זיי זענען געקומען צו אים. ");
INSERT INTO ydd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","און ער האט באשטימט צוועלף, אז זיי זאלן זיין מיט אים, און כדי ער זאל זיי אוועקשיקן צו דרשענען, ");
INSERT INTO ydd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","און צו האבן רשות ארויסצוטרייבן בייזע גייסטער. ");
INSERT INTO ydd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","און האט באשטימט אָט די צוועלף: שמעונען האט ער צוגעזעצט דעם נאמען פעטרוס; ");
INSERT INTO ydd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","און יעקב בן זבדי, און יוחנן, יעקבס ברודער, און זיי האט ער צוגעזעצט דעם נאמען בני רגוש, דאס הייסט זין פון דונער; ");
INSERT INTO ydd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","און אנדריי, און פיליפוס, און בר‑תלמי, און מתתיהו, און תומא, און יעקב בן חלפי, און תדי, און שמעון הקנאי, ");
INSERT INTO ydd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","און יהודה איש‑קריות, וועלכער האט אים אויך פארראטן. ");
INSERT INTO ydd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","און ער איז אריינגעגאנגען אין א הויז. און עס איז זיך ווידער צוזאמענגעקומען א המון מענטשן, אזוי אז זיי האבן אפילו נישט געקענט עסן ברויט. ");
INSERT INTO ydd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","און ווי זיינע קרובים האבן דאס געהערט, זענען זיי ארויסגעגאנגען אים כאפן, ווארום זיי האבן געזאגט: ער איז אראפ פון זינען. ");
INSERT INTO ydd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","און די סופרים, וואס זענען אראפגעקומען פון ירושלים, האבן געזאגט: ער האט דעם בעל‑זבול; און דורך דעם שר פון די בייזע גייסטער טרייבט ער ארויס די בייזע גייסטער. ");
INSERT INTO ydd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","און ער האט זיי גערופן צו זיך, און גערעדט צו זיי מיט משלים; וויאזוי קען דער שׂטן ארויסטרייבן דעם שׂטן? ");
INSERT INTO ydd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","און אויב א מלוכה איז צעטיילט קעגן זיך אליין, קען יענע מלוכה נישט האבן קיין קיום. ");
INSERT INTO ydd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","און אויב א הויז איז צעטיילט קעגן זיך אליין, וועט יענץ הויז נישט קענען בלייבן שטיין. ");
INSERT INTO ydd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","און אויב דער שׂטן שטייט אויף קעגן זיך אליין, און איז צעטיילט, קען ער נישט האבן קיין קיום, נאר האט דעם סוף. ");
INSERT INTO ydd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","קיינער קען נישט אריינגיין אין דעם הויז פון דעם גיבור און ביי אים צורויבן די זאכן, אויב ער וועט נישט קודם כל בינדן דעם גיבור; און דעמאלט וועט ער אויסרויבן זיין הויז. ");
INSERT INTO ydd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","באמת זאג איך אייך: אלע זינד וועלן פארגעבן ווערן צו די מענטשנקינדער, און די לעסטערונגען, וויפל זיי וועלן לעסטערן; ");
INSERT INTO ydd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ווער אבער עס וועט לעסטערן דעם רוח הקודש, דער האט נישט קיין פארגעבונג אויף אייביק, נאר איז חייב אן אייביקע זינד. ");
INSERT INTO ydd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ווייל זיי האבן געזאגט, אז ער האט אן אומריינעם גייסט. ");
INSERT INTO ydd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","און זיין מוטער און זיינע ברידער זענען געקומען, און שטייענדיק אינדרויסן האבן זיי געשיקט צו אים, אים צו רופן. ");
INSERT INTO ydd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","און עס איז געזעסן ארום אים א המון מענטשן; און מען האט צו אים געזאגט: זע, דיין מוטער און דיינע ברידער און דיינע שוועסטער זענען אינדרויסן און זוכן דיך. ");
INSERT INTO ydd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","און ער האט ענטפערנדיק צו זיי געזאגט: ווער איז מיין מוטער און מיינע ברידער? ");
INSERT INTO ydd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","און האט זיך ארומגעקוקט אויף די, וואס זענען געזעסן ארום אים אין א קרייז, און האט געזאגט: זע, מיין מוטער און מיינע ברידער! ");
INSERT INTO ydd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ווארום ווער עס וועט טאן ה׳ס רצון, דער דאזיקער איז מיין ברודער, און שוועסטער, און מוטער. ");
INSERT INTO ydd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","און ווידער האט ער אנגעהויבן צו לערנען ביים ים; און עס האט זיך פארזאמלט ביי אים א זייער גרויסער המון מענטשן, אזוי אז ער איז איינגעשטיגן אין א שיפל, און האט זיך אנידערגעזעצט אויפן ים; און דער גאנצער המון מענטשן איז געווען ביים ים אויף דער יבשה. ");
INSERT INTO ydd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","און ער האט זיי געלערנט א סך זאכן מיט משלים, און האט צו זיי געזאגט אין זיין תורה: ");
INSERT INTO ydd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","הערט זיך צו: זע, דער זייער איז ארויסגעגאנגען צו פארזייען. ");
INSERT INTO ydd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","און עס איז געשען, בשעת דעם זייען זענען אייניקע (זאמען) געפאלן ביים וועג, און די פייגל זענען געקומען און האבן זיי אויפגעגעסן. ");
INSERT INTO ydd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","און אנדערע זענען געפאלן אויף דעם שטייניקן באדן, וואו זיי האבן נישט געהאט קיין סך ערד; און האבן גלייך אויפגעשפראצט צוליבן נישט האבן קיין טיפקייט פון ערד; ");
INSERT INTO ydd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","און ווען די זון איז אויפגעגאנגען, זענען זיי פארוועלקט געווארן, און ווייל זיי האבן נישט געהאט קיין ווארצל, זענען זיי פארדארט געווארן. ");
INSERT INTO ydd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","און אנדערע זענען געפאלן צווישן די דערנער, און די דערנער זענען אויפגעוואקסן און האבן זיי דערשטיקט, און זיי האבן נישט געגעבן קיין פרוכט. ");
INSERT INTO ydd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","און אנדערע זענען געפאלן אויף דער גוטער ערד, און האבן יא געגעבן פרוכט, וואס האט אויפגעשפראצט און איז געוואקסן; און האבן געברענגט איינס—דרייסיקפאכיק, און איינס זעכציקפאכיק, און איינס—הונדערטפאכיק. ");
INSERT INTO ydd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","און ער האט געזאגט: ווער עס האט אויערן צום הערן, דער זאל הערן! ");
INSERT INTO ydd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","און ווען ער איז געווען אליין, האבן די, וואס זענען געווען מיט אים, צוזאמען מיט די צוועלף אים געפרעגט וועגן די משלים. ");
INSERT INTO ydd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","און ער האט צו זיי געזאגט: אייך איז געגעבן געווארן דער סוד פון דעם קעניגרייך פון ה׳; צו יענע אבער אינדרויסן ווערט אלץ געטאן אין משלים; ");
INSERT INTO ydd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","כדי קוקנדיק זאלן זיי קוקן און נישט זען, און הערנדיק זאלן זיי הערן און נישט באנעמען; טאמער וועלן זיי תשובה טאן און עס וועט זיי פארגעבן ווערן. ");
INSERT INTO ydd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","און זאגט צו זיי: איר פארשטייט נישט דאס דאזיקע משל, און וויאזוי וועט איר פארשטיין אלע משלים? ");
INSERT INTO ydd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","דער זייער פארזייט דאס ווארט. ");
INSERT INTO ydd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","און דאס זענען די ביים וועג, וואו דאס ווארט איז געזייעט געווארן; און ווען זיי האבן עס געהערט, קומט גלייך דער שׂטן, און נעמט אוועק דאס ווארט, וואס איז געזייעט געווארן אין זיי. ");
INSERT INTO ydd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","און אויך אזוי די, וואס זענען געזייעט אויף דעם שטייניקן באדן, וואס, ווען זיי האבן געהערט דאס ווארט, נעמען עס גלייך אָן מיט שמחה; ");
INSERT INTO ydd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","און האבן נישט קיין ווארצל אין זיך, נאר זענען בלויז אויף א געוויסע צייט; קומט אבער א צרה אדער רדיפה צוליב דעם ווארט, שטרויכלען זיי באלד. ");
INSERT INTO ydd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","און אנדערע זענען די, וואס זענען געזייעט צווישן דערנער; זיי זענען עס וואס האבן געהערט דאס ווארט; ");
INSERT INTO ydd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","און די זארגן פון דער וועלט און די פארפירערישקייט פון רייכטום, און די תאוות נאך אנדערע זאכן דרינגען אריין און דערשטיקן דאס ווארט, און עס בלייבט אָן פירות. ");
INSERT INTO ydd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","און יענע זענען עס וואס זענען געזייעט געווארן אויף דער גוטער ערד; וואס הערן דאס ווארט, און נעמען עס אָן, און ברענגען פרוכט, איינער דרייסיקפאכיק, און איינער זעכציקפאכיק, און איינער הונדערטפאכיק. ");
INSERT INTO ydd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","און ער האט צו זיי געזאגט: צי קומט דען דאס ליכט, כדי געשטעלט צו ווערן אונטער א מאסשעפל, אדער אונטערן בעט? ניין, נאר כדי עס זאל געשטעלט ווערן אויף דעם לייכטער. ");
INSERT INTO ydd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ווארום קיין זאך איז נישט פארבארגן, אחוץ כדי אנטפלעקט צו ווערן; און קיין זאך איז נישט פארהוילן געווארן, וואס וועט נישט מפורסם ווערן. ");
INSERT INTO ydd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","אויב עמיצער האט אויערן צום הערן, זאל ער הערן! ");
INSERT INTO ydd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","און ער האט צו זיי געזאגט: גיט אכטונג, וואס איר הערט! מיט וואס פאר א מאס איר מעסט, וועט אייך געמאסטן ווערן, און עס וועט אייך נאך צוגעגעבן ווערן א צולאג. ");
INSERT INTO ydd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ווארום ווער עס האט, דעם וועט געגעבן ווערן; און ווער עס האט נישט, פון דעם וועט אוועקגענומען ווערן אפילו דאס, וואס ער האט יא. ");
INSERT INTO ydd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","און ער האט געזאגט: אזוי אָ איז דאס קעניגרייך פון ה׳, ווי א מענטש וואלט געווארפן דעם זאמען אויף דער ערד, ");
INSERT INTO ydd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","און לייגט זיך שלאפן און שטייט אויף, ביינאכט און בייטאג, און דער זאמען שפראצט ארויס און וואקסט אויף, אָן זיין וויסן וויאזוי. ");
INSERT INTO ydd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","פון זיך אליין ברענגט די ערד ארויס פירות; צום ערשט דאס גראז, דערנאך די זאנג, נאך דעם פולן ווייץ אין דער זאנג. ");
INSERT INTO ydd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ווען אבער די פרוכט דערלאזט עס, שיקט ער גלייך דעם סערפ אהין, ווייל די שניט צייט איז שוין אנגעקומען. ");
INSERT INTO ydd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","און ער האט געזאגט: וויאזוי זאלן מיר פארגלייכן דאס קעניגרייך פון ה׳, אדער אין וואס פאר א משל זאלן מיר עס לייגן? ");
INSERT INTO ydd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","עס איז ווי א זענעפט קערנדל, וואס, ווען עס איז פארזייט אין דער ערד, הגם עס איז דאס קלענסטע פון אלע זריעות, ");
INSERT INTO ydd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","דאך ווען עס איז פארזייט, וואקסט עס אויף און ווערט גרעסער ווי אלע גארטן געוויקסן, און גיט ארויס גרויסע צווייגן, אז אונטער זיין שאטן קענען די פייגל פון הימל וואוינען. ");
INSERT INTO ydd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","און מיט א סך אזעלכע משלים האט ער צו זיי גערעדט דאס ווארט, לויט ווי זיי זיי זענען געווען בכוח צו הערן; ");
INSERT INTO ydd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","און אָן א משל האט ער צו זיי נישט גערעדט; און איז ער געווען מיט זיינע תלמידים אליין, האט ער זיי אלץ אויסגעלייגט. ");
INSERT INTO ydd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","און יענעם טאג, ווען עס איז געווארן אוונט, האט ער צו זיי געזאגט: לאמיר אריבערפארן אויף דער אנדערער זייט ים. ");
INSERT INTO ydd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","און זיי האבן געלאזט דעם המון מענטשן גיין, און האבן אים מיטגענומען, אזוי ווי ער איז געווען, אינם שיפל; און נאך אנדערע שיפלעך זענען געווען מיט אים. ");
INSERT INTO ydd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","און עס הויבט זיך אויף א גרויסער שטורמווינט, און די כוואליעס האבן זיך געווארפן אויפן שיפל, אזוי אז דאס שיפל האט זיך שוין געהאט כמעט אנגעפילט. ");
INSERT INTO ydd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","און ער אליין איז געווען אין דעם הינטערן טייל, שלאפנדיק אויף דעם קישן; און זיי וועקן אים אויף און זאגן צו אים: רבי, עס ארט דיך גארנישט, אז מיר קומען אום? ");
INSERT INTO ydd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","און ער איז אויפגעשטאנען, האט אנגעשריגן דעם ווינט און געזאגט צום ים: שווייג, זיי שטיל! און דער ווינט האט אויפגעהערט, און עס איז געווארן א גרויסע שטילקייט. ");
INSERT INTO ydd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","און ער האט צו זיי געזאגט: וואס זענט איר אזוי שרעקעוודיק? ווי, איר האט נאך אלץ נישט קיין גלויבן? ");
INSERT INTO ydd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","און זיי האבן זיך געפארכטן מיט א גרויסער פורכט, און האבן געזאגט איינס צום אנדערן: ווער איז ער דאך, אז סאי דער ווינט סאי דער ים געהארכן אים? ");
INSERT INTO ydd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","און זיי זענען געקומען אויף דער אנדערער זייט ים, אין דעם לאנד פון די געראסענער, ");
INSERT INTO ydd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","און ווען ער איז ארויסגעשטיגן אויס דעם שיפל, איז אים גלייך אנטקעגנגעקומען פון די קברים ארויס א מענטש מיט אן אומריינעם גייסט, ");
INSERT INTO ydd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","וואס האט געהאט זיין וואוינונג אין די קברים, און קיינער האט אים שוין מער נישט געקענט בינדן, אפילו נישט מיט קיין קייט; ");
INSERT INTO ydd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ווייל א סך מאל האט מען אים געבונדן מיט פענטעס און מיט קייטן, און ער האט די קייטן צעריסן און די פענטעס צעריבן, און קיינער האט אים נישט געקענט בייקומען. ");
INSERT INTO ydd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","און תמיד, טאג און נאכט, איז ער געווען צווישן די קברים און אויף די בערג, שרייענדיק און שלאגנדיק זיך מיט שטיינער. ");
INSERT INTO ydd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","און ווי ער האט דערזען יהושען/ישוען פונדערווייטנס, איז ער געלאפן און האט זיך געבוקט פאר אים; ");
INSERT INTO ydd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","און האט א געשריי געטאן מיט א הויך קול, און געזאגט: וואס האב איך מיט דיר, יהושע/ישוע, דו זון פון דער אויבערשטער? איך באשווער דיך ביי ה׳, דו זאלסט מיך נישט פייניקן! ");
INSERT INTO ydd_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ווארום ער האט צו אים געזאגט: דו אומריינער גייסט, גיי ארויס פון דעם מענטשן! ");
INSERT INTO ydd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","און ער האט אים געפרעגט: וואס פאר א נאמען האסטו? און ער האט צו אים געזאגט: מיין נאמען איז לעגיאן, ווייל מיר זענען א סך. ");
INSERT INTO ydd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","און ער האט אים פיל געבעטן, אז ער זאל זיי נישט ארויסשיקן פון דעם לאנד. ");
INSERT INTO ydd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","און דארט ביים בארג האט זיך געפאשעט א גרויסע סטאדע חזירים. ");
INSERT INTO ydd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","און זיי האבן אים געבעטן, אזוי צו זאגן: שיק אונדז צו די חזירים, כדי מיר זאלן אריינגיין אין זיי! ");
INSERT INTO ydd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","און ער האט זיי געגעבן רשות. און די אומריינע גייסטער זענען ארויסגעגאנגען, און זענען אריין אין די חזירים; און די סטאדע האט זיך א ריס געטאן פון דעם אראפהענגענדיקן פעלדזן אין ים אריין, אן ערך צוויי טויזנט, און זענען דערשטיקט געווארן אין ים. ");
INSERT INTO ydd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","און די וואס האבן זיי געפאשעט זענען אנטלאפן, און האבן עס דערציילט אין דער שטאט, און אויפן לאנד. און מען איז געקומען זען וואס עס איז פארגעקומען. ");
INSERT INTO ydd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","און זיי קומען צו יהושען/ישוען, און זען דעם באזעסענעם, וואס האט געהאט דעם לעגיאן, זיצן אנגעטאן און ביים קלארן פארשטאנד; און זיי האבן זיך געפארכטן. ");
INSERT INTO ydd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","און די, וואס האבן עס געזען, האבן זיי דערציילט וויאזוי עס איז געשען מיט דעם באזעסענעם, און וועגן די חזירים. ");
INSERT INTO ydd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","און זיי האבן אנגעהויבן אים צו בעטן, אז ער זאל אוועקגיין פון זייערע גרענעצן. ");
INSERT INTO ydd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","און ווען ער איז איינגעשטיגן אין דעם שיפל, האט אים דער, וואס איז געווען באזעסן געבעטן, אז ער זאל מיט אים בלייבן. ");
INSERT INTO ydd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","און ער האט אים נישט געלאזט, נאר זאגט צו אים: גיי אהיים צו די דייניקע, און דערצייל זיי וואס פאר א גרויסע זאכן דער האר האט דיר געטאן, און ווי ער האט זיך אויף דיר מרחם געווען! ");
INSERT INTO ydd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","און ער איז אוועקגעגאנגען, און האט אנגעהויבן אויסצורופן אין דעקאפאליס אלץ, וואס יהושע/ישוע האט פאר אים געטאן; און אלע האבן זיך געוואונדערט. ");
INSERT INTO ydd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","און ווען יהושע/ישוע האט זיך ווידער אריבערגעשיפט אינם שיפל אויף יענער זייט, האט זיך ביי אים פארזאמלט א גרויסער המון מענטשן; און ער איז געווען ביים ים. ");
INSERT INTO ydd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","און עס קומט איינער פון די גבאים פון דער שול, יאיר האט ער געהייסן, און זעענדיק אים, פאלט ער אנידער פאר זיינע פיס, ");
INSERT INTO ydd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","און בעט אים זייער פיל, אזוי צו זאגן: מיין טעכטערל האלט ביי יציאת נשמה; קום לייג ארויף דיינע הענט אויף איר, כדי זי זאל געראטעוועט ווערן, און לעבן! ");
INSERT INTO ydd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","און ער איז געגאנגען מיט אים, און א גרויסער המון מענטשן האט אים נאכגעפאלגט, און אים געשטופט. ");
INSERT INTO ydd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","און א פרוי, וואס האט געליטן פון א בלוט פלוס צוועלף יאר לאנג, ");
INSERT INTO ydd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","און האט זייער פיל געליטן פון א סך דאקטוירים, און אויסגעגעבן אלץ וואס זי האט געהאט, און עס האט איר גארנישט געהאלפן, נאר עס איז איר נאך ערגער געווארן, ");
INSERT INTO ydd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","האבנדיק געהערט וועגן יהושען/ישוען, איז זי געקומען צווישן דעם המון מענטשן פון הינטן, און האט אנגערירט זיין מלבוש. ");
INSERT INTO ydd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ווארום זי האט זיך געטראכט: אויב איך וועל אנרירן בלויז זיינע מלבושים, וועל איך געהאלפן ווערן! ");
INSERT INTO ydd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","און גלייך האט זיך פארטריקנט דער קוואל פון איר בלוט; און זי האט געפילט אין איר קערפער, אז זי איז געהיילט געווארן פון דער פלאג. ");
INSERT INTO ydd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","און יהושע/ישוע, גלייך ווי ער האט דערפילט אין זיך אז די קראפט איז פון אים ארויסגעגאנגען, האט זיך אויסגעדרייט צווישן דעם המון מענטשן, און געזאגט: ווער האט אנגערירט מיינע מלבושים? ");
INSERT INTO ydd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","און זיינע תלמידים האבן צו אים געזאגט: דו זעסט דער המון דרענגען דיך, און זאגסטו: ווער האט מיך אנגערירט? ");
INSERT INTO ydd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","און ער האט זיך ארומגעקוקט צו זען זי, וואס האט דאס דאזיקע געטאן. ");
INSERT INTO ydd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","די פרוי אבער, פארכטנדיק זיך און ציטערנדיק, ווייל זי האט געוואוסט וואס עס איז מיט איר געשען, איז געקומען און איז אנידערגעפאלן פאר אים, און האט אים געזאגט דעם גאנצן אמת. ");
INSERT INTO ydd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","און ער האט צו איר געזאגט: טאכטער, דיין גלויבן האט דיר געהאלפן; גיי לשלום, און זיי געזונט פון דיין פלאג! ");
INSERT INTO ydd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","בשעת ער האט נאך גערעדט, קומט מען פון דעם גבאיס הויז, אזוי צו זאגן: דיין טאכטער איז געשטארבן; וואס באמיסטו נאך דעם רבין? ");
INSERT INTO ydd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","יהושע/ישוע אבער האט נישט געלייגט קיין אכט אויף דעם ווארט וואס איז גערעדט געווארן, נאר האט געזאגט צום גבאי: פארכט דיך נישט, גלויב נאר! ");
INSERT INTO ydd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","און האט קיינעם נישט געלאזט מיטגיין, אחוץ פעטרוסן, און יעקבן, און יוחנן יעקבס ברודער. ");
INSERT INTO ydd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","און זיי קומען צו דעם גבאיס הויז; און ער זעט א געטומל, און מען וויינט און קלאגט זייער פיל. ");
INSERT INTO ydd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","און אריינגייענדיק זאגט ער צו זיי: וואס טומלט איר און וויינט? דאס קינד איז דאך נישט געשטארבן, עס שלאפט נאר. ");
INSERT INTO ydd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","און זיי האבן זיך אויסגעלאכט פון אים. ער אבער, נאך דעם ווי ער האט אלע ארויסגעטריבן, נעמט ער דעם פאטער פון דעם קינד און די מוטער, און די וואס זענען געווען מיט אים, און גייט אריין וואו דאס קינד איז געווען. ");
INSERT INTO ydd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","און ער האט אנגענומען דאס קינד ביי דער האנט, און האט צו איר געזאגט: טליתא קומי! וואס פארטייטשט איז דאס: מיידעלע (איך זאג דיר) שטיי אויף! ");
INSERT INTO ydd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","און דאס מיידעלע איז גלייך אויפגעשטאנען, און איז ארומגעגאנגען; ווארום זי איז שוין אלט געווען צוועלף יאר. און זיי זענען תיכף דערשטוינט געווארן מיט א גרויסער דערשטוינונג. ");
INSERT INTO ydd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","און ער האט זיי זייער אנגעזאגט, אז קיינער זאל זיך דערפון נישט דערוויסן; און האט געהייסן מען זאל איר געבן צו עסן. ");
INSERT INTO ydd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","און ער איז פון דארטן אוועקגעגאנגען, און איז געקומען אין זיין פאטערשטאט אריין; און זיינע תלמידים האבן אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","און ווען עס איז געקומען שבת, האט ער אנגעהויבן צו לערנען אין דער שול; און א סך, ווען זיי האבן אים געהערט, האבן געשטוינט, און געזאגט: פונוואנען קומט צו אים אזעלכעס? און וואס איז דאס פאר א חכמה, וואס איז אים געגעבן געווארן? און אזעלכע וואונדער געשען דורך זיינע הענט! ");
INSERT INTO ydd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","צי איז ער דען נישט דער סטאליער, מרימס זון, דער ברודער פון יעקב און יוסי און יהודה און שמעון? און צי זענען דען נישט זיינע שוועסטער דא ביי אונדז? און זיי האבן געשטרויכלט אין אים. ");
INSERT INTO ydd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","און יהושע/ישוע האט צו זיי געזאגט: קיין נביא איז נישט אָן כבוד אחוץ אין זיין פאטערלאנד און צווישן זיינע קרובים און אין זיין אייגן הויז. ");
INSERT INTO ydd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","און ער האט דארטן נישט געקענט טאן קיין וואונדער, אויסער וואס ער האט ארויפגעלייגט די הענט אויף אייניקע שלאפע, און זיי געהיילט. ");
INSERT INTO ydd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","און ער האט זיך געוואונדערט איבער זייער אומגלויבן. און ער איז ארומגעגאנגען אין די ארומיקע דערפער און האט געלערנט. ");
INSERT INTO ydd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","און ער האט גערופן צו זיך די צוועלף, און האט אנגעהויבן זיי ארויסצושיקן צווייענווייז, און זיי געגעבן מאכט איבער די אומריינע גייסטער; ");
INSERT INTO ydd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","און ער האט זיי באפוילן, אז זיי זאלן נישט מיטנעמען קיין זאך אויפן וועג, נאר בלויז א שטעקן—נישט קיין ברויט, נישט קיין טייסטער, נישט קיין געלט אין גארטל; ");
INSERT INTO ydd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","נאר סאנדאלן זאלן זיי זיך אונטערבינדן, און נישט אנטאן קיין צוויי העמדער. ");
INSERT INTO ydd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","און האט צו זיי געזאגט: וואו נאר איר וועט אריינגיין אין א הויז, זאלט איר דארט בלייבן ביז איר וועט אוועקגיין פון יענעם ארט. ");
INSERT INTO ydd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","און וועלכעס ארט עס וועט אייך נישט אויפנעמען, און מען וועט אייך נישט וועלן הערן, זאלט איר ביים אוועקגיין פון דארטן אפשאקלען דעם שטויב פון אונטער אייערע פיס, ווי אן עדות צו זיי. ");
INSERT INTO ydd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","און זיי זענען ארויסגעגאנגען, און האבן אויסגערופן, אז מען זאל תשובה טאן, ");
INSERT INTO ydd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","און האבן ארויסגעטריבן א סך בייזע גייסטער, און געזאלבט א סך שלאפע מיט אייל, און זיי געהיילט. ");
INSERT INTO ydd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","און דער קעניג הורדוס האט געהערט וועגן דעם, (ווארום זיין נאמען איז באקאנט געווארן) און האט געזאגט: יוחנן פון דער (ירדן) מקווה איז אויפגעשטאנען פון די טויטע, און דערפאר ווירקן די כוחות אין אים! ");
INSERT INTO ydd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","אנדערע אבער האבן געזאגט, אז ער איז אליהו. און אנדערע האבן געזאגט, אז ער איז א נביא ווי איינער פון די נביאים. ");
INSERT INTO ydd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","און ווען הורדוס האט דאס געהערט, האט ער געזאגט: יוחנן, וועמען איך האב אפגעהאקט דעם קאפ, ער איז ווידער אויפגעשטאנען. ");
INSERT INTO ydd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ווארום הורדוס אליין האט געשיקט און געלאזט כאפן יוחנן, און האט אים געבונדן אין תפיסה צוליב הורודיה, דאס ווייב פון פיליפוס זיין ברודער, ווייל ער האט מיט איר חתונה געהאט. ");
INSERT INTO ydd_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ווארום יוחנן האט געזאגט צו הורדוסן: דו טארסט נישט האבן דיין ברודערס ווייב! ");
INSERT INTO ydd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","און הורודיה האט אים פיינט געקריגן, און אים געוואלט טייטן, און האט נישט געקענט; ");
INSERT INTO ydd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ווייל הורדוס האט זיך געפארכטן פאר יוחנן, וויסנדיק אז ער איז אן איש צדיק וקדוש; און האט אים געשיצט. און ווען ער האט אים געהערט, איז ער געווען אין גרויס פארלעגנהייט, און דאך האט ער אים גערן געהערט. ");
INSERT INTO ydd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","און ווען עס איז געקומען א געלעגנהייטלעכער טאג, בשעת הורדוס האט אויף זיין געבוירנטאג געמאכט א סעודה פאר זיינע גרויסע לייט, און די הויכע אפיצירן, און די חשובסטע מענטשן פון גליל, ");
INSERT INTO ydd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","איז די טאכטער פון הורודיה אליין אריינגעקומען און האט געטאנצט, און זי איז וואוילגעפעלן הורדוסן און זיינע געסט. און דער קעניג האט געזאגט צום מיידל: בעט פון מיר וואס דו ווילסט נאר, און איך וועל עס דיר געבן! ");
INSERT INTO ydd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","און ער האט איר צוגעשוואוירן: וואס דו וועסט בעטן, וועל איך דיר געבן, ביז א העלפט פון מיין קעניגרייך. ");
INSERT INTO ydd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","און זי איז ארויסגעגאנגען, און האט געזאגט צו איר מוטער: וואס זאל איך בעטן? און זי האט געזאגט: יוחנן פון דער (ירדן) מיקווהס קאפ! ");
INSERT INTO ydd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","און זי איז תיכף אריינגעגאנגען גיך צום קעניג, און האט אים געבעטן, אזוי צו זאגן: איך פארלאנג, אז דו זאלסט מיר איצט געבן קאפ פון יוחנן פון דער (ירדן) מקווה אויף א טעלער! ");
INSERT INTO ydd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","און דער קעניג איז טרויעריק געווארן, נאר צוליב די שבועות און די געסט האט ער איר נישט געוואלט אפזאגן. ");
INSERT INTO ydd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","און דער קעניג האט גלייך געשיקט א לייבוואכמאן, און האט אים באפוילן צו ברענגען זיין קאפ; און ער איז אוועקגעגאנגען און האט אים אפגעהאקט דעם קאפ אין תפיסה, ");
INSERT INTO ydd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","און געברענגט זיין קאפ אויף א טעלער, און האט אים געגעבן דעם מיידל; און דאס מיידל האט אים געגעבן צו איר מוטער. ");
INSERT INTO ydd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","און ווען זיינע תלמידים האבן עס געהערט, זענען זיי געקומען און האבן גענומען זיין קערפער, און אים געלייגט אין א קבר אריין. ");
INSERT INTO ydd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","און די שליחים האבן זיך פארזאמלט ביי יהושען/ישוען; און אים דערציילט אלץ, וואס זיי האבן געטאן, און וואס זיי האבן געלערנט. ");
INSERT INTO ydd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","און ער האט צו זיי געזאגט: קומט איר אליין אויף אן איינזאם ארט, און רוט זיך אביסל אפ! ווארום א סך זענען געקומען און געגאנגען, אז זיי האבן אפילו נישט געהאט קיין צייט צו עסן. ");
INSERT INTO ydd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","און זיי זענען אוועק אינם שיפל צו אן איינזאם ארט אליין. ");
INSERT INTO ydd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","און מען האט זיי געזען אוועקפארן, און א סך האבן זיי דערקענט, און זענען אהינגעקומען צולויפן צופוס פון אלע שטעט פארויס פאר זיי. ");
INSERT INTO ydd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","און ווען יהושע/ישוע איז אויסגעשטיגן, האט ער געזען א גרויסן עולם מענטשן, און האט געהאט אויף זיי גרויס רחמנות, ווייל זיי זענען געווען ווי שאף, וואס האבן נישט קיין פאסטוך; און ער האט אנגעהויבן זיי א סך צו לערנען. ");
INSERT INTO ydd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","און ווען עס איז שוין געווארן א שפעטע שעה, זענען זיינע תלמידים צוגעקומען צו אים, און האבן געזאגט: דאס איז א מדבריותדיק ארט, און די שעה איז שוין שפעט; ");
INSERT INTO ydd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","לאז זיי אפ, כדי זיי זאלן גיין אין דער ארומיקער געגנט און דערפער, און זיך קויפן עפעס צו עסן. ");
INSERT INTO ydd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ער אבער האט ענטפערנדיק צו זיי געזאגט: גיט איר זיי צו עסן! און זיי האבן צו אים געזאגט: זאלן מיר גיין איינקויפן ברויט פאר צוויי הונדערט דינרים, און זיי געבן צו עסן? ");
INSERT INTO ydd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ער אבער האט צו זיי געזאגט: וויפל ברויט האט איר? גייט און זעט. און דערוויסנדיק זיך, האבן זיי געזאגט: פינף, און צוויי פיש. ");
INSERT INTO ydd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","און ער האט זיי באפוילן, אז אלע זאלן זיך אנידערזעצן חברותאווייז אויפן גרינעם גראז. ");
INSERT INTO ydd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","און זיי האבן זיך אנידערגעזעצט אין שורות, צו הונדערט, און צו פופציק. ");
INSERT INTO ydd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","און ער האט גענומען די פינף ברויט און די צוויי פיש, האט ארויפגעבליקט צום הימל, און געמאכט א ברכה, און צעבראכן די ברויטן; און האט זיי געגעבן צו די תלמידים, כדי זיי זאלן עס לייגן פאר זיי; אויך די צוויי פיש האט ער אויסגעטיילט צווישן אלע. ");
INSERT INTO ydd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","און אלע האבן געגעסן און זענען זאט געווארן. ");
INSERT INTO ydd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","און זיי האבן אויפגעהויבן פון די ברעקלעך צוועלף קערב פול, און פון די פיש. ");
INSERT INTO ydd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","און די, וואס האבן געגעסן די ברויטן, זענען געווען פינף טויזנט מאן. ");
INSERT INTO ydd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","און גלייך האט ער געצוואונגען זיינע תלמידים איינצושטייגן אין דעם שיפל, און אריבערצופארן פארויס אויף דער אנדערער זייט קיין בית‑צידה, ביז ער וועט אפלאזן דעם המון מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","און נאך דעם ווי ער האט זיך געזעגנט מיט זיי, איז ער אוועקגעגאנגען צום בארג תפילה צו טאן. ");
INSERT INTO ydd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","און ווען עס איז געווארן אוונט, איז דאס שיפל געווען אינמיטן ים, און ער אליין אויף דער יבשה. ");
INSERT INTO ydd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","און זעענדיק ווי זיי פייניקן זיך מיטן רודערן, ווארום דער ווינט איז געווען אנטקעגן זיי, איז ער געקומען צו זיי, ארום דעם פערטן משמר פון דער נאכט, גייענדיק אויפן ים, און האט זיי געוואלט פארבייגיין; ");
INSERT INTO ydd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","נאר ווי זיי האבן אים געזען ארומגיין אויפן ים, האבן זיי געמיינט, אז עס איז א געשפענסט, און האבן א געשריי געטאן; ");
INSERT INTO ydd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ווארום אלע האבן אים געזען, און האבן זיך דערשראקן. ער אבער האט תיכף גערעדט מיט זיי, און צו זיי געזאגט: זייט געטרייסט; איך בין עס; ");
INSERT INTO ydd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","שרעקט זיך נישט! און ער איז איינגעשטיגן צו זיי אינם שיפל, און דער ווינט האט זיך בארואיקט. און זיי זענען אין זיך זייער דערשטוינט געווארן, איבער יעדער מאס; ");
INSERT INTO ydd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ווארום זיי האבן נישט פארשטאנען בנוגע די ברויטן, מחמת זייער הארץ איז געווען הארט (ווי שטיין). ");
INSERT INTO ydd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","און אריבערשיפנדיק זיך צום לאנד, זענען זיי געקומען קיין גניסרת, און האבן פאראנקערט. ");
INSERT INTO ydd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","און ווען זיי זענען אויסגעשטיגן פון שיפל, האט מען אים גלייך דערקענט, ");
INSERT INTO ydd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","און מען איז ארומגעלאפן אין יענער גאנצער געגנט, און מען האט אנגעהויבן ארומצוטראגן די קראנקע אויף די בעטן, וואו מען האט געהערט, אז ער געפינט זיך. ");
INSERT INTO ydd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","און וואו נאר ער איז אריינגעגאנגען, אין דערפער, אדער אין שטעט, אדער אויפן לאנד, האט מען געלייגט די קראנקע אויף די מערקפלעצער, און מען האט אים געבעטן, אז זיי זאלן נאר אנרירן די זוים פון זיין מלבוש; און אלע, וואס האבן אים אנגערירט, זענען געהאלפן געווארן. ");
INSERT INTO ydd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","און עס האבן זיך פארזאמלט צו אים די פרושים, און אייניקע פון די סופרים, וואס זענען געקומען פון ירושלים; ");
INSERT INTO ydd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","און זיי האבן געזען, אז אייניקע פון זיינע תלמידים עסן ברויט מיט טמא הענט, דאס הייסט אומגעוואשן; ");
INSERT INTO ydd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ווארום די פרושים און אלע יידן, אויב זיי וואשן זיך נישט די הענט ביז צום עלנבויגן, עסן זיי נישט, ווייל זיי האלטן די מסורה פון די זקנים; ");
INSERT INTO ydd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","און ווען זיי קומען פון מארק, עסן זיי נישט, אָן זיך צו וואשן; און א סך אנדערע זאכן זענען פאראן, וואס זיי האבן איבערגענומען צו האלטן, טבילות פון טרינק געפעסן, און טעפ, און קופערנע כלים. ");
INSERT INTO ydd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","און די פרושים און די סופרים האבן אים געפרעגט; פארוואס פירן זיך דיינע תלמידים נישט אויף לויט דער מסורה פון די זקנים, נאר עסן ברויט מיט טמא הענט? ");
INSERT INTO ydd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ער אבער האט צו זיי געזאגט; וואויל האט ישעיהו נבואות געזאגט וועגן אייך, צבועקעס, ווי עס שטייט געשריבן: דאס דאזיקע פאלק גיט מיר אפ כבוד מיט די ליפן, אבער זייער הארץ איז ווייט פון מיר. ");
INSERT INTO ydd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","און אומזיסט דינען זיי מיך, ווייל זיי לערנען מצוות, וואס זענען געבאטן פון מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","איר פארלאזט ה׳ס געבאט, און האלט די מסורה פון מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","און האט צו זיי געזאגט: פיין מאכט איר בטל ה׳ס געבאט, כדי איר זאלט האלטן אייער מסורה. ");
INSERT INTO ydd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ווארום משה האט געזאגט: דו זאלסט אפגעבן כבוד דיין פאטער און דיין מוטער, און דער, וואס פלוכט פאטער אדער מוטער, זאל געטייט ווערן. (שמות כ, יב; כא, יז.) ");
INSERT INTO ydd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","איר אבער זאגט: אויב א מענטש וועט זאגן צום פאטער אדער צו דער מוטער: קרבן, דאס הייסט א מתנה צו ה׳, זאל זיין דאס וואס דו דארפסט פון מיר נהנה זיין; ");
INSERT INTO ydd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","לאזט איר אים שוין גארנישט מער טאן פאר דעם פאטער אדער פאר דער מוטער; ");
INSERT INTO ydd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","איר מאכט צונישט ה׳ס ווארט דורך אייער מסורה, וועלכע איר האט איבערגעגעבן; און א סך אזעלכע זאכן טוט איר. ");
INSERT INTO ydd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","און האט ווידער גערופן דעם עולם מענטשן צו זיך, און צו זיי געזאגט: הערט מיך אלע צו, און פארשטייט! ");
INSERT INTO ydd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","עס איז נישטא קיין זאך פון דרויסן פון דעם מענטשן, וואס אריינגייענדיק אין אים קען אים טמא מאכן; נאר דאס וואס קומט ארויס אויס דעם מענטשן איז עס, וואס איז מטמא דעם מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","אויב עמיצער האט אויערן צום הערן, זאל ער הערן! ");
INSERT INTO ydd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","און ווען ער איז פונם המון מענטשן אריינגעקומען אין הויז אריין, האבן זיינע תלמידים אים געפרעגט וועגן דעם משל. ");
INSERT INTO ydd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","און ער זאגט צו זיי, אזוי, אויך זענט איר אָן פארשטאנד? צי פארשטייט איר דען נישט, אז אלץ, וואס גייט אריין אין דעם מענטשן פונדרויסן, קען אים נישט טמא מאכן? ");
INSERT INTO ydd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ווייל עס גייט נישט אריין אין הארצן, נאר אין בויך, און עס גייט ארויס אין בית הכסא אריין. אזוי ארום האט ער דערקלערט אלע שפייזן ריין. ");
INSERT INTO ydd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","און האט געזאגט: וואס עס קומט ארויס פון דעם מענטשן, דאס איז דעם מענטשן מטמא. ");
INSERT INTO ydd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ווארום פון אינעווייניק, אויס דעם הארצן פון די מענטשן, קומען ארויס די בייזע מחשבות, זנות, גנבות, רציחות, ");
INSERT INTO ydd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ניאופים, געלט גייציקייט, שלעכטסקייטן, כיטרעקייט, צעלאזנקייט, א שלעכט אויג, חלול השם, גאווה, אומבאקימערטע נארישקייט; ");
INSERT INTO ydd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","אלע די דאזיקע בייזע זאכן קומען ארויס פון אינעווייניק, און מאכן דעם מענטשן טמא. ");
INSERT INTO ydd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","און ער האט זיך אויפגעהויבן, און איז פון דארטן אוועק צו די גרענעצן פון צור און צידון. און ווען ער איז אריינגעגאנגען אין א הויז, האט ער געוואלט, אז קיינער זאל עס נישט וויסן; און האט נישט געקענט בלייבן פארבארגן. ");
INSERT INTO ydd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","נאר תיכף האט א פרוי וועגן אים געהערט, וואס איר טעכטערל האט געהאט אן אומריינעם גייסט, און זי איז געקומען און איז אנידערגעפאלן צו זיינע פיס. ");
INSERT INTO ydd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","די פרוי איז אבער געווען א גריכין, א סירא‑פעניצערין לויטן אפשטאם, און האט אים געבעטן, אז ער זאל ארויסטרייבן דעם בייזן גייסט פון איר טאכטער. ");
INSERT INTO ydd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","און ער האט צו איר געזאגט: לאז צוערשט די קינדער זאט ווערן; ווארום עס איז נישט שיין צו נעמען דאס ברויט פון די קינדער און עס ווארפן פאר די הינטלעך! ");
INSERT INTO ydd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","זי אבער האט געענטפערט און זאגט צו אים: יא, האר; אפילו די הינטלעך אונטערן טיש עסן פון די ברעקלעך פון די קינדער! ");
INSERT INTO ydd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","און ער האט געזאגט צו איר: צוליב דעם דאזיקן ווארט גיי דיר; דער בייזער גייסט איז שוין ארויס פון דיין טאכטער. ");
INSERT INTO ydd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","און זי איז אוועקגעגאנגען צו זיך אהיים, און האט געפונען דאס קינד ליגן אויפן בעט, און דער בייזער גייסט איז שוין געווען ארויסגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","און ער איז ווידער ארויסגעגאנגען פון די גרענעצן פון צור, און איז געגאנגען דורך צידון צום ים פון גליל, אינמיטן פון די גרענעצן פון די צען שטעט. ");
INSERT INTO ydd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","און מען האט געברענגט צו טראגן צו אים איינעם, וואס איז געווען טויב און האט געשטאמלט; און מען האט אים געבעטן, אז ער זאל ארויפלייגן אויף אים די האנט. ");
INSERT INTO ydd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","און ער האט אים אוועקגענומען פון דעם המון מענטשן אויף א זייט, האט אריינגעלייגט זיינע פינגער אין זיינע אויערן אריין, און האט אויסגעשפיגן און אנגערירט זיין צונג; ");
INSERT INTO ydd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","און ארויפבליקנדיק צום הימל, האט ער געגעבן א זיפץ, און זאגט צו אים; אפתח! דאס הייסט מאך דיך אויף! ");
INSERT INTO ydd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","און זיינע אויערן האבן זיך אויפגעעפנט, און גלייך האט זיך דאס באנד פון זיין צונג לויז געמאכט, און ער האט ריכטיג גערעדט. ");
INSERT INTO ydd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","און ער האט זיי באפוילן אז זיי זאלן עס קיינעם נישט זאגן; אבער וואס מער ער האט זיי באפוילן, אלץ מער האבן זיי עס פארשפרייט. ");
INSERT INTO ydd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","און זיי זענען געווען אויסער זיך פון שטוינען, און האבן געזאגט: ער האט אלץ וואויל געטאן; אפילו די טויבע מאכט ער הערן, און די שטומע רעדן! ");
INSERT INTO ydd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","אין יענע טעג, ווען עס איז ווידער געווען א גרויסע מאסע מענטשן, און זיי האבן נישט געהאט וואס צו עסן, האט ער גערופן צו זיך די תלמידים, און זאגט צו זיי: ");
INSERT INTO ydd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","עס טוט מיר לייד אויף דער מאסע מענטשן, ווייל שוין דריי טעג זענען זיי ביי מיר געבליבן, און האבן נישט וואס צו עסן; ");
INSERT INTO ydd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","און אויב איך זאל זיי לאזן גיין אהיים פאסטנדיק, וועלן זיי פארשמאכטן אונטערוועגנס; ווייל א טייל זענען געקומען פון ווייט. ");
INSERT INTO ydd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","און זיינע תלמידים האבן אים געענטפערט: פונוואנען וועט מען דא אין דער מדבר קענען זעטיקן די דאזיקע מיט ברויט? ");
INSERT INTO ydd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","און ער האט זיי געפרעגט: וויפל ברויטן האט איר? האבן זיי געזאגט: זיבן. ");
INSERT INTO ydd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","און ער האט באפוילן דעם המון מענטשן זיך אנידערצוזעצן אויף דער ערד; און האט גענומען די זיבן ברויטן, געמאכט א ברכה, האט זיי צעבראכן, און געגעבן צו זיינע תלמידים, אז זיי זאלן זיי אויסטיילן; און זיי האבן זיי צעטיילט (צווישן) דער מאסע מענטשן. ");
INSERT INTO ydd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","און זיי האבן געהאט אייניקע קליינע פישלעך; און ווען ער האט געמאכט א ברכה, האט ער געהייסן מען זאל אויך די דאזיקע צעטיילן. ");
INSERT INTO ydd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","און זיי האבן געגעסן, און זענען זאט געווארן; און האבן אויפגעהויבן, פון די איבערגעבליבענע ברעקלעך, זיבן קערב. ");
INSERT INTO ydd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","און עס זענען געווען אן ערך פיר טויזנט; און ער האט זיי אוועקגעשיקט. ");
INSERT INTO ydd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","און גלייך איז ער איינגעשטיגן אין דעם שיפל צוזאמען מיט זיינע תלמידים, און איז געקומען אין די געגנטן פון דלמנותא. ");
INSERT INTO ydd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","און די פרושים זענען ארויסגעגאנגען, און האבן אנגעהויבן האלטן וויכוחים מיט אים, זוכנדיק פון אים א צייכן פון הימל, כדי אים אויסצופרואוון. ");
INSERT INTO ydd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","און ער האט טיף געזיפצט אין זיין גייסט, און געזאגט: וואס זוכט דאס דאזיקע דור א צייכן? באמת זאג איך אייך: קיין צייכן וועט נישט געגעבן ווערן דעם דאזיקן דור. ");
INSERT INTO ydd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","און האט זיי פארלאזט, און איז ווידער איינגעשטיגן אין דעם שיפל, און איז אריבערגעפארן אויף דער אנדערער זייט. ");
INSERT INTO ydd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","און זיי האבן פארגעסן מיטצונעמען ברויט; און אחוץ איין לעבל האבן זיי נישט געהאט מער מיט זיך אינם שיפל. ");
INSERT INTO ydd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","און ער האט זיי געווארנט, אזוי צו זאגן: גיט אכטונג, היט זיך פארן זויערטייג פון די פרושים און פארן זויערטייג פון הורדוסן! ");
INSERT INTO ydd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","און זיי האבן עס איבערגערעדט איינער מיט דעם אנדערן: דאס איז ווייל האבן נישט קיין ברויט. ");
INSERT INTO ydd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","און יהושע/ישוע האט עס באמערקט, און צו זיי געזאגט: פארוואס האט איר (אזעלכע) מחשבות, ווייל איר האט נישט קיין ברויט? צי פארשטייט איר נאך אלץ נישט און זענט נישט משיג? איז אייער הארץ נאך אלץ פארהארטעוועט? ");
INSERT INTO ydd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","איר האט אויגן און זעט נישט, און אויערן און הערט נישט? און צי געדענקט איר נישט, ");
INSERT INTO ydd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ווען איך האב צעבראכן די פינף ברויטן פאר די פינף טויזנט, וויפל קערב פול מיט ברעקלעך איר האט אויפגעקליבן? זאגן זיי צו אים: צוועלף! ");
INSERT INTO ydd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","און ווען די זיבן (ברויטן) פאר די פיר טויזנט, וויפל גרויסע קערב פול מיט ברעקלעך איר האט אויפגעקליבן? און זיי זאגן: זיבן! ");
INSERT INTO ydd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","און ער האט צו זיי געזאגט: צי זענט איר נאך אלץ נישט משיג? ");
INSERT INTO ydd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","און זיי זענען געקומען קיין בית‑צידה. און מען האט געברענגט צו אים א בלינדן, און אים געבעטן, אז ער זאל אים אנרירן. ");
INSERT INTO ydd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","און ער האט אנגענומען דעם בלינדן ביי דער האנט, און אים ארויסגעפירט אויסער דעם דארף; האט אים ארויפגעשפיגן אויף די אויגן, און ארויפגעלייגט די הענט אויף אים, און אים געפרעגט, צי ער זעט עפעס. ");
INSERT INTO ydd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","און ער האט א בליק געטאן און געזאגט: איך זע די מענטשן; אז ווי ביימער זע איך זיי ארומגיין! ");
INSERT INTO ydd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","נאך דעם האט ער ווידער ארויפגעלייגט די הענט אויף זיינע אויגן; און ער האט שארף געקוקט, און איז געהיילט געווארן, און האט אלץ געזען קלאר אפילו פונדערווייטנס. ");
INSERT INTO ydd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","און ער האט אים אוועקגעשיקט אהיים, און געזאגט: אין דעם דארף זאלסטו אפילו נישט אריינגיין! ");
INSERT INTO ydd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","און יהושע/ישוע איז ארויסגעגאנגען, און זיינע תלמידים, אין די דערפער אריין פון קסריה פון פיליפוס; און אונטערוועגנס האט ער געפרעגט זיינע תלמידים, זאגנדיק צו זיי: ווער זאגן די מענטשן, אז איך בין? ");
INSERT INTO ydd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","און זיי האבן אים געענטפערט, אזוי צו זאגן: יוחנן פון דער (ירדן) מקווה; און אנדערע, אליהו; אנדערע אבער, אז איינער פון די נביאים. ");
INSERT INTO ydd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","און ער האט זיי געפרעגט: איר אבער, ווער זאגט איר, אז איך בין? ענטפערנדיק זאגט פעטרוס צו אים: דו ביסט דער משיח! ");
INSERT INTO ydd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","און ער האט זיי שטרענג אנגעזאגט, אז זיי זאלן קיינעם נישט אויסזאגן וועגן אים. ");
INSERT INTO ydd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","און האט זיי אנגעהויבן צו לערנען, אז דער בר אנש מוז ליידן א סך, און פארווארפן ווערן פון די זקנים, און פון די הויפט כהנים, און פון די סופרים, און געטייט ווערן, און אין דריי טעג ארום ווידער אויפשטיין. ");
INSERT INTO ydd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","און ער האט דאס ווארט גערעדט אפן, נישט פארהוילן. און פעטרוס האט אים גענומען אויף א זייט, און אנגעהויב אנצושרייען אויף אים. ");
INSERT INTO ydd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ער אבער האט זיך אויסגעדרייט, און געקוקט אויף זיינע תלמידים, און האט אנגעשריגן אויף פעטרוסן, און זאגט: אוועק, הינטער מיר, שׂטן! ווייל דו האסט נישט אין זינען דאס, וואס איז שייך ה׳, נאר דאס, וואס איז שייך מענטשן! ");
INSERT INTO ydd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","און האט צוגערופן צו זיך דעם המון מענטשן צוזאמען מיט זיינע תלמידים, און צו זיי געזאגט: אויב עמיצער וויל מיר נאכגיין, זאל ער זיך אליין פארלייקענען, און זאל ער נעמען זיין בוים. און מיר נאכפאלגן. ");
INSERT INTO ydd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ווארום ווער עס וויל ראטעווען זיין נפש, וועט עס פארלירן; ווער אבער עס וועט פארלירן זיין לעבן צוליב מיר און דער גוטער בשורה, דער וועט עס אפראטעווען. ");
INSERT INTO ydd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ווארום וואס לוינט זיך א מענטשן צו געווינען די גאנצע וועלט, און צו פארלירן זיין נפש? ");
INSERT INTO ydd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ווארום וואס פאר אן אויסלייז געלט זאל א מענטש געבן פאר זיין נפש? ");
INSERT INTO ydd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ווארום ווער עס וועט זיך שעמען מיט מיר און מיט מיינע ווערטער אין דעם דאזיקן נואפדיקן און זינדיקן דור, וועט דער בר אנש זיך אויך שעמען מיט אים, ווען ער וועט קומען אין דער הערלעכקייט פון זיין פאטער מיט די הייליקע מלאכים. ");
INSERT INTO ydd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","און ער האט צו זיי געזאגט: באמת זאג איך אייך, עס זענען פאראן אייניקע, וואס שטייען דא, וועלכע וועלן נישט פארזוכן דעם טעם פון טויט, ביז זיי וועלן זען דאס קעניגרייך פון ה׳ געקומען מיט מאכט. ");
INSERT INTO ydd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","און אין זעקס טעג ארום נעמט יהושע/ישוע מיט זיך פעטרוסן, און יעקבן, און יוחנן, און פירט זיי ארויף אויף א הויכן בארג איינע אליין; און ער האט זיך פארענדערט פאר זיי; ");
INSERT INTO ydd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","און זיינע קליידער זענען געווארן שטראלנדיק, זייער ווייס, ווי קיין וואלקער אויף דער ערד קען נישט אזוי ווייס מאכן. ");
INSERT INTO ydd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","און אליהו (הנביא) האט זיך צו זיי באוויזן צוזאמען מיט משה (רבינו), און זיי האבן גערעדט מיט יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","און ענטפערנדיק זאגט פעטרוס צו יהושען/ישוען: רבי, עס איז גוט פאר אונדז דא צו זיין; און לאמיר מאכן דריי געצעלטן: פאר דיר איינס, און פאר משהן איינס, און פאר אליהו איינס; ");
INSERT INTO ydd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ווארום ער האט נישט געוואוסט, וואס ער זאל ענטפערן; ווארום זיי האבן זיך זייער געפארכטן. ");
INSERT INTO ydd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","און א וואלקן איז געקומען און האט זיי באשאטנט; און אויס דעם וואלקן איז געקומען א קול: דער דאזיקער איז מיין געליבטער זון, אים זאלט איר הערן! ");
INSERT INTO ydd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","און פלוצלונג, ארומקוקנדיק זיך, האבן זיי מער קיינעם נישט געזען, אחוץ יהושען/ישוען אליין מיט זיי. ");
INSERT INTO ydd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","און ווען זיי זענען אראפגעגאנגען פונם בארג, האט ער זיי באפוילן, אז זיי זאלן קיינעם נישט דערציילן, וואס זיי האבן געזען, אחוץ ווען דער בר אנש וועט זיין אויפגעשטאנען פון די טויטע. ");
INSERT INTO ydd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","און זיי האבן באהאלטן דאס ווארט, און האבן זיך געפרעגט איינס דאס אנדערע, וואס עס באטייט דאס אויפשטיין פון די טויטע. ");
INSERT INTO ydd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","און האבן אים געפרעגט, אזוי צו זאגן: די סופרים זאגן, אז אליהו מוז קומען צום ערשט. (מלאכי ד, ה-ו.) ");
INSERT INTO ydd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","און ער האט צו זיי געזאגט: אליהו קומט טאקע צום ערשט, און שטעלט אלץ צוריק; און וויאזוי שטייט געשריבן וועגן דעם בר אנש אז ער וועט א סך ליידן און צונישט געמאכט ווערן? (ישעיהו נג, ג.) ");
INSERT INTO ydd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","איך זאג אייך אבער, אז אליהו איז אויך שוין געקומען, און זיי האבן מיט אים געטאן, וואס זיי האבן געוואלט, אזוי ווי עס שטייט געשריבן וועגן אים. ");
INSERT INTO ydd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","און קומענדיק צו די תלמידים, האבן זיי געזען א גרויסן המון מענטשן ארום זיי, און סופרים האלטן מיט זיי א וויכוח. ");
INSERT INTO ydd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","און גלייך ווי דער המון מענטשן האבן אים דערזען, זענען זיי דערשטוינט געווארן, און זענען אים אקייגנגעלאפן און אים אפגעגעבן שלום. ");
INSERT INTO ydd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","און ער האט זיי געפרעגט: איבער וואס האלט איר מיט זיי א וויכוח? ");
INSERT INTO ydd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","און איינער אויס דעם המון האט אים געענטפערט: רבי, איך האב געברענגט צו דיר מיין זון, וועלכער האט א שטומען גייסט; ");
INSERT INTO ydd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","און וואו נאר ער כאפט אים אָן, רייסט ער אים, און ער שוימט פארן מויל, און קריצט מיט די ציין, און ווערט פארדארט; און איך האב שוין געזאגט דיינע תלמידים, אז זיי זאלן אים ארויסטרייבן; און זיי האבן נישט געקענט. ");
INSERT INTO ydd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ער אבער ענטפערנדיק זאגט צו זיי: אָ, אומגלויביק דור! ווילאנג זאל איך נאך זיין מיט אייך? ביז ווען זאל איך אייך דערטראגן? ברענגט אים אהער צו מיר! ");
INSERT INTO ydd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","און זיי האבן אים געברענגט צו אים; און ווי ער האט אים דערזען, האט דער גייסט אים גלייך א ריס געטאן; און ער איז אנידערגעפאלן אויף דער ערד, האט זיך געוואלגערט, שוימענדיק פארן מויל, ");
INSERT INTO ydd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","און ער האט געפרעגט זיין פאטער: ווילאנג איז שוין זינט דאס דאזיקע איז געשען צו אים? און ער האט געזאגט: פון קינדווייז אָן; ");
INSERT INTO ydd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","און אפטמאל האט ער אים געווארפן אין פייער אריין און אין וואסער אריין, כדי ער זאל אים אומברענגען; נאר אויב דו ביסט עפעס בכוח, העלף אונדז, און דערבארם דיך אויף אונדז! ");
INSERT INTO ydd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","יהושע/ישוע אבער האט צו אים געזאגט: אויב דו ביסט בכוח? אלץ איז מעגלעך פאר דעם, וואס גלויבט. ");
INSERT INTO ydd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","גלייך האט דער פאטער פון דעם יינגל א געשריי געטאן, און געזאגט: איך גלויב; העלף מיין אומגלויבן! ");
INSERT INTO ydd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","און ווי יהושע/ישוע האט געזען, אז א המון מענטשן לויפט זיך צונויף, האט ער אנגעשריגן דעם אומריינעם גייסט, זאגנדיק צו אים: דו שטומער און טויבער גייסט, איך באפעל דיר: גיי פון אים ארויס, און זאלסט מער נישט אריינגיין אין אים! ");
INSERT INTO ydd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","און ער האט א געשריי געטאן, און האט אים זייער פיל געריסן, און איז ארויסגעגאנגען; און ער איז געווארן ווי טויט, אז א רבים האבן געזאגט, אז ער איז געשטארבן! ");
INSERT INTO ydd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","יהושע/ישוע אבער האט אים אנגענומען ביי דער האנט, און אים אויפגעהויבן; און ער האט זיך אויפגעשטעלט. ");
INSERT INTO ydd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","און ווען ער איז אריינגעגאנגען אינם הויז, האבן זיינע תלמידים, גאנץ אליין, אים געפרעגט: פארוואס זענען מיר נישט געווען בכוח אים ארויסצוטרייבן? ");
INSERT INTO ydd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","און ער האט צו זיי געזאגט: דער דאזיקער מין (בייזע גייסטער) קען בשום אופן נישט ארויסגיין, אחוץ דורך תפילה און תעניתים. ");
INSERT INTO ydd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","און זיי זענען פון דארטן אוועק, און זענען געגאנגען דורך גליל; און ער האט נישט געוואלט, אז עמיצער זאל עס וויסן. ");
INSERT INTO ydd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ווארום ער האט געלערנט זיינע תלמידים, און צו זיי געזאגט: דער בר אנש וועט איבערגעגעבן ווערן אין די הענט פון מענטשן, און זיי וועלן אים טייטן; און זייענדיק געטייט, וועט ער אין דריי טעג ארום ווידער אויפשטיין. ");
INSERT INTO ydd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","זיי אבער האבן נישט פארשטאנען דאס ווארט, און האבן זיך געפארכטן אים צו פרעגן. ");
INSERT INTO ydd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","און די זענען געקומען קיין כפר‑נחום; און זייענדיק אינם הויז, האט ער זיי געפרעגט: וועגן וואס האט איר זיך מתווכח געווען אויפן וועג? ");
INSERT INTO ydd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","זיי אבער האבן געשוויגן; ווייל אונטערוועגנס האבן זיי געהאלטן א וויכוח איינער מיטן אנדערן, ווער עס איז דער גרעסטער. ");
INSERT INTO ydd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","און ער האט זיך אנידערגעזעצט, און האט גערופן די צוועלף; און זאגט צו זיי: אויב איינער וויל זיין דער ערשטער, זאל ער זיין דער לעצטער פון אלע, און אלעמענס משרת. ");
INSERT INTO ydd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","און האט גענומען א קינד, און עס אנידערגעשטעלט אין זייער מיט; און ער האט עס גענומען אויף זיינע ארעמס, און צו זיי געזאגט: ");
INSERT INTO ydd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ווער עס וועט אויפנעמען איינס פון אזעלכע קינדער אין מיין נאמען, דער נעמט מיך אויף; און ווער עס נעמט מיך אויף, דער נעמט נישט אויף מיך, נאר דעם, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","יוחנן האט צו אים געזאגט; רבי, מיר האבן געזען איינעם ארויסטרייבן בייזע גייסטער אין דיין נאמען; און מיר האבן עס אים פארווערט, ווייל ער פאלגט אונדז נישט נאך. ");
INSERT INTO ydd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","יהושע/ישוע אבער האט געזאגט: איר זאלט אים נישט פארווערן! ווייל עס איז נישט פאראן קיין מענטש, וועלכער וועט טאן א וואונדער אין מיין נאמען, און וואס וועט גיך קענען רעדן שלעכטס אויף מיר. ");
INSERT INTO ydd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ווארום ווער עס איז נישט קעגן אונדז, דער איז פאר אונדז. ");
INSERT INTO ydd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ווארום ווער עס וועט אייך געבן צו טרינקען א טעפעלע וואסער, פון מיינעטוועגן, ווייל איר געהערט צום משיח, באמת זאג איך אייך, דער וועט בשום אופן נישט פארלירן זיין שכר. ");
INSERT INTO ydd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","און ווער עס וועט פארפירן צום שטרויכלען איינעם פון די דאזיקע קליינע, וואס גלויבן וואלט עס געווען פיל בעסער פאר אים אויב א גרויסער מילשטיין וואלט געלייגט געווארן אויף זיין האלדז, און ער וואלט געווארפן געווארן אין ים אריין. ");
INSERT INTO ydd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","און אויב דיין האנט פארפירט דיך צום שטרויכלען, האק זי אפ! עס איז בעסער פאר דיר אריינצוגיין אין לעבן אריין א קאליקע, ווי צו האבן דיינע ביידע הענט און צו גיין אין גיהנום אריין—אין דעם פייער, וואס לעשט זיך נישט אויס, וואו זייער ווארעם שטארבט נישט, און דאס פייער ווערט נישט פארלאשן. (ישעיהו סו, כד.) ");
INSERT INTO ydd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","און אויב דיין פוס פארפירט דיך צום שטרויכלען, האק אים אפ! עס איז בעסער פאר דיר אריינצוגיין אין לעבן לאם, ווי צו האבן דיינע ביידע פיס און אריינגעווארפן צו ווערן אין גיהנום, וואו זייער ווארעם שטארבט נישט, און דאס פייער ווערט נישט פארלאשן. ");
INSERT INTO ydd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","און אויב דיין אויג פארפירט דיך צום שטרויכלען, נעם עס ארויס! עס איז בעסער פאר דיר אריינצוגיין אין ה׳ס קעניגרייך מיט איין אויג, ווי צו האבן צוויי אויגן און געווארפן צו ווערן אין גיהנום אריין, ");
INSERT INTO ydd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","וואו זייער ווארעם שטארבט נישט, און דאס פייער ווערט נישט פארלאשן. ");
INSERT INTO ydd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ווארום יעדער איינער מוז געזאלצן ווערן מיט פייער. ");
INSERT INTO ydd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","דאס זאלץ איז גוט; אויב אבער דאס זאלץ ווערט אומגעזאלצן, מיט וואס וועט איר עס ווירצן? האט זאלץ אין זיך, און לעבט בשלום איינער מיט דעם אנדערן. ");
INSERT INTO ydd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","און ער איז אויפגעשטאנען פון דארטן, און איז געקומען צו די גרענעצן פון יהודה און פון עבר הירדן; און ווידער האבן המונים מענטשן זיך פארזאמלט ביי אים; און ווי געוויינטלעך, האט ער זיי ווידער געלערנט. ");
INSERT INTO ydd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","און פרושים זענען צוגעקומען צו אים, און האבן אים געפרעגט, אויב א מאן מעג זיך גטן מיטן ווייב; אויספרואוונדיק אים. ");
INSERT INTO ydd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ער אבער האט ענטפערנדיק געזאגט צו זיי: וואס האט אייך משה געבאטן? ");
INSERT INTO ydd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","און זיי האבן געזאגט: משה האט דערלויבט (איר) צו שרייבן א ספר כריתות (גט) און זי אוועקצושיקן. (דברים כד, א.) ");
INSERT INTO ydd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","יהושע/ישוע אבער האט צו זיי געזאגט: צוליב דער פארהארטעוועטקייט פון אייער הארץ האט ער אייך אנגעשריבן דאס דאזיקע געבאט; ");
INSERT INTO ydd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","פון אנהויב פון דער באשאפונג אבער האט ה׳ זיי באשאפן זכר און נקבה. (בראשית א, כז.) ");
INSERT INTO ydd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","דערפאר וועט א מענטש פארלאזן זיין פאטער און די מוטער, און זיך באהעפטן מיט זיין ווייב, ");
INSERT INTO ydd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","און די צוויי וועלן זיין איין פלייש (בראשית ב, כד.); אזוי זענען זיי מער נישט צוויי, נאר איין פלייש. ");
INSERT INTO ydd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","דעריבער וואס ה׳ האט מזווג געווען, דאס זאל קיין מענטש נישט צעשיידן! ");
INSERT INTO ydd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","און אינם הויז האבן די תלמידים אים ווידער געפרעגט וועגן דער דאזיקער זאך. ");
INSERT INTO ydd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","און ער האט צו זיי געזאגט: ווער עס גט זיך מיט זיין ווייב, און האט חתונה מיט אן אנדערער, איז ער מזנה קעגן איר; ");
INSERT INTO ydd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","און אויב זי גט זיך מיט איר מאן, און האט חתונה מיט אן אנדערן, טוט זי זנות. ");
INSERT INTO ydd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","און מען האט צו אים געברענגט קליינע קינדער, כדי ער זאל זיי אנרירן; די תלמידים אבער האבן אנגעשריגן אויף זיי. ");
INSERT INTO ydd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","און ווי יהושע/ישוע האט דאס געזען, האט עס אים פארדראסן, און ער האט צו זיי געזאגט: לאזט די קליינע קינדער קומען צו מיר; פארווערט עס זיי נישט; ווארום פאר זייערסגלייכן איז דאס קעניגרייך פון ה׳! ");
INSERT INTO ydd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","באמת זאג איך אייך: ווער עס וועט נישט אויפנעמען דאס קעניגרייך פון ה׳ ווי א קליין קינד, דער וועט בשום אופן נישט אריינגיין דערין! ");
INSERT INTO ydd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","און האט זיי גענומען אויף זיינע ארעמס, און געבענטשט, ארויפלייגנדיק די הענט אויף זיי. ");
INSERT INTO ydd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","און בעת ער איז ארויסגעגאנגען אויפן וועג, איז אים איינער אקייגנגעלאפן, און איז אנידערגעפאלן פאר אים אויף די קני, און האט אים געפרעגט: רבי גוטער, וואס זאל איך טאן, כדי איך זאל ירשענען אייביק לעבן? ");
INSERT INTO ydd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","און יהושע/ישוע האט צו אים געזאגט: וואס רופסטו מיך גוטער? קיינער איז נישט גוט, אחוץ ה׳ אליין! ");
INSERT INTO ydd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","די געבאטן קענסטו: דו זאלסט נישט מארדן! דו זאלסט נישט נואפן! דו זאלסט נישט גנבענען! דו זאלסט נישט פאלש עדות זאגן! דו זאלסט נישט באטריגן! דו זאלסט אפגעבן כבוד דיין פאטער און דיין מוטער! (שמות כ, יב-טז.) ");
INSERT INTO ydd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","און ער האט צו אים געזאגט: רבי, אלע די דאזיקע האב איך אפגעהיטן פון מיין יוגנט אָן. ");
INSERT INTO ydd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","און יהושע/ישוע האט אויף אים א בליק געטאן און אים ליב געקריגן, און געזאגט צו אים: איין זאך פעלט דיר; גיי, פארקויף אלץ, וואס דו האסט, און גיב עס צו די ארעמעלייט, און דו וועסט האבן אן אוצר אין הימל; און קום, און פאלג מיר נאך! ");
INSERT INTO ydd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ער אבער איז אומעטיק געווארן איבער דעם ווארט, און איז אוועקגעגאנגען א טרויעריקער, ווארום ער האט געהאט א גרויס פארמעגן. ");
INSERT INTO ydd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","און יהושע/ישוע האט זיך ארומגעקוקט, און זאגט צו זיינע תלמידים: אָ, ווי שווער עס איז פאר די, וואס האבן עשירות אריינצוקומען אין דעם קעניגרייך פון ה׳! ");
INSERT INTO ydd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","און די תלמידים זענען דערשטוינט געווארן איבער זיינע ווערטער. יהושע/ישוע אבער ווידער ענטפערנדיק האט צו זיי געזאגט: קינדער, אָ, ווי שווער עס איז פאר די, וואס האבן בטחון אויף געלט, אריינצוגיין אין דעם קעניגרייך פון ה׳! ");
INSERT INTO ydd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","עס איז לייכטער פאר א קעמל דורכצוגיין דורך דעם לאך פון א נאדל, ווי פאר א רייכן מאן אריינצוקומען אין דעם קעניגרייך פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","און זיי זענען נאך מער דערשטוינט געווארן, און האבן צו זיך גערעדט: און ווער זשע קען דערלייזט ווערן? ");
INSERT INTO ydd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","יהושע/ישוע האט א קוק געטאן אויף זיי און זאגט: ביי מענטשן איז עס אוממעגלעך, נאר נישט ביי ה׳; ווארום אלץ איז מעגלעך ביי ה׳. ");
INSERT INTO ydd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","פעטרוס האט אנגעהויבן צו רעדן צו אים: זע, מיר האבן אלץ פארלאזן, און האבן דיר נאכגעפאלגט! ");
INSERT INTO ydd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","האט יהושע/ישוע געזאגט: באמת זאג איך אייך: עס איז נישט פאראן קיינער, וועלכער האט פארלאזט הויז, אדער ברידער, אדער שוועסטער, אדער מוטער, אדער פאטער, אדער קינדער, אדער פעלדער, צוליב מיר, און צוליב דער בשורה טובה, ");
INSERT INTO ydd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","וועלכער וועט נישט באקומען הונדערט מאל אזויפיל איצט אין דער דאזיקער צייט, הייזער, און ברידער, און שוועסטער, און מוטערס, און קינדער, און פעלדער, מיט פארפאלגונגען; און אין דער קומענדיקער וועלט אייביק לעבן. ");
INSERT INTO ydd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","אבער א סך ערשטע וועלן זיין לעצטע; און די לעצטע ערשטע. ");
INSERT INTO ydd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","און זיי זענען געווען אויפן וועג, ארויפגייענדיק קיין ירושלים; און יהושע/ישוע איז געגאנגען פארויס פאר זיי; און זיי האבן געשטוינט; און די, וואס האבן נאכגעפאלגט, האבן זיך געפארכטן. און ער האט ווידער גענומען די צוועלף צו זיך, און האט אנגעהויבן צו רעדן צו זיי וועגן די זאכן, וואס וועלן קומען אויף אים: ");
INSERT INTO ydd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","זע, גייען מיר ארויף קיין ירושלים, און דער בר אנש וועט איבערגעגעבן ווערן צו די הויפט כהנים און די סופרים; און זיי וועלן אים פארמשפטן צום טויט, און אים איבערגעבן צו די אומות (העולם); ");
INSERT INTO ydd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","און זיי וועלן אפשפאטן פון אים, און שפייען אויף אים, און וועלן אים שמייסן, און טייטן; און אין דריי טעג ארום וועט ער ווידער אויפשטיין. ");
INSERT INTO ydd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","און יעקב און יוחנן, זבדיס זין, זענען צוגעגאנגען צו אים, און האבן צו אים געזאגט: רבי, מיר פארלאנגען, אז דו זאלסט פאר אונדז טאן, וואס מיר וועלן דיך בעטן! ");
INSERT INTO ydd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","און ער האט צו זיי געזאגט: וואס פארלאנגט איר, אז איך זאל טאן פאר אייערטוועגן? ");
INSERT INTO ydd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","און זיי האבן צו אים געזאגט: גיב אונדז, אז מיר זאלן זיצן, איינער אויף דיין רעכטער זייט, און איינער אויף דיין לינקער זייט, אין דיין הערלעכקייט! ");
INSERT INTO ydd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","יהושע/ישוע אבער האט צו זיי געזאגט: איר ווייסט נישט וואס איר בעט! צי קענט איר דען טרינקען דעם בעכער, וואס איך טרינק? אדער געטובלט ווערן מיט דער מקווה, מיט וועלכער איך ווער געטובלט? ");
INSERT INTO ydd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","און זיי האבן געזאגט צו אים: מיר קענען! יהושע/ישוע אבער האט צו זיי געזאגט: דעם בעכער, וואס איך טרינק, וועט איר טרינקען; און מיט דער מקווה, מיט וועלכער איך ווער געטובלט, וועט איר געטובלט ווערן; ");
INSERT INTO ydd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","נאר צו זיצן אויף מיין רעכטער זייט אדער לינקער זייט איז נישט מיינס צו געבן, נאר (עס איז פאר די) פאר וועמען עס איז צוגעגרייט געווארן. ");
INSERT INTO ydd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","און ווען די צען האבן עס געהערט, האבן זיי אנגעהויבן צו ווערן אין כעס אויף יעקבן און יוחנן. ");
INSERT INTO ydd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","און יהושע/ישוע האט זיי גערופן צו זיך, און זאגט צו זיי; איר ווייסט, אז די, וואס גילטן צו הערשן איבער די פעלקער, אונטעריאכן זיי; און זייערע גדולים געוועלטיקן איבער זיי. ");
INSERT INTO ydd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ביי אייך אבער איז עס נישט אזוי; נאר ווער עס וועט וועלן ווערן א גדול צווישן אייך, וועט ער זיין אייער משרת; ");
INSERT INTO ydd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","און ווער עס וועט וועלן זיין צווישן אייך דער ערשטער, וועט ער זיין אלעמענס קנעכט. ");
INSERT INTO ydd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ווארום אפילו דער בר אנש איז נישט געקומען באדינט צו ווערן, נאר צו דינען, און צו געבן זיין לעבן ווי אן אויסלייז פאר פילע. ");
INSERT INTO ydd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","און זיי קומען קיין יריחו. און ווען ער איז ארויסגעגאנגען פון יריחו, מיט זיינע תלמידים און אן אנגעזעענעם המון מענטשן, איז טימיס זון, בר‑טימי, א בלינדער בעטלער, געזעסן ביים וועג. ");
INSERT INTO ydd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","און הערנדיק, אז עס איז יהושע/ישוע פון נצרת, האט ער אנגעהויבן צו שרייען, און זאגן: בן דוד, יהושע/ישוע, האב רחמנות אויף מיר! ");
INSERT INTO ydd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","און א סך האבן אנגעשריגן אויף אים, כדי ער זאל שווייגן; ער אבער האט נאך פיל מער געשריגן: בן דוד, האב רחמנות אויף מיר! ");
INSERT INTO ydd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","און יהושע/ישוע האט זיך אפגעשטעלט, און געזאגט: רופט אים. און זיי רופן דעם בלינדן, און זאגן צו אים: זיי געטרייסט; שטיי אויף, ער רופט דיך! ");
INSERT INTO ydd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","און ער האט אוועקגעווארפן זיין מלבוש, און זיך אויפגעשטעלט אויף די פיס, און איז געקומען צו יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","און יהושע/ישוע האט ענטפערנדיק צו אים געזאגט: וואס ווילסטו, אז איך זאל דיר טאן? און דער בלינדער האט צו אים געזאגט: רבוני, אז איך זאל זעענדיק ווערן! ");
INSERT INTO ydd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","און יהושע/ישוע האט צו אים געזאגט: גיי; דיין גלויבן האט דיר געהאלפן! און תיכף איז ער זעענדיק געווארן, און האט אים נאכגעפאלגט אויפן וועג. (ישעיהו מב, ו-ז.) ");
INSERT INTO ydd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","און ווען זיי דערנענטערן זיך צו ירושלים, צו בית‑פגי און בית‑היני, ביים הר הזיתים, שיקט ער צוויי פון זיינע תלמידים, ");
INSERT INTO ydd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","און זאגט צו זיי: גייט אין דעם דארף אריין, וואס איז אנטקעגנאיבער אייך; און גלייך ווי איר וועט אריינקומען אהין, וועט איר געפינען א יונג אייזעלע אנגעבונדן, אויף וועלכן קיין מענטש איז נאך קיינמאל נישט געזעסן; בינדט עס אפ, און ברענגט עס. ");
INSERT INTO ydd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","און אויב עמיצער וועט צו אייך זאגן: פארוואס טוט איר דאס? זאלט איר זאגן: דער האר האט עס נייטיק, און שיקט עס באלד צוריק אהער. ");
INSERT INTO ydd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","און זיי זענען אוועקגעגאנגען, און האבן געפונען א יונג אייזעלע אנגעבונדן ביי א טיר אינדרויסן ביים שייד וועג; און זיי בינדן עס אפ. ");
INSERT INTO ydd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","און אייניקע, וואס זענען דארטן געשטאנען, האבן צו זיי געזאגט: וואס טוט איר, אפבינדנדיק דאס אייזעלע? ");
INSERT INTO ydd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","און זיי האבן צו זיי געזאגט אזוי ווי יהושע/ישוע האט באפוילן; און זיי האבן זיי געלאזט. ");
INSERT INTO ydd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","און זיי ברענגען דאס יונגע אייזעלע צו יהושען/ישוען, און לייגן ארויף דערויף זייערע מלבושים; און ער האט זיך דערויף ארויפגעזעצט. ");
INSERT INTO ydd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","און א סך האבן אויסגעשפרייט זייערע מלבושים אויפן וועג; און אנדערע האבן אויסגעשפרייט צווייגן, וואס זיי האבן אפגעשניטן אויף די פעלדער. ");
INSERT INTO ydd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","און די, וואס זענען געגאנגען פארויס, און די, וואס זענען נאכגעגאנגען, האבן געשריגן: הושענא! געלויבט איז דער, וואס קומט אינם נאמען פון דעם האר! (ברוך הבא בשם ה׳) ");
INSERT INTO ydd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","געבענטשט איז דאס מלכות פון אונדזער פאטער דוד, וואס קומט! הושענא במרומים! (תהלים קיח, כו.) ");
INSERT INTO ydd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","און ער איז אריינגעגאנגען קיין ירושלים אין בית המקדש אריין; און נאך דעם ווי ער האט זיך אויף אלעם ארומגעקוקט, ווייל עס איז שוין געווען א שפעטע אוונט שעה, איז ער ארויסגעגאנגען קיין בית‑היני צוזאמען מיט די צוועלף. ");
INSERT INTO ydd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","און צומארגנס, ווען זיי זענען ארויסגעגאנגען פון בית‑היני, איז ער געווארן הונגעריק. ");
INSERT INTO ydd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","און דערזעענדיק פונדערווייטנס א פייגנבוים, וואס האט געהאט בלעטער, איז ער אהינגעגאנגען, אפשר וועט ער עפעס געפינען אויף אים; און ווען ער איז צוגעקומען צו אים, האט ער גארנישט געפונען אחוץ בלעטער; ווארום עס איז נישט געווען דער זמן פון פייגן. ");
INSERT INTO ydd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","און ער האט ענטפערנדיק געזאגט צו אים: עס זאל מער ביז אויף אייביק קיינער נישט עסן פון דיר קיין פרי! און זיינע תלמידים האבן עס געהערט. ");
INSERT INTO ydd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","און זיי קומען קיין ירושלים. און ער איז אריינגעגאנגען אין בית המקדש. און האט אנגעהויבן ארויסצוטרייבן די, וואס האבן פארקויפט און געקויפט אין בית המקדש, און איבערגעקערט די טישן פון די געלט וועקסלער, און די בענק פון די פארקויפער פון טויבן. ");
INSERT INTO ydd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","און ער האט נישט דערלאזט, אז עמיצער זאל דורכטראגן א כלי דורך דעם בית המקדש. ");
INSERT INTO ydd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","און ער האט זיי געלערנט, און האט צו זיי געזאגט: צי שטייט דען נישט געשריבן: מיין הויז זאל גערופן ווערן א בית תפילה פאר אלע פעלקער? (ישעיהו נו, ז.) איר אבער האט עס געמאכט פאר א רויבער הייל! (ירמיהו ז, יא.) ");
INSERT INTO ydd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","און די הויפט כהנים און די סופרים האבן עס געהערט. און זיי האבן געזוכט וויאזוי אים אומצוברענגען; ווארום זיי האבן מורא געהאט פאר אים, ווייל דער גאנצער המון מענטשן האט געשטוינט איבער זיין לערנונג. ");
INSERT INTO ydd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","און ווען עס איז געווארן אוונט, איז ער ארויסגעגאנגען אויסער דער שטאט. ");
INSERT INTO ydd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","און ווען זיי זענען פארבייגעגאנגען אינדערפרי, האבן זיי געזען דעם פייגנבוים פארטריקנט ביז צו די ווארצלען. ");
INSERT INTO ydd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","און פעטרוס האט זיך דערמאנט און זאגט צו אים: רבי, זע, דער פייגנבוים, וועלכן דו האסט פארפלוכט, איז פארדארט געווארן! ");
INSERT INTO ydd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","און יהושע/ישוע האט ענטפערנדיק צו זיי געזאגט: האט אמונה אין ה׳! ");
INSERT INTO ydd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","באמת זאג איך אייך: ווער עס וועט זאגן צום דאזיקן בארג: הויב דיך אויף און ווארף דיך אין ים אריין! און וועט נישט זיין מסופק אין זיין הארצן, נאר וועט גלויבן, אז וואס ער זאגט וועט געשען, וועט עס (אזוי) זיין פאר אים. ");
INSERT INTO ydd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","דערפאר זאג איך אייך: אלץ, אויף וואס איר וועט תפילה טאן און בעטן, גלויבט, אז איר האט עס באקומען, און עס וועט (אזוי) זיין צו אייך. ");
INSERT INTO ydd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","און ווען איר האט זיך אוועקגעשטעלט און זענט מתפלל, זאלט איר מוחל זיין, אויב איר האט עפעס קעגן וועמען; כדי אויך אייער פאטער אין הימל זאל אייך מוחל זיין אייערע עבירות. ");
INSERT INTO ydd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","אויב אבער איר וועט נישט מוחל זיין, וועט אייער פאטער אין הימל אייך אויך נישט פארגעבן אייערע עבירות. ");
INSERT INTO ydd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","און זיי קומען ווידער קיין ירושלים. און בשעת ער איז ארומגעגאנגען אין בית המקדש, קומען צו אים די הויפט כהנים, און די סופרים, און די זקנים; ");
INSERT INTO ydd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","און זאגן צו אים: מיט וואס פאר א רשות טוסטו די דאזיקע זאכן? אדער ווער האט דיר געגעבן דעם דאזיקן רשות, כדי דו זאלסט טאן די דאזיקע זאכן? ");
INSERT INTO ydd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","און יהושע/ישוע האט צו זיי געזאגט: איך וועל אייך פרעגן איין קשיא, און ענטפערט מיר, און איך וועל אייך זאגן, מיט וועלכן רשות איך טו די דאזיקע זאכן. ");
INSERT INTO ydd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","צי איז די מקווה פון יוחנן געווען מן השמים, אדער פון מענטשן? ענטפערט מיר! ");
INSERT INTO ydd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","און זיי האבן עס איבערגעלייגט צווישן זיך, אזוי צו זאגן: וועלן מיר זאגן: מן השמים, וועט ער זאגן: טא פארוואס האט איר אים נישט געגלויבט? ");
INSERT INTO ydd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","וועלן מיר אבער זאגן: פון מענטשן?—האבן זיי מורא געהאט פארן המון; ווארום אלע האבן געהאלטן, אז יוחנן איז ווירקלעך געווען א נביא. ");
INSERT INTO ydd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","און ענטפערנדיק זאגן זיי צו יהושען/ישוען: מיר ווייסן נישט! און יהושע/ישוע זאגט צו זיי; זאג איך אייך אויך נישט, מיט וואס פאר א רשות איך טו די דאזיקע זאכן! ");
INSERT INTO ydd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","און ער האט אנגעהויבן צו רעדן צו זיי אין משלים. א מענטש האט געפלאנצט א וויינגארטן, און אים ארומגערינגלט מיט א פלויט, און האט געגראבן א קעלטער, און געבויט א טורעם, און האט אים פארדונגען צו גערטנער, און איז אוועקגעפארן. ");
INSERT INTO ydd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","און צו דער רעכטער צייט האט ער געשיקט א קנעכט צו די גערטנער, אז ער זאל באקומען פון די גערטנער פון דער פרוכט פונם וויינגארטן. ");
INSERT INTO ydd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","און זיי האבן אים גענומען, און האבן אים געשלאגן, און אוועקגעשיקט מיט גארנישט. ");
INSERT INTO ydd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","און ער האט ווידער צו זיי געשיקט אן אנדערן קנעכט; און יענעם האבן זיי צעשלאגן דעם קאפ, און אנגעטאן חרפות. ");
INSERT INTO ydd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","נאך אן אנדערן האט ער געשיקט; און יענעם האבן זיי געטייט; און א סך אנדערע; א טייל פון זיי האבן זיי געשלאגן, און א טייל—געהרגעט. ");
INSERT INTO ydd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","נאך איינעם האט ער געהאט, א געליבטן זון; אים האט ער געשיקט צו לעצט צו זיי, אזוי צו זאגן: זיי וועלן זיך שעמען פאר מיין זון! ");
INSERT INTO ydd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","יענע גערטנער אבער האבן צווישן זיך געזאגט: דאס איז דער יורש; קומט, לאמיר אים טייטן, און די ירושה וועט זיין אונדזער! ");
INSERT INTO ydd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","און זיי האבן גענומען, און אים געטייט, און האבן אים ארויסגעווארפן פון וויינגארטן. ");
INSERT INTO ydd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","נו, וואס וועט דער האר פון דעם וויינגארטן טאן? ער וועט קומען און אומברענגען די גערטנער, און דעם וויינגארטן וועט ער געבן צו אנדערע. ");
INSERT INTO ydd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","צי האט איר דען נישט געלייענט דעם דאזיקן פסוק: דער שטיין, וועלכן די בוימייסטערס האבן פארווארפן, דער איז געווארן צום הויפט פונם ווינקל; ");
INSERT INTO ydd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","פונם האר (ה׳) איז דאס געשען, און עס איז א וואונדער אין אונדזערע אויגן? ");
INSERT INTO ydd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","און זיי האבן געזוכט אים צו כאפן; און האבן מורא געהאט פאר דעם המון מענטשן; ווארום מען האט געוואוסט, אז ער האט געזאגט דאס משל אויף זיי; און זיי האבן אים פארלאזט, און זענען אוועקגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","און זיי שיקן צו אים אייניקע פון די פרושים און פון הורדוס לייט, כדי זיי זאלן אים פאנגען מיט א ווארט. ");
INSERT INTO ydd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","און ווען זיי זענען געקומען, זאגן זיי צו אים: רבי, מיר ווייסן, אז דו ביסט ווארהאפטיק, און פרעגסט נישט אויף קיינעם; ווארום דו קוקסט נישט אויפן פנים פון מענטשן, נאר אויף אן אמת לערנסטו דעם וועג פון ה׳. צי מעג מען געבן מס צום קיסר, אדער נישט? זאלן מיר געבן אדער נישט געבן? ");
INSERT INTO ydd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ער האט אבער געוואוסט פון זייער צביעות, און האט צו זיי געזאגט: וואס פרואווט איר מיך אויס? ברענגט מיר א דינר, כדי איך זאל אים באקוקן. ");
INSERT INTO ydd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","און זיי האבן געברענגט. און ער זאגט צו זיי: וועמעס איז דאס דאזיקע בילד און די אויפשריפט? און זיי האבן צו אים געזאגט: דעם קיסרס! ");
INSERT INTO ydd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","און יהושע/ישוע האט צו זיי געזאגט: גיט זשע אפ דעם קיסר דאס, וואס איז דעם קיסרס, און צו ה׳ דאס, וואס איז ה׳ס! און זיי האבן זיך געוואונדערט אויף אים. ");
INSERT INTO ydd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","און עס קומען צו אים צדוקים, וועלכע זאגן, אז עס איז נישטא קיין תחית המתים; און האבן אים געפרעגט, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","רבי, משה האט אונדז געשריבן, אז אויב עמיצנס ברודער וועט שטארבן, און איבערלאזן א ווייב, און נישט איבערלאזן קיין קינד, אזוי זאל זיין ברודער נעמען די פרוי, און אויפשטעלן זאמען צו זיין ברודער. (דברים כה, ה.) ");
INSERT INTO ydd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","עס זענען געווען זיבן ברידער. און דער ערשטער האט גענומען א ווייב, און איז געשטארבן און האט נישט איבערגעלאזט קיין זאמען; ");
INSERT INTO ydd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","און דער צווייטער האט זי גענומען, און איז געשטארבן, נישט איבערלאזנדיק קיין זאמען; און דער דריטער אויך אזוי; ");
INSERT INTO ydd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","און די זיבן האבן נישט איבערגעלאזט קיין זאמען. צו לעצט נאך אלע איז אויך די פרוי געשטארבן. ");
INSERT INTO ydd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","אין דער תחית המתים, ווען זיי וועלן אויפשטיין, וועמעס ווייב פון זיי וועט זי זיין? ווארום אלע זיבן האבן זי דאך געהאט פאר א ווייב. ");
INSERT INTO ydd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","האט יהושע/ישוע צו זיי געזאגט: צי בלאנדזשעט איר דען נישט דערפאר, ווייל איר קענט נישט די כתבי (הקודש), און אויך נישט די קראפט פון ה׳? ");
INSERT INTO ydd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ווארום ווען זיי וועלן אויפשטיין פון די טויטע, וועלן זיי נישט חתונה האבן, נישט מען וועט זיי חתונה מאכן; נאר זיי זענען ווי די מלאכים אין הימל. ");
INSERT INTO ydd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","און וואס שייך די טויטע, אז זיי וועלן אויפשטיין, צי האט איר דען נישט געלייענט אין דעם ספר (תורת) משה, ביים סנה, ווי ה׳ האט צו אים גערעדט, אזוי צו זאגן: איך בין דער ג‑ט פון אברהם, און דער ג‑ט פון יצחק, און דער ג‑ט פון יעקב? (שמות ג, ז.) ");
INSERT INTO ydd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ער איז נישט דער ג‑ט פון די טויטע, נאר פון די לעבעדיקע: איר בלאנדזשעט זייער פיל. ");
INSERT INTO ydd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","און עס איז צוגעקומען איינער פון די סופרים, האבנדיק זיך צוגעהערט צו זייער וויכוח, ווייל ער האט געוואוסט, אז ער האט זיי וואויל געענטפערט, האט ער אים געפרעגט! וועלכעס איז דאס ערשטע געבאט פון אלע? ");
INSERT INTO ydd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","יהושע/ישוע האט געענטפערט: דאס ערשטע איז: שמע ישראל ה׳ אלהינו ה׳ אחד; ");
INSERT INTO ydd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","און דו זאלסט ליב האבן דעם האר דיין ג‑ט מיט דיין גאנץ הארץ, און מיט דיין גאנץ נפש, און מיט דיין גאנצן פארשטאנד, און מיט דיין גאנצער קראפט. (דברים ו, ד-ה.) ");
INSERT INTO ydd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","דאס צווייטע (געבאט) איז: דו זאלסט ליב האבן דיין חבר ווי דיך אליין. (ויקרא יט, יח.) קיין אנדער געבאט גרעסער ווי די דאזיקע איז נישט פאראן. ");
INSERT INTO ydd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","און דער סופר האט צו אים געזאגט: וואויל, רבי! דו האסט ווארהאפטיק געזאגט, אז ה׳ איז איינער; און עס איז נישט פאראן קיין אנדערער אחוץ אים; ");
INSERT INTO ydd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","און אים ליב צו האבן מיטן גאנצן הארצן, און מיטן גאנצן פארשטאנד, און מיט דער גאנצער קראפט, און ליב צו האבן דעם חבר ווי זיך אליין, איז א סך מער ווי אלע עולות און זבחים. ");
INSERT INTO ydd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","און יהושע/ישוע האט געזען, אז ער האט שכלדיק געענטפערט, האט ער צו אים געזאגט: דו ביסט נישט ווייט פון דעם קעניגרייך פון ה׳! און קיינער האט מער נישט זיך אונטערגעשטעלט אים צו שטעלן קשיות. ");
INSERT INTO ydd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","און יהושע/ישוע האט ענטפערנדיק געזאגט, בשעת ער האט געלערנט אינם בית המקדש: וויאזוי זאגן די סופרים, אז דער משיח איז דודס זון? ");
INSERT INTO ydd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","דוד (המלך) אליין האט דאך געזאגט דורך דעם רוח הקודש: דער האר האט געזאגט צו מיין האר: זיץ ביי מיין רעכטער זייט, ביז איך וועל אנידערלייגן דיינע פיינט פאר א פוסבענקעלע פאר דיינע פיס! ");
INSERT INTO ydd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","דוד אליין רופט אים האר, און פונוואנען איז ער זיין זון? און דער גרויסער עולם מענטשן האט זיך גערן צוגעהערט צו אים. ");
INSERT INTO ydd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","און אין זיין לערנונג האט ער געזאגט: היט זיך פאר די סופרים, וואס האבן ליב ארומצוגיין אין טליתים, און אז מען זאל זיי אפגעבן שלום אויף די מערקפלעצער, ");
INSERT INTO ydd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","און די הויפט זיץ‑ערטער אין די שולן, און ערטער אויבנאן אויף די סעודות; ");
INSERT INTO ydd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","זיי וואס שלינגען איין די הייזער פון אלמנות, און דאווענען כלומרשט לאנג: זיי וועלן באקומען א גרעסער משפט. ");
INSERT INTO ydd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","און ער האט זיך אנידערגעזעצט אנטקעגנאיבער דעם אוצר קאסטן, און זיך צוגעקוקט ווי דער המון מענטשן ווארפט אריין געלט אין דעם אוצר קאסטן אריין; און א סך רייכע לייט האבן אריינגעווארפן פיל. ");
INSERT INTO ydd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","און עס איז געקומען אן ארעמע אלמנה, און האט אריינגעווארפן צוויי פרוטות, דאס איז איין קוואדראנס, (די קלענסטע רוימישע מטבע.) ");
INSERT INTO ydd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","און ער האט צוגערופן זיינע תלמידים, און צו זיי געזאגט: באמת זאג איך אייך: די דאזיקע ארעמע אלמנה האט מער אריינגעווארפן ווי אלע, וואס האבן אריינגעווארפן אין דעם אוצר קאסטן אריין; ");
INSERT INTO ydd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ווארום אלע האבן אריינגעווארפן פון זייער שפע; זי אבער האט פון איר נויט אריינגעווארפן אלץ, וואס זי האט געהאט—איר גאנצע חיונה. ");
INSERT INTO ydd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","און ווען ער איז ארויסגעגאנגען פונם בית המקדש, זאגט איינער פון זיינע תלמידים צו אים: רבי, זע, וואס פאר א שטיינער און וואסערע בנינים! ");
INSERT INTO ydd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","און יהושע/ישוע האט צו אים געזאגט: דו זעסט די דאזיקע געוואלדיקע בנינים? עס וועט נישט איבערגעלאזט ווערן קיין שטיין אויף א שטיין, וואס וועט נישט צעבראכן ווערן! ");
INSERT INTO ydd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","און בעת ער איז געזעסן אויפן הר הזיתים, אנטקעגנאיבער דעם בית המקדש, האבן פעטרוס און יעקב און יוחנן און אנדריי אים געפרעגט, ווען זיי זענען געווען אליין: ");
INSERT INTO ydd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","זאג אונדז, ווען וועט דאס זיין? און וואס איז דאס צייכן, ווען דאס אלץ דארף דערפילט ווערן? ");
INSERT INTO ydd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","און יהושע/ישוע האט אנגעהויבן זאגן צו זיי: גיט אכטונג, אז קיינער זאל אייך נישט פארפירן. ");
INSERT INTO ydd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","א סך וועלן קומען אין מיין נאמען, און זאגן: איך בין עס, און וועלן א סך פארפירן. ");
INSERT INTO ydd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","און ווען איר וועט הערן וועגן מלחמות און שמועות פון מלחמות, זאלט איר זיך נישט דערשרעקן; דאס מוז געשען; נאר עס איז נאך נישט דער סוף. ");
INSERT INTO ydd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ווארום א פאלק וועט אויפשטיין קעגן א פאלק, און מלוכה קעגן מלוכה; עס וועלן זיין ערדציטערנישן דא און דארטן; עס וועלן זיין הונגערנויטן; די דאזיקע זענען דער אנהויב פון די ווייען. ");
INSERT INTO ydd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","איר אבער גיט אכטונג אויף זיך אליין! מען וועט אייך איבערגעבן צום סנהדרין; און מען וועט אייך געבן מלקות אין די שולן; און איר וועט געשטעלט ווערן פאר גובערנאטארן און מלכים צוליב מיר, פאר אן עדות צו זיי. ");
INSERT INTO ydd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","און צווישן אלע פעלקער מוז צום ערשט די גוטע בשורה אנגעזאגט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","און ווען מען וועט אייך פירן און איבערגעבן, זאלט איר זיך נישט מאכן קיין זארגן פארויס, וואס איר זאלט רעדן, נאר וואס עס וועט אייך געגעבן ווערן אין יענער שעה, דאס רעדט. ווארום נישט איר זענט עס, וואס רעדן, נאר דער רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","און א ברודער וועט איבערגעבן א ברודער צום טויט, און א פאטער א קינד; און קינדער וועלן אויפשטיין קעגן עלטערן, און וועלן זיי טייטן. ");
INSERT INTO ydd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","און איר וועט זיין פארהאסט פון אלעמען צוליב מיין נאמען; ווער אבער עס וועט אויסהאלטן ביז צום סוף, דער וועט געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","און ווען איר וועט זען די אומווירדיקייט פון דער פארוויסטונג שטיין וואו עס דארף נישט—זאל דער לייענער פארשטיין (דניאל יב, יא.)—דעמאלט זאלן די, וואס זענען אין יהודה, אנטלויפן צו די בערג; ");
INSERT INTO ydd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ווער עס איז אויפן דאך, דער זאל נישט אראפגיין, און נישט אריינגיין, עפעס נעמען פון זיין הויז ארויס; ");
INSERT INTO ydd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","און ווער עס איז אין פעלד, זאל זיך נישט אומקערן צוריק צו נעמען זיין מלבוש. ");
INSERT INTO ydd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","אבער וויי איז צו די טראגעדיקע און אנזויגערינס אין יענע טעג! ");
INSERT INTO ydd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","זייט אבער מתפלל, אז עס זאל נישט געשען אין ווינטער. ");
INSERT INTO ydd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ווארום יענע טעג וועלן זיין א צרה, אזא וואס אירסגלייכן איז נישט געשען זינט דעם אנהויב פון דער באשאפונג, וואס ה׳ האט באשאפן, ביז אצונד, און עס וועט מער נישט זיין. ");
INSERT INTO ydd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","און אויב דער האר וואלט נישט פארקירצט די טעג, וואלט קיין בשר (ודם) נישט געראטעוועט געווארן; נאר צוליב די אויסדערוויילטע, וועמען ער האט אויסדערוויילט, האט ער פארקירצט די טעג. (דניאל יב, א.) ");
INSERT INTO ydd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","און אויב עמיצער וועט אייך דעמאלט זאגן: זע דא איז דער משיח! זע, דארטן! זאלט איר עס נישט גלויבן; ");
INSERT INTO ydd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ווארום עס וועלן אויפשטיין פאלשע משיחים און פאלשע נביאים, און וועלן טאן נסים און וואונדער, כדי צו פארפירן, אויב מעגלעך, די אויסדערוויילטע. ");
INSERT INTO ydd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","איר אבער גיט אכטונג; זע, איך האב אייך אלץ פארויס אנגעזאגט! ");
INSERT INTO ydd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","נאר אין יענע טעג, נאך יענער צרה, וועט די זון פארפינסטערט ווערן, און די לבנה וועט נישט געבן איר ליכט, (ישעיהו יג, י.) ");
INSERT INTO ydd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","און די שטערן וועלן פאלן פון הימל, און די קרעפטן אין הימל וועלן דערשיטערט ווערן. (ישעיהו לד, ד.) ");
INSERT INTO ydd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","און דעמאלט וועט מען זען דעם בר אנש קומען אין די וואלקנס מיט גרויס מאכט און הערלעכקייט. (דניאל ז, יג-יד.) ");
INSERT INTO ydd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","און דעמאלט וועט ער שיקן די מלאכים, און איינזאמלען זיינע אויסדערוויילטע פון די פיר ווינטן, פון עק ערד ביז עק הימל. ");
INSERT INTO ydd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","און לערנט דאס משל פון דעם פייגנבוים; ווען זיין צווייג איז שוין זאפטיק, און ברענגט ארויס די בלעטער, ווייסט איר, אז זומער איז נאענט. ");
INSERT INTO ydd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","אזוי אויך איר, ווען איר וועט זען די דאזיקע זאכן געשען, זאלט איר וויסן, אז עס איז נאענט ביי די טירן. ");
INSERT INTO ydd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","באמת זאג איך אייך: דאס דאזיקע דור וועט נישט פארגיין, ביז אלע די דאזיקע זאכן וועלן געשען. ");
INSERT INTO ydd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","דער הימל און די ערד וועלן פארגיין, אבער מיינע ווערטער וועלן נישט פארגיין. ");
INSERT INTO ydd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","נאר וועגן יענעם טאג אדער שעה ווייסט קיינער נישט, נישט אפילו די מלאכים אין הימל, נישט דער זון (פון דער אויבערשטער), אחוץ דער פאטער. ");
INSERT INTO ydd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","גיט אכטונג, שלאפט נישט און טוט תפילה! ווארום איר ווייסט נישט ווען די צייט איז. ");
INSERT INTO ydd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ווי א מענטש, אוועקפארנדיק, האט פארלאזן זיין הויז, און געגעבן מאכט צו זיינע קנעכט, יעדן איינעם זיין ארבעט, און דעם טירוועכטער האט ער באפוילן, אז ער זאל וואכן. ");
INSERT INTO ydd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","דעריבער וואכט, ווארום איר ווייסט נישט ווען דער בעל הבית קומט, צי אין אוונט, אדער אינמיטן דער נאכט, אדער ווען דער האן קרייעט, אדער אין דער פרי; ");
INSERT INTO ydd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","טאמער וועט ער פלוצלונג קומען, און אייך געפינען שלאפנדיקע. ");
INSERT INTO ydd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","און וואס איך זאג אייך, זאג איך אלעמען: וואכט! ");
INSERT INTO ydd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","און אין צוויי טעג ארום איז געווען פסח און חג המצות; און די הויפט כהנים און סופרים האבן געזוכט וויאזוי אים צו כאפן מיט כיטרעקייט, ");
INSERT INTO ydd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","און אים צו טייטן. ווארום זיי האבן געזאגט: נישט יום טוב, טאמער וועט ווערן א מהומה צווישן פאלק! ");
INSERT INTO ydd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","און בשעת ער איז געווען אין בית‑היני אין דעם הויז פון שמעון דעם מצורע, זיצנדיק ביים טיש, איז געקומען א פרוי מיט אן אלאבאסטער פלאש פול מיט עכטער קאסטבארער נארד‑זאלב; און זי האט צעבראכן די אלאבאסטער פלאש, און אויסגעגאסן אויף זיין קאפ. ");
INSERT INTO ydd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","עס זענען אבער געווען אייניקע, וואס זענען געווארן צארנדיק צווישן זיך, (אזוי צו זאגן:) צו וואס איז די דאזיקע פארשווענדונג פון דעם זאלבאייל געמאכט געווארן? ");
INSERT INTO ydd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ווארום מען האט געקענט פארקויפן דעם דאזיקן זאלבאייל פאר מער ווי דריי הונדערט דינרים, און עס געבן צו די ארעמעלייט. און זיי האבן זיך אנגעבייזערט אויף איר. ");
INSERT INTO ydd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","יהושע/ישוע אבער האט געזאגט: לאזט זי צורו! וואס פארשאפט איר זי עגמת נפש? זי האט מיר געטאן א גוטע זאך. ");
INSERT INTO ydd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ווארום די ארעמעלייט האט איר תמיד ביי זיך, און ווען איר ווילט, קענט איר זיי טאן גוטס; מיך אבער האט איר נישט תמיד. ");
INSERT INTO ydd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","וואס זי האט געקענט, דאס האט זי געטאן; זי האט פארויס געזאלבט מיין גוף צו דער קבורה. ");
INSERT INTO ydd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","און באמת זאג איך אייך: וואו נאר די גוטע בשורה וועט אנגעזאגט ווערן אין דער גאנצער וועלט, וועט אויך דערציילט ווערן, וואס זי האט געטאן, לזכר פון איר. ");
INSERT INTO ydd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","און יהודה איש‑קריות, איינער פון די צוועלף, איז אוועקגעגאנגען צו די הויפט כהנים, כדי אים איבערצוגעבן צו זיי. ");
INSERT INTO ydd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","און ווען זיי האבן עס געהערט, האבן זיי זיך געפריידט, און אים צוגעזאגט צו געבן געלט. און ער האט געזוכט א גינסטיקע געלעגנהייט, אים צו פארראטן. ");
INSERT INTO ydd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","און דעם ערשטן טאג פון חג המצות, ווען מען האט געשחטן דאס קרבן פסח, זאגן צו אים זיינע תלמידים: וואו ווילסטו, זאלן מיר גיין און צוגרייטן, כדי דו זאלסט עסן דאס קרבן פסח? ");
INSERT INTO ydd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","און ער שיקט צוויי פון זיינע תלמידים, און זאגט צו זיי: גייט אין דער שטאט אריין, און עס וועט אייך באגעגענען א מענטש, טראגנדיק א קרוג מיט וואסער; אים זאלט איר נאכפאלגן; ");
INSERT INTO ydd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","און וואו נאר ער וועט אריינגיין, זאלט איר זאגן צום בעל הבית: דער רבי זאגט: וואו איז מיין גאסט שטוב, אין וועלכער איך זאל עסן דאס קרבן פסח מיט מיינע תלמידים? ");
INSERT INTO ydd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","און ער וועט אייך ווייזן א גרויסע אויבערע שטוב, אויסגעשטאט מיט הסבבעטן, פארטיק; און דארטן זאלט איר צוגרייטן פאר אונדז. ");
INSERT INTO ydd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","און די תלמידים זענען ארויסגעגאנגען, און זענען געקומען אין דער שטאט אריין, און האבן געפונען אזוי ווי ער האט זיי געזאגט; און זיי האבן צוגעגרייט דאס קרבן פסח. ");
INSERT INTO ydd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","און ווען עס איז געווארן אוונט, קומט ער מיט די צוועלף. ");
INSERT INTO ydd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","און בשעת זיי האבן זיך אנגעלענט און געגעסן, האט יהושע/ישוע געזאגט: באמת זאג איך אייך: איינער פון אייך וועט מיך פארראטן, דער, וואס עסט מיט מיר! (תהלים מא, ט.) ");
INSERT INTO ydd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","האבן זיי אנגעהויבן טרויעריק צו ווערן, און צו זאגן צו אים איינער נאכן אנדערן: דאך נישט איך? ");
INSERT INTO ydd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ער אבער האט צו זיי געזאגט: איינער פון די צוועלף, דער, וואס טונקט איין מיט מיר אין דער קערה. ");
INSERT INTO ydd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","דער בר אנש גייט טאקע לויט ווי עס שטייט געשריבן וועגן אים; וויי איז אבער צו יענעם מענטשן, דורך וועמען דער בר אנש ווערט פארראטן! עס וואלט געווען גוט פאר יענעם מענטשן, אויב ער וואלט נישט געבוירן געווארן! ");
INSERT INTO ydd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","און בשעת זיי האבן געגעסן, האט ער גענומען ברויט, געמאכט א ברכה, האט עס צעבראכן, און געגעבן צו זיי, און געזאגט: נעמט; דאס דאזיקע איז מיין גוף. ");
INSERT INTO ydd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","און ער האט גענומען א כוס, האט געמאכט א ברכה, און געגעבן צו זיי; און זיי האבן אלע געטרונקען דערפון. ");
INSERT INTO ydd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","און ער האט צו זיי געזאגט: דאס דאזיקע איז מיין בלוט פון דעם נייעם בונד, וואס ווערט פארגאסן פאר פילע. ");
INSERT INTO ydd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","באמת זאג איך אייך: איך וועל נישט מער טרינקען פון דער פרוכט פונם וויינשטאק, ביז צו יענעם טאג, ווען איך וועל עס טרינקען ניי אין דעם קעניגרייך פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","און ווען זיי האבן אפגעזונגען הלל, זענען זיי ארויסגעגאנגען צום הר הזיתים. ");
INSERT INTO ydd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","און יהושע/ישוע זאגט צו זיי: אלע וועט איר געשטרויכלט ווערן; ווייל עס שטייט געשריבן: איך וועל שלאגן דעם פאסטוך, און די שאף וועלן צעשפרייט ווערן. (זכריה יג, ז.) ");
INSERT INTO ydd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","נאר נאך מיין אויפשטיין, וועל איך אייך פארויסגיין קיין גליל. ");
INSERT INTO ydd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","פעטרוס אבער האט צו אים געזאגט: אפילו אויב אלע וועלן געשטרויכלט ווערן, וועל איך דאך נישט. ");
INSERT INTO ydd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","און יהושע/ישוע זאגט צו אים: באמת זאג איך דיר: היינט, אין דער דאזיקער נאכט, איידער דער האן וועט צוויימאל קרייען, וועסטו מיך דריימאל פארלייקענען! ");
INSERT INTO ydd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ער אבער האט נאך אייפריקער גערעדט: אויב איך זאל מוזן שטארבן צוזאמען מיט דיר, וועל איך דיך בשום אופן נישט פארלייקענען. און דעסגלייכן האבן אויך אלע געזאגט. ");
INSERT INTO ydd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","און זיי קומען צו א הויף, וואס האט געהייסן גת‑שמני; און ער זאגט צו זיינע תלמידים: זעצט זיך דא אנידער, ביז איך וועל האבן תפילה געטאן. ");
INSERT INTO ydd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","און ער נעמט פעטרוסן מיט זיך און יעקבן און יוחנן, און האט אנגעהויבן צו ציטערן און פלאטערן. ");
INSERT INTO ydd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","און ער זאגט צו זיי: מיין נפש איז זייער באטריבט, ביז צום טויט; בלייבט דא, און וואכט! ");
INSERT INTO ydd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","און ער איז געגאנגען אביסל ווייטער, און איז אנידערגעפאלן אויף דער ערד, און האט תפילה געטאן, אז, אויב מעגלעך, די שעה זאל אים פאראיבערגיין. ");
INSERT INTO ydd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","און האט געזאגט: אבא, פאטער, אלץ איז מעגלעך פאר דיר; נעם פון מיר אוועק דעם דאזיקן בעכער! דאך נישט וואס איך וויל, נאר וואס דו ווילסט. ");
INSERT INTO ydd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","און ער קומט, און געפינט זיי שלאפן, און זאגט צו פעטרוסן: שמעון, דו שלאפסט? ביסט נישט אימשטאנד געווען איין שעה וואך צו בלייבן? ");
INSERT INTO ydd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","וואכט און טוט תפילה, כדי איר זאלט נישט קומען צו קיין נסיון; דער גייסט איז טאקע וויליק, דאס פלייש איז אבער שוואך! ");
INSERT INTO ydd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","און ער איז ווידער אוועקגעגאנגען, און תפילה געטאן, זאגנדיק די זעלביקע ווערטער. ");
INSERT INTO ydd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","און ווען ער איז צוריקגעקומען, האט ער זיי ווידער געפונען שלאפן, ווארום זייערע אויגן זענען געווען שווער; און זיי האבן נישט געוואוסט וואס אים צו ענטפערן. ");
INSERT INTO ydd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","און ער קומט צום דריטן מאל, און זאגט צו זיי: שלאפט ווייטער, און רוט זיך אויס! עס איז גענוג; עס איז געקומען די שעה; זע, דער בר אנש ווערט איבערגעגעבן צו חוטאים אין די הענט אריין. ");
INSERT INTO ydd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","שטייט אויף, לאמיר גיין; זע, מיין פאררעטער איז שוין נאענט! ");
INSERT INTO ydd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","און גלייך, בשעת ער האט נאך גערעדט, קומט יהודה, איינער פון די צוועלף, און מיט אים א המון מיט שווערדן און שטאנגען, פון די הויפט כהנים און סופרים און זקנים. ");
INSERT INTO ydd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","און זיין פאררעטער האט זיי געגעבן א צייכן, אזוי צו זאגן: וועמען איך וועל א קוש טאן, דער איז עס; נעמט אים, און פירט אים אפ זיכער. ");
INSERT INTO ydd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","און ווען ער איז געקומען, איז ער גלייך צוגעגאנגען צו אים, און זאגט: רבי! און האט אים געקושט. ");
INSERT INTO ydd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","און זיי האבן ארויפגעלייגט די הענט אויף אים, און האבן אים געפאנגען גענומען. ");
INSERT INTO ydd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","איינער אבער פון די, וואס זענען געשטאנען דערביי האט ארויסגעצויגן די שווערד, און געשלאגן דעם כהן גדולס קנעכט, און אים אפגעהאקט אן אויער. ");
INSERT INTO ydd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","און יהושע/ישוע האט ענטפערנדיק צו זיי געזאגט: ווי קעגן א רויבער זענט איר ארויסגעקומען מיט שווערדן און שטאנגען מיך צו כאפן. ");
INSERT INTO ydd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","טאג אויס טאג איין בין איך געווען ביי אייך אינם בית המקדש און געלערנט, און איר האט מיך נישט געפאנגען גענומען; נאר (עס איז) כדי די כתבי (הקודש) זאלן דערפילט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","און אלע האבן אים פארלאזן, און זענען אנטלאפן. ");
INSERT INTO ydd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","און א יינגל איז אים נאכגעגאנגען, איינגעהילט אין א ליילעך אויפן בלויזן לייב, און זיי כאפן אים; ");
INSERT INTO ydd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ער אבער האט איבערגעלאזט דאס ליילעך, און איז אנטלאפן א נאקעטער. ");
INSERT INTO ydd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","און זיי האבן אוועקגעפירט יהושען/ישוען צום כהן גדול; און עס האבן זיך ביי אים פארזאמלט אלע הויפט כהנים און די זקנים און די סופרים. ");
INSERT INTO ydd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","און פעטרוס האט אים נאכגעפאלגט פונדערווייטנס, ביז אינעווייניק אריין אין דעם הויף פון דעם כהן גדול; און איז געזעסן מיט די משרתים און האט זיך געווארעמט ביים פייער. ");
INSERT INTO ydd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","און די הויפט כהנים און דאס גאנצע סנהדרין האבן געזוכט אן עדות זאגן קעגן יהושען/ישוען, כדי אים צו טייטן; און האבן נישט געפונען. ");
INSERT INTO ydd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ווארום א סך האבן פאלש עדות געזאגט קעגן אים, און זייערע עדות האבן נישט איבעראיינגעשטימט. ");
INSERT INTO ydd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","און אייניקע זענען אויפגעשטאנען, און האבן פאלש עדות געזאגט קעגן אים, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","מיר האבן אים געהערט זאגן: איך וועל צעשטערן דעם דאזיקן היכל, וואס איז מיט הענט געמאכט געווארן. און אין דריי טעג וועל איך אויפבויען אן אנדערן, וואס איז נישט געמאכט מיט הענט. ");
INSERT INTO ydd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","און אפילו אזוי האט זייער עדות זאגן נישט איבעראיינגעשטימט. ");
INSERT INTO ydd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","און דער כהן גדול האט זיך אויפגעשטעלט אין דער מיט, און געפרעגט יהושען/ישוען, אזוי צו זאגן: דו ענטפערסט גארנישט אויף דעם, וואס די דאזיקע זאגן עדות קעגן דיר? ");
INSERT INTO ydd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","און ער האט געשוויגן, און גארנישט געענטפערט. דער כהן גדול האט אים ווידער געפרעגט, און זאגט צו אים; ביסטו דער משיח, דער זון פון הקדוש ברוך הוא? ");
INSERT INTO ydd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","און יהושע/ישוע האט געזאגט: איך בין; און איר וועט זען דעם בר אנש זיצן אויף דער רעכטער זייט פון דער גבורה, און קומען מיט די וואלקנס פון הימל. (תהלים קי, א; דניאל ז, יג.) ");
INSERT INTO ydd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","און דער כהן גדול האט צעריסן זיינע קליידער, און זאגט: וואס דארפן מיר נאך האבן עדות? ");
INSERT INTO ydd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","איר האט דאך געהערט די לעסטערונג. וואס איז אייער מיינונג? און אלע האבן אים פארמשפט, אז ער איז חייב מיתה. ");
INSERT INTO ydd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","און אייניקע האבן אנגעהויבן צו שפייען אויף אים, און צו באדעקן אים דאס פנים, און צו שלאגן אים מיט די פויסטן, און צו זאגן צו אים: זאג נבואה! אויך די משרתים האבן אים עמפאנגען מיט פעטש. (ישעיהו נ, ו.) ");
INSERT INTO ydd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","און בשעת פעטרוס איז געווען אונטן אין הויף, קומט איינע פון דעם כהן גדולס דינסטמוידן; ");
INSERT INTO ydd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","און ווי זי האט דערזען פעטרוסן זיך ווארעמען, האט זי אויף אים א קוק געטאן, און זאגט: אויך דו ביסט געווען מיט דעם פון נצרת, דעם יהושע/ישוע! ");
INSERT INTO ydd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ער אבער האט געלייקנט, אזוי צו זאגן: נישט איך ווייס, נישט איך פארשטיי וואס דו זאגסט. און ער איז ארויסגעגאנגען אינדרויסן צום פאדערהויז; און א האן האט געקרייט. ");
INSERT INTO ydd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","און די דינסטמויד האט אים געזען, און האט ווידער אנגעהויבן צו זאגן צו די, וואס זענען דארט געשטאנען: דער דאזיקער איז איינער פון זיי! ");
INSERT INTO ydd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ער אבער האט נאכאמאל געלייקנט. און אביסל שפעטער האבן די, וואס זענען דארט געשטאנען, ווידער געזאגט צו פעטרוסן: דו ביסט זיכער איינער פון זיי; ווארום דו ביסט אויך א גלילי. ");
INSERT INTO ydd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","און ער האט אנגעהויבן צו פלוכן, און צו שווערן: איך קען נישט דעם דאזיקן מענטשן, פון וועמען איר רעדט! ");
INSERT INTO ydd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","און באלד האט א האן צום צווייטן מאל געקרייט. און פעטרוס האט זיך דערמאנט דאס ווארט, ווי יהושע/ישוע האט צו אים געזאגט: איידער א האן וועט צוויימאל קרייען, וועסטו מיך דריימאל פארלייקענען. און ער האט עס זיך גענומען צום הארצן, און זיך צעוויינט. ");
INSERT INTO ydd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","און באלד אינדערפרי האבן זיך די הויפט כהנים באראטן מיט די זקנים און סופרים, און דאס גאנצע סנהדרין—האבן געבונדן יהושען/ישוען, און אים אוועקגעפירט, און איבערגעגעבן צו פילאטוסן. (ישעיהו נג, ח.) ");
INSERT INTO ydd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","און פילאטוס האט אים געפרעגט: צי ביסט דו דער קעניג פון די יידן? און ער האט ענטפערנדיק צו אים געזאגט: דו זאגסט עס! ");
INSERT INTO ydd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","און די הויפט כהנים האבן געברענגט א סך באשולדיקונגען קעגן אים. ");
INSERT INTO ydd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","און פילאטוס האט אים ווידער געפרעגט, אזוי צו זאגן: דו ענטפערסט גארנישט? זע, וויפל באשולדיקונגען זיי מאכן קעגן דיר! ");
INSERT INTO ydd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","יהושע/ישוע אבער האט מער גארנישט געענטפערט; אזוי אז פילאטוס האט זיך געוואונדערט. (ישעיהו נג, ז.) ");
INSERT INTO ydd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","און אויף יעדן יום טוב פלעגט ער זיי באפרייען איין געפאנגענעם, וועמען זיי האבן באגערט. ");
INSERT INTO ydd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","און עס איז געווען איינער, וואס מען האט אים גערופן בר‑אבא, געבונדן צוזאמען מיט די בונטארן, וועלכע האבן אפגעטאן א רציחה בשעת אן אויפשטאנד. ");
INSERT INTO ydd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","און דער המון איז ארויפגעגאנגען און האט אנגעהויבן צו פארלאנגען, אז ער זאל טאן, ווי געווענלעך פאר זיי. ");
INSERT INTO ydd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","און פילאטוס האט זיי געענטפערט, אזוי צו זאגן: צי ווילט איר, אז איך זאל אייך באפרייען דעם קעניג פון די יידן? ");
INSERT INTO ydd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ווארום ער האט געוואוסט, אז די הויפט כהנים האבן אים איבערגעגעבן מחמת קנאה. ");
INSERT INTO ydd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","די הויפט כהנים אבער האבן אונטערגעהעצט דעם המון, אז ער זאל זיי ליבער באפרייען בר‑אבאן. ");
INSERT INTO ydd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","און פילאטוס האט ווידער ענטפערנדיק צו זיי געזאגט: וואס זשע זאל איך טאן מיט אים, וועמען איר רופט קעניג פון די יידן? ");
INSERT INTO ydd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","און זיי האבן נאכאמאל א געשריי געטאן: אויפהענגען אים אויף דער בוים! ");
INSERT INTO ydd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","און פילאטוס האט צו זיי געזאגט: וואס פאר א שלעכטס האט ער דען געטאן? זיי אבער האבן נאך מער געשריגן: אויפהענגען אים אויף דער בוים! ");
INSERT INTO ydd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","און ווייל פילאטוס האט געוואלט טאן די געפעליקייט דעם המון, האט ער פאר זיי באפרייט בר‑אבאן, און האט איבערגעגעבן יהושען/ישוען, נאך דעם ווי ער האט אים געלאזט שמייסן, און אים איבערגעגעבן אויפהענגען אויף א בוים צו ווערן. (ישעיהו נג, ה.) ");
INSERT INTO ydd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","און די זעלנער האבן אים אוועקגעפירט אינעווייניק אין הויף אריין, דאס איז דאס פרעטאריום; און רופן צונויף די גאנצע ראטע. ");
INSERT INTO ydd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","און זיי קליידן אים אָן אין פורפור, און טאן אים אָן א קרוין, וואס זיי האבן געפלאכטן פון דערנער; ");
INSERT INTO ydd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","און האבן אנגעהויבן אים צו באגריסן: שלום, קעניג פון די יידן! ");
INSERT INTO ydd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","און זיי האבן אים געשלאגן מיט א שטעקן איבערן קאפ, און געשפיגן אויף אים, און האבן געבויגן די קניען און זיך געבוקט צו אים. (ישעיהו נ, ו.) ");
INSERT INTO ydd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","און נאך דעם ווי זיי האבן אפגעשפאט פון אים, האבן זיי אים אויסגעטאן דאס פורפור, און אים אנגעטאן זיינע מלבושים. און זיי פירן אים ארויס, כדי אים צו אויפהענגען אויף דער בוים. ");
INSERT INTO ydd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","און זיי צווינגען א פארבייגייער, א געוויסן שמעון פון קירניה, קומענדיק פון פעלד, דעם פאטער פון אלעקסאנדער און רופוס, אז ער זאל טראגן זיין בוים. ");
INSERT INTO ydd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","און זיי ברענגען אים צו דעם ארט גלגלתא, וואס דער טייטש דערפון איז: דאס ארט פון א שארבן. ");
INSERT INTO ydd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","און זיי האבן אים געגעבן וויין געמישט מיט מירע, וואס ער האט אבער נישט אנגענומען. ");
INSERT INTO ydd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","און זיי האבן אים אויפגעהאנגען אויף א בוים, און צעטיילן צווישן זיך זיינע מלבושים, ווארפנדיק גורל אויף זיי, וואס ווער זאל נעמען. ");
INSERT INTO ydd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","און עס איז געווען די דריטע שעה, און זיי האבן אים אויפגעהאנגען אויף א בוים. (תהלים כב, יד-טז, יח.) ");
INSERT INTO ydd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","און דער כתב פון זיין באשולדיקונג איז געווען אויפגעשריבן: דער קעניג פון די יידן. ");
INSERT INTO ydd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","און צוזאמען מיט אים זיי אויפהענגען אויף דער בוים צוויי רויבער; איינעם אויף זיין רעכטער זייט, און איינעם אויף זיין לינקער זייט. ");
INSERT INTO ydd_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","און עס איז מקוים געווארן דער פסוק, וואס זאגט: און מיט פושעים איז ער פאררעכנט געווארן. ");
INSERT INTO ydd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","און די פארבייגייער האבן אים געלעסטערט, שאקלענדיק זייערע קעפ, און זאגנדיק: הא! דו, וואס צעשטערסט דעם היכל, און בויסט אים אויף אין דריי טעג, ");
INSERT INTO ydd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ראטעווע דיך אליין, און קום אראפ פונם בוים! ");
INSERT INTO ydd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","אזוי האבן אויך די הויפט כהנים אפגעשפאט צווישן זיך צוזאמען מיט די סופרים, און געזאגט: אנדערע האט ער געהאלפן, זיך אליין קען ער נישט העלפן. ");
INSERT INTO ydd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","דער משיח, דער קעניג פון ישראל! זאל ער איצט אראפשטייגן פון בוים, כדי מיר זאלן זען און גלויבן! אויך די, וואס זענען מיט אים אויפגעהאנגען אויף א בוים געווארן, האבן אים מבזה געווען. ");
INSERT INTO ydd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","און ווען די זעקסטע שעה איז געקומען, איז געווארן א פינצטערניש איבערן גאנצן לאנד ביז דער ניינטער שעה. ");
INSERT INTO ydd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","און אין דער ניינטער שעה האט יהושע/ישוע א געשריי געטאן מיט א הויך קול: אלהי אלהי למה שבקתני? פארטייטשט הייסט עס: ג‑ט מיינער, ג‑ט מיינער, פארוואס האסטו מיך פארלאזן? (תהלים כב, א.) ");
INSERT INTO ydd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","און אייניקע פון די, וואס זענען געשטאנען דערביי, האבן עס געהערט, און האבן געזאגט: זע, ער רופט אליהון. ");
INSERT INTO ydd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","און איינער איז געלאפן, און האט אנגעפילט א שוואם מיט עסיק, און זי ארויפגעזעצט אויף א שטעקן, און אים געגעבן צו טרינקען (תהלים סט, כב.), אזוי צו זאגן: לאזט; מיר וועלן זען אויב אליהו וועט קומען, כדי אים אראפצונעמען! ");
INSERT INTO ydd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","יהושע/ישוע אבער האט ארויסגעלאזט א הויך געשריי, און אפגעגעבן דעם גייסט. ");
INSERT INTO ydd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","און דאס פרוכת פון היכל האט זיך צעריסן אין צווייען, פון אויבן ביז אראפ. ");
INSERT INTO ydd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","און ווי דער אפיציר, וועלכער איז געשטאנען אנטקעגנאיבער אים, האט געזען, אז ער האט אָט אזוי אפגעגעבן דעם גייסט, האט ער געזאגט: דער דאזיקער מענטש איז באמת געווען ה׳ס זון! ");
INSERT INTO ydd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","און עס זענען אויך געווען פרויען, וואס האבן זיך צוגעקוקט פונדערווייטנס, צווישן זיי מרים פון מגדלה, און מרים, די מוטער פון יעקב הקטן און פון יוסי, און שלומית; ");
INSERT INTO ydd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","וועלכע האבן אים נאכגעפאלגט, ווען ער איז נאך געווען אין גליל, און האבן אים באדינט; און א סך אנדערע פרויען, וואס זענען ארויפגעגאנגען מיט אים קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","און ווען עס איז שוין געווארן אוונט, ווייל עס איז געווען ערב שבת, דאס הייסט א טאג פאר שבת, ");
INSERT INTO ydd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","איז געקומען יוסף הרמתי, אן אנגעזעענער יועץ, וואס האט אליין אויך געהאפט אויף ה׳ס קעניגרייך, און האט זיך אונטערגעשטעלט אריינצוגיין צו פילאטוסן, און געבעטן ישועס גוף. ");
INSERT INTO ydd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","פילאטוס אבער האט זיך געוואונדערט, אז ער איז שוין געשטארבן; און האט גערופן צו זיך דעם אפיציר, און אים געפרעגט, צי ער איז שוין לאנג טויט. ");
INSERT INTO ydd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","און דערוויסנדיק זיך פונם אפיציר, האט ער יוספן געשענקט דעם גוף. ");
INSERT INTO ydd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","און ער האט געקויפט א ליילעך, האט אים אראפגענומען, און אים איינגעוויקלט אין דעם ליילעך, און אריינגעלייגט אין א קבר, וואס איז געווען אויסגעהאקט אין א פעלדזן; און האט ארויפגעקייקלט א שטיין אויף דעם אריינגאנג צום קבר. (ישעיהו נג, ט.) ");
INSERT INTO ydd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","און מרים פון מגדלה און מרים, יוסיס מוטער, האבן געזען וואו ער איז געלייגט געווארן. ");
INSERT INTO ydd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","און ווען עס איז געווארן אויס שבת, האבן מרים פון מגדלה, און מרים, די מוטער פון יעקב, און שלומית געקויפט געווירצן, כדי זיי זאלן אהינגיין אים צו זאלבן. ");
INSERT INTO ydd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","און זייער פרי דעם ערשטן טאג פון דער וואך, קומען זיי צום קבר, ווען די זון איז אויפגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","און האבן געזאגט איינע צו דער אנדערער: ווער וועט אראפקייקלען פאר אונדז דעם שטיין פון דעם אריינגאנג צום קבר? ");
INSERT INTO ydd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","און ווי זיי האבן א בליק געטאן, האבן זיי געזען, אז דער שטיין איז אוועקגעקייקלט; ווארום ער איז געווען זייער גרויס. ");
INSERT INTO ydd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","און ווען זיי זענען אריינגעגאנגען אין קבר אריין, האבן זיי געזען א בחור זיצן אויף דער רעכטער זייט, אנגעטאן אין א ווייס קלייד, און זיי האבן זיך שטארק דערשראקן. ");
INSERT INTO ydd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","און ער זאגט צו זיי: שרעקט זיך נישט! איר זוכט יהושען/ישוען פון נצרת, דעם וואס איז אויפגעהאנגען אויף א בוים געווארן; ער איז אויפגעשטאנען; ער איז דא נישטא; אָט איז דאס ארט, וואו מען האט אים געלייגט! (תהלים טז, י.) ");
INSERT INTO ydd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","נאר גייט, זאגט זיינע תלמידים און פעטרוסן, אז ער גייט פארויס פאר אייך קיין גליל; דארט וועט איר אים זען, לויט ווי ער האט אייך געזאגט. ");
INSERT INTO ydd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","און זיי זענען ארויסגעגאנגען, און זענען אנטלאפן פון קבר; ווארום עס האט זיי אנגעכאפט א ציטערניש און זיי זענען געווען אויסער זיך; און זיי האבן קיינעם גארנישט געזאגט; ווייל זיי האבן מורא געהאט. ");
INSERT INTO ydd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","און ווען ער איז אויפגעשטאנען אינדערפרי דעם ערשטן טאג פון דער וואך, האט ער זיך צום ערשט באוויזן צו מרים פון מגדלה, פון וועמען ער האט ארויסגעטריבן זיבן בייזע גייסטער. ");
INSERT INTO ydd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","זי איז געגאנגען און האט עס דערציילט צו די, וואס זענען געווען מיט אים, וואס האבן געטרויערט און געוויינט. ");
INSERT INTO ydd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","און ווען זיי האבן געהערט, אז ער לעבט און איז פון איר געזען געווארן, האבן זיי עס נישט געגלויבט. ");
INSERT INTO ydd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","נאך דעם האט ער זיך באוויזן אין אן אנדער געשטאלט צו צוויי פון זיי, בשעת זיי זענען געגאנגען אין פעלד אריין. ");
INSERT INTO ydd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","און זיי זענען אוועקגעגאנגען און האבן עס דערציילט צו די איבריקע; אבער אויך יענע האבן זיי נישט געגלויבט. ");
INSERT INTO ydd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","דערנאך האט ער זיך באוויזן צו די עלף אליין, בשעת זיי זענען געזעסן ביים טיש, און האט זיי פארגעווארפן זייער אומגלויבן און הארטקייט פון הארצן, ווייל זיי האבן נישט געגלויבט די, וואס האבן אים געזען אן אויפגעשטאנענעם. ");
INSERT INTO ydd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","און ער האט צו זיי געזאגט: גייט אין דער גאנצער וועלט, זאגט אָן די גוטע בשורה צו דער גאנצער באשאפונג. ");
INSERT INTO ydd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ווער עס גלויבט און לאזט זיך טובל זיין אין א מקווה, דער וועט געראטעוועט ווערן; ווער אבער עס וועט נישט גלויבן, דער וועט פארמשפט ווערן. ");
INSERT INTO ydd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","און די דאזיקע צייכנס וועלן באגלייטן די, וואס גלויבן יא: אין מיין נאמען וועלן זיי ארויסטרייבן בייזע גייסטער; זיי וועלן רעדן מיט נייע לשונות; ");
INSERT INTO ydd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","מיט די הענט וועלן זיי אויפהויבן שלאנגען, און אויב זיי וועלן טרינקען סם, וועט עס זיי בשום אופן נישט שאטן; אויף קראנקע וועלן זיי ארויפלייגן די הענט, און זיי וועלן גענעזן ווערן. ");
INSERT INTO ydd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","און אזוי, נאך דעם ווי דער האר יהושע/ישוע האט צו זיי גערעדט, איז ער ארויפגענומען געווארן אין הימל אריין, און האט זיך אנידערגעזעצט אויף ה׳ס רעכטער זייט. (תהלים קי, א.) ");
INSERT INTO ydd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","און זיי זענען ארויסגעגאנגען, און האבן אויסגערופן (די גוטע בשורה) אומעטום, און דער האר האט מיטגעווירקט מיט זיי, באשטעטיקנדיק דאס ווארט דורך די צייכנס, וואס האבן נאכגעפאלגט. אמן.");
INSERT INTO ydd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ווייל א סך האבן אונטערגענומען צוזאמענצושטעלן א געשיכטע פון די פאקטן, וואס זענען פארגעקומען צווישן אונדז, ");
INSERT INTO ydd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","אזוי ווי עס האבן זיי אונדז איבערגעגעבן די, וואס האבן זיי אליין געזען פון אנהויב אָן און זענען געווען דינער פונם ווארט, ");
INSERT INTO ydd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","איז עס מיר אויך וואוילגעפעלן, האבנדיק אלץ גרינטלעך אויסגעפארשט אויפסניי, צו שרייבן צו דיר לויט א סדר, אָ נאבעלער טעאפילוס, ");
INSERT INTO ydd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","כדי דו זאלסט זיך דערוויסן די זיכערקייט פון די זאכן, וועלכע דו ביסט געלערנט געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","עס איז געווען אין די טעג פון הורדוס, קעניג פון יהודה, א געוויסער כהן, וואס האט געהייסן זכריה, פון דעם משמר פון אביה; און ער האט געהאט א ווייב פון די טעכטער פון אהרן, און זי האט געהייסן אלישבע. ");
INSERT INTO ydd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","און ביידע זענען זיי געווען צדיקים פאר ה׳, און האבן געלעבט אין אלע מצוות און חוקים פון דעם האר (ה׳) אָן א פעלער. ");
INSERT INTO ydd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","און זיי האבן נישט געהאט קיין קינד, ווייל אלישבע איז געווען אן עקרה, און ביידע האבן שוין געהאט דערגרייכט א טיפע עלטער. ");
INSERT INTO ydd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","און עס איז געשען, בשעת ער האט אפגעריכט די עבודה פאר ה׳ לויט דעם סדר פון זיין משמר, ");
INSERT INTO ydd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","איז אויסגעפאלן דער גורל, לויט דעם מנהג פון דער כהונה, אז ער זאל אריינגיין רויכערן קטורת אינם היכל פון דעם האר (ה׳), ");
INSERT INTO ydd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","און דער גאנצער המון עם האט מתפלל געווען אינדרויסן אין דער שעה פון קטורת. ");
INSERT INTO ydd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","און א מלאך פון דעם האר (ה׳) האט זיך באוויזן צו אים, שטייענדיק אויף דער רעכטער זייט פונם מזבח הקטורת. ");
INSERT INTO ydd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","און זכריה האט אים געזען, און האט זיך דערשראקן, און א מורא איז געפאלן אויף אים. ");
INSERT INTO ydd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","דער מלאך אבער האט צו אים געזאגט: פארכט דיך נישט, זכריה; ווייל דיין תפילה איז דערהערט געווארן, און אלישבע, דיין ווייב, וועט דיר געבוירן א זון, און דו זאלסט רופן זיין נאמען יוחנן. ");
INSERT INTO ydd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","און ער וועט זיין פאר דיר א פרייד און א שמחה, און א סך וועלן זיך פרייען איבער זיין געבורט. ");
INSERT INTO ydd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ווארום ער וועט זיין גרויס פאר דעם האר (ה׳), און וויין און שארפע געטראנקען וועט ער נישט טרינקען, און שוין פון זיין מוטערס לייב אָן וועט ער זיין פול מיט דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","און א סך פון די קינדער ישראל וועט ער צוריקפירן צום האר, דעם ג‑ט זייערן. ");
INSERT INTO ydd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","און ער וועט פארויסגיין פאר אים אינם גייסט און אין דער מאכט פון אליהו, צוריק צו קערן די הערצער פון די פאטערס צו די קינדער און די ווידערשפעניקע—צו דער פארשטענדיקייט פון צדיקים, צו שאפן א צוגעגרייט פאלק פאר דעם האר (ה׳). (מלאכי ד, ה-ו; ישעיהו מ, ג.) ");
INSERT INTO ydd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","און זכריה האט געזאגט צו דעם מלאך; לויט וואס וועל איך דאס דאזיקע דערקענען? ווארום איך בין א זקן און מיין ווייב איז אויך שוין אין אירע עלטערע יארן. ");
INSERT INTO ydd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","און דער מלאך האט ענטפערנדיק צו אים געזאגט: איך בין גבריאל (דניאל ח, טז; ט, כא.), וואס שטייט פאר ה׳, און בין געשיקט געווארן צו רעדן צו דיר און דיר אנצוזאגן די גוטע בשורה פון די דאזיקע זאכן. ");
INSERT INTO ydd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","און זע, דו וועסט זיין שטום און נישט קענען רעדן ביז צום טאג ווען די דאזיקע זאכן וועלן געשען, ווייל דו האסט נישט געגלויבט מיינע ווערטער, וועלכע וועלן דערפילט ווערן אין זייער צייט. ");
INSERT INTO ydd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","און דאס פאלק האט געווארט אויף זכריהן, און האט זיך געוואונדערט וואס ער זוימט זיך אינם היכל, ");
INSERT INTO ydd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","און ווען ער איז ארויסגעקומען האט ער נישט געקענט רעדן צו זיי; און זיי האבן פארשטאנען, אז ער האט געזען א חזיון אינם היכל; און ער האט זיך פארשטענדיקט מיט זיי דורך צייכנס, און איז פארבלייבן שטום. ");
INSERT INTO ydd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","און עס איז געשען, ווען די טעג פון זיין אפריכטן די עבודה זענען דערפילט געווארן, איז ער אהיים געגאנגען. ");
INSERT INTO ydd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","און נאך די דאזיקע טעג איז אלישבע, זיין ווייב, טראגעדיק געווארן, און זי האט זיך פארבארגן פינף חדשים, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","אזוי האט דער האר (ג‑ט) מיר געטאן אין די טעג ווען ער האט אויף מיר געקוקט אוועקצונעמען מיין חרפה צווישן מענטשן. ");
INSERT INTO ydd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","און אין דעם זעקסטן חודש איז דער מלאך גבריאל געשיקט געווארן פון ה׳ קיין גליל אין א שטאט אריין וואס האט געהייסן נצרת, ");
INSERT INTO ydd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","צו א יונגפרוי בתולה וואס איז געווען פארקנסט צו א מאן מיט דעם נאמען יוסף, אויס דעם בית דוד; און די יונגפרוי בתולה האט געהייסן מרים. ");
INSERT INTO ydd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","און אריינקומענדיק צו איר האט ער געזאגט: שלום דיר, דו מיט גנאד באשענקטע, דער האר (ה׳) איז מיט דיר. ");
INSERT INTO ydd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","זי האט זיך אבער דערשראקן איבער דעם ווארט, און האט זיך געטראכט, וואס זאל די דאזיקע באגריסונג באטייטן? ");
INSERT INTO ydd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","און דער מלאך האט צו איר געזאגט: פארכט דיך נישט, מרים; ווארום דו האסט געפונען חן ביי ה׳, ");
INSERT INTO ydd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","און זע, דו וועסט מעוברת ווערן און געבוירן א זון, און דו זאלסט רופן זיין נאמען יהושע/ישוע, ");
INSERT INTO ydd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ער וועט זיין גרויס, און וועט גערופן ווערן זון פון דעם אויבערשטער; און דער האר ג‑ט וועט אים געבן דעם טראן פון זיין פאטער דוד; ");
INSERT INTO ydd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","און ער וועט קעניגן איבער דעם הויז פון יעקב אויף אייביק, און זיין מלכות וועט נישט האבן קיין סוף. (ישעיהו ט, ו-ז.) ");
INSERT INTO ydd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","און מרים האט געזאגט צום מלאך: וויאזוי וועט דאס דאזיקע זיין, איך קען דאך נישט קיין מאן? ");
INSERT INTO ydd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","און דער מלאך האט ענטפערנדיק געזאגט צו איר: דער רוח הקודש וועט קומען איבער דיר, און דעם אויבערשטנס גבורה וועט דיך באשאטן; דערפאר וועט דאס געבוירענע (קינד) אויך גערופן ווערן הייליק, זון פון דעם אויבערשטער. (ישעיהו ז, יד.) ");
INSERT INTO ydd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","און זע, אלישבע, די קרובה דיינע, אויך זי איז טראגעדיק מיט א זון אויף איר עלטער, און זי, וועמען מען האט גערופן עקרה, איז שוין אין זעקסטן חודש; ");
INSERT INTO ydd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ווייל קיין זאך איז נישט אוממעגלעך פאר ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","און מרים האט געזאגט: זע, איך בין די דינסטמויד פון דעם האר (ג‑ט); זאל מיר געשען לויט דיין ווארט. און דער מלאך איז אוועקגעגאנגען פון איר. ");
INSERT INTO ydd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","און מרים איז אויפגעשטאנען אין די דאזיקע טעג און איז אייליק אוועקגעגאנגען צום בארגלאנד, צו א שטאט אין יהודה; ");
INSERT INTO ydd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","און איז אריינגעגאנגען אין זכריהס הויז און האט אפגעגעבן שלום אלישבען. ");
INSERT INTO ydd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","און עס איז געשען, ווי אלישבע האט געהערט מרימס באגריסונג, האט דאס קינד א שפרונג געטאן אין איר לייב; און אלישבע איז פול געווארן מיט דעם רוח הקודש, ");
INSERT INTO ydd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","און האט אויפגעהויבן איר קול מיט א הויך געשריי, און געזאגט: געבענטשט ביסטו צווישן פרויען, און געבענטשט איז די פרוכט פון דיין לייב. ");
INSERT INTO ydd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","און פארוואס איז דאס דאזיקע מיר געשען, אז די מוטער פון מיין האר זאל קומען צו מיר? ");
INSERT INTO ydd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ווארום זע, ווי דאס קול פון דיין באגריסונג איז געקומען אין מיינע אויערן אריין, האט דאס קינד א שפרונג געטאן מיט שמחה אין מיין לייב. ");
INSERT INTO ydd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","און אז וואויל איז איר וואס האט געגלויבט, אז עס וועט זיין א דערפילונג צו דעם, וואס איז איר געזאגט געווארן פונם האר (ה׳). ");
INSERT INTO ydd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","און מרים האט געזאגט: ");
INSERT INTO ydd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","עס טוט דערהייבן מיין זעל דעם האר, און עס פריידט זיך מיין גייסט אין ה׳, מיין דערלייזער, ");
INSERT INTO ydd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ווייל ער האט געבליקט אויף דער נידעריקייט פון זיין דינסטמויד; ווארום זע, פון איצט אָן וועלן מיך רופן געבענטשטע אלע דורות, ");
INSERT INTO ydd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ווייל גרויסע זאכן האט מיר געטאן דער מעכטיקער, און הייליק איז זיין נאמען; ");
INSERT INTO ydd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","און זיין בארעמהארציקייט איז פון דור צו דור צו די, וואס פארכטן זיך פאר אים. ");
INSERT INTO ydd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","מאכט האט ער באוויזן מיט זיין ארעם, צעשפרייט האט ער די שטאלצע אין דער מחשבה פון זייער הארץ. ");
INSERT INTO ydd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","פון טראנען האט ער אראפגעזעצט מעכטיקע, און נידריקע האט ער דערהייבט; ");
INSERT INTO ydd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","הונגריקע האט ער אנגעפילט מיט אלעם גוטן, און רייכע אוועקגעשיקט מיט גארנישט. ");
INSERT INTO ydd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","געהאלפן האט ער זיין קנעכט ישראל, געדענקענדיק זיין רחמנות, ");
INSERT INTO ydd_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","אזוי ווי ער האט גערעדט צו אונדזערע אבות, צו אברהם און זיין זאמען אויף אייביק. ");
INSERT INTO ydd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","און מרים איז געבליבן ביי איר אן ערך דריי חדשים, און האט זיך אומגעקערט אהיים. ");
INSERT INTO ydd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","פאר אלישבען אבער האט זיך דערפילט די צייט פון איר קימפעט, און זי האט געבוירן א זון. ");
INSERT INTO ydd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","און אירע שכנים און קרובים האבן געהערט, אז דער האר (ה׳) האט איר ארויסגעוויזן גרויס חסד, און האבן זיך געפריידט מיט איר. ");
INSERT INTO ydd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","און עס איז געשען, דעם אכטן טאג איז מען געקומען מל זיין דאס קינד, און מען האט אים א נאמען געגעבן נאך זיין פאטער זכריה. ");
INSERT INTO ydd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","און זיין מוטער האט ענטפערנדיק געזאגט: ניין; נאר ער זאל הייסן יוחנן. ");
INSERT INTO ydd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","און זיי האבן צו איר געזאגט: אין דיין משפחה איז דאך נישטא קיינער, וואס האט דעם דאזיקן נאמען! ");
INSERT INTO ydd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","און זיי האבן געוואונקען צו זיין פאטער, ווי וואלט ער געוואלט אים א נאמען געבן. ");
INSERT INTO ydd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","און ער האט געבעטן א שרייב טעוועלע און האט אויפגעשריבן, אזוי צו זאגן; זיין נאמען איז יוחנן! און אלע האבן זיך געוואונדערט. ");
INSERT INTO ydd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","און אין אן אויגנבליק האבן זיך זיין מויל און צונג געעפנט; און ער האט גערעדט, לויבנדיק ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","און א מורא איז געקומען אויף אלע זייערע שכנים, און אין דעם גאנצן בארגלאנד פון יהודה האט מען גערעדט פון אלע די דאזיקע זאכן. ");
INSERT INTO ydd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","און אלע, וואס האבן דאס געהערט, האבן עס זיך גענומען צום הארצן, אזוי צו זאגן: וואס וועט דאס דאזיקע קינד זיין? ווארום אויך די האנט פון דעם האר (ה׳) איז געווען מיט אים. ");
INSERT INTO ydd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","און זכריה, זיין פאטער, איז פול געווארן מיט דעם רוח הקודש און האט נבואות געזאגט, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","געלויבט זאל זיין דער האר, דער ג‑ט פון ישראל. ווייל ער האט השגחה געהאט און געשאפן א ישועה פאר זיין פאלק, ");
INSERT INTO ydd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","און אויפגעשטעלט א הארן פון גאולה פאר אונדזערטוועגן אין דעם הויז פון דוד זיין קנעכט, ");
INSERT INTO ydd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","לויט ווי ער האט גערעדט דורך דעם מויל פון זיינע הייליקע נביאים. פון אייביק אָן, ");
INSERT INTO ydd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","א רעטונג פון אונדזערע שונאים און אויס דער האנט פון אלע, וואס האסן אונדז; ");
INSERT INTO ydd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","צו טאן חסד מיט אונדזערע אבות, און צו געדענקען זיין הייליקן בונד; ");
INSERT INTO ydd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","די שבועה, וואס ער האט געשוואוירן צו אונדזער פאטער אברהם; ");
INSERT INTO ydd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","אונדז צו געבן, זייענדיק באפרייט אויס דער האנט פון אונדזערע שונאים, מיר זאלן אים דינען אָן מורא, ");
INSERT INTO ydd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","אין קדושה און גערעכטיקייט פאר אים אלע אונדזערע טעג. ");
INSERT INTO ydd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","און דו, קינד, וועסט גערופן ווערן: נביא פון דעם אויבערשטער, ווארום דו וועסט גיין פארויס פאר דעם האר צוצוגרייטן זיינע וועגן, (ישעיהו מ, ג.) ");
INSERT INTO ydd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","כדי צו געבן זיין פאלק דערקענטעניש פון ישועה דורך דער פארגעבונג פון זייערע זינד, ");
INSERT INTO ydd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","דורך דער הערצלעכער דערבארמונג פון אונדזער ג‑ט, דורך וועלכן א זונאויפגאנג פון אויבן וועט קומען צו אונדז, ");
INSERT INTO ydd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","זיי צו געבן ליכט וואס זיצן אין פינצטערניש און אין שאטן פון טויט, צו פירן אונדזערע פיס אינם וועג פון שלום. ");
INSERT INTO ydd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","און דאס קינד איז געוואקסן און איז שטארק געווארן אינם גייסט, און איז געווען אין מדבריות ביז צום טאג פון זיין באווייזן זיך צו ישראל. ");
INSERT INTO ydd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","און עס איז געשען אין יענע טעג, א דעקרעט איז ארויסגעגאנגען פון קיסר אויגוסטוס, אז די גאנצע וועלט זאל זיך רעגיסטרירן. ");
INSERT INTO ydd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","דאס איז די ערשטע רעגיסטרירונג, וואס איז געמאכט געווארן בשעת קירעניוס איז געווען העגמון פון סיריען. ");
INSERT INTO ydd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","און אלע זענען געגאנגען זיך רעגיסטרירן, יעדער איינער אין זיין אייגענער שטאט אריין. ");
INSERT INTO ydd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","און יוסף איז אויך ארויפגעגאנגען פון גליל, אויס דער שטאט נצרת, קיין יהודה, אין דער שטאט פון דוד, וועלכע הייסט בית‑לחם, ווייל ער איז געווען פון דעם הויז און משפחה פון דוד (המלך); ");
INSERT INTO ydd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","אז ער זאל זיך לאזן רעגיסטרירן צוזאמען מיט מרים, וואס איז געווען פארקנסט צו אים, און איז געווען מעוברת. ");
INSERT INTO ydd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","און עס איז געשען, בשעת זיי זענען דארט געווען, דאס די טעג פון איר קימפעט זענען דערפילט געווארן, ");
INSERT INTO ydd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","און זי האט געבוירן איר זון, דעם בכור, און האט אים איינגעוויקלט אין ווינדעלעך און אריינגעלייגט אין א מולטער, צוליב דעם וואס עס איז נישט געווען קיין ארט פאר זיי אין דער אכסניה. ");
INSERT INTO ydd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","און אין דער זעלביקער געגנט זענען געווען פאסטוכער, וואס האבן זיך אויפגעהאלטן אויפן פעלד און געהאלטן וואך איבער זייער סטאדע ביינאכט. ");
INSERT INTO ydd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","און א מלאך פונם האר (ה׳) האט זיך אוועקגעשטעלט ביי זיי און דער כבוד פון האר (ה׳) האט זיי ארומגעלויכטן, און זיי האבן זיך געפארכטן מיט א גרויסער פורכט. ");
INSERT INTO ydd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","און דער מלאך האט צו זיי געזאגט: פארכט זיך נישט! ווארום זע, איך זאג אייך אָן א גוטע בשורה פון גרויסער פרייד, וועלכע איז פארן גאנצן פאלק; ");
INSERT INTO ydd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","אז אייך איז היינט געבוירן געווארן א גואל, וועלכער איז משיח, דער האר, אין דער שטאט פון דוד. (מיכה ה, א.) ");
INSERT INTO ydd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","און דאס דאזיקע איז פאר אייך א צייכן: איר וועט געפינען א קליין קינד איינגעוויקלט אין ווינדלען און ליגנדיק אין א מולטער. ");
INSERT INTO ydd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","און פלוצלונג איז געווען אינאיינעם מיט דעם מלאך א מחנה פון הימלישע חיל וואס האבן געלויבט ה׳ און געזאגט: ");
INSERT INTO ydd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","כבוד צו ה׳ אין די הויכקייטן, און אויף דער ערד שלום צווישן מענטשן אין וועמען ער האט א וואוילגעפעלן! ");
INSERT INTO ydd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","און עס איז געשען, ווי די מלאכים זענען פון זיי אוועק אין הימל אריין, האבן די פאסטוכער געזאגט איינער צום אנדערן: לאמיר איצט גיין קיין בית‑לחם, און זען די דאזיקע זאך, וואס איז געשען, וועלכע דער האר (ה׳) האט אונדז צו וויסן געטאן. ");
INSERT INTO ydd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","און זיי זענען געגאנגען איילנדיק און האבן געפונען מרים און יוספן, און דאס קליינע קינד ליגנדיק אין דער מולטער. ");
INSERT INTO ydd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","און ווען זיי האבן עס געזען האבן זיי באקאנט געמאכט דאס ווארט, וואס איז צו זיי גערעדט געווארן וועגן דעם דאזיקן קינד. ");
INSERT INTO ydd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","און אלע, וואס האבן דאס געהערט, האבן זיך געוואונדערט איבער דעם, וואס איז געזאגט געווארן פון די פאסטוכער. ");
INSERT INTO ydd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","מרים אבער האט אפגעהיטן אלע די דאזיקע רייד און האט נאכגעטראכט איבער זיי אין איר הארץ. ");
INSERT INTO ydd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","און די פאסטוכער האבן זיך אומגעקערט אפגעבנדיק כבוד צו ה׳ און לויבנדיק אים פאר אלעם, וואס זיי האבן געהערט און געזען, אזוי ווי עס איז צו זיי גערעדט געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","און ווען אכט טעג זענען דערפילט געווארן, אז מען זאל אים מל זיין, האט מען אים א נאמען געגעבן יהושע/ישוע, ווי ער איז גערופן געווארן פון דעם מלאך איידער ער איז געשאפן געווארן אינם מוטערלייב. ");
INSERT INTO ydd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","און ווען די טעג זענען דערפילט געווארן פון זייער רייניקונג לויט תורת משה, האבן זיי אים ארויפגעברענגט קיין ירושלים, כדי אים אוועקצושטעלן פאר דעם האר (ה׳) (ויקרא יב, א-ח.) ");
INSERT INTO ydd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","אזוי ווי עס שטייט געשריבן אין דער תורה פון דעם האר (ה׳): יעדער זכר, וואס עפנט די מוטערטראכט, זאל גערופן ווערן הייליק צום האר (ה׳); (שמות יג, א-ב.) ");
INSERT INTO ydd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","און צו ברענגען א קרבן לויט ווי עס איז געזאגט געווארן אין דער תורה פונם האר (ה׳): א *פאר טערקל‑טויבן אדער צוויי יונגע טויבן. ");
INSERT INTO ydd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","און זע, עס איז געווען א מענטש אין ירושלים, וועלכער האט געהייסן שמעון, און דער דאזיקער איז געווען אן איש צדיק און א ג‑טספארכטיקער מענטש, און האט געהאפט אויף דער נחמה פון ישראל; און דער רוח הקודש האט גערוט אויף אים. ");
INSERT INTO ydd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","און עס איז אים אנטפלעקט געווארן דורך דעם רוח הקודש, אז ער וועט נישט זען דעם טויט איידער ער וועט זען דעם משיח פון דעם האר ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","און ער איז געקומען דורך דעם גייסט אין בית המקדש אריין! און בשעת די עלטערן האבן אריינגעברענגט דאס קינד יהושע/ישוע, כדי צו טאן מיט אים לויט דעם מנהג פון דער תורה, ");
INSERT INTO ydd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","האט ער (שמעון) עס גענומען אויף זיינע ארעמס און געלויבט ה׳ און געזאגט: ");
INSERT INTO ydd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","איצט, אָ, האר, לאזטו דיין קנעכט גיין, לויט דיין ווארט, בשלום, ");
INSERT INTO ydd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ווייל געזען האבן מיינע אויגן דיין רעטונג, ");
INSERT INTO ydd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","וואס דו האסט צוגעגרייט פאר אלע פעלקער, ");
INSERT INTO ydd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","א ליכט צו דער באלויכטונג פון די אומות (העולם) און א הערלעכקייט פאר דיין פאלק ישראל. ");
INSERT INTO ydd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","און זיין פאטער און מוטער האבן זיך געוואונדערט איבער דעם, וואס איז געזאגט געווארן וועגן אים; ");
INSERT INTO ydd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","און שמעון האט זיי געבענטשט און געזאגט צו מרים, זיין מוטער: זע, ער איז באשטימט צום פאלן און אויפשטיין פון א סך אין ישראל, און אלס א צייכן, וואס וועט ווידערגעשפראכן ווערן; (ישעיהו ח, יד-טו.) ");
INSERT INTO ydd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","און אויך דיין אייגענער זעל וועט דורכדרינגען א שווערד; כדי די מחשבות פון א סך הערצער זאלן אנטפלעקט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","און עס איז געווען א נביאה, חנה בת פנואל, פונם שבט אשר. זי האט שוין געהאט דערגרייכט א זייער טיפע עלטער, האבנדיק געלעבט מיט א מאן זיבן יאר פון איר יונגפרוישאפט אָן, ");
INSERT INTO ydd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","און איז געווען אן אלמנה ביז צו פיר און אכציק יאר, וואס האט נישט פארלאזט דאס בית המקדש, און האט געדינט ה׳ מיט תעניתים און תפילות בייטאג און ביינאכט. ");
INSERT INTO ydd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","אויך זי איז געקומען אין דער זעלביקער שעה, האט געלויבט ה׳, און גערעדט וועגן אים צו אלע, וואס האבן געהאפט אויף דער אויסלייזונג פון ירושלים. ");
INSERT INTO ydd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","און ווי זיי האבן אלץ מקיים געווען לויט דער תורה פונם האר (ה׳), האבן זיי זיך אומגעקערט קיין גליל, אין זייער אייגענער שטאט נצרת. ");
INSERT INTO ydd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","און דאס קינד איז געוואקסן און איז געווארן שטארק, ווערנדיק פול מיט חכמה, און ה׳ס חן איז געווען אויף אים. ");
INSERT INTO ydd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","און זיינע עלטערן פלעגן עולה רגל זיין יעדעס יאר קיין ירושלים אויף יום טוב פסח. ");
INSERT INTO ydd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","און ווען ער איז אלט געווארן צוועלף יאר זענען זיי ארויפגעגאנגען לויט דעם מנהג פונם יום טוב; ");
INSERT INTO ydd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","און ווען די טעג האבן זיך געענדיקט און זיי האבן זיך אומגעקערט (אהיים), איז דאס יינגל יהושע/ישוע איבערגעבליבן אין ירושלים, און זיינע עלטערן האבן עס נישט געוואוסט; ");
INSERT INTO ydd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","נאר מיינענדיק, אז ער איז מיט די עולי רגל, זענען זיי געגאנגען א טאג רייזע און האבן אים געזוכט צווישן די קרובים און באקאנטע. ");
INSERT INTO ydd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","און (אזוי ווי) זיי האבן אים נישט געפונען, האבן זיי זיך אומגעקערט קיין ירושלים און אים געזוכט. ");
INSERT INTO ydd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","און עס איז געשען, אין דריי טעג ארום האבן זיי אים געפונען אין בית המקדש זיצנדיק אין דער מיט צווישן די תנאים, און ער האט זיך צוגעהערט צו זיי און זיי געשטעלט קשיות; ");
INSERT INTO ydd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","און אלע, וואס האבן אים געהערט, האבן געשטוינט איבער זיין שכל און זיינע תשובות. ");
INSERT INTO ydd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","און ווען זיי האבן אים דערזען, זענען זיי געווארן אויסער זיך, און זיין מוטער האט צו אים געזאגט; קינד, פארוואס האסטו אונדז אזוי געטאן? זע, דיין פאטער און איך האבן דיך געזוכט מיט אנגסט. ");
INSERT INTO ydd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","און ער האט צו זיי געזאגט; פארוואס האט איר מיך געזוכט? צי האט איר דען נישט געוואוסט, אז איך מוז זיין אין מיין פאטערס הויז? ");
INSERT INTO ydd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","און זיי האבן נישט משיג געווען דאס ווארט, וואס ער האט צו זיי גערעדט. ");
INSERT INTO ydd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","און ער איז אראפגעגאנגען מיט זיי און איז געקומען קיין נצרת און געווען אונטערטעניק צו זיי; און די מוטער זיינע האט אפגעהיטן די אלע ווערטער אין איר הארץ. ");
INSERT INTO ydd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","און יהושע/ישוע איז געוואקסן אין דער חכמה און אין קערפערלעכן געשטאלט, און אין חן ביי ה׳ און ביי לייטן. ");
INSERT INTO ydd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","און אין דעם פופצענטן יאר פון דער הערשאפט פון קיסר טיבעריוס, בעת פאנטיוס פילאטוס איז געווען גובערנאטאר פון יהודה, און הורדוס איז געווען טעטרארך פון גליל, און פיליפוס, זיין ברודער, איז געווען טעטרארך פון איטורעא און פון דער געגנט טראכאניטיס, און ליזיאנוס איז געווען טעטרארך פון אבילענע, ");
INSERT INTO ydd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ווען חנן און קיפא זענען געווען כהנים גדולים, איז ה׳ס ווארט געקומען צו יוחנן בן זכריה אין דער מדבר. ");
INSERT INTO ydd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","און ער איז געקומען אין דער גאנצער אומגעגנט פון ירדן און האט אויסגערופן א מקווה פון תשובה צו דער פארגעבונג פון זינד, ");
INSERT INTO ydd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","אזוי ווי עס שטייט געשריבן אינם ספר פון די ווערטער פון ישעיה הנביא: א קול פון איינעם וואס שרייט אין דער מדבר: גרייט צו דעם וועג פון דעם האר (ה׳), מאכט גלייך זיינע שטעגן. ");
INSERT INTO ydd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","יעדער טאל זאל אנגעפילט ווערן און יעדער בארג און יעדעס בערגל זאלן דערנידעריקט ווערן, און די קרומע (ערטער) זאלן אויסגעגלייכט ווערן און די נישט גלייכע צו גלאטע וועגן; ");
INSERT INTO ydd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","און זאל יעדער בשר (ודם) זען די ישועה פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","און ער האט געזאגט צו די המונים מענטשן, וואס זענען ארויסגעקומען געטובלט צו ווערן אין דער מקווה פון אים: איר שפראץ פון שלאנגען, ווער האט אייך געגעבן צו פארשטיין צו אנטלויפן פון דעם קומענדיקן צארן? ");
INSERT INTO ydd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ברענגט דעריבער פירות, (וואס זענען) ווירדיק פון תשובה, און הויבט נישט אָן זיך איינצורעדן: מיר האבן אברהם אלס אונדזער פאטער; ווארום איך זאג אייך, אז ה׳ איז בכוח אויס די דאזיקע שטיינער אויפצושטעלן קינדער צו אברהמען. ");
INSERT INTO ydd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","און די האק ליגט אויך שוין ביים ווארצל פון די ביימער; דעריבער יעדער איינער בוים, וואס ברענגט נישט קיין גוטע פירות, ווערט אפגעהאקט און געווארפן אין פייער אריין. ");
INSERT INTO ydd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","און די מאסן מענטשן האבן אים געפרעגט, אזוי צו זאגן: וואס זשע זאלן מיר טאן? ");
INSERT INTO ydd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","און ער האט ענטפערנדיק צו זיי געזאגט: ווער עס האט צוויי העמדער, דער זאל זיך טיילן מיט דעם, וואס האט גארנישט; און דער, וואס האט שפייז, זאל אויך אזוי טאן! ");
INSERT INTO ydd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","און אויך שטייער אויפמאנער זענען געקומען צו לאזן זיך טובל זיין אין דער מקווה און האבן געזאגט צו אים: רבי, וואס זאלן מיר טאן? ");
INSERT INTO ydd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","האט ער צו זיי געזאגט: פאדערט נישט מער ווי עס איז אייך באשטימט געווארן! ");
INSERT INTO ydd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","און אויך זעלנער האבן אים געפרעגט, אזוי צו זאגן: און מיר, וואס זאלן מיר טאן? און ער האט צו זיי געזאגט: באדריקט קיינעם נישט, ברענגט נישט קיין מסירות אויף קיינעם, און באגענוגענט אייך מיט אייער געהאלט. ");
INSERT INTO ydd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","און אזוי ווי דאס פאלק איז געווען אין דערווארטונג, און אלע האבן זיך געפרעגט אין זייערע הערצער וועגן יוחנן, צי איז ער אליין נישט אפשר דער משיח, ");
INSERT INTO ydd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","האט יוחנן געענטפערט זאגנדיק צו אלעמען: איך טובל אייך טאקע מיט וואסער אין א מקווה, עס קומט אבער א שטארקערער פון מיר; וועמען איך בין נישט ווערט אויפצובינדן דאס שנירל פון זיינע שיך; ער וועט אייך טובל זיין אין א מקווה מיט דעם רוח הקודש און מיט פייער; ");
INSERT INTO ydd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","זיין ווינטשויפל איז אין זיין האנט, אויסצורייניקן זיין דרעשעריי און איינצוזאמלען דעם ווייץ אין שייער אריין, די פלעווע אבער וועט ער פארברענען מיט פייער, וואס לעשט זיך נישט אויס. ");
INSERT INTO ydd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","און נאך מיט א סך אנדערע אזהרות האט ער אנגעזאגט די גוטע בשורה צום פאלק. ");
INSERT INTO ydd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","הורדוס אבער, דער טעטרארך, ווערנדיק געמוסרט פון אים וועגן הורודיה, זיין ברודערס ווייב, און וועגן אלע מעשים רעים, וואס הורדוס האט געטאן, ");
INSERT INTO ydd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","האט ער צו דעם אלעם צוגעלייגט אויך דאס דאזיקע, וואס ער האט יוחנן פארשלאסן אין געפענקעניש. ");
INSERT INTO ydd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","און עס איז געשען, בשעת דאס גאנצע פאלק האט זיך געלאזט טובל זיין אין דער מקווה און יהושע/ישוע איז אויך געטובלט געווארן אין דער מקווה און האט תפילה געטאן, האט זיך דער הימל געעפנט, ");
INSERT INTO ydd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","און דער רוח הקודש איז אראפגעקומען אויף אים אין א קערפערלעך געשטאלט, ווי א טויב; און עס איז געקומען א קול פון הימל; דו ביסט מיין געליבטער זון, אין דיר האב איך א וואוילגעפעלן! ");
INSERT INTO ydd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","און יהושע/ישוע אליין איז אלט געווען ביי דרייסיק יאר ווען ער האט אנגעהויבן (זיין עבודה); און איז געווען, ווי מען האט געמיינט, דער זון פון יוסף בן עלי, ");
INSERT INTO ydd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","בן מתת, בן לוי, בן מלכי, בן יני, בן יוסף, ");
INSERT INTO ydd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","בן מתתיהו, בן עמוס, בן נחום, בן חסלי, בן נגי, ");
INSERT INTO ydd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","בן מחת, בן מתתיהו, בן שמעי, בן יוסף, בן יודה, ");
INSERT INTO ydd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","בן יוחנן, בן רישא, בן זרובבל, בן שאלתיאל, בן נרי, ");
INSERT INTO ydd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","בן מלכי, בן אדי, בן קוסם, בן אלמודם, בן ער, ");
INSERT INTO ydd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","בן יהושע/ישוע, בן אליעזר, בן יורים, בן מתת, בן לוי, ");
INSERT INTO ydd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","בן שמעון, בן יהודה, בן יוסף, בן יונם, בן אליקים, ");
INSERT INTO ydd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","בן מליא, בן מינא, בן מתתה, בן נתן, בן דוד, ");
INSERT INTO ydd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","בן ישי, בן עובד, בן בועז, בן שלמון, בן נחשון, ");
INSERT INTO ydd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","בן עמינדב, בן אדמין, בן ארני, בן חצרון, בן פרץ, בן יהודה, ");
INSERT INTO ydd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","בן יעקב, בן יצחק, בן אברהם, בן תרח, בן נחור, ");
INSERT INTO ydd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","בן שרוג, בן רעו, בן פלג, בן עבר, בן שלח, ");
INSERT INTO ydd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","בן קינן, בן ארפכשד, בן שם, בן נוח, בן למך, ");
INSERT INTO ydd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","בן מתושלח, בן חנוך, בן ירד, בן מהללאל, בן קינן, ");
INSERT INTO ydd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","בן אנוש, בן שת, בן אדם, בן אלקים. ");
INSERT INTO ydd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","און יהושע/ישוע, פול מיט דעם רוח הקודש, האט זיך אומגעקערט פונם ירדן, און איז געפירט געווארן פון דעם גייסט אין דער מדבר ");
INSERT INTO ydd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","פערציק טעג לאנג און איז אויסגעפרואווט געווארן פון שׂטן. און ער האט גארנישט געגעסן אין יענע טעג; און ווען זיי האבן זיך געענדיקט איז ער הונגעריק געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","און דער שׂטן האט צו אים געזאגט: אויב דו ביסט דער זון פון דער אויבערשטער, זאג צו דעם דאזיקן שטיין, אז ער זאל ווערן ברויט! ");
INSERT INTO ydd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","און יהושע/ישוע האט אים געענטפערט: עס שטייט געשריבן: נישט מיט ברויט אליין וועט דער מענטש לעבן! ");
INSERT INTO ydd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","האט ער אים ארויפגעפירט אויף א הויכן בארג און אים געוויזן אלע קעניגרייכן פון דער וועלט אין אן אויגנבליק. ");
INSERT INTO ydd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","און דער שׂטן האט צו אים געזאגט: דיר וועל איך געבן די דאזיקע גאנצע מאכט און זייער הערלעכקייט; ווייל זי איז מיר איבערגעגעבן געווארן, און איך גיב זי, צו וועמען איך וויל. ");
INSERT INTO ydd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","דעריבער אויב דו וועסט זיך בוקן פאר מיר, וועט אלץ זיין דיין. ");
INSERT INTO ydd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","און יהושע/ישוע האט ענטפערנדיק צו אים געזאגט: עס שטייט געשריבן: צום האר דיין ג‑ט זאלסטו זיך בוקן, און נאר אים אליין זאלסטו דינען. ");
INSERT INTO ydd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ער אבער האט אים אוועקגעפירט קיין ירושלים און אים געשטעלט אויפן שפיץ טורם פון בית המקדש, און געזאגט צו אים: אויב דו ביסט דער זון פון דער אויבערשטער, ווארף דיך פונדאנען אראפ; ");
INSERT INTO ydd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ווארום עס שטייט געשריבן: זיינע מלאכים וועט ער באפעלן וועגן דיר, דיך אפצוהיטן; ");
INSERT INTO ydd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","אויף די הענט וועלן זיי דיך טראגן, אז דו זאלסט דיר נישט צעקלאפן דיין פוס אין א שטיין. ");
INSERT INTO ydd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","און יהושע/ישוע האט אים ענטפערנדיק געזאגט: עס איז געזאגט געווארן: דו זאלסט נישט אויספרואוון דעם האר דיין ג‑ט. ");
INSERT INTO ydd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","און ווען דער שׂטן האט געענדיקט אלע אויספרווואונגען איז ער אוועק פון אים ביז אויף א צייט. ");
INSERT INTO ydd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","און יהושע/ישוע האט זיך אומגעקערט אין דער קראפט פונם גייסט קיין גליל; און א קלאנג איז ארויסגעגאנגען וועגן אים אין דער גאנצער אומגעגנט. ");
INSERT INTO ydd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","און ער האט געלערנט אין זייערע שולן, און אלע האבן אים אפגעגעבן כבוד. ");
INSERT INTO ydd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","און ער איז געקומען קיין נצרת, וואו ער איז דערצויגן געווארן; און לויט זיין געוואוינהייט איז ער שבת אריינגעגאנגען אין שול און האט זיך אויפגעשטעלט צו לייענען. ");
INSERT INTO ydd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","און מען האט אים געגעבן דאס ספר פון דעם נביא ישעיה. און אויפעפנענדיק דאס בוך האט ער געפונען דאס ארט, וואו עס איז געווען געשריבן: ");
INSERT INTO ydd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","דער גייסט פונם האר (ה׳) איז אויף מיר, ווייל ער האט מיך געזאלבט, כדי אנצוזאגן א גוטע בשורה צו ארעמעלייט; ער האט מיך געשיקט אויסצורופן באפרייאונג צו געפאנגענע, און צו בלינדע—ווידער צו קענען זען, די אונטערגעדריקטע ארויסצושיקן פריי, ");
INSERT INTO ydd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","אויסצורופן א שנת רצון פון דעם האר (ה׳). ");
INSERT INTO ydd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","און ער האט צונויפגעוויקלט דאס ספר, האט עס אוועקגעגעבן דעם חזן און זיך אנידערגעזעצט; און אלעמענס אויגן אין שול זענען געווען גענייגט מיט שפאנונג אויף אים. ");
INSERT INTO ydd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","און ער האט אנגעהויבן צו זאגן צו זיי: היינט איז די דאזיקע שריפט מקוים געווארן אין אייערע אויערן. ");
INSERT INTO ydd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","און אלע האבן עדות געזאגט אויף אים און האבן זיך געוואונדערט איבער די ליבלעכע ווערטער, וואס זענען ארויסגעקומען פון זיין מויל; און האבן געזאגט: צי איז דען דאס נישט יוספס זון? ");
INSERT INTO ydd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","און ער האט צו זיי געזאגט: זיכער וועט איר מיר זאגן דאס דאזיקע שפריכווארט: רופא, הייל דיך אליין! אלץ, וואס מיר האבן געהערט, אז עס איז געשען אין כפר‑נחום, טו אויך דא אין דיין פאטערשטאט! ");
INSERT INTO ydd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ער אבער האט געזאגט: באמת זאג איך אייך: קיין נביא איז נישט אנגענומען אין זיין פאטערשטאט. ");
INSERT INTO ydd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","אויף אן אמת זאג איך אייך: א סך אלמנות זענען געווען אין ישראל אין די טעג פון אליהו (הנביא), ווען דער הימל איז געווען פארשלאסן אויף דריי יאר און זעקס חדשים, און עס איז געווארן א גרויסער הונגער איבערן גאנצן לאנד; ");
INSERT INTO ydd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","און צו קיין איינער פון זיי איז אליהו נישט געשיקט געווארן, אחוץ קיין צרפת אין צידון צו א פרוי אן אלמנה. (מלכים א יז, א.) ");
INSERT INTO ydd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","און א סך מצורעים זענען געווען אין ישראל אין דער צייט פונם נביא אלישע; און קיין איינער פון זיי איז נישט גערייניקט געווארן, אחוץ נעמן דער סיריער. (מלכים ב ה, א-יד.) ");
INSERT INTO ydd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","און אלע אין שול זענען פול געווארן מיט צארן, הערנדיק די דאזיקע זאכן; ");
INSERT INTO ydd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","און האבן זיך אויפגעהויבן און אים ארויסגעווארפן אויסער דער שטאט, און אים אוועקגעפירט ביז צום שפיץ פון דעם בארג, אויף וועלכן זייער שטאט איז געווען געבויט, כדי אים אראפצושטירצן. ");
INSERT INTO ydd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ער אבער, דורכגייענדיק דורך זייער מיט, איז זיך אוועק אויף זיין וועג. ");
INSERT INTO ydd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","און ער איז אראפגעגאנגען קיין כפר‑נחום, א שטאט אין גליל; און אין די שבתים פלעגט ער זיי לערנען; ");
INSERT INTO ydd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","און מען פלעגט שטוינען איבער זיין תורה, ווייל זיין ווארט איז געווען מיט מאכט. ");
INSERT INTO ydd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","און אין דער שול איז געווען א מענטש, וואס האט געהאט אן אומריינעם בייזן גייסט, און ער האט א געשריי געטאן מיט א הויך קול: ");
INSERT INTO ydd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","וויי, וואס האבן מיר מיט דיר, יהושע/ישוע פון נצרת? ביסטו געקומען אונדז צו פארטיליקן? איך ווייס ווער דו ביסט—דער קדוש אלקים (הייליקער פון ה׳). ");
INSERT INTO ydd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","און יהושע/ישוע האט אויף אים אנגעשריגן, אזוי צו זאגן: שווייג און גיי ארויס פון אים! און דער בייזער גייסט האט אים א ווארף געטאן ביז אין דער מיט, איז ארויס פון אים און האט אים גארנישט געשעדיקט. ");
INSERT INTO ydd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","און אויף אלעמען איז אנגעפאלן א מורא, און זיי האבן גערעדט איינער מיטן אנדערן, אזוי צו זאגן: וואס פאר א ווארט איז דאס, אז מיט מאכט און מיט כוח באפעלט ער די אומריינע גייסטער, און זיי גייען ארויס! ");
INSERT INTO ydd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","און דער קלאנג וועגן אים האט זיך פארשפרייט אויף יעדן ארט אין דער געגנט ארום. ");
INSERT INTO ydd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","און ער איז אויפגעשטאנען און איז ארויסגעגאנגען פון שול אין שמעונס הויז אריין. שמעונס שוויגער אבער האט געליטן פון א שטארק פיבער, און זיי האבן אים געבעטן פאר אירעטוועגן. ");
INSERT INTO ydd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","און ער האט זיך אנידערגעשטעלט איבער איר און האט אנגעשריגן דאס פיבער, און עס האט זי פארלאזט; און אין אן אויגנבליק איז זי אויפגעשטאנען און האט זיי באדינט. ");
INSERT INTO ydd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","און ווען די זון איז אונטערגעגאנגען, האבן אלע, וואס האבן געהאט קראנקע מיט פארשיידענע שלאפקייטן, זיי געברענגט צו אים; און ער האט ארויפגעלייגט די הענט אויף יעדן איינעם פון זיי און זיי געהיילט. ");
INSERT INTO ydd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","און עס זענען אויך ארויסגעגאנגען בייזע גייסטער פון פילע, שרייענדיק און זאגנדיק: דו ביסט דער זון פון דער אויבערשטער! און ער האט אנגעשריגן אויף זיי און האט זיי נישט געלאזט רעדן, ווייל זיי האבן געוואוסט, אז ער איז דער משיח. ");
INSERT INTO ydd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","און ווען עס איז געווארן טאג איז ער ארויסגעגאנגען און איז געקומען צו אן איינזאם ארט; און די המונים מענטשן האבן אים אויפגעזוכט און זענען געקומען צו אים, און האבן אים צוריקגעהאלטן, אז ער זאל נישט אוועק פון זיי. ");
INSERT INTO ydd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ער אבער האט צו זיי געזאגט: אויך אין די אנדערע שטעט מוז איך אנזאגן די גוטע בשורה פון דעם קעניגרייך פון ה׳; ווייל דערצו בין איך געשיקט געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","און ער פלעגט דרשענען אין די שולן פון יהודה. ");
INSERT INTO ydd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","און עס איז געשען, בעת דער המון מענטשן האט זיך געדרענגט צו אים, כדי צו הערן ה׳ס ווארט, און ער איז געשטאנען ביים ים גניסרת; ");
INSERT INTO ydd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","האט ער געזען צוויי שיפלעך ליגן ביים ים ברעג, און די פישער זענען אויסגעשטיגן פון זיי און האבן געוואשן די נעצן. ");
INSERT INTO ydd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","איז ער איינגעשטיגן אין איינס פון די שיפלעך, וועלכעס האט געהערט שמעונען, און האט אים געבעטן אוועקצופארן אביסל פון דער יבשה; און האט זיך אנידערגעזעצט און געלערנט די המונים מענטשן אויס דעם שיפל ארויס. ");
INSERT INTO ydd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","און ווען ער האט אויפגעהערט צו רעדן, האט ער געזאגט צו שמעונען; פאָר אריבער צו דער טיפעניש און לאזט אראפ אייערע נעצן צום פאנג! ");
INSERT INTO ydd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","און ענטפערנדיק האט שמעון געזאגט: האר, דורך דער גאנצער נאכט האבן מיר געפראצעוועט, און גארנישט געכאפט; נאר אויף דיין ווארט וועל איך אראפלאזן די נעצן. ");
INSERT INTO ydd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","און ווען זיי האבן דאס דאזיקע געטאן, האבן זיי געכאפט א גרויסע מענגע פיש; זייערע נעצן אבער האבן זיך צעריסן. ");
INSERT INTO ydd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","און זיי האבן געמאכט צייכנס צו זייערע חברים אין דעם אנדערן שיפל, אז זיי זאלן קומען זיי העלפן; און זיי זענען געקומען און האבן אנגעפילט ביידע שיפלעך ביז צום זינקען. ");
INSERT INTO ydd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","און זעענדיק דאס, איז שמעון פעטרוס אנידערגעפאלן אויף די קני פאר יהושען/ישוען, זאגנדיק: האר, גיי אוועק פון מיר, ווייל איך בין א זינדיקער מענטש! ");
INSERT INTO ydd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ווארום עס האט אים אנגעכאפט א שרעק און אלע, וואס זענען געווען מיט אים איבער דעם פישפאנג, וואס זיי האבן געפאנגען, ");
INSERT INTO ydd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","און אויך אזוי יעקבן און יוחנן, זבדיס זין, וואס זענען געווען שמעונס חברים. און יהושע/ישוע האט געזאגט צו שמעונען: האב נישט קיין מורא; פון איצט אָן וועסטו פאנגען מענטשן. ");
INSERT INTO ydd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","און ברענגענדיק די שיפלעך צו דער יבשה, האבן זיי אלץ פארלאזט און אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","און עס איז געשען, בעת ער איז געווען אין איינער פון די שטעט, זע, עס איז געווען א מאן פול צרעת; און ווי ער האט געזען יהושען/ישוען, איז ער אנידערגעפאלן אויפן פנים, האט אים געבעטן און געזאגט: האר, אויב דו זאלסט וועלן, קענסטו מיך מאכן ריין! ");
INSERT INTO ydd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","און ער האט אויסגעשטרעקט די האנט, האט אים אנגערירט און געזאגט: איך וויל, זיי ריין! און גלייך איז די צרעת פון אים אוועק. ");
INSERT INTO ydd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","און ער האט אים באפוילן, עס קיינעמען נישט אויסצוזאגן, נאר גיי, ווייז דיך צום כהן, און זיי מקריב פאר דיין רייניקונג, אזוי ווי משה האט געבאטן, פאר אן עדות צו זיי! (ויקרא יד, א-לב.) ");
INSERT INTO ydd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","אבער דער באריכט וועגן אים האט זיך נאכמער פארשפרייט, און גרויסע מאסן מענטשן זענען זיך צוזאמענגעקומען, אים צו הערן און געהיילט צו ווערן פון זייערע שלאפקייטן. ");
INSERT INTO ydd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","נאר ער האט זיך צוריקגעצויגן אין די מדבריות אריין און תפילה געטאן. ");
INSERT INTO ydd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","און עס איז געשען אין איינעם פון די טעג, בשעת ער האט געלערנט, און עס זענען דערביי געזעסן פרושים און לומדים פון דער תורה, וואס זענען געקומען אויס יעדן דארף פון גליל און יהודה און ירושלים; און די גבורה פון דעם האר (ה׳) איז געווען מיט אים צו היילן. ");
INSERT INTO ydd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","און זע, מענער האבן געטראגן אויף א בעט א מענטשן, וועלכער איז געווען פאראליזשירט; און האבן געזוכט אים אריינצוברענגען, און צו לייגן פאר אים. ");
INSERT INTO ydd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","און נישט געפינענדיק (קיין מעגלעכקייט) וויאזוי זיי זאלן אים אריינברענגען צוליב דעם המון מענטשן, זענען זיי ארויפגעשטיגן אויפן דאך, און האבן אים אראפגעלאזט דורך די שינדלען מיט דעם בעטל אין דער מיט פאר יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","און ווען יהושע/ישוע האט געזען זייער אמונה, האט ער געזאגט: מענטש, דיינע זינד זענען דיר פארגעבן געווארן! ");
INSERT INTO ydd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","און די סופרים און די פרושים האבן אנגעהויבן נאכצוטראכטן, אזוי צו זאגן: ווער איז ער דאס, וואס רעדט ארויס לעסטערונגען? ווער קען דאס מוחל זיין זינד, אחוץ ה׳ אליין? ");
INSERT INTO ydd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","יהושע/ישוע האט אבער איינגעזען זייערע מחשבות, און האט ענטפערנדיק געזאגט צו זיי: פארוואס טראכט איר נאך אין אייערע הערצער? ");
INSERT INTO ydd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","וואס איז לייכטער, צו זאגן: דיינע זינד זענען דיר פארגעבן געווארן, אדער צו זאגן: שטיי אויף און גיי? ");
INSERT INTO ydd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","נאר כדי איר זאלט וויסן, אז דער בר אנש האט רשות אויף דער ערד מוחל צו זיין זינד—האט ער געזאגט צום פאראליטיקער—דיר זאג איך, שטיי אויף און נעם דיין בעטל און גיי אהיים! ");
INSERT INTO ydd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","און אין אן אויגנבליק איז ער אויפגעשטאנען פאר זיי, האט גענומען דאס (בעטל) אויף וועלכן ער איז געלעגן, און איז אוועק אהיים לויבנדיק ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","און א דערשטוינונג האט אלעמען אנגעכאפט, און זיי האבן געלויבט ה׳; און זענען אנגעפילט געווארן מיט מורא און האבן געזאגט: אומגלויבלעכע זאכן האבן מיר היינט געזען! ");
INSERT INTO ydd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","און נאך דעם איז ער ארויסגעגאנגען און האט געזען א שטייער אויפמאנער, מיט דעם נאמען לוי, זיצן ביים שטייער אמט, און האט צו אים געזאגט: פאלג מיר נאך! ");
INSERT INTO ydd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","און ער האט אלץ פארלאזט, איז אויפגעשטאנען און האט אים נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","און לוי האט פאר אים געמאכט א גרויס מאלצייט אין זיין הויז, און עס איז געווען א גרויסער עולם שטייער אויפמאנער און אנדערע, וואס זענען געזעסן מיט זיי (ביים טיש). ");
INSERT INTO ydd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","און די פרושים און זייערע סופרים האבן געמורמלט צו די תלמידים זיינע, אזוי צו זאגן: פארוואס עסט איר און טרינקט מיט שטייער אויפמאנער און זינדער? ");
INSERT INTO ydd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","און יהושע/ישוע האט ענטפערנדיק געזאגט צו זיי: נישט די געזונטע נויטיקן זיך אין א רופא, נאר די קראנקע; ");
INSERT INTO ydd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","איך בין נישט געקומען רופן צדיקים, נאר חוטאים צו תשובה! ");
INSERT INTO ydd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","זיי אבער האבן געזאגט צו אים: יוחננס תלמידים פאסטן אפט און טאן תפילה, אזוי טאן אויך די תלמידים פון די פרושים; דיינע אבער עסן און טרינקען. ");
INSERT INTO ydd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","האט יהושע/ישוע צו זיי געזאגט: צי קענט איר דען מאכן פאסטן די חתונה לייט בשעת דער חתן איז מיט זיי? ");
INSERT INTO ydd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","עס וועלן אבער קומען טעג, ווען דער חתן וועט אוועקגענומען ווערן פון זיי; דעמאלט וועלן זיי פאסטן אין יענע טעג. ");
INSERT INTO ydd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","און האט אויך געזאגט א משל צו זיי: קיינער שניידט נישט אפ קיין לאטע פון א נייעם בגד און לייגט זי אויף אן אלטן בגד; ווייל אויב יא, איז סאי ער שניידט אפ דאס נייע, סאי די לאטע פונם נייעם פאסט נישט דעם אלטן. ");
INSERT INTO ydd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","עס גיסט אויך קיינער נישט אריין קיין נייעם וויין אין אלטע לאגלען; ווייל אויב יא, צערייסט דער נייער וויין די לאגלען, און ווערט אליין אויסגעגאסן און די לאגלען גייען פארלוירן; ");
INSERT INTO ydd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","נאר נייעם וויין מוז מען אריינגיסן אין נייע לאגלען. ");
INSERT INTO ydd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","און קיינער, וואס האט געטרונקען אלטן, וויל נייעם; ווארום ער זאגט: דער אלטער איז גוט! ");
INSERT INTO ydd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","און עס איז געשען, א שבתדיקן טאג איז ער דורכגעגאנגען דורך די קארנפעלדער; און זיינע תלמידים האבן אפגעפליקט זאנגען, האבן זיי צעריבן מיט די הענט און געגעסן. ");
INSERT INTO ydd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","אייניקע אבער פון די פרושים האבן געזאגט: פארוואס טוט איר דאס, וואס מען טאר שבת נישט טאן? ");
INSERT INTO ydd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","און יהושע/ישוע האט ענטפערנדיק צו זיי געזאגט: צי האט איר דען נישט געלייענט דאס דאזיקע, וואס דוד (המלך) האט געטאן, ווען ער איז הונגעריק געווארן און די (לייט), וואס זענען געווען מיט אים? ");
INSERT INTO ydd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ווי ער איז אריינגעגאנגען אין ה׳ס הויז (משכן), און האט גענומען דאס לחם הפנים און עס געגעסן, און האט אויך געגעבן צו די (לייט), וואס זענען געווען מיט אים; וואס קיינער האט נישט געטארט עסן אחוץ די כהנים אליין? (שמואל א כא, ג-ד.) ");
INSERT INTO ydd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","און ער האט צו זיי געזאגט: דער בר אנש איז האר פונם שבת. ");
INSERT INTO ydd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","און עס איז געשען אן אנדערן שבת, אז ער איז אריינגעגאנגען אין א שול און האט געלערנט; און דארט איז געווען א מענטש, וועמעס רעכטע האנט איז געווען פארדארט. ");
INSERT INTO ydd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","און די סופרים און די פרושים האבן גוט אכטונג געגעבן אויף אים, אויב ער וועט שבת היילן, כדי זיי זאלן געפינען עפעס אים אנצוקלאגן. ");
INSERT INTO ydd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ער אבער האט געקענט זייערע געדאנקען; און האט געזאגט צום מאן, מיט דער פארדארטער האנט: הויב דיך אויף און שטעל דיך אין דער מיט! און ער איז אויפגעשטאנען און זיך געשטעלט. ");
INSERT INTO ydd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","און יהושע/ישוע האט צו זיי געזאגט: איך וועל אייך פרעגן: צי מעג מען שבת טאן גוטס אדער טאן שלעכטס, ראטעווען א נפש, אדער אומברענגען? ");
INSERT INTO ydd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","און ארומקוקנדיק זיך אויף זיי אלע, האט ער געזאגט צו אים: שטרעק אויס דיין האנט! און ער האט עס געטאן, און זיין האנט איז ווידער געזונט געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","זיי אבער זענען פול געווארן מיט גרימצארן; און האבן איבערגערעדט איינער מיטן אנדערן, וואס מען זאל טאן צו יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","און עס איז געשען אין די דאזיקע טעג, אז ער איז ארויסגעגאנגען צום בארג תפילה צו טאן; און האט פארברענגט די גאנצע נאכט אין געבעט צו ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","און ווען עס איז געווארן טאג, האט ער גערופן צו זיך זיינע תלמידים און אויסדערוויילט פון זיי צוועלף, וועלכע ער האט אויך א נאמען געגעבן שליחים: ");
INSERT INTO ydd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","שמעונען, וועמען ער האט אויך א נאמען געגעבן פעטרוס, און אנדריי זיין ברודער, און יעקבן און יוחנן, און פיליפוסן און בר‑תלמי, ");
INSERT INTO ydd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","און מתתיהו און תומא, און יעקב בן חלפי און שמעונען, וואס מען האט אים גערופן קנאי, ");
INSERT INTO ydd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","און יהודה בן יעקב, און יהודה איש‑קריות, וואס איז געווארן דער פאררעטער. ");
INSERT INTO ydd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","און איז מיט זיי אראפגעשטיגן און האט זיך געשטעלט אויף א פלאך ארט, און א גרויסע מאסע פון זיינע תלמידים און א גרויסער המון עם פון גאנץ יהודה און ירושלים און פון דער געגנט ביים ים פון צור און צידון, ");
INSERT INTO ydd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","וועלכע זענען געקומען אים הערן און צו ווערן געהיילט פון זייערע שלאפקייטן; און די, וואס זענען געווען געפלאגט פון אומריינע גייסטער, זענען געהיילט געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","און דער גאנצער המון מענטשן האט געזוכט אים אנצורירן, ווייל עס איז ארויסגעגאנגען פון אים א כוח און האט אלעמען געהיילט. ");
INSERT INTO ydd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","און ער האט אויפגעהויבן זיינע אויגן אויף זיינע תלמידים, און געזאגט: וואויל איז אייך, ארעמעלייט, ווייל דאס קעניגרייך פון ה׳ איז אייערס! ");
INSERT INTO ydd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","וואויל איז אייך, וואס הונגערן איצט, ווייל איר וועט געזעטיקט ווערן! וואויל איז אייך, וואס וויינען איצט, ווייל איר וועט לאכן! ");
INSERT INTO ydd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","וואויל איז אייך, ווען די מענטשן וועלן אייך האסן, און ווען זיי וועלן אייך ארויסשטויסן און באליידיקן און ארויסווארפן אייער נאמען ווי עפעס בייז, צוליב דעם בר אנש. ");
INSERT INTO ydd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","פריידט זיך אין יענעם טאג און טאנצט, ווארום זע, גרויס איז אייער שכר אין הימל; ווארום אזוי־אָ האבן זייערע עלטערן געטאן צו די נביאים. ");
INSERT INTO ydd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","אבער וויי צו אייך, די רייכע! ווייל איר האט שוין באקומען אייער נחמה. ");
INSERT INTO ydd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","וויי צו אייך, די וואס זענען איצט זאט, ווייל איר וועט הונגערן. וויי צו אייך, וואס לאכן איצט! ווייל איר וועט טרויערן און וויינען. ");
INSERT INTO ydd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","וויי צו אייך, ווען אלע מענטשן וועלן רעדן וואויל וועגן אייך, ווארום אָט אזוי האבן זייערע עלטערן געטאן צו די פאלשע נביאים. ");
INSERT INTO ydd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","צו אייך אבער, וואס הערן, זאג איך: האט ליב אייערע שונאים, טוט גוטס צו די, וואס האסן אייך; ");
INSERT INTO ydd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","בענטשט די, וואס פלוכן אייך, טוט תפילה פאר די, וואס באליידיקן אייך. ");
INSERT INTO ydd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","דעם, וואס שלאגט דיך אויף דער באק, גיב אויך די אנדערע; און פון דעם, וואס נעמט ביי דיר אוועק דעם מאנטל, האלט אויך דאס העמד נישט צוריק. ");
INSERT INTO ydd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","גיב יעדן, וואס בעט דיך; און פון דעם, וואס נעמט דאס דייניקע פון דיר אוועק, פאדער עס נישט צוריק. ");
INSERT INTO ydd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","און אזוי ווי איר ווילט, אז די מענטשן זאלן טאן צו אייך, זאלט איר אויך אזוי טאן צו זיי. ");
INSERT INTO ydd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","און אויב איר האט ליב די, וואס ליבן אייך, וואס פאר א חסד איז דאס ביי אייך? ווארום אפילו די חוטאים האבן ליב די, וואס האבן זיי ליב. ");
INSERT INTO ydd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ווארום אויב איר טוט גוטס צו די, וואס טאן אייך גוטס, וואס פאר א חסד איז דאס ביי אייך? די חוטאים טאן דאך דאס זעלביקע. ");
INSERT INTO ydd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","און אויב איר זאלט לייען צו די, פון וועמען איר האפט צוריק צו באקומען, וואס פאר א חסד איז דאס ביי אייך? אפילו חוטאים לייען צו חוטאים, כדי דאס גלייכע אפצונעמען. ");
INSERT INTO ydd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","איר אבער זאלט ליב האבן אייערע שונאים, און טוט גוטס, און לייט, אָן צו האפן אויף עפעס צוריק; און גרויס וועט זיין אייער שכר, און איר וועט זיין דעם אויבערשטנס קינדער; ווייל ער איז גוט צו די אומדאנקבארע און שלעכטע. ");
INSERT INTO ydd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","זייט בארמהערציק, אזוי ווי אייער פאטער איז בארמהערציק. ");
INSERT INTO ydd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","און משפט נישט, כדי איר זאלט נישט געמשפט ווערן; און פאראורטיילט נישט און איר וועט נישט פאראורטיילט ווערן; זייט מוחל, און עס וועט אייך פארגעבן ווערן; ");
INSERT INTO ydd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","גיט, און עס וועט אייך געגעבן ווערן; א מאס א גוטע, א געדריקטע, א צוגעשאקלטע, א שפעדיקע וועט מען אייך געבן אין אייער שויס אריין. ווארום מיט וואס פאר א מאס איר וועט מעסטן, וועט אייך אנטקייגן געמאסטן ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","און ער האט אויך געזאגט א משל צו זיי: צי קען דען א בלינדער פירן א בלינדן? וועלן זיי דען נישט ביידע אריינפאלן אין א גרוב? ");
INSERT INTO ydd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","דער תלמיד איז נישט איבער דעם רבין; ווען אבער פארפאלקאמט, וועט יעדער זיין ווי דער רבי זיינער. ");
INSERT INTO ydd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","און פארוואס זעסטו דאס שפענדל, וואס איז אין דיין ברודערס אויג, און באמערקסט נישט דעם קלאץ אין דיין אייגן אויג? ");
INSERT INTO ydd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","וויאזוי קענסטו זאגן צום ברודער דיינעם: ברודער, לאז מיך ארויסנעמען דאס שפענדל, וואס איז אין דיין אויג; בעת אליין זעסטו נישט דעם קלאץ אין דיין אויג? דו צבועק, נעם צום ערשט ארויס דעם קלאץ פון דיין אויג, און דעמאלט וועסטו זען קלאר ארויסצונעמען דאס שפענדל, וואס איז אין דיין ברודערס אויג. ");
INSERT INTO ydd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ווארום עס איז נישטא קיין גוטער בוים, וואס ברענגט שלעכטע פרוכט; און ווידער אויך נישט קיין שלעכטער בוים, וואס ברענגט גוטע פרוכט. ");
INSERT INTO ydd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ווארום יעדער בוים ווערט דערקענט פון זיינע אייגענע פירות; ווארום פון דערנער קלויבט מען נישט קיין פייגן, און פון א דארנבוש שניידט מען נישט קיין וויינטרויבן. ");
INSERT INTO ydd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","דער גוטער מענטש ברענגט ארויס דאס גוטע פון דעם גוטן אוצר פון זיין הארץ, און דער שלעכטער ברענגט ארויס שלעכטס פון דעם שלעכטן (אוצר); ווארום פון דעם, מיט וועלכן דאס הארץ פליסט איבער, רעדט דאס מויל זיינס. ");
INSERT INTO ydd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","און פארוואס רופט איר מיך, האר, האר, און טוט נישט וואס איך זאג? ");
INSERT INTO ydd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","יעדער איינער וואס קומט צו מיר און הערט מיינע רייד און טוט זיי, וועל איך אייך ווייזן צו וועמען ער איז גלייך; ");
INSERT INTO ydd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ער איז גלייך צו א מענטשן, וואס בויענדיק א הויז, האט געגראבן און איז אראפגעגאנגען טיף און געלייגט דעם פונדאמענט אויף דעם פעלדזן; און ווען עס איז געקומען א פארפלייצונג, האט דער שטראם זיך געווארפן אנטקעגן יענעם הויז און עס נישט געקענט דערשיטערן; צוליב דעם וואס עס איז געווען גוט געבויט. ");
INSERT INTO ydd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","דער אבער וואס הערט און טוט נישט, איז גלייך צו א מענטשן, וואס האט געבויט אויף דער ערד א הויז אָן א פונדאמענט; אנטקעגן וועלכן דער שטראם האט זיך געווארפן און עס איז באלד איינגעפאלן, און דער צוזאמענברוך פון יענעם הויז איז געווען גרויס. ");
INSERT INTO ydd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","נאך דעם ווי ער האט געענדיקט די אלע רייד זיינע אין די אויערן פון דעם פאלק, איז ער אריינגעגאנגען קיין כפר‑נחום. ");
INSERT INTO ydd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","און א געוויסן אפיצירס א קנעכט, וועלכער איז געווען ביי אים טייער געשעצט, איז געלעגן קראנק און געהאלטן ביים שטארבן. ");
INSERT INTO ydd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","און הערנדיק וועגן יהושען/ישוען, האט ער געשיקט צו אים זקנים פון די יידן אים צו בעטן, אז ער זאל קומען היילן דעם קנעכט זיינעם. ");
INSERT INTO ydd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","און ווען זיי זענען געקומען צו יהושען/ישוען, האבן זיי אים זייער געבעטן, אזוי צו זאגן: ער איז ווערט, אז דו זאלסט טאן דאס דאזיקע פאר אים; ");
INSERT INTO ydd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ווארום ער האט ליב אונדזער פאלק, און די שול האט ער אליין אונדז געבויט. ");
INSERT INTO ydd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","איז יהושע/ישוע געגאנגען מיט זיי. און ווען זיי זענען שוין נישט געווען ווייט פון דעם הויז, האט דער אפיציר געשיקט פריינד, אזוי צו זאגן צו אים: האר, באמי דיך נישט; ווארום איך בין נישט ווערט, אז דו זאלסט אריינקומען אונטער מיין דאך; ");
INSERT INTO ydd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","צוליב דעם האב איך מיך אליין נישט געהאלטן פאר ראוי צו קומען צו דיר. נאר זאג א ווארט, און מיין קנעכט וועט געזונט ווערן! ");
INSERT INTO ydd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ווארום אויך איך בין א מענטש, וואס איז געשטעלט אונטער מאכט, און האב אונטער מיר זעלנער, און איך זאג צו דעם דאזיקן: גיי! און ער גייט; און צו אן אנדערן: קום! און ער קומט; און צו דעם קנעכט מיינעם: טו דאס! און ער טוט עס. ");
INSERT INTO ydd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","און ווען יהושע/ישוע האט דאס געהערט, האט ער זיך געוואונדערט איבער אים, און האט זיך אויסגעדרייט און געזאגט צו דעם המון מענטשן, וואס האט אים נאכגעפאלגט: איך זאג אייך, נישט אפילו אין ישראל האב איך געפונען אָט אזא אמונה! ");
INSERT INTO ydd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","און ווען די שליחים האבן זיך אומגעקערט אהיים, האבן זיי געפונען דעם קנעכט געזונט. ");
INSERT INTO ydd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","און עס איז געשען, אויף צומארגנס איז ער אוועקגעגאנגען אין א שטאט אריין, וואס האט געהייסן נעים, און זיינע תלמידים זענען מיטגעגאנגען, און א גרויסער המון מענטשן. ");
INSERT INTO ydd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","און ווי ער האט זיך דערנענטערט צום טויער פון דער שטאט, זע, מען האט ארויסגעטראגן א מת, אן איינציקן זון ביי דער מוטער זיינער, און זי איז געווען אן אלמנה; און אן אנגעזעענער עולם פון דער שטאט איז געווען מיט איר. ");
INSERT INTO ydd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","און זעענדיק זי, האט דער האר זיך דערבארעמט איבער איר, און צו איר געזאגט: קלאג נישט! ");
INSERT INTO ydd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","און איז צוגעגאנגען און האט אנגערירט דעם ארון; און די נושאים האבן זיך אפגעשטעלט. און ער האט געזאגט; יונגערמאן, איך זאג דיר, שטיי אויף! ");
INSERT INTO ydd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","און דער טויטער האט זיך אויפגעזעצט און האט אנגעהויבן צו רעדן. און ער האט אים געגעבן צו זיין מוטער. ");
INSERT INTO ydd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","און אלעמען האט אנגעכאפט א מורא; און זיי האבן געלויבט ה׳, אזוי צו זאגן: א גרויסער נביא איז אויפגעשטאנען צווישן אונדז, און ה׳ האט זיך אומגעקוקט אויף זיין פאלק. ");
INSERT INTO ydd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","און די דאזיקע געשיכטע וועגן אים האט זיך פארברייטערט אין גאנץ יהודה און אין דער גאנצער געגנט ארום. ");
INSERT INTO ydd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","און יוחננס תלמידים האבן אים דערציילט וועגן אלעם דעם דאזיקן. און רופנדיק צו זיך צוויי פון זיינע תלמידים, ");
INSERT INTO ydd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","האט יוחנן זיי געשיקט צו דעם האר, אזוי צו זאגן: צי ביסטו דער, וואס דארף קומען, אדער זאלן מיר ווארטן אויף אן אנדערן? ");
INSERT INTO ydd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","און ווען די מענער זענען געקומען צו אים, האבן זיי געזאגט: יוחנן פון דער (ירדן) מקווה האט אונדז געשיקט צו דיר, אזוי צו זאגן: צי ביסטו דער, וואס דארף קומען, אדער זאלן מיר ווארטן אויף אן אנדערן? ");
INSERT INTO ydd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","און אין יענער שעה האט ער א סך געהיילט פון קראנקייטן און פון פלאג און פון בייזע גייסטער; און א סך בלינדע האט ער געשענקט די ראיה. ");
INSERT INTO ydd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","און ער האט ענטפערנדיק צו זיי געזאגט: גייט און דערציילט יוחנן וואס איר האט געזען און געהערט: בלינדע ווערן זעענדיק, לאמע גייען ארום, מצורעים ווערן גערייניקט, און טויבע הערן, טויטע שטייען אויף, צו ארעמעלייט ווערט אנגעזאגט די גוטע בשורה. (ישעיהו לה, ה-ו; סא, א.) ");
INSERT INTO ydd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","און געבענטשט איז דער, וועלכער וועט נישט שטרויכלען אין מיר. ");
INSERT INTO ydd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","און ווען יוחננס שליחים זענען אוועקגעגאנגען, האט ער אנגעהויבן צו רעדן צו די מאסן מענטשן וועגן יוחנן: וואס זענט איר ארויסגעגאנגען אין דער מדבר אריין צו זען? א טראשטשינע געשאקלט פונם ווינט? ");
INSERT INTO ydd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","נאר וואס דען זענט איר ארויסגעגאנגען זען? א מענטשן געקליידט אין טייערע מלבושים? זע, די וואס טראגן פרעכטיקע קליידער און לעבן אין תענוגים, געפינען זיך אין קעניגלעכע שלעסער. ");
INSERT INTO ydd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","נאר וואס דען זענט איר ארויסגעגאנגען זען? א נביא? יא, איך זאג אייך, און מער ווי א נביא. ");
INSERT INTO ydd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ער איז עס, וועגן וועמען עס שטייט געשריבן: זע, איך שיק מיין מלאך פאר דיין פנים, וועלכער וועט צוגרייטן דיין וועג פאר דיר. ");
INSERT INTO ydd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","איך זאג אייך, צווישן די, וואס זענען געבוירן געווארן פון פרויען, איז נישט פאראן קיין גרעסערער פון יוחנן; דאך איז דער קלענסטער אינם קעניגרייך פון ה׳ גרעסער ווי ער. ");
INSERT INTO ydd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","און דאס גאנצע פאלק, וואס האט אים געהערט, און די שטייער אויפמאנער האבן גערעכטפערטיקט ה׳, לאזנדיק זיך טובל זיין מיט דער מקווה פון יוחנן. ");
INSERT INTO ydd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","די פרושים אבער און די חכמים האבן אפגעווארפן די עצה פון ה׳ פון זיך, ווייל זיי האבן זיך נישט געלאזט טובל זיין אין דער מקווה פון אים. ");
INSERT INTO ydd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","צו וועמען זשע זאל איך פארגלייכן די מענטשן פון דעם דאזיקן דור, און צו וועמען זענען זיי גלייך? ");
INSERT INTO ydd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","זיי זענען גלייך צו קינדער, וואס זיצן אויפן מארק, און רופן איינס צום אנדערן און זאגן: מיר האבן געשפילט פאר אייך, און איר האט נישט געטאנצט; מיר האבן געקלאגט, און איר האט נישט געוויינט. ");
INSERT INTO ydd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ווארום יוחנן (פון דער ירדן מקווה) איז געקומען און האט נישט געגעסן קיין ברויט און נישט געטרונקען קיין וויין; און איר זאגט: ער האט א בייזן גייסט! ");
INSERT INTO ydd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","דער בר אנש איז געקומען, עסט און טרינקט יא; און איר זאגט: זע, א מענטש א זולל וסובא, א פריינד פון שטייער אויפמאנער און חוטאים! ");
INSERT INTO ydd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","און דאך איז די חכמה גערעכטפערטיקט אין אלע אירע קינדער. ");
INSERT INTO ydd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","און איינער פון די פרושים האט אים פארבעטן, צו עסן מיט אים. און ער איז אריינגעגאנגען אין דעם פרושס הויז, און האט זיך געזעצט צום טיש. ");
INSERT INTO ydd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","און זע, אין דער שטאט איז געווען א געוויסע זינדיקע פרוי; און דערוויסנדיק זיך, אז ער זיצט צום טיש אין דעם פרושס הויז, האט זי געברענגט אן אלאבאסטער פלאש מיט מירע אייל, ");
INSERT INTO ydd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","און האט זיך געשטעלט פון הינטן ביי זיינע פיס, און האט אנגעהויבן צו באנעצן זיינע פיס מיט אירע טרערן, און זיי אפגעווישט מיט די האר פון איר קאפ, און האט געקושט זיינע פיס און זיי געזאלבט מיט דער מירע. ");
INSERT INTO ydd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","אבער זעענדיק דאס, האט דער פרוש, וואס האט אים איינגעלאדן, צו זיך אליין גערעדט, אזוי צו זאגן: אויב ער וואלט געווען א נביא, וואלט ער געוואוסט ווער און וואס פאר א סארט פרוי זי איז, וואס רירט אים אָן, אז זי איז א זינדיקע. ");
INSERT INTO ydd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","און ענטפערנדיק, האט יהושע/ישוע צו אים געזאגט: שמעון, איך האב דיר עפעס צו זאגן. און ער האט געזאגט: רבי, זאג! ");
INSERT INTO ydd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","א געוויסער מלווה האט געהאט צוויי בעלי חובות; איינער איז אים שולדיק געווען פינף הונדערט דינרים, דער אנדערער נאר פיפציק. ");
INSERT INTO ydd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","און ווייל זיי האבן נישט געהאט צו באצאלן, האט ער זיי ביידן געשענקט. דעריבער ווער פון זיי וועט אים מער ליב האבן? ");
INSERT INTO ydd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","שמעון האט ענטפערנדיק געזאגט: איך נעם אָן, אז דער, וועמען ער האט דאס מערסטע געשענקט. און ער האט צו אים געזאגט: דו האסט ריכטיק געמשפט! ");
INSERT INTO ydd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","און אויסדרייענדיק זיך צו דער פרוי, האט ער געזאגט צו שמעונען: דו זעסט די דאזיקע פרוי? איך בין אריינגעקומען אין דיין הויז, קיין וואסער פאר מיינע פיס האסטו מיר נישט געגעבן; זי אבער האט מיר באנעצט די פיס מיט אירע טרערן, און זיי אפגעווישט מיר אירע האר. ");
INSERT INTO ydd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","קיין קוש האסטו מיר נישט געגעבן; אבער זי, זינט איך בין אריינגעקומען, האט נישט אויפגעהערט צו קושן מיינע פיס. ");
INSERT INTO ydd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","מיט אייל מיין קאפ האסטו נישט געזאלבט; זי אבער האט געזאלבט מיינע פיס מיט מירע. ");
INSERT INTO ydd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","צוליב וועלכן איך זאג דיר, אירע זינד, די פילע, זענען איר פארגעבן געווארן; ווייל זי האט א סך ליב געהאט; וועמען אבער ווייניק ווערט פארגעבן, דער ליבט ווייניק. ");
INSERT INTO ydd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","און ער האט צו איר געזאגט: דיינע זינד זענען דיר פארגעבן געווארן! ");
INSERT INTO ydd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","און די מיטזיצנדיקע האבן אנגעהויבן צו זאגן צווישן זיך: ווער איז דאס דער דאזיקער, וואס איז אפילו מוחל זינד? ");
INSERT INTO ydd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ער אבער האט געזאגט צו דער פרוי: דיין גלויבן האט דיך געראטעוועט, גיי לשלום! ");
INSERT INTO ydd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","און עס איז געשען נאך דעם, אז ער איז געגאנגען איבער שטאט און דארף, האט געדרשנט און אנגעזאגט די גוטע בשורה פון דעם קעניגרייך פון ה׳, און די צוועלף מיט אים, ");
INSERT INTO ydd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","און אייניקע פרויען, וואס זענען געהיילט געווארן פון בייזע גייסטער און פון שלאפקייטן: מרים, וועמען מען האט גערופן מגדלית, וואס פון איר זענען ארויס זיבן בייזע גייסטער, ");
INSERT INTO ydd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","און יוחנה, דאס ווייב פון כוזא, א פארוואלטער ביי הורדוסן, און שושנה און א סך אנדערע, וואס האבן אים געדינט מיט זייער האב און גוטס. ");
INSERT INTO ydd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","און ווען א גרויסער המון מענטשן איז זיך צוזאמענגעקומען, און זיי זענען געקומען צו אים פון אלע שטעט, האט ער געזאגט אין א משל: ");
INSERT INTO ydd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","עס איז ארויסגעגאנגען דער זייער צו פארזייען זיין זאמען; און בשעת ער האט געזייט, איז עפעס (פון דער זריעה) געפאלן ביים וועג און איז צעטרעטן געווארן, און די פייגל פון הימל האבן עס אויפגעפרעסן. ");
INSERT INTO ydd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","און אן אנדער ביסל איז געפאלן אויף דעם פעלדזן; און ווען עס האט אויפגעשפראצט, איז עס פארדארט געווארן, צוליב דעם וואס עס האט נישט געהאט קיין פייכטקייט. ");
INSERT INTO ydd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","און אן אנדער ביסל איז געפאלן אינמיטן פון די דערנער; און די דערנער זענען מיטאויפגעוואקסן און האבן עס דערשטיקט. ");
INSERT INTO ydd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","און אן אנדער ביסל איז געפאלן אויף דער גוטער ערד און האט אויפגעשפראצט און געברענגט פרוכט הונדערטפאכיק. און ווען ער האט דאס געזאגט, האט ער אויסגערופן: ווער עס האט אויערן צום הערן, דער זאל הערן! ");
INSERT INTO ydd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","און די תלמידים זיינע האבן אים געפרעגט, וואס דאס משל זאל באטייטן. ");
INSERT INTO ydd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","און ער האט געזאגט: אייך איז עס געגעבן געווארן צו וויסן די סודות פון דעם קעניגרייך פון ה׳; צו די איבריקע אבער אין משלים, כדי קוקנדיק זאלן זיי נישט זען, און הערנדיק זאלן זיי נישט פארשטיין. ");
INSERT INTO ydd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","און דאס איז דאס משל: דער זאמען דאס איז ה׳ס ווארט. ");
INSERT INTO ydd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","די ביים וועג זענען עס, וואס הערן, דערנאך קומט דער שׂטן און נעמט אוועק דאס ווארט פון זייער הארץ, כדי זיי זאלן נישט גלויבן און נישט געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","און די אויף דעם פעלדזן, דאס זענען זיי, וואס ווען זיי הערן, נעמען זיי אָן דאס ווארט מיט פרייד, זיי האבן אבער נישט קיין ווארצל; די גלויבן (נאר) אויף א געוויסע צייט, און אין א צייט פון נסיון פאלן זיי אפ. ");
INSERT INTO ydd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","און דאס וואס איז געפאלן צווישן די דערנער, זיי זענען עס, וואס הערן; און אוועקגייענדיק ווערן זיי דערשטיקט פון די דאגות און עשירות און תענוגים פון דעם לעבן, און ברענגען נישט קיין פירות צו רייפקייט. ");
INSERT INTO ydd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","דאס אבער אויף דער גוטער ערד, זיי זענען עס, וואס האבן געהערט דאס ווארט, האבן עס באהאלטן אין א לויטער און גוט הארץ און ברענגען פרוכט מיט סבלנות. ");
INSERT INTO ydd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","און קיינער, וואס האט אנגעצונדן א ליכט, פארדעקט עס נישט מיט קיין כלי, אדער שטעלט עס אונטער א בעט; נאר שטעלט עס אויף א לייכטער, כדי די, וואס קומען אריין, זאלן זען דאס ליכט. ");
INSERT INTO ydd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ווארום עס איז נישט פאראן קיין פארבארגענע זאך, וואס וועט נישט אנטפלעקט ווערן; עס געפינט זיך אויך נישט קיין באהאלטענע זאך, וואס וועט נישט באקאנט געמאכט ווערן און קומען צו התגלות. ");
INSERT INTO ydd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","דעריבער גיט אכטונג וויאזוי איר הערט; ווארום יעדער איינער, וואס האט, אים וועט געגעבן ווערן; און יעדער איינער, וואס האט נישט, פון אים וועט אוועקגענומען ווערן אפילו דאס, וואס ער מיינט, אז ער האט. ");
INSERT INTO ydd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","און זיין מוטער און זיינע ברידער זענען געקומען צו אים, און האבן נישט געקענט אים דערגרייכן מחמת דעם המון מענטשן. ");
INSERT INTO ydd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","און מען האט אים געזאגט: דיין מוטער און די ברידער דיינע שטייען אינדרויסן און ווילן דיך זען. ");
INSERT INTO ydd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ער אבער האט ענטפערנדיק צו זיי געזאגט: מיין מוטער און מיינע ברידער זענען די דאזיקע, וואס הערן ה׳ס ווארט און טאן עס! ");
INSERT INTO ydd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","און עס איז געשען אין איינעם פון די טעג, אז ער איז איינגעשטיגן אין א שיפל מיט זיינע תלמידים; און האט צו זיי געזאגט: לאמיר אריבערפארן אויף דער אנדערער זייט ים; און זיי האבן זיך אוועקגעשיפט. ");
INSERT INTO ydd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","בעת אבער זיי זענען געפארן, איז ער איינגעשלאפן; און א שטורמווינט האט אראפגענידערט אויפן ים, און דאס שיפל האט זיך אנגעפילט (מיט וואסער), און זיי זענען געווען אין סכנה. ");
INSERT INTO ydd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","און זיי זענען צוגעקומען, האבן אים אויפגעוועקט, אזוי צו זאגן; האר, האר, מיר זענען פארלוירן! ער אבער איז אויפגעשטאנען, האט אנגעשריגן דעם ווינט און די שטורמדיקע כוואליעס וואסער; און זיי האבן זיך געלייגט, און עס איז געווארן שטיל. ");
INSERT INTO ydd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","און ער האט צו זיי געזאגט: וואו איז אייער אמונה? זיי אבער האבן זיך געפארכטן און געוואונדערט, און געזאגט איינער צום אנדערן: ווער איז ער דאך, ווייל סאי די ווינטן באפעלט ער סאי דאס וואסער, און זיי געהארכן אים? ");
INSERT INTO ydd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","און זיי האבן זיך אהינגעשיפט צום לאנד פון די גרגשים, וואס איז אנטקעגנאיבער גליל. ");
INSERT INTO ydd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","און ווען ער איז ארויסגעקומען אויף דער יבשה, איז אים אויס דער שטאט אנטקעגנגעקומען א מאן, וואס האט געהאט בייזע גייסטער; און שוין א לאנגע צייט ווי ער האט נישט געטראגן קיין מלבוש, אויך האט ער נישט געוואוינט אין קיין הויז, נאר אין די קברים. ");
INSERT INTO ydd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","און דערזעענדיק יהושען/ישוען, האט ער א געשריי געטאן, איז אנידערגעפאלן פאר אים און האט געזאגט מיט א הויך קול: וואס האב איך מיט דיר, יהושע/ישוע, דו זון פון ג‑ט דעם אויבערשטער? איך בעט דיך, אז דו זאלסט מיך נישט פייניקן! ");
INSERT INTO ydd_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ווארום ער האט באפוילן דעם אומריינעם גייסט ארויסצוגיין פון דעם מענטשן; ווייל א סך מאל האט ער אים שוין געכאפט, און מען האט אים געבונדן מיט קייטן און פענטעס און געהאלטן אונטער שמירה; און ער פלעגט צערייסן דאס, מיט וועלכן ער איז געווען געבונדן און איז געטריבן געווארן פון דעם בייזן גייסט אין די מדבריות אריין. ");
INSERT INTO ydd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","און יהושע/ישוע האט אים געפרעגט: וואס איז דער נאמען דיינער? און ער האט געזאגט: לעגיאן! ווייל א סך בייזע גייסטער זענען אריין אין אים. ");
INSERT INTO ydd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","און זיי האבן אים געבעטן, אז ער זאל זיי נישט באפעלן צו גיין אין תהום אריין. ");
INSERT INTO ydd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","און דארטן איז געווען א גרויסע סטאדע חזירים פאשענדיק זיך אויפן בארג, און זיי האבן אים געבעטן, אז ער זאל זיי דערלויבן אריינצוגיין אין זיי. און ער האט עס זיי דערלויבט. ");
INSERT INTO ydd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","און די בייזע גייסטער זענען ארויסגעגאנגען פון דעם מענטשן און זענען אריין אין די חזירים; און די סטאדע האט זיך א ריס אראפ געטאן פון דעם משופעדיקן פעלדזן אין ים אריין און איז דערטרונקען געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ווי אבער די פאסטוכער האבן געזען, וואס עס האט געטראפן, זענען זיי אנטלאפן און האבן עס דערציילט אין דער שטאט און אין די דערפער. ");
INSERT INTO ydd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","און זיי זענען ארויסגעגאנגען זען, וואס עס האט פאסירט און זענען געקומען צו יהושען/ישוען, און האבן געפונען דעם מענטשן, פון וועמען די בייזע גייסטער זענען ארויס, אנגעקליידט און ביי די קלארע געדאנקען און ער איז געזעסן ביי ישועס פיס; און זיי האבן זיך געפארכטן. ");
INSERT INTO ydd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","די אבער, וואס האבן עס געזען, האבן צו זיי דערציילט, וויאזוי דער באזעסענער איז געהאלפן געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","און די גאנצע מאסע מענטשן פון דער אומגעגנט פון די גרגשים האבן אים געבעטן, אז ער זאל אוועקגיין פון זיי; ווייל עס האט זיי אנגעכאפט א גרויסע מורא. און ער איז איינגעשטיגן אין א שיפל און האט זיך אומגעקערט צוריק. ");
INSERT INTO ydd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","דער מאן אבער, פון וועמען די בייזע גייסטער זענען ארויס, האט אים געבעטן, אז ער זאל בלייבן מיט אים; ער אבער האט אים אוועקגעשיקט, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","קער דיך אום אהיים און דערצייל, וואס ה׳ האט דיר געטאן, און ער איז אוועקגעגאנגען און האט באקאנט געמאכט איבער דער גאנצער שטאט אלץ, וואס יהושע/ישוע האט פאר אים געטאן. ");
INSERT INTO ydd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","און ווען יהושע/ישוע האט זיך אומגעקערט, האט דער המון מענטשן אים אויפגענומען, ווארום אלע האבן געווארט אויף אים. ");
INSERT INTO ydd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","און זע, עס איז געקומען א מאן מיטן נאמען יאיר, א גבאי פון דער שול איז ער געווען; און איז אנידערגעפאלן פאר ישועס פיס און האט אים געבעטן, אז ער זאל אריינגיין אין זיין הויז. ");
INSERT INTO ydd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ווייל ער האט געהאט אן איין איינציקע טאכטער קנאפע צוועלף יאר אלט, און זי האט געהאלטן ביים שטארבן. און בשעת ער איז אהינגעגאנגען האבן די המונים מענטשן זיך געדרענגט ארום אים. ");
INSERT INTO ydd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","און א פרוי, וואס האט געהאט א בלוט פלוס שוין צוועלף יאר לאנג, וועלכע האט אויסגעגעבן איר גאנץ פארמעגן אויף רופאים, און האט פון קיינעם נישט געקענט געהיילט ווערן, ");
INSERT INTO ydd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","איז געקומען פון הינטן, האט אנגערירט די זוים פון זיין מלבוש, און פלוצלונג האט דער פלוס פון איר בלוט זיך אפגעשטעלט. ");
INSERT INTO ydd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","און יהושע/ישוע האט געזאגט: ווער האט מיך אנגערירט? און ווען אלע האבן געלייקנט, האט פעטרוס געזאגט: האר, די המונים דרענגען זיך ארום דיר און שטויסן דיך דאך. ");
INSERT INTO ydd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","יהושע/ישוע אבער האט געזאגט: עמיצער האט מיך אנגערירט; ווארום איך ווייס, אז א כוח איז פון מיר ארויסגעגאנגען! ");
INSERT INTO ydd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","און ווי די פרוי האט געזען, אז עס איז נישט געבליבן פארהוילן, איז זי ציטערנדיק געקומען און אנידערגעפאלן פאר אים און האט דערציילט פארן גאנצן פאלק, צוליב וועלכער סיבה זי האט אים אנגערירט, און וויאזוי זי איז פלוצלונג געהיילט געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","און ער האט צו איר געזאגט: טאכטער, דער גלויבן דיינער האט דיר געהאלפן; גיי לשלום! ");
INSERT INTO ydd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","בשעת ער האט נאך גערעדט, איז עמיצער געקומען פון דעם גבאיס הויז, אזוי צו זאגן: דיין טאכטער איז שוין געשטארבן; באמי מער נישט דעם רבין. ");
INSERT INTO ydd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","און אז יהושע/ישוע האט עס געהערט, האט ער געענטפערט צו אים: האב נישט קיין מורא; גלויב נאר און זי וועט געראטעוועט ווערן! ");
INSERT INTO ydd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","און ווען ער איז אריינגעקומען אין הויז, האט ער קיינעם נישט אריינגעלאזט מיט אים אחוץ פעטרוסן און יוחנן און יעקבן און דעם פאטער פון דעם קינד און די מוטער. ");
INSERT INTO ydd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","און אלע האבן געוויינט און געקלאגט איבער איר; ער אבער האט געזאגט: וויינט נישט, זי איז נישט געשטארבן, זי שלאפט נאר. ");
INSERT INTO ydd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","און זיי האבן זיך אויסגעלאכט פון אים, ווייל זיי האבן געוואוסט, אז זי איז יא געשטארבן. ");
INSERT INTO ydd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ער אבער האט זי אנגענומען ביי דער האנט און האט גערופן, אזוי צו זאגן: קינד, שטיי אויף! ");
INSERT INTO ydd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","און איר גייסט האט זיך אומגעקערט, און אין אן אויגנבליק איז זי אויפגעשטאנען; און ער האט באפוילן, מען זאל איר געבן צו עסן. ");
INSERT INTO ydd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","און אירע עלטערן זענען דערשטוינט געווארן; ער אבער האט זיי אנגעזאגט, קיינעם נישט צו זאגן, וואס עס איז געשען. ");
INSERT INTO ydd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","און ער האט צוזאמענגערופן די צוועלף, און האט זיי געגעבן כוח און שליטה איבער אלע בייזע גייסטער און צו היילן קראנקייטן. ");
INSERT INTO ydd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","און האט זיי געשיקט אויסצורופן דאס קעניגרייך פון ה׳ און געזונט צו מאכן די שלאפע. ");
INSERT INTO ydd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","און האט צו זיי געזאגט: נעמט גארנישט מיט אויפן וועג—נישט קיין שטעקן, נישט קיין בייטל, נישט קיין ברויט, נישט קיין געלט, איר זאלט אויך נישט האבן קיין צוויי העמדער. ");
INSERT INTO ydd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","און אין וועלכן נישט איז הויז איר וועט אריינקומען, בלייבט דארטן, און פון דארטן זאלט איר גיין ווייטער. ");
INSERT INTO ydd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","און וואו מען וועט אייך נישט אויפנעמען, ארויסגייענדיק פון יענער שטאט, זאלט איר אפשאקלען דעם שטויב פון אייערע פיס פאר אן עדות קעגן זיי. ");
INSERT INTO ydd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","און זיי זענען אוועק, און זענען געגאנגען איבער די דערפער, האבן אנגעזאגט די גוטע בשורה און געהיילט אומעטום. ");
INSERT INTO ydd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","און הורדוס דער טעטרארך האט געהערט אלץ, וואס עס איז געשען; און האט זיך באאומרואיקט, צוליב דעם וואס אייניקע האבן געזאגט, אז יוחנן איז אויפגעשטאנען פון די טויטע; ");
INSERT INTO ydd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","אייניקע אבער (האבן געזאגט), אז אליהו האט זיך באוויזן; און אנדערע—אז איינער פון די אלטע נביאים איז אויפגעשטאנען. ");
INSERT INTO ydd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","הורדוס אבער האט געזאגט: דעם יוחנן האב איך אפגעהאקט דעם קאפ; ווער אבער איז דער דאזיקער, וועגן וועלכן איך הער אזעלכע זאכן? און ער האט פארלאנגט אים צו זען. ");
INSERT INTO ydd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","און ווען די שליחים האבן זיך אומגעקערט, האבן זיי אים דערציילט אלץ, וואס זיי האבן געטאן. און ער האט זיי גענומען צו זיך און איז אוועק אין א שטאט אריין, וואס האט געהייסן בית‑צידה. ");
INSERT INTO ydd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","די המונים אבער האבן זיך דערוואוסט, און האבן אים נאכגעפאלגט, און ער האט זיי אויפגענומען, און גערעדט צו זיי וועגן דעם קעניגרייך פון ה׳, און די, וואס האבן זיך גענויטיקט אין א רפואה, האט ער געהיילט. ");
INSERT INTO ydd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","דער טאג אבער האט זיך שוין אנגעהויבן צו נייגן; און די צוועלף זענען צוגעקומען, און האבן געזאגט צו אים: לאז אפ דעם עולם מענטשן, כדי זיי זאלן אוועקגיין אין די ארומיקע דערפער און פעלדער איבערצונעכטיקן און צו געפינען שפייז; ווייל מיר זענען דא אויף אן איינזאם ארט. ");
INSERT INTO ydd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ער אבער האט צו זיי געזאגט: גיט איר זיי צו עסן! האבן זיי געזאגט: מיר האבן נישט מער ווי פינף ברויטן און צוויי פיש; סיידן מיר זאלן גיין איינקויפן שפייז פאר דעם דאזיקן גאנצן פאלק. ");
INSERT INTO ydd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ווארום עס זענען געווען קנאפע פינף טויזנט מענער. ער אבער האט געזאגט צו זיינע תלמידים: מאכט זיי זיך אנידערצוזעצן אין חברותות, מער ווייניקער צו פיפציק. ");
INSERT INTO ydd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","און זיי האבן אזוי געטאן און האבן אלעמען אויסגעזעצט. ");
INSERT INTO ydd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","און ער האט גענומען די פינף ברויטן און די צוויי פיש, האט ארויפגעבליקט צום הימל, געמאכט א ברכה און האט זיי צעבראכן און געגעבן צו די תלמידים צו לייגן פאר דעם המון מענטשן. ");
INSERT INTO ydd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","און זיי האבן געגעסן און זענען אלע זאט געווארן; און מען האט אויפגעהויבן, פון די ברעקלעך (שיריים), וואס זענען איבערגעבליבן, צוועלף קערב (פול). ");
INSERT INTO ydd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","און עס איז געשען בשעת ער האט תפילה געטאן איינער אליין, און די תלמידים זענען געווען מיט אים, האט ער זיי געפרעגט, אזוי צו זאגן: ווער, זאגן די לייט, אז איך בין? ");
INSERT INTO ydd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","און זיי האבן ענטפערנדיק געזאגט: יוחנן פון דער (ירדן) מקווה; אנדערע אבער (זאגן) אליהו; און אנדערע, אז איינער פון די אלטע נביאים איז אויפגעשטאנען. ");
INSERT INTO ydd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","האט ער צו זיי געזאגט: און ווער, זאגט איר, אז איך בין? פעטרוס האט ענטפערנדיק געזאגט: דער משיח פון ה׳! ");
INSERT INTO ydd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","און ער האט זיי שטרענג פארבאטן, דאס דאזיקע עמיצן אויסצוזאגן, ");
INSERT INTO ydd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","און האט געזאגט; דער בר אנש מוז א סך ליידן און פארווארפן ווערן פון די זקנים און הויפט כהנים און סופרים און געטייט ווערן און דעם דריטן טאג אויפשטיין. ");
INSERT INTO ydd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","און ער האט צו אלעמען געזאגט: ווער עס וויל מיר נאכגיין, דער זאל זיך אליין פארלייקענען און נעמען זיין בוים אויף זיך טאג אויס טאג איין און מיר נאכפאלגן. ");
INSERT INTO ydd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ווארום ווער עס וויל ראטעווען זיין נפש, דער וועט עס פארלירן; ווער אבער עס וועט פארלירן זיין נפש פאר מיינעטוועגן, דער וועט עס ראטעווען. ");
INSERT INTO ydd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ווארום וואס לוינט עס א מענטשן, אז ער זאל געווינען די גאנצע וועלט, און פארלירן אדער שעדיקן זיך אליין? ");
INSERT INTO ydd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ווארום ווער עס שעמט זיך מיט מיר און מיט די ווערטער מיינע, מיט דעם דאזיקן וועט דער בר אנש זיך שעמען, ווען ער וועט קומען אין זיין הערלעכקייט און (אין דער הערלעכקייט) פון דעם פאטער און פון די הייליקע מלאכים. ");
INSERT INTO ydd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","און באמת זאג איך אייך; אייניקע פון די, וואס שטייען דא, וועלן נישט פארזוכן דעם טעם פון טויט, ביז זיי וועלן זען דאס קעניגרייך פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","און עס איז געשען אן ערך אכט טאג נאך די דאזיקע רייד, אז ער האט גענומען פעטרוסן און יוחנן און יעקבן און איז ארויפגעשטיגן אויפן בארג תפילה צו טאן. ");
INSERT INTO ydd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","און בעת ער האט מתפלל געווען, האט דאס אויסזען פון זיין פנים זיך פארענדערט און זיינע קליידער זענען געווארן שטראלנדיק ווייס. ");
INSERT INTO ydd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","און זע, צוויי מענער האבן גערעדט מיט אים, וועלכע זענען געווען משה און אליהו; ");
INSERT INTO ydd_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","זיי האבן זיך באוויזן אין הערלעכקייט און האבן גערעדט וועגן זיין ליציאת (הסתלקות), וואס ער האט געזאלט ממלא זיין אין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","פעטרוס אבער און די, וואס זענען געווען מיט אים, זענען פארזונקען אין א שווערן שלאף; און אויפכאפנדיק זיך, האבן זיי געזען זיין הערלעכקייט און די צוויי מענער, וואס זענען געשטאנען מיט אים. ");
INSERT INTO ydd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","און עס איז געשען, ווען זיי זענען אוועקגעגאנגען פון אים, האט פעטרוס געזאגט צו יהושען/ישוען; האר, עס איז גוט פאר אונדז דא צו זיין; און לאמיר מאכן דריי סוכות: איינע פאר דיר, איינע פאר משהן און איינע פאר אליהו, נישט וויסנדיק, וואס ער רעדט. ");
INSERT INTO ydd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","און בשעת ער האט גערעדט, איז געקומען א וואלקן און האט זיי באשאטנט; און זיי האבן מורא געקריגן ווי זיי זענען אריינגעקומען אין דעם וואלקן אריין. ");
INSERT INTO ydd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","און עס איז ארויסגעקומען א קול פון דעם וואלקן, אזוי צו זאגן: דער דאזיקער איז מיין זון, דער אויסדערוויילטער, אים זאלט איר הערן! ");
INSERT INTO ydd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","און בשעת דאס קול איז געהערט געווארן, האט יהושע/ישוע זיך געפונען איינער אליין. און זיי האבן געשוויגן און אין יענע טעג האבן זיי קיינעם גארנישט דערציילט פון דעם, וואס זיי האבן געזען. ");
INSERT INTO ydd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","און עס איז געשען צומארגנס, ווען זיי זענען אראפגעשטיגן פונם בארג, איז אים אנטקעגנגעקומען א גרויסער המון מענטשן. ");
INSERT INTO ydd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","און זע, א מאן פון דער מאסע מענטשן האט א געשריי געטאן, אזוי צו זאגן: רבי, איך בעט דיך, קוק דיך אום אויף מיין זון, מחמת ער איז מיין בן יחיד; ");
INSERT INTO ydd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","און זע, א גייסט כאפט אים אָן, און פלוצלונג שרייט ער און רייסט אים, אז ער שוימט פארן מויל, און גייט קוים אוועק פון אים און צעשלאגט אים, ");
INSERT INTO ydd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","און איך האב שוין געבעטן דיינע תלמידים, אז זיי זאלן אים ארויסטרייבן, און זיי זענען נישט געווען ביכולת. ");
INSERT INTO ydd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","און יהושע/ישוע האט ענטפערנדיק געזאגט: אָ אומגלויביק און פארקרימט דור! ביז ווען וועל איך זיין ביי אייך און אייך סובל זיין! ברענג אהער דעם זון דיינעם! ");
INSERT INTO ydd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","און בעת ער איז נאך געווען אויפן וועג צו אים, האט דער בייזער גייסט אים א ריס געטאן און געמאטערט. יהושע/ישוע אבער האט אנגעשריגן אויף דעם אומריינעם גייסט, און געהיילט דאס יינגל און אים אפגעגעבן צו זיין פאטער. ");
INSERT INTO ydd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","און אלע זענען דערשטוינט געווארן איבער ה׳ס געוואלדיקער מאכט. און בשעת אלע האבן זיך געוואונדערט איבער אלעם, וואס ער האט געטאן, האט ער געזאגט צו זיינע תלמידים: ");
INSERT INTO ydd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","לאזט די דאזיקע ווערטער אריינדרינגען אין אייערע אויערן אריין: ווארום דער בר אנש וועט איבערגעגעבן ווערן אין די הענט פון מענטשן. ");
INSERT INTO ydd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","זיי אבער האבן נישט פארשטאנען דאס דאזיקע ווארט און עס איז געווען פארהוילן פון זיי, כדי זיי זאלן נישט וויסן די באטייטונג דערפון; און זיי האבן מורא געהאט אים צו פרעגן וועגן דעם דאזיקן ווארט. ");
INSERT INTO ydd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","און עס איז זיי אויפגעגאנגען א ארגומענט: ווער פון זיי עס זאל זיין דער גרעסטער. ");
INSERT INTO ydd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","און ווען יהושע/ישוע האט געזען די מחשבה פון זייער הארץ, האט ער גענומען א קינד און עס געשטעלט לעבן זיך, ");
INSERT INTO ydd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","און האט צו זיי געזאגט: ווער עס וועט אויפנעמען דאס דאזיקע קינד אין מיין נאמען, דער נעמט מיך אויף; און ווער עס וועט מיך אויפנעמען, דער נעמט אויף דעם, וואס האט מיך געשיקט; ווארום ווער עס איז דער קלענסטער צווישן אייך אלע, דער דאזיקער איז גרויס! ");
INSERT INTO ydd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","און יוחנן האט ענטפערנדיק געזאגט: האר, מיר האבן געזען איינעם, וואס האט אין דיין נאמען ארויסגעטריבן בייזע גייסטער, און מיר האבן עס אים פארווערט, ווייל ער פאלגט נישט נאך מיט אונדז. ");
INSERT INTO ydd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","יהושע/ישוע אבער האט צו אים געזאגט: איר זאלט נישט פארווערן! ווארום ווער עס איז נישט קעגן אייך, דער איז פאר אייך. ");
INSERT INTO ydd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","און עס איז געשען, ווען די טעג זענען דערפילט געווארן, אז ער זאל ארויפגענומען ווערן (זיין העלייה השמימה), האט ער פעסט אנטשלאסן געווענדט זיין פנים צו גיין קיין ירושלים, ");
INSERT INTO ydd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","און געשיקט שליחים פארויס פאר זיך; און זיי זענען אוועק און זענען אריינגעגאנגען אין א דארף פון די שומרונים, כדי צוצוגרייטן פאר אים. ");
INSERT INTO ydd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","און מען האט אים נישט אויפגענומען, ווייל זיין פנים איז געווען געווענדט צו גיין קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","און זעענדיק דאס, האבן די תלמידים, יעקב און יוחנן, געזאגט: האר, צי ווילסטו, אז מיר זאלן זאגן, עס זאל אראפקומען פייער פון הימל און זיי פארברענען? (מלכים ב א.) ");
INSERT INTO ydd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ער אבער האט זיך אויסגעדרייט און אנגעשריגן אויף זיי; ");
INSERT INTO ydd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","און זיי זענען געגאנגען אין אן אנדער דארף אריין. ");
INSERT INTO ydd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","און בשעת זיי זענען געגאנגען אויפן וועג, האט עמיצער געזאגט צו אים: איך וועל דיר נאכפאלגן וואואהין דו וועסט נאר גיין. ");
INSERT INTO ydd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","און יהושע/ישוע האט צו אים געזאגט: די פוקסן האבן היילן און די פייגל פון הימל נעסטן; דער בר אנש אבער האט נישט וואו דעם קאפ אנידערצולייגן. ");
INSERT INTO ydd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","און צו אן אנדערן האט ער געזאגט: פאלג מיר נאך! דער אבער האט געזאגט: דערלויב מיר צום ערשט אוועקצוגיין און קובר צו זיין דעם פאטער מיינעם. ");
INSERT INTO ydd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","האט ער צו אים געזאגט: לאז די טויטע באגראבן זייערע טויטע; דו אבער גיי, און זאג אָן דאס קעניגרייך פון ה׳! ");
INSERT INTO ydd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","און נאך אן אנדערער האט געזאגט: איך וועל דיר נאכפאלגן, האר, נאר דערלויב מיר קודם כל זיך צו געזעגענען מיט די, וואס זענען אין מיין הויז. ");
INSERT INTO ydd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","יהושע/ישוע אבער האט צו אים געזאגט: קיינער, וואס לייגט די האנט אויפן אקעראייזן און בליקט אויף דעם, וואס איז הינטער זיך, טויג נישט פאר דעם קעניגרייך פון ה׳! ");
INSERT INTO ydd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","און נאך דעם האט דער האר באצייכנט נאך זיבעציק אנדערע און זיי געשיקט זאלבעצוויי פארויס פאר זיך אין יעדער שטאט און ארט, וואואהין ער אליין האט געזאלט קומען. ");
INSERT INTO ydd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","און האט צו זיי געזאגט: דער שניט איז גרויס, די ארבעטער אבער זענען ווייניק; בעט זשע דעם האר פונם שניט, אז ער זאל שיקן ארבעטער צו זיין שניט! ");
INSERT INTO ydd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","גייט! זע, איך שיק אייך ווי שאף צווישן וועלף. ");
INSERT INTO ydd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","טראגט נישט קיין בייטל, נישט קיין טאש, נישט קיין שיך; און גיט קיינעם נישט אפ שלום אויפן וועג. ");
INSERT INTO ydd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","וואו אבער איר וועט אריינקומען אין א הויז, זאלט איר צום ערשט זאגן: שלום צו דעם דאזיקן הויז! ");
INSERT INTO ydd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","און אויב דארטן איז דא א בן שלום, וועט אייער פרידן רוען אויף אים; אויב אבער נישט, וועט ער זיך אומקערן צו אייך. ");
INSERT INTO ydd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","און אין דעם זעלביקן הויז זאלט איר בלייבן, עסט און טרינקט וואס זיי האבן; ווארום דער ארבעטער איז ווערט זיין לוין. גייט נישט פון הויז צו הויז. ");
INSERT INTO ydd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","און אין וועלכער עס איז שטאט איר קומט אריין, און זיי נעמען אייך אויף, זאלט איר עסן וואס מען לייגט פאר אייך אנידער; ");
INSERT INTO ydd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","און איר זאלט היילן די קראנקע אין דער זעלביקער (שטאט), און זאגט צו זיי: דאס קעניגרייך פון ה׳ האט זיך דערנענטערט צו אייך! ");
INSERT INTO ydd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","וואו אבער איר וועט אריינקומען אין א שטאט, און זיי וועלן אייך נישט אויפנעמען, זאלט איר ארויסגיין אויף אירע גאסן און זאגן: ");
INSERT INTO ydd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","אפילו דעם שטויב, וואס האט זיך פון אייער שטאט באהעפט צו אונדזערע פיס, ווישן מיר אפ קעגן אייך; דאך זאלט איר וויסן זיין דאס דאזיקע, אז דאס קעניגרייך פון ה׳ האט זיך דערנענטערט. ");
INSERT INTO ydd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","איך זאג אייך, אז פאר סדום וועט עס זיין דערטרעגלעכער אין יענעם טאג ווי פאר יענער שטאט. ");
INSERT INTO ydd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","וויי איז צו דיר, כורזין! וויי איז צו דיר, בית‑צידה! ווייל אויב אין צור און צידון וואלטן געשען די וואונדער, וואס זענען געשען אין אייך, וואלטן זיי שוין לאנג געזעסן אין זאק און אין אש און תשובה געטאן. ");
INSERT INTO ydd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","דאך וועט פאר צור און צידון זיין דערטרעגלעכער אינם משפט, ווי פאר אייך. ");
INSERT INTO ydd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","און דו כפר‑נחום, ביז צום הימל וועסטו זיין דערהויכט? ביז צום שאול תחתית וועסטו אראפנידערן! ");
INSERT INTO ydd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ווער עס הערט אייך, דער הערט מיך, און ווער עס פארווארפט אייך, דער פארווארפט מיך; ווער אבער עס פארווארפט מיך, דער פארווארפט אים, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","און די זיבעציק האבן זיך אומגעקערט מיט פרייד, אזוי צו זאגן: האר, אפילו די בייזע גייסטער זענען אונטערטעניק צו אונדז אין דיין נאמען! ");
INSERT INTO ydd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ער אבער האט צו זיי געזאגט: איך האב געזען דעם שׂטן פאלן, ווי א בליץ פון הימל. ");
INSERT INTO ydd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","זע, איך האב אייך געגעבן די מאכט צו טרעטן אויף שלאנגען און עקדישן און איבער יעדער גבורה פון דעם שונא; און עס וועט אייך גארנישט שאטן. ");
INSERT INTO ydd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","דאך זאלט איר זיך נישט פרייען מיט דעם דאזיקן, וואס די גייסטער זענען אייך אונטערטעניק; נאר פריידט זיך, ווייל אייערע נעמען זענען איינגעשריבן אין הימל! ");
INSERT INTO ydd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","און אין דער זעלביקער שעה האט ער זיך געפריידט אינם רוח הקודש און געזאגט: איך לויב דיך, פאטער, האר פון הימל און ערד, ווייל דו האסט פארהוילן די דאזיקע זאכן פון די חכמים און נבונים, און האסט זיי אנטפלעקט צו קליינע קינדער; יא, פאטער, ווייל אזוי איז עס געווען וואוילגעפעליק פאר דיר. ");
INSERT INTO ydd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","אלץ איז מיר איבערגעגעבן געווארן פון מיין פאטער; און קיינער ווייסט נישט, ווער דער זון איז, אחוץ דער פאטער; און ווער דער פאטער איז, (ווייסט קיינער נישט) אחוץ דער זון, און דער, צו וועמען דער זון וויל עס אנטפלעקן. ");
INSERT INTO ydd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","און אויסדרייענדיק זיך צו די תלמידים האט ער געזאגט צו זיי אליין: געבענטשט זענען די אויגן, וועלכע זען, וואס איר זעט; ");
INSERT INTO ydd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ווארום איך זאג אייך, אז א סך נביאים און מלכים האבן באגערט צו זען, וואס איר זעט, און האבן עס נישט געזען; און צו הערן, וואס איר הערט, און האבן עס נישט געהערט. ");
INSERT INTO ydd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","און זע, א געוויסער בעל תורה האט זיך אויפגעשטעלט און אים אויסגעפרואווט, אזוי צו זאגן: רבי, וואס זאל איך טאן, כדי צו ירשענען אייביק לעבן? ");
INSERT INTO ydd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","און ער האט צו אים געזאגט: וואס שטייט געשריבן אין דער תורה? וויאזוי לייענסטו? ");
INSERT INTO ydd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","האט ער ענטפערנדיק געזאגט: דו זאלסט ליב האבן דעם האר, דיין ג‑ט, מיטן גאנצן הארצן דיינעם און מיט דיין גאנץ נפש און מיט דיין גאנצער קראפט און מיט דיין גאנצן פארשטאנד, און דיין חבר ווי דיך אליין! (דברים ו, ה; ויקרא יט, יח.) ");
INSERT INTO ydd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","האט ער צו אים געזאגט: דו האסט ריכטיק געענטפערט; טו דאס דאזיקע, און דו וועסט לעבן. ");
INSERT INTO ydd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ער אבער, ווילנדיק זיך אליין גערעכטפערטיקן, האט געזאגט צו יהושען/ישוען: און ווער איז מיין חבר? ");
INSERT INTO ydd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","האט יהושע/ישוע ענטפערנדיק געזאגט: א געוויסער מענטש איז אראפגעגאנגען פון ירושלים קיין יריחו און איז אריינגעפאלן צווישן גזלנים; און זיי האבן אים אויסגעטאן און אים באלייגט מיט בלוטיקע שלעק און זענען אוועקגעגאנגען איבערלאזנדיק אים א האלב טויטן. ");
INSERT INTO ydd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","און מעשה צופאל איז א כהן אראפגעגאנגען אויף יענעם וועג; און ווי ער האט אים דערזען, איז ער אריבער אויף דער אנדערער זייט און אוועקגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","און אויך אזוי א לוי, קומענדיק צו דעם ארט און זעענדיק אים, איז אריבער אויף דער אנדערער זייט און אוועקגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","א געוויסער שומרוני אבער, אונטערוועגנס, איז אהינגעקומען צו אים, און ווי ער האט אים דערזען, האט ער זיך דערבארעמט ");
INSERT INTO ydd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","און איז צוגעגאנגען און האט אים פארבונדן די וואונדן זיינע און ארויפגעגאסן אייל און וויין; און אים ארויפגעזעצט אויף זיין אייגענער בהמה און אוועקגעפירט אין אן אכסניה אריין און אים געזארגט. ");
INSERT INTO ydd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","און צומארגנס האט ער ארויסגענומען צוויי דינרים און זיי געגעבן דעם בעל אכסניה און געזאגט: קוק דיך אום אויף אים! און וואס דו וועסט אויסגעבן מער, וועל איך דיר באצאלן ווען איך וועל מיך אומקערן. ");
INSERT INTO ydd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ווער פון די דאזיקע דריי, מיינסטו, איז געווען א חבר צו אים, וואס איז אריינגעפאלן צווישן די גזלנים? ");
INSERT INTO ydd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","און ער האט געזאגט: דער, וואס האט געטאן חסד מיט אים! און יהושע/ישוע האט צו אים געזאגט: גיי, און טו אויך אזוי! ");
INSERT INTO ydd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","און בשעת זיי זענען ווייטער געגאנגען, איז ער אריינגעקומען אין א געוויס דארף; און א פרוי מיט דעם נאמען מרתא האט אים אויפגענומען אין איר הויז אריין. ");
INSERT INTO ydd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","און זי האט געהאט א שוועסטער, וואס האט געהייסן מרים, וועלכע האט זיך אויך אנידערגעזעצט ביי דעם הארס פיס און זיך צוגעהערט צו זיין ווארט. ");
INSERT INTO ydd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","מרתא אבער האט זיך זייער געפארעט איבער א סך באדינען; און זי איז צוגעקומען און געזאגט: האר, עס קימערט דיך נישט וואס מיין שוועסטער האט מיך איבערגעלאזט איינע אליין צו באדינען? זאג זשע איר, אז זי זאל מיר צוהעלפן. ");
INSERT INTO ydd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","און דער האר האט איר ענטפערנדיק געזאגט: מרתא, מרתא, דו זארגסט דיך און קימערסט דיך וועגן א סך זאכן; ");
INSERT INTO ydd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","אבער נאר עפעס, איין זאך איז נייטיק; און מרים האט אויסדערוויילט דעם גוטן חלק, וואס וועט פון איר נישט אוועקגענומען ווערן! ");
INSERT INTO ydd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","און עס איז געשען, בשעת ער האט מתפלל געווען אויף א געוויס ארט; און אז ער האט אויפגעהערט, האט איינער פון די תלמידים זיינע געזאגט צו אים: האר, לערן אונדז תפילה צו טאן, אזוי ווי יוחנן האט אויך געלערנט זיינע תלמידים! ");
INSERT INTO ydd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","און ער האט צו זיי געזאגט: ווען איר טאט תפילה, זאלט איר זאגן: פאטער, געהייליקט זאל ווערן דיין נאמען. זאל דיין מלכות קומען. ");
INSERT INTO ydd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","גיב אונדז יעדן טאג אונדזער טעגלעך ברויט! ");
INSERT INTO ydd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","און פארגיב אונדז אונדזערע זינד, ווארום מיר אליין זענען אויך מוחל יעדן איינעם, וואס איז אונדז שולדיק. און ברענג אונדז נישט צו קיין נסיון. ");
INSERT INTO ydd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","און ער האט צו זיי געזאגט: ווער פון אייך וועט האבן א פריינד, און ער וועט גיין צו אים אין מיטן דער נאכט און זאגן צו אים: פריינד, ליי מיר דריי לעבלעך ברויט, ");
INSERT INTO ydd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ווייל א פריינד מיינער איז געקומען פון אונטערוועגנס צו מיר, און איך האב נישט וואס אנידערצולייגן פאר אים; ");
INSERT INTO ydd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","און יענער אינעווייניק ענטפערנדיק וועט זאגן: זיי מיך נישט מטריח; די טיר איז שוין צוגעשלאסן, און מיינע קינדער זענען מיט מיר אין בעט; איך קען נישט אויפשטיין און דיר געבן! ");
INSERT INTO ydd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","איך זאג אייך; אויב ער וועט נישט אויפשטיין און אים געבן, מחמת ער איז זיין פריינד, דאך צוליב זיין עזות פנימדיקייט וועט ער אויפשטיין און אים געבן, אזויפיל וויפל ער באדארף. ");
INSERT INTO ydd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","און איך זאג אייך: בעט, און עס וועט אייך געגעבן ווערן, זוכט, און איר וועט געפינען; קלאפט אָן, און עס וועט אייך אויפגעמאכט ווערן! ");
INSERT INTO ydd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ווארום יעדער איינער, וואס בעט, באקומט; און ווער עס זוכט, געפינט; און דעם, וואס קלאפט אָן, וועט אויפגעמאכט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","און וועמען פון אייך, וואס איז א פאטער, דער זון וועט בעטן ברויט, צי וועט ער אים דען געבן א שטיין? אדער פיש, צי וועט ער דען אים געבן א שלאנג אנשטאט פיש? ");
INSERT INTO ydd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","אדער אויב ער וועט בעטן אן איי, צי וועט ער דען אים געבן אן עקדיש? ");
INSERT INTO ydd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","דעריבער, אויב איר, זייענדיק שלעכט, ווייסט צו געבן גוטע גאב צו אייערע קינדער, על אחת כמה וכמה וועט דער פאטער פון הימל געבן דעם רוח הקודש צו די, וואס בעטן אים! ");
INSERT INTO ydd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","און ער האט ארויסגעטריבן א בייזן גייסט, וואס איז געווען שטום. און עס איז געשען, ווען דער בייזער גייסט איז ארויסגעגאנגען, האט דער שטומער גערעדט; און די מאסן האבן געשטוינט. ");
INSERT INTO ydd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","אייניקע אבער פון זיי האבן געזאגט: דורך דעם בעל‑זבול, דעם שר פון די בייזע גייסטער, טרייבט ער ארויס די בייזע גייסטער. ");
INSERT INTO ydd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","און אנדערע, אויספרואוונדיק אים, האבן פון אים פארלאנגט א צייכן פון הימל. ");
INSERT INTO ydd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ער אבער, ווייל ער האט געוואוסט פון זייערע געדאנקען, האט צו זיי געזאגט: יעדע מלוכה, וואס איז צעטיילט קעגן זיך אליין, ווערט פארוויסט; און א הויז פאלט אויף א הויז. ");
INSERT INTO ydd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","און אפילו דער שׂטן, אויב ער איז צעטיילט קעגן זיך אליין, וויאזוי וועט זיין קעניגרייך האבן א קיום? ווייל איר זאגט, דורך דעם בעל‑זבול טרייב איך ארויס די בייזע גייסטער. ");
INSERT INTO ydd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","און אויב איך טרייב ארויס די בייזע גייסטער דורך דעם בעל‑זבול, דורך וועמען טרייבן אייערע קינדער זיי ארויס? דערפאר וועלן זיי זיין אייערע שופטים. ");
INSERT INTO ydd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","אויב אבער איך טרייב ארויס די בייזע גייסטער מיט דעם פינגער פון ה׳, אזוי איז דאס קעניגרייך פון ה׳ שוין געקומען צו אייך! ");
INSERT INTO ydd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ווען דער גיבור, פעליק באוואפנט, באוואכט זיין הויף, בלייבט זיין פארמעגן אין פרידן; ");
INSERT INTO ydd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ווען אבער א שטארקערער פון אים קומט און באזיגט אים, וועט ער אוועקנעמען זיינע כלי זין, אויף וועלכע ער האט זיך פארלאזט, און וועט צעטיילן זיין רויב. ");
INSERT INTO ydd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ווער עס איז נישט מיט מיר, דער איז קעגן מיר; און ווער עס זאמלט נישט איין מיט מיר, דער צעשפרייט. ");
INSERT INTO ydd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ווען דער אומריינער גייסט גייט ארויס פון דעם מענטשן, גייט ער אדורך איבער ערטער, וואו עס איז קיין וואסער נישטא, זוכנדיק מנוחה; און ווייל ער געפינט נישט, זאגט ער: איך וועל מיך אומקערן צו דעם הויז מיינעם, פון וואנען איך בין ארויס. ");
INSERT INTO ydd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","און ער קומט און געפינט עס אויסגעקערט און אויסגעצירט. ");
INSERT INTO ydd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","דעמאלט גייט ער און נעמט מיט זיבן אנדערע ערגערע גייסטער ווי ער איז אליין, און זיי גייען אריין און וואוינען דארטן, און דער סוף פון יענעם מענטשן ווערט ערגער ווי דער אנהויב. ");
INSERT INTO ydd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","און עס איז געשען, בשעת ער האט דאס גערעדט, האט א געוויסע פרוי פון דעם המון מענטשן אויפגעהויבן איר קול און געזאגט צו אים: אז וואויל איז דעם מוטערלייב, וואס האט דיך געטראגן, און די בריסט, וועלכע דו האסט געזויגן! ");
INSERT INTO ydd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ער אבער האט געזאגט: יא, וואויל איז די, וואס הערן ה׳ס ווארט, און היטן עס אפ! ");
INSERT INTO ydd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ווי אבער מאסן מענטשן האבן אהערגעשטראמט צו אים, האט ער אנגעהויבן צו זאגן: דאס דאזיקע דור איז א בייז דור! עס פארלאנגט א צייכן; און קיין צייכן וועט אים נישט געגעבן ווערן אחוץ דאס צייכן פון יונה. ");
INSERT INTO ydd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ווארום אזוי ווי יונה איז געווארן א צייכן פאר די אנשי נינוה, אזוי וועט דער בר אנש זיין פאר דעם דאזיקן דור. (יונה א, יז.) ");
INSERT INTO ydd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","די מלכה פון תימן וועט אויפשטיין אינם משפט מיט די לייט פון דעם דאזיקן דור און וועט זיי פארמשפטן; ווייל זי איז געקומען פון די עקן פון דער ערד, צו הערן שלמהס חכמה און זע, דא געפינט זיך א גרעסערער ווי שלמה! (מלכים א י, א-יג.) ");
INSERT INTO ydd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","מענער פון נינוה וועלן אויפשטיין אינם משפט מיט דעם דאזיקן דור און וועלן עס פארמשפטן; ווייל זיי האבן תשובה געטאן אויף יונהס רוף; און זע, דא געפינט זיך א גרעסערער ווי יונה. (יונה ג.) ");
INSERT INTO ydd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","קיינער צינדט נישט אָן קיין ליכט און שטעלט עס אויף א פארבארגן ארט, אויך נישט אונטער א מאסשעפל, נאר אויף א לייכטער, כדי די, וואס קומען אריין, זאלן זען דעם העלן שיין. ");
INSERT INTO ydd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","דאס ליכט פון דעם קערפער איז דאס אויג דיינס. ווען דיין אויג איז געזונט, איז אויך דיין גאנצער קערפער ליכטיק; אויב אבער עס איז שלעכט, איז אויך דער גאנצער גוף דיינער חושך. ");
INSERT INTO ydd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","גיב זשע אכטונג, אז דאס ליכט אין דיר זאל נישט זיין קיין פינצטערניש! ");
INSERT INTO ydd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","אויב דעריבער דיין גאנצער קערפער איז ליכטיק, אז ער האט נישט קיין פינסטערן חלק, וועט ער זיין אינגאנצן ליכטיק, ווי ווען דאס ליכט באשטראלט דיך מיט זיין שיין. ");
INSERT INTO ydd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","און בשעת ער האט גערעדט, האט א פרוש אים פארבעטן, אז ער זאל עסן ביי אים. און ער איז אריינגעגאנגען און האט זיך געזעצט צום טיש. ");
INSERT INTO ydd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","און דער פרוש האט זיך געוואונדערט, זעענדיק, אז ער האט זיך נישט צו ערשט געוואשן פארן עסן. ");
INSERT INTO ydd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","און דער האר האט געזאגט צו אים: איצט מאכט איר, פרושים, ריין דעם בעכער און די שיסל פון אויסנווייניק, דאס אינעווייניקסטע אבער אין אייך איז פול מיט גזלה און רשעות. ");
INSERT INTO ydd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","נאראנים וואס איר זענט! צי האט דען נישט דער, וואס האט געמאכט דאס אויסנווייניקסטע, אויך געמאכט דאס אינעווייניקסטע? ");
INSERT INTO ydd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","גיט נאר צדקה פון דעם, וואס איז דרינען, און זע, אלץ איז ריין פאר אייך! ");
INSERT INTO ydd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","נאר וויי איז צו אייך פרושים, ווייל איר גיט אפ מעשר פון מיענטע און רוטע און פון יעדן קרייטעכצער, און זענט עובר אויף דעם משפט און דער ליבע פון ה׳; די דאזיקע האט איר געדארפט טאן און יענע אויך נישט אויסלאזן. ");
INSERT INTO ydd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","וויי איז צו אייך פרושים, ווייל איר האט ליב צו זיצן אויבנאן אין שול און אז מען זאל אייך אפגעבן שלום אויף די מערקפלעצער. ");
INSERT INTO ydd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","וויי איז צו אייך, אז איר זענט ווי קברים, וואס מען דערקענט נישט; און די מענטשן, וואס גייען ארום אויף זיי, ווייסן עס נישט! ");
INSERT INTO ydd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","און איינער פון די חכמים האט ענטפערנדיק געזאגט צו אים: רבי, ווען דו זאגסט די דאזיקע זאכן, באליידיקסטו אונדז אויך! ");
INSERT INTO ydd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ער אבער האט געזאגט: וויי איז אויך צו אייך, חכמי התורה; ווייל איר באלאדנט די מענטשן מיט שווערע משאות, וואס מען קען זיי קוים דערטראגן, און איר אליין רירט אפילו נישט אָן די לאסטן מיט איינעם פון אייערע פינגער. ");
INSERT INTO ydd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","וויי איז צו אייך, ווייל איר בויט די קברים פון די נביאים, וואס אייערע פאטערס האבן זיי געהרגעט. ");
INSERT INTO ydd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","אָט אזוי־אָ זענט איר עדות און איר האט א וואוילגעפעלן אין די מעשים פון די פאטערס אייערע; ווייל זיי האבן זיי געטייט, איר אבער בויט די קברים. ");
INSERT INTO ydd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","צוליב דעם האט אויך די חכמה פון ה׳ געזאגט: איך וועל שיקן צו זיי נביאים און שליחים, און א טייל פון זיי וועלן זיי אומברענגען און רודפן; ");
INSERT INTO ydd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","כדי דאס בלוט פון אלע נביאים, וואס איז פארגאסן געווארן זינט דער וועלטבאשאפונג, זאל געפאדערט ווערן פון דעם דאזיקן דור, ");
INSERT INTO ydd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","פון דעם בלוט פון הבל ביז צום בלוט פון זכריה, וואס איז אומגעקומען צווישן דעם מזבח און דעם בית (המקדש); יא, איך זאג אייך, עס וועט געפאדערט ווערן פון דעם דאזיקן דור, ");
INSERT INTO ydd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","וויי צו אייך, חכמי התורה, ווייל איר האט אוועקגענומען דעם שליסל פון וויסן; אליין זענט איר נישט אריינגעגאנגען, און די, וואס האבן געוואלט אריינגיין, האט איר פארווערט! ");
INSERT INTO ydd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","און ווען ער איז ארויסגעגאנגען פון דארטן, האבן די סופרים און די פרושים אנגעהויבן צוצושטיין צו אים און אים צו שטעלן קשיות איבער מערערע זאכן מיט פארביטערונג; ");
INSERT INTO ydd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","לויערנדיק אויף אים, צו כאפן עפעס פון זיין מויל. ");
INSERT INTO ydd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","דערווייל האט זיך פארזאמלט א המון פון טויזנטער מענטשן, אזוי אז זיי האבן זיך געטרעטן איינס דאס אנדערע, האט ער אנגעהויבן צום ערשט צו זאגן צו זיינע תלמידים: היט זיך פאר דעם זויערטייג פון די פרושים, וועלכעס איז צביעות. ");
INSERT INTO ydd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","און עס איז נישטא קיין באהאלטענע זאך, וואס וועט נישט אנטפלעקט ווערן, און קיין פארבארגענע זאך, וואס וועט נישט באקאנט געמאכט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","דערפאר, אלץ וואס איר האט גערעדט אין דער פינצטערניש, וועט געהערט ווערן אין דער ליכטיקייט; און וואס איר האט געזאגט אויפן אויער בחדרי חדרים, דאס וועט אויסגערופן ווערן אויף די דעכער. ");
INSERT INTO ydd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","איך זאג אייך אבער, מיינע פריינד: האט נישט קיין מורא פאר די, וואס טייטן דעם גוף און נאך דעם זענען נישט ביכולת עפעס מער צו טאן. ");
INSERT INTO ydd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","איך וועל אייך אבער ווייזן פאר וועמען איר זאלט מורא האבן: האט מורא פאר אים, וואס נאכן טייטן, האט ער די מאכט אריינצואווארפן אין גיהנום אריין; יא, איך זאג אייך, פאר דעם דאזיקן זאלט איר מורא האבן! ");
INSERT INTO ydd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","צי פארקויפט מען דען נישט פינף פייגעלעך פאר צוויי איסרים? און קיין איינס פון זיי איז נישט פארגעסן פאר ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","נאר אפילו די האר פון אייער קאפ זענען אלע געציילט. האט נישט קיין מורא! איר זענט ווערט מער ווי א סך פייגעלעך. ");
INSERT INTO ydd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","איך זאג אייך אבער: יעדער איינער, וואס וועט זיך באקענען צו מיר פאר מענטשן, וועט אויך דער בר אנש זיך באקענען צו אים פאר די מלאכים פון ה׳; ");
INSERT INTO ydd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","דער אבער, וואס פארלייקנט מיך פאר מענטשן, וועט פארלייקנט ווערן פאר די מלאכים פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","און יעדער איינער, וואס וועט זאגן א ווארט אנטקעגן דעם בר אנש וועט עס אים פארגעבן ווערן; ווער אבער עס לעסטערט דעם רוח הקודש, דעם וועט נישט פארגעבן ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","און ווען מען פירט אייך פאר די שולן און פאר די פירשטן און פאר די געוועלטיקער, זאלט איר נישט זארגן, וויאזוי אדער מיט וואס איר זאלט זיך פארטיידיקן אדער וואס איר זאלט זאגן; ");
INSERT INTO ydd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ווארום דער רוח הקודש וועט אייך לערנען אין דער זעלביקער שעה, וואס איר דארפט זאגן. ");
INSERT INTO ydd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","און עמיצער אויס דעם המון מענטשן האט צו אים געזאגט: רבי, זאג דעם ברודער מיינעם, אז ער זאל זיך טיילן מיט מיר מיט דער ירושה! ");
INSERT INTO ydd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ער אבער האט צו אים געזאגט: מענטש, ווער האט מיך באשטימט פאר א שופט אדער צעטיילער איבער אייך? ");
INSERT INTO ydd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ער האט אבער צו זיי געזאגט: גיט אכטונג און היט זיך פאר יעדער געלטגייציקייט! ווייל דאס לעבן פון א מענטשן באשטייט נישט אין דער שפע פון זיין פארמעגן. ");
INSERT INTO ydd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","און האט זיי געזאגט א משל, אזוי צו זאגן: א געוויסן עושרס לאנד האט אריינגעברענגט א גוטן שניט; ");
INSERT INTO ydd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","און ער האט זיך מישב געווען, זאגנדיק: וואס זאל איך טאן, אז איך האב נישט וואו איינצוזאמלען מיינע פירות? ");
INSERT INTO ydd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","און האט געזאגט: דאס דאזיקע וועל איך טאן: איך וועל צעשטערן מיינע שפייכלערס און בויען גרעסערע און וועל דארטן איינזאמלען די גאנצע תבואה און די גיטער מיינע; ");
INSERT INTO ydd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","און איך וועל זאגן צו מיין זעל: נשמה מיינע, האסט א סך גוטע זאכן ליגן אויף פיל יארן; האב מנוחה, עס, טרינק און לאז דיר וואוילגיין! ");
INSERT INTO ydd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ה׳ אבער האט צו אים געזאגט: דו נאר, אין דער דאזיקער נאכט וועט דיין זעל פון דיר געפאדערט ווערן; און פאר וועמען וועט עס זיין, וואס דו האסט אנגעגרייט? ");
INSERT INTO ydd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","אָט אזוי גייט עס דעם, וואס זאמלט אוצרות פאר זיך און איז נישט רייך אין ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","און ער האט געזאגט צו זיינע תלמידים: צוליב דעם זאג איך אייך: זארגט נישט פאר אייער לעבן, וואס איר וועט עסן; אויך נישט פאר אייער גוף, וואס איר וועט זיך אנקליידן. ");
INSERT INTO ydd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ווארום דאס לעבן איז מער ווי די שפייז און דער קערפער—ווי דאס מלבוש. ");
INSERT INTO ydd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","באטראכט די ראבן! אז נישט זיי זייען, נישט זיי שניידן, זיי האבן נישט קיין קאמער, נישט קיין שייער, און ה׳ דערנערט זיי דאך; וויפל מער זענט איר ווערט ווי די פייגל? ");
INSERT INTO ydd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","און ווער פון אייך מיט זיין זארגן קען צולייגן אן אייל צו זיין געוואוקס? ");
INSERT INTO ydd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","דעריבער, אויב איר זענט נישט אפילו בכוח צו טאן דאס קלענסטע, וואס זארגט איר זיך פאר די איבריקע זאכן? ");
INSERT INTO ydd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","באטראכט די ליליעס! ווי נישט זיי שפינען, נישט זיי וועבן; און איך זאג אייך, אפילו שלמה אין זיין גאנצער פראכט איז נישט געווען אנגעקליידט ווי איינע פון די דאזיקע. ");
INSERT INTO ydd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","און אויב ה׳ קליידט אזוי דאס גראז אויפן פעלד, וואס היינט איז עס און צומארגנס ווערט עס געווארפן אין אויוון אריין, וויפל מער אייך, איר קליינגלויביקע! ");
INSERT INTO ydd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","און פרעגט נישט נאך וואס איר וועט עסן און וואס איר וועט טרינקען און רעגט זיך נישט אויף. ");
INSERT INTO ydd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ווארום צו די אלע זאכן שטרעבן די אומות העולם; אייער פאטער אבער ווייסט, אז איר דארפט די דאזיקע זאכן. ");
INSERT INTO ydd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","נאר זוכט זיין קעניגרייך און דאס וועט אייך צוגעגעבן ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","האב נישט קיין מורא, דו קליינע סטאדע; ווייל עס איז וואוילגעפעלן דעם פאטער אייערן, אייך צו געבן דאס קעניגרייך! ");
INSERT INTO ydd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","פארקויפט אייער האב און גיט צדקה; מאכט זיך בייטלען, וואס ווערן נישט אלט; אן אוצר, וואס לאזט זיך נישט אויס, אין הימל, וואו קיין גנב דערנענטערט זיך נישט און קיין מילב צעשטערט אויך נישט. ");
INSERT INTO ydd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ווארום וואו אייער אוצר איז, דארט וועט אויך אייער הארץ זיין. ");
INSERT INTO ydd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","זאלן אייערע לענדן זיין אנגעגורט און אייערע ליכט ברענען; ");
INSERT INTO ydd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","און זייט גלייך צו מענטשן, וואס ווארטן אויף זייער האר, ווען ער וועט זיך אומקערן פון דער חתונה, כדי ווען ער קומט און קלאפט אָן, זאלן זיי אים גלייך אויפעפענען. ");
INSERT INTO ydd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","וואויל איז יענע קנעכט, וועלכע ווען דער האר קומט געפינט ער זיי וואכנדיקע; באמת זאג איך אייך, ער וועט זיך ארומגארטלען און זיי אנידערזעצן צום טיש און צוגיין און זיי באדינען. ");
INSERT INTO ydd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","און אויב ער וועט קומען אינם צווייטן אדער דריטן משמר פון דער נאכט און וועט זיי אזוי געפינען, איז וואויל יענע קנעכט. ");
INSERT INTO ydd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","נאר דאס דאזיקע זאלט איר וויסן זיין, אז אויב דער בעל הבית וואלט געוואוסט אין וועלכער שעה דער גנב קומט, וואלט ער נישט דערלאזט מען זאל איינברעכן אין זיין הויז. ");
INSERT INTO ydd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","און איר זאלט זיין גרייט, ווייל דער בר אנש קומט אין א שעה, וואס איר שטעלט זיך נישט פאר. ");
INSERT INTO ydd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","און פעטרוס האט געזאגט: האר, צי זאגסטו דאס דאזיקע משל צו אונדז אדער אויך צו אלעמען? ");
INSERT INTO ydd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","און דער האר האט געזאגט: ווער זשע איז דער געטרייער און פארשטאנדיקער הויז פארוואלטער, וועלכען דער האר וועט באשטימען איבער זיין הויזגעזינד, אז ער זאל זיי געבן די מאס שפייז צו דער רעכטער צייט? ");
INSERT INTO ydd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","וואויל איז יענעם קנעכט, וואס ווען דער האר זיינער קומט, געפינט ער אים אזוי טאן. ");
INSERT INTO ydd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","באמת זאג איך אייך, אז ער וועט אים באשטימען איבער אלע זיינע גיטער. ");
INSERT INTO ydd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","אויב אבער יענער קנעכט וועט זאגן אין זיין הארצן: מיין האר זוימט זיך צו קומען; און וועט אנהויבן צו שלאגן די קנעכט און די דינסטן, אויך צו עסן און טרינקען און זיך אנצושכורן, ");
INSERT INTO ydd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","וועט דער האר פון יענעם קנעכט קומען אין א טאג, ווען ער דערווארט עס נישט און אין א שעה, וואס ער ווייסט נישט; און וועט אים צעשניידן אין צווייען און וועט לייגן זיין חלק מיט די ווידערשפעניקע. ");
INSERT INTO ydd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","יענער קנעכט אבער, וואס האט געוואוסט זיין הארס רצון און האט נישט צוגעגרייט, אדער געטאן לויט זיין ווילן, וועט ליידן א סך שלעק; ");
INSERT INTO ydd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","אבער דער, וואס האט נישט געוואוסט, און האט געטאן דאס, פאר וועלכן ער איז חייב שלעק, וועט ווייניק געשלאגן ווערן. און יעדען איינעם, וועמען א סך איז געגעבן געווארן, וועט א סך געפאדערט ווערן פון אים; און וועמען מען האט א סך אנפארטרויט, וועט מען מער פארלאנגען פון אים. ");
INSERT INTO ydd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","איך בין געקומען, צו ווארפן א פייער אויף דער ערד; און וואס וויל איך, אויב עס האט זיך שוין אנגעצונדן? ");
INSERT INTO ydd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","איך אבער האב א מקווה געטובלט צו ווערן, און ווי עס טוט מיר באנג, ביז זי וועט פארענדיקט ווערן! ");
INSERT INTO ydd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","איר מיינט, אז איך בין געקומען געבן שלום אויף דער ערד? ניין! איך זאג אייך, נאר פיל מער א מחלוקה; ");
INSERT INTO ydd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ווארום פון איצט אָן וועלן זיין פינף אין איין הויז צעטיילט; דריי קעגן צוויי, און צוויי קעגן דריי. ");
INSERT INTO ydd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","עס וועלן זיין צעטיילט פאטער קעגן זון און זון קעגן פאטער; מוטער קעגן טאכטער און טאכטער קעגן דער מוטער; שוויגער קעגן איר שנור און שנור קעגן דער שוויגער. ");
INSERT INTO ydd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","און ער האט אויך געזאגט צו די המונים מענטשן: ווען איר זעט א וואלקן אויפגיין אין מערב, זאגט איר גלייך: עס קומט א רעגן; און אזוי געשעט עס. ");
INSERT INTO ydd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","און ווען עס בלאזט א דרום ווינט, זאגט איר; עס וועט זיין א היץ; און עס געשעט. ");
INSERT INTO ydd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","איר צבועקעס, דאס אויסזען פון דער ערד און פון דעם הימל ווייסט איר אויסצופארשן; און ווי איז עס וואס איר פארשט נישט די דאזיקע צייט? ");
INSERT INTO ydd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","און פארוואס משפט איר נישט פון זיך אליין, וואס איז גערעכט? ");
INSERT INTO ydd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ווארום ווען דו גייסט מיט דיין קעגנער פארן שר, גיב דיר די מי אויפן וועג, אז דו זאלסט פטור ווערן פון אים (מיט גוטנס); טאמער וועט ער דיך אוועקשלעפן צום שופט, און דער שופט וועט דיך איבערגעבן צום שוטר, און דער שוטר וועט דיך אריינווארפן אין תפיסה אריין. ");
INSERT INTO ydd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","איך זאג דיר, דו וועסט בשום אופן פון דארטן נישט ארויס, ביז דו וועסט נישט האבן באצאלט די לעצטע פרוטה! ");
INSERT INTO ydd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","און אין דער דאזיקער צייט זענען אייניקע געקומען און האבן אים דערציילט וועגן די גלילים, וועמעס בלוט פילאטוס האט אויסגעמישט מיט זייערע קרבנות. ");
INSERT INTO ydd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","און ער האט ענטפערנדיק צו זיי געזאגט: איר מיינט (אפשר), אז די דאזיקע גלילים זענען געווען גרעסערע חוטאים ווי אלע לייט פון גליל, ווייל זיי האבן אזעלכעס געליטן? ");
INSERT INTO ydd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ניין, זאג איך אייך; נאר אויב איר וועט נישט תשובה טאן, וועט איר אלע אומקומען אויף אזא אופן. ");
INSERT INTO ydd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","אדער יענע אכצן, אויף וועלכע דער טורם איז איינגעפאלן אין שילוח און האט זיי געטייט, מיינט איר (אפשר), אז זיי זענען געווען חייב מער ווי אלע מענטשן, וואס וואוינען אין ירושלים? ");
INSERT INTO ydd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ניין, זאג איך אייך; נאר אויב איר וועט נישט תשובה טאן, וועט איר אלע אויך אזוי אומקומען! ");
INSERT INTO ydd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","און ער האט געזאגט דאס דאזיקע משל: א געוויסער מאן האט געהאט א פייגנבוים, וואס איז געווען געפלאנצט אין זיין וויינגארטן; און ער איז געקומען און האט געזוכט פירות אויף אים, און האט נישט געפונען. ");
INSERT INTO ydd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","און ער האט געזאגט צום וויינגערטנער: זע, איך קום שוין דריי יאר און זוך פירות אויף דעם דאזיקן פייגנבוים און געפין נישט. האק אים אפ! פארוואס זאל ער נאך אומנוצלעך מאכן די ערד? ");
INSERT INTO ydd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ער אבער האט ענטפערנדיק געזאגט צו אים: האר, לאז אים נאך דאס דאזיקע יאר, ביז איך וועל אים ארומגראבן און באמיסטיקן, ");
INSERT INTO ydd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","אפשר וועט ער אויף להבא ברענגען פרוכט; און אויב נישט, וועסטו אים אפהאקן! ");
INSERT INTO ydd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","און ער האט געלערנט אין איינער פון די שולן א שבתדיקן טאג. ");
INSERT INTO ydd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","און זע, דארט איז געווען א פרוי, וואס האט געהאט א גייסט פון קראנקייט אכצן יאר לאנג, און זי איז געווען צוזאמענגעקרימט און האט זיך נישט געקענט אויפשטעלן גלייך. ");
INSERT INTO ydd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","און ווי יהושע/ישוע האט זי דערזען, האט ער זי צוגערופן און צו איר געזאגט: פרוי, דו ביסט באפרייט פון דיין קראנקייט! ");
INSERT INTO ydd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","און האט ארויפגעלייגט אויף איר די הענט, און אין אן אויגנבליק איז זי אויפגעריכט געווארן און האט געלויבט ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","און דער גבאי פון דער שול, בייזערנדיק זיך צוליב דעם, וואס יהושע/ישוע האט געהיילט אום שבת, האט ענטפערנדיק געזאגט צום עולם מענטשן: עס זענען פאראן זעקס טעג, אין וועלכע מען זאל ארבעטן; קומט זשע אין די דאזיקע און לאזט זיך היילן און נישט אין טאג פון שבת! ");
INSERT INTO ydd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","אבער דער האר האט אים געענטפערט און געזאגט: צבועקעס, צי בינדט דען נישט יעדער איינער פון אייך אויף אום שבת דעם אקס זיינעם אדער דאס אייזל פון דער קאריטע און פירט עס אוועק אנצוטרינקען? ");
INSERT INTO ydd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","און זי, וואס איז א בת אברהם, וועמען דער שׂטן האט געבונדן, זע, אכצן יאר לאנג, האט זי דען נישט געזאלט אויפגעבונדן ווערן פון דער דאזיקער געבונדנקייט אין דעם טאג פון שבת? ");
INSERT INTO ydd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","און ווען ער האט דאס געזאגט, זענען אלע זיינע קעגנער פארשעמט געווארן; און דער גאנצער עולם מענטשן האט זיך געפריידט איבער אלע וואונדערלעכע מעשים, וואס זענען געשען דורך אים. ");
INSERT INTO ydd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","דעריבער האט ער געזאגט: צו וואס איז דאס קעניגרייך פון ה׳ גלייך? און צו וואס זאל איך עס פארגלייכן? ");
INSERT INTO ydd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","עס איז גלייך צו א זענעפט קערנדל, וואס א מענטש האט גענומען און אריינגעווארפן אין זיין גארטן אריין. און עס איז אויפגעוואקסן און איז געווארן א בוים, און די פייגל פון הימל האבן זיך גענעסט אין זיינע צווייגן. ");
INSERT INTO ydd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","און ווידער האט ער געזאגט: צו וואס זאל איך פארגלייכן דאס קעניגרייך פון ה׳? ");
INSERT INTO ydd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","עס איז גלייך צו זויערטייג, וואס א פרוי האט אריינגעטאן אין דריי מאס זעמלמעל, ביז דאס גאנצע וועט זויער ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","און ער איז געגאנגען איבער שטעט און דערפער לערנענדיק און מאכנדיק די נסיעה קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","און עמיצער האט צו אים געזאגט: האר, זענען עס ווייניקע, וואס ווערן דערלייזט? ער אבער האט צו זיי געזאגט: ");
INSERT INTO ydd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","שטרעבט אריינצוגיין דורך דעם ענגן טויער, ווייל א סך, זאג איך אייך, וועלן זוכן אריינצוגיין און וועלן נישט קענען. ");
INSERT INTO ydd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ווען איינמאל דער בעל הבית האט זיך אויפגעהויבן און פארשלאסן די טיר, און איר וועט אנהויבן צו שטיין אינדרויסן און קלאפן אין דער טיר און זאגן: האר, עפן אונדז אויף! און ער וועט ענטפערנדיק זאגן צו אייך: איך קען אייך נישט, פונוואנען איר זענט! ");
INSERT INTO ydd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","דעמאלט וועט איר אנהויבן צו זאגן: מיר האבן געגעסן פאר דיר און געטרונקען, און אויף אונדזערע גאסן האסטו געלערנט! ");
INSERT INTO ydd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","און ער וועט ענטפערן: איך זאג אייך, איך קען אייך נישט, פונוואנען איר זענט; אוועק פון מיר איר אלע, וואס טוט אומגערעכטיקייט! ");
INSERT INTO ydd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","דארט וועט זיין דאס קלאגן און קריצן מיט די ציין, ווען איר וועט זען אברהמן און יצחקן און יעקבן און אלע נביאים אין דעם קעניגרייך פון ה׳, אייך אליין אבער ארויסגעווארפן אינדרויסן! ");
INSERT INTO ydd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","און זיי וועלן קומען פון מזרח און מערב, פון צפון און דרום, און וועלן זיך אנידערזעצן אין דעם קעניגרייך פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","און זע, עס זענען דא לעצטע, וואס וועלן זיין די ערשטע; און עס געפינען זיך ערשטע, וואס וועלן זיין די לעצטע. ");
INSERT INTO ydd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","אין דער זעלביקער שעה זענען צוגעקומען אייניקע פרושים און האבן געזאגט צו אים: גיי ארויס און גיי אוועק פונדאנען, ווייל הורדוס וויל דיך טייטן! ");
INSERT INTO ydd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","און ער האט געזאגט צו זיי: גייט און זאגט דעם דאזיקן פוקס: זע, איך טרייב ארויס בייזע גייסטער און איך טו רפואות היינט און מארגן, און דעם דריטן טאג קום איך צום סוף. ");
INSERT INTO ydd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","דאך מוז איך היינט און מארגן און איבערמארגן וואנדערן, ווייל עס געשיקט זיך נישט, אז א נביא זאל אומקומען מחוץ לירושלים. ");
INSERT INTO ydd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","אָ ירושלים, ירושלים, וואס טייט די נביאים און שטייניקט די, וואס זענען געשיקט צו איר! וויפל מאל האב איך שוין געוואלט איינזאמלען דיינע קינדער, ווי א הון אירע עופהלעך אונטער די פליגל, און איר האט נישט געוואלט! ");
INSERT INTO ydd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","אָט ווערט אייך איבערגעלאזט אייער הויז וויסט; איך זאג אייך אבער, איר וועט מיך מער נישט זען, ביז עס וועט קומען דער טאג, ווען איר וועט זאגן: ברוך הבא בשם ה׳! (געבענטשט איז דער, וואס קומט אין נאמען פון האר ג‑ט). (תהלים קיח, כו.) ");
INSERT INTO ydd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","און עס איז געשען, ווען ער איז א שבת אריינגעגאנגען אינם הויז פון איינעם פון די הויפט פרושים, כדי צו עסן ברויט, און זיי האבן געלויערט אויף אים. ");
INSERT INTO ydd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","און זע, א מענטש, א וואסער געשווילעכץ, איז געווען פאר אים. ");
INSERT INTO ydd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","און יהושע/ישוע האט ענטפערנדיק געזאגט צו די חכמי התורה און פרושים, אזוי צו זאגן: צי מעג מען שבת היילן אדער נישט? ");
INSERT INTO ydd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","זיי אבער האבן געשוויגן. און ער האט אים גענומען און געהיילט און האט אים אוועקגעשיקט. ");
INSERT INTO ydd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","און האט צו זיי געזאגט: ווער פון אייך, וועמעס א זון אדער אן אקס איז אריינגעפאלן אין א ברונעם, און וועט ער דען אים נישט גלייך ארויסשלעפן אינם טאג פון שבת? ");
INSERT INTO ydd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","און זיי האבן אים נישט געקענט ענטפערן דערויף. ");
INSERT INTO ydd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","און ער האט געזאגט א משל צו די געסט, ווען ער האט באמערקט, ווי זיי האבן זיך אויסגעקליבן די ערטער אויבנאן; און האט געזאגט צו זיי: ");
INSERT INTO ydd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ווען דו ווערסט פון עמיצן פארבעטן אויף א חתונה, זעץ דיך נישט אנידער אויף דעם ערשטן ארט אויבנאן; טאמער וועט א חשובערער פון דיר זיין פארבעטן פון אים, ");
INSERT INTO ydd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","און דער, וואס האט דיך און אים איינגעלאדן, וועט קומען און זאגן צו דיר: גיב אים דאס ארט! און דעמאלט וועסטו אנהויבן מיט חרפה צו פארנעמען דאס לעצטע ארט. ");
INSERT INTO ydd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","נאר ווען דו ווערסט פארבעטן, גיי און זעץ דיך אויף דעם לעצטן ארט, כדי ווען דער, וואס האט דיך פארבעטן, וועט קומען, זאל ער זאגן צו דיר: פריינד רוק דיך ארויף העכער! דעמאלט וועסטו האבן כבוד פאר אלע, וואס זיצן ביים טיש מיט דיר. ");
INSERT INTO ydd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ווייל יעדער איינער, וואס דערהייבט זיך אליין, וועט דערנידעריקט ווערן, און ווער עס דערנידעריקט זיך אליין, דער וועט דערהייבט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ער האט אבער אויך געזאגט צו דעם, וואס האט אים פארבעטן: ווען דו מאכסט א מיטאג אדער אן אוונט מאלצייט, לאד נישט איין דיינע פריינד, נישט דיינע ברידער, נישט דיינע קרובים, נישט קיין רייכעס שכנים, טאמער וועלן זיי אויך דיך ווידער איינלאדן און עס וועט ווערן פאר דיר א פארגעלטונג. ");
INSERT INTO ydd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","נאר ווען דו מאכסט א שמחה, לאד איין ארעמעלייט, קאליקעס, לאמע, בלינדע, ");
INSERT INTO ydd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","און דו וועסט זיין געבענטשט; ווייל זיי האבן נישט וואס דיר צו פארגעלטן; ווארום עס וועט דיר פארגעלטן ווערן אין דער אויפשטיין תחית המתים פון די צדיקים. ");
INSERT INTO ydd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","און הערנדיק דאס, האט איינער פון די מיטזיצנדיקע געזאגט צו אים: וואויל איז דעם, וואס עסט ברויט אין דעם קעניגרייך פון ה׳! ");
INSERT INTO ydd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ער אבער האט צו אים געזאגט: א געוויסער מענטש האט געמאכט א גרויסע סעודה, און פילע פארבעטן; ");
INSERT INTO ydd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","און האט געשיקט זיין קנעכט אין דער שעה פון דער סעודה, צו זאגן צו די פארבעטענע: קומט, ווייל אלץ איז שוין גרייט! ");
INSERT INTO ydd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","און אלע ווי איינער האבן אנגעהויבן זיך צו אנטשולדיקן. דער ערשטער האט צו אים געזאגט: איך האב געקויפט א פעלד און בין געצוואונגען, ארויסצוגיין עס צו באזען; איך בעט דיך, זיי מיר מוחל! ");
INSERT INTO ydd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","און אן אנדערער האט געזאגט: איך האב געקויפט פינף יאך אקסן, און איך גיי זיי אויספרובירן; איך בעט דיך, זיי מיר מוחל! ");
INSERT INTO ydd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","נאך אן אנדערער האט געזאגט: איך האב גענומען א ווייב, און צוליב דעם קען איך נישט קומען! ");
INSERT INTO ydd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","און ווען דער קנעכט איז צוריקגעקומען, האט ער דאס דערציילט דעם האר זיינעם. דעמאלט איז דער בעל הבית צארנדיק געווארן, און האט געזאגט צו זיין קנעכט: גיי גיך ארויס אויף די גאסן און געסלעך פון דער שטאט, און ברענג אהער די ארעמעלייט און קאליקעס און בלינדע און לאמע! ");
INSERT INTO ydd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","און דער קנעכט האט געזאגט: האר, עס איז געשען, ווי דו האסט באפוילן, און עס איז נאך דא ארט! ");
INSERT INTO ydd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","און דער האר האט געזאגט צו דעם קנעכט: גיי ארויס אויף די וועגן און פלויטן און צווינג זיי אריינצוקומען, כדי מיין הויז זאל ווערן פול! ");
INSERT INTO ydd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ווארום איך זאג אייך, אז קיין איינער פון יענע מענער, וואס זענען פארבעטן געווארן, וועט נישט טועם זיין פון מיין סעודה. ");
INSERT INTO ydd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","און עס זענען מיטגעגאנגען מיט אים גרויסע מאסן מענטשן, און ער האט זיך אויסגעדרייט, און צו זיי געזאגט: ");
INSERT INTO ydd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","אויב עמיצער קומט צו מיר און האסט נישט זיין פאטער און מוטער און דאס ווייב און די קינדער און די ברידער און די שוועסטער, און דערצו אויך זיין אייגן לעבן, קען ער נישט זיין מיין תלמיד. ");
INSERT INTO ydd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ווער עס טראגט נישט זיין בוים און גייט מיר נאך, דער קען נישט זיין מיין תלמיד. ");
INSERT INTO ydd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ווארום ווער פון אייך, וועלנדיק בויען א טורם, וועט זיך נישט קודם כל אנידערזעצן און בארעכענען די קאסטן, צי ער האט צו פארענדיקן? ");
INSERT INTO ydd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","כדי טאמער, ווען ער וועט האבן געלייגט דעם פונדאמענט און נישט קענענדיק פארענדיקן, וועלן אלע, וואס זען עס, אנהויבן צו שפאטן פון אים, ");
INSERT INTO ydd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","אזוי צו זאגן: דער דאזיקער מענטש האט אנגעהויבן בויען, און נישט געקענט פארענדיקן! ");
INSERT INTO ydd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","אדער וועלכער קעניג, וואס גייט ארויס מלחמה האלטן מיט אן אנדערן קעניג, זעצט זיך נישט קודם כל אנידער צו באראטן, צי עס איז מעגלעך, מיט צען טויזנט צו באגעגענען דעם, וואס קומט קעגן אים מיט צוואנציק טויזנט? ");
INSERT INTO ydd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","אויב אבער נישט, שיקט ער שליחים צו אים בשעת יענער איז נאך ווייט, און בעט שלום. ");
INSERT INTO ydd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","דעריבער אויך אזוי יעדער איינער פון אייך, וואס וועט זיך נישט שפאטן פון אלעם, וואס ער האט, קען נישט זיין מיין תלמיד. ");
INSERT INTO ydd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","דאס זאלץ איז טאקע גוט; אויב אבער אויך דאס זאלץ זאל פארלוירן זיין טעם, מיט וואס וועט מען עס ווירצן? ");
INSERT INTO ydd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","עס טויג מער נישט פאר דער ערד, נישט פאר דעם מיסט הויפן; מען ווארפט עס ארויס. ווער עס האט אויערן צו הערן, דער זאל הערן! ");
INSERT INTO ydd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","און עס האבן זיך דערנענטערט צו אים אלע שטייער אויפמאנער און חוטאים, כדי אים צו הערן. ");
INSERT INTO ydd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","און די פרושים און סופרים האבן געמורמלט, אזוי צו זאגן: דער דאזיקער נעמט אויף חוטאים און עסט מיט זיי! ");
INSERT INTO ydd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","און ער האט געזאגט צו זיי דאס דאזיקע משל, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","וועלכער מענטש פון אייך, האבנדיק הונדערט שאף און פארלירנדיק איינע פון זיי, לאזט נישט איבער די ניין און ניינציק אין דער מדבר און גייט נאך דער פארלוירענער, ביז ער געפינט זי? ");
INSERT INTO ydd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","און ווען ער האט זי געפונען, לייגט ער זי אויף זיינע שולטער מיט שמחה; ");
INSERT INTO ydd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","און קומענדיק אהיים, רופט ער צונויף זיינע פריינד און די שכנים, און זאגט צו זיי: פריידט זיך מיט מיר, ווייל איך האב געפונען מיין שאף, וואס איז פארלוירן געגאנגען. ");
INSERT INTO ydd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","איך זאג אייך, אָט אזוי וועט זיין א שמחה אין הימל איבער איין חוטא, וואס טוט תשובה, מער ווי איבער ניין און ניינציק צדיקים, וואס דארפן נישט קיין תשובה. ");
INSERT INTO ydd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","אדער וועלכע פרוי, וואס האט צען דראכמעס, ווען זי פארלירט איין דראכמע, צינדט נישט אָן א ליכט, און קערט אויס דאס הויז, און זוכט מיט פלייס, ביז זי געפינט זי? ");
INSERT INTO ydd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","און ווען זי האט געפונען, רופט זי צונויף אירע פריינט און שכנות, און זאגט: פריידט זיך מיט מיר; ווייל איך האב געפונען די דראכמע, וואס איך האב פארלוירן! ");
INSERT INTO ydd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","אָט אזוי, זאג איך אייך, ווערט א שמחה פאר די מלאכים פון ה׳ איבער איין חוטא, וואס טוט תשובה. ");
INSERT INTO ydd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","און ער האט געזאגט: א געוויסער מענטש האט געהאט צוויי זין. ");
INSERT INTO ydd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","און דער יונגערער פון זיי האט געזאגט צום פאטער: פאטער, גיב מיר דעם חלק פארמעגן, וואס פאלט מיר צו! און ער האט זיי צעטיילט דאס האב און גוטס. ");
INSERT INTO ydd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","און אין ווייניקע טעג ארום האט דער יונגערער זון אלץ צונויפגעזאמלט, און זיך אוועקגעלאזט אין א ווייט לאנד אריין; און דארט פארשווענדט זיין פארמעגן אין אן אויסגעלאסן לעבן. ");
INSERT INTO ydd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","און ווען ער האט שוין געהאט אלץ פארברויכט, איז געווארן א שטארקער הונגער איבער יענעם גאנצן לאנדן; און ער האט אנגעהויבן צו ליידן נויט. ");
INSERT INTO ydd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","און ער איז געגאנגען און האט זיך באהאפטן צו איינעם פון די בירגער פון יענעם לאנד; און ער האט אים געשיקט אין זיינע פעלדער אריין צו פאשען חזירים. ");
INSERT INTO ydd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","און ער האט געגארט אנצופילן זיין בויך מיט די שויטן, וואס די חזירים האבן געפרעסן; און קיינער האט עס אים נישט געגעבן. ");
INSERT INTO ydd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ווען אבער ער איז געקומען צו זיך, האט ער געזאגט: אָ, וויפל לוין ארבעטער פון מיין פאטער האבן ברויט בשפע, און איך גיי דא אויס פאר הונגער! ");
INSERT INTO ydd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","איך וועל אויפשטיין און גיין צו דעם פאטער מיינעם, און וועל זאגן צו אים, פאטער, איך האב געזינדיקט קעגן הימל און פאר דיר; ");
INSERT INTO ydd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","איך בין מער נישט ווערט גערופן צו ווערן דיין זון; מאך מיך ווי איינעם פון דיינע לוין ארבעטער. ");
INSERT INTO ydd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","און ער איז אויפגעשטאנען, און איז אוועק צו זיין פאטער. בשעת אבער ער איז נאך געווען ווייט, האט דער פאטער זיינער אים געזען און האט זיך דערבארעמט, און איז געלאפן, און אים געפאלן אויף זיין האלדז, און האט אים געקושט. ");
INSERT INTO ydd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","און דער זון האט צו אים געזאגט: פאטער, איך האב געזינדיקט קעגן הימל און פאר דיר, איך בין מער נישט ווערט גערופן צו ווערן דיין זון. ");
INSERT INTO ydd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","דער פאטער אבער האט געזאגט צו זיינע קנעכט: ברענגט געשווינט ארויס דאס בעסטע מלבוש און קליידט אים אָן; און גיט אים א רינג אויף זיין האנט, און שיך אויף די פיס; ");
INSERT INTO ydd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","און ברענגט דאס געשטאפטע קאלב, שחט עס, און לאמיר עסן און זיך לאזן וואוילגיין; ");
INSERT INTO ydd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ווייל דער דאזיקער זון מיינער איז געווען טויט, און איז ווידער לעבעדיק געווארן; ער איז געווען פארלוירן, און איז געפונען געווארן. און זיי האבן אנגעהויבן זיך משמח צו זיין. ");
INSERT INTO ydd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","אבער זיין עלטערער זון איז געווען אין פעלד; און ווען ער איז געקומען און זיך דערנענטערט צום הויז, האט ער געהערט קלעזמער מוזיק און טאנץ. ");
INSERT INTO ydd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","און ער האט צוגערופן איינעם פון די קנעכט, און האט געפרעגט וואס דאס זאל באטייטן. ");
INSERT INTO ydd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","און ער האט אים געזאגט: דיין ברודער איז געקומען; און דיין פאטער האט געשחטן דאס געשטאפטע קאלב, ווייל ער האט אים צוריק באקומען א געזונטן. ");
INSERT INTO ydd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","און ער איז צארנדיק געווארן, און האט נישט געוואלט אריינגיין; זיין פאטער אבער איז ארויסגעקומען און האט אים געבעטן. ");
INSERT INTO ydd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ער אבער האט ענטפערנדיק געזאגט צום פאטער: אָט שוין אזוי פיל יארן דין איך דיך, און האב נאך קיינמאל נישט עובר געווען אויף דיינס א געבאט; און מיר האסטו נאך קיינמאל נישט געגעבן קיין ציגנבאק, כדי איך זאל מיך משמח זיין מיט מיינע פריינד; ");
INSERT INTO ydd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ווען אבער דער דאזיקער זון דיינער איז געקומען, וועלכער האט פארצערט דיין האב און גוטס מיט זונות, האסטו געשחטן פאר זיינעטוועגן דאס געשטאפטע קאלב! ");
INSERT INTO ydd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","האט ער צו אים געזאגט; מיין קינד, דו ביסט תמיד מיט מיר, און אלץ, וואס איז מיין, איז דיין. ");
INSERT INTO ydd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","מען האט זיך אבער געדארפט לאזן וואוילגיין און משמח זיין; ווייל דער דאזיקער ברודער דיינער איז געווען טויט, און איז לעבעדיק געווארן; און ער איז געווען פארלוירן און איז ווידער געפונען געווארן! ");
INSERT INTO ydd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","און ער האט אויך געזאגט צו די תלמידים: עס איז געווען א געוויסער רייכער מענטש, וואס האט געהאט א פארוואלטער; און דער דאזיקער איז פאר אים אנגעקלאגט געווארן, אז ער פארשווענדט אים זיין פארמעגן. ");
INSERT INTO ydd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","און ער האט אים גערופן און געזאגט צו אים: וואס איז דאס וואס איך הער וועגן דיר? גיב אפ א חשבון פון דיין פארוואלטונג; ווארום דו קענסט לענגער נישט זיין פארוואלטער! ");
INSERT INTO ydd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","און דער פארוואלטער האט צו זיך געזאגט; וואס זאל איך טאן? מיין האר נעמט אוועק פון מיר די פארוואלטונג! גראבן קען איך נישט; בעטלען שעם איך מיך. ");
INSERT INTO ydd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","איך ווייס, וואס איך וועל טאן, כדי ווען איך וועל אפגעשאפט ווערן פון דער פארוואלטונג, זאלן זיי מיך אויפנעמען אין זייערע הייזער אריין. ");
INSERT INTO ydd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","און ער האט גערופן צו זיך יעדן איינעם פון זיין הארס בעלי חובות, און האט געזאגט צו דעם ערשטן: וויפל ביסטו שולדיק דעם האר מיינעם? ");
INSERT INTO ydd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","האט ער געזאגט: הונדערט מאס אייל. און ער האט צו אים געזאגט: נעם דיין שטר און זעץ דיך אנידער און שרייב גיך פיפציק. ");
INSERT INTO ydd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","דערנאך האט ער געזאגט צו אן אנדערן: און וויפל ביסטו שולדיק? האט דער געזאגט: הונדערט צענטנער ווייץ. זאגט ער צו אים: נעם דיין שטר און שרייב א אכציק. ");
INSERT INTO ydd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","און דער האר האט געלויבט דעם אומגערעכטן פארוואלטער, ווייל ער האט קלוג געטאן; מחמת די קינדער פון דער דאזיקער וועלט זענען קליגער אין זייער דור ווי די קינדער פון דעם ליכט. ");
INSERT INTO ydd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","און איך זאג אייך: מאכט אייך פריינד מיט דעם ממון פון אומגערעכטיקייט, כדי ווען עס וועט אויסגיין, זאלן זיי אייך אויפנעמען אין די אייביקע וואוינונגען אריין. ");
INSERT INTO ydd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ווער עס איז געטריי אינם קלענסטן, דער איז אויך געטריי אין א סך; און ווער עס איז אומגערעכט אינם קלענסטן, דער איז אויך אומגערעכט אין א סך. ");
INSERT INTO ydd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","דעריבער אויב איר זענט נישט געווען געטריי אין דעם אומגערעכטן ממון, ווער וועט אייך אנפארטרויען דאס אמתע? ");
INSERT INTO ydd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","און אויב איר זענט נישט געווען געטריי מיט יענעמס, ווער וועט אייך געבן אייער אייגנס? ");
INSERT INTO ydd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","קיין קנעכט קען נישט דינען צוויי הארן; ווארום אדער ער וועט דעם איינעם פיינט האבן און דעם אנדערן ליב האבן, אדער ער וועט זיך באהעפטן צו איינעם און דעם אנדערן מבזה זיין, איר קענט נישט דינען ה׳ און ממון! ");
INSERT INTO ydd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","און דאס אלץ האבן די פרושים געהערט, וואס זענען געווען געלט ליבהאבער, און האבן אפגעשפאט פון אים. ");
INSERT INTO ydd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","און ער האט צו זיי געזאגט: איר זענט עס, וואס גערעכטפערטיקן זיך פאר מענטשן, ה׳ אבער קען אייערע הערצער; ווייל דאס וואס איז הויך ביי מענטשן, איז אן אומווירדיקייט פאר ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","די תורה און די נביאים זענען געווען ביז יוחנן; פון דעמאלט אָן ווערט אנגעזאגט די גוטע בשורה פון דעם קעניגרייך פון ה׳, און יעדער איינער דרינגט אריין דערין מיט געוואלד. ");
INSERT INTO ydd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","עס איז אבער לייכטער, אז דער הימל און די ערד זאלן פארגיין, ווי איין נקודה פון דער תורה זאל פאלן. ");
INSERT INTO ydd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","יעדער איינער, וואס גט זיך מיט זיין ווייב און האט חתונה מיט אן אנדערער, איז מזנה; און ווער עס האט חתונה מיט א פרוי, וואס איז געגט פון איר מאן, דער איז מזנה. ");
INSERT INTO ydd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","עס איז געווען א רייכער מענטש, וואס האט זיך געקליידט אין פורפור און אין טייערע לייוונט, און האט געלעבט טאג איין טאג אויס אין תענוגים און וואוילטאג; ");
INSERT INTO ydd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","און א געוויסער ארעמאן מיטן נאמען אלעזר איז געלעגן פאר זיין טיר פול מיט געשווירן, ");
INSERT INTO ydd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","און האט געגארט זיך צו זעטיקן פון דעם, וואס איז אראפגעפאלן פון דעם רייכנס טיש; נאר עס זענען נאך אפילו געקומען די הינט און האבן געלעקט זיינע געשווירן. ");
INSERT INTO ydd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","און עס איז געשען, דער אביון איז געשטארבן, און איז אוועקגעטראגן געווארן פון די מלאכים אין אברהמס שויס אריין. און דער עושר איז אויך געשטארבן און איז באגראבן געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","און אין שאול תחתית האט ער אויפגעהויבן זיינע אויגן, זייענדיק אין יסורים, און זעט אברהמען פונדערווייטנס און אלעזרן אין זיין שויס. ");
INSERT INTO ydd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","און ער האט א געשריי געטאן און געזאגט: פאטער אברהם, דערבארם דיך אויף מיר און שיק אלעזרן, אז ער זאל איינטונקען זיין שפיץ פינגער אין וואסער און מיר קילן מיין צונג; מחמת איך לייד פיין אין דעם דאזיקן פלאם! ");
INSERT INTO ydd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","אברהם אבער האט געזאגט: קינד, געדענק, אז דו האסט באקומען דיין גוטס ביי דיין לעבן, און אלעזר אויך אזוי דאס בייזע; איצט ווערט ער דא געטרייסט, דו אבער ווערסט געפייניקט. ");
INSERT INTO ydd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","און צו דעם אלעם איז צווישן אונדז און אייך פעסטגעלייגט א גרויסער תהום, אז די, וואס וואלטן געוואלט אריבערגיין פונדאנען צו אייך, זאלן עס נישט קענען, אויך זאל מען נישט אריבערקומען פון דארטן צו אונדז. ");
INSERT INTO ydd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","האט ער געזאגט: איך בעט דיך דעריבער, פאטער, אז דו זאלסט אים שיקן אין דעם הויז פון מיין פאטער; ");
INSERT INTO ydd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ווארום איך האב פינף ברידער; כדי ער זאל זיי ווארנען, אז זיי זאלן אויך נישט קומען צו דעם דאזיקן ארט פון פיין! ");
INSERT INTO ydd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","אברהם אבער זאגט: זיי האבן (תורת) משה און די נביאים; זאלן זיי זיי הערן. ");
INSERT INTO ydd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","און ער האט געזאגט: ניין, פאטער אברהם, נאר אויב עמיצער פון די טויטע זאל קומען צו זיי, וועלן זיי תשובה טאן! ");
INSERT INTO ydd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ער אבער האט געזאגט צו אים: אויב זיי וועלן נישט הערן משהן און די נביאים, וועלן זיי זיך אויך נישט לאזן איבערצייגן, אויב עמיצער וועט אויפשטיין פון די טויטע. ");
INSERT INTO ydd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","און ער האט געזאגט צו זיינע תלמידים: עס איז אומפארמיידלעך, אז מיכשולים זאלן נישט קומען; וויי איז אבער צו דעם, דורך וועמען זיי קומען! ");
INSERT INTO ydd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","עס וואלט געווען בעסער פאר אים, אויב א מילשטיין וואלט געלייגט געווארן ארום זיין האלדז, און ער וואלט אריינגעווארפן געווארן אין ים אריין, ווי אז ער זאל פארפירן צום שטרויכלען איינעם פון די דאזיקע קליינע. ");
INSERT INTO ydd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","גיט אכטונג אויף זיך אליין! ווען דער ברודער דיינער זינדיקט, זאלסטו אים זאגן מוסר; און אויב ער האט חרטה, זאלסטו אים מוחל זיין. ");
INSERT INTO ydd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","און ווען ער זאל זינדיקן זיבן מאל אין טאג קעגן דיר, און זיבן מאל זיך אומקערן צו דיר, אזוי צו זאגן: איך האב חרטה; זאלסטו אים פארגעבן. ");
INSERT INTO ydd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","און די שליחים האבן געזאגט צו דעם האר: פארמער אונדז דעם גלויבן! ");
INSERT INTO ydd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","און דער האר האט געזאגט: אויב איר וואלט געהאט אמונה ווי א זענעפט קערנדל, וואלט איר געזאגט צו דעם דאזיקן פייגנבוים: ווארצל דיך אויס און פארפלאנץ דיך אינם ים; און ער וואלט אייך געהארכט. ");
INSERT INTO ydd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ווער אבער פון אייך, וואס האט א קנעכט אקערן אדער פאשען, וועט זאגן צו אים, ווען ער קומט אריין פונם פעלד; גיי זעץ דיך תיכף צום טיש? ");
INSERT INTO ydd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","צי וועט ער דען נישט זאגן צו אים: גרייט מיר צו עפעס אוונט עסן, און גארטל דיך ארום, און באדין מיך, ביז איך וועל אפעסן און אפטרינקען; און דערנאך וועסטו עסן און טרינקען? ");
INSERT INTO ydd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","צי דאנקט ער דען דעם קנעכט ווייל ער האט געטאן, וואס עס איז אים באפוילן געווארן? ");
INSERT INTO ydd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","און אזוי אויך איר, ווען איר וועט האבן געטאן אלץ, וואס איז אייך באפוילן געווארן, זאלט איר זאגן: מיר זענען אומנוצלעכע קנעכט; מיר האבן געטאן וואס עס איז געווען אונדזער חוב! ");
INSERT INTO ydd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","און עס איז געשען, אויף דער נסיעה קיין ירושלים, אז ער איז דורכגעגאנגען דורך דער מיט פון שומרון און גליל. ");
INSERT INTO ydd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","און בשעת ער איז אריינגעקומען אין א געוויס דארף אריין, האבן אים באגעגענט צען מצורעים, וועלכע זענען געשטאנען פונדערווייטנס; ");
INSERT INTO ydd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","און האבן אויפגעהויבן זייער קול, אזוי צו זאגן: יהושע/ישוע, האר, האב רחמנות אויף אונדז! ");
INSERT INTO ydd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","און ווי ער האט זיי דערזען, האט ער צו זיי געזאגט: גייט, ווייזט זיך צו די כהנים! און עס איז געשען, בשעת זיי זענען אוועקגעגאנגען, זענען זיי ריין געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","איינער אבער פון זיי, זעענדיק אז ער איז געהיילט געווארן, האט זיך אומגעקערט און געלויבט ה׳ מיט א הויך קול, ");
INSERT INTO ydd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","און איז אנידערגעפאלן אויפן פנים פאר זיינע פיס, און האט אים געדאנקט; און ער איז געווען א שומרוני. ");
INSERT INTO ydd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","און יהושע/ישוע האט ענטפערנדיק געזאגט: צי זענען דען נישט די צען ריין געווארן? וואו אבער זענען די ניין? ");
INSERT INTO ydd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","צי האט זיך נישט געפונען קיינער, וואס האט זיך אומגעקערט אפצוגעבן כבוד צו ה׳, אחוץ דער דאזיקער נכרי? ");
INSERT INTO ydd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","און ער האט געזאגט צו אים: שטיי אויף און גיי; דיין אמונה האט דיך געראטעוועט! ");
INSERT INTO ydd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","און ווען ער איז געפרעגט געווארן פון די פרושים, ווען דאס קעניגרייך פון ה׳ קומט, האט ער זיי געענטפערט און געזאגט: דאס קעניגרייך קומט נישט אויף א באשיימפערלעכן אופן; ");
INSERT INTO ydd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","מען וועט נישט זאגן: זע, דא איז עס, אדער דארטן! ווארום זע, דאס קעניגרייך פון ה׳ איז אינעווייניק אין אייך. ");
INSERT INTO ydd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","צו די תלמידים אבער האט ער געזאגט: עס וועלן קומען טעג, ווען איר וועט באגערן צו זען איינעם פון די טעג פון דעם בר אנש, און איר וועט נישט זען. ");
INSERT INTO ydd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","און מען וועט זאגן צו אייך: זע, דארטן! זע, דא! גייט נישט אהין, און לויפט זיי נישט נאך. ");
INSERT INTO ydd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ווארום פונקט אזוי ווי דער בליץ, ווען ער בליצט אויף, לויכט ער פון עק הימל ביז עק הימל, אזוי וועט דער בר אנש זיין אין דעם טאג זיינעם. ");
INSERT INTO ydd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","קודם כל מוז ער אבער א סך ליידן און פארווארפן ווערן פון דעם דאזיקן דור. ");
INSERT INTO ydd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","און אזוי ווי עס איז צוגעגאנגען אין די טעג פון נוח, אזוי וועט אויך זיין אין די טעג פון דעם בר אנש: ");
INSERT INTO ydd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","מען האט געגעסן, מען האט געטרונקען, מען האט חתונה געהאט, מען האט חתונה געמאכט, ביז צו דעם טאג, ווען נוח איז אריינגעגאנגען אין דער תיבה, און דאס מבול איז געקומען, און האט אלעמען פארטיליקט. (בראשית ו.) ");
INSERT INTO ydd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","פונקט ווי עס איז צוגעגאנגען אין די טעג פון לוט: מען האט געגעסן, מען האט געטרונקען, מען האט געקויפט, מען האט פארקויפט, מען האט געפלאנצט, מען האט געבויט; ");
INSERT INTO ydd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","אין דעם טאג אבער, ווען לוט איז ארויסגעגאנגען פון סדום, האט עס גערעגנט מיט פייער און שוועבל פון הימל, און עס האט אלעמען פארטיליקט. (בראשית יט, כד-כו.) ");
INSERT INTO ydd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","אויף דעם זעלביקן אופן וועט עס זיין אין דעם טאג, ווען דער בר אנש וועט אנטפלעקט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","אין יענעם טאג, ווער עס וועט זיין אויפן דאך, און די כלים זיינע אין הויז, זאל ער נישט אראפגיין זיי נעמען: און אויך אזוי, ווער עס וועט זיין אין פעלד, דער זאל זיך נישט אומקערן צוריק. ");
INSERT INTO ydd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","געדענקט לוטס ווייב! ");
INSERT INTO ydd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ווער עס וועט זוכן צו דערהאלטן זיין לעבן, דער וועט עס פארלירן, און ווער עס וועט עס פארלירן, דער וועט עס לעבעדיק דערהאלטן. ");
INSERT INTO ydd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","איך זאג אייך, אין דער זעלביקער נאכט וועלן צוויי זיין אין איין בעט, דער איינער וועט אוועקגענומען ווערן, און דער אנדערער וועט איבערגעלאזט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","צוויי (פרויען) וועלן מאלן צוזאמען; די איינע וועט אוועקגענומען ווערן, די אנדערע אבער וועט איבערגעלאזט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","צוויי וועלן זיין אין פעלד; איינער וועט אוועקגענומען ווערן, און דער אנדערער וועט איבערגעלאזט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","און ענטפערנדיק זאגן זיי צו אים: וואו, האר? און ער האט צו זיי געזאגט: וואו דאס פגר איז, דארטן וועלן זיך אויך די אדלערס פארזאמלען. ");
INSERT INTO ydd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","און ער האט געזאגט א משל צו זיי, אז זיי דארפן תמיד תפילה טאן, און נישט מיד ווערן, ");
INSERT INTO ydd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","אזוי צו זאגן: אין א געוויסער שטאט איז געווען א שופט, וואס האט זיך נישט געפארכטן פאר ה׳ און נישט געשוינט קיין מענטשן. ");
INSERT INTO ydd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","און עס איז געווען א געוויסע אלמנה אין יענער שטאט; און זי איז געקומען צו אים און האט געזאגט: פארשאף מיר גערעכטיקייט קעגן מיין שונא! ");
INSERT INTO ydd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","און א לאנגע צייט האט ער נישט געוואלט; דערנאך אבער האט ער געזאגט צו זיך אליין: הגם איך האב נישט מורא פאר ה׳ און שויען נישט קיין מענטשן, ");
INSERT INTO ydd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","דאך, ווייל די דאזיקע אלמנה מאכט מיר מיד, וועל איך איר פארשאפן גערעכטיקייט, כדי זי זאל נישט סוף כל סוף קומען מיך שלאגן אין פנים אריין. ");
INSERT INTO ydd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","און דער האר האט געזאגט: הערט, וואס דער אומגערעכטער שופט זאגט! ");
INSERT INTO ydd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","און צי וועט דען ה׳ נישט שאפן גערעכטיקייט פאר זיינע אויסדערוויילטע, וואס רופן צו אים טאג און נאכט, אפילו ווען ער איז געדולדיק מיט זיי? ");
INSERT INTO ydd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","איך זאג אייך, ער וועט זיי אינגיכן פארשאפן גערעכטיקייט! דאך ווען דער בר אנש וועט קומען, צי וועט ער דען געפינען די אמונה אויף דער ערד? ");
INSERT INTO ydd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","און ער האט געזאגט דאס דאזיקע משל אויך צו אייניקע, וואס זענען געווען איבערצייגט וועגן זיך אליין, אז זיי זענען צדיקים און די איבריקע האבן זיי מבטל געמאכט: ");
INSERT INTO ydd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","צוויי מענטשן זענען ארויפגעגאנגען אין בית המקדש אריין תפילה טאן, איינער א פרוש, דער אנדערער א שטייער אויפמאנער. ");
INSERT INTO ydd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","דער פרוש האט זיך אוועקגעשטעלט און אזוי מתפלל געווען צו זיך אליין: אָ, ה׳, איך דאנק דיר, וואס איך בין נישט אזוי ווי די איבריקע מענטשן, גזלנים, רשעים, נואפים, אדער אפילו ווי דער דאזיקער שטייער אויפמאנער. ");
INSERT INTO ydd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","איך פאסט צוויי מאל אין דער וואך; איך גיב מעשר פון אלעם, וואס איך דערווערב. ");
INSERT INTO ydd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","און דער שטייער אויפמאנער איז געשטאנען פונדערווייטנס, האט אפילו נישט געוואלט אויפהויבן די אויגן צום הימל, נאר האט זיך געשלאגן אויף זיין ברוסט, אזוי צו זאגן: אָ, ה׳, זיי מיר מוחל, דעם חוטא! ");
INSERT INTO ydd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","איך זאג אייך, דער דאזיקער איז אראפגעגאנגען אהיים מער גערעכטפערטיקט ווי יענער. ווייל יעדער איינער, וואס דערהייבט זיך אליין, וועט דערנידעריקט ווערן; און ווער עס דערנידעריקט זיך אליין, דער וועט דערהייבט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","און מען האט אויך געברענגט קליינע קינדער צו אים, אז ער זאל זיי אנרירן; די תלמידים אבער זעענדיק דאס, האבן אנגעשריגן אויף זיי. ");
INSERT INTO ydd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","יהושע/ישוע אבער האט זיי צוגערופן, זאגנדיק: לאזט די קינדער קומען צו מיר, און פארווערט עס זיי נישט; ווארום פון אזעלכע איז דאס קעניגרייך פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","באמת זאג איך אייך: ווער עס וועט נישט אננעמען דאס קעניגרייך פון ה׳ ווי א קינד, דער וועט בשום אופן נישט אריינקומען דערין. ");
INSERT INTO ydd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","און א געוויסער שר האט אים געפרעגט, אזוי צו זאגן: רבי גוטער, וואס זאל איך טאן, כדי איך זאל ירשענען אייביק לעבן? ");
INSERT INTO ydd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","און יהושע/ישוע האט צו אים געזאגט: פארוואס רופסטו מיך גוטער? קיינער איז נישט גוט, אחוץ איינער—ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","די געבאטן קענסטו דאך: זאלסט נישט נואפן; זאלסט נישט מארדן; זאלסט נישט גנבענען; זאלסט נישט פאלש עדות זאגן; זאלסט אפגעבן כבוד דעם פאטער דיינעם און די מוטער. (שמות כ, יב-טז.) ");
INSERT INTO ydd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","און ער האט געזאגט: דאס אלץ האב איך אפגעהיטן פון יונגווייז אָן. ");
INSERT INTO ydd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ווי אבער יהושע/ישוע האט דאס געהערט, האט ער געזאגט צו אים: נאך איין זאך פעלט דיר: פארקויף אלץ, וואס דו האסט און צעטייל עס צו ארעמעלייט, און דו וועסט האבן אן אוצר אין הימל; און קום, פאלג מיר נאך! ");
INSERT INTO ydd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ווי נאר ער האט דאס געהערט, איז ער געווארן זייער טרויעריק; ווארום ער איז געווען זייער רייך. ");
INSERT INTO ydd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","און יהושע/ישוע האט אויף אים געקוקט און געזאגט: אָ, ווי שווער עס איז פאר די, וואס האבן פארמעגנס, אריינצוקומען אין ה׳ס קעניגרייך אריין! ");
INSERT INTO ydd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ווארום עס איז לייכטער פאר א קעמל אריינצוגיין דורך דעם לאך פון א נאדל, ווי פאר אן עושר אריינצוגיין אין דעם קעניגרייך פון ג‑ט. ");
INSERT INTO ydd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","האבן די צוהערער געזאגט: טא ווער זשע קען דערלייזט ווערן? ");
INSERT INTO ydd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ער אבער האט געזאגט: דאס, וואס איז ביי מענטשן אוממעגלעך, איז יא מעגלעך ביי ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","און פעטרוס האט געזאגט: זע, מיר האבן איבערגעלאזט אונדזער אייגנס און האבן דיר נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ער אבער האט צו זיי געזאגט: באמת זאג איך אייך: עס איז נישט פאראן אזעלכער, וואס האט פארלאזט א הויז, אדער א פרוי, אדער ברידער, אדער עלטערן, אדער קינדער, צוליב דעם קעניגרייך פון ה׳, ");
INSERT INTO ydd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","וואס וועט נישט באקומען כפלי כפלים אין דער דאזיקער צייט, און אויף עולם הבא אייביק לעבן. ");
INSERT INTO ydd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","און ער האט גענומען די צוועלף צו זיך און האט צו זיי געזאגט: זע, מיר גייען ארויף קיין ירושלים, און עס וועט דערפילט ווערן אלץ, וואס איז געשריבן געווארן דורך די נביאים וועגן דעם בר אנש. (ישעיהו נג, א-יב.) ");
INSERT INTO ydd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ווארום ער וועט איבערגעגעבן ווערן צו די אומות (העולם), און וועט אפגעשפאט, און באליידיקט, און באשפיגן ווערן; (ישעיהו נ, ו.) ");
INSERT INTO ydd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","און זיי וועלן אים געבן שלעק און אים טייטן, און דעם דריטן טאג וועט ער ווידער אויפשטיין. (תהלים טז, י.) ");
INSERT INTO ydd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","און זיי האבן נישט פארשטאנען קיין זאך פון די דאזיקע, און דאס דאזיקע ווארט איז געווען פארהוילן פון זיי, און זיי האבן נישט געוואוסט וואס עס איז געזאגט געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","און עס איז געשען, בשעת ער האט זיך דערנענטערט קיין יריחו, איז איינער א בלינדער געזעסן ביים וועג און געבעטלט. ");
INSERT INTO ydd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","און היות ער האט געהערט א המון מענטשן פארבייגיין, האט ער זיך געפרעגט, וואס עס איז. ");
INSERT INTO ydd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","און מען האט אים געזאגט, אז יהושע/ישוע פון נצרת גייט פארביי. ");
INSERT INTO ydd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","און ער האט א געשריי געטאן, אזוי צו זאגן: יהושע/ישוע בן דוד, האב רחמנות אויף מיר! ");
INSERT INTO ydd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","און די, וואס זענען געגאנגען פארויס, האבן אנגעשריגן אויף אים, אז ער זאל שווייגן; ער אבער האט נאך פיל מער געשריגן; בן דוד, האב רחמנות אויף מיר! ");
INSERT INTO ydd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","און יהושע/ישוע האט זיך אפגעשטעלט און באפוילן מען זאל אים ברענגען צו אים. און ווי ער האט זיך דערנענטערט, האט ער אים געפרעגט: ");
INSERT INTO ydd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","וואס ווילסטו איך זאל טאן פאר דיר? און ער האט געזאגט: האר, אז איך זאל ווערן זעענדיק! ");
INSERT INTO ydd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","און יהושע/ישוע האט צו אים געזאגט; באקום דיין זעענדיק! דיין גלויבן האט דיר געהאלפן! ");
INSERT INTO ydd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","און תיכף ומיד איז ער זעענדיק געווארן, און האט אים נאכגעפאלגט, לויבנדיק ה׳; און דאס גאנצע פאלק, וואס האט דאס געזען, האט אפגעגעבן א שבח צו ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","און ער איז אריינגעקומען און איז דורכגעגאנגען דורך יריחו. ");
INSERT INTO ydd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","און זע, א מאן, וואס מען האט אים גערופן מיט דעם נאמען זכי, און ער איז געווען א ראש שטייער אויפמאנער, און אן עושר; ");
INSERT INTO ydd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","און האט באגערט צו זען יהושען/ישוען, ווער ער איז, און האט נישט געקענט מחמת דעם המון מענטשן, ווייל ער איז געווען קליין פון געוואוקס. ");
INSERT INTO ydd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","און ער איז געלאפן פארויס, און האט ארויפגעקלעטערט אויף א שקמה בוים, כדי אים צו זען; ווייל ער האט דארטן געזאלט פארבייגיין. ");
INSERT INTO ydd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","און ווי יהושע/ישוע איז געקומען צו דעם ארט, האט ער ארויפגעבליקט און געזאגט צו אים: זכי, קום געשווינט אראפ; ווארום היינט מוז איך איינשטיין ביי דיר אין הויז! ");
INSERT INTO ydd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","און ער איז גיך אראפגעשטיגן, און האט אים אויפגענומען מיט פרייד. ");
INSERT INTO ydd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","און זעענדיק דאס, האבן אלע געמורמלט, אזוי צו זאגן: ביי אן איש חוטא איז ער אריינגעגאנגען זיך אויפצוהאלטן! ");
INSERT INTO ydd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","זכי אבער האט זיך אנידערגעשטעלט און געזאגט צום האר: זע, די העלפט פון מיין פארמעגן, האר, גיב איך צו די ארעמעלייט, און אויב איך האב ביי עמיצן עפעס ארויסגעפרעסט, גיב איך אים אפ פיר מאל אזויפיל. ");
INSERT INTO ydd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","יהושע/ישוע האט אבער צו אים געזאגט: היינט איז א ישועה געקומען אויף דעם דאזיקן הויז, ווייל אפילו ער איז א בן אברהם; ");
INSERT INTO ydd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ווארום דער בר אנש איז געקומען צו זוכן און צו ראטעווען דאס, וואס איז פארלוירן געגאנגען. ");
INSERT INTO ydd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","און ווען זיי האבן דאס געהערט, האט ער ווידער געזאגט א משל, צוליב דעם וואס ער איז געווען נאענט צו ירושלים, און זיי האבן געמיינט, אז דאס קעניגרייך פון ה׳ מוז באלד דערשיינען. ");
INSERT INTO ydd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ער האט דעריבער געזאגט: א געוויסער איידלמאן איז אוועק אין א ווייט לאנד אריין, צו נעמען פאר זיך א מלכות, און זיך אומצוקערן. ");
INSERT INTO ydd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","און ער האט גערופן צען קנעכט זיינע, און זיי געגעבן צען מנים, און געזאגט צו זיי: האנדלט, ביז איך קום צוריק. ");
INSERT INTO ydd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","זיינע בירגער אבער האבן אים געהאסט, און האבן געשיקט שליחים נאך אים, אזוי צו זאגן: מיר ווילן נישט, אז דער דאזיקער זאל קעניגן איבער אונדז! ");
INSERT INTO ydd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","און עס איז געשען, ווען ער איז צוריקגעקומען, נאך דעם ווי ער האט גענומען דאס מלכות, האט ער געהייסן רופן די דאזיקע קנעכט זיינע צו זיך, צו וועלכע ער האט געגעבן דאס געלט, כדי ער זאל וויסן ווער עס האט וואס איינגעהאנדלט. ");
INSERT INTO ydd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","און דער ערשטער איז געקומען, און האט געזאגט: האר, דיין מנה האט אריינגעברענגט צען מנים! ");
INSERT INTO ydd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","און ער האט צו אים געזאגט: וואויל, דו גוטער קנעכט! ווייל דו ביסט געווען געטריי איבער ווייניק, זאלסטו האבן מאכט איבער צען שטעט! ");
INSERT INTO ydd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","און דער צווייטער איז געקומען, און האט געזאגט: דיין מנה, האר, האט דערווארבן פינף מנים! ");
INSERT INTO ydd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","און ער האט געזאגט אויך צו דעם דאזיקן: און דו זאלסט זיין איבער פינף שטעט! ");
INSERT INTO ydd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","און אן אנדערער איז געקומען, און האט געזאגט: האר, אָט איז דיין מנה, וואס איך האב געהאט באהאלטן אין א טיכל! ");
INSERT INTO ydd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ווארום איך האב מיך געפארכטן פאר דיר, ווייל דו ביסט א שטרענגער מענטש; דו נעמסט, וואס דו האסט נישט אנידערגעלייגט, און שניידסט דאס, וואס דו האסט נישט פארזייט. ");
INSERT INTO ydd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","זאגט ער צו אים: אויס דיין אייגן מויל וועל איך דיך משפטן, דו געמיינער קנעכט! דו האסט געוואוסט, אז איך בין א שטרענגער מענטש, איך נעם, וואס איך האב נישט אנידערגעלייגט, און שנייד, וואס איך האב נישט פארזייט; ");
INSERT INTO ydd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","און פארוואס האסטו נישט אריינגעגעבן מיין געלט אין א באנק, און איך וואלט עס ביי מיין צוריק קער אויפגעמאנט מיט צינזן? ");
INSERT INTO ydd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","און ער האט געזאגט צו די, וואס זענען געשטאנען ארום: נעמט אוועק פון אים די מנה, און גיט זי צו דעם, וואס האט די צען מנים! ");
INSERT INTO ydd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","און זיי האבן געזאגט צו אים: האר, ער האט דאך שוין צען מנים. ");
INSERT INTO ydd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","איך זאג אייך, אז יעדן איינעם, וואס האט, וועט געגעבן ווערן; פון דעם אבער, וואס האט נישט, וועט אפילו אוועקגענומען ווערן דאס, וואס ער האט יא. ");
INSERT INTO ydd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","דאך די דאזיקע שונאים מיינע, וואס האבן נישט געוואלט, אז איך זאל קעניגן איבער זיי, ברענגט אהער, און דערהרגעט זיי פאר מיר! ");
INSERT INTO ydd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","און ווען ער האט דאס געזאגט, איז ער אוועק פארויס, און איז ארויפגעגאנגען קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","און עס איז געשען, ווען ער האט זיך דערנענטערט קיין בית‑פגי און בית‑היני ביים בארג, וואס האט געהייסן הר הזיתים, האט ער געשיקט צוויי פון די תלמידים, ");
INSERT INTO ydd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","און געזאגט: גייט אריין אין דעם דארף אנטקעגנאיבער; און ווען איר וועט דארט אריינקומען, וועט איר געפינען א יונג אייזל אנגעבונדן, אויף וועלכן קיין מענטש איז נאך קיינמאל נישט געזעסן; בינדט עס אויף און ברענגט עס צו אהער. ");
INSERT INTO ydd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","און אויב עמיצער וועט אייך פרעגן: פארוואס בינדט איר עס אויף? זאלט איר אזוי זאגן: דער האר דארף עס האבן! ");
INSERT INTO ydd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","און די שליחים זענען אהינגעגאנגען, און האבן געפונען אזוי ווי ער האט זיי געזאגט. ");
INSERT INTO ydd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","און ווען זיי האבן אויפגעבונדן דאס יונגע אייזל, האבן זיינע בעלי בתים געזאגט צו זיי: פארוואס בינדט איר אויף דאס אייזל? ");
INSERT INTO ydd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","און זיי האבן געזאגט: דער האר דארף עס האבן! ");
INSERT INTO ydd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","און זיי האבן עס געברענגט צו יהושען/ישוען, און האבן ארויפגעווארפן זייערע מלבושים אויף דעם אייזל, און ארויפגעזעצט יהושען/ישוען דערויף. (זכריה ט, ט.) ");
INSERT INTO ydd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","און בשעת ער איז געגאנגען, האבן זיי אויסגעשפרייט זייערע קליידער אויפן וועג. ");
INSERT INTO ydd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","און ווען ער האט זיך שוין דערנענטערט צום אראפגאנג פון דעם הר הזיתים, האט די גאנצע מאסע תלמידים אנגעהויבן פריידיק צו לויבן ה׳ מיט א הויך קול פאר אלע גבורות, וואס זיי האבן געזען, ");
INSERT INTO ydd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","און האבן געזאגט: געבענטשט איז דער קעניג, וואס קומט אינם נאמען פון דעם האר (ה׳); שלום אין הימל, און כבוד אין די הויכקייטן! ");
INSERT INTO ydd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","און אייניקע פון די פרושים אויס דעם המון מענטשן האבן געזאגט צו אים: רבי, שריי אָן אויף דיינע תלמידים! ");
INSERT INTO ydd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","און ער האט ענטפערנדיק געזאגט: איך זאג אייך: אויב די דאזיקע שווייגן, וועלן די שטיינער שרייען! ");
INSERT INTO ydd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","און ווי ער איז צוגעקומען נענטער און האט געזען די שטאט, האט ער זיך צעוויינט איבער איר, ");
INSERT INTO ydd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","אזוי צו זאגן, אָ, ווען אויך דו וואלסט געוואוסט אין דעם דאזיקן טאג דאס, וואס האט א שייכות צו דיין שלום! איצט אבער איז עס פארהוילן פון דיינע אויגן. ");
INSERT INTO ydd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","עס וועלן קומען טעג אויף דיר, און דיינע שונאים וועלן ווארפן א וואל ארום דיר, און וועלן דיך ארומרינגלען, און באלאגערן פון אלע זייטן; ");
INSERT INTO ydd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","און וועלן דיך מאכן מיט דער ערד צוגלייך, און דיינע קינדער אין דיר; און וועלן נישט איבערלאזן א שטיין אויף א שטיין אין דיר, דערפאר וואס דו האסט נישט דערקענט די צייט פון דיין באזוכט ווערן! ");
INSERT INTO ydd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","און ער איז אריינגעגאנגען אין בית המקדש, און האט אנגעהויבן ארויסצוטרייבן די הענדלער, ");
INSERT INTO ydd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","זאגנדיק צו זיי: עס שטייט געשריבן: מיין הויז וועט זיין א הויז פון תפילה (ישעיהו נו, ז.); איר אבער האט דערפון געמאכט א הייל פון רויבער! (ירמיהו ז, יא.) ");
INSERT INTO ydd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","און ער האט געלערנט טאג טעגלעך אין בית המקדש; די הויפט כהנים אבער און די סופרים און די ראשים פונם פאלק האבן געזוכט אים אומצוברענגען. ");
INSERT INTO ydd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","און האבן נישט געפונען, וואס זיי זאלן טאן; ווארום דאס גאנצע פאלק האט זיך צוגעהערט צו אים מיט גרויסער ערנסטקייט. ");
INSERT INTO ydd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","און עס איז געשען, אין איינעם פון די טעג, בשעת ער האט געלערנט דאס פאלק אין בית המקדש, און אנגעזאגט די גוטע בשורה, זענען די הויפט כהנים און די סופרים און די זקנים צוגעטרעטן ");
INSERT INTO ydd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","און האבן געזאגט צו אים, אזוי צו זאגן: זאג אונדז, מיט וועמעס רשות טוסטו די דאזיקע זאכן? אדער ווער איז עס, וואס האט דיר געגעבן דאס דאזיקן רשות? ");
INSERT INTO ydd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ער אבער האט ענטפערנדיק געזאגט צו זיי: איך וועל אייך אויך פרעגן א שאלה! און זאגט מיר: ");
INSERT INTO ydd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","די מקווה פון יוחנן איז געווען פון הימל אדער פון מענטשן? ");
INSERT INTO ydd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","און זיי האבן עס איבערגעלייגט צווישן זיך, אזוי צו זאגן: וועלן מיר זאגן: פון הימל, וועט ער זאגן: טא פארוואס האט איר אים נישט געגלויבט? ");
INSERT INTO ydd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","וועלן מיר אבער זאגן: פון מענטשן, וועט דאס גאנצע פאלק אונדז שטייניקן, ווארום עס איז בטוח, אז יוחנן איז געווען א נביא. ");
INSERT INTO ydd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","און זיי האבן געענטפערט, אז זיי ווייסן נישט פונוואנען. ");
INSERT INTO ydd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","און יהושע/ישוע האט צו זיי געזאגט: זאג איך אייך אויך נישט מיט וועמעס רשות איך טו די דאזיקע זאכן. ");
INSERT INTO ydd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","און ער האט אנגעהויבן צו זאגן צום פאלק דאס דאזיקע משל: א מענטש האט געפלאנצט א וויינגארטן, און אים פארדונגען צו גערטנער, און איז אוועקגעפארן אויף א לאנגער צייט. ");
INSERT INTO ydd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","און צום זמן האט ער געשיקט א קנעכט צו די גערטנער, אז זיי זאלן אים געבן פון דער פרוכט פון דעם וויינגארטן; די גערטנער אבער האבן אים געשלאגן, און אוועקגעשיקט מיט גארנישט. ");
INSERT INTO ydd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","און ער האט געמערט צו שיקן אן אנדערן קנעכט; זיי אבער האבן אויך יענעם געשלאגן און אנגעטאן אים בזיונות, און אוועקגעשיקט מיט גארנישט. ");
INSERT INTO ydd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","און ער האט מוסיף געווען צו שיקן א דריטן; אבער אויך דעם דאזיקן האבן זיי בלוטיק צעשלאגן און ארויסגעווארפן. ");
INSERT INTO ydd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","און דער האר פון דעם וויינגארטן האט געזאגט: וואס זאל איך טאן? איך וועל שיקן מיין געליבטן זון; אפשר וועלן זיי אים שוינען. ");
INSERT INTO ydd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","נאר ווי די גערטנער האבן אים דערזען, האבן זיי זיך איבערגעלייגט איינער מיטן אנדערן, און געזאגט: דער דאזיקער איז דער יורש; לאמיר אים טייטן; כדי די ירושה זאל ווערן אונדזער. ");
INSERT INTO ydd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","און זיי האבן אים ארויסגעווארפן אויסער דעם וויינגארטן, און אים דערהרגעט. וואס זשע וועט דער האר פון דעם וויינגארטן טאן צו זיי? ");
INSERT INTO ydd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ער וועט קומען און אומברענגען די דאזיקע גערטנער, און דעם וויינגארטן געבן צו אנדערע. און ווען זיי האבן דאס געהערט, האבן זיי געזאגט: חלילה! ");
INSERT INTO ydd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ער אבער האט אויף זיי געקוקט, און געזאגט; וואס דען איז דאס דאזיקע, וואס שטייט געשריבן; א שטיין, וועלכן די בוימייסטערס האבן פארווארפן, דער דאזיקער איז געווארן צום הויפט פונם ווינקל? ");
INSERT INTO ydd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","יעדער איינער, וואס פאלט אויף יענעם שטיין, וועט צעשמעטערט ווערן; אויף וועמען אבער ער וועט פאלן, וועט ער אים צעמאלן. ");
INSERT INTO ydd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","און די סופרים און די הויפט כהנים האבן געזוכט צו לייגן די הענט אויף אים אין דער זעלביקער שעה; און האבן מורא געהאט פאר דעם פאלק; ווארום זיי האבן איינגעזען, אז ער האט געזאגט דאס דאזיקע משל אויף זיי. ");
INSERT INTO ydd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","און זיי האבן געלויערט אויף אים, און געשיקט שפיאנען, וואס האבן זיך פארשטעלט פאר צדיקים, כדי אים צו פאנגען מיט א ווארט, אז זיי זאלן אים איבערגעבן צו דער ממשלה און דער מאכט פון דעם גובערנאטאר. ");
INSERT INTO ydd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","און זיי האבן אים געפרעגט, אזוי צו זאגן: רבי, מיר ווייסן, אז דו רעדסט און לערנסט ריכטיק, און ביסט נישט נושא פנים, נאר לערנסט אויף אן אמת דעם וועג פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","מעגן מיר געבן שטייער צום קיסר, אדער נישט? ");
INSERT INTO ydd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ער אבער האט פארשטאנען זייער כיטרעקייט, און האט צו זיי געזאגט: ");
INSERT INTO ydd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ווייזט מיר א דינר. וועמעס בילד און אויפשריפט האט ער? און זיי האבן געזאגט: דעם קיסרס. ");
INSERT INTO ydd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","און ער האט צו זיי געזאגט: דעריבער גיט אפ דעם קיסר דאס, וואס איז דעם קיסרס, און צו ה׳ דאס, וואס איז ה׳ס! ");
INSERT INTO ydd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","און זיי האבן אים נישט געקענט פאנגען מיט קיין ווארט פאר דעם פאלק; און האבן זיך געוואונדערט אויף זיין ענטפער, און האבן געשוויגן. ");
INSERT INTO ydd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","און עס זענען צוגעקומען צו אים אייניקע פון די צדוקים, וועלכע זאגן, אז עס איז נישטא קיין תחית המתים; ");
INSERT INTO ydd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","און האבן אים געפרעגט, אזוי צו זאגן: רבי, משה האט אונדז געשריבן; אויב עמיצנס ברודער וועט שטארבן, האבנדיק א ווייב, און איז אָן א קינד, זאל זיין ברודער נעמען די פרוי, און אויפשטעלן זאמען צו זיין ברודער. (דברים כה, ה-ו.) ");
INSERT INTO ydd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","אָט זענען געווען זיבן ברידער; און דער ערשטער האט גענומען א ווייב, און איז געשטארבן אָן קינדער; ");
INSERT INTO ydd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","און דער צווייטער; ");
INSERT INTO ydd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","און דער דריטער האט זי גענומען; און אזוי א האבן אויך די זיבן נישט איבערגעלאזט קיין קינדער, און זענען געשטארבן. ");
INSERT INTO ydd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","צום סוף איז אויך די פרוי געשטארבן. ");
INSERT INTO ydd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","וועמעס ווייב פון זיי וועט דעריבער די פרוי זיין נאך תחית המתים? ווארום די זיבן האבן זי געהאט פאר א ווייב. ");
INSERT INTO ydd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","און יהושע/ישוע האט צו זיי געזאגט: די קינדער פון דער דאזיקער וועלט האבן חתונה, און ווערן חתונה געמאכט; ");
INSERT INTO ydd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","די אבער, וואס זענען ווערט צו דערגרייכן יענע וועלט און תחית המתים, האבן נישט חתונה, און ווערן נישט חתונה געמאכט; ");
INSERT INTO ydd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ווארום זיי קענען מער נישט שטארבן; ווארום זיי זענען גלייך צו די מלאכים; און זענען ה׳ס קינדער, זייענדיק קינדער פון תחית המתים. ");
INSERT INTO ydd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","און אז די טויטע שטייען אויף, האט אויך משה מרמז געווען ביים סנה, ווען ער רופט דעם האר דעם ג‑ט פון אברהם און דעם ג‑ט פון יצחק און דעם ג‑ט פון יעקב. (שמות ג, ו.) ");
INSERT INTO ydd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ער אבער איז דער ג‑ט, נישט פון טויטע, נאר פון לעבעדיקע; ווארום אלע לעבן פאר אים. ");
INSERT INTO ydd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","און אייניקע פון די סופרים האבן ענטפערנדיק געזאגט: רבי, דו האסט וואויל געזאגט! ");
INSERT INTO ydd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ווארום זיי האבן זיך מער נישט אונטערגעשטעלט, אים עפעס צו פרעגן. ");
INSERT INTO ydd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ער אבער האט צו זיי געזאגט: ווי אזוי זאגט מען, אז דער משיח איז דודס זון? ");
INSERT INTO ydd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","דוד אליין זאגט דאך אינם ספר תהלים: דער האר האט געזאגט צו מיין האר: זיץ ביי מיין רעכטער זייט, ");
INSERT INTO ydd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ביז איך וועל אנידערלייגן דיינע פיינט פאר א פוסבענקעלע צו דיינע פיס. ");
INSERT INTO ydd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","דוד רופט אים דעריבער האר; און וויאזוי זשע איז ער זיין זון? ");
INSERT INTO ydd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","און בעת דאס גאנצע פאלק האט זיך צוגעהערט, האט ער געזאגט צו די תלמידים: ");
INSERT INTO ydd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","היט זיך פאר די סופרים, וואס ווילן ארומגיין אין טליתים, און האבן ליב מען זאל זיי אפגעבן שלום אויף די מערקפלעצער, און די ערשטע ערטער אין שול, און פלעצער אויבנאן אויף סעודות; ");
INSERT INTO ydd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","זיי פארצערן די הייזער פון אלמנות, און פאר אן אויסרייד דאווענען זיי לאנג; זיי וועלן באקומען א הארבער משפט. ");
INSERT INTO ydd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","און א בליק טוענדיק, האט ער געזען ווי די עשירים ווארפן אריין זייערע נדבות אין דער שאצקאמער. ");
INSERT INTO ydd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","און האט געזען א געוויסע נויטבאדערפטיקע אלמנה אריינווארפן דארטן צוויי פרוטות. ");
INSERT INTO ydd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","און ער האט געזאגט: באמת זאג איך אייך: די דאזיקע ארעמע אלמנה האט אריינגעווארפן מער ווי אלע; ");
INSERT INTO ydd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ווארום אלע די דאזיקע האבן אריינגעווארפן צו די נדבות פון זייער עודף; זי אבער האט פון איר נויט אריינגעווארפן אלץ, וואס זי האט געהאט צום לעבן. ");
INSERT INTO ydd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","און ווען אייניקע האבן געזאגט וועגן דעם בית המקדש, אז עס איז באצירט מיט הערלעכע שטיינער און מיט מתנות, האט ער געזאגט: ");
INSERT INTO ydd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","די דאזיקע זאכן, וואס איר זעט, עס וועלן קומען טעג, אין וועלכע עס וועט דא נישט איבערגעלאזט ווערן א שטיין אויף א שטיין, וואס וועט נישט אנידערגעריסן ווערן! ");
INSERT INTO ydd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","האבן זיי אים געפרעגט, אזוי צו זאגן: רבי, און ווען וועט דאס זיין? און וואס איז דער סימן ווען דאס דארף געשען? ");
INSERT INTO ydd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","און ער האט געזאגט: גיט אכטונג, אז איר זאלט נישט פארפירט ווערן; ווארום א סך וועלן קומען אין מיין נאמען, און זאגן: איך בין עס און די צייט האט גענענט! איר זאלט זיי נישט נאכגיין! ");
INSERT INTO ydd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ווען אבער איר וועט הערן פון מלחמות און מהומות, זאלט איר זיך נישט שרעקן, ווארום דאס מוז קודם כל געשען; נאר דער קץ איז נישט באלד. ");
INSERT INTO ydd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","דעמאלט האט ער געזאגט צו זיי: א פאלק וועט אויפשטיין קעגן א פאלק, און א מלוכה קעגן א מלוכה; ");
INSERT INTO ydd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","עס וועלן זיין געוואלדיקע ערדציטערנישן, און דא און דארטן הונגער און מגפות; און שרעקלעכע זאכן און גרויסע צייכנס פון הימל וועלן זיין. ");
INSERT INTO ydd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","פאר דעם אלעם אבער וועלן זיי לייגן אויף אייך זייערע הענט, און אייך פארפאלגן, און וועלן אייך איבערגעבן צו די שולן און תפיסות און אייך פירן פאר מלכים און מושלים צוליב מיין נאמען. ");
INSERT INTO ydd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","דאס וועט אויספאלן פאר אייך צום עדות זאגן. ");
INSERT INTO ydd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","נעמט זשע עס אייך צום הארצן, נישט צו זארגן פארויס, וויאזוי זיך צו פארטיידיקן; ");
INSERT INTO ydd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ווארום איך וועל אייך געבן א מויל און חכמה, וואס אלע אייערע קעגנער וועלן זיך נישט קענען אנטקעגנשטעלן אדער ווידערשפרעכן. ");
INSERT INTO ydd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","איר וועט אבער איבערגעגעבן ווערן אפילו פון עלטערן, און ברידער, און קרובים, און פריינד; און א טייל פון אייך וועלן זיי טייטן. ");
INSERT INTO ydd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","און איר וועט זיין געהאסט פון אלעמען צוליב מיין נאמען. ");
INSERT INTO ydd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","און קיין האר פון אייער קאפ וועט נישט פארלוירן ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","דורך אייער סבלנות וועט איר געווינען אייערע לעבנס! ");
INSERT INTO ydd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","און ווען איר וועט זען ירושלים באלעגערט מיט חיילות, זאלט איר דעמאלט וויסן, אז איר פארוויסטונג האט זיך דערנענטערט. ");
INSERT INTO ydd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","דעמאלט זאלן די, וואס זענען אין (לאנד) יהודה, אנטלויפן צו די בערג; און די, וואס זענען אין איר מיט, זאלן אויסוואנדערן; און די, וואס זענען אויפן לאנד, זאלן נישט אריינגיין אין איר. ");
INSERT INTO ydd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ווייל זיי זענען טעג פון נקמה, כדי עס זאל דערפילט ווערן אלץ, וואס שטייט געשריבן. ");
INSERT INTO ydd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","וויי איז צו די טראגעדיקע פרויען און אנזויגערינס אין יענע טעג! ווארום עס וועט זיין א גרויסע נויט איבערן לאנד און א צארן איבער דעם דאזיקן פאלק. ");
INSERT INTO ydd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","און זיי וועלן פאלן פון דער שארף פון דער שווערד, און געפאנגען געפירט ווערן צווישן אלע פעלקער; און ירושלים וועט צעטרעטן ווערן פון אומות (העולם), ביז די צייטן פון די אומות (העולם) וועלן דערפילט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","און עס וועלן זיין סימנים אין דער זון און לבנה און שטערנס; און אויף דער ערד אנגסט אויף פעלקער; און זיי וועלן נישט וויסן קיין עצה זיך צו געבן, מחמת דעם ברויזן פון ים און די כוואליעס; ");
INSERT INTO ydd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","און מענטשן וועלן אויסגיין פאר מורא און דערווארטונג פון דעם, וואס דארף קומען אויף דער וועלט; ווארום די כוחות פון הימל וועלן דערשיטערט ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","און דעמאלט וועלן זיי זען דעם בר אנש קומען אויף א וואלקן מיט מאכט און פיל הערלעכקייט. (דניאל ז, יג-יד.) ");
INSERT INTO ydd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ווען אבער די דאזיקע זאכן הויבן אָן געשען, זאלט איר זיך אויפריכטן און אויפהויבן אייערע קעפ, ווייל אייער גאולה דערנענטערט זיך. ");
INSERT INTO ydd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","און ער האט זיי געזאגט א משל: קוקט אויף דעם פייגנבוים און אויף אלע ביימער; ");
INSERT INTO ydd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ווען זיי שפראצן שוין, זעט איר עס און ווייסט פון זיך אליין, אז דער זומער איז נאענט. ");
INSERT INTO ydd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","אזוי אויך איר, ווען איר וועט זען די דאזיקע זאכן געשען, זאלט איר וויסן, אז דאס קעניגרייך פון ה׳ איז נאענט. ");
INSERT INTO ydd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","באמת זאג איך אייך: דאס דאזיקע דור וועט נישט פארגיין, ביז אלץ וועט האבן געשען. ");
INSERT INTO ydd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","דער הימל און די ערד וועלן פארגיין, אבער מיינע ווערטער וועלן בשום אופן נישט פארגיין. ");
INSERT INTO ydd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","נאר היטן זאלט איר זיך, אז אייערע הערצער זאלן נישט שווער ווערן מיט איבערעסן זיך און זויפן, און מיט דאגות פארן לעבן, און אז יענער טאג זאל נישט פלוצלונג קומען אויף אייך; ");
INSERT INTO ydd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ווארום ווי א נעץ וועט ער קומען איבער אלע, וואס וואוינען אויפן פנים פון דער גאנצער ערד. ");
INSERT INTO ydd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","דעריבער וואכט אין יעדער צייט, און טוט תפילה, אז איר זאלט ווערטיק זיין צו אנטרינען די דאזיקע אלע זאכן, וואס דארפן געשען, און צו שטיין פאר דעם בר אנש! ");
INSERT INTO ydd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","און בייטאג איז ער געווען אינם בית המקדש און האט געלערנט, און ביינאכט איז ער ארויסגעגאנגען און האט איבערגענעכטיקט אויפן בארג, וואס מען האט אים גערופן הר הזיתים. ");
INSERT INTO ydd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","און דאס גאנצע פאלק איז געקומען צו אים אינדערפרי אין בית המקדש אריין, כדי אים צו הערן. ");
INSERT INTO ydd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","און עס איז שוין געווען נאענט פאר דעם חג המצות, וואס מען רופט פסח. ");
INSERT INTO ydd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","און די הויפט כהנים און די סופרים האבן געזוכט אויף וואס פאר אן אופן אים אומצוברענגען; ווארום זיי האבן מורא געהאט פארן פאלק. ");
INSERT INTO ydd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","און דער שׂטן איז אריינגעגאנגען אין יהודהן, וואס מען האט אים גערופן איש‑קריות, זייענדיק פון דער צאל פון די צוועלף. ");
INSERT INTO ydd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","און ער איז אוועקגעגאנגען, און זיך אפגערעדט מיט די הויפט כהנים און הויפטלייט, אויף וואס פאר אן אופן ער זאל אים איבערגעבן צו זיי, ");
INSERT INTO ydd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","און זיי האבן זיך דערפריידט, און האבן אפגעמאכט אים צו געבן געלט. ");
INSERT INTO ydd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","און ער האט (עס) צוגעזאגט, און געזוכט א געלעגנהייט אים איבערצוגעבן צו זיי אָן א צוזאמענגעלויף. ");
INSERT INTO ydd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","און עס איז געקומען דער יום המצות, אין וועלכן מען דארף מקריב זיין דאס (קרבן) פסח. ");
INSERT INTO ydd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","און ער האט אוועקגעשיקט פעטרוסן און יוחנן, זאגנדיק, גייט און גרייט צו פאר אונדזערטוועגן דאס (קרבן) פסח, כדי מיר זאלן עס עסן! ");
INSERT INTO ydd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","און זיי האבן צו אים געזאגט: וואו ווילסטו, אז מיר זאלן עס צוגרייטן? ");
INSERT INTO ydd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","האט ער צו זיי געזאגט: זע, ווען איר וועט אריינקומען אין דער שטאט, וועט אייך אנטקעגנקומען א מענטש טראגנדיק א קרוג מיט וואסער; אים זאלט איר נאכפאלגן אין דעם הויז, אין וועלכן ער גייט אריין. ");
INSERT INTO ydd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","און זאגט דעם בעל הבית פון דעם הויז: דער רבי לאזט דיר זאגן: וואו איז דאס גאסט צימער, וואו איך וועל עסן דאס (קרבן) פסח מיט מיינע תלמידים? ");
INSERT INTO ydd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","און יענער וועט אייך ווייזן א גרויסע אויבערשטוב אויסגעשטאט מיט הסב‑בעטן; דארטן זאלט איר עס צוגרייטן. ");
INSERT INTO ydd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","און זיי זענען אוועקגעגאנגען, און האבן געפונען אזוי ווי ער האט זיי געזאגט; און האבן צוגעגרייט דאס (קרבן) פסח. ");
INSERT INTO ydd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","און ווען די שעה איז געקומען, האט ער זיך אנידערגעזעצט, און די שליחים מיט אים. ");
INSERT INTO ydd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","און האט צו זיי געזאגט: מיט א באגער האב איך באגערט צו עסן דאס דאזיקע (קרבן) פסח מיט אייך, איידער איך גיי ליידן; ");
INSERT INTO ydd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ווארום איך זאג אייך: איך וועל עס מער נישט עסן, ביז עס וועט דערפילט ווערן אין דעם קעניגרייך פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","און נעמענדיק א בעכער, האט ער געמאכט א ברכה און געזאגט: נעמט דעם דאזיקן, און צעטיילט אים צווישן זיך, ");
INSERT INTO ydd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ווארום איך זאג אייך: איך וועל פון איצט אָן מער נישט טרינקען פון דער פרוכט פון דעם וויינשטאק, ביז דאס קעניגרייך פון ה׳ וועט קומען. ");
INSERT INTO ydd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","און ער האט גענומען ברויט, געמאכט א ברכה, און האט עס צעבראכן און געגעבן צו זיי, אזוי צו זאגן: דאס דאזיקע איז מיין גוף, וואס ווערט געגעבן פאר אייך; דאס דאזיקע זאלט איר טאן לזכרון פון מיר! ");
INSERT INTO ydd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","דעסגלייכן אויך דעם בעכער נאך דער סעודה, זאגנדיק: דער דאזיקער בעכער איז דער נייער בונד אין מיין בלוט, וואס ווערט פארגאסן פאר אייך. ");
INSERT INTO ydd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","דאך זע, די האנט פון דעם, וואס פארראט מיך, איז מיט מיר אויפן טיש. ");
INSERT INTO ydd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","יא, דער בר אנש גייט טאקע, לויט ווי עס איז באשטימט געווארן; נאר וויי איז צו יענעם מענטשן, דורך וועמען ער ווערט פארראטן! ");
INSERT INTO ydd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","און זיי האבן אנגעהויבן צו פרעגן איינס דאס אנדערע, ווער פון זיי דאס קען זיין, וואס וועט דאס דאזיקע טאן. ");
INSERT INTO ydd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","און עס איז אויך געקומען צו א מחלוקה צווישן זיי, ווער פון זיי זאל געהאלטן ווערן פאר דעם גרעסטן. ");
INSERT INTO ydd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ער אבער האט צו זיי געזאגט: די מלכים פון די פעלקער הערשן איבער זיי, און זייערע מושלים רופט מען וואוילטעטער. ");
INSERT INTO ydd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","איר אבער נישט אזוי; נאר דער גרעסטער צווישן אייך זאל זיין ווי דער יונגסטער; און דער מנהיג ווי דער משרת. ");
INSERT INTO ydd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ווארום ווער איז גרעסער, דער וואס זיצט ביים טיש, צי דער וואס באדינט? איז עס דען נישט דער, וואס זיצט? איך אבער בין אין אייער מיט ווי דער משרת. ");
INSERT INTO ydd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","איר אבער זענט עס, וואס זענען פארבלייבן מיט מיר אין די נסיונות מיינע; ");
INSERT INTO ydd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","און איך באשטים פאר אייך א מלכות, אזוי ווי מיין פאטער האט פאר מיר באשטימט, ");
INSERT INTO ydd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","כדי איר זאלט עסן און טרינקען אויף מיין טיש אין מיין קעניגרייך; און זיצן אויף טראנען און משפטן די צוועלף שבטים פון ישראל. ");
INSERT INTO ydd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","שמעון, שמעון, זע, דער שׂטן האט זיך אויסגעבעטן, אייך צו זיפען ווי ווייץ; ");
INSERT INTO ydd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","איך אבער האב מתפלל געווען פאר דיר, אז דיין אמונה זאל זיך נישט אויסלאזן; און דו, ווען דו וועסט האבן תשובה געטאן, שטארק דיינע ברידער! ");
INSERT INTO ydd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ער אבער האט צו אים געזאגט: האר, מיט דיר בין איך גרייט צו גיין סאי אין תפיסה אריין און סאי צום טויט! ");
INSERT INTO ydd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ער אבער האט געזאגט: איך זאג דיר, פעטרוס, נישט וועט היינט דער האן קרייען, ביז דו האסט דריי מאל געלייקנט מיך צו קענען! ");
INSERT INTO ydd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","און ער האט צו זיי געזאגט: ווען איך האב אייך ארויסגעשיקט אָן א געלטבייטל, און טייסטער, און שיך, האט אייך עפעס געפעלט? און זיי האבן געזאגט: קיין זאך נישט! ");
INSERT INTO ydd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","האט ער צו זיי געזאגט: נאר איצט ווער עס האט א געלטבייטל, זאל ער אים נעמען, און אויך אזוי דעם טייסטער; און ווער עס האט גארנישט, דער זאל פארקויפן זיין מלבוש, און קויפן א שווערד. ");
INSERT INTO ydd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ווארום איך זאג אייך, אז דאס, וואס שטייט געשריבן, מוז דערפילט ווערן אין מיר: און מיט פושעים איז ער פאררעכנט געווארן (ישעיהו נג, יב.); ווייל דאס, וואס איז שייך מיר, האט (איצט) א סוף. ");
INSERT INTO ydd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","און זיי האבן געזאגט: האר, זע, דא זענען דא צוויי שווערדן! ער אבער האט צו זיי געזאגט: עס איז גענוג! ");
INSERT INTO ydd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","און ער איז ארויסגעגאנגען, און איז אוועק, ווי עס איז געווען זיין געוואוינהייט, צום הר הזיתים; און די תלמידים האבן אים אויך נאכגעפאלגט. ");
INSERT INTO ydd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","און קומענדיק צו דעם ארט, האט ער צו זיי געזאגט: טוט תפילה, אז איר זאלט נישט אריינקומען אין קיין נסיון! ");
INSERT INTO ydd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","און אליין האט ער זיך פון זיי דערווייטערט (א שטח) אזוי ווי א שטיינוואורף; און האט אנידערגעקניט און תפילה געטאן, ");
INSERT INTO ydd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","אזוי צו זאגן: פאטער, אויב דו ווילסט, נעם אוועק פון מיר דעם דאזיקן בעכער! דאך נישט מיין, נאר דיין רצון זאל געשען! ");
INSERT INTO ydd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","און עס האט זיך צו אים באוויזן א מלאך פון הימל, און אים געשטארקט. ");
INSERT INTO ydd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","און א טויט אנגסט איז אויף אים געקומען, און ער האט העפטיקער תפילה געטאן; און זיין שווייס איז געווארן ווי בלוטסטראפן, וואס זענען אראפגעפאלן אויף דער ערד. ");
INSERT INTO ydd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","און ווען ער איז אויפגעשטאנען נאך דער תפילה און איז געקומען צו די תלמידים, האט ער זיי געפונען שלאפן פאר צער. ");
INSERT INTO ydd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","און ער האט צו זיי געזאגט: וואס שלאפט איר? שטייט אויף און טוט תפילה, אז איר זאלט נישט אריינקומען אין קיין נסיון! ");
INSERT INTO ydd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","בשעת ער האט נאך גערעדט, זע, עס איז געקומען א המון מענטשן און דער מיט דעם נאמען יהודה, איינער פון די צוועלף, איז געגאנגען פארויס פאר זיי און האט גענענט צו יהושען/ישוען, כדי אים א קוש צו טאן, ");
INSERT INTO ydd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","יהושע/ישוע אבער האט צו אים געזאגט: יהודה, מיט א קוש פארראטסטו דעם בר אנש? ");
INSERT INTO ydd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","און ווי די, וואס זענען געווען ארום אים, האבן געזען וואס דא גייט ווערן, האבן זיי געזאגט: האר, צי זאלן מיר שלאגן מיט דער שווערד? ");
INSERT INTO ydd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","און איינער פון זיי האט געשלאגן דעם כהן גדולס קנעכט און אים אפגעהאקט זיין רעכט אויער. ");
INSERT INTO ydd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","יהושע/ישוע אבער האט ענטפערנדיק געזאגט: לאזט געמאכט! און האט אנגערירט זיין אויער, און אים געהיילט. ");
INSERT INTO ydd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","און יהושע/ישוע האט געזאגט צו די הויפט כהנים, און הויפטלייט פון בית המקדש, און זקנים, וועלכע זענען געקומען קעגן אים: ווי קעגן א רויבער זענט איר ארויסגעקומען מיט שווערדן און מיט שטאנגען! ");
INSERT INTO ydd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ווען איך בין געווען טאג אויס טאג איין מיט אייך אינם בית המקדש, האט איר נישט אויסגעשטרעקט די הענט קעגן מיר; נאר די דאזיקע איז אייער שעה, און די מאכט פון דער פינצטערניש. ");
INSERT INTO ydd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","און זיי האבן אים געכאפט, און אים אוועקגעפירט, און אריינגעברענגט אין כהן גדולס הויז אריין. פעטרוס אבער האט נאכגעפאלגט פונדערווייטנס. ");
INSERT INTO ydd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","און ווען זיי האבן אנגעצונדן א פייער אינמיטן הויף, און זיך אנידערגעזעצט צוזאמען, האט פעטרוס זיך אנידערגעזעצט צווישן זיי. ");
INSERT INTO ydd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","א דינסטמיידל אבער האט אים געזען זיצן ביים פייער, האט זי זיך גוט איינגעקוקט אויף אים און געזאגט: אויך דער דאזיקער איז געווען מיט אים! ");
INSERT INTO ydd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","און ער האט עס אפגעלייקנט, אזוי צו זאגן: אשה, איך קען אים נישט! ");
INSERT INTO ydd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","און אביסל שפעטער האט אים אן אנדערער דערזען, און געזאגט: דו ביסט אויך פון זיי! פעטרוס אבער האט געזאגט: מענטש, איך בין עס נישט! ");
INSERT INTO ydd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","און נאך א פארלויף פון אן ערך איין שעה, האט אן אנדערער באשטימט פארזיכערט, אזוי צו זאגן: אויף אן אמת אויך דער דאזיקער איז געווען מיט אים; ווארום ער איז אויך א גלילי! ");
INSERT INTO ydd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","פעטרוס אבער האט געזאגט: מענטש, איך ווייס נישט, וואס דו זאגסט! און אין אן אויגנבליק, בשעת ער האט נאך גערעדט, האט דער האן געקרייט. ");
INSERT INTO ydd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","און דער האר האט זיך אויסגעדרייט, און א בליק געטאן אויף פעטרוסן. און פעטרוס האט זיך דערמאנט דאס ווארט פון דעם האר, ווי ער האט צו אים געזאגט: איידער דער האן וועט היינט קרייען, וועסטו מיך דריי מאל פארלייקענען. ");
INSERT INTO ydd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","און ער איז ארויסגעגאנגען אינדרויסן, און האט זיך ביטער צעוויינט. ");
INSERT INTO ydd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","און די מענער, וואס האבן אים (יהושען/ישוען) באוואכט, האבן אפגעשפאט פון אים, און אים געשלאגן. ");
INSERT INTO ydd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","און זיי האבן אים ארומגעהילט (דאס פנים), און אים געפרעגט, אזוי צו זאגן: זאג נבואות, ווער עס איז, וואס האט דיך געשלאגן? ");
INSERT INTO ydd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","און א סך אנדערע לעסטערונגען האבן זיי געזאגט קעגן אים. ");
INSERT INTO ydd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","און ווי עס איז געווארן טאג, זענען זיך צוזאמענגעקומען די זקנים פון פאלק, די הויפט כהנים און סופרים, און האבן אים אוועקגעפירט צו זייער סנהדרין, און געזאגט: ");
INSERT INTO ydd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","אויב דו ביסט דער משיח, זאג עס אונדז! ער אבער האט צו זיי געזאגט: אויב איך זאל עס אייך זאגן, וועט איר נישט גלויבן; ");
INSERT INTO ydd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","און אויב איך וועל פרעגן, וועט איר נישט ענטפערן. ");
INSERT INTO ydd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","פון איצט אָן אבער וועט דער בר אנש זיצן אויף דער רעכטער זייט פון ה׳ס מאכט. (תהלים קי, א.) ");
INSERT INTO ydd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","האבן זיי אלע געזאגט: צי ביסטו דען דער זון פון דער אויבערשטער? און ער האט צו זיי געזאגט: איר זאגט עס, ווייל איך בין עס! ");
INSERT INTO ydd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","זיי אבער האבן געזאגט: וואס דארפן מיר נאך אן עדות זאגן? ווארום מיר אליין האבן עס געהערט פון זיין מויל. ");
INSERT INTO ydd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","און זייער גאנצע עדה איז אויפגעשטאנען, און אים אוועקגעפירט צו פילאטוסן. ");
INSERT INTO ydd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","און זיי האבן אנגעהויבן אים צו באשולדיקן, אזוי צו זאגן: דעם דאזיקן האבן מיר געפונען פארפירן אונדזער פאלק, און ער פארווערט צו צאלן שטייערן צום קיסר; ער זאגט אויך, אז ער איז דער (רבי) מלך המשיח. ");
INSERT INTO ydd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","און פילאטוס האט אים געפרעגט, אזוי צו זאגן: דו ביסט דער קעניג פון די יידן? און ער האט ענטפערנדיק געזאגט צו אים: דו זאגסט עס! ");
INSERT INTO ydd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","האט פילאטוס געזאגט צו די הויפט כהנים און צו די המונים מענטשן; איך געפין נישט קיין שום שולד אין דעם דאזיקן מענטשן! ");
INSERT INTO ydd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","זיי אבער האבן זיך געהאלטן דערביי, און געזאגט: ער העצט אויף דאס פאלק, לערנט איבערן גאנצן (לאנד) יהודה, און אנהויבנדיק פון גליל אזש ביז אהער! ");
INSERT INTO ydd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","און ווי פילאטוס האט דאס געהערט, האט ער געפרעגט, צי דער מענטש איז א גלילי, ");
INSERT INTO ydd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","און דערוויסנדיק זיך, אז ער איז פון הורדוסנס ממשלה, האט ער אים אוועקגעשיקט צו הורדוסן, וועלכער איז אליין אויך געווען אין ירושלים אין די דאזיקע טעג. ");
INSERT INTO ydd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","און הורדוס האט זיך זייער געפריידט, זעענדיק יהושען/ישוען; ווארום שוין א לאנגע צייט ווי ער האט אים גערן געוואלט זען, צוליב דעם וואס ער האט געהערט וועגן אים, און האט געהאפט צו זען עפעס אן אות געטאן פון אים. ");
INSERT INTO ydd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","און ער האט אים געשטעלט א סך קשיות; ער אבער האט אים גארנישט געענטפערט. ");
INSERT INTO ydd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","און די הויפט כהנים און די סופרים זענען געשטאנען און האבן אים אייפערדיק אנגעקלאגט. ");
INSERT INTO ydd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","און הורדוס מיט זיינע זעלנער האבן אים פאראכט און אפגעשפאט פון אים, און אנטוענדיק אים אין א פראכטפול מלבוש, האט ער אים צוריקגעשיקט צו פילאטוסן. (ישעיהו נג, ז-ח.) ");
INSERT INTO ydd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","און הורדוס און פילאטוס זענען געווארן פריינד איינער מיטן אנדערן אין דעם זעלביקן טאג; ווארום פריער האט געהערשט א שנאה צווישן זיי. ");
INSERT INTO ydd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","און פילאטוס האט צוזאמענגערופן די הויפט כהנים און די שרים און דאס פאלק. ");
INSERT INTO ydd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","און צו זיי געזאגט: איר האט אהערגעברענגט דעם דאזיקן מענטשן פאר מיר, ווי א פאלקספארפירער; און זע, איך האב אים אויסגעפארשט פאר אייך, און האב נישט געפונען אין דעם דאזיקן מענטשן קיין שום שולד, וואס שייך דעם, וואס איר קלאגט אים אָן; ");
INSERT INTO ydd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ניין, אפילו הורדוס אויך נישט; ווארום ער האט אים צוריקגעשיקט צו אונדז; און זע, ער האט גארנישט געטאן, פארוואס ער זאל זיין חייב מיתה. ");
INSERT INTO ydd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","איך וועל אים דעריבער לאזן געבן שלעק, און אפלאזן. ");
INSERT INTO ydd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","און ער האט געמוזט אפלאזן פאר זיי איינעם אויף יום טוב. ");
INSERT INTO ydd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","און דער גאנצער המון האט געשריגן, אזוי צו זאגן: אוועק מיט דעם דאזיקן, און באפריי אונדז בר‑אבאן! ");
INSERT INTO ydd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","וועלכער איז אריינגעווארפן געווארן אין געפענקעניש אריין צוליב אן אויפשטאנד, וואס איז פארגעקומען אין דער שטאט, און צוליב א מערדעריי. ");
INSERT INTO ydd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","און ווידער האט פילאטוס אויסגערופן צו זיי, וועלנדיק אפלאזן יהושען/ישוען; ");
INSERT INTO ydd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","זיי אבער האבן געשריגן, אזוי צו זאגן: אויפהענגען אים אויף דער בוים! אויפהענגען אים אויף דער בוים! ");
INSERT INTO ydd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","און צום דריטן מאל האט ער צו זיי געזאגט: וואס פאר א בייז האט ער דען געטאן? איך האב נישט געפונען קיין שום טויט שולד אין אים; איך וועל אים דעריבער לאזן געבן שלעק און באפרייען. ");
INSERT INTO ydd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","זיי אבער האבן אנגעהאלטן מיט הויכע קולות, פאדערנדיק, אז ער זאל אים אויפהענגען אויף א בוים. און די געשרייען זייערע האבן גובר געווען. ");
INSERT INTO ydd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","און פילאטוס האט געמשפט, אז זייער פאדערונג זאל געשען. ");
INSERT INTO ydd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","און האט באפרייט דעם, וואס איז אריינגעווארפן געווארן אין געפענקעניש אריין צוליב אן אויפשטאנד און מערדעריי, וועמען זיי האבן באגערט; יהושען/ישוען אבער האט ער איבערגעגעבן צו זייער ווילן. ");
INSERT INTO ydd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","און ווי זיי האבן אים אוועקגעפירט, האבן זיי געכאפט א געוויסן שמעון פון קירניה, קומענדיק פונם פעלד, און האבן ארויפגעלייגט אויף אים דעם בוים, אז ער זאל אים טראגן נאך יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","און עס האט אים נאכגעפאלגט א גרויסער המון עם און פרויען, וואס האבן אים באקלאגט און באוויינט. ");
INSERT INTO ydd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","יהושע/ישוע אבער האט זיך אויסגעדרייט צו זיי און געזאגט: טעכטער פון ירושלים, וויינט נישט איבער מיר; נאר וויינט ליבער איבער זיך אליין, און איבער אייערע קינדער! ");
INSERT INTO ydd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ווייל זע, עס קומען טעג, אין וועלכע מען וועט זאגן: וואויל איז די עקרות, און די לייבער, וואס האבן נישט געבוירן, און די בריסטן, וואס האבן נישט געגעבן צו זויגן! ");
INSERT INTO ydd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","דעמאלט וועט מען אנהויבן צו זאגן צו די בערג: פאלט אויף אונדז! און צו די בערגלעך: דעקט אונדז צו! ");
INSERT INTO ydd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ווייל אויב מען טוט דאס צום גרינעם האלץ, וואס וועט שוין געשען צום פארדארטן? ");
INSERT INTO ydd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","און צוויי אנדערע, פארברעכער, זענען געפירט געווארן צוזאמען מיט אים געטייט צו ווערן. ");
INSERT INTO ydd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","און ווען זיי זענען געקומען צו דעם ארט, וואס מען רופט עס גלגלתא, האבן זיי אים דארט אויפגעהאנגען אויף א בוים, און די פארברעכער, דעם אויף דער רעכטער זייט און דעם אויף דער לינקער זייט. (ישעיהו נג, יב.) ");
INSERT INTO ydd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","יהושע/ישוע אבער האט געזאגט: פאטער, פארגיב זיי, ווארום זיי ווייסן נישט, וואס זיי טאן! זיי אבער האבן זיך צעטיילט זיינע קליידער און געווארפן גורל. (תהלים כב, יח.) ");
INSERT INTO ydd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","און דאס פאלק איז געשטאנען און האט עס צוגעזען. און אויך די שרים האבן אפגעשפאט פון אים, אזוי צו זאגן: אנדערע האט ער געהאלפן; זאל ער זיך אליין העלפן, אויב ער איז דער משיח, דער אויסדערוויילטער פון ה׳! ");
INSERT INTO ydd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","און אויך די זעלנער האבן אים אויסגעלאכט, צוקומענדיק צו אים, און ברענגענדיק עסיק פאר אים. (תהלים סט, כא.) ");
INSERT INTO ydd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","און האבן געזאגט: אויב דו ביסט דער קעניג פון די יידן, ראטעווע דיך אליין! ");
INSERT INTO ydd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","און איבער אים איז אויך געווען אן אויפשריפט: דאס איז דער קעניג פון די יידן. ");
INSERT INTO ydd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","איינער אבער פון די פארברעכער, וואס זענען געהענגט געווארן, האט אים געלעסטערט, אזוי צו זאגן: צי ביסטו דען נישט דער משיח? ראטעווע זשע דיך אליין און אונדז! ");
INSERT INTO ydd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","נאר דער אנדערער האט ענטפערנדיק אנגעשריגן אויף אים, און געזאגט: דו האסט אויך נישט קיין מורא פאר ה׳, ביסט דאך אין דעם זעלביקן משפט! ");
INSERT INTO ydd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","מיר טאקע מיט רעכט; ווארום מיר האבן באקומען דאס, וואס אונדזערע מעשים זענען ווערט געווען; ער אבער האט דאך נישט געטאן קיין שום עוולה! ");
INSERT INTO ydd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","און האט געזאגט: יהושע/ישוע, געדענק מיך, ווען דו קומסט אין דיין מלכות אריין! ");
INSERT INTO ydd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","און ער האט צו אים געזאגט: באמת זאג איך דיר: היינט וועסטו זיין מיט מיר אין גן עדן! ");
INSERT INTO ydd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","און עס איז שוין געווען ארום דער זעקסטער שעה, און א פינצטערניש איז געקומען איבערן גאנצן לאנד ביז דער ניינטער שעה. ");
INSERT INTO ydd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","און די זון איז פארפינסטערט געווארן, און דאס פרוכת פון היכל האט זיך צעריסן אין צווייען אין דער מיט. ");
INSERT INTO ydd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","און יהושע/ישוע האט א געשריי געטאן מיט א הויך קול, און געזאגט: פאטער, אין דיינע הענט גיב איך איבער מיין גייסט! און דאס זאגנדיק, האט ער אויסגעהויכט זיין אטעם. (תהלים לא, ה.) ");
INSERT INTO ydd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ווי אבער דער אפיציר האט געזען, וואס עס איז געשען, האט ער אפגעגעבן כבוד צו ה׳, אזוי צו זאגן: דער דאזיקער מענטש איז באמת געווען א צדיק! ");
INSERT INTO ydd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","און אלע המונים מענטשן, וואס זענען זיך צונויפגעקומען צו דער דאזיקער זעונג, זעענדיק די זאכן, וואס זענען געשען, האבן זיך געשלאגן אויף דער ברוסט און זיך אומגעקערט. ");
INSERT INTO ydd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","עס זענען אבער געשטאנען אלע זיינע באקאנטע פונדערווייטנס, און די פרויען, וועלכע האבן אים נאכגעפאלגט פון גליל, און האבן דאס צוגעזען. ");
INSERT INTO ydd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","און זע, א געוויסער מאן מיטן נאמען יוסף, וועלכער איז געווען א יועץ, אן איש טוב וצדיק, ");
INSERT INTO ydd_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(ער איז נישט געווען איינשטימיק מיט זייער עצה און מיט זייער טאן) פון הרמתים, א יידישע שטאט, וועלכער האט געהאפט אויף דעם קעניגרייך פון ה׳; ");
INSERT INTO ydd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ער איז געגאנגען צו פילאטוסן און האט געבעטן פון אים ישועס גוף. ");
INSERT INTO ydd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","און האט אים אראפגענומען, אים איינגעוויקלט אין א ליילעך, און געלייגט אין א קבר, אויסגעהאקט אין א פעלדזן, וואו עס איז נאך קיינמאל קיינער נישט געלייגט געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","און דער טאג איז געווען ערב שבת, און דער שבת האט שוין געהאלטן ביים צופאלן. ");
INSERT INTO ydd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","די פרויען אבער, וואס האבן אים באגלייט פון גליל, זענען נאכגעגאנגען, און האבן געזען דאס קבר, און וויאזוי זיין קערפער איז געלייגט געווארן. ");
INSERT INTO ydd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","און האבן זיך אומגעקערט, און צוגעגרייט בשמים און זאלבן. און שבת האבן זיי גערוט לויט דעם געבאט (פון דער תורה). ");
INSERT INTO ydd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","און דעם ערשטן טאג פון דער וואך, ווען עס האט אנגעהויבן טאגבראך, זענען זיי געקומען צום קבר, ברענגענדיק די בשמים, וואס זיי האבן צוגעגרייט. ");
INSERT INTO ydd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","זיי האבן אבער געפונען דעם שטיין אראפגעקייקלט פונם קבר; ");
INSERT INTO ydd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","און זענען אריינגעגאנגען, און האבן נישט געפונען דעם גוף פון דעם האר יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","און עס איז געשען, בשעת זיי זענען אזוי געווען מבולבל וועגן דעם, זע, צוויי מענער זענען געשטאנען נעבן זיי אין שטראלנדיקע קליידער; ");
INSERT INTO ydd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","און ווי זיי האבן זיך דערשראקן און גענייגט די פנימער צו דער ערד, האבן די דאזיקע געזאגט צו זיי: וואס זוכט איר דעם לעבעדיקן צווישן די טויטע? ");
INSERT INTO ydd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ער איז דא נישטא, נאר איז אויפגעשטאנען! דערמאנט זיך ווי ער האט גערעדט צו אייך, בשעת ער איז נאך געווען אין גליל, און געזאגט, ");
INSERT INTO ydd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","אז דער בר אנש מוז איבערגעגעבן ווערן אין די הענט פון זינדיקע מענטשן, און ווערן אויפגעהאנגען אויף א בוים, און דעם דריטן טאג ווידער אויפשטיין. ");
INSERT INTO ydd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","און זיי האבן זיך דערמאנט זיינע ווערטער, ");
INSERT INTO ydd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","און האבן זיך אומגעקערט פונם קבר, און דערציילט אלע די דאזיקע זאכן צו די עלף, און צו אלע איבריקע. ");
INSERT INTO ydd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","און דאס זענען געווען מרים פון מגדלה, און יוחנה, און מרים, יעקבס מוטער; און די איבריקע מיט זיי האבן דאס געזאגט צו די שליחים, ");
INSERT INTO ydd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","און די דאזיקע רייד זענען זיי פארגעקומען ווי פוסטע מעשיות, און האבן זיי נישט געגלויבט. ");
INSERT INTO ydd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","נאר פעטרוס האט זיך אויפגעהויבן און איז אהינגעלאפן צום קבר; און איינבייגנדיק זיך, זעט ער די תכריכים ליגן אליין; און ער איז אוועק צו זיך אהיים, וואונדערנדיק זיך איבער דעם, וואס איז געשען. ");
INSERT INTO ydd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","און זע, צוויי פון זיי זענען דעם זעלביקן טאג געווען אויפן וועג אין א דארף אריין מיטן נאמען עמאוס, וואס איז געלעגן זעכציק אקער‑פעלד פון ירושלים. ");
INSERT INTO ydd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","און האבן געשמועסט צווישן זיך וועגן אלעם דעם, וואס איז פארגעקומען. און עס איז געשען, ");
INSERT INTO ydd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","בשעת זיי האבן געשמועסט און געהאלטן א וויכוח, האט יהושע/ישוע אליין גענענט, און איז מיטגעגאנגען מיט זיי. ");
INSERT INTO ydd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","זייערע אויגן אבער זענען געהאלטן געווארן, כדי זיי זאלן אים נישט דערקענען. ");
INSERT INTO ydd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","און ער האט צו זיי געזאגט: וואס פאר א ווערטער זענען דאס, וואס איר רעדט איינער מיט דעם אנדערן אונטערוועגנס? און זיי זענען געבליבן שטיין מיט באטריבטע פנימער. ");
INSERT INTO ydd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","און דער איינער מיטן נאמען קלעאפאס, האט ענטפערנדיק געזאגט צו אים: ביסטו דער איינציקער פרעמדער אין ירושלים, און ווייסט נישט וואס עס איז דארט געשען אין די דאזיקע טעג? ");
INSERT INTO ydd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","און ער האט צו זיי געזאגט: וואס? און זיי האבן צו אים געזאגט: דאס פון יהושע/ישוע פון נצרת, וואס איז געווען א נביא, מעכטיק אין טאט און אין ווארט פאר ה׳ און דעם גאנצן פאלק; ");
INSERT INTO ydd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","און וויאזוי אונדזערע הויפט כהנים און שרים האבן אים איבערגעגעבן, אז ער זאל פארמשפט ווערן צום טויט, און האבן אים אויפגעהאנגען אויף א בוים. ");
INSERT INTO ydd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","מיר אבער האבן געהאפט, אז ער איז דאס, וועלכער האט געזאלט אויסלייזן דאס (פאלק) ישראל. און אויסער דעם איז שוין היינט דער דריטער טאג, זינט די דאזיקע זאכן זענען געשען. ");
INSERT INTO ydd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","נאר אפילו אייניקע פרויען, וואס געהערן צו אונדז, האבן אונדז איבערראשט, קומענדיק אינדערפרי צום קבר; ");
INSERT INTO ydd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","און ווען זיי האבן נישט געפונען זיין גוף, זענען זיי געקומען, און האבן געזאגט, אז זיי האבן אויך געזען א דערשיינונג פון מלאכים, וועלכע האבן געזאגט, אז ער לעבט. ");
INSERT INTO ydd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","און אייניקע פון די אונדזעריקע זענען אוועק צום קבר, און האבן עס געפונען פונקט אזוי, ווי די פרויען האבן געזאגט, אים (אליין) אבער האבן זיי נישט געזען. ");
INSERT INTO ydd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","און ער האט צו זיי געזאגט: אָ, איר נאראנים און וואס דאס הארץ איז אייך שווער צו גלויבן אלץ, וואס די נביאים האבן גערעדט! ");
INSERT INTO ydd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","צי האט דען דער משיח נישט געדארפט ליידן די דאזיקע זאכן, און אריינגיין אין זיין הערלעכקייט אריין? ");
INSERT INTO ydd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","און אנהויבנדיק פון (תורת) משה און פון אלע נביאים, האט ער אויסגעטייטשט פאר זיי אין אלע שריפטן דאס, וואס האט א שייכות צו אים. ");
INSERT INTO ydd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","און זיי האבן זיך דערנענטערט צו דעם דארף, וואואהין זיי זענען געגאנגען, און ער האט זיך געמאכט, ווי ער וואלט געוואלט גיין ווייטער. ");
INSERT INTO ydd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","און זיי האבן אים געבעטן, און האבן געזאגט: בלייב ביי אונדז, ווייל עס האלט שוין באלד ביים אוונט, און דער טאג האט זיך שוין גענייגט! און ער איז אריינגעגאנגען צו בלייבן ביי זיי. ");
INSERT INTO ydd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","און עס איז געשען, בשעתן אנידערזעצן זיך צוזאמען מיט זיי צום טיש, האט ער גענומען דאס ברויט, געמאכט א ברכה, האט עס צעבראכן און געגעבן צו זיי. ");
INSERT INTO ydd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","און זייערע אויגן זענען אויפגעעפנט געווארן, און זיי האבן אים דערקענט; און ער איז פון זיי פארשווונדן. ");
INSERT INTO ydd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","און זיי האבן געזאגט איינער צום אנדערן: צי האט דען נישט אונדזער הארץ געברענט אין אונדז, בשעת ער האט מיט אונדז גערעדט אויפן וועג, ווי ער האט אונדז אויפגעעפנט די כתבי (הקודש)? ");
INSERT INTO ydd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","און זיי זענען אויפגעשטאנען אין דער זעלביקער שעה און האבן זיך אומגעקערט קיין ירושלים, און האבן געפונען די עלף פארזאמלט, און די, וואס זענען געווען מיט זיי; ");
INSERT INTO ydd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","וועלכע האבן געזאגט: דער האר איז באמת אויפגעשטאנען, און האט זיך באוויזן צו שמעונען! ");
INSERT INTO ydd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","און זיי אליין האבן דערציילט, וואס עס איז געשען אויפן וועג, און וויאזוי ער איז פון זיי דערקענט געווארן ביים ברעכן דאס ברויט. ");
INSERT INTO ydd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","און בשעת זיי האבן גערעדט פון די דאזיקע זאכן, איז ער אליין געשטאנען אין דער מיט צווישן זיי, און זאגט צו זיי: שלום עליכם! ");
INSERT INTO ydd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","זיי אבער האבן געציטערט און מורא געהאט, מיינענדיק, אז זיי זען א גייסט. ");
INSERT INTO ydd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","און ער האט צו זיי געזאגט: פארוואס זענט איר אזוי דערשראקן, און פארוואס שטייגן אויף ספקות אין אייער הארץ? ");
INSERT INTO ydd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","קוקט אויף מיינע הענט און אויף מיינע פיס, אז איך בין עס אליין! רירט מיך אָן און זעט! ווייל א גייסט האט נישט קיין פלייש און ביין, ווי איר זעט, אז איך האב. ");
INSERT INTO ydd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","און ווי ער האט דאס געזאגט, האט ער זיי געוויזן די הענט און די פיס. ");
INSERT INTO ydd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","און בשעת זיי האבן נאך אלץ נישט געגלויבט פאר פרייד, און זיך געוואונדערט, האט ער צו זיי געזאגט: צי האט איר דא עפעס צו עסן? ");
INSERT INTO ydd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","האבן זיי אים געגעבן א שטיק געבראטענעם פיש. ");
INSERT INTO ydd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","און ער האט עס גענומען, און געגעסן פאר זייערע אויגן. ");
INSERT INTO ydd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","און ער האט צו זיי געזאגט: דאס זענען מיינע ווערטער, וואס איך האב צו אייך גערעדט, בשעת איך בין נאך געווען מיט אייך, אז אלץ מוז דערפילט ווערן, וואס עס שטייט געשריבן אין תורת משה, און אין די נביאים, און אין תהלים, וועגן מיר. ");
INSERT INTO ydd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","דעמאלט האט ער אויפגעעפנט זייער פארשטאנד, משיג צו זיין די כתבי (הקודש); ");
INSERT INTO ydd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","און האט צו זיי געזאגט: אזוי שטייט געשריבן, אז דער משיח זאל ליידן, און אויפשטיין פון די טויטע דעם דריטן טאג, ");
INSERT INTO ydd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","און אז אין זיין נאמען זאל אויסגערופן ווערן א תשובה צו דער פארגעבונג פון זינד צווישן אלע פעלקער—אנהויבנדיק פון ירושלים. ");
INSERT INTO ydd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","איר זענט עדות פון די דאזיקע זאכן. ");
INSERT INTO ydd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","און זע, איך שיק אויף אייך די הבטחה פון מיין פאטער; איר אבער בלייבט אין דער שטאט, ביז איר וועט אנגעקליידט ווערן מיט גבורה פון אויבן. ");
INSERT INTO ydd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","און ער האט זיי ארויסגעפירט ביז נאענט קיין בית‑היני, און האט אויפגעהויבן זיינע הענט, און זיי געבענטשט. ");
INSERT INTO ydd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","און עס איז געשען, בשעת דעם בענטשן זיי, האט ער זיך פון זיי אפגעשיידט, און איז ארויפגענומען געווארן אין הימל אריין. ");
INSERT INTO ydd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","און זיי האבן זיך אומגעקערט קיין ירושלים מיט גרויס פרייד; ");
INSERT INTO ydd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","און זענען תמיד געווען אין בית המקדש, לויבנדיק ה׳.");
INSERT INTO ydd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","אינם אנהויב איז געווען דאס ווארט, און דאס ווארט איז געווען ביי ה׳, און דאס ווארט איז געווען גארנישט ווייניקער ווי ג‑ט. ");
INSERT INTO ydd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","דאס דאזיקע איז געווען אין אנהויב ביי ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","אלץ איז דורך אים באשאפן געווארן; און אחוץ דורך אים איז נישט באשאפן געווארן קיין זאך, וואס איז באשאפן געווארן. ");
INSERT INTO ydd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","אין אים איז געווען לעבן; און דאס לעבן איז געווען דאס ליכט פון די מענטשן. ");
INSERT INTO ydd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","און דאס ליכט שיינט אין דער פינצטערניש; און די פינצטערניש האט עס נישט גובר געווען. ");
INSERT INTO ydd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","עס איז געווען א מענטש, פון ה׳ געשיקט, זיין נאמען איז געווען יוחנן. ");
INSERT INTO ydd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","דער דאזיקער איז געקומען פאר אן עדות, כדי עדות צו זאגן וועגן דעם ליכט, אז אלע זאלן גלויבן דורך אים. ");
INSERT INTO ydd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ער איז נישט געווען דאס ליכט, נאר (איז געקומען) כדי עדות צו זאגן וועגן דעם ליכט. ");
INSERT INTO ydd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","דאס איז געווען דאס אמתע ליכט, וואס באלייכט יעדן מענטשן, וועלכער קומט אין דער וועלט אריין. ");
INSERT INTO ydd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ער איז געווען אין דער וועלט, און די וועלט איז דורך אים באשאפן געווארן, און די וועלט האט אים נישט געקענט. ");
INSERT INTO ydd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","צו זיין אייגנטום איז ער געקומען, און די זייניקע האבן אים נישט אויפגענומען. ");
INSERT INTO ydd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","וויפל אבער עס האבן אים יא אנגענומען, האט ער זיי געגעבן מאכט צו ווערן ה׳ס קינדער, צו די, וואס גלויבן אין זיין נאמען: ");
INSERT INTO ydd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","וועלכע זענען געבוירן געווארן נישט פון בלוט, נישט פון דעם ווילן פון דעם פלייש, אויך נישט פון דעם ווילן פון א מאן, נאר פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","און דאס ווארט איז געווארן (פארקערפערן) בשר (ודם) און האט געוואוינט צווישן אונדז, און מיר האבן געזען זיין כבוד, א הערלעכקייט ווי פון א בן יחיד ביי זיין פאטער, פול מיט חסד און אמת. ");
INSERT INTO ydd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","יוחנן האט עדות געזאגט וועגן אים, און אויסגערופן, אזוי צו זאגן: ער איז עס, וועגן וועמען איך האב געזאגט: דער, וואס קומט נאך מיר, איז געווען פאר מיר, ווייל ער איז געווען פארויס פאר מיר. ");
INSERT INTO ydd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","און פון זיין פולקייט האבן מיר אלע באקומען, און (טאקע) חסד איבער חסד. ");
INSERT INTO ydd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ווייל די תורה איז געגעבן געווארן דורך משהן, דער חסד און דער אמת זענען געקומען דורך יהושע/ישוע המשיחן. ");
INSERT INTO ydd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","קיינער האט קיינמאל נישט געזען ה׳; (נאר) דער בן יחיד וועלכער איז אינם שויס פון דעם פאטער, האט (אים) באקאנט געמאכט. ");
INSERT INTO ydd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","און דאס דאזיקע איז יוחננס עדות זאגן, ווען די יידן פון ירושלים האבן געשיקט צו אים כהנים און לוויים, כדי אים צו פרעגן: ווער ביסטו? ");
INSERT INTO ydd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","און ער האט מודה געווען, און נישט געלייקנט; און האט מודה געווען: איך בין נישט דער משיח. ");
INSERT INTO ydd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","און זיי האבן אים געפרעגט: טאָ ווער דען? צי ביסטו אליהו? און ער זאגט: איך בין עס נישט. צי ביסטו דער נביא? און ער האט געענטפערט: ניין. ");
INSERT INTO ydd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","האבן זיי דעריבער געזאגט: ווער זשע ביסטו? כדי מיר זאלן געבן אן ענטפער צו די, וואס האבן אונדז געשיקט. וואס זאגסטו וועגן דיר אליין? ");
INSERT INTO ydd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","האט ער געזאגט: איך בין א קול פון איינעם וואס שרייט אין דער מדבר: מאכט גלייך דעם וועג פון דעם האר, אזויווי ישעיה הנביא האט געזאגט. (ישעיהו מ, ג.) ");
INSERT INTO ydd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","און די שליחים זענען געווען פון די פרושים. ");
INSERT INTO ydd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","און זיי האבן אים געפרעגט, און געזאגט צו אים: טאָ פארוואס ביסטו טובל אין א מקווה, אויב דו ביסט נישט דער משיח, אויך נישט אליהו, און נישט דער נביא? ");
INSERT INTO ydd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","האט יוחנן זיי געענטפערט, אזוי צו זאגן: איך בין טובל מיט וואסער אין א מקווה: אין אייער מיט שטייט (איינער), וועמען איר קענט נישט, ");
INSERT INTO ydd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","דער, וואס קומט נאך מיר, וועמען איך בין נישט ווערט אויפצובינדן דאס שנירל פון זיין שוך. ");
INSERT INTO ydd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","דאס איז געשען אין בית‑היני, אויף יענער זייט ירדן, וואו יוחנן פלעגט טובל זיין אין דער מקווה. ");
INSERT INTO ydd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","צומארגנס זעט ער יהושען/ישוען קומען צו אים, און זאגט: זע, ה׳ס לאם, וואס נעמט אוועק די זינד פון דער וועלט! (ישעיהו נג, ז.) ");
INSERT INTO ydd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ער איז דאס, פון וועמען איך האב געזאגט: נאך מיר קומט א מאן, וועלכער איז געווען פאר מיר; ווייל ער איז געווען פארויס פאר מיר. ");
INSERT INTO ydd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","און איך האב אים נישט געקענט; נאר כדי ער זאל אנטפלעקט ווערן צו ישראל, דערפאר בין איך געקומען, טובל זייענדיק מיט וואסער אין דער מקווה. ");
INSERT INTO ydd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","און יוחנן האט עדות געזאגט, אזוי צו זאגן: איך האב געזען דעם גייסט אראפנידערן פון הימל ווי א טויב; און בלייבן אויף אים. ");
INSERT INTO ydd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","און איך האב אים נישט געקענט; נאר דער, וואס האט מיך געשיקט טובל צו זיין מיט וואסער אין א מקווה, האט צו מיר געזאגט: אויף וועמען דו וועסט זען דעם גייסט אראפשוועבן, און בלייבן אויף אים, דער דאזיקער איז עס, וועלכער איז טובל אין א מקווה מיט דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","און איך האב געזען, און האב עדות געזאגט, אז ער איז דער זון פון דער אויבערשטער. ");
INSERT INTO ydd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","צומארגנס איז יוחנן ווידער געשטאנען, און צוויי פון זיינע תלמידים; ");
INSERT INTO ydd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","און דערזעענדיק יהושען/ישוען ווי ער איז פארבייגעגאנגען, האט ער געזאגט: זעט, דאס (איז) ה׳ס לאם! ");
INSERT INTO ydd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","און די צוויי תלמידים זיינע האבן אים געהערט רעדן, און האבן נאכגעפאלגט יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","און אויסדרייענדיק זיך און זעענדיק זיי נאכפאלגען, האט יהושע/ישוע צו זיי געזאגט: וואס באגערט איר? האבן זיי געזאגט צו אים: רבי (דאס הייסט, לערער) וואו וואוינסטו? ");
INSERT INTO ydd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","זאגט ער צו זיי: קומט און זעט. זענען זיי דעריבער געקומען און האבן געזען וואו ער האט געוואוינט; און זענען ביי אים פארבלייבן יענעם טאג. עס איז געווען ארום דער צענטער שעה. ");
INSERT INTO ydd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","איינער פון די צוויי, וואס האבן געהערט פון יוחנן און האבן אים נאכגעפאלגט, איז געווען אנדריי, דער ברודער פון שמעון פעטרוס. ");
INSERT INTO ydd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","דער דאזיקער געפינט צוערשט זיין אייגענעם ברודער שמעון און זאגט צו אים: מיר האבן געפונען דעם משיח, (דאס הייסט פארטייטשט, געזאלבטער). ");
INSERT INTO ydd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ער האט אים געברענגט צו יהושען/ישוען. יהושע/ישוע האט א בליק געטאן אויף אים און געזאגט: דו ביסט שמעון בן יונה; דו זאלסט הייסן כיפא, (פארטייטשט אויף יידיש, פעלדזן). ");
INSERT INTO ydd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","צומארגנס האט ער געוואלט ארויסגיין קיין גליל, און געפינט פיליפוסן; און יהושע/ישוע זאגט צו אים: פאלג מיר נאך. ");
INSERT INTO ydd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","און דער פיליפוס איז געווען פון בית‑צידה, פון דער שטאט פון אנדריי און פעטרוס. ");
INSERT INTO ydd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","פיליפוס געפינט נתנאלן און זאגט צו אים: אים, פון וועמען משה האט געשריבן אין דער תורה, און די נביאים, האבן מיר געפונען, יהושע/ישוע בן יוסף פון נצרת. ");
INSERT INTO ydd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","און נתנאל האט צו אים געזאגט: פון נצרת קען דען זיין עפעס גוטס? זאגט פיליפוס צו אים: קום און זע. ");
INSERT INTO ydd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","יהושע/ישוע האט געזען נתנאלן קומען צו אים, און זאגט וועגן אים: אָט איז אן אמתער ישראל, אין וועמען עס איז נישט פאראן קיין כיטרעקייט. ");
INSERT INTO ydd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","זאגט נתנאל צו אים: פונוואנען קענסטו מיך? האט יהושע/ישוע געענטפערט און געזאגט צו אים: איידער נאך פיליפוס האט דיך גערופן, האב איך דיך געזען, בשעת דו ביסט נאך געווען אונטער דעם פייגנבוים. ");
INSERT INTO ydd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","האט נתנאל אים געענטפערט: רבי, דו ביסט דער זון פון דער אויבערשטער; דו ביסט דער מלך פון ישראל. ");
INSERT INTO ydd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","האט יהושע/ישוע געענטפערט און געזאגט צו אים: ווייל איך האב דיר געזאגט, אז איך האב דיך געזען אונטער דעם פייגנבוים, גלויבסטו? גרעסערע זאכן ווי די דאזיקע וועסטו זען. ");
INSERT INTO ydd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","און זאגט צו אים: באמת, באמת זאג איך אייך: איר וועט זען דעם הימל אפן, און די מלאכים פון ה׳ ארויפגיין און אראפקומען אויף דעם בר אנש. ");
INSERT INTO ydd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","און דעם דריטן טאג איז געווען א חתונה אין קנה פון גליל; און ישועס מוטער איז דארטן געווען, ");
INSERT INTO ydd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","און אויך יהושע/ישוע און זיינע תלמידים זענען פארבעטן געווארן אויף דער חתונה. ");
INSERT INTO ydd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","און ווען עס האט אויסגעפעלט וויין, זאגט ישועס מוטער צו אים: זיי האבן נישט קיין וויין. ");
INSERT INTO ydd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","און יהושע/ישוע זאגט צו איר: וואס האב איך מיט דיר, אשה? מיין שעה איז נאך נישט געקומען. ");
INSERT INTO ydd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","זאגט זיין מוטער צו די סארווערס: וואס ער וועט אייך זאגן, זאלט איר טאן. ");
INSERT INTO ydd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","און דארטן זענען געווען אוועקגעשטעלט זעקס שטיינערנע וואסערגעפעסן, לויטן מנהג פון וואשן זיך ביי יידן, יעדעס איינע האט אנטהאלטן צו צוויי אדער דריי עמער. ");
INSERT INTO ydd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","זאגט יהושע/ישוע צו זיי: פילט אָן די געפעסן מיט וואסער. און זיי האבן די דאזיקע אנגעפילט ביז ארויף. ");
INSERT INTO ydd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","און ער זאגט צו זיי: איצט שעפט אָן און טראגט עס צו דעם, וואס זיצט אויבנאן. און זיי האבן עס געטראגן. ");
INSERT INTO ydd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ווי אבער דער, וואס איז געזעסן אויבנאן האט טועם געווען דאס וואסער, וואס איז געווארן וויין, און האט נישט געוואוסט פונוואנען עס איז—די סארווערס אבער, וואס האבן געשעפט דאס וואסער, האבן יא געוואוסט—רופט דער, וואס איז געזעסן אויבנאן דעם חתן, ");
INSERT INTO ydd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","און זאגט צו אים: יעדער מענטש שטעלט קודם כל אוועק דעם גוטן וויין, און ווען מען האט זיך שוין אנגעטרונקען, דעמאלט דעם ערגערן; און דו האסט באהאלטן דעם גוטן וויין ביז איצט. ");
INSERT INTO ydd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","דעם דאזיקן אנהויב פון די נסים האט יהושע/ישוע געמאכט אין קנה פון גליל, און האט אנטפלעקט זיין הערלעכקייט, און זיינע תלמידים האבן אין אים געגלויבט. ");
INSERT INTO ydd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","נאך דעם איז ער אראפגעגאנגען קיין כפר‑נחום, ער און זיין מוטער און די ברידער און זיינע תלמידים, און זענען דארט פארבלייבן נישט קיין סך טעג. ");
INSERT INTO ydd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","און דער יידישער פסח איז געווען נאענט, און יהושע/ישוע איז ארויפגעגאנגען קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","און האט געפונען אין בית המקדש די פארקויפער פון רינדער און שאף און טויבן, און די געלט וועקסלער זיצן. ");
INSERT INTO ydd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","און ער האט געמאכט א קאנטשיק פון שטריקלעך און אלעמען ארויסגעטריבן פונם בית המקדש מיט די שאף און די רינדער; און אויסגעשיט דאס געלט פון די אויסבייטער און די טישן אומגעקערט; ");
INSERT INTO ydd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","און צו די, וואס האבן פארקויפט טויבן, האט ער געזאגט: נעמט די דאזיקע אוועק פונדאנען; מאכט נישט פון מיין פאטערס הויז א הויז פון מסחר. ");
INSERT INTO ydd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","זיינע תלמידים האבן זיך דערמאנט, אז עס שטייט געשריבן: דער אייפער פון דיין הויז האט מיך פארצערט. ");
INSERT INTO ydd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","די יידן האבן דעריבער געענטפערט און געזאגט צו אים: וואס פאר א צייכן ווייזט דו אונדז, אז דו טוסט די דאזיקע זאכן? ");
INSERT INTO ydd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","האט יהושע/ישוע געענטפערט און געזאגט צו זיי: צעשטערט דעם דאזיקן היכל, און אין דריי טעג וועל איך אים אויפשטעלן. ");
INSERT INTO ydd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","אזוי האבן די יידן געזאגט: זעקס און פערציק יאר איז דער דאזיקער היכל געבויט געווארן, און דו שטעלסט אים אויף אין דריי טעג? ");
INSERT INTO ydd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ער אבער האט גערעדט וועגן דעם היכל פון זיין אייגענעם גוף. ");
INSERT INTO ydd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","דעריבער, ווען ער איז אויפגעשטאנען פון די טויטע, האבן זיך זיינע תלמידים דערמאנט, אז ער האט דאס דאזיקע געזאגט; און האבן געגלויבט אין דער (הייליקער) שריפט און אין דעם ווארט, וואס יהושע/ישוע האט געזאגט. ");
INSERT INTO ydd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","און בעת ער איז געווען אין ירושלים דעם יום טוב פסח, האבן א סך געגלויבט אין זיין נאמען, זעענדיק די נסים, וואס ער האט געטאן. ");
INSERT INTO ydd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","יהושע/ישוע אליין אבער האט זיך זיי נישט פארטרויט, ווייל ער האט אלעמען געקענט, ");
INSERT INTO ydd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","און נישט נייטיק געהאט, אז עמיצער זאל עדות זאגן וועגן דעם מענטשן; ווארום ער אליין האט געוואוסט וואס עס איז אין א מענטשן. ");
INSERT INTO ydd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","און עס איז געווען א מאן פון די פרושים, ער האט געהייסן נקדימון, א שר ביי יידן; ");
INSERT INTO ydd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","דער דאזיקער איז געקומען צו אים ביינאכט, און האט צו אים געזאגט: רבי, מיר ווייסן, אז דו ביסט א לערער, געקומען פון ה׳; ווארום קיינער קען נישט טאן די דאזיקע נסים, וואס דו טוסט, אויב ה׳ איז נישט מיט אים. ");
INSERT INTO ydd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","האט יהושע/ישוע געענטפערט און געזאגט צו אים: באמת, באמת זאג איך דיר: אויב איינער ווערט נישט ווידער געבוירן, קען ער נישט זען דאס קעניגרייך פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","זאגט נקדימון צו אים: וויאזוי קען א מענטש געבוירן ווערן, זייענדיק א זקן? צי קען ער דען א צווייט מאל אריינגיין אין זיין מוטערס לייב און געבוירן ווערן? ");
INSERT INTO ydd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","האט יהושע/ישוע געענטפערט: באמת, באמת זאג איך דיר: אויב איינער ווערט נישט געבוירן פון וואסער און פון גייסט (וואשנדיק פון התחדשות), קען ער נישט אריינגיין אין דעם קעניגרייך פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","דאס, וואס איז געבוירן פון דעם פלייש, איז פלייש; און דאס, וואס איז געבוירן פון גייסט, איז גייסט. ");
INSERT INTO ydd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","וואונדער דיך נישט, ווייל איך האב דיר געזאגט: איר מוזט ווידער געבוירן ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","דער ווינט בלאזט, וואו ער וויל, און דו הערסט זיין קול, נאר ווייסט נישט, פונוואנען ער קומט און וואואהין ער גייט; פונקט אזוי איז יעדער איינער וואס איז געבוירן פון דעם גייסט. ");
INSERT INTO ydd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","נקדימון האט געענטפערט און געזאגט צו אים: וויאזוי קען דאס געשען? ");
INSERT INTO ydd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","האט יהושע/ישוע געענטפערט און געזאגט צו אים: דו ביסט א רבי בישראל, און ווייסט דאס נישט? ");
INSERT INTO ydd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","באמת, באמת זאג איך דיר: וואס מיר ווייסן, דאס רעדן מיר, און וואס מיר האבן געזען, דערפון זאגן מיר עדות: און איר נעמט אונדזער עדות זאגן נישט אָן. ");
INSERT INTO ydd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","אויב איך האב צו אייך גערעדט פון ערדישע זאכן, און איר גלויבט נישט, וויאזוי וועט איר גלויבן, ווען איך וועל צו אייך רעדן פון הימלישע זאכן? ");
INSERT INTO ydd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","און קיינער איז נישט ארויפגעגאנגען אין הימל אריין, אחוץ דער, וועלכער איז אראפגעקומען פון הימל, דער בר אנש, וואס איז אין הימל. ");
INSERT INTO ydd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","און ווי משה האט אויפגעהויבן די שלאנג אין דער מדבר, אזוי מוז דער בר אנש אויפגעהויבן ווערן; ");
INSERT INTO ydd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","כדי יעדער איינער, וואס גלויבט אין אים, זאל האבן אייביק לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ווארום ה׳ האט אזוי ליב געהאט די וועלט, אז ער האט געגעבן זיין בן יחיד, כדי יעדער איינער, וואס גלויבט אין אים, זאל נישט פארלוירן ווערן, נאר האבן אייביק לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ווארום ה׳ האט נישט געשיקט זיין זון אין דער וועלט אריין, כדי צו משפטן די וועלט, נאר כדי די וועלט זאל דורך אים געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","דער, וואס גלויבט אין אים, ווערט נישט געמשפט; דער, וואס גלויבט נישט, איז שוין געמשפט געווארן, ווייל ער האט נישט געגלויבט אין דעם נאמען פון דעם בן יחיד פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","און דאס איז דאס משפט: דאס ליכט איז געקומען אין דער וועלט אריין, און די מענטשן האבן ליבער געהאט די פינצטערניש ווי דאס ליכט; ווייל זייערע מעשים זענען געווען בייז. ");
INSERT INTO ydd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ווארום יעדער איינער, וואס טוט שלעכטס, האט פיינט דאס ליכט, און קומט נישט צו דעם ליכט, כדי זיינע מעשים זאלן נישט אויפגעדעקט ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","דער אבער, וואס טוט דעם אמת, קומט צום ליכט, כדי זיינע מעשים זאלן אנטפלעקט ווערן, אז זיי ווערן געטאן אין ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","נאך דעם איז יהושע/ישוע אוועק מיט זיינע תלמידים צום לאנד יהודה, און איז דארטן פארבלייבן מיט זיי, און האט טובל געווען אין דער מקווה. ");
INSERT INTO ydd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","און אויך יוחנן האט טובל געווען אין דער מקווה אין עינון, נאענט ביי שלם, ווייל דארטן איז געווען א סך וואסער פאר דער מקווה; און מען פלעגט קומען און זיך לאזן טובל זיין אין דער מקווה. ");
INSERT INTO ydd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ווארום יוחנן איז נאך נישט געווען אריינגעווארפן אין תפיסה. ");
INSERT INTO ydd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","און עס איז געקומען צו א מחלוקה צווישן די תלמידים פון יוחנן און א יידן וועגן טהרה. ");
INSERT INTO ydd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","און זיי זענען געקומען צו יוחנן, און האבן געזאגט צו אים: רבי, ער, וואס איז געווען מיט דיר אויף יענער זייט ירדן, וועגן וועמען דו האסט עדות געזאגט, אָט זע, ער טובלט אין דער מקווה, און אלע קומען צו אים. ");
INSERT INTO ydd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","האט יוחנן געענטפערט און געזאגט: קיין מענטש קען זיך גארנישט נעמען, אויב עס איז אים נישט געגעבן געווארן פון הימל. ");
INSERT INTO ydd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","איר אליין זענט מיינע עדות, אז איך האב געזאגט: איך בין נישט דער משיח, נאר אז איך בין געשיקט געווארן פאר אים. ");
INSERT INTO ydd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ווער עס האט די כלה, דער איז דער חתן; אבער דער פריינד פון דעם חתן, וואס שטייט און הערט זיך צו צו אים, טוט מיט שמחה זיך פרייען איבער דעם חתנס קול; אָט די דאזיקע פרייד מיינע איז דערפילט. ");
INSERT INTO ydd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ער מוז וואקסן, איך אבער פארמינערט ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","דער, וואס קומט פון אויבן, איז איבער אלעמען: דער, וואס איז פון דער ערד, איז פון דער ערד, און רעדט פון דער ערד; דער, וואס קומט פון הימל, איז איבער אלעמען. ");
INSERT INTO ydd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","וואס ער האט געזען און געהערט, דערפון זאגט ער עדות; און זיין עדות זאגן נעמט קיינער נישט אָן. ");
INSERT INTO ydd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ווער עס נעמט יא אָן זיין עדות זאגן, דער האט צוגעלייגט זיין חתימה, אז ה׳ איז אמת. ");
INSERT INTO ydd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ווארום ער, וועמען ה׳ האט געשיקט, רעדט די ווערטער פון ה׳; ווארום ער גיט נישט דעם גייסט מיט א מאס. ");
INSERT INTO ydd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","דער פאטער האט ליב דעם זון, און האט אלץ געגעבן אין זיין האנט אריין. ");
INSERT INTO ydd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","דער, וואס גלויבט אין דעם זון, האט אייביק לעבן; ווער אבער עס געהארכט נישט דעם זון, דער וועט נישט זען קיין לעבן, נאר ה׳ס צארן בלייבט אויף אים. ");
INSERT INTO ydd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ווען דעריבער דער האר האט זיך דערוואוסט, אז די פרושים האבן געהערט, אז יהושע/ישוע מאכט און איז טובל אין דער מקווה מער תלמידים ווי יוחנן— ");
INSERT INTO ydd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","הגם יהושע/ישוע אליין האט נישט געטובלט אין דער מקווה, נאר זיינע תלמידים— ");
INSERT INTO ydd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","האט ער פארלאזט דאס לאנד יהודה, און איז ווידער אוועק קיין גליל. ");
INSERT INTO ydd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","און האט געמוזט דורכגיין דורך שומרון. ");
INSERT INTO ydd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","און אזוי קומט ער אין א שטאט פון שומרון, וועלכע מען רופט סוכר, נאענט ביי דעם פעלד, וואס יעקב האט געגעבן צו זיין זון יוסף; ");
INSERT INTO ydd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","און דארט איז געווען יעקבס ברונעם. און זייענדיק מיד פון דער נסיעה, האט יהושע/ישוע זיך אזוי אנידערגעזעצט ביים ברונעם; עס איז געווען ארום דער זעקסטער שעה. ");
INSERT INTO ydd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","קומט א פרוי פון שומרון שעפן וואסער; זאגט יהושע/ישוע צו איר: גיב מיר צו טרינקען. ");
INSERT INTO ydd_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ווארום די תלמידים זיינע זענען אוועקגעגאנגען אין שטאט אריין, כדי איינצוקויפן שפייז. ");
INSERT INTO ydd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","זאגט דעריבער צו אים די שומרונישע פרוי: וויאזוי בעטסטו, א ייד, צו טרינקען פון מיר, וואס איך בין א שומרונישע פרוי? ווארום יידן האבן נישט קיין מגע־משא מיט שומרונים. ");
INSERT INTO ydd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","האט יהושע/ישוע געענטפערט און געזאגט צו איר: אויב דו וואלסט געקענט די מתנה פון ה׳, און ווער דער איז, וואס זאגט צו דיר: גיב מיר צו טרינקען, וואלסטו אים געבעטן, און ער וואלט דיר געגעבן לעבעדיק וואסער. ");
INSERT INTO ydd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","זאגט די פרוי צו אים: האר, דו האסט נישט מיט וואס אנצושעפן, און דער ברונעם איז טיף; פונוואנען זשע האסטו דאס לעבעדיקע וואסער? ");
INSERT INTO ydd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","צי ביסטו דען גרעסער ווי אונדזער פאטער יעקב, וועלכער האט אונדז געגעבן דעם ברונעם, און אליין פון אים געטרונקען, און זיינע זין און זיינע סטאדעס? ");
INSERT INTO ydd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","האט יהושע/ישוע געענטפערט און געזאגט צו איר: יעדער איינער, וואס טרינקט פון דעם דאזיקן וואסער, וועט ווידער דארשטיק ווערן; ");
INSERT INTO ydd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ווער אבער עס וועט טרינקען פון דעם וואסער, וואס איך וועל אים געבן, דער וועט ביז אויף אייביק מער נישט דארשטיק ווערן; נאר דאס וואסער, וואס איך וועל אים געבן, וועט ווערן אין אים א וואסער קוואל, וואס שפרודלט צום אייביקן לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","זאגט די פרוי צו אים: האר, גיב מיר דאס דאזיקע וואסער, כדי איך זאל נישט דורשטן, און נישט דארפן אהערקומען אנצושעפן. ");
INSERT INTO ydd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","זאגט יהושע/ישוע צו איר: גיי רוף דיין מאן, און קום אהער. ");
INSERT INTO ydd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","האט די פרוי געענטפערט און געזאגט: איך האב נישט קיין מאן. זאגט יהושע/ישוע צו איר: דו האסט ריכטיק געזאגט: איך האב נישט קיין מאן; ");
INSERT INTO ydd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ווארום דו האסט שוין געהאט פינף מענער, און ער, וועמען דו האסט איצט, איז נישט דיין מאן; דאס דאזיקע האסטו אמת געזאגט. ");
INSERT INTO ydd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","זאגט די פרוי צו אים: האר, איך זע, אז דו ביסט א נביא. ");
INSERT INTO ydd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","אונדזערע אבות האבן זיך געבוקט (צו ה׳) אויף דעם דאזיקן בארג; און איר זאגט, אז אין ירושלים איז דאס ארט, וואו מען דארף זיך בוקן (צו ה׳). ");
INSERT INTO ydd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","זאגט יהושע/ישוע צו איר: גלויב מיר, אשה, אז עס קומט א שעה, ווען נישט אויף דעם דאזיקן בארג, נישט אין ירושלים וועט איר זיך בוקן צום פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","איר בוקט זיך צו וואס איר ווייסט נישט, מיר ווייסן יא צו וועמען מיר בוקן זיך; ווייל די ישועה איז פון די יידן. ");
INSERT INTO ydd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","נאר עס קומט א שעה, און איז שוין איצט, ווען די ווארהאפטיקע דינער פון ה׳, וועלן זיך בוקן צום פאטער אין גייסט און אין דער ווארהייט; ווארום דער פאטער זוכט אזעלכע, וואס זאלן זיך בוקן צו אים. ");
INSERT INTO ydd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ה׳ איז א גייסט, און די, וואס בוקן זיך צו אים, מוזן זיך בוקן אין גייסט און אין דער ווארהייט. ");
INSERT INTO ydd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","זאגט צו אים די פרוי: איך ווייס, אז דער משיח קומט, (וואס הייסט געזאלבטער) ווען ער וועט קומען, וועט ער אונדז אלץ זאגן. ");
INSERT INTO ydd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","זאגט צו איר יהושע/ישוע: איך בין עס, וואס רעדט מיט דיר. ");
INSERT INTO ydd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","און ביי דעם דאזיקן זענען זיינע תלמידים אנגעקומען, און האבן זיך געוואונדערט, אז ער רעדט מיט א פרוי; דאך האט קיינער נישט געזאגט: וואס ווילסטו? אדער: פארוואס רעדסטו מיט איר? ");
INSERT INTO ydd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","און די פרוי האט איבערגעלאזט איר וואסער קרוג, און איז אוועק אין שטאט אריין, און זאגט צו די מענטשן: ");
INSERT INTO ydd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","קומט, זעט א מענטשן, וועלכער האט מיר געזאגט אלץ, וואס איך האב געטאן; איז דאס נישט אפשר דער משיח? ");
INSERT INTO ydd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","זענען זיי ארויסגעגאנגען אויס דער שטאט, און זענען געקומען צו אים. ");
INSERT INTO ydd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","דערווייל האבן אים די תלמידים געבעטן, אזוי צו זאגן: רבי, עס. ");
INSERT INTO ydd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ער אבער האט צו זיי געזאגט: איך האב א שפייז צו עסן, וואס איר קענט זי נישט. ");
INSERT INTO ydd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","האבן די תלמידים דעריבער געזאגט איינער צום אנדערן: צי האט אים דען עמיצער געברענגט עפעס צו עסן? ");
INSERT INTO ydd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","זאגט יהושע/ישוע צו זיי: מיין שפייז איז, אז איך זאל טאן דעם רצון פון דעם, וועלכער האט מיך געשיקט, און צו ענדיקן זיין ווערק. ");
INSERT INTO ydd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","צי זאגט איר דען נישט: נאך פיר חדשים, און עס קומט דער שניט? זע, איך זאג אייך: הייבט אויף אייערע אויגן און זעט די פעלדער, אז זיי זענען שוין ווייס צום שניט. ");
INSERT INTO ydd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","דער שניטער באקומט א שכר, און זאמלט איין פירות צום אייביקן לעבן, כדי דער פארזייער און דער שניטער זאלן זיך פרייען צוזאמען. ");
INSERT INTO ydd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ווארום אין דעם דאזיקן (פאל) איז דאס שפריכווארט אמת: איינער זייעט, אן אנדערער שניידט. ");
INSERT INTO ydd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","איך האב אייך געשיקט צו שניידן, וואס איר האט נישט באארבעט; אנדערע האבן געארבעט, און איר זענט אריינגעקומען אין זייער ארבעט אריין. ");
INSERT INTO ydd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","און פון יענער שטאט האבן א סך שומרונים געגלויבט אין אים דורך דעם ווארט פון דער פרוי, וואס האט עדות געזאגט: ער האט מיר געזאגט אלץ, וואס איך האב געטאן. ");
INSERT INTO ydd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","און ווי די שומרונים זענען געקומען צו אים, האבן זיי אים געבעטן צו בלייבן ביי זיי; און ער איז דארט געבליבן צוויי טעג. ");
INSERT INTO ydd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","און א סך מער האבן געגלויבט דורך זיין ווארט, ");
INSERT INTO ydd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","און האבן געזאגט צו דער פרוי: מיר גלויבן מער נישט צוליב דיין רעדן, ווארום מיר אליין האבן אים געהערט; און ווייסן, אז ער איז באמת דער משיח, דער גואל פון דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","און אין צוויי טעג ארום איז ער פון דארטן ארויסגעגאנגען קיין גליל. ");
INSERT INTO ydd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ווארום יהושע/ישוע אליין האט עדות געזאגט, אז א נביא האט נישט קיין כבוד אין זיין אייגן היימלאנד. ");
INSERT INTO ydd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ווען דעריבער ער איז געקומען קיין גליל, האבן די לייט פון גליל אים אויפגענומען, ווייל זיי האבן געזען אלץ, וואס ער האט געטאן אין ירושלים דעם יום טוב; ווארום זיי אליין זענען אויך ארויפגעגאנגען אויף יום טוב. ");
INSERT INTO ydd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","און ער איז ווידעראמאל געקומען קיין קנה פון גליל, וואו ער האט געמאכט פון דעם וואסער וויין. און עס איז געווען א געוויסער קעניגלעכער באאמטער, וועמעס זון איז געלעגן קראנק אין כפר‑נחום. ");
INSERT INTO ydd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ווי דער דאזיקער האט געהערט, אז יהושע/ישוע איז אנגעקומען פון יהודה קיין גליל, איז ער אוועק צו אים, און אים געבעטן, אז ער זאל אראפגיין און היילן זיין זון; ווייל ער האט געהאלטן ביים שטארבן. ");
INSERT INTO ydd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","און יהושע/ישוע האט געזאגט צו אים: אויב איר זעט נישט קיין אותות ומופתים, ווילט איר בשום אופן נישט גלויבן. ");
INSERT INTO ydd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","זאגט דער קעניגלעכער באאמטער צו אים: האר, קום אראפ, איידער מיין קינד שטארבט. ");
INSERT INTO ydd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","זאגט יהושע/ישוע צו אים: גיי, דיין זון לעבט! דער מענטש האט געגלויבט אין דעם ווארט, וואס יהושע/ישוע האט צו אים געזאגט, און איז געגאנגען. ");
INSERT INTO ydd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","און בשעת ער איז אראפגעגאנגען, האבן אים זיינע קנעכט באגעגענט, און געזאגט, אז זיין יינגל לעבט. ");
INSERT INTO ydd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ער האט זיך דעריבער נאכגעפרעגט ביי זיי די שעה, אין וועלכער עס איז אים בעסער געווארן. האבן זיי אים געזאגט: נעכטן אין דער זיבעטער שעה האט דאס פיבער אים פארלאזט. ");
INSERT INTO ydd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","דער פאטער האט דעריבער געוואוסט, אז עס איז געווען אין יענער שעה, איז וועלכער יהושע/ישוע האט צו אים געזאגט: דיין זון לעבט; און ער האט געגלויבט און דאס גאנצע הויז זיינס. ");
INSERT INTO ydd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","דאס דאזיקע איז שוין דאס צווייטע נס, וואס יהושע/ישוע האט געטאן, ווען ער איז געקומען פון יהודה קיין גליל. ");
INSERT INTO ydd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","נאך דעם איז געווען א יידישער יום טוב, און יהושע/ישוע איז ארויפגעגאנגען קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","און אין ירושלים ביים שער הצאן איז דא א טייך, וואס הייסט אויף לשון קודש בית-חסדא, און האט פינף זאלן. ");
INSERT INTO ydd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","אין די דאזיקע איז געלעגן א מאסע קראנקע, בלינדע, הינקענדיקע, אויסגעצערטע, (וואס האבן געווארט, אז דאס וואסער זאל זיך באוועגן; ");
INSERT INTO ydd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ווארום פון צייט צו צייט פלעגט אראפקומען א מלאך פון דעם האר (ג‑ט) אין דעם טייך אריין און באוועגן דאס וואסער; דעריבער ווער עס איז אריינגעגאנגען דער ערשטער נאך דער באוועגונג פונם וואסער, דער איז געזונט געווארן, פון יעדער קראנקייט וואס ער האט נאר געהאט.) ");
INSERT INTO ydd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","און דארט איז געווען א מענטש, וואס איז קראנק געווען אכט און דרייסיק יאר לאנג. ");
INSERT INTO ydd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ווען יהושע/ישוע האט געזען דעם דאזיקן ליגן, און האט זיך דערוואוסט, אז ער ליגט שוין דארט א לאנגע צייט, זאגט ער צו אים: ווילסט געזונט ווערן? ");
INSERT INTO ydd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","האט דער חולה אים געענטפערט: האר, איך האב נישט קיין מענטשן, מיך אריינצואווארפן אין טייך אריין, ווען דאס וואסער ווערט באוועגט; נאר בשעת איך קום, גייט אן אנדערער אראפ פאר מיר. ");
INSERT INTO ydd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","זאגט יהושע/ישוע צו אים: שטיי אויף, נעם דיין בעט און גיי. ");
INSERT INTO ydd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","און גלייך איז דער מענטש געזונט געווארן, און האט גענומען זיין בעט, און איז ארומגעגאנגען. און יענער טאג איז געווען א שבת. ");
INSERT INTO ydd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","די יידן האבן דעריבער געזאגט צום געהיילטן: עס איז שבת, און דו טארסט נישט טראגן דאס בעט. ");
INSERT INTO ydd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ער אבער האט זיי געענטפערט: דער, וואס האט מיך געזונט געמאכט, האט צו מיר געזאגט: נעם דיין בעט און גיי. ");
INSERT INTO ydd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","האבן זיי אים געפרעגט: ווער איז דער מענטש, וואס האט צו דיר געזאגט: נעם און גיי? ");
INSERT INTO ydd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","און דער, וואס איז געהיילט געווארן, האט נישט געוואוסט, ווער עס איז; ווארום יהושע/ישוע האט זיך אוועקגעקערט, מחמת עס איז געווען א המון מענטשן אויף דעם ארט. ");
INSERT INTO ydd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","שפעטער האט יהושע/ישוע אים געפונען אין בית המקדש, און צו אים געזאגט: זע, דו ביסט געזונט געווארן; זינדיק נישט מער, כדי קיין ערגערס זאל דיר נישט געשען. ");
INSERT INTO ydd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","איז דער מענטש אוועקגעגאנגען, און האט געזאגט צו די יידן, אז עס איז יהושע/ישוע, וואס האט אים געזונט געמאכט. ");
INSERT INTO ydd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","און צוליב דעם האבן די יידן גערודפט יהושען/ישוען, ווייל ער האט עס געטאן אין שבת. ");
INSERT INTO ydd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","יהושע/ישוע אבער האט זיי געענטפערט: מיין פאטער ארבעט ביז אצונד, און איך ארבעט אויך. ");
INSERT INTO ydd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","דערפאר טאקע האבן די יידן נאך מער געזוכט אים צו טייטן, ווייל נישט נאר האט ער מחלל שבת געווען, נאר האט געזאגט, אז ה׳ איז זיין פאטער (ישעיהו ד, ב.), מאכנדיק זיך גלייך צו ג‑ט. ");
INSERT INTO ydd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","יהושע/ישוע האט דעריבער געענטפערט און געזאגט צו זיי: באמת, באמת זאג איך אייך: דער זון קען פון זיך אליין גארנישט טאן, אחוץ דאס, וואס ער זעט דעם פאטער טאן; ווארום וואס ער טוט, דאס טוט אויך דער זון אויף אן ענלעכן אופן. ");
INSERT INTO ydd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ווארום דער פאטער האט ליב דעם זון, און ווייזט אים אלץ, וואס ער אליין טוט; און גרעסערע מעשים ווי די דאזיקע וועט ער אים ווייזן, כדי איר זאלט זיך וואונדערן. ");
INSERT INTO ydd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ווארום ווי דער פאטער וועקט אויף די טויטע און מאכט לעבעדיק, אזוי אויך מאכט דער זון לעבעדיק וועמען ער וויל. ");
INSERT INTO ydd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ווארום דער פאטער משפט נישט קיינעם, נאר האט איבערגעגעבן דאס גאנצע משפט צום זון, ");
INSERT INTO ydd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","כדי אלע זאלן אפגעבן כבוד דעם זון, ווי זיי גיבן אפ כבוד דעם פאטער. ווער עס גיט נישט אפ כבוד דעם זון, דער גיט נישט אפ כבוד דעם פאטער, וואס האט אים געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","באמת, באמת זאג איך אייך: ווער עס הערט מיין ווארט, און גלויבט אין אים, וואס האט מיך געשיקט, דער האט אייביק לעבן, און קומט נישט צום משפט, נאר איז שוין אריבער פון טויט אין לעבן אריין. ");
INSERT INTO ydd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","באמת, באמת זאג איך אייך: עס קומט אָן א שעה, און איז שוין, ווען די מתים וועלן הערן דאס קול פון דעם זון פון דער אויבערשטער; און די, וואס הערן עס, וועלן לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ווארום ווי דער פאטער האט לעבן אין זיך אליין, אזוי האט ער אויך געגעבן דעם זון, צו האבן לעבן אין זיך אליין; ");
INSERT INTO ydd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","אויך האט ער אים געגעבן רשות צו טאן משפט, ווייל ער איז דער בר אנש. ");
INSERT INTO ydd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","וואונדערט זיך נישט איבער דעם; ווייל א שעה קומט אָן, אין וועלכער אלע, וואס זענען אין די קברים, וועלן הערן זיין קול, ");
INSERT INTO ydd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","און וועלן ארויסקומען; די, וואס האבן געטאן (מעשים) טובים, צו דער אויפשטייאונג פון לעבן; אבער די, וואס האבן געטאן (מעשים) רעים, צו דער אויפשטייאונג פון משפט. ");
INSERT INTO ydd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","איך קען פון מיר אליין גארנישט טאן; ווי איך הער, אזוי משפט איך; און מיין משפט איז גערעכט, ווייל איך זוך נישט מיין ווילן, נאר דעם רצון פון דעם פאטער, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","אויב איך זאג עדות וועגן מיר אליין, איז מיין עדות זאגן נישט אמת. ");
INSERT INTO ydd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","אן אנדערער איז עס, וואס זאגט עדות וועגן מיר; און איך ווייס, אז ווארהאפטיק איז דאס עדות זאגן, וואס ער זאגט וועגן מיר. ");
INSERT INTO ydd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","איר האט געשיקט צו יוחנן, און ער האט עדות געזאגט אויף דעם אמת. ");
INSERT INTO ydd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","איך אבער נעם נישט אָן דאס עדות זאגן פון א מענטשן, נאר דאס זאג איך, כדי איר זאלט געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ער איז געווען דאס ברענענדיקע און שיינענדיקע ליכט; און איר האט זיך געוואלט משמח זיין לפי שעה אין זיין ליכט. ");
INSERT INTO ydd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","איך אבער האב דאס עדות זאגן, וואס איז גרעסער ווי יוחננס; ווארום די מעשים, וואס דער פאטער האט מיר געגעבן, כדי איך זאל זיי פארענדיקן, די זעלביקע מעשים, וואס איך טו, זאגן עדות וועגן מיר, אז דער פאטער האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","און דער פאטער, וואס האט מיך געשיקט, האט עדות געזאגט וועגן מיר. נישט האט איר, ווען עס איז, געהערט זיין קול, נישט האט איר זיין געזען געשטאלט. ");
INSERT INTO ydd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","און זיין ווארט האט איר נישט וואוינען אין אייך, ווייל איר גלויבט נישט אין דעם דאזיקן, וועמען ער האט געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","איר פארשט (דאך) אין די כתבי (הקודש), ווייל איר מיינט, אז אין זיי האט איר אייביק לעבן; און זיי זענען עס, וואס זאגן עדות וועגן מיר. ");
INSERT INTO ydd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","און איר ווילט נישט קומען צו מיר, כדי איר זאלט האבן לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","כבוד פון מענטשן נעם איך נישט אָן. ");
INSERT INTO ydd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","נאר איך קען אייך, אז איר האט נישט די ליבע פון ה׳ אין זיך. ");
INSERT INTO ydd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","איך בין געקומען אין דעם נאמען פון מיין פאטער, און איר נעמט מיך נישט אויף; ווען אן אנדערער וועט קומען אין זיין אייגענעם נאמען, וועט איר אים יא אויפנעמען. ");
INSERT INTO ydd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","וויאזוי קענט איר גלויבן, איר, וואס נעמט אָן כבוד איינער פונם אנדערן, און דעם כבוד, וואס קומט פון דעם איינציקן ג-ט, זוכט איר נישט? ");
INSERT INTO ydd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","מיינט נישט אז איך וועל אייך מקטרג זיין ביי דעם פאטער; אייער מקטרג איז משה, אויף וועמען איר האט געהאפט. ");
INSERT INTO ydd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ווייל וואלט איר געגלויבט משהן, וואלט איר אויך מיר געגלויבט, ווארום ער האט געשריבן וועגן מיר. ");
INSERT INTO ydd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","אויב אבער איר גלויבט נישט זיינע שריפטן, וויאזוי זשע וועט איר גלויבן מיינע רייד? (דברים יח, טו.) ");
INSERT INTO ydd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","נאך דעם איז יהושע/ישוע אוועק אויף דער אנדערער זייט פון דעם ים פון גליל—ים כנרת (טבריה). ");
INSERT INTO ydd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","און א גרויסער המון מענטשן האט אים נאכגעפאלגט, ווייל זיי האבן געזען די נסים, וואס ער האט געטאן מיט די קראנקע. ");
INSERT INTO ydd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","און יהושע/ישוע איז ארויפגעגאנגען אויף דעם בארג, און האט זיך דארט אנידערגעזעצט צוזאמען מיט זיינע תלמידים. ");
INSERT INTO ydd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","און עס איז געווען נאענט צום יידישן יום טוב פסח. ");
INSERT INTO ydd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","און ווי יהושע/ישוע האט אויפגעהויבן די אויגן און געזען, אז א גרויסער המון מענטשן קומט צו אים, זאגט ער צו פיליפוסן: פונוואנען זאלן מיר קויפן ברויט, כדי זיי זאלן האבן צו עסן? ");
INSERT INTO ydd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","דאס דאזיקע האט ער געזאגט, אויספרואוונדיק אים; ווארום ער אליין האט געוואוסט, וואס ער וועט טאן. ");
INSERT INTO ydd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","פיליפוס האט אים געענטפערט: צוויי הונדערט דינרים ברויט וועט פאר זיי נישט געניגן, אז יעדער איינער זאל בלויז נעמען א שטיקל. ");
INSERT INTO ydd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","זאגט צו אים איינער פון זיינע תלמידים, אנדריי דער ברודער פון שמעון פעטרוס: ");
INSERT INTO ydd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","עס איז דא דא א יינגל, וואס האט פינף גערשטן ברויט און צוויי פישלעך; נאר וואס איז דאס פאר אזויפיל (לייט)? ");
INSERT INTO ydd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","האט יהושע/ישוע געזאגט: מאכט די מענטשן זיך אנידערזעצן. און אויף דעם ארט איז געווען א סך גראז. די מענער האבן זיך דעריבער אנידערגעזעצט, אין צאל אן ערך פינף טויזנט. ");
INSERT INTO ydd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","דאן האט יהושע/ישוע גענומען די ברויטן, האט געמאכט א ברכה און זיי צעטיילט צו די, וואס האבן זיך אנידערגעזעצט; דעסגלייכן אויך פון די פישלעך, וויפל זיי האבן געוואלט. ");
INSERT INTO ydd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","און ווען זיי זענען זאט געווארן, זאגט ער צו זיינע תלמידים: נעמט צונויף די איבערגעבליבענע ברעקלעך, כדי עס זאל גארנישט פארלוירן ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","אזוי האבן זיי צונויפגעזאמלט און אנגעפילט צוועלף קערב פון די ברעקלעך פון די פינף גערשטנברויטן, וואס זענען איבערגעבליבן צו די, וואס האבן געגעסן. ");
INSERT INTO ydd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ווען דעריבער די מענטשן האבן געזען דאס נס, וואס ער האט געטאן, האבן זיי געזאגט: דאס איז באמת דער נביא, וועלכער דארף קומען אין דער וועלט אריין. ");
INSERT INTO ydd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","דעריבער ווי יהושע/ישוע האט זיך דערוואוסט, אז זיי ווילן קומען און אים כאפן, כדי אים צו מאכן פאר א קעניג, האט ער זיך ווידער צוריקגעצויגן אויף דעם בארג ארויף איינער אליין. ");
INSERT INTO ydd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","און ווען עס איז געווארן אוונט, זענען זיינע תלמידים אראפגעגאנגען צום ים; ");
INSERT INTO ydd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","און זענען איינגעשטיגן אין א שיפל און אריבערגעפארן אויף דער אנדערער זייט ים קיין כפר‑נחום. און עס איז שוין געווען פינסטער, און יהושע/ישוע איז נאך נישט געהאט געקומען צו זיי. ");
INSERT INTO ydd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","און דער ים האט זיך אויפגעהויבן, ווייל עס האט געבלאזן א שטארקער ווינט. ");
INSERT INTO ydd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","און ווען זיי האבן געהאט גערודערט אן ערך פינף און צוואנציק אדער דרייסיק סטאדיען, האבן זיי געזען יהושען/ישוען ארומגיין אויפן ים, און זיך דערנענטערן צום שיפל; און זיי האבן מורא געהאט. ");
INSERT INTO ydd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ער אבער האט צו זיי געזאגט: איך בין עס; האט נישט קיין מורא! ");
INSERT INTO ydd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","און זיי האבן געוואלט אים נעמען אין שיפל אריין, און גלייך איז דאס שיפל געקומען צום לאנד, וואואהין זיי זענען געפארן. ");
INSERT INTO ydd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","צומארגנס האט דער המון מענטשן, וואס איז געשטאנען אויף יענער זייט ים, געזען, אז עס איז דארט נישט געווען קיין אנדער שיפל אחוץ איינס, און אז יהושע/ישוע איז נישט איינגעשטיגן מיט זיינע תלמידים אין דעם שיפל, נאר זיינע תלמידים אליין זענען אוועקגעפארן; ");
INSERT INTO ydd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","עס זענען אבער אנגעקומען שיפלעך פון טבריה נאענט צום ארט, וואו זיי האבן געגעסן דאס ברויט, נאך דעם ווי דער האר האט געמאכט א ברכה. ");
INSERT INTO ydd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ווען דעריבער דער המון מענטשן האט געזען, אז יהושע/ישוע איז דארטן נישטא, נישט די תלמידים זיינע, זענען זיי איינגעשטיגן אין די שיפלעך, און זענען געקומען קיין כפר‑נחום, און האבן געזוכט יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","און געפינענדיק אים אויף דער אנדערער זייט ים, האבן זיי געזאגט צו אים: רבי, ווען ביסטו דא אהערגעקומען? ");
INSERT INTO ydd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","האט יהושע/ישוע זיי געענטפערט און געזאגט: באמת, באמת זאג איך אייך: איר זוכט מיך, נישט ווייל איר האט געזען נסים נאר ווייל איר האט געגעסן פון די ברויטן און זענט זאט געווארן. ");
INSERT INTO ydd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ארבעט נישט פאר דער שפייז, וואס ווערט פארדארבן, נאר פאר דער שפייז, וואס בלייבט צום אייביקן לעבן, וואס דער בר אנש וועט אייך געבן; ווארום אויף אים האט ג‑ט דער פאטער געלייגט זיין חותם. ");
INSERT INTO ydd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","האבן זיי געזאגט צו אים: וואס זאלן מיר טאן, כדי מיר זאלן עוסק זיין אין די מעשים פון ה׳? ");
INSERT INTO ydd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","האט יהושע/ישוע געענטפערט און געזאגט צו זיי: דאס דאזיקע איז דאס ווערק פון ה׳, אז איר זאלט גלויבן אין אים, וועמען ער האט געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","האבן זיי געזאגט צו אים: וואס פאר א נס טוסטו דען, אז מיר זאלן זען און דיר גלויבן? וואס טוסטו? ");
INSERT INTO ydd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","אונדזערע עלטערן האבן געגעסן מן אין דער מדבר, אזויווי עס שטייט געשריבן: ברויט פונם הימל האט ער זיי געגעבן צו עסן. ");
INSERT INTO ydd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","האט יהושע/ישוע צו זיי געזאגט: באמת, באמת זאג איך אייך: נישט משה האט אייך געגעבן דאס ברויט פונם הימל; נאר דער פאטער מיינער גיט אייך דאס אמתע ברויט פונם הימל. ");
INSERT INTO ydd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ווארום דאס ברויט פון ה׳ איז ער, וואס קומט אראפ פונם הימל און גיט לעבן צו דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","האבן זיי דעריבער געזאגט צו אים: האר, גיב אונדז תמיד דאס דאזיקע ברויט. ");
INSERT INTO ydd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","האט יהושע/ישוע צו זיי געזאגט: איך בין דאס ברויט פון לעבן; דער, וואס קומט צו מיר, וועט קיינמאל נישט הונגערן, און דער, וואס גלויבט אין מיר, וועט קיינמאל נישט דורשטן. ");
INSERT INTO ydd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","איך האב אייך אבער געזאגט, אז איר האט מיך געזען און דאך גלויבט איר נישט. ");
INSERT INTO ydd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","אלץ, וואס דער פאטער גיט מיר, וועט קומען צו מיר; און דעם, וואס קומט צו מיר, וועל איך בשום אופן נישט ארויסווארפן אינדרויסן. ");
INSERT INTO ydd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ווייל איך בין אראפגעקומען פון הימל, נישט כדי איך זאל טאן מיין ווילן, נאר דעם רצון פון אים, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","און דאס דאזיקע איז דער רצון פון אים, וואס האט מיך געשיקט, אז פון אלעם, וואס ער האט מיר געגעבן, זאל איך גארנישט פארלירן, נאר איך זאל עס אויפשטעלן אין דעם לעצטן טאג. ");
INSERT INTO ydd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ווארום דאס דאזיקע איז מיין פאטערס רצון, אז יעדער איינער, וואס זעט דעם זון און גלויבט אין אים, זאל האבן אייביק לעבן; און איך וועל אים אויפשטעלן אין דעם לעצטן טאג. ");
INSERT INTO ydd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","די יידן האבן דעריבער געמורמלט קעגן אים, ווייל ער האט געזאגט: איך בין דאס ברויט, וואס איז אראפגעקומען פונם הימל. ");
INSERT INTO ydd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","און זיי האבן געזאגט; צי איז דען דער דאזיקער נישט יהושע/ישוע בן יוסף, וועמעס פאטער און מוטער מיר קענען? וויאזוי זאגט ער דאס איצט: איך בין אראפגעקומען פון הימל? ");
INSERT INTO ydd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","האט יהושע/ישוע געענטפערט און געזאגט צו זיי: מורמלט נישט צווישן זיך. ");
INSERT INTO ydd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","קיינער קען נישט קומען צו מיר, אויב דער פאטער, וואס האט מיך געשיקט, ציט אים נישט; און איך וועל אים אויפשטעלן אין דעם לעצטן טאג. ");
INSERT INTO ydd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","עס שטייט געשריבן אין די נביאים: און אלע וועלן זיין געלערנט פון ה׳. יעדער איינער, וואס האט געהערט פון דעם פאטער און האט געלערנט, קומט צו מיר. ");
INSERT INTO ydd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","נישט אז עמיצער האט געזען דעם פאטער, אחוץ דער, וואס איז פון ה׳; דער דאזיקער האט געזען דעם פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","באמת, באמת זאג איך אייך: דער מאמין האט אייביק לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","איך בין דאס ברויט פון לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","אייערע עלטערן האבן געגעסן מן אין דער מדבר, און זענען געשטארבן. ");
INSERT INTO ydd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","דאס דאזיקע איז דאס ברויט, וואס קומט אראפ פון הימל, אז ווער עס עסט דערפון, זאל נישט שטארבן. ");
INSERT INTO ydd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","איך בין דאס לעבעדיקע ברויט, וואס איז אראפגעקומען פון הימל; אויב עמיצער וועט עסן פון דעם דאזיקן ברויט, וועט ער לעבן ביז אויף אייביק; און דאס ברויט, וואס איך וועל געבן, איז מיין פלייש, פאר דעם לעבן פון דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","די יידן האבן זיך דעריבער געאמפערט איינער מיטן אנדערן, און געזאגט: וויאזוי קען דער דאזיקער אונדז געבן זיין פלייש צו עסן? ");
INSERT INTO ydd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","האט יהושע/ישוע צו זיי געזאגט: באמת, באמת זאג איך אייך: אויב איר וועט נישט עסן דאס פלייש פון דעם בר אנש און טרינקען זיין בלוט, האט איר נישט קיין לעבן אין זיך. ");
INSERT INTO ydd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ווער עס עסט מיין פלייש און טרינקט מיין בלוט, דער האט אייביק לעבן; און איך וועל אים אויפשטעלן אין דעם לעצטן טאג. ");
INSERT INTO ydd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ווארום מיין פלייש איז ווארהאפטיקע שפייז, און מיין בלוט איז ווארהאפטיק געטראנק. ");
INSERT INTO ydd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","דער, וואס עסט מיין פלייש און טרינקט מיין בלוט, בלייבט אין מיר, און איך אין אים. ");
INSERT INTO ydd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ווי דער לעבעדיקער פאטער האט מיך געשיקט, און איך לעב דורך דעם פאטער, אזוי דער, וואס עסט מיך, וועט לעבן דורך מיר. ");
INSERT INTO ydd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","דאס דאזיקע איז דאס ברויט, וואס איז אראפגעקומען פון הימל; נישט ווי אייערע עלטערן האבן געגעסן, און זענען געשטארבן; ווער עס עסט דאס דאזיקע ברויט, דער וועט לעבן אייביק. ");
INSERT INTO ydd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","דאס האט ער געזאגט, בשעת ער האט געלערנט אין דער שול אין כפר‑נחום. ");
INSERT INTO ydd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","און א סך פון זיינע תלמידים האבן געזאגט, ווען זיי האבן עס געהערט: דאס דאזיקע איז א הארב ווארט; ווער קען עס הערן? ");
INSERT INTO ydd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","וויסנדיק אבער אין זיך אליין, אז זיינע תלמידים האבן געמורמלט וועגן דעם, האט יהושע/ישוע צו זיי געזאגט: דאס דאזיקע מאכט אייך שטרויכלען? ");
INSERT INTO ydd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","און וואס וועט זיין, ווען איר וועט זען דעם בר אנש ארויפגיין, וואו ער איז פריער געווען? ");
INSERT INTO ydd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","דער גייסט איז עס, וואס מאכט לעבעדיק; דאס פלייש נוצט צו גארנישט; די ווערטער, וואס איך האב גערעדט צו אייך, זענען גייסט, און זענען לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","נאר צווישן אייך זענען פאראן אייניקע, וועלכע גלויבן נישט. ווארום יהושע/ישוע האט געוואוסט פונם אנהויב אָן, ווער עס זענען די, וואס גלויבן נישט, און ווער עס איז, וואס וועט אים פארראטן. ");
INSERT INTO ydd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","און ער האט געזאגט: דערפאר האב איך אייך געזאגט: קיינער קען נישט קומען צו מיר, אויב עס איז אים נישט באשערט געווארן פון מיין פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","פון דעמאלט אָן האבן א סך פון זיינע תלמידים זיך צוריקגעצויגן, און זענען מיט אים מער נישט ארומגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","יהושע/ישוע האט דעריבער געזאגט צו די צוועלף: צי ווילט איר אויך אוועקגיין? ");
INSERT INTO ydd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","האט שמעון פעטרוס אים געענטפערט: האר, צו וועמען זאלן מיר גיין? דו האסט די ווערטער פון אייביקן לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","און מיר גלויבן און ווייסן, אז דו ביסט דער קדוש אלקים. ");
INSERT INTO ydd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","האט יהושע/ישוע זיי געענטפערט: צי האב איך דען נישט אייך—די צוועלף—אויסדערוויילט? און איינער פון אייך איז א טייוול. ");
INSERT INTO ydd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","און ער האט גערעדט פון יהודה בן שמעון איש‑קריות; ווארום דער דאזיקער האט אים געזאלט פארראטן, איינער פון די צוועלף. ");
INSERT INTO ydd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","און נאך דעם איז יהושע/ישוע ארומגעגאנגען אין גליל; ווארום ער האט נישט געוואלט ארומגיין אין (לאנד) יהודה, ווייל די יידן האבן געזוכט אים צו טייטן. ");
INSERT INTO ydd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","און עס איז געווען נאענט פאר דעם יידישן יום טוב סוכות, ");
INSERT INTO ydd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","אזוי האבן זיינע ברידער צו אים געזאגט: הויב דיך אויף פונדאנען, און גיי קיין יהודה, כדי אויך דיינע תלמידים זאלן זען דיינע מעשים, וואס דו טוסט. ");
INSERT INTO ydd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ווארום קיינער טוט גארנישט אין פארבארגעניש, און זוכט דאך עפנטלעך באקאנט צו זיין. אויב דו טוסט די דאזיקע זאכן, זיי דיך מתגלה צו דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ווארום אפילו זיינע ברידער האבן נישט געגלויבט אין אים. ");
INSERT INTO ydd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","יהושע/ישוע האט דעריבער צו זיי געזאגט: מיין צייט איז נאך נישט געקומען; אייער צייט אבער איז תמיד גרייט. ");
INSERT INTO ydd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","אייך קען די וועלט נישט האסן; מיך אבער האסט זי יא, ווייל איך זאג עדות וועגן איר, אז אירע מעשים זענען בייז. ");
INSERT INTO ydd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","זייט איר עולה רגל אויף יום טוב; איך גיי נאך נישט ארויף אויף דעם יום טוב, ווייל מיין צייט איז נאך נישט דערפילט געווארן. ");
INSERT INTO ydd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","און ווען ער האט דאס געזאגט צו זיי, איז ער פארבלייבן אין גליל. ");
INSERT INTO ydd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","נאך דעם אבער ווי זיינע ברידער זענען ארויפגעגאנגען אויף יום טוב, איז ער דעמאלט אליין אויך ארויפגעגאנגען, נישט עפנטלעך, נאר ווי אין פארבארגן. ");
INSERT INTO ydd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","און די יידן האבן אים געזוכט בשעת דעם יום טוב, און האבן געזאגט: וואו איז ער? ");
INSERT INTO ydd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","און עס איז געווארן א גרויסע מחלוקה איבער אים צווישן די מאסן; א טייל האבן געזאגט: ער איז א גוטער מענטש; אנדערע אבער האבן געזאגט: ניין, ער פארפירט נאר דעם עולם. ");
INSERT INTO ydd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","דאך האט קיינער נישט גערעדט וועגן אים בפרהסיא, אויס מורא פאר די יידן. ");
INSERT INTO ydd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","און ווען עס איז שוין געווען אין מיטן יום טוב, איז יהושע/ישוע ארויפגעגאנגען אין בית המקדש אריין און האט געלערנט. ");
INSERT INTO ydd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","און די יידן האבן זיך געוואונדערט און געזאגט: וויאזוי איז דער דאזיקער א יודע ספר, נישט האבנדיק געלערנט? ");
INSERT INTO ydd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","האט יהושע/ישוע זיי דעריבער געענטפערט, און געזאגט: די לערנונג מיינע איז נישט מיין, נאר דעמס, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ווען עמיצער וויל טאן זיין רצון, וועט ער וויסן וועגן דער לערנונג, צי זי איז פון ה׳, אדער איך רעד פון מיר אליין. ");
INSERT INTO ydd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ווער עס רעדט פון זיך אליין, דער זוכט זיין אייגענעם כבוד; ווער אבער עס זוכט דעם כבוד פון אים, וואס האט אים געשיקט, דער דאזיקער איז ווארהאפטיק, און קיין אומגערעכטיקייט איז אין אים נישט פאראן. ");
INSERT INTO ydd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","צי האט משה (רבינו) אייך דען נישט געגעבן די תורה? און (דאך) האלט קיינער פון אייך די תורה נישט. פארוואס זוכט איר מיך צו טייטן? ");
INSERT INTO ydd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","האט דער המון מענטשן געענטפערט: דו האסט א בייזן גייסט; ווער זוכט דיך צו טייטן? ");
INSERT INTO ydd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","האט יהושע/ישוע געענטפערט און געזאגט צו זיי: איין זאך האב איך געטאן, און איר אלע וואונדערט זיך. ");
INSERT INTO ydd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","משה האט אייך געגעבן די מילה—נישט דאס זי איז פון משהן, נאר פון די אבות—און איר זענט מל א מענטשן אין שבת. ");
INSERT INTO ydd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","אויב דער מענטש ווערט געמלט אין שבת, כדי מען זאל נישט עובר זיין אויף תורת משה, זענט איר צארנדיק אויף מיר, ווייל איך האב א גאנצן מענטשן געזונט געמאכט אין שבת? ");
INSERT INTO ydd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","משפט נישט לויט דעם אויסערלעכן שיין, נאר א גערעכט משפט זאלט איר משפטן. ");
INSERT INTO ydd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","אייניקע פון די לייט פון ירושלים האבן דעריבער געזאגט: צי איז ער דען נישט דער, וועמען מען זוכט צו טייטן? ");
INSERT INTO ydd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","און זע, ער רעדט בפרהסיא, און מען זאגט אים גארנישט. קען עס זיין, אז אונדזערע שרים ווייסן באמת, אז ער איז דער משיח? ");
INSERT INTO ydd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","מיר קענען דאך דעם דאזיקן, פונוואנען ער איז: אבער ווען דער משיח וועט קומען, ווייסט קיינער נישט פונוואנען ער איז. ");
INSERT INTO ydd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","יהושע/ישוע האט דעריבער אויסגעשריגן אינם בית המקדש, בשעת ער האט געלערנט, און געזאגט: איר קענט מיך, און איר ווייסט, פונוואנען איך בין: און פון מיר אליין בין איך נישט געקומען; נאר ווארהאפטיק איז דער, וואס האט מיך געשיקט, וועמען איר קענט נישט. ");
INSERT INTO ydd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","איך קען אים, ווייל איך בין פון אים; און ער האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","זיי האבן דעריבער געזוכט אים צו כאפן; און קיינער האט נישט ארויפגעלייגט אויף אים די האנט, ווייל זיין שעה איז נאך נישט געקומען. ");
INSERT INTO ydd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","און א סך פון דעם המון מענטשן האבן געגלויבט אין אים, און געזאגט: ווען משיח וועט קומען, צי וועט ער דען טאן מער נסים, ווי דער דאזיקער האט געטאן? ");
INSERT INTO ydd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","די פרושים האבן געהערט דעם המון דאס שטילערהייט רעדן וועגן אים; און די הויפט כהנים און די פרושים האבן געשיקט משרתים, כדי זיי זאלן אים כאפן. ");
INSERT INTO ydd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","יהושע/ישוע האט דעריבער געזאגט: נאך א קליינע וויילע בין איך מיט אייך, און איך גיי צו אים, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","איר וועט מיך זוכן, און נישט געפינען; און וואו איך בין, (דארט אהין) קענט איר נישט קומען. ");
INSERT INTO ydd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","די יידן האבן דעריבער געזאגט איינער צום אנדערן: וואו וועט דאס דער דאזיקער גיין, אז מיר זאלן אים נישט געפינען? נישט וועט ער דען גיין צו די, וואס זענען צעשפרייט צווישן די גריכן, און לערנען די גריכן? ");
INSERT INTO ydd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","וואס זאל דאס דאזיקע ווארט באטייטן, וואס ער האט געזאגט: איר וועט מיך זוכן און נישט געפינען און: וואו איך בין, קענט איר נישט קומען? ");
INSERT INTO ydd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","און אין דעם לעצטן טאג, דעם גרויסן טאג פון דעם יום טוב, איז יהושע/ישוע געשטאנען און האט אויסגעשריגן, אזוי צו זאגן: אויב עמיצער איז דארשטיק, זאל ער קומען צו מיר און טרינקען. ");
INSERT INTO ydd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","דער, וואס גלויבט אין מיר, לויט ווי די שריפט (כתבי הקודש) זאגט, וועלן פון זיין לייב פליסן טייכן פון לעבעדיק וואסער. ");
INSERT INTO ydd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","דאס דאזיקע אבער האט ער געזאגט וועגן דעם רוח (הקודש), וואס די מאמינים אין אים, האבן געזאלט מקבל זיין; ווארום דער גייסט איז נאך נישט געהאט געגעבן געווארן, ווייל יהושע/ישוע איז נאך נישט געווען פארהערלעכט. ");
INSERT INTO ydd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","און אייניקע פון דעם המון, וואס האבן געהערט די דאזיקע ווערטער, האבן געזאגט: דאס איז באמת דער נביא! ");
INSERT INTO ydd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","אנדערע האבן געזאגט: דאס איז דער משיח! אנדערע האבן געזאגט: ניין, דער משיח קומט דאך נישט ארויס פון גליל? ");
INSERT INTO ydd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","צי האט דען נישט דער פסוק געזאגט, אז פון דער זרע דוד און פון בית‑לחם דעם דארף, וואו דוד איז געווען, קומט דער משיח? (שמואל ב ז, יב; מיכה ה, א.) ");
INSERT INTO ydd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","עס איז דעריבער געווארן א מחלוקה צווישן דעם המון צוליב אים. ");
INSERT INTO ydd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","אייניקע פון זיי האבן אים געוואלט כאפן, נאר קיינער האט נישט ארויפגעלייגט די הענט אויף אים. ");
INSERT INTO ydd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","און די משרתים זענען צוריקגעקומען צו די הויפט כהנים און פרושים, און זיי האבן צו זיי געזאגט: פארוואס האט איר אים נישט געברענגט? ");
INSERT INTO ydd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","האבן די משרתים געענטפערט: עס האט נאך קיינמאל קיין מענטש נישט אזוי גערעדט, ווי דער דאזיקער מענטש רעדט. ");
INSERT INTO ydd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","די פרושים האבן דעריבער געענטפערט צו זיי: זענט איר אויך פארפירט געווארן? ");
INSERT INTO ydd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","צי האט דען עמיצער פון די שרים געגלויבט אין אים, אדער (עמיצער) פון די פרושים? ");
INSERT INTO ydd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","נאר דער דאזיקער המון, וואס קען נישט די תורה, פארשאלטן זענען זיי. ");
INSERT INTO ydd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","זאגט נקדימון צו זיי (דער, וואס איז פריער געקומען צו אים, און איז געווען איינער פון זיי): ");
INSERT INTO ydd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","צי משפט דען אונדזער תורה דעם מענטשן, איידער מען האט אים קודם כל אויסגעהערט, און מען ווייסט וואס ער האט געטאן? ");
INSERT INTO ydd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","האבן זיי געענטפערט און געזאגט צו אים: צי ביסטו אויך פון גליל? פארש און זע, אז פון גליל שטייט נישט אויף קיין נביא. ");
INSERT INTO ydd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(און יעדער איינער איז זיך אהיים געגאנגען.) ");
INSERT INTO ydd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","(און יהושע/ישוע איז אוועקגעגאנגען צום הר הזיתים. ");
INSERT INTO ydd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","און אינדערפרי איז ער ווידער געקומען אין בית המקדש אריין, און דער גאנצער עולם איז געקומען צו אים; און ער האט זיך אנידערגעזעצט, און זיי געלערנט. ");
INSERT INTO ydd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","און די סופרים און די פרושים האבן געברענגט א פרוי, וואס מען האט זי געכאפט אין דער מעשה פון זנות; און אנידערשטעלנדיק זי אין דער מיט, ");
INSERT INTO ydd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","האבן זיי צו אים געזאגט; רבי, די דאזיקע פרוי איז געכאפט געווארן אין זנות, בשעת מעשה. ");
INSERT INTO ydd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","און אין דער תורה האט אונדז משה (רבינו) געבאטן, אזעלכע (פרויען) צו שטייניקן; וואס זשע זאגסטו? ");
INSERT INTO ydd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","און דאס דאזיקע האבן זיי געזאגט, אויספרואוונדיק אים, כדי זיי זאלן האבן עפעס, אים אנצוקלאגן. יהושע/ישוע אבער האט זיך אראפגעבויגן, און געשריבן מיטן פינגער אויף דער ערד. ");
INSERT INTO ydd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","און ווי זיי האבן אנגעהאלטן מיט זייער פרעגן אים, האט ער זיך אויפגעשטעלט, און צו זיי געזאגט: דער פון אייך, וואס איז אָן א חטא, זאל זיין דער ערשטער צו ווארפן אויף איר א שטיין. ");
INSERT INTO ydd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","און ווידער האט ער זיך איינגעבויגן און געשריבן אויף דער ערד. ");
INSERT INTO ydd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ווי אבער זיי האבן דאס געהערט, זענען זיי ארויסגעגאנגען איינער נאכן אנדערן, אנהויבנדיק פון די זקנים ביז צו די לעצטע; און יהושע/ישוע איז איבערגעבליבן איינער אליין, און די פרוי שטייענדיק אין דער מיט. ");
INSERT INTO ydd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","און יהושע/ישוע האט זיך אויפגעשטעלט, און צו איר געזאגט: אשה, וואו זענען זיי, דיינע באשולדיקער? האט דיך קיינער נישט פארמשפט? ");
INSERT INTO ydd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","האט זי געזאגט: קיינער נישט, האר. האט יהושע/ישוע געזאגט: אפילו איך פארמשפט דיך נישט; גיי, און פון איצט אָן זינדיק נישט מער.) ");
INSERT INTO ydd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","דאן האט יהושע/ישוע ווידער צו זיי גערעדט, אזוי צו זאגן; איך בין דאס ליכט פון דער וועלט; דער, וואס פאלגט מיר נאך, וועט אויף קיין פאל נישט לעבן אין דער פינצטערניש, נאר וועט האבן דאס ליכט פון לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","די פרושים האבן דעריבער צו אים געזאגט: דו זאגסט עדות וועגן דיר אליין; דיין עדות זאגן איז נישט אמת. ");
INSERT INTO ydd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","האט יהושע/ישוע געענטפערט און געזאגט צו זיי: און ווען אפילו איך זאג עדות וועגן מיר אליין, איז דאך מיין עדות זאגן אמת; ווייל איך ווייס פונוואנען איך בין געקומען, און וואואהין איך גיי; איר אבער ווייסט נישט פונוואנען איך קום, אדער וואואהין איך גיי. ");
INSERT INTO ydd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","איר משפט לויטן פלייש; איך משפט נישט קיינעם. ");
INSERT INTO ydd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","און אויב איך משפט יא, איז מיין משפט אמת; ווייל איך בין נישט אליין, נאר איך און דער פאטער, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","און אפילו אין דער תורה אייערער שטייט געשריבן, אז דאס עדות זאגן פון צוויי מענטשן איז אמת. ");
INSERT INTO ydd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","איך בין עס, וואס זאגט עדות וועגן מיר אליין, און דער פאטער, וואס האט מיך געשיקט, זאגט אויך עדות וועגן מיר. ");
INSERT INTO ydd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","זיי האבן דעריבער געזאגט צו אים: וואו איז דיין פאטער? האט יהושע/ישוע געענטפערט: נישט איר קענט מיך, נישט דעם פאטער מיינעם; אויב איר וואלט מיך געקענט, וואלט איר אויך געקענט מיין פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","די דאזיקע ווערטער האט ער גערעדט אינם בית האוצר, בשעת ער האט געלערנט אין בית המקדש; און קיינער האט אים נישט געכאפט, ווייל זיין שעה איז נאך נישט געהאט געקומען. ");
INSERT INTO ydd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","און ער האט ווידער צו זיי געזאגט: איך גיי אוועק, און איר וועט מיך זוכן, און איר וועט שטארבן אין אייער זינד; וואואהין איך גיי, קענט איר נישט קומען. ");
INSERT INTO ydd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","די יידן האבן דעריבער געזאגט: נישט וועט ער זיך א מעשה אנטאן? ווייל ער זאגט: וואואהין איך גיי, קענט איר נישט קומען. ");
INSERT INTO ydd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","און ער האט צו זיי געזאגט: איר זענט פון אונטן, איך בין פון אויבן; איר זענט פון דער וועלט, איך בין נישט פון דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","דערפאר האב איך אייך געזאגט, אז איר וועט שטארבן אין אייערע זינד; ווארום אויב איר וועט נישט גלויבן, אז איך בין עס, וועט איר שטארבן אין אייערע זינד. ");
INSERT INTO ydd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","זיי האבן דעריבער געזאגט צו אים: ווער ביסטו דען? האט יהושע/ישוע צו זיי געזאגט: דאס, וואס איך האב אייך געזאגט פון אנהויב אָן. ");
INSERT INTO ydd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","איך האב א סך צו זאגן וועגן אייך און צו משפטן; נאר דער, וואס האט מיך געשיקט, איז אמת; און וואס איך האב געהערט פון אים, דאס רעד איך צו דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","און זיי האבן נישט פארשטאנען, אז ער האט צו זיי גערעדט פון דעם פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","דאן האט יהושע/ישוע געזאגט: ווען איר וועט אויפהויבן דעם בר אנש, דעמאלט וועט איר וויסן, אז איך בין עס, און אז פון מיר אליין טו איך קיין זאך נישט; נאר ווי דער פאטער האט מיך געלערנט, אזוי רעד איך דאס. ");
INSERT INTO ydd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","און דער, וואס האט מיך געשיקט, איז מיט מיר; ער האט מיך נישט איבערגעלאזט אליין; ווייל וואס איז וואוילגעפעליק פאר אים, דאס טו איך אלעמאל. ");
INSERT INTO ydd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","און בשעת ער האט דאס גערעדט, האבן א סך געגלויבט אין אים. ");
INSERT INTO ydd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","דאן האט יהושע/ישוע געזאגט צו די יידן, וואס האבן געגלויבט אין אים: אויב איר וועט בלייבן אין מיין ווארט, זענט איר באמת מיינע תלמידים; ");
INSERT INTO ydd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","און איר וועט דערקענען דעם אמת, און דער אמת וועט אייך באפרייען. ");
INSERT INTO ydd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","האבן זיי אים געענטפערט: מיר זענען אברהמס זאמען, און זענען קיינמאל נישט געווען פארשקלאפט צו קיינעם; וויאזוי זשע זאגסטו: איר וועט ווערן פריי? ");
INSERT INTO ydd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","האט יהושע/ישוע זיי געענטפערט: באמת, באמת זאג איך אייך: יעדער איינער, וואס טוט זינד, איז א קנעכט פון דער זינד. ");
INSERT INTO ydd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","און דער קנעכט בלייבט נישט אייביק אין הויז, דער זון אבער בלייבט יא אייביק. ");
INSERT INTO ydd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","דעריבער אויב דער זון וועט אייך באפרייען, וועט איר וויקלעך זיין פריי. ");
INSERT INTO ydd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","איך ווייס, אז איר זענט אברהמס זאמען; נאר איר זוכט מיך צו טייטן, ווייל מיין ווארט געפינט נישט קיין ארט אין אייך. ");
INSERT INTO ydd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","איך רעד דאס, וואס איך האב געזען ביי מיין פאטער, און איר טוט אויך דאס, וואס איר האט געהערט ביי אייער פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","האבן זיי געענטפערט און געזאגט צו אים: אברהם איז אונדזער פאטער (זכות‑אבות). זאגט יהושע/ישוע צו זיי: אויב איר זענט קינדער פון אברהם, טוט די מעשים פון אברהם. ");
INSERT INTO ydd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","איצט אבער זוכט איר מיך צו טייטן, א מענטשן, וואס האט אייך געזאגט דעם אמת, וועלכן איך האב געהערט ביי ה׳. דאס דאזיקע האט אברהם נישט געטאן. ");
INSERT INTO ydd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","איר טוט די מעשים פון אייער פאטער. האבן זיי צו אים געזאגט: מיר זענען נישט געבוירן געווארן דורך זנות; מיר האבן איין פאטער—ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","האט יהושע/ישוע צו זיי געזאגט: אויב ה׳ וואלט טאקע געווען אייער פאטער, וואלט איר מיך ליב געהאט; ווארום איך בין ארויסגעגאנגען און בין געקומען פון ה׳; ווארום פון מיר אליין בין איך נישט געקומען, נאר ער האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","פארוואס פארשטייט איר נישט מיין רעדן? ווייל איר קענט נישט הערן דאס ווארט מיינס. ");
INSERT INTO ydd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","איר זענט פון אייער פאטער, דעם שׂטן, און די שלעכטע גלוסטונגען פון אייער פאטער ווילט איר טאן. ער איז געווען א רוצח פון אנהויב אָן, און איז נישט געשטאנען אין דעם אמת, ווייל עס איז קיין אמת אין אים נישט פאראן. ווען ער רעדט שקר, רעדט ער פון דעם, וואס איז זיין אייגן, ווייל ער איז א ליגנער, און דער פאטער פון שקר. ");
INSERT INTO ydd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","אבער ווייל איך זאג דעם אמת, גלויבט איר מיר נישט. ");
INSERT INTO ydd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ווער פון אייך באשולדיקט מיך וועגן א חטא? אויב איך זאג דעם אמת, פארוואס גלויבט איר מיר נישט? ");
INSERT INTO ydd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ווער עס איז פון ה׳, דער הערט די ווערטער פון ה׳; צוליב דעם הערט איר נישט, ווייל איר זענט נישט פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","די יידן האבן געענטפערט, און געזאגט צו אים: צי זאגן מיר דען נישט ריכטיק, אז דו ביסט א שומרוני, און האסט א בייזן גייסט? ");
INSERT INTO ydd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","האט יהושע/ישוע געענטפערט: איך האב נישט קיין בייזן גייסט, נאר איך גיב אפ כבוד צו מיין פאטער, און איר זענט מיך מבזה. ");
INSERT INTO ydd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","איך אבער זוך נישט מיין כבוד. עס איז פאראן איינער, וואס זוכט און משפט. ");
INSERT INTO ydd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","באמת, באמת זאג איך אייך: אויב עמיצער וועט אפהיטן מיין ווארט, וועט ער בשום אופן נישט זען דעם טויט אויף אייביק. ");
INSERT INTO ydd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","האבן די יידן צו אים געזאגט: איצט ווייסן מיר, אז דו האסט א בייזן גייסט. אברהם איז געשטארבן, און די נביאים; און דו זאגסט: אויב עמיצער וועט אפהיטן מיין ווארט, וועט ער בשום אופן נישט טועם זיין פונם טויט אויף אייביק. ");
INSERT INTO ydd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ביסטו דען גרעסער פון אברהם אבינו, וועלכער איז געשטארבן? אויך די נביאים זענען געשטארבן; פאר וועמען מאכסטו דיך? ");
INSERT INTO ydd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","יהושע/ישוע האט געענטפערט: אויב איך פארהערלעך מיך אליין, איז מיין כבוד גארנישט. עס איז מיין פאטער, וועלכער פארהערלעכט מיך, וועגן וועמען איר זאגט, אז ער איז אייער ג‑ט; ");
INSERT INTO ydd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","און איר האט אים דאך נישט דערקענט, איך אבער קען אים יא; און אויב איך זאל זאגן, אז איך קען אים נישט, וועל איך זיין א ליגנער גלייך צו אייך; נאר איך קען אים, און היט אפ זיין ווארט. ");
INSERT INTO ydd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","אברהם, אייער פאטער, האט זיך געפריידט, אז ער זאל זען מיין טאג, און האט געזען, און זיך משמח געווען. ");
INSERT INTO ydd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","די יידן האבן דעריבער געזאגט צו אים: דו ביסט נאך נישט פיפציק יאר אלט, און האסט שוין געזען אברהמען? ");
INSERT INTO ydd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","האט יהושע/ישוע צו זיי געזאגט: באמת, באמת זאג איך אייך; איידער אברהם איז געווען, בין איך. ");
INSERT INTO ydd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","זיי האבן דעריבער אויפגעהויבן שטיינער, כדי אים צו באווארפן; יהושע/ישוע אבער האט זיך פארבארגן, און איז ארויסגעגאנגען אויס דעם בית המקדש. ");
INSERT INTO ydd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","און פארבייגייענדיק האט ער געזען א מענטשן, א בלינדן פון דער געבורט אָן. ");
INSERT INTO ydd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","און זיינע תלמידים האבן אים געפרעגט, אזוי צו זאגן; רבי, ווער האט געזינדיקט, דער דאזיקער אדער זיינע עלטערן, אז ער איז געבוירן געווארן בלינד? ");
INSERT INTO ydd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","האט יהושע/ישוע געענטפערט: נישט ער האט געזינדיקט, נישט די עלטערן זיינע; נאר כדי די מעשים פון ה׳ זאלן אנטפלעקט ווערן אין אים. ");
INSERT INTO ydd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","מיר מוזן טאן די מעשים פון אים, וואס האט מיך געשיקט, כל זמן עס איז טאג; די נאכט קומט אָן, ווען קיינער קען נישט ארבעטן. ");
INSERT INTO ydd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","בשעת איך בין אין דער וועלט, בין איך דאס ליכט פון דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","דאס זאגנדיק, האט ער אויסגעשפיגן אויף דער ערד און געמאכט ליים פון דעם שפייעכץ און אים באשמירט די אויגן מיט דעם ליים, ");
INSERT INTO ydd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","און האט צו אים געזאגט: גיי, וואש דיך אין טייך שילוח, (פארטייטשט הייסט עס, געשיקט). ער איז דעריבער אוועקגעגאנגען, און האט זיך געוואשן, און איז צוריקגעקומען זעענדיק. ");
INSERT INTO ydd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","און די שכנים, און די, וואס האבן אים פריער געזען, אז ער איז געווען א בעטלער, האבן געזאגט: צי איז עס דען נישט דער, וואס איז געזעסן און געבעטלט? ");
INSERT INTO ydd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","אנדערע האבן געזאגט: ער איז עס; אנדערע האבן געזאגט: ניין, נאר ער איז ענלעך צו אים. יענער האט געזאגט: איך בין עס. ");
INSERT INTO ydd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","האבן זיי צו אים געזאגט: וויאזוי זשע זענען דיינע אויגן געעפנט געווארן? ");
INSERT INTO ydd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","יענער האט געענטפערט: דער מענטש, וועמען מען רופט יהושע/ישוע, האט געמאכט ליים, און אנגעשמירט מיינע אויגן, און צו מיר געזאגט: גיי צום שילוח און וואש דיך; און איך בין געגאנגען און האב מיך געוואשן, און בין זעענדיק געווארן. ");
INSERT INTO ydd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","האבן זיי צו אים געזאגט: וואו איז ער? זאגט ער: איך ווייס נישט. ");
INSERT INTO ydd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","נעמען זיי און פירן צו די פרושים דעם, וואס איז פריער געווען בלינד. ");
INSERT INTO ydd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","און דער טאג איז געווען א שבת, ווען יהושע/ישוע האט געמאכט דאס ליים, און אים געעפנט זיינע אויגן. ");
INSERT INTO ydd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","דעריבער האבן אויך די פרושים אים ווידער געפרעגט, וויאזוי ער איז זעענדיק געווארן. און ער האט צו זיי געזאגט: ער האט ארויפגעלייגט ליים אויף מיינע אויגן, און איך האב מיך געוואשן, און איך זע. ");
INSERT INTO ydd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","האבן אייניקע פון די פרושים געזאגט: דער דאזיקער מענטש איז נישט פון ה׳, ווייל ער היט נישט אפ שבת. און אנדערע האבן געזאגט: וויאזוי קען א מענטש, א חוטא, טאן אזעלכע נסים? און עס איז געווארן א מחלוקה צווישן זיי. ");
INSERT INTO ydd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","און ווידער האבן זיי געזאגט צום בלינדן: וואס זאגסטו וועגן אים, אז ער האט דיר געעפנט דיינע אויגן? ער אבער האט געזאגט: ער איז א נביא. ");
INSERT INTO ydd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","די יידן האבן דעריבער נישט געגלויבט וועגן אים, אז ער איז געווען בלינד, און איז זעענדיק געווארן, ביז זיי האבן גערופן די עלטערן פון דעם זעענדיק געווארענעם, ");
INSERT INTO ydd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","און זיי געפרעגט, אזוי צו זאגן: צי איז דער דאזיקער אייער זון, וואס איר זאגט, אז ער איז געבוירן געווארן בלינד? וויאזוי זשע זעט ער איצט? ");
INSERT INTO ydd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","האבן זיינע עלטערן געענטפערט און געזאגט: מיר ווייסן, אז דער דאזיקער איז אונדזער זון, און אז ער איז געבוירן געווארן בלינד; ");
INSERT INTO ydd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","וויאזוי אבער ער זעט איצט, ווייסן מיר נישט; אדער ווער עס האט אים געעפנט זיינע אויגן, ווייסן מיר נישט; פרעגט אים, ער איז א דערוואקסענער, ער וועט רעדן פאר זיך אליין. ");
INSERT INTO ydd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","דאס האבן זיינע עלטערן געזאגט, ווייל זיי האבן מורא געהאט פאר די יידן: ווארום די יידן האבן שוין געהאט אפגעמאכט, אז ווען עמיצער וועט אים אנערקענען פאר דעם משיח, זאל ער געלייגט ווערן אין חרם אריין. ");
INSERT INTO ydd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","דערפאר האבן זיינע עלטערן געזאגט: ער איז א דערוואקסענער, פרעגט אים. ");
INSERT INTO ydd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","זיי האבן דעריבער צום צווייטן מאל גערופן דעם מענטשן, וואס איז געווען בלינד, און געזאגט צו אים: גיב אפ כבוד צו ה׳; מיר ווייסן, אז דער דאזיקער מענטש איז א חוטא. ");
INSERT INTO ydd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","האט יענער געענטפערט: צי ער איז זינדיק ווייס איך נישט; איין זאך ווייס איך יא, אז איך בין געווען בלינד און איצט זע איך. ");
INSERT INTO ydd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","זיי האבן דעריבער געזאגט צו אים: וואס האט ער דיר געטאן? וויאזוי האט ער געעפנט דיינע אויגן? ");
INSERT INTO ydd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","האט ער זיי געענטפערט: איך האב דאך אייך שוין געזאגט, און איר האט זיך נישט צוגעהערט; פארוואס ווילט איר נאכאמאל הערן? צי ווילט איר אויך ווערן זיינע תלמידים? ");
INSERT INTO ydd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","און זיי האבן אים געזידלט, און געזאגט; דו ביסט יענעמס תלמיד, מיר אבער זענען משהס תלמידים. ");
INSERT INTO ydd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","מיר ווייסן, אז ה׳ האט גערעדט צו משהן; אבער וואס שייך דעם דאזיקן, ווייסן מיר נישט, פונוואנען ער איז. ");
INSERT INTO ydd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","האט דער מענטש געענטפערט און געזאגט צו זיי: אָט אין דעם דאזיקן ליגט דאָ דער חידוש, אז איר ווייסט נישט פונוואנען ער איז, און ער האט מיר געעפנט מיינע אויגן. ");
INSERT INTO ydd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","מיר ווייסן, אז ה׳ דערהערט נישט קיין חוטאים; נאר אויב עמיצער איז א ירא שמים און טוט זיין רצון, דעם דאזיקן דערהערט ער יא. ");
INSERT INTO ydd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","פון אייביק אָן איז עס נישט געהערט געווארן, אז עמיצער זאל האבן געעפנט די אויגן פון א בלינד געבוירענעם. ");
INSERT INTO ydd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","אויב דער דאזיקער וואלט נישט געווען פון ה׳, וואלט ער גארנישט געקענט טאן. ");
INSERT INTO ydd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","האבן זיי געענטפערט און געזאגט צו אים: דו ביסט אינגאנצן געבוירן געווארן אין זינד, און דו לערנסט אונדז? און האבן אים ארויסגעווארפן אינדרויסן. ");
INSERT INTO ydd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","יהושע/ישוע האט געהערט, אז זיי האבן אים ארויסגעווארפן; און געפינענדיק אים, האט ער געזאגט: צי גלויבסטו אין דעם בר אנש? ");
INSERT INTO ydd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","יענער האט געענטפערט און געזאגט; און ווער איז עס, האר, אז איך זאל גלויבן אין אים? ");
INSERT INTO ydd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","האט יהושע/ישוע געזאגט צו אים: דו האסט אים געזען, און דער, וואס רעדט מיט דיר, איז עס. ");
INSERT INTO ydd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","און ער האט געזאגט: האר, איך גלויב! און האט זיך געבוקט צו אים. ");
INSERT INTO ydd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","און יהושע/ישוע האט געזאגט: צום משפט בין איך געקומען אין דער וועלט אריין, כדי די, וואס זען נישט, זאלן זען, און די זעענדיקע זאלן ווערן בלינד. ");
INSERT INTO ydd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","און אייניקע פון די פרושים, וואס זענען געווען מיט אים, האבן דאס געהערט, און האבן געזאגט צו אים: צי זענען מיר אויך בלינד? ");
INSERT INTO ydd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","האט יהושע/ישוע צו זיי געזאגט: אויב איר וואלט געווען בלינד, וואלט איר נישט געהאט קיין חטא; איצט אבער זאגט איר: מיר זען; דערפאר בלייבט אייער זינד. ");
INSERT INTO ydd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","באמת, באמת זאג איך אייך; דער, וואס קומט נישט אריין דורך דער טיר אינם הויף פון די שאף, נאר שטייגט אריין דורך ערגעץ אנדערשוואו, יענער איז א גנב און א גזלן. ");
INSERT INTO ydd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","דער אבער וואס קומט אריין דורך דער טיר, איז דער פאסטוך פון די שאף. ");
INSERT INTO ydd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","פאר אים עפנט דער שומר; און די שאף הערן זיין קול, און ער רופט זיינע שאף ביים נאמען, און פירט זיי ארויס. ");
INSERT INTO ydd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","און ווען ער האט ארויסגעלאזט אלע זיינע אייגענע, גייט ער פארויס פאר זיי, און די שאף פאלגן אים נאך, ווייל זיי קענען זיין קול. ");
INSERT INTO ydd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","א פרעמדן אבער וועלן זיי בשום אופן נישט נאכפאלגן, נאר וועלן אנטלויפן פון אים, ווייל זיי קענען נישט דאס קול פון פרעמדע. ");
INSERT INTO ydd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","דאס דאזיקע משל האט יהושע/ישוע געזאגט צו זיי; אבער זיי האבן נישט פארשטאנען, וואס דאס איז, וואס ער האט צו זיי גערעדט. ");
INSERT INTO ydd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","יהושע/ישוע האט דעריבער ווידער צו זיי געזאגט: באמת, באמת זאג איך אייך: איך בין די טיר פון די שאף. ");
INSERT INTO ydd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","אלע, וואס זענען געקומען פאר מיר, זענען גנבים און גזלנים; אבער די שאף האבן זיי נישט געהערט. ");
INSERT INTO ydd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","איך בין די טיר; ווער עס וועט אריינגיין דורך מיר, דער וועט געראטעוועט ווערן; און וועט אריינגיין און ארויסגיין, און געפינען פאשע. ");
INSERT INTO ydd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","דער גנב קומט נישט אחוץ כדי צו גנבענען און הרגענען און צו פארדארבן; איך בין געקומען, כדי זיי זאלן האבן לעבן, און אז זיי זאלן האבן א שפע. ");
INSERT INTO ydd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","איך בין דער גוטער פאסטוך; דער גוטער פאסטוך איז זיך מוסר נפש פאר די שאף. ");
INSERT INTO ydd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","דער געדונגענער, און דער, וואס איז נישט קיין פאסטוך, צו וועמען עס געהערן נישט די שאף, זעט דעם וואלף קומען, און פארלאזט די שאף, און אנטלויפט; און דער וואלף פארצוקט און צעשפרייט זיי; ");
INSERT INTO ydd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ער אנטלויפט, ווייל ער איז א געדונגענער, און עס קימערט אים נישט וועגן די שאף. ");
INSERT INTO ydd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","איך בין דער גוטער פאסטוך, און איך קען די מייניקע, און די מייניקע קענען מיך, ");
INSERT INTO ydd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ווי דער פאטער קען מיך, און איך קען דעם פאטער; און מיין לעבן לייג איך אנידער פאר די שאף. ");
INSERT INTO ydd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","און אנדערע שאף האב איך, וואס זענען נישט פון דעם דאזיקן הויף; זיי מוז איך אויך פירן, און זיי וועלן הערן מיין קול; און עס וועט ווערן איין סטאדע, איין פאסטוך. ");
INSERT INTO ydd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","דערפאר האט דער פאטער מיך ליב, ווייל איך לייג אנידער מיין לעבן, כדי איך זאל עס ווידער נעמען. ");
INSERT INTO ydd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","קיינער נעמט עס נישט אוועק פון מיר, נאר פון מיר אליין לייג איך עס אנידער. איך האב רשות עס אנידערצולייגן, און האב רשות עס ווידער צו נעמען. דאס דאזיקע געבאט האב איך באקומען פון מיין פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ווידער איז געווארן א מחלוקה צווישן די יידן צוליב די דאזיקע ווערטער. ");
INSERT INTO ydd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","און א סך פון זיי האבן געזאגט: ער האט א בייזן גייסט, און איז אראפ פון זינען; פארוואס הערט איר אים? ");
INSERT INTO ydd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","אנדערע האבן געזאגט: דאס זענען נישט די רייד פון א באזעסענעם מיט א בייזן גייסט. צי קען דען א בייזער גייסט עפענען די אויגן פון בלינדע? ");
INSERT INTO ydd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","עס איז דעמאלט געווען חנוכה אין ירושלים; עס איז געווען ווינטער, ");
INSERT INTO ydd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","און יהושע/ישוע איז געגאנגען אינם בית המקדש אין אולם של שלמה ארויף און אראפ. ");
INSERT INTO ydd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","און די יידן האבן אים ארומגערינגלט, און האבן געזאגט צו אים: ביז ווען ווילסטו אויסציען אונדזער נשמה? אויב דו ביסט דער משיח, זאג אונדז אפן. ");
INSERT INTO ydd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","האט יהושע/ישוע זיי געענטפערט: איך האב אייך שוין געזאגט, און איר גלויבט נישט; די מעשים, וואס איך טו אין מיין פאטערס נאמען, זיי זאגן עדות וועגן מיר. ");
INSERT INTO ydd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","נאר איר גלויבט נישט, ווייל איר זענט נישט פון מיינע שאף. ");
INSERT INTO ydd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","מיינע שאף הערן מיין קול, און איך קען זיי, און זיי פאלגן מיר נאך; ");
INSERT INTO ydd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","און איך גיב זיי אייביק לעבן: און זיי וועלן קיינמאל נישט פארלוירן ווערן, און קיינער וועט זיי נישט ארויסרייסן פון מיינע הענט. ");
INSERT INTO ydd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","מיין פאטער, וואס האט זיי מיר געגעבן, איז גרעסער ווי אלע; און קיינער קען זיי נישט ארויסרייסן פון מיין פאטערס האנט. ");
INSERT INTO ydd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","איך און דער פאטער זענען מיר איינס. ");
INSERT INTO ydd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","האבן די יידן ווידער אויפגעהויבן שטיינער, כדי אים צו שטייניקן. ");
INSERT INTO ydd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","יהושע/ישוע האט זיי געענטפערט: א סך מעשים טובים האב איך אייך געוויזן פון דעם פאטער; צוליב וועלכער פון די דאזיקע מעשים, שטייניקט איר מיך? ");
INSERT INTO ydd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","האבן די יידן אים געענטפערט: פאר מעשים טובים שטייניקן מיר דיך נישט, נאר פאר חלול‑השם, און ווייל דו, זייענדיק א מענטש, מאכסט דיך פאר ג‑ט. ");
INSERT INTO ydd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","האט יהושע/ישוע זיי געענטפערט: צי שטייט דען נישט געשריבן אין אייער תורה: איך האב געזאגט: איר זענט ג‑טער? ");
INSERT INTO ydd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","אויב ער האט זיי גערופן ג‑טער, צו וועמען ה׳ס ווארט איז געקומען—און די שריפט קען נישט בטל ווערן— ");
INSERT INTO ydd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","זאגט איר אויף אים, וועמען דער פאטער האט געהייליקט, און געשיקט אין דער וועלט אריין: דו לעסטערסט; ווייל איך האב געזאגט: איך בין דער זון פון דער אויבערשטער? ");
INSERT INTO ydd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","אויב איך טו נישט די מעשים פון מיין פאטער, זאלט איר מיר נישט גלויבן. ");
INSERT INTO ydd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","אויב אבער איך טו יא, אפילו ווען איר ווילט מיר נישט גלויבן, גלויבט די מעשים, כדי איר זאלט וויסן און פארשטיין, אז דער פאטער איז אין מיר, און איך בין אין דעם פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","דעריבער האבן זיי ווידער געזוכט אים צו כאפן, און ער איז ארויס פון זייער האנט. ");
INSERT INTO ydd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","און ער איז ווידער אוועק קיין עבר הירדן, צו דעם ארט, וואו יוחנן פלעגט צום ערשט טובל זיין אין דער מקווה, און איז דארט פארבלייבן. ");
INSERT INTO ydd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","און א סך זענען געקומען צו אים, און האבן געזאגט: יוחנן האט טאקע נישט געטאן קיין נס, נאר אלץ, וואס יוחנן האט געזאגט וועגן דעם דאזיקן (יהושע/ישוע), איז אמת. ");
INSERT INTO ydd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","און א סך האבן דארט געגלויבט אין אים. ");
INSERT INTO ydd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","און עס איז איינער געלעגן קראנק, אלעזר פון בית‑היני, דאס דארף פון מרים און איר שוועסטער מרתא. ");
INSERT INTO ydd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","און די מרים איז עס געווען, וואס האט געזאלבט דעם האר מיט טייער זאלב, און אים אפגעווישט זיינע פיס מיט אירע האר, וועמעס ברודער אלעזר איז געלעגן קראנק. ");
INSERT INTO ydd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","די שוועסטער האבן דעריבער געשיקט צו אים, אזוי צו זאגן: האר, זע, ער וועמען דו האסט ליב, ליגט קראנק. ");
INSERT INTO ydd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","און ווען יהושע/ישוע האט דאס געהערט, האט ער געזאגט: די דאזיקע קראנקייט איז נישט צום טויט, נאר צום כבוד פון ה׳, כדי דער זון פון דער אויבערשטער זאל פארהערלעכט ווערן דורך איר. ");
INSERT INTO ydd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","און יהושע/ישוע האט ליב געהאט מרתאן און איר שוועסטער און אלעזרן. ");
INSERT INTO ydd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","און ווען ער האט געהערט, אז ער ליגט קראנק, איז ער דעמאלט נאך פארבלייבן צוויי טעג אויף דעם ארט, וואו ער איז געווען. ");
INSERT INTO ydd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","דערנאך האט ער ערשט געזאגט צו די תלמידים: לאמיר ווידער גיין קיין יהודה. ");
INSERT INTO ydd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","זאגן די תלמידים צו אים: רבי, איצט האבן די יידן דיך געזוכט צו שטייניקן, און דו גייסט ווידער דארטן אהין? ");
INSERT INTO ydd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","האט יהושע/ישוע געענטפערט: צי האט דען נישט דער טאג צוועלף שעה? ווער עס גייט ארום בייטאג, דער שטרויכלט נישט, ווייל ער זעט דאס ליכט פון דער דאזיקער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ווער אבער עס גייט ארום ביינאכט, דער שטרויכלט, ווייל דאס ליכט איז נישט אין אים. ");
INSERT INTO ydd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","דאס האט ער גערעדט, און נאך דעם זאגט ער צו זיי: אלעזר, אונדזער פריינד איז אנטשלאפן געווארן; נאר איך גיי, כדי אים אויפצוועקן פון שלאף. ");
INSERT INTO ydd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","די תלמידים האבן דעריבער געזאגט צו אים: אויב ער איז איינגעשלאפן, וועט ער גענעזן ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","יהושע/ישוע אבער האט גערעדט וועגן זיין טויט; און זיי האבן געמיינט, אז ער רעדט וועגן דעם רואיקן שלומער פון שלאף. ");
INSERT INTO ydd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","דעריבער האט יהושע/ישוע דעמאלט צו זיי געזאגט גאנץ אפן: אלעזר איז געשטארבן. ");
INSERT INTO ydd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","און איך פריי מיך צוליב אייך, אז איך בין דארטן נישט געווען, כדי איר זאלט גלויבן; נאר לאמיר גיין צו אים. ");
INSERT INTO ydd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","דאן האט תומא, וואס מען האט אים גערופן דידומאס, געזאגט צו זיינע חברים תלמידים: לאמיר אויך גיין, כדי מיר זאלן שטארבן מיט אים. ");
INSERT INTO ydd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","און אהין קומענדיק, האט יהושע/ישוע אים געפונען שוין ליגן זינט פיר טעג אין קבר. ");
INSERT INTO ydd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","און בית‑היני איז געווען נאענט צו ירושלים, אן ערך פיפצן אקערפעלד ווייט; ");
INSERT INTO ydd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","און א סך יידן זענען ארויסגעקומען צו מרתאן און מרים, כדי זיי מנחם-אבל צו זיין וועגן דעם ברודער זייערן. ");
INSERT INTO ydd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","און ווי מרתא האט געהערט, אז יהושע/ישוע קומט, איז זי אים אנטקייגן געגאנגען; מרים אבער איז געבליבן זיצן אין הויז. ");
INSERT INTO ydd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","און מרתא האט געזאגט צו יהושען/ישוען: האר, אויב דו וואלסט דא געווען, וואלט מיין ברודער נישט געשטארבן. ");
INSERT INTO ydd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","און אפילו איצט ווייס איך, אז אלץ, וואס דו וועסט נאר בעטן ביי ה׳, וועט ה׳ דיר געבן. ");
INSERT INTO ydd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","זאגט יהושע/ישוע צו איר: דיין ברודער וועט אויפשטיין. ");
INSERT INTO ydd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","זאגט מרתא צו אים: איך ווייס, אז ער וועט אויפשטיין אין דער אויפשטייאונג אין דעם לעצטן טאג. ");
INSERT INTO ydd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","האט יהושע/ישוע געזאגט צו איר: איך בין די אויפשטייאונג און דאס לעבן; ווער עס גלויבט אין מיר, אפילו ווען ער איז שוין געשטארבן, וועט ער לעבן, ");
INSERT INTO ydd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","און יעדער איינער, וואס לעבט און גלויבט אין מיר, וועט אויף אייביק נישט שטארבן. צי גלויבסטו דאס דאזיקע? ");
INSERT INTO ydd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","זאגט זי צו אים: יא, האר, איך גלויב, אז דו ביסט דער משיח, דער זון פון דער אויבערשטער, וואס זאל קומען אין דער וועלט אריין. ");
INSERT INTO ydd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","און האבנדיק דאס געזאגט, איז זי אוועקגעגאנגען, און האט גערופן איר שוועסטער שטילערהייט, און געזאגט צו איר: דער רבי איז דא און רופט דיך. ");
INSERT INTO ydd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","און ווי יענע האט עס געהערט, איז זי גיך אויפגעשטאנען, און געקומען צו אים. ");
INSERT INTO ydd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","און יהושע/ישוע איז נאך נישט אריינגעגאנגען אין דארף אריין, נאר איז נאך געווען אויף דעם ארט, וואו מרתא האט אים באגעגענט. ");
INSERT INTO ydd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","און די יידן, וואס זענען מיט איר געווען אינם הויז, און האבן זי געטרייסט, זעענדיק, אז מרים האט זיך גיך אויפגעהויבן און איז ארויסגעגאנגען, האבן איר נאכגעפאלגט, מיינענדיק, אז זי גייט צום קבר, כדי דארט צו וויינען. ");
INSERT INTO ydd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","און ווי מרים איז אהינגעקומען, וואו יהושע/ישוע איז געווען, און האט אים געזען, איז זי אנידערגעפאלן פאר זיינע פיס, און האט צו אים געזאגט: אויב דו וואלסט דא געווען, וואלט דער ברודער מיינער נישט געשטארבן. ");
INSERT INTO ydd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","און ווי יהושע/ישוע האט זי געזען וויינען און די יידן, וואס זענען מיטגעקומען מיט איר, אויך וויינען, האט ער א זיפץ געטאן אין זיין גייסט, און זיך מצער געווען, ");
INSERT INTO ydd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","און געזאגט: וואו האט איר אים געלייגט? זאגן זיי צו אים: האר, קום און זע. ");
INSERT INTO ydd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","יהושע/ישוע האט פארגאסן א טרער. ");
INSERT INTO ydd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","די יידן האבן דעריבער געזאגט: אָט זעט, ווי ער האט אים ליב געהאט! ");
INSERT INTO ydd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","אייניקע אבער פון זיי האבן געזאגט: צי האט ער, וואס האט אויפגעעפנט די אויגן פון דעם בלינדן, דען נישט געקענט מאכן, אז אויך דער (אלעזר) זאל נישט שטארבן? ");
INSERT INTO ydd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","און ווידער א זיפץ טוענדיק אין זיך אליין, קומט יהושע/ישוע צום קבר. און עס איז געווען א הייל, און א שטיין איז געלעגן אויף איר. ");
INSERT INTO ydd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","זאגט יהושע/ישוע: נעמט אוועק דעם שטיין. זאגט מרתא, די שוועסטער פון דעם בר מינה, צו אים: האר, ער שטינקט שוין, ווארום ער ליגט שוין פיר טעג. ");
INSERT INTO ydd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","זאגט יהושע/ישוע צו איר; צי האב איך דיר דען נישט געזאגט, אז אויב דו וועסט גלויבן, וועסטו זען דעם כבוד פון ה׳? ");
INSERT INTO ydd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","און זיי האבן אוועקגענומען דעם שטיין. און יהושע/ישוע האט אויפגעהויבן די אויגן (צום הימל) ארויף און געזאגט: פאטער, איך דאנק דיר, אז דו האסט מיך דערהערט. ");
INSERT INTO ydd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","און איך האב געוואוסט, אז דו הערסט מיך תמיד; נאר צוליב דעם המון, וואס שטייט ארום, האב איך עס געזאגט, כדי זיי זאלן גלויבן, אז דו האסט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","און האבנדיק דאס געזאגט, האט ער א געשריי געטאן מיט א הויך קול: אלעזר, קום ארויס. ");
INSERT INTO ydd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","און דאס מת איז ארויסגעקומען, און זיינע הענט און פיס זענען געווען ארומגעוויקלט מיט תכריכים; און זיין פנים איז געווען פארבונדן מיט א טיכל. זאגט יהושע/ישוע צו זיי: בינדט אים אויף, און לאזט אים גיין. ");
INSERT INTO ydd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","און א סך פון די יידן, וואס זענען געקומען צו מרים, זעענדיק וואס ער האט געטאן, האבן געגלויבט אין אים. ");
INSERT INTO ydd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","אייניקע אבער פון זיי זענען אוועקגעגאנגען צו די פרושים, און האבן זיי דערציילט, וואס יהושע/ישוע האט געטאן. ");
INSERT INTO ydd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","די הויפט כהנים און די פרושים האבן דעריבער צוזאמענגעברענגט דאס סנהדרין, און געזאגט: וואס זאלן מיר טאן? ווייל דער דאזיקער מענטש טוט א סך נסים! ");
INSERT INTO ydd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","אויב מיר וועלן אים אזוי לאזן, וועלן אלע גלויבן אין אים, און די רוימער וועלן קומען און אוועקנעמען אונדזער לאנד און פאלק. ");
INSERT INTO ydd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","נאר איינער פון זיי, קיפא, זייענדיק כהן גדול אין יענעם יאר, האט צו זיי געזאגט: איר ווייסט גארנישט, ");
INSERT INTO ydd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","און בארעכנט אפילו נישט, אז עס טויג פאר אייך, אז איין מענטש זאל שטארבן פארן פאלק, און דאס גאנצע פאלק זאל נישט פארלוירן גיין. ");
INSERT INTO ydd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","דאס דאזיקע אבער האט ער פון זיך אליין נישט געזאגט, נאר ווייל ער איז געווען כהן גדול אין יענעם יאר, האט ער געזאגט נבואות, אז יהושע/ישוע וועט שטארבן פאר דעם פאלק (ישעיהו נג, ח.); ");
INSERT INTO ydd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","און נישט בלויז פאר דעם פאלק אליין, נאר כדי אויך די צעשפרייטע קינדער פון ה׳ זאל ער איינזאמלען אינאיינעם. ");
INSERT INTO ydd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","און פון יענעם טאג אָן האבן זיי זיך באראטן, אים צו טייטן. ");
INSERT INTO ydd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","יהושע/ישוע איז דעריבער מער נישט ארומגעגאנגען עפנטלעך צווישן די יידן, נאר איז אוועק פון דארטן צו דער געגנט נאענט פון דער מדבר, אין א שטאט, וואס מען רופט זי עפרים, און איז דארט פארבלייבן מיט די תלמידים. ");
INSERT INTO ydd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","און עס איז געווען נאענט פאר דעם יידישן פסח, און א סך זענען ארויפגעגאנגען קיין ירושלים פון דער געגנט אויף פסח, כדי זיך צו הייליקן. ");
INSERT INTO ydd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","און האבן געזוכט יהושען/ישוען, און געזאגט איינער צום אנדערן שטייענדיק אין בית המקדש: וואס מיינט איר? אז ער קומט נישט אויף יום טוב? ");
INSERT INTO ydd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","און די הויפט כהנים און די פרושים האבן ארויסגעגעבן א באפעל, אז ווען עמיצער ווייסט וואו ער שטייט איין, זאל ער עס צו וויסן געבן, כדי זיי זאלן אים כאפן. ");
INSERT INTO ydd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","און זעקס טעג פאר פסח איז יהושע/ישוע געקומען קיין בית‑היני, וואו אלעזר איז געווען, וועמען יהושע/ישוע האט אויפגעוועקט פון די טויטע. ");
INSERT INTO ydd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","מען האט דעריבער דארטן פאר אים געמאכט א סעודה, און מרתא האט באדינט; אלעזר אבער איז געווען איינער פון די, וואס זענען געזעסן מיט אים ביים טיש. ");
INSERT INTO ydd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","און מרים האט גענומען א פונט לויטערן, קאסטבארן נרדזאלבאייל, און געזאלבט (דערמיט) די פיס פון יהושען/ישוען, און אפגעווישט זיינע פיס מיט אירע האר; און דאס הויז האט זיך אנגעפילט מיט דעם ריח פון דעם זאלבאייל. ");
INSERT INTO ydd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","אבער יהודה איש‑קריות, איינער פון זיינע תלמידים, דער, וואס האט אים געזאלט פארראטן, האט געזאגט: ");
INSERT INTO ydd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","פארוואס האט מען נישט פארקויפט דעם דאזיקן זאלבאייל פאר דריי הונדערט דינרים און געגעבן (דאס געלט) צו ארעמעלייט? ");
INSERT INTO ydd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","און דאס דאזיקע האט ער געזאגט, נישט ווייל ער האט זיך געדאגהט וועגן די ארעמעלייט; נאר ווייל ער איז געווען א גנב, און געהאט די פושקע און פלעגט אונטערשלאגן, וואס מען האט אריינגעלייגט. ");
INSERT INTO ydd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","יהושע/ישוע האט דעריבער געזאגט: לאז זי צופרידן, צום טאג פון מיין קבורה האט זי עס באהאלטן. ");
INSERT INTO ydd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ווארום די ארעמעלייט האט איר תמיד ביי זיך, מיך אבער האט איר נישט אלעמאל. ");
INSERT INTO ydd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","און א גרויסער המון יידן האט זיך דערוואוסט, אז ער געפינט זיך דארטן; און זיי זענען געקומען נישט בלויז צוליב יהושען/ישוען, נאר אויך כדי צו זען אלעזרן, וועמען ער האט אויפגעוועקט פון די טויטע. ");
INSERT INTO ydd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","די הויפט כהנים אבער האבן זיך באראטן, אפילו אלעזרן צו טייטן; ");
INSERT INTO ydd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ווייל א סך פון די יידן זענען צוליב אים אוועקגעגאנגען, און האבן געגלויבט אין יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","צומארגנס האט דער המון עם, וואס איז געקומען אויף יום טוב, געהערט, אז יהושע/ישוע קומט קיין ירושלים, ");
INSERT INTO ydd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","האבן זיי גענומען פאלמענצווייגן, און זענען ארויס אים אנטקעגנצוגיין, און האבן געשריגן: הושענא, ברוך הבא בשם ה׳, מלך ישראל! (תהלים קיח, כה.) (געבענטשט איז דער, וואס קומט אינם נאמען פון דעם האר ג‑ט, דער מלך פון ישראל). ");
INSERT INTO ydd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","און געפינענדיק א יונג אייזעלע, האט זיך יהושע/ישוע דערויף ארויפגעזעצט, ווי עס שטייט געשריבן: ");
INSERT INTO ydd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","פארכט דיך נישט, דו טאכטער פון ציון, זע, דיין מלך קומט, רייטנדיק אויף א יונג אייזעלע. ");
INSERT INTO ydd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","דאס האבן זיינע תלמידים צום ערשט נישט פארשטאנען; נאר ווען יהושע/ישוע איז שוין געווען פארהערלעכט, האבן זיי זיך דעמאלט דערמאנט, אז עס איז געווען געשריבן וועגן אים, און אז דאס האט מען געטאן צו אים. ");
INSERT INTO ydd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","און די מאסע מענטשן, וואס איז געווען מיט אים, ווען ער האט אלעזרן ארויסגערופן פונם קבר, און אים אויפגעוועקט פון די טויטע, האט עדות געזאגט וועגן אים. ");
INSERT INTO ydd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","צוליב דעם טאקע איז דער עולם אים אנטקעגנגעגאנגען, ווייל זיי האבן געהערט, אז ער האט געטאן דאס דאזיקע נס. ");
INSERT INTO ydd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","דעריבער האבן די פרושים געזאגט איינער צום אנדערן: איר זעט, אז איר פועלט גארנישט; זע, די גאנצע וועלט לויפט אים שוין נאך! ");
INSERT INTO ydd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","און עס זענען געווען אייניקע גריכן צווישן די, וואס האבן עולה רגל געווען, כדי זיך צו בוקן דעם יום טוב; ");
INSERT INTO ydd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","און זיי זענען צוגעקומען צו פיליפוסן, וואס האט געשטאמט פון בית‑צידה אין גליל, און האבן אים געבעטן, אזוי צו זאגן: האר, מיר ווילן זען יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","קומט פיליפוס און זאגט עס צו אנדריי; קומט אנדריי מיט פיליפוסן און זאגן עס צו יהושען/ישוען; ");
INSERT INTO ydd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","יהושע/ישוע אבער האט זיי געענטפערט, אזוי צו זאגן: עס איז געקומען די שעה, אז דער בר אנש זאל פארהערלעכט ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","באמת, באמת זאג איך אייך: אויב דאס קערנדל ווייץ פאלט אין דער ערד אריין און שטארבט נישט, בלייבט עס אליין; אויב אבער עס שטארבט יא, ברענגט עס א סך פירות. ");
INSERT INTO ydd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","דער, וואס האט ליב זיין נפש, פארלירט עס; און דער, וואס האט פיינט זיין נפש אין דער דאזיקער וועלט, וועט עס אפהיטן צום אייביקן לעבן. ");
INSERT INTO ydd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","אויב עמיצער דינט מיך, זאל ער מיר נאכפאלגן; און וואו איך בין, דארט וועט אויך מיין דינער זיין; אויב עמיצער דינט מיך, וועט דער פאטער אים אפגעבן כבוד. ");
INSERT INTO ydd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","איצט איז מיין נפש באאומרואיקט; און וואס זאל איך זאגן? פאטער, זיי מיך מציל פון דער דאזיקער שעה? אבער צוליב דעם בין איך דאך געקומען צו דער דאזיקער שעה. ");
INSERT INTO ydd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","פאטער, פארהערלעך דיין נאמען! און עס איז געקומען א קול פון הימל: איך האב שוין פארהערלעכט און וועל ווידער פארהערלעכן. ");
INSERT INTO ydd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","דער המון מענטשן, וואס איז געשטאנען און זיך צוגעהערט, האט געזאגט, עס האט געדונערט; אנדערע האבן געזאגט: א מלאך האט גערעדט צו אים. ");
INSERT INTO ydd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","האט יהושע/ישוע געענטפערט און געזאגט; נישט צוליב מיר איז דאס דאזיקע קול געקומען, נאר צוליב אייך. ");
INSERT INTO ydd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","איצט איז דאס משפט פון דער דאזיקער וועלט; איצט וועט דער שר פון דער דאזיקער וועלט ארויסגעווארפן ווערן אינדרויסן. ");
INSERT INTO ydd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","און איך, ווען איך וועל אויפגעהויבן ווערן פון דער ערד, וועל ציען אלעמען צו מיר. ");
INSERT INTO ydd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","דאס דאזיקע האט ער געזאגט, מרמז צו זיין, מיט וואס פאר א טויט ער גייט שטארבן. ");
INSERT INTO ydd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","דער עולם האט דעריבער געענטפערט צו אים: מיר האבן געהערט פון דער תורה, אז דער משיח בלייבט אויף אייביק; און וויאזוי זשע זאגסטו: דער בר אנש מוז אויפגעהויבן ווערן? ווער איז דאס דער דאזיקער בר אנש? ");
INSERT INTO ydd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","האט יהושע/ישוע צו זיי געזאגט: נאך א קליינע וויילע איז דאס ליכט צווישן אייך. גייט זשע אינם ליכט בשעת איר האט עס, כדי די פינצטערניש זאל אייך נישט איבערפאלן; און דער, וואס גייט אין דער פינצטערניש, ווייסט נישט וואו ער גייט. ");
INSERT INTO ydd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","בשעת איר האט דאס ליכט, גלויבט אינם ליכט, כדי איר זאלט ווערן קינדער פונם ליכט. דאס האט יהושע/ישוע גערעדט, און איז אוועקגעגאנגען, און האט זיך פארבארגן פון זיי. ");
INSERT INTO ydd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","און הגם ער האט געטאן פאר זיי אזויפיל נסים, האבן זיי (אלץ) נישט געגלויבט אין אים; ");
INSERT INTO ydd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","כדי דאס ווארט פון ישעיהו הנביא זאל מקוים ווערן, וואס ער האט געזאגט: אָ האר, ווער האט געגלויבט אונדזער שמועה? און אויף וועמען האט זיך אנטפלעקט דער ארעם פון האר (ה׳)? ");
INSERT INTO ydd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","דערפאר האבן זיי נישט געקענט גלויבן, ווייל ישעיהו האט ווידער געזאגט: ");
INSERT INTO ydd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","און ער האט בלינד געמאכט זייערע אויגן, הארט געמאכט זייער הארץ, כדי זיי זאלן נישט זען מיט די אויגן, און באנעמען מיטן הארץ, און תשובה טאן, און איך זאל זיי היילן. ");
INSERT INTO ydd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","דאס האט ישעיהו געזאגט, ווייל ער האט געזען זיין כבוד, און גערעדט וועגן אים. ");
INSERT INTO ydd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","דאך האבן א סך אפילו פון די שרים געגלויבט אין אים, נאר צוליב די פרושים האבן זיי עס נישט מודה געווען, כדי זיי זאלן נישט געלייגט ווערן אין חרם אריין; ");
INSERT INTO ydd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ווארום זיי האבן ליבער געהאט דעם כבוד פון מענטשן, ווי דעם כבוד פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","און יהושע/ישוע האט אויסגערופן און געזאגט: דער, וואס גלויבט אין מיר, גלויבט נישט אין מיר, נאר אין דעם, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","און דער, וואס זעט מיך, זעט דעם, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","איך בין געקומען א ליכט אין דער וועלט אריין, כדי יעדער איינער, וואס גלויבט אין מיר, זאל נישט בלייבן אין דער פינצטערניש. ");
INSERT INTO ydd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","און אויב עמיצער הערט מיינע רייד, און היט זיי נישט, וועל איך אים נישט משפטן; ווארום איך בין נישט געקומען, כדי איך זאל משפטן די וועלט, נאר כדי איך זאל ראטעווען די וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","דער, וואס ווארפט מיך אפ און נעמט נישט אָן מיינע רייד, האט שוין זיין שופט; דאס ווארט, וואס איך האב גערעדט, דאס וועט אים משפטן אין דעם לעצטן טאג. ");
INSERT INTO ydd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ווייל איך האב פון מיר אליין נישט גערעדט; נאר ער, וואס האט מיך געשיקט, דער פאטער אליין, האט מיר געגעבן א געבאט, וואס איך זאל זאגן, און וואס איך זאל רעדן. ");
INSERT INTO ydd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","און איך ווייס, אז זיין געבאט איז אייביק לעבן. דעריבער וואס איך רעד, רעד איך אזוי, ווי דער פאטער האט צו מיר גערעדט. ");
INSERT INTO ydd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","און פאר דעם יום טוב פסח, אזוי ווי יהושע/ישוע האט געוואוסט, אז זיין שעה איז געקומען, כדי ער זאל אוועקגיין פון דער דאזיקער וועלט צום פאטער, האבנדיק געליבט זיינע אייגענע, וואס זענען אין דער וועלט, האט ער זיי ליב געהאט ביז צום סוף. ");
INSERT INTO ydd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","און בשעת דער סעודה אין אוונט, נאך דעם ווי דער שׂטן האט שוין געהאט געלייגט אין הארצן פון יהודה בן שמעון איש‑קריות, אז ער זאל אים פארראטן, ");
INSERT INTO ydd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","(יהושע/ישוע) וויסנדיק, אז דער פאטער האט אים אלץ איבערגעבן אין די הענט אריין, און אז ער איז געקומען פון ה׳ און גייט צו ה׳, ");
INSERT INTO ydd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","איז ער אויפגעשטאנען פונם טיש, און האט אוועקגעלייגט די מלבושים, און נעמענדיק א האנטוך, האט ער זיך ארומגעגארטלט. ");
INSERT INTO ydd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","נאך דעם האט ער אריינגעגאסן וואסער אינם בעקן און אנגעהויבן צו וואשן די תלמידימס פיס און אפצואווישן מיטן האנטוך, מיט וועלכן ער איז געווען ארומגעגארטלט. ");
INSERT INTO ydd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","אזוי קומט ער צו שמעון פעטרוסן. זאגט ער צו אים: האר, דו זאלסט מיר וואשן די פיס? ");
INSERT INTO ydd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","האט יהושע/ישוע געענטפערט און געזאגט צו אים: וואס איך טו, ווייסטו נישט אצונד, שפעטער אבער וועסטו זיך דערוויסן. ");
INSERT INTO ydd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","זאגט פעטרוס צו אים: דו זאלסט מיר בשום אופן קיינמאל נישט וואשן מיינע פיס. האט יהושע/ישוע אים געענטפערט: אויב איך וואש דיך נישט, האסטו נישט קיין חלק מיט מיר. ");
INSERT INTO ydd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","זאגט שמעון פעטרוס צו אים: האר, נישט בלויז מיינע פיס, נאר אפילו מיינע הענט און דעם קאפ! ");
INSERT INTO ydd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","זאגט יהושע/ישוע צו אים: דער געוואשענער דארף נישט מער ווי אפצואוואשן די פיס, ווייל ער איז אינגאנצן ריין; און איר זענט ריין, אבער נישט אלע. ");
INSERT INTO ydd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ווארום ער האט געוואוסט, ווער עס וועט אים פארראטן; דערפאר האט ער געזאגט: נישט אלע זענט איר ריין. ");
INSERT INTO ydd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","און ווען ער האט שוין געהאט געוואשן זייערע פיס, און גענומען זיינע מלבושים, און זיך ווידער אנידערגעזעצט, האט ער צו זיי געזאגט: צי ווייסט איר וואס איך האב געטאן צו אייך? ");
INSERT INTO ydd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","איר רופט מיך רבי און האר, און ריכטיק זאגט איר, ווארום איך בין עס. ");
INSERT INTO ydd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","דעריבער אויב איך, דער האר און רבי, האב אייך געוואשן אייערע פיס, זענט איר אויך מחייב צו וואשן איינער דעם אנדערן די פיס. ");
INSERT INTO ydd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ווארום איך האב אייך געגעבן א ביישפיל, כדי, ווי איך האב געטאן צו אייך, אזוי זאלט איר אויך טאן. ");
INSERT INTO ydd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","באמת, באמת זאג איך אייך; א קנעכט איז נישט גרעסער ווי זיין האר, אויך איז א שליח נישט גרעסער ווי דער, וואס האט אים געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","אויב איר ווייסט דאס, געבענטשט זענט איר, אויב איר טוט עס. ");
INSERT INTO ydd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","נישט וועגן אייך אלע רעד איך; ווארום איך ווייס וועמען איך האב אויסדערוויילט; נאר כדי דער פסוק זאל מקוים ווערן: דער, וואס עסט מיין ברויט, האט אויפגעהויבן זיין טריט (עקב) קעגן מיר. ");
INSERT INTO ydd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","שוין איצט זאג איך עס אייך, איידער עס געשעט, כדי ווען עס וועט געשען, זאלט איר גלויבן, אז איך בין עס. ");
INSERT INTO ydd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","באמת, באמת זאג איך אייך: ווער עס נעמט אויף דעם, וועמען איך שיק, דער נעמט מיך אויף; און ווער עס נעמט מיך אויף, דער נעמט אויף אים, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","דאס זאגנדיק, האט יהושע/ישוע זיך באאומרואיקט אין זיין גייסט, און האט עדות געזאגט, און גערעדט: באמת, באמת זאג איך אייך: איינער פון אייך וועט מיך פארראטן. ");
INSERT INTO ydd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","די תלמידים האבן דעריבער געקוקט איינער אויפן אנדערן, מסופק וועגן וועמען ער זאגט עס. ");
INSERT INTO ydd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","און איינער פון זיינע תלמידים, וועמען יהושע/ישוע האט (באזונדערס) ליב געהאט, איז געווען אנגעלענט אויף ישועס ברוסט. ");
INSERT INTO ydd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","האט שמעון פעטרוס געוואונקען צו דעם דאזיקן, און צו אים געזאגט: זאג ווער עס איז, וועגן וועמען ער רעדט. ");
INSERT INTO ydd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","נייגנדיק זיך אזוי צו ישועס ברוסט, זאגט יענער צו אים: האר, ווער איז עס? ");
INSERT INTO ydd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","יהושע/ישוע האט געענטפערט: יענער איז עס, פאר וועמען איך וועל איינטונקען דעם ביסן און אים געבן. און איינטונקענדיק דעם ביסן, נעמט ער און גיט אים צו יהודה בן שמעון איש‑קריות. ");
INSERT INTO ydd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","און נאך דעם ביסן איז דער שׂטן דעמאלט אריין אין אים. יהושע/ישוע האט דעריבער צו אים געזאגט: וואס דו טוסט, טו גיך. ");
INSERT INTO ydd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","און קיינער ארום דעם טיש האט נישט פארשטאנען, פארוואס ער האט דאס געזאגט צו אים. ");
INSERT INTO ydd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ווארום אייניקע האבן געמיינט, ווייל יהודה האט געהאט די פושקע, זאגט יהושע/ישוע צו אים: קויף איין, וואס מיר ברויכן אויף יום טוב; אדער אז ער זאל עפעס געבן צו די ארעמעלייט. ");
INSERT INTO ydd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","און ווי ער האט געהאט גענומען דעם ביסן, איז ער גלייך ארויסגעגאנגען; און עס איז געווען נאכט. ");
INSERT INTO ydd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","און ווען ער איז ארויסגעגאנגען, האט יהושע/ישוע געזאגט: איצט איז דער בר אנש פארהערלעכט, און ה׳ איז פארהערלעכט אין אים; ");
INSERT INTO ydd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","און אויב ה׳ איז פארהערלעכט אין אים, וועט ה׳ אים פארהערלעכן אין זיך אליין, און באלד וועט ער אים פארהערלעכן. ");
INSERT INTO ydd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","קינדער, נאך א קורצע צייט בין איך מיט אייך. איר וועט מיך זוכן, און ווי איך האב געזאגט צו די יידן: וואואהין איך גיי, קענט איר נישט קומען, אזוי זאג איך אויך אייך איצט. ");
INSERT INTO ydd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","א נייע מצווה גיב איך אייך, אז איר זאלט ליב האבן איינער דעם אנדערן; ווי איך האב אייך ליב געהאט, אזוי זאלט איר אויך ליב האבן איינער דעם אנדערן. ");
INSERT INTO ydd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","דורך דעם דאזיקן וועלן אלע דערקענען, אז איר זענט מיינע תלמידים, אויב איר וועט האבן ליבע איינער פאר דעם אנדערן. ");
INSERT INTO ydd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","זאגט שמעון פעטרוס צו אים: האר, וואואהין גייסטו? האט יהושע/ישוע געענטפערט: וואואהין איך גיי, קענסטו מיר איצט נישט נאכפאלגן, שפעטער אבער וועסטו מיר נאכפאלגן. ");
INSERT INTO ydd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","זאגט פעטרוס צו אים: האר, פארוואס קען איך דיר איצט נישט נאכפאלגן? מיין לעבן וועל איך אנידערלייגן פאר דיינעטוועגן. ");
INSERT INTO ydd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ענטפערט יהושע/ישוע: דיין לעבן וועסטו אנידערלייגן פאר מיינעטוועגן? באמת, באמת זאג איך דיר: איידער נאך דער האן וועט קרייען, וועסטו מיך דריי מאל פארלייקענען! ");
INSERT INTO ydd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","זאל אייער הארץ זיך נישט באאומרואיקן; איר גלויבט אין ה׳, גלויבט אויך אין מיר. ");
INSERT INTO ydd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","אין מיין פאטערס הויז איז דא א סך וואוינונגען; וואלט עס נישט אזוי געווען, וואלט איך עס אייך געזאגט; ווייל איך גיי צוגרייטן אן ארט פאר אייך. ");
INSERT INTO ydd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","און ווען איך גיי און גרייט צו אן ארט פאר אייך, וועל איך ווידער קומען, און אייך נעמען צו מיר, כדי וואו איך בין, זאלט איר אויך זיין. ");
INSERT INTO ydd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","און וואואהין איך גיי, ווייסט איר, און איר קענט דעם וועג. ");
INSERT INTO ydd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","זאגט תומא צו אים: האר, מיר ווייסן נישט וואואהין דו גייסט; און וויאזוי קענען מיר וויסן דעם וועג? ");
INSERT INTO ydd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","זאגט צו אים יהושע/ישוע: איך בין דער דרך (ה׳) און דער אמת און דאס לעבן; קיינער קומט נישט צום פאטער, אחוץ דורך מיר. ");
INSERT INTO ydd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","אויב איר וואלט מיך געקענט, וואלט איר אויך געקענט מיין פאטער; און פון איצט אָן קענט איר אים און האט אים געזען. ");
INSERT INTO ydd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","זאגט פיליפוס צו אים: האר, ווייז אונדז דעם פאטער, און עס וועט זיין גענוג פאר אונדז. ");
INSERT INTO ydd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","זאגט יהושע/ישוע צו אים: אזא לאנגע צייט בין איך שוין מיט אייך, און דו קענסט מיך נישט, פיליפוס? ווער עס האט מיך געזען, דער האט געזען דעם פאטער; און וויאזוי זאגסטו: ווייז אונדז דעם פאטער? ");
INSERT INTO ydd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","צי גלויבסטו דען נישט, אז איך בין אין דעם פאטער און דער פאטער איז אין מיר? די ווערטער וואס איך רעד צו אייך, רעד איך נישט פון מיר אליין; נאר דער פאטער, וואס וואוינט אין מיר, טוט זיינע מעשים. ");
INSERT INTO ydd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","גלויבט מיר, אז איך בין אין דעם פאטער און דער פאטער אין מיר; און אויב נישט, גלויבט צוליב די מעשים אליין. ");
INSERT INTO ydd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","באמת, באמת זאג איך אייך: דער, וואס גלויבט אין מיר, די מעשים וואס איך טו, וועט ער אויך טאן; און גרעסערע ווי די דאזיקע וועט ער טאן, ווייל איך גיי צו דעם פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","און וואס איר וועט נאר בעטן אין מיין נאמען, וועל איך דאס דאזיקע טאן, כדי דער פאטער זאל פארהערלעכט ווערן אין דעם זון. ");
INSERT INTO ydd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","אויב איר וועט מיך עפעס בעטן אין מיין נאמען, וועל איך עס טאן. ");
INSERT INTO ydd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","אויב איר האט מיך ליב, זאלט איר האלטן מיינע געבאטן! ");
INSERT INTO ydd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","און איך וועל בעטן דעם פאטער, און ער וועט אייך געבן אן אנדערן פרקליט, כדי ער זאל זיין מיט אייך אויף אייביק; ");
INSERT INTO ydd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","דעם גייסט פון אמת, וואס די וועלט קען אים נישט אויפנעמען, מחמת זי זעט אים נישט און קען אים נישט; איר קענט אים יא, ווייל ער בלייבט ביי אייך און וועט זיין אין אייך. ");
INSERT INTO ydd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","איך וועל אייך נישט איבערלאזן ווי יתומים; איך וועל קומען צו אייך. ");
INSERT INTO ydd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","נאך א קליינע וויילע און די וועלט זעט מיך מער נישט, איר אבער זעט מיך; ווייל איך לעב, וועט איר לעבן אויך. ");
INSERT INTO ydd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","אין יענעם טאג וועט איר וויסן, אז איך בין אין מיין פאטער, און איר זענט אין מיר, און איך בין אין אייך. ");
INSERT INTO ydd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ווער עס האט מיינע געבאטן און האלט זיי, דער איז עס, וואס האט מיך ליב; און דער, וואס האט מיך ליב, וועט זיין געליבט פון מיין פאטער, און איך וועל אים ליב האבן, און וועל מיך אנטפלעקן צו אים. ");
INSERT INTO ydd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","זאגט צו אים יהודה, נישט דער איש‑קריות: האר, וואס איז געשען, אז דו וועסט דיך אנטפלעקן צו אונדז און נישט צו דער וועלט? ");
INSERT INTO ydd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","האט יהושע/ישוע געענטפערט און געזאגט צו אים: אויב עמיצער האט מיך ליב, וועט ער האלטן מיין ווארט; און מיין פאטער וועט אים ליב האבן; און מיר וועלן קומען צו אים און מאכן א וואוינונג (פאר אונדז) ביי אים. ");
INSERT INTO ydd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ווער עס האט מיך נישט ליב, דער האלט נישט מיינע ווערטער; און דאס ווארט, וואס איר הערט, איז נישט מיין, נאר פון דעם פאטער, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","דאס האב איך צו אייך גערעדט, זייענדיק ביי אייך. ");
INSERT INTO ydd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","דער פרקליט אבער, דער רוח הקודש, וועמען דער פאטער וועט שיקן אין מיין נאמען, ער וועט אייך אלץ לערנען, און אייך דערמאנען אלץ, וואס איך האב אייך געזאגט. ");
INSERT INTO ydd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","שלום לאז איך איבער מיט אייך; מיין שלום גיב איך אייך; נישט ווי די וועלט גיט, גיב איך אייך. זאל זיך אייער הארץ נישט באאומרואיקן, און זאל עס נישט ווערן פארצאגט. ");
INSERT INTO ydd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","איר האט געהערט, אז איך האב אייך געזאגט; איך גיי אוועק, און קום (ווידער) צו אייך. אויב איר וואלט מיך ליב געהאט, וואלט איר זיך געפריידט, אז איך גיי צו דעם פאטער, ווייל דער פאטער איז גרעסער פון מיר. ");
INSERT INTO ydd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","און איצט האב איך עס אייך געזאגט, איידער עס געשעט, כדי איר זאלט גלויבן, ווען עס וועט געשען. ");
INSERT INTO ydd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","איך וועל מער נישט רעדן קיין סך מיט אייך; ווארום דער שר פון דער וועלט קומט; און אין מיר האט ער גארנישט; ");
INSERT INTO ydd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","נאר כדי די וועלט זאל וויסן, אז איך האב ליב דעם פאטער, און ווי דער פאטער האט מיר געבאטן, אזוי טו איך. שטייט אויף; לאמיר אוועקגיין פונדאנען. ");
INSERT INTO ydd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","איך בין דער ווארהאפטיקער וויינשטאק, און מיין פאטער איז דער גערטנער. ");
INSERT INTO ydd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","יעדע צווייג אין מיר, וואס ברענגט נישט קיין פירות, נעמט ער אוועק; און יעדע, וואס ברענגט יא פירות, ער אפשניידן ריין (צווייג), כדי זי זאל ברענגען מער פירות. ");
INSERT INTO ydd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","איר זענט שוין ריין, דורך דעם ווארט, וואס איך האב צו אייך גערעדט. ");
INSERT INTO ydd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","בלייבט אין מיר, און איך אין אייך, ווי די צווייג קען נישט ברענגען קיין פירות פון זיך אליין, אויב זי בלייבט נישט אינם וויינשטאק, אזוי (קענט) איר נישט, אויב איר בלייבט נישט אין מיר. ");
INSERT INTO ydd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","איך בין דער וויינשטאק; איר זענט די צווייגן; ווער עס בלייבט אין מיר, און איך אין אים, דער ברענגט א סך פירות; ווייל אָן מיר קענט איר גארנישט טאן. ");
INSERT INTO ydd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","אויב עמיצער בלייבט נישט אין מיר, ווערט ער ארויסגעווארפן אינדרויסן, ווי די צווייג, און ווערט פארדארט; און מען זאמלט זיי איין און ווארפט זיי אין פייער אריין, און זיי ווערן פארברענט. ");
INSERT INTO ydd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","אויב איר בלייבט אין מיר, און מיינע ווערטער בלייבן אין אייך, מעגט איר בעטן וואס איר ווילט נאר, און עס וועט אייך געטאן ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","אין דעם דאזיקן ווערט מיין פאטער פארהערלעכט, אז איר זאלט ברענגען א סך פירות; און זיין מיינע תלמידים. ");
INSERT INTO ydd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ווי דער פאטער האט מיך ליב געהאט, אזוי האב איך אייך ליב געהאט; פארבלייבט אין דער ליבע מיינער! ");
INSERT INTO ydd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","אויב איר וועט האלטן מיינע געבאטן, וועט איר בלייבן אין מיין ליבע, ווי איך האב געהאלטן די געבאטן פון מיין פאטער, און בלייב אין דער ליבע זיינער. ");
INSERT INTO ydd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","דאס האב איך גערעדט צו אייך, כדי מיין פרייד זאל זיין אין אייך, און אייער פרייד זאל ווערן פול. ");
INSERT INTO ydd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","דאס דאזיקע איז מיין געבאט, אז איר זאלט ליב האבן איינער דעם אנדערן, ווי איך האב אייך ליב געהאט. ");
INSERT INTO ydd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","קיינער האט נישט קיין גרעסערע ליבע ווי די דאזיקע, אז ער זאל אנידערלייגן זיין לעבן פאר זיינע פריינד. ");
INSERT INTO ydd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","איר זענט מיינע פריינד, אויב איר טוט, וואס איך באפעל אייך. ");
INSERT INTO ydd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","איך רוף אייך מער נישט קנעכט, ווייל דער קנעכט ווייסט נישט וואס זיין האר טוט; איך רוף אייך אבער פריינד, ווייל אלץ, וואס איך האב געהערט ביי מיין פאטער, האב איך אייך צו וויסן געטאן. ");
INSERT INTO ydd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","נישט איר האט מיך אויסדערוויילט, נאר איך האב אייך אויסדערוויילט, און אייך באשטימט, אז איר זאלט גיין און ברענגען פירות, און אז אייערע פירות זאלן בלייבן; כדי וואס איר וועט בעטן דעם פאטער אין מיין נאמען, זאל ער אייך געבן. ");
INSERT INTO ydd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","דאס באפעל איך אייך, כדי איר זאלט ליב האבן איינער דעם אנדערן. ");
INSERT INTO ydd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","אויב די וועלט האסט אייך, ווייסט איר, אז זי האט מיך, קודם כל, געהאסט פאר אייך. ");
INSERT INTO ydd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","אויב איר וואלט געווען פון דער וועלט, וואלט די וועלט ליב געהאט דאס, וואס איז איר אייגנס; ווייל אבער איר זענט נישט פון דער וועלט, נאר איך האב אייך אויסדערוויילט פון דער וועלט, צוליב דעם האט די וועלט אייך פיינט. ");
INSERT INTO ydd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","געדענקט דאס ווארט, וואס איך האב אייך געזאגט: א קנעכט איז נישט גרעסער ווי זיין האר. אויב מען האט מיך גערודפט, וועט מען אייך אויך רודפן; אויב מען האט געהאלטן מיין ווארט, וועט מען אויך אייערס האלטן. ");
INSERT INTO ydd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","אבער דאס אלץ וועט מען אייך טאן צוליב מיין נאמען, ווייל זיי קענען נישט אים, וואס האט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","אויב איך וואלט נישט געקומען און גערעדט צו זיי, וואלטן זיי נישט געהאט קיין זינד; איצט אבער האבן זיי נישט קיין אנטשולדיקונג פאר זייער זינד. ");
INSERT INTO ydd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ווער עס האט מיך פיינט, דער האט אויך פיינט דעם פאטער מיינעם. ");
INSERT INTO ydd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","אויב איך וואלט נישט געטאן צווישן זיי די מעשים, וואס קיין אנדערער האט נישט געטאן, וואלטן זיי נישט געהאט קיין זינד; איצט אבער האבן זיי געזען (די דאזיקע) און האבן מיך דאך פיינט און דעם פאטער מיינעם. ");
INSERT INTO ydd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","נאר (דאס געשעט), כדי עס זאל מקוים ווערן דאס ווארט, וואס שטייט געשריבן אין זייער תורה: מיט א שנאת חנם האבן זיי מיך פיינט געהאט. ");
INSERT INTO ydd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ווען אבער דער פרקליט וועט קומען, וועמען איך וועל שיקן צו אייך פון מיין פאטער, דעם גייסט פון אמת, וואס קומט ארויס פון דעם פאטער, וועט ער עדות זאגן וועגן מיר; ");
INSERT INTO ydd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","און איר וועט אויך עדות זאגן, ווייל איר זענט געווען מיט מיר פון אנהויב אָן. ");
INSERT INTO ydd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","דאס האב איך צו אייך גערעדט, כדי איר זאלט נישט ניכשול ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","מען וועט אייך לייגן אין חרם אריין; יא, עס קומט אָן א שעה, אז יעדער איינער, וואס וועט אייך הרגענען, וועט מיינען, ער דינט ה׳ מיט דעם. ");
INSERT INTO ydd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","און דאס וועלן זיי טאן, ווייל זיי האבן נישט געקענט דעם פאטער, און נישט מיך. ");
INSERT INTO ydd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","און דאס האב איך גערעדט צו אייך, כדי ווען די שעה וועט קומען, זאלט איר זיך דערמאנען דערין, אז איך האב עס אייך געזאגט. אין אנהויב אבער האב איך עס אייך נישט געזאגט, ווייל איך בין געווען מיט אייך. ");
INSERT INTO ydd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","און איצט גיי איך צו אים, וואס האט מיך געשיקט; און קיין איינער פון אייך פרעגט מיך נישט: וואואהין גייסטו? ");
INSERT INTO ydd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","נאר ווייל איך האב דאס גערעדט צו אייך, האט עצבות אנגעפילט אייער הארץ. ");
INSERT INTO ydd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","איך זאג אייך אבער דעם אמת: עס איז גוט פאר אייך, אז איך גיי אוועק; ווארום אויב איך זאל נישט אוועקגיין, וועט דער פרקליט בשום אופן נישט קומען צו אייך; און אויב איך גיי יא, וועל איך אים שיקן צו אייך. ");
INSERT INTO ydd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","און ווען ער וועט קומען, וועט ער איבערצייגן די וועלט וועגן זינד און וועגן צדקות און וועגן משפט: ");
INSERT INTO ydd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","וועגן זינד, ווייל זיי האבן נישט געגלויבט אין מיר; ");
INSERT INTO ydd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","און וועגן צדקות, ווייל איך גיי צום פאטער, און איר וועט מיך מער נישט זען; ");
INSERT INTO ydd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","און וועגן משפט, ווייל דער שר פון דער דאזיקער וועלט איז געמשפט געווארן. ");
INSERT INTO ydd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","נאך א סך האב איך אייך צו זאגן, נאר איר קענט עס איצט נישט דערטראגן. ");
INSERT INTO ydd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","דאך ווען ער וועט קומען, דער גייסט פון אמת, וועט ער אייך פירן אין דעם גאנצן אמת אריין; ווארום ער וועט נישט רעדן פון זיך אליין, נאר אלץ, וואס ער הערט, וועט ער רעדן; און ער וועט אייך אנזאגן דאס, וואס דארף ערשט קומען. ");
INSERT INTO ydd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ער וועט מיך פארהערלעכן, ווייל ער וועט באקומען פון דעם, וואס איז מיין און וועט עס אייך דערקלערן. ");
INSERT INTO ydd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","אלץ, וואס דער פאטער האט, איז מיין; דערפאר האב איך געזאגט, אז ער נעמט פון דעם, וואס איז מיין, און וועט עס אייך אנזאגן. ");
INSERT INTO ydd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","נאך א קליינע וויילע, און איר זעט מיך מער נישט; און ווידער א קליינע וויילע, און איר וועט מיך יא זען. ");
INSERT INTO ydd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","אייניקע פון זיינע תלמידים האבן דעריבער געזאגט איינער צום אנדערן: וואס איז דאס דאזיקע, וואס ער זאגט אונדז: א קליינע וויילע, און איר זעט מיך נישט; און ווידער א קליינע וויילע, און איר וועט מיך יא זען? און: ווייל איך גיי צו דעם פאטער? ");
INSERT INTO ydd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","דעריבער האבן זיי געזאגט: וואס איז דאס דאזיקע, וואס ער זאגט: א קליינע וויילע? מיר פארשטייען נישט, וואס ער רעדט. ");
INSERT INTO ydd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","יהושע/ישוע האט געמערקט, אז זיי ווילן אים פרעגן, און ער האט צו זיי געזאגט: איר פרעגט זיך נאך, איינער ביים אנדערן, וועגן דעם דאזיקן, וואס איך האב געזאגט: א קליינע וויילע, און איר זעט מיך נישט, און ווידער א קליינע וויילע, און איר וועט מיך זען? ");
INSERT INTO ydd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","באמת, באמת זאג איך אייך: איר וועט וויינען און קלאגן, אבער די וועלט וועט זיך פרייען; איר וועט זיין טרויעריק, נאר אייער טרויער וועט ווערן א שמחה. ");
INSERT INTO ydd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","א פרוי, ווען זי גייט צו קינד, איז טרויעריק, ווייל איר שעה איז געקומען; ווען אבער זי האט געבוירן דאס קינד, געדענקט זי מער נישט די אנגסט, צוליב דער פרייד, אז א מענטש איז געבוירן געווארן אין דער וועלט אריין. ");
INSERT INTO ydd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","אזוי האט איר אויך איצט צער; איך וועל אייך אבער ווידער זען, און אייער הארץ וועט זיך פרייען, און די שמחה אייערע וועט קיינער נישט אוועקנעמען פון אייך. ");
INSERT INTO ydd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","און אין יענעם טאג וועט איר מיך גארנישט מער פרעגן. באמת, באמת זאג איך אייך: וואס איר וועט נאר בעטן דעם פאטער וועט ער אייך געבן אין מיין נאמען. ");
INSERT INTO ydd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ביז אצונד האט איר גארנישט געבעטן אין מיין נאמען; בעט, און איר וועט באקומען, כדי אייער פרייד זאל ווערן פול. ");
INSERT INTO ydd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","די דאזיקע זאכן האב איך גערעדט צו אייך אין משלים; עס קומט אָן א שעה, ווען איך וועל מער נישט רעדן צו אייך אין משלים, נאר אייך אנזאגן אפן וועגן דעם פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","אין יענעם טאג וועט איר בעטן אין מיין נאמען; און איך זאג אייך נישט, אז איך וועל בעטן דעם פאטער פאר אייערטוועגן; ");
INSERT INTO ydd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ווארום דער פאטער אליין האט אייך ליב, ווייל איר האט מיך ליב, און גלויבט, אז איך בין ארויסגעקומען פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","איך בין ארויסגעקומען פון דעם פאטער, און בין געקומען אין דער וועלט אריין; ווידער פארלאז איך די וועלט, און גיי צו דעם פאטער. ");
INSERT INTO ydd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","זאגן זיינע תלמידים: זע, איצט רעדסטו אפן, און זאגסט נישט קיין משל. ");
INSERT INTO ydd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","איצט ווייסן מיר, אז דו ווייסט אלץ, און דארפסט נישט, אז עמיצער זאל דיך פרעגן; דורך דעם גלויבן מיר, אז דו ביסט ארויסגעקומען פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","האט יהושע/ישוע זיי געענטפערט: איצט גלויבט איר? ");
INSERT INTO ydd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","זע, עס קומט א שעה, און איז שוין אנגעקומען, אז איר זאלט צעשפרייט ווערן, יעדער איינער צו די זייניקע, און מיך וועט איר איבערלאזן איינעם אליין; און איך בין (דאך) נישט איינער אליין, ווייל דער פאטער איז מיט מיר. ");
INSERT INTO ydd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","דאס האב איך גערעדט צו אייך, כדי אין מיר זאלט איר האבן שלום. אין דער וועלט האט איר צרות; נאר זייט געטרייסט; איך האב מנצח געווען די וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","דאס האט יהושע/ישוע גערעדט; און אויפהויבנדיק זיינע אויגן צום הימל, האט ער געזאגט; פאטער, עס איז געקומען די שעה; פארהערלעך דיין זון, כדי דער זון זאל דיך פארהערלעכן; ");
INSERT INTO ydd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ווי דו האסט אים געגעבן מאכט איבער יעדן בשר (ודם), כדי ער זאל געבן אייביק לעבן צו אלעמען, וואס דו האסט אים געגעבן. ");
INSERT INTO ydd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","און דאס איז דאס אייביקע לעבן, אז זיי זאלן דיך קענען, דעם איינציק אמתן ג‑ט, און יהושע/ישוע המשיחן, וועמען דו האסט געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","איך האב דיך פארהערלעכט אויף דער ערד, איך האב פארענדיקט דאס ווערק, וואס דו האסט מיר געגעבן צו טאן. ");
INSERT INTO ydd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","און איצט, פאטער, פארהערלעך דו מיך, מיט דער הערלעכקייט, וואס איך האב געהאט ביי דיר, איידער די וועלט איז (באשאפן) געווארן. ");
INSERT INTO ydd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","איך האב אנטפלעקט דיין נאמען צו די מענטשן, וועלכע דו האסט מיר געגעבן אויס דער וועלט; דיין זענען זיי געווען, און דו האסט זיי מיר געגעבן; און זיי האבן געהאלטן דיין ווארט. ");
INSERT INTO ydd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","איצט ווייסן זיי, אז אלץ, וואס דו האסט מיר געגעבן, איז פון דיר; ");
INSERT INTO ydd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ווייל די ווערטער, וואס דו האסט מיר געגעבן, האב איך זיי געגעבן; און זיי האבן זיי אנגענומען, און באמת דערקענט, אז איך בין ארויסגעגאנגען פון דיר; און האבן געגלויבט, אז דו האסט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","איך בעט דיך פאר זייערטוועגן; איך בעט נישט פאר דער וועלט, נאר פאר די, וועלכע דו האסט מיר געגעבן, ווייל זיי זענען דיין; ");
INSERT INTO ydd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","און אלץ, וואס איז מיין, איז דיין, און דיינס איז מיין; און איך בין פארהערלעכט אין זיי. ");
INSERT INTO ydd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","און איך בין מער נישט אין דער וועלט, און זיי זענען אין דער וועלט, און איך קום צו דיר. הייליקער פאטער, באהיט זיי אין דיין נאמען, וואס דו האסט מיר געגעבן, כדי זיי זאלן זיין איינס, אזוי ווי מיר! ");
INSERT INTO ydd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","בשעת איך בין געווען מיט זיי, האב איך זיי באהיט אין דיין נאמען, וועלכן דו האסט מיר געגעבן; און האב געוואכט (איבער זיי), און קיינער פון זיי איז נישט פארלוירן געגאנגען, אחוץ דער בן האבדון (פארלוירענער זון), כדי דער פסוק זאל מקוים ווערן. ");
INSERT INTO ydd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","איצט אבער גיי איך צו דיר; און דאס זאג איך אין דער וועלט, כדי זיי זאלן האבן מיין פרייד שלמותדיק אין זיך. ");
INSERT INTO ydd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","איך האב זיי געגעבן דיין ווארט; און די וועלט האט זיי פיינט, ווייל זיי זענען נישט פון דער וועלט, פונקט ווי איך בין נישט פון דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","איך בעט נישט, אז דו זאלסט זיי ארויסנעמען אויס דער וועלט, נאר אז דו זאלסט זיי אפהיטן פון בייז. ");
INSERT INTO ydd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","זיי זענען נישט פון דער וועלט, פונקט ווי איך בין נישט פון דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","הייליק זיי אין דעם אמת; דיין ווארט איז אמת. ");
INSERT INTO ydd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ווי דו האסט מיך געשיקט אין דער וועלט אריין, אזוי האב איך זיי געשיקט אין דער וועלט אריין. ");
INSERT INTO ydd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","און פאר זייערטוועגן הייליק איך מיך, כדי זיי זאלן זיין געהייליקט אין דעם אמת. ");
INSERT INTO ydd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","און נישט נאר פאר די דאזיקע אליין בעט איך, נאר אויך פאר יענע, וואס וועלן גלויבן אין מיר דורך זייער ווארט, ");
INSERT INTO ydd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","כדי אלע זאלן זיין איינס; ווי דו, פאטער, אין מיר, און איך אין דיר, אז אויך זיי זאלן זיין אין אונדז; כדי די וועלט זאל גלויבן, אז דו האסט מיך געשיקט. ");
INSERT INTO ydd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","און דעם כבוד, וואס דו האסט מיר געגעבן, האב איך זיי געגעבן, כדי זיי זאלן זיין איינס פונקט ווי מיר זענען איינס. ");
INSERT INTO ydd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","איך אין זיי, און דו אין מיר, כדי זיי זאלן ווערן שלמותדיק אין איינעם, כדי די וועלט זאל וויסן, אז דו האסט מיך געשיקט, און האסט זיי ליב געהאט, פונקט אזוי ווי דו האסט מיך ליב געהאט. ");
INSERT INTO ydd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","פאטער, איך וויל, אז וואו איך בין, זאלן אויך זיין מיט מיר די, וועלכע דו האסט מיר געגעבן, כדי זיי זאלן זען מיין כבוד, וואס דו האסט מיר געגעבן; ווייל דו האסט מיך ליב געהאט פון פאר דער גרינדונג פון דער וועלט. ");
INSERT INTO ydd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","גערעכטער פאטער, די וועלט האט דיך נישט געקענט, איך אבער האב דיך יא געקענט; און די דאזיקע ווייסן, אז דו האסט מיך געשיקט; ");
INSERT INTO ydd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","און איך האב צו זיי באקאנט געמאכט דיין נאמען, און וועל אים באקאנט מאכן, כדי די ליבע, מיט וועלכער דו האסט מיך ליב געהאט, זאל זיין אין זיי, און איך אין זיי. ");
INSERT INTO ydd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","האבנדיק דאס געזאגט, איז יהושע/ישוע ארויסגעגאנגען צוזאמען מיט זיינע תלמידים איבער דעם טייך קדרון, וואו עס איז געווען א גארטן, אין וועלכן ער איז אריינגעגאנגען מיט זיינע תלמידים. ");
INSERT INTO ydd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","און אויך יהודה, וואס האט אים פארראטן, האט געקענט דאס ארט, ווייל א סך מאל איז יהושע/ישוע זיך דארטן צוזאמענגעקומען מיט די תלמידים זיינע. ");
INSERT INTO ydd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","און יהודה האט באקומען די אפטיילונג (סאלדאטן) און משרתים פון די הויפט כהנים און פרושים, און איז אהינגעקומען מיט פאקלען און לאמפן און כלי זין. ");
INSERT INTO ydd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","און יהושע/ישוע האט געוואוסט אלץ, וואס וועט קומען אויף אים; און איז ארויסגעגאנגען און האט צו זיי געזאגט: וועמען זוכט איר? ");
INSERT INTO ydd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","האבן זיי אים געענטפערט: יהושען/ישוען פון נצרת! זאגט ער צו זיי: איך בין עס! און יהודה, וואס האט אים פארראטן, איז געשטאנען מיט זיי. ");
INSERT INTO ydd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","און ווי יהושע/ישוע האט צו זיי געזאגט: איך בין עס! זענען זיי געגאנגען הינטערוויילעכס און זענען אנידערגעפאלן צו דער ערד. ");
INSERT INTO ydd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","און ער האט זיי ווידער געפרעגט: וועמען זוכט איר? און זיי האבן געזאגט: יהושען/ישוען פון נצרת! ");
INSERT INTO ydd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","האט יהושע/ישוע געענטפערט: איך האב דאך אייך געזאגט, אז איך בין עס! און אויב איר זוכט מיך, לאזט די דאזיקע גיין; ");
INSERT INTO ydd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","כדי עס זאל מקוים ווערן דאס ווארט, וואס ער האט געזאגט: די, וואס דו האסט מיר געגעבן, פון זיי האב איך קיין איינעם נישט פארלוירן. ");
INSERT INTO ydd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","און שמעון פעטרוס, האבנדיק א שווערד, האט זי ארויסגעצויגן, און געשלאגן דעם כהן גדולס קנעכט און אים אפגעהאקט דאס רעכטע אויער. און דער קנעכט האט געהייסן מלכוס. ");
INSERT INTO ydd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","יהושע/ישוע האט דעריבער געזאגט צו פעטרוסן: לייג אריין די שווערד אין דער שייד. דעם בעכער, וואס דער פאטער האט מיר געגעבן, זאל איך אים דען נישט טרינקען? ");
INSERT INTO ydd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","און די אפטיילונג (סאלדאטן) מיט דעם אפיציר און די משרתים פון די יידן האבן געכאפט יהושען/ישוען און אים געבונדן (עקידה), ");
INSERT INTO ydd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","און אים קודם כל אוועקגעפירט צו חנן; ווארום ער איז געווען דער שווער פון קיפא, וועלכער איז געווען כהן גדול אין יענעם יאר. ");
INSERT INTO ydd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","און עס איז געווען קיפא, וואס האט געראטן די יידן, אז עס איז גוט איין מענטש זאל שטארבן פאר דעם פאלק. ");
INSERT INTO ydd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","און שמעון פעטרוס און אן אנדערער תלמיד האבן נאכגעפאלגט יהושען/ישוען. און יענער תלמיד איז געווען באקאנט מיט דעם כהן גדול, און ער איז אריינגעגאנגען מיט יהושען/ישוען אין הויף פון דעם כהן גדול. ");
INSERT INTO ydd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","פעטרוס אבער איז געשטאנען ביי דער טיר אינדרויסן. דער אנדערער תלמיד, וואס איז געווען באקאנט מיט דעם כהן גדול, איז דעריבער ארויסגעגאנגען און האט גערעדט מיט דער טיר וועכטערין, און אריינגעפירט פעטרוסן. ");
INSERT INTO ydd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","און די שיפחה, די טיר וועכטערין, האט געזאגט צו פעטרוסן: צי ביסטו דען נישט אויך פון די תלמידים פון דעם דאזיקן מענטש? זאגט ער: איך בין נישט. ");
INSERT INTO ydd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","און די קנעכט און די משרתים זענען געשטאנען און האבן זיך געווארעמט ביי א פייער, וואס זיי האבן געמאכט פון האלצקוילן, ווייל עס איז געווען קאלט; און פעטרוס איז אויך געווען מיט זיי, שטייענדיק און ווארעמענדיק זיך. ");
INSERT INTO ydd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","און דער כהן גדול האט אויסגעפרעגט יהושען/ישוען וועגן זיינע תלמידים און וועגן זיין לערנונג. ");
INSERT INTO ydd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","האט יהושע/ישוע אים געענטפערט: איך האב גערעדט בפרהסיא אין דער וועלט; איך האב תמיד געלערנט אין שול און אינם בית המקדש, וואו אלע יידן קומען זיך צונויף, און אין פארבארגעניש האב איך גארנישט גערעדט. ");
INSERT INTO ydd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","וואס פרעגסטו מיך? פרעג די צוהערער וואס איך האב צו זיי גערעדט; זע, זיי ווייסן, וואס איך האב געזאגט. ");
INSERT INTO ydd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","און בשעת ער האט אזוי גערעדט, האט איינער פון די משרתים, וואס זענען דארט געשטאנען, געגעבן יהושען/ישוען א פאטש, זאגנדיק: אָט אזוי ענטפערסטו דעם כהן גדול? ");
INSERT INTO ydd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","האט יהושע/ישוע אים געענטפערט: אויב איך האב שלעכט גערעדט, זאג עדות וועגן דעם שלעכטן; אויב אבער (איך האב גערעדט) גוט, וואס שלאגסטו מיך? ");
INSERT INTO ydd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","און חנן האט אים אוועקגעשיקט א געבונדענעם (עקידה) צו קיפא דעם כהן גדול. ");
INSERT INTO ydd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","שמעון פעטרוס אבער איז געשטאנען און זיך געווארעמט. און מען האט צו אים געזאגט: צי ביסטו דען נישט אויך פון זיינע תלמידים? האט ער געלייקנט און געזאגט: איך בין נישט! ");
INSERT INTO ydd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","זאגט צו אים איינער פון דעם כהן גדולס קנעכט, וואס איז געווען א קרוב פון דעם, וועמען פעטרוס האט אפגעהאקט דאס אויער: צי האב איך דיך דען נישט געזען אינם גארטן מיט אים? ");
INSERT INTO ydd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","פעטרוס האט דעריבער ווידער געלייקנט; און גלייך האט א האן געקרייעט. ");
INSERT INTO ydd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","דאן האט מען יהושען/ישוען אוועקגעפירט פון קיפא צום פרעטאריום; און עס איז געווען פרי; און זיי זענען נישט אריינגעגאנגען אין פרעטאריום, כדי זיי זאלן זיך נישט מטמא זיין, נאר זאלן (קענען) עסן דאס קרבן פסח. ");
INSERT INTO ydd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","פילאטוס איז דעריבער ארויסגעגאנגען צו זיי אינדרויסן, און געזאגט; וואס פאר א באשולדיקונג ברענגט איר קעגן דעם דאזיקן מענטשן? ");
INSERT INTO ydd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","האבן זיי געענטפערט און געזאגט צו אים: אויב דער דאזיקער וואלט נישט געווען טאן קיין בייז, וואלטן מיר אים נישט איבערגעגעבן צו דיר. ");
INSERT INTO ydd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","פילאטוס האט דעריבער צו זיי געזאגט: נעמט איר אים, און משפט אים לויט אייער תורה. האבן די יידן צו אים געזאגט: מיר האבן נישט קיין רשות עמיצן צו טייטן; ");
INSERT INTO ydd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","כדי עס זאל דערפילט ווערן ישועס ווארט, וואס ער האט געזאגט, מרמז זייענדיק, מיט וועלכן טויט ער גייט שטארבן. ");
INSERT INTO ydd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","פילאטוס איז צוריק אריינגעגאנגען אין פרעטאריום אריין, און האט גערופן יהושען/ישוען, און געזאגט צו אים: צי ביסט דו דער מלך פון די יידן? ");
INSERT INTO ydd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","האט יהושע/ישוע געענטפערט: זאגסטו דאס דאזיקע פון דיר אליין, אדער האבן אנדערע עס דיר געזאגט וועגן מיר? ");
INSERT INTO ydd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","פילאטוס האט געענטפערט: בין איך דען א ייד? דאס פאלק דיינס און די הויפט כהנים האבן דאך דיך איבערגעגעבן צו מיר; וואס האסטו געטאן? ");
INSERT INTO ydd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","האט יהושע/ישוע געענטפערט: מיין מלכות איז נישט פון דער דאזיקער וועלט; אויב מיין מלכות וואלט יא געווען פון דער דאזיקער וועלט, וואלטן מיינע משרתים געקעמפט, כדי איך זאל נישט איבערגעגעבן ווערן צו די יידן; איצט אבער איז מיין מלכות נישט פונדאנען. ");
INSERT INTO ydd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","פילאטוס האט דעריבער צו אים געזאגט: אויב אזוי ביסטו טאקע א מלך? האט יהושע/ישוע געענטפערט: דו זאגסט עס, אז איך בין א מלך. דערצו בין איך געבוירן געווארן און דערצו בין איך געקומען אין דער וועלט אריין, כדי איך זאל עדות זאגן אויף דעם אמת. יעדער איינער, וואס איז פון דעם אמת, הערט מיין קול. ");
INSERT INTO ydd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","זאגט פילאטוס צו אים: וואס איז אמת? און האבנדיק דאס געזאגט, איז ער ווידער ארויסגעגאנגען צו די יידן, און זאגט צו זיי: איך געפין נישט קיין שום שולד אין אים! ");
INSERT INTO ydd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","עס איז אבער א מנהג ביי אייך, אז איך זאל אייך אפלאזן איינעם אויף פסח; צי ווילט איר איך זאל אייך אפלאזן דעם מלך פון די יידן? ");
INSERT INTO ydd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","און זיי האבן ווידער א געשריי געטאן, אזוי צו זאגן: נישט דעם דאזיקן, נאר בר‑אבאן! און דער בר‑אבא איז געווען א בונטאר. ");
INSERT INTO ydd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","דעמאלט האט פילאטוס גענומען יהושען/ישוען און אים געלאזט שמייסן. ");
INSERT INTO ydd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","און די זעלנער האבן געפלאכטן א קרוין פון דערנער, און זי ארויפגעזעצט אויף זיין קאפ, און האבן אים אנגעטאן א פורפור מלבוש. ");
INSERT INTO ydd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","און זענען געקומען צו אים און געזאגט: שלום דיר, מלך פון די יידן! און האבן אים געגעבן פאטש. ");
INSERT INTO ydd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","און פילאטוס איז ווידער ארויסגעגאנגען אינדרויסן און האט צו זיי געזאגט: זע, איך פיר אים ארויס צו אייך, כדי איר זאלט וויסן, אז איך געפין נישט קיין שום שולד אין אים. ");
INSERT INTO ydd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","און יהושע/ישוע איז ארויסגעקומען אינדרויסן, טראגנדיק די דערנער קרוין און דאס פורפור מלבוש. און ער (פילאטוס) זאגט צו זיי: זע, דער מענטש! ");
INSERT INTO ydd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ווען די הויפט כהנים און זייערע משרתים האבן אים געזען, האבן זיי א געשריי געטאן, אזוי צו זאגן: אויפהענגען אויף דער בוים אים! אויפהענגען אויף דער בוים אים! (שמואל ב יח, ט-יד.) זאגט פילאטוס צו זיי: נעמט איר און אויפהענגען אויף דער בוים אים, ווארום איך געפין נישט אין אים קיין שולד. ");
INSERT INTO ydd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","האבן די יידן אים געענטפערט: מיר האבן א תורה, און לויט דער תורה איז ער חייב מיתה, ווייל ער האט זיך געמאכט פאר ה׳ס זון. ");
INSERT INTO ydd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","און ווען פילאטוס האט געהערט דאס א דאזיקע ווארט, האט ער זיך נאך מער געפארכטן; ");
INSERT INTO ydd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","און איז ווידער אריינגעגאנגען אינם פרעטאריום און האט געזאגט צו יהושען/ישוען: פונוואנען ביסטו? יהושע/ישוע אבער האט אים נישט געגעבן קיין ענטפער. ");
INSERT INTO ydd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","פילאטוס זאגט דעריבער צו אים: צו מיר רעדסטו נישט? ווייסטו דען נישט, אז איך האב מאכט דיך צו באפרייען, און האב מאכט דיך צו אויפהענגען אויף דער בוים? ");
INSERT INTO ydd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","האט יהושע/ישוע געענטפערט: דו וואלסט נישט געהאט קיין שום מאכט קעגן מיר, אויב עס וואלט דיר נישט געגעבן געווארן פון אויבן; דערפאר האט א גרעסערע זינד דער, וואס האט מיך איבערגעגעבן צו דיר. ");
INSERT INTO ydd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","פון דעמאלט אָן האט פילאטוס געזוכט אים צו באפרייען; די יידן אבער האבן געשריגן, אזוי צו זאגן: אויב דו באפרייסט דעם דאזיקן, ביסטו נישט דעם קיסרס פריינד; (ווארום) יעדער איינער, וואס מאכט זיך פאר א מלך, ווידערשפעניקט קעגן קיסר. ");
INSERT INTO ydd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ווען זשע פילאטוס האט געהערט די דאזיקע ווערטער, האט ער ארויסגעפירט יהושען/ישוען, און זיך אנידערגעזעצט אויף דער טריבונאל שטול, אויף דעם ארט, וואס הייסט ליטאסטראטאס, און אויף לשון קודש גבתא (אויספלאסטערונג). ");
INSERT INTO ydd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","און עס איז געווען ערב פסח, ארום דער זעקסטער שעה. און ער האט געזאגט צו די יידן: זע, אייער מלך! ");
INSERT INTO ydd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","און זיי האבן א געשריי געטאן: אוועק, אוועק! אויפהענגען אויף דער בוים אים! זאגט פילאטוס צו זיי: דעם מלך אייערן זאל איך אויפהענגען אויף דער בוים אים? האבן די הויפט כהנים געענטפערט: מיר האבן נישט קיין מלך אחוץ דעם קיסר! ");
INSERT INTO ydd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","האט ער דעמאלט אים איבערגעגעבן צו זיי, אז ער זאל אויפהענגען אויף א בוים ווערן. זיי האבן דעריבער גענומען יהושען/ישוען; ");
INSERT INTO ydd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","און טראגנדיק אליין זיין בוים, איז ער ארויסגעגאנגען צו אן ארט, וואס הייסט דאס ארט פון א שארבן, אויף לשון קודש הייסט עס גלגלתא; ");
INSERT INTO ydd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","וואו זיי האבן אים אויפהענגען אויף דער בוים, און מיט אים אנדערע צוויי, אויף ביידע זייטן, און יהושען/ישוען אין דער מיט. ");
INSERT INTO ydd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","און פילאטוס האט אויך געשריבן א טיטל און אים ארויפגעזעצט אויפן בוים. און עס איז געווען געשריבן: יהושע/ישוע פון נצרת מלך היהודים. ");
INSERT INTO ydd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","און א סך פון די יידן האבן געלייענט דעם דאזיקן טיטל, ווייל דאס ארט, וואו יהושע/ישוע איז אויפגעהאנגען אויף דער בוים געווארן, איז געווען נאענט צו דער שטאט; און עס איז געווען געשריבן אויף לשון קודש, לאטייניש און גריכיש. ");
INSERT INTO ydd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","און די הויפט כהנים פון די יידן האבן געזאגט צו פילאטוסן: שרייב נישט: דער מלך פון די יידן; נאר אז ער האט געזאגט: איך בין דער מלך פון די יידן. ");
INSERT INTO ydd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","האט פילאטוס געענטפערט: וואס איך האב געשריבן, האב איך געשריבן! ");
INSERT INTO ydd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","און די זעלנער, ווען זיי האבן אויפגעהאנגען אויף דער בוים יהושען/ישוען, האבן גענומען זיינע מלבושים, און געמאכט פיר חלקים, פאר יעדן זעלנער א חלק, און אויך דאס אויבערמלבוש. און דאס אויבערמלבוש איז נישט געווען גענייט, נאר אינגאנצן געוועבט פון אויבן (ביז אראפ). ");
INSERT INTO ydd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","זיי האבן דעריבער געזאגט איינער צום אנדערן: לאמיר עס נישט צערייסן, נאר ווארפן גורל וועגן דעם, וועמעס עס זאל זיין; כדי דער פסוק זאל מקוים ווערן: זיי האבן צעטיילט מיינע קליידער צווישן זיך, און אויף מיין לבוש האבן זיי געווארפן גורל. (תהלים כב, יט.) און די דאזיקע זאכן האבן די זעלנער געטאן. ");
INSERT INTO ydd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","און ביים בוים פון יהושען/ישוען זענען געשטאנען זיין מוטער און זיין מוטערס שוועסטער, מרים דאס ווייב פון קלאפאס (לוקאס כד, יח.), און מרים פון מגדלה. ");
INSERT INTO ydd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","און ווען יהושע/ישוע האט געזען זיין מוטער און דעם תלמיד, וועלכן ער האט ליב געהאט, שטיין דערנעבן, זאגט ער צו דער מוטער: אשה, זע, דיין זון! ");
INSERT INTO ydd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","דערנאך זאגט ער צו דעם תלמיד: זע, דיין מוטער! און פון יענער שעה האט יענער תלמיד זי גענומען צו זיך. ");
INSERT INTO ydd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","נאך דעם, אזויווי יהושע/ישוע האט געוואוסט, אז אלץ האט זיך שוין געענדיקט, כדי דער פסוק זאל מקוים ווערן, זאגט ער: איך בין דארשטיק! ");
INSERT INTO ydd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","דארט איז געשטאנען א געפעס פול מיט עסיק. און זיי האבן ארויפגעלייגט אויף אן היזאפ שטענגל א שוואם אנגעפילט מיט עסיק און אים דערלאנגט צום מויל. ");
INSERT INTO ydd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","און ווען יהושע/ישוע האט גענומען דעם עסיק, האט ער געזאגט: עס איז געענדיקט, און האט גענייגט דעם קאפ און אויפגעגעבן די נשמה. ");
INSERT INTO ydd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","און ווייל עס איז געווען ערב שבת, כדי די גופים זאלן נישט בלייבן דעם שבת אויפן בוים—ווארום יענער שבת איז געווען שבת הגדול—האבן די יידן געבעטן פילאטוסן, אז מען זאל צעברעכן די ביינער פון די גופים, און זיי אראפנעמען. ");
INSERT INTO ydd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","זענען געקומען די זעלנער און האבן דעם ערשטן צעבראכן די ביינער און דעם אנדערן, וואס איז אויפגעהאנגען געווארן מיט אים אויף דער בוים. ");
INSERT INTO ydd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","קומענדיק אבער צו יהושען/ישוען, ווי זיי האבן געזען, אז ער איז שוין געשטארבן, האבן זיי אים נישט צעבראכן די ביינער. ");
INSERT INTO ydd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","נאר איינער פון די זעלנער האט אים דורכגעשטאכן די זייט מיט א שפיז; און גלייך איז ארויסגעקומען בלוט און וואסער. ");
INSERT INTO ydd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","און דער, וואס האט עס געזען, האט עדות געזאגט, און זיין עדות זאגן איז וואר; און ער ווייסט, אז ער זאגט דעם אמת, כדי אויך איר זאלט גלויבן. ");
INSERT INTO ydd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ווארום דאס איז געשען, כדי דער פסוק זאל דערפילט ווערן: קיין ביין זאלט איר אים נישט צעברעכן. ");
INSERT INTO ydd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","און ווידער אן אנדערער פסוק זאגט: זיי וועלן קוקן אויף אים, וועמען זיי האבן דורכגעשטאכן. ");
INSERT INTO ydd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","און נאך דעם האט יוסף הרמתי, וועלכער איז געווען א פארבארגענער תלמיד פון יהושען/ישוען, אויס מורא פאר די יידן, געבעטן פילאטוסן, אז ער זאל מעגן אוועקנעמען ישועס גוף; און פילאטוס האט עס דערלויבט. ער איז דעריבער געקומען און האט אוועקגענומען זיין גוף. ");
INSERT INTO ydd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","און נקדימון איז אויך געקומען, (דער, וואס איז דאס ערשטע מאל געקומען צו יהושען/ישוען ביינאכט) ברענגענדיק צו טראגן א געמישטע זאלב פון מירע און אלאע, אן ערך הונדערט פונט. ");
INSERT INTO ydd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","און זיי האבן גענומען ישועס גוף און אים איינגעוויקלט אין תכריכים מיט די געווירצן לויט דעם מנהג ביי יידן מקבר צו זיין. ");
INSERT INTO ydd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","און אויף דעם ארט, וואו ער איז אויפגעהאנגען אויף דער בוים געווארן, איז געווען א גארטן, און אין דעם גארטן א ניי קבר, אין וועלכן עס איז נאך קיינמאל קיינער נישט געלייגט געווארן. ");
INSERT INTO ydd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","און דארטן—צוליב דעם ערב שבת ביי יידן, ווייל דאס קבר איז געווען נאענט—האבן זיי געלייגט יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","און דעם ערשטן טאג פון דער וואך אינדערפרי, בשעת עס איז נאך געווען פינסטער, קומט מרים פון מגדלה צום קבר, און זעט דעם שטיין אוועקגענומען פון קבר. ");
INSERT INTO ydd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","לויפט זי דעריבער און קומט צו שמעון פעטרוסן און צום אנדערן תלמיד, וועמען יהושע/ישוע האט ליב געהאט, און זאגט צו זיי: מען האט אוועקגענומען דעם האר פון דעם קבר ארויס, און מיר ווייסן נישט, וואו מען האט אים געלייגט. ");
INSERT INTO ydd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","און פעטרוס איז ארויסגעגאנגען און דער אנדערער תלמיד, און זענען אוועק צום קבר. ");
INSERT INTO ydd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","און ביידע זענען געלאפן צוזאמען; און דער אנדערער תלמיד איז געלאפן פארויס, גיכער ווי פעטרוס און איז דער ערשטער אנגעקומען צום קבר. ");
INSERT INTO ydd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","און איינבייגנדיק זיך, האט ער געזען די תכריכים ליגן; ער איז אבער נישט אריינגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","דאן קומט אויך שמעון פעטרוס, נאכפאלגנדיק אים, און איז אריינגעגאנגען אין קבר אריין; און זעט די תכריכים ליגן, ");
INSERT INTO ydd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","און דאס טיכל (מצנפת), וואס איז געווען אויף זיין קאפ, איז נישט געלעגן צוזאמען מיט די תכריכים, נאר באזונדער צונויפגעוויקלט אויף איין ארט. ");
INSERT INTO ydd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","און דעמאלט איז אויך דער אנדערער תלמיד אריינגעגאנגען, ער, וואס איז געקומען דער ערשטער צום קבר, און האט געזען און געגלויבט. ");
INSERT INTO ydd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ווארום זיי האבן נאך נישט פארשטאנען די שריפט, אז ער מוז אויפשטיין פון די טויטע. ");
INSERT INTO ydd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","און די תלמידים זענען ווידער אוועק צו זיך אהיים. ");
INSERT INTO ydd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","מרים אבער איז געשטאנען אינדרויסן ביים קבר וויינענדיק; און בשעת זי האט געוויינט, האט זי זיך אראפגעבויגן צום קבר, ");
INSERT INTO ydd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","און זעט צוויי מלאכים אין ווייסן זיצן, איינעם צוקאפנס און איינעם צופוסנס, וואו ישועס גוף איז געלעגן. ");
INSERT INTO ydd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","און יענע זאגן צו איר: אשה, וואס וויינסטו? זאגט זי צו זיי: ווייל מען האט אוועקגענומען דעם האר מיינעם, און איך ווייס נישט, וואו מען האט אים געלייגט. ");
INSERT INTO ydd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","דאס זאגנדיק, האט זי זיך אויסגעדרייט הינטער זיך, און זעט יהושען/ישוען שטיין, און האט נישט געוואוסט, אז עס איז יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","זאגט יהושע/ישוע צו איר: אשה, וואס וויינסטו? וועמען זוכסטו? און מיינענדיק, אז ער איז דער גערטנער, זאגט זי צו אים: האר, אויב דו האסט אים אוועקגעטראגן, זאג מיר, וואו דו האסט אים געלייגט, און איך וועל אים אוועקנעמען. ");
INSERT INTO ydd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","זאגט יהושע/ישוע צו איר: מרים! זי האט זיך אויסגעדרייט און זאגט צו אים: אויף לשון קודש: רבוני! (דאס הייסט לערער!) ");
INSERT INTO ydd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","זאגט יהושע/ישוע צו איר: ריר מיך נישט אָן: ווארום איך בין נאך נישט ארויפגעגאנגען צום פאטער; נאר גיי צו מיינע ברידער און זאג זיי, איך גיי ארויף צו מיין פאטער און אייער פאטער, און צו מיין ג‑ט און אייער ג‑ט. ");
INSERT INTO ydd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","קומט מרים פון מגדלה און דערציילט די תלמידים, אז זי האט געזען דעם האר, און דאס האט ער איר געזאגט. ");
INSERT INTO ydd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","און אין יענעם טאג אין אוונט, דעם ערשטן פון דער וואך, בשעת די טירן זענען געווען פארשלאסן, וואו די תלמידים האבן זיך געפונען, אויס מורא פאר די יידן, איז יהושע/ישוע געקומען און האט זיך געשטעלט אין דער מיט, און זאגט צו זיי: שלום עליכם! ");
INSERT INTO ydd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","און ווען ער האט דאס געזאגט, האט ער זיי געוויזן די הענט און די זייט. און די תלמידים האבן זיך געפריידט, זעענדיק דעם האר. ");
INSERT INTO ydd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","און יהושע/ישוע האט ווידער צו זיי געזאגט: שלום עליכם! ווי דער פאטער האט מיך געשיקט, אזוי שיק איך אייך. ");
INSERT INTO ydd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","און דאס זאגנדיק, האט ער אויף זיי געאטעמט, און זאגט צו זיי; זייט מקבל דעם רוח הקודש! ");
INSERT INTO ydd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","וועמען איר וועט מוחל זיין די זינד, וועט עס זיי זיין פארגעבן געווארן; וועמען איר וועט צוריקהאלטן, וועלן זיי זיין צוריקגעהאלטן. ");
INSERT INTO ydd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","אבער תומא, איינער פון די צוועלף, וועמען מען האט גערופן דידומאס, איז נישט געווען צוזאמען מיט זיי, ווען יהושע/ישוע איז געקומען. ");
INSERT INTO ydd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","האבן די אנדערע תלמידים דעריבער געזאגט צו אים: מיר האבן געזען דעם האר! ער אבער האט צו זיי געזאגט: אויב איך וועל נישט זען דעם צייכן פון די נעגל אין זיינע הענט, און אריינשטעקן מיין פינגער אויף דעם ארט פון די נעגל, און אריינטאן מיין האנט אין זיין זייט, וועל איך בשום אופן נישט גלויבן! ");
INSERT INTO ydd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","און אין אכט טעג ארום זענען זיינע תלמידים ווידער געווען אינעווייניק (אינם הויז), און תומא איז געווען מיט זיי. קומט יהושע/ישוע, בשעת די טירן זענען געווען פארשלאסן, און האט זיך געשטעלט אין דער מיט און געזאגט: שלום עליכם! ");
INSERT INTO ydd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","דאן זאגט ער צו תומא: שטרעק אויס דיין פינגער אהער און זע מיינע הענט; און שטרעק אויס דיין האנט און טו זי אריין אין מיין זייט, און זיי נישט אומגלויביק, נאר זיי א מאמין! ");
INSERT INTO ydd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","האט תומא געענטפערט און געזאגט צו אים: מיין האר און מיין ג‑ט! ");
INSERT INTO ydd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","זאגט יהושע/ישוע צו אים: ווייל דו האסט מיך געזען, גלויבסטו? וואויל איז די, וואס האבן נישט געזען און גלויבן דאך! ");
INSERT INTO ydd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","און נאך א סך אנדערע נסים האט יהושע/ישוע געטאן פאר זיינע תלמידים, וואס שטייען נישט געשריבן אין דעם דאזיקן ספר. ");
INSERT INTO ydd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","און די דאזיקע זענען געשריבן געווארן, כדי איר זאלט גלויבן, אז יהושע/ישוע איז דער משיח, דער זון פון דער אויבערשטער, און אז גלויבנדיק, זאלט איר האבן לעבן אין זיין נאמען. ");
INSERT INTO ydd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","נאך דעם האט יהושע/ישוע זיך ווידער באוויזן צו די תלמידים ביים ים פון טבריה; און האט זיך באוויזן אויף אזא אופן: ");
INSERT INTO ydd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","עס זענען געווען צוזאמען שמעון פעטרוס און תומא, וואס מען האט אים גערופן דידומאס, און נתנאל פון קנה אין גליל, און זבדיס זין, און אנדערע צוויי פון זיינע תלמידים. ");
INSERT INTO ydd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","זאגט שמעון פעטרוס צו זיי: איך גיי פאנגען פיש! זאגן זיי צו אים: מיר וועלן אויך קומען מיט דיר. און זיי זענען ארויסגעגאנגען, און זענען איינגעשטיגן אינם שיפל; און אין יענער נאכט האבן זיי גארנישט געכאפט. ");
INSERT INTO ydd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","און ווען עס איז שוין געווען אינדערפרי, איז יהושע/ישוע געשטאנען ביים ברעג; דאך האבן די תלמידים נישט געוואוסט, אז עס איז יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","און יהושע/ישוע זאגט צו זיי: קינדער, צי האט איר נישט עפעס (פאנגען פיש) צו עסן? האבן זיי אים געענטפערט: ניין! ");
INSERT INTO ydd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ער אבער האט צו זיי געזאגט: ווארפט אריין די נעץ אויף דער רעכטער זייט פונם שיפל, און איר וועט געפינען. און זיי האבן אריינגעווארפן און האבן זי מער נישט געקענט ארויסציען, צוליב דער מאסע פיש. ");
INSERT INTO ydd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","זאגט יענער תלמיד, וועלכן יהושע/ישוע האט ליב געהאט, צו פעטרוסן: עס איז דער האר! און ווי שמעון פעטרוס האט געהערט, אז עס איז דער האר, האט ער זיך אנגעגורט זיין אויבערמלבוש—ווארום ער איז געווען נאקעט—און האט זיך אריינגעווארפן אין ים אריין. ");
INSERT INTO ydd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","די אנדערע תלמידים אבער זענען געקומען אינם שיפל, ווארום זיי זענען נישט געווען ווייט פון דער יבשה, נאר אן ערך צוויי הונדערט איילן, שלעפנדיק די נעץ מיט פיש. ");
INSERT INTO ydd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","און ווען זיי זענען ארויסגעשטיגן אויפן לאנד, זען זיי א פייער פון קוילן אנגעלייגט און א פיש ליגן דערויף און ברויט. ");
INSERT INTO ydd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","זאגט יהושע/ישוע צו זיי: ברענגט אהער פון די פיש, וואס איר האט איצט געכאפט. ");
INSERT INTO ydd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","איז שמעון פעטרוס איינגעשטיגן און האט ארויסגעצויגן די נעץ אויף דער יבשה, פול מיט גרויסע פיש, הונדערט דריי און פיפציק, און הגם עס איז געווען אזויפיל, האט זיך די נעץ דאך נישט צעריסן. ");
INSERT INTO ydd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","זאגט יהושע/ישוע צו זיי: קומט, עסט אנבייסן! און קיינער פון די תלמידים האט זיך נישט אונטערגעשטעלט אים צו פרעגן: ווער ביסטו? ווייל זיי האבן געוואוסט, אז עס איז דער האר. ");
INSERT INTO ydd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","קומט יהושע/ישוע און נעמט דאס ברויט און גיט עס זיי, און אויך אזוי דעם פיש. ");
INSERT INTO ydd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","דאס דאזיקע איז שוין דאס דריטע מאל ווי יהושע/ישוע האט זיך באוויזן צו די תלמידים, נאך דעם ווי ער איז אויפגעשטאנען פון די טויטע. ");
INSERT INTO ydd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","און ווען זיי האבן אפגעגעסן אנבייסן, זאגט יהושע/ישוע צו שמעון פעטרוסן: שמעון בן יונה, צי האסטו מיך ליב מער ווי די דאזיקע? זאגט ער צו אים: יא, האר, דו ווייסט, אז איך האב דיך ליב. זאגט ער צו אים: פאשע מיינע לעמער. ");
INSERT INTO ydd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ווידער צום צווייטן מאל זאגט ער צו אים: שמעון בן יונה, צי האסטו מיך ליב? זאגט ער צו אים: יא, האר, דו ווייסט, אז איך האב דיך ליב. זאגט ער צו אים: פאשע מיינע שאף. ");
INSERT INTO ydd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","צום דריטן מאל זאגט ער צו אים: שמעון בן יונה, צי האסטו מיך ליב? איז פעטרוס טרויעריק געווארן, ווייל ער האט צו אים געזאגט צום דריטן מאל: צי האסטו מיך ליב? און ער האט צו אים געזאגט: האר, דו ווייסט אלץ; דו ווייסט, אז איך האב דיך ליב. זאגט יהושע/ישוע צו אים: פאשע מיינע שעפעלעך. ");
INSERT INTO ydd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","באמת, באמת זאג איך דיר: ווען דו ביסט געווען יונג, האסטו דיך ארומגעגארטלט און ביסט געגאנגען, וואו דו האסט געוואלט; אבער ווען דו וועסט אלט ווערן, וועסטו אויסשטרעקן דיינע הענט, און אן אנדערער וועט דיך ארומגארטלען און פירן, וואואהין דו וועסט נישט וועלן. ");
INSERT INTO ydd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","און דאס דאזיקע האט ער געזאגט, מרמז זייענדיק, מיט וואס פאר א טויט ער וועט פארהערלעכן ה׳. און נאך דעם ווי ער האט דאס געזאגט, זאגט ער צו אים: פאלג מיר נאך! ");
INSERT INTO ydd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","אויסדרייענדיק זיך, זעט פעטרוס דעם תלמיד נאכפאלגן, וועלכן יהושע/ישוע האט ליב געהאט און וועלכער האט זיך אויך אנגעלענט אויף ישועס ברוסט ביי דער סעודה, און האט געזאגט: האר, ווער איז עס, וואס פארראט דיך? ");
INSERT INTO ydd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","און ווען פעטרוס האט אים דערזען, זאגט ער צו יהושען/ישוען: האר, און וואס וועגן דעם דאזיקן? ");
INSERT INTO ydd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","זאגט יהושע/ישוע צו אים: אויב איך וויל ער זאל בלייבן, ביז איך קום, וואס גייט דאס דיך אָן? דו פאלג מיר נאך. ");
INSERT INTO ydd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","און דאס דאזיקע ווארט איז ארויסגעגאנגען צווישן די ברידער, אז יענער תלמיד וועט נישט שטארבן; יהושע/ישוע אבער האט נישט געזאגט צו אים, אז ער וועט נישט שטארבן, נאר: אויב איך וויל, אז ער זאל בלייבן ביז איך קום, וואס גייט דאס דיך אָן? ");
INSERT INTO ydd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","דאס איז דער תלמיד, וואס זאגט עדות וועגן די דאזיקע זאכן, און האט זיי געשריבן; און מיר ווייסן, אז זיין עדות זאגן איז אמת. ");
INSERT INTO ydd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","עס זענען אבער פאראן נאך א סך אנדערע זאכן, וואס יהושע/ישוע האט געטאן, וועלכע, אויב זיי זאלן באשריבן ווערן, איינע נאך דער אנדערער, בין איך מיך משער, אז אין דער וועלט וואלט נישט געווען גענוג ארט פאר די ספרים, וואס וואלטן אנגעשריבן געווארן.");
INSERT INTO ydd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","דעם ערשטן באריכט האב איך געמאכט, אָ טעאפילוס, וועגן אלעם, וואס יהושע/ישוע האט אנגעהויבן צו טאן און צו לערנען, ");
INSERT INTO ydd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ביז צום טאג, ווען ער איז ארויפגענומען געווארן, נאך דעם ווי ער האט דורך דעם רוח הקודש געבאטן די שליחים, וועלכע ער האט אויסדערוויילט; ");
INSERT INTO ydd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","צו וועמען נאך זיין ליידן ער האט זיך באוויזן לעבעדיק דורך א סך זיכערע באווייזן, דערשיינענדיק צו זיי במשך פון פערציק טעג און רעדנדיק וועגן דעם, וואס האט א שייכות צום קעניגרייך פון ה׳; ");
INSERT INTO ydd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","און ווען זיי זענען געווען פארזאמלט, האט ער זיי באפוילן נישט אוועקצוגיין פון ירושלים, נאר צו ווארטן אויף דער הבטחה פונם פאטער, וועלכע—האט ער געזאגט—איר האט געהערט פון מיר; ");
INSERT INTO ydd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ווייל יוחנן האט געטובלט מיט וואסער אין דער מקווה, איר אבער וועט געטובלט ווערן אין דער מקווה מיט דעם רוח הקודש נישט אין פיל טעג ארום. ");
INSERT INTO ydd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","דעריבער, ווען זיי זענען זיך צוזאמענגעקומען, האבן זיי אים געפרעגט, אזוי צו זאגן: האר, צי וועסטו אין דער דאזיקער צייט ווידער אויפריכטן דאס מלכות צו ישראל? ");
INSERT INTO ydd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","האט ער צו זיי געזאגט: עס איז נישט אייער זאך צו וויסן די צייטן אדער זמנים, וועלכע דער פאטער האט פעסטגעזעצט אין זיין מאכט. ");
INSERT INTO ydd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","נאר איר וועט באקומען גבורה, ווען דער רוח הקודש וועט קומען אויף אייך; און וועט זיין מיינע עדות אין ירושלים און אין גאנץ יהודה און אין שומרון און ביז צום עק פון דער ערד. ");
INSERT INTO ydd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","און האבנדיק דאס געזאגט, איז ער ארויפגענומען געווארן, און זיי האבן עס געזען, און א וואלקן האט אים אוועקגענומען פון זייערע אויגן. ");
INSERT INTO ydd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","און ווי זיי האבן אזוי פעסט געקוקט צום הימל, בשעת ער איז אוועק ארויף, זע, ביי זיי זענען געשטאנען צוויי מענער אין ווייסע קליידער; ");
INSERT INTO ydd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","וועלכע האבן אויך געזאגט: איר מענער פון גליל, וואס שטייט איר און קוקט ארויף צום הימל? דער דאזיקער יהושע/ישוע, וואס איז ארויפגענומען געווארן פון אייך אין הימל אריין, וועט אויף אזא אופן קומען, ווי איר האט אים געזען ארויפגיין אין הימל אריין. ");
INSERT INTO ydd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","דעמאלט האבן זיי זיך אומגעקערט קיין ירושלים פונם בארג, וואס הייסט הר הזיתים, וועלכער איז נאענט פון ירושלים א שטח א תחום שבת. ");
INSERT INTO ydd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","און ווען זיי זענען אריינגעקומען, זענען זיי ארויפגעגאנגען אין דער אויבערשטוב, וואו פעטרוס און יוחנן און יעקב און אנדריי, פיליפוס און תומא, בר‑תלמי און מתתיהו, יעקב בן חלפי און שמעון הקנאי און יהודה בן יעקב האבן געוואוינט. ");
INSERT INTO ydd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","די אלע האבן איינשטימיק אנגעהאלטן אין תפילה טאן, צוזאמען מיט די פרויען, און מרים ישועס מוטער און מיט זיינע ברידער. ");
INSERT INTO ydd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","און אין די דאזיקע טעג איז פעטרוס אויפגעשטאנען אין דער מיט פון די ברידער און האט געזאגט—אן עולם אן ערך הונדערט און צוואנציק זענען דערביי געווען פארזאמלט— ");
INSERT INTO ydd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ברידער, עס האט געמוזט דערפילט ווערן דער פסוק, וואס דער רוח הקודש האט פארויסגעזאגט דורך דודס מויל וועגן יהודהן, וועלכער איז געווארן א וועגווייזער פאר די, וואס האבן געפאנגען גענומען יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ווייל ער איז געווען געציילט מיט אונדז און האט באקומען זיין חלק אין דער דאזיקער עבודה. ");
INSERT INTO ydd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","דער דאזיקער האט זיך דערווארבן א פעלד פארן שכר פון זיין רשעות, און איז אנידערגעפאלן מיטן קאפ אראפ און איז צעפלאצט געווארן אין דער מיט, און אלע זיינע געדערעם זענען ארויס. ");
INSERT INTO ydd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","און דאס דאזיקע איז באקאנט געווארן צו אלע איינוואוינער אין ירושלים, אזוי, אז אין זייער אייגענעם דיאלעקט ווערט יענץ פעלד אנגערופן חקל דמא, דאס הייסט א פעלד פון בלוט. ");
INSERT INTO ydd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ווארום עס שטייט געשריבן אין ספר תהלים: זאל זיין וואוינונג ווערן א מדבר, און זאל זיך קיין איינוואוינער נישט געפינען אין איר; און; זיין אויפזיכט זאל אן אנדערער איבערנעמען. ");
INSERT INTO ydd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","עס איז דעריבער נויטווענדיק, אז איינער פון די דאזיקע מענער, וואס האבן אונדז באגלייט די גאנצע צייט, אין וועלכער דער האר יהושע/ישוע איז אריינגעגאנגען און ארויסגעגאנגען צווישן אונדז, ");
INSERT INTO ydd_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","אנהויבנדיק פון יוחננס מקווה ביז צום טאג, ווען ער איז פון אונדז ארויפגענומען געווארן, זאל זיין אן עדות מיט אונדז פון זיין תחית המתים. ");
INSERT INTO ydd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","און זיי האבן געשטעלט צוויי, יוספן, וועמען מען האט גערופן בר‑שבא, און האט געהאט דעם צונאמען יוסטוס, און מתיה. ");
INSERT INTO ydd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","און האבן תפילה געטאן און געזאגט: דו, אָ האר, וואס ווייסט אלעמענס הערצער, ווייז וועלכן דו האסט אויסדערוויילט פון די דאזיקע צוויי, ");
INSERT INTO ydd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","איינעם, וואס זאל איבערנעמען דאס ארט פון דער דאזיקער עבודה און שליחות, פון וועלכער יהודה איז אפגעפאלן, כדי צו גיין אויף זיין אייגן ארט. ");
INSERT INTO ydd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","און האבן געווארפן גורל פאר זיי, און דאס גורל איז אויסגעפאלן אויף מתיה; און ער איז צוגערעכנט געווארן צו די עלף שליחים. ");
INSERT INTO ydd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","און ווען עס איז געקומען דער טאג פון שבועות, זענען אלע געווען פארזאמלט אויף איין ארט. ");
INSERT INTO ydd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","און פלוצלונג איז געווארן א רעש פון הימל, ווי פון א גיכן און געוואלדיקן שטורמווינט, און האט אנגעפילט דאס גאנצע הויז, וואו זיי זענען געזעסן. ");
INSERT INTO ydd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","און עס האבן זיך באוויזן צו זיי צעטיילטע צונגען ווי פון פייער, און האבן זיך געזעצט אויף יעדן איינעם פון זיי. ");
INSERT INTO ydd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","און אלע זענען פול געווארן מיט דעם רוח הקודש און האבן אנגעהויבן רעדן אויף אנדערע לשונות, לויט ווי דער גייסט האט זיי געגעבן זיך אויסצודריקן. ");
INSERT INTO ydd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","און אין ירושלים האבן געוואוינט יידן, יראישמים, פון אלע פעלקער אונטערן הימל. ");
INSERT INTO ydd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","און ווען דאס דאזיקע קול (פונם רעש) איז געקומען, האט זיך דער המון עם פארזאמלט און איז צוטומלט געווארן, ווייל יעדער איינער האט זיי געהערט רעדן אויף זיין אייגן לשון. ");
INSERT INTO ydd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","און זיי זענען דערשטוינט געווארן און האבן זיך געוואונדערט, אזוי צו זאגן: אָט זעט, צי זענען דען נישט אלע די דאזיקע, וואס רעדן, מענטשן פון גליל? ");
INSERT INTO ydd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","און וויאזוי (איז עס, אז) מיר הערן יעדער איינער אין אונדזער אייגענער שפראך, אין וועלכער מיר זענען געבוירן געווארן? ");
INSERT INTO ydd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","פרתיים און מעדער און עלאמיטן, און די איינוואוינער פון ארם נהרים, יהודה, קאפאדאציע, פאנטוס און (קליין) אזיען, ");
INSERT INTO ydd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","פריגיען און פאמפיליען, מצרים און די טיילן פון ליביען ביי קירניה, און די געקומענע פון רוים, ");
INSERT INTO ydd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","יידן און גרים, קרעטער און אראבערן; מיר הערן זיי רעדן אויף אונדזערע לשונות (וועגן) די גרויסע מעשים פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","און אלע זענען געווארן אויסער זיך און צוטומלט, און האבן געזאגט איינער צום אנדערן: וואס זאל דאס באטייטן? ");
INSERT INTO ydd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","אנדערע אבער, אפשפאטנדיק, האבן געזאגט: זיי זענען פול מיט זיסן וויין. ");
INSERT INTO ydd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","אבער פעטרוס, אויפשטעלנדיק זיך צוזאמען מיט די עלף, האט אויפגעהויבן זיין קול און צו זיי געזאגט: איר מענער פון יהודה און אלע איינוואוינער פון ירושלים, זייט דאס וויסן, און נייגט אייערע אויערן צו מיינע ווערטער. ");
INSERT INTO ydd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ווארום די דאזיקע זענען נישט, ווי איר מיינט, שכור, ווייל עס איז (איצט בלויז) די דריטע שעה פון טאג. ");
INSERT INTO ydd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","נאר דאס איז, וואס איז געזאגט געווארן דורך דעם נביא יואל: ");
INSERT INTO ydd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","און עס וועט געשען אין די לעצטע טעג, זאגט ה׳, איך וועל אויסגיסן פון מיין גייסט אויף יעדן בשר (ודם); און אייערע זין און אייערע טעכטער וועלן נבואות זאגן, און אייערע יונגעלייט וועלן זען חזיונות, און אייערע זקנים וועלן חלומען חלומות, ");
INSERT INTO ydd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","און אפילו אויף מיינע קנעכט און דינסטן וועל איך אויסגיסן פון מיין גייסט אין יענע טעג, און זיי וועלן נבואות זאגן. ");
INSERT INTO ydd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","איך וועל געבן מופתים אויבן אין הימל און אותות אונטן אויף דער ערד, בלוט און פייער און א וואלקן רויך. ");
INSERT INTO ydd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","די זון וועט פארקערט ווערן אין פינצטערניש און די לבנה—אין בלוט, איידער עס וועט קומען דער גרויסער און מוראדיקער טאג פון דעם האר. ");
INSERT INTO ydd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","און עס וועט געשען, אז יעדער איינער, וואס וועט אנרופן דעם נאמען פון דעם האר, וועט געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","מענער פון ישראל, הערט די דאזיקע ווערטער: יהושע/ישוע פון נצרת, א מאן, וואס איז צו אייך געוויזן געווארן פון ה׳ דורך גבורות, מופתים און אותות, וועלכע ה׳ האט געטאן דורך אים אין אייער מיט, ווי איר ווייסט עס אליין, ");
INSERT INTO ydd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","דעם דאזיקן, וואס איז איבערגעגעבן געווארן לויט ה׳ס אויסדריקלעכער עצה און פארויסוויסן, האט איר גענומען און דורך די הענט פון רשעים אויפגעהאנגען אויף דער בוים און אומגעברענגט; ");
INSERT INTO ydd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","אים האט ה׳ אויפגעוועקט, אויפלויזנדיק די יסורים פון טויט, ווייל עס האט נישט געקענט זיין, אז ער זאל פון אים געהאלטן ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ווארום דוד (המלך) זאגט אויף אים: געזען האב איך דעם האר תמיד פאר מיר, דען ער איז אויף מיין רעכטער האנט, כדי איך זאל מיך נישט וואקלען. ");
INSERT INTO ydd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","דערפאר האט מיין הארץ זיך משמח געווען און מיין צונג האט זיך געפריידט, און עס וועט נאך מיין לייב רוען אויף האפענונג; ");
INSERT INTO ydd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ווייל דו וועסט נישט איבערלאזן מיין נפש אין שאול (תחתית), דו וועסט אויך נישט דערלאזן דיין הייליקן צו זען פארדארבונג. ");
INSERT INTO ydd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","דו האסט מיר באקאנט געמאכט די וועגן פון לעבן, דו וועסט מיך זאט מאכן מיט פרייד פאר דיין פנים. ");
INSERT INTO ydd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ברידער, לאזט מיך רעדן צו אייך מיט דרייסטקייט וועגן דעם שטאמפאטער דוד, אז ער איז נפטר געווארן און מען האט אים באגראבן, און זיין קבר איז ביי אונדז ביז צום היינטיקן טאג. ");
INSERT INTO ydd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","זייענדיק אבער א נביא און וויסנדיק, אז מיט א שבועה האט ה׳ אים צוגעשוואוירן, צו מאכן זיצן אויף זיין טראן (איינעם) פון דער פרוכט פון זיינע לענדן (תהלים קלב, יא; פט, ד-ה; שמואל ב ז, יב-יג.), ");
INSERT INTO ydd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","פארויסזעענדיק דאס, האט ער גערעדט בנוגע דעם משיחס תחית המתים, אז ער איז נישט איבערגעלאזט געווארן אין שאול, און אז זיין פלייש האט נישט געזען פארדארבונג. ");
INSERT INTO ydd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","דעם דאזיקן יהושע/ישוע האט ה׳ אויפגעשטעלט, פון וועלכן מיר אלע זענען עדות. ");
INSERT INTO ydd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","דעריבער, אזוי ווי ער איז דערהויבן געווארן צו ה׳ס רעכטער האנט און האט באקומען די הבטחה פונם פאטער וואס שייך דעם רוח הקודש, האט ער דאס אויסגעגאסן, וואס איר זעט איצט און הערט. ");
INSERT INTO ydd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ווארום דוד איז נישט ארויפגעגאנגען אין הימל אריין, דען ער אליין זאגט: דער האר האט געזאגט צו מיין האר: זיץ ביי מיין רעכטער זייט, ");
INSERT INTO ydd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ביז איך וועל אנידערלייגן דיינע פיינט פאר א פוסבענקעלע צו דיינע פיס. ");
INSERT INTO ydd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","דעריבער זאל דאס גאנצע בית ישראל זיכער וויסן, אז דעם דאזיקן יהושע/ישוע, וועמען איר האט אויפגעהאנגען אויף דער בוים, האט ה׳ געמאכט סאי פאר האר סאי פאר משיח. ");
INSERT INTO ydd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","און ווי זיי האבן דאס געהערט, האבן זיי עס זיך גענומען צום הארצן, און געזאגט צו פעטרוסן און צו די איבריקע שליחים: ברידער, וואס זאלן מיר טאן? ");
INSERT INTO ydd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","און פעטרוס האט צו זיי געזאגט: טוט תשובה, און זאל יעדער איינער פון אייך זיך לאזן טובל זיין אין דער מקווה אינם נאמען פון יהושע/ישוע המשיחן צו דער פארגעבונג פון אייערע זינד, און איר וועט באקומען די מתנה פון דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ווארום די הבטחה איז צו אייך און צו אייערע קינדער, און צו אלע, וואס זענען פון ווייטן, וועלכע דער האר אונדזער ג‑ט וועט רופן. ");
INSERT INTO ydd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","און מיט נאך א סך אנדערע רייד האט ער עדות געזאגט און זיי מזהיר געווען, זאגנדיק: ראטעוועט זיך פון דעם דאזיקן פארקרימטן דור. ");
INSERT INTO ydd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","און די, וואס האבן אנגענומען זיין ווארט, האבן זיך געלאזט טובל זיין אין דער מקווה, און עס זענען צוגעקומען יענעם טאג אן ערך דריי טויזנט נפשות. ");
INSERT INTO ydd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","און זיי האבן שטענדיק עוסק געווען אין דער לערנונג פון די שליחים און אין דער חברותאשאפט, אין ברויט ברעכן און אין די תפילות. ");
INSERT INTO ydd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","און עס איז געקומען א מורא אויף יעדן נפש, און א סך מופתים און אותות זענען געשען דורך די שליחים. ");
INSERT INTO ydd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","און אלע מאמינים זענען געווען צוזאמען, און האבן אלץ געהאט געמיינזאם; ");
INSERT INTO ydd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","און האבן פארקויפט זייער האב און גוטס און עס צעטיילט צו אלעמען, לויט ווי יעדער איינער האט זיך גענייטיקט. ");
INSERT INTO ydd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","און טאג אויס טאג איין האבן זיי זיך געפלייסט צו זיין אין בית המקדש, און געבראכן ברויט פון הויז צו הויז, און געגעסן זייער שפייז מיט שמחה און אויפריכטיקייט פונם הארצן, ");
INSERT INTO ydd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","לויבנדיק ה׳ און געפינענדיק חן ביים גאנצן פאלק. און יעדן טאג האט דער האר מוסיף געווען צו זיי די, וואס זענען געראטעוועט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","און פעטרוס און יוחנן זענען ארויפגעגאנגען אין בית המקדש אריין אין דער שעה פון תפילה, דער ניינטער. ");
INSERT INTO ydd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","און א מאן, א לאמען פון זיין מוטערס לייב, האט מען געברענגט צו טראגן, וועלכן מען פלעגט אנידערזעצן יעדן טאג ביים טויער פון בית המקדש, וואס האט געהייסן שער המהודר, צו בעטן נדבות פון די, וואס זענען אריינגעגאנגען אין בית המקדש אריין. ");
INSERT INTO ydd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","דערזעענדיק פעטרוסן און יוחנן, וועלכע האבן געהאלטן ביים אריינגיין אין בית המקדש, האט ער (זיי) געבעטן א נדבה. ");
INSERT INTO ydd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","פעטרוס אבער האט אויף אים א בליק געטאן מיט יוחנן און געזאגט: קוק אויף אונדז. ");
INSERT INTO ydd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","און ער האט געווענדט זיין פנים צו זיי, האפנדיק עפעס פון זיי צו באקומען. ");
INSERT INTO ydd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","פעטרוס אבער האט געזאגט: זילבער און גאלד האב איך נישט, נאר וואס איך האב יא, דאס גיב איך דיר. אין דעם נאמען פון יהושע/ישוע המשיח פון נצרת, שטיי אויף און גיי. ");
INSERT INTO ydd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","און ער האט אים אנגעכאפט ביי דער רעכטער האנט און אים אויפגעשטעלט; און אין אן אויגנבליק זענען זיינע פיס און קנעכלעך געשטארקט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","און ער איז אויפגעשפרונגען און האט זיך אנידערגעשטעלט, און איז ארומגעגאנגען; און איז אריינגעגאנגען מיט זיי אין בית המקדש אריין, ארומגייענדיק און שפרינגענדיק און לויבנדיק ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","און דאס גאנצע פאלק האט אים געזען ארומגיין און לויבן ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","און מען האט אים דערקענט, אז דאס איז דער, וואס פלעגט זיצן אויף נדבות ביים שער המהודר פון בית המקדש, און זיי זענען פול געווארן מיט שטוינען און פארוואונדערונג איבער דעם, וואס איז אים געשען. ");
INSERT INTO ydd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","און בשעת ער האט זיך געהאלטן צו פעטרוסן און יוחנן, איז דער גאנצער עולם זיך צוזאמענגעלאפן צו זיי צו דעם פאליש, וואס האט געהייסן אולם של שלמה, אויסער זיך פון שטוינען. ");
INSERT INTO ydd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","און זעענדיק דאס, האט פעטרוס געענטפערט דעם עולם: איר מענער פון ישראל, וואס וואונדערט איר זיך איבער דער דאזיקער זאך? אדער וואס קוקט איר אזוי אויף אונדז, גלייך ווי מיט אונדזער אייגענעם כוח אדער פרומקייט האבן מיר אים געמאכט ארומגיין? ");
INSERT INTO ydd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","דער ג‑ט פון אברהם און יצחק און יעקב, דער ג‑ט פון אונדזערע אבות, האט פארהערלעכט זיין קנעכט יהושע/ישוע, וועמען איר האט איבערגעגעבן, און פארלייקנט פאר פילאטוסן, ווען ער האט באשלאסן אים צו באפרייען. ");
INSERT INTO ydd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","איר אבער האט פארלייקנט דעם קדוש און צדיק, און פארלאנגט אז א מאן א רוצח זאל אייך באגנעדיקט ווערן, ");
INSERT INTO ydd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","און האט געטייט דעם שר החיים, וועמען ה׳ האט אויפגעוועקט פון די טויטע, פון וואס מיר זענען עדות. ");
INSERT INTO ydd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","און דורך דער אמונה אין זיין נאמען, האט זיין נאמען געשטארקט דעם דאזיקן, וואס איר זעט (דא) און קענט; און דער גלויבן, וואס איז דורך אים, האט אים געגעבן די פולע געזונטהייט פאר אייך אלעמען. ");
INSERT INTO ydd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","און איצט, ברידער, איך ווייס, אז איר האט עס געטאן נישט וויסנדיקערהייט, ווי אויך אייערע שרים. ");
INSERT INTO ydd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","אבער ה׳ האט אויף אזא אופן דערפילט, וואס ער האט פארויסגעזאגט דורך דעם מויל פון אלע נביאים, אז זיין משיח וועט ליידן. ");
INSERT INTO ydd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","דעריבער טוט תשובה און קערט אייך אום, כדי אייערע זינד זאלן אויסגעמעקט ווערן, ");
INSERT INTO ydd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","אז עס זאלן קומען צייטן פון דערקוויקונג פון דעם פנים פון דעם האר, און אז ער זאל אייך שיקן דעם פארויסבאשטימטן משיח יהושע/ישוע, ");
INSERT INTO ydd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","וועמען דער הימל מוז אויפנעמען ביז צו דער צייט, ווען אלץ וועט צוריקגעשטעלט ווערן, פון וועלכן ה׳ האט גערעדט פון אייביק אָן דורך דעם מויל פון זיינע הייליקע נביאים. ");
INSERT INTO ydd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ווארום משה (רבינו) האט געזאגט: א נביא, גלייך צו מיר, וועט דער האר ג‑ט אויפשטעלן צו אייך, פון צווישן אייערע ברידער; אים זאלט איר הערן לויט אלעם, וואס ער וועט צו אייך רעדן; ");
INSERT INTO ydd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","און עס וועט זיין, אז יעדעס נפש, וואס וועט יענעם נביא נישט הערן, זאל פארטיליקט ווערן פון דעם פאלק. ");
INSERT INTO ydd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","און אלע נביאים פון שמואל אָן און די, וואס זענען געווען נאך אים, וואס האבן גערעדט, האבן אויך אנגעזאגט די דאזיקע טעג. ");
INSERT INTO ydd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","איר זענט די קינדער פון די נביאים, און פון דעם בונד (ברית), וואס ה׳ האט געמאכט מיט אייערע אבות, ווען ער האט געזאגט צו אברהמען: און דורך דיין זאמען וועלן געבענטשט ווערן אלע משפחות פון דער ערד. ");
INSERT INTO ydd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","צו אייך קודם כל האט ה׳ אויפגעשטעלט זיין קנעכט און אים געשיקט אייך צו בענטשן, ווען יעדער איינער פון אייך וועט זיך אוועקקערן פון זיינע (מעשים) רעים. ");
INSERT INTO ydd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","און בשעת זיי האבן גערעדט צום עולם, זענען אויף זיי געקומען די כהנים און דער מיליטערישער הויפטמאן פונם בית המקדש און די צדוקים, ");
INSERT INTO ydd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ווייל זיי זענען געווען זייער אויפגעבראכט צוליב דעם, וואס זיי לערנען דאס פאלק און זאגן אָן תחית המתים דורך יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","און האבן ארויפגעלייגט די הענט אויף זיי, און זיי איינגעזעצט אין תפיסה ביז אינדערפרי; ווארום עס איז שוין געווען אוונט. ");
INSERT INTO ydd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","א סך אבער וואס האבן געהערט דאס ווארט, האבן געגלויבט; און די צאל פון די מענער איז געווען אן ערך פינף טויזנט. ");
INSERT INTO ydd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","און עס איז געשען, אינדערפרי זענען זיך צונויפגעקומען זייערע שרים און די זקנים און די סופרים אין ירושלים ");
INSERT INTO ydd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","און חנן דער כהן גדול, און קיפא און יוחנן און אלעקסאנדער, און אלע, וואס זענען געווען פון דעם כהן גדולס משפחה. ");
INSERT INTO ydd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","און מען האט זיי אוועקגעשטעלט אין דער מיט, און געפרעגט: מיט וועלכן כוח, אדער מיט וועלכן שם האט איר דאס געטאן? ");
INSERT INTO ydd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","דעמאלט איז פעטרוס פול געווארן מיט דעם רוח הקודש און האט געזאגט צו זיי: איר שרים פונם פאלק און זקנים פון ישראל, ");
INSERT INTO ydd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","אויב מען איז אונדז היינט חוקר ודורש וועגן דער טובה צום קראנקן מענטשן, דורך וואס ער איז געהיילט געווארן, ");
INSERT INTO ydd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","זאלט איר אלע וויסן און דאס גאנצע פאלק ישראל, אז אין דעם נאמען פון יהושע/ישוע המשיח פון נצרת, וועמען איר האט אויפגעהאנגען אויף דער בוים, וועמען ה׳ האט אויפגעוועקט פון די טויטע, דורך דעם דאזיקן שטייט דער מאן געזונט פאר אייך. ");
INSERT INTO ydd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ער איז דאס דער שטיין, וואס איר, די בוימייסטערס, האט פארווארפן, וועלכער איז געווארן צום הויפט פונם ווינקל. ");
INSERT INTO ydd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","און עס איז נישט פאראן קיין ישועה אין קיין אנדערן; ווארום עס איז נישטא אונטערן הימל קיין אנדערער נאמען, וואס איז געגעבן געווארן צווישן מענטשן, דורך וועלכן מיר זאלן געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","און ווען זיי האבן געזען דעם מוט פון פעטרוסן און יוחנן, און האבן פארשטאנען, אז זיי זענען אומגעלערנטע און איינפאכע מענטשן, האבן זיי זיך געוואונדערט, און דערקענט, אז זיי זענען געווען מיט יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","און זעענדיק דעם מענטשן, וואס איז געהיילט געווארן, שטיין מיט זיי, האבן זיי נישט געהאט וואס אקייגנצורעדן. ");
INSERT INTO ydd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","נאר באפעלנדיק זיי ארויסצוגיין אינדרויסן פון סנהדרין, האבן זיי זיך באראטן איינער מיטן אנדערן, ");
INSERT INTO ydd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","אזוי צו זאגן: וואס זאלן מיר טאן מיט די דאזיקע מענטשן? ווארום אז א באקאנט נס איז דורך זיי געשען, איז קלאר צו אלע איינוואוינער פון ירושלים, און מיר קענען עס נישט אפלייקענען. ");
INSERT INTO ydd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","נאר כדי עס זאל זיך נישט נאך מער פארשפרייטן צווישן פאלק, לאמיר זיי מזהיר זיין מער נישט צו רעדן צו קיינעם אין דעם דאזיקן נאמען. ");
INSERT INTO ydd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","און האבן זיי גערופן, און באפוילן אינגאנצן נישט צו רעדן און נישט צו לערנען אין דעם נאמען פון יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","פעטרוס אבער און יוחנן האבן ענטפערנדיק געזאגט צו זיי: משפט איר, צי עס איז גערעכט פאר ה׳ אייך מער צו געהארכן ווי ה׳ (אליין); ");
INSERT INTO ydd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ווארום מיר קענען נישט אנדערש ווי רעדן דאס, וואס מיר האבן געזען און געהערט. ");
INSERT INTO ydd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","און זיי האבן נאכאמאל זיי געווארנט, און אפגעלאזט, נישט געפינענדיק עפעס, פארוואס זיי צו באשטראפן, צוליב דעם פאלק; ווייל אלע האבן געלויבט ה׳ איבער דעם, וואס איז געשען. ");
INSERT INTO ydd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ווארום דער מענטש איז געווען עלטער ווי פערציק יאר, צו וועמען עס איז געטאן געווארן דאס דאזיקע נס פון רפואה. ");
INSERT INTO ydd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","און ווערנדיק באפרייט, זענען זיי געקומען צו זייערע אייגענע און האבן דערציילט אלץ, וואס די הויפט כהנים און די זקנים האבן צו זיי געזאגט. ");
INSERT INTO ydd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","און ווען זיי האבן דאס געהערט, האבן אלע צוזאמען אויפגעהויבן זייער קול צו ה׳, און געזאגט: אָ האר, דו ביסט עס, וואס האט באשאפן דעם הימל און די ערד און דעם ים, און אלץ, וואס איז אין זיי; ");
INSERT INTO ydd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","דו האסט געזאגט דורך דעם רוח הקודש דורך דעם מויל פון אונדזער פאטער דוד, דיין קנעכט: פארוואס צארנען די אומות (העולם), און די פעלקער טראכטן אויס פוסטקייטן? ");
INSERT INTO ydd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","די מלכים פון דער ערד האבן זיך אויפגעשטעלט, און די פירשטן האבן זיך אינאיינעם פארזאמלט, קעגן דעם האר און קעגן זיין משיח. ");
INSERT INTO ydd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ווארום באמת אין דער דאזיקער שטאט האבן זיך פארזאמלט קעגן דיין הייליקן קנעכט יהושע/ישוע, וועמען דו האסט געזאלבט, הורדוס און פאנטיוס פילאטוס מיט די אומות (העולם) און די פעלקער ישראל, ");
INSERT INTO ydd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","צו טאן וואס דיין האנט און עצה האט פארויס גוזר געווען, אז עס זאל געשען. ");
INSERT INTO ydd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","און איצט אָ האר, קוק אויף זייערע דראונגען, און גיב דיינע קנעכט צו רעדן דיין ווארט מיט א פולן דרייסטקייט, ");
INSERT INTO ydd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","בשעת דו טוסט אויסשטרעקן דיין האנט צו היילן, און צו טאן אותות און מופתים דורך דעם נאמען פון דיין הייליקן קנעכט יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","און בעת זיי האבן תפילה געטאן, האט דאס ארט געציטערט, אין וועלכן זיי זענען געווען פארזאמלט; און אלע זענען פול געווארן מיט דעם רוח הקודש, און האבן גערעדט דאס ווארט פון ה׳ מיט דרייסטקייט. ");
INSERT INTO ydd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","און ביי דעם רוב מאמינים איז געווען איין הארץ און איין גייסט, און קיינער האט נישט געזאגט, אז עפעס פון זיין באזיץ איז זיין אייגנס; נאר אלץ איז ביי זיי געווען געמיינשאפטלעך. ");
INSERT INTO ydd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","און מיט גרויס גבורה האבן די שליחים אפגעגעבן דאס עדות זאגן פון דעם האר ישועס אויפשטיין (תחית המתים); און גרויס חסד איז געווען אויף זיי אלעמען. ");
INSERT INTO ydd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","און עס איז נישט געווען קיין נויטליידנדער צווישן זיי, ווייל אלע, וואס האבן פארמאגט פעלדער אדער הייזער, האבן (די דאזיקע) פארקויפט, און געברענגט די פרייזן פון די פארקויפטע זאכן ");
INSERT INTO ydd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","און אנידערגעלייגט ביי די פיס פון די שליחים; און עס איז צעטיילט געווארן צו יעדן איינעם, לויט זיינע באדערפענישן. ");
INSERT INTO ydd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","און יוסף, וואס האט געקריגן פון די שליחים דעם ביינאמען בר‑נבא (דאס הייסט, זון פון טרייסט), א לוי, געבוירן אין קפריסין, ");
INSERT INTO ydd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","באזיצנדיק א פעלד, האט עס פארקויפט, און געברענגט דאס געלט, און עס אנידערגעלייגט ביי די פיס פון די שליחים. ");
INSERT INTO ydd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","א געוויסער מאן אבער מיטן נאמען חנניה, מיט שפירה זיין ווייב, האט פארקויפט א פארמעגן, ");
INSERT INTO ydd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","און אראפגענומען פון דעם פרייז, מיטן וויסן פון זיין ווייב, און א חלק געברענגט און אנידערגעלייגט ביי די פיס פון די שליחים. ");
INSERT INTO ydd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","פעטרוס אבער האט געזאגט: חנניה, פארוואס האט דער שׂטן אנגעפילט דיין הארץ, צו זאגן א ליגן צום רוח הקודש און אראפצונעמען פונם פרייז פון פעלד? ");
INSERT INTO ydd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","צי איז עס דען נישט געווען דיין אייגנס, ווען דו האסט עס געהאט? און נאכן פארקויפן, צי איז עס דען נישט געווען אין דיין רשות? פארוואס האסטו באשלאסן אין דיין הארצן די דאזיקע זאך? דו האסט נישט געלייקנט פאר מענטשן, נאר פאר ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","און ווען חנניה האט געהערט די דאזיקע ווערטער, איז ער אנידערגעפאלן און אויסגעגאנגען; און א גרויסע מורא איז געקומען איבער אלע, וואס האבן דאס געהערט. ");
INSERT INTO ydd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","און די יונגעלייט זענען אויפגעשטאנען, האבן אים אנגעטאן תכריכים, און אים ארויסגעטראגן און קובר געווען. ");
INSERT INTO ydd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","און נאך א פארלויף פון אן ערך דריי שעה איז זיין ווייב אריינגעקומען, נישט וויסנדיק וואס עס איז געשען. ");
INSERT INTO ydd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","און פעטרוס האט צו איר געזאגט: זאג מיר, צי האט איר פאר כך‑וכך פארקויפט דאס פעלד? און זי האט געזאגט: יא, פאר כך‑וכך. ");
INSERT INTO ydd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","האט פעטרוס צו איר געזאגט: פארוואס האט איר איינגעשטימט צווישן זיך אויסצופרואוון דעם גייסט פון דעם האר? אָט זע, די פיס פון די, וואס האבן באגראבן דיין מאן, זענען ביי דער טיר, און זיי וועלן דיך (אויך) ארויסטראגן. ");
INSERT INTO ydd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","און זי איז גלייך אנידערגעפאלן צו זיינע פיס און אויסגעגאנגען; און די יונגעלייט זענען אריינגעקומען און האבן זי געפונען א טויטע, און, ארויסטראגנדיק, האבן זיי זי קובר געווען ביי איר מאן. ");
INSERT INTO ydd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","און עס איז געקומען א גרויסע מורא איבער דער גאנצער קהילה און איבער אלע, וואס האבן דאס געהערט. ");
INSERT INTO ydd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","און דורך די הענט פון די שליחים זענען געשען א סך אותות און מופתים צווישן דעם פאלק; און אלע זענען געווען צוזאמען אין דעם אולם של שלמה. ");
INSERT INTO ydd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","פון די איבריקע אבער האט קיינער זיך נישט אונטערגעשטעלט צו באהעפטן צו זיי, נאר דאס פאלק האט זיי געהאלטן זייער טייער; ");
INSERT INTO ydd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","און די מאמינים אינם האר האבן זיך פיל פארמערט, מאסן מענער און אויך פרויען; ");
INSERT INTO ydd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","אזוי, אז מען פלעגט ארויסטראגן קראנקע אויף די גאסן, און זיי געלייגט אויף בעטן און געלעגערס, כדי ווען פעטרוס וועט קומען, זאל ווייניקסטנס זיין שאטן פאלן אויף עמיצן פון זיי. ");
INSERT INTO ydd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","און א המון מענטשן איז זיך צוזאמענגעקומען אין ירושלים פון די שטעט ארום, ברענגענדיק צו טראגן שלאפע און געפלאגטע פון אומריינע גייסטער, וועלכע זענען אלע געהיילט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","און דער כהן גדול איז אויפגעשטאנען און אלע, וואס זענען געווען מיט אים (דאס איז די כיתה פון די צדוקים), און זענען פול געווארן מיט קנאה, ");
INSERT INTO ydd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","און האבן ארויפגעלייגט די הענט אויף די שליחים, און זיי איינגעזעצט אין דער שטאטישער תפיסה. ");
INSERT INTO ydd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","און א מלאך פון דעם האר (ה׳) האט ביינאכט אויפגעעפנט די טירן פון דעם געפענקעניש, און זיי ארויסגעפירט, און געזאגט: ");
INSERT INTO ydd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","גייט, שטעלט זיך און רעדט אין בית המקדש צום פאלק אלע רייד פון דעם דאזיקן לעבן. ");
INSERT INTO ydd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","און ווען זיי האבן דאס געהערט, זענען זיי אינדערפרי אריינגעגאנגען אין בית המקדש אריין און האבן געלערנט. אבער דער כהן גדול איז געקומען און די, וואס זענען געווען מיט אים, און האבן צונויפגערופן דאס סנהדרין און אלע זקנים פון די בני ישראל, און געשיקט צו דער תפיסה, מען זאל זיי ברענגען. ");
INSERT INTO ydd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","און די משרתים זענען אהינגעגאנגען און האבן זיי נישט געפונען אין תפיסה, און האבן זיך אומגעקערט און דערציילט, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","מיר האבן געפונען דאס געפענקעניש פעסט פארשלאסן און די שומרים שטיין ביי די טירן; אבער אויפעפנענדיק, האבן מיר אינעווייניק קיינעם נישט געפונען. ");
INSERT INTO ydd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","און ווי דער מיליטערישער הויפטמאן פונם בית המקדש און די הויפט כהנים האבן געהערט די דאזיקע ווערטער, זענען זיי פארצווייפלט געווארן איבער זיי, וואס עס וועט פון דעם דאזיקן ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","דאן איז עמיצער געקומען און זיי דערציילט: זע, די מענער, וועמען איר האט איינגעזעצט אין תפיסה, זענען אינם בית המקדש, און שטייען און לערנען דאס פאלק. ");
INSERT INTO ydd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","דעמאלט איז דער מיליטערישער הויפטמאן אוועק צוזאמען מיט די משרתים, און זיי געברענגט, (דאך) נישט מיט געוואלד; ווארום זיי האבן מורא געהאט פארן פאלק, מען זאל זיי נישט שטייניקן. ");
INSERT INTO ydd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","און האבן זיי געברענגט און אוועקגעשטעלט פארן סנהדרין. און דער כהן גדול האט זיי געפרעגט, ");
INSERT INTO ydd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","אזוי צו זאגן: האבן מיר אייך נישט שטרענג באפוילן, נישט צו לערנען אין דעם דאזיקן נאמען, און זע, איר האט אנגעפילט ירושלים מיט אייער לערנונג, און ווילט איר ברענגען אויף אונדז דאס בלוט פון דעם דאזיקן מענטשן? ");
INSERT INTO ydd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","און פעטרוס און די שליחים האבן ענטפערנדיק געזאגט: ה׳ מוז מען מער געהארכן ווי מענטשן. ");
INSERT INTO ydd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","דער ג‑ט פון אונדזערע אבות האט אויפגעוועקט יהושען/ישוען, וועמען איר האט גענומען און אויפגעהאנגען אויף א בוים. ");
INSERT INTO ydd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","אים האט ה׳ דערהייבט מיט זיין רעכטער האנט, (צו זיין) א שר און א גואל, צו געבן צו ישראל תשובה און סליחת חטאים. ");
INSERT INTO ydd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","און מיר זענען עדות פון די דאזיקע ווערטער, און דער רוח הקודש, וועלכן ה׳ האט געגעבן צו די, וואס געהארכן אים. ");
INSERT INTO ydd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","און הערנדיק דאס, האט עס זיי געשטאכן אין זייערע הערצער, און זיי האבן געוואלט זיי טייטן. ");
INSERT INTO ydd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","נאר עס איז אויפגעשטאנען א געוויסער מאן אינם סנהדרין, א פרוש, וואס האט געהייסן גמליאל, א תנא, הויך געאכט ביים גאנצן פאלק, און האט באפוילן מען זאל די מענטשן ארויספירן אויף א וויילע. ");
INSERT INTO ydd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","דאן האט ער געזאגט צו זיי: מענער פון ישראל, זייט פארזיכטיק וואס שייך די דאזיקע מענטשן, וואס איר גייט טאן. ");
INSERT INTO ydd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ווארום פאר די דאזיקע טעג איז אויפגעשטאנען תודס, זאגנדיק, אז ער איז עפעס; צו וועמען עס האבן זיך באהאפטן אין צאל אן ערך פיר הונדערט מענטשן; ער איז געהרגעט געווארן; און אלע, וואס האבן אים געפאלגט, זענען צעשפרייט און צונישט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","נאך דעם איז אויפגעשטאנען יהודה הגלילי, אין די טעג פון דער רעגיסטרירונג, און האט פארפירט נאך זיך אן אנגעזעענעם טייל פונם פאלק; אויך ער איז פארלוירן געווארן, און אלע, וואס האבן אים געהארכט, זענען צעשפרייט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","און איצט זאג איך אייך: האלט זיך צוריק פון די דאזיקע מענטשן, און לאזט זיי אפ: ווייל אויב די דאזיקע עצה אדער די דאזיקע זאך איז פון מענטשן, וועט זי צעשטערט ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","נאר אויב זי איז פון ה׳, וועט איר זיי נישט קענען שטערן; טאמער וועט איר געפונען ווערן ראנגלענדיק אויך קעגן ה׳. און זיי האבן אים געהארכט; ");
INSERT INTO ydd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","און רופנדיק די שליחים און שלאגנדיק זיי מלקות, האבן זיי באפוילן, אז זיי זאלן נישט רעדן אין ישועס נאמען, און האבן זיי אפגעלאזט. ");
INSERT INTO ydd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","און זיי זענען אוועקגעגאנגען פון פאר דעם סנהדרין, פרייענדיק זיך וואס זיי האבן ווערטיק געווען מבזה צו ווערן צוליב דעם נאמען. ");
INSERT INTO ydd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","און יעדן טאג, סאי אין בית המקדש סאי פון הויז צו הויז, האבן זיי נישט אויפגעהערט צו לערנען און אנצוזאגן די בשורה פון דעם משיח יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","און אין די דאזיקע טעג, ווען די תלמידים האבן זיך געמערט, איז געווארן א געמורמל פון די העלעניסטן קעגן די עברים, מחמת אין דער טאג טעגלעכער באדינונג זענען זייערע אלמנות פארנאכלעסיקט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","און די צוועלף האבן גערופן דעם עולם תלמידים, צו זיך און געזאגט: עס טויג נישט, אז מיר זאלן איבערלאזן ה׳ס ווארט און זיך פארנעמען מיט דינען ביי טישן. ");
INSERT INTO ydd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","נאר זוכט זיך אויס, ברידער, צווישן אייך זיבן מענער, וואס האבן א גוטן נאמען און זענען פול מיט דעם רוח הקודש און מיט חכמה, זיי וועלן מיר באשטימען איבער דעם דאזיקן ענין; ");
INSERT INTO ydd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","מיר אבער וועלן אנהאלטן אין תפילה און אין דער עבודה פון דעם ווארט. ");
INSERT INTO ydd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","און דאס ווארט איז געפעלן דעם גאנצן עולם; און מען האט אויסדערוויילט סטעפאנוסן, א מאן פול מיט אמונה און מיט דעם רוח הקודש, און פיליפוסן און פראכארוסן און ניקאנאר און טימאן און פארמענאס, און ניקאלאאסן, א גר פון אנטיוכיא. ");
INSERT INTO ydd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","זיי האט מען געשטעלט פאר די שליחים; און מתפלל זייענדיק, האבן זיי ארויפגעלייגט די הענט אויף זיי. ");
INSERT INTO ydd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","און ה׳ס ווארט איז געוואקסן, און די צאל תלמידים אין ירושלים האט זיך שטארק פארמערט, אפילו א גרויסע מאסע פון די כהנים איז געווארן געהארכזאם צום אמונה. ");
INSERT INTO ydd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","און סטעפאנוס, פול מיט גנאד און גבורה, האט געטאן גרויסע אותות און מופתים צווישן דעם פאלק. ");
INSERT INTO ydd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","עס זענען אבער אויפגעשטאנען אייניקע פון דעם בית הכנסת, וואס האט געהייסן די שול פון די ליבערטינער, און פון קירניה און אלעקסאנדרענער און פון די (לייט) פון קיליקיען און אזיען; און האבן געהאלטן א וויכוח מיט סטעפאנוסן, ");
INSERT INTO ydd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","און זיך נישט געקענט אקייגנשטעלן דער חכמה און דעם גייסט, מיט וועלכן ער האט גערעדט. ");
INSERT INTO ydd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","האבן זיי דעמאלט אונטערגעשטעלט מענער, וואס האבן געזאגט: מיר האבן אים געהערט רעדן לעסטערנדיקע ווערטער קעגן משהן און ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","און האבן אויפגעהעצט דאס פאלק און די זקנים און די סופרים, און זענען אויפגעשטאנען און אים גענומען מיט געוואלד, און אוועקגעפירט צום סנהדרין, ");
INSERT INTO ydd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","און געשטעלט פאלשע עדות, וואס האבן געזאגט: דער דאזיקער מענטש הערט נישט אויף צו רעדן ווערטער קעגן דעם דאזיקן מקום קדוש און דער תורה; ");
INSERT INTO ydd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ווארום מיר האבן אים געהערט זאגן, אז דער דאזיקער יהושע/ישוע פון נצרת, וועט צעשטערן דאס ארט און ענדערן די חוקים, וועלכע משה האט אונדז איבערגעגעבן. ");
INSERT INTO ydd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","און אלע, וואס זענען געזעסן אין סנהדרין, האבן מיט שפאנונג געקוקט אויף אים, און געזען זיין פנים ווי (עס וואלט געווען) דאס פנים פון א מלאך. ");
INSERT INTO ydd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","און דער כהן גדול האט געזאגט: צי איז עס טאקע אזוי? ");
INSERT INTO ydd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ער אבער האט געזאגט: ברידער און פאטערס, הערט! דער ג-ט פון כבוד האט זיך באוויזן צו אונדזער פאטער אברהם, בשעת ער איז געווען אין ארם נהרים, איידער ער האט געוואוינט אין חרן, ");
INSERT INTO ydd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","און געזאגט צו אים: גיי ארויס פון דיין לאנד און פון דיין משפחה, און גיי אין דעם לאנד אריין, וואס איך וועל דיר ווייזן. ");
INSERT INTO ydd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","איז ער דעמאלט ארויסגעגאנגען אויס דעם לאנד פון די כשדים און האט געוואוינט אין חרן, און פון דארטן, נאך דעם ווי זיין פאטער איז געשטארבן, האט ער אים אריבערגעברענגט אין דעם דאזיקן לאנד אריין, אין וועלכן איר וואוינט איצט. ");
INSERT INTO ydd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","און האט אים דרינען נישט געגעבן קיין ירושה, אפילו נישט אן ארט, וואו א פוס אנידערצושטעלן, נאר עס אים צוגעזאגט צו געבן פאר א באזיץ און צו זיין זאמען נאך אים, בשעת ער האט נאך נישט געהאט קיין קינד. ");
INSERT INTO ydd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","און ה׳ האט צו אים אזוי גערעדט: אז זיין זאמען וועט זיין א גר אין א פרעמד לאנד, און מען וועט זיי פארקנעכטן און פייניקן פיר הונדערט יאר לאנג. ");
INSERT INTO ydd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","און דאס פאלק, וואס וועט זיי פארקנעכטן, וועל איך משפטן, האט ה׳ געזאגט, און דערנאך וועלן זיי ארויסגיין און מיך דינען אויף דעם דאזיקן ארט. ");
INSERT INTO ydd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","און האט אים געגעבן דעם בונד (ברית) פון מילה; און אזוי האט ער (אברהם) געבוירן יצחקן און אים מל געווען דעם אכטן טאג, און יצחק האט געבוירן יעקבן, און יעקב—די צוועלף ראשי האבות. ");
INSERT INTO ydd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","און די ראשי האבות, מקנא זייענדיק יוספן, האבן אים פארקויפט קיין מצרים; און ה׳ איז געווען מיט אים, ");
INSERT INTO ydd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","און האט אים מציל געווען פון אלע זיינע צרות, און אים געשענקט חן און חכמה פאר פרעהן, דעם מלך פון מצרים; און ער האט אים באשטימט פאר א מושל איבער מצרים און איבער זיין גאנץ הויז. ");
INSERT INTO ydd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","און עס איז געווארן א הונגער איבער גאנץ מצרים און כנען, און א גרויסע צרה, און אונדזערע עלטערן האבן נישט געפונען קיין שפייז. ");
INSERT INTO ydd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ווען אבער יעקב האט געהערט, אז עס איז דא ווייץ אין מצרים, האט ער דאס ערשטע מאל ארויסגעשיקט אונדזערע פאטערס. ");
INSERT INTO ydd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","און דאס אנדערע מאל האט יוסף זיך געלאזט דערקענען צו זיינע ברידער, און יוספס אפשטאמונג איז באקאנט געווארן צו פרעהן. ");
INSERT INTO ydd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","און יוסף האט געשיקט און גערופן זיין פאטער יעקב און די גאנצע משפחה, (פינף און) זיבעציק נפשות. ");
INSERT INTO ydd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","און יעקב האט אראפגענידערט קיין מצרים, און איז געשטארבן און אונדזערע פאטערס, ");
INSERT INTO ydd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","און מען האט זיי אריבערגעברענגט קיין שכם און געלייגט אין דעם קבר, וואס אברהם האט געקויפט פאר א געלט פרייז פון חמורס זין אין שכם. ");
INSERT INTO ydd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","און אזויווי עס האט זיך דערנענטערט די צייט פון דער הבטחה, וועגן וועלכער ה׳ האט צוגעשוואוירן צו אברהמען, איז דאס פאלק געוואקסן און זיך פארמערט אין מצרים, ");
INSERT INTO ydd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ביז איבער מצרים איז אויפגעשטאנען אן אנדערער קעניג, וועלכער האט נישט געקענט יוספן. ");
INSERT INTO ydd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","דער דאזיקער האט געהאנדלט מיט כיטרעקייט קעגן אונדזער פאלק, און געפייניקט אונדזערע עלטערן, אז זיי זאלן ארויסווארפן זייערע נייגעבוירענע קינדער, כדי זיי זאלן נישט בלייבן לעבן. ");
INSERT INTO ydd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","אין דער צייט איז משה געבוירן געווארן, און געווען שיין פאר ה׳, און איז דריי חדשים לאנג גענערט געווארן אין זיין פאטערס הויז. ");
INSERT INTO ydd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","און ווען מען האט אים ארויסגעווארפן, האט פרעהס טאכטער אים גענומען און דערצויגן פאר זיך פאר א זון. ");
INSERT INTO ydd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","און משה איז געלערנט געווארן אין יעדער חכמה פון די מצריים, און געווען א גיבור אין זיינע ווערטער און מעשים. ");
INSERT INTO ydd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","און ווען ער איז אלט געווארן פערציק יאר, איז אים געקומען אויפן הארצן צו באזוכן זיינע ברידער די קינדער ישראל. ");
INSERT INTO ydd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","און זעענדיק איינעם ליידן אן עוולה, האט ער זיך אנגענומען און נוקם געווען פאר דעם געליטענעם, דערשלאגנדיק דעם מצרי. ");
INSERT INTO ydd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","און האט געמיינט, אז זיינע ברידער וועלן פארשטיין, אז ה׳ גיט זיי ישועה דורך זיין האנט, זיי אבער האבן נישט פארשטאנען. ");
INSERT INTO ydd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","און דעם אנדערן טאג האט ער זיך באוויזן צו זיי, בשעת זיי האבן זיך געקריגט, און האט געוואלט מאכן שלום צווישן זיי, און געזאגט: מענער, איר זענט (דאך) ברידער, פארוואס טוט איר אן עוולה איינער דעם אנדערן? ");
INSERT INTO ydd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","און דער, וואס האט באעוולט זיין חבר, האט אים אפגעשטויסן, זאגנדיק: ווער האט דיך געשטעלט פאר א שר און א שופט איבער אונדז? ");
INSERT INTO ydd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","צי ווילסטו מיך הרגענען, אזוי, ווי דו האסט נעכטן געהרגעט דעם מצרי? ");
INSERT INTO ydd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","איז משה אנטלאפן איבער דעם דאזיקן ווארט און געווען א פרעמדער אינם לאנד פון מדין, וואו ער האט געבוירן צוויי זין. ");
INSERT INTO ydd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","און ווען פערציק יאר זענען דערפילט געווארן, האט זיך א מלאך באוויזן צו אים אין דער מדבר ביים בארג סיני אין א פלאם פייער פון דעם סנה. ");
INSERT INTO ydd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","און זעענדיק עס, האט משה זיך געוואונדערט איבער דער דערשיינונג; און בשעת ער איז צוגעגאנגען, זי צו באטראכטן, איז געקומען דאס קול פונם האר (ה׳): ");
INSERT INTO ydd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","איך בין דער ג‑ט פון דיינע אבות, דער ג‑ט פון אברהם, און דער ג‑ט פון יצחק, און דער ג‑ט פון יעקב. און משה האט געציטערט און זיך נישט אונטערגעשטעלט צו קוקן. ");
INSERT INTO ydd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","און דער האר האט צו אים געזאגט: נעם אראפ די שיך פון דיינע פיס, ווארום דאס ארט, אויף וועלכן דו שטייסט, איז הייליקע ערד. ");
INSERT INTO ydd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","זען האב איך געזען דאס ליידן פון מיין פאלק, וועלכעס איז אין מצרים, און האב געהערט זייער זיפצן, און בין אראפגענידערט זיי אויסצולייזן; און איצט קום, איך וועל דיך שיקן קיין מצרים. ");
INSERT INTO ydd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","דעם דאזיקן משה, וועמען זיי האבן פארלייקנט, זאגנדיק: ווער האט דיך געשטעלט פאר א שר און א שופט? אים האט ה׳ געשיקט ווי א שר און גואל, דורך דער האנט פון דעם מלאך, וואס האט זיך באוויזן צו אים אין דעם סנה. ");
INSERT INTO ydd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ער האט זיי ארויסגעפירט, טוענדיק אותות און מופתים אינם לאנד מצרים און אינם ים סוף און אין דער מדבר פערציק יאר לאנג. ");
INSERT INTO ydd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","דאס איז דער משה, וועלכער האט געזאגט צו די קינדער ישראל: א נביא וועט דער האר אייער ג‑ט אייך אויפשטעלן פון אייערע ברידער, גלייך צו מיר; אים זאלט איר הערן. (דברים יח, טו.) ");
INSERT INTO ydd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ער איז עס, וואס איז געווען אין דער עדה אין דער מדבר מיט דעם מלאך, וועלכער האט גערעדט צו אים אויפן בארג סיני, און מיט אונדזערע עלטערן; ער האט באקומען דברים חיים צו געבן צו אונדז; ");
INSERT INTO ydd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","צו וועמען אונדזערע פאטערס האבן נישט געוואלט זיין געהארכזאם, נאר האבן אים אפגעשטויסן און אין זייערע הערצער זיך געקערט קיין מצרים, ");
INSERT INTO ydd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","און געזאגט צו אהרנען: מאך אונדז ג‑טער, וואס זאלן גיין פאר אונדז; ווארום דער דאזיקער משה, וועלכער האט אונדז ארויסגעפירט אויס דעם לאנד מצרים, ווייסן מיר נישט וואס עס איז געשען צו אים. ");
INSERT INTO ydd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","און האבן געמאכט א קאלב אין יענע טעג, און געברענגט א קרבן צום אפג‑ט און זיך געפריידט מיט די מעשים פון זייערע הענט. ");
INSERT INTO ydd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","און ה׳ האט זיך אוועקגעקערט און זיי איבערגעגעבן צו דינען די הערשאפן פון הימל, אזויווי עס שטייט געשריבן אינם ספר פון די נביאים: צי האט איר מיר (דען) מקריב געווען זבחים און מנחות פערציק יאר אין דער מדבר, אָ בית ישראל? ");
INSERT INTO ydd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","און איר האט אויפגענומען דאס געצעלט פון מולך און דעם שטערן פון דעם ג‑ט רמפן (ראמפאן), די בילדער, וואס איר האט געמאכט, זיך צו בוקן צו זיי. און איך וועל אייך פארטרייבן אויף יענער זייט בבל. ");
INSERT INTO ydd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","דאס מישכן העדות איז געווען ביי אונדזערע עלטערן אין דער מדבר, אזויווי ער האט באפוילן, וועלכער האט גערעדט צו משהן, אז ער זאל עס מאכן לויט דעם געשטאלט, וואס ער האט געזען. ");
INSERT INTO ydd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","וועלכעס אונדזערע עלטערן מיט יהושע האבן גענומען און אויך אריינגעברענגט אין דעם אייגנטום פון די פעלקער, וואס ה׳ האט ארויסגעטריבן פון פאר אונדזערע עלטערנס פנים, ביז צו די טעג פון דוד; ");
INSERT INTO ydd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","וועלכער האט געפונען חן ביי ה׳, און האט געבעטן צו געפינען א געצעלט פאר דעם ג‑ט פון יעקב. ");
INSERT INTO ydd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","שלמה אבער האט געבויט פאר אים א הויז. ");
INSERT INTO ydd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","נאר דער אויבערשטער וואוינט נישט אין (הייזער), וואס זענען פון הענט געמאכט, ווי דער נביא זאגט: ");
INSERT INTO ydd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","דער הימל איז מיין טראן, און די ערד—דאס פוסבענקעלע פאר מיינע פיס; וואס פאר א הויז וועט איר מיר בויען? זאגט דער האר (ג‑ט); אדער וועלכעס איז דאס ארט פון מיין מנוחה? ");
INSERT INTO ydd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","צי האט דען נישט מיין האנט געמאכט די דאזיקע אלע זאכן? ");
INSERT INTO ydd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","איר הארטנעקיקע און (וואס האבן) נישט געמלטע הערצער און אויערן, איר שטעלט זיך תמיד אנטקעגן דעם רוח הקודש; ווי די עלטערן אייערע, אזוי איר. ");
INSERT INTO ydd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","וועמען פון די נביאים האבן אייערע עלטערן נישט גערודפט? און האבן געטייט די, וואס האבן פארויסגעזאגט וועגן דעם קומען פון דעם צדיק, וועמעס מוסרים און רוצחים איר זענט איצט געווארן; ");
INSERT INTO ydd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","איר, וועלכע האבן מקבל געווען די תורה דורך דער פארמיטלונג פון מלאכים, און האבן זי (דאך) נישט געהאלטן! ");
INSERT INTO ydd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","און הערנדיק דאס, האט עס זיי געשטאכן אין זייערע הערצער, און זיי האבן געקריצט מיט די ציין אויף אים. ");
INSERT INTO ydd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","און ער, זייענדיק פול מיט דעם רוח הקודש, האט ארויפגעבליקט צום הימל, און געזען דעם כבוד פון ה׳, און יהושען/ישוען שטיין אויף ה׳ס רעכטער זייט, ");
INSERT INTO ydd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","און האט געזאגט: אָט זע איך די הימלען געעפנט און דעם בר אנש שטיין אויף דער רעכטער זייט פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","און זיי האבן א געשריי געטאן מיט א הויך קול און זיך פארשטאפט די אויערן, און אלע אינאיינעם האבן זיך א ווארף געטאן אויף אים, ");
INSERT INTO ydd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","און אים ארויסגעשטויסן אויסער דער שטאט און געשטייניקט; און די עדות האבן אוועקגעלייגט זייערע מלבושים ביי די פיס פון א יונגנמאן, וואס האט געהייסן שאול. ");
INSERT INTO ydd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","און האבן געשטייניקט סטעפאנוסן, בשעת ער האט אויסגערופן און געזאגט: האר יהושע/ישוע, נעם אויף מיין גייסט. ");
INSERT INTO ydd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","און האט אנידערגעקניט און א געשריי געטאן מיט א הויך קול: האר, רעכן זיי נישט צו די דאזיקע זינד. און דאס זאגנדיק, איז ער איינגעשלאפן. ");
INSERT INTO ydd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","און שאול האט מסכים געווען צו זיין טויט. און יענעם טאג האט זיך אויפגעהויבן א גרויסע רדיפה אויף דער קהלה אין ירושלים; און אלע זענען צעשפרייט געווארן איבער די געגנטן פון יהודה און שומרון, מיטן אויסנאם פון די שליחים. ");
INSERT INTO ydd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","און ג‑טספארכטיקע לייט האבן גענומען סטעפאנוסן און אים קובר געווען, און געמאכט א גרויס הספד אויף אים. ");
INSERT INTO ydd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","שאול אבער האט חרוב געמאכט די קהלה, איז אריינגעגאנגען אין יעדן הויז, און געשלעפט מענער און פרויען און זיי איבערגעגעבן אין תפיסה אריין. ");
INSERT INTO ydd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","און די, וואס זענען צעשפרייט געווארן, זענען ארומגעגאנגען מבשר זייענדיק דאס ווארט. ");
INSERT INTO ydd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","און פיליפוס איז אראפגעגאנגען אין דער שטאט שומרון אריין, און האט אויסגערופן צו זיי דעם משיח. ");
INSERT INTO ydd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","און די מאסן האבן אלע אינאיינעם פארנומען מיט פלייס פיליפוסנס רייד, הערנדיק און זעענדיק די אותות, וואס ער האט געטאן. ");
INSERT INTO ydd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ווארום פון א סך פון די, וואס האבן געהאט אומריינע גייסטער, זענען (די דאזיקע) ארויס, שרייענדיק מיט א הויך קול, און א סך פאראליזשירטע און לאמע זענען געהיילט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","און עס איז געווארן א גרויסע שמחה אין יענער שטאט. ");
INSERT INTO ydd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","און א געוויסער מאן מיטן נאמען שמעון, וועלכער פלעגט זיך פריער אפגעבן מיט כשוף אין דער שטאט און האט דערשטוינט דאס פאלק פון שומרון, אויסגעבנדיק זיך פאר עפעס גרויס; ");
INSERT INTO ydd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","וואס צו אים האבן זיך אלע צוגעהערט, פון קליין ביז גרויס, און געזאגט: דער דאזיקער (מאן) איז די קראפט פון ג-ט, וואס מען רופט די גרויסע. ");
INSERT INTO ydd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","און זיי האבן זיך צוגעהערט צו אים, ווייל במשך פון א לענגערער צייט האט ער זיי דערשטוינט מיט די כישופים. ");
INSERT INTO ydd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ווען אבער זיי האבן געגלויבט פיליפוסן, וועלכער האט זיי אנגעזאגט די גוטע בשורה וועגן דעם קעניגרייך פון ה׳ און דעם נאמען פון יהושע/ישוע המשיח, האבן זיי זיך געלאזט טובל זיין אין דער מקווה, מענער און פרויען. ");
INSERT INTO ydd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","און דער שמעון אליין האט אויך געגלויבט; און ווערנדיק געטובלט אין דער מקווה, האט ער זיך באהאפטן צו פיליפוסן, און זעענדיק אותות און גרויסע מופתים געשען, האט ער זיך שטארק געוואונדערט. ");
INSERT INTO ydd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","און ווען די שליחים אין ירושלים האבן געהערט, אז שומרון האט אנגענומען ה׳ס ווארט, האבן זיי געשיקט צו זיי פעטרוסן און יוחנן; ");
INSERT INTO ydd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","וועלכע, אראפקומענדיק, האבן מתפלל געווען פאר זיי, אז זיי זאלן באקומען דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ווארום דער רוח הקודש איז נאך נישט געהאט געפאלן אויף קיין איינעם פון זיי; זיי זענען בלויז געווען געטובלט אין דער מקווה אינם נאמען פון דעם האר יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","דאן האבן זיי ארויפגעלייגט די הענט אויף זיי, און זיי האבן באקומען דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","און ווי שמעון האט געזען, אז דער רוח הקודש איז געגעבן געווארן דורך דעם ארויפלייגן די הענט פון די שליחים, האט ער געברענגט געלט צו זיי, ");
INSERT INTO ydd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","און געזאגט: גיט מיר אויך די דאזיקע מאכט, כדי ווען איך וועל ארויפלייגן די הענט אויף עמיצן, זאל ער באקומען דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","פעטרוס אבער האט צו אים געזאגט: דיין זילבער זאל בלייבן ביי דיר צו (דיין) פארדארבונג, ווייל דו האסט בדעה געהאט צו קויפן די מתנה פון ה׳ מיט געלט. ");
INSERT INTO ydd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","דו האסט נישט קיין חלק און נישט קיין נחלה אין דער דאזיקער זאך, ווארום דיין הארץ איז נישט אויפריכטיק פאר ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","דעריבער טו תשובה פון דער דאזיקער שלעכטסקייט דיינער, און טו תפילה צום האר (ה׳), אפשר וועט דיר פארגעבן ווערן די מחשבה פון דיין הארץ. ");
INSERT INTO ydd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ווארום איך זע, אז דו ביסט אין דער גאל פון ביטערקייט (ראש ולענה), און אין דעם בונד פון רשעות. (דברים כט, יז.) ");
INSERT INTO ydd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","און שמעון האט ענטפערנדיק געזאגט: זייט איר מתפלל פאר מיר צום האר (ג‑ט), אז קיין זאך זאל נישט קומען אויף מיר, פון וועלכע איר האט גערעדט. ");
INSERT INTO ydd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","און עדות זאגנדיק און רעדנדיק דאס ווארט פונם האר, האבן זיי זיך אומגעקערט קיין ירושלים, און אנגעזאגט (אונטערוועגנס) די גוטע בשורה אין פיל שומרונישע דערפער. ");
INSERT INTO ydd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","און א מלאך פון האר (ג‑ט) האט גערעדט צו פיליפוסן, אזוי צו זאגן: שטיי אויף, און גיי קיין דרום זייט אויף דעם וועג, וואס פירט אראפ פון ירושלים קיין עזה; דער זעלביקער איז וויסט. ");
INSERT INTO ydd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","און ער איז אויפגעשטאנען, און געגאנגען; און זע, א מאן, אן עטיאפיער, א סריס, א הויפט באאמטער ביי קאנדאקע, קעניגין פון די עטיאפיער—ער איז געווען איבער אלע אירע אוצרות—איז געקומען זיך צו בוקן (פאר ה׳) אין ירושלים; ");
INSERT INTO ydd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","און אומקערנדיק זיך (אהיים), און זיצנדיק אויף זיין רייטוואגן, האט ער געלייענט (דאס ספר פון) דעם נביא ישעיה. ");
INSERT INTO ydd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","און דער גייסט האט געזאגט צו פיליפוסן: גיי צו, און באהעפט דיך צו דעם דאזיקן רייטוואגן. ");
INSERT INTO ydd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","און פיליפוס איז צוגעלאפן, און געהערט אים לייענען דאס (ספר פון) ישעיה הנביא, און האט געזאגט: צי פארשטייסטו וואס דו לייענסט? ");
INSERT INTO ydd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","האט ער געזאגט: וויאזוי זאל איך קענען, ווען קיינער לערנט מיך נישט? און האט געבעטן פיליפוסן איינצושטייגן און זיך אנידערצוזעצן מיט אים. ");
INSERT INTO ydd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","און דער תוכן פון דער שריפט, וואס ער האט געלייענט איז געווען דאס דאזיקע: ווי א שאף צו דער שחיטה איז ער געפירט געווארן; און ווי א לאם פאר זיין שערער איז שטום, אזוי האט ער נישט אויפגעמאכט זיין מויל; ");
INSERT INTO ydd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","אין זיין דערנידעריקונג איז זיין משפט אוועקגענומען געווארן; און ווער וועט בארעכענען זיין דור? ווייל זיין לעבן איז אוועקגענומען געווארן פון דער ערד. ");
INSERT INTO ydd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","און דער סריס האט ענטפערנדיק געזאגט צו פיליפוסן: איך בעט דיך, וועגן וועמען רעדט דאס דער נביא? וועגן זיך אליין אדער וועגן אן אנדערן? ");
INSERT INTO ydd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","און פיליפוס האט אויפגעמאכט זיין מויל, און אנהויבנדיק פון דער דאזיקער שריפט, האט ער אים אנגעזאגט די גוטע בשורה פון יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","און ווי זיי זענען אזוי געפארן אויפן וועג, זענען זיי געקומען צו א וואסער; און דער סריס האט געזאגט: זע, א וואסער; וואס שטערט מיר געטובלט צו ווערן אין דער מקווה? ");
INSERT INTO ydd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","האט פיליפוס צו אים געזאגט: אויב דו גלויבסט מיטן גאנצן הארצן, מעגסטו. און ער האט ענטפערנדיק געזאגט: איך גלויב, אז יהושע/ישוע המשיח איז דער זון פון דער אויבערשטער. ");
INSERT INTO ydd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","און האט באפוילן אפצושטעלן דעם רייטוואגן, און ביידע זענען אראפגעגאנגען אין וואסער אריין, פיליפוס און דער סריס; און ער האט אים געטובלט אין דער מקווה, ");
INSERT INTO ydd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","און ווען זיי זענען ארויסגעשטיגן פונם וואסער, האט דער גייסט פון דעם האר פארטראגן פיליפוסן, און דער סריס האט אים שוין מער נישט געזען, און א פריילעכער איז ער זיך געפארן אויף זיין וועג. ");
INSERT INTO ydd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","פיליפוס אבער האט זיך געפונען אין אשדוד; און איז ארומגעגאנגען און האט אנגעזאגט די גוטע בשורה אין אלע שטעט, ביז ער איז געקומען קיין קיסריה. ");
INSERT INTO ydd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","שאול אבער האט נאך אלץ געאטעמט מיט דראונג און רציחה קעגן די תלמידים פון דעם האר, און איז געגאנגען צום כהן גדול, ");
INSERT INTO ydd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","און ביי אים געבעטן בריוו צו די שולן אין דמשק, כדי ווען ער וועט געפינען אייניקע, וואס האלטן זיך ביי דעם דרך (ה׳), סאי מענער סאי פרויען, זאל ער זיי ברענגען אין קייטן קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","און בשעת ער איז געפארן, איז געשען, אז ווען ער האט זיך דערנענטערט צו דמשק, האט פלוצלונג א ליכט פון הימל אים ארומגעשטראלט; ");
INSERT INTO ydd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","און ער איז אנידערגעפאלן אויף דער ערד, און געהערט א קול, וואס האט געזאגט צו אים: שאול, שאול, וואס פארפאלגסטו מיך? ");
INSERT INTO ydd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","האט ער געזאגט: ווער ביסטו, האר? און ער (האט געזאגט): איך בין יהושע/ישוע, וועמען דו פארפאלגסט. ");
INSERT INTO ydd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","נאר שטיי אויף, און גיי אריין אין דער שטאט, און עס וועט דיר געזאגט ווערן, וואס דו זאלסט טאן. ");
INSERT INTO ydd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","און די לייט, וואס האבן מיטגערייזט מיט אים, זענען (דערנאך) געבליבן שטיין אָן לשון, הערנדיק דאס קול, און נישט זעענדיק קיינעם. ");
INSERT INTO ydd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","און שאול האט זיך אויפגעהויבן פון דער ערד; און הגם די אויגן האבן זיך אים אויפגעמאכט, האט ער דאך גארנישט געזען; און מען האט אים אנגענומען ביי דער האנט, און אריינגעפירט קיין דמשק. ");
INSERT INTO ydd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","און דריי טעג איז ער געווען אָן ראיה; און האט נישט געגעסן און נישט געטרונקען. ");
INSERT INTO ydd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","און אין דמשק איז געווען א געוויסער תלמיד מיטן נאמען חנניה; און דער האר האט צו אים געזאגט אין א חזיון: חנניה! און ער האט געזאגט: אָט בין איך, האר! ");
INSERT INTO ydd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","און דער האר האט צו אים געזאגט: שטיי אויף, און גיי צו דער גאס, וואס מען רופט זי די גלייכע, און זוך אין יהודהס הויז שאולן מיטן צונאמען הטרסי, ווארום זע, ער טוט תפילה, ");
INSERT INTO ydd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","און האט געזען אין א חזיון א מאן, וועלכער הייסט חנניה, אריינקומען און ארויפלייגן די הענט אויף אים, כדי ער זאל ווידער זען. ");
INSERT INTO ydd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","האט חנניה געענטפערט: האר, איך האב געהערט פון פילע וועגן דעם דאזיקן מאן, וויפל שלעכטס ער האט געטאן צו דיינע קדושים אין ירושלים; ");
INSERT INTO ydd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","אויך דא האט ער רשות פון די הויפט כהנים צו בינדן אלע, וואס רופן אָן דיין נאמען. ");
INSERT INTO ydd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","דער האר אבער האט צו אים געזאגט: גיי, ווייל ער איז פאר מיר א כלי חפץ, צו טראגן מיין נאמען פאר די אומות און מלכים און קינדער ישראל; ");
INSERT INTO ydd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ווארום איך וועל אים ווייזן וואס ער וועט מוזן ליידן צוליב מיין נאמען. ");
INSERT INTO ydd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","און חנניה איז אוועק, און אריינגעגאנגען אין דעם הויז, האט ארויפגעלייגט די הענט אויף אים און געזאגט: ברודער שאול, דער האר האט מיך געשיקט, יהושע/ישוע, וואס האט זיך צו דיר באוויזן אויפן וועג, אויף וועלכן דו ביסט געפארן, כדי דו זאלסט ווידער זען און פול ווערן מיט דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","און גלייך זענען אראפגעפאלן פון זיינע אויגן עפעס ווי שופן, און ער האט ווידער געזען, און איז אויפגעשטאנען און זיך געלאזט טובל זיין אין דער מקווה; ");
INSERT INTO ydd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","און האט גענומען שפייז און זיך געשטארקט. און ער איז געווען אייניקע טעג מיט די תלמידים אין דמשק. ");
INSERT INTO ydd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","און האט גלייך אויסגערופן אין די שולן, אז יהושע/ישוע איז דער זון פון דער אויבערשטער. ");
INSERT INTO ydd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","און אלע, וואס האבן (אים) געהערט, זענען דערשטוינט געווארן, און האבן געזאגט: צי איז ער דען נישט דער דאזיקער, וואס פלעגט פארטיליקן אין ירושלים די, וועלכע האבן אנגערופן דעם דאזיקן נאמען? און איז אהערגעקומען פאר דעם זעלביקן צוועק, כדי זיי אוועקצופירן אין קייטן צו די הויפט כהנים? ");
INSERT INTO ydd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","שאול אבער האט זיך נאך מער געשטארקט, און האט צעמישט די יידן, וועלכע האבן געוואוינט אין דמשק, אויפווייזנדיק, אז דער דאזיקער איז דער משיח. ");
INSERT INTO ydd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","און ווען עס זענען פארביי א סך טעג, האבן די יידן זיך באראטן אים אומצוברענגען; ");
INSERT INTO ydd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","נאר זייער פארשווערונג איז באקאנט געווארן צו שאולן. און זיי האבן אפילו באוואכט די טויערן בייטאג און ביינאכט, כדי אים צו טייטן. ");
INSERT INTO ydd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","זיינע תלמידים אבער האבן אים גענומען ביינאכט, און אראפגעלאזט פון דער שטאטמויער, אראפנידערנדיק אים אין א קארב. ");
INSERT INTO ydd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","און ווען ער איז געקומען קיין ירושלים, האט ער געפרואווט זיך צו באהעפטן צו די תלמידים; און אלע האבן מורא געהאט פאר אים, נישט גלויבנדיק, אז ער איז א תלמיד. ");
INSERT INTO ydd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","בר‑נבא אבער האט אים גענומען, און אוועקגעפירט צו די שליחים, און זיי דערציילט, וויאזוי ער האט געזען דעם האר אויפן וועג, און אז ער האט צו אים גערעדט, און ווי ער האט מיט דרייסטקייט גערעדט אין דמשק אין ישועס נאמען. ");
INSERT INTO ydd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","און ער איז געווען מיט זיי, א יוצא ונכנס אין ירושלים, אויפטרעטנדיק מיט דרייסטקייט אין דעם הארס נאמען; ");
INSERT INTO ydd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","און האט גערעדט און זיך מתווכח געווען מיט גריכישע יידן; זיי אבער האבן געזוכט אים א מעשה אנצוטאן. ");
INSERT INTO ydd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","און ווי די ברידער האבן זיך דערוואוסט, האבן זיי אים אראפגעפירט קיין קיסריה און אים אוועקגעשיקט קיין טרסוס. ");
INSERT INTO ydd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","און די קהילה איבער גאנץ יהודה און גליל און שומרון האט געהאט שלום. איז דערבויט געווארן; און איז געגאנגען אין דער פורכט פון דעם האר; און דורך דער טרייסט פון דעם רוח הקודש האט זי זיך פארמערט. ");
INSERT INTO ydd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","און עס איז געשען, בשעת פעטרוס איז געגאנגען פון ארט צו ארט, איז ער אויך געקומען צו די קדושים, וואס האבן געוואוינט אין לוד. ");
INSERT INTO ydd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","און דארטן האט ער געפונען א געוויסן מענטשן מיטן נאמען ענעאס, וועלכער איז שוין געלעגן אכט יאר לאנג צו בעט; ווייל ער איז געווען פאראליזשירט. ");
INSERT INTO ydd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","און פעטרוס האט צו אים געזאגט: ענעאס, יהושע/ישוע המשיח מאכט דיך געזונט; שטיי אויף און מאך דיר דאס בעט! און ער איז גלייך אויפגעשטאנען. ");
INSERT INTO ydd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","און אלע איינוואוינער פון לוד און שרון האבן אים געזען און האבן זיך געקערט צום האר (אין גלויבן). ");
INSERT INTO ydd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","און אין יפו איז געווען א תלמידה מיטן נאמען טביתא, אויף א (גריכישער) איבערזעצונג האט מען זי גערופן דארקאס; זי איז געווען פול מיט מעשים טובים און צדקות, וואס זי האט געטאן. ");
INSERT INTO ydd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","און עס איז געשען אין יענע טעג, (דאס) זי איז קראנק געווארן און געשטארבן, און מען האט זי אפגעוואשן און געלייגט אין אן אויבערשטיבל. ");
INSERT INTO ydd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","און אזויווי לוד איז נאענט ביי יפו, ווייל די תלמידים האבן געהערט, אז פעטרוס געפינט זיך דארטן, האבן זיי געשיקט צוויי מענער צו אים און געבעטן: פארזאם דיך נישט צו קומען צו אונדז. ");
INSERT INTO ydd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","און פעטרוס איז אויפגעשטאנען און מיטגעגאנגען מיט זיי. ווען ער איז אהינגעקומען, האבן זיי אים ארויפגעפירט אין אויבערשטיבל אריין; און אלע אלמנות האבן זיך ארומגעשטעלט ארום אים, וויינענדיק און ווייזנדיק אים העמדער און קליידער, וואס דארקאס האט געמאכט, ווען זי איז נאך געווען מיט זיי. ");
INSERT INTO ydd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","פעטרוס אבער האט אלעמען ארויסגעשיקט אינדרויסן, האט גענייגט די קניען און תפילה געטאן, און זיך דאן געווענדט צום קערפער און געזאגט: טביתא, שטיי אויף! און זי האט אויפגעמאכט אירע אויגן, און זעענדיק פעטרוסן, האט זי זיך אויפגעזעצט. ");
INSERT INTO ydd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","און ער האט איר געגעבן די האנט און זי אויפגעשטעלט, און גערופן די קדושים און די אלמנות, און זי אוועקגעשטעלט פאר זיי א לעבעדיקע. ");
INSERT INTO ydd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","און דאס איז באקאנט געווארן איבער גאנץ יפו, און א סך האבן געגלויבט אין דעם האר. ");
INSERT INTO ydd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","און עס איז געשען, אז במשך פון מערערע טעג איז ער איינגעשטאנען אין יפו ביי א געוויסן שמעון, א גארבער. ");
INSERT INTO ydd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","און עס איז געווען א מאן אין קיסריה מיטן נאמען קארנעליוס, אן אפיציר פון דער אפטיילונג, וואס האט געהייסן די איטאליענישע, ");
INSERT INTO ydd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","א פרומער (מענטש) און א ירא שמים מיט זיין גאנץ בני בית, טוענדיק פיל צדקה צום פאלק און תמיד מתפלל זייענדיק צו ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ער האט באשיימפערלעך געזען אין א חזיון, ווי ארום דער ניינטער שעה פונם טאג איז א מלאך פון ה׳ אריינגעקומען צו אים, און צו אים געזאגט: קארנעליוס! ");
INSERT INTO ydd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","און ער האט א בליק געטאן אויף אים און זיך געפארכטן, און געזאגט: וואס איז עס, האר? און ער האט צו אים געזאגט: דיינע תפילות און דיינע צדקות זענען ארויפגעקומען לזכרון פאר ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","און איצט שיק מענער קיין יפו און לאז רופן שמעונען, וועלכן מען רופט פעטרוס; ");
INSERT INTO ydd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ער שטייט איין ביי א געוויסן שמעון, א גארבער, וועמעס הויז איז ביים ים. ");
INSERT INTO ydd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","און ווי דער מלאך, וואס האט גערעדט צו אים, איז אוועק, האט ער גערופן צוויי פון זיינע דינער, און א ג‑טספארכטיקן זעלנער פון די, וועלכע זענען תמיד ביי אים געווען; ");
INSERT INTO ydd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","און האט זיי אלץ דערקלערט, און זיי אוועקגעשיקט קיין יפו. ");
INSERT INTO ydd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","און אויף צומארגנס, בשעת זיי זענען געווען אויפן וועג, און האבן זיך דערנענטערט צו דער שטאט, איז פעטרוס ארויפגעשטיגן אויפן דאך, תפילה צו טאן, ארום דער זעקסטער שעה; ");
INSERT INTO ydd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","און איז הונגעריק געווארן, און געוואלט (עפעס) טועם זיין; נאר בשעת מען האט צוגעגרייט (דאס עסן), איז געפאלן אויף אים אן טראנס; ");
INSERT INTO ydd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","און ער האט געזען דעם הימל אויפגעמאכט, און עפעס א געפעס אראפקומען, ווי א גרויס ליילעך, אנגעבונדן אויף די פיר עקן, און אראפגעלאזט אויף דער ערד; ");
INSERT INTO ydd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","אין וועלכן עס האבן זיך געפונען אלע פירפיסיקע חיות און שרצים פון דער ערד און פייגל פון הימל. ");
INSERT INTO ydd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","און עס איז געקומען א קול צו אים: שטיי אויף, פעטרוס, שחט און עס. ");
INSERT INTO ydd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","פעטרוס אבער האט געזאגט: האר, בשום אופן נישט, ווייל איך האב נאך קיינמאל נישט געגעסן וואס איז טמא און טריפה. ");
INSERT INTO ydd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","און ווידער איז א קול געקומען צו אים צום צווייטן מאל: וואס ה׳ האט ריין געמאכט, דאס זאלסטו נישט (רופן) טמא. ");
INSERT INTO ydd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","און דאס איז געשען דריי מאל; און גלייך איז דאס געפעס ארויפגענומען געווארן אין הימל אריין. ");
INSERT INTO ydd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","און בשעת פעטרוס האט נישט געוואוסט וויאזוי זיך צו דערקלערן, וואס עס קען זיין די דערשיינונג, וועלכע ער האט געזען, זע, די מענער, וואס זענען געשיקט געווארן פון קארנעליוסן, האבנדיק זיך נאכגעפרעגט וועגן שמעונס הויז, זענען געשטאנען ביים טויער, ");
INSERT INTO ydd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","און האבן גערופן און געפרעגט, צי שמעון, וועמען מען רופט פעטרוס, שטייט דא איין. ");
INSERT INTO ydd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","און בשעת פעטרוס האט נאכגעטראכט וועגן דעם חזיון, האט דער גייסט צו אים געזאגט: זע, דריי מענער זוכן דיך. ");
INSERT INTO ydd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","נאר שטיי אויף, גיי אראפ, און פאר מיט זיי, צווייפל גארנישט; ווייל איך האב זיי געשיקט. ");
INSERT INTO ydd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","און פעטרוס איז אראפגעגאנגען צו די מענער, און האט געזאגט: אָט בין איך, וועמען איר זוכט; וואס פאר א סיבה איז עס, צוליב וועלכער איר זענט געקומען? ");
INSERT INTO ydd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","האבן זיי געזאגט: קארנעליוס, אן אפיציר, אן איש צדיק און ירא שמים, און וואס האט א גוטן שם ביים גאנצן יידישן פאלק, האט באקומען א באפעל פון א הייליקן מלאך, צו שיקן דיך רופן אין זיין הויז אריין, און צו הערן רייד פון דיר. ");
INSERT INTO ydd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","דעמאלט האט פעטרוס זיי אריינגערופן און אויפגענומען גאסטפריינדלעך. און צומארגנס איז ער אויפגעשטאנען און איז אוועק מיט זיי, און אייניקע פון די ברידער אין יפו זענען מיטגעגאנגען מיט אים. ");
INSERT INTO ydd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","און דעם אנדערן טאג זענען זיי אריינגעקומען קיין קיסריה. קארנעליוס אבער האט שוין געווארט אויף זיי, האבנדיק צוזאמענגערופן זיינע קרובים און די אינטימע פריינד. ");
INSERT INTO ydd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","און עס איז געשען, בשעת פעטרוס איז אריינגעקומען, אז אנטקעגנגייענדיק אים, איז קארנעליוס אנידערגעפאלן פאר זיינע פיס און האט זיך געבוקט. ");
INSERT INTO ydd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","פעטרוס אבער האט אים אויפגעהויבן, און געזאגט: שטיי אויף; איך אליין בין אויך נאר א מענטש. ");
INSERT INTO ydd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","און רעדנדיק מיט אים, איז ער אריינגעגאנגען, און האט געפונען א סך צונויפגעקומענע; ");
INSERT INTO ydd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","און האט צו זיי געזאגט: איר ווייסט אליין ווי עס איז אסור פאר א יידן זיך צו באהעפטן אדער צו קומען צו איינעם פון א פרעמד פאלק; נאר ה׳ האט מיר געוויזן, קיין מענטשן נישט צו רופן געמיין אדער טמא. ");
INSERT INTO ydd_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","היות איך בין גערופן געווארן, בין איך דערפאר געקומען אָן איינווענד. איך פרעג דעריבער, צוליב וואס האט איר מיך געלאזט רופן? ");
INSERT INTO ydd_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","און קארנעליוס האט געזאגט: מיט פיר טעג צוריק ביז צו דער דאזיקער שעה, דער ניינטער, האב איך תפילה געטאן אין מיין הויז; און זע פאר מיר איז געשטאנען א מאן אין שיינענדיקע מלבושים, ");
INSERT INTO ydd_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","און האט געזאגט; קארנעליוס, דיין תפילה איז דערהערט געווארן, און דיינע צדקות זענען דערמאנט געווארן פאר ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","שיק דעריבער קיין יפו, און לאד איין שמעונען, וועלכן מען רופט פעטרוס; ער שטייט איין אינם הויז פון שמעון, א גארבער, ביים ים. ");
INSERT INTO ydd_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","דעריבער האב איך גלייך געשיקט צו דיר; און דו האסט גוט געטאן, וואס ביסט געקומען. און איצט זענען מיר אלע דא פאר ה׳, כדי צו הערן אלץ, וואס איז דיר באפוילן געווארן פונם האר. ");
INSERT INTO ydd_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","און פעטרוס, האט אויפגעמאכט זיין מויל און געזאגט: אויף אן אמת בין איך משיג, אז ה׳ איז נישט קיין נושא פנים; ");
INSERT INTO ydd_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","נאר אין יעדן פאלק, ווער עס פארכט זיך פאר אים און טוט צדקה, איז אנגענומען ביי אים. ");
INSERT INTO ydd_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","דאס ווארט, וואס ער האט געשיקט צו די קינדער ישראל, מבשר זייענדיק שלום דורך יהושע/ישוע המשיחן—ער איז האר איבער אלע— ");
INSERT INTO ydd_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","קענט איר; און איר קענט די זאך, וואס איז געשען איבערן גאנצן (לאנד) יהודה, וועלכע האט זיך אנגעהויבן פון גליל נאך דער מקווה, וואס יוחנן האט אויסגערופן— ");
INSERT INTO ydd_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ווי ה׳ האט געזאלבט יהושען/ישוען פון נצרת מיט דעם רוח הקודש און מיט גבורה; וועלכער איז ארומגעגאנגען, טוענדיק גוטס און היילנדיק אלע, וואס זענען געווען אונטער דער מאכט פונם שׂטן, ווייל ה׳ איז געווען מיט אים. ");
INSERT INTO ydd_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","און מיר זענען עדות וועגן אלעם, וואס ער האט געטאן אין דעם לאנד יהודה און אין ירושלים; אים האבן זיי אויך אומגעבראכט, אויפהענגענדיק אים אויף א בוים. ");
INSERT INTO ydd_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","דעם דאזיקן האט ה׳ אויפגעוועקט דעם דריטן טאג, און אים געגעבן אנטפלעקט צו ווערן, ");
INSERT INTO ydd_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","(דאך) נישט צום גאנצן פאלק, נאר צו עדות, וועלכע זענען פארויס אויסדערוויילט געווארן פון ה׳, צו אונדז, וואס האבן געגעסן און געטרונקען מיט אים נאך זיין אויפשטיין פון די טויטע. ");
INSERT INTO ydd_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","און ער האט אונדז באפוילן אויסצורופן צום פאלק און עדות צו זאגן, אז ער איז דער פון ה׳ באשטימטער שופט פון די לעבעדיקע און טויטע. ");
INSERT INTO ydd_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","אויף אים זאגן אלע נביאים עדות, אז יעדערער, וואס גלויבט אין אים, וועט דורך זיין נאמען באקומען די פארגעבונג פון זינד. ");
INSERT INTO ydd_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","בשעת פעטרוס האט נאך גערעדט די דאזיקע ווערטער, איז דער רוח הקודש געפאלן אויף אלע, וואס האבן געהערט דאס ווארט. ");
INSERT INTO ydd_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","און די געמלטע (ד. ה. די יידישע) מאמינים, וועלכע זענען מיטגעקומען מיט פעטרוסן, האבן געשטוינט, אז אפילו אויף די אומות (העולם) איז אויסגעגאסן געווארן די מתנה פון דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ווארום זיי האבן זיי געהערט רעדן מיט לשונות און אפגעבן כבוד צו ה׳. דעמאלט האט פעטרוס געענטפערט: ");
INSERT INTO ydd_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","צי קען דען עמיצער פארווערן דאס וואסער, אז עס זאלן נישט געטובלט ווערן אין דער מקווה די דאזיקע, וועלכע האבן באקומען דעם רוח הקודש, פונקט אזוי ווי מיר? ");
INSERT INTO ydd_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","און ער האט זיי באפוילן זיך צו לאזן טובל זיין אין דער מקווה אין דעם נאמען פון יהושע/ישוע המשיחן. דעמאלט האבן זיי אים געבעטן, נאך צו פארבלייבן אייניקע טעג. ");
INSERT INTO ydd_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","און די שליחים און די ברידער, וועלכע זענען געווען אין יהודה, האבן געהערט, אז אויך די אומות (העולם) האבן אנגענומען ה׳ס ווארט. ");
INSERT INTO ydd_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","און ווען פעטרוס איז ארויפגעקומען קיין ירושלים, האבן די געמלטע זיך געצאנקט מיט אים, זאגנדיק: ");
INSERT INTO ydd_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","דו ביסט אריינגעגאנגען צו ערלים, און האסט געגעסן מיט זיי. ");
INSERT INTO ydd_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","פעטרוס אבער האט אנגעהויבן און זיי דערציילט כסדר, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","איך בין געווען אין דער שטאט יפו און האב תפילה געטאן, און אין א טראנס האב איך געזען א חזיון, עפעס א געפעס איז אראפגעקומען ווי א גרויס ליילעך, אראפגעלאזט פון הימל ביי די פיר עקן; און עס איז געקומען צו מיר; ");
INSERT INTO ydd_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","אין וועלכן איך האב זיך איינגעקוקט און באמערקט, און געזען די פירפיסיקע (בהמות) פון דער ערד און די חיות און שרצים און די פייגל פון הימל. ");
INSERT INTO ydd_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","און האב געהערט א קול זאגן צו מיר: שטיי אויף, פעטרוס, שעכט און עס. ");
INSERT INTO ydd_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","איך אבער האב געזאגט: בשום אופן נישט, האר, ווייל קיין שום טמא אדער טריפה זאך איז (נאך) קיינמאל נישט אריינגעגאנגען אין מיין מויל. ");
INSERT INTO ydd_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","און צום צווייטן מאל האט א קול פון הימל מיר געענטפערט: וואס ה׳ האט ריין געמאכט, זאלסטו נישט מטמא זיין. ");
INSERT INTO ydd_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","דאס דאזיקע איז געשען דריימאל, און אלץ איז ווידער ארויפגענומען געווארן אין הימל אריין. ");
INSERT INTO ydd_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","און זע, אין אן אויגנבליק זענען געשטאנען דריי מענטשן ביים הויז, אין וועלכן מיר זענען געווען, וואס זענען געשיקט געווארן פון קיסריה צו מיר. ");
INSERT INTO ydd_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","און דער גייסט האט געזאגט צו מיר, איך זאל מיטגיין מיט זיי, און זיך גארנישט ווייגערן. און די דאזיקע זעקס ברידער זענען מיטגעגאנגען מיט מיר, און מיר זענען אריינגעגאנגען אין דעם מאנס הויז; ");
INSERT INTO ydd_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","און ער האט אונדז דערציילט, ווי ער האט געזען דעם מלאך אין זיין הויז שטיין און זאגן: שיק קיין יפו און ברענג שמעונען, וועמען מען רופט פעטרוס, ");
INSERT INTO ydd_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","וועלכער וועט רעדן צו דיר ווערטער, דורך וועלכע דו וועסט געהאלפן ווערן און דיין גאנץ הויז. ");
INSERT INTO ydd_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","און ווען איך האב אנגעהויבן צו רעדן, איז דער רוח הקודש געפאלן אויף זיי, פונקט אזוי ווי אין אנהויב אויף אונדז. ");
INSERT INTO ydd_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","און איך האב מיך דערמאנט דעם הארס ווארט, ווי ער האט געזאגט: יוחנן האט טאקע געטובלט מיט וואסער אין דער מקווה, איר אבער וועט געטובלט ווערן אין דער מקווה מיט דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","דעריבער אויב ה׳ האט זיי געגעבן די זעלביקע מתנה, ווי אויך צו אונדז, די מאמינים אין דעם האר יהושע/ישוע המשיח, ווער בין איך, וואס זאל קענען פארווערן ה׳? ");
INSERT INTO ydd_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","און הערנדיק דאס, זענען זיי שטיל געווארן און האבן געלויבט ה׳, אזוי צו זאגן: באמת, ה׳ האט אויך צו אומות (העולם) געגעבן די תשובה צום לעבן. ");
INSERT INTO ydd_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","און די, וועלכע זענען צעשפרייט געווארן צוליב דער רדיפה, וואס איז געשען איבער סטעפאנוסן, זענען אוועק ביז פעניציען און קפריסין און אנטיאכיען, נישט רעדנדיק דאס ווארט צו קיינעם אחוץ בלויז צו יידן. ");
INSERT INTO ydd_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","עס זענען אבער געווען אייניקע פון זיי, מענער פון קפריסין און קירניה, וואס, ווען זיי זענען געקומען קיין אנטיאכיען, האבן גערעדט אפילו צו גריכן, אנזאגנדיק די גוטע בשורה פון דעם האר יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","און די האנט פון דעם האר איז געווען מיט זיי, און א גרויסע צאל האבן געגלויבט און זיך געקערט צום האר. ");
INSERT INTO ydd_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","און די זאך וועגן זיי איז געהערט געווארן אין די אויערן פון דער קהילה, וועלכע איז געווען אין ירושלים, און זיי האבן ארויסגעשיקט בר‑נבאן קיין אנטיאכיען; ");
INSERT INTO ydd_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","וועלכער האט זיך געפריידט, ווען ער איז אהינגעקומען און געזען דעם חסד פון ה׳; און האט אלעמען מזהיר געווען, זיך צו באהעפטן צום האר מיט אן אנטשלאסן הארץ; ");
INSERT INTO ydd_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ווייל ער איז געווען אן איש טוב און אנגעפילט מיט דעם רוח הקודש און מיט אמונה; און אן אנגעזעענער המון מענטשן האט זיך אונטערטעניק געמאכט צום האר. ");
INSERT INTO ydd_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","און ער איז ארויסגעגאנגען קיין טרסוס אויפצוזוכן שאולן; ");
INSERT INTO ydd_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","און געפינענדיק אים, האט ער אים אוועקגעפירט קיין אנטיאכיען. און עס איז געשען, במשך פון א גאנץ יאר האבן זיי זיך פארזאמלט אין דער קהלה און געלערנט א גרויסן עולם מענטשן; און צוערשט אין אנטיאכיען האט מען די תלמידים גערופן משיחיסטים. ");
INSERT INTO ydd_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","אין די דאזיקע טעג זענען אראפגעקומען נביאים פון ירושלים קיין אנטיאכיען. ");
INSERT INTO ydd_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","און איינער פון זיי מיטן נאמען אגאבוס איז אויפגעשטאנען און האט געוויזן דורך דעם רוח הקודש, אז עס וועט זיין א גרויסער הונגער אין דער גאנצער וועלט; וואס איז געקומען אין די טעג פון קלוידיוס. ");
INSERT INTO ydd_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","און די תלמידים האבן באשלאסן, אז יעדער איינער פון זיי, לויט זיינע מעגלעכקייטן, זאל שיקן צו דער אונטערשטיצונג פון די ברידער, וועלכע וואוינען אין יהודה. ");
INSERT INTO ydd_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","דאס האבן זיי אויך געטאן, שיקנדיק עס צו די זקנים דורך דער האנט פון בר‑נבא און שאול. ");
INSERT INTO ydd_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","און ארום יענער צייט האט דער קעניג הורדוס אויסגעשטרעקט די הענט צו פייניקן אייניקע פון דער קהלה. ");
INSERT INTO ydd_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","און האט געטייט יעקבן, יוחננס ברודער, מיט דער שווערד. ");
INSERT INTO ydd_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","און זעענדיק, אז עס איז געפעלן די יידן, האט ער געמערט צו ארעסטירן פעטרוסן אויך. און עס זענען (דעמאלט) געווען די טעג פונם חג המצות. ");
INSERT INTO ydd_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","און נעמענדיק אים געפאנגען, האט ער אים איינגעזעצט אין תפיסה, איבערגעבנדיק אים צו פיר אפטיילונגען זעלנער, יעדע פון פיר מאן, צו היטן, האבנדיק בדעה נאך פסח אים ארויסצופירן פארן פאלק. ");
INSERT INTO ydd_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","פעטרוס איז דעריבער באוואכט געווארן אין דעם געפענקעניש, און די קהלה האט זייער ערנסט מתפלל געווען פאר אים צו ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","און ווען הורדוס האט אים שוין געזאלט ארויספירן, איז פעטרוס יענע נאכט געשלאפן צווישן צוויי זעלנער, מיט צוויי קייטן געבונדן; און לייט אויף דער וואך ביי דער טיר האבן געהיטן די תפיסה. ");
INSERT INTO ydd_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","און זע, א מלאך פונם האר איז געקומען, און א ליכט האט אויפגעלויכטן אין דער קאמער; און ער האט א קלאפ געטאן פעטרוסן אויף דער זייט און אים אויפגעוועקט, און געזאגט: שטיי אויף געשווינד. און די קייטן זענען אים אראפגעפאלן פון די הענט. ");
INSERT INTO ydd_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","און דער מלאך האט צו אים געזאגט: גארטל דיך אונטער און טו אָן דיינע שיך. און ער האט אזוי געטאן. און ער האט צו אים געזאגט: היל דיך איין אין דיין מלבוש און פאלג מיר נאך. ");
INSERT INTO ydd_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","און ער איז ארויסגעגאנגען און האט נאכגעפאלגט; און נישט געוואוסט, אז עס איז אמת, וואס איז געשען דורך דעם מלאך, נאר האט געמיינט, ער זעט א חזיון. ");
INSERT INTO ydd_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","און ווען זיי זענען דורכגעגאנגען די ערשטע וואך און די צווייטע, זענען זיי געקומען צו דעם אייזערנעם טויער, וואס פירט אין דער שטאט אריין; פון זיך אליין האט עס זיך אויפגעמאכט פאר זיי; און זיי זענען ארויסגעגאנגען אינדרויסן און זענען דורכגעגאנגען איין גאס; און פלוצלונג האט זיך דער מלאך אפגעשיידט פון אים. ");
INSERT INTO ydd_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","און קומענדיק צו זיך, האט פעטרוס געזאגט: איצט ווייס איך באמת, אז דער האר האט ארויסגעשיקט זיין מלאך און מיך מציל געווען פון דער האנט פון הורדוס און דעם גאנצן פלאן פון יידישן פאלק. ");
INSERT INTO ydd_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","און ער האט זיך מישב געווען, און איז אוועק צום הויז פון מרים, די מוטער פון יוחנן, וועמען מען האט גערופן מארקוס, וואו א סך זענען געווען פארזאמלט און האבן תפילה געטאן. ");
INSERT INTO ydd_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","און ווען ער האט אנגעקלאפט אין דער טיר פונם טויער, איז א דינסטמיידל—זי האט געהייסן ראדא—ארויסגעקומען הערן. ");
INSERT INTO ydd_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","און דערקענענדיק פעטרוסנס קול, האט זי אויס פרייד אים נישט אויפגעמאכט דאס טויער, נאר איז אריינגעלאפן און האט דערציילט, אז פעטרוס שטייט ביים טויער. ");
INSERT INTO ydd_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","זיי אבער האבן צו איר געזאגט: דו ביסט משוגע. און זי האט זיך געהאלטן ביי אירס, אז עס איז אזוי (ווי זי האט געזאגט). האבן זיי געזאגט: עס איז זיין מלאך. ");
INSERT INTO ydd_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","פעטרוס אבער האט געהאלטן אין איין קלאפן, און ווען זיי האבן אויפגעעפנט און אים דערזען, זענען זיי דערשטוינט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","און ער האט זיי געגעבן א צייכן מיט דער האנט, זיי זאלן שווייגן, און זיי דערציילט, וויאזוי דער האר האט אים ארויסגעפירט פון תפיסה. און האט געזאגט: זאגט עס יעקבן און די ברידער. און ארויסגייענדיק, איז ער אוועק אויף אן אנדער ארט. ");
INSERT INTO ydd_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ווען אבער עס איז געווארן טאג, איז געווארן נישט קיין קליינע בהלה צווישן די זעלנער, וואס האט עס געקענט געשען מיט פעטרוסן? ");
INSERT INTO ydd_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","הורדוס אבער, זוכנדיק אים און נישט געפינענדיק, האט אויסגעפארשט די שומרים, און געגעבן א באפעל, מען זאל זיי אוועקפירן געטייט צו ווערן. און איז אראפגעגאנגען פון יהודה קיין קיסריה און האט זיך דארט אויפגעהאלטן. ");
INSERT INTO ydd_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","און ער איז געווען שרעקלעך אויפגעבראכט אויף די לייט פון צור און צידון, און אלע צוזאמען זענען געקומען צו אים, און נאך דעם ווי זיי האבן איבערגערעדט בלאסטוס, דעם שר איבער דעם מלכס שלאפצימער, האבן זיי געבעטן צו מאכן שלום, צוליב דעם וואס זייער לאנד איז גענערט געווארן פון דעם קעניגס לאנד. ");
INSERT INTO ydd_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","און אין א פעסטגעזעצטן טאג האט הורדוס, געקליידט אין קעניגלעכע מלבושים, זיך אנידערגעזעצט אויפן טראן און געהאלטן א רעדע פאר זיי. ");
INSERT INTO ydd_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","און דאס פאלק האט געשריגן: עס איז דאס קול פון א ג-ט און נישט פון קיין מענטשן! ");
INSERT INTO ydd_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","און פלוצלונג האט א מלאך פון דעם האר אים א שלאג געטאן, דערפאר וואס ער האט נישט אפגעגעבן דעם כבוד צו ה׳; און ווערנדיק אויפגעפרעסן פון ווערעם, איז ער אויסגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ה׳ס ווארט אבער איז געוואקסן און זיך פארמערט. ");
INSERT INTO ydd_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","און בר‑נבא און שאול האבן זיך אומגעקערט פון ירושלים, האבנדיק דערפילט זייער שליחות, און מיטנעמענדיק דעם יוחנן, וועמען מען האט גערופן מארקוס. ");
INSERT INTO ydd_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","און עס זענען געווען אין אנטיאכיען, אין דער דארטיקער קהילה, נביאים און מלמדים, בר‑נבא און שמעון, וואס האט געהייסן ניגער, און לוקיוס דער פון קירניה און מנחם, וועלכער איז דערצויגן געווארן צוזאמען מיט הורדוסן דעם טעטרארך, און שאול. ");
INSERT INTO ydd_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","און בשעת זיי האבן געדינט ה׳ און געפאסט, האט דער רוח הקודש געזאגט: שיידט מיר אפ בר‑נבאן און שאולן צו דער ארבעט, צו וועלכער איך האב זיי גערופן. ");
INSERT INTO ydd_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","דעמאלט, נאכן תענית און תפילה טאן, האבן זיי ארויפגעלייגט די הענט אויף זיי, און זיי אוועקגעשיקט. ");
INSERT INTO ydd_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","און ווערנדיק ארויסגעשיקט דורך דעם רוח הקודש, זענען זיי אראפגעגאנגען קיין סעלעאוציען, און פון דארטן האבן זיי זיך אוועקגעשיפט קיין קפריסין. ");
INSERT INTO ydd_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","און ווען זיי זענען אנגעקומען קיין סאלאמיס, האבן זיי אנגעזאגט ה׳ס ווארט אין די יידישע שולן; און האבן אויך געהאט יוחנן אלס משרת. ");
INSERT INTO ydd_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","און ווען זיי זענען דורכגעגאנגען די גאנצע אינדזל ביז פאפוס, האבן זיי געפונען א געוויסן מאן, א כישוף מאכער, א ייד, א פאלשער נביא, מיטן נאמען בר‑ישוע, ");
INSERT INTO ydd_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","וועלכער איז געווען ביי דעם פראקאנסול סערגיוס פוילוס, אן אינטעליגענט מאן. דער דאזיקער האט גערופן צו זיך בר‑נבאן און שאולן און פארלאנגט צו הערן ה׳ס ווארט. ");
INSERT INTO ydd_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","נאר עלימאס, דער כישוף מאכער (ווארום דאס איז די אראביש גריכישע באטייטונג פון זיין נאמען), האט זיך זיי אקייגנגעשטעלט, זוכנדיק אוועקצוקערן דעם פראקאנסול פון דער אמונה. ");
INSERT INTO ydd_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","שאול אבער, וועלכער הייסט אויך פוילוס, אנגעפילט מיט דעם רוח הקודש, האט שארף געקוקט אויף אים, ");
INSERT INTO ydd_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","און געזאגט: דו, וועלכער ביסט פול מיט יעדער כיטרעקייט און נידערטרעכטיקייט, דו זון פון דעם טייוול, שונא פון יעדער גערעכטיקייט, צי וועסטו נישט אויפהערן צו פארקרימען די רעכטע וועגן פון דעם האר (ה׳)? ");
INSERT INTO ydd_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","און איצט אָט זע, די האנט פון דעם האר איז אויף דיר, און דו וועסט זיין בלינד, וועסט נישט זען די זון ביז אויף א צייט. און אין אן אויגנבליק איז אויף אים געפאלן א טונקלקייט און א פינצטערניש, און ער איז ארומגעגאנגען און האט געזוכט (אזעלכע, וואס) זאלן אים פירן ביי דער האנט. ");
INSERT INTO ydd_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","און דעמאלט, ווי דער פראקאנסול האט געזען וואס איז פארגעקומען, האט ער געגלויבט, שטוינענדיק איבער דער לערנונג פון דעם האר. ");
INSERT INTO ydd_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","און פוילוס און זיינע באגלייטער האבן זיך אוועקגעשיפט פון פאפוס און זענען געקומען קיין פערגא אין פאמפיליען, און יוחנן האט זיך אפגעטיילט פון זיי און אומגעקערט קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","זיי אבער זענען ווייטער געגאנגען פון פערגא, און זענען געקומען קיין אנטיאכיען אין (לאנד) פיסידיען; און שבת זענען זיי אריינגעגאנגען אין דער שול און האבן זיך אנידערגעזעצט. ");
INSERT INTO ydd_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","און נאכן לייענען די תורה און די נביאים, האבן די גבאים פון דער שול געשיקט צו זיי, אזוי צו זאגן: ברידער, אויב איר האט עפעס א ווארט פון מוסר פאר דעם עולם, זאגטס. ");
INSERT INTO ydd_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","און פוילוס האט זיך אויפגעשטעלט און געמאכט א צייכן מיט דער האנט, און געזאגט: אנשי ישראל, און איר, וואס האבן מורא פאר ה׳, הערט! ");
INSERT INTO ydd_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","דער ג‑ט פון דעם דאזיקן פאלק ישראל האט אויסדערוויילט אונדזערע אבות און דאס פאלק דערהייבט בשעת זיי האבן זיך אויפגעהאלטן אינם לאנד מצרים, און מיט א הויכן ארעם זיי ארויסגעפירט פון דארטן. ");
INSERT INTO ydd_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","און כמעט פערציק יאר לאנג האט ער זיי געטראגן אין דער מדבר. ");
INSERT INTO ydd_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","און פארטיליקנדיק זיבן פעלקער אינם לאנד כנען, האט ער זיי געמאכט ירשענען דאס לאנד זייערס, אן ערך פיר הונדערט און פיפציק יאר לאנג. ");
INSERT INTO ydd_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","און דערנאך זיי געגעבן שופטים ביז שמואל הנביא. ");
INSERT INTO ydd_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","און פון דעמאלט אָן האבן זיי פארלאנגט א מלך, און ה׳ האט זיי געגעבן שאולן, דעם זון פון קיש, א מאן פון דעם שבט בנימין, במשך פון פערציק יאר. ");
INSERT INTO ydd_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","און ווען ער האט אים אראפגעזעצט, האט ער זיי אויפגעשטעלט דודן פאר א מלך, וועגן וועמען ער האט עדות געזאגט: איך האב געפונען דודן, דעם בן ישי, א מאן נאך מיין הארץ, וועלכער וועט טאן יעדן רצון מיינעם. ");
INSERT INTO ydd_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","פון דעם דאזיקנס זאמען, לויט א הבטחה, האט ה׳ געברענגט צו ישראל א גואל—יהושע/ישוע (ישעיהו יא, א; זכריה ו, יא-יב; עזרא ג, ב.), ");
INSERT INTO ydd_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","וואס פאר זיין קומען האט יוחנן אויסגערופן א מקווה פון תשובה צום גאנצן פאלק ישראל. ");
INSERT INTO ydd_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","און ווען יוחנן האט געהאלטן ביים ענדיקן זיין לויף, האט ער געזאגט: וואס איר מיינט איך בין, דאס בין איך נישט; נאר זע, עס קומט נאך מיר דער, וועמען איך בין נישט ווערט אויפצובינדן די שיך פון זיינע פיס. ");
INSERT INTO ydd_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ברידער, קינדער פון אברהמס שטאם און די, צווישן אייך, וואס האבן מורא פאר ה׳, צו אונדז איז דאס ווארט פון דער דאזיקער ישועה געשיקט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ווארום די איינוואוינער פון ירושלים און זייערע שרים, פארמשפטנדיק אים, וועמען זיי האבן נישט דערקענט, האבן דערפילט די רייד פון די נביאים, וואס ווערן געלייענט יעדן שבת. ");
INSERT INTO ydd_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","און הגם זיי האבן נישט געפונען קיין טויטשולד אין אים, האבן זיי דאך פארלאנגט פון פילאטוסן, אז ער זאל אומגעברענגט ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","און ווען זיי האבן אויסגעפירט אלץ, וואס שטייט געשריבן וועגן אים, האבן זיי אים אראפגענומען פון דעם בוים און אים אריינגעלייגט אין א קבר. ");
INSERT INTO ydd_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ה׳ אבער האט אים אויפגעוועקט פון די טויטע; ");
INSERT INTO ydd_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","און ער האט זיך באוויזן במשך פון א סך טעג צו די, וואס זענען ארויפגעגאנגען צוזאמען מיט אים פון גליל קיין ירושלים, און זיי זענען איצט זיינע עדות צום פאלק. ");
INSERT INTO ydd_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","און מיר זאגן אייך אָן די גוטע בשורה, אז די הבטחה, וואס איז געגעבן געווארן צו די אבות, ");
INSERT INTO ydd_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","די דאזיקע (הבטחה) האט ה׳ מקיים געווען צו אונדז, זייערע קינדער, דערמיט וואס ער האט אויפגעוועקט יהושען/ישוען, ווי עס שטייט אויך געשריבן אין דעם צווייטן (קאפיטל) תהלים: דו ביסט מיין זון, איך האב דיך היינט געבוירן. ");
INSERT INTO ydd_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","און אז ער האט אים אויפגעוועקט פון די טויטע, כדי ער זאל זיך מער נישט אומקערן צו פארדארבונג, האט ער אזוי געזאגט: איך וועל אייך געבן די הייליקע און באגלויבטע חסדים פון דוד. ");
INSERT INTO ydd_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","דערפאר זאגט ער אויך אויף אן אנדער שטעלע: דו וועסט נישט געבן דיין חסיד צו זען פארדארבונג. ");
INSERT INTO ydd_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ווארום דוד, נאך דעם ווי ער האט געדינט זיין דור לויט ה׳ס עצה, איז איינגעשלאפן, און איז געלייגט געווארן צו זיינע אבות און האט געזען פארדארבונג; ");
INSERT INTO ydd_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ער אבער, וועמען ה׳ האט אויפגעוועקט, האט נישט געזען קיין פארדארבונג. ");
INSERT INTO ydd_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","דעריבער זאלט איר וויסן זיין, ברידער, אז דורך דעם דאזיקן ווערט אייך אנגעזאגט די פארגעבונג פון זינד; ");
INSERT INTO ydd_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","און יעדער, וואס גלויבט אין אים, ווערט גערעכטפערטיקט פון אלעם, פון וואס איר האט נישט געקענט גערעכטפערטיקט ווערן דורך תורת משה. ");
INSERT INTO ydd_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","גיט זשע אכטונג, אז עס זאל נישט קומען אויף אייך דאס, וואס איז געזאגט געווארן און די נביאים: ");
INSERT INTO ydd_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","זעט, איר פאראכטער, און וואונדערט זיך און פארגייט, ווייל איך טו א ווערק אין אייערע טעג, א ווערק, וואס איר וועט נישט גלויבן, ווען עמיצער וועט עס אייך דערציילן. ");
INSERT INTO ydd_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","און בשעת זיי זענען ארויסגעגאנגען (פון שול), האט מען זיי געבעטן, אז דעם קומענדיקן שבת זאלן די זעלביקע רייד גערעדט ווערן צו זיי. ");
INSERT INTO ydd_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","און ווען קהל איז זיך צעגאנגען, האבן א סך פון די יידן און פון די פרומע גרים נאכגעפאלגט פוילוסן און בר‑נבאן, וועלכע האבן גערעדט צו זיי און זיי מזהיר געווען צו פארבלייבן אין דעם חסד פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","און דעם פאלגענדיקן שבת איז כמעט די גאנצע שטאט זיך צוזאמענגעקומען, צו הערן ה׳ס ווארט. ");
INSERT INTO ydd_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","און ווי די (אומגלויביקע) יידן האבן געזען די מאסן מענטשן, זענען זיי פול געווארן מיט קנאה און האבן אקייגנגערעדט דעם, וואס פוילוס האט געזאגט, און האבן געלעסטערט. ");
INSERT INTO ydd_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","און רעדנדיק אפן מיט דרייסטקייט, האבן פוילוס און בר‑נבא געזאגט: עס איז געווען נויטיק, אז צו אייך זאל קודם כל גערעדט ווערן ה׳ס ווארט; נאר ווייל איר פארשטויסט עס און האלט זיך נישט פאר ראוי אויף דעם אייביקן לעבן, זע, ווענדן מיר זיך צו די אומות (העולם). ");
INSERT INTO ydd_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ווארום אזוי האט אונדז דער האר באפוילן: איך האב דיך געזעצט פאר א ליכט צו די פעלקער, אז דו זאלסט זיין א ישועה ביז צום סוף פון דער ערד. ");
INSERT INTO ydd_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","און ווי די אומות (העולם) האבן דאס געהערט, האבן זיי זיך געפריידט און ערלעך געהאלטן דאס ווארט פון דעם האר; און וויפל עס זענען געווען באשטימט צום אייביקן לעבן אזויפיל האבן געגלויבט. ");
INSERT INTO ydd_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","און דאס ווארט פון דעם האר האט זיך פאנאנדערגעטראגן איבערן גאנצן לאנד. ");
INSERT INTO ydd_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","די יידן אבער האבן אונטערגעהעצט די פרומע און אנגעזענע פרויען און די פארנעמע לייט פון דער שטאט, און האבן אויפגעוועקט א רדיפה אויף פוילוסן און בר‑נבאן, און זיי ארויסגעטריבן פון זייערע גרענעצן. ");
INSERT INTO ydd_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","און זיי האבן אפגעשאקלט דעם שטויב פון זייערע פיס קעגן זיי, און זענען אוועק קיין איקאניען. ");
INSERT INTO ydd_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","און די תלמידים זענען געווארן פול מיט פרייד און מיט דעם רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","און דאס זעלביקע איז געשען אין איקאניען. זיי זענען אריינגעגאנגען אין דער יידישער שול און האבן אזוי גערעדט, אז עס האט געגלויבט פון יידן און גריכן א גרויסער המון. ");
INSERT INTO ydd_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","די אומגלויביקע יידן אבער האבן אויפגעהעצט און פארביטערט די זעלן פון די אומות (העולם) קעגן די ברידער. ");
INSERT INTO ydd_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","דעריבער האבן זיי דארטן פארברענגט א לענגערע צייט, רעדנדיק מיט דרייסטקייט פון דעם האר, וועלכער האט מעיד געווען אויף דעם ווארט פון זיין חסד, געבנדיק, אז עס זאלן געשען אותות און מופתים דורך זייערע הענט. ");
INSERT INTO ydd_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","און די מאסע פון דער שטאט האט זיך געשפאלטן, א טייל זענען געווען מיט די יידן, און א טייל מיט די שליחים. ");
INSERT INTO ydd_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","און ווי עס איז געמאכט געווארן א פיינטלעכער פארזוך מצד די אומות (העולם) און די יידן, מיט זייערע ראשים, זיי צו טאן שלעכטס און צו שטייניקן, ");
INSERT INTO ydd_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","האבן זיי זיך דערפון דערוואוסט, און זענען אנטלאפן אין די שטעט אריין פון ליקאאניען, ליסטרא און דערבע און דער געגנט ארום; ");
INSERT INTO ydd_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","און האבן דארטן אנגעזאגט די גוטע בשורה. ");
INSERT INTO ydd_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","און אין ליסטרא פלעגט זיצן א מאן, וואס איז געווען שוואך אויף די פיס, לאם פון זיין מוטערס לייב, וועלכער איז קיינמאל נישט ארומגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","דער דאזיקער האט זיך צו געהערט צו פוילוסן רעדן, וואס, ווען קוקנדיק אויף אים און זעענדיק, אז ער האט אמונה גענעזן צו ווערן, ");
INSERT INTO ydd_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","האט געזאגט מיט א הויך קול: שטעל דיך גלייך אויף דיינע פיס! און ער האט א שפרונג געטאן און איז ארומגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","און די המונים, זעענדיק וואס פוילוס האט געטאן, האבן אויפגעהויבן זייער קול אויף דעם ליקאאנישן לשון, אזוי צו זאגן: די ג‑טער אין געשטאלט פון מענטשן האבן אראפגענידערט צו אונדז. ");
INSERT INTO ydd_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","און האבן גערופן בר‑נבאן צעאוס (יופיטער) און פוילוסן הערמעס (מערקוריוס), ווייל ער איז געווען דער הויפט רעדנער. ");
INSERT INTO ydd_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","און דער פריסטער פון צעאוס, וועמעס (טעמפל) איז געווען אויסער דער שטאט, האט געברענגט צו פירן אקסן און גירלאנדן צו די טויערן, און געוואלט מקריב זיין מיט די מאסן. ");
INSERT INTO ydd_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","הערנדיק אבער דערפון, האבן די שליחים, פוילוס און בר‑נבא, צעריסן זייערע קליידער און זענען ארויסגעלאפן צווישן דעם המון מענטשן, שרייענדיק און זאגנדיק: ");
INSERT INTO ydd_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","מענער, פארוואס טוט איר דאס? אויך מיר זענען מענטשן מיט געפילן ענלעך צו אייך, און זאגן אייך אָן א בשורה טובה, זיך אפצוקערן פון די דאזיקע נישטיקייטן צום לעבעדיקן ג‑ט, וועלכער האט באשאפן הימל און ערד און דעם ים און אלץ, וואס (געפינט זיך) אין זיי; ");
INSERT INTO ydd_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","וועלכער האט אין פארגאנגענע דורות געלאזט אלע פעלקער גיין אין זייערע אייגענע דרכים. ");
INSERT INTO ydd_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","און דאך האט ער זיך נישט איבערגעלאזט אָן אן עדות, מחמת ער האט געטאן גוטס, געבנדיק אייך רעגן פון הימל און פרוכטבארע צייטן, און אנגעפילט אייערע הערצער מיט שפייז און מיט שמחה. ");
INSERT INTO ydd_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","און דאס זאגנדיק, האבן זיי קוים איינגעהאלטן די מאסן מענטשן, נישט מקריב צו זיין צו זיי. ");
INSERT INTO ydd_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","עס זענען אבער געקומען יידן פון אנטיאכיען און איקאניען און איבעררעדנדיק די מאסן און שטייניקנדיק פוילוסן, האבן זיי אים ארויסגעשלעפט אויסער דער שטאט, מיינענדיק, אז ער איז טויט. ");
INSERT INTO ydd_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ווען אבער די תלמידים האבן זיך ארומגעשטעלט ארום אים, האט ער זיך אויפגעהויבן און איז אריינגעגאנגען אין דער שטאט אריין; און אויף צומארגנס איז ער ארויס צוזאמען מיט בר‑נבאן קיין דערבע. ");
INSERT INTO ydd_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","און האבן אנגעזאגט די גוטע בשורה אין יענער שטאט, און געוואונען אן אנגעזענע צאל תלמידים, און זיך אומגעקערט קיין ליסטרא און קיין איקאניען און קיין אנטיאכיען, ");
INSERT INTO ydd_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","שטארקענדיק די זעלן פון די תלמידים, און מזהיר זייענדיק זיי צו בלייבן אין דער אמונה, און אז דורך פיל צרות מוזן מיר אריינקומען אין דעם מלכות פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","און אויסדערוויילנדיק פאר זיי זקנים אין יעדער קהילה, און תפילה טוענדיק מיט פאסטן, האבן זיי זיי איבערגעלאזט אויף דעם באראט פון דעם האר, אין וועמען זיי האבן געגלויבט. ");
INSERT INTO ydd_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","און זענען דורכגעגאנגען פיסידיען, און זענען געקומען קיין פאמפיליען. ");
INSERT INTO ydd_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","און האבן גערעדט דאס ווארט אין פערגא, און זענען אראפ קיין אטאליא; ");
INSERT INTO ydd_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","און פון דארטן זיך אוועקגעשיפט קיין אנטיאכיען, פונוואנען זיי זענען איבערגעגעבן געווארן צו ה׳ס חסד צו (טאן) די ארבעט, וואס זיי האבן דערפילט. ");
INSERT INTO ydd_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","און אנקומענדיק אהין, האבן זיי צוזאמענגעברענגט די קהלה, און דערציילט אלץ, וואס ה׳ האט מיט זיי געטאן, און אז ער האט אויפגעעפנט פאר די אומות (העולם) א טיר פון אמונה. ");
INSERT INTO ydd_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","און האבן פארברענגט נישט קיין קליינע צייט צוזאמען מיט די תלמידים. ");
INSERT INTO ydd_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","און אייניקע זענען אראפגעקומען פון (דעם לאנד) יהודה און האבן געלערנט די ברידער (אזוי צו זאגן): אויב איר וועט זיך נישט לאזן מל זיין כדת משה, קענט איר נישט געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","און ווען עס איז געווארן א מהומה און נישט קיין קליינע מחלוקה צווישן פוילוסן און בר‑נבאן מיט זיי, האט מען באשלאסן, אז פוילוס און בר‑נבא און אייניקע אנדערע פון זיי זאלן ארויפגיין קיין ירושלים צו די שליחים און זקנים וועגן דער דאזיקער שאלה. ");
INSERT INTO ydd_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","און ווערנדיק באגלייט פון דער קהלה, זענען זיי דורכגעגאנגען פעניציען און שומרון, און האבן דערציילט וועגן דער באקערונג (צו ה׳) פון די אומות (העולם), און פארשאפט א גרויסע פרייד צו אלע ברידער. ");
INSERT INTO ydd_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","אנקומענדיק אבער קיין ירושלים, זענען זיי אויפגענומען געווארן פון דער קהלה און די שליחים און די זקנים, און האבן דערציילט אלץ, וואס ה׳ האט מיט זיי געטאן. ");
INSERT INTO ydd_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","נאר עס זענען אויפגעשטאנען אייניקע מאמינים פון דער כיתה פון די פרושים, וועלכע האבן געזאגט: מען מוז זיי (די אומות (העולם)) מל זיין, און אנזאגן אפצוהיטן תורת משה (די תרי״ג מצוות). ");
INSERT INTO ydd_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","און די שליחים און די זקנים זענען זיך צוזאמענגעקומען, אריינצוקוקן אין דעם דאזיקן ענין. ");
INSERT INTO ydd_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","און ווען עס איז געווארן א גרויסע מחלוקה, האט פעטרוס זיך אויפגעשטעלט און געזאגט צו זיי: ברידער, איר ווייסט, אז פון די פריעסטע טעג אָן האט ה׳ (מיך) אויסדערוויילט צווישן אייך, כדי דורך מיין מויל זאלן די אומות (העולם) הערן דאס ווארט פון דער בשורה טובה און זאלן גלויבן. ");
INSERT INTO ydd_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","און ה׳, וועלכער קען די הערצער, האט מעיד געווען צו זיי, געבנדיק זיי דעם רוח הקודש פונקט אזוי ווי אויך אונדז; ");
INSERT INTO ydd_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","און נישט געמאכט קיין חילוק צווישן אונדז און זיי, רייניקנדיק זייערע הערצער דורך דער אמונה. ");
INSERT INTO ydd_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","פארוואס זשע פרואווט איר איצט אויס ה׳, מיטן ארויפלייגן אויף דעם האלדז פון די תלמידים אן עול, וואס נישט אונדזערע עלטערן, נישט מיר אליין האבן געקענט דערטראגן? ");
INSERT INTO ydd_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ניין, נאר דורך דעם חסד פון דעם האר יהושע/ישוע גלויבן מיר דערלייזט צו ווערן אויף דעם זעלביקן אופן ווי יענע. ");
INSERT INTO ydd_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","און דער גאנצער עולם האט געשוויגן; און זיך צוגעהערט צו בר‑נבאן און פוילוסן, וועלכע האבן דערציילט וואס פאר אותות און מופתים ה׳ האט געטאן צווישן די אומות (העולם) דורך זיי. ");
INSERT INTO ydd_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","און נאך דעם ווי זיי זענען אנטשוויגן געווארן, האט יעקב געענטפערט, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ברידער, הערט זיך צו צו מיר; שמעון האט (אונדז) דערציילט, וויאזוי ה׳ האט צום ערשט געבליקט, צו נעמען פון צווישן די אומות (העולם) א פאלק צו זיין נאמען. ");
INSERT INTO ydd_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","און צו דעם דאזיקן שטימען איין די ווערטער פון די נביאים, ווי עס שטייט געשריבן: ");
INSERT INTO ydd_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","נאך דעם וועל איך מיך אומקערן און ווידער אויפבויען דאס איינגעפאלענע געצעלט פון דוד, און די חורבות דערפון וועל איך ווידער אויפבויען און עס ווידער אויפשטעלן גלייך; ");
INSERT INTO ydd_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","כדי די איבערגעבליבענע מענטשן זאלן זוכן דעם האר, און אלע פעלקער, וואס מיין נאמען ווערט גערופן אויף זיי, זאגט דער האר, וועלכער טוט די דאזיקע זאכן, ");
INSERT INTO ydd_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","וואס זענען באקאנט פון אייביק אָן. ");
INSERT INTO ydd_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","דערפאר באשליס איך, מען זאל נישט מחמיר זיין אויף די, וואס קערן זיך צו ה׳ פון צווישן די אומות; ");
INSERT INTO ydd_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","נאר צו שרייבן צו זיי, זיך אפצוהאלטן פון טומאה פון די אפג-טער, און פון זנות, און פון (דעם פלייש פון א בהמה) וואס איז דערווארגן געווארן, און פון בלוט. ");
INSERT INTO ydd_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ווארום משה האט פון לאנגע דורות אָן אין יעדער שטאט די, וואס דרשענען אים, מחמת (זיין תורה) ווערט געלייענט אין די שולן יעדן שבת. ");
INSERT INTO ydd_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","דעמאלט איז עס וואוילגעפעלן די שליחים און די זקנים מיט דער גאנצער קהלה צו שיקן אויסדערוויילטע מענער פון זייער מיט קיין אנטיאכיען מיט פוילוסן און בר‑נבאן: (נעמלעך,) יהודהן, וואס מען האט אים גערופן בר‑שבא, און סילא, מענער מנהיגים צווישן די ברידער; ");
INSERT INTO ydd_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","שרייבנדיק דורך זייער האנט: די שליחים און די זקנים און ברידער צו די ברידער, וועלכע זענען פון די אומות העולם, און געפינען זיך אין אנטיאכיען און סיריען און קיליקיען, שלום! ");
INSERT INTO ydd_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","אזוי ווי מיר האבן געהערט, אז אייניקע פון אונדז האבן אייך באאומרואיקט מיט ווערטער, וואס פארשאפן אייך עגמת נפש; וועמען מיר האבן עס נישט באפוילן, ");
INSERT INTO ydd_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","איז עס אונדז וואוילגעפעלן, האבנדיק געקומען צו א הסכם, צו שיקן צו אייך אויסדערוויילטע מענער צוזאמען מיט אונדזערע געליבטע בר‑נבא און פוילוס, ");
INSERT INTO ydd_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","מענטשן, וואס האבן זיך מוסר נפש געווען פאר דעם נאמען פון אונדזער האר יהושע/ישוע המשיח. ");
INSERT INTO ydd_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","מיר האבן דעריבער געשיקט יהודהן און סילאן, און זיי וועלן אייך ווארט ווערטלעך דערציילן דאס זעלביקע. ");
INSERT INTO ydd_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ווארום עס איז וואוילגעפעלן דעם רוח הקודש און אונדז, נישט ארויפצולייגן אויף אייך קיין ווייטערע משא, אחוץ די דאזיקע נויטווענדיקע זאכן; ");
INSERT INTO ydd_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","זיך אפצוהאלטן פון קרבנות צו אפג-טער און פון בלוט און (פון פלייש פון בהמות) דערווארגענע און פון זנות, פון וועלכע אויב איר וועט זיך אפהיטן, וועט אייך גיין גוט. שלום צו אייך. ");
INSERT INTO ydd_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","און אזוי זענען זיי אוועקגעשיקט געווארן און זענען אראפ קיין אנטיאכיען, האבן פארזאמלט דעם עדה און איבערגעגעבן דעם בריוו. ");
INSERT INTO ydd_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","און איבערלייענענדיק אים, האבן זיי זיך געפריידט איבער דער נחמה. ");
INSERT INTO ydd_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","און יהודה און סילא, וועלכע זענען אליין אויך געווען נביאים, האבן געטרייסט די ברידער מיט פיל ווערטער, און זיי געשטארקט. ");
INSERT INTO ydd_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","און נאך דעם ווי זיי האבן פארבראכט א געוויסע צייט, זענען זיי אוועקגעלאזט געווארן בשלום פון די ברידער צו די, וואס האבן זיי געשיקט. ");
INSERT INTO ydd_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(סילאן אבער איז עס וואוילגעפעלן, דארטן איבערצובלייבן.) ");
INSERT INTO ydd_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","און פוילוס און בר‑נבא זענען פארבלייבן אין אנטיאכיען, לערנענדיק און אנזאגנדיק מיט נאך א סך אנדערע דאס ווארט פון דעם האר. ");
INSERT INTO ydd_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","און אין אייניקע טעג ארום האט פוילוס געזאגט צו בר‑נבאן: לאמיר זיך אומקערן און באזוכן די ברידער אין אלע שטעט, אין וועלכע מיר האבן אנגעזאגט דאס ווארט פון דעם האר, (און זען) ווי עס דערגייט זיי. ");
INSERT INTO ydd_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","בר‑נבא אבער האט געוואלט מיטנעמען אויך דעם יוחנן, וועמען מען האט גערופן מארקוס. ");
INSERT INTO ydd_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","נאר פוילוס האט עס נישט געהאלטן פאר טויגבאר מיטצונעמען דעם, וואס האט זיך אפגעקערט פון זיי פון פאמפיליען, און איז נישט מיטגעגאנגען מיט זיי צו דער ארבעט. ");
INSERT INTO ydd_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","און עס איז געקומען צו א פארביטערונג, אזוי, אז זיי האבן זיך אפגעטיילט איינער פון אנדערן, און בר‑נבא האט גענומען מארקוסן און זיך אוועקגעשיפט קיין קפריסין; ");
INSERT INTO ydd_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","און פוילוס האט אויסדערוויילט סילאן און איז אוועקגעגאנגען, ווערנדיק איבערגעגעבן פון די ברידער צו דעם חסד פון דעם האר. ");
INSERT INTO ydd_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","און איז דורכגעגאנגען סיריען און קיליקיען און האט געשטארקט די קהלות. ");
INSERT INTO ydd_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","און ער איז געקומען אויך קיין דערבע און ליסטרא, און זע, דארטן איז געווען א געוויסער תלמיד, מיטן נאמען טימאטעוס, א זון פון א יידישער גלויביק געווארענער פרוי, זיין פאטער אבער איז געווען א גריך; ");
INSERT INTO ydd_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","און ער האט געהאט א גוטן שם ביי די ברידער אין ליסטרא און איקאניען. ");
INSERT INTO ydd_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","אים האט פוילוס געוואלט האבן מיט זיך ארויסצוגיין, אויף דער נסיעה, און האט גענומען און אים מל געווען צוליב די יידן, וואס האבן זיך געפונען אין יענע מקומות; ווארום אלע האבן געוואוסט, אז זיין פאטער איז געווען א גריך. ");
INSERT INTO ydd_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","און ווי זיי זענען געגאנגען איבער די שטעט, האבן זיי איבערגעגעבן צו זיי אפצוהיטן די חוקים, וואס זענען באשלאסן געווארן פון די שליחים און זקנים אין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","און אזוי זענען די קהלות געשטארקט געווארן אין דער אמונה און האבן זיך פארמערט אין צאל פון טאג צו טאג. ");
INSERT INTO ydd_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","און זיי זענען דורכגעגאנגען פריגיען און דאס לאנד גאלאטיען, ווייל עס איז זיי פארווערט געווארן פון דעם רוח הקודש צו רעדן דאס ווארט אין אזיען; ");
INSERT INTO ydd_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","אנקומענדיק אבער קיין מיסיען, האבן זיי פארזוכט צו רייזן קיין ביטיניען, און דער גייסט פון יהושען/ישוען האט זיי נישט געלאזט; ");
INSERT INTO ydd_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","זענען זיי, פארבייגייענדיק מיסיען, אראפגעקומען קיין טראאס. ");
INSERT INTO ydd_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","און א חזיון האט זיך באוויזן צו פוילוסן ביינאכט: א מאצעדאניער איז געשטאנען און האט אים געבעטן און געזאגט: קום אריבער קיין מאצעדאניען און העלף אונדז. ");
INSERT INTO ydd_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","און נאך דעם ווי ער האט געזען דעם חזיון, האבן מיר גלייך געזוכט ארויסצוגיין קיין מאצעדאניען, ארויסדרינגענדיק, אז ה׳ האט אונדז גערופן אנצוזאגן צו זיי די גוטע בשורה. ");
INSERT INTO ydd_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","מיר האבן דעריבער געזעגלט פון טראאס און זענען געפארן אין א גראדער ריכטונג קיין סאמאטראציען, און דעם אנדערן טאג קיין נעאפאליס; ");
INSERT INTO ydd_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","און פונדאנען קיין פיליפי, וואס איז די ערשטע שטאט פון דעם טייל מאצעדאניען, א (רוימישע) קאלאניע, און אין דער דאזיקער שטאט האבן מיר פארברענגט אייניקע טעג. ");
INSERT INTO ydd_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","און דעם טאג פון שבת זענען מיר ארויסגעגאנגען אויסער דעם טויער צו א טייך, וואו מיר האבן זיך משער געווען, אז עס איז א בית התפילה; און האבן זיך אנידערגעזעצט און גערעדט מיט די פרויען, וואס זענען זיך צוזאמענגעקומען. ");
INSERT INTO ydd_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","און א ג‑טספארכטיקע פרוי, מיטן נאמען לידיא, א פארקויפערין פון פורפור, אויס דער שטאט טיאטירא, האט זיך צוגעהערט; וואס דער האר האט איר אויפגעמאכט דאס הארץ צו פארנעמען די רייד פון פוילוסן. ");
INSERT INTO ydd_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","און ווען זי איז געטובלט געווארן אין דער מקווה, און איר הויזגעזינד, האט זי (אונדז) געבעטן, אזוי צו זאגן: אויב איר האלט מיך פאר א גלויביקע אינם האר, קומט און שטייט איין אין מיין הויז. און האט אונדז שטארק געבעטן. ");
INSERT INTO ydd_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","און עס איז געשען, בשעת מיר זענען געגאנגען צום בית התפילה, אז א דינסטמיידל, וואס האט געהאט א גייסט פון נחוש (כישוף) פון ווארזאגער, האט אונדז באגעגענט; וואס פלעגט אריינגעברענגען אירע בעלי בתים א סך פארדינסט פון איר ווארזאגן. ");
INSERT INTO ydd_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","די זעלביקע האט נאכגעפאלגט פוילוסן און אונדז, און געשריגן, אזוי צו זאגן: די דאזיקע מענטשן זענען קנעכט פון דעם אלערהעכסטן ג‑ט, וועלכע זאגן אייך אָן א וועג פון רעטונג. ");
INSERT INTO ydd_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","דאס האט זי אבער געטאן במשך פון פיל טעג. און פוילוס איז דערפון טרויעריק געווארן, און האט זיך א קער געטאן און געזאגט צום גייסט: איך באפעל דיר אינם נאמען פון יהושע/ישוע המשיחן ארויסצוגיין פון איר. און ער איז ארויס פון איר אין דער זעלביקער שעה. ");
INSERT INTO ydd_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","און זעענדיק, אז די האפענונג פון זייער פארדינסט איז פארשווונדן, האבן אירע בעלי בתים געכאפט פוילוסן און סילאן, און זיי געשלעפט אין מארק אריין צו די מושלים, ");
INSERT INTO ydd_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","און ברענגענדיק זיי צו די פרעטארן, האבן זיי געזאגט: די דאזיקע מענטשן, וואס זענען יידן, שטערן די רו פון אונדזער שטאט, ");
INSERT INTO ydd_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","און לערנען מנהגים, וועלכע מיר טארן נישט אננעמען, אויך נישט האלטן, ווייל מיר זענען רוימער. ");
INSERT INTO ydd_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","און דער המון איז אויפגעשטאנען קעגן זיי, און די פרעטארן האבן פון זיי אראפגעריסן די מלבושים, און באפוילן מען זאל זיי שמייסן מיט ריטער. ");
INSERT INTO ydd_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","און באלייגנדיק זיי מיט א סך שלעק, האט מען זיי אריינגעווארפן אין תפיסה, באפעלנדיק דעם שומר זיי גוט צו היטן; ");
INSERT INTO ydd_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","וועלכער, באקומענדיק אזא באפעל, האט זיי אריינגעווארפן אין דעם אינערן געפענקעניש און פארגעשרויפט זייערע פיס אין דעם שטאק. ");
INSERT INTO ydd_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ארום האלבער נאכט אבער בעת פוילוס און סילא האבן תפילה געטאן און געזונגען צו ה׳, און די געפאנגענע האבן זיך צוגעהערט צו זיי, ");
INSERT INTO ydd_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","איז פלוצלונג געווארן א גרויסע ערדציטערניש, אזוי, אז די פונדאמענטן פון דער תפיסה זענען דערשיטערט געווארן, און אין אן אויגנבליק האבן זיך אלע טירן אויפגעעפנט, און אלעמענס קייטן זענען לויז געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","און ווי דער תפיסה שומר האט זיך אויפגעכאפט פון שלאף און געזען די טירן פון דער תפיסה אפן, האט ער ארויסגעצויגן זיין שווערד און זיך געוואלט דאס לעבן נעמען, מיינענדיק, אז די געפאנגענע זענען אנטלאפן. ");
INSERT INTO ydd_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","פוילוס אבער האט אויסגערופן מיט א הויך קול, אזוי צו זאגן: טו דיר נישט קיין מעשה אָן, ווארום מיר זענען אלע דא. ");
INSERT INTO ydd_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","און ער האט פארלאנגט א ליכט, איז אריינגעשפרונגען, און ציטערנדיק איז ער אנידערגעפאלן פאר פוילוסן און סילאן, ");
INSERT INTO ydd_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","און האט זיי ארויסגעפירט אינדרויסן, און געזאגט: מיינע הארן, וואס זאל איך טאן, כדי געראטעוועט צו ווערן? ");
INSERT INTO ydd_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","און זיי האבן געזאגט: גלויב אין דעם האר יהושע/ישוע, און דו וועסט געראטעוועט ווערן און (אויך) דיין הויזגעזינד. ");
INSERT INTO ydd_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","און האבן גערעדט צו אים ה׳ס ווארט און צו אלעמען אין זיין הויז. ");
INSERT INTO ydd_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","און ער האט זיי גענומען אין יענער שעה פון דער נאכט און זיי אפגעוואשן די שלעק; און זיך גלייך געלאזט טובל זיין אין דער מקווה, ער אליין און אלע זיינע בני בית. ");
INSERT INTO ydd_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","און האט זיי אריינגעפירט אין זיין הויז, און געדעקט א טיש (פאר זיי), און זיך זייער געפריידט מיט זיין גאנץ הויזגעזינד, אז ער איז געווארן א מאמין אין ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","און ווען עס איז געווארן טאג, האבן די פרעטארן (שופטים) געשיקט די ליקטארן (פאליציי), אזוי צו זאגן: לאז ארויס יענע מענטשן. ");
INSERT INTO ydd_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","און דער תפיסה שומר האט דערציילט די דאזיקע ווערטער צו פוילוסן: די פרעטארן האבן געשיקט, אז מען זאל אייך אפלאזן; קומט זשע איצט ארויס, און גייט אייך לשלום. ");
INSERT INTO ydd_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","פוילוס אבער האט צו זיי געזאגט: זיי האבן אונדז געשלאגן עפנטלעך מיט ריטער, אָן א משפט, אונדז, וואס מיר זענען רוימישע מענטשן, און אונדז אריינגעווארפן אין תפיסה אריין, און איצט ווארפן זיי אונדז ארויס שטילערהייט? אזוי נישט, נאר טאקע זיי אליין זאלן קומען און אונדז ארויספירן. ");
INSERT INTO ydd_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","און די ליקטארן האבן דערציילט די דאזיקע רייד צו די פרעטארן, און זיי האבן מורא געהאט, הערנדיק, אז זיי זענען רוימער. ");
INSERT INTO ydd_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","און זענען געקומען און זיי מפייס געווען, און האבן זיי ארויסגעפירט און געבעטן, אז זיי זאלן אוועקגיין פון דער שטאט. ");
INSERT INTO ydd_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","און ווי זיי זענען ארויס פון דעם געפענקעניש, זענען זיי אריינגעגאנגען צו לידיאן; און זעענדיק זיך מיט די ברידער, האבן זיי זיי געטרייסט, און זענען ארויסגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","און רייזנדיק דורך אמפיפאליס און אפאלאניע, זענען זיי געקומען קיין טעסאלאניקא, וואו עס איז געווען א יידישע שול. ");
INSERT INTO ydd_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","און לויט זיין געוואוינהייט איז פוילוס אריינגעגאנגען צו זיי, און במשך פון דריי שבתים האט ער זיך מיט זיי מתווכח געווען פון די כתבי (הקודש), ");
INSERT INTO ydd_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","אויפעפנענדיק און דערווייזנדיק, אז דער משיח האט געדארפט ליידן און אויפשטיין פון די טויטע, און אז דער דאזיקער יהושע/ישוע, וועלכן איך זאג אייך אָן, איז דער משיח. ");
INSERT INTO ydd_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","און אייניקע פון זיי האבן זיך איבערצייגט, און זיך באהאפטן צו פוילוסן און סילאן; און פון די יראת שמימדיקע גריכן א גרויסער עולם, און פון די פארנעמע פרויען נישט ווייניקע. ");
INSERT INTO ydd_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","די יידן אבער זענען געווארן אייפערזיכטיק און האבן גענומען אייניקע פארשוינען פון דעם גאסנגעזינדל, און איינגעזאמלט א המון, און געמאכט א מהומה אין דער שטאט; און שטעלנדיק זיך ארום יאזאנס הויז, האבן זיי געזוכט זיי ארויסצוברענגען פארן פאלק. ");
INSERT INTO ydd_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","און ווי זיי האבן זיי נישט געפונען, האבן זיי ארויסגעשלעפט יאזאנען און אייניקע ברידער צו די מנהיגים פון דער שטאט, שרייענדיק: די דאזיקע לייט, וועלכע האבן אויפגעברויזט די וועלט, זענען אויך אהערגעקומען; ");
INSERT INTO ydd_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","וועמען יאזאן האט אויפגענומען; און זיי אלע האנדלען קעגן דעם קיסרס געזעצן, זאגנדיק, אז עס איז פאראן אן אנדערער קעניג, יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","און האבן צארנדיק געמאכט דעם המון און די שטאט מנהיגים, ווען זיי האבן דאס געהערט. ");
INSERT INTO ydd_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","און באקומענדיק א פארזיכערונג פון יאזאנען און פון די איבריקע, האבן זיי זיי אפגעלאזט. ");
INSERT INTO ydd_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","און די ברידער האבן גלייך ארויסגעשיקט פוילוסן און סילאן ביינאכט קיין בערעא; און ווען זיי זענען אהינגעקומען, זענען זיי אריינגעגאנגען אין דער יידישער שול אריין. ");
INSERT INTO ydd_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","און די דאזיקע (יידן) זענען געווען איידעלער ווי די אין טעסאלאניקא, ווייל זיי האבן אנגענומען דאס ווארט מיט יעדער גרייטוויליקייט, און טאג טעגלעך געפארשט די כתבי (הקודש), צי עס איז אזוי. ");
INSERT INTO ydd_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","דעריבער האבן אויך א סך פון זיי געגלויבט, און נישט ווייניקע פון די פארנעמע גריכישע פרויען און מענער. ");
INSERT INTO ydd_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","נאר ווי די יידן פון טעסאלאניקא האבן זיך דערוואוסט, אז אויך אין בערעא איז ה׳ס ווארט אנגעזאגט געווארן פון פוילוסן, זענען זיי אויך אהינגעקומען, אויפרעגנדיק און אויפהעצנדיק די מאסן. ");
INSERT INTO ydd_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","און דעמאלט האבן די ברידער גלייך ארויסגעשיקט פוילוסן צו גיין ביז צום ים; און סילא און טימאטעוס זענען דארטן איבערגעבליבן. ");
INSERT INTO ydd_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","און פוילוסנס באגלייטער האבן אים געפירט ביז אטען, און באקומענדיק א באפעל צו סילא און טימאטעוסן, אז זיי זאלן קומען צו אים ווי צום געשווינדסטן, זענען זיי אוועקגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","און בשעת פוילוס האט געווארט אויף זיי אין אטען, האט זיך זיין גייסט פארביטערט אין אים, זעענדיק ווי די שטאט איז פול מיט אפג‑טער. ");
INSERT INTO ydd_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","דעריבער פלעגט ער רעדן מיט די יידן אין שול און מיט די יראת שמימדיקע (גריכן), און יעדן טאג אויפן מארק מיט די לייט, וועמען ער האט געטראפן. ");
INSERT INTO ydd_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","און אויך אייניקע פון די עפיקורעישע און סטאישע פילאזאפן האבן זיך געפלפולט מיט אים. און אייניקע האבן געזאגט: וואס וויל דער דאזיקער פלאפלער זאגן? אנדערע אבער (האבן געזאגט): ער שיינט אויס צו זיין א מגיד פון פרעמדע ג‑טער—ווייל ער האט אנגעזאגט די גוטע בשורה פון יהושען/ישוען און תחית המתים. ");
INSERT INTO ydd_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","און האבן אים גענומען און אוועקגעפירט צום ארעאפאגוס, און געזאגט: צי קענען מיר וויסן, וואס פאר א נייע לערנונג עס איז די דאזיקע, פון וועלכער דו רעדסט? ");
INSERT INTO ydd_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ווארום דו ברענגסט עפעס פרעמדע זאכן צו אונדזערע אויערן; מיר ווילן דעריבער וויסן, וואס דאס זאל זיין. ");
INSERT INTO ydd_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","און אלע אטענער און די פרעמדע, וואס האבן דארטן געוואוינט, פלעגן פארברענגען די צייט נישט מיט קיין שום אנדערס ווי אדער מיט זאגן אדער מיט הערן עפעס נייעס. ");
INSERT INTO ydd_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","און פוילוס האט זיך אנידערגעשטעלט אין דער מיט פונם ארעאפאגוס און געזאגט: מענער פון אטען, פון אלעם זע איך ווי איר זענט פול מיט רעליגיע. ");
INSERT INTO ydd_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ווארום פארבייגייענדיק און זעענדיק אייערע הייליקטימער, האב איך אויך געפונען א מזבח, אויף וועלכן עס איז געווען אויפגעשריבן: צום אומבאקאנטן ג‑ט. זעט, דאס דאזיקע, וואס איר קענט נישט און דינט, זאג איך אייך אָן. ");
INSERT INTO ydd_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","דער ג‑ט, וועלכער האט באשאפן די וועלט און אלץ, וואס איז אין איר, ער, וואס איז האר פון הימל און ערד, וואוינט נישט אין טעמפלען האנטגעמאכטע; ");
INSERT INTO ydd_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ער ווערט אויך נישט באדינט פון מענטשלעכע הענט, פונקט ווי ער וואלט עפעס געדארפט, ווארום ער גיט אלעמען לעבן און אטעם און אלץ; ");
INSERT INTO ydd_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","און האט פון איין בלוט געמאכט אלע מענטשלעכע פעלקער, צו וואוינען אויף דער גאנצער אייבערפלאך פון דער ערד, באשטימענדיק פעסטגעזעצטע צייטן און די גרענעצן פון זייער וואוינונג; ");
INSERT INTO ydd_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","כדי זיי זאלן זוכן ג‑ט, אפשר וועלן זיי אים דערפילן און געפינען, הגם ער איז נישט ווייט פון יעדן איינעם פון אונדז; ");
INSERT INTO ydd_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ווארום אין אים לעבן מיר און באוועגן זיך און האבן א קיום, אזויווי אויך אייניקע פון אייערע פאעטן האבן געזאגט: ווארום אן אפשטאם פון אים זענען מיר. ");
INSERT INTO ydd_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","זייענדיק דעריבער פון ג‑טס אפשטאמונג, געשיקט עס זיך נישט (פאר אונדז) צו מיינען, אז די ג‑טהייט איז ענלעך צו גאלד אדער זילבער אדער שטיין, צו א בילד פון מענטשלעכער קונסט און דערפינדונג. ");
INSERT INTO ydd_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","און אויף די צייטן פון אומוויסן האט ה׳ אוועקגעקוקט, איצט אבער באפעלט ער אלע מענטשן אומעטום, תשובה צו טאן; ");
INSERT INTO ydd_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ווייל ער האט פעסטגעזעצט א טאג, אין וועלכן ער וועט משפטן די וועלט מיט גערעכטיקייט דורך א מאן, וועמען ער האט באשטימט דערצו; און האט אלעמען געגעבן א פארזיכערונג, אויפוועקנדיק אים פון די טויטע. ");
INSERT INTO ydd_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","און ווי זיי האבן געהערט פון תחית המתים, האבן א טייל זיך אויסגעלאכט; אנדערע אבער האבן געזאגט: מיר וועלן דיך הערן נאכאמאל וועגן דער דאזיקער זאך. ");
INSERT INTO ydd_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","און אזוי איז פוילוס ארויסגעגאנגען פון זייער מיט. ");
INSERT INTO ydd_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","אייניקע מענער אבער האבן זיך באהאפטן צו אים, און געגלויבט, צווישן וועלכע (עס האבן זיך) אויך (געפונען) דיאניזיוס, דער ארעאפאגיטיקער, און א פרוי, מיטן נאמען דאמאריס, און אנדערע מיט זיי. ");
INSERT INTO ydd_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","נאך דעם איז ער ארויסגעגאנגען פון אטען, און איז געקומען קיין קארינט. ");
INSERT INTO ydd_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","און האט געפונען א געוויסן יידן מיטן נאמען אקווילא, געבוירן אין פאנטוס, נאר וואס אנגעקומען פון איטאליען, מיט פריסקילא זיין פרוי, צוליב דעם, וואס קלוידיוס האט באפוילן, אז אלע יידן זאלן פארלאזן רוים; און ער איז געגאנגען צו זיי. ");
INSERT INTO ydd_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","און ווייל ער איז געווען פונם זעלביקן פאך, איז ער ביי זיי פארבלייבן, און זיי האבן געארבעט, ווארום זיי זענען געווען געצעלטנמאכער פון דער מלאכה. ");
INSERT INTO ydd_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","און יעדן שבת האט ער גערעדט אין שול, און געזוכט איבערצוצייגן יידן און גריכן. ");
INSERT INTO ydd_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ווי אבער סילא און טימאטעוס זענען אנגעקומען פון מאצעדאניען, האט פוילוס זיך אינגאנצן געווידמעט דעם ווארט, עדות זאגנדיק צו יידן, אז יהושע/ישוע איז דער משיח. ");
INSERT INTO ydd_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ווען אבער זיי האבן זיך אקייגנגעשטעלט און געלעסטערט, האט ער אפגעשאקלט די מלבושים און געזאגט צו זיי: אייער בלוט אויף אייער קאפ; איך בין ריין; פון איצט אָן וועל איך גיין צו די אומות העולם. ");
INSERT INTO ydd_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","און איז אוועקגעגאנגען פון דארטן, און איז אריינגעגאנגען אין הויז פון א געוויסן (מאן), מיטן נאמען טיציוס יוסטוס, א יראת שמימדיקער (גר), וועמעס הויז איז געווען ביי דער שול. ");
INSERT INTO ydd_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","קריספוס אבער, דער גבאי פון דער שול, האט געגלויבט אין דעם האר צוזאמען מיט זיין גאנץ הויזגעזינד; און א סך פון די קארינטער, וועלכע האבן געהערט, האבן געגלויבט און זיך געלאזט טובל זיין אין דער מקווה. ");
INSERT INTO ydd_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","און דער האר האט געזאגט צו פוילוסן דורך א חיזיון ביינאכט: האב נישט קיין מורא, נאר רעד, און שווייג נישט; ");
INSERT INTO ydd_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ווייל איך בין מיט דיר, און קיינער וועט דיך נישט אנרירן, דיר שלעכטס צו טאן; מחמת איך האב א גרויס פאלק אין דער דאזיקער שטאט. ");
INSERT INTO ydd_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","און ער האט (דארטן) זיך אויפגעהאלטן א יאר מיט זעקס חדשים, לערנענדיק צווישן זיי דאס ווארט פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ווען אבער גאליאן איז געווען פראקאנסול פון אכאיא, האבן די יידן זיך איינשטימיק אויפגעשטעלט קעגן פוילוסן, און אים געפירט צו דער כסא המשפט, ");
INSERT INTO ydd_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","און געזאגט: דער דאזיקער מאן רעדט איבער די מענטשן צו דינען ה׳ להיפך דער תורה. ");
INSERT INTO ydd_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","און ווי פוילוס האט געוואלט אויפעפענען זיין מויל, האט גאליאן געזאגט צו די יידן; אויב עס וואלט טאקע געווען עפעס אן עוולה אדער א בייזע געמיינהייט, יידן, פארשטייט זיך, אז איך וואלט געווען געדולדיק מיט אייך; ");
INSERT INTO ydd_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","אויב אבער עס זענען שאלות וועגן ווערטער און נעמען אין דער תורה אייערער, זעט איר אליין דערצו; קיין שופט פון די דאזיקע זאכן וויל איך נישט זיין. ");
INSERT INTO ydd_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","און האט זיי פארטריבן פון דער כסא המשפט. ");
INSERT INTO ydd_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","און אלע האבן געכאפט סאסטענעסן, דעם גבאי פון שול, און אים געשלאגן פאר דער כסא המשפט; און גאליאן האט זיך נישט אנגענומען (פון דער אנטיסעמיטיזם). ");
INSERT INTO ydd_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","און פארבלייבנדיק נאך דארטן א סך טעג, האט פוילוס זיך געזעגנט מיט די ברידער, און איז אוועקגעפארן מיט דער שיף קיין סיריען, און מיט אים פריסקילא און אקווילא; נאכן אפגאלן זיך (אלס פרומער ייד) דעם קאפ אין קענקרעא, ווארום ער האט געהאט געטאן א נדר. ");
INSERT INTO ydd_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","און זיי זענען געקומען קיין עפעזוס, און ער האט זיי דארטן איבערגעלאזט; אליין אבער איז ער אריינגעגאנגען אין דער שול און האט גערעדט צו די יידן. ");
INSERT INTO ydd_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","און ווען זיי האבן אים געבעטן צו בלייבן אויף א לענגערער צייט, האט ער נישט איינגעשטימט; ");
INSERT INTO ydd_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","נאר האט זיך געזעגנט און געזאגט: איך וועל ווידער קומען צו אייך, אם ירצה ה׳, און האט זיך אוועקגעשיפט פון עפעזוס. ");
INSERT INTO ydd_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","און קומענדיק קיין קיסריה, איז ער אויסגעשטיגן און האט אפגעגעבן שלום דער קהלה, און איז אראפ קיין אנטיאכיען. ");
INSERT INTO ydd_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","און נאך דעם ווי ער האט (דארטן) פארברענגט א געוויסע צייט, איז ער אוועק, און איז דורכגעגאנגען כסדר די געגנט פון גאלאטיען און פריגיען, שטארקנדיק אלע תלמידים. ");
INSERT INTO ydd_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","און א געוויסער ייד, מיטן נאמען אפאלאס, געבוירן אין אלעקסאנדריען, א געלערנטער מאן, מעכטיק אין די כתבי (הקודש), איז געקומען קיין עפעזוס. ");
INSERT INTO ydd_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","דער דאזיקער איז געווען געלערנט אין דעם דרך ה׳; און זייענדיק אייפערדיק אין גייסט, האט ער גערעדט און געלערנט גענוי וואס שייך יהושען/ישוען, הגם ער האט בלויז געקענט די מקווה (פון תשובה) פון יוחנן; ");
INSERT INTO ydd_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","און האט אנגעהויבן צו רעדן מיט דרייסטקייט אין שול. ווי אבער פריסקילא און אקווילא האבן אים געהערט, האבן זיי אים גענומען צו זיך, און אים נאך גענויער קלאר געמאכט דעם דרך ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","וועלנדיק אבער גיין קיין אכאיא, האבן די ברידער אים צוגעגעבן מוט, און געשריבן צו די תלמידים, אז מען זאל אים אויפנעמען; און ווען ער איז אהינגעקומען, האט ער פיל געהאלפן די, וואס האבן געגלויבט דורך דעם חסד; ");
INSERT INTO ydd_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ווארום מיטן גאנצן כוח האט ער געהאלטן וויכוחים מיט די יידן, אויפווייזנדיק עפנטלעך פון די כתבי (הקודש), אז יהושע/ישוע איז דער משיח. ");
INSERT INTO ydd_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","און עס איז געשען, בשעת אפאלאס איז געווען אין קארינט, איז פוילוס, נאכן דורכגיין די אינלענדישע טיילן פון (קליין) אזיען, געקומען קיין עפעזוס; און ווען ער האט (דארט) געפונען אייניקע תלמידים, ");
INSERT INTO ydd_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","האט ער צו זיי געזאגט: צי האט איר מקבל געווען דעם רוח הקודש, ווען איר זענט געווארן מאמינים? האבן זיי געזאגט צו אים: מיר האבן אפילו נישט געהערט, אויב עס געפינט זיך א רוח הקודש. ");
INSERT INTO ydd_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","האט ער געזאגט: אויף וואס דען האט איר זיך מקווה געטובלט? און זיי האבן געזאגט: אויף דער מקווה פון תשובה פון יוחנן. ");
INSERT INTO ydd_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","האט פוילוס געזאגט: יוחננס מקווה איז געווען א מקווה פון תשובה, זאגנדיק צום פאלק, אז זיי זאלן גלויבן אין דעם, וועלכער וועט קומען נאך אים, דאס הייסט אין יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","און הערנדיק דאס, האבן זיי זיך געלאזט טובל זיין אין דער מקווה אין דעם נאמען פון דעם האר יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","און ווי פוילוס האט ארויפגעלייגט אויף זיי די הענט, איז דער רוח הקודש געקומען אויף זיי; און זיי האבן גערעדט מיט לשונות און נבואות געזאגט. ");
INSERT INTO ydd_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","און זיי אלע זענען געווען אן ערך צוועלף מענער. ");
INSERT INTO ydd_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","און ער איז אריינגעגאנגען אין שול, און האט גערעדט מיט דרייסטקייט במשך פון דריי חדשים, האלטנדיק וויכוחים און איבערצייגנדיק בנוגע דעם מלכות פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ווען אבער אייניקע האבן הארט געמאכט זייערע הערצער און נישט געגלויבט, רעדנדיק שלעכטס לגבי דעם דרך (ה׳) פאר דעם עולם, איז ער אוועק פון זיי, און האט אפגעשיידט די תלמידים, און טאג טעגלעך גערעדט אין דער בית המדרש ישיבה פון א געוויסן טיראנוס. ");
INSERT INTO ydd_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","דאס דאזיקע איז אנגעגאנגען צוויי יאר לאנג, אזוי, אז אלע איינוואוינער פון (קליין) אזיען, יידן און גריכן, האבן געהערט דאס ווארט פון דעם האר. ");
INSERT INTO ydd_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","און ה׳ האט געטאן אויסערגעוויינלעכע וואונדער דורך די הענט פון פוילוסן; ");
INSERT INTO ydd_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","אזוי, אז מען פלעגט אוועקטראגן פון זיין לייב טיכלעך אדער פארטיכער צו די שלאפע, און די חלאתן האבן זיי פארלאזט, און די בייזע גייסטער זענען ארויס. ");
INSERT INTO ydd_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","און אייניקע פון די יידישע וואנדערער, בעלי שם, האבן אונטערגענומען אנצורופן דעם נאמען פון דעם האר יהושע/ישוע אויף די, וואס האבן געהאט בייזע גייסטער, אזוי צו זאגן: איך באשווער אייך ביי יהושען/ישוען, וועמען פוילוס רופט אויס! ");
INSERT INTO ydd_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","און די, וואס האבן דאס געטאן זענען געווען זיבן בנים פון געוויסן סקעווא, א ייד, איינער פון די ”גרויסע כהנים“. ");
INSERT INTO ydd_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","און דער בייזער גייסט האט געענטפערט און געזאגט צו זיי: יהושען/ישוען קען איך, פוילוסן קען איך אויך; ווער אבער זענט איר? ");
INSERT INTO ydd_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","און דער מענטש, אין וועמען עס איז געווען דער בייזער גייסט, האט אויף זיי א שפרונג געטאן, און איבערגעוועלטיקט צוויי פון זיי, און זיי (אזוי) בייגעקומען, אז זיי זענען אנטלאפן פון יענעם הויז נאקעט און פארוואונדעט. ");
INSERT INTO ydd_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","און דאס דאזיקע איז באקאנט געווארן צו אלע יידן און גריכן, וועלכע האבן געוואוינט אין עפעזוס; און א מורא איז געפאלן אויף זיי אלע, און דעם האר ישועס נאמען איז דערהייבט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","און א סך פון די, וואס האבן געגלויבט, זענען געקומען און זיך מתוודה געווען און דערציילט פון זייערע (פריערדיקע) מעשים. ");
INSERT INTO ydd_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","און א סך פון די, וואס האבן זיך פארנומען מיט כישוף, האבן צוזאמענגעברענגט זייערע ביכער, און זיי פארברענט פאר אלעמען אין די אויגן; און מען האט בארעכנט זייער ווערט, און געפונען (אז עס האט באטראפן) פיפציק טויזנט שטיק זילבער. ");
INSERT INTO ydd_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","אזוי מעכטיק איז געוואקסן דאס ווארט פון דעם האר און האט זיך געשטארקט. ");
INSERT INTO ydd_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","און נאך דעם ווי די דאזיקע זאכן זענען געשען, האט פוילוס פארגענומען אין זיין גייסט, אז ווען ער וועט האבן דורכגעגאנגען מאצעדאניען און אכאיא, צו פארן קיין ירושלים, און האט געזאגט: נאך דעם ווי איך וועל דארטן זיין, מוז איך אויך זען רוים. ");
INSERT INTO ydd_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","און אוועקשיקנדיק קיין מאצעדאניען צוויי פון די, וואס האבן אים באדינט, טימאטעוסן און עראסטוסן, איז ער אליין נאך פארבלייבן א געוויסע צייט אין (קליין) אזיען. ");
INSERT INTO ydd_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","און ארום יענער צייט איז געשען נישט קיין קליינע מהומה וועגן דעם (משיחיסטים) דרך (ה׳). ");
INSERT INTO ydd_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ווארום א געוויסער מאן, מיטן נאמען דימעטריוס, א זילבערשמיד, וועלכער פלעגט מאכן זילבערנע טעמפלען פון ארטעמיס, און געבן די האנטווערקער נישט קיין קליינעם פארדינסט; ");
INSERT INTO ydd_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","האט זיי פארזאמלט און די (אנדערע) בעלי מלאכות פון אזעלכע זאכן, און געזאגט: מענער, איר ווייסט, אז פון דער דאזיקער ארבעט האבן מיר אונדזער וואוילשטאנד. ");
INSERT INTO ydd_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","און איר זעט און הערט, אז נישט נאר אין עפעזוס, נאר כמעט אין גאנץ (קליין) אזיען האט דער דאזיקער פוילוס איבערגערעדט און אפגעקערט אן אנגעזעענעם המון מענטשן, זאגנדיק, אז דאס זענען נישט קיין ג‑טער, וואס ווערן געמאכט מיט הענט; ");
INSERT INTO ydd_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","און עס איז א סכנה, אז נישט בלויז אונדזער פאך וועט ווערן צו שפאט, נאר אפילו דער טעמפל פון דער גרויסער ג‑טין ארטעמיס וועט פאר נישט געאכט ווערן; און עס קען נאך זיין, אז עס וועט אוועקגענומען ווערן די מאיעסטעט פון איר, וועמען גאנץ (קליין) אזיען און די באוואוינטע וועלט דינט. ");
INSERT INTO ydd_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","און ווי זיי האבן דאס געהערט, זענען זיי געווארן פול מיט צארן, און האבן געשריגן, אזוי צו זאגן: גרויס איז די ארטעמיס פון די עפעזער! ");
INSERT INTO ydd_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","און די שטאט איז פול געווארן פון דער מהומה; און אלע צוזאמען האבן געשטורמט צום טעאטער, מיטשלעפנדיק גאיוסן און אריסטארכוסן, מאצעדאניער, פוילוסנס באגלייטער אויף דער נסיעה. ");
INSERT INTO ydd_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ווי אבער פוילוס האט געוואלט אריינגיין צווישן דעם פאלק, האבן די תלמידים אים נישט געלאזט. ");
INSERT INTO ydd_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","און אויך אייניקע פון די הויכע באאמטע פון (קליין) אזיען, זייענדיק זיינע פריינד, האבן געשיקט צו אים, און געבעטן ער זאל זיך נישט איינשטעלן צו קומען אין טעאטער אריין. ");
INSERT INTO ydd_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","און זיי האבן געשריגן, א טייל איין זאך, אנדערע עפעס אנדערש, ווארום די פארזאמלונג איז געווען צעטומלט; און די מערסטע האבן נישט געוואוסט, צוליב וועלכן זיי זענען זיך צוזאמענגעקומען. ");
INSERT INTO ydd_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","און פון דעם המון האט מען ארויסגעשלעפט אלעקסאנדערן, וועמען די יידן האבן געשטופט פארויס. און אלעקסאנדער האט געמאכט א צייכן מיט דער האנט, און געוואלט האלטן א פארטיידיקונג רעדע פארן פאלק. ");
INSERT INTO ydd_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","דערוויסנדיק (אין אנטיסעמיטיזם) זיך אבער, אז ער איז א ייד, האבן אלע געשריגן מיט איין קול במשך פון כמעט צוויי שעה; גרויס איז ארטעמיס (די ג-טין) פון די עפעזער! ");
INSERT INTO ydd_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","און דער שטאט שרייבער, בארואיקנדיק דעם המון מענטשן, האט געזאגט: אָ מענער פון עפעזוס, צי געפינט זיך דען עמיצער צווישן מענטשן, וואס ווייסט נישט, אז די שטאט פון די עפעזער איז די טעמפל היטערין פון דער גרויסער ארטעמיס און פון איר בילד, וואס איז אראפגעפאלן פון הימל? ");
INSERT INTO ydd_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","דעריבער, אזוי ווי מען קען די דאזיקע זאכן נישט סותר זיין, האט איר זיך געזאלט פארהאלטן רואיק, און גארנישט טאן אין איילעניש. ");
INSERT INTO ydd_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ווארום איר האט אהערגעברענגט די דאזיקע מענטשן, וועלכע זענען נישט קיין טעמפל רויבער, נישט קיין לעסטערער פון אונדזער ג‑טין. ");
INSERT INTO ydd_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","דעריבער, אויב דימעטריוס און די האנט ווערקער מיט אים האבן טאקע עפעס א טענה קעגן עמיצן, ווערן (דאך) געהאלטן עפנטלעכע טעג פון משפטים, און עס זענען דא פראקאנסולן; זאלן זיי אנקלאגן איינס דאס אנדערע. ");
INSERT INTO ydd_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","אויב אבער איר זוכט עפעס אנדערש, וועט עס געלייזט ווערן אויף דער געזעצלעכער פארזאמלונג. ");
INSERT INTO ydd_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ווארום מיר זענען אויך אין א סכנה, אנגעקלאגט צו ווערן וועגן א מרידה צוליב דער היינטיקער מעשה, ווייל עס איז נישטא קיין סיבה, מיט וועלכער מיר זאלן קענען פארענטפערן דאס דאזיקע מהומה. ");
INSERT INTO ydd_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","און ווען ער האט דאס געזאגט, האט ער פאנאנדערגעלאזט די פארזאמלונג. ");
INSERT INTO ydd_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","און נאך דעם ווי די מהומה האט זיך איינגעשטילט, האט פוילוס געשיקט נאך די תלמידים און גערעדט טרייסטווערטער צו זיי, האט זיך געזעגנט און איז ארויסגעגאנגען צו גיין קיין מאצעדאניען. ");
INSERT INTO ydd_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","און דורכגייענדיק יענע פראווינצן, און טרייסטנדיק זיי (ד. ה. די דארטיקע מאמינים) מיט א סך ווערטער, איז ער געקומען קיין גריכנלאנד. ");
INSERT INTO ydd_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","און איז (דארט) פארבלייבן במשך פון דריי חדשים; און היות א פארשווערונג איז געמאכט געווארן פון די יידן קעגן אים, ווען ער האט בדעה געהאט זיך אוועקצושיפן קיין סיריען, האט ער באשלאסן זיך אומצוקערן איבער מאצעדאניען. ");
INSERT INTO ydd_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","און ביז (קליין) אזיען האבן אים באגלייט סאפאטרוס בן פורוס פון בערעא; און פון די טעסאלאניקער, אריסטארכוס און סעקונדוס; און גאיוס פון דערבע, און טימאטעוס; און טיכיקוס און טראפימוס, פון (קליין) אזיען. ");
INSERT INTO ydd_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","די דאזיקע אבער זענען געגאנגען פארויס, און האבן געווארט אויף אונדז אין טראאס. ");
INSERT INTO ydd_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","און נאך פסח זענען מיר אוועקגעפארן מיט דער שיף פון פיליפיען, און זענען אין פינף טעג ארום געקומען צו זיי קיין טראאס, וואו מיר זענען פארבלייבן זיבן טעג. ");
INSERT INTO ydd_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","און דעם ערשטן טאג פון דער וואך, ווען מיר זענען זיך צונויפגעקומען צו ברעכן ברויט, האט פוילוס געדרשנט צו זיי, האבנדיק בדעה צומארגנס אפצופארן; און האט מאריך געווען די דרשה ביז האלבער נאכט. ");
INSERT INTO ydd_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","און עס זענען געווען א סך לאמפן אין דער אויבערשטוב, וואו מיר זענען געווען פארזאמלט. ");
INSERT INTO ydd_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","און אויפן פענצטער איז געזעסן א געוויסער בחור, מיטן נאמען עווטיכוס, (וועלכער) איז אריינגעפאלן אין א טיפן שלאף; און בשעת פוילוס האט נאך אלץ פארצויגן מיט זיין דרשענען, האט דער שלאף אים בייגעקומען, און ער איז אראפגעפאלן פונם דריטן שטאק, און מען האט אים אויפגעהויבן א טויטן. ");
INSERT INTO ydd_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","פוילוס אבער איז אראפגעגאנגען, און איז ארויפגעפאלן אויף אים, און ארומנעמענדיק אים, האט ער געזאגט: באאומרואיקט זיך נישט, ווארום די נשמה זיינע איז (נאך) אין אים. ");
INSERT INTO ydd_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","און איז ארויפגעגאנגען, האט געבראכן דאס ברויט, און (אליין) טועם געווען, און נאך לאנג מיט זיי גערעדט, ביז עס איז געווארן שחרית‎, און אזוי איז ער אוועקגעגאנגען. ");
INSERT INTO ydd_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","און דאס בחור האט מען געברענגט צופירן א לעבעדיקן, און זיי האבן זיך נישט ווייניק געטרייסט. ");
INSERT INTO ydd_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","מיר אבער זענען געגאנגען פארויס צו דער שיף, און האבן זיך אוועקגעשיפט קיין אסוס, כדי דארטן אויפצונעמען פוילוסן; ווארום אזוי האט ער באפוילן, ווייל אליין האט ער געוואלט גיין צופוס. ");
INSERT INTO ydd_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","און ווען ער האט זיך מיט אונדז געטראפן אין אסוס, האבן מיר אים אויפגענומען, און זענען געקומען קיין מיטילענע. ");
INSERT INTO ydd_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","און ווייטער פארנדיק פון דארטן, זענען מיר דעם נעכסטן טאג אנגעקומען אנטקעגנאיבער כיוס; און דעם אנדערן טאג זענען מיר געקומען קיין סאמאס; און דעם פאלגענדיקן טאג זענען מיר געקומען קיין מילעטוס. ");
INSERT INTO ydd_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ווארום פוילוס האט באשלאסן פארבייצופארן עפעזוס, כדי ער זאל נישט דארפן פארלירן קיין צייט אין (קליין) אזיען; ווייל ער האט זיך געאיילט, ווי ווייט מעגלעך פאר אים, צו זיין אין ירושלים אויף שבועות. ");
INSERT INTO ydd_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","און פון מילעטוס האט ער געשיקט קיין עפעזוס, און געלאזט רופן די זקנים פון דער קהלה. ");
INSERT INTO ydd_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","און ווען זיי זענען געקומען צו אים, האט ער צו זיי געזאגט: איר ווייסט אליין, וויאזוי איך האב מיך אויפגעפירט צווישן אייך די גאנצע צייט, פון דעם ערשטן טאג אָן, ווען איך בין געקומען קיין אזיען, ");
INSERT INTO ydd_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","דינענדיק דעם האר מיט יעדער עניוות און מיט טרערן און נסיונות, וועלכע זענען געקומען אויף מיר דורך די פארשווערונגען פון יידן; ");
INSERT INTO ydd_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ווי איך האב גארנישט פארהוילן פון אייך פון דעם, וואס איז נוצלעך, אז איך זאל עס נישט האבן געזאגט צו אייך, און אייך געלערנט, סאי עפנטלעך סאי פון הויז צו הויז, ");
INSERT INTO ydd_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","עדות זאגנדיק צו יידן און צו גריכן וועגן תשובה צו ה׳ און אמונה אין אונדזער האר יהושע/ישוע המשיח. ");
INSERT INTO ydd_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","און זע, איצט, געבונדן אינם גייסט, גיי איך קיין ירושלים, נישט וויסנדיק, וואס עס וועט מיך דארטן באגעגענען, ");
INSERT INTO ydd_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","אחוץ דעם, וואס דער רוח הקודש איז מעיד צו מיר אין יעדער שטאט, אזוי צו זאגן, אז עס ווארטן אויף מיר קייטן און צרות. ");
INSERT INTO ydd_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","נאר איך האלט, אז מיין לעבן איז נישט ווערט די רייד, אזוי טייער איז עס פאר מיר, אויב איך זאל נאר קענען פארענדיקן דעם לעבנס לויף מיינעם, און די עבודה, וואס איך האב באקומען פון דעם האר יהושע/ישוע, עדות צו זאגן פון דער גוטער בשורה פון ה׳ס חסד. ");
INSERT INTO ydd_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","און זע, איצט ווייס איך, אז איר וועט מער קיינמאל נישט זען מיין פנים, איר אלע, צווישן וועמען איך בין ארומגעגאנגען, אויסרופנדיק דאס קעניגרייך פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","דערפאר בין איך מעיד צו אייך דעם היינטיקן טאג, אז איך בין ריין פון דעם בלוט פון אלע (מענטשן). ");
INSERT INTO ydd_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ווארום איך האב מיך נישט צוריקגעהאלטן, אייך נישט אנצוזאגן דעם גאנצן ראט ווילן פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","היט זשע זיך און די גאנצע סטאדע, אויף וועלכער דער רוח הקודש האט אייך באשטימט פאר משגיחים, כדי צו פאשען ה׳ס קהלה, וועלכע ער האט געקויפט מיט זיין אייגן בלוט. ");
INSERT INTO ydd_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","איך ווייס, אז נאך מיין אוועקגיין וועלן אריינקומען צווישן אייך בייזע וועלף, וואס וועלן נישט האבן קיין רחמנות אויף דער סטאדע; ");
INSERT INTO ydd_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","און פון אייך אליין וועלן אויפשטיין מענער, וואס רעדן פארקערטע זאכן, אפצונייגן די תלמידים נאך זיך. ");
INSERT INTO ydd_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","צוליב דעם זאלט איר שטיין אויף דער וואך, געדענקענדיק, אז במשך פון דריי יאר האב איך נישט אויפגעהערט, בייטאג און ביינאכט, צו זאגן מוסר צו יעדן איינעם פון אייך מיט טרערן. ");
INSERT INTO ydd_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","און איצט לאז איך אייך איבער אויף ה׳ס באראט און צום ווארט פון זיין חסד, וועלכער האט די מאכט אייך צו דערבויען און אייך צו געבן די ירושה צווישן אלע געהייליקטע. ");
INSERT INTO ydd_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","זילבער, אדער גאלד, אדער מלבושים, האב איך פון קיינעם נישט באגערט. ");
INSERT INTO ydd_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","איר אליין ווייסט, אז די דאזיקע הענט מיינע האבן מיר געדינט פאר מיינע הצטרכותן און פאר די הצטרכותן פון מיינע באגלייטער. ");
INSERT INTO ydd_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","אלץ האב איך אייך געוויזן, אז הארעווענדיק אויף אזא אופן, דארף מען העלפן די שוואכע, און געדענקען דעם האר ישועס ווערטער, ווייל ער אליין האט געזאגט: עס איז וויילער צו געבן ווי צו נעמען. ");
INSERT INTO ydd_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","און נאך דעם ווי ער האט דאס געזאגט, האט ער גענייגט זיינע קניען, און מתפלל געווען מיט זיי אלעמען. ");
INSERT INTO ydd_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","און עס איז געווארן צווישן אלע א שטארק געוויין, און זיי זענען געפאלן פוילוסן אויפן האלדז און האבן אים געקושט, ");
INSERT INTO ydd_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","זייענדיק שמערצלעך באטריבט, אם מערסטן איבער דעם ווארט, וואס ער האט געזאגט, אז זיי וועלן מער נישט זען זיין פנים—און האבן אים באגלייט צו דער שיף. ");
INSERT INTO ydd_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","און עס איז געשען, ווען מיר האבן זיך אפגעשיידט און זענען אוועקגעפארן פון זיי, פארנדיק אין א גראדער ריכטונג, זענען מיר געקומען קיין קאס, און דעם נעכסטן טאג קיין ראדאס, און פון דארטן קיין פאטארא; ");
INSERT INTO ydd_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","און אזויווי מיר האבן געפונען א שיף, וואס איז געגאנגען קיין פעניציען, זענען מיר איינגעשטיגן און אפגעפארן. ");
INSERT INTO ydd_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","און דערזעענדיק די (אינדזל) קפריסין, און איבערלאזנדיק זי אויף לינקס, האבן מיר זיך אוועקגעשיפט קיין סיריען, און זענען אנגעקומען קיין צור; ווארום דארטן האט די שיף געזאלט אויסלאדן איר פראכט. ");
INSERT INTO ydd_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","און נאך דעם ווי מיר האבן אויפגעזוכט די תלמידים, זענען מיר דארט פארבלייבן זיבן טעג; און זיי האבן גערעדט צו פוילוסן דורך דעם רוח (הקודש), נישט ארויפצוגיין קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","און ווען מיר האבן געהאט געענדיקט די טעג, זענען מיר ארויסגעגאנגען און אוועקגעפארן; און אלע האבן אונדז באגלייט מיט די פרויען און קינדער ביז אויסער דער שטאט; און מיר האבן געקניט אויפן ים ברעג און תפילה געטאן; ");
INSERT INTO ydd_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","דערנאך האבן מיר זיך געזעגנט איינס מיטן אנדערן, און זענען איינגעשטיגן אויף דער שיף, זיי אבער האבן זיך אומגעקערט אהיים. ");
INSERT INTO ydd_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","און מיר האבן פארענדיקט די ים רייזע פון צור, און זענען אנגעקומען קיין פטאלעמייס; און אפגעגעבנדיק שלום צו די ברידער, זענען מיר פארבלייבן ביי זיי איין טאג. ");
INSERT INTO ydd_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","און צומארגנס זענען מיר ארויסגעגאנגען, און זענען געקומען קיין קיסריה; און זענען אריינגעגאנגען אין דעם הויז פון פיליפוס דעם מבשר, איינער פון די זיבן, און איינגעשטאנען ביי אים. ");
INSERT INTO ydd_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","דער דאזיקער (פיליפוס) האט געהאט פיר טעכטער בתולות, וועלכע האבן נבואות געזאגט. ");
INSERT INTO ydd_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","און בשעת מיר זענען (דארט) פארבלייבן א סך טעג, איז אראפגעקומען פונם (לאנד) יהודה א געוויסער נביא, מיטן נאמען אגאבוס. ");
INSERT INTO ydd_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","און קומענדיק צו אונדז, האט ער גענומען פוילוסנס גארטל, האט זיך געבונדן די פיס און די הענט, און געזאגט: דאס זאגט דער רוח הקודש: דעם מאן, וועמעס גארטל דער איז, וועלן די יידן אין ירושלים אזוי בינדן, און (אים) איבערגעבן אין גויישע הענט אריין. ");
INSERT INTO ydd_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","און ווען מיר האבן דאס געהערט, האבן מיר און די דארטיקע אים געבעטן, אז ער זאל נישט ארויפגיין קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","דעמאלט האט פוילוס געענטפערט: וואס טוט איר, וואס איר וויינט און צעברעכט מיר דאס הארץ? ווארום איך בין גרייט נישט בלויז געבונדן צו ווערן, נאר אויך צו שטארבן אין ירושלים פאר דעם נאמען פונם האר יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","און אזויווי ער האט זיך נישט געלאזט איבעררעדן, האבן מיר שטיל געשוויגן, אזוי צו זאגן: זאל געשען דעם הארס רצון! ");
INSERT INTO ydd_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","און נאך די דאזיקע טעג האבן מיר איינגעפאקט אונדזערע זאכן, און זענען ארויפגעגאנגען קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","און עס זענען אויך מיטגעגאנגען מיט אונדז אייניקע פון די תלמידים פון קיסריה, מיטפירנדיק א געוויסן מנאזאן, פון קפריסין, אן אלטער תלמיד, ביי וועמען מיר האבן געזאלט וואוינען. ");
INSERT INTO ydd_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","און ווען מיר זענען געקומען קיין ירושלים, האבן די ברידער אונדז אויפגענומען מיט שמחה. ");
INSERT INTO ydd_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","און דעם נעכסטן טאג איז פוילוס מיט אונדז אריינגעגאנגען צו יעקבן, און אלע זקנים זענען אהינגעקומען. ");
INSERT INTO ydd_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","און אפגעגעבנדיק זיי שלום, האט ער באריכות דערציילט אלץ, וואס ה׳ האט געטאן צווישן די אומות העולם דורך זיין עבודה. ");
INSERT INTO ydd_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","און הערנדיק דאס, האבן זיי געלויבט ה׳; און צו אים געזאגט: דו זעסט, ברודער, וויפל טויזנטער יידן עס זענען, וועלכע גלויבן, און אלע זענען קנאים פאר דער תורה; ");
INSERT INTO ydd_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","און מען האט זיי (פאלשע קלאנג) דערציילט וועגן דיר, אז דו לערנסט אלע יידן, וועלכע געפינען זיך צווישן די אומות העולם, זיך אפפאלן פון (תורת) משה, זאגנדיק, אז זיי זאלן נישט מל זיין די קינדער, און זיך נישט נוהג זיין לויט די (יידישע) מנהגים. ");
INSERT INTO ydd_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","וואס זשע וועט זיין? אין יעדן פאל וועלן זיי (דאך) הערן, אז דו ביסט געקומען. ");
INSERT INTO ydd_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","טו דעריבער דאס, וואס מיר וועלן דיר זאגן: ביי אונדז געפינען זיך פיר מענער, וועלכע האבן א נדר אויף זיך; ");
INSERT INTO ydd_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","נעם די דאזיקע און רייניק דיך מיט זיי, און באצאל פאר זיי, כדי זיי זאלן זיך לאזן אפגאלן דעם קאפ; און אלע וועלן וויסן, אז אין דעם, וואס זיי האבן געהערט וועגן דיר, איז גאר נישטא (קיין אמת). נאר אז דו אליין גייסט אויך אויפן דרך הישר (דרך ה׳), און היטסט אפ די תורה. ");
INSERT INTO ydd_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","און וואס שייך די גויישע מאמינים, האבן מיר שוין געשריבן א בריוו, באשליסנדיק, אז זיי זאלן זיך אפהיטן (צו עסן) פון קרבנות צו אפג-טער און פון בלוט און פון דערווארגן (פלייש) און פון זנות. ");
INSERT INTO ydd_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","פוילוס האט דעמאלט גענומען די מענער, האט זיך גערייניקט מיט זיי דעם אנדערן טאג, און איז אריינגעגאנגען אין בית המקדש אריין, און געלאזט וויסן די דערפילונג פון די טעג פון רייניקונג, ביז עס זאל געברענגט ווערן דאס קרבן פאר יעדן איינעם פון זיי. ");
INSERT INTO ydd_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","און ווי די זיבן טעג האבן זיך שוין באלד געהאט געענדיקט, האבן יידן פון (קליין) אזיען אים דערזען אין בית המקדש, און האבן אויפגעהעצט דעם גאנצן המון, און ארויפגעלייגט זייערע הענט אויף אים, ");
INSERT INTO ydd_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","שרייענדיק, אנשי ישראל, העלפט: דער דאזיקער מענטש איז עס, וואס לערנט אלעמען אומעטום קעגן דעם (יידישן) פאלק און דער תורה און דעם דאזיקן מקום (קדוש), נאכמער, ער האט אפילו אריינגעפירט גריכן אין בית המקדש אריין און פארשוועכט דאס דאזיקע מקום קדוש. ");
INSERT INTO ydd_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ווארום זיי האבן פריער געהאט געזען טראפימוסן דעם עפעזער אין דער שטאט מיט אים; און געמיינט, אז פוילוס האט אים אריינגעפירט אין בית המקדש אריין. ");
INSERT INTO ydd_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","און די גאנצע שטאט האט זיך באוועגט, און עס איז געווארן א צוזאמענגעלויף פון פאלק; און זיי האבן געכאפט פוילוסן און אים ארויסגעשלעפט אויסער דעם בית המקדש; און גלייך האבן זיך די טירן געשלאסן. ");
INSERT INTO ydd_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","און ווי זיי האבן אים געוואלט טייטן, איז געקומען א שמועה צום הויפטמאן פון דער אפטיילונג, אז גאנץ ירושלים איז אין אן אויפברויז. ");
INSERT INTO ydd_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","האט ער גיך גענומען זעלנער און אפיצירן, און איז אראפגעלאפן צו זיי; און דערזעענדיק דעם הויפטמאן און די זעלנער, האבן זיי אויפגעהערט צו שלאגן פוילוסן. ");
INSERT INTO ydd_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","דאן איז דער הויפטמאן צוגעגאנגען, האט אים ארעסטירט, און באפוילן מען זאל אים בינדן מיט צוויי קייטן, און האט געפרעגט, ווער ער איז, און וואס ער האט געטאן. ");
INSERT INTO ydd_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","און יעדער איינער אינם המון האט עפעס אנדערש געשריגן; און נישט קענענדיק זיך דערוויסן אויף זיכער, צוליב דעם געטומל, האט ער באפוילן, מען זאל אים אוועקפירן אין דער פעסטונג אריין. ");
INSERT INTO ydd_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","און ווען ער איז געקומען צו די טרעפ, האבן די זעלנער אים געטראגן צוליב דעם געדרענג פון דעם המון; ");
INSERT INTO ydd_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ווארום די פאלקסמאסע האט נאכגעפאלגט, שרייענדיק: אוועק מיט אים! ");
INSERT INTO ydd_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","און בשעת פוילוס האט געזאלט אריינגעפירט ווערן אין דער פעסטונג אריין, האט ער געזאגט צום הויפטמאן: צי איז עס מיר דערלויבט עפעס צו זאגן צו דיר? און ער האט געזאגט: דו קענסט גריכיש? ");
INSERT INTO ydd_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","צי ביסטו דען נישט דער מצרי, וועלכער האט מיט א געוויסער צייט צוריק געמאכט א מרידה, און ארויסגעפירט אין דער מדבר אריין די פיר טויזנט מענער פון די סיקרים? ");
INSERT INTO ydd_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","האט פוילוס געזאגט: איך בין א ייד פון טארסוס אין קיליקיען, א בירגער פון אן אנגעזעענער שטאט; בעט איך דיך, דערלויב מיר צו רעדן צום פאלק. ");
INSERT INTO ydd_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","און ווען ער האט עס אים דערלויבט, האט פוילוס זיך געשטעלט אויף די טרעפ, און געמאכט א צייכן מיט דער האנט צום פאלק; און אז עס איז געווארן א גרויסע שטילקייט, האט ער גערעדט צו זיי אויף לשון קודש, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ברידער און פאטערס, הערט איצט אויס מיין פארטיידיקונג פאר אייך— ");
INSERT INTO ydd_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","און ווי זיי האבן דערהערט, אז ער רעדט צו זיי אויף לשון קודש, האבן זיי זיך נאך רואיקער פארהאלטן; און ער האט געזאגט— ");
INSERT INTO ydd_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","איך בין א ייד, געבוירן אין טרסוס אין קיליקיען, דערצויגן אבער בין איך געווארן (דא) אין דער דאזיקער שטאט, ביי די פיס פון (תנא רבן) גמליאל, און מען האט מיך פלייסיק געלערנט די תורה פון אונדזערע אבות, און א קנאי בין איך געווען פאר ה׳, ווי איר אלע זענט עס ביים היינטיקן טאג. ");
INSERT INTO ydd_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","און דעם דאזיקן (דרך ה׳) דרך האב איך גערודפט ביז צום טויט, בינדנדיק און איבערגעבנדיק אין תפיסה אריין מענער און פרויען. ");
INSERT INTO ydd_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ווי אפילו דער כהן גדול וועט עס מיר עדות זאגן און דאס גאנצע בית הזקנים, פון וועמען איך האט באקומען בריוו צו די ברידער, און בין געגאנגען קיין דמשק צו ברענגען אויך די, וואס זענען דארטן געווען, געבונדן קיין ירושלים, כדי זיי זאלן באשטראפט ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","און עס איז געשען, בשעת איך בין געווען אויפן וועג און האב מיך דערנענטערט צו דמשק, ארום האלבן טאג האט מיך פלוצלונג ארומגעלויכטן א גרויס ליכט פון הימל. ");
INSERT INTO ydd_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","און איך בין אנידערגעפאלן אויף דער ערד, און האב געהערט א קול זאגן צו מיר: שאול, שאול, וואס פארפאלגסטו מיך? ");
INSERT INTO ydd_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","און איך האב געענטפערט: ווער ביסטו, האר? און ער האט צו מיר געזאגט: איך בין יהושע/ישוע פון נצרת, וועמען דו פארפאלגסט. ");
INSERT INTO ydd_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","און די, וואס זענען מיט מיר געווען, האבן געזען דאס ליכט, נאר דאס קול, וואס האט גערעדט מיט מיר, האבן זיי נישט (מיט פארשטענדיקייט) געהערט. ");
INSERT INTO ydd_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","און איך האב געזאגט: וואס זאל איך טאן, האר? און דער האר האט צו מיר געזאגט: שטיי אויף, גיי קיין דמשק; און דארטן וועט דיר (שוין) געזאגט ווערן וועגן אלעם, וואס איז דיר באשטימט געווארן, צו טאן. ");
INSERT INTO ydd_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","אזויווי אבער איך האב נישט געקענט זען צוליב דעם גלאנץ פון יענעם ליכט, בין איך געקומען קיין דמשק, געפירט ביי דער האנט פון די, וואס זענען מיט מיר געווען. ");
INSERT INTO ydd_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","און א געוויסער חנניה, א ג‑טספארכטיקער מאן לויט דער תורה, וועלכער האט געהאט א גוטן שם ביי אלע יידן, וואס האבן דארט געוואוינט, ");
INSERT INTO ydd_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","איז געקומען צו מיר, און איז געשטאנען לעבן מיר, געזאגט: ברודער שאול, ווער ווידער זעענדיק! און אין דער זעלביקער שעה האב איך געקוקט אויף אים. ");
INSERT INTO ydd_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","און ער האט געזאגט: דער ג‑ט פון אונדזערע אבות האט דיך אויסדערוויילט, צו וויסן זיין רצון און צו זען דעם צדיק און צו הערן א קול פון זיין מויל ארויס. ");
INSERT INTO ydd_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","מחמת דו וועסט זיין אן עדות פאר אים צו אלע מענטשן פון דעם, וואס דו האסט געזען און געהערט. ");
INSERT INTO ydd_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","און איצט וואס צעגערסטו? שטיי אויף, לאז דיך טובל זיין אין דער מקווה, און וואש אפ דיינע זינד, אנרופנדיק זיין נאמען. ");
INSERT INTO ydd_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","און עס איז געשען, בעת איך האב מיך אומגעקערט קיין ירושלים און האב תפילה געטאן אין בית המקדש, בין איך אריינגעפאלן אין א טראנס, ");
INSERT INTO ydd_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","און האב אים געזען זאגן צו מיר: ^אייל דיך, און גיי ארויס געשווינט פון ירושלים, ווייל זיי וועלן (דא) נישט אננעמען דיין עדות זאגן וועגן מיר. ");
INSERT INTO ydd_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","און איך האב געזאגט: האר, זיי אליין ווייסן (דאך), אז איך פלעג איינזעצן אין תפיסה און שלאגן אין אלע שולן די, וועלכע גלויבן אין דיר; ");
INSERT INTO ydd_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","און בשעת דאס בלוט פון דיין עדות סטעפאנוס איז פארגאסן געווארן, בין איך אליין געשטאנען דערביי מסכים זייענדיק (דערצו), און אכטונג געבנדיק אויף די מלבושים פון די, וואס האבן אים געהרגעט. ");
INSERT INTO ydd_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","און ער האט צו מיר געזאגט: גיי; ווייל איך וועל דיך שיקן ווייט צו די אומות העולם. ");
INSERT INTO ydd_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","און זיי האבן אים אויסגעהערט ביז צו דעם דאזיקן ווארט; און האבן אויפגעהויבן זייער קול, זאגנדיק: פארטיליק אזא מענטשן פון דער ערד; ווארום ער איז נישט ווערט וואס ער לעבט! ");
INSERT INTO ydd_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","און בשעת זיי האבן (אזוי) געשריגן און אראפגעווארפן די מלבושים (פון זיך) און געווארפן שטויב אינדערלופטן, ");
INSERT INTO ydd_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","האט דער הויפטמאן באפוילן, ער זאל אריינגעפירט ווערן אין דער פעסטונג אריין, און האט געהייסן, מען זאל אים אויספארשן מיט שמיץ, כדי זיך צו דערוויסן, צוליב וועלכער סיבה זיי האבן אזוי געשריגן קעגן אים. ");
INSERT INTO ydd_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ווי אבער מען האט אים אויסגעצויגן צום שמייסן, האט פוילוס געזאגט צום אפיציר, וואס איז געשטאנען דערנעבן: צי איז אייך דען דערלויבט צו שמייסן א מענטשן, וואס איז א רוימישער בירגער און וועלכער איז נישט פארמשפט? ");
INSERT INTO ydd_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","און ווי דער אפיציר האט דאס געהערט, איז ער צוגעגאנגען צום הויפטמאן און אים דערציילט, אזוי צו זאגן: וואס גייסטו טאן? דער דאזיקער מענטש איז דאך א רוימער! ");
INSERT INTO ydd_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","און דער הויפטמאן איז צוגעקומען און געזאגט צו אים: זאג מיר, דו ביסט (טאקע) א רוימער? האט ער געזאגט: יא. ");
INSERT INTO ydd_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","האט דער הויפטמאן געענטפערט: פאר א גרויסן פרייז האב איך מיר דערווארבן די דאזיקע בירגערשאפט. און פוילוס האט געזאגט: איך אבער בין געבוירן געווארן (א רוימער). ");
INSERT INTO ydd_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","און די, וואס האבן אים געזאלט אויספארשן, זענען דעריבער גלייך אוועקגעגאנגען פון אים; און דער הויפטמאן האט זיך געפארכטן, דערוויסנדיק זיך, אז ער איז א רוימער, און אז ער האט אים געלאזט בינדן. ");
INSERT INTO ydd_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","צומארגנס אבער, וועלנדיק זיך דערוויסן אויף זיכער, וועגן וואס ער איז באשולדיקט געווארן פון די יידן, האט ער אים באפרייט פון די קייטן, און באפוילן, אז די הויפט כהנים זאלן זיך צוזאמענקומען און דאס גאנצע סנהדרין: און האט אראפגעפירט פוילוסן, און אים אוועקגעשטעלט פאר זיי. ");
INSERT INTO ydd_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","און פוילוס האט זיך איינגעקוקט אויפן סנהדרין, און געזאגט: ברידער, איך האב געלעבט פאר ה׳ מיט א גאנץ און גוט געוויסן ביז צום היינטיקן טאג. ");
INSERT INTO ydd_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","אבער דער כהן גדול חנניה האט באפוילן די, וואס זענען דארט ביי אים געשטאנען, אים צו שלאגן אויפן מויל. ");
INSERT INTO ydd_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","האט פוילוס דעמאלט צו אים געזאגט: ה׳ וועט דיך שלאגן, דו ווייס געקאלכטע וואנט; און דו זיצט מיך צו משפטן לויט דער תורה, און באפעלסט מען זאל מיך שלאגן להיפך דער תורה? ");
INSERT INTO ydd_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","אבער די, וואס זענען דארט געשטאנען האבן געזאגט: דעם כהן גדול פון ה׳ זידלסטו? ");
INSERT INTO ydd_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","האט פוילוס געזאגט: ברידער, איך האב נישט געוואוסט, אז עס איז דער כהן גדול; ווארום עס שטייט געשריבן: א נשיא ביי דיין פאלק זאלסטו נישט פלוכן. (שמות כב, כז.) ");
INSERT INTO ydd_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","און וויסנדיק, אז איין טייל איז צדוקים און די אנדערע טייל פרושים, האט פוילוס א געשריי געטאן אין דעם סנהדרין: ברידער, איך בין א פרוש בן פרושים; וועגן דער האפענונג פון תחית המתים ווער איך געמשפט! ");
INSERT INTO ydd_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","און ווען ער האט דאס געזאגט, איז געווארן א מחלוקה פון די פרושים מיט די צדוקים, און די מאסע האט זיך געשפאלטן. ");
INSERT INTO ydd_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ווארום די צדוקים זאגן, אז עס איז נישטא קיין תחית המתים, נישט קיין מלאך, נישט קיין גייסט; די פרושים אבער זענען מודה אויף ביידע. ");
INSERT INTO ydd_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","און עס איז געווארן א גרויס געשריי; און עס זענען אויפגעשטאנען אייניקע סופרים פון דעם צד פון די פרושים, און האבן געהאלטן א וויכוח, אזוי צו זאגן: מיר געפינען נישט קיין שום שלעכטס אין דעם דאזיקן מענטשן; און (וואס איז) אויב א גייסט אדער א מלאך האט צו אים גערעדט? ");
INSERT INTO ydd_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","און ווען דאס מחלוקה איז געווארן (גאר) גרויס, האט דער הויפטמאן, מורא האבנדיק, אז פוילוס זאל פון זיי נישט צעריסן ווערן, באפוילן דאס מיליטער אראפצוגיין און אים א כאפ צו טאן פון זייער מיט, און אריינצופירן אין דער פעסטונג אריין. ");
INSERT INTO ydd_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","און אין דער פאלגענדיקער נאכט איז דער האר געשטאנען ביי אים, און געזאגט: זיי שטארק; ווארום ווי דו האסט עדות געזאגט וועגן מיר אין ירושלים, אזוי דארפסטו אויך עדות זאגן אין רוים. ");
INSERT INTO ydd_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","און ווען עס איז געווארן טאג האבן די יידן געמאכט א פארשווערונג, און זיך געבונדן מיט א פייערלעכער שבועה, און געזאגט, אז זיי וועלן נישט עסן און נישט טרינקען ביז זיי וועלן נישט הרגענען פוילוסן. ");
INSERT INTO ydd_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","און עס זענען געווען מער ווי פערציק, וועלכע האבן געמאכט די דאזיקע שבועה. ");
INSERT INTO ydd_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","און זיי זענען געקומען צו די הויפט כהנים און צו די זקנים, און האבן געזאגט: מיט א פייערלעכער שבועה האבן מיר זיך געבונדן גארנישט טועם צו זיין, ביז מיר וועלן נישט טייטן פוילוסן. ");
INSERT INTO ydd_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","דעריבער לאזט איצט מיט דעם סנהדרין וויסן דעם הויפטמאן, אז ער זאל אים אראפברענגען צו אייך, פונקט ווי איר וואלט געוואלט גענויער אויספארשן וועגן אים; און איידער ער וועט זיך דערנענטערן צו אייך, זענען מיר גרייט אים אומצוברענגען. ");
INSERT INTO ydd_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","נאר פוילוסנס שוועסטערן‑זון האט געהערט פון דער לויערונג, און איז געקומען, און אריינגעגאנגען אין דער פעסטונג אריין, און האט עס דערציילט פוילוסן. ");
INSERT INTO ydd_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","און פוילוס האט גערופן איינעם פון די אפיצירן, און געזאגט: פיר דעם דאזיקן יונגנמאן צום הויפטמאן, ווארום ער האט אים עפעס צו דערציילן. ");
INSERT INTO ydd_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","און ער האט אים גענומען און אוועקגעפירט צום הויפטמאן, און געזאגט: דער ארעסטאנט פוילוס האט מיך גערופן און געבעטן, איך זאל ברענגען צו דיר דעם דאזיקן יונגנמאן, וועלכער האט עפעס צו דיר צו זאגן. ");
INSERT INTO ydd_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","און דער הויפטמאן האט אים גענומען ביי דער האנט, האט אים אוועקגעפירט אויף א זייט, און (אים) געפרעגט: וואס איז עס, וואס דו האסט מיר צו דערציילן? ");
INSERT INTO ydd_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","האט ער געזאגט: די יידן האבן איינגעשטימט דיך צו בעטן, אז דו זאלסט צומארגנס אראפפירן פוילוסן צום סנהדרין, פונקט ווי זיי וואלטן געוואלט עפעס גענויער אויספארשן וועגן אים. ");
INSERT INTO ydd_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","דו זאלסט דיך אבער נישט לאזן איבעררעדן פון זיי, ווארום מער ווי פערציק (מענטשן) פון זיי לאקערן אויף אים, און האבן זיך פייערלעך געשוואוירן, נישט צו עסן און נישט צו טרינקען, ביז זיי וועלן אים נישט האבן אומגעברענגט; און זענען איצט גרייט און ווארטן (בלויז) אויף דיין הבטחה. ");
INSERT INTO ydd_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","און דער הויפטמאן האט אוועקגעשיקט דעם יונגנמאן, אנזאגנדיק אים: זאלסט קיינעמען נישט אויסזאגן, אז דו האסט מיר דאס צו וויסן געטאן. ");
INSERT INTO ydd_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","און האט גערופן צוויי פון די אפיצירן, און געזאגט: גרייט צו צוויי הונדערט זעלנער, וואס זאלן גיין קיין קיסריה, און זיבעציק רייטער, און צוויי הונדערט שפיזנטרעגער, אין דער דריטער שעה פון דער נאכט; ");
INSERT INTO ydd_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","און (ער האט באפוילן) זיי זאלן צוגרייטן בהמות, כדי ארויפצוזעצן פוילוסן און אים אוועקפירן אין זיכערהייט צו פעליקסן דעם גובערנאטאר. ");
INSERT INTO ydd_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","און האט געשריבן א בריוו, אויף דעם אופן: ");
INSERT INTO ydd_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","קלוידיוס ליזיאס צום חשובסטן גובערנאטאר פעליקס, שלום. ");
INSERT INTO ydd_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","דער דאזיקער מאן איז געפאנגען געווארן פון די יידן, און זיי האבן אים געוואלט טייטן; (נאר) איך בין געקומען מיטן מיליטער און האב אים אפגעראטעוועט, דערוויסנדיק זיך, אז ער איז א רוימער. ");
INSERT INTO ydd_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","און וועלנדיק וויסן די סיבה, פארוואס זיי האבן אים אנגעקלאגט, האב איך אים אראפגעפירט צו זייער סנהדרין; ");
INSERT INTO ydd_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","און האב געפונען, אז ער ווערט אנגעקלאגט וועגן שאלות פון זייער תורה, און האט נישט קיין שום באשולדיקונג, אז ער זאל זיין חייב מיתה אדער קייטן. ");
INSERT INTO ydd_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ווי אבער עס איז מיר געוויזן געווארן, אז עס וועט זיין א פארשווערונג אויף דעם מאן, האב איך אים תיכף געשיקט צו דיר, באפעלנדיק אויך די באשולדיקער צו רעדן פאר דיר קעגן אים. ");
INSERT INTO ydd_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","די זעלנער האבן דעריבער גענומען פוילוסן, לויט ווי עס איז זיי באפוילן געווארן, און אים אוועקגעפירט ביינאכט קיין אנטיפאטריס. ");
INSERT INTO ydd_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","און צומארגנס, לאזנדיק די רייטער גיין מיט אים, האבן זיי זיך אומגעקערט אין דער פעסטונג אריין; ");
INSERT INTO ydd_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","און זיי זענען אריינגעגאנגען קיין קיסריה און האבן איבערגעגעבן דעם בריוו צום גובערנאטאר, און אויך אוועקגעשטעלט פוילוסן פאר אים. ");
INSERT INTO ydd_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","און נאכן איבערלייענען, האט ער אים געפרעגט פון וועלכער פראווינץ ער איז; און אז ער האט געהערט, אז פון קיליקיען, ");
INSERT INTO ydd_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","האט ער געזאגט: איך וועל דיך אויסהערן, ווען די אנקלאגער דיינע וועלן אויך (אהער) קומען; און האט באפוילן, מען זאל אים באוואכן אין הורדוסנס פאלאץ. ");
INSERT INTO ydd_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","און פינף טעג שפעטער איז דער כהן גדול חנניה אראפגעקומען מיט אייניקע זקנים, און א רעדנער, א געוויסער טערטולוס; און זענען דערשינען פארן גובערנאטאר קעגן פוילוסן. ");
INSERT INTO ydd_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","און ווען ער איז גערופן געווארן, האט טערטולוס אנגעהויבן אים צו באשולדיקן, זאגנדיק: אז מיר געניסן פיל פרידן דורך דיר, און אז א סך פארבעסערונגען זענען געטאן געווארן צו דעם דאזיקן פאלק דורך דיין השגחה, ");
INSERT INTO ydd_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","(דאס) אנערקענען מיר אלעמאל און אומעטום, אָ נאבעלער פעליקס, מיט פיל דאנקבארקייט. ");
INSERT INTO ydd_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","נאר כדי איך זאל דיך נישט צופיל באלעסטיקן, בעט איך דיך אין דיין באשיידנקייט אונדז אויסצוהערן בקיצור. ");
INSERT INTO ydd_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ווארום מיר האבן געפונען דעם דאזיקן מאן ווי א פעסט, און אן אויפהעצער צו מחלוקת צווישן אלע יידן איבער דער גאנצער באוואוינטער וועלט, א מנהיג פון דער כיתה פון די נוצרים; ");
INSERT INTO ydd_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","וואס ער האט אויך געמאכט א פארזוך מחלל צו זיין דאס בית המקדש; און מיר האבן אים ארעסטירט און געוואלט משפטן לויט אונדזער תורה. ");
INSERT INTO ydd_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","נאר ליזיאס דער הויפטמאן איז געקומען און מיט געוואלד אים ארויסגעריסן פון אונדזערע הענט, ");
INSERT INTO ydd_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","באפעלנדיק זיינע באשולדיקער צו קומען צו דיר; פון וועמען, נאך א חקירה ודרישה, דו וועסט זיך קענען דערוויסן, אלע די דאזיקע זאכן, וועגן וועלכע מיר באשולדיקן אים. ");
INSERT INTO ydd_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","און די יידן האבן מסכים געווען, זאגנדיק, אז עס איז אזוי. ");
INSERT INTO ydd_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","און פוילוס האט געענטפערט, נאך דעם ווי דער גובערנאטאר האט אים געגעבן א צייכן צו רעדן. וויסנדיק, אז דו ביסט שוין פון כמה יארן א שופט ביים דאזיקן פאלק, פארטיידיק איך מיך מיט גוטן מוט; ");
INSERT INTO ydd_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ווייל דו קענסט זיך דערוויסן, אז עס איז נישט מער ווי צוועלף טעג, זינט איך בין ארויפגעגאנגען קיין ירושלים, זיך צו בוקן צו ה׳; ");
INSERT INTO ydd_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","און נישט האבן זיי מיך געפונען האלטנדיק א וויכוח מיט עמיצן אדער מאכנדיק א מחלוקה ביים המון אינם בית המקדש, נישט אין די שולן, נישט אין דער שטאט, ");
INSERT INTO ydd_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","און זיי קענען דיר אפילו נישט באווייזן דאס, וועגן וועלכן זיי באשולדיקן מיך איצט. ");
INSERT INTO ydd_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","נאר דאס דאזיקע בין איך זיך פאר דיר מתוודה, אז לויט דעם (דרך ה׳) דרך, וועלכן זיי רופן אן כיתה, אזוי־אָ דין איך דעם ג‑ט פון אונדזערע אבות, גלויבנדיק אלץ, וואס שטייט געשריבן אין דער תורה און אין די נביאים; ");
INSERT INTO ydd_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","און האב א האפענונג צו ה׳, וועלכע זיי אליין דערווארטן, אז עס וועט זיין א תחית המתים פון צדיקים און רשעים. ");
INSERT INTO ydd_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","דעריבער באמי איך מיך תמיד צו האבן א לויטער געוויסן פאר ה׳ און פאר לייטן. ");
INSERT INTO ydd_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","און נאך פיל יארן בין איך געקומען צו ברענגען נדבות צו מיין פאלק, און קרבנות; ");
INSERT INTO ydd_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","מיט וועלכע זיי האבן מיך געפונען, נאך דעם ווי איך האב מיך געהייליקט אינם בית המקדש, נישט מיט קיין המון מענטשן און נישט מיט קיין געטומל; נאר עס זענען דא אייניקע יידן פון (קליין) אזיען, ");
INSERT INTO ydd_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","וועלכע וואלטן געדארפט דערשיינען פאר דיר און מאכן א באשולדיקונג, אויב זיי האבן עפעס קעגן מיר. ");
INSERT INTO ydd_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","אדער זאלן די דאזיקע (מענטשן) אליין זאגן, וואס פאר אן אומגערעכטיקייט זיי האבן געפונען אין מיר, בשעת איך בין געשטאנען פארן סנהדרין, ");
INSERT INTO ydd_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","אחוץ וועגן דעם דאזיקן איינעם ווארט, וואס איך האב אויסגעשריגן, שטייענדיק צווישן זיי: וועגן תחית המתים ווער איך היינט געמשפט פון אייך. ");
INSERT INTO ydd_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","פעליקס אבער, קענענדיק דעם (דרך ה׳) דרך גענויער, האט זיי אפגעלייגט, און געזאגט: ווען ליזיאס דער הויפטמאן וועט אראפקומען, וועל איך אנטשיידן אייער זאך. ");
INSERT INTO ydd_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","און האט באפוילן דעם אפיציר אים צו היטן מיט מילדקייט, און נישט צו שטערן קיינעם פון זיינע פריינד אים צו באדינען. ");
INSERT INTO ydd_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","און אין אייניקע טעג ארום איז פעליקס געקומען מיט זיין פרוי דרוסילא, וועלכע איז געווען א יידישקע, און געלאזט רופן פוילוסן, און אים אויסגעהערט וועגן דער אמונה (דרך ה׳) אינם משיח יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","און בשעת ער האט גערעדט וועגן צדקות, און נצחון איבער יצר הרע, און דעם משפט לעתיד לבוא (יום הדין), האט פעליקס זיך געפארכטן, און געענטפערט: איצט גיי דיר שוין; און ווען איך וועל האבן א באקוועמערע צייט, וועל איך דיך ווידער לאזן רופן. ");
INSERT INTO ydd_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","צוגלייך האט ער אויך געהאפט, אז עס וועט אים געגעבן ווערן געלט פון פוילוסן, כדי ער זאל אים באפרייען, צוליב דעם האט ער אויך עפטערס געלאזט שיקן נאך אים און מיט אים גערעדט. ");
INSERT INTO ydd_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","און ווען צוויי יאר זענען פארפלאסן, האט פעליקס באקומען פארציוס פעסטוסן צום נאכפאלגער; און וועלנדיק ארויסווייזן די יידן א חסד, האט פעליקס איבערגעלאזט פוילוסן אין תפיסה. ");
INSERT INTO ydd_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","און פעסטוס, קומענדיק אין דער פראווינץ אריין, איז אין דריי טעג ארום ארויפגעגאנגען פון קיסריה קיין ירושלים. ");
INSERT INTO ydd_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","און די הויפט כהנים און די פארנעמסטע יידן זענען דערשינען פאר אים קעגן פוילוסן, און האבן אים געבעטן, ");
INSERT INTO ydd_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","פארלאנגענדיק א געפעליקייט קעגן אים (ד.ה. פוילוסן), אז ער זאל אים לאזן ברענגען קיין ירושלים; ווייל זיי האבן געמאכט א פארשווערונג אים צו הרגענען אונטערוועגנס. ");
INSERT INTO ydd_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","פעסטוס אבער האט געענטפערט, אז פוילוס בלייבט אונטער וואך אין קיסריה, און אליין וועט ער אין גיכן ארויספארן אהין. ");
INSERT INTO ydd_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","דעריבער זאלן די באפולמעכטיקטע צווישן אייך, האט ער געזאגט, מיטאראפקומען (מיט מיר), אויב עס איז דא עפעס אן אומרעכט אין דעם מאן, זאלן זיי אים אנקלאגן. ");
INSERT INTO ydd_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","און נאכן פארבלייבן ביי זיי נישט מער ווי אכט אדער צען טעג, איז ער אראפ קיין קיסריה; צומארגנס האט ער זיך אנידערגעזעצט אויף דער ריכטער שטול, און באפוילן, מען זאל ברענגען פוילוסן. ");
INSERT INTO ydd_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","און ווען ער איז געקומען, האבן זיך די יידן, וועלכע זענען אראפגעקומען פון ירושלים, געשטעלט ארום אים, ברענגענדיק א סך און שווערע באשולדיקונגען, וואס זיי האבן נישט געקענט באווייזן; ");
INSERT INTO ydd_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","בעת פוילוס האט זיך פארטיידיקט: נישט קעגן דער יידישער תורה, נישט קעגן דעם בית המקדש, נישט קעגן קיסר האב איך עפעס געזינדיקט. ");
INSERT INTO ydd_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","פעסטוס אבער, וועלנדיק געפינען חן ביי די יידן, האט ענטפערנדיק פוילוסן געזאגט: צי ווילסטו ארויפגיין קיין ירושלים, און דארטן פון מיר געמשפט ווערן וועגן די דאזיקע זאכן? ");
INSERT INTO ydd_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","האט פוילוס געזאגט: איך שטיי פארן קיסרס טריבונאל שטול, וואו איך דארף געמשפט ווערן; יידן האב איך נישט געטאן קיין שום עוולה, ווי אפילו דו ווייסט עס גאנץ גוט. ");
INSERT INTO ydd_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","און אויב איך בין דאך באגאנגען א פארברעך, און האב געטאן עפעס, פאר וועלכן איך בין חייב מיתה, אויסמיידן איך מיך נישט צו שטארבן; אויב אבער קיין זאך איז נישט (אמת), פון וועלכע זיי באשולדיקן מיך, קען מיך קיינער נישט איבערגעבן צו זיי. איך אפעליר צום קיסר. ");
INSERT INTO ydd_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","דעמאלט האט פעסטוס זיך באראטן מיט זיינע יועצים, און האט געענטפערט: צום קיסר האסטו אפעלירט, צום קיסר וועסטו גיין! ");
INSERT INTO ydd_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","און נאכן אפלויף פון אייניקע טעג, איז דער קעניג אגריפא מיט בערעניקא געקומען קיין קיסריה און האבן באגריסט פעסטוסן. ");
INSERT INTO ydd_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","און היות זיי האבן דארט פארברענגט א סך טעג, האט פעסטוס געלייגט פארן קעניג פוילוסנס זאך, זאגנדיק: פעליקס האט איבערגעלאזט א געוויסן מאן אין קייטן, ");
INSERT INTO ydd_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","וועגן וועמען, ווען איך בין געקומען קיין ירושלים, די יידישע הויפט כהנים און זקנים זענען דערשינען פאר מיר, פארלאנגענדיק אן אורטייל קעגן אים; ");
INSERT INTO ydd_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","וועמען איך האב געענטפערט, אז עס איז נישט דער מנהג ביי רוימער איבערצוגעבן א מענטשן (צום טויט) איידער דער באשולדיקטער האט די באשולדיקער פאר זיך פנים אל פנים, און באקומט א געלעגנהייט זיך צו פארטיידיקן אויף דער באשולדיקונג. ");
INSERT INTO ydd_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ווען דעריבער זיי זענען זיך אהער צוזאמענגעקומען, האב איך נישט געמאכט קיין אויפהאלט, (נאר גלייך) דעם אנדערן טאג מיך געזעצט אויף דער ריכטער שטול און באפוילן, מען זאל ברענגען דעם מאן. ");
INSERT INTO ydd_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","קעגן וועמען די באשולדיקער, אוועקשטעלנדיק זיך, האבן נישט געברענגט קיין שום באשולדיקונג פון פארברעכנס, ווי איך האב חושד געווען, ");
INSERT INTO ydd_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","נאר האבן געהאט געוויסע טענות צו אים וועגן זייער אייגענער אמונה, און וועגן א געוויסן יהושע/ישוע, וועלכער איז געשטארבן, און וואס פוילוס זאגט, אז ער לעבט. ");
INSERT INTO ydd_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","און איך, זייענדיק אין ספק בנוגע דער אויספארשונג פון אזעלכע שאלות, האב געפרעגט, צי ער וויל גיין קיין ירושלים און דארטן געמשפט ווערן וועגן די דאזיקע זאכן. ");
INSERT INTO ydd_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","אזויווי אבער פוילוס האט אפעלירט, צו בלייבן אין ארעסט ביז צו דעם קיסרס אנטשיידונג, האב איך באפוילן, ער זאל באוואכט ווערן, ביז איך וועל אים שיקן צום קיסר. ");
INSERT INTO ydd_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","און אגריפא האט געזאגט צו פעסטוסן: איך אליין וואלט אויך געוואלט הערן דעם מענטשן. צומארגנס, האט ער געזאגט, וועסטו אים הערן. ");
INSERT INTO ydd_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","צומארגנס דעריבער, ווען אגריפא איז געקומען מיט בערעניקא מיט גרויס פאראד, און זענען אריינגעגאנגען אינם געריכטזאל מיט די הויפטלייט און אנגעזעענסטע מענער פון דער שטאט, האט פעסטוס געגעבן א באפעל, מען זאל ברענגען פוילוסן. ");
INSERT INTO ydd_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","און פעסטוס האט געזאגט; קעניג אגריפא, און איר אלע מענער, וועלכע זענען (דא) אנוועזנד ביי אונדז, איר זעט דעם דאזיקן (מענטשן), וועגן וועמען די גאנצע מאסע פון די יידן האט מיך געבעטן אין ירושלים און אויך דא, שרייענדיק, אז ער טאר לענגער נישט לעבן. ");
INSERT INTO ydd_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","איך האב אבער פארשטאנען, אז ער האט גארנישט געטאן, פאר וועלכן ער זאל זיין חייב מיתה; נאר ווייל ער אליין האט אפעלירט צום קיסר, האב איך באשלאסן אים צו שיקן. ");
INSERT INTO ydd_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","איך האב אבער נישט עפעס גענויעס צו שרייבן וועגן אים צו מיין האר. דערפאר האב איך אים געברענגט פאר אייך, און איבערהויפט פאר דיר, קעניג אגריפא, כדי נאך דער אויספארשונג זאל איך האבן וואס צו שרייבן. ");
INSERT INTO ydd_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ווארום עס שיינט מיר אויס נישט לאגיש, צו שיקן א געפאנגענעם, און נישט אנצוגעבן די באשולדיקונגען קעגן אים. ");
INSERT INTO ydd_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","און אגריפא האט געזאגט צו פוילוסן: עס איז דיר דערלויבט צו רעדן פאר דיר אליין. דעמאלט האט פוילוס אויסגעשטרעקט די האנט און זיך פארטיידיקט: ");
INSERT INTO ydd_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","איך שעץ מיך גליקלעך, אָ קעניג אגריפא, וואס איך דארף מיך היינט פארטיידיקן פאר דיר וועגן אלעם, וואס די יידן קלאגן מיך אָן; ");
INSERT INTO ydd_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","איבערהויפט ווייל דו ביסט א קענער פון אלע מנהגים און שאלות ביי יידן; דערפאר בעט איך דיך, דו זאלסט מיך אויסהערן מיט געדולד. ");
INSERT INTO ydd_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","וואס שייך מיין שטייגער לעבן פון דער יוגנט אָן, וועלכער איז געווען פונם סאמע אנהויב צווישן מיין פאלק אין ירושלים, ווייסן אלע יידן, ");
INSERT INTO ydd_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","און קענען מיך שוין פון לאנג, זיי זאלן נאר וועלן עדות זאגן, אז לויט דער שטרענגסטער כיתה פון אונדזער אמונה האב איך געלעבט, א פרוש. ");
INSERT INTO ydd_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","און איצט שטיי איך געמשפט צו ווערן צוליב דער האפענונג פון דער הבטחה, וועלכע ה׳ האט געמאכט צו אונדזערע אבות, ");
INSERT INTO ydd_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","צו וועלכער אונדזערע צוועלף שבטים, דינענדיק ה׳ בהתמדה יומם ולילה, האפן צו דערגרייכן. וועגן דער האפענונג ווער איך אנגעקלאגט פון די יידן, אָ קעניג! ");
INSERT INTO ydd_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","פארוואס האלט מען עס ביי אייך פאר אומגלויבלעך, אז ה׳ וועקט אויף טויטע? ");
INSERT INTO ydd_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","איך אליין טאקע האב מיר געטראכט, אז איך מוז א סך טאן קעגן דעם נאמען פון יהושע/ישוע פון נצרת. ");
INSERT INTO ydd_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","און האב עס אויך געטאן אין ירושלים; און פיל פון די הייליקע האב איך איינגעשלאסן אין תפיסות, האבנדיק באקומען מאכט פון די הויפט כהנים; און ווען מען האט זיי אומגעבראכט האב איך צוגעשטימט דערצו. ");
INSERT INTO ydd_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","און אין אלע שולן האב איך זיי אפט באשטראפט, און זיי געצוואונגען צו לעסטערן; און זייענדיק אויסערסט צארנדיק אויף זיי, האב איך זיי גערודפט אפילו ביז אין שטעט חוץ לארץ. ");
INSERT INTO ydd_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","און בשעת איך בין געפארן וועגן דעם קיין דמשק מיט רשות און אויפטראג פון די הויפט כהנים, ");
INSERT INTO ydd_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","האב איך אין מיטן טאג געזען אונטערוועגנס, אָ קעניג, א ליכט פון הימל, העלער ווי די זון, (וואס) האט מיך ארומגעלויכטן און די, וואס זענען געפארן מיט מיר. ");
INSERT INTO ydd_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","און ווען מיר אלע זענען אנידערגעפאלן אויף דער ערד. האב איך געהערט א קול, וואס האט צו מיר געזאגט אויף לשון קודש: שאול, שאול וואס פארפאלגסטו מיך? עס איז שווער פאר דיר צו שטויסן קעגן שפיציקע שטעקנס. ");
INSERT INTO ydd_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","און איך האב געזאגט: ווער ביסטו, האר? און דער האר האט געזאגט: איך בין יהושע/ישוע, וועמען דו פארפאלגסט. ");
INSERT INTO ydd_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","נאר הויב דיך אויף, און שטעל דיך אויף דיינע פיס; ווארום פאר דעם דאזיקן האב איך מיך צו דיר באוויזן, דיך צו מאכן פאר א דינער און עדות פון דעם, וואס דו האסט געזען פון מיר, און פון די זאכן, אין וועלכע איך וועל מיך צו דיר באווייזן; ");
INSERT INTO ydd_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","איך וועל דיך מציל זיין פון דעם (יידישן) פאלק און פון די אומות (העולם), צו וועלכע איך שיק דיך, ");
INSERT INTO ydd_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","אויפצועפענען זייערע אויגן, אז זיי זאלן זיך אומקערן פון דער פינצטערניש צום ליכט, און פון דער מאכט פונם שׂטן צו ה׳, כדי זיי זאלן באקומען פארגעבונג פון זינד, און א ירושה צווישן די, וועלכע זענען געהייליקט געווארן דורך (דרך ה׳) אמונה אין מיר. ");
INSERT INTO ydd_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","דערפאר, אָ קעניג אגריפא, בין איך נישט געווארן אומגעהארכזאם צו דעם חיזיון פון הימל; ");
INSERT INTO ydd_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","נאר ערשטנס צו די אין דמשק און אין ירושלים, און איבערן גאנצן לאנד יהודה, און צו די אומות העולם האב איך געדרשנט, אז זיי זאלן תשובה טאן און זיך אומקערן צו ה׳, און טאן מעשים (טובים), וואס זענען ראוי פון תשובה. ");
INSERT INTO ydd_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","צוליב דעם דאזיקן האבן מיך יידן געכאפט אינם בית המקדש, און האבן פארזוכט מיך צו טייטן. ");
INSERT INTO ydd_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","דעריבער אזויווי איך האב באקומען די הילף, וואס איז פון ה׳, שטיי איך ביז צום היינטיקן טאג, עדות זאגנדיק פאר קליין און פאר גרויס, און זאג נישט קיין שום זאך אחוץ דאס, וואס די נביאים און משה (רבינו) האבן געזאגט, אז עס וועט געשען: ");
INSERT INTO ydd_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","אז דער משיח וועט ליידן, און אז ער, דער ערשטער אויפצושטיין תחית המתים, וועט אנזאגן א ליכט צום (יידישן) פאלק און צו די אומות (העולם). ");
INSERT INTO ydd_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","און בשעת ער האט אזוי גערעדט צו זיין פארטיידיקונג, האט פעסטוס געזאגט מיט א הויך קול: פוילוס, דו ביסט אראפ פונם זינען; דאס פילע לערנען דערפירט דיך צו משוגעת. ");
INSERT INTO ydd_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","פוילוס אבער האט געזאגט: איך בין נישט משוגע, אָ נאבעלער פעסטוס, נאר איך רעד ווערטער פון אמת און ניכטערקייט. ");
INSERT INTO ydd_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ווארום וועגן די דאזיקע זאכן, ווייסט דער קעניג, צו וועמען איך רעד אויך מיט דרייסטקייט; ווארום איך בין בטוח, אז פון די דאזיקע זאכן איז אים גארנישט פארהוילן, ווייל עס איז נישט געטאן געווארן אין א (געהיים) ווינקל. ");
INSERT INTO ydd_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","קעניג אגריפא, צי גלויבסטו די נביאים? איך ווייס, אז דו גלויבסט! ");
INSERT INTO ydd_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","און אגריפא (האט געזאגט) צו פוילוסן: עס פעלט נישט קיין סך, און דו האסט מיך איבערגערעדט צו ווערן א (דרך ה׳) משיחיסט! ");
INSERT INTO ydd_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","און פוילוס (האט געזאגט): הלוואי, זאל ה׳ געבן, צי מיט ווייניק צי מיט א סך, אז נישט נאר דו אליין, נאר אויך אלע, וועלכע הערן מיך היינט, זאלן ווערן אזעלכע, ווי איך בין, (נאר) אָן די דאזיקע קייטן. ");
INSERT INTO ydd_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","און דער קעניג איז אויפגעשטאנען און דער גובערנאטאר און בערעניקא און די, וואס זענען געזעסן מיט זיי; ");
INSERT INTO ydd_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","און בשעתן אוועקגיין, האבן זיי גערעדט איינס מיטן אנדערן, אזוי צו זאגן: דער דאזיקער מענטש האט גארנישט געטאן, פאר וועלכן ער זאל זיין חייב מיתה אדער קייטן. ");
INSERT INTO ydd_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","און אגריפא האט געזאגט צו פעסטוסן: דער דאזיקער מענטש וואלט געקענט באפרייט ווערן, אויב ער וואלט נישט אפעלירט צום קיסר. ");
INSERT INTO ydd_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","און ווי עס איז באשלאסן געווארן, אז מיר זאלן זיך אוועקשיפן קיין איטאליען, האט מען איבערגעגעבן פוילוסן מיט אייניקע אנדערע געפאנגענע צו אן אפיציר, מיטן נאמען יוליוס, פון דער (אוגוסטישן) קיסרס אפטיילונג. ");
INSERT INTO ydd_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","און נאכן איינשטייגן אויף א שיף פון אדראמיציום, וועלכע האט געזאלט גיין צו די מקומות פון די (קליין) אזיאטישע ים ברעגעס, זענען מיר אפגעפארן, און מיט אונדז איז געווען אריסטארכוס, א מאצעדאניער פון טעסאלאניקא. ");
INSERT INTO ydd_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","און דעם אנדערן טאג זענען מיר אנגעקומען קיין צידון; און יוליוס האט זיך באצויגן מענטשלעך צו פוילוסן, און אים דערלויבט צו גיין צו זיינע פריינד, כדי צו קומען צו זיך. ");
INSERT INTO ydd_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","און פון דארטן זענען מיר אוועק און זיך פארבייגעשיפט (די אינדזל) קפריסין, צוליב דעם, וואס די ווינטן זענען געווען קעגן אונדז. ");
INSERT INTO ydd_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","און אריבערפארנדיק דעם ים ביי קיליקיען און פאמפיליען, זענען מיר געקומען קיין מירא אין ליציען. ");
INSERT INTO ydd_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","און דארטן האט דער אפיציר געפונען אן אלעקסאנדרינישע שיף, וואס איז געפארן קיין איטאליען, און האט אונדז ארויפגעזעצט אויף דער דאזיקער. ");
INSERT INTO ydd_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","און במשך פון א סך טעג זענען מיר געפארן פאמעלעך און זענען קוים אנגעקומען קיין קנידוס, און ווייל דער ווינט האט אונדז נישט דערלאזט, זענען מיר געפארן פארביי דער (אינדזל) קרעטא, אנטקעגנאיבער סאלמאנע; ");
INSERT INTO ydd_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","און פארנדיק מיט מי ביים ים ברעג, זענען מיר געקומען צו אן ארט, וואס האט געהייסן שיינער האפן נאענט פון דער שטאט לאזעא. ");
INSERT INTO ydd_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","און ווען א סך צייט איז פארגאנגען, און די נסיעה איז שוין געווארן געפערלעך, צוליב דעם וואס אויך דער תענית (יום כיפור) איז שוין געווען פארביי, האט פוילוס זיי געווארנט, ");
INSERT INTO ydd_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","זאגנדיק צו זיי: מענער, איך זע איין, אז די רייזע וועט זיין פארבונדן מיט סכנה און פיל שאדן, נישט בלויז פון דער לאדונג און דער שיף, נאר אויך פון אונדזערע לעבנס. ");
INSERT INTO ydd_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","דער אפיציר אבער האט מער געגלויבט דעם שטייערמאן און דעם אייגנטימער פון דער שיף, ווי פוילוסנס רייד. ");
INSERT INTO ydd_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","און היות דער פארט איז נישט געווען געראם, דארטן איבערצואווינטערן, האט די מערהייט געראטן פון דארטן אוועקצופארן, אפשר וועלן זיי קענען אנקומען קיין פעניקס—א האפן פון קרעטא, וועלכער ליגט (געשיצט) קעגן די צפון מערב און דרום מערב ווינטן—און איבערווינטערן. ");
INSERT INTO ydd_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","און בשעת דער דרום ווינט האט זאנפט געבלאזן, מיינענדיק אז זיי האבן דערגרייכט זייער ציל, האבן זיי ארויפגעצויגן דעם אנקער, און זענען געפארן פארביי קרעטא, נאענט ביים ברעג. ");
INSERT INTO ydd_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","נאר נישט לאנג דערנאך האט זיך אויפגעהויבן קעגן איר (דער שיף) א שטורמווינט, וועלכער הייסט עווראקלידאן; און האט א כאפ געטאן די שיף, ");
INSERT INTO ydd_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","און אז זי האט זיך שוין מער נישט געקענט אקייגנשטעלן דעם ווינט, האבן מיר נאכגעגעבן און זענען געטראגן געווארן (פון די כוואליעס). ");
INSERT INTO ydd_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","און לויפנדיק אזוי הינטער אן אינדזעלע, וואס האט געהייסן קלוידא, איז עס אונדז קוים געלונגען מיט גרויסער מי איינצוהאלטן דאס (רעטונגס) שיפל; ");
INSERT INTO ydd_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","און ווען מען האט עס ארויפגעצויגן, האט מען באנוצט הילפסמיטלען, אונטערצוגארטלען די שיף; און פארכטנדיק זיך, טאמער וועט מען ארויפגעווארפן ווערן אויף דער סירטע, האט מען אראפגעלאזט די זעגל און מען איז אזוי געטריבן געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","און ווייל מיר האבן שווער געליטן פונם שטורמווינט, האט מען דעם אנדערן טאג ארויסגעווארפן די לאדונג; ");
INSERT INTO ydd_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","און דעם דריטן טאג האט מען מיט די אייגענע הענט ארויסגעווארפן דאס שיפסגעצייג. ");
INSERT INTO ydd_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","און אזויווי במשך פון מערערע טעג נישט די זון נישט די שטערן האבן זיך באוויזן, און דער שטורם, נישט קיין קליינער, איז (אויף אונדז) פארלייגט זיך, איז סוף כל סוף פארשווונדן יעדע האפענונג, אז מיר זאלן געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","און היות מען האט שוין לאנג נישט געהאט געגעסן, האט פוילוס זיך געשטעלט אין זייער מיט און געזאגט: אָ מענער, איר האט מיך געדארפט הערן, זיך נישט אוועקצושיפן פון קרעטא, און איר וואלט זיך איינגעשפארט דאס דאזיקע ליידן און דעם שאדן. ");
INSERT INTO ydd_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","איצט אבער פאדער איך אייך אויף, זיך צו שטארקן; ווארום עס וועט קיין נפש פון אייך נישט פארלוירן ווערן, אחוץ די שיף. ");
INSERT INTO ydd_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ווארום אין דער דאזיקער נאכט איז ביי מיר געשטאנען א מלאך פון ה׳, וועמעס איך בין און וועמען איך דין, ");
INSERT INTO ydd_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","אזוי צו זאגן: פארכט דיך נישט, פוילוס; דו דארפסט שטיין פארן קיסר; און זע, ה׳ האט דיר געשענקט אלע, וואס פארן מיט דיר. ");
INSERT INTO ydd_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","דערפאר, מענער, האט מוט; ווייל איך גלויב ה׳, אז עס וועט זיין פונקט אזוי, ווי עס איז מיר געזאגט געווארן. ");
INSERT INTO ydd_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","מיר מוזן אבער געווארפן ווערן אויף עפעס אן אינדזל. ");
INSERT INTO ydd_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","און ווען עס איז געקומען די פערצענטע נאכט, און מיר זענען געטריבן געווארן איבער דעם אדריאטישן ים, האבן די שיפסלייט באמערקט ארום האלבער נאכט, אז זיי דערנענטערן זיך צו עפעס א יבשה; ");
INSERT INTO ydd_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","האבן זיי אראפגעלאזט דאס זינקבליי און געפונען צוואנציק קלאפטער (טיף); זענען אביסל ווייטער געפארן און ווידער געזונקען דאס בליי, און האבן געפונען פופצן קלאפטער (טיף). ");
INSERT INTO ydd_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","און מורא האבנדיק, מיר זאלן נישט פאלן אויף פעלדזיקע ערטער, האבן זיי ארויסגעווארפן פיר אנקערס פון דעם הינטערטייל פון דער שיף, און תפילה געטאן, אז עס זאל (שוין) ווערן טאג. ");
INSERT INTO ydd_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","נאר ווי די שיפסלייט האבן געזוכט צו אנטלויפן פון דער שיף, און האבן שוין געהאט אראפגעלאזט דאס (רעטונגס) שיפל אונטערן אויסרייד, אז זיי גייען אראפלאזן אנקערס פון דעם פאדערטייל, ");
INSERT INTO ydd_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","האט פוילוס געזאגט צום אפיציר און צו די זעלנער: אויב די דאזיקע וועלן נישט איבערבלייבן אויף דער שיף, קענט איר נישט געראטעוועט ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","האבן די זעלנער דעמאלט אפגעהאקט די שטריק פונם שיפל, און עס געלאזט אראפפאלן. ");
INSERT INTO ydd_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","נאר ביז עס וועט נישט ווערן טאג, האט פוילוס אלעמען געבעטן, צו נעמען עפעס עסן, זאגנדיק: היינט איז (שוין) דער פערצענטער טאג ווי איר ווארט אומגעגעסן, און האט גארנישט טועם געווען. ");
INSERT INTO ydd_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","דערפאר בעט איך אייך, צו נעמען שפייז, ווייל דאס דאזיקע האט צו טאן מיט אייער רעטונג; ווארום קיינעם פון אייך וועט קיין איין האר פונם קאפ נישט פארלוירן ווערן. ");
INSERT INTO ydd_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","און האבנדיק דאס געזאגט, האט ער גענומען ברויט, און געדאנקט ה׳ פאר אלעמען; און האט עס צעבראכן, און אנגעהויבן עסן. ");
INSERT INTO ydd_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","און אלע האבן זיך געשטארקט, און אויך גענומען שפייז. ");
INSERT INTO ydd_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","און מיר אלע אין דער שיף זענען געווען צוויי הונדערט און זעקס און זיבעציק נפשות. ");
INSERT INTO ydd_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","און נאך דעם ווי זיי האבן געגעסן צו דער זעט, האבן זיי לייכטער געמאכט די שיף, און ארויסגעווארפן דעם ווייץ אין ים אריין. ");
INSERT INTO ydd_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ווען אבער עס איז געווארן טאג, האבן זיי נישט דערקענט דאס לאנד; האבן אבער באמערקט א בוכטע מיט א ברעג, און באשלאסן, אויב מעגלעך ארויפצופירן די שיף אויפן ברעג. ");
INSERT INTO ydd_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","און האבן אפגעהאקט די אנקערס, איבערלאזנדיק זיי אין ים, און צוגלייך האבן זיי לויז געמאכט די בענדער פון די רודערס; און ארויפגעצויגן דעם זעגל קעגן ווינט, און זיך א לאז געטאן צום ברעג צו. ");
INSERT INTO ydd_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ארויפפאלנדיק אבער אויף א זאמד באנק, האבן זיי ארויפגעפירט די שיף אויפן גרונט; און דער פאדערטייל איז געבליבן פעסט, אומבאוועגלעך, דער הינטערטייל אבער האט זיך צעבראכן דורך דער געוואלדיקייט פון די כוואליעס. ");
INSERT INTO ydd_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","און די זעלנער האבן בדעה געהאט צו טייטן די געפאנגענע, כדי קיינער זאל נישט אוועקשווימען און אנטלויפן. ");
INSERT INTO ydd_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","נאר דער אפיציר, וועלנדיק אפראטעווען פוילוסן, האט זיי געשטערט אין דער עצה, און באפוילן, אז יענע, וואס קענען שווימען, זאלן די ערשטע זיך אריינווארפן (אין ים אריין) און קומען צום לאנד; ");
INSERT INTO ydd_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","און די איבריקע, ווער אויף ברעטער, ווער אויף עפעס (אנדערש) פון דער שיף. און אזוי איז עס געשען, אז אלע האבן זיך געראטעוועט אויף דער יבשה ארויף. ");
INSERT INTO ydd_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","און נאך דעם ווי מיר זענען געראטעוועט געווארן, האבן מיר זיך דעמאלט דערוואוסט, אז די אינדזל הייסט מעליטא. ");
INSERT INTO ydd_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","און די בארבארן האבן אונדז ארויסגעוויזן אן אויסערגעוויינלעכע מענטשלעכקייט; ווארום זיי האבן אנגעצונדן א פייער און אונדז אלעמען אויפגענומען צוליב דעם רעגן, וואס האט געהאלטן אין איין פאלן און צוליב דער קעלט. ");
INSERT INTO ydd_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","און פוילוס האט צונויפגעזאמלט א בינטל ריטער און עס ארויפגעלייגט אויפן פייער, און א שלאנג איז ארויסגעקומען, מחמת דער היץ, און האט זיך אנגעהאנגען אויף זיין האנט. ");
INSERT INTO ydd_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","און ווי די בארבארן האבן געזען די חיה הענגען אויף זיין האנט, האבן זיי געזאגט איינער צום אנדערן: דער דאזיקער מענטש איז זיכער א מערדער, וועלכער, הגם ער איז אנטרונען פונם ים, לאזט אים דאך די גערעכטיקייט נישט לעבן. ");
INSERT INTO ydd_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ער אבער האט אראפגעשאקלט די חיה אין פייער אריין, און עס האט אים גארנישט געשאדט. ");
INSERT INTO ydd_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","און זיי האבן דערווארט, אז ער וועט געשוואלן ווערן אדער פלוצלונג אנידערפאלן טויט; ווי אבער זיי האבן לאנג געווארט, און געזען, אז עס געשעט אים נישט קיין שום שלעכטס, האבן זיי געענדערט זייער מיינונג, און געזאגט, אז ער איז א ג-ט. ");
INSERT INTO ydd_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","און נאענט פון יענעם ארט איז געווען ערד (אייגנטימער), לאנד וואס האט געהערט צום ראש פון דער אינדזל, מיטן נאמען פובליוס; וועלכער האט אונדז אויפגענומען און דריי טעג פריינדלעך באקעסטיקט, ");
INSERT INTO ydd_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","און פובליוסנס פאטער איז (גראד) געלעגן קראנק אויף א פיבער און דיזענטעריע; צו וועמען פוילוס איז אריינגעגאנגען און מתפלל געווען, און ארויפגעלייגנדיק די הענט אויף אים, האט ער אים געהיילט. ");
INSERT INTO ydd_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","און ווי דאס דאזיקע איז געשען, זענען אויך די איבריקע חולאים אויף דער אינדזל געקומען, און זיך געלאזט היילן; ");
INSERT INTO ydd_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","און האבן אונדז צוגעטיילט גרויס כבוד; און ווען מיר זענען אוועקגעפארן, האבן זיי אונדז מיטגעגעבן אלדאס נויטיקע. ");
INSERT INTO ydd_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","דריי חדשים שפעטער זענען מיר אפגעפארן אין אן אלעקסאנדרינישער שיף, וועלכע האט איבערגעווינטערט אויף דער אינדזל; איר צייכן איז געווען די צווילינג ברידער. ");
INSERT INTO ydd_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","און מיר זענען געקומען קיין סיראקוס, און זענען דארט פארבלייבן דריי טעג. ");
INSERT INTO ydd_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","פון דארטן זענען מיר ארומגעפארן און זענען געקומען קיין רעגיום; און איין טאג דערנאך האט זיך אויפגעהויבן א דרום ווינט, און דעם אנדערן טאג זענען מיר געקומען קיין פוטעאלי, ");
INSERT INTO ydd_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","וואו מיר האבן געפונען ברידער, וועלכע האבן אונדז געבעטן צו בלייבן ביי זיי זיבן טעג, און אזוי זענען מיר געקומען קיין רוים. ");
INSERT INTO ydd_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","און פון דארטן זענען די ברידער, הערנדיק וועגן אונדז, אונדז אקייגנגעקומען ביז צום אפיוס פארום און טרעסטאבערנע; זעענדיק זיי, האט פוילוס אפגעגעבן א שבח צו ה׳ און זיך געשטארקט. ");
INSERT INTO ydd_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","און ווען מיר זענען אריינגעקומען קיין רוים, האט מען פוילוסן דערלויבט צו וואוינען אליין מיט דעם זעלנער, וועלכער האט אים באוואכט. ");
INSERT INTO ydd_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","און עס איז געשען, אין דריי טעג ארום האט ער צונויפגערופן די, וועלכע זענען געווען די חשובסטע צווישן די יידן; און ווען זיי זענען זיך צוזאמענגעקומען, האט ער צו זיי געזאגט: ברידער, הגם איך האב גארנישט געטאן קעגן אונדזער פאלק אדער די מנהגים פון אונדזערע אבות, בין איך דאך איבערגעגעבן געווארן ווי א געפאנגענער פון ירושלים צו די רוימער אין די הענט אריין, ");
INSERT INTO ydd_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","וועלכע, נאך דעם ווי זיי האבן מיך חוקר געווען, האבן געוואלט מיך אפלאזן, ווייל עס אין מיר נישט געווען קיין טויט שולד. ");
INSERT INTO ydd_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","נאר אזויווי די יידן האבן זיך אקייגנגעשטעלט, בין איך געווען געצוואונגען צו אפעלירן צום קיסר; נישט ווי איך וואלט געהאט עפעס וואס אנצוקלאגן מיין פאלק. ");
INSERT INTO ydd_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","און צוליב דער דאזיקער סיבה האב איך אייך גערופן, כדי אייך צו זען און צו אייך צו רעדן, ווארום וועגן דער האפענונג פון ישראל בין איך געבונדן מיט דער דאזיקער קייט. ");
INSERT INTO ydd_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","און זיי האבן צו אים געזאגט: נישט מיר האבן דערהאלטן בריוו פונם (לאנד) יהודה וועגן דיר, נישט איז עמיצער פון די ברידער געקומען, וועלכער האט דערציילט אדער געזאגט עפעס שלעכטס אויף דיר. ");
INSERT INTO ydd_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","מיר ווילן אבער הערן פון דיר, וואס דו דענקסט; ווארום וואס שייך דער דאזיקער כיתה, איז אונדז באקאנט, אז אומעטום רעדט מען קעגן איר. ");
INSERT INTO ydd_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","און נאך דעם ווי זיי האבן אים באשטימט א טאג, זענען זיי געקומען צו אים אין גאסטהויז אריין אין גרעסערער צאל; וועמען ער האט דערקלערט, עדות זאגנדיק וועגן דעם קעניגרייך פון ה׳, און אויפווייזנדיק וועגן יהושען/ישוען פון תורת משה און פון די נביאים, פון אינדערסרי ביז אין אוונט. ");
INSERT INTO ydd_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","און א טייל האבן זיך געלאזט איבערצייגן פון דעם געזאגטן, אנדערע אבער האבן נישט געגלויבט. ");
INSERT INTO ydd_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","און אזויווי זיי זענען נישט געווען איינשטימיק צווישן זיך, זענען זיי אוועקגעגאנגען, נאך דעם ווי פוילוס האט נאך געזאגט איין ווארט: גוט האט דער רוח הקודש גערעדט דורך דעם נביא ישעיה צו אייערע עלטערן, אזוי צו זאגן: ");
INSERT INTO ydd_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","גיי צו דעם דאזיקן פאלק און זאג: מיטן געהער וועט איר הערן און נישט משיג זיין; און קוקנדיק וועט איר קוקן און נישט זען; ");
INSERT INTO ydd_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ווייל פעט געווארן איז דאס הארץ פון דעם דאזיקן פאלק, און מיט די אויערן הערן זיי שווער, און די אויגן זייערע האבן זיי געשלאסן, טאמער וואלטן זיי געזען מיט די אויגן, און מיט די אויערן געהערט, און וואלטן פארשטאנען מיטן הארצן און תשובה געטאן (צו דרך ה׳), און איך וואלט זיי געהיילט. ");
INSERT INTO ydd_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","דעריבער זייט וויסן, אז די דאזיקע ישועה פון ה׳ ווערט געשיקט צו די אומות העולם; און זיי וועלן (זי) הערן. ");
INSERT INTO ydd_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","(און ווען ער האט דאס געזאגט, זענען די יידן אוועקגעגאנגען, האלטנדיק א גרויסן וויכוח צווישן זיך.) ");
INSERT INTO ydd_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","און ער איז פארבלייבן גאנצע צוויי יאר אין זיין אייגענער געדונגענער דירה, און אויפגענומען אלע, וואס זענען אריינגעקומען צו אים, ");
INSERT INTO ydd_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","האט אויסגערופן דאס קעניגרייך פון ה׳ און געלערנט פון דעם האר יהושע/ישוע המשיח גאנץ אפן, פון קיינעם נישט געשטערט.");
INSERT INTO ydd_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","פוילוס, א קנעכט פון יהושע/ישוע המשיחן, בארופן צו זיין א שליח, אפגעשיידט פאר דער בשורה טובה פון ה׳, ");
INSERT INTO ydd_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","וועלכע ער האט פון פריער צוגעזאגט דורך זיינע נביאים אין די כתבי הקודש, ");
INSERT INTO ydd_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","וועגן זיין זון, וואס איז געבוירן געווארן פון דער זרע דוד לויטן פלייש, ");
INSERT INTO ydd_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","אנטשיידן באוויזן אלס דער זון פון דער אויבערשטער מיט מאכט, לויט דעם גייסט פון קדושה דורך דעם אויפשטיין פון די טויטע—יהושע/ישוע המשיח אונדזער האר, ");
INSERT INTO ydd_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","דורך וועמען מיר האבן מקבל געווען חסד און די שליחות צו דער געהארכזאמקייט פון דער אמונה צווישן אלע פעלקער דורך זיין נאמען, ");
INSERT INTO ydd_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","צווישן וועלכע אויך איר זענט בארופן פון יהושע/ישוע המשיחן; ");
INSERT INTO ydd_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","צו אלע, וואס זענען אין רוים, געליבטע פון ה׳, בארופן (צו זיין) הייליקע: חסד צו אייך און שלום פון ה׳ אונדזער פאטער און פון דעם האר יהושע/ישוע המשיח. ");
INSERT INTO ydd_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","קודם כל גיב איך אפ א שבח צו מיין ג‑ט דורך יהושע/ישוע המשיחן פאר אייך אלע, ווייל איבער אייער (דרך ה׳) אמונה ווערט גערעדט אין דער גאנצער וועלט. ");
INSERT INTO ydd_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ווארום ה׳, וועמען איך דין אין מיין גייסט אין דער בשורה טובה פון זיין זון, איז מיין עדות ווי איך דערמאן אייך אָן אויפהער ");
INSERT INTO ydd_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","אין מיינע תפילות, בעטנדיק אלעמאל, אז עס זאל מיר שוין געלינגען, אם ירצה ה׳, צו אייך צו קומען. ");
INSERT INTO ydd_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ווארום מיין פארלאנג איז אייך צו זען, כדי אייך איבערצוגעבן עפעס א רוחניותדיקע מתנה צו אייער שטארקונג; ");
INSERT INTO ydd_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","דאס הייסט, איך זאל מיטגעטרייסט ווערן אין אייך דורך דער געמיינזאמער (דרך ה׳) אמונה, אייערער און מיינער. ");
INSERT INTO ydd_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","און איך וויל נישט, ברידער, איר זאלט זיין אומוויסנד, אז אפטמאל האב איך שוין געוואלט קומען צו אייך (און בין ביז איצט געשטערט געווארן), כדי איך זאל האבן פירות אויך צווישן אייך, ווי צווישן די איבריקע פעלקער. ");
INSERT INTO ydd_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","איך בין א בעל חוב צו גריכן און צו בארבארן, צו חכמים און צו נאראנים. ");
INSERT INTO ydd_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","אזוי זשע בין איך גרייט לויט מיינע מעגלעכקייטן אנצוזאגן די בשורה טובה אויך צו אייך אין רוים. ");
INSERT INTO ydd_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ווארום איך שעם זיך נישט מיט דער (דרך ה׳) בשורה טובה פון דעם משיח, ווייל זי איז ה׳ס גבורה צו ישועה פאר יעדן איינעם מאמין, דעם ייד קודם כל און אויך דעם גריך. ");
INSERT INTO ydd_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ווארום אין איר (דרך ה׳) איז גערעכטיקייט פון ה׳ אנטפלעקט געווארן פון גלויבן צו גלויבן, ווי עס שטייט געשריבן: דער צדיק וועט דורך זיין גלויבן לעבן. (חבקוק ב, ד.) ");
INSERT INTO ydd_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ווארום ה׳ס צארן אנטפלעקט זיך פון הימל אויף יעדער רשעות און עולה פון מענטשן, וואס האלטן דעם אמת אין אומגערעכטיקייט; ");
INSERT INTO ydd_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ווייל דאס וויסן פון ה׳ איז באקאנט געמאכט צו זיי, ווארום ה׳ האט עס זיי מגלה געווען. ");
INSERT INTO ydd_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ווארום די אומזיכטבארע זאכן זיינע, זינט דער וועלטבאשאפונג, ווערן זיכטבאר דורך באשאפענע זאכן, (נעמלעך) זיין אייביקע קראפט און ג‑טהייט, כדי זיי זאלן זיין אָן א תירוץ: ");
INSERT INTO ydd_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","צוליב דעם, וואס קענענדיק ה׳, האבן זיי אים נישט פארהערלעכט אלס ה׳ אדער (אים) געדאנקט, נאר האבן זיך צו נאר געמאכט מיט זייער דענקען און זייער זינלאז הארץ איז פארפינסטערט געווארן. ");
INSERT INTO ydd_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","מיינענדיק, אז זיי זענען קלוגע, האבן זיי זיך באנארישט, ");
INSERT INTO ydd_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","און פארביטן די הערלעכקייט פון דעם אומשטארבלעכן ג‑ט מיט דער ענלעכקייט פון דעם געשטאלט פון א שטערבלעכן מענטשן און פון פייגל און פון פיר פיסיקע און קריכנדיקע ברואים. ");
INSERT INTO ydd_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","דערפאר האט זיי ה׳ איבערגעגעבן אין די תאוות פון זייערע הערצער, צו שמוציקייט, צו שענדן זייערע קערפערס צווישן זיך אליין; ");
INSERT INTO ydd_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","וועלכע האבן פארביטן דעם (דרך ה׳) אמת פון ג‑ט מיט א שקר און פארערט און געדינט דאס באשאפענע אנשטאט דעם באשעפער, הקדוש ברוך הוא לעולמים. אמן. ");
INSERT INTO ydd_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","צוליב דעם האט ה׳ זיי איבערגעגעבן צו שענדלעכע תאוות; ווארום זייערע ווייבער האבן פארביטן דעם נאטירלעכן געברויך מיט אן אומנאטירלעכן; ");
INSERT INTO ydd_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","און אזוי אויך די מענער, פארלאזנדיק דעם נאטירלעכן געברויך פון דער פרוי, האבן זיך אין זייערע פארלאנגען דערהיצט איינער מיט דעם אנדערן, מענער מיט מענער טוענדיק געמיינהייטן, און האבן דערהאלטן אין זיך אליין דעם געהעריקן שכר פון זייער פארפירטקייט. ");
INSERT INTO ydd_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","און אזויווי זיי האבן נישט געוואלט האבן ה׳ אין זייער וויסן, האט ה׳ זיי איבערגעגעבן צו א פארדארבענעם פארשטאנד, צו טאן דאס, וואס מען טוט נישט; ");
INSERT INTO ydd_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","זיי זענען אנגעפילט געווארן מיט יעדער רישעות, שלעכטסקייט, זנות, גלוסטשאפיק תאוות גייציקייט, בייזוויליקייט, פול מיט קינאה, מערדעריי, קריג, אפנארעריי, כיטרעקייט, רכילות, ");
INSERT INTO ydd_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","לשון הרע, פיינד פון ה׳, עזות פנימער, פארריסן, בארימער, אויסגעפינעריש פון שלעכטס, אומגעהארכזאמע צו עלטערן, ");
INSERT INTO ydd_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","אומפארשטאנדיקע, בונד-ברעכער, אָן נאטירלעכע געפילן, אומרחמנותדיקע; ");
INSERT INTO ydd_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","וועלכע, הגם וויסנדיק פון ה׳ס משפט, אז די, וואס טאן די דאזיקע זאכן, זענען חייב מיתה, האבן זיי נישט נאר די דאזיקע זאכן געטאן, נאר זענען נאך צופרידן מיט די, וואס טאן זיי. ");
INSERT INTO ydd_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","דערפאר ביסטו, אָ מענטש, ווער דו זאלסט נישט זיין, וואס משפטסט, אָן א תירוץ; ווארום מיט וואס דו משפטסט דעם אנדערן, פארמשפטסטו דיך אליין, ווייל דו, וועלכער משפטסט, טוסט די דאזיקע זאכן; ");
INSERT INTO ydd_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","און מיר ווייסן אז ה׳ס משפט איז לויט דעם אמת אויף די, וואס טאן די דאזיקע זאכן. ");
INSERT INTO ydd_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","צי מיינסטו דען, אָ מענטש, וואס משפטסט די, וואס טאן די דאזיקע זאכן און טוסט זיי אליין, אז דו וועסט אויסמיידן ה׳ס משפט? ");
INSERT INTO ydd_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","אדער ביסטו מבזה די עשירות פון זיין גוטסקייט, געדולד און צוריקגעהאלטנקייט, נישט וויסנדיק, אז די גוטסקייט פון ה׳ זאל דיך פירן צום תשובה טאן? ");
INSERT INTO ydd_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","דו אבער, לויט דיין הארטקייט און דיין נישט תשובהדיקן הארץ, זאמלסט דיר איין צארן אינם טאג פון צארן און אנטפלעקונג פון ה׳ס גערעכטן משפט, ");
INSERT INTO ydd_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","וואס וועט יעדן פארגעלטן לויט זיינע מעשים: (משלי כד, ב.) ");
INSERT INTO ydd_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","צו די, וואס זוכן מיט סבלנות דורך מעשים טובים—הערלעכקייט, כבוד און אומשטערבלעכקייט, אייביק לעבן; ");
INSERT INTO ydd_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","אבער צו די ווידערשפעניקע און וואס זענען אומגעהארכזאם צום אמת נאר זענען געהארכזאם צו רשעות—צארן און גרימצארן; ");
INSERT INTO ydd_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ליידן און אנגסט אויף יעדן מענטשלעכן נפש, וואס טוט שלעכטס, קודם כל דעם ייד און אויך דעם גריך. ");
INSERT INTO ydd_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","אבער הערלעכקייט און כבוד און שלום צו יעדן, וואס טוט גוטס, קודם כל דעם ייד און אויך דעם גריך; ");
INSERT INTO ydd_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ווארום ה׳ איז נישט קיין נושא פנים. (דברים י, יז.) ");
INSERT INTO ydd_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ווארום אלע, וואס האבן געזינדיקט אָן א תורה, וועלן אויך אָן א תורה פארלוירן ווערן; און אלע, וואס האבן געזינדיקט אונטער דער תורה, וועלן געמשפט ווערן דורך דער תורה; ");
INSERT INTO ydd_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ווייל נישט די, וואס הערן די תורה, זענען גערעכט ביי ה׳, נאר די, וואס טאן (וואס) די תורה (זאגט), וועלן גערעכטפערטיקט ווערן; ");
INSERT INTO ydd_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ווארום ווען די אומות העולם, נישט האבנדיק די תורה, טאן פון זייער טבע לויט (ווי) די תורה (שרייבט פאר), זיי, הגם נישט האבנדיק קיין תורה, זענען א תורה פאר זיך אליין. ");
INSERT INTO ydd_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","זיי ווייזן, אז דאס טאן (וואס שטייט אין) דער תורה איז געשריבן אויף זייערע הערצער, ווען זייער געוויסן זאגט עדות און זייערע געדאנקען אדער באשולדיקן זיך אדער רעכטפערטיקן זיך קעגנזייטיק; ");
INSERT INTO ydd_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","אינם טאג ווען ה׳ וועט משפטן די פארבארגענע זאכן פון מענטשן, לויט מיין בשורה טובה דורך דעם משיח יהושע/ישוע. ");
INSERT INTO ydd_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","אבער אויב דו רופסט דיך ייד און שטיצטסט דיך אויף דער תורה און בארימסט דיך מיט ה׳, ");
INSERT INTO ydd_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","און קענסט זיין רצון און, ווייסט אונטערצושיידן צווישן גוטס און שלעכטס, זייענדיק געלערנט אין דער תורה, ");
INSERT INTO ydd_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","און ביסט איבערצייגט, אז דו אליין ביסט א פירער פון בלינדע—א ליכט פאר די, וואס זענען אין דער פינסטער, ");
INSERT INTO ydd_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","א דערציער פאר די אומזיניקע, א דרדקי-מלמד, האבנדיק די פארם פון וויסן און פון אמת אין דער תורה; ");
INSERT INTO ydd_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","דעריבער דו, וואס לערנסט אן אנדערן, פארוואס לערנסטו נישט דיך אליין? דו דרשנסט, מען זאל נישט גנבענען, און אליין גנבעסטו! ");
INSERT INTO ydd_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","דו, וואס זאגסט, מען זאל נישט מזנה זיין, ביסטו מזנה! דו פאראומווירדיקסט די געצן, בארויבסטו דעם געצן טעמפל? ");
INSERT INTO ydd_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","דו, וואס בארימסט דיך מיט דער תורה, שענדסט דו ה׳ דורך עובר זיין די תורה! ");
INSERT INTO ydd_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ווארום ה׳ס נאמען ווערט דורך אייך געלעסטערט צווישן די פעלקער, אזוי ווי עס שטייט געשריבן. (ישעיהו נב, ה.) ");
INSERT INTO ydd_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ווארום דאס געמלט זיין האט טאקע א ווערט, אויב דו טוסט וואס די תורה זאגט; אבער אויב דו ביסט עובר די תורה איז דיין מילה געווארן אן ערלה. ");
INSERT INTO ydd_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","דעריבער, ווען דער נישט געמלטער וועט אפהיטן די משפטים פון דער תורה, צי וועט אים דען נישט זיין ערלה פאררעכנט ווערן צו מילה? ");
INSERT INTO ydd_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","און וועט דער מן-הטבע נישט געמלטער, וואס איז מקיים די תורה, דיך נישט משפטן, וואס האסט דאס אות און די מילה און ביסט עובר די תורה? ");
INSERT INTO ydd_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ווייל נישט דער איז א ייד, וואס איז (א ייד) אויסערלעך, מילה איז אויך נישט דאס, וואס איז בלויז אויסערלעך אינם גוף; ");
INSERT INTO ydd_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","נאר א ייד איז דער, וואס איז אינערלעך אזעלכער, און מילה איז אינם הארצן לויטן גייסט, נישט לויט דעם אות, וועמעס לויב איז נישט פון מענטשן, נאר פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","דעריבער, וואס פאר א מעלה האט דער ייד, אדער וואס איז דער נוצן פון דער מילה? ");
INSERT INTO ydd_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","א סך אויף יעדן פאל—קודם כל טאקע ווייל צו זיי (די יידן) איז אנפארטרויט געווארן דאס וואס ה׳ האט גערעדט. ");
INSERT INTO ydd_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","און אויב א טייל האבן נישט געגלויבט, וואס מאכט עס דען אויס? צי מאכט דען זייער אומגלויבן צונישט די געטריישאפט פון ה׳? ");
INSERT INTO ydd_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","חס ושלום! זאל זיך ה׳ ארויסווייזן אלס ווארהאפטיק און יעדער מענטש א ליגנער, ווי עס שטייט געשריבן: כדי דו זאלסט זיין גערעכט אין דיינע רייד און זיגן ווען דו ווערסט געמשפט. (תהלים נא, ה.) ");
INSERT INTO ydd_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","אויב אבער אונדזער רשעות ווייזט אויף די צדקות פון ה׳, וואס וועלן מיר זאגן? אז ה׳ איז אומגערעכט, ברענגענדיק צארן? איך רעד ווי א מענטש. ");
INSERT INTO ydd_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","חס ושלום! ווייל אויב אזוי, ווי וואלט ה׳ געקענט משפטן די וועלט? ");
INSERT INTO ydd_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","אויב אבער דורך מיין שקר האט זיך דער אמת פון ה׳ געשטארקט צו זיין כבוד, פארוואס זאל איך נאך געמשפט ווערן ווי א חוטא? ");
INSERT INTO ydd_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","און פארוואס זאלן מיר נישט טאקע—ווי די, וואס באליידיקן אונדז באהויפטן, אז מיר זאגן—טאן דאס שלעכטע, כדי דאס גוטע זאל קומען? זייער משפט איז גערעכט. ");
INSERT INTO ydd_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","דעריבער וואס? צי האבן מיר דען עפעס א מעלה? בשום אופן נישט! ווארום מיר האבן שוין פריער באוויזן, אז סאי דער ייד און סאי דער גריך זענען אלע אונטער דער זינד; ");
INSERT INTO ydd_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","אזוי ווי עס שטייט געשריבן: עס איז נישט פאראן קיין צדיק, קיין איינער נישט; ");
INSERT INTO ydd_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","עס איז נישט פאראן קיין פארשטענדיקער, עס איז נישט פאראן קיין איינער, וואס זוכט ה׳; ");
INSERT INTO ydd_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","אלע האבן אפגענייגט, זיי זענען צוזאמען נוצלאז געווארן; עס איז נישט פאראן קיינער, וואס טוט גוטס, ניין, נישט איינער. (תהלים יד, ב-ד.) ");
INSERT INTO ydd_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","זייער קעל איז אן אפן קבר, מיט זייערע צונגען האבן זיי פאררעטעריש געהאנדלט, שלאנגענגיפט איז אונטער זייערע ליפן (תהלים ה, ח; קמ, ד.); ");
INSERT INTO ydd_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","וועמעס מויל איז פול מיט פלוך און ביטערקייט (תהלים י, ז.); ");
INSERT INTO ydd_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","זייערע פיס איילן צו פארגיסן בלוט; ");
INSERT INTO ydd_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","צעשטערונג און ליידן זענען אויף זייערע וועגן; ");
INSERT INTO ydd_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","און דעם וועג פון שלום האבן זיי נישט דערקענט (ישעיהו נט, ז-ח.); ");
INSERT INTO ydd_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","די מורא פאר ה׳ איז נישט פאר זייערע אויגן. (תהלים לו, ב.) ");
INSERT INTO ydd_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","מיר אבער ווייסן, אז וואס די תורה זאגט, איז עס גערעדט געווארן צו די, וועלכע זענען אונטער דער תורה, כדי איטלעכס מויל זאל פארשטאפט ווערן און די גאנצע וועלט זאל זיין שולדיק פאר ה׳; ");
INSERT INTO ydd_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","צוליב דעם, וואס דורך די מעשים פון (מחמיר חומרא) געזעץ וועט קיין בשר (ודם) נישט גערעכטפערטיקט ווערן פאר אים; ווארום דורך דער תורה קומט די פולע דערקענטעניש פון זינד. ");
INSERT INTO ydd_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","איצט אבער האט זיך, אויסער דער תורה, באוויזן די גערעכטיקייט פון ה׳, וועגן וועלכער סאי די תורה סאי די נביאים האבן עדות געזאגט: ");
INSERT INTO ydd_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","די גערעכטיקייט פון ה׳, דורך אמונה אין יהושען/ישוען דעם משיח, פאר אלע, וואס גלויבן, ווייל עס איז נישטא קיין חילוק; ");
INSERT INTO ydd_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ווארום אלע האבן געזינדיקט און געפעלט אין דער הערלעכקייט פון ה׳; ");
INSERT INTO ydd_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","און ווערן גערעכטפערטיקט פריי דורך זיין חסד דורך דער אויסלייזונג פונם משיח יהושע/ישוע; ");
INSERT INTO ydd_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","וועמען ה׳ האט ארויסגעשטעלט אלס א כפורת אין זיין בלוט צו זיין באקומען דורך אמונה. דאס איז געווען כדי צו ווייזן ה׳ס גערעכטיקייט ווייל אין זיין צוריקגעהאלטנקייט ער האט פסח פריער באגאנגענע זינד ");
INSERT INTO ydd_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","כדי צו ווייזן זיין גערעכטיקייט אין דער איצטיקער צייט און אז ער אליין איז גערעכט און דער גערעכטפערטיקער פון דעם, וואס גלויבט אין יהושען/ישוען. ");
INSERT INTO ydd_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","וואו זשע איז די בארימעריי? זי איז אויסגעשלאסן. דורך וואס פאר א תורה? צי פון מעשים? ניין, נאר דורך דער תורה פון אמונה. ");
INSERT INTO ydd_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ווארום מיר דרינגען ארויס, אז א מענטש ווערט גערעכטפערטיקט דורך אמונה אָן די מעשים פון דער תורה. ");
INSERT INTO ydd_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","צי איז דען ג‑ט בלויז דער ג‑ט פון די יידן? צי איז ער דען נישט אויך (דער ג‑ט) פון די אומות העולם? געוויס, אויך פון די אומות העולם; ");
INSERT INTO ydd_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ווייל ה׳ איז איינער, וואס וועט גערעכטפערטיקן דעם געמלטן פון אמונה און דעם נישט געמלטן דורך אמונה. ");
INSERT INTO ydd_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","צי מאכן מיר דען די תורה בטל דורך אמונה? חס ושלום! נאר מיר באשטעטיקן די תורה. ");
INSERT INTO ydd_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","וואס זשע זאלן מיר זאגן וועגן אברהם אבינו? וואס האט ער דען דערגרייכט לויטן פלייש? ");
INSERT INTO ydd_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ווארום אויב אברהם איז גערעכטפערטיקט געווארן דורך מעשים (טובים), האט ער עפעס, מיט וואס זיך צו בארימען, אבער נישט פאר ה׳. ");
INSERT INTO ydd_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ווייל וואס זאגן די כתבי (הקודש)? אברהם האט געגלויבט ה׳ און דאס איז אים פאררעכנט געווארן צו גערעכטיקייט. (בראשית טו, ו.) ");
INSERT INTO ydd_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","דעם ארבעטער אבער ווערט דער לוין נישט פאררעכנט אלס חסד נאר אלס א חוב. ");
INSERT INTO ydd_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","אבער דעם, וואס ארבעט נישט, נאר גלויבט אין אים, וואס מאכט גערעכט דעם רשע, ווערט זיין אמונה אים פאררעכנט צו גערעכטיקייט. ");
INSERT INTO ydd_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","דוד רעדט אויך אזוי איבער דער גליקלעכקייט פון דעם מענטשן, וועמען ה׳ פאררעכנט גערעכטיקייט אָן (פארלאזן זיך אויף) מעשים (טובים): ");
INSERT INTO ydd_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","וואויל איז די, וועמעס אומגערעכטיקייטן זענען פארגעבן געווארן און וועמעס זינד זענען פארדעקט געווארן; ");
INSERT INTO ydd_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","וואויל איז דעם מענטש, וועמען דער האר ג‑ט רעכנט נישט צו קיין זינד. (תהלים לב, ב, ג.) ");
INSERT INTO ydd_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","צי איז דען די דאזיקע גליקלעכקייט פאר דעם געמלטן אליין אדער אויך פאר דעם נישט געמלטן? ווארום מיר זאגן דאך, אז אברהמען איז דער גלויבן פאררעכנט געווארן אלס גערעכטיקייט. ");
INSERT INTO ydd_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","וויאזוי זשע איז עס אים פאררעכנט געווארן? זייענדיק געמלט, אדער איידער ער האט זיך מל געווען? ניין, נישט ווען ער איז שוין געווען געמלט, נאר ווען ער איז נאך געווען אין ערלה; ");
INSERT INTO ydd_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","און דעם צייכן פון מילה האט ער באקומען ווי א חתימה פון דער גערעכטיקייט פון אמונה, וואס ער האט געהאט איידער נאך ער האט זיך מל געווען; כדי ער זאל זיין דער פאטער פון אלע נישט געמלטע מאמינים, אז עס זאל אויך זיי פאררעכנט ווערן צו גערעכטיקייט; ");
INSERT INTO ydd_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","און דער פאטער פון די געמלטע, צו זיי, וואס נישט נאר זענען זיי געמלט, נאר גייען אין די פוסטריט פון דער אמונה, וועלכע אברהם אבינו האט געהאט נאך איידער ער האט זיך מל געווען. ");
INSERT INTO ydd_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ווארום די הבטחה, אז אברהם אדער זיין זאמען וועט ירשענען די וועלט, איז נישט געווען דורך דער געזעץ, נאר דורך דער צדקות פון אמונה. ");
INSERT INTO ydd_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ווארום אויב נאר די געזעץ לייט זענען יורשים, דאן האט די אמונה פארלוירן די ווערט און די הבטחה איז בטל; ");
INSERT INTO ydd_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ווייל די געזעץ ווירקט צארן (שטראף); און וואו עס איז נישטא קיין געזעץ, דארט איז אויך נישט פאראן קיין עבירה. ");
INSERT INTO ydd_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","צוליב דעם דורך אמונה, כדי עס זאל זיין לויט חסד, אז די הבטחה זאל זיין פארזיכערט צו דעם גאנצן זאמען; נישט נאר צו די פון דער געזעץ אליין, נאר אויך צו די פון דעם גלויבן פון אברהם, וועלכער איז אונדזער אלעמענס פאטער— ");
INSERT INTO ydd_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ווי עס שטייט געשריבן: איך האב דיך באשטימט פאר א פאטער פון פיל פעלקער (בראשית יז, ה.) —פאר ה׳, וועמען ער האט געגלויבט, אז ער מאכט לעבעדיק די טויטע און רופט דאס נישט עקזיסטירנדיקע פונקט ווי עס וואלט שוין עקזיסטירט. ");
INSERT INTO ydd_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","וואס, ווען עס איז נישט געווען קיין גרונט פאר האפענונג, האט דאך געגלויבט אין דער האפענונג, אז ער וועט ווערן א פאטער פון פיל פעלקער, ווי עס איז אים צוגעזאגט געווארן: אזוי וועט זיין דיין זאמען. (בראשית טו, ה.) ");
INSERT INTO ydd_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","און איז נישט שוואך געווארן אין גלויבן, ווען ער האט נאכגעדענקט איבער זיין אייגענעם שוין כמעט טויטן גוף—ער איז דעמאלט אלט געווען באלד הונדערט יאר—און שרהס אפגעשטארבענער מוטערטראכט; ");
INSERT INTO ydd_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","און האט נישט געצווייפלט דורך אומגלויבן אין ה׳ס הבטחה, נאר זיך געשטארקט אין אמונה, אפגעבנדיק כבוד צו ה׳, ");
INSERT INTO ydd_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","און זייענדיק פולשטענדיק איבערצייגט, אז ער איז אימשטאנד צו טאן וואס ער האט צוגעזאגט. ");
INSERT INTO ydd_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","דערפאר איז עס אים פאררעכנט געווארן צו גערעכטיקייט. ");
INSERT INTO ydd_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","נישט נאר פאר אים אליין איז עס געשריבן געווארן; עס איז אים פאררעכנט געווארן, ");
INSERT INTO ydd_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","נאר אויך פאר אונדזערטוועגן, וועמען עס וועט פאררעכנט ווערן, וואס גלויבן אין אים, וועלכער האט אויפגעוועקט פון די טויטע יהושען/ישוען אונדזער האר, ");
INSERT INTO ydd_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","וועלכער איז איבערגעגעבן געווארן (צום טויט) צוליב אונדזערע עבירות און אויפגעוועקט געווארן פאר אונדזער גערעכטפערטיקונג. ");
INSERT INTO ydd_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","זייענדיק דעריבער גערעכטפערטיקט דורך אמונה, האבן מיר שלום מיט ה׳ דורך אונדזער האר יהושע/ישוע המשיח, ");
INSERT INTO ydd_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","דורך וועמען מיר האבן אויך באקומען דעם צוגאנג דורך אמונה צום דאזיקן חסד, אין וועלכן מיר שטייען; און לאמיר זיך משמח זיין אין דער האפענונג פון דעם כבוד פון ה׳. ");
INSERT INTO ydd_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","און נישט נאר דאס, נאר לאמיר זיך אויך פרייען אין די צרות, וויסנדיק אז צרות פירן צו סבלנות; ");
INSERT INTO ydd_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","און סבלנות צו דערפארונג, און די דערפארונג צו האפענונג; ");
INSERT INTO ydd_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","די האפענונג אבער אנטוישט נישט, ווייל ה׳ס ליבע איז אויסגעגאסן אין אונדזערע הערצער דורך דעם רוח הקודש, וועלכער איז אונדז געגעבן געווארן. ");
INSERT INTO ydd_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ווייל ווען מיר זענען נאך געווען שוואך, איז דער משיח, אין דער געהעריקער צייט, געשטארבן פאר די רשעים. ");
INSERT INTO ydd_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ווארום זעלטן וועט זיך עמיצער אונטערנעמען צו שטארבן פאר א צדיק; דאך פאר א גוטן מענטשן וועט אפשר ווער האבן דעם מוט צו שטארבן. ");
INSERT INTO ydd_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","אבער ה׳ באווייזט זיין ליבע צו אונדז, אז משיח איז פאר אונדז געשטארבן, ווען מיר זענען נאך געווען חוטאים. ");
INSERT INTO ydd_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","אויף וויפל זשע מער, זייענדיק איצט גערעכטפערטיקט דורך זיין בלוט (כפרה), וועלן מיר געראטעוועט ווערן דורך אים פונם צארן. ");
INSERT INTO ydd_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ווארום אויב מיר, זייענדיק שונאים, זענען שלום-מאכן געווארן מיט ה׳ דורכן טויט פון זיין זון, אויף וויפל מער, זייענדיק שוין שלום-מאכן, וועלן מיר געראטעוועט ווערן דורך זיין לעבן; ");
INSERT INTO ydd_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","נישט נאר דאס, נאר מיר זענען זיך משמח אין ה׳ דורך אונדזער האר יהושע/ישוע המשיח, דורך וועמען מיר האבן איצט באקומען די שלום-מאכן. ");
INSERT INTO ydd_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","דערפאר, אזויווי דורך איין מענטשן איז די זינד געקומען אין דער וועלט אריין, און דורך דער (איינגעבוירן חטא קדמון) זינד דער טויט, און אזוי איז דער טויט דורכגעדרונגען צו אלע מענטשן, ווייל אלע האבן געזינדיקט; ");
INSERT INTO ydd_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ווארום ביז דער תורה איז די זינד שוין געווען אין דער וועלט, אבער עבירה ווערט נישט פאררעכנט, ווען עס איז נישטא קיין געזעץ. ");
INSERT INTO ydd_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","דאך האט דער טויט געקעניגט פון אדמען ביז משהן אויך אויף די, וואס האבן נישט געזינדיקט ענלעך צו דער עבירה פון אדם, וועלכער איז א פארבילד פון אים, וואס האט געזאלט קומען. ");
INSERT INTO ydd_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","אבער נישט ווי די עבירה, אזוי איז די מתנה. ווארום, אויב דורך דער עבירה פון דעם איינעם זענען די פילע געשטארבן, וויפל מער זענען ה׳ס חסד און די מתנה דורך דעם איינעם מענטשן, יהושע/ישוע המשיח, איבערגעפלאסן צו די פילע! ");
INSERT INTO ydd_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","און נישט אזוי ווי דורך דעם איינעם, וואס האט געזינדיקט, איז די מתנה; ווארום דאס משפט איז געקומען דורך איינעם צו פאראורטיילונג, אבער די מתנה איז צו גערעכטפערטיקונג פון א סך זינד. ");
INSERT INTO ydd_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ווייל אויב דורך דער עבירה פון דעם איינעם, האט דער טויט געהערשט דורך דעם דאזיקן איינעם, וויפל מער וועלן די, וואס זענען מקבל די שפע פון חסד און דער מתנה פון גערעכטיקייט, הערשן אין לעבן דורך דעם איינעם—יהושע/ישוע המשיח. ");
INSERT INTO ydd_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","דעריבער, אזויווי דורך איין עבירה איז געקומען די פאראורטיילונג אויף אלע מענטשן, אזוי אויך דורך איין טאט פון צדקות, איז געקומען די גערעכטפערטיקונג פון לעבן צו אלע מענטשן. ");
INSERT INTO ydd_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ווארום אזויווי דורך דער ווידערשפעניקייט פון דעם איינעם מענטשן זענען א סך געמאכט געווארן פאר חוטאים, אזוי אויך דורך דער געהארכזאמקייט פון דעם איינעם (יהושע/ישוע) וועלן א סך געמאכט ווערן פאר צדיקים. ");
INSERT INTO ydd_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","די תורה אבער איז אריינגעקומען, כדי די עבירות זאלן זיך פארמערן; און וואו די זינד האט זיך פארמערט, איז דער חסד נאך מער איבערגעפלאסן, ");
INSERT INTO ydd_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","כדי, ווי די זינד האט געהערשט אינם טויט, אזוי זאל דער חסד הערשן דורך צדקות צום אייביקן לעבן דורך יהושען/ישוען דעם משיח אונדזער האר. ");
INSERT INTO ydd_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","וואס זשע זאלן מיר זאגן? זאלן מיר בלייבן אין דער זינד, כדי דער חסד זאל זיך פארמערן? ");
INSERT INTO ydd_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","חס ושלום! וויאזוי וועלן מיר, וואס זענען געשטארבן צו דער זינד, נאך לעבן אין איר? ");
INSERT INTO ydd_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","אדער ווייסט איר נישט, אז מיר אלע, וואס זענען געטובלט געווארן אין דער מקווה צום משיח יהושע/ישוע, זענען געטובלט געווארן אין דער מקווה צו זיין טויט? ");
INSERT INTO ydd_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","מיר זענען דעריבער נקבר געווארן מיט אים דורך דער מקווה צום טויט, כדי, ווי משיח איז אויפגעוועקט געווארן פון די טויטע דורך דעם כבוד פונם פאטער, אזוי זאלן אויך מיר גיין באנייטע אין לעבן. ");
INSERT INTO ydd_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ווארום אויב מיר זענען צוזאמען געפלאנצט געווארן אין דער ענלעכקייט פון זיין טויט, וועלן מיר אויך זיין אין דער ענלעכקייט פון זיין תחית המתים, ");
INSERT INTO ydd_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","וויסנדיק דאס דאזיקע, אז אונדזער אלטער מענטש איז צוזאמען מיט אים אויפגעהאנגען אויף דער בוים געווארן, כדי דער גוף פון זינד זאל פארניכטעט ווערן און מיר זאלן מער נישט זיין פארשקלאפט צו דער זינד; ");
INSERT INTO ydd_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ווארום דער ניפטר איז גערעכטפערטיקט פון דער זינד. ");
INSERT INTO ydd_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","אבער אויב מיר זענען געשטארבן מיט משיחן, גלויבן מיר, אז מיר וועלן אויך לעבן מיט אים; ");
INSERT INTO ydd_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","וויסנדיק, אז משיח, זייענדיק אויפגעשטאנען פון די טויטע, שטארבט מער נישט; דער טויט האט נישט מער קיין שליטה איבער אים. ");
INSERT INTO ydd_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ווארום שטארבנדיק, איז ער געשטארבן צו דער זינד איינמאל פאר אלעמאל, אבער לעבנדיק, לעבט ער צו ה׳. ");
INSERT INTO ydd_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","אזוי זאלט איר זיך אויך באטראכטן ווי טויט צו דער זינד, אבער לעבעדיק צו ה׳ אינם משיח יהושע/ישוע אונדזער האר. ");
INSERT INTO ydd_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","זאל זשע די זינד נישט קעניגן אין אייער שטערבלעכן קערפער צו געהארכן זיינע תאוות; ");
INSERT INTO ydd_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","אויך זאלט איר נישט איבערגעבן אייערע אברים ווי כלי זין פון רשעות צו זינד, נאר גיט אייך איבער צו ה׳, ווי לעבעדיק פון די טויטע און אייערע אברים ווי כלי זין פון צדקות צו ה׳. ");
INSERT INTO ydd_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ווייל די זינד וועט נישט קעניגן איבער אייך, ווארום איר זענט נישט אונטער דער (מחמיר חומרא) געזעץ, נאר אונטער דעם חסד. ");
INSERT INTO ydd_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","דעריבער וואס? זאלן מיר זינדיקן, ווייל מיר זענען נישט אונטער דער (מחמיר חומרא) געזעץ נאר אונטער דעם חסד? חס ושלום! ");
INSERT INTO ydd_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","צי ווייסט איר דען נישט, אז וועמען איר גיט זיך איבער ווי קנעכט צו געהארכן, זענט איר קנעכט (פון דעם), וועמען איר געהארכט: אדער פון זינד צום טויט, אדער פון געהארכזאמקייט צו צדקות? ");
INSERT INTO ydd_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","אבער געלויבט זיי ה׳, אז איר וואס זענט געווען קנעכט פון דער זינד, זענט געווארן געהארכזאם פונם הארצן צו דעם פארבילד פון דער לערנונג, וואס איז אייך איבערגעגעבן געווארן; ");
INSERT INTO ydd_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","און זייענדיק באפרייט פון דער זינד, זענט איר משועבד געווארן צו צדקות. ");
INSERT INTO ydd_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","איך רעד מענטשלעך צוליב דער שוואכקייט פון אייער פלייש; ווארום ווי איר האט איבערגעגעבן אייערע אברים ווי קנעכט צו טומאה און הפקר ביז הפקר, אזוי אויך איצט זאלט איר איבערגעבן אייערע אברים ווי קנעכט צו צדקות ביז קדושה. ");
INSERT INTO ydd_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ווארום ווען איר זענט געווען קנעכט פון זינד זענט איר געווען פריי פון צדקות. ");
INSERT INTO ydd_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","וואס פאר א פרוכט האט איר דען דעמאלט געהאט? זאכן, מיט וועלכע איר שעמט זיך איצט; ווייל דער סוף זייערער איז דער טויט. ");
INSERT INTO ydd_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","אבער איצט, זייענדיק באפרייט פון דער זינד און זענט געווארן קנעכט צו ה׳, האט איר אייער פרוכט צו קדושה און צום סוף דאס אייביקע לעבן. ");
INSERT INTO ydd_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ווארום דער שכר פון זינד איז דער טויט, אבער דאס אייביקע לעבן איז ה׳ס מתנה אינם משיח יהושע/ישוע אונדזער האר. ");
INSERT INTO ydd_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","אדער צי ווייסט איר נישט, ברידער—ווארום איך רעד צו די, וואס קענען די תורה—אז די תורה הערשט איבער דעם מענטשן כל זמן ער לעבט? ");
INSERT INTO ydd_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ווארום די פארהייראטע פרוי איז מן התורה געבונדן צום מאן ביים לעבן; ווען אבער דער מאן שטארבט, איז זי פטור פונם געזעץ פון מאן. ");
INSERT INTO ydd_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","דעריבער, ווען ביים מאנס לעבן זי וועט זיך איבערגעבן צו אן אנדערן מאן, וועט זי גערופן ווערן נואפת; אבער אויב דער מאן שטארבט, איז זי פריי פון דעם געזעץ, און נישט קיין נואפת, ווען זי ווערט (דאס ווייב) פון אן אנדערן מאן. ");
INSERT INTO ydd_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","אזוי אויך, ברידער מיינע, זענט איר טויט געמאכט געווארן צו דער געזעץ דורך דעם גוף פונם משיח, אז איר זאלט געהערן צו אן אנדערן, צו דעם אויפגעשטאנענעם פון די טויטע, כדי מיר זאלן ברענגען פירות צו ה׳. ");
INSERT INTO ydd_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ווארום ווען מיר זענען געווען אינם פלייש, האבן די זינדיקע תאוות, וואס זענען דורך דער געזעץ, געווירקט אין אונדזערע אברים צו ברענגען פירות צו דעם טויט. ");
INSERT INTO ydd_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","איצט אבער זענען מיר פטור פון דער געזעץ, זייענדיק געשטארבן וואס שייך דעם, צו וועלכן מיר זענען געווען געבונדן, כדי מיר זאלן דינען אין דער באנייאונג פונם גייסט, און נישט לויט דער אלטקייט פונם אות. ");
INSERT INTO ydd_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","וואס וועלן מיר דעריבער זאגן? אז די געזעץ איז זינד? חס ושלום! נאר ווען נישט דורך דער געזעץ, וואלט איך נישט געוואוסט פון דער זינד; ווייל, וואלט די געזעץ נישט געזאגט: דו זאלסט נישט גלוסטן (שמות כ, יז.), וואלט איך פון גלוסטיקייט תאווה נישט געוואוסט; ");
INSERT INTO ydd_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","און די זינד, געפינענדיק א סיבה דורך דעם געבאט, האט אויפגעוועקט אין מיר יעדע תאווה; ווארום אָן א געזעץ איז די זינד טויט. ");
INSERT INTO ydd_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","און אמאל האב איך געלעבט אָן א געזעץ; איז געקומען דאס געבאט, האט די זינד אויפגעלעבט, און איך בין געשטארבן; ");
INSERT INTO ydd_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","און עס האט זיך ארויסגעוויזן, אז דאס געבאט, וואס האט געזאלט זיין צום לעבן (ויקרא יח, ה.), איז מיר געווארן צום טויט; ");
INSERT INTO ydd_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ווארום די זינד, געפינענדיק א סיבה אינם געבאט, האט מיך פארפירט און דאדורך מיך געטייט. ");
INSERT INTO ydd_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","אזוי ארום איז די תורה הייליק, און דאס געבאט איז הייליק און גערעכט און גוט. ");
INSERT INTO ydd_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","צי איז דען דאס גוטע געווארן פאר מיר דער טויט? חס ושלום! נאר די זינד, כדי זי זאל דערשיינען אלס זינד, ווירקנדיק פאר מיר דעם טויט דורך דעם גוטן—כדי דורך דעם געבאט זאל זיך ארויסווייזן ווי זייער זינדיק זינד איז. ");
INSERT INTO ydd_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ווארום מיר ווייסן, אז די תורה איז רוחניותדיק; אבער אי