﻿USE sofia;
DROP TABLE IF EXISTS sofia.ycn_vpl;
CREATE TABLE ycn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ycn_vpl WRITE;
INSERT INTO ycn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo, Tupana I'irí, moto'orí ina'uqué penaje i'imacá. Davidmi chu, Abrahami chu, quele laquénami naquiyana ri'imacá. Marí quele necá i'imaño ra'ajútayami chuna i'imacá: ");
INSERT INTO ycn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahami chu i'imari. Isaacmi chu jara'apá ri'imacá. Ricá i'imari Jacobmi chu jara'apá. Jacobmi chu i'imari Judami chu jara'apá, rijmerénami chuna hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judami chu i'imari Faresmi chu, Zarami chu, quele jara'apá ri'imacá. Nalomi cholo ií i'imari Tamar. Faresmi chu i'imari Esromi chu jara'apá. Esromi chu i'imari Arami chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arami chu i'imari Aminadabmi chu jara'apá i'imacá. Aminadabmi chu i'imari Naasonmi chu jara'apá i'imacá. Naasonmi chu i'imari Salmonmi chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonmi chu i'imari Boozmi chu jara'apá i'imacá. Boozmi chu jaló i'imayo Rahabmi cholo i'imacá. Boozmi chu i'imari Obedmi chu jara'apá i'imacá. Rutmi cholo i'imayo raló i'imacá. Obedmi chu i'imari Isaími chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaími chu i'imari Davidmi chu jara'apá i'imacá. Ne'emacana Davidmi chu i'imacá. Uríasmi chu yajálomi cholo hua'até rihuá'aco i'imacá. Rujhua'até ri'irí i'imari, Salomonmi chu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonmi chu i'imari Roboami chu jara'apá i'imacá. Roboami chu i'imari Abíasmi chu jara'apá i'imacá. Abíasmi chu i'imari Asami chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asami chu i'imari Josafatmi chu jara'apá i'imacá. Josafatmi chu i'imari Jorami chu jara'apá i'imacá. Jorami chu i'imari Uzíasmi chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasmi chu i'imari Jotami chu jara'apá i'imacá. Jotami chu i'imari Acazmi chu jara'apá i'imacá. Acazmi chu i'imari Ezequíasmi chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasmi chu i'imari Manasesmi chu jara'apá i'imacá. Manasesmi chu i'imari Amonmi chu jara'apá i'imacá. Amonmi chu i'imari Josíasmi chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jeconíasmi chu, rijmerénami chuna quele, jara'apá i'imari Josíasmi chu. Rihuacajé najña'á Israelmi chu laquénami nate'eré naquiyá Babilonia te'eré ejo. Ajopana chá'ataño ne'emacá. Aú nahuá'a necá rejo, nasápacaloje najló penaje. Re Josíasmi chu yaní moto'oñó i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Napa'acó nate'eré ejo ejomi mariruna moto'oñó: Jeconíasmi chu i'imari Salatielmi chu jara'apá i'imacá. Salatielmi chu i'imari Zarobabelmi chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelmi chu i'imari Abiudmi chu jara'apá i'imacá. Abiudmi chu i'imari Eliaquimi chu jara'apá i'imacá. Eliaquimi chu i'imari Azormi chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azormi chu i'imari Sadocmi chu jara'apá i'imacá. Sadocmi chu i'imari Aquimi chu jara'apá i'imacá. Aquimi chu i'imari Eliudmi chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudmi chu i'imari Eleazarmi chu jara'apá i'imacá. Eleazarmi chu i'imari Matanmi chu jara'apá i'imacá. Matanmi chu i'imari Jacobmi chu jara'apá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobmi chu i'imari Josemi chu jara'apá i'imacá. Ricá huá'acaro María hua'até i'imacá. Jesús jaló ru'umacá. Ina'uqué i'imatájeri penaje Jesús. ");
INSERT INTO ycn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abrahami chu laquénami yuriño rapumí chojé a'ajná Davidmi chu i'imacá ejená. Pa'u quele iphata ji'imaji nacojé quele na'ajútayami chuna huani i'imacá. Davidmi chu apumí chojena i'imaño caja pa'u quele iphata ji'imaji nacojé quele, nahuá'a ne'emacá Babilonia te'eré nacojé ejená. Ejomi ne'emá piño pa'u quele iphata ji'imaji nacojé quele Jesucristo moto'ocá ejená. ");
INSERT INTO ycn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Marí Jesucristo moto'ocá yucuna. María i'imayo raló. Uncá chiyó ruhuá'aco José hua'até ru'umá canupá. Caja napura'ó rinacu i'imacá, nahuá'acacoloje pajhua'atéchaca penaje. I'imaqué e'iyonaja nahuá'acaco piyaja ru'umá canupá. Tupana Pechu a'arí Ri'irí rohuó chojé i'imacá. Aú caja ru'umá canupá. ");
INSERT INTO ycn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Palájne'eque ruyajná penaje José i'imacá. Caja canupá ru'umacale, uncá rihuátala ajopana ina'uqué la'acá rucá chapú rijimaje. Uncá rihuátala ajopana ina'uquejlo riyucuna i'imacana. Me'echú rihuátaca ruyurícana, canupá ru'umacale. Uncá rihuátala runacu apáña'atacana. ");
INSERT INTO ycn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Marí que ripechu nacú ri'imacá; ehuá ritapúna'aca. Ritapú pajluhuaja Tupana hua'atéjeri, je'echú chiyaje, ya'ataró rijló. Rimá rijló: —José, Davidmi chu laquemi, pipechu i'imaniya ujhuí María liyá, rujhua'até huá'acacano nacú. Ru'urí i'imajeri, Tupana Pechu a'acale rohuó chojé ricá. ");
INSERT INTO ycn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ñaquele ruhuá'ajica ee ru'urí, pa'ajé rií Jesús. Ri'imataje rile'ejena ina'uqué capichácajo liyá. Ñaquele uncá Tupana huajálaje ra'apiyá jema'ajeño pu'uhuaré nala'acare chona. Ñaquele pa'ajé rií Jesús —que Tupana hua'atéjeri quemacá Josejlo ritapú. ");
INSERT INTO ycn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Caja riphá rená chojé Tupana quemacare nacú júpimi ripuráca'alo ja'apátajerimi chujlo. Marí que rimacá rijló i'imacá: ");
INSERT INTO ycn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Pajluhuájaru inaya i'imajeyo canupá. Ru'urí i'imajeri. Nemaje rinacu: “Huajhua'até Tupana” que, que Tupana quemacá rijló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Rihuacajeja riphá rená chojé. E caja José apori. Rila'á je'echú chiyaje quemacá rijló que. Rihuá'aco María hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Canupá ru'umacá quetana uncá rara'aló runacu. E caja ruhuá'a ru'urí. Pamineco moto'ocá rojló ri'imacá. José a'arí rií Jesús. Rimoto'ocá ejomi rucá, José, quele i'imaño pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús moto'orí pajimila Belén e i'imacá. Judea te'eré nacú ricá pajimila. Jesús moto'oqué huacajé, Herodes i'imari judíona i'imacana. E caja ajopana ina'uqué iphaño Jerusalén ejo. Camú jeño'ocá ejo pumitá nephá i'imacá. Ihuijrina nacú jehuíña'ajeño ne'emacá. Ñaquele nahue'epí cajrú nacaje nacojé, ihuijrina nacú jehuíña'ajeño ne'emacale. E caja nephá nanacu. ");
INSERT INTO ycn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nemá najló: —¿Mere chi ricá, i'imacana penaje, moto'ocá maare? Huamá ihuijrí pato'ocó meyáleje. Camú jácho'oco ejo pumitá huamá ripato'ocó. Huajé huamaca ri'imacá. Aú huahue'epí rimoto'ocá i'imacá. A'acuhuaná hue'ejná majó, huamácaloje ricá, moto'orí i'imacana penaje. Pu'ují huapechu i'imacáloje rinacu penaje hue'ejná majó —que nemacá najló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ejomi ne'emá ne'emacana Heródesjlo riyucuna. Marí caje aú ricahuíla'o rinacojé. Ñaqué caja piyuque Jerusalén e i'imacaño cahuíla'aco rinacojé riyucuna jema'acana aú. ");
INSERT INTO ycn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","E ne'emacana jahuacátari sacerdótena huacára'ajeño piyuque. Najhua'até caja rahuacata Tupana puráca'alo nacú jehuíña'atajeño. E rimá najló: —¿Mecaje pajimila nacú Tupana I'irí moto'orí? ¿Ricá Tupana huacára'ajicare ina'uqué i'imatájeri penaje huemá nacú? ");
INSERT INTO ycn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","E nemá rijló: —Belén e, Judea te'eré nacú rimoto'ó. Marí que Tupana puráca'alo ja'apátajerimi chu lana'acá riyucuna júpimi i'imacá: ");
INSERT INTO ycn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judá te'eré nacú Belén. Apú pajimila chaje ricá Belén, ne'emacana penaje i'imajícale reyaje. Ricá amájeri nule'ejena ina'uqué palá. Israelmi chu laquénami ramaje palá, que rilana'acá riyucuna i'imacá —que nemacá Heródesjlo i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","E rimicho'ojneja Herodes huá'aca ihuijrina nacú jehuíña'ajeño maná. E rimá najló: —¿Merohuacajé que amaca ihuijrí pato'ocó? Ne'emá rijló riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ejomi rihuacára'a necá Belén ejo. Rimá najló: —I'ijná rejo, ihue'epichi méreca ricá. Iphátajica ee ricá rejo, eco i'imá nojló riyucuna, nomíchachi ricá, nupechu i'imacáloje pu'ují rinacu penaje —que rimacá najló majopeja i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Marí cajé aú ne'ejná reyá. E caja namá ihuijrí pato'ocó piño, namácare camú jácho'oco ejo pumitá i'imacá. Ihuijrí i'ijnari ají que natucumá nachó que. Ritajnó to'ojmá i'imacare chu pají chaje. Ihuijrina nacú jehuíña'ajeño amaño ricamaré patacá ri'imacare chu pají nacú. ");
INSERT INTO ycn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Aú caja pu'ují huani napechu i'imacá. E caja nephá rejo. ");
INSERT INTO ycn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mujlúca'año nañacaré chojé. Amaño ri'imacá re raló María hua'até. Aú natára'o ne'erúpachi aú. Najláma'o to'ojmá nacojé, pu'ují napechu i'imacale rinacu. E najme'etá napaúre chaya. Na'á rijló oro, a'ahuaná ica, pu'umé jamarí caje, apú a'ahuaná ica hua'até. Mirra rií i'imacá. Ricá na'á rijló. Rejomi napa'ó. ");
INSERT INTO ycn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","E natapúna'a. Natapú Tupana quemari najló: —¡Pa! Ipa'aniyo Herodes i'imacá ejo. Marí caje aú apú iñe'epú chuhuá napa'ó nate'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","E caja ihuijrina nacú jehuíña'ajeño pa'añó i'imacá. Eyá José tapúna'ari. Ritapú Tupana hua'ateje, je'echú chiyaje, ya'ataró rijló i'imacá. Rimá rijló: —Pácho'o. Piñáata cari to'ojmá, raló, quele ají que a'ajná ño'ojó Egipto te'eré ejo. Re pi'imajé, Herodes culájicale cari to'ojmá, rinócaloje ricá penaje. Quetana pi'imajica re. Pu'uhuacá numájica piño pijló: “Chuhua pipa'ó” que, e pipa'ataje ricá piño majó —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Raú José jácho'oro. Riñáata lapí to'ojmá, raló, quele ají que Egipto te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Rejo ne'emacá, ma'apona Herodes taca'arí i'imacá. Quéchami napa'acó piño napumí chuhuá nate'eré ejo. Tupana quemacá rinacu júpimi que, iphari rená chojé raú. Marí que rimacá ripuráca'alo ja'apátajerimi chujlo i'imacá: “Egipto eyaje nuhuá'aje nu'urí i'imajica.” ");
INSERT INTO ycn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Uncá ihuijrina nacú jehuíña'ajeño i'ijnalaño piño ne'emacana Herodes chaje, riyucuna i'imajé rijló rihuacára'aca necá que. Aú rimá nanacu: —Namácaja nala'acá nucá. Raú íqui'ija huani riyúcha'aco najhua'até. Rihuata ilé queráco'ope capichátacana, nemacare nacú: “I'imacana penaje moto'ocá ricá.” Aú rihuacára'a surárana Belén ejo, nacapichátacaloje piyuqueja yuhuaná rehuájena penaje. Ya'ajná pajimila yámajo i'imacaño hua'ató rihuacára'a capichátacana. Ihuijrina nacú jehuíña'ajeño quemaño rijló mérohuacajeca namá ilé ihuijrí pato'ocó i'imacá. Ricá nacojé rihue'epí mecajenaca yuhuaná capichátacana. Ñaquele rihuacára'a iyamá jarechí quéchajena capichátacana a'ajná queráco'opena hua'ató. ");
INSERT INTO ycn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tupana puráca'alo ja'apátajerimi chu quemacá chojé riphá raú. Marí que Jeremíasmi chu lana'acá riyucuna papera chojé i'imacá: ");
INSERT INTO ycn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Cajrú namájica chapú caje yajhué nate'eré ehuá. Cajrú neyájica nayanimínami chuna. Raquelmi cholo laquénami iyájeño cajrú nayanimínami chuna. Uncá meño'ojó ajopana pala'atálaje napechu chapú nala'acare liyá, nacapichátajicale nayani, que rimacá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","E caja Herodes taca'arí i'imacá. Rejo'ocaja Egipto te'eré nacú José i'imari riyajalo, to'ojmá, quele hua'até. E lapí ritapúna'a. Ritapú ramá Tupana hua'ateje, je'echú chiyaje, iphaca rinacu. Ricá quemari rijló: ");
INSERT INTO ycn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Chuhua pácho'o. Pihuá'a to'ojmá, raló, quele pite'eré ejo, Israelmi chu te'eré ejo. Caja nataca'á, huátaño to'ojmá nócana. Ñaquele pihuá'a to'ojmá pite'eré ejo —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","—Je —que. Raú rácho'o reyá. Rihuá'a rijhua'ató to'ojmá, raló, quele. Napa'ó ají que nate'eré ejo, Israelmi chu te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Rihuata riñacajela ejo pa'acano, Judea te'eré ejo. E'iyonaja nemá rijló: —Arquelao ne'emacana me'etení re. Heródesmi chu i'irimi ri'imacá. Aú José quero'oró rejo pa'acano piyá. E caja ritapúna'a piño. Ritapú Tupana quemari rijló ri'ijnacá piyá rejo. Aú ri'ijná Galilea te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","E caja riphá rejo. Pajimila Nazaret ejé ritajnó. Re riyuró to'ojmá, riyajalo hua'até. Re Jesús tahuá'aro i'imacá. Re caja riñapá. Tupana puráca'alo ja'apátajeñomi chuna quemacá que ri'ijnacá najló i'imacá. Nemá Jesús nacú, Nazaret eyaje ri'imajica. ");
INSERT INTO ycn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Rihuacajé Juan iphari pu'uteni meñaru chojé Tupana yucuna i'imajé ina'uquejlo. Judea te'eré ehuájenajlo ri'imá riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Marí que rimájica najló: —Ipajno'otá ipéchuhua Tupana ejo, pu'uhuaré ila'acare liyá. Yehuicha riphaca rená chojé, Tupana i'imacáloje ina'uqué huacára'ajeri penaje —que rimájica najló. ");
INSERT INTO ycn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Riyucuna, Tupana puráca'alo ja'apátajerimi chu lana'arí papera chojé i'imacá. Júpimi que Isaíasmi chu i'imacá riyucuna marí que: Nema'ajé pajluhuaja ina'uqué jahuíyo'oca pu'uteni meñaru chu. Marí que rimájica ina'uquejlo: “Chuhuaca ilamá'ataca ipéchuhua palá Huahuacára'ajerijlo. Ipajno'otá caja ipéchuhua Tupana ejo pu'uhuaré ila'acare liyá”, que rimacá rinacu i'imacá júpimi que. ");
INSERT INTO ycn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Camello chijnemi naquiyá la'acanami i'imari Juan a'arumacá i'imacá. Camejeri ímami naquiyá la'acanami i'imari rihuachaphila. Caja'ayuna caje, munumunú jalá, caje i'imari ra'ajné. ");
INSERT INTO ycn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pu'uteni meñaru chu ri'imaqué Tupana yucuna i'imacana nacú ina'uquejlo. Cajrú Jerusalén eyájena i'ijnajica ripuráca'alo jema'ajé. Pajimila ií Jerusalén. Piyuque ina'uqué, Judea te'eré e'iyohuá i'imajícaño, i'ijnajica caja ripuráca'alo jema'ajé. Jordán cha ñacajélaruna i'ijnaqueño caja ripuráca'alo jema'ajé. Juni ií Jordán. ");
INSERT INTO ycn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ne'emajica ee pu'uhuaré nala'ajícare yucuna Tupánajlo, rila'aqué bautizar necá juni Jordán acojé. ");
INSERT INTO ycn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fariseo naquiyana, saduceo naquiyana, quele iphaño caja Juan nacú, rila'acáloje bautizar necá penaje. Uncá napajno'otala napéchuhua pu'uhuaré nala'acare liyá. Juan amaca aú nephaca rinacu rimá najló: —Pajlácachina ta icá. Iqui'i huani Tupana huajájica pu'uhuaré la'acaño. ¿Na quemari ijló, “i'imajó riliyá” que? ");
INSERT INTO ycn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ila'á palá, iná hue'epícaloje raú, caja iyurica iliyó pu'uhuaré ila'acare penaje. ");
INSERT INTO ycn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Imaniya inacuhuá marí que: “Abrahami chu laquénami huecá. Ñaquele lamára'ataquejanami que huecá Tupánajlo”. Uncá ñaqué calé ricá ijló. Uncá Tupana i'imatálaje icá capichácajo liyá raú. Tupana huátaquela, rehuíña'atajla marí jipa, ri'imacáloje Abrahami chu laquénami penaje. ");
INSERT INTO ycn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Iná la'á iná peruné iré, iná i'icatácaloje paijí mecharú iná mená e'iyayá penaje. Rimacára'aco ejomi iná cára'ata ricá piyuqueja ra'apare hua'ató. Ñaqué caja Tupana huajájica ina'uqué naquiyana. Rihuajaje namanaicho la'ajeño, pu'uhuaré la'ajeño, uncá paala la'acaño, cajena rihuajaje marí que. ");
INSERT INTO ycn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nucá la'arí bautizar ina'uqué juni aú —que Juan quemacá—. Raú ajopana ina'uqué hue'epiño caja napajno'otaca napéchuhua Tupana ejo pu'uhuaré nala'acare liyá. Ricá penaje nula'á bautizar necá. Nopumí chojé apú iphájeri. Iqui'i huani nuphácare ja'apí ricá, nuchaje huani ri'imacale. Ricá a'ajeri ina'uquejlo Tupana Pechu. Ricaja caja huajájeri pu'uhuaré la'acaño, namanaicho la'acaño, eja'ahuá tajnájico huacajé. ");
INSERT INTO ycn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nopumí chojé iphájica la'ajeri trigo a'arumi ca'ajeño la'acá que caja. Te'erí ichajona aú nácho'ota ricá, carená apho'ocáloje ra'arumi re'iyayá penaje. Quéchami paminá lamá'ataca riñacarelana chojé richa. Ra'arumi ricupá quera'atani uncá yacálare chojé. Marí que caja nopumí chojé iphájica huajájica ina'uqué e'iyohuá. Palá la'ajeño i'imajeño rijhua'até. Eyá pu'uhuaré la'ajeño, namanaicho la'ajeño, rica'ajé quera'atani uncá yacálare chojé —que Juan quemacá najló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","E caja Jesús ñapari i'imacá. Juan i'imacá pu'uteni meñaru chu huacajé rácho'o Galilea te'eré eyá, ri'ijnacáloje ají que Juan chaje penaje. Juni Jordán e ri'imacá. E caja riphá Juan nacú. Jesús quemari rijló: —Pila'á nucá bautizar. ");
INSERT INTO ycn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ijnú Juan huátaca rila'acana bautizar. Rimá rijló: —Palánijlaca pila'acajla bautizar nucá. Eta picá iphíchari nunacu, nula'acáloje picá bautizar penaje. ");
INSERT INTO ycn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","E'iyonaja Jesús quemari rijló: —Picá la'ajeri bautizar nucá. Palani caja iná la'acá nacaje piyuqueja Tupana huátaca que. —Je. Ñaqué ricá —que Juan quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Raú rila'á ricá bautizar. Ejomi Jesús jácho'oro junápiya. Hua'ató que je'echú je'echataco. Ricá chiyá Jesús amari Tupana Pechu huitúca'aca ají que majó. Túcu'uchi huitúca'aca que rihuitúca'aca rinacojé. ");
INSERT INTO ycn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ejéchami Tupana quemacá marí que je'echú chiyá: —Marí Nu'urí. Iqui'ija nuhuátacare ricá. Pu'ují huani nupechu rinacu —que rimacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Caja Juan la'arí bautizar Jesús i'imacá. Ejomi Tupana Pechu huacára'ari ricá pu'uteni meñaru chojé, Jiñá Chi'ináricana ca'átacaloje re'iyajé rejo penaje. ");
INSERT INTO ycn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Re ri'imá iyamá ina'uqué le'ejé que cala quetana. Marí quetana uncá rajñala ra'ajnehuá; quehuí rijló me'epejí i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ejéchami Jiñá Chi'ináricana iphaca Jesús nacú. Rihuata re'iyajé ca'átacana, rila'acáloje pu'uhuaré raú penaje. E rimá rijló: —¿Quehuaca chi Tupana I'irí picá? Nuhue'epícaloje ñaqué picá penaje, pihuacára'a marí jipa jehuíña'aco a'ajnejí penaje. ");
INSERT INTO ycn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Uncá Jesús jema'alá ra'apiyá. Rimá rijló: —Marí que Tupana puráca'alo lana'aquéjami quemacá: “Uncá a'ajnejí aú ja calé iná i'imá. Piyuqueja Tupana puráca'alo ja'apiyá jema'acana aú iná i'imá” —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","E Jiñá Chi'ináricana huá'ari ricá pajimila Jerusalén ejo. Re rihuá'a ricá Tupana ñacaré i'ihuátaje. ");
INSERT INTO ycn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","E rimá rijló: —Tupana I'irí pi'imajica ee, peño'ó maáreya cahuacaje te'erí e'iyajé. Pu'uhuacá Tupana I'irí pi'imajica ee, uncá meque pila'alajo raú. Marí que Tupana puráca'alo lana'aquéjami quemacá rinacu: Tupana huacára'ajeri rijhua'atéjena, je'echú chiyájena, a'acá nanacojó iná. Necá patañó iná ja'apí, iná la'acó piyá quehuí jipa nacojé ja'acano aú, que ripuráca'alo lana'aquéjami quemacá rinacu —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Raú Jesús quemari rijló: —Apa'amá caja Tupana puráca'alo lana'aquéjami quemari marí que: “Pila'aniya pimanaicho, pamachi méqueca Pihuacára'ajeri Tupana a'acá piñaté raú”. ");
INSERT INTO ycn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","E caja Jiñá Chi'ináricana huá'ari piño ricá ipuré i'ihuátaje. Yenoje huani ri'imacá. Reyá riya'atá rijló ajopana te'eré, ajopana te'eré que. Piyuque marí eja'ahuá chu i'imacaño ñacajela riya'atá rijló ipuré i'ihuátaya. Piyuque nacaje palá nojé re'iyá i'imacare hua'ató riya'atá rijló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ejéchami Jiñá Chi'ináricana quemacá Jesusjlo: —No'ojé pijló nate'eré piyuqueja, pi'imacáloje ne'emacana penaje. Piphájica ee no'opí, pitára'o pi'irúpachi aú nujimaje. E no'ojé pijló ricá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Raú Jesús quemari rijló: —Pa'apá nuliyá, Satanás. Marí que caja Tupana puráca'alo lana'aquéjami quemacá: “Piphá Tupana ja'apija. Iná Huacára'ajeri huani ricá. Ricá ja'apiyaja calé iná jema'á palá”. ");
INSERT INTO ycn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Marí que rimacá rijló aú Jiñá Chi'ináricana ja'apari riliyá. Ejomi Tupana hua'atéjena, je'echú chiyájena, iphaño nacaje la'ajé Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Caja naca'á Juan ina'uqué huajáquelana chojé i'imacá. Jesús jema'arí riyucuna. Raú ripa'ó riñacajela ejo, Galilea te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Uncá riyurilo pajimila Nazaret e. Ranúca'o pajimila Capernaum ejo. Caésa cajruni cha ricá pajimila. Zabulón te'eré, Neftalí te'eré, quele te'eré ahua'á ricá. Rejo ranúca'o. ");
INSERT INTO ycn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tupana puráca'alo ja'apátajerimi chu quemacá que rila'acá raú. Marí que ripuráca'alo quemacá, Isaíasmi chu lana'acare papera chojé i'imacá: ");
INSERT INTO ycn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón te'eré, Neftalí te'eré ahua'ayá iñe'epú to'oró. Richuhuá ina'uqué i'ijnaño juni jalomi ejo. Juni Jordán pa'anajo pitá re Galilea te'eré. Re cajrú ina'uqué rehuá. Uncá judíona calé necá. ");
INSERT INTO ycn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Uncá hue'epílaño Tupana nacojé necá. Necá jema'ajeño ripuráca'alo, nahue'epícaloje cajrú rinacojé raú penaje. Capichájeño penájena jema'ajeño Ne'ematájeri yucuna, que ripuráca'alo lana'aquéjami quemacá. ");
INSERT INTO ycn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","E Jesús queño'orí Tupana yucuna i'imacana najló rehuá. Marí que rimájica najló: —Ipajno'otá ipéchuhua pu'uhuaré ila'acare liyá. Yehuicha riphaca rená chojé, Tupana i'imacáloje ina'uqué naquiyana huacára'ajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","E caja Jesús chira'aró ají que caesa turenahua. Galilea caesa ií. E ramá ajopana ina'uqué. Ramá Simón Pedro, re'ehué Andrés hua'até. Jiña ña'ajeño huená chojé ne'emacá. Nahuenare naca'acá ejé riphá nanacu. ");
INSERT INTO ycn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—I'ijná nujhua'até —que rimacá najló—. Jiña ña'acana nacú sápajeño icá. Chuhua no'ojica ijló apú sápacaje. Ihuá'aje nojló ina'uqué, ne'emacáloje no'opiyá jema'ajeño penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","—Je —que nemacá rijló. Rejeja nayurí nacápiyo nahuenare; i'ijnaño rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","E caja Jesús ja'apari piño a'ajná ño'ojó pani. Amari piño apú re'ehué hua'até caja. Santiago rií. Re'ehué ií Juan. Nara'apá ií Zebedeo. Netane chu ne'emá nahuenare lamá'atacana nacú. Ramá necá. Rimá Santiágojlo, Juanjlo hua'até: ");
INSERT INTO ycn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","—I'ijná nujhua'até. Raú caja ne'ejná rijhua'até. Na'apaña netane nara'apá hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús ja'apari piyuque Galilea te'eré e'iyohuá Tupana yucuna i'imacana nacú. Rehuíña'ataque necá ajopana, ajopana que nahuacáca'alo ñacarelana chu. Ri'imaqué Tupana i'imataca ina'uqué capichácajo liyá yucuna najló, ne'emacáloje rijhua'atéjena raú penaje. Ra'apátaque natámina liyá nayaripune que'iyapejé. ");
INSERT INTO ycn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Marí que ri'imacale rehuá, cajrú riyucuna moto'ocá rehuá. Ya'ajná Siria te'eré ejená riyucuna jema'acó i'imacá. E nahuá'a richaje cajrú natámina. Quehuini yajhué amájeño ne'emacá. Que'iyapé nayaripune i'imacá. Jiñana pechu cahuíla'aque ne'iyajena nacú. Ne'iyajena nopana taca'átaqueri i'imajica. Ne'iyajena napona taca'aqueri camachá. Uncá meño'ojó nacahuitala. Marí cajena nahuá'aque Jesús ejo, ritejmo'ótacaloje necá piyuqueja penaje. ");
INSERT INTO ycn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Cajrú ina'uqué i'ijnajica rijhua'até. Galilea eyájena nanaquiyana i'imacá. Decápolis ehuá re iyamá té'ela quele pajimila. Reyájena ajopana i'imacá. Jerusalén eyájena, Judea te'eré eyájena, quele i'ijnaño caja rijhua'até. Ajopana i'imaño Jordán pa'anajo pitá eyájena. Quele i'ijnaqueño rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús amari cajrú ina'uqué jahuacaco rinacojé. Aú rácho'o yenuri i'ihuátaje. Re riyá'o. Ejomi rijhua'até jehuíña'ajeño i'ijnaño rápumi chu. Rejé nahuacó rinacojé. ");
INSERT INTO ycn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","E riqueño'ó nehuíña'atacana marí que: ");
INSERT INTO ycn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Re ina'uqué nemá Tupánajlo: “Pa'á huañaté, huala'acáloje pihuátaca que penaje. Uncá meño'ojó huala'alá huecó pihuátaca que”. Marí que quemacáñojlo ri'imajé palá, Tupana i'imacale Nahuacára'ajeri. ");
INSERT INTO ycn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Palani huani inajlo, camu'ují iná pechu i'imacachu pu'uhuaré iná la'acare nacú. Palani inajlo, Tupana pala'atájicale inajlo iná pechu. ");
INSERT INTO ycn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Palani huani ina'uquejlo, uncachu nala'alá necó hue'epiño que. Necá caja i'imajeño rijhua'até je'echú chu rimacá nanacu que. ");
INSERT INTO ycn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Palani huani inajlo, huechi iná huátacachu Tupana huátaca que la'acana. Aú Tupana a'ajeri iná ñaté rila'acana aú. ");
INSERT INTO ycn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Palani huani inajlo, iná hue'epícachu ajopana ina'uqué mu'ují. Ñaqué caja Tupana hue'epíjica iná mu'ují. ");
INSERT INTO ycn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Palani huani ina'uquejlo, nahue'epícachu Tupana huátaca que la'acana natucumó. Necá caja amájeño Tupana. ");
INSERT INTO ycn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Palani huani ina'uquejlo, napala'atácachu ajopana ina'uqué pechu, napechu i'imacá piyá chapú panacuhuácaca. Raú Tupana quemájeri nanacu: “Nuyani necá” que. ");
INSERT INTO ycn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Palani huani ina'uquejlo, ajopana la'acachu necá chapú, nala'acale Tupana huacára'aca que. Nahuacára'ajeri Tupana. ");
INSERT INTO ycn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Apala ajopana ca'ajná quemájeño inacu: “Uncá ina'uquélaruna necá” que. Apala nala'ajica icá chapú. Apala majopeja napajlájica inacu. Palani huani ijló, marí que nala'acachu chapú icá, no'opiyá jema'ajeño i'imacale. ");
INSERT INTO ycn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ipechu i'imá pu'ují raú, palani huani nacaje i'imajícale ijló je'echú chu. Ñaqué caja a'ajútayami chuna naquiyana la'ajica chapú Tupana puráca'alo ja'apátajeñomi chuna i'imajica. ");
INSERT INTO ycn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Icá, no'opiyá jema'ajeño, la'añó palá marí eja'ahuá chu, ina'uqué i'imacáloje palá pajhua'atéchaca raú penaje. Yuquira i'imacá a'ajnejijlo que caja icá ajopana ina'uquejlo, ila'acachu necá palá. Yuquira, palani rica'acana a'ajnejí e'iyajé. E'iyonaja rila'acochu uhui'ichí, uncá meño'ojó iná pa'atala rapumí chuhuá ricá, ri'imacáloje ca'ajipareni penaje. Uncá na penaje calé ricá uhui'ichini. Iná cupá ricá te'erí e'iyajé, ina'uqué ja'apácaloje re'iyohuá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Icá, no'opiyá jema'ajeño, la'añó Tupana huátaca que. Raú caja amata ajopana ñaqué la'acana aú. Iná camaré ja'apí nacaje amaro palá. Pu'uhuacá caja iná amaca pajimila yenuri i'ihuata nacú yá'aco. ");
INSERT INTO ycn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iná lucúna'acachu iná camaró, uncá iná yá'atala ricá i'ichí lájma'ataqueja ja'apejé. Yenú iná yá'ata ricá, piyuque pachu i'imacaño amácaloje palá ricamaré chojé penaje. ");
INSERT INTO ycn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Icá, no'opiyá jema'ajeño, la'ajeño caja palá. Raú ajopana ina'uqué amájeño palá ila'acare Tupana ja'apiyá jema'acana aú. Palá napura'ajico Tupana, je'echú churí, nacú raú. ");
INSERT INTO ycn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ipechu i'imaniya marí que nunacu: “Ricá quemájeri huajló, hue'emacá piyá reyá a'ajná ño'ojó Tupana puráca'alo ja'apiyá, ricá Moisesmi chu lana'acare i'imacá. Ripuráca'alo ra'apátajeñomi chuna lana'acare hua'ató rimaje nacú huajló, hue'emacá piyá ra'apiyá”, que ca'ajná ipechu nunacu. Uncá ricá penaje calé nu'ujná majó. Nacaje numacare nacú, ina'uqué hue'epéjeño meque quemacánaca ricá nemacare nacú i'imacá. Nacaje nula'acare aú caja nahue'epeje ricá. ");
INSERT INTO ycn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Jema'á marí: Tupana puráca'alo, Moisesmi chu lana'acare, re caja jo'ó riyuríjica ijló. Piyuque nacaje rimacare nacú, i'imacáloje ñaqué caja penaje, quetánaja ri'imajica ijló. ");
INSERT INTO ycn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Iná la'acáloje piyuqueja nacaje rimacá que penaje ricá. Ajopana ca'ajná uncá a'alaño nanacojó rinaquiyánaja, majopéjari. Nehuíña'ata caja ajopana, na'acá piyá nanacojó ricá. Ilé cajena i'imajeño majopéjaruna queja je'echú chu. Rehuájena huacára'ajeri Tupana. Ajopana ca'ajná a'añó nanacojó ripuráca'alo. Nehuíña'ata caja ajopana, nala'acáloje rimacá que penaje. Ilé cajena i'imajeño ajopana chaje je'echú chu. Rehuájena huacára'ajeri Tupana. ");
INSERT INTO ycn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Palá numacá ijló: Re e'iyá Tupana puráca'alo nacú jehuíña'atajeño, fariséona quele. Uncá huani i'ijnalaje je'echú chojé, uncachu ichá'atala necá Tupana huátaca que la'acana aú —que Jesús jehuíña'ataca necá. ");
INSERT INTO ycn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Marí que puráca'aloji quemacá Tupana yurícare peñahuilánami chúnajlo i'imacá: “Inóniya ina'uqué. Nójeri apú, najña'ajé ricá nahuacára'ajeño ejo, nahuajácaloje ricá penaje”. ");
INSERT INTO ycn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Eyá nucá quemari marí que rinacu: Yúcha'ajero apú inaquiyana cha, ilé najña'ajé ihuacára'ajeri ejo, nahuajácaloje ricá penaje. Pura'ajero pu'uhuaré inaquiyana nacú, ilé najña'ajé ihuacára'ajeño, peñahuilana, quele ejo, nahuajácaloje ricá penaje. Quemájeri apú inaquiyana nacú: “Mapéchuru huani ta ricá” que, ilé amájeri quera'atani yajhué uncá yacálare. ");
INSERT INTO ycn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Apala pi'ijná Tupana ñacaré ejo, pa'acáloje Tupánajlo pirajina naquiyana, nenócarena pu'uhuaré iná la'acare chaya penaje. Marí que la'acana nacú ca'ajná picá Tupana ñacaré chu. E riphá pipechu nacú: “Re nunaquiyana, chapú ripechu nunacu”. ");
INSERT INTO ycn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Marí que ri'imajica ee pijló, rejeja piyurí nacaje pihuátacare a'acana Tupánajlo. Pamineco pi'ijnajé chapú péchuri pinacu chaje, ilamá'atacaloje ricá pajhua'atéchaca penaje. Quéchami pipa'ajico piño nacaje a'ajé Tupánajlo. ");
INSERT INTO ycn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Apú ca'ajná arucátari picá, uncá pachá pa'alá pilehuérica rijló huemí. Raú ca'ajná rihuata pihuá'acana ihuacára'ajeri chaje, rilamá'atacaloje pijhua'até ricá penaje. Pilamá'ata ricá rijhua'até iñe'epú chuhuá ja'apácana nacú, rihuá'aca piyá picá ihuacára'ajeri ejo. Ricá ca'ajná a'ajeri picá policíajlo. Eyá ricá ca'ajeri picá ra'apiyá ina'uqué huajáquelana chojé. ");
INSERT INTO ycn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Numá pijló, uncá pácho'olajo richiyá a'ajná pa'atájica pilehuéricare huemí rijló ejená. ");
INSERT INTO ycn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Marí que puráca'aloji quemacá, Tupana yurícare peñahuilánami chúnajlo i'imacá: “Uncá achiñana, inaana quele la'alájeño namanaicho pajhua'atéchaca”. ");
INSERT INTO ycn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Eyá nucá quemari: Yacá'aro inanaru chaje riñujure aú, la'arí rimanaicho. Rujhua'até la'acana que caja rijló ricá. ");
INSERT INTO ycn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Pila'acachu pu'uhuaré nacaje pamácare pachá, piyurí piliyó ricá. Palani pijló riyurícana piliyó, pi'ijnacá piyá richona quera'atani yajhué amaje. Picahuícha'aquela pijlú majó, pica'acáloje pinaquiyó ricá penaje, palani ri'imacajla pijló. Pila'aquela marí que, pi'ijnacá piyá quera'atani chojé, palani ri'imacajla pijló. Iná napona naquiyánaja calé capichácojla raú. Chapú huani inajlo ri'imacajla, piyuque iná napona capicháquelo. ");
INSERT INTO ycn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pila'acachu pu'uhuaré nacaje pila'acare piyáte'ela aú pachá, piyurí piliyó rila'acana. Palani pijló piliyó riyurícana, pi'ijnacá piyá richona quera'atani yajhué amaje. Pimata'aquela pinaquiyó piyáte'ela ca'aña chojori pila'acare aú pu'uhuaré, pica'acáloje huichá ricá a'ajná ño'ojó que penaje, palani ri'imacajla pijló. Pila'aquela marí que, pi'ijnacá piyá quera'atani chojé, palani ri'imacajla pijló. Iná napona naquiyánaja calé capichácojla raú. Chapú huani inajlo ri'imacajla, piyuque iná napona capicháquelo. ");
INSERT INTO ycn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Marí que Tupana puráca'alo lana'aquéjami quemacá iná yajalo yurícana nacú: “Iná huátacachu iná yajalo yurícana caja penaje, iná a'á rojló papera lana'aquéjami, ruhue'epícaloje na pachaca iná yurica rucá penaje. Raú iná yurí rucá” que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Eyá nucá quemari marí que: Yuriri riyajalo, uncá la'alayo rumanaicho apú hua'até, la'arí rimanaicho raú. Apa'ahuelo hua'até la'acana queja caja ricá. Apú huá'acaro riyajalo penájerumi hua'até, la'arí caja rimanaicho. Apa'ahuelo hua'até la'acana queja caja Tupánajlo ricá. Ñaqué caja rula'acá rumanaicho raú. Tupana pechu i'imacale runacu: “Apú yajalo jo'ó rucá”. ");
INSERT INTO ycn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Marí que caja puráca'aloji quemacá, Tupana yurícare peñahuilánami chúnajlo i'imacá: “Pimacachu ‘quehuaca’ que Tupana nacú, ajopana hue'epícaloje raú pimacá que pila'ajica ricá, pila'á richuhuaja ricá”, que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Eyá nucá quemari ijló marí que: Uncá na penaje calé imaje apú nacaje nacú, ajopana hue'epícaloje imacá que ila'ajica raú penaje. Imániya caja ‘quehuaca’ que je'echú nacú, richiyá Tupana huacára'acale rijhua'atéjena. ");
INSERT INTO ycn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Imániya caja ‘quehuaca’ que eja'ahuá nacú, camu'ují huani Tupánajlo eja'ahuá i'imacale. Nacaje nacú iná to'otá iná i'imá, que caja rijló eja'ahuá. Imániya caja ‘quehuaca’ que pajimila Jerusalén nacú, I'imacana huani le'ejé pajimila ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Imaniya caja ‘quehuaca’ que ihuíla'aru nacú, uncale ihue'epila pajluhuélano ihuilá lajnere apiyácacana cameni aú, jareni aú. ");
INSERT INTO ycn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Marí que imájica: “Nula'ajé ricá”, que ca'ajná, “Uncá nula'alaje ricá”, que ca'ajná imájica. Rejeja calé imaje rinacu. Ila'á imacá que. Jiñá Chi'ináricana liyaje ricá richaje nacú quemacana. ");
INSERT INTO ycn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Marí que puráca'aloji quemacá, Tupana yurícare peñahuilánami chúnajlo i'imacá: “Apú ca'ajná la'ajeri picá chapú. Ñaqué caja pila'ajica piño ricá chapú. Apala apú apichátajeri apú pijlú. Ñaqué caja papichátajica rijlú. Apala apú apichátajeri apú paí naquiyana. Ñaqué caja papichájica caja raí naquiyana”, que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Eyá nucá quemari marí que: Ipura'aniyo ile'ejé jacumi nacú, nala'acachu icá chapú. Marí que ila'ajica: Apú ña'ajica ee icá pajimaya majó ca'ajná, ipajno'otá rijló apojó pitari ijimá, riña'acáloje icá reyá ñaqué caja penaje. ");
INSERT INTO ycn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Apú ca'ajná arucátajeri picá majopeja. Aú rihuá'aje picá ihuacára'ajeño ejo, nalamá'atacaloje pijhua'até ricá penaje. E ca'ajná najña'ajé picamichare pinaquiyá multa huemí penaje. Pa'á rijló ricá. Richaje pa'ajé rijló ricá. Apú pa'arumacá naquiyana hua'até pa'ajé rijló. ");
INSERT INTO ycn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ajopana te'eré le'ejena surárana naquiyana ca'ajná huacára'ari pijña'acá rijló nacaje. Rihuacára'ajica ee pijña'acá ricá iyajmela eja'ahuá jená quetana, rihuátajica ee, pijña'á rijló ricá richaje jucaca, pa'u quele eja'ahuá jená quetana ca'ajná. ");
INSERT INTO ycn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Apú quemájica ee pijló, pa'acáloje rijló nacaje rila'ajícare camu'ují nacú penaje, pa'ája rijló ricá. Apú quemájica ee pijló, piya'atácaloje rijló nacaje penaje, piyurija rijló ricá. ");
INSERT INTO ycn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Marí que puráca'aloji quemacá, Tupana yurícare peñahuilánami chúnajlo i'imacá: “Ihuata íqui'ija palá péchuruna inacu. Eyá chapú péchuruna inacu, ñaqué caja amaca necá chapú”, que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Eyá nucá quemari marí que: Ihuata íqui'ija chapú péchuruna inacu. “Uncá ina'uquélaruna necá”, que ca'ajná nemájica inacu. Ipura'ó Tupana hua'até marí que inacu quemajeño nacú. Ipura'ó Tupana hua'até la'añó icá chapú nacú. ");
INSERT INTO ycn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Marí que la'acana aú icá i'imaño Tupana yaní. Jara'apá, je'echú chu i'imacare, la'acá que caja ila'acá raú. Ricá huacára'ari camú camaré patacá ina'uquejlo pajimato. Palá la'acáñojlo, pu'uhuaré la'acáñojlo hua'até rihuacára'a camú patacá. Rihuacára'a caja juni ja'acó palá la'acáñojlo, pu'uhuaré la'acáñojlo hua'até. Palá rila'acá ina'uqué pajñacani. ");
INSERT INTO ycn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ihuátacachu íqui'ija necaja calé, huátaño caja icá íqui'ija, uncá Tupana a'alaje ijló rihuemí, uncale ila'alá palá raú. Liñeru ña'ajeño ne'emacánajlo, uncá ina'uqué huátalarena necá. Necá caja huátaño íqui'ija palá péchuruna nanacu. ");
INSERT INTO ycn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ajalácachu ejénaja calé, uncá ila'alá palá raú. Uncá hue'epílaño Tupana nacojé ajalácaño ñaqué caja pecohuácaca. ");
INSERT INTO ycn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jara'apá, je'echú chu i'imacare, uncá pu'uhuaré la'ajeri calé ricá. I'imá ricá que caja. ");
INSERT INTO ycn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ne'iyajena la'añó palá ajopana ina'uqué jimaje, ajopana quemacáloje nanacu: “¡Meque palá huani nala'acá!” que penaje. Ihuátajica ee palá la'acana, ila'aniya ilé que. Ñaqué ila'ajica ee ricá, uncá Tupana a'alaje ijló palá ila'acare huemí. ");
INSERT INTO ycn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ñaquele a'ajica ee camu'ují la'acáñojlo nacaje, i'imaniya riyucuna cajrú ina'uquejlo. Re pajlácachina, nala'á necó palá la'ajeño que ina'uqué ijlú chu. E'iyonaja uncá ñaqué calé necá. Necá a'añó camu'ují la'acáñojlo nacaje nahuacáca'alo ñacarelana chu ajopana jimaje. Le'ejepelaji ñacarelana copi, cajrú ina'uqué e'iyá, na'á camu'ují la'acáñojlo nacaje. Marí queja nala'acá, ina'uqué pura'acóloje palá nanacu penaje. Numá ijló, palá nemacare nanacu, ricaja calé i'imari najló nala'acare huemí. Uncá Tupana a'alaje najló rihuemí, uncale nala'alá palá. ");
INSERT INTO ycn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A'ajica ee camu'ují la'acáñojlo nacaje, i'imaniya riyucuna apujlo, ijhuáque'ehuejlo, quélejlo. ");
INSERT INTO ycn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Me'echú a'acá najló ricá ajopana jema'acá piyá riyucuna. Tupana amari nacaje iná la'acare me'echú caje. Ricá a'ajeri inajlo palá iná la'acare huemí. ");
INSERT INTO ycn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ipura'acochu Tupana hua'até, i'imaniya ileruna pajlácachina que. Cajrú ina'uqué e'iyá napura'ó Tupana hua'até nahuacáca'alo ñacarelana chu. Le'ejepelaji ñacarelana copi napura'ó caja Tupana hua'até, cajrú ina'uqué amácaloje necá penaje. Nemacáloje nanacu: “Meque palá huani napechu Tupana nacú”, que penaje. Numá ijló, ricaja calé nemacare nanacu i'imari nala'acare huemí. Uncá Tupana a'alaje najló rihuemí, ñaqué la'acana huemí. ");
INSERT INTO ycn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ñaquele iná huátajica ee Tupana hua'até pura'acano, iná mujlúca'a ucapú chojé, iná icoja iná i'imacáloje re penaje. Richu iná pura'ó iná jara'apá, Tupana hua'até. Uncá iná amálare ricá Tupana, iná pura'ó hua'até. Ricá amari nacaje iná la'acare meñaru chu. Ricá calé a'ajeri inajlo palá iná la'acare huemí. ");
INSERT INTO ycn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Iná pura'acochu Tupana hua'até, uncá iná quemalá rijló pajluhuaja nacuja richuhuaja. Apú nacú, que'iyapé iná pura'acó rijhua'até. Necá, uncá hue'epílaño Tupana nacojé, pura'añó pajluhuaja nacuja Tupana hua'até. Napechu i'imá: “Cajrú pura'acajo aú Tupana jema'arí iná ja'apiyá”. ");
INSERT INTO ycn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ipura'aniyo ilé que huani Tupana hua'até. Tupana hue'epiri naca iná la'acare nacú camu'ují, uncá chiyó iná quemá rijló rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Marí que ipura'ajico Tupana hua'até: Huara'apá, je'echú chu i'imacare. Palájne'eque huani picá. ");
INSERT INTO ycn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Piyuqueja ina'uqué huacára'ajeri penaje picá. Huahuata caja pi'imacá Huahuacára'ajeri. Huahuata caja ina'uqué la'acá maare eja'ahuá chu nacaje pihuátaca que, je'echú chu nala'acá que caja. ");
INSERT INTO ycn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pa'á huajló a'ajnejí chuhuajá, huajñácaloje penaje. ");
INSERT INTO ycn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pamó huachaje pu'uhuaré huala'acare liyá, huamaco ajopana chaje chapú nala'acare huecá liyá que caja. ");
INSERT INTO ycn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Piyuríniya nacaje a'acá huame'é rijluhua, huala'acá piyá pu'uhuaré raú. Pi'imatá caja huecá pu'uhuaré la'ajeño huacára'ajeri liyá. Huahuacára'ajeri huani picá. Picá hue'epiri piyuqueja nacaje la'acana nacojé. Matajnaco pi'imajica. Caja queja pi'imajica palánija. Marí que ipura'ajico Tupana hua'até —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Amácochu ajopana chaje, chapú nala'acare icá liyá, Jara'apá, je'echú chu i'imacare, amájero caja ichaje pu'uhuaré ila'acare liyá. ");
INSERT INTO ycn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Uncachu amalo nachaje, chapú nala'acare icá liyá, uncá caja Jara'apá amálajo ichaje pu'uhuaré ila'acare liyá. ");
INSERT INTO ycn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’I'itajico ee a'ajné liyá, ipechu i'imacáloje Tupana nacuja raú penaje, ila'aniya pajlácachina la'acá que caja. Necá la'añó najimahua pu'uhuaré, ajopana ina'uqué hue'epícaloje raú ne'etacó na'ajné liyá penaje. Nemacáloje nanacu: “Meque cajrú huani napechu Tupana nacú”, que penaje. Numá ijló, ricaja calé, palá nemacare nanacu i'imari nala'acare huemí. Uncá Tupana a'alaje najló rihuemí, uncale nala'alá palá. ");
INSERT INTO ycn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","I'itajico ee a'ajné liyá, ipá ijimá chiyá. A'ató palá ihuilá e'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Marí que ila'ajica, ajopana hue'epica piyá i'itacó a'ajné liyá. Jara'apá, uncá iná amálare, ricaja calé hue'epéjeri ricá. Ricá a'ajeri ijló palá ila'acare huemí. ");
INSERT INTO ycn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Jahuacátaniya ijluhua cajrú nacaje marí eja'ahuá chu. Maare pi'iréjena apichátaño iná nane. Ricoja iná nane apichaco. Ata'acáchina mujlúca'año iná ñacaré chojé rata'ajé. ");
INSERT INTO ycn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ñaquele ila'á nacaje Tupana huátaca que, nacaje i'imacáloje ijló je'echú chu penaje. Re uncá pi'iréjena apichátalaño nacaje. Uncá caja nacaje apichalo ricó. Uncá caja ata'acáchina mujlúca'alaño richojé nacaje ata'ajé. ");
INSERT INTO ycn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Iná i'ijnatá iná péchuhua nacaje íqui'i iná huátacare nacú. Iná huátacachu íqui'ija nacaje je'echú chu i'imacare, iná i'ijnatá caja iná péchuhua rinacu. Eyá iná huátacachu íqui'ija nacaje marí eja'ahuá chu i'imacare, iná i'ijnatá caja iná péchuhua rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Iná pechu loco'opánija iná la'acá nacaje. Palá iná pechu i'imacachu, iná hue'epí caja piyuque nacaje la'acana palá. ");
INSERT INTO ycn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Uncachu iná pechu i'imalá palá, uncá caja iná hue'epila naca la'acana palá. Chapú huani nacaje i'imacá inajlo raú. ");
INSERT INTO ycn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Tupana i'imacachu iná huajhué, uncá iná huajhué calé liñeru. Liñeru i'imacachu iná huajhué, uncá iná huajhué calé Tupana. Iná hue'epícachu liñeru jahuacátacana inajluhua iná tucumó, uncá iná hue'epila Tupana huátaca que la'acana iná tucumó. Uncá meño'ojó iná pechu i'imalá iyamá chuhuá. ");
INSERT INTO ycn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Ñaquele numá ijló: Ipechu i'imaniya marí que ajñacaje nacú: “Uncá na i'imalaje ca'ajná huajló, huajñácaloje penaje. Huataca'ajica me'epejí nacú ca'ajná”. Ipechu i'imaniya ñaqué caja i'iracaje nacú, a'arumacaji nacú. Tupana palamane iná cajmuchá inajlo, iná napona hua'até. A'ajnejí, a'arumacaji, quele chaje iná cajmuchá, iná napona hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ihue'epí cupira'aphana nacojé. Yenuhua ajrácaño necá. Uncá nejátala nacaje icha ijí, najña'acáloje richa najluhua penaje. Uncá caja a'ajnejí ñacarelana i'imalá najló, nalamá'atacaloje najluhua a'ajnejí richojé penaje. Jara'apá, je'echú chu i'imacare, ricaja calé a'arí najló ajñacaje. Cupira'aphana chaje Tupana huátaca icá. ");
INSERT INTO ycn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Iná huo ca'acochu nacaje nacú, uncá ra'alá iná ñaté, iná i'imacáloje richaje júpica marí eja'ahuá chu penaje. ");
INSERT INTO ycn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Naje ihuó ca'aró a'arumacaji a'ajícare inacuhuá nacú? Ihue'epí caja a'ahuaná ihuí nacojé. Uncá risápala. Uncá caja riña'alá rijluhua a'arumacaji, ra'acáloje rinacuhuá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","E'iyonaja richá'ata a'arumacaji jimáreni. Cajrú huani le'ejepelari, ne'emacánami chu, Salomonmi chu i'imacá. E'iyonaja uncá richá'atala a'ahuaná ihuí palá nojé ra'arumacá aú. ");
INSERT INTO ycn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mequetánajloje penaje calé a'ahuaná ihuí. Chuhuajá que iná amaca ricá. Muní que rimeríya'aco. E'iyonaja palá amácanami ricá Tupana palamane. A'ahuaná ihuí chaje ra'ajica rinacojó icá, a'arumacaji i'imacáloje ijló penaje. ¡Meque huejápaja huani ipechu Tupana chojé caphí! ");
INSERT INTO ycn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tupana a'arí rinacojó icá. Aú calé ihuó ca'aniyo nacaje nacú. Imaniya: “¿Na huajñaje? ¿Na hue'eraje? ¿Mérohua huephátaje huajluhua a'arumacaji?” ");
INSERT INTO ycn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Necá, uncá hue'epílaño Tupana nacojé, ricaja calé nahue'epí natucumó. Eyá Tupana hue'epiri icá, ra'acáloje ijló nacaje ila'acare nacú camu'ují penaje. ");
INSERT INTO ycn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ihue'epí itucumó pamineco Tupana huacára'aca que la'acana, rihuátaca que la'acana caje. Raú ra'ajé ijló a'ajnejí, a'arumacaji, caje macá. ");
INSERT INTO ycn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ihuó ca'aniyo nacaje nacú aquijñojo i'imajícare. Rihuacajé nacaje i'imajeri piño iná huo ca'ajona penaje. Hue'echú ca'alá queja re nacaje inajlo, uncá paala i'imacare, iná a'acáloje iná nacojó ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Imaniya ajopana ina'uqué nacú na aú ca nala'acá pu'uhuaré majopeja. Imaniya marí que Tupana quemacá piyá ñaqué caja inacu. ");
INSERT INTO ycn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ilé imacá nanacu que caja rimájica inacu. Nacaje nala'acare nacú ca'ajná pimá: “Uncá paala ricá. Pu'uhuaré nala'acá raú”. Pila'ajica ee ñaqué ricá, Tupana quemájeri caja pinacu ñaqué caja. ");
INSERT INTO ycn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Apú ca'ajná la'arí nacaje uncá quemachi paala. Raú pimá rinacú: “Pu'uhuaré la'ajeri ricá” que. Eyá picá ta, pu'uhuaré huani la'ajeri ca'ajná picá. E'iyonaja uncá pimalá pinacuhuá: “Pu'uhuaré la'ajeri nucá” que. ");
INSERT INTO ycn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pu'uhuaré huani la'ajeri pi'imacachu, ¿meque ta pimacajla apú pinaquiyánajlo: “Piyurí pu'uhuaré pila'acare piliyó” que? ");
INSERT INTO ycn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Pajlácachi huani picá ta! Piyurí pu'uhuaré pila'acare piliyó pamineco. Rejéchami pihue'epíjica méqueca apú inaquiyánajlo quemacana, riyurícaloje huejapa ñani pu'uhuaré rila'acare riliyó penaje. ");
INSERT INTO ycn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Chuhua apú nacú numá piño: Pipura'aniyo palani puráca'aloji nacú necá hua'até, uncá huani huátalaño Tupana. Apala napura'ó pu'uhuaré huani pinacu rijimaje. Iná a'acá cahuemí nojé murehua je'erúnajlo que caja ricá. Majopeja napiyácata richá te'erí aú. Que caja nala'acá iná, uncá huátalaño Tupana ja'apiyá jema'acana. ");
INSERT INTO ycn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Iquejá'a nacaje Tupana liyá. Raú ra'ajé ijló ricá. Iculá caja Tupana liyá nacaje. Raú iphátaje ricá. Imá rijló, rijme'etachi ijló nacaje apu. Raú rijme'etaje ijló rapu. ");
INSERT INTO ycn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Riliyá nacaje quejá'ajeñojlo ra'á nacaje. Riliyá culájeño iphátaño nacaje. Rijló quemájeñojlo rijme'etá rapu. ");
INSERT INTO ycn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Uncá na calé a'arí ri'irijlo jipa, riquejá'acachu riliyá cujnú. ");
INSERT INTO ycn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Uncá caja na calé a'arí ri'irijlo jeí, riquejá'acachu riliyá jiña. ");
INSERT INTO ycn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Icá, pu'uhuaré la'ajeño, hue'epiño iyánijlo nacaje a'acana palani. A'acá iyánijlo nacaje, chaje Tupana a'acá quejá'año riliyajlo nacaje palani. ");
INSERT INTO ycn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ila'á marí que: Ila'á palá ajopana ina'uqué, ihuátaca nala'acá icá que caja. Tupana puráca'alo, Moisesmi chu, ripuráca'alo ja'apátajeñomi chuna, quele lana'acare i'imacá, huacára'ari iná la'acá ñaqué caja. ");
INSERT INTO ycn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Iñe'epú naquiyá iyamá eyá iñe'epú hua'aró. Apú camu'ujuni ñani. Apú chi'itaje. Ilé chi'itaje iñe'epú i'ijnari capichácajo ejo. Malaca'aphénaru richuhuá i'ijnacana. Cajrú ina'uqué hua'añó richuhuá, ne'ejnacáloje richuhuá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Eyá apú camu'ujuni ñani i'ijnari matajnaco iná i'imacá ejo. Ricá chuhuá ihua'ó. Camu'ujuni rapunumacana. Huejápaja ina'uqué iphátaño ricá, ne'ejnacáloje richuhuá penaje. Calaca'apheni richuhuá i'ijnacana. ");
INSERT INTO ycn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Re pajlácachina. Nemá nanacuhuá: “Tupana puráca'alo ja'apátajeño huecá” que. A'aniya inacojó napuráca'alo. Namácana aú iná pechu i'imá nanacu: “Palájne'equena japi necá” que. E'iyonaja uncá huani ñaqué calé necá. Chapú péchuruna huani ta necá. ");
INSERT INTO ycn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Richa aú iná hue'epí mecajeca a'ahuaná palani, mecajeca pu'uhuareni. Ñaqué caja iná hue'epica mecajenaca necá nacaje nala'acare aú. Uncá meño'ojó lucú arúca'ala cajmú icha penaje. Uncá caja cucuná arúca'ala pipirí icha penaje. ");
INSERT INTO ycn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Palani a'ahuaná arúca'ari caja palani richa. Pu'uhuareni a'ahuaná arúca'ari caja pu'uhuareni richa. ");
INSERT INTO ycn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Uncá meño'ojó palani a'ahuaná arúca'ala pu'uhuaré a'ahuaná icha que caja. Uncá meño'ojó pu'uhuareni a'ahuaná arúca'ala palani a'ahuaná icha que caja. ");
INSERT INTO ycn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Iná i'icacá paijí iná mená e'iyayá, uncá arúca'alare palani richa, iná ca'acáloje ricá quera'atani chojé penaje. ");
INSERT INTO ycn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ñaqué caja necá Tupana puráca'alo ja'apátajeño e'iyohuá. Nacaje nala'acare aú ja iná hue'epí mecajenaca necá, pajlácachina necá ca'ajná, palá péchuruna ca'ajná necá. ");
INSERT INTO ycn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ina'uqué naquiyana quemaño nunacu: “Huahuacára'ajeri ricá” que. Nanuma chiyaja calé ne'iyajena quemaño. Eyá uncá na'alá nanacojó nupuráca'alo. Marí que i'imacaño uncá i'ijnalájeño je'echú chojé. Nora'apá huátaca que la'ajeño, necaja calé i'ijnajeño rejo. ");
INSERT INTO ycn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tupana huá'ajica ina'uqué je'echú chojé huacajé, ne'iyajena quemájeño nojló: “Huahuacára'ajeri, huecá ja'apátaño piyucuna ajopánajlo. Pipechu aú calé huaca'á jiñana pechu ajopana ina'uqué e'iyayá. Pipechu aú caja huala'á cajrú nacaje uncá meño'ojó ina'uqué la'alare”, que nemájica nojló rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","E'iyonaja calé numaje najló: “Uncá nujhua'atéjena calé icá. I'ijná maáreya, pu'uhuaré la'ajeño i'imacale”. ");
INSERT INTO ycn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ina'uqué iphaño nuchaje nupuráca'alo jema'ajé. Nupuráca'alo a'ajeño nanacojó i'imajeño palá. Chuhua nu'umajica yucu, ihue'epícaloje méqueca no'opiyá jema'ajeño la'acá palá najluhua raú penaje. Capechuni la'arí riñacaré i'imacá que caja no'opiyá jema'ajeño la'acá palá nanacuhuá raú. Marí que rila'acá riñacaré i'imacá: Pamineco ritára'ata jipa naquiyá riñacaré pana, ritára'acoloje camachá penaje. Ricá nacú rila'á riñacaré i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Cajrú juni ja'acó huacajé ta'aqueni riñaaca'alá iphaca riñacaré ja'apejé. Ta'aqueni huani ra'apaca riñacaré ja'apiyá. Cajrú huani carená i'imacá. Uncá riñacaré cojno'olá raú, jipa nacú riñacaré pana tára'acole. Marí que rila'acale ricá palá, uncá ricapichalo raú. Ñaqué caja nupuráca'alo a'ajeño nanacojó la'acá nanacuhuá palá, no'opiyá jema'ajeño ne'emacale. ");
INSERT INTO ycn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Eyá ajopana piño jema'añó nupuráca'alo. E'iyonaja uncá na'alá nanacojó ricá. Uncá paala ne'emajica, uncá pachá nema'alá no'opiyá. Uncá pechu i'imalá la'acá riñacaré i'imacá que caja nala'acá chapú necó raú. Marí que rila'acá riñacaré i'imacá: Que'epé e'iyaja ritára'ata riñacaré pana. Rinácuja rila'á riñacaré. ");
INSERT INTO ycn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Cajrú juni ja'acó huacajé, ta'aqueni riñaaca'alá iphaca riñacaré ja'apejé. Cojlo'orí que'epé riñacaré pana ji'ilaya. Cajrú huani carená i'imacá. Raú riñacaré cojno'orí queee junápeje. Chapú huani ricapichaco raú. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Caja marí que Jesús jehuíña'ataca ne'emacá. Ripuráca'alo jema'ajeño pechu i'imá: “Meque palá huani rehuíña'achiyaca huecá. ");
INSERT INTO ycn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Palá rihue'epica nacaje rehuíña'atacare nacú huecá.” Tupana puráca'alo nacú jehuíña'atajeño, rehuá i'imacaño uncá hue'epílaño palá rinacojé rijlunami chojé. ");
INSERT INTO ycn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","E caja Jesús huitúca'ari yenuri i'ihuátaya. Cajrú ina'uqué i'ijnacá rápumi chu. ");
INSERT INTO ycn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","E caja pajluhuaja ina'uqué i'ijnari Jesús ahua'ajé. Ritami ri'imacá, rinapona naquiyana patáca'ataro i'imacá. Caja riphá Jesús nacú. Re ritára'o ri'irúpachi aú rijimaje; rimá rijló: —Hue'emacana, pihuátajica ee, pa'apata nuliyá nuyaripune. ");
INSERT INTO ycn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Raú Jesús sápari rinacu riyáte'ela aú. Rimá rijló: —Je. Nuhuata ra'apátacana piliyá. Caja ripali'ichó pijló chuhua. Marí que rimacá rijló, hua'até que rinapona pala'acó rijló. ");
INSERT INTO ycn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","E Jesús quemari rijló: —Pi'imaniya nuyucuna ajopánajlo. Pi'ijná sacerdote chaje, ramíchachi picá. Quéchami pa'ajé nacaje Tupánajlo, pinapona pali'ichácole. Moisesmi chu huacára'aca i'imacá que pa'ajica rijló nacaje. Marí caje aú ina'uqué hue'epéjeño caja pinapona pala'acó pijló —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","E caja Jesús i'ijnari ají que pajimila Capernaum ejo. Riqueño'ó pajimila e'iyajé iphácana. Ejéchami pajluhuaja ina'uqué iphaca rahua'ajé. Romano naquiyana ri'imacá. Surárana huacára'ajeri ri'imacá. Riphá rahua'ajé. ");
INSERT INTO ycn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Rimá rijló: —Hue'emacana, ritami huani nujhua'até sápajeri. Quehuini huani rinapona piyuque. Uncá meño'ojó ricahuitala; iqui'i huani ramaca quehuini yajhué. Nuñacaré chu ritami to'oró. ");
INSERT INTO ycn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Ñaqué ricá —que Jesús quemacá—. Nu'ujichaca pijhua'até, nutejmo'óchiyachi pijló ricá. ");
INSERT INTO ycn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Raú surárana huacára'ajeri quemari rijló: —Hue'emacana, uncá nuhuátala pimujlúca'aca nuñacaré chojé. Nopáña'aco huani no'opihuá pijló, nuchaje huani pi'imacale. Maáreyaja pihuacára'a ritejmo'otaco. Raú ja ritejmo'otájico. ");
INSERT INTO ycn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Re caja nuhuacára'ajeño. Surárana huacára'ajeri caja nucá. Numacachu pajluhuaja nanaquiyánajlo: “Pi'ijná ají ño'ojó” que, ri'ijná rejo. Numacachu apujlo: “Majó pi'ijná” que, ri'ijná nucá ejo. Nuhuacára'acachu nujhua'até sápajeri la'acá nacaje, rila'á nacaje numacá rijló que —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Marí que rimacá rijló aú Jesús pechu i'imá: “¡Meque palá huani ripechu Tupana nacú!” E rimá rijhua'até chira'ajéñojlo: —Jema'á marí: Caphí ripechu Tupana chojé, ra'acáloje riñaté penaje. Uncá nuphátala apú Israelmi chu laquénami naquiyana e'iyayá, ricá que huani péchuri. ");
INSERT INTO ycn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Cajrú ajopana ina'uqué i'imajeño a'ajútayami chuna hua'até je'echú chu. Ajopana te'eré eyájena ne'emajica. Abrahami chu, Isaacmi chu, Jacobmi chu, quele hua'até ne'emajica je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Eyá icá, judíona, Tupana i'ihuapari rijluhua a'ajútayami chuna i'imacá, i'imacáloje Tupana hua'atéjena najhua'até penaje. E'iyonaja calé Tupana ca'ajeri cajrú inaquiyana ya'ajnaje calajeruni chojé. Re cajrú neyájica. Quehuini a'acuhuaná cajrú najma'ajica naí huá camachá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","E caja Jesús quemari piño surárana huacára'ajerijlo: —Chuhua pipa'ó. Caja pipechu i'imá caphí nochojé, nutejmo'ótachi pijló ricá. Pipechu nacú ricá queja ri'imajica pijló —que Jesús quemacá rijló. Marí que rimacá rijló. Hua'até que rijhua'até sápajeri tejmo'otaco. ");
INSERT INTO ycn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","E caja Jesús i'ijnari Pedro ñacaré ejo. Rimujlúca'a riñacaré chojé, amari Pedro yajneru to'ocó. Rutami ru'umacá jelo'ocajo nacú. ");
INSERT INTO ycn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","E risapa ruyáte'ela nacú. Raú jelo'ocajo mata'arí ruliyá. Ejéchami rócho'oco, rutamáca'atacaloje najló a'ajnejí penaje. ");
INSERT INTO ycn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","E caja najúhua'a re. E nahuá'a Jesús ejo cajrú ina'uqué. Nanaquiyana i'imaño natámina. Ajopana i'imaño re, jiñana pechu i'imacárena e'iyá ne'emacá. Pajluhua ñani ripuráca'alo aú ja calé rica'á jiñana pechu ne'iyayá. Ñaqué caja ritejmo'ótaca natámina. ");
INSERT INTO ycn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tupana puráca'alo ja'apátajerimi chu, Isaíasmi chu quemacá que rila'acá natejmo'ótacana aú. Marí que rilana'acá riyucuna i'imacá: “Ra'apátaje hualiyá huayaripune.” ");
INSERT INTO ycn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Muní que ri'ijná piño ají que a'ajná ño'ojó. Amari cajrú ina'uqué jahuacaco rinacojé. Raú rimá ra'apiyatéjenajlo, nacuhuá'acaloje ricá caesa pa'anajo pitá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","E apú i'ijnari rahua'ajé rijló quemaje. Tupana puráca'alo nacú jehuíña'atajeri ri'imacá. Rimá rijló: —Huehuíña'atajeri, nuhuata pijhua'até i'ijnacana pi'ijnajica ehuá. ");
INSERT INTO ycn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús quemari rijló: —Re camejérinajlo pucunaji, nacamátacoloje richu penaje. Cuphira'apánajlo re caja nañacaré najló. Eyá nojló, uncá pucunaji i'imalá, nuhuatána'acaloje richu penaje. Ina'uquéjloje penaje i'imacá nucá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","E apú ra'apiyateje quemari rijló: —Huahuacára'ajeri, piyurí nupa'acó nuñacaré ejo pamineco. Nuhuata nora'apá tami sa'acana ritaca'ajica ejomi —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús quemari rijló: —Pi'ijná nujhua'até. Uncá hue'epílaño Tupana nacojé, necá sa'ajeño caja taca'acaño tami. —Je —que. ");
INSERT INTO ycn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","E caja Jesús huitúca'ari jita chojé ra'apiyatéjena hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nacuhuá'aca quetana Jesús i'imari camátacajo nacú. Ejéchami mana'í chiyó carená i'imacá nachá caphí huani. Carená yocola amo'oró jita chojé cajrú juni. ");
INSERT INTO ycn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ejéchami napótaca Jesús. Nemá rijló: —¡Huehuíña'atajeri, pihue'epí huamu'ují! Chuhuaca huejaca. ");
INSERT INTO ycn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aú Jesús quemari najló: ¿Naje cajrú iquero'ocó? Uncá caphí péchuruna calé icá nochojé. E rácho'o. Raca'á carená, juni hua'até. Raú carená mata'aró, juni piya hua'até. Mana'í huani ri'imacá rejomi. ");
INSERT INTO ycn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Marí caje aú ra'apiyatéjena pechu i'imá: “¡Meque piyuque huani rihue'epica!” Nemá pajlocaca: —¿Na huani chi ricá? Ripuráca'alo aú carená, juni hua'até jema'arí ra'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","E caja nephá pa'anajo pitá, Gerasa te'eré ejo. Amaño iyamá ina'uqué huaíchaca juca ya'ajnajo. Támijimina ca'aquelana chiyá nephá. Jiñana pechu i'imaño ne'iyá. Raú ne'emá yuriná huani. Uncá na calé ja'apáqueri rehuá, chapú nala'ajica ina'uqué. ");
INSERT INTO ycn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Caja nephá nanacu. Cajrú nahuíyo'oca. Nemá Jesusjlo: —¿Naje picahuíla'a huanacu? Jesús, Tupana I'irí picá. ¿E chi pila'ajica huecá chapú, uncá chiyó riphá rená chojé huajló? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A'ajnare que cajrú je'eruna piracana chira'acó na'ajnehuá culacana nacú. ");
INSERT INTO ycn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Raú mahuó jiñana pechu la'acá ricá. Nemá Jesusjlo: —Pica'ajica ee huecá, pihuacára'a huecá a'ajnáruna je'eruna e'iyajé. ");
INSERT INTO ycn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Je —que Jesús quemacá najló. Raú jiñana pechu jácho'oño ileruna ina'uqué e'iyayá. Mujlúca'año je'eruna piracana e'iyajé. Raú je'eruna jecho'oñó ají que a'ajná ño'ojó. Yenuri ji'ihuátaya na'ó caesa acojé. Rejeja je'eruna capichaño piyuqueja junápeje. ");
INSERT INTO ycn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Marí que nala'acá aú nalamára'ajeño penájenami quero'oñó cajrú. Aú necho'ó pajimila ejo riyucuna i'imajé najló. Nephá rejo. E ne'emá najló Jesús ca'acá jiñana pechu yucuna. ");
INSERT INTO ycn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","E caja piyuque pajimila e i'imacaño i'ijnaño rejo ramaje. Nephá rinacu. E nemá Jesusjlo: —Chuhua pácho'o huate'eré eyá. —Je. ");
INSERT INTO ycn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","E caja Jesús huitúca'ari jita chojé. Nacuhuá'a pa'anajo pitá riñacajela ejo. Nephá rejo. ");
INSERT INTO ycn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","E nahuá'a Jesús ejo pajluhuaja ina'uqué. Camachá rinapona taca'acá i'imacá. Cama caje chu rito'ó. Nahuá'a ricá riloco'opani. Jesús hue'epiri caphí napechu i'imacá richojé, ritejmo'ótacaloje ricá penaje. Raú rimá rijló: —Pipechu i'imá caphí. Caja nomicho pichaje, pu'uhuaré pila'acare liyá. ");
INSERT INTO ycn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tupana puráca'alo nacú jehuíña'atajeño naquiyana i'imaño re caja. Marí que rimacá aú napechu i'imá: “¡Meque pu'uhuaré huani ta rimíchaca ta! Tupánaja calé amaro ina'uqué chaje pu'uhuaré nala'acare liyá. Uncá Tupana calé ricá.” ");
INSERT INTO ycn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús hue'epiri méqueca napechu i'imacá rinacu. E rimá najló: —¿Naje i'ijnataca ipéchuhua ilé que? ");
INSERT INTO ycn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Majopeja iná quemacajla apujlo: “Caja nomicho pichaje, pu'uhuaré pila'acare liyá.” Eyá puhuichani inajlo ricá, iná huacára'acaloje ritami jácho'oco, ra'apácaloje penaje. Tupánaja calé hue'epiri natámina tejmo'ótacana. ");
INSERT INTO ycn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ina'uquéjloje penaje i'imacá nucá. Tupana quemari nunacu, nomácoloje ina'uqué chaje, pu'uhuaré nala'acare liyá penaje. Nula'ajícare aú me'etení, ihue'epeje ñaqué jo'ó nojló ricá —que rimacá najló. E rimá camachá napona taca'acajlo: —Pácho'o. Pijña'á picamané ñani pijhua'ató, pipa'achó. ");
INSERT INTO ycn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ejéchami pila pila que rácho'oco. Ripa'ó riñacaré ejo. ");
INSERT INTO ycn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Namá ra'apaca. Aú naquero'ó. Palá napura'acó Tupana nacú, ra'acale Jesús ñaté, ritejmo'ótacaloje natámina penaje. ");
INSERT INTO ycn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","E caja Jesús ja'apari piño a'ajná ño'ojó. Amari pajluhuaja ina'uqué yá'aco risápaca'alo la'acana nacú. Mateo rií. Liñeru ña'ajeri ina'uqué liyá ri'imacá ne'emacánajlo. Jesús amari ricá; rimá rijló: —Pi'ijná nujhua'até. —Je —que rimacá. Raú rácho'o, ri'ijná rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Quéchami Mateo ñacaré chu Jesús ajñari ra'ajnehuá cajrú ajopana ina'uqué hua'até. Cajrú liñeru ña'ajeño ne'emacánajlo yá'año caja rijhua'até. Ajopana, nemacárena nacú: “Uncá ina'uquélaruna necá” que, necá i'imaño caja re. Ra'apiyatéjena i'imaño caja re. ");
INSERT INTO ycn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","E caja fariséona naquiyana amaño Jesús ajñaca ra'ajnehuá najhua'até. E nemá ra'apiyatéjenajlo: —¿Naje chi jehuíña'atajeri ajñari ra'ajnehuá najhua'até? Liñeru ña'ajeño ne'emacánajlo, uncá ina'uquélaruna, quele hua'até rajñá ra'ajnehuá. ");
INSERT INTO ycn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Jesús jema'arí méqueca nemacá najló. E rimá najló: —Uncá peyajhuéruna i'ijnalaño pusána'ajeri amaje. Natáminaja calé i'ijnaño ramaje. Ñaqué caja ina'uquejlo nucá. Re ina'uqué, natámina que necá Tupánajlo, pu'uhuaré la'ajeño ne'emacale. Ne'iyajena pechu i'imá nanacuhuá: “Pu'uhuaré la'ajeño huecá” que. Nu'ujná majó Tupana yucuna i'imajé ilé que i'imacáñojlo, napajno'otácaloje napéchuhua pu'uhuaré nala'acare liyá Tupana ejo penaje, ne'emacáloje lamára'ataquejanami que Tupánajlo raú penaje. Eyá ajopana, napechu i'imá nanacuhuá: “Palá la'ajeño huecá” que. E'iyonaja uncá ñaqué calé necá. Uncá nu'ujnalá majó marí que i'imacáñojlo Tupana yucuna i'imajé. Tupana puráca'alo lana'aquéjami naquiyana quemari marí que ajopana nacú: “Icá a'añó nojló pirajina nenócarena pu'uhuaré ina'uqué la'acare chaya. Richaje huani nuhuátaca ihue'epica ina'uqué mu'ují”, que Tupana quemacá nanacu i'imacá —que Jesús quemacá najló.— Ñaquele chuhua i'ijná, jehuíña'acoloje rinacu meque quemacánaca ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","E caja Juan bautizar la'ajeri ja'apiyatéjena iphaño Jesús nacú. Nemá rijló: —¿Naje uncá pa'apiyatéjena i'italaño na'ajné liyá? Huecá i'itañó cajrú hua'ajné liyá. Fariséona ñaqué caja. ");
INSERT INTO ycn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús quemari najló: —Nahuá'acaco huacajé, necá nayucupéra'acarena uncá i'italaño na'ajné liyá, ilé ruyajná penaje i'imacá najhua'até quetana. Ñaqué caja ricá no'opiyatéjenajlo. Najhua'até nu'umacá quetana uncá ne'etaló na'ajné liyá. Tupana huá'ajeri nucá naliyá. Rejomi ne'etajó na'ajné liyá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Uncá na calé mata'arí a'arumacaji huajé naquiyana jupichumi tepé penaje. Re'iyayá ripácana aú jupichumi jiyo'otaro huajé liyá. Caja penaje richaje huani jiyo'otáqueja jupichumi a'arumacaji yurico. ");
INSERT INTO ycn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Uncá caja iná aco'olá nacaje jalá huajé amúra'atacanami jupichumi ra'acuná chojé, iná lamá'atacaloje ricá richu penaje. Camejeri ímami naquiyá la'acanami ricá ra'acuná. Ilé que iná la'acachu, huajé amúra'atacanami huapa'atari jupichumi ra'acuná, caja ñaataco ri'imacale. Ejeja ricapichó jupichumi ra'acuná hua'até. Eyá huajé ra'acuná chojé iná aco'ocachu huajé nacaje jalá amúra'atacanami, uncá rijiyo'otala ricá, camejeri ímami ñaacole rijhua'até —que Jesús i'imacá najló yucu. ");
INSERT INTO ycn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús i'imari najló yucu ejé apú iphari rinacu. Judíona huacára'ajeño naquiyana ri'imacá. Riphá Jesús nacú. E rijláma'o ri'imá nacojé. Rimá rijló: —Huajé nutu taqui'ichaca. Pi'ijná nujhua'até nuñacaré ejo, pito'ochíyachi piyáte'ela runacojé, ruhuajácaloje rupéchuhua raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","—Je —que rimacá rijló. E ri'ijná rijhua'até. Ra'apiyatéjena i'ijnaño caja rijhua'até. Cajrú ina'uqué ja'apaño caja najhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Eyá apa'ahuelo ja'apayo caja najhua'até. Rutami ru'umacá. Jirá ja'apáqueri runaquiyá i'imajica. Caja iyamá iphata ji'imaji nacojé quele jarechí ru'umacá rutami rinacu. Rupechu i'imá: “Nusápajica ee ra'arumacá nacojé, nutejmo'otájico raú.” Aú ro'opá Jesús ápumi chu. Rusapa ra'arumacá ji'imá nacú. ");
INSERT INTO ycn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ejéchami Jesús pajno'ocó ruchaje yacá'ajo; amari ilerú inanaru. Rimá rojló: —Pipechu i'imá palá. Chuhua pitejmo'otájico, pipechu i'imacale caphí nochojé —que rimacá rojló. Raú ja rutejmo'otó. ");
INSERT INTO ycn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","E caja ri'ijná ají que a'ajná ño'ojó. Iphari nahuacára'ajeri ñacaré ejo. Amari cajrú ina'uqué i'imacá re. Quehuirí caje chojé apho'ojeño i'imaño caja re. Támijimi sa'acana yale napho'ó quehuirí caje chojé. Re caja cajrú nahuinano la'ajeño i'imaño re. Cajrú namejé i'imacá; cajrú nala'acá nahuinano rucá. ");
INSERT INTO ycn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","E caja Jesús quemari najló: —I'ijná a'ajná ño'ojó. Uncá ilerú yuhualó taca'alacha. Rucamáchiyacoja calé. Ne'echacá rinacu raú, nahue'epícale caja rutaca'acá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","E'iyonaja Jesús huacára'ari namujlúca'aca pají chiyá a'ajná ño'ojó. Quéchami rimujlúca'a támijimi i'imacare chu ucapú chojé. Ripatá rucá ruyáte'ela naquiyá. Raú rócho'o yá'ajo. ");
INSERT INTO ycn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Marí que rimacápo'oca ru'umacá. Ejomi cajrú huani riyucuna moto'ocá nate'eré ehuá. ");
INSERT INTO ycn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","E caja Jesús ja'apari a'ajná ño'ojó. E iyamá mejluruna i'ijnaño rápumi chu. Jahuíyo'oqueja nemáca rijló: —Picá Tupana huacára'acare majó ina'uqué i'imatájeri penaje, pihue'epí huamu'ují. ");
INSERT INTO ycn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","E caja Jesús mujlúca'ari pají chojé; necá rápumi chu. E Jesús quemari najló. —¿E chi ipechu caphí nochojé, no'opátacaloje iliyá mejlucaji penaje? —A'a, Hue'emacana —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","E Jesús sapari nejlú nacú. Rimá najló: —Ipechu i'imacá nochojé caphí loco'opáneje ri'imajé ijló. ");
INSERT INTO ycn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eja mejlucaji ja'apari naliyá, palá namaca. E Jesús quemari najló: —¡Pa! I'imaniya riyucuna ajopánajlo. ");
INSERT INTO ycn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Raú napa'ó. Palá Jesús la'acare necá yucuna ne'emá cajrú ina'uquejlo nañacajela ehuá. ");
INSERT INTO ycn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Caja mejluruna i'imacaño penájenami pa'añó. Nayámijo ajopana piño iphaño Jesús nacú. Nahuá'a najhua'ató apú; jiñá pechu i'imari re'iyá. Nacojé uncá meño'ojó ripura'aló. ");
INSERT INTO ycn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús ca'arí jiñá pechu re'iyayá. Ejomi palá ripura'acó. Piyuque ramájeño quemaño: “Meque piyuque huani la'acá Jesús. Uncá huani huamala apú la'acá ñaqué maare huate'eré nacú, Israelmi chu laquénami te'eré nacú.” ");
INSERT INTO ycn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Palá napura'acó rinacu. E'iyonaja ajopana, fariséona ne'emacá, quemaño najló: —Jiñana huacára'ajeri calé a'arí ilé Jesús ñaté, rica'acáloje jiñana pechu ina'uqué e'iyayá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús i'ijnaqueri apú pajimila, apú pajimila eyá que, rehuíña'atacaloje necá Tupana nacú penaje. Rehuíña'ataque necá nahuacáca'alo ñacarelana chu. Ri'imaqué Tupana i'imataca ina'uqué capichácajo liyá yucuna najló, ne'emacáloje rijhua'atéjena naquiyana ra'apiyá jema'acana aú penaje. Yucu ri'imaqué najló; hua'ató ritejmo'ótaque natámina piyuqueja nayaripune liyá. Quehuini yajhué amájeño ne'emajica; que'iyapé nayaripune i'imajica. Cajena necá ritejmo'ótaque. ");
INSERT INTO ycn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesús amaca aú cajrú huani ina'uqué rihue'epí namu'ují. Ujhuí péchuruna ne'emacá. Chapú caje yajhué amájeño caja ne'emacá. Ohuéjana, necó i'imacaño queja ne'emacá. Uncá namájeri i'imalá queja ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aú calé rimá ra'apiyatéjenajlo marí que: —Jema'á marí: Re cajrú ina'uqué marí eja'ahuá chu, nema'ájla Tupana ja'apiyá, ajopana i'imaquela najló riyucuna. E'iyonaja uncá riyucuna i'imajeño i'imalá. ");
INSERT INTO ycn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Re necá huejápaja. Ipura'ó Tupana hua'até, rihuacára'acaloje ina'uqué riyucuna i'imajé ajopana, ajopánajlo que penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","E caja Jesús quemari ra'apiyatéjenajlo, nahuacácoloje richaje penaje. Iyamá iphata ji'imaji nacojé quele ne'emacá. E nahuacó rinacojé. E ra'á najló Ripechu, naca'acáloje jiñana pechu ina'uqué e'iyayá raú penaje. Ra'á caja najló Ripechu, natejmo'ótacaloje natámina que'iyapé nayaripune liyá penaje. Natejmo'ótacaloje quehuini yajhué amájeño penaje ra'á najló Ripechu. ");
INSERT INTO ycn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iyamá iphata ji'imaji nacojé quele rihuacára'acarena i'imacá. Marí quele ne'emacá: Simón. Apú rií Pedro. Andrés apú. Simón e'ehué ri'imacá. Santiago, re'ehué Juan hua'até. Zebedeo yaní ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ajopana piño: Felipe, Bartolomé, Tomás, Mateo, liñeru ña'ajeri ne'emacánajlo penájemi ri'imacá. Apú piño Santiago. Alfeo i'irí ricá. Apú Tadeo. ");
INSERT INTO ycn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón apú. Celote naquiyana ri'imacá. Caja penaje Judas Iscariote. Nenoca Jesús i'imacá huacajé, ricá huá'ari ripinana Jesús i'imacá ejo, napatacáloje ricá penaje. Marí quele ne'emacá ri'ihuapacárena rijluhua ne'iyayá, ne'emacáloje ra'apiyatéjena penaje. ");
INSERT INTO ycn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","E caja Jesús huacára'ari ra'apiyatéjena marí que: —I'ijnaniya ajopana te'eré ejo, uncá judíona calé te'eré ejo. I'ijnaniya caja pajimila ejo, Samaria te'eré nacú i'imacare. ");
INSERT INTO ycn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","I'ijná Israelmi chu laquénami chájeja calé. Capichájeño necá Tupana liyá me'etení. ");
INSERT INTO ycn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yehuicha Tupana i'imajica ina'uqué naquiyana huacára'ajeri. Riyucuna i'imá najló. ");
INSERT INTO ycn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Itejmo'óta caja natámina; imacápo'ota caja ina'uqué caja taca'acaño naquiyana; ipala'atá caja nanapona patáca'ataco najló; ica'á caja jiñana pechu ina'uqué e'iyayá. Marí que ila'ajica nupechu aú. Majopeja no'ocá ijló ricá, uncá rihuemí i'imalá. Ñaqué caja ila'ajica ina'uquejlo nacaje. Imaniya najló, na'acáloje ijló rihuemí penaje. ");
INSERT INTO ycn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ijña'aniya caja ijhua'ató liñeru. ");
INSERT INTO ycn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ijña'aniya caja ijhua'ató itulané. Pajluhuaja a'arumacá chuja i'ijnajica. Ijña'aniya caja ijhua'ató ji'ima'ulaji, icutihuare caje. Icá la'ajeño najló nacaje, huemí na'ajé ijló a'ajnejí. ");
INSERT INTO ycn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Iphájica ee pajimila ejo, iculaje palá péchuri ina'uqué ijluhua, iyurícoloje rijhua'até riñacaré chu penaje. Iyuró rijhua'ateja riñacaré chu re i'imajica quetana. ");
INSERT INTO ycn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pají chojé mujlúca'acana aú ajalaca necá. Imá Tupánajlo, rila'acáloje napechu palá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Palá péchuruna ne'emajica ee, imá Tupánajlo caja queja ri'imacáloje najló penaje. Uncá paala péchuruna ne'emajica ee, imá Tupánajlo ra'acá piyá nañaté. ");
INSERT INTO ycn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Uncaque pají chujena ca'ajná, pajimila eruna ca'ajná, huátaño ipuráca'alo jema'acana, iñaca'á ji'ima'ulá naquiyá mu'upé najimaje. Marí que ila'ajica ja'apájica reyá huacajé. Nahue'epícaloje pu'uhuaré la'ajéñoca necá raú, uncale nahuátala ipuráca'alo a'acana nanacojó. ");
INSERT INTO ycn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tupana huajájica pu'uhuaré la'ajeño, namanaicho la'ajeño huacajé, cajrú rihuajájica necá, uncá huátalaño icá. Pajimila Sodoma erúnami chuna, pajimila Gomorra erúnami chuna, quele rihuajaje caphí huani, pu'uhuaré la'ajeño huani ne'emacale. Nachaje íqui'ica rihuajájica necá, uncá huátalaño icá. Marí que Jesús huacára'aca ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","E caja Jesús quemari piño marí que najló: —Jema'á marí. Mayuchéruna icá. E'iyonaja nuhuacára'a icá chapú péchuruna ejo. Ñaquele i'imá capéchuruna i'imacá que najhua'até. Mana'íja ila'acá ipéchuhua najhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ihue'epínota marí que ri'imajica no'opiyá jema'ajéñojlo: Nemaje inacu: “Pu'uhuaré la'ajeño necá” que. Raú najña'ajica icá ihuacára'ajeño ejo. Jahuacáca'alo ñacarelana chu naña'atájica icá. ");
INSERT INTO ycn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ya'ajná ajopana chaje huacára'ajeño ejé caja najña'ajé icá, nahuajácaloje icá re penaje. No'opiyá jema'ajeño i'imacá pachá, nahuajaje icá rejo. Palani ijló marí, i'imacáloje najló nuyucuna rejo penaje. Najló, uncá judíona calé i'imacáñojlo hua'até caja i'imajé nuyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Najña'ajica ee icá ihuacára'ajeño ejo, nahuajácaloje icá penaje, ihuó la'aniyo méqueca imájica najló ja'apí. Riphájicaja rená chojé ijló, ipura'acóloje ichayo penaje, Tupana quemájeri ijló méqueca imájica najló. ");
INSERT INTO ycn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Uncá ipechu queja calé imájica najló. Jara'apá Pechu, Tupana Pechu aú imaje najló. ");
INSERT INTO ycn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ne'iyajena a'ajeño nejena huani ajopánajlo, nenócaloje necá penaje, no'opiyá jema'ajeño ne'emacale. Ne'iyajena caja a'ajeño nayani ajopánajlo. Ne'iyajena caja a'ajeño nachi'iná ajopánajlo, nenócaloje necá penaje. Marí que nala'ajica necá, no'opiyá jema'ajeño ne'emacale. ");
INSERT INTO ycn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Cajrú ina'uqué pechu i'imajica chapú inacu, no'opiyá jema'ajeño i'imacale. Uncá jácho'olaño no'opiyá jema'acana chiyá caja penaje ri'imajica ejená, uncá capichálajeño. ");
INSERT INTO ycn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Apala pajimila e icá i'imajeño. Nala'ajica ee chapú icá re, iñaajó reyá apú pajimila ejo, i'imacáloje nuyucuna caja najló rejo penaje. Itajátaca piyá piyuqueja pajimila Israelmi chu laquénami te'eré ehuá, nucá iphájeri majó. Ina'uquéjloje penaje i'imacá nucá, pa'ajero piño majó. ");
INSERT INTO ycn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Apú ina'uqué ja'apiyateje, uncá rehuíña'atajeri chaje calé ricá. Apú hua'até sápajeri, uncá ricarihuate chaje calé ricá. ");
INSERT INTO ycn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ajopana pechu i'imacá nehuíña'atajeri nacú, que caja napechu i'imacá ra'apiyá jehuíña'ajeño nacú. Ajopana pechu i'imacá nacarihuate nacú, que caja napechu i'imacá rijhua'até sápajeño nacú. Jehuíña'atajeri nucá; Ihuacára'ajeri caja nucá. Nunacu nemá: “Jiñana huacára'ajeri ricá” que. Ñaqué caja nemájica pu'uhuaré inacu, nujhua'atéjena i'imacale. ");
INSERT INTO ycn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Ihuó la'aniyo ajopana ina'uqué ja'apejé. Me'echuje pu'uhuaré nala'acare me'etení. Piyuque nacaje ina'uqué la'acare me'echú, amájero ajopánajlo. ");
INSERT INTO ycn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nacaje numacare nacú ijló huecámica que, i'imá riyucuna pu'uhuacá cajrú ina'uquejlo. ");
INSERT INTO ycn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Iquero'oniyo ina'uqué nójeño piyá. Iná napónaja calé nenó. Eyá iná pechu uncá capichálajo raú. Tupana hue'epiri iná napona capichátacana. Rihue'epí caja iná ca'acana quera'atani uncá yacálare chojé. Ñaquele iquero'ó ripiyá. ");
INSERT INTO ycn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Iná huarúhua'a iyamá cupira'aphana mahuemiru huani maárohua. Mahuemíruna necá. E'iyonaja Jara'apá Tupana hue'epiri méquechamica nataca'ajica. ");
INSERT INTO ycn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Cajrú cupira'aphana chaje huani íqui'ica rihuátaca icá. Tupana hue'epiri piyuqueja. Rihue'epí caja méqueleca iná ihuilá i'imacá. Ra'á caja rinacojó iná. Ñaquele iquero'oniyo ajopana ina'uqué piyá. ");
INSERT INTO ycn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Re ca'ajná apú nujhua'ateje. Uncá rapáña'alo no'opí ajopana ina'uqué e'iyá. Rimá najló nunacu: “Rijhua'ateje nucá” que. Ñaqué caja numájica rinacu Nora'apá, je'echú chu i'imacárejlo. Numaje rijló: “Nujhua'ateje ricá” que. Marí que caja numájica rijló piyuque ina'uqué nacú, uncá micho'otálaño nuchaya ajopana ina'uqué e'iyá. ");
INSERT INTO ycn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","’Eyá apú nujhua'ateje ca'ajná apáña'aro no'opí ajopana ina'uqué e'iyá. Aú calé rimá najló nunacu: “Uncá rijhua'ateje calé nucá”. Ñaqué caja numájica rinacu Nora'apajlo, je'echú chu i'imacárejlo. Numaje rijló rinacu: “Uncá nujhua'ateje calé ricá”. Marí que caja numájica rijló piyuque ina'uqué nacú, micho'otaño nuchaya ajopana ina'uqué e'iyá. ");
INSERT INTO ycn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Apala ipechu i'imá nunacu: “Ricá la'ajeri ina'uqué palá, nayúcha'aco piyá pachácaca”. Ipechu i'imaniya ilé que. Uncá ilé que calé ri'imajica ina'uquejlo. Nupuráca'alo a'acana nanacojó jimaje chapú napechu i'imajica no'opiyá jema'ajeño nacú. ");
INSERT INTO ycn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Apala nupuráca'alo jimaje apú yúcha'aro rara'apajlo. Apala nupuráca'alo jimaje apa'ahuelo yúcha'ajeyo rolojlo. Apala nupuráca'alo jimaje ru'urinó yúcha'ajeyo ruyajnérujlo. ");
INSERT INTO ycn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Marí que ca'ajná ina'uqué i'imajica pajhua'atéchaca nejena hua'até nupuráca'alo jimaje. Iná ejena naquiyana i'imajeño chapú péchuruna iná nacú. ");
INSERT INTO ycn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Huátari rara'apá ca'ajná, raló ca'ajná, nuchaje íqui'ica, uncá na penaje calé nojló ricá, ri'imacáloje nujhua'ateje penaje. Huátari ri'irí ca'ajná, ritu ca'ajná nuchaje, uncá na penaje calé nojló ricá, ri'imacáloje nujhua'ateje penaje. ");
INSERT INTO ycn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Apala nenoje nujhua'atéjena naquiyana. Ihue'epíjica ee inacuhuá, uncá meño'ojó i'imalá nujhua'atéjena. ");
INSERT INTO ycn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Re ina'uqué, nahue'epí caí nanacuhuá. Nahuata pajimato ina'uqué pechu i'imacá palá nanacu. Caí nanacuhuá hue'epícaño ne'emacale, uncá nahuátala nujhua'atéjena i'imacana. Marí que hue'epícaño caí nanacuhuá capichájico Tupana liyá. Eyá ajopana, uncá hue'epílaño caí nanacuhuá ilé que, ne'emacáloje nujhua'atéjena penaje, i'imajeño matajnaco je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Palá péchuruna no'opiyá jema'ajeño nacú, palá caja napechu nunacu. Huátari nucá, huátari caja Tupana, huacára'ari nucá majó. ");
INSERT INTO ycn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ila'acachu nacaje apujlo, Tupana puráca'alo ja'apátajeri ri'imacale, palá ila'acá raú. Tupana a'ajica rijló palá rila'acare huemí, que caja ra'ajica ijló rihuemí. Ila'acachu nacaje apujlo, palá la'ajeri ri'imacale, palá ila'acá raú. Tupana a'ajica rijló palá rila'acare huemí, que caja ra'ajica ijló rihuemí. ");
INSERT INTO ycn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Apala apú la'arí apú palá, no'opiyá jema'ajeri naquiyana ri'imacale. Ra'á ca'ajná rijló juni ipe'ení, ri'iracáloje penaje. Marí que rila'acale ricá palá, Tupana a'ajeri rijló rihuemí. Marí que Jesús jehuíña'ataca ra'apiyatéjena i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús yuriri ra'apiyatéjena jehuíña'atacana nacú i'imacá. Iyamá iphata ji'imaji nacojé quele ne'emacá. Ejomi ri'ijná piño apú, apú eyá que rehuá i'imacaño jehuíña'atacana nacú. Tupana yucuna i'imacana nacú ri'imá rehuá. ");
INSERT INTO ycn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Caja naca'á Juan ina'uqué huajáquelana chojé i'imacá. E caja rema'á piyuque nacaje Jesús la'acare yucuna. Raú rihuacára'a ra'apiyatéjena naquiyana Jesús chaje, naquejá'acaloje riliyá riyucuna penaje, rihue'epícaloje ricá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","E nephá rinacu, nemá rijló: —Huahuacára'ajeri quemari pinacu: ¿Picá huani chi picá nemacare nacú i'imacá, iphájeri majó ina'uqué i'imatájeri penaje? Apú ca'ajná huaícha. ¿Meque chi ricá? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús quemari najló: —Ipa'ó Juan ejo, i'imichachi rijló riyucuna méqueca amíchaca nula'acá huajé. Nacaje nohuíña'atacare nacú yucuna hua'ató i'imajé caja rijló. ");
INSERT INTO ycn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Eco imá rijló marí que nunacu: “Mejluruna liyá ra'apata mejlucaji, namácaloje penaje. Uncá meño'ojó ja'apálaño rilamá'ata, na'apácaloje penaje. Nanapona patáca'atacaronajlo ripala'atá nanapona najló. Uncá jema'alaño liyá ra'apata caja me'ejhuícaje, nema'acáloje penaje. Támijimina naquiyana rimacápo'o caja. Tupana i'imataca ina'uqué capichácajo liyá yucuna ri'imá camu'ují la'acáñojlo. Marí que la'acana nacú ricá”, que imájica rijló nunacu. ");
INSERT INTO ycn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","“Pu'ují péchuruna necá, uncá la'alaño ujhuí napéchuhua nuliyá”, que imájica rijló —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Je. E napa'ó. Ejomi Jesús i'imari ripuráca'alo jema'ajéñojlo Juan yucuna. Rimá najló marí que: —Icá i'ijnaño pu'uteni meñaru chojé i'imacá Juan puráca'alo jema'ajé. Uncá ca'ajná i'ijnalá rejo i'imacá iyamá chuhuá péchuri chaje. Uncá iyamá chuhuá péchuri calé ricá. ");
INSERT INTO ycn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Uncá caja i'ijnalá ra'arumacá palani amaje. Uncá palá a'arumacaji i'imacare nacú calé ricá. Icá hue'epiño mecajenaca i'imaño palá a'arumacáruna. Nahuacára'ajeño ñacaré chiyájena necá. ");
INSERT INTO ycn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Apala ipechu i'imá rinacu: “Tupana puráca'alo ja'apátajeri ricá” que. Ricá jo'ó ri'imacá. Ajopana Tupana puráca'alo ja'apátajeñomi chuna chaje huani ricá. ");
INSERT INTO ycn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ricá nacú Tupana quemari nojló i'imacá. Marí que ripuráca'alo ja'apátajerimi chu lana'acá riyucuna i'imacá: Nucá huacára'ajeri pajluhuaja ina'uqué pitucumá. Ricá quemájeri ina'uquejlo pipé, nalamá'atacaloje napéchuhua pu'uhuaré nala'acare liyá penaje, que Tupana quemacá Juan nacú, uncá chiyó ri'imá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Jema'á marí: Uncá na i'imalá Juan chaje, i'imacá marí eja'ahuá chu huayámajo. Eyá je'echú chu uncá ñaqué calé ricá. Na'apejé i'imacá je'echú chu, i'imari Juan chaje. Je'echú churuna huacára'ajeri Tupana. ");
INSERT INTO ycn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Juan queño'ocá Tupana yucuna i'imacana eyá maárejecha, huechi cajrú ina'uqué huátaca Tupana hua'atéjena i'imacana. Napechu ejé nala'acá, ne'emacáloje rijhua'atéjena penaje. ");
INSERT INTO ycn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tupana puráca'alo ja'apátajeñomi chuna, Moisesmi chu, quele lana'añó ripuráca'alo papera chojé i'imacá. Ripuráca'alo lana'aquéjami quemari marí que Tupana nacú: “Ricá i'imajeri ina'uqué huacára'ajeri penaje”. Marí que nemacá rinacu uncá chiyó Juan i'imá. ");
INSERT INTO ycn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tupana puráca'alo quemari Elíasmi chu nacú: “Ricá pa'ajero piño majó. Tupana i'imajica ina'uqué huacára'ajeri penaje yámona riphaje”, que rimacá rinacu. Elías, quele rimacare nacú i'imacá, iphari majó. Juan, ricá po rimacare nacú, Elías que i'imacá, quele iphari majó. Apala ipechu i'imá: “Uncá ñaqué calé ricá”. E'iyonaja jema'á no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Icá que'ejhuirúnajlo numá, a'á inacojó ricá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","E rimá piño najló: —Ina'uqué i'imacaño me'etení, marí que necá: Yuhuaná queja necá. Yá'año le'ejepelaji ñacarelana chu cátacajo nacú necá. E nahuá'a ajopana najhuáque'enajlo. ");
INSERT INTO ycn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nemá najló: “Huapho'ó quehuirí chojé ijló. E'iyonaja uncá arápa'ala. Huataní caja ijló yáleje, ipechu la'acóloje camu'ují raú penaje. E'iyonaja uncá ipechu la'aló camu'ují raú. Uncá caja iyala raú”, que nemacá najló. Ñaqué caja ina'uqué naquiyana me'etení, majopeja aca'acá huamaná. Cayucújne'equena huani icá. ");
INSERT INTO ycn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","’Pamineco Juan i'imacá ijló Tupana yucuna. Ri'itajico ra'ajné liyá, ripechu i'imacáloje Tupana nacuja penaje. Uncá caja ri'iraqué nacaje jalá amúra'atacanami. E'iyonaja ricá nacú imá: “Jiñá pechu hua'ateje ricá” que. ");
INSERT INTO ycn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Eyá nucá, ina'uquéjloje penaje i'imacá nucá. Ajopana ajñaca na'ajnehuá que caja nojñaca no'ojnehuá. Ñaqué caja nu'uracá nacaje jalá amúra'atacanami. Nunacu imá: “Cahuale'equé ricá, i'iracachi huani caja ricá. Uncá ina'uquélaruna huáque'ehue caja ricá”, que imacá nunacu. “Liñeru ña'ajeño ne'emacánajlo huáque'ehue caja ricá”, que imacá nunacu. Marí que aca'acá huamaná. E'iyonaja iná hue'epí nacaje Tupana la'acare, jácho'oro palá. ");
INSERT INTO ycn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús la'aqueri cajrú nacaje, uncá meño'ojó ina'uqué la'alare caje. Cajrú pajimila ehuá rila'aqué ricá. E'iyonaja uncá napajno'otala napéchuhua pu'uhuaré nala'acare liyá Tupana ejo. Raú raca'á pajimila eruna maná, amaño rila'acá richaje íqui'ica nacaje, uncá meño'ojó ina'uqué la'alare. Marí que rimacá nanacu: ");
INSERT INTO ycn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Chapú huani ri'imajica pajimila Corazín erúnajlo. Chapú huani caja ri'imajica pajimila Betsaida erúnajlo. Cajrú huani nula'acá Tupana Pechu aú nacaje rehuá i'imacá, uncá meño'ojó ina'uqué la'alare. E'iyonaja uncá nema'alá no'opiyá. Uncá napala'atala napéchuhua pu'uhuaré nala'acare liyá. Ñaqué caja Tupana la'aquela pajimila Tiro e, pajimila Sidón e i'imacá, napajno'otajla napéchuhua pu'uhuaré nala'acare liyá Tupana ejo. Na'ájla nanacuhuá cotari caje na'arumacá penaje. Naca'ájla caja nachó siyá pa'ilá, ina'uqué hue'epícaloje caja napajno'otaca napéchuhua pu'uhuaré nala'acare liyá Tupana ejo raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tupana huajájica pu'uhuaré la'ajeño, namanaicho la'ajeño huacajé, rihuajájica cajrú Corazín eruna, Betsaida eruna, quele. Cajrú rihuajájica pajimila Tiro erúnami chuna, Sidón erúnami chuna, quele, chapú la'ajeño ne'emacale. Richaje huani rihuajájica Corazín eruna, Betsaida eruna, quele. ");
INSERT INTO ycn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Eyá pajimila Capernaum e i'imacaño i'imaño piño marí que: Napechu i'imá nanacuhuá: “Je'echú chu i'imajícaño penájena huecá” que. E'iyonaja uncá ñaqué calé najló ri'imajica. Cahuacaje naca'ajé necá, nacapichácoloje penaje. Cajrú nula'acá Tupana Pechu aú nacaje rehuá i'imacá, uncá meño'ojó ina'uqué la'alare caje. Tupana la'aquela ñaqué caja pajimila Sodoma ehuá, ejo'ocaja pajimila i'imacajla rehuá me'etení. ");
INSERT INTO ycn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tupana huajájica pu'uhuaré la'ajeño huacajé, pajimila Sodoma erúnami chuna chaje huani rihuajájica Capernaum eruna —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Marí que Jesús pura'acó Tupana hua'até i'imacá: —Nora'apá, eja'ahuá, je'echú, caje Mináricana picá. Palá pila'acá nucá, pila'acale ina'uqué naquiyana palá. Yuhuaná pechu, queja péchuruna necá. Pila'acale napechu palá, nahue'epí quehuácaje puráca'aloji numacare nacojé. Eyá cajrú jehuíña'acañojlo, capéchurunajlo me'echuje jo'ó ricá. ");
INSERT INTO ycn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nora'apá, caja queja pihuátaca najló ricá —que rimacá Tupánajlo. ");
INSERT INTO ycn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","E rimá piño rema'ajéñojlo: —Nora'apá quemari nojló piyuqueja puráca'aloji nacú. Uncá na i'imalá hue'epiri na huánica nucá Tupana I'irí. Nora'apá, ricaja calé hue'epiri naca nucá. Uncá caja na i'imalá hue'epiri na huánica Nora'apá. Nucá, Ri'irija calé hue'epiri naca ricá. Nucaja calé i'imari nuhuátacarenajlo riyucuna, nahue'epícaloje naca ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Icó ihuátaca nacaje la'acana, ri'imacáloje palá Tupana nacú penaje. Laca'apheji ijló ricá. Caja aya'ó rinacu. Ijló numá: Iyurí ichó nojló, nu'umacáloje iñaté a'ajeri penaje, ihuatána'acaloje laca'apheji liyá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ila'á nujhua'até nacaje nuhuacára'aca icá que. Jehuíña'o caja nupuráca'alo nacú nuliyá. Uncá yurí calé nucá. Uncá caja nula'alá nocó hue'epiri que huani ijló. Marí caje aú palá ipechu i'imajica. ");
INSERT INTO ycn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nacaje nuhuátacare ila'acá nujhua'até, uncá laca'apheji calé ricá. Uncá caja aya'alajo rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Huatána'acaje huacajé Jesús ja'apari ají que iñe'epú chuhuá ra'apiyatéjena hua'até. Iñe'epú ja'apari ajopana mená e'iyohuá. Re'iyá cajrú trigo i'imacá. Quehuí me'epejí i'imacá ra'apiyatéjenajlo. Aú nachira'acó nacú najña'á huejapa trigo naquiyana. Natojro'ó nacápojo ricá, najñácaloje penaje. ");
INSERT INTO ycn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariséona naquiyana amaca aú nachíra'aca trigo naquiyana nemá Jesusjlo: —Piyacá'o. Chuhuajá huatána'acaje huacajé. E'iyonaja ajona pa'apiyatéjena sapaño. Uncá nala'alá Moisesmi chu puráca'alomi quemacá que. ");
INSERT INTO ycn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","E Jesús quemari najló: —Icá hue'epiño méqueca Tupana puráca'alo lana'aquéjami quemacá Davidmi chu nacú. Quehuí rijló me'epejí i'imacá. Ñaqué caja me'epejí i'imacá quehuí rijhua'até chira'acáñojlo. ");
INSERT INTO ycn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A'acuhuaná namujlúca'a Tupana ñacaré chojé. Najñá pan, Tupánajlo a'acanami ri'imacá. Najñá ricá, uncá nayurila ajopana ajñaca ricá. E'iyonaja najñá ricá. Necaja calé, sacerdótena, ajñaño ricá. ");
INSERT INTO ycn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ihue'epí caja méqueca Tupana puráca'alo, Moisesmi chu lana'acare, quemacá sacerdótena nacú. Rimá nanacu: “Uncá nahuatána'alaje huatána'acaje huacajé. Rihuacajé nala'á nasápaca'ala Tupana ñacaré chu. E'iyonaja calé uncá nala'alá pu'uhuaré raú”, que rimacá nanacu. ");
INSERT INTO ycn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ñaquele numá ijló: Re apú maare, Tupana ñacaré chaje ricá. ");
INSERT INTO ycn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Marí que piño Tupana puráca'alo lana'aquéjami quemacá: “Icá a'añó nojló pirajina nenócarena pu'uhuaré ila'acare chaya. Richaje huani ila'acá nuhuátacare caje, ina'uqué mu'ují hue'epícana aú”, que Tupana quemacá i'imacá. Uncá caja ihue'epila meque quemacánaca ricá. Ihue'epíquela meque quemacánaca ricá, uncá imalajla ajopana nacú majopeja: “Pu'uhuaré la'ajeño necá” que. Uncá la'alaño pu'uhuaré, necá nacú imá marí que. ");
INSERT INTO ycn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ina'uquéjloje penaje i'imacá nucá. Tupana quemari nunacu, numacáloje méqueca iná la'acá huatána'acaje huacajé penaje —que Jesús quemacá fariséona naquiyánajlo. ");
INSERT INTO ycn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","E caja Jesús i'ijnari ají que a'ajná ño'ojó nahuacáca'alo ñacarelana chojé. ");
INSERT INTO ycn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Re caja pajluhuaja ina'uqué i'imari najhua'até. Caja riyáte'ela a'amitaró rijló i'imacá. Re caja ajopana i'imaño. Nahuata Jesús nacú quemacana: “Pu'uhuaré la'ajeri ricá” que. Ñaquele nemá rijló: —Chuhuajá huatána'acaje huacajé. ¿E palani ca'ajná, uncá ca'ajná, riyáte'ela lamá'atacana chuhuajá huatána'acaje huacajé? ¿Meque chi Tupana puráca'alo lana'aquéjami quemacá rinacu? —que nemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús quemari najló: —Pajluhuaja ipirá ohueja i'imaquela, ja'arojla ulahuí juniphuni chojé huatána'acaje huacajé. Icá jácho'otajla ricá richiyá rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ohueja chaje íqui'ica iná huátaca ina'uqué. Aú iná la'á palá necá huatána'acaje huacajé hua'ató —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","E rimá yáte'ela a'amitarojlo: —Piya'atá nojló piyáte'ela. Riya'ataca rijló ricá aú ja ripala'ó. Palá riyurico raú, apojó pitari riyáte'ela que caja. ");
INSERT INTO ycn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Marí que rila'acale ricá huatána'acaje huacajé, fariséona hue'epiño rinacu uncá ina'uquélari que. E caja nácho'o nahuacáca'alo ñacarelana chiyá, napura'acóloje ajopana hua'até Jesús nócana nacú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús hue'epiri napura'acó rinócana nacú. Aú calé ri'ijná reyá. Cajrú ina'uqué i'ijnaño rijhua'até. Natámina ritejmo'óta piyuque. ");
INSERT INTO ycn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Rimá najló nemacá piyá ajopánajlo na huánica ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tupana puráca'alo ja'apátajerimi chu, Isaíasmi chu, i'imari riyucuna jupejé i'imacá. Rimacá que rila'acá rehuá i'imacá. Ri'imá Jesús yucuna uncá chiyó riphá eja'ahuá nacojé. Marí que Tupana quemacá rinacu: ");
INSERT INTO ycn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nojló nacaje la'ajeri ricá. Ajopana e'iyayá nu'uhuapá nujluhua ri'imacá. Iqui'ija nuhuátacare ricá. Pu'ují nupechu i'imacare nacú ricá. Rijló no'ojé Nupechu. Palá nula'acare ina'uqué nacú, ricá yucuna ri'imajé najló. Ajopana jema'ajeño caja riyucuna, uncá judíona naquiyana calé necá. ");
INSERT INTO ycn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Uncá raca'ácalajo ajopana hua'até. Uncá caja rahuíyo'olaje ina'uquejlo. Uncá mejrí calé ripuráca'alo i'imajica. ");
INSERT INTO ycn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ra'ajé chapú caje yajhué amájeño ñaté. Ra'ajé caja ujhuí péchuruna ñaté. Marí que rila'ajica, palá la'ajeño huacára'ajeri ri'imajica ejená. Ejomi uncá pu'uhuaré la'acana i'imalaje. Ejéchami palá ina'uqué i'imajica pajhua'atéchaca reyá a'ajná ño'ojó. ");
INSERT INTO ycn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Piyuque ina'uqué eja'ahuá chu i'imajícaño pechu i'imajé caphí richojé, que Isaíasmi chu lana'acá riyucuna jupejé i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nahuá'a pajluhuaja ina'uqué Jesús ejo. Mejlurú huani ri'imacá. Uncá caja ripura'aló. Jiñá pechu i'imari caja re'iyá. Nahuá'a ricá Jesús ejo. E Jesús lamá'atari ricá. Ejéchami ripura'acó palá. Ramá caja reyá a'ajná ño'ojó. ");
INSERT INTO ycn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ramájeño pechu i'imá: “¡Meque piyuque huani rila'acá!” Nemá pajlocaca: —¿Ricá chi quele jupichúnami quemacare nacú, huaícha majó ina'uqué i'imatájeri penaje? ");
INSERT INTO ycn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariséona jema'añó nemacá ilé que. Aú nemá najló: —Beelzebú, jiñana huacára'ajeri pechu aú rica'á jiñana pechu ina'uqué e'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús hue'epiri méqueca napechu i'imacá rinacu. E rimá najló: —Ajopana ina'uqué huacára'ajeri hua'atéjena nócaquelo pajhua'atéchaca, nacapichátajla pecohuácaca raú. Ñaqué caja iná ejena nóquelo pajhua'atéchaca, nacapichátajla pecohuácaca raú. ");
INSERT INTO ycn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ñaqué caja ricá Satanás, Jiñá Chi'ináricanajlo. Jiñana pechu rijhua'atéjena. Rica'aquela necá ina'uqué e'iyayá, rila'ájla chapú ricó. Uncá meque rila'alajla rejomi, uncale rijhua'atéjena i'imalajla raú. ");
INSERT INTO ycn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Icá calé quemaño nunacu: “Beelzebú, jiñana huacára'ajeri pechu aú rica'á jiñana pechu ina'uqué e'iyayá”. Eta, ja'apiyatéjena ca'añó caja jiñana pechu ina'uqué e'iyayá. ¿Ñaqué caja chi imacá nanacu? Necá hue'epiño uncá paala ipechu. ");
INSERT INTO ycn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nucá ca'arí jiñana pechu ina'uqué e'iyayá Tupana Pechu aú. Aú iná hue'epí caja Tupana queño'ocá ina'uqué naquiyana huacára'ajeri i'imacana. ");
INSERT INTO ycn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","E Jesús i'imari yucu najló, nahue'epícaloje raú richá'ataca Jiñá Chi'ináricana penaje ri'imá najló yucu marí que: —Uncá na calé mujlúca'ari catejmuni ina'uqué ñacaré chojé rinane ña'ajé riliyá. Apú richaje catejmuca ipháquela rinacu, ricá jepo'otárijla ricá. Quéchami rijña'atácajla rinane riliyá —que Jesús i'imacá yucu najló. ");
INSERT INTO ycn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Rimá piño najló: —Uncachu ina'uqué naquiyana huátalaño nucá, chapú napechu nunacu. Uncachu nala'alá ina'uqué palá nujhua'até, napajno'otá napechu Tupana liyá apojó. ");
INSERT INTO ycn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tupana amaro ina'uqué chaje piyuqueja pu'uhuaré nala'acare liyá, namanaicho nala'acare liyá hua'ató. Pu'uhuaré nemacare nacú liyá hua'ató ramó nachaje. Eyá pu'uhuaré nemacare Tupana Pechu nacú, ricaja calé uncá ramalo nachaje riliyá. ");
INSERT INTO ycn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ina'uquéjloje penaje i'imacá nucá. Pu'uhuaré ina'uqué quemacare nunacu, Tupana amárojla nachaje, pu'uhuaré nemacare liyá. Eyá pu'uhuaré nemacare Tupana Pechu nacú, uncá Tupana amálajo nachaje riliyá. Ñaqué ricá me'etení. Ñaqué caja ri'imajica reyá a'ajná ño'ojó i'imajícañojlo. ");
INSERT INTO ycn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Palani inarí a'ahuaná arúca'ari palani richa. Pu'uhuareni inarí a'ahuaná arúca'ari pu'uhuareni caja richa. Richa aú iná hue'epí a'ahuaná nacojé, palani ricá, pu'uhuareni ca'ajná ricá. Ñaqué caja ina'uqué. ");
INSERT INTO ycn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pu'uhuaré péchuruna icá. Ñaqué i'imacale uncá meño'ojó imalá palá nacaje nacú. Iná pechu que caja iná quemacá nacaje nacú. ");
INSERT INTO ycn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Palá péchuri quemari palá nacaje nacú. Ripechu locópa'alaja rimá nacaje nacú palá. Eyá pu'uhuaré péchuri quemari pu'uhuaré nacaje nacú. ");
INSERT INTO ycn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pa. Tupana quemájeri ina'uqué nacú mecajenaca necá. Rihuacajé rihuajájica pu'uhuaré pura'ajeño. Piyuqueja pu'uhuaré caje nemacare nacú chona rihuajaje necá. ");
INSERT INTO ycn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Iná puráca'alo aú Tupana quemájeri iná nacú mecajeca iná. Uncá pu'uhuaré pura'ajero calé iná i'imajica ee, iná i'imajó rihuajájica iná liyá. Pu'uhuaré pura'ajero iná i'imajica ee, rihuajaje iná. ");
INSERT INTO ycn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","E caja fariséona naquiyana, Tupana puráca'alo nacú jehuíña'atajeño naquiyana quele quemaño marí que Jesusjlo: —Pila'á huajló nacaje uncá meño'ojó ina'uqué la'alare, huahue'epichi picá raú. ");
INSERT INTO ycn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús quemari najló: —Uncá ina'uquélaruna, uncá huátalaño Tupana, cajena quemaño nojló, nula'acáloje nacaje uncá meño'ojó iná la'alare penaje. Tupana la'arí Jonasmi chujlo nacaje júpimi i'imacá. Tupana puráca'alo ja'apátajeri ri'imacá. Rila'acá rijló nacaje i'imacá que caja rila'ajica piño nojló nacaje. Ricá aú ja calé ihue'epeje nucá. Uncá nula'alaje apú nacaje ijló, ihue'epichi nucá raú. ");
INSERT INTO ycn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jiña cajruni ajmílo'ori Jonasmi chu i'imacá. Rihuó chu ri'imá hueji que cala quetana. Ñaqué caja nu'umajica liri chu hueji que cala quetana. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jonasmi chu i'imari Tupana yucuna Nínive e i'imacáñomi chúnajlo i'imacá. Aú napajno'otá napéchuhua pu'uhuaré nala'acare liyá Tupana ejo. Eyá maare nucá me'etení ijhua'até. Jonasmi chu i'imacá chaje nucá, i'imari ijló Tupana yucuna. E'iyonaja uncá ipajno'otala ipéchuhua pu'uhuaré ila'acare liyá Tupana ejo raú. Rijimaje Nínive e i'imacáñomi chuna quemajeño inacu, Tupana huajácaloje icá penaje. Me'etení i'imacaño nacú nemaje rihuajájica ina'uqué huacajé. ");
INSERT INTO ycn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Júpimi apa'ahuelo i'imayo i'imacá. Cahuacajo te'eréruna i'imacánaru ru'umacá. Rucá i'ijnayo ya'ajnajo Salomonmi chu chaje ripuráca'alo jema'ajé. Hue'epiri huani ri'imacale, ru'ujná rejo i'imacá. Eyá maare nucá me'etení ijhua'até. Salomonmi chu chaje hue'epica nucá. E'iyonaja uncá a'alá inacojó nupuráca'alo. Rijimaje ne'emacánarumi cholo quemajeyo inacu, Tupana huajácaloje icá penaje. Me'etení i'imacaño nacú rumaje rijló, rihuajájica ina'uqué huacajé. ");
INSERT INTO ycn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—Jiñá pechu jácho'ocharo pajluhuaja ina'uqué e'iyayá. E ra'apicha te'erí macajreni nacuhuá. Riculicha rijluhua pucunaji, rihuatána'acaloje richojé penaje. E'iyonaja uncá riphátalacha ricá. ");
INSERT INTO ycn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","E rimicha: “Nupa'ajícoja nuñacaremi ejo, ilé ina'uqué nócho'ocaro e'iyayá ejo. Aú ripi'ichó rapumí chuhuá. Rimujlúqui'icha ina'uqué e'iyajé piño. Amíchari palani ri'imichaca. Lamá'ataquejami ri'imichaca rijló. ");
INSERT INTO ycn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Raú ri'ijichá piño ajopana jiñana pechu huá'aje. Iyamá cuhuá'ata quele rihuá'icha rijhuáque'ena penaje. Richaje chapújne'equenaca ne'emichaca. Necá piyuqueja mujlúqui'ichaño ilé ina'uqué e'iyajé, ne'emacáloje rihuacára'ajeño penaje. E caja penaje chapújne'eque huani ilé ina'uqué i'imichaca na'apiyá i'imacana aú. Júpimi ri'imacá chaje huani chapújne'equeca ri'imichaca na'apiyá —que Jesús i'imacá najló yucu. Ejomi rimá najló: —Ñaqué caja ri'imajica pu'uhuaré la'acáñojlo, me'etení i'imacáñojlo. Richaje ila'acá pu'uhuaré me'etení, uncale a'alá inacojó Tupana puráca'alo. ");
INSERT INTO ycn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pachu Jesús i'imari cajrú ina'uqué hua'até. Yucu ri'imá najló. E Jesús jaló, rijmerémina, quele iphaño rejo. Nahuata Jesús hua'até pura'acano. Huaca'apeja ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","E apú quemari Jesusjlo: —Paló, pejena, quele iphíchaño. Huaca'apé necá. Nahuata pijhua'até pura'acano. ");
INSERT INTO ycn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Rimá rijló: —¿Mecajena chi necá nojena, noló, quele? ");
INSERT INTO ycn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aú riya'atá ra'apiyatéjena chaje. —Mariruna nojló noló, nojena que i'imacaño. ");
INSERT INTO ycn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nora'apá, je'echú chu i'imacare, huátaca que la'acaño, nojena que nojló necá. No'ohué que, no'ohueló que, noló que nojló necá. ");
INSERT INTO ycn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","E caja Jesús jácho'oro pají chiyá. Ri'ijná ají que a'ajná ño'ojó Caésa turenaje. Re riyá'o. ");
INSERT INTO ycn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","E cajrú ina'uqué jahuacaco rinacojé. Aú rihuitúca'a jita chojé yá'ajo. Ajopana yuriño caesa turená, que'epé nacú. ");
INSERT INTO ycn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","E caja rehuíña'ata necá cajrú nacaje nacú. Nacaje yucuna i'imacana nacú rehuíña'ata necá. E ri'imá najló yucu marí que: —Pajluhuaja ina'uqué i'ijichari nacaje icha ijí ejátaje. ");
INSERT INTO ycn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Riqui'ichá richa ijí lamá'ataqueja te'erí jimahua. Rejátacana nacuja ri'ijichá. Richa ijí riqui'ichaje naquiyana ja'acharo iñe'epú chojé. E caja cupira'aphana iphíchaño rajmílo'otaje. ");
INSERT INTO ycn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Apú richa ijí riqui'ichaje naquiyana ja'acharo jipa nacojé. Huejápaja te'erí i'imichari rinacu. Quiñaja riphíchaca, huejapa te'erí i'imichácale rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Camú moco'ochaca aú rimeríyi'icho, uncale ra'apare i'imalacha. ");
INSERT INTO ycn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Apú richa ijí riqui'ichaje naquiyana, ja'acharo pu'uhuareni jimichi e'iyajé. Pu'uhuareni jimichi iphíchari richa ijí rejáchiyaje hua'até. Pu'uhuareni jimichi tahuá'añachari ricá. Raú rihuajri'ichá re'iyajé. ");
INSERT INTO ycn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Eyá apú richa ijí naquiyana ja'acharo palani te'erí e'iyajé. Ilé iphíchari palá; ritahuá'icho palá; rarúqui'icha palá. Re'iyajé que apú richa ijí rejáchiyaje arúqui'ichari richahuá cien ca'alá. Re'iyajé que apú arúqui'ichari richahuá sesenta ca'alá. Re'iyajé que apú arúqui'ichari richahuá treinta ca'alá. Marí que ri'imacá yucu najló. E rimá rema'ajéñojlo: ");
INSERT INTO ycn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","—Icá que'ejhuirúnajlo numá: A'á inacojó riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Caja ri'imá najló yucu. Yámijo ra'apiyatéjena i'ijnaño Jesús ahua'ajé. Nemá rijló: —¿Meca penaje pehuíña'ata ina'uqué nacaje nacú, nacaje yucuna i'imacana nacú? ");
INSERT INTO ycn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","E Jesús quemari najló: —Me'echuje ina'uquejlo méqueca Tupana la'acá, ina'uqué naquiyana i'imacáloje rijhua'atéjena penaje. E'iyonaja Tupana la'arí ipechu palá, jema'acáloje penaje. Eyá ajopánajlo me'echuje jo'ó ricá. ");
INSERT INTO ycn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Quehuácaje puráca'aloji nanacojó a'ajeño hue'epéjeño richaje, richaje que rinacojé. Raú cajrú nahue'epíjica rinacojé. Uncá a'alaño nanacojó quehuácaje puráca'aloji, uncá hue'epílaño rinacojé. Ricá ñani nahue'epícare nacojé, capichájero naliyá. ");
INSERT INTO ycn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nu'umá yucu najló, nohuíña'atacaloje necá Tupana nacú raú penaje. E'iyonaja uncá nahue'epila meque quemacánaca ricá riyucuna jema'acana aú. Uncá caja nahue'epila meque quemacánaca nacaje namácare Aú. ");
INSERT INTO ycn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tupana puráca'alo ja'apátajerimi chu, Isaíasmi chu i'imari riyucuna i'imacá. Caja queja najló ricá. Marí que rimacá nanacu i'imacá: Jema'ajé riyucuna. E'iyonaja uncá ihue'epílaje meque quemacánaca ricá. Icá amájeño nacaje. E'iyonaja uncá ihue'epílaje meque quemacánaca nacaje amácare. ");
INSERT INTO ycn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Marí que ri'imajica najló, nejnúcha'acole ra'apiyá jema'acana nacú. Uncá riphálaje napechu nacojé palá. Uncá caja nahue'epílaje meque quemacánaca ricá. Uncá caja nayurílaje nojló nachó, nulamá'atacaloje napechu penaje, que Tupana quemacá Isaíasmi chujlo i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Uncá ñaqué calé ijló ricá —que Jesús quemacá najló—. Palani ijló ricá, yucu jema'acare iphácale ipechu nacojé. Icá hue'epiño meque quemacánaca nacaje amácare. ");
INSERT INTO ycn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Jema'á marí: Ñaquejlaca cajrú Tupana puráca'alo ja'apátajeñomi chuna, palá la'acaño quele, huátacajla nacaje amácana, amaca ricá me'etení que caja. E'iyonaja uncá meño'ojó namala ri'imacá rihuacajé. Ñaquejlaca nahuátacajla nupuráca'alo jema'acana, jema'acá ricá me'etení que caja. E'iyonaja uncá caja meño'ojó nema'alajla ñaqué rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Jema'á, meque quemacánaca nacaje icha ijí ejátajeri yucuna. ");
INSERT INTO ycn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tupana yucuna jema'ajeño naquiyana uncá hue'epílaño meque quemacánaca ricá. Nema'á riyucuna. E'iyonaja Satanás, Jiñá Chi'ináricana, ca'arí napechu naquiyá Tupana puráca'alo nema'acare. Richa ijí ja'acó iñe'epú chuhuá que caja najló ricá. ");
INSERT INTO ycn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Eyá richa ijí naquiyana ja'aró jipa nacojé huejápaja te'erí i'imacare nacojé. Mequetánaja calé rijña'acá panacu riphaca ejomi. Ñaqué caja ina'uqué naquiyánajlo ricá. Nema'á Tupana puráca'alo. Pu'ují napechu la'acó raú. ");
INSERT INTO ycn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mequetánaja calé napechu i'imacá palá rinacu. Nahuátacale Tupana puráca'alo ja'apiyá i'imacana, ajopana ca'ajná la'añó necá chapú. Napura'ó ca'ajná nanacu pu'uhuaré. Namá ca'ajná chapú caje yajhué. Marí caje aú nayurí naliyó ricá, uncale napechu i'imalá caphí najluhua. ");
INSERT INTO ycn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Eyá richa ijí naquiyana ja'aró caja pu'uhuareni jimichi e'iyajé. Riphaca ejomi rihuaja'acá re'iyajé. Uncá rarúca'ala. Ñaqué caja ina'uqué naquiyánajlo ricá. Nema'á Tupana puráca'alo. Naqueño'ó ra'apiyá i'imacana. E'iyonaja cajrú na'acá nanacojó nacaje marí eja'ahuá chu i'imacare. Napechu nacú ri'imá: “Palá hue'emajica cajrú liñeru hua'até, ñó'ope le'ejepelaji caje hua'até”. E'iyonaja uncá ñaqué calé ricá ina'uquejlo. Marí que péchuruna ne'emacale, uncá na'alá nanacojó Tupana puráca'alo, nala'acáloje palá ra'apiyá i'imacana aú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Eyá richa ijí naquiyana ja'aró palani te'erí e'iyajé; riphá; ritahuá'o, rarúca'a palá. Ñaqué caja ina'uqué naquiyánajlo ricá. Nema'á Tupana puráca'alo; nahue'epí meque quemacánaca ricá; na'á nanacojó ricá. Raú nala'á palá ra'apiyá i'imacana aú. Richa ijí naquiyana arúca'ari richahuá cien ca'alá que, sesenta ca'alá que, treinta ca'alá que. Ñaqué caja ricá Tupana puráca'alo ja'apiyá i'imacáñojlo. Ne'iyajena la'añó palá huani cajrú. Ra'apejé que ajopana la'acá palá —que Jesús jehuíña'ataca necá rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","—Ina'uqué naquiyana huacára'ajeri Tupana. Chuhua nu'umajica yucu ijló, ihue'epícaloje rinacojé penaje. Apú ina'uqué i'ijichari trigo ejátaje ri'icacapere e'iyá. E caja riñapáchiya rejátacana. ");
INSERT INTO ycn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lapí ricamáchiyo. Cháyomi apú i'ijichari ri'icacapere e'iyajé jimichi pu'uhuaré nojé ejátaje. Chapú péchuri rinacu ri'imichaca. Rejáchiya ricá ejomi ripi'ichó. ");
INSERT INTO ycn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","E caja trigo tahuá'icho ri'icacapere e'iyá. Ehuá rihuirulá li'ichaco, rarúca'acaloje richiyá penaje. E caja namicha cajrú jimichi re'iyá. Trigo ina que caja rina amácana. ");
INSERT INTO ycn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Marí que rijhua'até sápajeño amíchaca aú ne'ejichá riyucuna quejá'aje paminá liyá. Nemicha rijló: “Palani richa ijí pejátacare re'iyajé i'imacá. Eta, ¿méreyaca pu'uhuareni jimichi iphala cajrú huani re'iyá”, que nemíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","E paminá quemíchari najló: “Chapú péchuri ta nunacu ejátari re'iyohuá ricá.” E nemicha rijló: “¿E pihuátaca hue'ejnacá rero'otaje”? ");
INSERT INTO ycn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Uncá” que rimíchaca najló. “Reja ri'imaláreja ñaqué. Apala jero'ó trigo naquiyana rijhua'ató. ");
INSERT INTO ycn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Reja ri'imareja,” que paminá quemacá najló rinacu. “Richá ña'acana iphájica rená chojé huacajé, nuhuacára'aje nujhua'até sápajeño pu'uhuaré nojé jimichi jero'otaje re'iyayá. Ejomi nepo'otaje ricá, nacára'atacaloje ricá penaje. Quéchami najña'ajé trigo icha, nalamá'atacaloje ricá riñacarelana chojé penaje,” que rimacá najló. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús i'imari piño najló yucu marí que: —Ina'uqué naquiyana huacára'ajeri Tupana. Rijhua'atéjena huejápaja. Ehuá richaje, richaje que íqui'irunaca rijhua'atéjena i'imajica. Chuhua nu'umajica yucu ijló, ihue'epícaloje méqueca ricá penaje. Mostaza ijí que ricá, ina'uqué ejátacare ne'ecacapere e'iyohuá. ");
INSERT INTO ycn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Capajé nojé huani rijí. E'iyonaja jíma'alami yenuna quetana ritahuá'aco. Ritahuá'aña apú nacaje icha ijí iná ejátacare. Ripana e'iyá cuphira'apana, camejérina cayuphéruna cajena la'añó nañacaró. ");
INSERT INTO ycn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús i'imari piño najló apa'amá yucu marí que: —Tupana i'imari ina'uqué naquiyana huacára'ajeri. Re rijhua'atéjena huejápaja. Ehuá richaje, richaje que íqui'irunaca ne'emajica. Chuhua nu'umajica apa'amá yucu, ihue'epícaloje rinacojé raú penaje. Inaana quechípa'año pan amúra'atajona harina hua'até. Raú harina anóro'otacanami piyuqueja amúra'ataro. Ñaqué caja Tupana yucuna jema'acó cajrú ina'uqué e'iyohuá, nema'acáloje ra'apiyá penaje, ne'emacáloje rijhua'atéjena raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Cajrú Jesús jehuíña'ataca necá nacaje nacú, yucu i'imacana aú. Yucu chuhuaja rimacá najló nacaje nacú. ");
INSERT INTO ycn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tupana puráca'alo ja'apátajerimi chu quemaqué rinacu que rehuíña'ataca ne'emacá. Marí que rilana'acá riyucuna papera chojé i'imacá: Yucu chuhuaja numaje najló nacaje nacú. Nacaje me'echújeja i'imacare ina'uquejlo, ricá yucuna nu'umajé najló. Me'echuje ri'imacá piyuque ina'uquejlo Tupana queño'ótaca eja'ahuá huacajé eyá maárejecha, que rimacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","E caja Jesús i'imari riyucuno ina'uquejlo. E rimujlúca'a pají chojé. E ra'apiyatéjena jahuacaño rahua'ajé. Nemá rijló: —Pimá huajló meque quemacánaca jimichi, trigo quele yucuna pi'imichaje huajló. ");
INSERT INTO ycn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús quemari najló: —Ina'uquéjloje penaje i'imacá nucá. Palani nacaje icha ijí ejátajeri que caja nucá. Palani nupuráca'alo. ");
INSERT INTO ycn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ri'icacapere que caja eja'ahuá. Trigo palani que caja Tupana ja'apiyá jema'ajeño. Pu'uhuaré jimichi que caja ina'uqué, Jiñá Chi'ináricana hua'atéjena i'imacaño. ");
INSERT INTO ycn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jiñá Chi'ináricana que caja chapú péchuri rinacu, ejátari pu'uhuareni jimichi ri'icacapere e'iyajé. Eja'ahuá tajnájico huacajé que caja richa ña'acana iphaca rená chojé. Tupana hua'atéjena, je'echú chu i'imacaño, que caja richa ña'ajeño. ");
INSERT INTO ycn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Rimá najló: Richa ña'ajeño i'ijnaño pamineco pu'uhuareni jimichi jahuacátaje, naca'acáloje ricá quera'atani chojé penaje. Ñaqué caja ri'imajica eja'ahuá tajnájico huacajé. ");
INSERT INTO ycn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Ina'uquéjloje penaje i'imacá nucá. Nucá huacára'ajeri nujhua'atéjena, je'echú chu i'imacaño, uncá ina'uquélaruna huá'aje. Pu'uhuaré la'acaño, namanaicho la'acaño, ñaqué la'acana aú namata ajopana, quele necá ne'ejnajé huá'aje. Nahuá'aje necá, naca'acáloje necá quera'atani chojé penaje. Re cajrú nahuíyo'ojica. Cajrú caja neyájica. Cajrú caja najma'ajica naí huá camachá, quehuini yajhué namájicale. ");
INSERT INTO ycn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Eyá Tupana huátaca que la'acaño, necá i'imajeño palá huani je'echú chu Nora'apá Tupana hua'até. Icá que'ejhuirúnajlo numá, jema'á numacare nacú —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesús quemari piño najló marí que: —Tupana ja'apiyá i'imacana palani huani inajlo. Cahuemí nojé huani nacaje ina'uqué huátacare najluhua que caja ricá. Apú ca'ajná iphátari apú i'icacapere e'iyá nacaje cahuemí nojé huani. Me'echú ri'imacá, sa'aquéjami. Caja ramá ricá. E rapára'ata ricá rapumí chojé piño. Pu'ují huani ripechu i'imacá, riphátacale ricá. E ripa'ó riñacaré ejo. Ra'á ajopánajlo piyuqueja rinane. Ricá aú rácho'ota rijluhua liñeru, rihuarúhua'acaloje ri'icacapere paminá liyá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesús i'imari piño apa'amá yucu. Rimá najló: —Tupana ja'apiyá i'imacana palani huani inajlo ricá. Nacaje íqui'i iná huátacare inajluhua que ricá inajlo. Apú ca'ajná, le'ejepelaji mináricana, i'ijnari palá nojé le'ejepelaji culácana nacú. ");
INSERT INTO ycn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","E caja riphata ca'ajná nacaje rihuátacare, apú nacaje chaje rihuátaca ricá. Palá nojé, cahuemí nojé huani ricá. Raú ra'á piyuqueja rinane. Ricá huemí ra'á rijló liñeru, rihuarúhua'acaloje rijluhua ricá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ina'uqué naquiyana huacára'ajeri Tupana. Nahuenare naca'acare junápeje que caja ricá. Naca'á nahuenare junápeje. Raú que'iyapejena jíñana ja'añó richojé. ");
INSERT INTO ycn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cajrú na'acó nahuenare chojé. Ejéchami nachíra'aca ricá ají que juni turenajo, que'epé nacojé. Re nayá'o. Najña'á ne'iyayá palá nojena jíñana; naca'á nacuhuá'alane chojé necá. Pu'uhuaréruna quehuá nacupá ne'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ñaqué caja ri'imajica ina'uquejlo eja'ahuá tajnájico huacajé. Tupana hua'atéjena, je'echú chiyájena, i'ijnajeño uncá ina'uquélaruna huá'aje. Pu'uhuaré la'ajeño, namanaicho la'ajeño, quele nahuá'aje ajopana ina'uqué e'iyayá, naca'acáloje necá quera'atani chojé penaje. ");
INSERT INTO ycn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Re cajrú nahuíyo'ojica. Cajrú neyájica. Cajrú najma'ajica naí hua, namájicale quehuini yajhué. ");
INSERT INTO ycn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","E Jesús quemari najló: —¿E ihue'epica meque quemacánaca numíchaje nacú ijló? —A'a —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","E rimá najló: —Tupana puráca'alo nacú jehuíña'atajeño a'acachu nanacojó nupuráca'alo, nahue'epí palá raú Tupana puráca'alo nacojé jupichumi, meyáleje hua'ató. Nacaje i'imacá pají minajlo que caja najló ricá. Re pají minajlo palá nojé nacaje jupichumi, huajé hua'até. Tupana puráca'alo nacú jehuíña'atajeño, no'opiyá jema'ajeño, hue'epiño jupichumi Tupana puráca'alo nacojé, meyáleje nacojé hua'até. Raú nahue'epí palá Tupana puráca'alo ja'apátacana ajopánajlo. ");
INSERT INTO ycn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Marí que Jesús i'imacá yucu najló i'imacá. E caja ri'ijná reyá. ");
INSERT INTO ycn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Iphari rite'eré ejo. Re richape piño riqueño'ó nehuíña'atacana Tupana nacú nahuacáca'alo ñacarelana chu. Ripuráca'alo jema'ajeño pechu i'imá: “¡Meque piyuque huani rihue'epílaca nacaje nacojé!” Nemá: —¿Mere chi rehuíña'o piyuqueja puráca'aloji nacú? ¿Meque rihue'epica nacaje la'acana, uncá ina'uqué hue'epílare la'acana? ");
INSERT INTO ycn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ilé mirapehua nacú sápajeri i'irí ricá. María raló. Santiago, José, Simón, Judas, quele e'ehué ricá. ");
INSERT INTO ycn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Maare hue'iyá re'ehuelona ñacaré. Eta, ¿Meque rihue'epica piyuqueja puráca'aloji nacojé? ");
INSERT INTO ycn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Namána'apa ri'imacale, chapú nahuó i'imacá richá. Uncá na'alá nanacojó ripuráca'alo. E Jesús quemari najló: —Piyuque ina'uqué iphaño Tupana puráca'alo ja'apátajeri ja'apí. Necaja calé rite'eré eruna, rejena, quele uncá iphálaño ra'apí. ");
INSERT INTO ycn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Uncá rila'alá cajrú nacaje rehuá, uncá meño'ojó iná la'alare. Uncá pachá napechu i'imalá caphí richojé. ");
INSERT INTO ycn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Caja cajrú huani Jesús yucuna jema'acó rehuá i'imacá. Riyucuna iphari caja nahuacára'ajeri Herodes nacú. Galilea te'eré eruna i'imacana ri'imacá rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","E rimá rahua'á i'imacáñojlo marí que Jesús nacú: —Juan bautizar la'ajeri ricá. Caja rimacápo'o. Penájemi ricá. Aú calé rihue'epí piyuque nacaje la'acana, uncá meño'ojó iná la'alare —que rimacá najló Jesús nacú. ");
INSERT INTO ycn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ejo'ocaja Juanmi chu i'imacá huacajé Herodes huacára'ari rica'acana ina'uqué huajáquelana chojé i'imacá. Jepo'oqueja nayurí ricá richu. Marí que rila'acá ricá chapú riyajalo puráca'alo aú. Riyajalo ií i'imari Herodías. Re'ehué, Felipe, yajalo ru'umacá pamineco. ");
INSERT INTO ycn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Rica'á riliyá rucá. Richona Juanmi chu aca'arí Herodes i'imacá. Rimá rijló: —Pe'ehué yajalo penájerumi ilerú pi'imá hua'até. Uncá Tupana huátala iná la'acá ilé que —que rimacá rijló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Rijimaje Herodes huátari rinócana. E'iyonaja riquero'ó ina'uqué piyá, palá napechu i'imacale Juan nacú. “Tupana puráca'alo ja'apátajeri ricá,” que napechu i'imacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","E caja Herodes iphátari rile'ejé jarechí. Aú caja rila'á fiesta. Cajrú riyucupéra'acarena ina'uqué iphaño rinacu. Aú rihuacára'a riyajalo itu arápa'aca najimaje piyuque. Aú rorápa'a rocó najimaje. Palá huani ri'imacá Herodes nacú. ");
INSERT INTO ycn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","E rimá rojló: —Piquejá'a nuliyá pihuátacare caje, no'ochí pijló ricá. Tupana hue'epiri quehuaca numacá. ");
INSERT INTO ycn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","—Je —que rumacá. E ru'ujná roló amaje pamineco. —Marí que rimíchaca nojló. ¿Meque numájica rijló? Aú rumá rojló: —Eco pimá rijló, ra'acáloje pijló Juan bautizar la'ajeri huíla'aru pachiya chojé. “Je” que. E rupa'ó piño ropumí chuhuá rijló quemaje. Rumá rijló: —Pa'á nojló Juan bautizar la'ajeri huíla'aru pachiya chojé. ");
INSERT INTO ycn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aú camu'ují huani ripechu la'acó, Herodes pechu la'acó. E'iyonaja uncá meque rila'alá. Caja rimá rojló i'imacá: “No'ojé pijló pihuátacare caje. Tupana hue'epiri quehuaca numacá,” que rimacá rojló i'imacá. Ina'uqué, riyucupéra'acarena, jimaje que rimacá rojló. Ñaqué i'imacale rihuacára'a na'acá rojló ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Rihuacára'a ne'ejnacá ina'uqué huajáquelana chojé Juanmi chu núru'upi mata'ajé. Namata'á ricá. ");
INSERT INTO ycn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Quéchami nayá'ata rihuíla'arumi pachiya chojé. Ne'ematá rojló ricá. Ejomi ro'ó rolojlo ricá. Raú ruhue'epí caja nenóchaca ricá. Marí que nenoca Juanmi chu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nenoca ricá ejomi ra'apiyatéjenami i'ijnaño ina'uqué huajáquelana chojé ritami ña'ajé. Najña'á ritami. E nasa'á ricá. Ejomi ne'ejná riyucuna i'imajé Jesúsjlo. ");
INSERT INTO ycn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Caja ne'emá Jesusjlo riyucuna. E ri'ijná reyá ra'apiyatéjena hua'até. Necoja ne'ejnacá jita chuhuá a'ajná ño'ojó, ne'emacáloje necoja ajopana ina'uqué liyá penaje. E'iyonaja ajopana hue'epiño meño'ojoca ne'ejnacá. Cajrú pajimila i'imacá rehuá. Re i'imacaño i'ijnaño pe'iyoóhua ají que ne'ejnacá ejo; iphaño natucumá. ");
INSERT INTO ycn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","E caja narúca'o. E Jesús jácho'oro jita chiyá; amari cajrú huani ina'uqué. Rihue'epí namu'ují. Ritejmo'óta natámina nahuá'acarena rejo i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Natejmo'ótacana nacú najúhua'a. E ra'apiyatéjena i'ijnaño rahua'ajé; quemaño rijló: —Caja huajúhui'ichaca. Uncá nañacaré i'imalá maárohua. Pihuacára'a necá pajimila ejo, nahuarúhua'acaloje a'ajnejí najluhua reyá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","E'iyonaja Jesús quemari najló: —Uncá ne'ejnalaje. Icá a'ajeño najló a'ajnejí. ");
INSERT INTO ycn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nemá rijló: —Uncá a'ajnejí i'imalá maare, najñácaloje penaje. Pajluhua té'ela ca'alá pan maare, iyajmela jíñana hua'até. Queleja calé maare. ");
INSERT INTO ycn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús quemari najló: —Iji'ichá ricá majó. —Je. ");
INSERT INTO ycn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","E rihuacára'a ajopana yá'aco jimichi palani e'iyajé. Ejomi rijña'á ricápojo pajluhua té'ela ca'alá pan, iyajmela jíñana hua'até. E riyacá'o ají que je'echú chojé. Rimá Tupánajlo: —Palá pili'ichaca huecá marí a'ajnejí aú. E ritupa'á pan naquiyana. Riyupa'atá caja jiña naquiyana najló. Ejomi ra'á ra'apiyatéjenajlo ricá, natamáca'atacaloje ina'uquejlo ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","Piyuqueja necá ajñaño na'ajnehuá namano'ocá ejé. Cinco mil ca'ajná ne'emacá achiñana, ajñaño na'ajnehuá inaana, yuhuaná hua'até. Uncá nalapa'atala inaana, yuhuaná, quele. Najñaca na'ajnehuá ejomi ra'apiyatéjena huayo'oñó rijlupemí yurícaro. Iyamá iphata ji'imaji nacojé ca'alá cuhuá'ala namano'otá pu'uteno raú. ");
INSERT INTO ycn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","E caja Jesús huacára'ari ra'apiyatéjena huitúca'aca jita chojé, nacuhuá'acaloje pa'anajo pitá ritucumá penaje. E caja rihuacára'a ina'uqué pa'acó. ");
INSERT INTO ycn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Caja napa'ó. E caja Jesús i'ijrari yenuri i'ihuátaje, ripura'acóloje Tupana hua'até penaje. Caja calajerúhuaca ne'emacá. Jesús i'imari ricoja. ");
INSERT INTO ycn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ra'apiyatéjena i'imaño caesa pe'iyó leñacaje nacú. Carená ja'apari ají que najimajo caphí. Caja cajrú juni yoco'ocó. Riyocola ña'arí jita nacojé caphí. ");
INSERT INTO ycn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","E caja ehuaja najme'etá. Luhuíchipica ee Jesús i'ijnari nápumi chu. Juni jimó ra'apá. ");
INSERT INTO ycn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ra'apiyatéjena amaca aú ricá huaíchaca, cajrú naquero'ocó. —¡Yee, ilé ina'uqué ñacami ta huaícha! —que nahuíyo'oca. ");
INSERT INTO ycn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","E Jesús quemari najló: —Ipechu i'imá caphí. Iquero'oniyo, Jesús nucá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","E Pedro quemari rijló: —Picá pi'imajica ee, pihuacára'a no'opaca ñaqué caja juni jimó pijimajo. ");
INSERT INTO ycn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Majó pi'ijná —que rimacá rijló. Aú Pedro jácho'oro jita chiyá juni jimaje. Riqueño'ó juni jimó ja'apácana ají que Jesús jimajo. ");
INSERT INTO ycn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Rimá: “¡Meque caphí huani ta carená!” Aú riquero'ó. Hua'ató que caja ra'acó junápeje. Eja rahuíyo'o: —Pihue'epí numu'ují. ");
INSERT INTO ycn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ejéchami Jesús patacá ricá ra'anapitá naquiyá. Rácho'ota junápiya ricá. Rimá rijló: —¡Huejapa nochojé péchuri picá! ¿Naje piyuricha caphí nochojé i'imacana? ");
INSERT INTO ycn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","E caja nahuitúca'a jita chojé. Hua'ató que carená mata'acá. ");
INSERT INTO ycn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","E jita chu i'imacaño tára'año ne'erúpachi aú Jesús jimaje. Nemá rijló: —Tupana I'irí jo'ó picá. ");
INSERT INTO ycn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Caja nacuhuá'a pa'anajo pitá, Genesaret te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ina'uqué amaca aú Jesús na'apata riyucuna apú nacojé, apú nacojé que nate'eré ehuá. Aú caja nahuá'a cajrú natámina ri'imacá ejo. ");
INSERT INTO ycn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Natámina quemaño rijló, riyurícaloje nasápaca ra'arumacá ji'imá nacojé penaje. Piyuqueja rinacu sápajeño tejmo'otaño raú. ");
INSERT INTO ycn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ajopana iphaño Jesús nacú i'imacá. Fariséona, Tupana puráca'alo nacú jehuíña'atajeño, quele naquiyana ne'emacá. Jerusalén eyájena ne'emacá. Caja nephá rinacu; nemá rijló: ");
INSERT INTO ycn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Naje uncá pa'apiyatéjena la'alaño peñahuilánami chuna quemajica que? Uncá nepala nayáte'ela chiyá najñaca na'ajnehuá piyá, peñahuilánami chuna la'ajica que caja. ");
INSERT INTO ycn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús quemari najló: —Eyá icá yuriño Tupana puráca'alo ja'apiyá i'imacana, ila'acáloje peñahuilánami chuna quemacá que penaje. ");
INSERT INTO ycn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Marí que Tupana quemacá: “Iphá ichi'iná ja'apí”. Pu'uhuaré pura'ajícaño nachi'iná nacú inoje”, que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Eyá me'etení maare nayani quemaño marí que nachi'inajlo: “Uncá meño'ojó no'olá iñaté liñeru aú. Caja no'ó Tupánajlo nuliñérute”, que nemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Majopeja nemacá. Uncá nephala nachi'iná ja'apí raú. E'iyonaja uncá na calé imá najló. Caja majopéjari que ila'acá Tupana puráca'alo ijluhua, ila'acáloje peñahuilánami chuna puráca'alomi quemacá que penaje. ");
INSERT INTO ycn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pajlácachina huani icá. Icá la'añó icó palá la'ajeño que ina'uquejlo. E'iyonaja uncá ñaqué calé icá. Palá huani Tupana puráca'alo ja'apátajerimi chu, Isaíasmi chu, i'imacá iyucuna júpimi i'imacá. Marí que rilana'acá papera chojé ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Marí que Tupana quemacá ina'uqué nacú: Mariruna ina'uqué pura'añó palá nunacu nanuma chiyaja calé. E'iyonaja nahuajhué nacú, uncá nahuátala nucá. ");
INSERT INTO ycn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Uncá na penaje calé nahuacono pajhua'atéchaca nahuacáca'alo ñacarelana chojé, nala'acáloje pu'ují napéchuhua nunacu penaje. Peñahuilánami chuna puráca'alomi nacuja calé nehuíña'ata ina'uqué. Tupana puráca'alo que japi ricá nehuíña'ataca necá rinacu, que Tupana quemacá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","E Jesús quemari piño ina'uquejlo, ne'ejnacáloje rahua'ajé penaje. E rimá najló: —Chuhua jema'á marí meque quemacánaca ricá: ");
INSERT INTO ycn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Iná numá chojé iná a'á a'ajnejí, iná ajñácaloje ricá penaje. Uncá iná la'alá pu'uhuaré raú. Eyá iná numá chiyá iná pura'ó pu'uhuaré. Raú calé iná la'á pu'uhuaré —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","E Jesús ja'apiyatéjena i'ijnaño Jesús ahua'ajé. Nemá rijló: —Ilé pimíchaje nacú jimaje fariséona yúchi'ichaño pichá. ¿E pihue'epica ricá? ");
INSERT INTO ycn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Rimá najló: —Nora'apá, je'echú chu i'imacare, capichátajeri piyuque ina'uqué uncá i'imalaño rile'ejena. ");
INSERT INTO ycn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Reja ne'emareja ñaqueja. Caja uncá nahue'epila Tupana nacojé. Ñaquejena jehuíña'atajeño necá. Mejluruna que necá. Pajluhuaja mejlurú pacóro'otacachu apú mejlurú, pajñacani na'acó ulahuí chojé rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","E Pedro quemari rijló: —¿Meque quemacánaca chi a'ajnejí ajñacana pimíchaje nacú? ");
INSERT INTO ycn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús quemari rijló: —¿Uncá caja chi pihue'epila? ");
INSERT INTO ycn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Iná a'á iná numá chojé a'ajnejí, iná ajñácaloje penaje. Rihuitúca'a iná julá chojé. Caja penaje ra'apá iná e'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Eyá iná numá chiyá iná quemá nacaje nacú, iná pechu nacú ri'imacá que. Pu'uhuaré péchuruna ina'uqué. ");
INSERT INTO ycn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aú calé nala'á pu'uhuaré napechu locópa'alaja. Pu'uhuaré péchuruna ne'emacale, ina'uqué i'ijnatá napéchuhua pu'uhuareni nacú. Pu'uhuaré péchuruna ne'emacale, nenó ina'uqué. Pu'uhuaré péchuruna ne'emacale, achiñana, inaana quele la'añó namanaicho pajhua'atéchaca. Pu'uhuaré péchuruna ne'emacale, nata'á ajopana liyá nanane. Pu'uhuaré péchuruna ne'emacale, majopeja napajlaca, nachapújra'aco ajopana nacú. ");
INSERT INTO ycn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Marí que la'acana aú ina'uqué la'añó pu'uhuaré, namanaicho hua'até. Uncá iná la'alá pu'uhuaré, uncachu iná a'alá iná nacojó peñahuilánami chuna puráca'alo. Uncachu iná ipala iná yáte'ela chiyá, nemacá que, iná ajñaca iná a'ajnehuá piyá, uncá iná la'alá pu'uhuaré raú —que Jesús jehuíña'ataca necá. ");
INSERT INTO ycn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","E caja Jesús i'ijnari reyá ají que Tiro, Sidón, quele te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Re pajluhuájaru i'imayo. Canaan te'eré eyájeru ru'umacá. Ru'ujná Jesús amaje, iphayo rahua'ajé. Jahuíyo'oqueja rumacá rijló: —Hue'emacana, Tupana huacára'acare majó ina'uqué i'imatájeri penaje picá. Pihue'epí numu'ují. Jiñá pechu nutu e'iyá. Chapú caje yajhué romaca raú —que rumacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Uncá Jesús ja'ajipalá rojló. E ra'apiyatéjena i'ijnaño rahua'ajé. Nemá rijló: —Pihuacára'a rupa'acó. Huápumi chu ro'opaca, cajrú huani rohuíyo'oca. ");
INSERT INTO ycn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","E Jesús quemari rojló: —Tupana huacára'ari nucá majó Israelmi chu laquénami ñaté a'ajé. Capichájeño necá Tupana liyá. Necaja calé ñaté a'ajeri nucá —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","E'iyonaja ru'ujná rijimaje. Rutára'o rijimaje ru'urúpachi aú. Rumá rijló: —Hue'emacana, pa'á nuñaté. ");
INSERT INTO ycn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Rimá rojló: —Uncá paala pan ña'acana Israelmi chu laquénami liyá, iná a'acáloje ricá ajopana te'eré eyájenajlo, yáhuinajlo penaje. (“Yáhuina” que judíona quemaqueño ajopana te'eré eyájena nacú.) ");
INSERT INTO ycn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Que jo'ó, Hue'emacana —que rumacá rijló—, yáhuina ajñaño caja pan mujrumi te'erí e'iyajé ja'acó. ");
INSERT INTO ycn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Raú Jesús quemari rojló: —¡Meque caphí huani pipechu nochojé! Pihuátaca queja ri'imajica pijló. Marí que rimacá rojló a'apona que Jiñá pechu jácho'oco rutu e'iyayá. Raú richuhuaja rutejmo'otaco. ");
INSERT INTO ycn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","E caja Jesús i'ijnari reyá. Ra'apá ají que caesa turenó. Galilea caesa ií. E rácho'o yenuri i'ihuata nacú. Re riyá'o. ");
INSERT INTO ycn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yenuri i'ihuata nacú riyá'aco ejé cajrú ina'uqué iphaca rinacu. Nahuá'a najhua'ató cajrú natámina. Uncá meño'ojó ne'iyajena ja'apálaño palá. Mejluruna ajopana i'imacá. Ajopana piño uncá pura'alaño. Ajopana piño i'imaño apicháca'alona. Que'iyapejé nayaripune i'imacá najló. Marí que yaripune i'imacaño nahuá'a Jesús chaje. Nato'otaque necá ri'imá nacojé, ritejmo'ótacaloje necá penaje. Ritejmo'óta piyuqueja necá que'iyapejé nayaripune liyá. ");
INSERT INTO ycn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Uncá pura'alaño penájenami pura'añó palá. Apicháca'alona i'imacaño penájenami pala'añó palá. Uncá ja'apálaño palá penájenami ja'apaño caja palá. Mejluruna penájenami amaño caja palá. Marí cajé aú napechu i'imá: “¡Meque piyuque huani la'acá ricá!” Palá napura'acó Tupana nacú raú. Tupana, Israelmi chu pechu i'imacare chojé caphí, nacú napura'ó palá. ");
INSERT INTO ycn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","E caja Jesús huá'ari ra'apiyatéjenajlo, ne'ejnacáloje richaje penaje. Rimá najló: —Nuhue'epí mariruna ina'uqué mu'ují. Caja hueji que cálicha nujhua'até necá. Caja na'ajné tajícharo. E'iyonaja uncá numalaje najló, napa'acóloje penaje. Apala uncá natejmú i'imalá, napa'acóloje me'epejí hua'até penaje. ");
INSERT INTO ycn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","E ra'apiyatéjena quemaño rijló: —Eta, ¿mere eyá chi huajña'ájla najló a'ajnejí? Iqui'iruna huani necá. Uncá nañacaré i'imalá maárohua. ");
INSERT INTO ycn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Rimá najló. —¿Me ca'alá pan maare? —Iyamá cuhuá'ata ca'alá, huejápaja jíñana le'epé hua'até —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","E rihuacára'a nayá'aco te'erí e'iyajé. ");
INSERT INTO ycn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Quéchami rijña'acá ricápojo iyamá cuhuá'ata ca'alá pan, jiña hua'até. E rimá Tupánajlo: —Palá pili'ichaca huecá marí a'ajnejí aú. Quéchami ritupa'ataca pan naquiyana najló. Ra'á ra'apiyatéjenajlo ricá, natamáca'atacaloje ina'uquejlo penaje. ");
INSERT INTO ycn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Piyuqueja necá ajñaño rinaquiyana namano'ocá ejé. Cuatro mil achiñana ajñaño na'ajnehuá inaana, yuhuaná quele hua'até. Achiñánaja calé nalapa'atá i'imacá. Uncá nalapa'atala inaana, yuhuaná, quele. Piyuque necá ajñaño na'ajnehuá re. Quéchami nahuacata rijlupemí. Iyamá cuhuá'ata ca'alá cuhuá'ala namano'otá pu'uteno huánija rijlupemí aú. ");
INSERT INTO ycn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nañapátaca na'ajnehuá ajñacana ejomi Jesús quemari najló napa'acóloje penaje. E rihuítuca'a jita chojé. Ne'ejná ají que Magadán te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariséona naquiyana, Saducéona naquiyana, quele necá i'ijnaño Jesús amaje. Nephá rinacu. Nahuata Jesús nacú quemacana: “Uncá Tupana huacára'acare calé ricá.” Aú naculácato rinacu. Nemá rijló, rila'acáloje najló nacaje, Tupánaja calé hue'epícare la'acana. ");
INSERT INTO ycn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","E rimá najló: —Amácachu querani je'echú jimá lainchu, imá: “Puji'iní ri'imajica muní” que. ");
INSERT INTO ycn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Amácachu lapiyami querani je'echú jimá juni suhuáca'ala hua'até cajrú, imá: “Uncá paala ri'imajica me'etení” que. Icá hue'epiño meque ri'imajica maárohua je'echú jimá amácana aú. Eta, nacaje nula'acare e'iyohuá amácana aú uncá ihue'epila meque quemacánaca ricá. ");
INSERT INTO ycn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Pu'uhuaré la'acaño icá. Uncá huátalaño Tupana icá, quemaño nojló nula'acáloje nacaje, uncá meño'ojó ina'uqué la'alare penaje. Marí aú ja ihue'epeje nucá. Jonasmi chujlo Tupana la'arí nacaje i'imacá. Rijló ri'imacá que caja ri'imajica piño nojló —que rimacá najló. Raú ra'apaña necá. ");
INSERT INTO ycn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Caja nacuhuá'a caesa pa'anajo pitá. Nephaca penaje ra'apiyatéjena hue'epiño uncá najña'alá pan najhua'ató. ");
INSERT INTO ycn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","E caja Jesús quemari najló: —Pa. Amá icó fariséona, saducéona, quele le'ejé pan amúra'atajona liyá. ");
INSERT INTO ycn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Raú ra'apiyatéjena quemaño pajlocaca necámica que: —Marí que rimíchaca huajló, uncá pachá huajña'alacha pan. ");
INSERT INTO ycn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús hue'epiri meque napechu i'imacá. E rimá najló: —¿Naje imá: “Uncá pan i'imalá huacapi”? ¡Meque huejápaja huani ipechu i'imacá nochojé caphí! ");
INSERT INTO ycn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Uncá jo'ó ihue'epila mecajeca nucá. ¿Uncá chi ihue'epila meque itamáca'ataca pajluhua té'ela ca'alá pan i'imacá, riphácaloje cinco mil ina'uqué nacojé penaje? ¿Me ca'alá cuhuá'ala imano'otá rijlupemí aú? ");
INSERT INTO ycn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Uncá caja chi ihue'epila meque itamáca'ataca iyamá cuhuá'ata ca'alá pan i'imacá, riphácaloje cuatro mil ina'uqué nacojé penaje? ¿Me ca'alá cuhuá'ala imano'otá rijlupemí aú? ");
INSERT INTO ycn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Numíchaca ijló i'imichaca: Pa. Amá icó fariséona, saducéona, quele le'ejé pan amúra'atajona liyá. Uncá nupura'aló pan nacú ilé que quemacana aú. ¿Naje uncá ihue'epílacha ricá? —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Marí que rimacá najló aú nahue'epí uncá rimalá najló, namácaloje necó nale'ejé pan amúra'atajona liyá penaje. E'iyonaja rimá najló na'acá piyá nanacojó napuráca'alo, jema'acaro cajrú ina'uqué e'iyohuá. ");
INSERT INTO ycn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","E caja nephá Cesarea Filipo te'eré nacojé. E Jesús quemari ra'apiyatéjenajlo: —Ina'uquéjloje penaje i'imacá nucá. ¿Meque ajopana ina'uqué quemacá nunacu? ");
INSERT INTO ycn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nemá rijló: —Ne'iyajena quemaño pinacu: “Juan bautizar la'ajeri ricá” que. Ajopana piño quemaño pinacu: “Elías ricá”. Ajopana piño quemaño: “Jeremías ca'ajná ricá”. Ajopana piño quemaño: “Apú Tupana puráca'alo ja'apátajeñomi chuna naquiyánami ca'ajná ricá”. ");
INSERT INTO ycn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Eyá Jesús quemari najló: —Eta icá ta, ¿Meque imacá nunacu? ");
INSERT INTO ycn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro quemari rijló: —Picá Tupana huacára'acare majó ina'uqué i'imatájeri penaje. Re Tupana. Uncá majopeja calé riyucuna. Re ricá, Ri'irí picá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Pedro, Jonás i'irí picá. Palá pihue'epica nucá —que Jesús quemacá—. Uncá ina'uqué liyá calé pihue'epí ricá. Nora'apá, je'echú chu i'imacare, liyá pihue'epí ricá. ");
INSERT INTO ycn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Picá Pedro. Jipa quemacana pií. No'opiyá jema'ajeño i'imajeño picá que caja caphí nochojé. Uncá taca'acaje chá'atalaje no'opiyá jema'ajeño. Matajnaco ne'emajica je'echú chu nujhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Je'echú chu i'imacaño huacára'ajeri Tupana. No'ojé pijló rinumaná me'etájona. Nacaje pepo'ocare marí eja'ahuá chu i'imajeri caja jepo'oqueja je'echú chu. Nacaje picaráca'acare marí eja'ahuá chu, i'imajeri caja caráca'aqueja je'echú chu —que rimacá Pédrojlo. ");
INSERT INTO ycn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ejomi rihuacára'a ne'emacá piyá ajopánajlo riyucuna. Uncá rihuátala nemacá ajopánajlo Tupana huacára'aca ricá ina'uqué i'imatájeri penaje. ");
INSERT INTO ycn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ricá pumí chiyó Jesús quemari ra'apiyatéjenajlo meque nala'ajica ricá chapú. Rimá najló: —Tupana huacára'ari nucá Jerusalén ejo. Re peñahuilana, sacerdótena, Tupana puráca'alo nacú jehuíña'atajeño, quele la'ajeño nucá chapú. Nenoje nucá. E'iyonaja hueji que cala i'imajemi numacápo'ojo piño —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","E Pedro huá'ari Jesús apojó quemachi. Raca'á ricá, rimá rijló: —Eco Tupana hue'epí pimu'ují. ¡Uncá huani nala'alaje ilé que picá! ");
INSERT INTO ycn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Raú Jesús pajno'oró riyámajo. E rimá Pédrojlo: —¡Pa'apá nuliyá, Satanás! Nunacu cahuíla'ajeri picá. Uncá Tupana pechu que calé pipechu. Ina'uqué pechu que caja pipechu. ");
INSERT INTO ycn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ejomi rimá piño piyuque ra'apiyatéjenajlo: —Marí que ricá ijló, huátaño nujhua'atéjena i'imacana: Nenoje ca'ajná icá, nujhua'atéjena i'imacale jimaje. Ihue'epíniya inacuhuá. Jácho'oniyo caja nujhua'atéjena i'imacana chiyá rijimaje. ");
INSERT INTO ycn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ina'uqué naquiyana hue'epiño caí nanacuhuá. Uncá nahuátala ajopana la'acá necá chapú. Ñaquele uncá ne'emalá nujhua'atéjena. Marí que i'imacaño capichájeño Tupana liyá. Eyá uncá hue'epílaño caí nanacuhuá, ne'emacáloje nujhua'atéjena penaje, i'imajeño matajnaco je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Uncá na penaje calé inajlo, iná ña'aquela inajluhua piyuque nacaje marí eja'ahuá chu i'imacare, iná capichácojla Tupana liyá rilanaquiya. Iná capichácochu Tupana liyá, uncá meño'ojó iná a'alá nacaje marí eja'ahuá chu i'imacá, iná capichaco piyá Tupana liyá. ");
INSERT INTO ycn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ina'uquéjloje penaje i'imacá nucá. Eja'ahuá tajnájico huacajé, nucá huaícha piño majó Nora'apá hua'atéjena, je'echú chu i'imacaño hua'até. Cajrú mejáma'atani huanacu que nuphájica majó. Rihuacajé no'ojé piyuqueja ina'uquejlo nacaje nala'acare huemí. ");
INSERT INTO ycn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pa. Re e'iyajena maare, uncá chiyó itaca'á, icá amájeño nucá ina'uqué naquiyana huacára'ajeri. Ina'uquéjloje penaje i'imacá nucá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Marí que rimacá najló i'imacá. E caja pajluhua cuhuá'ata que cala ejomi Jesús jácho'oro ipuré i'ihuátaje. Rihuá'a rijhua'ató Pedro, Santiago, re'ehué Juan, queleja rihuá'a rijhua'ató. Nephá rejo. ");
INSERT INTO ycn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ejéchami Jesús jimá apiyácaco najimaje. Mejáma'atani, camú camaré que rijimá amaco. Jareni huani, mejáma'atani que huani ra'arumacá amaco rinacojé. ");
INSERT INTO ycn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Rijhua'até namá Moisesmi chu, Elíasmi chu, quele. Najhua'até ripura'ó. ");
INSERT INTO ycn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Raú Pedro quemari Jesusjlo: —Hue'emacana, ¡meque palá huani huecá maare! Pihuátajica ee, huala'ajé hueji quele ca'apejé maare. Pajluhuala huala'ajé pijló, apalá Moisesjlo, apalá Elíasjlo. ");
INSERT INTO ycn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Marí que Pedro quemacá. Hua'ató que caja juni suhuáca'ala jareni itaca nachá. Re'iyayá Tupana quemari najló: —Marí Nu'urí, íqui'ija nuhuátacare. Palá huani nupechu rinacu. Jema'á ra'apiyá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Marí que rimacá aú ra'apiyatéjena láma'año pajima'aló te'erí e'iyajé. Cajrú huani naquero'ocó. ");
INSERT INTO ycn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","E Jesús i'ijnari nahua'ajé. Ritujla'á necá huejápaja riyáte'ela aú. —Jácho'o, iquero'oniyo —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","E nácho'o. Nayacá'o, uncá na namala. Ricaja calé, Jesús, namá. ");
INSERT INTO ycn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","E caja nahuitúca'a ipuré naquiyá. E Jesús quemari najló: —Pa. I'imaniya huajé amíchaje yucuna ajopánajlo. Numacápo'ojico ejomi i'imajé riyucuna ajopánajlo. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","E ra'apiyatéjena quemaño rijló: —Tupana puráca'alo nacú jehuíña'atajeño quemaño Elíasmi chu nacú: “Ricá huaícha majó pamineco. Ricá Tupana huacára'ajicare majó ina'uqué i'imatájeri penaje tucumá riphaje”, que nemacá rinacu. ¿Naje chi nemá ilé que? ");
INSERT INTO ycn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Rimá najló: —Que jo'ó ri'imacá. Ripa'atácaloje piyuque nacaje rapumí chojé penaje riphá majó i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Jema'á marí: Caja Elías iphari majó nutucumá i'imacá. E'iyonaja uncá nahue'epila ricá ri'imacá. Napechu queja nala'acá ricá chapú i'imacá. Nucá piño nala'ajica chapú. Nucá, i'imacá ina'uquéjloje penaje, ña'ajeri chapú caje yajhué panacu —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Marí que rimacá aú ra'apiyatéjena hue'epiño rimacá Juan bautizar la'ajérimi chu nacú i'imacá: “Caja Elías iphari majó i'imacá,” que rimacá Juan bautizar la'ajérimi chu nacú i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","E caja nephá ina'uqué nacojé. E pajluhuaja nanaquiyana i'ijnari Jesús jimajo. Ritára'o ri'irúpachi aú rijimaje; rimá rijló: ");
INSERT INTO ycn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Pihue'epí nu'urí mu'ují. Apú eyá, apú eyá que ritaca'ataco. Chapú caje yajhué huani ramaca raú. Apú eyá que ra'acó siyá chojé; apú eyá que ra'acó junápeje ca'ajná. ");
INSERT INTO ycn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Majó nuhuá'icha ricá pa'apiyatéjena chaje, natejmo'ótacaloje ricá penaje. Uncá meque nala'alacha ricá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","E Jesús quemari ra'apiyatéjenajlo: —¡Meque uncá huani ipechu i'imalá Tupana chojé caphí! Pu'uhuaré la'acaño icá. ¿Me quetana júpica nujña'ajica icá panacu? Ihuá'icha ricá majó —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","E nahuá'a ricá rijimajo. E Jesús aca'arí jiñá pechu re'iyá i'imacare. Raú rica'á ricá re'iyayá. Aú caja ritejmo'otó. Peyajhueni ri'imacá reyá a'ajná ño'ojó. ");
INSERT INTO ycn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Quéchami ra'apiyatéjena pura'añó Jesús hua'até necámica que. Nemá rijló: —¿Naje uncá meño'ojó huaca'alacha re'iyayá jiñá pechu? ");
INSERT INTO ycn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Rimá najló: —Huejápaja ipechu i'imacale caphí Tupana chojé, uncá ica'alacha re'iyayá ricá. Jema'á marí: Camu'ujuni mostaza ijí. Ñaqué caja huejápaja ipechu i'imaquela Tupana chojé caphí, imajla marí que ipurejlo: “Patató a'ajná ño'ojó” que. Raú ratatojla a'ajná ño'ojó. Ipechu i'imajica ee caphí Tupana chojé, ila'ajé piyuqueja nacaje ñaqué caja. ");
INSERT INTO ycn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Iná ca'acá ilé caje jiñá pechu ina'uqué e'iyayá yámona, iná pura'ó Tupana hua'até, iná i'itaó caja iná a'ajné liyá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","E caja Jesús ja'apiyatéjena jahuacaño rijhua'até Galilea te'eré e. Jesús quemari najló: —Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Na'ajé nupinánajlo nucá, nenócaloje nucá penaje. Nenoje nucá. E'iyonaja hueji que cala i'imajemi numacápo'ojo piño nopumí chuhuá. Marí que rimacá najló aú camu'ují huani napechu la'acó. ");
INSERT INTO ycn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","E caja Jesús iphari rijhua'atéjena hua'até Capernaum ejo. Re ajopana i'ijnaño Pedro chaje. Liñeru naquejá'a ina'uqué liyá Tupana ñacaré chojé penaje. E caja nephá Pedro nacú. Nemá rijló: —¿Uncá chi jehuíña'atajeri a'alá liñeru Tupana ñacaré chojé penaje? ");
INSERT INTO ycn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—A'a, ra'á ricá —que Pedro quemacá. E rimujlúca'a pají chojé. E Jesús quemari rijló: —Pedro, ¿Meque pipechu marí nacú? ¿Na liyá chi nahuacára'ajeño, marí eja'ahuá chu i'imacaño, huacára'año liñeru ña'acana? ¿E nahuacára'aca rijña'acana najhua'atéjena liyá ca'ajná, ajopana te'eré eruna liyá ca'ajná? ");
INSERT INTO ycn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro quemari rijló: —Ajopana te'eré eyájena liyá najña'á ricá. Jesús quemari rijló: —Que jo'ó ricá. Uncá najhua'atéjena calé a'añó najló liñeru. ");
INSERT INTO ycn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Uncá naje calé no'ó najló liñeru, Tupana hua'ateje nu'umacale. E'iyonaja calé no'ojé najló liñeru, napechu i'imacá piyá chapú nunacu. Ñaquele pi'ijná caesa ejo. Piqui'ichá ana'ajori junápeje. Chíra'ajeri pamineco, pijña'á ricá. Rinuma chu piphátaje liñeru. Naquejá'acare nuliyá, piliyá hua'até huemí locópa'ala ri'imajé. Quéchami pi'ijnajica najló ra'ajé. —Je —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Quéchami Jesús ja'apiyatéjena i'ijnaño Jesús ahua'ajé. Nemá rijló: —¿Na chá'atari pijhua'atéjena e'iyayá nacaje la'acana aú. ");
INSERT INTO ycn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","E Jesús huá'ari pajluhuaja yuhuajijlo. Rimá rijló: —Majó pi'ijná. E riphá nanacu. E rihuá'a ricá ne'iyá pe'iyoyá. ");
INSERT INTO ycn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","E rimá ra'apiyatéjenajlo: —Jema'á marí. Uncá yuhuaná la'alaño necó chá'atajeño que. Uncaja que ipajno'otá ipéchuhua chá'atacaje liyá, uncá i'imalaje nujhua'atéjena. ");
INSERT INTO ycn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Uncá la'alá ricó chá'atajeri que huani, i'imari ajopana nujhua'atéjena chaje. Marí yuhuají pechu i'imacá rinacuhuá, que caja ripechu rinacuhuá. ");
INSERT INTO ycn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Apú ca'ajná huátari marí caje yuhuají, nujhua'ateje ri'imacale. Aú iná hue'epí rihuátaca caja nucá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Chapú huani ri'imajica najló, amátaño no'opiyá jema'ajeño pu'uhuaré la'acana aú, namanaicho la'acana aú. Naca'aquela namátajeño junápeje, cajruni jipa jepo'oqueja nanúru'upi nacojé hua'ató, palani ri'imacajla najló. Marí que nala'acana i'imárijla palani, chapú caje yajhué namájicare ijlunami chojé. ");
INSERT INTO ycn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","’Uncá huani paala marí eja'ahuá, cajrú nacaje i'imacale richu, ina'uqué la'acáloje pu'uhuaré raú penaje. Caja queja ri'imajica marí eja'ahuá chu. Chapú huani ri'imajica ileruna ina'uquejlo, a'añó ajopánajlo nacaje ca'ajná, la'añó nacaje ca'ajná, ajopana la'acáloje pu'uhuaré, namanaicho raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Ñaqué i'imacale pila'á ca'ajná pu'uhuaré pila'acare piyáte'ela aú pachá, piyurí piliyó ricá. Pila'á ca'ajná pu'uhuaré meño'ojó pi'ijnacá pachá, piyurí piliyó ricá. Pimata'aquela pinaquiyó piyáte'ela ca'ajná, pi'imá ca'ajná, pica'acáloje ricá a'ajná ño'ojó penaje, palani ri'imacajla pijló. Pila'aquela marí que, pi'ijnacá piyá quera'atani uncá yacálare chojé, palani ri'imacajla pijló. ");
INSERT INTO ycn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pila'á ca'ajná pu'uhuaré nacaje pamácare pachá, piyurí piliyó ricá. Picahuícha'aquela pijlú majó, pica'acáloje ricá a'ajná ño'ojó que penaje, palani ri'imacajla pijló. Pila'aquela marí que, pi'ijnacá piyá quera'atani uncá yacálare chojé, palani ri'imacajla pijló. ");
INSERT INTO ycn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ipechu i'imaniya yuhuaná, no'opiyá jema'ajeño, nacú majopéjaruna que necá. Re nahua'aphena. Tupana hua'atéjena, je'echú chiyájena, necá nahua'aphena. Nora'apá, je'echú chu i'imacare, ahua'á i'imacaño necá. ");
INSERT INTO ycn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ina'uquéjloje penaje i'imacá nucá. Nu'umatácaloje no'opiyá jema'ajeño capichácajo liyá penaje, nuphá majó i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Re ca'ajná pajluhuaja ina'uqué. Cien ohuéjana ripirana. Apala pajluhuaja nanaquiyana capicharo ajopana e'iyayá. Paminá amaca aú uncá ri'imalá ajopana hua'até, rimá: “¿Meque ca'ajná rila'acó?” que. Riyurijla ajopana noventa y nueve na'ajnehuá ajñacana nacú yenuri pu'uteni chu. Ra'apáñajla necá, riculácaloje ricá pajluhuaja nanaquiyana capichaco i'imacá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Riphátacana aú pu'ují ripechu i'imacá rinacu. Ajopana chaje pu'ují ripechu i'imacá capicharo nacú riphátacana aú. ");
INSERT INTO ycn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ñaqué caja, Jara'apá, je'echú chu i'imacare. Uncá caja rihuátala yuhuaná, ra'apiyá jema'ajeño naquiyana, capichaco. ");
INSERT INTO ycn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Apú la'acachu picá chapú, pipura'ó rijhua'até icámica que. Pimá rijló na aú ca rila'acá picá chapú. Ra'ajica ee pipuráca'alo rinacojó, ri'imajó capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Uncaja que ra'á rinacojé pipuráca'alo, pihuá'a pijhua'ató apú, ajopana iyamá ca'ajná, nema'acáloje méqueca rimacá pijló penaje. Raú ajopana hue'epéjeño caja méqueca rimacare nacú pijló. ");
INSERT INTO ycn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Uncaja que ra'á rinacojó pipuráca'alo ajopana hua'até, pi'imá riyucuna Tupana ja'apiyá jema'ajéñojlo jahuacáca'alo ñacarelana chu. Uncaja que ra'á rinacojó napuráca'alo, ica'á e'iyayó ricá. Ihue'epí caja rinacu uncá jema'alare Tupana ja'apiyá que. Ihue'epí caja rinacu liñeru ña'ajeño ne'emacánajlo naquiyana que. Uncá ina'uqué huátalarena necá. ");
INSERT INTO ycn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jema'á marí: Ileruna imacárena nacú, ihuajácaloje necá pu'uhuaré nala'acare chona penaje, caja queja Tupana quemacá nanacu ijhua'até. Ileruna amácarona chaje pu'uhuaré nala'acare liyá, ñaqué caja Tupana amaco ijhua'até nachaje. ");
INSERT INTO ycn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Marí que ricá piño ijló: Iyamá icá ca'ajná, ipechu i'imajé ca'ajná panacojéchaca que nacaje la'acana nacú. Aú ipura'ajó Tupana hua'até pajhua'atéchaca, ra'acáloje iñaté penaje. Nora'apá, je'echú chu i'imacare, a'ajeri ijló nacaje iquejá'ajicare riliyá, panacojéchaca que ipechu i'imajica ee rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Iyamá ca'ajná, hueji quele ca'ajná, no'opiyá jema'ajeño jahuacaño, napura'acóloje nujhua'até penaje, nahue'epícaloje nucá penaje. Raú nupechu i'imari caja najhua'até re —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","E Pedro i'ijnari Jesús ahua'ajé. Rimá rijló: —Huehuíña'atajeri, apú la'acachu iná chapú metú que huani. ¿Meque pe iná amaco richaje? ¿Iyamá cuhuá'ata que pe ejé chi palani? ");
INSERT INTO ycn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—Uncá —que Jesús quemacá—. Uncá iná amalo nachaje iyamá cuhuá'ata que pe ejeja. Ñaqueja iná amaco nachaje. ");
INSERT INTO ycn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ñaquele nujhua'atéjena amaño ajopana chaje, chapú nala'acare necá liyá. Chuhua nu'umajica yucu, ihue'epícaloje rinacojé raú penaje. Ne'emacana i'imichari. Rijhua'até sápajeño lehuérichaño rijló cajrú liñeru aú. Ñaquele rihuá'icha namaná, rilamá'atacaloje najhua'até nalehuérichaje rijló penaje. ");
INSERT INTO ycn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Caja rilamá'achiya ne'iyajena hua'até. Eyá apú rijhua'até sápajeri iphíchari rinacu. Cajrú huani, íqui'i huani rilehuérichaca rijló. ");
INSERT INTO ycn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Uncá meque la'ajé ra'aláchajla rijló rilehuérichaje huemí. Aú ricarihuate quemíchari ajopana rijhua'atéjenajlo marí que: “Marí ina'uqué lehuérica nojló cajrú huani. Eco a'á ricá ajopánajlo rihuemí penaje, risápacaloje najhua'até re mahuemiru penaje. Ñaqué caja a'ajica ajopánajlo rinane rihuemí penaje. Ñaqué caja a'ajica riyajalo, riyani quele nahuemí penaje, nasápacaloje najhua'até mahuemiru penaje. Marí caje aú liñeru jácho'orojla rijló, rilehuéricare huemí penaje”, que rimíchaca najló. ");
INSERT INTO ycn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Marí que rimíchaca rinacu aú rijhua'até sápajeri tári'icharo ri'irúpachi aú ricarihuate jimaje. Mahuoja rimíchaca rijló: “Nucarihuate, piyúcha'aniyo nuchá. Quéchamico no'ó pijló rihuemí”. ");
INSERT INTO ycn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Marí caje aú ricarihuate hue'epíchari rimu'ují. Ramó richaje. Rilamá'achiya rijló rilehuérichaje aú rijló. Caja uncá rilehuérilacha rijló reyá a'ajná ño'ojó. ");
INSERT INTO ycn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Rejéchami ra'apíchaca ricarihuate liyá. Mequetana i'imajemi ripháchiya piño apú. Ricá lehuérichari rijló huejápaja. Ricarihuate hua'até sápajeri caja ri'imichaca. Ramíchaca ricá ee ripachiya ricá rinúru'upi naquiyá camachá. Riqueño'ochá rinúru'upi ajño'ocana; rimicha rijló: “Chuhua pa'ajica nojló piyuque pilehuéricare ta”. ");
INSERT INTO ycn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Eja ritári'icho rijimaje ri'irúpachi aú. Mahuó rimíchaca rijló: “Piyúcha'aniyo nuchá. Quéchami no'ojica pijló rihuemí piyuqueja”. ");
INSERT INTO ycn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Uncá” que rimíchaca. E ri'ijichá ajopánajlo riyucuna i'imajé, naca'acáloje ricá ina'uqué huajáquelana chojé penaje. Nahuajácaloje ricá, ra'acáloje rijló rilehuéricare huemí penaje. ");
INSERT INTO ycn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ajopana, ricarihuate hua'até sápajeño, amíchaño meque nali'ichaca ricá. Chapú huani ri'imichaca nanacu. Aú ne'ejichá riyucuna i'imajé nacarihuátejlo. ");
INSERT INTO ycn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aú ja ricarihuate huá'ichari rimaná. Riphicha rinacu; rimicha rijló: “Meque picá ta nujhua'até sápajeri, uncá huani ina'uquélari ta. Nucá amícharo pichaje. Nulamá'achiya picá pilehuéricare aú. Mahuó pimíchaca aú nojló, nomicho pichaje pilehuéricare nojló chiyá. ");
INSERT INTO ycn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Palánijlaca pihue'epícajla quele lehueri pijló mu'ují, nuhue'epíchaca pimu'ují que caja”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Iqui'ija huani ricarihuate yúchi'ichaco richá. Aú rihuacári'icha rihuajácana, ra'acá rijló cajrú huani rilehuéricare huemí ejená. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Marí que Jesús i'imacá yucu. Caja penaje rimá: —Ñaqué caja Nora'apá, je'echú chu i'imacare, la'ajica necá, uncá amálaño ajopana chaje, chapú nala'acare necá liyá. ");
INSERT INTO ycn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Caja ri'imá najló yucu. Ejomi ri'ijná Galilea te'eré eyá ají que Judea te'eré ejo. Juni Jordán pa'anajo pitá ejé riphá. ");
INSERT INTO ycn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cajrú ina'uqué chira'acó rijhua'até. Re ritejmo'óta natámina. ");
INSERT INTO ycn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eyá fariséona naquiyana i'ijnaño Jesús chaje. Nahuata nacaje yucuna quejá'acana riliyá, namácaloje méqueca rimacá najló penaje. Nemacáloje rinacu: “Majopeja ripajlaca” que penaje. E nemá rijló: —¿E Tupana yurica iná cupaca iná yajalo, iná huátaca que? ");
INSERT INTO ycn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Rimá najló: —Tupana puráca'alo lana'aquéjami amácare caja quemari marí que: “Tupana queño'ótaca eja'ahuá huacajé, riqueño'óta caja ina'uqué achiñá, inanaru hua'até”. ");
INSERT INTO ycn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Ñaquele achiñá anúca'aro richi'iná liyá rihuá'acaco ejomi, ri'imacáloje riyajalo hua'até penaje. Ne'emajé pajhua'atéchaca pajluhua japi necá queja”, que ripuráca'alo lana'aquéjami quemacá. ");
INSERT INTO ycn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Uncá iyamá ina'uqué calé huá'acajeñomi. Pajluhua japi necá queja necá pajhua'atéchaca. Marí que ri'imacale, uncá paala nayurica pecohuácaca. Caja Tupana la'arí necá, ne'emacáloje pajluhua japi necá queja pajhua'atéchaca penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","E nemá piño rijló: —Eta, Moisesmi chu quemari: Iná yurijla iná yajalo, iná a'acachu rojló papera lana'aquéjami. Richu iná quemá na pachaca iná yurica iná yajalo. ¿Na penaje chi rimá ilé que i'imacá? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Rimá najló: —Ijnú huani nema'acá Tupana ja'apiyá rihuacajé, a'acuhuaná nahuata naluna yurícana. Pamineco chiyó uncá ñaqué calé ri'imacá ina'uquejlo. ");
INSERT INTO ycn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Marí que numacá rinacu: Re ca'ajná apú yajalo, uncá rula'alá rumanaicho apú hua'até. Riyurícachu rucá, rihuá'acacoloje apa'ahuelo hua'até rulanaquiya penaje, rila'á rimanaicho raú. Apa'ahuelo hua'até la'acana queja caja ricá Tupánajlo. Apú ca'ajná huá'acaro riyajalo penájerumi hua'até. Ricá caja la'arí caja rimanaicho raú. Apa'ahuelo hua'até la'acana queja caja ricá Tupánajlo, apú yajalo jo'ó ru'umacale rijló —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","E caja ra'apiyatéjena quemaño rijló: —Marí que ri'imacale, palani ca'ajná uncá iná huá'acalo. ");
INSERT INTO ycn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús quemari najló: —Uncá piyuque ina'uqué hue'epílaje meque quemacánaca numájicare nacú me'etení. Tupana a'arí ina'uqué naquiyana ñaté, nahue'epícaloje ricá penaje. Necaja calé hue'epiño ricá. ");
INSERT INTO ycn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Re achiñana naquiyana uncá paala necá, nahuá'acacoloje penaje. Ajopana piño i'imaño ñaqué caja, ajopana pachá. Ajopana piño huátaño Tupana huátaca que la'acana hue'epícana natucumó. Aú calé uncá nahuá'acalo. Huátari marí numacare nacú jema'acana no'opiyá, jema'ajeri ricá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ajopana huá'año Jesús ejo yuhuaná, rito'otácaloje riyáte'ela nanacojé penaje, ripura'acóloje Tupana hua'até nanacu penaje. E'iyonaja ra'apiyatéjena ahuíyo'oño najló richá, nahuá'aca piyá richaje necá. ");
INSERT INTO ycn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","E Jesús quemari najló: —Reja yuhuaná i'ijnareja nuchaje. Itániya napu najló. Yuhuaná que i'imacaño i'imaño caja Tupana hua'atéjena. Nahuacára'ajeri ricá. ");
INSERT INTO ycn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Rito'otaca riyáte'ela nanacu ejomi ri'ijná reyá. ");
INSERT INTO ycn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pajluhuaja hualijímaca i'ijnari Jesús amaje. Rimá rijló: —Ina'uqué jehuíña'atajeri picá, palani picá —que rimacá rijló—. ¿Meque nula'acajla, nu'umacáloje matajnaco Tupana hua'até je'echú chu penaje? ");
INSERT INTO ycn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús quemari rijló: —¿Naje pimá nunacu: “Palani” que? Ricaja calé, Tupana, palani. Uncá palani calé ina'uqué. Pihuátajica ee matajnaco je'echú chu i'imacana, pila'á Tupana puráca'alo quemacá que. ");
INSERT INTO ycn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Raú ilé hualijímaca quemari rijló: —¿Mecaje chi pimá nacú? Jesús quemari rijló: —Pinóniya ina'uqué; pila'aniya pimanaicho; pata'aniya; pipajlániya; ");
INSERT INTO ycn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","piphá pichi'iná ja'apí; pihuata ajopana ina'uqué pihuátaca picó que caja —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","E rimá rijló: —Caja nujyuhuaco noma'á ra'apiyá maáreje cha. ¿Na yurico ejo'ocaja, nula'acáloje penaje? ");
INSERT INTO ycn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús quemari rijló: —Pihuátajica ee lamára'ataquejami que i'imacana Tupánajlo, pipa'ó piñacaré chojé. Eco pa'atá ajopánajlo pinane piyuqueja rihuemí aú, liñeru i'imacáloje pijló penaje. Quéchami pa'ajica piyuqueja piliñérute camu'ují la'acáñojlo. Marí que la'acana aú nacaje palá nojé i'imajé pijló je'echú chu. Quéchami pipa'ajico piño majó, pi'ijnacáloje nujhua'até no'opiyateje penaje. ");
INSERT INTO ycn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Marí que rimacá rijló aú camu'ují huani ripechu la'acó. Uncá ra'alá rinacojó ripuráca'alo, cajrú le'ejepelari ri'imacale. Aú caja ripa'ó. ");
INSERT INTO ycn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","E Jesús quemari ra'apiyatéjenajlo: —Jema'á marí. Puhuichani huani cajrú le'ejepelárunajlo nachó yurícana Tupánajlo, ri'imacáloje Nahuacára'ajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Numá piño: Puhuichani caméllonajlo luhuirí aphú chiyá ja'apácana. Richaje puhuichaca cajrú le'ejepelárunajlo nachó yurícana Tupánajlo, ri'imacáloje Nahuacára'ajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Marí que rimacá aú ra'apiyatéjena pechu i'imá: “Uncá huani ca'ajná Tupana i'imatala ina'uqué capichácajo liyá.” E nemá pajlocaca: —¿Mecajena ca'ajná Tupana i'imatájeri rijluhua capichácajo liyá? ");
INSERT INTO ycn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","E Jesús yacá'aro nachaje. Rimá najló: —Uncá meño'ojó ina'uqué i'imatala necó capichácajo liyá. Tupánaja calé i'imatari ina'uqué capichácajo liyá. Ricá hue'epiri piyuqueja nacaje la'acana. ");
INSERT INTO ycn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","E Pedro quemari rijló: —Huahuacára'ajeri, huecá yuriño piyuqueja huanane, hue'ejnacáloje pijhua'até penaje. ¿Meque ri'imajica huajló, marí que huala'acale? ");
INSERT INTO ycn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús quemari najló: —Jema'á marí: Huajé eja'ahuá i'imajica piño. Rihuacajé nucá i'imajeri piyuque ina'uqué huacára'ajeri. Ina'uquéloje penaje i'imacá nucá. Palá huani nuhuacára'ajica ina'uqué rihuacajé. Icá caja, no'opiyatéjena, huacára'ajeño caja nujhua'até. Re ñáca'ajori nahuacára'ajeñojlo. Iyamá iphata ji'imaji nacojé quele ricá. Icá yá'ajeño richu, imacáloje icá'ana nacú mecajenaca necá penaje. Iyamá iphata ji'imaji nacojé quele Israelmi chu laquénami a'ajútayami chuna i'imacá. Necá, icá'ana nacú imaje. ");
INSERT INTO ycn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Eyá marí que i'imacaño ina'uqué naquiyana me'etení, nala'acáloje nuhuacára'aca que penaje, ina'uqué naquiyana i'ijnañáaño nañacaré ca'ajná, nejena ca'ajná, nachi'iná ca'ajná, nate'eré ca'ajná. Nayani caja ñapácaño ca'ajná ne'ejnañáa, nala'acáloje nuhuacára'aca que penaje. Palá huani ri'imajica marí que la'acáñojlo. Ñó'ope caja Tupana a'ajica nañaté. Tupana a'ajeri caja necá, ne'emacáloje matajnaco je'echú chu rijhua'até penaje. ");
INSERT INTO ycn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Re cajrú ina'uqué naquiyana, me'etení i'imacaño, napechu i'imá nanacuhuá: “Ajopana chaje Tupana la'ajeri huecá palá” que. Uncá ñaqué calé ri'imajica najló. Tupana la'ajeri necá ajopana ja'apejé palá. Re cajrú ina'uqué naquiyana me'etení i'imacaño, napechu i'imá nanacuhuá: “Ajopana ja'apejé ca'ajná Tupana la'ajeri huecá palá” que. Uncá ñaqué calé ri'imajica najló. Tupana la'ajeri necá ajopana chaje palá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús quemari najló: —Ina'uqué naquiyana huacára'ajeri Tupana. Chuhua nu'umajica yucu ijló, ihue'epícaloje méqueca ricá penaje. Pajluhuaja ina'uqué i'imichari. Cajrú rimena i'imichaca. Re'iyá cajrú cajmú caje i'imichaca, epepí que rina i'imichaca. E lapiyami paminá i'ijichari ina'uqué culaje, nasápacaloje rimena e'iyá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","E ripháchiya huejápaja. Rimicha najló: “Icá sápajeño numena e'iyá. No'ojé ijló pajluhuata denario isápaca'ala huemí”. “Je” que nemíchaca. E rihuacári'icha necá rimena e'iyajé sapaje. ");
INSERT INTO ycn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Quéchami pe'iyochá camú jácho'oco ee ramicha piño ajopana le'ejepelaji ñacarelana ahua'á. Majopeja ne'emichaca. ");
INSERT INTO ycn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Necajlo rimicha: “I'ijná numena e'iyajé, isápichachi nujhua'até richa ña'acana nacú. Palá no'ojica ijló isápaca'ala huemí”, que rimíchaca najló. “Je” que nemíchaca. E ne'ejichá sapaje. ");
INSERT INTO ycn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Caápu'ucu ri'ijichá piño ina'uqué culaje; amíchari piño ajopana. Ñaqué caja rimíchaca najló. Pe'iyochá camú to'ocó ee ri'ijichá piño; amíchari piño ajopana. Ñaqué caja rimíchaca najló. ");
INSERT INTO ycn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","E lainchu, las cinco riji'ichá piño le'ejepelaji ñacarelana ejo. Amíchari piño ajopana. Majopeja ne'emichaca. E rimicha najló: “¿Naje icapicháchiya hue'echú ca'alá, uncale isápalacha?” Nemicha rijló: ");
INSERT INTO ycn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Uncá na calé a'achari huajló sápacaje”. E rimicha najló: “I'ijná numena e'iyajé, isápichachi nujhua'até”. “Je”. ");
INSERT INTO ycn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","E caja najúhui'icha. E paminá quemíchari rijhua'até sápajeño amájerijlo: “Chuhuata pihuá'icha necá majó, pilamá'atachi najló nasápaca'ala, pa'achí najló rihuemí. Ileruna, caja penaje iphíchacañojlo pilamá'ataje nasápaca'ala huemí pamineco. Natucumá iphíchacañojlo pilamá'ataje nasápaca'ala huemí caja penaje”, que rimíchaca rijló. “Je” que rimíchaca. ");
INSERT INTO ycn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","E caja nephicha sápajemi. Lainchu, las cinco, iphíchacañojlo ra'achá pajluhuata denario. Pajluhua cala sápacana huemí ejé ra'achá najló rihuemí. ");
INSERT INTO ycn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ñaqué caja ra'achaca ajopánajlo, ajopánajlo que nasápaca'ala huemí. E'iyonaja necá, lapiyami queño'ochácaño ajopana tucumá sápacana, necá pechu i'imichá: “Richaje japi ra'ajica huajló rihuemí”. E'iyonaja rejeja caja ra'achaca najló rihuemí. ");
INSERT INTO ycn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Raú naqui'ichá paminá maná. ");
INSERT INTO ycn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Nemicha: “Caja penaje iphíchacaño, sápichaño pajluhuaja camú jená quetánaja calé. E'iyonaja ra'achá najló rihuemí rejeja caja. Ra'achaca huajló rihuemí, que caja ra'achaca piño najló rihuemí. Huecá sápichaño ima'á huaca i'imichaca. Ima'aní yajhué huaji'ichá panacu chuhuajá quetana i'imichaca”. ");
INSERT INTO ycn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Paminá jemi'ichari méqueca nemíchaca pajlocaca rinacu. Aú rimicha pajluhuaja nanaquiyánajlo: “Uncá nula'alacha icá chapú. Numicha ijló i'imichaca: ‘No'ojé ijló pajluhuata denario’. Aú imicha: ‘Je’ que. Numíchaca ijló queja nujhua'até sápajeño amájeri a'achaca ijló rihuemí. ");
INSERT INTO ycn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chuhua pipa'ó ra'achaje pijló hua'até. Rejeja caja nuhuáchiyaca rihuemí a'acana caja penaje iphíchacañojlo. ");
INSERT INTO ycn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nula'á nuhuátaca que nuliñérute hua'até. Uncá na calé jahuíyo'ori nojló richá. ¿Chapú chi pihuó nuchá mamejajné no'ochaca najló ri'imichaca aú?” que paminá quemíchaca rijló. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Marí que ri'imacá yucu najló. Ejomi rimá najló: —Ñaqué caja Tupana la'acá rihuátaca que. Ajopana pechu i'imá ca'ajná nanacuhuá: “Ajopana ja'apejé Tupana la'ajica huecá palá” que. Necá Tupana la'ajeri ajopana chaje palá je'echú chu. Eyá ajopana piño pechu i'imá ca'ajná nanacuhuá: “Ajopana chaje Tupana la'ajica huecá palá” que. Necá Tupana la'ajeri ajopana ja'apejé palá je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","E caja Jesús ja'apari ají que Jerusalén ejo. Rapunana chu rihuá'a ra'apiyatéjena a'ajná ño'ojó quemachi ajopana ina'uqué liyá. Iyamá iphata ji'imaji nacojé quele ne'emacá. E rimá najló: ");
INSERT INTO ycn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Chuhua hue'ejichaca Jerusalén ejo. Re na'ajé najló nucá. Ina'uquéjloje penaje i'imacá nucá. Na'ajé nucá nahuacára'ajeñojlo. Sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, quélejlo na'ajé nucá, nenócaloje nucá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nenójica nucá yámona na'ajé nucá ajopana te'eré eyájenajlo. Necá la'ajeño namácaja nucá. Naña'ataje nucá. Caja penaje nacúhua'ataje nucá a'ahuaná apiyácacanami nacojé, nutaca'acáloje penaje. Eyá hueji que cala i'imajemi numacápo'ojo piño nopumí chuhuá que rimacá najló rinacuhuá. ");
INSERT INTO ycn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ra'apiyatéjena naquiyana i'imaño Santiago, Juan, quele. Nara'apá ií i'imari Zebedeo. E caja naló i'ijnayo Jesús ahua'ajé najhua'até. Rutára'o ru'urúpachi aú rijimaje, ruquejá'acaloje nacaje riliyá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","E rimá rojló: —¿Na pihuata? Rumá rijló: —Pi'imajica ee piyuque ina'uqué huacára'ajeri huacajé, pa'á nuyani pijhuáque'ena penaje, nayá'acoloje pahua'á penaje. Pajluhuaja ca'añá chojó pitá; apú pajrú chojó pitá. ");
INSERT INTO ycn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús quemari rojló ruyánijlo hua'até: —Uncá ihue'epila naca iquejá'aca nuliyá. Chapú huani nala'ajica nucá. ¿E ijña'acajla panacu ricá, ñaqué caja nala'aquela icá chapú? Nemá rijló: —A'a, huajña'acárejla ricá panacu. ");
INSERT INTO ycn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Rimá najló: —Quehuaca jo'ó. Nala'ajé icá chapú nala'ajica nucá que caja. E'iyonaja uncá nucá calé a'ajeri ina'uqué, nayá'acoloje nohua'á nuca'añane chojó pitá, nupajrune chojó pitá penaje. Tupana a'ajeri necá. Ricaja calé hue'epiri mecajenaca yá'ajeño nohua'á marí que —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ajopana, iyamá té'ela quele, ra'apiyatéjena jema'añó méqueca nemacá rijló. Aú nayúcha'o nachá, Juan, Santiago, quele cha. ");
INSERT INTO ycn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","E Jesús quemari najló, nahuacácoloje rahua'ajé penaje. Rimá najló: —Caja ihue'epí ajopana te'eré huacára'ajeño nacojé. Najhua'atéjena minaná queja necá najhua'até. Caphí huani nachaje huacára'ajeño huacára'aca najhua'atéjena. ");
INSERT INTO ycn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Eyá ijló uncá ñaqué calé ri'imajica. Ihuata ca'ajná inaquiyana chá'atacana. A'ajeri inaquiyana ñaté, ricá chá'atari e'iyá. ");
INSERT INTO ycn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ihuata ca'ajná inaquiyana chaje i'imacana. La'arí ricó inaquiyana hua'até sápajeri que, ricá i'imari ajopana chaje. ");
INSERT INTO ycn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ina'uquéjloje penaje i'imacá nucá. Uncá nuphala majó i'imacá, ina'uqué la'acáloje nojló nacaje penaje. Eyá nula'acáloje ina'uquejlo nacaje penaje, nu'ujná majó i'imacá. No'ojé nocó cajrú ina'uqué chaya penaje, ne'emacóloje capichácajo liyá raú penaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Napunana chu na'apá pajimila Jericó e'iyohuá. E caja naqueño'ó re'iyá ja'apácana. Cajrú huani ina'uqué ja'apaño Jesús apumí chuhuá. ");
INSERT INTO ycn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","A'ajnare que iñe'epú ahua'á iyamá mejluruna huani yá'año. Ajopana quemaño najló: —Jesús ja'apácare chuhuá marí iñe'epú. Eja nahuíyo'o. Nemá rijló: —Huahuacára'ajeri, ina'uqué i'imatájeri penaje picá. Pihue'epí huamu'ují. ");
INSERT INTO ycn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ajopana aca'añó necá; nemá najló: —Imanúma'o ta. E'iyonaja richaje huani nahuíyo'oca raú. Nemá rijló: —Huahuacára'ajeri, ina'uqué i'imatájeri penaje picá, pihue'epí huamu'ují. ");
INSERT INTO ycn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Raú Jesús tajnaro iñe'epú chojé. Rihuá'a najló, ne'ejnacáloje richaje penaje. Nephaca rinacu ee rimá najló: —¿Meque ihuátaca nula'acá icá? ");
INSERT INTO ycn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nemá rijló: —Huahuacára'ajeri, pa'apata hualiyá mejlucaji, huamachi. ");
INSERT INTO ycn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús hue'epiri namu'ují. Aú risapa nejlú nacú. Raú caja namá palá. E caja ne'ejná Jesús hua'até rápumi chu. ");
INSERT INTO ycn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","E caja nephá Jerusalén nacojé. Pajimila Betfagé ejé nephá. Yenuri Olivos ja'apejé ricá pajimila. E Jesús huacára'ari iyamá ra'apiyatéjena cahuaruna cajena huá'aje. ");
INSERT INTO ycn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Rimá najló: —I'ijná ají ño'ojó pajimila ejo huatucumajo. Re amaje cahuarú caje, a'aqueja mucuri. Ru'urí hua'até rucá. Eco icaráca'a rucá, ihuá'achi rucá ru'urí hua'até majó. ");
INSERT INTO ycn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nemájica ee ijló: “¿Naje chi icaráca'a rucá?” eco imá nunacu: “Huahuacára'ajeri huátari necá mequetánaja penaje. Quéchami huapa'atájica necá napumí chuhuá” —que Jesús quemacá najló. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tupana puráca'alo ja'apátajerimi chu quemacá chojé riphá raú. Marí que rilana'acá riyucuna papera chojé i'imacá: ");
INSERT INTO ycn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Imá pajimila Jerusalén erúnajlo marí que: Iyacá'o, Ihuacára'ajeri huaícha pajimila e'iyajé majopéjari queja. Cahuarú caje nacú ra'apá. Cachini ña'ajeri ricá cahuarú, ra'apá nacú, que rilana'acá riyucuna júpimi i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","E caja ra'apiyatéjena i'ijnaño Jesús quemacá najló que la'ajé. ");
INSERT INTO ycn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nahuá'a cahuarú caje, ru'urí hua'até Jesús ejo. E nayúma'a na'arumacá naquiyana cahuarú caje huajlé chojé. E caja Jesús jácho'oro rihuajlé chojé yá'ajo. ");
INSERT INTO ycn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Cajrú ina'uqué i'imacá re. Necá caja ayúma'año na'arumacá naquiyana ra'apaca ehuá. Palá napechu i'imacale Jesús nacú, nala'acá marí que. Ajopana piño mata'añó huejirí paná caje, naca'acáloje ricá iñe'epú chojé, palá ramácoloje raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ritucumá i'ijnacaño jahuíyo'oño cajrú. Ñaqué caja rápumi chu ja'apácaño jahuíyo'oca. Marí que nemacá Jesús nacú: —Palani huani ricá. Palani ricá Tupana huacára'acare majó ina'uqué i'imatájeri penaje. Palánija Tupana —que nahuíyo'oca. ");
INSERT INTO ycn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Marí que Jesús iphaca pajimila Jerusalén e'iyajé. Raú cajrú ina'uqué jahuacaco richaje yacá'ajo. Nemá najló: —¿Na chi caji? ");
INSERT INTO ycn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—Jesús ricá —que nemacá najló—, Tupana puráca'alo ja'apátajeri ricá. Pajimila Nazaret, Galilea te'erí nacú i'imacare, eyaje ricá —que nemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","E caja Jesús mujlúca'ari Tupana ñacaré chojé. E ra'apá richujena nacú. Nacaje a'ajeño, nacaje huarúhua'ajeño, quele nacú ra'apá richiyá piyuque. Ripajno'otá liñeru apiyácajeño mesané. Túcu'uchina piracana a'ajeño ñáca'aru ripajno'otá caja. ");
INSERT INTO ycn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","E rimá najló: —Tupana puráca'alo lana'aquéjami quemari marí que: “Re nuñacaré, ina'uqué pura'acóloje nujhua'até richu penaje”. Marí que rimacá, e'iyonaja icá apichátaño ricá. Icá a'añó ajopánajlo nacaje richu. Richuhuaja ata'á necá. Ata'ajeño ñacaré que ijló ricá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tupana ñacaré chu ri'imacá ee, ajopana i'ijnaño Jesús ahua'ajé. Mejluruna ne'iyajena i'imacá. Ajopana nanaquiyana uncá ja'apálaño palá. Re Jesús ja'apátari mejluruna liyá mejlucaji. Rilamá'ata caja uncá ja'apálaño tajné najló. Aú na'apá palá. ");
INSERT INTO ycn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Eyá sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, quele amaño rila'acá cajrú nacaje uncá meño'ojó ina'uqué la'alare. Nema'á caja yuhuaná jahuíyo'oca Tupana ñacaré chu. Marí que nemacá Jesús nacú: “Palani huani ricá, Tupana huacára'acare majó ina'uqué i'imatájeri penaje.” Marí caje aú nayúcha'o. ");
INSERT INTO ycn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","E nemá Jesusjlo: —¿E pema'acá méqueca nemacá? —A'a, noma'acare —que Jesús quemacá—. Tupana puráca'alo lana'aquéjami quemari marí que: Yuhuaná, capajáreruna nayani, quele pura'ajeño palá huani Tupana nacú. Tupana puráca'alo lana'aquéjami amácare i'imacá, quemari marí que nanacu i'imacá. ¿Uncá chi ihue'epila ricá? —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","E ra'apaña necá. Ri'ijná ají que pajimila Betania ejo. Re rajúhua'a; re ricamato. ");
INSERT INTO ycn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Muní que lapiyami ripa'ó piño Jerusalén ejo. Rapunana chu quehuí rijló me'epejí i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iñe'epú ahua'á a'ajnare que ramá a'ahuaná higuera. E ri'ijná rejo richa culaje, amari mecharú ri'imacá. Ripanaja calé i'imari rinacu. E Jesús quemari a'ahuanajlo. —Caja queja pi'imajica mecharú. Aú ja a'ahuaná la'aró cuhuichila que. ");
INSERT INTO ycn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Marí que ra'apiyatéjena amaca aú napechu i'imá: “¡Meque piyuque huani rila'acá!” E nemá Jesusjlo: —¿Meque la'ajé chi rili'ichaco cuhuichila quiñaja huani? ");
INSERT INTO ycn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús quemari najló: —Jema'á marí: Caphí ipechu i'imajica ee Tupana chojé, ila'ajé ñaqué caja, nuli'ichaca a'ahuaná higuera nacú que caja. Uncaja que ipechu i'imá: “Uncá rila'alaje nojló ricá” que, caja queja ri'imajica ijló. Richaje puhuichá nojé ila'ajé nacaje, ipechu i'imajica ee Tupana chojé caphí. Imaje ca'ajná ipurejlo: “Patató, pica'á picó juni jalomi acojé” que. Caja queja ri'imajica ijló. ");
INSERT INTO ycn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Piyuque nacaje iquejá'acare Tupana liyá rijhua'até pura'acano aú, ra'ajé ijló ricá. Ipechu i'imajica ee caphí richojé ra'ajé ijló ricá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","E caja Jesús mujlúca'ari piño Tupana ñacaré chojé. Rehuíña'ata ina'uqué Tupana nacú. E sacerdótena huacára'ajeño, peñahuilana, quele iphaño rinacu. Nemá rijló: —¿Na puráca'alo aú chi pila'á nacaje? ¿Na huacára'ari picá rila'ajeri penaje? ");
INSERT INTO ycn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús quemari najló: —Ñaqué caja nuquejá'ajica iliyá nacaje yucuna. Ja'ajipajica ee nojló, numaje ijló na nuhuacára'ajeri. ");
INSERT INTO ycn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Na puráca'alo aú chi Juanmi chu la'aqueri bautizar ina'uqué, Tupana puráca'alo aú ca'ajná ina'uqué puráca'alo aú ca'ajná? —que rimacá najló. Raú napura'ó pajhua'atéchaca necámica que. Nemá pajlocaca: —Huemaquela rijló. “Tupana puráca'alo aú” que, rimajla huajló: “¿Naje chi uncá jema'alá ra'apiyá?” que. ");
INSERT INTO ycn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Eyá huemaquela rijló: “Ina'uqué puráca'alo aú” que, mariruna ina'uqué yúcha'ajeñojla huachá raú. Napiyá huaquero'ó. Napechu i'imá Juanmi chu nacú: “Tupana puráca'alo ja'apátajeri ri'imacá” que. Marí que napura'acó pajhua'atéchaca necámica que. ");
INSERT INTO ycn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","E nemá Jesúsjlo: —Capí. Uncá huahue'epila na puráca'alo aú ca rila'aqué bautizar ina'uqué. —Ñaqué uncá caja numalaje ijló na puráca'alo aú ca nula'acá nacaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús quemari najló marí que: —¿Meque ijló marí yucu? Ina'uqué i'imichari. Iyamá riyani i'imichaño. E rimicha apú ri'irijlo: “Nu'urí, pi'ijná chuhua sapaje huamena e'iyajé”. ");
INSERT INTO ycn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Uncá” que rimíchaca rijló. Júpichami ri'ijnachiya ripéchuhua a'ajná ño'ojó: “¿Naje chi numicha rijló ‘uncá’ que maapami?” Aú ri'ijichá sapaje. ");
INSERT INTO ycn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","E rara'apá i'ijichari piño apú ri'irijlo quemaje: “Chuhua pi'ijná sapaje huamena e'iyajé”. “Je” que rimíchaca rijló. E'iyonaja uncá ri'ijnalacha sapaje. ");
INSERT INTO ycn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Marí que Jesús i'imacá najló yucu. Quéchami rimá najló: —¿Mecaje chi la'arí rara'apá huátaca que? E nemá rijló: —Pamineco rihuacára'acare. Raú Jesús quemari najló: —Jema'á marí: Ñaqué caja uncá ina'uquélaruna, liñeru ña'ajeño nahuacára'ajeñojlo, inaana namanaicho la'ajeño quele chá'ataca icá, nema'acale Tupana puráca'alo ja'apiyá, ne'emacáloje Tupana hua'atéjena raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan bautizar la'ajeri jehuíña'atari icá palá la'acana nacú i'imacá. E'iyonaja uncá jema'alá ra'apiyá. Eyá uncá ina'uquélaruna, liñeru ña'ajeño nahuacára'ajeñojlo, inaana namanaicho la'ajeño, quele jema'añó ra'apiyá. Marí que amaca i'imacá. E'iyonaja uncá ipajno'otala ipéchuhua pu'uhuaré ila'acare iliyá Tupana ejo, jema'acáloje ra'apiyá penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Jema'á apa'amá yucu. Pajluhuaja ina'uqué ejáchiyari cajmú caje ri'icacapere e'iyá. Jepepí rina i'imichari. Rili'ichá corral rinacu tujlá que rejátacare nacojé. Rili'ichá caja ralá apáca'aruna. Quéchami rili'ichaca rica'apé yenoje, richiyá rihua'aphena amácaloje ricá palá penaje. E caja riyuricha rijhua'até sápajeño naquiyánajlo ri'icacapere, namácaloje rijló ricá penaje. E caja ri'ijichá ajopana te'eré ejo. Ri'ijichaca yámona rimicha najló: “Chuhua nu'ujichaca. Eco amá ricá palá. Cajmú naquiyana no'ojé ijló rihuemí, amaca nojló ricá huemí”, que rimíchaca najló. Je. E ri'ijichá ya'ajnaje. Júpija ri'imichá ya'ajnó. ");
INSERT INTO ycn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","E caja richa ña'acana iphíchari rená chojé. Aú rihuacári'icha rijhua'até sápajeño richa ña'acana rijló penaje. ");
INSERT INTO ycn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","E ne'ejichá rcaloje rijló ricá penaje. E caja ri'ijichá ajopana te'eré ejo. Ri'ijichaca yámona rimicha najló: “Chuhua nu'ujichaca. Eco amá ricá ejo. Iphíchaño rimena amájeño nacú. Eta rimena amájeño pachíyaño necá. Naña'achiya apú nanaquiyana. Apú nenocha. Apú nanaquiyana cha naqui'ichá jipa. ");
INSERT INTO ycn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","E paminá huacári'ichari piño ajopana rijhua'até sápajeño rejo. Ajopana chaje íqui'iruna ne'emichaca, i'ijichaño rejo. Ñaqué caja rimena amájeño li'ichaca necá chapú. ");
INSERT INTO ycn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Aú caja rihuacári'icha ri'irí rejo. Ripechu i'imichá: “Nephaje japi nu'urí ja'apí”. ");
INSERT INTO ycn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","E'iyonaja nephicha na'apihuá rijló. Namicha ricá huaíchaca a'ajnare que. E nemicha pajlocaca: “Ilé ri'irí huaícha ta. Rijló rara'apá yuréjeri rimena, ri'imacáloje rijluhua penaje. I'ijná huenóchachi ricá, rimenami yurícoloje huajló penaje”. ");
INSERT INTO ycn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","E caja riphicha nanacu. Eta napachiya ricá. Naji'ichá ricá rimena yámojo. Re nenocha ricá. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Marí que Jesús i'imacá yucu najló. E rimá najló: —¿Meque ca'ajná paminá la'ajica rimena amájeño, riphájica nanacu huacajé? ");
INSERT INTO ycn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nemá rijló: —Rinótajica necá, uncá ina'uquélaruna necá. Uncá rihue'epílaje namu'ují. E riyureje rimena ajopánajlo, ramájeño penaje. A'ajícaño rijló richa rijluhua penaje riphájica rená chojé huacajé, cajena ra'ajé rimena amájeño penaje. ");
INSERT INTO ycn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús quemari najló: —Caja ihue'epí méqueca Tupana puráca'alo lana'aquéjami quemacá. Marí que rimacá nunacu: Pajluhuaja ina'uqué i'imajeri. Ne'iyajena quemájeño rinacu: “Uncá ina'uquélari ricá” que. E'iyonaja ricá i'imajeri ajopana chaje. Marí penaje Tupana a'ajeri ricá. Palá huani nacaje Tupana la'acare, que ripuráca'alo lana'aquéjami quemacá. ");
INSERT INTO ycn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Ijló numá. Tupana jácho'otajeri icá rijhua'atéjena i'imacana chiyá. Ra'ajé piño ajopana ina'uqué rijhua'atéjena penaje apumí chojé. Ileruna la'ajeño rihuátaca que. ");
INSERT INTO ycn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Uncá jema'alaño no'opiyá, capichájeño Tupana liyá. Chapú huani ri'imajica najló. Uncá huátalaño nucá, amájeño chapú caje yajhué nupuráca'alo aú. ");
INSERT INTO ycn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Marí que Jesús quemacá najló i'imacá. Sacerdótena huacára'ajeño, fariséona, quele jema'añó ripuráca'alo i'imacá. Yucu ri'imá najló. E'iyonaja nahue'epí rimacá nanacu raú meque la'ajéñoca necá. ");
INSERT INTO ycn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ñaquele nahuata rijña'acana, nahuajácaloje ricá penaje. E'iyonaja calé naquero'ó ina'uqué piyá. Palá ajopana pechu i'imacá rinacu. “Tupana puráca'alo ja'apátajeri japi ricá,” que napechu i'imacá Jesús nacú. ");
INSERT INTO ycn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús jehuíña'atari piño necá. Yucu ri'imá najló. Rimá najló: ");
INSERT INTO ycn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Chuhua nu'umajica yucu ijló, ihue'epícaloje mecajenaca ina'uqué naquiyana i'imajeño Tupana hua'até je'echú chu penaje. Pajluhua ina'uqué i'imichari. Ne'emacana ri'imichaca. Ri'irí huá'acaco huacajé rili'ichá fiesta. ");
INSERT INTO ycn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","E caja rihuacári'icha rijhua'até sápajeño riyucupéra'acarena huá'aje. Aú ne'ejichá nahuá'aje. E'iyonaja uncá nahuátalacha fiesta ja'apátacana rijhua'até. Aú napi'ichó riyucuna i'imajé rijló. ");
INSERT INTO ycn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Quéchami rihuacári'ichaca piño ajopana rijhua'até sápajeño naquiyana riyucupéra'acarena huá'aje. Rimicha najló: “Marí que imájica najló nunacu: Caja moto'oqueja a'ajnejí. Caja nonó jema piracana pitacaño naquiyana, huajñácaloje ri'ími penaje. Nu'urí huá'acajero. Caja re huani nacaje lamá'ataqueja ripé me'etení. Chuhua i'ijná fiesta ja'apátaje nujhua'até, que imájica najló”. “Je” que nemíchaca. E ne'ejichá najló quemaje. ");
INSERT INTO ycn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","E'iyonaja uncá na'alacha napuráca'alo nanacojó. Apú nanaquiyana i'ijichari rimena e'iyajé sápaje. Apú i'imichari le'ejepelaji a'ajé. ");
INSERT INTO ycn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ajopana nanaquiyana li'ichaño chapú ne'emacana hua'até sápajeño. Nenocha naquiyana. ");
INSERT INTO ycn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Marí caja aú ne'emacana yúchi'icharo cajrú. Aú rihuacári'icha rile'ejena surárana nacapichátacana, nótaño rijhua'até sápajeñomi chuna i'imacá. Rihuacári'icha caja nacára'ataca pajimila nañacaré i'imacare e'iyá. ");
INSERT INTO ycn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Marí que nali'ichaca. E caja rimicha rijhua'até sápajeñojlo: “Chuhua nu'urí huá'acajico. Caja lamá'ataqueja ripé piyuque nacaje. Uncá ina'uquélaruna necá, nuyucupéra'acarena pamineco i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ñaquele chuhua majopeja i'ijnacá iñe'epú chuhuá pajimila e'iyohuá, imíchachi ina'uquejlo, iphátajicarenajlo, ne'ejnacáloje majó fiesta ja'apátaje nujhua'até penaje”, que rimíchaca najló. ");
INSERT INTO ycn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aú ne'ejichá pajimila e'iyohuá, apú iñe'epú chuhuá, apú iñe'epú chuhuá que ina'uqué huá'aje. Aú nahuacáchiya necá palájne'equena, chapújne'equena hua'até ne'emacana ñacaré chojé. Caja namano'ochiya ucapú, najñácare chu na'ajnehuá. ");
INSERT INTO ycn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Ehuá ne'emacana iphíchaca namaje. Amíchari apú i'imichaca najhua'até. Pu'uhuareni ra'arumacá i'imichaca. ");
INSERT INTO ycn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","E ne'emacana quemíchari rijló: “¿Meque pimujlúqui'ichaca majó majopeja pu'uhuareni pa'arumacá hua'até. Fiesta, huá'acacajo huacajé, uncá iná ja'apátala ricá pu'uhuareni iná a'arumacá hua'até. ¿Meque pimujlúqui'ichaca majó?” que rimíchaca rijló. Uncá ra'ajipalacha rijló. ");
INSERT INTO ycn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","E ne'emacana quemíchari a'ajnejí tamáca'atajeñojlo: “Jepo'otá ricá ta ritajné naquiyá, ra'anapitá naquiyá hua'até. Quéchami iqui'ichaca ricá huaca'apojo calajerúhuaca. Re ina'uqué iyájeño cajrú calajerúhuaca. Camachá najma'ajica naí hua re, namácale chapú caje yajhué”, que rimíchaca najló. ");
INSERT INTO ycn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Marí que Jesús i'imacá yucu najló. E rimá najló: —Tupana quemari cajrú ina'uquejlo, ne'emacáloje rijhua'atéjena penaje. E'iyonaja huejápaja necá ri'ihuapacárena ina'uqué e'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","E caja fariséona naquiyana pura'añó pajhua'atéchaca meque nemájica Jesusjlo, rimacáloje najló nacaje nacú apojó ne'emacana liyá penaje. Nahuata quemacana rinacu: “Pu'uhuaré rimíchaca huajló” que, rimaquela apojó riliyá. E ne'ejná richaje. ");
INSERT INTO ycn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nanaquiyana puráca'alo aú, Herodes hua'atéjena naquiyana puráca'alo aú caja ne'ejná Jesús chaje. E nemá rijló: —Huehuíña'atajeri, huahue'epí quehuácaje pipuráca'alo. Nacaje Tupana huátacare iná la'acá nacú pehuíña'ata ina'uqué. Quehuaca nacaje pehuíña'atacare nacú. Re huahuacára'ajeño naquiyana, uncá paala najló pipuráca'alo. E'iyonaja uncá pa'alá pinacojó necá. Pajimato pehuíña'ata ina'uqué Tupana huátaca que la'acana nacú. ");
INSERT INTO ycn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chuhuata pimá huajló méqueca pipechu marí nacú: Naquejá'a hualiyá liñeru, na'acáloje ricá hue'emacana Césarjlo penaje. Romano naquiyana ricá. ¿Meque chi pijló ricá? ¿E chi hua'acajla najló liñeru, naquejá'acare hualiyá hue'emacánajlo? ¿E chi palani hua'acajla najló ricá ca'ajná, uncá ca'ajná? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús hue'epiri naquejá'aca riyucuna, nahuátacale rimacá apojó ne'emacana liyá, nemacáloje rinacu: “Pu'uhuaré rimíchaca huajló” que penaje. Aú rimá najló: —Pajlácachina icá. ¿Naje ihuata numacá ijló nacaje nacú, imacáloje nunacu raú: “Pu'uhuaré rimíchaca” que penaje? ");
INSERT INTO ycn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Iya'atá nojló liñeru, iná a'acare iná i'imacánajlo, nomachi. —Je. E na'á rijló pajluhuata. ");
INSERT INTO ycn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús yacá'aro richaje. E rimá najló: —¿Na jenami chi cari liñeru nacú? ¿Na ií cari lana'aquéjami rinacu? ");
INSERT INTO ycn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Hue'emacana Cesar jenami quele rinacu. Rií caja quele lana'aquéjami rinacu —que nemacá rijló. Rimá najló: —A'á i'imacánajlo quele liñeru rihuátacare. Ila'á caja Tupánajlo nacaje rihuátacare caje. ");
INSERT INTO ycn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Marí que rimacá aú najló napechu i'imá: “¡Meque capechú huani rimíchaca huajló!” E na'apaña ricá. Ne'ejná ají que a'ajná ño'ojó. ");
INSERT INTO ycn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Rihuacajé caja ajopana i'ijnaño piño Jesús amaje. Saducéona naquiyana ne'emacá. Necá quemaño caja taca'acaño nacú: “Uncá namacápo'olajo” que. Ñaqué i'imacale ne'ejná Jesús chaje rijhua'até pura'ajó. Nemá rijló marí que: ");
INSERT INTO ycn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Huehuíña'atajeri, marí que Moisesmi chu puráca'alomi quemacá: “Apú ca'ajná taca'añari riyajalo mayaniqueru. Palani re'ehuemi ra'apiyajé huá'acacojla riyajálomi hua'até. Re'ehuemi chu yanimínami yurícoloje rapumí chojé raú penaje”, que ripuráca'alomi lana'aquéjami quemacá. ");
INSERT INTO ycn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ñaqué ricá. Maare pajluhuaja ina'uqué i'imari huajhua'até. Iyamá cuhuá'ata quele ne'emacá rejena hua'até. Pe'ejrí ri'imacá, huá'acaro. Ejomi ritaca'á mayaniqueru. Rejomi ra'apejé i'imacá huá'acaro riyajálomi hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ñaqué caja ricapichaco ruliyá mayaniqueru caja. Raú ra'apejé piño huá'acaro rujhua'até. Capicharo caja ruliyá mayaniqueru caja. Ají que iyamá cuhuá'ata quele necá huá'acaco rujhua'até i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Necá piyuque capichaño ruliyá mayaniquéruja. E caja ehuaja nayajalo penájerumi capichayo nápumi chu. ");
INSERT INTO ycn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eta, Tupana macápo'otajica caja taca'acaño huacajé, ¿na yajalo chi ruyuríjico rejéchami? Iyamá cuhuá'ata quele ina'uqué yajálomi ru'umacá —que nemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús quemari najló: —Uncá ihue'epila rinacojé, uncale ihue'epila méqueca Tupana puráca'alo lana'aquéjami quemacá. Uncá caja ihue'epila nacaje Tupana hue'epiri la'acana nacojé. ");
INSERT INTO ycn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Caja taca'acaño macápo'ojico ejomi uncá pajhua'atéchaca huá'acajeñomi que calé ne'emajica re. Uncá caja nahuá'acalajo piño pajhua'atéchaca. Tupana hua'atéjena, je'echú chu i'imacaño, que caja ne'emajica rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Re caja taca'acaño macápo'oco yucuna, Tupana puráca'alo lana'aquéjami e'iyá, ihue'epícare. ");
INSERT INTO ycn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ricá quemari méqueca Tupana quemacá Moisesmi chujlo i'imacá. Rimá rijló: “Abraham, Isaac, Jacob, quele pechu i'imari nochojé caphí”. Marí que rimacá nanacu rijló nataqui'ichami. Uncá ihue'epila meque quemacánaca ricá rimacare nacú. Uncá necá, caja taca'acaño, pechu i'imalajla richojé caphí. Eyá necá cajmuruna pechu i'imari richojé caphí —que rimacá najló, nahue'epícaloje raú caja taca'acaño naquiyana i'imacá cajmuruna je'echú chu penaje. ");
INSERT INTO ycn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Marí que rimacá najló. Aú napechu i'imá: “¡Meque palá huani rehuíña'ataca ina'uqué!” ");
INSERT INTO ycn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Caja fariséona jema'añó Jesús manúma'ataca saducéona yucuna. Raú nahuacaco necámica que. ");
INSERT INTO ycn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pajluhuaja nanaquiyana i'imari Tupana puráca'alo nacú jehuíña'atajeri. Ricá huátari Jesús liyá nacaje yucuna quejá'acana, ramácaloje méqueca rimájica rijló penaje. Aú rimá rijló: ");
INSERT INTO ycn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Huehuíña'atajeri, Tupana puráca'alo lana'aquéjami huacára'ari iná la'acá nacaje. ¿Na rihuata huala'acá apú rimacare nacú chaje íqui'ica? ");
INSERT INTO ycn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús quemari rijló: —Huahuacára'ajeri Tupana. Ricaja calé Iná Chi'ináricana. Pihuata íqui'ija Pihuacára'ajeri Tupana. Pihuajhué ricá. Pi'ijnatá caja pipéchuhua rinacu. Pehuíña'o caja nacaje nacú, ri'imacáloje palá rinacu penaje. Pila'á caja piyuqueja nacaje, ri'imacáloje palá rinacu penaje. Marí que pila'acá, pihuátacale ricá íqui'ija. ");
INSERT INTO ycn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Apú nacaje rihuacára'acare iná la'acá chaje íqui'ica rihuátaca iná la'acá marí que. ");
INSERT INTO ycn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","“Pihuata caja íqui'ija piyuqueja ina'uqué pihuátaca picó que caja”. Apa'amá nacojé quemacana que caja marí. ");
INSERT INTO ycn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ra'apiyá jema'acana aú iná la'á Tupana puráca'alo lana'aquéjami quemacá que. Moisesmi chu, ripuráca'alo ja'apátajeñomi chuna, quele lana'acare ri'imacá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Rejo caja jo'ó jahuacácajo nacú fariséona naquiyana i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","E Jesús quemari najló: —¿Meque ipechu ricá Tupana huacára'acare ina'uqué i'imatájeri penaje nacú? ¿Na laquénami naquiyana chi ricá? Nemá rijló: —Davidmi chu laquénami naquiyana ricá. ");
INSERT INTO ycn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús quemari najló: —Tupana Pechu huacára'aca que, Davidmi chu lana'acá riyucuna papera chojé i'imacá. Davidmi chu quemari rinacu: “Nuhuacára'ajeri ricá”. Ñaquele uncá rilaquénami naquiyana huani calé ricá. Marí que rilana'acá riyucuna papera chojé i'imacá: ");
INSERT INTO ycn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ina'uqué Huacára'ajeri huani Tupana. Ricá quemari Nuhuacára'ajerijlo: “Palá huani nupechu pinacu. Pi'imá Nahuacára'ajeri nujhua'até. Maare pi'imajica nohua'á, nuchá'atajica chapú pinacu péchuruna ejená”, que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davidmi chu quemari: “Nuhuacára'ajeri ricá”, ilé Tupana huacára'acare ina'uqué i'imatájeri penaje nacú. Ñaquele uncá rilaquénami naquiyana huani calé ricá nemacare nacú —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Uncá nahue'epila méqueca rapiyácacana. Reyá a'ajná ño'ojó nahuó la'aró ra'apí nacaje yucuna quejá'acana nacú riliyá. ");
INSERT INTO ycn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","E caja Jesús quemari ra'apiyatéjenajlo, ajopana ina'uquejlo hua'até marí que: ");
INSERT INTO ycn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Tupana puráca'alo nacú jehuíña'atajeño, fariséona, quele pechu i'imá marí que nanacuhuá: “Huecaja calé hue'epiño palá meque quemacánaca Tupana puráca'alo, Moisesmi chu lana'acare i'imacá”. Nehuíña'ata icá rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jema'á napuráca'alo ja'apiyá. Pa. Amániya naliyá nacaje nala'acá que. Palani puráca'aloji i'ijnacá nanumá chiyá. E'iyonaja uncá ñaqué calé nala'acá nacaje. ");
INSERT INTO ycn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nahuacára'a ina'uqué la'acá nacaje puhuichani huani. Uncá meño'ojó iná la'alá ricá. E'iyonaja nahuacára'a rila'acana. Eyá necá, uncá la'alaño huejápaja nacaje najhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Piyuque nala'acare nacaje, nala'á ina'uqué amácaloje necá penaje. Napulá nacojé, na'anapitá nacojé, quele nepo'ó Tupana puráca'alo lana'aquéjami naquiyana. Apojó na'arumacá ajopana ina'uqué liyá. Ajopana a'arumacá chaje huaphereca na'arumacá, ajopana amácaloje necá ajopana ina'uqué e'iyayá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Najñácachu na'ajnehuá ajopana ina'uqué hua'até, nahuata palá nojé ñáca'ajori najluhua. Ajopana chá'atajeño que nayá'aco nahuacáca'alo ñacarelana chu. ");
INSERT INTO ycn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nahuata caja ina'uqué iphaca na'apí. Nahuata caja najalaca necá palá, nachira'acochu pajimila nacuhuá. Nahuata caja nemacá najló: “Huehuína'atajeri” que. ");
INSERT INTO ycn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ihuátaniya ina'uqué quemacá inacu: “Huehuíña'atajeri” que. Ejena queja icá pajhua'atéchaca. Re pajluhuaja calé Jehuíña'atajeri penaje. Nucá Jehuíña'atajeri penaje nucá. Tupana huacára'acare majó i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Imaniya caja ina'uqué nacú: “Jara'apaji” que. Re ricá pajluhuaja, je'echú chu, Jara'apá huani. ");
INSERT INTO ycn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Imaniya caja apú nacú: “Huahuacára'ajeri ricá” que. Nucaja calé Ihuacára'ajeri. Tupana huacára'ari nucá majó i'imacá Ihuacára'ajeri huani penaje. ");
INSERT INTO ycn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Iná pechu i'imacachu iná nacuhuá marí que: “Nucá chá'atari ajopana” que, Tupánajlo iná i'imá ajopana ja'apejé. Iná pechu i'imacachu iná nacuhuá marí que: “Ajopana chá'ataño nucá” que, Tupánajlo iná i'imá ajopana chá'atajeri. Ajopana ñaté a'ajeri, chá'atajeri ricá Tupánajlo —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Chapú huani ri'imajica Tupana puráca'alo nacú jehuíña'atajeñojlo, fariséonajlo, quele me'etení i'imacáñojlo. Necá la'añó necó palá la'ajeño que ina'uqué ijlú chu. E'iyonaja uncá ñaqué calé necá. Pajlácachina necá. Netá rapu ina'uquejlo, ne'emacá piyá Tupana hua'atéjena raú penaje. Uncá Tupana hua'atéjena naquiyana calé necá, uncá caja nahuátala ajopana ina'uqué jema'acá ra'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Chapú huani ri'imajica Tupana puráca'alo nacú jehuíña'atajeñojlo, fariséonajlo, quele me'etení i'imacáñojlo. Pajlácachina necá. Napajlá caja ihuacajílomina hua'até, nata'acáloje naliyá nañacaré penaje. Eyá napura'ó júpija Tupana hua'até, palá ina'uqué pechu i'imacáloje nanacu raú penaje. Marí que nala'acare chona, ajopana chaje huani Tupana huajájica necá. ");
INSERT INTO ycn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Chapú huani ri'imajica Tupana puráca'alo nacú jehuíña'atajeñojlo, fariséonajlo, quele me'etení i'imacáñojlo. Pajlácachina necá. Necá i'ijnaño a'ajná ajopana, ajopana que te'eré ejo. Re ca'ajná pajluhuaja nanaquiyana jema'arijla napuráca'alo ja'apiyá. Aú nacuhuá'a juni jalomi, nehuíña'atacaloje ricá napuráca'alo nacú penaje. Iqui'ija napichátaca ricá napuráca'alo aú Tupana ja'apiyá jema'acana liyá, ri'ijnacáloje najhua'até quera'atani, uncá yacálare chojé penaje. Ricá ina'uqué nehuíña'atacare, chá'atari necá richapucha aú, nehuíña'atacale ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Chapú huani ri'imajica najló. Mejluruna que necá. Nahuata ina'uqué jehuíña'atacana. E'iyonaja uncá nahue'epila quehuácaje puráca'aloji nacojé. Marí que nemacá: “Iná quemacachu: ‘Quehuaca nula'ajica numacá que’, Tupana ñacaré ií a'acana aú, uncá iná pajlala, uncachu iná la'alá iná quemacá que. E'iyonaja iná quemacachu: ‘Quehuaca nula'ajica ricá’, oro ií a'acana aú, Tupana ñacaré chu i'imacare ií a'acana aú, iná pajlá, uncachu iná la'alá ñaqué ricá”, que nehuíña'ataca ina'uqué majopeja. ");
INSERT INTO ycn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Meque uncá huani napechu i'imalá najló! ¡Uncá huani nahue'epila! Oro nayá'atacare Tupana ñacaré chojé, palani ricá re ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Necá caja quemaño: “Iná quemacachu: ‘Quehuaca nula'ajica nacaje numacá que’, mesa ií a'acana aú, Tupana ñacaré chu i'imacare ií a'acana aú, uncá iná pajlala, uncachu iná la'alá iná quemacá que”, que nemacá. ");
INSERT INTO ycn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Meque uncá huani napechu i'imalá najló! ¡Uncá huani nahue'epila! Nacaje nayá'atacare mesa nacú, palani ricá, Tupánajlo a'acanami ri'imacale. Mesa nacú ri'imacale, palani ricá. ");
INSERT INTO ycn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iná quemacachu: “Marí que nula'ajica mesa ií a'acana aú”, iná quemá caja rinacu yá'aco nacú raú. ");
INSERT INTO ycn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Iná a'acachu Tupana ñacaré ií, apú hue'epícaloje quehuaca iná quemacá penaje, iná quemá caja Tupana nacú, richu Tupana i'imacale. ");
INSERT INTO ycn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Iná quemacáchu: “Quehuaca nula'ajica nacaje”, je'echú ií a'acana aú, iná quemá caja Tupana nacú raú, richu ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Chapú huani ri'imajica Tupana puráca'alo nacú jehuíña'atajeñojlo, fariséonajlo, quele me'etení i'imacáñojlo. Pajlácachina necá. Iyamá té'ela ca'ala richa, nacaje nejátacare icha naquiyana na'á Tupánajlo pajlúhua'ala. Majopéjari quemachi ripuráca'alo na'á nanacojó. E'iyonaja uncá na'alá nanacojó Tupana puráca'alo, Moisesmi chu lana'acare i'imacá. Rimá nanacu, nala'acáloje palá penaje, nahue'epícaloje caja ajopana ina'uqué mu'ují penaje. Rimá caja nanacu, napechu i'imacáloje caphí Tupana chojé penaje. Marí caje la'acana uncá na'alá nanacojó. Tupana huátari nala'acá marí que ricá apú nacaje nala'acare hua'ató. ");
INSERT INTO ycn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ina'uqué jehuíña'atajeño necá. E'iyonaja uncá huani hue'epílaño necá. Huejapa ñani uncá quemachi paala i'imacare, nahuata ca'acana nanaquiyó. E'iyonaja calé pu'uhuaré huani nala'acare, uncá nahuátala ca'acana nanaquiyó. ");
INSERT INTO ycn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Chapú huani ri'imajica Tupana puráca'alo nacú jehuíña'atajeñojlo, fariséonajlo, quele me'etení i'imacáñojlo. Pajlácachina huani necá. Majopeja caja nala'acá nanacuhuá palá la'acaño que. E'iyonaja pu'uhuaré péchuruna necá. Nata'á ajopana ina'uqué nacaje aú. Canacújne'equena huani necá. ");
INSERT INTO ycn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Uncá nahue'epila pu'uhuaré nala'acare nacojé. Mejluruna que necá. Pamineco iná ca'á iná naquiyó pu'uhuaré iná la'acare, iná pechu la'acóloje palá raú penaje. Aú iná la'á palá. ");
INSERT INTO ycn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Chapú huani ri'imajica Tupana puráca'alo nacú jehuíña'atajeñojlo, fariséonajlo, quele me'etení i'imacáñojlo. Támijimina ca'aquelana ina'uqué e'ejataño jareni aú, ramácoloje palá raú penaje. Palani ramaco. E'iyonaja re richu pu'uhuareni támijimina. ");
INSERT INTO ycn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ñaqué caja necá. Palájne'equena que iná amaca necá. E'iyonaja pu'uhuareni napechu ne'iyá. Pajlácachina huani necá. E'iyonaja nala'á necó palá la'ajeño que ina'uqué ijlú chu. ");
INSERT INTO ycn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Chapú huani ri'imajica Tupana puráca'alo nacú jehuíña'atajeñojlo, fariséonajlo, quele me'etení i'imacáñojlo. Pajlácachina necá. Nahuacára'a nala'acá Tupana puráca'alo ja'apátajeñomi chuna tami pajré. Nachi'inami chuna nócarenami chuna tami pajré nahuacára'a la'acana. Nahuacára'a caja natára'ataca jipa rahua'á, ina'uqué pechu capicháñaca piyá necá, palájne'equena huani ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nemá nanacuhuá: “Hue'emaquela huachi'inami chuna i'imaqué huacajé, uncá hua'alajla nañaté nenócana aú”. ");
INSERT INTO ycn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Marí que nemacá. Caja nahue'epí nachi'inami chuna naquiyánami necá. Nachuhuá ja'apácaño necá. ");
INSERT INTO ycn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nala'ajica que caja nala'acá. ");
INSERT INTO ycn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Chapújne'equena huani necá. Uncá ina'uquélaruna necá. Marí que ne'emacale, uncá huani ne'emalajo quera'atani uncá yacálare chiyá. ");
INSERT INTO ycn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ne'iyajé nuhuacára'aje piño ajopana Tupana puráca'alo ja'apátajeño. Cajrú hue'epícaño ne'emajica. Palá nehuíña'atajica necá. Cajena nuhuacára'aje piño ne'iyajé. E'iyonaja calé nenoje nanaquiyana a'ahuaná apiyácacanami nacojé cúhua'ataqueja. Ajopana piño naña'ataje nahuacáca'alo ñacarelana chu. Apú pajimila nacojé, apú pajimila nacojé que nala'ajica necá chapú. ");
INSERT INTO ycn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Júpimi que na'ajútayami chuna nóqueño necá palájne'equena i'imajícaño. Abelmi chu nócana aú riqueño'ó najló i'imacá. Ajopana, ajopana que nenójica palájne'equena. Caja penaje nenó Zacaríasmi chu. Berequíasmi chu i'irí ri'imacá. Tupana ñacaré chu, mesa yámajo nenó ri'imacá ucapú ahua'á. Marí que nenoca ri'imacá. Palájne'equena ne'emajica nenójicarena. Tupana huajájeri chapújne'equena me'etení i'imacaño ajopana nócarena i'imacá chona. ");
INSERT INTO ycn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pu'uhuaré la'acaño, me'etení i'imacaño, rihuajaje richona ñaqué caja. Marí que huani najló ri'imajica. ");
INSERT INTO ycn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Marí que Jesús quemacá Jerusalén e i'imacáñomi chuna nacú: —Tupana huacára'aqueri ripuráca'alo ja'apátajeñomi chuna Jerusalén erúnami chúnajlo i'imajica. Nenoque nanaquiyana. Nanaquiyana cha naca'aqué jipa. Pulapé nuhuátacajla nahuacátacana no'opiyá jema'ajeño penaje. Capere jahuacátaca ruyani ruyuphé ja'apejé que caja nuhuátaca nahuacátacana, ne'emacáloje no'opiyá jema'ajeño penaje. E'iyonaja uncá nahuátala. ");
INSERT INTO ycn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chuhua uncá na calé i'imajeri najhua'até namájeri penaje. Meñaru namájica nucá. ");
INSERT INTO ycn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Caja numá nanacu: “Uncá namálaje nucá” que. Nemájica ee nunacu marí que: “Palani ricá Tupana huacára'acare majó i'imacá”, ejéchami namájica piño nucá —que rimacá Jerusalén e i'imacáñomi chuna nacú i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","E caja Jesús jácho'oro Tupana ñacaré chiyá. Riqueño'ó ja'apácaje. E ra'apiyatéjena i'ijnaño rijhua'até pura'ajó Tupana ñacaré nacú. ");
INSERT INTO ycn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","E rimá najló: —Jema'á marí: Tupana ñacaré, amácare me'etení, jipa naquiyá la'acanami, uncá i'imalaje maare. Aquijñojo ajopana chapú péchuruna, cajya'atájeño ricá. Ejomi uncá pajluhuaja ñani jipa yurílajo pachácaca —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","E ne'ejná yenuri ejo. Olivos yenuri ií. E Jesús yá'aro. Ra'apiyatéjena i'ijnaño rahua'ajé. Me'echú queja nemacá rijló marí que: —¿Méquechamica ri'imajica pimíchaje nacú huajló? ¿Na aú chi ina'uqué hue'epeje pipa'ajico piño majó jená? ¿Na aú chi ina'uqué hue'epeje eja'ahuá capichájico jená? ");
INSERT INTO ycn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús quemari najló: —Jema'aniya ajopana puráca'alo ja'apiyá, napajlájicare aú ijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Iqui'iruna ina'uqué iphájeño. Na'ajé nuí, neí hua penaje. “Ricá Tupana huacára'acare majó ina'uqué i'imatájeri penaje nucá”, que nemájica nanacuhuá apú, apú que. Napajlájica najhua'até. Cajrú ina'uqué jema'ajeño na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Eyá yucu i'imajé marí que: “Chuhua nenócaco pajhua'atéchaca”. Ajopana nacú nemaje: “Yehuicha naqueño'ocá pajhua'atéchaca nócacano”. Marí que yucu i'imajica rihuacajé. Iquero'oniyo raú. Caja queja ri'imajica. Uncá jo'ó eja'ahuá tajnálajo nenócajico huacajé. ");
INSERT INTO ycn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ajopana te'eré eruna nócajeño ajopana te'eré eyájena hua'até. Ajopana i'imacana hua'atéjena nócajeño ajopana i'imacana hua'atéjena hua'até. Cajrú ina'uqué taca'ajica me'epejí nacú rihuacajé. Cajrú huani natami caje nójica ina'uqué. Cajrú caja te'erí ñaca'ajico apú eyá, apú eyá que rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Marí caje aú naqueño'ojé chapú caje yajhué ña'acana panacu. ");
INSERT INTO ycn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Najña'ajé icá, nala'acáloje icá chapú penaje. Nenoje icá. Chapú caja nahuó i'imajica ichá, no'opiyá jema'ajeño i'imacale. ");
INSERT INTO ycn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Cajrú nujhua'atéjena jácho'ojico no'opiyá i'imacana chiyá. Chapú napechu i'imajica panacuhuácaca raú. Nemaje panacuhuácaca ajopánajlo, nala'acáloje necá chapú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Rihuacajé caja cajrú pajlácachina i'imajica. Nemaje nanacuhuá: “Tupana puráca'alo ja'apátajeño huecá” que. Raú cajrú ina'uqué jema'ajeño na'apiyá. Napajlaje najhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cajrú caja nala'ajica pu'uhuaré rihuacajé. Marí caje aú no'opiyá jema'ajeño jácho'ojico íqui'i pecohuácaca huátacana chiyá. Ñaqué caja nácho'ojico íqui'i nuhuátacana chiyá. ");
INSERT INTO ycn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Uncá yurílajeño Tupana puráca'alo ja'apiyá i'imacana nataca'ajica ejená, necá Tupana i'imatájeri capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tupana huátari ina'uqué huacára'ajeri i'imacana, ne'emacáloje palá penaje. Ne'ejnajé riyucuna i'imajé ajopánajlo, ajopánajlo que piyuque eja'ahuá chuhuá. Marí caje aú piyuqueja ina'uqué ajopana te'eré eruna, ajopana te'eré eruna que jema'ajica riyucuna. Piyuqueja ina'uqué jema'ajícaja riyucuna, ejéchami riphájica rená chojé, eja'ahuá tajnácoloje penaje. ");
INSERT INTO ycn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Natára'ataje nacaje pu'uhuareni huani Tupana ñacaré chojé. Tupana puráca'alo ja'apátajerimi chu, Daniel, i'imari riyucuna júpimi que. (Marí papera amájeñojlo numá: Ihue'epí meque quemacánaca ricá.) ");
INSERT INTO ycn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Natára'ataje nacaje pu'uhuareni Tupana ñacaré chojé. Marí que amájica ee ricá, icá Judea te'eré eruna ñaajeño ipuré e'iyajé. ");
INSERT INTO ycn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Rihuacajé ca'ajná e'iyajena i'imajeño pají i'ihuata chu. Pu'ucuja iñaajico reyá. Uncá imujlúca'alaje pají chojé nacaje ña'ajé pamineco. ");
INSERT INTO ycn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Apala e'iyajena i'imajeño imena e'iyá. Icá caja ñaajeño pu'ucuja. Uncá caja ipa'alajo iñacaré chojé a'arumacaji ña'ajé pamineco. ");
INSERT INTO ycn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Chapú huani ri'imajica canupana inaánajlo rihuacajé. Chapú huani caja ri'imajica inaana cayaniquérunajlo. Re caja jo'ó i'iracaño chu'uchú nayani, quélejlo ri'imajica chapú rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipura'ó Tupana hua'até, ri'imacá piyá ipe'ení iñaajico huacajé. Ipura'ó caja rijhua'até, ri'imacá piyá huatána'acaje huacajé iñaajico huacajé. ");
INSERT INTO ycn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Rihuacajé cajrú ina'uqué amájica chapú caje yajhué. Tupana queño'orí piyuque eja'ahuá la'acana huacajé reyá maárejecha, uncá chapú caje huani i'imalá ñaqué eja'ahuá chu. Uncá caja chapú caje huani i'imalaje ñaqué reyá a'ajná ño'ojó. ");
INSERT INTO ycn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tupana huitúca'atajeri najló rená, ri'imacá piyá júpija huani najló. Iqui'ija rihuátaca ina'uqué, ri'ihuapacárena rijluhua ajopana ina'uqué e'iyayá. Najló rihuitúca'ataje rená. Uncáquela rihuitúca'atalajla rená najló, uncá na calé i'imarojla capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Nemájica ijló: “Iyacá'o, ilé ina'uqué Tupana huacára'acare majó ina'uqué i'imatájeri penaje ricá”. Marí que nemájica ee ijló, jema'aniya na'apiyá. Nemájica ee ijló: “Iyacá'o, a'ajnare ricá”, jema'aniya caja na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Cajrú ina'uqué i'imajeño. Majopeja napajlájica. Apú, apú que nemájica nanacuhuá: “Nucá Tupana huacára'acare majó ina'uqué i'imatájeri penaje”. Ajopana caja quemájeño nanacuhuá: “Huecá ja'apátaño Tupana puráca'alo ina'uquejlo ra'apiyá que”. Nala'ajica caja cajrú nacaje uncá meño'ojó iná la'alare. Nená que'ená queja ri'imajica najló. Marí caje aú ina'uqué a'ajeño nanacojó napuráca'alo. Cajrú napajlájica najhua'até. Tupana hua'atéjena hua'ató caja nahuata pajlácana. E'iyonaja uncá meño'ojó napajlala najhua'até, uncale nema'alaje na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Marí que ri'imajica. Uncá chiyó ri'imá ñaqué, numá ijló rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ñaquele nemájica ee nunacu marí que ijló: “Re ricá ya'ajná pu'uteni meñaru chu, amicha ricá”, i'ijnaniya rejo ramaje. Uncá nucá calé ri'imajica. Nemájica ee: “Re ricá ucapú chu, amicha ricá”, jema'aniya caja na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pichaní camaré patacá que je'echú chiyá que caja ina'uqué amájica nucá huaíchaca majó. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Méreca nujhua'atéjena i'imajeño, eyaja Tupana hua'atéjena huá'ajeño necá. ");
INSERT INTO ycn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Ina'uqué amájeño cajrú huani chapú caje yajhué i'imajica. Rihuacajé uncá camú camaré i'imalaje. Uncá caja queri camaré i'imalaje. Ihuijina caje ja'ajeño je'echú chiyá. Piyuque nacaje je'echú chu i'imacare ñaca'ajero. ");
INSERT INTO ycn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ejéchami namájica nucá huaíchaca je'echú chiyá majó. Ina'uquéjloje penaje i'imacá nucá. Namájica aú nucá huaíchaca, cajrú neyájica. Piyuqueja ina'uqué ajopana, ajopana que iyájeño. Namaje nucá huaíchaca juni suhuáca'ala e'iyohuá. Piyuque ina'uqué huacára'ajeri penaje nuphaje majó. Cajrú mejáma'atani i'imajica nohua'ó, hua'até nuphaje. ");
INSERT INTO ycn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Cajrú luhuiluhuí caje mejé i'imajica. Ejéchami nuhuacára'ajica nujhua'atéjena, je'echú chiyájena, i'ijnacá ina'uqué huá'aje. Ina'uqué, nu'uhuapacárena nujluhua ajopana ina'uqué e'iyayá, huá'aje ne'ejnajé. Piyuqueja huani eja'ahuá e'iyayá nahuá'aje necá. ");
INSERT INTO ycn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ihue'epí nuphajica majó nacojé. Caja ihue'epí a'ahuaná higuera nacojé. Ri'iché pitúca'ari, ripaná moto'ocáloje rinaquiyá penaje. Ri'iché pitúca'aca aú iná hue'epí jarechí iphaca rená chojé. ");
INSERT INTO ycn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ñaqué caja ihue'epíjica nupa'ajico majó nacojé. Amájica aú nacaje numíchaje nacú, ihue'epeje yehuicha riphaca rená chojé caja penaje. ");
INSERT INTO ycn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Jema'á marí: Marí que ri'imajica ina'uqué tajnájico yámona. ");
INSERT INTO ycn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Je'echú, eja'ahuá hua'até tajnájero. E'iyonaja calé uncá nupuráca'alo tajnálajo. Numacá rinacu queja nacaje i'imajica. ");
INSERT INTO ycn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Uncá na calé hue'epiri méquechamica ri'imajica numíchaje nacú. Na huacajeca ri'imajica, na camú jenaca ri'imajica, uncá nacú quemacana i'imalá méquechamica que ri'imajica. Tupana hua'atéjena, je'echú chu i'imacaño, uncá hue'epílaño méquechamica ri'imajica. Nucá, Tupana I'irí, uncá caja hue'epila ricá. Ricaja calé, Tupana, hue'epiri méquechamica ri'imajica. ");
INSERT INTO ycn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Noémi chu i'imacá huacajé que caja ri'imajica nupa'ajico yámona. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noémi chu i'imacá huacajé, Tupana huacára'ari cajrú juni ja'acó, pu'uhuaré la'ajeño capichácoloje racojé penaje. Uncá chiyó cajrú juni ja'acó, ina'uqué la'aqueño marí que: Na'ajnehuá ajñacana nacú, nacaje jalá i'iracana nacú ne'emaqué. Na'aqué caja nayani pajlocaca, nahuá'acacoloje penaje. Marí caje nacuja ne'emaqué Noémi chu mujlúca'aca rihuapúrune chojé ejená. ");
INSERT INTO ycn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Uncá nahue'epila nacapichaco jená. Cajrú huani juni ja'acó i'imacá. Ricá acojé nacapichó i'imacá. Ñaqué caja ri'imajica ina'uquejlo nupa'ajico yámona. Uncá caja nahue'epílaje nuphaca. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nupa'ajico majó huacajé, nujhua'atéjena, je'echú chu i'imacaño, huá'ajeño nujhua'atéjena, eja'ahuá chu i'imacaño. Ajopana e'iyayá nahuá'aje necá. Nupa'ajico huacajé, iyamá ina'uqué ca'ajná i'imajeño namena e'iyá. Nujhua'atéjena, je'echú chiyájena, huá'ajeño pajluhuaja nanaquiyana. Apú yuréjero, uncá jema'alá no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rihuacajé caja iyamá inaana tujla'ajeño nacaje pajñacani ca'ajná, nacaje tujláca'aruna chu. Nahuá'aje pajluhuájaruja, nujhua'atéjeru ru'umacale. Apa'ahuelo yuréjeyo, uncá jema'alayo no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’I'imá ilere lamá'ataquejami que pu'uhuaré ila'acare liyá nupé. Uncá ihue'epílaje méquechamica nupa'ajico piño majó. ");
INSERT INTO ycn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jema'á marí: Paminá hue'epíquela méquechamica ata'ajeri iphaca nacaje ata'ajé riñacaré chiyá lapí, uncá ricamátalojla. Cajmuni ri'imajla ramaca riphaca ejená. Uncá riyurílajla rimujlúca'aca riñacaré chojé nacaje ata'ajé. ");
INSERT INTO ycn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ñaqué caja ilamá'ataca ipéchuhua nupé. Uncá caja ihue'epílaje noná. Mana'í chiyó nuphájica inacu majó. ");
INSERT INTO ycn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Re ca'ajná apú hua'até sápajeri. Ricarihuate huátari ca'ajná ya'ajnajo i'ijnacana. Aú riyuricha ricá a'ajnejí tamáca'atajeri penaje, ritamáca'atacaloje rijhua'até sápajeñojlo a'ajnejí riphaca rená chojé ejéchami. La'arí risápaca'alo palá, jema'arí ra'apiyá. Capechuni ricá. ");
INSERT INTO ycn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Apala ricarihuate iphari rinacu huajátacajo. Amari rila'acá palá rihuacára'aca ricá que. Palá ricarihuate la'ajica ricá raú. ");
INSERT INTO ycn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ra'ajé ricá ca'ajná piyuqueja rinane amájeri penaje. ");
INSERT INTO ycn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Eyá uncá ina'uquélari ri'imaquela, rimajla marí que ricarihuate nacú ya'ajná jo'ó ri'imaqué huacajé: “Meque júpija huani nucarihuate malá'ataca ricó rehuá. Uncá riphálaje quiñaja”. ");
INSERT INTO ycn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Raú ca'ajná riqueño'ójla ricarihuate hua'até sápajeño la'acana chapú. Cajrú ra'ajnehuá ajñacana nacú ri'imacajla. Cajrú cahuí caje i'iracana nacú ri'imacajla ajopana yuhuéra'acachona hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Huajátacajo ricarihuate ipháquela rinacu, rihuajácajla ricá íqui'ija huani. ");
INSERT INTO ycn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Rihuacára'ajla ricá ya'ajnaje, rijña'acáloje chapú caje yajhué panacu pajlácachina hua'até penaje. Re caja riyajla cajrú. Rajma'ájla raí hua cajrú. quehuini yajhué a'acuhuaná. ");
INSERT INTO ycn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Ina'uqué naquiyana huacára'ajeri penaje Tupana. Chuhua nu'umajica ijló yucu, ihue'epícaloje rinacojé raú penaje. Iyamá té'ela quele ináyana i'ijichaño lapí ajopana huá'acaco ejo. Nacamaré i'imichari nacapi. Nacaje jilá aú nacamaré lucúni'icharo. Ne'ejichá ru'uhuapánipe huátaje, ne'ejnacáloje rijhua'até penaje. ");
INSERT INTO ycn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ajopana, pajluhua té'ela quele caja i'imichaño capéchuruna. Pajluhuaja té'ela quele ináyana naquiyana i'imichaño mapéchuruna. ");
INSERT INTO ycn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Necá ji'ichaño nacamareja najhua'ató. Uncá najña'alacha najhua'ató nacaje jilá, naco'ocáloje rapumí chojé ritajnájico ee penaje. ");
INSERT INTO ycn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Eyá capechúruna ji'ichaño nacamaré, nacamaré jilá huíluru chu najhua'ató. ");
INSERT INTO ycn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","E caja ne'ejichá rihuátaje. Nahuáchiya ricá. Uncá riphálacha. Nahuáchiya ricá. Uncá. Júpija rimalá'achiyaca ricó. Caja ehuaja tapú nóchari necá. E caja ehuaja nacamáchiyo. Matámiruna que ne'emichaca reyá. ");
INSERT INTO ycn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lapí jenaji que nemi'ichá pajluhuaja jahuíyo'oca: “Ilé huaícha. I'ijná, amíchachi chuhua ricá”. ");
INSERT INTO ycn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aú nácho'ocho piyuque. Nalamá'achiya nacamaré. ");
INSERT INTO ycn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ejéchami mapéchuruna quemíchaca capéchurunajlo: “A'á huajló huejapa icamaré jilá naquiyana. Yehuíchaja huacamaré yacaca”. ");
INSERT INTO ycn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","E'iyonaja capechúruna quemíchaño najló: “Uncá hua'alaje ijló rinaquiyana. Hua'aquela ijló rinaquiyana, uncá riphálajla huanacojé. I'ijná ra'aquélana ejo, ihuarúhua'achi ijluhua ricá reyá,” que nemíchaca najló. ");
INSERT INTO ycn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aú ne'ejichá rihuarúhua'aje. A'apona ru'uhuapánipe iphíchaca. Ji'ichaño nacamaré jilá najluhua najhua'ató, necaja calé mujlúqui'ichaño rijhua'até pají chojé nahuá'acaco amaje. Namujlúqui'ichaca ejomi richahuíji'icha pají numaná. ");
INSERT INTO ycn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Quéchami ajopana ináyana iphíchaca piño. Nemá paminajlo: “Paminá, pijme'etá huajló rinumaná”. ");
INSERT INTO ycn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","E'iyonaja rimicha najló: “Uncá huani nuhue'epila mecajenaca icá”. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","E Jesús quemari yucu jema'ajéñojlo: —Ijló caja numá. I'imá capéchuruna, lamá'ataquejami que ipechu i'imacáloje nupé penaje. Uncá ihue'epílaje méquechamica nuphájica. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ina'uqué naquiyana huacára'ajeri penaje Tupana. Chuhua nu'umajica yucu ijló, ihue'epícaloje nupa'acó piño majó nacojé raú penaje. Pajluhuaja ina'uqué i'imichari. Rihuáchiya ya'ajnaje ajopana te'eré ejo i'ijnacana. Ri'ijichaca yámona rihuá'icha rijhua'até sápajeño maná. Nephicha rinacu. E ra'achá najló riliñérute naquiyana, nala'acáloje nacaje raú ri'imacá rejo quetana. ");
INSERT INTO ycn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pajluhuájajlo ra'achá cincuenta mil. Apujlo ra'achá veinte mil. Apujlo ra'achá diez mil. Nahue'epica nacaje nacojé loco'opáneje ra'achaca najló liñeru. Palá hue'epícajlo ra'achá cajrú liñeru. Ra'apejé péchurijlo ra'achá ra'apejeja caja liñeru. Marí que ra'achaca najló liñeru ri'ijichaca yámona. Quéchami ri'ijichaca ají que a'ajná ño'ojó ajopana te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ricá, ra'achájejlo cincuenta mil, huarúhui'ichari nacaje, rijña'acáloje rejé caja liñeru. ");
INSERT INTO ycn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ñaqué caja apú li'ichaca ra'achájejlo veinte mil, ricá huarúhui'ichari nacaje, riphátacaloje veinte mil caja richaje. ");
INSERT INTO ycn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Eyá ricá, ra'achájejlo diez mil, ricá si'ichari rile'ejé te'erí e'iyajé. ");
INSERT INTO ycn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Júpija nacarihuate i'imichaca rehuá ajopana te'eré nacú. E caja ehuaja ripi'ichó rapumí chuhuá, ramácaloje rijhua'até sápajeño ra'achájenajlo liñeru penaje. Rihuata hue'epícana méqueca nala'acá liñeru hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ricá ra'achájejlo cincuenta mil, i'ijichari ramaje pamineco. E ra'achá rijló liñeru ra'achaje rijló júpimi que. Richaje ra'achá rijló liñeru ricánichaje hua'ató. Rimicha rijló: “Nucarihuate, picá a'arí nojló cincuenta mil i'imacá. Caja nucana richaje ñaqueja caja cincuenta mil caja. Pa, marí ricá”. ");
INSERT INTO ycn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Je. Ñaqué ricá”, que ricarihuate quemíchaca rijló. “Palani huani picá. Palá pisápaca nujhua'até. Caja pila'á palá huejápaja aú. Chuhua no'ojica pijló richaje huani, pila'acáloje nacaje raú penaje. Pimujlúca'a majó, pi'imachi queyajupa nujhua'até”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","A'ajná ño'ojó chami pani apú rijhua'até sápajeri iphíchari piño rinacu. Ra'achájejlo veinte mil ri'imichaca. Riphicha rinacu, rimicha rijló: “Nucarihuate, picá a'arí nojló veinte mil i'imacá. Caja nucana richaje veinte mil caja. Pa. Marí ricá”. ");
INSERT INTO ycn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Je. Ñaqué ricá”, que ricarihuate quemíchaca. “Palani huani picá. Palá pisápaca nujhua'até. Caja pila'á palá ujú caje ñani aú. Chuhua no'ojica pijló richaje huani, pila'acáloje nacaje raú penaje. Pimujlúca'a majó, pi'imachi queyajupa nujhua'até”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","E caja penaje apú rijhua'até sápajeri iphíchari rinacu. Ra'achájejlo diez mil júpimi que. Riphicha ricarihuate nacú. Rimicha rijló: “Nucarihuate, nucá hue'epiri pihuacára'aca caphí ina'uqué. Pihuacára'a nejátaca pijló nacaje, richa i'imacáloje pijluhua penaje. Uncá pisápala pimena e'iyá. E'iyonaja re nacaje re'iyayá pijló penaje. ");
INSERT INTO ycn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Aú nuquero'ó pipiyá. A'acuhuaná nusa'á piliñérute te'erí e'iyajé me'echú. Pa, ricá cari”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ricarihuate quemíchari rijló: “¡Meque uncá huani ina'uquélari ta picá! Maliyaru huani picá ta. Pihue'epícare mecajeca nucá. Pihue'epícare caja nejátaca nojló nacaje, richa i'imacáloje nujluhua penaje. Pihue'epícare caja uncá nusápala numena e'iyá. E'iyonaja re nacaje re'iyayá nojló penaje. ");
INSERT INTO ycn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Caja pihue'epícare marí caje nucá. Pihuacára'aquela liñeru lamá'atacana liñeru ñacarelana chojé, naya'atajla ajopánajlo ricá, nacánacaloje richaje raú penaje. Ají que la'acana aú pipa'atácajla nojló nuliñérute, richaje hua'até”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","E rimicha re i'imichácañojlo: “Ijña'á riliyá liñeru, a'achí cien mil i'imacare cápijlo ricá. ");
INSERT INTO ycn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Cajrú nacaje i'imacárena cápijlo no'ojé richaje. Uncá na i'imalárena capi liyá, nujña'ajé huejapa nacaje i'imacare nacapi. ");
INSERT INTO ycn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Iqui'ichá ilé nujhua'até sápajeri, maliyaru, ají que calajeruni chojé. Re cajrú neyájica, cajrú najma'ajica naí hua, namájicale chapú caje yajhué”, que rimíchaca najló. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesús quemari piño marí que najló: —Ina'uquéjloje penaje i'imacá nucá. Aquijñojo nucá huaícha piño majó piyuque ina'uqué huacára'ajeri penaje. Cajrú nujhua'atéjena, je'echú chiyájena, i'imajica nohua'á. Ajopana chaje huacára'ajeri nu'umajica rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Piyuqueja ina'uqué eja'ahuá chu i'imacaño, ajopana te'eré eyájena, ajopana te'eré eyájena que, necá jahuacájeño nujimaje. Quéchami nutamáca'atajica necá ne'iyayá. Ohuéjana lamára'ajeri tamáca'ataca ohuéjana cahuayana piracana e'iyayá, que caja nutamáca'atajica necá paliyácaca. ");
INSERT INTO ycn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nutamáca'ataje nujhua'atéjena, palá la'acaño, pu'uhuaré la'acaño e'iyayá. Nujhua'atéjena, palá la'acaño, palá nupechu i'imajica nanacu. Necá i'imajeño ca'añá chojé pitá nohua'á. Eyá necá, pu'uhuaré la'ajeño, chapú nupechu i'imajica nanacu. Pajrú chojó pitá ne'emajica nohua'á. ");
INSERT INTO ycn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","E nucá, Nahuacára'ajeri, quemájeri marí que no'opiyá jema'ajéñojlo, nuca'añare chojó pitá i'imajícañojlo numaje: —Palá huani Tupana, Nora'apá, la'acá icá. Chuhua i'imajica palá huani nujhua'até je'echú chu. Ijló penaje Tupana lamá'atari ricá. Tupana queño'ótaca eja'ahuá huacajé, caja queja lamá'ataquejami ri'imacá ijlojé penaje. ");
INSERT INTO ycn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Quehuí nojló me'epejí i'imaqué, icá a'aqueño nojló a'ajnejí. Nunúru'upi chu macára'ataco i'imacá huacajé, icá caja a'aqueño nojló i'iracaje. Ajopana te'eré eyaje que nu'umaqué ijhua'até huacajé, icá caja quemaño nojló, nu'umacáloje iñacaré chu ijhua'até penaje. ");
INSERT INTO ycn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Camu'ují nula'aqué a'arumacaji nacú huacajé, icá caja a'aqueño nojló ricá. Nutami nu'umaqué huacajé, icá caja i'ijnaqueño nuchaje. Ina'uqué huajáquelana chu nu'umaqué huacajé, icá caja i'ijnaqueño nuchaje —que numájica najló. ");
INSERT INTO ycn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","E palá nupechu i'imacárena nacú quemájeño nojló marí que: —Huahuacára'ajeri, ¿Mérohuacaje hua'acá pijló a'ajnejí, quehuí me'epejí i'imaqué pijló huacajé, pimá nacú? ¿Mérohuacaje hua'acá pijló i'iracaje, pinúru'upi chu macára'ataco huacajé? ");
INSERT INTO ycn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Mérohuacaje huemaqué pijló, pi'imacáloje huañacaré chu huajhua'até penaje, ajopana te'eré eyaje que pi'imaqué huacajé huajhua'até? ¿Mérohuacaje hua'aqué pijló a'arumacaji, camu'ují pila'aqué huacajé a'arumacaji nacú? ");
INSERT INTO ycn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Mérohuacaje hue'ejnaqué pichaje, pitami pi'imaqué huacajé? ¿Mérohuacaje hue'emacá pichaje, ina'uqué huajáquelana chu pi'imaqué huacajé? —que nemájica nojló. ");
INSERT INTO ycn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Eyá nucá, Nahuacára'ajeri, quemájeri najló: —Jema'á marí: Marí que ila'ajica palá no'opiyá jema'ajeño naquiyana i'imajica. Ajopana ja'apejena ca'ajná ne'emajica. Palá ila'ajica necá i'imajica. Ñaqué caja ila'ajica nucá palá raú —que numájica najló, jema'añó no'opiyajlo. ");
INSERT INTO ycn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Eyá ajopánajlo, uncá jema'alaño no'opiyajlo, nucá ina'uqué huacára'ajeri, quemájeri marí que: —Ja'apá nuliyá. Caja Tupana yerúca'acarena chaje icá. I'ijná quera'atani uncá yacálare chojé. Caja lamá'ataqueja ricá Jiñá Chi'ináricanajlo, rijhua'atéjenajlo hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Quehuí nojló me'epejí i'imaqué huacajé, uncá a'aqué nojló a'ajnejí i'imacá. Nunúru'upi chu macára'ataco huacajé, uncá caja a'aqué nojló juni i'imajica. ");
INSERT INTO ycn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ajopana te'eré eyaje que nu'umaqué huacajé ijhua'até, uncá caja imaqué nojló, nu'umacáloje iñacaré chu ijhua'até penaje. Camu'ují nula'aqué huacajé a'arumacaji nacú, uncá caja a'aqué nojló a'arumacaji. Nutami nu'umaqué huacajé, uncá caja i'ijnaqué nuchaje. Ina'uqué huajáquelana chu nu'umaqué huacajé, uncá caja i'imalá nuchaje —que numájica najló, uncá jema'alaño no'opiyajlo. ");
INSERT INTO ycn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","E necá caja quemájeño nojló marí que: —¿Mérohuacaje uncá hua'alá pijló a'ajnejí, quehuí pijló me'epejí i'imaqué huacajé? ¿Mérohuacaje uncá hua'alá pijló i'iracaje, pinúru'upi chu macára'ataco huacajé? ¿Mérohuacaje uncá huemaqué pijló, pi'imacáloje huañacaré chu huajhua'até penaje, ajopana te'eré eyaje que pi'imaqué huacajé huajhua'até? ¿Mérohuacaje uncá hua'aqué pijló a'arumacaji camu'ují pila'aqué huacajé a'arumacaji nacú? ¿Mérohuacaje uncá hue'ejnaqué pichaje, pitami pi'imajica huacajé? ¿Mérohuacaje uncá hue'ejnalá pichaje pi'imaqué huacajé ina'uqué huajáquelana chu? —que nemájica nojló rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","E nucá, ina'uqué huacára'ajeri, quemájeri najló: —Jema'á marí: Uncá ila'alá palá no'opiyá jema'ajeño naquiyana. Ajopana ja'apejena ca'ajná ne'emacá. Uncá ila'alá necá palá i'imacá. Raú ñaqué caja ila'acá nucá —que numájica najló, uncá jema'alaño no'opiyajlo. ");
INSERT INTO ycn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Marí que numájica najló ejomi na'apájica nuliyá, ne'ejnacáloje nahuajáquelana ejo penaje. Matajnaco ne'emajica re. Eyá ajopana, palá la'ajeño, i'ijnajeño je'echú chojé, ne'emacáloje caja re matajnaco penaje. ");
INSERT INTO ycn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Caja Jesús i'imari najló yucu. Ejomi rimá ra'apiyatéjenajlo marí que: ");
INSERT INTO ycn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Caja ihue'epí apacala hua'apátajica fiesta, Pascua rií. Ina'uquéjloje penaje i'imacá nucá. Rihuacajé na'ajé nucá ajopánajlo, nacúhua'atacaloje nucá a'ahuaná apiyácacanami nacojé penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","E caja cajrú ajopana jahuacaco sacerdótena huacára'ajeño ñacaré cópeje. Sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, peñahuilana, quele necá jahuacaño Caifás ñacaré cópeje. Sacerdótena huacára'ajeri huani ricá Caifás i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Re napura'ó pajhua'atéchaca Jesús nacú. Nahuata rijhua'até pajlácana, najña'acáloje ricá, nenócaloje ricá penaje. Ricá nacú napura'ó pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","E nemá: —Uncá huajña'alaje ricá fiesta e'iyá. Ñaquejlaca cajrú ina'uqué yúcha'acojla huachá raú. ");
INSERT INTO ycn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betania e Jesús i'imari. Simón hua'até ri'imacá riñacaré chu. Napona patáca'ataro penájemi ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Rijhua'até ri'imá. Na'ajnehuá ajñacana nacú ne'emacá ee apa'ahuelo ña'ayó nacaje jilami Jesús jimajo. Huíluru chu ri'imacá. Jipa alabastro naquiyá la'acanami huíluru i'imacá. Pu'umé jamarí nacaje jilami i'imacá. Marí rujña'á Jesús jimajo. E roco'ó rihuilá e'iyajé ricá. ");
INSERT INTO ycn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Marí caje aú ra'apiyatéjena yúcha'año ruchá. Nemá pajlocaca: —¡Naje majopeja huani ta rucupíchaca ricá! ");
INSERT INTO ycn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Cahuemini huani ilé caje jilá. Ro'oquela ajopánajlo ricá, na'ájla rojló cajrú liñeru. Ricá aú ro'ójla camu'ují la'acaño ñaté. Marí que la'acana i'imajla palani —que napura'acó pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús hue'epiri méqueca nemacá runacu. Aú rimá najló: —¿Naje chi iqui'ichá pu'ují caje rupechu naquiyá? Palá ruli'ichaca nucá raú. ");
INSERT INTO ycn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ihuátajica ee camu'ují la'acaño ñaté a'acana, re necá ijhua'até ñaqueja. Eyá nucá, uncá nu'umalaje ijhua'até ñaqueja. ");
INSERT INTO ycn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pu'umé jamarí quejilani roco'ochá nunacojé. Aú rulamá'achiya nunapona, nasa'ajica nucá huacajé penaje. ");
INSERT INTO ycn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jema'á marí: Tupana i'imatari ina'uqué capichácajo liyá. Ne'ejnajé riyucuna i'imajé ajopana, ajopánajlo que. Ne'emajé caja méqueca ruli'ichaca nucá huajé yucuna najló, napechu capicháñaca piyá rucá penaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","E caja Judas i'ijnari sacerdótena huacára'ajeño hua'até pura'ajó. Iyamá iphata ji'imaje nacojé quele Jesús ja'apiyatéjena naquiyana ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Rimá rijló: —¿Merejé pa'ajica nojló liñeru, no'ojica ee ijló Jesús? Aú na'á rijló treinta parata cahuemí nojé. Pa'u queta queri quetana iná sápaca huemí ejé que ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Reyá a'ajná ño'ojó Judas quejíla'ari Jesús, ramácaloje méqueca ra'acajla najló ricá. ");
INSERT INTO ycn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","E caja naqueño'ó fiesta ja'apátacana. Riqueño'ojica quehuá najñájica pan mamúra'atacanaru. E ra'apiyatéjena i'ijnaño Jesús ahua'ajé. Nemá rijló: —¿Mere chi pihuata huala'acá fiesta pascua a'ajnená? ");
INSERT INTO ycn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Rimá najló: —I'ijná a'ajná ño'ojó pajimila ejo. Amájica ee apú, imaje rijló: “Huehuíña'atajeri quemíchari pinacu, caja riphicha rená chojé, nomácaloje chapú caje yajhué penaje. Piñacaré chu nojñaje no'ojnehuá no'opiyatéjena hua'até”, que imájica rijló nunacu. ");
INSERT INTO ycn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","E caja ra'apiyatéjena i'ijnaño ají que a'ajná ño'ojó. Nala'á Jesús quemacá najló que. Nala'á fiesta pascua a'ajnená. ");
INSERT INTO ycn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lapichami najñá na'ajnehuá Jesús hua'até. Iyamá iphata ji'imaji nacojé quele ra'apiyatéjena i'imaño rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Najñaca na'ajnehuá nacú rimacá najló: —Marí que ri'imajica: Pajluhuaja inaquiyana maare, a'ajeri nucá nupinánajlo. ");
INSERT INTO ycn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Marí que rimacá aú camu'ují napechu la'acó. Nemá rijló pajehuémichaca que: —¿Nucá chi quele pimá nacú? ");
INSERT INTO ycn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús quemari najló: —Ajñari ra'ajnehuá nujhua'até marí paratú chiyá, ricá numá nacú, a'ajeri nucá nupinánajlo. ");
INSERT INTO ycn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ina'uquéjloje penaje i'imacá nucá. Nala'ajica nucá chapú Tupana puráca'alo lana'aquéjami quemacá que nunacu. E'iyonaja calé chapú huani ri'imajica rijló a'ajeri nucá nupinánajlo. Uncáquela rimoto'ójla i'imacá, palani ri'imacajla rijló. Raú uncá Tupana huajálajla ricá cajrú huani. ");
INSERT INTO ycn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aú Judas, ripinánajlo a'ajeri, quemari Jesusjlo: —Huehuíña'atejeri, ¿Nucá chi quele pimá nacú? —A'a, picá —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Najñaca na'ajnehuá ee Jesús ña'arí pan ricápojo. Rimá Tupánajlo: —Palá pila'acá huecá marí pan aú. Ejomi ritupa'á rinaquiyana. E ritamáca'ata ra'apiyatéjenajlo pan tupa'aqueja. Rimá najló: —Ajñá ricá. Nunapona ricá. ");
INSERT INTO ycn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Quéchami rijña'acá piño chiyela ricápojo. Cajmú epepí inarí icha jalá amúra'atacanami i'imari richu. Rimá Tupánajlo: —Palá pila'acá huecá marí cajmú caje jalá aú. E rimá ra'apiyatéjenajlo: —Marí i'irá. A'á ijluhua ricá piyuque, i'irachi ricá. ");
INSERT INTO ycn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nura ricá. Nura i'ijnajeri nophú chiyá ina'uqué chaya penaje. Marí caje aú Tupana amájero cajrú ina'uqué chaje, pu'uhuaré nala'acare liyá. Nura palamane Tupana la'ajeri ina'uqué nacú palá. ");
INSERT INTO ycn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Uncá nu'uralaje cajmú epepí inarí icha jalá ijhua'até marí eja'ahuá chu piño. Nu'urajé piño ricá ijhua'até Nora'apá hua'até je'echú chu. Rihuacajé nu'urajé apú caja jalá ijhua'até re —que Jesús quemacá ra'apiyatéjenajlo. ");
INSERT INTO ycn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Caja penaje nataní Tupana yale. Ejomi ne'ejná yenuri Olivos ejo. ");
INSERT INTO ycn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","E Jesús quemari najló: —Ñaanó pani ipechu la'ajó piyuque ujhuí nuliyá. Ja'apáñaje nucá. Marí que Tupana puráca'alo lana'aquéjami quemacá huanacu: “Nonoje ohuéjana lamára'ajeri naliyá. Raú macajmálaja ohuéjana ñaajico”, que rimacá huanacu. ");
INSERT INTO ycn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nenoje nucá. Numacápo'ojico ejomi nu'ujnajé Galilea ejo itucumá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","E Pedro quemari rijló: —Ajopana pechu ca'ajná la'ajero ujhuí piliyá. Eyá nucá, nupechu uncá la'alajo ujhuí piliyá. ");
INSERT INTO ycn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús quemari rijló: —Numá pijló, marí lapí capere yaca'acá piyá pimicho'otájicaja nuchaya hueji que pe —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro quemari rijló: —Nenoje ca'ajná nucá pijhua'até raú. E'iyonaja calé uncá numicho'otálaje pichaya. Ajopana ra'apiyatéjena quemaño ñaqué caja. ");
INSERT INTO ycn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","E caja Jesús i'ijnari ra'apiyatéjena hua'até Getsemaní ejo. Ñaqueja ne'ejnajica rejo i'imajica. E rimá najló: —Maare iyá'o. Ihuata nucá, nupura'acó Tupana hua'até a'ajná ño'ojó quetana. —Je —que. ");
INSERT INTO ycn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","E rihuá'a a'ajná ño'ojó quemachi rijhua'ató Pedro, Juan, Santiago, queleja. Zebedeo yaní necá Juan, Santiago. Rihuá'a necá a'ajná ño'ojó quemachi. Ejéchami ripechu la'acó apú que; camu'ují huani ripechu la'acó. ");
INSERT INTO ycn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Rimá najló: —Camu'ují huani nupechu. Uncá meño'ojó nujña'alá panacu. Caja rimajáqui'icha nuhuajhué. Iyuró maare. Pa. I'imá cajmuruna nujhua'até; icamátaniyo. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","E Jesús ja'apáñari necá a'ajná ño'ojó pani. Re rito'ó pajima'aló te'erí e'iyá. Ripura'ó Tupana hua'até, rimá rijló: —Nora'apá, pihuátajica ee, pa'apata nuliyá chapú caje yajhué nomájicare ñaanó pani. Pila'aniya nuhuátaca que. Pihuátaca que pila'acá —que rimacá Tupánajlo. ");
INSERT INTO ycn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","E rácho'o. Ripa'ó piño ra'apiyatéjena amaje. Amari nacamátaco. Rimá Pédrojlo: —¿Uncá meño'ojó chi pi'imaláchajla cajmuni nujhua'até pajluhua camú jená quetana? ");
INSERT INTO ycn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","I'imá cajmurúnaja. Ipura'ó Tupana hua'até ila'acá piyá pu'uhuaré. Re ricá iná pechu nacú, iná la'acáloje palá penaje. E'iyonaja calé uncá meño'ojó iná iphátala palá la'acana iná icó —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","E ri'ijná piño Tupana hua'até pura'ajó. Rimá piño rijló: —Nora'apá, pihuátajica ee pa'apata nuliyá chapú caje yajhué nomájicare ñaanó pani. Pila'á pihuátaca que nucá. ");
INSERT INTO ycn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","E ripa'ó piño ra'apiyatéjena amaje. Amari nacamátaco piño. Caja tapú chá'atari necá. ");
INSERT INTO ycn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ejéchami uncá rapótala necá. Caja ripa'ó piño Tupana hua'até pura'ajó. Hueji que pe la'acá ñaqueja caja rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","E ripa'ó piño ra'apiyatéjena amaje. Rimá najló: —¿Ejo'ocaja chi icamátaco maare? ¿Huatána'acaje nacuja chi icá? Ihuatána'a. Caja riphicha rená chojé. Ina'uquéjloje penaje i'imacá nucá. Chuhua na'ajica nucá pu'uhuaré la'acáñojlo. ");
INSERT INTO ycn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Chuhua jácho'o, i'ijná hue'ejnachi. Caja ilé huaícha, a'ajeri nucá pu'uhuaré la'ajéñojlo. ");
INSERT INTO ycn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús pura'acó ra'apiyatéjena hua'até ejé Judas iphaca rinacu. Iyamá iphata ji'imaje nacojé quele ra'apiyatéjena naquiyana ri'imacá. Riphá rinacu cajrú ajopana ina'uqué hua'até. Sajalu caje, cujyúhua'ala caje hua'até nephá rinacu. Sacerdótena huacára'ajeño, peñahuilana, quele puráca'alo aú ne'ejná rejo ripataje. ");
INSERT INTO ycn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas a'arí ripinánajlo Jesús. Maapami que rimacá rijhua'até i'ijnacáñojlo mecajeca ricá. Rimá najló marí que i'imacá: —Pu'uhuacá nuchiño'ojica rijimá chiyá, ricá ipataje —que rimacá rijhua'até i'ijnacáñojlo maapami que. ");
INSERT INTO ycn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","E caja riphá Jesús nacú. Rajalaca Jesús. Rimá rijló: —Huehuíña'atajeri —que. Ejéchami richiño'ocá rijimá chiyá. ");
INSERT INTO ycn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús quemari rijló: —Nujhuáque'ehue, ¿naje pi'ijichá? Eja netá Jesús cha; patañó ricá. ");
INSERT INTO ycn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ejéchami pajluhuaja ra'apiyatéjena naquiyana jero'ocá risajálune ra'aruná chiyá. Ricá aú rica'á apú i'ijhuí. Sacerdótena huacára'ajeri hua'até sápajeri ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aú Jesús quemari rijló: —Pipa'atá ra'arú chojé pisajálune. Sajalu aú nócaño capichájeño raú. ");
INSERT INTO ycn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nuhuátaquela, numacajla Nora'apajlo, raú rihuacára'ajla setenta mil rijhua'atéjena je'echú chiyá majó. Necá mejñátañojla nucá naliyá. ");
INSERT INTO ycn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","E'iyonaja marí que rila'aquela, uncá ri'imalajla Tupana puráca'alo lana'aquéjami quemacá que nunacu. Richuhuá ne'ejnataca ricá me'etení nala'acare aú —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","E rimá ajopánajlo: —Caja i'ijichá majó nujña'ajé sajalu hua'até, cujyúhua'ala caje hua'até. Meque ata'acachi que huani ila'acá ijluhua nucá. Hue'echú ca'alá queja nu'umajícano Tupana ñacaré chu ina'uqué jehuíña'atacana nacú. E'iyonaja uncá ijña'alá nu'umacá rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Marí que ila'acá nucá me'etení yucuna, Tupana puráca'alo ja'apátajeñomi chuna lana'añó papera chojé i'imacá —que rimacá najló. Ejéchami piyuque ra'apiyatéjena ja'apáñaca Jesús. Neñaó reyá. ");
INSERT INTO ycn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","E caja najña'á Jesús ají que ya'ajná Caifás ñacaré ejo. Sacerdótena huacára'ajeri huani Caifás i'imacá. Riñacaré chojé Tupana puráca'alo nacú jehuíña'atajeño, peñahuilana, quele jahuacaño rijhua'até i'imacá. Rejo najña'á Jesús i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Eyá Pedro ja'apari juca quemachi Jesús ápumi chu. Nahuacára'ajeri huani ñacaré cópeje riphá. E rimujlúca'a corral chojé. Re riyá'o policíana hua'até, ramácaloje reyá méqueca nala'ajica Jesús penaje. ");
INSERT INTO ycn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Caja najña'á Jesús rejo. Re sacerdótena huacára'ajeño, peñahuilana, quele i'imaño ajopana hua'até. Necá culaño ajopana pajlácachina, nemacáloje Jesús nacú: “Pu'uhuaré la'ajeri ricá” que penaje, nenócaloje ricá richona penaje. ");
INSERT INTO ycn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Cajrú ina'uqué quemaño rinacu: “Pu'uhuaré la'ajeri ricá” que. E'iyonaja uncá nahue'epila méqueca rinacu quemacana pu'uhuaré, nenócaloje ricá richona penaje. Majopeja napajlájica rinacu. E caja ehuaja iyamá ina'uqué i'ijnaño najimaje rinacu quemaje. ");
INSERT INTO ycn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nemá najló: —Marí que ilé ina'uqué quemacá rinacuhuá: “Nucá cajya'atárijla Tupana ñacaré. Hueji que cala i'imajemi nula'ájla piño rapumí chuhuá ricá” —que nemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Marí caje aú sacerdótena huacára'ajeri huani tára'aro. Rimá Jesúsjlo: —¿Uncá chi papiyácalaje pinacojó necá? ¿Meque ricá quele nemíchaca aú pinacu? ");
INSERT INTO ycn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Uncá Jesús ja'ajipalá rijló. Raú sacerdótena huacára'ajeri quemari rijló: —Tupana, ricá cajmuni, puráca'alo aú numá pijló, pimacáloje nojló quehuaca penaje. ¿E chi picá quele Tupana huacára'acare majó ina'uqué i'imatájeri penaje? ¿Tupana I'irí chi picá? ");
INSERT INTO ycn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús quemari rijló: —A'a, ilé que pimíchaca nunacu queja nucá. Ina'uquéjloje penaje i'imacá nucá. Icá amájeño nucá Tupana ahua'á. Piyuque la'acá Tupana. Rijhua'até nuhuacára'aje ina'uqué. Icá amájeño nupa'acó piño majó je'echú chiyá juni suhuáca'ala e'iyohuá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Marí caje aú sacerdótena huacára'ajeri yúcha'aro íqui'ija huani. A'acuhuaná rijiyo'otá ra'arumacahua. Rimá ajopánajlo: —Ilé ta puri'icharo pu'uhuaré huani ta Tupana nacú. Uncá na penaje calé huaculá ajopana, ne'emacáloje huajló méqueca rila'acá pu'uhuaré yucuna penaje. Caja huemi'ichá méqueca rimíchaca ta pu'uhuaré huani Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Meque ijló quele? Nemá rijló: —Pihuacára'a rinócana richona. ");
INSERT INTO ycn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","E natupá nahui Jesús jimá chojé. Ajopana ña'atá ricá. Ajopana ña'añó pajimaya ricá. Apára'ataqueja a'arumacaji aú rijlú i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nemá rijló: —Ricá Tupana huacára'acare majó ina'uqué i'imatájeri penaje pi'imajica ee, pimá huajló naca ji'ichari picá pajimaya, ají que nala'acá namácaja ricá. ");
INSERT INTO ycn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Marí que nala'acá Jesús ee Pedro i'imari huaca'apé yá'acajo nacú. E apa'ahuelo i'ijnayo Pedro ahua'ajé. Pají chiyá sápajeyo ru'umacá. Rumá rijló: —Nuhue'epí ilé Jesús, Galilea eyaje, hua'ateje picá. ");
INSERT INTO ycn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","E'iyonaja Pedro micho'otari richaya. Rimá rojló ajopana e'iyá: —Uncá huani nuhue'epila méqueca pimacá nojló. ");
INSERT INTO ycn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Raú ra'apá ají que corral numaná ejo. Ejéchami apa'ahuelo quemacá piño ajopana re yá'acañojlo. —Ilé chira'aró caja Jesús, ilé Nazaret eyaje, hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ñaqué caja Pedro micho'otaca piño richaya. —Tupana hue'epiri quehuácaca numacá: Uncá nomána'apa calé ricá. ");
INSERT INTO ycn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mequetánaja i'imajémija ajopana piño iphaño Pedro ahua'ajé. Nemá rijló: —Rijhua'atéjena naquiyana picá. Pa. Napura'acó rite'eré ehuá que caja pipura'acó. ");
INSERT INTO ycn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Marí caje aú Pedro quemari najló: —Nuhuata Tupana huajaca nucá, uncachu numalá quehuaca. Uncá huani ta nomána'apa calé ricá. Ejéchami capere yaca'acá. ");
INSERT INTO ycn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Raú riphá ripechu nacojé méqueca Jesús quemacá rinacu maapami que. Rimá rijló i'imacá: “Capere yaca'acá piyá, picá micho'otájeri nuchaya hueji que pe caja.” Rema'acá aú capere yaca'acá, Pedro i'ijnari reyá. Supejeno riyaca. ");
INSERT INTO ycn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","E caja najme'etá. Re i'imacaño pechu i'imá réjenohuanija Jesús nócana nacú. Sacerdótena huacára'ajeño, peñahuilana, quele huátaño Jesús nócana. ");
INSERT INTO ycn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","E nepo'otá ra'anapitá panacojéchaca. Nahuá'a ricá nate'eré eyá huacára'ajeri ejo. Poncio Pilato rií i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas a'arí ripinánajlo Jesús maapami que i'imacá. Ramaca aú nahuátaca Jesús nócana chapú rihuó i'imacá richó. E ri'ijná piño liñeru pa'ataje najló, maapami que na'acare rijló. Na'á rijló liñeru i'imacá, rihuá'acaloje necá Jesús i'imacá ejo penaje. E riphá nanacu. Sacerdótena huacára'ajeño, peñahuilana, quele nacú riphá. ");
INSERT INTO ycn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","E rimá najló: —Marí liñeru, uncá huani paala nuli'ichaca ricá. Uncá la'alare pu'uhuaré quele. E'iyonaja calé ihuata rinócana. Chapú huani nuli'ichaca ricá ijló ra'acana aú —que Judas quemacá najló. Aú nemá rijló: —Pijloja calé chapú ricá. Huajló uncá ñaqué calé ricá. ");
INSERT INTO ycn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aú ja rica'á huichá liñeru Tupana ñacaré chojé. Marí caje aú ra'apá reyá, rinócaloje ricó penaje. Racúhua'ataca ricó rinúru'upi naquiyá. Marí queja Júdasmi chu noca ricó. ");
INSERT INTO ycn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sacerdótena huacára'ajeño huayo'oñó riliñérutemi rica'acare Tupana ñacaré chojé. E nemá: —Ina'uqué nócana huemí cari. Chapú huala'acajla hualamá'ataquela ra'acuná chojé ricá marí Tupana ñacaré chu. ");
INSERT INTO ycn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Napura'ó pajhua'atéchaca rinacu, méqueca rila'acana nacú. Ñaqué i'imacale nahuarúhua'a támijimina sa'aquélana pucuna raú, nasa'acáloje ajopana te'eré eyájena támina rejé penaje. Pajluhuaja pucapé ipújeri le'ejé ri'imacá. Ricá liyá nahuarúhua'a te'erí rapucuna penaje. ");
INSERT INTO ycn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Maárejecha nemá rapucuna nacú: Jirá pucuna ricá. ");
INSERT INTO ycn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tupana puráca'alo ja'apátajerimi chu, Jeremíasmi chu, quemacá que júpimi nala'acá raú. Marí que rilana'acá riyucuna papera chojé i'imacá. “Israelmi chu laquénami naquiyana a'ajeño apujlo treinta parata, cahuemí nojé, ra'acáloje najló ricá rihuemí penaje. ");
INSERT INTO ycn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Rihuemí aú nahuarúhua'aje rapucuna pajluhuaja pucapé ipújeri liyá. Tupana quemacá nojló que nala'ajica,” que rilana'acá papera chojé riyucuna i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","E caja nahuá'a Jesús nate'eré eyá huacára'ajeri ejo. E rimá Jesusjlo: —¿Judíona i'imacana chi picá? Jesús quemari rijló: —A'a, nucá nucá, pimacá queja. ");
INSERT INTO ycn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sacerdótena huacára'ajeño, peñahuilana, quele arucátaño Jesús rijló. E'iyonaja uncá Jesús apiyácala necá. ");
INSERT INTO ycn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Raú nahuacára'ajeri, Pilato, quemari rijló: —¿Uncá chi pihue'epila méqueca nemacá pinacu: “Pu'uhuaré la'ajeri picá” que? ");
INSERT INTO ycn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Uncá Jesús ja'ajipalá rijló. Raú ne'emacana pechu i'imá: —¿Na ta chi caji numajlo? Aú uncá meño'ojó rihue'epila méqueca rila'acana. ");
INSERT INTO ycn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Fiesta pascua huacajé queja Pilato jácho'otajicano ina'uqué huajáquelana chiyá pajluhuaja ina'uqué. Ricá nahuátajicare jácho'otacana, rácho'otaque najló. ");
INSERT INTO ycn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Rihuacajé apú i'imari ina'uqué huajáquelana chu. Piyuque ina'uqué amána'apa ri'imacá. Rií i'imari Barrabás. ");
INSERT INTO ycn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Caja nahuacó i'imacá. Aú Pilato quemari najló: —¿Mecaje ihuátaca nócho'otaca ijló, Barrabás ca'ajná, Jesús ca'ajná? Ricá nemacare nacú: “Tupana huacára'acare majó” que, ¿ricá chi nócho'otaje ijló? ");
INSERT INTO ycn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Marí que rimacá najló, rihue'epícale chapú nahuó i'imacá Jesús cha. Cajrú ina'uqué pechu i'imacá Jesús nacú palá. Ricá jimaje chapú nahuacára'ajeño huo i'imacá Jesús cha. Ñaqué i'imacale nahuá'a ri'imacá rejo, rihuacára'acaloje rinócana penaje. ");
INSERT INTO ycn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Re ne'emacana yá'aro, rimacáloje najló méqueca rila'acana. Ehuá riyajalo huacára'aca rijló puráca'aloji. Rumá rijló: —Pácho'ota ilé Jesús. Reja ri'imareja. Uncá la'alá meque ricá ina'uqué. Lapí nutapúni'icha ricá. Cajrú huani nucahuíli'ichaco raú. Marí que puráca'aloji quemacá, riyajalo huacára'acare rijló. ");
INSERT INTO ycn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Caja Pilato quemari najló i'imacá: “¿Mecaje ihuata nócho'otaca ijló, Jesús ca'ajná, Barrabás ca'ajná?” Raú sacerdótena huacára'ajeño, peñahuilana, quele ca'átaño cajrú ina'uqué e'iyajé, nemacáloje rijló marí que penaje: “Pácho'ota huajló Barrabás. Pihuacára'a Jesús nócana.” ");
INSERT INTO ycn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","E ne'emacana quemari piño najló: —Chuhuata, imá nojló mecajeca ihuata nócho'otaca ijló. Nemá rijló: —Pácho'ota huajló Barrabás. ");
INSERT INTO ycn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Rimá najló: —¿Eta meque chi nula'ajica Jesús, ricá nemacare nacú, Tupana huacára'acare majó? Nemá rijló: —Pihuacára'a rinócana a'ahuaná apiyácacanami nacojé acúhua'ataqueja. ");
INSERT INTO ycn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Raú Pilato quemari najló: —¿Naje ta ihuata rinócana? ¿Na ta chi rila'á pu'uhuaré? Raú nahuíyo'o piño rijló: —Pihuacára'a racúhua'atacana a'ahuaná apiyácacanami nacojé. ");
INSERT INTO ycn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato amari caja nejnúcha'aco rijló Jesús jácho'otacana nacú. Ramá caja yehuíchaja nenócaco pajhua'atéchaca rijimaje. Aú rihuacára'a najña'acá rijló juni pachiya chojé. Najimaje ripá riyáte'ela chiyá, nahue'epícaloje raú uncá ripachá calé rinócana. E rimá najló: —Uncá nuhuacára'alaje ilé nócana. Uncá la'alare pu'uhuaré ricá. Ijloja calé ilé que rila'acana. ");
INSERT INTO ycn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aú piyuque necá quemaño rijló: —Rinócana i'imajeri huapachá, huayani pachá hua'até. ");
INSERT INTO ycn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Marí caje aú Pilato jácho'otari najló Barrabás. Ejomi rihuacára'a naña'ataca Jesús. E riyurí najló Jesús, nenócaloje ricá penaje. Riyurí najló ricá, nacúhua'atacaloje ricá a'ahuaná apiyácacanami nacojé penaje. ");
INSERT INTO ycn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Quéchami ne'emacana le'ejena surárana ña'acá Jesús ne'emacana ñacaré ejo. Re nahuacata surárana, re i'imacaño piyuque Jesús ahua'ajé. ");
INSERT INTO ycn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ejomi naca'á ra'arumacá rinaquiyá. Namácaja penaje na'acá rinacojé ipirálucuni a'arumacaji. Nahuacára'ajeño a'ajícare nanacuhuá caje caja ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nachipúca'ata caja rihuíla'aru nacojé tujripi. Na'á caja ijijila ca'añá riyáte'ela chojó pumitá, ricutihuare penaje. Caje na'á ricápeje. Ejomi natára'o ne'erúpachi aú rijimaje. Namácaja nala'acá ricá; nemá rijló: —Judíona i'imacana, ¿Picá? ");
INSERT INTO ycn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Natupá nahui rijimá chojé. E najña'á ijijila ricápiya, naña'acáloje ricá pehuíla'aruya raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","E nayurí namácaja rila'acana. E naca'á piño a'arumacaji ipirálucuni rinaquiyá. Na'á piño rinacojé ra'arumacá. Ejomi najña'á ricá, nacúhua'atacaloje ricá a'ahuaná apiyácacanami nacojé penaje. ");
INSERT INTO ycn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","A'ahuaná apiyácacanami rihuacúla'apa que Jesús ja'apaca najhua'até. Nácho'oco ee pajimila e'iyayá, nephata apú ina'uqué. Cirene eyaje ri'imacá. Simón rií i'imacá. Ricá nahuacára'a a'ahuaná apiyácacanami huáco'ocana Jesús chaya. ");
INSERT INTO ycn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ne'ejná ají que a'ajná ño'ojó. E nephá rinóquelana ejo. Ina'uqué huíla'arumi aphinami que na'acá rapucuna ií. Napura'acó chu na'á rií Gólgota que. ");
INSERT INTO ycn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Rejo nephá. Re na'á Jesusjlo i'iracaje. Cajmú caje jalá amúra'atacanami, quechípa'aqueja nacaje jalá ipisini hua'até. Jesús atá'ari ricá, uncá ri'iralá ricá. ");
INSERT INTO ycn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","E nacúhua'ata ricá a'ahuaná apiyácacanami nacojé. Ipháqueja itapuhua aú nacúhua'ata ricá. Ejomi surárana cátaño nacaje nacú, namácaloje méqueca natamáca'atajica najluhua ra'arumacami penaje. Tupana puráca'alo ja'apátajerimi chu quemacá rinacu que nala'acá ri'imacá. Marí que rilana'acá riyucuna papera chojé i'imacá: “Natamáca'ataje najluhua no'orumacami. Nacaje nacú cátacano aú nahue'epeje ritamáca'atacana najluhua.” ");
INSERT INTO ycn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Caja natamáca'ata najluhua ra'arumacá rimacá rinacu i'imacá que. Ejomi nayá'o. Rihua'aphena ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","E nacúhua'ata Jesús cha lana'aquéjami. Ricá quemari na chona nenoca ricá. Marí que lana'aquéjami quemacá: “Marí Jesús, judíona i'imacana ricá.” ");
INSERT INTO ycn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Rejé caja nacúhua'ata ajopana iyamá. Rahua'ayá iyáma'ajo pumitana nacúhua'ata necá. Ata'acáchina ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Rahua'ayá ja'apájicaño pura'aqueño rinacu pu'uhuaré. Nañaca'aqué nehuíla'aru rijló. ");
INSERT INTO ycn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nemá rijló: —Yee, picá quemari pinacuhuá: “Nucá cajya'atájeri Tupana ñacaré. Hueji que cala i'imajemi nula'ajé piño rapumí chuhuá ricá”. Chuhuata pi'imatá picó. Tupana I'irí pi'imajica ee, pihuitúca'a a'ahuaná apiyácacanami naquiyá. ");
INSERT INTO ycn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ñaqué caja ajopana la'ajica namácaja ricá. Sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, fariséona, peñahuilana, quele ne'emacá, la'añó namácaja ricá. Nemá pajlocaca: ");
INSERT INTO ycn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Meque calé ta ri'imataca ajopana capichácajo liyá i'imacá. Eta, ricó uncá meño'ojó ri'imatala. Israelmi chu laquénami huacára'ajeri ri'imajica ee, rihuitúca'aje a'ahuaná apiyácacanami naquiyá. Marí que huamájica ee rila'acá, huema'ajé ra'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Caphí Tupana chojé péchuri ricá. Tupana huátacare ri'imaquela, Tupana i'imatárijla ricá, rimacale rinacuhuá: “Tupana I'irí nucá” que —que nemacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ata'acáchina nacúhua'atacarena Jesús ahua'á, necá caja pura'añó pu'uhuaré Jesús nacú. ");
INSERT INTO ycn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","E caja lapí que i'imari nachá piyuque eja'ahuá chu. Caápu'ucu eyá pe'iyochami camú to'ocó quetana ne'emacá calajerúhuaca. ");
INSERT INTO ycn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pe'iyochami camú to'ocó ee Jesús jahuíyo'ori caphí huani. Napura'acó chu rimá: —Elí, Elí, ¿lama sabactani? Marí que quemacánaca rimacá: Tupana, nupechu i'imacare chojé caphí, ¿na penaje piyurí nucá? ");
INSERT INTO ycn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Re i'imacaño naquiyana jema'añó rahuíyo'oca. E nemá: —Ilé huá'ari Tupana puráca'alo ja'apátajeri, Elíasmi chujlo. ");
INSERT INTO ycn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Raú pajluhuaja nanaquiyana jecho'ótari i'iracaje rijló. Rejata nacaje jamára'apani cajmú caje jalá amúra'atacanami acú. Quéchami repo'ocá ijijila lupucuje nacojé ricá. Ricá aú ra'á rijló ricá, ri'iracáloje re'iyayá ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Raú ajopana quemaño rijló: —Reja ri'imareja. Huamaijla, apala Elíasmi chu iphájeri majó ri'imataje. ");
INSERT INTO ycn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","E Jesús jáhuiyo'ori piño caphí huani caja penaje. Ejé ritaca'á i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hua'ató que ya'ajná Tupana ñacaré chu a'arumacaji jiyo'ocó pe'iyohuá paliyácaca. Apalá ucapú penaje racúhua'o re. Rijiyo'ó yenuya ají que cahuacaje. Caja iyamá que riyurico. Ritaca'acá aú caja te'erí ñaca'aró. Raú caja jipa cajruni e'echataro paliyácaca. ");
INSERT INTO ycn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Raú caja támijimina ca'aquelana chiyá támijimina chaya me'etátaco. Rihuacajé Tupana macápo'otari cajrú ina'uqué júpimi que taca'acaño. Caphí péchuruna Tupana chojé ne'emacá. Jesucristo macápo'oco ejomi ne'ejná Jerusalén ejo, Tupana le'ejé pajimila ejo. Caja pu'uhuacá nachira'acó rehuá. Cajrú ina'uqué amaño nachira'acó rehuá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ritaca'acá apucuna e surárana huacára'ajeri i'imari ajopana surárana hua'até. Jesús hua'aphena ne'emacá. Ritaca'acá aú namá te'erí ñaca'acá, jipa e'echataco caje. Cajrú huani naquero'ocó raú. Nemá pajlocaca: —Tupana I'irí jo'ó quele táqui'ichari. ");
INSERT INTO ycn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Cajrú inaana i'imacá a'ajnare que. Júcayaja nayacá'o rejo. Necá i'ijnaño Galilea eyá ají que Jerusalén ejo rijhua'até i'imacá. Riñaté a'ajeño ne'emacá rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","María Magdalena i'imayo najhua'até. Apa'ahuelo María i'imayo caja najhua'até. Santiago, Juan, quele jaló i'imayo caja najhua'até. Quele nanaquiyana i'imacá najhua'até. ");
INSERT INTO ycn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","E caja najúhua'a. E José i'ijnari Pilato amaje. Cajrú le'ejepelari José i'imacá. Arimatea eyaje ri'imacá. Jesús ja'apiyá jema'ajeri caja ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ricá penaje i'ijnari Pilato ejo, riquejá'acaloje Jesús tami riliyá penaje. E Pilato yuriri rijló ritami. ");
INSERT INTO ycn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Raú ripa'ó ritami huitúca'ataje. Rihuitúca'ata ritami. Ejomi ripila'á palá nojé a'arumacaji ritami nacú. ");
INSERT INTO ycn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Támijimi to'otáquelana chojé ri'ijnatá ritami. Huajé ichácanami jipa i'imacá. Rijluhua rihuacára'a richácana i'imacá. Ricá chojé rito'otá Jesús tami. Caja penaje netá cajruni jipa aú rinumaná. Ejomi ripa'ó. ");
INSERT INTO ycn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","A'ajnare que riloco'opani María Magdalena, apa'ahuelo María, quele yá'año. ");
INSERT INTO ycn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Caja a'ajnejí lamá'atacana huacajé ja'apari. Muní que sacerdótena huacára'ajeño, fariséona, quele i'ijnaño Pilato amaje. ");
INSERT INTO ycn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nemá rijló: —Riphicha huapechu nacojé méqueca ilé pajlácachi quemacá rinacuhuá. Cajmuni ri'imacá huacajé rimá rinacuhuá: “Nenoje nucá. Eyá hueji que cala i'imajemi numacápo'ojo nopumí chuhuá”. ");
INSERT INTO ycn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ñaquele pihuacára'a surárana rejo, ne'emacáloje ritami hua'aphena hueji que cala quetana penaje. Pihuacára'a necá, ne'emacáloje rihua'aphena penaje, ra'apiyatéjenami i'ijnacá piyá ritami ata'ajé. Nata'aquela ritami, caja nemacajla rinacu: “Caja rimacápo'o” que. Marí que nala'aquela, napajlácare yucuna jema'acojla cajrú huani —que nemacá Pilátojlo. ");
INSERT INTO ycn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","E Pilato quemari najló: —I'ijná rejo, ileruna surárana naquiyana i'ijnajeño ijhua'até, ne'emacáloje rihua'aphena penaje, ajopana mujlúca'aca piyá rejo —que rimacá najló. —Je —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aú ne'ejná rejo. Nachúta'a inimú jipa netacare rinumaná nacojé. Raú nahue'epijla, apú cahuitáquela ricá, rimujlúca'acaloje richojé rimicho'ojneja penaje. Caja penaje nayurí cajrú surárana re rihua'aphena penaje. ");
INSERT INTO ycn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Caja huatána'acaje huacajé ja'apari i'imacá. Muní que najme'etaca. Sápacaje queño'ocó huacajé ri'imacá. E María Magdalena, apa'ahuelo María, quele i'ijnaño piño támijimi to'otáquelana ejo. ");
INSERT INTO ycn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mana'í chiyó caphí huani te'erí ñaca'acó na'apiyá. Re'iyohuá que pajluhua Tupana hua'atéjeri huitúca'aca je'echú chiyá jipa jatataje rinumaná eyá. Ratatá jipa reyá. Ejomi riyá'o rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mejáma'atani huani que ramaco, pichaní camaré que. Jaré nojé huani ra'arumacá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Marí que surárana, támijimi hua'aphena, amaca aú cajrú huani naquero'ocó. Cajrú caja nacurúca'aca raú. Matámiru queja nato'ocó te'erí e'iyá re. ");
INSERT INTO ycn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","E inaana iphaño rejo. E Tupana hua'atéjeri, je'echú chiyaje, quemari najló: —Iquero'oniyo. Nuhue'epí i'ijichaca majó Jesús tami amaje, ricá nacúhua'atacare a'ahuaná apiyácacanami naquiyá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Uncá ri'imalá maare. Caja rimacápo'ocho. Rimacá rinacuhuá queja rimacápo'ochaco. Imujlúca'a majó, amachi rapucunami. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","E rimá piño najló: —Chuhua ipa'ó quiñaja, i'imichachi ra'apiyatéjenajlo riyucuna. Caja rimacápo'ocho. Caja ri'ijichá natucumá Galilea ejo, que i'imajica najló riyucuna. Caja numicha ijló —que Tupana hua'atéjeri quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aú pherú queja inaana pa'acó jecho'oquelo reyá. Quero'ocajo nacuja ne'emacá. Hua'ató que pu'ují napechu i'imacá raú. Necho'ó ají que a'ajná ño'ojó riyucuna i'imajé ra'apiyatéjenajlo. ");
INSERT INTO ycn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","E napunana chu Jesús ya'ataró najló. Rajalaca necá. Aú ne'ejná Jesús ahua'ajé. Pu'ují napechu i'imacá rinacu, aú najláma'o ri'imá nacojé. Namahuílo'o ricá ritajné naquiyá. ");
INSERT INTO ycn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","E rimá najló: —Iquero'oniyo. I'ijná, i'imichachi nuyucuna nojénajlo. Imicha najló ne'ejnachi Galilea ejo. Re namaje nucá. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Caja inaana i'ijnaño riyucuna i'imajé ajopánajlo. A'apona surárana, rihua'aphena i'imacaño, i'ijnaño pajimila ejo riyucuna i'imajé sacerdótena huacára'ajeñojlo. ");
INSERT INTO ycn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Riyucuna jema'acana aú Sacerdótena huacára'ajeño i'ijnaño peñahuilana hua'até rinacu pura'ajó. Panacojéchaca que napechu i'imacá méqueca nala'ajica nacú. Eyá na'á suráranajlo cajrú liñeru, ne'emacá piyá riyucuna ajopánajlo. ");
INSERT INTO ycn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","E nemá suráranajlo: —Marí que imájica ajopánajlo: “Lapí huacamátaco cháyomi ra'apiyatéjenami i'imaño rata'ajé”. ");
INSERT INTO ycn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ihuacára'ajeri jema'ajica ee riyucuna, huecá pura'ajeño ichaya, rihuátajica ee ihuajácana uncá pachá i'imalá rihua'aphena palá —que Sacerdótena huacára'ajeño quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","E na'á najló liñeru. Ejomi nahuacára'aca riyucuna i'imacana que ne'emacá riyucuna reyá a'ajná ño'ojó. “Ra'apiyatéjena ata'añó ritami,” que nemájica rinacu. Eyá maárejecha ñaqueja riyucuna. Ejo'ocaja judíona naquiyana quemaño ñaqué rinacu. ");
INSERT INTO ycn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Caja ra'apiyatéjena jema'añó rimacápo'oco yucuna. Aú ne'ejná Galilea ejo, yenuri Jesús quemacare nacú najló ejo. Pajluhuaja iphata ji'imaji nacojé quele ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","E nephá Jesús nacú. Pu'ují caje aú ne'ejnataca napéchuhua Jesús nacú ramácana aú. Ne'iyajena pechu i'imá: “¿Ricá huani chi ricá, apú ca'ajná?” ");
INSERT INTO ycn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","E Jesús i'ijnari nahua'ajé. E rimá najló: —Caja Tupana a'arí nucá Ihuacára'ajeri penaje, piyuque marí eja'ahuá chu, je'echú chu i'imacaño huacára'ajeri penaje ra'á caja nucá. ");
INSERT INTO ycn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ñaquele numá ijló: Eco i'ijná ajopana te'eré ejo, ajopana te'eré ejo que nupuráca'alo ja'apátacana nacú piyuqueja ina'uquejlo rehuá. Raú ne'iyajena jema'ajeño no'opiyá, ne'emacáloje nujhua'atéjena penaje. Re Nora'apá Tupana, nucá Ri'irí, Tupana Pechu, quele. Hua'apiyá ne'emajica aú ila'á bautizar necá. ");
INSERT INTO ycn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jehuíña'ata caja necá, na'acáloje nupuráca'alo nanacojó piyuqueja penaje. Nucá i'imajeri ijhua'até hua'ajini huani eja'ahuá tajnájico ejená. Uncá nuyurílaje icó icá —que Jesús quemacá najló. Caja quetana riyucuna.");
INSERT INTO ycn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Marí yucu, Jesucristo yucuna. Palani huani riyucuna, Tupana la'acale iná palá ripalamane aú. Tupana I'irí huani ricá, Jesucristo. Palani huani riyucuna. Júpimi uncá chiyó riphá majó marí eja'ahuá nacojé i'imacá, apú queño'orí riyucuna i'imacana ripiyá. Rií i'imari Isaías. Tupana puráca'alo ja'apátajeri ri'imacá. Júpimi, uncá chiyó Tupana huacára'a Ri'irí majó marí eja'ahuá nacojé i'imacá, ri'imá rijló riyucuna. Marí que Isaíasmi chu lana'acá riyucuna: Nuhuacára'aje apú ina'uqué pitucumá, ri'imacáloje piyucuna ina'uquejlo penaje. Ricá quemájeri najló, nalamá'atacaloje napéchuhua pijló pipé penaje. ");
INSERT INTO ycn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nema'ajé pajluhuaja ina'uqué jahuíyo'oca pu'uteni meñaru chu. Marí que rimájica ina'uquejlo: “Chuhua ilamá'ataca ipéchuhua palá Huahuacára'ajerijlo. Ipajno'otá caja ipéchuhua pu'uhuaré ila'acare liyá,” que rimájica najló. Marí que Tupana i'imacá Ri'irijlo Juan yucuna, uncá chiyó Juan i'imá. ");
INSERT INTO ycn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","E caja ehuaja rimacare nacú iphari rená chojé. Juan i'imari i'imacá. Ri'ijná pu'uteni meñaru chojé. Re rila'aqué bautizar ina'uqué naquiyana. Ri'imaqué Tupana yucuna najló, marí que rimájica najló: —Chuhua ipajno'otá ipéchuhua Tupana ejo, pu'uhuaré ila'acare liyá, imanaicho ila'acare liyá. Raú Tupana amájero ichaje pu'uhuaré ila'acare liyá. Ejomi nula'ajé bautizar icá —que rimájica najló. ");
INSERT INTO ycn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Piyuque ina'uqué, Judea te'eré e'iyohuá i'imajícaño, i'ijnaqueño ripuráca'alo jema'ajé. Ñaqué caja pajimila Jerusalén e i'imacaño i'ijnajica rejo. Re nema'aqué ripuráca'alo. Eyá ne'emajica ee pu'uhuaré nala'ajícare yucuna Tupánajlo, Juan la'aqueri bautizar necá juni Jordán acojé. ");
INSERT INTO ycn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan a'arumacá i'imari camello chijné naquiyá la'acanami. Rihuachaphila i'imari camejeri ímami naquiyá la'acanami. Ra'ajné i'imaqueri caja'ayuna caje, munumunú jalá caje. ");
INSERT INTO ycn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tupana yucuna ri'imaqué ina'uquejlo, rimaqué najló: —Nopumí chojé apú iphájeri. Iqui'i huani nuphácare ja'apí ricá, nuchaje huani ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nucá la'arí bautizar icá juni aú, eyá ricá a'ajeri ina'uquejlo Tupana Pechu. ");
INSERT INTO ycn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Juan i'imacá pu'uteni meñaru chu huacajé, Jesús jácho'oro pajimila Nazaret eyá, ri'ijnacáloje Juan chaje penaje. E caja ri'ijná, iphari Juan nacú. Re Juan la'arí bautizar ricá juni Jordán acojé. ");
INSERT INTO ycn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Rila'acá bautizar ricá ejomi Jesús jácho'oro junápiya. Ejéchami riyacá'aco je'echú chojé, amari je'echú je'echataco. Ricá chiyá ramá Tupana Pechu huitúca'aca ají que majó. Túcu'uchi huitúca'aca nacaje nacojé que rihuitúca'aca ají que Jesús nacojé. ");
INSERT INTO ycn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ejéchami Tupana quemacá marí que rijló je'echú chiyá: —Picá Nu'urí. Iqui'ija nuhuátacare picá. Pu'ují huani nupechu pinacu —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Rila'acá bautizar ri'imacá ejomi Tupana Pechu huacára'ari Jesús ya'ajnaje pu'uteni meñaru chojé. Aú ri'ijná rejo. ");
INSERT INTO ycn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Re ri'imá ricoja iyamá ina'uqué le'ejé que cala quetana. Re caja camejérina i'imacá. Re ri'imacá huacajé, Jiñá Chi'ináricana iphari Jesús nacú. Rihuata re'iyajé ca'átacana, rila'acáloje pu'uhuaré penaje. E'iyonaja uncá rema'alá ra'apiyá. Rihuacajé caja Tupana hua'atéjena, je'echú chiyájena, iphaño rejo Jesús ñaté a'ajé. ");
INSERT INTO ycn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Naca'acá Juan ina'uqué huajáquelana chojé yámijo Jesús i'ijnari Galilea te'eré ejo. Re ri'imá Tupana i'imataca ina'uqué capichácajo liyá yucuna najló, nema'acáloje ra'apiyá penaje, ne'emacáloje rijhua'atéjena raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Rimaqué najló: —Caja riphá rená chojé ijló, Tupana i'imacáloje Ihuacára'ajeri penaje. Mequetánaja i'imajemi yuriro huatucumá, Tupana i'imacáloje ina'uqué naquiyana huacára'ajeri penaje. Chuhua ipajno'otá ipéchuhua pu'uhuaré ila'acare liyá, imanaicho ila'acare liyá hua'ató. Tupana i'imatari ina'uqué capichácajo liyá. Ipechu i'imá caphí richojé, raú ri'imataje icá capichácajo liyá —que rimájica najló. ");
INSERT INTO ycn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","E caja Jesús chira'aró ají que caesa turenahua. Galilea caesa ií. Re ramá Pedro, re'ehué Andrés hua'até. Jiña ña'ajeño huená chojé nacú sápajeño ne'emacá. Nahuenare naca'acá ejé riphá nanacu. ");
INSERT INTO ycn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","E rimá najló: —I'ijná nujhua'até. Jiña ña'acana nacú sápajeño icá. Eyá chuhua no'ojica ijló apú sápacaje. Ihuá'aje nojló ina'uqué, ne'emacáloje no'opiyá jema'ajeño penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Marí que rimacá najló aú nayurí nahuenare nacápiya. E caja ne'ejná rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Reyá Jesús ja'apari piño a'ajná ño'ojó pani. Re ramá Santiago, re'ehué Juan hua'até. Nara'apá ií i'imari Zebedeo. Netane chu ne'emá nahuenare lamá'atacana nacú. ");
INSERT INTO ycn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ramá necá. E rimá Santiago, Juan, quélejlo: —I'ijná nujhua'até. Raú caja ne'ejná Jesús hua'até. Ja'apáñaño nara'apá, najhua'até sápajeño, quele. Necá yuriño netane chu. ");
INSERT INTO ycn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","E caja nephá pajimila Capernaum ejo. Nale'ejé huatána'acaje huacajé Jesús i'ijnari nahuacáca'alo ñacarelana chojé. Richu rehuíña'ata necá Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","“¡Meque palá huani rehuíña'atalaca huecá!” que ripuráca'alo jema'ajeño pechu i'imacá rinacu. Palá rihue'epica nacaje nacojé rehuíña'atacare nacú. Tupana puráca'alo nacú jehuíña'atajeño, rehuá i'imacaño, uncá hue'epílaño palá rijlunami chojé. ");
INSERT INTO ycn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Re caja apú i'imari nahuacáca'alo ñacarelana chu. Jiñá pechu i'imari re'iyá. E rahuíyo'oco rimacá marí que Jesúsjlo: ");
INSERT INTO ycn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús, Nazaret eyaje ¿naje picahuíla'a huanacu? ¿E piphaca majó huacapichátaje? —que rimacá rijló—. Nomána'apa picá. Ilé uncá la'alá pu'uhuaré picá. Tupana i'imacá e eyaje caja picá —que jiñá pechu i'imacare re'iyá quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","—Pimanúma'o, pácho'o ilé ina'uqué e'iyayá —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eta jiñá pechu curúca'atari caphí huani ilé ina'uqué napona. Cajrú jiñá jahuíyo'oca. Hua'ató que rácho'oco re'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","“¡Meque piyuque huani rila'acá cari!” que ramájeño pechu i'imacá Jesús nacú. Nemá pajlocaca: —¡Meque piyuque huani rila'alaca cari! Huajé huani huajló ripuráca'alo. Raú ja calé rihuacára'a jiñana pechu jácho'oco ina'uqué e'iyayá. Nema'á ra'apiyá —que nemacá pajlocaca. ");
INSERT INTO ycn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Marí que rila'acá ejomi cajrú riyucuna jema'acó Galilea te'eré e'iyohuá piyuque. ");
INSERT INTO ycn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","E caja nácho'o nahuacáca'alo ñacarelana chiyá. Ejomi Jesús i'ijnari Pedro, Andrés, quele ñacaré ejo. Santiago, Juan, quele i'ijnaño caja najhua'até. ");
INSERT INTO ycn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Re Pedro yajneru to'oyó jelo'ocajo nacú. E nemá Jesusjlo: —Rutami rucá. ");
INSERT INTO ycn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Raú ri'ijná rohua'ajé. Ripatá rucá ruyáte'ela naquiyá, rácho'ota rucá. Hua'ató que jelo'ocajo mata'acá ruliyá. Rejomi rutamáca'ata najló a'ajnejí. ");
INSERT INTO ycn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","E caja najúhua'a. Camú ja'acó ee, cajrú ina'uqué huá'año natámina Jesús i'imacá ejo. Jiñana pechu i'imacárena e'iyá ne'iyajena i'imacá. Nahuá'a necá rejo piyuqueja. ");
INSERT INTO ycn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ehuá piyuque pajimila eruna jahuacaco pají numanaje. ");
INSERT INTO ycn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Re ritejmo'óta cajrú natámina. Que'iyapejé nayaripune rica'atá nanaquiyá. Ajopana ina'uqué e'iyayá rica'á jiñana pechu. Uncá Jesús yurila jiñana pechu pura'acó, namána'apa ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","E muní que, lapiyami luhuíchipica ee, Jesús jácho'oro. Ri'ijná ají que pajimila yámojo, ri'imacáloje ricoja re penaje. Re ripura'ó Tupana hua'até. ");
INSERT INTO ycn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A'apona que Simón i'ijnacá riculaje rijhuáque'ena hua'até. ");
INSERT INTO ycn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","E caja ehuaja nephata ricá. E nemá rijló: —Piyuque ina'uqué culaño picá me'etení. ");
INSERT INTO ycn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Raú Jesús quemari najló: —Chuhua i'ijná hue'ejnachi apú eyá, apú eyá que nu'umichachi caja Tupana yucuna najló. Ricá penaje nu'ujná majó —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","E ri'ijná piyuque Galilea te'eré e'iyohuá. Nahuacáca'alo ñacarelana chojé, apalá chojé, apalá chojé que ri'ijnajica Tupana yucuna i'imajé najló. Rica'aqué caja cajrú jiñana pechu ina'uqué e'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","E caja apú iphari Jesús nacú. Ritami ri'imacá, napona patáca'ataro ri'imacá. Riphaca Jesús nacú ee ritára'o ri'irúpachi aú rijimaje. Rimá rijló: —Pihuátajica ee, pa'apata nuliyá nuyaripune. ");
INSERT INTO ycn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aú Jesús hue'epiri camu'ují rinacu. Risapa rinacu riyáte'ela aú, rimá rijló: —Je, nuhuata ra'apátacana piliyá. Caja ripali'ichó pijló. ");
INSERT INTO ycn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Marí que rimacá rijló, hua'até que rinapona pala'acó rijló. ");
INSERT INTO ycn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","E Jesús huacára'ari ricá sacerdote amaje. ");
INSERT INTO ycn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Rimá rijló: —Pema'á, pi'imaniya nuyucuna ajopánajlo. Pi'ijná sacerdote chaje, ramíchachi picá. Quéchami pa'ajica Tupánajlo nacaje, pinapona pali'ichaco aú. Moisesmi chu huacára'aca i'imacá que pa'ajica Tupánajlo nacaje. Marí caje aú ina'uqué hue'epéjeño caja palani chuhuaca pinapona, pi'imacáloje piño najhua'até penaje —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","—Je. E ri'ijná reyá. E'iyonaja ri'imá riyucuna piyuque ina'uquejlo, riphátacarenajlo. Pachá uncá meño'ojó Jesús i'ijnalá pajimila e'iyajé, cajrú huani ina'uqué huátacale ramácana. Raú riyuró ya'ajná pu'uteni meñaru chu. Uncá nañacaré i'imalá rehuá. Rejeja ne'ejnaqué cajrú ramaje. Apú eyá, apú eyá que ne'ejnajica richaje. ");
INSERT INTO ycn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Meque cala i'imajemi Jesús pa'aró piño Capernaum ejo. Riphaca rejo yucuna moto'orí rehuá cajrú. Yucu i'imari: —Caja riphicha majó, pachu ricá me'etení. ");
INSERT INTO ycn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Raú cajrú huani ina'uqué i'ijnacá richaje. Pu'uté nahuacaco pachoje. Rinumanahua, ricópihua hua'ató nahuacó cajrú. Uncá meque la'ajé ajopana mujlúca'ala richojé. Pají chu Jesús i'imari Tupana yucuna najló. ");
INSERT INTO ycn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ehuá pa'u quele achiñana iphaca rejo. Cuhuana nacú nahuáco'o pajluhuaja ritami, camachá napona taca'acá ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cajrú huani ina'uqué tami yá'aco ricópihua. Nanacojé uncá meño'ojó nephala Jesús ahua'ajé. Raú ne'ejrá pají i'ihuátaje. Pu'ucuja to'otácanami nañacaré i'ihuata i'imacá rehuá. Reyá najiyo'otá pají ji'ihuátaya Jesús loco'opániya. Richiyá nahuitúca'ata ritami ají que Jesús ahua'ajé. ");
INSERT INTO ycn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús hue'epiri caphí napechu i'imacá richojé, ritejmo'ótacaloje ricá penaje. Raú rimá ritámijlo: —Caja nomicho pichaje pu'uhuaré pila'acare liyá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tupana puráca'alo nacú jehuíña'atajeño naquiyana i'imaño caja re. Marí que rimacá aú napechu i'imá: ");
INSERT INTO ycn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¡Meque pu'uhuaré huani ta rimíchaca! Tupánaja calé amaro ina'uqué chaje pu'uhuaré nala'acare liyá. Uncá Tupana calé ricá,” que napechu i'imacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús hue'epiri napechu i'imacá ilé que rinacu. Aú rimá najló: —¿Naje ilé que huani ipechu nunacu? ");
INSERT INTO ycn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Majopeja iná quemacajla apujlo: “Caja nomicho pichaje, pu'uhuaré pila'acare liyá”. Eyá puhuichani inajlo, iná huacára'acaloje ritami jácho'oco, ra'apácaloje penaje. Tupánaja calé hue'epiri natámina tejmo'ótacana —que rimacá najló—. ");
INSERT INTO ycn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ina'uquéjloje penaje i'imacá nucá. Tupana quemari nunacu, nomácoloje ina'uqué chaje, pu'uhuaré nala'acare liyá penaje. Nula'ajícare aú me'etení, ihue'epeje quehuaca jo'ó nojló ricá —que rimacá najló. E rimá camachá napona taca'acá i'imacajlo: ");
INSERT INTO ycn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Pijló numá, chuhua pácho'o. Pijña'á picamané pijhua'ató, pipa'achó. ");
INSERT INTO ycn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ejéchami ritami jácho'oco pila pila que. Nejlú chuhuá ra'apá. Raú ramájeño pechu i'imá Jesús nacú: “¡Meque piyuque huani la'acá ricá!” Palá napura'acó Tupana nacú, ra'acale Jesús ñaté. Nemá pajlocaca: —Uncá huani huamala apú la'acá marí rila'acá que caja. ");
INSERT INTO ycn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","E caja Jesús i'ijnari piño caesa turenajo. Riphá rejo. Rejé cajrú ina'uqué jahuacaco piño rinacojé. Aú rehuíña'ata necá re. ");
INSERT INTO ycn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Rehuíña'ataca necá ejomi ri'ijná chira'ajó ají que a'ajná ño'ojó. Amari Mateo yá'aco risápaca'ala la'acana nacú. Liñeru riquejá'a ina'uqué liyá, ra'acáloje ricá ne'emacánajlo penaje. Alfeo i'irí ri'imacá. Ramá riyá'aco. E Jesús quemari rijló: —Pi'ijná nujhua'até. —Je —que rimacá. Raú rácho'o, ri'ijná rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","E caja Mateo ñacaré chu Jesús ajñari ra'ajnehuá cajrú ajopana ina'uqué hua'até. Cajrú ajopana liñeru ña'ajeño ne'emacánajlo yá'año caja rijhua'até. Ajopana, nemacárena nacú: “Uncá ina'uquélaruna necá” que, hua'até caja riyá'o. Cajrú marí cajena chira'acó rijhua'até rihuacajé. Jesús ja'apiyatéjena i'imaño caja re. ");
INSERT INTO ycn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tupana puráca'alo nacú jehuíña'atajeño naquiyana i'imaño fariséona. Necá amaño Jesús ajñaca ra'ajnehuá ileruna ina'uqué hua'até. Aú nemá ra'apiyatéjenajlo: —¿Naje chi jehuíña'atajeri ajñari ra'ajnehuá ileruna hua'até? Ne'iyajena uncá ina'uquélaruna necá. Liñeru ña'ajeño ne'emacánajlo necá ajopana. ");
INSERT INTO ycn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús jema'arí nemacá marí que najló. Aú rimá najló: —Uncá peyajhuéruna i'ijnalaño pusána'ajeri amaje. Natáminaja calé i'ijnaño ramaje. Ñaqué caja ina'uquejlo nucá. Re ina'uqué, natámina que necá Tupánajlo, pu'uhuaré la'ajeño ne'emacale. Ne'iyajena pechu i'imá nanacuhuá: “Pu'uhuaré la'ajeño huecá” que. Nu'ujná majó Tupana yucuna i'imajé ilé cajénajlo, napajno'otácaloje napéchuhua pu'uhuaré nala'acare liyá penaje, ne'emacáloje lamára'ataquejami que Tupánajlo raú penaje. Eyá ajopana, napechu i'imá nanacuhuá: “Palá la'ajeño huecá” que. E'iyonaja uncá ñaqué calé necá. Uncá nu'ujnalá majó ilé cajénajlo riyucuna i'imajé —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juan ja'apiyatéjena, fariséona ja'apiyatéjena, quele i'itacó na'ajné liyá huacajé, ajopana iphaño Jesús nacú. Nemá rijló: —Juan ja'apiyatéjena i'itañó na'ajné liyá; fariséona ja'apiyatéjena, ñaqué caja. Eyá pa'apiyatéjena ta uncá i'italaño na'ajné liyá —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús quemari najló: —Nahuá'acaco huacajé, necá nayucupéra'acarena, uncá i'italaño na'ajné liyá, ilé ruyajná penaje i'imacá najhua'até quetana. ");
INSERT INTO ycn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ñaqué caja ricá no'opiyatéjenajlo. Najhua'até nu'umacá quetánaja uncá ne'etaló na'ajné liyá. Tupana huá'ajeri nucá naliyá, rejomi ne'etajó na'ajné liyá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Uncá na calé mata'arí a'arumacaji huajé naquiyana jupichumi tepé penaje. Re'iyayá ripácana aú jupichumi jiyo'otaro huajé liyá. Caja penaje richaje huani jiyo'otáqueja jupichumi a'arumacaji yurico. ");
INSERT INTO ycn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Uncá caja iná aco'olá nacaje jalá huajé amúra'ataca jupichumi ra'acuná chojé, iná lamá'atacaloje ricá richu penaje. Camejeri ímami naquiyá la'acanami ricá ra'acuná. Ilé que iná la'acachu huajé amúra'ataca huapa'atari jupichumi ra'acuná, caja ñaataco ri'imacale. Ejeja ricapichó jupichumi ra'acuná hua'até. Eyá huaje ra'acuná chojé iná aco'ocachu huajé nacaje jalá amúra'atacanami, uncá rijiyo'otala ricá, camejeri ímami ñaacole rijhua'até —que Jesús i'imacá najló yucu, nayurícaloje naliyó jupichumi puráca'aloji, ripuráca'alo lanaquiya penaje. ");
INSERT INTO ycn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Huatána'acaje huacajé Jesús ja'apari ají que iñe'epú chuhuá ra'apiyatéjena hua'até. Iñe'epú ja'apari ajopana mená e'iyohuá. Re'iyá cajrú trigo i'imacá. Na'apaca re'iyohuá nacuhuaja ra'apiyatéjena ña'añó huejapa rinaquiyana. Natojro'ó nacápojo ricá, najñácaloje ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Raú fariséona quemaño Jesusjlo: —¡Piyacá'o! Chuhuajá huatána'acaje huacajé. E'iyonaja cajona pa'apiyatéjena sapaño. Uncá nala'alá Moisesmi chu puráca'alomi quemacá que. ");
INSERT INTO ycn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Aú rimá najló: —Icá hue'epiño méqueca Tupana puráca'alo lana'aquéjami quemacá Davidmi chu nacú. Marí que rila'acá Abiatarmi chu i'imacá sacerdótena huacára'ajeri huacajé: Quehuí rijló me'epejí i'imacá. Ñaqué caja quehuí me'epejí i'imacá rijhua'até i'imacáñojlo. ");
INSERT INTO ycn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A'acuhuaná Davidmi chu mujlúca'ari Tupana ñacaré chojé pan ajñaje, Tupánajlo a'acanami ri'imacá. Moisesmi chu puráca'alomi quemari rinacu, ajopana ajñaca piyá ricá. Necaja calé, sacerdótenaja calé ajñaño ricá. E'iyonaja Davidmi chu ajñari ricá. Ra'á caja rijhua'até i'imacáñojlo rinaquiyana —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","—Uncá huatána'acaje huacajéjloje penájeja calé Tupana queño'ótari ina'uqué i'imacá. Nahuatána'acaloje najluhua nasápaca'ala liyá penaje calé Tupana huacára'ari nahuatána'aca huatána'acaje huacajé. ");
INSERT INTO ycn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ina'uquéjloje penaje i'imacá nucá. Tupana quemari nunacu, numacáloje méqueca iná la'acá huatána'acaje huacajé penaje —que Jesús quemacá fariséona naquiyánajlo. ");
INSERT INTO ycn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","E apú huatána'acaje huacajé piño Jesús mujlúca'ari nahuacáca'alo ñacarelana chojé. Re apú i'imari najhua'até. Caja riyáte'ela a'amitaró rijló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Re caja ajopana i'imaño. Necá quejíla'año Jesús, namácaloje méqueca rila'acá penaje. Rilamá'ataquela ricá huatána'acaje huacajé, nemajla rinacu: “Pu'uhuaré la'ajeri ricá” que. ");
INSERT INTO ycn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","E Jesús quemari riyáte'ela a'amitarojlo: —Pácho'o majó huajimajo. ");
INSERT INTO ycn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","E rimá ajopánajlo: —¿Meque iná la'acá huatána'acaje huacajé? ¿Meque chi Tupana puráca'alo lana'aquéjami quemacá rinacu? ¿E chi palani iná la'acá palá ca'ajná, chapú ca'ajná huatána'acaje huacajé? ¿E chi palani iná i'imatacá ina'uqué capichácajo liyá ca'ajná, nacapichátacana ca'ajná huatána'acaje huacajé? —que rimacá najló. E'iyonaja uncá na'ajipalá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Raú riyacá'o nachaje yuríque'ela. Camu'ují ripechu la'acó najhua'até, ijnú nahuátacale ina'uqué mu'ují hue'epícana. E rimá riyáte'ela a'amitarojlo: —Piya'atá nojló piyáte'ela. Riya'ataca rijló ricá aú ja ripala'ó. Ripa'ó rapumí chuhuá júpimi ri'imacá que caja. ");
INSERT INTO ycn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Raú fariséona naquiyana jácho'oño nahuacáca'alo ñacarelana chiyá, napura'acóloje Herodes hua'atéjena hua'até Jesús nócana nacú penaje. Ritejmo'ótacale ina'uqué huatána'acaje huacajé chona nahuata rinócana. ");
INSERT INTO ycn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","E caja Jesús i'ijnari ra'apiyatéjena hua'até ají que caesa turenajo. Cajrú huani ina'uqué i'ijnaño rijhua'até. Ne'iyajena i'imaño Galilea eyájena. Ajopana i'imaño Judea eyájena. ");
INSERT INTO ycn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ajopana piño i'imaño Jerusalén eyájena. Ajopana piño i'imaño Idumea eyájena. Ajopana piño i'imaño Jordán pa'anajo pumitá eyájena. Ajopana piño i'imaño Tiro eyájena. Ajopana piño i'imaño Sidón eyájena. Iqui'iruna huani ne'emacá. Necá i'ijnaño ramaje, nema'acale piyuque nacaje Jesús la'acare yucuna. ");
INSERT INTO ycn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cajrú huani nahuacaco Jesús nacojé. Aú rimá ra'apiyatéjenajlo: —Iji'ichá nojló jita, ina'uqué majra'acá piyá nucá. —Je —que. ");
INSERT INTO ycn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Caja ritejmo'óta cajrú natámina i'imacá. Aú ajopana natámina jara'añó rinacojé, nasápacaloje rinacu penaje, natejmo'ocóloje raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ajopana e'iyá jiñana pechu i'imaño. Jiñana pechu amaca aú Jesús, ina'uqué ne'emacárena e'iyá tára'aqueño ne'erúpachi aú rijimaje. Nahuíyo'oco nemájica rijló: —Picá Tupana I'irí. ");
INSERT INTO ycn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aú Jesús huacára'ari necá caphí, ne'emacá piyá riyucuna ajopánajlo. ");
INSERT INTO ycn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Eyá Jesús i'ijnari yenuri i'ihuátaje. Reyá i'imajemi rihuá'a ina'uquejlo rihuátacarenajlo. Aú ne'ejná rejo. ");
INSERT INTO ycn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Iyamá iphata ji'imaji nacojé quele achiñana ne'emacá. E rimá najló: —Chuhua icá i'imajeño no'opiyatéjena. Nuhuacára'aje icá Tupana yucuna i'imajé ajopana, ajopánajlo que penaje. ");
INSERT INTO ycn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nupechu aú ica'ajé jiñana pechu ajopana ina'uqué e'iyayá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Marí quele ne'emacá ra'acárena ra'apiyatéjena penaje: Simón. Rapiyaca rií, ra'á rií Pedro. ");
INSERT INTO ycn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Apú i'imari Santiago, re'ehué Juan hua'até. Zebedeo yaní ne'emacá. Jesús a'arí neí Boanerges. “Ina'uqué catejmúruna pichaní que catejmuca”, que quemacana neí napura'acó chu. ");
INSERT INTO ycn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ajopana piño i'imaño: Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago, quele. Apú Santiago ri'imacá; Alfeo i'irí ri'imacá. Ajopana piño i'imaño: Tadeo, Simón, quele. Simón i'imari cananista naquiyana. ");
INSERT INTO ycn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Eyá caja penaje Judas Iscariote. Nenoca Jesús huacajé, ricá huá'ari ripinana Jesús i'imacá ejo, napatacáloje ricá penaje. Marí quele ne'emacá ri'ihuapacárena rijluhua ne'iyayá, ne'emacáloje ra'apiyatéjena penaje. ");
INSERT INTO ycn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ejomi Jesús i'ijnari pají chojé ra'apiyatéjena hua'até. Richape piño cajrú ina'uqué jahuacaco rejé Jesús chaje. Nanacojé uncá meño'ojó Jesús, ra'apiyatéjena, quele ajñalaño na'ajnehuá. ");
INSERT INTO ycn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Riyucuna iphari rejena nacú. Aú ne'ejná ripa'ataje. Yucu i'imá rehuá: “Caja rehuíji'icho.” ");
INSERT INTO ycn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tupana puráca'alo nacú jehuíña'atajeño naquiyana, Jerusalén eyájena ne'emacá, quemaño Jesús nacú marí que: —Jiñana huacára'ajeri ií Beelzebú. Jesús e'iyá ripechu. Ñaquele rihuacára'a ajopana jiñana pechu jácho'oco ina'uqué e'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","E Jesús huá'ari najló, ne'ejnacáloje rahua'ajé penaje. E ri'imá yucu najló, rehuíña'atacaloje necá raú penaje. Rimá najló: —¿Meque la'ajé chi jiñana huacára'ajeri, Satanás, ca'acajla rinaquiyana ina'uqué e'iyayá? ");
INSERT INTO ycn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ajopana huacára'ajeri hua'atéjena nócaquelo pajhua'atéchaca, nacapichátajla pecohuácaca raú. ");
INSERT INTO ycn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ñaqué caja iná ejena nócaquelo pajhua'atéchaca, nacapichátajla caja pecohuácaca raú. ");
INSERT INTO ycn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ñaqué caja ricá Jiñá Chi'ináricanajlo. Jiñana pechu rijhua'atéjena necá. Rica'aquela necá ina'uqué e'iyayá, rila'ájla chapú ricó raú. Uncá meque rila'alajla rejomi, uncale rijhua'atéjena i'imalajla raú. ");
INSERT INTO ycn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Uncá meño'ojó ina'uqué matejmuru mujlúca'ala catejmuni ina'uqué ñacaré chojé rinane ña'ajé riliyá. Apú richaje catejmuca ipháquela rinacu, ricá jepo'otárijla ricá. Quéchami rijña'atácajla rinane riliyá. Marí que Jesús i'imacá yucu najló, nahue'epícaloje raú richá'ataca Jiñá Chi'ináricana penaje. Rimá piño najló: ");
INSERT INTO ycn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Tupana amaro ina'uqué chaje piyuqueja pu'uhuaré nala'acare liyá, namanaicho nala'acare liyá hua'ató. Pu'uhuaré nemacare nacú liyá hua'ató ramó nachaje. ");
INSERT INTO ycn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Eyá pu'uhuaré nemacare Tupana Pechu nacú, ricaja calé uncá ramálajo nachaje riliyá. Caja queja ne'emajica hua'ajini huani. Uncá nachaje amácano i'imalaje. ");
INSERT INTO ycn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Marí que Jesús quemacá najló, Tupana puráca'alo nacú jehuíña'atajeño pura'acole pu'uhuaré rinacu. Tupana Pechu i'imacare re'iyá aú rica'á jiñana pechu ina'uqué e'iyayá. E'iyonaja nemá rinacu: “Jiñá pechu i'imacare re'iyá, aú rica'á necá ne'iyayá.” ");
INSERT INTO ycn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pachu Jesús i'imari cajrú ina'uqué hua'até. E Jesús jaló, rijmerénami, quele i'ijnaño rejo ramaje. Iphaño pají cópeje. E nemá apujlo: —Pimá rijló, ri'ijnachi majó. —Je —que. ");
INSERT INTO ycn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Cajrú ina'uqué yá'año Jesús hua'até pachu. E nemá rijló: —Piyacá'o, paló iphíchayo pají cópeje pijmerénami hua'até. Nahuata pijhua'até pura'acano. ");
INSERT INTO ycn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Rimá najló: —¿Mecajena chi necá nojena, noló, quele? ");
INSERT INTO ycn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","E riyacá'o rahua'á yá'acaño tujlá que chaje. Rimá najló: —Iyacá'o. Mariruna ina'uqué noló, nojena que i'imacaño necá nojló. ");
INSERT INTO ycn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tupana huátaca que la'acaño, necá nojena que nojló. No'ohué que, no'ohueló que, noló que nojló necá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ejomi ri'ijná piño caesa turenajo. Rejé cajrú huani ina'uqué jahuacaño piño rinacojé. Iqui'iruna ne'emacale, rihuitúca'a jita chojé yá'ajo. Ajopana yuriño que'epé nacú. E caja rehuíña'ata necá cajrú Tupana puráca'alo nacú. ");
INSERT INTO ycn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nacaje yucuna i'imacana nacú rehuíña'ata necá rinacu. Ehuá Jesús i'imacá yucu najló marí que: ");
INSERT INTO ycn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Jema'á. Pajluhuaja ina'uqué i'ijichari nacaje icha ijí ejátaje. Riqui'ichá richa ijí te'erí lamá'ataqueja jimahua. ");
INSERT INTO ycn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Rejátacana nacú ri'ijichá. Richa ijí, riqui'ichaje naquiyana, ja'acharo iñe'epú chojé. E caja cupira'aphana iphíchaño rajmílo'otaje. ");
INSERT INTO ycn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Apú richa ijí, riqui'ichaje naquiyana, ja'acharo jipa nacojé. Huejápaja te'erí i'imichari rinacu. Quiñaja riphíchaca, huejápaja te'erí i'imichácale rinacu. ");
INSERT INTO ycn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Camú moco'ochaca aú rimeríyi'icho, uncale ra'apare i'imalacha. ");
INSERT INTO ycn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Apú richa ijí, riqui'ichaje naquiyana, ja'acharo pu'uhuareni jimichi e'iyajé. Pu'uhuareni jimichi iphíchari nacaje icha ijí rejáchiyaje hua'até. Pu'uhuareni jimichi tahuá'añachari ricá. Raú rihuaji'ichá re'iyajé. Aú calé uncá rarúca'alacha. ");
INSERT INTO ycn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Eyá apú richa ijí, riqui'ichaje naquiyana, ja'acharo palani te'erí e'iyajé. Ilé calé iphíchari palá. Palá caja rarúqui'ichaca. Re'iyajé ejátacanami icha i'imari treinta ca'alá. Apú arúqui'ichari richahuá sesenta ca'alá. Apú arúqui'ichari piño richahuá cien ca'alá. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Marí que ri'imacá yucu najló. Ejomi rimá rema'ajéñojlo: —Icá que'ejhuirúnajlo numá: A'á inacojó riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesús i'imacá ee ricó apojó, riyucuna jema'ajeño naquiyana i'ijnaño richaje riyucuna quejá'aje riliyá. Iyamá iphata ji'imaje nacojé quele ra'apiyatéjena i'imaño caja najhua'até. Nemá rijló: —¿Meque quemacana chi quele yucu pi'imichaje huajló? ");
INSERT INTO ycn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","E rimá najló: —Me'echuje ina'uquejlo méqueca Tupana la'acá, ina'uqué naquiyana i'imacáloje rijhua'atéjena penaje. Chuhua icá ihue'epíjica rinacojé. Eyá ajopana, uncá nujhua'atéjena calé necá, uncá hue'epílajeño rinacojé. Najló yucu queja ricá. ");
INSERT INTO ycn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tupana puráca'alo ja'apátajerimi chu i'imari riyucuna júpimi i'imacá. Rimacá nanacu que necá. Marí que ri'imacá riyucuna i'imacá: Namaje nacaje. E'iyonaja uncá nahue'epílaje meque quemacánaca nacaje namájicare. Nema'ajé riyucuna. E'iyonaja uncá nahue'epílaje meque quemacánaca ricá. Ripháquela napechu nacojé, napajno'otácajla napéchuhua Tupana ejo pu'uhuaré nala'acare liyá. Raú ramojla nachaje pu'uhuaré nala'acare liyá —que rimacá riyucuna i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","E rimá piño najló: —Uncachu ihue'epila meque quemacánaca cari yucu, uncá caja ihue'epílaje meque quemacánaca apa'amá yucu nu'umajícare ijló —que rimacá najló—. Marí que quemacánaca ricá: ");
INSERT INTO ycn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tupana yucuna i'imajeri que caja nacaje icha ijí ejátajeri. ");
INSERT INTO ycn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ri'imá Tupana yucuna cajrú ina'uquejlo. Ne'iyajena jema'añó riyucuna. E'iyonaja Jiñá Chi'ináricana ca'arí napechu naquiyá Tupana puráca'alo nema'acare. Richa ijí naquiyana ja'acó iñe'epú chojé, que caja najló ricá. ");
INSERT INTO ycn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Eyá richa ijí naquiyana ja'aró jipa nacojé, huejapa te'erí i'imacare nacojé. Mequetánaja calé rijña'acá panacu riphaca ejomi. Ñaqué caja ina'uqué naquiyánajlo ricá. Nema'á Tupana puráca'alo, pu'ují napechu la'acó raú. ");
INSERT INTO ycn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mequetánaja calé napechu i'imacá palá ripuráca'alo nacú. Nahuátacale Tupana puráca'alo ja'apiyá i'imacana, ajopana ca'ajná la'añó necá chapú. Napura'ó ca'ajná nanacu pu'uhuaré. Namá ca'ajná chapú caje yajhué. Marí caje aú nayurí naliyó ricá, uncale napechu i'imalá caphí najluhua. ");
INSERT INTO ycn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Eyá richa ijí naquiyana ja'aró caja pu'uhuareni jimichi e'iyajé. Riphaca ejomi rihuaja'acá re'iyajé. Uncá rarúca'ala. Ñaqué caja ina'uqué naquiyánajlo ricá. Nema'á Tupana puráca'alo; naqueño'ó ra'apiyá i'imacana. ");
INSERT INTO ycn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","E'iyonaja cajrú na'acá nanacojó nacaje marí eja'ahuá chu i'imacare. Cajrú nacaje huátacana najluhua nahue'epí natucumó. Napechu nacú ri'imá: “Palá hue'emajica cajrú liñeru hua'até, ñó'ope le'ejepelaji caje hua'até”. E'iyonaja uncá ñaqué calé ricá ina'uquejlo. Marí que péchuruna ne'emacale, uncá na'alá nanacojó Tupana puráca'alo, nala'acáloje palá ra'apiyá i'imacana aú penaje. ");
INSERT INTO ycn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Eyá richa ijí naquiyana ja'aró caja palani te'erí e'iyajé. Ricá iphari palá; ritahuá'o; rarúca'a palá. Ñaqué caja ina'uqué naquiyánajlo ricá. Nema'á Tupana puráca'alo; na'á caja nanacojó ricá. Raú nala'á palá ra'apiyá i'imacana aú. Richa ijí naquiyana arúca'ari richahuá treinta ca'alá, sesenta ca'alá, cien ca'alá que. Ñaqué caja ricá Tupana puráca'alo ja'apiyá i'imacáñojlo. Ne'iyajena la'añó palá huejápaja. Richaje, richaje que ajopana la'acá palá —que ra'apátaca najló riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Rimá piño najló: —Iná lucúna'acachu iná camaré, uncá iná yá'atala ricá me'echú i'ichí lájma'ataqueja ja'apejé. Uncá caja iná yá'atala ricá iná camané ja'apejé. Yenú iná yá'ata ricá, ripatacáloje palá iná camaré penaje. ");
INSERT INTO ycn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Re Tupana puráca'alo naquiyana me'etení, me'echuje ricá ina'uquejlo. Quéchami nahue'epíjica rinacojé. ");
INSERT INTO ycn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jema'á, icá que'ejhuiruna —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Rimá piño najló: —Jema'á palá Tupana puráca'alo. A'ajeño nanacojó ricá pechu rila'ajé palá, nahue'epícaloje richaje, richaje que rinacojé penaje. Eyá necá uncá a'alaño nanacojó ricá, Tupana ca'ajeri naliyá huejápaja nahue'epícare rinacojé. ");
INSERT INTO ycn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús quemari piño najló: —Ina'uqué naquiyana huacára'ajeri Tupana. Chuhua nu'umajica yucu ijló, ihue'epícaloje rinacojé raú penaje: Apú i'ijnari nacaje icha ijí ejátaje te'erí lamá'ataqueja e'iyajé. ");
INSERT INTO ycn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Lapí ricamato, lapiyami rapó risápaca'ala nacojé. Muní, muní que ñaqueja hua'até ricá. Hua'até que nacaje rejátacare iphaca, tahuá'aro rijló. Uncá rihue'epila naca tahuá'ataca ricá. ");
INSERT INTO ycn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Te'erija calé tahuá'atari ricá. Pamineco rihuirulá jeño'orí. Ricá huicho'oró ripaná penaje. Ejomi rihuí jeño'orí, ricá chiyá richa jeño'orí caja. E caja penaje richa iphari rená chojé, paminá ña'acáloje richa penaje. ");
INSERT INTO ycn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Raú ri'ijná richa ña'ajé. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús i'imari piño najló yucu marí que: —Ina'uqué naquiyana huacára'ajeri Tupana. Re rijhua'atéjena huejápaja. Ehuá richaje, richaje que íqui'irunaca necá rijhua'atéjena. Chuhua nu'umajica yucu ijló, ihue'epícaloje méqueca ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostaza ijí que ricá, iná ejátacare iná i'icacapere e'iyá. Capajé nojé huani rijí. Uncá apú i'imalá ra'apejé marí eja'ahuá chu. ");
INSERT INTO ycn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Rejátacana ejomi riqueño'ó iphácaje. Richaje, richaje que ritahuá'aco. Jíma'alami yenuna quetana ritahuá'aco. Cajrú nojé caja ri'iché. Ripaná e'iyá cupira'aphana, camejérina cayuphéruna, cajena la'añó nañacaró re'iyá. ");
INSERT INTO ycn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Marí que Jesús jehuíña'atajica necá cajrú Tupana nacú yucu i'imacana aú. A'ajná nahue'epíjica ricá ejená, ri'imaqué najló yucu. ");
INSERT INTO ycn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Necámica que ne'emajica ra'apiyatéjena hua'até ee rihuicho'oqué piyuque riyucuna najló. ");
INSERT INTO ycn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","E caja najúhua'a. Raú rimá ra'apiyatéjenajlo: —I'ijná, huacuhuá'achi caesa pa'anajo pitá. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ne'emá nayucuno ina'uquejlo. Ejomi ra'apiyatéjena huitúca'año jita chojé, Jesús yá'acaro chu chojé nahuitúca'a. E naqueño'ó caesa cuhuá'acana pa'anajo pitá. Cha'apá ajopana, ajopana que cuhuá'año caja netane chu najhua'até. ");
INSERT INTO ycn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pe'iyojechá nacuhuá'aca ricá. Ejéchami mana'í chiyó carená noca necá caphí huani. Carená yoco'orí juni na'apiyá, amo'oró jita chojé cajrú juni. Ujú caje chiyó nejácajla. ");
INSERT INTO ycn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","E'iyohuá que Jesús camátaco ri'ipala chu. Rihuíla'aru ja'apí ja'ajona e'iyá ricamato. Huajé naqueño'ocá ejácaje ee napótaca ricá. —Huehuíña'atajeri —que nemacá—. ¿Uncá chi pa'alá pinacojó huacapichaco chuhuaca? ");
INSERT INTO ycn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","E Jesús jácho'oro, raca'á carená, rimá carenajlo: —Pa'apániya. Júnijlo rimá: —Piyoco'oniyo. Raú uncá carená ja'apala. Hua'ató que uncá juni yoco'oló. Mana'íja ri'imacá reyá. ");
INSERT INTO ycn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","E rimá ra'apiyatéjenajlo: —¿Naje chi iquero'ochó? ¿Uncá jo'ó chi ipechu i'imalá caphí nochojé? —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Quero'ocajo nacú jo'ó ne'emacá. E nemá pajlocaca: —¿Na ca'ajná cari? Carená, juni hua'até jema'arí ra'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","E caja nephá caesa pa'anajo pitá, Gerasa te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","E Jesús jácho'oro jita chiyá. Ejéchami apú ina'uqué iphaca rinacu. Jiñá pechu i'imari re'iyá. Támijimina ca'aquelana, jipa e'iyá i'imacare, chiyá riphá. ");
INSERT INTO ycn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Támijimina ca'aquelánaja i'imari rapucuna. ");
INSERT INTO ycn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Catejmuni huani ri'imacá. Pulapé nepo'otajla ricá curete aú. E'iyonaja rimata'á curete ta rinacojó. Uncá repo'ojona i'imalá; uncá caja na calé jepo'otárijla ricá. Na'aqué caja pejru'uhuá ra'anapitá nacojé, ritajné nacojé hua'ató. Rimajáca'ataque rinacojó ricá, rijítaminoja yuríquero raú. Uncá na i'imaqué ritejmú e'ehué; uncá na calé chá'ataqueri ricá. ");
INSERT INTO ycn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Hue'echú ca'alá queja, lapí hua'ató richira'acó ahuíyo'ocaje nacú ipuré e'iyohuá, támijimina ca'aquelana e'iyohuá hua'ató. Ritujla'aqué ricó jipa aú. Ricá penaje iphari Jesús nacú. ");
INSERT INTO ycn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ramaca aú Jesús júcaya recho'ó riloco'opani. Riphá rinacu ee ritára'o ri'irúpachi aú rijimaje. ");
INSERT INTO ycn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","E Jesús quemari jiñá péchu re'iyá i'imacárejlo: —Pácho'o re'iyayá. Cajrú rahuíyo'oca raú, rimá rijló: —Jesús, Tupana I'irí picá. Tupana je'echú churí i'irí picá. ¿Naje picahuíla'a nunacu? Pijló numá: Pila'aniya chapú nucá, uncá paala Tupánajlo ricá —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús quemari rijló: —¿Na pií? —Nuí íqui'iruna, íqui'iruna hue'emacale. ");
INSERT INTO ycn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mahuó rimacá Jesusjlo, rihuacára'aca piyá necá reyá. ");
INSERT INTO ycn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A'ajnare que cajrú je'eruna piracana chira'acó yenuri nacuhuá na'ajnehuá culácana nacú. ");
INSERT INTO ycn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Raú jiñana pechu quemaño rijló: —A'ajnáruna e'iyajé pihuacára'a huecá. ");
INSERT INTO ycn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Je —que Jesús quemacá najló. Raú jiñana pechu jácho'oño ilé ina'uqué e'iyayá, ja'añó je'eruna piracana e'iyajé. Dos mil je'eruna ne'emacá. Jiñana pechu ja'acó aú ne'iyajé necho'ó ají que a'ajná ño'ojó. Yenuri ji'ihuátaya na'ó caesa acojé. Rejeja nacapichó piyuqueja junápeje. ");
INSERT INTO ycn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Marí caje aú nalamára'ajeño penájemina ñaañó reyá. Ne'emá riyucuna pajimila erúnajlo, ajopana rehuá i'imacáñojlo hua'até. Raú cajrú ina'uqué i'ijnacá rejo ramaje. ");
INSERT INTO ycn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","E nephá Jesús nacú. Amaño ilé ina'uqué Jesús jácho'otacare e'iyayá jiñana pechu. Re riyá'o Jesús hua'até. Ca'arumacani ri'imacá; palá ripechu i'imacá. Marí que namaca aú ricá naquero'ó ripiyá. ");
INSERT INTO ycn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Re i'imacaño amaño maapami que Jesús jácho'otaca jiñana pechu re'iyayá. Namá caja je'eruna capichaco junápeje. Necá penájena i'imaño riyucuna huajé iphácañojlo. ");
INSERT INTO ycn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","E caja nemá Jesusjlo: —Pácho'o huate'eré naquiyá. —Je —que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","E rihuitúca'a jita chojé. Ejéchami jiñana pechu i'imacare e'iyá penájemi quemacá rijló mahuó: —Nu'ujná pijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","—Uncá pi'ijnalaje nujhua'até —que Jesús quemacá rijló—. Pipa'ó piñacaré ejo, pi'imacáloje pejena hua'até penaje. Palá huani Tupana li'ichaca picá. Cajrú rihue'epíchaca pimu'ují. Eco pi'imá riyucuna najló —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","—Je —que rimacá. E ripa'ó. Riqueño'ó riyucuna i'imacana rite'eré ehuájenajlo. Re'iyohuá iyamá té'ela quele pajimila i'imacá. Re ri'imá palá Jesús la'acare ricá yucuna najló. Riyucuna jema'ajeño pechu i'imá Jesús nacú: “¡Meque piyuque huani rila'acá!” ");
INSERT INTO ycn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","E caja Jesús cuhuá'ari jita chu ají que rapumí chuhuá piño caesa pa'anajo pitá. Narúca'aco ejé cajrú ina'uqué jahuacaño rinacojé. ");
INSERT INTO ycn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","E apú iphari rinacu, Jairo rií i'imacá. Nahuacáca'alo ñacarelana chiyá huacára'ajeri ri'imacá. Riphá rinacu. E rijláma'o ri'imá nacojé. ");
INSERT INTO ycn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Rimá rijló: —Aquíchajeru huani nutu, yehuíchaja rupechu capichaco. Pi'ijná nujhua'até nuñacaré ejo, pito'ochíyachi piyáte'ela runacojé, ru'umacóloje raú penaje —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","—Je —que Jesús quemacá rijló. E ri'ijná rijhua'até. Cajrú ina'uqué i'ijnaño rápumi chu. Cajrú namajra'acá ricá. ");
INSERT INTO ycn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Najhua'até caja apa'ahuelo ja'apayo, rutami ru'umacá. Iyamá iphata ji'imaji nacojé quele jarechí quetana ru'umacá rutami. Jirá ja'apáqueri runaquiyá. ");
INSERT INTO ycn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Caja cajrú pusána'ajeño atá'añojla rupusána'acana. Cajrú huani rujña'ajica quehuini yajhué panacu raú. Ruca'á ruliñérute piyuqueja, napusána'acaloje rucá penaje. E'iyonaja ñaqueja hua'até ru'umaqué. Richaje, richájeno que romájica quehuini yajhué. ");
INSERT INTO ycn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ehuá ne'emacá rojló Jesús yucuna. Aú ru'ujná ramaje. Ajopana hua'até ro'opá rápumi chu. Eyá rusapa ina'uqué ihuami chiyá ra'arumacá ji'imá nacú. ");
INSERT INTO ycn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Rupechu i'imá: “Nusápajica ee ra'arumacá nacú, nutejmo'otajo raú.” ");
INSERT INTO ycn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","E rusapa rinacu. Hua'ató que jirá ja'apácare runaquiyá mata'acó runacojé. Caja peyajhueru ru'umacá rejeja. Raú ruhue'epí runapona tejmo'otaco rojló. ");
INSERT INTO ycn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús hue'epiri ritejmo'ótaca rucá ripechu aú ja. Raú ripajno'ó riyámojo nachaje yacá'ajo. Rimá najló: —¿Na sápichari no'orumacá nacú? ");
INSERT INTO ycn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","E ra'apiyatéjena quemaño rijló: —¿Uncá chi pihue'epílacha cajrú ina'uqué majri'ichaca picá? ¿Eta naje chi pimá nanacu?: “¿Na sápichari no'orumacá nacú?” ");
INSERT INTO ycn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús yacá'aro ne'iyohuá piyuqueja, ramácaloje naca sápari ra'arumacá nacú. ");
INSERT INTO ycn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ilerú inanaru hue'epiyo caja rutejmo'otaco. Aú ru'ujná riloco'opani quero'ocajo nacú. Cajrú rucurúcaca. E rutára'o ru'urúpachi aú rijimaje. E ru'umá rijló riyucuna piyuqueja. Aú Jesús quemari rojló: ");
INSERT INTO ycn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","—Caja pitejmo'ochiyo chuhua, pipechu i'imacale caphí nochojé. Pipechu i'imichá nunacu: “Ricá ja'apátajeri nutami caje nuliyá” que. Aú calé pitejmo'ochiyo. Chuhua pi'ijná palá ca'ajnó. Caja pitejmo'ochiyo piyaripune liyá —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Marí que rimacá rojló ee ajopana iphaño Jairo nacú. Riñacaré eyá nahuacára'a ne'emacá. Nephá rinacu. E nemá rijló: —Caja pitu taqui'ichayo; caja rupechu capiícharo. Uncá na penaje calé picahuíla'a Jesús Huehuíña'atajeri nacú ruchaya —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Uncá Jesús a'alá rinacojó napura'acó. Rimá nahuacáca'alo ñacarelana chiyá huacára'ajerijlo: ");
INSERT INTO ycn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","—Pila'aniya picó camu'ují. Pila'á pipéchuhua caphí nochojé. E rimá ajopánajlo: —I'ijnaniya nujhua'até, maáreja iyuró. Pedro, Santiago, re'ehué Juan, queleja rihuá'a rijhua'ató. ");
INSERT INTO ycn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","E caja nephá riñacaré ejo, amaño cajrú ina'uqué i'imacá re. Cajrú namejé i'imacá. Nahuinano la'acana nacú cajrú neyaca rucá. ");
INSERT INTO ycn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","E rimujlúca'a rejo, rimá najló: —¿Naje ila'á ihuinano cajrú huani maare? ¿Naje chi iyá rucá? Uncá rutaca'alacha, rucamáchiyacoja calé —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Raú ne'echá rinacu. E Jesús quemari najló piyuque, namujlúca'acaloje a'ajná ño'ojó penaje. Rihuá'a rijhua'ató rora'apami, rolomi, rijhuáque'ena, queleja rihuá'a rijhua'ató. E namujlúca'a ucapú támijimi i'imacare chojé. ");
INSERT INTO ycn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","E ripatá rucá ruyáte'ela naquiyá. Rimá támijimijlo: —Talita cumi —que. Napura'acó chu rimá rojló: “Yuhualó, pijló numá, pácho'o.” ");
INSERT INTO ycn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Raú ja rócho'o; ruchira'ó. Iyamá iphata ji'imaji nacojé quele jarechí ru'umacá. Rijhua'até i'imacaño pechu i'imá rinacu: “¡Meque piyuque huani rila'acá!” ");
INSERT INTO ycn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Raca'acó rimacá najló nemacá piyá rimacápo'oca rucá yucuna ajopánajlo. E rimá najló: —A'á rojló a'ajnejí. ");
INSERT INTO ycn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E caja Jesús pa'aró ra'apiyatéjena hua'até ají que rite'eré ejo. Riphá rejo. ");
INSERT INTO ycn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","E nale'ejé huatána'acaje huacajé rehuíña'ata necá Tupana nacú nahuacáca'alo ñacarelana chu. Cajrú ripuráca'alo jema'ajeño i'ijnataca napéchuhua rinacu. Nemá rinacu: —¿Na liyá chi rihue'epí piyuqueja nacaje nacojé? ¿Na a'arí rijló ripechu? ¿Meque ca'ajná rihue'epí piyuque nacaje la'acana uncá meño'ojó iná la'alare? —que nemacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nemá piño pajlocaca: —Mirapehua nacú sápajeri ricá. María raló. Santiago, José, Judas, Simón, quele e'ehué ricá. Maare hue'iyá re'ehuelona ñacaré —que nemacá pajlocaca. Namána'apa ri'imacale, ijnú nema'acá ra'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","E Jesús quemari najló: —Piyuque ina'uqué iphaño Tupana puráca'alo ja'apátajeri ja'apí. Necaja calé rite'eré eruna, rejena, riñacaré chiyájena, quele uncá iphálaño ra'apí —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Uncá Jesús la'alá cajrú nacaje rehuá uncá meño'ojó iná la'alare. Rito'otá riyáte'ela huejápaja ina'uqué natámina nacú. Raú ja natejmo'otó. ");
INSERT INTO ycn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Uncá rehuájena pechu i'imalá caphí richojé. Raú Jesús pechu i'imá: “¿Naje ca'ajná ají que huani napechu?” Raú ri'ijná reyá apú eyá, apú eyá que nehuíña'atacana nacú. ");
INSERT INTO ycn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","E rahuacata iyamá iphata ji'imaji nacojé quele ra'apiyatéjena, ritamáca'atacaloje necá iyamano huánija najhuáque'ehue hua'até, ne'ejnacáloje apú eyá, apú eyá que penaje. Ra'á caja najló péchuji, naca'acáloje jiñana pechu ina'uqué e'iyayá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ne'ejnacá yámona rimá najló marí que: —Ijña'aniya nacaje ijhua'ató. Icutihuáreja calé ijña'ajé caja ijhua'ató. Ijña'aniya ijhua'ató a'ajnejí, itulané, liñeru, caje macá. ");
INSERT INTO ycn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Que'ema'uláruna i'ijnajé, pajluhua a'arumacaji chuja calé i'ijnajé. ");
INSERT INTO ycn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iphájica ee pajimila ejo, apú quemajeri ca'ajná ijló, iyurícoloje rijhua'até riñacaré chu penaje. Iyuró rijhua'até re i'imajica quetana. ");
INSERT INTO ycn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Apala uncá nahuátalaje icá, uncá caja ca'ajná nahuátalaje ipuráca'alo jema'acana. Marí que ri'imajica ee ijló, iñaca'á ji'ima'ulá naquiyá mu'upé najló reyá jácho'ocano aú. Nahue'epícaloje raú napachoje nacapichájico penaje. Numá ijló marí que ri'imajica: Tupana huajájica pu'uhuaré la'ajeño, namanaicho la'ajeño huacajé, cajrú rihuajájica ilé cajena, uncá pachá nahuátala icá. Cajrú rihuajájica Sodoma erúnami chuna. Ñaqué caja rihuajájica Gomorra erúnami chuna. Pu'uhuaré la'ajeño huani ne'emacale, rihuajaje necá. Nachaje íqui'ica rihuajájica necá, uncá huátalajeño icá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","E caja ne'ejná Tupana yucuna i'imajé ajopana, ajopánajlo que. Ne'emá najló riyucuna, napajno'otácaloje napéchuhua pu'uhuaré nala'acare liyá, namanaicho nala'acare liyá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Naca'á caja cajrú jiñana pechu ina'uqué e'iyayá. Na'á caja nacaje jilami cajrú natámina napona nacú. Raú natejmo'otó. ");
INSERT INTO ycn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Caja cajrú huani Jesús yucuna jema'acó rehuá i'imacá. Riyucuna iphari caja ne'emacana Herodes nacú. Raú rimá: —Juan Bautizar la'ajeri quele nemá nacú. Caja rimacápo'o. Aú calé rihue'epí piyuque nacaje la'acana. ");
INSERT INTO ycn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ajopana quemaño rinacu: —Ricá Elías. (Tupana puráca'alo ja'apátajeri Elíasmi chu i'imacá) Ajopana piño quemaño rinacu: —Tupana puráca'alo ja'apátajeri ricá. Júpimi i'imacaño naquiyana que caja ricá. ");
INSERT INTO ycn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jesús yucuna jema'acana aú Herodes quemari rinacu: —Juan Bautizar la'ajeri ricá, núru'upi nuhuacára'acare mata'acana i'imacá. Ricá penájemi macápo'oro piño —que rimacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ejo'ocaja Juanmi chu i'imacá huacajé, Herodes huacára'ari rica'acana ina'uqué huajáquelana chojé. Jepo'oqueja nayurí ricá richu. Marí que rila'acá ricá chapú riyajalo puráca'alo aú. Riyajalo ií i'imari Herodías. Re'ehué, Felipe, yajalo ru'umacá pamineco. Rica'á riliyá rucá. ");
INSERT INTO ycn_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Richona Juan aca'arí Herodes i'imacá. Rimá rijló: —Pe'ehué yajalo penájerumi ilerú pi'imá hua'até. Uncá Tupana huátala iná la'acá ilé que. ");
INSERT INTO ycn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Rijimaje Herodías yúcha'ayo Juan cha. Ruhuata rinócana. E'iyonaja Herodes itari rapu rojló. ");
INSERT INTO ycn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes quero'oró Juan piyá, rihue'epícale palá huani rema'acá Tupana ja'apiyá. Ñaquele Herodes huátari rimejñátacana ruliyá. Ri'ijnaqué ripuráca'alo jema'ajé; huechi ripechu i'imajica ripuráca'alo jema'acana nacú. E'iyonaja ricahuíla'aco rinacojé. ");
INSERT INTO ycn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","E caja ehuaja riphá rená chojé riyajalo Herodíasjlo. Herodes iphátari rile'ejé jarechí. Aú caja rila'á fiesta rijluhua. Rihuacára'a rijhua'até sápajeño la'acá cajrú a'ajnejí palá nojé. Cajrú rijhua'até huacára'ajeño, surárana huacára'ajeño, ajopana Galilea eruna chaje i'imacaño, quele necá ajñaño na'ajnehuá rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Re ne'emá na'ajnehuá ajñacana nacú rijhua'até. E'iyohuá que Herodías itu iphaca arápa'aje najimaje. Palá huani ri'imacá Herodes nacú, piyuque ajopana rijhua'atéjena quele nacú ri'imá palá. Aú Herodes, ne'emacana, quemari rojló: —Piquejá'a nuliyá nacaje pihuátacare caje, no'ochí pijló ricá. ");
INSERT INTO ycn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tupana hue'epiri quehuaca numacá. Nacaje piquejá'ajicare nuliyá no'ojé pijló ricá. Pe'iyojé nacaje nujhua'atéjena capi ejé no'ojé pijló ricá —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Raú rócho'o reyá riyucuna i'imajé rolojlo. Rumá rojló: —Amí, ají que rimíchaca nojló. ¿Na nuquejá'aje riliyá? —Pimá rijló, ra'achí pijló Juan Bautizar la'ajeri huíla'aru. —Je —que. ");
INSERT INTO ycn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","E pherú que rupa'acó ropumí chuhuá ne'emacana chaje. Rumá rijló: —Pa'á nojló me'etení Juan Bautizar la'ajeri huíla'aru pachiya chojé —que rumacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Camu'ují huani ripechu la'acó raú. E'iyonaja uncá meque rila'alajla. Caja rimá rojló ajopana jimaje: “No'ojé pijló pihuátacare caje. Tupana hue'epiri quehuaca numacá.” Ñaquele uncá rihuátala apojó la'acana. ");
INSERT INTO ycn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","E caja ne'emacana huacára'ari pajluhuaja surara Juan núru'upi mata'ajé. ");
INSERT INTO ycn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","E ri'ijná ina'uqué huajáquelana chojé. Mata'arí Juan núru'upi. Riyá'ata rihuíla'arumi pachiya chojé. Ejomi ri'imatá Herodías ítujlo ricá. Rucá ja'apátayo rolojlo ricá, raú ruhue'epí caja nenoca ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","E caja Juanmi chu ja'apiyatéjenami jema'añó nenoca ricá yucuna. Aú ne'ejná ritami ña'ajé, nato'otácaloje ritami támijimina to'otáquelana chojé penaje. ");
INSERT INTO ycn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","E caja necá, Jesús huacára'acarena i'imacá, pa'añó napumí chuhuá. Piyuque nacaje rehuá nala'acare yucuna ne'emá rijló. Piyuque nacaje nehuíña'atacare nacú yucuna ne'emá caja Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Cajrú huani ina'uqué i'ijnajica nachaje palanaquíyacaca que. Nanacojé uncá meño'ojó najñala na'ajnehuá. E Jesús quemari ra'apiyatéjenajlo: —I'ijná, hue'ejnachi a'ajná ño'ojó, hue'emacáloje huecámica que re penaje, ihuatána'acaloje mequetánaja rejo penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","E ne'ejná necámica que jita chu, ne'emacáloje juca ajopana ina'uqué liyá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","E'iyonaja cajrú ina'uqué amaño ne'ejnacá. Nahue'epí meño'ojoca ne'ejnacá; namá re caja Jesús i'ijnacá najhua'até. Aú necho'ó mata'aqueja pe'iyoóhua nápumi chu. Cajrú pajimila i'imacá rehuá. Re i'imacaño jecho'oñó caja najhua'até. Nephá punumaje chojé Jesús, ra'apiyatéjena, quele piyá. ");
INSERT INTO ycn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","E caja narúca'o. Jesús jácho'oco jita chiyá aú ramá cajrú ina'uqué. Rihue'epí namu'ují. Ohuéjana, uncá namájeri i'imalárena, que ne'emacá. Ñaquele rehuíña'ata necá cajrú nacaje nacú. ");
INSERT INTO ycn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ehuá najúhua'aca. E Jesús ja'apiyatéjena i'ijnaño rahua'ajé, nemá rijló: —Caja huajúhui'ichaca. Uncá nañacaré i'imalá maárohua. ");
INSERT INTO ycn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pihuacára'a necá maárohua ñacaré i'imacaño ejo, pajimila ejo hua'até, nahuarúhua'acaloje a'ajnejí najluhua reyá penaje —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","E'iyonaja Jesús quemari ra'apiyatéjenajlo: —Icá a'ajeño najló a'ajnejí. Aú nemá rijló: —¿E pihuátaca hue'ejnacá a'ajnejí huarúhua'aje najló? Iqui'ija huani rihuemí jácho'ojico huajló. ");
INSERT INTO ycn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús quemari najló: —¿Me ca'alá pan maare nacapi? amíchacajla. —Je. E nephá piño napumí chuhuá, nemá rijló: —Re maare pajluhua té'ela ca'alá pan, iyajmela ñani jíñana. ");
INSERT INTO ycn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","E Jesús huacára'ari piyuque ina'uqué yá'aco jimichi palá nojé e'iyajé. Rihuacára'a nanaquiyana yá'aco pajhua'atéchaca apojó, apojó que. ");
INSERT INTO ycn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aú nayá'o cien quéleno, ajopana yá'año cincuenta quéleno. Marí que nayá'aco i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","E Jesús ña'arí ricápojo pajluhua té'ela ca'alá pan, iyajmela ñani jíñana hua'até. E riyacá'o yenoje je'echú chojé, rimá Tupánajlo: —Palá pili'ichaca huecá marí a'ajnejí aú. Rejomi ritupa'á pan. Riyupa'atá caja najló iyajmela jíñana. Ejomi ra'á ra'apiyatéjenajlo ricá, natamáca'atacaloje piyuque ina'uquejlo ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Necá ajñaño na'ajnehuá piyuqueja namano'ocá ejená. ");
INSERT INTO ycn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Rejomi ra'apiyatéjena jahuacátaño rijlupemí yurícaro. Nahuayo'otá pan lupemí, jiña lupemí hua'até. Iyamá iphata ji'imaji nacojé ca'alá cuhuá'ala namano'otá pu'uteno raú. ");
INSERT INTO ycn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cajrú huani ne'emacá ajñaño na'ajnehuá re. Cinco mil achiñana i'imaño re. ");
INSERT INTO ycn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","E caja Jesús huacára'ari ra'apiyatéjena huitúca'aca jita chojé, nacuhuá'acaloje caesa pa'anajo pitá Betsaida ejo penaje. Rihuacára'a necá ritucumó, ejomi rihuacára'a ajopana pa'acó. ");
INSERT INTO ycn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","E Jesús i'imari riyucuno najló. Quéchami ri'ijnacá ají que yenuri ejo Tupana hua'até pura'ajó. ");
INSERT INTO ycn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","E lapí necá, jita chu i'imacaño, i'imaño caesa pe'iyó. Na'apona que Jesús i'imacá ricó yenuri i'ihuata. ");
INSERT INTO ycn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ramá naleñaca caphí huani, carená ja'apácale caphí ají que najimajo. E luhuíchipica ee ricuhuá'a nápumi chu, iphari naloco'opani a'ajnare que. Majopeja richira'acó juni jimó. Rihuata nahua'ayá ja'apácana pamineco. ");
INSERT INTO ycn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Namaca aú ra'apaca juni jimahua íqui'i nahuíyo'oca. Napechu i'imá: “Yee, ina'uqué ñacami japi huaícha.” ");
INSERT INTO ycn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Caja piyuque jita chu i'imacaño amaño ricá. Iqui'ija huani naquero'ocó raú. E rimá najló: —Caphí ila'acá ipéchuhua. Jesús nucá, iquero'oniyo —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ejéchami rihuitúca'aca jita chojé natu'uhueje. Hua'ató que carená yurica ja'apácaje. Aú napechu i'imá: “¡Meque piyuque huani rila'acá!” ");
INSERT INTO ycn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Marí que napechu i'imacá rinacu, uncale nahue'epila méqueca rila'acá a'ajnejí nacú maapami que. Ijnú napechu i'imacá rihue'epícana nacú. ");
INSERT INTO ycn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Caja ehuaja nephá pa'anajo pitá, Genesaret te'eré ejo. Re nacutá netane. ");
INSERT INTO ycn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nácho'oco jita chiyá pe'iyojó ee ina'uqué amaño Jesús. Namána'apa ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Raú necho'ó re'iyohuá natámina ña'acana nacú. Nahuáco'o necá cuhuana nacú meño'ojoca ri'ijnaqué ejo. Rehuájena quemaqueño najló meño'ojoca ricá. Aú necá i'ijnaqueño rápumi chu. ");
INSERT INTO ycn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Richira'acó pajimila cajruni nacuhuá, pajimila camu'ujini nacuhuá, riyámojo hua'ató. Ri'ijnajica ejo nato'otaque natámina le'ejepelaji ñacarelana e'iyohuá. Nemaqué Jesúsjlo, riyurícaloje nasápaca ra'arumacá ji'imá nacú penaje. Piyuque rinacu sápajeño tejmo'otáqueño raú. ");
INSERT INTO ycn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","E caja fariséona naquiyana jahuacaño Jesús nacojé. Tupana puráca'alo nacú jehuíña'atajeño i'imaño caja najhua'até. Jerusalén eyájena ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Necá amaño Jesús ja'apiyatéjena naquiyana ajñaca na'ajnehuá. Uncá nepala nayáte'ela chiyá pamineco, peñahuilánami chuna quemájica que. ");
INSERT INTO ycn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Uncachu fariséona ipala nayáte'ela chiyá pamineco cajrú, peñahuilánami chuna quemájica que, uncá najñaque na'ajnehuá. Piyuque ajopana judíona la'aqueño ñaqueja caja. ");
INSERT INTO ycn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nephácachu le'ejepelaji ñacarelana eyá nañacaré chojé, nepaque cajrú nayáte'ela chiyá pamineco. Rejomi najñaque na'ajnehuá. Cajrú apú nacaje nala'ajica nachi'inami chuna quemacá najló que. Majopeja nepájica nachiyélane chiyá, napero'ojlone chiyá, ne'eté chiyá caje macá. Ñaqué caja nepájica napero'ojlone palani sereni naquiyá la'acanami chiyá. ");
INSERT INTO ycn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","E caja fariséona, Tupana puráca'alo nacú jehuíña'atajeño, quele iphaño Jesús nacú. Nemá rijló: —¿Naje chi uncá pa'apiyatéjena la'alaño peñahuilánami chuna quemájica que? Uncá nepala nayáte'ela chiyá najñaca na'ajnehuá piyá, peñahuilánami chuna la'ajica que caja —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","E rimá najló: —Pajlácachina huani icá. Icá la'añó icó palá la'ajeño que ajopana ijlú chu. E'iyonaja uncá ñaqué calé icá. Palá huani Tupana puráca'alo ja'apátajerimi chu, Isaíasmi chu, i'imacá iyucuna júpimi que. Marí que rilana'acá papera chojé iyucuna rihuacajé: Marí que Tupana quemacá ina'uqué nacú: Mariruna ina'uqué pura'añó palá huani nunacu nanuma chiyaja calé. E'iyonaja nahuajhué nacú, uncá nahuátala nucá. ");
INSERT INTO ycn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Uncá na penaje calé nahuacono pajhua'atéchaca nahuacáca'alo ñacarelana chojé, nala'acáloje pu'ují napéchuhua nunacu penaje. Peñahuilánami chuna puráca'alomi nacuja calé nehuíña'ata huani ina'uqué. Tupana puráca'alo ricá japi que nehuíña'ataca necá rinacu, que ripuráca'alo lana'aquéjami quemacá, Isaíasmi chu lana'acare i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jesús quemari piño najló: —Icá yuriño Tupana puráca'alo a'acana inacojó, ila'acáloje peñahuilánami chuna quemacá que rilanaquiya penaje. Peñahuilánami chuna la'ajica que caja ila'acá cajrú nacaje. Majopeja ipaca ipero'ojlone chiyá, ichiyélane chiyá caje macá. ");
INSERT INTO ycn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Palá ihue'epica Tupana puráca'alo yurícana iliyó, ila'acáloje peñahuilánami chuna quemacá que penaje. ");
INSERT INTO ycn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Marí que Moisesmi chu quemacá nayani nacú i'imacá: “Iphá ichi'iná ja'apí. Eyá pura'ajero pu'uhuaré richi'iná nacú, inoje”, que rimacá najló rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Eyá icá me'etení uncá a'alaño inacojó ricá. Re nayani naquiyana maárohua, quemaño marí que nachi'inajlo: “Uncá meño'ojó hua'alá iñaté liñeru aú. Caja hua'á Tupánajlo hualiñérute”, que nemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Majopeja nemacá, uncale nephala nachi'iná ja'apí. E'iyonaja icá uncá quemalaño najló, nephaca piyá na'apihuá nachi'inajlo. ");
INSERT INTO ycn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Marí que la'acana aú uncá a'alá inacojó Tupana puráca'alo. Cajrú nacaje ila'acá ñaqueja caja ricá. Peñahuilánami chuna puráca'alomi ja'apátacana nacuja ihue'epí itucumó. Apujlo, apujlo que, i'imacá riyucuna. Yuhuanajlo hua'ató que i'imacá riyucuna. Uncá huani paala ricá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ejomi Jesús quemari ajopana ina'uquejlo, nahuacácoloje rahua'ajé penaje. Raú nahuacó rejo. E rimá najló: —Chuhua jema'á marí meque quemacánaca ricá: ");
INSERT INTO ycn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Iná numá chojé iná a'á a'ajnejí, iná ajñácaloje ricá penaje. Uncá iná la'alá pu'uhuaré raú. Eyá iná numá chiyá iná pura'ó pu'uhuaré. Raú calé iná la'á pu'uhuaré. ");
INSERT INTO ycn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Icá que'ejhuiruna, jema'á meque quemacánaca numacare nacú ijló —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ejomi Jesús ja'apáñari necá, mujlúca'ari pají chojé. Re ra'apiyatéjena quemaño rijló: —¿Meque ricá quele pimíchaca nacú huajló? ");
INSERT INTO ycn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Rimá najló: —¿Uncá caja chi ihue'epila? ¿Uncá chi ihue'epila a'ajnejí ajñacana nacojé? Iná numá chojé iná a'á a'ajnejí, iná ajñácaloje penaje. Uncá iná la'alá pu'uhuaré raú. ");
INSERT INTO ycn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Uncá a'ajnejí pachá calé iná la'á pu'uhuaré. Rihuitúca'a iná huo chojé. Caja penaje ra'apá iná e'iyayá. (Marí que rimacá aú rimá piyuque a'ajnejí nacú: Palani ricá, iná ajñácaloje penaje.) ");
INSERT INTO ycn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Rimá piño ra'apiyatéjenajlo: —Uncá iná la'alá pu'uhuaré a'ajnejí a'acana iná numá chojé aú. Eyá iná numá chiyá iná quemá nacaje nacú iná pechu nacú ri'imacá que. Pu'uhuaré péchuruna ina'uqué. Aú calé nala'á pu'uhuaré napechu queja. Ricá pachá pu'uhuaré la'ajeño ina'uqué. ");
INSERT INTO ycn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Napechu locópa'alaja ina'uqué la'acá nacaje. Pu'uhuaré péchuruna ne'emacale, ne'ejnatá napéchuhua, nala'acáloje pu'uhuaré raú penaje. Pu'uhuaré péchuruna ina'uqué i'imacale, nala'á namanaicho pajhua'atéchaca. Pu'uhuaré péchuruna ina'uqué i'imacale, nenó pecohuácaca. ");
INSERT INTO ycn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Pu'uhuaré péchuruna ina'uqué i'imacale, nata'á ajopana liyá nanane. Pu'uhuaré péchuruna ina'uqué i'imacale, nahuata ajopana le'ejé nacaje najluhua. Pu'uhuaré péchuruna ina'uqué i'imacale, nala'á chapú huani. Pu'uhuaré péchuruna ina'uqué i'imacale, uncá ina'uquélaruna necá. Pu'uhuaré péchuruna ne'emacale, chapú nahuó i'imacá nachá'atajeño cha. Pu'uhuaré péchuruna ne'emacale, nachapújra'o ajopana nacú. Pu'uhuaré péchuruna ina'uqué i'imacale, nala'á necó hue'epiño que huani. Pu'uhuaré péchuruna ne'emacale, nala'á namanaicho. ");
INSERT INTO ycn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ina'uqué pechu nacuja calé manaíchaji la'acana. Ricá aú nala'á pu'uhuaré najluhua. Pachá pu'uhuaré la'ajeño necá —que Jesús i'imacá najló riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","E caja Jesús i'ijnari reyá ají que Tiro, Sidón, quele te'eré ejo. Riphá rejo. E rimujlúca'a pají chojé, ajopana ina'uqué amaca piyá ricá. E'iyonaja uncá meño'ojó rimicho'oló naliyá. ");
INSERT INTO ycn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Apa'ahuelo jema'ayó riyucuna. Ajopana te'eré eyájeru ru'umacá. Rutu e'iyá jiñá pechu i'imari. Rucá iphayo Jesús nacú. E rujláma'o ri'imá nacojé, rumá rijló: —Pila'á nojló nacaje. Pica'á jiñá pechu nutu e'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Raú rimá rojló: —Uncá paala pan ña'acana Israelmi chu laquénami liyá, iná a'acáloje ajopana te'eré eyájenajlo, yáhuinajlo penaje. (“Yáhuina” que judíona quemájica ajopana te'eré eyájena nacú.) ");
INSERT INTO ycn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Que jo'ó Hue'emacana —que rumacá rijló— yáhuina ajñaño caja pan mujrumi te'erí e'iyajé ja'acó. ");
INSERT INTO ycn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Raú Jesús quemari rojló: —Palá huani pimíchaca nojló. Chuhua pipa'ó piñacaré ejo. Caja jiñá pechu iícharo pitu e'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ejomi rupa'ó ruñacaré ejo; iphayo; amayo rutu to'ocó mana'íja rucamané chu. Caja jiñá pechu jácho'oro ro'iyayá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús i'imari pajimila Tiro yámojo. E caja rácho'o reyá. Ra'apá piño ají que pajimila Sidón yámojo. Iyamá té'ela quele pajimila i'imacá rehuá. Rahua'ayá ra'apá, iphari caésa turenaje. Galilea na'acá rií. ");
INSERT INTO ycn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Rejé ajopana huá'año pajluhuaja me'ejhuirú. Ricaja caja i'imari manumarú. Nephá Jesús nacú. E nemá rijló, rilamá'atacaloje ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","E Jesús huá'ari ricá a'ajná ño'ojó que ina'uqué liyá. E rarúca'a riyatehuana me'ejhuirú i'ijhuí chojé. Ejomi ratupá rahui riyatehuana nacojé. Raú risapa me'ejhuirú lená nacú. ");
INSERT INTO ycn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Rejomi riyacá'o yenoje je'echú chojé. Ra'amá re'iyohuá. E rimá: —Efata. Marí que rimacá napura'acó chu: “Pijme'etó” que. ");
INSERT INTO ycn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Reyá a'ajná ño'ojó palá rema'acá, palá caja ripura'acó. ");
INSERT INTO ycn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","E Jesús quemari najló, ne'emacá piyá riyucuna ajopánajlo. Marí que rihuacára'ajica ee necá, richaje na'apátaque riyucuna ajopánajlo. ");
INSERT INTO ycn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Piyuque riyucuna jema'ajeño quemaño: —Palá huani rila'acá piyuque nacaje. Me'ejhuiruna rilamá'ata, nema'acáloje penaje. Manumaruna rilamá'ata caja, napura'acóloje penaje. ");
INSERT INTO ycn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","E apú huacajé cajrú huani ina'uqué jahuacaco piño Jesús nacojé. Júpija ne'emacá rijhua'até. Caja ehuaja na'ajné tajnáñari necá. Ñaquele Jesús huá'ari ra'apiyatéjenajlo, ne'ejnacáloje richaje penaje. E rimá najló: ");
INSERT INTO ycn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nuhue'epí mariruna ina'uqué mu'ují. Caja hueji que cálicha nujhua'até necá. Caja na'ajné tajícharo. ");
INSERT INTO ycn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nuhuacára'ajica ee napa'acó me'epejí hua'até, uncá natejmú iphálaje, nephácaloje nañacaré ejo penaje. Re ya'ajnájojena ne'iyá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","E ra'apiyatéjena quemaño rijló: —Eta, ¿mere eyá chi huajña'ajé najló a'ajnejí. Iqui'iruna huani necá. Uncá nañacaré i'imalá maárohua. ");
INSERT INTO ycn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Rimá najló: —¿Me ca'alá pan maare? —Iyamá cuhuá'ata ca'alaja —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","E rihuacára'a ajopana yá'aco te'erí e'iyajé. Ejomi rijña'á ricápojo iyamá cuhuá'ata ca'alá pan. E rimá Tupánajlo: —Palá pili'ichaca huecá marí a'ajnejí aú. Quéchami ritupa'ataca pan naquiyana. Ra'á ra'apiyatéjenajlo ricá, natamáca'atacaloje ina'uquejlo penaje. E natamáca'ata najló ricá. ");
INSERT INTO ycn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Re caja huejápaja jíñana le'epé i'imacá. Rinacu rimá caja Tupánajlo: —Palá pili'ichaca huecá marí jíñana aú. Rejomi rihuacára'a ritamáca'atacana najló ñaqueja caja. ");
INSERT INTO ycn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Piyuqueja ina'uqué ajñaño rinaquiyana namano'ocá ejé. Cuatro mil ina'uqué ca'ajná ne'emacá, ajñaño na'ajnehuá re. Rejomi nahuacata rijlupemí yurícaro. Iyamá cuhuá'ata ca'alá cuhuá'ala namano'otá pu'uteno raú. ");
INSERT INTO ycn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Najñaca na'ajnehuá ejomi Jesús quemari najló, napa'acóloje penaje. E rihuitúca'a jita chojé ra'apiyatéjena hua'até. Reyá ne'ejná ají que a'ajná ño'ojó Delmanuta te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","E caja fariséona iphaño Jesús nacú. Nahuata rijhua'até aca'ácacano. Majopeja nemacá rijló, rila'acáloje najló nacaje, Tupánaja calé hue'epícare la'acana penaje. Nahuata rila'acá najló rená que'ená penaje. ");
INSERT INTO ycn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Raú ra'amá re'iyohuá, rimá najló: —¿Naje chi ina'uqué, me'etení i'imacaño, huátaño nula'acá najló nacaje, Tupánaja calé hue'epícare la'acana? Uncá nula'alaje nacaje ijló noná que'ená penaje —que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Raú ra'apaña necá, huitúca'ari jita chojé. E nacuhuá'a caesa pa'anajo pitá. ");
INSERT INTO ycn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ra'apiyatéjena pechu capicháñari pan ña'acana najhua'ató. Re jita chu pajlúhua'ala ñani i'imari nale'ejé. ");
INSERT INTO ycn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nacuhuá'aca nacú Jesús quemari najló marí que: —Pa. Amá icó fariséona, Herodes, quele le'ejé pan amúra'atajona liyá. ");
INSERT INTO ycn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Raú ra'apiyatéjena quemaño pajlocaca: —Jema'á méqueca rimíchaca huajló, uncá pachá huajña'alacha huajhua'ató pan. ");
INSERT INTO ycn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús hue'epiri méqueca nemacá. Aú rimá najló: —¿Naje imá: “Uncá pan i'imalá huacapi” que? ¿Uncá jo'ó chi ihue'epila mecajeca ina'uqueca nucá ijhua'até? ¿Uncá chi riphala ipechu nacojé? ¿Ejo'ocaja chi ijnú ipechu rihue'epícana nacú? ");
INSERT INTO ycn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Quejluruna icá. E'iyonaja uncá amala. Que'ejhuiruna caja icá. E'iyonaja uncá jema'alá. ");
INSERT INTO ycn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Uncá chi ihue'epila meque nutupa'ataca pajluhua té'ela ca'alá pan, riphácaloje cinco mil ina'uqué nacojé penaje? ¿Me ca'alá cuhuá'ala imano'otá rijlupemí aú? que rimacá najló. Nemá rijló: —Iyamá iphata ji'imaji nacojé ca'alá cuhuá'ala huamano'otá pu'uteno. ");
INSERT INTO ycn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","E rimá piño najló: —Apú huacajé ñaqué caja nula'acá. Nutupa'atá iyamá cuhuá'ata ca'alá pan, riphácaloje cuatro mil ina'uqué nacojé penaje. ¿Me ca'alá cuhuá'ala imano'otá rijlupemí aú? Nemá rijló: —Iyamá cuhuá'ata ca'alá cuhuá'ala huamano'otá rijlupemí aú pu'uteno. ");
INSERT INTO ycn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Rimá najló: —¿Uncá huani chi ihue'epila mecajeca ina'uqueca nucá, la'arí ilé que? ");
INSERT INTO ycn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","E caja nephá Betsaida ejo. Re ajopana huá'año apú Jesús ejo. Mejlurú huani ri'imacá. Nephá Jesús nacú. E nemá rijló: —Pila'á huajló nacaje. Pa'apata marí ina'uqué liyá mejlucaji. —Je —que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","E ripatá mejlurú riyáte'ela naquiyá. Rihuá'a ricá pajimila yámojo. Re ratupá rahui rijlú chojé. Ejomi rito'otá riyáte'ela rinacu. E rimá rijló: —¿E chi pamaca nacaje chuhua? ");
INSERT INTO ycn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","E riyacá'ojla ají que, rimá rijló: —A'ahuaná chira'acó queja nomaca ina'uqué chira'acó. ");
INSERT INTO ycn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús sápari piño rijlú chojé riyáte'ela aú. Ejomi riyacá'o piño. Rejéchami palá huani ramaca piyuque nacaje. ");
INSERT INTO ycn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Raú Jesús quemari rijló: —Chuhua pipa'ó piñacaré chojé. Apú ehuá pipa'ó, pa'apániya ta pajimila e'iyohuá. Pi'imaniya caja nuyucuna pajimila erúnajlo —que rimacá rijló. —Je. ");
INSERT INTO ycn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Re cajrú pajimila Cesarea Filipo te'eré e'iyohuá. Apú eyá, apú eyá que Jesús ja'apaca ra'apiyatéjena hua'até. Nachira'acó nacú rimá ra'apiyatéjenajlo: —¿Meque ajopana ina'uqué quemacá nunacu? ");
INSERT INTO ycn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","E nemá rijló: —Ne'iyajena quemaño pinacu: “Juan Bautizar la'ajeri ricá”. Ajopana piño quemaño pinacu: “Elías ricá”. Ajopana piño quemaño pinacu: “Tupana puráca'alo ja'apátajeñomi chuna naquiyana ca'ajná ricá”. ");
INSERT INTO ycn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús quemari najló: —Icá ta ¿meque imacá nunacu? Pedro quemari rijló: —Tupana huacára'acare majó ina'uqué i'imatájeri penaje picá. ");
INSERT INTO ycn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Raú Jesús quemari najló: —Pa. I'imaniya nuyucuna ajopánajlo. ");
INSERT INTO ycn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ejomi rimá najló marí que: —Ina'uquéjloje penaje i'imacá nucá. Peñahuilana, sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, quele uncá huani huátalaño nucá. Napuráca'alo aú ajopana la'ajeño nucá chapú. Nujña'ajé cajrú chapú caje yajhué panacu. Nenoje nucá. E'iyonaja calé hueji que cala i'imajemi numacápo'ojo piño —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Marí que rimacá najló palá, nahue'epícaloje penaje. Ejomi Pedro huá'ari ricá a'ajná ño'ojó que. E raca'á ricá, rimá Jesusjlo: —Uncá na pachá calé nala'ajé picá ilé que. ");
INSERT INTO ycn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús pajno'oró ají que riyámojo, yacá'aro ajopana ra'apiyatéjena chaje. Eyá raca'á Pedro; rimá rijló: —¡Pa'apá nuliyá Jiñá Chi'ináricana! Uncá Tupana pechu que calé pipechu. Ina'uqué pechu queja pipechu. ");
INSERT INTO ycn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ejomi rahuacata ra'apiyatéjena ajopana ina'uqué hua'até rahua'ajó, Rimá najló: —Marí que rica ijló, huátaño nujhua'atéjena i'imacana. Nenoje ca'ajná icá, nujhua'atéjena i'imacale. E'iyonaja calé jácho'oniyo nujhua'atéjena i'imacana chiyá raú. Ihue'epíniya caja inacuhuá. ");
INSERT INTO ycn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ina'uqué naquiyana hue'epiño caí nanacuhuá. Uncá nahuátala ajopana la'acá necá chapú. Ñaquele uncá ne'emalá nujhua'atéjena. Marí que i'imacaño capichájeño Tupana liyá. Eyá uncá hue'epílaño caí nanacuhuá, ne'emacáloje nujhua'atéjena penaje, i'imajeño matajnaco je'echú chu. Uncá hue'epílaño caí nanacuhuá, na'apátacaloje nuyucuna ajopánajlo penaje, i'imajeño matajnaco je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Iná ña'aquela inajluhua piyuque nacaje eja'ahuá chu i'imacare, uncá na penaje calé ri'imajla inajlo, iná capichácojla Tupana liyá rilanaquiya. ");
INSERT INTO ycn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Iná capichácochu Tupana liyá, uncá meño'ojó iná a'alá nacaje marí eja'ahuá chu i'imacá, iná capichaco piyá Tupana liyá. ");
INSERT INTO ycn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Re ina'uqué, napáña'o no'opí pu'uhuaré la'ajeño, me'etení i'imacaño, e'iyá. Ñaqué caja napáña'aco nupuráca'alo ja'apí ne'iyá. Nupa'ajico je'echú chiyá majó huacajé, ñaqué caja nopáña'ajico na'apí. Ina'uquéjloje penaje i'imacá nucá. Piyuque ina'uqué huacára'ajeri penaje nuphaje je'echú chiyá majó rihuacajé. Nora'apá hua'atéjena, je'echú chu i'imacaño, quele iphájeño nujhua'até. Cajrú mejáma'atani huanacu que, huephájica majó. ");
INSERT INTO ycn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús quemari piño najló: —Ihue'epí marí: Tupana i'imajeri ina'uqué naquiyana huacára'ajeri. Ripechu aú nala'ajica cajrú nacaje rihuacára'aca que. Ri'imajica penaje ejo'ocaja inaquiyana i'imajeño marí eja'ahuá chu rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Marí que rimacá najló rihuacajé. E caja pajluhua cuhuá'ata que cala ejomi Jesús jácho'oro ipuré i'ihuátaje. Rihuá'a rijhua'até Pedro, Santiago, re'ehué Juan, queleja rihuá'a rijhua'até. Nephá rejo. Ejéchami Jesús jimá apiyácaco najimaje. ");
INSERT INTO ycn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jareni huani, mejáma'atani que huani ra'arumacá amaco rinacojé. Uncá na i'imalá marí eja'ahuá chu ipácajla a'arumacaji e'iyayá, ri'imacáloje ñaqué caja jareca penaje. ");
INSERT INTO ycn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mana'í chiyó Moisesmi chu, Elíasmi chu, quele ja'añó rejé pu'uhuacá. Napura'ó Jesús hua'até. ");
INSERT INTO ycn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","E Pedro quemari Jesúsjlo: —Huehuíña'atajeri, ¡meque palá huani huecá maare! Huala'ajé hueji quele ca'apejé maare. Pajluhuala huala'ajé pijló, apalá Moisesjlo, apalá Elíasjlo —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Marí que rimacá rijló majopeja rimacáchojonaja calé, cajrú riquero'ocole ajopana rijhuáque'ena hua'até. Uncá rihue'epila méqueca rijló quemacana. ");
INSERT INTO ycn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Marí que Pedro quemacá rijló i'imacá. Ejéchami juni suhuáca'ala itaca nachá. Re'iyohuá Tupana quemari najló. —Marí Nu'urí, íqui'ija nuhuátacare. Jema'á ra'apiyá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eyá mana'í chiyó nayacá'o rejo. Uncá na namala re. Ricaja calé Jesús namá. ");
INSERT INTO ycn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","E caja nahuitúca'a ipuré naquiyá. Napa'acó nacú Jesús quemari najló: —Pa. I'imaniya huajé amíchaje yucuna ajopánajlo. Numacápo'ojico ejomi i'imajé riyucuna ajopánajlo. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nema'á ra'apiyá, uncá ne'emalá riyucuna ajopánajlo. Napura'ó pajhua'atéchaca necámica que rimacare rinacuhuá najló nacú. Nemá pajlocaca: —Rimicha rinacuhuá: “Numacápo'ojo piño”. ¿Meque quemacana chi cari? ");
INSERT INTO ycn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","E ra'apiyatéjena quemaño rijló: —Tupana puráca'alo nacú jehuíña'atajeño quemaño Elíasmi chu nacú: “Ricá huaícha majó ritucumá, Tupana huacára'ajicare ina'uqué i'imatájeri penaje tucumá”. ¿Naje chi nemá ilé que? ");
INSERT INTO ycn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Rimá najló: —Que jo'ó ricá. Caja Elías iphari majó nutucumá i'imacá, rila'acáloje nacaje nupé penaje. E'iyonaja uncá ina'uqué huátalaño ri'imacá. Tupana puráca'alo lana'aquéjami quemacá rinacu queja nala'acá chapú ri'imacá. Eyá nucá piño, ina'uquéjloje penaje i'imacá nucá. Tupana puráca'alo lana'aquéjami quemacá que nunacu, que caja nala'ajica nucá chapú. Chapú nahuó nuchá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","E caja nephá piño ajopana ra'apiyatéjena nacú. Amaño cajrú ina'uqué najhua'até. Tupana puráca'alo nacú jehuíña'atajeño, ra'apiyatéjena, quele aca'ácaño pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nephá nanacu a'ajnáreje que. Ejéchami piyuque ina'uqué amaca Jesús huaíchaca. Pu'ují napechu la'acó raú. Aú necho'ó rijimajo rajalácaje. ");
INSERT INTO ycn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","E caja Jesús quemari ra'apiyatéjena re yurícañojlo: —¿Na jimaje aca'ácaco pajhua'atéchaca? ");
INSERT INTO ycn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Uncá chiyó na'ajipá rijló apú quemari rijló: —Huehuíña'atajeri, majó pichaje nuhuá'icha nu'urí. Re jiñá pechu re'iyá. Nacojé uncá meño'ojó ripura'aló. ");
INSERT INTO ycn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jiñá pechu noca ee ricá, ra'ó caphí huani cahuacaje te'erí e'iyajé. Cajrú quemu'ureni jeño'ocá rinuma chiyá. Camachá caja rajma'acá raí huá. Po'oló rinapona yurico raú. Caja numicha pa'apiyatéjenajlo, naca'acáloje jiñá pechu re'iyayá penaje. E'iyonaja uncá meño'ojó naca'alacha ricá re'iyayá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","E Jesús quemari ra'apiyatéjenajlo: —¡Meque uncá huani ipechu i'imalá Tupana chojé caphí! ¿Me quetana júpica nu'umajícajla ijhua'até? —que rimacá najló. E rimá piño ajopánajlo: —Ihuá'icha majó ilé yuhuají. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","E nahuá'a ricá rejo. Jiñá pechu amaca aú Jesús ricurúca'ata caphí huani ilé yuhuají ri'imacare e'iyá. Raú ra'ó cahuacaje te'erí e'iyajé. Pila, pila que ripilácaco. Hua'até que quemu'ureni jeño'ocá majó rinuma chiyá. ");
INSERT INTO ycn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","E Jesús quemari rara'apajlo; —¿Mequetánicha júpica ricá rijhua'até? —Rijyuhuácoja riqueño'ó rijló. ");
INSERT INTO ycn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pulapé jiñá pechu ca'acá ricá siyá chojé, junápeje, ricapichátacaloje ricá penaje. ¿E pila'acajla huajló nacaje? —que rimacá Jesusjlo—. Pihue'epí huamu'ují, pa'á huañaté. ");
INSERT INTO ycn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús quemari rijló: —Pipechu i'imajica ee caphí Tupana chojé, rila'acáloje nacaje pijló penaje, rila'ajé pijló nacaje. Tupana la'ajeri piyuque nacaje caphí richojé péchurunajlo. ");
INSERT INTO ycn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Raú caphí yuhuají jara'apá quemacá Jesusjlo: —Caphí nupechu Tupana chojé. Pa'á nuñaté, nupechu i'imacáloje richaje richojé caphí penaje. ");
INSERT INTO ycn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús amaca aú cajrú ina'uqué jecho'ocó majó que, raca'á jiñá pechu. Rimá jiñá péchujlo: —Pipachá manumarú ricá, me'ejhuirú caja ricá. Chuhua pácho'o re'iyayá; pipa'aniyo piño re'iyajé —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Raú jiñá pechu jahuíyo'ori. Ricurúca'ata caphí huani yuhuají. Raú rácho'o re'iyayá. Riyurí matámiru que. Piyuque ramájeño quemaño rinacu: —Caja ritaqui'ichá. ");
INSERT INTO ycn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","E'iyonaja Jesús patarí riyáte'ela naquiyá ricá. Riyá'ata ricá. Ejomi ritára'o. Palani ri'imacá reyá a'ajná ño'ojó. ");
INSERT INTO ycn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","E caja Jesús mujlúca'ari pají chojé. Necámica que ne'emacá ra'apiyatéjena hua'até. E nemá rijló: —¿Naje chi uncá meño'ojó huaca'alacha re'iyayá jiñá pechu? ");
INSERT INTO ycn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús quemari najló: —Rica'acana piyá iná i'itacó iná a'ajné liyá. Iná pura'ó caja Tupana hua'até. Marí que la'acana aú ja calé iná ca'á ilé caje jiñá pechu apú e'iyayá. ");
INSERT INTO ycn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","E caja ne'ejná reyá. Na'apá ají que Galilea te'eré e'iyohuá. Rimicho'ojneja Jesús huátaca ra'apiyatéjena hua'até ja'apácana, rehuíña'atacaloje necá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Rimá najló: —Ina'uquéjloje penaje i'imacá nucá. Na'ajé nucá ajopánajlo, nenócaloje nucá penaje. Nenoje nucá. E'iyonaja hueji que cala i'imajemi numacápo'ojo piño nopumí chuhuá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Uncá riphala napechu nacojé meque quemacánaca ricá. Uncá caja naquejá'ala riyucuna riliyá, nahuó la'acole ra'apejé. ");
INSERT INTO ycn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","E caja nephá pajimila Capernaum ejo. Re namujlúca'a pají chojé. Ejomi Jesús quemari najló: —¿Na nacú ipuri'ichó huachiri'ichaco nacú? ");
INSERT INTO ycn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Uncá na'ajipalá rijló, napáña'aco a'acuhuaná. Naca chá'atari ne'iyayó nacaje la'acana aú jimaje naca'ácaco pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","E Jesús yá'aro. Rejomi rahuacata necá rahua'ajó. Iyamá iphata ji'imaji nacojé quele ra'apiyatéjena i'imacá. E rimá najló: —Apú pechu i'imari ca'ajná rinacuhuá: “Ajopana ja'apejé nucá” que. Marí que péchuri chá'atari ajopana. Piyuque ajopana ñaté a'ajeri, ricá chá'atari ajopana. ");
INSERT INTO ycn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Eyá rihuá'a pajluhuaja yuhuají ne'iyajé. Riyá'ata ricá ricujyú nacojé. E rimá piño najló: ");
INSERT INTO ycn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Apú ca'ajná huátari marí caje yuhuají, nujhua'ateje ri'imacale. Raú caja rihuata nucá. Rihuátacachu nucá, rihuata caja Tupana, huacára'acare nucá majó —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","E caja Juan quemari Jesusjlo: —Huehuíña'atajeri, huamá apú ca'acá jiñana pechu ajopana ina'uqué e'iyayá. Pipuráca'alo aú rica'á necá ne'iyayá. Uncá huanaquiyana calé ricá. Aú calé huemá rijló: “Pila'aniya ilé que”. ");
INSERT INTO ycn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús quemari najló: —Uncá paala imacá rijló raú. Apú ca'ajná la'arí nacaje uncá meño'ojó iná la'alare nupuráca'alo aú. Ilé que i'imacá uncá pura'aló nunacu pu'uhuaré. ");
INSERT INTO ycn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Uncachu ina'uqué la'alá chapú huecá, nala'á huecá palá —que rimacá najló—. ");
INSERT INTO ycn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jema'á marí: Apala apú la'arí apú palá, no'opiyá jema'ajeri ri'imacale. Ra'á ca'ajná rijló juni, ri'iracáloje penaje. Marí que rila'acale ricá palá, Tupana a'ajeri rijló rihuemí. ");
INSERT INTO ycn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Chapú huani ri'imajica najló, amátaño no'opiyá jema'ajeño pu'uhuaré la'acana aú, namanaicho la'acana aú. Naca'aquela namátajeño junápeje, cajruni jipa jepo'oqueja nanúru'upi nacojé hua'ató, palani ri'imacajla najló chapú caje yajhué namájicare ijlunami chojé. ");
INSERT INTO ycn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ñaqué i'imacale pila'á ca'ajná pu'uhuaré nacaje pila'acare piyáte'ela aú pachá, piyurí piliyó ricá. Pimata'aquela pinaquiyó piyáte'ela, pica'acáloje ricá a'ajná ño'ojó penaje, palani ri'imacajla pijló. Uncá na aú calé pila'ájla pu'uhuaré piyáte'ela aú. Pila'aquela marí que, pi'ijnacá piyá quera'atani uncá yacálare chojé, palani ri'imacajla pijló. ");
INSERT INTO ycn_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Re uncá jamu'unana taca'alá; uncá caja quera'atani yacala. ");
INSERT INTO ycn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Pila'á ca'ajná pu'uhuaré meño'ojó pi'ijnacá pi'imá aú pachá, piyurí piliyó ricá. Pimata'aquela pinaquiyó pi'imá, pica'acáloje ricá a'ajná ño'ojó penaje, palani ri'imacajla pijló. Uncá pi'ijnalajla pu'uhuaré la'ajé raú. Pila'aquela marí que, pi'ijnacá piyá quera'atani uncá yacálare chojé, palani ri'imacajla pijló. ");
INSERT INTO ycn_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Re uncá jamu'unana taca'alá; uncá caja quera'atani yacala. ");
INSERT INTO ycn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pila'á ca'ajná pu'uhuaré nacaje pamácare pijlú aú pachá, piyurí piliyó ricá. Picahuícha'aquela pijlú majó, pica'acáloje ricá a'ajná ño'ojó que penaje, palani ri'imacajla pijló. Pila'aquela marí que, pi'ijnacá piyá quera'atani uncá yacálare chojé, palani ri'imacajla pijló. ");
INSERT INTO ycn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Re uncá jamu'unana taca'alá; uncá caja quera'atani yacala. ");
INSERT INTO ycn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Piyuque piraji nacára'atacare Tupánajlo, na'á yuquira re'iyajé pamineco. ");
INSERT INTO ycn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yuquira, palani rica'acana a'ajnejí e'iyajé. E'iyonaja rila'acochu uhui'ichí, uncá meño'ojó nala'alá ca'ajiparé rapumí chuhuá piño ricá. Yuquira i'imacá a'ajnejijlo, que caja icá ajopana ina'uquejlo, ila'acachu necá palá. Ila'á palá pecohuácaca. ");
INSERT INTO ycn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","E caja Jesús jácho'oro Capernaum eyá. Ri'ijná ají que Judea te'eré ejo. Iphari juni Jordán pa'anajo pumitá ejé. Rejé cajrú ina'uqué jahuacaco piño rinacojé. Richape piño rehuíña'ata necá. ");
INSERT INTO ycn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","E caja fariséona naquiyana iphaño rinacu. Nahuata nacaje yucuna quejá'acana riliyá, namácaloje méqueca rapiyácaca najló ricá penaje. E nemá Jesusjlo: —¿E Tupana yurica iná cupaca iná luna iná huátaca que? ");
INSERT INTO ycn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","E rimá najló: —¿Meque chi Moisesmi chu quemacá rinacu? ");
INSERT INTO ycn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nemá rijló: —Ricá quemari: Iná yurijla iná yajalo, iná a'acachu rojló papera lana'aquéjami. Richu iná quemá na pachaca iná yurica iná yajalo. Raú iná yurícajla rucá —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Rimá najló: —Ijnú huani nema'acá Tupana ja'apiyá rihuacajé. A'acuhuaná nahuata naluna yurícana. Raú riyurí najló rinacojé, nayurícaloje naluna penaje. ");
INSERT INTO ycn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tupana queño'ótaca eja'ahuá huacajé, riqueño'óta caja ina'uqué i'imacá. Achiñá, inanaru hua'até riqueño'óta ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ñaquele achiñá anúca'aro richi'iná liyá rihuá'acaco ejomi, ri'imacáloje riyajalo hua'até penaje. ");
INSERT INTO ycn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ne'emajé pajhua'atéchaca pajluhua japi necá queja. Uncá iyamá ina'uqué que calé necá huá'acajeñomi. Pajluhua japi necá queja necá pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Marí que ri'imacale, uncá paala nayurica pecohuácaca. Caja Tupana la'arí necá, ne'emacáloje pajluhua japi necá queja pajhua'atéchaca penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","E caja namujlúca'a pají chojé. Re ra'apiyatéjena quemaño rijló: —¿Meque quemacana chi quele pimíchaje nacú huajé? ");
INSERT INTO ycn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Rimá najló: —Apú yurícachu riyajalo, rihuá'acacoloje apa'ahuelo hua'até rulanaquiya penaje, la'arí rimanaicho raú. Apa'ahuelo hua'até la'acana queja caja Tupánajlo ricá. ");
INSERT INTO ycn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ñaqué caja apú lanaquiya ca'ajná riyajalo yurica ruyajná. Rula'á rumanaicho raú. Apú hua'até la'acana queja caja Tupánajlo ricá. ");
INSERT INTO ycn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ajopana huá'año Jesús ejo yuhuaná, rito'otácaloje riyáte'ela nanacojé penaje, ripura'acóloje Tupana hua'até nanacu penaje. E'iyonaja ra'apiyatéjena jahuíyo'oño najló richá, nahuá'aca piyá richaje necá. ");
INSERT INTO ycn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Marí caje aú Jesús yúcha'aro nachá. Rimá najló: —Reja yuhuaná i'ijnareja nuchaje. Jahuíyo'oniya napiyá. Yuhuaná que i'imacaño i'imaño caja Tupana hua'atéjena. Nahuacára'ajeri ricá. ");
INSERT INTO ycn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ihue'epí marí: Yuhuaná huátaño Tupana nañaté a'ajeri penaje. Uncachu ajopana ina'uqué pechu i'imalá ñaqué rinacu, uncá meño'ojó ne'emalá Tupana hua'atéjena, namujlúca'acaloje je'echú chojé penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","E caja rihuá'a yuhuaná pajluhuano queja ritu'uhuejo. Rito'otá riyáte'ela nanacu. Ripura'ó Tupana hua'até nanacu, rila'acáloje necá palá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","E caja Jesús queño'orí ja'apácaje ají que a'ajná ño'ojó. Hua'ató que apú iphaca jecho'oquelo rinacu. Ritára'o ri'irúpachi aú rijimaje. Rimá rijló: —Huehuíña'atajeri, palani picá. ¿Meque nula'acajla, nu'umacáloje matajnaco je'echú chu raú penaje? ");
INSERT INTO ycn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús quemari rijló: —¿Naje pimá nunacu: “palani” que? Ricaja calé, Tupana, palani. Eyá ina'uqué uncá palani calé necá —que rimacá rijló—. ");
INSERT INTO ycn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Caja pihue'epí méqueca Tupana puráca'alo lana'aquéjami quemacá. Uncá rihuátala iná noca ina'uqué. Uncá caja rihuátala achiñá, inanaru, quele, la'acá namanaicho pajhua'atéchaca. Uncá caja rihuátala iná ata'acá nacaje. Uncá caja rihuátala iná pajlaca ina'uqué hua'até. Uncá caja rihuátala iná pajlácaca, iná ña'acáloje nacaje apú liyá penaje. Uncá caja rihuátala iná iphaca iná ja'apihuá iná chi'inajlo. Rihuata iná iphaca na'apí palá —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Rimá rijló: —Huehuíña'atajeri, caja nujyuhuaco noma'á ra'apiyá i'imacá maáreje cha. ");
INSERT INTO ycn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Raú Jesús yacá'aro richaje. Iqui'ija rihuátaca ricá. Rimá rijló: —Re pajluhuaja ñani nacaje yuriro pitucumá, pila'acáloje penaje. Pipa'ó piño piñacaré ejo. Eco pa'atá ajopánajlo pinane piyuqueja liñeru aú. Quéchami pa'ajica piyuqueja piliñérute camu'ují la'acáñojlo. Marí que la'acana aú nacaje palá nojé i'imajé pijló je'echú chu. Quéchami pi'ijnajica piño majó, pi'ijnacáloje nujhua'até penaje. Pi'ijnajica ee nujhua'até, apala nenoje picá a'ahuaná apiyácacanami nacú acúhua'ataqueja. E'iyonaja pi'ijná nujhua'até —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Marí que rimacá rijló aú camu'ují huani ripechu la'acó. Uncá ra'alá rinacojó ripuráca'alo, cajrú le'ejepelari ri'imacale. Aú caja ripa'ó. ");
INSERT INTO ycn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús yacá'aro riyámojo ra'apiyatéjena chaje. Rimá najló: —Puhuichani huani cajrú le'ejepelárunajlo nachó yurícana Tupánajlo, ri'imacáloje Nahuacára'ajeri penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Raú cajrú ra'apiyatéjena i'ijnataca napéchuhua rimacare nacú. Jesús quemari piño najló: —Nujhuáque'ena, caphí ne'iyajena pechu nale'ejé le'ejepelaji chojé. Puhuichani najló nachó yurícana Tupánajlo, ri'imacáloje Nahuacára'ajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Puhuichani caméllojlo luhuirí aphú chiyá ja'apácana. Richaje puhuichaca cajrú le'ejepelárunajlo nachó yurícana Tupánajlo, ri'imacáloje Nahuacára'ajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Marí que rimacá aú ra'apiyatéjena quemaño pajlocaca: —¿Mecajena ca'ajná Tupana i'imatájeri rijluhua capichácajo liyá? ");
INSERT INTO ycn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Raú Jesús yacá'aro nachaje, rimá najló: —Uncá meño'ojó ina'uqué i'imatala necó capichácajo liyá. Tupánaja calé i'imatari ina'uqué capichácajo liyá. Ricaja calé hue'epiri piyuqueja nacaje la'acana. ");
INSERT INTO ycn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","E Pedro quemari Jesusjlo: —Huahuacára'ajeri, huecá yuriño piyuqueja huanane, hue'ejnacáloje pijhua'até penaje. ");
INSERT INTO ycn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús quemari najló: —Jema'á marí: Nala'acáloje nuhuacára'aca que penaje, ina'uqué naquiyana i'ijnañáaño nañacaré ca'ajná, nejena ca'ajná, nachi'iná ca'ajná, nate'eré ca'ajná. Ne'ejnañáa ca'ajná nayani caja ñapácaño. Marí caje nayurí nayámajo nojló, na'apátacaloje Tupana puráca'alo ajopánajlo penaje. ");
INSERT INTO ycn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Palá huani ri'imajica marí que la'acáñojlo. Ñó'ope Tupana a'ajica nañaté nacaje la'acana aú marí eja'ahuá chu. Nañacaré, nejena, nate'eré caje macá chaje palaca nacaje i'imajeri najló. Ajopana ca'ajná la'ajeño necá chapú nupuráca'alo jimaje. Caja penaje ne'emajica je'echú chu Tupana hua'até matajnaco. ");
INSERT INTO ycn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","’Re cajrú ina'uqué naquiyana, me'etení i'imacaño, napechu i'imá nanacuhuá: “Ajopana chaje Tupana la'ajeri huecá palá”. Tupana la'ajeri necá ajopana ja'apejé palá. Re caja cajrú ina'uqué naquiyana, me'etení i'imacaño, napechu i'imá nanacuhuá: “Ajopana ja'apejé Tupana la'ajeri huecá palá”. Marí cajena Tupana la'ajeri ajopana chaje palá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","E caja Jesús ja'apari ra'apiyatéjena hua'até ají que yenojo, Jerusalén ejo. Jesús ja'apari natucumá. Ra'apiyatéjena i'ijnataño cajrú napéchuhua rimacare nacú. Ajopana, nápumi chu ja'apácaño, i'imaño quero'ocajo nacú. Eyá a'ajná ño'ojó que na'apaca. E Jesús huá'ari iyamá iphata ji'imaji nacojé quele ra'apiyatéjena a'ajná ño'ojó pani ajopana liyá, rimacáloje najló méqueca ajopana la'ajica ricá chapú penaje. ");
INSERT INTO ycn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rimá najló: —Jema'á, ina'uquéjloje penaje i'imacá nucá. Chuhua hue'ejichaca yenojo Jerusalén ejo. Re sacerdótena huacára'ajeño; re caja Tupana puráca'alo nacú jehuíña'atajeño. Najló ajopana a'ajeño nucá. Nemaje nunacu, nenócaloje nucá penaje. Ejomi na'ajé nucá ajopánajlo. Uncá judíona calé necá. ");
INSERT INTO ycn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Necá la'ajeño namácaja nucá. Naña'ataje nucá; natupaje nahui nunacojé; nenoje nucá. E'iyonaja hueji que cala i'imajemi numacápo'ojo piño nopumí chuhuá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ra'apiyatéjena naquiyana i'imaño Santiago, Juan, quele. Nara'apá ií i'imari Zebedeo. E ne'ejná Jesús ahua'ajé, nemá rijló: —Huehuíña'atajeri, huahuata pila'acá huajló nacaje. ");
INSERT INTO ycn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Rimá najló: —¿Na ihuata nula'acá ijló? ");
INSERT INTO ycn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nemá rijló: —Pi'imajica ee piyuqueja ina'uqué huacára'ajeri huacajé, piyurí huecá pahua'á yá'ajeño penaje. Pajluhuaja yá'ajero ca'añá chojó pitá. Apú yá'ajero pajrú chojó pitá. ");
INSERT INTO ycn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús quemari najló: —Uncá ihue'epila naca iquejá'aca nuliyá. Chapú huani nala'ajica nucá. ¿E ijña'acajla chapú caje yajhué panacu, nala'aquela icá chapú ñaqué caja? ");
INSERT INTO ycn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nemá rijló: —A'a, huajña'acárejla panacu ricá. Jesús quemari najló: —Quehuaca jo'ó. Nala'ajé icá chapú, nala'ajica nucá que caja. Ijña'ajica chapú caje yajhué panacu, nujña'ajica ricá panacu que caja. ");
INSERT INTO ycn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","E'iyonaja uncá nucá calé a'ajeri ina'uqué, nayá'acoloje nuca'añare chojó pitá, nupajrure chojó pitá penaje. Tupana a'ajeri necá. Ricaja calé hue'epiri mecajenaca yá'ajeño nohua'á marí que —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ajopana, iyamá té'ela quele ra'apiyatéjena jema'añó méqueca napura'acó rijhua'até. Aú nayúcha'o Santiago, Juan, quele cha. ");
INSERT INTO ycn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","E Jesús quemari najló, nahuacácoloje rahua'ajé penaje. Rimá najló: —Caja ihue'epí ajopana te'eré eyájena huacára'ajeño nacojé. Najhua'atéjena minaná queja necá najhua'até. Caphí huani nachaje huacára'ajeño huacára'aca najhua'atéjena. ");
INSERT INTO ycn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Eyá ijló uncá ñaqué calé ri'imajica. Ihuata ca'ajná inaquiyana chaje i'imacana. La'arí ricó inaquiyana hua'até sápajeri que, ricá i'imari ajopana chaje. ");
INSERT INTO ycn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ihuata ca'ajná inaquiyana chá'atacana. Pamineco i'imá piyuque ina'uqué ñaté a'ajeño. ");
INSERT INTO ycn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ina'uquéjloje penaje i'imacá nucá. Uncá nuphala majó ina'uqué la'acáloje nojló nacaje penaje. Nucá i'ijnari majó, nula'acáloje ina'uquejlo nacaje penaje. No'ojé nocó cajrú ina'uqué chaya penaje, ne'emacóloje capichácajo liyá raú penaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iñe'epú chuhuá na'apá pajimila Jericó e'iyohuá. Jesús ja'apiyatéjena, cajrú ina'uqué hua'até ja'apaño Jesús hua'até. Nácho'oco pajimila e'iyá ee nephata apú ina'uqué. Mejlurú huani ri'imacá. Re riyá'o iñe'epú turená liñeru quejá'acana nacú ajopana ina'uqué liyá. Rií i'imari Bartimeo. Timeo i'irí ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Re nephata ricá, nemá rijló: —Jesús, Nazaret eyaje, ja'apácare chuhuá marí iñe'epú. Eja rahuíyo'o, rimá: —Jesús, ina'uqué i'imatájeri penaje picá. Pihue'epí numu'ují —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Raú cha'apá ina'uqué aca'añó ricá. Nemá rijló: —¡Pimanúma'o ta! Aú richaje huani rahuíyo'oca. Rimá piño: —Jesús, ina'uqué i'imatájeri penaje picá. Pihue'epí numu'ují. ");
INSERT INTO ycn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Raú Jesús tajnaro iñe'epú chojé. Rimá ajopánajlo: —Majó ihuá'icha ricá. Aú ne'ejná Bartimeo huá'aje, nemá rijló: —Caphí pila'acá pipéchuhua. Pácho'o; rihuá'icha pimaná. —Je —que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Raú rica'á ripayétane rinaquiyó. Quiñaja rácho'oco, i'ijnari Jesús jimajo. ");
INSERT INTO ycn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","E Jesús quemari rijló: —¿Meque pihuátaca nula'acá picá? —Huehuíña'atajeri, pa'apata nuliyá mejlucaji, nomachi —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús quemari rijló: —Chuhua pi'ijná. Caja pi'imichó mejlucaji liyá, pipechu i'imacale caphí nochojé. Ejéchami mejlucaji ja'apaca riliyá. E ri'ijná Jesús hua'até rápumi chu. ");
INSERT INTO ycn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","E caja ehuaja nephá Jerusalén nacojé. Pamineco na'apá pajimila Betfagé ahua'ayá. Ejomi na'apá piño pajimila Betania ahua'ayá. Iphaño yenuri ja'apejé. Yenuri ií Olivos. Rejé nephá. Ejéchami Jesús huacára'aca iyamá ra'apiyatéjena naquiyana pajimila ejo. Rimá najló: ");
INSERT INTO ycn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—I'ijná ají ño'ojó pajimila ejo huatucumajo. Iphájicaja rejo ee, amaje cahuarú caje i'irí a'aqueja mucuri. Uncá jo'ó na ja'apala rinacu. Eco icaráca'a ricá, ihuá'ichachi ricá majó. ");
INSERT INTO ycn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nemájica ee ijló: “¿Naje chi icaráca'a ricá?” imaje najló: “Huahuacára'ajeri huátari ricá mequetánaja penaje. Quéchami huapa'atájica piño ricá rimucú chojé”, que imájica najló. —Je —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","E caja ne'ejná ají que a'ajná ño'ojó pajimila ejo. Rimacá najló que nephátaca cahuarú caje a'aqueja mucuri. Re ritára'o rinumaná ahua'á, iñe'epú punumacana. Nephá rejé. E nacaráca'a ricá. ");
INSERT INTO ycn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Rahua'á lapa'acaño quemaño najló: —¿Meque ila'acá ricá quele? ¿Naje ta icaráca'a ricá? ");
INSERT INTO ycn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","E nemá najló Jesús quemacá najló i'imacá que. Aú nayurí najló ricá. ");
INSERT INTO ycn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","E nahuá'a ricá Jesús ejo. Nephá Jesús nacú. E nayúma'a na'arumacá naquiyana cahuarú huajlé chojé. E Jesús yá'aro re'iyajé. Quéchami ra'apaca cahuarú caje nacú ají que iñe'epú chuhuá. ");
INSERT INTO ycn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Cajrú ina'uqué i'imacá re. Necá caja ayúma'año na'arumacá naquiyana ra'apaca ehuá. Ajopana piño mata'añó huejirí huirulá paná caje, naca'acáloje ricá iñe'epú chojé ripé penaje, palá ramácoloje penaje. ");
INSERT INTO ycn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ritucumá ja'apácaño, rápumi chu ja'apácaño, quele jahuíyo'oño. Nala'á riyájlepana. Marí que nemacá jahuíyo'oqueja Jesús nacú: —Palani huani ricá Tupana huacára'acare majó. ");
INSERT INTO ycn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Palá huani rihuacára'ajica huecá. Davidmi chu huacára'ajica hua'ajútayami chuna i'imacá que caja rihuacára'ajica huecá. Palani Tupana, je'echú churí —que nahuíyo'oca. ");
INSERT INTO ycn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Marí que Jesús iphaca Jerusalén e'iyajé. E rimujlúca'a Tupana ñacaré chojé. Ripalamata piyuque nacaje re i'imacare richu. Caja najúhua'a. Aú ri'ijná ají que Betania ejo ra'apiyatéjena hua'até. ");
INSERT INTO ycn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Muní que nácho'oco Betania eyá, napa'acóloje Jerusalén ejo penaje. Iñe'epú chu quehuí Jesusjlo me'epejí i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A'ajnare que ramá paijí higuera tára'aco. E ri'ijná rejo richa culaje ripaná e'iyohuá. Riphá ra'apejé, amari mecharú ri'imacá. Ripanaja calé i'imari rinacu. Uncá jo'ó riphala rarúca'aca jená chojé. ");
INSERT INTO ycn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","E rimá a'ahuanajlo: —Maáreya huatucumá uncá na calé ajñájeri picha i'imajica. Ra'apiyatéjena jema'añó méqueca rimacá a'ahuanajlo. ");
INSERT INTO ycn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","E nephá piño Jerusalén ejo. E rimujlúca'a piño Tupana ñacaré chojé. E riqueño'ó richiyájena nacú ja'apácana. Nacaje a'ajeño, nacaje huarúhua'ajeño, quele nacú ra'apá richiyá piyuque. Ripajno'otá liñeru apiyácajeño mesané. Túcu'uchina piracana a'ajeño ñáca'aru ripajno'otá caja. ");
INSERT INTO ycn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Rejomi uncá riyurila najña'acá najhua'ató nacaje Tupana ñacaré chojé. ");
INSERT INTO ycn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","E rehuíña'ata necá, rimá najló: —Tupana puráca'alo lana'aquéjami quemari marí que: “Re nuñacaré piyuqueja ina'uquéjloje penaje, napura'acóloje nujhua'até richu penaje”, que rimacá. E'iyonaja icá apichátaño ricá. Icá a'añó ajopánajlo nacaje richu. Richuhuaja ata'á necá. Ata'ajeño ñacaré que ijló ricá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","E caja sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, quele jema'añó ra'apaca nanacu yucuna. Aú ne'ejnatá napéchuhua, nahue'epícaloje meque la'ajémica nenócajla ricá. Nahuata rinócana. E'iyonaja naquero'ó ajopana piyá. Caja piyuqueja ajopana ina'uqué pechu i'imari pu'ují rinacu, rehuíña'atacale necá palá huani. ");
INSERT INTO ycn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","E caja najúhua'a. Raú Jesús jácho'oro piño pajimila eyá. ");
INSERT INTO ycn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Muní que lapiyami na'apá piño paijí higuera ahua'ayá. Amaño caja rila'acó cuhuichila que, piyuque ra'apare hua'ató. ");
INSERT INTO ycn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ricá ahua'ayá na'apá. Ejéchami riphaca Pedro pechu nacojé lalemi que Jesús yerúca'aca richaje. Aú rimá Jesusjlo: —Huehuíña'atajeri, pamá higuera paca'acare. Caja rila'ó cuhuichila. ");
INSERT INTO ycn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús quemari najló: —Tupana la'arí nacaje caphí péchuruna richojejlo. ");
INSERT INTO ycn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Jema'á marí: Iná quemacá ee cari ipurejlo: “Pácho'o. Pica'á picó juni jalomi acojé”. Caja queja ri'imajica la'acana caphí Tupana chojé péchurunajlo. Uncachu iná pechu i'imalá caphí Tupana chojé iná quemá ca'ajná: “Uncá ri'imalaje ñaqué”. Uncá caja rila'acana i'imalaje raú. ");
INSERT INTO ycn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ñaquele numá ijló: Iquejá'ajica ee nacaje Tupana liyá, ipechu i'imajé caphí richojé. Raú ra'ajé ijló ricá. ");
INSERT INTO ycn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ipura'acó aú Tupana hua'até, amó ina'uqué chaje chapú nala'acare icá liyá. Raú ñaqué caja Jara'apá, je'echú chu i'imacare, amájero ichaje ila'acare pu'uhuaré liyá. ");
INSERT INTO ycn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Uncaja que amó apú chaje chapú rila'acare icá liyá, uncá caja Jara'apá, je'echú chu i'imacare, amalo ichaje pu'uhuaré ila'acare liyá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","E caja nephá piño Jerusalén ejo. E Jesús mujlúca'ari piño Tupana ñacaré chojé. Ejéchami sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, peñahuilana, quele jahuacaco Jesús nacojé. ");
INSERT INTO ycn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","E nemá rijló: —¿Na puráca'alo aú chi pila'á nacaje? ¿Na huacára'ari picá rila'ajeri penaje? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús quemari najló: —Ñaqué caja nuquejá'ajica iliyá nacaje yucuna. Ja'ajipajica ee nojló, numaje ijló naca nuhuacára'ajeri. ");
INSERT INTO ycn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Rimá najló: —¿Na puráca'alo aú chi Juanmi chu la'aqueri bautizar ina'uqué, Tupana puráca'alo aú ca'ajná, ina'uqué puráca'alo aú ca'ajná? Ja'ajipá nojló chuhuaca —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Raú napura'ó pajhua'atéchaca necámica que. Nemá pajlocaca: —Huemáquela rijló: “Tupana puráca'alo aú Juan la'aqueri bautizar ina'uqué” que, rimajla huajló: “¿Naje chi uncá jema'alá ra'apiyá?” ");
INSERT INTO ycn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Eyá huemáquela rijló: “Ina'uqué puráca'alo aú” que, mariruna ina'uqué yúcha'ajeñojla huachá raú —que napura'acó pajhua'atéchaca. Raú naquero'ó ilé que quemacana piyá rijló, ajopana pechu i'imacale Juanmi chu nacú: “Tupana puráca'alo ja'apátajeri ri'imacá.” ");
INSERT INTO ycn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aú calé nemá Jesusjlo: —Capí, uncá huahue'epila na puráca'alo aú ca rila'aqué bautizar ina'uqué. Jesús quemari najló: —Ñaqué uncá caja numalaje ijló, na puráca'alo aú ca nula'acá nacaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Marí que Jesús i'imacá yucu najló: —Pajluhuaja ina'uqué ejáchiyari cajmú caje ri'icacapere e'iyohuá. Rejomi rili'ichá corral tujlá que pajimájechaca rejáchiyaje nacojé. Rili'ichá caja ralá apáca'aruna. Quéchami rili'ichaca rica'apé yenoje, richiyá rihua'aphena amácaloje ricá palá penaje. E caja riyuricha rijhua'até sápajeño naquiyánajlo ri'icacapere, namácaloje rijló ricá penaje. Ri'ijichaca ya'ajnajo yámona rimicha najló: “Chuhua nu'ujichaca. Eco amá ricá palá. Cajmú naquiyana no'ojé ijló rihuemí, amaca nojló ricá huemí”, que rimíchaca najló. E ri'ijichá ya'ajnaje. Júpija ri'imichaca ya'ajnó. ");
INSERT INTO ycn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","E caja ehuaja richa ña'acana iphíchari rená chojé. Aú paminá huacári'ichari rijhua'até sápajeri i'ijnacá rimena amájeño chaje, rijña'acáloje richa rijló penaje. ");
INSERT INTO ycn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Aú ri'ijichá a'ajná ño'ojó rimena amájeño chaje. Iphíchari nanacu. Eta rimena amájeño pachíyaño ricá; naña'achiya ricá. Ejomi nahuacári'icha ripa'acó majopeja. ");
INSERT INTO ycn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Rejomi paminá huacári'ichari piño apú rijhua'até sápajeri rejo. Ñaqué caja nali'ichaca ricá chapú huani. Naqui'ichá jipa richá cajrú. Nenocha pehuíla'aruya ricá jipa aú. Cajrú raphumi yuríchaco rihuíla'aru nacú raú. Ripa'ó caja majopeja. ");
INSERT INTO ycn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","E rihuacári'icha piño apú. Ricá nenocha. Rejomi rihuacári'icha ajopana, ajopana que. Ñaqué caja nali'ichaca chapú ajopana rihuacári'ichajena rejo. Ne'iyajena naña'achiya, ne'iyajena nenocha. ");
INSERT INTO ycn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Eyá ejo'ocaja pajluhuaja yurícharo. Ri'irí huani ri'imichaca. Iqui'ija rihuátacare ri'imichaca. Caja penaje rihuacári'icha ricá nachaje. Ripechu i'imichá nanacu: “Nu'urí cari, ¿nephaje chi ra'apí?” ");
INSERT INTO ycn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","E'iyonaja nephicha na'apihuá rijló. Rimena amájeño amíchaca aú ricá huaíchaca nemá pajlocaca: —Ilé ta ri'irijlo paminá yuréjeri rimena, ri'imacáloje rijluhua penaje. I'ijná huenóchachi ricá, rimenami yurícoloje huajló penaje —que nemacá pajlocaca. ");
INSERT INTO ycn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","E caja riphicha nanacu. Eta napachiya ricá; nenocha ricá. Rimena yámojo naqui'ichá ritami. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Marí que Jesús i'imacá yucu najló. Ejomi rimá najló: —Marí que paminá la'ajica rimena amájeño: Riphaje nacapichátaje. Ejomi riyureje rimena ajopánajlo ramájeño penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jesús quemari piño najló: —Caja ihue'epí méqueca Tupana puráca'alo lana'aquéjami quemacá. Marí que rimacá nunacu: Pajluhuaja ina'uqué i'imajeri. Ne'iyajena quemájeño rinacu: “Uncá ina'uquélari ricá” que. E'iyonaja ricá i'imajeri ajopana chaje. ");
INSERT INTO ycn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Marí caje penaje Tupana a'ajeri ricá. Palá huani nacaje Tupana la'acare, que Tupana puráca'alo lana'aquéjami quemacá. ");
INSERT INTO ycn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Uncá paala Jesús puráca'alo i'imacá ne'iyajénajlo. Yucu ri'imá najló. E'iyonaja nahue'epí nanacu rimacá raú meque la'ajéñoca necá. Aú nahuata ripatacana, nahuajácaloje ricá penaje. E'iyonaja naquero'ó ajopana ina'uqué piyá. Aú na'apaña ricá. Ne'ejná ají que a'ajná ño'ojó. ");
INSERT INTO ycn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","E caja ajopana i'ijnaño Jesús hua'até pura'ajó, namácaloje méqueca rimacá ne'emacana nacú. Nahuata rinacu quemacana: “Pu'uhuaré rimíchaca huajló” que. ");
INSERT INTO ycn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Fariséona nanaquiyana, Herodes hua'atéjena naquiyana, quele puráca'alo aú ne'ejná Jesús chaje. E nemá rijló: —Huehuíña'atajeri, huahue'epí quehuácaje pipuráca'alo. Nacaje Tupana huátacare iná la'acá caje nacú pehuíña'ata ina'uqué. Quehuácaje nacaje pehuíña'atacare nacú. Re huahuacára'ajeño naquiyana, uncá paala najló pipuráca'alo. E'iyonaja uncá pa'alá necá pinacojó. Pajimato pehuíña'ataca ina'uqué Tupana huátaca que la'acana nacú. Chuhua pimá huajló méqueca pipechu marí nacú: Naquejá'a hualiyá liñeru, na'acáloje ricá hue'emacana Césarjlo penaje. Romano naquiyana ricá. ¿E palani hua'acajla najló liñeru ca'ajná, uncá ca'ajná? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús hue'epiri naquejá'aca riyucuna riliyá, nahuátacale rimacá apojó ne'emacana liyá, nemacáloje rinacu: “Pu'uhuaré rimacá” que penaje. Aú rimá najló: —¿Naje ihuata numacá ijló nacaje nacú, imacáloje nunacu: “Pu'uhuaré rimíchaca huajló” que penaje? Iya'atá nojló liñeru, iná a'acare iná i'imacánajlo, nomachi ricá. ");
INSERT INTO ycn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Je. E na'á rijló pajluhuata. Jesús yacá'aro richaje. E rimá najló: —¿Na jenami chi cari liñeru nacú? ¿Na ií lana'aquéjami rinacu? Nemá rijló: —Hue'emacana Cesar jenami quele rinacu. Rií caja quele lana'aquéjami rinacu —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aú Jesús quemari najló: —A'á i'imacana Césarjlo quele liñeru rihuátacare. Ila'á caja nacaje Tupánajlo rihuátacare caje. Marí que rimacá aú najló napechu i'imá: “¡Meque capechú huani rimíchaca huajló.” ");
INSERT INTO ycn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ajopana piño i'ijnaño Jesús amaje. Saducéona naquiyana ne'emacá. Necá quemaqueño caja taca'acaño nacú: “Uncá namacápo'olajo” que. Necá penájena i'ijnaño Jesús amaje. Nemá rijló: ");
INSERT INTO ycn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Huehuíña'atajeri, marí que Moisesmi chu puráca'alomi lana'aquéjami quemacá: “Apú ca'ajná taca'añari riyajalo mayaniqueru. Palani re'ehuemi ra'apiyajé huá'acacojla riyajálomi hua'até, re'ehuemi chu yanimínami yurícoloje rapumí chojé raú penaje”, que ripuráca'alomi lana'aquéjami quemacá. ");
INSERT INTO ycn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ñaqué ricá: Maare pajluhuaja ina'uqué i'imari huajhua'até. Iyamá cuhuá'ata quele ne'emacá rejena hua'até. Achiñana huánija ne'emacá. Pe'ejí ri'imacá huá'acaro. Ritaca'añá rucá mayaniqueru. ");
INSERT INTO ycn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Rejomi ra'apiyajé i'imacá huá'acaro piño riyajálomi hua'até. Ñaqué caja ricapichaco ruliyá mayaniqueru caja. Raú re'ehué pe'iyorí huá'acaro piño rujhua'ateja caja. Ñaqué caja ricapichaco ruliyá mayaniqueru caja. ");
INSERT INTO ycn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ají que iyamá cuhuá'ata quele necá huá'acaco rujhua'até i'imacá. Necá piyuque capichaño ruliyá mayaniquéruja. Caja penaje nayajálomi capichayo nápumi chu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eta, Tupana macápo'otajica ina'uqué caja taca'acaño huacajé ¿na yajalo chi ruyuríjico rejéchami? Iyamá cuhuá'ata quele ina'uqué yajálomi ru'umacá —que nemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús quemari najló: —Uncá ihue'epila rinacojé, uncale ihue'epila meque Tupana puráca'alo lana'aquéjami quemacá. Uncá caja ihue'epila nacaje Tupana hue'epícare la'acana nacojé. ");
INSERT INTO ycn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Caja taca'acaño macápo'ojico ejomi uncá pajhua'atéchaca huá'acajeñomi calé ne'emajica je'echú chu. Uncá caja nahuá'acalajo piño pajhua'atéchaca. Tupana hua'atéjena, je'echú chu i'imacaño, que caja ne'emajica rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Re riyucuna, caja taca'acaño macápo'oco yucuna, Tupana puráca'alo lana'aquéjami e'iyá. Icá caja hue'epiño riyucuna nacojé. Ricá quemari méqueca Tupana pura'acó jíma'alami cára'aco e'iyayá Moisesmi chu hua'até i'imacá. Rimá rijló marí que: “Abraham, Isaac, Jacob, quele pechu i'imari caphí nochojé”. ");
INSERT INTO ycn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","’Uncá caja taca'acaño pechu i'imalajla caphí Tupana chojé. Eyá necá cajmuruna pechu i'imari richojé caphí. Cajmuruna ne'emacale je'echú chu rimá Abrahami chu, Isaacmi chu, Jacobmi chu, quele nacú: “Caphí napechu nochojé”. Uncá ihue'epila naca quehuaca —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","E caja pajluhuaja Tupana puráca'alo nacú jehuíña'atajeri i'ijnari Jesús hua'até pura'ajó. Rema'á méqueca napura'acó pajhua'atéchaca i'imacá. Rihue'epí Jesús quemacá palá najló. Aú ri'ijná rahua'ajé, riquejá'acaloje riliyá nacaje yucuna penaje. E rimá rijló: —Tupana huacára'ari iná la'acá cajrú nacaje. ¿Na rihuata huala'acá i'imari apú nacaje chaje huani? ");
INSERT INTO ycn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús quemari rijló: —Marí que Tupana puráca'alo lana'aquéjami quemacá: “Huahuacára'ajeri Tupana. Ricaja calé i'imari Iná Chi'ináricana. ");
INSERT INTO ycn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pihuata íqui'ija Pihuacára'ajeri, Tupana. Pihuajhué ricá. Pi'ijnatá caja pipéchuhua rinacu. Pehuíña'o caja nacaje nacú, ri'imacáloje palá rinacu penaje. Pila'á caja piyuqueja nacaje, ri'imacáloje palá rinacu penaje. Marí que pila'acá, pihuátacale ricá íqui'ija”. Apú nacaje rihuacára'acare iná la'acá chaje rihuátaca iná la'acá marí que. ");
INSERT INTO ycn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Apa'amá rimacare nacú, ra'apejé quemachi ricá, quemari marí que: “Ihuata íqui'ija piyuqueja ina'uqué pihuátaca picó que caja”. Richaje huani Tupana huátaca iná la'acá marí que —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tupana puráca'alo nacú jehuíña'atajeri quemari Jesusjlo: —Huehuíña'atajeri, quehuaca jo'ó ilé pimíchaca. Palá pimíchaca huajló. Ricaja calé, Tupana, Iná Huacára'ajeri, Iná Chi'ináricana caja ricá. ");
INSERT INTO ycn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Palani iná huátaca ricá íqui'ija. Palani caja iná huejhué ricá. Palani caja iná jehuíña'o nacaje nacú, ri'imacáloje palani rijló penaje. Palani caja iná i'ijnataca iná péchuhua rinacu. Palani caja iná la'acá nacaje, ri'imacáloje palani rijló penaje. Marí que iná la'acá, iná huátacale ricá íqui'ija. Eyá apú, palani caja iná huátaca íqui'ija piyuque ina'uqué iná icó que caja. Apa'amá ripuráca'alo chaje huani iná a'á iná nacojó ricá. Pirajina nacára'atacare Tupánajlo chaje palaca ricá. Nacaje iná a'acare majopeja Tupánajlo chaje palaca ricá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús amari capechú rimacá rijló. Aú rimá rijló: —Yehuicha pipechu iphaca, Tupana i'imacáloje pihuacára'ajeri penaje. Reyá a'ajná ño'ojó uncá ajopana quejá'alaño nacaje yucuna riliyá, nahuó la'acole ra'apejé nacaje yucuna quejá'acana riliyá. ");
INSERT INTO ycn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","E caja Jesús jehuíña'atari necá Tupana ñacaré chu. Rimá najló: —Tupana huacára'ari pajluhuaja majó ina'uqué i'imatájeri penaje. ¿Naje chi Tupana puráca'alo nacú jehuíña'atajeño quemaño rinacu: “Davidmi chu laquénami naquiyana ricá” que? ");
INSERT INTO ycn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tupana Pechu quemacá que, Davidmi chu lana'acá riyucuna papera chojé marí que i'imacá: Ina'uqué Huacára'ajeri huani Tupana. Ricá quemari Nuhuacára'ajerijlo: “Palá huani nupechu pinacu. Pi'imá Nahuacára'ajeri nujhua'até. Maare pi'imajé nohua'á, nuchá'atajica chapú pinacu péchuruna ejená”, que rimacá. ");
INSERT INTO ycn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jesús quemari piño najló: —Davidmi chu quemari: “Nuhuacára'ajeri ricá”, ilé Tupana huacára'acare majó ina'uqué i'imatájeri penaje nacú. Ñaquele uncá rilaquénami naquiyana huani calé ricá nemacare nacú —que rimacá najló. Iqui'iruna ina'uqué jema'añó Jesús puráca'alo. Palá napechu i'imacá ripuráca'alo nacú. ");
INSERT INTO ycn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús jehuíña'atari necá. E rimá najló marí que: —Ihue'epí mecajenaca huani Tupana puráca'alo nacú jehuíña'atajeño. Huaphereni na'arumacá chu nahuata chira'acajo. Nahuata caja ina'uqué ajalácaca necá palá, nachira'acochu ne'iyohuá. Le'ejepelaji ñacarelana e'iyohuá na'apaca ee, ñaqué caja nahuátaca najalácaca necá palá. ");
INSERT INTO ycn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nahuata caja ajopana tucumá yá'acano nahuacáca'alo ñacarelana chu. Ñaqué caja nale'ejé fiesta huacajé. ");
INSERT INTO ycn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Napajlaca najhua'até aú nata'á inaana ihuacajílomina liyá nañacaré. Eyá majopeja napura'acó júpija Tupana hua'até, palá ina'uqué pechu i'imacáloje nanacu raú penaje. Marí que nala'acare chona, ajopana chaje huani Tupana huajájica necá. ");
INSERT INTO ycn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","E caja Jesús yá'aro Tupana ñacaré chu. Liñeru a'acuná ahua'á riyá'o. Ramá ina'uqué ca'acá liñeru richojé. Cajrú liñéruteruna i'imacaño ca'añó cajrú liñeru richojé. ");
INSERT INTO ycn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Eyá ramá caja pajluhuájaru ihuacajílomi. Camu'ují la'acayo ru'umacá. Ruca'á iyamata ñani liñeru richojé. Huejápaja huani rahuacaco. ");
INSERT INTO ycn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","E Jesús huá'ari ra'apiyatéjenajlo, ne'ejnacáloje rahua'ajé penaje. Rimá najló: —Jema'á marí: Ilerú inanaru, ihuacajílomi rucá. Camu'ují la'acayo caja rucá. Ilé liñeru, huejápaja ruqui'ichaje richojé aú ruchá'achiya ajopana. Raú ruli'ichá palá ajopana chaje. ");
INSERT INTO ycn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ajopana qui'ichaño naliñérute lupemí richojé. Eyá rucá qui'ichayo piyuque ruliñérute richojé. A'ajnejí huarúhua'ajona penaje ri'imichácajla —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús jácho'oro Tupana ñacaré chiyá. Aú pajluhuaja ra'apiyatéjeri quemari rijló: —Huehuíña'atajeri, pamala marí Tupana ñacaré. Jipa naquiyá la'acanami ricá. ¡Meque palani huani ricá! ");
INSERT INTO ycn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús quemari rijló: —Tupana ñacaré pamácare me'etení, jipa naquiyá la'acanami ricá. Uncá ri'imalaje maare. Aquijñojo ajopana, chapú péchuruna, cajya'atájeño piyuqueja ricá. Ejomi uncá pajluhuaja ñani jipa yurílajo pachácaca —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","E Jesús i'ijnari yenuri Olivos ejo. Re ri'ihuata nacú riyá'o Tupana ñacaré ejo pumitá. E caja Pedro, Santiago, Juan, Andrés, quele i'ijnaño Jesús chaje. Necámica que ne'emacá re. E nemá rijló: ");
INSERT INTO ycn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Pimá huajló méquechamica ri'imajica quele pimíchaje nacú huajló. ¿Na aú chi ina'uqué hue'epéjeño méquechamica riphájica rená chojé? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús quemari najló: —Jema'aniya ajopana ja'apiyá; napajlájica ijhua'até. ");
INSERT INTO ycn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Iqui'iruna ina'uqué iphájeño. Na'ajé nuí, neí hua penaje. Apú, apú que nemájica nanacuhuá: “Ricá Tupana huacára'acare majó ina'uqué i'imatájeri penaje nucá”, que nemájica nanacuhuá. Napajlájica najhua'até raú. Cajrú ina'uqué jema'ajeño na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Marí que nemájica ijló: “Nenócaco pajhua'atéchaca maárohua que, ya'ajnárohua que”, iquero'oniyo raú. Caja queja ri'imajica. Uncá jo'ó eja'ahuá tajnálajo nenócajico huacajé. ");
INSERT INTO ycn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ajopana te'eré eruna nócajeño ajopana te'eré eyájena hua'até. Ajopana huacára'ajeri hua'atéjena nócajeño ajopana huacára'ajeri hua'atéjena hua'até. Cajrú te'erí ñaca'ajico apú eyá, apú eyá que rihuacajé. Cajrú caja ina'uqué taca'ajica me'epejí nacú rihuacajé. Marí caje aú ina'uqué queño'ojeño chapú caje yajhué ña'acana panacu. ");
INSERT INTO ycn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ihue'epí méqueca nala'ajica ricá. Najña'ajé icá ihuacára'ajeño ejo, no'opiyá jema'ajeño i'imacale. Naña'ataje icá ina'uqué jahuacáca'alo ñacarelana chu. Itára'ajo caja ihuacára'ajeño jimaje, ajopana, ajopana que jimaje, naculácatacoloje inacu penaje. Marí que nala'ajica icá, no'opiyá jema'ajeño i'imacale. Marí caje aú i'imajé nuyucuna najló. ");
INSERT INTO ycn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tupana i'imatájeri ina'uqué capichácajo liyá. Rená tajnaco piyá ne'emajé riyucuna piyuqueja ina'uqué eja'ahuá chu i'imacáñojlo. ");
INSERT INTO ycn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Najña'ajica icá ihuacára'ajeño ejo huacajé, ihuó la'aniyo méqueca imájica najló piyá. Tupana Pechu quemájeri ijló méqueca imájica najló, riphájicaja rená chojé ijló. Uncá imalaje najló ipechu queja. Ripechu aú Tupana quemájeri ijló méqueca imájica nacaje nacú najló —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ne'iyajena ina'uqué a'ajeño nejena chapú nanacu péchurunajlo, nenócaloje necá penaje. Nachi'iná naquiyana a'ajeño najló nayani, nenócaloje necá penaje. Nayani naquiyana a'ajeño najló nachi'iná, nenócaloje necá penaje, que ne'iyajena la'ajica rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Piyuqueja ina'uqué pechu i'imajé inacu chapú, jema'acale no'opiyá. Uncájica ee jácho'o Tupana puráca'alo ja'apiyá i'imacana itaca'ajica ejená, Tupana i'imatájeri icá capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Danielmi chu i'imari Tupana puráca'alo ja'apátajeri i'imacá. Ricami chu lana'arí marí que papera chojé i'imacá: “Amájica ee nacaje pu'uhuareni huani tára'aco Tupana ñacaré chu, icá Judea te'eré eruna ñaajeño ipuré e'iyajé. (Marí papera amájeño, ihue'epí meque quemacánaca ricá.) ");
INSERT INTO ycn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Rihuacajé ca'ajná e'iyajena i'imajeño pají i'ihuata chu. Pu'ucuja iñaajico reyá. Uncá imujlúca'alaje pají chojé nacaje ña'ajé pamineco. ");
INSERT INTO ycn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Apala e'iyajena i'imajeño imena e'iyá. Icá caja ñaajeño pu'ucuja. Uncá caja ipa'alajo iñacaré chojé a'arumacaji ña'ajé pamineco. ");
INSERT INTO ycn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Chapú huani ri'imajica canupana inaánajlo rihuacajé. Chapú huani caja ri'imajica inaana cayaniquérunajlo. Ejo'ocaja i'iracaño chu'uchú nayani, quelejlo ri'imajé chapú rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cajrú iñaajico rihuacajé. Ipura'ó Tupana hua'até, ri'imacá piyá ipe'ení i'imajica huacajé. ");
INSERT INTO ycn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Rihuacajé cajrú ina'uqué ña'ajica chapú caje yajhué panacu. Tupana queño'ótaca eja'ahuá huacajé eyá uncá ina'uqué amálaño chapú caje yajhué, cajrú huani ri'imajica rihuacajé que caja. Uncá caja ri'imalaje ñaqué reyá a'ajná ño'ojó. ");
INSERT INTO ycn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tupana huitúca'atajeri najló rená, ri'imacá piyá júpija huani najló. Iqui'ija rihuátaca ina'uqué, ri'ihuapacárena rijluhua ajopana ina'uqué e'iyayá. Najló rihuitúca'ataje rená. Uncáquela rihuitúca'atajla rená najló, uncá na calé i'imarojla. ");
INSERT INTO ycn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nemájica ijló: “Iyacá'o, maare ricá Tupana huacára'acare majó ina'uqué i'imatájeri penaje”. Marí que nemájica ee ijló, jema'aniya na'apiyá. Nemájica ee ijló: “Iyacá'o, a'ajnare ricá” que, jema'aniya caja na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Cajrú ina'uqué i'imajica, majopeja napajlájica. Majopeja nemájica apú, apú que nanacuhuá: “Nucá Tupana huacára'acare majó ina'uqué i'imatájeri penaje”. Ajopana caja quemájeño nanacuhuá: “Huecá ja'apátaño Tupana puráca'alo ina'uquejlo ra'apiyá que”. Nala'ajé caja cajrú nacaje uncá meño'ojó iná la'alare nená que'ená penaje, ina'uqué jema'acáloje nanacojó napuráca'alo penaje. Cajrú napajlájica najhua'até. Tupana ja'apiyá jema'ajeño hua'até caja nahuata pajlácana. Uncá meño'ojó napajlálaje najhua'até, uncale nema'alaje na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ihue'epí numacare nacú. Uncá chiyó ri'imá ñaqué nu'umá riyucuna ijló —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Ina'uqué amájeño cajrú huani chapú caje yajhué i'imajica. Rihuacajé uncá camú camaré i'imalaje. Uncá caja queri amálajo, uncá ricamaré i'imalaje. ");
INSERT INTO ycn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ihuijrina caje ja'ajeño je'echú chiyá. Piyuque nacaje je'echú chu i'imacare ñaca'ajero. ");
INSERT INTO ycn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ejéchami namájica nucá huaíchaca juni suhuáca'ala e'iyohuá. Ina'uquéjloje penaje i'imacá nucá. Piyuque ina'uqué huacára'ajeri penaje nuphaje majó rihuacajé. Cajrú mejáma'atani i'imajica nohua'ó, hua'até nuphaje. ");
INSERT INTO ycn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nuphájica penaje nuhuacára'aje nujhua'atéjena je'echú chiyájena, ina'uqué huá'aje. Ina'uqué, nu'uhuapacárena nujluhua ajopana ina'uqué e'iyayá, huá'aje ne'ejnajé. Piyuqueja huani eja'ahuá e'iyayá nahuá'aje necá. ");
INSERT INTO ycn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ihue'epí nupa'ajico nacojé. Caja ihue'epí a'ahuaná higuera nacojé. Ri'iché pitúca'ari, ripaná moto'ocáloje rinaquiyá penaje. Ri'iché pitúca'aca aú iná hue'epí jarechí iphaca rená chojé. ");
INSERT INTO ycn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ñaqué caja ihue'epíjica nupa'ajico majó nacojé. Amájica aú piyuque nacaje numíchaje nacú, ihue'epeje yehuicha riphaca rená chojé caja penaje. ");
INSERT INTO ycn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Jema'á marí: Marí que ri'imajica ina'uqué tajnájico yámona. ");
INSERT INTO ycn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Je'echú, eja'ahuá hua'até tajnájero. E'iyonaja calé uncá nupuráca'alo tajnálajo. Numacá rinacu queja nacaje i'imajica. ");
INSERT INTO ycn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Uncá na calé hue'epiri méquechamica nupa'ajico piño je'echú chiyá majó. Uncá caja Tupana hua'atéjena je'echú churuna, hue'epílaño noná. Ricaja calé Nora'apá, Tupana, hue'epiri noná. ");
INSERT INTO ycn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’I'imá nupé maare. Ipura'ó Tupana hua'até. Uncá ihue'epílaje méquechamica nupa'ajico piño majó. ");
INSERT INTO ycn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Marí que ricá: Apú i'ijnari ca'ajná ya'ajnaje. Riyurí riñacaré. Ri'ijnacá yámona rimá rijhua'até sápajeñojlo, nala'acáloje rijló nacaje, ya'ajná ri'imacá quetana penaje. Apujlo, apujlo que rimacá najló, nala'acáloje nacaje rihuátacare caje penaje. Pají hua'aphejlo rimá, rihuátacaloje ricá penaje. Ejomi ri'ijná ya'ajnaje. ");
INSERT INTO ycn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jesús quemari piño najló: —Ihuata nucá maare. Uncá ihue'epila méquechamica nupa'ajico majó. Nuphaje lapí ca'ajná, lapí jenaji que ca'ajná, capere apoca ee ca'ajná nuphaje, lapiyami ca'ajná nuphaje. Uncá iná hue'epila méquechamica nuphájica. ");
INSERT INTO ycn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Apala quiñaja ca'ajná nupa'ajico. Uncá paala nomájica icá majopeja, uncá nuhuátacana nacú calé. ");
INSERT INTO ycn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Numá ijló, ihuátacaloje nucá penaje. Ñaqué huánija numacá piyuque ina'uquejlo, nahuátacaloje nucá nuphájica majó ejena penaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Iyamá cala yuriro natucumá nale'ejé fiesta ja'apejé. Nale'ejé fiesta ií i'imari Pascua. Rihuacajé najñaque pan mamúra'atacanaru. E caja sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, quele i'ijnataño napéchuhua méqueca napajlácajla Jesús hua'até, najña'acáloje ricá mana'í chiyó penaje. Nenócaloje ricá penaje, napura'ó pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","E nemá pajlocaca: —Uncá paala ripatacana fiesta e'iyá. Ñaqué huala'aquela ricá, cajrú ina'uqué yúcha'acojla huachá raú. ");
INSERT INTO ycn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pajimila Betania e Jesús i'imari Simón ñacaré chu. Napona patáca'ataro penájemi Simón i'imacá. Rijhua'até Jesús ajñari ra'ajnehuá riñacaré chu. Na'ajnehuá ajñacana nacú ne'emacá ee, apa'ahuelo iphayo Jesús ahua'ajé. Huíluru i'imari rucapi. Jipa alabastro naquiyá la'acanami ri'imacá i'imari rucapi. Pu'uté richu nacaje jilá i'imacá, nardo rií. Ricá huani ri'imacá; pu'umé huani jamarí ri'imacá. Cahuemini huani caja ri'imacá. E ruphá Jesús ahua'ajé. Rumajáca'ata ricá, rujme'etácaloje richaya penaje. Quéchami roco'ocá ricá piyuque Jesús huilá e'iyajé. ");
INSERT INTO ycn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Marí caje aú, ajopana re i'imacaño, yúcha'año ruchá. Nemá pajlocaca: —¡Naje majopeja huani ta rucupíchaca ricá! ");
INSERT INTO ycn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Cahuemini huani ilé caje jilá. Ro'oquela ajopánajlo ricá, na'ájla rojló rihuemí cajrú huani liñeru, ro'ocáloje camu'ují la'acaño ñaté raú penaje —que nemacá pajlocaca. Cajrú naca'acá rumaná. ");
INSERT INTO ycn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aú Jesús quemari najló: —Reja ru'umareja. ¿Naje chi iqui'ichá pu'ují caje rupechu naquiyá? Palá ruli'ichaca nucá raú. ");
INSERT INTO ycn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ihuátajica ee camu'ují la'acaño ñaté a'acana, re necá ijhua'até ñaqueja. Eyá nucá, uncá ñaqueja huani calé nu'umajica ijhua'até —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Rimá piño najló: —Rupechu locópa'ala ruli'ichaca nucá palá. Roco'ochá nardo jilá nuhuilá e'iyajé. Raú rulamá'achiya nunapona. Nato'otájica nutami támijimina to'otáquelana chojé huacajé penaje ri'imajé. ");
INSERT INTO ycn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Jema'á marí: Tupana i'imatari ina'uqué capichácajo liyá. Ne'ejnajé riyucuna i'imajé ajopana, ajopánajlo que. Ne'emajé caja huajé ruli'ichaje nucá yucuna najló, napechu capicháñaca piyá rucá penaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","E caja Judas i'ijnari sacerdótena huacára'ajeño chaje. Iyamá iphata ji'imaje nacojé quele Jesús ja'apiyatéjena naquiyana ri'imacá. E ri'ijná namaje. Rimá najló meque la'ajémica ra'acajla najló Jesús. ");
INSERT INTO ycn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ri'imacá aú riyucuna najló, palá napechu i'imacá rinacu. E nemá rijló: —Hua'ajé pijló liñeru, pa'ajica ee huañaté ripatacana aú. —Je. Reyá a'ajná ño'ojó Judas quejíla'ari Jesús, ramácaloje méqueca ra'acajla najló ricá. ");
INSERT INTO ycn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","E caja naqueño'ó fiesta ja'apátacana. Riqueño'ojico huacajé najñaque pan mamúra'atacanaru. Nenoque caja ohuéjana yaní Tupánajlo fiesta a'ajnená penaje. E caja naqueño'ó fiesta ja'apátacana. E caja ra'apiyatéjena quemaño Jesusjlo: —¿Meño'ojó chi huala'ajé pijló fiesta a'ajnená? ");
INSERT INTO ycn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","E Jesús quemari iyamá ra'apiyatéjenajlo marí que: —I'ijná a'ajná ño'ojó pajimila ejo. Re iphácajo apú hua'até. Juni rihuacúla'apa que iphátajica ricá. ");
INSERT INTO ycn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Eco i'ijná rápumi chu, imujlúca'achi rijhua'até pají chojé. Eco imá pají minajlo marí que: “Huehuíña'atajeri quemíchari pinacu: ¿Mere ucapú, huajñácaloje pascua a'ajnená richojé no'opiyatéjena hua'até penaje?” que imájica rijló nunacu. ");
INSERT INTO ycn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Raú riya'ataje ijló ucapú ñópo'ojlo lamá'ataqueja yenú. Piyuque huani nacaje i'imajica lamá'ataqueja richu. Ricá chu ila'ajé huajló a'ajnejí —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aú ne'ejná pajimila ejo. Amaño ucapú i'imacá Jesús quemacá que najló. Richu nala'á pascua a'ajnená. ");
INSERT INTO ycn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Calajerúchami Jesús i'ijnari rejo iyamá iphata ji'imaje nacojé quele ra'apiyatéjena hua'até. Nephá rejo. ");
INSERT INTO ycn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","E najñá na'ajnehuá. Najñaca na'ajnehuá ee rimá najló: —Jema'á marí: Re maare pajluhuaja inaquiyana, ajñari ra'ajnehuá nujhua'até. Ricá a'ajeri nupinánajlo nucá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Raú camu'ují napechu la'acó. —¿Nucá chi quele pimá nacú? —que nemacá rijló pajehuémichaca. ");
INSERT INTO ycn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús quemari najló: —Iyamá iphata ji'imaji nacojé quele icá no'opiyatéjena. Pajluhuaja inaquiyana a'ajeri nucá nupinánajlo. Ilé janóro'otari pan nuparatune chu nujhua'até, ricá numá nacú. ");
INSERT INTO ycn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ina'uquéjloje penaje i'imacá nucá. Nutaca'ajé Tupana puráca'alo lana'aquéjami quemacá que nunacu. E'iyonaja calé chapú huani ri'imajica rijló a'ajeri nucá nupinánajlo. Uncáquela rimoto'ójla i'imacá, palani ri'imacajla rijló. Raú uncá Tupana huajálajla ricá cajrú huani —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Najñaca na'ajnehuá ee Jesús ña'arí pan ricápojo. Ejomi rimá Tupánajlo: —Palá pila'acá huecá marí pan aú. Ejomi ritupa'á rinaquiyana. E ritamáca'ata najló pan yupa'aqueja. Rimá najló: —Ijña'á cari, nunapona ricá. ");
INSERT INTO ycn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Quéchami rijña'acá chiyela caje ricápojo. Epepí inarí cajmú icha jalá amúra'atacanami i'imari richu. Rimá Tupánajlo: —Palá pila'acá huecá marí cajmú jalá aú. Rejomi ra'apata ra'apiyatéjenajlo ricá. Piyuque necá i'iraño rinaquiyana. ");
INSERT INTO ycn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Rimá najló: —Nura ricá. Nura i'ijnajeri nophú chiyá ina'uqué chaya penaje. Marí caje aú Tupana amájero cajrú ina'uqué chaje, pu'uhuaré nala'acare liyá. ");
INSERT INTO ycn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jema'á marí: Uncá hue'eralaje jepepí inarí cajmú jalá ijhua'até marí eja'ahuá chu piño. Tupana hua'até hue'emajica ee je'echú chu, nu'uraje apú caja jalá ijhua'até re —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eyá caja penaje nataní Tupana yale. Ejomi ne'ejná yenuri Olivos ejo. ");
INSERT INTO ycn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","E Jesús quemari najló: —Ñaano pani ipechu la'ajó piyuque ujhuí nuliyá. Ja'apáñaje nucá. Marí que Tupana puráca'alo lana'aquéjami quemacá huanacu: “Nonoje ohuéjana lamára'ajeri naliyá. Raú macajmálaja neñaajico”, que rimacá huanacu. ");
INSERT INTO ycn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nenoje nucá. Numacápo'ojico ejomi nu'ujnajé Galilea ejo itucumá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","E Pedro quemari rijló: —Piyuque ajopana ca'ajná ja'apáñajeño picá. Eyá nucá, uncá ta no'opáñalaje picá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús quemari rijló: —Jema'á marí: Ñaano lapí, capere yaca'ajica piyá iyamá pe, pimicho'otájicaja nuchaya hueji que pe —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Caphí Pedro quemacá: —Nenoje ca'ajná nucá pijhua'até. E'iyonaja calé uncá numicho'otálaje pichaya raú—que rimacá Jesúsjlo. Ajopana ra'apiyatéjena quemaño ñaqué caja. ");
INSERT INTO ycn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","E caja nephá Getsemaní ejo. Apucunaji ií Getsemaní. E Jesús quemari ra'apiyatéjenajlo: —Maare iyá'o, nupura'acó Tupana hua'até a'ajná ño'ojó quetana. —Je —que. ");
INSERT INTO ycn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Rihuá'a a'ajná ño'ojó rijhua'ató Pedro, Santiago, Juan, queleja. E caja apú que huani Jesús pechu la'acó rejo. Camu'ují huani rila'acá rinacuhuá rejéchami i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","E rimá najló: —Camu'ují huani nupechu me'etení, nutaca'ajícale. Uncá meño'ojó nujña'alá panacu. Quehuí huani nojló ricá nuhuajhué naquiyá. Iyuró maare cajmuruna que, icamátaniyo —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","E ra'apaña necá a'ajná ño'ojó pani. Re rito'ó pajima'aló te'erí e'iyá. Ripura'ó Tupana hua'até. Rimá Tupánajlo, ri'imatácaloje ricá chapú caje yajhué ramájicare ñaano pani liyá penaje. Palani ri'imaquela Tupánajlo rihuata ri'imatácajla ricá richiyá. ");
INSERT INTO ycn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Rimá rijló marí que: —Pa'ayú, picá hue'epiri piyuque huani nacaje la'acana. Pihuátajica ee pa'apata nuliyá chapú caje yajhué nomájicare ñaano pani. Pila'aniya nuhuátaca que; pihuátaca que pila'acá —que rimacá Tupánajlo. ");
INSERT INTO ycn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","E ripa'ó piño nachaya, amari nacamátaco. Rimá Pédrojlo: —Simón Pedro ¿Picamáchiyaco chi? ¿Uncá meño'ojó chi pi'imaláchajla nujhua'até cajmuni pajluhua camú jená quetana? ");
INSERT INTO ycn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","I'imá cajmúruna, ipura'ó Tupana hua'até, ila'acá piyá pu'uhuaré. Re ricá iná pechu nacú, iná la'acáloje palá raú penaje. E'iyonaja calé uncá meño'ojó iná la'alá palá iná icoja —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","’E ri'ijná piño Tupana hua'até pura'ajó. Ñaqueja caja rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ripa'ó piño nachaya, amari nacamátaco piño. Caja tapú chá'atari necá. Riphá nachaya. Uncá nahue'epila méqueca nemacajla rijló. ");
INSERT INTO ycn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","E ripa'ó piño Tupana hua'até pura'ajó. Ejomi ripa'ó piño nachaya. Caja hueji que pe la'acá. E rimá najló: —Chuhua icamato; ihuatána'a; caja chuhua. Caja riphicha rená chojé nojló. Ina'uquéjloje penaje i'imacá nucá. Chuhua na'ajica chapú la'acáñojlo nucá —que rimacá najló—. ");
INSERT INTO ycn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jácho'o, chuhua i'ijná hue'ejnachi. Caja ilé huaícha a'ajeri nucá pu'uhuaré la'ajéñojlo. ");
INSERT INTO ycn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús pura'acó najhua'até ejé Judas iphari rinacu. Iyamá iphata ji'imaji nacojé quele naquiyana ri'imacá. Riphá rinacu cajrú ina'uqué hua'até. Sajalu caje, cujyúhua'ala caje hua'até nephá nanacu. Sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, peñahuilana, quele puráca'alo aú ne'ejná rejo ripataje. ");
INSERT INTO ycn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Maapami que Judas a'acá rijhua'até i'ijnacáñojlo jenaji, nahue'epícaloje mecajeca napatájica penaje. Rimá najló marí que i'imacá: —Pu'uhuacá nuchiño'ojica rijimá chiyá, ricá ta ipataje. Eco ijña'á ricá ijlú chuhuá —que rimacá rijhua'até i'ijnacáñojlo maapami que. ");
INSERT INTO ycn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","E caja riphá rinacu. E rajalaca Jesús. Rimá rijló: —Huehuíña'atajeri —que. Ejéchami richiño'ocá rijimá chiyá. ");
INSERT INTO ycn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eja napatá Jesús, najña'acáloje ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ejéchami apú, re i'imacare, jero'ocá risajálune ra'aruná chiyá. Ricá aú rica'á apú i'ijhuí. Sacerdótena huacára'ajeri hua'até sápajeri ri'imacá, ri'ijhuí rica'á. ");
INSERT INTO ycn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","E Jesús quemari najló: —Caja i'ijichá majó nujña'ajé sajalu hua'até, cujyúhua'ala hua'até. Meque ata'acachi que huani ila'acá ijluhua nucá. ");
INSERT INTO ycn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hue'echú ca'alá queja nu'umajica ijhua'até Tupana ñacaré chu jehuíña'atacana nacú. E'iyonaja uncá ijña'alá nu'umacá rihuacajé. Marí que ila'acá nucá me'etení Tupana puráca'alo lana'aquéjami quemacá nunacu que —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ejéchami piyuqueja ra'apiyatéjena ja'apáñaca Jesús. Neñaó reyá. ");
INSERT INTO ycn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","E caja najña'á Jesús. Nápumi chu apú hualijímaca ja'apari najhua'até. A'arumacaji mapíra'aqueja rinacu que ra'apaca nápumi chu. E napatajla ricá. ");
INSERT INTO ycn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Napatacá ricá ra'arumacá naquiyá. Aú ja riñaó richiyá a'ajná ño'ojó ma'arumacaru. Ra'arumacámija calé yuriro nacápeje. ");
INSERT INTO ycn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","E najña'á Jesús sacerdótena huacára'ajeri ejo. Riñacaré chojé sacerdótena huacára'ajeño, ajopana peñahuilana, Tupana puráca'alo nacú jehuíña'atajeño, quele jahuacaño rijhua'até richojé. ");
INSERT INTO ycn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","E caja Pedro ja'apari juca pani Jesús ápumi chu. Iphari sacerdótena huacára'ajeri ñacaré cópeje. Re riyá'o pají hua'aphena i'imacaño hua'até ja'anapacaje nacú siyá ji'ilá. ");
INSERT INTO ycn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pachu sacerdótena huacára'ajeño i'imaño piyuque judíona huacára'ajeño hua'até. Re napura'ó Jesús nacú, nahue'epícaloje na aú ca rila'acá pu'uhuaré rijluhua i'imacá, nenócaloje ricá richona penaje. Uncá nahue'epila na aú ca rila'acá pu'uhuaré. ");
INSERT INTO ycn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Cajrú ina'uqué pajlaño rinacu. Majopeja nemacá rinacu: “Pu'uhuaré la'ajeri ricá” que. Que'iyapé narucátaca najló ricá; uncá pajluhua chuhuaja calé narucata ricá. ");
INSERT INTO ycn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ne'iyajena pajlaño Jesús nacú majopeja. Nemá najló: ");
INSERT INTO ycn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Marí que ilé ina'uqué quemacá rinacuhuá: “Nucá cajya'atárijla Tupana ñacaré ina'uqué la'acare i'imacá. Hueji que cala i'imajemi nula'ájla piño rapumí chuhuá ricá. Uncá ina'uqué calé la'acare ri'imajica. ");
INSERT INTO ycn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Uncá caja richuhuá calé nemacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Marí caje aú sacerdótena huacára'ajeri tára'aro ne'iyá. Rimá Jesusjlo: —¿Uncá chi papiyácala pinacojó necá? ¿Meque chi ricá quele nemá nacu? —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Uncá ra'ajipalá rijló. Raú sacerdótena huacára'ajeri quemari piño rijló: —¿Picá chi picá, quele Tupana huacára'acare majó ina'uqué i'imatájeri penaje? ¿Ilé palani Tupana I'irí huani chi picá? ");
INSERT INTO ycn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús quemari rijló: —A'a, ilé pimíchaca nunacu queja nucá. Ina'uquéjloje penaje i'imacá nucá. Icá amájeño nucá Tupana ahua'á. Piyuque la'acá Tupana. Rijhua'até nu'umajé ina'uqué huacára'ajeri. Icá amájeño nupa'acó piño majó je'echú chiyá juni suhuáca'ala e'iyohuá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Marí caje aú sacerdótena huacára'ajeri yúcha'aro íqui'ija huani. A'acuhuaná rijiyo'otá ra'arumacahua, rimá ajopánajlo: —Ilé ta puri'icharo pu'uhuaré huani ta Tupana nacú. Uncá na penaje calé huaculá ajopana, nemacáloje huajló na aú ca rila'acá pu'uhuaré penaje. ");
INSERT INTO ycn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Caja huemi'ichá méqueca rimíchaca huajló pu'uhuaré huani Tupana nacú. ¿Meque huala'ajica ricá richona? —que rimacá najló. Raú piyuqueja ina'uqué quemaño rinacu, nenócaloje ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","E ne'iyajena atupaño nahui Jesús nacojé. Napára'a rijimá, naña'á ricá. Ejomi nemá rijló: —¿E pihue'epícajla naca ji'ichaca picá? Ñaqué caja pají hua'aphena ña'ataca ricá pajimaya nayáte'ela aú. ");
INSERT INTO ycn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Marí que nala'acá Jesús ee, Pedro i'imari nañacaré copi ajopana hua'até. E caja apa'ahuelo iphayo nanacu. Sacerdótena huacára'ajeri hua'até sápajeyo ru'umacá. ");
INSERT INTO ycn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ruphá nanacu, amayo Pedro ja'anapacá. Raú ruyacá'o richaje. E rumá rijló: —Nuhue'epí ilé Jesús, Nazaret eyaje, hua'ateje picá. ");
INSERT INTO ycn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","E'iyonaja Pedro micho'otari richaya, rimá rojló: —Uncá nomána'apa calé ricá, uncá huani ta nuhue'epila na nacuca pimacá nojló. E ra'apá ají que corral numaná ejo. Ejéchami capere yaca'acá. ");
INSERT INTO ycn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Rejomi romá piño ricá. E rumá re i'imacáñojlo: —Ilé Jesús, Nazaret eyaje, hua'ateje ricá. ");
INSERT INTO ycn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro micho'otari piño richaya. Mequetánaja i'imajemi re i'imacaño quemaño piño Pédrojlo: —Rijhua'atéjena naquiyana jo'ó picá. Galilea eyaje ricá; reyaje caja picá. Napura'acó rite'eré ehuá que caja pipura'acó. Raú huahue'epí reyájeca picá —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Marí caje aú Pedro quemari najló caphí: —Nuhuata Tupana huajaca nucá, uncaja que numá quehuaca: Uncá huani ta nomána'apa calé ricá imá nacú nojló. ");
INSERT INTO ycn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ejéchami capere yaca'acá piño. Iyamá pe la'acá. Hua'ató que riphaca Pedro pechu nacojé Jesús quemacare nacú rijló maapami que. Rimá rijló i'imacá: “Capere yaca'ajica piyá iyamá pe, picá micho'otájeri nuchaya hueji que pe caja.” Marí que riphaca Pedro pechu nacú rema'acá aú capere yaca'acá piño. Aú supejeno riyaca. ");
INSERT INTO ycn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Muní que najme'etá piño. Sacerdótena huacára'ajeño, ajopana peñahuilana, Tupana puráca'alo nacú jehuíña'atajeño, quele jahuacaño piño ajopana judíona huacára'ajeño hua'até. Napura'ó pajhua'atéchaca Jesús nacú. E nepo'otá Jesús a'anapitá panacojéchaca. Ejomi nahuá'a ricá nate'eré eyá huacára'ajeri ejo. Pilato rií i'imacá. Rijló na'á ricá. ");
INSERT INTO ycn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","E Pilato quemari Jesusjlo: —¿Judíona i'imacana chi picá? —A'a, nucá nucá pimacá nunacu queja —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","E sacerdótena huacára'ajeño arucátaño Jesús Pilátojlo. —Cajrú rila'acá pu'uhuaré rijluhua —que nemacá rijló Jesús nacu. ");
INSERT INTO ycn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","E Pilato quemari piño rijló: —¿Uncá chi papiyácalaje necá pinacojó? Caja pemi'ichá cajrú narucátaca picá nojló —que rimacá Jesúsjlo. ");
INSERT INTO ycn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Uncá Jesús ja'ajipalá rijló. Raú Pilato pechu i'imari: “¿Na ta chi caji numajlo?” ");
INSERT INTO ycn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Fiesta pascua huacajé queja Pilato jácho'otajica ina'uqué huajáquelana chiyá pajluhuaja ina'uqué. Ricá nahuátajicare, rácho'otaque najló. ");
INSERT INTO ycn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Rihuacajé apú i'imari ina'uqué huajáquelana chu ajopana hua'até. Rií i'imari Barrabás. Júpimi que ricá, rijhuáque'ena, quele noño ina'uqué, nenócaco ne'emacana hua'até huacajé. ");
INSERT INTO ycn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","E caja riphá rená chojé ne'emacánajlo, rácho'otacaloje pajluhuaja ina'uqué huajáquelana chiyá penaje. Aú ajopana iphaño Pilato nacú rijló quemaje. ");
INSERT INTO ycn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","E Pilato quemari najló: —¿E ihuátaca nócho'otaca ijló judíona i'imacana? ");
INSERT INTO ycn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Marí que rimacá najló, rihue'epícale chapú sacerdótena huacára'ajeño huo i'imacá Jesús cha, richá'atacale necá ripechu aú. Ñaqué i'imacale najña'á rejo ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Caja sacerdótena huacára'ajeño ca'átaño ina'uqué e'iyajé pamineco, nemachi Pilátojlo, rácho'otacaloje Barrabás najló penaje. ");
INSERT INTO ycn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","E Pilato quemari najló: —¿Meque nula'ajica ricá imá nacú: “Judíona i'imacana ricá”? ");
INSERT INTO ycn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aú nahuíyo'o cajrú, nemá rijló: —Pihuacára'a rinócana a'ahuaná apiyácacanami nacojé jacúhua'ataqueja. ");
INSERT INTO ycn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato quemari najló: —¿Naje ta ihuata rinócana? ¿Na ta chi rila'á pu'uhuaré? Aú richaje nahuíyo'oca: —Pihuacára'a racúhua'atacana a'ahuaná apiyácacanami nacú —que nahuíyo'oca. ");
INSERT INTO ycn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aú Pilato jácho'otari najló Barrabás, rihuátacale napechu i'imacá rinacu palá. E rihuacára'a Jesús ña'atácana. Ejomi ra'á suráranajlo ricá, nacúhua'atacaloje ricá a'ahuaná apiyácacanami nacojé penaje. ");
INSERT INTO ycn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","E najña'á Jesús ne'emacana ñacaré cópeje. Re nahuacata piyuque huani surárana re i'imacaño. ");
INSERT INTO ycn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nala'acáloje namácaja penaje, na'á rinacojé ipirálucuni a'arumacaji. Ne'emacana a'ajícare rinacuhuá caje ri'imacá na'á rinacu. Nachipúca'ata caja rihuíla'aru nacojé tujripi. ");
INSERT INTO ycn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ejomi najalaca ricá. —Judíona i'imacana ¿picá? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ne'ecá rihuilá isijila ina aú pehuíla'aruya. Natupá caja nahui rinacojé, natára'o caja ne'erúpachi aú rijimaje; nacúhua'ata nehuíla'aru rijló. ");
INSERT INTO ycn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Marí que nala'acá nacátajohua ricá i'imacá. E naca'á piño ra'arumacá ipirálucuni rinaquiyá. Rejomi na'á piño apú ra'arumacá rinacojé. E najña'á Jesús, nacúhua'atacaloje ricá a'ahuaná apiyácacanami nacojé penaje. ");
INSERT INTO ycn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na'apá ají que a'ajná ño'ojó. Re nephata apú ina'uqué, pajimila yámojo nephácaca rijhua'até. Rií i'imari Simón. Sirene eyaje ri'imacá. Alejandro, Rufo, quele jara'apá ri'imacá. Ricá nahuacára'a Jesús chaya a'ahuaná apiyácacanami huáco'ocana. ");
INSERT INTO ycn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","E najña'á Jesús ají que rinóquelana ejo. “Ina'uqué huíla'arumi aphinami,” que na'ajica ina'uqué nóquelana ií. Napura'acó chu na'á rií Gólgota que. Rejo najña'á Jesús i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Re na'á Jesusjlo i'iracaje. Cajmú caje jalá amúra'atacanami, pusana caje hua'até quechípa'acanami ri'imacá. Mirra pusana ií. Na'á rijló ricá, ri'iracáloje ricá penaje. E'iyonaja uncá ri'iralá ricá na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","E caja ehuaja nacúhua'ata ricá a'ahuaná apiyácacanami nacojé ipháqueja itapuhua aú. Pe'iyochami camú jácho'oco ee, nacúhua'ata ricá. Ejomi surárana cátaño nacaje nacú, namácaloje méqueca natamáca'ataca najluhua ra'arumacami penaje. ");
INSERT INTO ycn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","E nacúhua'ata lana'aquéjami Jesús cha. Ricá quemari na chónaca nenoca ricá. Marí que lana'aquéjami quemacá rinacu: “Marí Jesús, judíona i'imacana ricá.” ");
INSERT INTO ycn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Rejé caja nacúhua'ata ajopana iyamá. Rahua'á iyáma'ajo pumitá nacúhua'ata necá. Ata'acáchina ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Marí que nacúhua'atacana Jesús rahua'á aú nala'á ricá Tupana puráca'alo lana'aquéjami quemacá que. Rimá Jesús nacú: “Uncá ina'uquélaruna naquiyana que namájica ricá.” ");
INSERT INTO ycn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Rahua'ayá ja'apájicaño la'aqueño namácaja ricá. Nañaca'aqué nehuíla'aru rijló, nemá rijló: —Yee, picá quemaqueri pinacuhuá: “Nucá cajya'atájeri Tupana ñacaré. Hueji que cala i'imajemi nula'ajé piño rapumí chuhuá ricá”. ");
INSERT INTO ycn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Chuhuata pi'imatá picó. Pihuitúca'a a'ahuaná apiyácacanami naquiyá —que nemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ñaqué caja sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, quele la'ajica namácaja Jesús. Nemá pajlocaca: —¡Meque calé ta ri'imataca ajopana capichácajo liyá i'imacá! Eta ricó uncá meño'ojó ri'imatala! ");
INSERT INTO ycn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ajopana quemaño rinacu: “Tupana huacára'acare majó ina'uqué i'imatájeri penaje ricá. Israélmi chu laquénami huacára'ajeri ricá”, que nemacá rinacu. Rihuitúca'ajica ee a'ahuaná apiyácacanami naquiyá, caphí huapechu i'imajica richojé, ri'imacáloje Hue'ematájeri penaje —que nemacá Jesús nacú. Ñaqué caja ata'acáchina, nacúhua'atacarena Jesús ahua'á, pura'acó pu'uhuaré Jesús nacú. ");
INSERT INTO ycn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","E caja caápu'ucu i'imari nachá. Ejéchami calajeruni, lapí que i'imacá nachá piyuqueja eja'ahuá chu. Caápu'ucu eyá pe'iyochami camú to'ocó quetana ne'emacá calajerúhuaca. ");
INSERT INTO ycn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pe'iyochami camú to'ocó ee, Jesús jahuíyo'ori caphí huani. Napura'acó chu rimá: —Eloi, Eloi ¿lama sabactani? Marí que quemacánaca ricá: “Tupana, nupechu i'imacare chojé caphí ¿na penaje piyurí nucá?” ");
INSERT INTO ycn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Re i'imacaño jema'añó rahuíyo'oca. Aú nemá pajlocaca: —Jema'á. Ilé huá'ari Tupana puráca'alo ja'apátajeri, Elíasmi chujlo. ");
INSERT INTO ycn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Raú pajluhuaja jecho'ótari i'iracaje rijló. Rejata nacaje jamára'apani cajmú caje jalá amúra'atacanami acú. Quéchami repo'ocá ijijila lucupuji nacojé ricá. Ricá aú ra'á rijló ricá, Jesús i'iracáloje re'iyayá ricá penaje. Rimá ajopánajlo: —Huahuátaco pamineco, huamáijla, apala Elíasmi chu, iphájeri rihuitúca'ataje. ");
INSERT INTO ycn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","E Jesús jahuíyo'ori piño caphí huani caja penaje. Ejé ritaca'á. ");
INSERT INTO ycn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hua'ató que caja a'arumacaji, Tupana ñacaré chu cúhua'aco, jiyo'ocó pe'iyohuá paliyácaca. Apalá ucapú penaje que ri'imacá. Rijiyo'ó yenuya ají que cahuacaje. Caja iyamá que riyurico. ");
INSERT INTO ycn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Caja Jesús taca'arí. Rijimaje surárana huacára'ajeri tára'aro. Romano naquiyana ri'imacá. Cien rile'ejena surárana i'imacá. Ricá jema'arí Jesús jahuíyo'oca; ramá caja ritaca'acá. E rimá: —Tupana I'irí jo'ó quele táqui'ichari. ");
INSERT INTO ycn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Cajrú inaana i'imacá a'ajnare que. Júcayaja nayacá'o rejo. Nanaquiyana i'imaño María Magdalena, Salomé, María, quele. Apa'ahuelo ru'umacá María. Santiago, José, quele jaló ru'umacá. José i'imari rijmeremi. ");
INSERT INTO ycn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Necá inaana a'aqueño Jesús ñaté Galilea te'eré e ri'imaqué huacajé. Necá caja i'ijnaño rijhua'até Jerusalén ejo i'imacá. Necá penájenami i'imaño re cajrú ajopana inaana hua'até. ");
INSERT INTO ycn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","E caja najúhua'a. A'ajnejí lamá'atacana huacajé e'iyá ne'emacá. Muní que nale'ejé huatána'acaje huacajé i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ñaquele José i'ijnari Pilato, nahuacára'ajeri, amaje. Arimatea eyaje José i'imacá. Rihue'epí Tupana i'imajica ina'uqué naquiyana huacára'ajeri penaje. Aú ri'imá rihuátacana nacú. Ricá José i'ijnari Pilato chaje Jesús tami quejá'aje riliyá, rito'otácaloje ritami támijimi to'otáquelana chojé penaje. E riphá rinacu. Riquejá'a riliyá Jesús tami. ");
INSERT INTO ycn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Raú Pilato pechu i'imá: “¿Caja chi ritaqui'ichá?” E rihuá'a surárana huacára'ajeri maná. E caja riphá rinacu. E Pilato quemari rijló: —¿Caja chi ritaqui'ichá? ");
INSERT INTO ycn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Surárana huacára'ajeri quemari rijló: —A'a, caja ritaqui'ichá. Aú Pilato yuriri Josejlo Jesús tami, rijña'acáloje ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","E José i'ijnari palá nojé a'arumacaji huarúhua'aje. Rihuarúhua'aca ricá ejomi ripa'ó Jesús tami huitúca'ataje. E ripila'á a'arumacaji ritami nacuhuá. Ejomi rijña'á ritami támijimi to'otáquelana ejo. Rito'otá ritami richojé. Jipa ichácanami ri'imacá. Ricá chojé rito'otá ritami. Caja penaje ratatá cajruni jipa rinumanaje. Raú ritá rinumaná. ");
INSERT INTO ycn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Eyá a'ajnare que María Magdalena, María José jaló, quele huojítaño ricá, namácaloje mérejeca rito'otaca ritami penaje. ");
INSERT INTO ycn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Caja nale'ejé huatána'acaje huacajé ja'apari i'imacá. Caja najúhua'a. Aú María Magdalena, Salomé, María, Santiago jaló ru'umacá, quele i'ijnaño pusana huarúhua'aje. Pu'umé jamarí pusana i'imacá. Naca'acáloje ricá Jesús tami nacojé penaje nahuarúhua'a ricá. ");
INSERT INTO ycn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","E caja sápacaje queño'ocó huacajé lapiyami, huajé camú jeño'ocá ee, ne'ejná ritami i'imacá ejo. ");
INSERT INTO ycn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ne'ejnacá ehuá nemá pajlocaca: —¿Na jatatájeri huajló jipa támijimi numaná eyá? ");
INSERT INTO ycn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","E nayacá'o rejo jucaya. Amaño caja jipa i'imacá jatatáquejami. Imujulá nojé ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nephá rejo. E namujlúca'a ulahuí chojé, amaño pajluhuaja hualijímaca yá'aco ritami nato'otácare pucunami chu. Ca'añá ejo pumitá riyá'o. Je'echú chiyaje ri'imacá. Jareni, huaphereni ra'arumacá i'imacá. Namaca ricá aú naquero'ó. ");
INSERT INTO ycn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","E rimá najló: —Iquero'oniyo nupiyá. Nuhue'epí i'ijichaca majó Jesús, Nazaret eyaje, tami amaje. Ricá nacúhua'atacare a'ahuaná apiyácacanami naquiyá i'imacá, ricá iculá. Uncá ri'imalá maare. Caja rimacápo'ocho. Iyacá'o, amachi meñaru rapucunami —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Rimá piño najló: —Chuhua ipa'ó, i'imichachi riyucuna ra'apiyatéjenajlo. Marí que imájica rinacu najló, Pédrojlo hua'até: “Caja ri'ijichá itucumá Galilea ejo. Rejo amaje ricá, rimacá ijló i'imacá que”. Marí que imájica najló —que rimacá najló. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","E nácho'o ulahuí chiyá. Quero'ocajo nacú cajrú nacurúca'aca. Ñaquele neñaó reyá. Uncá ne'emalá riyucuna ajopánajlo na'apaca ehuá, naquero'ocó a'acuhuaná. ");
INSERT INTO ycn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sápacaje queño'ocó huacajé, jareni jácho'oco ee, Jesús macápo'oro liri chiyá i'imacá. Pamineco huani riya'ató María Magdalénajlo. Ro'iyayá rica'á iyamá cuhuá'ata quele jiñana pechu i'imacá. Rojló riya'ató pamineco i'imacá. ");
INSERT INTO ycn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Riya'atacó rojló ejomi ru'ujná riyucuna i'imajé Jesús ja'apiyatéjenajlo. Necá amaño chapú caje yajhué Jesús taca'añácale necá. Cajrú neyaca ricá, e'iyá ruphá nanacu riyucuna i'imajé najló. ");
INSERT INTO ycn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Rumá najló: —Caja rimacápo'ocho, nomicha ricá —que rumacá najló. E'iyonaja uncá nema'alá ro'opiyá. ");
INSERT INTO ycn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ya'ajná Jesús ya'ataró piño iyamá ajopánajlo, pu'uteni e'iyohuá nachira'acó ee. ");
INSERT INTO ycn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Rejomi necá caja pa'añó piño napumí chuhuá riyucuna i'imajé nanaquiyánajlo. E'iyonaja uncá caja nema'alá na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pajluhua iphata ji'imaji nacojé quele ra'apiyatéjena i'imaño na'ajnehuá ajñacana nacú. Rejé riya'ató piño najló, raca'á necá. Uncá pachá nema'alá ajopana ja'apiyá, amaño ri'imacá rimacápo'oco ejomi. ");
INSERT INTO ycn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","E rimá najló: —Tupana i'imatari ina'uqué capichácajo liyá. Eco i'ijná ajopana te'eré ejo, ajopana te'eré ejo que riyucuna i'imajé najló. ");
INSERT INTO ycn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tupana i'imatájeri necá, jema'ajeño ra'apiyá. Nema'ajica ra'apiyá ejomi nala'ajé necá bautizar. Eyá necá, uncá jema'alaño ra'apiyá, Tupana huajájeri necá. ");
INSERT INTO ycn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Marí que no'opiyá jema'ajeño la'ajica nacaje nahue'epéjona penaje: Nupuráca'alo aú naca'ajé jiñana pechu ina'uqué e'iyayá. Napura'ajó me'echuje puráca'aloji chu, uncá nema'alare chu napura'ajico. ");
INSERT INTO ycn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Napatájica ee jeína puhuiruna i'imajícaño, uncá meque nala'alajo raú. Ne'eraje ca'ajná nacaje jalá puhuini, uncá caja meque nala'alajo raú. Nato'otaje nayáte'ela natámina nacú. Raú natejmo'otajo —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Marí que Nahuacára'ajeri Jesús quemacá najló. Ejomi Tupana huá'ari ricá ají que je'echú chojé. Palá Tupana pechu rinacu. Tupana hua'atéjena Huacára'ajeri ricá rijhua'até re. ");
INSERT INTO ycn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E caja ra'apiyatéjena i'ijnaqueño apú eyá, apú eyá que riyucuna i'imajé ajopánajlo. Tupana i'imataca ina'uqué capichácajo liyá Jesucristo palamane aú, yucuna ne'emaqué najló. Nahuacára'ajeri Jesucristo a'aqueri nañaté nacaje la'acana aú. Raú calé nala'aqué nacaje uncá meño'ojó iná la'alare caje. Nená que'ená penaje ri'imaqué. Raú ajopana hue'epíqueño quehuácaca napuráca'alo i'imajica. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Eco palá pijló, Teófilojlo: Cajrú ina'uqué maárohua huátaño Jesucristo yucuna lana'acana papera chojé. Maárohua hue'iyohuá ri'imajica huacajé yucuna nahuata lana'acana papera chojé palá. ");
INSERT INTO ycn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Piyuqueja nacaje rila'ajícare caje amájeño, necá i'imaqueño riyucuna najló i'imajica. Aú nalana'á papera chojé riyucuna i'imacá. Jesucristo queño'ocá risápaca'ala la'acana huacajé ne'emá rijhua'até. Piyuque nacaje rehuíña'atajicare nacú necá nema'aqué ra'apiyá. Necá penájenami ja'apátaqueño riyucuna ajopánajlo, ajopánajlo que. Huajló hua'ató piyuqueja na'apátaque riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Eyá nucá piño quejá'ari palá riyucuna ajopana ina'uqué liyá i'imacá. Piyuqueja riyucuna nuquejá'a palá, rijyuhuacami yucuna hua'ató. ");
INSERT INTO ycn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ñaquele, Teófilo, nuhuata riyucuna lana'acana piyuqueja palá pijló, pihue'epícaloje palá quehuácaje puráca'aloji nacojé raú penaje. Caja nohuíña'ata picá rinacu i'imacá, pihue'epícaloje rinacojé palá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes i'imacá judíona i'imacana huacajé, apú sacerdote i'imari. Rií i'imari Zacarías. Sacerdótena ií i'imari Abías. Nanaquiyana caja ri'imacá. Riyajalo ií i'imari Elisabet. Júpimi que Aaronmi chu i'imacá sacerdote. Rilaquénami naquiyana ru'umacá. ");
INSERT INTO ycn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Palá Tupana pechu i'imajica Zacarías nacú riyajalo nacú hua'até. Nema'aqué Tupana ja'apiyá palá. Piyuque ripuráca'alo lana'aquéjami quemacá que nala'ajícano i'imajica. Aú calé uncá meño'ojó ajopana ina'uqué quemalá nanacu: “Pu'uhuaré la'ajeño necá”, que. ");
INSERT INTO ycn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Uncá nayani i'imalá, mehuacú riyajalo i'imacale. Rihuacajé caja peñahuilana huani ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zacarías i'imari sacerdote. Risápaca'ala rila'aqué Tupánajlo. Pajehuémichaca nala'ajica ricá ajopana hua'até. Ñaquele rihuacajé ricá, rijhuáque'ena, quele la'añó ricá. ");
INSERT INTO ycn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tupana ñacaré chu ne'emá. E caja nahuacára'a rimujlúca'aca ucapú chojé, ricára'acaloje a'ahuaná icá reyá i'imajemi penaje. ");
INSERT INTO ycn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ricára'aca a'ahuaná icá quetánaja ajopana ina'uqué pura'acó Tupana hua'até apalá ucapú chu. ");
INSERT INTO ycn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","E'iyohuá queja Tupana hua'atéjeri, je'echú chiyaje, ya'atacó Zacaríasjlo i'imacá. Re mesa caje i'imari. Jipa naquiyá la'acanami ri'imacá. Ricá nacú nacára'aque a'ahuaná icá. Ca'añá chojó pitá mesa nacojé, Tupana hua'atéjeri, je'echú chiyaje, iphari. ");
INSERT INTO ycn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","E Zacarías amari ritára'aco. Rinacojé ripechu capicháñari risápaca'ala, cajrú huani riquero'ocole. ");
INSERT INTO ycn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ejéchami Tupana hua'atéjeri, je'echú chiyaje, pura'acó rijhua'até. Rimá rijló: —Zacarías, piquero'oniyo, Tupana jema'arí pipura'acó rijhua'até. Chuhua ra'ajica piñaté. Marí que ri'imajica pijló: Ilerú piyajalo huá'ajeyo ru'urí. Ñaquele pa'ajé rií Juan. ");
INSERT INTO ycn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pu'ují huani pipechu i'imajica rimoto'ojica aú. Ñaqué caja cajrú ajopana pechu i'imajica pu'ují raú. ");
INSERT INTO ycn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Palá huani Tupana pechu i'imajica pi'irí nacú. Uncá ri'iralaje nacaje jalá amúra'atacanami. Tupana Pechu i'imajeri re'iyá rimoto'ojica ejéchami. ");
INSERT INTO ycn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ri'imajé Tupana yucuna cajrú Israelmi chu laquénamijlo, napajno'otácaloje napéchuhua Tupana ejo raú penaje, nahue'epícaloje piño Tupana raú penaje. Iná huacára'ajeri huani ricá. ");
INSERT INTO ycn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ricá Tupana huacára'ajicare ina'uqué i'imatájeri penaje, tucumá ra'apátaje Tupana puráca'alo ina'uquejlo. Caphí Elíasmi chu pechu i'imajica Tupana puráca'alo ja'apátacana nacú ina'uquejlo. Ricá pechu i'imacá que caja pi'irí pechu i'imajica ra'apátacana nacú. Ra'apátaje ina'uquejlo Tupana puráca'alo, nayani pechu pala'acóloje nachi'iná hua'até raú penaje. Uncá jema'alaño Tupana ja'apiyá, jema'acáloje Tupana ja'apiyá penaje ri'imajé ina'uquejlo riyucuna —que Tupana hua'atéjeri, je'echú chiyaje, quemacá Zacaríasjlo i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","E Zacarías quemari rijló: —¿Na aú chi nuhue'epeje quele pimíchaca nojló? Phíyu'uque huani nucá, phíyu'uqueru caja nuyajalo. Uncá meño'ojó huayani i'imalá. ");
INSERT INTO ycn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aú Tupana hua'atéjeri quemari rijló: —Gabriel, Tupana hua'atéjeri nucá. Ricá huacári'ichari nucá majó pichaje, nu'umacáloje pijló riyucuna penaje. Palani huani riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Uncá pachá pema'alá nupuráca'alo no'opiyá, pi'imajé manumarú a'ajná pi'irí moto'ojica ejená. Numíchaca pijló queja pi'irí i'imajica. Riphájica rená chojé huacajé pi'irí moto'ojeri —que Tupana hua'atéjeri, je'echú chiyaje, quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Je'echú chiyaje pura'acó Zacarías hua'até quetana ajopana ina'uqué huátaca ricá. Apalá chu ne'emá. Napechu i'imá: “¿Na rila'alá júpija huani richu.” ");
INSERT INTO ycn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","E caja ehuaja Zacarías jácho'oro richiyá. Reyá a'ajná ño'ojó uncá meño'ojó ripura'aló. Riyáte'ela aú ja ripura'ó najhua'até, manumarú ri'imacale. Raú nemá rinacu: —Nápaja ca'ajná ya'achíyaro rijló ucapú chu, li'ichari ricá ají que —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","E caja riphá rená chojé, apú sápacaloje Tupana ñacaré chu rapumí chojé penaje. Aú ripa'ó riñacaré ejo. ");
INSERT INTO ycn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","E caja riyajalo i'imayo canupá. Aú caja uncá rócho'olo nañacaré chiyá pajluhua té'ela queta queri quetana. ");
INSERT INTO ycn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Pu'ují rupechu i'imacá, canupá ru'umacale. Rumá: “Caja marí que Tupana la'acá nucá palá, ajopana ina'uqué iphácaloje no'opí raú penaje. Uncá nephala no'opí mehuacú nu'umaqué huacajé.” ");
INSERT INTO ycn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet i'imacá canupá pajluhua cuhuá'ata queta queri quetana huacajé, Tupana huacára'ari ricaja caja Gabriel je'echú chiyá pajimila Nazaret ejo. Galilea te'eré nacú ricá pajimila. ");
INSERT INTO ycn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Rejo Tupana huacára'ari ricá María chaje. Inaya jo'ó María i'imacá rihuacajé. Uncá jo'ó ruhuá'acalo rihuacajé i'imacá. Napura'ó rinacu José hua'até, nahuá'acacoloje pajhua'atéchaca penaje. José i'imari Davidmi chu laquénami naquiyana. Júpimi que Davidmi chu i'imacá ne'emacana. ");
INSERT INTO ycn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","E caja Tupana hua'atéjeri, je'echú chiyaje, iphari María nacú. Rimá rojló: —Pajalácaje nu'ujichá majó. Palá huani Tupana pechu pinacu. Piñaté a'ajeri ricá. Palá huani caja Tupana la'ajica picá. Ajopana inaana chaje huani rila'acá picá palá —que rimacá Maríajlo. ");
INSERT INTO ycn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Marí que rimacá aú rojló rupechu i'imá: “¿Meque chi caji rimíchaca nacú nojló? ¿Naje chi rimicha nojló a'ajná que huani?” ");
INSERT INTO ycn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","E Tupana hua'atéjeri quemari piño rojló: —María, pihue'epíniya pijluhua, palá Tupana pechu pinacu. ");
INSERT INTO ycn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chuhuaca canupá pi'imajica, pi'irí i'imajeri achiñá. Eco pa'á rií Jesús. ");
INSERT INTO ycn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Palá huani rila'ajica íqui'iruna ina'uqué nacú. Nemaje rinacu: “Tupana I'irí ricá” que. “Ajopana chaje huani huacára'ajeri i'irí ricá”, que nemájica rinacu. Tupana a'ajeri ricá ne'emacana penaje, Davidmi chu i'imacá ne'emacana, que caja ri'imacáloje penaje. ");
INSERT INTO ycn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israelmi chu laquénami huacára'ajeri ri'imajica. Uncá ritajnálajo i'imajica, uncá rácho'olajo richiyá —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Eyá rumá rijló: —¿Meque ca'ajná pimíchaca nojló? Uncá jo'ó nu'umalá achiñá hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Rimá rojló: —Tupana Pechu i'imajeri pijhua'até. Ricá queñótajeri pi'irí pihuó chu. Marí caje aú pi'irí i'imajeri Tupana I'irí. ");
INSERT INTO ycn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ñaqué caja pe'ehueló Elizabet i'irí i'imajica. “Mehuacú rucá” que nemacá runacu i'imacá. E'iyonaja caja canupá rucá. Pajluhua cuhuá'ata queta queri cha rucá me'etení. Phíyu'uqueru huani rucá, e'iyonaja canupá rucá Tupana palamane. ");
INSERT INTO ycn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tupana hue'epiri piyuque huani nacaje la'acana —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","—Ñaqué ricá —que María quemacá rijló—. Pimíchaca que nojló queja ri'imajica nojló. Tupana huátaca que la'ajeyo nucá. Marí cajé aú Tupana hua'atéjeri, je'echú chiyaje, pa'aró piño je'echú chojé. ");
INSERT INTO ycn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","E caja María i'ijnayo tu'ujné ají que apú pajimila ejo. Judea te'eré nacú, yenuri e'iyohuá pajimila i'imacá, ejo ru'ujná. ");
INSERT INTO ycn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ruphá rejo, rumujlúca'a Zacarías ñacaré chojé. E rojalaca Elisabet. ");
INSERT INTO ycn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Raú ru'urí ñani cahuitari rohuó chu. Tupana Pechu i'imari rujhua'até cajrú i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Raú caphí rumacá Maríajlo: —Tupana la'arí picá palá. Ajopana inaana chaje huani rila'acá picá palá. Ñaqué caja rila'ajica pi'irí i'imajícare palá huani. ");
INSERT INTO ycn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nuhuacára'ajeri jaló penájeru picá. ¡Meque palá huani pili'ichaca nucá majó nuchaje i'ijnacana aú! ");
INSERT INTO ycn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pajaláquichaca nucá aú, nu'urí ñani cahuichíyari nohuó chu, pu'ují ripechu i'imichácale —que Elisabet quemacá Maríajlo. ");
INSERT INTO ycn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Rumá piño rojló: —Pa'acale pinacojó Tupana puráca'alo, rimacare pinacu i'imacá, pu'ují pipechu la'acó raú. Huahuacára'ajeri Tupana quemacá pinacu queja ri'imajica pijló. ");
INSERT INTO ycn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María quemayo rojló: —Pu'ují huani nupechu Tupana nacú, ");
INSERT INTO ycn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ri'imatájicale nucá capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Palá nupechu, rihue'epícale nucá. Majopéjaru queja nucá. Rijló sápajeyo nucá. Chuhua ina'uqué quemájica nunacu: “Meque palá huani Tupana la'acá rucá” que. ");
INSERT INTO ycn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Palá huani jo'ó Tupana la'acá nucá. Tupana hue'epiri piyuqueja nacaje la'acana palá. Palani huani ricá. Uncá meño'ojó rila'alá pu'uhuaré. ");
INSERT INTO ycn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Rihue'epí piyuque ra'apí iphájeño mu'ují ñaqueja. ");
INSERT INTO ycn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Piyuque huani la'ajeri ricá. Re ina'uqué naquiyana, íqui'i nala'acá necó hue'epiño que huani. Necá pechu rapichata, nala'acá piyá nahuátaca que —que rumacá—. ");
INSERT INTO ycn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nahuacára'ajeño huani rácho'otaje ne'emacana caje chiyá. Ajopana ja'apejé i'imajícaño rila'ajé palá. ");
INSERT INTO ycn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ña'ajeño me'epejí panácujlo ra'ajé nacaje palani. Cajrú le'ejepeláruna rihuacára'aje a'ajná ño'ojó majopeja. Uncá na i'imalaje nacapi. ");
INSERT INTO ycn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tupana le'ejena ina'uqué Israelmi chu laquénami. Necá ñaté ra'ajé, rihue'epícale namu'ují. ");
INSERT INTO ycn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tupana hue'epiri namu'ují rimacá que najló i'imacá. Uncá riyurila Abrahami chu mu'ují hue'epícana i'imacá. Ñaqué caja rihue'epíjica rilaquénami mu'ují piño —que María quemacá Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María yuriyo Elisabet hua'até hueji queta queri quetana. Quéchami rupa'acó piño ropumí chuhuá. ");
INSERT INTO ycn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","E caja Elisabet iphayo roná chojé, ru'urí moto'ocáloje penaje. Ejéchami caja ruhuá'a ru'urí. ");
INSERT INTO ycn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pu'ují nañacaré ahua'á i'imacaño, nejena, cajena pechu la'acó raú, Tupana la'acale palá huani rucá. Aú ne'ejná ruchaje ruyájlepana la'ajé. ");
INSERT INTO ycn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","E caja hueji que cuhuá'ata que cala i'imajemi rimoto'ocá ejomi ne'ejná queráco'ope chu'uhuere chinuma mata'ajé. Nahuata rií a'acana rara'apá ií que caja. ");
INSERT INTO ycn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","E'iyonaja raló quemayo najló: —Uncá hua'alaje rara'apá ií rií. Hua'ajé rií Juan. ");
INSERT INTO ycn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","E nemá rojló: —¿Naje chi pa'á rií Juan? Uncá pejena naquiyana ií i'imalá Juan —que nemacá rojló. ");
INSERT INTO ycn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ejéchami naca'acá nayáte'ela queráco'ope jara'apajlo, namácaloje naca ra'acá rií penaje. ");
INSERT INTO ycn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Raú riquejá'a naliyá papera, riyá'atacaloje najló rií richojé penaje. E caja riyá'ata najló: rií Juan. Aú ajopana pechu i'imá: “¿Meque chi ricá caje?” ");
INSERT INTO ycn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ejéchami Zacarías lená huicho'ocó, ripura'acóloje penaje. E palá huani ripura'acó Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Raú rahua'á ñacaré i'imacaño quero'oñó. Marí caje ejomi Juan moto'ocá yucuna jema'aró cajrú rehuá. Judea te'eré ehuájena, yenuri e'iyohuá i'imacaño, necá piyuqueja jema'añó caja riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Piyuque riyucuna jema'ajeño i'ijnataño napéchuhua rinacu cajrú. Nemá pajlocaca: “¿Méqueca penaje rimoto'ó quele queráco'ope?” Que nemacá rinacu, nahue'epícale Tupana a'ajica riñaté cajrú huani. ");
INSERT INTO ycn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tupana Pechu i'imari queráco'ope jara'apá, Zacarías hua'até cajrú. Tupana huacára'aca ripuráca'alo que ripura'acó. Aú marí que rimacá: ");
INSERT INTO ycn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Palani Tupana. Israelmi chu laquénami huacára'ajeri ricá. Rile'ejena ina'uqué caja huecá. Huachi'ináricana caja ricá. Chuhua ri'imatájica huecá capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ra'ajé huajló pajluhuaja ina'uqué hue'ematájeri penaje. Piyuque la'ajeri ri'imajica. Davidmi chu la'aqueri Tupana huátajica que. Rilaquemi ri'imajica. ");
INSERT INTO ycn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Riyucuna Tupana i'imaqueri ripuráca'alo ja'apátajeñomi chúnajlo júpimi que. ");
INSERT INTO ycn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Rimá najló huanacu marí que i'imacá: “Nu'umataje necá napinana liyá. Chapú péchuruna nanacu liyá hua'ató nu'umataje necá,” que rimacá huanacu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Rimá caja huachi'inami chuna nacú marí que i'imacá: “Nuhue'epeje imu'ují. Uncá mapéchuru calé nucá numacare ijló nacú. No'ojé iñaté,” que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Rimá caja hua'ajútami chu, Abrahami chujlo nacaje rila'ajícare nacú. ");
INSERT INTO ycn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Rijló rimá huanacu i'imacá, ri'imatácaloje huecá huapinana liyá penaje. Raú huala'ajé nacaje rijló. Uncá hue'emalaje quero'ocajo nacú raú. ");
INSERT INTO ycn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Marí que rila'ajica huecá palá, rihuátaca que la'acaño hue'emacáloje raú penaje. Palá la'ajeño hue'emajica raú, hue'emajica quetana. Marí que la'ajícaño hue'emajica palá raú, que Zacarías quemacá Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ejomi Zacarías quemari marí que ri'irí ñanijlo i'imacá: —Nu'urí ñani, picá i'imajeri Tupana puráca'alo ja'apátajeri penaje. Ajopana huacára'ajeño huacára'ajeri, Tupana. Ricá puráca'alo ja'apátajeri pi'imajé. Picá i'ijnajeri Huahuacára'ajeri huani tucumá riyucuna i'imajé ina'uquejlo, napala'atácaloje napéchuhua pu'uhuaré nala'acare liyá ripé penaje. ");
INSERT INTO ycn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Pi'imajé riyucuna ina'uquejlo, huahue'epícaloje Tupana amaco huachaje pu'uhuaré huala'acare, huamanaicho huala'acare liyá penaje. Marí caje aú hue'emacóloje capichácajo liyá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tupana huajhuena huani ina'uqué piyuqueja. Ñaquele rihue'epí huamu'ují. Ñaqué i'imacale huajé chuhuá hue'emajica maare eyá a'ajná ño'ojó. ");
INSERT INTO ycn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Uncá meño'ojó ina'uqué i'imatala necó capichácajo liyá. Chuhua nahue'epíjica re apú Ne'ematájeri penaje. Ricá caja la'ajeri huapechu palá, hue'emacáloje palá pajhua'atéchaca ripalamane aú penaje —que Zacarías quemacá Tupana Pechu ja'apiyá que. ");
INSERT INTO ycn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Eyá ricá queráco'ope tahuá'aro i'imacá. Ehuá riñapaca tahuá'acajo. Cajrú ripechu i'imacá rijluhua. Pu'uteni meñaru chuja ri'imaqué. Ehuá riphaca rená chojé i'imacá, ra'apátacaloje Tupana puráca'alo yucuna ajopana ina'uquejlo penaje. Quetánaja ri'imacá pu'uteni meñaru chu. ");
INSERT INTO ycn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jesús moto'ocá huacajé nahuacára'ajeri huani ií i'imari Augusto. Ricá huacára'ari ina'uqué lapa'atácana piyuqueja. ");
INSERT INTO ycn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Apú piño i'imari Siria te'eré eyájena huacára'ajeri i'imacá. Rií i'imari Cirenio. Ri'imacá nahuacára'ajeri huacajé naqueño'ó piyuque ina'uqué lapa'atácana. ");
INSERT INTO ycn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Raú pajluhuano que napa'acó nachi'inami chuna ñacajelami ejo, nayá'atacaloje neí papera chojé penaje. ");
INSERT INTO ycn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aú José jácho'oro pajimila Nazaret eyá. Galilea te'eré nacú Nazaret. Reyá ri'ijná ají que ya'ajnaje Judea te'eré ejo; iphari pajimila Belén ejo. Re ne'emacana, Davidmi chu, moto'orí i'imacá. Rilaquénami naquiyana José i'imacá. Ñaquele José i'ijnari Belén ejo i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José iphari rejo María, riyajalo penaje i'imacayo hua'até. Canupá ru'umacá i'ijnayo rijhua'até, nayá'atacaloje neí papera chojé penaje. ");
INSERT INTO ycn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belén e ne'emacá ee María iphayo roná chojé i'imacá, ruhuá'acaloje ru'urí penaje. ");
INSERT INTO ycn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Re ru'urí moto'orí. I'imari ru'urí, pamineco huani ri'imacá. E ropo'otá ricá ñani ritóca'aru aú. Ejomi roto'otá ricá pirajina a'ajné a'acuná chojé. Pirajina ñacarelana chuja nayuró, uncale napucuna i'imalá, nacamátacoloje pají chu penaje. ");
INSERT INTO ycn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén ahua'á ajopana i'imaño pu'uteni chu lapí. Ohuéjana hua'aphé i'imacaño ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","E mana'í chiyó pajluhuaja Tupana hua'atéjeri, je'echú chiyaje, ya'atacó najló. Hua'ató que cajrú camareji patacá nanacojé. Cajrú naquero'ocó raú. ");
INSERT INTO ycn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","E rimá najló: —Iquero'oniyo. Palani yucu nupháchiya majó ijló, piyuqueja ina'uqué pechu i'imacáloje pu'ují raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Huajé queráco'ope moto'ochaca Belén e. Davidmi chu ñacajelami ricá pajimila Belén. Ina'uqué huacára'ajeri huani penaje ricá moto'ochari huajé. Tupana huacári'ichari ricá majó ina'uqué i'imatájeri penaje. ");
INSERT INTO ycn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Marí que amájica ricá: Pirajina a'ajné a'acuná chu rito'ojó jepo'otácanami ritóca'aru aú. Pu'uhuacá amájica ricá marí que, ihue'epeje ricá numacare nacú ijló —que Tupana hua'atéjeri, je'echú chiyaje, quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Rejéchami caja cajrú ajopana Tupana hua'atéjena ya'atacó najló. Ají que je'echú chiyá nahuitúca'aca apú ahua'ajé. E palá huani napura'acó Tupana nacú. Nemá najló: ");
INSERT INTO ycn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Palani huani nacaje Tupana la'acare! Yenú, je'echú chu, ricá Tupana. Ina'uqué, marí eja'ahuá chu i'imacaño, pu'ují ripechu i'imacárena nacú, necá i'imajeño palá pajhua'atéchaca, que nemacá Tupana nacú najló. ");
INSERT INTO ycn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ejomi Tupana hua'atéjena pa'añó napumí chuhuá je'echú chojé. E caja ohuéjana hua'aphé i'imacaño quemaño pajlocaca: —I'ijná hue'ejnachi Belén ejo, huamíchajla méqueca ricá Huahuacára'ajeri quemíchaje nacú. —Je —que. ");
INSERT INTO ycn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aú ne'ejná peyajhué rejo, iphaño nanacu, amaño María, José, quele re. Namá caja queráco'ope ñani to'ocó pirajina a'ajné a'acuná chu. ");
INSERT INTO ycn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Namá ricá. Ejomi ne'emá queráco'ope yucuna najló Tupana hua'atéjeri, je'echú chiyaje, quemacá najló i'imacá que. ");
INSERT INTO ycn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Riyucuna jema'ajeño pechu nacú ri'imá: “¡Meque piyuque huani Tupana la'acá!” ");
INSERT INTO ycn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María pechu nacuja ri'imá nemácare nacú. ");
INSERT INTO ycn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","E caja ohuéjana hua'aphé i'imacaño pa'añó piño napumí chuhuá. Palá huani napura'acó Tupana nacú, namácale Tupana I'irí i'imacá. Tupana hua'atéjeri quemacá najló i'imacá queja caja namaca ri'imacá. Namá caja Tupana hua'atéjena, je'echú chiyájena. Aú napura'ó Tupana nacú palá. ");
INSERT INTO ycn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hueji que cuhuá'ata que cala ne'emacá queráco'ope moto'ocá ejomi namata'á richinuma. Na'á rií Jesús. Caja Tupana hua'atéjeri, je'echú chiyaje, quemari Maríajlo uncá chiyó rimoto'ó: “Eco pa'á rií Jesús” que. ");
INSERT INTO ycn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","E caja riphá rená chojé, José, riyajalo María, quele la'acáloje Moisesmi chu puráca'alomi quemacá que penaje, ne'emacáloje lamá'ataqueja Tupánajlo raú penaje. Aú ne'ejná Jerusalén ejo. Nahuá'a queráco'ope najhua'ató, na'acáloje Tupánajlo ricá re penaje. ");
INSERT INTO ycn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tupana puráca'alo lana'aquéjami quemari queráco'opena chi'iná nacú, na'acáloje Tupánajlo naqueráco'opetena, achiñana, pamineco moto'ocaño penaje, ne'emacáloje Tupánajlo penaje. Aú calé ne'ejná rejo marí que la'ajé. ");
INSERT INTO ycn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ne'ejná caja nacaje a'ajé Tupánajlo. Ripuráca'alo lana'aquéjami quemari caja huajé i'irí moto'ocaño chi'iná nacú, na'acáloje iyamá ucu'ucúrina, iyamá caja túcu'uchina hua'até Tupánajlo penaje. Marí que la'ajé penaje ne'ejná rejo. ");
INSERT INTO ycn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Re apú ina'uqué i'imari Jerusalén e. Rií i'imari Simeón. Palájne'eque huani ina'uqué ri'imacá. Palá caja ripechu i'imacá Tupana nacú. Rihue'epí Tupana huacára'ajica pajluhuaja ina'uqué, Israelmi chu laquénami i'imatájeri penaje. Ricá huátacana nacú ri'imaqué. Tupana Pechu i'imari Simeón hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Caja Tupana Pechu quemari rijló: —Pamaje ricá Tupana huacára'acare majó ina'uqué i'imatájeri penaje. Pitaca'ajica yámona pamaje ricá. ");
INSERT INTO ycn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","E caja Tupana Péchuja caja quemari rijló, ri'ijnacáloje Tupana ñacaré ejo penaje. Aú ri'ijná rejo. E riphá pajñacani Jesús chi'iná hua'até. Rejo ne'ejná i'imacá, nala'acáloje Tupana puráca'alo lana'aquéjami quemacá que penaje. ");
INSERT INTO ycn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ramaca queráco'ope aú Simeón huá'ari ricápojo ricá. E ripura'ó palá Tupana nacú. Marí que rimacá Tupánajlo: ");
INSERT INTO ycn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nuhuacára'ajeri huani, Tupana, chuhua nutaca'ajica mana'íja. Caja nomicha ricá pimacare nacú nojló. Pihuátaca que la'ajeri nucá. ");
INSERT INTO ycn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Caja nomicha ricá i'imatájeri ina'uqué capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Piyuque ina'uqué i'imatájeri penaje pa'acare ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Palá rila'ajícare aú ajopana ina'uqué, uncá judíona calé necá, hue'epéjeño mecajeca picá, Tupana. Palá caja napechu i'imajica huanaquiyana nacú, Israelmi chu laquénami nacú, huanaquiyana ri'imacale, i'imatájeri ina'uqué capichácajo liyá, que Simeón quemacá Tupánajlo. ");
INSERT INTO ycn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Marí que rimacá rinacu. Aú José, Jesús jaló, quele pechu i'imá: “¡Meque palá huani rimíchaca queráco'ope ñani nacú!” ");
INSERT INTO ycn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Eyá Simeón quemari Tupánajlo, rila'acáloje necá palá penaje. E rimá piño marí que Maríajlo: —Marí caje penaje ri'imajé, quele queráco'ope: Rinacojé cajrú Israelmi chu laquénami capichájico Tupana liyá, uncá pachá nema'alaje ra'apiyá. Richojeja caja íqui'iruna i'imajó capichácajo liyá. Rinacojé caja ina'uqué hue'epéjeño mecajeca Tupana. Cajrú caja ina'uqué uncá huátalajeño ricá. ");
INSERT INTO ycn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Pu'uhuaré huani napura'ajico rinacu. Raú iná hue'epí necá mecajenaca necá —que rimacá rojló—. Chapú nala'ajícare penaje ricá. Camu'ují huani pipechu la'ajico raú. Cajrú pihuajhué majáca'ajico raú —que Simeón quemacá rojló. ");
INSERT INTO ycn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Re caja apa'ahuelo inanaru i'imayo. Tupana puráca'alo ja'apátajeyo ru'umacá. Ruí i'imayo Ana. Fanuelmi chu ítumilomi ru'umacá. Aser runamana ií i'imacá. Caja phíyu'uqueru huani ru'umacá. Inaya jo'ó ru'umaqué huacajé ruhuá'aco i'imacá. Iyamá cuhuá'ata quele jarechí quetánaja ru'umacá ruyajnami chu hua'até i'imacá. Ejéchami ritajnáñaca ru'umacá. ");
INSERT INTO ycn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Caja ihuacajílomi ruyurico reyá. Caja ochenta y cuatro jarechí quetana ru'umacá ihuacajílomi rihuacajé. Uncá rócho'oloja Tupana ñacaré chiyá; ríchuja ru'umaqué hue'echú quetana, lapí quetana. Tupana nacuja rupechu i'imaqué; rijhua'até pura'acano nacú ru'umaqué; ro'ojné liyá i'itacano nacuja caja ru'umaqué. ");
INSERT INTO ycn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Rucá penájerumi ru'umacá, iphayo Jesús chi'iná nacú Tupana ñacaré chu. Pamineco rumá Tupánajlo: “Palá pila'acá huecá” que. Ejomi ru'umá rohua'á i'imacáñojlo queráco'ope Jesús yucuna. Necá huátaño Tupana huacára'aca apú ina'uqué, Jerusalén e i'imacaño i'imatájeri penaje. Necajlo ru'umá riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","E caja Jesús chi'iná ñapátaño rila'acana Tupana puráca'alo lana'aquéjami quemacá que. E nácho'o Jerusalén eyá. Napa'ó piño napumí chuhuá pajimila Nazaret ejo. Galilea te'eré nacú ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Re Jesús tahuá'aro i'imacá. Ehuá richaje, richaje que ripechu i'imacá rijlúhua. Cajrú ripechu i'imacá. Palá huani Tupana la'ajica ricá. ");
INSERT INTO ycn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","E caja fiesta iphari rená chojé. Fiesta ií i'imari Pascua. Aú Jesús chi'iná i'ijnaño Jerusalén ejo fiesta ja'apátaje ajopana ina'uqué hua'até. Jarechí queja ne'ejnajícano rejo ra'apátaje. ");
INSERT INTO ycn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iyamá iphata ji'imaji nacojé quele jarechí Jesús i'imacá rihuacajé. Ne'ejná rejo rijhua'até fiesta ja'apátaje richape. Re ne'emá meque cálaja. ");
INSERT INTO ycn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Fiesta tapúrenami napa'ó piño napumí chuhuá. Jesús yuriro Jerusalén e. Uncá richi'iná hue'epílaja riyurico re. ");
INSERT INTO ycn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Napechu i'imá: “Ajopana hua'até japi ricá.” Ají que na'apaca pajluhua cala quetana. Ejéchami namaca rapumí. Aú naqueño'ó riculácana nejena e'iyohuá, rijhuáque'ena e'iyohuá, quele. ");
INSERT INTO ycn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Uncá nephátala ricá. Raú napa'ó piño napumí chuhuá ají que Jerusalén ejo riculaje. ");
INSERT INTO ycn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Caja ehuaja hueji que cala la'acá nacú nephata ricá. Nephata ri'imacá Tupana ñacaré chu. Re riyá'o Tupana puráca'alo nacú jehuíña'atajeño hua'até. Napuráca'alo jema'acana nacú riyá'o nahua'á. Riquejá'a caja naliyá riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ajopana jema'añó Jesús quejá'aca riyucuna. Aú napechu i'imá rinacu: “¡Meque capechuni huani ricá! Palá riquejá'aca riyucuna, palá caja rapiyácaca necá,” que napechu i'imacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","E richi'iná amaño ricá najhua'até. Raú nejlú jeño'oró richaje. E raló ajalaca ricá, rumá rijló: —Nu'urí, ¿naje pila'á huecá ilé que? Caja huahuó qui'icharo para'apá hua'até piculácana nacú —que rumacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús quemari najló: —¿Na penaje iculá nucá? ¿Uncá chi ihue'epila maare nucá, nula'acáloje Nora'apá huani quemacá que penaje? —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Marí caje aú uncá nahue'epila meque quemacánaca ricá rimacare nacú najló. ");
INSERT INTO ycn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Raló pechu nacuja ri'imá. Aú caja ripa'ó najhua'até ají que Nazaret ejo. Palá rema'ajica richi'iná ja'apiyá. ");
INSERT INTO ycn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Palá ritahuá'aco. Ehuá richaje, richaje que ripechu i'imacá rijluhua i'imacá. Palá Tupana pechu i'imacá rinacu; ñaqué caja ina'uqué pechu i'imacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nahuacára'ajeri huani ií i'imari Tiberio. Caja pajluhua té'ela quele iphata ji'imaji nacojé quele cha jarechí ri'imacá nahuacára'ajeri rihuacajé. Rihuacajé caja Poncio Pilato i'imari Judea te'eré eyájena huacára'ajeri. Herodes i'imari Galilea te'eré eruna huacára'ajeri. Re'ehué, Felipe, i'imari Iturea te'eré eruna, Traconite te'eré eruna, quele huacára'ajeri. Lisanías i'imari Abilinia te'eré eyájena huacára'ajeri rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás, Caifás, quele i'imaño sacerdótena huacára'ajeño. Marí que ne'emacá rihuacajé. Ehuá pu'uteni meñaru chu Tupana a'arí Juanjlo ripuráca'alo, ra'apátacaloje ricá ina'uquejlo penaje. Zacaríasmi chu i'irimi Juan i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","E caja Juan i'ijnari ají que juni Jordán cha ñacajélarunajlo riyucuna i'imajé. Rimaqué najló: —Ipajno'otá ipéchuhua Tupana ejo pu'uhuaré ila'acare liyá, imanaicho ila'acare liyá. Raú Tupana amájero ichaje riliyá. Ipajno'otájica ee ipéchuhua, nula'ajé icá bautizar —que rimájica najló. ");
INSERT INTO ycn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Júpimi que Isaíasmi chu, Tupana puráca'alo ja'apátajeri ri'imacá, lana'arí riyucuna papera chojé marí que: Nema'ajé pajluhuaja ina'uqué jahuíyo'oca pu'uteni meñaru chu. Marí que rimájica ina'uquejlo: “Chuhua ipala'ataca ipéchuhua palá Huahuacára'ajerijlo. Ipajno'otá caja ipéchuhua pu'uhuaré ila'acare liyá. ");
INSERT INTO ycn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Piyuque ina'uqué, nahuacára'ajeño, ajopana hua'até pala'atájeño napéchuhua palá ripé. Piyuque pu'uhuaré ila'acare, imanaicho ila'acare hua'ató, iyurí iliyó ricá, i'imacáloje palá Tupánajlo raú penaje. Marí que ipala'atájica ipéchuhua ripé. ");
INSERT INTO ycn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tupana huacára'ajeri majó pajluhuaja, ri'imatácaloje ina'uqué capichácajo liyá penaje. Piyuque ina'uqué jema'ajeño riyucuna”, que Isaíasmi chu lana'acá riyucuna papera chojé i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","E caja cajrú ina'uqué i'ijnacá Juan ejo, rila'acáloje necá bautizar penaje. Ne'iyajena uncá yurílaño pu'uhuaré la'acana naliyó, i'ijnaño caja najhua'até, rila'acáloje necá bautizar penaje. Nephá rinacu. E rimá najló: —Pajlácachina ta icá. Iqui'i huani Tupana huajájica pu'uhuaré la'acaño. ¿Na quemari ijló, i'imacóloje riliyá penaje?” ");
INSERT INTO ycn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ila'á palá, iná hue'epícaloje raú caja iyurica iliyó pu'uhuaré ila'acare penaje. Imaniya caja inacuhuá: “Abrahami chu laquénami huecá. Ñaquele lamá'ataqueja huecá Tupánajlo.” Uncá ñaqué calé ricá ijló. Uncá Tupana i'imatálaje icá capichácaje liyá raú. Tupana huátaquela, rehuíña'atajla marí jipa, ri'imacáloje Abrahami chu laquénami penaje. ");
INSERT INTO ycn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Iná la'á iná peruné iré, iná i'icatácaloje paijí mecharú iná mená e'iyayá penaje. Rimacára'aco ejomi iná cára'ata ricá piyuqueja ra'apare. Ñaqué caja Tupana huajájica ina'uqué naquiyana. Rihuajaje namanaicho la'ajeño, pu'uhuaré la'ajeño, cajena rihuajaje marí que. ");
INSERT INTO ycn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Raú ina'uqué quemaño Juanjlo: —Eta, ¿Meque huala'acajla, hue'emacáloje lamá'ataqueja que Tupánajlo raú penaje? ");
INSERT INTO ycn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Rimá najló: —Marí que ila'ajica: Iyamá icamichare i'imajica ee, a'á uncá camichare i'imalájejlo apú. Ca'ajneruna i'imajica ee, a'á uncá a'ajnejí i'imalájejlo ile'ejé naquiyana —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","E caja liñeru ña'ajeño ne'emacánajlo i'ijnaño caja Juan ejo. Ne'ejná rejo, rila'acáloje bautizar necá penaje. Nephaca rinacu ee nemá rijló: —Huehuíña'atajeri, ¿Meque huala'ajica, hue'emacáloje lamá'ataqueja que Tupánajlo penaje? ");
INSERT INTO ycn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Rimá najló: —Ica'aniya ina'uqué liyá cajrú liñeru. Ilé ihuacára'ajeri quemacá ijló ejé ijña'á naliyá ricá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Surárana naquiyana quemaño caja rijló: —¡Eta huecá! ¿Meque huala'ajica? Rimá najló: —Ila'aniya chapú ajopana, ijña'acáloje naliyá nacaje ijluhua penaje. Imaniya caja majopeja nanacu: “Pu'uhuaré nala'acá” que, na'acáloje ijló liñeru, multa huemí raú penaje. Ipechu i'imá palá liñeru hua'até na'acare ijló isápaca'ala huemí penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Uncá nahue'epila palá na penájeca Juan i'imacá. Napechu i'imá rinacu: “Apala ricá ca'ajná Tupana huacára'acare majó ina'uqué i'imatájeri penaje.” E Juan quemari najló: ");
INSERT INTO ycn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","—Nucá la'arí bautizar ina'uqué juni aú, napajno'otácale napéchuhua Tupana ejo, pu'uhuaré nala'acare liyá. Raú ajopana ina'uqué hue'epiño mecajenaca necá. Ricá penaje nula'á bautizar necá. Nopumí chojé apú iphájeri. Iqui'i huani nuphaca ja'apí ricá, nuchaje huani ri'imacale. Ricá a'ajeri ina'uquejlo Tupana Pechu, naca'acáloje pu'uhuaré nala'acare naliyó raú penaje. Ricaja caja huajájeri ina'uqué, pu'uhuaré la'ajeño, namanaicho la'ajeño, eja'ahuá tajnájico huacajé. ");
INSERT INTO ycn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nopumí chojé iphájica la'ajeri trigo a'arú ca'ajeño la'acá que caja. Te'erí ichajona caje aú nácho'ota ricá, carená apho'ocáloje ra'arú re'iyayá penaje. Quéchami paminá lamá'ataca riñacarelana chojé richa. Ra'arumi ricupá quera'atani uncá yacálare chojé. Marí que caja nopumí chojé iphájica huajájica ina'uqué e'iyohuá. Palá la'ajeño i'imajeño rijhua'até. Eyá pu'uhuaré la'ajeño, namanaicho la'ajeño, rica'ajé quera'atani uncá yacálare chojé —que Juan quemacá najló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Marí que Juan i'imajica najló Tupana i'imataca ina'uqué capichácajo liyá yucuna. Cajrú ripuráca'alo yucuna ri'imajica najló. ");
INSERT INTO ycn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Re'iyohuá queja Juan aca'acá ne'emacana, Herodes, rica'acale rijmeremi liyá riyajalo. Herodías ruí i'imacá. Rochona Juan aca'arí ri'imacá. Apú rimanaicho rila'acare chona, pu'uhuaré rila'acare chona hua'até raca'á ricá. ");
INSERT INTO ycn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","E'iyonaja uncá Herodes a'alá rinacojó ricá. Caja ehuaja rica'á Juan ina'uqué huajáquelana chojé. Marí que rila'acana aú rila'á rijluhua nacaje cajrú huani. ");
INSERT INTO ycn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Uncá chiyó naca'á Juan ina'uqué huajáquelana chojé, rila'aqué bautizar cajrú ina'uqué. Jesús hua'ató rila'á bautizar. Jesús iphari rinacu i'imacá, rila'acáloje ricá bautizar penaje. E Jesús pura'aró Tupana hua'até. Ejéchami je'echú je'echataco. ");
INSERT INTO ycn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ricá chiyá Tupana Pechu huitúca'ari ají que majó. Túcu'uchi huitúca'aca que rihuitúca'aca Jesús nacojé. Túcu'uchi que ramácano i'imacá. E Tupana quemari marí que Jesusjlo je'echú chiyá: —Picá Nu'urí, íqui'ija nuhuátacare, pu'ují huani nupechu pinacu —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús queño'ocá rara'apá puráca'alo ja'apátacana huacajé ri'imá treinta jarechí ca'ajná. Ina'uqué quemaqueño rinacu: “José i'irí ricá” que, rilamára'acale ri'imacá. José i'imari Elimi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elimi chu i'imarí Matatmi chu i'irimi. Matatmi chu i'imari Levimi chu i'irimi. Levimi chu i'imari Mélquimi chu i'irimi Mélquimi chu i'imari Jánami chu i'irimi. Jánami chu i'imari Josemi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josemi chu i'imari Matatíasmi chu i'irimi. Matatíasmi chu i'imari Amosmi chu i'irimi. Amosmi chu i'imari Nahumi chu i'irimi. Nahumi chu i'imari Eslimi chu i'irimi. Eslimi chu i'imari Nagaimi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaimi chu i'imari Maatmi chu i'irimi. Maatmi chu i'imari Matatíasmi chu i'irimi. Matatíasmi chu i'imari Semeimi chu i'irimi. Semeimi chu i'imari Josemi chu i'irimi. Josemi chu i'imari Judami chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judami chu i'imari Joanami chu i'irimi. Joanami chu i'imari Résami chu i'irimi. Résami chu i'imari Zarobabelmi chu i'irimi. Zarobabelmi chu i'imari Salatielmi chu i'irimi. Salatielmi chu i'imari Nérimi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérimi chu i'imari Mélquimi chu i'irimi. Mélquimi chu i'imari Adimi chu i'irimi. Adimi chu i'imari Cosami chu i'irimi. Cosami chu i'imari Elmodami chu i'irimi. Elmodami chu i'imari Ermi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ermi chu i'imari Josuémi chu i'irimi. Josuémi chu i'imari Eliezermi chu i'irimi. Eliezermi chu i'imari Jorimi chu i'irimi. Jorimi chu i'imari Matatmi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatmi chu i'imari Levimi chu i'irimi. Levimi chu i'imari Simeónmi chu i'irimi. Simeónmi chu i'imari Judami chu i'irimi. Judami chu i'imari Josemi chu i'irimi. Josemi chu i'imari Jonanmi chu i'irimi. Jonanmi chu i'imari Eliaquimi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimi chu i'imari Meleami chu i'irimi. Meleami chu i'imari Mainanmi chu i'irimi. Mainanmi chu i'imari Matátami chu i'irimi. Matátami chu i'imari Natanmi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natanmi chu i'imari Davidmi chu i'irimi. Davidmi chu i'imari Isaími chu i'irimi. Isaími chu i'imari Obedmi chu i'irimi. Obedmi chu i'imari Boozmi chu i'irimi. Boozmi chu i'imari Salmonmi chu i'irimi. Salmonmi chu i'imari Naasonmi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasonmi chu i'imari Aminadabmi chu i'irimi. Aminadabmi chu i'imari Admin chu i'irimi. Admin chu i'imari Esromi chu i'irimi. Esromi chu i'imari Faresmi chu i'irimi. Faresmi chu i'imari Judami chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judami chu i'imari Jacobmi chu i'irimi. Jacobmi chu i'imari Isaacmi chu i'irimi. Isaacmi chu i'imari Abrahami chu i'irimi. Abrahami chu i'imari Taremi chu i'irimi. Taremi chu i'imari Nacormi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacormi chu i'imari Serugmi chu i'irimi. Serugmi chu i'imari Ragaumi chu i'irimi. Ragaumi chu i'imari Pelegmi chu i'irimi. Pelegmi chu i'imari Hebermi chu i'irimi. Hebermi chu i'imari Salami chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salami chu i'imari Cainánmi chu i'irimi. Cainánmi chu i'imari Arfasadmi chu i'irimi. Arfasadmi chu i'imari Semi chu i'irimi. Semi chu i'imari Noémi chu i'irimi. Noémi chu i'imari Lamecmi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecmi chu i'imari Matusalenmi chu i'irimi. Matusalenmi chu i'imari Enocmi chu i'irimi. Enocmi chu i'imari Jaredmi chu i'irimi. Jaredmi chu i'imari Mahalaleelmi chu i'irimi. Mahalaleelmi chu i'imari Cainánmi chu i'irimi. ");
INSERT INTO ycn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainánmi chu i'imari Enosmi chu i'irimi. Enosmi chu i'imari Setmi chu i'irimi. Setmi chu i'imari Adanmi chu i'irimi. Tupana queño'ótacare Adanmi chu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Caja Juan la'arí bautizar Jesús juni Jordán acojé i'imacá. Reyá ra'apá ají que a'ajná ño'ojó. Caja Tupana Pechu ja'apiyá Jesús i'imacá. Ricá huacára'ari ricá ají que a'ajná ño'ojó pu'uteni meñaru chojé. ");
INSERT INTO ycn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Re ri'imá iyamá ina'uqué le'ejé que cala quetana. Marí quetana uncá rajñala ra'ajnehuá. Caja quehuí rijló me'epejí i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ejéchami Jiñá Chi'ináricana iphaca Jesús nacú. Rihuata re'iyajé ca'átacana, rila'acáloje pu'uhuaré raú penaje. E rimá rijló: —¿Quehuaca chi Tupana I'irí picá? Nuhue'epícaloje ñaqué picá penaje, pihuacára'a marí jipa jehuíña'aco a'ajnejí penaje. ");
INSERT INTO ycn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Uncá Jesús jema'alá ra'apiyá. Rimá rijló: —Marí que Tupana puráca'alo lana'aquéjami quemacá: “Uncá a'ajnejí aú ja calé iná i'imá. Piyuqueja Tupana puráca'alo ja'apiyá jema'acana aú iná i'imá —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","E Jiñá Chi'ináricana huá'ari piño ricá ipuré i'ihuátaje. Yenoje huani ri'imacá. Reyá riya'atá rijló ajopana te'eré, ajopana te'eré que. Piyuque marí eja'ahuá chu i'imacaño ñacajela riya'atá rijló richuhuaja ipuré i'ihuátaya. ");
INSERT INTO ycn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Reyá i'imajemi rimá Jesusjlo: —No'ojé pijló piyuqueja ina'uqué te'eré, pi'imacáloje ne'emacana penaje. Reyá caja piyuque nacaje yuréjero pijló marí eja'ahuá chu i'imacare. Nojló a'acanami ri'imacale, no'ó ricá nuhuátacarenajlo. ");
INSERT INTO ycn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Piphájica ee no'opí, pitára'o ee pi'irúpachi aú nujimaje. E no'ojé pijló nate'eré piyuqueja —que Jiñá Chi'ináricana quemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Raú Jesús quemari rijló: —Tupana puráca'alo lana'aquéjami quemari marí que: “Piphá Tupana ja'apija. Iná huacára'ajeri huani ricá. Ricá ja'apiyaja calé iná jema'á palá”, que Tupana puráca'alo lana'aquéjami quemacá —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Quéchami Jiñá Chi'ináricana huá'aca piño ricá Jerusalén ejo. Re rihuá'a ricá Tupana ñacaré i'ihuátaje yenoje. Re rimá rijló: —Tupana I'irí pi'imajica ee, peño'ó maáreya cahuacaje te'erí e'iyajé. ");
INSERT INTO ycn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pu'uhuacá Tupana I'irí pi'imajica ee, uncá meque pila'alajo. Marí que Tupana puráca'alo lana'aquéjami quemacá rinacu: Tupana huacára'ari rijhua'atéjena, je'echú chiyájena, a'acá nanacojó iná. ");
INSERT INTO ycn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Necá patañó iná ja'apí, iná la'acó piyá quehuí jipa nacojé ja'acano aú, que ripuráca'alo lana'aquéjami quemacá rinacu —que Jiñá Chi'ináricana quemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Raú Jesús quemari rijló: —Apa'amá caja Tupana puráca'alo lana'aquéjami quemari marí que: “Pila'aniya pimanaicho, pamachi méqueca Pihuacára'ajeri Tupana a'acá piñaté raú”. ");
INSERT INTO ycn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jiñá Chi'ináricana amárijla Jesús, rica'átacaloje re'iyajé penaje. E'iyonaja uncá rema'alá ra'apiyá. Aú ra'apá riliyá mequetánaja. ");
INSERT INTO ycn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","E caja Jesús pa'aró piño Galilea te'eré ejo. Tupana Pechu quemájica que rila'ajica nacaje. Rehuíña'ataque ina'uqué Tupana nacú nahuacáca'alo ñacarelana chu. Apalá chojé, apalá chojé que rehuíña'atajica necá rehuá. Piyuque ina'uqué rehuá i'imajícaño pura'aqueño rinacu palá. Cajrú riyucuna jema'acó piyuque nate'eré ehuá. ");
INSERT INTO ycn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","E Jesús i'ijnari Nazaret ejo. Re ritahuá'o i'imacá. E huatána'acaje huacajé ri'ijná piño richape nahuacáca'alo ñacarelana chojé. E ritára'o, ripura'acóloje Tupana puráca'alo lana'aquéjami hua'até najló penaje. ");
INSERT INTO ycn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na'á rijló Tupana puráca'alo lana'aquéjami, Isaíasmi chu lana'acare i'imacá. Tupana puráca'alo ja'apátajeri Isaíasmi chu i'imacá. E rijme'etá papera, iphátari puráca'aloji ricá chu quemari marí que: ");
INSERT INTO ycn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nujhua'até Tupana Pechu. Tupana a'arí nojló ricá, nu'umacáloje palani yucu uncá hue'epílaño Tupana nacojejlo penaje. Uncá huani nahue'epila ricá. Rihuacára'a caja nucá, nupala'atácaloje camu'ují péchurunajlo napechu penaje. Tupana jácho'otari ina'uqué pu'uhuaré la'acana chiyá. Rihuacára'a caja nucá riyucuna i'imajé najló. Rihuacára'a caja nucá, no'opátacaloje mejluruna liyá mejlucaji penaje. Rihuacára'a caja nucá, nu'umatácaloje ina'uqué chapú nala'ajeño liyá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Rihuacára'a caja nucá, nu'umacáloje ina'uquejlo palá Tupana la'ajícare necá yucuna penaje, que ripuráca'alo lana'aquéjami quemacá, ripura'acaro hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Riñapátacaja rijhua'até pura'acano ee Jesús itari papera. Ra'á nahuacáca'alo ñacarelana chiyá sápajerijlo ricá. Ejomi riyá'o. Piyuque nahuacáca'alo ñacarelana chu i'imacaño yacá'año richaje. ");
INSERT INTO ycn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Raú ri'imá riyucuna najló, rimá najló: —Chuhua Tupana puráca'alo lana'aquéjami, huajé nupuri'ichajo hua'até, iphíchari rená chojé, ñaqué ri'imacáloje penaje. Rimacá que ri'imajica e'iyohuá chuhuaca —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Palá huani napechu i'imacá Jesús nacú; palá caja napechu i'imacá ripuráca'alo nacú. Ne'iyajena quemaño pajlocaca: —¿Uncá chi José i'irí calé ricá? ");
INSERT INTO ycn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","E Jesús quemari najló: —Imaje ca'ajná nojló, nula'acáloje ijló nacaje penaje. Apú a'acáloje rená que'ená ijló penaje, imá rijló: “Pusána'ajeri picá. Eco pitejmo'óta picó”, que imacá apujlo maárohua. Ñaqué ca'ajná imaje nojló. Imaje nojló ca'ajná marí que: “Caja huema'á riyucuna, nacaje pila'acare pajimila Capernaum e pi'imaqué huacajé. Chuhua pila'á maare pite'eré nacú piño ñaqué caja, que ca'ajná imájica nojló” —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Rimá piño najló: —Jema'á marí: Ina'uqué iphaño Tupana puráca'alo ja'apátajeri ja'apí. Eyá rite'eré eruna uncá iphálaño ra'apí. ");
INSERT INTO ycn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Elíasmi chu i'imacá Tupana puráca'alo ja'apátajeri huacajé, cajrú Israelmi chu laquénami naquiyana, inaana, i'imaño ihuacajílomina. Rihuacajé uncá juni ja'aló hueji quele jarechí, eyá apú pe'iyojé quetana. Raú cajrú huate'eré ehuá i'imajícañomi chuna ña'ajica me'epejí panacu. ");
INSERT INTO ycn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Uncá Tupana huacára'ala Elíasmi chu ihuacajílomina ñaté a'acana, huate'eré e i'imacaño. Rihuacára'a ricá apa'ahuelo ejo, rimacápo'ocaloje rojló ru'urí penaje. Ajopana naquiyana ru'umacá. Pajimila Sarepta e ruñacaré i'imacá. Sidón ahua'á ricá pajimila. ");
INSERT INTO ycn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eyá apú i'imari piño. Tupana puráca'alo ja'apátajeri ri'imacá. Rií i'imari Eliseo. Ñaqué caja cajrú natámina i'imacá Israel te'eré ehuá rihuacajé. Nanapona naquiyá patáca'ataro najló, nacú ne'emaqué natámina. Uncá Eliseo tejmo'ótala ne'emacá. Ricaja calé, Naamanmi chu, ritejmo'óta i'imacá. Ajopana te'eré, Siria eyaje ri'imacá. Ricaja calé i'imaró ritami caje liyá —que Jesús i'imacá riyucuna najló, nahue'epícaloje raú uncá nañaté a'acana i'imalaje najló penaje. ");
INSERT INTO ycn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Marí que rimacá aú piyuque nahuacáca'alo ñacarelana chujena yúcha'año richá raú. ");
INSERT INTO ycn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","A'acuhuaná nácho'o Jesús pataje. Yenuri ja'apí pajimila i'imari i'imacá. Napatá ricá. E nachíra'a ricá ají que pajimila yámojo yenuri i'ihuátaje, naca'acáloje ricá ají que cahuacaje ri'ihuátaya penaje. ");
INSERT INTO ycn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","E'iyonaja Jesús ja'apáñari necá ne'iyayá. Rejomi ri'ijná reyá. ");
INSERT INTO ycn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús ja'apari reyá, ri'ijná ají que pajimila Capernaum ejo. Galilea te'eré nacú ricá pajimila. Re rehuíña'ata ina'uqué Tupana nacú huatána'acaje huacajé. ");
INSERT INTO ycn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","“Meque palá huani rehuíña'ataca huecá. Palá huani rihue'epica rinacojé,” que napechu i'imacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Re caja nahuacáca'alo ñacarelana chu apú i'imari najhua'até. Jiñá pechu i'imari re'iyá. E rahuíyo'o. ");
INSERT INTO ycn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Rimá Jesusjlo: —Jesús, Nazaret eyaje, ¿naje picahuíla'a huanacu? ¿E piphaca majó huacapichátaje? Nomána'apa caja picá. Ilé uncá la'alá pu'uhuaré picá. Tupana i'imacá e eyaje caja picá —que jiñá pechu i'imacare re'iyá quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","—Pimanúma'o, pácho'o ilé ina'uqué e'iyayá —que Jesús quemacá rijló. Ejéchami jiñá pechu ca'acá ilé ina'uqué cahuacá te'erí e'iyajé najimaje. Hua'ató rácho'o re'iyayá. Uncá rila'alá ina'uqué chapú re'iyayá jácho'ocano aú. ");
INSERT INTO ycn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","“¡Meque piyuque huani rila'alaca cari!” que ramájeño pechu i'imacá Jesús nacú. Nemá pajlocaca: —¡Meque palá huani ripuráca'alo! Raú ja calé jiñana pechu jácho'oro ina'uqué e'iyayá —que nemacá pajlocaca. ");
INSERT INTO ycn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Marí que rila'acá ejomi cajrú Jesús yucuna jema'acó rehuá. ");
INSERT INTO ycn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","E caja Jesús jácho'oro nahuacáca'alo ñacarelana chiyá. I'ijnari ají que Simón Pedro ñacaré ejo. Re Simón Pedro yajneru i'imayo rutami jelo'ocajo nacú. E nemá Jesusjlo: —Rutami rucá. ");
INSERT INTO ycn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Raú ri'ijná rohua'ajé tára'ajo. Rihuacára'a jelo'ocajo ja'apaca ruliyá. Raú ja calé rimata'á ruliyá. Ejéchami rócho'oco, rutamáca'atacaloje najló a'ajnejí penaje. ");
INSERT INTO ycn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","E caja najúhua'a re. Camú ja'acó ee, nahuá'a piyuque natámina Jesús ejo. Que'iyapejé nayaripune i'imacá nanacu. Jesús to'otari nanacojé riyáte'ela apú nacojé, apú nacojé que. Raú piyuqueja necá tejmo'otaño. ");
INSERT INTO ycn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ne'iyajena e'iyá jiñana pechu i'imá. Necá caja rica'á ne'iyayá. Raú nahuíyo'o, nemá rijló: —Tupana I'irí picá. Jesús quemari najló, ne'emacá piyá riyucuna. Uncá riyurila napura'acó, nahue'epícale Tupana huacára'acare ri'imacá, ina'uqué i'imatájeri penaje. ");
INSERT INTO ycn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","E muní que lapiyami Jesús i'ijnari ají que pajimila yámojo, ri'imacáloje ricoja re penaje. E'iyonaja naculá ricá. Caja ehuaja nephata ricá, nemá rijló: —Pi'ijnañáaniya huecá, maáreja piyuró huajhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús quemari najló: —Tupana i'imatari ina'uqué capichácajo liyá, ne'emacáloje rijhua'atéjena raú penaje. Palani riyucuna. Nu'ujnajé apú pajimila nacojé, apú pajimila nacojé que riyucuna i'imajé najló. Ricá penaje Tupana huacára'ari nucá majó —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","E ra'apá ají que Galilea te'eré e'iyohuá. Nahuacáca'alo ñacarelana chojé, apalá chojé, apalá chojé que ri'ijnajica Tupana yucuna i'imacana nacú najló. ");
INSERT INTO ycn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Apú huacajé piño Jesús i'imari caesa turená e. Genesaret e ricá caesa. E caja ina'uqué jahuacaño rejé cajrú Tupana puráca'alo jema'ajé. Raú cajrú nachipúca'aca Jesús nacojé. ");
INSERT INTO ycn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","E Jesús amari iyáma'acu jita cúhua'aco caesa acú, que'epé nacú. Meñaru richiyá i'imacá. Caja jiña ña'ajeño jácho'oño, nepácaloje nahuenare e'iyayá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","E caja Jesús huitúca'ari pajlúhua'acu jita chojé. Pedro jitane ri'imacá. E riyá'o richu. E rimá rijló: —Para'á ricá pe'iyojó quemachi. —Je. Ñaquele richiyá i'imajemi rehuíña'ata ina'uqué Tupana puráca'alo nacú. ");
INSERT INTO ycn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Riñapata nehuíña'atacana ejomi rimá Pédrojlo: —Chuhua pa'apata pitane juniphuni loco'opani. Reyá i'imajemi ica'ajé ihuenare juniphuni chojé pijhuáque'ena hua'até, ijña'acáloje jíñana richojé penaje —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aú Pedro quemari rijló: —Huehuíña'atajeri, caja huajme'echiya huahuenare ca'acana nacú. Uncá huani ta huajña'alacha. Pihuacári'ichacale rica'acana, nuca'ajica piño ricá junápeje —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","E caja Pedro, rijhuáque'ena, quele ña'añó ritane ají que rimacá rijló ejo. Reyá naca'á nahuenare junápeje. Ejéchami cajrú huani jíñana ja'acó richojé. Jíñana ja'apiyá nahuenare queño'orí mata'atácajo. ");
INSERT INTO ycn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Najhuáque'ena i'imaño apa'acú jita chu. E naca'á nayáte'ela najló, ne'ejnacáloje nañaté a'ajé penaje. Aú ne'ejná rejo, nácho'otacaloje jíñana najhua'até penaje. Nephá nanacu, chíra'año jíñana najhua'até majó jita chojé. Namano'otá iyáma'acu jita ñópo'ojlo jíñana aú. Ujú caje chiyó iyáma'acu netane ja'acojla na'apiyá junápeje. Jíñana cachicha ca'arijla netane na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón Pedro amari cajrú huani jíñana tami yá'aco jita chu. Marí caje aú ritára'o ri'irúpachi aú Jesús jimaje, piyuqueja hue'epica nacaje la'acana ri'imacale. E rimá rijló: —Pa'apá nuliyá, uncá ina'uquélari nu'umacale. ");
INSERT INTO ycn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pedro quero'oró ramaca aú cajrú jíñana. Ñaqué caja rijhuáque'ena quero'ocó rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Santiago, Juan, quele quero'oñó caja rijhua'até ñaqué caja. Simón Pedro huáque'ena ne'emacá, Zebedeo yaní. Nara'apá ií i'imari Zebedeo. Pedro quero'ocó aú Jesús quemari rijló: —Piquero'oniyo, marí eyá a'ajná ño'ojó ñaqué pihuá'ajica nojló ina'uqué, ne'emacáloje nujhua'atéjena penaje —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ejomi nachíra'a netane pe'iyojó, juni turenajo. Ejomi ne'ejná Jesús hua'até. Reja na'apaña piyuqueja nanane. ");
INSERT INTO ycn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús i'imacá pajimila e huacajé apú iphari rinacu. Ritami ri'imacá, napona patáca'ataro ri'imacá. Ramaca aú Jesús, ritára'o ri'irúpachi aú rijimaje. Racúhua'ata rihuíla'aru ají que te'erí jimaje. E rimá rijló: —Hue'emacana, pihuátajica ee, pa'apata nuliyá nuyaripune. ");
INSERT INTO ycn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Raú Jesús sápari rinacu riyáte'ela aú. Rimá rijló: —Je. Nuhuata ra'apátacana pijló. Caja ripali'ichó pijló chuhua. Marí que rimacá rijló, hua'até que rinapona pala'acó rijló. ");
INSERT INTO ycn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","—Pi'imaniya nuyucuna ajopánajlo —que Jesús quemacá rijló—. Chuhua pi'ijná sacerdote chaje, ramíchachi picá. Quéchami pa'ajica Tupánajlo nacaje, pinapona pali'ichácole. Moisesmi chu puráca'alomi lana'aquéjami quemacá que pa'ajica Tupánajlo nacaje. Marí caje aú ina'uqué hue'epéjeño caja pinapona pala'acó —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Je. Raú ri'ijná sacerdote ejo. Ejéchami cajrú ina'uqué jema'acá riyucuna. Raú calé cajrú huani ina'uqué i'ijnacá Jesús puráca'alo jema'ajé. Ajopana piño i'ijnaño richaje, rica'acáloje nayaripune nanaquiyá ñaqué caja penaje. Caja queja la'acana nacú ri'imajica. Cajrú nephájica rinacu i'imajica. ");
INSERT INTO ycn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ñaquele Jesús i'ijnañáaqueri necá mequetánaja. Ri'ijnaqué meñaru chojé Tupana hua'até pura'ajó. ");
INSERT INTO ycn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Apú huacajé piño Jesús jehuíña'atari cajrú ina'uqué Tupana nacú. Najhua'até fariséona naquiyana yá'año Tupana puráca'alo nacú jehuíña'atajeño hua'até. Apú pajimila eyájena, apú pajimila eyájena que ne'emacá. Ne'iyajena i'imaño Galilea te'eré eyájena; ajopana i'imaño Judea te'eré eyájena; ajopana i'imaño Jerusalén eyájena. Quele i'imaño Jesús jehuíña'atacarena hua'até. Tupana palamane aú Jesús tejmo'ótaqueri cajrú natámina. ");
INSERT INTO ycn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","E caja ajopana piño iphaño rejo. Achiñana huánija ne'emacá. Necá huáco'oño cuhuana nacú pajluhuaja ritami rejo. Camachá rinapona taca'acá i'imacá. Nahuata rijña'acana pají chojé, nato'otácaloje ricá Jesús ji'imá nacojé penaje, ritejmo'ótacaloje ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","E'iyonaja uncá mere eyaca calé namujlúca'atajla ricá pají chojé. Caja namano'otá pají Jesús i'imacare chu. Aú ne'ejrá pají i'ihuátaje. Pu'ucuja to'otácanami nañacaré i'ihuata i'imacá rehuá. Ricá i'ihuátaje ne'ejrá. Reyá najiyo'otá ri'ihuata. Ricá chiyá nahuitúca'ata ritami ina'uqué e'iyajé Jesús ahua'ajé. ");
INSERT INTO ycn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús hue'epiri caphí napechu i'imacá richojé, ritejmo'ótacaloje ritami penaje. Raú rimá ritámijlo: —Caja nomicho pichaje, pu'uhuaré pila'acare liyá. ");
INSERT INTO ycn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Marí que rimacá aú Tupana puráca'alo nacú jehuíña'atajeño, Fariséona, quele pechu i'imá: “¿Nata quele pura'aró pu'uhuaré huani Tupana nacú? Uncá na calé amaro iná chaje pu'uhuaré iná la'acare liyá. Ricaja cale, Tupana, amaro iná chaje pu'uhuaré iná la'acare liyá. Uncá Tupana calé ricá,” que napechu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús hue'epiri méqueca napechu i'imacá rinacu. Aú rimá najló: —¿Naje chi i'ijnataca ilé que ipéchuhua? ");
INSERT INTO ycn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Majopeja iná quemacajla apujlo: “Caja nomicho pichaje, pu'uhuaré pila'acare liyá”. Eyá puhuichani inajlo ricá, iná huacára'acaloje ritami jácho'oco, ra'apácaloje penaje. Tupánaja calé hue'epiri natámina tejmo'ótacana —que rimacá najló—. ");
INSERT INTO ycn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ina'uquéjloje penaje i'imacá nucá. Tupana quemari nunacu, nomácoloje ina'uqué chaje, pu'uhuaré nala'acare liyá penaje. Me'etení nula'ajícare aú ihue'epeje ñaqué jo'ó nojló ricá —que rimacá najló. E rimá camachá napona taca'acajlo: —Chuhua pácho'o. Pa'apá. Pijña'á picamané pijhua'ató, pipa'achó. ");
INSERT INTO ycn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ejéchami pila pila que rácho'oco nejlú chuhuá. Rijña'á rijhua'ató ricamané, rito'ocaro chu i'imacá. E ripa'ó ají que riñacaré ejo. Palá ripura'acó Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rácho'oco aú ramájeño pechu i'imá Jesús nacú: “¡Meque piyuque huani rila'alaca cari!” Nemá pajlocaca: —¡Meque palá huani huamíchaca rila'acá quele! ");
INSERT INTO ycn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","E caja Jesús ja'apari piño a'ajná ño'ojó. Amari pajluhuaja ina'uqué yá'aco risápaca'ala la'acana nacú. Mateo rií i'imacá. Liñeru rijña'á ina'uqué liyá ne'emacánajlo. Ricá i'imari risápaca'ala. E Jesús iphari rinacu, rimá rijló: —Pi'ijná nujhua'até. —Je —que rimacá. ");
INSERT INTO ycn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Raú rácho'o, ri'ijná Jesús hua'até. Ra'apaña piyuque rinane. ");
INSERT INTO ycn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Quéchami Mateo huacára'ari cajrú a'ajnejí la'acana, ajopana ajñácaloje na'ajnehuá Jesús hua'até riñacaré chu penaje. Raú cajrú ina'uqué jahuacaco riñacaré chojé. Cajrú caja liñeru ña'ajeño ne'emacánajlo yá'año re Jesús hua'até na'ajnehuá ajñacana nacú. Re caja ajopana yá'año rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Re caja Fariséona i'imaño Tupana puráca'alo nacú jehuíña'atajeño hua'até. Necá aca'añó Jesús ja'apiyatéjena, nemá najló: —¿Naje chi ajñá a'ajnehuá liñeru ña'ajeño hue'emacánajlo hua'até, uncá ina'uquélaruna, quele hua'até? ");
INSERT INTO ycn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","E Jesús quemari najló: —Uncá peyajhuéruna i'ijnalaño pusána'ajeri amaje. Natáminaja calé i'ijnaño ramaje. ");
INSERT INTO ycn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ñaqué caja ina'uquejlo nucá. Re ina'uqué, natámina que necá Tupánajlo, pu'uhuaré la'ajeño ne'emacale. Ne'iyajena pechu i'imá nanacuhuá: “Pu'uhuaré la'ajeño huecá” que. Nu'ujná majó Tupana yucuna i'imajé ilé cajénajlo, napajno'otácaloje napéchuhua pu'uhuaré nala'acare liyá, ne'emacáloje lamára'ataquejanami que Tupánajlo raú penaje. Eyá ajopana, napechu i'imá nanacuhuá: “Palá la'ajeño huecá” que. E'iyonaja uncá ñaqué calé necá. Uncá nu'ujnalá majó ilé cajénajlo riyucuna i'imajé —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","E caja ajopana quemaño Jesusjlo: —Metú que queja Juan ja'apiyatéjena, fariséona ja'apiyatéjena, quele i'itacó na'ajné liyá, napechu i'imacáloje Tupana nacuja raú penaje. Metú que queja caja napura'acó Tupana hua'até. Eyá pa'apiyatéjena, ñaqueja ajñácaño na'ajnehuá. ");
INSERT INTO ycn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús quemari najló: —Nahuá'acaco huacajé, necá nayucupéra'acarena, uncá i'italaño na'ajné liyá, ilé ruyajná penaje i'imacá re najhua'até quetana. ");
INSERT INTO ycn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ñaqué caja ricá no'opiyatéjenajlo. Najhua'até nu'umacá quetana uncá ne'etaló na'ajné liyá. Tupana huá'ajeri nucá naliyá. Rejomi ne'etajó na'ajné liyá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","—Uncá na calé mata'arí a'arumacaji huajé naquiyana jupichumi tepé penaje. Re'iyayá ripácana aú jupichumi jiyo'otáro huajé liyá. Caja penaje richaje huani jiyo'otáqueja jupichumi a'arumacaji yurico. ");
INSERT INTO ycn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Uncá caja iná aco'olá nacaje jalá huajé amúra'atacanami jupichumi ra'acuná chojé, iná lamá'atacaloje ricá richu penaje. Camejeri ímami naquiyá la'acanami ricá, ra'acuná. Ilé que iná la'acachu huajé amúra'atacanami huapa'atari jupichumi ra'acuná, caja ñaataco ri'imacale. Ejeja ricapichó jupichumi ra'acuná hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Eyá huajé ra'acuná chojé iná aco'ocachu huajé nacaje jalá amúra'atacanami, uncá rijiyo'otala ricá, huajé ra'acuná camejeri ímami ñaacole rijhua'até —que Jesús i'imacá najló yucu—. ");
INSERT INTO ycn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Uncá na calé huátari nacaje jalá i'iracana meyale amúra'atacanami, nemacale jupichumi amúra'atacanami nacú: “Marí caje palani. Ricá chá'atari huajé amúra'atacanami” —que rimacá najló, uncale ne'iyajena huátalaño huajé Tupana puráca'alo ja'apiyá jema'acana. ");
INSERT INTO ycn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Huatána'acaje huacajé Jesús ja'apari ají que iñe'epú chuhuá ra'apiyatéjena hua'até. Iñe'epú ja'apari ajopana mená e'iyohuá. Re'iyá cajrú trigo i'imacá. Na'apaca re'iyohuá nacuhuaja ra'apiyatéjena chíra'año huejapa trigo naquiyana. Natojro'ó nacápihua ricá, najñácaloje penaje. ");
INSERT INTO ycn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariséona naquiyana ja'apaño caja najhua'até. Ra'apiyatéjena chíra'año trigo naquiyana. Eyá nemá najló: —Chuhuajá huatána'acaje huacajé, e'iyonaja isapa. Uncá ila'alá Moisesmi chu puráca'alomi lana'aquéjami quemacá que. ");
INSERT INTO ycn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","E Jesús quemari najló: —Icá hue'epiño méqueca Tupana puráca'alo lana'aquéjami quemacá Davidmi chu nacú. Quehuí rijló me'epejí i'imacá. Ñaqué caja quehuí me'epejí i'imacá rijhua'até i'imacáñojlo. ");
INSERT INTO ycn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A'acuhuaná Davidmi chu mujlúca'ari Tupana ñacaré chojé pan ajñaje. Tupánajlo a'acanami ri'imacá. Moisesmi chu puráca'alomi quemari rinacu, ajopana ajñaca piyá ricá. Necaja calé, sacerdótenaja calé ajñaño ricá. E'iyonaja Davidmi chu ajñari ricá. Ra'á caja rijhua'até i'imacáñojlo rinaquiyana. Marí que David la'acá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ina'uquéjloje penaje i'imacá nucá. Tupana quemari nunacu, numacáloje méqueca iná la'acá huatána'acaje huacajé penaje —que Jesús quemacá fariséona naquiyánajlo. ");
INSERT INTO ycn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Apú huatána'acaje huacajé piño Jesús mujlúca'ari nahuacáca'alo ñacarelana chojé. Re rehuíña'ata necá Tupana nacú. Re caja najhua'até pajluhuaja ina'uqué i'imari. Caja riyáte'ela ca'añá ejo pitá a'amitaró rijló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Re caja Tupana nacú puráca'alo jehuíña'atajeño, fariséona, quele i'imacá. Necá quejíla'año Jesús, namácaloje rilamá'ataca ricá ca'ajná, uncá ca'ajná, huatána'acaje huacajé. Rilamá'atacana aú nemajla rinacu: “Pu'uhuaré la'ajeri ricá.” ");
INSERT INTO ycn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús hue'epiri méqueca napechu i'imacá rinacu. Aú rimá yáte'ela a'amitárojlo: —Pácho'o majó huajimajo. Raú rácho'o, ri'ijná najimaje. ");
INSERT INTO ycn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","E rimá ajopánajlo: —¿Meque chi iná la'acá huatána'acaje huacajé? ¿Meque chi Tupana puráca'alo lana'aquéjami quemacá rinacu? ¿E chi palani iná la'acá palá ca'ajná, chapú ca'ajná huatána'acaje huacajé? ¿E chi palani iná i'imataca ina'uqué capichácajo liyá ca'ajná, ina'uqué capichátacana ca'ajná huatána'acaje huacajé? —que rimacá najló. E'iyonaja uncá na'ajipalá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Raú Jesús yacá'aro nachaje, rahua'á i'imacaño tujlá que chaje. E rimá rijló: —Piya'atá nojló piyáte'ela. Riya'ataca rijló ricá aú ja ripala'ó. Ripa'ó rapumí chuhuá júpimi ri'imacá que caja. ");
INSERT INTO ycn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Raú ajopana yúcha'año cajrú Jesús cha. Naqueño'ó rinacu pura'acano, nahue'epícaloje méqueca nala'ajica ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","E caja Jesús jácho'oro yenuri i'ihuata nacojé, reyá i'imajemi ripura'acóloje Tupana hua'até penaje. Re ripura'ó Tupana hua'até pajluhuaja lapí quetana. ");
INSERT INTO ycn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Najme'etaca ee rihuá'a ra'apiyatéjenajlo, ne'ejnacáloje richaje penaje. Ejomi ri'ihuapá ne'iyayá iyamá iphata ji'imaji nacojé quele achiñana, ne'emacáloje rihuacára'acarena penaje. ");
INSERT INTO ycn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Marí quele ne'emacá ri'ihuapacárena rijluhua: Simón. Ra'á rijló apú rií Pedro. Apú ií i'imari Andrés. Simón e'ehué ri'imacá. Ajopana i'imaño: Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO ycn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Santiago, quele. Apú Santiago ri'imacá. Alféomi chu i'irimi ri'imacá. Apú i'imari Simón. Ricá i'imari cananista naquiyana. ");
INSERT INTO ycn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Apú i'imari Judas. Santiago e'ehué ri'imacá. E caja penaje i'imacá Judas Iscariote. Nenoca Jesús i'imacá huacajé, ricá huá'ari ripinana Jesús i'imacá ejo, napatacáloje ricá penaje. Marí quele ne'emacá ri'ihuapacárena rijluhua ne'iyayá, ne'emacáloje ra'apiyatéjena penaje. ");
INSERT INTO ycn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","E caja Jesús huitúca'ari yenuri i'ihuata naquiyá ra'apiyatéjena hua'até. Tajnaño paláma'atani chojé. Re cajrú ina'uqué i'imacá ajopana, ajopana que. Nanaquiyana i'imaño Judea te'eré eyájena. Ajopana piño i'imaño pajimila Jerusalén eyájena, quele ne'emacá. Juni cha re iyamá pajimila. Apú ií Tiro, apú ií Sidón. Ricá pajimila i'ihuami chu ñacajélaruna i'imaño caja re najhua'até. Piyuque necá i'ijnaño rejo Jesús puráca'alo jema'ajé. Natámina i'imacaño i'ijnaño caja richaje, ra'apátacaloje nayaripune naliyá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ne'iyajena e'iyá jiñana pechu i'imacá. Rica'á ne'iyayá jiñana pechu. ");
INSERT INTO ycn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ajopana natámina sápaño rinacu. Necá ritejmo'óta ripechu aú ja. Ñaquele piyuque natámina i'imacaño huátaño Jesús nacú sápacana, natejmo'otácoloje raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús iphari palámatani chojé. E riyacá'o ra'apiyatéjena chaje. Rimá najló: —Re ina'uqué, nemá Tupánajlo: “Pa'á huañaté, huala'acáloje pihuátaca que penaje. Uncá meño'ojó huala'alá huecó pihuátaca que”. Marí que quemacáñojlo ri'imajé palá, Tupana i'imacale nahuacára'ajeri. ");
INSERT INTO ycn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Palani huani inajlo, huechi iná huátacachu Tupana huátaca que la'acana. Aú Tupana a'ajeri iná ñaté rila'acana aú. Palani huani ina'uqué camu'ují napechu i'imacachu me'etení, necá i'ichajeño i'imajica. ");
INSERT INTO ycn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Apala chapú ca'ajná ajopana ina'uqué pechu inacu, no'opiyá jema'ajeño i'imacale. Rijimaje ca'ajná nala'ajé itejena. Pu'uhuaré ca'ajná napura'ajico inacu. “Uncá ina'uquélaruna necá,” que ca'ajná nemájica inacu, no'opiyá jema'ajeño i'imacale. Palani ri'imajica ijló marí que nala'ajica ee icá chapú, no'opiyá jema'ajeño i'imacale. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Marí que nala'ajica ee icá, ipechu i'imá pu'ují ijluhua. Aú arápa'aje jeño'oqueja, palani huani nacaje i'imajícale ijló je'echú chu. Ñaqué caja a'ajútayami chuna naquiyana la'ajica chapú Tupana puráca'alo ja'apátajeñomi chuna i'imajica. ");
INSERT INTO ycn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Chapú huani ri'imajica ijló, cajrú le'ejepelájerunajlo. Marí eja'ahuá chu i'imacá quetánaja calé pu'ují ipechu i'imajica. ");
INSERT INTO ycn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Chapú huani ri'imajica ijló, cajrú a'ajnejí i'imacárenajlo. Icá ña'ajeño me'epejí panacu. ’Chapú huani ri'imajica ijló, me'etení i'ichacáñojlo. Icá iyájeño, camu'ují ipechu i'imajícale. ");
INSERT INTO ycn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Apala cajrú ina'uqué pura'añó inacu palá me'etení, uncale jema'alá no'opiyá. Chapú huani ri'imajica ijló Tupana huajájica ina'uqué huacajé. Ñaqué caja ichi'inami chuna naquiyana pura'acó palá pajlácachina nacú. Majopeja ne'iyajena quemájica nanacuhuá: “Tupana puráca'alo ja'apátajeño huecá” que. Necá nacú ichi'inami chuna pura'aqueño palá. ");
INSERT INTO ycn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Nupuráca'alo jema'ajéñojlo numá: Ihuata íqui'ija chapú péchuruna inacu. Ila'á caja palá necá. ");
INSERT INTO ycn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Uncá ina'uquélaruna necá”, que ca'ajná nemájica inacu. Ipura'ó Tupana hua'até chapú la'acaño icá nacú. ");
INSERT INTO ycn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Naña'ajica ee icá pajimaya pajluhuáta'ama, ipajno'otá najló apojó pitari, naña'achí icá reyá ñaqué caja. Najña'ajica ee icamichare iliyá, ra'apejé hua'ató a'á najló ricá. ");
INSERT INTO ycn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nemájica ee ijló, iyurícaloje najló nacaje penaje, iyurí najló ricá. Najña'ajica ee iliyá nacaje, imaniya najló, napa'atácaloje ijló ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ila'á ajopana ina'uqué palá, ihuátaca nala'acá icá que caja. ");
INSERT INTO ycn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ihuátacachu íqui'ija necaja calé, huátaño caja icá íqui'ija, uncá Tupana a'alaje ijló rihuemí, uncale ila'alá palá raú. Ñaqué caja uncá ina'uquélaruna huátaca íqui'ija palá péchuruna nanacu. ");
INSERT INTO ycn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Palá ca'ajná ila'acá ina'uqué, la'añó caja icá palá. Necaja calé ila'acachu palá, uncá Tupana a'alaje ijló rihuemí, uncale ila'alá palá. Uncá ina'uquélaruna necá caja la'añó ñaqué caja. ");
INSERT INTO ycn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Iya'atájica ee liñeru najloja calé, pa'atájeño ijló ricá rapumí chojé, uncá Tupana a'alaje ijló rihuemí, uncale ila'alá palá. Uncá ina'uquélaruna caja la'añó ñaqué. ");
INSERT INTO ycn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ihuata íqui'ija chapú péchuruna inacu. Ila'á necá palá. Iya'atá najló liñeru. Ipechu i'imaniya nanacu: “¿Napa'ataje chi nojló ricá rapumí chojé?” Marí que nala'acana aú Tupana a'ajeri ijló palá ila'acare huemí. Ajopana chaje huani huacára'ajeri ricá Tupana. Ricá la'arí palá necá, uncá quemalaño rijló: “Palá pila'acá nucá” que. Rila'á caja palá chapú péchuruna rinacu. Ñaqué la'acaño i'imaño riyani. ");
INSERT INTO ycn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ihue'epí ajopana ina'uqué mu'ují, Tupana hue'epica namu'ují que caja. ");
INSERT INTO ycn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Imaniya majopeja ina'uqué nacú: “Pu'uhuaré la'acaño necá” que. Raú uncá caja Tupana quemalaje inacu: “Pu'uhuaré la'acaño necá” que. Amó ajopana chaje, pu'uhuaré nala'acare icá liyá. Raú Tupana amájero caja ichaje pu'uhuaré ila'acare liyá. ");
INSERT INTO ycn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","A'á ajopánajlo nacaje. Raú Tupana a'ajeri caja ijló nacaje. Cajrú ra'ajica ijló, uncá huejapaja calé ra'ajica ijló. Uncá rinaquiyánaja calé ra'ajé ijló, piyuque ra'ajé ijló nacaje. Ajopánajlo a'acá nacaje, que caja Tupana a'ajica ijló nacaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ri'imá piño marí yucu najló: —Uncá meño'ojó apú mejlurú paco'otala apú mejlurú caja. Ripaco'otaquela ricá, pajñacánija na'acojla ulahuí chojé. ");
INSERT INTO ycn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Uncá huajé jehuíña'acaño iphátala nehuíña'atajeri pechu. Riñapátacaja nehuíña'atacana ejomi nephátaca nehuíña'atajeri pechu —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Rimá piño najló marí que: —Apú ca'ajná la'arí nacaje uncá quemachi paala. Raú pimá ca'ajná rinacu: “Pu'uhuaré la'ajeri ricá” que. Eyá picá ta, pu'uhuaré huani la'ajeri ca'ajná picá. E'iyonaja uncá pimalá pinacuhuá: “Pu'uhuaré la'ajeri nucá” que. ");
INSERT INTO ycn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pu'uhuaré huani la'ajeri pi'imacachu, ¿meque ta pimacajla apú pinaquiyánajlo: “Piyurí pu'uhuaré pila'acare piliyó” que? ¡Pajlácachi huani picá! Piyurí pu'uhuaré pila'acare piliyó pamineco. Ejéchami pihue'epíjica méqueca apú inaquiyánajlo quemacana, riyurícaloje huejapa ñani pu'uhuaré rila'acare riliyó penaje. ");
INSERT INTO ycn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Uncá meño'ojó palani inarí a'ahuaná arúca'ala pu'uhuaré inarí icha que caja. Uncá meño'ojó caja pu'uhuaré inarí a'ahuaná arúca'ala palani inarí icha que caja. ");
INSERT INTO ycn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Richa aú iná hue'epí mecajeca a'ahuaná palani, mecajeca pu'uhuareni. Uncá meño'ojó cucuná icha arúca'ala pipirí icha que caja. Uncá caja lucú arúca'ala cajmú icha que caja. ");
INSERT INTO ycn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ñaqué caja iná hue'epica mecajenaca ina'uqué napuráca'alo aú. Palá péchuri pura'aró palani puráca'aloji nacú. Ri'ijnataca ripéchuhua palani nacaje nacú, que caja rimacá palá nacaje nacú. Eyá pu'uhuaré péchuri pura'aró pu'uhuaré puráca'aloji nacú. Ri'ijnataca ripéchuhua pu'uhuaré caje nacú que caja rimacá pu'uhuaré nacaje nacú. ");
INSERT INTO ycn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesús quemari piño najló: —¿Naje imá nunacu: “Hue'emacana” que? E'iyonaja uncá jema'alá no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ne'iyajena i'ijnaño nuchaje nupuráca'alo jema'ajé. Nupuráca'alo a'ajeño nanacojó i'imajeño palá. Chuhua nu'umajica ijló yucu, ihue'epícaloje méqueca no'opiyá jema'ajeño la'acá palá najluhua raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Capechuni la'ari riñacaró i'imacá que caja no'opiyá jema'ajeño la'acá palá nanacuhuá raú. Marí que rila'acá riñacaré i'imacá: Pamineco jipa naquiyá ritára'ata riñacaré pana, ritára'acoloje camachá penaje. Ricá nacú rila'á riñacaré i'imacá. Cajrú juni ja'acó huacajé, ta'aqueni riñaaca'alá iphaca riñacaré ja'apejé. Ta'aqueni huani ra'apaca riñacaré ja'apiyá. E'iyonaja uncá riñacaré cojno'olá raú, jipa nacú riñacaré pana tára'acole. Marí que rila'acale ricá palá, uncá ricapichalo raú. Ñaqué caja nupuráca'alo a'ajeño nanacojó la'acá palá nanacuhuá, no'opiyá jema'ajeño ne'emacale. ");
INSERT INTO ycn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Eyá ajopana piño jema'añó nupuráca'alo. E'iyonaja uncá na'alá nanacojó ricá. Uncá paala ne'emajica, uncá pachá nema'alá no'opiyá. Apú la'acá riñacaré i'imacá que caja nala'acá chapú necó raú. Marí que rila'acá riñacaré i'imacá: que'epé e'iyaja ritára'ata riñacaré pana. Rinácuja rila'á riñacaré. Cajrú juni ja'acó huacajé, ta'aqueni riñaaca'alá iphaca riñacaré ja'apejé. Raú riñacaré cojno'orí queee junápeje. Chapú huani ricapichaco raú. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Re Jesús jehuíña'atari ne'emacá Tupana nacú. Ejomi ri'ijná ají que pajimila Capernaum ejo. ");
INSERT INTO ycn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Re apú romano naquiyana i'imari. Surárana huacára'ajeri ri'imacá. Ritami huani, aquíchaje huani, rijhua'até sápajeri i'imacá. Iqui'ija rihuátacare ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","E'iyohuá que yucu iphaca ricarihuate nacú: “Jesús iphíchari majó” que. Raú rihuá'a Jesús maná, ri'ijnacáloje rejo rijhua'até sápajeri tejmo'ótaje penaje. Rihuacára'a peñahuilana rihuá'aje. Judíona naquiyana ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aú ne'ejná, iphaño Jesús nacú. Iqui'i nahuátaca ri'ijnacá najhua'até, ritejmo'ótacaloje nahuacára'ajeri hua'ateje penaje. Aú nemá rijló: —Palájne'eque huani huahuacára'ajeri. Ñaquele palani pa'acá riñaté. ");
INSERT INTO ycn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Iqui'ija rihuátaca huecá'ana. Aú calé ra'á liñeru najló i'imacá, nala'acáloje huahuacáca'alo ñacarelana penaje —que nemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Raú Jesús i'ijnari najhua'até. Na'apá ají que a'ajná ño'ojó. Juca pani ne'emacá riñacaré ahua'á ee, nahuacára'ajeri huacára'ari iyamá rijhua'até i'imacaño Jesús jimajo. Palá pechu i'imacaño rinacu ne'emacá. Necá rihuacára'a Jesús jimajo. Rimá najló: —Marí que imájica nunacu rijló: “Hue'emacana, uncá nuhuátala pinacu cahuíla'acana. Uncá caja nuhuátala pimujlúca'aca nuñacaré chojé, nuchaje huani huacára'ajeri pi'imacale. Nopáña'aco huani no'opihuá pijló. ");
INSERT INTO ycn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aú calé uncá nu'ujnalá nocó pijhua'até pura'ajó. Iléreyaja calé pihuacára'a ritejmo'otaco. Raú ja ritejmo'otájico. ");
INSERT INTO ycn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Re caja nuhuacára'ajeño. Surárana huacára'ajeri caja nucá. Numacachu apujlo: ‘Pi'ijná ají ño'ojó’ que, ri'ijná rejo. Numacachu apujlo: ‘Majó pi'ijná’ que, ri'ijnano caja nucá ejo. Nuhuacára'acachu nujhua'até sápajeri la'acá nacaje, rila'á nacaje numacá rijló que —que rimacá najló, na'apátacaloje Jesusjlo ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","E caja ne'ejná Jesús jimajo. Nemá rijló nahuacára'ajeri quemacá najló que. Aú Jesús pechu i'imá rinacu: “¡Meque palá huani ripechu Tupana nacú. Caphí ripechu richojé, ra'acáloje riñaté penaje.” E riyacá'o riyámojo, rápumi chu chira'ajeño chaje. Rimá najló: —Caphí ripechu Tupana chojé, ra'acáloje riñaté penaje. Uncá nuphátala apú Israelmi chu laquénami naquiyana e'iyayá ripechu que péchuri —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Reyá napa'ó piño napumí chuhuá nahuacára'ajeri ñacaré ejo. Amaño caja rijhua'até sápajeri tejmo'otaco. ");
INSERT INTO ycn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Rejomi Jesús i'ijnari ají que a'ajná ño'ojó pajimila ejo. Pajimila ií i'imari Naín. Ra'apiyatéjena, cajrú ajopana hua'até, i'ijnaño caja rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","E caja riphá pajimila nacojé. Amari nahuáco'oco támijimi caichama chu támijimina ca'aquelana ejo. Cajrú pajimila eruna ja'apaño najhua'até. Ihuacajílomi i'irí tajnáñari ru'umacá. Ricaja calé, pajluhuaja ru'urí i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús amari ruyaca ru'urí tami hua'até. Aú rihue'epí runacu camu'ují. E rimá rojló: —Piyániya. ");
INSERT INTO ycn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","E ri'ijná caichama ahua'ajé. Eyá risapa rinacu. Raú rihuáco'ojeño tajnaño. E Jesús quemari támijimijlo: —Hualijímaca, pácho'o. ");
INSERT INTO ycn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aú ja taca'arí penájemi jácho'oro yá'ajo. Ejéchami riqueño'ocá pura'acajo. E Jesús a'arí ralojlo ricá. ");
INSERT INTO ycn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Marí que namaca aú piyuque re i'imacaño quero'oñó. Palá napura'acó Tupana nacú. Ne'iyajena quemaño marí que pajlocaca: —Ajopana Tupana puráca'alo ja'apátajeño chaje cari huajhua'até. Caja Tupana iphari majó rile'ejena ina'uqué ñaté a'ajé —que nemacá pajlocaca. ");
INSERT INTO ycn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Cajrú huani Jesús yucuna jema'acó Judea te'eré e'iyohuá. Rahua'á i'imacaño, ajopana te'eré e'iyohuá hua'ató, riyucuna jema'acó i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan ja'apiyatéjena i'imaño Juanjlo piyuque nacaje Jesús la'acare yucuna. Aú rimá iyamá nanaquiyánajlo, ne'ejnacáloje Jesús amaje penaje. ");
INSERT INTO ycn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Rimá najló: —Eco iquejá'a nojló riyucuna riliyá. Imicha rijló marí que: “¿Picá chi picá nemacare nacú, iphájeri majó ina'uqué i'imatájeri penaje? Apú ca'ajná huaícha. ¿Meque chi ricá?” que imájica rijló —que Juan quemacá najló. —Je. ");
INSERT INTO ycn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Raú ne'ejná ají que a'ajná ño'ojó. Iphaño Jesús nacú. Iqui'iruna natámina tejmo'ótacana nacú ri'imá. Ra'apata natámina naquiyá nayaripune. Rica'á caja jiñana pechu cajrú ina'uqué e'iyayá. Ra'apata caja mejlucaji mejluruna liyá. Marí caje la'acana nacú ri'imacá ee nephá rinacu. E nemá rijló: —Juan Bautizar la'ajeri huacári'ichari huecá majó. Rimicha pinacu: “¿Picá huani chi picá nemá nacú i'imacá, iphájeri majó ina'uqué i'imatájeri penaje? Apú ca'ajná huaícha. ¿Meque chi ricá?” que rimíchaca pinacu —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","E Jesús quemari najló: —Ipa'ó rejo, i'imichachi Juanjlo riyucuna méqueca amíchaca nula'acá huajé. Nacaje nohuíña'atacare nacú yucuna hua'ató i'imajé caja rijló. Eco imá rijló marí que nunacu: “Mejluruna liyá ra'apata mejlucaji, namácaloje penaje. Uncá meño'ojó ja'apálaño rilamá'ata, na'apácaloje penaje. Nanapona patáca'atacaronajlo ripala'atá palá huani nanapona najló. Me'ejhuiruna liyá ra'apata caja me'ejhuí caje, nema'acáloje reyá penaje. Támijimina naquiyana rimacápo'o caja. Camu'ují la'acáñojlo ri'imá Tupana i'imataca ina'uqué capichácajo liyá yucuna”, que imájica rijló nunacu. ");
INSERT INTO ycn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","“Pu'ují péchuruna necá uncá huani la'alaño ujhuí napéchuhua nuliyá”, que imájica Juanjlo —que rimacá najló. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","E napa'ó. Ejomi Jesús i'imari ripuráca'alo jema'ajéñojlo Juan yucuna. Rimá najló marí que: —Icá i'ijnaqueño pu'uteni meñaru chojé Juan puráca'alo jema'ajé. ¿Naje chi i'ijnaqué rejo? ¿E i'ijnacá iyamá chuhuá péchuri chaje? Uncá iyamá chuhuá péchuri calé ricá. ");
INSERT INTO ycn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Palá a'arumacari amaje chi i'ijnaqué richaje? Uncá palá nojé a'arumacari calé ricá. Icá hue'epiño palá a'arumacáruna nacojé. Nahuacára'ajeño ñacaré chiyájena necá. ");
INSERT INTO ycn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Eta ¿naje chi i'ijnaqué ramaje? ¿Amácaloje Tupana puráca'alo ja'apátajeri penaje chi i'ijnaqué ramaje? Ricá jo'ó ri'imacá. Tupana puráca'alo ja'apátajeri penájemi ricá. ");
INSERT INTO ycn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ricá nacú Tupana puráca'alo lana'aquéjami quemari marí que: Nucá huacára'ajeri pajluhuaja ina'uqué pitucumá. Ricá quemájeri ina'uquejlo pipé, napala'atácaloje napéchuhua pu'uhuaré nala'acare liyá penaje, que Tupana quemacá ri'irijlo Juan nacú uncá chiyó ri'imá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jema'á marí: —que Jesús quemacá—. Uncá na i'imalá huayámojo Tupana puráca'alo ja'apátajeñomi chuna e'iyayá, chá'atari Juan. Eyá je'echú chu uncá ñaqué calé ricá. Na'apejé i'imacá je'echú chu, chá'atari Juan. Je'echú churuna huacára'ajeri Tupana. ");
INSERT INTO ycn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Juan i'imacá Tupana yucuna ina'uquejlo huacajé, cajrú ina'uqué jema'añó ripuráca'alo. Liñeru ña'ajeño ne'emacánajlo hua'ató jema'añó caja ripuráca'alo. Necá a'añó nanacojó Tupana puráca'alo. Ñaqué caja ajopana i'imacá. Aú calé Juan la'arí necá bautizar. ");
INSERT INTO ycn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Eyá fariséona naquiyana, Tupana puráca'alo nacú jehuíña'atajeño naquiyana, quele uncá huátalaño nacaje Tupana la'acare a'acana nanacojó. Aú calé uncá nemalá Juanjlo, rila'acáloje bautizar necá penaje —que Jesús i'imacá najló riyucuna. Rimá piño najló marí que: ");
INSERT INTO ycn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","—Marí que i'imacaño ina'uqué me'etení: Yuhuaná queja necá. Yá'año le'ejepelaji ñacarelana chu cátacajo nacú necá. E nahuá'a ajopana najhuáque'enajlo. Nemá najló: “Huapho'ó quehuirí chojé ijló. E'iyonaja uncá jarápa'ala. Huataní caja ijló yáleje, ipechu la'acóloje camu'ují raú penaje. E'iyonaja uncá ipechu la'aló camu'ují raú. Uncá caja iyala raú”, que nemacá najló. Ñaqué caja ina'uqué naquiyana la'acá me'etení, majopeja aca'acá huamaná. Cayucújne'equena huani icá. ");
INSERT INTO ycn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","’Pamineco Juan i'imacá ijló Tupana yucuna. Ri'itajico ra'ajné liyá, ripechu i'imacáloje Tupana nacuja penaje. Uncá caja ri'iraqué nacaje jalá amúra'atacanami. E'iyonaja ricá nacú imá: “Jiñá pechu re'iyá” que. ");
INSERT INTO ycn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Eyá nucá, ina'uquéjloje penaje i'imacá nucá. Ajopana ajñaca na'ajnehuá que caja nojñaca no'ojnehuá. Ñaqué caja nu'uracá nacaje jalá amúra'atacanami. Nunacu imá: “Cahuale'equé huani ricá. I'iracachi ricá. Uncá ina'uquélaruna huáque'ehue caja ricá. Liñeru ña'ajeño ne'emacánajlo huáque'ehue caja ricá”, que imacá nunacu. ");
INSERT INTO ycn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","E'iyonaja calé Tupana ja'apiyá jema'ajeño hue'epiño nacaje Tupana la'acare nacojé. ");
INSERT INTO ycn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pajluhuaja fariséona naquiyana quemari Jesusjlo, ri'ijnacáloje ra'ajnehuá ajñaje rijhua'até penaje. Raú ri'ijná rejo. Riyá'o ra'ajnehuá ajñacana nacú rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ricaja caja pajimila e apa'ahuelo i'imayo ñuju'uqueru, manai péchuru. Rucá jema'ayó Jesús ajñaca ra'ajnehuá fariséona naquiyana hua'até yucuna. Aú calé ru'ujná rejo, iphayo Jesús nacú. Huíluru i'imari rucapi. Jipa alabastro naquiyá la'acanami huíluru i'imacá rucapi. Nacaje jilami, pu'umé jamarí, i'imari richu. ");
INSERT INTO ycn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Rucá iphayo Jesús huajlé chojé hua'até que ruyaca. E rujláma'o ri'imá nacojé. Rojata ri'imá rujlú jalá aú. Quéchami rolácaca rinaquiyá ruhuilá aú. Quéchami ruchiño'ocá ri'imá naquiyá. Ejomi roco'ó nacaje jilá, pu'umé jamarí, ri'imá nacojé. ");
INSERT INTO ycn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ilé fariséona naquiyana, yucupéra'acare Jesús i'imacá, amari méqueca rula'acá ri'imacá. Aú ripechu i'imá: “Tupana puráca'alo ja'apátajeri ri'imaquela, rihue'epícajla mecajeruca quelerú inanaru ta, ñuju'uqueru, uncá ina'uquélaru ta rucá.” Jesús hue'epiri méqueca ri'ijnataca ripéchuhua rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Aú Jesús quemari rijló: —Simón, nuhuata nacaje nacú quemacana pijló. —Je. Pimá nojló, Huehuíña'atajeri —que rimacá. ");
INSERT INTO ycn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús i'imari rijló yucu marí que: —Iyamá ina'uqué i'imichaño. Lehuérichaño nacarihuátejlo cajrú huani. Apú lehuérichari rijló íqui'ija huani liñeru aú. Risápacajla iyamá jarechí quetana, ra'atácaloje rilehuéricare rijló huemí penaje. Apú lehuérichari rijló huejápaja quemachi. Ricá sápacajla iyamata queri quetánaja, ra'atácaloje rilehuéricare huemí penaje. ");
INSERT INTO ycn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Uncá meño'ojó na'alacha rijló liñeru nalehuérichaje huemí. Aú nacarihuate lamá'achiyari necá raú. Marí que ri'imacá rijló yucu. Ejomi rimá Simonjlo: —Iyamá ne'emacá. ¿Mecaje pechu i'imari richaje huani pu'ují rinacu? ");
INSERT INTO ycn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Capí. Apala ilé lehuérichari cajrú huani rijló, pechu i'imichari pu'ují huani rinacu —que Simón quemacá. —Que jo'ó —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Eyá Jesús yacá'aro apa'ahuelo chaje. Rimá Simonjlo: —¿E pamaca marirú? Nuphíchaca piñacaré chojé aú uncá pa'alacha nojló juni, nupácaloje nu'umá naquiyá raú penaje. Eyá marirú ejáchiyayo nu'umá rujlú jalá aú. Quéchami roláquichaca ricá ruhuilá aú. ");
INSERT INTO ycn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Uncá caja pajalácalacha nucá nujimá chiyá chiño'ocana aú. Eyá marirú iphíchayo, chiño'ochayo nu'umá naquiyá cajrú. Nu'umá naquiyá chiño'ocana nacuja rucá me'etení. ");
INSERT INTO ycn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Uncá caja paco'olacha nacaje jilá nuhuilá e'iyajé. Eyá marirú aco'ochayo nu'umá nacojé nacaje jilá, pu'umé jamarí. ");
INSERT INTO ycn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Marí que ruli'ichaca nuyájlepana, nomácole ruchaje cajrú huani rumanaicho rula'acare liyá, pu'uhuaré rula'acare liyá. Ñaquele pu'ují huani rupechu nunacu. Re ca'ajná ajopana. Nala'á pu'uhuaré huejápaja. Nomó nacaje pu'uhuaré nala'acare liyá. Necá penaje la'añó huejápaja caja nuyájlepana. Huejápaja caja pu'ují napechu nunacu —que Jesús quemacá Simonjlo. ");
INSERT INTO ycn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","E Jesús quemari rojló: —Caja nomicho pichaje pimanaicho pila'acare liyá, pu'uhuaré pila'acare liyá. ");
INSERT INTO ycn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Raú rijhua'até yá'acaño naquiyana quemaño pajlocaca: —¿Naca ca'ajná ricá? Amaro iná chaje iná manaicho iná la'acare liyá, pu'uhuaré iná la'acare liyá. ");
INSERT INTO ycn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús quemari piño rojló: —Caja Tupana i'imachíyari picá capichácajo liyá, pipechu i'imacale caphí nochojé. Pipechu i'imá nunacu: “Ricá amaro iná chaje pu'uhuaré iná la'acare liyá”. Chuhua pi'ijná palá ca'ajnó. ");
INSERT INTO ycn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","E caja apú huacajé piño Jesús ja'apari ají que a'ajná ño'ojó apú pajimila nacojé, apú pajimila nacojé que. Pajimila cajruni nacojé, pajimila camu'ujuni nacojé que ra'apaca Tupana yucuna i'imacana nacú. Tupana i'imatari ina'uqué capichácajo liyá, ne'emacáloje rijhua'atéjena raú penaje. Riyucuna ri'imaqué najló. Ra'apiyatéjena i'ijnaño caja rijhua'até. Iyamá iphata ji'imaji nacojé quele ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Inaana naquiyana i'ijnaño caja rijhua'até. Rica'acárena ne'iyayá jiñana pechu nanaquiyana i'imacá. Necá i'ijnaño caja rijhua'até. Ñaqué caja ajopana ritejmo'ótacarena i'ijnaño rijhua'até. Quele necá chira'añó rijhua'até. Apa'ahuelo i'imayo María Magdalena. Jesús ca'acáreru e'iyayá iyamá cuhuá'ata quele jiñana pechu i'imacayo ru'umacá. ");
INSERT INTO ycn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Apa'ahuelo i'imayo Juana. Cuza yajalo ru'umacá. Cuza i'imari Herodes hua'até sápajeri. Apa'ahuelo i'imayo Susana. Ajopana i'imaño caja najhua'até. Cha'apá ne'emacá. Necá piyuque a'aqueño Jesús ñaté. Na'aqué rijló, ra'apiyatéjenajlo hua'até a'ajnejí majopeja nale'ejó aú. ");
INSERT INTO ycn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","E caja cajrú ina'uqué jahuacaco Jesús nacojé. Apú pajimila eyá, apú pajimila eyá que nephaca rinacu. Cajrúchami ina'uqué jahuacaco rejé i'imacá. E ri'imá najló yucu, rehuíña'atacaloje necá Tupana nacú raú penaje. Marí riyucuna: ");
INSERT INTO ycn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Pajluhuaja ina'uqué i'ijichari nacaje icha ijí ejátaje. Riqui'ichá richa ijí te'erí lamá'ataqueja jimahua. Rejátacana nacuja ri'ijichá. Richa ijí riqui'ichaje naquiyana ja'acharo iñe'epú chojé. Richuhuá ina'uqué ja'apaño richó. E caja cupira'aphana iphíchaño rajmílo'oje. ");
INSERT INTO ycn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Apú richa ijí riqui'ichaje naquiyana ja'acharo jipa nacojé. Huejápaja te'erí i'imichari rinacu. Riphíchaca ejomi rimeríyi'icho, uncale isani te'erí i'imalá jipa nacú. ");
INSERT INTO ycn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Apú richa ijí riqui'ichaje naquiyana ja'acharo pu'uhuareni jimichi e'iyajé. Pu'uhuareni jimichi iphíchari nacaje icha ijí rejáchiyaje hua'até. Pu'uhuareni jimichi tahuá'añachari ricá. Raú rihuajri'ichá re'iyajé. ");
INSERT INTO ycn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Eyá apú richa ijí naquiyana ja'acharo palani te'erí e'iyajé. Ilé iphíchari palá. Palá ritahuá'ichaco. Palá caja rarúqui'ichaca; que'iyapé rarúqui'ichaca. Re'iyajé arúqui'ichari cien ca'alá. Marí que Jesús i'imacá yucu najló. Ejomi caphí rimacá najló: —Icá que'ejhuirúnajlo numá, a'á inacojó riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Caja ri'imá najló yucu. Ejomi ra'apiyatéjena quemaño rijló: —¿Meque quemacánaca chi cari yucu pi'imichaje huajló huajé? ");
INSERT INTO ycn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Rimá najló: —Me'echuje ina'uquejlo méqueca Tupana la'acá, ina'uqué naquiyana i'imacáloje rijhua'atéjena penaje. E'iyonaja Tupana la'arí ipechu palá, jema'acáloje penaje. Eyá ajopánajlo me'echuje jo'ó ricá. Nu'umá yucu najló, nohuíña'atacaloje necá Tupana nacú raú penaje. E'iyonaja uncá nahue'epila meque quemacánaca ricá riyucuna jema'acana aú. Uncá caja nahue'epila meque quemacánaca nacaje namácare. ");
INSERT INTO ycn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","E rimá najló: —Marí que quemacánaca ricá: Richa ijí rica'acare te'erí jimahua rejátacana nacú, Tupana puráca'alo na'apátacare ina'uquejlo que caja ricá. ");
INSERT INTO ycn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Richa ijí naquiyana ja'aró iñe'epú chojé. Ñaqué caja riyucuna jema'ajeño naquiyánajlo ricá. Nema'á riyucuna. E'iyonaja Jiñá Chi'ináricana ca'arí napechu naquiyá Tupana puráca'alo nema'acare. Rica'á napechu naquiyá ricá, napechu i'imacá piyá caphí Tupana chojé ne'ematájeri penaje. ");
INSERT INTO ycn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Eyá richa ijí naquiyana ja'aró jipa nacojé, huejapa te'erí i'imacare nacojé. Mequetánaja calé rijña'á panacu riphaca ejomi. Ñaqué caja ina'uqué naquiyánajlo ricá. Nema'á Tupana puráca'alo. Pu'ují napechu la'acó raú. Mequetánaja calé napechu i'imacá palá rinacu. Nahuátacale Tupana puráca'alo ja'apiyá i'imacana, ajopana ca'ajná la'añó necá chapú. Napura'ó ca'ajná nanacu pu'uhuaré. Namá ca'ajná chapú caje yajhué. Marí caje aú nayurí naliyó ricá, uncale napechu i'imalá caphí najluhua. ");
INSERT INTO ycn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Eyá richa ijí naquiyana ja'aró caja pu'uhuareni jimichi e'iyajé. Riphaca ejomi rihuaja'acá re'iyajé. Uncá rarúca'ala. Ñaqué caja ina'uqué naquiyánajlo ricá. Nema'á Tupana puráca'alo. Naqueño'ó ra'apiyá i'imacana. E'iyonaja cajrú na'acá nanacojó nacaje marí eja'ahuá chu i'imacare. Ñó'ope liñeru, le'ejepelaji, caje macá nahuacata najluhua. Ricá nahue'epí natucumó. Marí que péchuruna ne'emacale, uncá na'alá nanacojó Tupana puráca'alo, nala'acáloje palá ra'apiyá i'imacana aú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Eyá richa ijí naquiyana ja'aró palani te'erí e'iyajé. Riphá, ritahuá'o, rarúca'a palá. Ñaqué caja ina'uqué naquiyánajlo ricá. Nema'á Tupana puráca'alo, nahue'epí caja meque quemacánaca ricá, na'á caja nanacojó ricá. Uncá caja naya'aló ra'apiyá i'imacana nacú. Raú calé nala'á palá ra'apiyá i'imacana aú. ");
INSERT INTO ycn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Iná lucúna'acachu iná camaré, uncá iná yá'atala ricá i'ichí lájma'ataqueja ja'apejé. Uncá caja iná yá'atala ricá iná camané ja'apejé. Yenú iná yá'ata ricá, pají chojé mujlúca'ajeño amácaloje ricamare chojé penaje. ");
INSERT INTO ycn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Re Tupana puráca'alo naquiyana me'etení, me'echuje ricá ina'uquejlo. Quéchami nahue'epíjica rinacojé. ");
INSERT INTO ycn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ñaquele jema'á palá. Ra'apiyá jema'ajeño pechu rila'ajé palá, nahue'epícaloje richaje, richaje, que rinacojé penaje. Eyá necá, uncá jema'alaño ra'apiyá, naliyá Tupana ña'ajeri ricá huejápaja nahue'epícare nacojé. Napechu i'imá nanacuhuá: “Huahue'epícare ricá” que. E'iyonaja uncá ñaqué calé napechu nacú ricá. ");
INSERT INTO ycn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pachu Jesús i'imari cajrú ina'uqué hua'até. E Jesús jaló, rijmerémina, quele iphaño rejo. Nahuata rijhua'até pura'acano. Cajrú ina'uqué nacojé uncá meño'ojó nephala rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","E apú quemari Jesusjlo: —Paló iphíchayo pejena hua'até. Nahuá'icha pimaná, pi'ijnacáloje rejo penaje. ");
INSERT INTO ycn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","E Jesús quemari najló: —Re ina'uqué, nema'á nupuráca'alo. Nala'á caja numacá que. Necá calé nojena que, noló que. ");
INSERT INTO ycn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Muní que Jesús huitúca'aca jita chojé ra'apiyatéjena hua'até. Rimá najló: —I'ijná huacuhuá'achi caesa pa'anajo pitá. Aú nacuhuá'a. ");
INSERT INTO ycn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nacuhuá'aca nacú Jesús camátaro. Ejéchami mana'í chiyó carená i'imacá nachá caphí huani. Carená yocola amo'oró jita chojé cajrú juni. Ujú caje chiyó na'acojla junápeje raú. ");
INSERT INTO ycn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yehuíchami na'acó junápeje napótaca Jesús, nemá rijló: —Huehuíña'atajeri, chuhuaca huejaca. Raú Jesús jácho'oro. Raca'á carená, juni hua'até. Raú carená mata'aró, juni piya hua'até. Uncá huani riyoco'oló rejomi. ");
INSERT INTO ycn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","E rimá ra'apiyatéjenajlo: —¿Naje chi uncá ipechu i'imalá caphí nochojé? Quero'ocajo nacú ne'emá. Napechu i'imá: “¡Meque piyuque huani rihue'epica!” Nemá pajlocaca: —Ripuráca'alo aú carená, juni hua'até jema'arí ra'apiyá. ");
INSERT INTO ycn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","E caja nephá pa'anajo pitá, Gerasa te'eré ejo. Galilea te'eré loco'opani ricá. ");
INSERT INTO ycn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Narúca'o. E Jesús jácho'oro jita chiyá. E apú ina'uqué iphari rinacu. Pajimila eyaje ri'imacá. Caja júpicha Jiñana pechu i'imacare re'iyá ri'imacá. Aú richira'acó ma'arumacaru i'imajica. Uncá caja ri'imaqué pají chu. Támijimina ca'aquelana ehuaja ri'imaqué. ");
INSERT INTO ycn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ricá iphari Jesús nacú. Ramaca aú Jesús, rijláma'o ri'imá nacojé. Caphí rimacá rijló: —¿Naje picahuíla'a nunacu? Tupana, je'echú churí i'irí picá. Jesús picá. Pijló numá, pila'aniya nucá chapú huani me'etení. ");
INSERT INTO ycn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Marí que rimacá Jesusjlo i'imacá, Jesús quemacale jiñá péchujlo, ra'apácaloje re'iyayá penaje. Pulapé jiñá pechu patajica ilé ina'uqué. Yurí huani ri'imajica raú. Ñaquele na'á ajopana ramájeri penaje i'imacá. Nepo'otá ricá curete aú riyáte'ela naquiyá, ri'imá naquiyá hua'até. E'iyonaja rimata'atá curete. Ejomi jiñá pechu huá'ari ricá ají que pu'uteni meñaru chojé. Re Jesús iphátari ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","E Jesús quemari rijló: —¿Na pií? —Nuí íqui'iruna. Marí que rimacá rijló, íqui'iruna jiñana pechu i'imacale re'iyá. ");
INSERT INTO ycn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jiñana pechu quemaño Jesusjlo: —Pihuacára'aniya huecá ulahuí uncá tajáca'alo i'imalá chojé. ");
INSERT INTO ycn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A'ajnare que cajrú je'eruna piracana chira'añó yenuri nacuhuá na'ajnehuá culacana nacú. Mahuó jiñana pechu la'acá ricá. Nemá rijló: —A'ajnáruna je'eruna e'iyajé pihuacára'a huecá. —Je —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Raú jiñana pechu jácho'oño re'iyayá je'eruna piracana e'iyajé. Jiñana ja'acó aú ne'iyajé je'eruna jecho'oñó ají que a'ajná ño'ojó. Yenuri ji'ihuátaya na'ó ají que caesa acojé. Rejeja nacapichó piyuqueja junápeje. ");
INSERT INTO ycn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nalamára'ajeño penájenami amaca aú nacapichaco neñaó reyá. Ne'emá riyucuna rehuá i'imacáñojlo, pajimila erúnajlo hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Raú ne'ejná ramaje, iphaño Jesús nacú. Amaño ilé ina'uqué, jiñana pechu i'imacare e'iyá penájemi. Re riyá'o Jesús ji'ilá. Ca'arumacani ri'imacá. Palá caja ripechu i'imacá. Marí que namaca aú ricá naquero'ó. ");
INSERT INTO ycn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Re i'imacaño amaño maapami que Jesús ca'acá jiñana pechu re'iyayá. Necá penájena i'imaño huajé iphácañojlo riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Piyuqueja Gerasa te'eré ehuájena quero'oñó Jesús piyá cajrú, aú nemá rijló: —Pácho'o huate'eré naquiyá. —Je —que rimacá. E Jesús huitúca'ari piño jita chojé, ripa'acóloje penaje. ");
INSERT INTO ycn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ejéchami, rica'acare e'iyayá jiñana pechu penájemi, huátaca mahuó Jesús hua'até i'ijnacana. E'iyonaja Jesús quemari rijló: ");
INSERT INTO ycn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Pipa'ó piñacajela ejo, pi'imacáloje méqueca Tupana la'acá palá picá yucuna najló rehuá penaje. —Je —que rimacá. E ripa'ó. Ri'ijná piyuque pajimila nacuhuá riyucuna i'imacana nacú najló. ");
INSERT INTO ycn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","E caja Jesús iphari piño rapumí chuhuá caesa pa'anajo pitá. Pu'ují napechu i'imacá namaca aú ricá. Re ne'emá rihuátacana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","E caja apú iphari rinacu. Jairo rií i'imacá. Nahuacáca'alo ñacarelana chiyá huacára'ajeri ri'imacá. Riphá Jesús nacú. E rijláma'o Jesús ji'imá nacojé, rimá rijló: —Pila'á nojló nacaje. Pi'ijná nuñacaré ejo, pitejmo'óchiyachi nutu nojló. ");
INSERT INTO ycn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Aquíchajeru huani rucá. Uncá apa'ahuelo i'imalá, rucaja calé pajluhuájaru nutu. Iyamá iphata ji'imaji nacojé quele jarechicha rucá —que rimacá rijló. Aú Jesús i'ijnari rijhua'até. Cajrú ajopana i'ijnaño caja rijhua'até. Cajrú netaca Jesús cha. ");
INSERT INTO ycn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Najhua'até caja apa'ahuelo ja'apayo, rutami caja ru'umacá. Jirá ja'apáqueri runaquiyá. Caja iyamá iphata ji'imaji nacojé quele jarechí quetana ru'umacá rijhua'até. Ruca'aqué piyuque ruliñérute rupusána'acana huemí. E'iyonaja ñaqueja hua'ateja ru'umaqué. ");
INSERT INTO ycn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ro'opá najhua'até. E ru'ujná ají que ina'uqué ihuami chiyá Jesús loco'opani. Rutejmo'ocóloje penaje, rusapa ra'arumacá ji'imá nacú. Rejeja jirá ja'apácare runaquiyá mata'aró. ");
INSERT INTO ycn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","E Jesús quemari najló: —¿Na sápichari nunacu? —Uncá nucá calé —queja nemacá piyuqueja. Eyá Pedro quemari rijló: —Huehuíña'atajeri, cajrú ina'uqué ichíyaca pichá. Eta pimá: “¿Na sápichari nunacu?” que. ");
INSERT INTO ycn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús quemari najló: —Nápajaca sápichayo nunacu. Nuhue'epí nutejmo'óchiyaca pajluhuájaru inanaru nupechu aú. ");
INSERT INTO ycn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sápayo rinacu pechu i'imá: “Caja rihue'epicha méqueca nucá.” Cajrú rucurúcaca hua'até ru'ujná rijimajo. Rutára'o ru'urúpachi aú rijimaje. Re piyuque i'imacaño ahua'á ru'umá riyucuna rijló nájeca rusápaca ra'arumacá nacú. Rumá caja najló méqueca rutejmo'otaco raú. ");
INSERT INTO ycn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","E Jesús quemari rojló: —Caja pitejmo'ochiyo, pipechu i'imacale caphí nochojé. Pipechu i'imichá nunacu: “Ricá tejmo'ótajeri nucá” que. Aú calé pitejmo'ochiyo. Chuhua pi'ijná ca'ajnó, pipechu i'imá palá. ");
INSERT INTO ycn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Marí que rimacá rojló ee apú iphari nanacu. Jairo ñacaré chiyaje ri'imacá. Rimá Jáirojlo: —Caja pitu taqui'ichayo. Caja rupechu capiícharo. Uncá na penaje calé picahuíla'a Huehuíña'atajeri nacú ruchaya. ");
INSERT INTO ycn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús jema'arí méqueca rimacá rijló. Aú rimá Jáirojlo: —Pihuó ca'aniyo, pila'á pipéchuhua caphí nochojé. Pitu i'imajeyo. ");
INSERT INTO ycn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","E na'apá piño, iphaño riñacaré ejo, amaño cajrú nahuinano la'ajeño i'imacá re. Cajrú nala'acá nahuinano rucá. E Jesús quemari najló: —Iyániya rujhua'até. Uncá rutaca'alacha, rucamáchiyacoja calé. Raú ne'echá rinacu, nahue'epícale caja rutaca'acá i'imacá. E rimujlúca'a támijimi i'imacare ucapú chojé. Uncá riyurila ajopana mujlúca'aca rijhua'até. Pedro, Santiago, Juan, rora'apami, rolomi, quele ja calé riyurí mujlúca'aca rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","E Jesús iphari támijimi ahua'ajé, patarí rucá ruyáte'ela naquiyá. Caphí rimacá támijimijlo: —Yuhualó, pácho'o. ");
INSERT INTO ycn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Raú ja rócho'o. E Jesús quemari ajopánajlo: —A'á rojló a'ajnejí, rojñachi. ");
INSERT INTO ycn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ruchi'iná pechu i'imá: “¡Meque piyuque huani la'acá ricá!” E rimá najló: —Pa. I'imaniya riyucuna ajopánajlo. ");
INSERT INTO ycn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","E caja Jesús quemari ra'apiyatéjenajlo, nahuacácoloje rinacojé penaje. Iyamá iphata ji'imaji nacojé quele ne'emacá. E nahuacó rinacojé. E ra'á najló pechuji, naca'acáloje jiñana pechu ina'uqué e'iyayá raú penaje. Raú caja natejmo'ótacaloje natámina que'iyapejé nayaripune chiyá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Rihuacára'a necá, ne'emacáloje Tupana yucuna ajopánajlo penaje, Tupana i'imacáloje nahuacára'ajeri penaje. Rihuacára'a caja necá, natejmo'ótacaloje natámina penaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Rimá najló: —Majopeja i'ijnajica. Ijña'aniya inane ijhua'ató, icutihuare, itulané, a'ajné, liñeru, caje. Pajluhuaja a'arumacá chuja i'ijnajé. ");
INSERT INTO ycn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pajimila e iyuró apú hua'até riñacaré chu. Rijhua'ateja iyurejo re i'imajica quetana. ");
INSERT INTO ycn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Uncájica ee pajimila eruna huátaño icá re, iñaca'á ji'ima'ulá naquiyá mu'upé najimaje jácho'ojico reyá huacajé. Nahue'epícaloje raú pu'uhuaré la'ajéñoca necá, uncale nahuátala icá —que rimacá najló. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aú nácho'o reyá. Ne'ejná ají que a'ajná ño'ojó apú eyá, apú eyá que. Ne'emá Tupana i'imataca ina'uqué capichácajo liyá yucuna najló. Natejmo'óta caja natámina. ");
INSERT INTO ycn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Piyuque nacaje Jesús la'acare rehuá yucuna jema'acó cajrú rehuá. Nahuacára'ajeri Herodes jema'arí caja riyucuna. Ne'iyajena quemaño Jesús nacú: —Juan ca'ajná ricá. Caja rimacápo'o rapumí chuhuá piño.” Marí caje aú uncá Herodes hue'epila na huánica Jesús i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ajopana piño quemaño Jesús nacú: —Tupana puráca'alo ja'apátajeri, Elíasmi chu, macápo'ocaro penájemi ricá. Ricá quele iphari majó. Ajopana piño quemaño rinacu: —Pajluhuaja Tupana puráca'alo ja'apátajeñomi chuna naquiyana ricá, macápo'ocaro. ");
INSERT INTO ycn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eyá Herodes quemari rinacu: —Nucá huacára'ari Juanmi chu núru'upi mata'acana i'imacá. Eta, ¿nata quele nemá nacú: “Piyuque huani la'acá ricá”? Ñaqué i'imacale rihuata huani Jesús amácana. ");
INSERT INTO ycn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","E caja necá, Jesús huacára'acarena i'imacá, pa'añó piño napumí chuhuá. Piyuqueja nacaje nala'acare rehuá yucuna ne'emá Jesusjlo. E rihuá'a necá ají que pajimila Betsaida ejo, ne'emacáloje necó re penaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","E'iyonaja ajopana ina'uqué hue'epiño meño'ojoca ri'ijnacá. Aú ne'ejná nápumi chu, iphaño nanacu. Re rehuíña'ata necá Tupana nacú, nahuátacaloje ricá nahuacára'ajeri penaje. Ritejmo'óta caja natámina i'imacaño. ");
INSERT INTO ycn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","E caja najúhua'a. E ra'apiyatéjena, iyamá iphata ji'imaji nacojé quele, i'ijnaño Jesús ahua'ajé. Nemá rijló: —Pihuacára'a necá pajimila ejo, ajopana ñacaré ejo hua'até, nahuarúhua'acaloje a'ajnejí najluhua reyá penaje, naculácaloje camátacajo pucuna rejo penaje. Maare ta uncá na i'imalá najló —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","E'iyonaja rimá najló: —Icá a'ajeño najló a'ajnejí. Nemá rijló: —Pajluhua té'ela ca'alá pan maare iyajmela jíñana hua'até, queleja calé maare. ¿E pihuátaca hue'ejnacá a'ajnejí huarúhua'aje najló? ¡Iqui'iruna huani ina'uqué maare! —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cinco mil ca'ajná achiñana i'imaño re. Inaana, yuhuaná, quele i'imaño caja re najhua'até. E Jesús quemari ra'apiyatéjenajlo: —Imá najló, nayá'acoloje pajhua'atéchaca cincuéntano, cincuéntano queja penaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","—Je —que nemacá rijló. E nemá najló, nayá'acoloje penaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ejomi Jesús ña'arí ricápojo pajluhua té'ela ca'alá pan, iyajmela jíñana hua'até. E riyacá'o je'echú chojé, rimá Tupánajlo: —Palá pila'acá huecá marí a'ajnejí aú. Ejomi ritupa'atá najló pan. Riyupa'atá caja jiña jepo'oná najló. Ra'á ra'apiyatéjenajlo ricá, natamáca'atacaloje najló ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Piyuqueja necá ajñaño na'ajnehuá namano'ocá ejé. Ejomi ra'apiyatéjena jahuacátaño rijlupemí yurícaro. Iyamá iphata ji'imaji nacojé ca'alá cuhuá'ala namano'otá pu'uteno raú. ");
INSERT INTO ycn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","E apú huacajé piño Jesús i'imari ra'apiyatéjena hua'até necámica que. Re ripura'ó Tupana hua'até. Ejomi rimá najló: —¿Meque ajopana ina'uqué quemacá nunacu? Nemá rijló: ");
INSERT INTO ycn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—Ne'iyajena quemaño pinacu: “Juan Bautizar la'ajeri ricá” que. Ajopana piño quemaño pinacu “Elías ricá” que. Ajopana piño quemaño pinacu: “Tupana puráca'alo ja'apátajeñomi chuna naquiyánami macápo'ocaro ricá”, que nemacá pinacu. ");
INSERT INTO ycn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","E Jesús quemari najló: —Eta icá ta, ¿meque imacá nunacu? Pedro quemari rijló: —Tupana huacára'acare majó ina'uqué i'imatájeri penaje picá. ");
INSERT INTO ycn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús quemari najló: —A'a. Pa. Imaniya ajopánajlo nuyucuna naca nucá. ");
INSERT INTO ycn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Quéchami rimacá najló: —Ina'uquéjloje penaje i'imacá nucá. Nujña'ajé cajrú chapú caje yajhué panacu. Peñahuilana, sacerdótena huacára'ajeño, Tupana nacú jehuíña'atajeño, quele uncá huani huátalaño nucá. Chapú nala'ajica nucá. Nahuacára'aje nonócana. E'iyonaja hueji que cala i'imajemi ejomi numacápo'ojo piño nopumí chuhuá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","E rimá piyuque najló: —Marí que ricá ijló, huátaño nujhua'atéjena i'imacana. Nenoje ca'ajná icá, nujhua'atéjena i'imacale. Hue'echú ca'alá queja ca'ajná ri'imajica ijló marí que. Ihue'epíniya inacuhuá; jácho'oniyo caja nujhua'atéjena i'imacana chiyá rijimaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Re ina'uqué naquiyana nahue'epí caí nanacuhuá. Uncá nahuátala ajopana la'acá necá chapú. Ñaquele uncá ne'emalá nujhua'atéjena. Marí que i'imacaño capichájeño Tupana liyá. Eyá uncá hue'epílaño caí nanacuhuá, ne'emacáloje nujhua'atéjena penaje, i'imajeño matajnaco je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Iná ña'aquela inajluhua piyuque nacaje eja'ahuá chu i'imacare, uncá na penaje calé ri'imajla inajlo, iná capichácojla Tupana liyá rilanaquiya. ");
INSERT INTO ycn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Re ina'uqué, napáña'o no'opí ajopana ina'uqué e'iyá. Ñaqué caja napáña'aco nupuráca'alo ja'apí ne'iyá. Nupa'ajico je'echú chiyá majó huacajé, ñaqué caja nopáña'ajico na'apí. Ina'uquéjloje penaje i'imacá nucá. Piyuque ina'uqué huacára'ajeri penaje nuphájica je'echú chiyá majó. Nora'apá hua'atéjena, je'echú chu i'imacaño, quele hua'até nuphaje. Cajrú mejáma'atani i'imajica huanacu. ");
INSERT INTO ycn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tupana i'imajeri ina'uqué naquiyana huacára'ajeri. Re e'iyajena maare, amájeño rijhua'atéjena la'acá rihuacára'aca que. Ri'imajica penaje ejo'ocaja inaquiyana i'imajica marí eja'ahuá chu rihuacajé —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Marí que rimacá najló i'imacá. E caja hueji que cuhuá'ata que cala quetana ca'ajná ne'emacá re. Ejomi Jesús jácho'oro ipuré i'ihuátaje Tupana hua'até pura'ajó. Rihuá'a rijhua'ató Pedro, Santiago, Juan, quele. ");
INSERT INTO ycn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","E caja nephá rejo. Jesús pura'acó Tupana hua'até ee rijimá apiyácaro. Jareni huani, sereni que ra'arumacá apiyácaco rijhua'ató. ");
INSERT INTO ycn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Mana'í chiyó iyamá ina'uqué ja'acó rejé pu'uhuacajé cajrú mejáma'atani hua'até. Pajluhuaja i'imari Moisesmi chu, apú i'imari Elíasmi chu. E napura'ó Jesús hua'até chapú caje yajhué rijña'ajícare panacu Jerusalén e. Méqueca nenójica ricá re Tupana pechu nacú ri'imacá que, nacú napura'ó pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","A'apona que tapú chá'ataca Pedro, rijhua'atéjena quele. E'iyonaja uncá nacamátalo. Aú namá cajrú mejáma'atani Jesús nacú. Ñaqué caja namaca mejáma'atani iyamá ina'uqué tára'aco rijhua'até nacú. ");
INSERT INTO ycn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ejéchami ina'uqué, iyamá i'imacaño, capichaco Jesús ahua'ayá sujhuí que. Ejéchami Pedro quemacá Jesusjlo: —Huehuíña'atajeri ¡meque palá huecá maare! I'ijná huala'achí hueji quele ca'apejé maare, pajluhuala pijló, apalá caja Moisesjlo, apalá caja Elíasjlo —que rimacá rijló. Majopeja rimacáchojonaja calé rimacá. Uncá rihue'epila na penájeca rimacá marí que. ");
INSERT INTO ycn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Marí que Pedro quemacá. Ejéchami juni suhuáca'ala itaca nachá. E naquero'ó. ");
INSERT INTO ycn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Re'iyá caja Tupana quemari najló: —Ilé nu'urí, íqui'ija nuhuátacare ricá. Jema'á ra'apiyá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Marí que rimacá najló ejomi Jesusja calé namá. E napa'ó. Uncá ne'emaqué ajopánajlo riyucuna. Napechu nacuja ri'imaqué. ");
INSERT INTO ycn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nahuitúca'a ipuré naquiyá i'imacá. E muní que cajrú ina'uqué iphaño Jesús nacú. ");
INSERT INTO ycn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","E pajluhuaja nanaquiyana quemari caphí Jesusjlo marí que: —Huehuíña'atajeri, pila'á nojló nacaje. Pamicha caji nu'urí. Pajluhuaja ñani ricá. ");
INSERT INTO ycn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Re jiñá pechu re'iyá. Richá'atacachu ricá, cajrú rahuíyo'oca. Hua'ató que ritaca'ataco. Raú quemu'ureni jeño'ocá rinuma chiyá. Quehuí huani jiñá pechu la'acá ricá. Uncá rihuatána'atala ricá quehuini chiyá. ");
INSERT INTO ycn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Caja numíchajla pa'apiyatéjenajlo, naca'acáloje jiñá pechu re'iyayá penaje. E'iyonaja uncá meño'ojó naca'alacha ricá re'iyayá —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","E Jesús quemari najló: —¡Meque uncá huani ipechu i'imalá nochojé caphí! Pu'uhuaré la'acaño icá. ¿Me quetana júpica nujña'ajica panacu icá? ¿Me quetana júpica nu'umacajla ijhua'até, ihue'epícaloje rinacojé nuliyá penaje? E rimá rara'apajlo: —Majó pihuá'icha pi'irí. —Je —que. ");
INSERT INTO ycn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Rihuá'a ri'irí Jesús jimajo. Eja jiñá pechu cojno'ótari pajimó yuhuají te'erí e'iyajé. Hua'ató que ritaca'ataco. Eyá Jesús aca'arí jiñá pechu. Rica'á re'iyayá ricá. Ejomi palánija ri'imacá. E rimá rara'apajlo: —Marí pi'irí. ");
INSERT INTO ycn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ramájeño pechu i'imá Jesús nacú: “¡Meque piyuque huani rila'acá Tupana Pechu aú!” Ina'uqué i'ijnataño napéchuhua Jesús la'acare nacú. E Jesús quemari ra'apiyatéjenajlo: ");
INSERT INTO ycn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Jema'á marí palá. Ipechu capicháñaniya marí: ina'uquéjloje penaje i'imacá nucá. Na'ajé ajopana ina'uquejlo nucá, nala'acáloje chapú nucá nahuátaca que penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","E'iyonaja uncá nahue'epila meque quemacánaca rimacare rinacuhuá najló. Me'echuje ri'imacá najló. Uncá caja naquejá'ala riliyá riyucuna, nahuó la'acole ra'apejé. ");
INSERT INTO ycn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","E caja ra'apiyatéjena aca'ácaño pajhua'atéchaca naca chá'atari ne'iyayó nacaje la'acana aú. Rijimaje naca'ácaco pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús hue'epiri méqueca napechu i'imacá. Aú rihuá'a pajluhuaja yuhuají rejo. Ritára'ata ricá rahua'ajó. ");
INSERT INTO ycn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","E rimá najló: —Re ca'ajná apú, ra'á marí caje yuhuají ñaté, nujhua'ateje ri'imacale. Raú iná hue'epí íqui'ija rihuátaca caja nucá Nora'apá hua'até. Ilé huacára'ari nucá majó. Re ina'uqué naquiyana, uncá la'alaño nanacuhuá hue'epiño que. “Ajopana ñaté a'ajeño huecá”, que napechu nanacuhuá. Palani nojló ilé que péchuruna. Necá chá'ataño ajopana nujhua'atéjena. ");
INSERT INTO ycn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","E Juan quemari rijló: —Huehuíña'atajeri, a'ajná ño'ojó huamá apú ca'acá jiñana pechu ajopana ina'uqué e'iyayá. Pipuráca'alo aú rica'á ne'iyayá jiñana pechu. Uncá huanaquiyana calé ricá. Aú huahuíyo'o rijló richá. ");
INSERT INTO ycn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús quemari rijló: —Uncá paala imacá rijló ñaqué. Uncachu apú la'alá huecá chapú, rila'á huecá palá. Huanaquiyana ricá. ");
INSERT INTO ycn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yehuicha riphaca rená chojé, Jesús jácho'ocoloje je'echú chojé penaje. Ñaquele rila'á caphí ripéchuhua, ri'ijnacáloje Jerusalén ejo penaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ñaquele rihuacára'a ajopana iyamá ritucumó Samaria te'eré ejo, ne'ejnacáloje pají culaje najluhua pajimila ejo penaje. Nacamátacoloje richu rapunana chu penaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Aú ne'ejná rejo pají culaje. E'iyonaja uncá re i'imacaño huátalaño Jesús. Rihuátaca pachá Jerusalén ejo i'ijnacana uncá nahuátala ricá. ");
INSERT INTO ycn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","E napa'ó. Ne'emá najló riyucuna. Aú Santiago, Juan, quele, ra'apiyatéjena ne'emacá, quemaño Jesusjlo: —Huahuacára'ajeri, ¿e pihuátaca huacapichátaca necá quera'atani je'echú chiyaje aú? Júpimi Elíasmi chu huacára'ari quera'atani ja'acó je'echú chiyá ajopana cha. ¿Ñaqué caja chi pihuátaca huacapichátaca necá? ");
INSERT INTO ycn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Raú Jesús yacá'aro nachaje. Raca'á necá, rimá najló: —Uncá ihue'epila méqueca ipechu apojó huani. ");
INSERT INTO ycn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Uncá ilé caje penaje calé nu'ujná majó. Uncá nucapichátacaloje ina'uqué penaje calé nu'ujná majó. Nu'umatácaloje ina'uqué capichácajo liyá penaje nu'ujná majó. Ina'uquéjloje penaje i'imacá nucá —que Jesús quemacá najló: E ne'ejná apú pajimila ejo. ");
INSERT INTO ycn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na'apá ají que iñe'epú chuhuá ajopana hua'até. E apú quemari Jesusjlo: —Huahuacára'ajeri, nuhuata pijhua'até i'ijnacana meño'ojoca pi'ijnajica ejo. Jesús quemari rijló: ");
INSERT INTO ycn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","—Re camejérinajlo pucunaji, nacamátacoloje richu penaje. Cuphira'apánajlo re caja nañacaré najló. Eyá nojló, uncá pucunaji i'imalá, nuhuatána'acaloje richu penaje. Ina'uquéjloje penaje i'imacá nucá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","E Jesús quemari apujlo: —Pi'ijná nujhua'até. Aú rimá rijló: —Nuhuata nuñacaré ejo pa'acano pamineco. Nuhuata nora'apá tami sa'acana ritaca'ajica ejomi —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús quemari rijló: —Uncá hue'epílaño Tupana nacojé, necá sa'ajeño caja taca'acaño tami. Pijló numá, pi'ijná, pi'imacáloje Tupana yucuna ajopana ina'uquejlo penaje, ne'emacáloje rijhua'atéjena penaje ra'apiyá jema'acana aú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","E apú piño quemari Jesusjlo: —Nuhuata pijhua'até i'ijnacana. Pamineco piyurí nupa'acó nuñacaré ejo, nu'umacáloje nuyucuno nojénajlo penaje. ");
INSERT INTO ycn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús quemari rijló: —Apú ca'ajná queño'orí nuhuátaca que la'acana hue'epícana ritucumó. E'iyonaja pajñacani rihuata jo'ó nacaje la'acana rijluhua rihuátaca que. Ilé que i'imacaño uncá i'imalájeño Tupana hua'atéjena naquiyana. ");
INSERT INTO ycn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","E caja Jesús i'ihuapari achiñana ne'iyayá iyamano que, rihuacára'acaloje necá ritucumá penaje. Rihuata cajrú pajimila ejo i'ijnacana. Rejo rihuacára'a necá ritucumó. Setenta ne'emacá piño. ");
INSERT INTO ycn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","E rimá najló marí que: —Re cajrú huani ina'uqué marí eja'ahuá chu, nema'ájla Tupana ja'apiyá, ajopana i'imaquela riyucuna najló. E'iyonaja calé uncá riyucuna i'imajeño i'imalá. Re necá huejápaja. Ipura'ó Tupana hua'até, rihuacára'acaloje ina'uqué riyucuna i'imajé ajopánajlo, ajopánajlo que penaje. ");
INSERT INTO ycn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Chuhua i'ijná. Mayuchéruna icá. E'iyonaja nuhuacára'a icá pu'uhuaré péchuruna ejo. ");
INSERT INTO ycn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ijña'aniya ijhua'ató liñeru, itulané, ji'ima'ulá caje. Imalá'ataniya icó iñe'epú chuhuá ajopana ajalácana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Imujlúca'ajica ee pají chojé, ajalácaje necá. Marí que imájica ile pají chiyájenajlo: “Eco Tupana la'á ipechu palá.” ");
INSERT INTO ycn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Palá péchuruna ne'emajica ee, ipura'ó nanacu Tupana hua'até, rila'acáloje necá palá penaje. Eyá chapú péchuruna ne'emajica ee, ipura'ó Tupana hua'até nanacu, rila'acá piyá necá palá. ");
INSERT INTO ycn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Palá péchuruna i'imajícaño ñacaré chu iyurejo najhua'até. Ajñaje a'ajnehuá na'ajícare ijló. I'irajé caja i'iracaje na'ajícare ijló. Icá la'ajeño najló nacaje. Ñaquele isápaca'ala huemí que caja ijló a'ajnejí. Iná sápacachu apujlo, ra'á inajlo iná sápaca'ala huemí. Iphájica ee palá péchuruna ñacaré chojé, re iyuró najhua'até. I'ijnaniya apú chojé, apú chojé que. ");
INSERT INTO ycn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Iphaje ca'ajná apú pajimila ejo; palá ca'ajná napechu i'imajica inacu. Najhua'até iyuró. Ajñaje caja a'ajnejí na'ajícare ijló. ");
INSERT INTO ycn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Natámina i'imajica ee re, itejmo'ótaje caja necá. Marí que imájica najló: “Mequetánaja i'imajemi Tupana i'imajeri ina'uqué naquiyana huacára'ajeri”. ");
INSERT INTO ycn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Iphaje ca'ajná apú pajimila ejo; chapú ca'ajná napechu i'imajica inacu. Marí que ne'emajica ee, ja'apaje pajimila nacuhuá. Marí que imájica najló: ");
INSERT INTO ycn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mu'upé patacaro hue'emá nacú marí pajimila naquiyaje, hualaca hue'emá naquiyá ricá ijimaje, ihue'epícaloje raú pu'uhuaré ila'acá, uncale ihuátala huecá”, que imájica najló. Imaje caja najló: “Ihue'epí marí: Mequetana i'imajemi Tupana i'imajeri ina'uqué naquiyana huacára'ajeri”, que imájica najló. ");
INSERT INTO ycn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tupana huajájica pu'uhuaré la'ajeño, namanaicho la'ajeño huacajé, rihuajaje ilé pajimila eruna cajrú, uncá pachá nahuátala icá. Iqui'i rihuajájica pajimila Sodoma erúnami chuna pu'uhuaré nala'acare pachá. Richaje rihuajájica necá uncá huátalajeño icá —que Jesús quemacá rihuacára'acarenajlo. ");
INSERT INTO ycn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Marí que Jesús quemacá pajimila eruna nacú i'imacá: —Chapú huani ri'imajica Corazín erúnajlo. Ñaqué caja ri'imajica Betsaida erúnajlo. Cajrú huani nula'acá Tupana Pechu aú nacaje uncá meño'ojó iná la'alare rehuá i'imacá. Ñaqué caja Tupana la'aquela pajimila Tiro e, pajimila Sidón e i'imacá, napajno'otácajla napéchuhua raú pu'uhuaré nala'acare liyá. Na'ájla nanacuhuá cotari caje na'arumacá penaje. Naca'ájla caja nachó siyá pa'ilá, ina'uqué hue'epícaloje caja napajno'otaca napéchuhua pu'uhuaré nala'acare liyá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tupana huajájica pu'uhuaré la'ajeño, namanaicho la'ajeño huacajé, rihuajaje cajrú Corazín eruna, Betsaida eruna, quele. Cajrú rihuajájica pajimila Tiro erúnami chuna, Sidón erúnami chuna, quele, pu'uhuaré la'ajeño huani ne'emacale. Chaje huani rihuajájica Corazín eruna, Betsaida eruna, quele. ");
INSERT INTO ycn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Eyá pajimila Capernaum e i'imacaño i'imaño piño marí que. Napechu i'imá nanacuhuá: “Je'echú chu i'imajícaño penájena huecá” que. E'iyonaja uncá ñaqué calé ri'imajica najló. Cahuacaje naca'ajé necá, nacapichácoloje penaje —que Jesús quemacá pajimila eruna naquiyana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","E Jesús quemari ra'apiyatéjenajlo: —Ja'apátaje ca'ajná ajopánajlo nupuráca'alo. Pu'uhuacá nema'ajica ja'apiyá, nema'ajé caja no'opiyá. Eyá uncá huátalajeño icá, uncá caja huátalajeño nucá. Uncá huátalaño nucá, uncá caja huátalaño Nora'apá Tupana. Ricá huacára'ari nucá majó. ");
INSERT INTO ycn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesús huacára'ari setenta ina'uqué apú eyá, apú eyá que i'imacá. Necá penájenami pa'añó piño napumí chuhuá. Pu'ují napechu i'imacá. E nemá Jesusjlo: —Hue'emacana, pipuráca'alo aú jiñana pechu jema'añó hua'apiyá, huaca'acáloje necá ajopana ina'uqué e'iyayá penaje —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús quemari najló: —Nucá amari Jiñá Chi'ináricana ja'acó je'echú chiyá i'imacá. Pichaní camaré ja'acó que caja ra'acó cahuacaje. ");
INSERT INTO ycn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nucá chá'atari ina'uquejlo Jiñá Chi'ináricana. Jeí ajma'ajica ee icá, uncá na ila'alajo raú. Ipijí i'irajica ee icá, uncá caje ila'alajo raú. ");
INSERT INTO ycn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pu'ují ipechu me'etení, ica'acale jiñana pechu ina'uqué e'iyayá. Ipechu i'imaniya pu'ují raú ja calé. Ipechu i'imá caja pu'ují, i'imajícale Tupana hua'até je'echú chu. Caja lana'aquéjami ií ripapérane chu, re i'imajeño penájena i'imacale —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ejéchami Tupana Pechu la'acá Jesús pechu pu'ují. Aú rimá Tupánajlo: —Nora'apá, Huahuacára'ajeri huani picá. Eja'ahuá, je'echú, caje minaricana caja picá. Palá pila'acá nucá, pila'acale ina'uqué naquiyana palá. Yuhuaná pechu queja napechu, uncale nala'alá necó hue'epiño que necá. Pila'acale napechu palá, nahue'epí nacaje numacare nacojé. Eyá cajrú jehuíña'acañojlo, capéchurunajlo me'echuje jo'ó ricá. Caja queja pihuátaca najló ri'imacá —que rimacá Tupánajlo. ");
INSERT INTO ycn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Rimá piño rema'ajéñojlo: —Nora'apá quemari nojló piyuqueja puráca'aloji nacú. Uncá na calé hue'epiri na huánica nucá, Tupana I'irí. Nora'apá, Tupana, ricaja calé hue'epiri mecajeca nucá. Ñaqué caja uncá na calé hue'epica na huánica Nora'apá, Tupana. Nucá, Ri'irija calé hue'epiri mecajeca ricá. Nucaja calé i'imari nuhuátacarenajlo riyucuna, nahue'epícaloje naca ricá penaje —que rimacá. ");
INSERT INTO ycn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Eyá Jesús pajno'oró ají que ra'apiyatéjena ejo. Najloja calé rimá marí que: —¡Meque palá huani ijló, amácale nacaje nula'acare e'iyohuá! ");
INSERT INTO ycn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ñaquéjlaca cajrú Tupana puráca'alo ja'apátajeñomi chuna, ne'emacánami chuna, quele huátacajla nacaje amácana ne'emaqué eja'ahuá chu huacajé. E'iyonaja uncá meño'ojó namala ricá rihuacajé i'imacá. Ñaquéjlaca nahuátacajla nupuráca'alo jema'acana jema'acá ricá que caja. E'iyonaja uncá caja nema'alajla ñaqué rihuacajé —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","E caja pajluhuaja Tupana puráca'alo nacú jehuíña'atajeri iphari Jesús nacú. Rihuata nacaje yucuna quejá'acana riliyá, ramácaloje méqueca rimájica rijló penaje. Aú rimá rijló: —Huehuíña'atajeri, ¿meque nula'acajla, nu'umacáloje matajnaco je'echú chu raú penaje? ");
INSERT INTO ycn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","E Jesús quemari rijló: —¿Meque chi Tupana puráca'alo lana'aquéjami quemacá? ¿Meque chi pipechu rinacu? ");
INSERT INTO ycn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tupana puráca'alo nacú jehuíña'atajeri quemari rijló: —Marí que Tupana puráca'alo lana'aquéjami quemacá: “Huahuacára'ajeri Tupana. Ricaja calé Iná Chi'ináricana. “Pihuata íqui'ija ricá. Pihuajhué ricá. Pi'ijnatá caja pipéchuhua rinacu. Pehuíña'o caja nacaje nacú, ri'imacáloje palá rinacu penaje. Pila'á caja piyuqueja nacaje, ri'imacáloje palá rinacu penaje. Marí que pila'acá, pihuátacale ricá íqui'ija. Pihuata caja íqui'ija piyuque ina'uqué, pihuátaca picó que caja —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Eyá Jesús quemari rijló: —Palá pa'ajipichaca nojló. Richuhuaja caja pila'ajica ñaqué, pi'imacáloje matajnaco je'echú chu raú penaje —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tupana nacú jehuíña'atajeri pechu i'imari rinacuhuá: “Palá la'ajeri nucá” que. Raú rimá piño Jesusjlo: —¿Mecajena ina'uqué iná huátaca íqui'ija, iná icó que caja? ");
INSERT INTO ycn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Raú Jesús i'imari marí yucu rijló: —Pajluhuaja ina'uqué jácho'ocharo Jerusalén eyá. I'ijichari cahuacajo pajimila Jericó ejo. Iñe'epú chuhuá ra'apicha. Ehuá ajopana ata'acáchina ipháquichaño rijhua'até. Re nachi'iyá riliyá rinane piyuque ra'arumacá hua'ató. Cajrú naña'achíyaca ricá rinane chona. E na'apicha piño. Rejeja nayuricha ritami iñe'epú turenaje. Ujú caje chiyoja ritaqui'ichácajla. ");
INSERT INTO ycn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","E ricaja caja iñe'epú chuhuá apú ina'uqué ja'apíchari ají que ritami loco'opani. Sacerdote ri'imichá. Ramicha ritami to'ocó. E ra'apicha pu'ucuja rahua'ayá. ");
INSERT INTO ycn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","E apú ja'apíchari piño ricaja caja iñe'epú chuhuá. Levítami chu laquénami naquiyana ri'imichaca. Nañaté a'ajeri ri'imichá Tupana ñacaré chu. Ricá ja'apíchari ají que, amíchari ritami to'ocó re. Riyacá'icho richaje mequetánaja; ejomi ra'apicha piño. ");
INSERT INTO ycn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","E apú piño i'ijichari ricaja caja iñe'epú chuhuá. Samaria te'eré eyaje ri'imichaca. Ricá hue'epíchari rinacu camu'ují ramíchaca aú ritami to'ocó. ");
INSERT INTO ycn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ritajicho ritami nacojé. Eyá caja ripusáni'icha ricá. Raco'ochá nacaje jilami raphú chojé. Raco'ochá piño nacaje jalá amúra'atacanami richojeja caja. Ejomi repo'ochiya ricá a'arumacaji jítami aú. Ejomi rácho'ochiya ricá ají que ricahuarute janapeje. Rinacu rihuá'icha ricá ají que a'ajná ño'ojó apú ñacaré chojé. Re rihuojíchiya ricá. ");
INSERT INTO ycn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","E muní que ri'ijnacá yámona, ra'achá pají mináricanajlo liñeru. Rimicha rijló: “Eco pihuojita cari ina'uqué, ritami. Marí chaje liñeru pica'ajica ee rinacojé, nunacuhuá nupa'ataje pijló ricá rapumí chojé”, que rimíchaca rijló. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Marí caje aú Jesús quemari piño Tupana puráca'alo nacú jehuíña'atajerijlo: —Hueji quele ne'emacá amaño ritami to'ocó. Chapú ata'acáchina la'acare ri'imacá. ¿Mecaje chi huátari ricá íqui'ija rihuátaca ricó que caja? ");
INSERT INTO ycn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aú Tupana puráca'alo nacú jehuíña'atajeri quemari rijló: —Ilé hue'epiri rinacu camu'ují, huátari ricá rihuátaca ricó que caja. Jesús quemari rijló: —Chuhua pi'ijná. Eco pila'á ajopana ina'uqué palá. Rila'acá ricá palá que caja pila'ajica necá palá ca'ajnó —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús ja'apari ají que a'ajná ño'ojó ra'apiyatéjena hua'até. E caja nephá pajimila ejo. Re apa'ahuelo i'imayo. Ruí i'imari Marta. Rucá huátayo Jesús i'ijnacá nachaje nañacaré chojé. Raú Jesús i'ijnari rejo. ");
INSERT INTO ycn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta e'ehueló i'imayo. María ruí i'imacá. Rucá yá'ayo Jesús ji'ilá, roma'acáloje ripuráca'alo penaje. ");
INSERT INTO ycn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Eyá Marta cahuíla'ayo rusápaca'ala nacojé. Aú ru'ujná Jesús ahua'ajé; rumá rijló: —Huehuíña'atajeri, ¿Meque pijló quelerú? Uncá ro'olá nuñaté. Nuchaja ruyurí huasápaca'ala aú. Pihuacára'a ro'ocá nuñaté —que rumacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús quemari rojló: —Marta, ¿naje cajrú huani picahuíla'aco cajrú nacaje nacojé? Mahuó huani pila'acá picó rinacojé. ");
INSERT INTO ycn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Re nacaje palánija inajlo apú ijlunami chojé. Marirú hue'epiyo mecajeca ricá. Rucá jema'ayó nupuráca'alo. Uncá na calé quemájeri rojló, roma'acá piyá nupuráca'alo —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Apú huacajé Jesús pura'aró piño Tupana hua'até. Riyurí caja rijhua'até pura'acano ee pajluhuaja ra'apiyatéjeri quemari rijló: —Huahuacára'ajeri, pehuíña'ata huecá Tupana hua'até pura'acano nacú. Juanmi chu jehuíña'atajica ra'apiyatéjenami que caja pehuíña'ataca huecá. ");
INSERT INTO ycn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús quemari najló: —Ipura'ajico ee Tupana hua'até marí que imájica rijló: Huara'apá, je'echú chu i'imacare. Palájne'eque huani picá. Piyuqueja ina'uqué huacára'ajeri penaje picá. Huahuata caja pi'imacá Huahuacára'ajeri. Huahuata caja ina'uqué la'acá maare eja'ahuá chu nacaje pihuátaca que, je'echú chu nala'acá que caja. ");
INSERT INTO ycn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pa'á huajló a'ajnejí chuhuajá, huajñácaloje penaje. ");
INSERT INTO ycn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pamó huachaje pu'uhuaré huala'acare liyá, huamaco ajopana chaje chapú nala'acare huecá liyá que caja. Piyuríniya nacaje a'acá huame'é rijluhua, huala'acá piyá pu'uhuaré raú. Pi'imatá caja huecá pu'uhuaré la'ajeño huacára'ajeri liyá. Marí que ipura'ajico Tupana hua'até —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús quemari piño ra'apiyatéjenajlo: —Apú ca'ajná i'ijnari lapí jenaji que, palá péchuri rinacu ejo, a'ajnejí quejá'aje riliyá. Riphá rejo. E rimá rijló: “Majó nu'ujichá a'ajnejí chaya”. ");
INSERT INTO ycn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Huajé nuteló iphíchaca nunacu. Ya'ajnaya ri'ijichá majó. Uncá no'ojné i'imalá, no'ocáloje rijló penaje”, que ca'ajná rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Raú ca'ajná rimá rijló riñacaré chiyá: “Picahuíla'aniya nunacu. Nucamátaco huani nuyani hua'até maare. Caja chahuíña'aqueja pají numaná. Uncá meño'ojó nócho'olo pijló nacaje a'ajé me'etení”, que ca'ajná rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jesús quemari piño najló: —Numá ijló, apala uncá rácho'olajo quiñaja rijló nacaje a'ajé, palá péchuri rinacu ri'imacale. Mahuó rila'aquéjami rácho'ojo piyuque nacaje rihuátacare a'ajé rijló. ");
INSERT INTO ycn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ñaquele numá ijló, iquejá'a nacaje Tupana liyá. Raú ra'ajé ijló ricá. Iculá caja Tupana liyá nacaje. Raú iphátaje ricá. Imá caja rijló, rijme'etachi ijló nacaje apu. Raú rijme'etaje ijló rapu. ");
INSERT INTO ycn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Riliyá nacaje quejá'ajeñojlo ra'á nacaje. Riliyá culájeño iphátaño nacaje. Rijló quemájeñojlo rijme'etá rapu. ");
INSERT INTO ycn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Uncá na calé a'arí ri'irijlo jipa, riquejá'acachu riliyá cujnú. Uncá caja na calé a'arí ri'irijlo jeí, riquejá'acachu riliyá jiña. ");
INSERT INTO ycn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Uncá caja na calé a'arí ri'irijlo ipijí, riquejá'acachu riliyá capérejhue. ");
INSERT INTO ycn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Icá, pu'uhuaré la'ajeño, hue'epiño iyánijlo nacaje a'acana palani. Eta, Jara'apá, je'echú chu i'imacare, hue'epiri ichaje huani nacaje palani a'acana rijhua'atéjenajlo. Ra'á riliyá quejá'ajeñojlo Ripechu. ");
INSERT INTO ycn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús ca'arí jiñá pechu apú ina'uqué e'iyayá i'imacá. Jiñá pechu nacojé uncá meño'ojó ripura'aló. Rica'acá ricá re'iyayá ejomi ripura'acó palá. Marí que ajopana amaca aú napechu i'imá Jesús nacú: “¡Meque piyuque huani rila'acá!” ");
INSERT INTO ycn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Eyá ajopana piño quemaño marí que rinacu: “Beelzebú, jiñana huacára'ajeri ricá. Ripechu aú rica'á jiñana pechu ina'uqué e'iyayá.” ");
INSERT INTO ycn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ajopana piño huátaño ratá'acana. Nahuata rila'acá nacaje Tupánaja calé hue'epícare la'acana caje. Rená que'ená penaje nahuata rila'acá najló ricá, nahue'epichi ricá raú. ");
INSERT INTO ycn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús hue'epiri méqueca napechu nacú ri'imacá. Nemá rinacu i'imacá: “Jiñana huacára'ajeri pechu aú rica'á jiñana pechu ina'uqué e'iyayá.” Aú rimá najló: —Ajopana ina'uqué huacára'ajeri hua'atéjena nócaquelo pajhua'atéchaca, nacapichátajla pecohuácaca raú. Iná ejena nócaquelo pajhua'atéchaca, ñaqué caja nacapichátacajla pecohuácaca raú. ");
INSERT INTO ycn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ñaqué caja ricá Jiñá Chi'ináricanajlo. Jiñana pechu rijhua'atéjena. Rica'aquela rijhua'atéjena ina'uqué e'iyayá, rila'ájla ricó chapú raú. Uncá meque rila'alajla rejomi, uncale rijhua'atéjena i'imalajla raú. Marí que numacá ijló, imacale nunacu: “Beelzebú, jiñana huacára'ajeri pechu aú rica'á jiñana pechu ina'uqué e'iyayá”. ");
INSERT INTO ycn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Marí que imacá nunacu. ¿Ñaqué caja chi imacá ja'apiyatéjena nacú? Necá caja ca'añó jiñana pechu ina'uqué e'iyayá. Necá caja hue'epiño uncá paala ipechu. ");
INSERT INTO ycn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tupana Pechu aú ja calé nuca'á jiñana pechu ina'uqué e'iyayá. Ñaquele marí caje aú iná hue'epí caja Tupana queño'ocá ina'uqué naquiyana huacára'ajeri i'imacana. ");
INSERT INTO ycn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","E Jesús i'imari yucu najló, nahue'epícaloje raú richá'ataca Jiñá Chi'ináricana. Rimá najló: —Catejmuni ina'uqué amácachu riñacaré rilecare ricapi que, uncá na calé ata'arí rinane riliyá. ");
INSERT INTO ycn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Apú richaje catejmuca iphari ca'ajná rinacu. Ricá ca'ajná ca'arí rilecare riliyá, ri'imacare chojé caphí. Aú richá'ata ricá. Richá'ataca ricá ejomi rijña'atá rinane. Quéchami ritamáca'ataca ajopánajlo ricá. Marí que Jesús i'imacá yucu najló, nahue'epícaloje raú ricá chá'ataca Jiñá Chi'ináricana penaje. ");
INSERT INTO ycn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Rimá piño najló: —Uncachu ina'uqué naquiyana huátala nucá, chapú napechu nunacu. Uncachu nala'alá ina'uqué palá nujhua'até, napajno'otá napechu Tupana liyá apojó. ");
INSERT INTO ycn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—Jiñá pechu jácho'ocharo pajluhuaja ina'uqué e'iyayá. E ra'apicha te'erí macajreni nacuhuá. Riculicha rijluhua pucunaji, rihuatána'acaloje richojé penaje. E'iyonaja uncá riphátalacha ricá. E rimicha: “Nupa'ajícoja nuñacaremi ejo, ilé ina'uqué nócho'ocaro e'iyayá ejo”. ");
INSERT INTO ycn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aú ripi'ichó rapumí chuhuá. Rimujlúqui'icha re'iyajé piño. Amíchari palani ri'imichaca, lamá'ataquejami ri'imichaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Raú ri'ijichá piño ajopana jiñana pechu huá'aje. Iyamá cuhuá'ata quele rihuá'icha rijhuáque'ena penaje. Richaje chapújne'equenaca ne'emichaca. Necá piyuqueja mujlúqui'ichaño ilé ina'uqué e'iyajé, ne'emacáloje rihuacára'ajeño penaje. E caja penaje chapújne'eque huani ilé ina'uqué i'imichaca na'apiyá i'imacana aú. Júpimi ri'imacá chaje huani ri'imichá chapújne'eque. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Marí que Jesús i'imacá yucu cajrú ina'uquejlo i'imacá. Ejomi pajluhuájaru inanaru jahuíyo'oyo rijló. Marí que rumacá rijló: —¡Meque pu'ují ilerú pechu, huá'ayo pi'imacá, lamára'ayo pi'imacá! —que rumíchaca rijló raló nacú. ");
INSERT INTO ycn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","E Jesús quemari rojló: —Mariruna pu'ují péchuruna: jema'añó Tupana puráca'alo, hua'até a'añó nanacojó ricá. Necá cajena pu'ují péchuruna. ");
INSERT INTO ycn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Richaje, richaje que ina'uqué jahuacaco Jesús nacojé i'imacá. E rimá najló marí que: —¡Meque uncá huani ina'uquélaruna mariruna ina'uqué naquiyana me'etení i'imacaño! Nemá nojló, nula'acáloje nacaje najló Tupánaja calé hue'epícare la'acana. E'iyonaja uncá nula'alaje ijló ricá. Júpimi Tupana la'acá Jonasmi chujlo nacaje. Rila'acá rijló nacaje i'imacá que caja rila'ajica piño nojló nacaje. Ricá aú ja calé ihue'epeje nucá. ");
INSERT INTO ycn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tupana la'arí Jonasmi chujlo nacaje, Nínive e i'imacáñomi chuna hue'epichi ricá raú. Ina'uquéjloje i'imacá penaje nucá. Tupana la'ajeri caja nojló nacaje, ina'uqué me'etení i'imacaño hue'epichi nucá raú. ");
INSERT INTO ycn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Júpimi apa'ahuelo i'imayo i'imacá. Cahuacá i'imacaño i'imacánaru ru'umacá. Rucá i'ijnayo ya'ajnajo Salomonmi chu chaje ripuráca'alo jema'ajé. Hue'epiri huani ri'imacale, ru'ujná rejo i'imacá. Eyá maare nucá me'etení ijhua'até, Salomonmi chu chaje hue'epica nucá. E'iyonaja uncá a'alá inacojó nupuráca'alo. Rijimaje ne'emacánarumi cholo quemajeyo inacu, Tupana huajácaloje icá penaje. Me'etení i'imacaño nacú rumaje rijló rihuajájica ina'uqué huacajé. ");
INSERT INTO ycn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ñaqué caja Jonasmi chu i'imacá. Ricá i'imari Tupana yucuna Nínive e i'imacáñomi chúnajlo i'imacá. Aú napajno'otá napéchuhua pu'uhuaré nala'acare liyá Tupana ejo. Eyá maare nucá me'etení ijhua'até. Jonasmi chu i'imacá chaje nucá, i'imari ijló Tupana yucuna. E'iyonaja uncá ipajno'otala ipéchuhua pu'uhuaré ila'acare liyá Tupana ejo raú. Rijimaje Nínive e i'imacáñomi chuna quemájeño inacu, Tupana huajácaloje icá penaje. Me'etení i'imacaño nacú nemaje rijló rihuajájica ina'uqué huacajé. ");
INSERT INTO ycn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Iná lucúna'acachu iná camaró, uncá iná yá'atala ricá me'echuje chojé. Uncá caja iná yá'atala ricá i'ichilá lájma'ataqueja ja'apejé. Yenú iná yá'ata ricá, piyuque pachu i'imacaño amácaloje palá ricamaré chojé penaje. ");
INSERT INTO ycn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Iná pechu loco'opánija iná la'acá nacaje. Palá iná pechu i'imacachu, iná hue'epica caja piyuque nacaje la'acana palá. Uncachu iná pechu i'imalá palá, uncá caja iná hue'epila naca la'acana palá. Chapú huani nacaje i'imacá inajlo raú. ");
INSERT INTO ycn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pa. Pihue'epí méqueca pipechu. Apala uncá palani calé pipechu. Pipechu i'imá ca'ajná pinacuhuá: “Palani japi nupechu nujluhua.” ");
INSERT INTO ycn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pichuhuaje pi'imacachu palá péchuri, piyuque nacaje pila'acare i'imari palani caja ina'uquejlo. Iná amá palá nacaje ricamaré chojé, que caja ajopana ina'uqué amaca palani ricá pila'acare. ");
INSERT INTO ycn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús ñapátari yucu i'imacana najló. Ejomi pajluhuaja fariséona naquiyana quemari Jesusjlo: —Pi'ijná nujhua'até nuñacaré ejo, pajñachi pa'ajnehuá rejo nujhua'até. —Je —que rimacá. Aú ri'ijná rijhua'até. Rimujlúca'a riñacaré chojé. Re riyá'o, rajñácaloje ra'ajnehuá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ilé fariseo amari uncá Jesús ipala riyáte'ela chiyá rajñaca ra'ajnehuá piyá peñahuilánami chuna quemacá que. Raú ripechu i'imá: “¿Naje chi rila'á ají que huani? Uncá paala.” ");
INSERT INTO ycn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","E Jesús quemari rijló: —Apú ca'ajná ipari riparatune huajlé naquiyá, ripá ca'ajná ri'iracú huajlé naquiyá caje. Eta richiyá uncá ripala. Ñaqué caja icá fariséona. Icá ipaño iyáte'ela chiyá, inapona naquiyá caje. E'iyonaja uncá lamá'ataqueja calé ipechu Tupánajlo. Aú calé ihuata ijluhua piyuque nacaje ña'acana. Chapú ila'acá ina'uqué, ijña'acáloje naliyá nacaje ijluhua penaje. ");
INSERT INTO ycn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mapéchuruna huani icá. Tupana la'arí nacaje piyuqueja i'imacá. Rila'á iná pechu; rila'á caja iná napona. ");
INSERT INTO ycn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","A'á camu'ují la'acáñojlo nacaje, i'imacáloje palá la'acaño raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Meque chapú huani ri'imajica ijló, icá fariséonajlo! Iyamá té'ela quele a'ajnejí puní ejátacare naquiyana icá a'añó pajluhuaja Tupánajlo. Raú ca'ajná ipechu i'imá inacuhuá: “Palá la'acaño huecá” que. Uncá paala ila'acá, uncale ihuátala Tupana íqui'ija. Uncá caja ila'alá palá ajopana ina'uqué. Chuhua ila'á palá. Ihuata caja Tupana íqui'ija. Marí que la'acana, ricá a'acáreno rijló hua'ató, palani Tupánajlo. ");
INSERT INTO ycn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Meque chapú huani ri'imajica ijló, fariséonajlo! Ihuata ajopana ina'uqué pechu i'imacá inacu: “Ajopana chaje i'imacaño necá” que. Ñaquele ihuata natucumá yá'acano jahuacáca'alo ñacarelana chu. Ihuata caja ina'uqué ajalaca icá palá ja'apaca aú le'ejepelaji ñacarelana e'iyohuá. ");
INSERT INTO ycn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Chapú huani ri'imajica ijló Tupana puráca'alo nacú jehuíña'atajeñojlo, quele me'etení i'imacáñojlo. Pajlácachina huani icá. Icá la'añó icó palá la'ajeño que ina'uqué ijlú chu. E'iyonaja uncá ñaqué calé icá. Ajopana ina'uqué pechu i'imá inacu: “Palájne'equena japi necá” que. E'iyonaja chapújne'equena icá. Re ca'ajná támijimina ca'aquelana majopeja. Uncá ina'uqué hue'epílaño ri'imacá re. Raú na'apá re'iyohuá. Uncá nahue'epila támijimina ca'aquelánaca ricá. Ñaqué caja icá ina'uqué e'iyohuá. Uncá caja nahue'epila chapújne'equenaca icá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Eyá apú Tupana puráca'alo nacú jehuíña'atajeri quemari Jesusjlo: —Huehuíña'atajeri, ilé que pimíchaca aú pimicha huanacu: “Pu'uhuaré la'ajeño necá” que. ");
INSERT INTO ycn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús quemari rijló. —Que jo'ó ricá. ¡Chapú huani ri'imajica ijló, Tupana puráca'alo nacú jehuíña'atajeñojlo! Chapú ri'imajica ijló, ila'acale pu'uhuaré marí que: Icá huacára'año ajopana, nala'acáloje nacaje puhuichani huani penaje. Nacaje uncá meño'ojó iná la'alare caje, ihuacára'a nala'acá ricá. Eyá icá, uncá huani la'alaño nacaje najhua'até. Huejápaja ñani uncá caja ila'alá najhua'até —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Meque chapú huani ri'imajica ijló! ihuacára'acale nala'acá támijimina ca'aquelana palá nojé, naca'acáloje Tupana puráca'alo ja'apátajeñomi chuna aphinami richojé penaje. Ichi'inami chuna noño ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ilé que la'acana aú ina'uqué hue'epiño palani ijló chapú ichi'inami chuna la'acare i'imacá. Necá noño ne'emacá. Chuhuaca icá la'añó naphinami ñacarelana —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Hue'epícachi huani Tupana. Ñaquele rimá marí que inacu júpimi i'imacá: “Nuhuacára'aje nachaje nupuráca'alo ja'apátajeño, ne'iyajena nenoje. Ne'iyajena caja nala'ajé chapú”, que Tupana quemacá inacu i'imacá júpimi. ");
INSERT INTO ycn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Rimacá que rihuacára'aca necá i'imacá. Necami chuna, ichi'inami chuna noño i'imacá. Tupana huajájeri icá, chapú ichi'inami chuna la'acare i'imacá chona. Eja'ahuá queño'ocó eyá maárejecha huecá. Re'iyá nenócarena chona rihuajaje pu'uhuaré la'acaño, me'etení i'imacaño. ");
INSERT INTO ycn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelmi chu nócana aú riqueño'ó najló i'imacá. Pumí chiyó ajopana piño, ajopana piño que nenoca ne'emacá. Caja penaje nenócare i'imari Zacaríasmi chu. Tupana ñacaré copi, mesa yámojo ucapú ahua'á nenó ri'imacá. Numá ijló, Tupana huajájeri pu'uhuaré la'acaño, me'etení i'imacaño, necá ichi'inami chuna nócarena chona. ");
INSERT INTO ycn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Chapú huani ri'imajica ijló, Tupana puráca'alo nacú jehuíña'atajeñojlo, me'etení i'imacáñojlo! Tupana puráca'alo quemari méqueca ri'imataca iná capichácajo liyá. Uncá jehuíña'atala ina'uqué palá rinacu. Raú uncá nahue'epila rinacojé. Uncá caja ihue'epila rinacojé. Aú calé itá rapu ajopánajlo, nahue'epica piyá rinacojé —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Marí que rimacá aú. Tupana puráca'alo nacú jehuíña'atajeño, fariséona, quele yúcha'año richaje, ri'imacale najló ilé que nanacu. Ejomi namaque chapú ricá. Riqueño'ó reyá ja'apácana. ");
INSERT INTO ycn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ejéchami naculácataco rinacu, nemacáloje rinacu: “Pu'uhuaré la'ajeri ricá” que, rimacale nanacu: “Uncá paala nala'acá” que. ");
INSERT INTO ycn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Cajrú huani ina'uqué jahuacaño i'imacá. Mil chaje ne'emacá. Caja napayaca pe'emáchaca. E Jesús quemari ra'apiyatéjenajlo: —Ihue'epí méqueca fariséona la'acá necó palá la'ajeño que. E'iyonaja pu'uhuaré la'ajeño necá. ");
INSERT INTO ycn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Piyuque nacaje yucuna me'echú i'imacare me'etení, ajopana hue'epéjeño rinacojé. Piyuque nacaje me'echú i'imacare me'etení, amájero caja. ");
INSERT INTO ycn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nacaje imacare nacú apujlo lapí, nema'ajica riyucuna hue'echú, camú camaré japi. Nacaje imacare nacú apujlo ri'ijhuí chojé cachuhua ucapú itaqueja chu, riyucuna ne'emajé caphí ajopánajlo nahuacáca'alo ejé —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","E Jesús quemari piño najló: —Ijló numá, iquero'oniyo ina'uqué nójeño piyá. Iná napónaja calé nenó. Eyá iná pechu uncá meque nala'alá. ");
INSERT INTO ycn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Numaje ijló na piyaca iná quero'ocó: iquero'ó Tupana piyá. Ricá huá'ari iná péchumi. Rihue'epí caja iná ca'acana quera'atani uncá yacálare chojé. Ñaquele iquero'ó ripiyá. ");
INSERT INTO ycn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Mahuemiru iná huarúhua'aca maárohua iyamá cupira'aphana. Mahuemíruna huani necá. E'iyonaja Tupana amari necá palá. ");
INSERT INTO ycn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Cajrú cupira'aphana chaje huani íqui'ica rihuátaca iná. Rihue'epí iná nacú piyuqueja. Rihue'epí piyuque iná ihuilá nacojé méquelaca ricá. Ra'á caja rinacojó iná. Ñaquele iquero'oniyo ina'uqué nójeno piyá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesús quemari piño najló: —Re ca'ajná apú nujhua'ateje, uncá rapáña'alo no'opí ajopana ina'uqué e'iyá. Rimá najló nunacu: “Rijhua'ateje nucá” que. Ñaqué caja numájica ilé nacú Tupana hua'atéjena, je'echú churúnajlo. Numaje caja najló: “Nujhua'ateje ricá”. Marí que caja numájica rijló piyuque ina'uqué nacú, uncá micho'otálaño nuchaya ajopana ina'uqué e'iyá. ");
INSERT INTO ycn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Eyá apú nujhua'ateje ca'ajná apáña'aro no'opí ajopana ina'uqué e'iyá. Aú calé rimá najló marí que nunacu: “Uncá rijhua'ateje calé nucá”. Ñaqué caja numájica rinacu, Tupana hua'atéjena, je'echú churúnajlo. Numaje najló: “Uncá nujhua'ateje calé ricá”. Marí que caja numájica rijló piyuque ina'uqué nacú, micho'otaño nuchaya ajopana ina'uqué e'iyá. ");
INSERT INTO ycn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Ina'uquéjloje penaje i'imacá nucá. Pu'uhuaré ina'uqué quemacare nunacu liyá, Tupana amárojla nachaje. Eyá pu'uhuaré nemacare Tupana Pechu nacú, uncá Tupana amálajo nachaje ripachá. ");
INSERT INTO ycn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Nujhua'atéjena i'imacale, ajopana ña'ajeño ca'ajná icá najhua'ató jahuacáca'alo ñacarelana chojé. Ihuacára'ajeño jimaje ca'ajná nahuá'aje icá, nahuajácaloje icá penaje. Maare que ri'imajica ee ijló, ihuó la'aniyo na'apejé méqueca ipura'ajico najhua'até ichayo. ");
INSERT INTO ycn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Riphájicaja rená chojé ijló quéchami ipura'ajico ichayo. Ejéchami Tupana quemájica ijló méqueca imájica najló —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Cajrú ina'uqué i'imaño re. E apú quemari Jesusjlo: —Huehuíña'atajeri, pimicha no'ohuejlo, ra'achí nojló nule'ejé penaje i'imacajla, huara'apami chu yurícare huajló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús quemari rijló: —Uncá na calé a'arí nucá puráca'aloji lamá'atajeri penaje. Uncá caja nacaje tamáca'atajeri penaje calé nucá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","E Jesús quemari piño najló piyuque: —Re ina'uqué piyuque nacojéruna, camejéne'equena huani necá. Ma'aquéruna caja necá. Najlúhuaja nacaje ña'acana nahue'epí natucumó. Ileruna ihue'epeje ichó, i'imacá piyá necá que caja. Uncá cajrú iná le'ejé nacaje aú calé iná i'imacá matajnaco —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Eyá Jesús i'imari yucu najló marí que, rehuíña'atacaloje necá rinacu penaje: —Pajluhuaja ina'uqué i'imichari. Cajrú le'ejepelari ri'imichaca. Cajrú huani ajñacaje i'imichaca rimena e'iyohuá, rijña'acáloje reyaje rijluhua richá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Marí caje aú ri'ijnachiya ripéchuhua marí que: “¿Meque nula'alájica a'ajnejí? Nuhue'epí uncá riphálaje riñacarelana chojé, nulamá'atacaloje ricá richu penaje”, que ri'ijnachíyaca ripéchuhua. ");
INSERT INTO ycn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","E caja marí que riphíchaca ripechu nacú: “Palani ca'ajná nucajya'atácajla piyuque riñacarelana, nula'acáloje apú richaje ñópo'ojloca rapumí chojé penaje. Richojé nulamá'ataje piyuque a'ajnejí nujña'ajícare numena e'iyayá, nunane hua'ató. ");
INSERT INTO ycn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nuñapátajicaja ricá numaje: ‘Chuhua re cajrú a'ajnejí nucapi. Júpija ri'imajica’. Ñaquele chuhua nuhuatána'ajica nusápaca'ala liyá. Nojñaje cajrú no'ojnehuá. Yuhuéra'acajo nacú nu'umajé. Queyajúpani caja nu'umajica, que ri'imajica nojló”, que ripechu i'imichaca. ");
INSERT INTO ycn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","E'iyonaja Tupana quemíchari rijló: “Uncá huani ina'uquélari ta picá. Chuhuajá lapí pitaca'ajica. ¿Eta, nacaje pilamá'atacare pijluhua, najlo chi riyurejo?” que Tupana quemíchaca rijló. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesús quemari piño najló: —Ñaqué caja ri'imajica ina'uquejlo, cajrú huátacaño najluhua nacájejlo. Uncá na i'imalaje najló je'echú chu —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","E Jesús quemari ra'apiyatéjenajlo: —Ñaquele numá ijló, ipechu i'imaniya marí que ajñacaje nacú: “Uncá na i'imalaje ca'ajná huajló, huajñácaloje penaje. Huataca'ajica me'epejí nacú ca'ajná”. Ipechu i'imaniya caja ñaqué caja a'arumacaji nacú. Ihuó ca'aniyo rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tupana palamane iná cajmuchá inajlo, iná napona hua'até. A'ajnejí, a'arumacaji, quele chaje iná cajmuchá, iná napona hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ihue'epí cupira'aphana nacojé. Uncá nejátala nacaje icha ijí, najña'acáloje richa najluhua penaje. Uncá caja a'ajnejí ñacarelana i'imalá najló, nalamá'atacaloje najluhua a'ajnejí richojé penaje. Tupánaja calé a'arí najló ajñacaje. Cupira'aphana chaje íqui'ica Tupana huátaca icá. ");
INSERT INTO ycn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Iná huo ca'acochu nacaje nacú, uncá ra'alá iná ñaté, iná i'imacáloje richaje júpica marí eja'ahuá chu penaje. ");
INSERT INTO ycn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Uncá caja ihue'epila méqueca la'acana, i'imacáloje richaje júpica marí eja'ahuá chu penaje. Majopéjari ricá. Eta ¿naje ihuó ca'aró apú nacaje nacú? ");
INSERT INTO ycn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ihue'epí caja a'ahuaná ihuí nacojé. Uncá risápala. Uncá caja riña'alá rijluhua a'arumacaji, ra'acáloje rinacuhuá penaje. E'iyonaja richá'ata a'arumacaji ripalacha aú. Cajrú huani le'ejepelari, ne'emacánami chu, Salomonmi chu i'imacá. E'iyonaja uncá richá'atala a'ahuaná ihuí palá nojé ra'arumacá aú. ");
INSERT INTO ycn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mequetánajloje penaje calé a'ahuaná ihuí. Chuhuajá que iná amaca ricá, muní que rihuijíño'oco. E'iyonaja palá amácanami ricá Tupana palamane. A'ahuaná ihuí chaje ra'ajica rinacojó icá, a'arumacaji i'imacáloje ijló penaje. ¡Meque huejápaja huani ipechu Tupana chojé caphí! ");
INSERT INTO ycn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tupana a'arí rinacojó icá. Ñaquele ihuó ca'aniyo nacaje nacú. Imaniya: “¿Na huajñaje? ¿Na hue'erajé?” que. ");
INSERT INTO ycn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Necá, uncá hue'epílaño Tupana nacojé, ricaja calé nahue'epí natucumó. Eyá Tupana hue'epiri icá, ra'acáloje ijló nacaje ila'acare nacú camu'ují penaje. ");
INSERT INTO ycn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ihue'epí itucumó pamineco Tupana huacára'aca que la'acana, rihuátaca que la'acana caje. Raú ra'ajé ijló a'ajnejí, a'arumacaji, caje macá. ");
INSERT INTO ycn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Nujhua'atéjena, huejápaja icá. Iquero'oniyo. Nora'apá quemari inacu, i'imacáloje rijhua'até je'echú chu penaje. Palani rijló marí que ila'acana palá. ");
INSERT INTO ycn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Eco a'atá piyuque inane ajopana ina'uquejlo rihuemí penaje. Ejomi a'ajé camu'ují la'acáñojlo liñeru. Marí que la'acana aú Tupana a'ajeri ijló nacaje je'echú chu i'imajica huacajé. Re uncá nacaje tajnálajo iliyá. Uncá caja ata'acáchina mujlúca'alajeño richojé nacaje ata'ajé. Uncá caja pi'iréjena apichátalaje iliyá nacaje. ");
INSERT INTO ycn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Iná i'ijnatá iná péchuhua nacaje íqui'i iná huátacare nacú. Iná huátacachu íqui'i nacaje je'echú chu i'imacare, iná i'ijnatá caja iná péchuhua rinacu. Eyá iná huátacachu íqui'ija nacaje marí eja'ahuá chu i'imacare, iná i'ijnatá caja iná péchuhua rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","E Jesús quemari piño najló: —Marí que caja i'imajica nupé. Nacarihuate i'ijnari ca'ajná lapí ajopana chaje nahuá'acaco amaje. Rejomi rajñá ca'ajná ra'ajnehuá najhua'até queyajupa. Re ri'imacá quetana rijhua'até sápajeño huátaca ricá. Lucúna'aqueja nacamaré que nahuátaca ricá. Ca'arumacáruna que nahuátaca ricá. Namaca ricá huaíchaca aú najme'etá rijló pají numaná. ");
INSERT INTO ycn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Palá rila'acá necá, i'imaño ripé lamá'ataqueja rihuátacana nacú. Rihuacára'a najñaca na'ajnehuá ra'apiyá. Pu'ují napechu i'imacá raú. ");
INSERT INTO ycn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Apala riphá lapí jenaji que ca'ajná, apala riphá lapihuá ca'ajná. E'iyonaja riphata rijhua'até sápajeño cajmuruna rihuátacana nacú. Raú rila'á necá palá. Pu'ují napechu i'imacá raú. ");
INSERT INTO ycn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","Ina'uquéjloje penaje i'imacá nucá. Nucaja caja pa'ajero piño majó. Ñaqué ilamá'ataca palá ipéchuhua maare nupé. Uncá ihue'epílaje méquechamica nuphájica. Apú ca'ajná mujlúca'ari apú ñacaré chojé nacaje ata'ajé. Paminá hue'epíquela méquechamica riphácajla, uncá riyurílajla rimujlúca'aca riñacaré chojé. Ñaqué caja ijló ri'imajica. Uncá caja ihue'epílaje noná. Huajátacajo nuphájica majó ichaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","E Pedro quemari Jesúsjlo: —¿Mecajena necá pimíchajena nacú huajló yucu chu, huátajeño picá? ¿Huanacu chi pimicha ca'ajná, piyuqueja ina'uqué nacú pimicha ca'ajná? ");
INSERT INTO ycn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús quemari rijló: —Re ca'ajná apú hua'até sápajeri. Capechuni ricá. Ñaquele rila'á palá. Rihuacára'ajeri i'ijnacá yámona, ra'á ricá riñacaré chiyá huacára'ajeri penaje. Ricá caja riyurí piño a'ajnejí tamáca'atajeri penaje, ritamáca'atacaloje rijhua'até sápajeñojlo a'ajnejí penaje. ");
INSERT INTO ycn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","E caja ricarihuate i'ijnari ají que ya'ajnaje. Júpija huani ri'imacá rejo. E caja ehuaja ripa'ó rapumí chuhuá. Iphari rijhua'até sápajeri nacú. Amari rila'acá palá rihuacára'aca ricá que. ");
INSERT INTO ycn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aú ricarihuate la'arí ricá palá. Ra'á ricá piyuque rinane amájeri penaje. ");
INSERT INTO ycn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Eyá uncá ina'uquélari ri'imaquela, rimajla marí que ricarihuate nacú ya'ajná jo'ó ri'imaqué huacajé: “¡Meque júpija huani nuhuacára'ajeri malá'ataca ricó rehuá!” Marí que ripechu i'imacajla aú riqueño'ójla ricarihuate hua'até sápajeño ña'atácana, achiñana, inaana hua'até. Cajrú ra'ajnehuá ajñacana nacú ri'imajla. Cajrú i'iracaje i'iracana nacú caja ca'ajná ri'imacajla. Yuhuéra'acajo nacú ca'ajná ri'imajla. ");
INSERT INTO ycn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Huajátacajo ricarihuate ipháquela rinacu marí que rila'acá e'iyá ee, rihuajajla ricá íqui'i huani. Ajopana, uncá jema'alaño nahuacára'ajeri ja'apiyá, hua'até rijña'ájla chapú caje panacu. ");
INSERT INTO ycn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Re ca'ajná apú hua'até sápajeri. Rihue'epí palá naca ricarihuate huátaca rila'acá. E'iyonaja uncá rema'alá ra'apiyá. Uncá caja riculá rila'ajona, rila'acáloje ricá raú penaje. Marí que rila'acá aú ricarihuate ña'atájeri ricá cajrú huani. ");
INSERT INTO ycn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Re ca'ajná apú, uncá rihue'epila palá naca ricarihuate huátaca rila'acá. Aú rila'á ricá menáhuaca, uncá paala rila'acá. Marí caje chona nahuajá iná. E'iyonaja huejápaja calé rihuajaca ricá. Apú ca'ajná hue'epiri palá quemachi nacaje rihuacára'ajeri huátacare la'acana nacojé. Ripechu locópa'ala rihuacára'ajeri huátaca rila'acá ricá. Apú ca'ajná hue'epiri huejápaja rihuacára'ajeri huátacare la'acana nacojé. Ripechu locópa'ala caja rihuacára'ajeri huátaca rila'acá rijló nacaje. ");
INSERT INTO ycn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nucá i'ijnari majó Tupana Pechu a'ajé ina'uqué naquiyánajlo. Palani ri'imaquela nojló, ñaqué ri'imacajla me'etení. ");
INSERT INTO ycn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nujña'ajica chapú caje panacu aquijñojo. Camu'ují nu'ujnataca nupéchuhua a'ajná nuphájica richojé ejená. ");
INSERT INTO ycn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Apala ipechu i'imá nunacu marí que: “Ricá la'ajeri palá ina'uqué pechu, nayúcha'aco piyá pachácaca.” Ipechu i'imaniya ilé que. Uncá ilé que calé ri'imajica ina'uquejlo. Nupuráca'alo a'acana nanacojó jimaje chapú napechu i'imajica no'opiyá jema'ajeño nacú. ");
INSERT INTO ycn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Maare eyá a'ajná ño'ojó ina'uqué pechu i'imajé chapú panacuhuácaca. Marí que ca'ajná ri'imajica. Apú ca'ajná i'imajeri riyajalo hua'até. Re ca'ajná hueji quele riyani. Pajluhua té'ela quele necá piyuque riyani hua'até. Hueji quele nanaquiyana pechu i'imajé ca'ajná iyamá nacú chapú. Eyá iyamá pechu i'imajé ca'ajná hueji quele nacú chapú. ");
INSERT INTO ycn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nupuráca'alo ja'apiyá jema'ajeño jimaje rara'apá pechu ca'ajná i'imajé ri'irí nacú chapú. Ri'irí pechu ca'ajná i'imajé chapú rara'apá nacú. Chapú ca'ajná roló pechu i'imajica rutu nacú. Rutu pechu ca'ajná i'imajé roló nacú chapú. Ruyajneru pechu ca'ajná i'imajé chapú ru'urinó nacú. Ru'urinó pechu ca'ajná i'imajé chapú ruyajneru nacú. Marí que ne'emajica pajhua'atéchaca, nanaquiyana a'acale nanacojó nupuráca'alo —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús quemari piño najló: —Amaca aú juni suhuáca'ala huaícha camú to'ocó ejo, imá nacú: “Juni ja'ajero majó”. Imacá queja ra'acó. ");
INSERT INTO ycn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Carená apho'ocá aú rihuilaphe ejo, imá nacú: “Ima'aní penaje i'imajeri”. Imacá queja ima'aní moco'ocá maare. ");
INSERT INTO ycn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Pajlácachina icá! Icá la'añó icó palá la'ajeño que ina'uqué ijlú chuja. E'iyonaja uncá ñaqué calé icá. Icá hue'epiño méquechamica juni ja'ajico je'echú chojé yacá'acano aú. Ñaqué caja ihue'epica nacaje nacojé te'erí chaje yacá'acano aú. Eta, maare nucá ijhua'até me'etení. E'iyonaja uncá ihue'epila na penájeca Tupana huacára'aca nucá majó —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesús quemari piño najló: —Ilamá'ata puráca'aloji icó pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Apú ca'ajná quemari pinacu: “Pu'uhuaré la'ajeri ricá” que, uncá pachá pa'alá pilehuéricare huemí rijló. Raú ca'ajná rihuata pihuá'acana ihuacára'ajeri chaje, rilamá'atacaloje pijhua'até ricá penaje. Rihuá'ajica ee picá, pilamá'atajla ricá rijhua'até iñe'epú chuhuá ja'apácana nacú, rihuá'aca piyá picá ihuacára'ajeri ejo. Rihuá'aquela picá rejo, ra'apátajla picá policíajlo. Ricá piño ca'arijla picá ra'apiyá ina'uqué huajáquelana chojé. ");
INSERT INTO ycn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Numá pijló, uncá pácho'olojla richiyá. Pa'atájla pilehuéricare huemí rijló, quéchami pácho'ojla richiyá. ");
INSERT INTO ycn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","E caja re i'imacaño naquiyana i'imaño yucu Jesusjlo. Méqueca Pilato noca ajopana ina'uqué yucuna ne'emá rijló. Nemá rijló: —Cajrú huani Pilato nótaca ina'uqué. Galilea eyájena ne'emacá. Pu'uhuaré nala'acare chaya nenó Tupánajlo napirana naquiyana i'imacá. Marí que nala'acá aú Pilato huacára'ari nenótacana. Quéchami riquechípa'a nérami napiránami chuna írami hua'até —que nemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús quemari najló: —Apala ipechu i'imá necá Pilato nótacarena nacu: “Ajopana chaje pu'uhuaré la'ajeño ne'emacá. Pachá marí que nala'acó”. ");
INSERT INTO ycn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Uncá richona calé nacapichó. Uncájica ee ipajno'otá ipéchuhua pu'uhuaré ila'acare liyá Tupana ejo, ñaqué caja icapichájico. ");
INSERT INTO ycn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloé e pají i'imari. Yenoje ri'imacá. Mana'í chiyoja ricojno'ocó i'imacá. Hueji que cuhuá'ata quele iphata ji'imaji nacojé quele ina'uqué cha ricojno'ó i'imacá. Aú nacapichó piyuqueja. Ipechu nacú ri'imá ca'ajná: “Ajopana Jerusalén eruna chaje ne'emacá pu'uhuaré la'ajeño. Pachá nacapichó ilé que”. ");
INSERT INTO ycn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Numá ijló, uncá richona calé nacapichó. Uncájica ee ipajno'otá ipéchuhua pu'uhuaré ila'acare liyá, ñaqué caja icapichájico —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Marí que Jesús i'imacá najló yucu: —Apú i'imichari. Rimena e'iyá pajluhuánaja paijí tári'icharo. Higuera rií i'imichaca. Rihue'epíchaca aú rená, ri'ijichá richa ña'ajé. Iphíchari rejo. E riculicha ripaná e'iyohuá richa, amíchari uncá richa i'imalacha. ");
INSERT INTO ycn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aú rimicha rimena e'iyá sápajerijlo: “Pa. Caja hueji quele jarechí quetana i'imajemi nu'ujnacá majó richa culaje. E'iyonaja uncá richa ta i'imalá. Eco pi'icá ricá. Uncá na penaje calé mecharú ta tára'aro numena e'iyá majopeja”, que paminá quemíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","E'iyonaja rijhua'até sápajeri quemíchari rijló: “Reja ri'imareja pajluhuaja jarechí quetana ejo'ocaja. Eco nuchá ri'ilaya, nuca'achí a'ahuaná, jimichi tami caje patáca'alomi ri'ilaje. ");
INSERT INTO ycn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Raú ca'ajná rarúca'aje. Uncaja que rarúca'a, eco pihuacára'a nuca'acá ricá”, que rimíchaca ricarihuátejlo. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","E caja huatána'acaje huacajé Jesús jehuíña'atari ina'uqué nahuacáca'alo ñacarelana chu. ");
INSERT INTO ycn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Re ajopana ina'uqué hua'até pajluhuájaru inanaru i'imayo. Dieciocho jarechí quetánicha ru'umacá rutami caje hua'até. Pajluhuaja jiñá pechu i'imari rujhua'até. Ricá la'arí rutami rucá. Cúhua'acano ro'opájica. Rinacojé uncá meño'ojó rutára'alo pu'ucú. ");
INSERT INTO ycn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús amaca aú rucá, rihuá'a rojló. Aú ru'ujná rahua'ajé. E rimá rojló: —Caja ta pitami caje ja'apáchiyari piliyá. ");
INSERT INTO ycn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","E rito'otá riyáte'ela runacojé ají que. Raú ja rutára'o pu'ucú. Ejéchami rupura'acó palá Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","E'iyonaja nahuacáca'alo ñacarelana chiyá huacára'ajeri yúcha'aro Jesús cha, ritejmo'ótacale ina'uqué huatána'acaje huacajé. Raú rimá ajopana ina'uquejlo: —Re pajluhua cuhuá'ata que cala iná la'acáloje iná sápaca'ala re'iyá penaje. Re'iyá icá, itámina, i'ijnajeño richaje, ritejmo'ótacaloje icá penaje. Eyá huatána'acaje huacajé uncá inahuaja jiñá pechu i'imari'uqué tejmo'ótacana i'imalaje. ");
INSERT INTO ycn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Raú Jesús quemari rijló: —¡Pajlácachina ta icá! Icá la'añó icó palá la'ajeño que huani ina'uquejlo. E'iyonaja uncá ñaqué calé icá. Ipirá, jema piracana ca'ajná, cahuarú ca'ajná i'imaquela nañacarelana chu huatána'acaje huacajé, ihuá'ajla caja necá richiyá une'é chuhuá juni i'irajé. ");
INSERT INTO ycn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Eyá marirú, Abrahami chu laquélomi rucá. Dieciocho jarechí quetánicha ro'opaca cúhua'acano. Jiñá Chi'ináricana huacára'ari rutami caje rojló, ru'umacáloje rutami rinacu penaje. Ñaquele palani ra'apátacana ruliyá huatána'acaje huacajé —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Marí que rimacá aú rapáña'ata chapú péchuruna rinacu nacú. Ajopana ina'uqué pechu i'imá pu'ují rijhua'até namaca aú palá huani ritejmo'ótaca rucá. ");
INSERT INTO ycn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús i'imari piño najló yucu marí que: —Ina'uqué naquiyana huacára'ajeri Tupana. Re rijhua'atéjena huejápaja. Ehuá richaje, richaje que nañaté a'ajico. Chuhua nu'umajica yucu ijló, ihue'epícaloje méqueca ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostaza icha ijí que ricá, ina'uqué ejátacare ne'ecacapere e'iyohuá. Capajé nojé huani richa ijí. E'iyonaja jíma'alami yenuna quetana ritahuá'aco. Ripana e'iyá cupira'aphana, camejérina cayuphéruna, quele la'añó nañacaró. ");
INSERT INTO ycn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús quemari piño najló: —Ina'uqué naquiyana huacára'ajeri Tupana. Re rijhua'atéjena huajápaja. Ehuá richaje, richaje que nañaté a'ajico. Chuhua nu'umajica ijló apa'amá yucu, ihue'epícaloje rinacojé raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Inaana quechípa'año harina pan amúra'atajona hua'até. Raú harina anóro'otacanami amúra'ataro piyuqueja. Ñaqué caja Tupana puráca'alo jema'acó cajrú ina'uqué e'iyohuá, nema'acáloje ra'apiyá penaje, ne'emacáloje rijhua'atéjena raú penaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalén ejo i'ijnacana nacuja Jesús ja'apari cajruni pajimila, camu'ujuni pajimila, quele e'iyohuá. Marí que ja'apácana nacú rehuíña'ata ina'uqué Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","E apú quemari Jesusjlo: —Hue'emacana ¿huejápaja chi ina'uqué Tupana i'imatájeri capichácajo liyá? Raú Jesús quemari rijló, ajopánajlo hua'até: ");
INSERT INTO ycn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ila'á caphí ipéchuhua, imujlúca'achi ujú caje ñani rinumaná chiyá je'echú chojé. Numá ijló, cajrú ina'uqué atá'ajica richiyá mujlúca'acana. E'iyonaja uncá meño'ojó namujlúca'alaje richiyá. ");
INSERT INTO ycn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Pají miná que caja Tupana. Ricá jácho'ojero rinumaná itaje. Rejomi icá queño'ojeño jahuacácano huaca'apeje rinumaná ahua'ajé. E ihuá'aje rijló, rijme'etácaloje ijló rinumaná penaje. Imaje rijló: “Huahuacára'ajeri, pijme'etá huajló rinumaná”. Raú rimaje ijló: “Uncá nuhue'epila mere eyájenaca icá”. ");
INSERT INTO ycn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ejéchami imájica piño rijló: “Huajñaque hua'ajnehuá pijhua'até. Hue'eraque caja nacaje jalá pijhua'até i'imajica. Picá caja jehuíña'ataqueri huecá pajimila e”, que imájica rijló. ");
INSERT INTO ycn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","E'iyonaja rimaje piño ijló: “Caja numicha ijló: ‘Uncá nuhue'epila mere eyájenaca icá.’ I'ijná nuliyá a'ajná ño'ojó, pu'uhuaré la'ajeño icá” que rimájica. ");
INSERT INTO ycn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tupana hua'atéjena i'imajeño rijhua'até je'echú chu. Abrahami chu, Isaacmi chu, Jacobmi chu, piyuque Tupana puráca'alo ja'apátajeñomi chuna, quele i'imajeño caja re. Amájica ee necá re, cajrú iyájica. Cajrú caja ajma'atájica aí hua. Necá i'imajeño richu, je'echú chu. Eyá icá i'imajeño cupáquejanami que huaca'apé naliyá. ");
INSERT INTO ycn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ina'uqué, ajopana, ajopana que piyuqueja marí eja'ahuá chu i'imacaño, i'imajeño je'echú chu Tupana hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ajopana ina'uqué ja'apejé i'imacaño me'etení i'imajeño ajopana chaje rejo —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesús jehuíña'ataca necá ee fariséona naquiyana iphaño rinacu. E nemá rijló: —Pi'ijná maare eyá, Herodes huátacale pinócana. ");
INSERT INTO ycn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Jesús quemari najló: —Chuhuajá, muní hua'até nu'umajé jiñana pechu ca'acana ina'uqué e'iyayá nacú. Hua'ató nutejmo'ótajica natámina. Apacala nuñapátajica ricá. Marí caje la'acana nacú nu'ujnajé Jerusalén ejo. Jerusalén e nenono Tupana puráca'alo ja'apátajeño. Uncá nenola necá apú pajimila nacú. Ñaqué caja nenójica nucá rejo. Chuhua ipa'ó, imíchachi riyucuna Heródesjlo —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Marí que Jesús quemacá Jerusalén e i'imacáñomi chuna nacú: —Tupana huacára'aqueri ripuráca'alo ja'apátajeñomi chuna Jerusalén erúnami chúnajlo i'imajica. Nanaquiyana nenoque i'imajica. Nanaquiyana cha naca'aqué jipa. Pulapé nuhuátacajla nahuacátacana, ne'emacáloje no'opiyá jema'ajeño penaje. Capere jahuacátaca ruyani ruyuphé ja'apejé que caja nuhuátaca nahuacátacana, ne'emacáloje no'opiyá jema'ajeño penaje. E'iyonaja uncá nahuátala. ");
INSERT INTO ycn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chuhua uncá na calé i'imajeri najhua'até namájeri penaje. Meñaru namájica nucá. Caja numá nanacu: “Uncá namálaje nucá”. Nemájica ee nunacu marí que: “Palani ricá Tupana huacára'acare majó i'imacá”, ejéchami namájica nucá piño —que rimacá Jerusalén e i'imacaño nacú i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Apú huatána'acaje huacajé Jesús i'ijnari apú fariséona huacára'ajeri ñacaré ejo ra'ajnehuá ajñaje. Re caja apú i'imari. Ritami ri'imacá. Ra'anapitá, ritajné hua'até jenátaro. Nacú ri'imá ritami. Ajopana re i'imacaño yacá'año Jesús chaje, namácaloje méqueca rila'ajica ricá huatána'acaje huacajé penaje. ");
INSERT INTO ycn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tupana puráca'alo nacú jehuíña'atajeño, fariséona, quele ne'emacá. E Jesús quemari najló: —¿Meque chi Moisesmi chu puráca'alomi lana'aquéjami quemacá natámina tejmo'ótacana nacú? ¿E iná la'acá chapú necá natejmo'ótacana aú huatána'acaje huacajé? —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Uncá na'ajipalá rijló. Raú ripatá ritami riyáte'ela naquiyá. Ritejmo'óta ricá, rimá rijló: —Chuhua pi'ijná palá ca'ajnó. ");
INSERT INTO ycn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","E rimá najló: —Re ca'ajná ulahuí juni phuni. Re caja juni richu. Icahuarute ca'ajná, jematé ca'ajná, ja'aquelo richojé huatána'acaje huacajé. ¿E jácho'otacajla ricá richiyá rihuacajé? ");
INSERT INTO ycn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Raú namanúma'o. ");
INSERT INTO ycn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Apú quemari ajopánajlo, ne'ejnacáloje richaje penaje. Re ne'emá rijhua'até riñacaré chu. E Jesús amari necá paminá yucupéra'acarena. Palá nojé ñáca'ajori naculá najluhua. Raú rimá najló: ");
INSERT INTO ycn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","10","—Apala nayucupéra'aje icá, i'ijnacáloje nahuá'acaco a'ajnená ajñaje najhua'até penaje. Iphájica ee rejo, iyá'aniyo palá nojé ñáca'ajori chu. Apala nahuata ricá apujlo, ichaje naaloje nahuá'acaco a'ajnená ajñaje najhua'até penaje. Majopéjaruna le'ejé ñáca'ajori chojé iyá'ajo pamineco. Raú ca'ajná paminá iphari inacu. Rimá ca'ajná ijló: “Nujhuáque'ena, a'ajná chu iyá'icho palani ñáca'ajori chojé, nuhuátacarenajlo penaje quele ñáca'ajori”. Raú ijhua'até yá'ajicaño pechu i'imajé inacu palá. ");
INSERT INTO ycn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iná pechu i'imacachu iná nacuhuá marí que: “Nucá chá'atari ajopana ina'uqué”, Tupánajlo iná i'imá ajopana ja'apejé. Iná pechu i'imacachu marí que iná nacuhuá: “Ajopana chá'ataño nucá”, Tupánajlo iná i'imá ajopana chá'atajeri —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","E Jesús quemari piño paminajlo: —Pihuacára'ajica ee a'ajnejí la'acana ajopana ina'uquejlo, piyucupéra'aniya pihuátacarena, pejena, pahua'á ñacajelaruna, cajrú le'ejepeláruna i'imacárena, cajena. Pimaniya ilé cajénajlo, najñácaloje na'ajnehuá pijhua'até penaje. Quéchami nemájica caja pijló, pajñácaloje pa'ajnehuá najhua'até penaje. Marí que la'acana aú apiyácaje pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Marí cajénajlo pimá, najñachi na'ajnehuá pijhua'até: Pimá camu'ují la'acáñojlo, apicháca'alo moto'ocáñojlo, uncá meño'ojó ja'apálaño palajlo, mejlurúnajlo, quelejlo pimá, najñachi na'ajnehuá pijhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Marí que la'acana aú Tupana la'ajeri picá palá. Uncá meño'ojó napiyácala picá ñaqué la'acana aú. Tupana macápo'otajica palá la'ajéñomi chuna huacajé, ra'ajé pijló palá pila'acare huemí —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na'ajnehuá ajñacana nacú ne'emá re. Rahua'á yá'aco jema'arí méqueca rimacá apujlo. Aú rimá Jesúsjlo: —Pu'ují péchuruna ne'emajica, ajñájeño na'ajnehuá Tupana hua'até je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Raú Jesús i'imari rijló yucu marí que: —Apú huacári'icha ajopana, nayucupéra'acaloje cajrú ina'uqué penaje. ");
INSERT INTO ycn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ehuá caja na'ajnehuá ajñacana iphíchari rená chojé. Raú rihuacári'icha rijhua'até sápajeri riyucupéra'acarenajlo quemaje. Rimicha rijló: “Pimicha najló: ‘Caja a'ajnejí ñapíchari. Chuhua i'ijná rejo, ajíchachi a'ajnehuá’, que pimájica najló.” “Je.” ");
INSERT INTO ycn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Aú ri'ijichá apú chojé, apú chojé que riyucuna i'imajé najló. E'iyonaja ijnú nahuáchiyaca rejo i'ijnacana. Pamineco riphíchaje nacú quemíchari rijló: “Huajé nuhuarúhui'ichaca apú liyá rimena. Ricá nuhuata amácana me'etení. Ñaquele uncá nu'ujnalaje rejo”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","E ra'apicha piño apú chaje. Ricá quemíchari rijló: “Nuhuarúhui'icha iyamá té'ela quele jémana piracana. Chuhuaca nuhuata natá'acana, nomácaloje méqueca nachíra'aca nacaje penaje. Ñaquele rihuátaniya nucá ca'ajnó”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Apú quemíchari piño rijló: “Huajé huani nuhuá'aquichaco. Ñaquele uncá meño'ojó nu'ujnalá rejo”. ");
INSERT INTO ycn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Uncá nu'ujnalaje”, que huánija nemíchaca rijló piyuque. Raú rijhua'até sápajeri pi'icharo ricoja rihuacára'ajeri ñacaré ejo. Ri'imichá riyucuna rijló, meque nemíchaca rijló yucuna. Raú paminá yúchi'icharo nachá. E rimicha rijhua'até sápajerijlo: “Chuhua quiñaja pi'ijnacá apojó pajimila e'iyohuá. Chi'itaje iñe'epú chuhuá, ujú caje ñani iñe'epú chuhuá hua'até pi'ijnajé. Pihuá'icha majó camu'ují la'acaño, apicháca'alo moto'ocaño, uncá meño'ojó ja'apálaño palá, mejluruna, quele pihuá'aje majó”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Raú ri'ijichá piño ajopana huá'aje. Ne'ejichá rijhua'até cajrú. Ejomi rijhua'até sápajeri quemíchari rijló: “Caja nuli'ichá pimíchaca que. Re ejo'ocaja pucunaji ajopánajlo”. ");
INSERT INTO ycn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Rihuacára'ajeri quemíchari rijló: “Pi'ijná piño ilé iñe'epú chuhuá, to'ocó pajimila yámojo chuhuá. Pimicha ajopana ina'uquejlo, ne'ejnachi majó, namano'otachi nuñacaré. ");
INSERT INTO ycn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Numá pijló, ileruna nuyucupéra'acarena pamineco i'imacá, uncá huani najñálaje na'ajnehuá nujhua'até maare”, que rimíchaca rijhua'até sápajerijlo —marí que Jesús i'imacá yucu najló. ");
INSERT INTO ycn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","E caja Jesús ja'apari ají que a'ajná ño'ojó. Iqui'iruna ina'uqué ja'apaño rijhua'até. E ripajno'ó ají que riyámojo, rimá najló: ");
INSERT INTO ycn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Huátaño nujhua'atéjena penaje i'imacana, ijló numá: Ihuata nucá íqui'ija ajopana chaje. Ihuata nucá íqui'ija ichi'iná chaje. Ihuata caja nucá íqui'ija iyajalo chaje, iyani quele chaje. Ihuata caja nucá íqui'ija ejena chaje. Ihuata caja nucá íqui'ija icó chaje. Uncaja que ihuata nucá íqui'ija ileruna chaje, uncá meño'ojó i'imalá nujhua'atéjena. ");
INSERT INTO ycn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Apala nenoje ca'ajná nujhua'atéjena. Ihue'epíjica ee inacuhuá, uncá meño'ojó i'imalá nujhua'atéjena. ");
INSERT INTO ycn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Apú huátari ca'ajná pají la'acana. Pamineco ri'ijnatá ripéchuhua, ramácaloje mérejeca rihuemí jácho'ojico rijló. Raú rihue'epí riliñérute iphaca riñapátacana loco'opani ca'ajná, uncá ca'ajná. ");
INSERT INTO ycn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Uncachu ri'ijnatala ripéchuhua palá, rica'á ca'ajná piyuque riliñérute jipa ayúma'acana ra'apí huemí. Rejomi uncá riliñérute i'imalá, riñapátacaloje ricá penaje. Ajopana ina'uqué amájica ee ritára'aco mañapátacanaru, ne'echajica rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nemaje rinacu: “Riqueño'ó pají la'acana, e'iyonaja uncá riliñérute iphala rilocópa'ala”, que nemájica rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ñaqué caja apú i'ijnataca ripéchuhua. Ajopana ina'uqué huacára'ajeri i'ijnari rile'ejena surárana hua'até najhua'até nócajo. Veinte mil rile'ejena surárana hua'até ri'ijná. Apú le'ejé diez mil. Caja ne'emá rijló nayucuna: “Chuhua necá huaícha ijhua'até nócajo”. Raú ri'ijnatá ripéchuhua: “¿E huachá'atacajla necá diez mil surárana hua'até ca'ajná, uncá ca'ajná?” ");
INSERT INTO ycn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Rimá ca'ajná: “Uncá meño'ojó huachá'atalaje necá, íqui'iruna necá”. Marí que ripechu i'imajica ee, palani apú huacára'acana rejo rijhua'até pura'ajó, ya'ajná jo'ó ri'imanoja rile'ejena surárana hua'até. Palani rijhua'até pura'acano, naqueño'ocá piyá pajhua'atéchaca nócacano. Marí que ri'ijnataca ripéchuhua palá. ");
INSERT INTO ycn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ñaqué caja ricá piyuque ina'uquejlo, huátaño nujhua'atéjena i'imacana. Pamineco ne'ejnatá palá napéchuhua méqueca nahuátaca la'acana nacú. Uncaja que nahuata piyuque nacaje yurícana, ne'emacáloje nujhua'atéjena penaje, uncá meño'ojó ne'emalá nujhua'atéjena —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‘Yuquira, palani rica'acana a'ajnejí e'iyajé. E'iyonaja rila'acochu uhui'ichí, uncá meño'ojó iná pa'atala rapumí chuhuá ricá, rila'acóloje cajipareni penaje. ");
INSERT INTO ycn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Uncá na penaje calé ricá uhui'ichini. Te'erí e'iyajé rica'acana, uncá paala. Uncá ra'alá te'erí ñaté. Nacaje mujrumi e'iyajé rica'acana, uncá caja paala. Ricupácanaja palani. Jema'á icá que'ejhuiruna —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Cajrú liñeru ña'ajeño ne'emacánajlo jahuacaño Jesús nacú tujlá que ripuráca'alo jema'ajé. Ajopana jahuacaño caja rahua'ajé. Necá nacú ajopana quemaqueño: “Uncá ina'uquélaruna necá” que. ");
INSERT INTO ycn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","E fariséona, Tupana puráca'alo nacú jehuíña'atajeño hua'até amaño natára'aco Jesús ahua'á. Raú nachapújra'o Jesús nacú. Nemá pajlocaca: —Pa, Uncá ina'uquélaruna hua'até ricá. E'iyonaja uncá meque rimalá raú. Rajñá caja ra'ajnehuá najhua'até —que nemacá Jesús nacú. ");
INSERT INTO ycn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Raú Jesús i'imari najló yucu marí que, rehuíña'atacaloje necá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Pajluhuaja ina'uqué i'imichari. Ripirana i'imichaño cien ohuéjana. E caja pajluhuaja nanaquiyana capiícharo i'imichaca. Aú riyuricha ajopana, riculácaloje ricá penaje. Riculicha ricá a'ajná ripháchiyaca ricá ejená. ");
INSERT INTO ycn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Caja ehuaja ripháchiyaca ricá. Riqui'ichá ricá rihuacúla'apajo. Pu'ují ripechu i'imichaca, ripháchiyacale ricá. ");
INSERT INTO ycn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","E caja riphicha riñacaré ejo. Quéchami rahuacáchiya ina'uqué palá ripechu i'imacárena nacú, riñacaré ahua'ájena hua'até. E rimicha najló: “I'imá queyajupa nujhua'até. Caja nupháchiya nupirá, ile capiícharo”, que rimíchaca najló. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","E Jesús quemari piño najló: —Numá ijló ñaqué caja calé je'echú churuna pechu i'imacá pu'ují pajluhuaja ina'uqué nacú, pajno'otari ripéchuhua pu'uhuaré rila'acare liyá nacú. Eyá ajopana, re cajrú necá. Napechu i'imá nanacuhuá: “Palá la'acaño huecá Tupánajlo”. E'iyonaja uncá ñaqué calé necá. Marí que napechu i'imacale, uncá napajno'otala napéchuhua pu'uhuaré nala'acare liyá. Uncá pu'ují calé je'echú churuna pechu i'imacá nanacu —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","E ri'imá piño apa'amá yucu najló marí que: —Pajluhuájaru inanaru i'imichayo. Iyamá té'ela queta ruliñérute i'imichaca. Pajluhuata rinaquiyana capiícharo ruliyá. Aú rulucúni'icha rucamaré. Roláquicha ruñacaré chiyá a'ajná rupháchiyaca ricá ejená. ");
INSERT INTO ycn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Rupháchiya ricá ejomi rohuacáchiya ina'uqué, palá rupechu i'imacárena nacú, ruñacaré ahua'ájena hua'até. Rumicha najló: “I'imá queyajupa nujhua'até. Caja nupháchiya nuliñérute naquiyana capiíchajo”, que rumíchaca najló. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jesús quemari piño najló: —Pu'ují rupechu i'imacá, ruphátacale ruliñérute. Numá ijló, ñaqueja caja Tupana hua'atéjena, je'echú churuna, pechu i'imacá pu'ují pajluhuaja rimanaicho la'ajeri nacú, pajno'otari ripéchuhua rimanaicho rila'acare liyá nacú. ");
INSERT INTO ycn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús i'imari piño yucu najló marí que: —Pajluhuaja ina'uqué i'imichari. Riyani i'imichaño iyamá. ");
INSERT INTO ycn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","E caja rijmeremi quemíchari rara'apajlo: “Pa'ayú, chuhuata pa'á nojló piliñérute naquiyana, le'ejepelaji naquiyana, caje macá pimacare nacú nojló júpimi i'imacá”, que rimíchaca rijló. “Je” que. Aú nale'ejó, nale'ejó que ritamáca'achiyaca riyánijlo riliñérute naquiyana, le'ejepelaji caje. ");
INSERT INTO ycn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","E caja mequetánaja ri'imichaca. Eyá rijmeremi jahuacáchiyari rile'ejé le'ejepelaji piyuque. E caja ri'ijichá ají que ya'ajnaje ajopana te'eré ejo. Reyá majopeja ricupátajica riliñérute rehuá. Uncá huani paala rila'ajica rehuá. ");
INSERT INTO ycn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","E caja ehuaja riliñérute tajnáñari ricá. Hua'até uncá caja a'ajnejí i'imalacha rehuá rihuacajé. E naqueño'ochá me'epijí nacú taca'acana. Ñaqué caja riqueño'ochaca me'epejí ña'acana panacu. ");
INSERT INTO ycn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A'acuhuanaja ri'ijichá sápacaje culaje rijluhua. Aú reyaje a'achari rijló sápacaje. Je'eruna piracana lamára'acana nacú ri'imichá. ");
INSERT INTO ycn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A'ajnejí mujrumi cupácanami caje najicha ra'apiyá. Cacáme'e ri'imichá na'ajné ajñacana nacú, uncale na'alacha rijló a'ajnejí. ");
INSERT INTO ycn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","E caja ehuaja ri'ijnachiya ripéchuhua marí que: “Ya'ajná, pa'ayú hua'até sápajeño ajñaño na'ajnehuá cajrú. Uncá caja a'ajnejí tajnálaña necá. Maare ta nutaca'acá me'epijí nacú. ");
INSERT INTO ycn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ñaquele nupa'ajico rejo, pa'ayú ejo. Nuphájica ee rejo numaje rijló marí que: ‘Pu'uhuaré huani nula'acá Tupana. Ñaqué caja nula'acá picá chapú. ");
INSERT INTO ycn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Uncá ina'uquélari nucá. Ñaquele uncá pi'irí calé nu'umajé. Pijhua'até sápajeri nu'umajé’, que numájica rijló”, que ri'ijnachíyaca ripéchuhua. ");
INSERT INTO ycn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Raú rácho'ocho reyá, ripa'acóloje ají que ya'ajnaje rara'apá ñacaré ejo penaje. E ra'apicha ya'ajnaje. Juca ri'imanoja rara'apá amíchari ricá huaíchaca majó. Rihue'epicha camu'ují rinacu, aú recho'ochó rijimajo, iphíchari rinacu. E rimahuílo'ocha ricá, richiño'ochá rijimá chiyá. ");
INSERT INTO ycn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ejéchami ri'irí quemíchaca rara'apajlo: “Pa'ayú, pu'uhuaré huani nula'acá Tupana. Ñaqué caja nula'acá picá. Uncá ina'uquélari nucá. Ñaquele uncá pi'irí calé nu'umajé,” ");
INSERT INTO ycn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","E'iyonaja uncá rara'apá jema'alacha ra'apiyá. Rimicha rijhua'até sápajeñojlo: “Quiñaja iji'ichaca majó a'arumacaji patá nojé, a'achí nu'urí nacú ricá. Iji'ichá caja anillo, a'achí ricá riyatehuana nacojé. Iji'ichá caja ji'ima'ulaji, a'achí ri'imá nacojé ricá. ");
INSERT INTO ycn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ejomi ihuá'icha majó jema piracana i'irí pe'iyochá tahuá'aco, cajrú pitacó; inochi ricá, huajñachi ri'ími. Queyajupa huajñájica hua'ajnehuá pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Taca'arí que ri'imacá nuliyá quele nu'urí iphíchari. Capicharo que ri'imacá nuliyá. Caja nupháchiya chuhua ricá”, que rimíchaca rijhua'até sápajeñojlo. Ri'irí iphíchaca aú queyajúparuna ne'emichaca pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ma'apona re'ehué pe'ejí iphíchari namena e'iyayá. Iphíchari riñacaré cópeje, jemi'ichari cajrú nataníchaca, narápi'ichaca. ");
INSERT INTO ycn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aú rihuá'icha apú rara'apá hua'até sápajerijlo. Rimicha rijló: “¿Meque chi nala'acá quele?” ");
INSERT INTO ycn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Rimicha rijló: “Pijmeremi iphíchari. Aú para'apá huacári'ichari huenoca jema piracana i'irí pe'iyochá tahuá'aco, cajrú pitacó, riphíchacale rinacu palá, peyajhueni”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aú re'ehué pe'ejí yúchi'icharo, uncá rihuátalacha pají chojé mujlúca'acana. Raú rara'apá i'ijichari rijhua'até pura'ajó, rimujlúca'acaloje pají chojé penaje. ");
INSERT INTO ycn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Rimicha rara'apajlo: “Picá hue'epiri mequetana júpica nusápaca pijhua'até maare. Palá noma'acá pa'apiyá. E'iyonaja uncá na pa'aqué nojló, nu'umacáloje nujhuáque'ena hua'até queyajupa raú penaje. Cahuayá piracana pa'aquela nojló i'imacá, palani ri'imacajla nojló. ");
INSERT INTO ycn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Eyá quele pi'irí ta iphíchari. Caja ricupata piyuqueja piliñérute inaana ñuju'uquena nacojé. E'iyonaja rijló ta pihuacári'icha jema piracana i'irí cajrú pitacó nócana riphíchaca aú”, que rimíchaca rara'apajlo. ");
INSERT INTO ycn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aú rara'apá quemíchari rijló: “Nu'urí, nujhua'ateja huani picá. Re piyuque nacaje i'imacare nucapi, pile'ejé huánija ricá. ");
INSERT INTO ycn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Chuhuaca palani hue'emajica queyajupa pajhua'atéchaca pijmeremi iphíchaca aú. Caja ri'imá nuliyá taca'arí que. Chuhua nupháchiya taca'arí i'imacá penájemi. Capicharo que ri'imacá nuliyá. Caja nupháchiya chuhua ricá”, que rimíchaca rijló. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús i'imari marí yucu ra'apiyatéjenajlo: —Pajluhuaja ina'uqué i'imichari cajrú le'ejepelari. Apú i'imichari ra'apiyateje. E caja ajopana iphíchaño ricarihuate nacú. Nemicha rijló: “Pa. Uncá paala pa'apiyateje la'acá picá. Ricupata majopeja piliñérute, pinane hua'ató”. ");
INSERT INTO ycn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Raú ricarihuate huá'ichari rimaná. Riphicha rinacu. E rimicha rijló: “¿Picá chi nemá nacú la'arí uncá paala?” Chuhua pa'á nojló papera piyá'atacare chojé nalehuéricare najló, nahuarúhua'acare huemí caje. Caja quetana pi'imacá no'opiyateje”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Raú ra'apiyateje pechu i'imá: “Chuhuata, ¿Meque nula'ajica ta? Chuhua nucarihuate jácho'otajica nucá. ¿Na nacú ca'ajná sápacana i'imajeri palani najló? Uncá nutejmú iphala te'erí ichacana locópa'ala. Eyá liñeru quejá'acana ajopana ina'uqué liyá, uncá paala nojló. Nopáña'o riquejá'acana ja'apí. ");
INSERT INTO ycn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa, caja nupechu iphíchari nujluhua chuhua. Nuhue'epí méqueca nula'ajica, ajopana ina'uqué pechu i'imacáloje nunacu palá raú penaje. Raú nemaje nojló, nu'umacáloje najhua'até nañacaré chu penaje. Nucarihuate jácho'otajicaja nucá ejomi najhua'até nu'umajé”, que ripechu i'imichaca. ");
INSERT INTO ycn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ñaquele rahuacáchiya piyuque necá lehuériño ricarihuátejlo. Pamineco iphácajlo rimá: “¿Méreje pilehuérica huacarihuátejlo?” ");
INSERT INTO ycn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Rimicha rijló: “Nulehuérica rijló cien canecas pu'uteno huánija olivos jilá aú”. Raú ra'apiyateje quemíchari rijló: “Chuhua cincuéntaja pilehuérica rijló. Piyá'o quiñaja, piyá'atachi pipapérane chojé cincuéntaja nulehuérica rijló”. “Je” que. ");
INSERT INTO ycn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","E apujlo rimicha: “Picá ta, ¿méreje pilehuérica rijló?” “Quinientos bultos ca'alá nulehuérica rijló ricá harina penaje aú”, que rimíchaca. E ra'apiyateje quemíchari rijló: “Chuhua pilehuérica rijló cuatro cientos bultos”. Marí que rilamá'achiyaca nalehuéricare. ");
INSERT INTO ycn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","E caja ehuaja riyucuna iphíchari ricarihuate nacú. Raú ripechu i'imá: “¡Meque capechuni ta quele uncá ina'uquélari ta!” Caja quetana riyucuna. E Jesús quemari najló: —Quehuaca, necá uncá jema'alaño Tupana ja'apiyá, capechúruna necá nanaquiyana hua'até pajlácana aú. Raú nachá'ata Tupana ja'apiyá jema'ajeño. ");
INSERT INTO ycn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Uncá numalá ijló, ila'acáloje nacaje pajlácaje aú, palá inacu péchuruna i'imacáloje raú marí eja'ahuá chu penaje. Ilé que la'acana aú uncá iná i'imalaje matajnaco je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Iná huacára'a ca'ajná apú la'acá inajlo huejápaja nacaje, iná amácaloje méqueca rila'acá ricá penaje. Rila'acachu palá ricá, raú iná hue'epí ñaqué caja rila'ajica piño cajrú nacaje palá. Re ca'ajná apú piño, ripajlaca ca'ajná iná hua'até huejápaja. Raú caja iná hue'epí ripajlájica piño iná hua'até cajrú. ");
INSERT INTO ycn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Uncachu pila'alá palá nacaje hua'até marí eja'ahuá chu i'imacare, uncá caja pila'alaje palá nacaje Tupana huátaca que. ");
INSERT INTO ycn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Uncachu ila'alá palá ajopana nane hua'até, uncá caja Tupana a'alaje ijló nacaje ijluhua penaje. ");
INSERT INTO ycn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tupana i'imacachu iná huajhué, uncá iná huajhué calé liñeru. Liñeru i'imacachu iná huajhué, uncá iná huajhué calé Tupana. Iná hue'epícachu liñeru jahuacátacana inajluhua iná tucumó, uncá iná hue'epila Tupana huátaca que la'acana iná tucumó. Uncá meño'ojó iná pechu i'imalá iyamá chuhuá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Marí que rimacá aú fariséona i'ichaño rinacu, íqui'i nahuátacale liñeru. ");
INSERT INTO ycn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","E Jesús quemari najló: —Icá la'añó icó palájne'equena que ina'uquejlo, napechu i'imacáloje palá inacu penaje. E'iyonaja Tupana hue'epiri mecajenaca icá. Ina'uqué nemacárena nacú: “Palájne'equena huani necá” que, apala uncá huani Tupana huátalarena ca'ajná necá. ");
INSERT INTO ycn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesús quemari piño najló: —Tupana puráca'alo, Moisesmi chu lana'acare, yuriro piyuque ina'uquejlo. Ñaqué caja ripuráca'alo, ripuráca'alo ja'apátajeñomi chuna lana'acare, yuriro caja najló. Juanmi chu i'imacá ejená riyuró najló. Tupana i'imatari pamineco ina'uqué capichácajo liyá, ne'emacáloje rijhua'atéjena raú penaje. Juanmi chu queño'orí riyucuna i'imacana ina'uquejlo. Chuhua cajrú ina'uqué la'acá napechu ejé, ne'emacáloje Tupana hua'atéjena raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Piyuque nacaje Tupana puráca'alo lana'aquéjami quemacare nacú i'imajeri rimacá que. Uncá ri'imalaje apojó. Eja'ahuá capichájero. Je'echú capichájero caja. E'iyonaja uncá ripuráca'alo capichálajo. Rimacá rinacu queja ri'imajica. Ñaqué caja ripuráca'alo ñani quemacá que rinacu, queja ri'imajica. ");
INSERT INTO ycn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jesús quemari piño najló: —Apú yurícachu riyajalo, rihuá'acacoloje apa'ahuelo hua'até, la'arí rimanaicho raú. Apa'ahuelo hua'até la'acana queja caja ricá Tupánajlo. Apú ca'ajná huá'acaro riyajálomi, riyurícareru penaje hua'até. Ricá caja la'arí rimanaicho raú. Apa'ahuelo hua'até la'acana queja caja ricá Tupánajlo, apú yajalo jo'ó ru'umacale rijló —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús i'imari piño yucu najló marí que: —Pajluhuaja ina'uqué i'imichari. Cajrú le'ejepelari ri'imichaca. Palá nojé ra'arumacá ra'aqué rinacuhuá. Hue'echú ca'alá queja rajñajica ra'ajnehuá cajrú. Palá nojé, cahuemí nojé a'ajnejí ajñacana nacuja ri'imaqué. Piyuque huani nacaje i'imichaca ricapi. ");
INSERT INTO ycn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Eyá re caja apú ina'uqué i'imichari. Rií i'imichari Lázaro. Camu'ují la'acá ri'imichaca. Cajrú huani musumusuna i'imichaca rinacu. Cajrú le'ejepelari ñacaré numaná nacú riyá'ajico te'erí e'iyá. ");
INSERT INTO ycn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Rimesané naquiyá cajrú a'ajnejí mujrumi cujrúca'ajica. Cacáme'e ri'imajica rajñacana nacú ra'apiyá, rimano'ocáloje raú penaje. Rejé nayahuitena ipháqueño rinacu raphú chiyá apíro'oje. ");
INSERT INTO ycn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","E caja camu'ují la'acá taqui'ichari. Quéchami Tupana hua'atéjena, je'echú chiyájena, huá'ichaño ripéchumi ají que je'echú chojé, Abraham i'imacá ejo. Ejomi cajrú le'ejepelari taqui'ichari caja. E nasi'ichá ritami. ");
INSERT INTO ycn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pu'uhuaré la'ajeño, namanaicho la'ajeño péchumi i'imari apojó. Rejo ripéchumi i'ijichari. Chapú caje yajhué riji'ichá panacu re. Aú riyacá'icho ají ño'ojó. Juca ramicha Abraham, rijhua'até Lázaro i'imichari. ");
INSERT INTO ycn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","E rihuá'icha Abrahamjlo, rimicha rijló: “Chuchú, Abraham, pihue'epí numu'ují. Pihuacára'a majó ilé Lázaro, riyá'achi riyatehuana manáure juni acojé, riyacátacaloje nulená raú penaje. Iqui'i huani nomaca ima'aní yajhué maare siyá chu”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","E'iyonaja Abraham quemíchari rijló: “Nulaqué, picá hue'epiri méqueca nacaje piyuque huani i'imacá picapi, cajmuni pi'imaqué huacajé. Eyá Lázaro i'imari uncá huani paala rihuacajé. Chuhua palánija ricá maare. Eyá picá amari chapú caje yajhué. Caja queja pijló ricá. ");
INSERT INTO ycn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Uncá meque huala'alá. Cajrú huani te'erí mata'acá, ricá itari huapu paliyácaca. Ñaquele uncá meño'ojó iná cuhuá'ala pa'anajo pitá maare eyá. Uncá caja iná cuhuá'ala ilé ño'ojó majó”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Eyá cajrú le'ejepelari quemíchari piño rijló: “Chuchú, Abraham, pila'á nojló nacaje. Pihuacára'a Lázaro nora'apami ñacaré ejo. ");
INSERT INTO ycn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Re nojénami, pajluhua té'ela quele necá. Pihuacára'a ricá rejo, ri'imacáloje riyucuna najló penaje, ne'ejnacá piyá majó. Maare iná amaca chapú caje yajhué”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","E'iyonaja Abraham quemíchari rijló: “Re nacapi Tupana puráca'alo lana'aquéjami, Moisesmi chu lana'acare ina'uquejlo i'imacá. Re caja nacapi Tupana puráca'alo lana'aquéjami, ra'apátajeñomi chuna lana'acare i'imacá. Ra'apiyá jema'acana aú palá ri'imajica najló”. ");
INSERT INTO ycn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","E cajrú le'ejepelari quemíchari rijló: “Que jo'ó, chuchú. E'iyonaja pu'uhuacá pajluhuaja caja taca'arí penájemi i'ijnaquela najló riyucuna i'imajé, napajno'otajla napéchuhua pu'uhuaré nala'acare liyá”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aú rimicha piño rijló: “Moisesmi chu, Tupana puráca'alo ja'apátajeñomi chuna, quele lana'añó Tupana puráca'alo papera chojé i'imacá, ina'uqué a'acáloje nanacojó ricá. Uncaja que nema'á ra'apiyá, uncá caja nema'alaje pajluhuaja taca'arí penájemi macápo'oco ja'apiyá”, que rimíchaca rijló. Caja quetana riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús quemari ra'apiyatéjenajlo: —Re marí eja'ahuá chu nacaje ina'uquejlo, uncá paala. Raú nala'á pu'uhuaré. Re ca'ajná ina'uqué. Nala'á nacaje ca'ajná, na'á nacaje ca'ajná no'opiyá jema'ajéñojlo, nala'acáloje pu'uhuaré raú penaje. Chapú huani ri'imajica najló, na'acale nañaté raú. ");
INSERT INTO ycn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Naca'aquela necá junápeje, cajruni jipa jepo'ocana nanúru'upi nacojé hua'até, palani ri'imacajla najló. Ilé que nala'aquela necá, i'imárijla palani, chapú caje yajhué namájicare ijlunami chojé. Eyá Jesús quemari piño marí que najló: ");
INSERT INTO ycn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","—Ihue'epínoja marí: Iná e'ehué la'ajica ee chapú iná, iná aca'á ricá. Ripajno'otájica ee ripéchuhua pu'uhuaré rila'acare liyá, iná amó richaje. ");
INSERT INTO ycn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Apala iyamá cuhuá'ata que pe pajluhuaja cala japi rila'acá iná chapú. Rila'á iná chapú quehuá ca'ajná rimacá inajlo: “Uncá nula'alaje piño picá chapú” que. Rimájica inajlo que pe iná amájico richaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesús ja'apiyatéjena quemaño Jesusjlo: —Pa'á huañaté, huapechu i'imachi caphí Tupana chojé, ra'acáloje huañaté nacaje la'acana aú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Eyá Jesús quemari najló: —Camu'ujuni mostaza icha ijí. E'iyonaja yenuna rina tahuá'aco. Ñaqué caja huejápaja ñani ipechu i'imaquela caphí Tupana chojé, imajla marí a'ahuanajlo marí que: “Pero'ó picó te'erí e'iyayá, panúca'atachi picó juni jalomi acojé”. Marí que quemacana aú, rema'ájla ja'apiyá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesús quemari piño najló: —Re ca'ajná apú hua'até sápajeri. E lainchu ca'ajná riphá ricarihuate nacú. Te'erí moto'ótacana nacú risapa ca'ajná. Ripirana lamára'acana nacú ca'ajná risapa. Riphá rinacu lainchu. ¿Meque ca'ajná ricarihuate quemacajla rijló? “Majó pi'ijná. Piyá'icho, pajñachi pa'ajnehuá”. ¿Marí que chi rimacajla rijló? ");
INSERT INTO ycn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Uncá ilé que calé rimacajla rijló. Marí que rimacajla rijló: “Chuhua pimoto'ó nojló a'ajnejí, nojñachi no'ojnehuá. Pilamá'ata picó. Nojñaca no'ojnehuá quetana pi'imajica nohua'á, pa'apátacaloje nojló nacaje nuhuátajicare penaje. Nujehuémico pajñá pa'ajnehuá”, que rimacajla rijló. ");
INSERT INTO ycn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Uncá caja rimalajla rijhua'até sápajerijlo: “Palá pili'ichaca nucá” que, rijhua'até sápajeri ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ñaqué caja ijló ricá. Ila'acá aú Tupana huátaca que, imá inacuhuá marí que: “Majopeja rijhua'até sápajeño huecá. Rihuacára'aca que la'ajeño huecá”. ");
INSERT INTO ycn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","E caja Jesús i'ijnari ají que a'ajná ño'ojó. Rihuata Jerusalén ejo i'ijnacana, aú ra'apá ají que iñe'epú chuhuá. Samaria te'eré, Galilea te'eré ihuami chuhuá iñe'epú to'ocó. ");
INSERT INTO ycn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ricá chuhuá ra'apá. Iphari apú pajimila nacojé. Re riphá iyamá té'ela quele ina'uqué ahua'ajé. Natámina ne'emacá. Napona patáca'ataro najló, nacú ne'emá natami. E juca ri'imanoja nahuá'aca Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nemá rijló: —Jesús, Huehuíña'atajeri, pihue'epí camu'ují huanacu —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús amaca aú necá rimá najló: —I'ijná, iya'achíyachi icó sacerdótenajlo —que rimacá najló. E caja ne'ejná ají que a'ajná ño'ojó. Na'apaca nacuja caja natejmo'otó. ");
INSERT INTO ycn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pajluhuaja hue'epiri caja ritejmo'otaco. Samaria eyaje ri'imacá. Raú ripa'ó rapumí chuhuá. Jahuíyo'oqueja rimacá Tupana nacú: —¡Meque palá huani Tupana li'ichaca nucá! ");
INSERT INTO ycn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","E riphá Jesús nacú. E ritára'o ri'irúpachi aú Jesús jimaje. Racúhua'ata rihuíla'aru ají que cahuacaje. E rimá Jesúsjlo: —Palá huani pili'ichaca nucá. Samaria eyaje ri'imacá, quemari rijló marí que. ");
INSERT INTO ycn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Raú Jesús quemari rahua'á i'imacáñojlo: —Iyamá té'ela quele ina'uqué tejmo'ochíyaño. Eta, ¿mere chi ajopana? Pa'u que cuhuá'ata quele yuríchaño, uncá iphálachaño. ");
INSERT INTO ycn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ricaja calé pajluhuaja pi'icharo Tupánajlo quemaje: “Palá pili'ichaca nucá” que. Ajopana te'eré eyaje ricá. ");
INSERT INTO ycn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","E Jesús quemari ritejmo'ótacarejlo: —Pácho'o, pi'ijná. Peyajhueni picá chuhua, caphí pipechu i'imichaca aú nochojé pitejmo'ochiyo —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","E fariséona naquiyana quemaño Jesusjlo: —¿Méquechamica Tupana i'imajica piyuque ina'uqué huacára'ajeri? Jesús quemari najló: —Ina'uqué naquiyana huacára'ajeri Tupana me'etení. Uncá pu'uhuacá calé iná amaca rihuacára'aca rijhua'atéjena. ");
INSERT INTO ycn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Uncá marí que quemacana i'imalaje: “Maare rihuacára'aca necá. A'ajnare rihuacára'aca necá”. Re rijhua'atéjena maare e'iyohuá me'etení —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","E rimá ra'apiyatéjenajlo: —Ina'uquéjloje penaje i'imacá nucá. Ijhua'até nucá me'etení. Aquijñojo uncá nu'umalaje ijhua'até. Rihuacajé ihuátaje nu'umacá ijhua'até, me'etení nu'umacá ijhua'até que caja. Nu'umaquela ijhua'até aquijñojo pajluhua cálaja, palánija ri'imacajla ijló. E'iyonaja calé uncá nu'umalaje ijhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nemaje ca'ajná ijló nunacu marí que i'imajica: “Maare ricá”. Ajopana quemajeño ca'ajná: “A'ajnare ricá.” I'ijnaniya nuculaje, i'ijnaniya caja najhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ina'uquéjloje penaje i'imacá nucá. Pichaní camaré patacá que je'echú jimaya majó, que caja namájica nuphaca majó, nuphájica noná chojé huacajé. ");
INSERT INTO ycn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pamineco nujña'ajé chapú caje yajhué panacu. Ina'uqué, me'etení i'imacaño, la'ajeño nucá chapú. ");
INSERT INTO ycn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Eyá aquijñojo nuphájica majó huacajé, Noémi chu i'imacá huacajé que caja ri'imajica nupa'ajico piyá. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noémi chu i'imaqué huacajé, Tupana huacára'ari cajrú juni ja'acó, pu'uhuaré la'ajeño capichácoloje racojé penaje. Uncá chiyó cajrú juni ja'acó, ina'uqué la'aqueño marí que: Na'ajnehuá ajñacana nacú, nacaje jalá i'iracana nacú ne'emaqué. Huá'acacajo nacú ne'emaqué. Na'aqué caja nayani pajlocaca, nahuá'acacoloje penaje. Marí caje nacú ne'emaqué. E'iyá Noémi chu mujlúca'ari rihuapúrune chojé. Ejéchami mana'í chiyó nacapichaco. ");
INSERT INTO ycn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ñaqué caja ina'uqué la'ajica Lotmi chu i'imaqué huacajé. Najñaque na'ajnehuá; ne'eraqué nacaje jalá; nahuarúhua'aque nacaje paliyácaca; nejátaque nacaje icha ijí ne'ecacapere e'iyá; nala'aqué nañacaró. Caje nacú ne'emaqué. Mana'í chiyoja nacapichaco, uncá nahue'epila nacapichaco jená. ");
INSERT INTO ycn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lotmi chu jácho'oco pajimila Sodoma eyá huacajé, cajrú quera'atani cujúca'aca majó je'echú chiyá azufre hua'até. Cajrú ricujúca'aca pajimila eruna cha. Raú piyuqueja necá capichaño. ");
INSERT INTO ycn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ñaqué caja ri'imajica piño ina'uquejlo yehuicha nupa'ajico yámona. Uncá caja nahue'epílaje nuphájica majó jená. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Rihuacajé ca'ajná e'iyajena i'imajeño pají ji'ihuata chu. Inane i'imajé ca'ajná pají chu. Ihuitúca'aniya rijña'ajé richiyá. Rihuacajé ca'ajná e'iyajena i'imajeño imena e'iyá. Ipa'aniyo piño iñacaré chojé. ");
INSERT INTO ycn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ihue'epí méqueca Lotmi chu yajálomi cholo capichaco, ruyacá'acole ruyámojo pachá, rucapichó i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ñaqué caja ijló ricá me'etení. Huátari ricó mejñátacana, capichájero nuliyá. Uncá hue'epila rinacuhuá, ri'imacáloje nujhua'ateje penaje, i'imajeri nujhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nuphájica huacajé, apala iyamá camátajeño pajluhua cama chu. Nujhua'atéjena, je'echú chiyájena, huá'ajeño pajluhuaja nanaquiyana, nujhua'ateje ri'imacale. Apú yuréjero, uncá no'opiyá jema'ajeri calé ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Rihuacajé caja iyamá inaana tujla'ajeño pajñacani ca'ajná nacaje tujláca'aruna chu. Nahuá'aje pajluhuájaruja, nujhua'atéjeru ru'umacale. Apa'ahuelo yuréjeyo, uncá jema'alayo no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Rihuacajé caja iyamá achiñana i'imajeño ca'ajná namena e'iyá. Nahuá'aje pajluhuaja nanaquiyana, nujhua'ateje ri'imacale. Apú yuréjero, uncá jema'alá no'opiyá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Raú nemá rijló: —¿Meño'ojó ri'imajé quele pimá nacú? Aú Jesús quemari najló: —Meño'ojó nujhua'atéjena i'imajica ejo, reyá nahuá'aje necá ne'iyayá. ");
INSERT INTO ycn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","E Jesús i'imari yucu najló, rehuíña'atacaloje necá penaje, nayurica piyá Tupana hua'até pura'acano, nala'acó piyá ujhuí rijhua'até pura'acano nacú. ");
INSERT INTO ycn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Penaje ri'imá marí yucu najló marí que: —Pajluhuaja ina'uqué i'imichari. Puráca'aloji lamá'atajeri ina'uquejlo ri'imichaca. Pajimila e riñacaré i'imichaca. Uncá riphálacha Tupana ja'apí, uncá caja riphálacha ina'uqué ja'apí. ");
INSERT INTO ycn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ricaja caja pajimila e apa'ahuelo i'imichayo. Ihuacajílomi ru'umichaca. Apú li'ichari chapú rucá, aú metuque ru'ujichacano riyucuna i'imajé rijló. Mahuó ruli'ichaca ricá, rilamá'atacaloje rojló ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ruphaque rinacu. E'iyonaja uncá ra'alá rinacojó rucá. Júpija uncá rihuátalacha rilamá'atacana rojló. E caja ehuaja ripechu i'imichá marí que: “Uncá nuphala Tupana ja'apí, uncá caja nuphala ina'uqué ja'apí. ");
INSERT INTO ycn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","E'iyonaja no'ojé ilerú ihuacajílomi ñaté, rucahuíla'acale huani nunacu. Nupura'ajó ruchaya, ru'ujnacá piyá metuque huani majó, roya'átaca piyá nucá”, que ripechu i'imichaca —que Jesús i'imacá yucu. ");
INSERT INTO ycn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ejomi Jesús quemari piño najló: —Uncá ina'uquélari ilé puráca'aloji lamá'atajeri i'imacá. E'iyonaja rimá: “No'ojica ruñaté” que. ");
INSERT INTO ycn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eyá Tupana, quiñaja ra'ajica nañaté, necá ri'ihuapacárena ajopana ina'uqué e'iyayá. Nacaje riliyá quejá'ajeño necá. Hue'echú, lapí hua'ató nemá rijló, ra'acáloje nañaté penaje. Uncá cachuhua calé ra'ajica nañaté. ");
INSERT INTO ycn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Quiñaja ra'ajica nañaté. Marí que ijló ricá. E'iyonaja nupa'ajico majó huacajé, apala uncá nuphátalaje caphí Tupana chojé péchuruna. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Marí que ina'uqué naquiyana pechu i'imacá nanacuhuá: “Ajopana chaje nucá. Ajopana ina'uqué uncá ina'uquélaruna necá,” que napechu i'imacá nanacuhuá. Ñaquele Jesús i'imari apa'amá yucu najló, rehuíña'atacaloje necá Tupana nacú raú penaje. Marí yucu ri'imá najló i'imacá: ");
INSERT INTO ycn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Iyamá ina'uqué i'ijichaño Tupana ñacaré chojé Tupana hua'até pura'ajó. Apú i'imichari fariséona naquiyana. Apú i'imichari liñeru ña'ajeri ne'emacánajlo. ");
INSERT INTO ycn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","E fariseo puri'icharo Tupana hua'até. Marí que rimíchaca rijluhua: “Tupana, palá pila'acá nucá. Re ina'uqué, uncá ina'uquélaruna necá. Re caja piro'oquéjena. Re caja calúyana nacú cahuíla'ajeño. Uncá ñaquejé calé nucá. Raú palá pila'acá nucá. Uncá caja ilé tára'aro caje calé nucá. Liñeru ña'ajeri hue'emacánajlo ricá. ");
INSERT INTO ycn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nucá i'itaró no'ojné liyá iyamá peno que pajluhuaja sápacaje japi, pipechu i'imacáloje nunacu palá raú penaje. Marí queno nula'acá liñeru nucánacare aú: Iyamá té'ela queta naquiyana no'ó pijló pajluhuátano”, que rimíchaca Tupana hua'até pura'acano aú. ");
INSERT INTO ycn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Eyá liñeru ña'ajeri ne'emacánajlo tári'icharo juca pani ajopana ahua'ayá. Rihuó li'icharo je'echú chojé yacá'acano piyá. Ritujli'ichá ricó ri'icú chiyá riyáte'ela aú, ujhuí ripechu i'imichácale rinacuhuá. E marí que rimíchaca Tupánajlo: “Tupana, pihue'epí numu'ují. Pu'uhuaré la'ajeri nucá. Uncá ina'uquélari caja nucá”, que rimíchaca rijló. Maáreje riyucuna tajnaro. ");
INSERT INTO ycn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ejomi Jesús quemari piño najló: —Liñeru ña'ajeri ne'emacánajlo pa'aró riñacaré chojé. Palá Tupana pechu i'imacá rinacu. Eyá apú, fariséona naquiyana, uncá Tupana pechu i'imalá rinacu palá. Uncá paala Tupánajlo, iná pechu i'imacachu iná nacuhuá marí que: “Nucá chá'atari ajopana” que. Raú Tupánajlo iná i'imá ajopana ja'apejé. Iná pechu i'imacachu iná nacuhuá: “Ajopana chá'ataño nucá” que. Tupánajlo iná i'imá ajopana chaje raú —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ajopana huá'año Jesús ejo yuhuaná, rito'otácaloje riyáte'ela nanacu penaje. Ra'apiyatéjena amaca aú nahuá'aca necá rejo nahuíyo'o najló richá, nahuá'aca piyá yuhuaná Jesús ejo. ");
INSERT INTO ycn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","E'iyonaja Jesús huá'ari yuhuanajlo, ne'ejnacáloje richaje penaje. E rimá ra'apiyatéjenajlo: —Reja yuhuaná i'ijnareja nuchaje. Itániya napu, ne'ejnacá piyá nuchaje. Yuhuaná que i'imacaño i'imaño caja Tupana hua'atéjena. Nahuacára'ajeri ricá. ");
INSERT INTO ycn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ihue'epí marí: Uncá meño'ojó ina'uqué i'imalá Tupana hua'atéjena, uncachu napechu i'imalá yuhuaná pechu que caja rinacu. Yuhuaná huátaño Tupana nañaté a'ajeri penaje. Uncachu ajopana ina'uqué huátalaño Tupana nañaté a'ajeri penaje, uncá meño'ojó ne'emalá rijhua'atéjena, namujlúca'acaloje je'echú chojé penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pajluhuaja nahuacára'ajeño naquiyana quemari Jesusjlo: —Ina'uqué jehuíña'atajeri picá. Palani picá —que rimacá—. ¿Meque nula'acajla, nu'umacáloje Tupana hua'até matajnaco je'echú chu raú penaje? ");
INSERT INTO ycn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús quemari rijló: —¿Naje pimá nunacu: “Palani” que? Ricaja calé, Tupana, palani. Uncá palani calé ina'uqué. ");
INSERT INTO ycn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Caja pihue'epí méqueca Tupana puráca'alo lana'aquéjami quemacá. Uncá rihuátala achiñá, inanaru hua'até la'acá namanaicho pajhua'atéchaca. Uncá caja rihuátala iná noca ina'uqué. Uncá caja rihuátala iná ata'acá nacaje. Uncá caja rihuátala iná pajlaca ina'uqué hua'até. Uncá caja rihuátala iná iphaca iná ja'apihuá iná chi'inajlo. Rihuata iná iphaca na'apí palá —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","E rimá rijló: —Caja nujyuhuaco noma'á ra'apiyá maáreje cha. ");
INSERT INTO ycn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Marí que rimacá aú rijló Jesús quemari rijló: —Re pajluhuaja ñani nacaje yuriro pitucumá, pila'acáloje palá raú penaje. Eco pa'atá ajopánajlo piyuque pinane rihuemí aú. Rejomi pitamáca'ata piyuqueja piliñérute camu'ují la'acáñojlo. Marí que la'acana aú cajrú nacaje, palá nojé i'imajé pijló je'echú chu. Quéchami pipa'ajico piño majó, pi'ijnacáloje nujhua'até no'opiyateje penaje —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Marí que rimacá rijló aú camu'ují huani ripechu la'acó rinane hua'até. Uncá ra'alá rinacojó ripuráca'alo, cajrú le'ejepelari ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús amari camu'ují ripechu i'imacá. Raú rimá ajopánajlo: —Puhuichani huani cajrú le'ejepelárunajlo nachó yurícana Tupánajlo, ri'imacáloje nahuacára'ajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Puhuichani caméllojlo luhuirí aphú chiyá ja'apácana. Richaje puhuichaca cajrú le'ejepelárunajlo nachó yurícana Tupánajlo, ri'imacáloje nahuacára'ajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Raú ripuráca'alo jema'ajeño quemaño pajlocaca: —¿Mecajena ca'ajná Tupana i'imatájeri rijluhua capichácajo liyá? ");
INSERT INTO ycn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","E Jesús quemari najló: —Uncá meño'ojó ina'uqué i'imatala necó capichácajo liyá. Tupánaja calé i'imatari ina'uqué capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","E Pedro quemari rijló: —Huahuacára'ajeri, huecá yuriño piyuqueja huanane, hue'ejnacáloje pijhua'até penaje. ");
INSERT INTO ycn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús quemari rijló, ajopánajlo hua'até: —Nala'acáloje nuhuacára'aca que penaje, ina'uqué naquiyana yuriño nañacaré ca'ajná. Uncá nahuá'acalo ca'ajná. Ne'ejnañáaja nejena ca'ajná, nachi'iná ca'ajná, nate'eré ca'ajná, nala'acáloje nuhuacára'aca que penaje. Nayani caja ñapácaño ca'ajná ne'ejnañáa, nala'acáloje nuhuacára'aca que raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Palá huani ri'imajica marí que la'acáñojlo. Ñó'ope caja Tupana a'ajica nañaté. Tupana a'ajeri caja necá, ne'emacáloje matajnaco je'echú chu rijhua'até penaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús huá'ari ra'apiyatéjena juca pani ajopana ina'uqué liyá. E rimá najló: —Chuhua hue'ejnajica Jerusalén ejo. Re nala'ajé nucá chapú. Tupana puráca'alo ja'apátajeñomi chuna quemacá chojé nuphaje. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Re na'ajé nucá ajopánajlo, uncá judíonajlo calé. Necá la'ajeño namácaja nucá. Napura'ajó nunacu pu'uhuaré. Natupaje caja nahui nunacojé. ");
INSERT INTO ycn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Naña'ataje caja nucá. Quéchami nenójica nucá. E'iyonaja hueji que cala i'imajemi numacápo'ojo piño nopumí chuhuá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ra'apiyatéjena uncá hue'epílaño meque quemacánaca rimacá najló. Me'echuje ri'imacá najló, uncá riphala napechu nacú. ");
INSERT INTO ycn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","E caja Jesús iphari pajimila Jericó nacojé. Re iñe'epú turená pajluhuaja ina'uqué yá'aro, riquejá'acaloje liñeru ina'uqué liyá rijluhua penaje, mejlurú ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","E rema'á cajrú ina'uqué ja'apaca rahua'ayá iñe'epú chuhuá. Raú rimá najló: —¿Naje cajrú huánijle ina'uqué ja'apaca maárohua? ");
INSERT INTO ycn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nemá rijló: —Jesús, Nazaret eyaje, ja'apácare chuhuá marí iñe'epú —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Raú jahuíyo'oqueja rihuá'aca rijló. Rimá rijló: —Jesús, ina'uqué i'imatájeri Tupánajlo penaje picá. Pihue'epí numu'ují. ");
INSERT INTO ycn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jesús tucumá ja'apájeño aca'añó ricá: —¡Pimanúma'o ta! —que nemacá rijló. E'iyonaja richaje huani rahuíyo'oca raú: —Ina'uqué i'imatájeri Tupánajlo penaje picá. Pihue'epí numu'ují —que rihuá'aca Jesúsjlo. ");
INSERT INTO ycn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Raú Jesús tajnaro rejé. Rimá najló, nahuá'acaloje ricá rahua'ajé penaje. Riphaca rinacu ee rimá rijló: ");
INSERT INTO ycn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Meque pihuátaca nula'acá picá? Mejlurú quemari rijló: —Huahuacára'ajeri, pa'apata nuliyá mejlucaji, nomachi. ");
INSERT INTO ycn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús quemari rijló: —Piyacá'o chuhua. Caja pi'imichó mejlucaji chiyá, pipechu i'imichácale nunacu: “Ricá ja'apátajeri nuliyá mejlucaji”. Aú no'opáchiya piliyá ricá. ");
INSERT INTO ycn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ejéchami mejlurú penájemi amaca palá. Aú ri'ijná Jesús hua'até. Palá ripura'acó Tupana nacú. Ñaqué caja Jesús hua'até chira'ajeño pura'acó Tupana nacú palá. ");
INSERT INTO ycn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","E caja Jesús iphari pajimila Jericó e'iyajé. E ra'apá ají que pajimila e'iyohuá. ");
INSERT INTO ycn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Re pajluhuaja ina'uqué i'imari. Liñeru miná huani ri'imacá. Rií i'imari Zaqueo. Liñeru ña'ajeño ne'emacánajlo huacára'ajeri ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Eyá caja Zaqueo huátari Jesús amácana. E'iyonaja cajrú huani ina'uqué chipúca'ari Jesús nacú tujlá que. Huajáca'alami Zaqueo i'imacá. Ñaquele uncá meño'ojó ramala ne'iyayá Jesús. ");
INSERT INTO ycn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ñaquele recho'ó ají que a'ajná ño'ojó natucumajo. I'ijrari a'ahuaná nacuhuá, ramácaloje ricá reyá i'imajemi penaje. A'ahuaná ií i'imari sicómoro. Ricá nacuhuá ri'ijrá. Jesús apu ahua'á ritára'o i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús iphari riloco'opani. Aú riyacá'o richaje, amari ripato'ocó a'ahuaná nacú. E rimá rijló: —Zaqueo, quiñaja pihuitúca'aca majó. Chuhuajá nuyurejo pijhua'até piñacaré chu. ");
INSERT INTO ycn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Raú rihuitúca'a cara cara que a'ahuaná naquiyá. E rimá Jesusjlo, ri'ijnacáloje rijhua'ató riñacaré chojé penaje. Pu'ují rihuó i'imacá richá. ");
INSERT INTO ycn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ajopana amaca aú Jesús i'ijnacá rijhua'até nachapújra'aco Jesús nacú. Nemá rinacu: —Chuhua ri'ijichaca uncá ina'uquélari hua'até, ri'imacáloje rijhua'até riñacaré chu penaje —que nemacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","E caja mequetánaja ne'emacá riñacaré chu. E Zaqueo tára'aro, rimá Jesusjlo: —Pema'á, pe'iyojé nunane naquiyana no'ojé camu'ují la'acáñojlo. Júpimi nupajlaque ajopana ina'uqué hua'até, nujña'acáloje nujluhua naliñérute naquiyana penaje. Chuhua nupa'atájica piño najló naliñérute. Pajluhuata papera nujña'acárena liyajlo nupa'ataje pa'u queta richaje rapumí chojé. Ñaqué huánija nupa'atájica najló liñeru rapumí chojé —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Raú Jesús quemari rijló: —Chuhuajá piñacaré chu maare Tupana i'imachíyari picá rijluhua capichácajo liyá. Abrahami chu laquemi picá. ");
INSERT INTO ycn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ina'uquéjloje penaje i'imacá nucá, nu'ujná majó nu'umatácaloje ina'uqué capichácajo liyá penaje —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na'apaca nacú Jesús i'imari najló yucu. Yehuicha nephaca Jerusalén ejo. E rijhua'até chira'ajeño pechu i'imá: “Yehuíchaja riphaca rená chojé, Tupana i'imacáloje piyuque ina'uqué huacára'ajeri penaje”. Ñaqué i'imacale Jesús i'imari najló yucu, nahue'epícaloje rinacojé raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Marí que ri'imacá yucu najló: —Pajluhuaja ina'uqué i'imichari nahuacára'ajeño i'irí. Ricá i'ijichari ya'ajnaje ajopana te'eré ejo, na'acáloje rejo ricá necó huacára'ajeri penaje. Rejomi rihuáchiya rapumí chuhuá pa'acano. ");
INSERT INTO ycn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ri'ijichaca yámona rihuá'icha rijhua'até sápajeño maná. Iyamá té'ela quele ne'emichaca. Necá maná rihuá'icha. Raú ne'ejichá rejo. Riyámona ritamáca'achiyaca najló cajrú liñeru apujlo, apujlo que. Réjenohuaja ra'achacá najló ricá. E rimicha najló: “Caja no'ochá ijló liñeru. Raú ijña'ajé ijluhua richaje nu'umajica rejo quetana”, que rimíchaca najló. “Je”. ");
INSERT INTO ycn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ejomi ri'ijichá ají que a'ajná ño'ojó. Uncá huani rite'eré eruna naquiyana huátalacha ricá. Chapú napechu i'imichaca rinacu. Raú nahuacári'icha ajopana ina'uqué rápumi chu rijló quemaje: “Uncá huahuátala picá hue'emacana penaje”. ");
INSERT INTO ycn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","E caja ya'ajná na'achá ricá rite'eré eruna huacára'ajeri penaje. Ejomi ripi'ichó rite'eré ejo. E caja riphicha piño nanacu rapumí chuhuá. E rihuá'icha rijhua'até sápajeño maná. Ra'acárenajlo liñeru i'imacá maná rihuá'icha. Rihuáchiya riliñérute yucuna quejá'acana naliyá, apú liyá, apú liyá que, ramácaloje mérejeca nacánaca liñeru raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pamineco iphíchaca rinacu quemíchari rijló: “Huahuacára'ajeri, diez mil pesos pa'á nojló i'imacá. Raú nucana richaje cien mil pesos”. ");
INSERT INTO ycn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ne'emacana quemíchari rijló: “A'a, palani. Palani nujhua'até sápajeri picá. Palá pila'acá huejápaja aú. Ñaquele chuhua no'ojica picá ne'emacana penaje. Iyamá té'ela quele pajimila chiyájena huacára'ajeri penaje no'ojé picá”. ");
INSERT INTO ycn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Rejomi apú piño iphíchari rinacu. Rimicha rijló: “Huahuacára'ajeri, diez mil pesos pa'á nojló i'imacá. Raú nucana cincuenta mil pesos richaje”. ");
INSERT INTO ycn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Rimicha rijló: “Pajluhua té'ela quele pajimila chiyájena huacára'ajeri penaje no'ojé picá”. ");
INSERT INTO ycn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Eyá apú piño iphíchari rinacu. Rimicha rijló: “Marí piliñérute. Palá nulamá'ataca pijló ricá nulejuné chu jepo'otáqueja. ");
INSERT INTO ycn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nuquero'ó pipiyá, caphí pihuacára'acale ina'uqué. Pihuacára'a nejátaca pijló nacaje icha ijí, richa i'imacáloje pijluhua penaje. Uncá pisápala pimena e'iyá, e'iyonaja re nacaje pile'ejé pacá penaje”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Raú ne'emacana quemíchari rijhua'até sápajerijlo: “¡Meque uncá huani ina'uquélari ta picá quele!” Ilé pimíchaca nunacu aú iná hue'epí uncá huani paala pila'acá. Marí pihue'epí quehuaca: caphí nuhuacára'aca ina'uqué. Pihue'epícare caja nejátaca nojló nacaje icha ijí, richa i'imacáloje nujluhua penaje. Pihue'epícare caja uncá nusápala numena e'iyá. E'iyonaja re nacaje nule'ejé pacá penaje re'iyayá. ");
INSERT INTO ycn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Caja pihue'epí marí caje nucá. Eta, ¿naje uncá pihuacára'ala ricá liñeru ñacarelana chojé, na'acáloje liñeru ñaté penaje? Naya'atajla ajopánajlo ricá, richaje quemachi napa'atajla pijló ricá. Marí que pila'aquela, aú pipa'atajla nojló piño nuliñérute richaje hua'até”, que rimíchaca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Raú rimicha re i'imichácañojlo: “Ijña'á riliyá riliñérute, a'achí ilé cánari cien miljlo ricá”. ");
INSERT INTO ycn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nemicha rijló: “Hue'emacana, caja cajrú riliñérute, cien mil ricapi”. ");
INSERT INTO ycn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Raú ne'emacana quemíchari najló: “Numá ijló, cajrú nacaje i'imacárena cápijlo no'ojé richaje. Uncá na i'imalárena capi liyá, nujña'ajé huejapa nacaje i'imacare nacapi”, que nahuacára'ajeri quemíchaca najló. ");
INSERT INTO ycn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","E rimicha piño najló: “Chuhua re chapú péchuruna nunacu. Uncá nahuátala nucá ne'emacana penaje. Chuhua ihuá'icha necá majó, inochi necá nujimaje”, que rimíchaca najló —que Jesús i'imacá yucu najló. ");
INSERT INTO ycn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús i'imari najló yucu marí que i'imacá. Ejomi ra'apá natucumá Jerusalén ejo. ");
INSERT INTO ycn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","E riphá iyamá pajimila nacojé a'ajná ño'ojó. Yenuri Olivos ja'apí ricá pajimila, rejé nephá. Ejéchami rihuacára'aca iyamá ra'apiyatéjena pajimila ejo. ");
INSERT INTO ycn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Rimá najló: —I'ijná ají ño'ojó pajimila ejo huatucumajo. Re amaje cahuarú caje i'irí a'aqueja mucuri. Uncá jo'ó na ja'apálare nacú ricá. Ricá icaráca'a. Quéchami ihuá'aca ricá majó. ");
INSERT INTO ycn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nemájica ee ijló: “¿Naje chi icaráca'a ricá?” imaje najló: “Huahuacára'ajeri huátari ricá mequetánajajloje penaje” —que Jesús quemacá najló. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aú ne'ejná ají que a'ajná ño'ojó natucumajo. Amaño cahuarú caje i'irí a'aqueja mucuri. Jesús quemacá que namaca ricá. ");
INSERT INTO ycn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","E nacaráca'a ricá. Ejéchami paminana quemacá najló: —¿Naje ta icaráca'a quele? ");
INSERT INTO ycn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nemá najló: —Huahuacára'ajeri huátari ricá. —Je, ñaqué ricá. Icaráca'a ricá. ");
INSERT INTO ycn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aú nahuá'a ricá Jesús ejo. Nayúma'a na'arumacá naquiyana cahuarú huajlé chojé. E nácho'ota Jesús rihuajlé chojé yá'ajo. ");
INSERT INTO ycn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","E Jesús ja'apari rinacu. Cajrú ina'uqué i'imacá re. Necá caja ayúma'año na'arumacá naquiyana ra'apaca ehuá. Palá napechu i'imacale Jesús nacú, nala'á ilé que. ");
INSERT INTO ycn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ají que na'apaca Jerusalén nacojé. E caja nephá yenuri Olivos queñóca'ala ejé. Re piyuque ra'apiyá jema'ajeño, rijhua'até ja'apájeño ne'emacá, jahuíyo'oño cajrú, pu'ují napechu i'imacale Jesús nacú. Caja namá Jesús la'acá cajrú nacaje palani huani, nacaje uncá meño'ojó iná la'alare caje. Raú napura'ó Tupana nacú palá. ");
INSERT INTO ycn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Marí que nemacá jahuíyo'oqueja Jesús nacú: —Palani huani Hue'emacana, Tupana huacára'acare majó. Pu'ují je'echú chu i'imacaño pechu rinacu. Palani huánija Tupana —que nemacá rinacu jahuíyo'oqueja. ");
INSERT INTO ycn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Re caja najhua'até fariséona naquiyana i'imacá. Nema'acá aú nahuíyo'oca marí que, nemá Jesusjlo: —Huehuíña'atajeri, pihuacára'a pijhua'atéjena nahuíyo'oca piyá. ");
INSERT INTO ycn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús quemari najló: —Numaquela najló, nanúma'acoloje penaje, napumí chojé jipa jahuíyo'ojla caja —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","E caja Jesús iphari Jerusalén nacojé. Pajimila amácana aú riyá pajimila e i'imacaño hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Rimá pajimila e i'imaimila e i'imacaño nacú marí que: —Nahue'epíquela me'etení na ina'uqueca la'arí iná pechu palá, palani ri'imacajla najló. Me'echuje jo'ó najló naca nucá. Uncá jo'ó nahue'epila. ");
INSERT INTO ycn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aquijñojo napinana jahuacátaje marí pajimila nacojé. Chipu, chipu que nahuacájico rinacojé. Netaje napu, nácho'oco piyá richiyá. ");
INSERT INTO ycn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nacapichátajica piyuque pajimila eruna; nacajya'at riyá pajimila e i'imaaje caja pajimila piyuqueja; uncá nayurílaje pajluhuaja ñani jipa pachácaca. Marí que nala'ajica necá, uncá pachá nahue'epila méquechamica Tupana i'imacá najhua'até, ri'imatácaloje necá capichácajo liyá penaje —que Jesús quemacá Jerusalén eruna nacú. ");
INSERT INTO ycn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nephá pajimila ejo. Ejomi Jesús mujlúca'ari Tupana ñacaré chojé. E ra'apá richujena nacú. Nacaje a'ajeño, nacaje huarúhua'ajeño, necá i'imaño re. Necá nacú ra'apá richiyá. ");
INSERT INTO ycn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","E rimá najló: —Tupana puráca'alo lana'aquéjami quemari marí que: “Re nuñacaré ina'uqué pura'acóloje nujhua'até richu penaje”, que rimacá. E'iyonaja icá apichátaño ricá. Icá a'añó ina'uquejlo nacaje richu rihuemí aú. Richuhuaja ata'á necá. Ata'ajeño ñacaré que ijló ricá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hue'echú ca'alá queja Jesús jehuíña'atajica necá Tupana ñacaré chu. Sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, pajimila eruna huacára'ajeño, quele i'imaño re. Ne'ejnatá napéchuhua rinacu méqueca nenócajla ricá. ");
INSERT INTO ycn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Uncá napechu iphala rilocópa'ala, huechi cajrú ina'uqué jema'acale ripuráca'alo. ");
INSERT INTO ycn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Apú huacajé Jesús i'imari piño Tupana ñacaré chu. Re rehuíña'ata ina'uqué Tupana nacú. Tupana i'imataca ina'uqué capichácajo liyá yucuna ri'imá najló. E'iyohuá que sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, peñahuilana, quele iphaño rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nemá rijló: —Chuhua pimá huajló, na puráca'alo aú ca pila'á nacaje. ¿Na quemari pijló, pila'acáloje ricá penaje? ");
INSERT INTO ycn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús quemari najló: —Ñaqué caja nuquejá'ajica iliyá nacaje yucuna, i'imacáloje nojló riyucuna penaje. Eco ja'ajipá nojló. ");
INSERT INTO ycn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Na puráca'alo aú chi Juanmi chu la'aqueri bautizar ina'uqué, ina'uqué puráca'alo aú ca'ajná, Tupana puráca'alo aú ca'ajná? ");
INSERT INTO ycn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Raú napura'ó pajhua'atéchaca necámica que. Nemá pajlocaca: —¿Meque huemájica rijló? Huemáquela rijló, “Tupana puráca'alo aú que”, rimajla huajló: “¿Naje chi uncá jema'alá ra'apiyá i'imacá?” que. ");
INSERT INTO ycn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Eyá huemaquela rijló: “Ina'uqué puráca'alo aú rila'á nacaje” que, aú maare i'imacaño yúcha'añojla huachá. Naca'ájla jipa huachá rijimaje. Tupana puráca'alo ja'apátajeri Juanmi chu i'imacá, que napechu rinacu —que napura'acó pajhua'atéchaca necámica que. ");
INSERT INTO ycn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","E nemá Jesusjlo: —Capí. Uncá huahue'epila na puráca'alo aú ca Juanmi chu la'aqueri bautizar ina'uqué. ");
INSERT INTO ycn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—Ñaqué uncá caja numalaje ijló na puráca'alo aú ca nula'acá nacaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","E Jesús i'imari najló yucu, rehuíña'atacaloje necá raú penaje. Rimá najló: —Pajluhuaja ina'uqué ejáchiyari cajmú caje ri'icacapere e'iyá. Jepepí inarí cajmú i'imichaca. Quéchami riyuríchaca rijhua'até sápajeño naquiyánajlo ri'icacapere, namácaloje rijló ricá penaje. E caja ri'ijichá ajopana te'eré ejo. Ri'ijichaca yámona rimicha najló: “Chuhua nu'ujichaca. Eco amá ricá palá. Cajmú naquiyana no'ojé ijló rihuemí, amaca nojló ricá huemí”, que rimíchaca najló. “Je” que. E ri'ijichá ya'ajnaje. Júpija ri'imichaca ya'ajnó. ");
INSERT INTO ycn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","E caja richa ña'acana iphíchari rená chojé. Aú paminá huacári'ichari rijhua'até sápajeri richa ña'acana rijló penaje. E ri'ijichá rejo, iphíchari nanacu. Eta, rimena amájeño i'icachíyaño rihuilá. Ejomi nahuacári'icha ripa'acó majopeja. ");
INSERT INTO ycn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Rejomi paminá huacári'ichari piño apú rijhua'até sápajeri rejo. Ñaqué caja nali'ichaca ricá. Chapú huani nali'ichaca ricá, ne'ecachiya rihuilá. Ejomi nahuacári'icha ripa'acó majopeja caja. ");
INSERT INTO ycn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ejomi paminá huacári'ichari piño apú rejo. Ñaqué caja nali'ichaca ricá chapú. Quehuí nali'ichaca rinacu. Quéchami naqui'ichaca ritami rimena yámojo. ");
INSERT INTO ycn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Raú paminá pechu i'imá: “¿Meque nula'ajica? Palani ca'ajná nuhuacára'acajla rejo nu'urí, íqui'ija nuhuátacare. Ricá ja'apí ca'ajná nephajla”, que ripechu i'imichaca. ");
INSERT INTO ycn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Raú rihuacári'icha ri'irí rejo. Rimena amájeño amíchaño ricá huaíchaca a'ajnareje cha que, nemícha pajlocaca: “Ilé ri'irí huaícha. Rijló rara'apá yuréjeri rimena. I'ijná huenóchachi ricá, rimenami yurícoloje huajló penaje”, que nemíchaca pajlocaca. ");
INSERT INTO ycn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","E caja riphicha nanacu. Eta napachiya ricá; naji'ichá ricá rimena yámojo. Re nenocha ricá —que Jesús i'imacá yucu najló. E Jesús quemari najló: —Marí que paminá la'ajica rimena amájeño. ");
INSERT INTO ycn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Riphaje nacapichátaje. Quéchami ra'ajica ajopánajlo rimena, ramájeño penaje —que rimacá najló. Raú ripuráca'alo jema'ajeño quemaño Jesusjlo: —Ri'imaniya ilé que huajló. ");
INSERT INTO ycn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aú Jesús yacá'aro nachaje, rimá najló: —Marí que Tupana puráca'alo lana'aquéjami quemacá nunacu i'imacá: Pajluhuaja ina'uqué i'imajeri. Ne'iyajena quemájeño rinacu: “Uncá ina'uquélari ricá” que. E'iyonaja ricá i'imajeri ajopana chaje, que rimacá nunacu. ");
INSERT INTO ycn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Necá, uncá jema'alaño no'opiyá, capichájeño Tupana liyá. Chapú huani ri'imajica najló. Uncá huátalaño nucá, amájeño chapú caje yajhué nupuráca'alo aú —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ejéchami sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, quele huátaca Jesús patacana. Yucu ri'imá najló i'imacá. E'iyonaja nahue'epí rimacá nanacu raú meque la'ajéñoca necá. Ñaquele nahuata ripatacana, nahuajácaloje ricá penaje. E'iyonaja calé naquero'ó ina'uqué piyá marí la'acana aú. ");
INSERT INTO ycn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Raú nahuacára'a riquejíla'ajeño rejo rijhua'até pura'ajó. Chapú rinacu péchuruna ne'emacá. E'iyonaja calé nala'á necó palájne'equena que caja rijló. Nahuata Jesús liyá yucu jema'acana, nema'acáloje méqueca rimájica apojó ne'emacana liyá penaje. Aú nahuata rijña'acana ne'emacana ejo, rihuajácaloje ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","E caja riquejíla'ajeño iphaño rinacu. Nemá rijló: —Huehuíña'atajeri, huahue'epí quehuácaje pipuráca'alo. Quehuaca nacaje pehuíña'atacare nacú. Picá hue'epiri méqueca ina'uqué pechu i'imacá. Re huahuacára'ajeño naquiyana, uncá paala najló pipuráca'alo. E'iyonaja uncá pa'alá necá pinacojó. Pajimato pehuíña'ataca ina'uqué Tupana huátaca que la'acana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Chuhuata pimá huajló méqueca pipechu marí nacú. Naquejá'a hualiyá liñeru, na'acáloje ricá hue'emacana Césarjlo penaje. Romano naquiyana ricá. ¿Meque chi pijló ricá? ¿E chi hua'acajla najló liñeru, naquejá'acare hualiyá hue'emacánajlo? ¿Echi palani hua'acajla najló ricá ca'ajná, uncá ca'ajná? ");
INSERT INTO ycn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús hue'epiri na penájeca naquejá'aca riyucuna, nemacáloje rinacu: “Pu'uhuaré rimíchaca huajló,” que penaje. Aú rimá najló: —¿Naje ihuata numacá ijló nacaje nacú, imacáloje nunacu: “Pu'uhuaré rimíchaca huajló”, que penaje. ");
INSERT INTO ycn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Iya'atá nojló liñeru naquejá'acare iliyá i'imacánajlo, nomachi ricá. Aú naya'atá rijló ricá. E rimá najló: —¿Na jenami chi cari liñeru nacú? ¿Na ií cari lana'aquéjami rinacu? Nemá rijló: —Hue'emacana César jenami rinacu. Rií caja rinacu —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús quemari najló: —A'á Césarjlo quele liñeru rihuátacare. Ila'á caja Tupánajlo nacaje rihuátacare —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Marí que naquejá'aca riyucuna ajopana ina'uqué e'iyá. Marí que rimacá aú uncá meño'ojó nemalá: “pu'uhuaré rimíchaca pinacu” que ne'emacánajlo. Raú namanúma'o. Napechu i'imá: “¡Meque capechú huani rimíchaca huajló!” ");
INSERT INTO ycn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Quéchami saducéona naquiyana i'ijnacá piño Jesús amaje. Necá quemaño caja taca'acaño nacú: “Uncá namacápo'olajo.” Ñaqué i'imacale ne'ejná Jesús chaje rijhua'até pura'ajó. E nemá rijló: ");
INSERT INTO ycn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Huehuíña'atajeri, marí que Moisesmi chu puráca'alomi lana'aquéjami quemacá: “Apú ca'ajná taca'añari riyajalo mayaniqueru. Palani re'ehuemi ra'apiyajé huá'acacojla riyajálomi hua'até, re'ehuemi chu yanimínami yurícoloje rapumí chojé raú penaje”, que ripuráca'alomi lana'aquéjami quemacá. ");
INSERT INTO ycn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ñaqué ricá. Pajluhua ina'uqué i'imari. Iyamá cuhuá'ata quele ne'emacá rejena hua'até. Pe'ejí ri'imacá huá'acaro. Ejomi ritaca'á mayaniqueru. ");
INSERT INTO ycn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Rejomi ra'apiyajé i'imacá huá'acaro riyajálomi hua'até. Ñaqueja caja ricapichaco ruliyá mayaniqueru caja. ");
INSERT INTO ycn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Raú re'ehué pe'iyorí huá'acaro piño rujhua'até. Ricapichó caja ruliyá mayaniqueru caja. Ají que iyamá cuhuá'ata quele necá huá'acaco rujhua'até i'imacá. Caja queja nacapichaco ruliyá mayaniquéruja. ");
INSERT INTO ycn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Caja penaje nayajálomi capichayo nápumi chu. ");
INSERT INTO ycn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Eta, Tupana macápo'otajica piyuque ina'uqué caja taca'acaño huacajé, ¿na yajalo chi ruyuríjico rejéchami? Iyamá cuhuá'ata quele ina'uqué yajálomi ru'umacá —que nemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Raú Jesús quemari najló: —Marí eja'ahuá chu achiñana, inaana, quele huá'acaño pajhua'atéchaca. Eyá je'echú chu i'imajeño, uncá ñaqué calé ne'emajica rejo je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tupana macápo'otajeri ra'apiyá jema'ajéñomi chuna, ne'emacáloje je'echú chu penaje. Re uncá pajhua'atéchaca huá'acajeñomi calé ne'emajica. Uncá caja nahuá'acalajo piño pajhua'atéchaca re. Uncá caja na'alaje nayani, nahuá'acacoloje pajhua'atéchaca penaje. ");
INSERT INTO ycn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Re uncá natajnálajo. Ne'emajé Tupana hua'atéjena, je'echú chu i'imacaño, que caja. Uncá taca'alájeño penájena ne'emajé; Tupana yaní ne'emajé, Tupana macápo'otajicale necá. ");
INSERT INTO ycn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ñaqué caja Moisesmi chu puráca'alomi lana'aquéjami quemacá caja taca'acaño macápo'oco nacú. Jíma'alami cára'aco e'iyayá Tupana quemari Moisesmi chujlo marí que i'imacá: “Abraham, Isaac, Jacob, quele pechu i'imá nochojé caphí”. ");
INSERT INTO ycn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Uncá meño'ojó caja taca'acaño pechu i'imalá Tupana chojé caphí. Necaja calé cajmuruna pechu i'imá richojé caphí. Cajmuruna, capéchuruna necá Tupana hua'até i'imacaño —que Jesús quemacá najló, nahue'epícaloje raú caja taca'acaño rijhua'atéjena i'imacá cajmuruna je'echú chu penaje. ");
INSERT INTO ycn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","E Tupana puráca'alo nacú jehuíña'atajeño naquiyana quemaño rijló: —Palá pimíchaca rinacu, Huehuíña'atajeri. ");
INSERT INTO ycn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ejomi uncá ajopana quejá'alaño nacaje yucuna riliyá. Nahuó la'aró ra'apejé nacaje yucuna quejá'acana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","E Jesús quemari najló: —Ricá, Tupana huacára'acare ina'uqué i'imatájeri penaje, nacú nemá: “Davidmi chu laquénami naquiyana ricá”. ¿Naje chi nemá ilé que rinacu? ");
INSERT INTO ycn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Papera Salmos chu, iná iphata méqueca Davidmi chu quemacá rinacu i'imacá. Marí que rimacá: Ina'uqué huacára'ajeri huani Tupana. Ricá quemari Nuhuacára'ajerijlo marí que: “Palá huani nupechu pinacu. Pi'imá Nahuacára'ajeri nujhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Maare pi'imajica nohua'á, nuchá'atajica chapú pinacu péchuruna ejená”, que rimacá. ");
INSERT INTO ycn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jesús quemari piño: —Davidmi chu quemari ricá Tupana huacára'acare ina'uqué i'imatájeri penaje nacú: “Nuhuacára'ajeri ricá” que. Ñaquele uncá Davidmi chu laquénami naquiyana huani calé ricá nemacare nacú —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesús pura'aró nacaje nacú ra'apiyatéjena hua'até. Ajopana i'imaño re caja, jema'añó caja méqueca rimacá najló. Rimá najló: ");
INSERT INTO ycn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Ihue'epínoja Tupana puráca'alo nacú jehuíña'atajeño. Ila'aniya nala'acá que caja. Huaphereni na'arumacá chu nahuata chira'acajo. Na'apaca le'ejepelaji ñacarelana e'iyohuá ee, nahuata ina'uqué ajalácaca necá palá. Ajopana chá'atajeño que nayá'aco nahuacáca'alo ñacarelana chu. Ñaqué caja nahuátaca ajopana tucumá yá'acano nale'ejé fiesta huacajé. ");
INSERT INTO ycn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Napajlaca caja ihuacajílomina hua'até, nata'acáloje naliyá nañacaré penaje. Uncá nephala na'apí. Eyá majopeja napura'acó júpija Tupana hua'até, palá ina'uqué pechu i'imacáloje nanacu raú penaje. Marí que nala'acare chona, ajopana chaje huani Tupana huajájica necá. ");
INSERT INTO ycn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús i'imari Tupana ñacaré chu. Re ramá cajrú liñeru minana ca'acá liñeru ra'acuná chojé. ");
INSERT INTO ycn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Eyá ramá caja apa'ahuelo ihuacajilomi. Camu'ují la'acayo ru'umacá. Ruca'á iyamata ñánija parata richojé. Huejápaja huani rahuacaco. ");
INSERT INTO ycn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Raú Jesús quemari rahua'á i'imacáñojlo: —Jema'á marí, ilerú inanaru, ihuacajilomi rucá. Camu'ují la'acayo caja rucá. Ilé liñeru huejápaja ruqui'ichaje richojé aú ruchá'achiya ajopana. Raú ruli'ichá palá ajopana chaje. ");
INSERT INTO ycn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ajopana qui'ichaño naliñérute lupemí richojé. Eyá ilerú, camu'ují la'acayo, qui'ichayo piyuque ruliñérute richojé. A'ajnejí huarúhua'ajona penaje ri'imichácajla —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ra'apiyatéjena naquiyana pura'añó Tupana ñacaré nacú. Nemá rinacu: —Meque palani huani ricá. Meque palá nojé jipa naquiyana la'acanami ricá. Palani caja nacaje pato'oró rinacu, na'acare Tupánajlo —que nemacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","E Jesús quemari najló: —Quele Tupana ñacaré amácare me'etení, uncá i'imalaje maare. Aquijñojo ajopana chapú péchuruna cajya'atájeño piyuqueja ricá. Ejomi uncá pajluhuaja ñani jipa yurílajo pachácaca —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nemá Jesúsjlo: —Huehuíña'atajeri, ¿méquechamica ri'imajica quele pimíchaje nacú huajló? ¿Na aú chi ina'uqué hue'epeje méquechamica riphájica rená chojé? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús quemari najló: —Jema'aniya ajopana puráca'alo ja'apiyá, napajlájicare aú ijhua'até. Iqui'iruna ina'uqué iphájeño. Na'ajé nuí, neí hua penaje. “Ricá Tupana huacára'acare majó ina'uqué i'imatájeri penaje nucá. Caja noná iphari rená chojé”, que nemájica nanacuhuá apú, apú que. Pa. I'ijnaniya ilé cajena hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yucu i'imajé marí que: “Chuhua nenócaco pajhua'atéchaca”. Ajopana nacú nemaje: “Nenócaco pajhua'atéchaca necámica que”. Marí que yucu i'imajica rihuacajé. Pa. Iquero'oniyo raú. Caja queja ri'imajica. Uncá jo'ó eja'ahuá tajnálajo rihuacajé —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Rimá piño najló: —Ajopana te'eré eruna nócajeño ajopana te'eré eyájena hua'até. Ajopana i'imacana hua'atéjena nócajeño ajopana i'imacana hua'atéjena hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A'apona que cajrú te'erí ñaca'ajico apú eyá, apú eyá que rihuacajé. Cajrú caja ina'uqué taca'ajica me'epejí nacú rihuacajé apú eyá, apú eyá que. Cajrú huani natami caje nójica ina'uqué. Je'echú chiyá amaje cajrú nacaje. Ricá quero'ótaje ijló. ");
INSERT INTO ycn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","14","Marí que ri'imajica piyá, nala'ajé icá chapú. Napataje icá, najña'ajé icá jahuacáca'alo ñacarelana chojé. Re nemaje inacu: “Pu'uhuaré la'ajeño necá” que. Ejomi naca'ajé icá ina'uqué huajáquelana chojé. Najña'ajé icá i'imacánana ejo. Nachaje huacára'ajeño ejo hua'ató najña'ajé icá, narucátacaloje rijló icá majopeja penaje. Marí que nala'ajica icá chapú, no'opiyá jemaaté, i'ijnatániya ipéchuhua: “¿Marí que chi huapura'ajico huachayo, nahuajaca piyá huecá?” ");
INSERT INTO ycn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nucá a'ajeri ijló puráca'aloji. Raú capechú imájica najló, nemacá piyá inacu: “Napajlaca” que. ");
INSERT INTO ycn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ñaqué caja ejena naquiyana la'ajica icá chapú. Ichi'iná ca'ajná, ejena naquiyana ca'ajná, e'ehuelona naquiyana ca'ajná, ijhuáque'ena naquiyana ca'ajná a'ajeño icá ajopánajlo, chapú inacu péchurunajlo. Necá nójeño inaquiyana. ");
INSERT INTO ycn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Piyuqueja ina'uqué huo i'imajica ichá chapú, jema'acale no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Uncá na calé ila'ajico. ");
INSERT INTO ycn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Uncájica ee jácho'o no'opiyá jema'acana chiyá, Tupana i'imatájeri icá capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pu'uhuacá amájica cajrú surárana itaca pajimila Jerusalén cha, aú ihue'epeje mequetánaja i'imajemi nacajya'ataje pajimila. ");
INSERT INTO ycn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aú Judea te'eré eyájena ñaajeño ipuré e'iyajé. Jerusalén eruna jácho'ojeño reyá. Pu'uteni chu i'imajícaño uncá pa'alájeño piño pajimila ejo. Marí que ila'ajica. ");
INSERT INTO ycn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Huajácaje queja ri'imajica rihuacajé. Tupana puráca'alo lana'aquéjami quemacá que rinacu, que ri'imajica rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Chapú huani ri'imajica canupana inaánajlo rihuacajé. Chapú huani caja ri'imajica inaana cayaniquérunajlo, re caja jo'ó i'iracaño chu'uchú nayani. Cajrú ina'uqué amájica chapú caje yajhué rihuacajé ite'eré ehuá. Cajrú Tupana huajájica mariruna ina'uqué. ");
INSERT INTO ycn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nenójica ne'iyajena nócacajo e'iyá. Ajopana najña'ajé, naca'acáloje necá ina'uqué huajáquelana chojé penaje. Ina'uqué huajáquelana chu ne'emajé ajopana te'eré nacú, ajopana te'eré nacú que. Ajopana cajya'atájeño pajimila Jerusalén, uncá judíona naquiyana calé necá. Tupana yurica najló ricá quetánaja nala'ajica marí que. ");
INSERT INTO ycn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús quemari piño najló marí que: —Apojó camú, queri, ihuijina caje amajo rihuacajé. Cajrú caja juni jalomi mejé i'imajica; cajruni huani riyocola i'imajica. Raú piyuque eja'ahuá chu i'imajícaño quero'ojeño. ");
INSERT INTO ycn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Cajrú ne'emajica quero'ocajo nacú. Nahue'epeje eja'ahuá i'imacá capichácajo nacú. Jimaje napojlo'ojó. Piyuque nacaje je'echú chu i'imacare ñaca'ajero. ");
INSERT INTO ycn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Marí que ri'imajica ee namájica nucá iphaca majó juni suhuáca'ala e'iyohuá. Ina'uquéjloje penaje i'imacá nucá. Piyuque ina'uqué huacára'ajeri penaje nuphaje majó. Cajrú mejáma'atani i'imajica nohua'ó. Marí caje hua'ató nuphaje. ");
INSERT INTO ycn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Amájica ee nacaje i'imacá numacá que ijló me'etení, ila'á ipéchuhua caphí. Mequetánaja yuréjero ijló. Rejomi Tupana i'imatájeri icá capichácajo liyá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús jehuíña'atari necá piño marí que: —Caja ihue'epí a'ahuaná nacojé, a'ahuaná higuera nacojé hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ri'iché pitúca'ari, ripaná moto'ocáloje rinaquiyá penaje. Ri'iché pitúca'aca aú iná hue'epí yehuicha jarechí iphaca rená chojé. ");
INSERT INTO ycn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ñaqué caja ihue'epíjica nupa'ajico majó nacojé. Amájica aú nacaje numíchaje nacú, ihue'epeje yehuicha riphaca rená chojé, Tupana i'imacáloje piyuque ina'uqué huacára'ajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Jema'á marí. Ricá numíchaje nacú ijló i'imajeri re caja ina'uqué i'imanoja. ");
INSERT INTO ycn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Je'echú, eja'ahuá hua'até tajnájero. E'iyonaja calé uncá nupuráca'alo tajnálajo. Numacá rinacu queja nacaje i'imajica. ");
INSERT INTO ycn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Pa. I'imaniya cajrú a'ajnehuá ajñacana nacú. I'imaniya caja quehuini caje i'iracana nacú. Ihuó ca'aniyo caja nacaje marí eja'ahuá chu i'imacare hua'até. Apala huajátacajo ri'imajica numíchaje nacú ijló. ");
INSERT INTO ycn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mahue'epícanaru camejérina ja'acó napatáca'aruna chojé. Ñaqué caja ri'imajica piyuque huani ina'uquejlo, eja'ahuá chu i'imacáñojlo. Huajátacajo nu'umajica nachá. ");
INSERT INTO ycn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","I'imá nupé maare. Ipura'ó Tupana hua'até hue'echú ca'alá queja, i'imacóloje chapú caje i'imajícare liyá penaje, itára'acoloje nujimaje rejomi penaje. Ina'uquéjloje penaje i'imacá nucá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hue'echú Jesús jehuíña'ataque necá Tupana ñacaré chu. Lapí ri'ijnaqué yenuri Olivos ejo. Re ri'imaqué lapí. ");
INSERT INTO ycn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Lapiyami ca'alaja cajrú ina'uqué i'ijnajica Tupana ñacaré chojé ripuráca'alo jema'ajé. ");
INSERT INTO ycn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yehuíchaja nale'ejé fiesta iphaca rená chojé rihuacajé. Rihuacajé caja najñaque pan mamúra'atacanaru. Pascua nale'ejé fiesta ií i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Re sacerdótena huacára'ajeño i'imaño. Tupana puráca'alo nacú jehuíña'atajeño i'imaño caja najhua'até re. Necá pura'añó pajhua'atéchaca méqueca nenójica Jesús. Nahuata rinócana. E'iyonaja naquero'ó ajopana ina'uqué piyá. ");
INSERT INTO ycn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Eyá Jiñá Chi'ináricana pechu ja'aró Judas Iscariote e'iyajé. Iyamá iphata ji'imaji nacojé quele Jesús ja'apiyatéjena naquiyana ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ejomi Judas i'ijnari ají que sacerdótena huacára'ajeño amaje. Tupana ñacaré chiyá huacára'ajeño i'imaño caja re najhua'até. Najhua'até ripura'ó méqueca ra'acajla najló Jesús. ");
INSERT INTO ycn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ri'imacá aú riyucuna najló palá napechu i'imacá rinacu. Nemá rijló: —Hua'ajé pijló liñeru, pi'imichácale riyucuna huajló. ");
INSERT INTO ycn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Je —que rimacá najló. Reyá a'ajná ño'ojó Judas quejíla'ari Jesús, ramácaloje méqueca ra'acajla najló ricá, necó ne'emacá ee. ");
INSERT INTO ycn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","E caja nale'ejé fiesta pascua iphari rená chojé. Rihuacajé queja najñájica pan mamúra'atacanaru. Rihuacajé caja nenoque caja ohueja i'irí pu'uhuaré nala'ajícare chaya. ");
INSERT INTO ycn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","E caja Jesús quemari Pedro, Juan, quelejlo marí que: —I'ijná ili'ichachi huajló fiesta a'ajnená. ");
INSERT INTO ycn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nemá rijló: —¿Meño'ojó chi huala'ajé ricá? ");
INSERT INTO ycn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús quemari najló: —I'ijná a'ajná ño'ojó pajimila ejo. Iphájica ee re'iyajé, iphátaje pajluhuaja ina'uqué. Juni rihuacúla'apa que iphátajica ricá. Eco i'ijná rápumi chu, ijmulúca'aje pají chojé rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ejomi imaje pají minajlo marí que: “Huehuíña'atajeri quemíchari pinacu: ¿Mecaje chi ucapú, huajñaje chu hua'ajnehuá, pascua a'ajnená, no'opiyatéjena hua'até, que rimíchaca pinacu”, que imájica rijló nunacu. ");
INSERT INTO ycn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Raú riya'ataje ijló ñópo'ojlo ucapú yenú. Piyuque huani nacaje i'imajica lamá'ataqueja richu. Ricá chu ila'ajé a'ajnejí —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Je. E ne'ejná pajimila ejo. Amaño ucapú i'imacá Jesús quemacá que najló. Richu nala'á pascua a'ajnená. ");
INSERT INTO ycn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","E caja na'ajnehuá ajñacana iphari rená chojé. E caja Jesús ajopana ra'apiyatéjena hua'até iphaño rejo. E Jesús yá'aro, rajñácaloje pascua a'ajnená ra'apiyatéjena hua'até penaje. ");
INSERT INTO ycn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","E Jesús quemari najló: —Iqui'i nuhuátaca marí pascua a'ajnená ajñacana ijhua'até, nutaca'ajica yámona. ");
INSERT INTO ycn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Numá ijló, uncá nojñálaje piño ricá ijhua'até. Ohueja i'irí nócana ina'uqué chaya ricá renami. Eyá nucá, quehuaca penaje taca'ajeri ina'uqué chaya, no'opiyá jema'ajeño i'imacáloje nujhua'atéjena raú penaje. Ñaqueja caja la'aquéjami ri'imajica ee, nojñájica piño ricá ijhua'até —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","E rijña'á chiyela ricápojo, cajmú jepepí inarí ricá jalá i'imari richu. Rimá Tupánajlo: —Palá pila'acá huecá marí cajmú jalá aú. E rimá ra'apiyatéjenajlo: —Marí i'irá. A'á ijluhua ricá piyuque, i'irachi ricá. ");
INSERT INTO ycn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Numá ijló, uncá nu'uralaje piño marí caje jalá ijhua'até. Tupana i'imajica ina'uqué naquiyana huacára'ajeri huacajé, nu'uraje piño ijhua'até ricá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ejomi rijña'á piño pan ricápojo. Rimá Tupánajlo: —Palá pila'acá huecá marí pan aú. Ejomi ritupa'á rinaquiyana. E ritamáca'ata ra'apiyatéjenajlo pan tupa'aqueja, najñácaloje ricá penaje. Rimá najló: —Ajñá ricá. Marí nunapona no'ocare taca'acájejlo ijló penaje. Marí que ajñájicano ricá, ipechu capicháñaca piyá nucá. ");
INSERT INTO ycn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ñaqué caja rimacá ralá nacú najñaca na'ajnehuá ejomi. Rimá najló: —Marí chiyela chu re ralá. Nura aco'ojeri nophú chiyá nutaca'ajica aú ina'uqué chaya. Marí caje aú Tupana amájero cajrú ina'uqué chaje, pu'uhuaré nala'acare liyá. Marí que Tupana la'ajica ijlojé penaje, iyurícoloje ripalamane penaje. ");
INSERT INTO ycn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","E rimá piño najló: —Re pajluhuaja inaquiyana maare, a'ajeri nucá nupinánajlo. ");
INSERT INTO ycn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ina'uquéjloje penaje i'imacá nucá. Nucá taca'ajeri, Tupana pechu nacú ri'imacá que. E'iyonaja calé chapú huani ri'imajica a'ajeri nucá nupinánajlo —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Raú nemá pajlocaca: —¿Mecaje huanaquiyana ricá, huátari ra'acana ripinánajlo rimá nacú huajló? ");
INSERT INTO ycn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Eyá ra'apiyatéjena pura'añó pajhua'atéchaca piño apú nacú. Mecajeca ne'iyayá i'imari nachá'atajeri, ricá nacú napura'ó pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","E Jesús quemari najló: —Re ajopana te'eré eruna huacára'ajeño. Caphí huani nahuacára'aca najhua'atéjena. Raú nachaje huacára'ajeño quemaño nanacu: “Ina'uquéjloje penaje nala'á nacaje”. ");
INSERT INTO ycn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","E'iyonaja uncá ñaqué caja calé ijló ricá. Re ca'ajná pajluhuaja inaquiyana, apú ñaté, apú ñaté que a'ajeri ricá. Ricaja calé i'imárijla ichá'atajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ajopana huacára'ajeño ca'ajná yá'año na'ajnehuá ajñacana nacú. Najñaca na'ajnehuá quetana najhua'até sápajeño ja'apátaño najló nacaje nahuátacare caje. Eyá maare nucá me'etení ijhua'até ihuacára'ajeri penaje. E'iyonaja calé ijhua'até sápajeri que nucá ijhua'até. Nucá la'arí ijló nacaje. ");
INSERT INTO ycn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Icá i'imaño nujhua'até capinaca. Chapú caje yajhué nomácare hua'ató icá i'imaño nujhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ñaquele no'ojé icá ajopana ina'uqué huacára'ajeño penaje. Nora'apá a'acá nucá ina'uqué huacára'ajeri penaje, que caja no'ojica icá ajopana huacára'ajeño penaje. ");
INSERT INTO ycn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Icá ajñájeño a'ajnehuá nujhua'até ajopana nujhua'atéjena hua'até je'echú chu. Re ñáca'ajori nahuacára'ajeñojlo penaje. Ricá chojé iyá'ajo. Re iyamá iphata ji'imaje nacojé quele Israelmi chu laquénami a'ajútayami chuna i'imacá. Nalaquénami nacú imaje méqueca nala'acana i'imajica. Nacaje nala'acare marí eja'ahuá chu ne'emacá quetana, nacú imaje meque ricá, palá nala'acá ca'ajná, uncá ca'ajná. ");
INSERT INTO ycn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","E Jesús quemari Pédrojlo ajopana hua'até: —Pedro, pema'á. Jiñá Chi'ináricana huátari rijluhua icá. Rica'átaje e'iyajé, ila'acáloje pu'uhuaré rihuátaca que penaje. Iná jeyo'ó trigo, iná cupácaloje re'iyayá pu'uhuaré nojé rimujrumi penaje. Ñaqué caja Jiñá Chi'ináricana huátaca icupácana Tupana liyá pu'uhuaré la'acana aú —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Eyá rimá Pédrojlo: —Caja nupura'ó Tupana hua'até pinacu, pipechu la'acó piyá ujhuí nuliyá. Mequetánaja calé pipechu la'ajico apú que nuliyá. Ejomi pipajno'otájica pipéchuhua nucá ejo piño. Ejéchami pa'ajica pinacojó no'opiyá jema'ajeño, nayurica piyá naliyó nupuráca'alo —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro quemari rijló: —Huahuacára'ajeri, apala naca'ajé nucá ina'uqué huajáquelana chojé pijhua'até, apala nenoje ca'ajná nucá pijhua'até. Uncá huani ta nuyurílaje picá raú. ");
INSERT INTO ycn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús quemari rijló: —Pedro, numá pijló, ñaano pimicho'otájica nuchaya. Capere yaca'ajica piyá, pimicho'otájicaja nuchaya hueji que pe —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús quemari piño najló marí que: —Nuhuacára'a i'ijnacá queráma'aque apú pajimila naquiyá, apú pajimila naquiyá que apú huacajé i'imacá. Uncá ijña'alá ijhua'até ilinérute, ra'aruná caje. I'ima'ulaje caje uncá caja ijña'alá. ¿E chi ila'acá camu'ují nacaje nacú rihuacajé? Nemá rijló: —Uncá —que. ");
INSERT INTO ycn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Rimá najló: —Chuhua ijña'ajica ijhua'ató ihuajure, itulané caje, iliñérute caje macá. Uncá sajalu i'imalare capi, a'ajeri ra'arumacá naquiyana, rihuarúhua'acaloje rijluhua sajalu raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ilé que numacá ijló, nala'ajícale nucá chapú chuhuaca. Tupana puráca'alo lana'aquéjami quemacá nunacu que nala'ajica nucá chapú. Marí que rimacá nunacu: “Nala'ajé ricá uncá ina'uquélaruna naquiyana que”. Tupana puráca'alo lana'aquéjami quemacá que nunacu que piyuque nacaje i'imajica —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","E nemá rijló: —Huahuacára'ajeri, re maare iyamata sajalu. Rimá najló: —Reja ri'imare ñaqueja. ");
INSERT INTO ycn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","E caja Jesús jácho'oro. Ri'ijná piño yenuri ejo, ri'ijnaquela ejo. Yenuri ií Olivos. Ra'apiyatéjena ja'apaño rápumi chu rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","E caja nephá rejo. E Jesús quemari ra'apiyatéjenajlo: —Ipura'ó Tupana hua'até maare, ila'acá piyá pu'uhuaré. ");
INSERT INTO ycn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","E ri'ijná a'ajná ño'ojó pani naliyá. Iná ca'á huayajrú quetana júcaca ri'ijná naliyá. Rejé ritára'o ri'irúpachi aú. Ripura'ó Tupana hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Rimá rijló: —Pa'ayú, pihuátajica ee pi'imatá nucá chapú caje yajhué nomájicare chiyá ñaano pani. Pila'aniya nuhuátaca que, pila'á pihuátaca que —que rimacá Tupánajlo. ");
INSERT INTO ycn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ejéchami pajluhuaja Tupana hua'atéjeri, je'echú chiyaje, ya'atacó rijló, ra'acáloje riñaté penaje. ");
INSERT INTO ycn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Camu'ují huani Jesús pechu la'acó. Raú mahuó riquejá'aca ricó Tupana liyá. Cajrú riñaphina i'ijnacá. Rira naquiyana i'ijnari caja rijhua'ató. Imujulá nojé quemachi ratupátaco te'erí e'iyajé. ");
INSERT INTO ycn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ripura'ó Tupana hua'até. Ejomi rácho'o. Ri'ijná ra'apiyatéjena i'imacá ejo, amari mana'ija nacamátaco. Camu'ují huani napechu i'imacá, aú quiñaja tapú chá'atari necá. A'acuhuanaja nacamato. ");
INSERT INTO ycn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","E Jesús quemari najló: —¿Naje icamáchiyo? Jácho'o chuhua. Ipura'ó Tupana hua'até ila'acá piyá pu'uhuaré, nacaje a'acá piyá ime'é rijluhua. ");
INSERT INTO ycn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús pura'aró najhua'até. E'iyohuá queja cajrú ina'uqué iphaca nanacu. Judas ja'apari natucumá. Ricá i'imari iyamá iphata ji'imaji nacojé quele ra'apiyatéjena naquiyana. E caja ri'ijná Jesús jimajo rijimá chiyá chiño'ojé. ");
INSERT INTO ycn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Raú Jesús quemari rijló: —Judas, ¿Nujimá chiyá chiño'ocana aú chi pa'ajé nupinánajlo nucá? Ina'uquéjloje penaje i'imacá nucá —que rimacá Júdasjlo. ");
INSERT INTO ycn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Eyá ajopana, Jesús hua'até i'imacaño, amaño nephaca cajrú. Aú nemá Jesúsjlo: —Huahuacára'ajeri, ¿Hua'apata chi nanacu sajalu aú? ");
INSERT INTO ycn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Eta pajluhuaja Jesús hua'atéjeri mata'arí apú i'ijhuí matá. Sacerdótena huacára'ajeri hua'até sápajeri ri'imacá. Ca'añá chojó pitari ri'ijhuí rica'á. ");
INSERT INTO ycn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","E Jesús quemari najló: —Reja ne'emareja. Itaca'aniya nanacu. Eyá Jesús sápari ri'ijhuí pucunami chu. Hua'ató que ri'ijhuí pata'acó piño rapumí chuhuá. ");
INSERT INTO ycn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Marí quele ina'uqué iphaño Jesús ña'ajé i'imacá: sacerdótena, Tupana ñacaré chiyá huacára'ajeño, ajopana peñahuilana cajena, quele ne'emacá. E Jesús quemari piyuque rijña'ajé i'ijnacáñojlo: —I'ijichá majó nujña'ajé sajalu hua'até, cujyúhua'ala, quele hua'até. ¡Meque ata'acachi que huani ila'acá ijluhua nucá! ");
INSERT INTO ycn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hue'echú ca'alá queja nu'umajica ijhua'até Tupana ñacaré chu jehuíña'atacana nacú. E'iyonaja uncá ijña'alá nu'umacá rihuacajé. Chuhuaca riphíchaca rená chojé ijló, ila'acáloje nucá Jiñá Chi'ináricana huacára'aca que penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Eja napatá Jesús, najña'acáloje ricá penaje. Nahuá'a ricá ají que sacerdótena huacára'ajeri ñacaré ejo. Pedro i'ijnari caja najhua'até. Juca pani richira'acó naliyá. Nephá rejo. ");
INSERT INTO ycn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Re napho'otá siyá pe'iyó nañacaré copejé. Rejé Pedro iphari nanacu. Nayá'o tujlá que siyá ji'ilá na'anapacá ri'ilá. Pedro yá'aro caja re najhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Re apa'ahuelo i'imayo. Pají chiyá sápajeyo ru'umacá. Rucá amayo Pedro yá'aco najhua'até siyá camaré chojé. E ruyacá'o richaje, rumá najló: —Ilé yá'aro ijhua'até, Jesús hua'ateje ricá —que rumacá najló Pedro nacú. ");
INSERT INTO ycn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","E'iyonaja Pedro micho'otari richaya. Rimá rojló: —Uncá nomána'apa calé quele pimá nacú nojló. ");
INSERT INTO ycn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mequetánaja i'imajemi apú amari piño ricá. Rimá rijló: —Nuhue'epí Jesús huáque'ena naquiyánaca picá. Aú rimá rijló: —Uncá huani ta nanaquiyana calé nucá. ");
INSERT INTO ycn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pajluhuaja camú quetana i'imajemi apú quemari piño najló: —Rijhua'atéjena naquiyana jo'ó ricá quele. Galilea eyaje Jesús. Reyaje caja quele yá'aro siyá ji'ilá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aú Pedro quemari rijló: —Uncá huani ta nuhue'epila naca quele pimá nacú najló. Marí que Pedro quemacá. Ejéchami capere yaca'acá. ");
INSERT INTO ycn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hua'até que Jesús pajno'ocó riyámajo, amari Pedro a'ajnare que. Aú riphá Pedro pechu nacojé méqueca Jesús quemacá rinacu maapami que. Rimá rijló i'imacá najló: —Rijhua'atéjena naquiyana jo'ó ricá quele. Galilea eyaje Jesús. Reyaj: “Ñaano pani pimicho'otaje nuchaya. Capere yaca'ajica piyá, pimicho'otájicaja nuchaya hueji que pe.” ");
INSERT INTO ycn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Marí que riphaca ripechu nacojé aú Pedro i'ijnari reyá. Supejeno riyaca. ");
INSERT INTO ycn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ra'apona apalá chu Jesús i'imari. Re rihua'aphé i'imacaño la'añó namácaja ricá. Naña'atá caja ricá. ");
INSERT INTO ycn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Napára'aca yami rijimá naña'atá ricá pajimaya. Quéchami nemacá rijló: —¿E pihue'epícajlale. Galilea eyaje Jesús. Reyaj naca ña'achíyari picá? ");
INSERT INTO ycn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Cajrú napura'acó rinacu pu'uhuaré. Nacátajohua queja nala'acá ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","E caja muní que lapiyami nahuacó cajrú rejé. Peñahuilana, sacerdótena huacára'ajeño, Tupana puráca'alo nacú jehuíña'atajeño, quele jahuacaño rejé. E nahuá'a Jesús najimaje, nemá rijló: ");
INSERT INTO ycn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Picá chi quele Tupana huacára'acare majó ina'uqué i'imatájeri penaje? Chuhua pimá huajló. Aú rimá najló: —Numájica ee á'a que ijló, uncá jema'alaje no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nuquejá'ajica ee nacaje yucuna iliyá, uncá caja i'imalaje nojló riyucuna. Uncá caja jácho'otalaje nucá. ");
INSERT INTO ycn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ina'uquéjloje penaje i'imacá nucá. Nucá i'imajeri Tupana hua'até huacára'ajeri penaje. Tupana hue'epiri piyuqueja nacaje la'acana —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nemá piño rijló: —¿Picá chi Tupana I'irí? Jesús quemari najló: —A'a, imacá que nucá Tupana I'irí. ");
INSERT INTO ycn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Raú nemá ajopánajlo: —Uncá naje calé huemá ajopánajlo, ne'emacáloje huajló riyucuna penaje. Caja huemi'ichá méqueca rimacá huajló. Pu'uhuaré huani ripura'acó Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Raú piyuque necá jácho'oño. Najña'á Jesús ají que ne'emacana ejo. Ne'emacana ií i'imari Pilato. Rejo najña'á ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Re narucata Jesús rijló. Nemá majopeja Pilátojlo marí que Jesús nacú: —Marí ina'uqué ca'átari huanaquiyana e'iyajé, nayúcha'acoloje hue'emacana cha raú penaje. Rimá najló na'acá piyá liñeru naquejá'acare hue'emacanajlo. Romano eyaje ricá. Rimá caja rinacuhuá: “Cristo nucá”. I'imacana penaje nucá quemacánaca Cristo —que nemacá rinacu Pilátojlo. ");
INSERT INTO ycn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","E Pilato quemari Jesúsjlo: —¿Judíona i'imacana chi picá? Jesús quemari rijló: —A'a, nucá nucá pimacá queja. ");
INSERT INTO ycn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","E Pilato quemari sacerdótena huacára'ajeñojlo, ajopana ina'uquejlo hua'até marí que: —Uncá marí ina'uqué la'alá pu'uhuaré. Uncá na pachá calé huahuajá ricá. ");
INSERT INTO ycn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","E'iyonaja natára'o caphí rijló. Nemá piño rinacu: —Pu'uhuaré la'ajeri ricá. Rica'áta piyuque Judea te'eré nacuruna e'iyajé, nayúcha'acoloje hue'emacana cha raú penaje. Piyuque huate'eré nacuhuá richira'acó ina'uqué jehuíña'atacana nacú. Galilea te'eré eyá riqueño'ó chira'acajo, iphari maáreje. ");
INSERT INTO ycn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Marí que nemacá aú Pilato quemari najló: —¿Galilea eyaje chi ricá? ");
INSERT INTO ycn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nemá rijló: —A'a. Aú rihuacára'a Jesús ña'acana Herodes ejo. Galilea te'eré eyá huacára'ajeri ri'imacá. Rihuacajeja caja ri'imacá Jerusalén e. ");
INSERT INTO ycn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","E caja nahuá'a ricá Herodes ejo. Nephá rinacu. Herodes amaca aú Jesús pu'ují ripechu i'imacá, rihuátacale ramácana júpimi que i'imacá. Caja rema'á riyucuna meque la'ajérica ri'imacá. Ñaquele rihuata rila'acá nacaje uncá meño'ojó ina'uqué la'alare caje. Ramácaloje penaje rihuata rila'acá ricá. ");
INSERT INTO ycn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aú calé riquejá'a cajrú nacaje yucuna Jesús liyá. E'iyonaja uncá huani Jesús ja'ajipalá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Re caja sacerdótena huacára'ajeño i'imaño, Tupana puráca'alo nacú jehuíña'atajeño hua'até. Necá arucátaño piño cajrú Jesús rijló. Nemá rinacu: —Uncá huani ina'uquélari ricá. Cajrú huani rila'acá pu'uhuaré. Marí que napajlaca rinacu majopeja. ");
INSERT INTO ycn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes, rile'ejena surárana hua'até pura'añó Jesús nacú majopeja. Nacátajohua que nala'acá ricá najluhua. Na'á rinacojé a'arumacaji palá nojé, ne'emacana a'acare rinacuhuá caje. Eyá nahuacára'a piño rijña'acana rapumí chuhuá Pilato ejo. Aú napa'atá ricá. ");
INSERT INTO ycn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Rihuacajé Pilato, Herodes, quele amaño pecohuácaca. Júpimi que napechi i'imajica chapú panacuhuácaca. ");
INSERT INTO ycn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","E caja Pilato jahuacátari sacerdótena huacára'ajeño, ajopana nahuacára'ajeño hua'até, quele. Rahuacata caja ajopana ina'uqué najhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Rimá najló: —Marí ina'uqué iji'ichá majó. Imicha rinacu: “Cajrú rica'átaca ina'uqué e'iyajé, nayúcha'acoloje ne'emacana cha penaje”. Uncá ñaqué calé ricá. Caja naquejá'icha riliyá riyucuna ijimaje. Ñaquele nuhue'epí uncá rila'alá pu'uhuaré ilé imíchaca rinacu que. ");
INSERT INTO ycn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes hue'epiri caja uncá rila'alá pu'uhuaré. Ñaquele rihuacári'icha piño ricá majó, uncale rila'alá pu'uhuaré, nenócaloje ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chuhua nuhuacára'ajica ra'apátacana a'ajná ño'ojó, naña'atácaloje ricá penaje. Ejomi nócho'otaje ricá —que Pilato quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ilé fiesta huacajé queja Pilato jácho'otajica ina'uqué huajáquelana chiyá pajluhuaja ina'uqué, rácho'otaque najló judíona huátajicare caje. ");
INSERT INTO ycn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Rihuátajla Jesús jácho'otacana najló. I'imaqué e'iyonaja pajñacani nahuíyo'oca, nemá rijló: —Pihuacára'a Jesús nócana, pácho'ota huajló Barrabás. ");
INSERT INTO ycn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Júpimi que ri'imacá marí que: Ne'iyajena huátaño ne'emacana ca'acana. Aú nenoco ajopana hua'até pajimila e'iyohuá. Barrabás i'imari caja najhua'até. Nócacajo e'iyohuá que Barrabás noca ina'uqué. Richona naca'á ricá ina'uqué huajáquelana chojé. Ñaquele re ri'imá richu rihuacajé.) Ricá nacú nemá Pilátojlo, rácho'otacaloje najló ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato huátarijla huani Jesús jácho'otacana. Raú ripura'ó piño najhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","E'iyonaja richaje nahuíyo'oca rijló. Nemá rijló: —Pihuacára'a racúhua'atacana a'ahuaná apiyácacanami nacojé. Pihuacára'a racúhuatacana a'ahuaná apiyácacanami nacojé. Marí que huani nahuíyo'oca rijló. ");
INSERT INTO ycn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato pura'aró piño najhua'até, caja hueji que pe la'acá. Rimá najló: —¿Na ta chi rila'á pu'uhuaré? Uncá na calé rila'á pu'uhuaré rijluhua. Caja nuquejá'icha riliyá riyucuna. Uncá na pachá calé nuhuacára'a rinócana. Ñaquele nuhuacára'ajicaja riña'atácana. Quéchami nócho'otajica iliyá ricá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Raú richaje huani nahuíyo'oca. Nemá piño rijló, rihuacára'acaloje racúhua'atacana a'ahuaná apiyácacanami nacojé penaje. Piyuque ina'uqué, sacerdótena huacára'ajeño, quele jahuíyo'oño cajrú huani. Ejéchami caja nahuíyo'ocare chá'ataca Pilato. ");
INSERT INTO ycn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aú ripechu i'imá: “I'imatare ta. Nahuátaca que nala'ajica ricá.” ");
INSERT INTO ycn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","E rácho'ota najló Barrabás. Nahuátacare jácho'otacana ri'imacá. Rinó ina'uqué i'imacá, nenócaco i'imacá huacajé, naca'acáloje ne'emacana penaje. Marí que rila'acá chona naca'á ri'imacá ina'uqué huajáquelana chojé. Ricá penájemi nahuata jácho'otacana. E Pilato jácho'otari najló ricá. Ejomi ra'á najló Jesús, nala'acáloje ricá nahuátaca que penaje. ");
INSERT INTO ycn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","E caja nahuá'a Jesús ají que a'ajná ño'ojó, nacúhua'atacaloje ricá a'ahuaná apiyácacanami nacojé rejo penaje. E'iyohuá queja apú iphaca pajimila yámojo. Rií i'imari Simón. Pajimila Cirene eyaje ri'imacá. Ricá nahuacára'a Jesús chaya a'ahuaná apiyácacanami huáco'ocana. ");
INSERT INTO ycn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Cajrú ina'uqué ja'apaño rápumi chu. Cajrú inaana quele ja'apaño najhua'até. Cajrú neyaca rijhua'até. Cajrú nahuíyo'oca, camu'ují huani napechu i'imacale. ");
INSERT INTO ycn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús amari neyaca cajrú rijhua'até. Aú rimá najló: —Inaana, Jerusalén eyájena, iyániya nujhua'até. Iyá ijluhua, iyánijlo hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aquijñojo ina'uqué amájeño caja chapú caje yajhué. Rihuacajé ina'uqué quemájeño inaana mayaniquéruna nacú marí que: “Meque palani najló, mayaniquéruna ne'emacale”. ");
INSERT INTO ycn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Rihuacajé caja nemaje ipurejlo: “Pa'ó huachá” que. Nemaje caja yenúrijlo: “Papára'ata huecá” que. ");
INSERT INTO ycn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chuhua nahuajájica nucá huejápaja. Uncá pu'uhuaré la'ajeri calé nucá. E'iyonaja nahuajájica nucá. Eyá pu'uhuaré la'ajeño, ileruna nahuajaje cajrú huani. ");
INSERT INTO ycn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nahuá'a caja ajopana iyamá rijhua'até, nenócaloje necá rijhua'até penaje. Uncá ina'uquélaruna huani ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","E caja nephá nenóquelana ejo, yenuri ejo. Yenuri nemá nacú: “Ina'uqué huíla'aru aphinami ricá” que. Rejé nephaca ee nacúhua'ata Jesús a'ahuaná apiyácacanami nacú ipháqueja itapuhua aú. Ñaqué caja nacúhua'ataca necá ajopana, iyamá nahuá'acarena rijhua'até. Apú nacojé, apú nacojé que nacúhua'ataca necá Jesús ahua'á. Apú cúhua'aro Jesús ahua'á ca'añá chojó pitá, apú pajrú chojó pitá. Marí que nacúhua'ataca ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús nacúhua'ataca ee, rimá Tupánajlo marí que: —Nora'apá, chuhua pamó nachaje, uncale nahue'epila na penájeca nala'acá nucá chapú marí que. Nacúhua'ataca ricá ejomi surárana cátaño nacaje nacú, namácaloje méqueca natamáca'atajica najluhua Jesús a'arumacami penaje. ");
INSERT INTO ycn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Cajrú ina'uqué i'imacá re, yacá'año Jesús chaje. Nahuacára'ajeño, ajopana hua'até, la'añó namácaja ricá. Nemá rinacu: —Ri'imatá ajopana ina'uqué capichácajo liyá. Chuhua huamáijla ri'imataca ricó ñaqué caja. Ilé Tupana huacára'acare majó ri'imajica ee, ri'imataje ricó capichácajo liyá —que nemacá Jesús nacú. ");
INSERT INTO ycn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ñaqué caja surárana la'acá namácaja Jesús. Ne'ejná rahua'ajé. Na'á rijló nacaje jalá pu'uhuareni amúra'atacanami, ri'iracáloje penaje. ");
INSERT INTO ycn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nemá rijló: —Judíona i'imacana pi'imajica ee, pi'imataje picó. ");
INSERT INTO ycn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesús cha nacúhua'ata lana'aquéjami. Nalana'á ricá griego pura'acó chu, latín pura'acó chu, hebreo pura'acó chu hua'até. Marí que lana'aquéjami quemacá rinacu: “Judíona i'imacana ricá.” ");
INSERT INTO ycn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pajluhuaja pu'uhuaré la'ajeri cúhua'aro Jesús ahua'á. Ricá caja pura'aró rinacu pu'uhuaré, rimá rijló: —Ilé Tupana huacára'acare majó ina'uqué i'imatájeri penaje pi'imajica ee, pi'imatá picó, huecá hua'ató capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Raú apú, apojó pitá cúhua'aco, aca'arí ricá. Rimá rijló: —¿Uncá chi piquero'oló Tupana piyá? Pu'uhuaré la'ajeño huecá. Pachá nahuacára'a huenócana. Pu'uhuaré huala'acare pachá huamá chapú caje yajhué me'etení. Marí que huala'acana palani. Eyá marí ina'uqué uncá la'alá pu'uhuaré. E'iyonaja calé ramá chapú caje yajhué huajhua'até —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eyá rimá Jesusjlo: —Pihue'epí nucá, pi'imajica ee piyuque ina'uqué huacára'ajeri. Aú Jesús quemari rijló: ");
INSERT INTO ycn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","—Pijló numá, chuhuajá pi'imajé nujhua'até palá péchuruna péchumi i'imacá ejo. ");
INSERT INTO ycn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","E caja caápu'ucu i'imari nachá. Ejéchami camú camaré yacaca. Lapí que, ri'imacá rejéchami piyuque nate'eré ehuá. Caápu'ucu eyá pe'iyochami camú to'ocó quetana ne'emacá calajerúhuaca. ");
INSERT INTO ycn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Pe'iyochami camú to'ocó i'imacá. Ejéchami ya'ajná Tupana ñacaré chu a'arumacaji jiyo'ocó pe'iyohuá paliyácaca. Apalá ucapú penaje racúhua'o re. Yenuya rijiyo'ó ají que cahuacaje. Caja iyamá que riyurico. ");
INSERT INTO ycn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","E caja Jesús jahuíyo'ori, rimá Tupánajlo: —Nora'apá, pijló nuyurí nupechu. Marí que rimacá aú caja ritaca'á i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Surárana huacára'ajeri i'imari re. Romano naquiyana ri'imacá. Ricá amari Jesús taca'acá. Palá ripura'acó Tupana nacú, rimá Jesús nacú: —Palá la'ajeri jo'ó ricá taqui'ichari. ");
INSERT INTO ycn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Cajrú huani ina'uqué i'imaño re, amaño Jesús taca'acá. Ejomi napa'ó. Camu'ují huani napechu i'imacá, chapú nala'acale Jesús. Aú natujla'á necó ne'ecú chiyá. ");
INSERT INTO ycn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Palá péchuruna i'imacaño Jesús nacú yuriño ejo'ocaja rahua'á. Najhua'até caja inaana naquiyana i'imaño. Ne'ejná rijhua'até Galilea eyá Jerusalén ejo i'imacá. Necá penájenami ne'emacá. Re ne'emacá juca pani Jesús liyá i'imacá. Reyá namá méqueca nenoca Jesús i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Apú i'imari. Rií i'imari José. Pajimila Arimatea eyaje ri'imacá. Judíona huacára'ajeño naquiyana ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Uncá ajopana nahuacára'ajeño pechu que calé ripechu i'imacá Jesús nócana nacú. Uncá paala rijló marí que rila'acana i'imacá. Rihue'epí Tupana i'imajica ina'uqué naquiyana huacára'ajeri penaje. Aú ri'imá rihuátacana nacú. ");
INSERT INTO ycn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","E José i'ijnari Pilato amaje, riquejá'acaloje riliyá Jesús tami penaje. E rimá rijló “a'a” que. ");
INSERT INTO ycn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aú ri'ijná Jesús tami huitúca'ataje. Rihuitúca'ataca ritami ejomi rimapíra'a rinacu palá nojé a'arumacaji. Quéchami rito'otaca ritami támijimi to'otáquelana chojé. Huajé jipa e'iyá ichácanami ri'imacá. Uncá jo'ó nato'otala ajopana tami richojé. Ricá chojé nato'otá Jesús tami i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A'ajnejí lamá'atacana huacajé e'iyá ne'emacá. Lainchu chami nale'ejé huatána'acaje huacajé iphari rená chojé. Yehuicha riphaca rená chojé rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Rihuacajé caja inaana i'imaño támijimi to'otáquelana ejo, amaño méqueca nato'otaca Jesús tami richojé. Jesús jácho'oco Galilea eyá huacajé, necá, ajopana hua'até i'ijnaño caja rijhua'até Jerusalén ejo. Necá penájena amaño nato'otaca Jesús tami richojé. ");
INSERT INTO ycn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ejomi napa'ó. Nalamá'ata pusana, pu'umé jamarí caje, na'acáloje ricá Jesús tami nacú penaje. Caja nale'ejé huatána'acaje huacajé iphari rená chojé. Aú nahuatána'a Tupana puráca'alo lana'aquéjami quemacá que. ");
INSERT INTO ycn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sápacaje queño'ocó huacajé inaana i'ijnaño piño támijimi to'otáquelana ejo. Lapiyami, camú jeño'ocá ee, ne'ejná rejo i'imacá. Najña'á najhua'ató pusana pu'umé jamarí, nalamá'atacare i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","E caja nephá rejo, amaño jipa i'imacá jatatáqueja rinumaná eyá. ");
INSERT INTO ycn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Aú namujlúca'a ulahuí chojé, ritami i'imacare chojé. Amaño uncá Jesús Nahuacára'ajeri tami i'imalá richu. ");
INSERT INTO ycn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Raú cajrú naquero'ocó. Napechu i'imá: “¿Méquejle cari?” Ejéchami namaca iyamá achiñana, je'echú chiyájena, tára'aco nahua'á. Jareni, sereni hua'até que na'arumacá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Marí caje aú íqui'i huani inaana quero'ocó. Aú najláma'o ne'emá nacojé. E achiñana, je'echú chiyájena, quemaño najló: —¿Naje iculá quele cajmuni támijimina e'iyohuá? ");
INSERT INTO ycn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Uncá Jesús i'imalá maare. Caja rimacápo'ocho. Galilea e ri'imacá huacajé ri'imá ijló riyucuna i'imacá. Caja ihue'epí méqueca rimacá rinacuhuá ijló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Rimá ijló: “Ina'uquéjloje penaje i'imacá nucá. Na'ajé nucá pu'uhuaré la'ajéñojlo. Ejomi nenoje nucá a'ahuaná apiyácacanami nacojé. Hueji que cala i'imajemi numacápo'ojo piño nopumí chuhuá”, que Jesús quemacá ijló rinacuhuá i'imacá —que je'echú chiyájena quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Marí que nemacá aú najló riphá napechu nacojé. Ejéchami nahue'epica ñaqué huani Jesús quemacá najló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Raú napa'ó, iphaño Jesús ja'apiyatéjena nacú. Pajluhuaja iphata ji'imaji nacojé quele ne'emacá. Ne'emá najló Jesús macápo'oco yucuna ajopana ina'uquejlo hua'ató. ");
INSERT INTO ycn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Marí quele ne'emacá inaana, i'imaño riyucuna Jesús ja'apiyatéjenajlo: María Magdalena, Juana, María, Santiago jaló ru'umacá, ajopana inaana hua'até, quele i'imaño rimacápo'oco yucuna najló. ");
INSERT INTO ycn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","E'iyonaja uncá nema'alá na'apiyá. “Majopeja japi napura'acó huajhua'até,” queja napechu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Apala uncá ñaqué calé ca'ajná Pedro pechu i'imacá. Ricá jácho'oro, recho'ó ají que a'ajná ño'ojó támijimi to'otáquelana ejo, iphari rejo. E riyacá'o ulahuí chojé, amari meñaru ri'imacá. A'arumacaji José mapíra'acare rinacu i'imacá, yá'aro apojó pumitá. Marí que ramaca aú ripa'ó piño rapumí chuhuá. Cajrú ri'ijnataca ripéchuhua. ");
INSERT INTO ycn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Rihuacajé caja iyamá ina'uqué i'ijnaño ají a'ajná ño'ojó pajimila Emaús ejo. Pajluhuaja iphata ji'imaji nacojé quele quilómetros quetana júcaca Jerusalén eyá ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na'apaca nacú napura'ó pajhua'atéchaca Jesús nacú méqueca nala'acá ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","E'iyohuá que Jesús iphácaco najhua'até. Reyá ra'apá najhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Namá ricá. Apojó ri'imacá nejlú chu, nahue'epica piyá Jesús huani ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","E Jesús quemari najló: —¿Na nacú chi ipuri'ichó maare ja'apíchaca nacú? ¿Naje i'ijnatá camu'ují ipéchuhua? Marí que rimacá najló aú natajnó iñe'epú chu. ");
INSERT INTO ycn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","E apú quemari rijló, Cleofas rií i'imacá, rimá rijló: —Piyuque ina'uqué maárohua hue'epiño méqueca ri'imacá Jerusalén e i'imacá. Caja cajrú riyucuna jema'acó piyuque Jerusalén ehuá. ¿Picaja calé chi uncá jema'alá riyucuna? ");
INSERT INTO ycn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús quemari najló: —¿Meque chi ri'imacá rehuá? Nemá rijló: —Nazaret eyaje, Jesusmi chu i'imacá. Tupana puráca'alo ja'apátajeri ri'imacá. Palá huani rila'ajica ina'uqué; palá huani caja rehuíña'atajica ina'uqué Tupana nacú. Aú calé piyuque ina'uqué pechu i'imaqué palá rinacu. Ñaqué caja Tupana pechu i'imajica rinacu. ");
INSERT INTO ycn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","E'iyonaja sacerdótena huacára'ajeño, ajopana huahuacára'ajeño, quele a'añó ricá ajopánajlo, nenócaloje ricá penaje. Nacúhua'ata ri'imacá a'ahuaná apiyácacanami nacú i'imacá. Nephá ricá itapuhua aú riyáte'ela yá'aca eyá. Ejomi nacúhua'ata ricá. ");
INSERT INTO ycn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Huapechu i'imá caphí richojé, ri'imatácaloje huecá, Israelmi chu laquénami, ajopana te'eré eyájena liyá penaje. Caja hueji que cálicha huecá nenoca ricá ejomi. ");
INSERT INTO ycn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Huanaquiyana, inaana, i'imichaño riyucuna huajló, meñaru namíchaca ulahuí chiyá yucuna. Aú huapechu i'imichá: “¡Meque piyuque huani rila'acá!” Ne'ejichá támijimi to'otáquelana ejo lapiyami, camú jeño'ochaca ee. ");
INSERT INTO ycn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Iphíchaño rejo, amíchaño uncá ri'imalá richu. Aú napi'ichó riyucuna i'imajé huajló. Nemicha huajló: “Huamicha Tupana hua'atéjena, je'echú chiyájena, ya'achíyaco huajló. Necá quemíchaño huajló ‘Cajmuni Jesús’,” que inaana i'imichaca huajló riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ejomi huajhuáque'ena naquiyana i'ijichaño piño támijimi to'otáquelana ejo. Inaana quemíchaca que namíchaca ricá. Uncá caja namálacha Jesús —que nemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesús quemari najló: —Ñaqué caja Tupana puráca'alo ja'apátajeñomi chuna lana'acá riyucuna papera chojé i'imacá. ¡Meque ijnú huani jema'acá napuráca'alomi ja'apiyá! ¡Meque uncá huani ipechu i'imalá ijló! ");
INSERT INTO ycn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ricá, Tupana huacára'acare majó ina'uqué i'imatájeri penaje, amari chapú caje yajhué. Caja queja ri'imacá Tupana pechu nacú, nala'acáloje ñaqué ricá penaje ri'ijnacá yámona je'echú chojé. Ejomi ri'ijnacáloje je'echú chojé, ri'imacáloje Tupana hua'até rijhua'até huacára'ajeri penaje. Marí caje penaje ramá chapú caje yajhué i'imacá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Rimá najló méqueca Tupana puráca'alo lana'aquéjami quemacá rinacu. Tupana puráca'alo Moisesmi chu lana'acare eyá riqueño'ó riyucuna i'imacana najló pamineco. Ejomi ra'apata piño najló riyucuna, Tupana puráca'alo ja'apátajeñomi chuna lana'acare i'imacá. Marí que ri'imacá najló riyucuna. ");
INSERT INTO ycn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","E caja nephá pajimila nacojé. Rejeja ajopana huátaño i'ijnacana. Eyá Jesús quemari majopeja najló: “No'opíchaca” que. ");
INSERT INTO ycn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nemá rijló: —Maare piyuró huajhua'até. Caja huajúhui'ichaca huani, calajerú chaje majó. —Je, ñaqué ricá. Aú Jesús mujlúca'ari pají chojé najhua'até. ");
INSERT INTO ycn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","E caja nayá'o pajhua'atéchaca, najñácaloje na'ajnehuá penaje. Ejéchami Jesús ña'acá pan ricápojo. Rimá Tupánajlo: —Palá pila'acá huecá marí pan aú. Ritupa'á najló rinaquiyana. E ra'á najló ricá. ");
INSERT INTO ycn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ejéchami nejlú me'etaco rinacojé, amaño Jesusca ri'imacá. Ejeja rimicho'ó naliyá. ");
INSERT INTO ycn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aú nemá pajlocaca: —Chuhua huahue'epí naca la'arí pu'ují huani huapechu ra'apíchaca huajhua'até iñe'epú chuhuá quetana. Palá ra'apáchiyaca huajló Tupana puráca'alo. Jesús ri'imichaca, puri'icharo huajhua'até. Ñaquele pu'ují huapechu i'imichaca —que nemacá pajlocaca. ");
INSERT INTO ycn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Rejéchami napa'acó piño Jerusalén ejo. Nephá ajopana nacú. Jesús ja'apiyatéjena i'imari pajluhuaja iphata ji'imaji nacojé quele. Necá i'imaño ajopana najhuáque'ena hua'até re. Nanacu nephá. ");
INSERT INTO ycn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","E caja re i'imacaño quemaño najló: —Quehuaca jo'ó Jesús macápo'ocharo. Simón Pedro amíchari ricá. ");
INSERT INTO ycn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","—Que jo'ó ricá. Ñaqué caja huamíchaca ricá i'imichaca —que huajé iphácaño quemacá najló. Aú ne'emá najló méqueca ripura'acó najhua'até iñe'epú chuhuá yucuna. Nemá caja najló méqueca nejlú me'etaco rinacojé, ritamáca'ataca aú pan najló. ");
INSERT INTO ycn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Marí que ne'emacá riyucuna najló. Ejéchami Jesús ya'atacó najló mana'í chiyó rejé. Rajalaca necá. E rimá najló: —I'imá palá pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Cajrú riquero'ótaca najló raú. Napechu i'imá rinacu: “Ina'uqué ñacami japi ricá” que. ");
INSERT INTO ycn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","E Jesús quemari najló: —¿Naje chi iquero'ochó? ¿Uncá chi ihue'epila Jesusca nucá? ");
INSERT INTO ycn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Amá nuyáte'ela yá'aca, nu'umá hua'até itapuhua aphumi. Jesús nucá. Isápicha nunacu, ihue'epícaloje palá ricá raú penaje. Uncá ina'uqué ñacami napona i'imalá iná napona que caja. Uncá caja raphina i'imalá. Uncá ñaqué calé nucá. Re nunapona amácare me'etení —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ejomi riya'atá najló riyáte'ela yá'aca, ri'imá hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pu'ují huani napechu la'acó raú. Cajrú ne'ejnataca napéchuhua rinacu. E'iyonaja napechu i'imá: “Apala uncá ricá calé ricá.” Aú Jesús quemari najló: —¿E chi maare a'ajnejí, nojñachi? ");
INSERT INTO ycn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","E na'á rijló jiña a'amitaqueja jepo'oná, munumunú jalá hua'até. ");
INSERT INTO ycn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","E rijña'á naliyá ricá. Rajñá ricá najimaje. ");
INSERT INTO ycn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ejomi rimá najló: —Ihue'epí méqueca nala'acá nu'umacá. Riyucuna nu'umá ijló nu'umacá ijhua'até huacajé. Numá ijló méqueca Tupana puráca'alo lana'aquéjami quemacá nunacu i'imacá. Ricá Moisesmi chu lana'acare i'imacá, Tupana puráca'alo ja'apátajeñomi chuna lana'acare. Ricá numá nacú ijló i'imacá. Tupana puráca'alo lana'aquéjami iná iphátacare papera Salmos chu, numá caja nacú ijló i'imacá. Ripuráca'alo lana'aquéjami quemacá que nunacu, queja nala'acá numa'acá. Tupana huacára'ari ri'imacáloje marí que penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ejomi rila'á napechu palá, nahue'epícaloje Tupana puráca'alo lana'aquéjami nacojé raú penaje. ");
INSERT INTO ycn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Rimá piño najló: —Marí que Tupana puráca'alo lana'aquéjami quemacá nunacu uncá chiyó nuphá eja'ahuá nacojé i'imacá: “Ricá Tupana huacára'ajicare majó ina'uqué i'imatájeri penaje, taca'ajeri. Hueji que cala i'imajemi rimacápo'ojo piño”, que rimacá nunacu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Eyá marí que rimacá piño inacu: “Ripuráca'alo aú ne'emajé riyucuna piyuque ajopana te'eré i'imacáñojlo. Ne'emajé riyucuna najló, napajno'otácaloje napéchuhua Tupana ejo pu'uhuaré nala'acare liyá penaje. Raú Tupana amájero nachaje pu'uhuaré nala'acare liyá, penaje ne'emajé riyucuna najló. Jerusalén e i'imacáñojlo ne'emajé riyucuna pamineco, ejomi ajopánajlo, ajopánajlo, que ne'emajica riyucuna piyuque ina'uquejlo”, que Tupana puráca'alo lana'aquéjami quemacá inacu —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eyá rimá piño najló: —Icá i'imajeño riyucuna ajopana ina'uquejlo. ");
INSERT INTO ycn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nucá huacára'ajeri e'iyajé Tupana Pechu, Nora'apá quemacare nacú i'imacá. Jerusalén e iyurejo Tupana Pechu iphájica inacu ejená. Reyá a'ajná ño'ojó caja caphí ipechu i'imajica riyucuna i'imacana nacú —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ejomi rihuá'a necá pajimila eyá ají que Betania ejo. Re rácho'ota ra'anapitá. Rimá Tupánajlo, rila'acáloje necá palá penaje. ");
INSERT INTO ycn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","E'iyohuá que rácho'oñaca necá ají que je'echú chojé. ");
INSERT INTO ycn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ajopana tára'año mequetánaja mana'í, pu'ují napechu i'imacale rinacu. E napa'ó piño Jerusalén ejo. Pu'ují huani napechu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hue'echú ca'alá queja nahuacájico Tupana ñacaré chojé, ne'emacáloje Tupánajlo palá rila'acare necá yucuna penaje. Maáreje riyucuna tajnaro.");
INSERT INTO ycn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Uncá chiyó eja'ahuá i'imacá huacajé, Jesucristo i'imari. Nacaje Tupana pechu nacú i'imacare yucuna i'imajeri ricá. Tupana pechu que caja ripechu. Tupana queño'ótaca nacaje huacajé, Jesucristo i'imari rijhua'até re. ");
INSERT INTO ycn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jesucristo hua'até Tupana queño'ótari piyuqueja nacaje i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jesucristo a'arí inajlo cajmuchaji, iná i'imacáloje matajnaco je'echú chu raú penaje. Rilamá'ata caja iná pechu palá, iná hue'epícaloje quehuácaje puráca'aloji raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Rica'á iná liyá pu'uhuaré iná la'acare, iná manaicho iná la'acare caje. Uncá meño'ojó pu'uhuaré la'acana i'imalá rijhua'até. Marí caje penaje Jesucristo. ");
INSERT INTO ycn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Apú queño'orí riyucuna i'imacana. Rií i'imari Juan. Tupana huacára'ari ricá, ri'imacáloje Jesucristo yucuna najló penaje. ");
INSERT INTO ycn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Uncá chiyó riphá nanacu, Juanmi chu i'imari najló Jesucristo yucuna, nema'acáloje ra'apiyá penaje. Iná pechu lamá'atajeri Jesucristo, rehuíña'atacale iná quehuácaje puráca'aloji nacú. ");
INSERT INTO ycn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Uncá Juanmi chu calé lamá'atari ina'uqué pechu i'imacá. Uncá meño'ojó rilamá'atala napechu, nahue'epícaloje quehuácaje puráca'aloji nacojé raú penaje. Riyucúnaja calé ri'imá najló. ");
INSERT INTO ycn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Eyá nacaje Jesucristo la'acare aú ina'uqué hue'epiño mecajeca huani Tupana. Ñaqué caja nahue'epica mecajeca ricá ripuráca'alo rehuíña'atacare nacú necá aú. Ricá iphari marí eja'ahuá chojé i'imacá, rilamá'atacaloje piyuqueja ina'uqué pechu palá penaje. Quehuácaje puráca'aloji aú rila'á napechu palá. ");
INSERT INTO ycn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ricá, Jesucristo i'imari marí eja'ahuá chu i'imacá. Ina'uqué ri'imacá. Ricá queño'ótari eja'ahuá i'imacá. E'iyonaja uncá ina'uqué, eja'ahuá chu i'imacaño, hue'epílaño na ina'uqueca ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Riphá eja'ahuá nacojé riqueño'ótacare penájemi nacojé. E'iyonaja ricá'ana, judíona, uncá huátalaño ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ne'iyajena que huaja calé huátaño ri'imacá. Napechu i'imá richojé caphí, ri'imatácaloje necá capichácajo liyá penaje. Nanácuja calé Tupana quemari, ne'emacáloje riyani penaje. ");
INSERT INTO ycn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Uncá iná chi'inajlo que calé iná moto'ocá Tupánajlo, iná i'imacáloje riyani naquiyana penaje. Riyani i'imaño Tupana Pechu aú. Uncá ina'uqué pechu queja calé ne'emacá riyani. Tupánaja calé quemari ina'uqué naquiyana nacú, ne'emacáloje riyani penaje. ");
INSERT INTO ycn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesucristo i'imari ina'uqué i'imacá marí eja'ahuá chu. Majó riphá i'imacá, rimoto'ocáloje ina'uqué que caja penaje. Ina'uqué ri'imacá maare huajhua'até. Huamácare ri'imacá. Rihuajhuena huecá. Rehuíña'ataque ina'uqué quehuácaje puráca'aloji nacú. Huamájica rila'ajica palá huani ina'uqué. Tupana I'irí huani ricá; pajluhuaja calé Ri'irí. Ri'irí ri'imacale, Tupana a'arí riñaté, rila'acáloje piyuque nacaje penaje. ");
INSERT INTO ycn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juanmi chu i'imaqueri Tupana I'irí yucuna ina'uquejlo i'imajica. E caja ehuaja ramá ricá. Ejomi rimá najló marí que: —Ricá po numá nacú ijló i'imacá: “Pajluhuaja iphájeri majó nopumí chojé. Ricá i'imajeri nuchaje huani. Uncá chiyó na i'imá, ricaja calé i'imari pamineco”. ");
INSERT INTO ycn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Palá huani Jesucristo la'acá huecá ripalamane aú. Piyuqueja ina'uquéjloje penaje nacaje rila'acare. ");
INSERT INTO ycn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tupana huacára'ari ina'uqué i'imacá palá pajhua'atéchaca. Riyucuna Moisesmi chu i'imari ina'uquejlo i'imacá. Uncá pachá iná la'alá rihuacára'aca que Tupana huajájeri iná. Eyá Jesucristo, ricá i'imari piño riyucuna. Iqui'ija huani Tupana huátaca ina'uqué yucuna ri'imá huajló. Quehuácaje puráca'aloji nacú ripura'ó huajhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Uncá na calé amari Tupana i'imacá. Ri'irí huani, pajluhuaja ricá. Rara'apá pechu que caja ripechu. Ricá i'imari huajló riyucuna. Ri'imá riyucuna huajló, Tupana ahua'á huani ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judíona naquiyana i'imaño pajimila Jerusalén e. Reyá nahuacára'a ajopana ina'uqué i'ijnacá Juan i'imacá ejo, naquejá'acaloje riliyá riyucuno penaje. Nahuata hue'epícana na ina'uqueca ri'imacá, penaje nahuacára'a necá rejo. Sacerdótena naquiyana, levítana naquiyana, quele nahuacára'a Juan i'imacá ejo. ");
INSERT INTO ycn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","E nephá rinacu, nemá rijló: —¿Picá chi Tupana huacára'acare majó ina'uqué i'imatájeri penaje? Rimá najló pu'ucuja: —Uncá capichácajo liyá ina'uqué i'imatájeri calé nucá. Uncá nucá calé Tupana huacára'acare je'echú chiyá majó —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nemá rijló: —¡Eta! ¿Na chi picá? ¿Ilé Tupana puráca'alo ja'apátajeri Elías chi picá? —Uncá. Uncá ricá calé nucá —que Juan quemacá najló. Nemá piño rijló: —¿Picá chi ilé Tupana puráca'alo ja'apátajeri nemájicare nacú, iphájeri majó aquijñojo? —Uncá caja ricá calé nucá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nemá piño rijló: —¿Na ina'uqueca huani chi picá? Huahuacára'ajeño quejá'ajeño hualiyá piyucuna. Chuhua pimá huajló méqueca pimacá pinacuhuá. ");
INSERT INTO ycn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Raú Juan quemari najló marí que rinacuhuá: —Nucá jahuíyo'ori ina'uquejlo pu'uteni chu. Marí que numacá najló: “Chuhua ilráca'alo ja'apátajeri nemájicare nacú, ipamá'ata ipéchuhua pu'uhuaré ila'acare liyá Huahuacára'ajeri pe penaje”. Marí que caja Isaíasmi chu quemacá nunacu i'imacá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fariséona huacára'acarena ne'emacá, quejá'año riyucuno riliyá. ");
INSERT INTO ycn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nemá piño rijló: —Uncá capichácajo liyá ina'uqué i'imatájeri calé picá. Uncá caja Elías calé picá. Uncá caja Tupana puráca'alo ja'apátajeri calé picá, Tupana huacára'acare majó i'imacá. ¡Eta! ¿Naje ta pila'á bautizar ina'uqué? ");
INSERT INTO ycn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Aú Juan quemari najló: —Nucá la'arí bautizar ina'uqué juni aú. Re apú hue'iyá, uncá ihue'epila na ina'uqueca ricá. ");
INSERT INTO ycn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ricá iphájeri nopumí chojé. Iqui'i huani nuphácare ja'apí ricá, nuchaje huani ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Marí que napura'acó pajhua'atéchaca pajimila Betania e. Juni Jordán pa'anajo pitá pajimila i'imari. Rejeja Juan la'aqueri bautizar ina'uqué. ");
INSERT INTO ycn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","E caja Jesús chira'aró rehuá. Ramaca aú ricá rimá marí que rinacu: —Ohuéjana i'irí huenono Tupánajlo pu'uhuaré huala'acare chaya. Iyacá'o, ricá huani penaje huaíchaca, Tupana a'ajícare ina'uqué chaya penaje ricá. Nenoje ricá, rica'acáloje pu'uhuaré huala'acare huanaquiyá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ricá po ilé numá nacú ijló i'imacá. Marí que numacá ijló i'imacá: “Apú iphájeri majó nopumí chojé”. Nuchaje huani ricá. Uncá chiyó na i'imá, ricaja calé i'imari”. ");
INSERT INTO ycn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Uncá caja nuhue'epila na ina'uqueca ri'imacá. Majó nu'ujná; nula'á bautizar ina'uqué juni aú. Nu'umá caja riyucuna Israelmi chu laquénamijlo, nahue'epícaloje ricá Tupana huacára'acare majó nacojé penaje —que Juan quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","E caja Jesús iphari Juan nacú. Ri'imá najhua'até mequetánaja re. E Juan la'arí ricá bautizar. Ejomi Juan quemari ajopánajlo: —Nomicha Tupana Pechu huitúca'aca je'echú chiyá majó. Túcu'uchi huitúca'aca que rihuitúqui'ichaca Jesús nacojé. E caja riyuricho rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Uncá caja nuhue'epila pamineco na ina'uqueca ri'imacá, i'ijnari majó. Tupana huacára'ari nula'acá bautizar ina'uqué. Ricá quemari nojló marí que i'imacá: “Pu'uhuacá pamájica Nupechu huitúca'aca pajluhuaja ina'uqué e'iyajé. Aú pimaje: ‘¿Ricá chi a'ajeri Tupana Pechu ina'uquejlo?’” que Tupana quemacá nojló rinacu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Caja nomicha chuhua rimacare nacú nojló i'imacá. Ñaquele chuhua numá rinacu: “Tupana I'irí ricá” —que Juan quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","E muní que piño Juan i'imari re, iyamá ra'apiyatéjena hua'até. ");
INSERT INTO ycn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","E ramá Jesús ja'apaca a'ajnare que. Aú rimá rijhua'atéjenajlo: —Iyacá'o, amá ilé ja'apaca. Ohueja i'irí huenono Tupánajlo pu'uhuaré huala'acare chaya. Ricá huani penaje ilé. Tupana a'ajeri ina'uquejlo ricá ina'uqué chaya, nenócaloje ricá pu'uhuaré ina'uqué la'acare chaya penaje. ");
INSERT INTO ycn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Marí que rimacá aú ra'apiyatéjena naquiyana, iyamá, i'ijnaño Jesús ápumi chu. ");
INSERT INTO ycn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","E Jesús yacá'aro riyámajo; amari na'apaca rápumi chu. Aú rimá najló: —¿Na iculá? Nemá rijló: —Huehuíña'atajeri, ¿mere que chi picá? ");
INSERT INTO ycn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús quemari najló: —I'ijná nujhua'até, amíchachi mere que nucá. Raú ne'ejná rijhua'até; iphaño rejo; amaño mere queca ri'imacá. Caja pe'iyochá camú to'ocó. Aú rejé najúhua'a rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Iyamá necá jema'añó méqueca Juanmi chu quemacá Jesús nacú i'imacá. Ejomi ne'ejná Jesús hua'até. Pajluhuaja nanaquiyana ií i'imari Andrés; Simón e'ehué ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ricá penaje i'ijnari pu'ucuja re'ehué Simón culaje. E ramá ricá; rimá rijló: —Caja huamicha ricá Tupana huacára'acare majó ina'uqué i'imatájeri penaje. ");
INSERT INTO ycn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","E Andrés huá'ari Simón ají que a'ajná ño'ojó Jesús i'imacá ejo. E Jesús yacá'aro richaje, rimá rijló: —Simón pií; Jonás i'irí picá. Chuhua no'ojica pií Pedro. (Jipa que quemacánaca Pedro napura'acó chu.) ");
INSERT INTO ycn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","E muní que Jesús huátari Galilea te'eré ejo i'ijnacana. Ri'ijná ají que a'ajná ño'ojó, amari Felipe. ");
INSERT INTO ycn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pajimila Betsaida eyaje ri'imacá. Ricá pajimila eyájena caja Andrés, Pedro, quele i'imacá. Jesús amari Felipe. E rimá rijló: —Pi'ijná nujhua'até, pi'imacáloje no'opiyateje penaje. —Je —que rimacá. ");
INSERT INTO ycn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","E Felipe i'ijnari Natanael culaje. E ramá ricá. A'ahuaná ja'apí riyá'o. E rimá rijló: —Nucá, ajopana hua'até, amíchaño ilé ina'uqué Tupana puráca'alo lana'aquéjami quemacare nacú. Moisesmi chu lana'arí riyucuna i'imacá. Ñaqué caja Tupana puráca'alo ja'apátajeñomi chuna lana'acá riyucuna i'imacá. Jesús, José i'irí, ricá nemájicare nacú. Nazaret eyaje ricá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aú Natanael quemari rijló: —Uncá meño'ojó ri'imalajla palájne'eque, Nazaret eyaje ri'imacale. Felipe quemari rijló: —Pi'ijná nujhua'até, pamíchachi ricá. —Je —que rimacá rijló. Aú ri'ijná rijhua'até rejo. Iphaño Jesús nacú. ");
INSERT INTO ycn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús amaca aú ricá huaíchaca rimá rinacu marí que: —Ilé huaícha majó, Israélmi chu laquénami naquiyana ricá, Tupana huátacare ricá. Uncá na hua'até calé pajlaca ricá. ");
INSERT INTO ycn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","E Natanael quemari rijló: —¿Meque la'ajé chi pihue'epí nucá? Jesús quemari rijló: —Uncá chiyó Felipe huá'ichari picá majó, nomicha piyá'ichaco a'ahuaná ja'apí. ");
INSERT INTO ycn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Raú Natanael quemari rijló: —Huehuíña'atajeri, picá Tupana I'irí. Israelmi chu laquénami huacára'ajeri penaje caja picá. ");
INSERT INTO ycn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús quemari rijló: —Meque majopeja huani pipechu li'ichaco nochojé caphí, numíchacale pijló: “A'ahuaná ja'apí nomicha piyá'ichaco”. Richaje huani nula'ajica nacaje, uncá meño'ojó ina'uqué la'alare. Picá amájeri méqueca nula'ajica ricá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","E Jesús quemari piño rahua'á i'imacáñojlo: —Jema'á marí: Icá amájeño nula'ajica cajrú nacaje, Tupana hua'atéjena, je'echú chu i'imacaño, i'ijnajícale majó nuñaté a'ajé. ");
INSERT INTO ycn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Hueji que cala ejomi Jesús i'imari pajimila Caná ejo. Galilea te'eré nacú ricá pajimila. Nayucupéra'a ricá, ra'apiyatéjena hua'até, namácaloje apú huá'acaco penaje, nacajmo'ocóloje najhua'até penaje. Aú ne'emá rejo cajrú ina'uqué hua'até. Raló, María, i'imayo caja najhua'até. E caja nacajmóca'alo iphari rená chojé. ");
INSERT INTO ycn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Re'iyá ne'eracala tajnáñari necá. Raú Jesús jaló quemayo Jesusjlo: —Caja hue'eracala tajícharo. ");
INSERT INTO ycn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","E Jesús quemari rojló: —¿Naje pi'imichá riyucuna nojló? Uncá jo'ó noná iphala rená chojé. ");
INSERT INTO ycn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","E'iyonaja rumá pají chiyá sápajeñojlo: —Ila'á piyuqueja rimájica ijló que. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pajluhua cuhuá'ata ca'alá i'ichí i'imari re. Jipa naquiyá la'acanami ri'imacá. Judíona lamá'ataca napéchuhua pu'uhuaré nala'acare liyá huacajé naco'ó juni ricá i'ichí chojé. Pajlúhua'ala i'ichí ña'arí juni, cincuenta litros ca'ajná, setenta litros ca'ajná. ");
INSERT INTO ycn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","E caja Jesús quemari pají chiyá sápajeñojlo: —Ipitá juni i'ichí chojé pu'uteno ri'imajica ejená. —Je —que nemacá. Aú namano'otá ricá pu'uteno huaja. ");
INSERT INTO ycn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","E Jesús quemari najló: —Chuhua amo'ó i'ichí chiyá huejápaja, a'achachi ricá huayucupéra'ajerijlo. —Je —que nemacá. Aú namo'ó rinaquiyana; ne'ejnatá rijló ricá. ");
INSERT INTO ycn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","E nayucupéra'ajeri atá'ari ricá. Juni jehuíña'atacanami, cajmú caje jalá amúra'atacanami que caja ri'imacá. Uncá rihue'epila mere eyaca najña'acá ricá. Pají chiyá sápajeño, queleja hue'epiño riyucuna, namo'ocale ri'imacá. Ri'irá rinaquiyana huajápaja. E rihuá'a huá'acaro penaje maná. Riphá rijimaje. ");
INSERT INTO ycn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","E rimá rijló: —Piyuque ina'uqué a'añó pamineco palá nojé i'iracaje. Ritajnaco aú na'á najló apú i'iracaje majopéjari quemachi caja penaje. Eyá picá, a'arí caja penaje patá nojé i'iracaje —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Marí que Jesús queño'ocá nacaje la'acana, uncá meño'ojó ina'uqué la'alare. Galilea te'eré nacú pajimila Caná. Re riqueño'ó nacaje la'acana marí que huajé. Juni riqueño'óta cajmú caje jalá amúra'atacanami que caja ri'imacá. Raú ina'uqué hue'epiño piyuque hue'epica ricá. Raú caja ra'apiyatéjena hue'epiño Tupana huacára'acare majó ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Marí que rila'acá ejomi ri'ijná ají que pajimila Capernaum ejo. Raló, rejena, ra'apiyatéjena, quele i'ijnaño caja rijhua'até. Re ne'emá meque cálaja. ");
INSERT INTO ycn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yehuicha nephaca fiesta jená chojé i'imacá. Pascua fiesta ií. Marí caje aú Jesús i'ijnari Jerusalén ejo. ");
INSERT INTO ycn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iphari Tupana ñacaré chojé. Re ramá ina'uqué a'acá ajopánajlo pirajina, nacánacaloje liñeru raú najluhua penaje. Jémana piracana, ohuéjana, túcu'uchina piracana, caje macá na'á najló. Ramá caja re liñeru apiyácajeño yá'aco. Liñeru napiyaca ina'uquejlo i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Marí que ramaca aú rila'á naña'atájona penaje tupajuma naquiyá. Eta, ra'apá nanacu Tupana ñacaré chiyá. Ra'apá caja nacajena nacú, jémana piracana, ohuéjana, quele. Ra'apá caja ina'uqué re i'imacaño nacú. E caja ri'ijná liñeru apiyácajeño ahua'ajé. Eta, rica'á huichá naliñérute naliyá te'erí e'iyajé. Rejomi ripajno'otá namesané. ");
INSERT INTO ycn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Túcu'uchina piracana a'ajéñojlo rimá: —Imujlúca'ata necá huaca'apojo. Ila'aniya Nora'apá ñacaré le'ejepelaji ñacarelana que —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ra'apiyatéjena amaño méqueca ra'apaca nanacu Tupana ñacaré chiyá. Raú riphá napechu nacojé méqueca Tupana puráca'alo lana'aquéjami quemacá rinacu: “Iqui'i nuhuátaca ina'uqué iphaca Tupana ñacaré ja'apí,” que rimacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","E mequetana i'imajemi judíona naquiyana quemaño Jesusjlo: —¿Na ca'ajná huacári'ichari pila'acá maapami pili'ichaje caje? ¿Na aú chi huahue'epeje picá? ");
INSERT INTO ycn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús quemari najló: —Icajya'atá marí Tupana ñacaré. Eyá hueji que cala i'imajemi nócho'otaje piño ricá rapumí chuhuá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aú nemá rijló: —Cuarenta y seis jarechí quetana naca'acá rila'acana nacú. ¡Eta! ¿Picá chi jácho'otajeri ricá hueji que cala i'imajemi? —que nemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Rinapona nacú Jesús quemari najló “Tupana ñacaré” que. Uncá nahue'epila méqueca rimacá najló i'imacá rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ritaca'acá ejomi rimacápo'o piño i'imacá. Ejéchami ra'apiyatéjena hue'epica méqueca rimacá rinacuhuá i'imacá. Raú nala'á quehuaca que Tupana puráca'alo lana'aquéjami quemacá que. Ñaqué caja nala'acá quehuaca que Jesús puráca'alo, rimajícare nacú najló i'imajica. ");
INSERT INTO ycn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Fiesta pascua huacajé Jesús i'imari Jerusalén e. E'iyá cajrú ina'uqué jema'añó ra'apiyá, namácale rila'acá cajrú nacaje. ");
INSERT INTO ycn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","E'iyonaja Jesús hue'epiri necá. Uncá ra'apiyá jema'ajeño huani calé ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Uncá naje calé apú quemari rijló ajopana ina'uqué nacú, rihue'epícale piyuqueja napechu. ");
INSERT INTO ycn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pajluhuaja ina'uqué i'imari. Rií i'imari Nicodemo. Fariseo naquiyana ri'imacá. Judíona huacára'ajeño naquiyana caja ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","E caja Nicodemo i'ijnari Jesús chaje lapí. Riphá rinacu. E rimá Jesusjlo: —Huehuíña'atajeri, huahue'epí Tupana huacára'aca picá majó huehuíña'atajeri penaje. Cajrú huani nacaje pila'acá uncá meño'ojó iná la'alare. Uncá meque la'ajé iná la'alá pila'acá que. Tupana a'acale piñaté, pila'á piyuque huani nacaje. Nacaje palani huani pila'acare aú huahue'epí Tupana huacára'aca picá majó —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","E Jesús quemari rijló: —Pema'á marí: Uncachu iná moto'olaje piño, uncá Tupana hua'ateje calé iná —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo quemari rijló: —Eta, ¿Meque la'ajé chi iná moto'ójla piño, caja phíyu'uque iná i'imacachu? Uncá meño'ojó calé iná pa'ójla iná jaló huo chojé piño, iná moto'ocáloje huajé piño penaje —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús quemari rijló: —Pema'á marí: Uncachu iná moto'olá piño juni aú, Tupana pechu aú, iná i'imacáloje Tupana i'irí raú penaje, uncá meño'ojó iná iphala Tupana i'imacá ejo. Rijhua'até i'imacaño huacára'ajeri ricá. ");
INSERT INTO ycn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ina'uqué yaní moto'oñó; ina'uqué naquiyánaja necá. Eyá ina'uqué i'imaño piño Tupana yaní Ripechu queño'ocá aú najhua'até i'imacana. ");
INSERT INTO ycn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Piquechíra'ataniya pipéchuhua íqui'i huani numacá aú ina'uqué nacú, namoto'ocáloje huajé que caja penaje. ");
INSERT INTO ycn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Carená apho'orí rihuátaca ejo. Iná jema'á rimejé. E'iyonaja uncá iná hue'epila mere eyaca riqueño'ótaco. Uncá caja iná hue'epila meño'ojoca ra'apaca. Ñaqué caja uncá iná hue'epila méqueca Tupana Pechu ja'acó ina'uqué e'iyajé, ne'emacáloje Tupana yaní raú penaje —que Jesús quemacá Nicodémojlo. ");
INSERT INTO ycn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo quemari rijló: —¿Meque chi quele pimá nacú nojló. ");
INSERT INTO ycn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Aú Jesús quemari rijló: —Cajrú pehuíña'ataca Israelmi chu laquénami. ¿Uncá chi pihue'epila meque numacare nacú pijló? ");
INSERT INTO ycn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pema'á marí: Palá nu'umichaca riyucuna pijló. Huecá, Tupana hua'até, hue'epiño nacaje huapura'acaro nacojé. Nacaje huamácare nacú huapura'ó. E'iyonaja uncá na calé inaquiyana a'añó huapuráca'alo inacojó. ");
INSERT INTO ycn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Uncá puhuichani calé ijló nacaje nacojé hue'epícana marí eja'ahuá chu i'imacare. E'iyonaja numacachu rinacu ijló, uncá caja jema'alá no'opiyá. ¿Meque ca'ajná jema'acajla no'opiyá, nu'umaquela ijló nacaje je'echú chu i'imacare yucuna. ");
INSERT INTO ycn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Uncá na calé jácho'oro je'echú chojé i'imacá. Nucaja calé huitúca'ari reyá majó i'imacá. Nucá i'imaqueri rehuá. Ina'uquéjloje i'imacá nucá —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Rimá piño rijló: —Júpimi, Moisesmi chu i'imacá huacajé, Moisesmi chu tára'atari a'ahuaná i'imacá. Ya'ajná pu'uteni meñaru chu ritára'ata ri'imacá. Rinacu jeí jenami pato'oró. Pejru'uhuá caje naquiyá la'acanami jeí jenami i'imacá. Ñaqué caja natára'atajica piño apaná a'ahuaná. Nucá i'imari ina'uquéjloje penaje, cúhua'ajero rinacu, nutaca'acáloje ina'uqué chaya penaje. ");
INSERT INTO ycn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Raú caphí nochojé péchuruna i'imajeño matajnaco je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Iqui'ija huani Tupana huátaca ina'uqué. Ñaquele rihuacára'a Ri'irí huani majó eja'ahuá chojé i'imacá. Pajluhuaja huani Ri'irí. Iná pechu i'imacachu caphí richojé, ri'imatá iná capichácajo liyá, iná i'imacáloje matajnaco rijhua'até je'echú chu raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Uncá Tupana huacára'ala Ri'irí eja'ahuá chojé i'imacá, rihuajácaloje ina'uqué penaje. Rihuacára'a ricá majó, ri'imatácaloje ina'uqué Tupánajlo capichácajo liyá penaje. Richojé ina'uqué i'imajeñó capichácajo liyá. ");
INSERT INTO ycn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Caphí iná pechu i'imacachu Tupana I'irí chojé, uncá Tupana huajálaje iná. Uncachu iná pechu i'imalá caphí richojé, Tupana huajájeri iná. Uncá pachá iná la'alá quehuaca que rimacare Ri'irí nacú rihuajaje iná. ");
INSERT INTO ycn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tupana huajájeri ina'uqué uncá pachá napechu i'imalá caphí Jesucristo chojé ne'ematájeri penaje. Rihuajaje necá, uncale nahuátala ricá. Quemari ina'uquejlo quehuácaje puráca'aloji nacú, uncá nahuátala ricá. Richaje nahuata pajlácachi ja'apiyá jema'acana. Richaje caja nahuátaca pu'uhuaré la'acana. Cajeja nahuata najluhua, pu'uhuaré la'ajeño ne'emacale. ");
INSERT INTO ycn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Namanaicho la'ajeño, pu'uhuaré la'ajeño, quele uncá huani huátalaño quehuácaje puráca'aloji. Uncá huani nahuátala rema'acana, pu'uhuaré nala'acare i'imacá piyá najló pu'uhuacá. ");
INSERT INTO ycn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Eyá palá la'acaño, necá huátaño quehuácaje puráca'aloji jema'acana. Nahuata ra'apiyá i'imacana. Raú Tupana a'arí nañaté nacaje nala'acare aú. Aú calé ajopana amaño nala'acá palá huani ra'apiyá jema'acana aú. ");
INSERT INTO ycn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Apú huacajé piño Jesús i'ijnari ra'apiyatéjena hua'até ají que Judea te'eré ejo. Re ri'imá najhua'até. Ra'apiyatéjena la'añó bautizar ina'uqué i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ma'apona que Juan la'acá bautizar ina'uqué Enón e. Pajimila Salim ahua'á ricá. Re Juan la'aqueri bautizar ina'uqué, cajrú juni i'imajícale re. Rejo cajrú ina'uqué i'ijnajica, rila'acáloje bautizar necá penaje. ");
INSERT INTO ycn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Marí que la'acana nacú Juan i'imaqué rehuá, uncá chiyó naca'á ri'imacá ina'uqué huajáquelana chojé. ");
INSERT INTO ycn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","E apú huacajé Juan ja'apiyatéjena naquiyana aca'ácaño judíona naquiyana hua'até. Apojó nemacá paliyácaca bautizar la'acana nacú. Jimaje naca'ácaco pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Marí caje aú ne'ejná riyucuna i'imajé Juanjlo. Nephá rinacu. E nemá rijló: —Huehuíña'atajeri, Jordan pa'ajnajo pumitá hue'emacá huacajé, pajluhuaja ina'uqué iphari pinacu. Pimá huajló i'imacá na ina'uqueca ri'imacá. Chuhua ricá penájemi huacára'ari ra'apiyatéjena, nala'acáloje bautizar ina'uqué penaje. Chuhua piyuqueja ina'uqué i'ijnaño richaje, ra'apiyatéjena la'acáloje bautizar necá penaje —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Raú Juan quemari najló: —Uncá na calé la'arí palá nacaje, uncachu Tupana a'alá iná ñaté. ");
INSERT INTO ycn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Icá jema'añó méqueca numacá nunacuhuá i'imacá. Palá numacá ijló nunacuhuá: “Uncá nucá calé Tupana huacára'acare majó ina'uqué i'imatájeri penaje. Ritucumaja calé Tupana huacára'ari nucá riyucuna i'imajé ina'uquejlo”, que numacá ijló nunacuhuá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nahuá'acaco huacajé, pajluhuaja achiñá huá'acaro riyajalo penaje hua'até. Patarí ricá, jema'arí rimacare nacú. Pu'ují ripechu la'acó raú. Ñaqué caja pu'ují nupechu, cajrú ina'uqué i'imacale Jesucristo hua'até. ");
INSERT INTO ycn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Palani nuchaje, nuchaje que ri'imajica ina'uquejlo. Lanáquiya majopéjari queja nu'umajica najló —que Juan quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ajopana ina'uqué chaje huani ricá, iphari je'echú chiyá majó i'imacá. Marí eja'ahuá chujena majopéjaruna necá. Marí eja'ahuá chu i'imacana nacú napura'ó. Eyá iphaca je'echú chiyá majó, pura'aró nacaje ramácare nacú Tupana i'imacá e. ");
INSERT INTO ycn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ripuráca'alo rema'acare re nacú hua'ató ripura'ó. Ajopana chaje huani ricá. E'iyonaja uncá na calé jema'arí ripuráca'alo ja'apiyá. ");
INSERT INTO ycn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jema'arí je'echú chiyaje puráca'alo ja'apiyá, quemari Tupana puráca'alo nacú: “Quehuácaje ricá.” ");
INSERT INTO ycn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tupana huacára'ari Jesucristo i'imacá, ra'apátacaloje ripuráca'alo ina'uquejlo penaje. Tupana a'arí rijló Ripechu, rihue'epícaloje Tupana hue'epica que caja raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tupana huajhué Ri'irí. Ra'á rijló piyuque nacaje. ");
INSERT INTO ycn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Iná pechu i'imacachu caphí Tupana I'irí chojé, iná i'imajica hua'ajini huani rijhua'até je'echú chu raú, uncá iná tajnálajo. Uncachu iná jema'alá Tupana I'irí ja'apiyá, uncá ra'alá inajlo cajmuchaji. Uncachu ra'alá inajlo cajmuchaji, uncá iná i'imalaje matajnaco je'echú chu. Uncá pachá iná jema'alá ra'apiyá, chapú huani Tupana huajájica iná. ");
INSERT INTO ycn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Marí que yucu iphaca fariséona nacú i'imacá: “Juan ja'apiyatéjena chaje íqui'ica Jesús ja'apiyatéjena. Richaje caja íqui'irunaca rila'acá bautizar ina'uqué,” que yucu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Uncá quehuaca calé nemacá. Uncá Jesús la'alá bautizar ina'uqué. Necaja calé, ra'apiyatéjena, la'añó bautizar necá. ");
INSERT INTO ycn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesús hue'epica aú fariséona jema'acá riyucuna, rácho'o Judea te'eré eyá, ripa'acóloje Galilea te'eré ejo penaje. ");
INSERT INTO ycn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","E caja Jesús ja'apari ají que Samaria te'eré e'iyohuá. ");
INSERT INTO ycn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Riphá pajimila Sicar nacojé. Te'erí Jacobmi chu a'acare ri'irimi chujlo, Josemi chujlo i'imacá, ahua'ajé riphá. ");
INSERT INTO ycn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Re juni jamo'oquelana i'imacá. “Jacobmi chu jamo'oquelánami,” que na'acá rií. Rejé Jesús iphari. Caja raya'ó ja'apácaje nacú, raú rihuatána'a juni jamo'oquelana ahua'á. Rejé caápu'ucu i'imari nachá. ");
INSERT INTO ycn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Aú ra'apiyatéjena i'ijnaño pajimila ejo a'ajnejí huarúhua'aje. Yámijo pajluhuájaru inanaru iphayo rejé juni amo'ojé. Samaria eyájeru ru'umacá. E Jesús quemari rojló: —Pa'á nojló juni, nu'urachi. ");
INSERT INTO ycn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Raú rumá rijló: —¿Meque la'ajé chi piquejá'a nuliyá juni, Judíona naquiyana pi'imacale? Samaria eyájeru nucá —que rumacá rijló. (Ijnú ruhuátaca rijló juni a'acana. Aú rumá rijló ilé que. Júpimi nachi'inami chuna nócaño pajhua'atéchaca i'imacá. Aú chapú napechu i'imacá panacuhuácaca judíona, Samaria eruna, hua'até.) ");
INSERT INTO ycn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús quemari rojló: —Uncá pihue'epila naca Tupana a'acá inajlo. Pihue'epíquela na ina'uqueca nucá, piquejá'ajla nuliyá juni. Raú no'ójla pijló juni. Juni no'ocare ina'uquejlo a'arí cajmuchaji najló, natajnaco piyá raú —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Rumá rijló: —Eta uncá na i'imalá picapi. ¿Na aú chi pamo'ojé nojló juni? Ya'ajná riphuta chu ricá. ¿Meque la'ajé ca'ajná pamo'ójla nojló cari juni, a'acare inajlo cajmuchaji, iná i'imacáloje matajnaco raú penaje? —que rumacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Rumá piño rijló'uqueca nucá, piquejá'ajla nuliyá juni. Raú no'ójla pijló juni. Juni no'ocare ina'uquejlo a'arí cajmuchaji najló, natajnaco piyá: —Chuchumi chu, Jacobmi chu, yuriri huajló marí juni amo'oquelana i'imacá. Ricami chu, riyánimi chuna, ripiránami chuna quele i'iraqueño richiyá. Palá huani rila'acá huecá raú. ¿Richaje chi pila'ajica huecá palá nacaje aú? —que rumacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Rimá rojló: —Iná i'iracachu marí chiyá juni, rejomi maca'aní iná i'irataca piño juni. ");
INSERT INTO ycn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Eyá ilé juni no'ocare, uncá iná núru'upi chu macára'atalajo piño raú. Juni amo'oquelana uncá tajnálaro que caja iná e'iyá ilé cajmuchaji no'ocare ina'uquejlo. Raú iná i'imacá matajnaco —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Raú rumá rijló: —Eco pa'á nojló ilé caje juni, nu'ujnacá piyá majó piño juni amo'ojé. Uncá caja nunúru'upi chu macára'atalajo piño raú —que rumacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús quemari rojló: —Chuhua pipa'ó piño piñacaré ejo, pihuá'ichachi piyajná majó —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Raú rumá Jesusjlo: —Uncá na i'imalá nuyajná. Rimá rojló: —Quehuaca jo'ó pimá nacú nojló. ");
INSERT INTO ycn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pajluhua té'ela quele achiñana hua'até pi'imacá. A'ajná pi'imacare hua'até me'etení, uncá piyajná huani calé ricá. “Uncá na i'imalá nuyajná”, que pimíchaca nojló. Quehuaca jo'ó pimíchaca nojló i'imichaca —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aú rumá rijló: —Chuhua nuhue'epí Tupana puráca'alo ja'apátajeri picá. ");
INSERT INTO ycn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Huachi'inami chuna, Samaria erúnami chuna ne'emacá, i'ijnaqueño ca'ajnó ipuré ejo, napechu i'imacáloje pu'ují Tupana nacú re penaje. Eyá icá, judíona, quemaño Jerusalén ejo iná i'ijnacá, iná pechu i'imacáloje pu'ují Tupana nacú penaje —que rumacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús quemari rojló: —Pema'á no'opiyá. Rihuacajé huaícha pu'ují iná pechu i'imacá Tupana nacú majopeja. Uncá iná i'ijnalaje ipuré ejo; uncá caja iná i'ijnalaje Jerusalén ejo. ");
INSERT INTO ycn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Icá Samaria eruna pechu i'imá Tupana nacú pu'ují. E'iyonaja uncá ihue'epila naca ricá. Eyá huecá, judíona, hue'epiño naca ricá. Pajluhuaja huanaquiyana i'imatájeri ina'uqué capichácajo liyá. Raú huahue'epí naca ricá. ");
INSERT INTO ycn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tupana Pechu ja'apiyá que iná pechu i'imacá rinacu pu'ují. Marí palani. Ripechu aú caja iná hue'epí naca ricá. Marí que Ripechu ja'apiyá i'imacaño pechu i'imacá pu'ují rinacu me'etení. Ñaqué caja ri'imajica najló. ");
INSERT INTO ycn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Uncá Tupana napona i'imalá. Re ripechu; uncá iná amálare ricá. Ñaquele iná pechu aú ja iná pechu i'imá pu'ují rinacu. Marí que Tupana huátaca ina'uqué pechu i'imacá pu'ují rinacu —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—Nuhue'epí pajluhuaja ina'uqué huaíchaca. Tupana huacára'ajeri ricá majó ina'uqué i'imatájeri penaje. Riphájica huacajé ri'imajé palá huani Tupana yucuna huajló piyuqueja —que rumacá Jesúsjlo. ");
INSERT INTO ycn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús quemari rojló: —Nucá po quele pimá nacú, iphari majó. Hua'até pipura'ó me'etení. ");
INSERT INTO ycn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ejéchami ra'apiyatéjena iphaca Jesús nacú, amaño ripura'acó rujhua'até. Napechu nacuja nemá: “¿Naje chi ripura'ó ilerú inanaru hua'até?” E'iyonaja uncá nemalá rojló: “¿Na pihuata?” que. Nahuata rijló quemacana: “¿Naje pipura'ó rujhua'até?” E'iyonaja nahuó la'aró ripiyá. ");
INSERT INTO ycn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nephaca aú nanacu ruhuitúca'ata ru'utelá te'erí e'iyajé. Ejomi rupa'ó ají que pajimila ejo riyucuna i'imajé ajopánajlo. Rumá najló: ");
INSERT INTO ycn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—I'ijná nujhua'até, amíchachi pajluhuaja ina'uqué a'ajnare ricá. Piyuque nuyucuno ri'imichá nojló i'imichaca. Apala ricá ca'ajná Tupana huacára'acare majó i'imacá; ina'uqué i'imatájeri capichácajo liyá penaje ca'ajná ricá —que rumacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aú nácho'o pajimila eyá; i'ijnaño rujhua'até Jesús i'imacá ejo. ");
INSERT INTO ycn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Re'iyohuá que Jesús ja'apiyatéjena quemacá rijló: —Huehuíña'atajeri, chuhua pajñá pa'ajnehuá. ");
INSERT INTO ycn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Rimá najló: —Re a'ajnejí nojló, nojñácaloje penaje. Uncá ihue'epila naca ricá. ");
INSERT INTO ycn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Raú nemá pajlocaca. —¿Na ca'ajná a'achari rijló a'ajnejí? ");
INSERT INTO ycn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús quemari najló: —Nula'acá aú Nuhuacára'ajeri huátaca que, a'ajnejí que caja nojló ricá. Rihuacára'a nula'acá nacaje. Nuñapátaca aú rila'acana, a'ajnejí que caja nojló ricá. ");
INSERT INTO ycn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nacaje ina'uqué ejátacare huajé que, nemá nacú: “Pa'u queta queri i'imajemi richa i'imajé huajló. Quetana hue'echú ca'alá i'imajica huajló”, que nemacá. Eyá nucá quemari: imaniya, “Re cajrú hue'echú ca'alá ina'uquejlo, nema'acáloje Tupana yucuna penaje”. Numá ijló, re cajrú ina'uqué, nema'ájla Tupana ja'apiyá me'etení, ne'emaquela najló riyucuna. ");
INSERT INTO ycn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ina'uqué jema'acachu Tupana ja'apiyá riyucuna jema'acana aú, Tupana a'ajeri riyucuna i'imajéñojlo rihuemí. Palá nala'acá necá riyucuna i'imacana najló aú. Tupana ja'apiyá jema'ajeño ne'emacale, ne'emajica matajnaco je'echú chu raú. Ajopana ca'ajná queño'oñó riyucuna i'imacana uncá jema'alaño riyucúnajlo. Raú naqueño'ó Tupana nacojé hue'epícana. Pumí chiyó ajopana piño ca'ajná i'imaño Tupana yucuna najló. Rihuacajé ca'ajná nema'á ra'apiyá. Tupana a'ajeri riyucuna i'imajéñojlo rihuemí, palá nala'acare huemí. Rihuacajé napechu i'imajé pu'ují. ");
INSERT INTO ycn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Apa'amá puráca'aloji quemari marí que: “Apú ejátari nacaje icha ijí. Richa i'imacá ee apú caja ña'arí richa”. ");
INSERT INTO ycn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ñaqué caja ri'imajica ijló. Nuhuacára'aje i'ijnacá riyucuna i'imajé ajopánajlo. Ajopana jehuíña'atacarena necá penájenami ne'emajica. I'imajica aú nuyucuna najló, nema'ajé no'opiyá, ajopana jehuíña'atacale ne'emacá nunacu ipiyá. Ñaquele napalamane aú na'ajé nanacojó ipuráca'alo —que Jesús quemacá ra'apiyatéjenajlo. ");
INSERT INTO ycn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","E caja ilerú inanaru iphayo piño rejo pajimila eruna hua'até. Ru'umá riyucuna najló. Raú cajrú pajimila eyájena i'ijnaño rujhua'até Jesús ejo. Nahue'epí Tupana huacára'aca Jesús i'imacá, rumacale najló: “Piyuque nuyucuno ri'imichá nojló i'imichaca” que. Caja nephá Jesús nacú. E nemá rijló: —Piyuró huajhua'até maare. Aú ripa'ó najhua'até; riyuró najhua'até iyamá cala quetana. ");
INSERT INTO ycn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ri'imá najló Tupana puráca'alo yucuna. Ehuá cajruca hue'epiño Tupana huacára'acare ri'imacá. Ripuráca'alo huani jema'acana aú nahue'epí ricá ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","E nemá ilerú inanárujlo: —Pi'imacale aú huajló riyucuna, huahue'epí Tupana huacára'aca ricá majó. Chuhua uncá raú ja calé huahue'epica ricá. Caja huemi'ichá ripura'acó Tupana nacú. Caja huahue'epicha ricá huani Tupana huacára'acare majó eja'ahuá chojé i'imacá, ri'imatácaloje ina'uqué capichácajo liyá penaje —que nemacá rojló. ");
INSERT INTO ycn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iyamá cala i'imajemi Jesús jácho'oro Samaria te'eré eyá. Ra'apá ají que yenojo Galilea te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Uncá riyurilo rite'eré ehuá i'imacá, uncale nephala ra'apí rehuá. Rimá rinacuhuá marí que: “Tupana puráca'alo ja'apátajeri te'eré eruna uncá iphálaño ra'apí.” Aú calé uncá riyurilo rehuá. ");
INSERT INTO ycn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","E caja riphá Galilea te'eré ejo. Namaca aú ricá palá napechu i'imacá rinacu, nanaquiyana amána'apa ri'imacale. Jerusalén e na'apátaca fiesta huacajé namá rila'acá ina'uqué e'iyayá cajrú nacaje, uncá meño'ojó iná la'alare. ");
INSERT INTO ycn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Caja Jesús iphari rejo. Richira'ó ají que nate'eré e'iyohuá. Tajnaro pajimila Caná ejé. Re riqueño'óta júpimi que juni cajmú caje jalá amúra'atacanami que caja penaje i'imacá. Rejé riphá. Ya'ajná quemachi re apú pajimila, rií Capernaum. Re pajluhua ina'uqué i'imari. Ne'emacana hua'até sápajeri ri'imacá. Ritami ri'irí i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","E caja yucu i'imari: “Jesús jácho'ocharo Judea te'eré eyá. Iphíchari huajé majó Galilea te'eré nacojé”. Rema'acá aú riyucuna ri'ijná ají que Jesús amaje. Riphá rinacu; rajalaca ricá. E rimá rijló: —Aquíchaje huani nu'urí. Yehuíchaja huani ripechu capichaco. Pila'á nojló nacaje. Pi'ijná nujhua'até, pitejmo'óchiyachi nojló ricá —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aú Jesús quemari rijló: —Uncá ipechu i'imalá nochojé caphí, uncájica ee amá nacaje nula'acare, uncá meño'ojó ina'uqué la'alare caje. ¿Que chi ricá? —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Raú ne'emacana hua'até sápajeri quemari rijló: —Quiñaja pi'ijnacá nujhua'até, nu'urí pechu capichaco piyá. ");
INSERT INTO ycn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús quemari rijló: —Pipa'ó piñacaré ejo. Caja chuhua peyajhueni pi'irí. Rema'á ra'apiyá. Aú caja ripa'ó ají que riñacaré ejo. ");
INSERT INTO ycn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Rijhua'até sápajeño amaca aú ricá huaíchaca ne'ejná rijimaje. Nephácaco pajimájechaca rijhua'até. E nemá rijló: —Caja pi'irí tejmo'otaro. ");
INSERT INTO ycn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aú rimá najló: —¿Méreje chami camú to'ocó ee ritejmo'otó i'imacá? Nemá rijló: —Lalemi, huajé camú to'ocó ee, jelo'ocajo ja'apari riliyá. ");
INSERT INTO ycn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Raú rihue'epí pajñacani ritejmo'otaco Jesús quemacá aú: “Caja chuhua peyajhueni pi'irí” que. Ritejmo'ótacale ri'irí ya'ajnaya, caphí ripechu i'imacá Jesucristo chojé. Ñaqué caja riyajalo, riyani, quele pechu i'imacá caphí richojé. ");
INSERT INTO ycn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Marí que ritejmo'ótaca ri'irí i'imacá. Raú rila'á piño nacaje uncá meño'ojó iná la'alare. Iyamá pe rila'acá nacaje uncá meño'ojó ina'uqué la'alare Galilea te'eré ejo riphaca ejomi. Judea te'eré eyá ri'ijná rejo i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Judíona la'añó fiesta Jerusalén e i'imacá. Raú Jesús pa'aró rejo. ");
INSERT INTO ycn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pajimila nacú corral jipa naquiyá la'acanami chipúca'ari. Rinumaná i'imari cha'apá. Re apú rinumaná i'imari nemaqué nacú: “Ohuéjana le'ejé ricá.” Rahua'á juni yá'aro, rií Betesda. Marí que na'acá rií napura'acó chu, hebreo pura'acó chu. Juni cha pají yá'aro. Jipa naquiyá la'acanami ri'imacá. Pajluhua té'ela quele juni tujré i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Juni turená nacú cajrú natámina pitacó. Que'iyapejena ne'emacá. Ne'iyajena i'imaño mejluruna; ne'iyajena uncá meño'ojó ja'apálaño palá; ne'iyajénajlo nanapona taca'átaro. Re juni turená natámina pitacó. Juni yoco'ocó nahuátaque, ri'imajícale marí que: ");
INSERT INTO ycn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Apala, apala queja juni yoco'ocó. Tupana hua'atéjeri, je'echú chiyaje, huitúca'aqueri rejo juni yoco'ótaje. Pajluhua natámina naquiyana huitúca'aqueri racojé ajopana piyá riyoco'ocó quetana, riyo'ocola tejmo'ótari ricá riyaripune liyá. ");
INSERT INTO ycn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Re ne'iyá apú ritami i'imari. Treinta y ocho quele jarechí quetana ri'imacá ritami. ");
INSERT INTO ycn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","E caja Jesús iphari rejo, amari rito'ocó re. Rihue'epí júpicha huani ri'imacá ritami caje hua'até. Aú rimá rijló: —¿E pihuátaca tejmo'otácajo? ");
INSERT INTO ycn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aú ritami quemari Jesusjlo: —A'a. E'iyonaja uncá na i'imalá, rihuitúca'atacaloje nucá juni acojé riyoco'ocó quetana penaje. Nuhuitúca'ajla racojé. E'iyonaja quiñaja apú huitúca'aca racojé nupiyá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús quemari rijló: —Pácho'o; pa'apachi; pijña'á picamané pijhua'ató. ");
INSERT INTO ycn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ejéchami ritami caje ja'apaca riliyá. Raú rácho'o; rijña'á ricamané rijhua'ató; ra'apá reyá. Nale'ejé huatána'acaje huacajé i'imari rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","E judíona quemaño ritami penájemijlo: —¿Uncá chi pema'alá Tupana ja'apiyá? Chuhuajá huatána'acaje huacajé. E'iyonaja pijña'á picamané. ");
INSERT INTO ycn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","E rimá najló: —Tejmo'óchiyari nucá quemíchari nojló: “Pa'apá, pijña'á picamané pijhua'ató” que. ");
INSERT INTO ycn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nemá rijló: —¿Na ta chi quemíchari pijló ilé que? ");
INSERT INTO ycn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Uncá ra'ajipalá najló. Uncá rihue'epila naca tejmo'ótaca ricá, cajrú ina'uqué e'iyohuá ri'imacale. Jesús ja'apíchami, aú uncá ramala ricá ne'iyohuá. ");
INSERT INTO ycn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Quéchami Jesús iphácaco ricá penájemi hua'até Tupana ñacaré chu. E rimá rijló: —Pamá, caja pitejmo'ochiyo. Chuhua caja peyajhueni picá. Maare eyá huatucumó pila'aniya piño nacaje uncá Tupana huátalare caje. Pila'ajica ee nacaje uncá rihuátalare caje, richaje huani pila'ajico chapú reyá a'ajná ño'ojó —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eyá ricá penájemi i'ijnari riyucuna i'imajé judíona naquiyánajlo. Rimá najló: —Jesús, ricá tejmo'óchiyari nucá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Marí caje aú judíona naquiyana huátaño Jesús la'acana chapú, ritejmo'ótacale ritami nale'ejé huatána'acaje huacajé. ");
INSERT INTO ycn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Raú ne'ejná riyucuna quejá'aje Jesús liyá. Jesús quemari najló: —Nora'apá la'arí nacaje palani. Ñaquele nucá caja la'arí nacaje ñaqué caja —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Marí que rimacá aú richaje nayúcha'aco richá. Iqui'i nahuátaca rinócana i'imacá. Uncá paala najló ri'imacá, ritejmo'ótacale ina'uqué nale'ejé huatána'acaje huacajé. Chapú huani caja ri'imacá nanacu, rimacale Tupana nacú: “Nora'apá ricá” que. Marí que quemacana aú rila'á ricó Tupana queja caja. ");
INSERT INTO ycn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","E caja Jesús quemari najló: —Jema'á marí: Nucá, Ri'irí, uncá meño'ojó nula'alá nacaje nocó. Nora'apá ja'apiyá que nula'acá nacaje. Rila'acá nacaje, que caja nula'acá. ");
INSERT INTO ycn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nora'apá huajhué nucá. Ñaquele rimá nojló nacaje nacú, nuhue'epícaloje rila'acana nacojé penaje. Rimaje piño nojló nacaje nacú, nula'acáloje penaje. Apú nacaje nula'acare chaje ri'imajica. Marí que ipechu i'imajica nunacu raú: “Meque piyuque huani la'ajeri ricá” que. ");
INSERT INTO ycn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nora'apá hue'epiri ina'uqué caja taca'acaño macápo'otacana. Nucá, Ri'irí, hue'epiri ñaqué caja cajmuchaji a'acana nuhuátacarenajlo. ");
INSERT INTO ycn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Uncá Tupana calé quemajeri ina'uqué nacú mecajenaca necá: palá la'acaño ca'ajná, pu'uhuaré la'acaño ca'ajná. Caja ra'á nucá, numacáloje nanacu mecajenaca necá penaje. ");
INSERT INTO ycn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Marí penaje ra'á nu'umacá, piyuque ina'uqué pechu i'imacáloje nunacu palá penaje. Nora'apá nacú napechu i'imacá, que caja napechu i'imacáloje nunacu penaje ra'á nu'umacá. Uncachu ina'uqué pechu i'imalá palá nunacu, uncá caja napechu i'imalaje palá Tupana nacú. Ricá huacára'ari nucá majó i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Jema'á marí: A'ajeño nanacojó nupuráca'alo i'imajeño matajnaco je'echú chu. Nuhuacára'ajeri Tupana. Caphí richojé péchuruna i'imajeño matajnaco re. Marí que ri'imajica ee ijló, uncá Tupana huajálaje icá. Caphí Tupana chojé péchuruna icá i'imajica ee, icá ja'apájeño capichácajo chiyá cajmuchaji chojé. ");
INSERT INTO ycn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","’Jema'á marí: Tupana I'irí nucá. Caja riphá rená chojé capichájeño penájenajlo, nema'acáloje nupuráca'alo penaje. Ra'apiyá jema'ajéñojlo Tupana a'ajeri huajé cajmuchaji, ne'emacáloje raú hua'ajini huani je'echú chu penaje. ");
INSERT INTO ycn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Inajlo cajmuchaji a'ajeri Nora'apá, Tupana. Rimá caja nunacu ñaqué caja, no'ocáloje ina'uquejlo cajmuchaji penaje, ne'emacáloje matajnaco je'echú chu raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ina'uquéjloje penaje i'imacá nucá. Ñaquele ra'á nucá, numacáloje ina'uqué nacú méqueca ne'emajica. Rihuajaje necá, uncá la'alaño palá. Marí penaje ra'á nu'umacá. ");
INSERT INTO ycn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ipechu i'imaniya nunacu: “Meque piyuque huani péchuri ricá” que. Rihuacajé huaícha caja taca'acaño jema'ajeño nupuráca'alo. ");
INSERT INTO ycn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Palá la'acáñomi chuna macápo'ojeño, ne'emacáloje matajnaco je'echú chu penaje. Pu'uhuaré la'acáñomi chuna macápo'ojeño caja, najña'acáloje chapú caje yajhué panacu penaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesús quemari piño najló: —Uncá nula'alá nacaje nupechu queja. Noma'á Nora'apá ja'apiyá. Rihuacára'aca nucá queja nula'acá nacaje. Palani nacaje nula'acare, uncale nula'alá ricá nupechu queja. Nora'apá huacára'aca queja nula'acá nacaje. Ricá huacára'ari nucá majó i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nocó numaquela nunacuhuá, apala imacajla nunacu: “Uncá quehuaca calé rimacá rinacuhuá”. ");
INSERT INTO ycn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Re apú. Ricá caja quemari nunacu numacá que caja. Raú nuhue'epí quehuácaca ricá. ");
INSERT INTO ycn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Icá huacára'año inaquiyana riyucuna quejá'aje Juan liyá i'imacá. Quehuaca rimacá nunacu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Uncá na penaje calé nojló ina'uqué puráca'alo. E'iyonaja numá ijló marí que, iyurícaloje ichó nojló, nu'umatácaloje icá capichácajo liyá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Palani inajlo iná camaró lucúna'aqueja lapí, ripatacáloje iná camaré palá penaje. Ñaqué caja Juan puráca'alo i'imacá ijló, quehuaca rimacale ijló. Pu'ují ipechu i'imacá ripuráca'alo nacú mequetánaja. ");
INSERT INTO ycn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan i'imari nuyucuna i'imacá. Cajrú ina'uqué jema'añó nuyucuna raú. Richaje íqui'ica nema'acá nuyucuna nacaje nula'acare aú. Nora'apá palamane aú calé nula'á ricá. Raú ina'uqué hue'epiño Nora'apá huacára'aca nucá majó i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nora'apá Tupana huacára'ari nucá majó i'imacá. Ricá caja huacára'ari ajopana lana'acá ina'uquejlo nuyucuna papera chojé i'imacá. Uncá jema'alá Tupana i'imacá yucu ijló; uncá caja amala ricá. ");
INSERT INTO ycn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Uncá caja ripuráca'alo i'imalá ipechu nacú, uncale ipechu i'imalá caphí nochojé. Tupana huacára'acare majó nucá. ");
INSERT INTO ycn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Marí que ipechu Tupana puráca'alo lana'aquéjami nacú: “Tupana puráca'alo quemari inajlo rinacu, méqueca iná la'acajla, iná i'imacáloje hua'ajini huani je'echú chu raú penaje”, que ipechu i'imacá rinacu. Marí que ipechu i'imacale rinacu, icá jehuíña'año Tupana puráca'alo lana'aquéjami nacú cajrú. Tupana puráca'alo, jehuíña'atacare nacú, quemari jo'ó nunacu. ");
INSERT INTO ycn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","E'iyonaja calé uncá i'ijnalá majó nuchaje cajmuchaji chaya, i'imacáloje hua'ajini huani je'echú chu raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Uncá nuculala ajopana ina'uqué, napura'acóloje nunacu palá majopeja penaje. ");
INSERT INTO ycn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nuhue'epí uncá ihuajhué calé Tupana. ");
INSERT INTO ycn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tupana huacára'ari majó nucá ripuráca'alo aú. Aú calé nu'ujná majó. E'iyonaja uncá jema'alá no'opiyá. Apala apú iphájeri majó ripechu queja. Majopeja ripajlájica ca'ajná ijhua'até. Ricá ja'apiyá ca'ajná jema'ajé. ");
INSERT INTO ycn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Uncá meño'ojó i'imalá no'opiyá jema'ajeño, ihuátacale ina'uqué pura'acó inacu palá. Uncá ihuátala napura'acó pu'uhuaré inacu nupuráca'alo jimaje. Uncá ihue'epila itucumó Tupana huátaca que la'acana, rimacáloje inacu palá penaje. Marí que ri'imacale ijló, uncá jema'alá no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ipechu i'imaniya nunacu marí que: “Ricá quemájeri Tupánajlo pu'uhuaré huala'acare nacú, Tupana huajácaloje huecá penaje”. Uncá nucá calé quemájeri inacu. Tupana puráca'alo Moisesmi chu lana'acare i'imacá, chojé ipechu i'imá caphí. E'iyonaja calé uncá ila'alá rihuacára'aca que. Pachá Tupana huajájeri icá. ");
INSERT INTO ycn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Jema'aquela Tupana puráca'alo ja'apiyá, Moisesmi chu lana'acare i'imacá, que caja jema'acajla no'opiyá. Moisesmi chu lana'arí nuyucuna i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Uncaja que jema'á puráca'aloji ja'apiyá Moisesmi chu lana'acare, uncá caja jema'alaje nupuráca'alo ja'apiyá —que Jesús quemacá judíonajlo. ");
INSERT INTO ycn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jesús pura'aró najhua'até i'imacá. Quéchami ricuhuá'aca caesa pa'anajo pitá. Galilea caesa ií. Ricá caja caesa na'á rií Tiberias. ");
INSERT INTO ycn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Cajrú ina'uqué i'ijnacá rápumi chu, namácale rila'acá cajrú nacaje uncá meño'ojó ina'uqué la'alare caje. Cajrú namájicano ritejmo'ótaca ina'uqué natámina i'imajícaño. ");
INSERT INTO ycn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Rihuacajé yehuicha judíona le'ejé fiesta iphaca rená chojé. Jesús cuhuá'ari pa'anajo pitá. E nácho'o yenuri chuhuá, iphaño yenuri i'ihuátaje. Re riyá'o ra'apiyatéjena hua'até. ");
INSERT INTO ycn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","E Jesús pajno'oró riyámojo yacá'ajo, amari cajrú ina'uqué huaíchaca. Yehuicha nephátaca necá, aú rimá rijhua'ateje Felípejlo. —¿Mere eyá huahuarúhua'aje a'ajnejí ileruna huaíchañojlo penaje? ");
INSERT INTO ycn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Marí que rimacá rijló, rema'acáloje méqueca rimacá rijló penaje. Caja Jesús hue'epiri méqueca rila'ajica a'ajnejí najló. ");
INSERT INTO ycn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","E Felipe quemari rijló: —Hue'ejnaquela a'ajnejí huarúhua'aje dos cientos denarios aú, uncá riphálajla piyuque nanacojé, najñácaloje huejápajano rinaquiyana penaje —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Re caja apú ra'apiyateje i'imari re rijhua'até. Rií i'imari Andrés; Pedro e'ehué ri'imacá. E rimá Jesusjlo: ");
INSERT INTO ycn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Re maare pajluhuaja yuhuají. Ricapi pajluhua té'ela ca'alá pan; ricapi caja iyajmela jíñana. Queleja maare. Uncá meño'ojó riphala íqui'iruna ina'uqué nacojé —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús quemari ra'apiyatéjenajlo: —Chuhua imicha najló, nayá'acoloje piyuqueja penaje. Cajrú jimichi palá nojé i'imacá rehuá. E piyuqueja nayá'o re'iyajé. Iqui'iruna ne'emacá. Achiñánaja calé nalapa'atá; cinco mil ca'ajná ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","E Jesús ña'arí ricápojo pajluhua té'ela ca'alá pan. Quéchami ripura'acó Tupana hua'até. Rimá rijló: —Palá pili'ichaca huecá marí pan aú. Ejomi ra'á ra'apiyatéjenajlo pan, natamáca'atacaloje ricá piyuque ina'uqué yá'añojlo penaje. Pan rila'acá que caja rila'acá jíñana. E caja najñá ñó'ope na'ajnehuá nahuátaca ejé, namano'ocá ejé. ");
INSERT INTO ycn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Rejomi Jesús quemari ra'apiyatéjenajlo: —Chuhua ihuayo'ochá rijlupemí ilé yurícharo, nacupaca piyá ricá. —Je —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Raú ne'emá rijlupemí huayo'ojé. Namano'otá iyamá iphata ji'imaji nacojé ca'alá cuhuá'ala pu'uteno huánija a'ajnejí lupemí aú. ");
INSERT INTO ycn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Caja namá riqueño'ótaca a'ajnejí i'imacá. Raú rila'á nacaje uncá meño'ojó ina'uqué la'alare caje. Marí que rila'acá ejomi nemá pajlocaca: —Tupana puráca'alo ja'apátajeri jo'ó ricá. Caja queja ri'imacá Tupana pechu nacú, riphácaloje marí eja'ahuá chojé penaje —que nemacá pajlocaca Jesús nacú. ");
INSERT INTO ycn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesús hue'epiri méqueca napechu nacú ri'imacá, na'acáloje ricá tejmuji aú ne'emacana penaje. Raú ri'ijnañáa necá. Rácho'o piño ipuré i'ihuátaje, ri'imacáloje ricoja re penaje. ");
INSERT INTO ycn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","E caja najúhua'a. Raú Jesús ja'apiyatéjena i'ijnaño caesa turenaje. ");
INSERT INTO ycn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Huitúca'año jita chojé. Naqueño'ó caesa cuhuá'acana, nahuata pajimila Capernaum ejo pa'acano. E caja najúhua'a huani caesa chu, na'apá calajerúhuaca. Uncá jo'ó Jesús iphala nanacu rejé i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nacuhuá'aca ee cajrú carená queño'ocá ja'apácaje nachá. Raú cajrú juni yoco'ocó. ");
INSERT INTO ycn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Caja nacuhuá'a cinco quilómetros ca'ajná, seis quilómetros quetana ca'ajná. Ejéchami namaca Jesús huaíchaca majó naloco'opani. Juni jimó richira'ó. Namaca ricá huaíchaca aú naquero'ó. ");
INSERT INTO ycn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Rimá najló: —Iquero'oniyo, Jesús nucá. ");
INSERT INTO ycn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Raú nemá rijló, rihuitúca'acaloje jita chojé natu'ujhuejo penaje. Rihuitúca'a richojé. Hua'ató que nephaca punumaje chojé, nahuátaca i'ijnacana ejo nephá. ");
INSERT INTO ycn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ina'uqué naquiyana yuriño pa'anajo pitá i'imacá. Nahue'epí Jesús ja'apiyatéjena cuhuá'aca jita chuhuá. Caja penaje i'imacá re, ricá chu nacuhuá'a i'imacá. Nahue'epí caja uncá Jesús cuhuá'ala najhua'até i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","E'iyohuá que ajopana ina'uqué iphaca jita chuhuá rejé. Pajimila Tiberias eyájena ne'emacá. Najñaca pan lalemi que ejé nephá. Re Jesús quemari Tupánajlo: “Palá pila'acá huecá pan aú” i'imacá. Ejomi najñá ricá. Rejé nephá. ");
INSERT INTO ycn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Amaño Jesús, ra'apiyatéjena, quele uncá i'imalaño re. Aú nahuitúca'a piño netane chojé, cuhuá'año Capernaum ejo Jesús culaje. ");
INSERT INTO ycn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","E caja nephá caesa pa'anajo pitá. Re nephata Jesús. E nemá rijló: —Huehuíña'atajeri, ¿Méquechami piphíchaca majó? ");
INSERT INTO ycn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús quemari najló: —Numá ijló a'ajnejí chaya i'ijichá majó, ajñácale a'ajnehuá lalemi imano'ocá ejé. Uncá i'ijnalacha majó nuchaje, ihue'epícale naca nucá, la'arí nacaje uncá meño'ojó ina'uqué la'alare caje. Noná que'ená nula'á raú. ");
INSERT INTO ycn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ihue'epíniya itucumajo a'ajnejí ña'acana ijluhua. Majopeja ricapichaco inajlo. Iná ajñá iná a'ajnehuá, iná i'imacáloje raú penaje. A'ajnejí que caja inajlo Tupana Pechu. Tupana quemari nunacu, no'ocáloje Ripechu ina'uquejlo, ne'emacáloje matajnaco je'echú chu raú penaje. Ihue'epí itucumó Tupana Pechu ja'apiyá i'imacana —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nemá piño rijló: —¿Meque iná la'acá, iná la'acáloje Tupana huátaca que penaje? ");
INSERT INTO ycn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Rimá najló: —Tupana huátari ipechu i'imacá caphí nochojé, nu'umatácaloje icá capichácajo liyá penaje. Rihuacára'acare majó nucá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nemá piño rijló: —Pila'á piño huajló nacaje uncá meño'ojó ina'uqué la'alare, huamácaloje penaje, huapechu i'imacáloje caphí pichojé raú penaje. ¿Na ca'ajná pila'ajé piño huajló? ");
INSERT INTO ycn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Hua'ajútayami chuna i'imajica pu'uteni meñaru chu huacajé najñaque a'ajnejí. Rií i'imari maná. “A'ajnejí Tupana huacára'ajicare najló je'echú chiyá ri'imajica”, que Tupana puráca'alo lana'aquéjami quemacá rinacu. Pila'á ñaqué caja huajló, huapechu i'imacáloje pichojé caphí raú penaje —que nemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","E rimá najló: —Numá ijló uncá je'echú chiyaje huani calé a'ajnejí Moisesmi chu a'aqueri najló. Je'echú chiyaje huani a'ajnejí Nora'apá huacára'acare ijló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nucá Tupana huacára'acare majó, a'arí cajmuchaji ina'uquejlo, ne'emacáloje matajnaco je'echú chu raú penaje. Marí caje a'ajnejí Tupana a'arí ina'uquejlo me'etení —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aú nemá rijló: —Hue'emacana, pa'á huajló hue'echú ca'alá queja ilé a'ajnejí pimacare nacú. ");
INSERT INTO ycn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Eyá Jesús quemari najló: —Nucá ilé caje a'ajnejí. Nucaja calé a'arí huajé cajmuchaji ina'uquejlo, ne'emacáloje matajnaco je'echú chu raú penaje. Uncá quehuí calé me'epejí huajé ajñácaño na'ajnehuajlo. Uncá caja huajé que i'iracaño juni núru'upi chu macára'atalo. Ñaqué caja caphí nochojé péchurunajlo nucá. Uncá na i'imalá capuhuini no'opiyá jema'ajéñojlo, napechu i'imacá piyá pu'ují raú. ");
INSERT INTO ycn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Caja numá inacu: “Uncá jema'alaje no'opiyá” que. Caja amá nacaje nula'acare. E'iyonaja calé uncá jema'alá no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tupana a'arí nojló ina'uqué no'opiyá jema'ajeño penaje. Necá jema'añó no'opiyá. Uncá nócho'otalaje necá nule'ejena ina'uqué e'iyayá. ");
INSERT INTO ycn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Uncá nu'ujnalá majó je'echú chiyá, nula'acáloje nuhuátaca que penaje. Nu'ujná majó, nula'acáloje Nuhuacára'ajeri huátaca que penaje. ");
INSERT INTO ycn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nuhuacára'ajeri Tupana. Uncá rihuátala ina'uqué, ra'acárena nojló, capichaco riliyá. Pajluhuaja nanaquiyana, uncá caja rihuátala ricapichaco riliyá. Ñaquele rihuata numacápo'otaca nule'ejena caja taca'acaño i'imacá. Marí que ri'imajica caja penaje eja'ahuá iphájica rená chojé huacajé. ");
INSERT INTO ycn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nora'apá Tupana, huátari piyuqueja ina'uqué hue'epica naca nucá. Rihuata caja napechu i'imacá caphí nochojé. Uncá tajnálajeño penájena cajena ina'uqué je'echú chu. Nucá macápo'otajeri necá, caja taca'acaño, eja'ahuá iphájicaja rená chojé caja penaje huacajé —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","E caja judíona naquiyana queño'oñó rimaná aca'acana, rimacale najló rinacuhuá: “Nucá huitúca'ari je'echú chiyá majó. A'ajnejí queja caja nucá ina'uquejlo.” ");
INSERT INTO ycn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Aú nemá pajlocaca: —¿Uncá chi José i'irí calé ricá Jesús? Huamána'apa rara'apá, raló, quele. ¡Eta, meque rimacá rinacuhuá: “Nucá huitúca'ari je'echú chiyá majó!” —que napura'acó pajhua'atéchaca rinacu. ");
INSERT INTO ycn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","E Jesús quemari najló: —Aca'aniya numaná pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nora'apá calé la'arí ina'uqué pechu palá, nema'acáloje no'opiyá penaje. Necaja calé jema'añó no'opiyá. Eja'ahuá iphájicaja caja penaje rená chojé huacajé numacápo'otaje no'opiyá jema'ajéñomi chuna. ");
INSERT INTO ycn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tupana puráca'alo lana'aquéjami, ricá ripuráca'alo ja'apátajeñomi chuna lana'acare i'imacá, quemari marí que: “Tupana jehuíña'atajeri piyuque ina'uqué”, que rimacá. Ra'apiyá jema'ajeño, ileruna huátaño nucá nahuacára'ajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Uncá na calé amari Tupana. Nucaja calé amari ri'imacá, reyaje nu'umacale. ");
INSERT INTO ycn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jema'á marí: Caphí nochojé i'imacaño i'imajeño matajnaco je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","A'ajnejí palamane ina'uqué i'imaño eja'ahuá chu. A'ajnejí que caja nucá ina'uqué naquiyánajlo. Nupalamane ne'emajica matajnaco je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","A'ajútayami chuna ajñáqueño a'ajnejí, pu'uteni chu ne'emaqué huacajé. Ricá a'ajnejí ií i'imari maná. Uncá ne'emalá matajnaco raú. ");
INSERT INTO ycn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","A'ajnejí numacare nacú ijló iphari je'echú chiyá. Iná huátacachu inajluhua ricá, uncá iná tajnálajo raú je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nucá a'ajnejí, iphácare je'echú chiyá. Cajmuni nucá. Ajñari marí a'ajnejí naquiyana i'imajeri hua'ajini huani je'echú chu. A'ajnejí no'ojícare, nunapona ricá, no'ocare ina'uquéjloje penaje, ne'emacáloje hua'ajini huani raú je'echú chu penaje —que Jesús quemacá najló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Marí que rimacá jimaje judíona naquiyana aca'ácaño pajhua'atéchaca. Ne'iyajena quemaño ajopánajlo. —¿Meque la'ajé chi ra'ájla huajló rinapona naquiyana, huajñácaloje ricá penaje? ");
INSERT INTO ycn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Eyá Jesús quemari piño najló: —Jema'á marí: Ina'uquéjloje penaje i'imacá nucá. Uncá ca'ajná ihuátala nunapona ajñacana. Uncá caja ca'ajná ihuátala nura i'iracana. Marí que ri'imajica ee ijló, uncá cajmuchaji i'imalaje ijló, i'imacáloje hua'ajini huani je'echú chu raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nunapona ajñájeño, nura i'irajeño, i'imajeño matajnaco je'echú chu. Nucá macápo'otajeri ilé cajena taca'acaje chiyá, eja'ahuá capichájico huacajé. ");
INSERT INTO ycn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","A'ajnejí huani nunapona; i'iracaje huani nura. ");
INSERT INTO ycn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Huátaño najluhua ricá, i'imaño nujhuáque'ena. Ñaqué caja najhuáque'ehue nucá. ");
INSERT INTO ycn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nora'apá huacára'ari nucá majó i'imacá. Uncá tajnácajo penaje calé Nora'apá. Ricá a'arí nojló cajmuchaji; ripalamane nucá. Nupalamane piño nunapona ajñájeño, nura i'irajeño, i'imajeño matajnaco je'echú chu. ");
INSERT INTO ycn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","A'ajnejí numacare nacú ijló iphari je'echú chiyá i'imacá. Uncá ilé a'ajnejí que calé ricá, peñahuilánami chuna ajñájicare. Uncá ne'emalá matajnaco raú. Ajñari a'ajnejí numacare nacú, i'imajeri matajnaco je'echú chu —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Marí que Jesús jehuíña'ataca ne'emacá rinacu. Nahuacáca'alo ñacarelana chu, pajimila Capernaum e, rehuíña'ata ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Marí que rehuíña'ataca necá rinacu. Raú cajrú ra'apiyá jema'ajeño quemaño pajlocaca: —¡Meque me'echuje huani caji rimíchaje nacú huajló! Uncá meño'ojó iná a'alare jená palá. Uncá meño'ojó iná a'alá iná nacojó ricá. ");
INSERT INTO ycn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ripechu aú ja Jesús hue'epiri naca'acá rimaná rimacare chona. Raú rimá najló: —¿Uncá paala chi ijló quele numíchaje nacú ijló? ");
INSERT INTO ycn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Piyuque ina'uquéjloje penaje i'imacá nucá. ¿Meque ca'ajná ipechu la'acojla, amáquela nucá jácho'ocojla je'echú chojé, nu'umacáloje júpimi nu'umacá ejo penaje? ");
INSERT INTO ycn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tupana Pechu a'arí cajmuchaji inajlo, iná i'imacáloje hua'ajini huani ripalamane je'echú chu penaje. Apú napona ajñacana uncá a'alá cajmuchaji inajlo, iná i'imacáloje matajnaco raú penaje. Ipechu i'imacáloje palá nochojé, penaje nupuráca'alo. I'imacáloje matajnaco je'echú chu raú penaje ricá. ");
INSERT INTO ycn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Re e'iyajena maare, uncá caphí calé ipechu nochojé —que rimacá najló. Jesús hue'epiri mecajenaca pechu uncá i'imalá richojé caphí. Uncá chiyó nachira'ó rijhua'até rihue'epí mecajenaca ne'emacá. Rihue'epí caja mecajeca a'ajeri ricá ripinánajlo i'imajica. ");
INSERT INTO ycn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Rimá piño najló: —Caja numá ijló i'imacá, uncá na calé jema'arí no'opiyá, uncachu Nora'apá Tupana la'alá napechu palá, nema'acáloje no'opiyá raú penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Rejeja cajrú ra'apiyá jema'ajeño yuriño ra'apiyá jema'acana. Reyá a'ajná ño'ojó uncá nachira'aló Jesús hua'até. ");
INSERT INTO ycn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Eyá Jesús quemari iyamá iphata ji'imaji nacojé quele ra'apiyatéjenajlo marí que: —¿Ñaqué caja chi ja'apáñajica nucá? ");
INSERT INTO ycn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Aú Pedro quemari rijló: —Hue'emacana, uncá meño'ojó hue'ejnañáalaja picá, hue'emacáloje apú ina'uqué ja'apiyatéjena penaje. Pipuráca'alo aú huahue'epí méqueca iná la'acá, iná i'imacáloje matajnaco je'echú chu raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Caphí huapechu pichojé. Huahue'epí Tupana huacára'aca picá majó i'imacá. Tupana I'irí huani picá. Ricá uncá tajnácajo penaje calé i'imacá, I'irí picá —que Pedro quemacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús quemari najló: —Nucá i'ihuapari nujluhua icá ajopana ina'uqué e'iyayá. Iyamá iphata ji'imaji nacojé quele icá. E'iyonaja calé re pajluhuaja inaquiyana, Jiñá Chi'ináricana hua'ateje ricá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Rimacare nacú i'imari Judas Iscariote. Apú Simón i'irí ri'imacá. Nenoca Jesús huacajé ricá a'arí ripinánajlo ri'imacá. Iyamá iphata ji'imaji nacojé quele Jesús ja'apiyatéjena naquiyana ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Marí caje ejomi Jesús ja'apari piño Galilea te'eré e'iyohuá. Uncá rihuátala Judea te'eré ejo i'ijnacana, judíona naquiyana re i'imacaño, huátacale rinócana. Aú uncá ri'ijnalá rejo. ");
INSERT INTO ycn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Rihuacajé yehuíchaja judíona le'ejé fiesta iphaca rená chojé. Peñahuilánami chuna la'aqueño naca'apé que caja nala'ajícano naca'apó nale'ejé fiesta huacajé. ");
INSERT INTO ycn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ehuá Jesús merénami quemacá Jesusjlo: —Piyuríniyo maare. Pi'ijná chuhua Judea te'eré ejo, pa'apiyá jema'ajeño, rehuájena, amácaloje méqueca pila'ajica nacaje rehuá penaje. ");
INSERT INTO ycn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Iná huátacachu piyuque ina'uqué hue'epica iná la'acare nacojé, uncá micho'ojneji calé iná la'acá ricá. Piyuque hue'epica picá nacaje la'acana. Ñaquele pila'ajé ricá, piyuque ina'uqué amácaloje ricá penaje —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Uncá caja Jesús merénami hue'epílaño na ina'uqueca huani Jesús i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","E Jesús quemari najló: —Uncá jo'ó riphala rená chojé nojló, nu'ujnacáloje rejo penaje. Eyá icá, uncá ñaqué caja calé ijló ricá. Ihuátaca que ila'acá nacaje. ");
INSERT INTO ycn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ina'uqué, uncá jema'alaño Tupana ja'apiyá, ileruna pechu uncá i'imalá chapú inacu. Eyá nucá, napechu i'imacare nacú chapú nucá, numacale nacaje nala'acare nacú: “Uncá paala nala'acá” que. ");
INSERT INTO ycn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ñaquele icaja i'ijnajeño fiesta ja'apátaje. Nucá uncá i'ijnalaje ijhua'até. Uncá jo'ó riphala rená chojé palá nojló —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aú riyuró Galilea te'eré nacú. ");
INSERT INTO ycn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","E caja Jesús merénami i'ijnaño fiesta ja'apátaje. Júpichami Jesús i'ijnacá nápumi chu me'echú. ");
INSERT INTO ycn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fiesta e'iyá judíona naquiyana culaño Jesús i'imacá. Nemá pajlocaca: —¿Mere ca'ajná ricá? ");
INSERT INTO ycn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Cajrú re i'imacaño pura'acó Jesús nacú. Ne'iyajena quemaño rinacu: “Palájne'eque huani ricá.” Ajopana quemaño: “Uncá palájne'eque calé ricá. Majopeja pajlácata ricá ina'uqué hua'até.” ");
INSERT INTO ycn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Palá rinacu péchuruna uncá pura'alaño rinacu cajrú ajopana ina'uqué hua'até, naquero'ocole nahuacára'ajeño judíona piyá. ");
INSERT INTO ycn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pe'iyochami na'apátaca fiesta. Ejéchami Jesús mujlúca'aca Tupana ñacaré chojé. E riqueño'ó nehuíña'atacana Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","E judíona pechu i'imá: “¡Meque piyuque huani rihue'epílaca!” Nemá pajlocaca: —¿Meque la'ajé chi rihue'epica piyuque nacaje nacojé? Uncá ri'imalá jehuíña'ajo. ");
INSERT INTO ycn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús quemari najló: —Nohuíña'atacare nacú icá, uncá nupuráca'alo calé ricá. Ilé huacára'ari nucá majó, puráca'alo ricá. ");
INSERT INTO ycn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tupana huátaca que la'acaño hue'epiño na liyájeca nupuráca'alo. Nahue'epí Tupana liyaje nupuráca'alo. Uncá nule'ejé calé ricá. ");
INSERT INTO ycn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Apú ca'ajná pura'aró ripechu queja, rihuátacale ajopana ina'uqué pechu i'imacá rinacu palá. Eyá rihuacára'ajeri huátaca que pura'ajero, huátari ina'uqué pechu i'imacá palá Rihuacára'ajeri Tupana nacú. Quehuácaje puráca'alori ricá, uncá ripajlala. ");
INSERT INTO ycn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisesmi chu yuriri ijló Tupana puráca'alo lana'aquéjami i'imacá. E'iyonaja uncá na calé jema'arí ra'apiyá —que Jesús quemacá najló. Eyá Jesús quemari piño najló: —¿Naje chi ihuata nonócana? ");
INSERT INTO ycn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aú nemá rijló: —¿Na huátari pinócana? Jiñá pechu pe'iyá, ñaquele pimá ilé que. ");
INSERT INTO ycn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús quemari najló: —Nula'á nacaje palani e'iyá i'imacá. Raú ipechu nacú ri'imá: “¡Meque piyuque huani rila'acá!” Huatána'acaje huacajé nula'á ri'imacá. Pachá ipechu i'imá nunacu chapú. ");
INSERT INTO ycn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisesmi chu quemari júpimi i'imacaño nacú, namata'acáloje queráco'opena chinuma penaje. Icá la'añó ñaqué caja napumí chojé. Moisesmi chu puráca'alomi aú imata'á queráco'opena chinuma. Riphácachu rená chojé huatána'acaje huacajé, imata'á caja nachinuma. ");
INSERT INTO ycn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ila'acáloje Moisesmi chu puráca'alomi quemacá que penaje, imata'á nachinuma huatána'acaje huacajé hua'ató. Eta, ¿Naje iyúcha'o nuchá i'imacá, nutejmo'ótacale ritami huatána'acaje huacajé i'imacá? Piyuque rinapona nutejmo'óta i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Apala amá ina'uqué la'acá nacaje. Ramácana aú ipechu nacú ri'imá ca'ajná: “Pu'uhuaré rila'acá, uncá paala ricá”. Uncachu iná hue'epila palá ricá, uncá iná quemalá rinacu: “Pu'uhuaré rila'acá” que. Pamineco iná quejá'a riyucuna palá, iná hue'epícaloje na penájeca rila'acá ricá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","E caja Jerusalén eyájena naquiyana quemaño ajopánajlo marí que Jesús nacú: —¿Uncá chi ricá calé naculá, nenócaloje ricá penaje? ");
INSERT INTO ycn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","E'iyonaja maare ta ricá. Cajrú ina'uqué e'iyá ri'imá yucu huajló. Uncá meque huahuacára'ajeño la'alá ricá. Napechu i'imá ca'ajná rinacu: “Ricá Tupana huacára'acare majó ina'uqué i'imatájeri penaje ricá”, que ca'ajná napechu rinacu. ");
INSERT INTO ycn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","E'iyonaja uncá ñaqué calé ricá. Huahue'epí mere eyájeca ricá. Eyá ricá Tupana huacára'ajicare majó ina'uqué i'imatájeri penaje, uncá iná hue'epílaje mere eyájeca ri'imajica —que napura'acó pajhua'atéchaca rinacu. ");
INSERT INTO ycn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tupana ñacaré chu Jesús i'imari ina'uqué jehuíña'atacana nacú. Rema'acá aú napura'acó rinacu, rimá najló caphí marí que: —Ipechu i'imá nunacu: “Huamána'apa japi ricá” que. “Huahue'epí mere eyájeca ricá”, que ipechu i'imacá nunacu. Uncá nupechu queja calé nu'ujnacá majó. Pajluhuaja chuhuá péchuri, ricá huacára'ari nucá majó. Quehuácaje puráca'aloji chuhuá rila'acá nacaje. Uncá ihue'epila naca ricá. ");
INSERT INTO ycn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nucá amari ricá, reyá nócho'o i'imacá. Ricá huacára'ari nucá majó i'imacá —que Jesús quemacá najló, nahue'epícaloje raú Tupana huacára'acare majó ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Raú nahuata Jesús ña'acana, nahuajácaloje ricá penaje. E'iyonaja uncá na calé patarí ricá. Uncá jo'ó riphala rená chojé rijló. Ñaquele uncá nala'alajla ricá chapú rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Cajrú ina'uqué pechu i'imá Jesús nacú marí que: “Ricá Tupana huacára'acare majó ina'uqué i'imatájeri penaje ricá. Uncá na chá'atalajla ricá nacaje la'acana aú. Caja ra'á palá huajló rená que'ená, huahue'epícaloje ricá raú penaje,” que napechu i'imacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariséona naquiyana jema'añó napura'acó pajhua'atéchaca Jesús nacú. Palá napura'acó rinacu. Aú necá, sacerdótena huacára'ajeño, quele huacára'año policíana patacá Jesús, naca'acáloje ricá calajeruni chojé penaje. E ne'ejná ri'imacá ejo. ");
INSERT INTO ycn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Re ri'imá ina'uqué jehuíña'atacana nacú. Marí que rimacá piyuque ina'uquejlo: —Mequetánaja calé nu'umajica ijhua'até maárohua. Quéchami nupa'ajico Nuhuacára'ajeri ejo. ");
INSERT INTO ycn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Rejomi iculaje nucá. Uncá meño'ojó amálaje nucá, uncale i'ijnalaje nu'umajica ejo —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Raú judíona naquiyana quemaño pajlocaca: —¿Meño'ojó ca'ajná ri'ijnajé, rimá nacú huajló? Apala ri'ijnajé huanaquiyana judíona chaje, ajopana te'eré nacú i'imacaño ejo. Rejo ca'ajná ri'ijnajé, rehuíña'atacaloje necá penaje. ");
INSERT INTO ycn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Rimicha huanacu: “Iculaje nucá. E'iyonaja uncá meño'ojó amálaje nucá, uncale i'ijnalaje nu'umajica ejo.” ¿Meque quemacana ca'ajná rimíchaca marí que i'imichaca? —que nemacá pajlocaca. ");
INSERT INTO ycn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yehuicha fiesta tajnaco huacajé nala'á cajrú huani fiesta caja penaje. Ehuá Jesús jácho'oco najimaje. E caphí rimacá najló: —Re ca'ajná e'iyajena maare, huátaño cajmuchaji ja'apiyá i'imacana, i'imacáloje matajnaco je'echú chu raú penaje. Inúru'upi chu macára'ataco aú ihuata juni i'iracana. Que caja ihuátajica ee cajmuchaji ja'apiyá i'imacana, i'ijná majó nuchaje, no'ochí ijló ricá. ");
INSERT INTO ycn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Caphí nochojé péchuruna e'iyá re cajmuchaji, juni amo'oquelana uncá tajnalo que ricá najló. Raú caphí nochojé péchuruna i'imajica matajnaco je'echú chu. Marí que Tupana puráca'alo lana'aquéjami quemacá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tupana Pechu nacú rimá najló i'imacá. Caphí Jesucristo chojé péchurunajlo Tupana a'arí Ripechu. Jesús i'imacá riyucuna najló huacajé, uncá jo'ó ra'alá ina'uquejlo Ripechu i'imacá. Jesucristo jácho'oro je'echú chojé yámijo riqueño'ó Ripechu a'acana caphí Jesucristo chojé péchurunajlo. ");
INSERT INTO ycn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ripuráca'alo jema'ajeño naquiyana quemaño marí que Jesús nacú: —Tupana puráca'alo ja'apátajeri ricá, peñahuilánami chuna quemájicare nacú: “Huaícha majó” que. Ricá penaje ricá. ");
INSERT INTO ycn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ajopana quemaño marí que rinacu: —Tupana huacára'ari ricá majó, ri'imatácaloje ina'uqué capichácajo liyá penaje. Ajopana piño quemaño rinacu: —¿Uncá ca'ajná Tupana huacára'acare majó ina'uqué i'imatájeri penaje calé ricá. Galilea eyaje ricá, quele nemá nacú. Aú huahue'epí uncá ricá calé ricá, ina'uqué i'imatájeri penaje. ");
INSERT INTO ycn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Marí que Tupana puráca'alo lana'aquéjami quemacá rinacu: “Davidmi chu laquénami naquiyana ri'imajica. Pajimila Belén eyaje ri'imajica. Ricá caja pajimila eyaje Davidmi chu i'imacá”, que ripuráca'alo lana'aquéjami quemacá rinacu —que nemacá najló rinacu. ");
INSERT INTO ycn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Uncá rejenohuaja calé napechu i'imacá pajhua'atéchaca. ");
INSERT INTO ycn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ne'iyajena huátaño Jesús ña'acana, naca'acáloje ricá calajeruni chojé penaje. E'iyonaja uncá na calé ña'arí ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","E caja policíana pa'añó piño napumí chuhuá. Fariséona, sacerdótena huacára'ajeño, quele huacára'año ne'emacá, napatacáloje Jesús penaje, naca'acáloje ricá calajeruni chojé penaje. Nephá nanacu i'imacá. Uncá Jesús i'imalá najhua'até. Aú nemá najló: —¿Naje chi ipi'ichó majó majopeja? Uncá ijña'alacha majó Jesús. ");
INSERT INTO ycn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aú policíana quemaño najló: —Uncá huahuátala rihuá'acana, palá rehuíña'atacale ina'uqué. Uncá na i'imalá ñaqué palá pura'acó, palá ripura'acó que —que nemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Eyá fariséona quemaño najló: —¿Ñaqué caja chi jema'acá pajlácachi ja'apiyá ajopana jema'acá que caja? ");
INSERT INTO ycn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Uncá huahuacára'ajeño naquiyana, fariséona naquiyana, quele jema'alaño ilé ta ja'apiyá. ");
INSERT INTO ycn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Uncá hue'epílaño Tupana puráca'alo lana'aquéjami quemacá que, necaja calé jema'añó ra'apiyá. Tupana huajájeri necá, uncá pachá nahue'epila méqueca ripuráca'alo quemacá —que nemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo i'imari caja najhua'até. Fariséona naquiyana ri'imacá. Ricá i'imari Jesús chaje lapí júpimi que. Penájemi i'imari najhua'até, napura'acóloje Jesús huajácana nacú penaje. E rimá ajopánajlo: ");
INSERT INTO ycn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Uncá paala huahuajácajla apú majopeja, uncachu huahue'epila na aú ca rila'acá rijluhua pu'uhuaré. Uncá caja huahuajala ricá, uncájica ee huayurí ripura'acó richayo pamineco. Marí que hue'emacana puráca'alo lana'aquéjami quemacá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aú nemá rijló: —Galilea eyájena pechu que pipechu ta. Majopeja i'imacaño i'imaño rehuá. Eco pehuíña'o Tupana puráca'alo lana'aquéjami nacú. Raú pihue'epeje méqueca rinacojé. Uncá Tupana puráca'alo ja'apátajeri i'imalajla Galilea eyaje —que nemacá Nicodémojlo. ");
INSERT INTO ycn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","E caja pajluhuano que napa'acó nañacaré chojé. ");
INSERT INTO ycn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús i'ijnari ají que a'ajná ño'ojó yenuri Olivos ejo. ");
INSERT INTO ycn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","E muní que lapiyami Jesús pa'aró Tupana ñacaré ejo. Piyuque ina'uqué re i'imacaño jahuacaño rejé richaje. E riyá'o, riqueño'ó nehuíña'atacana Tupana nacú. ");
INSERT INTO ycn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ehuá Tupana nacú jehuíña'atajeño, fariséona, quele huá'año pajluhuájaru inanaru ina'uqué e'iyajó. Caluyo ru'umacá. E'iyonaja nephata ru'umacá rujlapu hua'até la'acana nacú. ");
INSERT INTO ycn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","E nemá Jesusjlo: —Huehuíña'atajeri, marirú inanaru ta caluyo rucá. Huajé huamíchaca rula'acá rujlapu hua'até. ");
INSERT INTO ycn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisesmi chu puráca'alo lana'aquéjami quemari huanacu, huenócaloje ñaqué la'ajeño jipa ca'acana nachá aú penaje. Marí que Moisesmi chu puráca'alo lana'aquéjami huacára'aca huecá. Eyá pijló ta, ¿Meque rinacojé? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Majopeja nemacá rijló, namácaloje méqueca rimacá raú penaje. Napechu i'imá: “Apala rimaje apojó huajló.” Aú nemajla rinacu: “Pu'uhuaré ripura'acó” que, narucátacaloje ricá nahuacára'ajeñojlo penaje. E caja Jesús acúhua'aro. Riqueño'ó lana'acaje te'erí jimá riyatehuana aú. ");
INSERT INTO ycn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pulapé nemacá ñaqué huani rijló. Aú rácho'o tára'ajo pu'ucú, rimá najló: —Re ca'ajná pajluhuaja maare hue'iyá uncá la'alá pu'uhuaré. Uncá caja rihue'epila rimanaicho la'acana. Ricá ca'ajeri ruchá jipa pamineco —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","E racúhua'o piño, te'erí jimá lana'ajé. ");
INSERT INTO ycn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Rimacá aú najló marí que nahue'epí méqueca nala'acá chapú ajopana. Namanaicho nala'acare i'imacá iphari napechu nacojé. Raú naqueño'ó pa'acajo pajluhuano, pajluhuano que. Peñahuilana queño'oñó pa'acajo pamineco. Apú, apú que napa'ataco piyuqueja. Jesusja calé yuriro ricoja ilerú inanaru hua'até. ");
INSERT INTO ycn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ejéchami Jesús jácho'oco piño tára'ajo pu'ucú. E riyacá'o rahua'ó, amari uncá na i'imalá. Rucaja calé ramá. E rimá rojló: —¿Mere necá quemaño pinacu: “Uncá ina'uquélaru rucá” que? ¿Uncá chi na ca'alacha jipa pichá? ");
INSERT INTO ycn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Rumá rijló: —Hue'emacana, uncá na ca'alacha jipa nuchá. Jesús quemari rojló: —Nucá, uncá caja ca'alaje jipa pichá. Chuhua pa'apá. ¡Pema'á! Pila'aniya piño pimanaicho ca'ajnó. ");
INSERT INTO ycn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","E caja Jesús pura'aró piño ajopana ina'uqué hua'até. Rimá najló: —Nucá lamá'atari ina'uqué pechu, nahue'epícaloje palá Tupana nacojé raú penaje. Raú ne'emajé hua'ajini huani je'echú chu —que Jesús quemacá najló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","E faríseona quemaño rijló: —Picá pura'aró pinacuhuaja. Uncá naje calé iná pura'ó ilé que iná nacuhuá. Uncá quehuaca calé quele pimacare pinacuhuá. ");
INSERT INTO ycn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Raú Jesús quemari najló marí que: —Quehuaca jo'ó numacare nunacuhuá. Nupura'ó jo'ó nunacuhuá, nuhue'epícale mere eyájeca nucá. Nuhue'epí caja meño'ojoca nu'ujnajica. Eyá icá, uncá hue'epílaño mere eyájeca nucá. Uncá caja ihue'epila meño'ojoca nu'ujnajica. ");
INSERT INTO ycn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Icá quemaño ajopana ina'uqué nacú ipechu queja, uncá ihue'epila palá. Eyá nucá, uncá ñaqué calé numacá majopeja nacaje ina'uqué la'acare nacú. ");
INSERT INTO ycn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Numacachu ina'uqué nacú mecajenaca necá, numacá que necá. Uncá numalá nupechu queja nanacu. Nora'apá huacára'ari nucá majó i'imacá. Ricá hua'até huemacá ñaqueja caja nacaje nacú. ");
INSERT INTO ycn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moisesmi chu puráca'alo lana'aquéjami quemari marí que: “Ñaqué caja iyamá ina'uqué quemacachu nacaje nacú, iná jema'á napuráca'alo ja'apiyá”, que rimacá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Iyamá huecá quemaño ñaqué nunacu. Nucá quemari nunacuhuá mere eyájeca nucá. Nora'apá quemari ñaqueja caja nunacu. Ricá huacára'ari nucá majó i'imacá —que Jesús quemacá najló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Eyá nemá rijló: —¿Mere chi para'apá? Jesús quemari najló: —Uncá ihue'epila na ina'uqueca nucá. Uncá caja ihue'epila naca Nora'apá. Ihue'epíquela na ina'uqueca nucá, ñaqué caja ihue'epícajla naca Nora'apá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Marí que Jesús jehuíña'ataca necá Tupana ñacaré chu. Pu'uhuacá riyá'aco caichama ahua'á, nalamá'atacare chojé liñeru ahua'á. E'iyonaja uncá na calé patarí ricá, naca'acáloje ricá calajeruni chojé penaje. Uncá jo'ó que riphala rená chojé rijló, ritaca'acáloje ina'uqué chaya penaje. Aú calé uncá meño'ojó nala'alá ricá chapú. ");
INSERT INTO ycn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","E caja Jesús quemari piño najló marí que: —Nu'ujnajica maare eyá, ejomi iculaje nucá. Uncá amálaje nucá. Pu'uhuaré ila'acare hua'atoja icapichajo. Uncá ichaje amácano i'imalaje. Nu'ujnajica ejo, uncá meño'ojó i'ijnalaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Raú judíona naquiyana quemaño pajlocaca: —Apala rinójica ca'ajná ricó. Ñaquele rimá huanacu, uncá meño'ojó hue'ejnalaje ri'ijnajica ejo. ");
INSERT INTO ycn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús quemari piño najló: —Maárohua cahuacájena naquiyana icá. Je'echú chiyaje nucá. Marí eja'ahuá chujena icá. Eyá nucá, uncá marí eja'ahuá chujena naquiyana calé nucá. ");
INSERT INTO ycn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ñaqué i'imacale numá inacu: Uncá ichaje amácano i'imalaje pu'uhuaré ila'acare liyá, uncale jema'alá no'opiyá numacare nunacuhuá. Pachá icapichajo pu'uhuaré ila'acare hua'atoja —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Raú nemá rijló: —¿Na ina'uqueca picá? Jesús quemari najló: —Caja numá ijló. Nuqueño'ocá jehuíña'atacana huacajé numá nunacuhuá ijló. ");
INSERT INTO ycn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Re cajrú nacaje numacáloje rinacu penaje, ihue'epícaloje pu'uhuaré ila'acare nacojé raú penaje. Huacára'ari nucá majó quemari quehuácaje puráca'aloji nacú. Noma'á ra'apiyá puráca'aloji no'opátacare ina'uquejlo —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tupana, Rara'apá nacú rimacá najló. E'iyonaja uncá judíona hue'epílaño na nacuca rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ñaquele Jesús quemari najló: —Ina'uquéjloje penaje i'imacá nucá. Acúhua'atajica ee nucá a'ahuaná apiyácacanami nacojé, ihue'epeje na ina'uqueca nucá. Ihue'epeje caja uncá nula'alá nuhuátaca queja. Ihue'epeje caja Nora'apá huacára'aca que numacá nacaje nacú. ");
INSERT INTO ycn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Huacára'ari nucá majó i'imacá, nujhua'até caja ricá. Uncá Nora'apá yurila nocó huani nucá, nula'acale hua'ajini huani nacaje rihuátaca que —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Marí que rimacá aú cajrú ina'uqué jema'acá ra'apiyá. ");
INSERT INTO ycn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Caja ne'iyajena jema'añó ra'apiyá, judíona ne'emacá. E rimá ra'apiyá jema'ajéñojlo marí que: —Uncaja que iyurí nupuráca'alo a'acana inacojó, nujhua'atéjena jo'ó icá. ");
INSERT INTO ycn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ihue'epí méqueca quehuácaje puráca'aloji quemacá, raú Tupana a'ajeri iñaté, i'imacá piyá pu'uhuaré la'acana nacú. Raú i'imajó pu'uhuaré la'acaño huacára'ajeri liyá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Eyá ajopana piño quemaño rijló: —Abrahami chu laquénami huecá. Uncá na calé huahuacára'ajeri. Eta, ¿meque pimacá huanacu, hue'emacóloje pu'uhuaré la'ajeño huacára'ajeri liyá penaje? ");
INSERT INTO ycn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús quemari najló: —Jema'á marí: Namanaicho yá jema'ajéñojlo marí la'ajeño, pu'uhuaré la'ajeño, necá la'añó nahuacára'ajeri huátaca que. Ricapi necá. Mahuemiru nacarihuate hua'até sápajeño que caja necá. ");
INSERT INTO ycn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sápari mahuemiru ricarihuate hua'até, uncá yurílajo hua'ajini huani riñacaré chu rijhua'até. Ri'irija calé yuréjero ra'apiyá hua'ajini huani rejena hua'até. ");
INSERT INTO ycn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ñaqué caja nojló ricá. Tupana I'irí nucá. Nu'umatájica ee icá ihuacára'ajeri liyá, uncá i'imalaje rijhua'atéjena. Raú uncá ila'alaje pu'uhuaré rihuátaca que reyá a'ajná no'ojó. Tupana yaní i'imajé raú. ");
INSERT INTO ycn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Caja nuhue'epí Abrahami chu laquénamica icá. E'iyonaja ihuata nonócana, uncale ihuátala nupuráca'alo a'acana inacojó. ");
INSERT INTO ycn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nora'apá huacára'aca que numacá ijló nacaje nacú. Ñaqué caja imacá nacaje nacú jara'apá huacára'aca que caja —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Raú nemá rijló: —Abrahami chu i'imari huajló huara'apá que. Rilaquénami huecá. Jesús quemari najló: —Abrahami chu naquiyánami i'imaquela, ila'ájla rila'ajica que caja. ");
INSERT INTO ycn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Quehuaca numacá ijló: Ripuráca'alo noma'acare Tupana ja'apiyá, ricá no'opata ijló. E'iyonaja ihuata nonócana. Uncá huani Abrahami chu la'aqué ilé que huani. ");
INSERT INTO ycn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Re apú jara'apá. Ricá la'arí nacaje, ñaqué caja i'ijnataca rápumi chu ricá —que Jesús quemacá najló. Nemá rijló: —Huecá hue'epiño naca huara'apá, uncá majopeja mano'ocaño yaní que calé huecá. Cahue'epícanami huara'apá, Tupana ricá —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Eyá Jesús quemari najló: —Tupana i'imaquela jara'apá, ihuátajla nucá íqui'ija. Tupana i'imacá eyá nu'ujná majó i'imacá. Ñaquele maare nucá me'etení. Uncá nu'ujnalá majó nupechu queja; Tupánaja calé huacára'ari nucá majó i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Uncá meño'ojó jema'alá numacare nacú ijló, uncá ihuátala nupuráca'alo jema'acana. Ñaquele uncá jema'alá ricá. ");
INSERT INTO ycn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jiñá Chi'ináricana, ricá jara'apá. Rijhua'atéjena icá. Ripechu nacú que caja ila'acá nacaje. Ina'uqué nójeri ricá, Jiñá Chi'ináricana. Caja queja ri'imacá riqueño'ocó huacajé. Uncá riyahua'achilo quehuácaje puráca'aloji hua'até. Uncá huani rimalá quehuácaje puráca'aloji nacú. Ripura'acochu, majopeja ripajlaca, ri'imacale richuhuájeja pajlácachi. Pajlácachina jara'apá huani ricá; pajlácachina huacára'ajeri caja ricá. ");
INSERT INTO ycn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Quehuaca numacale ijló, uncá jema'alá no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Uncá pu'uhuaré la'ajeri calé nucá. Aú calé uncá na inaquiyana i'imalá maare, amari nula'acá pu'uhuaré. Quehuaca numacá ijló. ¿Naje uncá jema'alá no'opiyá? ");
INSERT INTO ycn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tupana hua'atéjena jema'añó Tupana puráca'alo ja'apiyá. Uncá Tupana hua'atéjena calé icá. Ñaqué i'imacale uncá ihuátala ra'apiyá jema'acana —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Eyá judíona naquiyana quemaño Jesusjlo: —Huemá pinacu i'imacá: “Samaria eyaje ricá. Jiñá pechu i'imacare e'iyá ricá”, que huemacá pinacu i'imacá. Quehuaca jo'ó huemacá pinacu. ");
INSERT INTO ycn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús quemari najló: —Uncá jiñá pechu i'imalá no'iyá. Nula'á nacaje, ina'uqué pechu i'imacáloje palá Tupana nacú raú penaje. E'iyonaja calé chapú ipechu nunacu. ");
INSERT INTO ycn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Uncá nucá calé quemari ina'uqué nacú, napechu i'imacáloje nunacu palá penaje. Re ricá apú, quemari nunacu. Ricá caja quemájeri ina'uqué nacú mecajenaca rijló necá. Nanaquiyana i'imajeño rijhua'até. Eyá ajopana rihuajaje. ");
INSERT INTO ycn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jema'á marí: Uncá tajnácajo penájena calé nupuráca'alo ja'apiyá jema'ajeño i'imajica. ");
INSERT INTO ycn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Marí caje aú judíona naquiyana quemaño rijló: —Quehuaca huani huahue'epica jiñá pechu pe'iyá. Abrahami chu tajnaro i'imacá. Piyuqueja Tupana puráca'alo ja'apátajeñomi chuna taca'ataño caja i'imacá. Eyá picá ta quemari pipuráca'alo nanacojó a'ajeño nacú: “Uncá tajnácajo penájena calé necá” que. ");
INSERT INTO ycn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ajopana chaje huani Abrahami chu i'imacá. Ricá tajnaro i'imacá. ¿Abrahami chu chaje huani chi picá? Ñaqué caja Tupana puráca'alo ja'apátajeñomi chuna tajnátaco piyuque i'imacá. ¿Meque ca'ajná pipechu pinacuhuá? —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aú rimá najló: —Nocó numaquela nunacuhuá palá, uncá na penaje calé ricá ijló. Icá quemaño Nora'apá nacú: “Huachi'ináricana ricá”. Ricá caja quemari nunacu palá. ");
INSERT INTO ycn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Uncá ihue'epila naca Tupana. Nucá calé amari ri'imacá. Numaquela rinacu: “Uncá nomálare ricá” que, pajlácachina naquiyana nu'umacajla icá que caja. Quehuaca, nucá amari ri'imacá. No'ó nunacojó nacaje rimacare nacú. ");
INSERT INTO ycn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A'ajútami chu, Abrahami chu, hue'epiri eja'ahuá chojé iphájeri penaje nu'umacá. Raú pu'ují ripechu i'imacá, rihue'epícale marí que ri'imajica. Ñaquele pu'ují huani ripechu i'imacá raú —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Judíona quemaño piño rijló: —Uncá jo'ó cincuenta jarechí cha calé picá. Eta, ¿meque la'ajé chi pamácajla Abrahami chu i'imacá? ");
INSERT INTO ycn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús quemari najló: —Jema'á marí: Nucá i'imari pamineco, uncá chiyó Abrahami chu i'imá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Marí cajé aú najña'á jipa nacápojo, naca'acáloje ricá Jesús cha penaje. E'iyonaja Jesús ata'aró napiyá. E rácho'o Tupana ñacaré chiyá; ne'iyohuaja que ra'apaca. E caja ri'ijná ají que a'ajná ño'ojó nehuami chuhuá que. ");
INSERT INTO ycn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","E caja Jesús ja'apari ají que a'ajná ño'ojó. Re ramá apú ina'uqué. Mejlurú huani ri'imacá. Apicháca'aloja rimoto'ocá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","E caja ra'apiyatéjena quemaño Jesúsjlo: —Huehuíña'atajeri, ¿Naje ca'ajná rimoto'ó apicháca'alo? ¿Na la'arí pu'uhuaré, ricá ca'ajná, richi'iná ca'ajná? ");
INSERT INTO ycn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—Uncá pu'uhuaré rila'acare pachá calé rimoto'ó ilé que i'imacá —que Jesús quemacá najló—. Uncá caja richi'iná la'alaño pu'uhuaré. Uncá ricá calé apichátari ricá. Ina'uqué amácaloje me'etení méqueca Tupana la'ajica palá huani penaje, rimoto'ó mejlurú i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Hue'echú ca'alá japi queja iná la'acá iná sápaca'ala. Lapí uncá meño'ojó iná sápala iná sápaca'ala nacú. Hue'echú ca'alá japi queja huajló ricá, nu'umacale maare. Ñaquele palani tu'ujné huala'acá Nuhuacára'ajeri sápaca'ala. ");
INSERT INTO ycn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nu'umacá marí eja'ahuá chu quetana nula'acá nacaje, ina'uqué hue'epícaloje Tupana nacojé raú penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Marí que rimacá najló i'imacá. Ejomi ratupá rahui te'erí e'iyajé. Quéchami riquechípa'aca rahui te'erí hua'até. Quéchami ripato'otaca te'erí quechípa'acanami mejlurú huani ijlú chojé. ");
INSERT INTO ycn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ejomi rimá mejlurujlo: —Chuhua pi'ijná a'apitaquélaji ejo, pipíchachi pijlú chiyá. —Je —que rimacá. Aú ri'ijná ají que a'ajná ño'ojó, iphari a'apitaquélaji ejo. Siloé na'acá rií. “Huacára'acare” que Siloé que quemacana napura'acó chu. E caja riphá rejo. E ripá rijlú chiyá juni aú. Ejomi ripa'ó riñacaré chojé. Quejluni riphaca nanacu. ");
INSERT INTO ycn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Riñacaré ahua'á i'imacaño amaño quejluni ricá, mejlurú penájemi. Mejluruja namájicano ri'imajica. Namaca aú ricá quejluni nemá pajlocaca: —¿Uncá chi ricá calé quele yá'aquero ina'uqué liyá liñeru quejá'acana nacú? ");
INSERT INTO ycn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ne'iyajena quemaño rinacu: —A'a, ricá jo'ó quele. Ajopana piño quemaño rinacu: —Uncá ricá calé ricá. Ricá que huani amácanami ilé. Aú mejlurú penájemi quemari najló: —Nucá po mejlurú penájemi, imacare nacú. ");
INSERT INTO ycn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","E nemá rijló: —Eta, ¿meque la'ajé chi pamá me'etení? ");
INSERT INTO ycn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Rimá najló: —Re pajluhuaja ina'uqué, Jesús na'acá rií, ricá li'ichari nucá marí que: Riquechípi'icha te'erí rahui hua'até. Quéchami ripato'ochíyaca ricá nujlú chojé. Rejomi rimicha nojló: “Chuhua pi'ijná a'apitaquélaji, Siloé ejo, pipíchachi pijlú chiyá”, que rimíchaca nojló. Je. Raú nu'ujichá rejo. Nupicha nujlú chiyá. Ejéchami nomíchaca palá —que mejlurú penájemi quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nemá rijló: —¿Mere chi ricá, quele ina'uqué pimá nacú? —Capí, uncá nuhue'epila —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Eyá nahuá'a mejlurú penájemi fariséona i'imacá ejo. ");
INSERT INTO ycn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús la'acá te'erí quechípa'acanami rahui hua'até huacajé, i'imari nale'ejé huatána'acaje rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","E nephá fariséona nacú. Necá caja quejá'año mejlurú penájemi liyá riyucuna. Nemá rijló: —¿Meque pili'ichaca, pamácaloje penaje? E rimá najló: —Pajluhuaja pato'ochíyari nujlú chojé te'erí rahui hua'até quechípa'aquejami. Quéchami nu'ujichaca nujlú chiyá ipaje. Nupicha nujlú chiyá, ejéchami nomíchaca. Ñaquele palá nomaca me'etení. ");
INSERT INTO ycn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Raú fariséona naquiyana quemaño ajopánajlo: —Uncá Tupana hua'ateje calé ricá ja'apáchiyari ricá mejlucaje chiyá. Pamá méqueca rili'ichaca; risápicha huatána'acaje huacajé. Uncá rema'alá Tupana puráca'alo, Moisesmi chu lana'acare i'imacá, ja'apiyá. Ajopana piño quemaño rinacu: —Pu'uhuaré la'ajeri ri'imaquela, uncá meño'ojó rila'alajla nacaje uncá meño'ojó ina'uqué la'alare. Marí caje aú uncá rejenohuaja calé napechu i'imacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Marí que napechu i'imacá aú naquejá'a piño mejlurú penájemi liyá riyucuna. Nemá rijló: —Picá ta ¿meque pijló quele ja'apáchiyari picá mejlucaje chiyá? E rimá najló: —Nojló ricá Tupana puráca'alo ja'apátajeri —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judíona naquiyana pechu nacú ri'imá: “Majopeja ripajlaca ta. Uncá mejlurú huani calé ri'imacá.” Raú nahuá'a richi'iná maná. E nephá rejé nanacu. ");
INSERT INTO ycn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","E nemá najló: —¿I'irí chi cari nemá nacú mejlurú ricá? ¿Meque la'ajé chi ramaca me'etení? ");
INSERT INTO ycn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Raú richi'iná quemaño najló: —Huahue'epí marí hue'erí moto'ocá mejlurú i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Uncá huahue'epila méqueca rila'acá, ramácaloje penaje. Uncá caja huahue'epila na ina'uqueca ja'apáchiyaca riliyá mejlucaji. Caja phíyu'uque cha ricá. Iquejá'a riliyá riyucuna, ri'imachi ijló riyucuna —que richi'iná quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Marí que richi'iná quemacá najló, nahuó la'acole judíona naquiyana ja'apejé. Caja nahuacára'ajeño quemaño ina'uquejlo marí que i'imacá: “Imájica ee Jesús nacú, ‘Tupana huacára'acare majó ricá’ que, uncá huayurila ijló jahuacácajo huahuacáca'alo ñacarelana chojé.” ");
INSERT INTO ycn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Richi'iná huo la'acole judíona naquiyana ja'apejé nemá najló: “Iquejá'a riliyá riyucuna, caja phíyu'uque cha ricá” que. ");
INSERT INTO ycn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","E caja judíona naquiyana huá'año piño mejlurú penájemi maná. Raú ri'ijná piño rejo, iphari nanacu. E nemá rijló: —Chuhua pi'imá riyucuna huajló quehuaca, Tupana jimaje que pi'imacá que pi'imacá riyucuna. Huahue'epí quele ina'uqué ja'apáchiyari picá mejlucaji chiyá, uncá ina'uquélari ta ricá —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","E rimá najló: —Uncá nuhue'epila mecajeca ina'uqué ricá; uncá ina'uquélari ca'ajná ricá, palájne'eque ca'ajná ricá. Ricaja calé nuhue'epí, ra'apáchiya nuliyá mejlucaji. Uncá huani nomala i'imacá; me'etení caja nomaca palá. ");
INSERT INTO ycn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nemá piño rijló: —¿Meque huani rili'ichaca picá i'imichaca? ¿Meque ra'apáchiyaca piliyá mejlucaji? ");
INSERT INTO ycn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rimá najló: —Caja nu'umichá ijló riyucuna. Uncá huani jema'alá no'opiyá. ¿Naje ta iquejá'a metú que huani riyucuna nuliyá? ¿E ihuátaca rijhua'atéjena i'imacana? ");
INSERT INTO ycn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Raú napura'ó pu'uhuaré rinacu. Nemá rijló: —Picá ta jema'ajeri ra'apiyá. Eyá huecá jema'añó Moisesmi chu puráca'alomi ja'apiyá. ");
INSERT INTO ycn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Huahue'epí Tupana pura'acó Moisesmi chu hua'até i'imacá. Eyá ilé pimacare nacú huajló, uncá huahue'epila mere eyájeca ina'uqué ricá. ");
INSERT INTO ycn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Marí caje aú mejlurú penájemi quemari najló: —¡Meque apú caje huani quele imá nacú! Uncá ihue'epila mere eyájeca ricá. ¿Meque la'ajé calé ta ra'apáchiya nuliyá mejlucaje? ");
INSERT INTO ycn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Huahue'epí uncá Tupana a'alá rinacojó pu'uhuaré la'acaño puráca'alo, napura'acochu rijhua'até. Eyá ajopana iphaño ra'apí. Rihuátaca que la'ajeño necá. Napura'acochu rijhua'até, ra'á rinacojó napuráca'alo. Ra'á nañaté raú. ");
INSERT INTO ycn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Uncá huani nemalá apú nacú: “Ricá ja'apátari mejlurú moto'ocá liyá mejlucaji”. ");
INSERT INTO ycn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Uncáquela Tupana hua'ateje ri'imalá, uncá na calé rila'ájla —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Raú nemá mejlurú penájemijlo: —Picá ta moto'orí uncá ina'uquélari penaje i'imacá. Uncá picá ta calé huehuíña'atajeri, pehuíña'atacaloje huecá Tupana nacú penaje —que nemacá rijló. Marí caje aú naca'á ricá ne'iyayó nahuacáca'alo ñacarelana chiyá. Reyá a'ajná ño'ojó uncá nahuátala ri'ijnacá nachaje nahuacáca'alo ñacarelana chojé. ");
INSERT INTO ycn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Marí que nala'acá ri'imacá. Jesús hue'epiri méqueca naca'acá mejlurú penájemi nahuacáca'alo ñacarelana chiyá. E caja a'ajnare que riphácaco rijhua'até. E rimá rijló: —¿E chi pipechu caphí Tupana I'irí chojé? ");
INSERT INTO ycn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Rimá rijló: —Pimá nojló na ina'uqueca ricá, nupechu i'imachi caphí richojé. ");
INSERT INTO ycn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús quemari rijló: —Nucá po quele numá nacú. Hua'até pipura'ó me'etení. ");
INSERT INTO ycn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Marí que rimacá aú mejlurú penájemi tára'aro ri'irúpachi aú Jesús jimaje. E rimá rijló: —Nuhuacára'ajeri, caphí nupechu chuhua pichojé. ");
INSERT INTO ycn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","E Jesús quemari piño rahua'á i'imacáñojlo: —Re ina'uqué naquiyana mejluruna que necá Tupánajlo. Nemá nanacuhuá: “Pu'uhuaré la'acaño huecá”. Ne'emá riyucuna Tupánajlo. Raú ramó nachaje pu'uhuaré nala'acare liyá, ne'emacáloje quejluruna que Tupánajlo raú penaje. Eyá ajopana i'imaño quejluruna que najluhua me'etení. “Uncá huala'alá pu'uhuaré”, que nemacá nanacuhuá. Ñaquele uncá Tupana amalo nachaje pu'uhuaré nala'acare liyá. Raú nayuró mejluruna que Tupánajlo. Marí caje i'imacáloje pu'uhuacá ina'uquejlo penaje nu'ujná majó i'imacá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fariséona naquiyana i'imaño Jesús ahua'á. Marí que rimacá aú nemá rijló: —¿Mejluruna que caja chi huecá? ");
INSERT INTO ycn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Raú Jesús quemari najló: —Ihue'epíquela inacuhuá mejluruna que, uncá Tupana huajálajla icá pu'uhuaré ila'acare pachá. E'iyonaja calé ihue'epí inacuhuá palá la'acaño que, ñaquele pu'uhuaré ila'acare yuriro ijhua'ató. Pachá Tupana huajájeri icá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","E caja Jesús quemari najló: —Jema'á marí: Apú ca'ajná uncá mujlúca'ala ohuéjana corral numaná chojé, piro'oqueji ricá, ata'acachi ricá. Rijiyo'otá ca'ajná ricá, chiyá rimujlúca'a richojé. ");
INSERT INTO ycn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Eyá rinumaná chiyá mujlúca'aca, ohuéjana miná ricá. Nalamára'ajeri ricá. ");
INSERT INTO ycn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Rinumaná hua'aphé me'etari nalamára'ajerijlo rinumaná, rimujlúca'acaloje richojé penaje. Rile'ejena ohuéjana hue'epiño nalamára'ajeri núru'upi mejé méqueca rihuá'aca najló. Rihuá'a najló neí aú. Marí que rihuá'aca najló aú neño'ó corral chiyá riloco'opani. ");
INSERT INTO ycn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Rihuá'a necá corral chiyá, ejomi ra'apá natucumá. Rile'ejena ohuéjana, quele ja'apaño rápumi chu rijhua'até, nema'acale nalamára'ajeri núru'upi mejé. ");
INSERT INTO ycn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Uncá ne'ejnalá apú ápumi chu, uncale namána'apa calé ricá. Neñaacoja ripiyá, nahue'epícale uncá nalamára'ajeri calé ricá. Rinúru'upi mejé aú nahue'epí ricá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Marí que Jesús i'imacá najló yucu i'imacá. E'iyonaja uncá nahue'epila meque quemacánaca ricá. ");
INSERT INTO ycn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","E Jesús quemari piño najló: —Jema'á marí: Rinumaná chiyá ohuéjana mujlúca'año corral chojé. Rinumaná que caja nucá ina'uquejlo. Nupalamane aú namujlúca'aje Tupana i'imacá ejo. ");
INSERT INTO ycn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Piyuque nutucumá iphácaño huátaño ina'uqué najluhua najhua'atéjena penaje. Piro'oquéjena necá; ata'acáchina caja necá. Uncá Tupana ja'apiyá jema'ajeño a'alaño nanacojó napuráca'alo. ");
INSERT INTO ycn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Rinumaná que caja ina'uquejlo nucá, nupalamane aú ina'uqué mujlúca'ajeño Tupana i'imacá ejo. A'ajeño necó nojló, ne'emacáloje nujhua'atéjena penaje, necá nu'umataje capichácajo liyá. Ohuéjana lamára'ajeri amari palá ripirana. Rihuá'a necá na'ajné ejo, najñácaloje najluhua ricá penaje. Ñaqué caja nomaca palá nujhua'atéjena chapú nala'acá piyá. Nacaje nala'acare camu'ují nacú, no'ó najló ricá. ");
INSERT INTO ycn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Piro'oqueji iphari, rata'acáloje penaje, rinócaloje penaje. Ricapichátacaloje nacaje penaje riphá. Eyá nucá, uncá ñaqué calé. Nucá iphari majó nupechu a'ajé ijló, palá huani i'imacáloje marí eja'ahuá chu raú penaje. I'imacáloje caja matajnaco je'echú chu raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Palá lamára'aca ohuéjana que nucá ina'uquejlo. Palá lamára'aca ohuéjana a'arí ricó capichácajojlo ripirana chaya, rimejñátacaloje necá penaje. ");
INSERT INTO ycn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ohuéjana lamá'ajeri hua'até sápaca sápari, rijña'acáloje rijluhua risápaca'ala huemí penaje. Ohuéjana amácana nacú apala ramá yahui jeño'ocá ne'iyajé. Aú riñaó reyá, uncá paminá calé ri'imacale. Marí caje aú yahui ja'aró ohuéjana e'iyajé, jeño'ótano macajmala necá. ");
INSERT INTO ycn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Rijhua'até sápajeri ñaaró. Uncá ra'alá ricó capichácajojlo nachaya, rimejñátacaloje necá penaje. Ricánacaloje liñeru rijluhua penájeja calé risapa. ");
INSERT INTO ycn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Uncá ñaqué calé nucá nule'ejena ina'uqué hua'até. Palá nomaca necá. Nora'apá hue'epiri nucá; nucá hue'epiri caja Nora'apá. Ñaqué caja nuhue'epica nule'ejena ina'uqué. Necá hue'epiño caja nucá. Nucá taca'ajeri nachaya. ");
INSERT INTO ycn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Re caja ajopana ina'uqué, nule'ejena penájena necá. Uncá jo'ó nujhua'atéjena calé necá me'etení. Nuhuá'aje najló piño, ne'emacáloje nujhua'até penaje. Necá jema'ajeño no'opiyá, raú nohuacátaje necá ajopana nujhua'atéjena hua'até pajlúhua'o chojé. Nucá, pajluhuaja, amájeri necá. ");
INSERT INTO ycn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Nora'apá huátari nucá íqui'ija, nutaca'ajícale nujhua'atéjena ina'uqué chaya. Nutaca'ajica ejomi numacápo'ojo piño. ");
INSERT INTO ycn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ajopana ina'uqué nójeño nucá. Uncá meque nala'alajla nucá, uncáquela no'olajla nocó taca'acájejlo. Nuhuata nochó yurícana najló, nenócaloje nucá penaje. Caja Nora'apá quemari nunacu, nutaca'acáloje penaje. Rimá caja nunacu, numacápo'ocoloje penaje. Caja queja Nora'apá quemacá nojló i'imacá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Marí que rimacá aú uncá panacojéchaca calé judíona pechu i'imacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Iqui'iruna ina'uqué quemaño ajopana nanaquiyánajlo: —¿Naje a'á ripuráca'alo inacojó? Jiñá pechu ta re'iyá. Jehuíñami ta ricá. ");
INSERT INTO ycn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Eyá ajopana quemaño marí que rinacu: —Jiñá pechu i'imaquela re'iyá, uncá meño'ojó ripura'alojla ripura'acó que caja. Uncá caja jiñá pechu e'iyari ja'apátala mejlucaji ina'uqué liyá —que nemacá Jesús nacú. E caja na'apá paliyácaca. ");
INSERT INTO ycn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yahuijá e'iyá ne'emá rihuacajé. Jerusalén e na'apata fiesta i'imacá. Júpimi que nachi'inami chuna ñapátaño Tupana ñacaré la'acana rapumí chojé. Chapú nanacu péchuruna cajya'ataño pamineco i'imacare. Rihue'epícana penaje nala'áno fiesta. ");
INSERT INTO ycn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús caja ja'apátari fiesta najhua'até i'imacá. E Jesús chira'aró Tupana ñacaré cópihua. Ricopi richira'acaro chuhuá nemá nacú: “Salomón copi ricá.” Rehuá Jesús chira'aró. ");
INSERT INTO ycn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ejéchami judíona naquiyana jahuacaco rinacojé tujlá que pajimájechaca. E nemá rijló: —¿Méquetana júpica pimicho'otájica hualiyá na ina'uqueca picá? Picá Tupana huacára'acare majó pi'imajica ee, pimá huajló pu'ucuja pinacuhuá, huahue'epichi picá. ");
INSERT INTO ycn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Raú Jesús quemari najló: —Caja numá ijló i'imacá. E'iyonaja uncá jema'alá no'opiyá. Nora'apá a'arí nuñaté, nula'acáloje nacaje uncá meño'ojó apú la'alare penaje. Nacaje nula'acá aú ina'uqué hue'epiño palá, Tupana huacára'acareca nucá. ");
INSERT INTO ycn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","E'iyonaja calé uncá huani jema'alá no'opiyá. Uncá nule'ejena ina'uqué calé icá. Ñaquele uncá jema'alá no'opiyá. Caja numá ijló rinacu apú huacajé i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nujhua'atéjena a'añó nupuráca'alo nanacojó. Nuhue'epí mécajenaca ina'uqué nujhua'atéjena. Nema'á no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Najló calé no'ó cajmuchaji, ne'emacáloje matajnaco je'echú chu raú penaje. Uncá nacapichálajo. Uncá na calé ña'ajeri nucápiya caphí péchuruna nochojé. ");
INSERT INTO ycn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nora'apá Tupana a'arí nojló ina'uqué; nule'ejena penájena necá. Ricá chá'atari piyuqueja ajopana. Ñaquele uncá na calé ña'ajeri necá ricápiya. ");
INSERT INTO ycn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Panacojéchaca que huani huecá Nora'apá hua'até —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Marí que rimacá jimaje judíona naquiyana huátaño rinócana. Nahuata jipa ca'acana richá, nenócaloje ricá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","E Jesús quemari najló: —Nula'á cajrú nacaje palani ijimaje, Nora'apá a'acale nuñaté i'imacá. ¿Mecaje apú nula'acare chona ihuata nonócana jipa aú? —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Raú judíona naquiyana quemaño rijló: —Uncá na pila'acare chona calé huaca'ajé jipa pichá. Pu'uhuaré pipura'acó Tupana nacú. Richona huaca'ajé pichá jipa. Ina'uqué jo'ó picá, e'iyonaja pila'á pinacuhuá Tupana que huani —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aú Jesús quemari najló: —Tupana puráca'alo lana'aquéjami quemari marí que inacu: “Tupana que icá”, que rimacá. ");
INSERT INTO ycn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tupana puráca'alo quemacá que caja ricá. Uncá meño'ojó ri'imalá apojó. Riyurícarenajlo ripuráca'alo nacú rimá: “Tupana que necá”. Ñaquele uncá naje calé imá nunacu: “Pu'uhuaré la'ajeri ricá” que. ");
INSERT INTO ycn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Tupana a'arí nucá, rihuacára'acaloje nucá majó penaje. E'iyonaja, imá nunacu: “Pu'uhuaré ripura'acó Tupana nacú,” numacale ijló nunacuhuá: “Tupana I'irí nucá” que. ¿Naje imá nunacu: “Pu'uhuaré ripura'acó” que? ");
INSERT INTO ycn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Uncachu nula'alá Nora'apá Tupana quemacá que, jema'aniya no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nula'á nacaje rihuátaca que. E'iyonaja uncá jema'alá no'opiyá. Nula'á Tupana huátaca que. Ila'á quehuaca ricá no'opiyá. Raú ihue'epeje panacojéchaca huani huapechu rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Marí que rimacá aú nahuata piño rijña'acana, naca'acáloje ricá calajeruni chojé penaje. E'iyonaja Jesús i'imaró naliyá. ");
INSERT INTO ycn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","E caja Jesús cuhuá'ari ají que juni Jordán pa'anajo pitá piño. Juan la'ajica bautizar ina'uqué i'imacá ejo riphá. Re riyuró. ");
INSERT INTO ycn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","E cajrú ina'uqué i'ijnacá rejo ramaje. Marí que ramájeño quemacá pajlocaca: —Uncá Juan la'aqué nacaje uncá meño'ojó iná la'alare i'imacá. Nacaje rimacare Jesús nacú i'imacá quehuaca ricá —que nemacá. ");
INSERT INTO ycn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ñaquele re cajrú ina'uqué pechu i'imacá caphí Jesucristo chojé. ");
INSERT INTO ycn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pajluhuaja ina'uqué i'imari. Rií i'imari Lázaro; pajimila e ri'imacá. Pajimila ií Betania. Re caja María, Marta, quele ñacaré i'imacá re. Ne'ehué i'imari Lázaro. ");
INSERT INTO ycn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María, Lázaro e'ehueló, la'ayó Jesús marí que i'imacá: Roco'ó pu'umé jamarí jilá Jesús ji'imá nacojé i'imacá. Rejomi rolaca ricá ruhuilá aú rinaquiyá. Marí que rula'acá i'imacá. Rucá penájerumi María i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Eyá caja Marta, María, quele e'ehué la'aró ritami i'imacá. Raú re'ehuelona huacára'año Jesusjlo yucu rapunana chu. Marí que nemacá rinacu: —Hue'emacana, ricá íqui'ija pihuátacare la'aró ritami. Aquíchaje huani ricá me'etení —que nahuacára'aca riyucuna Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Aú Jesús quemari najló: —Uncá ritajnálajo ritami caje nacú. Tupana hue'epiri piyuqueja nacaje la'acana. Nucá, Ri'irí, hue'epiri ñaqué caja piyuqueja nacaje la'acana. Ina'uqué jema'acáloje riyucuna penaje, rila'ó ritami i'imacá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Palá huani Jesús pechu i'imajica nanacu. Marta, ro'ohueló, ne'ehué Lázaro, quele nacú ripechu i'imaqué palá. ");
INSERT INTO ycn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Caja ne'emá rijló riyucuna: “Aquíchaje huani Lázaro,” que nemacá rijló rinacu i'imacá. E'iyonaja rejo'ocaja jo'ó riyuró iyamá cala quetana. ");
INSERT INTO ycn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Quéchami rimacá ra'apiyatéjenajlo: —Chuhua i'ijná hue'ejnachi piño Judea te'eré ejo. ");
INSERT INTO ycn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Raú ra'apiyatéjena quemaño rijló: —Huehuíña'atajeri, meyale judíona huátaño jipa ca'acana pichá re i'imacá, nenócaloje picá raú penaje. ¿Rejo chi pihuátaca pa'acajo? ");
INSERT INTO ycn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","E Jesús quemari najló: —Re mejáma'atani iyamá iphata ji'imaji nacojé quele camú jená quetana pajluhuaja hue'echú. Iná ja'apácachu hue'echú ca'alá japi, uncá iná ji'imá huara'aló nacaje nacojé, mejáma'atani chuhuá iná ja'apácale. ");
INSERT INTO ycn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Majopeja iná ja'apácachu lapí iná ja'ó, uncale mejáma'atani i'imalá —que rimacá najló. (Marí que quemacánaca ricá rimacare nacú: Re hue'echú ca'alá nojló, nula'acáloje nusápaca'ala penaje. Uncá jo'ó riphala noná chojé, nenócaloje nucá penaje.) ");
INSERT INTO ycn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Rejomi Jesús quemari ra'apiyatéjenajlo: —Ricá, íqui'ija huahuátacare, Lázaro, camáchiyaro. Chuhua nu'ujichaca rapótaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eyá ra'apiyatéjena quemaño rijló: —¿Meque quemacánaca chi quele pimá nacú: “Ricamáchiyaco” que? Raú ritejmo'otajo. ¿Marí que quemacana chi ricá? ");
INSERT INTO ycn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Marí que Jesús huátaca ra'apiyatéjenajlo quemacana nacú i'imacá: “Caja Lázaro taca'arí” que. —E'iyonaja ra'apiyatéjena pechu nacú ri'imá: “Ricamáchiyaco japi, iná camátaco lapí que”. ");
INSERT INTO ycn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","E pu'ucuja Jesús quemacá najló: —Caja Lázaromi chu taca'arí. ");
INSERT INTO ycn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pu'ují nupechu, uncale hue'emalá rejo i'imacá. Palani caja ijló ricá, ihue'epícaloje na la'ajérica nucá raú penaje. Chuhua i'ijná huamíchachi ricá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Raú Tomás, iyamá moto'ocaño naquiyana ri'imacá, quemari rijhuáque'enajlo: —I'ijná hue'ejnachi rijhua'até rejo, huataca'acáloje rijhua'até rejo penaje. ");
INSERT INTO ycn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","E caja ne'ejná; iphaño rejo. E ne'emá Lázaromi chu yucuna Jesúsjlo. Nemá rijló: —Pa'u que cálicha huecá nasa'acá ritami ejomi —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalén ahua'á pajimila Betania. Iyamá quilometros eyá, apú quilometro pe'iyojé quetana júcaca reyá ricá. ");
INSERT INTO ycn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Cajrú huani judíona i'imaño Marta, María, quele chaje. Napechu pala'ataje ne'ejná rejo, namácale chapú caje yajhué ne'ehuemi chu tajnaco pumí chiyá. ");
INSERT INTO ycn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nemá najló: “Jesús huaícha” que. Aú Marta i'ijnayo ají que a'ajná ño'ojó rijimajo. María, ro'ohueló, yuriyo nañacaré chu. ");
INSERT INTO ycn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","E caja Marta iphayo Jesús nacú, rumá rijló: —Pi'imaquela maare, uncá no'ohuemi chu taca'alajla. ");
INSERT INTO ycn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","E'iyonaja nuhue'epí Tupana la'acá pijló piyuque nacaje piquejá'acare riliyá —que rumacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús quemari rojló: —Pe'ehuemi chu macápo'ojero piño. ");
INSERT INTO ycn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Aú Marta quemayo rijló: —A'a, nuhue'epícare jo'ó quele pimá nacú. Piyuque ina'uqué caja taca'acaño macápo'ojico huacajé, rimacápo'ojo najhua'até. Eja'ahuá iphájica caja penaje rená chojé huacajé, quéchami rimacápo'ojo piño —que rumacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Eyá Jesús quemari piño rojló: —Ina'uqué caja taca'acaño macápo'otajeri nucá. Ina'uquejlo cajmuchaji a'ajeri caja nucá. Ina'uqué taca'añó. E'iyonaja caphí péchuruna nochojé i'imajeño piño —que rimacá rojló—. ");
INSERT INTO ycn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Marí que ricá cajmurúnajlo: Nayurícachu nachó nojló, nu'umatácaloje necá Tupánajlo penaje, uncá huani natajnálajo. ¿E chi marí que pijló ricá? —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—A'a, Nu'umacana —que rumacá—. Nuhue'epí Tupana huacára'aca picá majó Hue'ematájeri penaje. Tupana I'irí picá. Caja queja Tupana pechu nacú ri'imacá, pi'imacáloje marí eja'ahuá chu penaje —que rumacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","E caja Marta pa'ayó María maná huá'aje. Me'echú rumacá rojló: —Caja Jesús iphíchari. Rihuá'icha pimaná. ");
INSERT INTO ycn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Marí que rumacá aú María jácho'oyo, i'ijnayo ají que Jesús amaje. ");
INSERT INTO ycn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ejo'ocaja ri'imá pajimila ahua'ája. Marta iphátaca ri'imacá eja. ");
INSERT INTO ycn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ruñacaré chu i'imacaño amaño María jácho'oco. Namá ro'opaca peyajhué a'ajná ño'ojó. Ruñacaré chu ne'emá najhua'até, napala'atácaloje napechu penaje. Namaca aú ru'ujnacá ají que a'ajná ño'ojó ne'ejná rópumi chu. Napechu i'imá: “Támijimina ca'aquelana ejo japi ru'ujichaca ro'ohuemi chu iyaje.” ");
INSERT INTO ycn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","E caja María iphayo Jesús i'imacá ejo. E rutára'o ru'urúpachi aú Jesús ji'imá nacojé. E rumá rijló: —Pi'imaquela maare, uncá no'ohuemi chu tajnálojla —que rumacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Raú Jesús ja'amari re'iyohuá. Ramá ruyaca cajrú. Ñaqué caja ramaca rujhua'até i'ijnacaño iyaca. Aú camu'ují huani ripechu la'acó najhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Méreje que nato'otaca Lázaromi chu tami? —que rimacá najló. —Pi'ijná huajhua'até, pamíchachi ritami. —Je —que. ");
INSERT INTO ycn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","E caja nephá rejo. E Jesús iyari Lázaromi chu. ");
INSERT INTO ycn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Raú judíona quemaño pajlocaca: —Pa. Meque íqui'ija huani rihuátaca Lázaromi chu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ne'iyajena quemaño rinacu marí que: —Ricá lamá'atari mejluruna, namácaloje palá penaje. ¿Uncá meño'ojó chi rila'alajla nacaje i'imacá, Lázaromi chu taca'acá piyá? —que nemacá rinacu. ");
INSERT INTO ycn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Riyúcha'aco a'acuhuaná Jesús ja'amari re'iyohuá. E ri'ijná támijimi a'acuná ahua'ajé. Ulahuí chu, jipa e'iyá ritami to'oró. Caja netá támijimi cha cajruni jipa aú i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","E Jesús quemari najló: —Jatachiya jipa ají ño'ojó pani rinumaná eyá. Raú Marta, Lázaromi chu e'ehuelomi, quemayo Jesusjlo: —Yee, apala pu'uhuareni ca'ajná rama yá'aco richu. Caja pa'u que cálicha huecá ritaca'acá i'imacá ejomi —que rumacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","E'iyonaja Jesús quemari rojló: —Caja numicha pijló maapami: “Caphí pipechu i'imajica ee Tupana chojé, pamájica Tupana la'acá palá huani” —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","E caja natatá jipa rinumaná eyá. E Jesús yacá'aro je'echú chojé. Rimá Tupánajlo: —Nora'apá, palá pili'ichaca nucá, pema'acale nupura'acó pijhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nuhue'epí hua'ajini pema'acá nupura'acó pijhua'até. Mariruna ina'uquéjloje penaje nupura'ó pijhua'até me'etení, nahue'epícaloje pihuacára'acare nucá majó i'imacá —que rimacá Tupánajlo. Marí queja calé rimacá rijló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ejomi rahuíyo'oco rimacá: —Lázaro, chuhua pácho'o majó liri chiyá. Pi'ijná majó —que rahuíyo'oca támijimijlo i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Aú ja Lázaro jácho'oro majó. Riyáte'ela, ri'imá, quele i'imari mapíra'ataqueja a'arumacaji jítami aú. Apára'aqueja rijimá i'imacá a'arumacaji aú. E Jesucristo quemari najló: —Chuhua ihuicho'otá rinaquiyá ricá, ra'apachi. —Je —que. E nahuicho'otá ricá. Ejomi ra'apá. ");
INSERT INTO ycn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jesús macápo'ori Lázaro i'imacá. Marí caje aú cajrú judíona pechu i'imacá caphí Jesús chojé. María hua'até i'ijnacaño ne'emacá. Jesús macápo'oca Lázaro amájeño ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Quéchami ne'iyajena i'ijnacá ají que fariséona naquiyana amaje, ne'emacáloje méqueca namaca Jesús macápo'oca Lázaro yucuna najló penaje. E caja nephá nanacu. E ne'emá najló riyucuna. ");
INSERT INTO ycn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Fariséona, sacerdótena huacára'ajeño, quele i'imaño re. Ne'emá najló riyucuna. Ejomi nahuacaco nachaje huacára'ajeño hua'até. E nanaquiyana quemaño ajopánajlo: —¿Meque ta huala'ajica quele ca'ajná ina'uqué? Cajrú rila'acá nacaje uncá meño'ojó ina'uqué la'alare. Ina'uqué pechu i'imacáloje caphí richojé raú penaje rila'á ricá. ");
INSERT INTO ycn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Uncájica ee huetá rapu riliyá, piyuque ina'uqué pechu i'imajla caphí richojé. Marí cajé jimaje ca'ajná Roma eyájena huacára'ajeño la'ajeño huecá chapú. Nahuacára'aje ca'ajná surárana majó, nacapichátacaloje huecá penaje. Tupana ñacaré hua'ató ca'ajná nacapichátaje —que nemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Apú i'imari najhua'até. Rií i'imari Caifás. Sacerdótena huacára'ajeri ri'imacá rihuacajé. Na'á ri'imacá, ri'imacáloje nahuacára'ajeri pajluhuaja jarechí quetana penaje. E rimá najló: —Uncá huani ihue'epila ta. ");
INSERT INTO ycn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Pajluhuaja ina'uqué taca'ajeri huachaya, huacapichaco piyá piyuque huani. Marí palani huajló —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Uncá ripechu queja calé Caifás quemacá marí que. Ri'imacáloje nahuacára'ajeri pajluhuaja jarechí quetana penaje na'á ri'imacá. Nahuacára'ajeri ri'imacale, Tupana quemari rijló rinacu. Raú rihue'epí Jesús taca'ajica Israelmi chu laquénami chaya. ");
INSERT INTO ycn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Rihue'epí caja uncá nacháyaja calé ritaca'ajé. Tupana hua'atéjena penájena chaya caja ritaca'ajé. Ajopana te'eré nacú i'imacaño cajena hua'ató chaya ritaca'ajé. Tupana hua'atéjena i'imacáloje pajluhuaja pi necá que pajhua'atéchaca raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ñaqué i'imacale reyá a'ajná ño'ojó judíona huacára'ajeño pura'añó pajhua'atéchaca, nahue'epícaloje méqueca nenócajla Jesús penaje. ");
INSERT INTO ycn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Marí caje aú uncá Jesús ja'apala pu'uhuacá huani judíona e'iyohuá. Rácho'o nate'eré eyá, Judea te'eré eyá. I'ijnari ají que a'ajná ño'ojó apú pajimila Efraín ejo. Pu'uteni chu ricá pajimila. Re riyuró ra'apiyatéjena hua'até. ");
INSERT INTO ycn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","E caja yehuicha nephaca fiesta la'acana ja'apejé. Pascua fiesta ií i'imacá. Marí caje aú cajrú ina'uqué i'ijnaño Jerusalén ejo, nalamá'atacaloje napéchuhua Tupánajlo penaje. Uncá chiyó fiesta iphá rená chojé, nalamá'atano napéchuhua Tupánajlo, napechu i'imacáloje palá raú Tupana nacú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Cajrú ne'emacá Jerusalén e. E caja naculá Jesús re. Tupana ñacaré chu ne'iyajena pura'añó pajhua'atéchaca Jesús nacú. Nemá apujlo, apujlo que: —¿Meque pipechu nacú ricá? ¿E ri'ijnajica majó fiesta ja'apátaje, uncá ca'ajná? ");
INSERT INTO ycn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Caja fariséona, sacerdótena huacára'ajeño, quele quemaño piyuqueja ina'uquejlo marí que i'imacá: —Amájica ee Jesús, eco i'imá riyucuna huajló, huapachíyachi ricá. ");
INSERT INTO ycn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pajluhua cuhuá'ata que cala yuriro napé, nephácaloje nale'ejé fiesta ja'apejé penaje. Pascua fiesta ií. E caja Jesús i'ijnari ají que Betania ejo. Lázaro, Jesús macápo'ocare i'imacá, ricá ñacajela ejo ri'ijná. ");
INSERT INTO ycn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Riñacaré chu nala'á a'ajnejí Jesús piyana i'imacá. Raú ne'ejná rejo na'ajnehuá ajñaje. Marta tamáca'atayo najló a'ajnejí. Ajopana ajñaño caja na'ajnehuá re najhua'até. Ne'iyá Lázaro i'imari. ");
INSERT INTO ycn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Caja ne'emá na'ajnehuá ajñacana nacú. E'iyohuá que María i'ijnacá Jesús jimajo. Nacaje jilá i'imari rucapi pe'iyó litro que. Pu'umé jamarí ri'imacá; nardo, nacaje jilá ií i'imacá. Cahuemini huani ri'imacá. E caja María aco'oyó ricá Jesús ji'imá nacojé. Ejomi rumacára'a ricá ruhuilá aú. Rama moco'oró piyuque pají chuhuá. ");
INSERT INTO ycn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Re caja Judas Iscariote i'imari. Simonmi chu i'irimi ri'imacá; Jesús ja'apiyatéjena naquiyana ri'imacá. Ricá a'arí Jesús pinánajlo ricá, nenoca ri'imacá huacajé. Ri'imá najhua'até. Ramaca aú rula'acá ilé que, rimá ajopánajlo: ");
INSERT INTO ycn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Cahuemini huani ta cari. Trescientos denarios rihuemí. ¿Naje uncá ro'olá ajopánajlo ricá, rujña'acáloje rujluhua liñeru penaje, ro'ocáloje camu'ují la'acaño ñaté raú penaje? —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Majopeja Judas quemacá ilé que runacu, ata'acachi ri'imacale. Uncá rihue'epila camu'ují la'acaño mu'ují i'imacá. Jesús ja'apiyatéjena liñérute lamá'atajeri ri'imacá. E'iyonaja uncá rilamá'ataque najló ricá; rata'aqueno rijluhua rinaquiyana. ");
INSERT INTO ycn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Marí que rimacá aú Jesús quemari rijló: —Reja ru'umare. Rulamá'ata nacaje jilá nasa'ajica nutami huacajé penaje. ");
INSERT INTO ycn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Camu'ují la'acaño i'imajeño ijhua'até ñaqueja. Eyá nucá, uncá nu'umalaje ijhua'até ñaqueja huani maare —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yucu i'imari: “Jesús i'ijnari Betania ejo” que. Cajrú judíona jema'añó riyucuna. Aú ne'ejná rejo Jesús amaje. Nahuata caja Lázaro amácana, ricá Jesús macápo'ocare i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ñaquele sacerdótena huacára'ajeño pechu nacú ri'imá, nenócaloje Lázaro penaje. ");
INSERT INTO ycn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Jesús macápo'oca ricá ejomi cajrú judíona pechu i'imacá caphí Jesús chojé. Rilanaquiya nayurí sacerdótena huacára'ajeño ja'apiyá jema'acana. Marí caje jimaje nahuata Lázaro nócana i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Caja cajrú ina'uqué i'ijnacá Jerusalén ejo fiesta la'ajé. Pascua fiesta ií. Nahue'epí muní que Jesús iphájica pajimila e'iyajé. ");
INSERT INTO ycn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Raú ne'ejná re'iyohuá huejirí huirulá mata'acana nacú. Ejomi nácho'o pajimila eyá; i'ijnaño ají que a'ajná ño'ojó rijimajo; iphácaño rijhua'até iñe'epú chu. Marí que nahuíyo'otaca ricá: —Palájne'eque huani Tupana je'echú churí. Palájne'eque huani caja ricá Tupana huacára'acare majó. Palani huani Israelmi chu laquénami huacára'ajeri —que nahuíyo'otaca ricá. ");
INSERT INTO ycn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","E caja Jesús iphátari cahuarú caje. E reño'ó ranapeje yá'ajo, ra'apácaloje rinacu pajimila ejo penaje. Raú rila'á Tupana puráca'alo lana'aquéjami quemacá rinacu i'imacá que. Marí que lana'aquéjami quemacá Jerusalén nacú i'imacá: ");
INSERT INTO ycn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jerusalén eruna, iquero'oniyo. Icá amájeño Ihuacára'ajeri iphaca majó cahuarú caje nacú. ");
INSERT INTO ycn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Rihuacajé Jesús ja'apiyatéjena uncá hue'epílaño meque quemacánaca marí que rimacá rinacu. Nacúhua'ataca Jesús a'ahuaná apiyácacanami nacú i'imacá ejomi nahue'epí ricá. Nahue'epí caja Tupana puráca'alo lana'aquéjami quemacá rinacu i'imacá marí que. Jupichúnami lana'añó riyucuna marí que i'imacá. Ricá chuhuaja ri'imá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús macápo'oca Lázaro huacajé cajrú ina'uqué i'imacá rijhua'até. Nema'á rahuíyo'oca rijló, rácho'ocoloje majó liri chiyá penaje. Jesús macápo'oca ricá amájeño i'imaño riyucuna ajopánajlo, ajopánajlo que. ");
INSERT INTO ycn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aú ne'ejná Jesús ejo, nahue'epícale rila'acá nacaje uncá meño'ojó ina'uqué la'alare. ");
INSERT INTO ycn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","E Jesús ja'apari cahuarú caje nacú. E fariséona amaño ricá iphaca pajimila e'iyajé cajrú ina'uqué hua'até. Raú napura'ó pajhua'atéchaca necámica que. Nemá pajlocaca: —Chuhua uncá meque huala'alá. Iyacá'o, rijhua'até huánija chuhua ina'uqué. ");
INSERT INTO ycn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Cajrú ina'uqué i'ijnaño Jerusalén ejo i'imacá, napechu i'imacáloje pu'ují Tupana nacú fiesta huacajé penaje. Re caja griégona naquiyana i'imaño. ");
INSERT INTO ycn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","E ne'ejná apú Jesús ja'apiyateje ahua'ajé, Felipe ahua'ajé. Pajimila Betsaida eyaje ri'imacá. Galilea te'eré nacú ricá pajimila. Nephá Felipe nacú. E nemá rijló: —Pila'á huajló nacaje. Pihuá'a huecá Jesús ejo, huahuata ramácana. ");
INSERT INTO ycn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Raú Felipe i'ijnari riyucuna i'imajé Andresjlo. Ejomi necá iyamá i'ijnaño riyucuna i'imajé Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","E ne'emá riyucuna rijló. Jesús quemari najló: —Caja riphá rená chojé, Tupana la'acáloje nucá ajopana chaje huani penaje. Ina'uquéjloje penaje i'imacá nucá. ");
INSERT INTO ycn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Jema'á marí: Uncachu iná ejátala nacaje icha ijí, pajluhuaja riyurico ricoja. Eyá iná ejátacachu ricá te'erí e'iyajé, ricapichaco queja rila'acó. Quéchami riphaca. Pajluhuaja rijí naquiyá iphaca, ricá a'arí cajrú richahuá. Ñaqué caja nucapichájico, cajrú nujhua'atéjena i'imacáloje raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Re ina'uqué, hue'epiño caí nanacuhuá. Nahuata pajimato ina'uqué pechu i'imacá palá nanacu. Aú calé uncá nahuátala nujhua'atéjena i'imacana. Marí que hue'epícaño caí nanacuhuá capichájeño Tupana liyá. Eyá uncá hue'epílaño caí nanacuhuá ilé que, i'imajeño matajnaco je'echú chu nujhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nojló nacaje la'ajeño jema'añó no'opiyá. Ne'emajé caja nu'umajica ejo nujhua'até. Palá huani Nora'apá la'ajica necá, la'añó nojló nacaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Chuhuaca nomájica chapú chaje yajhué. ¿Meque numájica Nora'apajlo rinacu? ¿E numájica rijló: “Pi'imatá nucá chapú caje i'imajícare nunacu liyá?” Uncá numalaje ilé que rijló. Ricá penaje huani nuphá majó i'imacá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","E ripura'ó Tupana hua'até. Rimá rijló: —Pa'ayú, pila'á nacaje ina'uqué pechu i'imacáloje palá pinacu raú penaje. Ejéchami re i'imacaño jema'acá Tupana pura'acó rijhua'até je'echú chiyá majó. Rimá Jesusjlo: —Caja nula'á nacaje palani, ina'uqué pechu i'imacáloje palá nunacu raú penaje. Chuhua piño nula'ajica apú nacaje, napechu i'imacáloje pu'ují nunacu raú penaje —que Tupana quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ina'uqué, re i'imacaño, jema'añó ripura'acó rijhua'até. Uncá nema'alá ricá palá. Ne'iyajena quemaño ajopánajlo: —¿Pichaní chi majáqui'icharo? Ajopana quemaño rinacu: —Tupana hua'atéjeri, je'echú chiyaje, puri'icharo rijhua'até je'echú chiyá. ");
INSERT INTO ycn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","E caja Jesús quemari najló: —Uncá nojló penaje calé rimicha ilé que nojló. Ijló penaje rimicha ilé que. ");
INSERT INTO ycn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chuhua Tupana huajájica nucá ina'uqué chaya. Pu'uhuaré nala'acare chona, namanaicho nala'acare chona, rihuajaje nucá. Reyá a'ajná ño'ojó uncá Jiñá Chi'ináricana i'imalaje nahuacára'ajeri. ");
INSERT INTO ycn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nacúhua'ataje nucá a'ahuaná apiyácacanami nacojé. Rejomi nulamá'ataje cajrú ina'uqué pechu, ne'emacáloje nujhua'atéjena raú penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Marí que rimacá aú ina'uqué hue'epiño méqueca ritaca'ajica. ");
INSERT INTO ycn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Raú nemá rijló: —Huema'á napura'acó Tupana puráca'alo lana'aquéjami hua'até huajló, ricá Moisesmi chu lana'acare i'imacá. Ricá quemari ina'uqué i'imatájeri nacú: “Uncá tajnácajo penaje calé ricá”, que rimacá. E'iyonaja picá quemari pinacuhuá: “Nacúhua'ataje nucá a'ahuaná apiyácacanami nacojé. Nucá i'imari ina'uquéjloje penaje”. Pitaca'ajé a'ahuaná apiyácacanami nacú. Uncá ca'ajná picá calé picá, Tupana puráca'alo lana'aquéjami quemacare nacú. ");
INSERT INTO ycn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús quemari najló: —Nula'á nacaje e'iyohuá. Nohuíña'ata caja icá palá Tupana nacú, ihue'epícaloje Tupana nacojé raú penaje. Mequetánaja nu'umajica ijhua'até. Jema'á no'opiyá icapichaco piyá Tupana liyá. Necá uncá jema'alaño no'opiyá, uncá hue'epílaño meño'ojoca ne'ejnajica. ");
INSERT INTO ycn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nunacojé ihue'epí Tupana nacojé. Ipechu i'imá nochojé caphí nu'umacá ijhua'até quetana maare. Raú i'imajé nujhua'atéjena —que Jesús quemacá najló. E ri'ijnañáa necá; rata'ó napiyá. ");
INSERT INTO ycn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús la'arí cajrú nacaje uncá meño'ojó ina'uqué la'alare. E'iyonaja uncá ina'uqué pechu i'imalá caphí richojé. ");
INSERT INTO ycn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Isaíasmi chu quemacá nanacu júpimi que, ñaqueja ne'ejnataca ricá. Tupana puráca'alo ja'apátajeri ri'imacá. Marí que rilana'acá riyucuna i'imacá: “Hue'emacana, uncá na'alaje nanacojó huapuráca'alo. Namaje meque piyuque huánica Tupana la'acá. ");
INSERT INTO ycn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","E'iyonaja uncá na'alaje nanacojó huapuráca'alo,” que rilana'acá i'imacá. Isaíasmi chu lana'arí apa'amá piño marí que: ");
INSERT INTO ycn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tupana la'ajeri necá mejluruna que penaje. Rila'ajé caja necá ijnú, nahue'epica piyá meque quemacánaca nacaje rila'acare. Marí que rila'ajica necá, nayurica piyá necó Tupánajlo, rilamá'atacaloje napechu raú penaje,” que rilana'acá júpimi que i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Marí que Isaíasmi chu quemacá i'imacá, rihue'epícale meque cajrú huánica Jesús la'ajica nacaje. Aú calé ri'imá riyucuna najló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Cajrú judíona naquiyana pechu i'imacá caphí Jesucristo chojé i'imacá. Nahuacára'ajeño naquiyana pechu hua'ató i'imari caphí richojé. E'iyonaja uncá ne'emalá riyucuna ajopana ina'uquejlo, naquero'ocole fariséona piyá, Uncá ne'emalá riyucuna ajopánajlo, fariséona ca'acá piyá necá nahuacáca'alo ñacarelana chiyá. Nahue'epíquela Jesucristo ja'apiyá jema'ajeño ne'emacá, naca'ájla necá richiyá. ");
INSERT INTO ycn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nahuata Tupana pechu i'imacá palá nanacu. E'iyonaja richaje íqui'ica nahuátaca ajopana ina'uqué pechu i'imacá palá nanacu. ");
INSERT INTO ycn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","E caja mejrí Jesús quemacá marí que najló: —Caphí ina'uqué pechu i'imacachu nochojé, caphí caja napechu Nora'apá chojé raú. Huacára'ari nucá majó ricá. ");
INSERT INTO ycn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nomájeño amána'apa nucá. Necá caja amána'apa ricá huacára'ari nucá majó. ");
INSERT INTO ycn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nohuíña'ata icá quehuácaje puráca'aloji nacú. Marí caje penaje nuphá eja'ahuá chojé i'imacá, caphí nochojé péchuruna i'imacá piyá pajlácaje puráca'aloji ja'apiyá. Nuphá majó, ne'emacá piyá pu'uhuaré la'acana nacú. ");
INSERT INTO ycn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Apala ina'uqué jema'añó nupuráca'alo. E'iyonaja uncá na'alá nanacojó ricá. Uncá nucá calé huajájeri necá richona. Uncá nuphala majó ina'uqué huajájeri penaje. Nu'umatácaloje necá capichácajo liyá penaje nuphá majó i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Riphájicaja rená chojé caja penaje huacajé, Tupana huajájeri necá, unca pachá ina'uqué a'alaño nupuráca'alo nanacojó. Uncá huátalaño nucá, uncá caja a'alaño nupuráca'alo nanacojó, cajena rihuajaje. ");
INSERT INTO ycn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Uncá nupura'aló nupechu queja. Nora'apá, Nuhuacára'ajeri, huacára'ari nupura'acó nacaje nacú. Rihuacára'a caja nohuíña'ataca ina'uqué rinacu. ");
INSERT INTO ycn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iná hue'epícachu Nora'apá puráca'alo nacojé, iná hue'epí méqueca iná la'acá, iná i'imacáloje matajnaco je'echú chu raú penaje. Ñaquele numá ijló nacaje nacú Nora'apá huacára'aca que —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pajluhua cala yuriro ejo'ocaja natucumá, nephácaloje nale'ejé fiesta chojé penaje. Pascua fiesta ií. Jesús hue'epiri yehuicha riphaca rená chojé, rácho'ocoloje marí eja'ahuá chiyá penaje, ri'imacáloje Rara'apá hua'até penaje. Ñaqueja Jesús huátaca íqui'ija ra'apiyatéjena maare eja'ahuá chu ri'imacá quetana. Ri'ijnacá yámona rila'á piño nacaje najló, nahue'epícaloje raú íqui'ica rihuátaca necá penaje. Riyucuna marí: ");
INSERT INTO ycn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","E caja apú huacajé piño, lainchu Jesús, ra'apiyatéjena hua'até ajñaño na'ajnehuá. Judas Iscariote i'imari caja najhua'até. Simonmi chu i'irimi ri'imacá. Najñaca na'ajnehuá ee, Jiñá Chi'ináricana pechu ja'aró Judas e'iyajé. Raú ripechu la'aró apú que, ra'acáloje ripinánajlo Jesús penaje. ");
INSERT INTO ycn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús hue'epiri Rara'apá a'arí ri'imacá, ri'imacáloje piyuque ajopana chaje huacára'ajeri penaje. Rihue'epícare caja Tupana eyá riphaca, rejo ripa'ajico piño. ");
INSERT INTO ycn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","E caja najñá na'ajnehuá ra'apiyatéjena hua'até. E'iyohuá que Jesús jácho'oco. Rica'á richáyaje ra'arumacá rinaquiyó. Ejomi repo'ó ricó rihuachaphí chiyá tohuaya aú. ");
INSERT INTO ycn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Rejomi raco'ó juni pachiya chojé. Quéchami riqueño'ocá ra'apiyatéjena ji'imá naquiyá ipacana. Ripá ne'emá naquiyá pajluhuano que. Ñaqué caja rimacára'aca ne'emá rihuachaphí chiyaje tohuaya aú. ");
INSERT INTO ycn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ehuá riphaca Pedro ji'ilaje. Ripajla ri'imá naquiyá. Aú Pedro quemari rijló: —Nuhuacára'ajeri, ¿E pihuátaca nu'umá naquiyá ipacana? ");
INSERT INTO ycn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús quemari rijló: —Me'etení uncá pihue'epila méqueca nula'acá. Rejomi pihue'epeje ricá —que rimacá Pédrojlo. ");
INSERT INTO ycn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aú Pedro quemari rijló: —Uncá pipalaje nu'umá naquiyá. Jesús quemari rijló: —Uncaja que nupá pi'imá naquiyá, uncá caja pi'imalaje nujhua'ateje. ");
INSERT INTO ycn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Raú Simón Pedro quemari rijló: —Nuhuacára'ajeri, pipá nu'umá naquiyá, nuyáte'ela chiyá, nuhuíla'aru naquiyá, quele —que rimacá Jesusjlo. ");
INSERT INTO ycn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús quemari najló: —Huajé a'apitacá uncá naje calé ra'apitajla piño. Ri'imá naquiyaja ipacana palani, piyuqueja rinapona i'imacáloje mapisaru raú penaje. Ñaqué caja nula'acá ina'uqué pechu. Nuca'á pu'uhuareni napechu naquiyá, ne'emacáloje palá péchuruna raú penaje. Caja nuca'á ipechu naquiyá pu'uhuaré ila'acare. Palá péchuruna icá chuhuaca. Pajluhuaja calé maare huajhua'até, uncá palá péchuri calé ricá. Pu'uhuaré la'ajeri jo'ó ricá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Rihue'epí mecajeca a'ajica ripinánajlo ricá. Aú calé rimá: “Pajluhuaja calé uncá palá péchuri calé ricá. Pu'uhuaré la'ajeri jo'ó ricá.” ");
INSERT INTO ycn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesús ñapátari ne'emá naquiyá ipacana. Ejomi ra'á rinacuhuá ra'arumacá richaje. Ejomi riyá'o piño najhua'até. E rimá najló: —¿E ihue'epica na nacuca nohuíña'achiya icá ji'imá naquiyá ipacana aú? ");
INSERT INTO ycn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Icá quemaño nunacu: “Huehuíña'atajeri” que, “Hue'emacana” que. Marí que nunacu quemacana palani, ñaqué nu'umacale. ");
INSERT INTO ycn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jehuíña'atajeri nucá; ihuacára'ajeri caja nucá. E'iyonaja nupicha ji'imá naquiyá. Ijhua'até sápajeri queja nuli'ichaca nunacuhuá. Marí que caja ila'ajica pecohuácaca. Ipajica pe'emáchaca naquiyá. ");
INSERT INTO ycn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Caja amicha méqueca nuli'ichaca palá, ñaqué caja ila'acáloje raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jema'á marí: Iná sápacachu apujlo, uncá iná carihuate chaje calé iná i'imacá. Iná sápacare hua'até, ricá i'imari iná chaje. ");
INSERT INTO ycn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Caja ihue'epí meque quemacánaca numacare nacú ijló. Ila'ajica ee ricá i'imajé palá. ");
INSERT INTO ycn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Uncá piyuque inaquiyana calé numá nacú. Nuhue'epí mecajenaca nu'uhuapacárena nujluhua. Re pajluhuaja, Tupana puráca'alo lana'aquéjami quemacá rinacu queja ri'imajica. Marí que rimacá rinacu: “Ajñari ra'ajnehuá nujhua'até, chapú ramaca nucá”. ");
INSERT INTO ycn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Numacare nacú, numá nacú ijló ri'imajica yámona. Ri'imajica ee, ihue'epeje Tupana huacára'acare majó nucá. ");
INSERT INTO ycn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jema'á marí: Ina'uqué huátajica ee íqui'ija nujhua'atéjena, necá caja huátajeño nucá. Huátaño nucá, huátaño caja Nuhuacára'ajeri —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Marí que rimacá najló ejomi camu'ují huani ri'ijnataca ripéchuhua. Raú pu'ucuja rimacá najló: —Jema'á marí: Re pajluhuaja inaquiyana maare huajhua'até, ricá a'ajeri nupinánajlo nucá. ");
INSERT INTO ycn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Marí que rimacá najló aú ra'apiyatéjena ijlú jeño'otaro pachájecaca. Uncá nahue'epila mecajeca nanaquiyana rimacare nacú. ");
INSERT INTO ycn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jesús ja'apiyateje, íqui'ija rihuátacare, i'imari Jesús ahua'á najñaca na'ajnehuá quetana. ");
INSERT INTO ycn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Marí que rimacá aú Simón Pedro ca'arí riyáte'ela rijló, riquejá'acaloje riyucuna riliyá penaje, mecajeca ricá rimá nacú a'ajeri ripinánajlo ricá. ");
INSERT INTO ycn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Raú ratató rahua'ajé huani. E rimá Jesúsjlo: —¿Mecaje ricá pimicha nacú, a'ajeri pipinánajlo picá? ");
INSERT INTO ycn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús quemari rijló: —Chuhua nonóro'otajica pan marí jalá acojé. Quéchami no'ojica ricá a'ajeri nucá nupinánajlo. Aú ihue'epeje: “¿Ricá chi ricá?” —que rimacá rijló. E ranóro'ota pan ralá acojé. Quéchami ra'acá Judas Iscariótejlo ricá. Simonmi chu i'irimi Judas i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas ña'arí pan anóro'otaquejami riliyá. Quéchami Jiñá Chi'ináricana pechu ja'acó Judas pechu e'iyajé. E Jesús quemari rijló: —Nacaje pila'ajícare, quiñaja pila'acá ricá. ");
INSERT INTO ycn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ajopana, rijhua'até ajñáucá caño na'ajnehuá, uncá hue'epílaño nájeca rimacá rijló ilé que. ");
INSERT INTO ycn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas i'imari naliñérute lamá'atajeri i'imacá. Aú ne'iyajena pechu i'imá: “Apala Jesús huátari rihuarúhua'aca huajló nacaje, hua'apátacaloje fiesta raú penaje. Rihuata ca'ajná ra'acá camu'ují la'acáñojlo liñeru,” que napechu i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas ña'acá pan anóro'otaquejami Jesús liyá ejomi ri'ijná reyá. Caja lapichá i'imari nachá. ");
INSERT INTO ycn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Caja Judas i'ijnari reyá i'imacá. Quéchami Jesús quemacá najló: —Ina'uquéjloje penaje i'imacá nucá. Chuhua cajrú ina'uqué hue'epíjica palá la'ajérica nucá. Ñaqué caja nahue'epíjica meque palá huani Tupana la'acá ina'uqué nupalamane. ");
INSERT INTO ycn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ina'uquéjloje penaje i'imacá nucá. Nacaje nula'acá aú ina'uqué pechu i'imá palá Tupana nacú. Chuhua Tupana la'ajica nacaje, ina'uqué pechu i'imachi palá caja nunacu raú. Yehuíchaja rila'ajica ricá numacare nacú. ");
INSERT INTO ycn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nujhua'atéjena, chuhua uncá nu'umalaje júpija ijhua'até maare eja'ahuá chu. Icá culájeño nu'umajica. Numacá judíonajlo i'imacá que caja numacá ijló. Uncá meño'ojó i'ijnalaje nu'ujnajica ejo me'etení. ");
INSERT INTO ycn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chuhua nuhuacára'a ila'acá nacaje, huajé numacá rinacu: Ihuata íqui'ija pecohuácaca. Iqui'ija nuhuátaca icá que caja ihuátaca pecohuácaca. ");
INSERT INTO ycn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Iqui'ija ihuá pechu i'imá palá Tupana nacútaca pecohuácaca aú piyuque ina'uqué hue'epéjeño nujhua'atéjenaca icá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","E Pedro quemari Jesusjlo: —¿Hue'emacana, meño'ojó chi pi'ijnajé me'etení? Jesús quemari rijló: —Nu'ujnajica ejo, uncá meño'ojó pi'ijnalaje nujhua'até me'etení. Nópumi chu pi'ijnajé rejo. ");
INSERT INTO ycn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro quemari rijló: —Nu'umacana, ¿naje uncá meño'ojó nu'ujnalá pijhua'até me'etení pi'ijnajica ejo? Apala nenoje nucá, pijhua'ateje nu'umacale. E'iyonaja calé nuhuata pijhua'até i'ijnacana —que Pedro quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Raú Jesús quemari rijló: —¿E chi quehuaca pimacá nojló? Numá pijló, pimicho'otájica nuchaya hueji que pe uncá chiyó capere yaca'á —que rimacá rijló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Ipechu i'imaniya camu'ují. Ipechu i'imá Tupana chojé caphí, nochojé quele. ");
INSERT INTO ycn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Re cajrú pucunaji Nora'apá i'imacá e, ina'uqué i'imacáloje re penaje. Uncá numalajla ijló, uncáquela ri'imalajla ñaqué. Ñaquele nu'ujnajé pucunaji lamá'ataje ipé penaje. ");
INSERT INTO ycn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nu'ujnajé itucumá apucuna lamá'ataje ipé. Quéchami nupa'ajico piño majó ihuá'aje nujhua'ató, i'imacáloje rejé nujhua'até penaje. ");
INSERT INTO ycn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Icá hue'epiño meño'ojoca nu'ujnajica maare eyá. Ihue'epí caja méqueca iná la'acá, iná i'ijnacáloje rejo penaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aú Tomás quemari rijló: —Hue'emacana, uncá huahue'epila meño'ojoca pi'ijnajica. ¿Meque la'ajé chi iná hue'epícajla rejo i'ijnacana nacojé? ");
INSERT INTO ycn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús quemari rijló: —Tupana ejo ina'uqué huá'ajeri nucá. Quehuácaje puráca'aloji yucuna i'imajeri caja nucá. Uncá tajnácajo penaje calé cajmuchaji a'ajeri nucá. Uncá na calé i'ijnajeri Nora'apá ejo. Caphí péchuruna nochojé, queleja i'ijnajeño Nora'apá ejo. ");
INSERT INTO ycn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ihue'epíquela na ina'uqueca nucá, ihue'epijla caja naca Tupana. Chuhuaca ihue'epica naca ricá; caja amá ricá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Raú Felipe quemari rijló: —Hue'emacana, piya'atá huajló Para'apá, huamachi ricá, palá huapechu i'imacáloje raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús quemari rijló: —Felipe, ijhua'até po nucá júpicha huani. ¿Uncá chi pihue'epila na ina'uqueca nucá? Amari nucá, amari caja Nora'apá, Tupana. Eta, ¿Naje pimá nojló ilé que? ");
INSERT INTO ycn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nora'apá pechu que caja nupechu; nupechu que caja ripechu. Pajluhuaja pechu que caja huapechu rijhua'até. Uncá nuliyoja calé numacá nacaje nacú ijló. Nora'apá pechu que caja nupechu. Ñaquele rihuacára'a nula'acá nacaje rihuátacare caje. ");
INSERT INTO ycn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nora'apá pechu que caja nupechu; nupechu que caja ripechu. Jema'á no'opiyá. Uncaja que jema'á no'opiyá numacá que nunacuhuá, jema'á no'opiyá amácale nula'acá cajrú nacaje uncá meño'ojó ina'uqué la'alare caje. ");
INSERT INTO ycn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jema'á marí: Ina'uqué pechu i'imajica ee nochojé caphí, necá caja la'ajeño nacaje nula'acá que caja. Nuchaje nala'ajica nacaje, nu'ujnajícale Nora'apá ejo. ");
INSERT INTO ycn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Iquejá'a nacaje nuliyá nupuráca'alo aú, e no'ojé ijló ricá. Nucá, Tupana I'irí, la'ajeri nacaje ijló, ina'uqué hue'epícaloje raú piyuque nacaje la'ajérica Nora'apá, Tupana. ");
INSERT INTO ycn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Piyuque nacaje iquejá'aje nuliyá nupuráca'alo aú, no'ojé ijló ricá —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","E Jesús quemari piño najló: —Iqui'ija ihuátacachu nucá, a'ajé inacojó nupuráca'alo. ");
INSERT INTO ycn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nucá quemájeri Nora'apajlo, rihuacára'acaloje apú piño majó penaje. Ri'imacáloje ijhua'até hua'ajini huani ipechu pala'atájeri penaje, iñaté a'ajeri penaje. ");
INSERT INTO ycn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tupana Pechu ricá numá nacú. Ricá jehuíña'atajeri ina'uqué quehuácaje puráca'aloji nacú. Uncá Tupana a'alaje uncá jema'alaño ra'apiyajlo Ripechu, uncale nahue'epila ricá. Icaja calé hue'epiño ricá, ri'imacale ijhua'até. Ri'imajé caja e'iyá hua'ajini huani. ");
INSERT INTO ycn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Uncá nuyurílaje icá cupáquejanami que maare. Nupa'ajó piño majó, nu'umacáloje ijhua'até penaje. ");
INSERT INTO ycn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mequetana i'imajemi uncá ajopana ina'uqué amálajeño nucá. Necá, uncá jema'alaño no'opiyá numá nacú. Icaja calé amájeño piño nucá. Icá i'imajeño hua'ajini huani nujhua'até, uncá tajnácajo penaje calé nu'umacale. ");
INSERT INTO ycn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tupana Pechu i'imajica e'iyá huacajé ihue'epeje Tupana hua'ateje nucá. Ihue'epeje nujhua'até icá, nu'umacá ijhua'até que caja. ");
INSERT INTO ycn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Iná hue'epí mecajenaca huátaño nucá íqui'ija. Nahue'epí nupuráca'alo nacojé. Rimacá que la'acaño caja necá. Marí cajena huátaño nucá íqui'ija. Tupana huátari caja íqui'ija necá, huátaño nucá íqui'ija. Ñaqué caja nuhuátajica necá íqui'ija. Nula'ajé napechu palá, nahue'epícaloje na ina'uqueca nucá raú penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","—E Judas (uncá Judas Iscariote calé ri'imacá), quemari rijló: —Hue'emacana, pila'ajé huapechu palá, huahue'epichi na ina'uqueca picá. Eyá necá uncá jema'alaño pa'apiyá ¿naje uncá pila'alaje napechu palá ñaqué caja? —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús quemari rijló: —Iqui'ija huátaca nucá, a'arí nupuráca'alo rinacojó. Nora'apá hua'até huajhué caja ricá. Raú nucá, Nora'apá hua'até huajhué caja ricá. Raú, nucá, Nora'apá hua'até i'imaño rijhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Uncá huátala nucá íqui'ija, uncá caja a'alá rinacojó nupuráca'alo. Nupuráca'alo jema'acare, uncá nule'ejé calé ricá. Huacára'ari nucá majó le'ejé ricá. ");
INSERT INTO ycn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Marí que numacá ijló nacaje nacú me'etení, nu'umacá maárohua ijhua'até quetana. ");
INSERT INTO ycn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nora'apá huacára'ajeri ijló Ripechu nupuráca'alo aú, ra'acáloje iñaté penaje, ripala'atácaloje ipechu penaje. Ricá jehuíña'atajeri icá piyuque nacaje nacú. Rila'ajé ipechu palá, ihue'epícaloje nacaje nacojé numacare nacú ijló penaje. ");
INSERT INTO ycn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nula'á ipechu palá, ihuó ca'acó piyá nacaje hua'até. Ipechu i'imacáloje nupechu que caja, penaje nula'á ipechu palá. Uncá nula'alá ipechu uncá jema'alaño Tupana ja'apiyá la'acá ajopana pechu que caja. Ila'aniya ipéchuhua ujhuí nacaje nacú. Iquero'oniyo caja. ");
INSERT INTO ycn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nu'ujnañáajica icá; quéchami nupa'ajico piño majó, nu'umacáloje ijhua'até penaje. Caja nu'umá ijló nupa'ajico Nora'apá ejo yucuna. Iqui'ija ihuátaquela nucá, pu'ují ipechu i'imacajla riyucuna jema'acana aú. Pu'ují ipechu i'imacajla, nuchaje huani Nora'apá i'imacale. ");
INSERT INTO ycn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Uncá chiyó ri'imá ñaqué, nu'umá riyucuna ijló. Ri'imajica quéchami, ipechu i'imacáloje caphí nochojé raú penaje nu'umá ijló riyucuna. ");
INSERT INTO ycn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Uncá nupura'alajo cajrú ijhua'até me'etení. Uncá jema'alaño no'opiyá, huacára'ajeri huaícha chuhua. Uncá nuchá'atajeri calé ricá. ");
INSERT INTO ycn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nucá la'arí Nora'apá huacára'aca que, ina'uqué hue'epícaloje raú íqui'ija nuhuátaca Nora'apá. Chuhuaca jácho'o, hue'ejnachi maáreya —que Jesús quemacá ra'apiyatéjenajlo. ");
INSERT INTO ycn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Marí que Jesús jehuíña'ataca ra'apiyatéjena: —Cajmú ina i'imacá ri'ichejlo que caja nucá ijló. Rina lamára'atajeri que caja Nora'apá. ");
INSERT INTO ycn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Cajmú arúca'ari rihuirulá chiyá ri'iché naquiyá. Ri'iché que caja nojló nujhua'atéjena. Uncá la'alaño Nora'apá huátaca que, ri'iché mecharú que caja nojló necá. Iná ca'acá rihuiná quechani e'iyayá, que caja Nora'apá ca'acá ajopana ina'uqué e'iyayá necá, uncá la'alaño rihuátaca que. Eyá Nora'apá huátaca que la'ajeño, ri'iché quechani que caja necá rijló. Nora'apá ca'arí pu'uhuaré nala'acare palá la'acaño liyá, richaje nala'acáloje palá penaje. Iná ca'acá pu'uhuaré caje quechani e'iyayá, que caja Nora'apá ca'acá palá la'acaño pechu naquiyá pu'uhuaré nala'acare. Marí que ricá rihuiná quechani e'iyayá, que caja Nora'apá ca'acá ajopana ina'uqué e'iyayá necá, uncá la'alaño rihuátaca que. Eyá Nora'apá la'acá, richaje, richaje que nala'acáloje palá raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Caja Nora'apá ca'arí inaquiyá pu'uhuaré ila'acare, a'acale inacojó nupuráca'alo. ");
INSERT INTO ycn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Iyuríniya nujhua'até i'imacana, nu'umacáloje ijhua'até iñaté a'ajeri penaje. Uncá meño'ojó cajmú arúca'ala richa ri'iché naquiyá ricoja, uncachu ri'iché i'imalá rinaquiyá. Ñaqué caja ijló ricá. Uncá meño'ojó ila'alá Nora'apá huátaca que ipechu queja. Nucá a'ajeri iñaté rihuátaca que la'acana aú, uncaja que jácho'o nujhua'atéjena i'imacana chiyá. ");
INSERT INTO ycn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Paijí ina i'imacá ri'ichejlo que caja ijló nucá. Ri'iché i'imacá rínajlo que caja nojló icá. Pajhua'atéchaca que huala'acachu nacaje ijhua'até, palá huani ila'acá nacaje Nora'apá huátaca que raú. Uncá meque la'ajé ila'alá nacaje rihuátaca que ipechu queja. No'ojica ee iñaté, ila'ajé nacaje rihuátaca que. ");
INSERT INTO ycn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nujhua'atéjena naquiyana jácho'ojico ee nujhua'atéjena i'imacana chiyá, ne'emajé cupáquejanami que nuliyá. A'ahuaná i'ichemi, júpimi que namata'acare, que caja ne'emajica. Ne'emajica ri'ichemi macajreni que najña'acare, nacupácaloje ricá siyá chojé penaje. ");
INSERT INTO ycn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Uncájica ee jácho'o nujhua'atéjena i'imacana chiyá, iquejá'aje nacaje nuliyá ihuátacare caje, e no'ojé ijló ricá. Uncájica ee jácho'o nupuráca'alo ja'apiyá i'imacana chiyá, no'ojé ijló nacaje iquejá'acare nuliyá. ");
INSERT INTO ycn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ina'uqué pechu i'imá palá Nora'apá nacú namaca aú ila'acá palá. Raú caja nahue'epí nujhua'atéjena huani icá. ");
INSERT INTO ycn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Iqui'ija Nora'apá huátaca nucá. Ñaqué caja nuhuátaca icá. Iyuríniya no'opiyá jema'acana, nuhuátacaloje icá íqui'ija ñaqueja penaje. ");
INSERT INTO ycn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","A'ajica ee inacojó nupuráca'alo, nuhuajhuénaja i'imajica ñaqueja. Ñaqué caja nojló ricá; noma'á Nora'apá ja'apiyá. Aú calé ñaqueja rihuajhué nucá. ");
INSERT INTO ycn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Marí que numacá ijló, ihue'epícaloje rinacojé penaje, ipechu i'imacáloje pu'ují raú penaje. Nupechu i'imacá pu'ují que caja ipechu i'imacáloje raú penaje numá ijló. ");
INSERT INTO ycn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Marí que nuhuacára'aca icá me'etení: Ihuata íqui'ija pecohuácaca. Iqui'ija nuhuátaca icá ejeja ihuátaca pecohuácaca. ");
INSERT INTO ycn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Apú taca'arí ca'ajná ina'uqué rihuajhuena chaya, ne'emacóloje capichácajo liyá raú penaje. Raú iná hue'epí quehuácaca rihuajhuena necá. Uncá meño'ojó iná la'alá palani nacaje richaje palaca iná huajhuénajlo. ");
INSERT INTO ycn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Iqui'ija nuhuátaca icá, ila'acachu nuhuacára'aca que. ");
INSERT INTO ycn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Uncá apú hua'até sápajeño que calé icá nojló. Apú hua'até sápajeño uncá hue'epílaño méqueca nacarihuate pechu nacú nacaje. Ñaquele uncá numalá inacu: “Nujhua'até sápajeño” que. Numá inacu: “Iqui'ija nuhuátacarena icá” que. Ñaquele numá ijló piyuque nacaje Nora'apá quemacare nacú nojló. ");
INSERT INTO ycn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Uncá i'ihuapala ijluhua nucá, nu'umacáloje ihuacára'ajeri penaje. Nucá i'ihuapari nujluhua icá ajopana ina'uqué e'iyayá, ila'acáloje piyuque huani nacaje Nora'apá huátaca que penaje. Marí caje aú uncá nacaje ila'acare palá capichálajo. Ñaquele Nora'apá a'ajeri ijló piyuque nacaje, iquejá'ajicare riliyá nupuráca'alo aú. ");
INSERT INTO ycn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Marí que calé nuhuacára'aca icá me'etení: Ihuata íqui'ija pecohuácaca —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesús quemari piño najló: —Apala ina'uqué, uncá jema'alaño Tupana ja'apiyá, pechu i'imajica inacu chapú. Jema'á marí: Ñaqué caja napechu i'imacá nunacu ipiyá. ");
INSERT INTO ycn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Uncá Tupana ja'apiyá jema'ajeño calé i'imaquela, nahuátajla icá íqui'i. Nahuátaca nanaquiyana que caja nahuátacajla icá. E'iyonaja calé nucá i'ihuapari nujluhua icá ne'iyayá. Ñaquele chapú nahuó ichá raú, uncale i'imalá necá que caja. ");
INSERT INTO ycn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ihue'epí meque numacá ijló i'imacá. Numá ijló: “Iná sápacare hua'até, ricá i'imari iná chaje”. Nala'á nucá chapú; ñaqué caja nala'ajica icá chapú. Ne'iyajena jema'añó nupuráca'alo ja'apiyá; ñaqué caja ne'iyajena jema'ajica ipuráca'alo ja'apiyá. ");
INSERT INTO ycn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Uncá jema'alaño Nora'apá ja'apiyá la'ajeño icá chapú, jema'acale no'opiyá. Uncá nahue'epila naca Nuhuacára'ajeri. Aú calé nala'á chapú icá. ");
INSERT INTO ycn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Uncáquela nu'umalajla najló pu'uhuaré nala'acare yucuna, uncá nahue'epílajla rinacojé. Caja nu'umá najló riyucuna. Chuhua uncá meño'ojó nemalá nanacuhuá marí que: “Uncá huahue'epila rinacojé” que. ");
INSERT INTO ycn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Chapú ina'uqué pechu i'imacachu nunacu, ñaqué caja chapú napechu Nora'apá nacú. ");
INSERT INTO ycn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nula'á ne'iyá nacaje uncá apú hue'epílare la'acana. Raú nahue'epícajla naca nucá. E'iyonaja uncá nahuátala nucá. Uncá caja nahuátala Nora'apá. Aú pu'uhuaré la'acaño necá. ");
INSERT INTO ycn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tupana puráca'alo, Moisesmi chu lana'acare quemacá que nanacu, queja necá. Marí que rimacá nanacu: “Uncá na calé nula'á, nayúcha'acoloje nuchá penaje. E'iyonaja nayúcha'ajo nuchá”. ");
INSERT INTO ycn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Nuhuacára'aje ijló Nora'apá Pechu. Ripechu quemari ina'uquejlo quehuácaje puráca'aloji nacú. Iñaté a'ajeri penaje caja ricá. Ipechu pala'atájeri penaje caja ricá. Ripechu i'imajeri ijló nuyucuna riphájica majó penaje. ");
INSERT INTO ycn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Icá caja i'imajeño nuyucuna ajopánajlo. Nuqueño'ocá ina'uqué jehuíña'atacana huacajé eyá maárejecha icá nujhua'até. Ñaquele i'imajé nuyucuna ajopana, ajopánajlo que —que Jesús quemacá ra'apiyatéjenajlo i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","E Jesús quemari piño najló marí que: —Marí que numacá ijló me'etení, iyurica piyá no'opiyá jema'acana quéchami. ");
INSERT INTO ycn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Uncá nayurílaje jahuacaco najhua'até jahuacáca'alo ñacarelana chojé. Aquijñojo i'imajica huacajé marí que napechu i'imajica inacu: “Nenócana aú huala'á Tupana huátaca que”. ");
INSERT INTO ycn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Marí que nala'ajica icá chapú, uncale nahue'epila naca Nora'apá. Uncá caja nahue'epila naca nucá. ");
INSERT INTO ycn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Numá ijló rinacu me'etení, caja queja ri'imajica ee, riphaje ipechu nacojé. —Iqueño'ocá nujhua'até chira'acano huacajé eyá maárejecha, uncá nu'umalá ijló riyucuna, nu'umacale ijhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nu'ujnajé chuhua, nu'umacáloje Nora'apá hua'até penaje. Ricá huacára'ari nucá majó i'imacá. Uncá na inaquiyana quemalá nojló: “¿Meño'ojó pi'ijnajé?” que. ");
INSERT INTO ycn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nuhue'epí camu'ují huani ipechu li'ichaco, numíchaca aú ijló marí que. ");
INSERT INTO ycn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Jema'á marí: Palani ri'imajica ijlojé penaje, nu'ujnañáajica icá ee. Uncáquela nu'ujnalajla maáreya, uncá Tupana Pechu iphálajla majó iñaté a'ajeri penaje, ipechu pala'atájeri penaje. Ñaquele nu'ujnajé rejo. Reyá i'imajemi nuhuacára'aje ricá majó. ");
INSERT INTO ycn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Riphájica penaje rica'átaje ina'uqué e'iyajé, nahue'epícaloje raú pu'uhuaré la'ajéñoca necá penaje. Rehuíña'ataje caja ina'uqué, nahue'epícaloje Tupana i'imacá nañaté a'ajeri penaje, nala'acáloje palá raú penaje ripalamane. Méqueca Tupana huajájica pu'uhuaré la'ajeño, nacú rimaje caja ina'uquejlo. ");
INSERT INTO ycn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Rimaje caja najló, nahue'epícaloje raú pu'uhuaré la'ajéñoca necá, uncale napechu i'imalá caphí nochojé. ");
INSERT INTO ycn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Rimaje caja najló, nahue'epícaloje méqueca palá la'acana penaje. Marí que ri'imajica ijló, nu'ujnajícale Nora'apá ejo. Uncá amálaje nucá maárohua. ");
INSERT INTO ycn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Caja Tupana chá'atari Jiñá Chi'ináricana. Tupana huajájeri ricá, rijhua'atéjena hua'até. Tupana Pechu quemájeri ina'uquejlo, nahue'epícaloje méqueca iná la'acá, iná i'imacóloje Tupana huajájica ina'uqué liyá penaje —que Jesús i'imacá Tupana Pechu yucuna najló. ");
INSERT INTO ycn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Re caja jo'ó apú, cajrú nacaje nuhuátacare quemacana nacú ijló. E'iyonaja uncá meño'ojó jema'alá piyuque huani me'etení. ");
INSERT INTO ycn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Quehuácaje puráca'aloji nacú pura'ajero Tupana Pechu. Riphájica penaje rehuíña'atajica icá piyuqueja quehuácaje puráca'aloji nacú. Uncá ripura'alajo ripechu queja ijhua'até. Nora'apá ja'apiyá queja rimájica nacaje nacú. Nacaje i'imajícare yucuna ri'imajé ijló. ");
INSERT INTO ycn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tupana Pechu la'ajeri ipechu palá, ipechu i'imacáloje palá nunacu raú penaje. Marí que rila'ajica ipechu, ra'apátajicale ijló nupuráca'alo no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Palani puráca'aloji aú nemá Nora'apá nacú; ñaque caja nemacá nunacu. Ñaquele numá ijló, Tupana Pechu ja'apátajeri ijló nupuráca'alo no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Mequetana i'imajemi uncá amálaje nucá maárohua, nu'ujnajícale Nora'apá i'imacá ejo. Eyá mequetana i'imajemi amaje piño nucá —que Jesús quemacá ra'apiyatéjenajlo. ");
INSERT INTO ycn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Marí caje aú ra'apiyatéjena quemaño pajlocaca: —¿Meque quemacana cari rimíchaje nacú huajló: “Mequetana i'imajemi uncá amálaje nucá, quéchami mequetana i'imajemi amaje piño nucá?” Eyá rimicha piño: “Nu'ujnajé Nora'apá i'imacá ejo”. ¿Meque chi cari rimíchaje nacú huajló? ");
INSERT INTO ycn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Meque quemacánaca ca'ajná rimíchaca: “Mequetánaja i'imajemi?” que. Uncá riphálacha huapechu nacojé —que nemacá pajlocaca. ");
INSERT INTO ycn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús hue'epiri nahuátaca riyucuna quejá'acana riliyá. Raú rimá najló: —Caja numicha ijló: “Mequetana i'imajemi uncá amálaje nucá maárohua. Rejomi mequetana i'imajemi amaje piño nucá maare”. ¿Riyucuna chi iquejá'aca paliyácaca? —que rimacá najló—. ");
INSERT INTO ycn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Jema'á marí: Icá iyájeño nu'umajica. Camu'ují ipechu la'ajico nuyámijo. Eyá ajopana, uncá jema'alaño Tupana ja'apiyá, necá péchuja calé i'imajé pu'ují. Icaja calé pechu i'imajé camu'ují. Chapú caje ja'apájica iliyá ejomi ipechu i'imajé piño pu'ují. ");
INSERT INTO ycn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Inanaru huá'aca ru'urí huacajé romá quehuini yajhué. Rimoto'ocá ejomi caja riquiyá ja'apari ruliyá. Pu'ují rupechu la'acó romaca aú ru'urí. ");
INSERT INTO ycn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ñaqué caja ri'imajica ijló. Me'etenija calé amájica chapú caje yajhué. Nutaca'ajica ejomi numacápo'ojo piño. Ejomi nupa'ajó piño majó amaje. Ejéchami caja pu'ují huani ipechu i'imajica. Uncá meque nala'alaje icá, ipechu i'imacá piyá pu'ují. ");
INSERT INTO ycn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Rihuacajé uncá iquejá'alaje nacaje yucuna nuliyá. Jema'á marí: Nupuráca'alo aú Nora'apá a'ajeri ijló piyuque nacaje iquejá'ajicare riliyá. ");
INSERT INTO ycn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Maárejecha uncá jo'ó iquejá'ala nacaje Nora'apá liyá nupuráca'alo aú. Iquejá'aje riliyá nacaje. E ra'ajé ijló ricá, pu'ují ipechu i'imacáloje raú penaje —que Jesús quemacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","E Jesús quemari piño najló marí que: —Yucu caje nu'umá ijló, nohuíña'atacaloje icá nacaje nacú penaje. Aquijñojo i'imajica huacajé uncá nohuíña'atalaje icá yucu caje aú. Pu'ucuja nu'umajica Nora'apá yucuna ijló. ");
INSERT INTO ycn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Rihuacajé iquejá'aje nacaje Nora'apá liyá nupuráca'alo aú. Uncá numalaje rijló, ra'acáloje ijló nacaje penaje. ");
INSERT INTO ycn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Icá icó quejá'ajica riliyá nacaje, rihuátacale icá íqui'ija. Icá huajhué nucá. Icá hue'epiño nuphaca Tupana eyá i'imacá. Aú calé Nora'apá huajhuena icá. ");
INSERT INTO ycn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nora'apá ahua'ayá nócho'o i'imacá, nu'ujnacáloje marí eja'ahuá chojé penaje. Chuhua nócho'ojico marí eja'ahuá chiyá, nupa'acóloje Nora'apá ejo penaje —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Raú ra'apiyatéjena quemaño rijló: —Chuhua ta pu'ucuja pi'imacá riyucuna huajló. Uncá pi'imalá yucu caje huajló, pehuíña'atacaloje huecá penaje. ");
INSERT INTO ycn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Chuhua huahue'epí picá hue'epica piyuqueja nacaje nacojé. Uncá naje calé apú quemari pijló nacaje nacú. Aú calé huemá pinacu, Tupana eyaje picá —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús quemari najló: —¿Chuhua chi a'acá inacojó nupuráca'alo? ");
INSERT INTO ycn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Caja riphicha rená chojé. Napatájica ee nucá, macajmala itamáca'atajico paliyácaca. Iyureje nucá nocoja. E'iyonaja uncá nuyurílajo nocoja, Nora'apá i'imajeri nujhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Marí que numacá ijló, ipechu i'imacáloje palá raú penaje. Maare eja'ahuá chu iná ña'acá chapú caje panacu. Rihuacajé ila'ajé ipéchuhua caphí nochojé. Raú ipechu i'imajé palá re'iyá. Palá ipechu i'imacá, nuchá'atacale ijló Jiñá Chi'ináricana. Pu'uhuaré la'acaño huacára'ajeri ricá —que Jesús quemacá ra'apiyatéjenajlo. ");
INSERT INTO ycn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Marí que Jesús quemacá najló i'imacá. Ejomi riyacá'o je'echú chojé. E rimá marí que Tupánajlo: —Pa'ayú, caja riphicha rená chojé pimacare nacú nojló i'imacá. Pila'á nucá palá, ina'uqué hue'epícaloje raú nupalamane aú ne'emajica palá penaje. Raú caja nahue'epeje pipalamane aú ne'emajica palá. ");
INSERT INTO ycn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Picá a'arí nucá, Pi'irí, piyuque ina'uqué huacára'ajeri penaje, no'ocáloje najló cajmuchaji penaje, ne'emacáloje matajnaco raú penaje. Ina'uqué pa'acárena nojló, i'imacáñojlo no'ojé ricá. ");
INSERT INTO ycn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Hue'epiño huecá pijhua'até, i'imajeño matajnaco huajhua'até je'echú chu. Picá, pajluhuaja calé iná Chi'ináricana. Pihuacára'acare majó nucá. ");
INSERT INTO ycn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Nacaje nula'acare marí eja'ahuá chu aú ina'uqué hue'epiño picá. Caja nuñapata piyuque nacaje la'acana pihuacára'aca nucá que. ");
INSERT INTO ycn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nu'umajica pahua'á quéchami pa'á nucá, nu'umacáloje picá que caja cajruni penaje. Uncá chiyó eja'ahuá i'imacá huacajé, cajruni nu'umacá pahua'á. ");
INSERT INTO ycn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Pi'ihuapá pijluhua ina'uqué ajopana e'iyayá i'imacá, pa'acáloje nojló necá nujhua'atéjena penaje. Caja nula'á napechu palá, nahue'epícaloje raú naca picá penaje. Caja chuhua pijhua'atéjena necá. Picá a'arí nojló ne'emacá. Necá a'añó nanacojó pipuráca'alo. ");
INSERT INTO ycn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Caja nahue'epí picá a'acá nuñaté piyuque nacaje nula'acare aú. Piyuque nacaje numacare nacú ina'uquejlo no'opata najló pa'apiyá. ");
INSERT INTO ycn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pipuráca'alo noma'acare pa'apiyá, no'opata najló ricá. Nema'á ra'apiyá. Raú nahue'epí pihuacára'acare reyá majó nu'umacá. ");
INSERT INTO ycn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Picá a'arí nojló ina'uqué naquiyana, ne'emacáloje nujhua'atéjena penaje. Numá pijló nanacu, pa'achí nañaté, pijhua'atéjena caja ne'emacale. Necá nacuja calé numá pijló, pa'acáloje nañaté penaje. Eyá ajopana, uncá pa'apiyá jema'ajeño calé necá, uncá numalá pijló, pa'acáloje nañaté penaje. ");
INSERT INTO ycn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Piyuqueja nujhua'atéjena, pijhua'atéjena caja necá. Huajhua'atéjena necá piyuqueja. Palá huajhua'atéjena pechu nunacu, nupalamane ne'emacale. ");
INSERT INTO ycn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Caja chuhua uncá nu'umalaje marí eja'ahuá chu. Necaja calé, huajhua'atéjena, yuréjeño maare. Nucá pa'ajero, nu'umacáloje pijhua'até penaje. Pa'ayú, uncá la'alare pu'uhuaré picá, pipechu aú ja pa'á pinacojó necá. Rejenohuaja huapechu pijhua'até. Ñaqué caja napechu i'imacáloje penaje, pa'á pinacojó necá. ");
INSERT INTO ycn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Marí eja'ahuá chu nu'umacá quetana no'ocá nunacojó necá pa'acárena nojló. Pipalamane aú no'ó nunacojó necá. Numejñata necá. Uncá na calé nanaquiyana pa'acárena nojló capichájero ne'iyayá. Re pajluhuaja, ricaja calé, capichájero ne'iyayá. Ñaqué penaje rimoto'ó i'imacá. Ricapichajo piliyá, pipuráca'alo lana'aquéjami quemacá rinacu queja ricapichájico piliyá. ");
INSERT INTO ycn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Chuhua nu'ujnajica ilé pi'imacá ejo. Numá pijló marí que, ejo'ocaja nucá najhua'até maare. Marí numá nacú, pu'ují huani napechu i'imacáloje nupechu que caja raú penaje. ");
INSERT INTO ycn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","No'opata najló pipuráca'alo. Nupechu que caja napechu. Uncá ajopana ina'uqué pechu que calé nupechu. Ajopana ina'uqué, uncá hue'epílaño picá, numá nacú. Chapú napechu nujhua'atéjena nacú, uncá pachá napechu i'imalá napechu que caja. ");
INSERT INTO ycn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Uncá numalá pijló, pihuá'acaloje nujhua'atéjena marí eja'ahuá chiyá penaje. Numá pijló, pamácaloje naliyá Jiñá Chi'ináricana penaje, nala'acá piyá pu'uhuaré, namanaicho caje. ");
INSERT INTO ycn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Uncá ajopana ina'uqué pechu que calé nupechu. Uncá caja napechu que calé nujhua'atéjena pechu. Nupechu que caja péchuruna necá nujhua'atéjena. ");
INSERT INTO ycn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Quehuaca pipuráca'alo. Pila'á necá palá raú, nala'acáloje pihuátaca que penaje. ");
INSERT INTO ycn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Picá huacára'ari nucá, ina'uqué uncá hue'epílaño picá e'iyajé, nu'umacáloje piyucuna najló penaje. Ñaqué caja nuhuacára'aca ne'ejnacá ina'uqué e'iyajé, uncá hue'epílaño picá e'iyajé, piyucuna i'imajé najló. ");
INSERT INTO ycn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Najlojé penaje no'ó nocó pijló, na'acáloje caja necó pijló penaje, nahue'epícaloje natucumó pihuátaca que la'acana penaje. ");
INSERT INTO ycn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Numá pijló, pa'achí mariruna ñaté. Uncá necaja calé numá nacú pijló. No'opiyá jema'ajeño i'imajícaño penájena numá caja nacú. Nema'ajé no'opiyá me'etení i'imacaño puráca'alo jema'acana aú. ");
INSERT INTO ycn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Numá pijló, eco pa'á nañaté, napechu i'imachi rejenohuaja pajhua'atéchaca. Ne'emacáloje pajluhuaja yaní queja pajhua'atéchaca penaje. Pipechu que caja nupechu. Nupechu que caja péchuri picá. Pa'ayú, pa'á nañaté, napechu i'imachi huapechu que caja. Raú ajopana ina'uqué hue'epéjeño pihuacára'aca nu'umacá. ");
INSERT INTO ycn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Picá la'arí nucá palá. Raú ajopana ina'uqué hue'epiño pu'ují pipechu nunacu. Ñaqué caja nula'acá necá palá, ajopana ina'uqué hue'epícaloje raú pu'ujica nupechu nanacu. Marí que nula'acá necá, napechu i'imacáloje rejenohuaja penaje. Rejenohuaja caja huapechu pajhua'atéchaca. Napechu i'imacáloje ñaqué caja penaje, nula'á necá palá. ");
INSERT INTO ycn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Najhua'até nucá; nujhua'até caja picá. Marí que huecá, ne'emacáloje huajhua'atéjena penaje. Marí caje aú ajopana ina'uqué hue'epiño pihuacára'acare nu'umacá. Nahue'epí caja raú íqui'ija huani pihuátaca necá, pihuátaca nucá que caja. ");
INSERT INTO ycn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Nora'apá, picá a'arí necá nojló, ne'emacáloje caphí péchuruna nochojé penaje. Nuhuata ne'emacá nujhua'até aquijñojo je'echú chu, namácaloje meque palá huani pila'acá nucá penaje. Uncá chiyó piqueño'óta eja'ahuá, piyuqueja nacaje hua'ató, pihuata nucá íqui'ija i'imacá. Aú calé pila'á palá nucá i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nora'apá, palani huani picá. Ina'uqué, uncá jema'alaño pa'apiyá, uncá hue'epílaño naca picá. Nucá hue'epiri naca picá. No'opiyatéjena hue'epiño caja pihuacára'acare majó nucá. ");
INSERT INTO ycn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nula'á napechu palá, nahue'epícaloje palá raú naca picá penaje. Ñaqueja nula'ajica napechu palá, íqui'ija nahuátacaloje pecohuácaca penaje. Iqui'ija pihuátaca nucá que caja nahuátajica pecohuácaca íqui'ija, Nupechu i'imacáloje ne'iyá raú penaje —marí que Jesús pura'acó Tupana hua'até i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Caja marí que Jesús pura'acó Tupana hua'até i'imacá. Quéchami ri'ijnacá ra'apiyatéjena hua'até ají que ina'atana pa'anajo pitá. Ina'atana ií Cedrón. A'ahuaná ejátaquejami i'imari re. Rejo Jesús i'ijnari richape ra'apiyatéjena hua'até. ");
INSERT INTO ycn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Rejo nahuacácono ra'apiyatéjena hua'até. Júdasja calé uncá i'imalá re najhua'até. Ajopana hua'até ri'imá, ra'acáloje Jesús ripinánajlo penaje. Rihue'epí ne'ejnacá rejo, aú rihuá'a ripinana rejo. ");
INSERT INTO ycn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","E caja cajrú ajopana ina'uqué iphaño nanacu Judas hua'até. Cajrú surárana, policíana, quele hua'até riphá i'imacá. Sacerdótena huacára'ajeño, fariséona, quele puráca'alo aú ne'ejná rejo rijhua'até i'imacá. Nalecare hua'até nephá rejo. Cajrú nacamaré, jepé caje i'imacá nacapi. ");
INSERT INTO ycn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Caja Jesús hue'epíchami na penájeca ne'ejnacá. Ñaquele nephaca nanacu aú ri'ijná najimajo. Rimá najló: —¿Na iculá? ");
INSERT INTO ycn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nemá rijló: —Jesús, Nazaret eyaje, ricá huaculá. Jesús quemari najló: —Nucá po Jesús. Ripinánajlo a'ajeri, Judas, i'imari caja najhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Rimá najló: “Nucá po Jesús” que, raú na'ató te'erí e'iyajé rijimaya. ");
INSERT INTO ycn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús quemari piño najló: —¿Na iculá? Nemá piño: —Jesús, Nazaret eyaje, ricá huaculá. ");
INSERT INTO ycn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Raú Jesús quemari najló: —Caja numicha ijló, nucá po quele imá nacú. Nucá iculájica ee, iyurí no'opiyatéjena, ne'ejnachi nahuátaca ejo —que rimacá najló. —Je —que. ");
INSERT INTO ycn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Rimacá que nanacu Tupánajlo maapami que caja ri'imacá najló. Marí que rimacá rijló nanacu i'imacá: “Uncá na calé nanaquiyana pa'acárena nojló capichájero ne'iyayá.” Ñaquele rimá najló, nayurícaloje ra'apiyatéjena, ne'ejnacáloje nahuátaca ejo penaje. ");
INSERT INTO ycn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pedro i'imari caja re. Sajalu caje cúhua'aro rinacu. Ramaca aú marí que nala'acá Jesús rero'ó risajálune ra'aruná chiyá. Ricá aú rica'á pajluhuaja i'ijhuí. Ca'añá chojó pitari ri'ijhuí rimata'á matá. Rimata'acare i'ijhuí ií i'imari Malco. Sacerdótena huacára'ajeri hua'ateje ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Caja rimata'á ri'ijhuí. Raú Jesús quemari Pédrojlo: —Pipa'atá ra'arú chojé pisajálune. Re Nora'apá pechu nacú ricá, nujña'acáloje chapú caje panacu penaje. Ñaquele nujña'ajeja panacu ricá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Surárana i'imaño re nahuacára'ajeri hua'até. Judíona le'ejena policíana i'imaño caja re. Caja napatá Jesús, nahuajácaloje ricá penaje. Nepo'otá ricá. ");
INSERT INTO ycn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","E caja nahuá'a ricá ají que Anás ñacaré ejo. Caifás yana'ajú ri'imacá. Caifás i'imari sacerdótena huacára'ajeri rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ricá, Caifás, quemari marí que judíona naquiyánajlo i'imacá: “Pajluhuaja ina'uqué taca'ajeri huachaya, huacapichaco piyá piyuque huani. Marí palani huajló,” que rimacá i'imacá. Ricá ñacaré ejo nahuá'a Jesús i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro, apú Jesús ja'apiyateje hua'até, ja'apaño juca quemachi Jesús ápumi chu. Ne'ejná ají que Anás ñacaré ejo. E apú i'ijnari ají que riñacaré cópeje, Jesús ahua'ajé. Pu'ucuja rimujlúca'aca rejé, sacerdótena huacára'ajeri amána'apa ri'imacale. ");
INSERT INTO ycn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro ta uncá mujlúca'ala rijhua'até. Corral yámojoja ritajnó. Aú apú Jesús ja'apiyateje i'ijnari rinumaná hua'apheru hua'até pura'ajó rinacu. Rimá rojló: —Pijme'etá rijló rapu, rimujlúca'achi. —Je —que rumacá. Rujme'etá rapu. Aú Pedro mujlúca'ari richojé. ");
INSERT INTO ycn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Quéchami rinumaná hua'apheru quemacá Pédrojlo: —¿Ilé ina'uqué napatacare ja'apiyateje chi picá? Pedro quemari rojló: —Uncá ra'apiyateje calé nucá. ");
INSERT INTO ycn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ehuá ipe'ení noca necá. Aú nahuacára'ajeri hua'até sápajeño, policíana cajena, apho'otaño siyá. Rilucúna'o palá. Quéchami na'anapacá rahua'á Pedro hua'até. ");
INSERT INTO ycn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sacerdótena huacára'ajeri queño'orí nacaje yucuna quejá'acana Jesús liyá. Rimá rijló: —¿Mecajena chi pa'apiyatéjena? ¿Na nacú chi pehuíña'ata ina'uqué? —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús quemari rijló: —Iqui'iruna ina'uqué e'iyá nupura'ó nacaje nacú. Capinaca nohuíña'atajica ina'uqué nahuacáca'alo ñacarelana chu, Tupana ñacaré chu hua'ató. Meño'ojoca judíona jahuacácono ejé nohuíña'ataque necá. Uncá numicho'ojneja calé numájica najló nacaje nacú. ");
INSERT INTO ycn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Naje piquejá'a nacaje nohuíña'atacare necá nacú yucuna nuliyá? Piquejá'a riyucuna nupuráca'alo jema'ajeño liyá. Necá quemájeño pijló na nacuca nohuíña'ataque necá. Necá hue'epiño méqueca numacá —que Jesús quemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pajluhuaja policía tára'aro Jesús ahua'á. Tupana ñacaré hua'aphé ri'imacá. Marí que Jesús quemacá aú rijló riña'á Jesús pajimaya riyáte'ela aú. Rimá rijló: —¿Ile que chi iná a'ajipacá sacerdótena huacára'ajerijlo? ");
INSERT INTO ycn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús quemari rijló: —Pimá nojló mecajeca puráca'aloji numíchaje nacú uncá paala i'imichaca pijló. Palá numíchaca. Uncá naje calé piji'ichá nucá pajimaya —que rimacá rijló i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","E caja Anás huacára'ari nahuá'aca Jesús jepo'oqueja Caifás ejo. Caifás i'imari sacerdótena huacára'ajeri rihuacajé. ");
INSERT INTO ycn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Naculácataco Jesús nacú, a'apona que Pedro a'anapacá ajopana hua'até. E nemá rijló: —¿Uncá chi ilé ina'uqué ja'apiyateje calé picá? —Uncá nucá calé ra'apiyateje —que rimacá najló. Rimicho'otá Jesucristo chaya. ");
INSERT INTO ycn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Re caja apú i'imari. Sacerdótena huacára'ajeri hua'até sápajeri ri'imacá. Pedro mata'acare i'ijhuí ejena naquiyana ri'imacá. E rimá Pédrojlo: —¿Uncá chi nomálacha picá ya'ajná a'ahuaná ejátaquelana ejo? ");
INSERT INTO ycn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro micho'otari piño richaya. Ejéchami capere yaca'acá. ");
INSERT INTO ycn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","E caja nahuá'a Jesús Caifás ñacaré eyá ají que nachaje huacára'ajeri ñacaré ejo. E naqueño'ó me'etácaje. Uncá judíona mujlúca'alaño nachaje huacára'ajeri ñacaré chojé, ajopana te'eré eyaje ri'imacale. Aú uncá paala najló richojé mujlúca'acana. Namujlúca'aquela richojé, uncá na calé i'imarijla najló palani que, najñácaloje pascua a'ajnená penaje. Aú calé uncá namujlúca'ala richojé. ");
INSERT INTO ycn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Marí caja aú Pilato jácho'oro riñacaré chiyá najhua'até pura'ajó. E rimá najló: —¿Pu'uhuaré la'ajeri chi ricá ihuá'ichaje majó? ");
INSERT INTO ycn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nemá rijló: —Uncáquela ri'imalajla uncá ina'uquélari, uncá huajña'aláchajla ricá majó. ");
INSERT INTO ycn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Rimá najló: —Ihuá'a ricá ichajo, amáijla na pachá ihuátaca rihuajácana. Ile'ejé lana'aquéjami huacára'aca que ca'ajná ihuajaca ricá —que Pilato quemacá najló. Judíona quemaño rijló: —Palani rinócana, uncá ina'uquélari ri'imacale. E'iyonaja uncá nayurila huecá, judíona, huenócaloje ricá penaje —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesús quemari ra'apiyatéjenajlo rinacuhuá maapami que méqueca nenójica ricá. Marí que nala'acá aú ri'imá Jesús quemacá que. ");
INSERT INTO ycn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","E caja Pilato pa'aró piño riñacaré chojé. Reyá i'imajemi rihuá'a Jesús maná. Nahuá'a ricá rejo. E Pilato quemari rijló: —¿Judíona i'imacana chi picá? ");
INSERT INTO ycn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","E Jesús quemari rijló: —¿Pipechu queja chi pimacá nojló ilé que, ajopana ca'ajná i'imaño nuyucuna pijló? ");
INSERT INTO ycn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato quemari rijló: —Uncá judíona naquiyana calé nucá, ne'emacáloje piyucuna nojló penaje. Inaquiyana judíona, sacerdótena huacára'ajeño, quele huá'ichaño picá majó. ¿Pila'acale pu'uhuaré chi, nahuá'icha picá majó? ");
INSERT INTO ycn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús quemari rijló: —Uncá nahuacára'ajeri penaje calé nucá marí eja'ahuá chu. Maare nuhuacára'aquela ina'uqué, nujhua'atéjena nóquichojla nuchaya, na'acá piyá judíonajlo nucá. E'iyonaja uncá nahuacára'ajeri penaje calé nucá marí eja'ahuá chu —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Eyá Pilato quemari rijló: —¿E chi quehuaca ne'emacana huani picá? Jesús quemari rijló: —Ilé pimacá nunacu queja nucá. Nucá huitúca'ari marí eja'ahuá chojé i'imacá. Maare nomoto'ó i'imacá, numacáloje ina'uquejlo quehuácaje puráca'aloji nacú penaje. Quehuácaje puráca'aloji ja'apiyá jema'ajeño huátaño nupuráca'alo jema'acana no'opiyá. ");
INSERT INTO ycn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Raú Pilato quemari rijló: —¿Na ta chi quele quehuácaje puráca'aloji pimá nacú? —que rimacá rijló. Marí que Pilato pura'acó Jesús hua'até. Ejomi ri'ijná piño huaca'apojo judíona hua'até pura'ajó. E rimá najló: —Uncá na calé rila'á pu'uhuaré, huahuajácaloje ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pascua fiesta huacajé queja ihuátaca nócho'otaca pajluhuaja ina'uqué calajeruni chiyá ijló. ¿E ihuátaca nócho'otaca ijló judíona i'imacana penaje? ");
INSERT INTO ycn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Marí que rimacá aú najló cajrú nahuíyo'oca rijló piyuqueja. Nemá rijló: —¡Uncá ricá ta calé! Pácho'ota huajló Barrabás —que nahuíyo'oca rijló. Piro'oqueji Barrabás i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Eyá Pilato huacára'ari surárana ña'ataca Jesús. Aú nahuá'a ricá apojó, naña'atácaloje ricá penaje. Naña'atá ricá. ");
INSERT INTO ycn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ejomi surárana a'añó rihuíla'aru nacojé tujripi chipúca'atacanami. Na'á rinacojé a'arumacaji ipirálucuni quemachi. ");
INSERT INTO ycn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Quéchami ne'ejnajica rahua'ajé rajalácaje. Marí que najalácajica ricá majopeja: —Judíona i'imacana, ¿picá? Re'iyá caja naña'atá ricá pajimaya nayáte'ela aú. ");
INSERT INTO ycn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","E caja Pilato jácho'oro piño riñacaré chiyá. E rimá najló: —Nuhuá'icha piño ricá majó ijimaje. Nuhuata ihue'epica uncá rila'alá pu'uhuaré, nuhuajácaloje ricá penaje. ");
INSERT INTO ycn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","E Jesús mujlúca'ari majó najimaje. Tujripi chipúca'atacanami i'imari rihuíla'aru nacú. A'arumacaji ipirálucuni quemachi, ne'emacana a'acare rinacuhuá, i'imari caja rinacu. E Pilato quemari najló: —Iyacá'o marí ina'uqué chaje. ");
INSERT INTO ycn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Namaca aú ricá, sacerdótena huacára'ajeño, policíana, quele ja'añó jahuíyo'oje. Nemá rijló: —Chuhua pihuacára'a racúhua'atacana a'ahuaná apiyácacanami nacojé. Pihuacára'a racúhua'atacana a'ahuaná apiyácacanami nacojé —que huánija nahuíyo'oca. Raú Pilato quemari najló: —Uncá nuhue'epila na chónaca nuhuacára'acajla rinócana. Icá ta ña'ajeño ricá icó, acúhua'atacaloje ricá a'ahuaná apiyácacanami nacojé penaje. ");
INSERT INTO ycn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judíona naquiyana quemaño rijló: —Rila'acale ricó Tupana I'irí que, pachá huenoje ricá. Huapuráca'alo lana'aquéjami quemari huanacu, huenócaloje ina'uqué quemaño nanacuhuá: “Tupana I'irí nucá” que —que nemacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Rejéchami cajrú Pilato quero'ocó. ");
INSERT INTO ycn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Raú ripa'ó piño riñacaré chojé Jesús hua'até pura'ajó. E rimá rijló: —¿Mere eyaje picá? Uncá ra'ajipalá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato quemari piño rijló: —¿Naje chi uncá pa'ajipalá nojló? ¿Uncá chi pihue'epila ne'emacánaca nucá. Nuhuátaquela nuhuacára'acajla pacúhua'atacana a'ahuaná apiyácacanami nacojé ca'ajná, nócho'otacajla ca'ajná picajla naliyá? ");
INSERT INTO ycn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús quemari rijló: —Uncáquela Tupana yurílajla pihuacára'aca nula'acana ilé que, uncá meño'ojó nala'alajla nucá chapú. Ñaquele ricá, Judas, a'acare pijló nucá, la'arí chapú pichaje huani —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Raú ri'ijnatá ripéchuhua meque ca'ajná rácho'otacajla ricá naliyá. E'iyonaja cajrú huani judíona jahuíyo'oca rijló. Nala'á mahuó ricá; nemá rijló: —Pácho'otajica ee ricá, chapú pipechu i'imajica romano te'eré eyaje huacára'ajeri nacú. Huahuacára'ajeri caja ricá. Jesús la'arí rinacuhuá huahuacára'ajeri que. Aú huahue'epí chapú ripechu romano te'eré eyaje huacára'ajeri nacú —que nemacá Pilátojlo. ");
INSERT INTO ycn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Marí que nemacá aú, Pilato huacára'ari piño Jesús huá'acana huaca'apojo. E Pilato yá'aro ñáca'ajori chu. Re rimaqué ina'uqué nacú méqueca nahuajájica necá. Riyá'aquelo ií i'imari Gabata hebreo pura'acó chu. Marí que quemacánaca ricá: “Jipa ayúra'atacanami” que quemacánaca ricá napura'acó chu. ");
INSERT INTO ycn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pajluhua cala yuriro natucumá nale'ejé fiesta Pascua queño'ocóloje penaje. Yehuíchami caápu'ucu chami Pilato quemari judíonajlo: —Marí i'imacana. ");
INSERT INTO ycn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Raú nahuíyo'o rijló: —¡Rinócana palani! ¡Rinócana palani! ¡Pihuacára'a racúhua'atacana a'ahuaná apiyácacanami nacojé! —que nahuíyo'otaca rijló i'imacá. Pilato quemari najló: —¿E chi ihuátaca nuhuacára'aca i'imacana jacúhua'atacana a'ahuaná apiyácacanami nacojé? E sacerdótena huacára'ajeño quemaño rijló: —Romano naquiyana huacára'ajeri, huahuacára'ajeri caja ricá. Ricaja calé, pajluhuaja, hue'emacana. Uncá na apú i'imalá. ");
INSERT INTO ycn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Marí caje aú Pilato a'arí najló Jesús. E najña'á ricá, nacúhua'atacaloje ricá a'ahuaná apiyácacanami nacojé penaje. ");
INSERT INTO ycn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","A'ahuaná apiyácacanami rihuacúla'apa que Jesús i'ijnacá najhua'até. Ne'ejná ají que a'ajná ño'ojó yenuri ejo. Ina'uqué huíla'arumi aphinami que yenuri amácano. Gólgota rií napura'acó chu, hebreo pura'acó chu. E caja nephá rejo. ");
INSERT INTO ycn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Rejé nacúhua'ata ri'imacá a'ahuaná apiyácacanami nacojé. Rahua'á iyámaja pumitanó nacúhua'ata ajopana. ");
INSERT INTO ycn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","E caja Pilato lana'arí marí que: “Jesús, Nazaret eyaje ricá. Judíona i'imacana ricá.” Ejomi napato'otá lana'aquéjami Jesús chaje. ");
INSERT INTO ycn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pajimila ahua'á nacúhua'ata Jesús i'imacá. Ñaquele cajrú judíona rehuá ja'apácaño amaño méqueca lana'aquéjami quemacá. Rilana'á ri'imacá, hebreo pura'acó chu, griego pura'acó chu, latín pura'acó chu. Hueji quele pura'acó chu rilana'á ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","E sacerdótena huacára'ajeño, judíona naquiyana ne'emacá, quemaño Pilátojlo: —Uncá paala pilani'ichaje: “Judíona i'imacana ricá”, que pilani'ichaca ricá. Marí que rilana'acana palani: “Rimá rinacuhuá: ‘Judíona i'imacana nucá’ que”. ");
INSERT INTO ycn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Aú Pilato quemari najló: —Caja queja nuhuáchiyaca rilana'acana. Caja queja riyuríjico. ");
INSERT INTO ycn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pa'u quele surárana acúhua'ataño Jesús i'imacá. Nacúhua'ata ricá ejomi najña'á ra'arumacami, natamáca'atacaloje najluhua ricá penaje. Ra'arumacami huaphereni, richaje rica'ajícareno rinacuhuá, richuhuá ña'acanami ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","E surárana quemaño pajlocaca: —Uncá huajiyo'otálaje ricá, huatamá'atacaloje huachó ricá penaje. Palani huacátajico nacaje nacú, chá'atajeri huecá ña'ajeri rijluhua ricá —que napura'acó ra'arumacami nacú. Marí que nala'acá aú nala'á Tupana puráca'alo lana'aquéjami quemacá nanacu i'imacá que. Marí que rimacá: “Natamáca'atajica no'orumacami najluhua. Nacaje nacú cátacano aú nahue'epeje ritamáca'atacana najluhua.” Rimacá júpimi rinacu i'imacá queja surárana la'acá ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús jaló, ro'ohueló hua'até, i'imaño a'ahuaná apiyácacanami ahua'á. Jesús acúhua'acaro nacú ahua'á ne'emá. Re caja María, Cleofas yajalo, i'imayo. María Magdalena i'imayo caja najhua'até. ");
INSERT INTO ycn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Re Jesús jaló tára'ayo ra'apí pajluhuaja ra'apiyateje hua'até. Ricá íqui'ija rihuátacare ri'imacá. Jesús amaca aú rutára'aco ra'apiyateje hua'até, rimá rojló marí que rinacu: —Chuhuaca ricá i'imajeri pi'irí que. ");
INSERT INTO ycn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Quéchami rimá ra'apiyatéjejlo: —Rucá i'imajeyo paló que chuhuaca. —Je —que rimacá. Reyá a'ajná ño'ojó ruyuró ilé ra'apiyateje ñacaré chu. ");
INSERT INTO ycn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Marí que Jesús quemacá najló i'imacá. Caja rihue'epí riñapátaca risápaca'ala la'acana. E rimá marí que: —Macajreni nunúru'upi chu. Marí que rimacá aú rimá Tupana puráca'alo lana'aquéjami quemacá rinacu que. ");
INSERT INTO ycn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Re i'ichilá i'imari pajlúhua'ajlu. Cajmú caje jalá ñapátacanami i'imari richu. Ca'amani ri'imacá. “Macajreni nunúru'upi chu” que rimacá aú, nejata nacaje jamára'apani ralá aú. Ejomi napatacá yenoje ricá isijila ina aú, Jesús i'iracáloje ricá re'iyayá penaje. ");
INSERT INTO ycn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús i'irari re'iyayá ricá. Quéchami rimacá marí que: —Caja nuñapáchiya nusápaca'ala. Ejéchami racúhua'ataca rihuíla'aru. Ejé caja ritaca'á i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","E caja judíona naquiyana i'ijnaño Pilato amaje. Nemá rijló, rihuacára'acaloje surárana yupa'ataca a'ahuaná apiyácacanami naquiyá acúhua'acaño tajné penaje, nataca'acáloje quiñaja raú penaje. Quéchami najña'acáloje natami reyá penaje. Uncá nahuátala natami acúhua'aco re muní que ejená. Muní que i'imari huatána'acaje huacajé. Rihuacajé aú fiesta queño'oró. Ñaquele apú huacajé chaje nephaca ra'apí. ");
INSERT INTO ycn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","E Pilato huacára'ari surárana rejo natajné yupa'ataje. Nephá rejo. Nayupa'atá apú tajné pamineco, ejomi apú piño. Nacúhua'atacarena Jesús ahua'á ne'emacá. ");
INSERT INTO ycn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ejomi ne'ejná Jesús ahua'ajé, amaño maapami que cha ritaca'acá. Aú calé uncá nayupa'atala ritajné. ");
INSERT INTO ycn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","E'iyonaja calé pajluhuaja surara jo'orí re'iyajé huejucú aú ripara'alá ja'apiyá. Raú rírami juni hua'até aco'oró richiyá. ");
INSERT INTO ycn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","37","Uncá nayupa'atala ritajné. Tupana puráca'alo lana'aquéjami quemacá rinacu queja nala'acá ricá. Marí que rimacá rinacu: “Uncá nayupa'atálaje ritajné.” Apa'amá e'iyá rimá piño marí que: “Namaje piño ricá penájemi najo'ocare e'iyajé.” Nucá, Juan, lana'arí riyucuna ijló. Nomácale méqueca nala'acá ri'imacá. Aú nuhue'epí quehuaca ricá. Nala'acá nohua'á ri'imacá que huani nu'umacá riyucuna. Ila'acáloje quehuaca que ricá penaje nu'umá ijló riyucuna. ");
INSERT INTO ycn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Marí que nala'acá ri'imacá. Caja surárana yupa'ataño ajopana Jesús ahua'á i'imacaño tajné i'imacá. Ejomi apú i'ijnari ritami quejá'aje Pilato liyá, rito'otácaloje ricá liri caje chojé penaje. Rií i'imari José. Pajimila Arimatea eyaje ri'imacá. Jesús ja'apiyá jema'ajeri ri'imacá. E'iyonaja uncá ri'imalá riyucuna ajopánajlo, riquero'ocole judíona naquiyana piyá. Ricá penájemi i'ijnari Pilato chaje Jesús tami quejá'aje riliyá. Pilato quemari: “Je” que. Aú ri'ijná Jesús tami ña'ajé. ");
INSERT INTO ycn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo i'ijnari caja rijhua'até riñaté a'ajeri penaje. Júpimi que Nicodemo iphaca Jesús nacú lapí i'imacá, ripura'acóloje rijhua'até penaje. Ricá penájemi i'ijnari José hua'até riñaté a'ajeri penaje. Rijña'á rijhua'ató pusana caje, pu'umé jamarí. Aloe rií. Treinta jenari rijña'á i'imacá. Mirra quechípa'acanami hua'até ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","E caja José, Nicodemo, quele huitúca'ataño Jesús tami. Na'á pusana, pu'umé jamarí, a'arumacaji jítami e'iyajé. Quéchami napila'ataca a'arumacaji jítami aú ritami. Marí queja judíona la'ajica támijimina nacú. ");
INSERT INTO ycn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nacúhua'ataca Jesús apucuna ahua'á a'ahuaná ejátaquelana i'imacá. Re jipa ichácanami i'imari ucapú que, nato'otácaloje támijimina richojé penaje. Huajé ichácanami ri'imacá, uncá jo'ó nato'otálare chojé támijimina ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Richojé nato'otá Jesús tami, rahua'á ri'imacale. Yehuicha judíona le'ejé huatána'acaje huacajé iphaca rená chojé. Ñaquele rejoja najña'á ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sápacaje queño'ocó huacajé, lapiyami huani, María Magdalena i'ijnayo támijimi to'otáquelana ejo. Luhuíchipica iná me'etaca ee, ru'ujná rejo. Ruphá rahua'ajé a'ajnáreje que, amayo caja jipa i'imacá jatatáqueja rinumanaya. ");
INSERT INTO ycn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Raú rupa'ó jecho'oquelo ropumí chuhuá riyucuna i'imajé Pédrojlo, apú Jesús ja'apiyateje hua'atejlo. Iqui'ija Jesús huátacare ri'imacá apú. E ruphá nanacu. E rumá najló: —¿Meño'ojó pajacá naji'ichá hue'emacánami chu tami? Uncá ri'imalá támijimi to'otáquelana chu. Uncá nuhue'epila meño'ojoca naji'ichaca ritami —que rumacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Marí caje aú Pedro, rijhuáque'ehue, quele jácho'oño, ne'ejnacáloje támijimi to'otáquelana ejo penaje. ");
INSERT INTO ycn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Jecho'oquelo ne'ejnacá rejo. Apú Jesús ja'apiyateje ja'apáñari Pedro jecho'ocajo aú. ");
INSERT INTO ycn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Riphá rejo. E acúhua'acano riyacá'aco richojé. Amari a'arumacaji jítami pitacó re, napila'acare rinacu i'imacá. Rinumaná chiyaja calé riyacá'o; uncá rimujlúca'ala richojé. ");
INSERT INTO ycn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Júpichami Pedro iphari rihuajlé chojé. Pu'ucuja ilé mujlúca'aca richojé. Ricá amari caja a'arumacaji jítamija pitacó re. ");
INSERT INTO ycn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","A'arumacaji napára'atacare aú Jesús jimami yá'aro apojó pitá. Uncá apú a'arumacaji jítami ahua'á calé ri'imacá. Apojó riyá'o riliyá, palá nótacanami pachácaca. ");
INSERT INTO ycn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","E caja apú Jesús ja'apiyateje, pamineco iphácare rejo, mujlúca'ari caja richojé. Meñaru ramaca richiyá. Raú rihue'epí quehuaca Jesús macápo'oco i'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tupana puráca'alo lana'aquéjami quemari rinacu marí que i'imacá: “Hueji que cala i'imajemi ritaca'ajica ejomi rimacápo'ojo rapumí chuhuá.” Rihuacajé uncá jo'ó nahue'epila meque quemacánaca ricá. ");
INSERT INTO ycn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Caja iyamá Jesús ja'apiyatéjena naquiyana amaño meñaru Jesús. Aú napa'ó nañacaré ejo. ");
INSERT INTO ycn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Reja María yuriyo támijimi to'otáquelana ahua'á. Rahua'ája ru'umá iyacaje nacú. E'iyohuá que rocúhua'aco ají que, ruyacá'acoloje richojé penaje. ");
INSERT INTO ycn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","E romá iyamá je'echú chiyájena, Tupana hua'atéjena, yá'aco Jesús tami apumí chu. Jaré nojé na'arumacá i'imacá. Apú yá'aro Jesús huíla'arumi i'imacá ejo, apú ri'imami i'imacá ejo. ");
INSERT INTO ycn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ejéchami Tupana hua'ateje quemacá rojló: —¿Naje piyá? Raú rumá najló: —Caja naji'ichá Nu'umacánami chu tami. Uncá nuhue'epila meño'ojoca naji'ichaca ricá —que rumacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Marí que rumacá aú rupajno'ó yacá'ajo, amayo Jesús tára'aco ruhuajlé chu. E'iyonaja uncá ruhue'epila Jesusca ri'imacá. ");
INSERT INTO ycn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","E Jesús quemari rojló: —¿Naje piyá? ¿Na piculá? Rupechu i'imá rinacu: “A'ahuaná ejátaquelana e'iyá sápajeri japi ricá.” Ñaquele rumá rijló: —Picá ca'ajná ji'ichari ritami maare eyá. Chuhua pimá nojló meño'ojoca piji'ichá ritami, nu'ujnacáloje rijña'ajé penaje. ");
INSERT INTO ycn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ejéchami Jesús ajalácaca rucá: —María —que. Raú rupajno'ó ruyámojo richaje yacá'ajo, amayo Jesusca ri'imacá. Raú rumá marí que napura'acó chu: —¡Rabuni! (“Nohuíña'atajeri”, que quemacánaca Raboni.) ");
INSERT INTO ycn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús quemari rojló: —Pisápaniya nunacu. Uncá jo'ó nu'ujnalá Nora'apá i'imacá ejo. Chuhua pipa'ó, pi'imichachi nuyucuna no'opiyatéjenajlo. Nojena que huani necá nojló. Chuhua Nora'apá ejo nu'ujichaca; Jara'apá caja ricá. Nuchi'ináricana ricá; Ichi'ináricana caja ricá —que rimacá rojló. ");
INSERT INTO ycn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ejomi María Magdalena i'ijnayo riyucuna i'imajé ra'apiyatéjenajlo. Ru'umá najló méqueca romaca Nahuacára'ajeri Jesús yucuna. Méqueca rimacá rojló yucuna ru'umá caja najló. ");
INSERT INTO ycn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Rihuacajé caja lapí, sápacaje queño'ocó huacajé, Jesús ja'apiyatéjena jahuacaño nañacaré chu. Chahuíña'queja que rinumaná i'imacá, naquero'ocole judíona naquiyana piyá. E majopeja re'iyayaja Jesús mujlúca'aca nañacaré chojé nachaje. Ne'iyajé ritára'o; rajalaca necá; rimá najló: —Ipechu i'imá palá. ");
INSERT INTO ycn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Marí que rimacá ejomi, riya'atá najló itapuhua cupijneremi riyáte'ela yá'aca e'iyá. Riya'atá caja najló ripara'alá ja'apiyá huejucú cupijneremi. Pu'ují huani napechu i'imacá Ne'emacana amácana aú. ");
INSERT INTO ycn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Rejomi Jesús quemari piño najló: —Ipechu i'imá palá. Nora'apá huacára'aca nucá que nacaje la'acana nacú, que caja nuhuacára'aca icá. ");
INSERT INTO ycn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ejomi rapho'ó nachaje. E rimá najló: —Ijña'á ijluhua Tupana Pechu. ");
INSERT INTO ycn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Amájico ee ina'uqué chaje pu'uhuaré nala'acare liyá, uncá napachoje i'imalaje. Uncájica ee amó nachaje pu'uhuaré nala'acare liyá, napachoje yuréjero najhua'atoja —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pajluhuaja Jesús ja'apiyateje ií i'imari Tomás. “Iyamá moto'ocaño naquiyana ricá,” que nemacá rinacu. Uncá ri'imalá najhua'até re Jesús ya'atacó najló ee. ");
INSERT INTO ycn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Riphaca nanacu ejomi ne'emá rijló riyucuna, nemá rijló: —Hue'emacana i'imichari majó huachaje. Raú Tomás quemari najló: —Uncá noma'alá ja'apiyá. Uncájica ee nomá itapuhua cupijneremi riyáte'ela yá'aca e'iyá, uncá nuhue'epila quehuácaca imacá nojló. Uncájica ee nusapa riyáte'ela yá'aca e'iyá, ripara'alá ja'apiyá ricupijneremi chu, uncá noma'alá ja'apiyá —que rimacá najló. ");
INSERT INTO ycn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pajluhuaja sápacaje i'imacá ejomi Jesús ja'apiyatéjena jahuacaño piño pají chojé. Tomás i'imari caja najhua'até re. Jesús mujlúca'ari piño ne'iyajé. Chahuíña'aqueja pají numaná i'imacá. E'iyonaja rimujlúca'a re'iyayá. E rajalaca necá; rimá najló: —Ipechu i'imá palá. ");
INSERT INTO ycn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ejéchami rimacá Tomasjlo: —Pisapa piyatehuana aú nucupijneremi chu. Pamá nuyáte'ela yá'aca. Pácho'ota caja piyáte'ela majó pisápachi nupara'alá ja'apiyá nucupijneremi nacú. Pipechu i'imaniya nunacu: “Uncá ricá calé namácare i'imacá”. Pema'á na'apiyá. ");
INSERT INTO ycn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ejéchami Tomás quemacá: —Nuhuacára'ajeri, Nuchi'ináricana. ");
INSERT INTO ycn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús quemari rijló: —Tomás, chuhua pihue'epí cajmuni jo'ó nucá, pamácale nucá. Palani najló, hue'epiño ejo'ocaja nucá, uncá namala nucá. E'iyonaja nahue'epí ejo'ocájaca nucá —que rimacá rijló. ");
INSERT INTO ycn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús la'arí cajrú apú nacaje, apú nacaje que, uncá meño'ojó apú la'alare. Rahua'á hue'emanoja rila'ajícano ricá. Uncá nulana'alá piyuque huani riyucuna marí papera chojé. Rinaquiyánaja calé nulana'á. ");
INSERT INTO ycn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Maáreje calé nulana'á riyucuna, ihue'epícaloje raú quehuaca Jesús, Tupana huacára'acare majó ri'imacá. Ihue'epícaloje raú Tupana I'irica ricá pe