﻿USE sofia;
DROP TABLE IF EXISTS sofia.yby_vpl;
CREATE TABLE yby_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yby_vpl WRITE;
INSERT INTO yby_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Muki wewenaya soto pimi wayoko, Jisesi Kalaestiya Dewitida ouvamela soto piye. Ito Dewitiya Aebalahamuda ouvamela ne. Yamidana gala maya ne. ");
INSERT INTO yby_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aebalahamuda ipala Aesiki ne. Aesikida ipala Jekopuma ne. Jekopuda ipala Judaya unalamotakiya soto piminae. ");
INSERT INTO yby_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judada ipala lowe Peleko Selako soto piminaiye. Donipoya Temaya ne. Peleya Helonida ahola ne. Ito Heloniya Lamuda ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ito Lamuya Aminadabuda ahola ne. Ito Aminadabuya Nasonida ahola ne. Nasoniya Salomonida ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomoniya Bowasida ahola ne. Bowasiya dola Lehapuya ne. Bowasiya Obetida ahola ne. Obetida dola Lutiya ne. Ito Obetiya Jesida ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesiya Kini Dewitida ahola ne. Dewitiya Solomonida ahola ne. Yulaiya helekaiyoko eto menalimoya Dewitito woko Solomonidaya etaiye. ");
INSERT INTO yby_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ito Solomoniya Liyaboyamuda ahola ne. Ito Liyaboyamuya Abaejada ahola ne. Abaejaya Esada ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esaya Jihosapetida ahola ne. Ito Jihosapetiya Jolamuda ahola ne. Ito Jolamuya Yusayada ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ito Yusayaya Jotamuda ahola ne. Ito Jotamuya Ehasida ahola ne. Ehasiya Hesikaeyada ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ito Hesikaeyaya Manasada ahola ne. Manasaya Aimonida ahola ne. Ito Aimoniya Josaeyada ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ito Josaeyaya Jekonaeyada unalamotakiya ahonipoya ne. Ya yupeka maya Isilaelo wewenasida maya di dadelo nala jiki liki Babiloniga maya dilipi-liki wae. ");
INSERT INTO yby_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nala maya hikayoko Jekonaeyaya Siyatieloda ahola ne. Siyatielo maya Selabobeloda ahola ne. Selabobelo maya Abaeyatida ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abaeyati maya Elaikimuda ahola ne. Elaikimu maya Esoda ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso maya Sedokuda ahola ne. Sedoku maya Ekimuda ahola ne. Ekimuya Elaeyatida ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ito Elaeyatiya Eliyesada ahola ne. Ito Eliyesaya Matanida ahola ne. Mataniya Jekopuda ahola ne. ");
INSERT INTO yby_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ito Jekopuya Josepuda ahola ne. Josepuya Meleda waunaya ne. Ito Melemamo Jisesida maya etaiye. Aya uliwamidana monawaya olisauti dilimekaka we loko ne. ");
INSERT INTO yby_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sakiya Aebalahamuda ouvamelalemotaya mini-liki nisiki Dewiti neboto nisebo wewenaya 14-pala minae. Ito Dewitida ouvamelalemota mini-liki nisiki Juda wewenasiya Babiloniga wiki nala heboto maya asaiki 14-pala minae. Asaikiya Babiloniga maya wiki nala hiki minabototiya 14-pala wewenaya mini-liki nisikayoko Jisesima soto penebo ne. 11 2 Kin 24:14-15; 2 Klo 36:10; Jel 27:20 ");
INSERT INTO yby_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisesi Kalaestima soto pibo ga maya sakoya ne: Dola Meledaya Josepuya litiye liki mudai molitiminabo menaya ne. Sakiya mudai molitikayokoya, Josepute owaha ouna jiki minamaibo ne. Sa-iyoko nenako, Meleda mudabo maya Omai weuna oluhomidana elewoleyalalotiya oluho ohumana jenebo ne. ");
INSERT INTO yby_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Wauna Josepuya wehe lonebo we nenako, oli hituboya wati etiye loko eliboya, menala Meledaya wewena domudaloya oli hituboya owana helekatinako, sunauka oli hituwe loko eliye. ");
INSERT INTO yby_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sakoya ata kekoko we napamidana okanaki we makolimoya wamo hemo omudalo moloko sa-loko lo miye: Josepuyo, emoya Dewitida ouvamelae, menaka Meleda maya lituhe lametuhe loko ata kideko eda elamideyo. Oluho ohumanauya Omai weuna oluhomidana elewoleyalaloti neyo. ");
INSERT INTO yby_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Sakoya minoko ipala etatiboya wewenalalesidaya lahelamibo weunipo molabo nesaya hulikoko dilipe-loko nisitibo nenako, uliwaya Jisesiye loko molatane. Ya uliwamidana monawaya wewena lilimekaka we loko ne. ");
INSERT INTO yby_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sainahena sako soto piboya Omaimidana epaloti ga lokaka wemoya we napamidana gala mako niseko ulolotetiye loko soto pekaiye. Luhuwa mako sa-loko jenebo ne: ");
INSERT INTO yby_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Eli-minahe. Eto oko netibo olu makolimo oluholaki minokoko ipala etatiboya uliwa Imanuelowe liki litae. Ito aya uliwamidana monawaya lemo ateukatiya Omai lemoki nebo we loko ne. ");
INSERT INTO yby_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sa-lokoya wamoutiya Josepuda maya lo mekaiyoko, Josepu maya sinokoko Meleda maya ilime-loko numudalauka maya nisiye. ");
INSERT INTO yby_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sakoya ilime-loko niseko numudalauka huloetokoko owaha udiki siniki amaiyoko Mele maya ipala etaiye. Sakoya etokaiyoko Josepumamo aya oluhomidana uliwa maya Jisesiyo loko molaiye. 18 Luk 1:27 21 Luk 1:31 23 Aes 7:14 25 Luk 2:21 ");
INSERT INTO yby_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Heloti maya uliki we lolo okoko ujapa ibo onawaloya Jisesima Betilihamuga soto piye, Juda ebatokaya. Ya yupekaya ho noyowibotokatiya sonohi monawalo mudaikaka weya Jelusalemu numutoka maya yowe. ");
INSERT INTO yby_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Aya wemasiya nisikiki loka iki edimoya Juda wewenasida uliki wenipo ohatama maya nakaha ebatoka soto pene. Lemoya numudate ho noyowibotoka sonohilaya soto peko neyoko mudakoko li bola he metune loko maya nonisune. ");
INSERT INTO yby_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Liki layoko, uliki we Helotimamo elekoko upau lekaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","edimo Jelusalemu eba aholalekiya asaiki sabo ne. Sa-inayoko Helotimamo ito Omailoka jokila hi mikaka niabo wehenamakiya monoka monawa api-napi ibikaka wehenamaki dilipe nupa okoko Omailimoya lahelamibo nesauti lilimitiye loko lo mololetaibo we maya nakaha ebatoka soto pitibo ne loko libo ne loko loka obetaiye. ");
INSERT INTO yby_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Loko loka obetaiyoko, Betilihamu numutoka Juda ebakukaya soto pitibo ne loko Omaimidana epaloti ga lokaka wemamo Omailimo lo mibo ga sa-loko luhuwa jenebo maya nenae liki lae: ");
INSERT INTO yby_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Betilihamu numutokatiya uliki we mako soto pekoko Isilaelo wewenasidaya ujapa obetakolainako, aya ebaya Judiya ebakuka neboya Judiya mikaya oto eba muki minabokutiya lemeko minamiye. ");
INSERT INTO yby_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Liki li mikayoko elekoko sonohi monawalo mudaikaka wesida maya suna oko dilipe nupa okoko, sonohima ada soto pibototiya onawa nenaki wiye loko loka obetokaiyoko, ya yupekae liki moletikiya li me. ");
INSERT INTO yby_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sa-liki li mikayoko, Helotimamo sa-loko suwa loko lo beko doli hiye: Edimoya wiki Betilihamu numutokaya dabuha moliki moniki ohu jilo. Sakiya ohu jiki li soto molikiki nisiki nemodaya li nimitayo. Nisiki li nimikadekoya asako woko lipe mituwe. ");
INSERT INTO yby_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Loko lo bekaiyoko niwayokoya, ho noyowibotokati mudabo sonohi maya le omutiye. Sakoya le omutoko woko aya oluho aida nebo numuto maya wehe loko woko ne. Woko neyoko mudaikiki mulunipouka dowa liye. ");
INSERT INTO yby_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Sa-okaiyoko, yowiki numukuya mudaboya dola Melete maya minaiyoko ");
INSERT INTO yby_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","mudaikiki lipi miki owonipo maya molikiki epawa li ka ikiki owonipouti sainahena li hiki molitae. Aya nesaya goli ehadahena ito nuwalaki jokila yowekaka noibo nesahena ito dupaloka hileyoko nuwala wokaka noibo nesahenaya ");
INSERT INTO yby_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","li hiki molitikiki udiminayoko, Omailimoya wamolokaya sa-loko lo biye: Edimoya Helotida numudalalo anu nisebotoma wamiki li wili jiki aito anuloka wiki numudatipoloka hetatae loko lo bekaiyoko wae. 2 Mae 5:2 ");
INSERT INTO yby_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Niwayoko, Omaimidana okanaki wela makolimoya Josepuda maya wamotoka sa-loko lo miye: Ele-minape. Helotimamo aya ipakada yaitaya ohu jeko le soto molokoko kohatuwe loko lokaiyo, emoya enemane oko dolako ipalakosidama dilipe-loko woko Ijipi mikaukaya minatane. Woko yaukaya minoko nemo ga lo imitubotoya ameme oko ele-minatane. ");
INSERT INTO yby_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Loko lokaiyoko Josepu maya enemane oko sinokoko dolako ipalakosidaya lubuka oletawaya dilipe-loko Ijipi mikalokaya wiye. ");
INSERT INTO yby_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yaloka wiki minayoko Heloti maya heliye. Sakoya Heloti helekaiyoko li wili jiki Isilaelo mikauka aku waboya ahamu minamiye. Omaimidana epaloti ga lokaka we makolimoya we napamidana galalo ga mako sa-loko libo ga maya niseko pasiye: Ipaneya Ijipi mikauka minokaiyoko nemo ju loboto nonisiye. 15 Hos 11:1 ");
INSERT INTO yby_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ito Heloti maya owaha helamiyoko, sonohi monawalo mudaikaka wemasiya Helotidama sa-iki okepa jiki aku nisiki li mamayoko epalo molaiye. Epalo adoha molokaiyoko nenako, imi wesida maya doli hekaiyoko wiki Betilihamu numutoka ito numuda esewatoka nebo ebatoka maya moniki oluho aida melekenipo lowe li hulamabolawa maya kohaidiki suwae. ");
INSERT INTO yby_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sakiya kohaidiki suwaboya sonohi monawalo mudaikaka wesiya Helotida li meboto sae. Sa-ikayoko Omaimidana epaloti ga lokaka we Jelemayakahoya asaitabo ne loko libo ga maya niseko pasiye loko luhuwa jenebo ne: ");
INSERT INTO yby_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Lama numutokatiya witaga hiki wije namalimo lemo jeje onebo ne. Sa-iyoko, Lesolomakiya oluholadamuya wije nama lenebo ne. Sakoya wije nama noliyoko ilime you letune liki laboya, muki wewenasida oluhonipolemakiya heleyoko nenako, ilime you lamitabo nesa liyoko wije nama okogo nebo ne. 18 Jel 31:15 ");
INSERT INTO yby_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heloti helekaiyoko Ijipi mikaukaya we napamidana okanaki wela makolimoya Josepuda maya wamo hemo omudalo moloko sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Sinokoko dolako ipalakosidama dilipe-loko aku Isilaelo mikaloka wetane. Oluho kohaidatuwe loko libo we maya alo helekaiyo. ");
INSERT INTO yby_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Loko lo mekaiyoko, dolako ipalakosidama aku dilipe-loko wiye. Sakiya aku li Isilaelo mikaukaya wae. ");
INSERT INTO yby_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sakiya niwadanaki, Josepumamo ga mako sa-loko eliye: Helotida ipala Akelaesima aholada adakolila maya le olo jekoko Juda mikauka uliki we lolo oko ne. Liki layoko Juda mikauka woko netibomuya omodala wonebo ne. Sakoya omodala wokaiyoko, wamotokaya ga mako hemo omudalo molayoko mudakoko Galeli mikaloka, ");
INSERT INTO yby_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","eba mako Naseletiyo loko nebo numutokaya woko nebo ne. Sa-iyoko, Omaimidana epaloti ga likaka wesiya Omailimo we makoya oli hituwe loko lo molobetaibo wemu Naseleti we liki likilae liki labo ga maya niseko pasiye. 22-23 Mak 1:9; Luk 2:39; Jon 1:45; Aes 11:1 ");
INSERT INTO yby_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ya yupekaya noku udobetokaka we Jonikahoya Judiya ebatokaya nisekoko mumusopa mikaloya monoka sa-loko lo soto molaiye: ");
INSERT INTO yby_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Omailimo ujapa olibetatibo onawaya alo alili okaiyo, dukaya li wili jilo. ");
INSERT INTO yby_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Loko liboya, Omaimidana epaloti ga lokaka we Aesayakahoya hapa yeikala sa-loko luhuwa jibo ga maya Jonito niseko pasiye: Mumusopa mikaloya we makolimo ga napauti sa-loko noliye: We napadamu duka li wehe litalo. Dukau limitibo anulaya li wehe litalo. ");
INSERT INTO yby_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jonikahoya kamolo ja upawaloti lolo abo nesa upaloya olo jekoko, ja upaloti lolo abo ebela ohalalo jekoko pipiya nodenesa hituki ito lubemidana nouvalakiya noko nebo ne. ");
INSERT INTO yby_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Sakoya neyoko, Jelusalemu numutokati ito Juda eba malokati ito Jodani no yola helegalokati ito ma helegatiya muki wiki emotoka hetikiki, ");
INSERT INTO yby_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","lihimanipomuya li soto molikayoko, Jonimamo noku udobetaiye. ");
INSERT INTO yby_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Noku noudobetaiyoko, Palasisi wewenahena ito Sediyusi wewenahenamakiya noku udakili nisikayoko, sa-loko lo biye: Edimoya jamidana oluholalitaya, olisatipomidana lihimala maya edimotoka soto pekolo noiboya aha oli itae loko ekahimamo lo libibo ne. ");
INSERT INTO yby_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dukaya li wili jikiki yamidana monawaya li soto molikiki nisilo. ");
INSERT INTO yby_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nemoya sa-loko lo noliboe: Omailimoya Aebalahamuda ouvamela yuha wavu-liki minatae loko lo hukaiboya, edimoya Aebalahamuda ouvamelale yuha minatae loko Omaiyamo edimodamuya elametiye. Sa-itae loko ehadasida yatokaya Aebalahamuda ouvamela lolo ilo loko letiboya aha lolo itabo nenako, dupatipoya liki yowiki Aebalahamuda ouvamela minudanako, Omailimoya lemoda lihimatemuya obi oletamekolaiye liki lamilo. ");
INSERT INTO yby_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Loda lekolimoya ya monauya kohakolo nebo maya ne. Sa-etibo nenako, ihilawa lalo jamitabolawa maya isa heko joku jekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nemoya duka li wili jebokumuye loko noku udobetokaka noe. Nemesaloka nonisibo welimoya Omaimidana weuna oluholoti ito dukau lahelametibo nesa jeko wotetibo jolotiyaki noku udolibetakolaiye. Emo elewoleyalalimoya nemo elewoleyanemidana asetoko ne. Nemoya aha gelekeke wela minoe. Emotoya kohamonako, emodaya elekele oetoko yowanu lasolasimaki letatubotoya kohamoe. Nemesaloka nisitibo welimoya Omaimidana weuna oluholaloti ito jolotikiya noku udolibetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Emoya pipiya nesa usokaka nesakiya leko niseko laisiya esopa jeko le lalo ekolaiye. Sakoko nodenesa lalo maya aka oko le numuku le moladeko minakolaiye. Ito pipiyawa maya usoko jokuya jekadeko lowa lowa oko minakolaiye, loko liye. 8 Mat 4:17; Mak 1:15 3 Aes 40:3 10 2 Kin 1:8 7 Mat 12:34; 23:33 9 Jon 8:33 10 Mat 7:19 ");
INSERT INTO yby_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ya yupekaya Jisesima Galeli mikaukati Jodani noloka noku udonetatiye loko Jonima nebotoka woko lo mekaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jonima auha lokoko sa-loko liye: Nemoya aha nesama minonako, emokahoya noku udonetatadawoya wehe lekolaiye. Sa-onenako, nemotoka nisedawoya wehe lamiye. ");
INSERT INTO yby_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Loko liyoko, Jisesimamo sa-loko lo miye: Yaya ga lalo nesa ladawoya, olotiya yamidana oko minasiye. Yowanuya sa-iki lisaiye loko lo letaiboma nenako, lahelametihe. Loko liyoko, Jonimamo ele miye. ");
INSERT INTO yby_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ele mekoko ilime-loko lemeko Jodani noku maya noku udomikaiyoko, sinoko mudaibo maya okulumama golo notiyoko, Omaimidana weuna oluholimo nama luhukidana lemeko Jisesida madonalo maya lemo jiyoko mudaiye. ");
INSERT INTO yby_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sa-okaiyoko, okulumauti ga mako sa-loko soto piye: Maya nukane meminobo ipanema nenako, muda lalo okoe loko liye. 17 Jen 22:2; Sam 2:7; Aes 42:1; Mat 12:18; Mak 1:11; Luk 9:35 ");
INSERT INTO yby_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sa-okaiyoko, Omaimidana weuna oluhomamo Jisesidaya olohalimo mimi moloetatiye loko elekoko ilime-loko mumusopa mikaloka wiye. ");
INSERT INTO yby_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yaloka maya woko neboya onawa 40 oko wiboya, nodenesa namoko nenako, nodekumuya heliye. ");
INSERT INTO yby_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sakoya nodekumu heleko neyoko, mimi molokaka wemamo Jisesi nebotoya nisiye. Niseko sa-loko liye: Emoya Omaimidana ipala minatadawoya matoka ehadahenasidaya ga lo bideko nodenesa lolo ideko namane. ");
INSERT INTO yby_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Loko liyoko, Jisesimamo o'e, monoka bukuguya sa-liki luhuwa ji-minaboma ne: Wewena mako nodenesago nikiki elewole iki minamitabo nesa ne. Omaimidana epaloti gagoya eliki minatabolimoya elewole iki minatabo ne. ");
INSERT INTO yby_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Loko lokaiyoko, Jisesidama ilime-loko woko Jelusalemu monoka numudamidana okepalo maya yoweko sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Emoya Omaimidana ipala minatadawoya maloti yokama mikalo satomo jo. Ga mako monoka bukuguya sa-liki luhuwa ji-minaboma nenako, le lahelamibo lolo amekolane: Emokumuya Omailimo okanaki welasidaya yowanu gaya lobetokadeko, emodaya ehadalimo kohaelokatiye liki limiki apusa jiki ilimi dade ulau molakilae. ");
INSERT INTO yby_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Loko liyoko, Jisesimamo ga mako monokauya sa-loko ne loko lo miye: We uti Omaimidana uliwaya le yolalo malo moloko nei opa-napa nesalo lametune liki luhuwa ji-minaboma ne. ");
INSERT INTO yby_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Loko lokaiyoko, ilime-loko bola hana-panauya yowiye. Yalo maya ilime-loko yoweko muki numuto namato duliki wesida numudanipohenama ito mikanipohenama ebanipohenama ilipeko sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Emoya nemoto i bola heko monoka loko nuline le sawa jekadeko, maya muki yatoka nesahena le heko imituwe. ");
INSERT INTO yby_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Loko liyoko, Jisesimamo Olohao, emoya hulikoko wo. Ga mako monoka bukuguya sa-liki luhuwa ji-minabo neyo: We uti Omaimidanagoya lipe meko li bola he meko uliwa le sawa jetudawo ne. Sakoya emogoya elekele oetatudawo we ne loko liye. ");
INSERT INTO yby_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Loko lokaiyoko, we lahelamibomamo huloetokoko wokaiyoko, okananipoki wesiya limiki ilimi lalo iki magoina minae. 1 Hib 2:18; 4:15 0 Dut 8:3 2 Sam 91:11-12 7 Dut 6:16 10 Dut 6:13 ");
INSERT INTO yby_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jonida maya huli nala numuku ikayoko, neyoko, Jisesima gawa elekoko Galeli ebakuka wiye. ");
INSERT INTO yby_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naseleti numutokaya woko onawa hana minamoko, apila maloka Kapaniyamu numutokaya woko ne. Yaya ebaya Galeli adumidana ilikalokaya ne. Sebulani wewenahena ito Natalae wewenahenasida mikanipolokaya woko ne. ");
INSERT INTO yby_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Sa-iyoko, Omaimidana epaloti ga lokaka we Aesayada gala makoya niseko pasiye. Sa-loko luhuwa jenebo ne: ");
INSERT INTO yby_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulani mikauka ito Natalae mikauka ela noloka ito Jodani nomidana yola helegaloka ito Galeli ebakuka Juda wewena minamabo wewenasi minikaka niabotokayae. ");
INSERT INTO yby_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Lubu jiboku minikaka niabo wewenasiya le napa mudatae. Ito helikaka lubumidana ulau minatabo wewenasiya lamedalimoya lameda letiboto minatae. ");
INSERT INTO yby_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sa-iyoko, ya onawalo maya Jisesikaho monoka sa-loko le api oko lo biye: Okulumau Omailimo ujapa olibetatibo onawa maya aloya alili oko domudalokaya nisekaiyo, duka li wili jilo loko libo ne. 12 Mat 14:3; Mak 6:17; Luk 3:19-20 13 Jon 2:12 15 Aes 9:1-2 17 Mat 3:2 ");
INSERT INTO yby_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yu makoya Jisesima Galeli adumidana ilikalokaya nomoneko mudaibo maya, we loweya unalako yatolako minaiyoko mudaiye. Makoya uliwa Saimoni ito ohatama uliwaya Pita ito unala Enduluteya lawaha hikaka we minainako, lawaha hikaka owo maya huli nohuku ikiki minaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisesimamo mudaidokoko sa-loko lo biye: Hulikiki nemotoka nisiliyo. Lawaha niheibo nesa liki wewenasitoka yowanu liki dilipi-liki nemotoka nisisaiye loko dilipe nomoloyo. ");
INSERT INTO yby_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Loko liyoko, enemane iki lawaha owoma hulikiki Jisesiki magoina waiye. ");
INSERT INTO yby_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sakiya wiki Jebetida ipala lowe asaiki minaiyoko mudaidae. Yatolada uliwa Jemisi ito unalada uliwaya Jonitema noku lapeuya ahonipoleki miniki lawaha likaka owo maya li lalo-talo niaiyoko Jisesimamo mudaidokoko ju lo biye. ");
INSERT INTO yby_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ju lo bekaiyoko, enemane iki ahonipoda ito noku lapenipokiya hulikiki Jisesiki magoina waiye. ");
INSERT INTO yby_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisesikaho Galeli mikaukaya wego wego oko moneko monoka numuku numuku monoka api-napi obeko ito okulumau Omailimo ujapa obetatibomidana gawa lo soto moloko lo beko aito aito nesa jelebo wewenahena maya dilipe haka loikaka oko nebo ne. ");
INSERT INTO yby_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sa-ibo nesamuye liki, liki i moneyoko pou loko Siliya mikauka ito muki numuto namato woko suwokaiyoko muki wewena maya eli suwae. Sa-ikayoko, aito aito nesa delaibo wewenahena ito dupa miluma nabo wewenahena ito dukau oloha nebohena dupauka opa napa okaka wewenahena ito ebili liki minabo wewenahenamakiya muki dilipi-liki Jisesitoka nisikayoko dilipe haka liye. ");
INSERT INTO yby_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sa-okaiyoko Galeli ebakukati ito taoni 10 nebo eba maya eba uliwa Dekapolisiyo loko nebo ebakukatima ito Jelusalemu numutokatima ito Juda eba malokatima, ito Jodani no yola helegatima wewena wavu-liki Jisesiki magoina wae. 23 Mat 9:35; Mak 1:39 ");
INSERT INTO yby_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisesikaho muki wewena li esa ayoko mudakoko bolauya yoweko ne. Sakoya yoweko neyoko unala ipalale yuha maya ayaloka li esa iki minae. ");
INSERT INTO yby_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sakiya minayoko Jisesimamo monoka sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Omaimidana uvaminalaya lukau waitamiye liki likaka niabo wewenasiya okulumamidana oholauya yowitabo nenako, edimoya elowa jebo ilekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ito lahelamibo nesanipohenalo wije nama liki miluma eliki minikaka niabo wewenasidaya Omailimo dilipe you letibo nenako, elowa jebo ilekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ito duliya limi limiki molikaka niabo wewenasiya ma mikauya Omaimidana abuhalama li sa-itabo nenako, elowa jitabo wewena minae. ");
INSERT INTO yby_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ito Omaimidana omudalo wehe liki minatabokumu delaiyoko minabo wewenaya wehe liki minatabo nesalimoya dukau waitetibo nenako, elowa jebo ilekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wewena eke libitatabo wewenasidaya Omailimo eke lobetatibo nenako, elowa jitabo wewena minae. ");
INSERT INTO yby_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ito dukau uluwitibo wewenasiya miniki Omaimidana muda-elatabo nenako, elowa jikilae. ");
INSERT INTO yby_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ito dilipi you nilabo wewenasidaya Omai oluhola minae loko lobetatibo nenako, elowa jiki minakilae. ");
INSERT INTO yby_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ito wehe lo mina anulo monebokumuye liki ulana molibitadeko minatabo wewena maya okulumamidana elewoleyala maya edimo nesanipo lolo etibo nenako, elowa jiki minakilae. ");
INSERT INTO yby_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ito nemokumuye liki liwi letiwi ilibitiki lahelamibo nesa lolo ilibitiki aya li yolau mau iki dilipi lahelamibo itabokumuya elowa jitae loko ele-minoe. ");
INSERT INTO yby_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Okulumauya meinawatipo napa-napa netibo nenako, yamuya mulutipou lalo eliki elowa jiki minalo. Omaimidana epaloti ga likaka wesida hapaya sa-iki sa-ibitabo nenako, Omailimo aya wewenaki edimokiya meinawa napa lemekolaiye liki elikiki elowa jiki minalo. 10 Aes 61:2 5 Sam 37:11 4 Sam 24:3-4 10 1 Pit 3:14 11 1 Pit 4:14 12 2 Klo 36:16; Apo 7:52 ");
INSERT INTO yby_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Edimoya ma mikau muki wewenasidaya agekidanaya minae. Ageya lahelepa ametiboya nena nena okoma aku le lahelepa etudawo ne. Samekoloune, aha nesa lolo onebo nenako. Yamuya ululutoko le hulokuniyoko lemeko mikalo neyoko wewenasiya wiki nisiki iki uha ilekile ae. ");
INSERT INTO yby_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ito edimoya ma mikau wewenasida lenipoya minae. Le napaya bola makomalo le soto molatudawoya saina makolimo le hitamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ito leya lepa okoko somou moloko epaloti jeko hitokaka nesa minamiye. Sipaloya molokuniyoko, numuku minabo wewenasida maya lameda lobetokaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Edimo leyamidana iki muki wewenasida hi lameda libitatae. Sa-ikiki edimoya lameda likigo mini-liki nisitaboya, aito wewenasi mudaidikiki lahelepa delokadeko okulumau ahotipodaya epoka likilae. 14 Jon 8:12; 9:5 15 Mak 4:21 Luk 8:16; 11:33 16 1 Pit 2:12 ");
INSERT INTO yby_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nemodamuya Mosesekaho lo hukoko libo gahena ito Omaimidana epaloti ga likaka wesiya api-napi iki luhuwa jebo gahena le hulatane loko lemene liki data kamilo. Le hulatuwe loko lemobo nehekala, monawala maya lo soto moloko lokoyoko woko ayau maya litiye loko lemobo maya ne. ");
INSERT INTO yby_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sa-ominobo maya nenako, wehe loko lo libituyo, elilo. Okulumaki ma mikakiya owaha woko tolowa amideko Mosesekaho lo hukoko libo gautiya ga lasolasi mako woko leso amekolaiye. Aha mino-loko woko yamidana gahena muki maya mino elewole ekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yamuya Omailimo lo hukoko libo gautiya we makolimo lasolasi mako ele hulikoko maloka wewenasiya ayamidana iki eli hulatae loko api-napi obetatiboya, Omaimidana oholauya lemekosi minakolaiye. Ito wewena makolimo aya lo hukoko libo ga elekoko wewena malokasi asaiki emesalo molatae loko api-napi obetatiboya, Omaimidana elewoleyalaloya yoweko netibo ne. ");
INSERT INTO yby_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nemoya sa-loko lo noliboe: Edimo wehe liki minikaka niabo monawatipolimoya monoka monawa api-napi ikaka niabo wesi ito Palasisi wesiya wehe loko minoko leko okaka noune liki likaka niabo wewenasida monawanipomidanaya asebetoko aito aweyaha ametiboya Omaimidana elewoleyalaloya ma yowamikilae. 18 Luk 16:17 ");
INSERT INTO yby_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mosesekaho lo hukoko libo gautiya latatipolesidaya sa-liki li biminabo maya ne: Wewena mako koha helamo. Ito wewena mako koha helitibo wewena maya obi yowanu litibo ne. ");
INSERT INTO yby_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sa-oneboya, nemokahoya sa-loko lo noliboe: Wewena makolimoya iweladamu epauka molatiboya obi yowanu lekaka nesa maya emo nesala ilekolaiye. Ito iwelada lewo letowo oko letiboya ujapa wesida domudaloya obi ekolaiye. Ito we makolimo iwelada leko letoko nei we ne loko letiboya alika onawa napaloya jo ebaku wekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yamuya Omailoka jokila he mekaka nesaya leko woko Omailokaya he mituwe loko letadawo yupekaya, iwekaki dokepa hoto-poto neyoko lowa nesa leibo maya nenako, yatoka nesa maya aha ne loko elitadawoya, ");
INSERT INTO yby_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jokila he mekaka nesaya hulikoko woko iwekakiya alo-nalo liki duka no jisaiye. Sakiya li hulikikima jokila he mekaka nesa maya leko woko Omaimidana mitane. ");
INSERT INTO yby_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","We makolimo lihimakamuya obi ogetakolo ilime-loko obi numutoka nowideko maya, anuloka niwiki lihimaka suwetiye loko maya, sainaka mako mitane. Ito aya yatoka nesakiya leko obi ga elekaka noibo we neboto yowitadawoya obi le helekaka welimoya imi wesida dadeu ilime molokadeko emodaya li huli nala numuku molikatayo. ");
INSERT INTO yby_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nemoya wehe loko lo noemoe, emoya Omaimidana nala numudala napauya minokoko lihimakamidana meinawa lasola napaya pasoko suwametadawoya ayauya minowa minowa oko minakolane. 21 Eks 20:13; Dut 5:17 ");
INSERT INTO yby_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mosesekaho lo hukoko libo gautiya latatipolesida sa-liki li biminaboma ne: Aito mena mako loka amo. ");
INSERT INTO yby_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sa-oneboya, nemokaho sa-loko lo noliboe: We makolimo mena makomidana muda-elo omuda helitiboya aya menamidana galoya loka ibo ilenenako, yamidana lihimala maya eimolatoka minakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Sa-onenako, omudakalimoya olisa lekaka anugu ilime molakoladekoma, upaka wasa jamoko minatadawoya joku wokataniyo. Yamuya omudakalimo ilime opa okatiye lokoma malokaya jeko potoko huliko. Sakoko omuda malokagoya minoko eda elamideko minakolane. ");
INSERT INTO yby_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ito ade malokalimoya olisa lekaka anugu ilime molakoladekoma, hukoko le hulo. Emoya ya adekalimo letiboto joku lokataniyo. Sakoko ade malokago minoko elowa jeko minakolane. 27 Eks 20:14; Dut 5:18 29 Mat 18:9; Mak 9:43-47 ");
INSERT INTO yby_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mosesekaho lo hukoko libo gautiya makoya sa-loko ne: We makolimo menalada huloetatuwe lokoma pepaloya luhuwa jeko mekoko oli he hulatiye. ");
INSERT INTO yby_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sa-oneboya nemokaho sa-loko lo noliboe: We makolimo menalaya we mena olisa ametiboto aha oli he hulikadekoma, menalalimoya we makomalo wetiboya we mena olisaya nenako, aya weyaki li koliki minaibomidana lihimaya omutoko waunatoka minakolaiye, ito alika wemo aya menamidana upalo litibomidana lihimala maya aya wemidana mupilalaloya yoweko minakolaiye. 31 Dut 24:1-4; Mat 19:7; Mak 10:4 32 1 Kol 7:10-11 ");
INSERT INTO yby_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mosesekaho lo hukoko libo gautiya latatipolesidaya ga mako sa-liki li bi-minae: Emoya Omaimidana omudaloya lo hukoko noladawoya suwa gauti le moloko lamo. We napamidana owisalo lo hukokaka noadawoya ele lekadeko ga ulawa soto pekolaiye. Sa-etibo ne loko libo gaya alo eli-minabo maya neboya, ");
INSERT INTO yby_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","nemokahoya sa-loko lo noliboe: Omaimidana owisalo li hukiki likaka niabo nesa maya hulalo. Okulumauti Omailimo ujapa oletokaka nesa nenako, okulumaloka li moliki aya li hukamilo. ");
INSERT INTO yby_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ito maya mikaya Omailimo lemeko i jekaka noibo nesa nenako, mikauka li moliki ga li hukamilo. Ito Jelusalemuya okulumau Omaimidana ebala nenako, Jelusalemu ebatoka li moliki ga li hukikaka nesa maya hulalo. ");
INSERT INTO yby_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ito edimoya yopatipo loimidanaya ga li mikadeko lubuha lolo ametibo ne, ito lubuhalimoya ga mako li mideko loi lolo ametibo nenako, yamuya yopatipolo li moliki gaya li hukamilo. ");
INSERT INTO yby_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yatoka nesaya hulikiki wehe likigo lolo etune ito o'e lolo ametune likigo litae. Yamidana mupilaloya ga mako litaboya, we lahelamibomikutiya likilae. 33 Liv 19:12; Nam 30:2; Dut 23:21 34 Mat 23:22; Jem 5:12 35 Aes 66:1; Sam 48:2 ");
INSERT INTO yby_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Moseseda gala mako sa-liki likaka niayoko elikaka niabo maya ne: We makolimo omudaka heko likokadekoma asako omudala heko liko. We makolimo epaka jeko letokadekoma asako epala jeko leto. ");
INSERT INTO yby_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Liki li-minaboya, nemokahoya sa-loko lo noliboe: Kohaidatune nilidekoma, dupatipo li wasa jamilo. Yamuya we makolimo epa hanawaka maloka jekadekoma maloka jitiye loko mino wili je mo. ");
INSERT INTO yby_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","We makolimo obi noetoko upakalo nesa lekadekoma, lasi nesakakiya mo. ");
INSERT INTO yby_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kiyape makolimo uvamina ohekoko anu minawaloka wetane loko nolidekoma ilimeko anu hanaloka oheko leko wo. ");
INSERT INTO yby_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ito wewena makolimo emo nesakamu wako nolidekoma aha mitaniyo. Ito aha sainaka mako leto-minatuwe loko lidekoma aha mo. 38 Eks 21:24; Liv 24:20; Dut 19:21 ");
INSERT INTO yby_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Monoka mako sa-liki likaka niaboma edimo elikaka niabo maya ne: Emo ukaya iwekada mo. Ito ulakalo wemidana uka mamo. ");
INSERT INTO yby_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Liki li-minaboya, nemokaho sa-loko lo noliboe: Ulatipolo wewenasidaya duka biki nasahili ibitalo. Lahelamibo nesa lolo ilibitatabo wewenasidamuya Omailoka lilo. ");
INSERT INTO yby_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Sa-ikiki okulumau ahotipoda oluhola lalo lolo iki minatae. Emokahoya lokaiyoko ho silihilalimoya wehe labo wewenaki wehe lamabo wewenakiya muki makoko aweyaha oko he lameda lobetokaka noiye. Ito emo lokaiyoko goyamo lahelamabo wewenaki ito wehe liki minabo wewenakiya makoko aweyaha oko jeko eha jebotokaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Edimoya duka libitabo wewenago nasahili ibitiki duka bitaboya, Omailokatiya meinawa lamitabo ne. Takisi ehada likaka niabo we mudaidi aha nesa lolo ikaka niabo wesiya ayamidana iki duka limitabo wewenaya luka betudawo ne, liki likaka niae. ");
INSERT INTO yby_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ito iwetelesidagoya eke libitataboya, edimoya saina dowa li lolo amae. Monoka elamabo wewenasiya ayamidana iki iwenipolesidagoya eke libitikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yamuya edimoya okulumau ahotipo wehe lokogo nebo nesa liki minalo. 43 Liv 19:18 48 Liv 19:2; Dut 18:13 ");
INSERT INTO yby_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Edimoya monokamuye liki wewena dilipi lalo iki nasahili ibitatabo nesamuya aito wewenasiya muda-elikiki lepoka litae liki samideyo. Edimoya wewenasi lepoka litae liki sa-itaha, okulumau ahotipokahoya meinawa libamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yamuya wewena dilipiki nasahili ibitadeko iwetipolesiya mudai lalo itae liki wewena domuda hamilo. Depa uluma lowe nebo wewenasiya suwaki namaki aya ladanaki monoka numukuya ito wewena domudaloya mudaleli lalo iki lepoka litae liki sa-ikaka niae. Sa-onenako, nemoya wehe loko lo libituyo, elilo: Sakiya wewenasi depoka likaka niabolimoya meinawanipo lolo okaka noiyoko alo leyoko suwokaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wewena dilimiki nasahili obetatune likima dade lamawakalokati sunaukaya sa-ibitalo. Sa-ideko dade atahakaloka minabo wewenasiya mudaki elamitae. ");
INSERT INTO yby_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Sa-ideko nasahilika maya sunauka netiye. Ahotipokahoya sunauka likaka niabo nesaya mudaokaka noinako, meinawaya libekolaiye. 1 Mat 23:5 ");
INSERT INTO yby_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Edimoya Omailoka nilikima suwaki depa uluma lowe nebo wewenasi likaka niabo nesa lamilo. Edimoya monoka numuku nebo ito wewena domudaloka neboya mudaleli lalo itae liki siniki likaka niae. Sa-ikaka niaboya nemoya ga lalo lo libituyo, eli-minalo. Omailoka liminaboto depoka likaka niabo nesalimo meinawanipo lolo iyoko aloya likaka niayoko suwokaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Edimoya Omailoka letune likima numudatipouya yowiki anuya vikiki miniki ahotipo sunauka mudaokaka noibo wemitokaya litae. Sa-ikadeko sunauka saina lolo ikaka niabo nesamidana meinawatipo ahotipokaho libekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Edimoya Omailoka nilikima wavu-liki yupeka liwa liwa ideko woko hana-pana lolo ideko aha gaya lolo okatiyo. Monoka elamabo wewenasiya Omailimoya lowa lowa uniyoko ele limitihe likiki sa-ikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Omailimoya sainahenamu ohu nojekoma, enemane oko owaha wako lamudawoto aha elekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sa-onenako, yamuya sa-liki Omailoka litae: Okulumau ahotelika, ulikaya eto oko minadeyo. ");
INSERT INTO yby_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Numuto namato ujapa oletokaka elewoleyakama soto peko suwideyo. Okulumauya emo ladawotoka moladawotoka iki elekele igitikaka niae. Sa-ikaka niabo nesa maya ma mikau lemotokakiya asako soto pideyo. ");
INSERT INTO yby_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Muki yulakaya nodenesate lemo. ");
INSERT INTO yby_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Lemoya iwetelesida lihimanipo le hulobetudawo nesa leko lemo lihimatema le-minadawo maya le huloleto. ");
INSERT INTO yby_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Emokahoya muluteu hitibo nesalo lilime molamo. Lahelamibo weloya le olowe oleto. ");
INSERT INTO yby_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Edimoya iwetipolesida lihimanipo li hulibitataboya, okulumau ahotipokaho asako lihimatipo le hulolibetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ito edimoya iwetipolesida lihimanipo hulibitamitaboya, asaoko okulumau ahotipokahoya lihimatipo hulolibetamekolaiye. 5 Luk 18:10-14 14 Mak 11:25-26 ");
INSERT INTO yby_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ito monokamuye liki nodenesa mosiki Omailoka litabo yupekaya monoka elamiki depa uluma lowe nebo wewenakidana iki minamilo. Maloka wewenasi nodenesa mosikaka niaboyae likiki depoka litae liki dokepauka uha lada iki dokepa lahelamiye. Sa-ikaka niaboya, nemo ga lalo lo libituyo, elilo. Wewenasi depoka likaka niabo nesalimoya meinawanipo lolo okaiyoko aloya likayoko, suwokaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Edimoya monokamuye liki nodenesa mosikiliya noku udiki yopatipo komu tiki li lalo ilo. ");
INSERT INTO yby_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Sa-ikiki wewenasi nodenesa nimoseboya mudai wehe lamitabo ne. Sa-ikadeko ahotipo sunauka nebo welimo elitiye. Ito sunauka lolo ikaka niabo nesamidana meinawaya ahotipokahoya libekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mikau uvaminatipoya aupa silekaka ito unakodalimo hukokaka ito numuda leda jiki ukele likakamidana neyo, ma mikauka uvamina maya li nupa nupa amilo. ");
INSERT INTO yby_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Edimoya okulumau uvaminaya aupa silamodemidana ito unakodalimo hukamodemidana ito ukelelo wesi numudatipouti leda jiki ukele lamikakamidana li nupa nupa itayo. ");
INSERT INTO yby_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Eli-minahe, uvaminatipo lalo netibotoka maya data ki moladeko minatibo ne. 19 Jem 5:2-3 ");
INSERT INTO yby_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Omudakaya upakamidana lela ne. Omudakalimo umu helekaka anugu ilime molametiboya, Omaimidana lelamo ukauya he lameda letibo ne. ");
INSERT INTO yby_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ito omudakamamo ilime lahelamibo etiboya, ukauka ayamidana oko lubu je-minakolaiye. Ukauya leya lonebo leya hitiboya, lubu napa-napa aitomidana jekadeko opa napa nei moloko minakolane. ");
INSERT INTO yby_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","We makokolimoya duliki we lowelo elekele yowanu lebetamekolaiye. Sa-etiboya, we makomidana uka mekoko makomamidana uka mamekolaiye. Makomalokaya kolokoko makomamidanaya muda-elo hulakolaiye. Edimoya ayamidana iki Omaimidana yowanulaki ito ehadamidana yowanulakiya makoko aweyaha oko lekaka nesa minamiye. ");
INSERT INTO yby_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yamuya nemo sa-loko lo libituyo, elilo: Edimoya miniki liki itabotokaya nodenesa nakahauti leko noko ito lupaloya nakahaukati le koloko minatudawo ne liki data kamilo. Edimoya ma lilegae. Nakaha nesaya saina ulawa ne, ito nakaha nesaya aha nesa ne. Miniki liki ikaka niabo nesaya saina lalo nehe, ito nodenesatipoya saina lalo ne. Ito dukaya saina lalo nehe, ito dupalo olo jitabo nesaya saina lalo ne. Minoko leko etudawo nesa ito lupateya saina lalo maya nebolae. ");
INSERT INTO yby_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Edimoya okulumaloya namaya mudalo. Saina-henanipoya ma yuha amae. Ito nodenesa omolokaiyoko liki wiki li numuku molamae. Sa-ikaka niaboya, ahonipo okulumau welimoya nodenesa bekaka noiye. Sa-obetokaka noinako, edimoya nama minamae. Wewena ma minanako, nama mukiya limiki minayoko, edimo yowiki nianako, saina-paina ohu jitabo nesaya aha le soto mololibetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Edimokutiya we makomalimo mulunauka eleko eimola minoko leko etiboto ata eleko melekema melekema le hula hula oko minatubo ne, loko letiboya suwaki napa-napa lekolaiye, ma sametiboto ne. ");
INSERT INTO yby_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ito dupalo nesamuya nenaha iyoko mulutipou elikaka niae. Yau nesaya uvawa okaka noibo nesamidana monawaya eli wehe lamahe. Yatoka nesaya yowanu lamae. Ito dupalo nesaya ma oto iki li kolatabokumu data kamae. ");
INSERT INTO yby_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sa-ikaka niaboya, yamuya ma lo libituyo, elilo. Hapa yeikalaya uliki we Solomonikahoya onowela lalo le kolokaka oneboya, yaukati uvawaki nesalimoya Solomonida upalo nesamidanaya asetoko ne. ");
INSERT INTO yby_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yauka nesalimoya olotiya uvawa okaka noiye. Ito hoya lokaiyoko aya nesa maya opatekaka noiyoko hukiki joya jikaka niae. Sa-oneboya, Omailimo liboto yauka nesahenaya onowenipo li kolikaka nianako, yamuya edimo amanamasi eli elewole niabo wewenalitaya Omailimo dupalo nesa aha le soto mololibetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yamuya lemoya nodenesaya nakahauti leko natune, ito lupalo nesaya le kolatudawoya nakahauti le kolatune liki data etipa kamilo. ");
INSERT INTO yby_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Monoka elamabo wewenasiya aya nesamuya data etipa kiki ohu jikaka niaboya, okulumau ahotipokaho aya nesaya edimotoka minametiboya dupaya dowa lametibo ne loko elene. ");
INSERT INTO yby_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Edimoya Omaimo uliki wetipo lolo etibo anugu ito Omailimo wehe loko minokaka anuguya duka data omutiki moladeko minadeyo. Sa-itaboya dupalo nesaki aha nesakidana libekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yamuya aijo soto pitibo nesamu data etipa kamilo. Aijo soto pitibo nesamidana edawaya aijo nesa neyo. Muki yupeka soto pitibo nesamidana edawamuya li makoko yupekago moliki data kamilo. 29 1 Kin 10:4-7; 2 Klo 9:3-6 ");
INSERT INTO yby_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Edimoya wewena makosida lihimanipomuya Omailimo sako obi obetatibo ne liki data kiki lamilo. Omailimoya asako lihimatipomuya lokatiyo. ");
INSERT INTO yby_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Edimoya wewenasida lihimanipomuya li hukibitataboto Omailimo makoko oko lihimatipoya lo hukolibetakolaiye. Ito edimoya wewenasitoka iki moliki itabo nesa leko makoko aweyaha oko edimotokaya iki moliki ikilae. ");
INSERT INTO yby_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Loko lokoko, olisatemuya koha moloko ga mako sa-loko lo biye: Iwekada omudauya ilisa mako ne loko ladawoya eimoka omudakauya ya lana woko neboya nenaha iyoko mudakoko lamane. ");
INSERT INTO yby_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Emo omudakauya ya lana woneboya mudamoko, nenaha iyoko iwekada omudau ilisaya le huloetatuwe loko nolane. ");
INSERT INTO yby_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Suwalo we epa ulumaka lowe nebo welika, omudakau yaitaya ya lana neboya omutoko le hulokoko muda wehe lokoko alikaya iwekada omudau ilisa le huloetatadawoya wehe lekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Edimoya monokamidana ga lalo maya ulakidana wewenaya li bamilo. Aya wewenasiya aku li wili jiki kohilibitikatae. Ito monokamidana meinawa yoweko nebo ga maya jakidana wewenasida li bamilo. Aya wewenasiya monokatipoya li opa ikatayo. 8 Mak 4:24 ");
INSERT INTO yby_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Omailoka loka iki wako likaka niabo wewenasiya sainahenaya alo likaka niae. Ito ohu jikaka niabo wewenasiya saina ihilawaya alo li soto molikaka niae. Ito atetoya esopa jikaka niayoko anu siyebetokaka noiye. Sa-nianako, Omailoka litaboya aya nesaya likilae. Ohu jitaboya ihilawa li soto molakilae. Atetoya esopa jitaboya anu siyelibetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Edimokutiya we makomidana ipalakahoya nodenesamu wako letiboya, aholakahoya ehada omudala mitibo nehe. Ito lahawamu wako letiboya oleteha mitibo nehe. O'e, samekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Edimoya wewena lahelamabo minaboya, ");
INSERT INTO yby_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","oluhotipolesidaya nodenesa lalo biki ujapa lalo nesa ibitikaka nianako, okulumau ahotipoloka loka iki wako litabo nesaya leko yoweko lalo nesago le heko mololibetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Edimoya wewenasi yamidana mamidana nesa lolo ilitatabo ne liki data kikaka niabo nesa liki asaiki lolo ibitalo. Aya sa-liki li-minabo galimo Mosesekaho lo hukoko libo gauti ito Omai epauti ga likaka wesi api-napi ikaka gautikiya muki le nupa okoya ne. 12 Luk 6:31 ");
INSERT INTO yby_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sima nokaka atedamidana anulaya napa-napaya nenako, ito aya anugu wokaka nesaya moleto nenako, yauyago muki wewenaya wikaka niayo, yamuya aya anuguya wamiki okuluma ateda lasolauya yowilo. ");
INSERT INTO yby_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Elewole oko minokaka ebamidana anu atedalaya lasolasi nenako, ito osele yowanu liki yowitabo nesa lenenako, maloka wewenasigo yowikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Suwa sawa monoka li-lili monikaka niabo wewenasida dupa esuwalokaya sipisipi jakidana you loneha, obohanipouya liwe ulakidana minayo, aya wewenasiya edimotoka nisitabomuya duka ujapa iki minalo. ");
INSERT INTO yby_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Edimoya lolo itabo nesalimo monawanipo maya lo soto molokadeko mudai wehe litayo. Hililibalimoya nokaka ihilawa jitibo nehe. O'e, sako minamiye. ");
INSERT INTO yby_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ya lalolimoya ihilawa lalogoya jekaka noiye. Ito lahelamibo yalimoya lahelamibo ihilawago jekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ya lalolimoya lahelamibo ihilawa jekaka nesa minamiye. Ito lahelamibo yalimoya lahelamibo ihilawa jekaka noiye. Ito lahelamibo yalimoya ihilawa lalo jametibo ne. ");
INSERT INTO yby_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sa-onenako, wewenasida monawanipoya makoko aweyaha oko ne. Ihilawa lalo jametibolawa maya isa heko joku jekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yamuya suwa monoka litabo wewenasi iki moliki itabo nesalimoya monawanipo lo soto molokadeko edimosiya mudai wehe likilae. 19 Mat 3:10; Luk 3:9 20 Mat 12:33 ");
INSERT INTO yby_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","We napae, we napae liki likaka niabo wewenautiya maloka mukiya okulumamidana ebalau yowamikilae. Ahoneda gala emesalo molikaka niabo wewenasigoya yowikilae. ");
INSERT INTO yby_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Onawa napaloya maloka wewenasiya sa-liki li nimikilae: We napate yamalae, nemoya emo gakalo monoka lo bekaka nobo maya nehao. Ito akaloya wewenasida dukauti muki oloha lahelamabosida kohaidoko doli he hulobo maya nehao. Ito gakalo muki elewole nesahena maya lolo obo maya nehao. ");
INSERT INTO yby_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Liki li nimitaboya, nemoya sa-loko lo libitubo ne: Nemoya edimo mudaido wehe lamoe. Lokoya lahelamibo nesalo monebolalitaya alo wilo loko letuwe. 23 Sam 6:8 ");
INSERT INTO yby_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Sa-onenako, maloka wewenasiya nemo gane maya elikiki eli litabo wewenaya sa-iki minae: Ele wehe lonebo we makolimoya numudala maya ehada mupilalo vokaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","goya napa-napa jeko no maya ileko lasi napa iboya, ehada mupilalo vibo numuda maya elewole oko nebo ne. ");
INSERT INTO yby_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ito nemo gane elikiki eli hulikaka niabo wewenaya sa-ikiya minae: Nei we makolimoya numudala no ilika akeloya vokoko neyoko, ");
INSERT INTO yby_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","go napa jeko no ileko lasi napa ibolimoya aya numudala maya ipisoko hulikaiyoko lemeko pou loko udokoko hulupa jiye. ");
INSERT INTO yby_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisesimamo gaya ga maya lo beko suwokaiyoko, yaloka nisiki Jisesida gala elebo wewenasiya Jisesikaho api-napi oko lobetaibo gamuya elikiki aiyo wuiye liki sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Monoka monawa api-napi iki likaka abo wesida maya aito wewenasida ganipolo emesalo molatae loko neyopa, eimola elewoleyalaki gala maya nenako, emesalo molatae loko lo lemekaka noiye, liki lae. 29 Mak 1:22; Luk 4:32 ");
INSERT INTO yby_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisesima bolauti maya nolimiyoko, muki we mena maya emesalo moliki wae. ");
INSERT INTO yby_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Sakiya niwayoko, we mako mika ihi jelekoko nebo welimoya woko Jisesida maya i bola he mekoko sa-loko lo miye: We napao, nilime olutetuwe lokoma nilime olutonetamane. ");
INSERT INTO yby_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Loko liyoko, Jisesimamo ade petoko upalo noleko olutetane loko eleminoyo, oluto loko liyoko, mika ihi jelibo nesa maya enemane oko olutiye. ");
INSERT INTO yby_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Olutokaiyoko, Jisesimamo emoya wewenasida maya olutadawo gaya wetome oko lo bamoko woko Omaitoka jokila he mekaka we netibotoka maya upaka ilipekadeko mudakoko alo uliwitokane loko elitiye. Ito olutodawomidanamuya Mosesekaho libo nesa leko Omaimidana uda je mekadeko, olutodawomidana monawa maya muki wewenasi eli wehe litae, loko lo miye. 0 Liv 14:1-32 ");
INSERT INTO yby_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisesima Kapaniyamu numutokaya yowekaiyoko, Lomu wesida lowa wenipo makolimo elekele welada maya yoweko ilime wati etiye loko sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","We laho-we napao, elekele oluhone mako saina napa jeleko abuhala maya hulupa nojiyoko, miluma eleko numudaneuka maya ne. ");
INSERT INTO yby_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Loko lokaiyoko, Jisesimamo nemo woko ilime haka letuwe loko lo mekaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","aya lowa imiki wemamo we napane yamalae, osele anu nisekoko lahelamobo we minonako, numudaneuya nenahalo yowitane. Aha malo minoko epakaloti ga lokadeko elekele oluhone maya haka letiye loko liye. ");
INSERT INTO yby_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nemoya asako duliki wewenasida elekele wenipoya minoe. Ito lowa imi we 100 nemokahoya ujapa obetominoe. Sa-ominonako, makomidana yaloka wo loko letuboya aha wekolaiye. Ito makomidana niso loko letuboya aha nisekolaiye. Ito elekele oluhonemidana woko ya yowanu lo loko letuboya aha woko lekolainako, yamidana gakaya elewole onenako, emoya aha malo minoko gagoya lideko haka letiye loko noloe. ");
INSERT INTO yby_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Loko liyoko Jisesimamo gala maya elekoko agae lokadanaki, emesalo moliki wabo wewenasida maya sa-loko auha biye: Nemo wehe loko lo libituyo, elilo. Isilaelo wewenasikuti we mako maya welimo elewole oko elibomidana elibo wewena mako mudamobo ne. ");
INSERT INTO yby_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yamuya sa-loko lo noliboyo, elilo: Muki ho noyowibotokaki ho nolimibotokati Juda wewena minamabo wewenasiya nisikiki Aebalahamule Aesikile Jekopulekiya okuluma ebalau maya li esa iki miniki nodenesa niki elowa jiki minakilae. ");
INSERT INTO yby_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sa-nideko, edimo omutoko lesa molo libibo Juda wewenasidaya lubu jitibo anugu hulolibetokadeko yau maya limiki miniki depa tala-mitala iki miluma-aluma eliki minakilae. ");
INSERT INTO yby_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Loko lokoko lowa ujapa wemamidana maya sa-loko lo miye: Emoya numudakaloka wo, elewole oko eledawomidana ihilawa maya soto pekolaiye. Loko Jisesimamo epa ka oko lo nomiyoko, elekele oluhola maya haka liye. 11 Luk 13:29 12 Mat 22:13; 25:30; Luk 13:28 ");
INSERT INTO yby_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisesima Pitada numudalau yowiboma iloho dola maya upauya jo libo nesa elokaiyoko udoneyoko mudakoko, ");
INSERT INTO yby_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","adelo noliyoko upau jo libo nesa maya suwoetaiye. Suwokaiyoko, sinokoko Jisesida maya nasahili oetaiye. ");
INSERT INTO yby_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sa-okaiyoko ludaka noliyoko, dukau olohamidana weuna oluho nebo wewenasida maya dilipi-liki Jisesima nebotoka nise. Dilipi-liki nisikayoko, saina delaibo wewenasida maya dilipe haka lobetoko ito dukau olohamidana weuna oluho nebo wewenasida maya kohaidoko doli he hulaiye. ");
INSERT INTO yby_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Sa-iyoko, Omaimidana epaloti ga lokaka we Aesayakaho ga mako sa-loko luhuwa jenebo ga maya niseko pasiye: Aito aito nesa lelaboya emokaho le ohiboma ne. 17 Aes 53:4 ");
INSERT INTO yby_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sa-okaiyoko, muki wema menama aku nisiki Jisesida maya hi wego ae. Saboya mudakoko unala ipalale yuhasida maya noku lapeu maya ilimi-liki yola helega witae loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Loko liyoko, monoka monawa api-napi oko lokaka we makolimoya woko Jisesida amaitoka minoko sa-loko lo miye: Tisane yamalae, wetadawotoka litadawotokaya nemo emeke emeke oko moneko minakoloe. ");
INSERT INTO yby_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Loko lokaiyoko, Jisesimamo ahasiya mika golotonebokuya yowikaka niae loko lo miye. Ito namaya udatabo numudanipoya neboya, nemo okulumauti we utiya yamidana udatubo numudanehena ito madonelo oseleho moloko udatubo nesa minamiyoko ohu nojobo nenako, magoina wesiye loko ele wehe lo-minoko nolape, loko lo miye. ");
INSERT INTO yby_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ito Jisesiki magoina wabokutiya wewena makolimoya Jisesida maya sa-loko lo miye: We napane yamalae, emoya nenae loko elekoko nolane, nemoya woko ahoneya helikadeko le ale jetokoko niseko alikaya emesalo molatuhao. ");
INSERT INTO yby_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Loko lokaiyoko, Jisesimamo emoya olotiya niso. Nemoki magoina nowisiko helitabo wewenasida ale jibitikaka yowanuya duka helenetibo wewenakiya aya yowanu litayo, loko liye. ");
INSERT INTO yby_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Loko lokoko unala ipalale yuhamaki noku lapeu maya yowikiki wae. ");
INSERT INTO yby_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sakiya noku lapeu maya yowikiki niwayoko, ahuhulimoya enemane oko liye. Sakoya wavu-leko liyoko nomamo alahuka jeko lemeko noku lapeu maya waitekolaiye. Sa-iboya Jisesima omuda udoneyoko nenako, ");
INSERT INTO yby_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","unala ipalale yuhasiya ilimi sinikiki sa-liki lae: We napate yamalae, noku maya sima nakoluniyo, sinoko lilimowo. Liki layoko, Jisesimamo sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Edimoya lasolasi eli elewole i-minabolita, nenaha iyoko domodatipo wiye. Loko lokoko, sinoko ahuhumidana ito no alahuka jibomidana maya auha biye. Sakoya auha biyoko limiki you lae. ");
INSERT INTO yby_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Sakiya you likayoko, aya wewenamasiya agae likadanaki, sa-liki lae: Maya weya aitomidana weya ne. Ahuhumaki ito no alahuka jibomakiya gala maya eli leiyolae liki lae. ");
INSERT INTO yby_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Galeli adu no yola helegaloka maya wiki hetikiki Gatala mikaukaya yowiki we lowe maya olohamidana weuna oluholimo dukau nebo we minaiyoko mudae. Aya we loweya adoha we minainako, muki wewenasiya domodanipo adoha wokaiyoko nenako, minaibotokaya wiki monamabo ne. ");
INSERT INTO yby_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sa-ikaka niaibo we minainako, ya yupeka maya ono molikaka niabo ehada muliguti maya limiki Jisesida maya hotula ikiki enemane iki opa napa ga liki sa-liki Jisesida amowa jiki li meiye: Omaimidana ipalao, emoya nenaha iyoko lahelamibo nesa lolo oletakolo nonisene. Onawa maya owaha nisametibotoya osele miluma yowanuya nenahamuya lemekolo noane. ");
INSERT INTO yby_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Liki laiboya, ayalokaya ja wavu-liki yomaloka alo hoto apulu iki yowi niki minae. ");
INSERT INTO yby_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sa-iminayoko, olohamidana elekele welamasiya loka iki sa-liki laiye: Lolihe hulakolo noko maya loli he hulo yomaya ja li nupa iki minabosida dukauya hulo. ");
INSERT INTO yby_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Liki laiyoko, Jisesimamo wilo loko liyoko, wiki jasida dukau maya yowikiki minae. Yowikayoko, aya jasiya lakiwa epaloti nisiki ekimi noku jiki sima niki heli esa ae. ");
INSERT INTO yby_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sa-ikayoko, ja ujapa abo wesiya oli taoniloka wiki taoniguya olohamidana elekele we minabo wesida ganipo maya wetome iki li-lili mone. ");
INSERT INTO yby_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Sa-liki li bikayoko, taoni napaloti muki wewenamasi eli suwikiki, Jisesidama mudatune liki nisiki muda-elikadanaki mikateukati maya hulikoko wetiye liki emekeme ga lae. ");
INSERT INTO yby_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisesima noku lapeu maya yowekoko, numudalaloka aku le welepa jeko wiye. ");
INSERT INTO yby_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sakoya wokaiyoko, we ebili libo we makoya mokokolo molikiki yauha moliki liki nise. Liki nisikayoko, Jisesimamo elewole iki emotoka data kebolawa maya mudakoko sa-loko lo miye: Ipanelika, aku eda elamideyo, lihimaka maya alo le huloimikoe. ");
INSERT INTO yby_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Loko liyoko, monoka monawa api-napi ibikaka abo wesiya sa-liki dukaukaya ele: Omai pulekolo nolihe. ");
INSERT INTO yby_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Liki nieleyoko, Jisesikaho sa-liki data kebolawa maya mudakoko sa-loko lo biye: Dukaukaya nenaha iyoko lahelamibo niele. ");
INSERT INTO yby_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wewena makolimo lihimaka le huloetokoe loko letiboya, suwa nehe ito wati ga nehe yawaya ekahimamo mudaone. Sa-oneboya, suwa lobo monawaya elikatae loko maya enemane oko mokoloka ohekoko wo loko lo mamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Sa-oneboya, nemo okulumauti we utilikaya ma mikauya lihimatipo le hulokakamidana elewoleyaya nemotoka ne. Loko lo bekadanaki, yamidana monawahena maya mudai wehe litae loko we ebilimidana maya sa-loko lo miye: Sinokoko mokoloka maya ohekoko numudakaloka leko wo. ");
INSERT INTO yby_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Loko lokaiyoko, we ebili maya mokolola ohekoko leko numudalaloka wiye. ");
INSERT INTO yby_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sakoya wokaiyoko, muki wewenamasiya domodanipo adoha wokaiyoko, Omaimidana elewoleyala ma mikau wewenasitoka molaiboya minokaiye liki Omaimidana epoka lae. ");
INSERT INTO yby_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ya yupekaya takisi ehada lekaka we nemo nuline Matiyu takisi ehada lekaka numuku minoyoko, muda-nelokoko sa-loko ju lo nimiye: Emoya nemesalo moloko niso, loko lokaiyoko magoina woiye. ");
INSERT INTO yby_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sakokoya Jisesima unala ipalale yuhakiya magoina nemo numudaneu yoweko minoko nodenesahena noko minune. Sa-nouniyoko, takisi likaka weki ito edimo maloka lahelamibo nesa lolo ikaka niabo wewena minae liki data kikaka abo wemakiya minimi minimi nisiki lupaloka miniki nodenesa maya magoina minoko nune. ");
INSERT INTO yby_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Sakoya nonuniyoko, Palasisi wewenahenamasiya mudaikiki sa-liki lae: Ahotipo yaitaya nenaha iyokoma takisi likaka weki ito maloka lahelamibo nesa lolo ikaka wehenamakiya magoina minoko nodenesa nonaiye liki Jisesida unala ipalale yuhasitoka maya loka ilitae. ");
INSERT INTO yby_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Liki li lemeyoko, Jisesimamo elekoko sa-loko liye: Edimo saina jelamiki aha minabo welitaya lusa wemuya ju lamae. Saina delaibo wewenasigoya lusa wemuya ju likaka niae. ");
INSERT INTO yby_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ito edimoya monoka bukuguya Omailimo libo ga mako sa-loko nebo neyo, eli wehe liki elilo: Nemoya jokila hi nimitae loko elamoe. Duka hi nimikakakumuya ele-minoe. Ito dukadunuya wehe loko minune liki likaka niabo wewenasida dilipe lalo etuwe loko lemamoe. Nemoya lihimanipoki wewenasida dilipe lalo etuwe loko lemobo nenae, loko liye. 10 Luk 15:1-2 13 Mat 12:7; Hos 6:6 ");
INSERT INTO yby_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ya yupekaya noku udobetokaka we Jonida unala ipalale yuhasiya Jisesima nebotoka yowikiki sa-liki loka itae; Lemoya Palasisi wewenakiya monoka loko Omailoka loka etune loko nodenesaya mosekaka noune. Sa-okaka noudawo maya neboya, emo unaka ipakalekiya mosamayo, nenaha iye. ");
INSERT INTO yby_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Liki layoko, Jisesimamo mena ada iki mitabo welimo iwelaleki magoina minatabo yulakaya iwelalesiya emokumuye liki nodenesa mositabo nehe. Sako minamiye. Mena huki mitabo weki magoina minatabo yupekaya nodenesa mosamikilae. Sakoya neboya, aya oluhomidanaya iwelalesida dadeuti hipo itabo yupekagoya iwelalesiya milumala eliki nodenesa mosikilae. Yamidana makoko aweyaha iki alikaya unanele ipanele yuhasiya nemokumuya miluma eliki nodenesa mosikilanako, olotiya aha mosamikilae. ");
INSERT INTO yby_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ito lawo-lawo ohatamaya no jiki li lasola amabo lawo-lawo maya hukoko le aseha lawolawolo molo omeko oto okaka nesa minamiye. Oto ikiki nokalawe jikadeko ohatama lawolawolimoya isulupa jekoko aseha lawolawoloti hikalekadeko huko-loko woko napa okatiye. ");
INSERT INTO yby_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ito waeni noya etehu alakala noiyokoya asehawa nogodau jikaka nesa minamiye. Waeni noyamo nogodawa jeko potokoko waeni noya kisekadeko aya nogoda maya nosamo okatiye liki waeni noya etehu alakala noiboya nogoda ohatamaugo jikaka niae. Sa-niayoko, waeni nomaki nogodamaki dowa liki minaiye. Loko liboya galaya ohatama nenako, unalale ipalale yuhasiya iki moliki itaboya ohatama weunipogo iki moliki itabo ne, loko koha moloko ga liye. ");
INSERT INTO yby_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisesisiya monoka lo beko neyoko, monoka ujapalo we makolimo niseko Jisesida maya lipe meko sa-loko liye: Nemo olune maya olotiya alo helekainako, aha woko adelotiya maku meko ilime sinatane loko ilime-loko wetuwe loko nonisoyo, sinoko niso. ");
INSERT INTO yby_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Loko lo mekaiyoko, Jisesima unala ipalale yuhamakiya siniki aya weki magoina wae. ");
INSERT INTO yby_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sakiya niwayoko, mena makoya ukada anu molowa molowa oko meleke 12-pala le hulaibo mena nebo ne. ");
INSERT INTO yby_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sa-ibo mena nenako, aya menamamo ukalaukaya sa-loko eliye: Nemoya woko aha Jisesida upaloyahe ito upalo nesalo lekoko haka letuwe. ");
INSERT INTO yby_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Loko ata elekoko Jisesida emeke noniseko upalo nesa atawaloka maya liyoko, Jisesimamo mino wili jeko sa-loko liye: Oluneyaliyo, aku eda elamideyo. Nemodamu elewole oko ataka kedawolimoya ilime haka lokaiyo, loko lo miye. Loko lo mibo epakiya aya mena maya haka loko oladalama sepo jiye. ");
INSERT INTO yby_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sa-okaiyoko, Jisesimamo woko monoka ujapalo wemamidana numudalau mudaibo maya oluwalu heleiki musiki jikaka we maya li esa iki minayoko, wije namalimo lemo jeje oko nebo ne. ");
INSERT INTO yby_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sakiya sa-minayoko, Jisesimamo ayau maya yowekoko hulikiki wilo loko lo biye. Maya oluya helamiye, aha omuda udone. Loko aku ilime sinatobo ne loko ata keko liyoko, yau minabo wewenamasi aha yatoka ija ga lihelae likiki ija itae. ");
INSERT INTO yby_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ija nitayoko, doli heko hulo hetoka okadanaki, aya olumidana maya uditiminabo sipaloka alili yowiye. Sakoya woko alili nedanaki aya olumidana maya adelo leko ilime sinaiyoko, aya olu maya sinaiye. ");
INSERT INTO yby_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Sakoya sinokaiyoko, sinaibomidana gala maya muki mikauka maya woko suwiye. ");
INSERT INTO yby_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sa-okoko Jisesima ya numuda eba maya hulikoko wiye. Sakoya nowiyoko, domuda likaibo we lowe maya emesalo moliki waiye. Sakiya emesalo moliki niwiki amowa jiki ju liki Dewitida awola olisauti lilimitiye loko lo mololetaibo we yamalae, lemodaya milumate eleletowo. ");
INSERT INTO yby_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Liki likaiyoko, woko numukuya yowiye. Yowekaiyoko, aya we lowe maya nisiki okepaloka maya minaiye. Sakiya minaiyoko, Jisesimamo domudatipoya le pana kitibo elewoleya nemotoka ne liki elewole iki nemodaya data ki nimi-minaihe, loko loka obetaiyoko, aya we lowemasi we napate yamalae, alo ele-minoibolae, ");
INSERT INTO yby_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","liki laiyoko Jisesimamo domudalo maya lenedanaki sa-loko liye: Sakiya elewole iki eleibomidana ihilawa maya soto pideyo. ");
INSERT INTO yby_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Loko liyoko, domuda maya pana kekaiyoko, Jisesimamo sa-loko lo biye: Eliminaihe, sa-olibetobo nesamuya wiki wewenasida wetome iki li bamiliyo. ");
INSERT INTO yby_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Loko lokaiyoko niwaidanaki, ga maya eli eli waiboya, aya ga maya li pou likaiyoko, muki mikauka maya yomala jeko moniye. ");
INSERT INTO yby_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ito sakiya niwaiyoko, we mako oloha makolimo epala heko lagoli ibo wemidana mokololo molikiki yauha jiki liki nise. ");
INSERT INTO yby_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sakiya liki nisikayoko, Jisesimamo aya olohama kohako oli he hulaiye. Sakoya oli he hulikaiyoko ayalo maya epa ka oko gahena maya liye. Sa-iyoko nenako, muki wewenamasiya elikiki agae liki sa-liki lae: Isilaelo mikaukaya hapa yamidana nesa soto piyoko mudamudawo maya nenae, liki lae. ");
INSERT INTO yby_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sa-liki laboya, Palasisi wehenasiya Jisesidamuya sa-liki lae: Olohasida uliki wenipolimoya ilime wati okaiyoko olohamidana weuna oluhola maya kohaidoko wewenasida dukauti doli hekaka noiye, liki lae. 34 Mat 10:25, 12:24; Mak 3:22; Luk 11:15 ");
INSERT INTO yby_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sa-ikayoko, Jisesikahoya numuto namato moneko numuda lasola napaya muda suwokoko monoka numuda neboku neboku moneko monoka monawa api-napi obetaiye. Sa-idanaki, Omailimo uliki we lolo obetatibomidana gala lalo maya lo soto moloko lo beko moniye. Sakoya aito aito nesa delaibo wewenasida maya dilipe haka loko dilipe lalo omo wiye. ");
INSERT INTO yby_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sakoya muki wewenasida mudabo migelele-agelele iki opa napa minabo wewenaya, sipisipi ja ujapalo we minamayoko, aha minabokidana minayoko, mudako edimokumu ukala hiyoko, ");
INSERT INTO yby_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","unala ipalale yuhalita maya gala elikaka abo wewenamu koha moloko ga sa-loko lo limiye: Muki mijaku nodenesaya o-molokaiboya, yowanu lekaka weya lasolasi minokuniyo, ");
INSERT INTO yby_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","yamuya edimosiya wiki yowanu aholatokaya lideko dilipe yowanulo molokadeko yowanuwauya wiki mida numuda litae, loko lo limiye. 35 Mat 4:23; Mak 1:39; Luk 4:44 36 Nam 27:17; 1 Kin 22:17 36 2 Klo 18:16; Iji 34:5; Jek 10:2; Mak 6:34 38 Luk 10:2 ");
INSERT INTO yby_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisesimamo unala ipalale yuha 12-palasida maya lesa molo lemekaiyoko, nisekuniyoko oloha dukau netibo wewenasida maya kohaidiki doli hitae loko, ito aito aito nesa delonetibo wewenasida maya dilipi lalo itae loko, ito aito aito nesa jeli-minabo wewenasida maya dilimiki delatibo nesa maya li haka libitatae loko elewoleya maya limiye. ");
INSERT INTO yby_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposolo 12-palaya sako minune: Makoya uli Saimoni ohatama uliwa Pitate, unala Endulute, ito Jebetida ipala lowe Jemisiko unala Joniko, ");
INSERT INTO yby_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ito Pilipite, Batolomiyute, ito Tomasi, ito nemo Matiyu takisi ehada lekaka we, ito Alopiyasida ipala Jemisi, ito Tadiyusi, ");
INSERT INTO yby_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ito Saimoniya Lomu gamanimidana oli he hulakolo ibo we, ito Kaliyoti ebatokati we Judasiya Jisesida ulala wesito ilime soto molaibo we. ");
INSERT INTO yby_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Lemo 12-pala wesida maya yowanulo loli nohidanaki sa-loko monoka lo limiye: Edimoya hetoka wewenasi mikaloka ito Samaliya mikaloka wamilo. ");
INSERT INTO yby_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Edimo Isilaelo wewenasikutiya sipisipi ja mako woko tolowa onebo maya edimokutigoya wiki mudatae. ");
INSERT INTO yby_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sakiya niwikima Omailimo uliki we lolo olibetatibo onawa maya domudaloka nisekaiye, liki litayo. ");
INSERT INTO yby_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sa-likiki saina delatibo wewenahena maya dilipi haka litayo, ito helebolawa maya dilipi sinatayo, ito mika ihi jelebolawasida maya dilipi olutitayo, ito dukau olohamidana weuna oluho yowiki minatabolawasida maya kohaidiki doli hitayo. Meinawa minamibo aha nesakidana monokaya limibo nenako, asako meinawa minametibo aha dilipi lalo itae. Ito ehadatipo lasolasi makoki owo jiki lamilo, keke. ");
INSERT INTO yby_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Anu witabotokaya uka jikaka owo maya liki wamilo. ");
INSERT INTO yby_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ito owo lowe uka jamilo. Ito dilo su maya jamilo. Sakiya akisalo lamiki aha wilo. Sakiya wiki yowanu litabo welotiya nodenesa liki nataboya wehe loko ne. ");
INSERT INTO yby_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ito anu makomaloka wiki hetikikima adaya eba aholamidana maya loka iki aya eba monawamuya elilo. Ito aya ebatokaya we makomidana monawala dowa letibo maya, aya wekiya udiki siniki iki miniki yalotiya hulitikiki wilo. ");
INSERT INTO yby_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sakiya yowiki numuku maya miniki makuya edimotoka minadeyo liki li bilo. ");
INSERT INTO yby_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Numuda aholalesiya dilipi numuku molikadeko minikiya aya li bebomidana ihilawa maya soto pitibo ne. Ito sakiya minataboya, monawanipo lahelamideko maya makumidana gala maya aku le wili jeko edimotoka nisekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ito eba makomaloti dilipi lalo iki gatipoya elamikadeko maya, aya eba maya hulikiki niwiki huka biki diloti mumusopa maya pu liki li hulikiki wilo. ");
INSERT INTO yby_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nemoya wehe loko lo libituyo, elilo: Onawa napaloya Sodomu numutoka ito Gomola numutoka minabo wewenaya lihima napa litabo neha, edimo dilipi lalo amitabo wewenaya Sodomu Gomola wewenasida lihimanipomidana asitiki likilae. 7 Luk 10:4-12 10 1 Kol 9:14; 1 Tim 5:18 14 Apo 13:51 15 Mat 11:24; Jen 19:24-28 ");
INSERT INTO yby_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Eli-minahe. Liwe jakidana minabo wewenasida luwawanipouya sipisipi jakidana iki hulu iki minatae loko doli nohoe. Sa-ominoyo, edimoya eli wehe likiki juna iki minalo. ");
INSERT INTO yby_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Edimosidaya dadelo likiki liki obilo wikilae. Ito monoka numudanipou monoka numudanipouya seida oijoya kohaidakilae. Sa-ikilayo, ehe, edimoya ujapa lalo iki minalo. ");
INSERT INTO yby_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ito nuline edimotoka nebokumuye liki dilipi-liki duliki wesida ito kiyapesida domudaloya wikadeko ga yowanuya lilibitakilae. Sa-ikadeko maya muki hetoka wewenasida dowisalokiya nemo gane maya li soto molatayo. ");
INSERT INTO yby_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Edimoya nemo ganemuya dilipi-liki obilo witabo onawaloya aiyo, nenae loko letupe liki, ito nenae loko lata keko letudawo ne liki, data kideko eda delamideyo. Ya onawalo ga litaboya Omaimidana weuna oluholimoya depalo le aila jitibo neyo. ");
INSERT INTO yby_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sa-ideko gaya lideko gatipoya lolo amekolaiye. Ahotipoda weuna oluholimoya madotipou ga lo nomoladeko litae. ");
INSERT INTO yby_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ito yatolakaho unalada adelo lekoko leko woko obi oetadeko unalada maya kohai helikilae. Ito aholakaho ipalada maya adelo leko woko obi oetadeko ipalada maya kohai helikilae. Ito oluhonipolesiya donipole ahonipolesida maya obi ibitadeko, kohaidi helikilae. ");
INSERT INTO yby_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ito muki wewenasiya nemo nuline edimotoka nebokumuya asolawaki nesa libitakili niaboya, maloka wewenasiya onawanipo suwetibotoya monoka hulamiki elewole iki li-minataboya, Omailimo dilimekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ito eba makomalokatiya Omaimidana galamuye liki lahelamibo nesa lolo ilibitadeko maya, oli ikiki eba makomaloka witayo. Nemoya wehe loko lo libituyo, elilo: Edimoya monoka yowanuloya Isilaelo mikauka ito eba makomaloka owaha li biki suwamideko, nemo okulumauti we utiya enemane oko nisekoloe. ");
INSERT INTO yby_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sukulu oluholimoya tisalasida asebetoko yoweko minamekolaiye. Elekele welimoya uliki welada asetokoko yoweko minamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sa-onenako, sukulu oluholimoya tisala oko moloko etibotoya makoko aweyaha oko minadeko wehe lekolaiye. Ito elekele oluholimoya uliki welamo oko moloko etiboto makoko aweyaha oko minadeko woko wehe lekolaiye. Ito nemokumuya oloha mako uliwa Belejebulo liki li-minabo nenako, oluho unamotakuse, nemokumuya dulitipoya liki mumusopa ji-liki wiki minakilae. 17 Luk 21:12-15 21 Luk 21:16 22 Mat 24:9; Luk 21:17; Mat 24:13 24 Luk 6:40; Jon 13:16; 15:20 25 Mat 9:34; 12:24; Mak 3:22; Luk 11:15 ");
INSERT INTO yby_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yamuya edimo lahelamibo nesa lolo ilibitatabokumuya domodatipo wamideyo. Hitonetibo nesa makolimoya minoko tolowa amekolaiye. Aya yatoka nesaya minoko alikaya soto pe suwetiboto ne. Ito asako sunauka lolo i-minabo nesakiya soto peko suwekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nemoya lubu jiboku minoko moletoko lo libobo gaya edimoya sakiya miniki alikaya li soto molatanage. Ito datauka musika loko lo nolibobo gaya alikaya edimosiya limiki numuda hetokaya miniki ga napauti li soto molatanage. ");
INSERT INTO yby_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Maloka wewenasiya dupago kohai helikilae. Weutipo kohai helitabo nesa lamiyo, sainama sainama itatabomuya domodatipo wamideyo. Ito weutipohena ito dupatipohena le nupa napa oko jo ebaku koha helekaka we Omaimugoya domodatipo wideyo. ");
INSERT INTO yby_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nama somohenaya aha nesa minanako, ehada makokolotiya somo lowe meina hikaka nesa neboya, ahotipokahoya mudametiboyaki somo makokomaki lemo mikauka jamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Edimoya madotipo yopalaya lepekaka nesa Omailimo makoko elene. ");
INSERT INTO yby_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Edimoya nama somokidana minamae, wewenae liki nesa maya minanako, Omailimoya ujapa olibetokaka noinako, saina makomuya domodatipo wamideyo. 26 Mak 4:22; Luk 8:17 ");
INSERT INTO yby_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Wewena malokasida domudaloya nemo nuline li soto moliki nilimi napa itaboya nemo asako okulumauya ahoneda owisaloya dilipe napa etuboya ne, ");
INSERT INTO yby_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ito wewenasida dowisaloya nulineya jiwi hitiwi itaboya, asako nemo ahoneda owisalaloya dulitipoya jewo hitowo olibetatubo ne. 33 2 Tim 2:12 ");
INSERT INTO yby_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Edimoya nemokumuya mikauka hulu le soto molatuwe loko lemenebo ne liki lamilo. Nemoya hulukigo minamoe. Lowaki le soto pituwe loko lemobo ne. ");
INSERT INTO yby_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nemo lemobomidana ihilawaya, aholako ipalakosiya lowa moila hiki dokepa hoto-poto netibo ne. Ito dolako oluwakoya lowa moila hiki dokepa hoto-poto netibo ne. Ito omebalako omebalakoya lowa moila hiki dokepa hoto-poto netibo he. ");
INSERT INTO yby_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ito makoko numukutihe ito edimo minatabo yuhautiya ula weutipo lolo ikilae. ");
INSERT INTO yby_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ito edimo dotipole ahotipolesida duka moli bikiki nemodaya lasolasi moli nimitaboya nemo oluhone lolo itabo aweyahalo minamae. Ito oluhotipoloka duka moli bikiki nemotoka lasolasi moli nimitaboya, nemo oluhone lolo itabo aweyahalo minamae. ");
INSERT INTO yby_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ito miluma nesa li ohilibitatabokumuya eli hulikiki nemo nemesalo moliki nisamitaboya, nemo oluhone lolo itabo aweyaha minamae. ");
INSERT INTO yby_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ito maloka wewenasiya dukaya li amanapa iki li-minataboya, wiki opa itabo ne. Ito maloka wewenasiya nemokumuye liki dupa wina itaboya, alikaya minowa minowa okaka depa mutiwa suwametibo likilae. 35 Mae 7:6 38 Mat 16:24; Mak 8:34; Luk 9:23 39 Mat 16:25; Mak 8:35; Luk 9:24; 17:33; Jon 12:25 ");
INSERT INTO yby_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ito wewena malokasiya edimo nasahili ilibitataboya, nemoda nasahili initabo elene. Ito nasahili nemoda initataboya, noli hibo wemidana nasahili itabo elene. ");
INSERT INTO yby_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ito monoka lo lele we makomidanaya nemokumuye liki nasahili itataboya, nasahili itatabomidana ihilawa meinawa litabo ne. Ito we makoya monokalaki we netiboya, monokalaki wema nenae liki nasahili itataboya, meinawa litabo ne. ");
INSERT INTO yby_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sa-onenako, nemoya wehe loko lo libituyo, elilo: Edimoya nemo wewenanele yuhautiya mako limiki minabokuti nemo ipane nebokumuye liki no hiki mitaboya aha nesa lolo amekolaiye. Meinawa litabo ne. 40 Luk 10:16; Jon 13:20; Mak 9:37: Luk 9:48 ");
INSERT INTO yby_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisesimamo ga maya lo beko suwokoko unala ipalale 12-palaya minudawotoka minudawotokaya wewenasidaya monoka monawahena api-napi obetakolo wiye. ");
INSERT INTO yby_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sa-okaiyoko, monoka noku udobetokaka we Joni maya nala numuku nedanaki, Jisesi Kalaestimamo yowanu libo ga maya elekadanaki, unala ipalale yuha lowe maya doli hekaiyoko Jisesitoka wiki sa-liki li meiye: ");
INSERT INTO yby_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Soto pitiye liki monoka bukugu luhuwa ji-minabo we maya emoya minape, ito alika mako soto pitibokumu ewa etune liki loka itaiye. ");
INSERT INTO yby_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Liki loka itaiyoko, Jisesimamo edimoya aku li wili jiki wiki oliwaki nesa mudaibomuya Jonida maya wetome iki li miliyo. ");
INSERT INTO yby_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Domuda likonebo we maya le pana kebetokaka noiye. Ito dilo lenebo wewenasida maya dilipe lalo okaka noiye. Mika ihi jelebosida dilipe olutokaka noiye. Ito data molonebo wewenasida maya le golotokaka noyoko aya elikaka niae. Ito lepa ono maya dilipe sinokaka noiye. Limiki minabo ito sainanipo minamibosiya gane laloya elikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sa-onenako, nemo monawanemuya edimoya kata eli-minadawomidana oko nehekala, aitomidana oko yowanu lekaka obomu data lowe kamitabo wewenasiya elowa jiki minakilae. ");
INSERT INTO yby_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Loko lokaiyoko, Jonida unala ipala lowe maya aku li wili jiki Jonitoka niwaiyoko, Jisesimamo ayalo minabo wewenasida maya le wili jeko Jonidamuya sa-loko lo biye: Edimoya mumusopa mikaloka wabo maya nenamidana we muda-elatune liki wabo ne. We Joniya akepa lasilimo liyoko mino yeilaloka maloka ibomidana oko lowe alo we nedeko muda-elakili wabo nehe. ");
INSERT INTO yby_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Emo upaloya onowe lalo kolokoko neyoko mudatune liki wabo nehe. Eli-minahe. Luhuwaki onowe kolikaka weya duliki wesida numuku udiki siniki ikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Joni maya Omaimidana epaloti ga lokaka we neyoko mudatune liki wabo nehe, olo. Ga mako lo libituyo, elilo. Edimo mudabo we maya Omaimidana epaloti ga wetome okaka wekidana minamiye. Emoya aitomidana oko ne. ");
INSERT INTO yby_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Monoka bukuguya Omailimo libo ga mako sa-liki luhuwa ji-minabo neyo: Elilo. Nemo gane lo-lele monitibo we mako oli hekoyoko le omutoko woko dukau yowanu litibomidana anuwaya wiletakolaiye, loko libo ga maya Jonitoya niseko pasiye. ");
INSERT INTO yby_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sa-onenako, wehe loko lo libituyo, elilo: Mikauka soto piminabo wewenauti wewena makolimo noku udobetokaka we Jonidaya ma li asamaboya, Omaimidana ujapalalo muki limiki minabo ito yowiki minabo wewenasiya Jonida lasolasima asitiki minae. ");
INSERT INTO yby_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Joniya monoka noku udobetokaka ibo onawalotiya mino-loko yoweko Omaimidana ujapalaloya wehe loko soto piyoko, muki wewenasiya lowa-sawa iki Omaimidana ujapalalo yowiki minakili dabuha molikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Omaimidana epaloti ga likaka weki ito Mosesekiya mukitoka alikaya soto pitibo ga maya Omailimo uliki we lolo etibomuya likayoko, Joni maya alikaya soto pibo ne. ");
INSERT INTO yby_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ito makoki eletune liki lidekoma, lo libituyo, elilo. We makoya Ilaijakidana nisitiye liki labo maya Joniya nisiye. ");
INSERT INTO yby_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sa-oneyo, edimo dataki minatabo wewenasiya maya aya eli wehe liki elilo. ");
INSERT INTO yby_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Oloti maya onawalo minabo wewenaya nenahalo lo moloko lokoyoko wehe letiye. Edimoya eli osele iki pelesa jikaka oluhokidanaya minae. Oluho li esa ikaka ebatoya minadanaki oluho malokasida maya sa-liki ju liki li bikaka niae: ");
INSERT INTO yby_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Edimoya nenahamuya nama ludawotoya lemesalo moliki lamae. Ito malokaya wije nama ludawotoya nenahamuya wije nama lamae liki likaka niaboya, nemo Joniteya yamidana mamidana okaka noiyoko edimoya osele delokaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jonikahoya aya yowanuya api okoko nodenesa lalo namidanaki no lalo namidanaki eto oko minokaka onebo ne. Sakoya eto oko neyoko mudaikiki oloha makolimo uka le opa okaiyoko ne liki likaka abo ne. ");
INSERT INTO yby_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ito malokaya nemo okulumauti we utiya lemekoko nodenesa lalo noko no lalo noko okaka noyoko muda-nelikiki maya weya mudalo. Emoya aso we minokoko ito ekesa nolo we minokoko takisi ehada likaka weki ito maloka lahelamibo nesa lolo ikaka niae loko lata kekaka noudawo wewenaki magoina minoko nodenesa nokaka noinako, iwenipo netiye, liki likaka niabo maya neboya, Omailimo ele wehe lo-minoko saina-maina lolo okaka noibomidana ihilawa maya soto pekaiyoko, wewesoko minokaka noibomidana monawa maya soto pekoko ne, loko liye. 5 Aes 35:5-6; Aes 61:1 10 Mal 3:1 12 Luk 16:16 14 Mal 4:5; Mat 17:10-13; Mak 9:11-13 ");
INSERT INTO yby_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisesimamo eba maloka maloka yowanu le loko woko muki oliwaki nesa maya le soto piye. Le soto pekaiyoko, mudabo maya mudai hulikiki yoga lemega ikiki duka li wili jamayoko, Jisesikaho ga maya le api oko lo beko sa-loko auha biye: ");
INSERT INTO yby_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Agae, Kolajina wewenalika ito Betiseda wewenalikaya, edimotoka oliwaki nesa mako soto pekolaiye. Elewole ane edimotoka lolo oboya lahelamibo eba lowe Taeya ebatoka ito Sidoni ebato soto pibo minatidanako, edimoya hapa dukauya miluma eliki duka li wili jebomidana monawaya li soto moliki dupalo nesa bolotonetibo nesa li olo jikiki jo laku udiki minatine. ");
INSERT INTO yby_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yamuya lo libituyo, elilo. Taeya ebatoka ito Sidoni ebatoka wewenaya onawa napaloya lihima litaboya, edimoya lihima napa edawaki likilae. ");
INSERT INTO yby_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ito Kapaniyamu wewenalitaya, lulite maya okulumau yowitiye liki li sawa jiki likaka niahe. Sakoya minamiye. Jo ebaku limitabo ne. Ito oliwaki elewole nesa edimotoka soto pibo maya Sodomu numutoka soto petidanako, dukaya li wiji jikadeko aya eba maya tolowa ametine. Sakoya oloti maya onawaloya aya eba maya aha minatine. ");
INSERT INTO yby_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yamuya lo libituyo, elilo: Lihimatipo libitibo onawalo maya Sodomu numutoka wewenasi lihima napa litabo neboya, edimodaya napa-napa edawakiya le ohelibetakolaiye, loko liye. 21 Aes 23:1-18; Iji 26:1-28:26; Joe 3:4-8; Aim 1:9-10; Jek 9:2-4 23 Aes 14:13-15; Jen 19:24-28 24 Mat 10:15; Luk 10:12 ");
INSERT INTO yby_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ya yupekaya Jisesikaho sa-loko lone: Ahonelika, emoya yowa okulumaki ito ma mikaki ahonipoya minane. Sukulu loko ele wehe lominune liki likaka niabo wewenaya monoka elikiki eli wehe likatae loko le suna molobetokoko sukulu lamiki oluho aidamidana minabo wewenasidaya dukau molobikaka noane. Sa-okaka noadawomuya nemoya epoka noloe. ");
INSERT INTO yby_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ahonelika, yamidanago soto pe-loko wetiye loko eledawoya wehe lone. ");
INSERT INTO yby_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Loko lokoko amida meko sa-loko liye: Ahonekahoya muki nesahenaya nadeu molo suwokaiye. Sa-oneboya, wewena makolimoya Omai ipalada monawala maya ele wehe lamiye. Ahone makokokahogoya elene. Ito ahoneda monawalaya muki wewenasi elamae. Nemo ipalakahogo ito lo soto moloko lo bekoyoko eli wehe litae loko letubo wewenakigoya lelimotego ahoteda monawala ele-minune. ");
INSERT INTO yby_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Osele pasele iki yoga lemega iki sainahenalimo eda delokaka noibo wewenalitaya, muki siniki nemotoka nisilo. Dilipe eha jituyo. ");
INSERT INTO yby_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nemoya you loko minoko, nuka lalokiya minoe. Sakiya nisikadeko nemo gogoya mololibetatuwe. Sakoya mololibetokoyoko, nemotokati ga lalo elitayo. Sa-okoyoko weutipoya leso oko mino laloko netiye. ");
INSERT INTO yby_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nemo gogoneya huluwa lalo ne, ito edawaki minamiye, loko liye. 27 Jon 3:35; Jon 1:18; Jon 10:15 29 Jel 6:16 ");
INSERT INTO yby_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Holi onawa makomauya Jisesikaho le omutiyoko wewenalalekiya kile mija makouya wune. Nowudanaki lemo Jisesida unala ipalale yuhamasiya nodekumu helekoko kile maya ulutoko ulawa maya heketoko nomo wune. ");
INSERT INTO yby_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sa-nouniyoko, Palasisi wewena malokasiya mudaikiki lahelamibo data kiki sa-liki Jisesidama li me: Mudao. Unaka ipakalesi yaitaya lahelamibo nesa lolo niae. Lemo holiteuya yowanu nileboya samode nesa likae. ");
INSERT INTO yby_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Liki layoko, Jisesimamo sa-loko lo biye: Hapa yeikalaya Dewiti maya wewenalalekiya nodekumu helikiki saina mako lolo abo nesamidana gawa maya lepi-minaboya, monawamu data molokaiyoko nilahe. ");
INSERT INTO yby_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dewitima Omaimidana monoka numuku maya yowekaiyoko, Omaitoka jokila he mekaka we napamamo Omaimidana owisalo moli-minabo beleti maya mekaiyoko naibo maya ne. Sa-iyoko wewenalalekiya magoina nabo maya ne. Ito aya beletiya aha wewenasi namitae, Omaitoka jokila hi mikaka wesigo natae liki li huki-minabo maya ne. ");
INSERT INTO yby_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ito Moseseda gala mako lepiki elamahe. Holigu maya Omaitoka jokila hi mikaka wesiya monoka numuda napau maya yowanu liki miniki li moli-minabo ga maya auta ikaka niaboya, yamidana lihimalaya edimotoka minamiye. ");
INSERT INTO yby_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nemoya wehe loko lo libituyo, elilo: Luwawatipou minobo weya monoka numuda napamidana asetoko minoe. ");
INSERT INTO yby_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ito monoka bukuguya Omailimo libo ga sa-loko ne: Nemoda jokila hi nimitae loko elamoe. Duka hi bikakakumuya elekaka noe. Edimoya aya gamidana monawaya eli wehe li-minatidanako, lihimanipo minametibo wewenasidaya lihimanipomuya ga yowanu libitametine. ");
INSERT INTO yby_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ito okulumauti we uti nemoya holimidana ahola minonako, unane ipanele yuhasi holi yupeka lolo itabo nesaya neimone nesane ne. 1 Dut 23-25 3 1 Sam 21:1-6 0 Liv 24:9 5 Nam 28:9-10 7 Hos 6:6; Mat 9:13 ");
INSERT INTO yby_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Loko lokoko yaloti maya sinoko woko monoka numuda makomauya yowiye. ");
INSERT INTO yby_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yoweko mudaibo maya we makoya ade maloka uka jenebo we neyoko mudaikiki maloka wesiya Jisesida maya loka itiki sa-liki lae: Lemo holiteuya wewena dilipe haka lokaka nesa nehe minamiye. Liki laboya, Jisesida maya nena galo lo moloko lokoko obi oetatune liki aha ohumanau hiki lae. ");
INSERT INTO yby_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sakiya mulunau hikayoko, Jisesimamo dukauya muda wehe lonedanaki sa-loko liye: Edimokutiya wewena makolimoya sipisipi ja mako aleuya holi onawau lemenetiboya, holigu maya ne likiki ayau hulikadeko netibo nehe. ");
INSERT INTO yby_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","O'e, ika iki li hulatabo ne. Sa-itabo nenako, sipisipi ja maya aha nesa ne. Lemo wewena maya ula nesa minune. Sa-onenako, holigu maya wewena dilipe lalo okaka nesa ne. ");
INSERT INTO yby_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Loko lokoko aya wemidana maya adeka yaitaya peto loko liyoko, adela maya petiyoko maloka adelamidana dowa liye. ");
INSERT INTO yby_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sakoya dowa lokaiyoko, Palasisi wewenamasiya sa-ibo nesa maya mudae. Sakiya mudaikiki limiki Jisesida maya nena nena okoma kohatune liki lowa je. 11 Luk 14:5 ");
INSERT INTO yby_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sa-ikayoko, Jisesimamo aya ga maya elekoko aya numuda maya hulikoko eba makomaloka wiye. Sakoya nowiyoko muki wewenasiya emeke moliki wae. Sa-ikayoko saina delaibo wewena mukiya dilipe haka lokaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","emo monawala maya wetome iki lamitae loko lo hukobetaiye. ");
INSERT INTO yby_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sa-loko lobetokaiyoko, Omaimidana epaloti ga lokaka we Aesayakaho hapa yeikala luhuwa sa-loko jibo maya niseko pasiye: ");
INSERT INTO yby_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Omailimoya sa-loko noliye: Elekele oluhoneda ilime eto oboya mudalo. Emokumu numu helekaiyoko nukane nomoe. Ito nemo weune oluhomidana emotoka huloetokoyoko ilime lalo okadeko hetoka wewena ito muki numuto namato wewenasida lihimanipomu ona molobetatibo ga maya lo soto moloko lo bitibo ne. ");
INSERT INTO yby_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Emoya lowa moila heko auha lamoko, anuloya ga napauti lamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Uvaminanipo minamibo limiki minabo wewenasidaya dilipe lahelamibo lolo o suwametibo ne. Limiki minabo wewenaya jo uluma lasolamidana oko neboyako hitihe, ma hamekolaiye. Sa-okokoya yowanuwaya abuha moloko le loko woko nedeko, yalimoya muki nesasida asebetoko netiye. ");
INSERT INTO yby_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sa-ideko hetoka wewenasi ito muki numuto namato wewenasiya emokumuya ubolo minakilae, loko liye. 18 Aes 42:1-4 ");
INSERT INTO yby_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ya yupekaya we makoya oloha makolimo uka le opa oko omuda he likoko epa he lagoli okaiyoko nebo we ilimi-liki Jisesima nebotoka wae. Sakiya ilimi-liki wayoko, Jisesimamo omudala maya le pana ketoko epala maya le ka oetoko atala maya le golotiye. ");
INSERT INTO yby_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sa-okaiyoko gahena maya liyoko mudaikiki muki wewenamasiya agae, Dewitida ouvamela nisitiye liki labo we maya yaya netiye liki lae. ");
INSERT INTO yby_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Liki layoko, Palasisi wewenasiya maya ga maya elikiki sa-liki lae: Pelejepuloya olohasida uliki wenipo lolo okoko ilime wati okaiyoko olohasidaya kohaidoko wewenasida dukauti doli hekaka noiye, liki lae. ");
INSERT INTO yby_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Liki nilayoko, Jisesimamo dukauka mudakoko sa-loko lo biye: Mika makomaloti wewenasiya luwaku potikiki mini maloka maloka iki lowa hitaboya elewole iki minamideko aya mikanipoloya ametekolaiye. Ito makoko numukutiya siniki emo kohadeko emo kohadeko itaboya hutili iki eba makomaloka witabo ne. ");
INSERT INTO yby_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ito Olohalimoya eimola oluholalesida kohaidoko doli henetiboya eimola oholauya wavu-liki hi pou liki elewole iki minamitabo ne. ");
INSERT INTO yby_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Edimoya nemokumuya Pelejebuloda elewoleyalaloti olohasidaya kohaidoko doli hekaka noiye liki likaka niae. Sa-likayo, edimo oluhotipolesida ekahikaho dilipe wati okaiyoko olohasida kohaidiki doli hikaka niae. Olohamidana elewoleyalaloti kohaidiki doli himikaka nianako, edimoya suwa liki muluneu hiki nilabomidana monawalaya aha li soto molatabo ne. ");
INSERT INTO yby_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sa-oneboya, nemoya Omaimidana weuna oluholimoya nilime wati iyoko olohasidaya kohaidoko doli hekaka nonako, Omailimo uliki wetipo lolo onebomidana elewoleya sakoya dowisaloya alili okaiyoko, yamidana monawa maya alo soto pekaiye. ");
INSERT INTO yby_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Loko lokaiyoko, Olohamidana elewoleyala maya le amaekuka molaibomidana monawamuya akuya amida meko sa-loko lo biye: Wewena makolimoya adoha we makomidana numuku yoweko uvaminalaya enemane oko hipo oko litibo nehe. Sakoya minamiye. Omutoko aya wemidana ilo adelo nala jekoko alikaya yoweko litibo ne. Sakoya yoweko uvaminala hipo ekolaiye loko liboya olohamidana adelo nala jekoko weuna oluhosidaya kohaidoko doli hekaka nowe loko liye. ");
INSERT INTO yby_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Loko lokadanaki ga mako sa-loko liye: Wewena makoya nemo we minamitaboya ulanelo we minakilae. Wewena makolimoya nemo nilimeko maloka wewenasida nemotoka dilipe nupa ametiboya, dilipe hutili okaka noibo ilekaiye. ");
INSERT INTO yby_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yamuya lo libituyo, elilo: Muki lahelamibo nesahena ito muki lahelamibo gahenaya wewenasida dupaloka leko letudawoya Omailimo aya nesamidana lihimala hulokaka anuwaya neboya, we makolimo Omai weuna oluhomidana upaloka leko lahelametibo ga maya letiboya Omailimoya yamidana lihimaya le huloetamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Okulumauti we uti nemokumu liwi letiwi itaboya Omailimo aya lihimaya aha le hulokaka nesa neboya, Omaimidana weuna oluholamuya liwi letiwi itataboya, Omailimo yamidana lihimala le hulametibo ne, ma mikauka netibo ito okulumauka netiboya suwamekolaiye. 24 Mat 9:34; Mat 10:25 30 Mak 9:40 32 Luk 12:10 ");
INSERT INTO yby_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Edimoya ya ihilawa lalo mako mudaikikima ya yuha laloutiya ne, liki likaka niae. Ito ya ihilawa lahelamibo mako mudaikikima ya yuha lahelamibokuti ne, liki likaka niae. Sakoya ya ihilawalimoya ya lalo nehe ito lahelamibo nehe lo soto molokaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Edimoya ja ulamidana oluholakidana minae. Monawatipoya lahelamiboki minanako, nena iki ga laloe liki litabo ne. Lukauya ayamidana nesalimo waitonebokuti aha lepalotiya lokaka noune. ");
INSERT INTO yby_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wewena lalosida dukauya lalo nesago netibo nenako, dukautiya lalo nesago yowitibo ne. Ito lahelamabo wewenasida dukauya lahelamibo nesago netibo nenako, dukautiya lahelamibo nesago yowitibo ne. ");
INSERT INTO yby_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Yamuya ga mako lo libituyo, elilo: Lihima likaka onawaloya muki wewenasiya aito-aitomidana aha gaya labokumuya obi yowanuya likilae. ");
INSERT INTO yby_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aya noladawomoya oko moloko adawomidana monawa maya lo soto molokadeko, lalo minadeko maya, lihimaka minametibo minakolane, ito lahelamibo minadeko maya lihimaka netibo minakolane. 33 Mat 7:20 34 Mat 3:7; Mat 23:33; Luk 3:7; Mat 15:18 ");
INSERT INTO yby_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Loko lo bekaiyoko, monoka monawa api-napi ibikaka wehena ito Palasisi wewena malokasiya sa-liki li me: Tisao, emoya oliwaki nesa elewoleya mako le soto moladeko mudatune. ");
INSERT INTO yby_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Liki layoko, Jisesimamo oloti onawalo minabo wewenaya monoka eli hulikaka wewena minae loko lo biye. Edimoya oliwaki nesa elewoleya le soto moloyoko mudatune liki nilaboya, edimoya aitomidana oliwaki nesa elewoleya mako le soto moloyoko mudamitae. Hapaya oliwaki ane mako Omaimidana epaloti ga lokaka we Jonato soto pibo anekidanagoya soto pideko mudatae. ");
INSERT INTO yby_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona maya loweki makoki onawaya lahawa napamidana ohumanau lemeko minoko aku hetoka nisibo maya ne. Asako okulumauti we uti nemoya loweki makoki yupeka mika ulauka minokoko aku sinatubo ne. ");
INSERT INTO yby_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jonakahoya Ninive wewenasida maya monoka lo nobiyoko duka li wili jebo ne. Sa-ibo neboya, nemoya Jonakidana minamoe. Jonadaya asetoko minoboya, edimoya nemo ane maya eli hulikiki duka li wili jamae. Yamuya Omailimo ona mololibetatibo onawaloya Ninive wewenasiya siniki miniki oloti onawalo minabo wewenasida lihimanipomuya obi ibitatabo ne. Sakiya obi ibitadeko lihima litabotogo ne. ");
INSERT INTO yby_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ito Siba mikauka uliki menalimo Omaimo ona mololibetatibo onawaloya sinokoko oloti onawalo minabo wewenasida lihimanipomuya obi obetadeko lihima litabo ne. Aya menalimoya Solomonima madonau golotiyoko muki nesa monawa elibomidana monawa maya elekolo mika makomalokati hana-pana anu nisiye. Ito nemo maya minobo weya Solomonida yatokaya asetoko minoboya, edimosiya ane maya elamae. 38 Mat 16:1; Luk 11:16 39 Mat 16:4 40 Jon 1:17 41 Jon 3:5 42 1 Kin 10:1-10; 2 Klo 9:1-12 ");
INSERT INTO yby_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Oloha makolimoya wewena makomidana ukauti yowekoko aso jeleko netibo ebamuya ohu jeko wewena minamitabo ebatoka woko ohu jeko monitiboya wewena mudaidamoko ohu je-loko nowokoma, ");
INSERT INTO yby_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nemo numudane maya hulikoko nisoboma nenako, omutoko minobo numutoka maya aku woko minatuwe loko woko mudatiboya, aya numukuya ohu liki mumusopa usiki li huli-minadeko mudatiboya, numuda aholaya minamideko mudakoko, ");
INSERT INTO yby_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","aku hulikoko woko iwelale yuha 7-palakiya dupaloti sisipa nuwama wibosidakiya dilipe-loko nisideko limiki yauya minakilae. Sa-ideko, aya we maya omutoko suwa nesa leko lahelamibo neboya, alikaya lina lahelametibo nesa leko minakolaiye. Sa-etibo nenako, aya nesa maya edimotoya soto pitibo nesamuya noloyo, ehetipoe. ");
INSERT INTO yby_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisesimamo ga lo beko neyoko, dolale unamotalale yuhama gahena lo metune liki nisiki emesaloka maya hetoka ewa i-minae. ");
INSERT INTO yby_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sakiya ewa iki minayoko, we makolimo mudakoko yoweko Jisesidama ele-minape, dokale unakale maya gahena lo emetune liki nisiki hetoka ewa igitiminae, ");
INSERT INTO yby_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","loko liyoko, Jisesimamo donele unamotanelemu nolape. ");
INSERT INTO yby_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Loko lokadanaki, unala ipalale minabotoka maya ade itupeko sa-loko liye: Mudalo. Donele oluho unamotanelekidana wewena maya minae. ");
INSERT INTO yby_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Okulumau ahoneda galalo emesalo molikaka niabo wewenaya donele oluho unamotanele minae, loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jisesima aya onawalo ga maya lo bekoko aya numukuti maya adu ilikaloka maya lemeko ga maya api-napi obetakolo noidanaki, ");
INSERT INTO yby_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","muki wewena maya nisiki akelo maya dupalo dupalo iki minayoko mudaidokoko noku lapeu maya yoweko nedanaki, ");
INSERT INTO yby_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","koha moloko ga aito-aitomidana lo biye. Lo nobidanaki, makoya sa-loko lo biye; Eli-minahe. Yuha nesa tili okaka welimoya yuha nesa maya tili ekolo wiye. ");
INSERT INTO yby_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sakoya mijakuka maya woko tili omo wiboya malokaya lemo anuloya jekaiyoko namasiya nisiki niki suwae. ");
INSERT INTO yby_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Malokaya ehada mupilalo mika lasolasi neboto lemo jiboya mikaya wavu-leko minaminako, wileko enemane oko yowiha, ");
INSERT INTO yby_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","hoya lidanaki aya nesa maya luhawa maya hana wamidanaki opateko alala miye. ");
INSERT INTO yby_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ito yuha nesa malokaya lemo lilihau jeko wileko yowiha, lilihalimoya mi jemikaiyoko mudako yowamiye. ");
INSERT INTO yby_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ito malokaya mika lalou lemeko nedanaki, wileko yoweko ihilawa lalo jiye. Yawa makokolotiya ihilawa 100 jiye. Yawa makomalotiya ihilawa 60 jiye. Yawa makomalotiya ihilawa 30 jiye. ");
INSERT INTO yby_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Edimoya dataki minune likima monawaya eli wehe lilo. 8 Luk 5:1-3 ");
INSERT INTO yby_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sa-loko lo lemekaiyoko, lemo unala ipalale yuhamasiya amaitoka woko loka otoko emoya koha moloko gaya nenahamuya lo nolemene. ");
INSERT INTO yby_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Loko luniyoko Jisesimamo sa-loko lo limiye: Okuluma ebaku yowitabomidana sunauka gala maya edimo elitae loko lo neboya, maloka wewenasiya elamitae loko liye. ");
INSERT INTO yby_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Monokaya wati iki ujapa iki li-minatabo wewenasiya ayaloya makoki le omeko bideko mida numuda lalo soto pe bekolaiye. Ito monoka wati iki elewole iki ujapa iki liminamitabo wewenasiya ahago le-minune liki litaboya aku dadeuti hipo oko lekadeko aha minakilae. ");
INSERT INTO yby_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sa-ikiki mudatune liki ohu ji-liki witaboya mudai wehe lamae. Ito eletune likima owaha eli wehe lamae. Yamuya koha moloko gaya lo noboe. ");
INSERT INTO yby_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sa-ikayoko, Aesayakaho iha hukoko libo ga maya edimotoya niseko pasiye. Omailimo libo ga maya sa-loko luhuwa jiye: Datadunu elikaka gaya aha elitaha, eli wehe lamitabo nesa lekaiye. Ito domudadunu mudaikaka nesaya aha mudataha, ma mudai wehe lamikilae. ");
INSERT INTO yby_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Edimo maya minabo wewena mukiya dukaya he lilokadanaki, domudaya he likonebogoya minae. Ito data he lilonebogo minae. Yamuya saina-painahena mudaikakawaya nimudae. Ito datadunu elikakawaya niele. Dukadunuya eli wehe liki elamae. Sa-ikikiya duka li wili jamanako, nemoya nena-nenakoma dilipe lalo etubone. ");
INSERT INTO yby_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ito Omailimoya maku libekaiyoko edimo mukisiya eli wehe liki data lalo elikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sa-ikaka nianako, ga ulawa lo libituyo, eli-minalo: Hapa yeikalaya Omaimidana epaloti ga likaka weki olisanipo minamibo wewena mukiya oliwaki nesa elewoleya lolo okaka onobo nesaya edimosi mudaikaka niabolawaya mudatune liki laboya, mudamabo maya ne. Ito edimoya nepauti ga maya elikaka niabo ga maya eletune liki likaka aboya, elamabo maya ne. 12 Mat 25:29; Mak 4:25; Luk 8:18; Luk 19:26 14 Aes 6:9-10 16 Luk 10:23-24 ");
INSERT INTO yby_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yuha nesamidana ihilawa tili okakamidana monawa lo libituyo, eli-minalo. ");
INSERT INTO yby_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Okuluma ebaku yowitabomidana gala eli wehe lamabo wewenasiya monokaya dukau molikayoko neboya, lahelamibo nesamidana ahola Olohalimoya saina ulawa maya leko oli hekadekoya, yuha nesa ihilawaya lemo anulo lemo jibomidana iki minakilae. ");
INSERT INTO yby_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ito ehada mupilalo lemo jibomidana iki minatabo wewenaya monokaya elideko dumu helitibo neboya, ");
INSERT INTO yby_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","dukauya luhawa le ilitamoko onawa minawasi minadeko, monoka ulawanipou nebokumuye liki kohaidi-liki yowiki ula molibitatabo onawaloya enemane iki hulatabo ne. ");
INSERT INTO yby_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ito lilihau limibomidana iki minatabo wewenaya monokaya elikakamidana elitaha, ma mikau eda delokaka noibo nesa ito ehadamu dumu helekaka noibo nesalimoya monokamidana jeko hitomikaiyoko, edimotoka ihilawa maya soto pametibo ne. ");
INSERT INTO yby_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ito mika lalou limibomidana iki minatabolikaya monokaya elikiki eli wehe liki liminabolimoya edimotoka ihilawa jekaka noiye. Malokaya napa apulu oko jekaka noiye. Malokaya muki jekaka noiye. Ito malokaya wavu-leko jekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sa-loko lokoko ga mako koha moloko sa-loko lo limiye: Okulumau yowitabo onawamidana monawaya sakoya ne: Wewena makolimoya mijalauya oina lekai yuhawa tili ibotoya le moloko letuyo. ");
INSERT INTO yby_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Oina lekai yuha maya tili okoko wokaiyoko, yu makoya lubuka muki wewena domuda udiki esa iminayoko, ulalalo welimoya liliha yuhawa maya leko niseko ayau maya tili okoko wiye. ");
INSERT INTO yby_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sa-okaiyoko, lekai maya wileko yoweko ihilawa maya nojiyoko, liliha maya ayauti maya wileko yowiye. ");
INSERT INTO yby_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sa-okaiyoko unala ipalale yuhamasiya nisiki sa-liki li me: Uliki we yamalae, emo mijakau maya saina lalo tili o-minadawo maya neboya, liliha maya ayauti muki wileko yowekaiboyae. ");
INSERT INTO yby_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Liki layoko, ulanelo we makolimo tili onetiye loko liyoko, unala ipalale yuhamasiya woko aya liliha maya asutetupe liki labo maya, ");
INSERT INTO yby_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","emomamo o'e, lilihaya asutitaboya, lekaikiya asutikatae. ");
INSERT INTO yby_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lekaiki lilihakiya aha minaideko, alikaya lekai maya yuha lokadeko yuha li molatabo wesida maya wiki liliha maya asutiki wasa jikadeko leko woko joku jekoko lekai yuhawa maya usiki wasa jikadeko li yuha nesa molokaka numuku maya molatae, loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisesikaho koha moloko ga mako sa-loko lo limiye: Okuluma ebaku wiki hilitabo wewenaya masteti ihilawamidana iki minae. ");
INSERT INTO yby_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Aya nesaya muki yuha nesasida asebetoko lasomosolasi neboya, we makolimo aya nesaya mikauka tili okaiyoko ohuhenasidaya muki asebetoko yakidana yowiye. Sa-okaiyoko, namasiya mudaikiki akawalo maya numudanipo vikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Muki wewena wavu-liki li esa iki minayoko, Jisesimamo koha moloko ga mako sa-loko lo biye: Okuluma ebaku wiki hilikaka wewenasida monawanipoya beleti lulu jekaka nesamidana oko ne. Mena makolimo aya nesa maya palauwakiya le opa napa iyoko beletima lulu jeko napa okaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sakoya muki wewena li esa iki minayoko, Jisesikaho ga lo biboya koha moloko gautigo lo biye. Ga mako lo bekolo noidanaki, aya koha moloko gautigo lo biye. ");
INSERT INTO yby_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sa-iboya Omaimidana epaloti ga lokaka welimo ga mako sa-loko luhuwa jibo maya woko pasiye: Koha moloko gaya nepaloti lo nobodanaki, mika maya soto pamiyoko sunauka mino-loko woko nebo ga maya olotiya lo soto molatuwe, loko liye. 35 Sam 78:2 ");
INSERT INTO yby_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisesimamo muki wewenasida maya hulobikoko numukuka yowekaiyoko, unala ipalale yuhamasi lemo kile mijakuka liliha yowibomidana monawa maya lideko eletune lokoko yoweko loka ituniyoko, ");
INSERT INTO yby_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","sa-loko lo limiye: Ihilawa lalo tili ibo wemu loboya okulumauti we uti nemo minoe. ");
INSERT INTO yby_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mijamu loboya muki mikaya ne. Ihila nesa lalomu loboya Omaimo uliki wenipo lolo etibo wewenamuya loe. Ito lilihamu loboya oloha lahelamibomidana unalale ipalae yuhaya minae. ");
INSERT INTO yby_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ulalalo weya nisekoko lahelamibo nesa tili ibo wemu loko loboya, Olohamidanamuya loe. Lekai yuhawa hukoko le molokaka onawalo wemu loboya, ma mikau muki nesa suwetibo onawaloya yowanulo wesiya yowanu litabomuya loe. ");
INSERT INTO yby_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Liliha asutiki joku jebomidana asako ma mikau nesa suwetibo onawaloya, ");
INSERT INTO yby_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","nemo okulumauti we napakaho okananipoki wesida leko doli hekoyoko, nemo uliki wetipo lolo onobo wewenasida dilipi opa ikaka niabo wewena ito lahelamibo nesa lolo ibitikaka niabo wewenasida maya dilipi nupa ikiki, ");
INSERT INTO yby_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","jo napauya doli hi hulikadeko limiki minakilae. Yau maya limiki miniki miluma-aluma eliki depa tala-mitala iki minakilae. ");
INSERT INTO yby_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ito wehe liki minatabolawa maya ahonipoda ebalau maya ho yakidana dupalokati lameda lideko minakilae. Sa-ikilayo, edimo data golotonetibo wewenalikaya ga maya eli wehe liki elilo. ");
INSERT INTO yby_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Okulumamidana ebalau yowekaka nesaya meinawa yoweko nebo nesakidana ne. Uvamina lalo mako ya yuhau netiboya moli eto ikadeko, halukoko nedeko maya, we makolimo woko mudakoko aku le wili jeko niseko aya nesa maya le suna okokoya elowa jeko ehada leko molatibototiya ona moloko meinalo be suwokoko aya mika maya meina hekoko aya uvamina lalo maya lekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Okulumamidana ebalau yowikakamidana anulaya sakoya ne: We makolimoya ela okanikidana nesa meinawa yoweko nebo nesamuya ohu je-loko widanaki, ");
INSERT INTO yby_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","okani lalo mako ohatama meinawa yoweko netibo nesa le soto molokokoma emo ehada uvamina leko molonetibo maya ona moloko meinalo be suwokoko aya nesa maya meina heko lekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Okulumamidana anulaya lawaha hikaka owokidana ne. Wewenasiya lawaha hikaka owoya huli ela noku ikayoko, lemeko lawaha aito-aitomidana lekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Sa-ikiki minayoko, aya owo maya waitokaiyokoma ika iki li huli akeloka molikiki nodemidana maya li lapeu molikaka niae. Ito mosehamidana maya li eto iki li hulikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sa-ikaka niabo nesa leko mikamidana onawala suwetibotoya okananipoki wesiya asaiki sa-ikilae. Okananipoki wesiya muki numuto namato wewenasida luwawanipoutiya lahelamabo wewenasida maya dilipi lena ikilae. ");
INSERT INTO yby_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Sa-ikikiya dilipi huli joku molakilae. Sa-ikadeko, yauka maya miniki miluma-aluma eliki depa tala-mitala iki minatabo ne. ");
INSERT INTO yby_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisesikaho sa-loko lo lemeko suwokoko sa-loko aku loka oletaiye: Edimoya muki gaya eli suwi-minahe. Loko loka oletokaiyoko, alo ele-minune. ");
INSERT INTO yby_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Loko luniyoko, sa-loko liye: We makolimoya uvaminala asehawauti ito ohatamauti ona moloko wewenala yuhasida bekaka noibomidana, maloka monoka monawa api-napi ibikaka niabo wewenaya okuluma ebamidana oluhola wehe liki lolo niabo wewenasiya asehawa monokamidana ukauti ito ohatama monokamidana ukauti liki litabo ne. ");
INSERT INTO yby_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisesikaho koha moloko ga aito-aitomidana sa-loko lo lemeko lo lemeko suwokoko numudala ebala hulikoko, ");
INSERT INTO yby_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","eimola oto numudalaloka woko hetiye. Woko hetokoko monoka numuku yoweko monoka lo biye. Monoka ga maya wetome oko lo bekaiyoko elikiki, agae likiki sa-liki lae: Maya welimoya ele wehe lokaka nesaya nakahaukati lekaihelae, ito oliwaki elewole nesa lolo okaka noibo mayae. ");
INSERT INTO yby_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Lemoya monawala ele-minune, emoya kapedamidana ipala maya ne. Ito dola uliwa Mele maya neyo. Ito unamotala duliya Jemisile ito Josepule Saimonile ito Judaleya unamotala maya minanako, ");
INSERT INTO yby_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","yatokaya lemokidana we maya neboya, ito emo nalalekiya malo maya miniki liki ikaka niabo nenako, emoya elewole anehena ito aito-aitomidana nesahenaya nena-nenakoma lekaiye. ");
INSERT INTO yby_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sa-liki likiki emokumu elebo maya eda delokaiyoko, liwi letiwi iki litikayoko, Jisesimamo elekoko sa-loko lo biye: Omaimidana epaloti ga lokaka we lemo uliteya muki numuto namato pou loko wetiboya, lemote oto ebatoka ito numudateukakiya uliteya minametibo ne, loko liye. ");
INSERT INTO yby_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ito aya ebato wewenasiya eli elewole amabo nenako, Jisesimamo oliwaki nesa elewoleya muki yalokaya le soto pamiye. 57 Jon 4:44 ");
INSERT INTO yby_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ya yupekaya uliki we Helotimamo Jisesida gala maya likayoko eliye. ");
INSERT INTO yby_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Elekoko emo elekele oluholamidana maya sa-loko lo miye: Joni noku udobetokaka we maya helibokuti sinokoko oliwaki elewole anehena aito-aitomidana le soto nomolaiye, loko liye. ");
INSERT INTO yby_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Sa-loko libomidana monawaya sa-lokoya ne: Hapaya Heloti maya yatola Pilipida menala uliwaya Helodiyasida hipo oko liye. ");
INSERT INTO yby_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sa-okaiyoko, Jonimamo Helotida maya sa-loko lo me-loko wiye: Emoya yatokada menala hipo oko ledawoya wehe lamiye. Loko libomuya Helotimamo menaladamuya elekoko imi we mako doli hekaiyoko, wiki Jonida maya adelo liki nisiki nala numuku hulitae. ");
INSERT INTO yby_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Muki wewenasiya Jonidamuya Omaimidana epaloti ga lokaka weya ne liki likaka abo maya nenako, Helotimamo Jonidaya kohatuboya wewenasi kohanelikatae loko omodala wokaiyoko huloetaiye. ");
INSERT INTO yby_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sa-iboya Helotida etabo onawa maya nisekaiyoko nenako, ujapa wehena maya nisiki numudalauya li esa ae. Li esa iki minayoko, Helodiyasida oluwamamo muki wewenasida domudalo maya meleke liyoko, Heloti maya omuda helekaiyoko sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nemoya Omaimidana owisaloya lo hukoko noloe. Emoya sainamamu nelaiye loko letadawo nesa maya aha emekoloe. ");
INSERT INTO yby_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Loko lokaiyoko, dolamamo sa-loko libotoya emesalo moloko sa-loko liye: Noku udobetokaka we Jonida enola maya hukoko lapeuya moloko leko niseko nimideko mudakoko aloya helekaiye loko letuwe loko liye. ");
INSERT INTO yby_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Loko lokaiyoko, uliki wemamo elibo maya eda elaiboya, Omaimidana omudalo galo lo hukoko lokobo maya nenako, lokoko ito muki matoka nisiki minabo wewenasida dowisalokiya lo hukokonako, lokoko opaya imi we makomidanaya woko enola maya hukoko lapeu moloko lekatiye loko loetokaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","woko nala numuku maya enola maya hukokoko, ");
INSERT INTO yby_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","lapeu molokoko aya olumidana maya mekaiyoko, leko woko dolada maya lemo miye. ");
INSERT INTO yby_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sakoya lemo mekaiyoko, Jonida unala ipalale yuhamasiya aya ga maya elikiki wiki onowa maya liki wiki ale jitae. Sakiya liki wiki ale jikiki awa maya Jisesida wetome iki li me. 0 Liv 18:16; Liv 20-21 ");
INSERT INTO yby_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Li mikayoko, elekoko enemane iki unala ipalale yuha lemokiya noku lapeu maya yowekoko yola helegaloka maya wune. Sa-okuniyoko, muki wewenasiya elikiki numuda ebanipo maya huliki emeke moliki mikauya wae. ");
INSERT INTO yby_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sa-ikayoko, Jisesimamo noku lapeuti maya eko lemeko mudaibo maya wavu-liki li esa iki minayoko mudaidokoko eke lobetaidanaki saina delaibo wewenasida maya dilipe haka liye. ");
INSERT INTO yby_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sa-noiyoko, ho maya lemekaiyoko, unala ipalale yuhamasi lemo niseko Jisesitoka sa-loko lo mune: Maya ame ebatoka maya nenako, ito onawa maya aloya suwokaiyo, aya wewena yaitaya numuda emesaloka wiki nodenesanipo ohu jiki litaboki neyo, doli ho. ");
INSERT INTO yby_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Loko lokuniyoko, Jisesimamo sa-loko lo biye: Nenaha idekoma witae. Edimotipoya nodenesa biki nalowo. ");
INSERT INTO yby_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Loko liyoko, beleti lade maloka suwokoki ito lawaha lowe mayakigo molo-minudawolae. ");
INSERT INTO yby_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Loko lokuniyoko Jisesimamo aya nesaya liki nemotoka nisilo, loko liye. ");
INSERT INTO yby_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Loko lokoko muki wewenasida maya yaitaya mikalo minalo loko lo bekadanaki, beleti lade maloka suwiyoko ito lawaha lowemaki lekoko okulumaloka omuda hulo moloko Omaimidana epoka lokadanaki beletimaki lahawa lowemakiya poseko lemekaiyoko, leko moneko muki wewenasida maya ona moloko bune. ");
INSERT INTO yby_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sakoya leko moneko buniyoko niki niki ohumanipo okaiyoko lumawa nebolawa maya li nupa iki manoda lape 12-pala owo jeko waitokaiyoko le molune. ");
INSERT INTO yby_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nodenesa nabo we 5000 minaboya menakipa oluhoya lepamune. ");
INSERT INTO yby_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sa-okaiyoko, Jisesimamo muki wewenasida maya doli nohidanaki, unala ipalale yuhasida lemodaya noku lapeu maya yowikiki omutiki wilo loko loli hiye. Sakoya loli hekaiyoko, nowuniyoko, ");
INSERT INTO yby_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","sakoya muki wewenasida maya doli he suwokoko Jisesima bola makomauya eimolago yoweko nedanaki Omailoka loko neyoko, ");
INSERT INTO yby_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","lubu maya jekoko udo wili jedawolawaya lolo okaiyoko, unala ipalale yuha lemo maya woko no luwaku maya nowuniyoko, ahuhu napalimoya niseko no maya alahuka jeko hulo noku lapeu maya moloko lilipe opa-napa ekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sakoya okululuwa nohokiyoko, Jisesi maya no mupilaloya anu moloko lemo minunibotoka alili noiyoko, ");
INSERT INTO yby_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","unala ipalale yuha lemo mudo-eludunaki oloha makoya nonisihe loko opa napa ga maya lune. ");
INSERT INTO yby_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Opa napa aya luniyoko, Jisesimamo enemane oko sa-loko liye: Domodatipo wamideyo, nemoma nonisoyo. Mulutipou hulu ideyo. ");
INSERT INTO yby_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Loko lokaiyoko, Pitamamo we napate yamalae, emoma minoko maya enemane oko no mupilaloya emo adawo nesa leko minadawotokaya wetuhao, loko liye. ");
INSERT INTO yby_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Loko liyoko, nisamane loko lokaiyoko, Pitamamo enemane oko noku lapeuti maya no mupilalo eko hekoko anu moloko wiye. ");
INSERT INTO yby_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sakoya eko heko nowiyoko, lasi napa maya nisibokumuya omodala wokaiyoko noku lemekolo noidanaki, we napane yamalae, nilimamane, napusa jowo loko lokaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisesimamo enemane oko adelo leko apusa nojidanaki, sa-loko lo miye: Emoya lasolasi elewole oko nemotoka ata kedawolikaya, nenahamuya ata lowe kedawo ne. ");
INSERT INTO yby_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Loko lokoko noku lapeu maya aku yowikaiyoko, lasi maya apa jiye. ");
INSERT INTO yby_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Apa jekaiyoko, noku lapeu minunibo wesiya Jisesida maya lipi meko sa-liki lae: Emoya Omaimidana ipala wehe loko minane, loko lune. ");
INSERT INTO yby_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sa-loko likoko yola helegalokaya Genesaleti ebatokaya woko hetune. ");
INSERT INTO yby_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sa-oko woko hetoko noku lapeuti maya lemekuniyoko, ayaloka minabo wewenasiya Jisesida maya mudai wehe likiki Jisesima aloya nisekaiye liki ayaloka alili minabo wewenasitoka maya wetome iki liki liki mone. Sayoko ayaloka minabo wewenasiya gala maya elikiki saina delaibo wewenasida maya dilipi-liki Jisesi nebotoka nisi nisi ae. Sakiya dilipi-liki nisedanaki, ");
INSERT INTO yby_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","sakiya li me: Saina delaibo wewenasiya aha upaloyahe ito aha upalo nesaloyahe dadeloti li elikiki haka litayo, liki likayoko asaiki lebo wewena maya haka li suwae. ");
INSERT INTO yby_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ya onawaloya Palasisi wewenahena ito monoka monawa api-napi ibikaka wehena malokakiya Jelusalemugati nisiki Jisesida maya sa-liki loka itae: ");
INSERT INTO yby_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Unaka ipakale yuhasiya latatele monawanipo maya li-minamiki nenaha iyoko hulikae. Nodenesa natune liki duki li huma jikaka nesa liki dadeya nokalawe amae. ");
INSERT INTO yby_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Liki likayoko, Jisesimamo sa-loko lo biye: Edimoya nenahamuya latatipolesida ganipo eli likili Omailimo lo hukobetaibo ga maya auta ikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Omailimo sa-loko lonebo maya ne: Dokako ahokakosida dulinipo le sino. Ito makoya wewena makolimo dolako aholakosida dupaloka lahelametibo ga lo molatibo maya alo kohakuniyoko helitiye loko lonebo ne. ");
INSERT INTO yby_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sa-oneboya, edimoya sa-liki likaka niae, wewena makolimo dolako aholakosida nasahili obetatuwe loko libo nesa maya alo Omaimidana he mekoe. ");
INSERT INTO yby_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Loko letibokumuya edimosiya aha nesa ne likiki dolako aholakosida nasahili obetatibo anuwa maya hiki li likaka niae. Sa-liki likiki Omaimidana gala maya li wasa jikiki edimotipo ahotipole dotipolesida ganipo maya li sawa jiki li-minikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Depa ulumatipo lowe nebolika, Omaimidana epaloti ga lokaka we Aesayakaho iha hukoko libo maya wehe loko edimokumuya lonebo maya ne. Omailimo libo ga maya sa-loko luhuwa jenebo maya ne: ");
INSERT INTO yby_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Maya wewenaya depadunugoya nuliya li sinikaka niaboya, dukaya nemotoka moli nemamiki hotokaya moli-minae. ");
INSERT INTO yby_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wewenasiya Omaimidana gala ne liki aha wewenasida ganipo maya li bikaka iki minadanaki suwa nesa liki lipi nimikaka niae. 0 Eks 20:12; Dut 5:16; Eks 21:17; Liv 20:9 4 Aes 29:13 ");
INSERT INTO yby_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisesikahoya sa-loko lo bekoko wewena muki ju liyoko emotoka nisikayoko sa-loko lo biye: Nemoya ga maya lo libekolobo maya eli wehe liki elilo. ");
INSERT INTO yby_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Niki mikili niayoko ohumatipou lemekaka noibo nesalimoya duka le huma jametibo ne. Depauti yowekaka noibo nesalimoya duka le opa etibo ne. ");
INSERT INTO yby_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Loko lo bekaiyoko, unala ipalale yuha lemoya amaitoka woko sa-loko lo mune: Emoya Palasisi wewenasida ga lobedawo maya eli lahelamibo ae. Sakiya eli lahelamabolawa maya alo ele-minape. ");
INSERT INTO yby_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Liki likayoko, Jisesimamo Palasisi wewenasida monawanipomuya koha moloko ga mako sa-loko lo biye: Yaya okulumau ahonekaho yuha amiyoko aha eimola ata eliboto wileko yowiboya alika asutoko luhawakiya le hulakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sakoko edimoda hulobetokadeko aha minatae. Palasisi wewenaya domuda likaibo wewenakidana minae. Omuda likaibo we makolimo omuda likaibo we makomidana anu ilipitibo nehe. Domuda likaibo we lowesiya emo adelo lideko maya emo adelo lideko ikiki anu moliki wisaiboya lowe loweya aleuya limikilaiye. ");
INSERT INTO yby_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Loko lokaiyoko, Pitamamo aya koha moloko gamidana monawa lo soto moloko lideko eletune loko liye. ");
INSERT INTO yby_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Loko lokaiyoko, Jisesimamo sa-loko lo biye: I'i, edimoya aya wewena suda liki ga monawa maya eli wehe lamahe. ");
INSERT INTO yby_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Depadunuya nodenesa niki mikili ikaka niayoko ohumatipou lemekaka noiboya, eimola anulauya lemekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ito depauti yowekaka noibo nesaya dukauti yowekoko dilipe opa okaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wewena dukauti yowekaka noibo nesaya sakoya ne: Lahelamibo nesa lolo etudawo, lata kekaka nesaya, ito wewena kohaido heletudawo nesaya, we olisa mena olisa okaka nesaya, anulo monikaka nesa, ito ukele okaka nesa, suwa lokaka nesa, ito wewena demega lokaka nesaya. ");
INSERT INTO yby_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yatokamidana nesalimoya dilipe opa okaka noiye. Lade nokalawe amoko nodenesa natudawolimo luka le opa ametibo ne. 14 Luk 6:39 18 Mat 12:34 ");
INSERT INTO yby_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Loko lokoko, Jisesikima numuda eba maya hulokoko Taiya numutoka ito Sidoni numuda alililokaya woko minuniyoko, ");
INSERT INTO yby_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kenani numutokati hetoka mena mako emotoka nonisidanaki, amowa jeko sa-loko ju loko lo miye: We napane emoya Dewitida ouvamela lahelamibo nesauti lilimitiye loko lo mololetaibo we yamalae, milumane elenetamane. Oloha lahelamibo makomalimo oluneda ukauya yoweko minokoko ilime opa napa okaka noihao. ");
INSERT INTO yby_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Loko libo maya Jisesimamo ele aha nesa lolo oikoko nowiyoko, unala ipalale yuha lemo sa-loko lo mune: Maya menalimoya newe newe loko lomo nonisiboya wehe lamiye. Emoya oli he moladeko wideyowo. ");
INSERT INTO yby_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Loko lokuniyoko, Jisesimamo sa-loko lo limiye: Nemoya Isilaelo wewena wiki tolowa i-minabokuti maya dilipe-loko nisitane loko noli hekaiyoko lemobo maya ne. ");
INSERT INTO yby_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Loko lokaiyoko, aya menamamo enemane oko iguka i bola he nomidanaki sa-loko liye: We napane yamalae, nilime wati ogae. ");
INSERT INTO yby_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Loko lokaiyoko, Jisesimamo Isilaelo wewenasiya Omaimidana makulaya omutiki litabokumuya elekoko koha moloko ga mako sa-loko lo miye: Oluhonipolesida nodenesanipoya hipo ikiki ulasida bitabo nesaya wehe lamiye. ");
INSERT INTO yby_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Loko lokaiyoko hetoka menamamoya Isilaelo wewenasigo nehekala, eimolakiya Omaimidana makula mako litibokumuya ele-minoko sa-loko liye: We napane yamalae, yaya wehe loko lokadawoya, nemoya ma letuyo. Nodenesa nokaka namabetalotiya ula oholasiya nodenesa ninayoko lanawa lemo jibolawaya ulasiya usiki nikaka niaboyae. ");
INSERT INTO yby_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Loko lokaiyoko, Jisesimamo sa-loko liye: Emoya uka laloki minokoko lokaninako, yamuya ladawo nesa maya soto pekolaiye. Loko lokaiyoko, aya onawalo maya wehe loko oluwa maya haka liye. ");
INSERT INTO yby_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sa-lokoko Jisesimamo akuya numuda eba maya hulikoko wili jeko Galeli no ilikaloka maya woko moneko bola makomauya yoweko ne. ");
INSERT INTO yby_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sakoya yoweko neyoko, wavu-liki wewena aito-aitomidana wewena li esa ae. Sakiya li esa abo wewenahenaya dilo libohena ito domudalo libohena, ito ebilihena ito gahena lamabo neihena ito saina delaibohena maya muki dilipi-liki nisiki limi Jisesida iloka maya molikayoko, dilipe haka lo suwiye. ");
INSERT INTO yby_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Sa-ikayoko, gahena lamabohena maya depa le lalo okaiyoko gahena maya lae. Ito di dade ihibo wewenahena maya dilipe lalo okaiyoko dowa liki minae. Ito dilo libo wewenahena maya sini wehe liki minae. Ito domudalo libo wewenahena maya domuda le pana kekaiyoko, domuda mudae. Sakiya minayoko, muki wewenasiya mudaikiki agae liki, Isilaelo wewenasida Omainipomidana epoka lae. ");
INSERT INTO yby_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sa-ikayoko, Jisesimamo unala ipalale yuha lemoda maya ju lo limiyoko emotoka nisekaiyoko sa-loko lo limiye: Muki wewena maya nodenesa namiki onawa loweki makoki yupeka nemotoka miniki monebokumuya elekoe. Sa-ikanako, nodenesa namabotoya oloti doli hekoyoko numudanipoloka witaboya anuloka niwideko domuda nana vokadeko limiki udatahe loko yamuya madoneuka opa napa okaiye. ");
INSERT INTO yby_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Loko lokaiyoko, lemote sa-loko lo mune: Aha ameto maya minudanako, nodenesaya nakahauti le soto moloko le beko natune. ");
INSERT INTO yby_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Loko lokuniyoko, Jisesimamo loka oletoko edimotokaya beleti nenakima ne, loko lokaiyoko, lemoya beleti 7-palaki ito lahawa amanamasiki le-minune. ");
INSERT INTO yby_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Loko lokuniyoko, aya beletimaki lawahamakiya liki nisilo loko lokaiyoko, liki nisiki limi mikuniyoko, muki wewenasida maya mikalo minalo lokoko, ");
INSERT INTO yby_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Omaimidana epoka lokadanaki aya beleti maya poseko unala ipalale yuha lemoda maya limiyoko leko moneko ona moloko beyuniyoko nae. ");
INSERT INTO yby_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sakiya niki niki dohumanipo okaiyoko nodenesa lumawa nebolawa maya manoda lape 7-pala owo jiki waitoko le molune. ");
INSERT INTO yby_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nodenesa nabo weya 4 tauseni yamidana wewenaya miniki naboya, menakipa oluhosidaya lepamune. ");
INSERT INTO yby_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sa-okaiyoko, Jisesimamo aya wewenasida maya doli hekaiyoko niwayoko, lemoki noku lapeu maya yowekoko yola helegaloka Magadani mikaloka maya wune. ");
INSERT INTO yby_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Palasisi wewenaki ito Sediyusi wewena malokakiya Jisesida maya ohumanau hetune likadanaki nisiki sa-liki lae: Emoya okulumauti elewole ane mako le soto molokadeko Omailoti lemedawo we minape mudatune. ");
INSERT INTO yby_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Liki layoko, Jisesimamo elekoko, edimoya lubu jekolo noiyoko ho lae lae libotoya mudaikiki aijo ho letibo ne, liki likaka niae loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ito hoya lokaiyoko mudaikikiya okulumaloka hito-pito noiyoko oya jitibo ne, liki likaka niae. Edimoya okulumaloya mudaikiki onawamuya ona molikaka niaboya, oloti onawalo oko moloko okaka nobomidana monawamuya ma eli wehe lamadanaki ahaya minikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Oloti onawalo minabo wewenaya lahelamabo wewena minanako, monoka eli hulikaka niabo wewena minae. Edimoya elewole aneya le soto moloyoko mudatune liki nilahe. Edimoya elewole ane mako le soto molokoyoko mudamikilae. Hapaya monoka we Jona maya onawa loweki makoki wiyoko sinaibomidana oko yamidana ganegoya nemotoka soto pideko mudatae loko lokadanaki hulobetokoko wiye. 1 Mat 12:38; Luk 11:16 0 Mat 12:39; Luk 11:29 ");
INSERT INTO yby_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Unala ipalale yuha lemo maya beleti makoya leko wetubo nesamu lata molokaiyoko hulokoko niseko no adu helegaloka maya hetune. ");
INSERT INTO yby_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Niseko hetokuniyoko Jisesimamo koha moloko ga sa-loko lo limiye: Edimo Palasisi wewenaki ito Sediyusi wewenakiya lulu jekaka nesanipolimoya kohaidokatiyo, ehe. ");
INSERT INTO yby_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Loko liyoko beleti lulu jekaka nesamuya lihe loko leimo minunibotoka lo yolalo malo une. Beleti maya hulikoko nisudawokumuya gaya lo nolimiyo. ");
INSERT INTO yby_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Loko ludawo ga maya atauka hilekaiyoko sa-loko lo limiye: Agae, edimoya lasolasi eli elewole adanaki beletima hulikoko nisudawokumu noliye liki nenahamuya data etipa kiki nilae. ");
INSERT INTO yby_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nemoya elewole nesa leko nodenesa aha le soto mololibetatubomidana monawaya eli wehe lamahe. Nemoya 5000 wewenasida beleti lade maloka suwokoloti maya poseko bekoyoko niki niki ohumanipo okaiyoko lumawa hulabolawa maya li nupa iki manoda lape 12-pala owo jiki waitiki li molabo nesa maya data molokaiyoko lahe. ");
INSERT INTO yby_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ito 4000 wewenasida maya beleti 7-palaloti poseko bekoyoko niki dohumanipo okaiyoko usiki li molabolawa maya manoda lape nenaki li molabo ne. ");
INSERT INTO yby_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Edimoya beletimu lo lemepe liki nemo monawaneya nenahamuya eli wehe lamae. Palasisi wewenaki ito Sediyusi wewenakiya lulu jekaka nesanipolimo kohaidokatiyo, ehe. ");
INSERT INTO yby_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Loko akuya ga lo limiyoko yalo maya ele wehe lamune. Ele wehe lokoko beleti lulu jekaka noibo nesamu liyopakala, Palasisi wewenaki ito Sediyusi wewenakiya suwa-sawa monoka likaka niabokumuya liye loko elune. 2 Luk 12:1 9 Mat 14:17-21 10 Mat 15:34-38 ");
INSERT INTO yby_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisesima Sisaliya ebaya uliki we Pilipida uliwalo moli-minabo eba ilikalokaya woko nedanaki, unalale ipalale lemoda sa-loko loka oletaiye: Wewenasiya okulumauti we uti nemokumuya ekahima ne liki likaka niae. ");
INSERT INTO yby_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Loko loka iyoko, maloka wewenasiya emoya Jonima monoka noku udobetokaka we maya akuya soto peminane liki likaka niae. Ito malokasiya Ilaija maya hapa okulumau yowenebo we maya akuya lemeko minane liki nilayoko, malokasiya Omaimidana epaloti ga lokaka we Jelemaya maya aku soto pekane liki nilayoko, malokasiya hapa yeikala Omaimidana epaloti ga likaka wekidanaya soto peminane liki likaka niae, loko lo mune. ");
INSERT INTO yby_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Lo lokuniyoko, aku lemoda loka oletoko edimosiya nemodamuya ekahima ne liki data elikaka niae loko loka oletaiye. ");
INSERT INTO yby_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Loko loka oletokaiyoko, Saimoni Pitamamo emoya lahelamibo nesauti lilimitiye loko lo mololetaibo we Omaimidana ipala maya minane, loko liye. ");
INSERT INTO yby_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Loko liyoko, Jisesimamo Jonida ipala Saimoniyo, sa-loko ladawoya wewenasi ma li imikayoko lamane, ahone okulumau welimoya ata emekaiyoko lokaninako, sa-loko ladawomuya Omaimo maku imibo we minatane, loko lo miye. ");
INSERT INTO yby_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sa-lokaniyoko, yamuya lo emekoloyo, elo: Emo ulikaya Pitaya minane. Ito ulikamidana monawaya lemo ateutiya asowalaki ehada. Ito nemokahoya aya asowalaki ehadamidana mupilaloya monoka elitabo wewenasidaya dilipe nupa okoko hulobetokoyoko, joku hilitabomidana elewoleyalimoya ma dilipe yeimauka molamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ito nemokahoya okulumamidana oholau wikili ateda siyitabomidana kiwa maya emekoloe. Ito emokahoya mikauka saina makomu lo hoipa etadawoya okulumaukaya asako lo hoipa oetakolaiye. Ito ma mikauka nesamu lo hoipa ametadawoya asako Omailimo lo hoipa oetamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Loko lokoko unala ipalale yuha lemoda maya lata leko elewole gaya sa-loko lo limiye: Nemoya lahelamibo nesauti dilimitiye loko lo mololibetaibo we maya minonage, yaya aya wewenasida oha keke li bamilo, loko lo limiye. 14 Mat 14:1-2; Mak 6:14-15; Luk 9:7-8 16 Jon 6:68-69 19 Mat 18:18; Jon 20:23 ");
INSERT INTO yby_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ya yupeka maya Jisesima mino-loko nowidanaki emotoka soto pitibo nesahenaya unala ipalale yuha lemoda maya sa-loko lo limiye: Jelusalemu numutokaya yowekoyoko monoka ujapalo wesi ito Omaimitoka jokila hi mikaka wesiya, ito monoka monawa api-napi ibikaka wesiya muki miluma nesa li huli nupalo moliki kohaneli helikadeko, onawa loweki makoki yupekaya minokoko akuya sinatubo ne. ");
INSERT INTO yby_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yaya ga maya lo lemeko suwokaiyoko, we napane yamalae, Pitamamo Jisesida maya ilime aitoloka moloko auhala meko adeko We napane yamalae, Omailimo eseka vokadeko yamidana nesaya upakalo soto pamideyo. ");
INSERT INTO yby_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Loko liyoko, Jisesimamo mino wili jeko Pitada maya sa-loko lo miye: Olohamidana gala maya lokaniyo, mino oli o. Nemo anune maya heko li letadawo ga maya lokane. Aya ladawoya wewenasi datauti likaka niabo gaya lokaninako, Omaimidana gala maya elamoko lokane. ");
INSERT INTO yby_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Loko lokoko ya yupekaya Jisesikako maya amida meko sa-loko lo limiye: Wewena malokasiya nemo nemesalo molatune likima dupamo elitibo nesamu eli hulikiki wiki miluma nesa li ohibitiki kohaidi helitabomuya eliki oli bamideko eli hulikiki nemesalo moliki nisitae. ");
INSERT INTO yby_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wewena malokaya dukamidana eli amanapa ikiki minatabo wewenaya dukaya woko opa napa etibo ne. Ito maloka wewenasiya nemokumuye liki duka wina itaboya elewole depa mutiwa litabo ne. ");
INSERT INTO yby_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wewena malokasiya ma mika mupilalo nebo uvaminaya li suwikiki wiki edimonipo dukanipo woko tolowa etiboya maya mikauka uvaminalimo nena nena oko dilipe lalo etibo ne. Ito dukamidana weunaya nena nenakima meina hikiki aku litabo ne. Sakoya minamiye. ");
INSERT INTO yby_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Okulumauti we uti nemoya ahoneda lamedalalimoya mupilanelo yowekadeko muki okananipoki wesida maya dilipe-loko lemekoyoko, muki wewenasi ma mikauka iki moliki niabo nesaloya nemo pasobetatubo ne. ");
INSERT INTO yby_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nemoya wehe loko wati gaya lo libituyo, elilo. Edimo oloti maya minabokutiya malokaya owaha helamideko nemo okulumauti we uti lemeko uliki wetipo lolo olibetatubomidana elewoleyala maya soto pideko mudakilae, loko lo limiye. 24 Mat 10:38; Luk 14:27 25 Mat 10:39; Luk 17:33; Jon 12:25 27 Mat 25:31; Sam 62:12; Lom 2:6 ");
INSERT INTO yby_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jisesi maya 6-pala onawaya wokaiyoko Pitale ito Jemisile Jemisida unala Jonilesida maya dilipe-loko bola hanau makoya yowiye. ");
INSERT INTO yby_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yauya yoweyoko, domudaloya Jisesida upala maya aitomidana soto piye. Okulumau minokaka ibo upala maya le uho okoko okepala maya ho ijala hulaibomidana okoko upalo nesalokati maya ukulo hege-pege loko neyoko mudae. ");
INSERT INTO yby_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sa-iyoko, Ilaijako Moseseko maya okulumauti limiki Jisesilemaki alo-nalo le. ");
INSERT INTO yby_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Alo nalo likayoko mudaikiki Pitamamo Jisesida maya sa-loko lo miye: We napane yamalae, maloya minudawoya dowa lokaiye. Sa-okainako, yamuya elekadeko maya, maloya olowala numuda loweki makoki volibetatuniyo. Makoya emoda ito makoya Moseseda ito makoya Ilaijadae. ");
INSERT INTO yby_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Loko nolibo epakiya limu ukulolimo lemeko jeko hitobikaiyoko, ayautima ga mako sa-loko soto piye: Maya nukane meminobo ipane maya nenako, muda-eloboya numu helekaiyo, emo gala maya eliki emesalo molalo, loko liye. ");
INSERT INTO yby_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Loko lokaiyoko, unala ipalale yuha maya domoda wokaiyoko, mikauka maya limiki dokepa hi-minayoko di dade maya pipi oko dupauya liye. ");
INSERT INTO yby_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sa-iyoko, Jisesimamo woko dupaloka maya nolidanaki, sa-loko lo biye: Domoda wamideko sinalo. ");
INSERT INTO yby_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Loko lokaiyoko, siniki mudabo maya Jisesima eimolago neyoko mudae. ");
INSERT INTO yby_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mudaikiki, bolauti maya nilemeyoko, Jisesimamo sa-loko lo biye: Bolauya sainahena mudaboya enemane iki wetome iki wewenasida li bamilo. Nemo okulumauti we uti maya helekoko sinoko yowekoyoko li bitayo. ");
INSERT INTO yby_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Loko lokaiyoko, Jisesida maya loka itiki lahelamibo nesauti lilimitibo we maya owaha nisamideko Ilaijaya omutoko nisitibo ne liki monoka monawa api-napi ibikaka wesiya nenahamuya lae, liki loka itae. ");
INSERT INTO yby_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Liki layoko, Jisesimamo sa-loko lo biye: Ilaijakidana weya omutoko niseko saina-painahena le lolowa etiye likiya wehe liki laboya, nemoya lo libituyo, elilo. ");
INSERT INTO yby_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ilaijakidana we maya alo soto pekaiyoko, edimoya muda-eli wehe lamiki data eleboto lahelamibo nesa lolo itikayoko alo helekaibo maya ne. Sa-okaibo maya nenako, asaiki nemo okulumauti we utiya miluma nesa li ohinitakilae. ");
INSERT INTO yby_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Loko Ilaijakidana wemuya liboya noku udobetokaka we Jonikumuya liyo, liki elebo ne. 1 2 Pit 1:17-18 5 Jen 22:2; Sam 2:7; Aes 42:1; Mat 3:17 5 Mat 12:18; Mak 1:11; Luk 3:22; Dut 18:15 10 Mal 4:5 12 Mat 11:14 ");
INSERT INTO yby_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sakiya bolauti maya limikiki, muki wewena maya minabotoka nisikayoko, we makolimo eke loko Jisesida iguka maya niseko i bola heko sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","We napane yamalae, ipanedamuya miluma elamane. Ipaneya nei molokadanaki, epaukaya etehu ilakilalimo waitokaiyoko nokukahe ito jokukaya lemeko pou loko udokaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Unakale ipakale yuhasiya ilimi haka litahe loko ilime-loko minabotoka woyoko, sa-imi waha waha haka loetamiyoko, aya nesalimoya newe newe lokaiye. ");
INSERT INTO yby_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Loko liyoko, Jisesimamo edimoya eli elewole amiki eli amanapa ikiki minabokumuya osele nelokaiye, loko liye. Edimotoka minoko muki yupeka maya lo libe-loko woko niseko noboto maya, elewole iki data kamanako, aya yowanuya nemogo leko minatuhe. Loko lokoko aya oluho maya namaitoka ilimi-liki nisilo. ");
INSERT INTO yby_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Loko lokaiyoko ilimi-liki nisikayoko, Jisesimamo aya oluhomidana maya auha miyoko hulomikoko wiye. Sakoya hulomikoko wokaiyoko, aya oluho maya aya onawasilo maya dowa lokaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","unala ipalale yuha lemoya minudanaki, Jisesida maya loka itoko lemoya oloha maya nenaha iyokoma kohako oli hamune, loko loka otune. ");
INSERT INTO yby_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Loka lutuniyoko, Jisesimamo edimoya eli elewole ikakawatipoya lasolasi minokaiyokoyako, kohaiki oli hamae, loko lo limiye. Sa-ikayo, wehe loko wati aya lo libituyo, elilo. Maya mikauka masteti ihilawa lasolasilimoya wileko yoweko napa-napa okaka noibomidana iki eli elewole ikaka nesatipo netiboya, bolamidanaya mino olowe o liki litaboya aha mino olowe etibo ne. Sakiya edimo muki nesaya aha lolo itabo ne.  ");
INSERT INTO yby_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sa-oneboya, yamidanaya oloha nosamibomidana kohako oli hekaka anuwa mako minamiye, Omailoka lokakadunu ito monoka letune liki nodenesa mosikakadunuya kohako oli hetudawo ne, loko liye. 20 Mat 21:21; Mak 11:23; 1 Kol 13:2 ");
INSERT INTO yby_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sakoya onawa lasolasi mako minokoko Jisesiki lemokiya magoina noyowudanaki woko Galeli ebakukaya minuniyoko, sa-loko lo limiye: Okulumauti we uti nemodaya mini hana amiki ulanelo wewenasida dadeu nilimi molikadeko ");
INSERT INTO yby_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kohaneli helitaboya, onawa loweki makoki minoko helitubokutiya aku sinakoloe loko lo biyoko, lemo maya eke napa lune. ");
INSERT INTO yby_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sakoya minoko Kapaniyamu numutoka maya wuniyoko, monoka numuda napamidana takisi ehada likaka wesiya Pita maya nebotoka wiki loka itiki sa-liki lae: Monoka monawa api-napi obetokaka noibo wetipoya monoka numudamidana takisi ehadala maya hulokaka noihe. ");
INSERT INTO yby_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Liki layoko, Pitamamo nenaha iye, molokakawaya neboyae, loko liye. Sa-loko lokaiyoko, numukuya yoweko Jisesida maya aya nesamu owaha lo mamiyoko, Jisesimamo loka oetoko Saimoniyo, emoya nenae loko noelene, loko liye. Maya mikauka duliki wesiya nakaha wewenalokati takisi ehada likaka niae. Edimonipo wewenanipolesitokatigoya likaka niahe, ito aito mikalokati wewenasitokatigoya likaka niae. ");
INSERT INTO yby_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Loko liyoko, Pitamamo aito mikalokati wewenasitokatigoya likaka niae loko liyoko, Jisesimamo sa-loko lo miye: Sa-okainako, mika aholaya dupa meina hamiki aha minatayo. ");
INSERT INTO yby_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ito nemoya aya monoka numudamidana ahola maya minonako, takisi ehadaya hulamoko aha minatubo neboya, nemodamuya elitaboya lahelamo okatiyo. Yamuya emoya lemeko adugu maya lawaha hikaka owo maya hulikoko lawaha ada litadawomidana epala maya le ka oko mudao. Lawahamidana epalauya ehada nedeko mudakokoma leko yowekoko nemoki emokiya lupa meina hitane, loko lo miye. 24 Eks 30:13; Eks 38:26 ");
INSERT INTO yby_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ga sa-loko lo limibo yupekaya unala ipalale yuha lemoya Jisesi nebotoka woko sa-loko loka otune: Okulumauti Omailimo ujapa oletatibo wewenautiya ekahimamo aseletoko uliyaki we lolo etibo ne. ");
INSERT INTO yby_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Loko lokuniyoko, Jisesimamo oluho lasola mako ju loko ilime-loko niseko luwateu maya ilime sinonedanaki sa-loko lo limiye: ");
INSERT INTO yby_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nemoya wehe loko lo libituyo, elilo. Edimoya dukaya li wili jikiki limiki maya oluho lasolakidana minamitaboya keke okuluma ebakuya yowamikilae. ");
INSERT INTO yby_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Okulumauti Omailimo ujapa olibetatibo wewenautiya oluho lasola mamidana iki minatabo wewenasiya asibitiki we napa lolo ikilae. ");
INSERT INTO yby_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Wewena malokasiya nemokumuye liki oluho lasola mamidana iki nasahili ibitataboya nemoda nasahili initabo ilekaiye, loko lo limiye. 1 Luk 22:24 3 Mak 10:15; Luk 18:17 ");
INSERT INTO yby_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ito nemokumuya elewole iki eliki minatabokutiya wewena oluho mako limiki minatabokutiya wewena malokasiya lahelamibo nesa litae liki ula molataboya, agae. Omailimoya edawaki adoha nesa lolo obetatibo ne. Aya wewenasidaya ehadaloti enonipoloya nala jikiki dipisiki huli ela noku molatabomidana asetoko adoha nesa lolo obetatibo ne. ");
INSERT INTO yby_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ito lahelamibo nesa litae loko ula molokaka nesa aito aitomidanaya ma mikaukaya ne. Aya lahelamibo nesaya aha soto pekolaiboya, we makolimoya lahelamibo nesa litae loko ula moloko lo-lele monitiboya Omailimoya nenaha oetatibo ne. Agae, adoha oliwaki nesa lolo oetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Sa-etibo neyo, ikalimohe ito adekalimohe lihima lekaka anugu ilime-loko nowidekoma hukoko le hulo. Ikaya makoko nedeko ito adekaya makoko nedeko elewole oko minokaka anuguya aha wetaniyo. Ika adeka lowe minoko ilime jo ebaku molokadeko joya hamoko lowa lowa oko netibo ebakuya wokataniyo. ");
INSERT INTO yby_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ito omudakalimoya lihima lekaka anugu ilime nomoladeko maya yatoka heko likoko le huliko. Omudaka makokogo nedeko elewole ebakuya yowitadawoya wehe lone. Omudakaya lowe minokoko miluma elikaka jokuya ilime molokatiyo. 8 Mat 5:30 9 Mat 2:29 ");
INSERT INTO yby_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Edimoya ehetipoe, unamotanelemuya elideko aha nesa lolo amideyo. Yamuya nemo wehe loko lo libituyo, elilo. Okananipoki we okulumauya minikaka niaboya, ga maya likili maya muki yupekaya ahone Omaida owisaloya wiki miniki likaka niae.  ");
INSERT INTO yby_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ito okulumauti we uti nemoya wi tolowa ikili abokuti ohu jeko olisauti dilimituwe loko lemobo maya ne. ");
INSERT INTO yby_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yamuya edimoya nenae liki niele. We makomidana sipisipi jala 100 minatabokutiya makokoma tolowa etiboya ohu jametibo nehe. Sakoya minamiye. Sipisipi jala 99 yawa maya bolaukaya hulobetoikoko moneko tolowa etibo jamidana maya abuha moloko ohu jitibo ne. ");
INSERT INTO yby_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nemoya wehe loko lo noliboe. Sakoya moneko ohu jewa jewa oko le soto molokoko maya ukaukaya dowa lekolaiye. Ukauka lahelepa etiboya jala 99 maloka aha minabosidamuya samekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ito ahotipo okulumau welimoya ayamidana oko edimo oluho unamotanele yuhaya makokoma tolowa etibokumuya umu helamiye. ");
INSERT INTO yby_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Iweka makolimoya emotoka lihima nesa lolo ogetokadeko maya edimotopogoya woko emokahoya aya nesa maya ilipo. Sakokoya yaloti maya emo aka elekadekoma iwekada maya aku ilime emotoka molataniyo. ");
INSERT INTO yby_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sakoko emo gakama elamidekoma, we makokihe ito lowekihe magoina dilipe-loko wo. Sa-okadeko monoka bukuguya ga mako sa-liki luhuwa ji-minabo maya niseko pasetiye: Ga yowanu litabotoya wewena lowehe loweki makokihe miniki makomidana monawalamuya ga yowanu liki litaboya, woko wehe letibo ne. ");
INSERT INTO yby_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sakoya sa-etadawoya, gaka maya elamidekoma, monoka emesalo molabo wewenasida maya woko lo bo. Sakoya sa-etadawo maya yatoka wewenasi ga makiya elamidekoma, aya weya lihimalaki we ito takisi ehada lekaka wekidana monoka elametibo we lolo ideyo. 15 Luk 17:3 16 Dut 19:15 ");
INSERT INTO yby_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nemoya wehe loko lo libituyo, elilo. Edimoya maya mikau saina makokumu li hoipa itaboya, Omailimoya asako okulumauya aya nesamuya lo hoipa olibetakolaiye. Ito asaikiya saina makokumu li hoipa amitaboya Omailimoya okulumauya asako lo hoipa olibetamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Sa-etibo nenako, makoki amida meko lo libituyo. Edimokutiya wewena lowesihe ito wavu-liki wewenasiya saina makomu dukaya moli makokoto molikiki duka makoko lolo okadeko Omailoka litaboya ele libitibo ne. ");
INSERT INTO yby_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ito wewena lowehe ito loweki makokihe ito wavu-liki wewenasiya nemo nulinelo li nupa itaboya, aya wewenasida luwawanipouya lemeko minatubo ne. 18 Mat 16:19; Jon 20:23 ");
INSERT INTO yby_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Loko lokaiyoko, Pitamamo mino Jisesida amaitoka molaidanaki we napane yamalae, iwene makolimoya lihimala onawa nenaki yupeka nimideko huloetatubo ne, 7-pala onawa nehe. ");
INSERT INTO yby_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Loko liyoko, Jisesimamo onawa 7-pala minamiye, 7-pala yupekaya hulotomo wideko woko onawa 700 lolo ideyo. ");
INSERT INTO yby_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yamuya Omailimo okulumauti ujapa oletadeko minatudawomidana malokaya dilipeko ga mako letuyo. Uliki we makolimoya elekele welalesida lihimanipomuya le wehe lekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lihima liminayoko le wehe lekoloya api oko yowanu noliyoko, we makomidana emotoka ilimi-liki nise. Emotokaya lihimala 10 miliyoni kina nebo we. ");
INSERT INTO yby_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sa-iboya aya lihimala pasetibo ehadalaya ma minamiye. Sa-okaiyoko, uliki wemamoya sa-loko liye: Dinala pasetibokumuya emo menakipa oluholaleki ito uvaminanipo mukiya wewenasi meina hi suwikadeko emoda meusa oluho lolo itiki minatae. ");
INSERT INTO yby_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Loko lokaiyoko, elekele oluhomamo uliki wemidana iguka i bola heko sa-loko liye: Eke loneto-loko woko minaniyoko, nemoya woko ehada le soto molokoko pasoeto-loko wetuwe. ");
INSERT INTO yby_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Loko liyoko, aya yowanulo wemamo elekele oluholada milumala eletokoko huloetaiye. Sa-iboya lihimalakiya aha huloetaiye. ");
INSERT INTO yby_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Sakoya huloetokaiyoko, aya elekele oluhola maya numukuti lemekoko woko yowanu welada ehada 100 kinaya omutoko meneboto nenako, mudakoko enola leko po notidanaki sa-loko liye: Emoya ehada emoboto maya muki alo pasoko nimitadawokumuye. ");
INSERT INTO yby_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Loko lokaiyoko, iwela maya iguka i bola henedanaki ekewake noidanaki sa-loko lo meko liye: Emoya esene vonetokadeko ehada ohu jekoko alikaya pasoko imituhao. ");
INSERT INTO yby_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Loko libo maya ele hulikoko iwelada maya obi omikaiyoko nala numukuya hulitae. Sakoya yau maya minoko lihimalaya suwetiye loko nala miye. ");
INSERT INTO yby_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sa-iyoko nenako, wewenalalesiya aya nesa maya mudaikiki nenako, mulunipouya lahelamibo ele. Sa-ikiki nenako, wiki uliki we napamidana maya wetome iki li me. ");
INSERT INTO yby_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sa-ikayoko, uliki wemamo elekele wemidana maya ju liyoko, nisiyoko sa-loko lo miye: Elekele oluho lahelamadawolika, emoya laniyoko lihimaka maya aha huloetokobo maya ne. ");
INSERT INTO yby_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nemoya emokumuya milumaka elegetobo maya ne. Sa-okobo maya nenako, emoya asako iwekada maya milumala eletoko lihimalaya huloetamaninako. ");
INSERT INTO yby_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Loko lokoko uliki wemamo epauka lalo lamiyoko, miluma nesa litikiki wideko minoko lihimala paso suwetiye loko imiki wesida dadeu maya molaiye. ");
INSERT INTO yby_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sakoya lokoko Jisesimamo sa-loko liye: Edimo mukiya dukauya iwetipolesida lihimanipo hulamitaboya, ahone okulumau nebo welimoya asakogo edimotoka lolo olibetakolaiye. 21 Luk 17:3-4 ");
INSERT INTO yby_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisesimamo aya ga maya lo beko suwokoko Galeli eba maya hulikoko Juda ebatoka Jodani no yola helegaloka maya wiye. ");
INSERT INTO yby_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Sakoya nowiyoko, muki wewenamasiya emesalo moliki wae. Sakoya woko yaloka maya saina delaibo wewenahenasida dilipe haka loko ne. ");
INSERT INTO yby_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sa-noiyoko, Palasisi wewena malokasiya emotoka nisiki mulunau hiki sa-liki lae: Mosesekaho lo hukoko libo gautiya we makolimoya sainahenamamuya menalada oli hituwe lokoya aha oli he hulatibo ne loko lonebo ga maya wehe lonehe, ito wehe lamiye. ");
INSERT INTO yby_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Liki layoko, Jisesimamo, edimoya monokauya ga mako sa-loko nebo maya lepiki eliminaboya data molokaihe: ");
INSERT INTO yby_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hapa yeikalaya Omailimo dilipe soto molaibo yupekaya weki menakiya dilipe soto molonebo maya ne. Ito dilipe soto molokoko sa-loko lonebo maya ne: Yamuya we makolimoya dolako aholakosida maya hulobikoko menalate duka depa moli makokoto molikiki omiki minasaiye. ");
INSERT INTO yby_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Loko lonebo maya nenako, edimoya lowe minamikilae, makoko dupaya lolo one. Sakoya Omailimoya dilipe makoko wewena lolo onebo nenako, wewenalika dilipe hoto-poto ametadawo ne. ");
INSERT INTO yby_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Loko lo bekaiyoko, Palasisi wewenasiya Mosesekahoya menakipa doli hetune liki luhuwa nesa mako jiki bikiki doli hilo loko liboya nenahamuya liye. ");
INSERT INTO yby_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Liki layoko Jisesimamo Mosesekahoya ahamu yatoka lamiye. Edimoya nei nei moliki duka opa ibokumuya mena doli hitae loko ele libeko sa-loko luhuwa jeneboya, saina-painahena api oko le soto molaibo onawaloya sakoya minamiye. ");
INSERT INTO yby_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Sa-onebo nenako, yamuya nemoya sa-loko lo noliboyo, elilo. We makolimo menalakahoya aito wemidana adelo ika amideko ahamu oli hekoko mena mako litiboya, olisaya nenako, lihima napa litibo ne. ");
INSERT INTO yby_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Loko lokaiyoko, unala ipalale yuhasi lemoya sa-liki lo mune: Welo menaloya sakoya minokainako, mena lamoko aha minatunikowo. ");
INSERT INTO yby_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Loko lokuniyoko, Jisesimamo welo menalo mukiya oloti maya lo libitubo galoya emesalo molamikilae loko lo biye. Omailimo elewoleya benebo wewenasigoya litabotogoya ne. Wewena malokasiya donipolesida dohumanipoutiya we mena lamokakawaya soto pebo ne. Ito maloka wewenasidaya oluho etamokaka nesaya dupalo moli hukibitikayoko we mena lamae. ");
INSERT INTO yby_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ito wewena malokasiya okulumau ohomidana yowanulamuye liki welo menalo ikaka niabo nesa maya o'e likae. Sa-ikanako, maloka wewenasiya ayamidana elewoleya li-minatabo maya emesalo molatae. 4 Jen 1:27; Jen 5:2 5 Jen 2:24 7 Dut 24:1-4; Mat 5:31 9 Mat 5:32; 1 Kol 7:10-11. ");
INSERT INTO yby_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ya onawaloya oluho lasomosola Jisesitoka dilipi-liki wae. Emokahoya adelama madonipolo moloko maku bitiye liki dilipi-liki wae. Sakiya dilipi-liki niwayoko, lemo unala ipalale yuhamasiya auhaya bune. ");
INSERT INTO yby_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Auha nobuniyoko, Jisesimamo lemoda maya edimoya oluho lasomosolasida yaitaya hulibikalo, nemotoka nisitayo. Yamidana oluhoya okuluma ebaku maya yowitabo oluhoya minayo, edimoya li hoipa ibitamilo. ");
INSERT INTO yby_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Loko lokokoya adedunuya madonipolo moloko maku biye. Maku bekoko, ya eba maya hulikoko wiye. ");
INSERT INTO yby_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yu makoya we makolimo Jisesi nebotoka niseko loka oetoko sa-loko liye: Tisane yamalae, nemoya nena nesa laloya lolo okoko elewole nepa mutiwa litubo ne. ");
INSERT INTO yby_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Loko liyoko, Jisesimamo emoya saina lalomuya nenaha iyoko loka nonetane. Lalo nesamidana aholaya makoko Omaiya nenako, monawane maya ele wehe lo-minoko lalo nesamuya loka nonetape. Ito emoya elewole epa mutiwa lituwe lokoma Omaimidana 10-pala lolaya eleko emesalo molo. ");
INSERT INTO yby_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Loko liyoko, aya wemamo Omaimidana 10-pala lolae loko noladawoya nakaha gamuya nolane, loko loka iyoko, Jisesimamo sa-loko lo miye: Omaimidana gala maya sakoya ne: Wewenasida kohaido helamo. We olisa mena olisa amo. Ukele amo. Suwaki namaki lamo. ");
INSERT INTO yby_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Dokako ahokako dulinipo le sawa jo. Ito eimokadamu elekaka noadawo nesa leko iwekadamuya eleko uka mo. ");
INSERT INTO yby_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Loko lokaiyoko, we owahamoya sa-loko lo miye: Aya lo hukaibo gaya emesalo molo-minobo maya nenae. Makoma nakaha nesa maya le opa oko lamoe. ");
INSERT INTO yby_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Loko liyoko, Jisesimamo sa-loko lo miye: Emoya ukaka dowa loko netiye lokoma woko muki uvaminaka maya meinalo ona moloko lekoko uvaminanipo minamibo wewenasida maya bekoko niseko nemesalo molo. Sa-okadeko, okulumau elewole uvamina maya emotokaya soto pitibo ne. ");
INSERT INTO yby_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Loko lokaiyoko, we owahamoya elekoko uvaminala maya waitoko nebo nenako ona moloko bituhelae loko ata kibolimoya edala elokaiyoko aha wiye. ");
INSERT INTO yby_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nowiyoko, Jisesimamo unala ipalale yuha lemoda maya sa-loko lo limiye: Nemoya wehe loko lo libituyo, elilo. Uvaminanipoki wewenaya okulumamidana ebalauya osele nesa liki yowitabo ne. ");
INSERT INTO yby_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Oha mako lo libituboya sa-one: kamolo jalimoya nekamidana anuwa lonebokuya wokaka nesaya osele nesa leko yowitibo neboya, uvaminanipoki wewenasiya Omaimidana ebalau yowitaboya yatoka nesamidana asetiki osele yowanu adoha litabo ne. ");
INSERT INTO yby_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Loko liyoko, lemo maya eludanaki oliteda adoha lenebo ne. Oliteda adoha lekaiyoko nenako, sa-loko loka itune: Sa-lokoma ekahidama lahelamibo nesauti ilimekadeko mino-loko woko minatiye. ");
INSERT INTO yby_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Loko lokuniyoko, Jisesimamo wenu mudailenedanaki sa-loko lo limiye: Wewenasiya yamidana itaboto minamiboya, Omailimoya saina mako lolo etuwe loko ata kitibo nesaya aha lolo etibo ne. ");
INSERT INTO yby_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Loko lokaiyoko, Pitamamo ele-minape. Lemoya muki nesatehena maya hulikoko emodaki magoina nomonudanawoya, alikaya meinawa letudawo nehe. ");
INSERT INTO yby_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Loko loka oetokaiyoko, Jisesimamo sa-loko lo limiye: Wehe loko lo libituyo, elilo. Alikaya muki nesahenaya ohatama soto pitibo onawaloya, nemo okulumauti we utiya onowelaki siyaloya lamedaneki minoyoko, edimo we 12-pala nemeke moliki nisebo weya asaiki lamedatipokiya onowelaki siya 12-palaloya miniki Isilaelo wewena nala 12-palasida maya ujapa ibitiki ona molibitiki minakilae, loko liye. ");
INSERT INTO yby_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wewena malokasiya nemo nulinemuye liki numudanipohe ouna yuhahe, donipole ahonipolehe, ito oluhonipolekihe, ito mikanipohe hulatabomidana meinawa yowiki litayo. Ito minowa minowa okaka depa mutiwa maya likilae. ");
INSERT INTO yby_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Oloti omutiki nisebo wewenaya mini alika ikadeko alika minabo wewenasiya mini omutikilae. 18 Eks 20:13-16; Dut 5:17-20 19 Eks 20:12; Dut 5:16; Liv 19:18 28 Mat 25:31; Luk 22:30 ");
INSERT INTO yby_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Okuluma oholamidana yowanula lekaka nesaya sakoya ne: We makolimoya mikala napa-napa nebo welimoya nekewa napaya sinokoko waeni mijalau yowanu litabo wemuya ohu jeko wiye. ");
INSERT INTO yby_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sakoya woko yowanulo we maya ohu jekoko onawa makoko makokoloya 20 kina litae loko liyoko, oo likiki emesalo moliki wiki yowanula waeni mijalau maya litae. ");
INSERT INTO yby_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Sakiya yowanu nileyoko ho maya yoweko 9 kiloku ibolawa maya mudaiboya wewena malokaya maketilo matokaya aha minayoko mudaone. ");
INSERT INTO yby_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sako mudaidokoko edimokiya nemo waeni mijaneu maya wiki yowanu litahe ehadaya wehe loko libekoloyo. ");
INSERT INTO yby_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Loko lokaiyoko, wiki aya yowanu maya le. Holigaki ito ludaka 3 kilokuloyaki woko mudaibo maya asakogo sa-iye. ");
INSERT INTO yby_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ludaka 5 kilokuloya woko mudaibo maya, li esa ikaka ebatoka maya maloka wewenasiya aha siniki minayoko mudaiye. Sakiya minayoko mudakoko edimoya nekewa ludakaya maloya nenaha iyokoma sini-minae, loko loka obetaiye. ");
INSERT INTO yby_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Loko liyoko, aya wewenamasiya lemoya we makolimo yowanu lemamiye, liki layoko emomamoya sa-loko lo biye: Edimokiya nemo waeni mijaneu maya wiki yowanu lilo. ");
INSERT INTO yby_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Loko lokoko ludaka maya lokaiyoko waeni mijamidana aholamamoya ujapa welamidana maya sa-loko lo miye: Yowanulo wesida maya ju loko meinawa maya bo. Alika nisiki yowanu lebola beloko nowoko maya omutiki nisiki yowanu lebolawasidaya alika bitane. ");
INSERT INTO yby_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Loko lokaiyoko ludaka 5 kilokulo yowanu lebo wewena maya ehada 20 kina leyoko, ");
INSERT INTO yby_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","edimo omutiki nisiki yowanu lebo wewenasiya meinaya napa oko letupe liki data kebo maya neboya, edimokiya asaiki 20 kinagoya limi wae. ");
INSERT INTO yby_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sakiya likiki waeni mija aholadama auha miki sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Emoya alika nisiki yowanu lasolasi lebo wewenamakiya meinawa makoko aweyaha oko lemekane. Sa-oneboya, lemoya ho napa libotoya osele yowanu leko lupate miluma noko lune. ");
INSERT INTO yby_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Liki likayoko, edimo luwawanipouti maya ujapa welimoya we makomidana sa-loko lo miye: Iwenelika, nemo ilime lahelamibo lolo amoe. Emoki nemokiya lukate molo makokoto oikoko 20 kina litane loko lokoibo maya ne. ");
INSERT INTO yby_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sa-lokoibo maya neyo, meinawaka lekoko wo. Meinawaka emoboya makoko aweyaha okogo alika nisebo weinayaki libituwe loko ele-minobo maya ne. ");
INSERT INTO yby_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nenaha iye. Nemoya aya ehadanedunuya saina mako lolo etuwe loko ele-minobo maya neboya, ma kohamihe. Nemoya saina laloya lolo ogetoha, emoya nenahamuya elekaniyoko lahelamiye, loko mija aholamamo liye. ");
INSERT INTO yby_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Loko Jisesimamo lokoko amida meko sa-loko liye: Ayamidana oko oloti onawaloya mini omutabo wewenasiya mini alika moladeko alika mini molabo wewenasiya mini omutikilae, loko liye. 8 Liv 19:13; Dut 24:15 16 Mat 19:30; Mak 10:31; Luk 13:30 ");
INSERT INTO yby_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisesilemaki Jelusalemu numutoka niyowekayo, unala ipalale 12-pala maya lilime ata jeko sa-loko lo limiye: ");
INSERT INTO yby_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Elilo. Olotiya Jelusalemu numutoka maya noyowune. Yalokaya Omailoti lemobo we uti nemoda maya Omailoka jokila hi mikaka weki ito monoka monawa api-napi ibikaka wesidakiya dadeu nilimi molikiki obi initiki kohaneli helitabo aya likilae. ");
INSERT INTO yby_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sakikiya hetoka wewenasida dadeu maya nilimi-liki wiki hulikadeko, ulana molinitiki uhedawaki nalalotiya kohane-liki yoha yaha yalo maya kohaneli helikilae. Sa-ikadeko, loweki makoki yupeka minokoko helitubokuti aku sinakoloe, loko liye. ");
INSERT INTO yby_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ya yupekaya Jebetida menalamamo ipala lowesida maya dilipe-loko Jisesima nebotoka woko saina makokumuya loka oetaiye. ");
INSERT INTO yby_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sa-loko loka oetaiyoko, Jisesimamo aya menamidana aku sa-loko loka oetaiye: Emolikaya nenahamu elokaiyoko nolane. Loko liyoko, maya menamamoya sa-loko liye: Ele nemekadeko emoya uliki we napa lolo oko minoko ujapa oletatadawo ebakukaya ipane lowe maya apika maloka maloka minasaiye loko noloe. ");
INSERT INTO yby_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Loko lokaiyoko, aya we lowesida maya Jisesimamo sa-loko lo biye: Edimoya loka initaibo nesamidana monawa maya eli opa ikiki likaiyo. Nemoya ekesa nesaya natubokutiya aha nasaibo nehe. Loko liyoko, edimoya aha nasibo maya nenae, ");
INSERT INTO yby_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","liki laiyoko, Jisesimamo sa-loko lo biye: Ekesa nesa natubokutiya aha nasaibo neboyako, nemo apine maloka maloka minikaka nesaya nemo nesane neboyakoko libituhe. Ahonekaho dilipe lolowa obetaibo wewenasida sianipomuya nilaiye. ");
INSERT INTO yby_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Loko lokaiyoko, lemo unala upalale yuha malokasiya aya ga maya elekoko iwete lowesida maya depa aha kohaiduniyoko, ");
INSERT INTO yby_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jisesimamo ju loko sa-loko liye: Ma mikauka duliki wesiya elekele oluhonipolesida ujapa ibitikaka niae. Ito we napasiya asaiki ujapa ibitikaka niabo nesaya edimosiya alo eliminaboya, ");
INSERT INTO yby_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","edimotokaya sakoya minametiye. Edimokutiya we makolimoya nuliki we minatuwe lokoma ukalaya lemeko minoko elekele obetoko minatinako, ");
INSERT INTO yby_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ito wewena makolimoya muki wewenasida asebetoko minatuwe loko maya lemeko minoko muki wewenasida meusa oluhonipo lolo obetoko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Omailoti lemobo we uti nemodaya elekele initatae loko lemamoe. Muki wewenasida elekele obetoko lahelamibo nesauti meina hebetoko nalauti olutobetatuwe loko minoko leko obo nupa maya hulatuwe loko lemobo maya ne, loko liye. 25 Luk 22:25-26 26 Mat 23:11; Mak 9:35 ");
INSERT INTO yby_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisesima unala ipalale yuhalitakiya Jeliko eba maya hulune. Hulokoko nowuniyoko, muki wewenamasiya lemeke moliki dupalo dupalo iki wae. ");
INSERT INTO yby_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sakoya nowuniyoko, we lowe domuda likaibo weya anulo miniki Jisesi maya nonisiye liki laboya elikiki amowa jiki sa-liki ju liki laiye: We napao, emoya Dewitida awolao, olisauti lilimitiye loko lo mololetaibo we yamalae, lemodamuya milumate eleletowo. ");
INSERT INTO yby_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Liki nilaiyoko, muki wewenamasiya moletiki minasaiye liki auhaya be. Saboya edimomasiya eli hulikiki alukada moliki ju liki sa-liki laiye: We napao, Dewitida awola yamalae, lemodaya milumate eleletowo. ");
INSERT INTO yby_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Liki laiyoko Jisesimamo woko anulo maya nedanaki ju lo biyoko, amaitokaya niseiyoko sa-loko lo biye: Edimo nenaha lolo olibetatubokumuya nilaiye. ");
INSERT INTO yby_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Loko liyoko, sa-liki li meiye: we napate yamalae, lemo lomuda maya le pana keletatane loko noloiye, liki laiye. ");
INSERT INTO yby_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Liki laiyoko, Jisesimamo milumanipo elekoko adeloti maya domudalo noliyoko, aya onawalo maya wehe loko domuda maya pana kekaiyoko, Jisesida emeke moliki waiye. ");
INSERT INTO yby_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sa-okaiyoko, Jelusalemu numutoka aliliya Betepeje ebatoka maya Oliwi ya bola ohunalo maya woko hetune. Yaloka maya woko hetokuniko Jisesima unala ipalale yuhauti we lowe maya doli nohidanaki sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Edimoya yolaya numutokaya wiki hetikiki donki ja hosi elibo jaya dolako ipalako nala jibitiminabototiya wina iki liki maloka nisiliyo. ");
INSERT INTO yby_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sakiya wina iki liki niniseideko, we makolimo loka olibetadekoma, We napamamo yowanu neyoko maya jamuya liyoko nonisoiye liki likadekoya enemane oko ele libekadeko liki nisiliyo. ");
INSERT INTO yby_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Loko lokaiyoko waiboya aha samiye. Omaimidana epaloti ga lokaka we makolimo libo ga maya niseko pasetiye liki sa-iye. ");
INSERT INTO yby_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Aya welimoya sa-loko luhuwa jibo ne: Saiyona bolau wewenasidaya sa-liki li bilo: Uliki wetipoma edimotoka nowiye. Aya weya juna onedanaki donki jamidana emesalo yaitaya nowiye. Donki ja akalewalimoya emesalo ehuna oko leko yaitaya nowiye. ");
INSERT INTO yby_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sa-okaiyoko, unala ipalale yuhamasiya Jisesima libo ga maya elikiki waidanaki, ");
INSERT INTO yby_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","donki ja ipalako dolako maya dilipi-liki niseiye. Sakiya dilipi-liki nisikaiyoko, lawolawonipoma ololotiki donki jamidana emesalo molikayoko, Jisesima yoweko yaloma esela heko neyoko, ");
INSERT INTO yby_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","maloka wewenasiya dupalo nesama ololotiki anulo maya newelusa itae. Ito maloka wewenasiya dumu helibo nesahena kokonasi ailawahenama hiliki anulo maya newelusa iti-liki wae. ");
INSERT INTO yby_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sa-niayoko, wewena omutiki alika moliki abo wewenasiya ga napauti sa-liki lae: Agae, Dewitida awolamae, epoka letune. We napatemidana galalo maya soto pekadanako, Omailimo maku imiye. Agae, okulumau Omaitemidanaki epoka letune. ");
INSERT INTO yby_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Liki layoko, Jelusalemu numutokaya yoweko hetiyoko, numuda ahola maya mulunipo yowiye. ");
INSERT INTO yby_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mulunipo yowekaiyoko, ekahoma nisiyoko nilae, liki layoko, Omaimidana epaloti ga lokaka we Jisesima Galeli ebakuka Naseleti numutoka soto pibo we maya nisekaiyo liki lae. 5 Jek 9:9 9 Sam 118:26 ");
INSERT INTO yby_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisesimamo woko monoka numuda napama mudakoko ayauya yoweko wewena sainahena liki nisiki maketilo moliki li yolalo malo niabo wewenasida maya kohaidoko doli he hulikoko, aito mikaukati ehada maya aya mikauti ehadalo li moliki senisimi ikaka wesida namabeta maya leko hululuka jeko hulikoko, ito Omaitoka jokila hi mikaka namaya nama luhukidana nama moli-minabo wesida namabetanipomakiya leko hululuka jeko hulikoko, ");
INSERT INTO yby_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","sa-loko lo biye: Omailimo libo gauti monoka bukuguya sa-liki luhuwa ji-minabo maya ne: Nemo numudanemuya Omailoka domuda likikaka numudae loko lonebo maya neboya, edimoya ukelelo wesi halukiki muliguka miniki liki ikaka abo eba maya lolo ikae, loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sakoya monoka numuda napau maya neyoko, domuda likaibo wewenahena ito di dadelo libo wewenahena maya niseyoko, dilipe lalo-talo oko nebo ne. ");
INSERT INTO yby_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sakoya neyoko mudaikiki Omaimitoka jokila hi mikaka we napaki ito monoka monawa api-napi ibikaka wekiya oliwaki nesa lolo ibotoya mudaikiki olinida adoha bekaiyoko, oluho lasomosolasi monoka numuda napau maya miniki opa napa ga liki Dewitida awolada maya epoka loetatune liki nilayoko, elikiki depalo molokaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","aya nilaboya ele-minape liki likayoko, Jisesimamo sa-loko lo biye: Maya wewenasiya nepoka nilaboya eleminoboya, edimoya monoka bukugu ga mako sa-loko nebo maya lepi-minaboya data molokaihe: Emokahoya lokaniyoko, oluho aida amito minabosiya epoka nilae. ");
INSERT INTO yby_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Loko lobetokoko Jelusalemu numuda maya hulikoko Beteni numutokaya lubu jekaiyoko yaloka woko udaiye. 13 Aes 56:7; Jel 7:11 16 Sam 8:2 ");
INSERT INTO yby_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Udikiki unala ipalale yuha lemokiya Jelusalemu numutoka aku niyowedunanaki nodekumuya elokaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","sigolokidana ya mako anulo neyoko mudakoko monau maya woko nedanaki ihilawa jenehe loko mudaiye. Mudaibo maya ailawago neyoko mudakoko aya yamidana maya nosamibo ga loetoko sa-loko lo miye: Emoya oluhoka mako etamoko ohuda lolo oko minataniyo loko nolibo epakiya enemane oko opatiye. ");
INSERT INTO yby_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Opatekaiyoko, lemomasi mudaoko agae loko sa-loko lune: Ya maya nenaha okaiyoko enemane oko opatiye. ");
INSERT INTO yby_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Loko lokuniyoko, Jisesimamo sa-loko lo limiye: Nemoya wehe loko lo libituyo, elilo. Edimoya data lowe kamilo. Elewole iki data kitaboya maya ohuda yaloka elewole ane lolo obomidana iki lolo ikilae. Ito mayagoya minamiye. Edimoya elewole iki eli-miniki bola makomidanaya yowaya bolalae enemane oko babiya oko lemeko nokuya hilitadawo nehao liki litaboya gatipoya ele libekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Omailokaya saina makokumuya wako likili maya eli elewole i-miniki wako litaboya, aha aya nesaya likilae, loko liye. 21 Mat 17:20; 1 Kol 13:2 ");
INSERT INTO yby_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sakokoya monoka numuda napauya yoweko monoka lo beko ne. Sakoya neyoko Omaitoka jokila hi mikaka wehena ito monoka we napahenasiya nisiki Jisesida maya mulunauka hiki sa-liki lae: Emoya aijo maya niseko malo lolo adawo nesaya ekahida galalo sane, ito ekahimamo lokaiyoko sa-onane. ");
INSERT INTO yby_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Liki layoko, Jisesimamo sa-loko lo biye: Nemoya asako ga mako loka olibetatuyo. Edimosiya ada li nimikadeko nemokahoya ekahida galalo sa-okaka nohe lo libituyo. ");
INSERT INTO yby_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Joni maya noku udobetokaka yowanu libo maya nakahauti le soto moloko libo ne. Omaimidana galaloya lihe, ito ma mikauka wewenasida ganipolo liye. Loko loka obetaiyoko, edimonipoloka sa-liki ligi hagi ae: Yaya galoya nenae loko le wili jeko lo metune liki data kebolimoya woko opa napa okaiyoko, sa-liki data ke: Aya yowanuya Omailokati le soto moloko libo ne loko letudawoya, edimoya nenaha iyokoma galaloya eliki emesalo molamae loko lekolainako. ");
INSERT INTO yby_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ito muki wewenasiya Jonidamuya Omai epaloti ga lokaka we liki likaka niabo maya nenako, aya yowanu liboya aha wewenasitoti le soto moloko libo maya nenae loko letudawoya, wewenasiya nenahama lolo ilitatahe loko lomodate wokaiye. ");
INSERT INTO yby_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Liki edimotokaya likiki sa-liki lae: Jonida monawala ma elamune. Liki layoko, Jisesimamo sa-loko lo biye: Sa-ikanako, saina-painahena lolo okaka nobolawa maya ekahida galalo lolo okaka nohe nemokiya lo libamekoloe. ");
INSERT INTO yby_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ga mako sa-loko lo libituyo, elilo. We makoya ipala loweya minaiboya ada ipalada maya sa-loko lo miye: Emo ipanelikaya olotiya woko waeni mijaku maya yowanu lo. ");
INSERT INTO yby_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Loko liyoko, lamekoloe loko lokoko, alikaya uka le wili jekoko woko liye. ");
INSERT INTO yby_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sakoya alika ipalada maya aholamamoya aya agoya lo mekaiyoko, litubo ne lokoko woko yowanu lamoko yogo-yogo jeko ahaya ne. ");
INSERT INTO yby_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ito edimosiya aholada gala maya ekahimamo ele libo ne liki niele. Loko lokaiyoko, ayalo minabo wemasiya ada ipalalimoya ele libo ne liki li me. Liki likayoko, Jisesimamo sa-loko lo biye: Nemoya wehe loko lo libituyo, elilo. Nosamibo nesa liki takisi ehada likaka niabo weki ito anulo monikaka niabo menakipakiya Omaimidana ebalauya omutilibitiki witabo ne. ");
INSERT INTO yby_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jonimamo edimotoka niseko wehe libo anu maya dilipibo mayaki ito monokalamakiya eli hulikabo maya ne. Sakiya eli hulikayoko, nosamibo nesa liki takisi ehada likaka weki ito anulo monikaka niabo menakipakiya nisiki Jonida gala maya eli elewole abolawaya edimoya alo mudai-minabo maya neboya, miluma eliki dukauya li wili jiki monokala eli elewole amabo maya ne. 32 Luk 3:12; Luk 7:29-30 ");
INSERT INTO yby_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Loko lokoko Jisesimamo sa-loko liye: Nemoya koha moloko ga mako letuyo, elilo. We makolimoya mikala napa minokaiyoko malokaya waenigoya yuha oko ayalo maya ohoya heko le wego okoko waeni ihilawa mijeko lilika jitibo ale maya ohekadanaki, ujapa numuda napa-napaya vokoko wewena mako ujapa iki minadeko meinawaya libitunage ahaya ujapa iki liniti-minatae loko wewenalasidaya bekoko wenoka mika makomaloka wiye. ");
INSERT INTO yby_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Woko neyoko, ihilawa halatokaka onawa maya alili okaiyoko, ihilawa mako linitiki nisitae loko uliki wemamo elekele welasidaya leko doli hiye. ");
INSERT INTO yby_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Sakoya doli hiyoko, wiki hetikayoko, mijato ujapa abo wewenasiya dadelo likiki makoya dadelotiya kohae, makoya kohai hele, ito makoya ehadalotiya kohae. Sa-ikayoko elekele we malokasiya wiki uliki wemamidanaya li me. ");
INSERT INTO yby_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sa-ikayoko, elekoko elekele oluholale mukiya doli hekaiyoko wabo maya asaiki kohaidiki doli he. ");
INSERT INTO yby_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sakiya wikayoko, uliki wemamo hulikamoko ipala makoko neboya oli noheko sa-loko ata eliye: Nemo ipane maya oli hekoyoko, uliki wemidana ipala maya nisiyo likiki ilime lalo itayo lokoko oli hiyoko wiye. ");
INSERT INTO yby_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sakoya woko hetokaiyoko, mijato ujapa abo wewenasiya muda-elikiki edimonipo minabotoka sa-liki ligi hagi ae: Maya mika aholamidana ipala maya nenako, alikaya ahola iloho letiboya aya mija maya emokahoya litibo nenako, lemokahoya koha helekuniyoko matoka mikayaki aholada uvaminalakiya lemo nesate lolo etiye. ");
INSERT INTO yby_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Liki likiki waeni mijakuti maya ipisiki huli hetoka molikiki kohai helebo nenako, ");
INSERT INTO yby_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","yamuya waeni mija aholakahoya niseko nenaha obetatibo ne. ");
INSERT INTO yby_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Loko Jisesimamo loka obetokaiyoko, sa-liki li me: Aya wemamo niseko aya wewena lahelamabosida maya kohaido esa etibo nenae. Sakoya aya waeni mija maya aito wewenasida liniti-minatae loko bideko liti-miniki halatetibo onawalo maya ona moliki mija wemidana mitabo ne. Liki likayoko, Jisesimamo sa-loko amida meko lo biye: Monoka bukuguya ga mako sa-loko nebo maya lepi-minaboya data molokaihe: ");
INSERT INTO yby_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Numuda vikaka wewenasiya ehada napa mako mudai hulabolimoya elewole ahoda lolo okoko ne. Aya nesaya we napamidana galaloya soto pekaiye. Wewenalikaya mudauniyoko lomuda heliye. ");
INSERT INTO yby_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yamuya lo libituyo, elilo. Omailimoya maloka wewenasida ujapa obetokaka yowanuya edimo Juda wewenasitotiya hipo oko le aito wewenasida bekolaiye. Sa-okadeko oholamidana ihilawa maya aito wewenasi li soto pikilae.  ");
INSERT INTO yby_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wewena malokasiya aya ehatoya limi jitaboya aya ehadalotiya idimadi iki li esa ikilae. Ito aya ehadalimoya we makomidana mupilalo lemo jitiboya aya wewenama mijeko otele patele ekolaiye loko liye. ");
INSERT INTO yby_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aya koha moloko gaya loko suwokaiyoko, Omaitoka jokila hi mikaka wehena ito Palasisi wehenamasiya elikiki sa-liki lae: Agae, koha moloko libo gautiya ehadamu liboya Jisesida muda huludawomuya lokaiyo liki elikiki, ");
INSERT INTO yby_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","adelo likiki kohatune liki laboya, Jisesidamuya muki wewenasiya Omaimidana epaloti ga lokaka we liki laboma nenako, wewenasiya kohalelikatae liki domodanipo wokaiyoko hulitae. 33 Aes 5:1-2 42 Sam 118:22-23 ");
INSERT INTO yby_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisesimamo akuya amida meko koha moloko ga mako sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Okuluma ebalau yowikaka nesamuya uliki we makolimo saina-painahena oko moloko ibotoya lo moloko letuyo, elilo. Uliki we makolimoya ipalaloya mena lemo molakolo noidanaki nodenesaya ataina oko le lolowa iye. ");
INSERT INTO yby_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sakoya le lolowa noidanaki, elekele welalesida maya doli hekaiyoko, omutoko lesa molaibo wewena maya nisiki nodenesa natae liki wiki li bilo liyoko wiki li be. Sakiya wiki li bebo maya amanapa ikae. ");
INSERT INTO yby_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Amanapa ikayoko, elekele wela maya aku doli nohidanaki sa-loko liye: Nemo lesa molobo wewenasida maya wiki sa-liki li bilo: Nodenesa maya aloya le lolowa oko bulumaka dowa loko napa libolawa maya, ito nodenesa muki maya aloya le lolowa okaiyo, edimoya mena ada okaka nodenesaloya nisilo. ");
INSERT INTO yby_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Loko lokaiyoko elekele welale yuhamasiya wiki aya ga maya li bebo neha, elebolago elikiki osele ikae. Sakiya eli hulikiki maloka maya alo mijanipouka wae. Ito maloka maya yowanunipoloya wae. ");
INSERT INTO yby_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ito malokasiya uliki wemidana elekele welalesida maya dadelo li-miniki kohaidiki dilipi lahelamibo lolo ae. Ito malokasida maya kohaidi hele. ");
INSERT INTO yby_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sa-ikayoko nenako, uliki wemamo elibo maya epauka molokaiyoko, imi wesidaya doli hekaiyoko wiki elekele welalesida kohaidabo wewenasida maya kohaidiki numuda ebanipoya li lahelamibo ikiki wowotiki wauya doli he. ");
INSERT INTO yby_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sa-ikayoko nenako, uliki wemamo elekele welalesida maya sa-loko lo biye: Mena ada okaka nodenesa maya aloya le lolowa okoboya, lesa molobetobo wewenaya nisiki aya nodenesa nataboto kohiki minamae. ");
INSERT INTO yby_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Sa-okaiyo, edimoya anu lasomosolaukaya wiki wewena mako hotula iki maya sa-liki li bikadeko nisiki aya nodenesa maya natanage. ");
INSERT INTO yby_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Loko lo bekaiyoko, elekele welale maya wiki anu lasolauka maya wewena lahelabolawa ito lahelamabolawasida maya hotula ikiki mukiya wowotiki dilipi-liki nisiki nodenesa le lolowa ibo numuku maya waitae. ");
INSERT INTO yby_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Sakiya wavu-liki wewena nisiki minahe lokoko uliki wemamo mudakoloya yowiye. Sakoya yoweko mudaibo maya, we mako mena adalo olo jiki nisikaka upalo nesa maya olo jeko nisamiyoko mudaiye. ");
INSERT INTO yby_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mudakoko uliki wemamo sa-loko lo miye: Iwene yamalae, emoya nenaha iyokoma mena adalo koliki nisikaka niabo nesa maya koloko nisamane. Aito nesa koloko nisekane loko liyoko maya wemamo ga letibo ga minamiyoko, epa limiye. ");
INSERT INTO yby_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sa-iyoko uliki wemamo elekele welalesida maya sa-loko lo biye: Edimoya nisiki ilo adelo nala jikiki liki wiki hekaka lubu jibo anuguya hulitikadeko yaukaya lemeko minoko miluma-aluma eleko epa tala-mitala oko netiye. ");
INSERT INTO yby_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Loko lo bekoko, Jisesimamo sa-loko liye: Omailimoya muki wewenasida lesa moloneboya, maloka wewenasigoya hekaiyoko yowikaka niae. 13 Mat 8:12; Mat 25:30; Luk 13:28 ");
INSERT INTO yby_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Loko lo bekaiyoko, Palasisi wewenasiya wiki sa-liki lae: Ga mako le opa oko letiboto ujapa o-minoko adelo letune liki lowa jiki minadanaki, ");
INSERT INTO yby_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","edimonida minabo yuhauti ito Helotida oluholaleutiya doli hikayoko Jisesima nebotoka wiki sa-liki lae: Tisate yamalae, lemoya monawakaya ele-minune. Emoya gaya wehe loko ihilawagoya lokaka noane. Gaya wehe lokogo ladanaki muki wewenasidaya Omaimidana anulaya wehe loko dilipekaka noane. Muki wewenasida dupamugoya nehekala lukamidana monawalakiya elekoko lo lemekaka noane. Wewena yowiki minabohena ito limiki minabohenakiya makoko aweyaha oko api-napi obetokaka noane. ");
INSERT INTO yby_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sa-oneboya, lemodaya aha lo limitaniyo. Nenae loko noelene, Lomu numutoka uliki we napa uliwa Sisae loko nebo wemidanaya takisi ehada mekaka noudawoya, wehe libo nesa lolo okaka noupe, wehe lamibo nesa lolo okaka noune. ");
INSERT INTO yby_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Liki laboya, bametune loko lideya maya gamaniloka ilime-loko woko obi oetatune, ito betune loko lideyama Juda wewenasiya auha mitae liki data eliki layoko, Jisesimamo ganipomidana monawa maya eliboya lahelamiyoko sa-loko lo biye: Edimoya depa ulumatipo lowe nebolita, nemodaya muluneu hikili nilahe. ");
INSERT INTO yby_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisi ehadautiya mako nilipilo. Loko lokaiyoko ehada mako maya liki nebotoka wae. ");
INSERT INTO yby_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Wikayoko, Jisesimamo pikisa mayaki ito luhuwa mayakiya ekahidama ne. ");
INSERT INTO yby_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Loko loka obetaiyoko, gamani napa Sisada maya ne liki lae. Liki layoko, Jisesimamo gamanimo woka litibo nesala maya gamanimidana milo. Ito Omailimo woka litibo nesala maya Omaimidana milo. ");
INSERT INTO yby_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Loko lokaiyoko nenako, maya wewena maya elikiki topa ikiki agae liki hulikiki wae. ");
INSERT INTO yby_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aya yupekaya Sediyusi wewenaya helenebokutiya sinamitabo ne liki likaka abo wewenauti malokasiya Jisesitoka nisiki mulunau hikili sa-liki loka itae: ");
INSERT INTO yby_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tisate yamalae, Mosesekahoya sa-loko libo ne: We makolimoya oluhola etamoko helekadekoma unalakahoya aya mena ijona maya lekoko yatolatoya oluho etoko uliwa molatiye loko lonebo maya ne. ");
INSERT INTO yby_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sa-loko lonebo nenako, hapaya oluho unamotala 7-pala lemotoka minaboya, ada welimoya mena leko oluho etamoko helekaiyoko, unalakahoya aya mena ijona maya liye. ");
INSERT INTO yby_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Libo maya ayamidanago oko oluho etamoko helekaiyoko, asaikigo aya makoko mena maya li yolalo malo iki oluhonipo etamikigoya 7-pala maya heliki suwae. ");
INSERT INTO yby_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sakiya heliki suwikayoko menanipo maya alikaya heliye. ");
INSERT INTO yby_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Sa-iboya aya 7-pala we maya emo waunagoya minikanako, helebokuti aku sinataboya aya mena maya ekahida menala lolo etibo ne. ");
INSERT INTO yby_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Liki layoko, Jisesimamo donoto leko edimoya monoka bukuguya ga mako mudaki lepi-minaboya, monawa elamiki ito Omaimidana elewoleyala maya mudamanako, eli opa napa ikiki likae. ");
INSERT INTO yby_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Helebo wewena sinatabo onawaloya mena leka ito mena ada oko lemo beka itabo nesa minamiye. Okulumau okananipoki we suda liki ohuda minakilae. ");
INSERT INTO yby_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sa-oneboya, helebo wewenaya aku sinatabokumuya edimo aku loka olibetatuyo. Edimo ga maya Omailimo lo libibo ga maya lepi-minaboya, monawaya elamahe. Hapa yeimaloka mini-liki yowebo wewenamuya sa-loko lonebo ne: ");
INSERT INTO yby_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nemoya Aebalahamule Aesikile Jekopule Omainipo minobo we maya olotiya aha maya minoe, loko libo nenako, alo helebo wewenasida Omainipo neyopakala, weunipo aha nebo wewenasida Omainipo nenako, elewole depa mutiwa ledanaki helebo wewenaki ito aha minabo wewenasidaki Omainipoya ne. ");
INSERT INTO yby_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Loko lokaiyoko, muki wewenasiya emo gala api-napi ibokumuya topa iki agae, dowa loko le welepa jeko lo biye, liki lae. 23 Apo 23:8 24 Dut 25:5 32 Eks 3:6 ");
INSERT INTO yby_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisesima libo galimoya Sediyusi wewena maya depa lemekaiyoko nenako, Palasisi wewenamasiya elikiki Jisesima nebotoka nisiki li esa ikayoko, ");
INSERT INTO yby_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","edimo luwawanipouti ga monalo elekaka noibo we makolimoya Jisesida maya mulunau hekolo sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tisate yamalae, Mosesekaho lo hukoko libo gautiya nakaha galimoya asetoko ne. ");
INSERT INTO yby_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Loko lokaiyoko, Jisesimamo onoto leko sa-loko lo miye: Obohaka ito weuka ito ga elekaka noadawo nesahena mukiya we napa Omailoka molo. ");
INSERT INTO yby_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sa-etadawolimo yoweko napa-napa minakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ito napa apulu oko nebohenakiya makoko aweyaha oko sa-loko ne: Eimokadamu elekaka noadawomidana oko iwekadamu eleko uka mo. ");
INSERT INTO yby_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aya lo hukoko libo gaya loweya Mosesekaho lo molaibo ga ito Omaimidana epaloti ga likaka wesi api-napi abo gamidana madona lolo one loko liye. 37 Dut 6:5 39 Liv 19:18 ");
INSERT INTO yby_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Palasisi wewenahena maya li esa iki minayoko Jisesimamo loka obetoko sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Edimoya Omailimo lahelamibo nesauti dilipitiye loko lo mololibetaibo wemamuya nenae liki niele. Ekahida awola netiye loko loka iyoko, edimomasiya Dewitida awolae. ");
INSERT INTO yby_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Liki likayoko, emomamo sa-loko lo biye: Sa-likima Omai weuna oluholimo nenaha iyokoma Dewitida ilime aila jekaiyoko Dewitikahoya aya wemuya nemo we napane loko liye. Dewitikahoya sa-loko libo ne: ");
INSERT INTO yby_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Yowau welimoya we napanemidana sa-loko lo miye: Nemo nade lamawakalokaya mino-loko woko minadeko emo ulakalo wesidaya le hulo ilauka molobetakoloe. ");
INSERT INTO yby_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dewitikahoya aya wemuya nemo we napane loko libo maya nenako, Omailimoya lahelamibo nesauti lilimitiye loko lo mololetaibo weya nenaha idekoma Dewitida awolago lolo etiye. ");
INSERT INTO yby_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dewitida awola neboya Dewitida we napalakiya netibo ne. Loko liyoko Jisesima liboto onoto liki litabo nesa lamibo ne. Edimoya aya onawaloya ga mako loka itatabo nesamu eleyoko eda delokaiyoko nenako, yowiki mulunau hiki loka itatabo nesa lamibo ne. 44 Sam 110:1 ");
INSERT INTO yby_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisesima lasolasi nedanaki unala ipalale yuha lemoki ito muki wewenamakiya ga sa-loko lo limiye: ");
INSERT INTO yby_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Edimo monoka monawa api-napi ibikaka weki ito Palasisi wekiya Moseseda adakolila li olo jikiki li molabo gautigoya api-napi ikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sa-niadanaki gaya muki li libikaka niae. Sa-ikaka niayo, ga maya elikikima aya galoya muki emeke molalo. Sa-oneboya, edimo iki moliki niabomidana monawaya samilo. Edimoya muki gaya likaka niaboya aya gamidana emesalo molamae. ");
INSERT INTO yby_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Li molabo gaya edawaki okaiyoko aito wewenasida li molibitikayoko, edimonidaya edawaki nesa maya dadedunu dilipi wati ibitikiki ma lamae. ");
INSERT INTO yby_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Muki nesa lolo ikaka niaboya wewenasi muda-lelatae likigo lolo ikaka niae. Monoka luhuwa maya bokisi lasolasi makomauya molikiki otipanipoloya moliki nala jikaka niae. Ito dadeloya asaikiya nala jikaka niae. Ito dupalo nesaloya onowelaki nesa hanaya oto iki olo jikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sa-ikikiya nodenesa napa ataina abotokaya epalo nebo siyalo minatabokumu dumu helekaka noiye. Ito monoka numuku numukuya epalo muki wewenasida dowisalo nebo siyamugoya delokaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ito wewenasiya maketilokaya lepoka liki tisatemae liki litae liki dumu helekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Sa-oneboya, wewenasiya edimodamuya tisae liki likili nidekoma eli bamilo. Omai makokoya tisatipo neyoko edimoya aha oluhola miniki makoko aweyaha ikigoya minae. ");
INSERT INTO yby_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Maya mikaukaya wewena makomuya ahoteyae liki lamilo. Ahotipo makoko okulumauya ne. ");
INSERT INTO yby_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ito edimokumuya duliki we liki likatae loko noloe. Edimo we napatipo Omailimo lahelamibo nesauti dilimitiye loko lo mololibetaibo we makoko nemoya minoe. ");
INSERT INTO yby_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Edimo we napatipoya ahaya lemeko elekele olibetoko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Edimokuti we makolimo eimola uliwa le sinatiboya uliwaya lemekolaiye. Ito we makolimo eimola uliwa leko lemeko molatiboya Omailimoya uliwa le napa oetakolaiye. 5 Mat 6:1; Dut 6:8; Nam 15:38 10 Mat 20:26-27; Mak 9:35 10 Mak 10:43-44; Luk 22:26 12 Luk 14:11; Luk 18:14 ");
INSERT INTO yby_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Edimo Palasisi wewenahena ito monoka monawa api-napi ibikaka niabo wewenalitaya ehetipoe. Edimo depa ulumatipo lowe nebosiya Omaimidana ebalau wikaka anu maya wewenasida dowisalo hiki li libitikaka niae. Edimotipoya ayauya yowamae. Ito wewena malokasiya yowikili niayokoma aha yatoka yowikatae liki mudai hulikamae.  ");
INSERT INTO yby_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Edimo monoka monawamu api-napi ibikaka weki ito Palasisi wewenalitaya, ehetipoe. Edimosiya ijona menakipasida uvaminanipo ukele lika ito depaloti suwa liki Omaimidana epoka hana likaka nianako, alikaya lihima napa likilae. ");
INSERT INTO yby_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Edimo monoka monawa api-napi ibikaka weki Palasisi wekiya depa ulumawatipo lowe nebolitaya, ehetipoe. Edimoya ela nokuka nebo mikauka neboya moniki maloka wewenasidaya oluhotipole lolo itae liki dilipi molikaka niae. Sa-ikayoko, oluhotipole lolo abo maya edimokidana dilipi miluma anugu molikayoko, aya wewenasiya edimoda asibitiki jomidana wewenala lolo ikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Edimo dukamidana omudala likonebo weya wewenasida anu dilipikili niabo wewenalitaya, ehetipoe. Edimoya sa-liki likaka niabo ne: Edimokutiya we makolimo monoka numuda napamidana uli loko adeya le sinoko okepalo moloko letiboya, woko aha nesa lolo etiboya aha nesa yatoka neboya, makomalimoya monoka numuku goli ehadamidana uli loko ade le sinoko letiboya wehe loko lekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Edimoya nei nai dukamidana omudala likaibolitaya, nenaha maya yoweko ne. Goli ehadaya yoweko nehe, ito monoka numudalimo goli ehadamidana le eto okaka nesalimoya yoweko ne. ");
INSERT INTO yby_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Edimoya sa-liki likaka niabo ne: Wewena makolimoya Omaitoka jokila hi mikaka niabo namabetalo netibo nesamidana uliwa loko ade yoweko letiboya no wetiboya aha nesa yatoka neboya, ito mupilalo netibo nesamuya uliwa loko ade yowitiboya elewole nesa nenako, aya nesa maya lolo ekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Edimoya dukamidana omudala likaibolitaya, jokila hi mikaka nesalimoya yoweko nehe, ito jokila le eto oko molokaka namabetalimoya yoweko netiye. ");
INSERT INTO yby_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yamuya wewena makolimoya jokila hi mikaka namabetamidana uliwa loko ade yoweko letiboya, namabeta mupilalo nebo nesakiya uliwa loko ade yoweko letibo nesa ilekaiye. ");
INSERT INTO yby_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ito wewena makolimoya monoka numuda napamidana uliwa loko ade yoweko letiboya, numudaki ito monoka numuku minoko leko okaka noibo Omaikiya uliwa loko ade yoweko libo ilekaiye. ");
INSERT INTO yby_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wewena makolimoya okulumamidana uli loko ade yoweko letiboya, Omai minokaka noibo sipamaki ito aya sipalo minokaka noibo Omaimidanakiya uli loko ade yowibo ilekaiye. ");
INSERT INTO yby_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Edimo monoka monawa api-napi ibikaka weki ito Palasisi welitaya, ehetipoe. Edimo depa ulumatipo lowe nebolitaya muki mijaku nodenesahenaya lepiki 10-10 nebokutiya makoko makoko iki liki wiki Omaimidanae liki mikaka niae. Sa-ikaka niaboya, lo hukoko libo gauti yoweko nebolawa napawaya li wehe liki makoko aweyaha iki ona molikaka, ito duka hi bikaka, ito eli elewole ikaka nesa maya muki hulikae. Saina 10-10 nebokuti lepiki makoko makoko iki Omaimidana mikaka nesa maya hulikaka nesa minamiboya, maya nolobo nesa napakiya aha lolo okaka nesaya ne. ");
INSERT INTO yby_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Edimo dukamidana omudala likonebolitaya, wewenasida anu dilopikili niaboya, saina lasolasi mako duka le opa amokaka noibo nesaya aka iki li hulikiki duka le opa okaka nesa napaya aha opa napaya niki mikili ikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Edimo li hukabo ga api-napi ikaka niabo weki ito Palasisi welitakiya, ehetipoe. Edimoya depa ulumawatipo lowe neyoko no odaki ito lapekiya hetoka nokalawe ikaka niaboya, dukauya ukele nesa ito dupamo muda lahelibo nesaya odatipouya jiki waitikaka niae. ");
INSERT INTO yby_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Palasisi wewena dukamidana omudala likonebolalita, dukamidana nokalawe iki li uluwitikadeko dupa hetokaki makoko aweyaha oko uluwitekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Edimo monoka monawa api-napi ibikaka weki ito Palasisi welitaya, ehetipoe. Depa ulumawatipoya lowe neyoko aya lowe likaka niae. Edimoya ono molikaka abatoya wewenasi muda-eladeko dowa letiye liki uhiya hilikaka niabo nesa likiya minae. Hetokaya mudai lalo ikaka niaboya, ulau helebo wewenasida abuhanipoya nedanaki nuwama wokaka nesaya ayauya waitone. ");
INSERT INTO yby_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sa-okaka onebo nesa liki edimokiya asaikiya minae. Wewenasiya aya dupa hekakawaya mudaikikiya wehe li-minabo wewena minae liki likaka niaha, dukauya suwa galimo ito li hukabo gamidana pelesa jekaka nesalimoya waitone. 22 Aes 66:1; Mat 5:34 23 Liv 27:30 27 Apo 23:3 ");
INSERT INTO yby_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Edimo monoka monawa api-napi ibikaka weki ito Palasisi welitaya, ehetipoe. Edimoya depa ulumawatipo lowe nebolitaya, Omaimidana epaloti ga likaka wesida ono molikaka ebanipo wehe liki lolo ikadanaki, wehe liki mini-liki nisebo wesida ono molikaka ebaya onowe lalo nesanipo li kolibitikiki, sa-liki likaka niae: ");
INSERT INTO yby_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Lemo latatelesida onawanipoloya minatidanako, Omaimidana epaloti ga likaka wewena mako kohaidi helebo wewenasidaya dilipe wati ametine. ");
INSERT INTO yby_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Liki yaya gaya li soto molikaka niaboya, edimo monawatipomuya likaka niae. Edimoya Omaimidana epaloti ga likaka wesida kohaidi helebo wewenasida oluhonipole yuha maya minae. ");
INSERT INTO yby_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Latatipolesida lahelamibo monawanipo maya edimotoya woko lekaiye. ");
INSERT INTO yby_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Edimoya jamidana oluholalitaya Omaimidana obilalimoya dilipe joku molakolaiye. Sa-etiboya edimoya mako eke liki oli wamikilae. ");
INSERT INTO yby_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yamuya elilo. Nemoya Omaimidana epaloti ga likaka weki ito monoka monawa eli wehe likaka weki ito monoka elikaka niabo wewenakiya doli hekoyoko edimotoka wikilae. Sakoyoko, edimosiya luwawanipoutiya malokasidaya kohaidi helikiki ito malokasidaya nalawa iki yoho yaha yalo tikiki ito malokasidaya monoka numudanipouya seida oijoloti kohaidiki eba napa makomautiya deni jiki liki wiki huli makomaukaya molakilae. ");
INSERT INTO yby_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sa-ikadeko, wehe liki minabo wewenaya mikauka minayoko kohaidi helebomidana lihimawala maya edimotoka minakolaiye. Aebolo maya wehe loko nebo we maya yatolakaho koha heliyoko oladala kisibo onawaloti maya maloka wewenasida kohaidi heliliki niwayoko, oladanipo kisiyoko Baelakida ipala Jekolaeya maya monoka numuda napaki ito Omaito jokila hi mikaka namabetakiya luwaku neyoko kohaikayoko oladala kisibomidana lihimanipo mukiya mupilatipolo yowekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Edimoya wehe loko lo noliboe. Yamidana monawamidana lihimala maya oloti maya oko moloko nobo nesa mudaikaka niabo wewenasida mupilanipoloya yoweko minakolaiye. 33 Mat 3:7; Mat 12:34; Luk 3:7 35 Jen 4:8; 2 Klo 24:20-21 ");
INSERT INTO yby_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Eke, Jelusalemu wewenalitaya, edimoya Omaimidana epaloti ga likaka wewenasida ito Omailimo yowanulo leko doli hiyoko edimotoka nisebo wewenasida kohaidi heliki ito ehadalotiya huli moliki kohaidi helikaka niae. Nemoya edimodaya okolelimo oluholalesida dilipe okanauka molokaka noibomidana oko muki yupeka edimodaya dilipe namaikuka molakolo okaka noboya, edimoya eli nemamae. ");
INSERT INTO yby_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sa-ikaka niayo, elilo. Omailimoya dilipe hulikadeko ebatipo ame numudamidana minakilae. ");
INSERT INTO yby_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sa-ekolaiyoko, maya lo noliboe. Nemodaya aku muda-nelamiki mini-liki wiki alikaya sa-liki li nimitae: We napamidana galalo maya soto pekane. Omailimoya maku emekaiye liki litae, loko liye. 39 Sam 118: 26 ");
INSERT INTO yby_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisesima monoka numuda napa maya hulikoko nowiyoko unala ipalale yuha lemosiya monoka numuda napa maya ilopikiliya amaitoka nisune. ");
INSERT INTO yby_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sakoya nonisuniyoko, sa-loko lo limiye: Edimoya muki numuda maya mudai-minahe. Agae, nemoya wehe loko lo libituyo, elilo. Monoka numudamidana ehadawaya muki posikiki leda jiki hulikadeko, mupilalo mupilalo iki moli-liki yowebokutiya, jeko hululuka jeko lemeko suwekolaiye. Sa-okadeko, jiki lana mina ikiki li hutili iki hulakilae. ");
INSERT INTO yby_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Loko lokoko Jisesima Oliwi bolau maya yoweko neyoko, unala ipalale yuha maya emogo minabotoka yowekoko loka otoko sa-loko lune: Emoya lo lemo. Oloti nesamuya ladawoya nena yupekama soto pitiye. Ito mikauka nesa suwetibo onawa ito emoya aku le wili jeko nisekoladakoma nena anema mudakoko onawaka maya alili iye loko yalotiya mudako eletune. ");
INSERT INTO yby_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Loko loka otuniyoko, Jisesima lonoto leko sa-loko liye: Ehe, ujapa ilo. We makolimoya dokepa jekatiyo. ");
INSERT INTO yby_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wavu-liki wewenasiya nemo nulinelo nisikiki Omailimo lahelamibo nesauti dilimitiye loko lo mololibetaibo we maya minune liki dokepa jiki litabo ne. ");
INSERT INTO yby_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Edimoya aito aito lowamidana onowaya elikiki ito lowa hikilae liki lideko gala maya elikilae. Sa-itaboya, edimo ehetipoe. Sakiya sa-ideyama mulutipouti hugili amideyo. ");
INSERT INTO yby_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","8","Yatokamidana nesa soto pitiboya, muki nesa suwetibo onawaya owaha ne. Numuto namato wesiya ulanipolo wesida lowa hi nibidekoma, numuto namato duliki we napa makomidana wewenalaki ito makomidana wewenalakiya lowa hikilae. Ito aito aito mikaukaya nodekumu helitabo onawa maya mino-loko yowideko muki mikaukaya mima napa-napa noideko, miluma nesa soto nopideko, menasi oluho etakili miluma elikaka niabomidana oko soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Sakiya ya onawaloya dadelo likiki miluma elitabo obiya ilibitakilae. Sakikiya edimokuti maloka wewenasida maya kohaidi helikilae. Nemo nuline maya edimotoka nebokumuye liki mesaha jilibitakilae. ");
INSERT INTO yby_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sa-ideko, aya onawaloya muki wewenasiya eli elewole ikaka niabo nesa maya hulakilae. Sakoya makomalimoya makomamidana mimi ideko makomamidana mimi ideko yautiya emo olisa lekani emo olisa lekani likilae. ");
INSERT INTO yby_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Sa-nideko muki suwa omaimidana epaloti ga likaka we maya nisikiki muki wewenasida maya suwaki namaki li bikilae. ");
INSERT INTO yby_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sakoya lahelamibo nesalimoya hutili noideko, muki wewena maya duka Omailoka molikaka nesa maya lepa hekoliye. ");
INSERT INTO yby_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wewena mako onawanipo suwetibotoya monoka hulamiki elewole iki li-minatabo wewena maya Omailimoya dilipekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ito Omai oholamidana gala laloya ma mika okana maloka maloka muki numuto namato wewenasi elikiki emesalo molatahe liki wetome iki suwikilae. Sa-ikadeko onawa maya suwekolaiye. 9 Mat 10:22 13 Mat 10:22 ");
INSERT INTO yby_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Edimoya omusepatipo yoweko lahelametibo nesalimoya eba le lahelametibo nesamuya hapaya Omaimidana epaloti ga lokaka we Deniyolokahoya libo nesalimoya eto onebo numukuya sinonedeko mudakilae. Maya aya lepitadawo wewenalikaya le madokauya molo. ");
INSERT INTO yby_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Sa-ideko aya onawaloya Judiya mikauka minatabo wewenalitaya oli li bolaukagoya yowitanage. ");
INSERT INTO yby_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ito wewena mako hetoka liwanaukaya limiki minatabototiya aku li numukuka yowiki uvaminanipoya lamitanage. ");
INSERT INTO yby_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ito wewena malokaya mijakuka nimonitabototiya lupalo kolatudawo nesatemae liki nisiki ma numukutiya lamitanage. ");
INSERT INTO yby_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kee, oluhonipoki minatabo menakipa ito oluhonipo aida amida ninatabo menakipasiya, nenaha itahelae. ");
INSERT INTO yby_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Edimoya nolobo nesaya go jitibo onawalohe ito holi onawalohe oli etudawo onawaya soto pametiye liki Omailokaya likigo minalo. ");
INSERT INTO yby_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ya onawaloya edawaki nesa soto pitiboya maya mikaya ohatamalo nebotoya, yamidana nesa soto pamiyoko mino-loko yoweko oloti onawaloya soto pamiye. Sa-iboya oloti maya nolobo onawaloya soto pekoko alika aku soto pamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sa-oneboya, Omailimoya aya onawaya le minawa ametiboya muki wewenaya domuda lamikilanako, Omailimo dilipe eto ibo wewenamuye loko aya onawa le minawa ekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ya onawaloya wewena makolimoya mudalo, lahelamibo nesauti lilimitiye loko lo mololetaibo we maya ya ebatoka maya ne, ito ma ebatoka maya ne loko nolideko elikikima emesalo molamilo. ");
INSERT INTO yby_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ya onawaloya suwaki namaki loko lahelamibo nesauti lilimitiye loko lo mololetaibo wekidana nisikilae, ito suwa omaimidana epaloti ga likaka we soto pikiki wewenasi lepoka litae liki suwa ganehena lolo iki Omailimo dilipe eto onebo wewenasida maya dokepa jetune liki aha yatoka aweyaha itabo ne. ");
INSERT INTO yby_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Elilo, aya nesahenaya owaha soto pamiyoko maya gaya lo noliboe. ");
INSERT INTO yby_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ito wewena malokasiya Omailimo lahelamibo nesauti dilimitiye loko lo mololibetaibo we maya niseko ya ebatokama ne liki litabotoko wamilo. Ito mudalo, aya we maya yowaya numukuya halukone liki lidekoma, edimoya demesalo molamilo. ");
INSERT INTO yby_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Okulumaloya go pana kitiboya ho noyowibokutiya yowekoko ho nolimibokuya lemekolaiye. Okulumauti we uti nemoya yamidana oko nonisoyoko edimo mukisiya mudaneli suwikilae. ");
INSERT INTO yby_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wewena helebo onawaloya nama osuwehaya enemane iki nisiki limi esa ikilae. Ayamidana oko ma mikauka wewenasida dukauya nuwama nesalimo waitetibo onawaloya enemane iki obi ikilae. 15 Den 9:27; Den 11:31; Den 12:11 17 Luk 17:31 21 Den 12:1; Lev 7:14 26 Luk 17:23-24 28 Luk 17:37 ");
INSERT INTO yby_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Aya onawaloya edawaki nesaya suwokadeko, ho maya yowekoko enemane oko lubu nojideko, ukada maya lameda lamideko, sonohi maya ululutiki limi nijidekoya, okulumaloti elewole nesahena mukiya momoga iki suwikilae. ");
INSERT INTO yby_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sa-ikadeko, okulumauti we uti nemo ane maya okulumalo soto nopideko, mikauka wewena mukiya wavu-liki wije nama ikilae. Sa-nideko okulumauti we uti nemoya elewoleyaneki ito lamedanekiya okuluma ijopa mupilaloya lemoyoko muda-nelakilae. ");
INSERT INTO yby_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Okananipoki wesida maya doli hekoyoko, pikuli maya huhu nilideko, onowa napa nomoladekoya, Omailimo dilipe eto ibo wewena okana malokati malokati ho noyowibotokati ho nolimibotokatiya dilipi nupa ikilae. 29 Aes 13:10; Joe 2:10,31; Joe 3:15; Lev 6:12-13; Iji 32:7; Aes 34:4 30 Den 7:13; Lev 1:7 ");
INSERT INTO yby_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Edimoya sigolokidana yalo koha moloko libo ga maya eli wehe liki elilo. Yamidana akawau nouvala wavu-leko minokoko aila uluma siliyoko mudaikiki howai onawa maya aloya alili okaiye liki likaka niae. ");
INSERT INTO yby_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sa-ikaka nianako, asaiki maya nolobo nesaya soto nopideko mudaikikima we napate maya nisekolo ateto sinone liki lilo. ");
INSERT INTO yby_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nemoya wehe loko lo libituyo, elilo. Oloti maya onawalo minabo wewenaya heliki suwamideko muki nolobo nesahenaya soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mikaki ito okulumakiya wiki suwisaibo neha, nemo ganeya woko aha nesa lolo oko suwamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Sa-oneboya, aya onawamuya wewena malokasiya elamae. Okulumauya okananipoki weyaki aya onawamuya ma elamae. Nemo Omaimidana ipalakiya ma elamoe. Ahone makoko eimolago elene. ");
INSERT INTO yby_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Okulumauti we uti nemo onawaneya alili noidekoma, Nowada onawalo lolo abo nesa liki lolo ikilae. ");
INSERT INTO yby_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hapa yeikalaya no napaya owaha ilamiyoko, ya onawaloya ataina napa-napa adanaki, mena bi yolalo malo iki yogo-yogo jiki minayoko, Nowa maya noku lapeuya menakipa oluholalekiya yowe. ");
INSERT INTO yby_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Aya wewenamasiya Nowada gala may elamiki minayoko, no napaya ilekoko niseko muki wewenasida maya nolimo kohaido esa iye. Sa-ibo nenako, okulumauti we uti nemo nisitubo onawaloya muki wewenasiya asaiki sa-ikilae. ");
INSERT INTO yby_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aya onawaloya we loweya mijaku yowanu nilisaibototiya, makomalamidana ilimekoko makomalamidanaya huloetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mena lowema nodenesa koha jisaibototiya, Omailimo makomalaya ilimekoko makomalamidanaya huloetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Sa-onenako, we napatipoya nisitibo onawaya edimo ma elamayo, edimoya ujapa lalo nesa iki minalo. ");
INSERT INTO yby_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Edimo maya aya elilo. Numuda aholalimoya ukelelo we nisitibo onawamuya elenetiboya, ujapa o-minadeko ukelelo welimoya niseko numudala hukoko uvaminala lametibo ne. ");
INSERT INTO yby_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sa-onenako, nemo okulumauti we uti nisitubokumuya newa iki minamitabo onawaloya nisitubo nenage, edimoya li lolowa iki minalo. 37 Jen 6:5-8 39 Jen 7:6-24 43 Luk 12:39-40 ");
INSERT INTO yby_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Elekele oluho makolimoya ele wehe lonetibo ito yowanu le emesalo moloko leko netibo weya ujapa welalimoya eimola numudalauya ujapa oko minoko yowanulo we malokasida nodenesa natabo onawaloya ona moloko bitibo wemidana monawala lo libituyo. ");
INSERT INTO yby_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ujapa we maya nisekoko aya elekele oluhomidana omutoko lotaibomidana oko yowanu nolideko mudakokoma, aya elekele oluhomuya elideko lahelepa etibo ne. ");
INSERT INTO yby_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sa-onebo nenako, nemoya wehe loko lo libituyo, elilo. Ujapa wemamoya sakoya ujapa lalo ibo wemidanaya muki nesaloya ujapa we lolo oetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sa-oneboya, aya oluhoya elekele oluho lahelamibo netiboya, nemo ujapa wene maya enemane oko nisamekolaiye loko madonauka elekoko, ");
INSERT INTO yby_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","yowanulo we malokasidaya kohaidoko nodenesa ataina oko noko ito ekesa nolo we malokakiya magoinaya miniki sipaki no niki minatabo ne. ");
INSERT INTO yby_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sakiya minadeko, aya oluhomidana ujapa wemamo aya oluho maya ewa oko minametibo onawaloyahe, ito ujapa oko elametibo onawaloya nisekoko, ");
INSERT INTO yby_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","aya elekele oluho maya upala kohaowe hukowe oko suwa likaka we depa uluma lowe nebo we minabokuya ilime molakolaiye. Sa-ideko yaukaya woko minoko miluma-aluma eleko epa tala-mitala oko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Aya onawaloya okulumamidana oholau yowitabo nesa leko yaha mena 10-palakidanaya minakilae. Mena olilo wemamo niseko le welo menalo noiyoko, yaha mena 10-palasiya lamu joya lepa okoko woko anulotiya ilime-loko nisetune liki wae. ");
INSERT INTO yby_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sabokutiya yaha mena maloka 5-palaya nei menaya minanako, ito 5-pala malokaya data golotonebo menakipaya minae. ");
INSERT INTO yby_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sa-inakoya, nei mena 5-palamasiya lamu nowa maya kisiki lamiki lamunidagoya liki lepa iki liki wae. ");
INSERT INTO yby_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Sayoko dataki menakipasiya liwe no maya kisiki odau maya li-miniki lamunida maya lepa iki liki wae. ");
INSERT INTO yby_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Saboya aya mena olilo we maya enemane oko nisamiyoko nenako, aya yaha menakipa maya domuda hihi okaiyoko udi-minae. ");
INSERT INTO yby_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Sakiya udiminayoko, lubuka udo wili jedawolawa maya ju mako sa-liki lae: Mena olilo we maya aloya nisekaiyo. Edimoya wiki anulotiya ilimi-liki nisitayo, wilo. ");
INSERT INTO yby_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Likayoko, maya yaha menakipa maya sinikiki lamu jonida lehonahowa maya pu liki li hulikiki lepa ae. ");
INSERT INTO yby_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sakiya lepa ayoko, maya nei menakipasida lamugu nonipo maya suwokaiyoko, dataki menakipasida maya sa-liki lae: Edimoya liwe notipoya ma kisiki limilowo. Lemo lamuteu maya nowa suwokoko hekolo noiyo. ");
INSERT INTO yby_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Liki laha, maya dataki menakipamasiya edimo wiki situwaukatiya meina hilo, liki lae. Edimotokaki lemotokakiya woko kohametibo nesa lekaiyo. ");
INSERT INTO yby_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Liki layoko, aya nei menakipa maya situwauka no maya meina hikili wikayoko, mena olilo we maya niseko hetiye. Sa-okaiyoko, edimo li lolowa iki minabo menakipamakiya yowiki numuku maya mena adalo nodenesa maya magoinaya nae. Sakikiya anu maya viki etoha ae. ");
INSERT INTO yby_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Sakikiya minayoko, maloka nei menakipa maya nisikiki sa-liki lae: We napate yamalae, we napate yamalae, anuya siyeletowo. ");
INSERT INTO yby_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Liki layoko, aya wemamo sa-loko lo biye: Nemoya gaya lo libituyo, elilo. Edimoya ma mudaidamobo menakipa minayo, wilo. ");
INSERT INTO yby_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Lokoya liye lokoko, Jisesimamo esewau leko sa-loko liye: Sa-onebo nenako, edimoya nemo nisitubo onawamuya elamayo, li lolowa iki ujapa ikiya minalo. 1 Luk 12:35 12 Luk 13:25 ");
INSERT INTO yby_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sa-one. We makolimoya wenoka wekolo noidanaki, emo elekele welalesida maya ju liyoko nisikayoko, emo nesalahena mukiya ujapa initatae loko dadeuya molaiye. ");
INSERT INTO yby_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Emola elekele oluholalesidaya monawanipohena ito elekelewanipohena maya mudaonedanaki ayamidana oko makoko aweyaha oko ehadala maya ona moloko biye. Sakoya we makomidanaya 5000 kinaya miye. We makoya 2000 kinaya miye. Ito makomidanaya 1000 kinaya miye. Sakokoya anu hana wenokaya wiye. ");
INSERT INTO yby_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sa-okaiyoko maya ehada 5000 kina mibo wemamoya woko bisinisiya lolo oko weunawa asako 5000 kinaya liye. ");
INSERT INTO yby_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ito we mako 2000 kina mibo wemamoya asako woko bisinisi lolo oko weunawa 2000 kinaya liye. ");
INSERT INTO yby_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ito 1000 kina libo wemamo uliki wemidana ehadala maya leko woko mikauya ale ohekoko ale li jiye. ");
INSERT INTO yby_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Sakoya onawa hana wokaiyoko, elekele wesida uliki wenipo maya nisiye. Sakoya nisekoko hapa ona moloko bibo ehada maya li wehe litae loko elekele welalesida maya ju lo biye. ");
INSERT INTO yby_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sa-lokaiyoko, 5,000 kina libo wemamo niseko sa-loko liye: Ulikaki we yamalae, mudao. Emokaho 5000 kina nemedawoma nenako, yaloti maya leko woko bisinisiya lolo oko weunawa 5000 kinaya le kolokoko leko maya nonisoe. ");
INSERT INTO yby_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Loko lokaiyoko, uliki welamamo sa-loko lo miye: Emoya elekele wene lalo minane. Emoya wati oko yowanuya ujapa ane. Yowanu lasolalo maya wati oko ujapa okaninako, muki nesaya emekoyoko ujapa etane. Sa-okaniyo, emoya niseko uliki weka nemokiya olite hideko elowa elowa jeko minasiye. ");
INSERT INTO yby_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Loko lo mekaiyoko, 2000 kina libo wemamoya niseko, ulikaki wene yamalae, emoya 2000 kina maya nemekaniyoko leko woko bisinisiya lolo oko aku weunawa 2000 kinaya le kolokoko leko maya nonisoe, loko lo miye. ");
INSERT INTO yby_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Loko liyoko, uliki welamamo emoya elekele wene lalo minane loko lo miye. Emoya wati oko yowanu lasolalo maya ujapa okaniyo, sadawotoya muki nesaya emekoyoko ujapa etane, lokoko sadawotoya emoya niseko uliki wekakiya elowa jeko mino, loko lo miye. ");
INSERT INTO yby_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Loko lo mekaiyoko, 1000 kina mibo wemamo niseko sa-loko lo miye: Uliki wene yamalae, emoya monawakaya alo ele-minoe. Emoya adoha we maya minane. Wewenasiya mida numudaya li kolikayoko emokahoya mida numudaya lekaka noane. Ito wewena makosiya yowanu liki ihila nesa li soto molaboya emokaho lekaka noane. ");
INSERT INTO yby_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sa-okaka noadawokumuya nomodane wokaiyoko, aya 1000 kina maya leko woko mikauya ale li jeminobo ne. Sa-ominobototi maya leko nonisoyo, emo nesaka maya neyo, le molo. ");
INSERT INTO yby_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Loko liyoko, uliki welamamo libo galoya sa-loko onoto liye: Emoya osele-pasele yowanulo weya minane. Emokahoya nemo monawane maya ele-minane. Wewena makolimo mijaku nodenesa yuha onetibo maya leko asutokaka noe. Ito wewena makolimoya ihila nesa tili okaiyoko o molokaiyoko maya ihila nesaya lekaka noe. ");
INSERT INTO yby_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Sa-okaka nenako, nemo ehadane maya ehada molikaka numuku maya leko woko molatadawoya nenaha iye. Sa-ideko aya ehatoya amida miki nimoladeko niseko litubo neboya. ");
INSERT INTO yby_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Sa-okaniyo, emotokatiya hipo ikikiya 10,000 kina lenebo wemidana maya milo. ");
INSERT INTO yby_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Elilo, wewenasi nesa li-miniki maya ujapa lalo nesa iki li-minataboya akuya amida meko libekoloe. Sa-oneboya, we makolimoya lasolasi nesa mako le-minoko maya ujapa lalo nesa ametiboya aha nesa yatoka le-minohe loko ata elitiboya aku hipo ekoloe. ");
INSERT INTO yby_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ito aya osele ibo yowanulo wemidana maya oli he hulo lubu jibo ebakuka ikadeko yauka maya lemeko minoko miluma-aluma eleko epaya tala-mitala oko minakolaiye, loko lo biye. 29 Mat 13:12; Mak 4:25; Luk 8:18 30 Mat 8:12; Mat 22:13; Luk 13:28 ");
INSERT INTO yby_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Okulumauti we uti nemoya lamedanekiya minoko okananipoki wenelekiya onowelaki siyalo maya minakoloe. ");
INSERT INTO yby_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sakoya minoyoko edimo maya mikau wewenaya mukiya nisiki nowisalokaya li esa ikilae. Sa-nidekoya nemoya wewenasida ona moloko le lowetekoloe. Ja ujapalo wemoya meme jalaya dilipe aito moloko sipisipi jala dilipe aito molokaka noibomidanaya, ");
INSERT INTO yby_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","nemo sipisipi janesida maya dilipe nade lamawakaloka moloko meme ja maya dilipe atahakaloka molakoloe loko liye. ");
INSERT INTO yby_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Sakokoya nuliki we minobo maya nade lamawakaloka minatabo wewenasida maya sa-loko lo bekoloe: Ahonekaho maku bitibo wewenae, liki lilo. ");
INSERT INTO yby_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nemoya nodekumu noheloyoko nodenesa nimikaka abomae. Ito nomuya nonelaiyoko noya hiki nimikaka abomae. Ito wenoka wewena lolo okoko nonisoyoko nilimi numudatipou molikaka abomae. ");
INSERT INTO yby_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ito nupalo hitokaka nesa minamiyoko nupalo hitokaka nesa nimikaka abomae. Saina nelokaiyoko minoyokoma edimoya nisiki jonano initikaka abomae. Nala numuku minoyoko edimolitaya nisiki muda-nelikaka abomae. Sa-ikaka abo maya nenako, hapaya mika maya api oko le soto molakolo Omailimo ujapa olibetatibo nesamidana le lolowa ibomidana iki lilo. ");
INSERT INTO yby_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Loko lo bekoyoko, wehe liki minabo wewenasiya sa-liki li nimikilae: We napate yamalae, emoya nena yupekama nodekumu noelaiyoko muda-elokoko nodenesa imudawo ne, ito nena yupekama nokamu noelaiyoko, muda-elokoko, noya heko leko niseko imudawo ne. ");
INSERT INTO yby_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ito nena yupekama wenoka wewena lolo okoko noniseniyoko muda-elokoko ilime numudateu moludawo ne. ");
INSERT INTO yby_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ito nena yupekama upalo kolokaka nesaka minamiyoko imudawo ne. Ito nena yupekama saina elokaiyoko woko muda-eludawo ne. Ito nena yupekama nala numuku minaniyoko woko muda-eludawo ne. ");
INSERT INTO yby_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Likiya likadeko, nemo nuliki welikaya sa-loko lo bekoloe: Nemoya wehe loko lo libituyo, eli-minalo: Nemo nulinelo emesalo molabo wewenasida lolo obetupe liki lolo ibitabo maya nemoda lolo initabo ilekaiye. ");
INSERT INTO yby_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Loko lo nobeko, nade atahakaloka minatabo wewenasida maya sa-loko lo bekoloe: Omaimidana auhalalo minabo wewenalitaya, ");
INSERT INTO yby_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","nemoya nodekumu heleko minoyokoya, nodenesa mako huli nemamabo ne. Ito nomu nelaibo maya noya himi nemamabo ne. ");
INSERT INTO yby_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nemoya wenoka wewena lolo okoko nonisobo maya edimo nilimi numudatipou molamabo ne. Ito nala numukuhena ito saina nelokaiyoko minobo maya ma nisiki mudanelamabo nenako, joya hamibomidana lowa lowa oko letibo jokuya Olohamaki ito muki okanaki welalemakiya ahonekaho le lolowa olibetonebo joku maya wiki minalo. ");
INSERT INTO yby_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Loko lo bekoyoko, edimosiya sa-liki li nimikilae: We napate yamalae, emoya nena yupekama nodekumu heleko noniseniyoko, ito nena yupekama nokamu noelaiyoko, ito nena yupekama wenoka wewena lolo okoko noniseniyoko, ito nena yupekama upalo kolokaka nesaka minamiyoko, ito nena yupekama saina elokaiyoko ito nena yupekama nala numuku minaniyoko ilime wati amudawomuya nolane. ");
INSERT INTO yby_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Liki litaha, nemokahoya sa-loko lo bekoloe: Nemokahoya wehe loko lo libituyo, elilo: Maya mikauka limiki minabo wewenasida sa-ibitamaboya nemoda sa-initamabo ilekaiye. Nemesalo molabo wewenasida sa-ibitamaboya, nemoda sa-initamabo ilekaiye. ");
INSERT INTO yby_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Loko lo bekoyoko, aya wewena maya miluma ebakuka wiki miniki miluma suwametibomidana likilae. Ito wehe liki minatabo wewena maya miniwa miniwa iki minatabo ebakukaya wikilae. 31 Mat 16:27; 19:28 46 Den 12:2 ");
INSERT INTO yby_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisesimamo aya ga maya lo beko suwokoko unala ipalale yuha lemodaya sa-loko lo limiye: ");
INSERT INTO yby_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Onawa loweya wokadeko latatelesida esenipo vibo holi onawa maya nisekolaiye liki edimoya eli-minae. Sa-noidekoya nemo okulumauti we uti maya yoho yaha yalo kohanelatae loko we makolimoya mimi oko nilimemo we napasida dadeu molatiye liki edimoya eli-minae. ");
INSERT INTO yby_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aya onawaloya monoka ujapalo weki ito Omailoka jokila hi mikaka wesikiya Isilaelo wewena Omailoka jokila hi mikaka wesida uliki wenipo napa Kaiyapasida numudalauya li nupa ae. ");
INSERT INTO yby_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Sakiya Jisesida maya sunauka adelo liki kohatabo ga maya lowa jiki minae. ");
INSERT INTO yby_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sa-ikiya, sa-liki lae: Lemodaya esete vokaka holiguya sametune. Yauya sa-uniyoko wewenasiya lowa napa hiki kohalelikatae, liki lae. 2 Eks 12:1-27 ");
INSERT INTO yby_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisesi maya Beteni numutokaya Saimoniya mika ihi jelekoko neyoko ilime olutibo wemidana numudalauya ne. ");
INSERT INTO yby_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Sakoya neyoko, mena makoya adeuya netupa nuwala dowa loko wibo netupaya meinawa yoweko neboya ehadakidana odauya jekoko leko nisiye. Sako leko nisekoya Jisesima nodenesa noko neyoko muda-elokoko madonau maya kisetaiye. ");
INSERT INTO yby_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Sa-noiyoko, unala ipalale yuha lemoya lata lahelamibo kekoko sa-loko ludawo ne: Netupa nuwala dowa libo maya neboya, nenaha iyoko le latila ihelae. ");
INSERT INTO yby_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ito aya netupaya aha netiboya wewenasida meina hitae loko betudawoya meinawa napa-napa lekoko uvaminanipo minamibo wewenasidaya betudawo neboyao. ");
INSERT INTO yby_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Loko lata noeluniyoko, Jisesima elekoko sa-loko lo limiye: Edimo maya menamidanaya nenaha iyokoma auha miki edawaki aya li nime. Hulitikalo. Emokahoya saina laloya lolo onetokaiye. ");
INSERT INTO yby_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Edimoya uvaminanipo minamibo wewenaki edimoki magoina mini-liki wiki minakilaboya, nemoya edimokiya magoina hana-pana yupeka minamekoloe. ");
INSERT INTO yby_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Maya menalimoya ono molikakakuya ale li jinitatabokumuya elekoko nupaloya nuwala wibo netupaya hilenimikaiye. ");
INSERT INTO yby_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nemoya wehe loko lo libituyo. Muki mikaukaya ga lalo maya li soto moliki li bitabotoya maya menamidana monawala maya elitae liki emo lolo onetaibo nesamuya li bikilae. 7 Luk 7:37-38 11 Dut 15:11 ");
INSERT INTO yby_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Loko lokaiyoko, unala ipalale yuhauti Kaliyoti numutokati we mako uliwa Judasi maya Omailoka jokila hi mikaka wesida we napa minabotoka wiye. ");
INSERT INTO yby_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Woko Jisesida maya mimi etubotoya edimoya ehada nenakima nemetune liki data ki-minae. Loko liyoko, emoya ehada siluwa 30 yakidana litane liki litiko mikayoko, ");
INSERT INTO yby_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","emomamo Jisesida maya mimi ekoloya moneko mabada hiye. ");
INSERT INTO yby_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lulu jekaka amibo beleti nikaka abo holimidana ada onawau maya lemo unala ipalale yuha maya Jisesi nebotoka woko sa-loko loka oetune: ");
INSERT INTO yby_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Emoya esenipo vibo holimidana nodenesala maya nakahauka li lolowa initatae loko nolane, loko lokuniyoko, emo maya sa-loko liye: Edimoya Jelusalemu numutoka maya wiki we mako netibotoya tisatelimoya nemo onawane maya alo alili okaiyo, emo numukuya esenipo vibo holimidana nodenesa maya unala ipalale yuhamakiya natune loko lokaiyoko nonisune liki wiki li miliyo. ");
INSERT INTO yby_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Loko lokaiyoko, unala ipalale yuhauti lowe maya Jisesida gala maya eliki wiki esenipo vobetaibo holimidana nodenesa maya natudawo nesa maya li lolowa aiye. ");
INSERT INTO yby_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sa-ikaiyoko, ludaka maya Jisesimaki lemo unala ipalale yuha 12-palamakiya le esa oko minoko nodenesa maya nune. ");
INSERT INTO yby_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sakoya nodenesa maya nokoko minudanaki, Jisesimamo sa-loko liye: Wehe loko lo libituyo, elilo. Edimokutiya we makolimo nemodaya mimi ekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Loko lokaiyoko, miluma eludanaki, makoko makoko oko We napate yamalae, nemodamuya nolape, nemodamu nolape loko loka-mika oetune. ");
INSERT INTO yby_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sa-uniyoko, Jisesimamo sa-loko lo limiye: Makoko lapeutiya beleti leko noibo welimoya mimi ekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Okulumauti we uti nemokumuya monoka bukugu luhuwa jiminabomidana oko helitubo anuguya nowoboya, mimi etibo weya agae, lihima napa-napa lekolainako, dolakaho etametidanako wati oko minatine. ");
INSERT INTO yby_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Loko liyoko, mimi etibo we Judasimamo sa-loko liye: Tisane yamalae, nemodamuya nolape. Loko liyoko, Jisesimamo eimokaya alo lokane loko liye. 23 Sam 41:9 ");
INSERT INTO yby_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sakoya nonuniyoko, Jisesimamo beletima leko Omaimidana epoka lokoko poseko unala ipalale yuha lemoda nolimidanaki sa-loko liye: Liki nalo. Maya nemo milawanemidana aweyaha neyo. Loko liyoko nonuniyoko, kapu maya lekoko Omaimidana epoka lokoko nolimidanaki sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Maya waeni noya lo mutihekaka ga le elewolemidana oladala maya neyo, nalo. ");
INSERT INTO yby_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Muki wewenasida lihimanipo maya le hulobetatuwe loko kisitubomidana aweyahawaya ne. ");
INSERT INTO yby_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sa-onenako, nemoya wehe loko aya lo libituyo, eli-minalo. Waeni no mako namoko mino-loko wodanaki, ahoneda ebalauya aitomidana waeni noya edimoki magoina natune. ");
INSERT INTO yby_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Loko lokoko, monoka nama mako lokoko lemeko Oliwi ya bolau maya yowekolo wune. 28 Eks 24:8; Jel 31:31-34 ");
INSERT INTO yby_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bolau maya yowekuniyoko, Jisesimamo sa-loko lo limiye: Monoka bukuguya Omailimo libo ga mako sa-liki luhuwa ji-minabo maya ne: Ujapa weya kohakoyoko sipisipi jala maya hutili iki oli wikilae. Liki ji-minabo maya nenako, oloti lubukaya edimo mukiya hulinitikiki hutili iki oli wikilae. ");
INSERT INTO yby_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sa-itaboya, helekoko alikaya ahonekaho nilime sinokadeko, Galeli ebakukaya le omutolibetoko wekoloe. ");
INSERT INTO yby_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Loko liyoko, onoto leko Pitamamo sa-loko lo miye: Nemoya huloetamekoloe, edimo mukiya eli elewole ikaka nesanipo lemo jitaha, nemoya samekoloe. Loko liyoko, Jisesimamo Pitada maya sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nemoya wehe loko lo emekoloyo, ele-mino. Oloti lubukaya okole onowa owaha lamideko nemoda yuwawa molonetatadawoya onawa loweki makoki ekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Loko liyoko, Pitamamo sa-loko liye: Nemoya emoda yuwawa moloetamekoloe. Emoki magoina kohaneli helitanako, sa-oetamekoloe. Loko lokaiyoko, unala ipalale yuha lemokiya asakogo lo mune. 31 Jek 13:7 32 Mat 28:16 ");
INSERT INTO yby_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sa-loko lokoko, Jisesima unala ipalale lemokiya eba mako uliwa Gesameniyo loko nebotokaya wune. Woko yaloma hetokoko sa-loko lo limiye: Edimoya maloka minadeko nemoya woko yolalokaya Omailoka letuwe. ");
INSERT INTO yby_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Loko lokoko, Pitamaki ito Jebetida ipala lowemakiya dilipe-loko wiye. Sakiya niwadanaki mulunau elola nowiyoko, mulunauka miluma elekoko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nemoya muluneu hekaiyoko helitubo nesa noliye. Sa-okaiyo, edimoya maloya miniki nemodamuya ujapa iki minadeko magoina minatune. ");
INSERT INTO yby_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Loko lokoko lasolasi minomo nowidanaki, okepalokati lemeko pou loko noudoko Omailokaya sa-loko liye: Ahonelika, anuwa minadekoma emoya edawaki nesa li ohinitatabo nesa maya le hulonetatane loko noeloboya, nemo elituboto nehekala, eimoka letadawoto lolo etane loko noloe. ");
INSERT INTO yby_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Loko lokoko, aku niseko unala ipalale yuha maya lomuda udominuniyoko muda-lelokoko Pitada maya ilime sinoko sa-loko lo miye: Edimoya nenaha iyokoma nemokiya ujapa oko minoko onawa lasolasiya magoina minametudawo ne. ");
INSERT INTO yby_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mulutipou hitabokumu opa ikatayo, edimoya ujapa iki miniki Omailoka liki minalowo. Weuteya olo loneboya, lupalimoya eda noiye. ");
INSERT INTO yby_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Loko lokoko, akuya widanaki, Omailoka sa-loko liye: Ahonelika, edawaki nesaya mayalimo asenetoko wamidekoma, lokoyoko emo mulukau ele-minatadawo nesa leko lolo etane. ");
INSERT INTO yby_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Loko lokoko akuya niseko mudaibo maya, lomuda hihi okaiyoko lomuda udominuniyoko muda-lelone. ");
INSERT INTO yby_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sa-okuniyoko, huloletokoko woko akuya Omailoka liyoko loweki makoki yupekaya lolo iye. Omutoko woko Omailoka libomidana okogo liye. ");
INSERT INTO yby_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sako lokoko, akuya niseko unala ipalale yuhasida maya lilime sinokoko sa-loko lo limiye: Edimoya mini aso jeliki aha udi-minahe. Sa-ikayo, eli-minahe. Nemo okulumauti we uti maya mimi iki lihimanipoki wesida dadeu molatabo onawa maya aloya alili okaiye. ");
INSERT INTO yby_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sa-okaiyo, sinadeko edimotoka alo wetune. Mudalo. Mimi etibo we maya aloya alili okaiye. ");
INSERT INTO yby_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisesima unala ipalale yuha lemoda maya gaya lo lemeko neyoko, lemokuti we mako Judasi maya nonisiyoko mudabo maya wewena wavu-liki sopolohena ito mainahahena maya li-miniki emeke moliki nise. Aya wewenasidaya Omailoka jokila hi mikaka wehena ito Juda wewenasida we napanipolesiya ayalokaya doli hikayoko nise. ");
INSERT INTO yby_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sakiya anuloya niwiki Jisesida mimi ekolo wemamo ga mako sa-loko lo biye: Nemoya nowoko we mako netibotoya mudakoko okepa liyeko nonoyoko mudaikikima aya weya ne likiya adelo lilo. ");
INSERT INTO yby_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Loko lokoko enemane oko Jisesi nebotoka woko oho, tisanemalae, yaya minape lokoko okepa wotoko naiye. ");
INSERT INTO yby_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sa-noiyoko, Jisesimamo sa-loko lo miye: Iwene yamalae, emoya lolo ekolo noadawo nesaya enemane oko lolo owo. Loko noliyoko, lowa wesiya nisiki Jisesida maya adelo li ikitiki le. ");
INSERT INTO yby_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sakiya adelo nileyoko, Jisesileki minudawo weuti makolimoya sopolola maya owolauti ika okoko Omaitoka jokila hi mikaka niabo wesida we napanipomidana elekele welada maya kohakolo iboya, atalama aha boloto hulikaiye. ");
INSERT INTO yby_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sa-iyoko, Jisesimamo sopolokaya ledawokukaya aku le molo, loko lo miye. Edimoya aya sopolodunuya kohaidi esa esa ikatayo. ");
INSERT INTO yby_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Emoya ele-minape, nemoya ahonetoka letuboya enemane oko okananipoki weya lowa wekidana nala napa 12-pala doli hekadeko limiki nilimi wati ikilae. ");
INSERT INTO yby_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sa-itaboya, sakoyoko Omaimidana gala luhuwa ji-minaboya nena nena oko niseko ulolotetiye. Hapa yeikalaya monoka bukugu sakoya soto pitiye liki luhuwa ji-minabo maya nenako. ");
INSERT INTO yby_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Loko lokoko, aya onawaloya Jisesimamo li nupa i-minabo wewenasida sa-loko lo biye: Edimoya nemo ukelelo we minoyoko sopolohena ito mainahahenaya liki nisiki nadelo letune liki liki ninisehe. Nemoya muki yupeka monoka numuda napau monoka lo libekaka noboto maya nadelo lamabo nehe. ");
INSERT INTO yby_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sa-ideko maya edimo Omaimidana epaloti ga likaka wesi monoka bukugu luhuwa ji-minabo ga maya niseko ulolotetiye loko muki matoka nesaya soto nopiye. Loko liyoko, lemo unala ipalale yuha maya Jisesida huloetokoko oli hutili oko wune. 55 Luk 19:47; Luk 21:37 ");
INSERT INTO yby_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisesida maya adelo likiki Omaitoka jokila hi mikaka wesida we napanipo Kaiyapasida numudalau maya ilimi-liki waboya monoka monawa api-napi ibikaka weki ito monokalo ujapa weki minaboku ilimi-liki yowe. ");
INSERT INTO yby_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Sakiya ilimi-liki niyowekoko, Pita maya hoto apulu oko demeke moloko woko Omaitoka jokila hi mikaka wesida we napanipo numudala meniha molamabo numuku maya wiki hetikiki imi wekiya minayoko, yalo maya nenahama soto pitihe loko ujapa one. ");
INSERT INTO yby_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sa-noiyoko, Omailoka jokila hi mikaka we napaki ito monokamidana kanisolemakiya Jisesida maya koha heletune liki suwa gahenamuya ohu je. ");
INSERT INTO yby_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sakiya ohu nijeyoko, muki wewenasiya Jisesidamuya suwaki laboya, Jisesida kohatabo anuwa li soto molamae. Sakiya sa-iwa sa-iwa niayoko, we lowemasiya nisikiki sa-liki laiye: ");
INSERT INTO yby_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Maya welimoya Omaimidana monoka numudala napa maya jeko leda jeko limitiboya, onawa loweki makoki nowideko aku le sinoko vetubo ne loko lonebo ne, liki laiye. ");
INSERT INTO yby_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Liki laiyoko, Omailoka jokila hi mikaka wesida we napanipo maya sinokoko Jisesida maya sa-loko lo miye: Emoya obiya nigitadanaki laibo galoya le wili jeko letadawo gaya nehe minamiye, olo. ");
INSERT INTO yby_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Loko loka oetaibo maya Jisesimamo epa molokoko minokaiyoko, maya we napamamo sa-loko lo miye: Elewole we Omaimidana omudaloya lo soto molatane loko loka noetoe. Emoya Omaimidana ipala lahelamibo nesauti lilimitiye loko lo mololetaibo we maya minape, lo lemo. ");
INSERT INTO yby_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Loko loka oetaiyoko, Jisesimamo sa-loko lo miye: Emokahoya galoya lokadawoya, nemoya makoya sa-loko lo liboe: Maya onawamidana mupilaloya okulumauti we uti nemoya elewole wemidana ade lamawakaloka minoyoko, ito okulumamidana ijopa mupilaloya nolemoyoko muda-nelatabo ne. ");
INSERT INTO yby_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Loko liyoko, Omailoka jokila hi mikaka wesida we napanipomamoya elibo maya wehe lamiyoko, eimola upalalo nesa maya jeko wetala jeko nohulaidanaki sa-loko liye: Omaiya pulekolo lokaiyo. Gala mako eli-minatabo wewenasidaya nenahalo aku ju lokoko gala lideko eletune. Emoya Omai pulekolo libo aya edimo olotiya galoya elikanako, ");
INSERT INTO yby_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","yamuya edimoya nenahama oetatune liki niele. Loko liyoko, muki wewenamasiya yaya oijo nakolo ga maya lokainako, helitiye, liki lae. ");
INSERT INTO yby_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Liki likiki malokasiya Jisesida maya etehu niitiki dadelotiya okepalo maya moli hiti-miniki ");
INSERT INTO yby_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sa-liki li me: Lahelamibo nesauti lilimekaka we yamalae, emoya ga monawa lo soto molokaka we maya minatadawoya, ekahimamo nokohaelaihe, lo lemowo, liki omudalo maya lawolawoloti wasa jinimiki sa-likiya lae. 61 Jon 2:19 64 Den 7:13 65 Liv 24:16 67 Aes 50:6 ");
INSERT INTO yby_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sa-niayoko, Pita maya meniha molamabo numuku maya neyoko, Omaitoka jokila hi mikaka wesida we napanipomidana elekele oluho makolimo Pitama nebotoka niseko, emoya Galeli ebakukati we Jisesite minikaka niaibo we maya minane. ");
INSERT INTO yby_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Loko liyoko, Pita maya muki wewenasida dowisalo suwa loko emo noladawo gamidana monawaya ma elamoe, loko lokoko, ");
INSERT INTO yby_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","lemeko meniha molamabo numuda ateto maya neyoko, elekele oluho makolimo muda-elokoko ayaloka magoina minabo wewenasida maya sa-loko lo biye: Maya weya Naseleti numutoti we Jisesite magoina minikaka niaibo we maya ne. ");
INSERT INTO yby_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Loko liyoko, Pitamamo akuya yuwawa moloko sa-loko liye: Omaimidana omudaloya nade nokepalo yoweko noloe. Ma muda-elamobo wemuya nolane. ");
INSERT INTO yby_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Loko lokoko, onawa lasolasi neyoko ayaloka sini-minabo wewenasiya Pita maya nebotoka nisiki sa-liki lae: Wehe liki nilae, emoya aya yuhauti maya minane. Eimoka gakalimoya monawaka maya lo soto molokaiye. ");
INSERT INTO yby_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Liki layoko, Pitamamo Omaimidana omudaloya lo soto moloko nemoya suwa lamoe, aya weya ma muda-elamobo wemuya nilae. Suwa letuboya Omailimo nilime olisau molokatiyo loko nolibo epaki enemane oko okolemamo onowa liye. ");
INSERT INTO yby_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Lokaiyoko, Pita maya Jisesikaho okole owaha onowa lamideko nemokumu yuwawa molonetatadawo onawa loweki makoki ekolaiye loko libo galo maya aku ata kekoko lemeko hetoka maya wije napa-napa liye. ");
INSERT INTO yby_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nekewa ho maya noyowiyoko, Omailoka jokila hi mikaka we napaki ito monoka ujapalo wemakiya Jisesida kohatune liki lowa je. ");
INSERT INTO yby_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sa-likiki nala jiki liki wiki uliki we napa Paelati neboto maya obi itakili ilimi-liki wae. ");
INSERT INTO yby_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judasima Jisesida mimi ibo wemamo mudaibo maya Jisesida helitiye liki li hukimikayoko, Judasi maya akuya ukala le wili jekoko, aya siluwa ehada 30 maya Omailoka jokila hi mikaka weki ito monoka ujapalo wemaki minabotokaya aku leko woko biye. ");
INSERT INTO yby_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Leko woko nobidanaki sa-loko liye: Nemoya lihimaya le-minoe. Lihimala minamibo we maya mimi okoyoko helekolaiye. Loko liyoko, aya wesiya yaya lemo nesate minamiye, emoka nesakaya ne. ");
INSERT INTO yby_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Liki layoko, Judasimamo aya omolu ehada maya leko yoweko monoka numuku maya hutili oko hulikoko woko yalo maya nala iye. ");
INSERT INTO yby_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nala okaiyoko, aya Omailoka jokila hi mikaka we napasiya aya omolu ehada maya likiki sa-liki lae: Maya omolu ehadaya we mako helekolo noibo wemidana ehadala maya ne. Yamidana ehada maya monoka numuku ehadakiya magoina molamilo liki li huki-minabo maya ne. ");
INSERT INTO yby_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Liki ligi hagi iki ga mako li hukae. Sa-liki likiki mika makomalokati wesida ono molikaka eba netiye likiki aya ehadaloti maya somo lolo ikaka wesida mikanipo maya meina he. ");
INSERT INTO yby_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sa-ikiki aya mikamidana uliwa maya olada mikae liki molae. Sakiya molabo uliwa maya olotiya aha ne. ");
INSERT INTO yby_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sa-ikayoko ga mako hapa yeikala Omailimo epaloti ga lokaka we Jelemayada lo mibo ga maya niseko ulolotiye. Emoya luhuwa sa-loko jenebo ne: Edimoya aya omolu ehada 30-ya Isilaelo wewenasiya aya ehadamuya li molabo maya, maya wemidana meinawa ne liki li-minabo maya nenako, ");
INSERT INTO yby_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aya ehadaya likiki mika somo lolo ikaka niabo wesida mikanipo meina heboya we napalimo lo nimiboto nesa lolo ae. 3-8 Apo 1:18-19 9 Jek 11:12-13 ");
INSERT INTO yby_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisesida maya ilimi-liki wiki duliki wesida we napanipomidana omudalo maya ilimi sinae. Sa-ikayoko, uliki wemamo loka oetoko emoya Juda wewenasida duliki wenipo napa maya minape. Loko loka oetaiyoko, Jisesimamo yaya eimoka galoya lokane loko liye. ");
INSERT INTO yby_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sa-loko lokaiyoko, Omailoka jokila hi mikaka wemaki ito ujapalo wemakiya Jisesitokagoya ga maya li molikigoya lae. Sakiya laboya edimo labotoya mako bekimi oko lo bamiyoko nenako, ");
INSERT INTO yby_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Paelatimamo sa-loko liye: Muki gaya li obilo nimoligitaboya ele-minape. ");
INSERT INTO yby_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Loko libo maya Paelati libo galo maya bekimi oko lo mamibo ne. Sa-okaiyoko nenako, duliki wesida we napanipomamo ata etipo kenebo ne. ");
INSERT INTO yby_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Esenipo vobetaibo holi onawau maya melekeu melekeuya nala numuku minabo wewenasida Juda wewenasiya olutobetatane liki we makomidana uliwa likayoko, uliki wemamo nala numukuti doli heka doli heka iyoko, aya wewena maya numudanipoloka wikaka abo ne. ");
INSERT INTO yby_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sa-iboya, aya onawaloya we mako uliwaya muki ebakuka hutili oko wibo we makoya nala numukuya nebo ne. Aya weya Jisesida abala uliwa Balabasi. ");
INSERT INTO yby_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sa-okaiyoko muki weloti menaloti li esa ikayoko, Paelatimamo loka obetoko edimoya ekahidama esewa voetokoyoko edimotoka wetiye liki nilae. Lahelamibo nesauti dilimekaka we ne liki likaka niabo we Jisesidahe, ito Jisesida abala Balabasidaya esewa voetatuwe. ");
INSERT INTO yby_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Loko liboya, Jisesida uliwa maya yowekaiyoko, edimo dulinipo maya lemekaiyoko, mulunipou nosamiyoko obilo maya ilimi soto molabokumuya Paelatimamo elenedanaki aya wewenasida maya loka obetaiye. ");
INSERT INTO yby_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sakoya Paelati maya obi ga lo hukokaka siyalo maya yoweko neyoko, menalamamo luhuwa nesa jeko sa-loko lo miye: Emoya aya we yaitaya wehe loko nebo we maya neyo, emokahoya ga mako upaloka lo molamo. Oloti lubukaya aya wemidana wamola mudaobo nenako, milumala adoha noeloe, loko liye. ");
INSERT INTO yby_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ito edimo Omailoka jokila hi mikaka weki ito monoka ujapalo wekiya wewenasida mulunipou higi iki sa-liki nilayoko, Balabasida maya esewa voetatiye liki Paelatitoka nilikiya Jisesida koha heletune liki layoko, ");
INSERT INTO yby_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Paelatimamoya sa-liki likanako, maya we loweuti ekahidama huloetokoyoko edimotoka wetiye loko liyoko, matoka wewenamasiya Balabasidae liki lae. ");
INSERT INTO yby_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Liki layoko, Paelatimamo sa-loko liye: Sa-oneboya, lahelamibo nesauti lilimitiye loko lo mololetaibo we ne liki labo we Jisesida maya nemoya nenahama oetatuwe loko loka obetaiyoko, aya we yaitaya leko woko yoho yaha yalo nalawa oko teto liki lae. ");
INSERT INTO yby_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Liki layoko, Paelatimamo nenahamuye loko loka obetaiye. Aya weya nenahaloma olisa okaiyoko nilae loko libo maya, aya wewenamasiya Paelatida gala maya mi ji hulikiki yoho yaha yalo nalawa oko tetowo liki pigi jiki lae. ");
INSERT INTO yby_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Liki layoko, Paelatimamo elibo maya emo letibo ga maya mumu lametibo nesa leko lowa napa soto pitibo nesa lekaiyoko nenako, muki wewenasida dowisaloya no maya kise hulo lapeu molokoko adela nokalawe oko le hulonebo ne. Sakoya adela nokalawe noidanaki, sa-loko liye: Maya weya kohatabomidana lihimalaya nemotoka minamekolaiye, edimo nesatipoe. ");
INSERT INTO yby_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Loko liyoko, matoka wewenamasiya liboto maya sa-liki lae: Aya lihimalaya lelimoteloka ito oluho laopilatelokagoya netiye, liki lae. ");
INSERT INTO yby_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sa-okaiyoko, Paelatimamo Balabasida maya olutoetaiye. Sakokoya Paelatimamo libotoya Jisesida maya uhedawaki oijoloti kohaki ito yoho yaha yalo nalawa iki tibitikaka oijoloti maya kohaikiki helitiye loko imi wesida dadeu maya molaiye. 24 Dut 21:6-9 ");
INSERT INTO yby_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sakikiya uliki wemidana imi welalemasiya Jisesida maya ilimi-liki uliki wemidana numudala luwakuya yowiki muki imi wehena maya li nupa ae. ");
INSERT INTO yby_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sakikiya Jisesida galalo maya uliki wekidanaya lolo itadanaki upalo olo jenebo nesa maya ololotiki li hulikiki duliki wesi olo jikaka niabo nesa maya liki nisiki ohugo nesaya olo jitikikiya, ");
INSERT INTO yby_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","asowalaki nalaloti adakolila lolo ikiki madonalo olo jitikiki ade lamawakaloka maya akepa oijoya mako letiki mikayoko lenebo ne. Sakoya leneyoko, imi wemasiya amaitokaya nisiki okepa jiki di bola hi miki sa-liki lae: Esekane aliyo, Juda wewenasida duliki wenipomae. ");
INSERT INTO yby_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sakiya ni-liki okepauka matokaya etehu nitiki adelau meyoko lenebo oijoloti maya wowotiki nikohaiki okepalo matokaya jimi yowiki limiki iki minabo ne. ");
INSERT INTO yby_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sakiya okepa jiki niladanaki ohugo upalo olo jitabo nesa maya ololotiki li hulimikiki eimola upalo olo jeko monekaka noibo nesa maya liki nisiki olo jitae. Sakiya olo jimikiki yoho yaha yalo tibitakili kohaidikaka niabo oijoloti maya kohai helikili ilimi-liki wae. ");
INSERT INTO yby_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sa-ikili ilimi-liki niwayoko, Sailini mikaukati we makoya uliwa Saimonikahoya anulo nonisiyoko mudaibo maya Jisesida yoho yaha yala maya ohitiye liki ula molikayoko, ");
INSERT INTO yby_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","magoinaya eba makomaloya wae, aya ebaya uliwa Gologota. Ya eba uliwamidana monawaya sa-loko ne: Madonamidana ono ebalae. ");
INSERT INTO yby_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Loko nebotoya yowikiki Jisesima natiboe liki waeni no makoya mukasikidana elibo nesakiya li opa napa ikiki Jisesida maya miluma eleko elola wokatiye liki me. Sakiya mikayoko noko elibo maya, ekesa okaiyoko namoko hulikaiye. ");
INSERT INTO yby_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sa-okaiyoko, yoho yaha yalo kohaiki te. Sakiya kohaiki timikiki ono makoya kasikidanaya moliki asitibo wemamo Jisesida upalo nesa maya litiye likiki molae. ");
INSERT INTO yby_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sa-ikiki ayalo maya ujapa iki minae. ");
INSERT INTO yby_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sa-ikikiya, madonalokaya obi itabo aya sa-liki luhuwa jiki molitikayoko nebo ne: Maya weya Jisesimae, Juda wewenasida uliki wenipomae. ");
INSERT INTO yby_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Liki luhuwa jiki molikiki, Jisesida apila maloka malokaya ukelelo weya makoya kohaiki ade atahakaloka tiki ito makoya ade lamawakaloka tebo ne. ");
INSERT INTO yby_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Sa-ikayoko, wewena wiki nisiki abo wewenasiya mudabo maya madonipo oke oke nojiyoko mudaikiki ulana moliki lika lika iki sa-liki labo ne: ");
INSERT INTO yby_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Emokahoya monoka numuda napa maya le opa okoko onawa loweki makoki nowideko akuya le sinoko vetubo ne loko lokaka adawo we maya minaniyo, eimoka upakaya le yasi owo. Emoya Omaimidana ipala minatadawoya, yoho yaha yaya hulikoko lemamane. ");
INSERT INTO yby_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Liki nilayoko, Omailoka jokila hi mikaka we napaki ito monoka monawa api-napi ibikaka wekiya nisikiki eme jiki sa-likiya litae: ");
INSERT INTO yby_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Wewena malokasida dilipe yola molokaka ibo we maya neboya, eimola upalaya le yasi ametibo nesa lekaihelae. Emoya Isilaelo wewenasida uliki wenipo maya netiboya, olotiya yoho yaha yalotiya pasokoko lemetine. Sakoya lemekadeko lemokahoya muda-elokoko emesalo molatudawo nehao. ");
INSERT INTO yby_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Emoya Omailokaya elewole oko ele-minoko nemoya Omaimidana ipala minoe loko lokaka ibo maya neboya, Omailimo olotiya emodamu elenetiboya, yoho yaha yalotiya ilime hulatibo neha. ");
INSERT INTO yby_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Liki layoko, we lowema Jisesida apila maloka maloka nalawa iki tebo wemasiya asaikiya Jisesida eme jiki laiye. 35 Sam 22:18 39 Sam 22:7; Sam 109:25 40 Mat 26:61; Jon 2:19 43 Sam 22:8 ");
INSERT INTO yby_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Holiga maya muki mikauka lubu jeko suwokoko mino-loko nowiyoko 3 kilokuya lolo okaiyoko, ");
INSERT INTO yby_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jisesimamo eimola galautiya ga napauti sa-loko liye: Eli, Eli, lema sapakatani, loko liye. Loko liboya lemo gateukatiya Omaine yamalae, Omaine yamalae, nenahamuya holonetokane. ");
INSERT INTO yby_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Loko liyoko, amaitoka minabo wewenamasiya eli opa ikiki maya wemamo Ilaijadama ju noliye. ");
INSERT INTO yby_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Liki layoko, ayauti we makolimo lolosa jeko woko noikidana nesa makoya leko nisekoko akepa oijo lolowalo maya molokoko ekesa waeni nokuya hekoko leko woko Jisesi maya natiye loko mekolo noiyoko, ");
INSERT INTO yby_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","maloka wewenamasiya sa-liki lae: Aha mudamino. Ilaijakaho niseko ilime hulatihe, mudaminoko letuniyo. ");
INSERT INTO yby_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sa-liki nilayoko, Jisesi maya ga napauti ju loko weuna oluhola maya huloetaiyoko wiye. ");
INSERT INTO yby_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sa-noiyoko, monoka numuda napau Omaimidana owisalo yowikaka niabo ateto imaha molabo lawo-lawo maya lolowaloti yokawa jeko boloto-loko lemeko woko le maloka maloka iye. Sakoya mima napa-napa oko ehada napahena maya jewo posewo iye. ");
INSERT INTO yby_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sa-noiyoko, ono molikaka ale makoya eimola golotiye. Sa-iyoko Omaimidana wewenala hapa yeikala helebo wewenahenaya sinae. ");
INSERT INTO yby_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Sakiya sinikiki ono molikaka eba maya hulikiki Jisesida emeke moliki Jelusalemu numutoka maya wayoko, muki wewenamasiya miniki mudai-minae. ");
INSERT INTO yby_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sa-iyoko, imi wesida we napanipolemaki ito imi wemakiya Jisesito ujapa iki minadanaki, mika maya mima noiyoko ito maloka nesahena maya soto piyoko, domodanipo adoha wokaiyoko nenako, maya weya wehe loko Omaimidana ipala ne liki lae. ");
INSERT INTO yby_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sa-liki likayoko, omutiki Galeli eba maya hulikiki Jisesida ilimikaka abo menakipamaki emesalo moliki wabo menakipa mayaki hoto apulu iki sini-miniki mudai-minae. ");
INSERT INTO yby_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sakiya minabokutiya Magadala numutoti mena Mele ne, ito Mele mako Jemisite Jonite donipo, ito mena makoya Jebetida menalamakiya magoina minae. 46 Sam 22:1 48 Sam 69:21 51 Eks 26:31-33 55 Luk 8:2-3 ");
INSERT INTO yby_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ludaka huluwaloya uvaminalaki we makoya Alimatiya numutokati we uliwa Josepuwo lokoya omutoka Jisesida unala ipalale yuha nebo ne. ");
INSERT INTO yby_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Sa-ibo nenako, aya wemamo Jisesida onola maya lekolo woko Paelatida sa-loko loka oetokaiyoko, Paelatimamo onowa maya li milo loko lokaiyoko, li me. ");
INSERT INTO yby_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sakiya li mikayoko, Josepumamo lawo-lawo ohatama ukulolotiya wasa jeko sese iye. ");
INSERT INTO yby_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sakoko aya ono maya eimola ono molokaka ale ohatamauya we makosiya liki wiki molae. Sakoya ono molikaka niabo ebawaya ehada numuda Josepukaho golotonebokuya liki wiki molikiki ehada napa makoya ipisiki liki wiki aya alemidana epawalo maya moliki li likiki wae. ");
INSERT INTO yby_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sa-noiyoko mena lowe minaiboya makoya Magadala numutoti mena Mele ito Mele makokiya ono ale epawaloka maya miniki mudai-minaibo ne. ");
INSERT INTO yby_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sa-ikayoko go maya lokaiyoko, holi onawalo nodenesa li lolowa ikaka onawa maya wokaiyoko, Omailoka jokila hi mikaka wehena ito Palasisi wewenahena maya Paelatima nebotokaya wiki li nupa ae. ");
INSERT INTO yby_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Sakiya li nupa ikiki sa-liki lae: Agae, we napalae, lemoya ga mako elekoko nonisune. Aya suwalo we maya aha omuda le-minoko onawa loweki makoki wokadeko aleuti aku sinakoloe loko libomidana okatinako, ");
INSERT INTO yby_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","emokahoya imi wesida maya doli hekadeko wiki loweki makoki yupekaya ale epawalo maya ujapa iki minatae. Unala ipalale yuhamasiya onowa maya ukele liki wikiki wewenasida suwa liki galoya ono aleuti maya sinokaiye liki likatayo. Omutoko suwa ga libotoya alika suwa ga litabolimoya asetokatiyo. ");
INSERT INTO yby_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Liki layoko, Paelatimamo sa-loko lo biye: Edimosiya imi wekiya dilipi-liki wilo. Aya alemidana epalo maya edimo elewoleyatipo nebomidana iki jiki lilalo. ");
INSERT INTO yby_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Loko lokaiyoko wikiya ale epawalo molabo ehada maya elewole oko netiye liki nala makoya le. Sa-ikiki imiki wesidaya ya ale epawalo maya ujapa itae liki hulibitae. 63 Mat 16:21; Mat 17:23; Mat 20:19; Mak 8:31; Mak 9:31; Mak 10:33-34 63 Luk 9:22; Luk 18:31-33 ");
INSERT INTO yby_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Holi onawa maya suwokaiyoko Magadala numutoti Melemaki ito Mele makokiya Sadeu nekewa ho maya yowekolo noiyoko ono ale maya mudakiliya waiye. ");
INSERT INTO yby_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sakiya niwaiyoko, mima napa-napa makoya iboya, Omaimidana okanaki wela makolimoya okulumauti lemekoko ale epawalo moli li li-minabo ehada maya ipisoko le hulikoko aya ehada mupilalo maya esela hiyoko mima napa iye. ");
INSERT INTO yby_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sakoya neboya, okepaloka maya go panakidana oko neyoko, upalo nesalokati matokaya ukulo hege-pege loko nebo ne. ");
INSERT INTO yby_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sa-iyoko nenako, lowamidana ulalalo we maya sa-ibo nesamuya domodanipo wokaiyoko, ololo jikiki dabuhanida minamiyoko, udiki esa i-minabo ne. ");
INSERT INTO yby_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sakiya aya wewena maya alonipo oli wikayoko, alikaya aya mena lowe maya niseiyoko, okanaki wemamo sa-loko lo biye: Edimoya domodatipo wamideyo. Edimoya yoho yaha yalo kohaki tebo we Jisesida maya mudasiye liki niniseiye loko ele-minoe. ");
INSERT INTO yby_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Sa-aiboya, aya we maya mauya minamiye. Hapa yeikala eimola liboto maya aloya sinokaiye. Sa-okaiyo, edimoya nisiki aya wema udaibo ebawa maya mudaliyo. ");
INSERT INTO yby_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sa-ikikiya edimoya enemane iki wiki unala ipalale yuhasidama we napama aleuti maya alo sinokaiye. Sa-okokoya aloya le omutolibetoko Galeli ebakuka maya nowinako, edimoya aya wemidana maya wiki yaloka maya muda-elakilae liki li biliyo. Sakoya lo libiboto maya eli-miniki li biliyo. ");
INSERT INTO yby_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Loko lo bekaiyoko, mena lowe maya domoda wiboya, aya ehada numukuti maya limikiki elowa jiki lolosa jiki wiki unala ipalale yuhasida maya li bikiliya waiye. ");
INSERT INTO yby_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sakiya niwaiyoko, Jisesimamo anulokaya aya mena lowesida maya hotula-patula okoko alo-nalo liki, yaya niniseihe loko lo biye. Loko noliyoko, aya mena lowemasiya li wili jikiki ilalo maya leibo ne. Sa-nikiya lipi miki epoka laiye. ");
INSERT INTO yby_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sakiya epoka nilaiyoko Jisesimamo sa-loko lo biye: Edimoya domodatipo wamideyo. Edimoya wiki unanele motasida maya Galeli ebakukaya wiki nemoda muda-nelakilae loko liye liki wiki li biliyo, loko aya mena lowesida maya lo biye. ");
INSERT INTO yby_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aya mena lowe maya anu moliki niwaiyoko, ale epawalo ujapa i-minabo wewena malokamasiya li taoniguka wae. Sakiya wikiki Omailoka jokila hi mikaka we napasida maya soto pibo nesamuya wetome iki li be. ");
INSERT INTO yby_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sa-liki likayoko, Omailoka jokila hi mikaka wehena ito monoka ujapalo wehenamasiya li nupa ikiki ga mako li molae. Sakiya li molikiki lowa wesidaya omolu ehadaya mukiya be. ");
INSERT INTO yby_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Sakiya nibikiya sa-liki lae: Edimoya sa-likigo lilo: Lemoya udominuniyoko lubukaya unala ipalale yuhamasiya nisiki onowa maya ukele liki wae likigoya lilo. ");
INSERT INTO yby_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ito uliki we napamamo aya ga maya elekoko nolideko maya, lemoya ga mako lo mekolo uniyo. Edimotokaya ga mako minamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Liki layoko, lowa wemasiya laboto maya emesalo molae. Sa-ikayoko aya ga maya Juda wewenasikuka hutili oko woko suwokaiyoko nenako, oloti onawalo maya aya ga maya likaka niae. ");
INSERT INTO yby_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Unala ipalale yuha lemo 11-pala maya Galeli ebakuka woko Jisesikaho bola makomau yowitae loko lo limibotoka maya yowekoko, ");
INSERT INTO yby_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jisesidaya muda-elokoko lipe meko epoka ludawoya, malokamasiya Jisesi maya helenebokuti sinoko nehe liki data etipa ke. ");
INSERT INTO yby_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sa-ikayoko nenako, Jisesimamo niseko alililoka minoko gaya sa-loko lo limiye: Omailimoya okulumaki ito ma mikaki elewoleyanipo maya hulo nemo nadeu molo suwokaiye. ");
INSERT INTO yby_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sa-okainako, yamuya edimoya aya abuha-wowone li-miniki mika okana maloka malokaya wiki muki wewenasida maya dilipe nemo unanele ipalanele yuha lolo itae. Saniki maya ahoneda uliwalo ito ipala nemo nulinelo ito Omai weuna oluhomidana uliwalo dilipi-liki nisiki dilipi nupa iki nokuya udibitalo. ");
INSERT INTO yby_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Sa-ikiki nemo lo libitubo galoya emesalo molatae liki api-napi ibitalo. Eli-minahe, nemoya edimoki magoina mino-loko woko minoyoko, mikamidana onawalaya suwetibo ne loko unala ipapalale yuhasida maya lo limiye. 16 Mat 26:32; Mak 14:28 ");
INSERT INTO yby_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jisesi Kalaestiya Omaimidana ipaladamuya gala laloya sa-loko soto pibo maya ne. ");
INSERT INTO yby_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yamidana gawaya Omaimidana epaloti ga wetome okaka we Aesayakaho Omailimo ipalamidana lo mibo ga sa-loko luhuwa jibo ne: Elilo, nemo gane lo-lele monitibo we oli hekoyoko emo le omutoko woko dukau yowanu litibomidana anuwaya wilebetakolaiye. ");
INSERT INTO yby_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mumusopa ebatokatiya aya welimo ga napauti sa-loko noliye: We napamu maya duka li wehe litalo. Dukau limitibo anula li wehe litalo. ");
INSERT INTO yby_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Loko libo ga maya Jonito nisekaiyoko, mumusopa ebatoka woko nedanaki, Omailimo lihimanipo le hulobetatiye loko dukanipo li wili jikiki noku udatae loko lo beko ne. ");
INSERT INTO yby_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Loko liyoko, Jelusalemu numutoka ito Judiya eba malokatiya wewena mukiya Joni nebotoka wiki lihimanipo li soto molikayoko, Jodani noku maya noku udobetaiye. ");
INSERT INTO yby_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Joniya ya yupekaya lawolawolaya kamolo ja upaloti lolo abo nesa olo jekoko ja upaloti lolo abo ebelaya ohalalo jekoko pipiya nodenesa hituki lube nouvalakiya noko nebo ne. ");
INSERT INTO yby_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Noko nedanaki, sa-loko lo beko nebo ne: Nemesaloka nonisibo weya elewoleyalalimo nemo elewoleyanemidana kohako ne. Nemoya aha we minoe. Emotoya kohamonako, emodaya elekele oetoko yowanu lasolamaki letatuboto kohamoe. ");
INSERT INTO yby_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nemoya aha noku udolibetobo neboya, emokahoya Omaimidana weuna oluholalotiya noku udolibetakolaiye, loko lo biye. 2 Mal 3:1 3 Aes 40:3 6 2 Kin 1:8 ");
INSERT INTO yby_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ya yupekaya Galeli mikaukaya eba mako neboya uliwa Naseleti. Jisesi maya Naseleti numutokati Joni neboto nisiyoko noku udotaiye. ");
INSERT INTO yby_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nokuti maya sinaiyoko, okulumama golotiyoko mudaboya Omaimidana weuna oluhoya nama luhukidana oko lemeko Jisesida elelaloma neyoko mudae. ");
INSERT INTO yby_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sa-iyoko, okulumauti maya ga mako sa-loko soto piye: Emoya nukane eme-minobo ipane maya minaninako, emodaya muda-elo lalo okoe. 11 Jen 22:2; Sam 2:7; Aes 42:1; Mat 12:18; Mak 9:7 ");
INSERT INTO yby_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sa-loko liyoko, weuna oluholimo Jisesida maya oli hekaiyoko mumusopa mikaloka wiye. ");
INSERT INTO yby_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yaloka maya woko onawa we lowesida di dadeloka suwoko le nohulaiyoko Olohalimoya niseko odalau hego mologo oko ne. Sa-iboya, Jisesi maya liwe aha-namasida luwanipouya neyoko, Omaimidana okanaki welalesiya nasahili itiki minae. ");
INSERT INTO yby_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sa-iboya, Jonida maya nala numuku hulitikayoko neyoko, Jisesimamoya Galeli ebakuka woko Omaimidana gala lalo maya wetome oko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Aloya onawa okaiyo, Omailimo ujapa olibetatibo onawa maya alili okaiye, yamuya duka li wili jiki maya ga laloya eli elewole ilo, loko lo biye. 15 Mat 3:2 ");
INSERT INTO yby_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sakoya minoko yu makoya Galeli no apilaloka nomoniyoko, Saimoniko unala Endulukoya lahawa hikaka we minainako, lahawa owo maya huli nohuku ikiki minaiyoko, mudaidokoko sa-loko ju liye: ");
INSERT INTO yby_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hulikiki nemoki magoina wetune. Lahawa niheibo nesa liki wewenanelesitoya yowanu liki dilipi-liki nemotoka nisisaiye loko dilipe nomoloyo. ");
INSERT INTO yby_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Loko liyoko, enemane iki lahawa owoma hulikaidanaki Jisesiki magoina wae. ");
INSERT INTO yby_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sa-ikaiyoko, Jisesimamo lasolasima nowidanaki, Jebetida ipala lowe Jemisiko unala Joniko maya asaiki noku lapeu maya miniki lahawa owo li wati wati niaiyoko mudaidokadanaki, ");
INSERT INTO yby_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ju liyoko ahonipo Jebetile elekele oluholalesida maya aha noku lapeu minalo liki hulibitikiki Jisesiki maya magoina wae. ");
INSERT INTO yby_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sakikiya Kapaniyamu numuto maya wayoko, monoka onawa maya alili okaiyoko, Jisesimamo monoka numuku maya yoweko monoka lo biye. ");
INSERT INTO yby_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Monoka libo maya monoka monawa api-napi ibikaka abo wesi nesa leko lamiye. Aito wewenasida ganipolo emesalo molatae loko neyopa, eimola elewoleyalaki gala maya nenako, emesalo molatae loko lo bekaka ibo nenako, aiyo liki lae. ");
INSERT INTO yby_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sa-iyoko aya yupekaya olohamidana weuna oluho makolimo we makomidana madona le opa ibo we mako nebo ne. ");
INSERT INTO yby_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Aya wemamoya alukada moloko Naseleti we Jisesiyo, emoya nenahalo lahelamibo nesa lolo oletakolo noane. Lilime opa etuwe loko nonisepe. Emodaya muda-elo wehe lo-minoe. Emoya Omailokati eto oko minadawo we maya minane. ");
INSERT INTO yby_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Loko liyoko, Jisesimamo auha meko epaka mumukeikoko moletoko ukautiya lemeko wo. ");
INSERT INTO yby_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Loko liyoko, ukala le opa noibo olohamamoya ilime momoga okoko opa napa ga nolidanaki ukalauti maya lemeko wiye. ");
INSERT INTO yby_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sa-iyoko, muki wewenasiya agae ni-liki maya nena nesa iye liki emo okepau mudao emo okepau mudao liki lae. Emoya monoka aitomidana abuha-wowolaki lobetokaka noiyoko, olohasidaya wilo liboto maya emesalo moliki wikaka niae. ");
INSERT INTO yby_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Liki layoko, Jisesidamuya labo ga maya enemane oko Galeli ebakuka pou loko wiye. 22 Mat 7:28-29 ");
INSERT INTO yby_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sa-okaiyoko, hetoka limikikiya Jemisile Jonilemaki wiki akuya li Saimoniko Endulukosida numudanipou maya yowe. ");
INSERT INTO yby_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonida iloho dola maya upau jo libo nesa eloneyoko, Jisesida maya enemane iki li me. ");
INSERT INTO yby_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sakiya li meyoko, Jisesimamoya woko aya menamidana maya adelo leko ilime sinaiyoko, aya nesa maya suwoetokaiyoko sinokoko Jisesilemaki nasahili obetaiye. ");
INSERT INTO yby_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Sakoya ho maya lemekaiyoko, muki saina delaibo wewenahena ito olohamidana weuna oluho dukau nebo wewenahena maya dilipi-liki Jisesitoka maya nisi nisi aboya, ");
INSERT INTO yby_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","numuda ahola maya muki nisiki ateto maya li esa abo iliye. ");
INSERT INTO yby_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Sa-ikayoko, aito aito nesa delaibo wewenahena ito olohamidana weuna oluho dukau nebo wewenahena maya dilipe lato-lato oko aya olohasida maya doli heko le hula hula iye. Sa-iboto maya muda-eli wehe layoko, sa-ibo nesa maya wetome amitae loko lo hukobetaiye. ");
INSERT INTO yby_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Okululuwa hokekolo sa-ibolawa maya, Jisesima sinoko hetoka lemekoko ametoka woko nedanaki Omailoka loko ne. ");
INSERT INTO yby_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sa-okaiyoko, Saimoni maya wewenalaleki ijaka hiki wadanaki, ");
INSERT INTO yby_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","wiki muda-elikiki muki wewena maya emokumuya ohu nije liki li me. ");
INSERT INTO yby_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Liki layoko, muki ebaya wavu-leko alililoka ne loko lo biye. Sa-onenako, yatoka ebatoya woko monoka lo soto molatuwe loko wetune. Aya yowanu maya lituwe loko nonisoe. ");
INSERT INTO yby_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Loko lokoko Galeli ebakuka moneko suwokadanaki, monoka numuda neboto neboto moneko monoka lo beikaka oko nedanaki, olohahena maya wewena dukautima oli heko le hula hula oko nebo ne. 39 Mat 4:23; Mat 9:35 ");
INSERT INTO yby_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mika ihi jelibo we makolimo maya Jisesitoka niseko i bola heko sa-loko lo miye: Emoya nilime olutetuwe loko maya aha nilime olutonetamane. ");
INSERT INTO yby_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Loko liyoko, Jisesi maya ukala hekaiyoko adela moloko upaloka leko sa-loko lo miye: Olutetane loko noloyo, oluto. ");
INSERT INTO yby_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Loko liyoko aya mika ihi maya enemane oko olutoetokaiyoko, ");
INSERT INTO yby_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisesimamoya aya we maya numudalaloka oli heko sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ele-minape. Olutadawo gaya wetome oko wewenakalesida olotiya lo bamo. Alo olutokane liki eli wehe litae loko woko Omailoka jokila he mekaka wema netiboto upaka maya ilipekadeko alo uliwitokane loko mudatiyo. Ito ulijedawomuya Mosesekaho libo nesa leko Omaitoka jokila hi mikadeko olutadawomidana monawa maya muki wewenasi eli wehe litayo. ");
INSERT INTO yby_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sa-loko lokaiyoko, aya wemamoya woko wetome-katome oko lo-lele moniye. Sa-okaiyoko, Jisesimamo taoniloka wetuboya wewena wavu-liki nisikilanako lokoko numuda lasolaukagoya neyoko, muki numutotiya maloka gala elebo wewenasiya nisi nisi ayoko, magoinaya minae. 44 Liv 14:1-32 ");
INSERT INTO yby_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yu makoya Jisesi maya aku Kapaniyamu ebatoka maya woko numuku ne liki laboya elikadanaki, ");
INSERT INTO yby_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","wavu-liki wewena nisiki numudalau mini waitikadanaki, atetokiya hiki li-liki minayoko monoka lo biye. ");
INSERT INTO yby_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Sa-noiyoko, we loweki lowekisiya ebili libo wemidana maya mokolo lolo iki ilimi molikiki liki niseyoko, wavu-liki wewenasiya demesalo moliki nise. ");
INSERT INTO yby_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sakiya nisebo maya wewenasiya waitikayoko, Jisesida amaitoka nisamitabo nesa lekaiyoko, aya wemidana maya yauha moliki liki numupito maya yowe. Sakiya ilimi-liki yowikiki opida maya Jisesida madonalo wehe liki kawasiki aya we maya mokololoma nala jikiki hulitayoko, Jisesida amaito maya limiye. ");
INSERT INTO yby_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Sa-iyokoya, Jisesimamoya elewole iki elebolawa maya elekoko aya wemidanama ipanelika, lihimakaya alo le huloetokoe, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Loko liyoko, monoka monawa api-napi ikaka we ayalo minabosiya dukadunuya nenahamu lihelae liki data etipa kiki sa-liki ele: ");
INSERT INTO yby_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Wewena mako ekahimamoya lihimate le huloletatibo ne. Omai makokolimoya lihima le hulokaka noiboma nenako, emoya upala leko yoweko Omaimidana asetakolo noliboya etamiye. ");
INSERT INTO yby_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sakiya data nieleyoko, Jisesimamo aha ukadunu elekoko edimo yamidana aya nenaha iyoko niele. ");
INSERT INTO yby_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wewena makolimoya lihimaka le hulikoe loko letiboya suwa nehe wati ga nehe yawaya ekahimamo mudaone. Sa-oneboya, suwa lobo monawaya elikatae loko mokoloka maya ohekoko wo loko enemane oko lo mamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Sa-oneboya, okulumauti we uti nemoya lihimatipo le hulokaka yowanu litubo elewoleyaki neimonetoka ne, loko lo bekadanaki yamidana monawa mudatae loko we ebilimidana sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nemokaho lobotoya sinokoko mokolokama ohekoko anu moloko wo. ");
INSERT INTO yby_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Loko liyoko, enemane oko muki wewenasida domuda lelei maya mokololama ohekoko wokaiyoko, aya wewena maya otopa adanaki Omaimidana epoka liki yamidana nesaya mudamudawo ada nesaya soto piyoko mudakune, liki lae. ");
INSERT INTO yby_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisesimamoya aku lemeko nohuda ilikaloka maya wavu-liki wewena nisiki li esa ikayoko, monoka lo beko ne. ");
INSERT INTO yby_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sa-loko yaloti nowidanaki maya, Alapasida ipala Liwae maya ehada takisi likaka numuku neyoko mudako-elokoko nemeke moloko niso liye. Loko liyoko, Liwae maya sinokoko Jisesiki magoina waiye. ");
INSERT INTO yby_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sa-iyoko, Liwaeda numudalau maya takisi ehada likaka we ito maloka lahelamibo nesa lolo ikaka niabo wewena minae liki data kikaka abo wewenaki magoina miniki nodenesa nabo ne. Mukiya Jisesida emesalo moliki wabo wewena minabo ne. ");
INSERT INTO yby_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sa-inayoko, Jisesiya takisi ehada likaka abo weki ito lahelamibo nesa lolo ikaka we minae liki data kikaka abo wewena malokaki magoina nodenesa ninayoko, Palasisi wewenasida monoka monawa api-napi ibitikaka wesiya mudaidikadanaki, Jisesida oluholale yuhasida sa-liki li be: I'i, emoya takisi likaka weki lahelamibo nesa lolo ikaka wewena malokaki nodenesa nenaha iyoko nonaiye. ");
INSERT INTO yby_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sa-liki layoko, Jisesimamoya elekadanaki koha moloko ga mako sa-loko lo biye: Edimoya saina jelamiki aha minabolasiya lusa wemuya ju lamae, saina delaibo wewenasigoya lusa wemu ju likaka niae. Nemoya wehe lominune liki likaka niabo wewenasidaya dilipe lalo etuwe loko lemamoe. Lihimanipoki wewenasidaya dilipe lalo etuwe loko lemobo maya ne, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jonida unala ipapala yuhaki Palasisi wewenaki monokamuye liki nodenesa mosikaka ae. Sa-niayoko, maloka wewenasiya wiki Jisesitoka loka iki maya Palasisi wewenaki ito Jonida unala ipapalale yuhakiya nodenesa monokamuye liki mosikaka niaboya, emoya unaka ipakale yuhaya mosamae. Nenaha iyokoe. ");
INSERT INTO yby_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sa-liki layoko, Jisesimamo koha moloko ga sa-loko lo biye: Mena huki molabo oluhoya iwelaleki magoina minatabo yulakaya emokumuye liki miluma eliki nodenesa mositabo nehe. Sakoya minamiye, aya mena hukatabo yulakaya magoina miniki nodenesa mosamikilae. ");
INSERT INTO yby_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mena ada iki mitabo wemidana iwelalesida dadeuti hipo itabo onawa maya alili etibo yupekamagoya milumala eliki nodenesa mosikilae. Yamidana makoko aweyaha iki unanele ipanele yuhasiya alikaya nemokumuya miluma eliki mosikilanako, olotiya mosamikilae. ");
INSERT INTO yby_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ito lawo-lawo ohotama no jiki li lasola amabo lawo-lawo maya hukiki li aseha lawolawolo moliki oto itabo nesa minamiye. Oto ikiki nokalawe jikadeko ohatama lawolawolimoya isulupa jekoko aseha lawolawoloti hikalekadeko lawolawoya golotokatiye. ");
INSERT INTO yby_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ito waeni no ohotama etehu alakala noiyoko aseha nogodau jitabo nesa minamiye. Waeni noyamo nogoda jeko potokoko waeni no hutili okadeko, aya nogoda maya nosamokatiye. Waeni no etehu alakala noiboya nogoda asehawau maya jamiki ohatamaugoya jikaka niae. Loko liboya asehawa weuteki ito ohatama weutekiya le makokoto molametudawo nenako, unala ipalale yuhasi ohatama weunipogo iki moliki itabo ne loko koha moloko gauti liye. ");
INSERT INTO yby_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Holi onawa makomauya Jisesima unala ipapalakiya kile mijaku nimoneyoko, unala ipalalesiya nodekumu delaiyoko, kile maya ulutiki ulawa maya heketiki nimi wae. ");
INSERT INTO yby_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sa-inayoko, Palasisi wewenahenasiya mudaikiki Jisesida maya sa-liki li me: Mudao, lemo holi onawateuma samudawo nesa liki unaka ipapakale yuhamasiya yowanu nileboya lahelamibo nesa lolo niae. ");
INSERT INTO yby_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Liki layoko, Jisesimamoya donoto leko sa-loko lo biye: Hapa yeikalaya uliki we napa Dewitima wewenalale yuhakiya monoka numuku maya yowiki saina mako lolo abo ne, liki luhuwa jebo nesa maya lepi-minaboya, monawaya elamiki nilahe. ");
INSERT INTO yby_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dewiti maya Omaimidana numudalau yowiyoko, Omaitoka jokila he mekaka we napa Apiyatalayamo Omaimidana omudalalo molabo beleti maya miyoko, Dewitiki magoina minabo wewenamakiya ona moliki naboma ne. Sakoya aya beletiya aha wewenasiya namitae, Omaitoka jokila hi mikaka wesigo natae liki elewole iki li huki-minabo maya neboya, monokamidana li huki-minabo gahenasiya wewenasida dilipitibo anu li opa itabo nesa minamiye. ");
INSERT INTO yby_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Loko lokadanakiya, kolo meko sa-loko lo biye: Holi onawamuye loko Omailimoya wewena lolo amibo ne. Holi onawaya wewenamuye loko soto pene. ");
INSERT INTO yby_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sa-oneyo, okulumauti we uti nemoya holi aholaya minonako, unanele yuhasiya holi onawauya lolo itabo nesaya nemo nesanego ne, loko liye. 23 Dut 23:25 25-26 1 Sam 21:1-6 26 Liv 24:9 ");
INSERT INTO yby_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","2","Yu makoya Jisesimamo monoka numuda mako ade uka jenebo we neboku yowekaiyoko, aya wemidana adela le petadeko maya holiguma nenako, obi yowanu letatune likadanaki ujapa iki minae. ");
INSERT INTO yby_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sa-niayoko, Jisesimamo ade uka jibo wemidana maya luwawateu sino-mino liyoko, sinaiye. ");
INSERT INTO yby_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Loko lokadanaki muki wewenasida maya sa-loko loka obetaiye: Holiguya wehe lonetibo nesa lolo okakalimoya wehe lonehe, ito lahelametibo nesa lolo okakalimoya wehe lone. Ito wewena kohaidokaka nesayahe, ito dilipe lalo okaka nesayae liye. ");
INSERT INTO yby_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Loko libo maya onoto lamiki eli hulikayoko, epalo molokaiyoko wenu nodelaidanaki eli lamabokumu Jisesi maya eke lokadanaki, adela uka jenebo wemamidana maya adeka peto liyoko adela petiyoko akuya woko wehe liye. ");
INSERT INTO yby_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sa-okaiyoko, Palasisi wewenamasiya nena nena oko kohatune likadanaki Helotida wewenala yuhakiya lowa je. ");
INSERT INTO yby_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sa-okaiyoko, Jisesi maya unala ipalale yuhamakiya nohutoka maya lemeyoko, Galeli numutokati wewenamakiya demesalo moliki leme. Saboya edimonipogo demesalo moliki lemamae. ");
INSERT INTO yby_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jelusalemu numutokati ito Judiya ebaku maloka numutokati ito Itumao ebatokati ito Jodani no yola helegalokati ito Taeya numutokati ito Sidoni numutokati wewenakiya Jisesikaho oko moloko ibo ga maya elikadanaki wavu-liki nisiki li esa iki aitokaya minae. ");
INSERT INTO yby_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sa-iyoko, Jisesi maya li esa abo wewenasiya ipisitabo nesa lekaiyoko, unala ipalale yuhasida maya liyoko noku lape makoya liki nisiki no ilikaloka maya molikayoko, yau maya yoweko minoko gahena wetome oko lo bituyo loko eliye. ");
INSERT INTO yby_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Muki wewenasida dilipe haka libokumuya aha niseko upaloka maya letudawolimoya lilime wati etibo ne, liki elikadanakiya, sa-etune likiki lahelamibo nesahena jelebo wewenamakiya muki nisiki li esa ayoko, noku lapemuya iwelalesidaya lo biye. ");
INSERT INTO yby_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sa-iyoko nenako, oloha lahelamabo dukau yowiki minabo wewenasiya Jisesida nimudadanaki amowa jiki emoya Omaimidana ipalama minane liki lika lika ae. ");
INSERT INTO yby_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sa-liki laboya, Jisesimamo emo monawala maya wetome iki li-lili monamitae loko lo hukobetoko ne. 9-10 Mak 4:1; Luk 5:13 ");
INSERT INTO yby_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisesi maya le bolau yowekoko, emo ukadunu elibo wewenasida maya ju liyoko nisiki li esa ae. ");
INSERT INTO yby_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Sa-ikayoko, emoki magoina minataboe loka, ito doli hekadeko monoka wetome iki li bitaboe loka, ito abuha-wowo bideko olohahena dukau minabo wewena dukauti kohaidiki doli hitaboe loka oko sa-iki yowanu litabo we 12-palasida dilipe eto eto okoko, dulinipoya aposolo wemae loko molabo ne. ");
INSERT INTO yby_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aya wesida dulinipo sa-iki minae: Saimoniya uliwa ohatama Pitae loko molaiye, ");
INSERT INTO yby_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ito Jebetida ipala Jemisite unala Jonite, aya wewenasidaya dulinipo le nupa oko Poanelekesiye lokoya lemo gateutiya oo pou lokaka we. ");
INSERT INTO yby_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ito Enduluwo, Pilipiyo, Batolomiyuwo, Matiyuwo, Tomasiyo, ito Alopiyasida ipala Jemisiyo, ito Tadiyusiyo, ito Saimoniya Lomu gamaniya le hulakolo sa-noibo we, ");
INSERT INTO yby_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ito Kaliyoti numutokati Judasiya mino-loko nowidanaki Jisesida mimi ibo we. ");
INSERT INTO yby_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisesi maya emo numudalaloka wiboya wewena wavu-liki li esa ikayoko nenako, nodenesa namae. ");
INSERT INTO yby_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sa-ikayoko, Jisesidamuya wewenalalesiya nei molone liki labo gaya elikadanaki adelo letune liki wae. ");
INSERT INTO yby_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sa-ikayoko, monoka monawa api-napi ibikaka we Jelusalemu numutokati nisebo wewenasiya sa-liki lae: Lahelamibo oloha mako uliwaya Pelejepulo loko nebo oloha maya ukalauya ne, ito olohasida we napanipomamoya ilime wati okaiyoko olohasidaya wewenasida dukauti kohaidoko doli hekaka noiye, liki lae. ");
INSERT INTO yby_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Liki labolawaya Jisesimamo alo elekadanaki, ju lo beko olohamidana elewoleyala alo asebetonebokumu koha moloko ga mako sa-loko lo biye: I'i, olohalimoya eimola unala ipapalalesidaya kohaidoko doli hekaka noibo nesa nehe. ");
INSERT INTO yby_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mika makokou wewenasiya luwaku sila ikiki mini yolaloka maloka itaboya elewole iki minamideko, aya ebatoya ametekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ito makoko yuhasiya auha likikihe ito sainama ikikiya mini maloka maloka itaboya elewole iki minamikilae. ");
INSERT INTO yby_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sa-onenako, Olohalimoya eimola unala ipapalalekiya auha likiki mini yolaloka maloka iki minataboya, elewole ametibo nenako, Olohalimoya elewole amoko hulikoko mino leso etibo ne. ");
INSERT INTO yby_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ito wewena makolimoya enemane oko adoha we makomidana numudalautiya yoweko uvaminala hipo oko lametiboto ne. Omutokoya aya wemidana ilo adelo nala jekoko alikaya yoweko litibo ne. Sakoya nala jekoko alikaya yoweko uvaminalaya lekolaiye loko liboya Olohamidana adelo nala jekoko weuna oluhosidaya kohaidoko doli hekaka noe, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Loko lokadanaki, sa-loko liye: Nemoya ga mako lo libituyo, elilo: Muki lahelamibo nesahena ito lahelamibo gahenaya wewenasida dupaloka leko letudawoya Omailimo aha le hulokaka anuwaya neboya, ");
INSERT INTO yby_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","we makolimoya Omai weuna oluholamuya lewo letowo oetatiboya, Omailimo lihimala huloetatiboto minamiye. Sa-etibo nenako, aya lihima maya aya wemidana upalalo minowa minowa oko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sa-loko liboya, Omai weuna oluhomidana elewoleyalaloti neyopa, oloha makolimoya Jisesida ukau lemeko ilime wati iyoko olohasida maya kohaidoko doli hekaka noibo ne, liki labokumuya sa-loko Jisesimamoya lo biye. 22 Mat 9:34; Mat 10:25 29 Luk 12:10 ");
INSERT INTO yby_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jisesida dolama unalamotakiya nisiki hetoka sini-miniki Jisesidamuya ju lae. ");
INSERT INTO yby_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sakiya ju nilayoko, Jisesida maya ilimi wego iki minabo wewenasiya sa-liki li me: Ele-minape: Dokale unakale maya nisiki hetoka miniki emokumuya ju nilae. ");
INSERT INTO yby_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Liki layoko, Jisesimamo donele unanele motamuya nilahe. ");
INSERT INTO yby_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Loko lokadanaki, ayalo minabo wewenasitoka maya wenu deloko mudalo, donele unamotanele yuha maya edimoya minaboyae. ");
INSERT INTO yby_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Omailimo libo galoya eliki emesalo molikaka niabo wewenalikaya donele oluho unamotanele yuha maya minaboyae, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisesi maya aku nohutoka maya lemeko mudaiboya wavu-liki wewena nisiki li esa ikayoko, noku lapeu maya yoweko no ilikaloka nedanaki muki wewena maya akeloka minayoko monoka wetome oko lo biye. ");
INSERT INTO yby_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sakiya minayoko, Jisesimamo koha moloko ga wavu-leko lo bidanaki makoya sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Elilo. Yuha nesa tili okaka we makolimoya yuha nesa tili ekolo wiye. ");
INSERT INTO yby_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mijakuka maya woko tili omo nowiyoko, maloka lemo anulo jibo maya namasi nesa eliye. ");
INSERT INTO yby_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Malokaya lemo ehada mupilalo mika asolasi neboto lemo jiboya, mika napa minamiboto nenako, enemane oko wileko yowiha, ");
INSERT INTO yby_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ho maya lidanaki aya nesa maya luhawa hana wamidanaki opateko alala miye. ");
INSERT INTO yby_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Maloka lemo lilihau jekoko wileko yowiha, lilihalimoya mi jemikaiyoko ihilawa jamiye. ");
INSERT INTO yby_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Malokaya lemo mika lalou jibolawa maya dowa loko wileko yowiye. Sakoya wileko yoweko yawa makolimoya ihilawa 30 jiye, ito makolimoya ihilawa 60 jiye. Ito makolimoya ihilawa 100 jiye. ");
INSERT INTO yby_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Edimoya dataki minune likima maya aya monawaya eli wehe lilo, loko liye. 1 Luk 5:1-3 ");
INSERT INTO yby_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Maloka wewena maya alo wiki suwikayoko, oluho unala ipalaleki maloka wewena magoina minabosikiya aya koha moloko gamuya loka itikayoko, sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Omailimoya ujapa olibetatibo onawamidana suna ibo gaya edimo elitae loko loneboya, hetoka minabolawasiya koha moloko gagoya elitae. ");
INSERT INTO yby_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yamuya Aesayamamoya ga mako sa-loko luhuwa jenebo ga maya edimotoka nisekolaiye: Domudalotiya mudaikaka nesa liki mudataha, ma mudai wehe lamikilae. Ito datadunuya aha elikaka nesa liki elitaha, ma eli wehe lamikilae. Duka li wili jamitaboya Omailimoya lihimanipoya le hulamideko aha minakilae. 12 Aes 6:9-10 ");
INSERT INTO yby_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisesimamoya le omeko unala ipalalesida sa-loko lo biye: Maya koha moloko lobo gamidana monawa eli wehe lamahe. Sa-ikiya maloka koha moloko gamidana monawa maya nena nena iki eli wehe litae. ");
INSERT INTO yby_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yuha nesa ihilawa tili okaka noibo welimoya monoka leko moneko tili noiye. ");
INSERT INTO yby_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yuha nesa ihilawa lemo anulo jibomidana iki minabo wewenasiya monoka maya eleko le madonipou molatune liki sa-inabo maya, Olohalimoya enemane oko niseko aya monoka maya hipo oko le hulokaka noiye. ");
INSERT INTO yby_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ito yuha nesa lemo ehada mupilalo jibomidana iki minabo wewenasiya monoka maya lahelepa iyoko enemane iki eliki li dukau molikaha, ");
INSERT INTO yby_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","dukauya luhawa le ilitamoko onawa minawasi minadeko, monokaya dukau nebokumuye liki kohaidi-liki wiki ulana molibitatabo onawalo maya enemane iki limiki udatabo ne. ");
INSERT INTO yby_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ito lilihau lemebomidana iki minatabo wewenasiya monokaya elitaha, ");
INSERT INTO yby_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma mikauti nesalimo eda delokaka noibo nesaya, ito ehadamu dumu helekaka noibo nesalimoya, ito aito-aitomidana nesalimoya dukau minoko dumu helekaka noibo nesalimoya dukauya minokadanaki, monokamidana maya jeko hitomikaiyoko. monoka ihilawa maya edimotoka soto pamiye. ");
INSERT INTO yby_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ito mika lalou lemo jibomidana iki minabo wewenasiya monoka maya li pilikiki liminayoko, monoka ihilawa maya edimotoka soto pekaka noiye. Maloka wewenasitokaya napa apulu oko jekaka noiye, ito maloka wewenasitoka maya muki jekaka noiye, ito maloka wewenasitoka wavu-leko jekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Loko lokoko koha moloko ga mako sa-loko lo biye: Leya wewena makolimoya lepa okoko sipa iwaukahe, ito somo ulauka molokoko jeko hitamekolaiye. Lepa okoko maya molokaka noibo ebatoka maya moladeko, muki ebatoka lameda lekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ayamidana oko Omaimidana suna onebo nesa maya woko tolowa ametiye. Alikaya soto pitibogo ne. Ito halukuka netibo nesaki asako soto pe suwekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Data golotonetibo wewenasiya maya nolobo gaya eli wehe liki elilo. ");
INSERT INTO yby_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sa-loko lokadanaki, edimoya maya galoya eli wehe liki elilo. Ga maya elitabo nesa leko Omailimoya monoka gaya libekolaiye. Ito yagoya minamiye. Leko isaloka yoweko libekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ito monoka dowa liki ujapa iki li-minatabo wewenasida maya Omailimoya ayaloya makoki le omeko bekolaiye. Ito monoka dowa liki ujapa amitabo wewenasiya ahago le-minupe liki litaha aku hipo okoko le eimolatoka molokadeko, ahanipo minakilae. 21 Mat 5:15; Luk 11:33 22 Mat 10:26; Luk 12:2 24 Mat 7:2; Luk 6:38 25 Mat 13:12; Mat 25:29; Luk 19:26 ");
INSERT INTO yby_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisesimamo ga mako sa-loko lo biye: Wewenaya Omaimidana monoka oholauya yowekakamidana monawaya sakoya ne: We makolimoya yuha nesa mikauya tili okadanaki minoko, ");
INSERT INTO yby_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","voya wavu-leko udokadanaki yamidana monawa muda wehe lamiyoko, yuha nesa maya wileko yoweko napa noiboya, ");
INSERT INTO yby_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","mikalimoya eimola lulu jeko wileko yoweko napa okaka noiye. Api oko potoko yoweko aila jekoko ihilawaya jekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sakoya ihilawa jeko halatoko lokaiyoko maya, leko natudawo onawa maya alili okaiye lokoko mida numuda litae loko doli hekaka noiye. 29 Joe 3:13 ");
INSERT INTO yby_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ga sa-loko le koloko liye: Omaimidana oholau witabo wewenamuya nena nesalo lo moloko letuwe. Ya nesamidana iki minae loko nenahalo maya koha moloko letuwe. ");
INSERT INTO yby_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ya mako uliwa masteti yamidana ihilawa suda liki minae. Aya nesa maya liki moniki tili ikili niayoko maya, muki yuha nesasida asebetoko lasomosolasi neboya, ");
INSERT INTO yby_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","tili ikayoko wileko yoweko napa-napa oko liwana napakiya yowekaiyoko, namahenasiya nisiki akawau maya numudanipo vikaka niae. ");
INSERT INTO yby_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisesimamo aya koha moloko gamidana wavu-leko alo elitabotoya monoka lo biye. ");
INSERT INTO yby_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ga mako lo bekolo noidanaki koha moloko gautigo lo beko mako alo elitabo nesa leko lo bamidanaki, eimola unala ipalale yuhakigo magoina minayoko yalogoya ga monawa lo soto moloko lo biye. ");
INSERT INTO yby_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aya yupeka ludaka maya Jisesimamo unala ipapalalesida maya noku lapeuma alo yola helega wetune, ");
INSERT INTO yby_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","loko lokaiyoko li esa iki minabo wewenasida maya hulibitikiki noku lapeu maya yoweko neyoko unala ipalale yuhasiya ilimi-liki yola helega maya niwayoko maloka wewenasiya noku lape makomauya yowikiki demesalo moliki wae. ");
INSERT INTO yby_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Sakiya niwayoko ahuhu napa-napa nisekoko no maya alahuka jeko hulo noku lapeu maya moloko nolimo waitekolo iboya Jisesi maya lemeko ulauka yeimaya madonaloya ya mako leko niseko madona jeikoko udoneyoko, ");
INSERT INTO yby_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","unala ipapalesiya ilimi sinikiki monoka ujapa wete yamalae, noku maya sima natudawo nesa noluniyo, emoya nenaha iyoko lemokumu elamoko aha minane liki lae. ");
INSERT INTO yby_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sa-liki layoko, Jisesi maya sinokoko ahuhumidana maya auha mekoko nomidana maya auha meko alahuka jamoko moletoko mino loko liyoko, lasi maya suwiyoko no maya apa jiye. ");
INSERT INTO yby_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sa-okaiyoko, unala ipalalesida maya auha beko nenahamu domoda wokaiye. Nemodamuya napa iki elewole iki data ki nemamahe, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Loko lokaiyoko, domodanipo adoha wokaiyoko, edimonipo wetome-katome iki sa-liki lae: Agae, maya aitomidana we nenako lasima nebo ahuhuma neboya emo gala maya eli leiyolae, liki lae. ");
INSERT INTO yby_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nohuda yola helegaloka woko Gelasa wewenasikuka maya hetiye. ");
INSERT INTO yby_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aya ebakukaya ukauya oloha lahelamibo nebo welimoya ehada numuku ono molikaka ebakuka nebototiya niseko anulo maya ne. ");
INSERT INTO yby_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aya welimoya ehada numukuya udokaka noiyoko, wewena malokasi adelo likiki liki nisiki seni nalalotiya adelo jeboya pasiye. ");
INSERT INTO yby_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Muki yupekaya adelo liki nisiki senilotiya ilo adelo etoha iki nala jikaka aboya, aya nala maya jeko hukoko le hulikaka iyoko, wewena makolimoya adelo litibo nesa lamiye. ");
INSERT INTO yby_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Muki yupekaya lubuka ito ho yowibotoka ehada numukuki ito bolaukiya minoko opa napa ga loko minokaka idanaki, ehadalotiya eimola upala maya huko nako oko minokaka iye. ");
INSERT INTO yby_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sa-okaka noibo we nenako, Jisesima noku lapeuti maya lemekoko nisiyoko, aya we maya hoto apulu oko Jisesida mudakoko lolosa jeko niseko Jisesida ilau maya apu-napu oko udokadanaki, i bola noheko, ");
INSERT INTO yby_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","10","amowa jeko sa-loko liye: Jisesiyo, Omai napamidana ipalalika, nenahalo lahelamibo nesa lolo onetakolo nonisene. Loko liyoko, Jisesimamo ulika ekahimae loko loka oetaiyoko, olohamamoya lemoya muki minudanako, ulineya Etipa minoe. Loko liyoko, Jisesimamo oloha lahelamibomidana uliwa noloko maya wemidana ukalautiya yoweko wamane loko libokumuye loko aya wemamoya Omaimidana owisalo noloko miluma yowanu nemametane loko lo hukowo loko emekeme ga lokadanaki aya ebaloti loli hametane loko imiya liye. ");
INSERT INTO yby_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Loko lokaiyoko, mudaibo maya jahena bolau matokaya yomi niki minayoko mudaikikiya, ");
INSERT INTO yby_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","olohamasiya loka loka iki jasida dukau loli hekadeko lemetune liki lae. ");
INSERT INTO yby_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Sa-liki layoko, Jisesimamoya ele bekoko doli heko hulo tu tauseni jasida dukau maya molaiyoko yowiki suwikiki lakiwa epaloti nisiki limiki nohuku jiki niki hutikiki heliki esa ae. ");
INSERT INTO yby_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Helikayoko, ja ujapalo wemasiya oli taoniloka ito numuda emesaloka maya wiki moniki wetome iki muki wewenasida maya li bikayoko, ");
INSERT INTO yby_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","muki wewenasiya aya soto pibo nesama mudatune liki Jisesitoka nisiki mudabo maya, olohasidaya ukauti doli hibo we maya olo jekaka ibo lawo-lawo maya olo jekoko gahena elekaka nesala maya wati oko neyoko muda-elikiki domodanipo wiye. ");
INSERT INTO yby_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Sa-iyoko, aya nesa mudabo wewenasiya olohasidaya ukauti doli hiyoko wiki jasida dukau yowikayoko jamasi wiki noku sima nabo nesamuya wetome iki li bikayoko, ");
INSERT INTO yby_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jisesikako aha netiboya alika sainahenanida mako le opa okatihe liki maya alo hulikoko wetiye liki emekeme ga lae. ");
INSERT INTO yby_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sa-liki likayoko, Jisesimamoya noku lapeu noyowiyoko, olohasida ukauti doli heko le hulaibo wemamoya Jisesiki magoina minasiye loko loka loka ibo neboya, ");
INSERT INTO yby_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jisesimamoya onoto lamoko sa-loko lo miye: Numudakaloka woko maya we napalimo emoda eke loetaidanaki sa-ogetaibo nesaya wetome oko wewenakalesida lo bo. ");
INSERT INTO yby_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Loko liyoko, aku wili jeko Tekapoli ebatoka widanaki, Jisesimamo lolo oetaibo nesamuya lo bekaiyoko, muki wewenasiya Jisesidamuya adoha eliki minae. ");
INSERT INTO yby_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sa-ikayoko, Jisesi maya noku lapeuma yowekoko aku ma helegaloka niseko akelo maya neyoko, muki wavu-liki wewena nisiki li esa ae. ");
INSERT INTO yby_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sa-ikayoko, monoka numuku we napa maya Jaelusiyo loko nebo welimo niseko ");
INSERT INTO yby_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jisesida maya mudakadanaki, niseko i bola heko emekeme ga sa-loko liye: Nemo olune lasola mako alo helekolo alili oko anada nohiyoko noloyo, sinokoko omuda lenetiye loko nisekoko adeloti maku mitane loko nonisoe. ");
INSERT INTO yby_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Loko lo mekaiyoko, magoinaya niwaiyoko, yalo li esa iki minabo wewenamakiya dupalo dupalo iki niwabokuya, ");
INSERT INTO yby_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","luwawanipouya mena makoya ukada anu meleke 12 oko wiyoko molowa molowa oko nebo mena ne. ");
INSERT INTO yby_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Muki lusalo wewenasiya lusa vitimi wayoko ehada bemo woko niseko iboya, aya nesa maya suwoetametibo nesa lekaiyoko, alika napa-napa nesa jeleko ne. ");
INSERT INTO yby_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sa-onebo nenako, aya menalimoya Jisesida gala maya elekoko wavu-liki wewena li esa iki niwabokuya Jisesida emesaloka maya nisekadanaki, ");
INSERT INTO yby_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jisesida upalalo jenebo nesalohe ito upalalohe lekoko haka letuyo loko ata elekoko upalo nesa atawaloka liye. ");
INSERT INTO yby_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sakoya ade liyoko, enemane oko aya oladala maya sepo jiyoko, sainane maya aloya suwiye loko ata kiye. ");
INSERT INTO yby_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sakoya sa-iyoko, Jisesimamoya abuha-wowola upaloti maya wokaiyoko elekoko mino wili jeko nemo nupaloya ekahimamo liye loko wewena wavu-liki niniseboku maya loka obetaiye. ");
INSERT INTO yby_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Loko liyoko, unala ipapalalesiya emoya wewena wavu-liki li esa aboku maya nemoda ekahikaho nupalo liye lape, liki layoko, ");
INSERT INTO yby_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ekahimamo lihelae loko mino wili jeko mudamo monibo maya, ");
INSERT INTO yby_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","aya menamamoya wewenasiya huma jenebo menamamo Jisesida upalo liye liki likatahe loko Jisesikaho sa-oetaibo nesamamuya omodala wokaiyoko ololo noidanaki akuya niseko aya nesamidana monawa maya wetome oko Jisesida maya lo meko suwiye. ");
INSERT INTO yby_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lo soto moloko lo mekaiyoko, Jisesimamoya sa-loko lo miye: Olunelika, nemodamu elewole oko eledawolimo ilime haka lokaiye. Mulukauka lahelepa ideko aya nesaka maya alo suetadeko dowa loko mino. ");
INSERT INTO yby_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Loko noliyoko, monoka ujapa wemidana numudalauti maya wewena maloka nisikiki sa-liki lae: Oluka maya alo helekaiyo, tisateya nenahamu osele anuya nisitiye. ");
INSERT INTO yby_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sa-liki layoko, Jisesimamoya gaya sa-liki labo maya ele hulokadanaki monoka ujapa wemidana maya sa-liki labomuya omodaka woko eke lamoko elewole okogo ata keko mino, loko lo miye. ");
INSERT INTO yby_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sa-loko lokoko wewena muki demesalo moliki wamitae lokoko, Pitale Jemisile unala Jonilemakogoya dilipe-loko wiye. ");
INSERT INTO yby_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sakoya dilipe-loko woko monoka numuku ujapa ibo wemamidana numudalau maya mudaiboya ga napa-napa liki wije nama liki witaga niheyoko mudaiye. ");
INSERT INTO yby_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mudakoko Jisesimamoya aya numuku yoweko ohaku le ilime sinatubone loko aka koko wije nama liki witaga nihebo wewenasida maya, nenahamuya sa-niae, aya olu yaitaya helamiye, aha omuda udonehao loko liye. ");
INSERT INTO yby_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sa-loko liyoko, ija napa itayoko muki wewenasida maya doli heko le hulo hetoka ikoko, aya olumidana dolaki aholaki ito magoina minabo wewenamakiya dilipe-loko aya olu udonebotoka maya yowiye. ");
INSERT INTO yby_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yowekoko aya olumidana maya adelo noleko emo galauti Talita, kumi loko liye. Yamidana monawaya lemo gateukati olu lasolao, sinatane loko noloe loko ne. ");
INSERT INTO yby_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Loko liyoko, aya olumamo enemane oko sinokadanaki anu moneko ne. Sa-iboya aya olumidana melekelaya 12-pala ne. Sa-iyoko nenako, muki wewenamasiya mudaikiki aiyo liki lae. ");
INSERT INTO yby_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sa-iyoko, aya nesamuya muki wewenasida maya wetome iki li bikatae loko li-lili monamitae loko lo hukobetaiye. Sakokoya aya olumidana maya nodenesa milo liyoko nodenesa liki nisiki me. ");
INSERT INTO yby_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisesimamo aya eba maya hulikoko eimola oto numudalaloka wiyoko, unala ipapalale yuhamasiya magoina wae. ");
INSERT INTO yby_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Wikiya holi onawa maya alili okaiyoko monoka numuku maya yoweko monoka lo beko neyoko, maloka wewenamasiya elikadanaki agae liki sa-liki lae: Maya welimoya ele wehe lokaka nesaya nakahauti elekoko niseko nolihelae. Maya welimoya oliwaki elewole nesaya nakahaukati le soto molokaka noihelae. ");
INSERT INTO yby_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Lemoya monawala ele-minune. Emoya numuda vokaka wemidana ipala maya ne, ito Meleda ipala maya neboya, Jemisile Josile Judasile ito Saimonile yatonipo maya ne, ito emo olu emonalate maloya minikaka nianako, yatokaya lemokidana we maya ne. Sa-liki laboyamo eda delokaiyoko, Jisesimamoya sa-liki labo ga maya elekoko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nemoki maloka Omaimidana epaloti ga lokaka wesida uliteya pou loko muki numuto namato wetiboya, lemo oto ebate ito lemo wewenatesitoka lemoda numudateukaya lulite minametibo ne. ");
INSERT INTO yby_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Loko lokadanaki, yaloka maya Omaimidana abuha-wowola le soto molatuwe loko sa-ibo maya eda elokaiyoko hulikoko, saina delaibo wewena malokasidagoya adeloti sisiwanipo jebetoko dilipe haka liye. ");
INSERT INTO yby_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sa-iboya elewole iki data ki mamabokumuya eliyoko edala elaiye. 4 Jon 4:44 Sa-ikayoko, Jisesimamoya aya numudala maya hulikoko moneko numuto namato monoka lo beikaka oko ne. ");
INSERT INTO yby_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sa-okadanaki, unala ipalale yuha 12-pala maya dilipe nupa idanaki edimoya moniki oloha lahelamibo wewena dukauti kohaidiki doli hitae loko elewoleya beko lowe lowe oko doli nohidanaki sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Anu witabotokaya sainahena mako lamiki akusagola dadeu likiki wilo. Beleti lamiki, ito asa owoya uka jamiki, ehada owotipo maya lamiki, ");
INSERT INTO yby_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","dilo suya jiki, olo jikaka dupalo nesaya lowe olo jamiki aha muki nesatipoya hulikiki wilo. ");
INSERT INTO yby_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Loko lokoko sa-loko lo biye: Numuda makomauya yowikiki maya ayauya mini-liki wikiki aito numutokaya wilo. ");
INSERT INTO yby_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ito numuda emesa makomalotiya dilipi wati amidekoma, ito gatipo elamidekoma, aya numuda eba maya hulikiki huka biki dilotiya mumusopa hopo i hulikiki wilo. Sa-itaboya, Omailimo emesalo molamitabo wewenasidaya miluma yowanu bitibo ne liki elitae. ");
INSERT INTO yby_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Sa-loko lo bekaiyoko, wikiya wewenasida maya duka li wili jitae liki li soto moliki li bikiki, ");
INSERT INTO yby_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","wavu-liki oloha wewenasida dukauti maya kohaidiki doli hiki ito saina delaibo wewenasida maya netupa hilibitiki dilipi haka haka limi wae. 8-11 Luk 10:4-11 11 Apo 13:51 13 Jem 5:14 ");
INSERT INTO yby_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sa-ikayoko, awa maya hutili oko muki ebakuka moneko ulilaki we Helotima nebotoka wiyoko eliye. Aya yupekaya maloka wewenasiya Jisesidamuya sa-liki likaka ae: Joni noku udobetokaka we maya helenebokuti sinokoko oliwaki anehena aito-aitomidana le soto nomolaiye. ");
INSERT INTO yby_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Liki layoko, malokasiya Ilaija maya aku okulumauti limibo ne liki layoko, malokasiya hapa yeikalaya Omaimidana epaloti ga wetome ikaka weuti makomanipoya ne liki likaka aboya, ");
INSERT INTO yby_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helotimamoya Joni maya enola hukobo wemamoya aleuti sinokoko moneko aya nesa lolo okaka noihe loko ata kiya. ");
INSERT INTO yby_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Loko ata kibomidana monawaya sakoya ne: Hapa yeikalaya Heloti maya yatola Pilipida menala Helodiyasida maya hipo oko liyoko, Jonimamoya yatokada menala hipo oko ledawoya wehe lamiye loko lo-loko wiye. Sa-loko liyoko, Helotimamoya menalada ukau yowe hilekoko we mako doli hekaiyoko wiki Jonida maya adelo liki nisiki nala numuku hulitae. ");
INSERT INTO yby_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Sa-iyoko, Helodiyasimamoya epalo molokaiyoko, Jonida maya koha helituyo loko ata kiboya, Joniya lihimala minamibo we ito monoka we nenako, kohatuboya Omailimo nenaha onetatihe loko omodala wokaiyoko, Helotikahoya ujapa lalo nesa oetainako lokoko Helodiyasimamoya Jonida maya kohatibo nesa lamiye. Jonimamoya muki yupeka libo gamuya Helotimamo ata lowe kiboya, Helotida upauka lahelepa ibo gagoya liye. ");
INSERT INTO yby_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sakoya nedanaki, Heloti maya dolakaho etaibo onawama aku data kebo onawa nisiyokoya, muki duliki wehena ito lowa ujapalo wehena ito Galeli mikauka wewena napawakiya dilipe nupa okadanaki, nodenesa ataina iyoko yauya nisiki niki minayoko, Helodiyasimamoya Jonida maya kohatibo onawa le alili molaiye. ");
INSERT INTO yby_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sakiya nodenesa niki minayoko, Helodiyasida oluwa maya yoweko domudalo maya meleke liyoko, mudai lahelepa ikayoko, ulilaki we napalimoya aya olumidana maya meleke dowa loko lekaniyo, saina mako elonetibo nesamuya lideko imituwe. ");
INSERT INTO yby_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Loko Omaimidana omudaloya lo hukoko emoya sainamamuya letadawo nesaya aha emekoloe, ito nemo ujapa nobo mikamukiya letadawoya hukoko malokaya emo ujapa oo loko emekoloe. ");
INSERT INTO yby_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Loko liyoko, aya oluma hetoka lemekoko dolada maya ujapa wemamoya sa-loko lokainako nenahamu nelone loko letuwe loko liyoko, dolamamoya sa-loko lo miye: Aloya helekaiye loko elituwe loko noku udobetokaka we Jonida enola maya hukoko madona nimitane loko lowo. ");
INSERT INTO yby_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Loko lo mekaiyoko, aya olumamo enemane oko uliki we napama nebotoka yowekoko sa-loko loka oetaiye: Noku udobetokaka we Jonida madona maya olotiya hukoko lapeu moloko leko niseko nimitane loko noloe. ");
INSERT INTO yby_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Loko liyoko, uliki wemamoya eliboya eda iboya, aloma Omaimidana omudalo lo hukokobo maya nenako, ito lesa moloyoko nisiki minabo wewenasida domudalo lo hukonako loko elekadanaki ");
INSERT INTO yby_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","enemane oko imi we mako leko oli hekaiyoko, nala numuku maya woko Jonida enola maya hukoko, ");
INSERT INTO yby_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","lapeu maya moloko leko niseko aya olumidana miyoko. leko woko dolada maya miye. ");
INSERT INTO yby_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sa-okaiyoko Jonida unala ipalale yuhamasiya aya ga maya elikadanaki wiki nala numukuti onowa maya liki wiki ehada numuku molitae. 14 Mat 16:14; Mak 8:28; Luk 9:19 ");
INSERT INTO yby_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposolo maya lowe lowe oko doli hibototi maya aku nisiki Jisesi nebotoka maya li nupa ikiki yauka moniki numuto namato sabo nesahenamamuya wetome iki Jisesida maya li miki suwayoko, ");
INSERT INTO yby_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","wewena muki maya wiki nisiki ayoko nodenesa natabo onawa minamiyoko, Jisesimamoya sa-loko lo biye: Lemotegoya ametoka woko lasola ma mino aso jeletune. ");
INSERT INTO yby_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Loko lokaiyoko, edimonipogoya noku lapeu maya yowikiki wiki ametoya wae. ");
INSERT INTO yby_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sakiya niwayoko, muki wewenasiya mudaidi wehe likadanaki, muki muki taonilokati maya lolosa jiki wiki omutiki yalo maya hetae. ");
INSERT INTO yby_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sa-iki noku lapeu maya wiki hetikadanaki, wavu-liki wewena li esa iki minayoko, Jisesimamo oloto lemeko mudaiboya, sipisipi ja ujapa wenipo minamiyoko minabomidana iki minayoko mudaidokoko edimokumu ukala hiyoko, muki gahena maya wetome oko lo bebe oko ne. ");
INSERT INTO yby_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sakoya lo bebe iyoko, miniki ho maya lemekaiyoko, oluholale yuhamasiya Jisesitoka maya nisiki sa-liki lae: Maya ameto maya minuniyoko onawa maya aloya suwokaiyo, ");
INSERT INTO yby_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","doli hideko wiki numudanipo lasolaukatihe napaukatihe nodenesanipo meina hitae. ");
INSERT INTO yby_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Liki layoko, edimo laboto donoto leko edimotipoya nodenesa biki nalowo loko liyoko, unala ipalale yuhamasiya sa-liki li me: Ehada owo makokolotiya beleti meina hekoko betudawolimoya woko aya wewenaloya kohametibo nesa lekaiye. ");
INSERT INTO yby_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Liki layoko, Jisesimamo sa-loko loka obetaiye: Edimotokaya beleti nenakima nehe, wiki mudalo loko lokaiyoko, wiki mudaikiki nisiki sa-liki lae: Beleti lade maloka suwiyokoki loku lawaha libo lowekiya ne. ");
INSERT INTO yby_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Liki likayoko, aya wewenasida maya hi letika hi letika iki ohatama ohulo maya minatae loko lokaiyoko, ");
INSERT INTO yby_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","hiki letabolawaya 100 wewena minae, ito mini-liki lemebolawaya 50 wewenaya sa-iki minae. ");
INSERT INTO yby_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sakiya minayoko, lade maloka suwoko beletimaki ito lawaha lowemakiya lekoko omuda hulo okulumauka moloko Omaimidana epoka lokoko aya beleti maya posekadanaki wewenasida maya ona moliki bitae loko unala ipalale yuhasida maya bekadanaki, lawaha lowemaki muki wewenasi natae loko ona moloko biye. ");
INSERT INTO yby_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sa-okaiyoko, yalo li esa abo wewena maya niki niki ohumanipo okaiyoko, ");
INSERT INTO yby_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","lumawa nebolawaya li nupa iki manoda lape 12-palaya waitiyoko li molae. ");
INSERT INTO yby_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ito aya nodenesa nabo wewenaya 5 tauseni weya minae. Menakipa oluhoki lepamune. 34 Nam 27:17; 1 Kin 22:17; 2 Klo 18:16; Iji 34:5 34 Jek 10:2; Mat 9:36 ");
INSERT INTO yby_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sakiya nikiki minayoko, muki wewenasida maya doli heko hulo numudanipoloka mola mola noidanaki, unala ipalale yuhasida maya noku lapeu maya yowikiki Betiseda numutoka omutiki witae loko doli hiye. ");
INSERT INTO yby_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sakoya muki wewenasida maya depoka loko doli hekadanaki, emo maya bola makomauya Omaimitoka omuda likakolo yowiye. ");
INSERT INTO yby_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sa-noiyoko, lubu maya jekaiyoko, unala ipalale yuha maya wiki wiki no luwaku maya niwayoko, Jisesi maya eimolago no akelo nedanaki mudaibo ");
INSERT INTO yby_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","maya lasi napa napalimo nisekoko noku lape maya domudalokati leko dipisoko leko nisekolainako likadanaki no kohaikaka oijoloti maya noma kohaiwa kohaiwa niayoko, okululuwa maya nohokiyoko Jisesima no mupilalo maya anu moloko woko edimo minabotoka maya hetiye. Sakoya niseko unala ipalalalesidama asebetatibo nesa leko ");
INSERT INTO yby_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","no mupilalo maya nonisiyoko muda-elikadanaki, oloha mako nonisiye likiki muki unala ipalale yuhamasiya domodanipo adoha wokaiyoko opa ga lae. ");
INSERT INTO yby_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sa-inayoko Jisesimamo enemane oko sa-loko lo biye: Domoda wamideko, mulutipo lepa hideyo, nemoma nonisoyo. ");
INSERT INTO yby_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Loko lokadanaki noku lapeu maya yowekaiyoko, lasi maya suwiboya, ");
INSERT INTO yby_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","nodenesa 5 tauseni wewenasida biboloti Jisesida elewolelamidana monawa maya data golotamiyoko eli wehe lamiki aha epoka liki aiyo waiyo liki minae. ");
INSERT INTO yby_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sakiya wiki yola helegaloka Genesaleti ebatoka wiki hetikadanaki, noku lape maya li ilikaloka moliki nala jikadanaki, ");
INSERT INTO yby_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","noku lapeuti maya ekimi lemeyoko, muki wewenasiya enemane iki muda-eli wehe likadanaki, ");
INSERT INTO yby_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","lolosa jiki numuto numuto wiki suwikadanaki, saina delaibo wewenasida maya dilipi mokololo molikiki Jisesi maya nebo numuto numutoka wae. ");
INSERT INTO yby_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Minabokuti minabokuti taoniloka ito numuda lasolaukati saina lasolaki napaki delaibo wewena li esa ikaka ebatoka maya dilipimi molikadanaki sa-liki li me: Upakalohe ito aha lawolawokalohe dadeloti li elikiki haka litae. Liki loka loka iki likayoko, asaiki lebo wewena maya haka liki suwae. ");
INSERT INTO yby_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Palasisi wewenahenaki ito Jelusalemu numutokati monoka monawa api-napi ibikaka abo wewenahenakiya Jisesi nebotokaya nisiki li esa ae. ");
INSERT INTO yby_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Sa-niayoko, oluholale malokasiya dade maya nokalawe amiki nodenesa ninayoko mudae. ");
INSERT INTO yby_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Palasisi wewenaki ito Juda wewena malokakiya lahelamo okatune liki latanipolesi labo galoya elikikiya dade maya wavu-liki nokalawe amikima nodenesa maya namae. ");
INSERT INTO yby_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ito maketiloti meina hiki liki nisebo nodenesayaki nokalawe iki uluwitikigo nikaka ae. Ya sabogoya minamiye. Aito aitomidana nesa lolo ikaka niabo ne. No odahena ito somohena, lapehena, ito sipakiya lukateukaya huma jeko lahelametiye liki nokalawe ikaka aboya latanipolesi liminaboto emesalo moliki lolo ikaka abo ne. ");
INSERT INTO yby_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sa-ikaka niabo nenako, Palasisi wewenamaki ito monoka monawa api-napi ibikaka wewenamakiya Jisesida oluholalesiya dade nokalawe amiki nodenesa ninayoko mudaikiki Jisesida maya sa-liki loka itae: Oluhokale yuhasiya lemo latatele monawanipo maya li-minamikili nenahamuya hulikae. Nodenesa natune liki dadeya nokalawe ikiki namaha dukanipoya li huma jikaka niae. ");
INSERT INTO yby_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Liki layoko, Jisesimamoya sa-loko lo biye: Depa ulumatipo lowe nebo wewena yamalae Aesayakahoya iha hukoko libo ga maya wehe loko edimokumuya lonebo maya ne. Omailimo libo ga sa-loko luhuwa jenebo maya ne: Maya wewenasiya depadunugo nuline li sawa jikaka niaboya, dukanipo nemotoka molamiki moli hoto i-minae. ");
INSERT INTO yby_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wewenasi Omaimidana gala nehe likili aha maya mikau wewenasida ganipo li bikaka i-miniki suwa nesa liki lipi nimikaka niae. ");
INSERT INTO yby_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Edimoya Omailimo libo ga maya li hulikiki edimotipo ma mikau wewenasi labo gamagoya li-minikaka niae. ");
INSERT INTO yby_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Loko lokadanaki sa-loko lo biye: Edimoya latatipolesida ganipo eletune liki Omailimo lo hukolibetaibo ga maya li demesaloka hulikaka niaboya wehe libo nesa lolo une liki likaka niahe. ");
INSERT INTO yby_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesemamoya dokako ahokakosida ganipo eleko le sino. Ito wewena makolimoya dolako aholakosida dupaloka lahelametibo ga lo molatiboya oijo mideko helekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Loko liboya, edimosiya sa-liki likaka niae: Wewena makolimo dolako aholakosida nasahili obetatuwe loko sa-iboya kolopani nesa lolo okaiye. Yamidana monawaya Omaimidana alo mekoe. ");
INSERT INTO yby_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Loko letibokumuya edimosiya dolako aholakosida nasahili obetatibo anuwa maya hiki li likaka niae. ");
INSERT INTO yby_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Edimoya sa-ikadanaki Omaimidana gala maya wasa jikiki edimotipo ahotipole dotipolesida ganipo maya li sawa jiki li-minikaka niae. Ito yagoya minamiye. Muki ayamidana nesago lolo ikaka niae. 6 Aes 29:13 10 Eks 20:12; Dut 5:16; Eks 21:17; Liv 20:9 ");
INSERT INTO yby_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sa-lokoko muki menakipasida maya ju liyoko nisiki li esa ikayoko, nemoya wehe loko lo libekoloyo, elilo. ");
INSERT INTO yby_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Niki mikili ikayoko ohumatipou lemekaka noibo nesalimoya duka le huma jametibo ne. Depauti yowekaka noibo nesalimoyago duka le opa etibo ne.  ");
INSERT INTO yby_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Edimoya dataki minune likima monawaya eli wehe lilo. ");
INSERT INTO yby_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Loko lokoko muki wewenasida maya hulobetokoko le numuku yowiyoko, unala ipalale yuha maya aya koha moloko libo gamuya loka itikayoko, sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","I'i, edimoya asaiki data golotamibo minahe, ito ga monawa maya eli wehe lamahe. Sainahenaya nokuniyoko enoteu lemeko le ohumateu lemekaka noibo nenako, ohumatipou lemekaka noibo nesalimoya duka le opa amiye. Loko liboya nodenesa mukiya nokaka nesagoya ne loko liye. ");
INSERT INTO yby_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Loko lokadanaki, makoma sa-loko lo biye: Depauti yowekaka noibo nesalimoya duka le opa napa okaka noiye. ");
INSERT INTO yby_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wewenasiya lahelamibo data kikaka niabo nesaya, ukele ito anu napalo monikaka, ito wewena kohaidi helikaka, mena ukele okaka, ito we ukele okaka, ");
INSERT INTO yby_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","muda lalo-talo okaka, ito lahelamibo nesa lolo okaka, dokepa jekaka, ito hokoliya ito mesaha jekaka, ito ga pelesa jekaka, dupa liki yowi yowi ikaka, yogo-yogo jekaka, ");
INSERT INTO yby_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","yatoka lahelamibo nesa nolepobolimoya dukauti yoweko dilipe opa napa okaka noiye. ");
INSERT INTO yby_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sa-lokoko Taeya numuda ilikalokaya woko numuda makomauya yoweko saina lolo ibo nesahenamuya elamitae loko halukoko lolo etuwe loko eliha, haluketibo nesa lolo amiye. ");
INSERT INTO yby_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ya numutoya mena makomidana oluwaya oloha makolimo ukalau yowekoko ilime opa napa okaiyoko, aya menamamoya Jisesidamuya gala layoko elekoko enemane oko woko Jisesida iguka maya i bola hiye. ");
INSERT INTO yby_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aya menaya Juda mena minamiye, hetoka menaya Poinikiya ebaya Siliya mikauka soto pibo menalimoya oluwada ukauti maya oloha lahelamibo mako neboya kohako oli hitane loko loetaiyoko, ");
INSERT INTO yby_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jisesimamoya Isilaelo wewenasiya Omainipomidana makula omutiki li litabomuya elenedanaki koha moloko ga mako sa-loko liye: Oluhotipolesida nodenesanipoya hipo ikiki huli ulasida bitaboya wehe laminako, oluhotipolesiya omutiki niki ohumatipo itae. ");
INSERT INTO yby_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Loko liyoko, aya hetoka menamamo elibo maya eimolakiya Omaimidana makula litibomuya ata elekoko, we napalika, wehe loko lokaniyo, nemo ma letuwe. Nodenesa nokaka namabetalotiya oluhosi niki lanawa hulayoko lemo jiboya ulasi nesa lolo okaka noiye. ");
INSERT INTO yby_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Loko liyoko, Jisesimamoya sa-loko ladawomuya epoka loyo, wili jeko numudakaloka wo, oloha lahelamibomamo olukada ukalauti maya alo huloetokoko lemeko wokaiyo. ");
INSERT INTO yby_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Loko lokaiyoko, woko numudalau mudaiboya oloha lahelamibo maya alo oluwada hulotokoko ukalauti maya lemeko wokaiyoko sipalo udoneyoko mudaonebo ne. ");
INSERT INTO yby_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sa-okaiyoko, Jisesimamoya Taeya numuda maya hulikoko wili jeko Sidoni numuda maya aseko Tekapoli numuda maya aseko okoko le Galeli nohuda ilikaloka maya woko hetiye. ");
INSERT INTO yby_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Woko hetokaiyoko, nei we mako epa uluma le wilijenebo weya Jisesi maya adeloti sisiwa jetadeko wehe letiye liki ilimi-liki nisikayoko, ");
INSERT INTO yby_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","wavu-liki wewena li esa abokuti maya ilime aitoloka moloko edimonipogoya minaiyoko, ade ilehaladunuya atau hekadanaki etehu o molokoko epa ulumalo ade nolidanaki, ");
INSERT INTO yby_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","okulumauka nomudako sa-loko lo miye: Epata. Yamidana monawaya lemo gateutiya golotideyo. ");
INSERT INTO yby_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Loko liyoko, atala maya golotoko ga lalo liye. ");
INSERT INTO yby_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sa-okaiyoko Jisesimamoya li li-lili monamilo loko lo hukaibo maya nene liki liki liki mone. ");
INSERT INTO yby_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Edimoya ayo wuiye liki minadanaki sa-liki lae: Muki nesaya lolo iboya dowa lokogo lolo okaka noiye. Data molaibo wewenasida maya le golotobetokaiyoko gahena elikaka niae. Ito depa lagoli ibo wewenasidaya le golotobetaiyoko gahena likaka niae, liki lae. ");
INSERT INTO yby_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aya yupekaya wewena wavu-liki nisiki li esa ikaboya nodenesanipo minamiyoko, Jisesimamoya unala ipalalesidama ju loko sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Wewena muki maya nodenesanipo namiki nemoki magoina miniki loweki makoki yulaka moneyoko ganipo elekoyo. ");
INSERT INTO yby_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nodenesa namabotoya numudanipo hoto maya nenako, numudanipoloka doli hituboya anulokaya domuda nana vekolaiyoko noloyo. ");
INSERT INTO yby_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Loko liyoko, unala ipapalesiya numudahena ito mijahenaya minamibotoya nena nenako maya nodenesa nakahauti ohu jeko leko niseko beko natune. ");
INSERT INTO yby_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Liki layoko, Jisesimamo edimoya beleti nenaki li-minae loko loka iyoko, 5 le-minune liki lae. ");
INSERT INTO yby_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Liki likayoko, Jisesimamoya muki wewenasida maya mikalo minalo liyoko mikalo minikayoko, aya beleti 5 maya lekoko Omaitoka epoka lokadanaki, posekadanaki unala ipapalasida ona moliki wewenasidama bitae loko biyoko liki moniki ona moliki yalo minabo wewenasidama be. ");
INSERT INTO yby_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Lahawama asola minokaiyoko, yamuki Omailoka epoka lokadanaki mauya ona moliki bilo loko lo biyoko sabo ne. ");
INSERT INTO yby_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wewenamasiya niki niki ohumanipo okaiyoko, lumawa lana-hana nebolawaya manoda lape 7 owa jiki waitokaiyoko li molae. ");
INSERT INTO yby_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Aya nodenesa nabo wewenaya 4 tauseni wewena miniki nae. ");
INSERT INTO yby_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sa-ikayoko, numudanipoloka doli he molokaiyoko wikayoko, unala ipalekiya enemane iki noku lapeu maya yowikiki li Talamanuta numutokaya wae. ");
INSERT INTO yby_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wiki yaloka maya minayoko, Palasisi wehenamasiya nisikiki Jisesilekiya lowa moila hikadanaki, okulumauti we netihe, ito ma mikauti we netihe mudatune likiki, ohumanau hiki oliwaki nesahenama le soto moladeko mudatune liki layoko, ");
INSERT INTO yby_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisesimamoya mudaidaibo maya wehe lamiyoko, sa-loko lo biye: Edimoya saina jelaibo wewenasida dilipe dowa loyoko muda-elikadanaki oliwaki elewole nesa mako le soto moloyoko mudatune liki nilaboya, nenaha iyoko nilae. Sa-iki nilaboya, wehe loko lo libituyo, elilo: Maya weya elewole nesa mako le soto moloyoko mudamikilae. ");
INSERT INTO yby_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Loko lokoko akuya aya wewenasida maya hulobikoko unala ipalalekiya le ma helegalokama nisiye. 11 Mat 12:38; Luk 11:16 12 Mat 12:39; Luk 11:29 ");
INSERT INTO yby_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sa-ikikiya beleti makoya liki witabo nesamu data molokaiyoko hulikiki wayoko, beleti makokogoma noku lapeu maya aha ne. ");
INSERT INTO yby_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sa-iyoko, Jisesimamoya Palasisi wewenaki Helotimaki suwa-sawa monawanipomu koha moloko gaukatiya data leko sa-loko liye: Palasisi wewenaki ito uliki we Helotikiya ehe, lulu jekaka noibo nesanipolimoya kohaidokatiyo. ");
INSERT INTO yby_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Loko liyoko, unala ipalalesiya beleti lulu jekaka noibo nesamuya nolihe likigo data kiki edimonipoloka ligi hagi iki sa-liki lae: Beleti maya lata molaiyoko hulikoko nisudawomu liye, likigo minae. ");
INSERT INTO yby_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Liki labo galimo ataloka nisiyoko elekoko sa-loko lo biye: Edimoya beleti hulikoko nisudawomuya liye liki nenahamu nilae. Aijo maya nodenesa wavu-leko wewenaki minoko le soto molobotoka maya mudaikaboya, monawa eli wehe lamahe. Edimoya datauya owaha golotamiye. ");
INSERT INTO yby_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Domudatipolotiya mudamahe. Datatipo yaitaya neboya, molokaiyoko sahe. ");
INSERT INTO yby_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wewena 5 tauseni wemuya beleti lade maloka suwiyoko beletiguti maya posekoyoko niki ohumanipo okaiyoko, lumawa manoda lape nenakima waitiyoko li molae. Loko liyoko, edimosiya onoto liki 12-pala ne liki lae. ");
INSERT INTO yby_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sa-liki likayoko, wewena 4 tausenisida beleti 7-pala boyoko niki ohumanipo okaiyoko lumawa aka iki manoda lape nenaki jiki waitokaiyoko li molabo ne. Loko loka iyoko, edimosiya 7-pala ne liki lae. ");
INSERT INTO yby_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Liki likayoko, yalo maya mudai-minabo maya neboya, omutoko lolo olibetobo nesakidana oko aku aha lolo etubone liki owaha eli wehe lamiki nilahe, loko liye. 15 Luk 12:1 18 Jel 5:21; Iji 12:2; Mak 4:12 ");
INSERT INTO yby_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sakiya wiki Betiseda numutoya wayoko, omuda likonebo we makoya ilimi-liki Jisesima nebotoka nisiki adeloti le pana ketatiye liki ilimi-liki nisiki hui-pui ga lae. ");
INSERT INTO yby_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Likayoko, aya wemidanama adelo leko numuda lekaka lemeko etehuma oko adelo molokoya omudalalo maya hiletokoko adedunu le eleko sisiwa jetaidanaki sainahenama nomudape loko loka oetaiye. ");
INSERT INTO yby_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Loko loka oetaiyoko, aya wemamo omudala maya pana kekoko wewena nimoneyoko nomudaidoboya, jakidana iki neyoko nomudaidoe. ");
INSERT INTO yby_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Loko liyoko, akuya adeladunu omudalalo sisiwa jetokaiyoko, yaloti maya muki nesa maya muda kolosoko mudaoe loko liye. ");
INSERT INTO yby_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sa-okaiyoko, Jisesimamo aya wemidanama oli heko numudalaloka huloko, woko numuda ebatokaya omutoko wamo loko lo miye. ");
INSERT INTO yby_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisesimamo unala ipalalesidama dilipe-loko Sisaliya ebakuka uliki we Pilipida ulilalo ebatoya wiki muki numuto namato wae. Sakiya anuloka niwikiya unala ipalalesidama sa-loko loka obetaiye: Muki wewenasiya nemokumuya ekahima ne liki likaka niae. ");
INSERT INTO yby_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Loko liyoko, emodamuya noku udobetokaka we Joni maya akuya soto peminane liki nilayoko, ito malokasiya Ilaija maya hapa okulumau yowenebo we maya aku lemeko minane liki nilayoko, ito malokasiya hapa yeikala Omaimidana epaloti ga likaka weuti maya makomanipo sinokoko minane liki likaka niae, liki lae. ");
INSERT INTO yby_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Liki layoko, akuya loka obetoko edimosiya nemodamuya ekahi maya ne liki likaka niae loko liyoko, Pitamamoya emoya Omailimo olisauti lilimitiye loko lo mololetaibo we maya minane. ");
INSERT INTO yby_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Loko liyoko, Jisesimamo wehe loko lokaniyo, wewenasida maya ya wema ne liki wetome iki li bamilo loko lo hukobetaiye. 28 Mak 6:14-15; Luk 9:7-8 29 Jon 6:68-69 ");
INSERT INTO yby_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sa-okaiyoko, aya yupekaya ga mako sa-loko lo soto moloko api-napi oko lo biye: okulumauti we uti nemodaya muki monoka monawa api-napi ibikaka weki ito Omaitoka jokila hi mikaka we napaki ito ujapa wesikiya mudaneli hulikiki miluma nesa linitiki kohaneli helikadeko, onawa loweki makokiya minokoko hele-minatubokutiya aku sinakoloe. ");
INSERT INTO yby_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Loko lokaiyoko, Pitamamo olisauti ilimetibo weya helamekolaiye loko ata je-minoko osele ga lane loko auhala miboya, ");
INSERT INTO yby_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jisesimamo mino wili jeko maloka unala ipapalasida maya mudaidokoko sa-loko Pitada auhala miye: Emoya wewenasi datauti likaka niabo gama lokaninako, Omaimidana gala maya elamoko lokaniyo, emoya Olohakidana welika mino oli o. ");
INSERT INTO yby_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Loko lokadanaki muki wewenaki ito oluho unala ipapalalesidakiya ju lo beko sa-loko liye: Wewena mako nemo nemesalo molatune likima dupamo elitibo nesamu eli hulikiki wiki miluma nesa li ohilibitiki kohaidi helitabomuya eliki oli ibamideko eli hulikiki nemoda nemesalo molalo. ");
INSERT INTO yby_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ito wewena malokasiya dukanipo liki imiya likiki minataboya dukanipo opa etibo ne. Ito wewena mako nemokumuye liki ito gawa lalowamuye liki duka wina itaboya elewole depa mutiwa likilae. ");
INSERT INTO yby_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ito wewena malokasiya ma mikau nebo nesa mukiya li suwikiki wiki edimonipo dukanipo woko opa oko leso etiboya, aya ma mikau uvaminalimoya nena nenako dilipe wati etiye. ");
INSERT INTO yby_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dukamidana weunaya akuya nena nenakima meina hikiki aku litabo ne. Sakoya minamiye. ");
INSERT INTO yby_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Lahelamibo nesa lolo ikaka niabo wewena ito Omaimidana demesa mikaka niabo wewenasida luwanipou minudawo wewenalikaya, nulinemuhe monokanemuhe wetome itabomuya owanipo helitaboya, okulumauti we uti nemo ahoneda lamedalalimoya mupilanelo yowekadeko, eto iki minabo okananipoki weki magoina lemetudawo yupeka maya owatipo helebomidana oko nemokiya ulinipo le sawa jitubomu owane helekoloe. 34 Mat 10:38; Luk 14:27 ");
INSERT INTO yby_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sa-loko lokadanaki, Jisesimamoya kolo meko wati gaya lekoloyo elilo, lokoko sa-loko lo biye: Edimokutiya malokawaya owaha helamideko Omailimo ujapa obetatibomidana elewoleyalaya soto pideko mudakilae. ");
INSERT INTO yby_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sa-loko lokadanaki, onawa 6-pala oko wokaiyoko, Pitale Jemisile Jonilesidagoya dilipe-loko bola hanau yowiye. Yowiki bolau maya domudalokaya upalama aitomidana soto pekaiyoko minoko, ");
INSERT INTO yby_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","upalo nesaloti maya okuluma ijopa libomidana oko maya mikau wewenasi samitabo nesa leko sa-iye. ");
INSERT INTO yby_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sa-okaiyoko, Ilaijako Mosesekoma okulumauti limiki Jisesimakiya gahena li yolalo malo iki minayoko mudae. ");
INSERT INTO yby_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sa-inayoko, Pitamamoya Jisesidama sa-loko lo miye: Monoka ujapa wenelika, maloya minudawoya dowa lokaiye. Sa-okainako, olowala numuda loweki makoki volibetatuniyo, makoya emodae, ito makoya Mosesedae ito makoya Ilaijadae. ");
INSERT INTO yby_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Loko liboya, domoda adoha wokaiyoko nenae loko lo mituhe loko letibo ga minamiyoko opa napa ga liye. ");
INSERT INTO yby_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Loko noliyoko, lubu napa lemeko jeko hitobikaiyoko, ayauti maya ga mako sa-loko liye: Maya nemo nukane meminobo ipanema neyo, emo galama eliki emesalo molalo. ");
INSERT INTO yby_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Loko lokaiyoko, ilipe iki demesaloka mudabo maya Jisesima eimolago neyoko mudai-minabo ne. ");
INSERT INTO yby_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sakiya mudaikiki bolauti nilimiki bolau mudabo nesamuya wetome iki li bamitae loko, alikaya okulumauti we uti maya helekoko sinokadeko wetome itae loko lo hukobetaiye. ");
INSERT INTO yby_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sa-loko libo ga maya elikadanaki, helitabokuti aku sinikaka gamuya loka loka ae. ");
INSERT INTO yby_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Edimoya alo Ilaijada muda-elaboya, emoya Jisesida anu le wiletoko saina mako lolo amibo nenako, Sa-liki loka itae: Monoka monawa api-napi ibikaka wesiya lahelametibo olisauti lilimitibo we maya owaha soto pamideko, Ilaijaya omutoko soto pitibo ne liki nenahamuya likaka niae. ");
INSERT INTO yby_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Liki loka itayoko, Jisesimamo noku udobetokaka we Jonimamu ga mako sa-loko lo biye: Ilaijakidana welimoya omutoko nisekoko sainahena anu wileko le wehe letiye liki laboya wehe liki lae. Sa-oneboya, nemo okulumauti we uti mupilaneloya miluma nesa li ohinitatabo ne liki monoka bukuguya luhuwa ji-minabo gamidana monawamu data kitae loko noloe. ");
INSERT INTO yby_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ito Ilaijakidana we maya alo soto pekaiyoko emokumu monoka bukugu luhuwa jiki li-minabo galo maya data eleboto lahelamibo nesa lolo itikayoko aloya helekaiye. 7 Mat 3:17; 2 Pit 1:17-18 11 Mal 4:5; Mat 11:14 ");
INSERT INTO yby_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sa-loko lokaiyoko, unala ipapalale maloka minabotoka maya wiki mudabo maya wavu-liki wewena li esa iki miniki monawa api-napi ibikaka wekiya lowa moila hiki minayoko muda-minabo ne. ");
INSERT INTO yby_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sakiya wayoko, muki wewenasiya Jisesida maya muda-elikiki topa ikiki lolosa jiki Jisesi nebotoka wiki eke-woke liki epoka litae. ");
INSERT INTO yby_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sa-inayoko, Jisesimamoya edimo nenahamuya lowa moila nihe loko loka obetaiye. ");
INSERT INTO yby_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sa-loko loka obetaiyoko, edimokuti we makolimoya enemane oko sinokadanaki monoka ujapa wenelika, oloha lahelamibo makolimo ipaneda ukau maya lemeko minokadanaki epala maya heko lagoli okaiyoko gahena lametibo nesa liyoko ilime-loko emotoka maya nonisoe, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ipanedaya oloha makolimoya ilime opa napa okaiyoko, muki yupekaya lemeko mikauya pou loko udokaka noiye. Sakoya epalauya etehulimogo waitokaiyoko, epa tala-mitala oko ilo adelo lekaiyoko, momoga amoko minokaka noiye. Sa-okaiyoko, ipakale yuhasiya aya oloha maya kohaki oli hitae loko loboya, sa-itabo nesa lamiye. ");
INSERT INTO yby_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Loko liyoko, Jisesimamoya unala ipalalesida maya edimoya elewole iki elamabokumuya oselene nelokaiye, loko liye. Edimokiya nenaki onawa magoina minoko eda delonetibo nesaya lewa lewa oko minatubo ne. Loko auha bekoko aya oluho maya nemo minoboto ilimi-liki nisilo liyoko, ");
INSERT INTO yby_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ilimi-liki nisikayoko, oloha lahelamibomamo Jisesida maya muda-elokoko opa napa ga loko aya oluhomidana maya ilime ololo okoko ipiso hulikaiyoko, lemeko mikau maya pou loko udoko wiliye aliye oko noudaiyoko, epauti maya etehu alakala wiliye. ");
INSERT INTO yby_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sa-noiyoko, Jisesimamoya aholada maya nena yupekama jelibo nesa ne loko loka oetaiyoko, aholamamoya oluho lasolaloti jelenebo ne, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Muki yupekaya aya olohalimoya ipanedaya ilime leso ekolo ipisoko hulo jokuhena ito nokuhena hulokaka noiyoko, eke adoha loetokaka nobo neyo, elewoleya emotoka nedeko maya eke loletoko le huloeto. ");
INSERT INTO yby_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Loko liyoko, Jisesimamoya abuha-wowo emotoka nedekoe loko ladawoya nenaha iyoko lane. Wewena malokasiya sainahena lolo etune liki elewole iki data kitabo wewenasiya muki nesaya li lolowa ikikigo lolo itabo maya ne. ");
INSERT INTO yby_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Loko liyoko, aya ipamidana aholamamoya enemane oko alukada moloko sa-loko liye: Lasolasi elewole oko eleminoboya, napa oko luhawane le ilitideko elituwe loko noloe. ");
INSERT INTO yby_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Loko lokaiyoko, Jisesimamo mudaibo maya wavu-liki weloti menaloti nisiki li esa niayoko mudakoko oloha lahelamibomidana maya lowa moila he meko oli nohidanaki sa-loko lo miye: Oloha lahelamadawo emolika atala ito epala heko lagoli adawolika, aya oluhomidanama hulotokoko lemeko wowo. Sako wokoko maya aku le wili jeko nisametane loko lo nohukoetoe. ");
INSERT INTO yby_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Loko liyoko, opa ga lidanaki aya oluhomidana maya aku ilime ololo okoko ukalautiya yoweko wiye. Sakoya yoweko wokaiyoko, aya oluho maya wewena helebokidana oko mikalo maya lemeko udoneyoko, maloka wewenasiya aloya helekaiye, liki lae. ");
INSERT INTO yby_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Liki layoko, Jisesimamo adelo leko aya oluhomidana maya ilime sinaiyoko sinoko ne. ");
INSERT INTO yby_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sa-okaiyoko, Jisesi maya oluho unala ipapalalekiya numuku yowiki edimonipogo miniki Jisesida maya lemoyamo nenahamuya kohako oli hamune, liki loka itae. ");
INSERT INTO yby_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Liki layoko, Jisesimamoya olohasidaya saina makoloti kohaidoko doli hekaka nesa minamiye. Omailoka domuda likokaka nesalotigoya kohaidoko doli hekolune loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Sa-lokaiyoko, aya eba maya hulikiki Galeli ebakuka wae. Wiki yalokaya Jisesimamoya oluho unala ipapalalesida maya sa-loko lo bebe iye: Okulumauti we uti nemodaya nilimi ulanelo wesida dadeu molikadeko kohaneli helitabo ne. Sakiya kohaneli helikadeko maya, onawa loweki makoki yupeka minokoko akuya sinatubo ne. Loko lo bekadanaki, maloka wewenasiki aya gama elikatae loko lokadanaki moletokosi wiyoko, ");
INSERT INTO yby_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","aya gama eli wehe lamiki loka oetatune liki laboya, domodanipo wokaiyoko loka itamae. ");
INSERT INTO yby_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sakiya Kapaniyamu numuto maya wiki hetikiki li numuda makomauya yowiki Jisesimamo anuloka nenahamuya wetome-katome ae. ");
INSERT INTO yby_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Loko loka obetaiboma, anuloka niwikiya Jisesiya uliki we napa lolo etibo onawaloya ekahimamo lemokutiya aseletoko ulilaki we lolo etiye liki laboma nenako loka obetaibo gama onoto lamiki depa molikiki minae. ");
INSERT INTO yby_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sa-inayoko, Jisesimamoya mikalo minadanaki unala ipalale yuha 12-palasidama ju loko dilipe nupa okoko we mako uliki we minatuwe loko ata kitibo welimoya lemeko minoko muki wewenasida elekele obetoko minakolaiye, loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sa-loko lokoko oluho lasola mako luwanipou ilime sinoko apusa jenedanaki sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Wewena malokasiya maya oluho lasolamidana iki nemokumuye liki nasahili ibitataboya nemoda nasahili initabo ilitibo ne. Ito nemoda nasahili initatabo nesaya ahone noli hibo wemidanaki nasahili itabo lolo etibo ne, loko lo biye. 34 Luk 22:24; 35 Mat 20:26-27; Mat 23:11; Mak 10:43-44; Luk 22:26 37 Mat 10:40; Luk 10:16; Jon 13:20 ");
INSERT INTO yby_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sa-okaiyoko, Jonimamoya Jisesidama sa-loko lo miye: Tisanelika, we makolimoya oloha lahelamibosidaya ulikalo loko wewenasida dukauti kohaidoko doli nohiyoko mudaudawoya, lemoki magoina monekaka noudawo we minamiyoko auha mune. ");
INSERT INTO yby_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Loko liyoko, Jisesimamoya auha mamilo loko liye. Wewena makolimo nemo nulinelo oliwaki nesa lolo etiboya enemane oko nemodamuya lewo letowo amekolaiye, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wewena mako lemo ulatelo we minametiboya, lemo wete minakolaiye. ");
INSERT INTO yby_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nemoya wehe loko lo libituyo, elilo. Wewena makolimo olisauti lilimitiye loko lo mololetaibo we makoya nemo wewenane yuha minabokumuye loko nogo hiki libitiboya, woko aha nesa lolo amekolaiye, aya nesalotiya meinawa litibo nesago ne, loko lo biye. 40 Mat 12:30; Luk 11:23 41 Mat 10:42 ");
INSERT INTO yby_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nemodamu elewole iki eli-minabo unane ipapaneleutiya lemeko nebo wemidanaya edimokutiya we makolimo lahelamibo nesa litiye loko okepa jeko letiboya, agae, Omailimo edawaki adoha nesa lolo oetatibo ne. Enolaloya ehada napaloti nala jikiki huli ela noku molatabomidana asetoko adoha nesa lolo oetatibo ne. ");
INSERT INTO yby_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Sa-oneyo, adekalimoya lihima lekaka anugu ilime molakoladekoma adekaya huko huliko. Emoya ya adekalimo letiboto hametibo lowa lowa oko netibo jokuya hilekataniyo, adeka huko netibo minoko okulumau yowitadawoya wati oko ne.  ");
INSERT INTO yby_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ito aya jokuya woko inida hitadawoya suwametibo ne, joyaki hametibo nenako. ");
INSERT INTO yby_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ito ikalimoya ilime lihima lekaka anugu molakoladeko maya, huko huliko. Emoya ika loweki minoko jo ebaku ipisikatae, ebili minoko okulumauya yowitadawoya wehe loko ne.  ");
INSERT INTO yby_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ito aya jokuya woko inida hitadawoya suwametibo ne, joyaki hametibo nenako. ");
INSERT INTO yby_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ito omudakalimoya ilime olisa lekaka anugu nomoladekoma, adekalotiya omudaka malokaya heko likoko huliko. Omudaka maloka likonedeko okulumau yowitadawoya wehe lone. ");
INSERT INTO yby_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jo ebaku woko minatadawoya, upakau inida molo heko suwametibo jokuya woko minakolane. ");
INSERT INTO yby_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nodenesauya wati etiye loko soleya hulokaka noune. Yamidana oko muki wewenasida lahelamibo weunipo molikaka niabo nesa maya jo jeko nokalawe oko dilipe lalo etibo ne. ");
INSERT INTO yby_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ito soleya lalo nesa neboya, nodenesauya lahelepa ametiboya nena nena ikima aku li lahelepa itabo ne. Ma samitabo nesa neyo, edimoya solekidana iki hulu iki minalo, loko liye. 43 Mat 5:30 47 Mat 5:29 48 Aes 66:24 50 Mat 5:13; Luk 14:34-35 ");
INSERT INTO yby_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisesimamo aya ebama hulikoko lemeko Judiya ebama hulikoko lemeko Jodani nomidana yola helegalokama wiyoko, muki wewenasiya ayaloka wiki li esa iki minayoko, omutoko okaka ibo nesa leko monoka lo bebe oko ne. ");
INSERT INTO yby_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sakoya monoka lo beikaka oko neyoko, Palasisi wehenasiya nebotoka nisiki ohumanau hiki Mosesekaho lo hukoko libo gauya we makolimo menaladaya oli hituwe lokoma aha oli hitibo ne loko neboya, suwa nehe ito wati ga ne liki lae. ");
INSERT INTO yby_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sa-liki layoko, Jisesimamo aku mino wili jeko Mosesekaho nenae loko libo ne loko lokaiyoko, sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Menatipole doli hetune liki maya luhuwa nesa jiki bikiki doli hilo loko Mosesemamo ele bekaka iboma nenae. ");
INSERT INTO yby_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Liki layoko, Jisesimamoya edimoya nei moliki duka opa ibokumuya sa-loko luhuwa jeneboya, ");
INSERT INTO yby_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","omutoko muki nesa api ibo onawalo yeimaya Omailimo makoko weki makoko menaki dilipe soto pene. ");
INSERT INTO yby_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sa-onenako, yamuya Omailimoya sa-loko lone: We mako ekahimamo dolale aholalesida hulobikoko ");
INSERT INTO yby_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","menalaki duka depa moli makokoto ikiki koliki minasaiye. Loko ga maya libo nenako, edimoya lowe wewena lolo iki minamikilae. Dupa makoko lolo one. ");
INSERT INTO yby_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sa-onenako, Omailimoya dilipe koloko makoko wewena lolo onebolawaya wewenalika dilipe hoto-poto ametadawo ne. ");
INSERT INTO yby_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Loko lokaiyoko, numukuya yowiki miniki unala ipalalesiya aya gamuya aku loka itayoko, sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sa-onenako, we makolimoya menalada oli he hulikoko aito mena litiboya olisa nesa nenako, lihima napa lekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ito mena makolimoya waunada hulikoko aito welo wetiboya olisa nesa nenako, lihima napa lekolaiye, loko liye. 4 Dut 24:1-4; Mat 5:31 6 Jen 1:27; Jen 5:2 8 Jen 2:24 11-12 Mat 5:32; 1 Kol 7:10-11 ");
INSERT INTO yby_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Muki wewenasiya oluhonipolesida dupalo leko maku bitiye liki dilipi-liki Jisesitoka niseyoko, Jisesida unala ipapalalesiya aya wewenasidama auha be. ");
INSERT INTO yby_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sa-liki auha labo nesaya alo mudako elekadanaki, Jisesimamoya oluho lasomosolasidaya hulibitikalo, nemotoka nisitayo, yamidana oloho lasomosolaya Omaimidana ebalauya ebanipo nenako nisikilayo, li hoipa ibitamilo. ");
INSERT INTO yby_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nemoya ga wehe loko lo libituyo, elilo: Oluho lasola monokau li lolowa iki yowikaka niabo nesa liki yowamitaboya, Omaimidana ebakuya keke yowamikilae. ");
INSERT INTO yby_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Loko lokadanaki, aya oluhosida maya dapusa jeko sisiwanipo nojeko maku biye. 15 Mat 18:3 ");
INSERT INTO yby_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sa-loko lokoko aya ebatoti maya aito ebatoka wetuwe loko sa-noiyoko, we makolimo lolosa jeko niseko Jisesida maya i bola he meko, tisa lalo, nenaha okoko nepa mutiwa suwametibo lituwe loko loka oetaiyoko, ");
INSERT INTO yby_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisesimamoya nemodamuya we lalowe loko noladawoya, monawane ele wehe lo-minoko lape, ito aha yatoka lane, ahone makokoya we lalo neyo, ito mako minamayo. ");
INSERT INTO yby_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ito emoya 10-pala lo napa maya elekaka noane. Aya lolimoya sa-loko lone: Wewenasida kohaido helamo. We olisa mena olisa amo. Ukele amo. Suwa ga lamo. Wewena aitosi nesa wau lamo. Dokako ahokako dulinipo le sawa jo. ");
INSERT INTO yby_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Loko liyoko, aya wemamoya laho wenelika, nemoya aya 10-pala loya oluho we owahaloti api oko emesalo molokaka nobolae. Sa-onenako, saina mako owaha lolo amoboya nehe. ");
INSERT INTO yby_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Loko lokaiyoko, Jisesimamoya wenu eloko ukala emotoka molokoko saina makoko owaha lolo amadawoya le wehe letane. Emoya woko muki uvaminakahenama meinawalo ona moloko lekoko muki uvaminanipo minamibo wewenasidama bekoko nisekadeko magoina wetune. Sa-okadeko okulumauti elewole uvamina maya emo nesaka lolo ekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Loko liyoko, aya wemamoya uvaminala wavu-leko nebo nenako, ona moloko bituhelae loko ata kibolimoya edala elokaiyoko wiye. ");
INSERT INTO yby_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sa-loko lokoko aya we maya nowiyoko, Jisesimamoya mino wili jeko unala ipapalalesida maya uvaminanipoki wewenasiya Omaimidana ebakuya osele nesa liki yowitabo ne. ");
INSERT INTO yby_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Loko liyoko, unala ipapalale maya Omailimo uvaminaki wewenamu elene liki elikadanaki ololo ikayoko akuya sa-loko lo biye: Unane ipapanelika, Omaimidana amaekuka wokaka nesaya hulu nesa minamiye. ");
INSERT INTO yby_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamolo jalimoya nekamidana anuwa lonebokuya wokaka nesaya osele nesa neboya, Omaimidana ebaku uvaminanipoki wewenasi witaboya yatoka nesamidana asetoko osele yowanu adoha litabo ne. ");
INSERT INTO yby_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Loko liyoko, akuya ololo ikiki loka itiki, sa-ideko maya ekahidama olisauti ilime yowaloka molokadeko netibo ne. ");
INSERT INTO yby_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Liki loka itayoko Jisesimamoya wenu nodelaidanaki wewena makolimo ametibo nesa leko Omailimoya saina mako lolo etuwe loko ata kitibo nesaya aha lolo etibo ne. ");
INSERT INTO yby_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Loko liyoko, Pitamamo ele-minape, lemoya muki nesate maya hulikoko emoki magoina nomonudanako, alikaya meinawate letudawo nehe. ");
INSERT INTO yby_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Loko liyoko, Jisesimamo sa-loko lo biye: Nemoya wehe loko lo libituyo, elilo: Wewena malokasiya numudanipohe, ito wewenanipohe, ito donipole ahonipolesidahe, oluhonipolehe ito mikanipohe, nemokumuhe, ito gane lalomuye liki hulataboya, ");
INSERT INTO yby_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","oloti maya yupekaya numudanipole donipole ahonipole wewenanipole oluhonipole mijanipole 100 yamidana iki litaboya, ganipo minamibotoya ahamuya ulana molibitakilae. Sa-ikadekoya, alika soto pitibo onawaloya elewole oko minokaka depa mutiwaki minakilae. ");
INSERT INTO yby_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sa-oneboya, muki omutune liki likaka niabo wewenasiya mini alika ikadeko, muki lemeko noune liki likaka niabo wewenasiya alika omutikilae, loko liye. 19 Eks 20:12-17; Dut 5:16-20 31 Mak 20:16; Luk 13:30 ");
INSERT INTO yby_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jelusalemu numutoka yowiki anu niwayoko, Jisesimamo luwaku wibototi maya mino omutiyoko unala ipalale yuhasiya Jisesima ulalalo wesi ebatoka wetuwe loko libomuya ololo ayoko, muki demesalo moliki wabo wewenakiya domodanipo adoha wonebo ne. Sa-ikayoko Jisesimamo unala ipapalale yuha 12-palasida maya dilipe aitoloka molokoko emotoka soto pitibo nesamu sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Elilo, lemoya olotiya Jelusalemu numutokama noyowune. Yalokaya okulumauti we uti nemodaya Omailoka jokila hi mikaka wesida ito monoka monawa api ibikaka wesida dadeu nilimi molikiki obi yowanu linitikiki kohaneli helitae liki hetoka wewenasida dadeuya nilimi molakilae. ");
INSERT INTO yby_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Sa-ikadeko, hetoka wewenasiya ulana molinitiki etehu initiki uhedawaki nalalotiya kohane-liki kohaneli helikilae. Sa-ikadeko, loweki makoki yupeka minoko helitubokuti aku sinakoloe, loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jebetida ipala lowe Jemisiko Jonikomasiya Jisesitoka nisiki tisatelika, lemo loka noibo nesaya lolo oletatane loko noloiye. ");
INSERT INTO yby_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Liki laiyoko, Jisesimamoya nena nesa lolo olibetatubomuya nilaiye. ");
INSERT INTO yby_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Loko liyoko, emo lamedakaloya apika maloka maloka minaliyo letane loko noloiye. ");
INSERT INTO yby_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Liki laiyoko, Jisesimamo loka initaibo nesamidana monawaya eli opa ikiki likaiye. Nemoya ekesa nesa natubokutiya edimoki ayauti nasaibo nehe. Ito miluma nesa li ohinitatabo nesaya edimoki aha ohisaibo nehe. ");
INSERT INTO yby_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Loko lokaiyoko, sa-liki li meiye: Aha nasibo maya nenae. Liki likaiyoko, Jisesimamo sa-loko lo biye: Ekesa nesa natuboya edimoki aha nasaibo neboya, ito miluma nesa ohituboya edimoki mohisaibo neboya, ");
INSERT INTO yby_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","nemo apine maloka maloka minikaka nesaya nemo nesa neyoko libitubo nesamu nilaihe. Omailimo le lolowa obetaibo wewenasida sipamuya nilaiye. ");
INSERT INTO yby_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Loko liyoko, unala ipalale maloka 10-palamasiya aya gama elikiki Jemisiko Jonikosida maya depa aha kohaidikayoko, ");
INSERT INTO yby_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisesimamo muki unala ipala yuha maya ju lo bekoko sa-loko liye: Maloka wewenasiya ma mikauka we mako duliki we ne liki likaka niabo wesiya elekele oluhonipolesida ujapa ibitikaka niae. Ito we napasiya asaiki ujapa ibitikaka niabo nesaya edimosiya eli-minaboma ne. ");
INSERT INTO yby_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sa-oneboya, edimotokaya sako minametiye. Edimokuti we makolimoya nuliki we minatuwe loko elekoko maya elekele olibetoko netibo ne. ");
INSERT INTO yby_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ito wewena makolimoya muki wewenasida asebetoko minatuwe lokoko maya lemeko minoko muki wewenasida meusa oluhonipo lolo oko elekele obetoko netiye. ");
INSERT INTO yby_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nemo okulumauti we uti elekele initatae loko lemamoe. Muki wewenasida elekele obetoko lahelamibo nesauti meina hebetoko nalauti olutobetatuwe loko minoko leko obo nupaneya hulatuwe loko lemobo maya ne, loko liye. 38 Luk 12:50 42-44 Luk 22:25-26; Mat 23:11; Mak 9:35 ");
INSERT INTO yby_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisesi maya Jeliko numutoka wokoko, ya numuda maya hulikoko unala ipapalaleki wikili niayoko, magoina li esa iki minabo wewenaki magoina niwayoko, Timeoda ipala Batemeoya omudala likonebo we nenako ehada wako wako loko anu akononalo ne. ");
INSERT INTO yby_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Minoko elibo maya, Naseleti we Jisesi maya nonisiye liki layoko elekoko alukada moloko ju loko Jisesiyo, emoya Dewitida awola olisauti lilimekaka welikaya, nemoda milumane elenetowo. ");
INSERT INTO yby_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Loko liyoko, muki wewenasi ebili omuda likaibo yaitaya moletoko minamiye liki auha mebo maya ele hulikoko alukada molokogo ju loko Dewitida ouvamela olisauti lilimekaka welikaya, nemoda maya miluma elenetowo. ");
INSERT INTO yby_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Loko lowa lowa iyoko, Jisesimamo elekoko woko anulo minoko aya we maya ju liki ilimi-liki nisilo, loko liyoko, omuda likaibo wemidanama ju liki, sinoko elowa jeko niso, emodamu Naseleti wemamo noliye. ");
INSERT INTO yby_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Liki likayoko, olo jekoko nebo lawo-lawo maya ololoto hulikoko moi oko sinokoko Jisesima nebotoka wiye. ");
INSERT INTO yby_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Wiyoko, Jisesimamo nenaha oetatubomu nolane loko loka oetaiye. Sa-iyoko, omuda likaibo wemamo laho wenelika, nomudane maya le pana kenetatane loko nolo. ");
INSERT INTO yby_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Loko liyoko, Jisesimamo nemodamu ele elewole adawolimoya omudaka pana kekaiyo, wo loko lo miye. Loko libo epakiya omudala maya pana kiyoko mudakoko Jisesiki magoina wae. ");
INSERT INTO yby_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sakiya Jelusalemu numuda aliliya bola mako Olivi ya loko nebomidana ohalaloya numuda emesa loweya neboya dulinipo makoya Betepeje loko, ito Beteniyo loko nebotoya wiki hetikiki, Jisesimamo unala ipala lowesida maya doli nohidanaki sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yolaya numutoka wiki hetikiki, donki ja akalewa nala ji-minatabototiya mudaki wewena emesalo monamitabo netiboya wina ikiki liki nisiliyo. ");
INSERT INTO yby_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sakiya wina niaiyoko, we makolimoya nenaha ikili wina niaiye loko lidekoma, we napalimo yowanu neyoko maya jamu liyoko wina noinako, aku maloka enemane oko oli hekadeko leko nisesibo ne liki li miliyo. ");
INSERT INTO yby_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Loko lokaiyoko, wiki anu ateto maya aya jama nala ji-minayoko mudaikiki wina niaiyoko, ");
INSERT INTO yby_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ateto minabo wehenasiya mudaidikiki donki ja akalewaya nenaha ikili wina niaiye liki layoko, ");
INSERT INTO yby_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jisesimamo sa-liki liliyo loko libo ga maya laiyoko, oo likayoko liki waiye. ");
INSERT INTO yby_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sakiya aya jama liki Jisesima neboto wikiki olo ji-minaibo nesa maya ololoha ikiki aya jamidana emesalalo molikaiyoko, Jisesima yoweko mupilalo maya ne. ");
INSERT INTO yby_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sakokoya nowiyoko, muki wewenasiya dupalo nesa maya ololotiki anugu moli-liki nilemeyoko, maloka wewenasiya kokonasi ailawa maya hiliki anugu moli-liki wiki newelusa imi wae. ");
INSERT INTO yby_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sa-inayoko, omutika alika molika abo wewenasiya ga napauti agae, we napamidana galalo soto pekadanako, Omaimo maku imitiye. ");
INSERT INTO yby_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Latate Dewitikidana netibo weya nenako, ya welimo ujapa oletatibo onawaloya Omailimo maku limitiye. Okulumau Omaitemidana epoka letune, liki lae. ");
INSERT INTO yby_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sakiya limi wiki Jelusalemu numuto maya wikiki monoka numuda napau maya yowiki muki nesahena maya moneko mudako suwokoko ho maya lemeko lubu onawa alili okaiyoko unala ipapalale yuhamakiya li Beteni numutokaya wae. 9 Sam 118:26 ");
INSERT INTO yby_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lubu jekoko go maya lokaiyoko, Beteni numutoka hulikiki niwayoko, Jisesima nodemu elokaiyoko, ");
INSERT INTO yby_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","mudaibo maya sigolokidana ya mako hoto neboya ailawa obe-loko neyoko, ihilawa jenetihe loko woko mudaibo maya, ihilawa jitibo onawa minaminako, ailawago neyoko mudakoko, ");
INSERT INTO yby_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","aya yamidana maya sa-loko auha miye: Emoya ihilawaka jamoko ayamidana mino-loko woko minadeko emokutiya wewenasi ihilawaka liiki namitae loko liyoko unala ipalalesiya ele. ");
INSERT INTO yby_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sakiya Jelusalemu numuto maya wiki hetikiki Jisesimamo monoka numukuya yoweko mudaibo maya wewena ayauya miniki sainahena maketilo moliki li yolalo malo niayoko, aya wewenasida maya kohaidoko doli heko le hulikoko aito mikalokati ehadama li huliki aya mikauti ehadalo li moliki senisimi ikaka wesida namabetanipo maya leko hululu jeko hulikoko, Omailoka jokila hi mikaka nama, nama luhukidana li yolalo malo ikaka wesida namabetanipomaki leko hululu jeko hulikadanaki, ");
INSERT INTO yby_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","monoka numuda napauya nesa makoya liki wamilo loko lo hukobetaiye. ");
INSERT INTO yby_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sako lo hukobetokoko, Omailimo libo ga mako monoka bukuguya, nemo numudaneuya aito aito wewenasi Omailoka domuda likikaka numudae loko libo ga luhuwa ji-minabo maya neboya, edimo ukelelo wewenasi suna iki minikaka niabo muliya lolo ikae. ");
INSERT INTO yby_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Loko liyoko, Omailoka jokila hi mikaka weki ito monoka monawa api ibikaka we napakisiya Jisesidama kohatabo anumuya ohu jeboya, Jisesikahoya muki wewenasida monoka lo biboya lahelepa delaibomuya kohakuniyoko, aya monokala elebo wewenasiya lemoda lowa napa hi limikatae likiki hulitae. ");
INSERT INTO yby_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sa-likayoko nenako, muki ludaka maya Jisesileki aya numuda maya hulikiki Beteni numutoka udakili wikaka ae. 17 Aes 56:7; Jel 7:11 ");
INSERT INTO yby_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Go maya lokaiyoko, nekewa maya anuloka niwiki sigolokidana ya maya monauti opatiyoko mudae. ");
INSERT INTO yby_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sa-okaiyoko, Jisesimamo libo ga maya Pitamamo elekoko ujapa wenelika mudao, sigolokidana yamidanama auha medawo maya alo opatekoko ne. ");
INSERT INTO yby_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Loko liyoko, Jisesimamo Omaidamuya elewole iki data kilo loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nemoya wehe loko lo libekoloyo, elilo. We makolimoya bola makomidana enemane oko babiya oko lemekoko le ela noku hilo loko letiboya, atala lowe kamoko makoko elewole oko ke-minoko letibotoya, hitibo ne. ");
INSERT INTO yby_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sa-onenako edimoya sainamamuya Omailoka data ki elewole i-miniki wako ni-liki aloya lekune liki wako litaboya aya nesaya litabo ne. ");
INSERT INTO yby_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Saniki maya Omailoka likaka itabo onawaloya we makomidana lihimala li-minatabo maya hulalo. Sa-ideko ahotipo okulumau welimoya asako edimo lahelamibo nesatipohenama hulolibetakolaiye loko lo biye.  ");
INSERT INTO yby_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ito edimoya iwetipolesida lihimanipo hulibitamitaboya okulumau ahotipokaho lihimatipo hulolibetamekolaiye. 23 Mat 17:20; 1 Kol 13:2 25-26 Mat 6:14-15 ");
INSERT INTO yby_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jelusalemu numutokaya aku li wili jiki nisikiki, Jisesima numuda napauma yoweko nomoniyoko, Omailoka jokila hi mikaka we napaki ito monoka monawa api ibikaka we napaki monoka ujapa weki nisikiki Jisesida maya sa-liki loka itae: ");
INSERT INTO yby_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Emo aijoma malo niseko monoka numuku lolo adawo nesa maya ekahida galalo sane liki lae. Ito ekahimamo lokaiyoko sa-okaka noane. ");
INSERT INTO yby_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Liki layoko, Jisesimamoya nemoki ga mako loka olibetatuyo, edimosiya ada li nimikadeko, nemoya ekahida galalo sa-okaka nohe alikaya lo libituwe. ");
INSERT INTO yby_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jonimamo noku udobetokaka yowanu libo maya nakahaukati le soto molaibo ne. Ya yowanu maya Omaimidana galalo lihe, ito maya mikau wewenasida ganipolo lihe, yawa maya li nimideko elituwe. ");
INSERT INTO yby_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Loko loka obetaiyoko, edimonipoloka ligi hagi iki sa-liki lae: Okulumauti le soto molaibo ne loko letudawoya, sa-onetiboya edimosiya nenahamuya Jonida galalo emesalo molamae loko letibo maya nenako, ");
INSERT INTO yby_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ito muki wewenasiya Joniya Omaimidana epaloti ga wetome okaka we ne likigo lanako, Jonimamo aya yowanu liboya wewenasitoti le soto molaibo ne loko letudawoya, wewenasiya auha limikiki nenahama lolo ilitatahe loko lomodate wokaiye, ");
INSERT INTO yby_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","likiki Jisesida maya onoto liki lemo Jonida monawala ma elamune liki lae. Liki likayoko, Jisesimamo sa-loko lo biye: Sa-ikiki maya nemo sainahena lolo nobomidana monawaya ekahida galalo sa-okaka nohe yawakiya nemo lo libamekoloe, loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisesimamo koha moloko ga mako sa-loko liye: We makolimoya waeni mijaya yuha okoko ohoya heko le wego okoko waeni ihilawa mijeko otele etibo nesamidana ale ohekadanaki, ujapa numuda hana vokadanaki, wewena mako ujapa i-minadeko meinawa beikaka etuwe loko we makosida ujapa initalo loko bekoko wenoka mika makomaloka wiye. ");
INSERT INTO yby_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sakoya yaloka woko minoko elekele oluhola mako ihilawa halatokaka onawama nisekaiyoko, halatonetibo lenetoko nisitiye loko oli hekaiyoko mijala ujapa i-minabo wewenasitoka maya wiye. ");
INSERT INTO yby_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sa-okaiyoko, wibo maya aya mijato ujapa i-minabo wewenamasiya aya wemidana maya kohaikiki waeni ihilawa maya mamiki oli hikayoko, lahowela nebotoka wili jeko wiye. ");
INSERT INTO yby_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sa-okaiyoko, akuya elekele oluhola mako leko oli hekaiyoko, ayalo wibo maya asaiki mija ujapa i-minabo wewenamasiya madona jiwi potiwi iki owana helitibo nesa lolo itae. ");
INSERT INTO yby_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sa-ikayoko, mako asako leko oli hibo maya kohai hele. Sa-ikayoko, muki doli hiyoko wabo maya malokasidaya aha kohaidiki doli hiki ito malokasida maya kohaidiki hele. ");
INSERT INTO yby_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sa-ikayoko, doli hitibo wewena mako minamayoko, ipala makokoya ukala menebo ipala maya ne. Ga ipama oli noheko sa-loko lo miye: Nemo ipane makoko maya oli hekoyoko, uliki wemidana ipala makoko maya nisiye likiki ilimi wati itahe. ");
INSERT INTO yby_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Loko lokoko oli hiyoko, woko ayalo maya hetokaiyoko, mija ujapalo wemasiya edimotokaya mika aholamidana ipala maya nisinako, alikaya ahola iloho molatiboya aya mija maya emokahoya litibo nenako, kohakuniyoko aya nesa matokaya lemo nesate lolo etiye. ");
INSERT INTO yby_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Likiki aya oluho maya adelo liki kohai heleboya aya mijakuti maya ipisiki huli hetoka ikadanaki kohai hele. ");
INSERT INTO yby_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sabo nenako, mijamidana aholaya nenaha etibo ne. Aya welimoya niseko ujapa niabo wesidaya kohaido hulokoko aito wewena yuna itabosida leko hulobetadeko, aya mijala maya ujapa itatabo ne. ");
INSERT INTO yby_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ito monoka bukuguma ga mako sa-liki ji-minaboma lepi-minaboya data molokaihe: Numuda vikaka wesiya ehada napa mako mudai hulabolimoya elewole ahoda lolo okoko ne. ");
INSERT INTO yby_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sa-onenako, aya nesaya we napamidana galaloya soto pinako, wewenalikaya mudakuniyoko lomuda heliye. ");
INSERT INTO yby_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Loko liyoko, Juda wewenasida monoka ujapa wenipolesiya koha moloko libo gautiya ehadamu liboya Jisesida muda huludawomuya lokaiyo likiki adelo li-miniki kohatune liki saboya, wavu-liki wewena minayoko, Jisesida kohatudawoya wewenasi nenaha ilitatae likadanaki domoda wokaiyoko hulikiki aha wae. 1 Aes 6:1-2 11 Sam 118:22-23 ");
INSERT INTO yby_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Juda wewenasiya Palasisi wewenauti liki ito uliki we Helotida wewenala yuhauti liki ikiki Jisesima ga mako le opa oko letiboto ujapa i-miniki, adelo litae liki doli hikayoko, Jisesi neboto wiki mudaikiki sa-liki li me: ");
INSERT INTO yby_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tisatelika, monawakaya ele-minune. Emoya ga ulawago lokaka noane. Emoya muki wewena lupamidanago neyopa, lukamidana monawalaki elekoko lo lemekaka noane. Sakokoya emo wewenaki muki duliki we minabo ito aha wewena minaboya emokaho le wehe loko Omaimidana anula lilipekaka noaninako, ma lideko eletune. Lomu numutokaya uliki we mako uliwa Sisao loko nebo wemidanaya takisi ehada mekaka noudawoya wehe libo nesa lolo noupe, wehe lamibo nesa lolo noune. ");
INSERT INTO yby_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Takisi ehada maya betupe bametune. Liki laboya, bametune loko lideya maya gamaniloka obi oetatune, ito bitae loko lideya maya Juda wewenasiya auha mitae. Liki ohumanau hiki layoko, Jisesimamoya ga labokuka maya ele-minoko sa-loko lo biye: Nenahamuya nemo muluneu hiki nilae. Ehada mako nilipideko mudatuwe. ");
INSERT INTO yby_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Loko liyoko, mako liki nisiki ilipeyoko, mudakoko aya ehato pikisa mayaki ito luhuwa mayakiya ekahida ne. Loko loka obetaiyoko, aya wewenasiya gamani napa Sisada maya ne liki lae. ");
INSERT INTO yby_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sa-liki layoko, sa-loko lo biye: Sa-liki maya gamanimo wako nolibo nesala maya gamanimidana milo, ito Omaimo wako nolibo nesa maya Omaimidana milo loko liyoko, maya wewena maya topa iki agae liki dowa loko le welepa jeko lo biye, liki lae. ");
INSERT INTO yby_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sediyusi wewenasiya helebokutiya aku sinamitabo nesa ne liki likaka abo wewenauti malokasiya nisiki Jisesidama sa-liki loka itae: ");
INSERT INTO yby_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tisatelika, Mosesekaho lo hukoko libo gauya we makolimo oluhola etamoko mino-loko woko helekadeko maya, unalakaho aya mena ijona maya lekoko oluhola etoko yatolatoma molatiye loko loletonebo maya ne. ");
INSERT INTO yby_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sa-onenako, hapaya oluho unamotala 7-pala minae. Sa-ibokutiya ada welimoya mena mako leko oluhola etamoko helekaiyoko, ");
INSERT INTO yby_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ayalo wemamoya aya ijona mena maya lekoko oluho etamoko helekaiyoko, ayalo wemamoya aya mena maya lekoko oluho etamoko helekaiyoko, ");
INSERT INTO yby_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","sa-iliki wiki 7-palasi aya makoko yanipo ada wemidana menalamago li yolalo malo iki mini-liki wiki oluhonipo etamiki heliki suwikayoko, menanipomago minoko alikaya heliye. ");
INSERT INTO yby_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sakiya 7-pala wesiya makoko menagoya li yolalo malo iki minabototi helikanako, alika sinataboya aya mena maya ekahida menala lolo etibo ne. ");
INSERT INTO yby_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Liki layoko, Jisesimamo edimoya monoka bukuguti ga mako sa-loko neboya mudaiki lepiki elamiki ito Omaimidana abuha-wowola maya mudamanako, eli opa napa ikiki likae. ");
INSERT INTO yby_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Helebo wewena sinatabo onawaloya mena leka ito mena ada oko lemo beka etudawo onawa minamiye. Okulumau okananipoki wemidana ikigo minakilae. ");
INSERT INTO yby_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ito aya helebo wewenaya aku sinatabokumuya loka olibetatuyo, Omailimo lo libibo ga maya lepi-minaboya monawa elamahe. Omutoko maya Mosesemamo ya ohuguti jo uluma mako mudakoko neyoko, Omailimoya sa-loko lo mibo maya ne: Omutiki latatele Aebalahamule ito Aesikile ito Jekopulesida Omainipo minobo wema olotiya aha maya minoe. ");
INSERT INTO yby_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Loko libo maya nenako, alo helebo wewenasida Omainipo nehekala, weunanipo aha nebo wewenasida Omainipo nenako, elewole depa mutiwa likiki helebo wewenasidaki ito aha minabo wewenasidaki Omainipo ne. Edimosiya sa-loko lonebo gahena maya li opa ikae. 18 Apo 23:8 19 Dut 25:5 26 Eks 3:6 ");
INSERT INTO yby_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sa-likiya lowa moila niheyoko, monoka monawa api okaka we makolimo niseko ameme oko elibo maya Jisesimamo ga labotoma le wehe loko lo nobiyoko elekoko nemokiya asaoko loka ogetatuwe lokoko, Mosesekaho lo hukoko libo gautiya nakaha galimo aseko ne. ");
INSERT INTO yby_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Loko liyoko, Jisesimamo ga napalimoya sa-loko lone: Edimo Isilaelo wewenalikaya, elilo, we napa Omaite makokolimoya we napate ne. ");
INSERT INTO yby_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dukatipo weutipo ito ga elekakatipo, abuha-wowotipo muki nesatipoya we napa Omaitipolokago milo. ");
INSERT INTO yby_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ito makoya eimokadamuya elekaka noadawomidana oko wewenakamidana asako elekoko uka mo. Loko libo gautiya napawa mako yoweko minamiye. ");
INSERT INTO yby_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Loko liyoko, monoka monawa api okaka noibo wemamoya sa-loko lo miye: Tisanelika, wehe loko lokaniyoko numu helekaiye. Omaiya makoko ne, mako minamae. ");
INSERT INTO yby_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ito lukalimo ele wehe lokaka nesate ito elewoleyateya muki emotokago molatune, ito lelimotemu elekaka noudawomidana oko wewenatemu eleko luka betudawolimoya Omaitoka jokila he mekaka nesa ito uda je mekaka nesamidana asetokaiye. ");
INSERT INTO yby_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Loko ele wehe lo-minoko lokaiyoko, Jisesimamoya sa-loko lo miye: Omailimoya uliki we lolo ogetatibo onawaya hoto minamiye. Loko liyoko, yaloti maya aku saina makomuya mulunau hikili loka itabomu domoda wokaiyoko loka itamae. 29-30 Dut 6:4-5 31 Liv 19:18 32 Dut 4:35 33 Hos 6:6 ");
INSERT INTO yby_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisesimamo monoka numuda napauya monoka lo bebe noidanaki, monoka monawa api-napi ibikaka wesiya lahelamibo olisauti dilimitiye loko lo molobetaibo weya Dewitida ouvamela ne liki nenahamuya likaka niae. ");
INSERT INTO yby_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dewitidaya Omaimidana weuna oluholimo ilime aila jekaiyoko sa-loko liye: Yowau welimo we napanemidana sa-loko lo miye: Nemo nade lamawakaloka mino-loko woko minadeko muki ulakalo wewenasidaya hulo ilauka molobetakoloe. ");
INSERT INTO yby_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ito Dewitimamo aya wemuya we napane lokaibo maya nenako, olisauti lilimitibo weya nenaha iyoko Dewitida ouvamelago netibokumuya nilae. Dewitida ouvamela maya neboya, Dewitida we napalakiya netiye. Loko Jisesimamo liyoko, muki li esa abo wewenasiya eleyoko, dukauka maya lahelepa iye. 36 Sam 110:1 ");
INSERT INTO yby_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisesimamo monoka lo-loko woko monoka monawa api ibikaka wesidamuya ehetipoe loko liye. Dupalo kolikaka nesa hana kolatabokumuya, ito maketilo wideko muki wewenasi depoka litabomu, ");
INSERT INTO yby_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ito monoka numuku numuku moniki muki wewenasi domudalo minikaka siyalo minatabokumu, ito nodenesa napa ataina abotoya epalo nebo siyalo minatabo nesamugoya dumu helekaka noiye. ");
INSERT INTO yby_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Edimoya ijona menakipasida uvaminanipohena ukele lika, ito depaloti suwa liki Omaimidana epoka hana-pana aya liki likaka nianako, alikaya lihima napa likilae, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisesimamo monoka numuda napauma minoko ehada molikaka bokisi alili minoko muki wewenasi ehadama ayau nimolayoko mudaone. Sakoya mudaoneyoko, muki uvaminanipoki wewenasiya ehada maya moliwa moliwa niayoko, ");
INSERT INTO yby_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","uvaminala minamibo ijona mena makolimo ehada laho loweya leko niseko hulaiye. ");
INSERT INTO yby_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sa-iyoko, Jisesimamo unala ipalalesida maya ju loko sa-loko lo biye: Ga mako lo libituyo, elilo. Maya wewenasiya ehadanipo wavu-leko nebokutiya liki nisiki hulaboya, maya ijonalimoya epa nesalalo hulo suwoikoko ayahasiya molonebokuti leko niseko hulainako, ");
INSERT INTO yby_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","maya uvaminala minamibo ijona menalimoya ehada molikaka bokisigu hulaibo ehadalimo muki wewenasida asebetonebo ilekaiye, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisesi maya monoka numukuti nolimiyoko, unala ipalale yuhauti makomalimo Jisesida maya tisane yamalae, mudao, maya ehada numudaya li lalo iki viminabo maya ne. ");
INSERT INTO yby_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Loko liyoko, Jisesimamo maya numuda napamuya nolape loko liye. Olotiya numudaya aha neyoko mudaboya alikaya ulanipolo wesiya nisiki ehada mupilalo mupilalo iki moliki viliki yowebokutiya kohaiki leda jikadeko, muki ehadaya hululuka jeko lemeko suwekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Loko lokadanaki, Jisesimamo unala ipalalesida maya hulobetokoko Oliwi ya bolau maya yoweko neyoko, ito monoka numuda napama yolaloka neyoko, Pitale Jemisile Jonile ito Endulule maya emotoka nisiki sa-liki loka itae: ");
INSERT INTO yby_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Oloti ladawo nesaya nena yulaka soto pitiye, ito emo ladawo onawaya alili noidekoma, anewa maya nena nenako oko soto pideko mudatupe, lo lemo. ");
INSERT INTO yby_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Liki likayoko, Jisesimamo sa-loko lo biye: Ehe, ujapa ilo. We makolimo dokepa jekatiyo. ");
INSERT INTO yby_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muki wewenasiya ninisiki nemo nulinelo we napa maya nonisoe liki suwaki liki dokepa jikilae. ");
INSERT INTO yby_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ito wavu-liki lowa gahena nieliki ito lowahena hikilae liki nilidekoma, mulutipouti hugili amideyo. Yatoka nesaya soto pitibo neboya, muki nesahenaya owaha suwamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Numuto namato wewenasiya lowa napa hitabo ne, ito uliki we makomidana wewenalaki ito uliki we makomidana wewenalakiya sinikiki lowa napa hitabo ne. Ito muki numuto namato nodemu napa helitabo onawa soto pitibo ne. Aya nesaya soto pitiboya, menakipasi oluhonipo etakili miluma nielebo nesamidana asetoko miluma elitadawo ne. ");
INSERT INTO yby_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Sa-etiboya, edimoya mudaki ujapa ilo. Dadelo likiki obilo dilipi-liki wikilae. Ito monoka numuku numukuya moniki monoka litabo wewenasida maya seida oija kohaidakilae. Ito nulineya edimotoka nebomuye liki dilipi-liki we napanipole minaboto ito kiyapenipole minaboto wiki dilipe sini-minadeko nemo gane maya wetome iki we napanipomidana omudalo likilae. ");
INSERT INTO yby_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Sa-itaboya, onawa enemane oko suwamekolaiye. Omutikiya ga lalo maya muki numuto namato pou loko wetiye liki li hutili iki li bitabo nesa ne. ");
INSERT INTO yby_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Dadelo likiki dilipi-liki wiki obi ilibitatabo yupekaya nenae loko letudawo ne liki data etipa kamilo. Sa-itabo yupekaya Omaimidana weuna oluholimoya gaya le dukauya moladeko yagoya litabo ne. Lemo ga ludawo nehe lamiki Omaimidana weuna oluhomidana gala lolo ideyo. ");
INSERT INTO yby_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aya yupekaya yalakahoya unalada maya adelo lekoko obi oetadeko, unalada maya kohai helikilae. Aholakaho ipalada maya adelo lekoko obi oetadeko, ipalada maya kohai helikilae. Oluhonipolesiya donipole ahonipolesida obi ibitadeko, kohaidi helikilae. ");
INSERT INTO yby_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nemo nuline maya edimotoka netibomuya asowalaki nesa lolo ilibitataboya, wewena malokasiya onawanipo owaha suwametibotoya monoka hulamiki elewole iki li-minataboya Omailimoya aya wewenasidaya dilimekolaiye. 9 Mat 10:17-20; Luk 12:11-12 13 Mat 10:22 ");
INSERT INTO yby_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Sa-onenako, edimoya miniki omusepatipo yowitibo eba le opa okaka nesaya eto onebo ebato sinonedeko mudatae. Maya gaya lepitadawo wewenalikaya, wehe loko elo. Sa-ideko aya yupeka Judiya ebakuka minatabo wewenasiya oli li bolalokago yowitanage. ");
INSERT INTO yby_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ito numuda hetoka minatabototiya oli li numuku yowikiki uvaminanipo liki wamitanage. ");
INSERT INTO yby_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ito mijakuka nimonitabo wewenasiya aku numudanitoka wiki dupalo nesa lamikilae. ");
INSERT INTO yby_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kee, menakipa oluhonipoki minatabo ito oluhonipo owaha etiki amida nilijitabo menakipasiya ya yupekaya nenaha itabo nehelae. ");
INSERT INTO yby_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Edimo maya nolobo nesaya go onawalo soto pametiye liki Omailoka domuda likigo minalo. ");
INSERT INTO yby_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ya yupekaya edawaki nesaya soto pitiboya Omaimo api oko saina-maina le soto molaibo onawaloti yeimaya soto pamibo nesa maya minokoko yoweko oloti maya onawaloya soto pamiye. Sa-onenako, oloti maya nemo nolobo onawalo soto pekoko mino-loko woko aku soto pamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","We napalimoya milumate elitibo onawaya le minawa ametiboya, muki wewenaya domuda lamikilanako, aya yupekaya dilipe eto onebo wewenamuye loko le minawa ekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sa-etibo onawaloya wewena makolimo niseko mudalo, olisauti lilimitiye loko libo we maya niseko yaloka ne, ito maloka maya ne loko letibo maya wati ga liye liki li madotipou molamilo. ");
INSERT INTO yby_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aya onawaloya suwaki loko olisauti lilimitiye loko libo we ito suwa omaimidana epaloti suwa ga wetome ikaka we soto pikiki, wewenasi lepoka litae liki suwa anehena lolo ikiki Omaimo dilipe eto onebo wewenasida maya dokepa jetune liki sa-ikilae. ");
INSERT INTO yby_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ehe, nolobo nesahenaya owaha soto pamiyoko alo lo libe suwokoyo, ujapa iki minalo. 14 Den 9:27; Den 11:31; Den 12:11 15-16 Luk 17:31 19 Den 12:1; Lev 7:14 ");
INSERT INTO yby_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Aya yupekaya aya edawaki nesaya suwokadeko, ho maya yowekoko enemane oko lubu jitiye, ito ukada maya lameda lametiye, ");
INSERT INTO yby_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ito sonohihena maya okulumaloti ululutiki nilimideko, okulumauti abuha-wowolaki nebo nesa maya momoga noideko, ");
INSERT INTO yby_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","okulumauti we uti nemomamoya elewoleyaneki, ito lamedanekiya okuluma ijopa mupilalo minoko nolemoyoko muda-nelakilae. ");
INSERT INTO yby_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sakokoya okananipoki wenele maya doli hekoyoko, moniki muki okana malokati ho noyowibotokati ho nolimibotokatiya Omailimo dilipe eto ibo wewenasida maya dilipi nupa ikilae. 24 Joe 2:10,31; Lev 6:12 25 Aes 34:4; Lev 6:13 26 Den 7:13 ");
INSERT INTO yby_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sigolokidana yalo koha moloko libo gala maya mudaki wehe liki elilo. Yamidana akawau maya noya wavu-leko minokoko aila uluma siliyoko, muki wewenasiya mudaikiki ho onawa maya alili okaiye liki likaka niabo maya ne. ");
INSERT INTO yby_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sa-liki likaka niabo nesa liki nemo lo libobo nesahena maya soto nopideko mudaikikima we napate maya nisekolo atetoya sinone liki lilo. ");
INSERT INTO yby_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sa-oneboya, wehe loko lo libituyo, elilo. Oloti maya muki nesa lolo obo nesa mudabo wewena maloka muki heliki suwamideko, muki nolobo nesaya soto pemo wekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sa-etibo neboya, okulumaki ito maya mikakiya suwisaibo neha nemo ganeya ma aha nesa lolo oko suwamekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Sa-oneboya, nemo nisitubo onawaya muki wewenasiya ma elamae, ito okulumau okananipoki wesikiya ma elamae, ito Omaimidana ipala wehe loko nemo minoboya nemokiya aya onawaya elemoboya, ahone Omai makokolimogo elene. ");
INSERT INTO yby_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nemo nisitubo onawaya edimokiya ma elamanako, ujapa lalo nesa iki minalo. ");
INSERT INTO yby_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Saina makoya yowanu we napalimoya wenoka numudala ebala maya hulikoko wekolo noidanaki, elekele oluholalesidaya muki yowanu maya dadeu moloko numudala ujapa etibo wemidana maya atetoma hulomikoko, yaloya ujapa iki minalo lokoko nowibo nesa maya ne. ");
INSERT INTO yby_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sa-iboya, aya numuda aholaya nisitibo onawaya ludakahe, lubukahe, ito okululuwa hokitibolawahe, ito nekewahe, ma elamae. ");
INSERT INTO yby_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Sakiya ma elamanako, yamuya mudaki ujapa lalo nesa iki minalo. ");
INSERT INTO yby_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Maya lobo gaya edimodamugo lamoe, muki wewenasidamukiya noloyo, mudaki ujapa iki minalo. 34 Luk 12:35-38 ");
INSERT INTO yby_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Juda wewena latanipolesida esenipo vobetaibo holiguya lulu jamibo beleti nikaka abo onawa alili okaiyoko, onawa lowe maya aha neyoko, Omailoka jokila hi mikaka weki ito monoka monawa api-napi ibikaka wekiya sa-likiya lae: ");
INSERT INTO yby_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wewenasiya lowa napa hiki kohalelikatanako, holiguya Jisesida kohametune likikiya aya yupeka maya Jisesida adelo lamiki hulikiki aha suna iki kohatabo gahenagoya liki minae. 1 Eks 12:1-27 ");
INSERT INTO yby_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisesi maya Beteni numutoka woko Saimoniya mika ihi jelekoko neyoko ilime haka libo wemidana numudalauya yoweko minoko nodenesa nonaiyoko, mena makolimoya ehadakidana oda mako maya leko niseko auvena siyekoko ayautiya nuwala dowa loko wibo netupa meinawa yoweko nebo netupa makoya nadiyae loko netupaya Jisesida madonauya kisetaiye. ");
INSERT INTO yby_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sa-okaiyoko, maloka wemasiya depalo molokaiyoko, edimonipolokaya netupa lalo maya neboya, nenaha iyoko le latila ihelae liki lae. ");
INSERT INTO yby_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aya netupaya aha minatidanako meinawa 300 kina lekoko sainanipo minametibo wewenasida betine. ");
INSERT INTO yby_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Likiki auha likayoko, Jisesimamo elekoko edimoya nenaha iyoko maya auha miki edawaki ga nilitae, hulitikalo, aya menalimoya wehe libo nesa lolo onetokaiye. ");
INSERT INTO yby_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sainanipo minamibo wewenaya edimokiya mini-liki wiki minakilanako, dilipe lalo etune liki maya alikaya dilipi lalo itabo neboya, nemoya edimoki hana-pana yupeka minamekoloe. ");
INSERT INTO yby_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aya menalimoya eimola sa-etuwe loko ata elibo nesa lolo okaiye. Alikaya nemoya helekoyoko, ono molikakakuya molinitadeko nupaloya netupa hilinitatabo maya nenako, yamuya ata kekoko leko niseko nupaloya hilenimikaiye. ");
INSERT INTO yby_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nemoya wehe loko lo libituyo, elilo: Muki mikaukaya ga lalo nesa li soto moliki li bitabotoya, maya menamidana monawalamu elitae liki emo lolo onetaibo nesamu li soto moliki li bikilae, loko liye. 3 Luk 7:37-38 7 Dut 15:11 ");
INSERT INTO yby_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sa-okaiyoko, we makoya uliwa Judasiya Kaliyoti numutoti weya Jisesida unala ipala weutiya neboya, emomamo Omaitoka jokila hi mikaka niabo wesitoka maya woko Jisesida maya mimi oko leko niseko edimo dadeu hulakoloe loko lo biye. ");
INSERT INTO yby_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Loko liyoko, aya we maya dukauka lahelepa oko ya nesamuya noludawo maya ne likiki omolu ehada emekolune liki lae. Sakoya ilipikayoko mudakoko Jisesida maya mimi ekoloya moneko mabada hiye. ");
INSERT INTO yby_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lulu jamibo beleti nikaka abo holi onawamidana ada onawaya esenipo vobetaibo sipisipi ja akalewa kohaikaka abo onawaloya unala ipalalesiya Jisesidama sa-liki loka itae: Olohanipo esenipo vobetaibo onawa akuya data kiki holimidana nodenesala maya nakahauka wiki li lolowa initatae loko nolane. ");
INSERT INTO yby_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Liki likayoko, Jisesimamoya unala ipalale yuhauti lowe maya doli nohidanaki sa-loko lo biye: Jelusalemu numuto maya wiki mudasaibo maya we makoya mika somo nowaki hekoko leko nowideko, hotula ikikima aya wemidana emesalo moliki wiliyo. ");
INSERT INTO yby_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sakiya wiki aya we maya le numuku yowekadeko maya, ayauya yowiki numuda aholamidanama lemo tisatemamo nemoki unanele ipanele yuhaki minoko olohate esenipo vobetaibomidana nodenesala natudawo lumuya nakahauka ne liki liliyo. ");
INSERT INTO yby_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Liki lisaiboya, aya numuda mupilaloya sainahena alo newelusa onetibo lumuya dilipidekoma yaloya natudawo nesaya li lolowa iliyo. ");
INSERT INTO yby_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Loko liyoko, aya oluhola lowemasiya wiki taonilo hetiki mudaibo maya Jisesimamo lo bibo nesa leko neyoko wiki olohanipo esenipo vobetaibo holimidana nodenesa maya li lolowa aiye. ");
INSERT INTO yby_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sa-ikaiyoko, lubu maya jekaiyoko, Jisesi maya unala ipalalekiya li nupa iki nodenesa niki minayoko, Jisesimamo sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nemoya wehe loko lo libituyo, elilo. Lemo muki maya le nupa oko minoko nodenesa nonudawokutiya we makolimo nemodaya mimi ekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Loko liyoko, edimonipo miluma nieliki sa-liki li yolalo malo ikiki nemokumu nolape, ito nemodamu lamane, liki loka-mika itae. ");
INSERT INTO yby_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sa-ikayoko, Jisesimamo edimo we 12-pala minabokutiya nemoki makoko lapeuti beleti leko nasibo welimoya sa-etibo ne. ");
INSERT INTO yby_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ito nemo okulumauti we utimuya monoka bukugu luhuwa jiminabomidana oko helitubo anugu nowoboya, nemoda mimi etibo weya lihima napa lekolainako, dolakaho etametidanako wati oko minatine, loko lo biye. 18 Sam 41:9 ");
INSERT INTO yby_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nodenesa maya ninadanaki, Jisesimamo beleti maya leko Omaimidana epoka lokoko posekoko nobidanaki, sa-loko liye: Liki nalo, maya nemo milawanemidana aweyaha maya ne. ");
INSERT INTO yby_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Loko lokoko, waeni no oda maya lekoko Omaimidana epoka lokoko kiseko biyoko ninayoko, ");
INSERT INTO yby_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","sa-loko lo biye: Nemo oladane maya muki wewenasidamuye loko kisitubomidana aweyahawa maya ne. Wewena mukisida lihimanipo le hulatuwe loko oladaneloti ohatama ga lo mutihekaka ga le elewole etubone. ");
INSERT INTO yby_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Wehe loko lo libituyo, nemoya waeni ihilauti namoko mino-loko woko Omailimo uliki wetipo lolo olibetatubo onawaloya, aitomidana oko waeni noya natuwe. 24 Eks 24:8; Jel 31:31-34 ");
INSERT INTO yby_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Loko lokaiyoko, monoka nama mako likiki limiki li Oliwi ya bolalokaya niyowiki, ");
INSERT INTO yby_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisesimamo sa-loko lo biye: Monoka bukuguya Omailimo libo ga sa-liki luhuwa ji-minabo maya ne: Ujapa weya kohakoyoko, sipisipi ja akalewa maya hutili iki oli ikilae. Liki ji-minabo maya nenako, edimo mukiya nemoda hulinitikiki oli itaboya, ");
INSERT INTO yby_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","helekoyoko akuya ahonekaho nilime sinokadeko maya, Galeli ebatokaya woko le omutolibetatuwe. ");
INSERT INTO yby_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Loko lokaiyoko, Pitamamoya nemo huloetamekoloe, edimo mukiya eli elewole ikaka nesanipoya lemo jekadeyamaya, nemoya samekoloe. ");
INSERT INTO yby_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Loko liyoko, Jisesimamo wehe loko lo imituyo elo. Oloti lubukaya okole onowa loweya owaha lamideko, nemodaya yuwawa molonetatadawoya onawa loweki makoki lekolaiye. ");
INSERT INTO yby_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Loko liyoko, Pitamamoya emokumu sa-loko yuwawa molamekoloe loko pigi jeko liye. Kohaneli helikili maya emokiya magoina kohaleli helitaboki sa-ogetamekoloe. Loko liyoko, muki unala ipalale yuhamasiya asaikigo lae. 27 Jek 13:7 28 Mat 28:16 ");
INSERT INTO yby_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sa-okaiyoko, ya mija makoya uliwa Gesameniyo loko neboya yuhauya wiki hetikadanaki unala ipalalesida maya edimoya maloya minadeko nemoya woko Omailoka omudane likatuwe loko hulobikoko, ");
INSERT INTO yby_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pitale Jemisile Jonilesidakiya dilipe-loko widanaki Jisesi maya uka hekaiyoko miluma elekoko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nukau hekoko helitubo nesa lekaiyo, edimoya maloya ujapa iki minalo. ");
INSERT INTO yby_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Loko lokadanaki, lasolasima eba huloko mino-loko nowoko mikau lemeko okepa nohidanaki, ahonelika, edawaki nesa maya ohitubo nesaya emo elekadekoma oli onetatiye loko noloe. ");
INSERT INTO yby_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Loko nolidanaki, ahonelika, emoya muki lolo etuwe loko ata kedawo nesaya aha lolo etadawo ne. Edawaki nesa maya li ohinitatabo nesaya le olowe etadawo ne loko noeloboya, nemo nata elituboto nehekala, eimoka letadawoto soto pitiye loko noeloe. ");
INSERT INTO yby_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Loko lokadanaki, niseko unala ipalalesida maya mudaibo maya uvo udiminayoko mudaidokoko, Pitada maya ilime sinokoko sa-loko lo miye: Saimoniyo, udo-minape, sinoko nemoki minametape. ");
INSERT INTO yby_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mulutipou hitabo onawa nisitibokumuya opa ikatayo, ujapa iki Omailoka domuda likiki minalo. Weuteya olo loneboya, lupalimo eda noiye. ");
INSERT INTO yby_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Loko lokadanaki akuya woko aya gaya Omailoka lokoko, ");
INSERT INTO yby_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","aku niseko mudaibo maya, domuda hihi okaiyoko uvo udi esa iminayoko mudaiye. ");
INSERT INTO yby_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sa-okaiyoko, onoto liki li mitabo gamuya ohu je. Sakiya sayoko, onawa loweki makoki okaiyoko Jisesimamoya edimoya aha aso jeliki udi-minahe. Sa-ikayo, eli-minahe. Okulumauti we uti nemoda maya mimi iki lihimanipoki wewenasida dadeu molatabo onawa maya alili okaiye. ");
INSERT INTO yby_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Loko lokoko sinadeko alo wetune. Mudalo, nemoda mimi etibo we maya aloya alili okaiye. ");
INSERT INTO yby_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sa-loko lo beko neyoko, eimola unala ipalale yuhauti Judasi maya nisiyoko mudabo maya muki wewenama emesalo moliki mainahahena ito sopolo emitahena maya li-miniki nise. Edimo aya wewenaya Omailoka jokila hi mikaka wehena ito monoka monawa api-napi ibikaka wehena ito monoka ujapa ikaka wehenasiya yeimaloka doli hikayoko, ");
INSERT INTO yby_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","niwiki mimi etibo wemamoya ga mako sa-loko lo biye: Sako nowoko maya we mako okepa liyeko nonoyoko mudaikikima aya we maya ne liki mudaiki adelo liki ujapa dowa liki itiki ilimi-liki wilo. ");
INSERT INTO yby_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Loko lo bekoko niseko Jisesi maya neboto enemane oko niseko oho, tisanemalae, lokadanaki enemane oko okepa hukoko naiye. ");
INSERT INTO yby_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sa-iyoko, lowa wesiya nisiki Jisesida adelo maya li ikitiki le. ");
INSERT INTO yby_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sa-inayoko, Jisesida amaitoka nebo weutiya we makolimoya sopolo hana mako owolauti maya eleleha okoko Omailoka jokila hi mikaka wesida we napamidana elekele oluholamidana koha helituwe loko aha atala maya jeko seko hulikaiye. ");
INSERT INTO yby_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sa-okaiyoko, Jisesimamoya lowa wesida maya nemoya olisalo we ukelelo we minoyoko sopolohena ito mainahahenaki liki nisiki nadelo letune liki liki nisehe. ");
INSERT INTO yby_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Muki yupekaya edimoki magoina monoka numuda napau minoko monoka lo libekaka oboto maya sakiya nadelo lamabo nehe. Sa-ikaboya, hapa yeikala monoka bukuguya nemokumuya luhuwa ji-minaboto maya woko ulolotetiye loko saina maya soto nopiye. ");
INSERT INTO yby_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Loko liyoko, oluho unala ipalalesiya hulitikiki hutili iki oli wae. 49 Luk 19:47; Luk 21:37 ");
INSERT INTO yby_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sa-inayoko, we owaha nemoya ukulo nesago nupalo olo jekoko Jisesida maya emeke moloko nowoyoko, nadelo lebo maya, ");
INSERT INTO yby_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","olo jeko wobo ukulo lawolawoma ololotoko hulo dadeu okoko upane sapago oli woe. ");
INSERT INTO yby_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sa-okaiyoko Jisesida maya Omailoka jokila he mekaka we napanipo nebotoka ilimi-liki yoweboya, Omailoka jokila hi mikaka we napaki ito monoka ujapa weki monoka monawa api-napi ibikaka weki li esa iki minabokuya ilimi-liki yowe. ");
INSERT INTO yby_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Sakiya ilimi-liki niwayoko Pita maya hoto apulu oko Jisesida maya emeke moloko woko Omailoka jokila he mekaka noibo we napamidana numudalau maya yoweko aya wemidana elekele oluholamakiya jo jeboto maya jo lapi oko ne. ");
INSERT INTO yby_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sa-noiyoko, monokamidana kanisole wehena ito Omailoka jokila hi mikaka we napahenasikiya Jisesida maya kohatune liki olisa onetibo gahenamuya ohu jeboya, ");
INSERT INTO yby_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","suwa labo wesiya ganipolimo lowa-sawa okoko li makokoto molamiki nenako, kohatabo gaya li soto molamae. ");
INSERT INTO yby_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Malokasiya sinikiki suwa ga mako Jisesidamuya sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Sa-loko liyoko eludawo maya ne: Monoka numuda napaya dadeloti viminabo maya jeko leda jekoko loweki makoki yupekaya nowideko aku nadeloti vametuha, aha galotiya vetubo ne loko lonebo ne, liki lae. ");
INSERT INTO yby_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Liki laboya, litabo ga li makokoto molamiki litabo ga minamiyoko, ");
INSERT INTO yby_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Omailoka jokila hi mikaka wesida we napanipo maya luwanipou sinokadanaki Jisesida maya obi nitabo galoya emokahoya le wili jeko letadawo gakaya nehe minamihe, loko loka oetaiye. ");
INSERT INTO yby_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Loko liboya, Jisesimamo ga lo mamoko epa moloikoko neyoko, Omailoka jokila hi mikaka wesida we napanipomamoya emoya Omailimo olisauti lilimitiye loko lo mololetokaibo we epoka lokaka noudawo Omaimidana ipala maya minape. ");
INSERT INTO yby_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Loko loka oetaiyoko, Jisesimamoya oo, aloya wehe loko lokaniyo, ito ga mako lo libituyo, eli-minalo: okulumauti we uti nemoya elewole wemidana ade lamawakaloka minoyoko, ito okuluma ijopa limu mupilaloya nolemoyoko alikaya muda-nelatae. ");
INSERT INTO yby_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Loko liyoko, Omailoka jokila hi mikaka wesida we napanipomamoya eliboma wehe lamiyoko, upalo nesala maya jeko bolotoko le hulikoko wewenalalesida maya emo gala eli-minatabo wewenasidaya aku nenahalo ju lokoko gala lideko eletune. ");
INSERT INTO yby_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Omai pulekolo libo gaya aloya elikae. Edimoya eleboya nenaha iye. Loko liyoko, muki wewenasiya oijo natibo ga maya lokainako, lina koha heletune likiki, ");
INSERT INTO yby_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","malokasiya etehu niitiki dadeloti maya okepalo nikohaiki emoya Omaimidana epaloti ga lo soto molokaka we minatadawoya, ekahimamo nokohaelaihe, lo soto moloko lo lemowo, liki layoko, monoka numudamidana elekele oluholasiya okepalo wasa jeboto maya dadeloti kohae. 58 Jon 2:19 62 Den 7:13 ");
INSERT INTO yby_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sa-noiyoko, Pita maya numuda lekaloka maya neyoko, Omailoka jokila hi mikaka wesida we napanipomidana oluwa makolimo niseko mudakoko, ");
INSERT INTO yby_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita maya jo lapi oko neyoko, muda-eloko wenu-kenu noidanaki sa-loko liye: Naseleti numutoti we Jisesimaki magoina monikaka niaibo we maya minane. ");
INSERT INTO yby_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Loko liyoko, Pitamamoya ga ladawoya monawa ele wehe lamobo ga nolane. Loko lokoko ateto maya nolimiyoko okole maya onowa liye. ");
INSERT INTO yby_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sa-noiyoko, aya elekele olumamoya muda-elokoko li esa iki minabo wewenasida maya sa-loko lo biye: Maya weya Jisesida unala ipalale yuhauti maya ne. ");
INSERT INTO yby_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Loko liyoko akuya yuwawa molaiye. Sakoya yuwawa molokoko lasolasi onawa neyoko, ayalo magoina sini-minabo wewenasiya Pitada maya emoya Galeli we maya minadanako, Jisesi maya nebokuti wehe loko minane. ");
INSERT INTO yby_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Liki layoko, Pitamamo Omaimidana omudaloya wehe loko noloe, suwa letuboya Omailimo nilime olisau molokatiyo, edimo nilabo weya nemo muda-elamobo wemuya nilae, loko liye. ");
INSERT INTO yby_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Loko nolibo epaki okolemamoya aku onowa liye. Loko liyoko, Pita maya Jisesimamo lo mibo galo maya okolemoya lowe yupeka owaha lamiyoko, nemodamuya yuwawa molonetatadawo yupekaya onawa loweki makoki ekolaiye loko lo mibo galo maya elekoko wije napa-napa iye. ");
INSERT INTO yby_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nekewa maya ho noyowiyoko, Omailoka jokila hi mikaka we napaki monoka monawa api-napi ibikaka weki, muki monokalo kanisoleki, ga li kohikiki Jisesida maya obi itakili nala jiki liki Paelatima neboto wae. ");
INSERT INTO yby_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sa-ikayoko, Paelatimamoya Jisesida maya muda-elokoko loka oetoko, emoya Juda wewenasida duliki wenipo maya minape, loko loka iyoko, Jisesimamo emokaya alo lokane. ");
INSERT INTO yby_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Loko lokaiyoko, Omailoka jokila hi mikaka we napamasiya Jisesida maya muki nesamamuya obi itikayoko, ");
INSERT INTO yby_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","akuya Paelatimamoya loka oetaiye: Emodamuya muki edawaki gaya nilaboya emokahoya labotoya ma lametadawo nehe. ");
INSERT INTO yby_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Loko loka oetaibotoya Jisesikahoya ga le wili jeko lo mamiyoko, Paelati maya ata etipa kiye. ");
INSERT INTO yby_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kiyapemamo latanipolesida esenipo vibo onawamu aku data kikaka niabo holi melekeu melekeuya edimo Juda wesiya nalauti le hulobetatane liki, wewena makomidana ulila layoko, nala numuku hulibitabo wewenasida maya doli heka doli heka iyoko aya wewena maya numudanipoloka wikaka ae. ");
INSERT INTO yby_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sa-iboya aya yupekaya we mako nala numuku neboya uliwa Balabasiyo loko neboya aya weya gamani wewenaki lowahina lebotoka we makomidana koha helekaiyoko nenako, ilimi-liki nisiki huli nala numuku hulikayoko nebo we ne. ");
INSERT INTO yby_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sa-okaiyoko nenako, Paelati nebotoka maya wiki emo lekaka ibomidana oko litiye, ");
INSERT INTO yby_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","liki loka itikayoko nenako, Omailoka jokila hi mikaka we napasiya Jisesida uliwa maya woko napa iyoko, edimo dulinipo maya lemekaiyoko mulunipou nosamiyoko obilo ilimi-liki wabokumuya Paelatimamoya elekoko sa-loko lo biye: Juda wewenasida duliki wenipoda maya nalautiya olutomikoyoko minabotoka wetiye liki nilahe. ");
INSERT INTO yby_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Loko libo maya, Omailoka jokila hi mikaka we napasiya muki wewenasida maya esenipouka li ahu liki sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Emodaya hulomikoko Balabasida maya le hetoka etane, liki layoko Paelatimamoya sa-loko lo biye: Juda wewenasida uliki wenipo ne likaka niabo wemamidanaya nenaha maya oetatuwe. ");
INSERT INTO yby_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Loko loka obetokaiyoko, akuya opa gaya ni-liki yoho yaha yalo maya helitiye ");
INSERT INTO yby_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","liki layoko, Paelatimamoya nenahamuye loko loka obetaiye. Nena olisa okaiyoko nilae. ");
INSERT INTO yby_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Loko lokaiyoko, akuya opa-napa ga layoko, Paelatimamoya li nupa i-minabo wewenasida dukauka dowa letiye loko Balabasida maya olutowetaiye. Sakokoya Paelatimamoya liyoko Jisesida maya uhedawaki oijoloti kohaiki liki wiki yoho yaha yalo maya nililoti jiki oto ideko helitiye loko dadeu maya molaiye. ");
INSERT INTO yby_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sa-okaiyoko, imiki wesiya Jisesida maya uliki we napamidana numudala luwato maya ilimi-liki yowiki imiki we malokasidaya dilipi nupa ikiki, ");
INSERT INTO yby_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","uliki we lolo itiki uhedawaki adakoli maya olo jitikiki, uliki wekidana li lolo itiki okohudago upalo nesa hana olo jitiki, ");
INSERT INTO yby_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","okepa jiki epoka liki sa-liki lae: Esekane aliyo, Juda wewenasida uliki wenipomae. ");
INSERT INTO yby_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Liki likadanaki, seida oijokidana oijolotiya kohaikiki etehu nitadanaki, ilauka maya di bola nihiki suwa nesa liki okepa okepa je. ");
INSERT INTO yby_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sakiya uluna ga li suwitadanaki, okohudago nesa olo jitabo maya ololotiki li hulikiki eimola upalo nesala maya li olo jitikiki, yoho yaha yalo maya nililoti maya kohaiki jiki oto ikili ilimi-liki wae. ");
INSERT INTO yby_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sa-ikiki ilimi-liki anulo niwayoko, we mako uliwa Saimoniya Apilika mikaukati we Sailini numutoti we, Alesate ito Lupute ahonipoya mijalaukati noniseko mudaibo maya ula molikayoko, Jisesimamo oheko leko wibo yala maya ilimeko ohetoko wiye. ");
INSERT INTO yby_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sa-okaiyoko, Jisesida maya ilimi-liki wiki eba mako Gologotae loko lemo gateutiya uliwa madonipo abuhawae loko nebotoya wiki hetikiki, ");
INSERT INTO yby_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jisesi maya natiye liki waeni noku maya upala elola wokatiye likiki, mukasikidana elibo nesakiya li opa napa ikiki me. ");
INSERT INTO yby_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Saki mebo maya, namiyoko, yoho yaha yalo maya kohaki tikiki upalo nesa maya ekahoma litihe ekahoma litihe likadanaki, kasikidana ono mako molae. ");
INSERT INTO yby_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sa-ikiki mudai-minayoko go maya lokoko ho maya yoweko elewole noiyoko kohakiki yalo maya te. ");
INSERT INTO yby_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Obi itabomidana gaya Juda wewenasida uliki wenipomae liki nalawa iki madonalo maya titikayoko ne. ");
INSERT INTO yby_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Sa-ikiki ukelelo we makoya ade lamawakaloka kohaiki te, ito makoya ade atahakaloka kohaiki tikayoko ne. ");
INSERT INTO yby_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Sa-iyoko, hapa yeikalaya monoka bukugu luhuwa mako jenebo maya niseko ulolotiye. Sa-loko luhuwa jenebo ne: Emo maya lahelamibo nesa lolo iki ukele-hakele ikaka abo weuma li moliki uliwa lae. ");
INSERT INTO yby_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sa-ikayoko, wewenahena wiki nisiki abo wewenasiya madonipo maya gima ikiki ulana molikigo lika lika iki sa-liki lae: Oho, monoka numuda napa maya jeko leda jekoko loweki makoki yupeka nowideko aku vetuwe lokaka welika, ");
INSERT INTO yby_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","emokalikaya yoho yaha yalotiya lemo mikau matoka jeko jowo. ");
INSERT INTO yby_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Liki layoko, Omailoka jokila hi mikaka we napaki ito monoka monawa api-napi ibikaka wekiya asaikiya eme jiki sa-liki lae: Muki wewenasida olisa lebokuti dilipe dowa lokaka noibo we maya neboya, eimoladaya sametibo nesa lekaiye. ");
INSERT INTO yby_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Emoya Isilaelo wewenasida olisauti lilimekaka we ito uliki wete netiboya, olotiya yoho yaha yalotiya pasokoko lemekadeko mudakokote maya galaloya wati gaya lokaka noiye loko emesalo moloko eletudanako, liki layoko ukelelo we lowe maya Jisesida apila maloka maloka kohaidiki tebo wemasiya upalo hapalo ga laiye. 21 Lom 16:13 24 Sam 22:18 29 Sam 22:7; Sam 109:25 29 Mak 14:58; Jon 2:19 ");
INSERT INTO yby_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sa-ikayoko, holiga maya neboya, muki mikauka maya lubu je-loko woko ludaka 3 kiloku iye. ");
INSERT INTO yby_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sakoya ho maya le yoho notiyoko, Jisesimamoya ai moloko Eloi, Eloi, Lama sapakatani loko liboya, lemo gateutiya Omainelika, Omainelika, nenaha iyokoma hulonimikane loko liye. ");
INSERT INTO yby_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Loko liyoko, amaitoka minabo wewenamasiya eli opa-opa ikiki Omaimidana epaloti ga lokaka noibo we Ilaijada maya ju noliye, liki lae. ");
INSERT INTO yby_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Liki likadanaki, we makolimoya lolosa jeko woko noikidana nesa maya waeni ekesa noku hekoko akepa oijo lolowalo maya molo omekoko le sawa jeko Jisesi maya natiye loko miye. Sakoya nomeko sa-loko liye: Ilaijakaho niseko pasoetatihe, muda-minatune. ");
INSERT INTO yby_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Loko liyoko, Jisesimamo ga napauti nolidanaki ahu lo nohuloko heliye. ");
INSERT INTO yby_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sakoya noheliyoko, monoka numuda napau Omaimidana owisalo yowikaka niabo ateto imaha lawolawoloti moli-minabo maya lolowaloti yokawaya bolotoko lemeko le maloka maloka iye. Sa-ibo maya Omaimidana omudalalo aha sinatudawo nesa liye. ");
INSERT INTO yby_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sakoya Jisesi maya ai napa nomolaidanaki helekaiyoko, lowa wesida ujapa wenipo makoya Jisesida omudalo maya sino-minoko, maya weya wehe loko Omaimidana ipala netiye loko liye. ");
INSERT INTO yby_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Saboya menakipa malokasiya hoto apulu iki sini-miniki mudai-minae. Ayauya Magadala numutoti mena Meleya ne, ito Mele makoya Jemisite lasola ito Josepute donipo, ito Salomekilemakiya magoina sini-minae. ");
INSERT INTO yby_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aya menakipasiya omutoko Jisesi maya Galeli numutoka maya neyoko magoina niwadanaki, nasahili itiki minabo menakipa minae. Sakiki Jisesilekiya magoina Jelusalemu numutoka yowebo menakipa malokakiya ayalo minae. 34 Sam 22:1 36 Sam 69:21 38 Eks 26:31-33 41 Luk 8:2-3 ");
INSERT INTO yby_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ludaka maya holi onawamidana saina li lolowa ikaka onawa maya alili okaiyoko, holi onawa maya nisekoya onawa makoko aha neyoko, ");
INSERT INTO yby_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Alimatiya numutoti we Josepuya monoka kanisoleuti neboya duka miminabo weya Omailimo uliki we ilime soto pitibokumu ujapa oko nebo we maya omodala wibo maya ele hulikoko, Jisesida onola maya lekolo Paelatida maya loka oetaiyoko, ");
INSERT INTO yby_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jisesi maya alo helihelae loko ata lowe kekadanaki, lowa wesida ujapa wenipomamidana maya ju lokaiyoko nisiyoko, Jisesi maya alo helihe loko loka oetaiye. ");
INSERT INTO yby_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Loka oetokoko, lowa ulalo wesida we napanipomidana gala maya elekoko Jisesida onowa maya Josepu maya aha leko wetiye loko liye. ");
INSERT INTO yby_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sa-lokaiyoko, Josepumamoya Jisesida upala wasa jitibomuya lawo-lawo ukulo mako meina hekadanaki, emoki we malokaki wiki onowa maya yaloti pasiki li mikalo ikadanaki lawo-lawo ukulo lalouya wasa jikiki liki wiki ono molikaka ebaya ehada numuda Josepuma eimola golotoneboku hulimikiki, ehada napa makolotiya ipisiki li wiki aya alemidana epalo maya jiki lilae. ");
INSERT INTO yby_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Sa-ikiya nimolayoko, Magadala numutoti mena Mele ito Mele mako Josesida dolate maya ayalo miniki mudai-minaiye. ");
INSERT INTO yby_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Onawa makokoma minikiki holi onawa maya alo suwokaiye likiki Magadala numutoti mena Mele ito Mele mako Jemisida dola ito mena Salomelekiya Jisesida ono upalaloma nuwalaki netupama hiletatune liki meina hitae. ");
INSERT INTO yby_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sakiya meina hiki likiki nekewa napa yeikamaya Sadeu maya ono molabotoka maya wiwa wiwa niayoko, ho maya yowiye. ");
INSERT INTO yby_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sakiya ono molaboto alili wikadanaki edimonipolokaya wetome-katome iki ehada napa maya ale epaloti maya ekahimamo ipisoko le huloletatiye liki lae. ");
INSERT INTO yby_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Liki likiki mudabo maya, aya ehada maya alo ipisiki li ilikaloka molikayoko, ale epawa maya golotoneyoko mudai-minae. ");
INSERT INTO yby_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sa-okaiyoko, aya aleu maya yowiki mudabo maya okanaki we owahakidana makoya ukulo lawo-lawo hana olo jekoko lamawaka sinoneyoko, mudaikiki aya menakipa maya ololo ae. ");
INSERT INTO yby_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sakiya ololo niayoko, aya wemamoya ololo amilo loko lo biye. Edimoya Naseleti we Jisesida yoho yaha yalo kohaiki tebo we maya muda-elakili nisehe. Aya we maya mauya minamiye. Alo sinokaiyo, onowa molaboku maya mudalo. ");
INSERT INTO yby_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mudaikiki wiki unala ipapala yuha malokasida maya ito Pitalesidamakiya omutoko lo libibo nesa leko le omutokoya Galeli mikauka maya wetibo nenako, yaloka maya wiki muda-elakilae, liki li bilo. ");
INSERT INTO yby_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Loko liyoko, luwo-luwo nijedanaki ololo abo nenako, ayauti maya hetoka maya limikiki oli wae. Sakiya domoda adoha wokaiyoko nenako, oli niwiki we makomidana wetome iki li mamae. 7 Mat 26:32; Mak 14:28  ");
INSERT INTO yby_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisesi maya Sadeu nekewa napa aleuti lubukaya sinokadanaki Magadala numutoti mena Mele oloha lahelamibo 7-palasidaya ukauti kohaidoko doli hibo menamidana omudaloya ada soto piye. ");
INSERT INTO yby_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sa-okaiyoko aya menamamoya woko wewenalale maya miluma-aluma eliki wije nama nileyoko wetome oko lo biye. ");
INSERT INTO yby_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Helenebokuti maya sinokoko aha neyoko mudaoe loko libo maya aya wewenasiya elewole iki data kamae. ");
INSERT INTO yby_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Sa-okaiyoko, we loweya ohuguka maya niwaiyoko Jisesi maya omutoko nebokidana amoko aito aweyaha oko domudalo soto piye. ");
INSERT INTO yby_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sa-okaiyoko, edimosiya wiki maloka wewenasida maya wetome iki li beiboya, aya wewenasiya elewole iki data kamae. ");
INSERT INTO yby_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Alikaya Jisesi maya unala ipalale yuha 11-pala maya edimonipogo li esa iki miniki nodenesa ninayoko, soto pe bekadanaki aleuti maya sinokoko niseko neyoko emoda ada muda-elabo wewenasida ganipo maya wati ga lae liki lamabo ito data elewole iki elamabo maya nenako, yamuya auha biye. ");
INSERT INTO yby_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sakokoya edimoya numuto namatoya wiki ho noyowibotoka ho nolimibotoka moniki muki wewenasidaya nemo ane lalo maya wetome iki li bilo. ");
INSERT INTO yby_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sa-ideko edimo gatipo eli elewole ikiki monoka noku udatabo wewenasida maya olisauti dilimekoyoko minatabo ne, ito gatipolo eli elewole amitabo wewena maya jomidana epa nesala lolo ikilae. ");
INSERT INTO yby_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ito maya ganeya elewole iki elitabo wewenalokaya sako soto pebetakolaiye: Nemo nulinelotiya oloha lahelamabosida maya kohaidiki doli hitae. Ito aito aito dono jiki ga liki likilae. ");
INSERT INTO yby_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ito oletehaya opa li sawa jiki minatabo ito nalisa no nataboya, yatoka nesalimoya dilipe opa napa amekolaiye. Ito saina delatibo wewenasida maya dadeloti sisiwanipo jitaboya, haka likilae. 15 Apo 1:8 ");
INSERT INTO yby_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sa-loko we napa Jisesimamoya lo bekaiyoko, Omailimoya ilime-loko okulumau yoweko ade lamawakaloka hulotoneyoko ne. ");
INSERT INTO yby_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Sa-iyoko, unala ipalale yuhamasiya muki numuto namato maya wikadanaki gala maya li nibeyoko, We napamamo dilipe wati idanaki oliwaki elewole nesa le soto pibodunuya ganipo maya le elewole obetaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Muki wewenasiya luwawateu Jisesimamo le soto pibo nesama li emesalo moliki luhuwa jebo. ");
INSERT INTO yby_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Monoka likaka wewenasiya mudai wehe likikiya aya luhuwa ji lemebo nenako, ");
INSERT INTO yby_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","nemo aya gawa lalo maya moletoko le wehe loko elekoloya, Teyopilasi uliki wene yamalae, luhuwa maya le eto eto oko je noemoe. ");
INSERT INTO yby_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Lepekokoya emo aya wehe loko ga ulawa neyo loko elitane. Judiya mikaukaya uliki we napa Helotiya ujapa oko nebo yulakaya, ito Omailoka jokila he mekaka weya ulilaya Jekolaeyaya Abaijada nalala minabokuti nebo ne. ");
INSERT INTO yby_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Aya weya mena mako Elonida ouvamelauti liboya ulilaya Elisabeti. ");
INSERT INTO yby_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Edimoya Omaimidana omudaloya duka laloki minaidanaki, Omailimo lo hukoko libo gaya lihimanipo minamibo miniki eli-liki minaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabetiya ohuda mena nenako, oluhonipo etamiki miniki iloho laiye. ");
INSERT INTO yby_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jekolaeyada yowanulo laini maya monoka numuda napauma uda jitabo onawama alili okaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Omailoka jokila hi mikaka wesiya likaka abo nesa liki yowanunipo maya li eto eto iki li-liki niwayoko, Jekolaeyadama Omaimidana uda je mo liki ilime eto ikayoko, monoka numuda napa ulauma yoweko nuvala lalo wibo nesalotima Omai uda je nomiyoko, ");
INSERT INTO yby_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","muki wewenama oho ulau miniki we napaloka liki minae. ");
INSERT INTO yby_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sa-ikiya nilayoko, We napamidana okanaki wela makoya niseko uda jikaka namabetamidana lamawakalokama sinone. ");
INSERT INTO yby_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakoya sinoneyoko, Jekolaeyamamo mudakadanaki ololo oko upau lekadanaki omodala wiye. ");
INSERT INTO yby_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Omodala wokaiyoko, okanaki wemamoya sa-lokoya lo miye: Jekolaeyao, omodaka wamideyo. We napamidana epoka noladawoya eleneyo, menaka Elisabetimamo oluholaki minoko oluho etatibo maya ulilaya Joniyo loko molo. ");
INSERT INTO yby_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mulukau lalo eleko oli mekolane. Sa-ideko muki wewenasiya aya oluho soto pitibokumuya dumu helitibo ne. ");
INSERT INTO yby_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sa-ideko aya oluhomoya We napamidana omudalaloya we napa lolo oko netiye. Ito aya oluholimoya waeni nohe ito nei nohe moseko dolada ohumanauya nedeko, Omaimidana weuna oluholimoya ukauya waitetiye. ");
INSERT INTO yby_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Sa-okadeko, Isilaelo wewena mukima lahelamibo anugutima dilipe lika okadekoya, we napa Omailokagoya nisikilae. ");
INSERT INTO yby_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ito Ilaija okaka ibo nesa leko abuha moloko We napatemidana anula wiletoko gala maya lo soto molokaka oko minakolaiye. Sako minoko olopa wewenasida ito oluho lasomosolasida dukauma le nupa obetatiye. Sa-okadeko, ga eli hulikaka wewena maya duka laloki wewenasi nielebo monokaya elikilae. Sakoya ya yowanuya lideko, muki wewenasiya we napamuya ewa iki minakilae. ");
INSERT INTO yby_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Okanaki wemamoya sa-loko lo mekaiyoko, Jekolaeyamamoya onoto leko sa-loko lo miye: Menaneki ito nemokiya aloya iloho molokoinako watiya lane loko elamoe. ");
INSERT INTO yby_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Loko liyoko, okanaki wemamo sa-loko lo miye: Ele-minape. Nemo ulineya Gebiliyoloma minoe. Nemoya Omaimidana omudalo minoko sako nobo we maya emokahoya noli hekaiyoko lemeko ga lalo maya lo noemoe. ");
INSERT INTO yby_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sa-oneyo, elo. Ga maya lo emoboya watiya lane loko lamaniyoko epakaya he lagoli okadeko nei moloko mino-loko wokoma lo emobo aya niseko ulolotokadako alikaya ga letane. Nemo nolobo gaya hataga amekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Loko lokaiyoko, Jekolaeyama monoka numuda napauya sa-ikiya alo-nalo likaibolimoya onawa hana minokaiyoko nenako, muki wewenama ewa iki miniki data etipa ke. ");
INSERT INTO yby_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sa-ikayoko nenako, Jekolaeyama alikaya lemekoko ga lo bitibo nesamuya opa iye. Gala maya wehe lamiyoko maya wewenamasiya monoka numukuya wamokidana mudaonetiye. Liki nilayoko Jekolaeyamamo aya gama nena nena oko lo bituhe lokadanaki adelotima aweyaha oko sa-iye, ga maya lo bamidanakiya. ");
INSERT INTO yby_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakoya neyoko, yowanu litabo onawama suwokaiyoko Jekolaeya le numutokama le wili jeko wiye. ");
INSERT INTO yby_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Sa-ikayoko, alika maya menala Elisabetima oluholakiya ne. Sa-okaiyoko, ilohomoki oluho ohumana jiye liki litahe loko ukada lade maloka suwiyoko halukoko numukugoya nedanaki sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","We napamamo molaibo onawa maya alili okaiyoko ohuda menama minobomuye loko nilime lalo onetaidanaki, owane helobo nesama olotiya le suwonetokaiye. 5 1 Klo 24:10 15 Nam 6:3 17 Mal 4:5-6 19 Den 8:16; Den 9:21 ");
INSERT INTO yby_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Loko liyoko, oluholaki minoko ukada lade maloka suwoko ito maloka makoko iyoko le hulikaiyoko, Omaimoya okanaki we Gebiliyoloda oli hekaiyoko, Galeli ebaku Naseleti numutoma wiye. ");
INSERT INTO yby_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Naseleti numutokaya yaha mena makoya uliwaya Mele loko ne. Aya menaya Dewitida ouvamela yuhauti we Josepuda mudai molikayoko ne. ");
INSERT INTO yby_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Sa-iminabo nenako okanaki wemamo aya oluma nebotoka nisekadanaki sa-loko lo miye: Omaimo ilime lalo oetokaiyoko minadawo olulika hulu emotoka minadeyo. We napama emotokaya ne. ");
INSERT INTO yby_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Loko okanaki wemamoya lo mekaiyoko, Melemamo elibo maya eda elokaiyoko, sa-loko ukalaukaya eliye: Ladawo gamidana monawaya nenae loko netiye. ");
INSERT INTO yby_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Loko noeliyoko, okanaki wemamo sa-loko lo miye: Mele, omudaka wamideo. Omailimo muda-elaiboya wehe lo-minane. ");
INSERT INTO yby_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Oluhokaki minoko oluhoka etadadawoya ulilaya Jisesiyo loko etoko molo. ");
INSERT INTO yby_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Emoya napa-napa we lolo oko nedeko, Yowau wemidana ipalamae liki litabo neyo, ito We napa Omailimoya latala Dewitida adakolilama ohetokadeko we napa lolo oko netibo ne. ");
INSERT INTO yby_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ito Jekopuda ouvamela yuhautiya ujapa owa owa oko minakolaiye. We napa lolo etibomidana elewoleya suwamoko hana-pana mino-loko woko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Loko okanaki wemamo lokaiyoko, Melemamo sa-loko lo miye: Nemoya wauneki omeko minamoiye. Sa-ominonako, noladawo gaya nena nena okoma niseko litibo ne. ");
INSERT INTO yby_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Loko liyoko, okanaki wemamo sa-loko lo miye: Omaimidana weuna oluholimoya emo minadawotoya lemekolaiye. Ito Omaimidana elewoleyalalimoya ilime lalo oetakolaiye. Sa-ekolainako, ipaka etadawoya eto oko nebo Omaimidana ipalae liki likilae. ");
INSERT INTO yby_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Ito ga mako lo emekoloyo, ele-mino. Emoka minadawo yuhauti mena iloho Elisabeti maya oluholaki neyoko ukada 6-pala alo wokaiye. Agae, ohuda menama neboya, Omailimo lolo ametibo nesaya ma minamibo nenako olotiya oluholaki ne. ");
INSERT INTO yby_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Loko lokaiyoko, Melemamoya sa-loko lo miye: Nemoya We napamidana elekele olula minoe. Sa-ominonako, noladawo nesaya aha le soto pitiye, loko lokaiyoko, okanaki wemamo hulomikoko wiye. 27 Mat 1:18 31 Mat 1:21 32-33 2 Sam 7:12-16; Aes 9:7 37 Jen 18:14 ");
INSERT INTO yby_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Melema mino hana amokoya Judiya ebatoka weuha makomauya numuda mako nebotoka wiye. ");
INSERT INTO yby_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wokoya aya weuhau Jekolaeyada numudalauma yoweko menaladama eke loetaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sa-okoya eke noloetaiyokoya, Elisabetida ohumanautima oluhomamo hugili oko momoga iyoko eliye. Sako elekoko, Omaimidana weuna oluhomamo Elisabetida obohalauma lemeko waitoko minokaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ga napauti Meleda maya sa-loko lo miye: Omailimoya muki menakipauti ilime eto okoko makuya emekaiyo, ito oluhoka etadawokiya lusa voetokaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","We napanemidana idola minane. Mena ebili maya minoboya nemotokaya nenaha iyoko nisene. ");
INSERT INTO yby_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Elo. Eke adoha nolonetaniyoko ohumaneuti oluhonema momoga oko omola adoha noyowiye. ");
INSERT INTO yby_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ito emoya We napamamo lo mibo ga maya woko letiye loko elewole oko ata elekaniyoko Omailimo maku mekaiye. Yamuya eloyoko wati iye. ");
INSERT INTO yby_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Loko liyoko, Melemamoya sa-loko lo miye: Nemoya nukaneya We napamidana epoka noloe. ");
INSERT INTO yby_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ito weuna oluhonedunuya Omaimo lahelametibo nesauti nilimitibo wemuya oli meko epoka noloe. ");
INSERT INTO yby_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ito nemo elekele oluwa lemeko minobo maya olotiya nilime-loko noyowiye. Sa-noinako, alikaya mini-liki yowitabo wewenasi nemodamu Omaimo maku nimibo menae liki likilae. ");
INSERT INTO yby_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sa-onenako, Omaiya elewoleyalaki welimo nemotoka saina ulawa le soto molokaiye. Sa-onenako, emo ulila maya eto okoya ne. ");
INSERT INTO yby_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Emoda oli mitabo wewenaya mini-liki yowiki minaboya Omailimoya nasahili obetokaka noiye. ");
INSERT INTO yby_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ito edimonipomu eleyoko yowekaka noibo wewenaya eimola elewoleyalaloti dilipe hulokaka noiye. ");
INSERT INTO yby_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ito duliki wesi sa-inayokoma onowelaki siyaloti dipisoko le hulikaiyoko mohiliki limikaka niae. Sakokoya limiki minabo wewenasida duli maya leko yowekaka noiye. ");
INSERT INTO yby_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ito uvaminanipo minamibo ito nodemu helikaka niabo wewenasida maya saina ihilawa biyoko niki dohumanipo iki minikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ito uvaminanipoki wewenasidama hulobetokaiyoko yowiki limiki minikaka niae. Omaiya ukala laloki we nenako, lemo Isilaelo wewena elekele oetoko minudawolaya lilime lalo oletaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Latate Aebalahamu ito ouvamela mota mini-liki nisiki minabo wewenalokaya ga loko hukobetoko sa-ibomidana ihilawama soto pekaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Melemamo sa-lokokoya Elisabetite maya miniki ukada loweki makokiya le hulikoko akuya numudaloka le wili jekoya wiye. 46 1 Sam 2:1-10 55 Jen 18:14 ");
INSERT INTO yby_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sa-iyoko Elisabeti maya oluho etatibo onawama nisekaiyoko, ipalaya etaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Etokaiyoko, muki wewenalale ito iwelalesiya We napamamo he elowo oetaibo ga maya elikikiya Melelemaki mulunipou wati iye. ");
INSERT INTO yby_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sa-okaiyoko, onawa 8-pala yamidana sako wokaiyoko, Omaimidana ganelama aya ipamidana upalaloma moloetatune likiki muki wewena nisiki li esa ikiki ulilamaki aholada ulilalo molatune likiki lae. ");
INSERT INTO yby_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Liki layoko, dolamamo auha lokoko O'e. Ulilaya Joniyo loko molatune. ");
INSERT INTO yby_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Loko lokaiyoko, sa-liki li me: Aiye, emo latakalesida ulinipo mako sako minamiye. ");
INSERT INTO yby_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Liki auhaya likadanaki Jekolaeyadamamu ipalada ulilama nenae loko molatihe likadanaki dadelotima aweyaha ayoko, ");
INSERT INTO yby_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jekolaeyamamo pepama liki nisilo loko adelotima aweyaha okaiyoko, liki nisiki mikayoko, yaloma ulila maya Joniyo loko luhuwa jiye. Jekaiyoko, elikadanakiya agae, likiya lae. ");
INSERT INTO yby_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sa-iyoko, Jekolaeyada epa ulumalama enemane oko wehe liyoko, Omaimidana epoka liye. ");
INSERT INTO yby_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sa-iyoko, iwelale malokasiya elikadanaki domodanipo adoha wonebo ne. Sa-iyoko Judiya ebakuka bolaukahena ito muki numutokahena aya gama wetome-katome ayoko, ");
INSERT INTO yby_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","muki wewenasiya wego menago ganipoma elikikiya eli madonipou moliki sa-liki lae: Oluhoya napa lekoko nenaha etihelae liki lae. Liki laboya, We napamidana elewolelama aya oluholo neyoko mudaikiki labo ne. 59 Liv 12:3 ");
INSERT INTO yby_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ito ahola Jekolaeyadaya Omaimidana weuna oluholimo ukalau lemeko minokoko ilime lalo okaiyoko, ga mako sa-loko ohuwa hukoko liye: ");
INSERT INTO yby_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","We napate Omaimoya Isilaelo wewena lemodaya lilime wati okadanaki lahelamibo nesautima lilimekaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Elekele oluhola Dewitida ouvamela mota lahelametibo nesauti lilimitibo ahoda maya le sinoko hekaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hapaya eimola epalauti ga likaka wesiya dilime lalo iyoko, ga mako koha moliki sa-likima liminaboma ne: ");
INSERT INTO yby_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Lowa hi limiki asowalaki nesa li limiki sa-niabo wewenasida dadeutiya lilime oli ekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Latatelesidama eke lobetoko dilimituwe loko lo molaibo ne. Ga loko wasa jekaka gaya liboyaloya ele-minoko sa-oletakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ito latate Aebalahamudama sa-loko elewole oko lo moloetaibo nenako, ");
INSERT INTO yby_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yamuya lowa ulatelo wewenatelesilokatiya lilimekadeko hulu oko minakolune, ");
INSERT INTO yby_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ito lukaya eto eto oko minoko gateya minamideko elekele oluhola lolo oko mino-loko woko minoko heletune. Sa-onenako, Omaimidana epoka letune. ");
INSERT INTO yby_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ito emo maya ipalikaya, We napamidana gala lo-lele moneko anulaya wiletataniyo, emokumuya okulumauti Omaimidana epalauti ga lokaka we likiya likilae. ");
INSERT INTO yby_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Emokahoya Omaimo wewenalale yuhasida esenipo vobetaibo gama lo bekaniyoko, eli wehe likadeko lihimanipoma le hulobetakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Lemo Omaitemoya lemo milumate elekaka noinako, emo letibotoya okulumaloya okululuwa nohokeko ");
INSERT INTO yby_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","lubukamidana ukauka ito helekaka anuguya minudawo wewenaya leya jeko le lameda loletakolaiye. Sa-ideko, onawa lalomidana anulaya soto pekadeko yauya wekolune, loko Jekolaeyakahoya liye. ");
INSERT INTO yby_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ito maya ipaya napa leko elewole okoko mumusopa mikaloka woko nedeko, yowanu litibo onawaya alili okaiyoko, nisituwe lokoya Isilaelo wewenasitokaya soto pene. 76 Mal 3:1 79 Aes 9:2 ");
INSERT INTO yby_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ya yupekaya Lomu wewenasida uliki wenipo napa neboya uliwaya Agustasiyo loko nebo nenako, emokahoya numuto namato wewenasida dulinipo litae loko gaya hulaiyoko wiye. ");
INSERT INTO yby_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ya yowanulaya hapa lamabo ne. Kuwiliniyusiya Siliya ebakukaya uliki we neyoko ya yowanuya api iki lebo ne. ");
INSERT INTO yby_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sa-niayoko, muki wewenasiya lulitema litae liki latanipolesida oto ebanipoloka wayoko, ");
INSERT INTO yby_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josepuya Dewitida ouvamelama nenako, emokiya asako Galeli ebaku Naseleti numutoka nebototiya hulikoko Judiya ebakuka Dewitida oto ebala Betilihamugama yowiye. ");
INSERT INTO yby_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yoweko muda molitabo mena Meledama oluho ohumanakiya ilimiyoko magoina waiye. ");
INSERT INTO yby_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wiki yaloka miniki menalamo oluho etatibo onawama alili okaiyoko wenoka wewena udikaka numudama liki lokaiyoko nenako, alowo jikiki bulumakasi numukuma yowiki minaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Melemamoya ada ipalama etokoko adalalotima hitoetokoko bulumaka jasida nodenesa bikaka lapeuma huloetoneyoko udone. ");
INSERT INTO yby_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sa-okaiyoko, aya yupekaya aya mikaukati maloka wewenama lubukaya ametoka miniki sipisipi janipolo ujapa iki minabo ne. ");
INSERT INTO yby_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sa-ikiya minayoko, We napamidana okanaki wela makoya nisiboya aya wewenasidama We napamidana lamedalimo he hada obetokaiyoko nenako, domodanipo adoha wonebo ne. ");
INSERT INTO yby_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sa-iyoko, okanaki wemamo sa-loko lo biye: Nemoya ga lalo nesa leko nolemoyo, domodatipo wamideyo. Yamidana ihilawaya muki wewenasitoka soto pideko mulunipouya aila uluma silekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aya nesaya sakoya ne: Olotiya lahelamibo nesauti dilimitiye loko lo mololibetaibo we maya Dewitida oto numutokama soto nopiye. ");
INSERT INTO yby_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ito anewa mako lo libituyo, elilo. Oluho aida makoya lawolawolotiya jiki hitiki hulitikayoko jasi nodenesa molikaka lapeuya numuku udoneyo, wiki mudalo. ");
INSERT INTO yby_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Loko lo bekaiyoko, wavu-liki okananipoki wewenamasi enemane iki okulumautima limikiki iwenipole minabotoma li esa ikiki Omaimidana epoka liki nama mako sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Okulumau Omaimidana oli meko epoka letune. Maya mikauka Omailimo umula helibo wewenasitokaya hulu soto pideyo. ");
INSERT INTO yby_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Likiya okananipoki wewenamasiya likadanaki, akuya li okulumau yowikayoko, ja ujapalo wemasiya sa-liki wetome-katome ae: ");
INSERT INTO yby_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Lemoya Betilihamu numutoka lemeko We napalimo lo limibo nesaya soto piboto mudatune. ");
INSERT INTO yby_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Liki likadanaki enemane iki wikiya Meleko Josepukoma dilipi soto molikiki, oluho aida maya bulumakasida nodenesa lapeuma udoneyoko muda-elae. ");
INSERT INTO yby_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Muda-elikikiya okanaki welimo yaya oluhomu libo gama wetome iki li be. ");
INSERT INTO yby_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Sakiki, sipisipi ja ujapalo we maya akuya li welepa jiki wiki okanaki welimo libo nesama mudabomuya Omaimidana epoka liki ulila li sawa jiki minae. ");
INSERT INTO yby_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sa-iyoko, aya wewenasida depauti awa elebo wewenama dukaukaya lahelepa iyoko, Mele maya muki gama le madonau molokoko ata keke oko nebo ne. ");
INSERT INTO yby_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ipa Jisesi maya soto pekaiyoko, onawa 8-pala wokaiyoko aya ipamamidana upalaloya Omaimidana anela molitiki ulilama Jisesiye liki molae. Aya ulilaya Meleya owaha oluholaki minamiyoko okanaki welimo omutoko lo miboto molaiye. 21 Luk 1:31 ");
INSERT INTO yby_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Aya ipa etaibokumu upama li lalo itae loko Mosesekaho lo hukoko libo nesa liki lolo itatabo onawama alili okaiyoko, Meleko Josepukomasi ipa Jisesidama ilimi-liki Jelusalemu numutokama yowiki We napa Omaimidana ipala netiye liki anela molitaiye. ");
INSERT INTO yby_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sa-iboya We napamo sa-loko libotoma elikiki sa-iye: Ada oluhoma soto nopidekoma, We napamidana oluhola netiye liki milo. ");
INSERT INTO yby_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ito Omailimoya sa-loko lo hukaiye: Nama luhuhe ito omeyasikidana nama loweya liki wikiya nemoda uda ji nimilo. Loko lo hukaibo gama elikikiya nama lowemaki liki waiye. ");
INSERT INTO yby_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sa-iyoko, Jelusalemu numutoka we mako ulila Simiyoniyo loko nebo weya wehe loko monokalaki we ito Isilaelo wewenasida lahelamibo nesauti dilimitiye loko lo molaibo wemuya ewa oko minokaka onebo we ne. Aya wemidana ukauya Omaimidana weuna oluho lemeko waitoko minoko ");
INSERT INTO yby_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","sa-loko lo miye: Emoya helamoko aha minoko We napayamo maku mibo we lahelamibo nesauti dilimitiye loko lo mololibetaibo wema muda-elakolane. ");
INSERT INTO yby_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sa-iyoko, Simiyonidama Omaimidana weuna oluholimo ilime sahu okaiyoko monoka numuda napauma yowiye. Sa-iyoko Meleko Josepukoma Omailimo libo nesa liki lolo itatae liki ipa Jisesidama ilimi-liki monoka numukuma yoweiyoko, ");
INSERT INTO yby_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyonimamo ipa Jisesidama yanawa oko lenedanaki Omaimidana sa-loko epoka loko liye: ");
INSERT INTO yby_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","We napane yamalae, lahelamibo nesauti lilimitibo we maya olotiya nomudalotiya mudakoe. Ga lo molonetadawoma ayaloya niseko ulolotokainako, nemoya emo elekele wekama nilime monokau moloko nilime hulu ideko helituwe. ");
INSERT INTO yby_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Emokahoya numuto namato wewenasi muda-lelatae loko lilime lalo etibo wema ilime soto molokane. ");
INSERT INTO yby_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sa-okainako. ya welimoya hetoka wewenasida dukauya he hada ideko nisiki monoka elikilae. Sakoya Isilaelo wewenasida duli maya le sinakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Loko ipa Jisesidamuya liyoko, dolako aholakomasi agae liki laiye. ");
INSERT INTO yby_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sa-iyoko, Simiyonimamoya eimola maku meko dola Meledama sa-loko lo miye: Ele-minape, maya ipaloya Isilaelo wewenasi lopo-topo ga litae loko loneboma ne. Aya oluhomidana galalotiya maloka wewenaya demesa mikiki huluwai liki limi jitabo ne. Ito malokaya elewole iki sinakilae. Sako emoya elewole oko netibo nenako. muki wewenasiya duka kohai miki liwi letiwi itatabo ne. ");
INSERT INTO yby_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sa-ikiki alikaya nikohadeko emoya ipakamuya miluma elekolane. ");
INSERT INTO yby_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Loko lokaiyoko, mena mako Anao loko nebo menaya Omaimidana epalauti ga lokaka mena ne. Emoya Panuweloda oluwa Esada nalalauti weloya niseko nedanaki meleke 7-pala le hulikaiyoko waunama helekaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","eto mena lolo oko mino-loko yowiboya meleke 84-pala le hulikoko iloho molaiye. Ito monoka numuda napa maya hulamoko muki yulaka ludaka nekewaya Omailoka monoka lokaka oko nedanaki, monokalokago ekolo nodenesa moseko nedanaki Omailokaya lokaka iye. ");
INSERT INTO yby_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sa-okaka ibo nenako, aya onawaloma niseko Omaimidana epoka lidanaki Jelusalemu numutokama Omaimo dilimitibo onawamu ewa iki minabo wewenasida maya ipa Jisesida galama wetome oko lo biye. 22 Liv 12:6-8 23 Eks 13:2,12 32 Aes 42:6; Aes 49:6 ");
INSERT INTO yby_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sa-okaiyoko We napalimo lo hukoko libo gamidana yowanuwa maya likiki Galeli ebakuka numudanipo Naseletigama aku li wili jiki waiye. ");
INSERT INTO yby_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yaloka wiki minaiyoko ipa Jisesida maya Omailimo ujapa lalo oetoko sa-iyoko, napa leko elewole o-minoko sawe lalo nesa liye. 39 Mat 2:23 ");
INSERT INTO yby_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Meleke nowiyoko nowiyokoya esenipo vobetaibo holi onawama nisiyoko Meleko Josepukoma Jelusalemu numutokama yowikaka aiye. ");
INSERT INTO yby_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sa-ikiya minikaka aiyoko, ipanipo Jisesi maya meleke 12-pala le hulikaiyoko, aya onawama nisiyoko omutiki ikaka aibo nesa liki ipa Jisesidamaki ilimi-liki Jelusalemugama yoweiye. ");
INSERT INTO yby_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sa-ikiya yowiki minayoko, holi onawa maya suwokaiyoko, Meleko ito Josepukoma ipa Jisesidama Jelusalemu numutokama ata jimikiki emomae liki lamiki hapaya numudanipoloka lemeiye. ");
INSERT INTO yby_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Numudanipoloka nilimiki wewenasida oluhonipo ahaluwaleki wonetihe likiki anuloka lubu jekaiyoko moniki edimo yuha iwelale minaboku minaboku maya ohu jeiye. ");
INSERT INTO yby_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sa-iki ohu jeiboma nisamiyoko, moniki loka loka aiha mudamune likigo layoko, akuya li welepa jiki Jelusalemu numutoka yoweiye. ");
INSERT INTO yby_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yowiki ohu jiwa jiwa iki minaiyoko, onawa loweki makoki wokaiyoko, Jisesima monoka numuda napau minoko monoka monawa lainimi ikaka wesida luwawanipou nedanaki ganipo noeleko ito ga monawamuya loka nobetaiyoko dolako aholakomasiya wiki muda-elaiye. ");
INSERT INTO yby_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ito monoka monawa lainimi ikaka wesiya ipa Jisesimamo ga monawa elibokumu ito loka abotoma le welepa jeko lo bibomu agae liki domodanipo adoha wonebo ne. ");
INSERT INTO yby_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sakoya luwawanipouya neyoko mudaikiki dolamamo sa-loko lo miye: Ipane emoya nenahamu ata jeletane. Olo. Ahokatema emokumu muluteuma hugili iyoko moneko ohu nojoiye. ");
INSERT INTO yby_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Loko lo miyoko Jisesimamoya sa-loko lo miye: Nenahamuya ohu nijeiye. Nemo ahonemamoya numudalauya yowanu leko mino loko lonetaibo yowanuma leko minohao, edimoya aya gama elamiki nilaihe. ");
INSERT INTO yby_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Loko libomidana monawa maya dolako aholakoma elamaiye. ");
INSERT INTO yby_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sa-liki likiki ilimi-liki Naseleti numutokama waiyoko elekele obetoko ne. Ito dolakaho muki elibo gama le ukauya molaiye. ");
INSERT INTO yby_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sakoya neyoko Jisesima upalaki ito elekakalaki napa leko elewole iyoko ne. Sa-ikiya minayoko, Omaiki muki wewenakiya Jisesidamuya muda-eliki dumu helenebo ne. 41 Eks 12:1-27; Dut 16:1-8 52 1 Sam 2:26; Plo 3:4 ");
INSERT INTO yby_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tibeliyusiya Lomu wewenasida ujapa wenipo napa-napa lolo oko neyoko, meleke 15-pala wiyoko, Potiyo Paelatiya Judiya ebakukaya uliki we napa lolo oko neyoko, ito Helotiya Galeli ebakukaya kiyape lolo oko neyoko, ito unala Pilipikahoya Itulaiya ito Talakoniti ebakukaya kiyape lolo oko neyoko, ito Lisaniaya Abiline ebakuka kiyape lolo oko neyoko, ");
INSERT INTO yby_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ito Omailoka jokila hi mikaka we napaya Anasiko ito Kaeyapasiko minaiyoko, sa-ikiya ujapa weya lolo iki minayoko, Jekolaeyada ipala Joniya ame mikalo neyoko Omailimoya yowanu ga loetaiye. ");
INSERT INTO yby_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Sa-okaiyoko nenako, Jodani no yola helega ito ma helega moneko Omailimo lihimanipo le hulobetatiye loko dukanipo li wili jikiki noku udatae loko lo soto moloko lo beko nebo ne. ");
INSERT INTO yby_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sa-noiyoko Omaimidana epalauti ga lokaka we Aesayakaho ga mako sa-loko ohuwa hukoko luhuwa jibo ga maya Jonitoya niseko ulolotiye: Mumusopa mikaloya we makolimo ga napauti sa-loko noliye: We napatemidana anula dukauya wilitalo. Sa-ikiya anulama li wehe litalo. ");
INSERT INTO yby_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Omotudahe ito weuhahe lekesa jenetibohe, anuloya yoweko lemeko oko awa halenetibohe, kohaiki li wehe likadeko ");
INSERT INTO yby_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","muki wewenasiya Omaimidana elewoleyala ito olisauti dilimekaka wema muda-elakilae. ");
INSERT INTO yby_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Sa-iyoko muki wewenasiya Jonidama noku udobetaiboto wiki nomuya loka itayoko, sa-loko lo beikaka oko nebo ne: Edimo jamidana oluholalita olisatipomidana lihimalama nisekolaiboya aha oli itae loko ekahimamo lo libiye. ");
INSERT INTO yby_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Edimoya dukaya li wili jikiki yamidana monawaya li soto molikiki nisilo. Ga mako lo libituyo, elilo. Edimoya tolowa i suwikadekoma Aebalahamuda ouvamela minatae loko edimosidamu elametiye. Omailimo sa-itae loko maya ehadasidaya Aebalahamuda ouvamelale lolo ilo loko letiboya aha lolo itabo nenako, edimoya dupatipo liki yowiki lemoya Aebalahamuda ouvamelalema minudanako Omailimo lihimatemu obi oletamekolaiye liki lamilo. ");
INSERT INTO yby_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mudalo. Loda leko makoya ya monau kohakolo nebo nenako, tomaya yaya ihilawa jametiboya isa heko joku jekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Loko liyoko, muki li esa iki minabo wewenasiya sa-liki loka itae: Sa-inako, lemoya nenaha etune. ");
INSERT INTO yby_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Liki layoko sa-loko lo biye: Wewena makolikaya upalo nesa lowe le-minokoma iwekada upalo nesala minamidekoma, iwekadaya mako maya mo. Ito nodenesalokiya asaiki sa-ilo. ");
INSERT INTO yby_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Loko liyoko, takisi likaka we malokasiya noku udakili emotoka nisiki monoka wete yamalae, lemoya nenaha etudawo ne. ");
INSERT INTO yby_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Liki loka itayoko, sa-loko lo biye: Takisi ehada gamanilimo lilo loko lo molaibototima oha limi yowiki lamilo. ");
INSERT INTO yby_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Loko liyoko, pilisi wemasi nisiki lemoya nenaha etudawo ne liki layoko, edimoya wewenasi ehada limitae liki kohaidiki dilipi lahelamibo amiki hakupa ga libitamilo loko lo biye. Ito ukada yowanuloti ehada likaka niaboma osele delamideyo, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Muki wewenasiya Omaimo lahelamibo nesauti lilimitiye loko lo mololetaibo wema nisitibo onawaya alo alili okaiye liki elikiki aya wema nehe liki Jonidamamuya data lowe ke. ");
INSERT INTO yby_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Sa-ikayoko, Jonimamoya muki wewenasidama sa-loko lo biye: Nemoya nolotigoya noku udolibetokaka noboya, nemo nemesaloka nonisibo wemidana elewolelalimo nemo elewolenemidana asetoko ne. Nemoya aha we minoe. Emotoya kohamonako, emoda elekele oetoko yowanula asolamaki letatuboto kohamoe. Aya welimoya Omaimidana weuna oluholoti ito dukau lahelametibo nesa jeko wotetibo noku udokaka jolotiki noku libetakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aya wemoya pipiya usokaka nesakiya leko niseko laisi esopa jeko le lalo ekolaiye. Sako nodenesa lalo maya usoko le numudalau molokadeko minakolaiye. Sakoko pipiyawama usoko joku jekadeko lowa lowa oko minakolaiye, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jonimamo sakoya maya gayaki ito maloka gayaki wewenasida data leko lo nobeko Omaimidana gala laloya lo beko nebo ne. ");
INSERT INTO yby_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sa-iboya Helotimamo yatolada menala Helodiyusidama hipo oko lekoko maloka lahelamibo nesa lekaiyoko nenako, Jonimamo auha miyoko Helotimamo lahelamibo ata kekoko, ");
INSERT INTO yby_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jonidama nala numukuma huloetaiye. 4 Aes 40:3-5 7 Mat 12:34; Mat 23:33 8 Jon 8:33 9 Mat 7:19 12 Luk 7:29 19 Mat 14:3-4; Mak 6:17-18 ");
INSERT INTO yby_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jonidama nala numukuma owaha hulitamayoko, noku noudobetaiyoko Jisesima asako Jonitoka wiyoko nokuma udoetaiye. Sako udoetokoko Omailoka noliyoko okulumama golo notiyoko, ");
INSERT INTO yby_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Omaimidana weuna oluhomamo nama luhukidana oko lemeko Jisesida madonaloma olomo jeko ne. Sako neyoko, okulumautiya ga mako sa-loko soto piye: Nemo nukane eme-minobo ipane minaninako, emodaya muda-elo lalo okoe loko liye. 22 Sam 2:7; Mat 17:5; Luk 9:35 ");
INSERT INTO yby_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisesima melekela 30-pala le hulikoko monoka yowanuma le api oko liye. Sako noliyoko, muki wewenasiya Josepuda ipalama nehelae liki ele. Josepuya Helida ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","emoya Matatida ipala, emoya Liwaeda ipala, emoya Melikida ipala, emoya Janaida ipala, emoya Josepuda ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","emoya Matatayada ipala, emoya Aimosida ipala, emoya Nahumuda ipala, emoya Eselida ipala, emoya Nagaida ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","emoya Matada ipala, emoya Matatayada ipala, emoya Semenida ipala, emoya Josekeda ipala, emoya Jodada ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","emoya Joanada ipala, emoya Lesada ipala, emoya Jelupapelada ipala, emoya Sealetiyelida ipala, emoya Nelida ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","emoya Melikida ipala, emoya Adida ipala, emoya Kosamida ipala, emoya Elimadamida ipala, emoya Eleda ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","emoya Josuwada ipala, emoya Eliejelida ipala, emoya Jolimida ipala, emoya Matatida ipala, emoya Liwaeda ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","emoya Simiyonida ipala, emoya Judada ipala, emoya Josepuda ipala, emoya Jonamada ipala, emoya Eliakimida ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","emoya Meleyada ipala, emoya Menada ipala, emoya Matatada ipala, emoya Netenida ipala, emoya Dewitida ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","emoya Jesida ipala, emoya Obetida ipala, emoya Bowasida ipala, emoya Salamoda ipala, emoya Nasonida ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","emoya Aminadaboda ipala, emoya Adaminoda ipala, emoya Alonida ipala, emoya Hejelonida ipala, emoya Pelesida ipala, emoya Judada ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","emoya Jekopuda ipala, emoya Aesikida ipala, emoya Aebalahamuda ipala, emoya Telada ipala, emoya Neholada ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","emoya Seluguda ipala, emoya Leyuda ipala, emoya Pelegeda ipala, emoya Ebeleda ipala, emoya Selada ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","emoya Kenanida ipala, emoya Alapasatada ipala, emoya Semuda ipala, emoya Nowada ipala, emoya Lamekeda ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","emoya Metuselada ipala, emoya Inokuda ipala, emoya Jaletida ipala, emoya Mahalaleda ipala, emoya Kenanida ipala, ");
INSERT INTO yby_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","emoya Enosida ipala, emoya Seteda ipala, emoya Adamuda ipala, Adamuya Omailokati ne. ");
INSERT INTO yby_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisesida maya Omaimidana weuna oluholimo lemeko ukaulau waitokoko ilime sahu okaiyoko, Jodani noma hulikoko mumusopa mikaloka wiye. ");
INSERT INTO yby_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mumusopa mikaloya woko 40-pala yulaka nodenesa namoko aha yupago udoko sinoko oko neyoko, olohalimo niseko mimi oko mulunau heko mologo oko ne. ");
INSERT INTO yby_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sa-iyoko, olohamamoya sa-loko lo miye: Emoya Omaimidana ipala minatadawoya matoka ehadahenasida lideko, nodenesa lolo imi wideko noko minamane. ");
INSERT INTO yby_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Loko liyoko, Jisesimamoya sa-loko lo miye: O'e, monoka bukugu luhuwa mako sa-liki ji-minaboma ne: Wewena makolimoya nodenesago nokoko elewole oko minametibo nesa ne. ");
INSERT INTO yby_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Loko lokaiyoko, olohamamoya akuya ilime-loko bola hana-panauya yoweko muki numuto namato wesida ebanipohena ito elewoleyanipohenama ilipeko suwokokoya ");
INSERT INTO yby_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","sa-loko lo miye: Mudao. Muki yatoka duliki wesi nesaki maya mikauya saina laloki mukiya nemoneda nadeuya moloneyoko nemo ujapa o-minonako, wewena makomamidana mituwe loko letuboya aha mitubo nenako, emodagoya eme suwekoloyo. ");
INSERT INTO yby_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Emolitaya nemoto i bola heko monoka letadawoya, muki nesaya emo nesakago lolo o suwekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Loko liyoko, Jisesimamo sa-loko lo miye: O'e, monoka bukuguma ga mako sa-liki luhuwa ji-minaboma ne: We napa Omaimidanagoya li bola he meko lipe meko uliwa le sawa jetudawo ne. Sako emodagoya elekele oetatudawoya ne. ");
INSERT INTO yby_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Loko lokaiyoko, olohamamoya ilime-loko Jelusalemu monoka numuda okepaloma yoweko sa-loko lo miye: Emoya Omaimidana ipala minatadawoya malotiya yokama mikalo eko molo. Sa-liki luhuwa ji-minabo ne: ");
INSERT INTO yby_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Emodamu Omailimo okanaki wesida yowanu ga lobetadeko ujapa lalo nesa itakilae. ");
INSERT INTO yby_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ito ga mako sa-loko ne: Ikaya ehadalimo kohaelokatiye liki okanaki wesida doli hekadeko limiki apusa jiki ilimi dade lukanauya molakilae. ");
INSERT INTO yby_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Liki luhuwa ji-minaboma neyo, emoya le lahelamibo amekolane. Loko liyoko Jisesimamo sa-loko lo miye: O'e, monoka bukuguya We napatipo Omaimidana mulunau heko nei nesa lolo etuboya We napatipo nilimekolaiye liki lamilo liki luhuwa ji-minaboma ne. ");
INSERT INTO yby_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Loko lokaiyoko, olohamamo muki nesaloma mulunau hego hego oko lokoko yu makowe lokoko Jisesidama huloetokoko oli wibo ne. 4 Dut 8:3 8 Dut 6:13 10 Sam 91:11 11 Sam 91:12 12 Dut 6:16 ");
INSERT INTO yby_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisesida maya Omaimidana weuna oluholimo ilime abuha-wowo loko elewole mekaiyoko Galeli ebakuka akuya le wili jekoya wiye. Sa-iyoko galama muki ebatoka woko suwiyokoya ele. ");
INSERT INTO yby_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yalokaya monoka numuda neboku nebokuya yoweko lemeko oko monoka lo biyoko muki wewenasi eleboya lahelepa delaiyoko epoka lae. ");
INSERT INTO yby_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sa-ikayoko Jisesima napa libo eba Naseletigama wokoko, holi onawa alili okaiyoko monoka numuku yowiye. Emo holi minokaka ibo yulakaya asakogoya yowekaka iye. Sako yoweko monoka lepeko lo bekolo noyowiyoko, ");
INSERT INTO yby_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Omaimidana epalauti ga lokaka we Aesayakaho luhuwa jibo pepama mikayoko, le taloko ga makoya sa-loko nebo aya mudakoko lepeko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","We napamidana weuna oluholimo nemotoka lemeko yowanu ga sa-lokoya lo nimiye: You liki minabo wewenasidaya ga laloya lo bo. Nala numuku minabo wewenasida olutobetatuwe loko lo bo. Domuda likaibo wewenasidaya le pana kituwe loko lo bo. Migele-agele iki minabo wewenasidaya dilipe dowa letuwe loko lo bo. ");
INSERT INTO yby_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","We napalimo dilipe dowa letibo onawaya alo alili okaiye loko lo bo. ");
INSERT INTO yby_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisesimamo sa-loko lepeko lo bekokoya pepama ake oko elekele oluhoma mekadanaki ohaya mikalo ne. Sako neyoko monoka numuku minabo wewenasiya wenu wenu niayoko ga mako sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Monoka bukuguti aya lepoyoko elebomidana ihilawaya olotiya soto piye. ");
INSERT INTO yby_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Loko lokaiyoko edimomasi ini imikikiya emo epalauti aya eleyoko lahelepa delaiye. Sa-iyoko epoka likiki emo Josepuda ipalama neboya, yamidana aya nenaha okoko noliye. ");
INSERT INTO yby_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Liki layoko, sa-loko lo biye: Ga makoya sa-liki koha moliki likaka niae: Lusa we minatadawoya aito wewenasida dilimedawo nesa leko eimoka wewenakalesidaya dilimamape. Nemo nata eloboya aya koha moliki aya wasa jiki li nimikiki nemoda Kapaniyamu numutoka elewole anehena liyoko maya eludawomidana asakoya oto numudakaloma neyo aya nesa lolo ideko mudatune liki li nimitae. ");
INSERT INTO yby_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Loko lokadanakiya kolo meko sa-loko liye: Nemo watiya lo libituyo, eli-minalo. Omaimidana epaloti ga lokaka we makolimo eimola oto ebalalo woko Omaimidana galaya lo bitiboya emo yatokaya lelimote oluhotema ne liki galaya elamikilae. ");
INSERT INTO yby_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ya nesamuya lo libituyo. Ilaijaya monoka yowanu libo yupekaya okulumau anuya li lokaiyoko meleke 3-palaki ito ukada 6-palaya goya jamibo ne. Sayoko nenako, nodekumu napaya muki ebatoka maya soto pibo ne. Sa-ibo onawaloya Isilaelo mikaukaya eto menakipa obe liki minaboya, ");
INSERT INTO yby_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Omailimo Ilaijadaya muki mena minabotoya dilipe wati etiye loko oli hamiye, Sidoni ebaku Salepata numutokaya Juda mena nehekala hetoka mena mako nebotokaya oli hiye. ");
INSERT INTO yby_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ito Omaimidana epalauti ga lokaka we Ilaisaya yowanu libo onawaloya Isilaelo mikaukaya mika ihi jelebo wewenaya obe liki minaboya Ilaisamamo dilipe lalo amoko Siliya ebakuka hetoka we mako Naemanidagoya ilime haka liye. ");
INSERT INTO yby_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Loko lokaiyoko aya gama eliki lemodamukiya lokaiyo liki monoka numuku minabo wewenama depauka molokaiyoko ");
INSERT INTO yby_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","vovotiki sinikiki hetokama wiki Jisesida maya ilimi-liki aya nebo weuhamidana lakiwauma yowiki ipisi hulakili ilimi-liki yoweha, ");
INSERT INTO yby_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","luwawanipoutima aha leso iye. 18 Aes 61:1-2 24 Jon 4:44 25 1 Kin 17:1 26 1 Kin 17:8-16 27 2 Kin 5:1-14 ");
INSERT INTO yby_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sakoko Jisesi maya Galeli ebakuka lemeko Kapaniyamu numutokama muki holiguma yoweko monoka lo beikaka oko nebo ne. ");
INSERT INTO yby_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sako elewoleyalaki monoka ijaka heko lo bekaka ibo nenako, domodanipo adoha wiye. ");
INSERT INTO yby_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sa-niayoko aya monoka numukuya we mako neboya ukauya oloha lahelamibo makolimo minokoko ilime lahelamibo okaiyoko, nedanaki gai moloko sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Agae, Naseleti we Jisesiyo, nenahalo lahelamibo nesa lolo oletakolane. Olotiya lilime lahelamibo etuwe loko nonisepe. Emodaya muda-elo wehe lo-minoe. Emoya Omailokati lemedawo eto o-minadawo wema minane. ");
INSERT INTO yby_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Loko liyoko, Jisesimamo auha meko sa-loko liye: Epaka he li lokoko moletoko ukautiya lemeko wo. Loko lokaiyoko, olohamamoya aya wemidana muki wewena luwawanipoutima ipisoko hulikaiyoko lemeko pou loko udokaiyoko, oloha lahelamiboma ilime lahelamibo amoko huloetokoko wiye. ");
INSERT INTO yby_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Sa-okaiyoko, muki wewenama domodanipo wokaiyoko wetome-katome iki sa-liki lae: Nenaha iye. Monokala aitomidana ne. Emo galaya elewoleyalaki ito abuha-wowolalotiki lobetokaka noiyoko olohasiya hulibitikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Liki layoko Jisesidamu gala maya muki ebatoka woko suwiye. 32 Mat 7:28-29 ");
INSERT INTO yby_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sa-iyoko, Jisesima monoka numukutima lemekoko Saimonida numudalauma yowiye. Saimonida iloho doladama upauya jo napa libo nesa elokaiyoko ilime haka letiye liki likayoko, yowiye. ");
INSERT INTO yby_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yoweko aliliya sinonedanaki upalauya jo lonebo nesamidanama auha mekaiyoko suwoetaiye. Suwoetokaiyoko, aya menamamo enemane oko sinokoko Jisesilemaki nasahili obetaiye. ");
INSERT INTO yby_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ludaka homa nolimiyoko aito aito nesa jelebo wewenasidama dilipi-liki Jisesitokama nisi nisi ayoko, adelama dupalo moloikaka oko dilipe haka haka liye. ");
INSERT INTO yby_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ito wewenasida dukau oloha lahelamabo minabosidama kohaidoko doli nohiyoko opa napa ga liki sa-liki lae: Emoya Omaimidana ipalama minane. Liki likiki hulibitikiki wiwi ae. Niwiki Jisesidamuya Omaimo lahelamibo nesauti lilimitiye loko lo mololetaibo wema ne liki data elebo nenako, Jisesimamoya auha beko emo monawalama li-lili monamitae loko lo hukobetaiye. ");
INSERT INTO yby_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nekewama homa noyowiyoko, Jisesima numukutima lemekoko woko mika epaloka emesa meko minoko aholadama epoka lekolo sa-iye. Sakoya woko neyoko, muki wewenasi emokumuya ohula jiki jiki li soto molikiya huloletametiye liki layoko, ele bameko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nemoya eba makomaloka moneko Omailimo muki wewenasida uliki wenipo lolo etibomidana gala laloya wetome oko lo bebe ekoloe. Ya yowanu litane loko Omailimo noli henebo nenako, ");
INSERT INTO yby_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","loko lokoko woko Judiya ebakukaya monoka numuda neboku nebokukaya yowego lemego oko monoka lo beikaka oko moniye. ");
INSERT INTO yby_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yu makoma Jisesima Genesaleti adu no ilikakama neyoko muki wewenamasi Omaimidana galama eletune liki nisiki dupalo dupalo iki minayoko, ");
INSERT INTO yby_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","lahawa hikaka wemasi noku lapenipoutima limikadanaki lahawa likaka owo ololeyama no nijeyoko ito noku lape lowema aha noku minaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisesimamo mudaidokoko mako Saimonida noku lapelaya neyoko, yauma yowekoko ipiso-loko alili akeloka wetane loko liyoko ipisi-liki nisikayoko ayauma yoweko minoko muki nisiki li esa abo wewenasidama monoka lo biye. ");
INSERT INTO yby_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lo beko suwokoko Saimonidama noku lapema ipiso-loko woko nohukuma molo-minoko iwekalekiya lahawa likilayo, lahawa likaka owo ololeyama huli noku molalo, loko Saimonidama lo miye. ");
INSERT INTO yby_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Loko liyoko, Saimoni Pitakaho libotoma onoto leko We napate yamalae, oloti lubukaya lahawa hewa hewa oko minuniyoko lomudaloya goya liboya lahawa makokomaki keke lamune. Sa-ominudawoya, emo ladawotoya owo ololeya oha hulo nohuku molakolune. ");
INSERT INTO yby_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Loko lokoko aya lahawa owonipoma huli nohukuma molaboma lahawa wavu-liki leyoko, owowama jeko bolo tekolaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","iwenipole makoma noku lapeu minabosidama nisiki lilimitae liki nisiki dadelotima api-napi iniki ju lae. Sa-ikayoko, nisiki noku lape loweuya lahawahenama li nimolayoko, aya noku lape lowe maya nokuma lemekolo sa-iye. ");
INSERT INTO yby_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Sa-iyoko, Saimoni Pitaleki magoina minabo wewenasiya obe liki lahawa lebokumuya Jisesidama epoka layoko, Pitama Jisesida iguka lipeko sa-loko lo miye: We napane yamalae, nemoya lihimaneki wema minonako, hulonetokoko wetapelae. ");
INSERT INTO yby_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Loko liyoko, Jebetida ipala lowe Jemisiko Jonikoya Saimonida iwela minainako asaikiya epoka laiye. Epoka nilaiyoko, Jisesimamoya Saimonidama omodaka wamideyo, emokaho asako olotiya monoka yowanu nolideko muki wewenaya nemo wewenane lolo itae loko lo miye. ");
INSERT INTO yby_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Loko lokaiyoko noku lapenipoma liki wiki no akelokama muki nesanipoma hulikiki Jisesiki magoina wae. 1 Mat 13:1-2; Mak 3:9-10; Mak 4:1 5-10 Jon 21:3-8 ");
INSERT INTO yby_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisesima eba makomaloya woko neyoko, mika ihi wavu-leko jelibo we makoya niseko Jisesidama muda-elokoko woko ilaukama noudoko, We napane emoya nilime olutetuwe lokoma aha nilime olutoneto loko liye. ");
INSERT INTO yby_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Loko liyoko, Jisesimamo adelama petoko upalo noleko olutetane loko eleminoyo, oluto loko liyoko, aya mika ihi maya enemane oko olutiye. ");
INSERT INTO yby_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sa-iyoko, aya ga maya wetome oko wewenasida lo bametiye loko lo hukoetoko sa-loko lo miye: Aloya olutokadanae liki elitiye loko Omailoka jokila he mekaka wemitokama upaka leko woko ilipideko muda-elatiyo. Sako olutadawomuya Mosesekaho libo nesa leko Omaimidana uda je mekadeko muki wewenasiya olutadawo monawaka maya mudai wehe litae. ");
INSERT INTO yby_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Loko libo ga maya pou loko moniyoko muki wewenasiya elikiki Jisesida galama eletune liki ito saina delaibo nesauti dilipe haka letiye liki saina delaibo wewenasidama dilipi-liki Jisesitokama nisiki li esa ikaka aboya, ");
INSERT INTO yby_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","emoya woko ametoma nedanaki Omailoka lekolo wokaka onebo ne. 14 Liv 14:1-32 ");
INSERT INTO yby_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yu makoya Jisesimamo monoka monawa lainimi obetoko neyoko, Palasisi wewenahena ito monoka monawa lainimi ikaka wewenahena muki ebatokati Galeli ebakukati ito Jelusalemu numutokati ito Judiya eba numuda malokatiki nisiki yalomago li nupa ae. Sayoko Jisesi maya saina delaibo wewenasida dilipe haka letibo elewoleyalakiya ne. ");
INSERT INTO yby_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sakoya neyoko mokolo lolo ikiki ilimi-liki nisebo we ebili makomidana maya Jisesida iguka hulitakiliya, ");
INSERT INTO yby_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","muki wewenasiya anu maya hiki li likayoko ilimi-liki numuda opitoma yowikiki opidama kisikiki mokolowamaki nala jikiki nalawamaki wewenasida luwawanipouma hulitayoko, Jisesida omudaloka maya limiye. ");
INSERT INTO yby_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sa-iyoko, Jisesimamoya ilimi-liki nisebo we maya emodamu elewole iki elebolawama mudakoko we ebilimidanama sa-loko lo miye: We mageyo, lihimakaya alo le huloetokoe. ");
INSERT INTO yby_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Loko lokaiyoko, monoka monawamu lainimi ikaka weki ito Palasisi wekiya data etipa kikiki edimonipoloka sa-liki lae: Wewena mako ekahimamoya lihimate le hulatibo ne. Omai makokolimogo sa-okaka noiboma nenako, eimola upala leko yoweko Omai pulekolo noliboya etamiye. ");
INSERT INTO yby_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Liki data nikeyoko, Jisesimamo mudakoko edimoya nenahamuya dukauya sa-liki niele loko lo biye. ");
INSERT INTO yby_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","We makolimoya lihimakama alo le hulikoe loko letiboya, suwa nehe watiwa nehe wewena ekahimamo elene. Sa-oneboya, wewena makolimoya suwa lihe watiwa lihe liki yamidana monawaya enemane iki elitabo nenako, saina delaibo wewena dilipe haka lokaka elewoleya minametiboya, ila lahelametibo wemu anu moloko wo loko enemane oko lo mamekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sa-oneboya, okulumauti we uti nemokaho maya mikauya delaibo nesa le hulokaka elewolego nehekala, lihimatipo le hulobetokakamidana elewoleyakiya nemotokaya ne. Loko lo bekadanaki yamidana monawa maya eli wehe litae loko we ebilimamidanaya sa-loko lo miye: Nemokaho lobotoya mokoloka leko sinokoko anu moloko numudakaloka wo. ");
INSERT INTO yby_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Loko liyoko, muki wewenasi domudalo maya enemane oko mokololama le oheko sinokoko anu moloko numudalaloka nowidanaki Omaimidana epoka lomo wiye. ");
INSERT INTO yby_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sa-iyoko muki wewenasiya Omaimidana epoka liki mulunipouma hugili noiyoko, olotiya aitomidana nesa makoya mudakune, liki lae. ");
INSERT INTO yby_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sa-liki likayoko hetoka lemekadanaki Liwaema takisi lekaka we nenako, yowanu lekaka numukuma neyoko muda-elokoko nemoki magoina wetune loko ju liye. ");
INSERT INTO yby_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Loko liyoko, Liwaemamo muki nesalama hulikoko Jisesiki magoina waiye. ");
INSERT INTO yby_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sa-iki magoina wiki Liwaeda numudalauma Jisesida nodenesa napaya ataina oetaiyoko, takisi ehada likaka weki ito edimo maloka lahelamibo nesa lolo ikaka niabo wewena minae liki data kikaka niabo wewenaki magoina miniki aya nodenesa maya niminae. Sa-ikiya ninayako, Palasisi wewenaki ito monoka monawamu lainimi ikaka wewenakiya Jisesida unala ipalale yuhasidamu lahelamibo data nieliki sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lemokuti takisi ehada ukele lekaka weki ito maloka olisalo wekiya nenahamu magoina miniki nodenesa ninae. ");
INSERT INTO yby_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Liki layoko, Jisesimamo elekoko edimo saina jelamiki aha minabo wewenasiya lusa wewenamu ju lamabo nesama ne. Saina delaibo wewenamasigo lusalo wewenamu ju likaka niae. ");
INSERT INTO yby_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sa-ikaka nemokahoya wehe loko minune liki likaka niabo wewenasida dilipe lalo etuwe loko lemamoe. Lihimanipoki wewenama dukanipo li wili jitae loko lemoboma ne. 30 Luk 15:1-2 ");
INSERT INTO yby_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Loko liyoko, Jisesidama auha miki sa-liki li me: Jonida unala ipalale yuhasiya muki yulakaya monokamuye liki nodenesa mosikaka iki Omailoka likaka niae. Ito Palasisi wewenasida unanipolesiya asaiki sa-ikaka i-minabo neboya, emo unaka ipakale yuhasiya nodenesa aha opa liki nikaka niaboya nenahamu sa-ikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Liki layoko, Jisesimamo ga mako koha moloko sa-loko liye: Mena ada iki mitabo welimoya iwelaleki magoina minatabo yulakaya we makolimo nodenesa mosebetatibo nehe. Sako minamiye. ");
INSERT INTO yby_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mena ada iki mitabo welimo dadeuti hipo itabo onawa maya alili okadeko ya yulakama milumala elikiya nodenesa mosikilae. Ayamidana iki alikaya unane ipanele yuhasiya nemokumuya miluma eliki nodenesa mosikilae. Olotiya sako minamiye. ");
INSERT INTO yby_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Loko lokoko koha moloko ga mako sa-loko lo biye: Lawo-lawo ohatama no jiki li lasola amaboya bolotikiki li asehawa lawolawolo moliki oto itabo nesa minamiye, saki oto ikiki no jitaboya ohatama lawolawolimo hikalekoko aitomidana lolo okatiye. ");
INSERT INTO yby_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ito waeni no etehu alakala noiyokoya asehawa nogodau jikaka nesa minamiye. Waeni noyamo nogodawa jeko potokoko waeni noya kisekadeko, aya nogoda maya nosamo okatiye liki waeni no etehu alakala noiboya nogoda ohatamaugo jikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Waeni no etehu alakala noiboya ohotama nogodau jitabo ne. ");
INSERT INTO yby_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ito latatele nesago le koloko netibo wewenalimoya pupune nesamu elametibo ne. Hapa lupalo nesayamogo wati one loko lokaka adawo nenako, sa-okaka noiye. Loko liboya aseha weutemidana nesaki ito ohotama weutemidana nesakiya le makoko molametudawo nenako, unala ipalale yuhasiya ohatama weunipogo iki moliki itabokumu liye. ");
INSERT INTO yby_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Holi onawa makomauya Jisesima unala ipalale yuhakiya kile mijaku nimoniki unala ipalale yuhamasiya kilema ulutiki dadelotima ulawama heketiki nimi wae. ");
INSERT INTO yby_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sa-niayoko, Palasisi wewena malokasi mudaidikiki holi onawauma nenako, yowanu nileboya lahelamibo nesa lolo niae, samitaboma neboya, nenaha iyoko sa-niae. ");
INSERT INTO yby_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Liki layoko Jisesimamo edimoya Dewitimamo wewenalale yuhakima nodekumu helikiki saina mako lolo abo nesamu lepi-minaboma neboya, monawa elamiki nilahe. ");
INSERT INTO yby_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dewitima nodekumu helekoko monoka numukuma yowiyoko Omaimidana owisalo moli-minabo beleti maya Omailoka jokila he mekaka wemamo meko wewenalale yuhamaki biyoko naboma ne. Aya beletiya aha wewenasi namitae, Omailoka jokila hi mikaka wesigo natae liki ga li hukiminabomaya, ya yupekaya aha wewenamasiki ni-minaboma ne. ");
INSERT INTO yby_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Loko lokoko Jisesimamo kolo meko sa-loko lo biye: Okulumauti we uti nemoya holimidana aholaya minonako, unanele ipanele yuhasiya holi onawau lolo itabo nesaya nemo nesae. 1 Dut 23:25 3 1 Sam 21:1-6 4 Liv 24:9 ");
INSERT INTO yby_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Loko lokoko holi onawa makomauya Jisesikaho monoka numuda makomau yoweko monoka monawama lainimi obetoko neboto ayauya ade lamawaka uka jenebo wekiya yoweko nebo ne. ");
INSERT INTO yby_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sakoya neyoko monoka monawa lainimi ikaka weki ito Palasisi wekiya aya wemidana adela maya le petadekoma holiguma nenako obi oetatune likiki ujapa i-minabo ne. ");
INSERT INTO yby_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sa-iki data eliki minabolawaya Jisesimamo alo elekadanaki, aya wemidanama sinoko luwawateuma sino-mino loko liyoko ayaloma sinokoko ne. ");
INSERT INTO yby_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sakoya sinoneyoko Jisesimamo sa-loko loka obetaiye: Saina makomu loka olibetatuyo. Holiguya wehe lonetibo nesa lolo etudawolimoya wehe letibo nehe ito lahelametibo nesa lolo etudawolimoya woko wehe letibo ne. Wewena makomidana ilime lalo okaka nesahe ito koha helekaka nesa ne. ");
INSERT INTO yby_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Loko lokoko muki wewenasidama wenu nodeloko aya wemidanama adeka le peto loko liyoko petiyoko akuya wehe liye. ");
INSERT INTO yby_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sa-iyoko nenako Palasisi wewenaki ito monoka monawamu lainimi ikaka wewenakiya depalo molokaiyoko nenako Jisesidama nenahama lolo oetatupelae liki ligi hagi ae. ");
INSERT INTO yby_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ya yulaka maya Jisesimamo bolauma yoweko Omailoka lowa lowa oko neyoko go maya liye. ");
INSERT INTO yby_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Goma loko homa yowekaiyoko unala ipala yuhama ju liyoko nisikayoko we 12-pala dilipe eto okoko dulinipoya aposoloe loko molaiye. ");
INSERT INTO yby_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sakoya Saimonidama ohotama uliwaya Pitae loko molaiye. Ito unala Enduluyo, Jemisiyo, Joniyo, Pilipiyo, Batolomiyuyo, ");
INSERT INTO yby_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyuyo, Tomasiyo, Alopiyasida ipala mako Jemisiyo ito Saimoniya Lomu gamanimidana oli he hulakolo ibo we, ito Jemisi makomamidana ipala Judasi mako, ");
INSERT INTO yby_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ito Kaliyoti numutokati we Judasi makoya Jisesida mimi ibo weya ne. ");
INSERT INTO yby_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisesimamo bolautima unala ipalale yuhamakiya limikiki eleda makomauya minayoko emo wewenalale yuhaki ito maloka wewenakiya Jelusalemu numutokati ito Judiya eba malokati ela no ilikalokati ito Taeya ito Sidoni numutokatima Jisesida gala eletune liki ito saina delaibo wewenasidama dilipe haka letiye liki muki wewenama nisiki li esa ae. ");
INSERT INTO yby_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Sa-iki nisiki minayoko oloha lahelamibo dukau nebo wewenasidama dilipe lalo iye. ");
INSERT INTO yby_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ito Jisesida upalalo leyoko upalaloti elewolelalimo saina jelebo nesanipoma haka lobetaibo nenako, li esa iki minabo wewenasiya upalalo letudawoya sainate haka loletatibo ne liki ele. ");
INSERT INTO yby_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sa-ikayoko Jisesimamo unalale ipalale yuhasidama wenu delo-minoko sa-loko lo biye: Edimo Omaimidana uvaminala koheko le-minamudawo ne liki likaka niabo wewenaya Omaimidana oholauya yowitabo nenako, elowa jebo ilekaka noiye. ");
INSERT INTO yby_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Edimo lalo nesamu delaiyoko minabo wewenaya lalo nesalimo dukauya waitetibo nenako, elowa jebo ilekaka noiye. Edimo wije nama iki minabo wewenalikaya ija onoka molatabo nenako, elowa jebo ilekaka noiye. ");
INSERT INTO yby_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Okulumauti we uti nemokumuye liki liwi letiwi iki asowalaki nesa lolo ilibitiki demesa libikiki edimokumuya lahelamaboe liki auha libitabo ito ulitipoya sakiya molataboya olitipo hideko elowa jikilae. ");
INSERT INTO yby_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sa-nilibitadekoma edimoya diya jiki miniki omutiki latatipolesidaya Omaimidana epalauti ga likaka wesidaya asaiki lolo ibitayoko Omaimo meinawa napa-napa bibo nenako, okulumauya asako meinawatipo napa-napa netibo ne liki lilo. ");
INSERT INTO yby_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ito uvaminatipoki wewenalitaya ehetipoe. Edimo olitipo hiyoko iki moliki abolawamaya aloya suwokaiye. ");
INSERT INTO yby_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Edimo niki ohumatipo ikiki minabo wewenalitaya ehetipoe. Alikaya nodemuya helikilae. Edimo ija onoka ga liki minabo wewenalitaya ehetipoe. Alikaya edimo miluma eliki wije nama likilae. ");
INSERT INTO yby_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Edimo duli li sinikaka niabo wewenalikaya ehetipoe. Latatipolesida suwa-sawa monoka li-lili monikaka wesida dulima li sawa jikaka niaboya, suwalo wesida dade liki yowikaka abo wewenasidaya Omaimo dilimamibo nenako, edimodaya asako Omaimo dilimametibo ne. 22 1 Pit 4:14 23 2 Klo 36:16; Apo 7:52 ");
INSERT INTO yby_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Sa-oneboya nemo ane nielebo wewenalitaya ga lo libituyo, elilo. Edimosiya ulatipolo wesidama dukatipo bikiki nasahili ibitalo. Ulana molilibitatabo wewenasidama dilipi lalo ilo. ");
INSERT INTO yby_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ito edimodama liwi letiwi itabo wewenasidamu dilipi lalo ilo. Edimoda lahelametibo nesa lolo ilibitatabo wewenasidamu Omailokaya loka ilo, dukau yowanu lebetatiyo. ");
INSERT INTO yby_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wewena makolimo epa hanakaloka jekadeyama le wili jeko malokakiya kohanelo loko mo. Wewena makolimo lasi nesaka hipo oko leko nowidekoma upakalo nesakiya o'e loko lamoko meiko yakiya leko wetiyo. ");
INSERT INTO yby_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ito wewena makolimo emo nesakamu wako letiboya aha mo. Ito wewena makolimo emo nesaka leko wetuwe lokadekoma aha mideko leko wokadekoma aku wako lamo. ");
INSERT INTO yby_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Edimo wewena malokasi yamidana mamidana nesa lolo ilibitatae liki likaka niabo nesa liki lolo ibitalo. ");
INSERT INTO yby_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Lahelamabo wewenasi duka limikaka niabo wewenasidaya luka betudawo ne liki likaka nianako, edimo duka bikaka niabo wewenago dukatipo bitaboya Omaimoya depoka lametibo ne. Edimolitaya saina lalo lolo ilibitikaka niabo wewenasidagoya saina lalo lolo ibitataboya, Omaimoya depoka lametibo ne. Lahelamabo wewenakiya asaiki sa-ikaka nianako. ");
INSERT INTO yby_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Edimo wewena makosida saina bikiki aku bekimi iki limitae liki likaka niabo wewenaya Omaimo depoka lametibo ne. ");
INSERT INTO yby_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Lahelamabo wewenasiya alika limitae liki dina iki lahelamabo wewenasida bikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Sa-niaboya edimo ulatipolo wewenasida dukatipo bikiki nasahili ibitikiki alika dina iki limitae liki lamiki aha yatoka bilo. Sa-ideko alikaya meinawatipo yoweko nedeko okulumau Omaimidana oluhola wehe liki lolo iki minatae. Omaimidana epoka lamabo ito lahelamabo wewenakiya muki muluna molobetoko nasahili obetokaka noiye. ");
INSERT INTO yby_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sakoya ahotipokaho miluma elelibetokaka noibo nesa liki miluma elibitalo. 31 Mat 7:12 ");
INSERT INTO yby_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Edimo wewenasida lihimanipomuya Omailimoya sako obi obetatibo ne liki data kiki lamilo. Omaimoya lihimatipoe lokatiyo. Edimoya wewena makosida lihimanipomu li hukibitamilo. Sa-itaboya Omaimoya edimo lihimatipomu lo hukolibetametibo ne. Edimosiya maloka wewenasida lihimanipo li hulibitataboya Omaimo asaoko lihimatipo le hulolibetatibo ne. ");
INSERT INTO yby_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Edimosi wewenasida ono moliki bikaka niabomidana asetoko Omailimo ona moloko libitibo nenako, edimosi wewenaloka iki moliki itabo nesa leko makoko aweyaha iki edimotokaya iki moliki itaboya Omaimo wehe loko dukauya le ohelibetokoko heko mijeko owoina olibetatiboya waitoko wilemo jeje oko netibo ne. ");
INSERT INTO yby_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Loko lokoko olisanipomu koha moloko ga mako sa-loko lo biye: Omudala likonetibo we makolimo asako omudala likonetibo we makomamidana anu ilipeko ilime-loko wetibo nehe, sametiboma ne. Sa-oko ilime-loko emo adelo lideko emo adelo lideko wisaiboya lakiwa olakilaiye. ");
INSERT INTO yby_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ito sukulu oluholimoya enemane oko tisala lolo ametibo ne. Alikaya sukulula lo-loko woko suwokoko tisa lolo etibo nenako, nemokidana netibo tisamidanaya emesalo molalo. ");
INSERT INTO yby_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Emo iwekadaya omudalau ilisa mako ne loko ladawoya emo omudakau yaitaya ya lana mako neboya nenaha iyoko mudamoko lane. ");
INSERT INTO yby_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Eimoka omudakau yaitaya ya lanama wonebo maya mudamadawo nenako, nenaha iyoko iwekada omudala ilisama le huloetatuwe loko nolane. Emo suwalo we epa ulumaka lowe nebo welika eimoka omudakau yaitaya ya lanama neboya omutoko le hulikoko muda wehe lokokoya alikaya iwekada omudala ilisa le huloetatadawoya wehe lone. 39 Mat 15:14 40 Mat 10:24-25; Jon 13:16 ");
INSERT INTO yby_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ito ya lalo makolimoya ihilawa lahelametibo mako jametibo ne. Ito ya lahelametibo makolimoya ihilawa lalo mako jamekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ito ya ihilawalimoya aya yaya lalo nehe ito lahelamibo nehe loko le soto molokaka noiye. Hililibamoya uveya ilideko hukiki natabo nehe. Ito uhedalimoya obosu jekadeko liyiki natabo nehe. ");
INSERT INTO yby_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ayamidana sako wewena lalosida dukauya saina lalogo netibo nenako, dukautiya saina lalogo yowitibo ne. Ito lahelamabo wewenasida dukauya lahelamibo nesago netibo nenako, lahelamibo nesago yowitibo ne. Lukauya ayamidana nesago waitonebokuti lepautiya lokaka noune. ");
INSERT INTO yby_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Edimosi nemodamu We napate We napate liki likaka niaboya nenaha iyokoma nemo aneya elamae. ");
INSERT INTO yby_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nemotoka nisikiki nemo aneya eli likaka niabo wewenaya aha sa-ikiya minae lokoya lo noliboe. ");
INSERT INTO yby_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wewena makolimoya numudala vekolo maya aleya liyekoko ahodaya heko hulo yeikamau oko vibo numudalaya go napa niseko ito yasi napa niseko ahuhu napa niseko liboma ehada mupilalo vibo nenako, momoga amoko elewole oko nebo ne. ");
INSERT INTO yby_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sa-ikiya minaboya, maloka wewenasiya nemo anema elikakawama eleha mako eliki li madonipou molamabo nenako, edimoya sa-iki minae: Wewena makomo numuda vekolo maya ahodaya yeimau ale liyamoko aha yatoka suwa nesa leko mika mupilalo vokaiyoko alikaya ahuhulimohe ito golimohe yasilimohe niseko ipi sokaiyoko enemane okoma lemeko pou loko udoko luko-mako oneboma ne. ");
INSERT INTO yby_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisesimamo monoka gama yaloya lo beko suwokoko Kapaniyamu numutokama wiye. ");
INSERT INTO yby_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yalokama woko neyoko Lomu ebatoti lowa wesida ujapa wenipomidana elekele wela mako saina lahelamibo jeliboya alo helede-molode oko neyoko ujapa welalimoya emodaya weuna menebo nenako, ");
INSERT INTO yby_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","yamuya Jisesida gala maya elekoko Juda monoka ujapa wesidama doli heko wiki Jisesidama lideko niseko elekele oluhone jelibo nesa maya le haka loetatiyo, wiki li mideko nisideyo, loko doli hiye. ");
INSERT INTO yby_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sa-loko doli hekaiyoko Jisesitoka maya wiki lemoya lowa wetesida ujapa wenipoma oko moloko noiboya dowa noliye. ");
INSERT INTO yby_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Emo ukalaya lemo Juda wewenaya lemekaka noibo ne. Ito monoka numudate soto pitiye lokoma ehada napa molokaiyoko vilitaboyae. Sa-okaka noibo wema nenako emo galama ele mitadawoya wehe lone. ");
INSERT INTO yby_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Liki layoko Jisesimamo elekadanakiya magoinaya wae. Wiki numudala alili niwayoko aya wemamoya elekele oluholasida leko doli heko wikiya we napane yamalae, hana-pana anu nisekoko nemo numudaneuma lahelamobo we maya minonako nenahalo yowitane liki ayaloya mino lilo. ");
INSERT INTO yby_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Neimoneya molo eloboya wehe lamonako emotokaya wamoboya, aha yaloya minoko epakauti ga lideko elekele oluhone maya jelibo nesaya suwoetatiye. ");
INSERT INTO yby_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nemoya asako duliki wesida elekele wenipo minoe. Ito lowa wesida ulanipolo weloya nemoya ujapa weya minoe. Sa-ominonako imi we makomamidana wo loko letuboya aha wekolaiye, ito niso loko letuboya aha nisekolainako, ito elekele oluhonemidanaya woko yowanu lo loko letuboya aha woko yowanu lekolaiye. Yamidanaya gakaya elewole onenako, aha malo minoko gakaya lideko elekele oluhone maya haka letiye loko nolobolae. ");
INSERT INTO yby_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Liki wiki li milo loko doli hekaiyoko wiki hetikiki sa-liki layoko Jisesimamoya aya gama elekadanaki aya lowa wesida ujapa wenipoma epoka lokoko mino wili jeko emeke moliki wabo wewenasidama sa-loko auha biye: Isilaelo wewenaukatiya wewena mako maya welimo elewole oko elibomidana elibo wewena owaha mudamoe. ");
INSERT INTO yby_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Loko lokaiyoko lowa wesida ujapa wenipomo doli hibo wewena maya aku li lika iki numutoka wiki aya elekele we saina elaibomidanama muda-elabo maya sainalama alo haka lokoko neyoko muda-eliminabo ne. ");
INSERT INTO yby_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Sa-okaiyoko Jisesimamo mino hana amoko eba mako uliwa Naeniyo loko nebo numutokaya unala ipalale yuhamaki niwayoko maloka wewenamaki demesalo moliki wae. ");
INSERT INTO yby_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sa-ikiya wiki oho atetoma ninisayoko ono mako moliki liki lemeboya eto mena makomidana ipalaya helekaiyoko moliki liki leme. Sa-ikiya ale jitakiliya muki wewenamaki liki nilemeyoko, ");
INSERT INTO yby_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","We napamamoya aya eto menamidanama muda-elokoko muluna hukokaiyoko wije amo. ");
INSERT INTO yby_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Loko lokoko woko ono yauhalo maya ade noliyoko ohikiki sini-minayoko Jisesimamo maya ipalae sinatane loko noloyo sino. ");
INSERT INTO yby_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Loko liyoko helenebokutima sinokoko gahenama liye. Sako noliyoko Jisesimamo woko dolatema minasaiye loko liye. ");
INSERT INTO yby_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sako lokaiyoko muki wewenasiya mudabo nesamuya domodanipo adoha wokaiyoko Omaimidana epoka liki Omaimidana epalauti ga lokaka we napaya luwawateuya soto pekaiye liki layoko, malokasiya Omaimoya wewenalale yuhasidama dilipe wati etiye lokoma oli hekaiyoko nisekaiye. ");
INSERT INTO yby_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Liki layoko Jisesida gala maya Judiya ebakuka ito maloka ebakukakiya woko niseko iye. ");
INSERT INTO yby_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Joni maya nala numukugo neyoko unala ipalale yuhasiya Jisesikaho oko moloko ibo ga maya wetome iki li mikayoko, ");
INSERT INTO yby_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","gawaya elekadanaki Jisesidamamuya ata lowe kekoko edimokutima we lowe maya doli heko We napamidanama sa-liki loka itasaiye loko doli hiye: Soto pitiye liki monoka bukugu luhuwa ji-minabo we maya emoya minape ito alika we mako soto pitibokumu ewa etune liki liliyo loko doli hekaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","aya wemasiya Jisesitokama wiki sa-liki laiye: Noku udobetokaka we Jonimamo wiki lahelamibo nesauti lilimitiye loko lo mololetaibo wema minape ito aito makoma nisitibokumu ewa etune liki loka italiyo loko loli hekaiyoko emotokaya nonisoiye. ");
INSERT INTO yby_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Liki likaiyoko aya yulakama Jisesimamo saina delaibo wewenahena dilipe haka loka ito oloha lahelamibomo dukau waitoko nebo wewenahenama olohasidama kohaidoko doli he hulika ito domuda likaibo wewenasida domuda le pana keka ito di dade uka jibo wewenasidama le petobetoka oko ne. ");
INSERT INTO yby_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sako sa-noiyoko we lowemasi nisiki loka itaiyoko Jisesimamo edimoya enemane iki wiki maya mudaibo nesamuya Jonidama wetome iki li miliyo. Domudalo libo wewenasidama le pana kebetokaka noiye. Dilo libo wewenama dilipe lalo okaka noiye, ito mika ihi jelebo wewenasidama le olutobetokaka noiye, ito data molaibo wewenasidama le golotobetaiyoko gahena maya elikaka niae, ito lepa onoma dilipe sinokaka noiye, ito limiki minabo ebili-nabilimasiya ane lalo maya elikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sa-onenako wewena mako nemo monawanemuya data lowe kamitabo wewenama elowa jiki minakilae liki li miliyo loko lo biye. ");
INSERT INTO yby_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jonikaho doli hibo we lowesida maya sa-loko lo bekoko doli hiyoko aku li wili jiki niwaiyoko Jisesimamoya malo nisiki li esa abo wewenasida maya Jonidamuya sa-loko lo biye: Edimosiya ame mikaloka wabo maya nenakidana wema muda-elatune liki wabo ne. Joniya yasilimo liyoko akepaya mino yeilaloka maloka ibomidana oko Joniya lowe alo we neyoko muda-elatune liki waboma nehe. ");
INSERT INTO yby_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ito upaloya onowela le koloko neyoko muda-elatune liki wabo nehe. Eli-minahe. Saina lalo li koliki minikaka niabo wewenasiya duliki wesida numudanipougo udiki siniki iki nodenesa lalo wavu-liki niki minikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Sabo maya nenako, edimoya Omaimidana epalauti ga lokaka we mako mudaikili wabo nehe, olo. Ito elilo. Edimo mudai-minabo we maya Omaimidana epalauti ga likaka we malokamidana minamiye. Emoya aitomidanaya ne. ");
INSERT INTO yby_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Monoka bukuguya Omailimo ga mako sa-loko liboma luhuwa ji-minaboma ne: Elilo, nemo nepauti ga lo-lele monitibo we mako oli hekoyoko omutoko woko dukau yowanu litibomidana anuwaya wiletakolaiye. Loko libo ga maya Jonitokaya niseko ulolotiye. ");
INSERT INTO yby_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Loko lokoko nemoya wehe loko lo libituyo, eli-minalo loko liye. Edimo ma mikau soto pebo wewenasikutiya Jonida asitiki minabo weya minamae. Sa-oneboya, Omaimo ujapa obetaiyoko minabo wewenasi yowiki minabo ito limiki minabo muki wewenasiya Jonidama asitiki minae. ");
INSERT INTO yby_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Loko liyoko takisi likaka wewena malokakiya aya gama elikiki Jonikaho noku udobetonebo nenako, Omaimidana anula maya wehe lone liki eleboya, ");
INSERT INTO yby_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Palasisi wewenaki ito monoka monawamuya lainimi ibitikaka wewenakiya Jonikaho noku udobetaibomuya osele ikikiya, Omailimo wilebetaibo anu maya demesa mikiki hulikae. ");
INSERT INTO yby_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sa-iyoko Jisesimamoya sa-loko liye: Oloti maya onawalo minabo wewenaya nenahaloma lo moloko loyoko woko wehe letiye. ");
INSERT INTO yby_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Edimoya eli osele iki pelesa jikaka oluhokidana minae. Oluho lasomosolasiya li esa ikaka ebatoka wiki miniki oluho malokasidama ju liki edimoya nenahamuya nama loko ono moludawotoma nisiki lemesalo moliki lamae, ito malokaya wije nama ludawotoma nenahamuya wije nama lamae. ");
INSERT INTO yby_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sa-ikaka nianako, nemo Joniteya yamidana nesa lolo okaka noiyoko depa aha kohalelikaka niae. Noku udobetokaka we Jonikahoya api oko aya yowanu nolidanaki nodenesa lalohena namoko moseko minoko lekaka noiyoko muda-elikikiya oloha makolimo ukala le opa napa okaiyoko ne liki lae. ");
INSERT INTO yby_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ito malokaya nemo okulumauti we uti lemeko nodenesa lalowa ito no lalowa noko minoyoko muda-nelikiki mudalo. Emoya aso we netinako takisi ehada likaka we ito maloka lahelamibo nesa lolo ikaka wewena minae loko lata kekaka noudawo wewenakiya minoko nodenesa nonainako iwenipo netiye. ");
INSERT INTO yby_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sa-nilaboya Omaimoya saina-painahena le wehe loko lekaka noiyoko ele wehe lokogo minokaka noiyoko, unala ipalale yuhasiya yamidana monawaya li soto moliki likaka niae loko lo biye. 22 Aes 35:5-6; Aes 61:1 27 Mat 3:1 29 Mat 21:32; Luk 3:12 ");
INSERT INTO yby_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jisesida maya Palasisi we makolimoya nodenesa natane liyoko numudalauma yowiki nodenesa niki minaiye. Sa-ikiya nodenesa ninaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","aya numutoti mena makolimo Jisesima Palasisi wemidana numudalauma yoweko ne liki laboya elekoko nuvala lahelepa wibo netupa ehadaloti lolo abo odau ji-minaboya leko yoweko, ");
INSERT INTO yby_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","emesaloka nedanaki wije noiyoko omudala nouvala maya lemo Jisesida ilo maya jiyoko madona yopaladunu ilo maya uliyetaiye. Sakokoya Jisesida ilama wotoko nokoko ilaloma nuvalaki netupama hiletaiye. ");
INSERT INTO yby_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sa-iyoko Jisesida nodenesa natane libo Palasisi wemamo mudakoko ukalaukama sa-loko eliye: Maya menalimoya lahelamibo nesa leko Jisesida upalo maya nolinako Jisesiya Omaimidana epalauti ga lokaka we netiboya aya menamidana monawamuya olisalo menae loko letine. ");
INSERT INTO yby_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Loko ukaukaya noeliyoko Saimoniyo nemo ga mako lo imituyo loko liyoko, tisane yamalae, lideko elituwe. ");
INSERT INTO yby_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Loko liyoko Jisesimamo ga mako sa-loko koha moloko lo miye: We makolimoya alikamuye loko we lowesidama dina ehada biye. We makomidana 500 kinaya miye. Ito makomamidana 50 kinasiya miye. ");
INSERT INTO yby_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sa-okaiyoko alika maya ayaloma bekimi esiye liki ehadamu ohu jeibo maya minamiyoko minamiye liki laibo maya hulikaliyo loko liyoko ahaya minaiye. Sa-iboya aya we loweutiya nakaha welimo lahowenipomidana epoka napa letibo ne. ");
INSERT INTO yby_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Loko lokaiyoko Saimonimamo, nata eloboya ehada napalo mibo wemamoya lahowenipomidana epoka napa letibo ne, loko liyoko wehe loko lane liye. ");
INSERT INTO yby_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Loko lokoko maya menama nebotokama mino wili jeko Saimonidama sa-loko lo miye: Maya menamidana mudaminape. Numudakau yowekoko ni nade no jitubotokaya no kiseko molonetamadawoya, maya menamoya omuda nouvalaloti niya no jekoko madona yopaladunuma nouliyenetaiye. ");
INSERT INTO yby_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ito emo napusa jamaniyokoya numudakau noyowoyoko maya menamoya nine wotoko nomo noyowiye. ");
INSERT INTO yby_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Emoya okaka onoudawo nesa leko madoneuya netupa hilenetamadawoya, maya menalimo nuvalaki netupama niloya hilenetaiye. ");
INSERT INTO yby_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sa-noiyoko sa-loko lo noemoe: Maya menalimoya nemodamu elekoko nasahili napa onetokaiyoko muki lihimala maya aloya nosuwiye. Wewena mako lihimala lasolasi le huloetokadeko netibo wewenamamoya le huloletaibo wewenamidanaya ukala maloka lasolasi mene. ");
INSERT INTO yby_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Loko lokoko maya menamidana maya lihimaka maya alo le hulo suwoetokoe loko lo miye. ");
INSERT INTO yby_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Loko liyoko magoina emoki miniki nodenesa nabo wewenamasiya edimonipolokaya emoya aitomidana we minoko nolihe liki lae. Lihimakaya suwokaiye loko noliboya nakaha wemamo noliye. ");
INSERT INTO yby_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Liki nilayoko Jisesimamo ya menamidanama nemotoka elewole oko ata kedawolimo lihimakama suwokaiye, mulukauya lalo eleko wo loko lo miye. 37 Mat 26:7; Mak 14:4; Jon 12:3 ");
INSERT INTO yby_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sakokoya alikaya Jisesimamo muki eba napa lasolaukakiya moneko monoka maya lo beikaka oko ito Omaimo muki wewenasida uliki we lolo etibo gahenala lalo maya wetome oko lo beikaka oko ne. Sako moniyoko emeke moliki monebo wewenautiya unala ipalale yuha 12-pala ne, ");
INSERT INTO yby_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ito olohasida dukau minaboloti ito saina delaiboloti dilipebenebo mena ne, makoya Mele ulilaya Magadalao liki molabo mena emo ukalauti oloha 7-pala kohaidoko doli hibo mena, ");
INSERT INTO yby_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ito Jowanaya Sujada menala Helotida yowanulalo ujapa wemidana menala, ito Susana ito maloka menakipaya uvaminanipoki minikiki Jisesida unala ipalale yuhasida maya nasahili ibitiki minae. 2 Mat 27:55-56; Mak 15:40-41; Luk 23:49 ");
INSERT INTO yby_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Muki numuto namato wewena maya nisiki Jisesima nebotokago minayoko mudakoko koha moloko ga mako sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Yuha nesa tili okaka we makolimoya mijakuma yuha nesa tili ekolo wiye. Woko yuha nesa tili omo nowiyoko maloka lemo anulo jibolawama wewenasi wiki nisiki ikili mijiki otele ae. Ito malokaya aha-namasiya nisiki niki suwae. ");
INSERT INTO yby_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ito malokaya limi ehatoya jikiki potiki yowedelamuya yoweha mika nouvalama minamiyoko alala miki hele. ");
INSERT INTO yby_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ito ihilawa malokaya lemo lilihau jekoko magoina lilihaki wileko yowiha lilihalimo jemikaiyoko opa teko heliye. ");
INSERT INTO yby_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ito malokasiya limi mika lalou jikiki potiki yowiki ihilawa lalo nesaya je. Makoko makokosiya ihilawanipo 100 je. Loko lo suwokoko ga napauti sa-loko liye: Edimoya dataki minune liki maya ga nolobo monawaya eli wehe lilo, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Loko lokaiyoko unala ipalale yuhasiya koha moloko libo gamuya Jisesida loka itikayoko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Omaimoya muki wewenasida uliki we lolo obetatibomidana suna ibo gala maya edimoya elitae loko loneboya, malokasiya koha moloko agoya elitae. Sa-nikiya saina-paina domudalotiya mudataboya mudai wehe lamikilae. Ito dataloti aya elitaboya eli wehe lamikilae. ");
INSERT INTO yby_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ito ga maya koha moloko noloboya monawaya lo libituyo. Yuha nesa ihilawaya Omaimidana gala laloya ne. ");
INSERT INTO yby_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ito ihila nesa lemeko anulo nebomidana iki minabo wewenaya Omaimidana gala elitaboya lemeko dukauma minokadeko aya elewole iki elikadeko Omailimoya dilimekatiye loko Olohalimoya niseko aya ga maya leko wokaka noiye. ");
INSERT INTO yby_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ito ihila nesa malokaya ehada mupilalo lemo jeko wileko yowibomidana iki minatabolawama monoka gama eliki lahelepa delokaiyoko elikaka niaboya, dukauya luhawanipo ilitamiyoko nenako, onawa minawasi liminayoko mimi molokakawa soto piyoko monoka aya hulikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ihilawa maloka lemo lilihau jibomidana iki minatabo wewenaya monoka elikakawa elitaha, dupamo dumu helekaka noibo nesa jeko hitomikaiyoko nenako, moni uvaminamidana lelamoya lemeko dukauya monoka gamidana le jebetokaiyoko edimotokaya ihilawa jeko halatamiye. ");
INSERT INTO yby_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ihilawa maloka lemo mika lalou jibomidana iki minatabo wewenaya monoka eliki li pilikiki liminayoko edimotoka monoka ulawa soto pekaka noiye. 10 Aes 6:9-10 ");
INSERT INTO yby_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nakaha welimo leya lepa okoko somodunu jeko hitatibo ne. Ito nakaha welimo lepa okoko sipa iwauka lolosa etibo ne. Samitaboma ne. Nisitabo wewenasidama heko hada obetatiye loko lepa oko sipalo molatibo ne. ");
INSERT INTO yby_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ayamidana oko Omaimidana suna onebo nesa neboya woko tolowa ametiye. Aya nesaya soto pitibo nesa ne. Ito halukuka netibo nesakiya asako soto pe suwekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Wewena mako monoka li-minatabo wewenasiya wati iki ujapa iminataboya Omaimoya aku kolo meko bekolaiye. Ito wewena mako monokaya li laliki ujapa amitabo wewenasiya ahagoya le-minupe liki litaboya akuya hipo oko lekolaiye. Sa-oneyo, edimosiya maya aya elikikima li madotipou molalo loko lo biye. 16 Mat 5:15; Luk 11:33 17 Mat 10:26; Luk 12:2 18 Mat 25:29; Luk 19:26 ");
INSERT INTO yby_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yu makoya muki wewenasi nisiki Jisesidama hiki wego ikiki minayoko Jisesida dolale unamotalalema nisiki alowo jikiki hetoka yeimaya minae. ");
INSERT INTO yby_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sa-niayoko we makolimo mudakoko Jisesida maya dokale unakale yuhama muda-elakili nisebo maya wewena waitikayoko hetoka maya nisiki minae. ");
INSERT INTO yby_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Loko liyoko Jisesimamo muki wewenasidama Omaimidana gala eliki eli likaka niabo wewena maya nemo donele unamotanele minae loko liye. ");
INSERT INTO yby_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yu makoya Jisesile unamotalalekiya noku lapeuma yowikiki minayoko Jisesimamo no maya sila oko yola helega wetune loko liyoko wae. ");
INSERT INTO yby_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sa-ikiya niwayoko Jisesi maya omuda hihi iyoko udoneyoko go napa jeko yasi napa-napa okoko ahuhumaki nonisidanaki no maya alahuka jeko hulo noku lapeuma moloko noku lape maya leko nokuma limitibo nesa liye. ");
INSERT INTO yby_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sa-iyoko Jisesida maya ilime sinikiki ujapa wete yamalae, lemoya noku maya sima nakolune liki lae. Liki layoko Jisesimamo sinokoko lasimaki no alahuka jiboki auha biyoko amanapa aiye. ");
INSERT INTO yby_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sako you likaiyoko unala ipalale yuhasidama elewole iki elikaka niabo nesatipo maya nakahama ne loko loka obetaiye. Loko liyoko unala ipalale yuhasiya aya nesa mudabomuya domodanipo adoha wokaiyoko agae, likiki sa-liki ligi hagi ae: Oho, maya welimoya yasimaki ito nomakiya gama lo bibo maya elikainako maya weya aitomidana we netiye liki lae. ");
INSERT INTO yby_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sa-okaiyoko Galeli no yola helegalokama Gegesa wewenasida ebanipoukama wiki hetae. ");
INSERT INTO yby_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","30","Wiki hetikiki no ilikaka maya niyoweyoko numuda napautiya we makoya nisiye. Aya weya oloha lahelamabosi ukalauya waitiminayoko hana-pana yulaka numuku udamibo we ne, hetoka ehada numuku ito ono molikaka aboku udoikaka oko monekaka noibo we ne. Ito aya weya olohalimoya ukalau elewole oko minokaka iyoko muki yulakaya wewenasi seni nalalotiya ilo adelo etoha iki nala jikiki ujapa itiki minikaka aboya, aya nala maya olohamamo kohako huko hulikaiyoko, oli hetoka lemeko ametokago woko minokaka ibo we ne. Sa-okaka noibo nenako, aya wemamo Jisesidama mudakoko igukama pou loko udoko ga napauti amowa jeko sa-loko liye: Jisesiyo Omai yowau wemidana ipala yamalae, nehahalo lahelamibo nesaya lolo onetakolo nonisene. Loko liyoko Jisesimamo ulika ekahimae loko loka oetaiyoko, Olohamidana weuna oluhoya ukauya wavu-liki minaboma nenako, nemo ulineya etipa minoe loko liye. Loko liyoko Jisesimamo oloha lahelamibomidana uliwa noloko maya wemidana ukalautiya hulikoko wamane loko libokumuye loko aya wemamoya emokaho miluma yowanu nemametane loko elewole oko loka noetoe. ");
INSERT INTO yby_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Loko lokoko lemodaya loli he hulo meiku molametane liki meusa oluhosi labo ga liki lae. ");
INSERT INTO yby_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Liki layoko ayaloya ja wavu-liki yomi niki minayoko doli hekadeko jasida dukauya yowetune liki loka loka iki lae. Liki layoko oo liyoko, ");
INSERT INTO yby_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","aya olohamasiya aya wemidana maya hulitikiki wiki jasida dukauma yowiki limikayoko, aya jamasiya oli li lakiwaloka limiki limi nohukuma jiki niki nihutiki hele. ");
INSERT INTO yby_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sa-ikayoko ja ujapalo wemasiya mudaikiki oli taoniloka ito numuda emesalokama wiki wetome iki li bikayoko, ");
INSERT INTO yby_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","muki wewenasiya aya soto pibo nesama mudatune liki Jisesima nebotokama nisiki olohalimo ukau nebo we maya upalo nesa maya le kolokoko gala elekaka noibo nesala maya golotokaiyoko gama eleko Jisesida igukama neyoko, muda-elikiki domodanipo adoha woneboma ne. ");
INSERT INTO yby_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sa-iyoko aya nesa mudabo wewenasiya olohaki nebo we maya dowa libomuya wetome iki mudamabo wewenasidama li be. ");
INSERT INTO yby_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sa-iyoko Gegesa ebakuka wewenamasiya domodanipo adoha wokaiyoko Jisesi maya aya eba maya hulikoko wetiye liki lae. Sa-likayoko akuya wekolo noku lapeuma yowiye. ");
INSERT INTO yby_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Sako noyowiyoko oloha ukalauti oli heko le huloetaibo wemamo Jisesidamamu magoina nemoki minasiye loko loka loka iyoko Jisesimamoya ele mameko sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Emoya woko Omailimo lolo oetaibo nesamuya numudakaloka wewenakasidama wetome oko lo bo loko oli hekaiyoko aya wemamoya woko numudalaloka wewenasidama Jisesikaho lolo oetaibo nesamuya wetome oko lo beko suwiye. ");
INSERT INTO yby_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sa-iyoko wewenama yola helegama Jisesikumu ewa iki minayoko akuya nisiyoko ekewake litikiki, ");
INSERT INTO yby_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","monoka numukuya uliki we mako neboya ulila Jaelusiyo loko nebo weya oluwa makoko neboya kilisimasila 12-pala nebo olu maya saina elaiboya helekolo noiyoko, Jisesitoma niseko i bola heko numudaneloka magoina wesiye loko liyoko magoina niwaiyoko muki wewenamakiya wavu-liki niwayoko, ");
INSERT INTO yby_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","luwawanipouya mena makoya ukada anu molowa molowa oko minoko lusa wewenasida ehada beko suwoko kilisimasi 12-pala le hulaiyoko lusa vitaha vitaha suwametibo nesa lekaiyoko hulitabo ne. ");
INSERT INTO yby_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Sa-ibo nenako aya menamamo Jisesida emesaloka niseko upalo nesa lolowalokama ade liye. Sakoya niseko ade noliyoko ayalo maya oladala maya sepo jetaiye. ");
INSERT INTO yby_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sa-iyoko Jisesimamo loka obetoko ekahimamo nupalo nesalo noliye loko liyoko, muki wewenamasi yuwawa molayoko, Pitamamo ujapa wene yamalae, wavu-liki wewenaya emesaloya ninisenako yauti yatokasi ma upalo nesalo li-minakilae. ");
INSERT INTO yby_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Loko liyoko Jisesimamoya o'e, wewena makolimoya alo nupalo nesalo noliyoko abuha-wowo makoya nupaloti nowiyoko elekoko noloe. ");
INSERT INTO yby_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Loko liyoko maya menamamo monawanema aloya soto pinako loikoko luwo-luwo jekaiyoko muki wewenasida domudaloma lemeko Jisesida igukama noudoko elaibo nesamidana monawama ito upalo ade noliyoko suwoetaibo monawama wetome oko liyoko muki wewenasiya ele. ");
INSERT INTO yby_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sa-iki nieleyoko Jisesimamo olune yamalae nemodama elewole oko ata kedawolimoya ilime haka lokaiyo, mulukauya lepa hideko wo. ");
INSERT INTO yby_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Loko noliyoko monoka ujapa wemamidana numudalautima we makomamo nisekoko oluka maya aloya helekaiye. Sa-okainako tisateya ahamuya osele anuya nisekatiyo, ");
INSERT INTO yby_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","huliko loko liyoko Jisesimamoya Jaelusida maya omodaka wamideko elewole oko ata kitadawoya olukaya aku sinakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Loko lo miyoko woko numutoka maya hetokoko aya numuku maya yowamitae loko muki wewenasida maya doli he hulikoko Pitale, Jonile ito Jemisile aya olumidana dolako aholako ayahasi dilipe-loko numukuma yowiye. ");
INSERT INTO yby_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Muki wewena ayauma wije nama liki minayoko yoweko mudakoko wije nama lamilo, olutipo maya helamoko aha omudaya udoneyo. ");
INSERT INTO yby_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Loko liyoko hapa heleneboma ne likadanaki ijala itae. ");
INSERT INTO yby_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sa-ikayoko Jisesimamo adeloma le-minoko olu yamalae sinowo, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Loko liyoko ayalo maya wehe loko sinaiye. Sakoya sinokaiyoko nodenesa maya liki nisiki olumamidana maya mideko natiye loko lobetaiye. ");
INSERT INTO yby_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Loko lobetokaiyoko, dolako aholako maya oliwaki nesama lolo iye liki agae liki laiye. Sa-okaiyoko Jisesimamo aya nesamuya ga wetome iki maloka wewenasida li bamitae loko lo hukobetaiye. ");
INSERT INTO yby_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisesimamo unala ipalale yuha 12-pala dilipe nupa okoko wewenasida dukautiya oloha ulama kohaidiki doli hitae loko ito saina delaibo wewenasida dilipi haka libitatae loko yamidana elewolewa biye. ");
INSERT INTO yby_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bekoko Omaimo muki wewenasida uliki wenipo lolo etibo gala maya li biki saina delaibo wewenasidaya dilipe haka litae loko doli nohekoya ");
INSERT INTO yby_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","sa-loko lo biye: Anu witabotokaya sainahenaki liki wamilo. Akusa uka jekaka owoya beletiya ehadaya lamiki ito owo loweya uka jamiki wilo. ");
INSERT INTO yby_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yowitabo numukuya udiki mini-liki wikiya aya numutotiya witayo. ");
INSERT INTO yby_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dilipi lalo amidekoma aya ebama hulikiki niwikima huka biki dilotiya mumusopa tili i hulikiki wilo. ");
INSERT INTO yby_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Loko lo bekaiyoko numuto namatoka wadanaki Jisesida gala lalo maya li bikaka iki saina delaibo wewenasidaya dilipi haka lae. 3-5 Luk 10:4-11 5 Apo 13:51 ");
INSERT INTO yby_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Sa-niayoko uliki we Heloti maya aposolosi elewole anehena lolo niabo ga maya elekoko ata etipa kiboya, maloka wewenasiya Joniya helenebokuti ilime sinokaiyoko ne liki layoko, ");
INSERT INTO yby_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","maloka wewenasiya Ilaija maya Omailimo ilime sinokaiyoko niseko ne liki layoko, maloka wewenasiya hapa yeikala Omaimidana epalauti ga likaka weuti maya makomamidanaya Omailimo ilime sinokaiyoko niseko ne liki layoko, ");
INSERT INTO yby_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helotimamo elekadanaki sa-loko liye: Jonida enolama hukokoboma nenako, maya nesa lolo noibo weya ekahidamu nilitae loko liye. Loko lokoko Jisesida maya muda-elatuwe loko eliye. 9 Mat 16:14; Mak 8:28; Luk 9:19 ");
INSERT INTO yby_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposolosiya yowanulo doli hibototima akuya nisedanaki edimotoka iki moliki abo nesahenama wetome iki Jisesidama li me. Sa-ikayoko dilipe-loko numuda eba mako uliwa Betisedae loko nebo numutokaya wiye. ");
INSERT INTO yby_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sa-iyoko muki wewenasiya elikiki Jisesidama emesalo moliki niwayoko, dilipe nupa okoko Omailimo muki wewenasida uliki we lolo etibomidana gala lalo maya wetome oko lo beko saina delaibo wewenasidama dilipe haka haka liye. ");
INSERT INTO yby_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sa-iyoko ludaka maya homa lemekolaiyoko unala ipalale yuha 12-palamasi nisikiki sa-liki li me: Lemoya ametoma minuniyo, maya wewenasidaya doli hideko numuda napalokaki asolalokaki wiki nodenesamu ohu jiki nikiki udataboma ne. ");
INSERT INTO yby_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Liki layoko Jisesimamo edimotipoya nodenesa biki nalowo loko liyoko, sa-liki onoto liki lae: Beleti lade maloka suwiyoko ito lahawa lowemakigo maya molo-minudawolae. Sa-ominudanako lemoya woko maya wewenasida nodenesanipo meina hebetatune loko nolape. ");
INSERT INTO yby_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Liki labolawa maya yalo li esa iki minabo weya 5000 minayoko elikadanaki sa-liki layoko Jisesimamo unala ipalale yuhasidama sa-loko lo biye: Muki wewenaya 50 50 iki mini nupa ika mini nupa ika ilo liki li bilo, loko lo biye. ");
INSERT INTO yby_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sa-liki li bikayoko muki wewenama mikalo minayoko ");
INSERT INTO yby_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisesimamo beleti lade maloka suwokomaki ito lahawa lowemakiya lekoko okulumaukama omuda hulo moloko Omaimidana epoka lokadanaki beletima posekoko aya nodenesama liki moniki bitae loko unala ipalale yuhasidama biye. ");
INSERT INTO yby_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sa-iyoko muki wewena maya niki dohumanipo ikiki nodenesa lumawa nebolawama li nupa iki manoda lape 12-pala owo jiki waitokaiyoko li molae. ");
INSERT INTO yby_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yu makoya Jisesimamo Omailoka loko nedanaki unala ipalale yuhama edimonipogo minabotoya sa-loko loka obetaiye: Muki wewenasiya nemokumuya ekahima ne liki likaka niae. ");
INSERT INTO yby_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Loko liyoko sa-liki li me: Noku udobetokaka we Jonima aku soto peminane liki likaka niae. Ito maloka wewenasiya Ilaijama hapa okulumau yowenebo we maya akuya lemeko minane liki likaka niae, ito malokasiya hapa yeikala Omaimidana epalauti ga likaka weuti mako maya aleuti sinokoko minane liki likaka niae. ");
INSERT INTO yby_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Liki likayoko Jisesimamo loka obetoko edimotipoya nemokumuya ekahima ne liki likaka niae. Loko liyoko Pitamamo onoto leko emoya Omailimo lahelamibo nesauti lilimitiye loko lo mololetaibo wema minane. 19 Mat 14:1-2; Mak 6:14-15; Luk 9:7-8 20 Jon 6:68-69 ");
INSERT INTO yby_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Loko lokaiyoko Jisesimamo lo hukoko sa-loko lo biye: Oloti maya lo nolibobo aya wewena makosida li bamilo. ");
INSERT INTO yby_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Okulumauti we uti nemodaya Omailoka jokila hi mikaka we napaki monoka monawa lainimi ikaka weki ito monoka ujapalo wesiya muki edawaki miluma nesaya li ohinitikiki mudaneli hulikadeko kohaneli helikadeko onawa loweki makoki yulaka minokoko aleuti aku sinakoloe. ");
INSERT INTO yby_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Loko lokoko muki wewenasida sa-loko lo biye: Wewena mako nemoda nemesalo molatune liki eli-minikima dupalimo elekaka noibo nesaya eli hulikiki muki yulakaya miluma nesa libitiki kohaidi helitabomuya eliki oli libamideko eli hulikiki nemesalo moliki nisilo. ");
INSERT INTO yby_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ito wewena mako dukanipo li amanapa ikiki minatabo wewena maya dukanipoya woko opa-napa ekolaiye. Ito wewena mako nemokumuye liki dukanipo wina itaboya elewole depa mutiwa likilae. ");
INSERT INTO yby_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wewena malokasiya ma mikamidana mupilalo nesahenaya li suwikadeko edimonipo dukanipoya tolowa etiboya, mikauka uvaminalimoya nena nena okoma dilipe lalo etibo ne. ");
INSERT INTO yby_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wewena mako ulinemuhe ito monokanemuhe wetome itabomu owanipo helitaboya, okulumauti we uti nemo lamedane ito ahoneda lamedalakiya mupilaneloya yowekadeko okanaki welale maya dilipe-loko limitubo onawalo owatipo helebomidana nemokiya ulinipo le sawa jitubomu owane helekoloe. ");
INSERT INTO yby_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sa-onenako nemoya wehe loko lo libekoloyo, eli-minalo. Edimoya oloti minabokutiya malokaya helamiki aha miniki Omailimo uliki we lolo oko ma mikau wewenasida ujapa etibo onawaya soto pideko mudakilae, loko lo biye. 23 Mat 10:38; Luk 14:27 24 Mat 10:39; Luk 17:33; Jon 12:25 ");
INSERT INTO yby_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisesimamo ga maya lo beko suwokoko onawa 8-pala yamidana oko wokaiyoko Pitale Jemisile Jonilesidama Omailoka letuwe loko dilipe-loko bolauma yowiye. ");
INSERT INTO yby_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yoweko Omailokama liyoko okepa omudalama le aitomidana okoko upalo nesama ukulo haepae tibo nesaya le olo jekoko ne. ");
INSERT INTO yby_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sakokoya neyoko alinali we lowe Moseseko ito Ilaijako maya okulumauti nisiki domudalo soto pikiki Jisesilemaki alo-nalo iki minayoko, ");
INSERT INTO yby_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","okulumau onowe liki minikaka niabo nesaki minaiyoko Jisesi maya Jelusalemu numutoka heleko Omailimo lo molaibo nesa maya lolo etibomuya ligi hagi ikiya minae. ");
INSERT INTO yby_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Sa-niayoko Pitale yuha maya domuda hihi okaiyoko udi-minabokuti maya sinikiki mudabo maya we lowemaki ito Jisesi maya lamedalaki neyoko mudai-minabo ne. ");
INSERT INTO yby_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mudaikayoko we lowe maya hulimikiki wikili niaiyoko Pitamamoya sa-loko Jisesidama lo miye: Monoka ujapa wene yamalae, maloya minudawoya dowa liye. Sa-okainako, olowala numuda loweki makokiya volibetatune, makoya emodae, makoya Mosesedae, makoya Ilaijadae loko liboya opa aya liye. ");
INSERT INTO yby_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Loko nolibo epaki limulimoya lemeko je hitobikaiyoko nenako domodanipo wiye. ");
INSERT INTO yby_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sa-noiyoko ayautima ga mako sa-loko soto piye: Ipane maya ilime eto ominoboma neyo, emo gala maya eliki emesalo molalo. ");
INSERT INTO yby_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Loko lokaiyoko mudaboma Jisesima eimolago neyoko mudai-minabo ne. Sa-ikiya mudabo nesamuya depaya hiki li likiki wewenasida maya wetome iki li bamabo ne. 32 2 Pit 1:17-18 35 Luk 3:22 ");
INSERT INTO yby_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Udikiki goma lokaiyoko bolautima limiki minayoko muki wewenamasiya nisiki Jisesileki hotula-patula ae. ");
INSERT INTO yby_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sa-ikiki ayauti maya we makolimo ga napauti sa-loko ju loko liye: Monoka ujapalo wene yamalae, nemo ipane makokomidana niseko muda-elatane loko noloe. ");
INSERT INTO yby_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Olohamidana weuna oluho makolimo muki yulakaya ukauya yowekoko neyoko opa-napa ga lokaka noiye. Sa-okoko aya nesalimoya ilime momoga okaka onoiyoko epauti etehu ilakila okaka noiye. Sa-oko kohaowa kohaowa oko minoko enemane oko huloetatibo nesa lamiye. ");
INSERT INTO yby_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ito unaka ipakalesidama aya Olohamidana weuna oluhoma kohaiki oli hitae loko lobo maya sa-itabo nesa lamiye. ");
INSERT INTO yby_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Loko lokaiyoko Jisesimamoya sa-loko lo biye: Edimoya eli elewole amiki eli amanapa ikiki minabokumuya oselene nelokaiye. Edimoki muki yupeka minowa minowa oko minoyoko eli elewole itahe. Sa-ikayo ipakadama maloya ilime-loko ano. Loko lokaiyoko oluho maya Jisesima nebotoka nonisiyoko Olohamidana weuna ohuhomamo aya oluhomidanama ipisiyoko lemeko mikaloma pou loko udokoko ilime momoga iye. ");
INSERT INTO yby_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sa-iyoko Jisesimamo Olohamidana weuna oluhoma auha meko oli he hulikoko aya ipamidanama akuya le lika oko aholatokama oli he hulaiyoko wiye. ");
INSERT INTO yby_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sa-iyoko muki wewenasiya Omaimidana elewoleyalamuya epoka lae. Sa-ikiki Jisesimamo oliwaki nesa elewole lolo ibo nesamuya aiyo wuye nilayoko unala ipalale yuhasidama sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Edimoya maya aloya data eliki minalo. Okulumauti we uti nemodaya ulanelo wesida dadeu nilimi molakilae, kohanelatae liki. ");
INSERT INTO yby_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Loko liboya yamidana monawa elikatae loko data golotamibo nenako loka oko ele wehe letune liki saboya neha, domodanipo wokaiyoko loka itamae. ");
INSERT INTO yby_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sa-okaiyoko unala ipalale yuhama lowa-sawa iki lemokutiya ekahoma aseletoko uliki we netiye liki lae. ");
INSERT INTO yby_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sa-liki dukauka nilaboya mudakoko Jisesimamo oluho asolasi mako ilime-loko nisekoko amaitoka maya ilime sinokoko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Wewena malokasi nemokumuye liki oluho asolasi maya nasahili ibitikaka itaboma nemoda nasahili itabo elene. Ito nemoda nasahili initataboya ahone noli hibo wemidanaki nasahili itabo ilekaka noiye. Edimokutiya we makolimo lemeko minoe loko letibo weya Omailimo ilime we napa lolo ideko aselibetoko minakolaiye. 46 Luk 22:24 48 Mat 10:40; Luk 10:16; Jon 13:20 ");
INSERT INTO yby_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Loko liyoko Jonimamo sa-loko lo miye: Ujapa wete yamalae, we makolimoya ulikalo loko Olohamidana weuna oluho lahelamabosidaya wewenasida dukauti kohaidoko doli nohiyoko mudaudawoya lemesalo molamibo we nenako, auha mune. ");
INSERT INTO yby_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Loko lokaiyoko Jisesimamo li hoipa itamilo, wewena mako ulatipolo we minamitaboya edimo wetipole minakilae loko lo miye. ");
INSERT INTO yby_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Omailimoya Jisesidama aku ilime-loko okulumau yowitibo onawa maya alili okaiyoko Jisesimamo Jelusalemu numutoka wetune loko elewole okoya ataya kiye. ");
INSERT INTO yby_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sa-okadanaki we makoma doli hekaiyoko Samaliya ebakuka eba makolokaya Jisesi nisitibomu li wati ikili wiki hetaiboya, ");
INSERT INTO yby_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jisesimamo Jelusalemu numutoka wekoloe loko libomu osele delokaiyoko ilimi molamayoko, ");
INSERT INTO yby_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","unala ipalale yuhautima Jemisiko Jonikomasiya mudaikiki We napate, lemokaho lokuniyoko okulumautima jolimo lemoko maya wewenasida kohaido esa etiye loko nolape. ");
INSERT INTO yby_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Liki laiyoko Jisesimamo mino wili jeko auha biye. ");
INSERT INTO yby_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sakoya auha bekaiyoko aito ebatoka magoinaya wae. 54 2 Kin 1:9-16 ");
INSERT INTO yby_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Anulokama niwayoko we makolimo Jisesidama sa-loko loka oetaiye: Wetadawotoka nisitadawotoka nemoya emesalo emesalo moloko monekoloe. ");
INSERT INTO yby_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Loko liyoko Jisesimamo sa-loko lo miye: Mikaya golotonebokuya ahasiya yowikaka niae. Ito namaya numudanipo neboya, okulumauti we uti nemoya udatubo numudane ito madonelo oseleho moloko udatubo nesa minamiyoko ohu nojobo nenako, magoina wesiye loko nolape. ");
INSERT INTO yby_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Loko lokoko we mako sa-loko lo miye: Emoya niseko nemesalo molo. Loko lokaiyoko aya wemamo sa-loko lo miye: We napane yamalae, emoya nenae loko elekoko nolane, nemoya woko ahone le ale lijemikoko niseko emesalo molatuhao. ");
INSERT INTO yby_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Loko liyoko Jisesimamo sa-loko lo miye: Helitabo wewenasida ale jibitikaka yowanuya duka helenetibo wewenasida yowanunipo ne. Emoya woko Omailimo wewenasida uliki we lolo etibomidana gala lalo maya lo soto moloko lo bo. ");
INSERT INTO yby_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Loko liyoko we makolimo sa-loko liye: We napane yamalae, emodaya emesalo molakolo noboya, woko nemo numudaneu minabo wewenasida maya minalo loko lo bekoko letuwe. ");
INSERT INTO yby_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Loko liyoko Jisesimamo wewena makolimo nemo yowanuneuti mino wili jitiboya Omaimidana yowanulauya woko yowanu litibo nesa lamiye loko liye. 61 1 Kin 19:20 ");
INSERT INTO yby_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Sa-iyoko We napamamo 72-pala wewenasidaya dilipe nupa okoko ona moloko lowe lowe oko muki numuto namato doli hiye. Sakoya doli hiboya alikaya eimola wetibo anulo maya witae loko doli hiye. ");
INSERT INTO yby_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Emo gala elikili niabo wewenamu koha moloko ga mako sa-loko lo biye: Nodenesama o-molokaiboya yowanu letudawo wewenaya lasolasi minokoko noluniyo, edimosiya wiki mija aholatoka lideko, dilipe yowanulo molokadeko yowanuwauya wiki mida numuda litayo. ");
INSERT INTO yby_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eli-minahe, sa-itayo wilo. Liwe jakidana minabo wewenasida luwawanipouya dukatipou hulu iki sipisipi jakidana minatae loko edimodaya doli nohoyo, wilo. ");
INSERT INTO yby_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Edimoya wikili maya ehada owotipo ito uka jikaka niabo owotipo ito dilo sutipohenamakiya lamiki hulikiki niwiki maya anulokaya yatoka nesamu data kiki iki mole-kaletamiki enemane iki wilo. ");
INSERT INTO yby_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Saki wiki numuda makomau yowikili niki maya numuda aholamidana ukau hulu minadekoma yowilo. ");
INSERT INTO yby_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aya numukuya hulu we mako netiboya hulumu litabo ga maya aya wemitokaya woko ulolotetibo ne. Ito yamidana we minametiboya aya hulu ga maya aku le lika oko edimotoka nisitibo ne. ");
INSERT INTO yby_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aito wewenasitoka yowanu li-minatabo wewenasiya yauti maya nodenesa liki niki minataboya dowa letibo nenako, numuda makomauya yowikiki aya numuku maya mini-liki wiki meinawatipo maya nodenesa yuha libitabomagoya niki minalo. Sakikiya aito numuku yowamiki makoko numukugo minalo. ");
INSERT INTO yby_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Eba makomauka niwideko eba aholasiya dilipi molikiki nodenesa libitabomagoya niki miniki ");
INSERT INTO yby_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","saina delatibo wewenasida maya dilipi haka nilikima sa-liki li bilo: Omailimo uliki we lolo olibetatibomidana elewoleya maya domudalokaya nisekaiye. ");
INSERT INTO yby_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ito eba makomauka niwideko dilipi lalo amidekoma anuloma wiki sini-miniki sa-liki li bilo: ");
INSERT INTO yby_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Edimo numudatipouti lilo mumusopa neboya edimokumuya anu ahoya molokokoya hopo noune. Sa-nouniyo, maya aya eli-minalo. Omai ohola maya domudaloka niseko alili okaiboya mudai hulikae liki li bilo. ");
INSERT INTO yby_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nemo wehe loko lo libekoloyo, elilo. Onawa napaloya Sodomu ebakuka minabo wewenasiya lihimanipo napa litabo neha, dilipi lalo amitabo wewenasiya Sodomu wewenasida lihimanipomidana asitiki likilae. 2 Mat 9:37-38 3 Mat 10:16 4-11 Mat 10:7-14; Mak 6:8-11; Luk 9:3-5 7 1 Kol 9:14; 1 Tim 5:18 11 Apo 13:51 12 Mat 10:15 12 Jen 19:24;28; Mat 11:24 ");
INSERT INTO yby_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Agae, edimo Kolajina wewenalika ito Betiseda wewenalikaya oliwaki nesa mako edimotoka soto pekolaiye. Oliwaki nesa ane elewolewa edimotoka lolo obo maya Taiya ebatoka ito Sidoni ebatoka soto petidanako, edimoya hapa duka miluma eliki li wili jebomidana monawa li soto moliki lada hiliki aseha nesa li dupalo koliki minatine. ");
INSERT INTO yby_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Onawa napaloya Taiya ebato minaboki ito Sidoni ebatoka minabo wewena mukiya lihima litaboya edimosi lihima napa edawaki likilae. ");
INSERT INTO yby_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ito edimo Kapaniyamu wewenalikaya lulite okulumau yowitiye liki li sawa jikaka niahe. Sako minaminako edimodaya jo ebaku dipiso hulakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Loko lokoko wewenala yuhasidaya kolo meko sa-loko lo beko doli hiye: Wewena makolimo edimo depauti ga elohe loko letiboya nemo nepauti aya elekolaiye. Ito wewena makosiya demesa libitaboya nemoda demesa nemebo elitibo ne. Ito nemoda demesa nimitaboya noli hibo wemidana demesa mebo elitibo ne. 16 Mat 10:40; Mak 9:37; Luk 9:48; Jon 13:20 ");
INSERT INTO yby_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sakoya doli hekaiyoko wiki minikiki mulunipouma aila uluma silekaiyoko aku nisiki elowa jiki sa-liki lae: We napatelika emo akalo maya oloha lahelamabosikiya eli limikiki oli ikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Liki layoko Jisesimamo sa-loko lo biye: Olohama okulumauti go panakidana lemeko neyoko mudaoe. ");
INSERT INTO yby_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Edimoya elilo. Nemokaho elewoleyama libekoyoko utihaloki ito okohimi oletehaloki monitadawoya ito Olohamidana elewolelalo mi jitataboya yalimo yatokaya ma kohaidamekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sa-oneboya olohasi edimo gatipo elikaka niabokumuya elideko yowamideko edimoya Omaimidana oluhola minabokumuye loko duliya okulumau je molonebokumugoya elowa jiki minalo. 19 Sam 91:13 ");
INSERT INTO yby_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Loko noliyoko ayaloya Omaimidana weuna oluholimo ukala le aila jiyoko, mulunau maya jo uluma noiyoko sa-loko liye: Ahonelika emoya yowa okulumaki ito ma mikaki ahonipo makoko minane. Sukulu lokoko ele wehe lokaka noune liki likaka niabo wewenasiya monoka elikiki eli wehe likatae loko molo halukokadanaki, sukulu lamiki oluho aidakidana minabo wewenasida dukauka molobetokaka noadawokumuya epoka lokaka noe. Ahonelika, sakogo soto pe-loko wetiye loko eledawoya wehe lone. ");
INSERT INTO yby_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Loko lokoko kolo meko akuya sa-loko liye: Ahonekaho muki nesa maya nadeu moloko suwokaiye. Wewena makolimo Omaimidana ipalada monawalaya elamiye. Ahonekaho eimolago elene. Ito ahoneda monawalaya wewena makomasi ma elamae. Neimone ipalakahogo ito lo soto moloko lo bekoyoko eli wehe liki elitae loko letubo wewenaki lelimotegoya ahote Omaimidana monawala ele-minune. ");
INSERT INTO yby_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Loko lokadanaki unala ipalale yuhama minabotoka mino wili jeko edimosidagoya sa-loko lo biye: Omailimo dilimekaiyoko domudalotiya saina muda wehe likae. ");
INSERT INTO yby_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ga mako lo libekoloyo, elilo. Hapa yeikalaya Omaimidana epalauti ga likaka weki duliki we napaki saina-painahena oko moloko nobo nesaya edimosi mudaikaka niabolawaya mudatune liki likaka aboya, mudamaboma ne. Ito edimo nepauti ga maya elikaka niabomidana eletune liki likaka aboya elamaboma ne. 22 Jon 3:35; Jon 10:15 ");
INSERT INTO yby_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Loko lokaiyoko monoka monawa lainimi okaka we makolimo sinokoko Jisesidama mulunau heko sa-loko loka oetaiye: Monoka ujapa wene yamalae, nemoya nenaha okokoma elewole nepa mutiwa litubo ne. ");
INSERT INTO yby_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Loko libotoma Jisesimamo sa-loko onoto leko lo miye: Mosesekaho nenae loko lo hukolibetaiye. Emoya nenae loko lonebo gama lepeko elene. ");
INSERT INTO yby_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Loko lokaiyoko sa-loko lo miye: Emo muluka obohaka weukahena ito abuha-wowoka ga elekaka adawo nesahena mukiya We napaka Omailoka molo. Ito emokadamu elekaka noadawomidana iwekalesidamu asako elebetoko uka bo. ");
INSERT INTO yby_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Loko liyoko Jisesimamo sa-loko lo miye: Nemo noloboto maya wehe loko nolane. Ladawoto emesalo moloko sa-etadawoya elewole oko minakolane. ");
INSERT INTO yby_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Loko lokaiyoko aya welimo eimola monawalago le sawa jekolo Jisesidama sa-loko loka oetoko liye: Iwenele motakuse edimoya ekahilema minae. ");
INSERT INTO yby_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Loko lokaiyoko, Jisesimamo sa-loko lo miye: We makoya Jelusalemu numutokati hulikoko le Jeliko numutoka lemekolo nolimiyoko ukelelo wesi kohaiki upalalo nesahena ito uvaminalahena muki ukele likayoko helekolo anulo udone. ");
INSERT INTO yby_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sakoya udoneyoko Omailoka jokila he mekaka we mako aya anuloma niseko mudaibo maya helekolo udoneyoko asetoko anu apilaloka wiye. ");
INSERT INTO yby_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sa-okaiyoko monoka numuku ujapa we mako Liwaeda ouvamela makoya aya anuloma niseko mudaibo maya udoneyoko mudaikoko asetoko anu apilaloka wiye. ");
INSERT INTO yby_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Wokaiyoko Samaliya wewenaki ito Juda wewenaki ouna jiki minamaboma neboya Samaliya we makolimo aya anuloma niseko mudaibo maya kohabo we maya udoneyoko woko muda-elaibo maya muluna hukokaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","oladala ma uli jeko le lalo oetoko waeni no malasini maya hiletokoko wasa jetokadanaki ilime hosi jalamidana emesalaloma molokadanaki ilime-loko woko wenoka wewenasida numudanipouma yoweko nasahili oetaiye. ");
INSERT INTO yby_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Udikaidanaki goma lokaiyoko aya wema wekolo noidanaki wenoka wewenasida ujapa okaka wemidanaya ehada kina lowema meko sa-loko lo miye: Maya wemidana ujapa lalo nesa oeto. Sa-noideko ehada emobolawama su-noidekoya nemokaho aku niseko imituwe loko liye. ");
INSERT INTO yby_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yauya emoya nenae loko nolane. We loweki makoki nisebokutiya ukelelo wesi kohaiki hulikayoko anulo udonebo wemidana wewenalaya ekahi maya ne. ");
INSERT INTO yby_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Loko lokaiyoko monoka monawa lainimi okaka wemamoya sa-loko lo miye: Miluma eletokadanaki ilime lalo ibo weyae. Loko lokaiyoko Jisesimamo emoyaki woko asaoko sao loko lo miye. 25 Mat 22:35-40; Mak 12:28-34 27 Dut 6:5; Liv 19:18 28 Liv 18:5 ");
INSERT INTO yby_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sakoya lomikaiyoko anu moliki wiki numuda makomalo hetae. Aya numuto mena mako neboya ulila Matao loko nebo menalimoya Jisesidama ilime numudalau molokaiyoko ");
INSERT INTO yby_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","unala Melemamoya niseko We napamidana iguka maya minoko galama eleko ne. ");
INSERT INTO yby_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sa-iboya Mata maya nodenesa le lolowa etibo nesamugoya ata kene. Sa-okaiyoko nenako Matamamoya woko Jisesidama sa-loko lo miye: We napane yamalae, unane Melekaho yataya hulonimikaiyoko nenimogo nodenesa le lolowa noboya mudamape. Sa-noyo oli hideko niseko nemoda nilimideko magoina yowanu lesiye. ");
INSERT INTO yby_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Loko lokaiyoko Jisesimamo sa-loko lo miye: Mata yamalae, emoya aito aito nesalogoya ata nokeniyoko elokaiye. ");
INSERT INTO yby_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sa-okadawoya emoya saina makokomugo ata elo. Unaka Mele maya saina lalomugo elidanaki nemotokati elewoleyama lekaiye. Sa-noinako yamoya emotokati ihilawa jitibo nenako wewena makolimoya adeuti hipo amekolaiye loko liye. 38 Jon 11:1 ");
INSERT INTO yby_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yu makoya Jisesimamo eba makomalo minoko Omailoka epoka loko suwokaiyoko unala ipalale yuhauti makolimoya sa-loko lo miye: We napate yamalae, Jonikaho unala ipalale yuhasida Omailoka litae loko lainimi obetokaka ibo nesa leko lainimi oletowo. ");
INSERT INTO yby_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Loko liyoko Jisesimamo Omailoka ni-liki maya sa-liki lilo loko lo biye: Ahotelika ulikaya eto oko minadeyo. Muki numuto namato ujapa oletokaka elewoleya soto pe suwideyo. ");
INSERT INTO yby_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Muki yulaka nodenesateya le lemo. ");
INSERT INTO yby_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Lemoya iwetelesida lihimanipo le hulobetokaka noudawomidana lemo lihimateya le-minadawo maya le huloleto. Lemo muluteu hitibo nesau lilime molamo. ");
INSERT INTO yby_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Loko lokoko sa-loko lo biye: Edimokutiya we makolimo lubuka udi helebolawaya woko welada numudalauya sa-loko ju letiye: Wene emoya beleti loweki makoki nemo. ");
INSERT INTO yby_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Olotiya wewena mako nemo numudaneu nisiboya nodenesaya mitubo minamiyoko emoda loka noe. ");
INSERT INTO yby_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Loko lideko welamamo numukutima sa-loko lo mitibo ne: Anu vokoko menakipa oluhonekiya udominudawoku nena osele gama niseko nolane. Nemo sinokoko nodenesa emamekoloe. ");
INSERT INTO yby_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Loko letiboya nemo sa-loko lo noliboe. Wewena mako nemo wenema ne lokoko udonetibokutiya sinokoko nodenesa mametiboya welakahoya ju lowa lowa ideko sinokoko ohu nojibo nesaya mekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Sa-itabo nesamuya sa-loko lo noliboe: Omailoka wako likaka niabo wewenasiya sainahena likaka niae. Ito ohu jikaka niabo wewenasiya saina ihilawa li soto molikaka niae. Ito ateto esopa jikaka niayoko ateda siyebetokaka noiye. Sa-noinako edimosiya Omailoka litaboya aya nesaya likilae. Ito ohu jitaboya saina ihilawa li soto molakilae. Ito ateto esopa jitaboya anu siyelibetakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Edimokutiya we makomidana ipalakaho lahawamu wako letiboya aholakahoya oleteha mitibo nehe. ");
INSERT INTO yby_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ito okole omudalamu wako letiboya ehada omudala mitibo nehe. Samekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yamuya muki lahelamabo wewenalikaya oluhotipolesida nodenesa lalo biki ujapa lalo ibitikaka nianako, okulumau ahotipoloka wako litabo wewenalikaya aseko yoweko nebo nesa weuna oluho maya libekolaiye loko liye. ");
INSERT INTO yby_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yu makoya Olohamidana weuna oluho makolimo we makomidana epala heko lagoli okaiyoko nebo wemidanaya Jisesimamo aya olohama kohako oli hiyoko wokaiyoko, epala lagoli ibo we maya epala ka oko gahenama liye. Sa-iyoko muki wewenasi epoka laboya, ");
INSERT INTO yby_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","maloka wewenasiya sa-liki lae: Olohamidana uliki wenipo ulila Belejepuloe loko nebo welimo ilime wati noiyoko Olohamidana weuna oluhosida maya wewenasida dukauti kohaidoko doli hekaka noiye liki lae. ");
INSERT INTO yby_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Liki layoko malokasiya mulunau hiki sa-liki lae: Okulumauti oliwaki nesa elewoleya mako le soto moladeko monawaka mudatune liki loka itae. ");
INSERT INTO yby_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Liki data elebolawa maya Jisesikaho muda hokolotonedanaki sa-loko lo biye: Mika makokoloti wewenasiya mini maloka maloka ikiki lowa hitaboya, aya mika maya ametetibo ne, ito numuda makokou minatabo wewenasiya dokepalo dokepalo itaboya aya numudaya hulikiki hutili iki witabo ne. ");
INSERT INTO yby_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Edimosiya nemodamuya Olohamidana elewoleyalaloti olohasidama kohaidoko wewenasida dukauti doli hekaka noiye liki likaka niaboya, Olohalimoya eimola weuna oluhoki lowa hikiki dokepalo dokepalo itaboya nena nena okoma Olohalimo ujapa okaka noibo yowanulaya woko elewole etibo ne. ");
INSERT INTO yby_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nemokumu Pelejepuloda elewolelaloti olohasida kohaidoko doli hekaka noiye liki likaka niae. Sa-likaka niaboya edimo oluhotipolesiya ekahida elewolelaloti olohasida kohaidiki doli hikaka niae. Olohamidana elewolelalotima kohaidiki doli hamikaka nianako, edimotipoya suwa liki nemo muluneu hiki nilabomidana monawaya aha li soto molilibitataboma ne. ");
INSERT INTO yby_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sa-oneboya nemoya Omaimidana elewolelalotiya olohasida kohaidoko doli hekaka nonako, Omailimo uliki wetipo lolo etibomidana elewoleya niseko domudaloka alili ibomidana monawa maya aloya soto pekaiye. ");
INSERT INTO yby_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Olohaya elewoleyalaki leko ile imi oko numudala ujapa etiboya, aha minoko muki nesalaya aha netibo ne. ");
INSERT INTO yby_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sa-etiboya, nemokaho abuha-wowo elewoleyaloti Olohamidanaya lowa he meko asetatuboya ile imi elewole etibo nesalaya ujapa okaka ibo nesalaya hipo okoko neimone wewenanelesida ona moloko bitubo ne, loko libo maya emoya Olohamidana adelo nala jekoko weuna oluhosida maya kohaidoko doli hekaka ibomidana monawamu lo biye. Sa-loko lokadanaki mako sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ito we mako nemokuti minametibo weya nemo ulanelo we minakolaiye. Wewena makosi nilimi wati amiki ito wewena malokasida nemotoka dilipi nupa amitabo wewenasi dilipi hutili ikaka niabo elekaiye. 15 Mat 9:34; 10:25 16 Mat 12:38; Mat 16:1 23 Mak 9:40 ");
INSERT INTO yby_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Olohamidana weuna oluho makolimoya we makomidana ukauti yowekoko aso jeleko netibo ebamuya ametoka moneko ohu jitiye. Ohu je-loko nowoko nemo numudane hulikoko nisoboma nenako, lokoko moneko ohu jitiboya minamideko aku ayauya yoweko minatuwe loko ata ketiboma ne. ");
INSERT INTO yby_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Loko lokoko woko mudatibo maya aya numudala maya ohu liki li dowa li-minadeko mudakoko ");
INSERT INTO yby_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","woko iwelale 7-palasida dupaloti sihana nuvama wibolaya dilipe-loko nisideko aku ayauma yowiki minatabo ne. Sa-ideko omutoko aya we maya aha suwa nesa leko lahelamiboma neboya, alikaya lina adoha nesa litibo ne. Sa-etibo nenako, aya nesaya edimotoka soto pitibomuya noloyo, ehetipoe. ");
INSERT INTO yby_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Loko liyoko muki wewenama li esa iki minabokutima mena makolimo Jisesidama ju lo meko sa-loko lo miye: Mena makolimo emoda etokoko amida emenebo menaya Omailimo maku menebo mena ne. ");
INSERT INTO yby_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Loko lokaiyoko Jisesimamoya sa-loko liye: Sa-loko ladawoya Omailimo liboto eliki Omaimidana galaloya emesalo molikaka niabo wewenasida wehe loko maku benebo wewena minae. ");
INSERT INTO yby_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Loko lokoko muki wewenama wowotiki li esa niayoko Jisesimamo kolo meko sa-loko lo biye: Oloti onawalo minabo wewenaya lahelamabo wewena minikae. Oliwaki elewole nesa mako mudatune liki likaka niaboya, aitomidana elewole ane mako le soto moloyoko mudamikilae. ");
INSERT INTO yby_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona maya lahawamidana ohumanau lemeko loweki makoki yupeka le hulikoko helekolo noibokutima aku Ninive wewenasida dowisalo niseko aya ga wetome oko lo bibomidana asako nemo okulumauti we uti maya oliwaki adoha nesa elewoleya le soto molakoloe. ");
INSERT INTO yby_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Omailimo ona mololibetatibo onawalo maya Siba mikauka uliki mena maya sinokoko oloti maya onawalo minabo wewenasida lihimanipomu obi obetadeko lihimanipo napa litabo ne. Aya menalimoya Solomonima madonau golotiyoko muki nesa monawanipo ele wehe loko elibomidana monawaya elekolo hana-pana anuya nisibo ne. Sa-oneboya nemoya Solomonidaya asetoko minoboya edimosi nemo ane elamaboma ne. ");
INSERT INTO yby_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ito Omailimo ona mololibetatibo onawaloya Ninive wewenaya siniki oloti onawalo minabo wewenasida lihimanipomuya obi ilibitakilae. Sako ona molobetatiboya lihima litabotogoya ne. Ahamu yatoka samikilae. Jonakahoya monoka lo nobiyoko Ninive wewenasiya lahelamibo nesanipoya demesa mikiki mulunipo obohanipo Omaimitoka mebo ne. Sa-iboya nemoya Jonakidana sako minamoe. Jonada asetoko minoboya edimosi nemo aneya eli hulikiki duka li wili jamae. 29 Mat 16:4; Mak 8:12 30 Jon 3:4 31 1 Kin 10:1-10 2 Klo 9:1-12 32 Jona 3:5 ");
INSERT INTO yby_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nakaha welimo leya lepa okoko sipa anugu molatibo ne, ito somodunu auvene vetibo ne. Sakoya minamiye. Leya lepa okoko numuku yowitabo wewenasida lameda lobetatiye loko le namabetalo molatibo ne. ");
INSERT INTO yby_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ito omudakaya upakamidana lelaya ne. Omudakalimo umu helekaka anuloya ilime molametiboya Omaimidana lelamo ukauka he hada etibo ne. Ito omudakalimo ilime lahelamibo lolo etiboya, upakaloka ito ukaukaya lubu je-minakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sa-oneyoko ukaukaya Omaimidana lela maya hekadeko lubu jitiboku minokataniyo, ujapa lalo nesa o. ");
INSERT INTO yby_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ukauya lubu jamoko lameda lo su-noidekoma lameda loetaibomidana oko lameda lokogo minakolaiye. 33 Mak 4:21; Luk 8:16 ");
INSERT INTO yby_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisesimamo sa-loko lo nosuwiyoko Palasisi we makolimo nodenesa natane loko loetaiye. Loko lokaiyoko Jisesimaki numukuma yowiki nodenesa maya niki minaiye. ");
INSERT INTO yby_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sa-niaiyoko aya Palasisi wemamo Jisesidama muda-elaibo maya adela maya nokalawe amoko aha nodenesama leko nonaiyoko Palasisi wemamo etamibo nesa noliye loko ata etipa kekoko gima gima oko ne. ");
INSERT INTO yby_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Sa-noiyoko We napamamo sa-loko lo miye: Mudao. Edimo Palasisi wewenalitaya somohena lapehena suda likiya minae. Edimoya no odahena ito somo lapehenaya nokalawe iki nikaka niaboya dukauya ukele nesalimo waitoko ne. ");
INSERT INTO yby_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Omailimoya muki nesa ulauka ito hekaloka makoko aweyaha oko lolo oneboya edimoya nei wewena minae. ");
INSERT INTO yby_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sakiya dukauti wewenasida nasahili ibitataboya dukauya lameda lokogo minakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Edimo Palasisi wewenalitaya ehetipoe. Edimo mijatipouti nuvala lalo wokaka noibomidana oinahenaya ito maloka nesahena 10 10 oko netibokuti Omaimidana makoko makoko mikaka niaboya, edimoya wehe liki miniki wewena le wehe loko makoko aweyaha oko ona molokaka nesa ito dukauya Omaimidana mikaka nesa hulikae. Edimoya saina 10 10 oko netibokuti Omaimidana mikaka nesaya hulamiki saina napa malokakiya aha lolo okakawaya ne. ");
INSERT INTO yby_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Sa-oneyo edimo Palasisi wewenalitaya ehetipoe. Edimoya monoka numuku numukuya muki wewenasida dowisalo minokaka siyaloya minatune liki elikaka niae. Ito maketiloka muki li esa abo wewenasiya lepoka litae likigo elikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ehetipoe. Edimoya ono molikaka ebakidana minae. Ayalo wewenasiya nimoniki dukauya alo nuvama wone liki elamae. ");
INSERT INTO yby_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisesi maya sa-loko lokaiyoko monoka monawa lainimi okaka we napa makolimo sa-loko lo miye: Monoka ujapalo wene yamalae, emoya sa-loko noladanaki lemoda maya auhate lemekaka noane. ");
INSERT INTO yby_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Loko liyoko Jisesimamo sa-loko lo miye: Edimo monoka monawa lainimi ibitikaka we edimokiya ehetipoe. Edimosi Mosesekaho lo molaibo galimoya edawaki nesa lolo iyoko muki wewenasida ohibitayoko osele nesa liki ohikaka niaboya aya edawaki nesaya edimotipo dadeloti ma dilimiki lamae. ");
INSERT INTO yby_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Sa-ikaka niayo edimoya ehe. Latatipolesiya Omaimidana epalauti ga likaka wesida kohaidiki ale lijebo wewesida ono molikaka ebamidanaya onowe lalo nesanipoya li kolibitikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sa-niayoko latatipolesi iki moliki ikaka niabomidana edimokiya makoko aweyaha iki sa-ikaka niayoko monawatipoya soto pekaka noiye. Latatipolesiya Omaimidana epalauti ga likaka wewenasida kohaidiki ale lijikayoko edimokidana minadanaki onowa molikaka numudanipo lalo lolo ikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yamuya Omai ele wehe lokaka nesamuya sa-loko loneboma ne: Omaimidana epalauti ga likaka weki ito monokalo wekiya doli hekadeko wiki minadeko malokasida ulana molibitiki ito malokasidama kohaidi helitabo ne loko loneboma ne. ");
INSERT INTO yby_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sa-nideko mikaya eda okoko mino-loko noyowiyoko Omaimidana epalauti ga likaka wewenasida kohaidabo oladawanida kisebo lihimawaya oloti maya minabo wewenasida dupaloya kise suwibo ne. ");
INSERT INTO yby_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Sa-onenako nemoya wehe loko lo libituyo, eli-minalo. Aibolodaya yatolakaho kohaiyoko heleko olodala kisibo onawalotiya maloka wewenasida kohaidi-liki niwayoko oladanipo kisiyoko Jekolaiyaya Omaimidana jokila hi mikaka sipaloki ito eto onebo numudakiya luwatoya neyoko nikohayoko oladala kisibomidana lihimawaya oloti onawalo minabo wewenasida mupilatipoloya yowekaiye. ");
INSERT INTO yby_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Edimo monoka monawa lainimi ikaka welitaya ehetipoe. Edimoya ga eli wehe likaka atetoti kiwa maya liki wikae. Edimotipo ayauya yowamiki aito wewena yowikilayoko atetoya hiki li likaka niae. ");
INSERT INTO yby_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Loko lokoko numukutima nolimiyoko monoka monawa lainimi ikaka weki ito Palasisi wewenakiya galotiya lowa hi mikili loka loka itae. ");
INSERT INTO yby_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Sakoya loka oetuniyoko Jisesima opa ga mako lideko obi yowanu letatune liki loka itikiki epau awa hi-minae. 42 Liv 27:30 51 Jen 4:8; 2 Klo 24:20-21 ");
INSERT INTO yby_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sa-noiyoko muki wewenama nisiki dupalo dupalo iki li esa iki minayoko, Jisesimamo unala ipalale yuhasida maya sa-loko lo biye: Palasisi wewenasiya suwalo wewenasi iki moliki ikaka abo nesa liki iki moliki ikaka niaboya lahelamibo nesa likaka niae. Edimoya yamidana sa-ikatayo, ujapa ilo. ");
INSERT INTO yby_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Halukonetibo nesahena mukiya alikaya soto pitibotogo ne. Ito sunauka lolo i-minabo nesahena soto pe suwokadeko muki wewenasiya muda-elikilae. ");
INSERT INTO yby_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sa-nideko lubukaya haluki-minatabo aya lameda lo suwideko muki wewenasiya elikilae. Ito numudanipou miniki musika liki labo aya hetokaya ga napauti lideko muki wewenasiya elikilae. 1 Mat 16:6; Mak 8:15; 2 Mak 4:22; Luk 8:17 ");
INSERT INTO yby_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nemo iwenele motase lo libekoloyo, eli-minalo. Maloka wewenasiya dupago kohaidi helikilae. Alikaya saina mako lolo ilibitatabo nesaya minaminako, sa-itabo wewenamuya domoda wamideyo. ");
INSERT INTO yby_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sa-oneboya domoda wetibo we mako dilipituyo. Omailimo lupateya koha helekoko jo ebakuya lipiso hulatibo elewolewaya lene. Nemokahoya wehe loko lo noliboyo, elilo, emokumu domodatipo wideyo. ");
INSERT INTO yby_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nama somoya aha nesa nenako laho ehadalotiya aya namaya aha meina hitabo nesa lene. Sa-oneboya Omaimoya nama somo makokomuya ata molamiye. ");
INSERT INTO yby_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ito madotipo yopala lepikaka nesaya Omailimogoya elene. Edimoya nama somokidana minamae. Edimoya wewenae liki nesama minanako, Omailimoya ujapa olibetokaka noinako, saina makomu domoda wamideyo. ");
INSERT INTO yby_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nemokaho lo libituyo, elilo. Wewenasi domudaloya nemo nuliya li soto moliki li napa itabo wewenaya nemo okulumauti we uti asako Omaimidana okananipoki wesida dowisalo dilipe napa oko duli le sawa jekoloe. ");
INSERT INTO yby_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wewena makomalikaya wewenasida dowisalo nemodamu jewo hitowo etadawoya asako Omaimidana okanaki welalesitoya jewo hitowo ekoloe. ");
INSERT INTO yby_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ito okulumauti we uti nemokumuya liwi letiwi itaboya Omaimoya aya lihimaya aha le hulobetatibo anuwa neboya, Omaimidana weuna oluholamu liwi letiwi itataboya Omailimo yamidana lihimawaya le hulametibo nesa ne. ");
INSERT INTO yby_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ito monoka numudatipou ujapa wemidana owisalo obi nilibitadekoma yalo maya nenae loko letune liki data etipa kamilo. ");
INSERT INTO yby_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ayahasiloya edimo litabo aya Omaimidana weuna oluholimo lo libe libe ideko litabo neyo. Sa-etibo neyo, data etipa kamilo. 10 Mat 12:32; Mak 3:29 11 Mat 10:19-20; Mak 13:11; Luk 21:14-15 ");
INSERT INTO yby_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Loko lokaiyoko li esa iki minabo wewenautima we makolimo Jisesidama sa-loko lo miye: Monoka ujapalo wene yamalae, emoya yaneda lo mekadeko ahotekaho mololetatibo uvaminaya ona moloko maloka nimitihao. ");
INSERT INTO yby_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Loko liyoko Jisesimamo sa-loko lo miye: We mageyo, uvamina ona mololetoko ito obi yowanu lelibetatane loko ekahimamo nilime eto okaiyoko nolane. ");
INSERT INTO yby_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Loko lokoko wewenasida sa-loko lo biye: Lupamidana uvaminala waitoko netibolimo lukamidana uvaminala le soto molametibo nenako, edimoya mudai dumu helikaka nesamuya ehetipoe. ");
INSERT INTO yby_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Loko lokoko koha moloko ga mako sa-loko lo biye: Ehada uvaminala wavu-leko netibo welimoya mikauka nodenesa wavu-leko le soto molaiye. ");
INSERT INTO yby_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Le soto molokoko mulunauya sa-loko eliye: Nodenesa le molokaka numuku nodenesaya waitonenako, maloka nodenesaya nenaha etuwe. ");
INSERT INTO yby_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Loko lokoko sa-loko eliye: Nodenesa le molokaka numudaya lukoko le napa-napa oko vetuyo lokoya eliye. Sakoko nodenesaneki ito maloka nesanekiya le aya numukugoya molatuyo. ");
INSERT INTO yby_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Le molokoko neimoneya sa-loko letuyo: Nemo nodenesaneya waitoko minokainako owahaya suwamideko meleke wavu-leko wekolaiye. Yamuya ake jeko nodenesa lalohenaya noko aso jeleko minakoloe. ");
INSERT INTO yby_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Loko liyoko Omailimo sa-loko lo miye: Emoya nei we minadanako oloti lubukaya emo weuka oluhoya lekoyoko helekolane. Sa-okadeko nodenesa uvamina le moladawoya emoka nesaka netihe ito wewenasi nesa elitiye. ");
INSERT INTO yby_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Loko lo mitibo nenako, sainapainalahena waitoko netibo we mako Omaimidana omudaloya sainala minametibo we netiboya, ayamidana nesaya emotokaya soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Loko lokoko unala ipalale yuhasidama sa-loko lo biye: Sa-noiyoko sa-loko lo noliboe: Edimoya miniki liki itaboya nodenesa nakahaukati natupe ito lupalo nesaya nakahaukati le kolatupe liki data etipa kamilo. ");
INSERT INTO yby_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nodenesaya saina lalo minamiye. Edimo miniki liki itabo nesaya saina lalo ne. Ito lupalo nesaya saina lalo minamiye, aha lupateya saina lalo ne. ");
INSERT INTO yby_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ahanamamuya data eliki eli wehe lilo. Aha-namasiya nodenesa ma yuha amae, ito nodenesa o molaiyokoma ma liki wiki numudanipouka li nupa iki namae. Ito nodenesa li molatabo numudaya vamaboya Omailimogo nodenesanipoya bekaka noiye. Sa-okaka noinako edimoya nama minamae. Wewena ma minanako, nama mukiya limiki minayoko edimoya yowiki minanako Omailimoya sainahenatipoya aha le soto mololibetatibo ne. ");
INSERT INTO yby_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Edimokuti we mako ata etipa keko minoko sako etiboloti emolakaho meleke makoki kolo meko minoko sako etibo nehe, sako ma minamiye. ");
INSERT INTO yby_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yaya lasolasi nesa neboya, edimosiya aya nesaya lamabo nenako, saina mako nenahamu data etipa nike. ");
INSERT INTO yby_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Edimoya sainahena uvawa oko minokaka noibo nesamidana monawaya ma eli wehe lamahe. Yotoka nesaya yowanu mako lamae. Ito lalo nesa mako oto iki li kolatabokumu data kamae. Sa-oneboya ga mako lo libituyo, eli-minalo. Hapa yeikalaya uliki onowelaki we Solomonikahoya onowela lalo le kolokaka oneboya, yaukati uvawaki nesalimo Solomonida upalo nesamidanaya asetoko ne. ");
INSERT INTO yby_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ya nalauka nesaya olotiya uvawa okoko minoko hoya loko alala mekaiyoko hukiki jo jikaka niae. Sa-niaboya ya nalauka nesahenaya Omailimo liboto onowenipo li kolikaka nianako, edimo asolasi eli elewole iki eli-minabo wewenalitaya dupalo nesahenaya Omailimo aha le soto mololibetakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Edimoya nena nesama natudawo ne liki data etipa kamilo. ");
INSERT INTO yby_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Muki numuto namato wewena monokanipo minamibo wewenasiya aya nesamuya ohu adoha jikaka niae. Sa-niaboya ahotipokaho aya nesaya edimotoka minametiboya dupaya dowa lametibo ne loko elene. ");
INSERT INTO yby_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Edimoya aya nesamu nehekala Omaimidana oholamu duka data omutiki ki moladeko minadeyo. Sa-itaboya dupamidana nesalaya aha nesakidana libekolaiye. 27 1 Kin 10:4-7; 2 Klo 9:3-6 ");
INSERT INTO yby_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Edimo maloka wewena sipisipi jakidana nupa i-minabolawalitaya domoda wamideyo. Ahotipokaho eimola oholamidana elewole uvamina le libekolo elowa nojiye. ");
INSERT INTO yby_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yamuya uvaminatipo salimi ikiki meinawa likiki uvaminanipo minamibo wewenasida yaitaya bilo. Sa-ikiki ehadatipo owo jikaka owo hulupa jametibomidanaya li uka jilo. Sa-iki okulumauka suwametibo uvamina li nupa itabotoya, ukelelo wewena monamikilae, ito unakodalimo hukametibo ne. ");
INSERT INTO yby_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ito uvaminatipo lalo netibotokaya data ki moladeko minatibo ne. ");
INSERT INTO yby_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Edimoya lawolawotipoya li kolikiki ohatipolo ebetipoya li etoha iki jikiki leya liji molikiki minalo. ");
INSERT INTO yby_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ujapa we makoya menala ada abo onawaloya aku le wili jeko numutoka nisitibokumu ewa iki miniki anulo maya niseko hoko-hoko lidekoma enemane iki anu siyetatune liki ewa iki minabo neyo, edimoya asaiki ewa iki minalo. ");
INSERT INTO yby_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ujapa welimo niseko elekele oluholalesida udamiki siniki minikadeko mudaidatiboya, elowa jikilae. Sa-oneboya nemokaho ga mako wehe loko lo libekoloyo, elilo. Ujapa wenipokaho yowanulo nesama li olo jikiki nisiki miniki nodenesatipo nalo, loko lokoko eimolaya nodenesa wataina oko ona moloko bekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aya weya lubuka udo wili jeko nisitihe ito okululuwa hokibolawaya niseko mudatiboya elekele oluholama aha ewa iki minadeko mudaidatiboya elowa jiki minakilae. ");
INSERT INTO yby_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Sa-oneboya, edimoya elilo. Yaya numuda aholalimo ukelelo we nisitibo onawaya eletidanako, ukelelo weloe loko ujapa onetibo nenako ukelelo weya niseko numudala jeko pasokoko uvaminala lametibo ne. ");
INSERT INTO yby_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yamidana sako okulumauti we uti nemodaya newa iki minamitabo yulaka nisekoloyo, li lolowa ikigo minalo. 35 Mat 25:1-13 36 Mak 13:33-36 39-40 Mat 24:43-44 ");
INSERT INTO yby_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Loko lokaiyoko Pitamamo sa-loko liye: We napatelika koha moloko noladawo aya lemodamugoya nolape ito muki wewenamu usi gaya nolane. ");
INSERT INTO yby_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Loko lokaiyoko We napamamo sa-loko lo miye: Elekele oluho makolimo ele wehe loko elenetibo ito yowanu le emesalo moloko litibo weya, ujapa welalimo emola numudalauya ujapa oko minoko yowanulo we malokasidama ujapa oko netiye loko ujapa we lolo oetokadeko nodenesa natabo onawalo maya ona moloko bitibo wemidana monawalamuya lo libituyo. ");
INSERT INTO yby_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yowanulalo ujapa wela maya nisekoko omutoko libotoma emesalo moloko nolideko mudakoko aya yowanulo welamuya elideko lahelepa etibo ne. ");
INSERT INTO yby_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sa-onenako nemoya wehe loko lo libituyo, elilo: Ujapa welamoya sako ujapa lalo ibo wemidanaya muki nesalo ujapa we lolo oetakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sa-etiboya aya yowanulo welimoya nemo ujapa wenema onawa hana minokainako enemane oko nisamekolaiye loko elekoko yowanulo wehe menahe kohaidokaka noko nodenesa ataina oko noko minoko biya no noko nei moloko netiboya, ");
INSERT INTO yby_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","aya yowanulo wemidana ujapa welama nisekoko ujapa welamu ewa oko minametibo onawalo ito elametibo onawaloya niseko upalahena kohako huko nako oko oli he huladeko yowanumu elewole iki data elamitabolawa minatabokuya woko magoina minakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yowanulo we makolimo ujapa welamidana epalauti aya elekoko le lolowa oko minamoko ujapa welamo letibotoya emeke molamideko maya ujapa welalimoya wavu-leko nokohadeko obi yowanu napa litibo ne. ");
INSERT INTO yby_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sa-etiboya yowanulo we makolimo ujapa welamidana epalauti ga mako elamoko obi oetatibo nesa lolo idekoma ujapa welalimo moletokogo kohakolaiye. Omailokati uvamina wavu-liki li-minatabo wewenaya Omailimo aku li welepa jiki nimilo loko letibo nenako, akuya mikilae. Ito Omailimo we makomidana saina waitoko molatiboya Omailimoya oha obe-loko nemo loko lekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nemo ma mikauya jo dupalo jituwe loko lemoboma ne. Ito muki wewenasida lahelamibo nesanipo jo jituwe loko olotiya letidanako dowa lokoe loko letine. ");
INSERT INTO yby_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nemodaya miluma nesa napa makoya li ohinitakilae. Muluneu okohu iyoko mino-loko woko minoyoko alikaya suwonetatibo ne. ");
INSERT INTO yby_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Edimosi nemokumuya ma mikauya hulu nesa le soto molatuwe loko lemene liki nilahe. Yaloya lemamoe. Nemoya luwaku potiki li maloka maloka iki ona molikaka nesa le soto molatuwe loko lemoboma ne. ");
INSERT INTO yby_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Oloti onawaloti asolasima mino-loko yoweko numuda makokouya wewena 5-pala minataboya, nemo monokanemuye likiki sa-oneboma ne sa-oneboma ne liki makomidanahe ito lowesidamuhe lowa moila hiki ulanipolo we lolo iki dokepalo dokepalo iki monikilae. ");
INSERT INTO yby_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sakikiya sa-iki luwakuya potikilae. Aholako ito ipalako mini maloka maloka iki luwaku potikilaiye. Ito dolako oluwakosiya asaikilaiye. Ito omebalako omebalakosiya asaiki sa-ikilaiye. 50 Mak 10:38 53 Mae 7:6 ");
INSERT INTO yby_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisesimamo sa-loko lokoko li esa abo wewenasidama sa-loko lo biye: Edimoya limu mako ho omudalo nohitaiyoko mudaikiki maya goma jekolaiye liki likaka niae. Sa-liki laboto hekaka noibo maya ne. ");
INSERT INTO yby_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ito okuluma lubuhago le esa noiyokoma howai onawa nenako otaga lekolaiye liki likaka niaboto hekaka noibo nesama ne. ");
INSERT INTO yby_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sa-likaka niaboya edimo suwalo wewenalita ma mikaki ito okulumaki monawanipo ona molikaka niaboya, oloti maya nemokaho oko moloko okaka nobomidana monawaya nenahamuya eli wehe lamae. ");
INSERT INTO yby_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ito sabo weutipolotiya maya monawaya wehe lonetiboya nenahamu ona molamae. ");
INSERT INTO yby_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sa-itaboya we makolimo obi yowanu legetakolo ilime-loko obi numuto obi napa le helekaka welo ilime-loko nowideko anulokaya magoina niwiki ukalauka lalo etiye loko sainahenama mo. Samoko aya nesamaki le-loko aya obi le helekaka we netiboto wisaiboya obi elekaka welimoya imi wesida lideko imi wesi ilimi-liki wiki nala numuku huligitikatae. ");
INSERT INTO yby_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sa-onenako nemoya wehe loko lo libituyo. Omaimidana nala numuda muliguya lihimaka napa lasola netiboya pasoko suwametadawoya, ayauya huloetokadeko mino-loko woko minakolane. ");
INSERT INTO yby_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aya onawalo ayalo minabo wewena malokasiya Galeli wewenasida ganipo Jisesidama sa-liki li me: Edimoya Omaimidana uda ji meyoko Paelatimamo nokohaidadanaki Omaimidana uda ji mebo nesamidana oladalaki ito aya wewenasida oladanipoki le opa napa iye. ");
INSERT INTO yby_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Liki li mikayoko edimo laboto sa-loko donoto leko lo biye: Muki Galeli wewenasikuti sa-iki helebo wewenasida lihimanipo napa-napa neyoko weunipo wamibo anu wikae liki nielehe. ");
INSERT INTO yby_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Sako minamiye loko lo noliboe. Edimosiya sa-iki duka li wili jamitaboya edimoki sa-ikigo wiki opa ikilae. ");
INSERT INTO yby_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ito Siloamu numutokaya numuda hana hana makoya lemeko udoko wewena 18 kohaido heliboya Jelusalemu ebaku nebo wewenauti asaiki helebo wewenasida lihimanipo napa nebo wewenae liki nilahe. ");
INSERT INTO yby_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Sako minamiye loko lo noliboe. Edimokiya asaikiya duka li wili jamitaboya edimoki asaikigo wi opa ikilae. ");
INSERT INTO yby_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Loko lokoko Omaimo Juda wewenamu osele elaibomu koha moloko ga mako sa-loko liye: We makoya ohuda ya sigolo yuha okoko alikaya niseko ihilawamu ohu jiye. Niseko mudaibo maya aya ya maya ihilawa jamiyoko aya mijalau yowanu lekaka wemidana sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Meleke loweki makoki maya wokaiyoko maya yamidana ihilawa maya liyekolo nisobo maya gaya yamaya ihilawa jamiye. Mika nouvala ahamu nokatiyo, kohako le huliko. ");
INSERT INTO yby_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Loko lokaiyoko mijalau ujapa welamamo sa-loko lo miye: Ujapa wenelika, oloti melekeuya moneko monaukaya ohu leko le wati okoko bulumaka jasida esenipo maya heko leko niseko molatuwe. ");
INSERT INTO yby_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sa-okoyoko alika melekeloya ihiwala jitiboya dowa lokoe. Ito ihilawa jamidekoma kohako le hulo loko lideko kohako le hulatuboya, wati okoe loko liye loko Jisesimamo liye. ");
INSERT INTO yby_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Holi onawa makomauya Jisesimamo monoka numuku ga maya lainimi obetaiye. ");
INSERT INTO yby_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sa-noiyoko mena mako nebotoya Olohamidana weuna oluho makolimo ukauya yowekaiyoko meleke 18-pala saina napa-napa nesa jeleko minokaka iye. Sa-okaiyoko aya mena sino wehe loko netibo nesa lamoko abuhala minamiyoko nebo ne. ");
INSERT INTO yby_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sa-iyoko Jisesimamo sa-loko ju lo meko liye: Ma menalae elaibo nesaya aloya le haka loetokoe. ");
INSERT INTO yby_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Loko nolidanaki aya menamidana madonalo maya ade noleko le lalo noetaiyoko ayahasiloya maya menama sino wehe lokadanaki Omaimidana epoka liye. ");
INSERT INTO yby_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sa-iyoko monoka numudalo ujapa we napamo holi onawa napauya Jisesikaho maya menamidana ilime haka libokumu mulunauka lahelamibo elekoko ayalo minabo wewenasidama sa-loko lo biye: Yowanu lekaka onawa 6-pala nenako, saina lelaibo wewena lilime haka letiye likima holi onawau nisamiki yowanu onawaugoya nisilo. ");
INSERT INTO yby_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Loko liyoko we napamamoya sa-loko liye: Edimo suwalo we depa uluma lowe nebo wewenalitaya, holi onawauya bulumaka jatiposida numukuya wikiki no natae liki aha wina iki dilipi wikaka i-minaboma ne. ");
INSERT INTO yby_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yamidana maya nenako Juda mena maya Olohalimo ukauya ilime lahelamibo lolo okaiyoko meleke 18-pala le huloko neboya elaibo nesamidanaya holi onawau le huloetatuboya wehe lonehe wehe lamone. ");
INSERT INTO yby_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Loko noliyoko ulalalo we maya owanipo napa-napa hele. Sa-iyoko muki wewena maya oliwaki nesa lolo ibokumuya elowa adoha je. 14 Eks 20:9-10; Dut 5:13-14 ");
INSERT INTO yby_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ito Jisesimamo sa-loko lo biye: Omaimidana oholau wiki minatabo wewenaya nena nena ikima minae. Ya nesakidana iki minae loko nenahalo lo moloko letuwe. ");
INSERT INTO yby_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mastetiya ihilawamidana iki minae. Wewena makolimoya masteti ihilawaya asolasi neboya makokosi leko woko mijalau yuha iboya wileko yoweko napa okaiyoko namasiya nisiki akawaloya numuda vaboma ne. ");
INSERT INTO yby_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Loko lokoko akuya sa-loko liye: Omaimidana oholau wokaka nesamuya nenahalo lo moloko letuwe. ");
INSERT INTO yby_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Beleti lulu jekaka nesakidana ne. Mena makolimo beleti lulu jekaka nesaya palauwaki le opa napa okoko ataina okaka noiyoko beleti lulu jeko napa iye. ");
INSERT INTO yby_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisesimamo Jelusalemu numukuka wekolo noidanaki eba lasolauka ito napauka yoweko lemeko oko monekolo monoka monawahenama lainimi obetoikaka omo wiye. ");
INSERT INTO yby_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sa-noiyoko we makolimo sa-loko lo miye: We napane yamalae, Omailimo wewena amanamasi dilimitibo nehe. Loko lokaiyoko Jisesimamo sa-loko lo beko liye: ");
INSERT INTO yby_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ateda asolasiguya yowikilima abuhatipoukaya li elewole ikiki yowitae. Nemoya sa-loko lo noliboe: Muki wewenasiya yowetune liki litaboya yowamikilae. ");
INSERT INTO yby_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sa-nideko numuda aholalimoya anuya vobetokadeko atetoya sini-minikiya sa-liki atetoya hoko-hoko liki ju likilae: We napate yamalae, anuya siyeletowo. Liki lideko nemoya sa-loko lo libekoloe: Edimoya mudaidamobo wewena minayo, edimoya nakaha numutoti wewena minae. ");
INSERT INTO yby_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Loko lokoyoko sa-liki li nimikilae: Emoki magoina minudanaki magoina lemo numudateuti noko lemo numudateloya woko monoka monawaya lainimi oletoko lemo mudalelo-minadawoma ne. ");
INSERT INTO yby_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Liki li nimideko nemokaho sa-loko lo libituwe: Edimoya nakaha ebatoti wewena minae loko aloya lo libekoe. Edimoya lahelamibo nesalogo monikaka abo wewenalitaya nenahalo nise, alo wilo, loko lo libekoloe. ");
INSERT INTO yby_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Loko lokoyoko mudataboya Aebalahamule Aesikile Jekopule ito Omaimidana epalauti ga likaka wewenaya Omaimidana oholauya minadeko mudaidakilae. Sa-iki mudaikadeko edimodaya doli he hulikoyoko hetokaya miniki depa tala-mitala iki miluma eliki wije nama adoha liki minakilae. ");
INSERT INTO yby_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sa-nideko wewena ho yowibotokati ito ho limibotokati ito okana maloka malokati nisiki li esa iki Omaimidana oholau nodenesa niki elowa jiki minakilae. ");
INSERT INTO yby_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sa-oneyo, edimoya elilo. Oloti onawalo omutiki nisebo wewena malokasiya mini alika ikadeko, alika minabo wewena malokasiya mini omutikilae. 27 Sam 6:8 28-29 Mat 8:11-12; Mat 22:13; Mat 25:30 30 Mat 19:30; 20:16; Mak 10:31 ");
INSERT INTO yby_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aya onawaloma Palasisi wewena mako nisikiki Jisesidama sa-liki li me: Emoya maya ebaya hulikoko wo. Uliki we napa Helotimamo kohaelo helekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Liki likayoko emomamoya yowanu le-loko woko suwokoko alika helitibokumu ohuwa hukoko sa-loko lo biye: Edimoya wiki aya liwe ula weunaki wemidanaya sa-liki li midekoya elideyo: Olotiki aijokiya minoko olohalimo dukau yowibo wewenasida olohasida kohaidoko doli he huloko ito saina delaibo wewenasidaya dilipe haka lobetokokoya mino holi molatuwe. ");
INSERT INTO yby_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sa-oneboya aito ebatoka Omaimidana epalauti ga lokaka we mako kohaidi helitaboya etamiye. Jelusalemu numutokagoya sa-itae liki li-minabo maya nenako, olotiki aijoki okokiya nemo anunelokaya wekoloe. ");
INSERT INTO yby_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ke, Jelusalemu wewenalitaya, Omaimidana epalauti ga likaka wewenasida ito Omailimo edimotoka yowanulo doli hibo wewenasidaya ehadalotiya huli moliki kohaidi helikaka niae. Nemokaho edimodaya okolelimo oluholalesida le okanauka molaibokidana muki yupeka le muluneuka molakolo okaka noboya edimoya eli nemamae. ");
INSERT INTO yby_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sa-ikaka niayo, elilo. Omaimoya dilipe hulikadeko ebatipoya ame numuda minakolaiye. Nemokaho sa-loko lo libituwe: Edimolitaya nemoda muda-nelamiki miniki alikaya sa-liki nemodamuya litae: We napamidana galalo nisekane. Omailimo maku imitiye liki litabo ne, lokoya lo biye. 35 Sam 118:26 ");
INSERT INTO yby_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Holi onawa makomauya Palasisi wewenasida ujapa wenipomidana numudalau yoweko minoko nodenesa noko neyoko, Jisesimamo sainama le opa etihe liki ujapa i-minae. ");
INSERT INTO yby_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sa-niayoko ayauya we mako neboya i adelo lulu jekaka nesa jelibo weya Jisesida omudalokaya niseko ne. ");
INSERT INTO yby_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Neyoko Jisesimamo monoka monawa api-napi ikaka weki ito Palasisi wekiya sa-loko loka obetaiye: Edimoya saina delaibo wewenasidaya holi onawauya dilipe haka lokaka nesa nehe ito sametudawo ne. ");
INSERT INTO yby_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Loko liyoko edimoma depa molikiki minae. Sa-ikiya minayoko aya nesa elaibo wemidanama ilime haka lokaiyoko wiye. ");
INSERT INTO yby_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wokaiyoko Jisesimamo sa-loko loko lo biye: Edimokutiya we makomidana ipalahe ito bulumaka jalahe aleu lemeko netiboya holi onawauma ne likiki ayauya hulikadeko ayauya netibo nehe. Ito enemane iki ika iki huli maloka molatabo ne. ");
INSERT INTO yby_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Loko lokaiyoko yalo maya li mamae. 5 Mat 12:11 ");
INSERT INTO yby_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sa-iyoko lesa molo bibo wewenama nisikiki nodenesama nakili niadanaki, siya laloloya minatune liki sa-niayoko Jisesimamo mudakoko koha moloko ga mako sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Wewena makolimo nodenesa napaloya nisitane loko lesa molokadeko nise-minadeyama siya lalolo minamo. Aya nodenesalo we napa mako emoda asetoko netiboya, lesa molonetibo wemamo nisekoko sa-loko lo imitiye: ");
INSERT INTO yby_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Emoya maya minadawo siyaya hulikoko maya wemidana mo. Loko lideko emoya owaka helekoko demesaloka siya lahelamiboto woko minokatane. ");
INSERT INTO yby_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nodenesa napalo lesa moli imikadeyama woko demesaloka siyaloya minadeko lesa molo libibo welimo niseko sa-loko lo imitiye: Yogone, emoya woko lomudaloka siyalo yowaya mino. Loko lokadeko nodenesa li esa iki niki minabo wewenasida madonipoloya ulikaya wetiye. ");
INSERT INTO yby_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Wewena makolimo eimola ulila le sinatiboya alikaya eimola ulila lemekolaiye. Ito wewena makoya eimola ulila leko limitiboya Omailimo alikaya ulila leko yowekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Loko lokoko Jisesimamo lesa molo mibo wemidanama sa-loko lo miye: Emoya nodenesa napa le lolowa noko maya emo unakago ito yowokago ito numudakalo wewenago ito uvaminanipoki wewenagoya lesa molo bamo. Edimo nodenesa napa le lolowa oko lesa molo bedawoto aku emoda imikatayo. ");
INSERT INTO yby_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ito emoya nodenesahena le lolowa noko maya aha wewenahena ito di dade lahelamibo wewenahenakiya ito domuda likaibo wewenahenakiya lesa molo bo. ");
INSERT INTO yby_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sa-ikiya niki alika nodenesa bekimi iki sa-itabolawa minaminako, emoya elowa jeko minakolane. Sa-ideko Omailimo wewena lalowa heli-minatabokuti dilipe sinatibo onawaloya niseko meinawaka emekolaiye. 8 Plo 25:6-7 11 Mat 23:12; Luk 18:14 ");
INSERT INTO yby_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nodenesa noko nebo wemalimo Jisesimamo sa-loko noliyoko elekoko sa-loko lo miye: Omaimidana oholauya miniki nodenesa niki minatabo wewenaya ake jikilae. ");
INSERT INTO yby_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Loko lokaiyoko Jisesima yamuya ga mako koha moloko sa-loko liye: We makolimo nodenesa wavu-leko le lolowa ekolo muki wewenasida maya lesa molo biye. ");
INSERT INTO yby_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lesa molobetaibo onawa maya alili okaiyoko nodenesalo maya nisitae loko yowanu welalesidama doli hekaiyoko lesa molo bibo wewenasitokama wae. Wiki sa-liki li be: Edimoya nisilo. Nodenesama aloya le lolowa okaiyo. ");
INSERT INTO yby_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Liki likayoko maya wewenama muki witabo nesamuya osele-pasele ladanaki makomalimo sa-loko liye: Nemoya mika makoya meina he-minonako, yalokaya woko muda-loko nowoyo, woko uliki wemidanama nemo maya wamokoya eke liye loko lo mo. ");
INSERT INTO yby_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Loko lokaiyoko makolimoya sa-loko liye: Olotiya bulumaka ja lade maloka maloka suwoko meina heminobo nenako, aha minatahe woko mudakoloyo. Uliki wemidana maya woko wamokoya eke liye loko lo mo. ");
INSERT INTO yby_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Loko lokaiyoko makolimo sa-loko liye: Nemoya owahasiya mena lekoko sa-nonako yamuya wametubo ne loko liye. ");
INSERT INTO yby_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Liki likayoko aya yowanu wemamoya aku le wili jeko woko labo labo ga maya ujapa welamidanama wetome oko lo miye. Lo mekaiyoko ujapa welamamo epalo molokaiyoko yowanu weladama sa-loko lo miye: Emoya enemane oko woko taoniloka ito muki numutoka aha wewenahena ito dilo libo wewenahena ito saina delaibo wewenahena minabo maya ohu jeko dilipe-loko niso. ");
INSERT INTO yby_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Loko lokaiyoko yowanu welamamo moneko libo ga maya lokadanaki niseko sa-loko lo miye: Ujapa wene, yowanu gama lonetadawo gama loboya siya makoya aha minokaiye. ");
INSERT INTO yby_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Loko lokaiyoko ujapa wemamo yowanu weladama sa-loko lo miye: Emoya asola masola ohuguka anuhenaya nowoko numudaneuya liki liki minatae loko dilipe-loko niso. ");
INSERT INTO yby_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Emodaya sa-loko lo noemoe: Omutoko lesa molo bobo wewenama nisamanako, nemo nodenesaneutiya namikilae loko lo biye. ");
INSERT INTO yby_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Muki wewenasiya Jisesidama emesalo moliki niwayoko Jisesimamo sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Wewena makolimo nemoki minasiye loko elekoko maya dolale aholale menakipa oluholalemuya adoha nesa leko elekoko, ito eimola minoko sako etibo nesamu adoha nesa leko elekokoma, ito nemokumu ele aha nesa lolo etiboya nemo oluhone lolo ametiye. ");
INSERT INTO yby_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ito wewena mako miluma nesa li ohitatabomu le emesaloka hulikoko nemesalo molametiboya nemo oluhone lolo amekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Edimokutiya we makolimo numuda napa mako vekoloya ehada kohenehe ito kohamihe adaya meinawa loka oko elekoko molo eleko vetibotoya wehe loko nehe mudakoko vekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ito samoko enemane oko numudalaya le heko vetiboya, ehadala maya suwideko ehadamu aya numudaya hulikadeko muki wewenasiya ijala itakilae. ");
INSERT INTO yby_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ijala itiki sa-liki likilae: Maya welimoya abuhala neyoko ihe, numuda napa-napaya ehada le heko viha viha osele elaiyoko hulikayoko ayau maya epa nuvama woko ne. ");
INSERT INTO yby_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ito uliki we napa makolimoya iwela uliki we napa mako kohatuwe lokoma lowa okepa molamekolaiye. Emo adaya sa-loko ata elekolaiye: Lemoya aya lasolasi 10,000 minokudanako, ito edimoya wavu-liki 20,000 minikanako, kohaidatupe kohaidametupe lokoko ");
INSERT INTO yby_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","eimolaki ito wewenalalesikumuki elitiboya kohamidekoma ulalalo weya numudalaloka aha nedeko enemane oko ilime eha jitiye loko we mako oli hekadeko woko sa-loko letiye: Olotiya yogo moloko natune loko noli hekaiyoko nonisoe loko lo mitiye. ");
INSERT INTO yby_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Loko letibo nenako, yamuya edimotokati we mako sainapainalahenala mukiya hulo suwametiboya nena nena oko nemo oluhone lolo etibo ne. 26 Mat 16:24; Mak 8:34; Luk 9:23 ");
INSERT INTO yby_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ageya saina lalo neboya, lahelepa ametiboya, nena nena okoma aku le lahelepa etune. Ma samekolune. ");
INSERT INTO yby_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yamidana mamidana oko le lahelepa etudawolaya minamiye. Ahaya kise hulakolune. Sa-oneyo, dataki minatabolawalita maya aya eli wehe liki elilo. Edimokiya lahelepa iki minatayo loko liye. ");
INSERT INTO yby_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takisi meina likaka wewenaki ito we olisa mena olisa ikaka wewena muki nisiki monoka elikili Jisesitoka li esa ikaka ae. ");
INSERT INTO yby_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Sayoko Palasisi weki ito monoka monawamu api-napi ikaka wekiya sabo nesamuya delamibo ne. Sa-okaiyoko Jisesikumuya sa-liki likaka i-minabo ne: Maya welimoya we mena olisa ikaka wewenamaki magoina nodenesa nokaka noiboya etamiye liki lae. ");
INSERT INTO yby_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Liki likayoko Jisesimamo elekoko koha moloko ga mako sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Edimokutiya we makolimo sipisipi jala 100 minatabokutiya makoma leso etiboya moneko ohu jitibo nehe moneko ohu jametibo ne. Maloka aha minabolawasidaya dilipe nupa o makomaloka molokoko moneko leso ibolawa ohu jitiboma ne. ");
INSERT INTO yby_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sako moneko ohu jeko jeko le soto molokokoma ukalauka lahelepa ideko ilime-loko numutoka nisekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ilime-loko niseko iwelalekiya dilipe nupa okoko sa-loko lekolaiye: Sipisipi jane leso ibolawa maya alo ohu jekoyo, magoina elowa jetune loko letibo ne. ");
INSERT INTO yby_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sa-onenako, yamuya nemokaho ga mako lo libekoloyo, elilo. Watiya minune liki litabola 99-siya duka li wili jamitabo wewenamuya okulumauya elowa jamikilae. We makoko lahelamibomidana uka le wili jekadeko okulumauya elowa napa jitabo ne. 1-2 Luk 5:29-30 ");
INSERT INTO yby_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ito mena makolimo ehada ihilawa lade maloka maloka suwoko molonetibokutiya makoko lemo jenetiboya yatokaya makokoma ne lokoko hulikamekolaiye. Leya jeko mumusopaya usoko le hula hula oko ohu jeko le soto molokoko wewenalalesidama sa-loko lo bekolaiye: ");
INSERT INTO yby_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ehadane lemo jibo maya ohu jeko le soto molokoyo, nemoki magoina elowa jetune loko letibo ne. ");
INSERT INTO yby_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yamidana nenako Omaimidana okanaki welalesiya lahelamibo nesauti wewena makolimo ukala le wili jekaiyokoma okulumauya elowa jikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisesikaho koha moloko ga mako sa-loko lo biye: We makoya ipala lowe minaiye. ");
INSERT INTO yby_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Minikiya alika ipalamamo aholadama sa-loko lo miye: Ahone aliyo, ehada uvamina molonetadawomaya olotiya le nemo. Loko lokaiyoko ehada uvaminala maya ona moloko ipala lowesida maya biye. ");
INSERT INTO yby_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ona moloko bekaiyoko alika ipalamamo mino hana amidanaki uvamina maya lekadanaki wiye. Woko mika makomaloka nedanaki, woko minoko ehadala maya oluwalu menakipalo ito biya noloya huloko suwiye. ");
INSERT INTO yby_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sako hulo suwoikoko neyoko aya nebo ebato maya nodemu napa-napa hele. Helikayoko emokiya nodenesalamu ohu jeko, ");
INSERT INTO yby_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","woko mika aholamidana lokaiyoko aya wemamo woko jama ujapa oko minatane loko lokaiyoko woko jama ujapa oko nedanaki, ");
INSERT INTO yby_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","nodenesa maya mositikayoko jasida nodenesanipoutima natuwe loko sa-ibo maya yautimaki namo liki likayoko namiye. ");
INSERT INTO yby_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sa-ikayoko nedanaki alikaya ata golotokaiyoko sa-loko ata kiye: Ahoneda elekele oluholale wavu-liki miniki nodenesa laloma ninataboma neboya, nemo maya nodekumu helekolonako, ");
INSERT INTO yby_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","numudaneloka aku woko ahonedaya sa-loko lo mituwe: Ahone aliyo, lahelamibo nesa lolo okoyoko lihimawanelimo emotokaki ito Omailokaki eda adoha okaiyo, ");
INSERT INTO yby_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","akuya ipane loko lamo, elekele oluhone loko lideko minatuwe loko lo mituyo lokoko sinoko aholatokaya wiye. ");
INSERT INTO yby_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Woko numudala atetoma sinaiyoko, aholamamo mudaiboma sa-iyoko milumala elekoko lolosa jeko woko apusa jeko okepa epama lijeko nonaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ipalamamo sa-loko lo miye: Ahone lahelamibo nesa lolo okoyoko lihimawanelimo Omailokaki ito emotokakiya edawaki okaiyo, aku ipakae loko minametuwe. ");
INSERT INTO yby_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Loko noliyoko aholamamo elekele oluholasidama sa-loko lo biye: Enemane iki wiki upalo nesa lalo liki nisiki jitalo, adelo lini jitalo, ito iloya su jitalo, ");
INSERT INTO yby_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ito bulumaka ja napawa netibo kohaiki vitalo. Lemoki noko elowa jetuniyo. ");
INSERT INTO yby_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ipanema helenebokuti sinoko nisekaiye ito aha leso onebokuti nisihe sa-ihe okaiyo, kohaiki vitadeko noko elowa jetuniyo. Loko lokaiyoko aiyo wuye liki elowa jiki ehada jiki nae. ");
INSERT INTO yby_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Sa-iki sa-niayoko ada ipalamamo yowanulo nomonibokukati niseko numuda esewatokatima elibo maya, mau maya elowa jiki meleke liki aito aweyaha niayoko elekoko, ");
INSERT INTO yby_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","elekele oluho mako ju lokaiyoko nisiyoko loka oetoko yataya nenaha niae, ");
INSERT INTO yby_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","loko liyoko maya wemamo sa-etape unakama hapa wiboma nisekaiyoko ahotipomamo bulumaka ja napawa mako kohaiki vitalo loko lokaiyoko kohako novoetune. ");
INSERT INTO yby_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Loko liyoko ada ipalamamo mesaha jeikoko yalo maya wamoko aha neyoko ahonipomamo lemeko ilime hulu iha, ");
INSERT INTO yby_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ele hulikoko sa-loko lo miye: Ele-mino. Wavu-leko melekema le huloko elekele oetoko aka mako ladawoya ele hulamoboya, emokaho meme ja akalewa mako nemoki wewenaneleki kohaiki nalo loko nemamadawoma ne. ");
INSERT INTO yby_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ito alika ipakama ehada uvaminalama leko menakipa oluwalulo hulo suwiye. Yamidanama neboya emokaho laniyoko bulumaka ja napawaya kohaikiki wataina nitae. ");
INSERT INTO yby_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Loko lokaiyoko ahonipomamo sa-loko lo miye: Ipane yamalae, emoya hana-pana yulakaya nemokima minadawoma nenako, nemo nesa-pasaya emo nesakagoya elitiboma ne. ");
INSERT INTO yby_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ito unakaya helenebokutihe ito leso onebokutihe akuya nisekaiyoko yamuya muluteu lalo eleko elowa nojudawoya watiyoko ne loko liye. ");
INSERT INTO yby_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisesimamo unala ipalale yuhasidama sa-loko lo biye: Uvaminalaki we napalimo yowanulo ujapa wela mako nebo ne. Minokoma we makosiya ujapa wemamidana ga mako sa-liki layoko eliye: Ujapa wemamoya uvaminala le opa okaka noiye. Liki laboya elekoko, ");
INSERT INTO yby_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","sa-loko ju lo miye: Gakaya nenae liki layoko eloe. Yamidana wewenaya nemo ujapa wene minamitae loko noloe. Yowanulo tiketima lekano, ehada uvaminane ujapa adawo monawa le wehe letuniyo. ");
INSERT INTO yby_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Loko liyoko, uvamina ujapalo wemamo ukalauka sa-loko eliye: Maya ujapa wenelimoya maya yowanuneya hipo oko litiboya nenaha etubo nehelae, loko eliye. Owiya yowanu lituboya osele nelokaiye. Anulo ehadamu wako wako loko moneko owane helekatuwe. ");
INSERT INTO yby_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Loko elekonako, nemoya ujapa wenelimo noli hekadeko wewenanele numudanipou minoko leko oyoko nilimi lalo itabo wewenasida saina mako lalo obetatuyo. ");
INSERT INTO yby_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Loko lokoko moneko ujapa welamidana dina itiminabo wewenasidama lesa makoko makoko oko molobetaiye. Molokoko makomamidana sa-loko loka oetaiye: Nemo ujapa wenemidana dinalama emotokaya nenakima ne. ");
INSERT INTO yby_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Loko lokaiyoko, emo maya ya olivi nouvala oda 100 ne. Loko lokaiyoko, sa-loko lo miye: Enemane oko tiketima lekoko 50 loko luhuwa jo. ");
INSERT INTO yby_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Loko lokoko makomamidana sa-loko loka oetaiye: Ujapa wenemidana dinala emotokaya nenakima ne. Loko lokaiyoko, laisi owo 1000 ne. Loko lokaiyoko, sa-loko liye: Enemane oko tiketima lekoko 800 loko luhuwa jo. ");
INSERT INTO yby_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Loko liyoko, ujapa wemamo elekoko uvamina le opa napalo ujapa weya ele wehe lo-minoko libomuya eke loetaiye. Ito monokanipo minamibo wewenasiya eli wehe li-miniki saina-maina likaka niae. Monokatipoki wewenaya yamidana nesaya edimotoka minamiye. ");
INSERT INTO yby_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yamidana nesamuya lo libekoloyo, elilo. Edimoya asaiki ehada uvaminaya aha nesae likiki iwetipolesida bikadeko, edimo iwetipole lolo ikadeko, aya nesa li-minatabo onawa maya suwokadeko, elewole ebato molobetokadeko yauya miniki meinawatipo likilae. ");
INSERT INTO yby_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wewena mako lasomosola nesalo wati oko ujapa etiboya, saina napalokiya asako wati oko ujapa etibo ne. Ito wewena mako lasomosola nesalo le opa napa oko ujapa etiboya, asaoko saina napalokiya wati oko ujapa ametibo ne. ");
INSERT INTO yby_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Edimo uvamina aha nesaya li laliki ujapa amitaboya, saina laloya ekahimamo libitiye. ");
INSERT INTO yby_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ito aha nesa libiboya li laliki ujapa amitaboya, elewole uvaminatipoya ekahimamo le heko mololibetatiye. ");
INSERT INTO yby_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","We makolimo wewena lowesida elekele yowanu lebetamekolaiye. Sa-etiboya makomidana uka mekoko ito makomidana mesaha jetatiye. Makomalokaya kolokoko makomamidanaya muda-elo hulakolaiye. Edimoya asaiki Omaimidana yowanula nebo ito ehada yowanu nebo maloka maloka makoko aweyaha oko lekaka nesa minamiye. 13 Mat 6:24 ");
INSERT INTO yby_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Loko lokaiyoko, Palasisi wewenasiya ehada uvaminamu delaibo wewenasiya aya ga maya eliki eli aha nesa lolo ae. ");
INSERT INTO yby_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sa-ikayoko, Jisesimamo sa-loko lo biye: Edimoya wewenasida domudaloya wehe lominune liki ake jiki monikaka niaboya, Omailimo dukamidana monawalaya mudaone. Wewenasiya mudaboya wehe lone liki likaka niaha, Omailimo mudaiboya omusepala yowekaka noiye. ");
INSERT INTO yby_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mosesekaho lo hukoko libo gaki ito Omaimidana epalauti ga likaka wesi labo gakiya mino-loko niseko niseko Jonitoya liye. Yalotiya niseko Omaimidana ebalamidana galaya hutili oko muki ebakukaya wokaiyoko, muki wewenasiya lowa-sawa iki Omaimidana ebalauya wikili sa-ikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Okulumaki ito ma mikakiya leso esiye liki leso isaiboya, Mosesekaho lo hukoko libo gaya onuwa lasolasi mako leso amekolaiye. 16 Mat 11:12-13 17 Mat 5:18 ");
INSERT INTO yby_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","We makolimo menaladaya oli he hulikoko aito mena mako litiboya, olisa nenako, lihima napa lekolaiye. Ito we makolimo hulonetibo mena mako litiboya olisaya nenako, lihima napa lekolaiye. 18 1 Kol 7:10-11 ");
INSERT INTO yby_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisesikaho koha moloko ga mako sa-loko lo biye: Uvaminalaki we napa ne. Emoya luhuwawaki nebo nesa meina napaloti nesa meina heko le koloko nebo ne. Ito muki yulakaya uvaminala obeliyoko yotili oko minokaka iye. ");
INSERT INTO yby_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sa-noiyoko, we ebili mako Laselesi upaloya mika ihi jeleko uvaminalaki wemamidana numudala lekuka udoko, ");
INSERT INTO yby_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","minoko nodenesa natibokuti lana-hanawama lemo jitibokuti le nimideko natuyo loko minokaka iye. Sa-oko neyoko, ulahenamasi nisiki numulalotima unapi iki nikaka ae. ");
INSERT INTO yby_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sako minoko we ebilima helekaiyoko, okanaki wesiya ilimi-liki yowiki Aebalahamuda amaitokaya hulitikayoko ne. Ito alikaya uvaminalaki we maya heliyoko ale jitae. ");
INSERT INTO yby_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ale jitikayoko, lemeko jo ebaku nedanaki miluma-aluma eleko minoko omuda hulo meida epaloka moloko minoko mudaibo maya, Laselesi maya Aebalahamuda amaitokama neyoko mudaiye. ");
INSERT INTO yby_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mudakoko ju loko sa-loko liye: Aebalahamuyo, milumane elekoko Laselesidaya oli hideko ade owalotiya noku hekoko lemeko nepa ulumaloka lideko eha jenetatihao. Nemo joku maya miluma-aluma eleko maya minohao. ");
INSERT INTO yby_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Loko liyoko, Aebalahamumamo sa-loko liye: Ipane yamalae, ele-minape, emolikaya ma mikaukama uvaminalo emesa meko minadawo maya alo suwiye. Ito Laselesiya milumamidana mupilalo neboma ne. Sa-iboma asakoya suwiye. Oloti maya Laselesidama ilime lalo niayoko emoma miluma noelene. ");
INSERT INTO yby_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ito luwawateuya meida napa-napaya minokaiye. Sa-onenako, yamuya malokati lemekakawaya minamiye. Ito yalokati yowekakawa minamiye. ");
INSERT INTO yby_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Loko liyoko, uvaminalaki wemamo sa-loko liye: Ahone yamalae, ga mako lekoloyo, emesalo molo. Yeilaya nemo numutokaya ");
INSERT INTO yby_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nemo unane ipaneleya nade maloka suwiyoko minayo. Edimosiya nisiki maya miluma ebakuya nisikatayo, Laselesidama oli hekadeko woko ehe loko lo bideyo. ");
INSERT INTO yby_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Loko liyoko, Aebalahamumamo sa-loko liye: O'e, Moseseda galaki ito Omaimidana epalauti ga likaka wesida ganipoki edimotoka nebo nenako, eli-minatabo nenae. ");
INSERT INTO yby_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Loko liyoko, o'e, ahone omokane, sako minamiyolae. Helenetibokutima makolimo sinokoko woko lo bideko duka li wili jitabo ne. ");
INSERT INTO yby_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Loko liyoko, sa-loko liye: Mosesele ito Omaimidana epalauti ga likaka wesida ganipo eli huliminataboya, we mako helenetibokuti sinokoko woko lo bitibo maya asaiki eli hulakilae, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisesimamo unala ipalale yuhasidama ga mako sa-loko lo biye: Lahelamibo nesamu ula molikaka niabo nesaya aha minakolaiboya, aya nesamu ula moloko lo-lele monitibo wemidanaya Omaimo nenaha lolo oetatihelae. ");
INSERT INTO yby_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Oluhone lasomosola minatabokutiya wewena makolimo makomidana lahelamibo nesa lolo o loko esewauka le ahu letiboya, Omailimo nenaha oetatiye. Ehada napa-napaloti enolauya nalawa iki tikiki helu i ela noku hulatabomidana asetoko Omaimo edawaki adoha nesa lolo oetatibo ne. ");
INSERT INTO yby_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ehe, edimoya iki moliki itabo nesa ujapa iki minalo. We iweka makolimo liwe weuna molokadekoma auha meko ata lo. Sako ata lideko gaka elekadekoma lihimala le huloeto. ");
INSERT INTO yby_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Makoko yulakaya lihima nesa legetonetiboya 7-pala yulaka noadawotoka niseko iwene, yamidana nesa lolo oetobolimoya muluneu lahelamiye loko niseko lo imitiboya yamuya asako lihimawalaya le huloeto. 3 Mat 18:15 ");
INSERT INTO yby_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposolosi We napamidanama sa-liki li me: Emo elewole oko lata elekaka nesaya le hutili oleto. ");
INSERT INTO yby_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Liki likayoko, We napamamo sa-loko lo biye: Masteti ya ihilawa lasolasilimoya wileko yoweko napa-napa okaka noibomidana elewole iki elikaka nesatipoya minatidanako, ya makomidana babiya oko lemeko ela noku sino-mino liki li mitaboya, gatipo ele libekoko aha sa-etibo ne. ");
INSERT INTO yby_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Edimokutiya we makomidana elekele oluhola mikauka yowanu leko netibototiya ito ja ujapa oko netibokutiya ludakama nisekadeko aha sa-loko lo mitibo nehe: Enemane oko yoweko nodenesaka noko mino. ");
INSERT INTO yby_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sako minamiye. Emoya sa-loko lo mekolaiye: Emokahoya yowanu lekaka upalo nesaya le molokoko ludakaya nodenesa wataina onetadeko nonoyoko, alikaya emoka epa nesaka wataina oko natane. ");
INSERT INTO yby_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Loko loetokadeko, elekele oluho maya ujapa wemamo loetaibo nesa lekogo nedeko, ujapa wemamo dowa lokoe loko letihe, ma ilime lalo amekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ito edimo monawatipokiya asa-okogoya ne. Edimo yowanu ga lolibetoboya liki suwikikima sa-likiya lilo: Lemo elekele oluhoka ebili maya loletadawo yowanugo maya aloya lekune, kolo meko mako lolo amune liki lilo, loko lo biye. ");
INSERT INTO yby_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisesima Jelusalemu numutoka wekolo Galeli ebakuka ito Samaliya ebakuka luwakuya nowidanaki, ");
INSERT INTO yby_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","eba makomaloya nise hetoko nowiyoko, mika ihi jelebo wewena lade maloka maloka suwiyoko wewenasiya muda-elikiki yuha le yolalo malo nesama nenako, likadanaki hototiya ju liki sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Lemo ujapa wete Jisesiyo, lemokumuya milumate eleleto. ");
INSERT INTO yby_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Liki layoko, mudaidokoko sa-loko liye: Edimoya olutitabokumu dupatipoya liki wiki Omaimitoka jokila hi mikaka wesitokaya dilipilo. Loko lo bekaiyoko, oha li wili jiki niwayoko dupalo jelebo nesa maya olutobetaiye. ");
INSERT INTO yby_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Oluto suwobetaiyoko, makokolimoya mudaiboma sa-iyoko akuya niseko ga napautiya Omaimidana epoka lomo lomo, ");
INSERT INTO yby_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jisesitokama nisidanaki i bola heko Jisesidama epoka liye. Aya weya Juda we nehekala, Samaliya welimoya sa-iye. ");
INSERT INTO yby_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sa-iyoko, Jisesimamo sa-loko liye: We 10-pala minabo maya 9-palama nakahaloka wae. ");
INSERT INTO yby_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Edimomasi nisiki Omaimidana epoka litaboma neboya, aha wikayoko, Samaliya ebakuka muda aha nesa okaka noudawo wewenauti eimolago nisekaiye. ");
INSERT INTO yby_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Loko lokoko aya wemidana elewole oko eladawolimoya ilime haka loetokaiyo, sinoko wo loko lo miye. 14 Liv 14:1-32 ");
INSERT INTO yby_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Palasisi wewenasiya Jisesidama loka itiki Omailimo ujapa oletatibo we napateya nena yulakama soto pitiye liki layoko, Jisesimamo sa-loko lo biye: Omaimo ujapa olibetatibo onawaya edimo mudai-minadeko, onowelaki soto pamekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yamuya anewa mako mudaikikima agae, maloka soto pene, ito yolaloka soto pene liki lamikilae. Eli-minahe. Omailimo ujapa olibetatibo ebaya dukauya soto peko ne, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ito unala ipalale yuha maya sa-loko lo biye: Minoko onawaya alili etiboya nemo okulumauti we uti muda-nelakiliya nupamu elitabo neboya, ma muda-nelamikilae. ");
INSERT INTO yby_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ya yulakaya sa-liki li li bikilae: Lemotoka soto nopiye, ito edimotoka soto nopiye liki lideko, edimoya emesalo moliki wamilo. Ito wehe liki lae liki data kamilo. ");
INSERT INTO yby_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Okulumaloka muki go pana nokiyoko mudaokaka noune. Yamidana sako nemo okulumauti we uti nisitubo onawa alili noidekoma, sa-etibo nenako, ma mikau minatabo muki wewenasiya mudatabo mudaneli suwikilae. ");
INSERT INTO yby_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sakoma neboya, maya wewenasiya nemo okulumauti we utima mudaneli hulikiki nemodama miluma nesa le nemetune liki li-minae. ");
INSERT INTO yby_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nemo onawanemoya alili noideko maya, Nowama nebo onawalo minabo wewenasida diyakauya jitabo ne. ");
INSERT INTO yby_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Edimoya ataina napa-napa adanaki mena hukadanaki yogo-yogo jiki mini-liki wayoko, Nowa maya menakipa oluholaleki noku lapeu yowikayoko, no napa ileko niseko nolimo kohaido esa iboma ne. ");
INSERT INTO yby_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ito Lotima nebo yulakamaki asa oneboma ne. Edimoya nodenesa napa-napa ataina adanaki, meinalo nesa li yolalo malo adanaki, yowanu liki yuha yaha adanaki, numuda vikiki lukikiki Lotida gala maya elamiki sa-niayoko, ");
INSERT INTO yby_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lotimamo Sodomu ebama hulikoko nowiyoko, okulumautima gokidana nesa sako jo ulumaki lemeko kohaido esa iboma ne. ");
INSERT INTO yby_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Okulumauti we uti nemoya nisitubo yupekaya asako soto pekoloe. Soto pitubo yulakaya muki wewenasiya asaiki sa-ikilae. ");
INSERT INTO yby_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ya yulakaya numudanipo hekaka minatabo wewenasiya enemane iki yowiki uvaminanipo lamikilae. Ito wewena mijanipouka minatabototiya enemane iki nisiki numudanipoukati uvaminanipo lamikilae. ");
INSERT INTO yby_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sa-oneyo, Lotida menalatokagoma data kilo. ");
INSERT INTO yby_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wewena mako duka depaya li etoha iki li-minatabo wewenaya wiki opa ikilae, ito wewena mako duka depaya wina itaboya elewole depa mutiya likilae. ");
INSERT INTO yby_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nemoya wehe loko lo libituyo, eli-minalo. Nisitubo lubukaya we loweya makoko sipalo udi-minasaibokutiya mako maya ilimekoko makomamidana huloetakoloe. ");
INSERT INTO yby_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mena lowema witi ihilawa esopa jiki nimulisaibokutiya Omailimo makomalaya ilimekoko makomalaya huloetakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Loko lokaiyoko, unala ipalale yuhamasiya loka itiki sa-liki lae: We napate yamalae, ya nesaya nena yulakama soto pitiye. Liki layoko. sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wewena helebo onoloya nama osuwehaya enemane iki limi esa ikaka niae. Yamidana ma mikauka wewena nuwama nesalimo dukauka waitetibo onawaloya enemane iki obi napa ikilae, loko lo biye. 26 Jen 6:5-8 27 Jen 7:6-24 28-29 Jen 18:20-19:25 31 Mat 24:17-18; Mak 13:15-16 33 Jen 19:26; Mat 10:39; Mat 16:25 31 Mak 8:35; Luk 9:24 ");
INSERT INTO yby_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisesikaho unala ipalale yuhasidama muki yulaka domuda udiki osele-pasele amiki Omailoka litaboya Omailimo ele bitibomu koha moloko ga mako sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Eba makomaloya obi le helekaka we mako nebo ne. Sa-onebo nenako, aya welimoya Omai nebo wewena minaboya ma ele bamiye. ");
INSERT INTO yby_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sa-iboya, aya ebato eto mena makokiya nebo ne. Aya menalimoya obi ga le helekaka we napa nebotoka muki yulakaya woko sa-loko lo mekaka iye: Nemoya ulanelo welimoya nilime lahelamibo ekolaiyoko, emokahoya nilimitane loko noloe. ");
INSERT INTO yby_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Loko lo mekaka iboya maya obi yowanu le helekaka welimoya hana-pana yulaka elekoko minokaka iboya, sako minoko ukaukaya sa-loko eliye: Nemoya Omai nebo ito wewena minabosidaya ma ele bamobo wema minoboya, ");
INSERT INTO yby_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","maya eto menalimoya niseko osele ga adoha lokaka noiye. Sako lowa lowa ideko osele nelokatiyo, aya ga maya le heletatuyo, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Loko We napamamo gama lo suwokoko sa-loko lo biye: Obi yowanu lekaka wemamoya ga makoya liboya alo eli-minahe. ");
INSERT INTO yby_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Olile. Edimoya Omaimidanamu nenae liki likaka niae. Emokaho asako dilipe eto ibo wewenasiya muki yulakaya ju liwa liwa iki minadeko, dilipe lalo ametibo ne liki data ki-minahe. Ito ele hulikoko netibo nehe. Sako minamiye. ");
INSERT INTO yby_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Enemane oko le wehe lolibetatibo ne loko noloe. Sa-etiboya, nemo okulumauti we uti aku le wili jeko ma mikau nisitubo onawaloya nemo dilipe wehe liki eli elewole iki minatabo wewenaya ma minatahe ma minamitahe loko nata etipa nokoe, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Maloka wewenasiya edimonida dupanidaya liki yowikiki ito iwenipolesida liki limikaka niayoko, Jisesimamo mudakoko koha moloko ga mako sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","We lowe maya Omailoka domuda likakili monoka numukuya yoweiye, makoya Palasisi we ne, ito makoya takisilo moneko ehada ukele lekaka noibo we ne. ");
INSERT INTO yby_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Saki yoweidanaki Palasisi wemamo sino wehe lonedanaki eimoladamuya sa-loko elekoko sa-loko liye: Kee, ahone Omaiyo, maloka wewenaya ukele-hakele iki we mena olisa ikaka niae. Nemoya edimokidana minamoe, ito takisi ehada ukele lekaka we yolayakidana minamoe. Yamuya epoka noloe. ");
INSERT INTO yby_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nemoya holi onawau onawauya monokamuye loko nodenesa moseko minokaka noe. Ito ehada noleko maya 10 10 nebokutiya monokamuye loko makoko makoko molokaka noe. ");
INSERT INTO yby_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Loko lokaiyoko, takisi ehada lekaka we maya ilikauka nedanaki sinoko mudatibo nesamuya owana helekoko, eke adoha loko sa-loko epoka liye: Kee, ahone Omaiyo, lihimaneki we nemodaya eke loneto, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Eli-minahe, takisi ehada lekaka wemidana lihimalaya le huloetokaiyoko numudalaloka wiye. Sa-iyoko, Palasisi wemidana lihimalama aha nebo ne. Sa-onebo nenako, olotiya wewena mako dulinipo li jitaboya, alikaya limitibo ne. Ito wewena mako dulinipo liki limiki molataboya Omailimoya dulinipo leko yowekolaiye. 14 Mat 23:12; Luk 14:11 ");
INSERT INTO yby_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Loko lokaiyoko aya yulakaya muki wewenasi oluhonipolesidama Jisesima nebotoka adeladunu sisiwa jebetoko maku bitiye liki dilipi-liki nebotokaya wae. Sa-niayoko, unalale ipalale yuhamasiya auha nibeyoko, ");
INSERT INTO yby_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jisesimamo sa-loko liye: Sa-lamiki oluho lasomosolaya hulibitikadeko nemotoka nisitae. Oluho lasomosola yamidana wewenaya Omaimidana oholau yowitabo oluhola lolo itabo neyo, auha bamiki hulibitikalo. ");
INSERT INTO yby_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nemoya wehe loko lo libituyo, elilo. Wewena makoya oluho lasomosola monokau li lolowa iki yowikaka niabomidana iki monokau yowamitaboya, Omaimidana oholauya yowamikilae, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sa-iyoko, Juda wewenasida ujapa we makolimo Jisesidama sa-loko loka oetaiye: Tisane lalo nesa yamalae, nemoya nenaha okoko elewole nepa mutiya litubo ne. ");
INSERT INTO yby_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Loko lokaiyoko, Jisesimamo sa-loko lo miye: Emolika nemodamu we laloe loko noladawomidana monawamuya ele wehe lo-minoko nolape. Ahone Omai makokoya we lalo neyo. ");
INSERT INTO yby_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ito emoya 10-pala lo maya ele-minane. Sa-loko ne: We olisa mena olisa amo. Emoya wewenasidaya kohaido helamo. Ukele lamo. Suwaki namaki lamo. Emoya dokako ahokakosida duliya le sino. ");
INSERT INTO yby_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Loko lokaiyoko, ujapa wemamo sa-loko liye: Aya lo hukoko libo gaya nemokahoya oluho we owahaneloti emesalo moloko lekaka noboma nenae. Sa-oneyo, saina ma lolo amohe. ");
INSERT INTO yby_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Loko lokaiyoko, Jisesimamo elekoko sa-loko liye: Saina makokosima owaha lolo amadawo neboya, le wehe letaniyo. Emoya woko uvaminakahena meinalo ona moloko lekoko uvaminanipo minamibo wewenasida bekoko niseko we ivene lolo etane. Sa-okadeko okulumau elewole uvaminaya emo nesaka lolo ekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Loko liyoko, uvaminala waitoko nebo nenako, ona moloko bituhelae loko eliyoko edala adoha elonebo ne. ");
INSERT INTO yby_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sa-okaiyoko, Jisesimamo mudakoko uvaminanipoki wewenaya Omaimidana oholauya osele nesa liki yowikilae. ");
INSERT INTO yby_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ja kemoloyamoya neka onawa lonebokuya yowitiboya osele nesa neboya, uvaminanipoki wewenaya Omaimidana oholau yowitaboya yatoka nesamidana asetoko osele yowanu adoha litabo ne. ");
INSERT INTO yby_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Loko noliyoko elebo wewenasiya sa-liki lae: I'i, sa-idekoma ekahidama Omailimo lahelametibo nesauti ilime yowaloka moladeko mino-loko yoweko netiye. ");
INSERT INTO yby_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Liki layoko, Jisesimamo sa-loko lo biye: Wewenasiya yamidana itabolawaya minamiboya, Omailimo lolo etuwe loko ata kitibo nesaya aha lolo etibo ne. ");
INSERT INTO yby_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Loko lokaiyoko, Pitamamo sa-loko lo miye: Ele-minape. Lemoya muki nesatehenama hulikoko emoki magoina nomonudanako, alikaya meinawa letudawo nehe. ");
INSERT INTO yby_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Loko lokaiyoko, Pitalesidama Jisesimamo sa-loko lo biye: Wehe loko lo libituyo, elilo. Wewena malokasiya numudanipo menakipanipo oluhonipo donipole ahonipohe ito ja ulanipohena monokamuye liki hulikiki nisiki nemesalo molataboya, ");
INSERT INTO yby_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yamidana apila malokaya ma mikaukaya napalo likilae, ito alikaya soto pitibo onawaloya elewole depa mutiya suwametibo nesa likilae, loko lo biye. 20 Eks 20:12-16; Dut 5:16-20 ");
INSERT INTO yby_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisesimamo unala ipalale yuhasidama dilipe makomaloka molokoko sa-loko lo biye: Elilo. Olotiya lemo Jelusalemu numutoka noyowune. Yaloka yowuniyoko, Omaimidana epaloti ga likaka wesiya okulumauti we uti nemodamu ohuwa hukiki labo ga maya niseko ulolotetiye. ");
INSERT INTO yby_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hetoka wewenasida dadeuya nilimi molikadeko, ulana molinitiki lahelamibo nesa lolo initiki etehu initiki ija initakilae. ");
INSERT INTO yby_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sa-ikiki uhedawaki nalalotiya kohane-liki kohaneli helikadeko, onawa loweki makoki yulaka minokoko helitubokutiya aku sinakoloe. ");
INSERT INTO yby_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Loko liyoko, eleboma eli wehe lamabo ne. Eli wehe litabo nesama jeko hitokaiyoko nenako, eli wehe lamabo ne. ");
INSERT INTO yby_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisesima woko Jeliko numutoka alili iye. Le alili ibo maya anu ilikalokaya omudala likaibo we mako ne. Minoko ehadamu wako loko minokaka iye. ");
INSERT INTO yby_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sako minoko muki wewenama wiki nisiki ayoko, monawamuya loka iyoko, ");
INSERT INTO yby_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Naseleti numutoti we Jisesima nonisiye. ");
INSERT INTO yby_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Liki layoko, ga napauti ju loko Jisesi Dewitida awolao, olisauti lilimitiye loko lo mololetaibo welika, nemodama milumane elenetowo. ");
INSERT INTO yby_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Loko liyoko, omutiki nisebo wewenasiya moletoko netiye liki auha meboya, ele hulikoko alukada moloko ju lidanaki Dewitida ouvamela olisauti lilimekaka welika, nemodama eke loneto. ");
INSERT INTO yby_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Loko liyoko, Jisesimamo anulo nebototima ilimi-liki nemotoka nisilo. Loko lokaiyoko, aya wema Jisesima nebotoka ilimi-liki nisikayoko, loka oetaidanaki ");
INSERT INTO yby_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","emoya nenaha nesama lolo oetatubomu nolane. Loko lokaiyoko omuda likaibo wemamo, we napanelika, omudaneya le olutonetatane loko noloe. ");
INSERT INTO yby_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Loko lokaiyoko, Jisesimamo sa-loko lo miye: Omudakaya halatideyo, nemodamu ele elewole adawolimo omudakaya le pana kogetokaiyo. ");
INSERT INTO yby_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Loko noliyoko, ayahasilo omudalama pana kiye. Pana ketokaiyoko, Jisesidama emesalo moloko nowidanaki Omaimidana epoka liye. Sa-noiyoko mudabo wewenamasiki asaiki Omaimidana epoka lae. ");
INSERT INTO yby_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisesima Jeliko numutokama nisekadanaki hulikoko wekolo noiyoko, ");
INSERT INTO yby_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","aya numuto we mako neboya uliya Sakiyesi, emoya takisi ehada likaka wesida uliki wenipo. Emoya uvaminala waitonebo we ne. ");
INSERT INTO yby_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sa-oneboya, aya weya we minawasi nenako, Jisesida upalo mudatuwe lokoko wewena luwawanipou nebo maya Jisesidama muda-elamoko, ");
INSERT INTO yby_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","omutoko lolosa jeko widanaki ya makomau yoweko nedanaki maloya minoyoko Jisesi maya maloka nisideko mudatuwe, ");
INSERT INTO yby_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","loko lokoko neyoko, Jisesimamo ayaloma woko mino sawa jeko muda-elokoko Sakiyesiyo, enemane oko lemo, olotiya emo numudakauka wesiye loko nonisoyo. ");
INSERT INTO yby_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Loko lokaiyoko, mulunauka lahelepa okaiyoko, enemane oko lemekoko Jisesidama ilime-loko numudalauka wiye. ");
INSERT INTO yby_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wiki yowikaiyoko muki wewenasiya mudaikiki auhala me, data lahelamibo kikikiya. Emo nenaha iyoko lahelamibo wemidana numudalauma yoweko ne. ");
INSERT INTO yby_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Liki likayoko, Sakiyesimamo We napamidana omudaloma sinoko sa-loko lo miye: We utinelika, elo. Ehada uvaminaneya ona moloko maloka maya uvaminanipo minamibo wewenasida bekoloe. Ito wewena malokasitoya suwaki namaki loko ehadanipo lekaka obotoya leko yoweko makoko lobotoya lowe lowe oko bituwe. ");
INSERT INTO yby_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Loko lokaiyoko, Jisesimamo sa-loko liye: Yamidana yowanu likaka niabo wewenasiya hetoka we netibo ne liki likaka niaboya, maya we Sakiyesiya Aebalahamuda ouvamela Juda weya wehe loko ne. Olotiya niseko emo numudalauya mudaoboma elewole epa mutiya lekaka nesama soto pekaiye. ");
INSERT INTO yby_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Okulumauti we uti nemoya leso iminatabo wewenamuya moneko ohu jeko olisauti dilimituwe loko lemobo maya ne, loko liye. 10 Mat 18:11 ");
INSERT INTO yby_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisesimamo Jelusalemu numudama le alili noiyoko, gala elebo wewenasiya oloti Omaimo ulilaki we napa le soto mololetatibo onawa maya alili okaiye liki data nikeyoko, Jisesimamo sako minamiye liki elitae loko koha moloko ga mako sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Uliki we napa makolimoya uliki we mako netibotoka woko lokadeko mika ujapalo wesida adakolinipokidana madonelo hitonetokadeko nisituwe loko hotoka wekolo noidanaki, ");
INSERT INTO yby_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","elekele oluhola lade maloka maloka suwiyoko lesa molo bekadanaki ehada owo makoko makoko oko nobeko edimoya malotiya liki wiki yowanu liki li obe nilideko, aku niseko mudatuwe. ");
INSERT INTO yby_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Loko lokoko wokaiyoko, aya wemidana oholau minabo wewena malokasiya mesaha jimikiki maloka wewenasidama doli hikayoko emeke maya wiki emoya mika ujapalo wete minametane loko nolune. ");
INSERT INTO yby_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Liki laboya, uliki we napamamoya mika ujapalo wesi adakolima alika mekaiyoko olo jekoko aku nisiye. Akuya woko elekele oluholalesida maya ehada bibo wewenama ju lokoko, ehada bibo maya yowanuwa likayoko woko nenaki nenaki ihe, likalo loko ju lokaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","elekele oluho makolimo niseko sa-loko liye: We napanelika, emokaho ehada owo makoko nemedawolotiya yowanuwa leko ehada owo lade maloka maloka suwiyoko le soto moloe. ");
INSERT INTO yby_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Loko liyoko, sa-loko lo miye: Emoya elekele oluho laloya minane. Wati oko yowanulo maya ujapa okane. Emoya yowanu lasolalo maya emesalo moloko lekadanako, olotiya nemo numudane ebane 10-pala nebo maya emokahoya ujapa we lolo oko ujapa etane. ");
INSERT INTO yby_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Loko lokaiyoko, elekele oluho makolimoya niseko sa-loko lo miye: We napanelika, emokaho ehada owo makoko nemedawolotiya yowanuwa leko ehada owo lade maloka suwiyoko le soto moloe. ");
INSERT INTO yby_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Loko liyoko wati okoe loko lokoko emoya numuda eba lade maloka suwibo wewenasidaya ujapa we lolo oko ujapa etane loko loetaiye. ");
INSERT INTO yby_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Loko lokaiyoko, makolimoya niseko sa-loko lo miye: We napanelika, emokaho ehada owo makoko ma nemedawo maya lawolawoloti wasa jeko etoha oko molo-minobototi maya leko nonisoe. ");
INSERT INTO yby_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Emoya osele we minadanako wewena malokasi yowanu lebotoya ihilawa soto pekaiyoko lekaka noane. Ito maloka wewenasi yowanu liki mija yuha ayoko o molaiboto nodenesagoya leko nokaka noane. Yamuya emodamu nomodane wokaiyoko ehadakama aha ujapa oko legeto-minoe. ");
INSERT INTO yby_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Loko lokaiyoko, ujapa wemamo sa-loko lo miye: Emoya lahelamadawo elekele we minaninako, emoka ladawotoya le welepa jeko obi yowanu nolegetoe. Nemo osele nobomidana monawaya ele-minane. Maloka wewenasiya yowanu lebotoya ihilawa soto pekaiyoko lekaka noe, ito maloka wewenasi mija yuha ikayoko o molaibotoya leko nokaka noe loko loboya monawane elekadawoya, ");
INSERT INTO yby_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ehadaneya ehada molikaka numukukaya leko woko molokadeko ayalo koli miki molinitiliki niyowideko alikaya woko litunako, nenaha iye. ");
INSERT INTO yby_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Loko lokoko amaitoka sini-minabo wewenasidama sa-loko lo biye: Ehada owo lenebo yaitaya likiki ehada owo 10-pala lenebo wemidanaya liki wiki milo. ");
INSERT INTO yby_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Loko liyoko, we napatelika, ehada lade maloka maloka suwiyoko owo maya alo lekaiye. ");
INSERT INTO yby_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Liki layoko, sa-loko lo biye: Nemoya ga mako lo libituyo, eli-minalo. Wewena makolimo saina mako le-minokoma, ujapa lalo nesa oko lenetiboya. Omailimo aku kolo meko mekolaiye. Sa-oneboya, saina mako ujapa lalo nesa ametibo wewenalimoya aha le-minohe loko ata elitiboya Omailimo aku hipo oko le eimolatoka molakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ito nemo ulanelo wesiya nemodamu ujapa we lolo ametane liki likaka abo wewenasida dilipi-liki nisiki nemo numudanelo maya kohaidi helilo. 26 Mat 13:12; Mak 4:25; Luk 8:18 ");
INSERT INTO yby_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Loko Jisesimamo lo bekoko Jelusalemu numutoka wekolo le omutoko nowiyoko, ");
INSERT INTO yby_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Oliwi ya bola ohalaloya numuda emesawa loweya Betepejeko ito Betenikoya le alili noidanaki, unala ipalale yuhauti we lowema doli nohidanaki sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Edimoya yolaya numutoka wikiya donki ja akalewa wewena emesalo monamabo donki jaya nala jiminatabo neyo, mudaikiki wina iki liki nisiliyo. ");
INSERT INTO yby_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wina iki liki niniseideko, we makolimo loka oko nenahamu wina niaiye loko lidekoma, We napamamo yowanu neyoko aya jamuya loli hekaiyoko niseko wina noiye liki li miliyo. ");
INSERT INTO yby_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Loko doli hekaiyoko, waiboma We napalimo liboto aya nesama soto piye. ");
INSERT INTO yby_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sa-okaiyoko, donki jamidana nalalama wina niaiyoko, ja aholasiya ja akalewaya nenaha iyoko wina niaiye, ");
INSERT INTO yby_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","liki layoko, We napamamo yowanu neyoko maya jamuya liyoko niseko wina noiye liki li beiye. ");
INSERT INTO yby_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Liki likaiyoko, ja aholasiya oo likayoko, donki jama Jisesitoka liki waiyoko, lasigu wikili olo jikaka niabo nesama ololo tikiki aya donkimidana emesalaloma molikayoko, ");
INSERT INTO yby_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jisesima yoweko yaloma minokoko nowiyoko, muki wewenamasiya lasi nesanipoma ololo tikiki anulo maya moli-liki wae. ");
INSERT INTO yby_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sa-niayoko, Jelusalemu numuda maya le alili oko Oliwi ya bolauti nolimibo anu maya le alili noiyoko, unala ipalale yuhamasiya elowa jiki elewole ganehena le soto molaibokumuya ga napauti Omailoka sa-liki epoka lae: ");
INSERT INTO yby_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","We napatemidana galaloya soto pekadanako, Omailimoya maku imitiye. Okulumauya hulu minadeyo. Omaimidana monawala maya onowelaki minadeyo. ");
INSERT INTO yby_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Liki likayoko, wavu-liki wewena minabokuti Palasisi we maloka ayauya miniki sa-liki lae: Ujapa welika, unaka ipakalesiya sa-liki lamilo loko lo hukobeto. ");
INSERT INTO yby_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Liki layoko, Jisesimamo sa-loko lo biye: Nemo wehe loko lo libekoloyo, elilo. Edimosi ga lamiki aha minataboya, maya ehadasiya ga napautiya nepoka likilae, loko liye. 38 Sam 118:26 ");
INSERT INTO yby_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sako niseko Jelusalemu numudama mudakoko uka nohiyoko sa-loko wije iye: ");
INSERT INTO yby_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Edimoya mulutipou hulu etibo ga maya eli hulikaka niaboya olotiya eli litanako. Sa-oneboya, monawaya suna onebo nenako domudalotiya mudai wehe lamikilae. ");
INSERT INTO yby_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yu makoya ulatipolo wesiya nisikiki numuda ebatipoya li wego ikiki yanala ehadaya li nupa ikiki oholaya molikiki ayalo yowikiki ");
INSERT INTO yby_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","oho ulauka limiki menakipa oluhotipokiya kohaidiki wau doli hikilae. Sa-ikiki numudatipoya luko-mako iki ehadaloti mupilalo mupilalo iki viliki yoweboya jiwi pasiwi iki suwikiki limikilae. Sa-itaboya, Omailimo edimoda dilimekolo edimotoka nisiboma eli wehe lamaboma nenako, yamidana nesaya edimotoka soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisesi maya sa-loko lokoko monoka numuda ohowau yoweko sainahena meina hikaka iki maketilo molabo wewenasidaya doli he huloko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Omailimo libo gama monoka bukuguma sa-likima luhuwa ji-minaboma ne: Nemo numudanemuya Omailoka domuda likikaka numudae liki lilo. Liki ji-minaboma neboya, edimoya ukelelo wesi suna iki minikaka niabo muliya lolo ikae. ");
INSERT INTO yby_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Loko lo bekoko muki yulakaya monoka numuda napauma monoka monawamu api-napi obekaka iye. Sa-noiyoko, Omailoka jokila hi mikaka weki ito monoka monawa api-napi ikaka weki ito Juda wewenasida ujapa wenipolekiya Jisesidama kohatabo anuwamuya ohu jeboya, ");
INSERT INTO yby_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","muki wewenasiya Jisesikaho libo galo maya ameme iki eliminayoko nenako, ujapa wesiya wewena olinipoya Jisesida kohatabo anuwa maya li soto amae. 46 Aes 56:7; Jel 7:11 47 Luk 21:37 ");
INSERT INTO yby_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sa-niayoko, Jisesimamo ya onawaloma monoka numuda napauma yoweko monoka api obetoko neyoko, Omailoka jokila hi mikaka weki ito monoka ujapalo weki ito monoka monawa api-napi ikaka wekiya Jisesitokama nisiki sa-liki loka itae: ");
INSERT INTO yby_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Maya monoka numuku aijo lolo adawo nesaya ekahida galalo lolo ane, ito ekahimamo liboto lolo ape, lo lemo. ");
INSERT INTO yby_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Liki loka itayoko, sa-loko lo biye: Nemokiya asako ga makoya loka olibetakoloyo, eli-minalo. ");
INSERT INTO yby_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Joniya monoka noku udobetokaka yowanu liboya nakahaukati le soto moloko liye. Omaimidana galalo lihe, ito wewenasida ganipolo liye. ");
INSERT INTO yby_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Loko loka obetaiyoko, edimonipolokaya sa-liki ligi hagi ae: Yaloya nenae loko letune liki data keha, sa-iyoko, lemokaho Omaimitokati ne loko letudawoya, sa-onenako edimoya nenaha iyoko Jonida gala eli datau molamae loko lekolainako, ");
INSERT INTO yby_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ito muki wewenasiya Jonidamuya Omaimidana epalauti ga lokaka we ne liki liminaboma nenako, yowanu liboya wewenasitoti le soto molaibo ne loko letudawoya ehadaloti kohalelakilae. ");
INSERT INTO yby_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Liki nieliki Jisesidama sa-liki li me: Joni maya ekahimamo liboto yowanu le soto ibo nehe yamidana monawaya elamune. ");
INSERT INTO yby_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Liki layoko, Jisesimamo sa-loko lo biye: Sa-likanako, saina-maina maya lolo okaka noboya ekahida galalo lolo okaka nohe yawakiya lo libamekoloe. ");
INSERT INTO yby_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Lokoko ga mako sa-loko Jisesimamo wewenasidama lo biye: We makolimo waeni mijaya yuha okoko ujapa we makosidaya ujapa initi-minadeko meinawa libituwe loko dadeu molokadanaki aito mikaloka woko onawa hana ne. ");
INSERT INTO yby_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Woko neyoko, ihilawa halatetibo onawama alili okaiyoko, ujapa abo wewenasidama ihilawama liyinitiki nisitae lokoko elekele we mako oli hekaiyoko wiboma, mija ujapa abo wewenamasiya aya wemidanama waeni ihilawama mamiki oli hikayoko ahaya lahowela nebotoka wiye. ");
INSERT INTO yby_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sa-ikayoko, elekele we makoya aku oli hekaiyoko wibo maya mija ujapa wemasiya kohaiki owana helitibo nesa lolo itiki ihilawama mamiki ahaya oli heyoko wiye. ");
INSERT INTO yby_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sa-ikayoko, makomamidana oli hekaiyoko wiboma upalama kohawi hukiwi ikiki huli hetoka molikayoko wiye. ");
INSERT INTO yby_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Sa-ikayoko, mija aholamamo nenaha etuwe. Ma ilimi lalo itahe nenimone nuka mobo ipaneda maya oli hoyoko wetiyo. ");
INSERT INTO yby_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Loko elekoko ipaladama oli hiyoko, woko ayaloya hetiyoko, maya mija ujapalo wewenasiya edimo minabotokaya sa-liki ligi hagi ae: Maya mika aholamidana ipalama nenako, alikaya ahola iloho molatiboya aya mija maya emokaho litibo nenako, koha helekuniyoko aholada uvaminalahenama lemo nesatego lolo etiye. ");
INSERT INTO yby_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Liki likiki waeni mijakutima ika-iliki wiki kohai hele. Saboya aya mijamidana aholama nisekoko aya ujapalo wesidama nenahama lolo obetatiye. ");
INSERT INTO yby_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aya welimoya nisekoko aya waeni mija ujapalo wesidama kohaidoko doli hekoko aito yuna itabo wewenasidaya leko hulobetadeko ujapa lalo nesa itakilae. Loko Jisesimamo lokaiyoko, elikiki edimomasiya sa-liki lae: I'i, ma sako minamiye, liki likayoko, ");
INSERT INTO yby_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","wenu nodelaidanaki sa-loko lo biye: Monoka bukugu ga mako sa-liki luhuwa ji-minaboma lepiki eli-minaboma neboya, data molokaihe: Numuda vikaka wewenasiya ehada napa mako mudai hulabomamo numuda ahodawa elewolewa lolo okoko ne. ");
INSERT INTO yby_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Wewena mako aya ehadaloya limi jitaboya, aya ehadalotiya idimadi iki li esa ikilae. Ito aya ehadalimoya wewena makomidana mupilalo lemo jitiboya, aya wewenama mijeko otele patele ekolaiye loko liye. 9 Aes 5:1 17 Sam 118:22 ");
INSERT INTO yby_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Loko lokaiyoko, Omailoka jokila hi mikaka weki ito monoka monawa api-napi ikaka wekiya aya koha moloko libo gayautiya ehadamu libo gaya Jisesida muda-elo huludawo gamuya lokaiyo. Likiki, ayalo maya adelo lekoko kohatune liki labo neha, wewenamuya Jisesida kohatudawoya wewenasi nenaha ilitatae likadanaki domodanipo wokaiyoko hulitae. ");
INSERT INTO yby_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Sa-okaiyoko, Jisesida kohatabo onawamu ujapa iki minikiki edimokutima we malokasida doli hikayoko, Jisesimamo opa ga mako letibokumuye liki ameme iki miniki lahelametibo ga mako lidekoma wehe lamidekoma, uliki wemidana lo mekuniyoko nala mitiye liki suwa nesa liki duka laloki wewenakidana weunipo moladanaki, Jisesidama sa-liki loka itae: ");
INSERT INTO yby_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tisate yamalae, emolikaya weya menaya api obetokaka noadawo nesaya wehe lokogo neyoko elekaka noune. Emoya muki duliki wewenahena ito aha wewenahenakiya makoko aweyaha okogo dilimekoko Omaimidana anulaya dilipekaka noane. ");
INSERT INTO yby_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Emoya nenae loko noelene. Lomu ebato gamanimidana we napa Sisadaya takisi ehada mekaka noudawoya wehe loko nesa lolo noupe, ito wehe lamibo nesa lolo okaka noune. ");
INSERT INTO yby_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Liki laboya, lahelamibo nesa ne loko lideyama gamaniloka obi oetatune, ito wehe loko nesa ne loko lideyama, Juda wewenasiya auha mitae. Liki ohumanau hiki labo gaya elekadanaki sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Edimosiya ehada mako nilipilo. Aya ehadalo nebo pikisa mayaki ito luhuwa mayakiya ekahida ne. Loko lokaiyoko gamani we napa Sisada maya ne. ");
INSERT INTO yby_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Liki layoko, sa-loko lo biye: Sako gamanimo wako letibo nesalama gamanimidana milo. Ito Omailimo wako letibo nesalama Omaimidana milo. ");
INSERT INTO yby_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Loko libo gamuya muki wewenasida dowisalo adelo likilaboya, Jisesikaho ohumanau hiki likaka abomidana elehuguti maya asekaiyoko aiye wuye labomuya dadelo eda iye. ");
INSERT INTO yby_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sa-ikayoko, edimo Sediyusi wewena helebokuti sinamitabo ne liki likaka niabo wewenanauti malokasiya nisiki Jisesidama sa-liki loka itae: ");
INSERT INTO yby_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tisate yamalae, Mosesekaho luhuwa sa-loko je lemeneboma ne: We makolimo menala lenetiboma oluhola etamoko mino-loko woko helekadekoma, unalakahoya aya eto menama lekoko yatolatoya oluho etoko ulilaloya molatibo ne loko luhuwa jenebo maya ne. ");
INSERT INTO yby_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sa-onenako, lemotokaya oluho unamotala 7-pala minabo ne. Sa-iki miniki ada welimo mena mako lekoko oluho etamoko helekaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","unalalimoya asa-okaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","unala makolimoya asa-okaiyoko, unala mota 7-palasiya makoko menagoya li yolalo malo iki li-liki niwiki oluhonipo etamiki heli suwikayoko, ");
INSERT INTO yby_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","aya eto mena maya minoko alikaya heliye. ");
INSERT INTO yby_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Saboya aya 7-pala wemasiya makoko mena maya li yolalo malo iki liki minabo nenako, heli-minatabokuti aku sinataboma aya menama ekahi menala lolo etiye. ");
INSERT INTO yby_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Liki likayoko, Jisesimamo sa-loko lo biye: Edimo oloti onawalo minabo wewenalitaya menakipaya meina hikaka niaboya, ");
INSERT INTO yby_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Omailimo wewena makomamuya heli-minatabokuti sinatabo aweyaha ne loko lobetonebo wewenasiya mena ma lamae, ito menama li bamae. ");
INSERT INTO yby_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Edimo okanaki wewenakidana iki helikaka amae. Heli-minatabokuti sinatabo wewenaya Omaimidana oluhola lolo iki ohotama depa mutiya liki minakilae. ");
INSERT INTO yby_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ito helebokuti sinokaka nesamuya lo libituyo, elilo. Mosesekaho ya nesamuya ga mako lo lemeneboma ne. Emoya ya ohugutiya jo uluma yowibo ga maya We napamuya ga mako sa-loko loneboma ne: Nemoya Aebalahamule Aesikile ito Jekopule Omainipo minobo we maya olotiya ahaya minoe. ");
INSERT INTO yby_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Loko libo nenako, helebo wewenasida Omainipo nehekala, weunipo aha nebo wewenasida Omainipo nenako, elewole depa mutiya likadanaki helebo wewena ito aha minabo wewenasida Omainipo ne. Helebo wewenaya Omaimidana omudalaloya weunipoya aha ne. ");
INSERT INTO yby_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Loko libo nenako, monoka monawa api-napi ikaka we malokasiya sa-liki li me: Tisate yamalae, wehe loko lokane. ");
INSERT INTO yby_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Liki ladanaki, akuya ohumanau hiki loka itabomuya domodanipo wokaiyoko loka itamae. 28 Dut 25:5 37 Eks 3:6 ");
INSERT INTO yby_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sa-nilayoko, Jisesimamo sa-loko lo biye: Lahelamibo nesauti dilimitiye loko lo mololibetaibo we maya Dewitida ouvamelago ne liki nenaha iyokoma likaka niae. ");
INSERT INTO yby_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dewitiya Omaimidana epoka liki nama liki itabo gautiya luhuwa mako sa-loko jeneboma ne: Yowau wemamo We napaneda maya sa-loko lo miye: Nemo nade lamawakaloka mino-loko woko minadeko, ");
INSERT INTO yby_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ulakalo wesida maya le hulo ika heumauka molobetakoloe. ");
INSERT INTO yby_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewitikahoya aya wemuya We napane loko lokaibo nenako, lahelamibo nesauti dilimitiye loko lo mololibetaibo weya nenaha iyoko Dewitida ouvamelagoya netiye. Dewitida We napalakiya netiye. 42 Sam 110:1 ");
INSERT INTO yby_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Loko Jisesimamo lokoko muki wewenasi eliminayoko unala ipalale yuhasidama sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Monoka monawa api-napi ikaka wemuya, ehetipoe. Dupalo kolikaka nesa hana kolatabokumuya, ito maketiloka maloka wewenasi aiye wuiye libitatabomu ito monoka numuku numukuya wewena dowisalo minikaka siyalo minatabokumu, ito nodenesa napa ataina itabo yupekaya epalo yeima netibo siyalo minatabo nesamu dumu helekaka noiye. ");
INSERT INTO yby_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Edimoya eto menakipasida uvaminanipohenaya ukele liki ito monoka wewenakidana iki depadunuya suwa liki Omaimidana epoka hana liki Omailoka domuda likikaka niae. Sa-inabo wewenasiya lihima napa edawakiya likilae loko liye. ");
INSERT INTO yby_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisesimamo monoka numuda napauma minoko uvaminanipoki wewenasi ehada molikaka bokisigu maya ehada nimolayoko mudaiye. ");
INSERT INTO yby_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Saki nimolayoko mudaibo maya uvaminala minamibo eto mena makolimo ehada ihilawa laho lowe maya leko niseko ayau maya nomolaiyoko mudakoko, ");
INSERT INTO yby_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","unala ipalale yuhasidama sa-loko lo biye: Ga mako lo libituyo, elilo: ");
INSERT INTO yby_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Maya wewenasiya wavu-liki moli-minabokuti hulaboya, eto mena mayalimo epa nesalalo hulo suwoikoko ayahasiya molonebokuti leko niseko hulaibo nenako, maya eto menalimo hulaibo ehadalimoya muki wewenasida asebetonebo ilekaiye, loko liye. ");
INSERT INTO yby_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Muki wewenasiya monoka numuda napa maya ehada laloloti viminaboki Omaidaya mikabo onowe lalo nesaya ayalo neboyaki mudaikiki depoka nilayoko Jisesimamo mudakoko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Edimo oloti maya nimudabo nesahenaya lowa wewenasi nisiki ehada mukiya kohaiki leda jiki hulikadeko, ehada mupilalo mupilalo iki moli-liki yowebokutiya hululuka jeko lemeko suwekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Loko lokaiyoko, edimosiya sa-liki loka itae: Tisate yamalae, oloti maya noladawo nesaya nena yupeka soto pitiye, ito nena ane maya soto pekadeko mudakoko ladawo nesa maya soto pekolaiye loko letune. ");
INSERT INTO yby_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Liki likayoko, sa-loko lo biye: Ehe, dokepa jitabokumuya ujapa ilo. Wavu-liki wewenasiya nemo nulinelo nisikiki nemo we napa maya nonisowe, ito onawa maya alili okaiye liki lideko maya, demesalo moliki wamilo. ");
INSERT INTO yby_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ito mika makomalokati lowa nihidekohe ito edimo mikatipouti lowa nihideko maya demesa tamideyo. Yamidana nesahenaya omutoko nisitiboya, muki nesahena maya enemane oko suwamekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Loko lokoko kolo meko aku sa-loko liye: Muki numuto namato wewenasiya ulanipolo wewenasida lowahina li nibideko, uliki we makomidana wewenalaki ito makomidana wewenalaki lowa hikilae. ");
INSERT INTO yby_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ito muki mikauka mima napa-napa noideko, nodekumu napa-napa helikilae, ito saina delatibo nesa napa-napa mako ayauya nisekolaiye, ito okulumaloya mulutipou hugili etibo nesa mako soto pideko ane napa-napa mako soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Sa-etiboya, aya nesahenaya owaha nisamideko dadelo likiki ulana molilibitiki dilipi-liki wiki nala numuku ito monoka numuku obi yowanu lilibitakilae. Sakiki nemo nulineya edimotoka nebokumuye liki dadelo likiki dilipi-liki wiki duliki wesida ito kiyapesida dowisaloya dilipi sinakilae. ");
INSERT INTO yby_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sa-ikadeko, edimoya nemo monawanemu elewole iki nielebo ga maya li soto moliki li bitabo ne. ");
INSERT INTO yby_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sa-itabo neyo, olotikogoya data eli wehe li-miniki sa-liki li hukalo: Obi yowanu nilibitadeko maya, nenae loko letudawo ne liki data etipa kamilo. ");
INSERT INTO yby_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nemokahoya ga litaboto depa ulumatipoya le aila jekoyoko litabo nenako, ulatipolo wesiya asilibitamikilae. ");
INSERT INTO yby_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Dotipole ahotipole yatotipole unatipole wewenatipole edimo minabo yuhauti maya dadelo likiki obi yowanu nilibitadeko edimokuti malokasidaya kohaidi helitayo. ");
INSERT INTO yby_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sa-nikiya nemo nuline edimotoka nebokumuye liki muki wewenasiya asowalaki nesaya lilibitataboya, ");
INSERT INTO yby_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","dukatipo mako woko opa amekolaiye. Okepaki epaki aha minakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Sa-etibo nenako, edimoya elewole iki sini-minataboya elewole depa mutiwakiya minakilae. 14 Luk 12:11-12 ");
INSERT INTO yby_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Saki miniki Jelusalemu numuda maya lowa wewenasi nisiki hiki wego nideko maya, numuda eba mukiya kohaki leda jiki mikataka jitabo onawa maya aloya alili okaiye liki lilo. ");
INSERT INTO yby_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sa-nideko, Judiya ebakuka minatabo wewenasiya oli li bolauka maya niyowideko Jelusalemu numutoka minatabo wewena maya aya numudanipohena hulataboya maya nihuladeko, Jelusalemu numutoka alili minatabo wewenahena maya yauya yowamitanage. ");
INSERT INTO yby_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aya onawaloya lahelamibo nesanipomidana lihimala bitibo onawa maya nenako, monoka bukugu luhuwa ji-minabo ga maya niseko yaloya ulolotekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Eke, oluhonipoki minatabo menakipahena ito oluhonipo amida ninatabo menakipahenama nenaha itahelae. Maya mikauka maya edawaki nesa soto pekadeko, Omaimidana epalo molatibo nesalimoya maya mikauka minatabo wewenasida mijebetakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sa-ikadeko maloka wewenasidaya sopololoti kohaidi helikiki maloka wewenasida maya nala numuku dilipi nimoladeko maloka hetoka wewenasi Jelusalemu numudahena maya mijiki otele iki mini-liki niyowideko, hetoka wewenasida onawanipo maya suwekolaiye. 22 Hos 9:7 ");
INSERT INTO yby_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Okulumalo holimo, ukadalimo, sonohilimoya aito-aitomidana nesa le soto nopideko, ela nolimoya lisada jeko sasa loko nolimideko wewenasi onowa elikiki domodanipo adoha wetibokumuya limi jiki pou liki niudadeko, ");
INSERT INTO yby_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","okulumalo elewoleyanipoki nesa mukiya momoga iki nisuwideko, aitomidana itabo nenako, sa-etibokumuya domodanipo wokoko domuda nana vokadeko ma mikauka elewole nesa maya soto pekolo noetibokumuya domodanipo adoha wetibo ne. ");
INSERT INTO yby_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sa-okadeko, okulumauti we uti nemoya elewoleyaneki onowenekiya limu mupilalo yowaya nolemoyoko muda-nelakilae. ");
INSERT INTO yby_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yamidana nesa soto nopideko maya, edimoya aya nesamidana maya mudaikiki sini wehe liki miniki lemoda lilimitibo onawa maya ayahasi alili iye liki elilo. 25 Aes 13:10; Joe 2:31; Lev 6:12-13 27 Den 7:13; Lev 1:7 ");
INSERT INTO yby_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Loko Jisesimamo lokoko koha moloko ga mako sa-loko lo biye: Ohuda ya sigolo yahe ito ya mako mudaikiki maya elilo: ");
INSERT INTO yby_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ya makolimo aila uluma silekaiyoko mudaikiki edimosiya howai onawa maya alo alili iye liki likaka niae. ");
INSERT INTO yby_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sa-liki likaka niabomidana oloti nolobo nesaya soto pekadeko mudaikiki maya, Omaimidana oholama soto pitibo onawa maya alo alili okaiye liki elilo. ");
INSERT INTO yby_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nemoya wehe loko lo libituyo, elilo: Oloti maya minabo wewenaya owaha heliki suwamideko aya nolobo nesaya soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Okulumaki maya mikakiya wiki leso isaibo neboya, nemo ganeya woko leso amekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ehe, edimo weutipoya ujapa lalo ilo. Nei molokaka nesalimo ito nei no nokaka nesalimo ito data etipa kikaka nesalimo eda delokadeko onawa napaya edimotoka enemane oko soto pekatiyo. ");
INSERT INTO yby_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Aya onawa napaloya elehukidana oko muki maya mikauka numuto namato wewenasidaya kohaidakolaiye. ");
INSERT INTO yby_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Edimodaya Omailimo elewoleya libekadeko aya sako soto pitibo nesamidana mini olowe niki okulumauti we uti nemo nowisalo sino-minatune liki Omailoka liki ujapa i-liki wiki minalo. ");
INSERT INTO yby_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Loko Jisesimamo lo bekoko muki yupeka maya monoka numuda napau ga lo bekoko lubu jiyoko Oliwi ya bolau maya yoweko udokaka iye. ");
INSERT INTO yby_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sa-okaka iyoko nenako, muki yupeka maya muki wewenasi nekewa napaya nisiki monoka numuda napau maya Jisesitokati ga elikili li esa ikaka ae. 37 Luk 19:47 ");
INSERT INTO yby_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lulu jamibo beleti nikaka abo holi onawa napa uliwa esenipo vobetaibo onawae loko alili okaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Omaimitoka jokila hi mikaka weki ito monoka monawa api-napi ibikaka abo wekiya wewenasidamu domodanipo wokaiyoko, Jisesidama kohatabo anuwamu ohu jikiki suna i-minae. 2 Eks 12:1-27 ");
INSERT INTO yby_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sa-ikayoko, Jisesida oluhola unala ipalale yuha 12-pala minabokutiya Kaliyoti numutokati we Judasida maya olohalimo ukau lemeko ilime lolowa okaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","woko Omaitoka jokila hi mikaka we napaki ito monoka numuda napau imi wekiya Jisesida adelo liki kohatabo gahenaya li koheboya, Jisesida maya mimi oko ilime-loko edimotoka nisitibokumu sa-etibo molatibo gahenaya liki kohe. ");
INSERT INTO yby_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Liki likayoko, matoka wewenamasiya elowa jikiki omolu ehada Judasidama metune liki lae. ");
INSERT INTO yby_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Liki layoko, Judasimamo donoto lekoko muki wewena li esa amideko Jisesidama mimi ekolo mabada hiye. ");
INSERT INTO yby_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lulu jamibo beleti nikaka onawa esenipo vobetaibomidana holi onawamuye liki sipisipi ja akalewamidana kohaikaka onawa maya alili okaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisesimamo unala ipalale yuhauti loweya Pitako Jonikosida maya doli nohidanaki edimoya wiki esenipo vobetaibo holimidana nodenesala maya li lolowa ikadeko lemoya woko natune. ");
INSERT INTO yby_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Loko lo bekaiyoko, nakahaukama nodenesa le lolowa oetasiye loko nolane. ");
INSERT INTO yby_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Liki laiyoko, Jisesimamo sa-loko lo biye: Eliliyo. Edimoya taonilokaya wiki hetikiki we mako mika somolauya nolaki heko lenetibo wemidanaya hotula ikikima aya wemidana emeke moliki wiki yowitibo numuku maya magoina yowiliyo. ");
INSERT INTO yby_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yowikiki numuda aholamidana maya sa-liki li miliyo: Tisatemamo nemoki unanele ipanele yuhamaki esenipo vobetaibo nodenesa natudawo lumu maya nakahauka ne loko liyoko lo noemoiye. ");
INSERT INTO yby_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Liki likadeko, lumu sahayaya alo mupilalo newelusaki netiboya dilipitiye. Sako dilipitibo numuku maya nodenesa li lolowa iliyo. ");
INSERT INTO yby_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Loko lokaiyoko, wiki mudaibo maya Jisesimamo lo bibo nesa leko neyoko mudaikiki, esenipo vobetaibo holimidana nodenesala maya li lolowa aiye. ");
INSERT INTO yby_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sakiya li lolowa ikaiyoko, nodenesa natabo onawa maya alo alili okaiyoko, Jisesima aposololale yuhamakiya magoina miniki nodenesa maya niki minae. ");
INSERT INTO yby_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sakiya niki minayoko, Jisesimamo sa-loko lo biye: Maya esenipo vobetaibo nodenesaya owaha miluma elamoko magoina edimoki minoko natune loko muluneuka dowa liyoko ele-minobo ne. ");
INSERT INTO yby_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sa-oneboya, ga mako lo libekoloyo, eli-minalo. Aya nodenesaya alika magoina edimoki minoko namoko mino-loko woko alikaya Omailimo ujapa wetipo lolo olibetatibo onawa maya soto pekadeko nakoloe. ");
INSERT INTO yby_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Loko lokoko oda mako leko Omaimidana epoka lokoko sa-loko liye: Edimoya maya liki ona moliki nalo. ");
INSERT INTO yby_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ga mako lo libituyo: Oloti onawalotiya waeni noya ihilawauti aku namodanaki mino-loko woko Omaimidana ujapa wetipo lolo olibetatobo onawamidana elewoleyala maya soto pekadeko natuwe. ");
INSERT INTO yby_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Loko lokoko beleti mako lekoko Omaimidana epoka lokadanaki poseko nobeko sa-loko liye: Beleti maya nemo milawanema ne. Sa-noyo, nemodamu eli-minikima niki minalo. ");
INSERT INTO yby_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Loko lokoko nodenesama nikayoko, waeni no odama asako lekoko sa-loko lo biye: Maya odauya nemo olodanelimo ga lo mutihekaka ga ohatama lo mutihekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sa-oneboya, mudalo. Nemoda mimi etibo wekiya makoko sipalo minoko makoko lapeuya ladeya limiyoko magoina nodenesaya leko nonoiye. ");
INSERT INTO yby_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Okulumauti we uti nemodaya wo loko noli hibo anuloka woko helitubo anu nowoboya, nemoda mimi etibo weya lihima napa-napa lekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Loko lokaiyoko, unala ipalale yuha minabotoka maya agae, ekahimamo sa-etibokumu lihelae likadanaki, edimonipo minabotoka maya ligi hagi iki loka loka ae. 21 Sam 41:9 ");
INSERT INTO yby_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sakikiya unala ipalale yuha maya lemokuti ekahimamo uliki we lolo etiye liki lowa-sawa ae. ");
INSERT INTO yby_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sa-ikayoko, Jisesimamo sa-loko lo biye: Ma mikaukaya aha wewenasiya elekele ibitiki diuka limiki minayoko, duliki wewenasiya ujapa ibitikaka niae. Ito duliki wewenasiya lepoka litae liki likaka niaboya, ");
INSERT INTO yby_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","edimotokaya sako minamideyo. Edimokutiya yowiki minabolawasiya limiki minabo wewenakidana limiki minatayo. Ito ujapa wetipolesiya limiki miniki wewenasida elekele wenipo lolo iki minatayo. ");
INSERT INTO yby_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Edimoya ma lilegae, ekahima uliki we nehe. Nodenesa aha minoko natibolimohe, ito nodenesa le lolowa oko ataina etibolimohe. Aha minoko nodenesago noikaka oko netibo welimo uliki we netiboya, nemoya luwawatipouya aya duliki wewena suda lamoko elekele oluhokidana lolo oko minokaka noe. ");
INSERT INTO yby_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nemoya asowalaki nesamidana ulauya minoko, edimokiya ayauya magoina miniki nilimi wati ikaka niae. ");
INSERT INTO yby_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ahonekaho ohonelo ujapa etane loko lonetaibomidana ikigo edimoya sa-itae loko nololibetoe. ");
INSERT INTO yby_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Edimoya nemo ohoneu miniki nodenesatipohena niki minadeko elowa jituwe loko ito onowelaki siyalo miniki Isilaelo wewena nala 12-palasidaya ujapa ibitiki miniki ona molibitakilae loko noloe. 24 Luk 9:46 25 Mat 20:25-27; Mak 10:42-44 26 Mat 23:11; Mak 9:35 27 Jon 13:12-15 30 Mat 19:28 ");
INSERT INTO yby_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Saimoniyo, laisi pipiyawa usiki li eto ikaka niabomidana olohalimo niseko edimoya adelauya minikadeko usoko dilipe eto ekolo loneboya, ");
INSERT INTO yby_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","nemoya ele elewole adawolawaya lemo jekatiye loko Omailoka lokaka noe. Sa-oneyo, yamuya emoya aku monoka anuloya ilime molokadeko iwekalesida maya he elowo obeto. ");
INSERT INTO yby_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Loko lo mekaiyoko, Pitamamo sa-loko lo miye: We napane yamalae, emodaya nala numukuhe ito kohaeli helitabohe nemoki magoina wekoloiye. ");
INSERT INTO yby_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Loko liyoko, Jisesimamo sa-loko lo miye: Pitao, ga mako lo imituyo, elo: Oloti lubukaya okoleya owaha onowa lamideko loweki makoki yupekaya nemoda yuwawa molonetakolane. ");
INSERT INTO yby_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Loko lokoko sa-loko loka obetaiye: Omutoko doli noheko maya ehada owoki ito uka jekaka owoki ito dilo sumaki liki wamilo loko lo libobo yupeka maya, saina makokumu ohu jebo nehe. Loko liyoko unala ipalale yuhasiya o'e. ");
INSERT INTO yby_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Liki likayoko, Jisesimamo sa-loko lo biye: Sa-ikabo neboya, oloti maya onawaloya we makolimo aya owo maya lenetiboya leko wetiye. Ito sopolo hana le-minametibo welimoya lasi owolaloti maya ehada lekoko sopolola meina hitiye. ");
INSERT INTO yby_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nemoya wehe loko lo noliboe. Monoka bukuguya ga mako sa-liki luhuwa ji-minabo ga maya olotiya nemotoka niseko ulolotekolaiye: Lahelamibo nesa likaka wesikutiya emokiya ne liki lepi-minaboma ne. Ito monoka bukugu nemodamu muki luhuwa jebo maya nemotoka niseko ulolo notiye. ");
INSERT INTO yby_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Loko lokaiyoko, edimosiya We napate yamalae, mudao: Sopolo hana lowe maya ne. Liki likayoko, nemo gane maya ele wehe lamayo, ayahasiye loko lo biye. 35 Mat 10:9-10; Mak 6:8-9; Luk 9:3; Luk 10:4 37 Aes 53:12 ");
INSERT INTO yby_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Loko lokoko hetoka lemeko omutoko lolo okaka ibomidana lolo ekolo Oliwi ya bolau maya noyowiyoko, unala ipalale yuhasiya magoina wae. ");
INSERT INTO yby_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Oliwi ya bola alili nowidanaki unala upalale yuhasida maya sa-loko lo biye: Edimoya maloya miniki muluteu hitabokumuya woko opa-napa okatune liki Omailoka domuda likiwa likiwa iki i-minalo. ");
INSERT INTO yby_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Loko hulobikadanaki emo maya lasolasima widanaki i bola heko Omailoka sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ahonelika, sa-etuwe loko elekoko nemotokatiya edawaki nesahena li ohinitatabo nesaya le olowe etadawo ne loko noeloboya, nemo nata elituboto nehekala emoka letadawoto soto pideyo. ");
INSERT INTO yby_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Loko noliyoko, okulumauti okanaki we mako lemekoko he elowo oetaiye. ");
INSERT INTO yby_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sa-okaiyoko, miluma napa-napa noelidanaki abuha moloko Omailoka noliyoko, owiya elaibo maya oladamidana oko mikauka maya le-loko limiye. ");
INSERT INTO yby_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sa-noiyoko, Omailoka loko nebototi maya unala ipalale yuha minabotoka aku nisekoko lahelamibo nesa soto pitibokumuya domuda udiminayoko, dilipe sinokoko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Edimoya nenahamu domuda niudae. Edimoya sinikiki mulutipou hitabokumu woko opa-napa okatune liki Omailoka domuda likiki minalo. ");
INSERT INTO yby_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Loko lo beko neyoko, Jisesida unala ipalale yuhauti we makoya Judasimamo le omutiyoko muki wewenamasiki nisiki Jisesima nebotoka li esa ae. Sa-ikayoko, Judasimamo Jisesida okepa liyeko nakolo nebotoka mino alili noiyoko, ");
INSERT INTO yby_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jisesimamo sa-loko lo miye: Judasiyo, nemo okulumauti we uti maya nokepa liyeko noko mimi ekolo nonisepe. ");
INSERT INTO yby_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Loko liyoko, Jisesida unala ipalale yuhasiya mudaikiki soto pekolaibo nesamuya sa-liki lae: We napate yamalae, sopololotiya kohaidatupe. ");
INSERT INTO yby_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Liki ni-liki edimokuti we makolimo Omaimitoka jokila hi mikaka wesida we napanipomidana elekele oluholadama sopololoti koha helituwe loko kohaiboya, mino olowe noiyoko atalago koha hulikaiye. ");
INSERT INTO yby_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sa-iyoko, Jisesimamo yamidana nesaya lamo lokoko adeloti aya wemidana atalo le noelidanaki ilime haka loetaiye. ");
INSERT INTO yby_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sakoya ilime lalo okadanaki, Omaimitoka jokila hi mikaka we napaki ito monoka numuku imi weki ito monoka ujapa wehenamakiya Jisesida adelo letune liki ninisebo wewenasidama sa-loko lo biye: Edimoya nemo ukelelo we minoyoko sopoloki ito mainahaki liki nisiki nadelo letune liki ninisehe. ");
INSERT INTO yby_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Muki yupekaya edimoki monoka numuda napau magoina minokaka obo maya nadelo lamabo maya nehao. Saboma neboya, olotiya edimo onawatipo neyoko lubumidana ahola olohamidana elewoleyala maya soto piye. 53 Luk 19:47; Luk 21:37 ");
INSERT INTO yby_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Loko lokaiyoko, Jisesida maya adelo liki ilimi-liki wiki Omaitoka jokila he mekaka we napamidana numudalauma yowe. Sa-niayoko, Pitama hoto apulu oko demeke demeke oko nowiyoko, ");
INSERT INTO yby_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","aya numuda lekuka maya jo jikiki minae. Saki minayoko, Pitamakiya magoina aya joto maya woko ne. ");
INSERT INTO yby_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sako neboya, emoya jo uluma wibotoka maya jo lapi oko neyoko, elekele mena makolimo muda-eloko wenu wenu noidanaki sa-loko liye: Maya weya Jisesite minikaka niaibo we maya ne. ");
INSERT INTO yby_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Loko liyoko, Pitamamo yuwawa moloko ma menalae, nemo muda-elamobo wemuya nolane. ");
INSERT INTO yby_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Loko lokoko lasolasi neyoko, we makolimo Pitadama aku muda-elokoko Jisesida nalalauti maya minane. Loko liyoko, Pitamamo ma welae, ma yauti minamoe. ");
INSERT INTO yby_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Loko lokoko lasolasi neyoko we makolimo pelesa jeko emoka Galeli onoki we minadanako, wehe loko aya yuhautiya minane. ");
INSERT INTO yby_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Loko liyoko, Pitamamo ma welae, emo noladawo gaya ma elamobo ga nolane, loko nolibo epaki okole maya onowa molaiye. ");
INSERT INTO yby_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sakoya onowa noliyoko, We napamamo mino wili jeko Pitada maya wenu elaiye. Sako muda-elokaiyoko, we napalimo Pitada loetaibo ga maya okole onowa owaha molamideko loweki makoki yupekaya yuwawa nomolonetadeko lekolaiye loko libo ga maya aku elekoko, ");
INSERT INTO yby_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","uka hekaiyoko lemeko hetoka wije napa-napa liye. ");
INSERT INTO yby_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sa-okaiyoko, Jisesida adelo li-minabo wewenasiya unala molitiki okepa jedanaki dadeloti nikohaiki ");
INSERT INTO yby_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","omudalaloma lawolawoloti wasa jimikiki sa-liki lae: Ekahimamo nokohaelaihe, ma duli logae. ");
INSERT INTO yby_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Liki likiki liwi letiwi iki aito-aitomidana gahena litiki minae. ");
INSERT INTO yby_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sakiya minayoko, go maya lokaiyoko, monoka ujapa wesiya Omaimidana jokila hi mikaka we napaki ito monoka monawa api-napi ibikaka wekiya li esa ikiki monoka kanisolesida domudalo Jisesida maya ilimi-liki wikiki, ");
INSERT INTO yby_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","emoya lahelamibo nesauti lilimitiye loko Omailimo lo mololetaibo we minape, lo lemo. Liki likayoko, Jisesimamo sa-loko lo biye: Nemokaho lo libituboya, edimosiya wehe loko liye liki lamikilae. ");
INSERT INTO yby_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ito aya nesamu loka olibetatuboya, ma nonoto liki li nemamikilae. ");
INSERT INTO yby_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sa-oneboya, oloti maya onawaloti alikaya nemo okulumauti we uti elewole we Omaimidana ade lamawakaloka minakoloe. ");
INSERT INTO yby_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Loko lokaiyoko, sa-liki li me: Sa-loko noladawoya emoya Omaimidana ipala minoe loko nolape. Olo. Liki likayoko, oo, wehe liki galoya lae. ");
INSERT INTO yby_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Loko lokaiyoko, aya wewenasiya sa-liki li me: Emo gala eli-minatabo wewena mako nenahamu ju lokoko gala eletune. Eimola epalauti sa-loko lokaiyoko alo elekudawo maya nenako. ");
INSERT INTO yby_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Liki likayoko, muki wewenasiya sinikiki Jisesida maya uliki we Paelatima nebotoka ilimi-liki wae. ");
INSERT INTO yby_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ilimi-liki wikiki api iki obi itiki sa-liki lae: Maya welimo lemo Juda wewena lilime opa okaka noidanaki Lomu wewenasida gamani we napanipo Sisada maya takisi ehada mamilo loko lokoko eimoladamu nuliki we napa maya lahelamibo nesauti dilimitiye loko lo mololibetaibo we maya minoe loko lokaka noiye. ");
INSERT INTO yby_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Liki likayoko, Paelatimamo Jisesida maya sa-loko loka oetaiye: Emoya Juda wewenasida uliki wenipo napa maya minape. Loko loka oetaiyoko, Jisesimamo wehe loko lokadawoyae. ");
INSERT INTO yby_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Loko lokaiyoko, Paelatimamo Omaitoka jokila hi mikaka we napaki ito muki wewenasidamakiya sa-loko lo biye: Maya wemidana olisala ohu joboya ma minamiye. ");
INSERT INTO yby_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Loko liyoko edimosiya pelesa jiki sa-liki lae: Emokahoya muki wewenasida dilipe topa idanaki Galeli mikauka api o-loko woko Judiya mikaukaya wo suwokoko ga monawa api-napi idanaki sa-oloko oloti mayalo nisiye. ");
INSERT INTO yby_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Liki likayoko, Paelatimamo ganipo maya elekoko aya weya Galeli we nehe. ");
INSERT INTO yby_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Loko loka obikoko Jisesima i-liki we Helotikaho ujapa ibo ebatokati we neyoko mudakoko ito Helotima aya yupekaya Jelusalemu numutoka minaibo nenako, Heloti netibotoka ilimi-liki wilo loko oli hekaiyoko ilimi-liki wae. ");
INSERT INTO yby_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sa-ikayoko, Helotiya Jisesida gala maya hapa yeikala eleneboto nenako, Jisesikaho adoha elewole nesa mako lolo okadeko mudakoko letunako loko ata kekoko Jisesida maya muda-elaibo maya elowa jibo ne. ");
INSERT INTO yby_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sa-iyoko nenako, Helotimamo Jisesikaho muki oko moloko ibo nesamu loka oetaiboya, Helotikaho libo galo maya ma onoto leko le wili jeko lo mamiye. ");
INSERT INTO yby_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sa-noiyoko, Omaitoka jokila hi mikaka we napaki ito monoka monawa api-napi ibikaka wekiya amaitoka sini-miniki helitiye liki dabuha moliki obi yowanu litae. ");
INSERT INTO yby_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Sakiya emo olisala ohu jiapulu iki Helotile muki maloka wewenasikiya lahelamibo ga litae. Sakiya lahelamibo gahena litikiki, uliki we napamidana upalo nesa lalo maya li kolimikiki, Helotimamo aku Paelatima nebotoka oli he molokaiyoko, akuya ilimi-liki wae. ");
INSERT INTO yby_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sa-ikiki hapa yeikalaya Paelatiko Helotikoya ulanipolo we lolo iki minaibo neboya, yalotiya aku yowo moli niki ouna jeiye. ");
INSERT INTO yby_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sakikiya Paelatimamo muki we mena ito Omaitoka jokila hi mikaka we napaki ito monoka ujapalo wesidamaki dilipe nupa okoko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Edimoya maya wemidana ilimi-liki nemoto nisiki muki wewenasida dilipe topa okaka noiye liki laboya, edimotipokiya magoina minoko domudaloya olisalamu ohu joboya, edimosi olisa ibokumu obi noetune liki laboya olisala ohu joboya ma minamiye. ");
INSERT INTO yby_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Helotikahokiya asakoko olisalamu ohu jiboya minamiyoko, nemotoka oli hekaiyoko nisiye. Sa-okaiyo, elilo: Aya welimo lahelametibo olisa nesa mako lolo etidanako, koha hulatipa, sako minamiyo, ");
INSERT INTO yby_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","nemokaho letubotoya seida oijoloti kohaikiki numudalaloka oli hideko wetiye loko liye.  ");
INSERT INTO yby_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ito Paelatimamo esenipo vobetokaka holigu melekeu melekeu maya nala numuku minabo wewenasida le hulobetatane liki duli maya likayoko aya wewenasida makoko makoko oko doli he hetoka hulokaka iyoko numudanipoloka wikaka ae. ");
INSERT INTO yby_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sa-onebo nenako, edimosiya imiya liki sa-liki lae: Maya weya okepa usitiye. Sa-idekoma Balabasida maya olutomikadeko aku numudalaloka wetiye. ");
INSERT INTO yby_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Liki laboya, Balabasiya Jelusalemu numutokaya gamani wewenaki lowahina lebotoka we makomidana kohako heliyoko, ilimi-liki nisiki nala numuku hulimikayoko nebo we ne. ");
INSERT INTO yby_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sa-iyoko nenako, Paelatimamo Jisesida maya oli he hulatuwe loko aku loka obetaibo maya, edimosiya gala elamiki pelesa jiki, ");
INSERT INTO yby_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","yoho yaha yalo helitiye, yoho yaha yalo helitiye liki lae. ");
INSERT INTO yby_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Liki likayoko, Paelatimamo aku sa-loko lo biye: Nenahamuye. Nena olisa okaiyoko helitiye liki nilae. Emo kohai helitabo olisala mako le soto molamoe. Sa-onenako, nemokahoya lokoyoko seida oijoloti kohaikiki oli hikadeko numudalaloka wetiye. ");
INSERT INTO yby_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Loko liyoko, aya wewenasi Paelati libo galo maya kohaki yoho yaha yalo nalawa oko teto liki labo galimoya Paelatimidana gala maya kohaiye. Sa-iyoko nenako, Paelatimamo libo ga maya mumu lamiye. ");
INSERT INTO yby_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Sa-iyoko nenako, Paelatimamo edimo laboto demesalo molatuwe loko liye. ");
INSERT INTO yby_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Loko lokoko omutoko gamani wewenaki lowahina leko we mako koha heliyoko nala numuku huliti-minabo wemamidanaya oli he hulikoko edimonipo data kitabo nesa lolo itatae loko Jisesidama imi wesida dadeu molaiye. ");
INSERT INTO yby_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sa-okaiyoko, Jisesida maya kohakili ilimi-liki niwayoko, anulokaya we mako uliwa Saimoniya Sailini we neboya, ohugukati le taoniloka wetuwe loko nowibotokati anulo neyoko adelo likiki yoho yaha ya maya ohimikayoko ohekoko Jisesida maya emeke moloko wiye. ");
INSERT INTO yby_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sakikiya niwayoko, muki we menaya emeke moliki niwadanaki menakipamasiya milumala elitikiki wije nama litimi wae. ");
INSERT INTO yby_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sa-imi niwayoko, Jisesimamo mino wili jeko sa-loko lo biye: Jelusalemu menakipalitaya, nemokumu wije nama lamiki edimotipo oluhotipolesida ito edimotipolesidamukiya wije nama lilo. ");
INSERT INTO yby_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Onawa mako alili noinako, ya onawa soto nopideko maya sa-liki litayo: Oluhonipo etamabo menakipa ito oluho amida liyamabo menakipasidamuya wati iki minae liki litabo neyo. ");
INSERT INTO yby_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Liki likiki aya onawaloya bola napa makomidanamuya bola yowayalae, niseko jeko hitoletowo liki likilae. Ito bola lasolahenamukiya nisiki lemoda jiki hitilitalowo liki likilae. ");
INSERT INTO yby_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Loko lokoko sa-loko lo biye: Nemoya ohatama jokidana minoboya, nemodaya aha joku jitabo nenako, edimoya opatibo jo maya minanako, edimodaya aha joku jitabo nenako nenaha itahelae. ");
INSERT INTO yby_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Loko lokaiyoko, olisalo we loweki ito Jisesimakiya kohaidakili dilipi-liki wae. ");
INSERT INTO yby_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sakiya dilipi-liki wiki eba makoya madonipo abuhawa ebae liki labotoya hetikiki, Jisesidama yoho yaha yalo nilimi itae. Sa-ikiki olisalo we lowesida maya mako maya ade lamawakaloka tiki ito mako maya ade atahakaloka titae. ");
INSERT INTO yby_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Sa-ikayoko, Jisesimamo ahonelika, eli wehe lamiki opa-napa nesa nileyo, lihimanipo le hulobeto, loko liye. Loko lokaiyoko Jisesida upalo nesa maya ekahoma litihe ekahoma litihe liki lopo-topo likadanaki kasikidana ono makoya molae, asitibo wemamo Jisesida upalo nesa maya litiye likadanaki. ");
INSERT INTO yby_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sa-niayoko, muki wewena maya li esa iki miniki mudai-minae. Sa-niayoko, Juda wewenasida ujapa wenipolesiya lahelibo lahelamibo ga nilitiki emoya wewenasida dilimekaka we Omailimo nilime eto onebo we lahelamibo nesauti dilimitiye loko lo mololibetaibo wema minoe loko moneko lokaka ibo we maya nenako, eimolaya yowalotiya lemo mikalo matoka jeko wetinako, nenaha iyokoma noliye liki lae. ");
INSERT INTO yby_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Liki likiki imi wesiya lahelamibo ga litiki liwi letiwi itikiki ekesa waeni no ma natihe liki hiki nimiki, ");
INSERT INTO yby_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","emoya Juda wewenasida uliki wenipo minokoma eimokadaya ilimowo. ");
INSERT INTO yby_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Liki ni-liki isa madonalokaya luhuwa mako sa-liki jikayoko nebo ne: Maya weya Juda wewenasida uliki wenipomae. ");
INSERT INTO yby_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sa-niayoko, lahelamibo nesa likaka aibo we loweuti makomalamamo Jisesida lewo letowo oko sa-loko liye: Emoya lahelamibo nesauti lilimitiye loko lo mololetaibo wema minatadawoya eimokadaya noilimeko lemodakiya lilimowo. ");
INSERT INTO yby_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Loko liyoko, makomalamamo auha meko sa-loko lo miye: Emoki lemokiya obi nilitiki helitae liki lilitiminabo maya nenako, noheleko Omaimidanamu oli emamihe. ");
INSERT INTO yby_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Loko lokoko, sa-loko liye: Lemodaya lihimatemuya kohaleli niheleboya wehe loneboya, maya weya lihimala minamibo we neboya hakupa galoya kohai nihele. ");
INSERT INTO yby_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Loko lokoko Jisesida maya sa-loko lo miye: Jisesiyo, emoya uliki we napa lolo oko nisitadawo yupeka maya nemodamuya ata molametiye loko noloe. ");
INSERT INTO yby_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Loko liyoko, Jisesimamo sa-loko lo miye: Nemo wati gaya lo emekoloyo, ele-mino. Oloti eba lalou emoki ouna jeko minakoloiye. 30 Hos 10:8; Lev 6:16 34 Sam 22:18 ");
INSERT INTO yby_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Loko noliyoko, holiloya ho aha luwato neyoko muki ma mikauka maya lubu je suwokoko mino-loko woko 3 kiloku iye. ");
INSERT INTO yby_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sa-iyoko, monoka numuda ateto Omaimidana owisalalo yowikaka ateto imaha molabo lawo-lawo maya yowa epaloti maya luwakuma boloto-loko lemeko le maloka maloka moloko pasiye. ");
INSERT INTO yby_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sa-iyoko, Jisesimamo ga napauti ahone aliyo, nemo weunema adekauya nomoloe. Loko lokadanaki ahu lo nohuloko heliye. ");
INSERT INTO yby_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sa-iyoko, lowa ujapalo wemamo soto pibo nesa maya mudakoko Omaimidana uliwa le sawa jeko maya weya wehe loko nebo we ne. ");
INSERT INTO yby_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Loko liyoko, aya nesa mudatune liki li esa iki minabo wewenasiya mudaikiki miluma napa elikiki ikinipolo jimi jimi numudanipoloka maya wae. ");
INSERT INTO yby_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Sa-niayoko, emo iwelaleki ito Galeli ebatokati emeke moliki nisebo menakipakiya alo hoto apulu iki sini-miniki aya soto pibo nesa maya mudae. 45 Eks 26:31-33 46 Sam 31:5 49 Luk 8:2-3 ");
INSERT INTO yby_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Sa-ikayoko, we mako neboya uliwa Josepu. Emoya Judiya eba mako uliwa Alimatiyao loko nebo ebatoti we ne. Emoya we lalo ito wehe lonebo weya Juda wewenasida monoka kanisolenipouti we ne. ");
INSERT INTO yby_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Sa-iboya muki kanisolesiya Jisesida kohatune liki lowa jiwi moneyoko emoya ele bamibo welimoya Omailimo uliki we ilime soto pitibokumu ujapa oko nebo we ne. ");
INSERT INTO yby_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Sakoya nebo we nenako, aya welimoya Jisesida onowa lekolo woko Paelatidama loka oetaibo maya Paelatimamo oo lokaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","emoki we malokaki yaloti maya pasiki li mikalo molikiki lawo-lawo ukulo lalo nesaloti wasa jimikiki liki wiki ehada numuku wewena owaha ono molamabokuya molitae. ");
INSERT INTO yby_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Falaideu maya liki wiki ale jitae, esenipo vibo holi onawa maya alili noiyoko. ");
INSERT INTO yby_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sa-noiyoko, Galeli ebatokati Jisesida emeke moliki nisebo menakipasiya Jisesida maya nena-nenakoma ale jetatihe liki Josepuda emesalo moliki wiki ono molikaka ebato maya miniki mudai-minae. ");
INSERT INTO yby_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sakiya mudaikiki numudanipoloka wiki onowalo maya nuwala wibo netupa hiletatune liki li lolowa ae. Sakikiya holiguya Juda wewenasi li huki-minaboto maya moletiki minaboya, ");
INSERT INTO yby_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sadeu maya nekewa napaya ono molabo ebatokama wikili nuwala wibo netupa li lolowa iki molabo nesama liki wae. ");
INSERT INTO yby_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wiki mudabo maya ehada numuda epawalo ehada napaloti moli li li-minabo maya alo ipisiki li huli-minayoko mudai-minabo ne. ");
INSERT INTO yby_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Sa-iminayoko, yau maya yowiki mudaboya, We napa Jisesida onola maya mudamabo ne. ");
INSERT INTO yby_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sakiki datauka upe-nape okaiyoko, sa-niabotoka we lowema alinali nisiki apinipoloka maya sini-minaiboya, dupalo nesalimoya ukulo hege-pege lokoko nebo ne. ");
INSERT INTO yby_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sa-iki minaiyoko, mudaidikiki aya menakipa maya domodanipo wokaiyoko mikauka maya lipi-minae. Sa-niayoko, aya we lowemasi sa-liki li be: Helebo wewenasida ebanipouya weunaki sinoko nebo wemuya nenahamuya ohu nije. Aya we maya mauya minamiye, alo hapa sinokaiye. ");
INSERT INTO yby_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Edimodaya Galeli ebakuka minoko lo libibo gamamugoya data kiki minalo. ");
INSERT INTO yby_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","8","Liki likaiyoko nenako, Okulumauti we uti nemoya lahelamabo wewenasida dadeu nilimi molikadeko yoho yaha yalo kohaneli helikadeko loweki makoki yupeka minokoko aku sinakoloe loko, hapa lo bibo galo maya aku data kikikiya, ");
INSERT INTO yby_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ono molabo eba maya hulikiki aku li welepa jiki wikiya emo unala ipalale yuhauti 11-palamaki ito maloka wewenakiya mudabo nesamu wetome iki li bebo maya, ");
INSERT INTO yby_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Meleya Magadala ebatoti mena ito Jowanale ito Jemisida dola Melele ito maloka menakipakiya aya ga maya wetome iki aposolosida maya li beboya, ");
INSERT INTO yby_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","aya aposolosiya watiya nilae liki data kamabo ne. ");
INSERT INTO yby_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sa-liki nilayoko, Pitamamo lolosa jeko woko ono molabo aleu maya lipeko mudaiboya, lawo-lawo ukulo lowemago neyoko mudakoko aku le wili jeko numutoka woko mudaibo nesamuya ata etipa keko nebo ne. 56 Eks 20:10; Dut 5:14 6 Luk 9:22; Luk 18:31-33 ");
INSERT INTO yby_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sa-iyoko, aya yupeka maya Jisesida wewenalauti we lowe maya Emause numutoka wikili waiye. Emause numudaya Jelusalemu numudaya hulikoko hoto apulu oko 11 kilomitakidanaya ne. ");
INSERT INTO yby_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Sakiya niwiki Jisesitoka soto pibo nesamuya wetome-katome i-liki niwaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jisesima luwawanipoukatiya soto pekaiyoko, magoinaya waboya, ");
INSERT INTO yby_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","domudalo hitoneyoko Jisesima ne liki mudai wehe lamaiyoko, ");
INSERT INTO yby_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisesimamo maya gaya nenaha ibokumu wetome-katome i-liki niniseiye loko liyoko, we lowema anulo sini-miniki dokepa lahelamiyoko, ");
INSERT INTO yby_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","makomalaya uliwa Kiliyopasiyo loko nebo welimoya emo liboto onoto leko sa-loko lo miye: Muki wenoka wewenahena ito Jelusalemu numutoka wewenahenakiya oloti soto pibo nesamuya eli suwiminaboya, emo makokoya elamape. ");
INSERT INTO yby_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Liki laiyoko, nenahama soto pibokumu nilaiye loko akuya loka obetaiyoko, edimotokati we makolimo sa-loko lo miye: Jisesi Naseleti wemamuya noloiye. Emoya Omaimidana epaloti ga lokaka we ito Omaimidana omudaloki muki wewenasida domudalokiya elewole anehena ito adoha nesa elewoleya aitomidana le soto molokaka oko nebo we ne. ");
INSERT INTO yby_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sa-ibo neboya, lemo ujapa wetele ito Omaimitoka jokila hi mikaka wetelesiya helitiye liki obi itikayoko nenako, yoho yaha yalo kohaiki tikayoko helenebo wemu noloiye. ");
INSERT INTO yby_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ito omutokoya Isilaelo mikaukaya ulatelo wesida dadeuti lilimitihe loko ele-minudawo neboya, ga mako sa-loko ne: Aya nesa soto piboya onawa loweki makoki oko wokaiyoko ne. ");
INSERT INTO yby_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sa-oneboya, lemokuti maloka menakipasi nisiki layoko elekoko ololo okune. Aya menakipasiya nekewa napa go lo mikalo molamiyoko ono molabo ebatoka wiki, ");
INSERT INTO yby_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mudabo maya, Jisesida onowama mudamiki okananipoki we lowesiya ale epaloma miniki Jisesima alo sinokoko wokaiye liki laibo gamuya wamokidana likaiyoko aya menakipamasiya nisiki li leme. ");
INSERT INTO yby_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sa-ikayoko, lemokuti we lowemasi wiki mudaibo maya menakipasi laboto hekaiboya, aya wemidana upalo mudamaiye. ");
INSERT INTO yby_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Liki laiyoko, Jisesimamo sa-loko lo biye: Edimoya aha nei moliki minaiye. Edimoya mulutipo eha jeneyoko Omaimidana epaloti ga likaka wesi luhuwa ji-minabo ga maya lepiki eli elewole amaiye. ");
INSERT INTO yby_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Omailimo dilimitiye loko lo mololibetaibo wemidanaya miluma nesa li ohimikadeko helekoko alikaya lameda letiye loko sinakolaiye liki luhuwa ji-minabo maya ne. ");
INSERT INTO yby_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Loko lokoko Mosesekaho luhuwa jibo ga ito Omaimidana epaloti ga likaka wewenasi luhuwa jebo gama wetome oko beloko nowoko, eimoladamu monoka bukugu luhuwa ji-minabo ga maya muki wetome oko lo beloko woko suwiye. ");
INSERT INTO yby_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sa-loko lo beloko ninisikiya, Emause numuda alili nisiki emo maya aya numudama hulikoko aseko wekolo noiyoko, ");
INSERT INTO yby_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","aya we lowemasiya ata liki homa lemekoko lubu jekolo noinako, lemokiya magoina woko udatune liki laiye. Liki laiyoko, Jisesimamo oo lokaiyoko aya we lowesida numudanipou maya magoina yowe. ");
INSERT INTO yby_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sakiya yowikiki emo maya mitoka nedanaki beletima leko Omaitoka epoka loko omuda likoko poseko biye. ");
INSERT INTO yby_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sa-noiyoko, yalotima domudama pana kekaiyoko, Jisesidama muda-eli wehe laiye. Sakiya muda-eli wehe nilaiyoko, enemane oko woko tolowa iye. ");
INSERT INTO yby_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sa-okaiyoko nenako, edimosiya sa-liki wetome-katome aiye: Anuloka maya monokahena lo limidanaki monoka bukugu nebo gahena maya wetome oko lo lemeko muluteuka maya le lameda loko le eha jeletaiye. ");
INSERT INTO yby_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Liki wetome-katome ikiki enemane iki Jelusalemu numutoka maya li welepa jiki waiye. Wiki unala ipalale yuha 11-pala aha minabolawaki ito iwenipole malokakiya li nupa iki minayoko mudaikayoko, aya we lowesida maya enemane iki ga maya wetome iki, ");
INSERT INTO yby_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","We napate maya wehe loko aloya sinokoko Saimonida omudalo maya soto pekaiye. ");
INSERT INTO yby_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Liki likayoko edimomasi Jisesima anuloka demeke moloko woko nodenesa nakili beletima posiboto muda-eli wehe laibo ga maya wetome iki li beiye. ");
INSERT INTO yby_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Unalale ipalale yuhamasi aya ga maya wetome-katome niayoko, enemane oko Jisesimamo luwawanipouti soto pekoko huluya edimotoka minadeyo. ");
INSERT INTO yby_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Loko liyoko, muda-elaboma olohalimo soto pekoko lihe liki domodanipo adoha wonebo ne. ");
INSERT INTO yby_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Liki data nikeyoko, sa-loko lo biye: Edimoya nenahamu domodatipo nowiyoko data lowe nike. ");
INSERT INTO yby_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nemo Jisesima minohao. Ni nadeloka hulane maya mudalowo. Saki mudaikiki nisiki nupalo likiki mudaneli wehe lilo. Nemoya wewena dupakidana wehe loko nupaneya ne, olohaya wewena suda liki minamae. ");
INSERT INTO yby_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Loko lo bekoko ila adela maya dilipiye. ");
INSERT INTO yby_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sa-iyoko nenako, malokasiya wehe loko liye liki datauka lahelepa adoha one. Ito malokasiya data lowe nikeyoko, Jisesimamo edimotokaya nodenesa mako nehe. ");
INSERT INTO yby_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Loko liyoko, joto ataina i-minabo lawaha mako mikadanaki, ");
INSERT INTO yby_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","mudai-minayoko, adelotima leko naiye. ");
INSERT INTO yby_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sakoko Jisesimamo sa-loko lo biye: Nemoya edimoki magoina minudanaki sa-loko lo libekaka obo maya ne: Mosesekaho lo hukoko libo gauti ito Omaimidana epaloti ga likaka wesi labo gauti ito Omaimidana epoka liki nama likaka niabo gauya nemokumu ohuwa hukiki ga luhuwa ji-minaboma niseko ulolotekolaiye. ");
INSERT INTO yby_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Loko lokoko monoka bukugu nebo ga maya eli wehe litae loko data le golotoko lo beko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Monoka bukuguya lahelamibo nesauti dilimitiye loko lo mololibetaibo wemuya luhuwa sa-liki ji-minabo ne: Miluma nesa le oheko helekoko onawa loweki makoki yupekaya aleu minokoko helenetibokuti aku sinakolaiye liki luhuwa ji-minabo maya ne. ");
INSERT INTO yby_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ito aya wemidana uliwaya muki numuto namato li bikadeko eli suwiki elikiki muki wewenasiya duka li wili jikadeko, lihimanipo hulobetakolaiye loko lone. Ito aya yowanuya Jelusalemu numutokaya api iki limi witae liki luhuwa ji-minabo maya ne. ");
INSERT INTO yby_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aya nesa maya mudabokumu li soto moliki litabo wewena maya edimoya minae. ");
INSERT INTO yby_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Eli-minahe, ahonekaho weuna oluhomidana maya edimotoka oli hituwe loko lo mololibetaibo maya yoweko doli hekoyoko edimotokaya lemekolaiye. Sa-etubo neyo, edimoya enemane iki maya ebaya hulikiki wamiki ujapa iki gamaloya minalo, elewoleya maya okulumauti likiki witayo. 49 Apo 1:4 ");
INSERT INTO yby_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Loko lokoko numutoti dilipe-loko Beteni numuda alili adeloti maya sisiwanipo jeko makuya biye. ");
INSERT INTO yby_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sako maku nobeko hulobetokoko wiye. ");
INSERT INTO yby_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sa-iyoko, edimo mulunipouka maya aila uluma siliyoko Jelusalemu numutoka maya aku li wili jiki wiki, ");
INSERT INTO yby_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Omaimitoka jokila hi mikaka numuku maya yowiki muki yupeka maya Omaimidana epoka likaka iki minae. ");
INSERT INTO yby_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sainahena api oko soto pibo onawalo yeimaya Omaimidana epalau galo nebo welimoya minowa minowa o-loko niseko nebo we ne. Sakoya Omaimidana amaitoka mino moloko ne. Ito Omaimidana epalau galo nebo weya Omaiya ne. ");
INSERT INTO yby_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aya welimoya api oko Omaitoka mino moloko ne. ");
INSERT INTO yby_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sakokoya muki nesahenaya lolo oko le soto piye, ito emoya ata elamibotoya sainahena mako soto pamiye. ");
INSERT INTO yby_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Aya welimoya elewole oko minokakamidana ahola lolo okoko muki wewenasidaya elewoleyala lamedalalimo he lameda lobetaiye. ");
INSERT INTO yby_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lamedalalimoya lubu jiboku maya he lameda lobetaiyoko nenako, lubulimoya lamedalamidana asetamiye. ");
INSERT INTO yby_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Sakokoya, Omailimo we makomidana ilime eto okoko oli hekaiyoko woko soto pibo wemidana uliwa Joni. ");
INSERT INTO yby_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Sa-iyoko, aya welimoya muki wewenasiya gala maya elikiki lamedalamidana emesalo molatae loko lamedamidana gala maya lo soto moloko ne. ");
INSERT INTO yby_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sa-iboya, Joniya lamedamidana ahola minamiye, aha lamedamidana aholada galagoya lo soto moloko ne. ");
INSERT INTO yby_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lamedamidana ahola maya muki numuto namato wewenasida he lameda lobetokaka noibo weya, ya yupekaya alo maya mikauka soto pekoko neyoko ne. ");
INSERT INTO yby_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ma mikau nebo nesa mukiya Omailimo eimola elewoleyalalotigo le soto pibo maya ne. Sakoya le soto pekoko alikaya mino-loko nowoko lemeko maya mikauya soto piboya, maya mikau wewenasiya aya wemidanaya muda-eli wehe lamae. ");
INSERT INTO yby_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Sa-ikayoko, eimola le soto pibo ebaku maya soto piboya, Juda wewenala yuhasiya lemokuti neyo likiki ilimi damaitoka molamabo ne. ");
INSERT INTO yby_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sa-oneboya, aya wemidana li uka jebo wewenala maya Omaimidana wewenala yuha lolo itae loko anu wilebetonebo maya emodamuya elewole iki elitabo wewenaya sa-itae loko aya welimoya ele benebo ne. ");
INSERT INTO yby_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sa-iboya, donipolesi etabototiya Omaimidana wewenala lolo iki ohatama soto pamae, ito oladamidana anulau wiki ohatama soto pamae. Makoko Omailokatigoya wiki ohatama soto pikaka niae. ");
INSERT INTO yby_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Omaimidana epalau galo nebo welimoya woko wewena lolo idanaki, luwawateu minoko nasahili oletaidanaki, ga ulawa lo limidanaki, lowa-lawa nesa lolo oko api-napi o limiyoko mudaune. Emoda okulumau lamedaya mudaudawoya, ipalakaho aholada makoko lameda lolo iyoko mudaune. ");
INSERT INTO yby_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Sa-ibomidana monawaya Jonikaho ga napauti sa-loko lo soto molaiye: Nemokaho aya wemuya omutoko nemo soto pamoyoko hapa yeikala nebo we nenako, aya weya alika nemeke yaitaya nonisibo weya nemoda asenetoko ne loko lo libobo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Lemo muki wewenaya Jisesikaho nasahili adoha lemekaiyoko aha lekoko minokaka noune. ");
INSERT INTO yby_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Omailimo liboto Mosesekaho lo hukoko libo gamago luhuwa je limiboya, Jisesi Kalaestikaho leko yoweko nasahili maya aha nesakidana oletaidanaki, ga ulawa maya lo limiye. ");
INSERT INTO yby_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Omaimidanaya wewena makolimo mudaelamiye. Sakoya ipala makoko eimolaya Omaiya ne. Sakoya ipalakaho aholada amaitoka nedanaki, aholada monawala maya mudakoko leko lemeko lemoda maya api-napi oletaiye. 6 Mat 3:1; Luk 3:1-2 ");
INSERT INTO yby_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jelusalemu numutokati Juda wewenasida ujapa wesiya Omaitoka jokila hi mikaka wehena ito monoka numuda napau ujapa wehenakiya doli hikayoko Jonitoka wiki sa-liki lae: Emoya nenamidana we maya minane, lahelamibo nesauti lilimitane loko lo mololetaibo we maya minape, liki loka itayoko, emo monawala maya ");
INSERT INTO yby_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","yuwawa molamoko lo soto moloko sa-loko lo biye: Nemoya lahelamibo nesauti dilimeko huka libituwe loko lo mololibetaibo we maya minamoe. ");
INSERT INTO yby_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Loko liyoko, aku loka itadanaki, sa-liki lae: Sa-inako, emoya nenamidana we minane. Olisauti lilimitiye loko Omailimo lo mololetaibo weya awahaya nisemiko okulumauti ewa nominudawo we Ilaija maya minape. Liki layoko, Jonimamoya nemoya Ilaija minamoe loko liyoko, akuya sa-liki lae: Emoya Omaimidana epaloti ga lokaka we maloka ewa ominudawo we Mosesekidana we maya minape, liki labo maya, o'e, loko lokaiyoko, ");
INSERT INTO yby_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","sa-lokaniyo emoya ekaho minane. Lemoya emotoka loli hikayoko nonisudanako, woko nenae loko lo betune. Emokadamuya nenae loko nolane. ");
INSERT INTO yby_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Liki loka itayoko, Joni maya sa-loko lo biye: Omaimidana epaloti ga lokaka we Aesayakaho ga mako monoka bukugu sa-loko luhuwa mako jibo maya nemotoya niseko ulolotiye. Sa-loko luhuwa jibo ne: Mumusopa mikaloka we makolimo ga napauti sa-loko noliye: We napamidana anula maya dukauka li wehe liki wilitalo, loko libo ne. ");
INSERT INTO yby_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Loko liyoko, Palasisi wewenasi doli heyoko Jonitoka wabo wewenasiya akuya loka itiki sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Sa-inako, emoya lahelamibo nesauti lilimitiye loko lo mololetaibo we maya minamane, ito Ilaija maya minamane, ito Omaimidana epaloti ga lokaka we lemo ewa ominudawo we maya minamadawo nenako, nenaha iyoko wewenasida monoka nokuya udobetokaka noane. ");
INSERT INTO yby_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Liki layoko, Joni maya sa-loko lo biye: Nemoya wewenasida monoka noku udobetokaka noboya, luwawatipou yaitaya we mako soto pekoko neboya muda-eli wehe lamae. ");
INSERT INTO yby_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aya welimoya nemeke moloko nisewa nisewa noiye. Aya wetoya nemo kohamonako, elekele oetoko yowanu lasola mako letatubokiya kohamoe, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Loko libo nesa maya Beteni numutoka Jodani nomidana yola helegaloka maya nokuya udobetokaka noiboto soto piye. 21 Mal 4:5; Dut 18:15,18; 23 Aes 40:3 ");
INSERT INTO yby_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sakiya udikiki go maya lokaiyoko Jisesima Joni nebotoka nisiye. Alo hoto apulu oko nonisiyoko, muda-elokoko wewenasida maya mudalo, yomaya Omaimidana sipisipi jala akalewa maya muki numuto namato wewenasida lihimanipo maya elelalo yowekaiyoko oheko leko nonisiye. ");
INSERT INTO yby_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aya wemidanamuya sa-loko lo libobo maya ne: Nemoya soto pamoyoko hapa yeikala nebo we nenako, alikaya nemeke moloko nonisibo weya nemoda asenetoko ne, loko lobo we maya yaya ne. ");
INSERT INTO yby_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nemokiya omutoka aya weya muda-elo wehe lamoboya, edimo Isilaelo wewenalikaya aya wemidana gala wetome oko lo liboyoko elitae loko niseko api oko monoka noku maya udolibetoe. ");
INSERT INTO yby_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Sa-loko lokoko, akuya aya ga maya wetome oko sa-loko liye: Nemoya okulumauti Omaimidana weuna oluholimoya nama ijopakidana lemeko aya wemidana madonalo lemo nojiyoko mudaoe. ");
INSERT INTO yby_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nemoya omutoka aya wemidanaya muda-elo wehe lamobo maya neboya, monoka noku udobetokaka yowanulo noli hibo welimoya sa-loko lo nimibo ne: Omaimidana weuna oluholimo lemeko madonalo nedeko mudatadawo welimoya Omaimidana weuna oluhola le ohelibetakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Loko Omailimo libotoma lemeko neyoko mudakonako, aya weya Omaimidana ipala wehe loko ne, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Udokoko go maya lokaiyoko, nemoki ito Jisesida unala ipala yuhauti lowemaki aya ebato maya minune. ");
INSERT INTO yby_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Minokokoya Jisesima anu moloko nonisuniyoko, Jisesi maya numuda makomaloka wiyoko muda-eludanaki, lemoda maya Jonimamo sa-loko lo limiye: Omaimidana jala akalewa tomaya mudaliyo. ");
INSERT INTO yby_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Loko liyoko, muda-elokoko Jisesiki maya magoina wune. ");
INSERT INTO yby_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nowoiyoko le welepa jeko mudalidokoko, Jisesimamo edimoya nenaha iyoko niniseiye loko liyoko, maya we lowemasiya lemo gateuti Labiyo, lokoya lemo gateutiya monoka ujapalo wetelikae loko, emoya nakaha numuku minokaka noane. ");
INSERT INTO yby_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Loko loiyoko, nisiki mudaliyo lokoko lilime-loko woko numudala maya lilipiyoko mudoiye. ");
INSERT INTO yby_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mudaokoko ho maya le yohotokayoko 4 kiloku okaiyoko nenako, ayaloka maya magoina mino molune. Jonida gala eleko Jisesiki magoina monudawo we loweutiya, makoya uliwa Enduluya, Saimoni Pitada unala. ");
INSERT INTO yby_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Sa-iyoko, aya we Endulukaho enemane oko yatola Pitadama muda-elokoko sa-loko lo miye: Olotiya lemo Mesaeyada maya mudakuiye. Mesaeyaya Juda wewenasida ganipouti, ito Kalaestiya Giliki wewenasida ganipoutiya ulilamidana monawaya lahelamibo nesauti lilimitiye loko lo mololetaibo we loko ne. ");
INSERT INTO yby_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Loko lokoko, Jisesitoka ilime-loko wiyoko muda-elokoko sa-loko lo miye: Emo Saimonilika Jonida ipala maya ulika Sipasiyo loko nomoloe. Sipasiya Juda wewenasida ganipouti, ito Giliki wewenasida ganipoutiya Pitada ulilamidana monawaya ehadakidanae liki likaka niae. ");
INSERT INTO yby_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Udokoko go maya lokaiyoko, Jisesi maya Galeli ebatoka wetuyo loko ata kekoko nolibotokaya, Pilipida maya muda-elokoko, emoki magoina wesiye loko lo miye. ");
INSERT INTO yby_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Loko liboya, Pilipile ito Pitale Endululeya makoko Betiseda numutotigo minae. ");
INSERT INTO yby_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ito Pilipimamoya Nateniyoloda maya muda-elokoko sa-loko lo miye: Mosesekaho lo hukoko libo gamaki ito Omaimidana epaloti ga likaka wesiki labo we maya olotiya mudakune, Naseleti numutokati Josepuda ipala Jisesida mayae, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Loko liyoko, Nateniyolomamo Naseleti numutokatiya saina lalo mako nenahama soto pitiye, Loko liyoko, Pilipimamo sa-lokaniyo, niseko mudao. ");
INSERT INTO yby_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Loko liyoko, Nateniyolomamo niseko Jisesida maya mudaiyoko sa-loko liye: Maya weya Isilaelo we wehe loko nenako, ukauya suwa ga mako minamibo we ne. ");
INSERT INTO yby_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Loko liyoko, Nateniyolomamo loka oetoko sa-loko liye: Emoya nakahalokama minoyoko muda-neladawo ne. Loko liyoko, Jisesimamo sa-loko liye: Pilipikahoya ilime-loko owaha nisamiyoko figiyae labo yuyukidana elibo yamidana monalo maya emogo minaniyoko muda-elobo maya ne loko liye. ");
INSERT INTO yby_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Loko liyoko, Nateniyolomamo sa-loko liye: Monoka ujapalo we yamalae, emoya wehe loko Omaimidana ipala minane. ");
INSERT INTO yby_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Loko liyoko, Jisesimamo sa-loko liye: Yuyukidana elibo ya monalo minaniyoko muda-eloe lobotoya elekoko nemodamuya elewole oko ata kepe. Elo. Oko moloko nobo maya aha aweyaha ne. Saina ulawaya alika mudako elekolane. ");
INSERT INTO yby_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Loko lokoko akuya amida meko sa-loko liye: Nemokahoya wehe loko lo emekoloyo, ele-mino. Edimoya okuluma golotideko Omaimidana okanaki wela maya okulumauti we uti nemotoka yowiki limiki nideko mudakilae, loko liye. 51 Jen 28:12 ");
INSERT INTO yby_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Numuda lowe udikiki Kana numutoya, Galeli ebakuka oluho mako menala ikilayoko, Jisesida dola maya ayaloka woko neyoko, ");
INSERT INTO yby_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisesida unala ipalale yuha lemodakiya lesa moli limikayoko woko magoinaya minoko nodenesa nonuniyoko, ");
INSERT INTO yby_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ayau minabo wewenasiya waeni no maya niki suwi hulikayoko, Jisesida dolamamoya niseko sa-loko Jisesida lo miye: Waeni no maya niki suwikae. Saina mako lolo etadawo nehe. ");
INSERT INTO yby_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Loko liyoko, Jisesimamo maya menalae, nenaha iyoko niseko nemotoka nolane. Yatoka nemo nesane ne. Nemo elewole adoha nesa lolo etubo onawa maya owaha nehao. ");
INSERT INTO yby_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Loko liyoko, dolamamo elekele welalesida maya saina makomu nolideko maya, emesalo moliki lolo ilo loko lo biye. ");
INSERT INTO yby_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ito Juda wewenasiya monokamuye liki dupa nokalawe ikaka abo nenako, aya numukuya no oda napa-napa ehadaloti lolo abo 6-pala nebo ne. Aya no odauya waitetiye liki ehada somo lade maloka maloka suwiyoko noya hiki kisikaka niabo ne. ");
INSERT INTO yby_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sa-ikaka niabo nenako, Jisesimamoya elekele welalesida maya wiki no maya hiki no oda napau maya kisilo loko liyoko, no maya hiki kisiwa kisiwa ayoko, aya no oda maya waitoko epawamogo iye. ");
INSERT INTO yby_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sa-ikayoko, Jisesimamo sa-loko lo biye: Sa-ikiki hiki liki wiki nodenesalo ujapa noibo wemidana maya milo. Loko lokaiyoko, hiki liki niwayoko, ");
INSERT INTO yby_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aya nomamo waeni no maya lolo okaiyoko, nodenesa ujapa ibo wemamo noko elibo maya lahelepa okaiyoko, nakahauti maya soto pihelae lokoko soto pibo monawa maya elamiye. Waeni noya soto pibolawaya elekele wemasigoya mudai-minae. Sa-iyoko, nodenesa ujapa ibo wemamo mena ada ibo wemamidana maya ju loko sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Muki wewenasi waeni no lahelepa ibolawa maya hiki bimi wayoko niki niki dukauka opa napa okaiyoko, alikaya lahelamibo waeni no maya hiki bikaka niae. Sako maya neboya, waeni no lalowa maya emokaho le suna o-minoko alika le soto moladawoya wati okoe loko lo miye, nodenesa ujapalo wemamoya. ");
INSERT INTO yby_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sa-iyoko, Jisesimamoya Kana numuto Galeli ebakuka maya api oko noloti le waeni lolo oko eimola elewoleyala maya lilopekaiyoko, unala ipalale yuha lemoya yalotiya Jisesidamuya elewole oko lata ke mune. ");
INSERT INTO yby_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sa-ikayoko, Jisesima Kana numuda maya hulikoko Kapaniyamu numutoka maya lemeko nowiyoko, dolale aholale unala ipapalale yuha lemoya emeke moloko wune. Sakoya lemoya lemeko yalo maya hana minamuniyoko, ");
INSERT INTO yby_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda wewenasida esenipo vobetaibo holi onawa maya alili okaiyoko, Jisesi maya Jelusalemu numutoka yoweko wiye. ");
INSERT INTO yby_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yalo maya Jisesi maya yoweko mudaiboya, bulumaka jahena ito nama luhukidana elibo namahena maya Omaitoka jokila he metudawoe liki, ito aito aito mikaukati ehadahenamaki liki nisiki aya mikauti ehadamaki li ohatama iki minayoko, Jisesimamo mudaidokoko ");
INSERT INTO yby_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","lepa nalakidana elibo nalaloti mijikiki oijo lolo i-minabo mako lekoko wewenahena ito aito-aitomidana jahena maya kohaidoko doli he hula hula iyoko, oli niwayoko, ehada li ohatama iki minabo namabeta maya le hululuka jeko hulikoko aya ehadahena maya leko lomala jeko hulikoko, ");
INSERT INTO yby_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","nama luhukidana nama liki nisiki molabo wesida maya sa-loko lo biye: Ahoneda numudala maya nodenesa meina hikaka numuda lolo amilo. Matoka nalabetahena liki wiki hetoka lolo itayo, liki wilo. ");
INSERT INTO yby_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Loko Jisesimamo lokaiyoko, unala ipalale yuha lemosiya monoka bukuguya ga mako sa-loko nebomu elune: Emo numudakamuye loko nemo muluneu itihina ibolimoya nemoda kohanelo helitibo nesa lekaiye. ");
INSERT INTO yby_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sa-iyoko, Juda wewenasida ujapa wenipolesiya sa-liki li me: Emoya yamidana mamidana noadawoya ekahida galalo sa-noane. Saina mako le oha okoko emoya okaka noadawo nesamidana monawaya wehe loko lilipamane. ");
INSERT INTO yby_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Liki layoko, donoto leko edimo monoka numuda maya leda jikadeko, onawa loweki makoki yupeka minoko nemokahoya aku le sinoko vetubo ne. ");
INSERT INTO yby_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Loko liyoko, onoto liki lemo latatelesiya maya monoka numudaya meleke 46-pala oko wiboya, owaha viki suwamabo numuda maya nenako, emoya onawa loweki makoki yupekago voko hukatuwe loko nolape. ");
INSERT INTO yby_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Liki laboya, Jisesi maya upalamuya le monoka numuto moloko liye. ");
INSERT INTO yby_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kohaiki ale jitabokuti maya onawa loweki makoki yupeka minoko sinatibo gamuya koha monoka numuto moloko liye. Sakoya liyoko, alikaya unala ipalale yuhalikaya aya nesamu monoka bukugu nebo gamaki ito Jisesikaho libo gamakiya niseko ulolotiyoko elekoko ele elewole oko elune. 08 Mat 4:13 13 Eks 12:1-27 17 Sam 69:9 19 Mat 26:61; Mat 27:40 ");
INSERT INTO yby_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisesi maya esenipo vobetaibo holi onawau maya Jelusalemu numutoka minoko, monawala maya mudatae loko oliwaki nesa aito-aitomidana lolo iyoko, muki wewenasiya mudaikiki olisauti lilimekaka we ne niki eleboya, ");
INSERT INTO yby_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jisesimamo muki wewenasiya data kebo monawanipo maya muda suwiyoko nenako, emoya uliki we lolo etibo ne loko ele bamiye. ");
INSERT INTO yby_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jisesikahoya we makomidana monawalamu lekolo maya woko wewenasitoka loka oko elekoko lamiye. Eimolaya muki wewenasida dukau muda suwoko mudaonedanaki liye. ");
INSERT INTO yby_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Palasisi wewenasida uliki wenipo mako neboya uliwa Nikodimasi. Aya weya Juda wewenasida monoka ujapa wenipokiya ne. ");
INSERT INTO yby_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sa-onebo nenako, yu makoya lubukaya Jisesi nebotoya aya wemamo woko monoka ujapa wete yamalae, lemoya monawakaya elekaka noune. Emoya monoka ulawa api o-lemekaka weya Omailokati lemedawo we minane. Omailimo emotoka mino moloko minametidanako, emo noadawo nesa leko oliwaki elewole nesa lolo ametine. ");
INSERT INTO yby_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Loko liyoko, Jisesimamo wehe loko lo emekoloyo, elo: Wewena mako ohatama wewena lolo ametiboya, Omaimidana oholamidana elewoleyala mudamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Loko liyoko, Nikodimasimamo sa-loko lo miye: Agae, nemoya olopa nesa maya minonako, nena nenako oluho lasola lolo okoyoko donekaho etatibokumuya lane. Nena nenako maya doneda ohumanau yowekoyoko aku etatibokumu lane. ");
INSERT INTO yby_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Loko lokaiyoko, Jisesimamo sa-loko lo miye: Nemoya wehe loko lo emekoloyo, ele-mino. Wewena mako noku udoko Omaimidana weuna oluho maya le ukau moloko ohatama wewena lolo ametibo maya Omaimidana oholauya yowamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wewenasitokati soto pitabolawa maya wewenasida weunipoki soto pikilae. Ito Omaimitokati soto pitabolawa maya Omaimidana weuna oluhouti soto pikilae. ");
INSERT INTO yby_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sa-onenako, emoya aku soto pitane loko loboya ataka lapa-lapa kamo. ");
INSERT INTO yby_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mudao, lasilimoya opa-napa lekaka noiye. Sa-okaka noiyoko, onolagoya elikaka niaboya, nakahaukati api okoko ito nakahauka woko suwokaka noihe, yawaya mudaiki elamae. Sa-okaka noinako, Omaimidana weuna oluholaloti soto pitabo wewena maya lasikidana oko ne. ");
INSERT INTO yby_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Loko liyoko, Nikodimasimamo aya ladawoya monalo elamobo gaya laninako, nena nenako maya soto pitiye. ");
INSERT INTO yby_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Loko liyoko, Jisesimamo sa-loko lo miye: Emoya Isilaelo wewenasidaya sa-ilo ma-ilo loko lokaka noadawo we maya minadawoya, nemo nolobo gamidana monaloya elamape. ");
INSERT INTO yby_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sa-okaniyo, nemoya wehe loko ga ulawa lo emekoloyo, ele-mino. Lemoya mudako ele-minudawo nesago lo libekaka noudawo maya edimomasiya gate maya eli hulikae. ");
INSERT INTO yby_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Sa-ikaka nianako, nemoya maya mikau soto pekaka noibo nesamuya lo liboboya li laliki elamanako, okulumau soto pekaka noibo nesamuya lo libetuboya nenahatipoloti nemodamu eli elewole itae. ");
INSERT INTO yby_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Edimokuti wewena makolimo okulumau yoweko okulumau nebo nesaya mudamibo maya ne. Nemo okulumauti we utigo okulumauti leme-minonako, muki okulumau nebo nesahenaya muda-minoe. ");
INSERT INTO yby_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sa-ominonako, Mosesekaho hapa yeikala ametoka oletehakidana nesa mako lolo oko le sinaiboya, Isilaelo wewena maya lahelamayoko, yalo mudaikiki aku wiki dowa litae loko sa-ibo maya ne. Mosesekaho aweyaha ibokidana nemo okulumauti we utimidanaya nalawa iki yoho yaha yalo maya tinitakilae. ");
INSERT INTO yby_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Sakiya tinitikadeko, nemodamu elewole iki data kitabo wewena maya minowa minowa depa mutiwa likilae, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Omaiya numuto namato wewena milumate eliboya napa-napa neyoko, ipala makoko maya ne lamoko lemodaya limiboya emodamu elewole iki data kitabo wewena maya wiki tolowa amiki minowa minowa depa mutiwa liki minatae loko sa-iye. ");
INSERT INTO yby_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ito ipalakahoya maya mikau wewenasida miluma nesa le bituwe loko lemamiye. Lahelamibo nesauti maya lilimitiye loko Omailimo oli hekaiyoko lemene. ");
INSERT INTO yby_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sa-onenako, wewena makolita Omaimidana ipaladamuya elewole iki data kitaboya, lihima nesa libamekolaiye. Eli elewole amabo wewenasiya Omai ipalada uliwaya eli lamabo nenako, sa-itaboya Omailimo lihima bekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lihima bekakamidana monawa maya sakoya ne: Okulumauti lamedalaki wemamo muki wewenasida domudalo soto pekaiyoko, mudakudawo maya neyo lamiki lahelibo lahelamibo nesa lolo ikaka niabo maya nenako, lamedamidana hulitikiki lubumidana oluhola lolo iki minae. ");
INSERT INTO yby_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Lahelamibo nesa lolo iki minabo wewenasiya Omaimidana lamedala maya demesa mikiki edimonipo iki moliki abo nesa maya soto pekatiye liki Omai lamedalalo maya nisamae. ");
INSERT INTO yby_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wehe libo nesago lolo ikaka niabo wewena maya Omailimo dilimekadeko, iki moliki abo nesa monawanipo maya soto pitiye liki Omaimidana lamedalalo maya nisikilae. 10 Nam 21:9 ");
INSERT INTO yby_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sakiya miniki Jisesimamo Jelusalemu numuda maya hulikoko unala ipalale yuha lemoda lilime-loko Judiya ebatoka maya wiyoko yaloka maya woko minune. Yaloka woko minoko nokuhena maya udobetokaka oko minune. ");
INSERT INTO yby_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Sakoya minudawoya, Jonida maya owaha ilimi nalato molamayoko, mika makoya Salemuyo loko nebo ebamidana ilikaloka maya Aeno loko nebo numutoka ne. ");
INSERT INTO yby_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sakoya yalokaya nohena wavu-leko nebotoka nenako, wavu-liki wewenahena nisi nisi ayoko noku udobetoko nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sayoko Juda we makolimoya Jonida unala ipalale yuhakiya noku udobetokaka nesamuya lowa moila he. ");
INSERT INTO yby_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sa-iyoko, Joni maya neboto wiki tisate yamalae, emoya Jodani no helegaloka minaniyoko, we mako nisiyoko monawala lo soto moloko lo lemedawo wemamo emo adawomidana oko monoka noku noudobetaiyoko, muki wewena maya lemotoka nisitaha, emotokago wiwi niae. ");
INSERT INTO yby_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Liki layoko, Jonimamo sa-loko lo biye: We mako ahola Omailimoya sainahena mametiboya, ahamu yowanu lametibo ne. ");
INSERT INTO yby_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nemoya lahelamibo nesauti dilimitubo we maya minamoe loko lo libobo maya ne. Nemoya aya wemidanaya le omutoko anu wiletatane loko Omailimo noli hekaiyoko nisobo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mena mudai molitabo welimoya menalaki ouna jeko welo menalo iki minikiki uliwa nowideko, yatolakaho elekoko mulunauya lahelepa ekolaiye labo nesa leko nemoya muluneya aila uluma siliboya wavu-liki wewena maya Jisesitokago niwayoko sa-noiye. ");
INSERT INTO yby_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sa-noinako, aya we Jisesida ulila yoweko nedeko, nemoya lemeko iwaukaya minakoloe, loko Jonikaho liye. 20 Mat 14:3 24 Jon 1:20 ");
INSERT INTO yby_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Okulumauti limibo weya lemoda aseletoko ne. Wewena mako maya mikauti soto pitabo wewena maya ma mikamidana oluhola lolo ikilae. Sakiya mikaukati gagoya likilae. Sa-iboya, okulumauti limibo welimoya muki lemo maya mikau minudawo wewenala aseletoko ne. ");
INSERT INTO yby_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Emokaho sainahena mudako elenebo nesamuya lokaka noiboya, eimoda gala elikiki emesalo molabo wewenaya wavu-liki minamae. ");
INSERT INTO yby_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Gala eli litabo wewena maya Omailimo liyoko elewole okaka noibo we ne liki gala maya ilimiki likaka niae. ");
INSERT INTO yby_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Omailimo oli hekaiyoko limibo welimo Omaimidana weuna oluhola maya owo jeko waitomikaiyoko, Omaimidana galagoya lokaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aholakahoya ipalada umu helekaiyoko, muki nesa maya ipalada adelaugo moloko suwone. ");
INSERT INTO yby_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wewena makosi Omaimidana ipaladamuya elewole iki elitaboya minowa minowa depa mutiwaya alo likae. Ito Omai ipalada gala maya eli hulikiki monitabo wewena maya elewole depa mutiwaya lamikilae. Sa-ideko, Omailimo mesaha jebetatibo nesalimoya edawa mupilanipolo yoweko minakolaiye, loko liye. 35 Mat 11:27 ");
INSERT INTO yby_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Palasisi wewenasiya Jisesidamuya sa-liki ele: Joniya wewenala yuha malokago dilipe moloko noku udobetokaka noiboya, Jisesikahoya muki wewenasida noku udobetokaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aha sa-liki lae. Jisesikahoya unala ipalale yuhasida dilipe molokaiyoko edimonipogoya monoka noku udibitae. Sayoko Jisesimamo aya ga maya elekoko, ");
INSERT INTO yby_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Judiya eba maya hulikoko aku le Galeli ebatoka wiye. ");
INSERT INTO yby_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sakoya yaloka woko Samaliya ebatoka maya woko hetiye. ");
INSERT INTO yby_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaliya ebatokaya numuda mako Sikae loko nebotoya woko hetiye. Aya ebaya hapa yeikalaya Jekopukaho ipala Josepuda mika mako mibomidana ilikaloka maya woko nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Sa-iboya ayaloka maya Jekopuda no alela maya neyoko nenako, Jisesi maya anu wibo nesalimo owiya elokaiyoko, holiga maya woko aya ale epaloka maya nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Sakoya neyoko, unalale ipalale yuha maya nodenesa meina hikili li numuda emesalokago yowikayoko, Jisesi maya eimolago nebotoya Samaliya mena mako no hituwe loko nisiye. Sakoya nisiyoko, Jisesimamo noya ma heko nemegae, loko liyoko, ");
INSERT INTO yby_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Juda wewenaki ito Samaliya wewenakiya aito aito iki minikaka niabo nenako, aya menamamo sa-loko liye: Emoya Juda we maya minaninako, nenaha iyoko nomu wako lo nemene. ");
INSERT INTO yby_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Loko liyoko, Jisesimamo emoya Omailimo imitibo nesamuya ele wehe lamane, ito noya heko nemo loko nolobo we nemodaya monawane ele wehe lamane. Emoya nemo monawane maya mudadawoto minatidanako, sakoya loka amoko elewole oko minokaka nomu loka okadeko emetine. ");
INSERT INTO yby_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Loko liyoko, maya menamamo, we lalo nesa yamalae, ale maya yeikamau nenako, ito emoya no hikaka nesayaki lamaninako, elewole oko mino-loko wokaka noya nakahauti heko nimitane. ");
INSERT INTO yby_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Latate Jekopukahoya eimola no aleya ohekoko ayauti maya nonoko helekaiyoko, ipalaki ja ulalaki ayauti mayago hiki nikaka abo ne. Sa-ikaka abo maya nenako, emolikaya Jekopuda asetoko aitomidana no mako le soto molakolo nolape. ");
INSERT INTO yby_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Loko liyoko, Jisesimamo maya noya nataboya aku nomu delakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ito nemo noneya dohumanipo okaka no maya ne. Sa-onenako, wewena mako nemo noneuti nataboya aku notipou delamekolaiye. Nemo none libituboya lemeko dukauya omuda lenetibo nenako, elewole depa mutiwa liki minakilae. ");
INSERT INTO yby_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Loko liyoko, maya menamamo, we lalo nesa yamalae, aya noya nemekadeko nokoko aku nomuya nelamekolaiye, ito muki yupeka niseko no hewa hewa okaka nobo nesa maya hulikoko moletoko minatuhao. ");
INSERT INTO yby_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Loko liyoko, Jisesimamo woko waukada maya ilime-loko niso. ");
INSERT INTO yby_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Loko liyoko, maya menamamo nemo waune minamibo ne loko liye. Loko liyoko, Jisesimamo emoya waune minamiye loko wehe loko lokadawoya, ");
INSERT INTO yby_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","emo waukaleya lade maloka suwoko weloya wokoko nisedawo maya ne. Ito oloti wadawo weya emo wauka wehe loko minamiye. Sa-oneboya emoya suwa lamane, ");
INSERT INTO yby_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","loko liyoko, maya menamamo, we lalo nesa yamalae, olotiya elekoboyae. Emoya Omaimidana epaloti ga lokaka we maya minane. ");
INSERT INTO yby_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Lemo Samaliya wewena latatelesiya maya bolaloya yowiki limiki iki Omaimitoka monoka likaka abo ne. Ito edimo Juda wewenalitaya Jelusalemu numutokagoya monoka letune liki monoka likaka niabo nenae. ");
INSERT INTO yby_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Loko liyoko, Jisesimamo, ma mena yamalae, nemo lobo ga maya eleko lowo. Onawa maya alili okaiyo, sako alili ideko, ahonedaya maya bolalau lipi miki monoka lamitabo neyo, ito Jelusalemu numutokago lipi miki monoka lamitabo ne, muki ebatokaya lipi miki monoka litabo ne. ");
INSERT INTO yby_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Edimoya eli opa iki lipi mikaka niae. Lahelamibo nesauti dilimitibo nesa maya lemo Juda wewenasitokatigoya soto pitibo nenako, lemo Juda wewenalita lipe mekaka noudawo wemidana monawa ele wehe lo-minudawo ne. ");
INSERT INTO yby_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Onawa mako alili ekolaiye, ito aya onawa alo alili okaiyo. Yamuya Omaimidana wewenala laloya dukadunu ito ga ulawadunu ahoneda lipi mikilae. Ahonekahoya yasuda liki lipi nimitae loko wewenamuya ohu nojiye. ");
INSERT INTO yby_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Omaiya eimola weuna oluhokidana nenako, lemoya Omaimidana weuna oluholoti ito ga lalolotigoya lipe metune. Loko liyoko, aya menamamo sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Lahelamibo nesauti lilimitibo weya uliwaya Kalaestiye loko soto pitibo ne liki layoko, ele-minobo nenako, olotiya mudakoe. Aya welimoya soto pekoko muki nesahena lo soto moloko suwekolaiye liki layoko, ele-minobo maya nenae. ");
INSERT INTO yby_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Loko liyoko, Jisesimamo nemo ga lo noemobo we maya minobolae loko liye. ");
INSERT INTO yby_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Loko noliyoko, Jisesida unala ipalale yuha lemo nisekoko, maya menaki laibo gamuya lomoda wokaiyoko, agae, nenahamuya nilaihelae, ito nenahamuya alo-nalo nileiye loko loka oetatune liki lata kebo maya eda lelokaiyoko, hulokunibo ne, loka otamoko. ");
INSERT INTO yby_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sa-iyoko, maya menamamoya no odahena maya hulikoko lolosa jeko woko taoniloka muki wewenasida sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Edimoya nisiki maya wemidana mudalo, nemo muda-elamobo welimoya nemo oko moloko obo monawane maya lo soto moloko suwo nimikaiye. Sa-inako, lahelamibo nesauti lilimitiye loko lo mololetaibo we maya netihe. ");
INSERT INTO yby_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Loko liyoko, taonilokati maya limiki Jisesida muda-elae. ");
INSERT INTO yby_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sa-niayoko, lemosiya ula moloko, monoka ujapa wete yamalae, nodenesa maya nogae. ");
INSERT INTO yby_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Loko luniyoko, Jisesimamo nodenesa aitomidana mako nemotoka neboya mudamahe. ");
INSERT INTO yby_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Loko liyoko, unala ipalale yuha lemoda minunibotoka sa-loko wetome-katome une: Wewena makolimo nodenesa leko niseko mekaiyoko lihe. ");
INSERT INTO yby_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Loko lokuniyoko, Jisesimamo sa-loko lo limiye: Noli hibo welimoya eimola letibotoka molatibotoka oko yowanu ga lonetaibo yowanula nolobolimoya nemo nodenesa ne. Ito edimosiya ukada loweki makoki wokadeko nodenesa o-molakolaiye liki likaka niae. Sa-likaka niaboya, lo libituyo, elilo: Domudaya pana kiki ahoneda mijala maya mudalo. ");
INSERT INTO yby_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nodenesa alo o molonebomidanaya wewena dukanipo alo li lolowa iki minikae. ");
INSERT INTO yby_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Loko lo libibomidana yowanula litabo wewenasiya meinawa likilae. Sakiya likadeko wewena malokasiya elewole dupa mutiwa likilae. Sa-ikadeko, dukauya monoka ihilawa tili abo wewenaki ito ihilawa liyebo wewenakiya elowa jikilae. ");
INSERT INTO yby_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sa-ideko wewena makolimo yuha okaiyoko, wewena makolimo mida numuda lekaka noiye liki likaka niabo ga maya woko ulolotekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Asako edimoya li yuha amiki mida numuda litae loko doli hekobo maya ne. Wewena malokasiya yowanu liki li yuha ikayoko alo o molokaiyo, edimo yowanunipomidana ihilawa maya aha likae. ");
INSERT INTO yby_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Loko liyoko, Samaliya menamamo saina-painahena nemo oko moloko obo monawane maya muki lo soto molokaiye loko wetome oko lo biyoko, aya ebaku wewenamasiya elikiki Jisesidamuya elewole iki data kiminabo ne. ");
INSERT INTO yby_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sa-iki data kikiki aya wewenamasiya Jisesimaki magoina minatune likayoko, Jisesi maya loweki makoki yupekaya aya wewenamaki magoina nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sakoya magoinaya minoko Jisesimamo monoka lo biyoko, muki wewenamasiya eliki emesalo molae. ");
INSERT INTO yby_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sakiya aya menamamidana sa-liki li me: Emokahoya ada wetome okaniyoko malokalitaya eludawo maya ne. Sa-udawo maya neboya, oloti maya eimola Jisesikaho epaloti lokaiyoko elekune. Liki emoya wehe loko muki numuto namato wewenasida lahelamibo nesauti lilimitiye loko lo mololetaibo we maya ne loko ele elewole okune, liki lae. 5 Jen 33:19; Jos 24:32 9 Eja 4:1-5; Nih 4:1-2 ");
INSERT INTO yby_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Jisesikahoya adaya Omaimidana epaloti ga lokaka we makolimo eimola numudala ebalau netiboya ilimi napa amikilae. Loko libo nenako, Jisesima loweki makoki yupekago edimoki minokoko akuya le Galeli mikauka wiye. ");
INSERT INTO yby_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galeli ebakuka wiyoko, omutoko esenipo vobetaibo holi onawa maya nisiyoko, Jelusalemu numuto yowanu libolawa maya mudai-minabo nenako, ilimi molikayoko, Kana numutokaya omutoko Jisesikaho aha noma le waeni no lolo ibo numutoka maya wiye. ");
INSERT INTO yby_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sakoya woko neyoko, Kapaniyamu numutokaya kiyape makomidana ipala saina elokaiyoko, ");
INSERT INTO yby_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jisesi maya Judiya ebakuka hulikoko aku le wili jeko Galeli ebakuka maya nonisiye liki layoko, elekoko, aya kiyape maya ipalama helekolo anada nohiyoko, Jisesida maya ilime-loko Kana numutoka wetuwe loko Jisesi nebotoka woko ekewake o-minoko liyoko, ");
INSERT INTO yby_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisesimamo edimoya api-napi noyoko, mudaha nemo ganeya eli likaka amae. ");
INSERT INTO yby_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Loko liyoko, maya wemamo we lalo nesa yamalae, ipaneya helekatiyo, enemane oko lumudanae. ");
INSERT INTO yby_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Loko liyoko, Jisesimamo sa-loko lo miye: Emoya aha woiko, ipaka maya alo haka lokaiyo. Loko liyoko, aya wemamo Jisesida gala maya elewole oko ata kekoko akuya le wili jeko wiye. ");
INSERT INTO yby_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Sakoya nowiyoko, go maya lokaiyoko, elekelela wemasiya anuloka ninisiki ipaka maya alo haka lokoko ne. ");
INSERT INTO yby_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Liki layoko, haka libo onawamuya loka iyoko, aijo maya ho le yohotekolaiyoko, 1 kilokulo maya mumusikasi nesa elaibo maya suwotaiyoko sinoko opa naiye. ");
INSERT INTO yby_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Liki layoko, aya wemamo ipalada onawalamuya sa-loko eliye: Aya onawalo wehe loko Jisesimamo noli heko ipaka maya alo haka lokaiye libo onawalo maya wehe loko nenae. Loko lokoko menakipalale oluholalekiya Jisesidamuya elewole iki data kebo ne. ");
INSERT INTO yby_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Aya nesaya Jisesikaho Judiya ebakukati niseko Galeli ebakuka woko oliwaki nesa elewoleya lolo iyoko lowetiye. 44 Mat 13:57 45 Jon 2:23 46 Jon 2:1-11 ");
INSERT INTO yby_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Sako minoko Juda wewenasida holi onawanipo mako alili okaiyoko, Jisesima le Jelusalemu numutoka yowiye. ");
INSERT INTO yby_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Sakoya Jelusalemugaya sipisipi jasida oho akanipoloya adu no mako neboya uliwa Betiseda. Aya no ilikalokaya yawago nebo numuda lade maloka suwoko nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Sa-onebo nenako, aya numukuya saina delaibo wewenahena ito domuda likaibo wewenahena ito di dadelo libo wewenahena dade uka jibo wewenahena wavu-liki nisiki udiki siniki iki minikaka niabo ne.  ");
INSERT INTO yby_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Sakiya ujapa iki minikaka ayoko, no maya le yeiwa yeima etibo onawaloya okanaki we makolimo lemeko no maya le momoga okaiyoko ada satomo noku jibo we maya sainala haka letiye liki elikiki aya nolo maya ujapa iki minikaka ae. ");
INSERT INTO yby_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Sa-iki minabokuya, we mako ila ebili libo weya dolakaho etaibokuti anu monamibo meleke 38 le huloko nebo wekiya ilimi-liki nisiki hulikayoko, nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sakoya neyoko, Jisesimamo niseko muda-elokoko onawa hana-pana yupeka neyo loko elekoko loka oetoko emoya ma haka letuwe loko ele-minape. ");
INSERT INTO yby_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Loko liyoko, ila lahelamibo wemamo we lalo nesa yamalae, ekahimamo niseko no yomaya momoga noibokuya nipiso huladeko haka letuwe. Owaha maloka lemekolo noyoko, wewena makolimo asenetoko lemekaka noihao. ");
INSERT INTO yby_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Loko liyoko, Jisesimamo sa-okaniyo, sinoko newelusaka maya ohekoko leko wo loko lo miye. ");
INSERT INTO yby_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sa-loko libo epakiya ila lahelamibo wemamo enemane oko sinoko mino telekekoko newelusala maya oheko leko wiye. ");
INSERT INTO yby_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Sa-iyoko, Juda wewenasida ujapa wenipolemasiya haka libo wemidana maya olotiya holi onawau maya nenako, newelusaka oheko leko nisedawoya, samode yowanu lekane. ");
INSERT INTO yby_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Liki layoko, maya wemamo nilime haka libo wemamo newelusaka maya ohekoko leko wo loko noli hekaiyoko leko nisoe. ");
INSERT INTO yby_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Loko liyoko, maya wewenasiya sa-loko lo imibo weya ekahoma ne liki loka itiki lae. ");
INSERT INTO yby_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Liki laboya, Jisesiya wavu-liki wewena minabokuti leso ibo we maya nenako, ilime haka liyoko nebo wemamo Jisesida uliwa elaminako, ");
INSERT INTO yby_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","elamoe lokoko monoka numuda napau maya yoweko neyoko, Jisesimamo muda-elokoko sa-loko lo miye: Olotiya upakauka maya wati okaiyo, alikaya edawaki nesa jelekataniyo, lahelametibo nesahena maya aku lolo amo. ");
INSERT INTO yby_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Loko liyoko, aya wemamo Jisesida maya sa-loko libototiya muda-elo wehe lokoko woko Juda wewenasida ujapa wenipolesida sa-loko lo biye: Nemoda nilime haka libo we maya uliwa Jisesi maya ne loko lo biye. ");
INSERT INTO yby_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sakoya holigumaki moneko yamidana yowanu lekaka ibokumuya Juda wewenasida ujapa wenipolesiya yaloti maya api iki Jisesida ulanipolo we lolo itiki ulana molitae. ");
INSERT INTO yby_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sakiya sayoko, Jisesimamo nemoya ahonekahoya yowanuya holigumaki muki yupeka leko minokaka noiye loko lo biye. Sa-noinako, nemokiya emesalo moloko leko minokaka noe. ");
INSERT INTO yby_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Loko lokoko Jisesimamo Juda wewenasida holinida maya le opa napa ibokumu ito Omaiya nemo ahone nenako, nemokiya makoko aweyaha oko minoiye libomuya Juda wewenasida ujapa wenipolesiya mesaha jitiki kohatune liki dabuha adoha molikaka abo ne. 06 Nih 13:19; Jel 17:21 ");
INSERT INTO yby_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Sa-iyoko, Jisesimamo nemoya wehe loko lo libituyo, eli-minalo lokoko sa-loko lo biye: Nemoya Omaimidana ipala maya minoboya neimone nata keko yowanu litubo nesa lamoe. Ahonekaho liboto ade wasumalo mudakoko noloe. Sakoya ahonekaho oko moloko iboto maya mudakoko nemo ipalakahoya oko moloko okaka noe. ");
INSERT INTO yby_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ahonekahoya nemo ipalada umu helekaiyoko, muki lolo noibo nesahena maya nilipekaka noiye. Ito edimoya yowanu maya noloyoko mudaikaka niabogoya minamiye. Edimosiya muda-nelikiki aiyo wuye liki nepoka litae loko ahonekahoya yowanu napa maya dilopetane loko nemekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ahonekahoya helebo wewenasida dilipe sinokaka noibo nesa leko nemo ipalakahoya elewole depa mutiwa maya wewena mako mituwe loko letuboya aha mekoloe. ");
INSERT INTO yby_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ahonekahoya wewenasida lihimanipomuya ona molobetokaka amiye. Sa-okadanaki, muki yatoka yowanuhena maya nemo ipaladago nadeu molonetoneboya, ");
INSERT INTO yby_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","maloka wewenasiya ahoneda uliwa li sinikaka niabo nesa liki nemo nulinekiya li sinatae loko sa-noiye. Sakoya maloka wewenasiya nemo nulineya li sinamaboya ahonekaho nemoda noli hibo wemidanakiya uliwa li sinamabo ilekaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Sa-onenako, nemoya wehe loko lo libekoloyo, eli-minalo: Wewena mako nemo gane maya elekoko noli hibo wemidanamu elewole oko elitiboya elewole epa mutiwa maya alo lekaiye. Alikaya lihimalamuya obi amekolaiye. Helekaka epa mutiwa maya hulikoko elewole epa mutiwa maya alo lekainako. ");
INSERT INTO yby_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nemoya wehe loko lo libituyo, eli-minalo. Onawa alili ekolaiboya, olotiya aloya alili okaiye. Yatoka onawau helebo wewenasiya Omaimidana ipala nemodaya onone elikiki aku siniki minakilae. ");
INSERT INTO yby_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ahoneya elewole okakamidana monawa maya ne. Sa-onenako, ipala nemokiya asako elewole okakamidana monawa maya minatane loko noli hene. ");
INSERT INTO yby_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sakokoya okulumauti we uti maya minonako, ahonekahoya wewenasida lihimanipomu lo hukobetokaka yowanu maya nadeuya molone. ");
INSERT INTO yby_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Maya nolobo gaya elikiki topa amilo. Onawa mako molonebo onawa maya aha neyo. Ya onawa nisideko nemo onone maya elikiki ono ebaku udi-minabo wewena maya alenipouti aku sinakilae. ");
INSERT INTO yby_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Sakiya wehe lonebo nesa lolo i-minabolawa maya elewole depa mutiwa liki sinakilae. Ito lahelamibo nesa lolo i-miniki helebo wewenasida maya sinikadeko lihimanipo maya bekoloe. ");
INSERT INTO yby_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Sa-etuboya nenimonekaho nata eleko yowanu lituboto minamiye. Ahonekaho lokadeko lihimanipomuya ona molobetakoloe. Sakoya lihimanipomuya yowanu loyoko woko wehe lekolaiye. Yatoka nesa lolo etuboya nenimone nata eleko samekoloe. Noli hibo welimo letiboto molatiboto oko sa-ekoloe. ");
INSERT INTO yby_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Sakoya nenimone monawane lo soto molatuboya wehe lamekolainako, ");
INSERT INTO yby_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ahonekaho monawane maya lo soto molatiye. Ahonekahoya lo soto molokadeko wehe letiye loko ele-minoe. ");
INSERT INTO yby_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Edimoya maloka wewenasida maya Jonitoka doli hikayoko wiki loka itayoko ga ulawa maya lo libenebo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wewenasi monawane maya mudaikiki hi elowo initatae loko lamoe. Aha elewole depa mutiwa maya likiki elewole anugu witae loko edimokumuya noloe. ");
INSERT INTO yby_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jonikahoya lubu napa jeneboku maya le napa lolo okoko he lameda loneyoko, yalo maya elowa jiki minabo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Omailimoya nemoda he elowo onimikaka noiboya, Jonida sa-otaibomidana asetoko sa-onimikaka noiye. Sakoko ahonekahoya aito-aitomidana yowanu litane loko lonetonebo maya, aya yowanumidana ihilawa maya le soto molokoyoko, ahonekaho noli hiyoko lemobomidana monawa maya soto pekaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ahone noli hibo welimoya nemo monawane maya lo soto molokaka noiboya, edimosiya onola maya elamabo ne. Ito ahonedaya muda-elamabo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Edimoya ahone noli hibo wemidanamuya elewole iki elamabo maya nenako, gala maya dukauya minamiye. ");
INSERT INTO yby_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Edimoya monoka bukula le-minudanako, elewole lepa mutiwa lekaka ga maya yauya ne likiki ijakala hiki atedala maya hiki li likaka niae. Sa-inayoko, nemo monawane maya aya luhuwauya soto nopiboya, ");
INSERT INTO yby_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","edimosiya nisiki nemotoka omikiki elewole depa mutiwa maya litanako, samikiya huli aito molinimikaka niae. ");
INSERT INTO yby_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Sa-oneboya, matoka wewenasiya nupa liki yowitae loko lamoe. ");
INSERT INTO yby_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Edimo monawatipoya mudaminoboya, dukaya wehe liki Omaitoka molamae. ");
INSERT INTO yby_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nemoya ahoneda galalo jego o-minoko edimotoka lemoyopakala, edimosiya no yahu nemamae. Sa-ikanako, wewena makolimoya eimola ata eleko nisideko maya no yahu mitahelae. ");
INSERT INTO yby_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Edimoya wewenasigo lilimi napa itae liki elikiki, Omailimo lilime napa etiye liki mako elamae. Sa-ikanako, nenaha ikiki Omaimu elewole iki elitae. ");
INSERT INTO yby_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Edimoya nemokaho aholatoka obi yowanu leletatibo ne liki lamilo. Edimoya Moseseda galaloya demesa jiki minae. Sa-ikaka nianako, aya Moseseda galalimoya obi yowanu lelibetakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosesekaho luhuwa jiboya nemodamuya luhuwa jenebo maya ne. Sa-onebo maya nenako, Moseseda gala maya elebo minatidanako, nemodamuya elewole iki data ketine. ");
INSERT INTO yby_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Sa-onebo maya nenako, Moseseda gala maya eli hulikanako, nemo gane maya nena nena iki maya elitabo ne. 29 Den 12:2 33 Jon 1:19-27; Jon 3:27-30 37 Mat 3:17 ");
INSERT INTO yby_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jisesimamo ga lo beko suwokoko, Galeli adu noloya uliwa mako Taibiliyae loko nomidana sila oko yola helegaloka wiye. ");
INSERT INTO yby_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Woko saina delaibo wewenasida dilipe haka lomo nowidanaki oliwaki nesa elewoleya lolo iyoko muki wewenasi muda-elikiki emesalo moliki wae. ");
INSERT INTO yby_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sa-niayoko, Jisesimamo unala ipalale yuha lemoda maya dilipe-loko yoweko bolau nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ya yupekaya Juda wewenasida esenipo vobetaibo holi onawa maya alili okaiyoko nenako, ");
INSERT INTO yby_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisesimamo muki wewena maya emotokago nisikayoko mudaidokoko, Pilipida maya sa-loko lo miye: Nodenesa maya nakahauti meina heko betune, wewena lasola li esa amanako, nodenesa mahasilimoya woko muki wewenaloya kohamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Loko liboya, Jisesikaho sainahena lolo etibo anuwa maya aha neyoko Pilipida maya mulunau heko liye. ");
INSERT INTO yby_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Loko liyoko, Pilipimamo nodenesaya ehada owo makoloti meina heko betudawokiya woko kohamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Loko liyoko, Saimoni Pitada unala Endulumamo sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Maukaya oluho lasola makolimoya beleti lade maloka suwoko lahawa lowemaki leneboya, yalimoya muki wewenasito woko kohamekolainako, nenaha etune, ");
INSERT INTO yby_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","loko loka iyoko, Jisesimamo sa-loko liye: Wiki aya wewenasida maya mikalo minalo liki li bideko mikalo minadeyo. Aya bolaloya dau lalo nesa nebo nenako, yalo maya 5 tauseni we maya menakipanipole oluhonipole hulikiki nisebo wewena maya mikalo minikayoko, ");
INSERT INTO yby_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisesimamo Omaimidana epoka lokoko aya beleti maya ona moloko beko, lahawamakiya ona moloko biye. ");
INSERT INTO yby_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Biyoko, matoka wewena maya niki niki ohumanipo okaiyoko, Jisesimamo unala ipalale yuha lemodama lumawahena maya latila okatiyo, moniki aka ilo. ");
INSERT INTO yby_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Loko lokaiyoko beleti lade maloka suwoko beletiloti ona moloko buniyoko nikiki lumawa hulabolawa maya manoda lape 12-pala owo jiki waitokaiyoko le molune. ");
INSERT INTO yby_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sakoya oliwaki elewole nesa yaya lolo iyoko muki wewenamasiya mudaikiki sa-liki lae: Maya Omaimidana epaloti ga lokaka we napa mako soto pitiye liki labo we maya netiye. ");
INSERT INTO yby_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Liki likiki Jisesida maya hi wego ikiki uliki we lolo itakilayoko, Jisesimamo mudakoko aya wewenasida maya hulobikoko eimolago bola makomauya yowiye. ");
INSERT INTO yby_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sakoya yoweko yaloka neyoko, ludaka lokaiyoko, unala ipalale yuha maya no ilikalokaya lemune. ");
INSERT INTO yby_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lemeko Kapaniyamu numutoka maya wekolo noku lapeu maya yowekolo nouniyoko, lubu maya jekaiyoko Jisesi maya owaha nisamiyoko hulolemekoko lemogo wune. ");
INSERT INTO yby_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Sakiya wuniboya, ahuhu napaya nisekoko no maya alahuka jeko le yeiwa yeima noiyoko wunibo ne. ");
INSERT INTO yby_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sakoya anu kilomitaya 5-palahe ito 6-palahe nowuniyoko, Jisesima no mupilalo maya anu moloko nisiyoko muda-elelokoko, lomoda adoha wiye. ");
INSERT INTO yby_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Sakoya lomoda nowiyoko, Jisesimamo nemo maya nonisoyo, domodatipo wamideyo. ");
INSERT INTO yby_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Loko liyoko, noku lapeu maya ilime molatune loko ludaboya, ayahasi wekolo nounisebo numuto maya woko hetune. ");
INSERT INTO yby_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sakokoya udokoko go maya lokaiyoko maloka wewena yola helega udabo wewenamasiya sa-liki lae: Lemoya lubukaya noku lape makoko neyoko mudaudawo maya nenako, yauya Jisesida maya hulimikiki unala ipalale yuhamagoya wabo maya nenako, nakahaloka netihe liki data kiminaboya ne. ");
INSERT INTO yby_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sakiya niniseyoko, Taibiliya numutokatiya we napalimo Omaimidana epoka loko beleti maya biyoko naboto maya aito noku lapeu nisiki hetae. ");
INSERT INTO yby_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Niseboya, wewenamasiya Jisesi maya unala ipalale yuha lemoki nosamuniyoko nenako, aya noku lapeu maya yowikiki Jisesida maya ohu jetune liki Kapaniyamu numutoka li lika iki wae. ");
INSERT INTO yby_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Sabo maya, ma helegati maya Jisesida maya ohu jiki li soto molikiki sa-liki lae: Monoka ujapalo we yamalae, emo maloya nena yupekama ito nena oko nisedawo ne. ");
INSERT INTO yby_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Liki layoko, Jisesimamo nemoya wehe loko lo libekoloyo, eli-minalo. Edimoya nemo sainahena elewole maya lolo oboto mudabomuye liki, nemoda maya ohu nijehe. Yatoka nesa lolo obomuya ohune jamae. Beleti maya liboyoko niki niki ohumatipo ikiki nemodamuya ohune nijehelae. ");
INSERT INTO yby_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Sa-ikayoko edimolitaya yowanu ga lilowo. Woko aha etibo nodenesamuya lamoe. Elewole oko minatibo nodenesamidana yowanuwamago lilo. Okulumauti we uti nemoya ahoneda anela le-minobo welikaya elewole oko minokaka nodenesa maya libekoloe. ");
INSERT INTO yby_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Loko lokaiyoko, onoto liki Omailimo mudalelo lahelitiye loko nena yowanu letune. ");
INSERT INTO yby_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Liki layoko, donoto leko, Omailimoya yowanu sakiya litae loko lolibetonebo maya ne. Omailimo noli hibo we nemodamuya elewole iki data kitae loko lone. ");
INSERT INTO yby_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Loko liyoko, aya wewenamasiya elewole nesa mako le soto molokaniyoko, emoda ele emetune. Sa-ekoluniyo, emoya nena yowanu maya litane. ");
INSERT INTO yby_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sa-lokaninako, emokahoya muki yupeka maya nodenesa lemekolo nolape. Omutikiya lemo latatele minabotoya ame mikaloya mana nodenesago niki minabo maya nenako, yamidana gala maya sakoya ne: Sakiya minabotoya okulumauti nodenesa biyoko niki minabo ne. ");
INSERT INTO yby_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Liki layoko, Jisesimamo wehe loko lo libekoloyo, eli-minalo, lokoko Mosesekahoya okulumauti nodenesa bamibo maya ne. Nemo ahonekahoya bibo maya ne. Ito nemo ahonekahogoya okulumauti nodenesa ihilawa maya libekaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Okulumauti limibo nodenesalimoya elewole oko minokaka depa mutiwaya le soto molokaka noiye. Yamidana nodenesaya Omailokatigoya ihilawa nodenesaya ne. ");
INSERT INTO yby_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Loko liyoko, onoto liki, we napate yamalae, nodenesakamuya ladawoya muki yupekaya limitaniyolae. ");
INSERT INTO yby_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Liki layoko, Jisesimamo elewole oko minokaka nodenesaya nemoya minoe loko liye. Sa-ominonako, wewena mako nemotoka nisitaboya nodekumu helamikilae. ");
INSERT INTO yby_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ito nemodamu elewole iki data kitabo wewenaya notipomu delamekolaiye. Nemoya muki yupekaya lo libekaka noboya elamiki eli hulikaka niae. ");
INSERT INTO yby_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ma mikau wewenaya ahonekaho nemekaka noibo wewena mukiya nemotoka nisikilae. Sakiya nemotoka nisitabo wewenasidaya ma nade bolaloti helu jamekoloe. ");
INSERT INTO yby_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Okulumauti lemobo we nepauti ga maya le napa etuwe loko lemamoe. Noli hibo welimoya eimola letibotoka molatibotoka oko yowanu lituwe loko lemobo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ahonekaho nemotoka dilipe molaibo wewena maya wiki latila ikatanako, onawa napalo maya dilipe molokoyoko sinatae loko nisoe. Noli hibo wemidana epalauti gaya sa-lokoya ne. ");
INSERT INTO yby_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ipala nemodaya muda-nelikiki eli elewole itabo wewenasiya elewole depa mutiwa likadeko onawa napalo maya dilipe sino suwekoloe, ahoneda gala sakoya ne. ");
INSERT INTO yby_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sakoya Jisesimamo elewole nodenesaya okulumauti limibo maya nemo minoe loko libokumuya Juda wewena malokasiya data lahelamibo kikiki, emega sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Maya weya Josepuda ipala maya neboya, ito emo dolako aholakosida maya mudaido-minudawo maya neboya, okulumauti lemobo we minoe loko lokaka noiboya nenahamuya lokaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Liki layoko, Jisesimamo edimoya lahelamibo data kamilo loko lo biye. ");
INSERT INTO yby_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wewena mako edimonipo data kiki nemotoka nisiki omamikilae. Ahone noli hibo welimoya dilipe-loko nisideko nisiki hetakilae. Sa-ideko yamidana wewenasida maya onawa napalo maya dilipe sinakoloe. ");
INSERT INTO yby_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Omaimidana epalauti ga likaka wewenasiya ga mako sa-liki luhuwa ji-minabo maya ne: Omailimo eimolaya muki wewenasida monoka lo beko api-napi o bekolaiye. Sa-etibo ne liki luhuwa ji-minabo maya nenako, ahonekaho monoka lo bideko eliki li emesalo molatabo wewena maya nemotoka nisikilae. ");
INSERT INTO yby_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wewena makolimoya ahoneda mudamiye. Omailokati lemobo we nemo makoko minonako, nemogoya muda-eleminoe. ");
INSERT INTO yby_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wehe loko lo libekoloyo, eli-minalo. Nemodamu elewole iki elitabo wewenama elewole depa mutiwa maya galoya likae. ");
INSERT INTO yby_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Elewole oko minokakamidana nodenesa maya nemoya minoe. ");
INSERT INTO yby_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ahotipole maya ame mikalo mana nodenesago ni-liki wiki miniki hele. ");
INSERT INTO yby_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ito okulumauti nodenesa noko helamokakamidanaya nemotogoya ne. ");
INSERT INTO yby_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Elewole nodenesa okulumauti limibo maya nemoya minoe. Sa-onenako, nemotokati nodenesa natabo wewena maya mini-liki wiki minakilae. Milawanemoya nodenesa lolo iye. Muki numuto namato wewena maya elewole iki minatae loko libekoloe. ");
INSERT INTO yby_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Loko liyoko, Juda wewenamasiya pelesa jiki sa-liki lae: Emokahoya nena nena okoko milawalaya limideko natudawomu liye. ");
INSERT INTO yby_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Liki layoko, Jisesimamo wehe loko lo libekoloyo, eli-minalo lokoko, nemo okulumauti we uti milawaneki ito oladanekiya namitaboya elewole depa mutiwa maya dukauya minamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wewena mako nemo milawaneki ito oladaneki nataboya elewole depa mutiwa maya aloya likanako, onawa napalo maya dilipe sinakoloe. ");
INSERT INTO yby_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nemo milawane maya nodenesa ihilawaya ne, ito oladane maya no laloya ne. ");
INSERT INTO yby_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nemo oladaneki ito milawaneki natabo wewena maya nemoda li uka jikae. Sa-itaboya nemokaho asako le uka jebetakoloe. ");
INSERT INTO yby_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ahoneya elewole wemamo noli hekaiyoko leme-minoe loko eimolatogo jego o-minoko noloe. Sa-onenako, wewena mako nemo milawane natabo wewena maya nemoto jigi iki minakilae. ");
INSERT INTO yby_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Okulumauti nodenesamidana monawala sakoya ne. Omutiki latatipole minaboto nabo nodenesakidana minamiye. Latatipolesiya omutikiya mana nodenesago ni-liki wiki alika helebo ne. Sa-iki saboya, nemo nodenesane natabo wewenaya mini-liki wiki elewole depa mutiwa liki minakilae. ");
INSERT INTO yby_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Lokoya Jisesi maya Kapaniyamu numutoka nedanaki, monoka numuku maya yoweko sa-loko monoka lo bibo gaya ne. 31 Eks 16:4,15; Sam 78:24 45 Aes 54:13 ");
INSERT INTO yby_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sa-loko liyoko, wewenalalesiya maya ga maya elikiki edimonipoloka sa-liki lae: Ga maya eludawoya eda okainako, ekahimamo ele wehe loko emesalo molatiye. Liki osele ga likayoko, ");
INSERT INTO yby_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisesimamo ukauka aha elekoko sa-loko lo biye: Edimoya eleyoko lahelamiyoko nilahe. ");
INSERT INTO yby_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Okulumauti we uti nemoya omutoko minokaka obo ebatoka maya le welepa jeko noyowoyoko muda-nelataboya nenaha itabo ne. ");
INSERT INTO yby_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lupatemoya elewole lepa mutiwa le soto molokaka nesa minamiye. Elewole lepa mutiwa le soto molokaka nesaya Omai weuna oluhomidana yowanula maya ne. Ito maya lo libobo galimoya elewole depa mutiwa le soto molokaka gaya ne. ");
INSERT INTO yby_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sa-loko lo libobo ga maya edimokutiya maloka wewenasiya eliki emesalo molamae loko liye. Jisesida monokala eli hulatabo wewena maya ada api ibo onawalotiya elene. Ito mimi etibo wemidanaya uliwa elene. ");
INSERT INTO yby_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sa-onenako, ga maya lo bekoko akuya esewau leko maya sa-loko lo biye: Nemokaho sa-loko lo libituyo, elilo. Wewena mako ahonekaho ilime lalo amideko nemotoka niseko minokaka nesa minamiye. ");
INSERT INTO yby_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Loko liyoko, ya yupekaya wavu-liki wewena nisiki magoina minabototi maya hulimikiki wikayoko, ");
INSERT INTO yby_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jisesimamo unala ipalale yuha 12-pala loka oletoko sa-loko liye: Edimokiya asaiki hulinimikiki wetune liki nilahe. ");
INSERT INTO yby_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Loko liyoko, Saimoni Pitamamoya we napao, emodaya huloimikoko ekahitoka wetune. Emo makokolitaya elewole oko minokaka ga maya nolane. ");
INSERT INTO yby_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Sa-noaniyoko, lemoya emokumuya elewole oko elekaka noune. Emoya Omaimidana ipala wehe loko minane loko ele-minune. ");
INSERT INTO yby_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Loko liyoko, Jisesimamo sa-loko lo limiye: Nemoya wewenanele 12-palaya dilipe eto okoboya, edimokutiya makolimoya Olohaloka mino molakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Loko liboya, Kaliyoti numutokati Saimonida ipala Judasiya Jisesida unala ipalale yuhauti welimoya mimi etibokumuya liye. 68 Mat 16:16; Mak 8:29; Luk 9:20 ");
INSERT INTO yby_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sakiya Jelusalemu numutokati Juda wewenasida ujapa wenipolesiya Jisesida maya kohatune liki dabuha molikayoko, Judiya eba maya hulikoko Galeli ebakukagoya woga nisega oko ne. ");
INSERT INTO yby_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Sakoya neyoko, mida numuda holi maya soto pekolo alili okaiyoko, ");
INSERT INTO yby_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jisesida unalale yuhamasiya sa-liki li me: Wewenakale maya elewole nesa lolo okaka noadawo maya mudatae loko maya, maya ebaya hulikoko woko Judiya ebakuka maya lolo-halo ideko mudatae. ");
INSERT INTO yby_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wewena makolimo soto pituwe loko sunauka minoko yowanu lekaka amibo nesa maya ne. Emoya yamidana yowanu lituwe loko maya woko wewenasida dowisanipolo lideko mudatanako, ");
INSERT INTO yby_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","liki unalamotasi laboya emodamuya elewole iki data kamiki labo ne. ");
INSERT INTO yby_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Liki likayoko, Jisesimamo sa-loko lo biye: Edimoya saina-painahena lolo etune liki maya aha lolo itaboya, nemoya Judiya ebakuka wetubo onawaya owaha ne. ");
INSERT INTO yby_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Edimosidaya monoka elamabo wewenasiya kohadelamikilae. Nemokahoya miniki liki niabolawa maya lahelamiyoko lo soto molokaka nobo nesaloya kohanelakilae. Sa-oneyo, edimoya holi onawauya wilo, nemo onawaneya owaha nenako, ");
INSERT INTO yby_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","9","olotiya wamoko amaloka minakoloe, loko Galeli ebakukaya nebo ne. 2 Liv 23:34; Dut 16:13 ");
INSERT INTO yby_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sa-iboya, unala ipalale yuha lemo holi onawa minatune loko Jelusalemuga omutoko yowokuniyoko, Jisesima alikaya eimolago halukoko yowiye. ");
INSERT INTO yby_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sakoya noyowiyoko, Juda wewenamasiya holi onawau emokumuya moniki loka loka iki nakahauka maya niseko netihelae liki ohu je. ");
INSERT INTO yby_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sakiya moniki ohu nijeyoko, maloka wewenasiya musika ga liki Jisesiya we lalo maya ne. Liki layoko, malokasiya emega liki, hulikalo, emokahoya muki wewenasida maya dilipe opa napa okaka noiyo. ");
INSERT INTO yby_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Liki laboya, Juda wewenasida ujapa wenipolesidamuya domoda wokaiyoko ga napa lamiki musika ga liki labo ne. ");
INSERT INTO yby_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sa-iyoko, holi onawa napau maya Jisesimamo monoka numuda napau maya yoweko monoka monawahena maya api-napi o-benebo ne. ");
INSERT INTO yby_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Sakoya neyoko, Juda wewenasiya agae liki sa-liki lae: Emoya lemo sukulu ludawokuya magoina sukulu lamibo maya nenako, monoka monawahenaya nakahaukatima elibo ga nolihelae, liki lae. ");
INSERT INTO yby_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Liki layoko, Jisesimamo sa-loko lo biye: Nemo monoka monawahena api-napi olibekaka noboya, nenimone nata eleko lamoe. Ahone noli hibo wemitokati eleko lo libekaka noe. ");
INSERT INTO yby_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wewena malokasiya Omailimo letiboto molatiboto eletune liki litabo maya alikaya aya monokamuya nemotokati nehe ito Omailokati nehe liki aha elikilae. ");
INSERT INTO yby_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wewena mako edimonipo data elitaboto litabo maya dupanipo liki yowiki likilae. Maloka wewenasiya yowanu ahola doli hibo wemidanago upa leko yoweko letune liki yowanu litabo weya we huluwa suwaki namaki lamabo wewenae loko letune. ");
INSERT INTO yby_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Edimokutiya Mosesekaho lo hukoko libo ga lo libibo maya emesalo molabo wewena ma minamae. Sa-oneboya, nemo lobo ga maya elikiki nenaha iyoko kohanelatune liki lae. ");
INSERT INTO yby_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Loko liyoko, muki wewenamasiya emoya madoka opa napa okaiyoko nolape, ekahimamo kohaelatuwe loko noliyoko nolane, liki lae. ");
INSERT INTO yby_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Liki layoko, Jisesimamo nemoya holi onawau maya oliwaki elewole nesa makoko lolo obo maya mudaikiki aiyo woiyo li-minabo ne. ");
INSERT INTO yby_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ya neyo, Mosesekaho oluhotipolesida dupalo Omaimidana anela molibitatae loko lolibetaibo maya, Mosesekaho api oko lamiye. Latatipolesiya api abo ne. Sakoya aya yowanu litabo onawa maya alili okaiyoko, holigu maya ne liki lamiki aya yowanu aha likaka niae. ");
INSERT INTO yby_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yaya Mosesekaho libo ga maya woko aha nesa lolo okatiye liki Omaimidana anela maya oluhotipolesida dupaloya holi onawalo molikaka nianako, nemoya holi onawau maya we ebilimidana ilime haka lobokumuya nenaha iyoko duka kohaneliminae. ");
INSERT INTO yby_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Edimoya aya nesamidana monawa maya elamiki maya aha alinali ga lamilo, monalo eli-minikigo lilo. 18 Liv 12:3; Jen 17:10 23 Jon 5:9 ");
INSERT INTO yby_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Loko lokaiyoko, Jelusalemu wewena malokasiya sa-liki lae: Kohatune liki likaka niabo we maya yaya nehe. ");
INSERT INTO yby_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nenaha iyoko maya ga soto nolibotoya duliki wesiya emega lamae. Edimosiya monawala ohu jiki li wehe laboya Omailimo lahelamibo nesauti lilimitiye loko lo mololetaibo we maya ne liki nilahe. ");
INSERT INTO yby_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sako minamiye. Maya wemidana etabolawaya alo ele-minune. Lahelamibo nesauti lilimitiye loko lo mololetaibo we soto pitiboya monawala elametudawo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Liki layoko, Jisesi maya monoka numuda napau maya monoka monawahena lainimi obetoko nebototiya sa-liki labo ga maya elekoko ga napauti sa-loko liye: Olo, edimoya nemo etaboki nemo monawanekiya ele-minune liki nilaboya, nemo lemoboya nenimone nata eleko lemamoe. Wati gamidana ahola maya nenako, aya welimoya noli hekaiyoko leme-minobo maya neboya, aya wemidanamuya elamae. ");
INSERT INTO yby_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nemoya aya wemidana amaitoka minoyoko, noli hekaiyoko leme-minobo maya nenako, nemokahoya monawala ele-minoe. ");
INSERT INTO yby_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Loko liyoko, maya wewenamasiya nala metune liki saboya hilitibo onawala maya owaha nenako, likiki hulitae. ");
INSERT INTO yby_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sa-ikayoko, edimokutiya wewena malokasiya emodamuya elewole iki data kikiki sa-liki lae: Maya welimoya elewole nesa api-napi okaka noinako, lahelamibo nesauti lilimitiye loko lo mololetaibo welimoya Jisesidaya asetamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Li esa abo wewenasiya sa-liki nilayoko, elikiki Palasisi wewenasiya wiki Omaitoka jokila hi mikaka wehenakiya ligi hagi ikiki Jisesida maya ilimi nala numuku molatae liki imiki wesida liki doli he. ");
INSERT INTO yby_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sa-ikayoko, Jisesimamo nemoya onawa lasolasima edimoki minokoko noli hibo weloka wekoloe loko liye. ");
INSERT INTO yby_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Sakoya wekolonako, edimosiya nemodamuya ohu jitabo maya muda-nelamikilae. Sako woko minatubotokaya nena nena iki witae. Ma wamikilae. ");
INSERT INTO yby_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Loko liyoko, Juda wewena maya edimonipo sa-liki ligi hagi ae: Maya welimoya nakahaloka woko nedeko ohu jetudawomu noliye. Juda wewena maya wavu-liki Guliki mikauka wiki minanako, yaloka woko monoka monawahena api-napi obeko minadeko ohu jetudawomu lihe. ");
INSERT INTO yby_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Edimoya nemodamuya ohu jitaboya muda-nelamikilae, ito minatubotoka wamitabo ne loko liboya nenaha etibomu lihelae liki lae. ");
INSERT INTO yby_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Juda wewenasida holi onawanipo maya suwekolo noiyoko, Jisesimamo niseko ga napauti sa-loko lo biye: Wewena mako notipomu delokadeko maya nemototi nisiki natayo, nisilo. ");
INSERT INTO yby_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ito monoka bukuguya nemodamu elewole iki data kitabo wewenamuya sa-liki luhuwa ji-minabo maya ne: Dukauti monokalimoya no lisadakidana jeko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Loko Jisesimamo liboya emodalamuya elewole iki data kitabo wewenasida maya Omailimo weuna oluho libitiye loko liye. Jisesiya okulumau onowelaki ito lamedakiya ukau yowamekolaiye loko Omaimidana weuna oluho maya owaha bamidanaki libo ga maya ne. 37 Liv 23:36 34 Aes 58:11; Jek 14:8 ");
INSERT INTO yby_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ga maya wewenamasiya elikiki Jisesidamuya sa-liki lae: Wehe loko Omaimidana epaloti ga lokaka weya ewa ominudawo we maya niseko soto pekaiye. ");
INSERT INTO yby_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Liki malokasiya layoko, malokasiya emoya Omailimo lahelamibo nesauti lilimitiye loko lo mololetaibo we maya netiye, liki laha, malokasiya Galeli ebakuti soto penebo we maya ne, likiki pelesa jiki sa-liki lae: Lahelamibo nesauti lilimitibo weya nena nenako maya Galeli mikauti soto pitibo ne. ");
INSERT INTO yby_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Monoka bukuguya lahelamibo nesauti huka lemeko lilimitiye loko lo mololetaibo weya Betilihamu numutokati Dewitida ouvamelalesikuti wehe loko soto pitiye liki luhuwa ji-minabo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Liki likiki emokumuya mini maloka maloka ae. ");
INSERT INTO yby_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sa-ikayoko, malokasiya nala metune liki laboya, dadelo eda okaiyoko hulitae. 42 Mae 5:2 ");
INSERT INTO yby_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sakiya monoka numuku ujapalo we imi we minabo maya aku li wili jiki wikayoko, Omailoka jokila hi mikaka weki ito Palasisi wekiya minikiki loka ibitiki lae: Edimoya nenahamuya Jisesida maya ilimi-liki nisamae. ");
INSERT INTO yby_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Liki layoko, imiki wemasi sa-liki lae: Aya welimo gahena nolibo nesa liki wewena makosi lamae. ");
INSERT INTO yby_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Liki layoko, Palasisi wewenasiya sa-liki lae: Edimodakiya dokepa jiyoko nilahe. ");
INSERT INTO yby_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Palasisi wewenaki ito ujapalo we malokakiya emodamu eleboya elewole noihe. ");
INSERT INTO yby_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","O'e, li hukabo ga maya elamabo wewena maya li esa iki minadanaki, Jisesidamuya elewole iki elikadanaki, Omailimo mesaha jebetonebo wewena minae. ");
INSERT INTO yby_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Liki layoko, edimokutiya we mako Nikodimasiya omutoko lubukaya Jisesi neboto wibo wemamo sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Edimogoya lilo. We makoya monawala mudaikiki ito lihimala mudamiki kohatune liki likaka niahe. Monoka bukuguya sa-loko minamiye. ");
INSERT INTO yby_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Loko liyoko, iwelalesiya auha miki sa-liki lae: Emokiya asako nosamibo eba Galeligatiya nisedawo nehe. Sa-lokaniyo, emolitaya monoka bukuguya ohu jewa ohu jewa oko sa-loko elitaniyo. Galeli ebakukatiya Omaimidana epaloti ga lokaka we mako soto pitiye loko keke minamiye.  ");
INSERT INTO yby_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Liki likiki hutili iki numudanipoloka maya wiwi ae. 50 Jon 3:1-2 ");
INSERT INTO yby_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nisikayoko Jisesimamo Olivi ya bolau maya yowiye. ");
INSERT INTO yby_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Udikiki go maya loko, ho ijala maya nohulaiyoko, monoka numuda napau maya yoweko neyoko, muki wewena maya Jisesi nebotoka maya nisiki li esa ikayoko, mikalo nedanaki monoka monawahena maya lainimi obetaiye. ");
INSERT INTO yby_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Sakoya monoka monawahena maya api-napi nobetaiyoko, monoka monawa lainimi ikaka weki ito Palasisi wemaki mena makoya we ukelelo menaya we makoki udi-minaiyoko, muda-elikiki adelo liki liki nisiki Jisesi maya neboto luwato maya hulitikiki sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tisate yamalae, maya menaya we makoki udi-minaiyoko mudakoko adelo leko leko nonisudawolae. ");
INSERT INTO yby_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ito Mosesekaho lo hukaibo gauya yamidana menakipa maya ehadaloti kohaidi hulalo loko loletonebo maya nenako, emoya nenae loko nolane, liki loka itikiki ga letibotoe liki ujapa i-minae. ");
INSERT INTO yby_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sa-liki laboya, kohalo loko lidekoma obi oetatune, ito hulitalo loko lidekoma obi oetatune liki elehukidana vi-miniki aha ohumanau hiki lae. Sa-liki laboya, Jisesimamo ga mako lokadeko, elekoko, yalotiya le ya gauya moloko kohatune liki data kikiki layoko, Jisesimamo mino mikalo molonedanaki, ade umawa makokolotiya mikalo maya luhuwa jiye. ");
INSERT INTO yby_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sakoya nojiyoko, loka itikiki, akuya loka nitayoko, sinokoko sa-loko lo biye: Edimotokati we mako lihimala minametibo welimoya adaya ehada hulo upalo jekadeko alika kohalo. ");
INSERT INTO yby_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Loko lokoko, akuya mino lipeko mikalo maya luhuwa jiye. ");
INSERT INTO yby_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Sakoya mikalo luhuwa nojiyoko, ahonipo maya le omutokaiyoko, makoko makoko iki wiki suwae. Sakiya wikayoko aya menamagoya Jisesida amaitoka maya neyoko, ");
INSERT INTO yby_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisesimamo mino haka loko wenu eloko loka oetoko sa-loko liye: Ma menalae, malo minabo wewena maya nakahaloka wae. Amaloya miniki lihimakamuya obi igitamahe. ");
INSERT INTO yby_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Loko liyoko, aya menamamo we napane yamalae, samabowae. Loko liyoko, Jisesimamo nemokiya lihimakamuya obi ogetamoe, loko lokoko, sa-okaniyo, woko numudakaloka minoko maya aku ayamidana lihima nesa lolo amo, loko lo miye. 5 Liv 20:10; Dut 22:22-24 ");
INSERT INTO yby_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisesimamo alikaya ga maya esewau leko nemoya muki maya mikau wewenasida lenipo minoe loko liye. Sa-ominonako, nemoda nemeke molatabo wewena maya lubu jitiboku wiki minamikilae. Elewole lameda maya likiki minakilae. ");
INSERT INTO yby_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Loko liyoko, Palasisi wewenamasiya eimoka monawaka lo soto moloko ladawoya, lemo eluniyoko, lahelamiye liki lae. ");
INSERT INTO yby_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Liki layoko, Jisesimamo sa-loko lo biye: Neimone monawane lo soto moloko loboya, nemoya nakahauti nisekoko ito nakahauka wetubomidana monawaya le-minoko noloboya wehe loko ihilatoka noloe. Edimoya yamidana mamidana nesa mako elamae. ");
INSERT INTO yby_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Edimoya wewenasida monawanipo li mumusopa jikiki yowanuwa likaka niaboya, aha hutuwaya likaka niae. Nemoya monawahenaya le mumusopa jekoko oloti lamoboya, ");
INSERT INTO yby_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","nemoya monawahenawaya le mumusopa jeko lituboya, neimonego lituboto minamiye. Noli hibo welimo letiboto lituboya woko anuwalo lekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mosesekaho lo hukoko libo gauti sa-loko mako nebo ne: Wewena lowesiya wewena makomidana monawalamuya li makoko aweyaha iki yowanu lisaiboya woko anuwalo litibo ne loko lonebo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Neimone monawane maya noloyoko, noli hibo we ahonekahoya asako monawane maya lo soto molokaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Loko liyoko, loka itiki ahokaya nakahama ne, liki layoko, Jisesimamo edimoya nemo monawane maya elamanako, nemo ahonedakiya monawala elamae. Edimoya nemo monawane eleboto minatidanako, ahonedakiya monawala eletine. ");
INSERT INTO yby_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Loko Jisesimamo liboya, monoka numuda napauya ehada molikaka bokisi apilaloka minoko, monoka monawahena lainimi obeko, aya gaya liboya helitibo onawala maya alili amiyoko nenako, wewena makolimo ilime nala numuku molamibo ne. 08 Mat 5:12; Jon 9:5 13 Jon 5:31 ");
INSERT INTO yby_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisesimamo sa-loko lokoko aku amida meko sa-loko lo biye: Edimoya nemokaho hulolibikoko wokoyoko, moniki nemodamu ohu jiki jiki ikiki lahelamibo weutipokiya aha miniki helikilae. Sakiya helikiki nemo woko minatubotokaya ma wamikilae. ");
INSERT INTO yby_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Loko liyoko, Juda wewenamasiya sa-liki lae: Nemo woko minatubotoka ma nisamikilae loko liboya, nenahamu liye. Eimola upala le lahelamibo oko helekolo nolihe. ");
INSERT INTO yby_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Liki layoko, Jisesimamo edimoya mikauti minae. Nemoya yowauti minoe. Edimoya ma mikauti minaboya nemoya ma mikauti minamoe. ");
INSERT INTO yby_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sa-onenako, nemoya yamuya lahelamibo weutipoya aha nedeko helikilae loko lo noliboe. Nemoya minoko monawane lo noliboboya, nemoya Omailoti lemobo we minane liki elewole iki data kamitaboya, lahelamibo weutipokiya helikilae. ");
INSERT INTO yby_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Loko liyoko, loka itiki sa-liki lae: Olo, sa-ideya maya, emoya ekahima minane. Liki layoko, Jisesimamo sa-loko lo biye: Api oko maya mikau lemobototiya lo libe-loko wokaka nobolae. ");
INSERT INTO yby_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nemoya muki wewenalika lihimatipoya le-minobolae. Sa-noyoko, noli hibo welimoya ga ulawa lokaka noiye. Sa-noiyoko, nemoya epauti ga elobo maya nenako, ma mikaukaya lo soto moloko lo libekaka noe. ");
INSERT INTO yby_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aholadamuya sa-loko lo bibo maya aya wewenamasiya eli wehe lamabo ne. ");
INSERT INTO yby_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sa-ikayoko nenako, Jisesimamo amida meko sa-loko liye: Edimoya nemo okulumauti we uti maya yoho yaha yalo nalawa iki tikadeko maya nolobo nesahenaya soto pideko mudatayo. Ito eimola atauti yowiboto yowanu lamoko, aholakaho liboto yowanu lekaka iye liki alikaya eli wehe litayo. ");
INSERT INTO yby_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Noli hibo weki nemokiya magoina minoiye. Nemoya muki yupeka sainahena oko moloko noboya umu helekaiyoko nenako, ma hulonetamiye. ");
INSERT INTO yby_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Loko liyoko, yaloti maya muki wewenasiya emokumu lahelamibo nesauti lilimitiye loko lo mololetaibo wema ne liki elewole iki ele. ");
INSERT INTO yby_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Juda wewena elewole iki elebolawasida Jisesimamo sa-loko lo biye: Edimoya nemo ganelogo minataboya nemo oluhone wehe liki minakilae. ");
INSERT INTO yby_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sa-ikiki ga ulawalimoya nalatipo maya wina olibetokadeko wati iki minakilae. ");
INSERT INTO yby_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Loko liyoko, edimomasi sa-liki li me: Lemoya Aebalahamuda ouvamela minuniyo, wewena makolimo meinawa lamiki agowe yowanu limibomidana nalauti maya olotiya wina oletokadeko wati oko minatune loko nolape. ");
INSERT INTO yby_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Liki layoko, Jisesimamo sa-loko lo biye: Nemoya wehe loko ga lo libituyo, elilo. Wewena mako lahelamibo nesa liki minatabo wewenaya aya nesalimoya nala jebetokadeko minakilae. ");
INSERT INTO yby_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Agowe yowanu lebo wewenasiya ujapa wenipomidana numudalau maya minamikilae. Aya wemidana ipalagoya onawa hanaya oluholago mino-loko woko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yamuya Omaimidana ipalakaho wehe loko nalauti maya olutolibetokadeko nalau minamikilae. ");
INSERT INTO yby_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Edimoya Aebalahamuda awolale minune liki layoko, mudalido-minoboya, ganeya dukau minamiyoko nenako, nemoda maya kohanelatune liki likaka niae. ");
INSERT INTO yby_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nemoya ahoneda amaitoka neyoko mudaobo nesamugo lokaka noe. Ito edimoya ahotipole nesa mudabomugoya likaka niae. ");
INSERT INTO yby_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Loko liyoko, lemo ahoteya Aebalahamuya nenae. Liki layoko, Jisesimamo sa-loko lo biye: Edimoya Aebalahamuda awolale minatidanako, Aebalahamu ibo nesa letine. ");
INSERT INTO yby_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nemoya Omailokati ga ulawa elobo ga maya lo libobomamuya kohanelatune liki likaka niaboya, Aebalahamuya sa-loko lamiboma ne. ");
INSERT INTO yby_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Edimoya ahotipole abo nesa likaka niae, loko liyoko, edimomasi sa-liki li me: Lemoya anulo oluho minamune, Omaiya ahote makoko ne. ");
INSERT INTO yby_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Liki layoko, Jisesimamo nemoya Omai minobototi wewena lolo okoko leme-minobo maya nenako, ahotipo Omai minatidanako, dukaya nemotoka moli nemetine. Aha neimone nata eleko soto pamoe, Omailimo noli hekaiyoko leme-minoe. ");
INSERT INTO yby_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nemo ganeya nenaha iyoko eli wehe lamae. Nemo ga noloboya eda delokaiyoko elamae, yamuyae. ");
INSERT INTO yby_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Edimoya ahotipo Olohalimo umu helitibo nesago letune liki data kikaka niae. Emokahoya hapa yeikalaloti api oko kohaidokaka omo nonisiye. Ukauya ga ulawa mako minamiyoko emesa mekaka noiye. Suwa gamidana ahola ito suwa nesaya nodenesala lolo iyoko, yalo ata ke-minoko sa-okaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nemoya ga ulawa maya lo libekaka noboya edimoya eli hulikaka niae. ");
INSERT INTO yby_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Edimotokatiya wewena makolimo nemo lihimane netiboya lo soto moladeko woko wehe letihe, sakoya minamiye. Nemoya wehe loko ga ulawa maya lo libekaka noboya, nenaha iyoko maya elewole iki eliki emesalo molamae. ");
INSERT INTO yby_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Edimoya Omaimidana oluhola minataboya Omaimidana gala maya elikilae. Sa-itanako, edimoya Omaimidana oluhola minamiki, gala maya eli hulikaka niae. 33 Mat 3:9; Luk 3:8 ");
INSERT INTO yby_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Loko liyoko, Juda wewenamasiya sa-liki li me: Emoya Samaliya we maya madoka opa noiyoko lokaka noane loko lokaka noudawo maya wehe loko lokaka noune. ");
INSERT INTO yby_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Liki layoko, Jisesimamo sa-loko lo biye: Nemoya madone opa iyoko lamoe. Edimolitaya nemodaya liki mumusopa jikaka niae. Ahoneda maya ilime napa oko lokaka nohao. ");
INSERT INTO yby_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nemoya nuline wetiye loko lamoe. Yamidana nesaya ahoneda nesala ne. Emoya ga lo huko huko weya nenako, muki wewenasida monawanipomuya lo hukobetakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nemoya wehe loko lo libekoloyo, eli-minalo: Nemo gane ele litibo wewena maya ukalahena ito weunahenaya helamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Loko liyoko, Juda wewenasida ujapa wenipolesiya sa-liki lae: Emoya madoka maya alo opa okaiye. Aebalahamudamuya ladawoya alo helekaibo we maya nehao. Ito Omaimidana epaloti ga likaka wehenaya alo hapa helikabo maya neboya, nemo gane elitabo wewena maya dukahena ito weunipohena helametiye loko nolape. ");
INSERT INTO yby_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Latate Aebalahamuya yoweko nebo we maya helibo ne. Emoya Aebalahamuda maya asetakolo nolape. Ito Omaimidana epaloti ga likaka wehena maya alo asaiki helikabo maya neyo. Emoya nakaha wemu nolane, aha suwa loko upaka leko yoweko nolane. ");
INSERT INTO yby_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Liki layoko, Jisesimamo sa-loko lo biye: Neimonego nupane leko yoweko letuboya wehe lamekolaiye. Ahone Omaiye liki likaka niabo welimoya nilime napa okaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Edimoya aya wemidanamuya eli wehe lamae. Neimonekahoya aya wemidanamuya ele wehe lo-minoe. Ahonedamuya elamoe loko letuboya edimokidana suwalo we minokatuwe. Ahonedamuya ele-minoko galakiya le-minoe. ");
INSERT INTO yby_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Latatipo Aebalahamuya nemo maya mikau lemobolawa maya wamotoka muda-nelokoko elowa jeko nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Loko liyoko, aya ujapa wemasiya sa-liki li me: Emoya meleke 50 wamiyokoya Aebalahamudaya mudaelo-minape, liki lae. ");
INSERT INTO yby_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Liki layoko, Jisesimamo nemoya wehe loko lo libituyo, eli-minalo. Aebalahamuya owaha soto peko minamiyoko, nemoya omutoko minobo we maya olotiya lemeko maya minoe. ");
INSERT INTO yby_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Loko liyoko, ehada maya likiki kohatune liki sa-niayoko, Jisesimamo aha nesa lolo oikoko monoka numukuti muki wewenasida luwawanipouti maya lemeko wiye. ");
INSERT INTO yby_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yu makoya Jisesimamo anu moloko widanaki, we makoya dolada ohumanaukati omuda likonebo etaibo wemidanaya muda-elaiye. ");
INSERT INTO yby_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sakoya nomudaiyoko, wewenalalesiya Jisesida maya loka itiki monoka ujapa wete yamalae, ekahida lihimalalimo omudala likaibo we soto piye. Eimola lihimalamohe ito dolako aholakosida lihimanipomoe. ");
INSERT INTO yby_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Liki layoko, Jisesimamo sa-loko lo biye: Yatoka nesalimo samiye. Ito dolako aholako lihimanipomo samiye. Omaimidana elewoleyala maya ya weloya soto pitiye loko omudala likaibo weya soto piye. ");
INSERT INTO yby_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ma mikau wewenasiya holiyagoya yowanu likiki lubukaya yowanu lamae. Asakoya ahone noli hibo wemidana yowanula maya olotigo lekoko, alikaya onawa suwokadeko yowanula lamekolune. ");
INSERT INTO yby_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nemoya maya mikau minobo onawaloya ma mikau wewenasida lenipoya minakoloe. ");
INSERT INTO yby_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Loko lokoko, mika maya leko etehu okoko akula jeko aya omudala likaibo wemidana omudalalo maya hiletoko sa-loko lo meko oli hiye: ");
INSERT INTO yby_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Emoya woko no mako Siloamuye loko nebo noku maya noku udoko humawaka maya nokalawe oko le hulo. Aya no uliwamidana monawaya koha puti-minaboe loko ne. Loko liyoko, woko nokalawe oko omudala maya halatokaiyoko nisiye. ");
INSERT INTO yby_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sakoya omudala maya halatiyoko, iwelasi ito omutoko ehadamu wako noliyoko mudaikaka abo wewenamasiya muda-elikiki ehadamu wako wako loko humeko minokaka ibo we maya nehe, liki lae. ");
INSERT INTO yby_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Liki layoko, maloka wewenamasiya oo, aya we maya nebowae, liki layoko, maloka wewenamasiya o'e, ayakidana we mako netiye liki layoko, aya wemamo sa-itahe nemo aya we maya minobowae. ");
INSERT INTO yby_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Liyoko emoya nenaha aniyoko omudaka yaitaya halatiye. ");
INSERT INTO yby_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Liki layoko, sa-loko lo biye: We mako Jisesiyo loko nebo welimoya uha maya etehu oko nomudanelo maya hilenetokoko woko Siloamuye loko nebo noku maya woko nokalawe o loko noli hekaiyoko woko nokalawe oyoko nomudane maya pana kiye. ");
INSERT INTO yby_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Loko liyoko, aya wewenamasiya loka itiki aya weya nakahauka maya ne, liki layoko, aya wemamo nemo muda-elamoe loko liye. 5 Mat 5:14; Jon 8:12 ");
INSERT INTO yby_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Loko liyoko, aya wemidana maya ilimi-liki Palasisi wewena minabotoka maya wae. ");
INSERT INTO yby_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisesikaho omudala le pana ketaiboya holi onawau maya sa-iye. ");
INSERT INTO yby_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Sa-iyoko Palasisi wewenamasiya nisiki omudala pana kibo wemidana maya aku loka itiki layoko, sa-loko lo biye: Aya welimoya uha maya nomudanelo hilenetaiyoko, woko nokalawe joyoko nomudane maya pana kiye. ");
INSERT INTO yby_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Loko liyoko, Palasisi we malokasiya Jisesidamuya sa-liki lae: Lemo holi onawate maya le opa okaka noinako, aya weya Omailokati minamiye. Liki layoko malokasiya sa-liki lae: Emoya lahelametibo we netiboya mamidana yowanuya nena nenako maya litiye. Liki likiki ona moliki mini maloka maloka ae. ");
INSERT INTO yby_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sa-ikiki omudala le pana ketaibo wemidana maya eimokaya nenae loko ata nokene liki layoko, Omaimidana epaloti ga lokaka we netiye loko liye. ");
INSERT INTO yby_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sa-okaiyoko Juda wewenasida ujapa wenipolesiya omudala likonebo we maya pana kekaiyo liki elewole iki data kamiki dolako aholakosida maya ju likiki sa-liki loka ibitae: ");
INSERT INTO yby_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ipatipo maya omuda likonebo etoibo ne liki nilaihe. Ito aya ipatipo maya nehe. Nena nena okoko omudala maya pana kiye. ");
INSERT INTO yby_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Liki layoko, dolako aholako maya lemo ipate maya ne loko ele-minoiye. Ito omudala likaibo etoibo maya ne loko ele-minoiboya, ");
INSERT INTO yby_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","olotiya nenaha okoko omudala maya pana kihelae. Ito ekahimamo omudala le pana kihe, yawaya elamoiye. Emoya lasola nehe, olopa we maya neyo, eimolada yaitaya loka italowo, lo soto molatiyo. ");
INSERT INTO yby_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Liki laiboya Juda wewenasida ujapa wesiya alo sa-liki li hukaboto ne: Wewena makolimoya Jisesiya lahelamibo nesauti huka limitibo we ne loko letibo wewenamidana maya monoka mosetatune liki labo maya nenako likiki, dolako aholako maya Juda wewenasida ujapa wesidamuya domoda wokaiyoko, ");
INSERT INTO yby_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ipateya olopa we maya neyo, loka italowo liki laiye. ");
INSERT INTO yby_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Liki likaiyoko, omudala pana kibo wemidana maya aku ju likayoko, nisiyoko sa-liki loka itae: Emoya Omaimidana omudaloya wehe loko lo. Lemoya aya welimoya lahelamibo yowanu lekaka noiyoko noludawo we nenako, uliwa le sawa jamo. ");
INSERT INTO yby_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Liki layoko, aya wemamo lahelamibo yowanu lekaka we nehe, yawaya elamoe, Nemoya omutoko nomudaneya likonebo we maya minoboya olotiya pana kekaiyoko wati okoe lokogo noloe. ");
INSERT INTO yby_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Loko liyoko, aku loka itiki nena nenako maya omudaka le pana ketaiye. ");
INSERT INTO yby_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Liki layoko, alo maya lo libekobo maya neha, edimoya elamahe. Akuya nenahamu loyoko eletune liki nilae. Edimokiya Jisesida unala ipalale yuha lolo etune liki nilahe. ");
INSERT INTO yby_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Loko liyoko, auhala miki sa-liki lae: Emoya aya wemidana oluhola minane. Lemoya Moseseda ouvamela minune. ");
INSERT INTO yby_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Omailimoya Moseseda ga maya lo mibo ne loko ele-minudawoya, aya wemidana etabolawaya lemo muda-minupao. ");
INSERT INTO yby_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Liki layoko, aya wemamo sa-loko lo biye: Nemo nomudane le pana kenetaibo wemidana etabolawaya elamune liki niahe. Nemoya ija nolibetoe. ");
INSERT INTO yby_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Lemoya sa-loko elekaka noune: Omailimoya lahelamabo wewenasidaya dilipe lalo etibo nesa leko minamiboya, makoko wewenalimoya Omaimidana epoka loetoko gala ele litiboya Omailimo ilime wati ekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ito hapa yeikala maya mika api oko soto pibototiya omudala likonebo we makomidana we makolimo le pana ketaiye liki layoko, ma elamudawo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sa-onenako, maya weya Omailokati lemametidanako, yamidana yowanuya lemetine. ");
INSERT INTO yby_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Loko liyoko, sa-liki lae: Ebili lahelamadawo soto pedawo maya neboya yalika yatoka eko yowekoko monoka lemekolo lape, liki likadanaki ipisiki hulae. ");
INSERT INTO yby_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisesimamo ipisiki hulae liki labo ga maya elekoko lasolasima minoko aya wemidana maya muda-elokoko sa-loko loka oetoko liye: Emoya okulumauti we utimidanamuya elewole oko ata nokepe. ");
INSERT INTO yby_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Loko liyoko, aya wemamo we lalo nesa yamalae, ladawo wemidana nilipekadeko muda-elokoko elewole oko nata ke mituwe. ");
INSERT INTO yby_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Loko liyoko, Jisesimamo emoya mudanelo-minadawo we ga lo noemobo we maya minobolae. ");
INSERT INTO yby_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Loko liyoko, aya wemamo we napane yamalae, olotiya elewole oko nata nokoe. Loko lokoko, i bola heko iguka maya udaiye. ");
INSERT INTO yby_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sa-iyoko, Jisesimamo sa-loko lo miye: Nemoya muki wewenasida monawanipohena maya ona molobetatuwe loko ma mikau lemobo maya nenako, dukamidana omudala minamibo wewenasiya li pana kiki mudatayo, ito lukamidana omudala likaibo ne liki labo wewena maya likonedeko ayamidana yatoka mini-liki yowiki minatayo. ");
INSERT INTO yby_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Loko liyoko, Palasisi wewena maloka minabosiya loka itiki lae: Olo, maya we yamalae, lemoya lukamidana omudala likonebo minupe. ");
INSERT INTO yby_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Liki layoko, Jisesimamo sa-loko lo biye: Edimoya omudatipo likonebo minatidanako, lihimatipoya minametipa, dukamidana omudala maya pana kene liki likaka nianako, lihimatipo maya aha minakolaiye, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisesikaho nemo ga wati aya lo libekoloyo, eli-minalo loko liye. Wewena makolimo sipisipi jasida ohonipou yowekolo maya oho akaloti yowamoko, oho ohalaloti yowekadeko maya ukelelo weya yowiye loko letune. ");
INSERT INTO yby_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Oho akaloti yowitibo wemuya ja ujapalo weya yowiye loko letune. ");
INSERT INTO yby_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sakoya yowekoladeko maya oho akalo ja ujapalo welimoya anu siyetatiye. Ito sipisipi jasiya aya wemidana onola maya elikilae. Sa-okoko sipisipi jasida maya duli loko ju loko dilipe nupa okoko dilipe-loko lemekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Oluholalesida maya dilipe-loko lemekoko emoma le omutideko, oluholalemasiya onola maya elikiki emeke moliki wikilae. ");
INSERT INTO yby_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aito we makomidanaya emeke molamikilae. Aito wemidana onola maya lena etibo nenako, domodanipo wideko oli ikilae. ");
INSERT INTO yby_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Loko Jisesimamo koha moloko ga mako sa-loko liyoko, edimomasiya nenahamuya lihelae liki ga libo maya monalo eli wehe lamae. ");
INSERT INTO yby_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sa-ikayoko, Jisesimamo amida meko sa-loko liye: Wehe loko wati gaya lo libituyo, eli-minalo. Sipisipi jasida ohonipou yowikaka atedaya nemoya minoe. ");
INSERT INTO yby_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nemo nisamoyoko soto pebo wewena mukiya ukelelo wegoya minae. Sa-iyoko, yamuya sipisipi jasiya ganipolo maya eliki demesalo molamabo ne. ");
INSERT INTO yby_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Atedaya nemoya minoe. Wewena mako nemoda asinitamiki atedaneuya yowitaboya wiki latila amikilae. Wikiki nisikiki iki mida numuda lalo nesau monikilae. ");
INSERT INTO yby_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ukelelo welimoya sipisipi jaya kohakologoya ohonipouya yowekaka noiye. Nemoya sipisipi ja maya elewole depa mutiwa liki elewole mida numuda lalo nesau maya moniki minatae loko lemobo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nemoya sipisipi jasida ujapa wenipo lalo maya minoe. Ujapalo we lalolimoya sipisipi jasidamuye loko minoko leko ibo nesala maya hulakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Elekele welimoya ja ahola minamibo nenako ito ujapa lalo nesa ametibo nenako, liwe ula nisitiboya mudakoko sipisipi jalasida maya hulobikoko oli wekolaiye. Sa-ideko liwe ulamamo sipisipi jasida maya kohaidoko dilipe hutili ekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Aya welimoya meinawa lituwe lokogo ata ke-minoko yowanu lekaka noinako, sipisipi jasidamuya ata kamoko hulobikoko oli etibo ne. ");
INSERT INTO yby_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nemoya sipisipi jasida ujapa wenipo laloya minoe. Ahoneki nemokiya mudako ele-minoinako, ");
INSERT INTO yby_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","asako wewenaneleki nemokiya mudako ele-minune. Yamuya sipisipi ja edimokumuye loko minoko leko okaka nobo nesa maya hulakoloe. ");
INSERT INTO yby_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ito sipisipi janeleya nala malokaki minae. Edimoya maya oho ulauti nisamae. Sa-iminanako, nemoya dilipe-loko nisekoyoko, onone maya elikilae. Sa-ikadeko, sipisipi ja maya nala makoko minakilae, ito ujapa wenipoya nemo makoko minakoloe. ");
INSERT INTO yby_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nemoya minoko leko nobo nesa maya hulakolo nobomuye loko, ahonekahoya ukala nemekaka noiye. Sakoya minoko leko nobo nesaya hulikoko aku ohatama lekoloe. ");
INSERT INTO yby_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Sa-onenako, yamuya minoko leko etubo nesaya wewena makolimo hipo amekolaiye. Neimoneya elekoko hulakoloe. Nemoya minoko leko nobo nesaya hulikoko aku lituwe loko letubomidana elewoleyawaya neimonetoka ne. Yamidana lolo etane loko ahonekaho lonetonebo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Loko Jisesimamo yamidana ga maya lokaiyoko, Juda wewenamasiya ligi hagi iki mini maloka maloka ae. ");
INSERT INTO yby_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sa-liki likiki, edimokuti muki wewenamasiya emo yaitaya ukau olohalimo yowanu noliyoko opa napa ga maya nolihao, edimoya nenahamuya elikili niae. ");
INSERT INTO yby_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Liki layoko, malokasiya oloha makolimo ukau yowenetiboya yamidana gaya lametibo ne. Ito oloha makolimoya domuda likaibo wewenasidaya ma le pana kebetamekolaiye, liki lae. 15 Mat 11:27; Luk 10:22 ");
INSERT INTO yby_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Juda wewenasida monoka numudanipo lusa vabomidana onawala maya lasi onawa maya alili noiyoko ne. ");
INSERT INTO yby_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisesimamo monoka numudau yawago nebo eba mako uliwa Solomoniyo loko nebokuya woko niseko oko neyoko, ");
INSERT INTO yby_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juda wewenasida ujapa wenipolesiya nisiki ilimi wego ikiki sa-liki li me: Emoya nenahamuya onawa hanaya monawaka le suna okaniyoko ele opa napa okaka noune. Emoya lahelamibo nesauti lilimitiye loko lo mololetaibo we maya minatadawoya, lo soto moloko lo lemowo. ");
INSERT INTO yby_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Liki layoko, Jisesimamo nemoya lo libekaka noboya, edimoya eli wehe liki elamae. Ahoneda galalo yowanu lekaka nobolimoya lo soto molokaka noibolae. ");
INSERT INTO yby_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Edimoya sipisipi ja lolo iki minamanako nemo ganeya elamae. ");
INSERT INTO yby_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipisipi jane lolo iki minabo wewenasiya nemo onone maya elikaka niayoko, mudalidokoko ju loyoko nemeke moliki nisikaka niae. ");
INSERT INTO yby_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Sa-onenako, nemoya elewole depa mutiwa maya bekoyoko, wiki latila amiki elewole iki minakilae. Edimosidaya nemo nadeutiya wewena makolimo niseko hipo amekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ahone nemotoka dilipemo molaibo weya muki nesasida asebetoko nenako, adeutiya wewena makolimo hipo amekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nemoki ahonekiya makoko minoiye. ");
INSERT INTO yby_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Loko liyoko, Juda wewenasida ujapa wemasiya akuya ehada maya likiki kohakilayoko. ");
INSERT INTO yby_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisesimamo sa-loko lo biye: Oliwaki elewole nesaya ahoneda abuhalaloti lekaka noboya, edimoya nakaha yowanuya lahelamibo loyoko, ehadalotiya aku kohanelatune liki nilae. ");
INSERT INTO yby_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Loko liyoko, Juda wewenamasiya onoto liki sa-liki lae: Yowanu lalo lekaka noadawomu lamune. Emoya wewena lemokidana maya minadawoya, Omai pulekolo, eimokada maya le Omailoka moloko nemo Omai minoe loko lokaka noadawomuya kohaelakolune. ");
INSERT INTO yby_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Liki layo, Jisesimamo monoka bukutipou maya we makolimo sa-loko libo ga maya luhuwa ji-minabo maya ne: Edimoya omai nesaya minae loko lobolae. ");
INSERT INTO yby_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Loko liboya, Omaimidana gala soto pe bibo wewenamuya omai nesae loko libo nenako, ito monoka bukugu luhuwa ji-minabo maya lemeko udatibo nesa minamiye. ");
INSERT INTO yby_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sa-onebo nenako, ahonekahoya nilime lene oko noli hekaiyoko maya mikau lemobo we Omaimidana ipala minoe loko lobo maya nenako, edimoya nenaha iyoko Omai pulekaka noane, liki nilae. ");
INSERT INTO yby_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yowanu lekaka noboya mudaikiki ahoneki makoko aweyaha amidekoma ganeya eli hulataboya wehe loko ne. ");
INSERT INTO yby_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ito nemo yowanuneki ito ahoneda yowanulakiya makoko aweyaha onedeko, mudaikikima, opa ga lamiki nemo yowanu nolobotogoya mudalo. Mudai wehe litaboya ahonekaho nemodaya uka jene. Ito ahonekaho nemoda maya asaoko uka jene liki mudaikiki nemo monawane maya mudai wehe likilae. ");
INSERT INTO yby_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Loko lokoko, nala mikili niabokuti maya hulikoko wiye. ");
INSERT INTO yby_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Woko Jodani no yola helega Joni maya api oko monoka noku udobetaibotoka maya woko ne. ");
INSERT INTO yby_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yaloka maya woko neyoko, muki wewena maya nebotoka nisikiki sa-liki lae: Joniya sako muki elewole nesahena lolo amibo maya neboya, maya wemu libo ga maya wehe loko ulawago lokaka ibo ne. ");
INSERT INTO yby_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Liki likiki yaloti maya muki wewenasiya Jisesidamuya elewole iki data ke. 33 Liv 24:16 30 Sam 82:6 36 Jon 1:28 ");
INSERT INTO yby_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Beteni numutoya we mako uliwa Laselesiyo loko nebo weya saina elonebo ne. Aya weya olu emonala lowe minaiboya dulinipo Meleko Matakoya makoko numutotiya minaiye. ");
INSERT INTO yby_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meleya we napa Jisesidaya nuwala wibo netupa maya kiseko ilalo maya madona yopalaloti uli jeko le lalo oetaibo menamidana yatola maya saina elokaiyoko nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sakoya elokaiyoko neyoko, Jisesitoka maya sa-liki gaya hulaiye: We napayo, wewenaka maya saina napa elokaiyoko udone. ");
INSERT INTO yby_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Liki laiyoko, Jisesimamo elekoko lina helituwe loko jelamiye, loko liye. Omaimidana luhuwalamaki ito nemo Omaimidana ipala luhuwanekiya soto pitiye loko jelene loko liye. ");
INSERT INTO yby_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisesikahoya Laselesile Melele Matalesidaya uka benebo wewena minae. ");
INSERT INTO yby_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sayoko, Laselesida saina elaibo ga maya elekoko nebo numuto maya onawa loweya kolo meko udokoko, ");
INSERT INTO yby_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","unala ipalale yuhasida maya sa-loko lo limiye: Nisilo. Judiya ebakuka maya aku le wili jeko wetuniyo. ");
INSERT INTO yby_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Loko liyoko, lemo sa-loko lo mune: Monoka ujapa wete yamalae, omutoko maya Juda wewenasida ujapa wenipolemasi kohaelatune liki labo maya nenako, aku aya ebakuka maya wetune loko nolape. ");
INSERT INTO yby_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Loko lokuniyoko, Jisesimamo eimola helitibo onawa maya owaha neyoko, sa-loko lo limiye: Yowanu onawaya nekewahena ito holigahena ito ludakahenaya wavu-leko ne. Holiga maya lamedalo wideko wewena mako ahamuya sainapainahenaloti liki kohaidamikilae. Nemoya yowanu litubo onawane maya owaha ne. ");
INSERT INTO yby_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wewena mako lameda lamideko lubuka anu witaboya, mainahaloti mohiliki nisiki kohaidakilae. ");
INSERT INTO yby_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Loko lo lemekoko amida meko sa-loko liye: Yowone Laselesi maya alo udo helekaiboya, aku woko ilime sinakoloe. ");
INSERT INTO yby_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Loko liyoko, lemo unala ipalale sa-loko lune: We napate yamalae, omuda udonetiboya haka lekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Loko ludawoya, Jisesimamo helekaka nesamuya koha moloko libo maya neboya, lemoya ele wehe lamoko aha udonebokumu lihe loko opaya lune. ");
INSERT INTO yby_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Loko lokuniyoko, alikaya Jisesimamo lo soto moloko sa-loko lo limiye: ");
INSERT INTO yby_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nemoya yaloka maya wamoko, malokagoya minoyoko, Laselesi maya alo helekaiboya, edimokumuye loko elewole oko elekakatipomidana ihilawa maya soto pitiye loko obohaneu maya aila uluma nosiliye. Sa-okainako, ayalokaya wetune. ");
INSERT INTO yby_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Loko liyoko, Tomasiya uliwa mako Lobetokoe loko nebo welimoya welalesida maya sa-loko lo limiye: Lemokiya magoina woko heletune. 1 Luk 10:38-39; 2 Jon 12:3 ");
INSERT INTO yby_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Loko lokaiyoko, magoina wudawoya, Laselesida ale li jitabo onawa maya loweki lowekiya wokaiyoko, Jisesima woko aya numuto maya hetokoko aya ga maya eliye. ");
INSERT INTO yby_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Sa-iboya aya Beteni numudaya Jelusalemu numutoka alili nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Sa-iyoko, Meleko Matako yanipo maya helekaiyoko, Juda wewenahena mukiya wiki wije nama libitakili wae. ");
INSERT INTO yby_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sa-niayoko, Mata maya Jisesima nonisiye liki laboya elekoko Mele maya numuku neyoko woko anuloka hotula iye. ");
INSERT INTO yby_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Sakiya Jisesiki hotula ikiki Matamamo sa-loko lo miye: We napane yamalae, emoya malo minatidanako, nemo yane maya sako helametine. ");
INSERT INTO yby_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Olotiya emo monawaka maya ele-minoe. Matoka nesamuya woko Omailoka letadawoya ele imitibo ne. ");
INSERT INTO yby_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Loko liyoko, Jisesimamo yatokaya aha momoga oko sinakolaiye, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Loko liyoko, Matamamo sakoya minoko onawa napalo maya Omailimo muki wewena dilipe sinatiboto maya ilime sinatibomu lihelae nata ele-minoe. ");
INSERT INTO yby_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Loko liyoko, Jisesimamo helebokuti siniki elewole depa mutiwa likakamidana aholaya nemoya minoe. Wewena mako nemokumu elewole iki data kitabo wewena maya helikiki aku siniki elewole iki minakilae. ");
INSERT INTO yby_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ito domuda li-minabo wewenasiya nemokumu elewole iki data kitaboya, depa mutiwa maya suwamekolaiye. Aya depa mutiwaya mino-loko woko minakolaiye. Sa-oneyoko noloyo, emoya nolobo ga maya eleko nemesalo nomolape. ");
INSERT INTO yby_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Loko loka oetaiyoko, Matamamo we napane yamalae, emoya Omailimo lahelamibo nesauti lilimitiye loko lo mololetaibo we Omaimidana ipala maya ma mikau leme-minane liki labo we maya minane loko emodamuya nukaloti elewole oko ele-minoe. ");
INSERT INTO yby_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Loko lokadanaki, olu unala Meleda maya ju lo meko sumika loko sa-loko lo miye: Monoka ujapalo we maya nisekoko emodamu noliye. ");
INSERT INTO yby_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Loko liyoko, elekoko, Mele maya enemane oko sinokoko Jisesima nebotoka wiye. ");
INSERT INTO yby_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sako nowiyoko, Jisesima numutoka wamoko, Matada ga lo mibo ebato maya ne. ");
INSERT INTO yby_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sakoya neyoko, Mele maya enemane oko sinokoko wiyoko, Juda wewena nisiki numudalau wije nama liki minabo wewenamasiya Laselesida molitabo aleloka maya woko wije nama lekolo wihe likiki emesalo moliki wae. ");
INSERT INTO yby_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Melema Jisesi neboto wokoko i bola heko udokoko sa-loko lo miye: We napane yamalae, emoya malo aha minatidanako, yatone maya helametine. ");
INSERT INTO yby_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Loko lokoko wije iye. Wije noiyoko, Juda wewena emeke moliki wabolawamaki emesalo moliki wije ae. Wije nama nileyoko Jisesimamo mudaidokoko ukauka miluma elekoko sa-loko loka obetoko liye; ");
INSERT INTO yby_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nakahaukama ale jiti-minae, loko liyoko, we napate yamalae, niseko mudataniyo, nisegae, liki lae. ");
INSERT INTO yby_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Liki layoko, Jisesimamo omudalauti maya leke leke liyoko, wije nama liye. ");
INSERT INTO yby_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wije nama liyoko, Juda wewenamasiya mudalo, Laselesidaya ukala me ilitone, liki lae. ");
INSERT INTO yby_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Liki layoko, maloka wewenamasiya omutoko omudala likaibo we makomidana le pana ketaibo maya nenako, olotiya maya wemidana ilime haka lideko helametibo neboya, samiye liki lae. ");
INSERT INTO yby_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Liki likayoko, Jisesima aku mulunauka miluma napa elekoko, ono molikakaku maya yoweko ehada numuda ateto maya ehada napaloti moli li labo ehada maya, ");
INSERT INTO yby_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","mudakoko sa-loko liye: Ehada maya ipisiki li hulalo. Loko liyoko, helibo wemidana emonala Matamamo we napane yamalae, onawa loweki loweki yupekaya minokainako, alo nuwama wonetibo ne. ");
INSERT INTO yby_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Loko liyoko, Jisesimamo emoya ga lo emoboya elamape, elewole oko elitadawoya, Omaimidana elewoleyala maya soto pideko mudakolane. ");
INSERT INTO yby_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Loko liyoko, ehada maya koliki li hulikayoko, Jisesimamo omuda hulo okulumauka moloko, ahone yaliyo emotoka noloboya ele-minane. ");
INSERT INTO yby_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ito muki yupeka emotoka lokaka noboma elekaka noadawo maya ne loko eleminoboya, maya li esa iki minabo wewenasiya emokaho noli heniyoko lemobo ne liki eli wehe litae loko noloe. ");
INSERT INTO yby_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Loko lokoko, ga napauti ju loko Laselesiyo, emoya sinokoko nisowo. ");
INSERT INTO yby_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Loko liyoko, ilo adelo nala jebo nalahenamaki aha neyoko, sinokoko nisiyoko Jisesimamo nalahena yomaya wina iki li hulitalo, liyoko nalahena maya wina iki li hulitae. ");
INSERT INTO yby_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sa-ikayoko, Juda wewena malokasiya nisiki Meleko Matako minaibotoka miniki wije nama liki minabo wewenasiya Jisesima oko moloko ibo nesa maya mudaikiki Jisesidamuya data elewole iki keboya, ");
INSERT INTO yby_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","maloka wewenasiya wiki Palasisi wewenasitoka maya wetome iki li be. ");
INSERT INTO yby_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sa-ikayoko aya wewenaki ito Omaitoka jokila hi mikaka wehenakiya monoka Kanisolesida maya lesa molikiki sa-liki lae: Maya welimoya lowa-lawa nesa maya lolo okainako, lemoya nenaha lolo oetatune. ");
INSERT INTO yby_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Lemoya mudaikoko minuniyoko aya nesaya sa-oloko wowa wowa ideko muki wewenasiya emotokago wiki omiki suwikilae. Sa-ideko Lomu wewenasida imi wesiya nisiki lemodaya lowa hi limiki kohale-liki wau loli hikiki monoka numudate napa maya liki tolowa ikilae. ");
INSERT INTO yby_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Liki layoko, edimokuti we mako uliwa Kaeyapasiya aya melekeuya Omaitoka jokila hi mikaka wesida uliki wenipo lolo ibo nenako, ya wemamo edimoya nei minanako, sa-liki elamae loko liye. ");
INSERT INTO yby_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Lemo Juda wewenaya woko aha nesa lolo okatudanako, ya welimoya muki lilime nupa napa oko helekadeko, yalimoya saina ihilawa le soto mololetatiye. ");
INSERT INTO yby_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Loko liboya eimola atauti yowiyoko lamiye. Emoya aya melekeloya Omaitoka jokila hi mikaka wesida ujapa wenipo lolo ibo nenako, Omailimo ilime sahu iyoko Jisesima muki wewenasidamuye loko helitibo onawamuya ohuwa hukoko liye. ");
INSERT INTO yby_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Sa-loko liboya, Juda wewenamugo helitibokumu lamiye. Omaimidana wewenala numuto namato minabosida maya dilipe nupa napa okadeko, nala makoko jiki minatabokumu helitiye loko ohuwa hukoko lo biye. ");
INSERT INTO yby_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Loko liyoko, Omaitoka jokila hi mikaka wemasiya ya yupeka maya Jisesida kohatune liki lowa je. ");
INSERT INTO yby_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sa-ikayoko nenako, Jisesima Judiya ebaku wewenasi domudaloka maya lemo jamoko woko ame mikaloka maya ne. Yamidana apilalokaya numuda mako Ipiliyamuyo loko nebotoya unala ipalale yuhamaki magoinaya woko minune. ");
INSERT INTO yby_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yaloka maya woko minuniyoko, Juda wewenasida esenipo vobetaibo holi onawa maya alili okaiyoko, muki numuda lasomosolaukati maya hulikiki dukanipo no jiki li uluwitikiki li Jelusalemu numutokago wiwi ae. ");
INSERT INTO yby_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Sakiya wiki Omaimitoka jokila hi mikaka numuda napau maya yowikiki Jisesima owaha nisamiyoko, ohu nijiki sa-liki edimonipo minabotokaya nenae liki niele, Jisesiya holi onawauya nisitibo nehe ito nisametibo ne, liki ligi hagi ae. ");
INSERT INTO yby_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Liki laboya Omaitoka jokila hi mikaka weki ito Palasisi wekiya, wewena makolimoya Jisesima netibo ebaya mudakoko niseko lideko nala metudanako liki li moliki labotoya Jisesima holi onawau maya nisametibo nehe liki lae. ");
INSERT INTO yby_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Esenipo vobetaibo holi onawa maya alili oko onawa 6 aha neyoko Jisesi maya Beteni numutoka woko hetiye. Aya numutokaya omutoko Laselesi maya helenebokuti ilime sinaibo numuda maya ne. ");
INSERT INTO yby_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sa-iki aya numuto maya nodenesa ataina ayoko nenako, Matamamo nodenesa maya leko moneko ona moloko nobiyoko, Jisesi maya Laselesilekiya magoina minayoko ne. ");
INSERT INTO yby_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Saki niki minayoko, netupa makoya uliwa nadiyae loko meinawa yoweko nebo netupa maya Melemamo meina heko leko nisekoko botoloutiya Jisesida ilalo maya kisekoko madona yopalalotima uli jeko le lalo oetaiye. ");
INSERT INTO yby_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sa-iyoko, numuku maya nuwalalimo molo lele moniyoko, unala ipalale yuhauti maya we mako Kaliyoti ebatokati we Judasiya Jisesida mimi etibo welimoya sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Nuwala lalo wibo netupa maya nenako, aha minatidanako, meinawa kilisimasi makokomidana ukau ehada lekoko saina-painahenanipo minametibo wewenasida betine. ");
INSERT INTO yby_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Loko liboya, sainanipo minamibo wewenasidamu lamiye. Emokahoya Jisesida wewenalalesida ehadanipolo ujapa onebo nenako liye. Ehadahena liki nisiki meyoko le suna suna oko minokaka ibo maya nenakoya, liye. ");
INSERT INTO yby_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Loko liyoko, Jisesimamo edimoya hulitikalo, loko liye. Emoya nuwala wibo netupaya nupalo hilenetaiboya nemo helekoyoko nupalo hilinitatabo nesa leko hilenetaiyo. ");
INSERT INTO yby_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Uvaminanipo minamibo wewenaya edimoki magoina mini-liki wiki minatabo neha, nemoya edimoki sako mino-loko woko minamekoloe. 3 Luk 7:37-38 8 Dut 15:11 ");
INSERT INTO yby_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Loko lokaiyoko, muki Juda wewenamasiya Jisesi maya yaloka ne liki laboya elikiki niseboya, Jisesidamugo nisamae. Laselesi maya helenebokuti ilime sinaibo wemidana maya muda-elakili nisebo ne. ");
INSERT INTO yby_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Sakiya Laselesidamuya muki wewenasiya Juda wewenasida ujapa wesidaya hulibitikiki wiki omiki elewole iki Jisesidamugo data ki me. Sayoko nenako, Omailoka jokila hi mikaka wesiya Laselesidaki kohatune liki lowa je. ");
INSERT INTO yby_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Udikiki go maya lokaiyoko, holilo nisebo wewenamasiya Jisesima nonisiye liki labo elikiki, ");
INSERT INTO yby_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","wavu-liki kokonasi aila maya letiki liki Jisesida wiki anuloka hotula ikili liki anuloka wae. Sakiya anulokaya niwiki, agae, we napamidana galalo maya nisekaninako, Omailimo maku imitiyo. Lemo Isilaelo wewenalika uliki wete maya nonisedanako. ");
INSERT INTO yby_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Liki nilayoko, Jisesima donki ja akalewa mako mudakoko emesalo maya yowekoko wiye. Sa-iboya monoka bukuguya ga mako sa-loko neboto maya ele-minoko sa-iye: ");
INSERT INTO yby_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Edimo Saiyona bolau wewenalitaya domodatipo wamideyo, eli-minahe. We napatipo maya donki jamidana emesalo maya yoweko minokoko yaitaya nonisiye. ");
INSERT INTO yby_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sa-iboya, aya gaya lemo unala ipalalikaya ele wehe lamudawoya, alikaya Jisesi maya aku le okulumau yowekaiyoko elekoko emodamuye liki luhuwa ji molabotoya aweyaha sa-iye loko ele wehe lune. ");
INSERT INTO yby_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jisesimamo Laselesida maya ju liyoko ono aleuti limiyoko mudabo wewenasiya wetome iki li be. ");
INSERT INTO yby_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sa-ibo nesamuya muki wewenasiya awa maya elikiki nenako, anuloka woko hotula etune liki wae. ");
INSERT INTO yby_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Sa-ikayoko, Palasisi wewenamasiya edimonida sa-liki ligi hagi ae: We yuhakuse, eli-minahe. Aya yowanu ludawo maya aha nesa lolo okaiyoko, muki wewena maya wiki emotokagoya omiki nisuwae, liki lae. 13 Sam 118:25-26 15 Jek 9:9 ");
INSERT INTO yby_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Juda wewenasida holi onawanipouya Omaitoka monoka letune liki Jelusalemu numutoka yowebo wewenautiya malokaya Guliki wewena minabo ne. ");
INSERT INTO yby_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Edimoya Galeli ebaku Betiseda numutokatiya we mako Pilipiyo loko nebo wemidanaya wiki we lalo nesa yamalae, Jisesida maya ma muda-elatune loko noludawolae. ");
INSERT INTO yby_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Liki layoko, Pilipimamo woko Enduluda maya lo miyoko magoinaya wiki Jisesida maya li mikaiyoko, Jisesimamo sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Okulumauti we uti nemoya huwepaneki ito luhuwanekiya soto pitibo onawa alo alili okaiye. ");
INSERT INTO yby_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wehe loko wati gaya lo libekoloyo, eli-minalo. Kile yuha makokoya mikau hametudawoya aha minakolaiye. Ito mikau hekuniyoko maya, minoko okepa helekoko wileko yoweko aila jeko o-molakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yamidana oko wewena makolimo ukala leko yowitiboya alikaya ukala opa-napa ekolaiye. Ito wewena mako nemokumuye liki duka liki limiki minataboya alikaya elewole depa mutiwa liki minakilae. ");
INSERT INTO yby_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wewena mako nemo elekele oluhone lolo etune liki data eli-minatabo wewena maya nemo nemeke moliki nisitae. Sa-ikadeko, nemo yoweko minatubotoka maya elekele oluhoneki magoinaya minakolune. Ito nemoda nasahili initatabo wewenasida dulinipoya alikaya ahonekaho le sinakolaiye. 25 Mat 10:39; Mat 16:25 ");
INSERT INTO yby_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ahoya jekoko nupau lekainako, nenae loko letuwe. Ahone yaliyo, ahone yaliyo, onawane maya alili inako, nupalo yowekolabo nesaya hulo hoto oneto loko letuboya lahelamekolaiyo, sa-loko lamekoloyo. Miluma elitubo nesa nupalo yowitibo onawa maya aloya nisekaiyo. ");
INSERT INTO yby_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ahonelika, lokadeko ulikamidana luhuwa maya soto pideyo. Loko liyoko, okulumauti ga napa mako sa-loko liye: Nuline luhuwalaya alo onowelakiya soto pekaiboya, soto pe-loko woko soto pideko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Loko liyoko, muki li esa iki minabo wewenamasiya elikiki sa-liki lae: Okanaki we makolimoya aya lo mekaiyo. ");
INSERT INTO yby_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Liki layoko, Jisesimamo sa-loko lo biye: Gaya nemokumuye loko lamiye. Edimokumuye loko soto pekaiye. ");
INSERT INTO yby_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Olotiya lahelibo lahelamibo nesa ma mikau nebomidana obi obetatibo onawala maya alili okaiyo. Ma mikau ujapa we mako Olohae loko nebo wemidanaya oli hekoloe. ");
INSERT INTO yby_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma mikauya yalo maya nalawa iki tinitikadeko, muki wewenasida maya lesa molo boyoko nemotokagoya nisiki suwikilae. ");
INSERT INTO yby_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Loko liboya, yoho yaha yalo maya sakoya helitubo ne loko koha moloko liye. ");
INSERT INTO yby_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Loko liyoko, muki minabo wewenamasiya sa-liki li me: Lemoya monokauya ga mako sa-loko elekaka noune: Lahelamibo nesauti lilimitiye loko lo mololetaibo weya helamoko mino-loko woko minakolaiye loko nebo maya nenako, emoya okulumauti we uti nemodaya yalo nalawa iki tinitakilae loko nenaha iyoko nolane. Ito nenamidana okulumauti we utimuya nolane. ");
INSERT INTO yby_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Liki layoko, Jisesimamo sa-loko lo biye: Le maya onawa lasolasiya edimo luwawatipouya lameda lekolaiye. Sa-ekolaiyo, lubulimoya edimotoka lubu jekatiyo, lelimoya edimotoka lameda lokogo netiyo, aya leya likiki minalo. Ito wewena mako lubuka witabo anuya mudai wehe lamikilae. ");
INSERT INTO yby_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sa-oneyo, leya edimotoka nebotogoya li etoha iki li-minalo. Edimoya lemidana oluhola lolo etune liki maya nemodamuya elewole iki elilo. 34 Sam 110:4; Aes 9:7; Den 7:14 Loko Jisesimamo lokoko woko suna ibo ne. ");
INSERT INTO yby_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jisesikahoya aito-aitomidana elewole anehena maya domuda leleiya le soto molokaiyoko mudaikaboya, elewole iki data kamabo ne. ");
INSERT INTO yby_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Omaimidana epaloti ga lokaka we Aesayada gala maya woko ulolotetiye liki sabo ne. Aya welimoya sa-loko luhuwa jenebo ne: We napane yamalae, gaya loboya, muki wewenasi elewole iki data kamae. Ito we napamidana elewoleyala maya wewenasitoka soto piyoko amanama wewenasiya elewole iki elebo ne. ");
INSERT INTO yby_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ito Aesayada gala mako sa-loko nebo maya elewole iki data kamae: ");
INSERT INTO yby_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Edimoya domuda likoko madotipo maya opa okaiyoko sainahena maya mudai wehe lamae. Dukaya li wili jamanako, dilipe lalo etubo nesa lamiye. ");
INSERT INTO yby_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Loko Aesayakaho liboya, Jisesida lamedala maya okulumau nebo mudakoko libo ne. ");
INSERT INTO yby_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sa-iyoko, Juda wewenasida ujapa wenipole malokasiya Jisesidamuya elewole iki data keha, lo soto molatudawoya Palasisi wewenasiya monoka anute maya hiki lilimikatae liki domodanipo wokaiyoko, li soto molamae. ");
INSERT INTO yby_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aya wewenasiya aito wewenasi dupa liki yowitae liki sa-ikaka abo ne. Omailimo dupa leko yowitiye liki samabo ne. 38 Aes 53:1 40 Aes 6:10 ");
INSERT INTO yby_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Sa-iyoko, Jisesimamo ga napauti wewena mako nemodamuya elewole iki elitaboya nemodamugo elamikilae, nemoda noli hibo we ahonedamukiya elewole iki elebo elekaiye, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wewena mako nemodaya mudaneli wehe litaboya, ahone noli hibo wemidanakiya muda-eli wehe likilae. ");
INSERT INTO yby_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nemodamu elewole iki elitabo wewena maya lubu jitiboku minamitae loko ma mikau wewenasida lenipo minatuwe loko leme-minobo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ito wewena mako nemo gane maya elikiki eli hulatabo wewenasida maya obi obetamekoloe. Nemoya ma mikau wewenasida lihima le bituwe loko lemamoe. Muki numuto namato wewenasida maya dilimituwe loko lemobo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sa-oneboya, wewena mako nemoda huli hoto molinitikiki nemo gane maya eli hulataboya, lo molobo galimoya onawa napalo maya obi yowanu lebetakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Neimone nata eleko lamoe. Ahone noli hibo welimo lo soto molatane loko lonetaiyoko lokaka noe. ");
INSERT INTO yby_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Sakoya nemo nepauti galimoya elewole oko minokakamidana monawa maya le soto molokaka noiye loko ele-minoe. Ga matokaya noloboya, ahonekaho liboto noloe loko Jisesimamo liye. ");
INSERT INTO yby_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Juda wewenasida esenipo vibo holi onawa maya aijoe loko neyoko, olotiye loko Jisesimamo sa-loko ata kiye: Ma mika maya hulikoko ahone nebotoka yowitubo onawa maya alili okaiyo, loko elekoko ma mikau wewena emo oluholale lolo abo wewenasida maya uka beko suwokoko saina mako sakoya lolo iye. ");
INSERT INTO yby_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nodenesa natune loko le esa okuniyoko, saina mako sakoya lolo iye: Kaliyoti numutoti Saimonida ipala Judasida maya olohalimo ukau niseko minokoko esewau le ahu liyoko, Jisesida maya mimi etuwe loko ata kiye. ");
INSERT INTO yby_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sa-iyoko nenako, Jisesimamo sa-loko eliye: Ahonekaho muki nesahena maya nemo nadeu molonebo maya ne. Sa-okaiyoko, Omailokati lemobo nenako, akuya le lika oko yowekoloe. ");
INSERT INTO yby_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Loko elekadanaki, nodenesa noko minudawokuti maya sinokoko upalo nesa hana olo jekaka noibo nesa maya hulikoko tauli hana mako ohalalo wilekoko, ");
INSERT INTO yby_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","moneko no maya kiseko lapeu maya lekoko lemo unala ipalale yuhalita maya nokalawe oletaidanaki, tauliloti maya leko ulijeletomo woko, ");
INSERT INTO yby_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Saimoni Pitama neboto wiyoko sa-loko lo miye: We napane yamalae, nemo nineya emo nokalawe onetatuwe loko nolape. ");
INSERT INTO yby_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Loko liyoko, Jisesimamo maya lolo nobo nesamidana monawaya olotiya elamane. Alikaya mino-loko noyoweko elekolane. ");
INSERT INTO yby_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Loko liyoko, Pitamamo nemo nineya nokalawe onetamekolane. Loko lokaiyoko, Jisesimamo nemoya ika nokalawe ogetametuboya emoki nemoki magoina minamekoloiye. ");
INSERT INTO yby_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Loko liyoko, Saimoni Pitamamo we napane aliyo, sa-ekolo maya nigo nokalawe ametane, muki madoneuka nupalokakiya nokalawe onetatane. ");
INSERT INTO yby_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Loko liyoko, Jisesimamo wewena makosiya omutiki noku udikiki alikaya digoya nokalawe ideko dupa uluwitoko suwekolaiye. Ito dukatipo maya uluwitiki suwiminabo maya neboya, edimo mukiya uluwitiki minamae. ");
INSERT INTO yby_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Loko liboya, we mako nakaha welimo mimi ekolaibo wemu ele-minoko, edimo mukiya uluwitiki minamae loko lo limiye. ");
INSERT INTO yby_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Li maya nokalawe oko suwokoko upalo nesa maya aku le olo jeko nedanaki, sa-loko lo limiye: Saina oloti maya lolo olibetobo nesamidana monawa maya eli wehe li-minahe. Yamuya olotiya lo libekoloyo, eli-minalo. ");
INSERT INTO yby_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Edimoya nemodamu we napaye tisate liki likaka niaboya wehe liki likaka niae. ");
INSERT INTO yby_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nemoya we napatipo tisatipo maya minoboya, di maya nokalawe olibetokoyo, edimokiya asaiki emo nokalawe oetadeko emo nokalawe oetadeko iki mini-liki yowiki minalo. ");
INSERT INTO yby_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Saina maya lolo nobo nesaya edimosiya sa-iliki wiki wewenatipolesida lolo ibitatae loko api-napi o noliboe. ");
INSERT INTO yby_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sa-onenako, nemoya wehe loko lo libituyo, eli-minalo. Elekele oluho makolimoya ujapa welakidana pulekakawa minamiye. Ito doli hiyoko wabo wesiya doli hibo we pulikakawaya minamae. ");
INSERT INTO yby_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ga maya nolobo gaya eli madotipou molikiki minadeko, alikaya nemokahoya maku libekoloe. ");
INSERT INTO yby_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Maya nolobo gaya woko muki wewenasitoka lamiye. Nemo dilipe aka nobo welitaya monawatipoya le-minoboya, monoka bukugu ga mako sa-loko nebo gaya we makomaloya soto pekolaiye: Magoina nodenesa noko minoibo welimoya nemoda kohanelo hulakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ito aya nesaya soto pideko mudaikiki alikaya we napatemae liki litae loko aya nesa maya owaha soto pamiyoko lo noliboe. ");
INSERT INTO yby_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nemoya wati gaya lo libekoloyo, elilo. Wewena malokasiya we makomidana oli hibo wemidanaya nasahili itataboya, yowanu ahola nemokiya nasahili initabo ilene. Ito wewena makosiya nemoda nasahili initaboya, noli hibo wemidana nasahili itabo ilekaka noiye. 14 Luk 22:27 16 Mat 10:24; Luk 6:40; Jon 15:20 18 Sam 41:9; 20 Mat 10:40; Mak 9:37; Luk 9:48; Luk 10:16 ");
INSERT INTO yby_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Sa-iyoko, Jisesimamo aya ga maya lo suwokoko, ukala hekaiyoko, sa-loko lo soto moloko lo limiye: Nemoya wehe loko lo libekoloyo, eli-minalo. Edimokutiya we makolimo nemoda mimi ekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Loko liyoko, lemo unala ipalale yuha maya wenu emo elokaiyoko emo elokaiyoko, okoko ekahidamu lihelae, loko lata hulo mama une. ");
INSERT INTO yby_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sa-nouniyoko, nemoya Jisesikaho ukala nemenebo nenako, amaitoka minoyoko, ");
INSERT INTO yby_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimoni Pitamamo adedunu aweyaha oko ekahidamu lihelae loko loka oetadeko lo limitiye, loko sa-iyoko, ");
INSERT INTO yby_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","nemoya Jisesida amaitoka minodanaki loka oetoko sa-loko loe: We napane yamalae, ekahikumu nolane. ");
INSERT INTO yby_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Loko loyoko, Jisesimamo nodenesa noku heko moyoko natibo wemuya noloe. Loko lokoko, nodenesa maya noku hekoko Kaliyoti numutokati we Saimonida ipala Judasida maya miye. ");
INSERT INTO yby_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sakoya miyoko, nokaiyoko, olohalimoya ukau yowekaiyoko, Jisesimamo emoya saina painahenama le soto molatuwe loko ata noeledawo nesaya enemane oko le soto molowo. ");
INSERT INTO yby_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Loko lo miboya, lemo iwelale magoina minudawo neboya aya ga maya ele wehe lamune. ");
INSERT INTO yby_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sa-udanaki, malokalitaya sa-loko elune: Judasi maya ehada owolo ujapa onebo wema nenako, holi onawau maya nodenesahenama meina hitibokumu oli heko lihelae loikune. Ito malokalitaya sainanipo minamibo meusahenasida maya ehadama leko moneko ona moloko bitibokumuya lihelae, liki ele. ");
INSERT INTO yby_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Sa-okuniyoko, Judasi maya nodenesa nokoko upauka lubu jekaiyoko nenako, hetoka maya lemeko wiye. ");
INSERT INTO yby_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Hetoka maya lemekaiyoko Jisesimamo sa-loko liye: Olotiya okulumauti we uti nemo nuline maya onowelakiya soto pekolaiye, ito nemo yowanunelotiya Omaimidana uliwa maya onowelakiya soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Omaimidana uliwa maya onowelakiya soto nopideko, Omailimo letibotoya nemo nuline maya asako onowelakiya soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Oluhone motakuse, elilo. Nemoya edimokiya onawa minawasiya minokoko aloya wekoloe. Sakoya wokoyoko edimoya nemokumuya moniki ohu jitaboya, hapa yeikala Juda wewenasida lo bobo gamidana maya olotiya lo noliboe. Nemo woko minatubotokaya edimoya wamikilae. ");
INSERT INTO yby_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Sa-itabo nenako, olotiya ohatama gaya sa-loko lo nohukolibetoe. Duka moliki wilo. Nemo nukane libobo nesa liki emo ukala mideko emo ukala mideko iki mini-liki wilo. ");
INSERT INTO yby_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sa-itaboya muki wewenasiya nemo unanele ipanele minae liki mudaidatabo ne. 33 Jon 7:34; 34 Jon 15:12,17; 1 Jon 3:23; 2 Jon 5 ");
INSERT INTO yby_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Loko liyoko, Saimoni Pitamamo we napane yamalae, nakahaloka wetane. Loko liyoko, Jisesimamo eba makomaloka wetuboya olotiya nemeke molamoko alikaya nemeke molakolane. ");
INSERT INTO yby_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Loko liyoko, Saimoni Pitamamo we napane yamalae, olotiya nenahamu emesalo molametuwe. Emokumuye loko minoko leko nobolawa maya hulatuhe loko le lolowa okoboyae. ");
INSERT INTO yby_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Loko liyoko, Jisesimamo onoto leko sa-loko lo miye: Nemodamuye loko minoko leko noadawo nesa maya hulatuwe loko nolape. Wehe loko lo imituyo, ele-mino. Oloti lubukaya okole onowa owaha lamideko loweki makoki yupekaya yuwawa molonetakolane, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisesikaho ga mako sa-loko lo limiye: Mulutipouya lepa hideko minalo. Sakiya miniki Omaimidanamuya elewole iki eliki nemodamukiya elewole iki eliki minalo. ");
INSERT INTO yby_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ahoneda numudalauya numuda eba lalo nesago waitoko ne. Sako minametidanako, nemokahoya woko numuda ebatipo le lolowa olibetatuwe loko lametine. ");
INSERT INTO yby_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nemokahoya woko numuda ebatipoya le lolowa olibetokoko niseko dilipe-loko yowekoyoko, nemoki magoina minatune. Sakoya nemo minatubo ebakuya magoina minakilae. ");
INSERT INTO yby_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nemo woko minatubo ebamidana anulaya edimoya mudai-minae. ");
INSERT INTO yby_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Loko liyoko, Tomasimamo onoto leko sa-loko liye: O'e, We napane yamalae, emo woko minatadawo ebamidana uliwa maya elamudanako, nena-nenakoma anuwaya mudakoko wetune. ");
INSERT INTO yby_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Loko liyoko, Jisesimamo anuwaki ito ga ulawaki ito elewole oko minokakamidanakiya, nemoya minoe, loko lo miye. Nemodaya asinitikiki ahonetoka wikakawaya minamiye. ");
INSERT INTO yby_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Edimoya nemokumu eli wehe letidanako, ahonedamukiya eli wehe letidawo neboya, olotiya mudaikiki emokumuya eli wehe lae. ");
INSERT INTO yby_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Loko lokaiyoko, Pilipimamo we napane yamalae, ahokada maya lilipekadeko, sainahenamuya aku loka-mika ogetametune. ");
INSERT INTO yby_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Loko liyoko, Jisesimamo Pilipida maya, Pilipiyo, hana-pana onawaya edimokiya minoboya, nemoda maya owaha mudanelo wehe lamape. Wewena mako nemoda muda-nelonetibo wewenalimoya ahonedakiya muda-elonebo ilekaiye. Sa-onenako, emoya nenahamuya ahoneda maya lilipo loko nolane. ");
INSERT INTO yby_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ahonekahoya nemoda uka jene loko ito nemoya ahoneda uka jeminoe loko emoya elewole oko elamape. Gaya lo noemoboya nenimone nata eleko lo emamoe. ");
INSERT INTO yby_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Edimosiya ahonekaho nemoda uka jene liki, ito nemokaho ahoneda uka jeminoe liki elewole iki elitae loko noloboya, aya ga maya nieliki wehe lamideko maya, oliwaki nesahena elewoleya lolo okaka nobotoya mudaikiki maya nemodamuya elewole iki data ki nimitae. ");
INSERT INTO yby_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nemoya wehe loko wati gaya lo libekoloyo, eli-minalo. Nemodamuya elewole iki data kitabo wewenasiya nemo yowanu lekaka nobo nesa lolo ikilae. Ito yagoya minamiye. Nemoya ahonetoka yowekoko weuna oluho maya oli hitubo nenako, edimoya Omai weuna oluholimoya dilipe ahu lideko nemoda asinitiki yowanu likilae. ");
INSERT INTO yby_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ito nemo nuline li-miniki saina makomu wako litaboya ahoneda uliwa maya le hutili etuwe loko ele libekoko minokaka etuwe. ");
INSERT INTO yby_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nemo nulineya li-miniki saina makomu wako litaboya aha libekoloe. ");
INSERT INTO yby_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Dukaya wehe loko nemotoka molabo minataboya, nemo ganeya eli likilae. ");
INSERT INTO yby_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Sa-ideko, nemo ahonetoka loyoko luhawatipoya le ilitetibo weya oli hekadeko, edimokiya magoina mino-loko woko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ga ulawamidana madona maya Omaimidana weuna oluhomuya noloe. Sa-oneboya monoka lamabo wewenasiya emodaya muda-eli wehe lamae. Ito monawalamuya elamae. Sa-ikanako, emodaya li-minamikilae. Sa-oneboya, edimoki magoina minoko ukatipouya lemeko minokaka noibo maya nenako, monawala maya eli-minabo maya ne. ");
INSERT INTO yby_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nemoya hulolibetokoyoko meusa oluho lolo iki minikatae loko alikaya aku minatabotoka nisekoloe. ");
INSERT INTO yby_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Onawa minawa mako nenako, ya onawa maya su-noideko, monoka elamitabo wewenasiya nemoda muda-nelamitaha, edimo monoka elebo wewenalikaya muda-nelakilae. Nemoya ohatama mino-loko yowekakamidana ahola minonako, edimoya asaiki ohatama mini-liki yowiki minakilae. ");
INSERT INTO yby_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ito ya yupekaya ahonekaho nemoda uka jenebo ne, ito nemokaho edimosida uka jeminobo ne, ito edimosiya nemoda uka ji-minabo ne liki mudai wehe likilae. ");
INSERT INTO yby_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nemo nepauti ga eliki minikaka niabo wewenasiya wehe liki duka nimikaka niae. Ito nemodaya duka nimitaboya ahonekahoya asako ukala libekolaiye. Ito neimonekiya nukane libekoko monawane lo soto moloko lo libekoloe. ");
INSERT INTO yby_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Loko lokaiyoko, Kaliyoti numutoti Judasida abalamamo loka oetoko sa-loko liye: We napane yamalae, nenaha idekoma lemotokago monawakaya le soto molokoko aito wewenasitokaya le haluketane. ");
INSERT INTO yby_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Loko loka oetaiyoko, wewena makolimo ukala nimitiboya nemo ganeya emesalo molokadeko, ahonekaho asako ukala mekolaiye. Sakokoya nemokiya aya wewenaloka magoina woko lowetoko ukalauya yoweko minakoloinako, aito wewenasi muda-lelamikilae. ");
INSERT INTO yby_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wewena mako dukanipo nemamitaboya, ganeya eli lamikilae. Ito ga maya lo noliboboya nemo gane minamiye. Ahone noli hibo wemidana gala maya lo noliboe, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nemoya edimokiya minoko ga maya lo libeko api-napi olibekaka noe. ");
INSERT INTO yby_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ito nemoya alo yowekoyoko, luhawatipo le ilitetibo weya Omaimidana weuna oluhola ahonekahoya nemo ganeloya oli hekadeko lemeko muki nesahenamu api-napi o libeko nemo lo libobo gaya lo ohatama oko lo libekaka oko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nemo hulu maya edimodaya noliboe. Ma mikau wewenasida hulunipoya libamoe. Neimone hulune maya noliboe. Sa-ominoyo, oli libeko ololo amilo. ");
INSERT INTO yby_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nemoya wokoko aku edimotoka le welepa jeko nisitubo ne loko lobo maya alo eli-minabo maya ne. Dukaya nemotoka moliki minatidanako, ahoneya nemo asenetoko nenako, ahonetoka yowekoyoko, weuna oluhoya oli hitibokumuya elikiki mulutipouya dowa letine. ");
INSERT INTO yby_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Maya nesaya soto pideko mudaikiki edimoya elewole iki data kitae loko aya nesa maya owaha soto pamiyoko lo noliboe. ");
INSERT INTO yby_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nemoya muki ga maya amida meko lo libametuwe. Maya mikau uliki we oloha maya alo nisituwe loko le lolowa okaiye. Sa-iboya niseko nemodaya helu jamekolaiboya, ");
INSERT INTO yby_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","monoka elamabo wewenasi yowanu ga lonetaibo yowanu maya lekaka noiboya, mudaikiki nukaneya ahoneda mekaka noiye liki litae loko oliwaki nesa elewoleya le soto molokaka noyo. Loko lokoko, muki sinalo, alo wetuniyo loko liye. ");
INSERT INTO yby_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisesimamo kolo meko nemoya waini nala monawa laloya minoe loko liye. Ito ahoneya waini yowanu ahola maya ne. ");
INSERT INTO yby_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ito nemotokatiya akawa makolimoya ihilawa jametiboya ihilawa wavu-leko jitiye loko hukoko le hulatiye. Ito ihilawa jekaiyoko mudaikoko akawa lahelamibolawa maya hukoko le hulokaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Sa-onenako, edimoya monoka lo libobolimoya dukauya le uliwitokaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Edimosiya nemotoka nisiki omiki minataboya nemokahoya asako edimotoka woko omeko minakoloe. Akawane makolimo monawaneloya omeko minametiboya eimola ihilawa mako jametibo ne. Sa-onenako, edimosiya nisiki nemotoka omamitaboya, asaoko edimotokaya ma ihilawa jametibo ne. ");
INSERT INTO yby_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nemoya waini nala monawa minonako, edimoya akawaneya minae. Wewena mako nisiki nemotoka omitaboya edimotoka asako woko omekoyoko ihilawa lalo jideko minakilae. Edimoya ma nemoki nisiki omiki minamitaboya ma ihilawa lalo jamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wewena mako nisiki nemotoka omamitaboya, alala miyoko hukiki li hulikaka niabo nesa leko alala mekolainako, hukoko le hulakoloe. Akawahenaya alala mekaiyoko hukiki joku jikaka niae. Nemotoka nisiki omamabo wewenasidaya aya nesaya dupalo soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Edimoya nemoki omiki minataboya ito nemo ganeya dukau netiboya sainahenamuya wako litabo nesaya aha soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Edimotokaya ihilawa muki jideko wehe liki nemo wewenane yuha lolo iki minadekoma, ahoneda onowelaki luhuwala maya soto pekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ahonekahoya ukala nemekaka noiyoko, nemokiya asaoko nukane mekaka nonako, edimokiya asaoko nukane libekaka nobomidana apilaloka maya nisiki minalo. ");
INSERT INTO yby_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nemoya ahoneda epalauti ga maya emesalo moloko ukala nemekaka noibomidana apilaloka minobo ne. Sa-okaka nobo nenako, edimokiya asaiki nepauti ga maya eli likiki nisiki nukane libekaka nobomidana apineloka maya minatayo. ");
INSERT INTO yby_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nemoya muluneuya aila uluma silekaka noibo nesaya edimotoka minadeko, mulutipou aila uluma silitibolimoya hutili oko lomala jeko minadeyo loko ga maya lo libeko suwoe. ");
INSERT INTO yby_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Sa-loko lo nolibetoe. Nukane libekaka nobo nesa liki emo uka mideko emo uka mideko iki mini-liki wiki minalo. ");
INSERT INTO yby_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wewena mako iwelamuye loko minoko leko noibo nesala hulatiboya, ukala bekaka noibo nesamidana monawa maya soto pekolaiye. Aitomidana uka mekakalimoya sako uka mekakamidana asetamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ga maya lolibetobomidana lolo ikadeko mudakoko yowo mololibetakoloe. ");
INSERT INTO yby_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Elekele oluho makolimo oluho aholakaho oko moloko ibo nesahenaya mudaminako, oloti maya onawaloya edimokumuya elekele oluhonele loko lametuwe. Nemo ahonetokati elobo ga maya lo libeko suwokobo maya nenako, edimokumuya yowonele minae loko letuwe. ");
INSERT INTO yby_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Edimoya nemoda maya nilimi eto amae. Neimonekaho dilipe eto okoyoko wiki saina ihilawa maya li soto molikadeko, woko elewole oko minowa minowa oko netiye loko lo noliboe. Sa-okadeko, nemo nuline maya li-miniki yamidana mamidana nesamu wako litaboya ahonekaho aha libekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sa-onenako, olotiya emo uka mideko emo uka mideko iki minatae loko nololibetoe. 12 Jon 13:34; 1 Jon 3:23 ");
INSERT INTO yby_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Monoka eli lamabo wewenasiya ulanipolo we lolo nilibitadeko maya, we napate maya ma mikau neboto asaiki ulana molitikaka abo maya ne liki elilo. ");
INSERT INTO yby_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Edimoya monoka elamabo wewenasikuti minatidanako, sa-iki nesa lolo ilibitamiki duka moli libetine. Nemoya luwawanipoutiya dilipe lena okoyoko, iki moliki abo nesa maya alo hulikabo maya ne. Sa-ikabo maya nenako, yamuya ulanipolo we lolo nilibitikaka niae. ");
INSERT INTO yby_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Elekele oluholimoya ujapa wela oko moloko okaka noibo nesamidana asetokaka minamiye loko lo libobo ga maya elitayo. Monoka elamabo wewenasiya nemoda lahelamibo nesa lolo initikaka nianako, edimokiya asaiki lahelamibo nesa lolo ilibitakilae. Nemo ganeya eliki li owo jamabo nenako, edimo atipokiya asaiki eliki li owo jamikilae. ");
INSERT INTO yby_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Noli hibo wemidana muda-eli wehe lamabo nenako, yamuya nemo nuline edimotoka nebokumuye liki sa-ilibitakilae. ");
INSERT INTO yby_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nemoya edimoki lemeko soto peko gaya lo libamobo minatidanako, lihimanipoya minametine. Sa-iboya lihimanipo maya nena nena iki hulatae. ");
INSERT INTO yby_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nemoda ulanelo we lolo initikaka niabo wewenasiya ahonedakiya ulalalo we lolo itikaka niae. ");
INSERT INTO yby_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nemoya luwawanipou elewole oliwaki ganeya muki wewenasi li soto pamabomidana le soto pamobo minatidanako, aya wewenasitokaya lihimanipo minametine. Aya nesa lolo okoyoko mudaikabo maya neboya, mudai hulikiki nemoda ulanipolo we lolo initikaka niae. Sa-inadanaki, ahonedakiya asaiki ulanipolo we lolo itikaka niae. ");
INSERT INTO yby_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sa-ikaka niayoko, monoka bukuguya ga mako sa-liki luhuwa ji-minabo ga maya niseko ulolotonebo ne: Edimoya nemoda ahamu ulanipolo we lolo initae. ");
INSERT INTO yby_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","He elowo olibetoko ihilamidana ahola maya Omai weuna oluho maya ahonetoka ne. Edimotokaya ahonetokati oli hekoyoko lemeko nemo monawane lo soto molakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ito edimoya nemo yowanu api obokuti maya nemoki magoina mini-liki wiki minabo maya nenako, edimokiya asaiki nemo monawane maya li soto molakilae. 20 Mat 10:24; Luk 6:40; Jon 13:16 25 Sam 35:19; Sam 69:4 ");
INSERT INTO yby_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Alikaya lahelamibo nesa lolo nilibitadeko monokaya hulikatae loko ga maya lo noliboe. ");
INSERT INTO yby_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Monoka numudatipo maya hiki li libitakilae. Ito onawa mako alili ekolaiye. Sa-ideko, Omai nasahili noetupe ni-liki kohaidi helikilae. ");
INSERT INTO yby_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sa-itaboya, ahoneki nemokiya mudaleli wehe lamiki sa-ikilae. ");
INSERT INTO yby_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Maya owaha lo libobo gaya woko elewole noideko, ahotemamo alo lo lemenebo nesa maya soto piye liki litayo. Yowanu api obo onawalo maya edimoki minoko leko udawo onawa hana neboto maya sa-loko lo libamobo maya neyo. ");
INSERT INTO yby_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Olotiya noli hibo wemitoka aku le wili jeko wekoloyokoya, edimokuti we makolimo nakahaloka wetane loko loka onetamiye. ");
INSERT INTO yby_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ga maya lo liboyoko miluma nesalimo dukauya wai notiye. ");
INSERT INTO yby_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nemoya wehe loko noloe, nemoya aku le wili jeko ahone nebotoka yowitubolimoya saina ulawa le soto mololibetakolaiye. Hulolibetoko yowametidanako, he elowo olibetatibo weya lemametine. Sa-okatinako, nemoya yowekoko oli hekoyoko edimotoka lemekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Sakoya lemekoko ma mikau wewenasida lihimanipomidana monawa ito wehe loko minokakamidana monawa ito lihima bitibomidana monawa lo soto molokadeko, eli wehe likilae. ");
INSERT INTO yby_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Aya wewenasiya nemokumu elewole iki elamabo nenako, lihimanipo monawamuya lideko elitayo. ");
INSERT INTO yby_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Wehe lokakamidana monawa maya lideko, nemoya ahonetoka le wili jeko yowekoyoko, aku muda-nelamikilae liki elitae. ");
INSERT INTO yby_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Obi yowanu lekakamidana monawa lideko ma mikau we Olohamidana lihimalamuya alo obi okaibo maya neyo liki elikilae. ");
INSERT INTO yby_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Wavu-leko nesamu lo libitubo ga maya neboya, olotikogo muki nesamu lo libeko suwokoyoko eda delokatiyo. ");
INSERT INTO yby_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ga madona Omaimidana weuna oluhola maya lemekoko ga lalomidana ulau dilipe-loko wekolaiye. Sa-etiboya eimola ata eleko samekolaiye. Omailimo letiboto emesalo moloko sa-ekolaiye. Sakoya minoko alika soto pitibo nesamuya lo libe libe oko minakolaiye. ");
INSERT INTO yby_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Gahena maya nemotokati lekoko lo libideko, nemo huwepanekiya le nupalo moloko minoko soto pekoloe. ");
INSERT INTO yby_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ahonetokati nesa maya muki nemogoya neme suwone. Sa-onenako, Omai weuna oluholimoya gahena maya nemotokatigoya lekoko lo libekolaiye loko aloya lo libekoe. ");
INSERT INTO yby_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Edimoya lasolasi miniki nemoda maya muda-nelamikilae. Sakiya onawa lasolasi miniki alikaya aku muda-nelakilae. ");
INSERT INTO yby_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Loko liyoko, lemokuti unala ipalale yuha malokasiya sa-liki ligi hagi ae: Nenahamuya noliye. Onawa lasolasi miniki nemoda muda-nelamikilae loko liboya, ito alikaya onawa lasolasi mako miniki aku muda-nelakilae loko liboya. Ito ahonetoka aku le wili jeko yowekoloe loko liboya nenahamuya noliye. ");
INSERT INTO yby_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Liki ladanaki, makoya sa-liki lae: Onawa lasolasimu noliboya, nakaha onawamu noliye, lemote ma monalo elamudawo ga noliye. ");
INSERT INTO yby_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Liki likiki loka itakili niayoko, Jisesimamo mudailidokoko sa-loko lo limiye: Onawa lasolasi miniki muda-nelamikilae, ito onawa lasolasi miniki aku nemoda muda-nelakilae loko lobomuya ligi hagi niahe, olile. ");
INSERT INTO yby_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wehe loko lo libituyo, eli-minalo. Edimoya wije nama liki minadeko, monoka elemabo wewenasiya elowa jiki minakilae. Sa-iki minadeko, alikaya le wili jeko nisoyoko muda-nelikiki mulutipouya aila uluma silekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mena makolimoya oluho etatibo onawa alili okadeko miluma elekolaiye. Sakoya miluma eleko oluhola maya soto pekadeko, mulunauya aila uluma silekoko miluma elibo onawamu aku ata kamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Edimokiya olotiya asaiki miluma elitaboya, alikaya mudaidoyoko mulutipou aila uluma silekolaiye. Sa-idekoya, wewena makolimo mulutipou aila uluma silekaka nesaya hipo oko le hulamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Sa-ideko, ya onawaloya sainahenamu nemotoka wako lamikilae. Nemoya wehe loko wati gaya lo libekoloyo, eli-minalo: Yamidana nesamuya nemo ahonetokaya wako litaboya nemo nulinemuye loko aha libekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Edimoya omutiki mini-liki yowebotoka maya nemo nuline ma lamikima nenako, saina-painahenamuya wako lamaboma ne. Mulutipouya aila uluma silibo nesalimoya hutili oko yomala jeko waitetiye liki wako litaboya aya nesaya aha likilae. ");
INSERT INTO yby_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ga muki lo libekaka omo yowobo maya koha moloko gagoya lo liboe. Onawa mako alili ekolainako, ya onawalo maya sakoya koha moloko ga lo libamekoloe. Ahoneda monawala maya lo soto moloko lo libekoloe. ");
INSERT INTO yby_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Ya onawaloya nemo nuline maya li-miniki wako litae. Nemo ahonetokati lemobo ga maya elewole iki elikiki duka nemebomuya ahonekaho eimola ukala libekaka noiye. Sa-onenako, edimokumuya ahonetoka wako letuwe loko lamoe. ");
INSERT INTO yby_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nemoya ahoneda hulomikoko maya mikau lemobo ne, ito olotiya aku le wili jeko ma mika maya hulikoko ahonetoka yowekoloe. ");
INSERT INTO yby_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Loko liyoko, unala ipalale yuhalitaya sa-loko lo mune: Emo ga maya koha moloko lamoko olotiya lo soto moloko lo lemekane. ");
INSERT INTO yby_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sa-okaniyoko, olotiya emokumuya sa-loko elune: Wewena malokasiya loka-mika itamayoko, muki nesahenamuya ele suwo-minane. Sa-ominaniyoko, emoya Omailokati lemedawo we minane loko elewole oko lata kune. ");
INSERT INTO yby_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Loko lokuniyoko, Jisesimamo edimo olotiya elewole iki data ki nemehe loko lo limiye. ");
INSERT INTO yby_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Onawa mako alili ekolainako, alili okadeko nemoda maya hulinitikiki oli hutili iki numudatipoloka wikilae. Sakiya wikadeko, neimonego minatuwe. Sa-etuboya, ahonetego lelimote minakoloinako, neimonego minamekoloe. Sa-etibo onawa maya oloti owahasiya alili noiye. ");
INSERT INTO yby_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Sa-noiyoko, nemoda hulune maya edimotoka netiye loko olotiya lo noliboe. Edimoda ma mikau wewenasi lahelibo lahelamibo nesa lolo ilibitatabomuya mulutipou miluma elamilo. Nemoya ma mikau nesasida asebetoko minoyo. ");
INSERT INTO yby_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisesimamo ga maya lo lemeko suwokoko mino muna oko okepa hulo okulumauka moloko sa-loko liye: Ahone yamalae, onawa maya aloya alili okaiyo, ipakada luhuwala maya le soto molokadeko, nemo ipakakahoya luhuwaka maya le soto molatuwe. ");
INSERT INTO yby_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Emokahoya numuto namato wewenasida ahonipo nilime lolo adawoya nemotoka dilipe moladawo wewenasida maya elewole depa mutiwa bekoloe loko sadawo ne. ");
INSERT INTO yby_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Elewole depa mutiwamidana monawa maya sa-loko ne: Omai wehe loko ihilawa makoko ito noli hedawo we ipaka Jisesi Kalaesti nemo monawane nielideko elewole depa mutiwa maya soto pe libekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Emo nemedawo yowanu maya le suwokoyoko, emo luhuwaka maya ma mikau soto pekaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kee, ahonewae, ma mikaya owaha soto pamiyoko emoki magoina okulumau lamedaneki minobo maya neyo, olotiya owisakaloya omutoko minoibo nesa maya aku nimideko minatuwe loko noloe. ");
INSERT INTO yby_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ma mikau wewena maloka nemotoka dilipe moladawolasidaya emo monawaka elewoleyakahena lo bobo maya ne. Emo oluhokale yuha maya dilipe nemotoka molaniyoko, emo gaka maya eli likae. ");
INSERT INTO yby_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ito nemotoka nebo nesahena mukiya emotokatigoya ne liki eli-minae. ");
INSERT INTO yby_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ito lo nemedawo gahena maya alo lo boyoko eliki suwikae. Ito noli hekaniyoko emotokati lemobolawa maya alo elewole iki elikae. ");
INSERT INTO yby_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Sa-niayoko, edimokumuya emotoka noloe. Monoka dukau minamibo wewenamuya lamoe. Emokahoya nemedawo wewenanele yuhaya emo oluhoka lolo iki minaboma nenako, edimokumuya noloe. ");
INSERT INTO yby_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ito nemo oluhoneya emo oluhokale yuha maya minae. Ito dukadunu iki moliki niabo nesalimoya nemo luhuwane maya soto pekaka noiye. ");
INSERT INTO yby_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Sa-iyoko, nemo maya mikauka minatubo onawa maya aloya su-noiye. Edimosiya amida miki minadeko nemoya emotokaya yowekoloe. Eto o-minadawo ahonelika, elewoleyakaloti nadeu moladawo wewenasida le etoha obikadeko minatae. Sa-ikadeko, luka makoko nebomidana edimokiya asako duka makoko netiye. ");
INSERT INTO yby_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Edimoki magoina minudawo onawalo nemotoka dilipe moladawo wewenasiya elewoleyakalotiya nasahili obetokaka noyoko, yamidana ukauya minae. Sakoya ujapa obetoyoko wiki opa amabo ne. Monoka bukugu luhuwa mako sa-loko nebo maya niseko ulolotetiye loko alika okepa usitibo we makoko latila iye. ");
INSERT INTO yby_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Oloti maya emotoka wekolo nodanaki, ma mikau wewena mulunipou aila uluma silibolimoya hutili oko yomala jeko moneko netiye loko noloe. ");
INSERT INTO yby_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nemoya emo gaka maya alo lo beminobo maya ne. Nemoya mikamidana oluhola minamoe. Edimokiya asaiki mikamidana oluhola minamanako, hetoka wewenasiya asaiki ulanipolo we lolo nibitikaka niae. ");
INSERT INTO yby_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Emoya wewenane yuhasida ma mikauti dilimitane loko lamoe. We lahelamibo olohamidanamuya ujapa obetatane loko noloe. ");
INSERT INTO yby_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nemoya mikamidana oluhola minamoe. Ito edimokiya asaiki mikamidana oluhola minamae. ");
INSERT INTO yby_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ga ulawa dukau limitibototiya dilipe eto o. Emo gaka maya wehe loko ga ulawaya ne. ");
INSERT INTO yby_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Emokahoya nemoda yowanu ga lonetoko ma mikauka noli hekaniyoko asako maya mikaukaya yowanu ga loko doli nohoe. ");
INSERT INTO yby_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Emo gaka lalolimo dukauya lemekoko yalimoya dilipe eto etiye loko neimone nuka nupane maya le eto oko noloe. ");
INSERT INTO yby_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nemoya ya wewenasidamugoya emotoka lamoe. Edimosiya li bideko nemotoka elewole iki elitabo wewenasidamukiya noloe. ");
INSERT INTO yby_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Duka makoko minadeko minatae loko yamuya noloe. Ahonelika, nemoda maya uka je-minane. Ito nemoya emoda uka jeminoe. Yamidana oko edimosidakiya le uka jesiye loko yamuya noloe. Sa-okadeko monoka madonipou minamibo wewenasi emo noli hekaniyoko lemobolawa maya eli wehe litae. ");
INSERT INTO yby_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Lemoya luka makoko nenako, edimokiya duka makoko minadeko minatae loko luhuwaki lamedakaki nemedawo nesa maya noboe. ");
INSERT INTO yby_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nemo weune boyoko ito emokaho weuka nemeniyoko, edimokiya asaiki dukadunu mutihina iki makoko aweyaha iki minatayo. Sa-ikadeko, monoka madonipou minamibolawasiya emo noli hekaniyoko lemobolawa maya eli wehe liki elitanage, ito uka nemotoka molokaka noadawo nesa leko edimotokaki molokaka noane liki eli wehe litae. ");
INSERT INTO yby_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ahonelika, nemotoka dilipe moladawo wewenaya nemo minatubotoka minatae loko noloe. Yalo maya miniki mika maya owaha soto pamiyoko uka nemotoka moladanaki okulumamidana lamedala maya nemotoka le henetadawo nesa maya mudai wehe litanage. ");
INSERT INTO yby_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ahone lalo yamalae, monoka madonipou minamibo wewenasiya monawaka maya eli wehe lamaboya, nemoya ele-minoe, ito nemo wewenanele yuhasiya emo noli heniyoko lemobolawa maya eli-minae. ");
INSERT INTO yby_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nemoya monawaka maya lo boe, ito lo beko minakoloe. Sakoyoko uka nemedawomidana edimotoka minadeko, nemoya dukauya minakoloe. 12 Sam 41:9; Jon 13:18 ");
INSERT INTO yby_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisesimamo ga maya sa-loko lo lemeko suwokaiyoko, lemo wewenalale yuhakiya Kidoloni no maya sila okoko yola helegaloka woko ya yuha makomauya yowune. ");
INSERT INTO yby_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aya ya yuhauya lemo Jisesile unala ipalale yuhaki le esa okaka noudawoku nenako, Jisesida mimi etibo we Judasikiya aya ebamuya elekoko, Jisesiya ayaloka netibo ne loko elekadaki, ");
INSERT INTO yby_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Omaitoka jokila hi mikaka niabo weki ito Palasisi wewena minabotoka maya woko Jisesida maya libekolobolae loko loka obetaiyoko, oo likadanaki, wavu-liki imi wehenaki ito monoka numuda napauti imi we malokasidaki maya doli hikayoko wewena wavu-liki lehena lepa ikiki lowa hikaka nesahenamaki li-miniki Judasidama emeke moliki Jisesi nebotoka wae. ");
INSERT INTO yby_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nisiki hetikayoko, Jisesimamo eimola upalo yowitibo nesamu elekoko ya yuhauti maya lemekoko sa-loko lo biye: Edimoya ekahikumu ohu nije. ");
INSERT INTO yby_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Loko liyoko, lemoya Naseleti we Jisesidamu ohu nojune liki layoko, Jisesimamo nemo maya minobolae loko liyoko, mimi ibo we Judasi maya luwawanipou nedanaki ");
INSERT INTO yby_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","emoki aya wewenamaki Jisesima libo gamuya oli demesalokati demesalokati niwadanaki, limiki mikau maya pou liki udimi wae. ");
INSERT INTO yby_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sa-ikayoko, Jisesimamo loka obetoko akuya ekahikumu moniki ohu nije, loko liyoko, lemoya Jisesi Naseleti wemamu ohu nojune liki layoko, ");
INSERT INTO yby_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisesimamo nemo maya minobolae loko lo libekobolae loko liye. Sa-ominoyo, nemodamuya moniki ohu nijitaboya, matoka wesidaya hulibitikadeko aha numudanipoloka witae. ");
INSERT INTO yby_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Loko lokoko ga mako sa-loko ayaloya libolimoya woko ulolotiye: Nemotoka dilipe moladawo weutiya mako tolowa amiye. ");
INSERT INTO yby_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sa-iyoko, Saimoni Pitamamo sopolola owolauka maya lenebototi eleleha okoko Omaitoka jokila hi mikaka wesida we napamidana elekele oluhola Malokusida kohako lamawakaloka atala maya bolotoko hulikaiyoko, atala maya lemo mikalo jiye. ");
INSERT INTO yby_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sa-iyoko, Jisesimamo Pitada maya sopolo emitaka yaitaya aku le owolau owo jo loko lo miye. Ahonekahoya miluma nesa le ohitane loko lonebo maya nenako, emokahoya le ohametane loko sa-noape, loko liye. 11 Mat 26:39; Mak 14:36; Luk 22:42 ");
INSERT INTO yby_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sa-okaiyoko, imiki wehenaki ujapa wenipoki ito Juda wewenasida imiki wenipolekiya nisiki Jisesida maya adelo liki nala je. ");
INSERT INTO yby_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Sa-ikiki adelo likiki adaya ilimi-liki Kaiyapasi menalada ahola Anasiyo loko nebo weloka ilimikili wae. Kaiyapasiya aya melekeya niseko nowiyoko Omaitoka jokila hi mikaka wesida ujapa wenipo lolo oko minoko, ");
INSERT INTO yby_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","hapa yeikalaya Juda wewenasida maya data leko we makokolimo lemo heletudawoto maya lilime nupa oko helekadeko lemoya aha wati oko minatune loko libo we ne. 14 Jon 11:49-51 ");
INSERT INTO yby_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sa-okaiyoko, Saimoni Pitamamo Jisesida unala ipalale yuhauti we mako Jisesida emeke moloyoko woibo we maya Omaitoka jokila he mekaka noibo we napalimoya nemoda muda-nelonebo nenako, Jisesikiya magoina woko Omailoka jokila hi mikaka wesida ohonipouya yowe-minoiyoko, ");
INSERT INTO yby_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pitamamo oho ateto maya sinoneyoko, wela mako Omaitoka jokila hi mikaka niabo we napaya mudaelo-minobo nenako, nemokaho woko ateto ujapa onebo menamidana maya lo mekoko Pitada maya ilime-loko oho ulauya yowoiye. ");
INSERT INTO yby_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yowekoiyoko, ateto ujapa onebo menamamo Pitada maya sa-loko lo miye: Emoya aya wemidana unala ipalale yuhauti maya minape, liyoko Pitamamo nemo ya weya minamoe, aito we minoe loko liye. ");
INSERT INTO yby_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Loko lokaiyoko, elekele wehenaki imi wehenakiya lasi delokaiyoko jo jiki lapi niabotoka maya Pitamakiya lasila elokaiyoko nenako, niseko sino-minoko jotoka maya lapi noiye. ");
INSERT INTO yby_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sa-noiyoko, Omaitoka jokila he mekaka we napalimoya Jisesida unala ipalale yuhasida maya api-napi obetokaka noibo gamuya loka oetaiye. ");
INSERT INTO yby_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Loka oetaiyoko, Jisesimamo nemoya muki numuto namato wewenasida lo soto moloko lo bekaka noe loko liye. Nemoya numudatipou numudatipouya ito monoka numuda napauya Juda wewenahenaya muki li esa iki minayoko api-napi obekaka noe. Nemoya sunauka ga mako lo bamoe. ");
INSERT INTO yby_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Emoya nenahamuya loka nonetane. Nemo gane lo bekoyoko eli-minabo wewenasida yaitaya nenae loko libo ne loko loka obetowo. Nemo lo bekaka noboya aya wewenasiya eliminayo. ");
INSERT INTO yby_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Loko liyoko, imi we mako maloka sinonebo welimoya Jisesida maya adeloti nokohako sa-loko liye: Omaitoka jokila he mekaka we napa maya neboya emoya aya ga lo nomepe. ");
INSERT INTO yby_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Loko lokaiyoko, Jisesimamo nemoya lahelamibo ga mako lominatubo maya lo soto molo loko aya wemidana maya lo miye. Ga lalo lo nolibobotoya emoya nenahamuya nokohanelane. ");
INSERT INTO yby_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Loko liyoko, Anasimamo nalaloti Jisesida adelo nala jekoko Omaitoka jokila hi mikaka wesida we napanipo Kaiyapasima nebotoka oli hekaiyoko ilimi-liki wae. ");
INSERT INTO yby_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sa-niayoko, Saimoni Pitate joto maya jo lapi iki sini-minayoko sa-liki li me: Emokiya Jisesida unala ipalale yuhauti minape. Liki layoko, yuwawa moloko nemo minamoe loko liye. ");
INSERT INTO yby_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Loko liyoko, Omailoka jokila he mekaka we napamidana elekele wela Pitakaho atala jeko bolotibo wemidana yuhauti we makolimoya loka oetoko emokiya ya yuhau minaniyoko mudaobo maya nehe, olo. ");
INSERT INTO yby_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Loko liyoko, aku Pitamamo yuwawa nomolaiyoko yalo maya okele maya onowa liye. ");
INSERT INTO yby_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Sa-ikayoko, Jisesida maya Kaiyapasida numudalauti maya ilimi hetoka molikiki ilimi-liki uliki wemidana numudalau maya wae. Wikiki udiki go maya lokaiyoko, Juda wewenasida esenipo vobetaibo holimidana nodenesala maya nakili Juda wewena amabo nesa lolo okoko lukate maya le huma jekatune liki uliki wemidana numudalau maya yowamae. ");
INSERT INTO yby_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sa-ikayoko, Paelatimamo hetoka maya lemeko loka obetoko sa-loko liye: Edimo maya weya nenahamuya ilimi-liki nisiki obi nitae, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Loko liyoko, maya weya lahelamibo nesa lolo ametidanako adelo leko emotoka leko nisametine. ");
INSERT INTO yby_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Liki layoko, Paelatimamo edimotipoya adelo liki wiki edimotipo li huki-minabo galoya obi italo. Loko liyoko, Juda wewenasida ujapa wenipolesiya, o'e, lemo gateya wewena mako kohaidi helamilo loko ne, liki lae. ");
INSERT INTO yby_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Liki laboya, yoho yaha yalo wewena kohaidi helikaka nesaya Lomu wewenasida nesagoya minokainako, Jisesimamo yamidana oko helitubo ne loko libo ga maya woko ulolotiye. ");
INSERT INTO yby_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Sa-iyoko, Paelati maya aku duliki wesida numuku maya yowekoko Jisesida ju lo meko emoya Juda wewenasida duliki wenipo napa maya minape, loko loka iye. ");
INSERT INTO yby_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Loko liyoko, Jisesimamo eimokaya ata eleko gaya nolape, ito wewena makolimo nemokumuya sa-loko lo emekaiyoko nolane. ");
INSERT INTO yby_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Loko liyoko, Paelatimamo sako minamiye. Nemoya Juda we minoyoko nolape, eimoka wewenakauti ito Omailoka jokila hi mikaka wekiya ilimi-liki nemotoka nisiminabo maya neyo, nena nesa lolo aniyoko ilimi-liki nise. ");
INSERT INTO yby_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Loko liyoko, Jisesimamo nemo nuliki we minatubo monawaya ma mikaukati monawa emesalo molametiye loko lo miye. Maya mikauka nebo nesa minatidanako, Juda wewenasida ujapa wesida dadeuya nilimi molikatae liki unanele ipanele yuhasiya lowa li soto molatidawo neboya, nemo nuliki we minatubo monawamoya ebaneya ma mikauka we suda minamiye. ");
INSERT INTO yby_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Loko liyoko, Paelatimamo sa-loko noladawoya, nuliki we minoe loko nolape, loko liye. Jisesimamo nemoya nuliki we minoe loko eimokaya lo soto molokadawoya, nemoya ga ulawa lo soto molatuwe loko ma mikau lemoboya donekaho etokaiyoko maya minoe. Ga ulawa elikaka niabo wewenasiya nemo nepauti gaya elikaka niae. ");
INSERT INTO yby_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Loko liyoko, Paelatimamo ga ulawae loko noladawo gaya nena gamae. Loko lokoko hetoka maya lemeko Juda wewenasidaya maya wemidana lihimalamuya ohu joboya minamiye loko lo biye. ");
INSERT INTO yby_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Sa-okaiyoko noloyo, edimotipoya monawala sakoya ne. Esetipo vobetaibo holi onawau maya we makomidana uli likayoko, nala numukuti maya doli he hula doli he hula noyoko, edimotoka wikaka niabo maya ne. Ito ga maya elideko woko wehe lidekoma, Juda wewenasida uliki wetipo maya nenako, esewa vomikoyoko edimotoka wetiyo. ");
INSERT INTO yby_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Loko liyoko, aya wewenamasiya ai ai moliki ga napauti sa-liki lae: O'e, Emoya minamiye, Emoya minamiye. Balabasida maya esewa voeto, liki laboya Balabasiya wewena kohaidoko sainanipo ukele lekaka we maya nenae. 32 Jon 3:14; Jon 12:32-33 ");
INSERT INTO yby_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Sakoya Paelatimamo lokaiyoko, Jisesidama seida oijoloti kohaiki, ");
INSERT INTO yby_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","uliki wema nenae liki imi wemasiya uhedawaki nalaloti adakoli lolo iki madonalo olo jimikiki upalo nesa lalo okohuda luhuwalakiya liki nisiki olo jitae. ");
INSERT INTO yby_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sa-ikiki amaitoka maya hiki leti miniki ganidalimo oulimo lemo jeje noiyoko sa-liki lae: Esekanealiyo, Juda wewenasida uliki wenipo maya minapao, ni-liki dadedunu Jisesida okepalo nijiki nijiki labo ne. ");
INSERT INTO yby_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Sa-ikayoko, Paelatimamo aku Juda wewena minabotoka maya lemeko mudalo, lihimalamuya ohu jobo maya minaminako, edimotipo elitae loko ilime-loko nonisoe. ");
INSERT INTO yby_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Loko lokaiyoko, Jisesimamo asowalaki adakolimaki upalo nesa luhuwakimaki olo jekoko lemeko minabotoka maya neyoko, Paelatimamo nodilopeko maya weya muda-elalo loko liyoko, ");
INSERT INTO yby_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Omaitoka jokila hi mikaka wehenamaki maloka wewenanipolekiya Jisesida maya muda-elikiki amowa jiki sa-liki lae: Ya weya yoho yaha yalo helitibokumuye, yoho yaha yalo helitibokumuye, liki layoko, Paelatimamo elekoko nemoya lihimalamuya ohu jobo minamiyoko, ");
INSERT INTO yby_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","edimotipoya ilimi-liki wiki yoho yaha yalo kohatune likima kohalo. Loko liyoko, Juda wewenamasiya eimoladamuya Omaimidana ipala maya minoe loko lokaka noibo nenako, yamidana wewena maya helitae liki lemoda li hukiliti-minabo gauya luhuwa ji-minabo maya nenako, helitiye. ");
INSERT INTO yby_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Liki layoko, Paelatimamo Omaimidana ipala minoe loko libo ne liki labokumuya omodala adoha wiye. ");
INSERT INTO yby_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Omodala adoha wokaiyoko nenako, Jisesida maya aku numuku maya ilime-loko yoweko emoya nakahautima soto pedawo ne loko loka oetaiye. Loko liboya Jisesimamo onoto lamiye. ");
INSERT INTO yby_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jisesimamo onoto lamiyoko, Paelatimamo emoya nenahamuya nonoto leko ga lo nemamane, nemokahoya letubotoya aha minakolane, ito nemokahoya letubotoya yoho yaha yalo helekolane. Yamidana elewoleya nimi-minabo maya neboya emoya elamape. ");
INSERT INTO yby_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Loko liyoko, Jisesimamo aha netiboya, nemo ganeya nena-nenakoma eletine. Nemo gane maya letane loko yowaukati Omailimo elewoleya emenebo maya nenako, yaya nolane. Yamuya emotoka nilime molaibo wemidana lihimala asegetoko napa-napa ne, loko lo miye. ");
INSERT INTO yby_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Loko liyoko, Paelatimamo Jisesida gala maya elekoko esewa voetatuwe loko liyoko, Juda wewenasida ujapa wesiya ai ai moliki emo maya wemidana esewa voetatadawoya Lomu ujapa wemidana iwela minatape, ito suwitatae. Ito we makolimo eimoladamu we napama minoe loko letiboya, Lomu ebatoka uliki we napa Sisada maya asetokoko lowa hamekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Liki layoko, Paelatima elekoko sa-loko lo bekaiyoko, Jisesida maya ilimi-liki lemeyoko lemeko ga li hukikaka sipalo maya neyoko, ehadaloti lolo abo sipaya Hibulu gautiya uliwa Gabatae liki likaka abo sipa ne. ");
INSERT INTO yby_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Juda wewenasida esenipo vobetaibo holi onawa maya minatune liki saina-painahena maya li lolowa niayoko, holiga nekewa maya Paelatimamo Juda wewenasida maya uliki wetipoma muda-elalo loko lo biye. ");
INSERT INTO yby_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Loko liyoko, aya wewenamasiya ai ai moliki sa-liki lae: Emoya suwideyo. Yoho yaha yalo yowideyo. Liki likayoko, Paelatimamo sa-loko liye: Aije, uliki wetipo maya neboya edimosiya lideko yoho yaha yalo yoweko helitiye liki nilahe. Loko liyoko, Omailoka jokila hi mikaka we napamasiya sa-liki lae: Lemoya uliki wete mako minamiye. Lomu ebatoka uliki wete makoko Sisagoya ne. ");
INSERT INTO yby_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Liki layoko, Paelatimamo elekoko Jisesida yoho yaha yalo kohaidiki helikaka oijoloti maya kohatae loko dadeuya molaiye. ");
INSERT INTO yby_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Sa-ikikiya lowa wesiya yoho yaha ya maya Jisesida mikayoko oheko leko eba mako madonipo abuhawa ebae loko ito Hibulu gautiya Gologotae loko nebo ebatokaya ilimi-liki wae. ");
INSERT INTO yby_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Sa-ikiya ilimi-liki wikiki yoho yaha yalo maya nalawa iki te. Sa-ikiki lahelamaibo we loweya kohaidiki apila maloka maloka maya nalawa iki tibitae. Sa-ikiki Jisesida maya luwaku maya hi sinitae. ");
INSERT INTO yby_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Sa-ikayoko, Paelatimamo sa-ilo liyoko yalo maya luhuwa mako sa-liki jiki molae: Naseleti numutoti Juda wewenasida uliki wenipo Jisesimae. ");
INSERT INTO yby_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yaya numuda esewatoka minokaiyoko, Juda wewenahena muki wiki nisiki niadanaki aya luhuwa maya lepe. Aya luhuwa maya Hibulu gauti ito Lomu gauti ito Guliki gautiya luhuwa jiki moli-minabo ne. ");
INSERT INTO yby_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sa-ikayoko, Juda wewenasida Omailoka jokila hi mikaka we napahenamasiya Paelatida maya sa-liki li me: Juda wewenasida uliki wenipoe liki luhuwa jamiki, nemoya Juda wewenasida duliki wenipo minoe loko libo ne liki luhuwa jamae. ");
INSERT INTO yby_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Liki layoko, Paelatimamo aloya luhuwa jekonako, aha netiye loko liye. ");
INSERT INTO yby_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sakiya lowa wewenamasiya Jisesida maya kohaiki yoho yaha yalo maya tikiki upalo nesa maya ona moliki loweki loweki iki aya nesa maya ona moliki li yawalo yawalo iki aya wego lolo ae. Sa-ikayoko, upalo nesa hana maya onuwa miki oto amabo nesa nenako, likiki sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sa-okainako, hukoko le nosamibo okatiye, likiki kati onokidana ono makoya molae, asitibo welimo litiye likiki. Sa-iki saboya, monoka bukuguya ga mako sa-liki luhuwa ji-minabo maya ne: Nemo olo jeminobo nesaneya ona moliki likiki muki nupalo nesaneya li onou molatabo ne, liki luhuwa ji-minabo ga maya ayaloya niseko ulolotiye. ");
INSERT INTO yby_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lowa wesiya sa-inayoko, Jisesida yoho yaha ya monauya mena sa-iki neboya ne: Dolale ito aholale ito Kolopasida menala Mele ito Magadala numutokati Mele makokiya. ");
INSERT INTO yby_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yauya Jisesikaho weuna nemenebo we nemokiya magoina minuniyoko nenako, Jisesimamo dolada maya sa-loko lo miye: Mena yamalae, nemo ipakada maya muda-elogae. ");
INSERT INTO yby_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Loko lokoko nemodaya sa-loko lo nimiye: Dokada maya muda-elo. Loko lokaiyoko, aya onawalo wehe loko nemo numudaneu maya magoina minoibo ne. 24 Sam 22:18 ");
INSERT INTO yby_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisesima yowanula le suwibo elekoko gala maya woko ulolotetiye loko ga mako monoka bukugu neboya gaya sa-loko liye: Nonemu nelokaiye. ");
INSERT INTO yby_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Loko liyoko, lape makomauya waini no ekesamidanaya mako neyoko aya nokuya noikidana elibo nesauya oijolo pikiki Jisesidama meyoko naiye. ");
INSERT INTO yby_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Waini no maya nokoko ju loko aloya ahonelika, nemedawo yowanuma le suwokoyo loko lidanaki weuna oluhola maya huloetokoko yowekaiyoko madona lipe lemeko heliye. 28 Sam 22:15 29 Sam 69:21 ");
INSERT INTO yby_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Juda wewenasida ujapa wesiya latanipolesida esenipo vibo holi onawa maya minakili sainahena li lolowa niadanaki sa-liki lae: Aijoma holi napama minatudawoma nenako, kohaidabo wewena maya yoho yaha yalo minamitae. Liki likiki Paelatida maya sa-liki li me: Aijo maya holi onawa napa maya nenako, lowa wewenasida yaitaya doli hideko wiki aya wewenasida di abuhawanipoma jiki letiki liki wiki ale jibitatae. ");
INSERT INTO yby_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Liki likayoko, Paelatimamo lowa wesida maya doli hiyoko wiki lahelamibo weunipo molaibo we Jisesiki magoina kohaidabo we lowesida maya dima jiki letikiki liki wiki Jisesida maya muda-elae. ");
INSERT INTO yby_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sakiya wiki mudabo maya, Jisesima alo helekaiyoko nenako, ila maya jiki letamae. ");
INSERT INTO yby_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sa-iyoko, lowa we makolimo Jisesida lohanau maya ujaloti heko ololi iyoko oladalaki nokiya ayauti maya limiye. ");
INSERT INTO yby_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Sakiya sabo nesaya nemo nomuda ihilawaloti mudakoko maya lo noliboe, suwa minamiye. Sakiya sayoko mudaminobo nenako, olotiya edimokiya elikiki elewole iki data kitae loko lo noliboe. ");
INSERT INTO yby_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Monoka bukugu ga mako sa-loko nebo maya woko ulalo litiye loko soto piye: ");
INSERT INTO yby_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Edimoya ono abuhawaya ma jiki letamikilae. Ito monoka bukuguya ga mako sa-loko ne: Ujaloti lohanau hiki hokolotabo we maya muda-elakilae. 36 Eks 12:46; Nam 9:12; Sam 34:20 37 Jek 12:10; Lev 1:7 ");
INSERT INTO yby_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Sa-ikayoko, Alimatiya numutoti we Josepuya Juda wewenasida ujapa wenipomuya omodala wokaibo nenako, sunauka Jisesida oluhola nebo wemamo Jisesida onola maya leko wekoloe loko woko Paelatida maya liyoko, Paelatimamo oo lokaiyoko, woko yoho yaha yaloti maya leko nolimiyoko, ");
INSERT INTO yby_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimasiya hapa yeikala lubuka Jisesitoka wibo we maya nuwala wibo netupa lowemidana le opa napa okoko sigelilo mologo ibo edawa maya 50 kilo okaiyoko heko leko wiye. ");
INSERT INTO yby_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Sakoya emoki we malokasiya liki wiki Josepuda maya ilimiyoko, Jisesida onola maya nuwama wokatiye liki aya netupa maya hilimikiki lawo-lawo ukulolotiya sese imikiki Juda wewenasi ono molikaka niabo nesa liki molitae. ");
INSERT INTO yby_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Saboya, Jisesida kohabo apilalokaya ya yuha mako nebo nenako, yamidana monauya ehada numuda mako neboya wewena owaha ono molamayoko, aha ohatama nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sa-iyoko, Juda wewenasida esenipo vibo holi onawa maya alili okoko yowanu litabo onawa maya suwokaiyoko, aya ehada numuda maya alili neyoko nenako, yau maya Jisesida onola maya enemane iki liki wiki molitae. 39 Jon 3:1-2 ");
INSERT INTO yby_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sadeu maya go lo mikalo molamiyoko, Magadala numutokati mena Mele maya ono eba maya mudakolo wiye. Woko mudaibo maya, ehada numuto ateto ehada napa moli li li-minabo ehada maya ipisiki li huli-minayoko mudaiye. ");
INSERT INTO yby_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sakoko lolosa jeko woko Saimoni Pitako nemoko maya muda-lelokoko sa-loko lo limiye: We napatemidana onola maya alo liki wikae. Nakahaukama moli-minabo ne. Lemoya ma muda-elamune. ");
INSERT INTO yby_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Loko lokaiyoko, Pitako nemoko maya aya ono ebatoka maya woiye. ");
INSERT INTO yby_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Anuloka lolosa jeko woko nemo maya Pitada huloetokoko omutoko woko ono alelo maya hetokoko, ");
INSERT INTO yby_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","awa heko mudaobo maya, lawo-lawo nala jebo nesago neyoko mudaoboya, aya ehada numuku maya yowamoe. ");
INSERT INTO yby_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sakoyoko, Saimoni Pita maya alikaya nisekoko aya ehada numuku maya yoweko mudaibo maya lawo-lawo sese abomago neyoko, ");
INSERT INTO yby_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","madonalo ukulo lawo-lawo wasa jebo maya aitoya elewekeko moloneyoko mudaiye. ");
INSERT INTO yby_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sa-iyoko, nemo omutoko nisoboma neboya alikaya ayau maya yowekoko aya nesago neyoko mudakoko aloya sinoko wokaiye loko elewole oko nata koe. ");
INSERT INTO yby_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Hapa yeikalaya monoka bukugu Jisesima helenetibokuti aku sinoko yowitibo ne loko nebo ga maya ele wehe lamune. ");
INSERT INTO yby_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sa-okoko lemo maya aku le wili jeko numutoka maya woiye. ");
INSERT INTO yby_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Wokoiyoko, Magadala numutokati mena Melema ayalo maya ale apilaloka minoko wije nama leko nebototiya awa heko aya aleu maya nomudaiyoko, ");
INSERT INTO yby_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","okananipoki we lowe maya Jisesida ale jitabo ale epalo maya ukulo nesago olo jikiki esenipo hiki minaiyoko mudaidonebo ne. Makoyamoya madonaloka maya nebo ne. Makoya ilaloka nebo ne. ");
INSERT INTO yby_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Sakiya minaidanaki, mena yamalae, emoya nenahamuya wije noane, liki laiyoko, maya menamamo edimoya nenaha iye, nemo we napaneda onola maya liki wikayoko nakahaloka liki wahe loko ohu nojeko noloe. ");
INSERT INTO yby_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Loko lokoko mino wili jeko mudaibo maya, Jisesima neyoko mudaibo neboya, okepala maya muda wehe lamibo ne. ");
INSERT INTO yby_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Muda wehe lamiyoko, Jisesimamo loka oetoko mena yamalae, ekahidamu ohu jeko moneko wije nama nolene. Loko loka iyoko, emoya ya yuhau yowanu lekaka we maya nehe loko sa-loko lo miye: We lalo nesa yamalae, emoya onowa maya leko woko aito ebakuka molo-minatadawoya, lo nimideko leko wetuwe. ");
INSERT INTO yby_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Loko liyoko, Jisesimamo Mele liyoko, emo maya wili jeko Juda gaukatiya lapuniyo loko, lemo gateukatiya monoka ujapalo we yamalae loko libo ne. ");
INSERT INTO yby_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Loko liyoko, Jisesimamo nemoya ahonetoka owaha yowamoyo, napusa jamoko, woko unamotanele yuhasida maya nemo ahone maya edimo ahotipoe, ito nemo Omaine maya edimo Omaitipo nebotoka yowekoloyo, lo bo loko lo miye. ");
INSERT INTO yby_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Loko lo mekaiyoko, Mele Magadala numutokati menamamo aku le wili jeko woko Jisesida unala ipalale yuhasida maya sa-loko lo limiye: Nemoya we napate maya muda-eloyoko, sa-loko lo nimiye, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Loko lokaiyoko, Sadeu maya lubu jekaiyoko, lemo unala ipalale yuha maya Juda wewenasida ujapa wenipolemuya olite lemekaiyoko nenako, anu vokoko numuku maya yoweko minuniyoko, Jisesimamo luwawateu maya sinonedanaki sa-loko lo limiye: Huluya edimotoka minadeyo. ");
INSERT INTO yby_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Loko lokoko ade lowe maya lilipeko lohana maya lilipiyoko, unala ipalale yuha maya we napate maya muda-elokoko muluteu lalo elune. ");
INSERT INTO yby_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Sa-okuniyoko, akuya sa-loko lo limiye: Hulu maya edimotoka minadeyo. Ahonekaho noli hibomidana oko edimoya doli nohoe. ");
INSERT INTO yby_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Loko lokoko, epa mutiwa lemeko sa-loko liye: Omaimidana weuna oluho maya lilo. ");
INSERT INTO yby_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sa-ikadeko, wewena maya lahelamibo nesamu liki hulataboya suwetiyo. Sa-ikiki liki hulamitabo maya aha minakolaiye, loko liye. 23 Mat 16:19; Mat 18:18 ");
INSERT INTO yby_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Iwete makoya uliwa Tomasiyo loko uliwa makoya Lobe-Oluhoe loko nebo weya eba makomalo neyoko, Jisesima sinokoko niseko lemotoka soto piye. ");
INSERT INTO yby_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Soto pekaiyoko, lemo sa-loko wetome oko lo mune: Lemo we napate maya lomudaloti muda-elokune. Loko lokuniyoko, Tomasimamo neimonekaho adelau hulala maya mudamoko ayauya nadeloti leko elamoko, ito lohanaloka hulala maya nadeloti leko elamoko maya, gatipo watiya ne loko lametuwe. ");
INSERT INTO yby_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Loko lokoko neyoko, Sade makoya alili okaiyoko, lemo unala ipalale yuha maya aya Tomasimakiya numuda makomauya minudanaki, anu maya voko etoha okoko ulau maya minune. Sako minuniyoko, Jisesima luwakuti maya soto pekoko sa-loko lo limiye: Huluya edimotoka minadeyo. ");
INSERT INTO yby_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Loko lokoko Tomasida maya sa-loko lo miye: Adeloti yaitaya nade hulaneloka maya leko mudao. Ito adeka hulo moloko lohaneloka maya leko elo. Sakoko ataka lowe kamoko elewole oko ata makoko ko. ");
INSERT INTO yby_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Loko liyoko, Tomasimamo we napanemae ito Omainemae, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Loko liyoko, Jisesimamo emoya olotiya muda-nelokoko elewole oko ata kekane. Nemodaya muda-nelamiki elewole iki data kikaka niabo wewenamuya nelone, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ito Jisesikaho unala ipalale yuha lomudalo maya oliwaki nesa elewoleya lolo ibo maloka maya luhuwa je suwamoboya, ");
INSERT INTO yby_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","maloka maya luhuwa jobolawaya lepiki elikiki Jisesidamuya lahelamibo nesauti lilimitiye loko lo mololetaibo we Omaimidana ipalae liki emokumuya elewole iki data ki miniki elewole depa mutiwa maya litae loko jeminobo ne. ");
INSERT INTO yby_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ito minoko lemo unala ipalale yuha maya Galeli adu no ilikaloka woko minuniyoko, Jisesima aitomidana oko niseko soto piye. ");
INSERT INTO yby_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimoni Pitaki lobe oluho Tomasikiya Galeli ebakuka Kana numutokati we Nateniyoloki ito nemo yatoneki ito unala ipalale yuha lowemaki muki le esa oko minuniyoko, ");
INSERT INTO yby_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimoni Pitamamo sa-loko lo limiye: Nemoya lahawa lekolo nowoe. Loko lokoko wekolaiyoko, lemokiya magoina wetune lokoko magoina noku lapeu maya yowekoko woko aya lubukaya lahawa lamoko sa-owa sa-owa oko minuniyoko, ");
INSERT INTO yby_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","okululuwa nohokiyoko, Jisesi maya akeloka yolaya neboya, lemo unala ipalale yuhalitaya okepa muda wehe lamuniyoko, ");
INSERT INTO yby_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jisesimamo loka oletoko oluho yolaya lahawaya ma lehe, loko liyoko, lemo maya o'e, lahawa ma lamune loko lune. ");
INSERT INTO yby_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Loko lokuniyoko, Jisesimamo lahawa owo yaitaya li lamawakaloka moliki hulataboya owahaya lahawa likilae, loko liye. Loko liyoko, lahawa lekaka owo maya hulo lamawakaloka hulo moloko lahawa wavu-leko leko ika udawo maya matema le sawa jeko ika etudawo nesa lamune. ");
INSERT INTO yby_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sakokoya Jisesikaho ukala nemenebo we nemo Pitada maya we napate maya nenae loko lo mobo ga maya elekoko upa sapago nebototiya upalo nesa maya le olo jekoko le nokuka maya lemeko oli asoda jeko 100 mitakidanaya woko akeloka maya hetokaiyoko, ");
INSERT INTO yby_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","maloka welitaya lahawa owoma noku lapeu maya ika oko leko wune. ");
INSERT INTO yby_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Woko akeloka maya hetokoko saina mako sakoya mudaune: Jo mumuki-minaboku maya lawahaki beleti makoki neyoko mudaune. ");
INSERT INTO yby_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Sakoya nomudauniyoko, Jisesimamo lawaha oloti nilebokuti maya maloka liki nisilo. ");
INSERT INTO yby_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Loko liyoko, Saimoni Pitamamo noku lapeu maya yowekoko lawaha owo maya ika oko leko woko no akeloka maya molokoko, lawaha napa 153 waitiki minaboya aya owo maya hukamiye. ");
INSERT INTO yby_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Sa-okaiyoko, Jisesimamo sa-loko lo limiye: Nisiki nekewa nodenesa maya nalo. Loko liyoko, unala ipalale yuhalitaya lemo we napatemae loko ele-minudawoto nenako, emoya ekahima minane loko loka oetamune. ");
INSERT INTO yby_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Loka oetamuniyoko, Jisesimamo niseko beletimaki lawahamakiya ona moloko limiye. ");
INSERT INTO yby_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sa-noidanaki, Jisesimamo helenebokuti sinokoko lemo unala ipalale yuhasitoka soto pe limiyoko minudawo onawaya loweki makoki ibo ne. 3 Luk 5:5 6 Luk 5:6 ");
INSERT INTO yby_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nekewa nodenesa maya noko suwokuniyoko, Jisesimamo Saimoni Pitada maya loka oetoko sa-loko liye: Jonida ipala Pitao, iwekalekiya nemoda duka nimikaka niaboya, yatoka iwekalesidaya asebetoko uka nemekaka noape. Loko liyoko, Pitamamo sa-loko lo miye: We napane yamalae, emokumuya nelokaka noiboya mudanelo-minane. Loko liyoko, Jisesimamo sa-loko lo miye: Emoya wewenanelesida nodenesa beko no. ");
INSERT INTO yby_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Loko lokoko, aku sa-loko lo miye: Jonida ipala Pitao, emoya wehe loko uka nemekaka noape. Loko liyoko, Pitamamo sa-loko lo miye: We napane yamalae, emodamu nelokaka noibolawa maya ele-minane. Loko lokaiyoko, Jisesimamo sa-loko lo miye: Wewenanele yuhasida maya dowa loko nasahili obeto. ");
INSERT INTO yby_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Loko lokoko aku esewau leko loka iye: Jonida ipala Pitao, nemodamuya elokaka noihe. Loko loka oetaiboya, loweki makoki yupeka loka oetaiyoko, Pita maya uka hekaiyoko sa-loko liye: We napane yamalae, muki nesamuya ele-minane. Nemoya emodamu nelokaka noiboya ele-minane. Loko liyoko, Jisesimamo emoya wewenanele yuhasida maya dowa loko ujapa lalo nesa obeto. ");
INSERT INTO yby_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wehe loko lo imituyo, ele-mino, Emoya omutoko we owahaya minadanaki, ohakalo ebekaya jekoko anu yaloka maloka wetuwe loko ata kedawotokaya aha wokaka adawo maya ne. Ito iloho moloko adeka apu oko minadeko, we makolimo asako ebeka maya adekalo jekoko yaloka wametubo nesa liye loko letadawotoka aha ilime-loko woko niseko ekolaiye. ");
INSERT INTO yby_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Loko Jisesikaho Pitaya yoho yaha yalo nohelideko, Omaimidana uliwa maya lena etiye loko koha moloko liye. Loko lokoko aku esewau leko nemesalo moloko niso, loko liye. ");
INSERT INTO yby_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Loko lokaiyoko, Pita maya Jisesikaho le wili jeko weuna nimibo we nemodaya muda-nelaiye. Nemoya nodenesa nudawo yupeka maya Jisesida amaitoka minoko we napane yamalae, ekahimamo mimi etibokumu nolane loko lobo we maya minobo nenako, ");
INSERT INTO yby_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pitakahoya nemokumuya Jisesida loka oetoko maya weya nenaha etibo ne loko liye. ");
INSERT INTO yby_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Loko loka iyoko, Jisesimamo emoya aha nedeko nemoya aku le wili jituwe loko letuboya emoya nenahamu nolane. Emoya aha nemeke moloko niso. ");
INSERT INTO yby_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Loko libo galimoya muki ebakuka maya hutili oko moniyoko, wewenalale yuhamasiya helametibo ne liki eleboya, Jisesi maya yamidana gaya lamidanaki, emoya woko nedeko nemoya aku le welepa jituwe loko letuboya, nenahamuya nolane loko liye. ");
INSERT INTO yby_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ito nemoya aya nesa maya mudako le soto molokoko luhuwa maya nojoe. Sa-iboya lemo mukilitaya aya nesaya wehe loko nesa ne loko ele-minune. ");
INSERT INTO yby_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ito Jisesikaho oko moloko ibo nesaya nena weuteloti jeko suwetune. Aha nenako lemo ma jeko suwudawoto minatidanako, nemo nata koboya maya mikaukaya woko maya suwametine. 20 Jon 13:25 ");
INSERT INTO yby_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyopilasiyo, omutoko luhuwa je emoboya Jisesikaho omutoko yowanu libolawa ito api-napi oko le-loko wiboya le suwidanaki okulumau yowibolawakiya je emobo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Okulumauya owaha yowamoko aposolola lolo itae loko dilipe eto ibo wesidaya lamedalaki weuna oluholimo libotoya yowanu gaya lo biye. ");
INSERT INTO yby_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yalo yoweko miluma eleko helenebokuti sinokoko aha omuda le-minoko maya ne liki eli wehe litae loko muki elewole nesa lolo noidanaki onawa we lowesida di dade suwiyoko soto peika suna oika noidanaki Omaimidana oholamu lo beko ne. ");
INSERT INTO yby_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sakokoya alikaya edimoki magoina nedanaki sa-loko lo biye: Edimoya Jelusalemu numutoya enemane iki hulamiki ahonekaho weuna oluhola oli hituwe loko liyoko lo libobo wemuya ewa iki minalo. ");
INSERT INTO yby_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jonikahoya aha noku udobetokaka ibo maya neboya, ahonekahoya onawa hana minamoko weuna oluholoti noku udolibetakolaiye loko lo biye. 1 Luk 1:1-4 4 Luk 24:49 5 Mat 3:11; Mak 1:8; Luk 3:16 5 Jon 1:33 ");
INSERT INTO yby_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yu makoya li esa ikiki Jisesidama sa-liki loka itae: We napatelika, duliki we omutiki lemotoka ujapa ikaka abomidana oko oloti onawaloya uliki we lolo okoko lemo Isilaelo wewenasitokaya ujapa etape. ");
INSERT INTO yby_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Liki layoko Jisesimamo sa-loko lo biye: Ujapa olibetatubo onawaya ahonekaho eimola elewoleyalalo molo eleko hanahe ito minawahe loko eimola lo hukaibo maya nenako, edimoya ma elamikilae. ");
INSERT INTO yby_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sa-oneboya malokaya elikilae. Omaimidana weuna oluholimoya edimotoka lemeko elewoleya maya libekadeko, api iki Jelusalemu numutokaya ganewaya likiki yalotiya Judiya ebatoya ito Samaliya mikauka wiki likadeko, muki maya mikauka ho yowokuka ho limibokuya liki suwikilae loko lo biye. ");
INSERT INTO yby_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sa-loko lo bekoko okulumau noyowiyoko, muda-eliminayoko, yoweko woko limuguka maya sunaiye. ");
INSERT INTO yby_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Okulumauka yoweko suna okaiyoko, unala ipalale yuhamasiya awa hiki upalo mudatupe liki mudai-minayoko we lowe maya dupalo nesa ukulogo jikiki nisiki ");
INSERT INTO yby_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","sa-liki li beiye: Galeli ebatokati wenao, edimoya nenaha iyokoma okulumaukaya wenu-kenu niae. Jisesitipoya mudai-minayoko okulumau yowibomidana oko alikaya nisekolaiye liki li bikiki wiki tolowa aiye. ");
INSERT INTO yby_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sa-okaiyoko aposolo maya Oliwi ya bolauti maya 1 kilomitaya limikiki wiki Jelusalemu numuto maya hetikiki, ");
INSERT INTO yby_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","numuda mupilalo mako viminabokuya minikaka i-minabo nenako, aya numuku yowiki minae. Aya wewenasida dulinipoya, Pita, Joni, Jemisi, Endulu ito Pilipi, Tomasi, Batolomiyu, Matiyu, ito Alopiyasida ipala Jemisi mako, ito Saimoniya Lomu gamanimidana oli hekolo sa-ibo we ito Jemisi makomidana ipala Judasi. ");
INSERT INTO yby_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yatoka wekiya Jisesida unala makokiya, Jisesida dola Melemaki ito Mele makokiya mulunipo moli makokoto molikiki Omailoka likaka ae. 8 Mat 28:19; Mak 16:15; Luk 24:47-48 13 Mat 10:2-4; Mak 3:16-19; Luk 6:14-16 ");
INSERT INTO yby_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ya yupekaya Jisesida wewenalale yuhaya 120-pala iki minaboya li esa iki minayoko, Pitamamo sinokoko sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Wewenanelita, Judasimamo le omutiyoko Jisesida adelo lebo wemamidana monawala maya lo libituyo, elilo. ");
INSERT INTO yby_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Aya wemidanaya lemokiya magoinaya monoka yowanuya lemeko mibo ne. ");
INSERT INTO yby_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Sa-iboya, aya we maya mika makoya omolu ehadaloti meina hikayoko woko ayalo maya nedanaki, madonalokatiya moheloko lemeko ohumana maya jeko potoko esewa maya jeko hululuka jiye. ");
INSERT INTO yby_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Sakoya sa-ibo ga maya Jelusalemu wewenasiya elikiki aya eba maya uliwaya edimonipo ganipoukatiya Akeledamayo liki molae. Ito lemo ateutiya olada mikae loko ne. ");
INSERT INTO yby_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ito Omaimidana weuna oluholimoya Dewitida ilime aila jekaiyoko alikaya Judasiya niseko lolo etibo nesamuya libo maya niseko soto piye. Aya nesaya Judasitoka soto pitibo nesamuya Omaitoka epoka lika nama lika abo gautiya sa-liki luhuwa ji-minabo ne: Numudala ebala maya ametokadeko numudala lapouya wewena mako minamekolaiye loko luhuwa jiye. Ito makoya sa-loko ne: ");
INSERT INTO yby_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Luhuwaya sa-liki ji-minabo nenako, we napate Jisesiya luwateuya minoko leko noiyoko, maloka wewenasiya Jonikaho api oko Jisesida noku udoetaibo onawalotiya api iki lemesalo moli-liki niwayoko Omailimoya Jisesida maya ilime-loko okulumau yowibo maya ne. Jisesima helekoko sinaibo maya emoki lemokiya magoina mudaudawo maya nenako, emokiya magoina wetome oko lo betune loko ayautiya we mako Judasida ebalalo leko yowanu litiye loko ilime eto etune loko noloe. ");
INSERT INTO yby_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Loko Pitamamo lo bekaiyoko, we lowe maya makoya uliwa Josepu uliwa lasolawaya Balabasi ito uliwa makoya Jasitasi, ito we makoya uliwaya Mataeyasida mayaki hikiki ");
INSERT INTO yby_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Omaitoka sa-liki epoka lae: ");
INSERT INTO yby_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Kee we napatelika, muluteu mudaokaka we maya minane. Judasi maya aposolo yowanu maya hulikoko helekadanaki eimola etatibo ebatoka maya wiye. Sa-okaiyoko emokaho yowanula epalo litiye loko letadawo we maya lilipo. ");
INSERT INTO yby_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Liki likiki ulinipo maya luhuwa jiki li nupa iki molinitiki nisiki li nupa iki miniki li sawa jiki Mataeyasida uliwa maya minokaiyoko aposolo yowanu maya me. 18-19 Mat 27:3-10 20 Sam 69:25; Sam 109:8 22 Mat 3:16; Mak 1:9; Luk 3:21 ");
INSERT INTO yby_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Juda wewenasida esenipo vobetaibo holi onawa maya suwokoko onawa 50 oko wokaiyoko, holi onawa makoya nisiyoko, Jisesida emesalo molabo wewena maya numuda makomaloya li esa iki minayoko, ");
INSERT INTO yby_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","okulumauti elewole lasi onowa alinaliya lemekoko aya numuku maya yoweko mino waitiye. ");
INSERT INTO yby_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Sa-okadanaki jo ulumakidana nesa mako soto pekoko makoko makoko oko madonipolo maya mino-loko wokaiyoko, ");
INSERT INTO yby_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Omaimidana weuna oluhola maya lemeko dukau maya mino waitoko ayamidana elewoleya bekaiyoko aito aito dono jiki ga maya lae. ");
INSERT INTO yby_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sa-iboya aya onawaloya Juda wewena monokanipoki wewenaya wavu-liki aito aito ebatokatiya nisiki aya ebatoya li esa iki minabo ne. ");
INSERT INTO yby_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sakiya minayoko gugu loko okulumauti limibo nesa mayamidana onowa elikiki ito aito aito dono jiki monoka li bebo nesa maya mudaikiki enonipolo je molaiyoko aiye wuye liki sa-liki lae: ");
INSERT INTO yby_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ga wetome niabo weya Galeli ebakuti wegoya minaboya, ");
INSERT INTO yby_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","edimoya nenaha ikiki lelimote gateutiya ga wetome iki li nilemeyoko noelune. ");
INSERT INTO yby_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Lemoya Patiya wewena minudawo, ito Midiya wewena minudawo ito Ilamu wewena minudawo ito Mesopotamiya wewena minudawo ito Judiya wewena minudawo ito Kapadosiya wewena minudawo ito Potu wewena minudawo ito Esiya wewena minudawo, ");
INSERT INTO yby_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ito Pilakiya wewena minudawo ito Pamapiliya wewena minudawo ito Ijipi mikau wewena minudawo ito Libiya mikaukati Sailini wewena minudawo ito Lomu ebatokati wenoka wewena minudawo Juda wewenasitokaya monokamu iwenipole nisiki edimotoka kolabo wewenaki ");
INSERT INTO yby_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ito Kiliti wewena ito Alabiya wewenakiya lemo sakoya wewena minudanaki Omaimidana oliwaki nesa elewoleyawaya sakiya onoteuti onoteutiya layoko elune. ");
INSERT INTO yby_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Liki likadanaki, topa iki data etipa kikiki li-lili moniki sa-liki lae: Agae, maya nenahama niae. ");
INSERT INTO yby_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Liki layoko malokasiya dupalo hapalo ga liki nei no maya nikiki madonipouka opa napa okaiyoko moniki nei gaya nilae liki lae. 1 Liv 23:15-21; Dut 16:9-11 ");
INSERT INTO yby_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Liki likayoko, Pita maya iwelale 11-palamakiya sini-minayoko ga napauti sa-loko lo biye: Jelusalemu eba aholalikaki ito Juda wewena malokakiya nemo wehe loko wati gaya lo libituyo, elilo. ");
INSERT INTO yby_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Edimoya lemodamuya liwe no maya nikiki madonipouka opa okaiyoko moniki nilae liki nilaboya, ho maya owaha tomaya noyowinako sipaki onawa minamiye. ");
INSERT INTO yby_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mayamidana nesamuya Omaimidana epalauti ga lokaka we Joelokaho luhuwa jibo nesa maya nise poto piye. Sa-loko luhuwa jiye: ");
INSERT INTO yby_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Omailimoya sa-loko lone: Minoko onawa napa suwetibo yupekaya weune oluho maya muki numuto namato wewena libekoyoko, awotipolemotasidaya Omaimidana epaloti gaya li nimoladeko we owahasiya wamokidana nimudadeko we ilohosida wamo hemo domudalo moloyoko wamo mudakilae. ");
INSERT INTO yby_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ito aya yupekaya nemo weune oluho maya nemo elekele wewenasida maya le ohebetoyoko wetome itae. ");
INSERT INTO yby_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ito okulumaloka mikaloka oliwaki ane muki dilipoyoko mudakilae. ");
INSERT INTO yby_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mikaukaya olada joki jokilakiya soto pekolaiye, ito okulumalo towaya homidana omudaloya lubu jitibo ne. ");
INSERT INTO yby_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sa-okadeko we napamidana uliwa li-minatabo wewenasida maya dilimekoloe loko liyoko Joelomamo luhuwa jibo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Isilaelo mikau weinasi, gaya lo libekoloyo, elilo. Naseleti numutokati we Jisesi maya edimo luwawatipou minokadanaki, Omailokati ne liki litae loko Omaimo he elowo oetaiyoko abuha-wowolalo molo elenedanaki oliwaki nesa mukiya le soto piye. ");
INSERT INTO yby_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sa-ibo maya neboya, Omailimoya hapa molo hukaidanaki elibo nesa leko dadetipouya molokaiyoko edimosiya layoko ulalalo wesiya ilimi-liki wiki yoho yaha yalo kohayoko heliye. ");
INSERT INTO yby_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sa-ikaboya ono molikakaku maya netibo nesa lamiyoko miluma eleko helenebokuti maya Omailimo aku ilime sinaiye. ");
INSERT INTO yby_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Sa-iboya, Jisesida gala maya Dewitikahoya luhuwa sa-loko jenebo maya ne: Nemoya we napamidana muda-elo isulu heko minokaka noe. Sakoya woko opa okatuwe loko nade lamawakaloka ne. ");
INSERT INTO yby_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yamuya muluneuya lahelepa noidanaki ohatama noiyoko noloe. Ito saina makoya nupanemu makoko elekoko oli nimideko minakoloe. ");
INSERT INTO yby_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nuka laloki welika, nukane nuwama woko lilitamideyo. Weuneya oloha numukuya hulonetamo. ");
INSERT INTO yby_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Elewole nepa mutiwa litubo anuwa nilipedawolika, owisakaloya muluneu ohatama iyoko minakoloe loko liye. ");
INSERT INTO yby_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Done ahonelika, lemo latate Dewitidamuya le wehe loko lo libituyo. Dewiti maya heliyoko molitabo alewa maya olotiya aha neyoko mudaikaka niae. ");
INSERT INTO yby_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Omaimidana epaloti ga lokaka we maya neboma helekaiyoko Omailimo nemo unanele ipanele yuhauti yowanune epaloti we napane lolo oetatuwe loko elewole oko lo hukaibo ga maya Dewitikaho elekadanaki, ");
INSERT INTO yby_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","olisauti lilimitiye loko lo mololetaibo weya aleuti sinatibo gamuya elekadanaki ukala laloki we maya ukala lilitokatiye loko helebo wewenasida ebaku maya weuna huloetamibo ne loko liye. ");
INSERT INTO yby_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Sa-inako, Jisesida maya Omailimo ilime sinaibo maya lemo lomuda ihilawaloti muda-minudawo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ito Omailimoya ade lamawakaloka ilime molokadanaki aholakaho eimola lo moloetaiboto weuna oluhoya mekaiyoko aya weuna oluholimoya lemeko lilime sahu okaiyoko oloti maya ganehenaya eliki minae. ");
INSERT INTO yby_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ito Dewitiya okulumau yowamiboya, gahena sa-loko lone: Yowau welimoya nemo we napanemidana maya sa-loko lo miye: Nemo nadene lamawaka mino-loko woko minadeko, ");
INSERT INTO yby_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ulakalo wesida maya ika heumauka hulobetoyoko minakilae, loko liye. ");
INSERT INTO yby_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Sa-onebo neyo, muki Isilaelo wewenalitaya, elewole iki elilo. Aya weya kohaikayoko helibo we Jisesi maya we napate olisauti lilimitiye loko lo mololetaibo we netiye loko Omailimo ilime eto onebo we ne loko lo biye. ");
INSERT INTO yby_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Loko liyoko, milumanipo elikadanaki Pitale aposolo malokamaki loka ibitiki wewenatele yuhase, lemoya nenaha etune. ");
INSERT INTO yby_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Liki layoko Pitamamo sa-loko lo biye: Omailimoya lihimatipo hulobetatiye liki maya lahelamibo weutipo molabolawa maya eke liki aku hulalo. Sa-ikadeko lemokahoya Jisesi Kalaestida uliwaloya noku udolibetokuniyoko, Omailimoya weuna oluhola maya libekolaiye. ");
INSERT INTO yby_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Edimoki ito oluhotipolekiya magoina hetoka wewenakiya lesa molobetadeko nisitabo wewena mukiya weuna oluho libekolo lo mololibetonebo maya ne, ");
INSERT INTO yby_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","loko Pitamamo lokadanaki, akuya amida meko ga mako sa-loko lo biye: Olotiya eke liki nisilo. Nei wewenasida maya demesa bikadeko Omailimo eke lolibetatiye, loko lo biye. 17-21 Joe 2:28-32 25 Sam 16:8-11 30 2 Sam 7:12; Sam 132:11 34-35 Sam 110:1 ");
INSERT INTO yby_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Sa-lokaiyoko emo galalo elebo wewena 3000 Omaimo Jisesida wewenalalesito le kolaibo wewenasida noku udibitae. ");
INSERT INTO yby_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sa-ikiki muki yupeka maya makoko aweyaha iki elikadanaki aposolosi li biki api-napi abo gahena maya elikiki aha nodenesaki ito lotisapakiya niki miniki Omailoka likaka ae. ");
INSERT INTO yby_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sakiya minadanaki aposolomasi muki elewole ganehena maya lolo iki oliwaki nesahena maya lolo ikayoko nenako, muki wewena maya domodanipo adoha wiyoko minabo ne. ");
INSERT INTO yby_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Elewole iki elebo wewenasi nesanipomamu muki lemo nesate liki li-minadanaki, ");
INSERT INTO yby_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","uvaminanipohena malokaya liki wiki maketilo molikadanaki ehada likiki uvaminanipo minamibo wewenamakiya ona moliki li yolalo malo ikadanaki, ");
INSERT INTO yby_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","muki yupekaya obohanipo makokoto moliki muki yupekaya monoka numuda napau monoka liki ito numudanipouka nodenesaya aha nodenesaki lotisapaki niki duka li makokoto moliki minadanaki, ");
INSERT INTO yby_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Omaimidana epoka liki minikaka niayoko, muki wewenasiya dumunipo helibo ne. Sa-iki minayoko muki yupekaya We napanipokaho maloka wewenasidaya olisauti dilimekaka noibo wewenaloya le kolobetaiye. 44 Apo 4:32-35 ");
INSERT INTO yby_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yu makoya Pitako Joniko homa le yohotoko Omailoka domuda likikaka onawa maya nisiyoko monoka numuda napau maya Omailoka lesiye liki yoweiye. ");
INSERT INTO yby_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Sakiya yowesiye liki ateto maya nisiki mudaibo maya we makoya dolakaho etaibokuti anu monamoko ilaya lahelamiyoko monoka numuda ateto minoko wewena monoka numuku yowiki limiki abo wewenasida maya ehadamu wako wako loikaka oko nebo weya neyoko mudaiye. Aya wemidanaya muki yupekaya ilimi-liki nisiki monoka numuda napamidana ateda uliwa lalo nesae loko nebotoya hulimikaka iminayoko ehada wako wako loikaka oko nebo ne. ");
INSERT INTO yby_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sakiya ilimi-liki wiki ayalo maya huliti-minayoko, Pitako Joniko maya monoka numuda napau maya yowesiye liki niaiyoko ehadamuya wako liye. ");
INSERT INTO yby_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wako liyoko, Joniko Pitakomasiya wenu niitaidanaki Pitamamo mudalelo. ");
INSERT INTO yby_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Loko lokaiyoko maya wemamo saina nimikili laihe loko lokoko epalauwa no mikili okoko wenu delaiye. ");
INSERT INTO yby_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Sa-noiyoko Pitamamo sa-loko lo miye: Ehadaya lemotoka minamiboya, saina makoma lemotoka nebo nesaya emesiyo, Naseleti numutokati we Jisesi Kalaestida uliyeloya sinoko anu moloko wo. ");
INSERT INTO yby_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Loko nolidanaki adela lamawakaloka maya leko ilime sinaiyoko enemane oko ilauka ito ila hutanauka maya elewole iyoko ");
INSERT INTO yby_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","sinokoko eko hehe omo woko Omaimidana maya epoka lomo woko Pitako Jonikomakiya magoina monoka numuda napau maya yowe. ");
INSERT INTO yby_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Sa-okaiyoko anu nomonidanaki Omaimidana epoka noliyoko muki wewenamasiya muda-elikiki, ");
INSERT INTO yby_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","omutoko maya monoka numuda ateda uliwa lalo nesae loko neboto minoko ehada wako wako lokaka ibo we maya nehe liki ila maya petoko lalo ibokumuya elikiki agae liki lae. ");
INSERT INTO yby_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Aya wemamo Pitako Jonikosida maya dadelo liyoko muki wewenamasiya monoka numuda napa numuda yawago nebotoya Solomonidae liki laboto maya lolosa jiki wiki li esa ikadanaki depa maya limiyoko nenako, ga lamiki minae. ");
INSERT INTO yby_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Sa-niayoko Pitamamo mudaidokoko sa-loko lo biye: Isilaelo mikauka wese, maya wemidana muda-elikiki opa-napa gaya nilaboya, lemote abuha-wowoteloti ito elewoleyateloti ilime sinamuniyo, wenu lelamilo. ");
INSERT INTO yby_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Latate Aebalahamule, Aesikile, Jekopulesida Omainipomidana elekele ipala Jisesida abuha-wowola maya soto piyokoya mudae. Uliyaki we Paelatimamo Jisesida maya esewa voetatuwe loko noliyokoma, edimomasiya Paelatida omudalalo maya kohatae liki likiki muda-eli aha nesa lolo ikiki imi wesida dadeu maya molae. ");
INSERT INTO yby_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Edimoya aya weya wehe loko nebo we ukala laloki we maya muda-eli aha nesa lolo ikadanaki, wewenasida kohabo we maya esewa vikiki, ");
INSERT INTO yby_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","aha minokaka aholada maya kohaikayoko heliboya, Omailimoya helenebokuti maya ilime sinaiyoko mudaudawo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sa-ibo maya nenako, Jisesida uliwamuya elewole oko ele-minoko ila lahelamibo wemidana maya ilime lalo oiyoko aya wemoya Jisesidamuya elewole oko eliyoko ila maya dowa liye. ");
INSERT INTO yby_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wewenanele motakuse, edimoya ujapa wetipolekiya eli wehe lamiki Jisesida maya kohaiminabo maya ne loko ele-minoe. ");
INSERT INTO yby_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Omailimoya olisauti lilimitiye loko lo mololetaibo we maya yamidana oko miluma eleko helitiye loko Omaimidana epaloti ga likaka wesida maya dilipe sahu okaiyoko luhuwa jiki li-minabo ga maya olotiya niseko ulolotiye. ");
INSERT INTO yby_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Omailimo lihimatipo le uluwitoletatiye liki maya obohatipo li wili jikiki milo. Sa-ikadeko we napalokatiya obohatipomidana nodenesalamae loko letibo onawaya nisekolaiye. ");
INSERT INTO yby_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Sa-okadeko Omailimoya lahelamibo nesauti lilimitiye loko lo mololetonebo we Jisesi maya ilime eto olibetonebo we maya oli hekadeko akuya maya mikauya lemekolaiye. ");
INSERT INTO yby_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jisesida maya okulumalimo le wasa jeko lenedeko Omailimo ma mikau nesahena aku le ohatama etibo onawauya Omaimidana epaloti ga likaka niabo wesida depa le aila jekaiyoko ga li molabo onawa maya alili okadeko lemekolaiye. ");
INSERT INTO yby_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yamuya Mosesekaho ga mako sa-loko lone: We napate Omailimoya sa-loko lone: Wewenatipolesida luwawanipoutiya Omaimidana epaloti ga letibo we nemokidana heko ilime sawa jekolaiye. ");
INSERT INTO yby_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Sa-okadeko aya Omaimidana epaloti ga lokaka wemidana gala maya elamiki eli hulataboya Omailimo dilipe ekolaiye loko liye. ");
INSERT INTO yby_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ito Samuelo maya nebototi Omaimidana epaloti ga likaka we mini-liki nisebo wewenaya oloti maya onawamuya ohuwa hukiki likaka abo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sa-ikaka i-minabo maya nenako, edimoya Omaimidana epaloti ga likaka wesida dinipouka minayo, ito Omailimoya latatipolesitoka lo molaiboya edimokumuya libo maya ne. Aebalahamudaya sa-loko lo miye: Awoka makolimoya muki numuto namato wewenasida lusa vobetakolaiye loko lo miye. ");
INSERT INTO yby_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Omailimoya elekele ipalada maya ilime eto okaiyoko lusa volibetokoko anu lahelamibokuti maya dilipe anu lalotoka molatiye loko lemo Juda wewenasitokaya omutoko oli henebo maya ne, loko liye. 13 Eks 3:15 14 Mat 27:15-23; Mak 15:6-14; Luk 23:13-23; Jon 19:12-15 22 Dut 18:15, 18-19 25 Jen 22:18 ");
INSERT INTO yby_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitako Joniko maya sa-liki ga li biki minaiyoko, Omaitoka jokila hi mikaka wehena ito monoka numuda napau ujapa wehena ito Sediyusi wewenahenakiya minaibotoka nisedanaki, ");
INSERT INTO yby_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","wewenasida maya Omailimo Jisesida maya helenebokuti ilime sinaibomidana oko maloka wewenasidaya dilipe sinakolaiye liki li biki api-napi ibiki sa-ibo nesamuya elebo maya wehe lamiyoko, ");
INSERT INTO yby_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","saboya alo lubu jekaiyoko nenako dadelo liki aijogo obi yowanu lebetatune likiki li nala numukuya molae. Sa-ikayoko numuda makoko udaiboya, ");
INSERT INTO yby_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","edimo ganipolo eliki demesalo molabo weya 5000 minae. ");
INSERT INTO yby_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sakiya nala numuku hulibikiki udiminayoko, go maya lokaiyoko Juda wewenasida ujapa wenipoleki ito wewena loidawahena ito monoka monawa api-napi libikaka wehenamakiya, ");
INSERT INTO yby_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Omaitoka jokila hi mikaka abo we napawaya Anasi ito Kaiyapasi ito Joni ito Eleksenda ito asaiki Omaitoka jokila hi mikaka abo yuha malokakiya Jelusalemu numutoka maya li esa iki minadanaki ");
INSERT INTO yby_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","aposolosida maya dilipi luwawanipou molikiki loka ibitiki we ekahida elewoleyalalo ito abuhalaloya jigi i-miniki maya wemidanaya ilimi haka lae. ");
INSERT INTO yby_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Liki layoko Omaimidana weuna oluholimoya lemeko Pitada madonau maya waitoneyoko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Donelika, ahonelika, edimoya ila lahelamibo we maya nenaha okoko ito nena-nenakoma ila lalo iye liki lemodaya oloti maya saina lolo oibomuya loka nilitaboya, ");
INSERT INTO yby_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","edimoki ito muki Isilaelo mikauka wewenakiya magoina lo libekoloyo, elilo. Naseleti numutokati we Jisesi Kalaestidama edimosiya yoho yaha yalo kohaiki teyoko Omailimo ilime sinaibo wemidana elewoleyalaloya oloti maya weya lalo tekoko edimo domudaloya sinone. Sa-oneboya, monoka bukuguya luhuwa mako sa-liki ji-minabo maya ne: ");
INSERT INTO yby_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Numuda vikaka wesiya ehada napa mako mudai hulabolimoya numuda ahodawa lolo okoko sinone liki luhuwa ji-minabo maya ne. Liki luhuwa ji-minabo maya nenako, edimoya aya numuda vikaka weya minanako, Jisesida maya asehawa ahoda ne liki muda-eli hulabo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Muki numuto namato wewenauti huka limitibo we mako minamiye. Ito emo uliwaloya woko dowa letudawo nesa ne, we mako ma mikaukaya minamiye, loko liye. ");
INSERT INTO yby_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sa-iboya Pitako Joniko maya domoda wamiyoko li akutiki gaya likaiboya, maya sukulu lamaibo we maya minainako likiki agae liki Jisesida amaitoka minaibo wemasiya sainae liki lae. ");
INSERT INTO yby_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sa-inayoko, ilimi dowa laibo we maya minaibotoka nonisiyoko, we lowesida donoto liki ga litabo maya minamiyoko ohu je. ");
INSERT INTO yby_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Sakiya ohu jikiki le nupa okaka numukuti maya aya we lowesidama dilipi hetoka hulikiki edimonipogoya sa-liki wetome iki minae: ");
INSERT INTO yby_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Maya we lowesidaya nenahama obetatune. Edimosiya oliwaki nesa likaiye liki muki Jelusalemu numutoka wewenasiya eli suwikanako, lemoya nenaha oko le yuwawa moloko sakoya minamiye loko letune. ");
INSERT INTO yby_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ito aya ga maya woko napa okadeko muki wewenasiya elikatae liki Jisesida uliwalo ga maya wetome amisaiye loko data letune likadanaki, ");
INSERT INTO yby_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","akuya ju likiki Jisesida uliwalo nesa maya lolo-halo iki api-napi libitamisaiye liki data likayoko, ");
INSERT INTO yby_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pitako Jonikomasiya sa-liki li beiye: Edimoya ga maya eliki maloka mudalo. Wewena edimo gatipoya elekoko Omaimidana gala ele hulasiboya Omailimo dowa loko ne loko letibo nehe. ");
INSERT INTO yby_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mudako, eleko noudawo nesaya lemo ma le hitamekolune. ");
INSERT INTO yby_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Liki laiyoko akuya domodanipo wetibo ga li bikadanaki, kohaidatabo anuwamuya ohu jebo maya minamiyoko akuya hulibitikayoko waiye. ");
INSERT INTO yby_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sa-iboya, aya oliwaki nesa liki ilimi haka laibo weya meleke 40 le hulaibo we nenako, aya nesamuya muki wewenasiya Omaimidana epoka likanako, kohaidatudawoya wewenasiya auha limikatae liki elikadanaki hulibitayoko waiye. 11 Sam 118:22 ");
INSERT INTO yby_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Dilipi hulikayoko hetoka limikiki wewenanipole minabotoka maya wiki Omailoka jokila hi mikaka wesi ito monoka we loidawasi labo ga maya wetome iki li bikaiyoko, ");
INSERT INTO yby_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Omailoka makoko aweyaha iki sa-liki lae: Yowau we napate emoya okulumauka ito ma mikauka ito ela nokuka minabo nesasida lolo adawo welika, ");
INSERT INTO yby_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","weuka oluholimoya gawa maya latate Dewitida lo mekaiyoko sa-loko liye: Hetoka wewenasiya depalo molokaiyoko aha nesae likiki opa napa ga nilae. Wewenasiya lahelamibo nesa lolo oetatune liki elikaboya, aha elikakawagoya ele. ");
INSERT INTO yby_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mikauka duliki we napasiya ito ujapa wesiya yamidana mamidana iki we napateki olisauti lilimitiye loko lo mololetaibo welakiya lowa he betune liki li esa ae loko liye. ");
INSERT INTO yby_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Lelaki we elekele ipaka Jisesida maya lahelamibo nesauti lilimitiboto ilime eto adanaki sabo we maya lowa hi mikili Helotile Paelatile uliwa lasola Ponitiyasi ito Isilaelo ujapa wehena ito monoka elamabo wewenahenakiya maya ebato li esa ikadanaki, ");
INSERT INTO yby_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ohatama nesa soto pitiye loko ladawo nesa muki lebo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sa-iboya, we napatelika, olite limitibo ga elekoko le akutoko lepa ulumateya le sogotokoko, ");
INSERT INTO yby_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","abuha-wowote maya lemekadeko wewenasida maya dilipe haka lokoko lamedalaki ipaka Jisesida uliwaloya oliwaki yowanuya letune loko nolune, liki lae. ");
INSERT INTO yby_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Liki Omailoka layoko minabo numuda maya momoga iyoko Omaimidana weuna oluholimoya lemeko obohanipou maya mino waitokadanaki dilipe elewole iyoko limiki Omaimidana gala maya enemane iki li akutiki li bikaka ae. 24 Eks 20:11; Nih 9:6; Sam 146:6 25-26 Sam 2:1-2 27 Luk 23:7-11; Mat 27:1-2 ");
INSERT INTO yby_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sakiya eli elewole abo wewenaya mulunipo obohanipo moli makokoto ikadanaki, muki edimo li-minabo nesahena maya imiya lamiki muki wewenasi nesae likadanaki li-minae. ");
INSERT INTO yby_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sa-niadanaki aposolosiya we napate Jisesima aleuti sinaiyoko mudaune liki ga maya wetome iki li bibi iki minayoko Omailimoya he elowo obetaiyoko, muki wewenasiya edimokumu eleboya lahelepa iyoko minabo ne. ");
INSERT INTO yby_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Numudahe mikahe ito yanala ahonipolesiya meinawa likaka adanaki liki wiki aposolosida maya beyoko maloka maya edimokuti sainanipo minamibo wewenasida maya ona moliki bikaka ayoko nenako, wewena makolimoya sainalamuya ohu jamiye. ");
INSERT INTO yby_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yamidana nesaya we mako uliwa Josepu uliwa makoya Banabasiyo liki molae, ya uliwamidana monawaya lemo gateuti dilipe etoha okaka welimoya Liwaeda awola Saepalasi mikaukati etabo welimoya, ");
INSERT INTO yby_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ya yuha mako leneboya, meinalo lekoko aya ehada maya leko woko aposolosida maya biye. 32 Apo 2:44-45 ");
INSERT INTO yby_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sa-okaiboya, we makoya uliwa Ananaeyasiyo loko nebo weya menala Sapaelasite ligi hagi ikiki ya yuha mika makoya salimi iki meinawa liki, ");
INSERT INTO yby_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","maloka maya li suna ikiki malokagoya Ananaeyasi maya leko woko aposolosida nobeko ayahasiya ludawo ne loko lo biye. ");
INSERT INTO yby_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Sa-iyoko, Pitamamo sa-loko lo miye: Ananaeyasiyo, emoya nenaha iyoko Olohalimo ukau le opa iyoko Omaimidana weuna oluhomidana suwaki lo meikoko mikakaloti meinawa malokaya le suna ane. ");
INSERT INTO yby_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Aya mikaya aha eimokaloka netibo neboya eimokalikaya ataka keko aya mikaloti salimi okoko meinawa ledawoya eimoka ehadaka maya nenako, lemokaho ma wako lamune. Yalotiya meinawa lekoko alikaya sainahena nata kekoko letuwe loko letadawo maya neboya, nenaha iyokoma aya lo molokoko yamidana nesaya lolo ane. Wewenasida suwa lo bohe lekolo Omaimidana suwa lo mekane. ");
INSERT INTO yby_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Loko nolibo epakiya Ananaeyasima moheloko lemeko mikalo maya heliye. Sakoya helekaiyoko we owaha minabolawasiya nisiki homidalotiya wasa jiki liki wiki ale jitae. Sa-iyoko aya ga elebo wewenasiya domodanipo wiye. ");
INSERT INTO yby_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sakiya ale jitikayoko onawa lasolasi minoko menala maya aya gama elamidanaki waune ma wibotokae loko ayalo maya nisiye. ");
INSERT INTO yby_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Sakoya nisekaiyoko, Pitamamo loka oetoko olo, ma mena yamalae, waukateya mikatipoloti meinawa maya ayahasi leibo nehe. Loko loka oetaiyoko, aya menamamo oo, ayahasi nenae, loko lokaiyoko ");
INSERT INTO yby_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pitamamo sa-loko lo miye: Edimoya waukateya nenaha iyoko aya nesaya Omaimidana weuna oluholimo mudametiye liki mulunau hiki lolo aiye. Sa-okaniyo, elo. Waukada ale jitabo we owaha maya atetoka yaitaya gili gili liki niniseyo, emodakiya asaiki ilimi-liki wiki ale jigitakilae. ");
INSERT INTO yby_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Loko nolibo epakiya aya mena maya lemo jeko alinaliya heliye. Sakoya helekaiyoko aya we owahamasiya yowiki mudabo maya mikaloya heleneyoko mudaikiki ilimi-liki wiki waunada ale jitabo apilaloka maya ale jitae. ");
INSERT INTO yby_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Sa-okaiyoko, muki Jisesida wewenalale ito ganipo elebo wewenamakiya domodanipo wiyoko minae. ");
INSERT INTO yby_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolosiya oliwaki nesa elewoleya aito aitomidanaya wewenasida domudalo li soto soto moliki monoka numuda napau yawago nebo eba makoya uliwa Solomoniye loko nebokuya mulunipo obohanipo li makokoto molikiki li esa ikaka ae. ");
INSERT INTO yby_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Sakiya li esa iki minayoko maloka wewenasiya dulinipo li sawa jeboya, maloka wewenasiya domodanipo wokaiyoko nenako, monoka elebo wewenasitokaya wiki omamae. ");
INSERT INTO yby_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ito muki wewenasiya elewole iki elikadanaki, we napaloka maya mini moliki minae. ");
INSERT INTO yby_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sa-ikadanaki nenako, saina jelebo wewenasida maya anulo dilipi hulayoko, Pita maya aya anulo maya nomoneko dupalo lekadekohe ito aha amamunamo auta lelokadekohe haka litae liki mokolo maya lolo ikiki aya wewenasida maya moliki dilipi-liki nisiki iwauka maya hulibitikaka ae. ");
INSERT INTO yby_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Sa-iyoko, Jelusalemu numutoka alili minabo wewenasiya saina delaibo wewenahena ito oloha dukau yowebo wewenahenasida maya dilipi-liki nisi nisi ayoko dilipe haka lo suwiye. ");
INSERT INTO yby_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Sa-niayoko Omaitoka jokila hi mikaka weki unala ipalale yuhaki ito Sediyusi wekiya mudaikiki ma yamidana sa-etudawolae liki dukau yowi hiliki depalo molokaiyoko, ");
INSERT INTO yby_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","aposolosida maya dadelo likiki li nala numuku molae. ");
INSERT INTO yby_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sa-ikayoko, nala numuku maya udiminayoko, lubuka udo heledawolawa maya we napamidana okanaki wela makolimo nala numuda atedawa maya siyekoko aposolosida maya dadelo leko lemeko sa-loko lo biye: ");
INSERT INTO yby_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Edimoya wiki monoka numuda napau maya yowiki elewole depa mutiwa liki minatabo gama li bikaka iki minalo. ");
INSERT INTO yby_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Loko lo beko doli he hulokaiyoko, nekewa maya ho maya noyowiyoko monoka numuda napau maya monoka li bikaka iki minae. ");
INSERT INTO yby_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Sa-niayoko Omaitoka jokila he mekaka ibo we napalimoya unala ipalale yuhakiya, Isilaelo wewenasida ujapa wehenaki ito monoka ujapa wehenasidakiya dilipe nupa okadanaki gahena li kohikiki aposolosida maya dilipi-liki nisitae liki imiki wesida maya nala numutoka maya doli he. ");
INSERT INTO yby_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Doli hikayoko wiki nala numuku maya mudabo maya minamayoko, nisiki sa-liki li be: Lemoya woko ateda maya etoha iki viminayoko ujapa we maya aha ateto maya neyoko ateda maya siyekoko yoweko ulau maya mudaudawoya aya wewena maya minamayoko mudaune. ");
INSERT INTO yby_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Liki likayoko, monoka numuku ujapa wemaki ito Omaitoka jokila hi mikaka wemakiya elikiki alikaya saina mako soto pitibo nehe liki datanipo etipa ke. ");
INSERT INTO yby_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sakiya nikeyoko we makolimoya niseko sa-loko lo biye: Nala numuku dilipi molabo wewena maya wiki monoka numuda napau maya monoka li biki minahao. ");
INSERT INTO yby_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Loko liyoko monoka numuda napau ujapa wemamo imiki wekiya dilipe-loko widanaki, aposolosidaya kohaidatudawoya aha wewenasiya ehadaloti kohalelikatae liki aha moletiki dadelo liki liki nise. ");
INSERT INTO yby_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Sakiya dilipi-liki nisiki monoka kanisolesida luwawanipou maya hulibitikiki Omailoka jokila he mekaka we napamamo sa-loko loka obetaiye: ");
INSERT INTO yby_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Nemoya aya monoka likaka niabo wemidana uliwa maya li bamilo loko lamobo nehe, olo. Edimoya nemo ane maya eli hulikiki Jelusalemu numutoka wewenasida maya li bikayoko aya wemidana uliwa maya hutili okaiye. Sa-adanaki, yoho yaha yalo kohabo wemidana lihimala maya lemo mupilatelo yowitiye liki nilahe. ");
INSERT INTO yby_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Loko liyoko, Pitale aposolo malokakiya onoto liki sa-liki li me: Wewenasida ganipo ele lekoko Omaimidana gala ele hulokakawa minamiye. ");
INSERT INTO yby_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Edimoya Jisesida maya kohaki yoho yaha yalo helikayoko, ahote Omailimoya aku ilime sinaiye. ");
INSERT INTO yby_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Sa-okaiyoko Omailimoya edimo Isilaelo wewenalikaya mulutipo obohatipo nimikadeko lihimatipo maya suwobetatuwe loko aya weya uliki we lilimekaka we loko ilime eto oko ilime sawa jekaiyoko, Omaimidana amaitoka ne. ");
INSERT INTO yby_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sa-okaiyoko Omaimidana weuna oluhola maya Omaimidana gala eli likaka niabolawaya bekaka noibo weki lemokiya mudako elekudanaki, ga wetome oko lo nolibune loko lo biye. ");
INSERT INTO yby_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Loko lo bibo maya depauka lalo lamiyoko aposolosida maya kohaidatune liki li hukaboya, ");
INSERT INTO yby_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Juda wewenasida kanisoletipoutiya Palasisi we mako neboya, uliwa Gameliele loko ne. Ya welimoya Mosesekaho lo hukoko libo gauti leko api-napi lobetaiyoko wewenasiya muda lalo abo we ne. Sa-iyoko aya wemamo sinokoko aposolosidaya dilipi hetoka itae loko liyoko aposolo maya limiki hetoka maya minayoko, ");
INSERT INTO yby_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","aya kanisolemamo wewenalalesida maya sa-loko lo biye: Isilaelo wese, edimoya maya wewenasida monawanipoya eli wehe liki sainahena lolo ibitalo. ");
INSERT INTO yby_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Hapa yeikalaya we mako uliwa Teudasiyo loko nebo ne. Aya welimoya nemo nulineki we napa maya minoe loko lokaiyoko, wewena 400-tipalaya emotoka wiki kolabo wewenasidaya alikaya kohaiki hulikayoko, emotoka emesalo molabo wewena maya hutili iki wikiki api iki likilabo yowanu maya hulabo ne. ");
INSERT INTO yby_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Sa-okaiyoko, alikaya Galeli ebatokati we mako uliwa Judasikahoya lulite lokaka onawalo maya sinokadanaki wewenasida maya ula moloko le omutoko lowa ga liyoko, lowa li api iki heboya aya wemidana maya kohai hulikayoko unala ipalale yuha maya hutili iki wae. ");
INSERT INTO yby_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Sa-onebo nenako, ga maya lo libekoloyo, elilo. Maya wewenasidaya hulibitadeko aha minatae. Edimoya gahena liki yowanuhena nileboya edimonipo data eliki nilitaboya woko opa oko suwekolaiye. ");
INSERT INTO yby_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ito Omaimo yowanu ga lobetonedeko nilitaboya edimolitaya sa-ikili Omaimidana yowanula maya li opa iki Omaimidana lowa hi mikatae. Sa-ikatae loko yamuya data le golotoko noloe. ");
INSERT INTO yby_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Loko liyoko, emesalo moliki aposolosida maya dilipi-liki yowiki seida oijoloti kohaidikiki Jisesida uliwa maya aku wetome iki wewenasida li bamitae liki li hukibitikiki doli he. ");
INSERT INTO yby_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kohaidiki doli hikayoko niwiki sa-liki lae: We napadamuye liki kohale-liki owate luwitibo nesa lolo ilitaboya, Omailimo eliboya dowa liye liki elikiki elowa jiki kanisolesida domudaloti maya limiki wae. ");
INSERT INTO yby_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Sakiya wiki monoka numuda napau ito numudanipoukaya Jisesidamuya lahelamibo nesauti huka limitiye loko lo mololetaibo wemidana gala lalo maya wetome-katome iki li bikigo minae. 28 Mat 27:25 ");
INSERT INTO yby_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ya yupekaya Jisesida wewenala maya hutili niayoko edimokuti Juda wewena malokaya Guliki gauti likaka wewenasiya eto menakipasida nodenesa malokaya muki yupeka ona moliki bebo maya woko kohamibokumuye liki Juda ga likaka abo wewenasida maya auha be. ");
INSERT INTO yby_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Sa-ikayoko aposolo 12-palamasiya Jisesida wewenalalesida maya ju li bikadanaki, sa-liki li be: Lemoya Omaimidana gala maya lo soto moloko lo bamoko lupatemidana yowanulago letudawoya wehe lamiye. ");
INSERT INTO yby_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sa-oneyo, yamuya edimokutiya 7-pala wesiya monokaki ito Omaimidana weuna oluholakiya dukau waitonedeko mudataboya wehe lidekoma dilipi eto ikadeko lemoya maya yowanuya buniyoko litae. ");
INSERT INTO yby_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sa-ikadeko lemokiya Omailoka lokaka ito monoka lokaka nesa maya osele-pasele lelamideko dowa loko minatune. ");
INSERT INTO yby_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Liki layoko, muki Jisesida wewenalalesiya eli lalo ikiki maloka wesida dilipi eto abo maya ulinipoya makoya Sitiweniya mulunau elewole oko eliyoko Omaimidana weuna oluholimo lemeko obohalau waitoko nebo we, ito Pilipite Polokolote Nikanolote Timonite, Palamenasite ito Nikolasi emo Enitiyoko numutokati Juda wewenasitoka monokamuye liki nisiki kolabo wewenauti we. ");
INSERT INTO yby_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sakiya yatoka weya aposolosida damaitoka hiki letiki minayoko aposolomasi dadenipoya madonipolo molikaka iki Omailoka liki dilipi eto imi wae. ");
INSERT INTO yby_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Sa-ikayoko Omaimidana gala maya hutili oko Jisesida wewenala yuha maya Jelusalemu numutoka wewenaki magoina koliki minayoko, Omailoka jokila hi mikaka wewena malokasiya Jisesida galamuya elewole iki ele. ");
INSERT INTO yby_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sa-ikayoko, Omailimoya Sitiwenida maya nasahili oetokoko elewoleya mekaiyoko, oliwaki nesa elewole aito aitomidanaya wewenasitoka moneko lolo oko ne. ");
INSERT INTO yby_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Sa-okaiyoko monoka numuda makomautiya miluma yowanuguti esenipo vibitabo wewena maya Sailini ebatokati, ito Alesataliya ebatokati, Silisiya ebatokati weki Esiya wewenakiya li nupa ikadanaki Sitiwenida maya li holo molitaboya, ");
INSERT INTO yby_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Omaimidana weuna oluholimoya ilime sahu okaiyoko monokamoya edimo ganipo maya woko aha iye. Sakiya sa-ikayoko aya ganipomamo aku niseko edimonipo kohebetaiye. ");
INSERT INTO yby_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sa-okaiyoko, wewenasitoka maya suwa omoluya hulikayoko Sitiwenidamuya sa-liki suwa gaya lae: Aya wemamo Moseseko Omaikosida maya lewo letowo iyoko elune. ");
INSERT INTO yby_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Liki likiki hetoka wiki monoka ujapa weki ito olopa napa wekiya ula molikayoko nisiki Sitiwenida maya adelo likiki ilimi-liki kanisolesida li nupa ikaka numuku maya wae. ");
INSERT INTO yby_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Sakiya ilimi-liki wikiki suwa galo wesida maya dilipi numuku molikayoko sa-liki lae: Maya welimoya monoka numudamu ito Omailimo lo hukaibo gamuya lewo letowo oko lokaka noiye. ");
INSERT INTO yby_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sa-loko makoya noliyoko eludawo maya ne: Naseleti numutoti we Jisesimamo maya ebaya le opa okoko oko moloko noudawolawa maya ito Mosesekaho luhuwa je molaibo nesa maya le opa napa ekolaiye liki lae. ");
INSERT INTO yby_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Liki likadanaki, li nupa ikaka numuku minabo wewenamasiya Sitiwenida okepauka maya mudaboya okanaki we makomidana lamedalakidana onowelaki neyoko mudae. ");
INSERT INTO yby_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sa-okaiyoko Omaitoka jokila hi mikaka wesida ujapa wenipomamo loka oetoko maya obi ga nilaboya wehe liki nilahe. ");
INSERT INTO yby_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Loko liyoko, Sitiwenimamo sa-loko liye: Donele ahonelelika, ga mako letuyo, elilo. Ahote Aebalahamu maya Halani ebakuka maya owaha wamoko aha Mesopotamiya ebakuka neyoko, Omaiya lamedalaki weya emo omudalalo soto pekoko sa-loko lo miye: ");
INSERT INTO yby_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Numudaka ebaka wewenakalesidaya hulobetokoko nemo eba mako ilipitubotoya woko minatane. ");
INSERT INTO yby_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Loko liyoko emesalo moloko Kalatiya mika maya hulikoko Halani ebakukaya woko nebo ne. Sakoya woko yaloka neyoko ahola maya helekaiyoko ale jitae. Sa-okaiyoko Omailimo libotoya aku hokeko niso liyoko hokeko lemo minudawotoka nisibo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sakoya hokeko nisekoko maya mikaya lamibo maya ne. Omailimo mika lasola mako keke mamibo ne. Sakoya oluhola etamoko neyoko, emoki awolalesikiya aya mikaya litae loko lo molobetaibo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Sakoya Omailimo ga mako sa-loko lo menebo maya ne: Awopilakalesiya mika makomaloka wiki miniki wenoka mikalo maya osele-pasele yowanu liki miluma-aluma eliki minadeko meleke 400 wekolaiye. ");
INSERT INTO yby_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Loko lokadanaki, Omailimoya ga mako kolo meko sa-loko liye: Sakoya nowideko maya miluma yowanu nemo wewenanelesida bitabo wewenasida maya obi yowanu lebetakoloe. Sa-okadeko awokalesidaya doli hi molikadeko nisiki maya mikalokaya nemoda nuline li sawa jiki monoka liki minakilae loko lo miye. ");
INSERT INTO yby_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Loko lo mekadanaki Aebalahamuda unala ipalalesitoka maya Omaimidana anela netiye loko lo hukoetaiye. Loko lokaiyoko, Aebalahamuda ipala Aesikida etaiyoko onawa maya 8-pala oko wokaiyoko aya ane maya upalo moloetaiye. Sakoya moloetokaiyoko, Aesikikahoya mino-loko yoweko Jekopuda etaiye. Sa-okaiyoko, alikaya Jekopukahoya oluhola 12-pala etaiboya lemo latatele yuha minae. ");
INSERT INTO yby_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Sakiya latatelesiya unanipo Josepuda maya ma yamidana sako minatudawolae liki dukau yowi hilikadanaki Isimalaita wewenasitoya salimi iki meinawaya le. Sa-ikayoko Josepuda maya Ijipi mikauka ilimi-liki waboya, Omailimoya Josepu woko nebotoka magoina wiki minaiboya, ");
INSERT INTO yby_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","miluma nesama le huloetokadanaki nasahili oetaiyoko muki nesahenamuya ele wehe loko neyoko, Ijipi mikauka uliki we napamamoya muda-elo lalo okadanaki Ijipi mikauka ito emo unala ipalalesitoka ujapa we napa netiye loko ilime sawa jiye. ");
INSERT INTO yby_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Sa-okaiyoko, neyoko, Ijipi mikauka ito Kenani mikauka maya nodekumu napa heleyoko, muki numuto namato wewena maya miluma napa eliki minikayoko lemo latatelesiya asaiki nodenesamuya ohu jebo ne. ");
INSERT INTO yby_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sakiya minadanaki, Josepumamo Ijipi mikauka maya nodenesa wavu-leko ne liki laboya elekadanaki, oluholalesida maya doli hiyoko leme. ");
INSERT INTO yby_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Sakiya limikiki yowiki aku lemeyoko Josepumamo nemo maya minohao, loko yatolalesida maya okepa dilipiyoko Pelomakiya aya gama eliye. ");
INSERT INTO yby_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Sa-okaiyoko Josepumamo ahola Jekopuda maya ipapalalekiya Ijipi mikauka maya limilo loko liyoko, 75-pala wewenaya leme. ");
INSERT INTO yby_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sakoya Jekopu maya woko Ijipi mikauka maya minoko heliye. Sa-okaiyoko oluholale maya aya mikaukamagoya miniki heliki suwikaiyoko, ");
INSERT INTO yby_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","onowanipo maya usiki liki nisiki Sekemu numuto maya Hemolida unalamotauti ono molikaka ehada numukuya omutoko Aebalahamu meina hibo numukumagoya ale jibitae. ");
INSERT INTO yby_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Sa-ikayoko, Omailimo Aebalahamuda ga lo moloetaiboya niseko ulolotetibo onawa maya alili okaiyoko Juda wewena maya Ijipi mikauka maya hiki hutili ae. ");
INSERT INTO yby_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Sakiya hiki hutili niayoko Ijipi mikauka maya uliki we mako ohatama soto piye. Sa-iboya aya welimoya Josepukaho oko moloko ibo nesamuya elamibo we ne. ");
INSERT INTO yby_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Sakoya ahotelesida maya dokepa jidanaki dilipe opa napa oko ahotelesiya ipa etatabo maya kohaidi hula hula ilo loko lokaiyoko nenako, ahotele dotelesiya aya oluhosida maya dilipi-liki wiki liwe ohuguka hula hula ayoko heli mina mina ae. ");
INSERT INTO yby_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sakiya sabo yupekaya Mosese maya dolakaho etaiye. Sa-iboya, oluho lalo nesa soto pekaiyoko nenako, aholada numudaukagoya suna ilimi-minayoko ukada loweki makokiya wiye. ");
INSERT INTO yby_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Sa-ikiki alikaya kohaikatae liki hetoka maya ilimi suna iminayoko, Peloda oluwamamo mudakoko neimone ipane lokoko ilime sa-iye. ");
INSERT INTO yby_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Sa-iyoko, Peloda wewenalalemasiya Ijipi ga maya li mimi ayoko ele suwokoko oko moloko ibolawa maya monokauya elewole oko ne. ");
INSERT INTO yby_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Sakoya nedanaki, meleke 40 le hulikoko Isilaelo wewenasida woko mudaidatuwe loko elekoko wiye. ");
INSERT INTO yby_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Sakoya woko mudaibo maya Ijipi we makolimo Isilaelo we makomidana nokohaiyoko mudakoko, Isilaelo wemitoka Mosesema molokoko Ijipi wemidana maya koha heliye. ");
INSERT INTO yby_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nemo wewenanelesida maya Peloda adeuti maya hipo etane loko Omailimo nilime eto onebo ne liki elitahe loko Ijipi wemamidana maya kohaiboma neboya, mudaiki eli wehe lamae. ");
INSERT INTO yby_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Sa-okadanaki udokoko go maya lokaiyoko akuya wiye. Woko mudaibo maya Isilaelo we lowemasi lowahina nileiyoko mudaidokoko data leko sa-loko lo biye, lowahina lamisaiye loko, Mawelae, edimoya ouna we minaiboya nenahamu lowahina nileiye. ");
INSERT INTO yby_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Loko lo biyoko, ada api oko lowahina leko welada kohaibo wemamo sa-loko lo miye: Emoya ekahimamo ilime ulikaki we lolo ogetokaiyoko obi yowanu leletakolo nolane. ");
INSERT INTO yby_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Sa-okadanaki, aijo maya Ijipi we mako kohaminadawo maya nenako, olotiya nemodaya asako kohanelakolo nolape, olo. ");
INSERT INTO yby_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Loko lokaiyoko, Mosese maya omodala wokaiyoko oli woko Midiyani ebakuka maya lupona oko ne. Sakoya woko yauka maya lupona oko minoko mena leko ipala lowe etaiye. ");
INSERT INTO yby_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Sakoya woko minoko meleke 40 aku le hulikoko, yu makoya woko Sainae bola iwaukaya ame mikalokaya ya yuha mako aila vonebokuti jo uluma noyowiyoko mudaibo maya ayauti maya We napamamo okanaki we lolo okoko lemeko minoko ga noliyoko, ");
INSERT INTO yby_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosesemamo ololo okoko nenaha soto nopihe mudatuyo lokoko alili nonisiyoko, We napamidana onola sa-loko soto piye: ");
INSERT INTO yby_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Nemoya lataka Aebalahamule Aesikile Jekopulesida Omainipo hapa yeikala minobo weya oloti maya aha minoe. Loko liyoko Mosese maya omodala wokaiyoko agae, lokoko mino muna oko mudamiye. ");
INSERT INTO yby_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Sakoya neyoko, We napamamo sa-loko lo miye: Ika je-minadawo mikalo yaitayaloya nisomao, lominoboto minaniyo, ikalo su yaitaya ololoha oko le huliko. ");
INSERT INTO yby_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nemo wewenanele yuha Ijipi mikauka minabo maya lahelibo lahelamibo nesa lolo nibitayoko wije nama liwa liwa iki minaboya dilipe wati amoko aha minobo onawa maya alo suwokaiye. Sa-okaiyoko olotiya aya nesauti maya dilimituwe loko nolemoe. Sa-oneyoko, emodaya olotiya Ijipi mikauka maya oli nohoyo, wo loko lo miye. ");
INSERT INTO yby_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ito emoya we ekahimamo ulikaki we lolo ogetokaiyoko lemodaya lilime obilo nomololetane liki muda-eli hulabo we Mosese maya ya aila vibokuti Omailimo okanaki wela lolo oikoko niseko soto pe mekaiyoko nenako, Omailimo ujapa we ito olisauti dilimekaka we loko oli hiye. ");
INSERT INTO yby_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Sakoya oli hekaiyoko woko wewenasida maya dilimemo widanaki Ijipi mikau maya ito no makoya laho noe loko ela noloka ito ame mikaloka ito ohunahu luwamibotoka aito aito anehena maya le soto soto moloko neyoko meleke 40 wiye. ");
INSERT INTO yby_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Sa-iyoko, Mosesemamo Isilaelo wewenasida maya sa-loko lo biye: Omailimoya lemo muki wewena luwawateutiya eimola epalauti ga lokaka etibo we mako nemokidana ilime eto olibetakoloe loko liye. ");
INSERT INTO yby_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ito ahotele maya Omaimidana monokalamuye liki ohunahu minamibotoka li esa iki minayoko, Sainae bolauka maya Omaimidana okanaki wela nebo ito wewenalale yuha minabotoka lo-loko woko niseko oko nedanaki, elewole lepa mutiwamidana gala maya lo limituwe loko liye, Omailokatiya. ");
INSERT INTO yby_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Sakoya lekaiyoko ahotelemasiya Moseseda gala maya eli hulikiki li wili jiki Ijipi mikaloka wikili data nikikiya, ");
INSERT INTO yby_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Moseseda yala Elonida maya sa-liki li me: Emokahoya aweyaha nesa mako lolo oletokadeko ya nesalimoya le omutideko aku le wili jeko Ijipi mikaloka wetune. Mosese maya Ijipi mikauti lilime-loko nisibo we maya woko opa ihe ito woko liwe hihe mudamuniyo. ");
INSERT INTO yby_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Liki likiki ya yupekaya bulumaka jakidana nesa makoya lolo iki molikiki jokila hi nimiki dadeloti lolo abo nesamuya elowa jiki minae. ");
INSERT INTO yby_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sakiya sayoko Omailimoya hulobetaiyoko, duka opa oko okulumaloka lameda lokaka nesa oliwaki nesamidana maya epoka liki minabokumuya Omaimidana epaloti ga wetome okaka welimoya sa-loko luhuwa jenebo maya ne: Isilaelo wewenalitaya, aha-namasida maya kohaidiki semeda hukiki niwa niwa iki minayoko meleke 40 wiboya, nemodaya semeda mako hukinitamabo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Edimoya omai nesatipo Molekeda numuda lasolasi mako vikiki makoya Lepanida sonohikidana lolo iki molikiki aya nesamidana weuna we maya oli meko epoka letune likiki omai nesa lolo abo maya nenako, nemokaho letubotoya Babiloni numuda maya dilipi-liki hotoka wikilae liki luhuwa ji-minabo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ohunahu minamiboto maya Omailimo Mosesedaya monoka numuda lawolawoloti sako vitae loko ilipiyoko vabo numuda maya ahotele minabotoya aha nebo ne. ");
INSERT INTO yby_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Sa-iboya aya numudaya hapa yeikala vabo numuda maya neboya, aya numudalimoya aha mino-loko niseko ahotele minaboto maya neyoko, Omailimo le omutoko hetoka wewenasida maya doli hekaiyoko, niwayoko, ahotelesiya nisiki aya mika maya likiki aya lawolawoloti vabo numuda maya Josuwalekiya liki nise. Sakiya aya numuda maya liki nisiwa nisiwa iki liki niniseyoko, Dewiti maya soto piye. ");
INSERT INTO yby_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Sa-iyoko, Omailimo Dewitida muda-elaibo maya umu helekaiyoko, Dewitikahoya monoka numudala latane Jekopuda Omaimu voetatuhe loko loka iboya, ");
INSERT INTO yby_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ipala Solomonikahoya Omaimidana numudalaya voetaiye. ");
INSERT INTO yby_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Sa-iboya okulumau yowanu wekaho wewenasi vabo numukuya minoko leko amiye, Omaimidana epaloti ga lokaka welimoya sa-loko luhuwa jibo maya ne: ");
INSERT INTO yby_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","We napamamo sa-loko noliye: Okulumauya numudane ebane maya ne. Ito maya mikaukaya aha yatoka niyakane moloko ujapa okaka noe. Sa-okaka nonako, numudaneya nakahamidana vonetokadeko wehe letiye. Ito nakaha sipaloma aso jeleko minatuwe. ");
INSERT INTO yby_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nemoya nadenelotiya okulumaki mikakiya le soto molominoe loko luhuwa jibo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ga elamabo wewena datatipo madotipo golotamibo wewenalita, ahotipole abo nesa liki Omaimidana weuna oluho maya lowa ulatipolo we lolo itikaka niae. ");
INSERT INTO yby_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Omutikiya ahotipolesi Omaimidana epaloti ga likaka wewenauti maya we makomidana esela vitabo nehe, samabo maya ne. Wehe loko nebo we maya soto pekolaiye liki labo wewenasida maya kohaidi helikayoko, aya wehe lonebo we maya soto piyoko mimi iki ilimi-liki wiki kohaikayoko helibo maya ne. ");
INSERT INTO yby_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Omaimidana okanaki welalesiya Omailimo lo hukaibo gahena maya li libebo maya mudaiki eliki emesalo molamae. 2-3 Jen 12:1 4 Jen 11:31 5 Jen 12:7; Jen 15:18; Jen 17:8 6 Jen 15:13-14 8 Jen 17:10-14; Jen 21:2-4; Jen 25:26; Jen 29:31—35:18 9 Jen 37:11,28; Jen 39:2,21 10 Jen 41:39-41 11 Jen 42:1-2 13 Jen 45:16 14 Jen 45:9-10, 17-18; Jen 46:27 15 Jen 46-1-7; Jen 49:33 16 Jen 23:2-20; Jen 33:19: Jen 50:7-13 17-18 Eks 1:7-8,22 19 Eks 1:10-11 20 Eks 2:2 21 Eks 2:3-10 23-29 Eks 2:11-15 29 Eks 18:3-4 30-34 Eks 3:1-10 36 Eks 7:3; Eks 14:21; Nam 14:33 37 Dut 8:15,18 38 Eks 19:1-20:17; Dut 5:1-33 40 Eks 32:1 41 Eks 32:2-6 42-43 Aim 5:25-27 44 Eks 25:9,40 45 Jos 3:14-17 46 2 Sam 7:1-16; 1 Klo 17:1-14 47 1 Kin 6:1-38 49-50 Aes 66:1-2 51 Aes 63:10 ");
INSERT INTO yby_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sitiweni maya sa-loko libokumuya depauka lalo lamiyoko, ");
INSERT INTO yby_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sitiweni maya Omai weuna oluholimo lemeko obohalau waitoko minokaiyoko, omudala hulo okulumauka moloko Jisesi maya Omaimidana lamedalaloya amaitoka neyoko mudakoko sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nemoya okuluma golotiyoko mudaoboya, okulumauti we uti maya Omaimidana amaitoka neyoko mudaoe. Loko liyoko datau maya oijo hiki letikiki wiki ");
INSERT INTO yby_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","apusa jikadanaki, ipiso-mapiso iki ilimi-liki numuda hetoka maya limiki ehadaloti maya nikohayoko, dupalo nesanipo maya liki ololoha iki li nupa iki we owaha mako Soloda maya iguka maya molae. ");
INSERT INTO yby_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sa-ikiki Sitiwenida maya ehadaloti nikohayoko, helekolo noidanaki Omailoka sa-loko liye: We napane Jisesi yamalae, weune maya lo. ");
INSERT INTO yby_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Loko lokoko i bola heko ju loko liye: We napanelika, maya wewenasida lihimanipoya le hulobeto. Loko noliyoko, kohaiki helikayoko Solomamo wati okoe loko liye. ");
INSERT INTO yby_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Sa-ikayoko nenako, Sitiwenida maya monoka wewena malokasiya wije nama liki liki wiki ale jitae. Saboya ya yupekaya Jelusalemu numutoka monokalo emesalo molabo wewenasida maya ulanipolo we lolo ibitayoko nenako, hutili iki Juda ebakuka ito Samaliya ebakuka wiki suwayoko, aposolo maya edimonipogo Jelusalemu numutoka minabo ne. ");
INSERT INTO yby_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sa-niayoko, ya yupeka maya Solomamo monokalo emesalo molabo wewenasida maya ulanipolo we lolo obetoko numudanipou maya yowego lemego noidanaki muki wema menama oluma ipama ililiha oko leko leme leme oko nala numuku maya hulobetomo wiye. 3 Apo 22:4-5; Apo 26:9-11 ");
INSERT INTO yby_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Sa-okaiyoko nenako, hutili iki wabo wewenasiya wabotoka maya Omaimidana gala laloya wetome iki li bimi wae. ");
INSERT INTO yby_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Sakiya wiwi ayoko, Pilipi maya Samaliya ebamidana numuda emesawa makomaloya lemeko minoko Omailimo lahelamibo nesauti lilimitiye loko lo mololetaibo we Jisesida gala maya lo beko ne. ");
INSERT INTO yby_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Sakoya lo beko neyoko, muki wewenasiya Pilipi libo galo maya emesalo molayoko, Pilipimamo oliwaki nesa elewoleya aito-aitomidana le soto soto iyoko mudaki minae. ");
INSERT INTO yby_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sa-noidanaki, oloha lahelamabolawa wewenasida dukau minabosida maya kohaidoko doli he hula hula iyoko opa napa ga liki wiwi ae. Ito dinipo nosamibo wewenahena maya dilipe lalo iye. ");
INSERT INTO yby_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sa-iyoko nenako, aya numutoti wewenasiya elowa jiki minae. ");
INSERT INTO yby_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sa-iboya aya ebatoya we mako uliwa Saimoniya weuna jelibo welimoya nuliki we maya minoe lokoko moneko Samaliya wewenasida maya dokepa jekaka iye. ");
INSERT INTO yby_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Sa-okaka iyoko nenako, muki yowiki minabo wewenasi ito limiki minabo wewenasiya epoka adoha liki sa-liki likaka ae: Omailimoya elewoleya mekaiyoko nenako, muki nesahena lolo ibo maya wehe lokogo lolo iye. ");
INSERT INTO yby_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Liki laboya, onawa hana sa-iyoko, aya wemidana oli miki emesalo molae. ");
INSERT INTO yby_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Sakiya minayoko, Pilipimamo Omailimo uliki wenipo lolo obetatibomidana gala ito Jisesi Kalaestida gala lalo maya lo bebe iyoko nenako, eliki elewole iki emesalo molikadanaki, muki we mena maya monoka noku maya udae. ");
INSERT INTO yby_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ito Saimonimamo Pilipida gala maya elekoko emesalo moloko monoka noku maya udoko Pilipida gala maya eleko emesalo molaiye. Sa-noiyoko, Pilipimamo oliwaki ganehena maya le soto mola mola iboto maya mudako aiyo wiye loikaka oko ne. ");
INSERT INTO yby_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ito aposolomasiya Samaliya wewenasiya Omaimidana gala maya eliki emesalo molikayoko elikiki Jelusalemu numutokati maya Pitako Jonikosida maya liki doli hikayoko ayaloka maya waiye. ");
INSERT INTO yby_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Sakiya wiki hetikiki mudaibo maya we napa Jisesida uliwalogo noku udabotoya, edimotoka Omaimidana weuna oluhola maya lemamiyoko mudai-minaiye. ");
INSERT INTO yby_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Sa-ikayoko nenako, Pitako Joniko dadenipo maya madonipolo molikaka iki weuna oluhola limitiye liki Omaitoka laiyoko, Omailimoya weuna oluhola maya oli hekaiyoko limiye. ");
INSERT INTO yby_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Sa-iyoko Saimonimamo mudakoko ehada lisaiye loko mudakoko leko woko sa-loko liye: ");
INSERT INTO yby_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","We makomidana madonalo nade molokoyoko Omaimidana weuna oluho limitiye liki edimotoka elewoleya li-minaibomidanaya nimiliyo. ");
INSERT INTO yby_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Loko liyoko Pitamamo sa-loko lo miye: Omaimidana abuha-wowola maya aha lemekaka noibo nesa maya neboya, emoya ehadaloti meina hituwe loko lokaniyo, emoya ehadakaki aha minoko woko latila ekolane. ");
INSERT INTO yby_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Omailimo emo obohakau mudaibo maya monoka minaminako, monoka yowanu noloibo maya lamekolane. ");
INSERT INTO yby_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Lahelamibo weuka nomoladawoya hulikoko muluka obohaka le wili jeko We napalimo lihimamu ataka noeledawo nesaya le huloeta