﻿USE sofia;
DROP TABLE IF EXISTS sofia.yaqNT_vpl;
CREATE TABLE yaqNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yaqNT_vpl WRITE;
INSERT INTO yaqNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Inim ji'ojtei, Jesukrijtota betana jume' bat a' yo'owawam team. Aapo, ini'i Labiituka'uta betana intok Apra'amtuka'uta betana yeu simriatukan. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ju'u Apra'amtuka'u, Isaak teamta yoemiakan. Ini'i intok juka' Jakoobo' teamta yoemiakan, ju'u ket Juraa' teamta yoemiaka'u intok jume' iniamak werim. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ju'u Juraatuka'u, Paarej teamta yoemiakan intok juka' Saara' teamta. Ju'u inime'e ae, Tamar tean. Ju'u Paarejtuka'u, Ejrom teamta yoemiakan, ket ju'u Aram teamta yoemiaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ju'u Aram tuka'u, Aminarap teamta yoemiakan. Ini'i intok, juka' Na'ason teamta yoemiakan, ket ju'u Salmon teamta yoemiaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ju'u Salmontuka'u, Booj teamta yoemiakan. Ju'u inia ae intok, Ra'ab tean. Ju'u Booj teame intok, Oobel teamta yoemiakan. Ju'u inia ae intok, Rut tean. Ju'u Oobel teame, Issai' teamta yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ju'u Issai' teame intok, juka' che'a yo'o ya'ari, Labii' teamta yoemiakan. Ini'i che'a yo'o ya'ari, Labii' teame intok, ju'u Uriaj teamta jubiasuka'u, juka' Salomon teamta yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ju'u Salomon teame intok, Roboam teamta yoemiakan. Ini'i ket, Abiaj teamta yoemiakan, ket ju'u Asa'ap teamta yoemiaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ju'u Asa'ap teame intok, Josapat teamta yoemiakan. Ini'i ket, Jooram teamta yoemiakan, ket ju'u Osiaj teamta yoemiaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ju'u Osias intok, Joatam teamta yoemiakan. Ini'i ket, Akaaj teamta yoemiakan, ket ju'u Esekiaj teamta yoemiaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ju'u Esekiaj teame intok, Manaseej teamta yoemiakan. Ini'i ket, Amoos teamta yoemiakan, ket ju'u, Josiaj teamta yoemiaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ju'u Josiaj teame intok, Jekoniaj teamta yoemiakan, intok jume' aamak werim. Ini'i, taewaim, juka' ijra'eliita yoemrata, bwiaraa Babiloonia' tea'u, utte'apo am tojiwako. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Iniat chukula ju'u Jekoniaj teame, Salalti'el teamta yoemiakan. Ini'i ket, Sorobabel teamta yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ju'u Sorobabel teame intok Abiul teamta yoemiak. Ini'i ket, Eliakim teamta yoemiakan, ket ju'u Asoor teamta yoemiaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ju'u Asoor teame intok, Sarook teamta yoemiakan. Ini'i intok, Akiim teamta yoemiak, ket ju'u Eliul teamta yoemiaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ju'u Eliul teame intok, Eleasar teamta yoemiak. Ini'i ket, Mattan teamta yoemiak, ket ju'u Jakoobo' teamta yoemiaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ju'u Jakoobo' teame intok, Jose' teamta yoemiak, juka' Maria' teamta kuuna. Ini'i, Maria' teame aapo ju'u Jesuj teame ju'u Krijtopo ta'eewame, a' aekan. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Junuen san Apra'amtuka'uta jiapsao naatekai, Labiituka'uta taewaimmeu tajtia, woj mamni ama naiki, ju'u yoemra nat tomti kateka, jume' yo'otu sakakame. Intok ket, Labiituka'uta jiapsao naatekai, juka' ijra'eliita yoemrata, bwiaraa Babiloonia' tea'u, utte'apo am tojiwaka'po tajtia, ket woj mamni ama naiki ju'u yoemra nat tomti kateka, jume' yo'otu sakakame. Intok ket, junak naatekai, Jesukrijtota yeu tomteka'po tajtia, intok juchi, woj mamni ama naikiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesukrijtota yeu a' yoemtuka'uta inen yeu siika. Ju'u a' aewa Maria, Jose' teamta a' kunabaeka junuen aamak ean. Intok bat naataka, kee nau am jiapsao, aapo ju'u Maria, Liojta tu'u jiapsita betana, a jita a' joa'apo aman, juka' yeu a' yoemianee'uta jaibu a' mabetlatukan. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ju'u Josee, Mariata kunawa, ini'i, Liojta bichapo tu'u yoemtukan. Taa inia betana, aapo, Mariata, ka si'ime bichapo yeu a' bwiseka, a' ju'uneiyaa i'an. Ala aapo, kaabeta a' ju'uneiyaa'po, a' su'u tojibaen. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Intok aapo'ik iniat kee tu'isi ju'uneao, achai Liojta betana ankeles, tenkupo benasia au yeu machiak, intok: ―Josee, Labiituka'uta betana yeu simria ―ti au jiiak―, kaachin eenee juka' Maria' teamta em a' jupnee'u betana. Bwe'ituk ju'u a' yoemianee'u, Liojta tu'u jiapsi betana weye. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aapo o'outa asoane. Junaka'a intok, empo, Jesuj ti jiame a' teatuane. Junuen teanee bwe'ituk juka' a' yoemrawata, ka tu'ik bem ya'ari betana, am jinne'une. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Si'ime ini'i yeu siika junuen yeu a' chupne' betchi'bo, juka' achai Liojta, senuk aet ju'uneetuaka, inen jiaka a' teuwaaka'uta: ");
INSERT INTO yaqNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ju'u beeme, a' yoemianee'uta mabetne. Intok o'outa yoemiane. Juna'a san Emanuel ti teane. Lios itomake ti jiubaeme. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Junak intoko, ju'u Josee, busakai, Liojta betana ankelejta a' tejwaaka'uta yaak. Intok juka' Mariata jup betchi'bo a' mabetak. ");
INSERT INTO yaqNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Taa ka tua emo jubekame benasi jiapsan, aapo'ik Mariata o'outa a' use'u tajtia. Junaka'a intoko, Jesuj ti jiame a' teatuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ju'u Jesus, ili jo'araa Beleem ti teaka'po yeu tomtek, bwiaraa Jurea' tea'po. Juka' che'a yo'o ya'ari, Eroorej teamta, si'ime junama'a bwiaraapo a' yo'otuko. Junak intok waate o'owim jitat ju'uneame, Maakom teaka, inime'e, ta'ata yeu we'e betana kateka, bwe'u jo'ara Jerusalen tea'u yajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Intok juname'e nattemaek: ―Jaksa aane ju'u, juriommeu che'a yo'owe yeu tomtekame. Bwe'ituk ta'ata yeu weama'a betana, aapo'ik betana chokita te bichak. Itepo inim yajilam a' yo'oribaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ju'u yo'o ya'ari Eroorej teame, inika'a ju'uneiyaakai, tu'isi ka aet yanti elaka taawak. Intok ket si'ime jume' junama'a Jerusalen tea'po jiapsame. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Junak intoko ju'u yo'o ya'ari, Eroorej teame, si'ime jume' te'opopo tekiakammeu yo'owemmeu, intok jume'e, Moiseejta nesauta, yoemrata am majtammeu nau chaaeka, ameu nattemaek jakun yeu a' tomtine'po juka' Krijto'o teamta. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bempo intok inen au jiiak: ―Jurea bwiaraa, jo'araa Beleem tea'po. Bwe'ituk seenu, ju'u Liojta betana ju'uneetuawakame inen a' ji'ojtek: ");
INSERT INTO yaqNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Empo intoko, bwiaraa Juraa' tea'po jo'ara Beleem teame, eiyaa watchisi empo maachi junama'a bwiaraapo, jume' yo'owem bichapo. Bwe'ituk senu, yo'otaka tawaneeme, ee betana yeu machine, nee betana Ijra'eliita yoemrata a' suuaneeme. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Junak intoko ju'u Eroorej teame, etbwa juname'e suawakammeu chaaek, intok ameu nattemaek tua jak weyeo juka' chokita yeu a' machiaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Junak intoko, jo'araa Beleem tea'u am bittuak intok: ―Aman eme'e sajaka, junae ili usita betana tu'isi nattemaine. Intok eme'e a' teako, a'abo nee tejwaane. Junuen ne ket aman sikaa, a' yo'orine' betchi'bo ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Inika'a yo'o ya'arita ameu teuwaaka'uta jikkajaka, jume' suawakame sajak. Junak intoko ju'u choki, ta'ata yeu weama'a betana aneka, bem bichaka'u, ame pat weyen. Junuen su, chukula, ju'u ili usita ane'epo bepa kiktek. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jume' Maakom teaka, jitat ju'uneame intok, junak, juka' chokita a' bichakai, tua alleak. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Inime'e intok, jum kariu kimukai, ili usi o'outa, a' malawa Maria' teamtamak ama bichak. Junak intoko, tonommea japteka, intok a' yo'orek juka' ili usi o'outa. Sep intok juka' beje'ewaekamta bem weiyaa'uta, etapoka intok sawai tomita, intok kopaalim benaka tattaawamta insienso' teamta, intok jita, win jubak, miira' teamta a' miikak. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chukula, tenkupo benasi ju'uneetuawakai, ka intok Eroorej teamtau luula bem nottine'po betana, bempo ta'abwi bo'ot bem bwiaarau bicha nottek. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chukula, jume' o'owim suawakame am saka'asuko, achai Liojta betana ankeles, tenkupo benasi Josee' teamtau au yeu machiak. Intok inen jiiak: ―Yejte'e, usita intok a' malawata weiyaaka, intok bwiaraa Ejipto' tea'u bicha yeu weene. Junaman intok empo tawane, in enchi tejwaa'po tajtia. Bwe'ituk ju'u Eroorej teame, juka' ili usita jariunee a' me'e betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Junak intok ju'u Josee, yejteka, waka'a ili usita intok a' malawata weiyaaka intok tukaapo, bwiaraa Ejipto' tea'u bicha amemak yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Junama'a bempo taawak, Eroorej teamta a' muke'u tajtia. Ini'i inien yeu siika junuen yeu a' yuma'ane' betchi'bo juka'a, achai Liojta, senuk aet ju'uneetuaka inen jiaka a' teuwaaka'uta: “Ejipto' tea'a betana nee, in yoemiabeu chaaek”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ju'u Eroorej teame junak, jume' susuawakame betana, jak wa'am a' eiyaawaka'uta ju'uneiyaakai, tua o'omtek. Intok si'ime jume' ili uusim, illitchim, wooi wasuktiammeu tajtia, jum jo'araa Beleem tea'po intok wate au jeela ili jo'arammetchi jiapsame, am su'a tebok. Jume' susuawakame betana, chokita jak weyeo tua bem a' bichaka'u, junae betana tejwaawaka'u, taewaita ju'uneiyaakai, am su'a tebok. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Junuen chupuk ju'u Jeremiaj tuka'uta, Liojta betana aet ju'uneetuawaka, inen a' teuwaaka'uta: ");
INSERT INTO yaqNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ili jo'ara Ramaa' tea'po, jiokot jiuwaka intok bwanwame ama jikkajituk. Ju'u jamut, Rakel teame, a' yoemiam betchi'bo bwaanan. Intok kaabeta a' jiapsi yecha'a i'an. Bwe'ituk juname'e jaibu kokkolamtukan, ti a' jiaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Taa chukula, juka' Eroorej teamta muksuko, Liojta betana ankeles, Ejipto' bwiaraa' tea'po, tenkupo benasi, Josee' teamtau au yeu machiaka, intok: ");
INSERT INTO yaqNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Yejteka, ili usita a' weiyaaka intok a' malawata, bwiaraa Ijra'eel tea'u nottine. Bwe'ituk jaibu kokkosuk jume'e, juka' usita a' me'ebaeme ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Junak intoko, ju'u Josee yejtek intok aapo, juka' usita intok a' aewata, bwiaraa Ijra'el tea'u bicha am nuk siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Taa ju'u Josee, Arkelao' teamta, jum Jurea bwiaraapo a' achaiwa Eroorejtuka'uta betchi'bo a' yo'o ya'arituka'po ju'uneakai, aman a' weenee'uta majjaek. Intok tenkupo benasi ju'uneetuawakai, bwiara Kalilea' tea'u bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Junaman yepsakai jo'ara Nasaret tea'u jo'atek. Ini'i yeu siika junuen, Liojta betana jume' ju'uneetuawakame bem teuwaaka'uta, a' chupne' betchi'bo, Jesukrijtota, nasaareenopo a' ta'eena'ati bem jiaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Junakriapo taewaimmet ju'u Joan yee babatoowame, pa'akun bweka pa'ariau siika, bwiaraa Jurea' tea'po yee majtakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Intok: ―Ka tu'ik bo'o joowamta betana emo temaine. Bwe'ituk achai Liojta betana, inim a' nesaunee'u abe yuuma ―ti jiakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ini'i Joan jiba juna'atukan, wa'a, juka' Isa'iajtuka'uta, Liojta betana ju'uneetuawaka, inia betana inen a' ji'ojteka'u: Mekka bweka pa'ariapo senuk jiawai, chaae nokpo noka'u jikkajiwa, inen jiakai: “Juka' achai Liojta, a'abo bittuanemta mabet betchi'bo, Aawas enchim jiapsim tu'utene. Juka' inim ka tu'ik su'u tojine”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ju'u tajo'ori ju'u Joan teamta atteaka'u, kameeyo boae ya'aritukan. Ju'u wikosa intok, bea tukan intok waka wo'ochim benam intok ket juyapo mumu ba'awam bwa'een. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bwe'u jo'araa Jerusalen tea'po jo'aakame intok si'ime jume'e, jum bwiaa jurea' tea'po intok jume'e, batwee Joran tea'u ka mekka jiapsame, au nau yaajan a' jikkaji betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Juname'e intok, bem ka tu'uwa ya'arim Liojtau bicha am teuwaasuko, aapo ju'u Joan, batwee Jooraan tea'po am bato'owaa simen. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Taa ju'u Joan, inime'e nasuk jume' paiseompo ta'eewame intok jume' saruseompo ta'eewame, juebenam, bato'owaa betchi'bo aman kateme bichakai: ―Ka tu'i yoemra, bakochim benasi a yee bai ta'aame, jabesa enchim tejwaak, junuen, Liojta betana, unnaa jiokot machika a'abo weyemta betana enchim ama yo'eebaane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ala eme'e ka tu'ik betana enchim emo temae'uta, tu'isi enchim jiapsa'ue a' ju'uneiyaa tebonee a' lutu'uriatuka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Intok eme'e, ka emo nasuk emo che'ewareka: “Itepo Apra'amtuka'uta betana te yeu katriam”, ti jiubaeka'eene. Bwe'ituk ju'u achai Lios, kia inime'e tetammea juni'i, juka' Apra'amtuka'uta betana, yoemrata yeu katriam tuneeme a jooa. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jume' tepwam jaibu im jipu'uwa, jume' juyam chukta betchi'bo. Intok si'ime juya, ka tu'ik tatakame, chuktawaka intok taya'atune. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Inepo ala, nee ju'u ka tu'ikut enchim emo temae'uta a' teuwaakai, ba'apo ne enchim bato'owaa. Taa ju'u, net cha'aka, chukula yebijneeme, aapo, Liojta betana tu'u jiapsi emot jiapsituaka, wepulsi tu'ik jiba emot tawaaka, junuen a' chupa'ane. Juna'a, aapo che'a nee bepa yo'otaka nesawe. Junuen inepo, kia a' bochawam in a' weiyaarianee'u juni'i, ka neu lutu'uria. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tiikom ae wij wijtawa'uta jaibu mampo jipuemta benasi machika. Intoko jume' tiikom tu'utene. Otata intok, omola a' tawaane. Jume' aapo'ik tiikom, bachiata auka'u am tojine. Taa juka' otata, a' taya'ane, tajita jiba yuu beete'po ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Junak intoko ju'u Jesukrijto, bwiaraa Kalilea' tea'a betana, batwee Joran tea'u yepsak, jumun Joanta ane'ewi. Junuen juka' Joanta a' bato'owaane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Che'a bat ka junen ean ju'u Joan. Intok Jesujtau inen jiiak: ―Ineponee ala juna'a, ju'u em bato'owaa'ea'u. Empo intoko nee su enchi bato'owa i'a ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Taa ju'u Jesus: ―Taa inien aune. Bwe'ituk utte'a, si'imeta juka' achai Liojta tu'uree'uta, itom a' chupa'ane'po ―ti au jiiak. Junak san ju'u Joan aamak eak. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aapo ju'u Jesus, bato'owaasuakai, ba'apo yeu siika. Junama'a sep ju'u teeka au etapokamta benasi aayuk. Aapo ju'u Jesus intok, Liojta betana tu'u jiapsita, wokkoita benasi ko'om weyemta, bichak, aet ko'om yejtesusekamta. ");
INSERT INTO yaqNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Junak intoko, teeka betana senu jiawai inen jiaka jikkajiwak: ―Ini'i juna'a in yoemia, in nake'u. Ae betchi'bo ne tua allea ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chukula sepia ju'u Jesus, Liojta tu'u jiapsie ju'uneetuawakai, mekka, kaabeta ane'u bicha siika. Junuen, juka' bebeje'erita, ka tu'ikut a' ji'obilaane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Woi taka taewaim intok woi taka tukaariammeu tajtia, ka ji'ibwaka ama aanek. Chukula intoko tebaurek. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Junak intoko, ju'u bebeje'eri, Jesujtau yepsak. Intok junuen, ka tu'ik a' ya'a i'aka: ―Lutu'uriapo, empo Liojta betana yoemiarituko, inime'e tetam, paan aune' betchi'bo nesaune ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Taa ju'u Jesus: ―Jum Liojta nok lutu'uriapo inen ji'ojtei: “Ka bwa'aawamtae jiba senu jiapsine, ala ketchia, si'ime Liojta betana noki weyemtae” ―ti jiaka a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Junak intoko ju'u bebeje'eri, aapo'ik, bwe'u jo'ara Jerusalen teaka, Liojta betana attearipo ti ta'eewa'u bicha a' nuk sikaa, intok junama'a, bwe'u te'opopo jikau bepa a' ja'amutuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Intok ini'i: ―Lutu'uriapo empo Liojta betana yoemiarituko, emo ko'om jimaa. Bwe'ituk Liojta nok lutu'uriapo inen ji'ojtei: Ju'u achai Lios, jume' ankelesimmet nesaune, juname'e enchi suuane' betchi'bo, bempo bem maammea enchi nu'une, junuen jita tetat juni'i, ka ko'okosi em aune' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ju'u Jesus ket inika'a a' yoopnak: ―Ketchia Liojta nok lutu'uriapo inen ji'ojtei: “Ka empo juka' em Lios achaita ji'obilaabaane” ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Juchi wee'po ju'u bebeje'eri, aapo'ik mekka jikat, bwe'u kawiu jikau yeu a' nuk siika. Intok aniat si'imekut, ka nanau machi yoemrata, intok juka' bem ujyoriawata intok eiyaawatchik ama ayukamta a' bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Intok: ―Ineponee si'imeta inika'a ne enchi a' makne, empo tonommea weeka, enchi nee yo'orineeo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Junak intoko ju'u Jesus: ―Mekka'e bebeje'eri. Bwe'ituk jum Liojta nok lutu'uriapo inen ji'ojtei: “Em achai Liojta yo'orinee intok aapo'ik jiba nok jikkajine” ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Junako ju'u bebeje'eri, juka' Jesujta a' to'o siika. Ankelesim intok au yajaka, au be'eemtat a' anian. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ju'u Jesus, juka' Joan yee babatoowamta, a' eta'ituka'po ju'uneakai, junak bwiaraa Kalilea' tea'u bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Taa ka jum ili jo'araa Nasaret tea'po taawak. Ala, jo'araa Kapernaum tea'u jo'aabaeka aman bicha siika, bwe'u jo'ara, bwe'u bau ba'a mayoat, bwiaraa Sabuloon intok Naptali'iti teaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ini'i yeu siika junuen, Isa'iajtuka'uta, Liojta betana ju'uneetuawaka, juka' a' teuwaaka'uta a' chupne' betchi'bo: ");
INSERT INTO yaqNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Bwiaraa Sabuloon intok Naptali' teame, bo'ota baweu bicha aet bo'oka'u, batwee Joran tea'po beasi, ta'ata ama yeu we'e betana. Bwiaraa Kalilea' teame, jume' ka juriom jiapsa'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ju'u yoemra, Liojta betana weyemtat ka ju'uneaka, ka machiku aneme benaeka'um, bwe'u tachiriata benasi, Liojta betana lutu'uriata ju'uneiyaatuawak. Jume' intoko bem ka ju'uneaka' betchi'bo, jiba yuu ka machiku bem kokkone'po jiapsa'um, ju'u Liojta nok lutu'uria, taji tachiriata benasi, machiku taawak, ti a' jiaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Junako ju'u Jesus yee majta taitek, inen jiakai: ―Ka tu'ik betana emo temaine. Bwe'ituk achai Liojta betana inim a' nesaunee'u, abe yuuma. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ju'u Jesus, bawe Kalilea' tea'po bwikolakut weyekai, wooim nau wewerim bichak. Senu Simoo' tean, ket Peeommea ta'eewame. Ju'u intoko senu Antej tean. Juname'e kuchureomtukan. Intok inime'e bem jite'im ba'au a' jimmaan. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Junak intok ju'u Jesus: ―Eme'e nemak katne. Inepo intok, ne ta'abwi tekilta enchim makne, ju'u inim yoemrata jiapsammeu, bem jinne'uimtune' betchi'bo ne enchim ameu noktuane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bempo intoko sep su, bem jite'im su'u tojaka aamak sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Che'a ili bichau bicha weyekai, juchi woika nau wewerim bichak ju'u Jesus. Jakoobo' teamta intok Joan teamta, Sebereo' teamta u'usim. Juname'e, bwe'u kuta kanoapo aanen bem achaiwatamake, bem jite'im tu'utekai. Junammeu ket chaaek ju'u Jesus. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Junama lautipo intok, bempo, bwe'u kuta kanoata intok bem achai ama su'u tojaka, aamak sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ju'u Jesus si'ime Kalilea bwiaraat weyen, a' yepsa'apo juriom nau yaaja'po yee majtakai. Juka' bemela nok lutu'uriata betana, achai Liojta inim a' nesaunee'u betana yeteu nookan. Intok si'imem jume' ka nanau machik ko'okoakame emo am inne'etetuakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bwiaraa Siiria' tea'po si'imeku ju'uneiyaawak ju'u Jesus. Intok si'ime jume' ka nanau maisi jiokot emo bichame au tojiwak. Ko'okoeme intok jak wanteme. Intok jume' bebeje'erita betana jiokot emo bichame, intok jume' kobapo ko'okoeka wat watteme. Intok jume' ka emo taka yekame. Jesus intok, inime'e emo ine'etetuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bwiaara Kalilea' tea'po betana tua juebenaka aamak sajak. Intok ili jo'aram Lekapolij tea'a betana intok bwe'u jo'ara Jerusalen tea'a betana, intok jurea bwiaara betana, intok batwee Joran tea'awaetana jo'aakame aamak sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ju'u Jesus, si'ime junaka'a yoemrata bichakai, ili kawiu jikau sikaa, junama'a yejtek. Junak intoko jume' a' majta'um au nau yajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ju'u Jesus intok inime'e majta taitek: ");
INSERT INTO yaqNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Tua alleenee jume' Liojta betana bem jiapsimmeu tu'ik ameu a' be'ee'uta ju'uneame. Bwe'ituk bempo, teekau, Liojta yo'otaka a' kateka'u jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Tua alleenee jume' junuen ket ka alleame. Bwe'ituk inime'e, bem jiapsi jo'anaa'uta, Liojta betana amet autuanaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Tua alleenee jume' ka emo jabeleme, bwe'ituk bempo Liojta betana bwiata ameu na'ikiarita mabetne. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Tua alleenee jume'e, tua junen jiaka, Liojta am joo i'a'uta a' joopeame. Bwe'ituk aapo junaet am anianee yuma'isi aet yeu kat betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Tua alleenee jume' yee nak jiokoleme. Bwe'ituk ju'u Lios juname'e am jiokoine. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Tua alleenee jume'e, tua junen jiaka, tu'ikut jiapsekame. Bwe'ituk bempo Liojta bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Tua alleenee jume' nau eewamta tu'ureme. Bwe'ituk bempo Liojta betana yoemiarimpo ta'eenaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Tua alleenee jume'e, achai Liojta junen tu'isi am jiapsi i'a'po aman jiapsaka, inim watem betana jiokot emo bichame. Bwe'ituk bempo teekau Liojta yo'otaka a' kateka'u bem jiapsinee'uta bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Tua eme'e alleenee enchim nee suale' betchi'bo watem betana jaana jiawaawa'ateko intok jiokot bitwakai. Intok si'ime ka lutu'uriata enchim beje'eka am nokao. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tua kaitat jain eaka alleene. Bwe'ituk eme'e, Liojtamak ama butti emou tu'ik bitne. Bwe'ituk ket jiba inien su watem betana jiokot bitwak, jume' Liojta betana ju'uneetuawaka yeteu noktuawakame, emo bepat che'a bat jiapsaka'um. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Eme'e, ju'u inim yoemrata nasuk jiapsakai, Liojta betana juka' ameu tu'ik juname'e ket a' mabettua, onata tu'ika bwa'apo a' weye'e benasia. Taa ju'u oona a' kiawaita ta'aruko kaachin juchi a sawaanaa. Jaibu kaita'po tu'ine. Ala wo'otanaa intok aet naj katnaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Eme'e inim ju'u yoemrata betchi'bo ket, tachiriata benasi mamachi. Kawit jikat bwe'u jo'aratuko, kaachin a au essone. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Intok kia kaabe tachiriata ya'ane, jitaa betuk wajiwa a' mana' betchi'bo. Ala juna'a jikat mana'anaa junuen si'imem jo'araapo aneme amet a' machine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Junuen ketchia eme'e, Liojta betana enchim tachiriata benaka jipue'uta, si'imem bichapo tu'ik enchim joa'ue a' ju'uneiyaatuane. Junuen bempo, tu'ik enchim joa'uta bichakai, enchim achai Liojta, teekau katekamta a' yo'orine. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ka eme'e juka' nesaurita Moiseejtuka'uta ji'ojteita intok kia juka'a, Liojta betana ju'uneetuawaka bem yee majtaka'uta, yeu a' tawaabaeka inim ne yebijlaa ti eane. Kannee yeu a' tawabaeka yebijlaa. Ala inepo junaka'a tua juka' a' teuwaa'uta, in ya'anee'ue a' chupa'abaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Bwe'ituk lutula wee'po ne inen emou jiia, inim teekata intok bwiata ketun ayuka a' bitwao, ju'u Liojta betana nesauri, jita juni'i tua kaita ama yeu tawaanaa, si'imeta juka' yeu yuma'anemta a' chupsu'utajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Junuen san ju'u Liojta betana nesaurita jita'po juni'i, juka' che'a kaita teuwaa machik juni'i, ka a' nok jikkajame, intok watem jiba junaka'a majtakai, teekau Liojta yo'otaka a' kateka'abichapo, juna'a che'a kaita teuwaane. Taa ju'u, si'imem nok jikkajame intok watem jiba junaka'a majtakai, juna'a, Liojta yo'otaka a' kateka'abichapo che'a eiyaanaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bwe'ituk inen ne emou jiia, enchim ka jume' Moiseejtuka'uta betana nesaurim yee majtame bepa intok jume' paiseompo ta'eewame bepa che'a tu'isi Liojta ea'po aman ka enchim jiapsao, kaachin eme'e, Liojta kateka'u lutu'uriane. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Eme'e a' ju'uneiyaa, che'a bat naatakai enchim yo'owasuka'ummeu inien: “Ka jissu'abaane, bwe'ituk jabe juni'i yee su'ari, ya'uraa bittuanaa”, i ameu a' jiuwaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Taa inepo nee inen emou jiia, jabeta juni'i, ale benasi yoemtamak a' o'omteko, ini'i, Liojta betana ya'uraa bittuanaa. Ju'u intok, juka' ale benasi yoemta tua jaana, ka tu'isi au a' nokao, inim ya'uraa bittuanaa. Ju'u intok, ale benasi yoemta, ka suawa'ara, ti au jiakame, jiba yuu taji beeteu a' yebijnee'u au chupiatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Junuen san beja, empo Liojtau bicha em na'ikiarita te'opou a' toji'isekai intok junama'a empo, senuk ele benasi yoemta jita'apo juni'i ka emak a' tu'iriaka'u waate'eteko, ");
INSERT INTO yaqNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","juka' Liojtau bicha em na'ikiari, jiba junama'a te'opopo a' su'u tojinee intok junae ele benasi yoemtamak bat emo tu'utene. Junak empo a te'opou nottinee intok juka' Liojtau bicha em na'ikiarita ama a' mabet tebone. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Senuk enchi a' beje'eeo intok enchi a' ya'uraa bittuaseko, ketun aamak weyeka aamak emo tu'utene. Junuen ka ya'uttau bicha enchi a' su'u tojine' betchi'bo. Bwe'ituk junako ju'u ya'ut, ye'e'etammeu enchi su'u tojine, intok juname'e enchi eta'ine. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tua ne lutu'uriapo inen eu jiia, juka' em wikiria'uta ka tua si'imeta enchi a' beje'etuasuko, junama'a ka a em yeu weene'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Eme'e a' ju'uneiyaa, che'a bat naataka inen: “Ka ta'abwi jamuttamak emo tu'urine”, ti a' jiuwaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Taa inepo ne inen emou jiia, jabetaka juni'i jamuttamak au tu'uribaeka a' bichakame, juna'a junaemak a' jiapsipo jaibu ka tu'isi aulatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Inien san beja, empo, batatana em pusimmea, Liojta bichapo jita ka tu'ik ya'ane'eteko, yeu am wikeka, mekka am su'u tojine. Bwe'ituk che'a tu'ine, takaapo wepulaik ama be'eeka, intok ka junuen si'ime ju'u em takaa, tajita ka tutuke'u jimmaatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Intok batatana em mamam junuen enchi am tawaaneeo, am chuktane, intok mekka am su'u tojine. Bwe'ituk che'a juni tu'ine, takaapo, wepulaik ama be'eeka, intok ka junuen si'ime ju'u em takaa, tajita ka tutuke'u jimmaatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ketchia, bat naataka inen teuwaawak: “Jabetaka juni'i a' jubiawata su'u tojibaeme, ini'i, junae betana ya'uraapo ji'osia ya'arita a' maknee'u a' utte'a”, ti teuwaawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Taa inepo ne inen ne emou jiia, wa'a a' jubiawata su'u tojame, taa junaka'a ka ta'abwiku mak ka tu'isi a' aulatuko, juna'a, a' jubiawata ta'abwiku mak au a' tu'urituane. Intok ju'u, juka' jamutta su'u tojirita jubekame, ini'i ketchia, Liojta bichapo ka tu'isi aune. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Intok ketchia eme'e a' ju'uneiyaa, jume' bat katriammeu inen a' teuwaawaka'po: “Ka a' koptaka yeu a' yuma'ariane, juka'a, achai Liojta bichapo aneka a' chupne'eti jiaka em teuwaaka'uta”, ti teuwaawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Taa inepo inen ne emou a' teuwaa, lutu'uriatune'eti jiaka enchim noka'uta, ka jita betchi'bo enchim a' noknee'u. Kia teekata juni'i eme'e ka teuwaane, bwe'ituk ini'i juna'a, Liojta yo'otaka ama a' kateka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Intok kia juka' bwiata juni'i, bwe'ituk ini'i juna'a, aapo'ik Liojta aet wokeka kateka'u. Intok kia juka' bwe'u jo'araa Jerusalen teamta juni'i, bwe'ituk ini'i bwe'u jo'ara juna'a, juka' che'a si'imem bepa yo'o ya'ari yeu a' pu'ala'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kia em koba juni'i ka teuwaaka jita lutu'uriatebaane. Bwe'ituk empo, chonim wepu'ulaik juni'i, tosaisia oo chukuisia ka a' ya'ane. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wepulsi eme'e, enchim teuwaanee'u, jeewi, oo e'e, ti jiune. Bwe'ituk ju'u inia mak naa buusti nokwame, bebeje'erita betana weye. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Eme'e a' ju'uneiyaa, che'a bat naatakai inen jiuwaka'po: “Wa'a seenu, juuka'a senuk, pusim a' ta'arutuakame, ini'i ket, pusim ta'arune. Intok ju'u, juka' senuk tamim a' ta'arutuakame, juna'a ket tamim ta'arune.” ");
INSERT INTO yaqNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Taa inepo inen ne emou jiia, juka' ka tu'ik joamta, empo ka a' beje'ene. Ala empo, juka' batatana jopemmet enchi chochonakamta, ket sekka'atana empo au kuaktene. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Senuk enchi a' ya'uraa bittuaka intok inika'a, junama'a ya'uraapo, supem enchi a' u'aabao, jume' em bepa supem intok ket a' makne. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Seenuk, pu'aktita senu kiloometrota enchi a' weiyaasao, empo naa buustia juchi junae beekisi a' weiyaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Juka' jita eu netanemta, a' mikne. Intok juka'a, jita eu reewemta, junuen a' reuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ketchia eme'e a' ju'uneiyaa, che'a bat naatakai inen jiuwaaka'po: “Juka' ee naapo jo'aakamta a' nakne. Juka' intoko enchi beje'emta a' omtane.” ");
INSERT INTO yaqNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Taa inepo inen ne emou jiia, jume' enchim beje'eme, am nakne. Jume' intoko ka tu'isi emou nokame, tu'ik ame tana a'aune. Jume' enchim omtame, tu'uwata am jooriane. Jume' ka tu'isi jaana emou nokaka intok jiokot enchim joame, Liojtau bicha am nokriane. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Junuen eme'e, enchim yo'owa Lios, teekapo katekamta betana yoemiarimtune. Bwe'ituk aapo, jume' tu'i yoemem intok kia jume' ka tu'i yoemem betchi'bo juni'i, juka' ta'ata yeu weamtua. Intok tu'isi jiapsame intok kia ka tu'isi jiapsame betchi'bo juni'i, yuyuktua. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bwe'ituk eme'e, jume' enchim eiyaame jiba nake'eteko, kaita chukula emou tu'ik ama bitne. Kia jume' yo'oraata betana tomita bem nau tojine' betchi'bo tekilta joame juni'isu ket inika'a jooa. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Intok eme'e, jume' emo mak werim jiba tetebotua'ateko, kaita tu'ik eme'e jooa. Bwe'ituk inika'a jume' ka Liojta sual ta'aame juni'isu a' jooa. ");
INSERT INTO yaqNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Eme'e, yuma'isi yee eiyaane, ju'u, juka' enchim yo'owa Lios, teekau katekamta si'imem yuma'isia am eiya'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Eme'e, Liojta sualeka a' yo'oreka juka' enchim joa'uta, ka eme'e, watem bichapo enchim bittune' betchi'bo jiba a' joone. Bwe'ituk junuen eme'e a' bo'o jooria'ateko, junak ju'u enchim yo'owa Lios, teekau katekame, emou tu'ik tua kaita enchim bittuane. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Junuen san empo jume' jiokot eame ania'ateko, ka si'imem a' ju'uneiyaatuane, jume' waate, ka lutu'uriapo emo tu'u joame, jum te'opompo intok jum naj katwa'apo a' joa'a benasia. Inime'e junuen aane junuen watem tu'ik ame tana teuwaane' betchi'bo. Taa inepo ne tua inen emou a' teuwaa, lutula wee'po junama bem eiyaanaa'u jiba, Liojta betana chukula bem bitnee'u kaitatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Taa empo jume' jiokot eame jita'apo am aniakai, taa inika'a empo, kia juka' emak jo'aakamta juni'i, ka a' ju'uneiyaatuakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ala juka' em yaaka'uta kaabe a' ju'uneiyaane. Ju'u intoko em yo'owa Lios, juka' kaabeta ju'uneiyaaka em joa'uta a' bichame, aapo, juka' chukula eu tu'ik enchi bittuane. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Eme'e intoko Liojtau bicha yee nokriakai, kaaa eme'e wame'e ka lutu'uriapo bempo emo tu'u joame benasi a' bo'o jooriane. Inime'e jum te'opopo intok jum naj katwa'apo ja'abweka, bem Liojtau bicha noknee'u a' tu'ure junuen watem am ju'uneiyaane' betchi'bo. Inepo ne inen emou jiia, lutula wee'po junama bem eiyaanaa'u jiba, Liojta betana chukula bem bitnee'u kaitatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Taa empo, Liojtau bicha yee nokria'ateko, em karipo wajiwa, pueetata eta'ika intok empola, em achai Lios junuen emak jiba anemtau bicha yee nokriane. Junako ju'u Lios, juka' kaabeta ju'uneiyaaka em joa'uta a' bichame, chukula aapo juka' tu'ik enchi bittuane. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Junuen, Liojtau bicha emo nokria'ateko, ka naa buusti kia beja nok baanee wame'e ka Liojta sual ta'aame ane'e benasia. Intok inime'e junuen, juebenak bem teuwa' betchi'bo, Liojta am jikkaji machiaka ane'e benasia. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Junuen eme'e ka juname benasi anne. Bwe'ituk ju'u achai Lios jaibu ju'unea ju'u emou be'eemtat kee au bicha enchim nokao. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Junuen san eme'e, Liojtau bicha inen emo nokrianee: Itom achai Lios, teekau katekame. Em yo'orinaa'uta eu lutu'uriatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Che'a yo'otaka em nesaunee'uta, inim itomaktune. Ju'u em joo i'a'uta inim ya'atune. Jiba junaen teekau a' joowa'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Juka' bwa'awamta jiba itou be'eemta, i'an itou autuane. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ka tu'ik itom ya'arit itom jiokoine. Junuen itom jume' ka tu'ik itou yaakame itom am jijiokoe'e benasia. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Unnaa itom ae ji'obilaanaa'uta, ka itou autuane. Ala, bebeje'erita betana itom jinne'une. Bwe'ituk ju'u che'a yo'otaka si'ime utte'ata jipueka em nesawee'u, intok ju'u yo'orisi maisi em eiyaanaa'u, jiba yuu betchi'bo eu aune. Tua junuentune. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Bwe'ituk eme'e junuen jume' waatem, ka tu'ik emou yaakame junaet am jijiokoe'eteko, ju'u enchim achai Lios, teekau katekame ket enchim jiokoine. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Taa junuen enchim watem ka jijiokoeo, ju'u enchim achai Lios, ka tu'ik enchim ya'arit ka enchim jiokoine. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Eme'e ka ji'ibwalamtaka junuen Liojta yo'ore'eteko, ka eme'e jume' ka lutu'uriapo, bempo emo tu'u joame junuen emo siokame benasi emo joame benasi anne. Bwe'ituk bempo inien aane, junuen ka ji'ibwaka Liojta bem yo'ore'po bem ju'uneiyaana' betchi'bo. Inepo ne inen emou jiia, lutula wee'po junama bem eiyaanaa'u jiba, Liojta betana chukula bem bitnee'u kaitatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Taa empo, ka ji'ibwalataka Liojta yo'oreka au bicha nokbae'eteko, emo pujbaa baksianee intok tu'isi emo chichikne. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Junuen ka ji'ibwaka Liojta em yo'oree'uta, kaabeta enchi ju'uneiyaane' betchi'bo. Ju'u em achai Lios jiba, junama'a aapola jiba emak aneme ju'uneene. Intok aapo, chukula juka' eu tu'ik enchi bittuane. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ka inim bwiapo eme'e, juka' eiyaawatchika, beje'emta, bu'uuk nau tojibaane. Inim, yoeriam a jita moiyaa'po intok jita momoyee'po intok jume' jita e'etbwame jak kimuka jita e'etbwa'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ala eme'e, teekau juka' chukula eiyaawatchika, emou tu'ik jipu'ubaeka'eene, jum yoeriam ka a jita moiyaa'po. Intok kaita momoyee'po. Intok kia jume' jita etbwawamta tu'ureme ka ane'epo. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bwe'ituk eme'e, jum enchim eiyaa'uta intok beje'emta ayuka a' jipue'po, junama'a ket eme'e junaet jiba jiapseka, aet emo temaine. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Em puusim ee betchi'bo, tachiriata benasi maachi. Junuen san, empo jume' em puusim tu'ireako, ketchia si'ime ee betchi'bo mamachine. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Taa jume' em puusim ka tu'ireako, ketchia, si'ime ee betchi'bo ka mamachi benane. Empo intoko, ju'u a' lutu'uria ti eaka em suale'u, ini'i ka mamachika ka lutu'uriatuko, jiba ini'i inien machika, juchi ae bepa jiba betchi'bo eu ka tu'ine. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Jabe juni'i, kaibu wooim tekoka nanancha a nesauta am jooriane. Bwe'ituk senuk omtaka juka' senuk intok nakne. Oo juka' senuk che'a jikkajaka juka' senuk intok ka a' eiyaane. Ket, kaabe, Liojta a' joo i'a'uta joaka intok junaewit yu'in tomibaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Junuen ne emou jiia, enchim bwa'eeka oo junuen enchim je'eeka jiapsinee'u betchi'bo, eme'e ka jain eene. Intok kia ju'u enchim tajo'onee'u betchi'bo juni'i. Ju'u jiapsiwame, bwa'amta bepa che'a eiyaawatchi. Intok ju'u takaa, ju'u tajo'ota bepa che'a eiyaawatchi. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jume' wikitchim naas nenne'eme, eme'e mammatene. Inime'e ka e'echa intok kia ka bachiata tobo tobokta, junuentaka juni'i ju'u enchim achai Lios, teekau katekame, am jiji'ibwatua. Eme'e, jume' wikitchim bepa che'a juni'i eiyaawa. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Intok emo nasuku kaabe aane unnaa jain au eetuaka juni'i, nasuk aman batata a yo'otune. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Intok enchim nat bepa ujyoik tajo'onee'u betana ka aet jain eene. Maa su ket jume' wajpo seewam yoyyo'otume mammatene. Juname'e kaita joaka ka jiji'ikame. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Taa junuentaka juni'i, inen ne emou jiia, ju'u che'a yo'o ya'ari Salomon tuka'u, yu'in ujyoik atteaka juni'i, ka inime'e watem benasi ujyoireakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ju'u achai Lios intok, juka' juyata i'an wajpo ayukamta junuen ujyoisi a' joakai, juka' chukula tajiu wo'otanamta, enchim che'a juni san aapo aniane, kaita a suale'am. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Junuen san eme'e ka jain emo eetuanee inien jiakai: “Jitasa tee bwa'ane, oo jitasa te ji'inee oo jitasa tee tajo'otene”, ti jiakai, ");
INSERT INTO yaqNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","bwe'ituk jume' ka Liojta sual ta'aame, si'ime inia weemtat jiba jiapsek. Taa eme'e juka' Liojta, teekau jiapsamta sual ta'aa, si'imeta inika'a emou a' be'ee'po jaibu ju'uneamta. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Junuen san eme'e, Liojta che'a yo'otaka a' kateka'u, juka' aamak enchim lutu'urianee'ut, iniat bat emo temaine. Intok aapo'ik junuen tu'isi enchim jiapsi i'a'utchi iniat jiapsekai. Intok ketchia si'imeta inika'a eme'e a' mabetne. ");
INSERT INTO yaqNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Junuen san, chukula taewaimmet emou auneemtat ka emo jain eetuane. Bwe'ituk juname'e taewaimmetchi aet emo temainaame aune. Ala chikti ta'apo ju'u obisi emou ayukamtat junaet jiba emo temaine. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Ka eme'e watem jita'apo ka tu'isi am tatawaane. Junuen juka' Liojta ka enchim a' ya'uraa bittuane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bwe'ituk aapo, jiba junaen enchim watem juka' ka tu'ik enchim amet a' bicha'a benasia, junaen enchim ya'uraa bittuane. Intok juka' watemmeu enchim joa'u benakue, ket junaen emou a' nottane. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Iniamak empo, senukut a' pujpo ili sankoata bichamta benasi maachi, em pujpo intok juka' sankoata che'a bwe'uuk em jipue'po ka emo mammatekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Junuentuka'ateko empo: “Juka' ili sankoata em pujpo jipue'uta, nee enchi yeu a' wikriabae”, ti kaachin a au jiune, em pujpo juka' che'a bwe'uuk sankoata jipuekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ka tu'i yoemtakai emo tu'u joame, empo bat tu'isi em jiapsinee'ut emo ju'uneiyaane, junak intok senuku tu'isi a' jiapsinee'u betana a au nokne. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Juka' eiyaawatchik, lutu'uriata Liojta betana weyemta, jume' inim tua ka tu'i yoememmeu ka inimmeu a' teuwaabaane. Chukula inime'e junuen, ka jume' chu'um juju'enam benasi, enchim am ya'ane' betchi'bo. Intok jiba inika'a, kaitau a tamachiatuka lutu'uriata, jume' tiusi, ka tu'ik tu'ureme ka a' majtabaane. Chukula, ka jume' bawepo tetam, pejlam teame, koowimmeu wo'otawaka'a benasi machika, inime'e intok amet chep cheptisune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Enchim waata'uta, Liojtau bicha a' a'aune, ju'u Lios intok, enchim a' bittuane. Intok kia juka' Liojta betana enchim jaiwa'uta juni'i, eme'e a' bitne. Maa su eme'e pueetata pona'ateko eme'e kima'anaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bwe'ituk wa'a, a' waata'uta a'auneeme a' mabetne. Wa'a intoko a' waata'uta jaiwame, a' teune. Intok kibachanaa ju'u pueetau weyeka a' poname. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Kaabe aane emo nasuku a' yoemiawata, bwa'awamta a' a'awao, tetata a' mikbaaneeme. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Oo inika'a, kuchuta a' a'awao, bakotta a' mikbaaneeme. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bwe'ituk eme'e junuen ka tu'i yoememtakai juni'i, jume' enchim yoemiam, tu'ik enchim am miknee'uta, a' ta'aa. Jiba tua ju'u enchim Lios, teekau katekame, aapo, jume' aapo'iku bicha tu'ik a'awame, junaka'a tu'ik am mikne. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Junuen san eme'e watem betana tu'ik jiba bitbae'eteko, junaen jiba eme'e tu'ik ameu joone. Bwe'ituk jiba ini'i ama weye Moiseejtuka'uta nesauri ji'ojteipo, intok wame'e bat naataka yeteu noktuawakame ji'ojteka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Eme'e, na'ulaika aet aman kikkumuwa'po, jiba yuu jiapsiwa'u bicha kimune. Ju'u aet aman kimuwame intok ju'u bo'o, jiba yuu kokkowa'u bicha bo'okame, bweeka, juebenaka intok junaet aman sasaka. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Taa ju'u aet aman kikkimuwame intok kia ju'u bo'o juni'i, jiba yuu jiapsiwa'u bicha bo'okame, tua nana'ulai, intok ka bweeka, iniet intok ka juebenaka aet aman sasaka. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Jume' ka lutu'uriata nokaka, Liojta betana emo noktuawa'ati jiame betana eme'e emo suuane. Bwe'ituk inime'e, Krijtopo emo mak werim benasi emo joaka emou yaaja, taa bempo, roobom, bwalam benasi emo ya'arikai. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Taa eme'e ju'u bem bo'o jooria'ue a amet ju'uneene. Bwe'ituk juya wichakamta, pa'asim ka a' tatakaka intok kia ju'u ka tu'i juya, chunam ka tataka'a benasia machikai. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Junuen san si'ime wa'a tu'i juya, tu'ik tataka. Intok si'ime wa'a ka tu'i juya, ka tu'ik tataka. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ju'u juya, tu'ikai, kaachin ka tu'ik tatakane. Ju'u intok, kia ka tu'i juya juni'i, kaachin a tu'ik takane. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Si'ime ju'u juya, ka tu'ik tatakame, chuktanaa intok taji beete'po taya'atune. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Junuen san eme'e, ju'u bem bo'o jooria'ue a amet ju'uneene. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ka si'ime wame'e: “In yo'owa”, ti neu jiame, Liojta yo'o nesaweka a' kateka'u a jiapsine. Ala wame'e, achai Liojta, teekau katekamta joo i'a'uta joame jiba a aman jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Junaka'a taewaita yumako juebenaka inen neu jiunee: “Itom achai, ee betana ito lutu'uriak ti jiaka, juka' em nokta te yee majtak. Intok ket junaen em team teuwaaka, jume' bebeje'erita ka tu'i jiapsim jipueme, itepo yeu am bepriak. Intok ket jiba junaen itepo juka' ka a jootu maisi machik tee yu'in a' yaak”, ti jiuneemme. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Taa inepo junak inen ameu jiunee: “Jakwoo juni'i ne ka enchim nemak ee ta'aak. Mekka em kaate, eme'e, ka tu'ik ya'alame.” ");
INSERT INTO yaqNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Junuen san wa'a, juka' in teuwaa'uta a' jikkajaka a' bo'o jooriame, juna'a, seenuk, tu'isi suawaka, junaka'a senu tetata bepa karita a' yaaka'a benasi machine. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chukula yuk taiteka jume' batwem tapunak intok jeekam aet sajak intok au a' tataptuan taa juna'a kari ka wechek bwe'ituk juna'asu, tetat kutti nawakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Taa wa'a, inika'a in teuwaa'u a' jikkajaka intok ka a' bo'o jooriame, juna'a, seenuk tu'isi ka suawaka, junaka'a se'eta bepa karita a' yaaka'a benasi machine. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yuk taiteka, jume' batwem tapunak intok jeekam aet sajak, juna'a kari intok wechek intok tua jiokot taawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Juka' Jesujta ameu a' noksuko, jume' ama aneme, aapo'ik bempo'im majtasuka'u betana a' suum eiyaan. ");
INSERT INTO yaqNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bwe'ituk aapo, senuk yo'o utte'akamta benasia am majtan, intok ka jume' Moiseejtuka'uta nesaurim yee majtame benasia. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Junak Jesujta, ju'u ili kau betana ko'om a' siiko, juebenaka aamak sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Junama intok, seenu, lepra' teamtae ko'okoeka, au ruktek. Ini'i, Jesujtau tonommea kikteka: ―In yo'owa, empo junen ea'ateko ika'a ko'okoata a nee u'aa ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Junak intok ju'u Jesus aet mamteka: ―Junen ne ea, junuentune, tu'ine'e ―ti au jiiak. Inien a' jiusuko ju'u sa'awakame, a' ko'okoa betana au ine'etek. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ju'u Jesus intok: ―Yuu, kaabetau a' teuwaane. Ala, jiba aman sika intok ju'u te'opopo che'a yo'otau yebijne. Intok Moiseejtuka'uta nesaweka'po aman, junaka'a Liojtau em na'ikiaka'uta aman weiyaane. Junuen si'imem ju'uneene' betchi'bo, em ko'okoata betana jaibu em tu'isuka'po ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jo'ara Kapernaum tea'u Jesujta yebissuseo, senu Roma' tea'a betana, sontaommeu ya'ut, Jesujtau ruktek intok inen au ujbwanak: ");
INSERT INTO yaqNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―In yo'owa, in ili uusi, jo'aapo bo'oka ka au yeeka intok ama butti jiokot a' inne'a ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus intok: ―Inepone aman sikaa, au a' ine'etetuane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ju'u sontao ya'ut a' yoopnak: ―Achai, ka neu cha'aka in jo'au em yebijne'po. Ala kia au a' ine'etene' betchi'bo, junuen a' teuwaanee jiba. Junak intok au ine'etenee ju'u in uusi. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bwe'ituk inepo ne juni'i watem che'a nee bepa nesaweme jipue. Taa intok ket nee naa buusti sontaom in sawe'um ne jipue. Juname betana senuk jakun ne a' wee saao, aman weene. Senuk intok ket, a'abo weye ti ne au jiao, juna'a neu weene. Juka' intok in jo'apo nesauta nee jooriamta jita juni'i nee a' ya'asao, ini'i a' jojoa. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Junak ju'u Jesus inika'a ae tana jikkajakai, a' suum eiyaak. Intok jume' aamak katemmeu inen jiiak: ―Lutu'uriapo ne inen emou jiia, si'ime inim Ijra'el yoemrata nasuku, inepo kee jabeta ta'aa, inia o'outa benasia, tua tu'isi Liojtat a yoem'eamta. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Inen ne, inepo emou jiia, juebenam jume' ta'abwi yoemra, mekka, ta'ata yeu we'e betana intok ket, ta'ata aman weche'u betana aman yajine'po. Intok inime'e, ju'u Apra'am teamtamak intok ju'u Isaak intok ju'u Jakoop teamtamak joteka am ji'ibwane'po jum teekau, Liojta a' yo'otaka a' kateka'awi. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Taa wame'e intoko junaman Liojta che'a yo'otaka a' kateka'u an'ea'um, inime'e, pa'akun ka mamachikun yeu tawaanaa. Intok junama'a, inime'e bwannee intok ko'okoleka emo tam kumne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Junak intok ju'u Jesus, ju'u sontao ya'uttau: ―Em jo'au nottinee intok junuen, tua em a' sualeka'a benasia ya'atune ―ti au jiiak. Ju'u intoko ju'ubwa yo'otume junama'a sep su au ine'etek. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus ket ju'u Peo' teamta jo'au yepsak. Junama'a intoko Peota jamut ase'ebwa, taji wecheka intok bo'okamta ama bichak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aapo, mampo a' bwisek. Ju'u taji wechia intok sep su a' su'u tojak. Junak intok aapo yejtek. Sep intok jita am jooria taitekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ka machiao yumakai ket juebenaka bebeje'erita betana ka tu'i jiapsim amet aneka, Jesujtau tojiwak. Aapo intok, kia sejtul ameu nonokaka si'imem yeu beebak. Intok ket, si'imem jume' ko'okoeme, emo am ine'etetuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ini'i inien yeu siika, junuen waka'a bat naataka Liojta betana chukula yeu weenemta ju'uneetuawaka nonokame, Isa'iajtuka'uta teuwaaka'uta a' chupne' betchi'bo inen a' jiaka'uta: “Aapo, juka' itom ka au yuma'uta mabetak. Intok ito betana juka' ko'okoata itom u'aak”, ti a' jiaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Junak ju'u Jesus, tua juebenam au nau yajame bichakai, bau ba'a waitana au toji nesaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Senu intoko, Moiseejtuka'uta nesauri ji'ojtei yee majtame, Jesujtau ruktek, ini'i intok: ―Yee majtame, jakun juni'i em sime'u bicha, nee emak weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ju'u Jesus intok: ―Jume' kawisim bwia woojo'oku jo'aak. Jume' intoko wikitchim totosakamme. Taa inepo, ju'u emo benasi inim yoeme, jakun in yebijnee'uta juni'i ka jipue ―ti au jiiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Senu aapo'ik majtim betana: ―Achai, nee jiokoe, in yo'owata ne bat ma'abae ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus intok: ―Nemak weene intok ela'apo wame'e Liojta bichapo ka jiapsame bebena, jume' kokkoarim ma'ane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Junak intok ju'u Jesus, jum kuta kanoapo ja'amuk. Jume' intok aapo'ik majtim aamak kaaten. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Junae bau ba'at intok, jeka tua utte'aka siika. Junuen kia jume' ba'a ro'aktiam, juka' kuta kanoata, bem ama kate'uta, pat pattakai. Taa ju'u Jesus kotchen. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Junak san jume' a' majtim, au sajaka a' busak. Intok: ―Achai, itom jinne'u, abe te ko'om kiimu ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aapo intok: ―Jaisaaka eme'e unnaa majjae. Eme'e tua ka yuma'isi Liojtat a yoem'ea ―ti ameu jiiak. Junak intok, yejteka, jekatau intok bawetau nonokak. Junak intok si'ime yanti taawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jume' intok waate o'owim a' suum eiyaaka intok: ―Ini'i intok, jaku'ubosa jometaka tua, kia ju'u jeeka intok kia ju'u baawe juni'i, aapo'ik ea'po aman aayuk ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Junak ju'u Jesus, junae bwe'u bau ba'a waitana yepsak, bwiaraa Kalaara' tea'po. Wooi o'owim, kokkoarim mama'awa'a betana au yeu sajak intok au ruktek. Juname'e woikai, bebeje'eri ka tu'i jiapsim amet aanen. Intok juname'e tua ama butti emo i'ii'aan. Junuen san junae bo'ot ka a rejtitun. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Juname'e intok chaai japtek: ―Jaisaakai empo itou suua Jesus, Liojta u'usi. Jaisa kee taewata yumao su empo itom jiokot ya'aseka a'abo weye ja'ani ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Junama'a ka mekka, koowim tua juebenaka ji'ibwan. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jume' intoko ka tu'i jiapsim Jesujtau nookak: ―Itom yeu bepbae'eteko, wame koowimmet itom kimutuane ―ti au jiiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Junak ju'u Jesus: ―Tu'i, amet em kiimu ―ti ameu jiiak. Jume' ka tu'i jiapsim intok junammet yeu sajaka intok wame koowimmet kiimuk. Chukula ket, si'ime juname'e koowim, kau siibau luula ko'om wattek ba'au ko'omi, intok junama'a kokkokai. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jume' koowim sua'um, womtilamtaka ama yeu sajak. Intok inime'e, jum ili jo'arau yajaka, si'imeta junaka'a a' teuwaa japtek. Intok ket jume' o'owim ka tu'i jiapsim amet ane'um, juka' ameu yeu a' sika'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Junak intok si'ime wa'a junama ili jo'araapo joomem, Jesujta ane'u yeu sajak. A' bichaka intok, au nookak junama'a bem bwiapo, omot bicha a' weene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Junak intok ju'u Jesus, senu kuta kanoau ja'amuka, junae bau ba'ata beasi waitana juchi nottek. Intok ili bwe'u jo'arau, aapo'ik yo'otuka'po yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Junama'a seenu, ka au taka yekaka au tojiwak. Ili jipetekpo bo'o simekai. Ju'u Jesus intok, juname'e junuen tua a' sualeme ju'uneiyaakai, ju'u ko'okoemtau: ―Kat jain ea in yoemia. Em ka tu'uwa ya'arimmete'e jiokoiri ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Junak intoko waate, jume' Moiseejtuka'uta nesauri ji'ojteim yee majtame inen emo eetuan: “Ini'i o'ou junuen jiaka, Liojta beje'eka jaana ka tu'ik nooka”, ti emo eetuan. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Taa ju'u Jesus, inime'e, ju'u bem emo eetua'uta amet ju'uneakai: ―Jaisaaka eme'e junuen tua ka tu'isi ea ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bwe'ituk jitasa che'a ka obiachi a' chupnee'uta: “Em ka tu'uwa ya'arimmet empo jiokoiri”, oo “Empo, yejteka intok weene”, ti in au teuwaanee'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Junuen san enchim ne a' ju'uneiyaa i'a, juka' inim emo benasi yoemta, inim bwiapo junuen jume' ka tu'uwa ya'arim, yetet a' jiokoinee'u au a' lutu'uriatuka'po ―ti jiiak. Junak intok aapo, ju'u ka au yekamtau: ―Yejte'e, em jipetekta nu'uka intok em jo'au weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ju'u ka au taka yekame junak, yejteka intok a' jo'aau bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Junak ju'u yoemra, inika'a bichaka, majjaek. Intok inime'e Liojtau bicha bem allea'uta teuwaak, aapo'ik junuen inim yoemrata nasuk inile benak a jita a' joa'uta am bittuaka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus junama'a yeu siika intok senuk Mateo' teamta bichak, ya'uraatau bicha tomita weyemta nau a' totoja'po katekamta. Iniau intok: ―Nemak weye ―ti au jiiak. Junak intok ju'u Mateo' teame, kikteka, aamak siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chukula ket Jesus, jo'araapo ji'ibwan. Intok juebenaka ya'uraatau bicha tomita weyemta jume' nau a' totojame intok wate ka tuu'ii yoemem ket ama yajak. Inime'e intok ket Jesujtamak intok jume' a' majtimmak mesau jookan. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Taa jume' paiseeom teame inika'a bichakai, jume' Jesujta majtimmeu: ―Jaisaakai ju'u enchim majtame, inime'e tomita nau totojammak intok jume' ka tu'i yoememmak ji'ibwa ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Inika'a ju'u Jesus jikkajak intok inimmeu inen jiiak: ―Jume' alleaka intok ka ko'okoeme ka waka'a yee jijittomta jariune. Jume' ko'okoeme ala, a' jariune. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Saka'abo'em intok eme'e, Liojta nok lutu'uriapo inen ji'ojteita, juka' a' teuwaa'uta ta'aanee: “Enchim yee nak jiokolinee'uta ne waata, intok kaa, nee yo'oribaawaka, bwara jissu'awamta.” Bwe'ituk, kannee jume' Liojta bichapo tu'isi emo jiapsa'ati eame jinne'useka yebijlaa. Ala jume' ka tu'i yoemem junuen juka' ka tu'ik bem joa'uta su'u tojaka, bem a' koptane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Junak intok jume'e, ju'u yee babatoowame Joan teamta majtim Jesujtau rukteka intok: ―Jaisaaka itepo intok jume' paiseeom teame ka ji'ibwaka Liojta yo'oriwamta juebenasi te a' jooa. Jume' intok em majtim ka junaen a' bo'o jooria ―ti a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ju'u Jesus inen am yoopnak: ―Jume' jujupwa'po nunurim, kaachin siokaka ama anne, juka' au jubemta ama ketun a' aneo. Taa yuma'anee ju'u taewai, junaka'a jubemta a' kaabetuneeo, junak ala ka ji'ibwabaanaa ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Kaabe supe moeram, tajo'ori bemelammea am cha'abwabaane. Bwe'ituk jume' bemelam ammea am cha'abwaame, baksiawaka intok nau sikaa, jume' yuuyam siutanee intok junuen che'a juni'i bwekasi siutine. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Intok kia ju'u bemela pa'asi ba'awa juni'i, kaachin bea boosa moeraku kima'anaa. Bwe'ituk ini'i inien ya'awako, tapunaka jume' bea boosam wojoktine. Junak intok ju'u pa'asi ba'awa wo'otine. Intok kia jume' bea boosam juni'i nasontune. Junuen san ju'u bemela pa'asi ba'awa beemela bea boosampo kima'atune. Junuen nanancha nau binwatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Juka' Jesujta ket inika'a weemta ameu teuwaao su, senu juriommeu ya'ut ama au yepsaka au tonommea kiktek intok: ―In maara ju'ubwa jiba muuke, taa enchi aman sikaa, enchi aet mamteko juna'a juchi jiapsine ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ju'u Jesus, kikteka jume' a' majtimmake aamak siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Junak intok senu jamut, woj mamni ama wooi wasuktiapo ojbo aet yeu weyeka ko'okoekai, amatana Jesujtau rukteka intok a' supe mayoat maamea aet tajtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Bwe'ituk juna'a jamut: “Kia nee a' supewammet tajtek juni'i, nee ino ine'etene”, ti ean. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Taa ju'u Jesus kuakteka intok juka' jamutta bichaka: ―Kat jain ea in yoemia, emo'e ine'etela. Junuen em nee sualeka' betchi'bo ―ti au jiiak. Junama lautipo aapo sep au ine'etek. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Junak juka' Jesujta junae ya'utta jo'au yepsaka, intok jume' jiponreeom a' ma'a betchi'bo jipoonbaeme intok jume' ama aneme tua bwaname bichakai, ");
INSERT INTO yaqNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","inen ameu jiia: ―Yeu em kaate bwe'ituk ka mukia ju'u usi jamut, taa ala koche. Jume' ama aneme kia a' atbwan. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Taa ju'u Jesus, inime'e yeu saka'atuak. Junak intok aapo aman kibakeka intok juka' usi jamutta mampo a' bwisek. Ini'i intok sep yejtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Intok si'ime junae bwiaraat ju'u ama yeu sikame ju'uneiyaawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Juka' Jesujta junama'a yeu siiko, liliptim woika aet cha'aka kaaten intok: ―Itom jiokole, empo Labiituka'utat katriam betana yeu simria ―ti chaaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Juka' Jesujta intok, kariu a' kibakeko, jume' woika ka bibichame au ruktek. Aapo intok ameu nattemaek: ―Jaisa eme'e inika'a in a ya'ane'uta a' suale ja'ani ―ti jiakai. Bempo intok: ―Jeewi achai ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Junak intok ju'u Jesus, pujpo amet mamtek intok: ―Enchim junuen a' suale'po aman tune ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Inime'e intok, bem puusim sep tu'ireak. Junak ju'u Jesus tua ameu ujbwanak: ―Inika'a, eme'e kaabeta a' ju'uneiyaatuane ―ti ameu jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Taa inime'e, kia junama yeu sajaka jiba, si'ime junae bwiaraat, juka' Jesujta yaaka'uta teuwaa japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Junak bempo'im junama yeu kateo su, waate, junaman yoemem, seenuk, ka nokamta intok bebeje'erita ka tu'ik jiapsekamta, Jesujtau a' tojak. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Junama'a juka' Jesujta junuen, inika'a ka tu'i jiapsita, yeu a' bepriasuko, ju'u ka noka'u sep nok taitek. Ju'u ama aneme yoemra, tua suum eak intok: ―Jakwoo juni'i inim Ijra'el yoemrata nasuk, inile benaka kee bittun ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Taa jume' paiseeom teame: ―Ini'i o'ou jume' bebeje'eri ka tu'i jiapsim yeu beba, taa jiba ju'u inime'e bebeje'erimmeu yo'ota a jita a' joa'ue ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ju'u Jesus si'ime jume' bwere jo'aram intok ka bwere jo'arammet wewe'aman. Jum juriom nau emo totoja'po te'opompo a' yepsa'apo, yee majtakai. Liojta yo'o nesaweka a' kateka'a betana juka' bemela nok lutu'uriata yee majtan. Intok ket si'ime jume' ka nanau machik ko'okoakame intok jak wanteme, emo am ine'etetuan. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aapo, juka' junama'a yoemrata bichakai, am nak jiokolek. Bwe'ituk inime'e, ka alleewame amet ayukan. Intok kaabetat eaka, kia beja sioksi jiapsan, jume' bwalam, kaabeta am suua machiaka'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Junak intok aapo, iniat nokaka, essoi nokpo, a' majtimmeu inen jiiak: ―Tua lutu'uriapo, ju'u eechi, chuktanaame, juebena. Taa jume' tekipanoame ka juebena ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Junuen san eme'e, juka' echita atteakamtau bicha nokne, junuen, tekipanoareeom, juka' echita chuktaneeme, aman a' bittuane' betchi'bo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Junak intoko ju'u Jesus, jume' woj mamni ama wooika yeu a' pu'arimmeu chaaek. Inime'e intok, jume' bebeje'eri, ka tu'i jiapsim yeu beep betchi'bo, intok si'ime ka nanau machi ko'okoata intok jak wanteme a am tu'utene' betchi'bo, junaka utte'ata amet autuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Inime'e juname'e, jume' woj mamni ama woika, Krijtota yeu pu'arim team: ju'u bat weeme, Simo' teame, ket Peeommea ta'eewame. Intok inia saai, Antej teame. Intok ju'u Jakoobo intok ket ju'u aapo'ik saailawa Joan teame, jume' Sebereo' teamta u'usim. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Intok ju'u Jeriipe' teame intok ju'u Baatolome' teame. Ju'u Toomas intok ju'u Mateeo, ju'u ya'uraatau bicha tomita weyemta, nau totojame. Ket senu Jakoobo, Alpeo' teamta u'usi. Intok ju'u Lebeo' teame. Ini'i ket Tareo ti teaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ket senu Simo' teame, ini'i jume' kananiitampo emo teuwaamak cha'aka'u. Intok Juuras, Ijkarioote' teame, ju'u chukula Jesujta yeu bwisekame. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ju'u Jesus inime'e woj mamni ama wooim naas bittuak inen amet nesawekai: ―Jume' ka jurio yoemrata jo'aaka'u bicha eme'e ka katne. Intok kia bwiaara Samaaria' tea'po jo'arammeu juni'i ka yajine. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ala eme'e Ijra'el yoemratau, jume'e, bwaram chiktulam benasi in eiyaa'ummeu bicha katne. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Achai Liojta inim bwiapo a' nesaunee'u abe a' yuma'apo yee majta sakane. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wame'e ko'okoeme am nokriaka emo am ine'etetuane. Jume' kokkoarim eme'e juchi am jiabijtetuane. Jume' sa'awaka, lepra' teamtae ko'okoeme, eme'e am tu'utene. Jume' bebeje'eri ka tu'i jiapsekame jipueme, yeu am bepriane. Eme'e inika'a, au yumaka, Liojta betana a enchim joa'uta, kia beja a' mabetri. Junuen san eme'e ka tomipo jita ae joone. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Sawai tomita intok kia tosai tomita intok kia kopre tomita juni'i, ka weiyaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Intok kia juka' enchim ama nu'u sakanee'u juni'i. Supem ka wooim weiyaane. Intok kia chukula enchim bochanee'um juni'i. Intok kia booniata juni'i ka weiyaane. Bwe'ituk ju'u tekipanoaleeo, ini'i bwa'amta a' maknaa'u iniau lutu'uriane. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Senu bwe'u jo'arau, oo junae naapo, ili jo'arau eme'e yajako, junama'a eme'e seenuk, enchim yoem'eiyaa'uta a' jariunee intok junama, inia jo'apo eme'e tawane, enchim ama anbae'po tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Junama'a kariu eme'e yajako, Liojta betana yanti eewamta ame tana waataka am tebotuane. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Junama'a, jume' jo'aakame tu'isi enchim mabetaka, ameu a' lutu'uriatuko, inika'a Liojta betana yanti eewamtae am tebotuane. Taa inime'e ka junuen ameu a' lutu'uriatuneeo, eme'e ka inien, junae am tebotuane. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Intok junama'a eme'e ka mabetwako, intok kia ka enchim am jikkajibaao, junak eme'e junama'a karipo oo junama'a bwe'u jo'arapo yeu katne. Intok bempo'im ka amma'ali aulatuka'uta teuwaaka, enchim wokpo juka' to'ochiata eme'e a' tatakne. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Lutu'uriapo nee inen emou jiia, juka' taewaita, Liojta yee aet a' ya'uraa bittuanee'u yumako, ju'u junama'a jo'aakame yoemra, junuen jiokot bem emo bitnee'u, che'a juni'i machine, jume' bat naataka jum bwere jo'aram Sorooma' tea'po intok Komoora' tea'po jo'aakame bepa. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Eme'e a' mammatene, inepo ne enchim bwalam benasi machika, jumun robom ane'u bicha ne enchim bittua. Junuen san beja, eme'e, bakotta a au a' suua'a benasia annee. Taa ket, juka' wokkoita, kaitau a' sua'a benasi tu'isi emo uju'une. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Emo suuanee bwe'ituk inim ju'u yoemra, ya'uraatau enchim yeu tojine. Intok jum juriom nau emo totoja'po te'opompo eme'e ko'okosi joonaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Intok ket senu yoemratau yo'o ya'arim bichapo intok kia jume' che'a si'imem bepa yo'o ya'arim bichapo juni'i, eme'e yeu tojitune, enchim im nee yo'ore' betchi'bo. Junuen eme'e nee betana weyemta ameu a' teuwaane. Intok wame'e ka juriommeu juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Taa juname'e ya'uraam bichapo eme'e yeu tojituko, ka eme'e jain emo eetuane, juka' enchim teuwaanee'uta oo ju'u enchim jiunee'u betana, bwe'ituk junak junama enchim noknee'uta, ala, Liojta betana eme'e junaet aniatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bwe'ituk eme'e ka juname'emtunee jume' nokneeme, ala, ju'u aapo'ik Lios achaita tu'u jiapsi emot aneme juna'atunee ju'u enchim aniaka enchim noktuaneeme. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Junako waate inim jiapsame, kia tua jume' amemak werim, am su'atune' betchi'bo yeu am bwijne. Jume' intoko achaiwaim jume' bem yoemiam beje'eka katne. Jume' intoko yoemiawaim bem yo'owam beje'eka japtenee intok am su'atebone. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Inim si'imekut, si'ime enchim omtane, nemak eaka nee betana enchim kate' betchi'bo. Taa wa'a, inim ket a' jiapsa'po tajtia, Liojta ka koptakame, juna'a jiba betchi'bo jinne'uitune. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jak, senu bwe'u jo'araapo, ka emomak eewao, eme'e omot, ta'abwi bwe'u jo'arau bicha yeu saka'ane. Bwe'ituk ne lutu'uriapo ne inen emou jiia, kee si'ime Ijra'el yoemrata jiapsa'abe'eka tana enchim kateo su, juka' inim emo benasi yoemta a'abo a' nottine'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Kaabe ju'u majtawame, ju'u a' majtaka'uta bepa che'a bepaasi eiyaatune. Intok kia ju'u tekokame juni'i, kaachin a' tekowaa bepa che'a eiyaatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ju'u majtawame, ju'u a' majtaka'uta benasi jita tu'ik ta'aaka, junaemak yanti elne. Ju'u tekokame intok ket, a' tekowata benasi tekileu junuen yumakai, yanti elne. Taa junuen juka' che'a yo'ota juni'i su, bebeje'eri jiapsimmeu yo'owe ti a' teuwaawao, jiba tua jume' a' yoemiawam che'a juni'i junaen teuwaanaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Junuen san ka eme'e jume' emo benasi inim yoemem majjaune. Bwe'ituk kaita aayuk ju'u ka a ju'uneiyaawaka jiba betchi'bo ka ju'uneiyaanaame. Intok kaita aayuk wa'a ka ju'uneiyaawaka joowaka, jakwoo ini'i ka ju'uneiyaatuneekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Juka'a, tukaapo in emou teuwaaka'uta, eme'e junaka'a taewapo a' teuwaane. Intok ket, juka' omola emou jiba laauti in emou teuwaarita, eme'e, kari jikat ja'abweka, watemmeu kusisi a' teuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Inim jume' yee sussu'ame eme'e ka majjaune, jume'e, jiapsita kaachin joame. Ala eme'e, juka' teekapo jiapsaka inika'a takaata intok kia juka' jiapsita juni'i, jum taji, jiba yuu beete'po jiba betchi'bo am tawaanemta, junaka'a eme'e majaune. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Eme'e ju'unea, wepul ili tomipo, wooi ili wikitchim am nenenkiwa'po. Taa juname'e betana wepu'ulaika juni'i ka kia beja mukne, juka' enchim yo'owa Liojta ka junen eao. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bwe'ituk kia jume' kobat enchim choonim juni su, si'ime, aapo ju'u Lios am na'ikiari. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ka eme'e majaune. Bwe'ituk eme'e juni'isu ket che'a juni'i, juname'e wikitchim, juebenam bepa che'a eiyaawa. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Si'imem wame'e, inim yoemrata bichapo, ne tana bem kate'epo a' teuwaaka junuen a' lutu'uriateme, inepo nee ket, in achai, teekau katekamta bichapo, nee betana bem kate'epo junuen a' lutu'uriatene. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Taa wame'e, inim yoemrata bichapo, ka nee emo ta'a'ati jiame, ineponee ket, in achai, teekau katekamta bichapo inime'e junuen ka nee betana bem kate'uta a' lutu'uriatene. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Ka eme'e, inim jiapsammeu yanti eewamta jiba a'abo nee weiya'ati eene. Bwe'ituk kannee inika'a a'abo weiyaaka yebijlaa, ala juka' emo beje'ewamta. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Inen weyekai, ju'u yoemiawai, inim a' achaiwata beje'ene. Ju'u intok jamut asowai, a' malawata beje'ene. Ju'u intok jaboraiwai a' jamut ase'ebwawata beje'ene. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Junuen san we'epulaka, si'ime jume' nau wewerika nau jo'aakame, naas emo beje'ene. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Wa'a, juka' a' achaiwata oo a' aewata, nee bepa che'a juni'i a' eiyaame, ka au lutu'uriatunee in a' yoemiane'po. Intok ket, wa'a a' ou usita oo a' marawata, nee bepa che'a juni'i a' eiyaame, juna'a ka au lutu'urianee in a' yoemiane'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wa'a intoko inim a' jiapsa'uta ka nee betchi'bo a' su'u tojaka intok ka nemak eebaeme, ini'i ka au lutu'uriatune, in a' yoemiane'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wa'a, inim jiba binwa alleaka jiapsibaeme, juna'a, jiba yuu a' jiapsinee'uta a' ta'arune. Taa wa'a, nemak eaka a' jiapsibae' betchi'bo, ka junuen ala ini'i a' jiapsinee'uta ka a' bichakame, ini'i, jiba yuu a' jiapsinee'uta bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Ju'u tu'isi enchim mabetame, nee mabetlatune. Ju'u intoko junuen nee tu'isi mabetame, waka'a nee a'abo bittuakamta junuen mabetlatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wa'a intoko, juka' Liojta betana ju'uneetuawaka yeteu noktuawamta tu'isi mabetakame, junaka'a Liojta betana a' weye'po ju'uneakai, ini'i, jiba junaka'a Liojta betana yeteu noktuawamta tu'ik mabetnee'uta, ale benasi a' mabetne. Wa'a intoko juka' yoemta tu'ik jiapsekamta tu'isi mabetakame, junuen a' machiaka'po ju'uneakai, ini'i jiba junaka'a tu'ik jiapsekamta tu'ik mabetnee'uta, junale benak mabetne. ");
INSERT INTO yaqNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Intok jabetaka juni'i, inime'e nee sualeme betana seenuk, sejtul juni'i, sebe ba'am a' jiituame, junaka'a junuen nemak a' ea' betchi'bo, lutu'uriapo ini'i ket juka' au tu'ik bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ju'u Jesus junak, jume' woj mamni ama wooika a' majtim tejwaasukai intok na'ikim am bittuakai, junama'a yeu siika. Ama bwiaraapo jume' ili bwere jo'arammet yee majtaka intok Liojta nok lutu'uriata yeteu teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ju'u intoko Joan, yee babatoowame, jum yee e'etawa'po katekai, juka' Jesukrijtota joa'uta inika'a ju'uneiyaak. Junak intok aapo, jume' a' majtim betana waatem yeu pu'aka, Jesujta aman am bitne' betchi'bo, au am bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Inime'e junuen: ―Jaisa empo juna'a ju'u Krijto yebijnee'u ja'ani, oo te ketun senuk bo'o bitnee ja'ani ―ti au nattemae' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ju'u Jesus inime'e: ―Aman eme'e sajaka, si'imeta juka' enchim inim bicha'uta intok enchim jikkaja'uta, ju'u Joantau teuwaane ―ti am yoopnak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jume' ka bibichame, am bittuawa'po. Jume' intok lolo'im rejte'po. Jume' intok, sa'awaka, lepra' teamtae ko'okoeme, junae betana am tuttu'urea'po. Jume' ka jikkajame tu'ireaka am jijikkaja'uta. Jume' intoko kokkokame, juchi jijiabijtetuawa'po. Jume' intoko inim jiokot aneka jiapsammeu, Liojta betana juka' tu'i nok lutu'uriata am majtawaa'uta a' etejoriane. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Intok tua alleenee wa'a inim net jiapseka, jiba net a' yoem'ea'uta ka a' ta'arukame ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juname'e saka'asuko ju'u Jesus, ju'u Joan teamta betana ju'u yoemratau etejo taitek: ―Eme'e aman bwe'u pa'ariau aneka, jitasa eme'e bitboka aman sajak. Jaisa eme'e senu bakata jekae naas bepwamta bitbaeka aman sajak ja'ani. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ka junuentuko, jitasa eme'e bitboka aman sajak. Ka eme'e senuk tu'isi ujyoisi au a'anaalata bitbaeka aman sajak. Eme'esu ju'unea, jume' junuen ujyoisi emo a'anaarim, inime'e, jume' che'a si'imemmeu yo'o ya'arim jo'aaka'po jiba am ane'epo. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Junak su tua, jitasa eme'e bitboka aman sajak. Jaisa seenuk Liojta betana ju'uneaka yeteu nokamta ja'ani. Jana'aka. Intok inika'a che'a bepa jume' bat naataka Liojta betana yeteu noktuawame bepa machilaakamta. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ini'i Joan juna'a, ju'u, jum Liojta nok lutu'uriapo ae betana inien jiaka ji'ojtewakame: Inepone, juka' nee betana yeteu nokneemta epat a' bittuabae. Junuen inika'a, ju'u yoemratau nokaka, ee beas juname'e, bem emo jiapsi temaeka, enchi am mabetne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Taa lutu'uriapo ne emou inen jiia, yoemrata inim jiapsa'po naateka i'an tajtia, ju'u Joan yee bato'owamta bepa, kaabe che'a eiyaawatchika inim jiapsak. Junuentaka juni'i, jum teekau, Liojta yo'otaka kateka'u, ju'u che'a ka eiyaawatchi, inia bepa che'a eiyaanaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Juka' Joan yee babatoowamta yepsak naateka, i'an tajtia, Liojta inim a' nesawee'uta, ini'i tua beje'ewaka ka eiyaawa. Wame'e intoko, tua aet emo utte'a jooriame, inime'e a' yo'obaeka'ati ea. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Si'ime wame'e bat naataka Liojta betana ju'uneetuawaka nokakame ji'ojteim intok ju'u Moiseejtuka'uta nesauri ji'ojteim, inime'e, Liojta che'a yo'otaka kateka'u betana weyemtat nookak, juka' Joanta inim a' yepsak tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Eme'e intoko a' sualbae'eteko, ini'i Joan juna'a, wa'a, Eliaj teaka Liojta betana ju'uneetuawaka nokaka yebijne' teame. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jume' a' mammatebaeme a' jikkajine. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Inika'a yoemrata i'an jiapsamta, jitausa inepo nee a' tamachiane. Inen a tamachiatu, inime'e, ili uusim jum jita nenenkiwa'po joteka, yeeweka, intok jume' bem ta'aa'ummeu inen jiame bebena: ");
INSERT INTO yaqNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Kusiata itom emou kuseo juni'i, taa eme'e ka ye'eka. Chukula ket, kia sioksi itom emou bwikaao juni'i eme'e ka bwaanak.” ");
INSERT INTO yaqNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bwe'ituk juka' Joan, yee babatoowamta inim jiapsaka, inika'a ka yu'in a' ji'ibwaakai intok kia juka' ae naakowamta juni'i, ka a' jeje'eekai. Intok eme'e junaka'a, bebeje'eri ka tu'i jiapsi aet aane ti jiia. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Iniat chukula ket, ju'u inim emo benasi yoeme yepsak si'imeta a bwa'eekai intok kia si'imeta a je'eekai. Eme'e intok inika'a, yu'in a' ji'ibwaka intok ae naakowamta a' je'e'eti jiia. Ket jume' ka tu'i yoememmak intok jume' ya'uraatau bicha tomita weyemta nau totojamtamak a' weama'ati jiia. Taa ju'u suawa, Liojta betana weyeme, ini'i, chukula tu'isi yeu a' weama'ue, junae a ju'uneiyaatu. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Junak intok ju'u Jesus, wame'e bwere jo'arammet, jum aapo'ik a jita a' joa'uta che'a bu'uuka a' yaaka'po, inimmet nokaka am sua nok tejwaa taitek, jume' ama jiapsame ka emo am jiapsi temaeka' betchi'bo: ");
INSERT INTO yaqNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Tua jiokot emou machine, bwe'u jo'ara Korasin tea'po jiapsame. Tua jiokot emou machinee bwe'u jo'ara Betsaira' tea'po jiapsame. Bwe'ituk jum bwere jo'aram Tiiro' tea'po intok Siroon tea'po, ini'i ka a jootu maisi machika, emo nasuk ya'ari, ini'i junaman ya'atuko, jume' junakriapo jiapsame a' bichakai, jakwoo su bem ka tu'ik betana emo temaisu ean. Intok chukuik atteateka intok emo napojtuaka bem sioka'uta teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Taa inen ne emou jiia, chukula, Liojta yee ya'uraa bittuaneeo, junaka'a taewaita yumako, eme'e che'a juni'i jiokot a' bitne, wame'e, jo'aram Tiiro' tea'po intok Siroon tea'po jiapsaka'um bepa. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Eme'e intoko bwe'u jo'ara Kapernaum tea'po jiapsame, jaisa eme'e teekau nukisi emo che'a eiyaa machia ja'ani. Ala eme'e, jume' kokkoarim yaaja'u ko'om tojinaa. Bwe'ituk jum bwe'u jo'ara Sorooma' tea'po ini'i ka a jootu maisi machika emo nasuk ya'ari junaman ya'atuko, juna'a bwe'u jo'ara, i'an tajtia bwe'u jo'aratu ean. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Taa inepo inen emou jiia, chukula, Liojta yee ya'uraa bittuaneeo taewaita yumako, eme'e che'a juni'i jiokot a' bitne, wa'a yoemra, bwiaraa Sorooma' tea'po jiapsamta bepa. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Junakriapo ju'u Jesus: ―Enchi ne baisaeka enchi yo'ore, achai, teekau intok bwiau yo'owe. Bwe'ituk empo inika'a ee betana lutu'uriata, inime'e ili usim benasi, ka emo che'ewareme em a' ju'uneiyaatuari' betchi'bo, juka'a, koba susuakame intok jitat ju'uneame betana em essoka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jeewi in yo'owa, bwe'ituk empo junuen a' tu'urek. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Ju'u in yo'owa Lios, si'imeta in mampo su'u tojiri. Intok kaabe, juka' a' u'usiwata tua lutu'uriapo a' ta'aa, ala ju'u a' achaiwa jiba. Intok kia juka' achaiwaita juni'i, kaabe tua lutu'uriapo a' ta'aa, ala ju'u u'usiwai jiba. Intok wame'e, inika'a yoemiawaita aapo'ik a' ta'aatuabae'um jiba. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Si'ime jume' inim, betteka emou aukamta betana jiokot emo bichame intok juka' enchim joobaeka, ka enchim au yuma'uta emou ayukame, net eaka, neu bicha waatine. Inepo ne intok, junae betana enchim aet yeu yuma'atuane. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Juka' in enchim tekil makbae'uta, eme'e mabetne, intok juka' lutu'uriata eme'e junuen neu a' ta'aane. Bwe'ituk inepo ne ka seej chukti eaka ne a jita juiwa. Intok ket, ne ka ino che'eware. Intok junuen eme'e, juka' jiapsi yuma'isi yum jo'ewamta jajamne. ");
INSERT INTO yaqNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bwe'ituk ju'u in enchim bo'o jooria i'a'u ka obiachika weye. Intok junuen weyeka in enchim jiapsi i'a'u ini'i ka bettesi yuum watchisi weye. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Junak ta'apo ju'u Jesus, wajpo tiikom etchipo aman weyen, senu aet yum jo'e taewaituko. Jume' a' majtim tebauri e'eaka intok, inime'e jume' tiikom moakame chuktaka, jume' bachiam bwa'ajaptek. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jume' paiseompo ta'eewame junak, inika'a bichakai, Jesujtau: ―Jume' em majtim bichaa ―ti au jiiak―. Aet yum jo'e taewapo tekilta, ka joo i'awamta jooa ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Taa aapo intok junammeu: ―Jaisa eme'e jum ji'ojteipo kee a' nokla ja'ani, sejtul wee'po juka' Labiituka'uta intok jume' aamak rejteme, tebaureka juka' bem yaaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ini'i jum Liojta yo'oriwa'po, te'opopo kibakeka, jume' paanim, Liojtau bicha na'ikiarim ama joka'um bwa'aka. Inime'e, aapo'ik intok kia jume' aamak rejte'um juni'i, ka bem bwa'a'ea'um, ala jume' te'opopo tekiakame jiba ameu lutu'uriakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Oo jaisa eme'e jum Moiseejtuka'uta nesauri ji'ojteipo eme'e kee a' bicha ja'ani, wame'e, jum te'opopo che'a yo'o ya'arim junama inime'e taewaimmetchi ka bem yum jojo'ee'uta. Intok junuentaka juni'i, inika'a Liojta bichapo, ka tu'ik kaita ama a' ayuka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Junuen san inien ne emou jiia, i'an inimi'i, junae te'opota bepa che'a juni'i eiyaawatchika senuk ane'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Eme'e, juka' Liojta nok lutu'uriapo inen ji'ojteitat kee aet ju'unea: “Enchim yee nak jiokolinee'uta ne waata, intok ka juka' bwara jissu'awaka nee yo'oribaawamta.” Iniat eme'e ju'une'ea'ateko eme'e juka' yoemrata, kaita ka tu'ik ya'arita kaachin ka tu'isi a' tatawaa ean. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bwe'ituk ju'u inim emo benasi yoeme, ket jiba inia aet yum jo'e taewait juni'i, jitat a' nesaunee'ut lutu'uriak. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Junako ju'u Jesus junaman yeu sika intok ket, Liojta yo'ori betchi'bo, jume' juriom nau yaaja'po, te'opopo yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Junama'a intok senu jurio, mam wakiataka ama aanen. Waate intoko juka' Jesujta, jachin juni'i a' na'atejobaekai: ―Jaisa tu'i ja'ani, aet yum jo'e ta'apo, ko'okoemta seenuk a' aniaka au a' ine'etetuapo ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ju'u Jesus inen am yoopnak: ―Jabesa emo betana, senu ili a' bwalawa jum wojo'oku, ba'aka'po ko'om a' wecheko, junuen aet yum jo'e taewaituko, ka au sika yeu a' wikneeme ―ti ameu jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kiali'ikun senu inim yoemtaka, bwalata bepa che'a juni'i eiyaawatchi. Junuen san kaachin maachi, amet yum jo'e taewaimmet, senuk, jita tu'ik a' ya'anee'u ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Junak aapo, inia yoemtau: ―Em mamam rutukta ―ti au jiiak. Inika'a intoko, jume' a' mamawam rutuktakai, juname'e, jume' senum benasi tu'ika taawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Junako jume' paiseeom teame junama yeu sajaka intok inime'e junama sep juka' Jesuujta, a' me' betchi'bo nau etejo japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Junak ju'u Jesus, inika'a ju'uneiyaaka, junama'a yeu siika. Ju'u intoko yoemra bu'uuka aamak yeu sajak. Ju'u Jesus intok si'ime jume' ko'okoeme emo am ine'etetuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Intok aapo ameu ujbwanak, aapo'ik jabetuka'po, ka bem a' etejone' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ini'i junuentuk, junuen a' chupne' betchi'bo juka' bat naataka, Liojta betana ju'uneetuawaka yeteu noktuawakame, Isa'iaj tuka'uta teuwaaka'uta inen a' jiako: ");
INSERT INTO yaqNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ini'i juna'a ju'u nee betana tekilta joame. Ini'i ju'u in yeu pu'ari, in nake'u. Intok inia betchi'bo tua in allea'u. Nee betana juka' tu'ik jiapsita nee aet autuane. Intok ini'i, nee betana juka' in yee ya'uraa bittuanee'uta, si'ime ka nanau machi yoemratau a' teuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ini'i ka nok nassuane. Intok kia ka chaaine. Intok jum bwere jo'arampo naj katwammet, kaabe, chaaemta a' jikkajine. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jabeta, jak wa'am machik juni'i, inika'a ka yeu tawaane. Intok kia juka' ju'ubwa jiba Liojta sualbaemta, junae betana ka ko'om a' eetuane. Junuen aapo'ik inim che'a yo'otaka intok lutu'uriakamtae nesaweka, junae inim a' yo'osu'po tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Intok si'ime ju'u inim yoemra, bem jinne'uimtune' betchi'bo, aapo'ikut eaka a' bo'o bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Junak intok seenu, ka bichaka intok ka a nokaka, intok bebeje'erita ka tu'ik jiapsekamta, ini'i, Jesujtau tojiwak. Ju'u Jesus, inika'a au a' ine'etetuak. Junuen san ini'i, juchi bichaka intok a nookan. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Si'ime jume' ama aneme a' suum eiyaaka intok: ―Jaisa ini'i juna'a ja'ani, ju'u Labiituka'utat yeu katriam betana weyeka, ju'u bo'o bitwame ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Junak jume' paiseeom, inika'a jikkajakai: ―Ini'i o'ou, ju'u inimmeu yo'owe, Beelsebuu teamta a' utte'awae jiba, jume' bebeje'eri ka tu'i jiapsim yeu beba ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Inimmet ju'u Jesus ju'unean bem jachin emo eetua'po intok: ―Jita yoemrapo juni'i, junammeu ju'u che'a yo'oraa na'ikimteko intok inime'e nau nassuakai, inime'e emo lu'utane. Intok kia senu bwe'u jo'arapo oo jo'apo jume' nau wewerim, inime'e nattepola, ka nau ea'ateko, inime'e ka a binwa nau jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Junuen ketchia, ju'u yo'o bebeje'eri, juka' aapo'ik sawe'uta bebeje'erita ket yeu bebakai, ini'i jiba aapo au beje'eka annee. Junuen san ju'u inika'a utte'aka a' nesawee'uta, kaachin inim binwatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Eme'e, jume' bebeje'eri ka tu'i jiapsim, ju'u bebeje'erimmeu yo'owe, Beelsebuu teamta utte'ae nee yeu am beba'ati jiia. Junuentuka'ateko, jume' emo mak eaka rejteme, inime'e ket yeu am bep betchi'bo, jabesa junau am yuma'atuari. Junuen san jiba bempo enchim ji'oplamtuka'uta a' teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Taa inepo ne, jume' bebeje'eri ka tu'i jiapsim, jiba ju'u Liojta tu'u jiapsie nee yeu am beba. Ini'i intoko, Liojta che'a yo'otaka inim bwiapo a' nesaunee'u a' yuma'aseka'po a' teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Junuen san, kaabe, senuk a au aniamta kariu kibakeka, jita a' u'aane, inika'a ka che'a bat a' suma'alatakai. Bwe'ituk inien jiba inika'a a' atteawata a' u'aane. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Wa'a ka nemak eame, juna'a nee beje'eka jiapsine. Wa'a intoko ka nee betchi'bo yoemrata nau totojame, ini'i junuen, ka neu bicha am eetuane. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Junuen san ne inen emou jiia, jume' inim jiapsame, si'ime ju'u bem ka tu'uwa ya'arit intok si'ime ju'u ka tu'ik bem teuwaarit, a bem jiokoitu'po. Taa inime'e, Liojta tu'u jiapsita beje'eka, ka tu'ik teuwa'ateko, ini'i, kaachin a amet jiokoitune. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Intok kia jabetaka juni'i, juka' inim emo benasi yoemta beje'eka jita ka tu'ik teuwaakame, jiokoitune. Taa wa'a, juka' Liojta tu'u jiapsita beje'eka ka tu'ik teuwaakame, ini'i, inim jiapsakai intok kia chukula jiapsinaa'po juni'i, kaachin a aet jiokoitune. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Senu tu'u yoemtuka'ateko, juna'a, tu'ik a' joa'u aet aune, tu'i juyata, tu'ik a' tataka'a benasia. Senu intok, ka tu'u yoemtuka'ateko, juna'a, ka tu'ik a' joa'u aet aune. Juka' juyata a' tataka'ue junuen a' ta'eewa'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Bakotchim bebena ka tu'i yoemra. Jiba eme'esu, ka tu'i yoememtakai, juka' tu'ik eme'e kaachin a' teuwaane. Bwe'ituk ju'u senuk teuwaanee'u, inika'a a' jiapsipo a' eeriwa betana weye. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ju'u tu'i yoeme, aapo'ik jiapsipo, ju'u tu'ik aet ayuka'u betchi'bo, ini'i tu'ik jiba teuwaane. Ju'u intoko ka tu'i yoeme, ini'i a' jiapsipo, juka' ka tu'ik jiba aet ayuka'u betchi'bo, junuen ka tu'ik teuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Inepo intoko ne inen emou jiia, chukula, Liojta yee aet ya'uraa bittuaneo taewaita yumako, si'imem, noktuawaka, jiokot aet emo bitne, si'ime inim ju'u bai tiupo benaka, kaita teuwaaka bem teuwaari betana. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bwe'ituk empo, ju'u em teuwaariaka'u betana, junaen, Liojta bichapo ya'uraa bittuanaa. Junak intok, kaita ka tu'ik ya'ari benasi bitnaa, oo ka tu'isi eu chupne. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Junak intok waate, jume' paiseom betana intok jume' Moiseejtuka'uta nesaurim yee majtame betana, inime'e Jesujtau inen jiiak: ―Yee maj majtame, machilaata em a jita joa'apo amani, itepo a' bitbae ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus, inime'e inen yoopnak: ―Ju'u ka tu'i yoemra intok ka wepulsi Liojta jiba yo'oreme, Liojta a jita joa'uta, machilaata bitbae. Taa inime'e kaita intok naa buusti machilaata bitne, kia juka' Jonajtuka'uta betana ju'u ama ayuka'uta jiba. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bwe'ituk juka' Jonajtuka'uta junuen baji ta'apo intok baji tukaapo, bwe'u kuchuta wajiwa a' aneka'a benasia, jiba junuen ket ju'u inim emo benasi yoeme, baji ta'apo intok baji tukaapo, bwiata wajiwa anne. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jume'e, bwe'u jo'ara Ninibe' tea'po jiapsaka'um, Liojta yee ya'uraa bittuaneo taewait ama anne. Junak juka' i'an taewaimmet yoemrata a' ya'uraa bittuawao, intok juname'e inime'e ka tu'isi tawaane. Bwe'ituk jume'e, bwe'u jo'ara Ninibe' tea'po jiapsaka'um junak, juka' Jonajtuka'uta, Liojta betana nokta ameu a' teuwaako, inime'e ka tu'ik betana emo temaek. Inimi'i intok, ju'u Jonaj teamta bepa che'a eiyaawatchika senu aane. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Intok ketchia, luula yejte'u betana senu si'imem bepa yo'o ya'ari jamut, ket, Liojta yee ya'uraa bittuaneo taewait ama annee. Junak, juka' i'an taewaimmet yoemrata a' ya'uraa bittuawao intok, aapo inime'e ka tu'isi tawaane. Bwe'ituk ini'i jamut, aapo junama'a che'a juni'i mekka bwiaraa betana yepsak, juka' yo'o ya'ari, Salomon tuka'uta ama butti a' suawaka'uta jikkajibaekai ama yepsak. I'an intok inimi'i, ju'u Salomon tuka'uta bepa, che'a eiyaawatchika senu aane. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Maa su, senu bebeje'eri ka tu'i jiapsi, senukut inim yeu siiko, juna'a mekka anwa'abe'emu weamnee jak a' yebijnee'uta jaiwakai. Intok ini'i junuen kaita teakai, ");
INSERT INTO yaqNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","junak: “Jumun jo'arau in yeu sika'u ne nottibae”, ti ee simne. Junak nottekai junaka'a yoemta aet yeu a' sika'uta, karitau kaabeta ama ane'ebenaka ujyoisi ya'arik intok chichikrita a' teune. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Junak intok sikaa, juchi woo busanim waate bebeje'eri ka tu'i jiapsim che'a juni'i ae bepa mamachin aman nu'upane. Juname'e intok si'ime jiba junaet jiapsibaeka aet kimune. Chukula intok ini'i, che'a juni'i bat naataka bepa ka tu'ika tawane. Inia ka tu'i yoemratau ket jiba inien yeu weene. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Juka' Jesujta, ju'u yoemratau ketun a' nokao su junak jume' a' sailawam intok a' aewa ama yajak. Inime'e pa'aku taawak intok bempo aamak etejobaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Senu inen a' tejwaak: ―Ju'u em maala intok jume' em sailam, im pa'aku aane, intok bempo emak etejobae ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Taa aapo ju'u Jesus, ju'u a' tejwaakamtau: ―Jabesa ju'u in ae intok jabemsa juname'e jume' in sailam ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Junak intok jume' a' majtim naj jikku'ubwaka intok: ―Inime'e, inepo ne in ae benasi intok jume' nemak wewerim benasi ne am eiyaa ―ti jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bwe'ituk jabetaka juni'i, in yo'owa, teekau katekamta ea'po aman jiapsame, juna'a in saila oo in jamut waaim intok kia in ae benasi machine ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jiba junae taewait ju'u Jesus junama karipo yeu sika intok senu bwe'u bau ba'au mayoau yepsaka ama yejtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jum a' ane'epo juebena yoemrata aman nau yajako, ju'u Jesus, senu bwe'u kuta kanoau ja'amuk intok ama yejtek. Ju'u intoko yoemra si'ime juna'a bae mayoat taawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Junak intok, aapo, jita ta'abwiku a' tamachiaka juebenak am majtan: ―Senu etreeo etbaeka a' wasau yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Intok ini'i junuen, enchimuta wo'ota simekai, juna'a bachia, waate bo'ot luula wattek. Jume' intok wikitchim ama yajaka junaka'a bwa'aka. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Waate ju'u bachia ket tetam nasuk, ka yu'in bwiaka'po wattek. Intok juna'a bachia lauti siiwek bwe'ituk juna'a bwia bepa jiba bwalkoekan. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Taa juka' ta'ata yeu yejteko, juna'a choowok. Intok ini'i bachia, ka mekka ko'om a' nawaka' betchi'bo, waakek. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waate bachia ket, juya wichaka'po wattek. Intok ini'i wichakame yo'otuka intok junaka'a tiikota ka a' yo'otutuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Taa waate ju'u bachia, tu'i bwiapo wattek. Ini'i intok, tu'ika chupuk. Waate ju'u tiiko bachia, we'epulaka, mamni takaam bachiaka chupuk. Wate intoko baji takaam bachiak. Wate intoko senu taka ama woj mamni bachiak ju'u tiiko. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Eme'e intoko a' mammatebae'eteko a' mammatene. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Junako waate jume' a' majtim, ju'u Jesujtau rukteka intok inen au nattemaek: ―Jaisaaka empo inia yoemratau, jita ta'abwiku a' tamachiaka ameu nooka ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aapo, inime'e inen yoopnak: ―Ju'u Lios, teekau aapo'ik che'a yo'otaka a' kateka'u betana, juka' kaabeta ju'uneiyaa'uta, enchim a aet ju'uneetuala. Taa bempo ka junuen inika'a ju'uneiyaatuawa. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bwe'ituk wa'a che'a a' eiyaame, ini'i che'a bepa a' ju'uneiyaatuanaa, intok junuen yuma'isi aet ju'uneene. Taa ju'u ka a' eiyaame, ini'i, juka' iliikik ka jaikika a' ju'uneiyaa'uta, a' u'aatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Junuen san nee jita ta'abwiku a' tammachiaka ameu nooka. Bwe'ituk bempo, juka' in joa'uta, a' bichaka juni'i, kaita bichame benasi tatawa. Intok kia juka' in ameu noka'uta a' jikkajaka juni'i, kaita jikkajame benasi, ka aet ju'uneaka tatawa. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Junueni inime'e i'an bem maachiaka'ue chupia ju'u Liojta betana ju'uneetuawaka nonokame Isa'iaj tuka'uta inen a' teuwaaka'uta: Jiba tua eme'e a' jikkajine, taa eme'e ka aet ju'uneene. Intok eme'e jiba tua a' bitne, taa ka aet mammatene. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bwe'ituk inia yoemrata jiapsi, a jitat am ju'une'ea'u, namakasi aulaa. Intok kia beja tua jikkaja. Intok inime'e, ka bibichame bebena. Junuen puseka juni'i, kaita bitbae. Intok nakaka juni'i, kaita jikkajibae. Intok ka tua lutu'uriapo net ju'uneebae. Intok kia ka neu bicha waatibae juni'i, junuen in emo am ine'etetuane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Taa tua alleenee eme'e, bwe'ituk eme'e lutu'uriapo a' mammateka a' bicha intok tua aet ju'uneebaeka a' jikkaja. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Lutu'uriapo ne junen emou jiia, juebenaka jume' bat naataka, Liojta betana ju'uneetuawaka yeteu nonokame intok jume' tu'ik jiba joaka jiapsame, inika'a, i'an enchim bicha'uta a' bitbaek taa ka a' bichak. Inika'a i'an enchim jikkaja'uta intok a' jikkajibaek, taa katim a' jikkajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Juka' echimuta wo'otakamtat nokaka in emou teuwaaka'uta juka' tua a' teuwaabae'uta i'an eme'e a' jikkajine. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jume'e, juka' Liojta aman teekau che'a yo'otaka a' kateka'u betana juka' nok lutu'uriata a' jikkajaka intok ka aet ju'uneame, inime'e, juka' bachiata bo'ot wattekamta bebena. Ju'u bebeje'eri ameu yepsaka juka' Liojta betana nok lutu'uriata ameu teuwaawaka bem mabetaka'uta, inime'e a' koptatuane. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ju'u bachia jum tetapo wattekame, inime'e, jume'e, juka' Liojta betana nok lutu'uriata a' jikkajaka intok tua alleaka sep a' mabetakame teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Taa inime'e intok junuen, juka' tiikota ka tu'isi yuma'isi a' nawaka'a benasi machikai, ka bibinwatu. Intok inime'e, bettesi ameu a' ayuko oo ju'u Liojta nok lutu'uriata betchi'bo jiokot bitwakai, junaet ka emo alleetuaka, aet bem ea'uta ta'arune. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ju'u bachia intok, jum juya wichaka'po yojtekame, ini'i, jume'e, juka' Liojta betana nok lutu'uriata a' jikkajaka, tu'isi a' mabetakame teuwaa. Taa inime'e inim weyemtat jiapseka intok juka' inim ujyooik bem a' eiya' betchi'bo intok ju'u yu'in bem tomipea'u, am kokkoba. Si'ime ini'i, Liojta nok lutu'uriat bem mabetrit, ka a aet emo ju'uneetua. Intok juka' tu'ik ae bem bo'o jooria'ea'uta, junuen ka a am jootua. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Taa ju'u bachia intok, tu'i bwiapo yojtekame, ini'i jume'e, juka' Liojta betana nok lutu'uriata a' jikkajaka, intok aet ju'uneaka intok tua yuma'isi, nat bepaasi inime'e juka' tu'ik bem bo'o jooriaka jiapsinee'uta a' teuwaa. Waate intoko, ju'u bachia, wepu'ulaka, mamni takaam bachiakame bebena. Waate intok ju'u bachia, wepu'ulaka, baji takaam bachiakame bebena. Wate intok ju'u bachia, wepu'ulaka, senu taka ama woj mamni bachiakame bebenakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ju'u Jesus, juchi inika'a seenuk, jita ta'abwikut nokaka inen jiiak: ―Teekau, Liojta che'a yo'otaka a' kateka'a betana ju'u nok lutu'uria ket, seenuk yoemta, a' waj bwiapo, tu'i bachiata a' echaka'po benasi weye ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Taa senu tukaapo si'imem kokotcheo, seenu, ju'u, junaka'a wajta atteakamta a' beje'eka aneme, junama'a kibakek intok ini'i, tiikom nasuk juyata, ka tu'ik echaka siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Junak, jume' tiikom yo'otuka intok jaibu am moao, juna'a ka tu'i juya ket junama'a tiikota nasuk yeu machiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Junak intoko jume' tekilta a' jooriame, junaka'a wajta atteakamtau sajaka a' tejwaak: “Achai, ju'u tiiko bachia em echaka'u tu'ireakai, jaisaakai ini'i ka tu'i juya ama yo'otuk”, ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ju'u junaka'a wajta atteakame: “Senu nee beje'eme inika'a yaak”, ti ameu jiiak. Junak intok wame'e a' sawe'um inen a' nattemaek: “Jaisa itepo, aman sajaka juka' juyata ka tu'ik poponnee ja'ani”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Taa aapo, inimmeu: “E'e, bwe'ituk junuen eme'e juka' juyata ka tu'ik popon pat, wame'e tiikom mak nau a' poponne”, ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“Ala che'a tu'inee eme'e ama a' su'u tojaka junaemak a' yo'otu' betchi'bo, juka' tiikota a' chuktawa'u tajtia. Chukula ne inepo, jume' tekipanoareeom, juka' juyata ka tu'ik bat bem a' chuktane' betchi'bo aman am bittuane. Inime'e lolopola a' sumaka bem a' taya'ane' betchi'bo am tejwaane. Chukula intok, bempo'im juka' tiiko bachiata, jum kari junae betchi'bo in ya'aripo nau a' tojine' betchi'bo”, ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ju'u Jesus ketchia, juchi seenuk inile benaka jita ta'abwikut ameu nokaka: ―Liojta aman teekau che'a yo'otaka a' kateka'a betana ju'u nok lutu'uria ket, seenuk inim yoemta, mojtaasa bachiata a' wajpo a' echaka'po benasi weye ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ini'i mojtaasa bachia lutu'uriapo si'ime bachiata bepa che'a ilitchi. Taa ini'i intok siweka, junama'a si'ime ili juyata bepa che'a bwe'uusi yo'otune. Intok junuen tua bwe'u juyata benane. Junuen che'a bwe'uukai, kia jume' jekapo naj kateme wikitchim a' nassa'akariampo aet a tosate. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ju'u Jesus ketchia, juchi inika'a inile benaka jita ta'abwikut ameu nokaka am majtak: ―Liojta aman teekau che'a yo'otaka a' kateka'a betana ju'u nok lutu'uria ket, jamutta reberuata, ainam bajisi yeu to'orimmak a' kuutaka junuen si'imek kittita a' boyo i'a'a benasi weye ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus, si'imeta inika'a ju'u yoemratau teuwaak junuen jita ta'abwikut nokakai. Intok aapo kaita am majtan, ka junuen jita ta'abwikut nokakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ini'i junuen tuk, juka' bat naataka Liojta betana ju'uneetuawaka yeteu nonokamta a' teuwaaka'uta a' chupne' betchi'bo, inen a' ji'ojteka'uta: Jita ta'abwikut nokaka ne yeteu nokne. Achai Liojta ika'a aniata ju'unaktek naateka waka'a ka ju'uneiyaawamta nee a' teuwaane, ti a' jiaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Junak intoko ju'u Jesus, jume' ama aneme, si'ime saka'atuasuka, aapo, kariu kibakek. Junama'a jume' a' majtim aapo'iku rukteka intok: ―Ju'u, wajpo ka tu'i juyat nokaka em teuwaaka'uta, ju'unakkiachisi itou teuwaane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Junak intok ju'u Jesus inimmeu: ―Ju'u, juka' tu'i bachiata echakame, ini'i jiba ju'u inim emo benasi yoeme. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ju'u intoko waasa, ini'i jiba ju'u ania teuwaa o'oben. Ju'u tu'i tiiko bachia, jume' Liojta yoemiam teuwaa. Ju'u ka tu'i juya bachia ket jume' bebeje'erita ea'po aman jiapsame teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ju'u intoko a' beje'eka aneka, juka' ka tu'i juya bachiata echakame, jiba ju'u bebeje'eri o'oben. Ju'u jichupawame intok, juka' aniata a' subimnee'uta a' teuwaa. Jume' intok echimuta toboktaneeme, jiba jume' ankelesim o'oben. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Juka' ka tu'i juyata nau tojiwaka intok inika'a junuen beete'po wo'otawaka a' taya'ana'a benasia ket junuen machinee juka' aniata a' subimneo. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ju'u emo benasi yoeme inim yo'otaka anekai, aapo, jume' a' ankelej nesureom naj bittuanee intok inime'e, si'imem jume' inim Liojta bichapo, watem ka tu'ik am jootuame intok jume' ka tu'isi jiapsame, nau am tojine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Inime'e intok jum jiba yuu beeteu am wo'otane. Inime'e junama'a bwanaka intok jiokot annee. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Junak intok jume'e, si'imeku lutu'uriakamta joaka jiapsame, inime'e, aman bem yo'owa, che'a yo'otaka a' kateka'po, eiyaawatchisi, tajpa'ala bittune. Eme'e intok, aet mammatebae'eteko, a' jikkajine. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Teekau, Liojta che'a yo'otaka a' kateka'a betana ju'u nok lutu'uria, ini'i, seenu, waj bwiapo, yu'in sawai tomita a' essoituka'a benasi weye. Senu intok inika'a tomita a' teakai, intok aapo jiba junama'a a' essone. Intok tua alleaka ini'i sikaa, si'imeta juka' a' jipue'uta nenkinee intok junae tomie junaka'a waj bwiata a' jinune. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Ketchia ju'u Liojta che'a yo'otaka a' kateka'a betana ju'u nok lutu'uria, seenuk, ujyooi bawepo tetam, beje'eme, pejlam teame jaiwaka a' jijinne'u benasi weye. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ini'i intok seenuk, tua beje'emta teakai, sikaa, si'imeta juka' a' jipue'uta nenkinee intok aapo, junae tomie, junaka'a pejlata beje'emta a' jinune. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Intok ketchia ju'u Liojta che'a yo'otaka a' kateka'a betana ju'u nok lutu'uria, jite'im, baweu am jimmaawaka intok inime'e, si'ime ka nanau machi kuchum a' nu'uka'a benasi weye. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Junak jume' jite'im tapunako, jume' kuchureeom, jum mayoau yeu am tojine. Inime'e intok, junama'a joteka yeu am pu'aneekai, bempo jume' tuttu'im, jum bwe'u warimpo am nu'unee intok jume' ka tuttu'im mekka wo'otane. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Junuen machine, inika'a aniata lu'uteo. Jume' ankelesim yeu katnee junuen, jume' tu'isi tawalame betana, jume' ka tu'isi aulame am na'ikimtene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Intok jume' ka tu'isi aulame, jum taji jiba yuu beete'po am wo'otane. Junama'a inime'e bwannee intok ko'okoleka emo tam kumne. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Junak intok ju'u Jesus: ―Jaisa eme'e iniat si'imekut ju'unea ja'ani ―ti ameu nattemaek. Bempo intoko: ―Jeewi achai ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Junak intok aapo, inimmeu: ―Inim seenu, ju'u Moiseejtuka'uta betana nesaurim yee majtame, ini'i, Liojta che'a yo'otaka a' kateka'a betana juka' nok lutu'uriata a' sualeka au a' majtasukai, aapo, seenu, yu'in jita beje'emta atteakamta benasia tawane. Inika'a, juka' tuttu'ik a' atteawa betana, juka' beemelata intok ka beemelata a yeu a' pua'a benasi maachi. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Junak ju'u Jesus, inime'e jaikika jita ta'abwikut a' tammachiaka yee majtasuka, ama yeu sikaa, ");
INSERT INTO yaqNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","intok jum, tua aman a' bwiaarau yepsak. Junama'a aapo, jum juriom nau yaaja'po yee majta taitek. Ju'u intoko junama'a yoemra a' uttiak intok: ―Jaksa ini'i o'ou inika'a suawata a' ta'aak. Juka' intok, ka a jootu maisi machik, jaisa ini'i a' jooa ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bwe'ituk ini'i juna'a, ju'u kutae jita joamta u'usi. Ju'u intoko a' malawa, Maria' tea. Jume' Jakoobo' teame, ju'u Josee' teame, ju'u Siimo' teame intok ket ju'u Juuraj teame, inime'e a' saaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jume' intoko a' jaamut waaim ket inim ito nasuku jo'aak. Junuen san, jaksa aapo inika'a si'imeta ta'aak ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Inia betchi'bo san, inime'e, kaitat a' jikkajibaek. Taa ju'u Jesus inimmeu: ―Juka'a, Liojta betana chukula yeu weenemtat ju'uneetuawaka yeteu nokame, si'ime tu'isi a' eiyaaka a' bitne. Taa inika'a, tua jum a' bwiaraawapo joomem betana intok jume' a' jo'apo aamak werim betana juni'i, ka junuen eiyaatune ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Intok aapo, junama'a ka jaikik juka' a jita a' joa'uta ama yaak. Bwe'ituk bempo junuen ka a' sualekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Junakriapo taewaimmet ju'u Eroorej teame, bwiaraa Kalilea' tea'po yo'o ya'atuka'u, Jesujta betana, ini'i etejoriawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aapo intok, jume' ama tekiaka, aamak anemmeu: ―Ini'i jiba ju'u Joan, yee bato'owaame tuka'u. Mukiataka jiabijtela. Kiali'ikun junuen ka a jootu maisi machik a' joone'po au yuma'atualaa ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ini'i Eroorej teame, bat naataka juka' Joanta bwij teboka intok suma'ita, yee e'eta'awa'u a' toji tebolatakai. Inika'a yaak, jamut Eroriaj teaka, bat naataka a' saila, Jeriipe' teamta jubisuka'u betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ju'u Joantuka'u, ju'u Eroorejtau inen jiulatukan: ―Ka eu lutu'uria em a' jubeka'a benasi a' jipu'une'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ju'u Eroores inika'a Joanta a' me'e tebobaek taa juka' yoemrata a' majjaen bwe'ituk si'ime, juka' Joanta, Liojta betana ju'uneetuawaka yeteu a' noka'apo junuen a' sualen. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Taa jum, juka' Eroorejta wasuktiam yuma'ariaka a' pajko'po, ju'u, junae jamut Eroriaj teamta jamut asoa, aman nunurim bichapo anwa'po a' ye'eko, junaka'a, ju'u Eroores tua a' musa'ulek. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Junuen aapo, iniat ka yumako, ka tu'ik au chupnee'u teuwaaka, jita juni'i au a' a'awaka'uta, aapo tua au a' makne'eti jiaka nokakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Junako ini'i beme jamut, a' malawa betana bat inen tejwaatakai, ju'u Eroorejtau: ―Pu'atopo, juka' yee bato'owaame Joanta koba inimi'i nee makne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ini'i, juka' junama'a che'a yo'ota Eroorejta, ka a' alleetuak. Taa aapo, ini'i, tua aet a' yuma'anee'uta a' teuwaalatuka' betchi'bo, intok jume' junaman nunurim a' jikkajilatuka' betchi'bo, a' makna' betchi'bo nesawek. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Junuen san juka' Joanta aman a' eta'ituka'po, a' koba chuktana' betchi'bo aet nesawek. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chukula ini'i koba, pu'atopo aman tojiwak intok ju'u usi beme a' makwaka, intok aapo a' malabeu a' tojak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Junak intok jume' Joantuka'uta a' majtim ama yajaka, inime'e intok juka' takaata nuk sajaka intok inika'a ma'ak. Chukula inime'e sajaka intok Jesujta tejwaak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Junak ju'u Jesus inika'a ju'uneiyaakai, jum a' ane'epo, senu bwe'u kuta kanoapo, aapola, omot kaabeta ane'u bicha yeu siika. Taa ju'u yoemra a' ju'uneiyaakai, intok ini'i, jume' bwere jo'aram betana yeu sajak, junuen bwiat aet cha'aka kat betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Juka' Jesujta junama ko'om cheptekai, yoemrata juebenak ama anemta bichak. Intok inime'e, am nak jiokolek. Intok jume' ko'okoeme, bem weiyaa'um, aapo emo am ine'etetuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Junak junama'a jaibu ka machiseo, jume' Jesujta majtim au rukteka intok: ―Jaibu tua kupte intok inim kaabe jo'aak. Im aneme am kat saune, inime'e jumun ili jo'arammeu sajaka intok bem bwa'anee'uta bem jinune' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ju'u Jesus: ―Ka utte'a bem saka'anee'u. Eme'e am ji'ibwatuane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bempo intok: ―Kaita te im jipue, mamni paanim intok wooi kuchum jiba ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Inimmeu Jesus: ―A'abo em neu am toja ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Junak intok aapo, juka' yoemrata, bajpo am joote saek intok chukula jume' mamni paanim intok jume' wooi kuchum am nu'uka, jikau bitchuka, Liojta a' baisaeka am rebekta taitek. Jume' a' majta'ummeu am bwisek. Inime'e intok junae yoemratat am na'ikimtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Si'ime juname'e ji'ibwak intok yuma'isi jatteaka taawak. Intok chukula, woj mamni ama woika bwere waarim tapunak, jume' ama yeu be'akammea. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Junama'a jume' ji'ibwakame, o'ouraa, mamni miil tukan, ketun jume' jaamuchim intok jume' illitchim ka na'ikiatakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Che'a chukula intok ju'u Jesus, jume' a' majtim, jum kuta kanoapo am ja'amutuak, bau ba'at sajaka, aapat waitana bem yaajine' betchi'bo, aapo'ik ketun juka' yoemrata a' saka'atuao. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Inime'e am saka'atuasukai, aapo ju'u Jesus, ili kawiu jikau siika, junama'a aapola, Liojtau bicha nokbaekai. Tukaariau yumakai ju'u Jesus aapola junama'a aanen. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Juka' bwe'u kuta kanoata ket bau ba'a nasukun a' weyeo, jume' ba'a biaktiam, juka' kuta kanoata naas beban. Ju'u su jeeka am nankika weyen. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jaibu abe matchuu ini'i Jesus ameu ruktek, ba'a bepa weyekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Intok junako jume' majtim, aapo'ik ba'a bepa weyemta bichakai, womtek. Intok majjaeka: ―Ini'i, tukaapo yee wom womtame ―ti chaaen. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Taa ju'u Jesus inimmeu nokaka: ―Kate'em jain ea, ineponee juna'a ju'u im aneme. Kate'em majjae ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Junak ju'u Peeo intok au nookak: ―Achai, empo tua juna'atuko, ba'a bepa weyeka em ane'u nee yebijtua'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ju'u Jesus intok: ―A'abo neu bicha weyema ―ti au jiiak. Junak san ju'u Peeo jum kuta kanoapo ko'om chepteka, intok ba'a bepa wee taitek junuen Jesujta a' ane'u au yebijbaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Taa aapo, juka' jekata utte'akamta mammatekai, majjaek intok ko'om kibak taitekai: ―Nee jinne'u'e, achai ―ti chaaen. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Junama'a sep ju'u Jesus, mampo a' bwiseka intok: ―Tua empo ka yuma'isi a Liojtat yoem ea. Jaisaaka empo ka net yoem eak ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bempo'im intok jum bem kate'epo ja'amuko, cha'atuk ju'u jeeka. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Junako jume' kuta kanoapo kateme, Jesujtau tonommea japteka: ―Tua lutu'uriapo, empo Liojta betana yoemiari ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bempo junae bwe'u bau ba'at waitana sajaka, intok bwiau Jenesaret tea'awi yeu yajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Junak ju'u yoemra, junama'a jo'aakame, juka' Jesujta tata'aakai, inime'e, junama'a bwiaraapo si'imekut jo'arammeu bicha emo naas tejwaa japtek. Intok jume' ko'okoeme si'ime jum aapo'ik ane'u au tojiwak. ");
INSERT INTO yaqNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Juname'e intok au ujbwanan, aapo'ikut, kia a' tajo'ori mayoat juni'i, bem tajtine' betchi'bo. Intok si'ime jume' aet mamtekame, emo ine'etek. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Junak intoko, waate jume' paiseom teame intok jume' Moiseejtuka'uta betana nesaurim yee majtame, Jesujtau ruktek. Inime'e, bwe'u jo'ara Jerusalen tea'a betana ama yajilamtakai, intok inime'e inen au nattemaek: ");
INSERT INTO yaqNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Jaisaaka jume' em majtim, waka'a bat naataka itom yo'owasuka'um betana ta'eewaka joowamta ka junuen a' bo'o jooria. Bwe'ituk inime'e, emo tu'utewakai, kee ji'ibwakai, mam bajimawamta ka a' jooa. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Taa ju'u Jesus inimmeu nattemaek: ―Jaisaakai ket eme'e, juka' Liojta nesaurita ka a' jooa, junuen juka' inim enchim ta'aaka au joiwalaa'uta enchim a' joobae' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bwe'ituk ju'u Lios inen a' nesawek: “Juka' em achaita intok em malata yo'oreka am aniane. Intok ket, ju'u, a' achaiwata oo a' aewata, ka tu'ik ameu aune'eti jiaka ka tu'isi ameu nokame, ini'i me'etune.” ");
INSERT INTO yaqNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Taa eme'e intok inen jiia: “Seenuk, a' achaibeu oo a' aebeu: Kannee a enchi ania, bwe'ituk si'imeta juka' in jipue'uta, Liojtau bicha nee a' na'ikiala, ti a' jiune'eti jiia, ");
INSERT INTO yaqNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","intok jabeta juni'i, a junuen jiamta, inika'a, juka' a' achaiwata oo a' aewata ka a' aniane”, ti jiia eme'e. Junuen san eme'e juka' Liojta nesauri, tua kaita a' teuwa'a benasi a' tawaalam, junuen juka' inim enchim ta'aaka, au joiwalaa'uta, junaka'a enchim joobae' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ka tu'i yoememtaka emo tu'u joame, tu'isi jiiak wa'a bat naataka Liojta betana ju'uneetuawaka yeteu nonokame, Isa'iajtuka'u, emot nokaka, junak inen a' ji'ojtekai: ");
INSERT INTO yaqNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ini'i yoemra nee emo yo'ore'eti jiaka, a' teuwaa. Taa bem jiapsim ka neu bicha waateka june'ela. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kaita'po taawa bem nau eaka nee yo'oree'u. Bwe'ituk ju'u bem yee majta'u, wepulsi inim watem betana nesau teuwaari ausu'li. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Junak intoko ju'u yoemratau ama anemtau chaaek: ―Aet mammateka nee aet jikkajine ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ju'u senuk bwa'anee'u, ka ini'i senuk ka tu'isi tawaane. Ala ju'u senuk teuwaanee'u aet yeu weyeme su, junuen Liojta bichapo ka tu'isi a' tatawaa ―ti ameu jiiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Junak intoko jume' a' majtim Jesujtau ruktekan intok: ―Jaisa empo jume' paiseom teame empo mammatek ja'ani. Em teuwaaka'uta jikkajaka ka bem emo alleetuaka'po ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Taa aapo, essoi nokpo inen am yoopnak: ―Ju'u juya, jitataka juni'i, juka' in achai, teekau katekamta ka a' echiako, chikti nawammak popontune ―ti jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kia beja em am bicha. Bwe'ituk inime'e, ka bibichaka, watem ka bibichame weiyaame benasi maachi. Intok seenuk ka bichaka, senuk ket ka bichamta weiya'ateko, jak juni'i, wojo'oku a nau ko'om wattine. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Junak intok ju'u Peeo, ju'u Jesujtau: ―Inika'a em ta'abwikut nokaka em teuwaaka'uta, ju'unakkiachisia itou a' teuwaane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ju'u Jesus inimmeu: ―Jaisa eme'e ket ka a' mammate ja'ani ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Jaisa eme'e ka aet ju'unea ja'ani, si'imeta juka' senuk bwa'anee'uta, to'onau bicha a' weye'po, chukula intok ket, inika'a, takaapo yeu a' weenee'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Taa ju'u, senuk teuwaanee'u aet yeu weeneme, jiapsiu yeu weye, intok ini'i juna'a ju'u, ka tu'isi a' tatawaame. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bwe'ituk jiapsi betana inen ju'u ka nanau machika ka tu'i eeri yeu weama, yee su'apeewame, jamutta ka a' jubeka juni'i, aamak emo tu'uriwame oo ju'u si'ime tiusi machika ka tu'ik joowame. Jita etbwawame. Ju'u aa noki'ichia intoko ka lutu'uriata yetet nok sasakawame, Liojta beje'eka, ka tu'ik teuwaawame. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ini'i weyeme juna'a junuen ju'u senuk ka tu'isi tatawaame. Taa ju'u, kee ji'ibwaka, emo te'ochiaka mam bajimawamta ka a' joowame, ka ini'i juna'a, ju'u senuk ka tu'isi tatawaame. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Junama'a yeu sikaa, ju'u Jesus bwiaara Tiiro'otea'u intok Siron tea'u bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Intok senu jamut, bwiaraa Kananea' tea'po jometa, ini'i junama'a bwiaraa jo'aaka, Jesujtau yepsak: ―In yo'owa, Labiituka'utat yeu simria, nee jiokole'e ―ti au chaaek―. Bwe'ituk ju'u in jamut asoa, bebeje'eri ka tu'i jiapsi aet aane intok tua jiokot maisi au bicha ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Taa ju'u Jesus inika'a kaita a' yoopnak. Junak intok jume' a' majtim au yajaka intok inen au ujbwanak: ―A' simne' betchi'bo au nooka achai. Bwe'ituk itot cha'aka weyeka, jiba chai sime ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Junak intok ju'u Jesus, ju'u jamuttau: ―Ju'u Lios, jume' bwalam chiktulame bebenammeu Ijra'el yoemratau jiba nee bittuari ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Taa ju'u jamut au rukteka intok au tonommea kikteka: ―In yo'owa, nee ania'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ju'u Jesus intok: ―Ka tu'ine, jume' paanim usim bwaa'ea'um, am u'aaka intok jume' chu'um am mikpo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Taa junuentaka juni'i, aapo ju'u jamut: ―Jeewi in yo'owa, taa kia jume' chu'um juni'i, bem teekom ji'ibwaa'po, jume' reebeim ko'om watteme bwabwa'ee ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Junak intok ju'u Jesus, iniau: ―Jeewi, tua empo Liojta a suale, em ea'po aman eu chupne ―ti au jiiak. Intok jiba junama naateka ju'u a' jamut asoawa, yuma'isi au ine'etek. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ju'u Jesus junama'a yeu sika intok Kalilea' tea'po, bwe'u bau ba'a bwikola weyen. Chukula ili kawiu jikau sikaa, intok junama'a yejtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yoemra, juebenaka jum a' ane'epo au yajak. Intok inime'e, jume' ka rejteme, jume' ka bibichame, jume' ka nokame, jume' ka emo mam yekame intok waate juebenam ko'okoeme amemak weiyaakai, inime'e ju'u Jesujta bichapo nau tojiwak. Aapo intoko emo am ine'etetuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Junuen san beja ju'u ama aneme yoemra a' uttiaka a' suum eiyaak. Jume' ka a nokame, noktuawame, jume' mam lolo'im tu'ureame intok jume' lolo'im am rejte'epo intok jume' ka bibichame am bittuawame, inime'e bichakai. Intok juka' bem yo'owata, Ijra'el tuka'uta a' achai Liojta a' yo'ori japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Junak intoko ju'u Jesus, jume' a' majtimmeu chaaeka intok: ―Inika'a yoemrata ne tu'isi jiokole bwe'ituk jaibu baji ta'apo inim nemak aane. Intok inime'e bem bwa'anee'uta kaita nunu'ubwa. Kanne junuen, ka ji'ibwakame, bem jo'au bicha am saka'atuabae, junuen ka inime'e jum bo'ot bem tebae wattine' betchi'bo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jume' a' majtim junak: ―Jaksa itepo, si'ime inia yoemratau yuma'ik bwa'awamta nu'unee inimi'i kaabeta jo'aaka'po ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ju'u Jesus inimmeu: ―Jaiki paanimsa eme'e nunu'ubwa ―ti ameu nattemaek. Bempo intok: ―Woo busani, intok wate ili kuchum ―ti jiaka a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Junak aapo, juka' yoemrata ama anemta, bwiapo am jote'esaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jume' woo busan paanim intok jume' kuchum am nu'uka, intok Liojta a' baisae'uta teuwaak. Chukula am rebektaka intok jume' a' majtimmeu bicha am bwisek. Inime'e intoko ju'u ama yoemratat am na'ikimtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Si'ime inime'e ji'ibwak intok yuma'isi jat teaka taawak. Chukula ketun jume' reebeim yeu be'eekammea woo busan waarim tapuniawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Junama'a ji'ibwakame, ju'u o'ouraa, naiki miil tukan. Ketun jume' jaamuchim intok jume' illitchim ka na'ikiatakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chukula ju'u Jesus juka' yoemrata saka'atuako aapo kuta kanoau ja'amuka intok jum bwiaraa Maklaala' tea'u bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jume' paiseom teame intok jume' saauseeom teame, Jesujta bitbaeka au noitek. Intok junuen aapo'ik jitat a' ji'optuabaekai, teeka betana machilaata, a jita a' joa'uta am bittuasaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Taa aapo inime'e inen yoopnak: ―Kupteo, eme'e: “I'an tu'ibae jume' taewaim, bwe'ituk sikiisi cha'aka ju'u ania”, ti eme'e jijia. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ketwoo tana intok eme'e: “I'an ka tu'ibae jume' taewaim, bwe'ituk ju'u ania sikii intok naamuk”, ti eme'e jijia. Ka tu'i yoememtaka emo tu'u joame, eme'e juka' aniata ju'u a' machiaka'ue taewaim ju'une'eiyaa. Taa eme'e i'an taewaim betana juka' machilaata a' teuwaa'ut eme'e ka a aet ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ini'i ka tu'i yoemra intok ka wepulsi Liojta yo'oreme senu machilaata, Liojta a jita joa'uta bitbae. Taa kaita intok bittuanaa, kia juka' Jonajtuka'uta juka' au yeu a' sika'u benak machilaata jiba bittuanaa ―ti ameu jiiak. Intok inime'e ama su'u tojaka, siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Junak jume' a' majtim, ju'u bwe'u bau ba'ata beas yajaka, paanim koptalamtukan. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Junak intok ju'u Jesus: ―Eme'e a' mammatenee jume' paiseom intok jume' saauseeom teame ju'u reberuuata benaka, ka lutu'uriata bem yee majta'u betana emo suuakai ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jume' a' majtim: ―Ka paanim itom nu'upaka' betchi'bo aapo junuen jiia ―ti naas nau jiu japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ju'u Jesus amet ju'une'eaka intok: ―Jaisaaka eme'e paanim ka emo nu'upak ti jiia ―ti ameu jiiak―. Tua em ka yuma'isi Liojtat yoem ea ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jaisa eme'e, i'an tajtia kee ju'unea intok ka au waate ja'ani, jume' mamni paanim, jume' mamni miil yoemem in amet na'ikimteka'ummewi intok jaiki bwere warim, jume' yeu be'ekame tapuniawakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Intok jaisa eme'e kia ka au waate ja'ani, jume' woo busan paanim betana, jume' naiki miil yoememmet in na'ikimteka'ummewi juni'i, intok jaiki bwere warim eme'e toboktak. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Junuen, jaisaaka eme'e ka aet ju'uneak, ka paanimmet in emou noka'apo, jume' paiseom betana intok saauseeom teame betana enchim emo suua saeka intok ju'u reberuuata benasi machik betana, nee emou nokao ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Junak beja inime'e aet ju'uneak, Jesujta ka wame'e paanim betana reberuat bem am suuane' betchi'bo ameu a' nokaka'po ala, jume' paiseom intok jume' saauseom teame, bem yee majta'u betana junaet a' noka'apo. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Junak ju'u Jesus, bwiaraa Sesarea piliipo' tea'u yepsakai, aapo jume' a' majtimmeu: ―Ju'u yoemra, inia inim yoemtat nokaka, a' jabesa'ati jiia ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Inime'e intok: ―Waate, enchi ju'u yee babatoowame Joantuka'u tiia. Wate intoko enchi ju'u Eliaj tuka'u ti jiia. Ketunia waate enchi ju'u Jeremiaj tuka'u oo jume' bat naataka Liojta betana ju'uneetuawaka yeteu nokame betana seenuk ti jiia. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Junak intok aapo: ―Eme'e intok, nee jabesa'ati jiia ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Junak intok ju'u Simoo Peeo' teame: ―Empo juna'a ju'u Krijto yeu pu'ari, ju'u Lios jiba yuu jiapsamta u'usi ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ju'u Jesus inika'a inen yoopnak: ―Tua empo alleenee Simoo, ju'u Jonaj teamta u'usi. Bwe'ituk inika'a ka inim senu enchi a' tejwaala. Ala ju'u in yo'owa, teekau jiapsame enchi aet ju'uneetuala ―ti jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Inepo intok ne Peeo ti enchi teuwaa, intok inepo ne jiba inia lutu'uriae em teuwaaka'ue, jume' Liojta yoemiamtuneeme, ae am koba'a i'a. Intok kia ju'u kokkowame juni'i ka ae bepa utte'aka a' koba'ane. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ineponee ket inim teekau, Liojta che'a yo'otaka a' kateka'u yajineeme betana enchi am tekil makne. Juka' inim bwiapo em ka yee joo i'a'uta ket aman teekau ka joonaa. Intok juka' inim bwiapo em yee joo i'a'uta, ket aman teekau joonaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Junak intoko ju'u Jesus, inime'e a' majtimmet nesawek, aapo'ik Krijtotuka'po aman, kaabetau am montine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Junama'a naatekai ju'u Jesus, jume' a' majtim senu weemta machisi am tejwaa taitek, a' utte'atuka'po amani, aapo'ik Jerusalen tea'u a' weene'po intok junaman te'opopo ju'u che'a yo'owe intok jume' junama'a junae yoemratau yo'owem intok jume' Moiseejtuka'uta nesauri ji'ojteim yee majtame betana aapo'ik tua jiokot a' ya'anaa'po. Inimmeu, juname'e a' me'ene'eti jiiak. Taa ket, baji taewaita weyeo, aapo'ik a' jiabijtene'po betana am tejwaak. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Junak intoko ju'u Peeo, omola a' nunuka intok batte au omti nokaka a' sua tejwaa taitek: ―Kaibu ta'apo achai, jakwoo juni'i kaachin ini'i, junuen eu yeu weene ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Taa ju'u Jesus, amau kuakteka, Peotau inen jiiak: ―Kat neu suua, empo, ju'u bebeje'eritumta benasi anekai. Bwe'ituk kaita'ee nee a jootua. Empo juka' Liojta tu'uree'ut ka ale benasi ea. Ala kia empo inim yoemem benasi ea jiba ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Junak intok ju'u Jesus, jume' a' majtimmeu: ―Jabe senu nemak eebaeme, ini'i, inim aapo'ik betchi'bo jiba a' jiapsa'uta a' koptane. Intok nemak a' ea' betchi'bo mukneeka juni'i, jiba nemak eene ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bwe'ituk wa'a inim aapo'ik betchi'bo jiba, binwa jiapsibaeme, juna'a jiba yuu a' jiapsinee'uta a' ta'arune. Taa wa'a, nemak a' eebae' betchi'bo, ka inien aapo'ik betchi'bo a' eiyaakame, ini'i, jiba yuu a' jiapsinee'uta a' bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bwe'ituk inim seenu, jitasa tu'ik jajamnee inim si'ime aniat juka' beje'emta yo'okai intok tu'ik bichaka taa chukula, Liojtau a' weenee'u ka au a' lutu'uriatukai. Ini'i ju'u jiba yuu a' jiapsine' betchi'bo tua kaita a nenkine. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bwe'ituk ini'i emo benasi inim yoeme, a' achai Liojwaa, yo'orisi a' machiaka'a benasi aapo junaen, intok jume' a' ankelesimmak a'abo yebijne. Intok junako aapo, inim, we'epulaim, junuen bem ya'ariaka'po aman, tu'isi oo ka tu'isi au a' chupa'ane. ");
INSERT INTO yaqNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tua lutu'uriapo ne inen emou jiia, i'an, inim wate aane, inime'e, juka' inim emo benasi yoemta, junuen yo'orisi machika intok che'a yo'otaka a' yebijnee'uta, bempo'im ka a' bichako ka bem kokkonee'u ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Busan taewaim sikaa, ju'u Jesus, juka' Peota intok juka' Jakoobo' teamta intok juka' Joanta, ju'u Jakoobo' teamtamak weri, nunuka intok aapo, aapola amemak senu mekka jikat kawiu jikau amemak siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Junaman intok aapo ame bichapo ta'abwisi au bittebok. A' pujbawa ta'ata benasi machisi tachiriakan. Ju'u intok a' tajo'oriwa, tossaala tachiriata benasi aayuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Intok bempo, junama'a sep su, juka' Moiseej teamta intok juka' Eliaj teamta, ju'u Jesujtamak etejome bichak. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Junak intok ju'u Peeo, Jesujtau: ―Achai, tua su te tu'isi im aane. Enchi junen eao, itepo baji ili juya karim te ya'ane. Ee betchi'bo senuk, Moiseejta betchi'bo senuk, intok Eliajta betchi'bo intok ket seenuk ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ket juka' Peota nokao su, naamu, tua beojkoka am roptak. Junama'a namupo betana intok, jiawai jikkajituk: ―Ini'i juna'a ju'u in yoemia in nake'u, ae betchi'bo tua in allea'u. Aapo'ik eme'e a' nok jikkajine ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Inika'a jikkajakai jume' a' majtim yeu a' pu'arim, bwiapo pepetala to'otek intok inime'e tua womtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Junak intoko ju'u Jesus ameu rukteka, amet mamteka intok: ―Japte'em bu ―ti ameu jiiak―. Kate'em majjae. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Inime'e juchi aman bitchukai, kaabeta intok ama bichak, juka' Jesujta aapolaik jiba. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bempo'im junae kau betana ko'om kateo, ju'u Jesus amet nesawek: ―Inika'a enchim bittuawaka'uta, kaabetau eme'e a' etejone. Chukula, juka' inim emo benasia yoemta kokkoarim nasuk a' jiabijtesuk ju'ubwa a' teuwaane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Junak intok jume' a' majtim: ―Jaisaaka junen, jume' Moiseejtuka'uta nesaurim yee majtame, a' utte'a ti jiia, juka' Eliaj teamta bat a'abo a' yebijnee'u ―ti Jesujtau nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Junak intok ju'u Jesus inime'e inen yoopnak: ―Lutu'uria juka' Eliaj teamta, utte'a, bat a' yebijnee'u. Intok inika'a si'imeta a' tu'utene'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Taa inepo ne, juka' Eliajta jaibu a' yebissuk ti jiia. Bempo intok a' jabetuka'po ka a' ta'aak. Ala bempo si'imeta juka' jiokot machik bem au ya'abae'uta au yaak. Ket jiba junaeni ju'u inim emo benasi yoeme, jiba inime'e betana jiokot ya'atune ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Junak intok jume' Jesujta majtim aet ju'une'eak, Jesujta, ju'u Joan, yee babatoowamta betana ameu a' noka'apo. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Chukula junak, bempo'im jum anwa'u am yajakai, seenu, junaman Jesujtau rukteka, ini'i ket au tonommea kikteka intok: ");
INSERT INTO yaqNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Achai, inika'a in ou yoemiata nak jiokole'e. Beja su, aapo epileepsia' teamtae ko'okoeka weeche. Intok tua unnaa jiokot au bicha. Juebenasi tajipo oo ba'apo weeche. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A'abo ne ime'e em majtimmeu ne a' tojak taa bempo ka a au a' ine'etetua machi ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ju'u Jesus inen a' yoopnak: ―Ou, eme'e, kaita sualeka intok tua ka tu'i yoemra. Jakwoo tajtiasa tua nee inien enchim bitne. Jakwoo tajtiasa tua ne jiokot emomak anne. Juka' usita em a'abo neu toja ―ti jiiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Junak ju'u Jesus, ju'u bebeje'eri ka tu'i jiapsitau kuttipo au nokaka intok inika'a, ju'u usi o'outat yeu a' simtuak. Junuen ini'i junama'a sep tu'urekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chukula jume' Jesujta majtim, omola sajaka, Jesujtamak etejoko intok bempo: ―Jaisaaka tua, itepo, juka' ka tu'i jiapsita ka a yeu a' beebak ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ju'u Jesus inimmeu inen jiiak: ―Bwe'ituk eme'esu tua ka a Liojtat yoem ea. Tua lutu'uriapo ne inen jiia, eme'e, kia ju'u mojtaasa bachiata belleekik juni'i, Liojtat a enchim yoem ea'u emot ayuko, inia kawiu eme'e: “Inim yeu sikaa, omot yejtene”, ti au jiu ean. Ini'i kawi intok omot bicha weene. Junuen eme'e lutu'uriapo Liojtat a yoem ea'ateko, kaita emo betchi'bo obiachine. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Taa inile benaka ka tu'i jiapsi, ini'i, ka ji'ibwawaka Liojta yo'oriwaka intok au bicha emo nokriawamtae jiba a yeu beeptu ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ketun jum bwiaraa Kalilea' tea'po nau rejtekai, ju'u Jesus, juka' inim yoemta, jume' inim ka tu'i yoemem mampo a' su'u tojina'ati jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Intok juname'e a' me'eenee'u. Taa ket, baji taewaim sikaa, a' jiabijtenee'u ti jiiak. Ini'i, ju'ubwa a' teuwaari, bempo'im tua sioktuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Juka' Jesujta intok jume' yeu a' pu'arim, bwe'u jo'ara Kapernaum tea'u yeu am yajako, junama'a jume' te'opota betchi'bo tomita nau totojame, ju'u Peotau yajaka intok: ―Ju'u enchim majtame, jaisa tomita te'opota betchi'bo ka a beje'etua ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ju'u Peeo intok: ―Jana'aka ―ti jiiak. Junako, juka' Peota kariu a' kibakeko, ju'u Jesus bat au nonokak: ―Jaisa eu maachi Simoo ―ti jiakai―. Jume' inim bwiapo che'a yo'o ya'arim, inime'e, juka' ya'uraatau bicha tomita weyemta, intok juka' jita'apo yee aniabaawaka tomita, jabemmeusa junuen a' waata, jume' ama bem bwiaraapo jomemmewi oo jume' ka junama'a bwiaraapo joomemmewi, ja'ani ―ti au nattemaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ju'u Peeo: ―Jume' omot bwiaraa yoemratau ―ti a' yoopnak. Ju'u Jesus junak: ―Junuentuko, jume' ama bem bwiaarapo yoemem, kaita beje'etuane ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Taa junuen, kaabeta ka alleetuabaekai, jum bau ba'au sikaa, jume' kuchum ammea yeu wiikwame ba'au jimmaane, intok juka' bat ama cha'atukamta yeu wikne. Junae tenpo empo tosai tomita, tua au yuma'ik teune. Juna'a, in beje'etua'ea'uta intok em aman toji'ea'uta, junae aman am beje'etuane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jiba junako, jume' Jesujta majtim au rukteka intok: ―Jum teekau, achai Liojta che'a yo'otaka a' kateka'u, jabesa juna'atunee ju'u che'a eiyaawaka bitnaame ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Junak intok ju'u Jesus, ili usi o'outau chaaeka, ame nasuk a' kechaka ");
INSERT INTO yaqNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","intok: ―Tua lutu'uriapo ne inen emou jiia, ju'u ka tu'ik betana ka enchim emo temaeka intok inia betana junuen, ka jume' ili usim benasi enchim eao, eme'e, jum Liojta che'a yo'otaka kateka'u kaibu aman jiapsine ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Junuen san, jum Liojta che'a yo'otaka a' kateka'u, wa'a che'a ama eiyaatuneeme, ini'i, inim che'a bepa emo eiyaawamta koptaka intok junaen inia ili usita benasi eame, juna'atune, wa'a che'a eiyaanaame. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Wa'a intoko, juka' ile benasi ili usita, nee a' suale' betchi'bo, tu'isi a' mabetakame, nee junen mabetne. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Jabetaka juni'i, inime'e illichim nee sualeme betana, senuk, ju'u ka tu'ik a' ya'atuakame, che'a au tu'i ean, inika'a, bwe'u tetata ae tuttujwamta, kutanaapo aet sumawaka, jum bawepo che'a mekka ko'om a' jimmaawako. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jume' inim bwiapo jiapsame betchi'bo, tua ka tu'i, inim jiapsame, ju'u ka tu'ik jootuame ayukai. Ini'i jiba aunee o'oben. Taa tua jiokot au machine, ju'u o'outau, inika'a ka tu'ik yee jootuamtawi. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Inien san empo, em maammea oo wokimmea, jita ka tu'ik ya'ane'eteko, am chuktaka intok mekka am su'u tojine. Bwe'ituk che'a tu'ine, mam lo'itaka oo wok lo'itaka jum jiba yuu jiapsiwa'u em annee'po. Intok junuen, yuma'im mamaka intok yuma'im wokeka intok jum tajita jiba yuu beete'u em anne'po bepa. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Intok empo em pusimmea ka tu'ik ya'ane'eteko, juname'e yeu wikeka, mekka am su'u tojine. Bwe'ituk che'a tu'inee wepu'ulaim puseka jum jiba yuu jiapsiwa'u em annee'po. Intok junuen, yuma'im puseka, jum tajita jiba yuu beete'u em annee'po bepa. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Inime'e illichika nee sualeme betana, kaabem omola am eiyaane. Bwe'ituk inime'e betana jume' ankelesim am suuame, jum teekau, Liojta aman jiapsamtau jiba am ane'u ―ti ne a' teuwaa―. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bwe'ituk ju'u inim emo benasi yoeme, ini'i, jume' inim ta'aruim benasi jiapsame am jinne'ubaeka yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Jaisa emou maachi ini'i, seenu, inim mamni takaam bwaram jipueka, intok ini'i, juname betana seenuk ta'arukai, jiba tua aapo, jume' naiki taka ama woj mamni ama batan bwaram, jum kaupo to'o sikaa, intok juka' chiktulata a' jariune. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Intok ini'i, junaka'a a' teakai, jiba su tua, ini'i junae betchi'bo che'a alleene, waate jume' naiki taka ama woj mamni ama batanika ka emo ta'arukame bepa. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Junuen san ketchia, ju'u enchim yo'owa Lios, teekau jiapsame, inime'e illitchim betana, wepu'ulaik juni'i, kaabeta ta'aru i'a ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Seenuk, Krijtopo emak werik ka tu'ik eu a' yaako, aapolaiku mak etejonee intok juka' ka amma'ali a' aula'u betana a' tejwaane. Inika'a intok tu'isi enchi a' nok jikkajako, junuen inika'a Krijtopo emak werikumak empo juchi tu'isi nau eaka jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Taa inika'a ka junuen enchi aet nok jikkajako, empo seenuk oo wooim nunune, junuen juname'e, si'imeta junama'a jikkajaka, junaet lutu'uriata bem ju'uneene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Taa inika'a, juname'e juni'i ka a' nok jikkajako, junak si'ime jume' te'opopo nau anemmeu a' teuwaane. Intok inika'a, kia juname'e si'imem juni'i ka am nok jikkajako, junako, itepo, inika'a ka Liojta sualemta benasi a' eiyaanee oo kia seenuk, ya'uraatau bicha juka' tomita weyemta nau a' totojame betana a' weye'e benasia. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Tua lutu'uriapo ne inen emou jiia, inim bwiapo si'imeta juka' enchim ka yee joo i'a'uta, ket aman teekau ka joonaa. Intok juka' inim bwiapo enchim yee joo i'a'uta, ket aman teekau joonaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ketchia inen ne emou jiia, inim, emo betana wooika Liojtau bicha enchim a'aubae'ut nau eaka enchim emo nokria'ut, ju'u in yo'owa, teekau jiapsame junuen emou a' chupa'ane. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bwe'ituk jum woika oo bajim, nee yo'oribaeka bem nau ane'epo, junama inepo ame nasuk annee. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Junak intok ju'u Peeo, ju'u Jesujtau sika au nattemaek: ―Achai, juka' Krijtopo nemak werik, jaikisisa jita ka tu'ik neu a' yaako intok inepo junuen ne inika'a jiokoine. Jaisa woo busanisia ja'ani ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus inika'a: ―Kannee junuen woo busanisia ti eu jiia, ala, aapo'ik jaikisia junuen enchi a' jiokoi i'a'abeekisia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Inia betchi'bo, Liojta aman teekau che'a yo'otaka a' kateka'a betana ju'u nok lutu'uria, inim seenuk yoemratau che'a yo'o ya'ata, jume' aapo'ik tekoka intok a' wikiriammak au a' tu'ute'e benasi maachi. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Inika'a, junaka'a ju'ubwa a' naateo, senu juebena miiyoonim a' wikiriakai au yeu tojiwak. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Junak, juka' ama tekokamta, tua kaitae a' beje'etua machiako, ju'u a' tekowa, inika'a, senuk omot a' atteane' betchi'bo au a' nenki tebok chikti a' jubimmake intok a' yoemiam intok si'imeta juka' a' jipue'u mak junuen junae, juka' a' wikiriawa'uta a' beje'etuana' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Junak intok ju'u a' tekokame, junau tonommea kikteka intok au ujbwanak: “Achai, ka seej chukti eaka, nee bo'o bitnee intok inepo si'imeta ne beje'etuane”, ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ju'u a' tekowai, inika'a, tua a' nak jiokoleka intok juka' aapo'ik a' wikiria'ut a' jiokoek, intok a' su'u toji tebok. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Taa ini'i tekokame, jiokoliwakame, junama'a yeu sikaa, seenuk aamak tekokamta teak. Inika'a ka jaikik a' wikiriamta. Junaka'a kuta naat a' bwiseka, a' jiabij meme'aaka: “Juka' em nee wikiria'uta sep nee beje'etua”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Junak intok ju'u aamak tekokame, au tonommea kikteka inen ujbwanak: “Achai, ka seej chukti eaka nee bo'o bitnee intok inepo si'imeta ne enchi beje'etuane”, ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Taa ini'i wikiriawame, ka a' jiokolibaek. Ala a' nuk sikaa, yee e'etawa'po a' eta'atebokai, inika'a a' beje'etuasu'u tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Waate jume' inimemak tekokame, inika'a ju'uneiyaakai, tua ka alleak. Intok inime'e, junae tekobeu sajakai, si'imeta junaka'a yeu sikamta au etejok. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Junako ju'u tekowai, junau chai tebok intok inen au jiiak: “Empo tekipanoareo ka tu'ik jiapsekame, inepo si'imeta juka' em nee wikiria'uta ne enchi aet jiokoek, em junuen jiokot jiaka em neu nokaka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Empo juni ket juka' emak tekipanoamta, in enchi jiokoleka'a benasia, jiba junuen a' jiokoi machiakan”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Intok juna'a tekowai, tua ka alleaka, junaka'a, jiokot a' ya'a tebok juka' a' wikiria'uta si'imeta a' beje'etuasu'utajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ju'u Jesus intok: ―Jiba inien ket emomak aunee ju'u in yo'owa, teekau katekame, enchim, jume' Krijtopo emomak werim we'epulaka, ka tua junen jiaka, enchim emo jiokoeko ―ti jiaka ameu noksuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ju'u Jesus, chukula inika'a teuwaasukai, jum bwiaraa Kalilea' tea'po yeu sikaa, jum bwiaraa Jurea' tea'po, batwe Joran tea'po, ta'ata ama yeu we'e betana aman yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yoemra juebenaka aamak sajak. Intok junama'a aapo, wame'e ko'okoeme emo am ine'etetuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Junak intok jume' paiseom teame, waate Jesujtau ruktek junuen jita'apo a' ji'optuabaekai intok inime'e: ―Jaisa seenu, jita betchi'bo juni'i, juka' a' jubiawata jimmaa betchi'bo, ya'uraatau, junae betchi'bo ji'osiam a ya'atebo ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Inime'e aapo inen yoopnak: ―Jaisa eme'e jum Liojta nok lutu'uria ji'ojteita kee a' bicha ja'ani, inen, juka' che'a bat naataka am ju'unaktekamta, o'outa intok jamutta, aapo'ik am ju'unakteka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Inen ket ji'ojtei: “Inia betchi'bo san, ju'u o'ou, juka' a' achaiwata intok juka' a' aewata am to'o simnee intok junuen ju'u a' jubiawamak jiapsine. Intok inime'e junuen woikai, wepul yoemta beasi tawane.” ");
INSERT INTO yaqNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Junuen san inime'e jaibu ka wooi benane, ala wepul yoemta benakai, inia betchi'bo ju'u inim yoeme, juka' Liojta wepu'ulai benasi a' ya'ari, kaachin a am na'ikimtene ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Junak intok inime'e: ―Jaisaaka junen ju'u Moiseejtuka'u, juka' jubiarita ya'uraatau ji'osia ya'arita a' makaka junae a' jimmaa betchi'bo aet nesawek ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ju'u Jesus inimmeu: ―Jiba junuen, tua ka enchim yee nak jiokole' betchi'bo ju'u Moiseejtuka'u junuen enchim jujubim a enchim am wo'otane' betchi'bo enchim a' tu'uteriak. Taa che'a bat naataka ka junuen weyen ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Inepo intok ne inen emou jiia, ju'u a' jubi jimaakame, taa ini'i ka juka' a' juubi ta'abwiku mak ka tu'isi a' tawako, intok ini'i ta'abwik jubeko, ka tu'ik ya'arine. Intok kia ju'u jamutta jimaarita a' jubeko, ini'i ket ka tu'ik ya'arine. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jume' Jesujta majtim junak inen au jiiak: ―Inika'a weyemta inien machiako, ju'u kunawaita a' jubimake, senuk betchi'bo ka jujupwame che'a tu'i ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ju'u Jesus inimmeu: ―Iniat ka si'ime a aet ju'unea. Kia wame'e wepulsi Liojta betana a' ju'uneiyaatuawame jiba ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Waatek ka nanau machik ayukamta betchi'bo, wate o'owim ka jujjube. Waate ka a jubineeka junen yoemem. Waate intok ket, inim yoemem betana junuen ya'ari ka jujjube. Intok ketun waate, juka' Liojta che'a yo'otaka a' kateka'u betana juka' nok lutu'uriata che'a bem eiya' betchi'bo ka jujubeka tatawa. Inika'a a' chupa'aneeme a' mabetne. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Junak intoko waate ili uusim, ju'u Jesujtau tojiwak, aapo'ik amet mamteka intok Liojtau bicha inime'e a' nokriane' betchi'bo. Taa jume' Jesujta majtim, jume' aman au am tojame, am beje'eka nok japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Taa ju'u Jesus inen jiiak: ―Ake'em am su'u toja jume' ili uusim, ela'pom a'abo neu katne, intok iniat ka ameu suuane. Bwe'ituk Liojta che'a yo'otaka a' kateka'u, aman lutu'uriakame, inime'e benasi emo eetuame juname'e ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Intok aapo, juname'e ili usimmet mamteka intok am nokriasuka, intok chukula, junama'a a' ane'epo yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Senu ju'ubwa yo'otume Jesujta a' bitbaeka au siika intok ini'i: ―Tu'i yoeme, yee majtame. Jitasa inepo tu'ik yaaka junuen juka' jiba yuu jiapsiwamta a' bitne ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ju'u Jesus iniau: ―Jaisaaka empo tu'i yoeme'eti neu jiia. Kaabe intoko, wepu'ulai jiba tu'ika jiapsame. Ini'i intok ju'u Lios juna'a. Taa empo jiba yuu jiapsiwamta a' bitbae'eteko, Liojta nesaurim bo'o jooriaka jiapsine ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ju'u ju'ubwa yo'otume: ―Jitaa nesaurim ti au jiiak. Ju'u Jesus iniau: ―Ka yee sussu'ane. Jamutta ka jubeka, ka aamak emo tu'urine. Ka jita e'etbwane. Ka aa noki'ichiata yetet nonokne. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Juka' em achaita intok juka' em aewata, am yo'orine. Intok empo juka' ele benasi yoemta, em emo eiya'a benasia a' nakne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ju'u ju'ubwa yo'otume intok: ―Si'imeta inika'a inepo in ili usituka'po naatekai ne a' chupa'i. Jitasa ketun neu be'ee ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iniau inen jiiak ju'u Jesus: ―Empo yuma'isi Liojta ea'po jiapsibae'eteko, sikaa, si'imeta juka' em jipue'uta nenkakai, jume' kaachin emo ania machim a' mikne. Junak empo, teekau, Liojta yo'otaka a' kateka'u, che'a si'imek bepa beje'emta intok tu'ik a' bitne. Chukula empo a'abo neu sikaa, intok nemak eaka jiapsine ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Taa junak, juna'a ju'ubwa yo'otume, inika'a jikkajaka, tua siokaka, ama yeu siika. Bwe'ituk unnaa yu'in jita tu'ik atteakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Junak ju'u Jesus, jume' a' majtimmeu: ―Tua nee lutu'uriapo ne inen emou jiia, ju'u yu'in tomekamtau tua a' obiachiaka'po, inika'a, teekau, Liojta che'a yo'otaka a' kateka'u a' yebijnee'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Inika'a ne juchia emou a' teuwaa, juka' naikim wokekamta, kameeyo' teamta, ji'ikia pusimpo yeu a' weenee'u, che'a ka a' obiachiaka'u, juuka'a yu'in tomekamta, jum Liojta che'a yo'otaka kateka'u a' yebijnee'u bepa ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Inika'a jiikkajakai, jume' aapo'ik majtim tua aet suum eak. Intok bempo: ―Junuentuko, jabesa tua a jinne'uitune ―ti emo naas tetemaen. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ju'u Jesus am bitchuka: ―Inim jume' yoemem, iniau ka yuuma. Taa ju'u Lios, si'imeku yumaka, a' jooa ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Junak ju'u Peeo: ―Achai, itepo te si'imeta juka' itom atteasuka'uta a' to'o saka'i, intok itepo emak eaka te emak rejte. Jitasa tua itepo mabetne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus inime'e inen yoopnak: ―Tua lutu'uriapo ne inen emou jiia, junak, chukula taewaimmet, si'imeta bemelasi a' ayuko, juka' inim emo benasi yoemta che'a eiyaawatchika yo'otaka a' yejteko, junak eme'e, jume' i'an inim nemak eaka, nemak rejteme, ketchia woj mamnika intok wooika, jume' che'a yo'owem jojoye'po eme'e ama amet jote'ene, junuen jume' woj mamni ama wooika, Ijra'el tuka'uta betana yoemrata a' ya'uraa bittua betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Intok si'ime wame'e inim bem karim to'o sajakame, oo jume' o'owimtaka oo jaamuchimtaka jume' amemak werim, oo kia a' achaiwata oo a' aewata oo a' jubiawata oo jume' bem yoemiam, oo ket bem waj bwiam, junaka'a nemak bem ea' betchi'bo junaka'a to'o sajakai, inime'e, junaka'a mamni takaasi junae beekik mabetne, intok ketchia, chukula, jiba yuu jiapsiwamta bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Taa juebenaka jume' i'an inim che'a eiyaawaka bitwame, junak che'a ka eiyaanaa. Wate intok, jume' i'an inim che'a ka eiyaawaka bitwame, junak che'a eiyaanaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Ju'u, teekau, Liojta che'a yo'otaka a' kateka'a betana nok lutu'uria, ini'i, seenuk waj bwiata atteaka inika'a ketwoo yeu sikaa, pa'asim chuktaneeme a' takeaseka'a benasi weye. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ini'i, inime'e tekipanoareeom, senu taka tosai tomim taewapo am beje'etuarokaka, junuen ameu nookak. Intok inime'e junen eako, tekipanoa betchi'bo a' wasau am bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Che'a chukula, ketwoo, jumak batanim jia'apo yeu siika intok juchi waatem junama'a jita nenenkiwa'po, kia beja kaita joame bichak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Inimmeu: “Eme'e ket jum pa'asim in chukta tebo'u sajaka tekipanoane. Inepo intok, ne tua enchim koba'a'ea'uta enchim makne”, ti ameu jiiak. Intok bempo junak ket aman sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ju'u wajta atteakame, abe luula yejteo juchi yeu siika, intok chukula ketchia che'a kupteo, bajim jiao yeu sika jiba junaen aayuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Intok ketchia, che'a kupteo, jumak mamnim jia'apo, juchi jum jita nenenkiwa'u bicha yeu siika. Intok juchi waatem junaman, kaita joame bichaka intok inimmeu: “Jaisaaka eme'e, si'ime taewata ka tekipanoaka inim aane”, ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Inime'e: “Bwe'ituk kee jabe itom takea machi”, ti au jiiak. Aapo junako: “In wasau sajaka ket eme'e tekipanoane. Inepo intok, ne, juka' enchim koba'a'ea'uta enchim makne”, ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Junak, tukaariao yumakai, ju'u wajta atteakame, ju'u tekileu weyekamtau inen jiiak: “Jume' tekipanoammeu chaaeka, am beje'etuane. Jume' che'a chukula tekipanoa japtekame bat a' makakai. Intok jume' che'a bat tekipanoa japtekame che'a chukula a' makakai.” ");
INSERT INTO yaqNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Junak intok, jume' kupteo mamnim jia'apo tekipanoa japtekame, aman yajaka, juname'e we'epulaka, yuma'isi senu taka tosai tomim mabetak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chukula jume' che'a bat kimukame aman yajakai, inime'e, che'a bepa emo a' mabet machian. Taa ketchia, we'epulaka senu taka pesom mabetak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Inime'e a' mabetakai, juka' wajta atteakamta beje'eka emo nokria japtek, ");
INSERT INTO yaqNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","inen jiakai: “Inime'e, che'a chukula yajakai, senu orata jiba takipanoak. Intok empo, jiba ito beekik am beje'etuala. Itom, jume' che'a yu'in tekilta yaakame, intok si'ime taewata juka' tatariata ine'akame benasi”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Taa ju'u wajta atteakame, juname'e betana senuk inen yoopnak: “Nujmeea, kannee jita ka tu'ik eu jooa. Empo'e ju'unea, senu taka tosai tomim enchim beje'etua rokaka in emou nokaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Juka' em koba'ita nu'uka weene. Inepo inika'a che'a chukula tekipanoa taitekamta, jiba em koba'i beekik inepo a' makbae. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Jaisa ka neu lutu'uria ja'ani, juka' in tomita, in a' sawabae'po aman, ae in aunee'u. Oo jaisa empo junuen in yee jiokol ta'aa'u betchi'bo iniat net kopte ja'ani”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Junuenpo aman san, jume' i'ani inim che'a ka eiyaawaka bitwame, junak che'a eiyaanaa. Intok i'ani, inim che'a bat eiyaawaka bitwame, junak che'a ka eiyaanaa. Bwe'ituk juebena jume' nunuwakame, taa ka jaiki jume' yeu pu'arim. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ju'u Jesus intok, bwe'u jo'ara Jerusalen tea'u bicha a' bo'o joobaekai, jume' woj mamni ama wooika yeu a' pu'arim, bempola, omola am nunuka, intok inen ameu jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Junuen enchim jaibu ju'unea'a benasia, Jerusalen tea'u bicha itepo jikau kaate. Junaman intok, juka'a, inim emo benasi yoemta, jume' te'opopo tekiakammeu yo'owemmeu intok jume' Moiseejtuka'uta betana nesaurim yee majtammeu a' su'u tojitune. Inime'e intok a' me'etune' betchi'bo ae tana au bicha a' teuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Intok bempo, jume' ka ito benasi inim yoemem mampo a' su'u tojine. Inime'e intok junuen, inika'a kia a' juunn jiaawaka, ko'okosi a' joaka intok kuuset bem a' poponne' betchi'bo. Taa baji taewaita weyeka, kokkoarim nasuk jiabijtene ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Junak intok ju'u Jakoobo' teamta intok ju'u Joan teamta ae, inime'e Sebereo' teamta u'usim, aapo, a' yoemiammak weyeka, Jesujtau ruktek intok ini'i au tonommea kiktek a' yo'orekai, junuen senu weemta aapo'iku a'aubaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ju'u Jesus: ―Jitasa empo neu waata ―ti au nattemaek. Ini'i aapo: ―Inime'e woika in yoemiam betana, chukula, jum che'a yo'otaka em yejtene'po, seenuk batatana eu a' yejtene' betchi'bo, juka' senuk intok, mikko'otana eu a' yejtene' betchi'bo junuen nesaune ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Taa ju'u Jesus inen am yoopnak: ―Eme'e kate'em ju'unea enchim a'awa'uta. Jaisa eme'e juka' jiokot, ko'okosi machik intok ka alleaka sioksi maisi machik in ine'enee'uta neu weyemta, nele benasi a' ine'enee ja'ani ―ti jiakai. ―Au te yuma'ane ―ti jiiak bempo. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Taa aapo inen ameu jiiak: ―Lutu'uria ala eme'e, jiba inile benak jiokot ko'okosi a' ine'ene. Intok eme'e nele benasi ka alleaka sioksi emo bitne. Taa seenuk in batatana neu a' yejtenee'uta, juka' senuk intok mikko'otana a' yejtenee'uta, ka neu lutu'uria in a' teuwaane' betchi'bo. Ala a' bittuanaa, wame'e, in yo'owa Liojta betana junuen ameu a' chupa'im ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Junak jume' waate, woj mamnika a' majtim, inika'a jikkajaka, jume' woika nau werim beje'eka emo omtituan. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Taa ju'u Jesus ameu chaaeka: ―Jaibu enchim ju'unea'a benasia, jume' bwere yoemratau che'a yo'o ya'arim, juka' yoemrata, am tekoka'a benasia a am kuakta. Intok ket inime'e yo'o ya'arim nasuk, jume' che'a bepa bem eiyaawame ti ta'eewame, ket bempo'im che'a nesawee'uta am ju'uneiyaatua. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Taa emo nasuku ka junuen weene. Junuentu'eaka su ala, emo nasuku ju'u si'imemmeu che'a yo'otubaeme, ini'i, jume' waatem nesauta jooriane. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Intok jabe juni'i emo nasuk eiyaawaka au bit i'ame, ini'i, che'a bat naataka inime'e nesaupo a' jiapsa'a benasi au eiyaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Junuen juka' inim emo benasi yoemta, ka nesauta a' jooriana' betchi'bo inim a' yepsaka'a benasia. Ala junuen yee aniasekai. Intok junuen, juebenam ka tu'ik betana bem jinne'una' betchi'bo a' jiapsi nenkibaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bempo'im jum bwe'u jo'ara Jeriko' tea'a betana yeu am kateo, yoemra juebenaka, Jesujtat cha'aka kat japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Junama'a bo'o bwiikola, liliptim woika ama jookan. Inime'e intok juka' Jesujta junama wa'am a' weye'po a' jikkajakai: ―Achai, Labiituka'uta yoemratat betana yeu simria, itome'e jiokole ―ti kusisi chaaen. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ju'u yoemra am yaatine' betchi'bo, inimmeu omti nookan. Taa bempo che'a juni'i: ―Achai, Labiituka'uta yoemratat betana yeu simria, itome'e jiokole'e ―ti chaaen. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Junak ju'u Jesus, junama kikteka, jume' liliptimmeu chaaeka: ―Jitasa eme'e nee enchim ya'aria i'a ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bempo: ―Achai, juchi itom bittuane ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Junak ju'u Jesus, juname'e tua am nak jiokoleka, intok pujpo amet mamtek. Inime'e liliptim junama sep bibichaka taawak. Intok inime'e, Jesujtat cha'aka sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bempo'im jum bwe'u jo'ara Jerusalen tea'u abe am yajao, intok ket ili jo'ara Betpaake' tea'u am yajako, jum Oliibo kawiu jeela. Junak ju'u Jesus, wooi jume' a' majtim yeu pu'aka, ");
INSERT INTO yaqNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","intok: ―Jum ili jo'arau bepa bicha kateka'u eme'e katne. Junaman eme'e buu jamutta cha'akamta intok ili buuta aamak eme'e ama bitne. Eme'e a' woitaka intok a'abo neu am tojine ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Intok senuk jachin emou a' jiao, eme'e: “Ju'u achai a' sawabae, intok lauti am notta roka”, ti eme'e au jiune. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ini'i yeu siika junuen juka' bat naataka Liojta betana ju'uneetuawaka, chukula yeu weenemta tetteuwaamta teuwaaka a' ji'ojteka'uta a' chupne' betchi'bo: ");
INSERT INTO yaqNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jum bwe'u jo'ara, kawi Sion tea'po jo'aakammeu eme'e inen jiunee: “Ake'em a' mammatene, ju'u inim che'a yo'o ya'ari emou weye, buu jamuttat yej simekai. Ju'u jita pu'a pu'aktemta asoat, ini'i, ka au che'ewarekai”, ti a' jiaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Intok junak jume' a' majtim sajaka intok tua juka' Jesujta am saweka'po aman aayuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bempo juka' buu jamutta intok juka' ili buuta au nu'upaka intok bem tettebe tajo'orim bem jineka'um buummet wattak. Jesus intok amet jikat yejtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ju'u intok ama yoemra, ka ilikikai, inime'e jum bo'ot bepa bem tettebe tajo'oreka'um to'o sakan. Waate ket juya nassa'akariam chuktak. Intok inime'e, bo'ot aawas am to'o sakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jume' bat aapat kateme, intok ket jume' aet cha'aka kateme, inime'e chaai japtek: ―Juka' si'imemmeu yo'o ya'ari Labiituka'uta yoemiam betana yeu simriatau, a' yo'oriwaka a' alleetuanaa'u au lutu'uriatune. Tu'isi a' eiyaawa'u au bicha teuwaawaka mabettunee ju'u, achai Liojta betana lutu'uriaka a'abo weyeme. A' yo'oriwaka a' alleetuanaa'u tua Liojtau lutu'uriatune ―ti chaae japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Junak juka' Jesujta jum bwe'u jo'ara Jerusalen tea'u a' kibakeko, si'ime jume' junama'a jiapsame, ka nanancha eewame ama ayukan. Juebenaka intoko: ―Jabesa ini'i ―ti nattemaen. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ju'u intok yoemra: ―Ini'i juna'a ju'u Jesuj teame, chukula yeu weenemta tetteuwaame. Ju'u bwiaraa Kalilea' tea'po, jo'ara Nasaret tea'po joome ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chukula ju'u Jesus jum te'opou, Liojta ama yo'oriwaa'u kibakeka intok junama'a si'imem jume' jita nenkaka intok ama jita jinume, yeu am beebak. Jume' yoemratau tomita nanakuliame, jume' bem meesam, intok ket ama jume' wokkoim nenenkame, bem amet joka'um naas am wo'otariak. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Intok inen ameu jiiak: ―Jum Liojta nok lutu'uriapo inen ji'ojtei: “Ju'u in kari, kari Liojtau bicha emo nokria betchi'bo kari ti teane”, ti ji'ojtei. Taaa eme'e, jume' jita e'etbwam ama e'eusee'u, kau wojo'oriata benasi a' ya'ari ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Junama'a te'opopo waate liliptim intok lolo'im, Jesujtau ruktek. Aapo intok inime'e emo ine'etetuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Taa junak, jume' junama'a te'opopo tekiakammeu yo'owe intok jume' Moiseejtuka'uta betana nesauri ji'ojteim yee majtame, inime'e, aapo'ik machilaa, ka a jootu maisi weyemta a' joamta bichakai, intok jume' ili uusim junama'a te'opopo aneka: “Yo'oriwaka intok a' alleetuanaa'u au lutu'uriatune, ju'u si'imemmeu yo'o ya'ari, Labiituka'uta yoemiam betana yeu simriatau”, ti chaaeme jikkajakai, inime'e emo o'omtituak, ");
INSERT INTO yaqNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","intok Jesujtau inen jiiak: ―Jaisa empo juka' inime'e teuwaa'uta jikkaja ja'ani ―ti jiiak. Jesus intok inime'e yoopnak: ―Jana'aka, a nee a' jikkaja. Taa jaisa eme'e inia betana junuen jum Liojta nok lutu'uriapo inika'a ji'ojteita kee bicha ja'ani: Jume' tua illitchim, intok jume' ketuni che'eeme, empo, inime'e che'a yuma'isi enchi am yo'oribaeka junuen am bwiktualaa, ti a' jiaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Junak junama'a am su'u tojak. Intok junama'a bwe'u jo'ara betana yeu sikaa, ili jo'ara Betaania' tea'u bicha yeu siika. Junaman aapo yeu matchuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ketwoo tana junak jum bwe'u jo'arau nottisekai, ju'u Jesus tebauri'e'eak. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aapo bo'o mayoat, chuna'ouwota weyekamta bichaka intok iniau ruktek. Taa junae ouwot kaita teak, sawa ausu'liakan. Junak ju'u Jesus, junau: ―Kate'e intok juchi takane ―ti au jiiak. Intok junama'a sep waakek ju'u chuna'ouwo. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Inika'a bichakai jume' Jesujta majtim tua ae tana suum eak, intok ju'u Jesujtau nattemaek: ―Jaisaaka tua, ju'u chuna'ouwo tua sep waakek ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Inime'e ju'u Jesus inen yoopnak: ―Tua lutu'uriapo ne inen emou jiia, enchim tua junen jiaka Liojtat eaka intok ka ta'abwisi enchim eao, ka eme'e inika'a chuna'ouwotau in yaaka'uta jiba, a' joone, ala ketchia, eme'e inia kautau a inen jiunee: “Inim sookteka, intok jum baweu emo jimmaane”, ti enchim jiao, ini'i intok junuen aune. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Intok si'imeta waka'a, Liojtau bicha nokaka enchim a'awa'uta, eme'e junuen a' suale'eteko, eme'e a' mabetne. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Junak intok ju'u Jesus jum te'opou kibakek, junama'a intok ket yee a' majtao su, jume'e, jum te'opopo tekiakammeu yo'owe intok jume' juriommeu yo'owe, Jesujtau ruktek, intok inime'e: ―Jita ya'uraata betanasa empo lutu'uriata makwaka inika'a jooa. Intok jabesa junuen iniat enchi sawek ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ju'u Jesus, inime'e inen am yoopnak: ―Ineponee ket junuen, senu weemta emou nattemaibae, inika'a intok enchim neu teuwaako, junak inepo enchim tejwaane, jita lutu'uriae inika'a in a' joa'apo ―ti jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juka' Joanta, yee a' bato'owaane' betchi'bo, jabesa aet a' sawek, ju'u Lios oo jume' inim yoeme ―ti ameu jiakai. Taa inime'e, bempo naas emo tetemai japtek inen jiakai: ―Lios a'abo a' bittuak ti itom jiao, junak su aapo: “Jaisaaka intok eme'e ka a' sualek”, ti itom yoopnane. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Intok: “Inim jume' yoemem betana”, ti itom jiao, itepo jume' inim aneme te jinile bwe'ituk si'ime, juka' Joanta, Liojta betana a' noktuawaka'po junuen a' suale ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Junuen san inime'e Jesujtau: ―Katte ju'unea ―ti au jiiak. Junak intoko aapo: ―Inepo nee ket junuen ka enchim tejwaane, jabeta betanasa lutu'uriaka inika'a in a' joa'apo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ju'u Jesus ameu inen jiiak: ―Jaisa ini'i emou maachi. Senu yoeme, woim u'usekai, ini'i intok senuku inen jiiak: “In yoemia, i'an empo jum wasau, pa'asim in echiu sikaa, tekipanoane”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ju'u inia u'usi: “Kannee junen ea”, ti a' yoopnak. Taa ini'i, chukula ta'abwisi eaka, intok aman tekipanoabaeka aman siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chukula ket ju'u achaiwai, ju'u senuku sika intok jiba junaen au jiiak. Ini'i intoko: “Jeewi achai, aman ne weye”, ti a' yoopnaka taa ka aman siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Inime'e wooim betana, jabesa juka' a' achaiwata joo i'a'uta yaak ―ti ameu jiiak. Bempo intok: ―Ju'u bat weyeme ―ti jiiak. Junak ju'u Jesus inen ameu jiiak: ―Tua lutu'uriapo nee inen emou jiia, jume' ya'uraatau bicha tomita weyemta nau totojame, intok jume' ka tu'i jaamuchim, inime'e emo bepat, jum Liojta che'a yo'otaka a' kateka'u yajine. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bwe'ituk ju'u Joan, yee babatoowame, juka' tu'isi jiapsiwamta enchim majtaka emou yepsak. Eme'e intok ka a' sualek. Taa jume' ya'uraatau bicha tomita weyemta nau totojame intok jume' ka tu'i jaamuchim ala, a' teuwaa'uta sualek. Taa eme'e inika'a bichaka juni'i, ka tu'ik betana ka emo temaek junuen a' sual betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Juchi seenuk, jita ta'abwikut nokaka in teuwaa'uta eme'e jikkajine. Ju'u senuk, bwe'u wajta atteakame, junama'a juebena pa'asi ouwom ja'abwak. Inika'a intok a' koratuaka, ket pa'asita ama ba'awa'u betchi'bo senuk yaak. Intok si'imeta a suua betchi'bo, mekka jikau tetam nat chayak. ’Chukula ini'i, junaka'a waj echita, wate tekipanoareeommeu tomipo a' reu teboka, mekka bicha yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Junak pa'asim chuktanaa'u yumakai, ini'i, jume' tekilta a' jooriame, juname'e tekipanoareeommeu junama'a echiu am bittuak, jum echipo aapo'iku weyemta a' lutu'uriatuka'po aman, bem a' mabetne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Taa jume' tekipanoareeom, jume' aman bittuarim bwiseka intok senuk tua ko'okosi yaak, ket senuk me'ak, senuk intok ket mamaasuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ju'u wajta atteakame, bat bepa juchi che'a bu'uum, jume' tekilta a' jooriame aman bittuak. Taa jume' junama'a tekipanoareeom, inime'e si'imem junuen nanancha am yaak. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Junuen su, tua chukula, ini'i, juka' tua aapo'ik ou yoemiata aman bittuak: “In uusi inime'e, aapo'ik yo'orine”, ti eakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Taa junak, juka' usiwaita bichakai, jume' tekipanoareeom inen naas nau jiian: “Ini'i juna'a ju'u chukula inia atteariu tawaneeme. Nau te a' me'ene. Junuen juka' bem at teamak itepo tawa betchi'bo.” ");
INSERT INTO yaqNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Junuen san, inime'e a' bwiseka junama'a wajpo yeu a' nuk sajaka a' me'ak. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ju'u Jesus: ―Junak, ju'u wajta atteakame aman notteko, juname tekipanoareeommak jaisa tua amemak aune ―ti nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bempo inen au jiiak: ―Juname'e ka tu'ik jiapsekame, juna'a, kia ili juni'i ka am jiokoleka am su'ane. Intok ini'i, juka' waj bwiata, tatta'abwi tekipanoareeommeu a' reu tebone. Inime'e, taewaita yumako junama'a echipo a' mabet'ea'uta au a' tojineemmeu. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus junak inen ameu jiiak: ―Jaisa juka' Liojta nok lutu'uria ji'ojteita jakwoo juni'i kee a' bicha ja'ani, ama ji'ojtei: Ju'u tua tu'i teta, jume' kaateme yeu tawaaka'u, ini'i, che'a bat naataka nawataka yeu siika. Inika'a ju'u in yo'owa Lios inien a' ya'ari. Ini'i intok tua itou uttia watchisi yeu weama. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Junuen san ne inen emou jiia, juka' Liojta che'a yo'otaka a' kateka'u, enchim lutu'uria'ea'uta, eme'e ka a' bitne, intok inika'a, ju'u yoemra, juka' Liojta, aapo'ik ea'po aman tu'isi jiapsisukame, a' bittuanaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ju'u intoko tetata betana teuwaawame, jabetaka juni'i, ju'u inia tetat wechekame, kot kottisune. Taa ju'u teta intoko, senukut ko'om wecheka'ateko, inika'a jotchisi a' tutujne. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Junak jume' te'opopo tekiakammeu yo'owe intok jume' paiseom teame, inime'e juka' Jesujta, ta'abwikut nokaka a' teuwaa'uta jikkajakai, aapo'ik bempo'immet a' noka'apo aet mammatek. ");
INSERT INTO yaqNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Junako inime'e a' bwijbaeka'e'eak, taa juka' yoemrata ama anemta majjaen. Bwe'ituk ju'u ama yoemra, juka' Jesujta, Liojta betana weyeka a' noka'apo ju'uneiyaaka a' sualen. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ju'u Jesus juchi jita ta'abwikut nokaka am majta taitek intok inen ameu jiian: ");
INSERT INTO yaqNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Jum teekau, Liojta che'a yo'otaka a' kateka'a betana, ju'u nok lutu'uria, seenuk, yoemratau che'a yo'o ya'arita, a' yoemiawata juptuabaeka, pajkota a' ya'ariaka'a benasi weye. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ini'i, jume' tekilta a' jooriame yeu pu'aka, aman am bittuak, jume' nunurim tejwaane' betchi'bo. Taa juname'e ka aman yeu yajibaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Chukula juchi wate jume' tekilta a' jooriame aman bittuak inen ameu jiakai: “Wame'e nunurimmeu, juka' bwa'aamta jaibu a' ya'asuak, ti eme'e ameu jiune. Jume' wakasim intok jume' wate naikim wowokekame che'a a'awim ne jaibu am su'a tebosuk. Intok kaita inim be'ee. A'abo am kat chaune”, ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Taa inime'e, jume' aman nunuwaka'um, kia beja am jikkajak. Inime'e betana seenu, a' wasau bicha siika, ju'u senu intok, omot a' tekileu bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jume' waate intok junaka'a che'a yo'o ya'arita, wame'e a' tekipanoareeom am bwiseka intok jijiokot am yaak, bem am sussu'a'po tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Junak intok ju'u che'a yo'o ya'ari, unnaa o'omtek. Intok ini'i, jume' a' sontaowam, juname'e yee sussu'ame, am su'aane' betchi'bo aman am bittuak. Intok inime'e ili bwe'u jo'araata ama bem jo'aaka'uta am taya'aria betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chukula jume' tekilta a' jooriammeu inen jiiak: “Si'ime yuma'isi, kaita ama be'ee juka' jujupwamta a' chupne' betchi'bo. Taa wame'e che'a bat nunuwakame, ka ameu cha'aka, bem a'abo katnee'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Junuen san eme'e, bwe'u jo'arapo che'a amet rejtiwa'um bo'ommeu sajaka, junama'a si'imem jume' enchim tea'um, inim jujupwa'u am nunune.” ");
INSERT INTO yaqNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Juname'e tekilta a' jooriame, junaman bwe'u jo'arau yeu sajaka intok si'imem juname'e bem tea'um nau nunuk, tuttu'i yoemem intok kia jume' ka tuttu'i yoemem juni'i. Intok junuen junama bwe'u karipo ju'u yoemra tapunak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Junak ju'u che'a yo'o ya'ari, jume' aman nunurim bitbaeka aman kibakek. Intok senuk junama'a anemtat remtek. Taa ini'i, ka junuen jujupwa'po an betchi'bo junaka'a tajo'orekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Iniau intok inen jiiak: “Empo achai, jaisa tua junuen ka inim an betchi'bo emo a'anaalataka a'abo kibakek”, ti au jiiak. Taa ini'i kaita a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Junak ju'u che'a yo'o ya'ari, junama'a jume' sawammeu: “Inika'a, mampo intok wokpo a' suma'ane, intok pa'akun, ka machikun a' jimmaane”, ti ameu jiiak. Ini'i, junama'a bwannee intok ko'okoleka au tam kumne. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bwe'ituk juebena jume' jiba yuu jiapsi betchi'bo nunuwakame, taa ka jaiki jume' yeu pu'arim. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Junak intok jume' paiseom teame, junama yeu sajaka intok nau eaka junuen, aapo'ik, jita juni'i a' teuwaatuaka, junaet a' nana'atejo betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Junuen san inime'e, waatem ame betana kateme, intok ket waatem jume' Eroojrej teamta betana kateka, aamak eame, Jesujtau am bittuak inen au am jiune' betchi'bo: ―Yee maj majtame, ju'uneate lutu'uriata em noka'apo, intok juka' Liojta betana nok lutu'uriata ka ta'abwisi intok em yee a' majta'apo, intok juka' inim yoemrata noka'uta, kaachin eaka, kia beja a' jikkaja. Bwe'ituk empo ka inim watem, ju'u bem machiaka'ut amet tu'ureka tu'isi am tawaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iniat itom etejoriane. Jaisa tu'i ja'ani, ju'u Romapo che'a yo'o ya'aritau bicha tomita weyemta a' makpo, oo ka tu'i ja'ani ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Taa ju'u Jesus inimmet mammatek bempo'im ka tu'ik bem au ya'abae'po intok inimmeu: ―Ka tu'i yoememtaka emo tu'u joame. Jaisaaka eme'e iniat junuen nee ji'optuabae ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Juka' tomita, ya'uraaatau bicha enchim nana'ikia'uta nee a' bittuane ―ti ameu jiiak. Inime'e intok, junak junaka'a tosai tomita au tojak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Inika'a bichakai, ju'u Jesus inimmeu: ―Jabesa inika'a pujbak intok jume' team iniat ji'ojtei ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bempo: ―Jiba ju'u Romapo, si'imem bepa yo'o ya'ari, Sesar teame ―ti a' yoopnak. Junak ju'u Jesus inen ameu jiiak: ―Junuen san eme'e, ju'u inim che'a yo'otau bicha weyemta au a' na'ikiane. Liojtau bicha weyemta intok eme'e, Liojtau bicha a' na'ikiane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Inika'a bempo jikkajakai, aet suum eaka taawak. Intok junama'a a' su'u tojaka, sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jiba junae taewait, waate, jume' saruseeom teame betana Jesujta bitbaeka aman au yajak. Inime'e saruseeom teame, jume' kokokame, ka am jijiabijte'eti jiaka a' teuwaa. Junuen san iniat nokaka au a' teuwaak: ");
INSERT INTO yaqNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Yee maj majtame, ju'u Moiseejtuka'u inen jiiak: “Yoemta senuk, jubeka intok ka yoemiaka a' mukuko, ju'u junae sailawa, ju'u jokoptulata a' jupne'eti jiiak, intok junaemak yoemiane, ju'u a' saai mukukamta betchi'bo”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Junuen san ket, inim ito nasuk woo busanika nau wewerika jiapsan. Ju'u che'a yo'owe jubeka intok muukuk. Ini'i junuen ka yoemiakai, juka' a' jubeka'uta, a' saila aet cha'aka weyemtau a' tawaak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Iniamak woika, ju'u senuku juni'i jiba junaen su yeu siika. Chukula intok, iniamak bajikuu juni'i ketchia. Intok junuen nat cha'aka jume' woo busanika nau werimmeu yumakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Intok inime'e si'imemmet chukula ju'u jamut juni'i ket muukuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Inien san, jume' kokoarim nasuk am jiabijtesuko, juname'e woo busanika nau werim betana, jabesa a' jubeka tawane. Bwe'ituk inime'esu si'ime a' jubekan takai. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ju'u Jesus inimmeu: ―Tua ji'oplam ―ti ameu jiiak―. Bwe'ituk eme'e, Liojta betana nok lutu'uria ji'ojteita ka a' ta'aa. Intok kia aapo'ik Liojta tua a' utte'aka'uta juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bwe'ituk junak jume' kokoarim jiabijteneeo, kaabe jujupne. Intok kia jume' marakame juni'i ka am kukunatuane. Bwe'ituk inime'e, kia jume' Liojta ankelesim, teekau jiapsame bebenane. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Taa jume' intok kokkoarim, tua am jijiabijte'u betana, jaisa eme'e jum Liojta nok lutu'uria ji'ojteipo, jiba aapo'ik emou teuwaari, kee a' bicha ja'ani, inen jiamta: ");
INSERT INTO yaqNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ineponee juna'a, Apra'am teamtau ju'u Isaak teamtau intok ju'u Jakoop teamtau ju'u bem Lios.” Junuen san, aapo, ka jume' kokkolammeu, taa ala jume' jiba yuu jiapsammeu Lios. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Inika'a jikkajakai ju'u yoemra, junuen yee a' majta'ut, aet suum eaka taawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jume' intoko paiseeom teame, juka' Jesujta, jume' sauseeom teame, junaet am yaatituaka'po ju'une'eakai, inime'e emo nau tojak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Juname'e betana intok seenu, Moiseejtuka'uta betana nesaurim yee majtame, ini'i a' ji'optuabaeka inen au nattemaek: ");
INSERT INTO yaqNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Yee majtame, Moiseejta nesauri ji'ojteim betana, jitasa juna'a ju'u che'a eiyaanaame ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus iniau: ―“Juka' em yo'owa Liojta, empo, ka jiapsita bepa taa tua em tu'u'eeriae intok ket em a jita mammate'ue a' nak yo'orine.” ");
INSERT INTO yaqNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ini'i juna'a ju'u nesauri ju'u che'a eiyaa'eewame. Intok ju'u che'a bat jikkaji'eewame. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Intok ju'u chukula, iniamak wooikai, batte ju'u senuk bena. Ini'i intok inen jiia: “Juka' ele benasi inim yoemta, em emo eiya'a benasi, junaka'a nak'eiyaane.” ");
INSERT INTO yaqNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Inime'e woikai jume' nesaurim juname'e jume' Moiseejta betana nesaurim intok ket wame'e che'a bat naataka, Liojta betana ju'uneetuawaka bem teuwaaka yee majta'uta, amet a' chupe'um ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jume' paiseeom teame junama'a ketun nau am aneo, ju'u Jesus ameu nattemaek: ");
INSERT INTO yaqNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―Ju'u Krijto' teamta betana jaisa eme'e jiia. Jabeta betanasa ini'i yeu simria. Bempo intok: ―Labiituka'uta yoemiam betana ini'i weye ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Junak intok ju'u Jesus inimmeu: ―Junak su jaisaaka ju'u Labiituka'u, Liojta tu'u jiapsie ju'uneetuawaka nokaka, inika'a a' yo'owa rokak ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bwe'ituk ju'u Labiituka'u inen jiiak: Ju'u yo'owa Lios, ju'u in yo'owabeu inen jiiak: “In batatana neu yejtene, jume' enchi beje'eka aneme, junuen ee betchi'bo, in am koba'asu'utajtia”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Inien san, jaisa tua junuen ju'u Krijto, Labiituka'uta betana yeu simriatune, junuen jiba aapo ju'u Labii teamta a' yo'owa rokakai ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Intok kaabe, kia jita juni'i, ka a' yoopnak. Intok junae taewait naateka, kaabe intok juchi au nattemaibaeka'eak. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Junak intok ju'u Jesus ju'u yoemratau intok jume' a' majtimmeu inen jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Jume' Moiseejta betana nesaurim yee majtame intok jume' paiseeom teame, inime'e, Moiseejta betana nesauri ji'ojteim, bem teuwaa'uta, machisia bem yee a' majtane' betchi'bo junuen iniau lutu'uriak. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Inien san eme'e am nok jikkajine. Intok si'imeta juka' bem enchim joo i'a'uta a' chupa'ane. Taa bem junuen jiapsaka bem joa'uta, eme'e ka a' joobaane. Bwe'ituk bempo, senu weemta yee majtaka juni'i, ka junuen junaka'a jooa. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bwe'ituk inime'e, bempo unnaa bettek yee majtaka, juka' jeela juni'i ka a jootumta, intok bempo, yoemrata junaka joo i'a. Taa bempo intok kia ili juni'i ka a' bo'o jooriabae. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Inime'e, si'imeta juka' bem joa'uta, bem bitna' betchi'bo a' jooa. Bwe'ituk inime'e, jum koba meje'eku intok mampo, juka' Liojta noki ji'ojteita a' kima'ika amet bem a' chaya'inee'uta junuen a' tu'ure. Intok jume' watem bepa, che'a ko'om tajti, tettebem se'ebekame bem bepa supempo bem koba'anee'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Inime'e, pajkompo ji'ibwawa'po, che'a nasukun bem joonee'uta tu'ure. Intok jum juriom te'opompo, jume' che'a eiyaawame jojoye'po bem joonee'uta ket tu'ure. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Intok jum aet naj katwa'ummet, inime'e, yoemrata tua yo'orisi am tetebotua i'a. Intok ket juname'e, yee maj majtame, ti am teuwaa i'a. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Taa eme'e, kaabeta junuen, yee maj majtame, ti enchim ta'aatuane. Bwe'ituk si'ime eme'e em nau weri. Intok ket eme'e wepu'ulaik jiba enchim maj majtamta a' jipue, juka' Krijtota. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Intok ketchia eme'e inim kaabeta junuen achai yo'owapo ta'aane. Bwe'ituk eme'e wepu'ulaik jiba achai yo'owak, juka' teekau jiapsamta. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Intok kia eme'e inim, kaabeta betana, yo'o ja'abwaim ti enchim ta'aatuane. Bwe'ituk ju'u yo'owe Jesukrijto aapola juna'a ju'u emou yo'otaka weyekame. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wa'a, inim watem tu'iku aniame, ini'i juna'atune, ju'u emo nasuk che'a eiyaanaame. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bwe'ituk wa'a, aapo au che'a yo'o joame, ini'i, ka eiyaawaka, ko'om eiyaanaa. Taa wa'a ka au che'ewareka, au ko'om eiyaame che'a eiyaatune. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Tua jiokot emou machine, eme'e Moiseejtuka'uta betana nesaurim yee majtame intok eme'e paiseeom teame, ka tu'i yoememtaka emo tu'u joame. Bwe'ituk eme'e, Liojta betana juka' nok lutu'uriata yee ae jinne'uitu'ea'uta, eme'e inime'e kaaet am ju'uneetua. Junuen kia eme'e juni'i ka a' mabetbae, intok kia jume' junuen a' mabetaka jinne'uimtu'ea'um, eme'e ka a junuen am autua. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Tua jiokot emou machine, eme'e Moiseejtuka'uta betana nesaurim yee majtame intok eme'e paiseeom teame, ka tu'i yoememtaka emo tu'u joame. Bwe'ituk eme'e, jume' jaamut jokoptuim, jume' bem karim bem attea, eme'e emo am attea mamaka, chukula intok eme'e junuen, binwa Liojtau bicha emo noktuaka ame bichapo junuen junaet jijiawite. Inia betchi'bo san eme'e che'a juni'i beppa jiokot emo bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Tua jiokot emou machine, eme'e Moiseejtuka'uta betana nesaurim yee majtame intok eme'e paiseeom teame, ka tu'i yoememtaka emo tu'u joame. Eme'e, bwiat intok bawet, mekka tajtia rejteka junuen enchiim suale'uta, senuk, ka emo benasi juriotaka a' sualtuabaekai, intok junak eme'e iniau yumako, junaka'a seenuk, eme'e junuen che'a juni'i emo bepa jiba yuu beete'u bicha betchi'bo ka tu'isi a' tatawa. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Tua jiokot emou machinee eme'e, ka bibichaka watem bo'ota tetejwaame bebenakai, inen jiame: “Seenu, juka' te'opota teuwaaka jita tua au a' ya'ane'eti jia'ateko, ini'i junaet ka a' utte'a joorianee junaka'a a' ya'ane' betchi'bo. Taa ini'i junuen, jum te'opopo, sawai tomita junuen teuwaaka nokako ala, ini'i junaet a' utte'a jooriane.” ");
INSERT INTO yaqNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ka suawaka intok ka bibichame bebena, jitasa che'a eiyaawatchi, ju'u sawai tomi oo ju'u te'opo, junaka'a sawai tomita, Liojta a' atteaka'a benasi a' bittebome ");
INSERT INTO yaqNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Intok ketchia eme'e inen jiia: “Seenu, ju'u te'opopo wajiwa, juka' bwaram ama aet susu'awaa'uta a' teuwaaka, jita tua a' lutu'uriatune'eti jia'ateko, ini'i junaet ka a' utte'a jooriane. Taa ini'i, ju'u, jum bwaram aet susu'awa'ut ayuka, Liojtau bicha na'ikiarita teuwaako, ini'i junaet a' utte'a jooriane.” ");
INSERT INTO yaqNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ka suawaka intok kaitat ju'uneame bebena. Jitasa che'a eiyaawatchi, ju'u Liojtau bicha na'ikiari oo ju'u, jum te'opopo bwaram aet susu'awa'u, ini'i juka' Liojtau bicha na'ikiarita aet ayukamta, Liojta a' atteaka'a benasi a' bit tebome. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bwe'ituk wa'a, juka' bwaram ama aet su'awa'uta teuwaaka, jita a' chupne'eti jiame, ini'i, ka junae betchi'bo jiba a' teuwaane, ala ket juka' junaet ayukamta teuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Intok ju'u, juka' te'opota teuwaaka, jita a' chupne'eti jiame, ini'i, ka juka' te'opota jiba teuwaaka nokne, taa ala ket, Liojta, juka' junama jiapsamta teuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ketchia ju'u teekata teuwaaka jita a' chupne'eti jiame, ini'i, juka' Liojta ama che'a yo'otaka aet a' kateka'uta ket teuwaaka noknee. Intok ket inien naa buusti, juka' Liojta junaet katekamta teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Tua jiokot emou machine, eme'e, Moiseejta betana nesaurim yee majtame intok eme'e paiseeom teame, ka tu'i yoememtaka emo tu'u joame. Bwe'ituk eme'e ju'u juya menta' teamta betana intok ju'u aniijta intok ju'u komiino' teamta betana juka' watek Liojtau bicha weyemta eme'e au a' nana'ikia. Taa eme'e, jume' nesaurim betana juka' che'a eiyaawatchika yee a' majta'uta, kia beja a' bicha, lutu'uriata bo'o jooriawamta, yee nak jiokoliwamta intok juka' Liojta sual ta'eewamta. Ini'i juna'a ju'u enchim joo'ea'u junae ju'u wateku mak nawi. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Eme'e ka bibichaka watem bo'ota tetejwaame bebena, eme'e Liojta betana nok lutu'uriat emo ju'uneeleka, juka' che'a kaita teuwaamta, inika'a bat naataka a' weye'e benasi a' jooa, taa juka' bat naataka enchim joo'ea'uta, kia beja a' bichaka a' kopkopta, senuk wete'poita yeu a' meeyaka juni'i, juka' kameeyo' teamta a' je'ekamta benasi anekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Tua jiokot emou machine, eme'e, Moiseejtuka'uta betana nesaurim yee majtame intok eme'e paiseeom teame, ka tu'i yoememtaka emo tu'u joame. Bwe'ituk eme'e juka' baasota intok juka' pu'atota pa'ariatana tu'ulisi am babaksia, taa inime'e, wajiwa tana ju'u enchim etbwaka intok jain juni'i jita waatiawamtae enchim nu'ula'ue tapuni. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Paiseeo' teame ka bichamta benakai, juka' baasota intok juka' pu'atota che'a bat wajiwa tana am baksiane, junako inime'e ket pa'ariatana ka jaiti machine. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Tua jiokot emou machine, Moiseejta betana nesaurim yee majtame intok paiseeom teame, ka tu'i yoememtaka emo tu'u joame. Bwe'ituk eme'e kia jume' kokkoarim ma'arimpo, bepa inime'e totosaisi ya'arimtaka kia pa'ariatana ujyoisi am mamachiaka'a benasi eme'e mamachi. Taa inime'e wajiwa tana, mukia otammea intok kia si'ime ka nanau machika ju'u jaiti machikue tappunikai. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Inien eme'e mamachi. Watem bichapo kia bitpo tu'i yoemem bebena. Taa Liojta bichapo ju'u enchim emo tu'u joa'u, tokti ka lutu'uria intok tua ka tu'uwa emot aayuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Tua jiokot emou machine, Moiseejta betana nesaurim yee majtame intok paiseeom teame, ka tu'u yoememtaka emo tu'u joame. Eme'e junen jume' bat naataka Liojta betana ju'uneetuawaka yeteu nonoka'um, inime jum bem ma'aripo karim eme'e am jojooria. Intok jume' tuttu'i yoememtusukame betchi'bo, jitae juname benasi ya'arim eme'e ujyoisi am jojoa. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Intok ket eme'e inen jijia: “Itepo ala, jume' bat naataka itom yo'owasuka'um jiapsao taewaimmet jiapsaka'ateko, kaibu te juname'e ee'aniaka jume' Liojta betana yeteu nonoktuawame am su'aa ean.” ");
INSERT INTO yaqNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Taa junuen su jaibu eme'e, juname'e Liojta betana yeteu nonoktuawame am su'akammet enchim yeu katriamtuka'uta aet emo ju'uneiyaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Junuen san eme'e, waka'a bat naataka enchim yo'owasuka'um inien bem naateka'uta, a' chupa'ane. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Ka tu'i yoemem, bakotchim bebena, kaachin eme'e ama yo'eene, taji jiba yuu beete'po jiokot enchim emo bitnee'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jiba inia betchi'bo san, inepo, chukula, jume' Liojta betana ju'uneaka yeteu nokneeme nee emou am bittuane, koba susuakame intok jume' a yee majtame. Taa eme'e, inime'e betana waatem su'ane. Watem ket eme'e, kuusimmet am popontebone. Watem intok ket eme'e jum juriom nau yaaja'po, jiokot am joone. Intok ket jum ili bwere jo'arammet eme'e am jajjane. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Junuen san emot ayunee ju'u ka tu'ika ya'ari, si'imem jume' tuttu'i yoememtusuka'um, bem su'awaka'u betana, ju'u che'a bat tu'isi jiapsisukame Abeltuka'uta betana naatekai, ju'u Sakariaj teaka, Berekiaj teamta yoemiata, jiapsaka'u tajtia. Inika'a, jum Liojta te'opo, a' yo'oriwa'po intok jum bwaram aet susu'awa'po, inime' nasuk enchim me'aaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tua lutu'uriapo ne inen emou jiia, si'ime inia betana ju'u ka tu'ika ya'ari, jume' i'an inim jiapsammet, inime'e a' ya'ari benasi amet aune. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Jerusalen tea'po jiapsame, eme'e, jume' Liojta betana ju'uneetuawaka chukula yeu weenemta teuwaame sussu'ame, intok jume' enchim tejwaaneeka, Liojta emou bittuarim mamaame, juebenasi ne jume' inim jiapsame neu nau am tojaka am jinne'ubaek, juka' totoi jamutta, jume' ili a' asoam, a' masam betuk nau a'atotoja'a benasia, taa eme'e ka junen eak. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yuu, i'an jum enchim bwe'u te'opopo junama'a ju'u Lios ka intok ama aneka emomak tuka ju'uneiyaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bwe'ituk inen ne emou jiia, eme'e ka intok nee bitne, chukula taewaita yuma'u tajtia, inen enchim jiuneeo: “Yo'oriwaka a' alleetuanaa'u au aune, ju'u achai Liojta betana lutu'uriaka, a'abo weemtau”, ti enchim jiuneeo. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus jum te'opopo yeu siika. Intok jaibu a' simeo, junak jume' a' majtim au ruktek intok te'opopo jume' bwere karim a' tetejwaa japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Taa ju'u Jesus inen am yoopnak: ―Eme'e si'imeta inika'a junuen a' bicha. Lutu'uriapo ne inen emou jiia, inime'e, wepu'ulaika juni'i, teta ka jikat tawane. Si'ime chibela tataptune ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Junak intok bempo, jum Oliibo'okawi' tea'u bicha sajak. Juka' Jesujta intok junama'a a' kateko, junak jume' a' majtim au yajaka, junama'a bempola jiba, inime'e: ―Inika'a jakwoo a' chupne'po oo jakwoo yeu a' weene'po enchi te itou a' teuwaa i'a. Jitaa machilaasa aunee enchi a'abo notteo intok juka' aniata a' lu'utineeo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Junak Jesus inimmeu: ―Tu'isi emo suuane, eme'e kaabeta enchim bai ta'aatuane ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bwe'ituk juebenaka nee teuwaaka inim yajinee intok: “Ineponee juna'a ju'u Krijto”, ti jiakai, intok inime'e juebenam bai ta'aane. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Inimi'i intok aman jakuni, nassuawamta eme'e jikkajine. Taa eme'e ka majaune. Bwe'ituk utte'a junuen a' weene'po. Taa junak ketun kee lu'utinee ju'u ania. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bwe'ituk senu bwiaraapo yoemra, juka' ket senuk omot bwiaraapo yoemrata beje'eka nassuane. Intok ju'u senu yoemratau che'a yo'o ya'ari, ta'abwi yoemratau yo'o ya'arita beje'eka nassuane. Intok tebaa aune. Ko'okoa weene. Intok jak chukti ju'u bwia au yoonee. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Si'ime ini'i, kia ju'u ju'ubwa naatemetune, ju'u aet emo jiokot bitnaame. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Intok junak eme'e watemmeu yeu totojinaa, junuen jiokot enchim joona' betchi'bo. Intok eme'e susu'anaa. Intok si'ime yoemra enchim omtanee enchim nemak ea' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Juname'e taewaimmet, juebenaka, Liojta bem sual ta'aa'uta a' koptane. Intok emo naas omtane. Intok jiba bempo, emo naas yeu bwi'ibwijne. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Juebenaka inim yeu machine, jume' yee bai tatta'aame, Liojta betana emo noktuawa'ati jiakai, intok juebena yoemrata bai ta'aane. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Intok ju'u ka tu'uwai ayuka weyeme, unnaa aune. Junuen juebenaka, naas bem emo nak ta'aa'uta koptane. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Taa wa'a, inim a' jiapsa'po tajtia, juka' a' sual ta'aa'uta ka a' koptakame, jinne'uitune. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ini'i intoko, Liojta che'a yo'otaka a' kateka'a betana nok lutu'uria, si'ime aniat, jume' a' teuwaame annee. Junuen si'imekut, si'ime juka' ka nanau yoemrata a' ju'uneiyaane' betchi'bo. Tua junak san junen si'ime aet lu'utine. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ju'u Liojta betana ju'uneetuawaka yeteu nokakame, Laniel tuka'u, wae, Liojta bichapo ka tu'ik yee jootuamta intok kaita be'aaka jita nanasontemta betana a' ji'ojtek. Eme'e junak, inika'a jum te'opopo, Liojta tua ama ane'e benasi a' yo'oriwa'po inika'a ama anemta a' bicha'ateko (ju'u inika'a nokame, aet ju'uneeka a' noknee) ");
INSERT INTO yaqNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","junako jume' bwiaraa Jurea' tea'po aneme, inime'e kawiu bicha sep bamsi yeu katne. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ju'u intoko, kari jikat aneme ka ko'om chepteka, jita wajiwa nu'ubaeka'eene. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ju'u intoko wajpo weamame, ini'i, kia a' tajo'owa nu'u betchi'bo juni'i, ka nottibaeka'eene. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tua jiokot ameu machine, wame'e jaamuchimmeu, juname'e taewaimmet abe usemmewi oo jume' illitchim asoakammewi. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Liojtau bicha eme'e emo nokriane, inika'a enchim yeu katnee'uta ka sebeako intok kia aet yum jo'e taewait juni'i, ka yeu a' weene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bwe'ituk junako, ju'u unnaa jiokot emo bitwame tua aunee. Ini'i aniata ju'unaktewak naateka kaita ale benakai, intok kia chukula juni'i kaita ale benaka aunee. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Intok juka' Liojta, juname'e taewaim junaka'a weenemta, ka lauti a' kechao, kaabe jinne'uitu ean. Taa junaka'a, aapo junuen lauti amau a' tawaane, jume' aapo'ik yeu pu'arim nakeka, aapo'ik am jinne'ubae' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Junak san, junuen seenuk: “Ake'em a' bicha, inim yebijlaa ju'u Krijto”, oo: “Junama'a yebijlaa ju'u Krijto”, ti emou a' jiao, eme'e ka a' sualne. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bwe'ituk inim yeu machinee jume' yee bai tatta'aame, inime'e emo Krijto joakai, intok waate, Liojta betana bem noktuawa'a benasi emo joakai. Intok inime'e machilaata intok suum watchisi machik joone. Junuen yee bai ta'aabaekai, junuen jiba aapo'ik Liojta yeu pu'arim a am bai ta'a'ateko juni'i, am bai ta'a'abaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jaibu nee inika'a emou teuwaala, ketun kee yeu a' yumao su. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Inia betchi'bo san: “Ake'em a' bicha, junum bweka pa'akun aane”, ti emou jiuwao, kate'em aman rejte, oo: “Inim karipo wajiwa aane”, ti emou am jiao, ka am sualne. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bwe'ituk senu yuku be'oktiata, ta'ata yeu we'e betana naateka, aman a' weche'u tajtia a' jibaoka'a benasi, junuen machine, junak, juka' emo benasi yoemta a'abo a' notteo. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jum, juka' mukiata bo'oka'po, junama'a jume' bwere wiirum nau yajine. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Juname'e taewaim, jiokot amet emo bitwakame am simsuko, sep ju'u ta'a ka machisi tawane. Ju'u meecha, ka tachiriane. Jume' chokim teeka betana ko'om wattine. Intok kia teekapo, ka bittaka, jume' utte'akame, inime'e juni'i emo yoone. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Junak intok, teekapo ju'u emo benasi yoemta betana, senu machilaa aune. Intok inim si'ime bwiat ju'u ka nanau machi yoemra bwanne. Intok juka' emo benasi yoemta yo'o nesaweka intok tua yo'orisi machika, teeka betana, namupo weyemta a' bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Intok jume' ankelesim a' sawe'um naas bittuane. Junuen juname'e, jume' bem sisi'iwook kusiam, kusisi am jiutuaka, naiki jekam kate'e betana, si'ime bwiat, jume' aapo'ik yeu pu'arim bem nau am nunu betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Inika'a, juka' chuna'ouwota, ju'u a' machiaka'ut a' ta'aane. Ini'i, jume' nassa'akariam sisiariako intok jume' sawam am basiweeo, junak eme'e ju'une'ea, jaibu juka' tasariata a' yuma'ase'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ket jiba junaeni, junak si'imeta inika'a a' weyeo, a' bicha'ateko, eme'e ju'uneene, si'imeta aet lu'utinee'uta a' yuma'aseka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Lutu'uriapo ne inen emou jiia, si'ime ini'i yeu weene, juka' yoemra i'an jiapsamta kee a' kokko su. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ju'u teekapo bitwame intok ini'i bwia ayukame, inime'e lu'uteka, ka intoko tune. Taa ju'u in teuwaari, ini'i ka lu'uteka, jiba yuu tawane. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Taa tua juka' taewaita intok kia tua jak weyeo a' yuma'anee'uta juni'i, kaabe ju'unea. Kia jume' teekau ankelesim intok kia aapo ju'u Liojta u'usi juni'i. Inika'a, ju'u achai Lios, tua aapo jiba a' ju'uneiyaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Juka' Noe'etuka'uta jiapsao junaen yeu a' sika'a benasia, ket jiba junaen yeu weene, juka' inim yoemta junak a'abo a' notteo. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Taa junakriapo, ju'u aniata kee ba'ae a' subimneeo, jume' junama'a jiapsame, ji'ibwawaka intok bwe'uusi jita ji'iwamta weetuaka emo alleetuan. Jujupwaka intok jume' bem maaram am kukunatuakai. Juka' Noe'etuka'uta, jum bwe'u kuta kari kanoau a' kibakeo taewata yuma'u tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Intok bempo kaita mammatek, juka' ba'ata yepsaka si'imem a' nuk siiko, junak ju'ubwa inime'e ju'une'eakai. Ket jiba inien su machinee juka' emo benasi yoemta a'abo a' notteo. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Junak taewait, o'owim woika wajpo nau rejteka, wepu'ulaka nuk saka'anaa, senu intoko junama tawaanaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jaamuchim woika nau tuseka, junama'a senu nuk saka'anaa, ju'u intoko senu junama tawaanaa. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Eme'e ka koptelaka emo suuanee bwe'ituk eme'e ka ju'unea, jak weyeo juka' yo'ota a' yebijnee'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Taa iniat eme'e ju'uneene, juka' yo'ota jo'aakamta, juka' jita a' etbwarianeemta, tukaapo jak weyeo a' yebijnee'uta ini'i ju'unea'ateko, ka kocheka bo'o bitnee intok jum kariu jita etbwa betchi'bo ka aman a' kibaktua ean. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Inien san ket eme'e, yuma'isi, kaita emou be'eeka bo'o bitne. Bwe'ituk ka a' bo'o bitwaao intok kia ili juni'i ka au waatiawao su yebijnee ju'u emo benasi yoeme. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Ju'u yo'ota tekilta a' jooriame, inika'a, ju'u a' tekowa a' jo'aapo jume' a' yoemiammeu a' to'o simnee'u, juname'e am ji'ibwa'eao, junak aapo'ik am ji'ibwatuane' betchi'bo. Ini'i, suawaka intok ka ta'abwisi eame tune. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tua alleenee ju'u tekoka tekilta joame, ini'i a' tekowa betana aapo'ik junak yepsaka, juka' tekilta a' joo'ea'uta, junuen a' joaka teunaame. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Lutu'uriapo ne inen emou jiia, inika'a, ju'u a' tekowa, juna'a, si'imeta a' atteabeu tua aapo'ik au a' yo'otuka'a benasi a' tawaane. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Taa juna'a tekokame intok, junuen ka tu'i yoemtuko intok ini'i, juka' a' tekowata ka lauti a' nottine'eti eaka, ");
INSERT INTO yaqNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","intok waate jume' ale benasi tekokame, jiokot joo taiteka intok ji'ibwawamta weetuaka intok jume' nanaakommak jita je'eeka'ateko, ");
INSERT INTO yaqNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","junako, ju'u inia tekowa, juka' tekokamta, taewait tua ka a' bo'o bichao intok jak weyeo ka a' ju'uneao nottine. ");
INSERT INTO yaqNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Intok inika'a, che'a bettesi, tua jiokot au a' chupa'ane. Jiba jume' ka tuttu'i yoememtaka emo tu'u joame, ka tu'isi tawaarituka'a benasi a' yaakai. Junak ini'i bwanne, intok ko'okoleka, au tam kumne. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Junuentuk san, teekau, Liojta che'a yo'otaka a' kateka'a betana ju'u nok lutu'uria, woj mamni bebemem, bem tachiriam nu'uka intok inime'e, jujupwa'u sajaka, junuen juka' jupbaemta am nankibae'e benasi machine. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Inime'e betana mamnika ka a suasi emo uju'un, mamnika intok tua a emo anian. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jume' ka a suasi emo uju'ume, jume' bem tachiriam nuk sajaka, junuen, juchi am tapuniaka ae am beetinee'uta kaita nu'upak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Taa jume' a emo aniame, jume' bem tachiriammak nau, ae am beetinee'uta ket jita'apo a' nu'upak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Intok junuen, juka' jupbaemta ka a' yepsao, si'ime yetem ameu yumaka intok junen su kokochok. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Junak intok, jaibu nasuk tukaata weyeo, seenu: “A'abo weye ju'u jupbaeme, yeu em kateka a' nanke”, ti chaaeka jikkajituk. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Juname'e bebemem, si'ime joteka intok bempo jume' bem tachiriam tu'ute japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Intok junak, jume' mamnika, ka a suasi emo uju'ume, jume' a emo aniammeu: “Enchim, inime'e, juka' ae am beetinee'uta, eme'e illikik itom mikne. Bwe'ituk jume' itom tachiriam tutuke”, ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Taa jume' bebemem, a emo aniame: “E'e, bwe'ituk junuen ito betchi'bo intok kia emo betchi'bo juni'i ka yuma'ane. Ala eme'e, jumun a' nenenkiwa'u sajaka eme'e emo betchi'bo a' jinuko, che'a tu'ine”, ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Taa jume' mamnika, ka a suasi emo uju'ume aman junaka'a ket am nu'eeo su, ju'u jupbaeme yepsak. Jume' bebemem, kaita ameu be'eeme, iniamak jum jujupwaa'u kiimuk. Intok ju'u pueeta pattawakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chukula jume' wate bebemem yajak, intok: “Japchi, japchi itom kimu tua”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Taa aapo: “Lutu'uriapo ne ka enchim ta'aa”, ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Junak intok ju'u Jesus, a' majtimmeu: ―Eme'e emo suuanee bwe'ituk eme'e ka ju'unea juka' taewaita intok kia jak weyeo juka' emo benasi yoemta a' yebijnee'uta ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Teekau, Liojta che'a yo'otaka a' kateka'a betana ju'u nok lutu'uria, senuk yoemta, inika'a mekka omot bwiarau bicha yeu simeka, junak jume' a' tekipanoareeommeu chaaeka intok tomita chubala betchi'bo ameu a' to'o sika'a benasi weye. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Inime'e betana seenuk, mamni miil tosai tomim jumak a' makak. Juka' senuk intok ket, jumak wooi miilim a' makak. Intok juchi juka' senuk, jumak senu miilim a' makak. We'epulaim au bem yuma'alaapo aman a' makakai. Junak intok ini'i mekka bicha yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ju'u tekoka, jume' mamni miil tosai tomim mabetakame, ini'i junae tekipanoak intok junuen juchi ae beekim mamni miil tosai tomim yo'ok. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ket jiba junaeni, ju'u jume' wooi miil tosai tomim mabetakame, junae junuen ket juchi wooi miilim yo'ok. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Taa ju'u jume' senu miil tosai tomim mabetakame, ini'i sikaa, intok juka' a' tekowata tomi bwiapo wojo'oriata a' yaaka'po ama a' essok. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Juebena taewaim sikaa, chukula nottek ju'u, inime'e teeko. Intok ini'i, junae betana a' ju'uneiyaabaeka, amemak au tu'ute taitek. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ju'u, jume' mamni miil tosai tomim mabetakame bat au yepsak. Intok ini'i juchi jume' wate mamni miilim, ju'u a' tekobeu su'u tojak: “Achai, mamni miilim empo nee makakan, intok inim ee betchi'bo aayuk juchi mamni miil takai jume' in kobaka'um”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ju'u tekowai iniau: “Tua su tu'i, empo tua tu'i yoemtaka ka ta'abwisi eaka in tekil jojoame. Ka jaikikut tu'isi yuma'isi em aet yeu sika' betchi'bo, inepo nee che'a bepa wateku enchi yo'o ya'ane. Kibakeka alleewamta inim nemak bitne”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chukula intok ju'u, jume' wooi miilim tosai tomim mabetakame, au yepsak intok ini'i, ju'u a' tekobeu: “Achai, wooi miilim empo nee makakan, intok inim ee betchi'bo aayuk juchi wooi miil takai jume' in kobaka'um”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ju'u tekowai intok iniau inen jiiak: “Tua su tu'i, tua empo tu'i yoemtaka, ka ta'abwisi eaka in tekilta jojoame. Ka jaikikut tu'isi yuma'isi em aet yeu sika' betchi'bo, inepo nee che'a bepa wateku enchi yo'o ya'ane. Kibakeka, alleewamta inim nemak bitne”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Taa junak, ju'u tekoka, jume' senu miil tosai tomim mabetakame yepsaka, ju'u a' tekobeu: “Achai, ju'uneanne, bettek em yeteu jiapsaka'po, ka em echaka'po em jitchupa'po. Intok jum kaita em wo'otaka'po juni'i, em nau a' totoja'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Junuen san ne majaeka, intok ne sikaa, juka' em tomi jum bwiapo ne a' essok. Taa inim aayuk ju'u em attea”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ju'u tokowai inen a' yoopnak: “Empo tekoka ka tu'i yoemtaka intok obeme. Ka in echaka'po in jitchupa'uta intok jum kaita in wo'otaka'a betana in nau a' totoja'uta empo ju'uneakai, ");
INSERT INTO yaqNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","inia betchi'bo san empo juka' in tomita, jume' tomita tekipanoammeu a' reu tebo ean, intok junuen inepo, notteka, juka' in tomita au a' kobaka'uta kia naa buusti a' mabet ean”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ini'i intok, jume' ama anemmeu inen jiiak: “Jume' senu miilim ake'em a' u'aaka, juka'a, jume' woj mamni miilim jipuemta am makne. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bwe'ituk wa'a a' jipue'uta, ini'i tu'ikut a' sawaame, iniau junuen che'a juni'i au aune. Taa wa'a a' jipue'uta, ini'i ka junuen a' sawaame, kia juka' iliikim a' jipue'uta juni'i, a' lu'utasune. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Intok inika'a, tekoka junuen jita betchi'bo juni'i ka tu'ik, pa'akun, ka machikun eme'e yeu a' jimmaane. Junama ini'i bwanaka intok ko'okoleka, kusisi au tam kumne”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Juka' inim yoemta, che'a si'imem bepa yo'otaka junaen a'abo a' notteo, ini'i, si'ime jume' a' ankelesiwam ae konila jap sakakai, aapo jum che'a yo'orisi machika, yo'owem jojoye'po yejtene. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Junak intok si'ime aniat ju'u yoemra, aapo'ik bichapo nau yajine. Aapo intok inika'a nattepola a' na'ikimtene, juka' bwaram suuamta jume' bwaram, chibam betana a' na'ikimte'e benasia. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jume' bwalam benasi a' bicha'um, a' batatana am ja'abwane. Jume' intok chibam benasi a' bicha'um, a' mikko'otana am ja'abwane. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Junak intok ju'u che'a yo'otaka katekame, jume' a' batatana ja'abwekammeu: “Eme'e, jume' in achai betana tu'ik emou na'ikiari, neu em kaate. Liojta aniata ju'unaktek naateka juka' emou na'ikiarita nemak enchim yo'o nesaunee'uta eme'e mabetne. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bwe'ituk nee tebaureko, eme'e nee ji'ibwa miikak. Nee ba'a ji'ipeao, eme'e nee ba'a miikak. Ka in bwiaraa be'emu ne weamsuko, eme'e, karita chubala in ama tawanee'uta nee reuwaak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Intok ka nee tajo'osuko, eme'e nee a' mimiksuk. Nee ko'okoeo intok eme'e nee ju'uneiyaabaeka neu yaajisuk. Intok nee eta'ituko juni'i, eme'e nee aniabaeka neu yaajisuk.” ");
INSERT INTO yaqNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Junako jume' tu'isi tawalataka yeu sajakame inen jiunee: “Achai, jaksa itepo tebauremta enchi bichaka intok itepo enchi ji'ibwa miikak. Oo jakwoosa itepo enchi ba'ae mukemta bichaka intok te enchi ba'a miikak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Oo jakwoosa ka em bwiaraa be'emu enchi weamsuko, itepo, karita chubala em ama tawanee'uta enchi reuwaak. Oo jakwoosa ka enchi tajo'osuko te enchi a' mimiksuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Oo jakwoosa itepo ko'okoemta oo eta'ita enchi ju'uneiyaaka te eu sajaka enchi bichak.” ");
INSERT INTO yaqNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ju'u che'a yo'otaka katekame intok inen am yoopnanee: “Lutu'uriapo ne inen emou jiia, eme'e, si'imeta juka' tu'ik inime'e nemak werim, kia inime'e betana che'a ka eiyaawame juni'i, juka' enchim yaaka'uta, junaka'a jiba eme'e nee betchi'bo a' ya'ari.” ");
INSERT INTO yaqNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Junak ju'u che'a yo'o ya'aritaka katekame, jume' mikko'otana au anemmeu: “Omot bicha katnee eme'e, ka tu'ikun bicha na'ikiarim, jum tajita jiba yuu beete'u bicha, inika'a, ju'u bebeje'erita betchi'bo intok jume' a' ankelesim aamak eame betchi'bo ya'arita ayuka'u bicha. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bwe'ituk nee tebaureo intok eme'e ka nee ji'ibwa miikak. Nee ba'a ji'ipeao intok eme'e ka nee ba'a miikak. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ka in bwiaraa be'emu ne weamsuko intok eme'e, chubala in ama tawanee'uta ka nee reuwaak. Intok nee ka tajo'osuko, eme'e ka nee a' mimiksuk. Intok nee ko'okoeo intok nee eta'ituko, eme'e ka nee ju'uneiyaabaeka neu yaajisuk”, ti ameu jiune. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Junak intok bempo: “Achai, jakwoosa itepo tebauremta oo ba'ae mukemta oo ka em bwiaraa be'emu enchi weamakamta oo ka enchi tajo'osukamta te enchi bichak oo enchi ko'okoeo oo enchi eta'ituko, intok itepo ka enchi aniakai”, ti au jiune. ");
INSERT INTO yaqNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ju'u che'a yo'o ya'aritaka katekame intok inen am yoopnanee: “Lutu'uriapo ne inen emou jiia, si'imeta waka'a inime'e wepu'ulaiku juni'i, juka' ka enchim yaaka'uta, junuen inime'e betana tua ka eiyaawatchimmeu juni'i, ket eme'e nee betchi'bo ka a' yaak.” ");
INSERT INTO yaqNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chukula inime'e, jum jiba yuu betchi'bo bem jiokot emo bitnee'u yajine. Jume' intoko, Liojta betana tu'isi mabetrimtaka yeu sajakame, inime'e, jum jiba yuu jiapsinaa'u yajine. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Junak juka' Jesujta, si'imeta inika'a jaibu a' teuwaasukai, jume' a' majtimmeu: ");
INSERT INTO yaqNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Enchim jaibu ju'unea'a benasia, wooi taewaim be'ee, ju'u bwara jisu'awaka pajkonaamta aet weeneo. Ju'u intoko emo benasi yoeme, watem mampo su'u tojitunee junuen kuuset a' popontune' betchi'bo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Juname'e taewaimmet jume' te'opopo tekiakammeu yo'owe, jume' Moiseejtuka'uta betana nesaurim yee majtame intok jume' juriommeu che'a yo'owe, inime'e, ju'u te'opopo tekiakammeu che'a yo'owe, Kaipaaj teamta bwe'u karipo ama yaajiwa'po emo nau tojak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Junama'a inime'e junuen juka' Jesujta junuen a' bai ta'aaka a' bwiseka intok a' me' betchi'bo aet nau etejok. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Taa inime'e: ―Ka pajko taewaimmetchi a' bwijne, junuen ju'u yoemratau ka yanti elwamta ka ameu ya'a betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus, ili jo'ara Betaania' tea'po aanen, senu Simon teamta jo'apo. Ini'i, Lepra' teamta ko'okoak ti ta'eewame. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Senu jamut intok, jita'apo tosai tetae ya'aripo, ochokok ba'ata benak tua win jubaka, unnaa beje'emta weiyaakai au ruktek. Junak, juka' Jesujta mesau a' kateko, aapo kobat, junaka'a ba'ata si'imeta aet yaak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jume' Jesujta majtim junak, inika'a bichakai, o'omtek intok inime'e: ―Jaisa betchi'bo inika'a kia beuti a' wo'otak ―ti jiu japtek―. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ini'i, yu'in tomipo a nenkitun. Junuen jume' jiokot eame am ania betchi'bo ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ju'u Jesus inika'a jikkajaka intok inimmeu: ―Jaisaaka eme'e inia jamuttau suua. Ini'i, aapo'ik neu ya'ari, tu'uwa jiba ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bwe'ituk jume' jiokot jiapsame eme'e jiba inim emo mak am bitne, taa nee eme'e ka jiba inim emo mak bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ju'u inika'a jamutta ya'ari junuen inika'a ba'ata benak win jubak net a' ya'arikai, iniae aapo, nee ma'atuneeo juka' net ya'a'eewamta jaibu a' ya'ari. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Lutu'uriapo ne inen emou jiia, jak juni'i, inika'a nok lutu'uriata a' teuwaawa'po si'ime aniatchi, ket inika'a jamutta ju'u a' ya'ari teuwaatunee junuen aapo'iku waatina' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Junak intoko jume' woj mamni ama wooika, Jesujta majtim betana, seenu, Juuras Ijkarioote' teame, te'opopo tekiakammeu yo'owemmeu sikaa, amemak etejok. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Intok ini'i: ―Jaikiksa eme'e nee makne, junuen juka' Jesujta enchim mampo in a' su'u tojine' betchi'bo ―ti ameu jiiak. Junako bempo, senu taka ama woj mamnik tosai tomim a' beje'etuak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Junama'a naateka ju'u Juraj teame, junammeu juka' Jesujta su'u toji betchi'bo, jakwoo che'a a' tu'ireaka'uta bo'o bichan. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bat ju'u taewait, jume' paanim ka reberuakame bwa'awaka pajkota aet naateeo, jume' Jesujta majtim Jesujtau rukteka intok inen au nattemaek: ―Jakunsa empo, juka' pajkot kupteo em bwa'anee'uta, itom a' tu'ute i'a ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aapo inen ameu jiiak: ―Bwe'u jo'arau eme'e katnee, aman inia senu yoemta a' jo'awi. Junama'a intok iniau eme'e: “Nee betana si'imeta aet chupnee'u, ju'u taewai yuma'asek. Intok jum em jo'apo ne, jume' in yeu pu'arimmak, juka' pajkot joowamta a' chupa'abae”, ti jiia ―ti eme'e au jiune. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jume' a' majtim, Jesujta am saweka'po aman aayuk. Intok pajkot kupteo bwa'aneemta yaakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Junak tukaariau yuma'aseka, ju'u Jesus, jume' woj mamni ama woika yeu a' pu'arimmak mesau ruktek. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bempo'im intok ketuni ji'ibwaao, aapo: ―Lutu'uriapo ne inen emou jiia, emo betana senu nee yeu bwijne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Junak intok bempo tua emo sioktuak. Intok inime'e we'epulaka: ―Achai, jaisa inepo juna'atunee ja'ani ―ti au nattemai japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus intok inime'e: ―Wa'a in pu'atopo nemak ji'ibwakame, ini'i juna'atunee wa'a nee yeu bwijneeme ―ti am yoopnak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ju'u emo benasi yoemtau, Liojta nok lutu'uriapo aapo'ik betana junuen a' ji'ojteituka'po aman au chuppe. Taa tua jiokot au machine, ju'u yeu a' bwijneemtawi. Inia o'outau che'a juni'i tu'i ean, ju'u ka yeu a' yoemtu'ea'u ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Junak intok nookak ju'u Juuras, ju'u aapo'ik yeu bwijneeme intok: ―Yee majtame, jaisa tua inepo juna'atunee ja'ani ―ti au jiiak. Jesus: ―Jeewi, empo juna'a ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bempo'im ketuni ji'ibwao su, ju'u Jesus, paanim nu'uka, ame betchi'bo Liojta baisaek. Intok juname'e rebektasukai, jume' a' majtimmeu am bwisek: ―Ake'em am bwa'ee, ini'i in taka o'oben ―ti ameu jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chukula ket juka' pa'asi ba'awata ama ayuka'u nu'uka, ae betchi'bo Liojta baisaeka intok inika'a bempo'immeu bicha a' bwisek: ―Si'ime eme'e inika'a ji'ine ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Bwe'ituk ini'i in ojbo o'oben, Liojta mak bemelasi emo tu'utewamta a' lutu'uriatuka'uta a' teuwaame. Intok ini'i, juebenammeu tu'ineeka, bem ka tu'uwa ya'arim betana am jiokoi betchi'bo wo'otituneeme ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Taa inepo ne inen emou jiia, inika'a pa'asi betana ba'ata, kannee intok emomak a' ji'ine, ju'u taewait, chukula in achai che'a yo'otaka a' kateka'u, pa'asi ba'awata bemelaka ka inile benak, itom nau a' ji'ineeo tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Intok chukula, jume' bwiikim bwiksuka, Oliibo'okawi' tea'u bicha yeu sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Junak intok ju'u Jesus inimmeu: ―Si'ime eme'e inia tukaariat nemak enchim ea'uta a' koptane ―ti ameu jiiak―. Bwe'ituk jum Liojta nok lutu'uriapo: “Juka' bwaram suuamta ne a' me'ene, jume' bwalam intok na'ikimtune”, ti ji'ojtei. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Taa chukula, inepo kokkoarim nasuk jiabijtesuko, jum bwiaraa Kalilea' tea'u ne emo pat anne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Junak intok ju'u Peeo: ―Si'imem junuen emak bem ea'uta am koptak juni'i, inepo ne kaibu junuen aune ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ju'u Jesus junak: ―Lutu'uriapo ne eu inen jiia, inia tukaariat, totoi o'owiata kee a' kuseo, empo, temaiwaka, bajisi ka nee emo ta'a'ati jiune ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ju'u Peeo: ―Kia nee emak me'etuneeka juni'i, kannee ee betana tiune ―ti au jiiak. Intok si'ime jume' a' majtim ket jiba junaen jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Junak intok ju'u Jesus, jume' a' majtimmak, aman jum Jetsemani' tea'u yepsak. Junammeu intok: ―Inim jooye, ket imin, Liojtau bicha ne noka'u tajtia ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Intok Peota intok wooi jume' Sebereeo' teamta u'usim nunuka, junama'a tua siokaka intok ka allee taitek. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Junak intok aapo inimmeu: ―Tua nee ama butti ka ine'emaisi sioka. Inim eme'e tawane, intok nemak eme'e eaka ka kokotne. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Junako ju'u Jesus, juchi ili bichau bicha sikaa, intok tonommea weeka, bwiau ko'om cha'aka, Liojtau bicha nookak: ―In yo'owa, a junuen yeu a' weyeo juni'i, inika'a bettesi jiokot machika neu weyemta, ka junuen yeu a' weetuane. Taa ini'i, ka in ea'po amantune, taa tua em junen ea'po amantukai ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Junak intok, jume' yeu a' pu'arim tawala'u notteka intok kokochemmeu yepsak. Peotau intok: ―Jaisa eme'e kia senu orapo juni'i, ka kokocheka a in taawak ja'ani ―ti ameu nattemaek―. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kate'em kokkoche. Intok Liojtau bicha em emo nokria junuen ka tu'ikut ka enchim ji'opne' betchi'bo. Lutu'uriapo eme'e tu'ikut jiapsek, taa ju'u inim enchim takaa, tua ka au yuuma ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Inia mak, woosa aman sikaa: ―In yo'owa, inika'a jiokot neu weenemta, jiba junuen a' utte'atuneo, junako, tua em ea'po amantune ―ti jiaka Liojtau bicha nookak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sep notteka intok juchi jume' yeu a' pu'arim kokochemmeu yepsak. Bwe'ituk inime'e yetem ka yu'een. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Inime'e kia am to'o sikaa, intok iniamak bajisi, juchi Liojtau bicha nokbaeka siika, jiba juka' bat a' teuwaaka'uta au teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Junak intok jume' a' majtim tawala'u nottek intok: ―Jaisa eme'e ketun yum jo'eka kokkoche ja'ani. Yuma'asuk ju'u oora juka' emo benasi yoemta aet ka tu'i yoememmeu a' su'u tojinaa'u ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jote'em, jante bu. A'abo weye ju'u nee yeu bwijneeme. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesujta ketun a' nokao su, junak ju'u Juuraj teame ama yepsak. Ini'i, jume' woj mamni ama woika, Jesujta yeu pu'arimmak na'ikiatuka'u. Intok wate juebenaka aamak kaaten, tettebe kuchi'im intok kutam weiyaakai. Inime'e, te'opopo tekiakammeu yo'owem intok jume' junama'a juriommeu che'a yo'owem betana katekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ini'i Juuras, ju'u yeu a' bwisekame, senu machilaata am tejwaalatukan: ―Ju'u, in aet tentenee'u juna'atune. A' bwiseka a' weiyaane ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Junak intok aapo, ju'u Jesujtau rukteka intok: ―Ketchi allea, yee majtame ―ti au jiiak. Intok aet tentek. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ju'u Jesus: ―Jalla'i, jitasa empo a'abo nu'usek ―ti au jiiak. Junak inime'e au rukteka intok aapo'ik Jesujta bwiseka intok a' nuk sajakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ketun ama am aneosu, seenu, Jesujtamak eame, jume' tebe a' kuchi'im yeu wikeka intok juka' te'opopo tekiakammeu yo'ota sawee'u nakammet a' chuktak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Junak intok ju'u Jesus iniau: ―Jume' em tebe kuchi'im bem weeka'po am kecha ―ti au jiiak―. Bwe'ituk si'ime wame'e bem tebe kuchi'immea nassuame, inime'e ket tettebe kuchi'immea su'atune. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Empo tu'isi ju'unea, inia betchi'bo in yo'owabeu bicha in a ino nokria'po, intok i'an lautipo, woj mamni ama wooika batayoonim bepa, ankelesim aapo'ik neu bittua'ea'po. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Taa junuentuko, kaachin yeu yumaa ean, jum Liojta nok lutu'uriapo junuen nee betana utte'a a' chupne'po ju'u ji'ojtei. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Junak intok ju'u Jesus jume' a' bwijbokammeu: ―Eme'e, tettebem kukuche'ekai intok kukutakai a'abo yeu sajak nee jita etbwareotuka'a benasi nee bwijbaekai. Chikti ta'apo jum te'opopo nee emo nasuk aneka yee majtan intok junak eme'e ka nee nuk sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Taa si'ime ini'i inien weye, juka'a, jume' bat naataka Liojta betana ju'uneetuawaka, jum Liojta nok lutu'uriapo bem teuwaaka'uta a' chupne' betchi'bo. Junak intok si'ime jume' Jesujta majtim, aapolaik su'u tojaka, tennek. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jume'e, juka' Jesujta bwisekame, Kaipaaj teamtau, ju'u jume' te'opopo tekiakammeu che'a si'imemmeu yo'otau a' tojak. Junama'a jume' Moiseejta betana nesaurim yee majtame intok jume' juriommeu che'a yo'owem emo nau tojilamtuka'awi. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Taa ju'u Peeo, mekka aet cha'aka weyen, jum junama'a che'a yo'o ya'arita bwe'u kariu kimuwa'u tajtia. Junama'a ini'i kibakekai. Intok jume' waate junama'a ya'uraata betana yee suuatuawammak yejtek. Junuen junaka'a weyemta, jachin yeu a' weene'po a' ju'uneiyaabaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jume'e, jum te'opopo tekiakammeu yo'owe, ket jume' ama juriommeu yo'owe intok si'ime ju'u ama nau yo'oraa, inime'e, senuk Jesujta beje'eka, ka lutu'uriata teuwaanemta jaiwan. Junuen nesaubaekai a' me'etune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Taa inime'e, kaita a' beje'eka ayukamta ju'uneiyaak. Juebenaekan o'oben, jume' aman yajaka intok aa noki'ichiata teuwaakame. Taa inimmet chukula, woika, ka lutu'uriata teuwaaka ama yajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Inime'e: ―Ini'i o'ou, sejtul inen jiiak: “Juka' Liojta te'opota inepo a' tatabe, intok baji ta'apo ne juchi a' yecha'aneekai”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Junak ju'u, jum te'opopo tekiakammeu che'a yo'owe, kikteka intok Jesujtau: ―Jaisa empo ka montibae ja'ani. Jitasa ini'i, inime'e enchi beje'eka teuwaa'u ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Taa ju'u Jesus, kaita a' yoopnak. Junak intok ju'u jume' te'opopo tekiakammeu che'a yo'owe: ―Ju'u Lios, jiba yuu jiapsamta betana lutu'uriaka ne, inepo lutu'uriata enchi teuwaa i'a. Empo ju'u Krijto, ju'u Liojta yoemiatuko, itom tejwaane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ju'u Jesus iniau: ―Inepo ne juna'a em a' teuwaari benasi ―ti au jiiak―. Intok ket ne inen emou jiia, juka' emo benasi yoemta, Lios, si'ime utte'akamta, a' batatana betana kateka intok inika'a, teeka betana namupo ko'om weyemta, eme'e a' bitne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Junak intok ju'u te'opopo tekiakammeu che'a yo'owe, tua ka a' tu'uree'uta teuwaakai, a' supewam siutak, intok: ―Ini'i o'ou ju'u a' noka'ue, Liojta beje'eka ka tu'ik teuwaala ―ti jiiak―. Iniae, ju'u a' beje'eka nokneeme ka utte'atune. Eme'e a' jikkajila, Liojta beje'eka juka' ka tu'ik a' teuwaaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Jaisa emou maachi. Bempo: ―Ka tu'ika aet aayuk intok ini'i me'etunee jiba ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Junak intok pujbat aet chit wattiwak. Intok ko'okosi joowan. Wate intok pujbat a' chonan. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Intok inime'e: ―Empo ju'u Krijtotakai, ka ju'uneakai jabesa junuen enchi chochonak ―ti au jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Junuen a' weyeo su, ket ju'u Peeo junama'a tebatpo wajiwa tana ketun katekan. Intok senu jamut ama sawame, au rukteka: ―Empo ket, Jesus ju'u Kalilea' tea'u jometamak weaman ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Taa ju'u Peeo, si'imem bichapo: ―Kannee ju'unea jitat em noka'apo ―ti jiaka, ka au a' ta'a'ati jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Juka' Peota jaibu yeu a' simbaeo su, junak juchi senu jamut a' bichaka intok jume' ama anemmeu: ―Ini'i ket, Jesus, jo'ara Nasaret tea'u jo'aakamtamak weaman ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Intok juchi wee'po ju'u Peeo, tua lutu'uriata au noka'ati jiaka: ―Kannee a' ta'aa junaka'a o'outa ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Che'a chuubatuka jume' junama'a ane'um, Peotau rukteka: ―Lutu'uria, empo ketchia junamemak weye. Bwe'ituk junuen em noka'ut juni'i, empo ju'unakkiachi ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Junak intok ini'i, jita ka tu'ik au chupne, ka a' junuentuko, tua lutu'uriata au noka'ati jiaka: ―Kannee a' ta'aa inika'a o'outa ―ti jiakai. Junama'a lautipo senu totoi o'owia kukusuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Junak ju'u Peeo, Jesujta au teuwaaribeu wawaatek: “Juka' totoi o'owiata kee a' kukuseo, temaiwaka, bajisi empo ka emo nee ta'a'ati jiulatune”, ti a' jiaka'u. Ju'u Peeo intok junama'a yeu sika intok a' juiwaka tua bwaanak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Junak yokoriapo, si'ime jume' te'opopo tekiakammeu yo'owe, intok jume' juriommeu che'a yo'owe, inime'e, juka' Jesujta me'e betchi'bo nau lutu'uriabaeka nau etejok. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Inime'e, aapo'ik suma'ita nuk sajaka intok ju'u kobanao, Ponsio Pilaato' teamtau a' nu'upak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Juuras ju'u yeu a' bwisekame junak, juka' Jesujta me'etune' betchi'bo aet nesawakamta a' ju'uneiyaakai, au koptaka, jume' senu taka ama woj mamni tosai tomim, jume' te'opopo tekiakammeu yo'owe intok junama'a juriommeu che'a yo'owemmeu am nottak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Intok: ―Liojta bichapo ne ka tu'ik ya'ari. Senuk, ka tu'ik kaita ya'arik, a' me'etune' betchi'bo yeu a' bwisekai ―ti ameu jiiak. Taa bempo: ―Ini'i, ito betchi'bo kaita teuwaa. Inika'a empo a' ya'ari, em mampo aayuk ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Junak ju'u Juuras junaka'a tomita, jum te'opopo na'ikim a' wo'otaka intok sikaa, au chayak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jume' te'opopo tekiakammeu yo'owe, junaka'a tomita nu'uka, intok: ―Inika'a tomita, jum te'opo tomita auka'po, katte a aman a' jipue. Bwe'ituk ini'i, senuk a' me'etune' betchi'bo ae beje'etuari ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chukula inime'e, wepulsi nau eaka, junae tomie, junuen, senu Babuta tekipanoamta waj bwia, ae jinu betchi'bo etejok. Junuen jume' ka ama joomem ama bem mama'anee'uta a' jipu' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Inia betchi'bo san juna'a waasa i'an taewaimmeu tajtia, Ojbo bwia ti teuwaawa. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Intok inien yeu chupuk ini'i, ju'u Liojta betana ju'uneetuawaka, Jeremiaj teamta inika'a: “Jume' senu taka ama woj mamni tosai tomim nu'uka. Tomita, juka' Ijra'el yoemrata ae betchi'bo a' a'awaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Intok inimmea, senuk babu bwiata ama tekipanoamta waj bwiata jinuk. Tua juka' achai Liojta nee aet saweka'po amani”, ti a' teuwaariaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus, ju'u kobanaota bichapo yeu tojiwak. Ini'i intok: ―Jaisa empo juna'a ja'ani, ju'u, jume' juriommeu che'a yo'o ya'ari ―ti au nattemaekai. Ju'u Jesus iniau: ―Lutu'uria, junuen em a' teuwaari benasia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Intok junako jume' te'opopo tekiakammeu yo'owe intok jume' juriommeu che'a yo'owe, jitat a' nana'atejoo, Jesus kaita am yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Junak ju'u Pilaato: ―Jaisa empo ka a' jikkaja ja'ani si'imeta juka' enchi beje'eka teuwaawamta ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Taa Jesus, kaita a' yoopnak. Junuen san ju'u kobanao, tua a' suum eiyaaka taawak. Intok kaita ae tana teuwaa machiakan. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Intok ketchia, ju'u kobanaao, juname'e pajko taewaimmet senuk eta'ita yeu a' weene'po junuen waatiawamta, yeu a' su'u tojine'po junuen a' bo'o joorian. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Junakriapo intok, senu tua ta'eewaka, Barabaaj teaka eta'itaka jipu'uwan. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Intok bempo'im junako ama nau aneo, ju'u Pilaato: ―Jabetasa eme'e su'u toji i'a, juka' Barabaj teamta oo juka' Jesujta, Krijto ti teuwaawamta ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bwe'ituk aapo, bempo'im aet kopte' betchi'bo, bem yeu a' tojilatuka'po, a' mammatelatukan. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Juka' Pilaatota ket jum yo'otaka yeyesa'po a' katek su, ju'u a' jubiawa nokta au bittuak: “Ka au suuane, iniau si'imeku tu'i yoemtawi. Bwe'ituk tutukabiak tua nee jantiaachik tenkuk, jiba inia o'outa betchi'bo”, ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Taa jume' te'opopo tekiakammeu yo'owe intok jume' juriommeu che'a yo'owe, juka' yoemrata ama anemta nok yu'uk junuen Barabaaj teamta a' su'u tojinaa'uta a'awaka intok juka' Jesujta muknee'uta bem a' teuwaane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ju'u kobanaao juchi ameu nokaka inen ameu nattemaek: ―Inime'e woim betana, jabetasa eme'e su'u toji i'a. Bempo intok: ―Juka' Barabaaj teamta ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ju'u Pilaato intok: ―Juka' Jesujta su, juka' Krijto' teamta, jaisa nee a' ya'ane ―ti ameu nattemaek. Si'ime juname'e: ―Kuuset a' popon tebone ―ti jiaka a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Junak intok ju'u Pilaato: ―Jitasa ka tu'ik ini'i ya'arikai ―ti ameu jiiak. Taa bempo: ―Kuuset a' popon tebone ―ti juchi chaaen. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ju'u Pilaato intok, junuen kaita a tu'utetu'po ju'uneakai, ala, junaka'a junama'a ka nau eewamta ayuka'uta bichakai, ba'am a'awaka intok si'ime junama'a aneme bichapo mam bajimak inen: ―Inika'a yoemta ka tu'ik kaita ya'arika a' mukneemta betana ju'u ka tu'uwa ka net aayuk, eme'e a' ya'ari ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ju'u yoemra intok si'ime: ―Itepo intok jume' itom yoemiam a' muknee'u betana, itom a' ya'ariaka'po itepo ju'unea ―ti jiaka a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Junako ju'u Pilaato, juka' Barabaaj teamta yeu a' simtuaka, chukula juka' Jesujta bepsu teboka, kuuset a' popontune' betchi'bo ameu a' su'u tojak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chukula jume' kobanaaota betana sontaaom, kobanaaota bwe'u kariu wajiwa tana, sontaom ane'u a' tojak. Intok si'ime ju'u sontaoraa au nau tojiwak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Junak sep, inime'e, a' supe wattak intok ta'abwim, unnaa sikiim a' supetuakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Intok juya wichakamta nat ko'elai yaaka, kobat aet a' yechak. Batatana mampo intok, bakata benak a' makak. Junak intok ae bichapo tonommea jajapteka, intok a' junn jiaawaka: ―Ketchi allea, ju'u juriommeu che'a yo'o ya'ari ―ti au jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ketchia, inime'e aet chit wat watten. Intok juka' bakata benak a' nu'uka, kobat ae a' beban. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chukula junuen, jak wa'am a' bitchukai, jume' sikii supem a' yecha'ariak intok inime'e a' supewampo juchi a' kobatuak. Chukula inime'e junuen kuuset a' poponne' betchi'bo yeu a' nuk sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Junak junama'a yeu katekai, senu yoemta, bwe'u jo'ara Sireene' tea'a betana jo'aaka, Simon teamta nankek. Inika'a, inime'e, kuujta Jesujta weiyaa'uta, utte'apo a' pu'aktituan. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Junuen kateka, inime'e jum Kolkota' tea'u yajak. Ini'i nooki intok, Mukia kobata kateka'po, ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Junama'a inime'e, juka' Jesujta, pa'asi ba'awata, chibu jittoatamak kuukuutita a' ji'ituak. Taa inika'a jiwekai, ju'u Jesus ka a' waatak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Junak, jaibu kuuset a' poponsuako, jume' sontaaom, ju'u Jesujta tajo'ori nat a' na'ikimte betchi'bo, nau ja'atek. Junuen yeu chupukai ju'u, juka' Liojta betana ju'uneetuawaka a' teuwaaka'uta: “In tajo'ori, inime'e nat na'ikimtek, aet nau ja'atekai”, ti a' jiaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chukula inime'e junama jootek a' suuabaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A' koba bepa intok ji'ojtei, inia betchi'bo junuen a' me'ewaka'u ama chaya'awak: “Ini'i juna'a ju'u Jesus, ju'u juriommeu che'a yo'o ya'ari”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ketchia, woika jume' jita e'etbwame aamak kuusimmet poponwak. Seenuk a' batatana, senuk intok a' mikko'otana. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jume' intoko junama'a aet wa'am kateme, ka a' yo'oreka nookan, jikau intok ko'om kobatekai. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Intok inime'e: ―Empo, juka' Liojta te'opota tatabeka intok baji ta'apo juchi emo a' yecha'ane'eti jiame, junum emo jinne'u. Empo tua Liojta yoemiatuko, junum kuuset em poponripo ko'om weye'e, ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Junuen ketchia jume' te'opopo tekiakammeu yo'owe intok jume' Moiseejtuka'uta nesaurim yee majtame, jume' paiseeom teammake intok jume' juriommeu che'a yo'owe, ket junuen ka a' yo'oren intok bempo nau: ");
INSERT INTO yaqNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Watem jinne'uk taa aapo ka a au jinne'u ―ti jiian―. Ini'i lutu'uriapo Ijra'el yoemratau che'a yo'o ya'arituko, junum a' poponripo ko'om weene itom a' sualne' betchi'bo ―ti nau jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Liojtat a' ea'uta teuwaalaa. I'an ela'po Lios a' jinne'une, lutu'uriapo naksi a' eiyaakai, aapo su junuen itou, Liojta betana au yoemiari'iti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kia jume' jita e'etbwame aamak junama'a kuusimmet popontukame juni'i, ket ka a' yo'oreka au nookan. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Junak, junama'a si'imekut ka machisi taawak, luula katek naateka, kupteo, bajim jia'u tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Intok jumak ket jiba junama'a bajim jiao, Jesus kusisi: ―Eli Eli, lama sabaktani ―ti chaaek. Ini'i: Achai Lios, achai Lios, jaisaaka empo nee inim inepolaik koptala, ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Waate, jume' junama'a ane'um, junuen a' jikkajaka: ―Ini'i, bat naataka ju'u Liojta betana ju'uneetuawaka nokakame, Eliaj teamtau chaae ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Juname betana seenu, lauti buiteka, jita, ba'ata nunu'emta ejponja' teamta nu'uka, chukula intok junaka'a binaakretae a' komoniaka, tebe kutat a' sumaka intok aman jikau au a' yuma'ariak, junuen junaka'a a' ji'ine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Taa jume' waate: ―A' su'u toja, bo'o bitneete. Jumak juni'i ju'u Eliaj teame a'abo a' jinne'une ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ju'u Jesus juchi wee'po kusisi chachaek. Intok junak muukuk. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Junama lautipo, Liojta te'opopo jume' bwe'uu tajo'orim cha'akame, nanana'aku nasuk, jikat naateka ko'om tajti siutek. Ju'u bwia intok au yoyoak, jume' bwere tetam intok na'ikim jamtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jume' intok kokkoarim ama ma'atuka'um, emo etapok. Juebenak intok waate jume' Liojta sualeka kokkokame, bem takaam juchi jiapsak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Intok chukula, juka' Jesujta, kokkoarim nasuk a' jiabijtesuko, inime'e junama'a bem ma'arimpo yeu sajak. Intok ju'u bwe'u jo'ara, Liojta yeu pu'ariu, Jerusalen tea'u kiimuk. Junaman inime'e, juebenaka am bichakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Junako ju'u sontao ya'ut intok jume' aamak juka' Jesujta suuame, juka' bwiata au yoakamta intok juka' watek yeu sikamta bichaka, inime'e tua majaek, intok: ―Lutu'uriapo, ini'i yoeme, Liojta betana yoemiaritukan ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Junama'a juebena jaamuchim, mekka ja'abweka a' bitchun. Inime'e intok, bwiaraa Kalilea' tea'a betana naateka, Jesujtamak rejteka intok a' anialamtukan. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ame nasuk ju'u Maria Maareena' teame, ket ju'u senu Maria, ju'u Jakoobo' teamta intok Jose' teamta ae. Inime'e intok ju'u Sebereeo' teamta yoemiam ae ama aanen. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Junak, tukaariau yuma'asekai, yoeme, tua tomeka, Jose ti teaka, ini'i, ili bwe'u jo'ara Arima tea' tea'po jo'aakai, aman yepsak. Intok ini'i ket, bat naataka Jesujta mak eaka jiapsaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Junak ini'i, Pilaato' teamtau sika intok juka' Jesujta takaawata au a'awak. Pilaato junak nesawek, a' makna' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ju'u Josee, juka' takaata nu'uka, bwe'u tajo'orim tossaalaimpo a' biijtaka, ");
INSERT INTO yaqNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","intok ini'i, bemelaka, jum tetapo ya'ari, a' attea, aapo'ik betchi'bo a' ya'ateboka'po, junama'a a' teekak. Chukula junaka'a, jum ama kima'awa'po, bwe'u tetae a' pattasuka, siika. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Intok junama'a ket, Maria Maareena' teame intok ju'u senu Maria, a' tekwaka'po bichapo jookan. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Juchi yokoriapo, aet yum jo'ewamta taewaita betchi'bo, si'imeta tu'utesuako, aet chukula jume' te'opopo tekiakammeu yo'owe intok jume' paiseeom teame, inime'e ju'u Pilaatotau yajaka ");
INSERT INTO yaqNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","intok inime'e: ―Achai, wae yee bai tatta'asukamtau itepo waatek, ketun jiapsakai, junaka'a inen: “Baji taewata weyeka, kokkolam nasuk au jiabijtene'eti”, jiaka a' teuwaaka'ubewi ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Inia betchi'bo jum a' bo'oka'u, empo baji taewata simsu'utajtia a' bitneeme aman bittuane. Junuen jume' a' majtim ka aman sajaka tukaapo juka' takaata bem a' nuk sajaka, intok chukula, yoemratau: “Kokolam nasuk jiabijtek”, ti bem jiune' betchi'bo. Bwe'ituk junuen yeu a' siiko, ini'i, bat naataka bepa, che'a bwe'u aa noki'ichia tu ean ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ju'u Pilaato inimmeu: ―Junum eme'e am jipue jume' sontaaom. Eme'e, aman sajaka, jum a' bo'oka'po, tu'isi enchim a' waata'po aman, a' suua tebone ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Junak intok inime'e sajaka intok jum a' bo'oka'u a' bitneeme aman tojak. Bwe'u teta, junaka'a ae pattita, ya'uraata betana machilaata ama chayak. Intok jume' sontaom ama to'o sajakai. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Junak juka' taewai, aet yum jo'ewamta a' simsuko, intok woo busan taewaim aet naate'u yeu matchusekai, ju'u Maria Maareena' teame intok ju'u senu Maria' teame, inime'e, aman juka' tetapo wojo'oria ya'arita bitbaeka sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Junama lautipo intok, ju'u bwia tua utte'aka au yoyoak. Achai Liojta ankeles teeka betana ko'om yepsaka june'elaekan. Ini'i junama'a yepsaka, tetata, tetapo wojo'oriata ae a' pattita, omola a' kechaka intok ae bepa yejtek. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ini'i ankeles, yuku be'oktiata benasi mamachiakai, a' tajo'oriwa intok, sapam benasi tossaalaikai. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","A' bichaka, jume' sontaaom ama a' suua'um, emo yooak majjaekai. Intok inime'e, kia kokkolam benasi taawak. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Junak ju'u ankeles, jume' jaamuchimmeu: ―Kate'em majjae ―ti ameu jiiak―. Ju'uneane, juka' Jesujta a'abo enchim jaiwa'po, juka' kuuset popontukamta, ");
INSERT INTO yaqNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","inim kaabe, bwe'ituk jiabijtelaa, aapo'ik jiaka'a benasia. A'abo kateka, jum a' tekwaka'po em a' jiiwe. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lauti eme'e sajaka intok jume' a' majtimmeu eme'e: “Mukiatukan, taa i'an aapo jiabijtela. Intok jum bwiaraa Kalilea' tea'u aapo emo pat anne. Junaman eme'e a' bitne”, ti eme'e ameu jiune. Ini'i juna'a, ju'u in emou teuwaa'ea'u ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Junak jume' jaamuchim jum tetapo wojo'oria ya'ari betana sep bamsi yeu sajak, majjaekai, intok tua alleakai ketchia. Intok inime'e tenneka, Jesujta majtimmeu, juka' bemelasi ayukamta teuwaabaeka sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Seej chukti inim, ju'u Jesus ameu kikteka intok ameu tebotek. Bempo junak Jesujtau rukteka intok a' wokiu a' iba'acha'aka a' yo'orek. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Intok aapo: ―Kate'em majjae. Aman em sajaka, jume' nemak werim etejoriane, jum bwiaraa Kalilea' tea'u bicha bem katnee'po, intok aman bem nee bitne'po ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ket jume' jaamuchim kateo su, waate jume' sontaaom, a' suuatuawa'um, inime'e, bwe'u jo'arau sajaka intok jume' te'opopo tekiakammeu yo'owemmeu, si'imeta juka' yeu sikamta ameu teuwaak. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Inime'e te'opopo tekiakammeu yo'owe, jume' juriommeu che'a yo'owemmeu sajaka, amemak etejok junuen jitat nau lutu'uriabaekai. Chukula inime'e, jume' sontaaommeu yu'in tomita ameu na'ikiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Intok inimmeu inen jiiak: ―Eme'e, tukaapo enchim ket kokkocheo, jume' Jesujta majtim ama yajaka, juka' takaata etbwak, ti jiune. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Intok juka' kobanaaota inika'a a' ju'uneiyaak juni'i, itepo te a' nok koba'anee intok kaita emou weene' betchi'bo itepo enchim aniane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Junak intok jume' sontaaom junaka'a tomita mabetaka, intok sajaka, juka' bem tejwaawaka'uta a' yaak. Intok jume' juriom i'an tajtia junuen a' lutu'uriate. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Junuen san jume' woj mamni ama wepulaka, Jesujta majtim, bwiaraa Kalilea' tea'u bicha sajak, jum kawi, Jesujta am tejwaalatuka'awi. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Intok junak, inime'e, juka' Jesujta bichakai a' yo'orek. Taa wate ala, ka junuen witti a' juna'atuka'po a' ta'aak o'oben. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Junak intok ju'u Jesus ameu rukteka intok inimmeu: ―Teekau intok kia inim bwiapo juni'i, si'imekuu che'a in yo'otunee'uta, inepo ne i'an a' mabetri ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Junuen san eme'e, inim si'ime ka nanau machi yoemratau sajaka, intok inime'e nee betana weyemta bem sualne' betchi'bo ameu noknee. Liojta betana intok a' yoemiawata intok aapo'ik tu'u jiapsi betana lutu'uriaka, eme'e am bato'owaa sakane. ");
INSERT INTO yaqNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Intok eme'e, si'imeta juka' in enchim aet tejwaa'uta, junaka'a, bempo'im a' bo'o jooriane' betchi'bo eme'e am majta sakane. Intok inim si'imeta lu'ute'u tajtia, jiba ta'apo in emomaktune'po eme'e a' ju'uneiyaane.");
INSERT INTO yaqNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Liojta tu'i nok lutu'uria inim naateka ji'ojtewa. Ini'i weeme intok, Liojta usi betana nooka, ju'u Jesukrijto' teamtatchi. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bat naataka ju'u Isa'iajtuka'u, Liojta betana noktuawakame, inika'a inien weenemta a' teuwaak, intok a' ji'ojtek, inen jiakai: Senuk epat weenemta, intok epat a' lutu'uria ya'anemta ne epat na'a bittuabae, ti jiia ju'u Lios. Juna'a intok, ju'u yoemra enchi bat mabetneeme, eewas, bem jiapsim bem tu'utene' betchi'bo, ameu nokbae. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ju'u jiawai bweka pa'aku chaipo benasi machine: “Juka' achaita, a'abo weyemta, enchim mabetne' betchi'bo, aawas enchim jiapsim tu'utekai, juka' ka tu'i weyemta su'u toja'em”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Inien a' weye'po, ju'u Joan yee babatoowame, juna'a junen ama yeu yepsak, bweka pa'aku, intok Liojtau bicha bem emo jiapsi kuaktanamta ameu teuwaak. Intok bem ka tu'uwa ya'arim betana, aet emo jiokoitune' betchi'bo, ket ameu nookak, intok inen auka, bem batoowatune'po amani. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Junaman intok, Jurea bwiara betana, bwe'u jo'ara Jerusalen tea'po betana, a' jikkaji betchi'bo, juebenaka aman emo nau tojak, ju'u Joantawi. Intok a' noka'po aman a' jikkajaka bem jiapsipo a' sualekai. Junama'a batwe Joran tea'po emo batoowatebok; bem ka tu'uwa ya'arim Liojtau bicha am teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ini'i Joan teame kameyo boa ausu'lik supe ya'arimpo kobakan; beata wikosakan. A' bwa'ee'u waka wo'ochim benaekan, intok juka' mumu ba'awata je'een. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Intok ameu nokaka inen jiiak: ―Chukula senu a'abo yebijne, juna'a tua Liojta betana utte'akai. Ne intok, ka neu lutu'uriatu maisi maachi, kia au kom pokteka, a' bocha wikiawam in a' woitariane'po amani. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne intok ―ti jiia ju'u Joan―, kia lautipo betchi'bo, ba'ammea ne enchim batoowa, taa juna'a, Liojta tu'u jiapsi emot autuane ―ti jiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jesus intok, juname'e taewaimmet, senu ili jo'ara Nasaret tea'po betana, bwia Kalilea' tea'po katekame, juna'abo tana, Joan yee babatoowamtau aman yepsak. Intok aapo ket batwe Joran tea'po batoowatuk. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Intok junama'a batwepo, ba'apo yeu simsuka, sep, juka' teekata, na'ikim au a' etapolaata benasi bichak ju'u Joan. Intok juka' Liojta tu'u jiapsi, wokkoita benasi, aet ko'om yejtesusekamta bichak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Intok juna'abo, teeka betana, jiawai aman ko'om yuumak, inen jiakai: ―Empo ju'u in yoemia ―ti jiia―, tua in nake'u, intok etana in allea'u, tu'isi net aayuk ―ti jiamta jikkajituk. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Junama'a sepsu, ju'u Liojta tu'u jiapsi, mekka bicha, senu bweka pa'ariau bicha a' weene' betchi'bo, junuen a' jiapsipo a' eetuak juka' Jesujta. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Juna'a Krijto intok, woi taka taewaimpo tajtia, junama'a bweka pa'aku, aapola aanek. Ju'u yoo bebeje'eri, Satanaj teame intok, ka tu'ik a' yaa i'akai, a' utte'a jooriaka, au yepsaka ama aamak aanen. Pocho'oku ka nanau machik yoawara ame naat aanen ketchia. Intok Liojta sawe'um, ankelesim teame, a' ania betchi'bo ama aamak aanen. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juka' Joan yee babatoowamta, ya'uraapo eta'ituko, aet chukula, ju'u Jesus, Kalileom bwiarau yepsak. Junama'a intok, juka' Liojta nok lutu'uriata a' teuwa simen. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Intok: ―Taewaim yuma'asuk ―tiaka―, Liojta amet yee saune' betchi'bo ―ti jiia ju'u Jesus―. Inia betchi'bo ―tiia―, enchim ka tu'uwa ya'arim ka intok am bo'o jooriaka, Liojta tu'i nok lutu'uriata suale'em ―ti jiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Junama'a intok, Kalilea' tea'po, intok bawe naat weamaka, woi yoemem ama bichak, emo sairakame. Juka' Simo' teamta intok juka' Antej teamta bichak. Juname'e intok, kuchum yeu baubaekai, bem jite'im ba'au jimaalataka ama aanen. Bwe'ituk kuchuleomtukan. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Junammeu intok ju'u Jesus inen jiiak: ―Nemak ne enchim kat i'a ―tiia―. Bwe'ituk ta'abwi tekilta ne enchim joo i'a. Bwe'ituk yoemrata, bem jinne'utune' betchi'bo, enchim ne ameu nok i'a ―ti ameu jiiak ju'u Jesus. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Juname'e intok, bem ae tekipanoa'uta, kia ama wo'otaka, sep Jesujtamak sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Junama'a intok, che' a bichau jeela weyeka ju'u Jesus, juchi jume' woi yoemem bichak, emo sairakame, Jakoobo' teamta, Sebereo' teamta u'usi, intok juka' a' sairawata Joan teamta bichak. Intok kuta kanoat jikat jokame, intok bem jite'im cha'abwammeu yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus intok sep junammeu, aapo'imak am katne' betchi'bo ket ameu nookak. Juname'e intok, bem achaiwata, Sebereo' teamta, intok a' tekipanoareommak nau, jum barkopo to'o sajaka, Jesujtamak sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Si'ime nau, bwe'u jo'ara Capernau' tea'u yajak. Junama'a intok, sabala ta'apo beja, Liojta yo'ori betchi'bo intok Liojtau bicha nok betchi'bo, jum juriom nau emo totoja'po, bwe'u kariwi kibakeka ju'u Jesus, ama yee majta taitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Juname'e intok, Jesujta yee majtaka'ut, tu'isim a' sum eiyaak. Bwe'ituk aapo ju'u Jesus, yee a' majta'ue, seenu, yo'o lutu'uriakamta benasi ameu nookak, intok ka jume' bem maejtom ama'a yee majta'um benasia. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Junaman lautipo intok, bwe'u karipo nau emo totojiwa'po, senu yoeme aman yeu yepsak, bebeje'eri jiapsita a' jiapsipo aet aneo, ka tu'isa'a eetua'u. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Juna'a intok, chai nokpo, inen au jiiak: ―Empo Jesus ―ti jiia―, bwe'u jo'ara Nasaret tea'po jo'aakame, jitasa empo itomak lutu'uriak ―ta' temaek―. Empo jumak ka amma'ali itomak a'abo bo'o jooseka weye ja'ani ―ta' temaek―. Ette ju'unea, Liojta betana em tu'u jiapsi usiarituka'po ―ti jiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Taa ju'u Jesus, junae bebeje'erita ka tu'i jiapsita, yoemta jiapsipo wajiwa katekamta nok yaatituak. ―Junue yoem jiapsipo em kateka'po yeu weye'e ―tau jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Junak intok, junaka'a yoemta, ju'u bebeje'eri jiapsi aet ane'u, tu'isi utte'aka a' takaawata au yootuak, intok aet yeu weepatchi, kusisi a' chachaituak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Si'ime ama aneme intok, Jesujta yaaka'uta bichaka a' sum eiyaak. Juname'e intok a' bichaka, inen nau jiu japtek: ―Jitasa tua ini'i ―ti nau jiu japtek―. Bemela wemta itom bittuabae, intok utte'akamta nooka. Intok juka' bebeje'eri jiapsitaka juni'i, a' nesawe'po aman auk. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Intok junama'a naateka, aapo'ik Jesujta a jita joa'apo aman, jum bwiara Kalilea' tea'po, si'imekut ju'uneyya japteak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Junama'a nau emo totojiwa'po yeu sikaa, Simo' teamta intok Antej teamta jo'au bicha sikaa, junaman kibakek ju'u Jesus. Ju'u intok Jakoobo' teame, intok ju'u Joan teame aamak kaaten ketchia. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ju'u Simo' teamta jamut ase'ebwawa intok, tu'isi taji wecheka, ama bo'okan. Intok a' ko'okoe'po aman, Jesujtau sep nokwak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Juna'a intok, mampo a' bwiseka, a' yechak. Ju'u taji wechia intok, sep a' su'u tojak. Sep intok am ji'ibworia taitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Intok kuptisuko, intok ju'ubwa ta'ata aman wetchuko, jume' ko'okoeme aman au yeu tojiwan, Jesujtawi. Intok jume' bebeje'eri jiapsim bem jiapsimpo jipueme, au tojiwan. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Intok junama'a bwe'u jo'arapo jo'akame, batte si'ime au jeela, aman au yajak, puetawi. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Intok junama'a juebenam, ka nanau machi ko'okoakame, emo am ine'etetuak. Intok ket junalensu, jume' bem jiapsimpo juka' bebeje'erita betana ka tu'im jiapsekame, pa'akun yeu am bepriak, intok kaita am noktuak. Bwe'itukim aet ju'unean. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Juchi yokoriapo, tu'isi ketwoo tana, matchuu, yejteka ju'u Jesus, kaabeta ane'u bicha, ili mekka'ekun bicha siika. Junama'a intok Liotau bicha nookak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ju'u Simo' teame intok jume' aamak rejteme, aet chukula a' jariubaeka yeu sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","A' teak intok inen au jiiak: ―Juebenaka intok, aman enchi jaiwa ―tau jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Taa ju'u Jesus, inen ameu jiiak: ―Omot, ta'abwi jo'arammeu bicha te saka'ane ―tameu jiiak―, Liojta nokta in ama nokne' betchi'bo. Bwe'ituk inia betchi'bo ne a'abo yebijla ―ti jiia ju'u Jesus. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Juna'a intok, Kalilea bwiarat si'imekut naj weyeka, emo nau totojiwaka ama emo majtawa'apo, ama ameu yepsaka, juka' Liojta nokta ameu teuwaak. Intok jume'e bem jiapsimpo juka' ka tu'ik, bebeje'eri jiapsekame, pa'akun yeu am bepriak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Senu intok, jitae juni'i ka a yoremta taka sa'awakai, ama Jesujtau yepsak. Intok aapo'ik bichapo tonommea kikteka, chikti a' jiapsie au ujbwanaka: ―Achai ―ti jia―, in takapo, juka' sa'awata, empo junen ea'ateko, a' yore'etuane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ju'u Jesus intok, a' jiapsipo tu'isi a' jijiokoleka: ―Jeewi ―tau jiiak―. Yore'enee'e ―tau jiaka, a' takawapo aet mamtek. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Juna'a intok, sep takaapo tu'ireak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ju'u Jesus intok, kaabetau a' etejo saeka au nokaka, inen au jiiak: ―Tua kaabetau em etejone'po aman, aet emo suua'e. Taa che'a juni san, jume'e bem te'opopo ama tekiata makritaka, ameu yo'o ya'arimmeu aman ameu sika, em taka sa'awata, a' yore'etuawaka'po aman, ama junammeu a' etejo'e. Intok Moisejtuka'uta nesaulatuka'po aman aune'e, em taka sa'awata a' tu'uteituka'po aman, jume' ama tekiakame, bem aet ju'uneene' betchi'bo. Intok inen au jiaka, a' simtuak. ");
INSERT INTO yaqNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Taa juna'a intok, aman sika, si'imekut, si'imemmeu nas a' etejo taitek. Intok inia betchi'bo san, ju'u Jesus, bwere jo'arammeu, ka witti a aman kibaken. Taa che'a juni'i, bwere jo'aram mayoat, pa'ariat tatawan. Junama'a intok, si'imekut betana, yoemra ama au nau yaajan. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ka jaiki taewaita simsuko, intok aet chukula, bwe'u jo'ara Kapernao' tea'u yeu yepsak ju'u Jesus. Junama'a intok, senu jo'arapo, ama a' ane'epo ju'uneyyatuk. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Junama'a intok, tu'isi juebenaka ama yajak. Jo'arapo wajiwa ka ama jak kiaka juni'i, pa'akun yeu tajti tapunisi ama aanen. Jesus intok, juka' Liojta nok lutu'uriata ameu teuwaaka ama aanen. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Junak intok, senu yoeme, lo'itaka, a' takaawata ka a yekamta, naikika nau, aapo'ik Jesujtau bicha, chikti a' jipetekwamak, a' pu'ateka kaaten. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Junak intok, juebena yoemrata ama tapunisi ane' betchi'bo, intok ka a aman kimukai, juka' ko'okoemta, kari jikat a' nuk ja'amukamme. Junak intok, junama'a bepa, juka' karita wojoktaka, juka' ko'okoemta, chikti a' jipetekwamak, Jesujtau ko'om teekak. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Junak intok ju'u Jesus, junuen aneme bichaka, intok bem jiapsimpo, tua a' sualeme ju'uneyyaka, ko'okoemtau inen jiiak: ―Jeewi, in yoemia ―tiia―, si'imeta waka'a ka tu'ik em ya'ari'ut, aete'e jiokoiri'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Junama'a intok, bem maejtomtaka, waate ama jookan. Intok Jesujta junuen jiamta jikkajaka, bem jiapsipo inen emo eetuan: ");
INSERT INTO yaqNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Jaisaaka tua ini'i inen jiia Liojta bepa au yo'o jooa,” inien jiakai. “Bwe'ituk ka kia jabe juni'i, juka' ka tu'uwa ya'arita a yetet a' jiokoe. Taa ju'u Lios jiba a yetet a' jiokoe”, tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesus intok sep inien bem ea'uta bem jiapsipo amet a' ju'uneyyaka inen ameu jiu taitek: ―Jaisa betchi'bo eme'e, enchim jiapsipo inien emo eetua ");
INSERT INTO yaqNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ju'u ko'okoemtau, jaisa ne au jia'atek beja, ne tu'isi au jiu ean: “Em ka tu'uwa ya'arita betana'e jiokori'e”, ti ne au jia'ateko, oo: “Yejteka, juka' em jipetekta nau lopoktaka, bamsea, em weebae'u bicha weye”, ti ne au jia'ateko Intok inie wooi weemta betchi'bo, jitasa che'a ka neu obiachi ean ");
INSERT INTO yaqNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Taa i'an ne enchim a' ju'uneyya'ii'a, Lios utte'awata net a' ayu'upo amani, intok, aapo'ik Liojta betana in usiwaituka'po aman, neu lutu'uria, ka tu'uwata ya'alame in a am jiokoine' betchi'bo. Junak intok, lo'itaka intok a' takaawata ka a yekamtau inen jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Inepone eu nooka, kikteka, juka' em jipetekta nau ropoktaka, em jo'au bicha weye'e, ti ne eu jiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Juna'a intok, ama aneme, si'imem bichapo, sep kikteka, a' jipetekwata nau ropoktaka, bempo'im nasuk aman yeu siika. Juname'e intok, tu'isi a' suum eiyaaka taawak. Intok Liojta, tu'uwa noktae teuwaa japteka, inen jiian: ―Jakwoo juni'i, inien yeu simlamta te kee bichan ―tim jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus, junama'a yeu sika intok, bawe mayoau bicha siika. Intok juebena yoemra aman au nau yajak. Junak intok, aapo, Liojta nok lutu'luriata am majtan. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Junama'a intok, che'a bichau jeela weyekasu, senu yoemta, Lebi' teamta ama bichak. Junaka'a intok, ju'u Alpeo' teame a' u'usekan. Ini'i Lebi' teame intok, ya'uraapo betana ama saiwaka, juka' tomita, ya'uraata ae beje'etuanaamtae, junaka'a, aapo ju'u Lebi' teame, nau a' totojituawan. Jesus intok, aapo'iku inen jiiak: ―Nemak weye'e ―ti au jiiak. Juna'a intok, a' kateka'po, kikteka, sep Jesujtamak siika. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chukula intok, ju'u Lebi' teamta jo'aapo, ju'u Jesus, a' majta'ummak nau, junae jo'aapo ama ji'ibwan. Waate intok, juna'a Lebi' teamta benasi, ya'uraapo saiwaka, jiba junaka'a tekilta joame, ket aman au yajak. Intok jume' ka tu'uwata bo'o jooriame, juebenaka ket ama aanen. Intok si'ime nau, junama'a Jesujta ji'ibwa'po ama aamak nau jookan. Bwe'ituk juebenaka Jesujtamak rejten. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jume' intok, bem maejtom, inime'e junen, jume' wate juriom, paiseom teammak nau eame, inime'esan, Jesujta, ya'uraapo tekiakamtamak, intok ka tu'isi anemmak a' ji'ibwamta bichaka, Jesujta majtimmeu inenim jiiak: ―Jaisaaka tua, ju'u enchim majtame, jume' ka tu'isi anemmak ji'ibwa, intok jume' ya'uraapo saiwaka a' tekiakammak ji'ibwa ―ti am temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus intok, inien am jiao am jikkajaka, inen ameu jiu taitek: ―Jume' tu'ik takaaka, ka ko'okoeme, kaachin juka' yee jijittomta waatane. Taa ju'u ko'okoeme ala a' waatane, juka' yee jijittomta. Inienpo aman san, nejpone a'abo ne yebijla, jume' ka tu'isi aulammeu nok betchi'bo, bem jinne'umtune' betchi'bo. Bwe'ituk jume' jaibu tu'isi jiapsame, juname'e, lutu'uriata bo'o jooria. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jume' Joan yee babatoowamta majtala'um, intok jume' waate juriom, bem junuen a' suale' betchi'bo, paiseompo ta'eewame, juname'e taewaimmet, ka jiji'ibwan. Junuen aneka, Liojta emo yo'orituan. Junak intok, waate, Jesujtau sajak intok a' temaek: ―Jaisaakai ―tiian―, jume' paiseom teame, intok Joan yee babatoowamta majta'um, inime'e taewaimmetchi, Liojta yo'ori betchi'bo, ka jiji'ibwa ―tim a' temaek―. Taa jume' em majtim, ka inien a' bo'o jooria ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus intok, inen ameu jiiak: ―Jaisa jujupwaa'u, intok jiji'ibwa'po, jume' junaman nunuritaka, ama aneme, jaisa ka alleaka, ka aman ji'ibwanee ja'ani Ka junuen weye. Bwe'ituk junako, ju'u jubeme, au sioktuane. Che'a juni san, juka' jubemta ketuni ama aneo, alleaka aamak eaka, ji'ibwane ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Taa chukula ket ―tiia ju'u Jesus―, taewaim yuma'ane ―tiia―, juka' jubemta kaabetuko, junak intok, siokrimmea ka ji'ibwane. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Inien a' wee'po san ―tiia ju'u Jesus―, kaabe ju'u bemela tajo'orim, moera tajo'orimmet jitcha'abwabaane. Bwe'ituk baksiapat, ju'u bemela tajo'orim, si'imeta nau wikeka, jume' tajo'o moeram nau wikeka, am siutane. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Inien a' wee'po san ketchia, intok kia jabe juni'i, juka' pa'asi ba'awata, bemelasi ya'ata, bea boosa ya'aripo, ju'u moerapo, kaachin ama a' to'obaeka'eene. Bwe'ituk ama'a to'aaka'ateko, ju'u bea, a' moeratuka' betchi'bo, lauti siutane. Junak intok ju'u pa'asi ba'awa wo'otine, intok kia ju'u bea juni'i, nasontune. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jesus intok, sabala ta'apo, yum jo'e taewaet, tiikom, jaibu wake'epo aman weyen. Jume' a' majta'um intok, aamak kateme, juka' tiikom kautakai, am biitakai, am bwa'een. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Waate juriom, paiseompo emo teuwaame, intok junuen aneme bichaka, Jesujtau inen jiian: ―Jume' em majta'um bicha'e ―ti au jiian―. Sabala ta'apo, kaitat mammawaka, Lioj waatiawa'a taewaituko juni'i, inime'e inien aane ―tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jesus intok inen am yoopnak: ―Jaisa eme'e, jum Liojta ji'osia ji'ojteimpo ka'a nokla ja'ani, juka' Labiituka'uta a' yaaka'uta Bwe'ituk, aapo ju'u Labii' teame, tebaurekai, intok jume' aamak rejteme juni'i. Junak intok ju'u Abiatar teame junaman tekiakamtau ama yo'otukan. Ju'u Labii' teame, aman karipo, Liojta aman yo'oriwa'po kibakek. Kariu kibakeka, intok jume' paanim, ama tekiakame bwaa'ea'um, ju'u Labiit am bwa'aka, intok ka aapola jiba am bwa'aka, taa ket jume' aamak rejteme am miikak. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","’Junuen a' wee'po san, ju'u sabala taewai, yum jo'e taewaita Lios a' ju'unaktela, yoemtau tu'uwaitune' betchi'bo, aet yum jo'ekai. Taa ju'u taewai, ka yee utte'a jooria. ");
INSERT INTO yaqNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Inia betchi'bo san, nejpo, emo benasi yoemtaka juni'i, yee a sawe, yum jo'e taewait juka' bem a bo'o jooria'po amani. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Juname'e taewaimmet, jum juriom emo nau totojiwa'u kariu kibakek. Junama'a intok, senu o'ou ama katekan, wepul takana mam wakiatakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sabala taewaituka'po aman intok, junaka'a jitto machiaka, jume' ama aneme junuen, Jesujta suuan, junuen a' ayuk juni'i, sep a' na'atejobaeka ean. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Junak intok ju'u Jesus junae yoemta, waki mamakamtau: ―A'abo neu sikaa, in bichapo kikte'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Junak intok ju'u Jesus, si'imemmeu inen nattemaek: ―Sabala ta'apo, jitasa che'a tu'i ean, tu'uwata yeteu joowame, oo ka tu'uwata Oo senuk me'etune'po, oo senuk jinne'utune'po. Taa junuen a' jiao intok, ka wotti tawawak. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus intok, si'imem, ka alleaka naj bitchun. Intok bem namakak jiapseka' betchi'bo, au sioktuak. Junae yoemtau intok, wakiak mamakamtau inen jiiak: ―Em mamam rutukta'e ―ti au jiiak. Juna'a intok, a' mamawam rutuktak. Intok sep tu'ureak. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Taa jume' waate juriom, bem junuen a' suale' betchi'bo, paiseompo ta'eewame, inime'e junen, junama'a yeu sajaka, jume' eroorianom teammak nau eaka, emo nau tojaka, nau wepul lutu'uriata ya'abaekai, Jesujta jachin juni'i a' bwiseka, bem a' me'ene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Taa ju'u Jesus intok, a' majta'ummak nau, baweu bicha siika. Intok Kalilea' bwiaraapo jo'aakame aamak sajak. Intok ket junalensu, Jurea bwiaraapo jo'aakame ketchia. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Intok ket jiba junalensu, bwe'u jo'arapo Jerusalenpo jo'aakame. Intok Tiiro' tea'po jo'aakame. Intok Siron tea'po jo'aakame. Intok Irumea bwiaraapo jo'aakame. Intok waate, batwe Joranta beaj jo'aakame. Inime'e junen, si'ime, suum watchisi machik a' joa'apo aman a' ju'uneyyaka, juna'abo, si'imekut betana, juebenaka ama au nau yajak, Jesujtawi. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Junama'asan, juebena yoemrata ama au nau yaja' betchi'bo, intok ka ama nau a' pitta i'aka, a' majta'ummeu inen jiiak: ―Juka' kuta kanoata, junama'a ba'apo bo'okamta, mayoau jeela rukta'em ―ti ameu jiiak, ama ja'amubaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bwe'ituk aapo ju'u Jesus, junama'a jaibu juebenam emo inne'etetualatukan. Intok jume' waate, ko'okoeka, ama aneka, kia aet mamte betchi'bo, nat emo yuu'an, intok aapo'ik bat batte ba'au ko'om a' taben. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Intok inen ket ama yeu siika, jume' bebeje'eri eerita, bem jiapsimpo amet aneme, juname'e junen, juka' Jesujta bichaka, aapo'ik bichapo tonommea jajapten. Jume' bebeje'eri jiapsim intok, inien am chaituak: ―Empo juna'a, Liojta usiwai ―tim jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Taa ju'u Jesus intok, a' jabetuka'po ka'a ju'uneyyatune' betchi'bo, kuttipo ameu nookak. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Aet chukula intok, senu kawiu, jika pa'ariau bicha siika. Intok junaman kateka, ameu chaitebok, jume' a' majta'um, yeu a' pu'ala'ummewi. Juname'e intok aman au yajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Junama'a aapo'ik mak nau an betchi'bo, intok aet chukula juka' Liojta nok lutu'uriata bem a' nok sakane' betchi'bo, aet a' tekil maknee'um, woj mamni ama wooim yeu pu'ak, ju'u Jesus. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Junak intoko, utte'awata amet autuak, bebeje'eri jiapsi eerita, bem jiapsipo amet aneme, pa'akun yeu am bepriane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Juname'e intok inen teakan. Seenu, Simo' tea. Junaka'a intok, Peeom a' teatuak. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jume' watem team intok, iiyime juname'em. Jakoobo' teame, Sebereo' teamta u'usi. Intok a' sailuawa, ju'u Joan teame. Juname'e ket ta'abwim teatuak. Ebreo nokpo nokwame. Juname'e intok, Bo'aneerjim tea. Jiak nokiu juchi a' kuaktituk intok teekapo yuku ru'uti jiame, ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Intok ju'u Antej teame. Intok ju'u Jeriipe' teame. Intok Battome' teame. Intok ju'u Mateo' teame. Intok ju'u Tomaj teame. Intok ket Alpeo' teamta u'usi, Jakoobo' teame. Intok ju'u Tareo' teame. Intok senu Simo' teame, kananiita' teammak nau eame. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Intok ju'u Juuras Ijkarioote' teame, ju'u chukula a' nenkineeme. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Junak intok a' jo'awawi yeu yepsak. Taa junama'a a' aneo intok, tu'isi juebenaka ama au nau yajak. Aapo intok, kia ammea ka ji'ibwan. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Taa jume' Jesujta wawaekame, intok, inien a' jikkajaka, aman a' aneo au sajaka, ama yeu a' wikbaen, “ka'a suatula”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Waate ket ama aanen, maejtompo ta'eewame, Jerusalen tea'a betana. Juname'e ket inen jiian: ―Juka' yo'o bebeje'eri jiapsi e'eri aet ane'e ―tiian. Juna'a eeri intok, bem nokpo, Be'elsebuupo ta'eewan. Intok ket inen jiian: ―Yo'o bebeje'eritamak a' lutu'uriak ―tiian―. Kiali'ikun junae utte'awatae, jume' bem jiapsimpo jume' waate bebeje'eri e'eerim yetet ane'um, yeu am bepria ―tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesus intok, juname'e maejtommeu chaiteboka: ―Jaisa i'an ―tiia―, aapo ju'u yoo bebeje'eri, Satanaj teame, aapo au yeu bepbaanee ja'ani ―ti am temaek―. Ka junuentune ―tiia. Junak intok, ta'abwi weemtau a' tammachiaka inen ameu jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","―Kia wa'a senu bwiaraapo, si'ime ama nau jo'aakame, nasuk aman emo na'ikimteko, intok nau nassuabae'eteko, juname'e, ka binwatukasu, kaita'po tawane ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Intok ket jiba junalensu, jume' wepul jo'arapo nau jo'aaka, intok emo ee beje'eteko, juname'e ka a nau jiapsine ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Inien san beja, ju'u yoo bebeje'eri, Satanaj teame, jaisa i'an aapo jume' ka tu'i jiapsi eerim, aapo'ik attearim, jaisa am beje'eka anne. Bwe'ituk aapo ju'u Satanaj teame junuen anne'eteko, kaachin am saune ―tiia. Junak intok: ");
INSERT INTO yaqNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","―Kia jabe juni'i ―tiia―, jo'arapo wajiwa aman jita etbwabaeka ama kibake'eteko, taa ju'u intok, ama jo'aakame, utte'aka'ateko, intok ama ane'eteko, ju'u ama jita etbwabaeme, kaita a' u'uraane. Taa kia juka' ama jo'aakamta a' sumaka'ateko, junak ala, a jita ama etbwane ―tiia―. Inepone, ju'u o'outa, utte'akamta sumakamta benasi ne maachi. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Inepo intok, lutula we'epo ne inien ne emou jiia, batte si'ime wa'a ka tu'uwa ya'arime, a jiokoitu. Intok juka' bat naataka, Liojtat jaana jiuwamta juni'i, a amet jiokoitu. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Taa juka' ka tu'uwa ya'arita, senu weemta jiba ka a aet yee jiokoitu, waka'a Liojta tu'u jiapsiwata jaana a' jiawaanaa'u. Bwe'ituk inien wa'a jaana a' jiawaakame, jiba yuu betchi'bo ka a aet jiokoitune. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus inien ameu nookak, bwe'ituk bempo juka' bebeje'eri jiapsi eerita, jaiti machik aet ane'etiakai, tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","A' aewa, intok a' sailawam ama yajaka, pa'aku japteka, aman au chaitebok. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Intok jume' che'a Jesujtau jeela jokame, inen au jiiak: ―Ju'u em maala, intok jume' em sailam, pa'akun ja'abweka, eu chaitebo ―tim au jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Taa ju'u Jesus intok inen am yoopnak: ―Jabesa ju'u in maala intok, jabesa jume' in sailam ―ti am temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Junak intok, si'imem, ae nape konila jokame naj bitchuka inen jiiak: ―Inime'e juname'e, jume' in aem, intok jume' nemak werim. ");
INSERT INTO yaqNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bwe'ituk si'ime juka'a, in achaita ea'apo aman aneme, juname'e nemak werimtune. Oo ne ket a' ae rokne. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Intok juchi wee'po, bawe mayoat aneka, yee majtataitek. Intok tu'isi bu'uuka aman au nau yajak. Intok bu'uuraata ama ane' betchi'bo, utte'atukan, kuta kanoat, bawepo bo'okamtat, jikau a' ja'amune'po. Aapo intok, ama jikat katekan. Ju'u bu'uura intok, pa'akun tana, bawe mayoat ja'abwekan. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Aapo intok ju'u Jesus, intok, ta'abwi weemtau a' tammachiaka, juebena weemta am majtan. Intok am majtaka, inen ameu jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Neche'em jikkaja ―ti ameu jiiak―. Senu yoeme, echimuta etbaeka, a' wasau bichaa siika. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Junama'a wajpo intok, senu wok bo'ota bo'oka'po, ju'u echimu, waate ama yojtek. Wikichim intok junaka'a sep bwa'aka ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Omot intok, tetata auka'po ket ju'u wate echimu ama yojtek. Junama'a intok, ka mekka ko'om a' bwalkoeka' betchi'bo ―tiia―, ju'u echimu ama yojtekame sep siwek. Taa ka mekka ko'om a' nawatuka' betchi'bo, ");
INSERT INTO yaqNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ta'ata unnaa utte'aka aet yejteka' betchi'bo, sep waakek ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waate echimu intok, juya, unnaa wichaka'po yojtek. Juna'a juya intok, junae echimu siwekamtamak nau yo'otuka, a' chouyaka, intok ka'a takatuak. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ju'u wate echimu intok, tua tu'i bwiapo yojtekame, juna'a, siweka intok yo'otuka, yu'in taakak. Jum wepul sako etwaka'po, jichupaka, senu taka ama woj mamni sakom toboktituk. Omot intok, wepul sako etwaka'po, jichupaka, baji taka sakom toboktituk. Omot intok, wepul sako etwaka'po, jichupaka, mamni taka sakom toboktituk. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Intok inika'a weemta ameu noksuka, aet chukula inen ameu jiiak: ―A' mammatebaeme, a' mammatene ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chukula intok, bempola tawaka, jume' woj mamni ama wooim, yeu a' pu'ala'um aamak ama tawakame, intok jume' waate, che'a aamak eame, ameu a' teuwaaka'uta betana a' temai japtek, jitat a' noka'apo. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ju'u Jesus intok, inen am yoopnak: ―Inepone enchim a' ju'uneyyatuala, juka' Liojta che'a a' nesawamta betana weyemta, aapo'ik atteata, juka' bat naataka, ka aet ju'uneyyawa'utachi. Taa jume' waate, jume' ka aet emo ju'uneetuabaemcha aneme, inimmeu, juna'a si'ime weeme, ta'abwiku a' tammachiaka ameu teuwaawa. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tu'isi bem a' bichaka juni'i, ka a' mammatene' betchi'bo. Intok kia juka' nokta jikkajaka juni'i, ka a aet ju'uneene' betchi'bo, intok Liojtau bicha ka emo jiapsi kuaktane' betchi'bo. Intok junuen bem ka tu'uwa ya'arim amet jiokoitune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Junak intok, inien ameu jiiak: ―Jaisa eme'e juni'i ka aet ju'uneak, ju'ubwa in emou teuwaaka'utachi, ju'u a' teuwaa'ut Junuentuka'ateko intok, jaisa tua, juka' ta'abwi weemta, jitau a' tammachiaka, emou a' nokwako, jaisa tua a aet ju'uneene ");
INSERT INTO yaqNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ju'u bachiata echame, Liojta tu'u nok lutu'uriata yeteu a' teuwaamta benasi mamachi. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bwe'ituk waate yoemra aane, juna'a echimu, bo'ot yejtekamta benasi maachi. Liojta noki jikkajaka, taa chukula a' jikkajisuko, namakak bem jiapseka' betchi'bo, ju'u Satanaj teame, ameu yepsaka, juka' nok lutu'uriata, Liojta betana weyemta, aawas a' koptituane. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ju'u bwia intok, tetakamta betana in nokaka'u, si'ime wame'e, Liojta nokta jikkajaka, alleaka a' sualeme benasi maachi. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Intok bem jiapsipo ka binwa aet eeneeme, juname'e, taa bem omtawaa'uta ju'uneyya taiteko, emo a' rojiktatuaka, sep a' su'u tojibaeka eene. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Juyata, wichakamta betana in emou nokaka'u intok, ju'u bachia ama wajiwa yojtekame, inime'e junen wame'e inim bwiapo aukamta che'a emo naktuame, yu'in tomita waatame, emo ae alleetuabaekai, Liojta nok lutu'uriata bepa a' waatakai. Inia betchi'bo san, inim bwiapo, ju'u Liojta nok lutu'uria, kaita amet a' autua, juka' jiapsitau tu'uwatunemta. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Taa waate, juka' Liojta nok lutu'uriata jikkajakame, intok a' mabetaka, bem jiapsipo a' tawaakame, intok Liojtau bicha jiba emo eetuame. Inime'e junen, juname'e, wa'a bachia, tu'i bwiapo yojteka, intok yu'in bachiakamta benasi maachi. Inime'e junen, Liojta nok lutu'uriat jiapseka, a' tekipanoa. Waate intok, kia juka' bachiata, we'epulaim, senu taka ama woj mamni bachiakamta benasi maachi. Wate intok, juka' bachiata, we'epulaim, baji taka bachiakamta benasi maachi. Wate intok, juka' bachiata, we'epulaim, mamni taka bachiakamta benasi maachi. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Intok ket, inien san beja: ―Kia jabetaka juni'i ―ti ameu jiiak―, a' jo'awapo wajiwa tachiriatunemta jinukame, juna'a, kaachin, bwe'u waata betuk wajiwa a' mana'abaane. Intok kia a' bobo'obetuk juni'i, kaachin ae tuk a' mana'abaane. Taa che'a juni san, jikat a' mana'ane, tu'isi a' tachiriane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bwe'ituk wa'a che'a bat naataka, ka ju'uneyyawa'u, a ae emo jiapsi jinne'uwame, oo ju'u si'ime ka a aet ju'uneetume, juna'a si'ime, chukula ju'uneyyatune. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","In noksuka'ut, aet mammatebaeme, aet mammatene, ju'u a' teuwaa'utchi. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Taa ket inen ameu jiiak: ―Juka' enchim jikkajaka'uta, tu'isi em aet suuaka, a' jikkajine. Bwe'ituk Liojta, tua a' waata'po aman, junuen aet jiapseka a' bo'o jooria'ateko, ju'u Lios ket junuen, juka' emou tu'inee'uta, emou a' autuane. Intok kia jaarekisia em a' maktune, eme'e a' mammateme. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bwe'ituk, ju'u che'a a' mammatekame, Liojta betana, che'a juni'i aet ju'uneetuanaa. Taa intok, ju'u ka aet mammatekame, kia juka' iliikik a' mammateka'ut juni'i, aawas a' koptituanaa. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Intok naa buusti, tiia: ―Ket inien bena, ju'u Liojta utte'awa nesauta kateka'po betana ju'u lutu'uria weyeme ―tiia―. Senu yoemta, bwiapo, echimuta wo'otaka'a benasia mamachi ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Juna'a intok, tukaaria yumak, kotne. Intok taewaita yumak, yejtene. Ju'u echimu intok, aapola bwiapo basiune. Intok yo'otune. Aapo'ik juka' o'outa ka ju'uneao juni'i ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bwe'ituk ju'u bwia, a' utte'aka'po aman, juka' echimuta, ama a' wo'otawaka'uta, a' babasiuyaa. Juna'a intok tiiko, kia beja bat siulatune. Chukula intok moane. Chukula intok sewane. Intok sep jeela bachiataitine. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Juka' etta, wakeo intok, a' chuktaneeme au kima'atune. Bwe'ituk jichupawaa'u taewaitune. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Intok ket inen ameu jiian: ―Liojta utte'a nesawamta, ama naa buusti, jita ta'abwikuusa tua, te a' tammachiane ―ti am temaek―. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Juna'a ala inen maachi, mojtaasa bachiatau ta'a tammachiane. Bwe'ituk juna'a, si'ime bachiata junama'a bwiapo etwamta bepa che'a amma'ali beletchi. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Taa chukula, jaibu etrituko, siweka, yo'otuka, intok junama'a si'ime juyata bepa, che'a bwe'uusi yo'otuka, na'ikim nassa'akariane. Wikichim juni'i, a ama tosatene. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Intok juebena weemta, ka nanau machikue, bem a aet ju'uneene'ut ameu nookan. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Intok bu'uraatau, jita ameu teuwaabae'eteko juni'i, ta'abwi machilaatau a' tammachiaka ameu a' nookan. Taa chukula, jume' a' woj mamni ama wooimmeu, a' majta'ummeu, junaka'a weemta machisi ameu a' teuwaan. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Intok jiba junae taewait, kuptisuko, a' majta'ummeu inen jiiak: ―Inie bawe ba'ata waetana bicha te katne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Intok juka' bu'uu yoemrata, ama anemta to'o sikaa, intok jiba junama'a kuta kanoapo, bem ane'epo, omot bicham bawet bo'o joo japtek. Intok ket waate ama aanen, wate kuta kanoammetchi. Juname'e intok ket aamak sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Intok tu'isi bwe'uusi jejekak. Intok jume' bawe biaktiam, kuta kanoapo wajiwa am beban. Intok che'ewasu ba'ae tapunan. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aapo intok ju'u Jesus, kuta kanoapo, amapo, bwe'u tajo'orim nat ropoktimmet bo'oka, kotchimen. A' majta'um intok a' busaka: ―Rabii ―tim au jiiak―. Jaisa, abe inim itom kokko'u juni'i, empo kia kaachin emo eetua ja'ani ―tim a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Junak intok sep busak, ju'u Jesus, intok yejteka, jekatau: ―Yaate'e ―ti au jiiak. Bawetau intok ket junalensu: ―Yanti cha'atu'e ―ti au jiiak. Junak intok, ju'u jeeka cha'atuk. Aet chukula intok si'ime, yanti taawak. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesus intok bempo'immeu inen jiiak: ―Jaisaaka eme'e, unnaa emo majjaitua ―ti am temaek―. Jaisa eme'e, enchim jiapsipo, Liojtat ka yoem'ea ―ti am temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Juname'e intok, tu'isim a' suum eiyaka taawak. Intok inenim jiian: ―Ini'i intok, jabetakasa tua Kia ju'u jekataka juni'i, intok kia ju'u bawetaka juni'i, aapo'ik nesaweka'po aman aauk ―tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Intok sekka'ana bawe betana, bwiara Kalaara' tea'po yajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aapo Jesus intok, kuta kanoapo yeu siika, junama'a intok senu yoeme, kokkoarim ma'ari'po jiba a'aneka, intok bebeje'eri ka tu'i jiapsi eerita a' jiapsipo aet aneka, Jesujtau yeu sikaa, a' nankek. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Juna'a intok, kokkoarim ma'ari kari ya'arim jiba jojo'an. Intok kia sisi'iwok wikiam ya'arimmea juni'i, ka a suma'atun. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bwe'ituk jue benasia, sisi'iwok wikiammea, intok mampo ae a' suma'im susumawan. Intok mampo yee ammea susumammea chatchaawan. Taa juname'e wikiam intok, aapo a' utte'awammea am chuk chuktan. Intok mampo ae a' suma'im juni'i, chuk chukti wiiken. Intok kia jabe juni'i ka'a yu'een. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Juna'a intok, tukaariat intok taewait naa buusti, kaupo jiba chai sisimen. Intok kokkoarim ma'ari'po jiba weaman. Intok tetammea jiba ko'okosi au joo sisimen. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Intok Jesujta mekka'ekut bichaka, au tajtia buiteka, au tonommea kikteka, a' yo'ori taitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Junak intok ju'u bebeje'eri jiapsi, aet wajiwa aneme, kusisi inien a' chaituak: ―Jesus ―tiia―, Lios, si'imem bepa yo'orisi machik u'usi ―tiia―. Jitasa empo nemak lutu'uriak. Liojta betchi'bo eu ne ujbwana, ka bat ko'okosi em nee ya'ane' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bwe'ituk ju'u Jesus, inen jaibu au jiulatukan: ―Empo, bebeje'eri ka tu'i jiapsi, inie yoemta jiapsipo wajiwa betana yeu weye'e ―ti au jiulatukan. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus intok, junau, ka tu'i jiapsitau: ―Jaisa empo teak ―ti a' temaek. Juna'a intok, inen a' yoopnak: ―Bu'uuraapo te ta'eewa, bwe'ituk tu'isi juebenate ―ti a' yoopnak. Bem nokpo intok, Lejionpo ta'eewan. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Junak intok juname'e bebeje'eri, ka tu'i jiapsi e'eri, tu'isim Jesujtau jiokot jiaka am au ujbwana, junama'a bwiaraapo pa'akun mekka bicha ka bem yeu beeptune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Junama'a intok, senu kawiu jeela, kowim tu'isi juebenaka ama ji'ibwa sasakan. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Juname'e si'ime intok, bebeje'eri jiapsi ka tu'i e'eri, Jesujtau tu'isi jiokot jiaka, au ujbwanan: ―Juname'e kowimmeu itom bittua'e, amet itom kimune' betchi'bo ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Junak intok ju'u Jesus junen ameu a' chupak. Juname'e ka tu'i jiapsi eeri intok, junae yoem jiapsitat yeu sajaka, juname'e kowi jiapsimmet kiimuk. Juname'e intok wooi miil kowimtukan. Intok si'ime, kau bemte'utchi, luula tenneka, baweu ko'om watteka, ama am kokkok. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jume' intok, am suuame, junama'a yeu tenneka, wasampo bem ama wa'am kate'epo, a' etejo sasakan, intok bwe'u jo'arau yeu yajaka, ket junuen a' lutu'uria yaak. Junama'a jo'aakame intok, aman bicha yeu sajaka, aman a' bit betchi'bo, intok jita ama yeu sika'apo aman aet ju'uneebokai. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Intok Jesujtau yajaka, waka'a bat naataka juebena bebeje'erita ka tu'u jiapsi eerita a' jiapsipo wajiwa aet anemta, tu'isi supetuaritaka, yuma'isi suakamtam ama bichak. Intok aet emo jiapsi womtak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Intok jume' waate ama aneme, bat naataka juka' bebeje'eri jiapsi ka tu'i eeriakamta, jachin au yeu a' sika'apo aman, junammeu a' etejon. Intok kowimmeu, jachin ameu yeu a' sika'apo juni'i, ket bempo'immeu a' etejok. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Junak intok, si'ime jume' ama jo'aakame, Jesujtau ujbwan japtek, junama'a bem bwiaraapo betana, pa'akun bicha yeu a' weene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Junak intok juka' Jesujta, kuta kanoau a' ja'amubaao, ju'u bat naataka juka' bebeje'eri ka tu'i jiapsi eeriakamta, junammea jiokot au bichaka'u, juna'a, Jesujtau ujbwanan, aamak weebaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Taa ju'u Jesus ka junen e'eak: ―Em jo'au bicha siime ―ti au jiiak―. Liojta, juka' tu'uwata enchi a' ya'ariaka'po aman, intok tua enchi a' jijiokoloka'po aman, am etejoriane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Junak intok juna'a, sep siika, intok Lekaapolij tea'po, juka' Jesujta, tu'uwata au a' yaaka'po aman, intok tua a' jijiokoloka'po aman, naas a' etejo taitek. Junama'a jo'aakame intok, tu'isi a' suum e'eiyaak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus intok, juchi kuta kanoapo, jiba junama'a bawepo, omot bicha yeu sikaa, omot yeu yepsak. Junama'a intok, bawe mayoau jeela a' aneo, tu'isi juebenaka ama au nau yajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Junama'a intok, seenu, juriom emo nau totojiwaka'po, ama yo'o ya'arime, intok Jairo' teakai. Juna'a ama Jesujtau bicha yeu sikaa, au yepsaka, au tonommea kikteka, ");
INSERT INTO yaqNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tu'isi au ujbwanak: ―Ju'u in maara, unnaa ko'okoe, intok abe muuke ―ti au jiian―. Empo aman au sikaa, aet mamte'e, tiia. Bwe'ituk junuentuka'ateko, juna'a, au inne'eteka, jiapsine ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesus intok aamak siika. Junak intok, juebena yoemra aamak sajaka, nasuk a' weeyaka, kia nau a' pitta sakan. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Junama'a intok, senu jamut, woj mamni ama wooi wasuktiapo, ojbota jiba wo'otan. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Intok juebena yee jijittome a' jittolatukan. Intok si'imeta a' jipue'uta amet wiutak. Intok kia junuentaka juni'i, yu'in eewamta kaita jajamek. Che'a juni'i, ka tu'i simen. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Intok Jesujta ama ane'e betana ju'uneyyaka, juebena yoemrata ama ane'epo, nasuk aman kibakeka, Jesujtau amatana au yepsaka, a' supewammet mamtek. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Bwe'ituk inen au eetuan: “Kia ne a' supewammet mamteka'ateko juni'i, ino ne ine'etenee”, ti au eetuak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Junak intok junama'a lautipo, ju'u ojbo sep cha'atuk. Intok junae ko'okoata betana au a' inne'eteka'po aman, a' takaawata tu'isi maisi a' inne'an. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Junak intok, ju'u Jesus, senuku tu'uwatunemta aapo'ik takaapo yeu simlatau ju'uneyyaka, bu'uu yoemratau bicha kuakteka, inen ameu nattemaek: ―Jabesa ju'u in supemmet mamtekame ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A' majta'um intok, inen au jiiak: ―Empo yekaka ju'unea, yoemrata tu'isi enchi nau pitta'po, intok: “Jabetasa junen em supemmet, et mamteka'po”, nattemae ja'ani. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Aapo intok, ju'u Jesus, nape konila, si'imem naj bitchutaitek, ju'uneebaekai, jabeta aet mamteka'po. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Junak intok ju'u jamut, au yoakai, intok au majjaituaka, jachin au yeu simla'po aman, ju'uneakai, Jesujtau yepsaka, aapo'ik bichapo, tonommea kikteka, aapo'iku au yeu bwiseka, au nookan Jesujtawi. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Junak intok ju'u Jesus inen au jiiak: ―In jamut yoemia ―tiia―, em a' suale' betchi'bo, emo ine'etela'e. Kaachin eaka weene. Intok inia em ko'okoata betana emo ine'etelatakai ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ket junuen a' nokaosu, ju'u yo'o ya'arime, Jairo' teamta jo'aa betana, waate ama au yajak, inien jiakai: ―Em mara muukuk ―tim au jiian―. Kat intok inika'a yee majtamta suate bicha ―tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Taa ju'u Jesus inien jiuwamta jikkajaka, yo'o ya'aritau Jairo' teamtau, inen jiiak: ―Kate'e jachin emo eetua'e ―ti au jiiak―. Net yoem'ea'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Intok kaabeta intok aamak wee'ii'ak, taa juka' Peo' teamta jiba intok juka' Jakoobo' teamta, intok juka' Joanta, Jakoobo' teamta saira. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Junak intok, juriom emo nau totojiwa'po betana, ju'u ama yo'o ya'arimta jo'apo yepsak. Intok juebenammeu, bwanaka, te'inemmeu yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesus ameu kibakeka, inen ameu jiiak: ―Jaisa em aulamtaka, ama butti jiia ―ti am temaek―. Ju'u usi jamut ala, kia beja kotche, taa ka mukia ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Junuen a' jiao intok, juebenaka kiala'a atbwaka, jak wa'am a' eeyan. Junak intok, aapo ju'u Jesus, pa'akun bicha si'imem yeu beebaka, usi jamutta bo'okau, a' malawata intok a' japchiwata, intok aamak rejteme, wajiwa bicha am nunuk. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Junaka'a usi jamutta intok, mampo bwiseka: ―Taliita kuumi ―ti au te'eka. Ini'i noki intok, kuaktituk, inen jiubae: “Usi jamut, eu ne junen jiia, enchi ne yejtesae”, ti jiubae ini'i nooki. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Juna'a usi jamut intok, sep yejteka, naj weetaitek. Bwe'ituk woj mamni ama wooi wasukten. Inia weemta betana intok, jume' ama aneka a' bichame, bem jiapsipo, tu'isi a' suum e'eiyaak. ");
INSERT INTO yaqNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Taa ju'u Jesus intok, tu'isi ameu ujbwanaka, kaabeta a' ju'uneyyane' betchi'bo, kaabeta am etejoriasaen. Intok juka' usi jamutta a' ji'ibwatuanesaen. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus intok, junama'a yeu sikaa, tua a' bwiarau, ama a' yo'otuka'po yeu yepsak. A' majta'um intok, aamak aman yajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Intok juka' sabala taewata yumako, Liojta yo'ori betchi'bo, intok Liojtau nok betchi'bo, jume' juriom nau totojiwa'po yepsaka, ju'u Jesus, yee majtataitek. Juebenaka intok a' jikkajaka, a' suum eiyaan, intok inenim jiakai: ―Jaksa tua, ini'i, inika'a weemta ta'aak. Intok jita koba suawasa ini'i aet ayuka'u. Intok juka' suum watchisi machik, jaisa tua aneka, a' jooa. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Jaisa ini'i ka juna'a, yoem kapinteota u'usi, intok Maria' teaka a' ou'asoak. Intok a' sailawaim si'ime inim itomak aane. Ju'u Jakoobo' teame, intok ju'u Jose' teame. Intok ju'u Juraj teame. Intok ju'u Simo' teame. Inime'e si'ime inim itomak aane. Intok ket a' jamut waiwam si'ime inim itomak aane, tiian. Intok si'ime jume' ama aneme, ae tana, jaana emo eetuak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Taa ju'u Jesus intok, inen ameu jiiak: ―Kia jabe juni'i, Liojta betana weyemta a' ju'uneyyatuawame, yeteu a' teuwaane' betchi'bo. Juna'a, jak juni'i a' ane'epo, a' noka'u betana, yo'oriwaka, jikkajitune. Taa tua a' bwiaraapo a' jome'epo, intok jiba a' ta'eewa'po, intok kia a' jo'awa'po juni'i, junama'a jiba, a' noka'u betana ka eeyatune, intok ka jikkajitune. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Junama'a intok, bem ka'a sualbae' betchi'bo, juka' suum watchisi machik, tu'isi jita a' joa'uta, junama'a ka'a yaak. Taa jume' ili ama jaikim, ama ko'okoeme jiba, amet mamteka, emo am inne'etetuak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Intok jume' ka'a sualeme betana, aapo ju'u Jesus, tu'isi am suum eiyaaka taawak, bem ka'a sualbae' betchi'bo. Bwe'ituk bempo ka'a sualen. Intok junama'a ka bwere jo'aram be'ekatana weamaka, yee majta sisimen. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Intok jume' woj mamni ama wooi, a' majta'ummeu chaiteboka, na'ikim wowoim nau, naj bittuak. Intok jume' bebeje'eri ka tu'i jiapsi e'erita bem jiapsipo wajiwa aneme juni'i, yeu am bepriane' betchi'bo, utte'ata amet autuak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Intok bem bo'o joone' betchi'bo, tebe kutam jiba, mampo am machu'utisaen. Intok kaita intok am weeyaasaen. Kia tomita juni'i, kaita am weeyaasae. Intok kia bo'ot bem bwa'anee'u juni'i, ka'am weeyaasae. Intok jita pu'aktita juni'i, ka'am weeya'ii'a. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Intok bea'abochampo wokteka jiba am bo'o joosaen. Intok bem supenee'uta, ka nat wooi a'anaata am weeyaasaen. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Intok ket inen ameu jiiak: ―Enchim bo'o joa'po, jak bwere jo'arau enchim yaja'po, senu a' jo'apo enchim nunuka'ateko, ama jiji'ibwa betchi'bo, intok ama totto' betchi'bo, junama'a jo'aapo jiba tawaane'em, enchim ama anbae'po tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Intok kia jak bwere jo'arapo juni'i, junama'a ka mabetbaawa'ateko, intok enchim noka'uta, ka'a jikkajibaawao, junama'a yeu sajaka, kia juka' ama bwia to'ochiata, enchim wokpo ama emot chu'aktekamta, ama emo wok tatake'em, ka tu'isi bem aula'po aman, bem a' ju'uneyyane' betchi'bo. Inien san beja, inien ne emou jiia, Liojta yee aet ya'uraa bittuane'uta taewaita yumako, juna'a jo'ara, che'a jiokot au bitne, intok bettesi che'a au aune, ju'u bwe'u jo'ara Sorooma' teamta bepa, intok ju'u bwe'u jo'ara Komoora' teamta bepa. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Juname'e a' majtim intok, junama'a yeu sajaka, yoemrata, juka' ka tu'ik, ka intok bem a' bo'o jooriane' betchi'bo, Liojta nok lutu'uriata am majta sakan. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Intok jume' bebeje'eri, ka tu'i jiapsi e'erita, bem jiapsipo amet aneme, juebenam junuen, pa'akun yeu am bepriak. Intok jume' kia ko'okoeme, oliibo'ouwo takata, aseite ya'aritae amet bemtaka, emo am inne'etetuan. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ju'u yo'o ya'ari Eroorej teame intok, juka' Jesujta a jita a' joa'apo aman, si'imekut a' ju'uneyyawa' betchi'bo, a' jikkajak. Junak intok juna'a yo'o ya'ari Eroorej teame: ―A' Joan yee babatoowame ―ti jiian―, bat naataka inien, yee babatoowasukame ―ti jiian―. Taa i'an kokkolam nasuk a' jiabijtelatuka' betchi'bo, Liojta betana utte'awae, suum watchisi machik a jooa. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Waate intok: ―A' Eliaj teame ―ti jiian. Wate intok: ―Liojta betana noktuawame'e ―tiian―, oo waate, bat naataka jume' Liojta betana a'abo bittuarimpo a' weye'e ―tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ju'u Eroorej teame intok, inien jiuwamta jikkajaka, aapo inen jiiak: ―Ini'i ju'u Joan yee babatoowame, in koba chuktateboka'u. Kokkolam nasuk jiabijtelataka, inim weama ―tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bwe'ituk jiba aapo ju'u Eroorej teame, Joan yee babatoowamtat nesawek, ya'uraata ye'eta'po a' eta'anesaekai. Ju'u jamut Eroriaj teamta junuen au jiaka' betchi'bo. Ju'u jamut Eroriaj teame, bat naataka a' sailawata jubiawatukan. A' sailawa intok Jeriipe' tean. Juna'a Eroorej teame intok, a' sailawata jubi, jubi'ulatukan. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bwe'ituk ju'u Joan yee babatoowame inen au jiakan, Eroorej teamtawi: ―Kate'e tu'isi aula'e ―ti au jiian―, juka' em saira jubita emo a' juptualatakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Intok ket ju'u jamut, Eroriaj teame, juka' Joanta a' omtaka, a' me'epean. Taa ka ama yuuman. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Bwe'ituk ju'u yo'o ya'ari Eroorej teame, juka' Joan yee babatoowamta au majjautuan. Bwe'ituk tu'isi aet ju'unean, a' tu'u yoemtuka'po aman. Intok tu'i lutu'uriata a' noka'apo aman, ju'u Eroorej teame. Inia betchi'bo san, juka' ka tu'ik au ya'abaemta, kaabeta au suua'ii'an. Intok juka' Joanta au nokaka'uta, ka tua aet ju'uneaka juni'i, a' yo'oreka a' jikkajan. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Junak intok, Eroorej teamta aet yeu tomteka'po taewai yuumak, intok pajkoteboka, intok junama'a aapo'ik ya'uraata a'abojtebok. Intok jume' waate ya'uraapo tetekiakame. Intok bwiara Kalilea' tea'a betana, jume' ama ya'uram. Junama'asan ju'u jamut Eroriaj teame, Joan yee babatoowamtau a' ya'abae'uta, au yaak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Junama'a intok, jamut Eroriaj teamta jamut'asoa, aman kibakeka, ye'eka, ju'u yo'o ya'ari Eroorej teame intok, tu'isi a' musa'uleka taawak. Intok jume' ama aamak ji'ibwaka aamak ama aneme, ket a' musa'uleka taawak. Junak intok ju'u yo'o ya'ari, junae usi bemetau inen jiiak: ―Jita juni'i em waata'uta, neu a'awa'e ―ti au jiiak―. Ne intok, enchi a' maktebone. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Intok tua au a' makne'etiakai, kia jita juni'i, au a' a'awa'uta, ―kia si'imekut in nesawe'po juni'i ―tiakai―, wateku, enchi yo'o yaaka enchi ama nesautuanee juni'i ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Juna'a usi jamut intok, a' malabeu bicha sikaa, aman au nattemaek: ―Jitaa ne tua au a'aune ―ti a' temaek. Junae mala intok inen au jiiak: ―Joan yee babatoowamta kobata, pu'atopo au a'awa ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Junak intok juna'a usi jamut, sep Eroorej teamtau kibakeka, inen au jiiak: ―I'an lautipo ―tiia―, Joan yee babatoowamta kobata, pu'atopo neu tojine ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Junak intok ju'u Eroores, tu'isi ka au alleetuak, inile benasi weemta ka ya'abaekai. Taa a' noka'uta betana, a' tuatune'po aman noklataka, intok jume' waate aamak ama aneme, a' jikkajaka' betchi'bo, aet a' nok mabetaka, aapo'iku utte'atukan, a' nokaka'uta betana junuen aet a' nok mabetne'po. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Junak intok ju'u yo'o ya'ari, ama si'imeta suuame, intok a' nesawata betuk jipueka intok a' sawe'um, senuk, Joan yee babatoowamta kobata aman a' nu'une' betchi'bo, aet a' sawek. Juna'a intok, Joan yee babatoowamta eta'ipo aman au sikaa, a' koba chuktak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Junae Joan yee babatoowamta koba intok, pu'atopo, Eroorejta kateka'u yeu tojiwak. Junama'a intok, ju'u u'usi jamut a' makwak. Ju'u usi jamut intok a' malabeu a' tojak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bat naataka intok, junae Joan yee babatoowamta majtaka'um, inien a' ya'awaka'po aman a' ju'une'eeyaka, a' takaawata aman nu'uka a' ma'ak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jume' Jesujta majta'um intok, aapo'ik betana naj bittuarime, juchi si'ime aman au yeu yajaka, si'imeta waka'a bem tekil yaaka'uta, intok bem yee majtaka'uta, Jesujtau a' lutu'uria jooan. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Junak intok ju'u Jesus inen ameu jiiak: ―Eme'e, nemak, kaabeta ane'u bicha te nau saka'ane. Intok junama'a, chubala juni'i, yum jo'e betchi'bo, tiia. Bwe'ituk junama'a bem ane'epo, ju'u yoemra tu'isi juebenaka, waate saka'asakan, wate intok au yeu yaji sakan. Intok ka a yum jo'en. Intok kia ka ammea a ji'ibwan juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Junak intok, kuta kanoapo ja'amuka, kaabeta ane'epo, omot bicha sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Waate intok, bawe mayoa mak lopola ja'abwekame, mekka'ekut ja'abwekame, ama wa'am am kateo, am junamemtuka'po amet ju'une'eaka, yeu a' yebijnee'u bicha, aapat bo'o joo japtek. Intok jume' ka bwere jo'arampo jo'aakame juni'i, intok kia bwere jo'arampo jo'aakame juni'i intok, yeu a' yebijne'ewi tenneka, aapat aman aawas aneka a' bo'o bichan. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus intok aman yebijsuseka, juebena yoemrata ama aawas anemta teak. Intok am jijiokolok. Bwe'ituk, kia bwala chiktulamtaka, kaabeta am suua'a benasi machiakan. Junama'a intok, juebena weemta am majtataitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Intok jaibu tu'isi kupti taiteo, a' majta'um aman au yajaka inen au jiiak: ―Tu'isi te mekka, pa'ariapo aane, intok jaibu tu'isi kupte ―tim au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tu'i ean ―tiian―, inika'a yoemrata, empo, bem bwa'anee'uta bem aman jinune' betchi'bo, inim ka itou mekka, jume' ili jo'aram joka'awi am bittuaka'ateko ―tiian―. Bwe'ituk kaitam bwa'amachi ―tim au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aapo ju'u Jesus intok am yoopnaka: ―Eme'e am ji'ibwatua'em ―ti ameu jiiak. Bempo intok inien a' temaek: ―Jaisa jumak, te aman sajaka, tiian, paanim woi sientom lenaariom jinuriaka, am a'a'aboj betchi'bo ja'ani, tiian. Jaksa te jita nu'uka am ji'ibwatuane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesus intok: ―Jaiki paanimsa eme'e nunu'ubwa ―ti am temaek―. Aman sajaka a' bicha'em ―ti ameu jiiak. Aman am ju'uneyyaka intok: ―Mamni paanim, intok wooi kuchum ―tim au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Junama'a intok, baj sialiku, bu'uuraata, nat wikiaka am jootesaen. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Junuen auka intok, junama'a intok, mamamni takaasia, aet nat wikiakai, taa nattepola, joote japtek. Intok ket, woi taka ama woj mamnisia, aet nat wikiakai nattepola, waate ama joote japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesus intok, jume' mamni paanim nu'uka, intok jume' wooi kuchum, teekau jikau bitchuka, Liojta bai saek. Chukula intok, jume' paanim rebektataiteka, a' majta'ummeu am bwisek. Juname'e intok, junae yoemrata, si'imemmet amet am na'ikimtene' betchi'bo. Intok jume' wooi kuchum ket junalensu amet na'ikimtewak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Intok juname'e si'ime, jiapsi yuma'isi ji'ibwak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jume' paanim intok jume' kuchum ama yeu be'ekame intok, woj mamnim ama wooim warimtaka toboktituk. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jume' intok, inien a'aboj wakame, mamni miil yoememtukan. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesus intok, jume' a' majta'um, kuta kanoau am ja'amusaeka, am bamijtuataitek, aapat, Betsaira' tea'u bicha am katchaekai. Juka' bu'uuraata ama au anemta saka'atuasu'po tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Si'imem na'ikim saka'atuasuka intok, ju'u Jesus, senu kauta kateka'u bicha siika, junaman Liojtau bicha nok betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Intok jaibu jeo jomteo, ket aapo'iksu waki bwiapo aapolaik aneosu, ju'u kuta kanoa, baweta nasuk jeela weaman. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ju'u Jesus intok am bichak, kuta kanoapo aneka, jibweeta lottilamtakai. Bwe'ituk ju'u jeeka am nankika weyen. Intok maukaapo, abe matchuu, bawe bepa weyeka, ameu yepsak ju'u Jesus, intok amepat au weetuan waja'aleka weyen. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bempo intok bawe bepa weemta a' bichakai, tukaapo, jita yee wom womtame ama weama, ti ean. Intok emo a' majjaituaka emo chaituan. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bwe'ituk si'ime a' bichaka, emo womtak. Taa aapo ju'u Jesus intok, sep ameu nookak: ―Kate'em jachin emo eetua'em ―ti ameu jiiak―, intok katem emo majjaitua. Bwe'ituk inepone juna'a ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Intok kuta kanoau ameu ja'amuka, juka' jekata sep cha'atutuak. Bempo intok, majjaurimmea, batte jachin aayuk. Intok tu'isi aet im suum'eaka taawak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bwe'ituk jume' mamni paanimmea intok jume' wooi kuchummea, bu'uum ammea a'abojwamtat betana, junaet ka a ju'unean, Jesujta a jita a' joa'apo. Bwe'ituk bempo ketuni ka'a mammaten. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Intok juna'abo, waetana betana bem ane'epo, Jenesaret tea'u bwiarau yeu yajaka, junama'a kuta kanoapo bawe mayoau yeu yajaka, bem aet rejte'u, jitau a' sumaka, yeu sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Junama'a jo'aakame intok, sepim aet ju'uneak. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Junama'a jo'aakame intok, naj tenneka, jume' bem ko'okoiriawame, si'imekut betana, bem jipetekipo, kia jak juni'i, aapo'ik ane'etea'po jikkajaka, junaman au yeu tojiwan jume' ko'okoeme. ");
INSERT INTO yaqNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Intok ka kia bwere jo'arampo yeu a' yepsa'apo juni'i, intok kia bwere jo'arampo a' yepsa'apo juni'i, intok si'imekut, wasammetchi a' weama'po, junama'a aet naj rejtiwa'po, jume' ko'okoeme yeu tojiwan. Intok Jesujtau ujbwanwan, kiala'a supewammet juni'i, aet mamte betchi'bo. Jume' intok, a' supewammet aet mamtekame, sepim emo inne'eten. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Junama'a intok, bwe'u jo'ara Jerusalen tea'a betana, jume' waate juriom, bem junuen a' suale' betchi'bo, paiseompo emo teuwaame, intok jume' juriommeu maejtom, juname'e Jesujtau nau yajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Juname'e intok, Jesujta majta'um, ka bajimalataka ji'ibwame bichaka, jiapsita juni'i, jaiti jooan, tiian, intok ka tu'isi am tawa'atiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bwe'ituk jume' waate juriom, paiseompo emo teuwaame, intok si'ime jume' juriom teame, bem yo'owasuka'um junuen aet am majtalataka, junuen bem aet joiwala'po aman a' bo'o joorian. Bwe'ituk ka bajimalamtaka, kaachin ji'ibwane. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Intok kia jakun weamaka juni'i, a' jo'awapo yeu yepsaka, ka bajimala'atek, ka ji'ibwane. Intok che'a ta'abwi weemta juebenak im jooan. Pu'atom bem ama jiji'ibwa'uta, intok bem ama ba'a jeje'ee'uta, intok bem aet ji'iboboa'uta, intok bem aet ji'ibwowamta, sisi'iwok soto'otuko juni'i, intok babu soto'otuko juni'i, intok bem aet toto'uta, junaka'a si'ime weemta, ba'ammea a' si'i si'itaka a' te'ochian. Junuen a' sualeka, junuen a' bo'o joorian. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jume' waate juriom, paiseompo emo teuwaame, intok jume' juriommeu maejtom, Jesujtam temaek: ―Jaisa betchi'bo ―tiian―, jume' em majta'um, bat naataka yo'oraata, ju'ubem aet yee majtaka, intok junuen aet joiwalataka, junuen a' bo'o jooriawa'po, inime'e em majta'um ka inien a' bo'o jooria ―tim a' temaek―. Bwe'ituk bem sawaa'uta, ito benasi ka'a ba'a si'i si'ita. Intok kiam ka babajimaka juni'i, jiji'ibwa saka. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus intok inen am yoopnak: ―Pa'akun tana, eme'e, bitpo tu'i yoememtu machika juni'i, taa enchim jiapsipo wajiwa, ka tu'i yoememtaka junuen em maachi. Inien a' wee'po san ju'u Isa'iajtuka'u emot nokaka, inien a' ji'ojtek: Ini'i yoemra, ti ji'ojtek, kia tenie nee emo yo'oritua, tiia. Taa bem jiapsim, tu'isi mekka neu aane, tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Intok kia tenie, junuen bem emo nee yo'oritua'u, kaita'po taawa. Bwe'ituk o'owim betana weyemta intok yee majtawamta, junaka'a emo bo'o jooria saka, tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","’Bwe'ituk tua junaka'a Lioj nesaurita su'u tojilamtaka ―tiia, ju'u Jesus―, o'owim betana weyemta junuenim emo a' majtalamtaka junuen aet joiwalataka a' bo'o jooria. Bem ama aet jiji'ibwaa'uta, intok bem ama aet ba'a jejje'ee'uta, intok si'imeta bem sawaa'uta, ba'a si'i si'itakai a' te'ochia, intok kia ta'abwi weemta bo'o jooria ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Intok ket inen ameu jiiak: ―Juka' enchim aet joiwalaa'uta, intok yoemrata enchim aet sawee'uta, junaka'a che'a tu'ureka a' bo'o jooriabaeka, tua junaka'a Lios nesauta, kia kaita'po em a' tawaala. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bwe'ituk Moiseejtuka'u, Liojta betana inien a' mabetaka, ji'ojteita to'o siika. Juna'a ji'ojtei intok inen jiia: “Em achaita intok juka' em malata, am yo'oreka'am bicha'e”, ti jiiak. Wa'a intok, “A' malawata intok a' achaiwata, ju'ena noktae am nok beje'ekame, juna'a, ya'uraapo yeu tojiwaka, muk maisia bettesi aet autuanaa.” ");
INSERT INTO yaqNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Taa eme'e intok, kia jabe juni'i a' achaibewi intok a' malabewi inen jia'ateko, tiia: “In enchim mik'ea'uta, Liojpo betana weyemtat na'a sawana' betchi'bo, junaka'a Liojta betchi'bo na'a e'eriala.” Intok inien ameu jiaka'ateko, junak jaibu, ka au utte'atune, a' yo'owawam a' aniane' betchi'bo, ti jiia eme'e. (Juname'e juriom intok, inika'a tomita teuwaabae'etek, Korbanpo tiaka, ebreo nokpo a' teuwa.) ");
INSERT INTO yaqNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Inien intok eme'e aneka, enchim yo'owam ka aniabaeka'eene. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bwe'ituk, Liojta nesaurita ka enchim chupa'abae' betchi'bo, ju'u enchim aet joiwalaa'utae, intok enchim junuen a' tekipanoa'utae, inie weemtae, Liojta nesaurita kaita'po tawaala'em. Intok ket juebenak wate weemta inile benasi machik eme'e bo'o jooria. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Intok si'imemmeu ama anemmeu chaaeka: ―Netche'em jikkaja ―tiia―. Intok aet mammate ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kia jabe yoemtaka juni'i, a' takaabeu tu'inee'uk, bwa'ako, intok a' jitataka juni'i, junae, ka tu'isi a' jiapsi tawaanee'u, ka au aune. Taa ju'u a' jiapsiwa betana yeu weeme, juna'a ala, a' jiapsiwata ka tu'isi a' tawaane. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ju'u a' mammatebaeme a' mammatene. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Junama'a intok, juka' si'ime yoemrata ama yeu sikaa, senu jo'arau kibakek, ju'u Jesus. Junama'a intok a' majta'um, ta'abwi weemtau a' tammachiaka'uta, intok yoememmeu a' teuwaaka'uta, junaka'a weemta, ju'ua' teuwaa'ut, au im nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aapo intok inen ameu jiiak: ―Jaisa eme'e ket kaita em a mammate ja'ani ―ti am temaek―. Jaisa eme'e ka aet ju'unea, kia jabe yoemta juni'i, si'imeta a' bwa'ee'u, juna'a weeme a' jiapsiwata kaachin a nasontene ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bwe'ituk juna'a weeme, a' jiapsipo ka ko'om weama, bwe'ituk si'ime a' bwa'ee'u, to'onau luula ko'om weene, chukula intok a' pocho'okuntenaa. Inien jiaka san, si'ime bwa'aamta a' tu'i, tiia, intok kaabeta a jiapsi nasonte'etiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Taa intok ket inen jiia: ―Si'ime wa'a ka tu'i eeria, intok ka tu'i nooki, yoemta jiapsipo yeu a' weye'etiia. Inia betchi'bo san, au a' jiapsi nasonte'etiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bwe'ituk yoem jiapsipo ju'u ka tu'u'eewame yeu weama. Jubeka juni'i, ta'abwi jamuttamak au tu'uribaeka a' jiapsipo eene. Intok kia kee jubeka juni'i, kia jabe jamuttamak au tu'uribaeka a' jiapsipo eene. Intok juka' a yee bai ta'aawamta weetua. Intok yee su'awamta. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ju'u jita etbwawame, intok jain juni'i, jita waatiawame, intok emo i'awame. Intok yee bai ta'aawame. Intok ka tiuwame. Intok a yee sibowame. Intok watemmet ju'enasi nokwame. Intok unnaa jikat emo eeyawame. Intok ka suasi emo uju'uwame. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ini'i si'ime ka tu'uwa weeme, yoemta jiapsipo yeu weye, intok a' jiapsiwa junae ka tu'isi taawa. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Junama'a yeu sika intok, bwe'u jo'ara Tiiro' tea'u bicha intok Siroon tea'u bicha aman yepsaka, senu jo'arapo kibakek. Intok kaabeta a' ju'uneyya i'an. Taa junuentaka juni'isu, ka a eusek. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bwe'ituk senu jamut, a' jamut'asoawata, bebeje'eri ka tu'i jiapsi eerita a' jiapsipo aet anemtae, ko'okoirian. Juna'a jamut intok, aapo'ik Jesujta ama ane'epo a' jikkajaka, au sikaa, bwiau tajtia ko'om pujbaka, au tonommea kiktek. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Juna'a intok, rieka jamuttukan. Intok senu bwiarapo, Siro peniisa' tea'po jometukan. Juna'a jamut intok, tu'isi Jesujtau ujbwana, juka' bebeje'eri ka tu'i jiapsi e'erita a' jamut'asoawatat, a' jiapsipo wajiwa aet anemta, pa'akun yeu a' bepria i'akai. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Taa ju'u Jesus, essoi nokpo inen au jiiak, jamuttawi: ―Ili chu'ummeu, ju'u bwa'aame kaachin bat a ameu mana'atune. Bwe'ituk jume' a' yoemiarimmeu bat weye, bem bat ji'ibwatuanaa'u ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Taa ju'u jamut intok, junae essoi noktae, ju'ua' tawaa'ut, aet ju'uneaka, ket junalensu, essoi nokpo: ―Jeewi japchi ―ti a' yoopnakai―. Jume' ili chu'um juni'i ket usiwaim, bem aet ji'ibwa betuk jokaari, juka' betukun ko'om yojtemta a bwa'ane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Junak intok ju'u Jesus, inen a' yoopnak: ―Inien em lutu'uriata nokaka' betchi'bo, em a' waata'po aman eu aune. Ka jain'eaka weene. Bwe'ituk ju'u bebeje'eri ka tu'i jiapsi eeri, em jamut'asoabet a' jiapsipo wajiwa aet ane'u, yeu simlaa ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Juna'a jamut intok, a' jo'awau bicha siika. Ju'u a' jamut'asoawa intok, ju'u bebeje'eri ka tu'i jiapsi e'eriata a' jiapsipo wajiwa aet ane'uta, junama'a jaibu aet yeu simlatau, junama'a jipetekpo bo'okamtau yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Junak intok ju'u Jesus, bwiara Tiro' tea'po yeu sika intok, senu bwiarau, Siron tea'po aman, naa buusti sikaa, senu bwiarau yepsak. Junama'a intok, woj mamni bwere jo'aramtukan. Juna'a intok, Lekaapolij tea junama'a bwiara. Chukula intok Kalilea baweu yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Junama'a intok senu yoeme, naka pittaka intok nee'o, au tojiwak. Intok au ujbwanwan, aet a' mamtene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Intok aapolaik kaabeta ane'epo, omot bicha a' nuk sikaa, junama'a a' nakawapo a' mam pusiawam aet ja'abwak. Intok mam pusiapo au chittuaka, junae yoemta ninpo aet mamtek. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesus intok teekau jikau bitchuka, bwe'um jiabijteka: ―Eppata ―ti te'eka. Ini'i noki, jiak nokpo kuaktituk intok, inen jiubae: “Tu'urea'e”, ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sep intok a' niniwa tu'ureak. Intok tu'isi a nookan ju'u nee'o. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Intok kaabetau a' etejone'po aman, kutti au nookak. Taa junuen au a' noka' nasuk su, che'a juni san, si'imekut naas a' etejotaitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Junama'a intok, si'ime, tu'isi a' suum eiyaan: ―Si'imeta a' joa'u, tiaka, tu'isi a' jojoa. Bwe'ituk jume' ka jikkajame, a jikkajitua. Intok jume' ka a nokame juni'i, nonoktua. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Juname'e taewaimmet intok, ju'u yoemra tu'isi bu'uuka ama aanen. Intok im kaita bwa'amachiakan. Junak intok ju'u Jesus, a' majta'ummeu chaaeka: ");
INSERT INTO yaqNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Inika'a yoemrata ne tu'isi na'a jiokoleka na'a bicha ―ti ameu jiiak―. Bwe'ituk jaibu baji taewaim inim nemak aneka, intok kaita bwa'amachi ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Intok ne ka'am ji'ibwatuaka'ateko, intok bem jo'arammeu bicha am saka'atuaka'ateko, bo'ot tebae, ka pappeaka, wattinemme. Bwe'ituk bempo'im betana, waate che'a mekka betana inim aane. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jume' a' majta'um intok inen a' yoopnak: ―Jaksa te tua, inim kaita auka'po, ama butti bwa'amta nu'uka, inika'a yoemrata a a'abojne ―tim a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus intok: ―Jaiki paanimsa eme'e nu'uka rejte ―ti ameu nattemaek. ―Woo busanim ―tim te'ekamme. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Junak intok, juka' yoemrata, nat wikiaka am jootesaeka amet nesawek. Intok jume' woo busanim paanim nu'uka, Liojtau bicha nok suka, am rebektataitek. Junak intok, a' majta'ummeu am manak. Jume' a' majta'um intok, yoemrata bichapo am manak. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Intok ket ka jaiki kuchum nu'uka rejten. Intok ket juname'e nu'uka, Liojtau bicha noksuka, junae yoemrata bichapo mana'awak. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Intok si'ime, jiapsi yuma'isi, jobo'oji'ibwakamme. Intok yeu be'aka'uta, woo busan waarimtaka, tapunika toboktituk. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Intok junuen aman a'abojwame, toktim naiki miiltukan. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Intok am saka'atuasuka, a' majta'ummak nau, sep, kuta kanoau ja'amuka, senu bwiarau, Lalmanuuta' tea'u bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Junama'a a' yepsao intok, jume' waate juriom, paiseom teame, aman au yajaka, aamak emo nok bwijlatukan, a' ji'obila betchi'bo, Liojta betana, teekapo, senu machilaata ko'om weenemta a' ju'unaktesaen. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesus intok, tu'isi bwe'um jiabijteka, inen jiiak: ―Jaisa betchi'bo tua, ini'i yoemra machilaata a'awa. Lutula wee'po, tiia, eme'e ka'a bittuanaa, juka' machilaata. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Junama'a am to'o sika intok, kuta kanoau ja'amuka, sekka'ana, omot bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Intok bem bwa'anee'uta, bem weeyanee'u, aawaj koptekamme. Junama'a kuta kanoapo bem kate'epo, wepul paanim jiba nu'uka kaaten. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Junak intok ju'u Jesus, essoi nokpo paiseom teame betana, intok Eroorej teamta betana, juka' ka tu'ik bem yee majta'uta betana, emo ama suuasaeka ameu nookan. Intok reberuapo a' teuwaaka ameu nookan. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Junak intok, jume' a' majta'um, naas emo temae japtek, inienim jiakai: ―Paanim ka itom weeya' betchi'bo jumak reberuata itou teuwa ―tim jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Junak intok ju'u Jesus amet ju'uneaka, inen ameu jiiak: ―Jaisaaka eme'e, paanim ka weeya' betchi'bo eme'e nok saka. Jaisa eme'e kaitat mammateka, intok kaitat ju'unea ja'ani. Oo enchim jiapsim namakasi aula ja'ani ―ti am temaek―. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bwe'ituk eme'e, in ya'ala'uta enchim pusimmea bichaka'uta, intok in nokaka'uta enchim nakammea jikkajaka'uta, ili juni'i em ka'a jajjamlata benasi em aula. Katem a au waate juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jaisa eme'e ka au waate ja'ani, mamni miilim yoemem a'aboj betchi'bo, jume' mamni paanim in amet na'ikimteka'po. Intok jaikika waarimsa intok ama yeu be'ekame, jaiki waarimsa eme'e aman tapuniak ―ti am temaek. Bempo intok: ―Woj mamni ama wooi waarim ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Intok jume' woo busan paanim, jume' naiki miilim yoemem in ammea a'abojseka'posu, jaiki waarimsa ama toboktituk, ama yeu be'ekame betana. Bempo intok: ―Woo busan waarim ama toboktituk ―tim au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Junak intok ju'u Jesus inen ameu jiiak: ―Jaisa betchi'bo eme'e ka a aet ju'unea, ju'ubwa in emou nokaka'uta betana ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Junak intok, Betsaira' tea'u bicha sikaa, aman yepsak. Junama'a intok, senu yoeme, liptitaka ama au tojiwak. Intok aet a' mamtene' betchi'bo au ujbwanwan. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Junak intok, junaka'a yoemta liptita, mampo bwiseka, junama'a ili ka bwe'u jo'ara a' ane'epo, pa'akun bicha yeu a' nuk siika. Intok a' pujpo a' chitta amet yaak. Junak intok ae bepa mamteka, jaisa ka'a bicha ja'ani, ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Juna'a yoeme intok, ili bit jeelaika, inen jiiak: ―Yoemem ne naj kateme ne bicha ―tiia―, taa kia juyam benasi mamachime. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Intok juchi intok a' pusiwammet aet mamteka, junak intok si'imeta tajpa'alasia machisi bittaitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Junak intok ju'u Jesus, junaman ka bwe'u jo'arau bicha, ka intok a' weesaen, juka' tu'uwata au a' yaaka'uta ka junaman a' etejo'ii'akai. Kiali'ikun a' jo'awau bicha a' simsaeka a' tejwak. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Junama'a intok ju'u Jesus, a' majta'ummak, jum bwe'u jo'ara Sesarea piliipo' tea'po, waate ka bwere jo'aram au jeela joka'um, junama'a wa'am yeu siika. Bo'ot intok a' majta'ummeu nattemae taitek: ―Jume' yoemem, nee jabesa ti jiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A' majta'um intok inen au jiiak: ―Enchi Joan yee babatoowame'etiia. Waate intok enchi Eliaj tiia. Wate intok, jume' bat naataka, Liojta betana yeteu noktuawame betana enchi weye'etiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Junak intok aapo inen ameu nattemaek: ―Eme'e intok, nee jabesa'atiia. Peeo intok: ―Empo ju'u Krijto ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Junak intok ju'u Jesus, aapo'ik, kaabetau a' etejosaeka am tejwak. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Intok inen a' utte'a, tiia, juka' emo benasi yoemta, jiokot au a' bitne'po, intok junama'a yo'o ya'arim betana kaita'po a' bitna'po betana. Intok ama bem maejtom, intok ama te'opopo nesaweme, jume' che'a ama yo'o ya'arime betana, intok me'etune. Taa baji taewaita weyeo, jiabijtene, tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Inika'a weemta intok, machisi ameu a' teuwaan. Junak intok ju'u Peeo, aapolaik omot bicha yeu a' nuk sikaa, junuen a' jiaka' betchi'bo, ili a' nok buitaitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Junak intok ju'u Jesus, amau bicha, jume' waate a' majta'um naj bitchuka, omti nokpo, Peotau inen jiiak: ―Mekka jakun bicha weami'ise'e. Bwe'ituk, kia che'a tu'isi, Satanajtumta benasi neu jiia. Bwe'ituk Liojta betana weyemtate'e ka ju'unea. Taa inim bwiapo, yoemratat betana weyemtat jiba'e ju'unea ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Intok yoemratau chaitebok, intok a' majta'ummeu intok: ―Kia jabetaka juni'i ―ti ameu jiiak―, in lutu'uriata nemak atteabaeme, juna'a intok inim aniapo weyemtae ae emo alleetuawamta, ka intok junae au taka alleetuabaeka'eene. Bwe'ituk junuen au utte'atune. Taa in ea'po aman jiba an sisimne. Intok inien aneme, che'a tu'isi, kia kuujta pu'atemcha weene. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bwe'ituk si'ime wa'a i'an lautipo inim aniapo, si'ime weemtatchi, junae tana jiba au eetuaka jiapsa'ateko, junuen auka'ateko, juka' Liojtau bicha yuu jiapsinamta ka teune. Taa si'ime wa'a nee betchi'bo intok inie in tu'i nokta betchi'bo, jachin ya'awaka'ateko juni'i, intok kia me'ewaka'ateko juni'i, juna'a ala, junae, jiapsi jinne'uritune. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bwe'ituk jita tu'uwatasa ama jajamne, ju'u yoeme, si'ime juka' aniapo ujyoriata a' atteako, chukula intok, mukuko, ju'u a' jiapsiwa Liojtau a' weenee'u, ka au lutu'uriatuka'ateko. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bwe'ituk ju'u junuen mukukame, juchi inim jiapsibae'eteko, kia jaiki tomita beje'etuaka'ateko juni'i, kaachin juchi jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bwe'ituk kia jabe juni'i, nee tana, intok in tu'i nokta betana au tiutuakame, inim bwiapo inim jiapsame nasuku, jume' ka tu'uwata weetuaka, ka Liojta jiba emo yo'orituame, juname'ebichapo emo tiutuakame, nejpone ket emo benasi yoemtaka, ket juname'e betana ne ino tiutuane, jume' in yeu pu'arimmak, intok Lios achaita ujyoria at teamak ne a'abo ko'om yepsako. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Intok juchi intok, inen ameu jiia: ―Lutula wee'po ―tiia―, inim waate aane, juka' Lioj nesawamta utte'awakamta, a'abo ko'om yebijnemta bitneeme, kee kokkokai, inim ket jiapsaka a' bitne ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Busan taewaita simsuk intok, ju'u Jesus, juka' Peota intok juka' Jakoobo' teamta intok juka' Joanta, bempolaim yeu nuk sikaa, omot bicha, bwe'u kawiu, jikau im ja'amuk. Junama'a intok, aapo ju'u Jesus, bempo'im bichapo, ta'abwisi bittuk. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A' tajo'owa intok, kaupo tosai sapam benasi, unnaa beojkosia tosaisia machiakan. Intok inim bwiapo kia jabe juni'i, tajo'orim baksia'atek, kaibu junuen tossaalaisi am basuane. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Junama'a intok, ju'u bat naataka, Liojta betana, yeteu noktuawame, Eliaj teame, intok ju'u Moiseej teame, ket ama yeu machiak. Intok Jesujtamak nau etejok. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Junak intok ju'u Peeo, Jesujtau: ―Tu'isi ne allea achai ―tiia―, itom inim ane' betchi'bo ―tiia―. Tu'i ean, itepo inim baji ili juya karim yaaka'ateko, senuk ee betchi'bo, senuk intok Eliaj teamta betchi'bo. Intok Moiseejta betchi'bo, ket seenuk. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Bwe'ituk ju'u Peeo, womtilataka, kaita nok machika junuen au jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naamu intok amet ko'om yejteka am roptak. Junama'a namupo intok senu jiawai jikkajituk: ―Ini'i juna'a, ju'u in yoemia ―tiame―, tu'isi in nake'u, enchim nok jikkajinee'u. ―Junuen jikkajituk ju'u jiawai. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Junama'a intok, seej chukti, kaita'po taawak ju'u naamu. Junak intok bempo, naj bitchuka juni'i, kaabeta intokim naa buusti bichak, taa Jesujta jiba, aapolaik ama weekamta. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Junae kauta betana intok ko'om sajaka, ju'u Jesus, bem bichaka'uta, kaabeta am etejoriasaeka am tejwak. Taa juka' emo benasi yoemta, kokolam nasuk a' jiabijtesuko, junak ju'ubwa, bem bichaka'uta am etejosaen. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Intok junuen bem tejwawaka'po aman, junaka'a bem bichaka'uta, bem jiapsipo jiba a' jipueka, bempola jiba a' ju'uneyyan, intok, juka' ame benasi yoemta, kokolam nasuk a' jiabijtenee'utat ameu nokwakamtat, junaet ka ju'uneaka, jiba aet emo temaen. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Junak intok bempo, juka' Jesujta temaek: ―Jume' itom maejtom intok, tiian, jaisa tua jiubaeka inen jiia, a' utte'a tiia, juka' Eliaj teamta bat yebijne'po ―ti a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aapo intok ju'u Jesus: ―Lutula wee'po ―tiia―, ju'u Eliaj teame bat yebijne. Juna'a intok, inim ama be'emta, aapo a' tu'uteka a' tu'u ya'ane. Taa jum Liojta ji'osiampo, juka' emo benasi yoemtat betana ket senu weeme ama ji'ojtei, juna'a intok, junau, tu'isi jiokot machine, intok kaita'po a' bittune ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Taa ju'u Eliaj teame intok, jaibu yebijsula, junau intok, si'imetam au yaak, ji'ojteita aapo'ik betana junuen a' teuwa'po amani. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Intok watem a' majta'ummeu yepsaka, bempo'im nape konila, yoemrata bu'uuk ama anemmeu yepsak. Intok waate bem maejtom, jume' Krijtota majtimmak emo nok bwijlame. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Junak intok, si'ime ju'u yoemra ama aneme, Jesujta am teaka a' suum eiyaak. Junak intok a' tebotua betchi'bo au bicha tennekamme. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Junak intok ju'u Jesus bempo'im temaek, a' majta'ummak, jitat amemak am nok nassua'po. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Senu intok, inen ama a' yoopnak: ―Yee majtame ―ti au jiakai―, in yoemia ne eu nu'upak. Bwe'ituk ini'i, juka' bebeje'eri, ka tu'i jiapsita eerita a' jiapsipo aane. Junae betchi'bo intok ka a nooka. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Juna'a intok, kia jak juni'i, bwiapo naas au a' ro'a ro'aktatua. Intok tenpo sosomo'ochiakai. Intok tu'isi au tam kukume. Intok che'ewasu taka waake. Nejpo intok em majtimmeu a' tojakan, pa'akun yeu a' bepriasaekai. Taa kati'im a pa'akun a yeu a' bepriak. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Junak san ju'u Jesus inen am yoopnak: ―Ini'i yoemra, tua kaita a suale ―ti ameu jiakai―. Jaisa inim jiba nee emomak an machian, intok jiba inim jiokot nee ino bit i'a ja'ani ―ti ameu nattemaek. Junaka'a intok, junuen ko'okoemta au a' toji nesaen. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Juna'a usi'o'ou intok sep aman au tojiwak. Ju'u bebeje'eri ka tu'i jiapsi eeri, usi'o'outat aneme, Jesujta ta'aakai, sep juka' usi'o'outa bwiapo au jibeptuak. Intok naas au a' ro'aktituan. Tu'isi tenpo somo'ochiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus intok a' achaibeu nattemaek: ―Jakwoo naatekasa a' junule bena'atiakai. Juna'a intok: ―Kia ili a' usituka'po naateka ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Jue benasia intok ju'u bebeje'eri ka tu'i jiapsi eeri, a' jiapsipo aneme, tajipo au a' jimmaatua. Intok kia ba'apo juni'i, bat batte ama a' meme'a. Taa empo a' jinne'u'uteko, itom jiokoleka, itom ania'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Junak intok ju'u Jesus: ―Em inen neu jia'apo, “Empo a' jinne'u'uteko”, ti em neu jia'apo. Che'a juni san, empo em jiapsipo, Liojta suale'eteko, a jinne'utu. Bwe'ituk si'ime wa'a a' jiapsipo a' sualeme, kaita aawas aayuk ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Junak intok, usi'o'outa achaiwa, kia bwan nok jeelaika: ―Ana'a suale ―tiia―, taa netche'e ania'e, che'a yuma'isi in jiapsipo che'a in a enchi sualne' betchi'bo ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus intok, juka' bu'uuraata, bu'uuk au bicha katemta bichakai, juka' bebeje'eri ka tu'i jiapsi eerita, usi'o'outa jiapsipo wajiwa katekamtau, omti nokpo, inen au jiiak: ―Empo, bebeje'eri ka tu'i jiapsi ―tiia―, inika'a usi'o'outa ka a noktuamta, intok ka a' jikkajituamta, pa'akun aet yeu weye'e. Intok ka intok a' jiapsipo aet kibakne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Junak intok ju'u bebeje'eri ka tu'i jiapsi eeri, junae jiapsipo betana pa'akun yeu weyeka, juka' usi'o'outa tu'isi chaituan. Intok naas au a' wiiktuan. Intok mukiata benasi taawak. Juebenak intok, junuen ama a' bichaka, “Muukuk”, tim jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Taa ju'u Jesus, mampo a' bwiseka, a' yechaka, intok sep kiktek. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Junama'a intok ju'u Jesus, senu jo'arapo kibakeka, junama'a intok aapolaik, jume' a' majtim inen a' temaek: ―Jaisaakai tua, itepo ka a pa'akun yeu a' beebak, juka' ka tu'i jiapsita ―tim a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aapo intok inen am yoopnak: ―Ini'i weeme ―tiia―, ka kia jachin juni'i pa'akun a yeu a' beepne. Bwe'ituk pa'akun yeu a' bepriabae'eteko, intok che'a a' yo'ori betchi'bo, ka ji'ibwaka, ka je'eka, intok Liojtau bicha a' nokriakai ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Junama'a yeu sajaka intok, bwiara Kalilea' tea'po ama wa'am sajak. Jesus intok, kaabem am ju'uneyya'ii'an. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bwe'ituk juka' ame benasi yoemta, a' me'eneeme mampo su'u tojinaa'u, intok junuen ya'asuako, baji taewaita weyeo, jiabijtene. Inika'a weemta am majtaka, kaabeta intok naa buusti a' ju'uneyya'ii'an. Taa a' majtim jiba a' ju'uneyya'ii'an. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Taa juname'e intok, inie nokit, ka ju'unean. Intok a' temaineeka juni'i, emo a' tiutuan. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Junak intok, bwe'u jo'ara, Kapernao' tea'u yajak. Junama'a intok, jo'arapo aneka, Jesus inen ameu nattemaen: ―Jitasa eme'e bo'ot, jitasa nau etejosakan. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Taa bempo intok ka'a yoopnak. Bwe'ituk jum bo'ot, bempo'im nasuk, jabeta che'a ama yo'o ya'atune'po aman, naas emo aet temae sakan. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Junak intok ju'u Jesus, yejteka, jume' woj mamni ama wooi a' majtimmeu chaaek, intok: ―Emo tana ―tiia―, seenu, emou au yoo'eeyabae'eteko, juna'a, si'imemmet chukula weene. Intok si'imem nesauta jooriane ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Ili usita intok, bempo'im nasuk bichapo kechaka, chukula intok a' maammea a' ibaktakai: ―Kia jabe juni'i ―tiia―, in teampo, inien ili usim mabetakame, che'a tu'isi kia nee mabetne. Wa'a intok nee mabetakame, che'a tu'isi kia nee a'abo bittuakamta mabetlatune ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ju'u Joan intok: ―Yee majtame ―tiia―, senuk te bichak, bebeje'eri ka tu'i jiapsita e'erita, watem jiapsimpo anemta, em teampo ameu nokaka, pa'akun yeu am bepriame. Junaka'a intok, ka itomak a' weama' betchi'bo, katte junuen a' ansaeka ta'a tejwak. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Junak intok ju'u Jesus: ―Katem au suua ―ti ameu jiiak―. Ake'em a' su'u toja'em. Bwe'ituk kaabe aane, sep ka tu'isi net nokbaaneeme, neae aman intok in team teuwaaka, senuku au tu'uwatunemta, ka kia jabe juni'i a' joaka au a' yaakame ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bwe'ituk si'ime wa'a, ka itom beje'eka aneme, itomak eaka aane. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Intok kia jabe juni'i, nee teuwaaka enchim ba'am mikaka'ateko juni'i, Krijtota betana enchim atteari'po, juname'e, lutula wee'po, Liojta betana tu'uwata mabetne. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Intok inime'e, nee sualeme betana, kia jabe juni'i ka tu'ik am ya'ane' betchi'bo ameu noka'ateko, che'a tu'i ean, juna'a, tetata kutanaapo aet suma'awaka, baweu ko'om a' jimaatune'po. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Intok em maamea, ka tu'uwata ya'abae'eteko, intok junae betchi'bo, jiba yuu taji beete'po enchi antuaneemta, che'a tu'i ean, juname'e mamam chuktituko. Taa ka che'a wooim mamaka, jum tajita ka tutuke'po jiba yuu beete'po ka yej ean. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","Intok ket jiba junalensu, em wokimmea, jakun bicha sikaa, aman ka tu'uwata ya' betchi'bo, che'a tu'i ean, junaka'a wepul wokim chuktituko, taa ka che'a wooim wokeka, jum tajita ka tutuke'po jiba yuu beete'po ka yej ean. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","Intok ket jiba junalensu, em pusimmea em bichaka'u, ka tu'isi enchi eetua'ateko, che'a tu'i ean, juname'e wepul pusim yeu am wikeko, bwe'ituk che'a tu'i ean, Liojta nesawau si'imeta kateka'u, wepu'ulaim puseka ama kibakeka'ateko, taa ka che'a wooim puseka, jum tajita jiba yuu beete'po yejnee. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Junama'a intok, jakwoo juni'i tajita ka tutuke'po ama anne. Junama'a intok bem takaa, jiba yuu ama anne. Intok ket bwichiam jiba auka'po benasi machine. Inime'e junen ama anne. Jum bwichiam jakwoo juni'i ka kokko'po. Intok jum tajita jakwoo juni'i, ka tutuke'po. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Bwe'ituk si'ime jume' nee sualeme, jiokot emo bitne, kia taji rupaktiatae, senuk sassaawa'a benasia, wakasim peutame, si'imekut on si'itawa benasia. Taa junae, jiokot emo bitnamtae, jiapsi tu'utenamta jajamne. Intok Liojta enchim yo'orine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Bwe'ituk juka' bwa'amta kiawata mak betchi'bo, ju'u oona tu'i. Taa juka' onta, on kiawata ka jipue'eteko, jitaesa cho'okosi a' ya'anee juka' onta. Kiali'ikun san, juka' onata jum bwa'aa'po, a' tu'ireaka'a benasia, eme'e juni'i ket junalensu, tu'isi em nau jiapsaka, watem enchim emou a' suawa'une' betchi'bo enchim bichaka emo benasi bem jiapsine' betchi'bo. Intok yanti jiapsiwame emot naas aune. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Junama'a yeu sika intok, Jurea bwiaraapo ama naa buustia siika. Intok batwe Joran waetana yepsak. Junama'a intok, juebenaka juchi aman au nau yajak. Aapo intok, jiba am majta'a benasia am majtan. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jume' waate juriom intok, paiseom teame, ama au yajaka, kiala'a ji'obila' betchi'bo au nattemaek: ―Jaisa, senu a' jubiawata a jimmaanee ja'ani ―tim au nattemaen. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Taa aapo ju'u Jesus intok, inen am yoopnak: ―Ju'u Moiseejtuka'u, jaisa emot a' nesawek ―ti am temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bempo intok: ―Ju'u Moiseejtuka'u ala ―tiian―, jubiarita to'o sim betchi'bo, ya'uraapo, ji'osiata yeu jimmaanesaeka a' nookak. Juname'e ji'osiammea intok, senu, a' jubiawata a to'o simne ―tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus intok am yoopnaka: ―Enchim namakak jiapseka' betchi'bo ―tiia―, juna'a Moiseejtuka'u inika'a nesauta ji'ojtetebok ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Taa aniata naateka'po naateka, ju'u Lios ka junuen a' waatan. Bwe'ituk inien ji'ojtei, ju'u Lios, o'outa ju'unaktek, intok jamutta ju'unaktek. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Inia betchi'bo san ju'u o'ou, a' malawata intok a' achaiwata to'o sikaa, a' jubimak jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ka intok wooi yoemem benasia tawane. Inien san beja, woiriaka juni'i, nappat, wepul yoemta benasi eeyatune. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Inia betchi'bo san, wooi jiapsita nau tojirita, Liojta wepul jiapsita ya'arita, inim bwiapo, ju'u yoeme, kaachin junaka'a a na'ikimtene ―ti ameu jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chukula intok, senu jo'arapo, junae weemta betana, jume' a' majtim au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aapo intok am yoopnaka: ―Kia jabe juni'i ―tiia―, a' jubiawata jimmaakame, intok ta'abwik jamuttamak jiapsa'ateko, juna'a, tua a' juprita a' kunabeu lutu'uriawame, junaka'a, ta'abwi jamutta ama lutu'uria makako, juna'a, tua a' jamut juprita betchi'bo ka tu'isi tawane. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Intok ket junalensu, kia jamuttaka juni'i, a' kuna jimmaako, intok ta'abwi o'outamak yejteko, juna'a, tua a' kunabeu lutu'uriapo, junaka'a ta'abwi o'outa au kunatuakamta, tua a' kunawata betchi'bo ka tu'isi tawane. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Waate intok, junama'a, ili usim, Jesujtau tojan, amet am mamte'ii'akai. Taa a' majtiwam intok, aman yeu am tojammeu, ameu emo omtituan. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus intok junuen am bichaka, au o'omtituaka, a' majtimmeu inen jiiak: ―Inime'e ili uusim ela'po a'abo neu tojinaa, katem ammeu suua ―ti ameu jiiak―. Bwe'ituk, inime'e ili usim benasi emo eetuame, juka' Liojta utte'a nesawata kateka'po au lutu'uriane, ama jiapsine' betchi'bo ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Lutula wee'po ne inen jiia, kia jabetaka juni'i, Liojta utte'a nesawata, ili usita benasi ka au eetuaka'ateko, junaka'a, Lios utte'a nesawata kateka'po, ka a aman kibakne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Juname'e ili usim intok, we'epulaim am iba'ibaktaka, amet mamaka, ameu tu'uwatunemta, Liojtau bicha am nokrian. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Aapo intok, junama'a yeu sikaa, bo'ot a' weyeo, senu au tajtia buiteka, aapo'ik bichapo, tonommea kikteka au nattemaeka: ―Tu'u yoeme ―tiia―. Yee mamajtame ―ti Jesujtau jiiak―. Jaisa ne auka tua, juka' yuu jiapsiwamta net aune ―ti a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus intok: ―Jaisaakai empo nee tu'u jiapsek, tiia. Bwe'ituk inim kaabe aane, tu'u jiapsekame. Taa ju'u Lios jiba tu'u jiapsekame ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Empo jaibu Liojta nesaurim ta'aa: “Jubeka, ka ta'abwi jamuttamak emo tu'uribaane. Etbwawamta juni'i, ka bo'o jooriane. Intok yee su'ana'uta juni'i. Ka aa noki'ichiata nokne. Intok yetet, juka' ka lutu'uriata, kate'e amet a' nokne. Intok em achaita intok em malata, tu'isi am yo'orinee” ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Juna'a intok inen a' yoopnak: ―Yee maj majtame ―ti au jiakai―. Inika'a weemta, in usituka'po naateka, yuma'isi ne si'imeta ya'ari ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Junak intok ju'u Jesus, a' noka'utat betana aet mammateka, a' jiapsipo a' naktaitek, intok inen au jiakai: ―Senu weeme jiba eu be'e ―ti au jiiak―. I'ane'e sik, juka' si'imeta em jipue'uta nenkaka, intok pooberaatat a' na'ikimtene ―tiia―. Junak intok, aman teekapo ee betchi'bo, che'a eu tu'uwatunemta aune ―tiia―. Chukula intok, in bo'o jooria'uta, nemak a' joo simne. Intok nee betchi'bo em jiokot emo bitne'po, ka jain emo eetuaka, kiala'a inne'aka jiapsine ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Taa juna'a intok, Jesujta inien au a' teuwa' betchi'bo, ka au alleetuaka siika. Bwe'ituk tu'isi jita yu'in beje'ewakamta jipuen. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Junak intok ju'u Jesus a' majtim naj bitchuka, inen ameu jiiak: ―Tua tu'isi ameu obiachi, jume' yu'in totomekammewi, Liojta utte'a nesawata kateka'u bem yajine'po ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Junak intok, jume' a' majtim, inien bem ameu nokwaka'uta betana aet emo suum'eetuak. Taa ju'u Jesus intok, juchi ameu noktaiteka: ―In yoemiam ―ti ameu jiiak―. Tu'isi ameu obiachi, Liojta utte'a nesawata kateka'po, bem yajine'po, jume' yu'in tomeka, junaet eaka aet jiapsekammewi ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kameota ji'ikia pusimpo ama yeu a' weene'po bepa, ju'u yu'in tomekamtau che'a obiachi, Liojta utte'a nesauta kateka'u a' yebijne'po ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bempo intok, inia weemtat aet ee majjautuan. Bem jiapsimpo inen emo eetuakai: ―Junuentuka'ateko intok, jabesa tua a jinne'utune ―ti emo eetuan. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus intok bempo'im naj bitchuka, inen ameu jiiak: ―Yoemtau obiachisi machiaka'u, Liojta betchi'bo, tua ka obiachi. Bwe'ituk aapo'ik betchi'bo kaita obiachisi machika aayuk. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peeo intok inen au jiutaitek: ―Achai ―tiia―, itepo, itom atteata si'imeta to'o saka'alataka intok te em ea'po aneka, emak te rejte ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus intok a' yoopnaka: ―Lutula wee'po ―ti au jiiak―. Kia jabetaka juni'i, tu'isi nee au naktuakai, intok in nok lutu'uriata a' bo'o jooriaka, yee a' majtabaekai, intok junue betchi'bo a' jo'awata to'o sika'ateko, oo jume' aamak werim to'o sika'ateko, intok kia a' jubiawata intok a' yoemiawaim juni'i to'o sika'ateko, intok waj bwiawata to'o sika'ateko, ");
INSERT INTO yaqNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ju'u inien aukame, che'a juni san, si'imeta juka' a' su'u tojaka'uta bepa, i'an, inime'e taewaimmetchi, che'a bu'uuk atteane, jume' Liojpo betana aamak werimtuneeme, intok yoemiamtuneeme, intok yu'in jo'araata jipu'unee a' mabettune'po, intok waj bwiawam juni'i. Taa junuentaka juni'i, watem betana omtanaa. Intok juka' jiokot au a' bicha'u, jiba aet aune. Taa chukula, Liojtau bicha juka' yuu jiapsiwame aet aune. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Taa juebenaka jume' che'a emo eeyame, juname'e junen, aman che'a ko'om'eeyarimtune. Intok juebenaka jume' ka emo che'a eeyame, juname'e junen, aman che'a eeyarimtune. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Intok bo'ot, Jerusaleneu bicha jikau bo'okamtat kateka, Jesus bat weyen, a' majtim intok aet cha'aka kateka, aman Jerusaleneu bem yajine'ewi aman, emo majjaituaka juni'i, aet cha'aka kaaten. Bwe'ituk aman, bempo'im betchi'bo, ka tu'ik au machian. Junak intok ju'u Jesus, jume' woj mamni ama wooim a' majtimmeu, junama'a bo'ot omot bicha bempolaim yeu wikeka, junama'a bempolaimmeu, si'imeta waka'a au ya'anaa'uta ameu teuwaak: ");
INSERT INTO yaqNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―I'an te Jerusaleneu yajako ―tiia―, junama'a, ju'u emo benasi yoeme, te'opopo yo'o yaa'uchim mampo intok jume' maejtom mampo su'u tojitune. Intok a' me'ena' betchi'bo, ta'abwi yoemrata mampo su'u tojitune, junuen nau a' wepul lutu'uria yaakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Junama'a intok, juname'e a' beebaka, jaana a' jiawaane. Intok aet im chit wat wattine. Intok im a' me'ene. Taa juna'a, baji taewaita weyeo, jiabijtene ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Junak'intok, ju'u Jakoobo' teame, intok ju'u Joan teame, Sebereo' teamta u'usim, Jesujtau rukteka, inienim au jiia: ―Achai ―tim au jiiak―. Itom eu a'awa'uta, itom a' ya'ariane ―tim au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aapo intok: ―Jitasa eme'e waataka ―tiia―, enchim nee a' ya'aria'ii'a ―ti am temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bempo intok: ―Ito tana ―tiian―, senuk em batatana yej betchi'bo, senuk intok, em mikko'otana yej betchi'bo, itom junen autua'e ―ti au jiiak―, emak ama an betchi'bo, enchi yo'otaka yejteko. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus intok am yoopnaka: ―Tua em ka ju'unea ―ti ameu jiiak―, ju'u enchim a'awa'ut. Jaisa eme'e si'imeta juka' ko'okosi machik neu weyemta, intok waka'a in jiapsipo, ko'okosi in inne'enee'uta, jaisa eme'e nele benasi a' inne'ene ―ti am temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bempo intok: ―Jeewi ―tim a' yoopnak. Jesus intok inen ameu jiiak: ―Lutula wee'po ―tiia―, inien neu aunemtat betana, wate weeme emou aune ―tiia―. Intok a eme'e a' inne'e sakane. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Taa batatana senuk neu yejtenemta, intok mikko'otana senuk neu yejtenemta, junaka'a weemta, inepone ka a yeu am pu'a. Taa wame'e Lioj'achaita betana yeu pu'awame, juname'e junuen ama jote'etuanaa ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jume' waate, woj mamni a' majtim intok, inien jiame jikkajaka, Jakoobo' teamta intok Joan teamta emo ameu omtituan. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Taa ju'u Jesus, si'imemmeu chaaeka, inen ameu jiiak: ―Eme'e tu'isi ju'unea ―tiia―, inim bwiapo, jume' tekiataka ya'uttuko, yoemratau au yo'o joaka, nesawamta weetua. Taa juname'ebepa ket aane, ame bepa nesaweka, bempo'im juni'i saweme ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Taa emo nasuk ka inien weye. Bwe'ituk kia jabetaka juni'i, emo nasuk au yo'o joobae'eteko, juna'a, che'a, enchim si'imem nesauta jooriane ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Intok kia jabe juni'i, emotana, bat au yo'o joobaeme, juna'a, emou si'imemmeu, nesaureopo tawane ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bwe'ituk ju'u emo benasi yoeme, kaabeta, nesauta a' ya'ariane' betchi'bo a'abo yepsak. Taa che'a juni san, aapo, si'imem nesauta ya'ariabaekai a'abo ameu yepsak. Intok kia a' jiapsiwata juni'i, juebenam betchi'bo nenkine ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Junak intok, bwe'u jo'ara, Jeriko' tea'u bicha sajak. Junama'a intok, Jeriko' tea'po, a' majtimmak yeu siika. Intok juebena yoemem ket aamak sajak. Senu yoeme, liptitaka, Bartimeo' teame, Timoteo' teamta u'usi, juna'a bo'o mayoat kateka netanen. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Intok aman weyemta, a' Jesus nasareeno'otuka'po aman, a' jikkajaka, inen jiaka chaitaitek: ―Jesus ―tiia―, Labii' teamta u'usi, nee jiokole'e ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Intok juebenaka, ka jaiti a' jiusaeka, au omten. Taa juna'a che'a juni san kusisi chaaeka inen jiian: ―Labiituka'utat yeu simria, nee jiokole'e ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Junak intok, Jesus, kikteka, junae yoem liptitau chaitebok. Junau intok inen jiuwan: ―Aet yoem'ea'e, kikte'e. Bwe'ituk aapo eu chaae ―tim au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Junak intok juna'a, a' jijine'um, kia ama to'o kikteka, Jesujtau bicha sikaa, aman au yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus intok inen au noktaitek: ―Jitasa empo nee enchi ya'aria i'a ―ti a' temaek. Juna'a yoem lipti intok: ―Achai ―tiia―. Juchi in bitne' betchi'bo, in pusim tu'ute'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus intok inen au jiiak: ―Em jiapsipo em a' suale' betchi'bo, ka jain eaka weene. Juche'e bitne'e ―ti au jiakai. Junak intok sep bittaitek. Intok Jesujtat cha'aka katemmak, amemak siika. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Intok Jerusaleneu jeela kateka, intok jume' wooi ka bwere jo'arammeu nau jokammeu, Betpaake' teamtau intok Betaania' teamtau jeela yajak. Junama'a intok ket, Jerusaleneu jeela, senu kawi ama katekan. Oliibo'ouwo intok tu'isi ama bu'uureakan. Junak san beja, senu nesauta a' ya'ariana' betchi'bo, jume' a' majtim betana wooim yeu pu'aka, aman am bittuak, ");
INSERT INTO yaqNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","intok inen ameu jiakai: ―Itopat bat sajaka, jo'arau yajaka, junama'a senu buu'aso'olaata cha'akamta em bitne. Junaka'a intok, kia jabe yoeme juni'i, kee a' kaba'ite. A' buttaka, a'abo newe'em a' tojine ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Intok senuk, jaisaaka eme'e a' butta, ti enchim temaeka'ateko, “achai chubala betchi'bo a' waata, taa chukula juchi a'abo a' bittuarokaka nooka”, ti ameu jiune. “Junak intok sep a'abo a' bittuane” ―ti jiia ju'u Jesus. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Juname'e intok, junam bicha sajaka, juka' ili buu'aso'olaata ama jo'arau aman kimuriata naapo, pa'akun tana, bo'otchi cha'akamta a' teak. Junak intok a' butta japtek. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Junama'a intok wate ama aanen, senu intok inen ameu jiiak: ―Jaisaakai eme'e ili buu'aso'olaata butta ―ti am temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Junak intok juname'e, Jesujta, bem amet a' saweka'po, intok bem ameu a' nokaka'po aman, junaeu a' teuwaak. Junak intok sep, bem a' nuk saka'ane' betchi'bo su'u tojiwak. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Junaka'a buu'aso'olaata aman nu'uka intok, Jesujtau a' tojak. Junak intok bem bepa supem aet wattak. Junae buu'aso'olaatat intok, ju'u Jesus aet jikat yej simen. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Junama'a intok, aapat juebenaka ama aneme, jum bo'ot aet wa'am a' weene'po, bem jiniam tetekan. Waate intok nassa'akariam chuktaka, junama'a bo'ot aawas a' toto'an. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aapat kateme, intok kia ama'a kateme juni'i, alleerimmea chaaeka inenim jiian: ―Itome'e jinne'u'e ―tiian―. Tu'isi tawaari, achai Liojta betana lutu'uriaka inim weyeme ―tim jiu sakan―. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Rei Labiita bat naataka, inim si'imekut tu'isi a' nesausuka'a benasia, juchi junaen benasi inim a' aune' betchi'bo, Lios aapo, teekapo betana junae betchi'bo enchi aniaka, emaktune ―tim jiu sakan. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Junak intok Jesus, Jerusaleneu yepsaka, junama'a bwe'u te'opota kateka'u kibakek. Junama'a intok si'imeta ama aukamta naj bitchuka, siika. Betaania' tea'u bicha siika. Jume' woj mamni ama wooim a' majtimmake. Bwe'ituk jaibu unnaa kupten. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Juchi yokoriapo intok, junama'a Betaania' tea'po betana yeu sajaka, tebauritaitek ju'u Jesus. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mekka'ekut intok, senu chuna'ouwota, sia koja weekamta bichaka, aman au siika, takam a' jipue'eti'eakai. Au yepsaka intok, kia sawa ausu'litukan. Intok ka tatakan. Bwe'ituk kee taewaim yuuman a' takane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Junak intok, Jesus junae chuna'ouwotau: ―Kiale'e, jakwoo juni'i, kaibu'e takane'e ―ti au jiiak―. Intok kia jabe juni'i, ka enchi taka bwa'ane ―tiiak. Intok junuen au a' jia'apo, jume' a' majtim a' jikkajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Intok juchi'intok, Jerusaleneu yajaka, ju'u Jesus juchi aman bwe'u te'opou kibakeka, jume' ama jita nenkame pa'akun yeu beeptaitek. Intok jume' ama jita jinume. Intok jume' watem, bem tomita ama bem nanakulia'po, intok bem aet a' jipue'uta, junaka'a juni'i, mekka am biaktariak. Intok jume' ama wokkoim nenenkame, intok bem aet joka'um junaka'a juni'i, mekka am biaktariak. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Intok junama'a pa'ariatchi te'opopo nape konila bo'okame, kia jabeta juni'i junama'awa'am kaita weeya'ii'an. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Intok inen am majtaka, inen am tejwa: ―Jaisa eme'e ka ju'unea ―tiian―, inien a' ji'ojteituka'po: “Ini'i in te'opo, si'ime yoemrata betana, ama Liojtau bicha nok betchi'bo te'opopo ta'eenaa.” Taa eme'e, tesompo, jume' jita e'etbwamta bo'o jooriame, ama emo euse'po benasi, inien a' kari ya'ari'em ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Intok jume' te'opopo yaa'uchim intok jume' bem maejtom, inien a' jia'apo a' jikkajak. Intok kialim a' me'ebaeka juni'im ean. Taa katim a' me'an, bwe'ituk junuen auneekai, juni'im majjaen, juka' yoemrata aet yee a' majta'apo betana bem a' suum eeya' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Intok kupte' betchi'bo, junama'a bwe'u jo'ara Jerusalen tea'po, ju'u Jesus ama yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yokoriapo intok, ketwootana, chuna'ouwota weeka'po aman sajak. Juna'a chuna'ouwo intok, nawau tajtia wakiataka yeu matchulatukan. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Junak intok ju'u Peeo, tukariapo, Jesujta au a' teuwaaka'utau wawaateka: ―Itom majtame ―tiia―, ju'u chuna'ouwo, tuuka, junuen em au bette nokie jiaka'u, waakek ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus intok junak: ―Liojta, em jiapsipo yoem'ea'e ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Bwe'ituk em jiapsipo tu'isi a jita suale'eteko, kia senu kawibeu, a' kateka'po a' sookteka, baweu au a' jimmaasae'eteko juni'i, junuen au ean ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Junuen san beja, inien ne emou jiia, Liojtau bicha nokaka, si'imeta waka'a enchim au netanee'u, juna'a weeme, enchim a' mabetne'po betana aet eaka, a' suale'em ―tiia―. Intok junuen aet suale'eteko, enchim netanee'u, emou aune ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Intok Liojtau bicha noka'ateko, senuk beje'eka aulatuko, junuen em Liojtau noka'apo a' jiokoine. Lios achaita teekapo katekamta betana senuku, enchim ka tu'uwa ya'ari'ut, enchim aet jiokoine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bwe'ituk eme'e, kaabeta a jiokoe'eteko, ju'u Lios achai juni'i, teekapo katekame, senuku enchim ka tu'uwa ya'ari'ut, ket junalensu ka enchim a aet jiokoine ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesus intok, a' woj mamni ama wooi majtimmak, juchi Jerusaleneu yepsak. Aapo intok junama'a te'opopo naj weyen. Junak intok junama'a te'opopo saiwame, bem yo'o ya'urammak, intok jume' bem maejtom, intok jume' ama si'ime yoemratau a' yo'oraa, aman au sajaka, ama au yajaka Jesujtawi, a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Junak intok: ―Inien em aune' betchi'bo ―tiian―, jabesa enchi aet tekil makri ―ti a' temaek―. Intok jabesa juna'a, inien enchi antuame ―tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Junak intok ju'u Jesus am yoopnak: ―Nee ket senu weemta emou nattemaibae ―tiia―, intok enchim nee aet yoopnako, nee ket enchim tejwane, a' jabetuka'po, inika'a nee tekil makrime. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Joan yee babatoowamta ba'apo yee a' batoowa'u, jaku'ubosa aet sauritaka junuen yee batoowan, Liojta betana, oo inim bwiapo yoem nesautukan ja'ani, netche'em aet yoopna ―ti ameu jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Junak intok juname'e, bempo'im nasuk, ka kusisi inien jiu japtek: ―Liojta betana, ti te jiaka'ateko: “Jaisaaka intok, eme'e ka'a sualek”, ti itou nattemaine. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Taa inim bwiapo, yoem nesauta betana a' mabetlataka junuen yee batoowan ju'u Joan yee babatoowame, ti te jia'ateko, ito betchi'bo ka tu'ine ―ti jiian. Bwe'ituk bempo, juka' yoemrata emo majjaituan ju'u ameu am ya'ane'po betana. Bwe'ituk ju'u yoemra, junaka'a Joan yee babatoowame tuka'uta, tua lutu'uriapo, Liojta betana yeteu a' noktuawaka'po aman a' eeyaka, tu'isi emo a' yo'orituan. ");
INSERT INTO yaqNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Inia betchi'bo san, Jesujta, kaachin a yoopna machika: ―Katte ju'unea ―tim jiiak. Jesus juni'i, ket junuen am yoopnak: ―Nee juni'i, ne kaachin enchim a tejwaane, jabeta ea'po junuen in ane'epo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Intok senu weemta am majtabaeka, ta'abwi weemtau a' tammachiaka inen ameu nok taitek: ―Senu yoeme ―tiia―, yu'in pa'asi ouwota eechak. Intok korate betchi'bo, juyata ama jijjo'ak. Intok pa'asi taka ba'awata nu'u betchi'bo a' baba'awa'umta ama ya'atebok. Intok mekka aniau bicha bitchuu betchi'bo, yu'in tetata jikau bicha nat cha'abwak. ’Junuen auka intok, ta'abwim mampo a' su'u tojak. Intok pa'asi'ouwo takata, ama toboktitunemta, bempo'immak watek aman nu'u betchi'bo, lutu'uriata yaak. Junak intok, omot, mekka bwiarau bicha siika ju'u. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pa'asim bwaseo intok, senuk, a' nesaureowata, aman, pa'asi wajta tekipanoammeu bittuak. Pa'asim bwaseme ama chuktawame au lutu'uriamta aman nu'utuawakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Taa juname'e intok, kaita a' makaka, kia june'elaka simtuaka, intok ko'okosi a' yaakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Intok juchi intok, senuk a' nesaureowata aman ameu juchi bittuak. Taa junaka'a intok, tiusi maisi a' yaaka, koba jamti a' mamaasuka a' simtuak. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Intok juchi intok, senu nesaureowata aman bittuak. Junaka'a intok im me'ak. Intok juchi intok, bu'uuka aman bittuak. Juname'e juni'i ket junalensu, watem ko'okosi yaak, watem intok su'ak. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Junak san beja, wepul pu'ilaik useka, intok tu'isi a' nakeka juni'i, junaka'a junaman bittuak: “Jumak juni'i”, ti'eaka, “in a' useka'po aman, emo a' yo'orituanee”, ti au eetuakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Taa juname'e pa'asi etta tekipanoame, intok junaka'a usiwaita aman weyeo a' bichaka, inenim jiiak: “Inika'a pa'asi etta atteaneeme, a'abo weye”, tiian. “Taa inika'a pa'asi etrita itou a' tawane' betchi'bo, ite a' me'ene. Junak intok itou tawanee”, tim nau jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Junak intok, junaka'a bwiseka, a' me'aaka, junama'a pa'asi etripo, pa'akun bicha, mekka jakunim a' tojak. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Tua ju'u tekowaita intok inika'a pa'asi etrita atteakame junaman yepsako, jume' ama tekipanoame, jaisa tua ya'aneekai. Juname'e bat a' tekipanoasuka'um junuen bem auka' betchi'bo, tokti am su'aka kaita'po am tawane ―tiia―. Intok juka' pa'asi wajta ta'abwim mampo a' su'u tojitebone ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Jaisa, Liojta nok lutu'uriapo inen a' ji'ojteipo aman, eme'e kee a' noklaa ja'ani. Juna'a ji'ojtei intok, net nokaka, tetapo nee teuwaaka, inen jiia: Juka' tu'i tetata, tiia, kari aet utti nawanee'uta, jume'e, juka' karita joame, tua junaka'asu, pa'akun yeu tawaak. Chukula, juna'a teta, jiba junae karita betuk, samita nau yuma'apo, aetuk yecha'awak, bem ka junen eao juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Inika'a weemta yaakame intok, ju'u achai Lios aapo juna'a. Intok itom bichapo suum watchisi machisi maachi. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Junak intok, junaka'a weemta, ta'abwi weemtau a' tammachiaka, aapo'ik ameu noka'uta, bempo'immet junuen a' noka'ati ju'uneaka, a' bwiseka a' me'ebaeka ean. Taa juka' bu'uuraata ama anemta majjae' betchi'bo, kaachin a' yaaka, kia beja ama a' to'o sajak juka' Jesujta. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chukula intok, Jesujtau watem paiseom betana intok eroorianom teame betana aman au bittuawak, jita juni'i, a' nonoktuaka, a' na'atejo betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Juname'e intok, junama'a au yajaka: ―Yee majtame ―tim au jiiak―. Ju'uneate, lutu'uriata jiba em noka'apo. Intok kaabeta betana em emo suua'po. Bwe'ituk ee betchi'bo kaabe bwere yaa'uchim ―tiian―. Che'a juni san, empo si'imem nanancha eeyaka am bicha ―tiian―. Che'a juni san lutu'uriakamta ausu'litae Lioj tu'u lutu'uriata e'e yee majta'e ―tiian―. Inia betchi'bo san, senu weemta te eu nattemaibae ―tim au jiian―. Jaisa tu'inee ja'ani, oo ka tu'inee ja'ani, ju'uyo'o ya'ari Sesar teamtau tomita aman au tojipo ―tiian―. Junae tomie, ya'uraapo saiwame ae beje'etuana' betchi'bo. Inien san beja, itom tejwaane, jaisa te a' beje'etuane, oo te ka'a beje'etuane ―tim a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Junak intok ju'u Jesus, aapo'ik, bem a' bai ta'aabae'po aman amet ju'uneaka, inen ameu jiiak: ―Jaisa betchi'bo eme'e nee aet ji'obilaabae ―ti am temaek―. Juka' tomita neu toja ―tiia―, na'a bitbae ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Junak intok, bempo junaka'a tomita au tojak, aapo intok: ―Ini'i pujba ―tiia―, intok inime'e team, tomit katekame, jabesa juna'a ―ti am temaek. Bempo intok: ―Ini'i juna'a, ju'u yo'o ya'ari Sesar teamta pujbawa, intok a' teawam ―tim a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Junak intok ju'u Jesus inen ameu jiiak: ―Si'imeta waka'a Sesar teamtau bicha au a' lutu'uriaka'uta, ake'em a' maka'em ―tiia―. Intok si'imeta waka'a Liojtau bicha au a' lutu'uriaka'uta, ake'em a' maka'em ―tiia. Intok junuen ameu a' jiaka' betchi'bo, tu'isim a' suum'eeyak. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Junak intok jume' saruseom teame, kokkolam jiabijtene'po, junaka'a taewaita jakwoo juni'i, ka yuma'ane'etiame, aman au yajak Jesujtawi, intok inen au nattemaek: ");
INSERT INTO yaqNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Yee majtame ―tiian―, ju'u Moiseejtuka'u, ji'ojteita inien to'o siika, a' saiwata, kaabeta useka intok a' jubi to'o mukuko, a' sairawata a' jubi'une'po aman au utte'a'atiia, a' saiwata betchi'bo yoemiane'eteakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Inien a' wee'po san, woo busan o'owim nau weweriakan. Ju'u bat weyeme, jubeka, intok ka yoemiaka muukuk. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aet chukula weyeme intok, juchi a' jubi'uka juni'i, ka yoemiaka muukuk. Junaet chukula weeme juni'i, a' jubi'uka juni'i, ka yoemiaka muukuk. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Junuen nat cha'aka jume' woo busan o'owim nau weweriaka'um, junuen emo a' jubi makaka juni'i, kia jabe juni'i, junae jamuttau kia wepul yoemiata juni'i ka au to'o kokkok. Chukula kia aapo juni'i ju'u jamut muukuk ―tim au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kokkolam jiabijtene'po taewaita yumako, juname'e jiabijteko, jume' woo busan nau wewerim betana, jabesa tua aamak tawane. Bwe'ituk si'ime emo a' jubi maklatukan ―tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Junak intok ju'u Jesus am yoopnaka: ―Tu'isi em ji'opla'em ―tiia―. Bwe'ituk Liojta nok lutu'uriat em ka ju'unea. Intok kia Liojta utte'awat juni'i em ka ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bwe'ituk junaka'a taewaita yumako, kokkolam aet jijiabijtenee'u, emo jujupnaame kaitane. Bwe'ituk junaman teekapo, ankelesim benasia inime'e, juname'e benasi machine ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Intok kokkolam jiabijtene'po betana eme'e, jum Moiseejtuka'uta ji'osia ji'ojteimpo ka'a nokla ja'ani, junama'a ili juya beete'utchi ji'ojtek, intok Liojta inien au a' nokaka'po inen au jiakai: “Inepone Apra'amta Liojraa”, tiia. “Intok Isaak teamta Liojraa, intok Jakoobo' teamta Liojraa, inim nemak jiapsamme”, ti jiia ju'u Lios. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ini'i Lios intok, ka kokkoarimmeu Lios, taa jiapsammeu Lios ―tiia―. Inien san beja, eme'e tu'isi ji'opla'em, kokkoarim ka jijiabijte'etiakai ―ti ameu jiiak ju'u Jesus. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Intok senu maejto, junuen emo nau nok bwijlaame jikkajaka, intok Jesujta tu'isi am yoopnaka'po aman, a' jikkajaka, aman Jesujtau yepsaka, au nattemaek: ―Liojta nesauta betana ―tiaka―, jitaa nesaurisa, che'a utte'a itom a' ya'anee'u ―ti a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus intok a' yoopnaka: ―Si'ime nesaurita betana, ini'i juna'a, ju'u che'a utte'a itom ya'ane'u: “Ijra'eliitam teame, ake'em a' jikkajaka a' mammate'em, tiia. Ju'u itom Lios achai, wepul Lios jiba juna'a” ―ti ameu jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","“Intok em Lios achaita, tu'isi chikti em jiapsi utte'awatae, intok em jiapsi tu'i'eeritae, em achai Liojta yo'oreka a' nakne'em”, tiia. “Intok tu'isi aet jiapseka, a' nesawe'po aman weene.” Ini'i juna'a, ju'u che'a tu'i nesauri. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aet chukula weyeme intok, batte ale benasi maachi: “Em emo nake'e benasi”, ti jiame, “ket junalensu yoemrata a naknee”, ti jiame. Intok ini'i wooi nesauri, jume' waate si'ime nesaurita bepa, che'a eeyawatchi, ti ne eu jiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Junak intok ju'u maejto inen a' yoopnak: ―Tua su tu'i, yee majtame ―tiia―. Lutu'uriate'e nooka, kaabeta intok Liojtuka'po, tiaka, taa wepul jiba juna'a ju'u Lios, ti em jia'apo. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Intok chikti itom jiapsie, intok itom tu'i'eewamtae intok si'ime itom jiapsi'utte'awatae, junuen itou cha'aka, junuen itom a' nakne'epo. Intok tu'isi aet jiapseka a' nesawe'po aman weene'po ket junuen itou cha'aka, junuen itom a' bo'o jooriane'po. Intok juka' yoemrata junuen itom am nakne'epo ket junuen itou cha'aka ―tiia―. Intok te inien a' bo'o jooria'ateko, inim si'ime tekiata intok Liojta yo'ori betchi'bo, wakasim su'aaka am tattaawa'abepa, ite che'a tu'isi aunee inien ane'eteko ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus intok junak, tua junuentuka'po aman, juka' maejtota junuen a' yoopnaka' betchi'bo, a' mammateka, inen a' yoopnak: ―Empo i'an, juka' Liojta tu'i nok lutu'uriatat abe tu'isi aet ju'unea ―ti au jiiak. Junak intok, Jesujta junuen a' jiaka' betchi'bo, kaabe intok ta'abwi weemta a' temaebaeka ean. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus intok, junama'a bem te'opopo am majtaka, inen ameu jiiak: ―Jaisa betchi'bo ―tiia―, jume' maejtom, juka' Krijtota Labii' teamta a' yoemiak, ti jiamme. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Bwe'ituk juka' Labiituka'uta, Liojta tu'u jiapsi inien a' jiutuak: Ju'u tua achai yo'owe Lios, tiaka, in achai Krijtotau: “In batatana yejte'e”, ti au jiiak. “Si'ime wame'e, ka enchi am sau i'aka jiapsame, taa che'a tu'isi, kia enchi beje'eka aneme, inime'e si'imem, in enchi am nok jikkajitua'po tajtia”, tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jaisa i'an ju'u Labiituka'u juka' Krijtota usine. Bwe'ituk kia aapo'itaka juni'i, a' achai Krijto rokak. Intok juebenaka ama aneme, alleaka Jesujta jikkajan. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Intok jiba am majtasimeka: ―Jume' maejtom betana emo'em suua'em ―tiia―. Bwe'ituk juname'e, emo Lioj waatituamcha aneme benasi, emo tebe a'aabi'itotua. Intok jum kaayepo, juka' tu'isi yo'orisi maisi ameu tebotewamta eeyamme. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Intok jum Lioj waati betchi'bo, emo nau totojiwa'po, inime'e maejtom junama'a, ka amapo joobaeka'eene. Che'a juni san, bat bem jote'ene'uta che'a waata. Intok emo a'abojwa'po, jiba bat jote'ebaeka'eene. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Taa ka amma'ali aane. Bwe'ituk inime'e junen, jamut jokoptuim, bem atteata, kia tomituk juni'i, intok kia waj bwiatuk juni'i, intok kia karimtuk juni'i, am u'uraa. Chukula intok, bem bitna' betchi'bo, tu'isi a Lioj waate tiuna' betchi'bo, binwa juka' Liojtau bicha nokwamta weetua jume' maejtom. Inimmeu san junen, che'a bettesi amet aune, jiokot bem annee'u. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Junama'a bwe'u te'opopo intok, Jesus katekan, tomita ama jojjo'awa bichapo. Intok juka' yoemrata bitchun, tomita aman tojamta. Yu'in totomekame intok, che'a bu'uuk ama jojo'an. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Senu jamut intok, poloobetaka intok jokoptuitaka, ama yepsak. Juna'a intok, wooi kopre tomim ama joak, tu'isi ka beje'ewaekamta. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Junak intok ju'u Jesus, a' majta'ummeu chaaeka: ―Lutula wee'po ―ti ameu jiiak―, ini'i poloobe jamut jokoptui, Liojta bichapo, si'ime jume' che'a bu'uuk ama joakame bepa che'a bu'uuk ama joak. ");
INSERT INTO yaqNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bwe'ituk si'ime jume' waate, bem ameu yeu bi'ila'uta ama joak. Taa ini'i jamut, a' poloobe'a'po aman, juka' ili a' jipue'uta, tokti si'imeta ama joak, bwa'amta ae a' jinu'ea'uta juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jume' Jesujtaim junama'a te'opopo yeu sajaka, intok senu a' majtiwa: ―Achai ―ti au jiiak―. Yuu, inime'e bwere karim, bwere tetammea ya'arim bicha'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus intok a' yoopnaka: ―Inime'e bwere karim enchim bichaka'um ―ti au jiiak―, taewai aapo yuma'ane, inime'e karim si'ime bem tataptune'po. Intok inime'e bwere tetam intok, kia wepu'ulaik juni'i, ka nat joka tawane. Taa si'ime jeto chibela tataptune. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Senu ili kawiu intok, oliibo'ouwota bu'uuka, juna'a intok te'opota bichapo ka au mekka au machiata katek. Jesus intok, junaman bicha sikaa, junama'a aanen. Junama'a intok aapolaik, ju'u Peo' teame, intok Jakoobo' teame, intok ju'u Joan teame, intok ju'u Antej teame, inen a' tetemae japtek: ");
INSERT INTO yaqNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Inien auneeme ―tiian―, jakwoosa yeu weeneekai ―ti a' temaek―. Intok jitaa machilaasa aune, inika'a taewata abe yuma'asuseo ―tim a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus intok am yoopnaka: ―Kaabeta enchim bai ta'aane'po betana emo'em suua'em ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bwe'ituk in team teuwaaka, juebenaka yeu machine. Intok: “Inepo ju'u Krijto”, tim jiune. Intok bu'uum bai ta'aane. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Taa nassuawamta em jikkaja'ateko, intok kia nassuabaawa tiuwamta juni'i, katem jachin emo eetua. Bwe'ituk utte'a junuen yeu a' weene'po. Taa juna'a, kee ju'u subimwatuneeme. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bwe'ituk ju'u waate yoemratau yo'oraa, ta'abwi yoemratau yo'oraatamak nassuane. Intok kia o'omotchuu, ju'u bwia au yoowame aune. Intok tebaetune. Taa ini'i si'ime weeme, kia ju'ubwa naatewame, jiokot eenaa'u. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Taa eme'e, emo naas em suua'em ―tiia―. Bwe'ituk juriom ya'uraata bichapo yeu tojitune. Intok jum juriom nau emo totoja'po bemmucha'atune'em. Intok kia che'a yo'o ya'arim bichapo, intok yo'o yaa'uchim bichapo nee betchi'bo, junama'a yeu totojinaa'em. Juka' Liojta tu'u nok lutu'uriata bem jikkajine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Intok in tu'i nok lutu'uriata inim bwiapo jiapsammeu, si'imem yeu tajtia, ameu teuwaatune'po aman, utte'a, junuen bat ameu a' teuwaana'po, kee juka' chukula yeu weenemta yeu a' weyeo. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Intok eme'e, aman yaa'uchim bichapo nu'upawako, aman tojiwako, ju'u enchim nokne'epo betana, ka jain eene. Intok kaachin emo eetuakai. Taa junama'a lautipo, enchim noknee'uta nokne. Bwe'ituk Liojta tu'u jiapsi, aapo'ik enchim noktuabae'po aman enchim noktuane. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Intok kia a' sairaka juni'i, kiala'a me'etuneo juni'i, yeu a' bwijne. Intok kia achaiwaitaka juni'i, a' yoemiata junuen ya'a tebone. Jume' yoemiamtaka juni'i, bem achaim beje'eka japtene. Intok am su'ane. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Intok eme'e si'ime, nee betchi'bo omtanaa'em. Taa wa'a a' muke'epo tajtia nee yoem'eeyaakame, intok nee sualeme, juna'a jiapsi jinne'uritune. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Taa eme'e, juka' senu o'outa, Liojta te'opopo, ka ama an machika juni'i, ama anemta bichaka'ateko (inika'asan junen ji'ojtek ju'u Lanieltuka'u, Liojta betana noktuawakame), Liojta te'opota jaana a' eeyaka, intok junama'a Jerusalen tea'po ayukamta bu'uuk nasonteneeme (inika'a inien jiamta nokame, tua aet ju'unee betchi'bo, aet mammateka a' noknee). Junak intok, junaka'a junen ama anemta bicha'ateko, jume'e, bwiara Jurea' tea'po aneme, kawiu bicha saka'ane. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ju'u intok, karita bepa aneme, ko'om sikaa, ka wajiwa kibakeka a' weeya' betchi'bo jita nu'ubaeka'eene. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wa'a intok, wajpo aneme juni'i, ka juchi amau bicha nottibaeka'eene, a' jijine'um aman nu'ubaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Taa juname'e taewaimmet intok, tu'isi jiokot machine. Jaamuchimmeu abe asoammeu, intok jume' bem ili asoam jaibu chi'ituammewi. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Inia betchi'bo san, Liojtau bicha emo nokria, ka seberia mechammet, junam bicha enchim katne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bwe'ituk juname'e taewaimmet, tu'isi jiokot machine. Bwe'ituk, Liojta ke'esamriapo aniata ju'unakteka'po naateka inien jiokot machinee'u, kaitatuk. Taa i'an, juname'e taewaimmet, jiokot machinee'u junuen aune. Intok aet chukula junale benasi jiokot machinee'u, jakwoo juni'i, ka intok junuentune. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Taa ju'u achai Lios, ka binwa junuen a' an'ii'a' betchi'bo, kaita intok taewaita naa buusti am makak. Bwe'ituk, ka junuen auka'ateko, kaabe jiapsi ean. Taa aapo ju'u Lios, juname'e ama yeu a' pu'arim betchi'bo, junaka'a junuen anemta junama'a nukisi jiba junuen a' anne' betchi'bo, ka intok naa buusti junuen a' antuak. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Inien a' wee'po san: “Krijto wa'am aane”, ti senuk jia'ateko, ka'a sualbaeka'eene. Oo: “Wa'am jak a' yebijlaa”, ti a' jiao juni'i, ka'a sualbaeka'eene. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bwe'ituk juebenaka emo Krijtom tiaka, yeu machine. Waate intok, emo, Liojta betana noktuawaka bittuarim, tiaka yeu machine, intok yee bai ta'a' betchi'bo, sualwatchisi machik, machilaata am joone. Intok kia suum watchisi machik juni'i joone. Intok Liojta yeu pu'arim a am bai ta'a'ateko juni'i, am bai ta'aabaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Taa eme'e, aet emo suua'em. Bwe'ituk inika'a weemta, kee yeu weyeo, jaibu ne si'imeta enchim tejwasula. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Taa intok, juname'e taewaimmetchi, jiokot machisi maisi yeu simsuka'po, ju'u ta'a ka machisi tawane. Intok kia ju'u mala meecha juni'i ka machiriane. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jume' chokim intok, teeka betana ko'om yojtine. Intok si'ime ju'u teekapo ayukame, au yoyoone. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Junak intok, seenu, namupo a'abo weeka bitnaa. Emo benasi inim yeu yoemtakai, yo'orisi machisia, intok tu'isi utte'awakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Junak intok, a' nesaureo'ankelwam, si'imekut naas am bittuaka, aapo'ik yeu pu'ala'um nau am toji betchi'bo, si'ime bwiat yeu tajtia, na'ikim aneme nau am toji betchi'bo ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Senu weemta ne enchim majtabae ―tiia―. Eme'e ―tiia―, juka' chuna'ouwota, basiu taitemta bicha'ateko, eme'e jaibu ju'uneene, juka' tatariata a'abo weye'po. Junaka'a mammateka ju'uneene. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ket junalensu, bat naataka in emou teuwaaka'uta junuen yeu a' machi taiteko, ket eme'e a aet ju'uneene, juka' Liojta usiwai, che'ewasu ka mekka a' be'ee'po, inim wain ko'om a' yebijne'po ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Lutula wee'po ―tiia―, in emou teuwaaka'u, i'an inime'e taewaimmet, inim bwiapo jiapsame, juka' in teuwaaka'u, kee am kokkousu, yuma'isi si'ime yeu machine ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ju'u teeka juni'i, lu'utine, intok kia bwia juni'i lu'utine. Taa in noki, ka lu'uteka, jiba betchi'bo aune ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Taa kaabe a' ju'uneyya junaka'a taewata, jak weyeosu a' yuma'ane'po. Kia ankeltaka juni'i, ka'a ju'uneyya, teekapo aneme. Intok kia Liojta usiwai juni'i ka'a ju'uneyya, taa aapo jiba ju'u achai Lios ju'unea ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Taa eme'e ―tiia―, junaka'a taewata, jak weyeo a' yuma'ane'po ka enchim aet ju'unea' betchi'bo, juka' bejak in emou teuwaaka'uta yeu a' wee taiteko, tu'isi aet mammateka, Liojtau bicha emo nokria, intok kulupti juka' emo benasi yoemta a' yebijnee'uta bo'o bitne. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bwe'ituk ini'i weeme, iiyilen maachi, senu yoeme, mekka bicha simbaeka, a' jo'awapo a' nesaureowam, we'epulaim jitat am tekil makaka, sika'a benasi maachi, intok juka' senuk, jum a' jo'awapo jum ama yeu rejtiwa'po si'imeta a' suuasaeka, junama'a a' to'o siika ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Junuen san beja, junaka'a, jak weyeo a' nottine'po ka ju'uneaka, oo kupteo tana yebijne, oo nasuk tukaata weyeo, oo matchuu bicha, totoim kukuseo, oo tua matchusuk, a' yebijne'po ka ju'uneewa' betchi'bo, jiba a' bo'o bichaka ama anne. Eme'e juni san, netchem bo'o bichaka tawane. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bwe'ituk enchim ka emo suuao, inepo seej chukti emou yepsako, enchim kokocheme teune ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Intok si'imeta waka'a in emou teuwaa'uta, si'imemmeu ne yeu tajti a' teuwaaka ne junen jiia, bem nee bo'o bicha'po amani. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chukula intok, wooi taewata be'eeo, bem pajko, bwala'aso'ola jisu'awa taewaitune' betchi'bo, intok jume' paanim ka reberuakame, bwa'a taewaitune' betchi'bo. Intok jume' te'opopo, ama saiwame bepa che'a yo'o yaa'uchim, intok jume' maejtom, Jesujta etbwa bwij betchi'bo, intok a' me'etune' betchi'bo, awim a' jaiwan, junuen a' ya'abaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Inenim nau jiakai intok: ―Ka jume' taewaim weye'po te inen aune, bwe'ituk te junuen ayuek ―tiian―, juka' yoemrata, itou omtineekai, ka yanti eewame aune ―tiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Aapo'ik intok, Jesujta, jo'ara Betaania' tea'po aneo, junama'a yoeme Simo' teame, bat naataka junerasi taka sa'awakai, junama'a jo'aaka, ju'u Jesus intok, junae jo'aapo aanen. Aet jiji'ibwawapo intok, aapo'ik aman yejteko, senu jamut, ama Jesujtau yepsaka, juka' ochokok tu'isi win jubak, naaro' teamta ausu'lik, intok tu'isi beje'ewakamta weeyan. Junama'asan juka' ili tosai teta soto'ita, aet a' auka'uta, jamtaka, junaka'a ochokok a' kobawapo aet a' to'aak. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Waate intok ama aneme, inia weemta betchi'bo emo o'omtituak, inen emo eetuakai: ―Jaisaaka tua, beuta'a yaak ―tim jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bwe'ituk ini'i ochoko win jubak, che'a tu'i ean, bu'uu tomipo nenkitu ean. Bwe'ituk a' beje'ewa'u, batte senu wasuktiapo tekipanoaka ama kobaka'u, junaka'a beje'ewaek. a' nenkak intok juna'a tomi poobemmet na'ikimte'eewan. Inia betchi'bo san, junaka'a jamutta a' beje'eka, ae tana nookan. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Taa Jesus intok, junammeu: ―Ake'em a' su'u tojaka, katem suati a' bicha ―ti ameu jiiak―. Bwe'ituk ini'i jamut, tu'uwata neu ya'ala ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bwe'ituk jume' poloobem jiba emo mak anne, intok tu'uwata enchim ameu ya'abae'po aman, jiba emou aune. Taa nee ka jiba inim emo mak annee. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","In mukuka, in aet ma'ana'ata'apo neu ya'anaa'uta, ini'i jamut, ket be'eeo aapo jaibu inika'a ochokok win jubak a' yuma'ala'po aman, in takaat net a' si'itala. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Lutula wee'po inien ne emou jiia, ini'i Liojta tu'i nokta, kia jak juni'i, si'ime bwiat yeu tajtia, a' teuwaawa'po, inika'a jamutta, juka' ochokok win jubak, net a' si'itaka'po aman, ket teuwaatunee aapo'iku waatitune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Junak intok ju'u Juuraj Ijkarioote' teame, woj mamni ama wooi a' majtimpo na'ikiatuka'u, juna'a, jume' te'opopo saiwame, bem yaa'uchimmeu sikaa, Jesujta ameu yeu bwiseka, bempo'im mampo a' su'u tojine' betchi'bo amemak au tu'utek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Juname'e intok, a' jikkajaka, junae weemta betana, emo alleetuaka, intok tomita a' mikrokaka a' tejwak. Chukula intok ju'u Juuraj Ijkarioote' teame, a' bwijtune' betchi'bo, aet tekipanoa taitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Intok, ju'u bem pajko, jume' paanim ka reberuakame bwa'e taewaita yumako, intok jume' bwara'aso'olam aet su'anaa'u. (Juna'a intok pajkua'atea tiia.) Junak san beja, jume' a' majtim: ―Jakunsa ―tiian―, jume' paanim ka reberuakame, intok juka' bwala jisu'ari jissobata itom bwaa i'a ―tim a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Junak intok, aapo, wooi a' majtim, bwe'u jo'arata kateka'u am bittuak, intok: ―Senu o'outa, soto'po ba'am weeyamta enchim nankika weene ―tiia―. Junaet cha'aka em katne ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Intok senu jo'arapo a' kibakeko, junaman, junaka'a karita atteakamtau eme'e yajaka, inen au jiunee: “Ju'u yee majtame inen jiia: Inim em jo'apo, jume' paanim ka reberuakame, intok juka' bwara jisu'ari jissobata, aet a' bwa'a taewaita yumaka'po aman, inim em jo'apo a' ji'ibwarokaka nokla. Kiali'ikun te a' ju'uneyyabae, jakuni itom ji'ibwane'po.” ");
INSERT INTO yaqNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Junak intok juna'a, junama'a, junae karita bepa, intok senu bwe'u kari katek. Junaka'a intok enchim tejwane. Junama'a intok si'ime aayuk, itom ae ji'ibwanee'u. Eme'e junen intok, junama'a, ito beasi si'imeta ama tu'utene. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jume' majtim intok, aman bwe'u jo'arau bicha sajaka, junuen ameu jiuwaka'po aman, junuen ameu yeu siika. Intok paanim, ka reberuakame, intok bwara jisu'ari jissobata, bwa'ana'po, junama'a si'imeta tu'ulisi tu'utekamme. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kupteo yumak intok, ju'u Jesus, jume' woj mamni ama wooi ama a' majtimmak, junaman, paanim ka reberuakame, intok juka' bwara jisu'ari jissobata, bem bwa'ane'po yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Junama'a intok, ama aet jiji'ibwawa'po, ji'ibwa betchi'bo, ama jootekai, Jesus inen jiiak: ―Lutula wee'po ―tiia―, emo tana senu aane, i'an nemak inim ji'ibwame, nee yeu bwiseka nee nenkineeme ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Junak san beja, bempo, ka emo alleetua japtek, intok we'epulaka inen au jiu japtek: ―Jumak juni'i inepo ja'ani ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Junak intok aapo am yoopnaka: ―Jume' woj mamni ama wooim betana ―tiia―, wepu'ulaka juna'atune ―tiia―. Pu'atopo in ji'ibwa'po, paanim komoniaka, am bwa'akame ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Taa lutula wee'po, ju'u emo benasi yoemta betana junuen a' ji'ojteituka'po aman, au chupne. Taa tu'isi ae betchi'bo jiokot machine, junae o'outawi, ju'u, yeu a' bwiseka a' nenkakamtau ―tiia―. Che'a tu'i ean ―tiia―, juna'a o'ou, jakwoo juni'i ka inim yeu tomteka'ateko ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Junak intok ju'u Jesus, ketuni am ji'ibwaosu, juname'e paanim, ka reberuakame, nu'uka, Liojtau bicha noksuka intok, am rebekta taiteka a' majtimmet naas am na'ikimte taitek: ―Jibabu ―tiakai―, ini'i juna'a, ju'u in taka benasi machik, enchim bwa'anee'u. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Juka' pa'asi ba'awata aet auka'uta intok, nu'uka, Liojtau bicha nookak. Liojtau bicha au nokriasuka intok, junaka'a pa'asi ba'awata, bem a' ji'ine' betchi'bo, naas am maktaitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Intok: ―Ini'i juna'a ―tiakai―, ju'u in ojbota benasi maachi. Liojta betana bemelasi lutu'uria ya'ari, juebenam betchi'bo wo'otineeme. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lutula wee'po ―tiia―, inika'a pa'asi ba'awata ne kaa'intok ne inim emo mak a' ji'ine ―tiia―. Taa taewai yuma'ane, junaman Lios yo'o nesaweka kateka'u, ta'abwi, bemelak pa'asi ba'awata in emo mak ji'inee'uta yuma'ane ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Junama'a intok, Liojtau bicha weyemta juka' bwikta bwiikak. Junama'a intok, junuen ausuka, senu kawiu, tu'isi oliibo'ouwota auka'u bicha sajak. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Junama'a Jesus intok, inen ameu jiiak: ―Inie tukaariat, si'ime eme'e, neu aunemta betana emo womtaka, nee to'o tennine'em ―tiia―. Bwe'ituk chupi'iseka weye ju'u Ji'ojtei inen jiame: “Bwaram womteka, na'ikim bem tennine' betchi'bo, juka' am suuamta ne me'enee”, ti jiia ju'u ji'ojtei. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Taa chukula intok, ne jiabijtesuko, bwia Kalilea' tea'u bicha ne emo pat weene ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Junak intok, ju'u Peeo inen au jiiak: ―Eu aunemta betana, si'imem emo womtaka'ateko juni'i, inepone kaachin ino majjaituaka enchi to'o simbaeka'eene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Taa ju'u Jesus intok, aapo'ik inen yoopnak: ―Lutula wee'po ―ti au jiiak―, ne inen ne eu jiia, inie tukaariat, totoi'o'owiata kee wosa a' kukuseosu, empo, bajisi temaiwako, junalensu ket, bajisi, ka nee emo ta'aa tiune. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Taa ju'u Peeo, che'a juni san au ousi eetuaka: ―Kia nee a eemak muke'etek juni'i ―tiia―, nee eemak mukne ―tiia―, intok jiba ino enchi ta'aa tiakai. Jume' waate juni'i, ket jiba junaensu jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Junak intok, sajaka, Jetsemani' tea'u yajak. Jesus intok, junama'a am joosaeka am tejwaak. Bwe'ituk bempo'immeu, ameu ili mekka, aapola, Liojtau bicha nokbaeka ean. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Taa juka' Peo' teamta nuk siika, intok juka' Jakoobo' teamta intok juka' Joan teamta. Intok tu'isi au jachin eetuataitek. Intok ka au alleetuataitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Juname'e bajika intok, aamak sajakammeu: ―In jiapsi abe siok muke ―ti ameu jiaka―, emo'em suuaka, im em taawa ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Junak intok ju'u Jesus, jum a' ane'epo, mekka jeela sikaa, bwiapo, tonommea kikteka, Liojtau bicha nokbaekai, jumak juni'i, junama'a lautipo, ka ine'e maisi machik au weyemta, ka utte'atune, ti eakai. Intok Liojtau bicha nokaka, inen jiiak: ―In achai ―tiia―, empo che'a, si'imeta a jooa. Inika'a neu weyemta, empo a omot bicha, ta'abwisi a' kuaktaka'ateko, junuen aune. Taa ka in junen ea'po, taa em ea'po amantune. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Junak intok, jume' baji a' majtim, a' to'o sika'apo aman, ameu yepsaka, kokocheme teaka, Simotau: ―Jaisa empo koche Simo ―ti a' temaek―. Jaisa empo kia chubala juni'i, ka kocheka a aane ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ka tu'uwata ka enchim ya'ane' betchi'bo, aet emo suuaka Liotau bicha noka'em ―ti ameu jiiak―. Bwe'ituk ju'u jiapsi ala, tu'uwau bicha jiba ea, taa ju'u enchim takaa, ka ama aawe ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Intok juchi'intok, bat naataka, Liojtau bicha nok betchi'bo, tonommea a' kikteka'u bicha sikaa, junaman, jiba junaka'a, bat naataka junaman a' teuwaa'uta nookak. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Junak intok, jume' baji a' majtim a' to'o sika'apo aman ameu yepsaka, juchi kokocheme teak. Bwe'ituk juname'e intok bem yete kokkolamtuka' betchi'bo, kia kaita nok machiakan, juchi bem kokocheka teuwaaka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bajisi junuen auka beja, juchi juname'e bajimmeu notteka: ―Jaisa eme'e ketuni kokoche ―tiia―, intok ketuni yum jo'ewamta weetua ―ti am temaek―. Jote'embu ―tiia―. Eme'e jaibu kaachin an machi. Bwe'ituk yuma'asuk ju'u in teuwaaka'u, emo benasi inim yoemtukame, ka tu'i jiapsi yoemem mampo a' su'u tojinaa'u. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Japte'em. Bwe'ituk a'abo weye ju'u nee yeu bwiseka, nee nenkineeme. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ket a' nokaosu intok, ju'u Juuras Ijkarioote' teame bat naataka woj mamni ama wooi a' majtimpo na'ikiarituka'u, juebena yoememmak ama Jesujtau yepsak. Te'opopo saiwame, bem yo'o ya'uram betana intok junama'a yoemrapo che'a ama yo'o ya'arim betana, intok junama'a bem maejtom betana, aman bittuarimtakai. Waate tettebem kukuche'eka kaaten. Wate intok bwere kutam mampo machu'utisakan. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ju'u yeu a' bwijneeme intok a' nenkineeme, jaibu senu machilaata am maklatakai, inen ameu jiulatukan: ―Te aman yajako ―tiaka―, waka'a a' pujbawapo, in aet tentenee'u, junaka'a, eme'e, tu'isi a' suuaka a' bwiseka a' weeyane ―ti ameu jiulatukan. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Intok ama yajaka, ju'u Juraj Ijkarioote' teame, Jesujtau rukteka, a' pujbawapo aet tenteka: ―Yee mamajtame ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Junak intok juname'e, junuen bem tejwarimtuka'po aman, Jesujta bwisekamme. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesujta majtim betana intok, seenu, a' bainapo jume' tebe kuchi'im yeu wikeka, te'opopo nesawemta a' nesaureowata aman bittuarita, naka chukta'a beebak. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus intok, ameu nokaka: ―Jaisa nee etbwareotuka'a benasia eme'e, mampo kuche'eka, intok kutam machu'uteka a'abo nee bwij betchi'bo, a'abo neu yajak ―ti am temaek―. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kati'ikun nee chikti ta'apo, emomak jum te'opopo aneka intok yee majtan. Junama'a intok jaisaakai eme'e ka nee bwisek ―ti am temaek―. Taa juka' ji'ojteita junuen a' chupne' betchi'bo, utte'a inien a' ya'atune'po ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Junama san, jume' a' majtim, si'ime a' to'o tennek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Taa seenu, ju'ubwa yo'otume, ka tajo'oreka taa kia bwe'u tosai tajo'orimmea au ropti jintuarika, junama'a Jesujtaimmak ama aanen. Junak intok, jume'e, Jesujta junuen bwisekame, ket junaka'a ju'ubwa yo'otumta aamak weeyabaeka, ammea au a' jintuarim bwisek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Taa juna'a intok, am mamajuka, jume' a' jineka'um, bem mampo a' to'o buiteka, ama yo'eeka, june'elaka siika. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesujta intok, te'opopo che'a yo'o ya'ataka, nesawemta jo'au tojiwak. Junama'a intok, si'ime jume' ama te'opopo ju'u yo'oora intok junama'a yoemrapo ama yo'o ya'arime ama aanen. Intok si'ime jume' junama'a bem maejtom. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Taa ju'u Peo' teame, a' weeyawao, ili mekka, aet cha'aka weyen. Intok a' junama'a jo'ara mayoau tajtia aamak yepsak. Te'opopo yo'o ya'ataka nesawemtau a' tojiwako. Intok ama saiwammak, tajimmeu kateka sukawen ju'u Peeo. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Intok junama'a, ju'u yo'oora, jum te'opopo nesaweme, intok si'ime ju'u ya'uraa, Jesujta me' betchi'bo, watem, jitat, ka tu'ikut betana, a' me'etune' betchi'bo, a' na'atejonemta waatan. Taam kaabeta teak. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bwe'ituk juebenaka, aa noki'ichiata, ka tu'ik ae tana nookan. Taa bem aet noka'u, intok aetana a' waatiawa'po aman, ka ama yeu weaman. Bwe'ituk utte'atukan, wooi oo baji yoemem, nanancha bem a' teuwaane' betchi'bo, juka' bem a' na'atejonee'uta. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Junak intok, waate, a' beje'eka, aa noki'ichiata nok japtek inenim jiakai: ");
INSERT INTO yaqNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Itepote che'a, inika'a inen ti jiamta te jikkajila. Aapo, ika'a te'opota, maamea ya'arita au tatapne, tiia. Baji ta'apo intok, ta'abwi te'opota, ka maamea ya'atunemta au ya'ane'etiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Taa junuentak juni'i, a' beje'eka bem teuwaa'u, ka nanancha a' teuwaak. A' waatiawa'po aman ka yeu weaman. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Junak intok ju'u te'opopo che'a yo'otaka, ama nesaweme, nasuk kikteka, Jesujtau: ―Jaisa empo kaita am yoopna machi ―ti a' temaek―. Inika'a weemta enchi beje'eka nokammewi. Jaisa lutu'uria ja'ani, bem et noka'uta ―ti a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Taa aapo intok, ju'u Jesus, tua kaita am yoopnariak. Juchi intok ju'u te'opopo che'a yo'otaka ama nesaweme, juchi au nattemaeka: ―Jaisa empo juna'a ja'ani, ju'u Krijto ―ti a' temaek―. Intok ju'u, tua yo'oriwamta Liojta betana, empo usiwai ―ti a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Junak san beja, ju'u Jesus: ―Inepo juna'a ―ti au jiiak―. Intok juka' Liojta usiwaita empo bitne, Liojta, si'ime utte'awata betana, intok a' batatana katekamta bitne. Intok ket, namupo a'abo ko'om weyemta'e'e bitne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Junak intok ju'u te'opopo, che'a ama yo'o ya'arime, kujteerimmea, au supe siuti wikeka, ama anemmeu inen jiiak: ―I'an, junuen a' nokaka' betchi'bo ―tiia―, junuet a' nok bwijlataka, intok a' beje'eka aet nokneeme, kaabe intok waatiatune ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Eme'e a' jikkajila, junuen ju'enasi a' jiaka'po. Jaisa emou maachi ―ti am temaek. Juname'e intok, si'ime, a' me'e i'aka nookan. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Waate intok, aet chit watti japtek. Intok a' puj suma'ika, a' beebaka, inen au jiian: ―Noolia ―tiian―, itom tejwaa jabeta ju'u enchi choname ―tim au jiakai. Jume' waate intok, ama saiwame, a' chonaka, ko'okosi a' jooan. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Te'opopo che'a yo'o ya'arita, jamut nesaureowa aman ko'om siika. Peota intok junama'a betuk a' ane'epo, ");
INSERT INTO yaqNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","tajimmeu sukawemta bichaka, tu'isi a' bitchuka, inen au jiiak: ―Jaisa empo ket, Jesuj nasareeno' teamtamak empo weaman ketchia ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Taa aapo ju'u Peeo intok: ―Tua ne ka'a ta'aa junaka'a ―ti au jiiak―. Intok ne kia ka ju'unea jachin em neu jia'apo ―tiia. Intok junama'a, ama yeu rejtiwa'po, pa'akun bicha yeu siika. Intok ju'u totoi'o'owia kukusek. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ju'u jamut nesaureo intok, juchi a' bichaka, ama anemmeu inen jiiak: ―Ini'i ket juna'a, Jesujtaim betana weyeme ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Taa ju'u Peeo intok, juchi, ka'a lutu'uria'atiaka nookan. Intok juchi intok, chukula, jume' ama aneme: ―Lutula wee'po ―tiian―, empo amemak weaman ―tim Peotau jiian―, intok'e Kalileotakai. Bwe'ituk bempo'im benak nooka. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Taa ju'u Peeo, tua a' sualna' betchi'bo inien au noktaitek: ―Tua ne ka'a ta'aa junaka'a o'outa ―tiia―, enchim nee aamak weama tia'u. Intok ka tu'uwa neu a'aune'uta net aune'etiia, in noki ka lutu'uriatuko ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Junak intok ju'u totoi'o'owia, iniamak nau, jaibu wosa kukujlatukan. Junak intok ju'u Peeo, Jesujta au nokaka'utau wawaateka, inen au a' jiaka'po: “Juka' totoi'o'owia kee wosa kukuseo, empo bajisi netana temaiwaka'ateko, junama'a empo ket junalensu, ket bajisi, ka emo nee ta'aa tiune.” Peeo intok, junuen au nokwakamtau wawaateka, bwan taitek. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yokoriapo intok, jume' te'opopo saiwame, bempo'im bepa che'a ama yo'o ya'arime, intok jume' yoemratau che'a ama yo'o ya'arimmak, intok bem maejtommak, intok si'ime ya'uraamak nau, wepulsi nau a' lutu'uriateka, Jesujta, mampo nau suma'ita, Pilaato' teamtau tojak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaato intok inen au nattemaek: ―Jaisa empo juna'a, ju'u juriommeu ju'u rei ―ti au jiakai. Jesus intok: ―Lutu'uria, em noka'u ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jume' te'opopo saiwame, bempo'im bepa che'a yo'o ya'arime, juebenakut betana a' na'atejoka ama aanen. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaato intok juchi au nattemaek: ―Juebena weemtat betana em na'atejowa'po, jaisa empo ka'am yoopnabae ―ti a' temaek―. Jaisa empo kaita am yoopna machi. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Taa ju'u Jesus, kia junuentak juni'i, ka'am yoopnak. Pilaato intok, tu'isi au a' suum eeyatuan. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Taa juname'e taewaimmet intok, pajko taewaituko, junuen a' bo'o jooriawa'po aman, ya'uraapo eta'ita, kia jabeta juni'i, bem a'awaka'uta, jiokoiritaka, su'u tottojiwan. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Junama'a intok ye'e'eta'awa'po, watemmak, senu eta'itukan, Barabaj teame. Bwe'ituk juna'a, watemmak nau eaka, ya'uraata beje'eka aulammake, yee su'awamta weetuan. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ju'u bu'uura ama yajaka intok, junuen a' bo'o jooriawa'po aman, pajko taewaituka' betchi'bo, senuk ama su'u tojina'po betana a' teuwaan. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilaato intok: ―Jaisa eme'e, juka' juriommeu yo'o ya'ari' teamta nee su'u toji'ii'a ―ti am temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bwe'ituk aapo ju'u Pilaato tu'isi ju'unean, yo'o ya'uraata, Jesujtat kopteka, aman au tojiwaka'po. Bwe'ituk ju'u te'opopo yo'o ya'uraa, ka'a bibitpean, juka' yoemrata che'a am eeya i'akai. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Taa jume' te'opopo che'a ama yo'oora, juka' bu'uurata amemak eene' betchi'bo, ameu nookan, Barabajta su'u tojitune'po betana. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Junak san beja ju'u Pilaato: ―Jaisa eme'e nee aet nesau'ii'a, inika'a juriommeu yo'o ya'ari' teamtat ―ti am temaek. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bempo intok chai nokpo inen jiian: ―Kuuset popontaka, me'etune ―ti chaaen. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Taa ju'u Pilaato intok, inen ameu jiia: ―Jitasa ka tu'ika ya'alataka, eme'e kuuset a' muk i'a ―ti am temaek. Taa bempo intok, che'a kusisi chaaeka, inen jiia: ―Jiba kuuset popontaka, me'etune ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ju'u Pilaato intok, si'ime juka' yoemrata ama anemtamak, tu'isi tawaabaekai, Barabaaj teamta jiokoi tebok. Juka' Jesujta intok, bat a' bemmucha'ateboka, chukula, kuuset a' popontune' betchi'bo aet nesawek. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Junak intok jume' sontaom, jum yo'o ya'uraa karita korapo wajiwa a' kibachak. Juna'a intok Pretoorio' tea. Junama'a intok, si'ime ju'u sontaoraa, emo nau tojak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Junama'a intok, unnaa sik saalaim teebem wokimmeu tajtia supetuawak. Intok juka' juyata tu'isi wichakamta jijjo'aaka, a' koona yaaka, a' kobawapo aet a' yechak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Junama'a intok, sep au tebote pat: ―Jaisa empo jiia, juriommeu yo'o ya'ari ―ti au jiu japtek―, emo a' yo'orituamcha aneka. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Intok bwe'u bakae, kobat a' bebaka, ko'okosi a' jooan. Intok aet'im chit wat watten. Intok a' yo'oremcha aneka, kia jak wa'am a' eeyaka, au tonommea jajapten. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Junuen jaanam aet noksuka intok, jume' sik saalaim supem, bem a' supetuaka'um, juname'e a' yecha'ariaka, jiba a' supewampo a' kobatuak. Intok kuuset a' popontune' betchi'bo, yeu nuk saka'awak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Senu o'ou intok, Sireene' bwiara' tea'a betana joome, juna'a intok Simo' teaka, intok Rupo' teamta intok Alejanro' teamta achai, waj betana yebijsusekan. Junama'a wa'am a' weyeo intok, Jesujta aniasaiwakai, juka' kuujta pu'aktatuawak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Intok senu ili bwia kawiu, kolkota' tea'po tojiwak. Juna'a intok, kuaktituko, Mukia koba, ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Junama'a intok, juka' pa'asi ba'awata, wantiriata cha'atuamta miira' teamtamak nau kuutita, a' ji'ii'aka, au ji'obek. Taa aapo intok, ka'a je'eka. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Intok kuuset a' poponsuako, aet chukula, a' supewam, naikisi reebeik am na'ikimtek. Jume' reebeim intok, we'epulaim amemak tawane' betchi'bo, ja'atepo nau yeuwak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Intok kuuset a' poponwa'po, tua batan jiao junen ya'awak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Intok a' na'atejoka junuen a' ya'awaka'po, ju'u ji'ojtei inen ji'ojteitukan: “Juriommeu yo'o ya'arituka' betchi'bo”, ti ji'ojteitukan. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aamak intok, naa buusti, wooi etbwareom aamak lopola bem kuusimmet poponwak. Senu a' batatana, senu intok a' miko'otana. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","“Ka tu'i yoememmak junuen ya'atuk”, ti jiakame, junama'a chupuk ju'u senu ji'ojteipo, jakwoo naateka junuen teuwarituka'u. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ama amet wa'am kateme intok, kialim jaana aet jiaka, au koba wiu wiuten, intok inenim au jiian: ―Empo che'a, juka' Liojta te'opota tatabeka'ateko juni'i, intok baji ta'apo juchi emo a' ya'ane, ti bat naataka junuen jiusukame, ");
INSERT INTO yaqNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","empo, emo jinne'uka, kuuset ko'om weye'e ―tim au jiian. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Intok ket jiba junaensu jume' te'opopo saiwame betana, ama ya'uram, bem maejtommak nau, jaanam aet nookan, inenim jiakai: ―Watem jinne'uk. I'an intok, aapo ka a au jinne'u ―tim nau jiian―. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Empo ―tiian―, ijra'eliitammeu Krijto yo'o ya'ari'i teame, junum kuuset em poponikut betana ko'om weye'e intok junuen enchi ayuko, ite a' bichaka, te enchi sualne ―tim au jiakai. Jume' intok, aawit ama ket kuuset poponwakame, ka tu'isi aetana nookan. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Intok tua luula kateko naateka, si'ime bwiat, bajim jia'apo tajtia, ka machisi tawakan. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Intok junama'a, bajim jia'apo, ju'u Jesus kusisi chaaeka, inen jiian: ―Eloi, Eloi, lama sabaktani. ―Ini'i noki intok, inen jiubae: “Lios in achai, jaisa betchi'bo empo kia nee jimaalataka, neaj koptilata benasi aulaa”, ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Junama'a intok, senu ama aneme, junuen a' jia'apo aman a' jikkajaka: ―Eliaj teamtau a' chaae ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Junama'a lautipo intok, ju'u seenu, senu weemta, ejponja' teamta, juna'a intok komoniawak, ba'ata nunu'ee, binaakretae a' komoniaka, tebe bakapo a' sumaka, aman jikau au a' noitak, intok inen jiakai: ―Chubala em bo'o bicha ―tiia―. Jumak juni'i ju'u Eliaj teame au a' chaae'u, au yepsaka, ko'om a' yecha'ane ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Taa ju'u Jesus, junama'a lautipo, kusisi chaipat, muukuk. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Junak intok, jum bwe'u te'opopo, unnaa bwe'u tajo'orim, ama wajiwa cha'aka'um, nasuk'aman, jikat naateka, ko'om tajti, siutek. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ju'u intok, sontao ya'ut, aapo'ik bichapo ane'u, junuen a' jiaka a' mukuka'po aman a' mammateka, aapo'ik betana inien a' teuwaak: ―Lutula wee'po, ini'i o'ou, kuuset poponiakame, Liojta usiwai ―tiia. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Intok mekka'ekut, waate jaamuchim aman ja'abweka, a' bitchun. Juname' nasuk intok, ju'u Maria, bwe'u jo'ara Maareena' tea'a betana jometaka ama aanen. Intok ju'u senu ju'ubwa yo'otume, Jakoobo' teamta intok a' saira, Jose' teamta, juname'e ae, ket ama aanen, Maria' teame, intok ju'u Salome' teame. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Juname'e jaamuchim intok, jum bwiara Kalilea' tea'po intok, tu'isi a' suuaka, aet emo tekil makritukan. Intok wate juebena jaamuchim ket junalensu aet emo tekil makritukan, Jerusalen tea'po, jum yee a' majta'apo, aamak naj kuaktisukame. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Junae taewait, kupteo, ket jeo jomteo, juchi yokoriapo intok sabalatubae' betchi'bo, intok aet yum jo'etuneeo, junaka'a sabalata, kee yumao, si'imeta baa ya'asubaeka ean. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Junue betchi'bo senu yoeme, Jose' teame, Arima tea' tea'po jo'aakame, juna'a intok ya'utuka, yo'oriwan. Intok ket jiba junalensu, juna'a, Liojta utte'a nesawata inim aniau ko'om a' yuma'ane'po aet bo'o bichakan. Juna'asan, au ou bujtaka, Pilaato' teamtau kibakek. Intok juka' Jesujta takaata a'awak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ju'u Pilaato intok, lauti a' mukuka' betchi'bo, a' suum'eeyak. Juka' ya'uttau intok chaitebok, juka' Jesujta muksuka'po, oo kee a' muke'epo aetana ju'uneebaekai. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Intok ya'utta betana, Jesujta muksuka'po junuen lutu'uriata makwaka, juka' Jesujta takaa, Jose' teamtau su'u tojiwak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Juna'a Jose' teame intok, bwe'u tosai tajo'orim jinuka, chukula intok ko'om a' yechaka, bwe'u tosai tajo'orimpo a' biijtaka, kau sibapo, wojo'oriata ya'ari'po, junama'a a' tekaka, intok juka' pattiriata, tetae ya'arita, junae a' pattak. ");
INSERT INTO yaqNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ju'u Maria, bwe'u jo'ara Maarena' tea'po jometaka, intok senu yoeme, Jose' teamta ae Maria' teame, juname'e a' bichak junum a' tekri'po. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Intok sabala taewata simsuka'po aet chukula, ju'u Maria, Maareena' tea'po joome, intok ju'u senu ju'ubwa yo'otume, Jakoobo' teamta maala, Maria' teame, intok Salome' teame, senu weemta, tu'isi win jubak jinuk, aman au toji betchi'bo, a' takaawabet a' to'o betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yokoriapo intok, lominko ta'apo, tu'isi ketwootana yeu sajaka, aman a' tekri'u bicha sajak, ju'ubwa ta'ata yeu weyeo. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Intok bo'ot kateka inen nau jiusakan: ―Jabesa tua, juka' bwe'u tetata, ae pattita, mekka itom biaktariane ―tim nau jiu sakan. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aman yajaka intok, juka' bwe'u tetata a' tekri'ipo, aet a' pattituka'uta, mekka biaktita teak. Bwe'ituk tu'isi bwe'uuriakan. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Junama'a a' tekri'ipo intok, ama kimuka, senu ju'ubwa yo'otumta, tossaalaim, ko'om tajti supekamta, junama'a batatana katekamta am bichak. Intok emo womtekamme. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Taa aapo ju'u ju'ubwa yo'otume intok: ―Kate'em emo wom womta ―ti ameu jiiak―. Ne ju'unea ―tiia―, juka' Jesus nasareenota, kuuset poponwakamta enchim a' jaiwa'po. Juna'a ala, inim a' tektuka'po ka aane. Bwe'ituk jiabijtesuk. Intok inim ka aane. Intok junum a' bo'osuka'po a' bicha'em, a' kaabe'po. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Taa aapo'ik a' teuwala'a benasia, i'an eme'e sajaka, a' majtim aman lutu'uriata makne. Intok juka' Peo' teamta, bwiara Kalilea' tea'po, ameas a' ane'epo aman. Junaman bem a' bitne' betchi'bo. Intok junuen bem a' ju'uneyyane' betchi'bo, am lutu'uria makne. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Juname'e intok, junama'a, a' bo'osuka'po, yeu sajaka, womtilamtaka, emo yoaka, intok tu'isi emo majjautuaka tennek. Intok kia bem womtilamtuka' betchi'bo, junaka'a junuen bem ju'uneyyaa'uta, kaabetau a' etejon. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Taa ju'u Jesus, lominko ta'apo, tua ketwootana, jiabijteka, Maria Maareena' teamtau bat au yeu machiak. Bat naataka intok junaka'a, jume' woo busan bebeje'eri ka tu'i jiapsi eerita a' jiapsipo a' jipu'usuka'um, pa'akun yeu beeprialatukan. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aapo ju'u Maria intok, bat naataka aamak rejtisuka'um, aapo'ik betana, emo jiapsi sioktuaka anemmeu, aman ameu yepsaka, am lutu'uria makak. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Juname'e intok, a' juchi jiapsa'po aman junuen a' jikkajaka, intok aapo'ik junuen a' bichak, tia'apo, katim a' suale. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Taa chukula, wasau bicha, woika katemmeu, ta'abwisi au ya'alataka, ameu au yeu machiak. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Juname'e intok, notteka, jume' wate aman lutu'uria makbaekai. Junuentak juni'i, juname'e ka sualwan. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Intok juchi'intok, aet chukula, jume' woj mamni ama wepu'ulaimmeu, jiji'ibwawa'po nau anemmeu, ameu au yeu machiak, ju'u Jesus. Intok kaita bem a suale'po betana, intok namakak bem jiapseka'a betana, junama'a witti ameu a' teuwan, jume'e, bat naataka junuen a' jiabijteka'po aman a' bichaka, intok bempo'immeu a' etejowaka'po, intok junuen ka bem a' sualeka'po betana, junama'a junuen ameu nookan. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Intok inen ameu jiiak: ―Si'ime bwiat na'ikim sajaka, inim bwiapo jiapsammeu, inika'a tu'i nokta, Liojta betana weyemta, ameu teuwane ―tiia―. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wa'a intok, enchim jikkajaka intok a' sualeka, au batoowatebokame, juna'a a' jiapsi jinne'utune. Taa wa'a ka'a sualekame, juna'a, jiba betchi'bo ka tu'uwata betuk tawane. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Intok inika'a machilaata amet ju'uneyyane, wame'e a' sualneeme. Bwe'ituk juname'e, bemelak, ka bem nokta nokaka, ta'abwik nokne. Intok neas lutu'uriaka, jume'e, bem jiapsimpo bebeje'eri ka tu'i jiapsi eeriakame, pa'akun yeu am bepriane. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Intok, senuk, kia aakamta a' ki'ilatuk juni'i, junaka'a kaachin autuane. Intok jita, junae a' muknee'ue, joyokamta je'eka'atek juni'i, kaachin aune. Intok ko'okoemtat mamaka, Liojtau bicha a' nokria'ateko, au a' inne'etetuane. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ju'u yo'owe Jesus intok, inika'a si'ime weemta ameu a' noksuko, teeka betana, jikau nuk cha'atuwak. Junaman mabetwaka, intok Liojta batatana yejtetuawak. ");
INSERT INTO yaqNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Juname'e intok, yeu sajaka, si'imekut, Liojta tu'i noki teuwa sasakan. Ju'u achai Lios intok jiba amemaktukan. Intok machilaata bem joa'utae, junaka'a, Liojta nok lutu'uriata tua a' lutu'uriaten. Tua junuentune.");
INSERT INTO yaqNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Juebenaka au ji'opla, juka' inim ito nasuk yeu sikamta si'imeta yuma'isi, tu'isi a' ji'ojtebaekai, ");
INSERT INTO yaqNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tua junama wa'am intok jume' a' wee taitek naateka a' bichakame, intok junak inika'a, Krijtota betana nok lutu'uriata tekiaka, yee majtakame, itom a' majtaka'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Inepo juni'i ket nee inika'a aet nee suaka, tua a' naatelaapo naateka nee ino a' majtai. Intok nee inika'a yuma'isi in eu a' ji'ojtenee'u, nee junuen a' tu'i machia, tua in naksi eiyaa'u Teopilo' teame. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Junuen, juka' lutu'uriata em majti, tu'isi intok yuma'isi em a' ta'aane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Junak juka' Eroorej teamta, bwiaraa Jurea' tea'po che'a a' yo'otuko, seenu, te'opopo tekiakame, Sakariaj teaka ama jiapsan. Ini'i, senu Abiaj teamtaim betana tekiakammak weyen. Ju'u inia jubiawa, Elisabet tean. Intok ini'i ket, ju'u che'a bat naataka, ju'u te'opopo tekiakammeu che'a yo'owe, Aaron teamta yoemrata betana yeu simriakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Inime'e nau, Liojta bichapo yuma'isi si'imeku tu'isi jiapsan. Intok Liojta betana juka' nesauri ji'ojteita, yuma'isi a' bo'o joorian. Junuen beja, kaabe jita ka tu'ik betana a amet nokakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Taa inime'e ka yoemiakan, bwe'ituk ju'u Elisabet teame ka a yoemian. Ketchia bempo nawit jaibu tua yo'otuimtukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Senu ta'apo, junak ju'u Sakariajta, aamak tekiakame, inime'e junuen, Liojta bichapo, jume' te'opopo tekiakame joa'uta bem a' ya'anee'uta ameu a' yumako, ");
INSERT INTO yaqNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","jume' te'opopo tekiakame nasuk, bem a' bo'o jooria'a benasia, junuen, ju'u Sakariaj teamtau yeu pu'awaka au yuumak, aapo'ik jum Liojta te'opopo wajiwa aneka, junama'a, kopaalim benak win jubak a' taya'ane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Junaka'a kopaalim benak win jubak ket a' taya'awaao, si'ime jume' ama aneme, pa'aku aneka Liojtau bicha nookan. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Junako, ju'u Sakariiaj teamtau, Liojta betana ankeles, junama'a junaka'a win jubak a' tattaawa'po, batatana weyeka au yeu machiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Juka' ankelejta bichakai, ju'u Sakariias, kaachin an machiakan. Intok tua majaen. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Taa ju'u ankeles iniau: ―Sakariias, kat emo majjaitua ―ti au jiiak―. Bwe'ituk ju'u Lios, aapo'iku bicha em emo nokriaka'uta a' ju'uneiyaala. Intok Elisabeet em juubi, o'outa yoemiane, junaka'a intok, empo Joan ti a' teatuane ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tua em allea'u intok Liojtau bicha em a' baisae'u et aune. Intok juebenaka inika'a yeu yoemtuko tua alleene. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bwe'ituk ju'u em yoemia, Liojta bichapo tua eiyaawaka bitnaa. Ini'i, pa'asi ba'awata intok juka' ba'ata yee nanaakoamta ka ji'ine. Intok Liojta tu'u jiapsi, kia kee yeu a' tomteo naatekai yuma'isi aet annee. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ini'i, jume' Ijra'el yoemrata betana, juebenam, bem achai Liojta, juchi am suale' betchi'bo am aniane. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ini'i Joan, itom yo'owata bepa weene. Intok ini'i, ju'u bat naatakai Liojta betana noktuawakame, Eliaj tuka'uta benaka, Liojta betana utte'ata aet aune. Junuen, jume' achaiwaim, bem yoemiammak am tu'ute betchi'bo. Intok jume'e, kaita yo'oreme, Liojta bem yo'ori ta'aane' betchi'bo. Ini'i inien, ju'u yoemratau noknee, junuen juka' itom yo'owata, tu'isi bem a' mabetne' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ju'u Sakariaj teame ju'u ankelejtau: ―Jaisa tua ne witti iniat ju'uneene ―ti au nattemaek―. Bwe'ituk jaibu nee tua yo'otui intok kia ju'u in jubi juni'i ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ju'u ankeles inika'a inen yoopnak: ―Inepo nee Jabiel tea. Intok inepo, Liojta betana juka' tekilta nee a' jooa. Jiba aapo junuen inia bemelak betana nee eu nokne' betchi'bo ne eu bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Taa i'an, juka' in eu teuwaaka'uta, ka em a' sualeka' betchi'bo, ka nokaka empo tawane. Intok empo ka a noknee, juka' em yoemiata yeu a' tomte'po tajtia. Ini'i, taewai au yeu a' pu'arit chupne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Intok junama'a, ju'u yoemra, pa'aku aneka, jiba juka' Sakariajta a' bo'o bichan. Intok inime'e ka ju'unee machiakan, aapo'ik junama'a te'opopo binwatuka, ka yeu a' weyeo. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pa'akun yeu sikaa, ju'u Sakariaj teame ka a ameu nookan. Junak bempo ju'une'eak, aapo'ik junama'a te'opopo wajiwa, Liojta betana jita a' bittuawaka'po. Intok ini'i maammea ameu nookan. Bwe'ituk ka nokaka tawalatukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Junak taewaim simsuko, Sakariaj teamta jum te'opopo a' joo'ea'uta ya'asuka, a' jo'au bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Iniat chukula ju'u a' jubiawa, Elisabet teame, juka' chukula yeu a' yoemianee'uta mabetak. Intok mamni mechammeu tajtia a' jo'a betana ka mekka bicha yeu siika, naas waateka: ");
INSERT INTO yaqNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ju'u in yo'owa Lios, inile benak nee bittuak, i'an junuen, watem ka intok jaana nee eiyaane' betchi'bo”, ti ean. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Busan meecham am weyeo, ju'u Lios senu ankeles, Jabiel teamta, bwiaraa Kalilea' tea'po, ili jo'ara Nasaret tea'u a' bittuak, ");
INSERT INTO yaqNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","junuen inika'a, senu jamut bemeta, Maria' teamtau a' noitine' betchi'bo. Ini'i beeme, seenuk, Jose' teamta a' kunanee'ut ju'uneaka jiapsan. Inika'a, ju'u bat naataka che'a yo'o ya'ari Labiituka'uta yoemiam betana yeu simriata. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ju'u ankeles, jum aapo'ik kateka'u au yepsak. Intok ini'i: ―Alleewame eu aune, empo, Liojta betana tu'ik bichame. Ju'u itom yo'owa Lios emak aane. Intok ju'u Lios, si'ime jaamuchim bepa tu'ik eu ya'ari ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Taa junak aapo, juka' ankelejta bichakai, kaachin an machika taawak inika'a au a' teuwaaka'u betana. Intok ju'uneepean, jitat tua, junuen jiaka a' noka'ut. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Junako ju'u ankeles: ―Maria, kat majjae. Bwe'ituk Lios enchi yeu pu'ari, junuen juka' kaitau a tamachiatuka tu'ik enchi bittua betchi'bo ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","I'an empo, chukula em yoemianee'uta mabetnee intok empo o'outa yoemianee intok inika'a empo Jesuj ti a' teatuane ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bwe'ituk ini'i, aapo tua eiyaanaa. Lios ju'u aman teekau jiapsaka, si'imem bepa yo'orisi machika, Liojta yoemia ti ta'eenaa. Ju'u achai Lios intok, ju'u che'a yo'o ya'atuka'u, Labiita, aapo'ik inika'a aet yeu simriatuka'uta benasia, che'a a' yo'o ya'ane. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Junuen, jiba betchi'bo, juka' Ijra'el yoemrata, aapo'ik am kuaktane' betchi'bo. Intok ju'u a' nesawee'u jakwoo juni'i ka lu'utineekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Junak ju'u Maria, ju'u ankelejtau: ―Jaisa tua ini'i yeu weene, inepo kaabe o'outamak katekai ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ju'u ankeles inika'a inen yoopnak: ―Liojta betana ju'u a' tu'u jiapsiwa junaet enchi aniane. Intok teekau che'a eiyaawatchika Liojta, ju'u a jita a' joa'u, ka bittaka, namuta benasi enchi roptane. Junuen san, ju'u o'ou, yeu tomtineeme, wepulsi Liojta betchi'bo jiba jiapsine. Intok ini'i, Liojta betana yoemiari ti ta'eenaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ketchia, wa'a em wawaai, Elisabet teame o'outa yoemiane, ini'i jaibu tua yo'otuitaka juni'i. Junuen san ju'u ka a yoemia' teame, i'an busan mecham po weye, bwe'uukai. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bwe'ituk Liojta betchi'bo, tua kaita aayuk, ka a' joa'u. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Junak ju'u Maria: ―Inepo, ju'u in yo'owa Liojta betchi'bo jiba ne jiapsa. Ela'po ju'u Lios junuen em neu jia'a benasi neu a' chupa'ane ―ti au jiiak. Junak ju'u ankeles siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Juname'e taewaimmet ju'u Maria, tua au bamijtuakai, ili jo'arau, bwiaraa Jurea' tea'u, kaupo kateka'u bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Intok junaman, ju'u Sakariaj teamta kariu yepsaka, tawabaeka aman kibakek. Intok juka' ama Elisabet teamtau tebotek. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Junak ju'u Elisabet, aapo'iku tebotewakamta, aapo'ik a' jikkajako, inia tompo ju'u uusi au yoyoak. Intok ju'u Elisabet junama'a lautipo, yuma'isi Liojta tu'u jiapsi aet aanek. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Junak aapo, tua kusisi nokaka: ―Ju'u Lios, che'a si'ime jaamuchim bepa, inim kaita ale benaka tu'ik eu ya'ari. Intok kia ju'u em yoemiabeu juni'i tu'ik ya'arialaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ka neu lutu'uriak junuen juka' in yo'owata ae a'abo sikaa, nee a' bitne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bwe'ituk kia juka' em teboteka'uta, nee a' jikkajak jiba, ju'u in asoa, alleerimmea in tompo au yoyoak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tua alleenee empo a' sualekame. Bwe'ituk junuen yeu yuma'ane, ju'u achai Liojta eu teuwaari ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Junako inen jiiak ju'u Maria: Tua ne junen jiaka, in yo'owa Liojta, alleaka a' bai sae. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Intok in jiapsi, juka' in yo'owata, ju'u nee jinne'uneemta betchi'bo tua allea. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bwe'ituk ju'u Lios, inika'a kaita'po che'a eiyaawaka ae betchi'bo jiapsamta, tu'ik a' ya'arialaa. Intok inim naateka ju'u yoemra jiapsame, tua alleewamta bichame ti ne tana a' teuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bwe'ituk Lios, ju'u si'imeku yumaka a jita joame, eiyaawatchika, tu'ik nee bittualaa. Wepulsi tu'uwata aet ayukame ti ta'eewa. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Aapo, si'imem wame'e a' yo'ori ta'aaka jiapsame, jiba am nak jiokoleka am bitne. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Eiyaawatchik bweresi weyemta ya'ari. Jume' emo che'ewareka jikat emo eiyaame, am koobak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jume' che'a yo'otaka jokaa, nesaweme, junaka'a am u'aak. Jume' intok, jita'apo juni'i, ka che'a eiyaawame, am yo'ori tebola. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jume' kaitae emo ania machim, tu'ik yu'in am bittuak. Jume' intok totomekame, kaitamak am tawaakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ae betchi'bo jiapsisukamta, Ijra'el tuka'uta betana juka' yoemrata, a' aniak. Aapo'ik a' nak jiokolinee'uta ka koptak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Inika'a a' chupne'eti jiaka, itom yo'owasuka'ummeu a' teuwaaka'po amani. Ju'u Apra'am tuka'utawi intok jume' aet yeu katriammeu bicha, junuen jiba betchi'bo tuneekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ju'u Maria intok, junama'a ju'u Elisabetta mak, baji metpo ama taawak. Intok chukula, juchi ini'i a' jo'au bicha nottek. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chukula intok yuumak ju'u taewai, juka' Elisabetta junuen aet a' yoemianee'u betchi'bo. Intok ini'i, ili o'outa asoak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jume' ae naapo jo'aakame, intok a' wawaim, a' uttiaka a' alleetuabaeka aman au yajak, achai Liojta junuen tua tu'ik a' ya'arialaa'uta ju'uneiyaatakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jume' woj naiki taewaim weyeo, waate, jume' juka' usita sirkunsiraaroaneeme aman yajak. Juname'e intok, Sakariahta, a' achaiwata team a' teatuabaen. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Taa ju'u a' malawa: ―E'e, ka junueni. Ini'i che'a, Joanim ti teane ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Intok inime'e: ―Jaisa betchi'bo, em wawaim betana, kaabe junuen teak ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Junak, ju'u usita achaibeu, inime'e maammea au nattemaek, junuen aapo'ik jachin a' teatuabae'po ju'uneebaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ju'u a' achaiwa, jita aet a' ji'ojtenee'uta a'awak intok: “Joanim ti teane”, ti ji'ojtek. Intok iniet si'ime suum eaka taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jiba junama lautipo ju'u Sakariaj teame juchi a nookak. Intok aapo, Liojtau bicha tua alleaka a' baisae'uta teuwaa taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Intok si'ime jume' ae naapo jo'aakame, tua suum eaka intok aet jachin eaka taawak. Intok junama Jurea bwiaraa' tea'po kawimmet, si'imekut jo'arammet, ju'u yeu sikame, naas etejowan. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Si'ime jume' inika'a ju'uneiyaa sakame, au waateka intok bempo naas nau nattemaen: ―Chukula, jitasatunee tua ini'i ili uusi ―ti jiakai. Bwe'ituk tua lutu'uriapo, ju'u achai Lios, si'imeku tu'ik a' bittuan. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ju'u a' achaiwa, Sakariaj teame, ju'u Liojta tu'u jiapsie yuma'isi aet aneka intok Liojta betana a' noktuawaka'uta teuwaaka inen jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","A' baisaeka a' yo'orinaa'u, Ijra'el yoemrata achai Liojtau aune. Bwe'ituk a'abo itou yebijlaa, aapo'ik betana yoemratawi intok itom jinne'ulaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Senuk, tua si'ime utte'aka, itom jinne'uneemta itom maki. Ju'u aapo'ik betchi'bo jiapsame, Labiituka'uta nat tomti yoemrata betana. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Junuen aapo'ik, juka' itou a' chupa'anee'uta a' teuwaaka'a benasia. Che'a bat naataka taewaimmet naateka, jume' wepulsi aapo'ik betchi'bo jiapsaka, chukula yeu weenemta teteuwaame am noktuakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Junuen aapo, wame'e itom beje'eka aneme betana, intok si'ime jume' itom omtame betana itom jinne'uka, ");
INSERT INTO yaqNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Intok aapo, jume' che'a bat naataka itom yo'owasuka'um nak jiokoleka intok aapo'ik betana juka' ameu bicha, bemela lutu'uriata a' teuwaari, aapo'ik ka a' koptanee'uta teuwaak. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ini'i juna'atuk, ju'u achai Liojta, tua a' chupa'ane'eti jiaka, ju'u itom yo'owa, Apra'amtuka'utau bicha a' teuwaaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Junuen aapo, wame'e itom beje'eka aneme betana, itom au jinne'une'eti jiakai, junuen, kaabeta majaeka, aapo'ik itom joo i'a'uta, itom joone' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Si'imemmak wepulsi lutu'uriakamta jiba bo'o jooriaka intok aapo'ik betchi'bo jiba jiapsakai, taewaim, inim itom jiapsa'u tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Empo intoko in yoemia, Lios, teekau jiapsamta betana weyeka chukula yeu weenemta teuwaame ti empo ta'eenaa. Bwe'ituk empo itom yo'owata bepat weyeka, ju'u yoemratau noknee. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Junuen juka' aapo'ik yeu pu'arik yoemrata ju'uneetua' betchi'bo, bem ka tu'uwa ya'arimmet am jiokoitune'po intok junuen a bem jinne'uitune'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bwe'ituk ju'u itom Lios, aapo'ik tua yee a' nakeka intok yee a' nak jiokole' betchi'bo, mekka jikat, teeka betana, bemela taewaita benaka itou a' bittuari. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Junuen jume' Liojta betana lutu'uriat ka ju'uneaka jiapsame, jume' ka tu'ik betchi'bo, kokko maisi jiokot emo bichammeu, tachiriata benaka, lutu'uriata ameu nu'upa betchi'bo. Intok junuen, iniae, yanti, ka jain eaka inim itom jiapsine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Intok ju'u ili uusi yo'otu simen. Intok ini'i, Liojta betana weyemtat suatu simen. Intok yo'otu chupuko, mekka, pa'akun kaabeta tua jo'aaka'po jo'aakan, junak taewai, chukula, ju'u Ijra'el yoemratau, aapo'ik au a' ta'aa tebok tajtia. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jiba juname'e taewaimmet, jum Romapo, ju'u che'a yo'o ya'ari Aukuujto' teame nesawek, junama'a yoemrata ju'uneiyaa betchi'bo, kaabeta be'eka a' ji'ojte tebok. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ini'i bat weyeka, ya'awak, juka' Sirineeo' teamta bwiaraa Siiria' tea'po a' kobanaaotuko. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Utte'atukan, si'imem, tua jak juni'i bem jomemtuka'u, bem katnee'po, junuen junaman emo ji'ojte tebo betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Inia betchi'bo san, ju'u Jose, bwiaraa Kalilea' tea'po, ili jo'araa Nasaret tea'a betana yeu sikaa, intok Jurea' tea'u, ili jo'ara Beleem tea'u bicha yeu siika, Labiituka'uta yeu tomteka'u. Bwe'ituk ju'u Jose, Labiituka'uta nat tomti yoemrata betana weyen. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ini'i ili jo'ara Beleem tea'u siika, Maria' teamtamake, inim au ji'ojte tebobaekai, ju'u chukula tua a' kunanemtamake. Intok ini'i Maria jaibu abe yoemiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Intok inime'e ket junama'a Beleem tea'po am aneo su, yuumak, ju'u taewai, juka' Mariata aet a' yoemianee'u betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Junama'a aapo juka' ke'esam o'outa asoak. Intok chukula, tosampo a' biijtaka, jum bepaaka, jume' naikim wokekame jaja'abwee'po, jita'apo a' teekak. Bwe'ituk junama'a bwe'u karipo jakun tawa betchi'bo, ame betchi'bo kaita tukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Junama ili jo'ara Beleem tea'u ka mekka, waate, bwaram suareeom, juyapo, tukaapo toto'een, bem bwaram suuakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Junama lautipo, Liojta betana, ankeles ameu yeu machiak, intok Liojta betana ujyoika tachiria amet konila taobiakan. Intok inime'e tua majjaen. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Taa ju'u ankeles: ―Ka eme'e majjaune ―ti ameu jiiak―. Bwe'ituk, nokta bemelaka tu'ik ne emou weiyaa. Ini'i, si'imem betchi'bo tua ae alleewame tuneekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","I'an jum jo'ara, ju'u Labiituka'uta yoemtuka'po, juka' enchim jinne'uneemta yeu a' tomteka'uta, ini'i, Krijto ju'u itom yo'owa. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Intok enchim aet ju'uneene' betchi'bo, eme'e juka' ili usita tajo'orimpo biijtitaka, jum bepaaka, jume' naikim wokekame jaja'abwe'po, bo'okamta eme'e a' teune. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Junama lautipo, junae ankelejtamak, juebenaka waate, teekau ankelesim yeu machiak. Inime'e nanawit nokaka Liojta yo'oren intok inen jiian: ");
INSERT INTO yaqNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Teekau, Liojta alleaka a' yo'orinaa'u au aune. Intok inim bwiapo jiapsame nasuk, aapo'ik tua tu'ik ya'ari a' bichammeu, si'imeku, yanti, ka jain eewame aune, ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Junako, chukula jume' ankelesim juchi teekau bicha am notteko, jume' bwaram suuame, naas inen nau jiu japtek: ―Jantebu ma jum jo'ara Beleem tea'u bicha te katnee inika'a yeu sikamta a' bit betchi'bo, intok juka' achai Liojta itom ju'uneiyaatuari ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Inime'e, lauti tenneka intok Mariatau intok Joseetau intok ju'u ili usitau, junama'a, bepaaka, naikim wokekame jaja'abwee'po ama bo'okamtau yajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Junak inime'e, inika'a bichaka, ju'u ili usitat nokaka, juka' ankelejta ameu teuwaaka'uta a' etejok. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Intok si'ime jume'e, inime'e teuwaa'uta jikkajakame, ju'u bem teuwaa'u betana kaachin jiu machika taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Taa ju'u Maria, inika'a si'imeta au teuwaawaka'uta, ka a' koptaka, aet jiapseka jiba au waaten. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jume' bwaram suuame, bempo, si'imeta juka' bem jikkajaka intok bem bichaka'u betchi'bo, tua Liojta yo'oreka intok bem allea'uta au bicha teuwaaka, nottek. Bwe'ituk si'imeta, tua ameu a' teuwaawaka'po aman, yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Woj naiki taewaim weyeka, sirkunsiraaroawak ju'u ili uusi. Intok ini'i Jesuj ti teatuawak, jiba jume' team juka' ankelejta bat naataka Mariata, chukula a' yoemianee'uta kee a' mabetao, junak a' tejwaaka'um. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jume' taewaim, Liojta bichapo bem emo tu'utenee'um yumako, inika'a, Moiseejtuka'uta nesauri ji'ojtei junuen a' teuwa'a benasia, bempo juka' ili usita, bwe'u jo'ara Jerusalen tea'u a' nuk sajak, junaman inika'a, wepulsi Liojta betchi'bo jiba a' jiapsine' betchi'bo, au bicha a' nokriakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bempo, inien aayuk, bwe'ituk jum Liojta betana jume' nesaurimpo: “Si'ime wa'a ke'esam o'ou yeu tomtekame, ini'i, wepulsi Liojta betchi'bo jiba a' jiapsine' betchi'bo, Liojtau su'u tojituka, au bicha nokrianaa”, ti ji'ojtei. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Inime'e junaman sajak junuen Liojta nesauripo a' ji'ojteituka'a benasi, jume' woi kuukum oo jume' wooi ommo'okolim, Liojta yo'oreka am su'a betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Juname'e taewaimmet intok, senu Simeeon teaka, Jerusalen tea'po jiapsan. Ini'i tua tu'i yoemtukan, Liojta yo'ori ta'aakai intok juka' Ijra'el yoemrata aniaka a' jinne'uneemta, a' yebijnee'uta bo'o bichan. Ju'u Liojta tu'u jiapsi inika'a Simeeon teamta aniaka aamaktukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Intok a' ju'uneetualatukan, juka' Krijtota, achai Liojta a'abo bittuanee'ut, kee a' bichaka, ka a' muknee'uta. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ini'i yoeme, te'opou siika, Liojta tu'u jiapsie aman a' weene'po ju'uneetuawakai. Intok junak jume' ili uusi Jesujta yo'owam, inika'a, te'opou a' nu'upako, junuen juka' nesauri ji'ojteita a' teuwaa'po aman au a' chup i'akai, ");
INSERT INTO yaqNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ju'u Simeeon, inika'a, mampo nu'uka intok a' allea'uta, achai Liojtau bicha a' teuwaak: ");
INSERT INTO yaqNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Achai Lios, i'an ala empo jaibu tua kaachin eaka, in muknee'uta a neu chupa. Bwe'ituk, inia ee betchi'bo jiapsamtau, em chupne'eti jiaka teuwaarita, empo a' chupa'i. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","In pusimmea nee a' bitlaa juka' yee jinne'unemta. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","I'an, si'ime yoemratau em yeu machiari. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ini'i, aapo juna'a, ju'u si'ime jume'e, ka Ijra'elta yoemratau, tachiriata benasi machika, juka' ee betana lutu'uriata ameu a' teuwaaneeme. Intok ju'u, ee betana, juka' Ijra'el yoemrata a' yo'ori teboneeme, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josee intok ju'u Jesujta ae, ili usita betana juka' Simeeon teamta teuwaaka'uta jikkajakai, alleaka, aet suum eaka taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Junak ju'u Simeeon teame, Liojtau bicha, tu'ik am a'auriak. Intok ju'u Maria, Jesujta aebeu inen jiiak: ―A' ju'uneiyaane, ini'i ili uusi, Ijra'el yoemrata nasuk juebenam, Liojta bichapo tu'isi oo ka tu'isi bem tawanee'uta, am bittua betchi'bo au na'ikiari. Aapo'ikut Liojta betana weyeme yeu machine, iniat juebenam ka a' mabetnee'ut, ");
INSERT INTO yaqNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","intok junuen ju'uneiyaanaa, we'epulaim, ju'u jachin bem ea'u. Taa si'ime ini'i ee betchi'bo jiokot emo bitwame tune, kia jume' tebe kuchi'im naa buusti et am kikteka'a benasi ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Senu jamut Liojta betana ju'uneetuawaka nokame ket ama aanen. Ini'i Aana'ati teakai. Aseer tuka'uta nat tomti yoemratat yeu simriataka. Senu Panu'el teamta a' marakan. Ini'i jaibu tua yo'otui tukan. Aapo tua bemetaka kunalatukan, intok woo busan wasuktiapo a' kunamak jiapsilatukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Intok i'an ini'i jokoptuitukan, naiki taka ama naiki wasuktekai. Ini'i, jiba jum te'opopo a' annee'ut ka koptan. Ala, achai Liojta a' joo i'a'uta joakai, jamak ka ji'ibwaka, Liojta yo'orekai intok au bicha nokakai tukaariat naa buustia. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ini'i Aana, jiba junama lautipo ama ameu ruktek. Intok chukula, Liojta a' baisae'uta au a' teuwaasukai, junama'a, si'ime jume' Jerusalen tea'po jo'aaka am jinne'utunee'uta a' bitbaemmeu, ili usi Jesujta betana ameu nok taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Junak chukula, si'imeta juka' achai Liojta nesauri ji'ojteita ya'asukai, bempo jum bwiaraa Kalilea' tea'po, tua bem jo'aaka'u, Nasaret tea'u bicha nottek. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ju'u ili uusi intok, yo'otu simeka, che'a juni'i taka utte'itun. Intok che'a juni'i koba suawakan. Ju'u Lios intok, si'imeku tu'ik yu'in a' bittuan. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jume' a' yo'owaawam, chikti wasuktiapo, bwe'u jo'ara Jerusalen tea'u yaajan. Junuen junaman, Liojta yo'ori betchi'bo, bwalam su'awaka pajkoa' teamta a' bit betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesujta woj mamni ama wooi wasuktiam a' yuma'ariako, junak si'ime, jum bwe'u jo'ara Jerusalen tea'u bicha sajak, jaibu junuen aman pajkotuko a' joowa'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Junak, juka' pajkota a' chupsuka intok bempo'im notteo, ju'u uusi Jesus, ini'i junama'a bwe'u jo'ara Jerusalen tea'po taawak, a' aewa intok kia ju'u Josee juni'i, bempo ka ju'uneakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Inime'e, Jesujta, si'ime jume' am bicha bo'o joammak a' weye'eti eaka intok junuen si'ime taewata bo'o joaka kuptek. Taa junak, jume' bem wawaim nasuku intok bem ta'aa'um nasuku a' jaiwaka ");
INSERT INTO yaqNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ka a' teak. Junak bempo, Jerusalen tea'u bicha nottek, junaman a' jariubaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Baji taewaita sikaa, te'opopo a' teak. Jume' Moiseejta nesaurim yee majtame nasuk kateka am jikkajaka intok ameu nattemaemta a' teak. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Intok si'ime inime'e a' jikkajakame, tua a' suawaka'u betana intok aapo'ik jachin am yoopnaka a' teuwaaka'u betana a' uttiaka a' suum eiyaak. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jume' a' yo'owawam junama'a a' bichakai, kaachin ee machika, kia a' bitchuka taawak. A' aewa intok inen au jiiak: ―Uusi, jaisaaka empo inien itom yaak. Ju'u em yo'owa intok inepo, tua te jachin eaka tee enchi jariusuk ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Junak ju'u Jesus: ―Jaisaaka intok eme'e nee jaiwan. Jaisa eme'e ka ju'unea ja'ani, inim in yo'owata nee a' joo i'a'uta, in joo'ea'u ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Taa bempo, aapo'ik ameu a' teuwaaka'ut, tua ka aet ju'uneak. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Intok junak aapo jo'ara Nasaret tea'u bicha amemak nottek. Intok juchi jiba junaen, bempo'im nok jikkajakai. Ju'u a' aewa si'imeta inika'a, aapo ka a' koptaka, jiba au waaten. ");
INSERT INTO yaqNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Intok Jesujta junuen su, che'ewasu koba suawaka intok a' yo'otu simeo intok Lios, intok kia ju'u yoemra juni'i, si'imeku ae allean. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Junakriapo juka' Tibeerio' teamta junama che'a si'imem bepa yo'o nesawekai, woj mamni ama mamni wasuktiam a' weiyaao, ju'u Ponsio Pilaato' teame bwiaraa Jurea' tea'po kobanaao tukan. Ju'u Eroorej teame intok bwiaraa Kalilea' tea'po kobanaao tukan. Ju'u a' sailaawa Jeriipe' teame intok, bwiaraa Iturea' tea'po intok Trakooniitij tea'po kobanaao tukan. Ju'u Lisaniaj teame, bwiaraa Abileenia' tea'po kobanao tukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ju'u Anaas intok ju'u Kaipaaj teame, inime'e, jume' te'opopo tekiakammeu che'a yo'otukan. Juname'e taewaimmet ju'u Lios, ju'u Joantau, Sakariiaj teamta u'usibeu, aman mekka pa'akun a' jiapsa'u, au nookak. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Intok ini'i Joan, ju'u batwee Joran tea'u jeela, si'ime ili jo'arammet siika. Junama yoemratau a' utte'ati jiian, ka tu'ik betana ta'abwisi eaka intok bem bato'owaatune'po junuen ju'u ka tu'ik bem ya'ari betana amet am jiokoitune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ini'i junuen yeu siika, jiba juka' Liojta betana ju'uneetuawaka, chukula yeu weenemta teuwaakame, Isa'iajtuka'uta a' teuwaari benasia: Mekka bweka pa'aku, senuk chaaemta a' jiawai jikkajiwa: “Itom yo'owata a' mabet betchi'bo, eme'e, ka tu'ik betana emo tu'utene”, ti jiakai. “Intok inika'a, tu'isi emou yepsaka, enchim a' mabetne' betchi'bo, tu'ik eme'e ya'arine. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Si'ime jume' ka emo jabeleme, tu'ik ameu be'eemta a' ju'uneiyaame, bempo yuma'isi a' mabetne. Si'ime jume' emo che'ewareka intok emo eiyaame, inime'e ko'om tojinaa. Jume'e, juka' ka tu'ika, ka amma'ali weyemta tekipanoame, inime'e chukula tu'ik lutu'uriata bo'o jooriane. Jume' intoko, juka' Liojta betana nok lutu'uriata ka tu'isi yee a' majtame, inime'e ka nappat junuen a' bo'o jooriane”, ti a' jiaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","“Intok junuen, si'ime wa'a inim yoemra, Liojta jachin yee a' jinne'unee'uta a' bitne”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Junak juka' yoemrata junuen Joanta am bato'owane' betchi'bo aman au bicha yeu am kateo, aapo: ―Ka tu'i yoemra, bakotchim bebena ―ti ameu jiiak―. Eme'e ka ju'u enchim bato'owaimtunee'ue, tua ka tu'ika jiokot emo bitnaamta abe a'abo yuma'u betana, junae enchim ama yo'eene'eti eene. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","E'e, ala eme'e ka tu'ik betana ta'abwisi enchim ea'uta ju'unakkiachisi emot a' bitna' betchi'bo, tu'isi jiapsine. Intok ka eme'e, ju'u Apra'amtuka'uta nat tomti yoemrata betana emo kate'eti jiubaane. Bwe'ituk ju'u achai Lios, kia inime'e tetammea juni'i, Apra'amta betchi'bo jume' ae betana emo yeu katriam ti jiame a am ju'unakte. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Liojta betana tua jiokot machika enchim bitnee'uta kaita be'ee. Juka' juya, taka'eaka, ka tu'ik tatakamta tepwammea chuktawaka, tajipo a' taya'atune'e benasia ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Junako jume' ama aneme: ―Junak su, jaisa tua itepo auneekai ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ju'u Joan inime'e inen yoopnak: ―Wa'a, wooim supekame, ini'i, juka' wepulaim juni'i ka supekamta, wepulaim a' mikpo yuma'i. Ju'u intoko bwa'awamta jipueme, ini'i jiba junaen, ju'u kaita jipuemtau bicha watek na'ikiane ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ketchia jume' ya'uraatau bichaa tomita weyemta nau totojame, waate, Joantau emo bato'owaabaeka aman yajaka intok Joantau: ―Yee majtame, itepo su jaisa te auneekai ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ju'u Joan intok inimmeu: ―Ya'uraata betana nesau ji'ojteipo, tomita enchim yeteu a' a'au'ea'uta jiba, ka junae bepa a' a'aune ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ketchia sontaaom waate: ―Itepo su, jaisa tua te auneekai ―ti au nattemaek. Aapo inime'e inen yoopnak: ―Kaabeta eme'e jita u'aanee jita betchi'bo am majau tetejwaakai. Intok kia ju'u ka bem ya'arit juni'i, ka am nana'atejokai. Intok eme'e, enchim beje'etuawa'ue, yanti elne. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ju'u yoemra baa ju'uneepeaka bo'o bichan. Jumak juni'i ju'u Joan juna'a ju'u Krijto' teame ti eakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Taa ju'u Joan si'imemmeu inen jiiak: ―Inepo ala, lutu'uriapo nee ba'ammea enchim bato'owaa. Taa senu yebijne, juna'a, aapo si'imeku Lios eerie a' tu'u jiapsita emot jiapsituaka, ae enchim bato'owaane. Aapo nee bepa yo'o'utte'aka jikkajiwa. Junuen san, kanne ino jabele, kia a' bochawam in a' woitariane'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aapo jaibu inim, senuk tiikota tu'ute betchi'bo, ae am wij wijtawamta mampo a' jipue'e benasi maachi, junuen jume' a' yoemiam omola a' jipu'ubae'po am tawaane. Intok jume' ka a' yoemiam, omot, taji beeteu jiokot bem emo bitnee'u bicha am tawaane. Juka' bachiata toboktaka intok juka' otata tokti a' tayaka'abenakai ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Inile benakue intok watek juebenak tu'ikue am nok tejwaaka ju'u Joan junuen juka' bemela nok lutu'uriata ju'u yoemratau a' teuwaan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ketchia ini'i, juka' kobanaaota, Eroorej teamta a' sua tejwaak, inika'a a' sailawaa, Jeriipe' teamta juubi, Erooriaj teamta jubi'ulatukan. Intok ket juka' watek ka tu'ik a' yaaka'u betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Taa ju'u Eroorej teame, inika'a nok jikkaji'eaka su, ketuni juchi ka tu'ik yaak, juka' Joanta a' eta'atebokai. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Inika'a kee yeu weyeo, junak juka' Joanta si'ime junama yoemrata a' bato'owaao, ju'u Jesus ket bato'owaatuk. Aapo'ik intok ketuni Liojtau bicha a' nokao su, teekau machilaa bittuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Intok juna'abo ju'u Liojta tu'u jiapsi, ju'unakkiachisi, wokkoita benasi Jesujtat ko'om siika. Teeka betana intok jiawai: ―Empo juna'a ju'u in yoemia tua in nake'u, ee betchi'bo nee tua allea ―ti jiaka jikkajituk. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ju'u Jesus inim jumak senu taka ama woj mamni wasukten junak juka' yoemrata mak a' tekilwata naatekai. Ini'i, watem junuen a' suale'po aman, ju'u Jose' teaka a' u'usek tean. Ju'u Josee intok, senuk Eli'iti teaka a' u'usekan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ini'i intok ket, Matat teaka a' yoemiakan. Ini'i intok ket, Lebi' teaka a' yoemiakan. Ini'i ket, Melki' teamta betana yoemiaritukan. Ini'i ket Jana' teaka a' yoemiakan. Ini'i ket, Jose' teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ini'i ket Matatiaj teamta betana yoemiaritukan. Ini'i ket Amoj teaka a' yoemiakan. Ini'i ket Na'um teamta betana yoemiaritukan, ini'i ket Esli' teamta betana yoemiaritukan, ini'i ket Nakkai' teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ini'i ket Ma'at teamta betana yoemiaritukan, ini'i ket Matatiaj teaka a' yoemiakan. Ini'i ket Semei' teaka a' yoemiakan, ini'i ket Jose' teamta betana yoemiaritukan. Ini'i ket Jura' teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ini'i ket Joana' teamta betana yoemiaritukan. Ini'i ket Resa' teaka a' yoemiakan, ini'i ket Sorobabel teaka a' yoemiakan. Ini'i ket Salati'el teaka a' yoemiakan, ini'i ket Neri' teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ini'i ket Melki'i teamta betana yoemiaritukan. Ini'i ket Ari'iteaka a' yoemiakan, ini'i ket Koosam teaka a' yoemiakan, ini'i ket Elmoram teaka a' yoemiakan, ini'i ket Er teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ini'i ket Josue' teamta betana yoemiaritukan. Ini'i ket Elieser teaka a' yoemiakan, ini'i ket Jorim teaka a' yoemiakan, ini'i ket Matat teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ini'i ket Lebi' teamta betana yoemiaritukan, ini'i ket Simeon teaka a' yoemiakan, ini'i ket Jura' teaka a' yoemiakan, ini'i ket Jose' teaka a' yoemiakan, ini'i ket Jonan teaka a' yoemiakan, ini'i ket Eliakim teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ini'i ket Melea' teamta betana yoemiaritukan. Ini'i ket Mainan teaka a' yoemiakan, ini'i ket Matata' teaka a' yoemiakan, ini'i ket Natan teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ini'i ket Labii' teaka a' yoemiakan. Ini'i ket Issai' teamta betana yoemiaritukan. Ini'i ket Obel teaka a' yoemiakan, ini'i ket Booj teaka a' yoemiakan, ini'i ket Salmon teaka a' yoemiakan, ini'i ket Na'ason teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ini'i ket Aminarap teamta betana yoemiaritukan. Ini'i ket Aram teaka a' yoemiakan, ini'i ket Ejrom teaka a' yoemiakan, ini'i ket Paarej teaka a' yoemiakan, ini'i ket Jura' teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ini'i ket Jakoop teamta betana yoemiaritukan, ini'i ket Isaak teaka a' yoemiakan, ini'i ket Apra'am teaka a' yoemiakan, ini'i ket Tare' teaka a' yoemiakan, ini'i ket Nakor teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ini'i ket Seruk teaka a' yoemiakan, ini'i ket Rakau' teaka a' yoemiakan, ini'i ket Pelek teaka a' yoemiakan, ini'i ket Eber teaka a' yoemiakan, ini'i ket Sala' teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ini'i ket Kainan teamta betana yoemiaritukan, ini'i ket Arpaksat teaka a' yoemiakan. Ini'i ket Sem teaka a' yoemiakan, ini'i ket Noe' teaka a' yoemiakan, ini'i ket Lamek teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ini'i ket Matusalem teamta betana yoemiaritukan, ini'i ket Enok teaka a' yoemiakan, ini'i ket Jaret teaka a' yoemiakan, ini'i ket Majalale'el teaka a' yoemiakan, ini'i ket Kainan teaka a' yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ini'i ket Enoj teamta betana yoemiaritukan, ini'i ket Set teaka a' yoemiakan, ini'i ket Adam tuka'uta betana yoemiaritukan. Ini'i ket, Liojta betana yoemiaritukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ju'u Jesus, yuma'isi Liojta tu'u jiapsi aet anekai, jum batwee Joran tea'a betana nottek. Intok ju'u Liojta tu'u jiapsie ju'uneetuawaka, mekka pa'ariau, kaabeta ane'ebe'emu bichaa siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Junaman, woi taka taewaimmeu tajtia ama aanek. Ju'u intok bebeje'eri jitat a' ji'optuabaek. Si'ime juname taewaimmet aapo ka ji'ibwaka, intok chukula tebaurek. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Junak intok ju'u bebeje'eri: ―Empo lutu'uriapo Liojta yoemiatuko, inika'a tetata paan ya'ane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus inika'a inen yoopnak: ―Jum Liojta nok lutu'uriapo: “Ju'u inim yoeme, ka bwa'amtae jiba jiapsine. Ala ketchia ini'i, si'ime ju'u Liojta betana nok lutu'uriae”, ti ji'ojtei ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chukula ket ju'u bebeje'eri, mekka jikau kawiu a' nuk siika. Intok chubalapo su ini'i, si'ime aniat juka' ka nanau machi yoemrata jokame a' tejwaak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Intok ini'i bebeje'eri: ―Inepo si'imeta inia aniat yoemrata betana nesawamta intok ujyoriata enchinee a' makne. Bwe'ituk si'imeta inika'a ineponee a' mabetri. Intok inepo juka' in a' makbae'uta nee a' maknee ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Enchi tonommea weeka, nee enchi yo'oreo, si'ime ini'i eu lutu'uriatune ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Taa Jesus: ―Kat neu suua, mekka bicha weene. Bwe'ituk Liojta nok lutu'uriapo: “Em yo'owa Liojta jiba a' yo'orine, intok aapo'ik jiba a' joo i'a'uta joone”, ti ji'ojtei. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chukula intok ju'u bebeje'eri, bwe'u jo'ara Jerusalen tea'u a' nu'upak. Intok junama'a bwe'u te'opopo jikat a' tojaka intok inen au jiiak: ―Lutu'uriapo empo Liojta yoemiatuko, inim ko'om bicha emo jimmaa, ");
INSERT INTO yaqNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","bwe'ituk Liojta nok lutu'uriapo inen ji'ojtei: Ju'u Lios, jume' a' ankelesim, enchi am suuane' betchi'bo, amet nesaune. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Inime'e bem mampo enchi toboktane, junuen jita tetat juni'i, ka em wokim ko'okosi aune' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ju'u Jesus iniau: ―Ketchia, Liojta nok lutu'uriapo inen ji'ojtei: “Juka' Liojta em yo'owata empo ka a' ji'obilabaane” ―ti jiaka a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Intok junuen ju'u bebeje'eri, Jesujta ji'optua betchi'bo kaita intok teakai, junak aapo'ik ili binwa a' su'u tojak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ju'u Jesus, bwiaraa Kalilea' tea'u juchi nottek, tua yuma'isi Liojta tu'u jiapsi aet aneka, si'imeta a joakai. Intok junama'a si'ime bwiaraat yeu tajti aapo etejowan. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Junama'a si'imekut, jum juriom emo nau totoja'po, yee majtan. Intok si'ime, a' teuwaa'ut a' tu'ureka a' uttian. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Junak intok ju'u Jesus, ili jo'ara Nasareet tea'u bicha jum aapo'ik yo'otuka'po siika. Sabalat, aet yum jo'e ta'apo aapo jum juriom nau emo totoja'po yepsak, aapo'ik jiba a' bo'o jooria'po amani. Intok junama'a, Liojta nok lutu'uriata nokbaeka kiktek. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ju'u Isa'iaj tuka'uta, Liojta betana ju'uneetuawakamta ji'ojteka'uta aapo'iku bwijwak. Juname'e intok etapokai, inen ji'ojteita ama teak: ");
INSERT INTO yaqNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Achai Liojta betana ju'u tu'u jiapsi, nemaktuka nee ania. Bwe'ituk aapo, wepulsi iniau nee yeu pu'ari junuen, jume' kaitae emo ania machimmeu, bemelaka, tu'ik betana in ameu nokne' betchi'bo. Jume' tua siok kokkome, am jiapsi jo'a betchi'bo nee ameu bittuari. Jume'e, bebeje'erita betana eta'im benasi emo bichame, bem su'u tojitunee'uta ameu teuwaa betchi'bo. Intok jume' ka bibichame benasi tawalame, bittua betchi'bo. Intok wame'e, watem betana ka tu'ik bittuawame, juname betana bem anianaa'uta. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Junuen, i'an, tu'isi weyeka achai Liojta yee aet a' jiokoinee'uta juka' taewaita a' teuwaa betchi'bo, ti a' ji'ojteituka'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Junak ju'u Jesus, juname'e ji'ojteim etaka, ju'u junama'a tekiakamtau am bwiseka, yejtek. Taa si'ime jume' ama aneme jiba a' bitchuka tawako, ");
INSERT INTO yaqNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","aapo nok taiteka intok: ―I'an inimi'i lautipo emo bichapo yeu yuma'alaa ju'u inim, Liojta nok lutu'uriapo ji'ojtei ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Si'ime, Jesujta betana tu'ik teuwaan. Intok inime'e, aapo'ik tua ujyoisi ameu a' noka'u betchi'bo a' uttiaka suum eiyaan. Intok inime'e: ―Jaisa ka ini'i juna'a ja'ani, ju'u Josee' teamta u'usi ―ti nau nattemaen. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ju'u Jesus inimmeu: ―Witti jiba tua eme'e, a inen yetet nokwa'a benasi, inen neu jiubaanee: “Empo emo jittone, jitebitakai.” Iniae: “Bwe'u jo'ara Kapernaom tea'po em yaaka itom jikkajaka'uta, ket inim tua em bwiaraapo a' ya'ane”, ti jiubaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Junak aapo naa buusti ameu nokaka intok: ―Lutu'uriapo inen ne emou jiia, Liojta betana ju'uneetuawaka nokame, kaabe ju'u tua a' bwiaraapo tu'isi mabettuneeme ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Inika'a nee a' lutu'uriatukan ti jiia. Junako Ijra'el yoemrata nasuk, ju'u Liojta betana yeteu noktuawakamta Eliaj tuka'uta a' jiapsao, jaamut jokoptuim am bu'uusuka'u junak, baji wasuktia ama busan metpo ka yukuka intok si'ime junama'a bwiaarat tua tebaatuko. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Taa ju'u Eliaj teame, kaabe jume' Ijra'el yoemrata nasuk jokoptuim jo'aakammeu bittuawak. Ala senu jokoptui, jo'ara Sarepta' tea'po, bwe'u jo'ara Siroon tea'u ka mekka jo'aakamtau bittuawakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ketchia, jum Ijra'el yoemrata nasuk, ju'u Liojta betana yeteu noktuawame, Eliseo' teamta a' jiapsao, jume' takaapo sa'awaka, lepra' teamtae ko'okoeme juebenaekan. Taa juname nasuk kaabe au ine'etetuawak. Ala seenu, omot bwiaraa Siiria' tea'po jometaka, Naaman teakai jiba ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Inika'a teuwaawakamta jikkajakai, si'ime jume' junama'a juriom nau emo totoja'po ane'um, inime'e tua o'omtek. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Inime'e intok, Jesujta junama'a ili bwe'u jo'arapo pa'akun yeu a' tojaka intok junama'a kaupo, junaka'a jo'araata aet kateka'ut tua bepa jikau a' tojak. Juna'abo bepa, ko'om a' jimmaabaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Taa Jesus, inimmet yeu sika intok junama yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Junak intok Jesus, bwe'u jo'ara Kapernaom tea'u, bwiaraa Kalilea' tea'u bicha siika. Junama'a intok sabalat, aet yum jo'e ta'apo yoemrata a' majta taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Inime'e intok, aapo'ik am majta'u betana tua a' suum eiyaan. Bwe'ituk aapo, a' teuwaa'u, bat weyeka tua lutu'uriata ameu nookan. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Junama'a juriom nau emo totoja'po, seenu, bebeje'eri ka tu'u jiapsi aet aneka ama aanen. Ini'i intok kusisi inen chachaekai: ");
INSERT INTO yaqNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Kat itou suua. Jaisaaka empo a'abo itou yepsak Jesus, jo'ara Nasaret tea'po joome. Jaisa empo a'abo itom jiokot tawaasek ja'ani. Enchi ne ta'aa intok ne ju'unea, Liojta betana yoemiaritaka ae betchi'bo jiba em jiapsa'u ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus, sep ju'u bebeje'eri ka tu'u jiapsitau kuttipo nonokak: ―Ka monteka, inika'a yoemta a' su'u tojine ―ti jiakai. Junako ju'u bebeje'eri ka tu'u jiapsi, junaka'a, juname bichapo, bwiau a' tatabek. Taa inika'a tua kaachin a' yaaka, a' su'u tojak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Si'ime a' uttiaka a' suum eaka taawak. Inime'e intok: ―Ini'i, a' teuwaa'u ka kia beja nooki. Ala ini'i tua nesaweka intok tua utte'akamta, jume' bebeje'eri ka tu'u jiapsimmeu nooka. Intok inime'e yeu rejte ―ti naas nau jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Intok junama'a bwiaraapo si'imekut, ini'i junuen ae betana etejowan. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Junak ju'u Jesus junama'a juriom nau emo totoja'po yeu sika intok Simo' teamta jo'au kibakek. Ju'u, Simo' teamta jamut ase'ebwa tua taji wecheka ko'okoen. Ini'i intok Jesujtau nokriawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Inika'a bo'oka'u ju'u Jesus rukteka intok au ko'om po'okteka, taji wechiata a' su'u tojine' betchi'bo nesawek. Ini'i intok sep a' su'u tojak. Junama'a sep aapo yejteka intok jita am jooria taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Junama'a ta'ata aman wetsuko, sep si'ime jume'e, ka nanau machik ko'okoaka, ko'okoiriawame, inime'e ju'u Jesujtau am tojak. Intok aapo inime'e, we'epulaimmet mamteka intok emo am ine'etetuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Juebena ko'okoeme betana ket jume' bebeje'eri ka tu'u jiapsim yeu sajak. Inime'e intok chaaeka: ―Empo juna'a ju'u Liojta yoemia ―ti jiian. Taa ju'u Jesus, jume' bebeje'eri ka tu'u jiapsimmeu kuttipo ameu nonokaka intok kaita am noktuak. Bwe'ituk inime'e, aapo'ik junen Krijtotuka'po ju'unean. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yokoriapo matchuu, ju'u Jesus junama'a bwe'u jo'arapo pa'akun bicha, kaabeta ane'u yeu siika. Taa ju'u yoemra a' jaiwaka intok junama aapo'ik ane'u au yajak. Bempo aapo'ik ama a' tawaa i'aka ka a' simne' betchi'bo au nookan. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Taa ju'u Jesus inimmeu inen jiiak: ―Utte'a, bemelaka, Liojta che'a yo'otaka a' kateka'u betana juka' tu'i nok lutu'uriata, waate jume' ili jo'arammeu ket in a' teuwaane'po. Bwe'ituk jiba inia betchi'bo inepo a'abo bittuari. ");
INSERT INTO yaqNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Intok junuen ju'u Jesus, junama'a bwiaraa Kalilea' tea'po, jum juriom emo nau totoja'po te'opommet yee majtan. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sejtul ju'u Jesus, bwe'u bau ba'a Jenesaret tea'po inim mayoat aanen. Junama intok ju'u yoemra juebenaka nau yajaka inime'e kia ama nau a' pit pittan bwe'ituk inime'esu, Liojta betana nok lutu'uriata jikkajibaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesus, junama'a bau ba'a mayoat, wooi bwere kuta kanoam ba'apo kia beja cha'akammeu yepsak. Bwe'ituk jume' kuchureeom inime'e junama to'o saka'alataka intok inime'e jume' bem jite'im baksian. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Junak ju'u Jesus juname betana senu kanoa, Simo' teamta atteau ja'amuk intok iniau, che'a ba'au a' ruktane' betchi'bo au nookak. Junak ju'u Jesus junama'a yejtek, chukula intok ama jikat kateka juka' yoemrata majta taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Junak, junammeu noksukai, ju'u Simo' teamtau: ―Inika'a kuta kanoata ba'ata che'a bu'uukun a' nuk sika intok kuchum nu'u betchi'bo enchim jite'im ko'om jimmaane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ini'i Simoo intok: ―Yee maj majtame, si'ime tukaata te inim tekipanoala kaita bwij machikai. Taa ne jume' jite'im sep ba'au ne am jimmaane, i'an em junen a' nesawe' betchi'bo ―ti jiaka a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Junak inime'e aman bem tejwaawaka'uta yaakai, kuchum ka ilikim ama teaka, junuen kia jume' jite'im juni'i chukti taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Junak inime'e, jume' wate amemak rejteme, senu ta'abwi kuta kanoapo anemmeu, maammea ameu chaaek, junuen inime'e aman am aniane' betchi'bo. Inime'e ameu sajaka intok jume' wooi kuta kanoam tapuniak, kia tua inime'e abe ammea roptekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Inika bichakai ju'u Simoo Peo' teame, Jesujta bichapo tonommea kikteka intok: ―In yo'owa, inim nee to'o simne. Bwe'ituk tua nee ka tu'i yoeme ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Bwe'ituk ini'i Simoo majaen intok kia si'ime jume' wate aamak rejteme juni'i junuen jume' kuchum bem yeu wikeka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ju'u Jakoobo intok ju'u Joan, seenu, Sebereo' teamta yoemiam, Simo' teamtamak tekipanoame, inime'e ket womtilamtukan. Taa ju'u Jesus Simo' teamtau: ―Ka majaune, empo i'an naateka jume' inim yoemem, bem jinne'uimtune' betchi'bo am jariune ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Intok junako inime'e, jume' kuta kanoam bwiau yeu am tojisukai, si'imeta junama'a su'u tojaka intok Jesujtamak yeu sajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Junak, Jesujta junama senu ili bwe'u jo'araapo a' aneo, seenu, lepra' teamtae, unnaa ko'okoeka au yepsak. Intok ini'i, Jesujta bichakai, tonommea kikteka, bwiau ko'om cha'aka intok au ujbwanak: ―Achai, empo junen ea'ateko, inia in ko'okoata betana nee ino ine'etetuane ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Junak intok Jesus, inika'a, aet mamteka: ―Jana'aka, junuentune. Sep tu'ika tawane ―ti au jiiak. Aapo'ik inika'a teuwaako, ju'u lepra' teame ko'okoa iniat kaitatuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Junako ju'u Jesus inia betana aet nesawek inika'a kaabetau a' teuwaasaekai: ―Ala sikaa, intok aman ju'u te'opopo tekiakamtau noitinee jiba. Intok em tu'ureaka' betchi'bo intok inia betana empo Liojta yo'ori betchi'bo, inien ko'okoeme aman toji'ea'uta aman tojine, juka' Moiseejtuka'uta a' nesaweka'a benasia, junuen si'imem ju'uneene' betchi'bo, em ko'okoa betana jaibu em tu'ireasuka'po ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Taa ju'u tu'ika Jesujta joa'u nooki, che'ewa su si'imekut weyen. Yoemra intok juebenaka au nau yaajan a' teuwaa'uta jikkajibaekai intok aapo'ik ju'u bem ko'okoa betana am tu'utene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Taa ju'u Jesus, pa'akun, omot, kaabeta ane'u bicha yeu sisimen, intok junaman Liojtau bicha nonokan. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sejtul, juka' Jesujta yee a' majtao, junama waate paiseeom teame intok Moiseejta nesaurim yee majtame ket junama aanen. Inime'e jume' ili jo'aram be'ekatana, bwiaraa Kalilea' tea'po intok Jurea' tea'po jokame betana intok bwe'u jo'ara Jerusalen tea'a betana ama yajilamtakai. Liojta betana intok ju'u a jita a' joa'uta aet bitwan, aapo jume' ko'okoeme emo ine'etetuakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Intok waate o'owim junama yajak, seenuk, ka au taka yekamta, tapejtim benaku a' weiyaakai. Intok inime'e, inika'a kariu Jesujta ane'u a' nuk kimubaen. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Taa inime'e, juka' bu'uuraata betchi'bo kaak luula a aman kiimuk. Junako inime'e kari jikau ja'amuka intok junama'a jikat, jume' babue ya'arim kooktaka, juka' ko'okoemta, jipetekpo ama aneme nasuk, Jesujtau ko'om a' teekak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ju'u Jesus, inime'e junuen tua a' sualeme ju'uneiyaakai, ju'u ko'okoemtau: ―Empo in nake'u, jume' em ka tu'ik ya'arimmet, i'an ne enchi jiokoe ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Junak jume' Moiseejta nesaurim yee majtame intok jume' paiseeom teame, inime'e: “Jabetaka sa ini'i, a' nokie Liojta beje'eka, ka tu'ik teuwaame. Kaabe intok ka tu'uwa ya'arimmet a yee jiokoe, aapo Lios jiba”, ti bempo ee japtek. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Taa Jesus, inime'e ju'u bem emo eetua'ut witti ju'uneaka intok: ―Jaisaaka eme'e junuen emo eetua ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bwe'ituk jitasa che'a ka obiachi a' chupnee'u: “Em ka tu'uwa ya'arimmet empo jiokoiri”, oo: “Empo, yejteka intok weene”, ti in au teuwaanee'u ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tu'i, junuen san enchim ne a' ju'uneiyaa i'a juka' inim emo benasi yoemta, inim bwiapo junuen jume' ka tu'uwa ya'arim, yetet a' jiokoinee'ut, yo'o'utte'ata aet ayuka'po. Junako aapo, ju'u ka au yekamtau: ―Eu ne nooka. Yejteka em jipetekta nu'uka intok em jo'au weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ju'u san ka au taka yekame, junama lautipo bempo'im bichapo ka obiachisi kiktek. Ini'i, juka' a' jipetekta nu'uka intok a' jo'aau bicha siika, alleaka Liojta a' baisae'uta teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Si'ime jume' ama aneme, junaet suum eaka taawak, intok inime'e, Liojta bem yo'ore'uta a' teuwaan. Intok tua majjaika: ―I'an inim itepo te juka' ka jiba bitwaka, tua ka a jootu maisi weyeka ya'arita itepo bitlaa ―ti inime'e jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iniat chukula ju'u Jesus junama yeu sika intok seenuk Lebi' teaka, ya'uraata betana tomita nau totojamtau yepsak, inika'a jum junaka'a tomita a' totojiwa'po ama au katekamta, intok iniau: ―Nemak weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Junak intok ju'u Lebii' teame sep kikteka intok si'imeta junama su'u tojaka, Jesujtamak yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Iniat chukula ju'u Lebi' teame, a' jo'aapo Jesujta betchi'bo ji'ibwa teboka, bwe'uusi alleewamta weetuan. Junama intok ket juebenaka waate, ale benasi ya'uraata betchi'bo tomita nau totojame ama aanen. Intok wate ket ama yajilame bempo'immak mesau jookan. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Taa jume' paiseeom teame intok jume' inimemak, Moiseejta nesaurim yee majtame, inime'e, Jesujta majtim ka amma'ali am ane'eti jiaka, nok japtek. Intok inimmeu: ―Jaisaaka eme'e, jume' tomita nau totojammak intok jume' ka tu'i yoememmak emo alleetuaka intok amemak ji'ibwa ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Inime'e inen yoopnak ju'u Jesus: ―Jume' kaita inne'aaka, ka ko'okoeme, juka' jittoata am makneemta ka a' jariune. Ala jume' ko'okoeme. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kannee jume' tu'i yoemem jinne'uimtune' betchi'bo ameu noki'isek. Ala, jume' Liojta bichapo ka tu'i yoemem, junuen inime'e, ka tu'ik betana emo am temaine' betchi'bo, junaka'a koptakai ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Junak intok bempo: ―Jaisaaka jume' Joan tuka'utamak eame intok jume' paiseeom teammak eame, inime'e jaarekisi ka ji'ibwaka Liojta yo'oriwamta intok Liojtau bicha nokwamta weetua. Taa jume' em majtim inime'e jiba junaen ji'ibwa, ka jume' watem benasia ―ti Jesujtau nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus inen am yoopnak: ―Kaachin eme'e, jum jujupwaa'u, jume' nunurim a utte'a jooriane, inime'e ka ji'ibwaka ama anne' betchi'bo, ket juka' jupbaemta ama a' aneo. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Taa yuma'anee ju'u taewai, junak inime'e, juka' jupbaemta am u'aatuneeo. Junak ala inime'e ka ji'ibwane ―ti ameu jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ketchia aapo inile benak ta'abwik teuwaaka ameu nookan: ―Kaabe bemela supem chuktaka, jume' moeram ammea cha'abwabaane. Junuen ini'i ayuko, jume' bemela supem nasontene, intok che'a ket, jume' bemela tajo'orim, moerampo ka ama tu'i ―ti jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Intok kia, ju'u bemela pa'asi ba'awa juni'i, kaachin moera bea boosampo kima'anaa. Bwe'ituk junuentuko, ju'u bemela pa'asi ba'awa, jume' bea boosam siutane. Intok ju'u paa'sai ba'awa intok kia jume' bea boosam juni'i junuen nasontune. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Junuen san, ju'u bemela paasi ba'awa, beemela bea boosampo kima'atune. Junuen nanancha binwatune. ");
INSERT INTO yaqNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Intok kia kaabe, wa'a, juka' pa'asi ba'awata binwatuk ya'arita je'eeme, chukula bemelak ji'ibaane. Bwe'ituk ini'i: “Ju'u binwatuk weeria che'a tu'i” ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sejtul, senu aet yum jo'e taewait Jesujta ket jum tiiko etpo aman a' weyeo, jume' a' majtim aamak kateme, jume' tiikom chukta sakan. Chukula bempo maammea am biitaka, jume' bachiam bwa'a sakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Junak intok waate, jume' paiseeom teame: ―Jaisaaka eme'e, yum jo'e taewait, tekilta, ka joo'eewamta a' jooa ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Inime'e, Jesus inen yoopnak: ―Jaisa eme'e, jum ji'ojteimpo kee a' bicha ja'ani, sejtul junak juka' Labiituka'uta, aapo'ik intok jume' aamak rejteme, bempo'im tebaureka, aapo'ik yaaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ini'i jum Liojta te'opou kibakeka intok jume' paanim, Liojtau bicha na'ikiarim am nu'uka inime'e bwa'aka. Intok ket jume' aamak aneme mikakai. Inime'e paanim, kia jume' te'opopo tekiakame jiba bwa'aa'ea'um ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ketchia aapo inimmeu: ―Ju'u inim emo benasi yoeme, aet yum jo'e taewait, jitat nesau betchi'bo ket yo'o'utte'aak ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chukula juchi senu aet yum jo'e ta'apo, Jesus, juriom nau emo totoja'po kibakeka, junama yee majta taitek. Junama senu ama yoeme, batatana mamam tua ka am yekaka ama aanen. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jume' Moiseejta nesaurim yee majtame intok jume' paiseeom teame, inime'e Jesujta bitbaeka ama jak ja'abwekan, juka' ama anemta junae aet yum jo'e ta'apo a' tu'utek juni'i, intok junuen iniat jiawiteka a' na'atejobaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Taa Jesus ju'unean, aapo'ik betana jachin bem emo eetua'po. Intok ju'u ka au mam yekamtau: ―Kikte'e, imin nasukun keka ―ti au jiiak. Ini'i kikteka, aman siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Junak intok ju'u Jesus jume' watemmeu: ―Senu weemta ne emou nattemaibae ―ti ameu jiiak―. Aet yum jo'e taewait, jitasa itepo junen joo i'awa, juka' tu'ik, oo juka' ka tu'ik. Senuk jinne'uwame oo jiapsita senuk ta'arutuawame ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Junak Jesus, jume' aamak ama aneme, si'imem bitchusuka intok, ju'u o'outau: ―Mamam rutukta ―ti au jiiak. Ini'i junuen am rutuktaka intok jume' a' mamam tu'ureak. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Taa jume' waate, ka a' tu'ureme, tua o'omtek. Intok inime'e naas nau nattemai japtek, Jesujta beje'eka, juka' bem ya'anee'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Junakriapo, inime'e taewaimmet ju'u Jesus junama senu kawiu bicha siika Liojtau bicha nokbaekai. Junama intok si'ime tukaapo Liojtau bicha nokaka ama aanek. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Junak, yokoriapo yeu matchukai, jume' a' majtimmeu chaaek. Intok junama, inime betana, woj mamni ama wooim yeu pu'aka. Inime'e ket, apojtolim ti am teatuakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Inime'e inen te teakai: Ju'u Simoo' teame, ini'i ket aapo'ik Peeo ti a' teatuaka'u. Ju'u intok Anteej teame, ju'u Simo' teamta saila. Ju'u Jakoobo' teame intok ju'u Joan teame. Ju'u Jeriipe intok ju'u Baatolome' teame. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ju'u Mateeo intok ju'u Toomas. Ju'u senu Jakoobo' teame, Alpeo' teamta u'usi. Intok ju'u senu Simo' teame, ini'i kananijtam ti teuwaawammak ea'u. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ju'u, ju'u Jakoobo' teamtamak weri, Juuraj teame. Intok ju'u senu Juuras, Ijkarioote ti teuwaa'u. Ini'i, chukula Jesujta yeu bwisekame. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ju'u Jesus, inimemak kau betana ko'om siika. Intok aapo jume' a' majtimmak weyeka, senu bweka pa'akun yepsak. Ket junama'a yoemra juebenaka aanen. Inime'e, bwiaraa Jurea' tea'a betana intok bwe'u jo'ara Jerusalen tea'a betana, intok mekkaa, jume' bwere jo'aram, Tiiro intok Siroon tea'po, bawe mayoat jokame betana. Inime'e, Jesujta jikkaji betchi'bo intok ket junuen, bem ko'okoa betana aapo'ik am tu'utene' betchi'bo ama yajilatukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jume'e, bebeje'eri ka tu'i jiapsimmea, jiokot emo bichame, ketchia inime'e tuttu'ika taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Si'ime jume' ama aneme, Jesujtat mamtebaen, bwe'ituk aapo, a jita a' joa'ue, si'imem tu'uten. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Junak ju'u Jesus, jume' a' majtimmeu bitchuka intok inen ameu jiiak: ―Tua alleenee eme'e, jume' Liojta betana weyemta emou a' be'ee'po ju'uneame. Bwe'ituk emou lutu'uria, jum Liojta che'a yo'otaka a' kateka'u, enchim annee'u. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Tua alleenee eme'e, i'an tebaureme benasi Liojta betana tu'ik bo'o bichame. Bwe'ituk eme'e tu'ik bitne. ’Tua alleenee eme'e, i'an opoam wo'otame, bwe'ituk chukula eme'e alleewamta bitne. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Tua alleenee eme'e, ju'u yoemrata betana omtawaka oo ket enchim yeu am tatawaao, oo ka enchim yo'oreka emou am nokao, oo jita tua ka tu'ireaka'a benasi enchim am bichao, ju'u inim emo benasi yoemta mak enchim ea' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Junaka taewaita yuma'anemtatchi tua eme'e yuma'isi alleenee intok enchim allea'uta teuwaaka cheptine. Bwe'ituk teekau eme'e tua emou tu'ik bitne. Junuen ju'uneakai, jiba inien jume' inime'e yo'owasuka'um, wame'e Liojta betana ju'uneetuawaka noktuawakame, jiokot am yaaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Taa tua jiokot emou machinee eme'e, jume' tua yu'in emo totomek ti eammeu. Bwe'ituk eme'e, juka' alleewamta inim jaibu a' bitlaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Tua jiokot emou machine, eme'e, jume' i'an kaita emou be'eeka jiapsame. Bwe'ituk chukula ju'u enchim ae jiapsinee'uta emou bi'ine. ’Tua jiokot emou machine, eme'e, jume' i'an inim alleewamta bichaka acheme. Bwe'ituk eme'e chukula tua ka alleaka bwanne. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Tua jiokot emou machine, junak si'imem tu'ik emo tana am nokao. Bwe'ituk jume' junuen emou jiame, bem yo'owasuka'um, bat naataka jume' ka lutu'uriata teuwaaka, Liojta betana emo noktuawa'ati jiakame, ket junuen am uttiaka am bichan. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Taa emou, jume' nee jikkajammeu ne inen jiia, jume' enchim beje'eka aneme, am nakne. Intok jume' ka enchim tu'ureme, eme'e tu'ik ameu joone. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Jume' ka tu'ik emou bicha teuwaame, eme'e tu'ik ame tana waatane. Jume' intok ka enchim yo'oreka emou nokame, eme'e Liojtau bicha am nokriane. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Senuk, pujbat seka'atana enchi a' chochonako, senu takana intok ket au kuaktine. Intok senuk em bepa supem utte'apo enchi a' u'aako, inika'a jume' em supem intok ket a' makne. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Waka'a eu netanemta, a' mikne. Waka'a intok jita em atteata enchi a' u'aakamta, ka au a' a'aubaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tu'ik watem betana emou a' joo bo'o bicha'a benasia, eme'e ket junaen junammeu tu'ik joone. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Bwe'ituk eme'e, jume' enchim nakeme jiba am nake'eteko, kaita tu'uwa ini'i. Bwe'ituk kia jume' ka tu'i yoemem juni'i, inika'a jooa. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Oo eme'e wame'e tu'ik enchim jooriame jiba tu'uwata jooria'ateko, kaita tu'uwa ini'i. Bwe'ituk kia jume' ka tu'i yoemem juni'i ketchia inika'a jooa. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Intok eme'e, wame'e jita ame tana enchim mabet bo'o bicha'um jiba jita rereuwa'ateko, kaita tu'uwa ini'i. Bwe'ituk jiba jume' ka tuttu'i yoemem ket jume' wate ka tu'i yoememmeu jita rereuwaa, ket ame betana jita mabet bo'o bichakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Taa eme'e, jume' enchim beje'eka aneme am nakne. Intok tu'ik joone. Intok jita enchim reu teboka'u betchi'bo, kaita mabet bo'o bichakai. Junuen teekau chukula juka' kaitau a tamachiatuka tu'ik enchim bitnee'uta, ka iliikine. Intok eme'e lutu'uriapo, teekau jiapsamta Liojta yoemiamtune. Bwe'ituk jiba aapo juni'isu ket, jume' ka tu'i yoememmak intok jume' kaita a bai saemmak tu'ika am nake. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","A eme'e yee nak jiokoline, junuen enchim yo'owa Liojta yee a' nak jiokole'e benasia tu'ik yeteu joakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ka eme'e watem jitat ka tu'isi ane'eti jiune, intok junuen Lios kaachin enchim ya'uraa bittuane. Ka eme'e watem jita'apo ka tu'isi am tatawaane, intok Lios kaachin junuen ka tu'isi enchim tawaane. A eme'e yee jiokoinee intok junuen Lios a enchim jiokoine. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","A eme'e yee miknee intok Lios tu'ik enchim bittuane, yuma'isi, nat bepaa kaita be'eeka emou a' autuane. Ju'u Lios, watem enchim am bicha'a benasia, ket jiba junaen emou a' chupa'ane. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ju'u Jesus inika'a ta'abwikut teuwaaka ameu nookan: ―Ju'u senu ka bichame, kaachini juka' senuk ka bichamta a omot bicha a' weiyaane. Inime'e jiba su tua, chubalapo su wojo'oku nau ko'om wattineekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ju'u majtawame, kaachin ju'u a' majtamta bepa che'a eiyaatune. Ini'i chukula a' majtawa'uta chupa'asuka yeu siiko, junuen a' majtaka'u benasi eiyaawaka yeu weeneeka juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Jaisa tua empo ju'u emak werikut, pujpo ili sankoata bicha, em pujpo intok, unnaa bwe'uuk em jipue'po ka emo ju'uneiyaakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Intok empo, em pujpo juka' che'a bwe'uuk sankoata ka a' bichakai, empo tua kaachin, ju'u emak weriku: “Nemak weri. Juka' ili juyata pujpo em jipue'uta, nee enchi yeu a' wikria tua”, ti a au jiune. Empo intok juka' unnaa bwe'uuk pujpo em jipue'po ka emo ju'uneiyaakai. Ka tu'i yoemtaka emo tu'u joame, empo bat tu'isi em jiapsinee'ut emo ju'uneiyaane, junak intok, senuk emak weriku, tu'isi a' jiapsinee'u betana a au noknee. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Kaita ju'u juya, tu'i juyataka intok ka tu'ik takaneeme. Intok kia ju'u juya ka tu'ika, tu'ik takaneeme kaita. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bwe'ituk we'epulaka ju'u ouwo, inime'e, bem taka'ue ta'eenaa. Ju'u ouwo wichakame, kaachin juka' chunata takane. Intok kia jume' pa'asim juni'i, juya sarsa'a teamta betana ka pu'anaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ju'u yoeme, tu'ikai, tu'ik ausu'lik teuwaane, bwe'ituk tu'ik jiba aet ayuka' betchi'bo. Ju'u intok yoeme, ka tu'ikai, ka tu'ik teuwaane, bwe'ituk ka tu'ik jiba aet ayuka' betchi'bo. Bwe'ituk ini'i, juka' aapo'ikut ayukamta, a' noka'ue su a' teuwaaneekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Jaisa betchi'bo tua eme'e: “In yo'owapo” nee teuwaa, juka' in teuwaarita intok ka a' joakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Emou ne a' teuwaabae, juka' nemak eaka intok in teuwaarita a' bo'o jooriamta, jabetau a' tamachiatu'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ini'i, senuk karita a' yaaka'a benasi maachi. Taa bat naataka juna'a, mekka ko'om ji'ibwejek. Intok ini'i tetata bepa a' nawatuak. Ju'u batwee tapunakai, ju'u ba'a utte'aka aet siika, taa kaachin a' yaak bwe'ituk ini'i su tetat nawakantakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Taa wa'a, juka' in teuwaarita jikkajaka intok ka a' bo'o jooriame, ini'i, senuk karita bwiat ka nawakamtat a' yaaka'a benasi maachi. Ju'u intok batwee tapunakai intok ju'u ba'a utte'aka aet sikaa, ini'i wecheka intok tua ju'u wechia jiba taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Junak Jesus, ju'u yoemratau inika'a si'imeta noksukai, bwe'u jo'ara Kapernaom tea'u bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Junama'a seenu, Roma' tea'a betana jometaka, sontaommeu ya'ut, ini'i seenuk a' nesaureowata tu'isi a' nake'uta ama jipuen. Juna'asan ko'okoen, jaibu muki'isekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Junak ju'u sontao ya'ut, Jesujta etejowamta jikkajakai, ini'i jume' juriommeu yo'owem, watem au bittuak, inime'e juka' aapo'ik nesaureowata junuen aman a' tu'utene' betchi'bo au am nokne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Inime'e Jesujtau rukteka intok junae betana tua au ujbwan japtek: ―Ini'i ya'ut au lutu'uriak em a' anianee'u betana ―ti jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bwe'ituk aapo itom yoemra nakeka a' bicha, intok jiba aapo juka' itom ama nau yaaja'u karita itom ya'aria tebok ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Junak ju'u Jesus inimemak siika. Taa bempo'im jo'arau jeela am kateo, junak ju'u ya'ut, watem a' ta'aa'um, Jesujtau am bittuak: ―Achai, ka emo lottane, bwe'ituk tua ka neu lutu'uria in jo'au em yebijne'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Inia betchi'bo ka inepo aman enchi bitbaek juni'i. Taa ala, a' ine'etenee'uta teuwaane jiba, intok au ine'etenee ju'u in nesaureo, ti bem au jiune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bwe'ituk jiba inepo juni'i, watem che'a nee bepa nesaweme jipue. Intok inepo ne ket naa buusti sontaom in sawe'um nee jipue. Juname betana, senuk jakun ne a' wee saao, aman weene. Senuku intok ket: “A'abo weye”, ti ne au jiao, neu weene. Juka' intok in nesaureota, jitat nee saweo, a' jojoa ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Inika'a jikkajakai ju'u Jesus, a' suum eiyaaka a' uttiaka taawak. Intok jume' aamak katemmeu bitchuka: ―Tua lutu'uriapo, kia inim Ijra'el yoemrata nasuk juni'i, ne kee jabeta ju'uneiyaa, tua tu'isi Liojtat a yoem'eamta, inia o'outa benasi ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Inime'e aman au bittuarim intok chukula jo'arau notteka, ju'u junama tekokamtau jaibu tu'iku yajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Iniat chukula ju'u Jesus ili bwe'u jo'ara Nain tea'u bicha weyen. Intok jume' a' majtim intok wate yoemra juebenaka aamak kaaten. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Junaman jeela yebissusekai, mukiata ma'aboka weiyaawamta bichak. Ini'i, wepu'ulaika jiba, a' malawa jokoptuita yoemiakan. Junama ili bwe'u jo'arapo, juebena yoemra junae jamuttamak kaaten. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Inika'a bwanamta bichaka ju'u yo'owe Jesukrijto tua a' jiokolek intok aapo'iku: ―Kat bwaana ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Junak ju'u Jesus au rukteka intok ju'u jitat ama a' weiyaawa'ut mamtek. Jume' a' weiyaa'um sep japtek. Intok ju'u Jesus ju'u mukiatau: ―Ju'ubwa yo'otume, ineponee eu junen jiia, yejte'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Junako ini'i mukiatuka'u, yejteka intok nok taitek. Ju'u Jesus intok junak a' malabeu a' su'u tojak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Inika'a junuen bichakai, si'ime majjaen. Intok juname'e, Liojta bem a' yo'oree'uta teuwaa japtek inen jiakai: ―Senu tua eiyaawatchika, Liojta betana ju'uneetuawaka nokame ito nasuk yeu machiala. Ket inime'e: ―Ju'u achai Lios a' yoemrabeu wawaatek ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Intok bwiaraa Jurea' tea'po si'imekut intok inia konila ka mekka bwiaarapo joomem betana ju'uneiyaatuk ju'u Jesujta yaaka'u. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ju'u Joan, si'ime inia betana a' ju'uneiyaak. Bwe'ituk jume' a' majtim au a' etejok. Junako juname betana wooim yeu pu'aka ");
INSERT INTO yaqNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","intok inime'e, Jesujtau am bittuak junuen bempo'im, lutu'uriapo aapo'ik ju'u Krijto yebijneemetuka'po oo ta'abwik bem bo'o bitne'po betana bem au nattemaine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jume' Joanta betana aman bittuarim junuen Jesujtau ruktek intok: ―Ju'u Joan, ju'u yee babatoowame, a'abo itom bittuari, junuen tua lutu'uriapo enchi ju'u Krijto yebijneemetuka'po oo ta'abwik itom bo'o bitne'po betana itom eu nattemaine' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Inime'e ama yajako, junama lautipo Jesus juebenam bem ko'okoat intok si'ime ka tu'ikut am tu'utek. Intok bebeje'eri ka tu'i jiapsim betana am tu'utekai. Intok ket juebenam jume' ka bibichame emo ine'etetuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Junuen san ju'u Jesus inimmeu: ―Eme'e aman sajakai intok si'imeta juka' inim enchim bichaka'uta intok enchim jikkajaka'uta Joantau a' teuwaane. Jume' ka bibichame am bittuawa'po intok jume' lolo'im rejte'epo. Jume' sa'awam, lepra' teamtae ko'okoeme emo am ine'ete'po. Jume' ka jikkajame am jikkaja'po. Jume' intoko kokkokame, juchi jijiabijtetuawa'po. Intok jume' kaitae emo ania machika jiapsammeu, Liojta betana juka' tu'i nok lutu'uriata am majtawaa'uta a' etejorianee juka' Joanta ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Intok ket, tu'ikut tua alleenee wa'a, inim net jiapseka jiba net a' yoem'ea'uta ka au tiutuakame ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Junak jume' Joanta betana aman bittuarim sajako, Jesus ju'u Joan teamta betana ju'u yoemratau nok taitek: ―Aman bweka pa'ariau yeu sajaka, jitasa eme'e bitboka aman aanen. Ka eme'e bakata jekae naas bepwamta bitbaeka aman sajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ka junuen tuko, jitasa eme'e bitboka aman sajak. Ka eme'e senuk tu'isi ujyoisi au a'anaalata bitbaekai aman sajak. Eme'esu ju'unea, jume' junuen ujyoisi emo a'anaarime intok inim ayukamtae jiba emo alleetuame, inime'e, jume' che'a si'imemmeu yo'o ya'arim jo'aaka'po jiba am ane'epo. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Junak su jitasa eme'e bitboka aman sajak. Seenuk Liojta betana ju'uneetuawaka yeteu nonokamta ja'ani. Jana'aka. Intok ini'i senuk Liojta betana chukula yeu weenemta teteuwaamta bepa che'a eiyaawatchikai. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ini'i Joan jiba juna'a, wa'a, Liojta nok lutu'uriapo ae betana inen ji'ojtewakame: Inepone, juka' epat sikaa, yeteu nokneemta nee aman bittuane. Junuen inika'a, yoemratau nokaka, eewas juname'e bem emo jiapsi temaine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Taa ineponee inen emou jiia, juka' yoemrata inim jiapsa'po naateka i'an tajtia, ju'u Joan yee babatoowamta bepa, kaabe, che'a ae bepa eiyaawatchika jiapsila. Junuentaka juni'i, wa'a jum teekau, Liojta yo'otaka kateka'u tua che'a ka eiyaawatchikai juni'i, ae bepa che'a eiyaawatchine. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Inika'a jikkajakai, si'ime ju'u yoemra intok jume' ya'uraatau bicha tomita weyemta nau totojame, ju'u Joanta betana bato'owaawakame, inime'e, Liojta si'imeku lutu'uriakamta jiba a' joaka a' tu'ure'po ju'unean. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Taa jume' paiseom teame intok jume' Moiseejta nesaurim yee majtame, inime'e Joanta betana kee bato'owaa'um, juka' Liojta ame betchi'bo ya'abaeka'uta ka a' mabetbaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Junak intok ju'u Jesukrijto inen jiiak: ―Jitau sa tua nee a' tamachianee juka' yoemrata i'an inim jiapsamta. Jaisa inime'e mamachi. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Inime'e, ili uusim, jum jita nenenkiwa'po yeeweka intok jume' bem ta'aa'ummeu inen jiame bebena: “Kusiata, tua ujyoisi itom emou kuseo juni'i, eme'e ka ye'eka. Chukula intok kia sioksi itom emou bwikaao juni'i, taa eme'e ka bwaanak.” ");
INSERT INTO yaqNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bwe'ituk ju'u Joan yee babatoowame inim jiapsaka, inika'a ka yu'in ji'ibwaao, intok kia juka' ae nanaakowamta juni'i, ka a' je'eekai, eme'e intok, bebeje'eri ka tu'i jiapsi aet aane'eti jiia. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iniat chukula intok ket ju'u inim emo benasi yoeme yepsak, si'imeta a bwa'eekai intok pa'asi ba'awata ne je'eekai, intok eme'e, inika'a yu'in a' jiji'ibwaka intok ae nanaakowamta a' je'e'eti jiia. Intok kia jume' ka tu'i yoememmak intok jume' ya'uraatau bicha tomita weyemta nau totojammak a' weama'ati jiia. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Taa ju'u suawa Liojta betana weyeme, jume' aapo'ik Liojta betana suawakammet a ju'uneiyaatu. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jume' paiseom betana seenu, Jesujta a' ji'ibwa nunuk. Jesus intok inia jo'au yepsak intok junama'a mesau yejtekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Junak intok senu ka tu'i jamut, jiba junama ili bwe'u jo'arapo jo'aakame, Jesujta junae paiseota jo'au a' ji'ibwaseka'po ju'uneaka, ini'i, jita tosai tetae ya'aripo, ochokok tua win jubaka weiyaaka ama yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Intok ini'i, Jesujta wokiu yejtek. Intok bwanaka, a' opoam Jesujta wokimmet ko'om weyekai. Chukula a' chonimmea a' wacha'ariakai. Intok amet tenteka, juka' ochokok win jubak amet to'aak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ju'u paiseo, Jesujta nunulame a' bichakai: “Ini'i lutu'uriapo Liojta betana weyeka yeteu nokametuko, inia jamut, aet mammamtat ju'une ean, inika'a jachin a' jiapsa'ut. Bwe'ituk ini'i tua ka tu'i jamut ti,” au eetuan. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Junak ju'u Jesus, ju'u paiseotau: ―Simoo, senu weemta ne eu teuwaabae ―ti au jiiak. Ju'u paiseo intok: ―Neu a' teuwaa yee majtame ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ju'u Jesus iniau: ―Waate woika, seenuk tomita yee rereuwamta a' wikiriian. Seenu, mamni siento tosai tomim a' wikiriian. Senu intok woi taka ama woj mamni tosai tomim a' wikiriian. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Inime'e intok ka a' beje'etuao, ju'u tomita am reuwaalame, ju'u bem a' wikiria'ut am jiokoek. Nee tejwaa, inime'e woim betana jabesa tua che'a a' nak machi ―ti a' temaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ju'u Simoo' teame: ―Ju'u, che'a bu'uukut jiokoiwakame, ti nejpo ea ―ti au jiiak. Jesus intok: ―Tua empo junaen a' teuwaala ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Junak ju'u Jesus juka' jamutta bitchuka, ju'u Simo' teamtau inen jiiak: ―Inia jamuttat mammatene. Inim em jo'apo nee yepsaka, empo intok ba'am in ammea wok baksianee'um ka neu tojak. Taa ini'i jamut a' opoammea in wokim baksiala intok a' chonimmea am wachakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Intok empo ka nee ibaktaka nee tebotuak. Taa ini'i, nee im yepsak naatekai in wokimmet tettente. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Empo kia juka' ochokok ka kobat net yaak. Taa ini'i, aapo wokpo juka' ochokok win jubak net to'aak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Inia betchi'bo ne inen eu jiia, tua a nee a' nak yo'oree'uta a' teuwaa, tua bu'uuk a' ka tu'uwa ya'arit a' jiokoituka'u. Taa wa'a ka bu'uukut jiokoiri, ini'i, nee a' nak ta'aanee'uta ka junuen aet yeu machine. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Junako ju'u jamuttau: ―Em ka tu'uwa ya'arimmet empo jiokoiri ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jume' aman nunurim junama'a aamak joka'um, bempo naas inen nau jiu japtek: ―Jabesa tua ini'i, yoemtaka, kia jume' ka tu'uwa ya'arim juni'i a jiokoekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Taa Jesus ju'u jamuttau: ―Ka tu'ik betana empo jinne'uri junuen em nee suale' betchi'bo. Kaachin eaka weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iniat chukula ju'u Jesus, juebena ili bwere jo'arammet intok jume' che'a ilitchi jo'arammet weyeka, Liojta yo'o nesaweka a' kateka'u betana juka' nok lutu'uriata yee a' majtakai. Jume' woj mamni ama woika a' majtim intok aamak kaaten. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kechia waate jaamuchim, inime'e aapo'ik bebeje'eri ka tu'i jiapsim betana intok ko'okoat aapo'ik tu'uteka'um, aamak kaaten. Inime nasuk ju'u Maria Maareena' teame weyen. Ini'i, woo busan bebeje'eri ka tu'i jiapsim betana tu'ureakame. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kechia ju'u Joana' teame, ju'u Chusa' teamta, ini'i, ju'u kobanao Eroorej teamta a' jipue'u yo'o ya'ataka, tekilta joamta juubi. Ket ju'u senu Susaana' teame intok juebenaka waate jaamuchim. Inime'e, ju'u bem atteae, au be'emtat a' aniakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Juebenaka junama ka mekka ili bwere jo'aram betana yeu sajak junuen juka' Jesujta bitbaekai. Intok junak juebenam junama nau yajako, aapo jita ta'abwiku a' tamachiaka ameu nookak, inen ameu jiakai: ");
INSERT INTO yaqNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Senu etreeo, etbaeka a' waj bwiau yeu siika. Ini'i intok junuen juka' echimuta wo'ota simekai, waate ju'u bachia, bo'ot wattek intok aet cheptiwak. Jume' wikitchim intok a' bwa'aka. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wate ju'u bachia ket, tetam nasuk wattek. Intok juna'a bachiata siwekai, sep waakek, ba'arik au be'e' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waate ju'u bachia ket, juya wichakamta nasuk wattek. Intok ju'u juya wichakame, aamak yo'otuka, ka a' yo'otu tuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Taa waate ju'u bachia, tu'i bwiapo wattek. Intok ini'i yo'otuka, junak tu'ika chupuk. Kia ju'u echimu wo'otawakame, we'epulaka, mamni takaam bachiaka chupukai. Inika'a teuwaasuka ju'u Jesus, tua kusisi nokaka: ―Eme'e a' jikkajibae'eteko, a' mammatene ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Junako jume' a' majtim, inika'a jita ta'abwikut nokaka a' teuwaa'uta, ju'u a' teuwaabae'ut au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Inimmeu intok inen jiiak: ―Ju'u Lios, aapo'ik teekau che'a yo'otaka a' kateka'a betana, juka' kaabeta ju'uneiyaa'uta, enchim ju'uneiyaatuari. Taa jume' watemmeu ne junuen jita ta'abwiku a' tamachiaka ameu nooka. Bwe'ituk inime'e jita bichaka juni'i, ka a' bichame benasi taawa intok juka' ameu teuwaawamta jikkajaka juni'i, ka aet ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ini'i juna'a, ju'u inia jita ta'abwiku a' tamachiawaka teuwaawamta a' teuwaa'u. Ju'u bachia, juka' Liojta betana nok lutu'uriata teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ju'u intoko wate bachia bo'ot luula wattekame, jume' a' jikkajame teuwaa. Taa ju'u bebeje'eri ameu yepsaka intok juka' nok lutu'uriata bem jikkajaka'uta, ae beas am kop koptitua junuen ka bem a' sualeka intok ka bem jinne'uimtune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ju'u bachia, tetapo wattekame ket, jume'e, juka' Liojta nok lutu'uriata jikkajaka intok alleaka a' mabetakame teuwaa. Taa inime'e, tiikota ka yuma'isi a' nawaka'a benasi, jumak a' sualnee chuuba taewaimmeu tajtia. Taa jiokot bem emo bitnee'u a' yumako, inime'e, inika'a omola tawaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Intok ju'u wate bachia, juya wichaka'po wattekame, ini'i, jume' a' jikkajame teuwaa. Taa inime'e jiba benasi jiapsa. Intok ju'u bem aet jiapseka'ut intok yu'in tomipeewamtat intok inim chubala ae alleaka jiapsiwamtat jiba bem jiapseka, inime'e ka wepulsi Liojta betchi'bo jiapsa intok junuen Liojta betana weyeka, tu'ik ka a' joaka jiapsa. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Taa ju'u wate bachia, tu'i bwiapo wattekame, ini'i, jume' bem tu'u jiapsie intok tua junen jiaka, Liojta nok lutu'uriata a' nok jikkajame intok a' bo'o jooriaka jiapsame teuwaa. Inime'e bem mabetlaa'u ka koptaka intok Liojta betana weyeka, juka' tu'ik yu'in a' joaka jiapsa. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Kaabe, jita tachiriata tayaka intok inika'a junuen chukula jitae a' patta betchi'bo oo jum tottowa'abetuku a' mana' betchi'bo. Ala ini'i, jikat a' mana'anee junuen jume' ama anemmet a' tachiriane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bwe'ituk kaita ju'u etbwa ya'arime oo etbwa teuwaari, ini'i ka ju'uneiyaatuneeme. Ala ju'unakkiachisi ju'uneiyaatune. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Junuen san eme'e tu'isi a' mammateka a' jikkajine. Bwe'ituk wa'a, juka' Liojta a' yoem eiyaame, ini'i che'a juni'i junaet anianaa. Taa wa'a, juka' Liojta ka a' yoem eiyaame, ini'i, kia juka' a aet au yoem'ea'ati a' ea'uta, a' u'aatune. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Junak intok ju'u Jesujta ae intok jume' aamak werim, inime'e, jum aapo'ik ane'u yajak. Taa ka a aman au rukten, tua juebenaka ama ane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Senu Jesujta tejwaak: ―Em ae intok jume' emak werim wa'am pa'aku aane, intok bempo enchi bitbae ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Taa aapo inimmeu: ―Wame'e, juka' Liojta nok lutu'uriata jikkajaka intok a' nok jikkajaka jiapsame, inime'e inepo in ae intok jume' nemak werim benasi ne am eiyaane ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sejtul wee'po ju'u Jesus jume' a' majtimmak, senu kuta kanoau ja'amuk. Intok inimmeu: ―Bwe'u bau ba'ata waitana bicha te katne ―ti ameu jiiak. Inime'e yeu sajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Intok ketun bempo'im ba'at bo'o joao su ju'u Jesus kochok. Junama bau ba'apo intok, jeeka, tua utte'aka seej chukti ameu yepsak. Ini'i intok juka' kuta kanoata ba'ae a' tapunia taitek, ko'om kimu maisi anekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Junak intok bempo, Jesujtau sajaka a' busak intok: ―Yee majtame, inim te abe ko'om kiimu ―ti au jiiak. Junak Jesus, yejteka intok ju'u jekatau intok ba'a ro'aktiammeu, yanti a' tawane' betchi'bo nookak. Intok si'ime yuma'isi yanti taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Junak intok aapo a' majtimmeu: ―Jaksa ju'u enchim a nee suale'u ―ti ameu jiiak. Taa bempo, womtilamtaka suum ean. Intok naas nau nattemaen: ―Jabesa taka tua ini'i, jekata intok juka' ba'ata a au nooka. Ini'i intok a' teuwaa'po aman aane. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Junen su, inime'e bwiaraa Kalaara' tea'u yeu yajak. Kalilea' tea'abewit, bwe'u bau ba'ata beasi. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Juka' Jesujta junama'a bwiau ko'om a' chepteo, seenu, junama ili bwe'u jo'arapo joome au ruktek. Binwatun ini'i, jume' bebeje'eri ka tu'i jiapsim aet anekai. Ka tatajo'oren, intok kia ka jo'arapo jiapsan. Ala jum kokkoarim ma'aripo jiba aanen. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Junak ini'i, Jesujta bichakai, au tonommea kiktek chaaekai: ―Kat neu suua Jesus, che'a yo'orisi machika ju'u Liojta u'usi. Ka jiokot em nee ino bittuane' betchi'bo ne eu ujbwana ―ti jiiak kusisi nokakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Aapo inien jiiak bwe'ituk ju'u Jesus, juka' bebeje'eri ka tu'i jiapsita a' su'u tojine' betchi'bo au nookan. Ju'u ka tu'i jiapsi jue benasi a' kokkoban. Intok junama'a waate, a' eta'abaekai, a' bwiseka, sisi'iwook wikiammea, mampo intok wokpo a' sussuman. Taa ini'i, inime'e chuk chuktan. Intok ju'u ka tu'i jiapsi, mekka bweka pa'akun bicha a' sisimtuan. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ju'u Jesus: ―Jaisa empo teak ―ti au nattemaek. Aapo intok: ―Lejion, ti ne ta'eewa ―ti a' yoopnak. Inika teuwaak bwe'ituk tua unnaa juebenaekan jume' bebeje'eri ka tu'i jiapsim aet kimulamtuka'um. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Inime'e ka tu'i jiapsim Jesujtau nookak, junuen jum che'a mekka ko'om siba wojo'okun ka aman am bittuane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Junama kaupo intok koowim juebenam ama ji'ibwan. Jume' ka tu'i jiapsim au nookak, juname'e koowimmet am kimune' betchi'bo. Ju'u Jesus intok junaet am jikkajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Junak intok jume' ka tu'i jiapsim sep su junaet yeu sajaka intok juname kowimmet kiimuk. Inime'e intok si'ime, kau sibau ko'om tenneka intok bwe'u bau ba'au ko'om wattek, junama kokkokai. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Juname kowim suua'um, junaka'a yeu sikamta bichakai, tua suum eaka, sep junama yeu tennek, senu junama ka mekka bwe'u jo'arau, intok bem sajaka'ut intok wasampo jo'arammet a' etejokai. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jume' junama jo'aakame, junama yeu sikamta bitbaeka aman sajak. Inime'e jum Jesujta ane'u yajakai, junaka'a bebeje'eri jiapsimmea koba'ita ama bichak, Jesujta wokiu katekamta, suaka intok tajo'orekamta. Intok inime'e aet ee majjaeka taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jume' intoko a' bichakame, junammeu a' etejok, juka' bebeje'eri ka tu'i jiapsimmea koba'isukamta jachin a' tu'ireaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Junako ju'u yoemrata si'ime ju'u junama'a bwiaraa Kalaara' tea'po jo'aakame, Jesujtau nok japtek junama'a yeu a' simne' betchi'bo. Bwe'ituk inime'e tua majjaen. Junuen san ju'u Jesus, jum bwe'u kuta kanoau ja'amuka ama yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Juna'a bebeje'eri ka tu'i jiapsimmea koba'isukame au nookan, aapo'ik aamak a' weetuane' betchi'bo. Taa Jesus ama a' tawane' betchi'bo au nookak: ");
INSERT INTO yaqNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Em jo'aau bicha nottinee intok si'imeta juka' tu'ik Liojta eu ya'ari, junammeu a' teuwaane ―ti au jiiak. Junuen ini'i, sikaa, intok si'ime junama jo'arat a' teuwaak, juka' Jesujta au yaaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Juka' Jesujta juchi jum bwe'u bau ba'ata waitana a' notteko, ju'u yoemra alleaka a' mabetak. Bwe'ituk junama'a si'ime a' bo'o bichan. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Junak intok seenu, Jairo' teaka ama au yepsak. Ini'i, jum juriom nau emo totoja'po yo'o ya'aritakai. Ini'i Jesujtau tonommea kikteka bwiau ko'om cha'atuka intok a' jo'aau a' yebijne' betchi'bo au ujbwanak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Bwe'ituk aapo wepu'ulaik jiba marakan, woj mamni ama wooi wasukteka, jaibu muki'isekamta. Juka' Jesujta am bicha yeu siiko, tua juebenaka aamak kaaten, kia nau a' pit pittakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Intok inime nasuk senu jamut, woj mamni ama wooi wasuktiapo, ojbo aet yeu weyeka ko'okoekai. Intok ini'i, jume' jittoata ta'aammet si'imeta juka' a' jipue'uta wiutalatukan. Taa juname betana kaabe a' tu'ute machikai. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ini'i, aapo ama tana Jesujtau rukteka intok a' supe mayoammet a' bwisekai, junama lautipo intok ju'u ojbo cha'atuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Junak intok ju'u Jesus: ―Jabesa net mamtek ―ti nattemaek. Si'imem junama'a: “Kaabe”, ti am jiao, ju'u Peeo intok jume' aamak rejteme: ―Yee majtame, ini'i yoemra bu'uukai inim aneme enchi nau pit pitta intok enchi naas yuu'a. Jaisaakai empo intok: “Jabesa net mamtek”, ti jiia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Taa ju'u Jesus: ―Senu net mamtek. Bwe'ituk ne machisi ju'uneak, nee betana in utte'ae, senuk a' tu'ureaka'po ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ju'u jamut, a' ju'uneiyaawaka'po ju'uneakai, au yoaka, intok Jesujtau rukteka a' wokiu au tonommea kiktek. Junama'a si'imem bichapo a' teuwaak junuen aapo'ik aet a' mamteka'uta intok ket junama sep a' tu'ureaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iniau ju'u Jesus: ―In yoemia, junuen em nee sualeka' betchi'bo empo tu'ureak. Alleaka intok ka jain eaka weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Juka' Jesujta ket a' nokao su, seenu, ju'u juriom nau emo totoja'po yo'o ya'ari, Jairo' teamta jo'aa betana ama yepsak intok Jairo' teamtau: ―Ju'u em mara muksuk. Kat intok naa buusti ju'u yee mamajtamta aet suati bittua ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Taa Jesus, junaka'a jikkajaka: ―Ka majjaune, ka ta'abwisi eaka a' sualne, ju'u intok em maara sep tu'ine ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Junaman jo'arau yepsakai, kaabeta intok aamak aman kimutuak taa juka' Peota juka' Jakoobota, juka' Joanta intok jume' junae usi jamutta yo'owawam jiba. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Si'ime ae betchi'bo ka alleaka intok bwaanan. Taa Jesus: ―Kat em bwaana. Ka mukia ju'u usi jamut, koche ala ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Taa inime'e a' atbwan bwe'ituk ju'unean a' mukiatuka'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Junak intok Jesus, mampo a' bwisek intok kusisi nokaka: ―Empo uusi, yejte'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Intok aapo, jiapsi juchi au nottek. Intok ini'i sep su yejtek. Jesus intok a' ji'ibwatua nesaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jume' a' yo'owawam intok alleerimmea ka ju'uneame benasi taawak. Taa Jesus inimmeu nookak, juka' junama yeu sikamta, tua kaabemmeu bem a' etejone' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ju'u Jesus, jume' woj mamni ama wooim a' majtimmeu nau chaaeka intok inime'e, si'ime ka nanau machika bebeje'eri ka tu'i jiapsim a yeu beep betchi'bo intok si'ime ko'okoata a bem tu'utene' betchi'bo yo'o'utte'ata amet autuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Inime'e ket, Liojta che'a yo'otaka a' kateka'a betana juka' nok lutu'uriata am teuwaa betchi'bo intok jume' ko'okoeme bem emo am ine'etetua betchi'bo naas am bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Intok inen ameu jiiak: ―Bo'ot betchi'bo kaita eme'e weiyaane. Kia booniata enchim ama nu'unee'uta, bwa'aamta intok tomita juni'i ka weiyaane. Supem, ka wooim weiyaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jak juni'i, jo'arapo enchim yajaka'u, junama'a enchim ama anbae'po tajtia ama annee. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Intok jum ka enchim mabetbaawa'po, bwe'u jo'arapo eme'e yeu katnee. Intok wokpo bwiata emot cha'atukamta, eme'e a' tattakne, bempo'im ka amma'ali aulatuka'uta junuen a' teuwaakai ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Junuen inime'e yeu sajak, intok si'ime ili ka bwere jo'arammet sajak. Intok si'imekutchi Liojta nok lutu'uriata, yee jinne'umta a' teuwaaka intok jume' ko'okoeme tu'utekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ju'u kobanaao Eroorej teame si'imeta juka' Jesujta joa'uta ju'uneiyaak, intok kaachin an machiakan. Bwe'ituk waate, juka' Joantuka'uta, kokkolam nasuk juchi jiabijtek, ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wate, aapo'ik ju'u Liojta betana ju'uneetuawaka yeteu nonokame, Eliaj teamta inim yeu a' machiak, ti jiian. Waate intok ket, che'a bat naataka, wate jume' Liojta betana yeteu noktuawakame, senuk a' jiabijtelame'e ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Taa ju'u Eroores inen jiiak: ―Jiba inepo su ne a' koba chukta tebok juka' Joantuka'uta. Junak su, jabesa tua ini'i, inien machika tua juebenak joaka in jikkaja'u. Intok Eroores, inika'a ta'aabaeka ean. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Junak jume' aapo'ik majtim nottekai, juka' bem yaaka'uta, Jesujtau a' etejok. Junak intok aapo am nunuka, intok omot, kaabeta tua ane'u bicha sajak, bwe'u jo'ara Betsaira' tea'u jeela. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Taa ju'u yoemra am ju'une'eakai, aet cha'aka sajak. Intok ju'u Jesus, junaman, inime'e au am ruktituak. Intok aapo, Liojta che'a yo'otaka a' kateka'a betana juka' lutu'uriata ameu teuwaak. Intok jume' ko'okoeka kateme am tu'utekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Junak junama kupti taiteko, jume' woj mamni ama wooi Jesujta majtim au rukteka: ―Inika'a yoemrata saka'atua'e, junuen sajaka, bem yum jo'eene' betchi'bo intok jum che'a ka mekka ili jo'arammeu, intok wasammet jo'arammeu sajaka, bem bwa'anee'uta bem jariune' betchi'bo bwe'ituk inim pa'aku itom ane'epo, tua kaak jita aayuk ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Taa Jesus: ―Eme'e am ji'ibwatuane ―ti ammeu jiiak. Bempo: ―Kaita te jipue. Tua mamni paanim intok wooi kuchum jiba ―ti au jiiak―. Kia itepo si'ime inia yoemrata betchi'bo bwa'amta ama jakun a' jinuk jiba ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bwe'ituk inime'e, jumak mamni miil o'owimtukan. Taa ju'u Jesus jume' a' majtimmeu: ―Woi taka ama woj mamamnisia, nattepola eme'e am jote'esaene ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Junuen inime'e ayuka, si'ime jote'esuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Junak intok ju'u Jesus jume' mamni paanim intok jume' wooi kuchum nu'uka intok teekau jikau bitchuka, juname betchi'bo Liojta bai saek. Juname'e paanim rebektakai intok jume' kuchum na'ikimteka, jume' a' majtimmeu am bwisek junuen ju'u yoemratat bem am na'ikimtene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Inime'e si'ime ji'ibwaka intok tua yanti elaka taawak. Chukula intok woj mamni ama wooi bwere waarim, jume' yeu be'ekammea tapuniawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sejtul, junak Jesujta omola, kaabeta ane'u, Liojtau bicha a' nokao, jume' a' majtim ket aamak aanen. Aapo: ―Ju'u yoemra, nee jabesa'ati jiia ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bempo inen a' yoopnak: ―Waate, enchi ju'u yee babatoowame, Joan, ti jiia. Wate ket, enchi ju'u Eliias, ti jiia. Wate intok ket enchi, che'a bat naataka jiapsisuka, wate jume' Liojta betana yeteu noktuawakame, senuk a' jiabijtelame'e ti jiia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Junak intok aapo ameu nattemaek: ―Eme'esu, nee jabesa'a ti jiia. Ju'u Peeo intok: ―Empo juna'a ju'u Krijto, Liojta yeu pu'ari ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Taa ju'u Jesus tua ameu ujbwanaka, inika'a, kaabetau bem a' teuwaane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Intok ket inen ameu jiiak: ―Ju'u inim emo benasi yoeme, tua jiokot au bitne. Intok ini'i jume' juriommeu yo'owem betana intok jume' te'opopo tekiakammeu yo'owem betana intok ket, jume' Moiseejta nesaurim yee majtame betana, ka a' mabettunee'uta junuen bitne. Inime'e, in me'etune' betchi'bo net nesaune. Taa baji taewaita weyeka jiabijtene ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chukula si'imemmeu inen jiiak: ―Seenu, ju'u nemak eebaeme, ini'i, ka tu'ik a' tu'uree'uta a' koptane. Intok chikti ta'apo, nemak eaka jiapsine, jiokot au bichaka juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bwe'ituk wa'a, inim ayukamtat jiba eaka, tu'isi jiapsibaeme, ini'i, jiba yuu a' jiapsinee'uta ta'arune. Taa wa'a nemak a' ea' betchi'bo, mukneeka juni'i, kaachin eame, juna'a, jiba yuu a' jiapsinee'uta a' bitne. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bwe'ituk jitasa tu'ik jajamnee seenu, si'imeta juka' inim bwiapo tu'ik kobaka, taa intok junaet jiba betchi'bo ka tu'ikun bicha au ta'aruko. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bwe'ituk seenuk, inika'a, nee betana intok ju'u in nok lutu'uriata betana au a' tiutuakamta, ju'u inim emo benasi yoeme, chukula, che'a si'imem bepa yo'o ya'ataka intok a' Lios achaiwa betana yo'orisi machika a' eiyaanaa'uta aet bitwaka intok jume' Liojta ankelesimmak a'abo nottekai, ket junae betana au tiutuane. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lutu'uriapo ne inen emou jiia, jume' inim aneme betana, wate inim rejte, inime'e, juka' Liojta che'a yo'o nesaweka au a' jiapsa'uta, ka a' bichaka ka bem kokkone'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chukula, woj naiki taewaim sika inika'a teuwaakai, Jesus senu kawiu siika, junaman Liojtau bicha nokbaekai. Juka' Peota intok juka' Jakoobota intok juka' Joanta inime'e ket aamak nunukai. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Juka' Jesujta intok ket, Liojtau bicha a' nokao su, ju'u a' pujbawa ta'abwisi bittuk. Ju'u intok a' tajo'oriwa tua tossaaisi intok beojkosi taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Junak intok o'owim wooika aamak etejoka bittuk. Inime'e, ju'u Moisees intok ju'u Eliias tukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Inime'e, Liojta betana tatchiriapo ja'abwekai. Intok bempo, Jesujta chukula jum bwe'u jo'ara Jerusalen tea'po a' muknee'u betana nau etejon. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ju'u Peeo intok jume' aamak rejteme, tua kokotpeaka juni'i, ka kokochok. Intok inime'e, Jesujtat inien juka' Liojta betana tachiriata, ka a teuwaatumta, intok jume' woika aamak aneme am bichak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Junak juname'e o'owim, Jesujta ama a' to'o sakao, ju'u Peeo inen au jiiak: ―Yee majtame, tu'isi te im aane. Itepo, baji ili juya karim te ya'ane, senuk ee betchi'bo, senuk Moiseejta betchi'bo intok senuk Eliajta betchi'bo ―ti jiakai. Taa ju'u Peeo tua ka ju'uneaka nookan. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Aapo'ik intok ketun a' nokao su, namu am pattak. Inime'e intok tua majjaen junuen namupo wajiwa emo bichakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Junak intok junama namupo betana jiawai jikkajituk: ―Ini'i juna'a ju'u in yoemia in nake'u. Aapo'ik eme'e a' nok jikkajine ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chukula junaka'a jiawaita junuen a' noksuko, inime'e Jesujta aapolaik jiba ama bichak. Bempo intok kaita teuwaak intok juka' bem bichaka'uta kaabetau a' etejok. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Juchi yokoriapo bempo'im junae kau betana ko'om am yajako, yoemra juebenaka Jesujta nankika au kaaten. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Junak intok seenu, juname betana, tua kusisi au nokaka: ―Yee majtame, nee jiokoine, in usi nee bitria. Bwe'ituk tua nee inika'a jiba uusek ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Intok senu bebeje'eri ka tu'i jiapsi a' kokkoba intok ini'i a' chatchaitua intok weettua, intok tenpo a' sommo'ochiatua. Intok jiokot au a' bittuaka intok ka a' su'u tottojibae. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jume' em majtimmeu ne jaibu a' nokriasuk, juka' ka tu'i jiapsita betana bempo'im a' tu'utene' betchi'bo, taa inime'e ka au yuumak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus inime'e inen yoopnak: ―Uu eme'e, ka tu'i yoemra kaita sualeme. Jakwoo tajtisa ne inim emomak aneka inien emomak ino bitne. A'abo a' tojinee juka' em yoemiata ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Taa junak juka' usita weiyaawao, ju'u ka tu'i jiapsi junae ko'okoae juchi a' wettuak. Taa Jesus, ju'u ka tu'i jiapsitat nesaweka juka' usita tu'utek. Junak intok a' yo'owamak a' simtuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Intok si'ime, ju'u Liojta utte'aka a jita a' joa'u betchi'bo suum ean. Inime'e si'ime ket junuen, ju'u Jesujta jita a joa'u betchi'bo am suum eao su, aapo, jume' a' majtimmeu: ");
INSERT INTO yaqNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Inika'a em tu'isi mammate, intok ka aawas koptine. Inepo, ju'u inim yoeme, ka tu'i yoemem mampo su'u tojitune ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Taa inime'e, aapo'ik ameu teuwaa'ut ka ju'unean, bwe'ituk ka aet ju'unee i'awan. Intok inime'e, junae betana machisi a' teuwaane' betchi'bo, au nattemaineeka juni'i, majjaen. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Junak intok jume' a' majtim, bempo'im nasuk jabeta che'a a' eiyaatunee'u betana aet nau etejo japtek. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Taa Jesus inimmet ju'une'eak, jachin bem emo eetua'ut. Junak intok aapo, ili usita yeu pu'aka, ae naapo a' kechak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Intok inimmeu: ―Inika'a ili usita, nee betana a' weye' betchi'bo, ju'u tu'isi a' mabetakame, nee junuen mabetlatune. Wa'a intoko nee junuen tu'isi mabetakame, ketchia junuen, a'abo nee bittuakamta mabetlatune. Ju'u emo nasuk che'a ka eiyaawaka bitwame, ini'i junen che'a eiyaawametune ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Junak ju'u Joan inen au jiiak: ―Yee majtame, senuk te bitlaa, inika'a, em team teuwaaka jume' ka tu'i jiapsekamta tu'utemta. Itepo intok, ka itomak a' weama' betchi'bo, ka junuen junaka'a an saek. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Taa ju'u Jesus inimmeu: ―Kate'em au suuane, bwe'ituk ju'u ka itom beje'eka aneme, ini'i itomak ea ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Junako juka' taewaita, Jesujta teekau bicha a' nottineeo abe a' yumao, aapo junaet tua kaachin au eetuaka, junaman bwe'u jo'ara Jerusalen tea'u bicha yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aapat bat watem bittuakai. Inime'e intok, ili bwe'u jo'ara, bwiaraa Samaaria' tea'po kateka'u bicha, junuen junama a' yebijnee'uta a' jariu betchi'bo aman yajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Taa ju'u junama'a yoemra, ka ama a' mabetbaaek. Bwe'ituk inime'e, Jerusalen tea'u bicha a' weye'po ju'uneakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jume' a' majtim, Jakoobo intok Joan teame, inien a' ju'uneiyaakai, inime'e: ―Achai, jaisa tu'inee ja'ani, itepo a teeka betana tajita ko'om simtuaka junuen inime'e am lu'uta betchi'bo, juka' Liojta betana noktuawakamta Eliaj tuka'uta ayuka'a benasia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Junak ju'u Jesus am nok tejwaak: ―Eme'e ka ju'unea, iniat jitat enchim jiapseka'po ―ti ameu jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bwe'ituk ju'u emo benasi yoeme, ka yee su'a betchi'bo inim yebijlaa. Ala yee jinne'ubaekai. Junak intok bempo si'ime, omot, ka yu'in jo'arau bicha sajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bempo'im junuen bo'o joa'po, senu Jesujtau: ―Achai, jakun juni'i em yebijnee'u, ne emak weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Junak ju'u Jesus iniau: ―Jume' kawisim bem bwia wojo'oriam jipue, intok jume' wikitchim totosak. Taa ju'u inim yoeme, jakun a' yebijnee'uta juni'i, ka jipue ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ju'u Jesus, senuku: ―Nemak weene ―ti au jiiak. Taa juna'a: ―Achai, nee bo'o bitne, in yo'owata muksuka nee a' ma'a'u tajtia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus inen a' yoopnak: ―Kat aman weama. Ela'apo jume'e, Liojta bichapo ka jiapsame bebena, jume' bem kokkoarim ma'ane. Taa empo nemak eaka Liojta yo'otaka a' kateka'a betana juka' nok lutu'uriata teuwaa simne ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Junak intok juchi senu inen au jiiak: ―Achai, emak ne weene, taa in jo'au jo'aakame bat nee aman tejwaatua ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Taa ju'u Jesus inen au jiiak: ―Wa'a mo'iti taiteka intok chukula amau bitchukame, ini'i, Liojta che'a yo'otaka a' kateka'a betana tekileu ka au yuma'ane. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iniat chukula ju'u yo'owe Jesukrijto ket juchi wate, baji taka ama woj mamnim yeu pu'ak. Intok inime'e, wo wooim nau, si'ime bwere jo'arammeu intok ka bwere jo'arammeu aapo'ik wa'am weenee'u, aapat naas am bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ket inen ameu jiiak: ―Lutu'uriapo jume' jinne'uimtuneeme, echita waksuka'a benasia machika, tua juebena. Taa jume' tekilta ya'aneeme tua ka juebena. Junuen san eme'e, ju'u iniau yo'otau bicha noknee, aapo'ik, jume' tekilta ya'aneeme a' tekileu am bittuane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eme'e yeu katnee, enchim bwaaram benaka, jume' roobom ane'u bicha in enchim bittua'po ju'uneakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Enchim ama nu'uu sakanee'uta oo kia tomita ama enchim weiyaanee'uta intok kia bocham juni'i ka naa buusti weiyaane. Intok eme'e bo'ot kaabeta binwa tebotuaka etejobaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Eme'e, jak jo'arapo juni'i yajakai, che'a bat eme'e: “Liojta betana tu'ika emo maktune”, ti ameu jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Intok junama'a wame'e jo'aakame, juka' Liojta betana tu'ik a' mabetbaao, junuen enchim ameu teboteka'uta ame betchi'botune. Taa ka emomak am eao, junuen enchim ameu teboteka'uta ka inime' betchi'botune. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jak juni'i enchim yajaka'po, junama'a wepul jo'arapo jiba tawane. Intok juname'e bem jipue'uta bwa'ane. Bwe'ituk ju'u tekipanoame, tomita a' koba'anee'uta au lutu'uriak. Ka eme'e o'omot su yajine. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jak senu ili bwe'u jo'arapo yajaka, enchim mabetwaka'po, junama emou tojiwamta bwa'ane. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Junama'a jume' ko'okoeme eme'e am tu'utene. Intok inimmeu: “Liojta inim bwiapo a' nesaunee'u abe yuuma”, ti ameu jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Taa eme'e senu ili bwe'u jo'arau yajaka, junama ka mabetwako, eme'e junama'a jo'arapo amet naj katwa'ummet yeu sajaka intok inen jiunee: ");
INSERT INTO yaqNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Kia itepo inim enchim bwe'u jo'arapo juka' bwiata, wokpo itot cha'atukamta juni'i, itepo te emo bichapo a' tatake, junuen ka tu'isi enchim aula'uta enchim a' ju'uneiyaane' betchi'bo. Taa juka' Liojta inim bwiapo yo'otaka a' nesaunee'uta, abe a' yuma'u, inika'a ju'uneiyaane”, ti ameu jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Inepo ne inika'a inen emou teuwaa, Liojta yee aet ya'uraa bittuanee'u taewaita yumako, jume' junama'a bwe'u jo'arapo jo'aakame betchi'bo, che'a juni'i jiokot machine, jume' bwe'u jo'ara Sorooma' tea'po jo'aasukame bepa. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Tua jiokot emou machine, bwe'u jo'ara Korasin tea'po jiapsame. Tua jiokot emou machine, bwe'u jo'ara Betsaira' tea'po jiapsame. Bwe'ituk inika'a ka a jootu maisi machika, emo nasuk ya'ari, jum bwere jo'aram Tiiro intok Siroon tea'po ini'i ya'atuko, jume' junakriapo jiapsame a' bichako, jakwoo su emo temaisu ean intok chukuik atteateka intok kobat emo napojtuaka, bem sioka'uta teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Taa juka' taewaita yumako, junuen Liojta yee ya'uraa bittuaneeo, eme'e che'a juni'i jiokot emo bitne, jume' bwere jo'aram Tiiro intok Siroon tea'po jiapsaka'um bepa. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Eme'e intoko, bwe'u jo'ara Kapernaom tea'po jiapsame, jaisa eme'e teekau enchim yajinee'u, emo uttia machia ja'ani. Ala eme'e, jume' kokkoarim yaaja'u tajtia ko'om tojinaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Wa'a enchim jikkajineeme, nee junen ket jikkajilatune. Wa'a intok ka enchim eiyaaka ka enchim mabetakame, nee junen ket ka mabetlatune. Wa'a intok, ka nee eiyaaka ka nee mabetakame, Liojta juka' nee a'abo bittuakamta junuen ka mabetlatune. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jume' baji taka ama woj mamni naj bittuawakame, tua alleaka nottek: ―Achai, kia jume' bebeje'eri ka tu'i jiapsim juni'i, ee betana utte'ata itot ayukamtae, itom ameu nokao, inime'e itom nok jikkajak ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus inimmeu: ―Lutu'uria, bwe'ituk jiba ineponee a' bichak juka' bebeje'erita, teeka betana yuku be'oktiata benasi ko'om a' wecheko ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jiba inepo nee emot a' autuari, enchim au yuma'anee'u jume' bakotchimmet intok jume' machilimmet juni'i a enchim cheptine' betchi'bo, intok kia si'ime bebeje'eri utte'ata enchim a' koba'ane' betchi'bo, tua kaachin eme'e anekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Taa ka eme'e alleenee junuen jume' bebeje'eri ka tu'i jiapsim enchim teuwaa'uta bem a' joa' betchi'bo. Ala, teekau, Liojta jiapsa'u enchim lutu'uriaka'uta ju'uneiyaakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Junama lautipo ju'u Jesus, Liojta tu'u jiapsi betchi'bo tua alleaka inen jiiak: ―Enchi ne baisaeka enchi yo'ore in achai, bwiapo intok teekau yo'owe. Bwe'ituk empo, inika'a ee betana lutu'uriata, inime'e ili usim benam, ka emo che'ewaremmeu em am ju'uneiyaatuari betchi'bo. Intok jume' koba susuakame intok jitat ju'uneammeu em essoka'u. Jeewi in achai Lios, bwe'ituk empo su junuen a' tu'urekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Ju'u in achai Lios, kaita yeu be'eka, si'imeta in mampo su'u tojilaa. Kaabe ju'unea juka' usiwaita a' jabetuka'uta taa ju'u achaiwai, aapo jiba. Intok kaabe ju'unea juka' achaiwaita a' jabetuka'uta, taa ju'u usiwai jiba. Intok wame'e, inika'a usiwaita aapo'ik, junaka'a a' ta'aatuabae'um jiba. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Junak intok ju'u Jesus jume' a' majtimmeu bitchuka omola bempolaimmeu inen jiiak: ―Tua alleene, jiba inika'a i'an enchim bicha'uta, wame'e ket a' bichame. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bwe'ituk inepo ne inen jiia, juebenaka jume' bat naataka Liojta betana ju'uneetuawaka yeteu nokakame, intok jume' inim che'a yo'o ya'arim, inika'a i'an enchim bicha'uta, a' bitbaek, taa ka a' bichak. Intok inika'a i'an enchim jikkaja'uta, a' jikkajibaek, taa ka a' jikkajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Junak intok seenu, Moiseejta nesaurim yee majtame, ini'i junama Jesujtau ruktek junuen a' ji'optuabaekai. Intok ini'i inen au nattemaek: ―Yee maj majtame, jitasa tu'ik nee yaaka, juka' jiba yuu jiapsiwamta bitne ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus inen a' yoopnak: ―Jum Moiseejta nesauri ji'ojteimpo jaisa ji'ojtei ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ju'u Moiseejtuka'uta nesaurim yee majtame inen a' yoopnak: ―“Juka' em yo'owa Liojta, ka jiapsita bepa a' nak yo'orine, intok ket tua em tu'u eeriae intok alleaka em jiapsa'ue intok em a jita mammate'ue a' nak yo'orine. Intok empo, juka' ele benasi inim yoemta, em emo eiya'a benasia a' naknee” ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Junak ju'u Jesus iniau: ―Tua empo amma'ali jiia. Inika'a em teuwaa'uta ya'ane, intok empo jiba yuu jiapsine ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Taa ju'u Moiseejtuka'uta nesaurim yee majtame, aapo'ik ju'u a' nattemaeka'u betana, lutu'uriata au jipu'uleka: ―Jabesatunee ini'i, ju'u nele benasi yoeme ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ju'u Jesus junak inen a' yoopnak: ―Senu yoeme, bwe'u jo'ara Jerusalen tea'a betana bo'ot senu bwe'u jo'arau Jerikoo' tea'u bicha ko'om weyen. Inika'a intok, waate, jita yee u'aame au yeu sajaka, si'imeta a' u'uraak, kia a' tajo'oriwa chiktia. Inime'e ket ko'okosi a' yaaka intok batte mukiata ama to'o sajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tua junak su seenu, te'opopo tekiakame jiba junae bo'ot weyen. Taa ini'i, junaka'a bichakai, naa buusti siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ketchia seenu, ju'u Lebi'ituka'uta yoemiam betana yeu simria, ini'i junaet cha'aka ama yepsak. Ini'i intok junaka'a bichakai, kia ama naa buusti siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Taa senu yoeme, bwiaraa Samaaria' tea'a betana jometakai, jiba junae bo'ot weyeme, ini'i junaka'a bichakai, tua a' jiokolek. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Junak intok, inia o'outau ruktek. Inika'a, ko'okosi a' ya'aripo, ochokokue intok pa'asi ba'awae a' jittok. Tettebe tajo'orimmea a' sumakai. Chukula intok inika'a, aapo a' kaba'it a' ja'amutuak. Senu jo'arau a' reu jinula'u a' tojakai intok junama'a a' suuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yokoriapo juna'a Samaaria' tea'po joome, simekai, wooi tosai tomim yeu wikeka intok junaka'a, junama'a jo'aakamta am miikak. Intok inen au jiiak: “Inika o'outa nee suuariane, intok empo naa buusti jita aet wiutako, inepo nottek ne enchi a' beje'etuane”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Junak su, juname bajim betana, empo jabesa tua juna'atuk ti ea ju'u, jume' jita yee u'aame betana ko'okosi ya'awakamta, aapo'ik au a' eiya'a benasi junaka'a eiyaakame ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ju'u Moiseejta nesaurim yee majtame: ―Ju'u, junaka'a nak jiokolekame ―ti au jiiak. Junak ju'u Jesus: ―Beja ma, empo ket jiba inile benak bo'o jooriane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus ketun a' sika'u bicha bo'o joaka intok senu ili bwe'u jo'arau yeu yepsak. Junama'a intok senu jamut, Maata' teakai a' jo'apo a' mabetak. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ini'i Maata' teame, senuk Maria' teamta jamut waekan. Ini'i aapo Jesujta wokiu yejtek junuen juka' aapo'ik teuwaa'uta jikkajibaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Taa Maata, juebenaka a' joo machikut tua obisi au bichan. Intok aapo Jesujtau rukteka inen au jiiak: ―In yo'owa, jaisa empo a' tu'ureka a' bicha ja'ani, juka' in waai inim tekilpo ka nee a' ania'uta. Nee a' ania saune ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Taa Jesus inen a' yoopnak: ―Maata, empo juebena weyemtat emo obisi eetua intok ka allea. ");
INSERT INTO yaqNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Taa wepu'ulaika jiba aayuk ju'u lutu'uriapo obisi aet emo bit'eewame. Ini'i Maria inika'a che'a tu'ik yeu pu'ari. Intok inika'a, kaabe a' u'uraane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sejtul juka' Jesujta ama jakun, Liojtau bicha a' nokaao, intok junako a' ansuko, a' majtim betana seenu: ―Achai, Liojtau bicha itom nokne' betchi'bo itom majtane, juka' Joanta jume' aapo'ik majtim a' majtaka'a benasia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus inen ameu jiiak: ―Eme'e Liojtau bicha noka'ateko, inen eme'e jiunee: Itom yo'owa, teekau katekame, eu lutu'uriatunee si'imem betana em yo'orinaa'u. Che'a yo'otaka em nesawee'uta, inim tee a' bitne. Ju'u em joo i'a'uta inim bwiapo ya'atune, junuen jum teekau benasia. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Inia taewait juka' itom bwa'anee'uta, yuma'isi itou a' autuane. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Itom ka tu'uwa ya'arimmet itom jiokoine, bwe'ituk ket te itepo, si'imem jume' ka tu'ik itou ya'alame, am jijiokoe. Aet itom ji'opnee'u, kaita itou autuane. Ala, ka tu'ik betana itom ania. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ju'u Jesus ket inen ameu jiiak: ―Maasuko, senuk emo betana te iniat inen jiune. Juna'a jabeta a' ta'aa'uta ayuka, intok ini'i nasuk tukaapo a' jo'au yepsaka, iniau: “Empo, in nake'u, paanim bajim nee reuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Bwe'ituk seenu, in ta'aaka in eiyaa'u, mekka betana, ju'ubwa in jo'au yepsa. Intok inika'a nee kaita a' mik machi”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Maasu juna'a senu intok ket, wajiwa aneka, a inen a' yoopna ean: “Kat a'abo neu suua. Patti ju'u pueeta. Intok jume' uusim inim nemak to'oka. Kannee a yejteka jita eu toja”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Junuentaka juni'i, ini'i junuen yejteka, ka tua kia aapo'ik a' ta'a' betchi'bo jiba, ala junuen, ka naa buusti au a' suane' betchi'bo, si'imeta a' waata'uta a' mikne. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Junuen san inepo inen emou jiia, enchim waata'uta a'aune, ju'u Lios intok emou a' autuane. Juka' emou be'eemta jariune, intok eme'e a' bitne. Intok pueetata pona'ateko juni'i, eme'e a' etaporianaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bwe'ituk ju'u, a' waata'uta a'awame, a' mabetne. Ju'u intoko juka' au be'emta a' jaiwame, a' bitne. Intok kibachanaa, ju'u, pueetau weyeka a' poname. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Kaabe aane emo nasuku, yoemiaka, a' usiwa paanim a' a'awao, tetata a' mikbaaneeme. Oo kuchuta a' a'awao, bakotta a' mikbaaneeme. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Oo totoi kabata a' a'awao, machilta a' mikbaaneeme. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Eme'e junuen, ka tu'i yoememtaka juni'i intok jume' enchim yoemiam, tu'ik enchim am miknee'uta a' ta'a'ateko, jiba tua ju'u enchim achai Lios, teekau katekame, wame'e junuen aapo'iku bicha, juka' a' tu'u jiapsiwata a'awame, aapo tua lutu'uriapo amet a' jiapsituane. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Juka' Jesujta, senuk, inika'a, bebeje'eri ka tu'i jiapsi aet aneka, junae ka nokamta, aapo'ik a' tu'uteo, intok junak, inika'a bebeje'eri ka tu'i jiapsita yeu siiko, ju'u ka noka'u, a nookak. Ju'u bu'uura ama aneme, iniat a' uttiaka taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Taa waate inen jiiak: ―Ini'i o'ou, jume' bebeje'eri ka tu'i jiapsim yeu beba o'oben, taa jiba ju'u, inimmeu yo'owe, Be'elsebuul teamta utte'ae, a jita a' joa'ue a' joakai ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waate ket a' ji'optuabaeka, junuen teeka betana machilaata a' ju'unakte saen. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Taa ju'u Jesus, inime'e jachin bem emo eetua'po ju'uneakai inen ameu jiiak: ―Jitaa bwiaraapo juni'i, ju'u ama yoemratau yo'oora au na'ikimteka, emo beje'eka nau nassuakai, inime'e emo lu'utane. Intok kia jume' nau wewerika, senu jo'araapo jo'aakame, inime'e ka nau eakai, ka a nau jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Junuen san ket, ju'u bebeje'eri, juka' aapo'ik sawe'uta bebeje'erita yeu beba'ateko, ini'i, aapo au beje'eka anne. Junuen san, ju'u a' nesawee'u kaachin binwatune. Inika'a ne teuwaa junuen, enchim, jume' bebeje'eri ka tu'i jiapsim, ju'u bebeje'erimmeu yo'ota, Be'elsebuul teamta utte'awae, yeu ne am beba'ati jia' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Taa inientuko, jabesa, jume' waatem emomak eame, inime'e ka tu'i jiapsim yeu am bep betchi'bo, jabesa utte'a amet autua. Junuen san, jiba juname'e, enchim ji'oplatuka'uta a' teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Taa inepo jiba ju'u Liojta utte'awaesan nee jume' bebeje'erita ka tu'i jiapsim yeu am beba. Ini'i intoko, Liojta che'a yo'otaka inim bwiapo a' nesaunee'u, inim a' yuma'aseka'uta a' teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Yoemta seenuk, ousi au eiyaamta, inika'a, ju'u ae au a' anianee'uta jipueka, intok inika'a a' jo'arata a' suuao, junama'a ju'u a' suua'u, kaita au weene. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Taa inika'a beje'eka, senu che'a ae bepa utte'aka ama yepsaka intok a' yu'ukai, junak ini'i, ae a' nassuanee'um, si'imem a' u'aane. Intok si'imeta juka' a' jo'araapo a' nu'uka'uta, a' na'ikimtene. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Wa'a ka nemak eame, juna'a, nee beje'eka aane. Wa'a intok, ka nemak eaka, jume' jinne'uimtuneeme nau totojame, ini'i junuen, ka a am jinne'u tebo. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ju'u bebeje'eri ka tu'i jiapsi, jabe senukut yeu siiko, junak ka anwa'abe'emu weamne, jak a' yebijnee'uta jaiwakai. Intok junuen, ka a' teakai, junak: “Jumun in yeu sika'u ne nottibae”, ti eene. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Junuen nottekai, junaka'a yoemta aet yeu a' sika'u, karita kaabeta ama ane'ebenak a' teune, ujyoika intok chi chikrita benak. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Junak intoko ini'i, sikaa, intok juchi woo busanim jume' bebeje'eri ka tu'i jiapsim, che'a juni'i ae bepa ka tuttu'im nu'upane. Intok juname'e si'ime, jiba junae o'outat tawabaeka aet kimune. Chukula intok ini'i, che'a juni'i, bat naataka bepa machika tawane. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Juka' Jesujta ketun inien weyemtat a' nokao su, ju'u bu'uuraata betana senu jamut chaaen: ―Tua alleewamta bitnee wa'a jamut, inim enchi yoemiaka intok enchi yo'oturiakame ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Taa aapo inen jiiak: ―Alla che'a tu'isi tua alleenee wame'e, Liojta noki jikkajaka intok a' teuwaa'uta joaka jiapsame ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ju'u yoemra junama Jesujta ane'u, che'a juni'i bu'uuka au nau yajan. Aapo intok nokaka, inen ameu jiu taitek: ―Ju'u yoemra i'an jiapsame, ini'i ka tu'i yoemra. Intok ket, in a jita joa'ue aman machilaata bitbae. Taa inime'e, kaita intoko naa buusti machilaata bittuanaa. Taa kia juka' Jonaj teamta ju'u a' yaaka'u benak jiba bittuanaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bwe'ituk juka' Joonajtuka'uta, bwe'u jo'ara Ninibe' tea'po jiapsaka'ummeu aapo'ik a' machilaatusuka'a benasia, ketchia junuen ju'u inim yoeme i'an yoemra inim jiapsammeu machilaatune. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Juka' taewaita, Liojta yee aet a' ya'uraa bittuanee'u yumako, juka' yoemrata a' ya'uraa bittuanaao, wa'a jamut ya'ut, sur betana joome ama annee. Intok ini'i, juka' yoemrata i'an jiapsamta, ka tu'isi a' tawaane. Bwe'ituk ini'i jamut, aapo junama'a che'a mekka a' bwiaraa betana juka' yo'o ya'ari Salomontuka'uta, tua a' koba suawaka'uta, jitat a' ju'unea'uta aet a' jikkajibaeka yepsak. I'an intok inimi'i, senu ju'u Salomontuka'uta bepa che'a eiyaawatchika aane. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wame'e, bwe'u jo'ara Ninibe' tea'po jiapsisuka'um, inime'e, taewait Liojta yee ya'uraa bittuaneo ama anne. Intok junak juka' inim yoemrata ya'uraa bittuanao, inika'a, bempo ka tu'isi a' tawaa tebone. Bwe'ituk jume' junama jiapsisuka'um, juka' Jonaj tuka'uta, Liojta betana nok lutu'uriata ameu a' teuwaako, bempo, ka tu'ik betana emo temaek. I'an intok inim, ju'u Jonaj tuka'uta bepa senu che'a eiyaawatchika aane. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Kaabe, senu tachiriata tayaka intok inika'a, kobi'ikut a' mana'abaane. Intok kia senu jita ama e'eria betchi'bo ya'arita betuk juni'i. Ala ini'i, jikat a' mana'ane, junuen junama jume' kimummet a' tachiriane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jume' puusim senuk betchi'bo, tachiriata benasi maachi. Junuen san ketchia, jume' em puusim tu'ireako, si'ime ee betchi'bo mamachine. Taa jume' em puusim ka tu'ireako, ketchia, si'ime ee betchi'bo ka mamachi benane. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aet emo suuanee juka' Liojta betana weyeka em ju'uneiyaa'uta, inika'a ka ta'abwisi em a' nayyotene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bwe'ituk empo junuen yuma'isi si'imeku Liojta lutu'uria weiyaaka jiapsakai, kaita ka tu'ik ta'abwisi joakai, junak si'imeku machisi empo ju'unakkiachisi a' ju'uneiyaane, junuen tachiriata tajpa'ala et a' machiaka'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Juka' Jesujta a' noksuko, jume' paiseom teame betana senu a' jo'au a' ji'ibwa nunuk. Ju'u Jesus junama yepsaka, mesau yejtek. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ju'u paiseo kaachin jiu machiakan, aapo'ik Jesujta ka bempo'im junuen au joiwalatuka'po aman, ji'ibwabaeka, ka junaen mam bajimaka ji'ibwakamta bichakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Taa ju'u yo'owe Jesukrijto iniau inen jiiak: ―Eme'e jume' paiseeom teame, juka' baasota intok juka' pu'atota pa'ariatana tu'isi am baksiane. Taa eme'e intok, wajiwa tana, jita etbwaka intok ka tu'ik yaaka enchim nu'ula'ue, junae tappuni. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ka suawa'am, eme'e ju'unea, ju'u juka' takaata yaakamta, ket juka' jiapsita aet katekamta a' yaaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Junuen san eme'e, juka' watemmeu bicha enchim nana'ikia'uta, tua junen jiaka a' joonee intok junuen si'ime enchim joa'u, Liojta bichapo tu'ine. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Tua jiokot emou machinee eme'e paiseeom teame. Eme'e ju'u juya menta' teamta betana intok ju'u juya ruura' teamta betana intok si'ime jume' ji'um betana, juka' Liojtau bicha weyemta eme'e au a' na'ikia. Taa eme'e juka' si'imeku lutu'uriata bo'o jooriawamta ka a' chupa'ala intok juka' Liojta enchim nak yo'oree'uta eme'e kia beja a' bicha. Ini'i juna'a ju'u enchim joo'ea'u. Taa junae ju'u wateku mak nawi. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Tua jiokot emou machine, eme'e paiseeom teame, bwe'ituk eme'e jum te'opompo che'a bichau wajiwa, yo'owam jojoye'po enchim jojo i'a. Intok eme'e jum bwe'u jo'aapo amet naj katwa'po si'imem betana tua yo'orisi enchim am tetebotua i'a. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Tua jiokot emou machine, eme'e paiseeom teame, ka tu'u yoememtaka juni'i, emo tu'u joame. Bwe'ituk eme'e jum kokkoarim ama ma'aritaka ka ju'uneiyaawame bebena. Jume' intok naj rejteme ame bepa naj kateka juni'i, ka ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Junak intok jume' Moiseejtuka'uta nesaurim yee majtame betana seenu: ―Yee majtame, inika'a empo teuwaaka, ket itom ka alleetua ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Taa ju'u Jesus inen au jiiak: ―Tua jiokot emou machine, eme'e Moiseejtuka'uta nesaurim yee majtammeu. Bwe'ituk eme'e unnaa bettek yee majtaka, juka' jeela juni'i ka a jootumta, intok eme'e, watem junaka'a joo i'a. Taa eme'e intoko kia ili juni'i ka a' bo'o jooriabae. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Tua jiokot emou machinee bwe'ituk eme'e, jume' bat naataka Liojta betana ju'uneetuawaka yeteu noktuawakame, jiba jume' bat naataka enchim yo'owasuka'um su'aka'um, eme'e jum bem ma'ari'po bepa jitae ujyooi karim benam am jooria. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Inien enchim joa'ue, juka' bat naataka enchim yo'owasuka'um yaaka'ummak enchim ea'uta a' teuwaa. Bwe'ituk bempo am su'ak, eme'e intoko junama'a juname'e ma'aripo bepa ujyooi karim benam am jooria. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Inia betchi'bo ju'u achai Lios, aapo'ik suawae a' nok lutu'uriapo inen jiiak: “Inepone, jume' nee betana chukula yeu weenemta tetteuwaame intok jume' in yeu pu'arim ne emou bittuane. Inime'e betana intok eme'e, watem su'anee watem intok jiokot emo bittuane.” ");
INSERT INTO yaqNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bwe'ituk ju'u Lios, juka' i'an yoemrata, si'imem jume' Liojta betana noktuawaka yeu pu'arim, Liojta aniata ju'unaktewak naateka, jume' su'awakame betchi'bo, inime'e, bempo'im a' yaaka'a benasi amet a' bitne. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ju'u che'a bat Abeltuka'uta me'ewaka'po naateka, ju'u Sakariaj teamta, jum te'opopo, Liojta yo'oriwa'po intok jum bwaram aet susu'awa'po, inime' nasuk enchim me'aaka'u tajtia. Inia betchi'bo ne inen emou jiia, ju'u Lios, juka' yoemrata i'an jiapsamta, bempo'im a' yaaka'a benasia amet a' bichaka am ya'uraa bittuane. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Tua jiokot emou machine, eme'e Moiseejtuka'uta nesaurim yee majtame, bwe'ituk eme'e Liojta betana nok lutu'uriata betana eme'e jiba a' ju'uneiyaaka a' eta'i bebena. Taa eme'e junae enchim jinne'uimtune' betchi'bo ka a emo ania. Intok kia jume' jinne'uim tubaeme eme'e ka a junuen am autua. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Juka' Jesujta inika'a weemta ameu a' teuwaasuko, jume' Moiseejtuka'uta nesaurim yee majtame intok jume' paiseeom teame, tua ka aamak alleaka taawak. Intok inime'e, tua juebena weemta au nattemaeka suati a' bit japtek. ");
INSERT INTO yaqNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Inime'e, jitae a' ji'optuaka, junuen jitaa a' teuwaaka'ue juni'i, a bem a' na'atejonee'uta jaiwakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ket junuen a' weyeo su, ju'u yoemra junama'a, ka iliikika, juebena miiltaka ama au yajan. Junuen juebenaka kia ama nat chep chepteka juni'i. Intok ju'u Jesus, a' majtimmeu bat inen jiu taitek: ―Eme'e, jume' paiseeom teame betana, reberuatau a tamachiatuka, ka lutu'uriae bem emo tu'u joa'u betana emo suuane. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bwe'ituk si'ime ju'u ka ju'uneiyaawaka bo'o jooriawame, chukula ju'uneiyaatune. Intok si'ime ju'u etbwa bo'o jooriawame ket chukula ju'uneiyaatune. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Inien san, si'imeta juka' ka machiku enchim teuwaaka'uta, juna'a, taewapo jikkajitune. Intok kaabeta ane'epo, oo karipo wajiwa ju'u enchim teuwaarita, ini'i, chukula kari jikat betana kusisi teuwaatune. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Emou, jume' tua in nak ta'aa'ummeu ne inen jiia, jume' inim itom takaam a su'ame, taa intok chukula inia bepa ka tu'ik kaita intok a joame, inime'e ka enchim majjaunee'uta ne emou teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Taa jabeta ala enchim majjaunee'uta ne enchim tejwaabae. Juka' jiapsiwamta senuk u'aasuka, aet chukula, taji jiba yuu beete'po a yee tawaa betchi'bo utte'akamta ala eme'e majjaune. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Eme'e ju'unea, mamnim jume' ili wikitchim, inime'e wooi ili tomipo am nenenkiwa'po. Taa ju'u Lios, inime'e betana wepu'ulaik juni'i ka koptai. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bwe'ituk kia jume' kobat enchim choonim juni su, si'imem we'epulaka na'ikiarim. Ka eme'e majjaunee bwe'ituk eme'e su, che'a juni'i tua juebena ili wikitchim bepa che'a eiyaawa. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ineponee emou inen jiia, si'imem jume' inim yoemrata bichapo net eaka ne tana bem kate'uta junuen a' lutu'uriateme, inepo ju'u inim yoeme, ket in achai Liojta ankelesim bichapo inime'e nee betana am kate'epo junuen a' lutu'uriatene. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Taa wame'e intok, inim yoemrata bichapo ka nee tana emo kate'eti jiame, inime'e betana in achai Liojta ankelesim bichapo ket, ka bem nemak ea'uta ame tana teuwaanaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Intok jabetaka juni'i, inika'a inim yoemta beje'eka nokakame, ini'i a aet jiokoitune. Taa ju'u, juka' Liojta tu'u jiapsita beje'eka ka tu'ik teuwaakame, ka a aet jiokoitune. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Jum juriom te'opommeu oo jume' yetet nesaweme intok ju'u ya'uraata bichapo eme'e yeu tojiwako, eme'e ju'u enchim am yoopnaanee'u betana oo enchim teuwaanee'u betana ka jain eene. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bwe'ituk jak weyeo enchim emo nokrianee'uta a' yumako, ju'u Liojta tu'u jiapsi enchim aet ju'uneetuane, tua jachin enchim teuwaanee'ut. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ju'u bu'uurata betana senu Jesujtau inen jiiak: ―Empo, yee majtame, juka' nemak werik, au lutu'uriaka iniamak itom nau atteaka'uta, junama'a nee a' mak saune ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Taa ju'u Jesus iniau: ―E'e. Kaabe inim jitau nee yo'o ya'ari, intok kia jitaa in nat na'ikimte betchi'bo juni'i ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ketchia ju'u Jesus inen jiiak: ―Aet em bichaka, tu'isi aet emo suuanee si'ime ju'u jain juni'i jita waatiawamta betana. Bwe'ituk seenu, ka bu'uuk a' jipue' betchi'bo jiba jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Junak intok ju'u Jesus inia ta'abwiku a' tamachiaka ameu nookak: ―Seenu, tua yu'in tomeka jiapsan. Intok inia waj bwiam tua yu'in chupuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ini'i yu'in tomekame intok junak: “Jaisa ne tua anne”, ti ee taitek. “Jak ne ka a' kima'amachi juka' bachiata.” ");
INSERT INTO yaqNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chukula intok inen aubaeka'eak: “Inen ne aunee: Jume' bachiata ama kima' betchi'bo karim ne am tatapnee junuen watem, che'a bwerem ya'a betchi'bo intok junama'a inepo si'imeta juka' bachiata intok in jipue'uta ne ama kima'ane”, ti eakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“Junak nee jaibu a inen jiunee: I'an ala nee juebena wasuktiam betchi'bo ne tua yu'in jita jipue. I'an naateka, yum jo'eka, ji'ibwaka intok jita je'eka nee tua alleene, ti ne a jiune.” ");
INSERT INTO yaqNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Taa iniau ju'u Lios: “Empo ka suawa'aa, jiba inia tukaariat empo mukne. I'an su ju'u em nau tojiri, jabesa tua aamak tawaneekai”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jiba inien au chuchupe, ju'u inim beje'emta jain juni'i aapo'ik betchi'bo jiba, nau totojamtau. Taa ini'i intok junuen, Liojta betana weyeka ayukamta, ili juni'i ka aet au eetuamtau. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chukula ju'u Jesus jume' a' majtimmeu: ―Junuen san nee inen emou jiia, eme'e, juka' enchim bwa'eeka jiapsinee'u betchi'bo intok kia juka' enchim tajo'otenee'u betchi'bo juni'i, kaachin eene. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bwe'ituk ju'u jiapsiwame, ju'u bwa'amta bepa che'a eiyaawatchi. Intok ju'u takaa, ju'u tajo'ota bepa che'a eiyaawatchi. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jume' konim eme'e mammatene. Inime'e ka e'echa. Intok kia ka bachiata tobo tobokta. Intok kia jak bem a' e'erianee'uta juni'i ka jipue. Taa junuentaka juni'i, ju'u Lios am mimika. Eme'e, inime'e wikitchim bepa che'a juni'i eiyaawa. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Intok emo nasuk tua kaabe, ini'i, ju'u tua unnaa jachin au a' eetua' betchi'bo, junaen, senu batata nasuk'aman juni'i, juchi a' yo'otuneeme. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Junuen, eme'e ka jaikiku juni'i ka yumakai, jaisaaka eme'e wate weemtat emo temaeka emo au yuma'amachia. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Jume' juyam sesewame jachin bem yoyyo'otune'po eme'e am mammatene. Inime'e kaita joaka, ka jiji'ika. Taa inientaka juni'i, kia ju'u che'a yo'o ya'ari Salomontuka'u, yu'in ujyoik atteaka juni'i, ka inime'e watem benasia ujyoisi machiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Junuen, ju'u achai Lios juka' i'an wajpo juyata, juka' chukula wakeka taya'atunemta, junuen ujyoisi a' joakai, aapo che'a juni san enchim tajo'onee'uta emou autuane, eme'e kaita a suale'am. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Junuen san beja eme'e ka jain emo eetuanee ju'u enchim bwa'anee'u betana intok enchim ji'inee'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bwe'ituk jume'e, ka Liojta sual ta'aame, si'ime inia weemtat jiba jiapsek. Taa ju'u enchim achai Lios, si'imeta inika'a emou a' be'ee'uta ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Taa eme'e emo betchi'bo Liojta betana weyeka enchim jiapsimmeu tu'i'eamtat aet emo temai sakanee intok si'imeta inika'a waatek chukula eme'e ket a' miknaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Bwalam benasi in eiyaa'um, ka eme'e majjaune. Tua eme'e iliiki o'oben, taa ju'u enchim achai Lios emo betana inien aapo'ikumak yo'otaka enchim annee'uta junuen a' waatak. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Juka' enchim jipue'uta eme'e nenkinee intok eme'e, jume' jiokot eame mikne. Intok junuen ayuka, si'imeta bepa eiyaawatchika, ka lu'utineemta intok ka moineemta, teekau junuen jipu'ubaekai. Junaman juka' jita e'etbwamta ka anne'ewi intok kia jume' yoeriam, kaita a momoiya'awi. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bwe'ituk eme'e, jum juka' eeiyaawatchika, beje'emta enchim jipue'po, junaman ket eme'e jiba aet jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Jiba eme'e ka emo koptaine, ka machiku tachiriam jiba nunu'ubwame benakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Eme'e, kia jume' tetekokame benasi eene. Inime'e, juka' bem teko, jum jujupwa'u betana nottinemta a' bo'o bichame benakai. Junuen aapo'ik yepsaka, pueetata a' poponak sep a' etaporia betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tua alleenee jume' tetekokame, inime'e bem teko, ka kokochemmeu a' yebijnee'um. Tua lutu'uriapo ne inen ne emou jiia, jiba aapo ju'u bem teeko, mesau am joaka aet jiapseka, aapo am a'abojne. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ela'po inika'a nasuk tukaapo oo abe matchuu a' yebijneeo juni'i, junuen ka kokochemmeu yepsakai, inime'e a' tekokame tua lutu'uriapo bem allea'u ameu aune. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Intok eme'e inika'a ju'uneiyaane, waka'a jo'aakamta, inika'a jak weyeo juka' jita nunu'emta a' yebijnee'uta a' ju'uneao, inika'a ka kot'ea'u, intok jum kariu jita etbwa betchi'bo, ka aman a' kibaktua'ea'u. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eme su juni ketchia, jiba junaen yuma'isi, kaita emou be'eeka a' bo'o bitne. Bwe'ituk tua ka au waatiwao su yebijnee ju'u emo benasi yoeme. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Junak intok ju'u Peeo: ―Achai, inika'a ta'abwiku a' tamachiaka em teuwaaka'uta, jaisa empo ito betchi'bo jiba a' teuwaak, oo si'imem betchi'bo ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ju'u yo'owe Jesukrijto inen jiiak: ―Inile benasi mamachinee ju'u yo'ota tekilta a' jooriame. Ini'i suawaka intok ka ta'abwisi eame. Inika'a, ju'u a' tekowa a' jo'aapo jume' a' yoemiammeu a' to'o simnee'u, juname'e aapo'ik am ji'ibwaneeo, junak am ji'ibwatuane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tua alleenee ju'u tekokame, ini'i, ju'u a' tekowa nottekai, junuen juka' tekilta a' joo'ea'uta, a' joaka teunaame. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Lutu'uriapo ne inen emou jiia, junaka'a, ju'u a' tekowa, si'imeta a' atteabeu, aapo'ik au yo'otaka a' kecha'ane. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Taa juna'a tekokame intok, juka' a' tekowa ka lauti a' nottine'eti eaka intok ini'i, jume' waate tekokame intok jume' jaamuchim ama tekipanoame, ka tu'isi am bichaka intok ji'ibwawamta intok nanaakowamta weetuaao, ");
INSERT INTO yaqNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","junako, wa'a a' tekowa, taewait intok jak weyeo, juka' a' tekokamta ka a' bo'o bichao su yebijne. Intok inika'a tua ka a' jiokoleka, unnaa bettesi jiokot au a' chupa'ane. Intok jiba jume' Liojta ka sual ta'aame benasi au a' chupakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ju'u tekokame juka' a' tekowata joo i'a'uta ju'uneiyaaka taa ini'i ka aet jiapseka a' koptaikai, intok kia ka a' nok jikkajakai, ini'i tua bettesi jiokot ya'atune. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Taa ju'u tekokame, juka' a' tekowata joo i'a'uta ka ju'uneiyaaka intok ini'i ka a' joo'ea'uta joakai, ini'i ka tua bettesi jiokot au weene. Bwe'ituk wa'a che'a yuma'isi Liojta betana weyemtat ju'uneaka a' mabetlame, ini'i junae betana au waatianaa. Ju'u intoko che'a yu'in a' ya'anee'uta maki, ini'i junae betana au waatianaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ineponee bemelasi weyeka nok lutu'uriata, tajiu a tammachiatumta ne a'abo toji'isek. Intok inepo inika'a jaibu a' weetuapea. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Utte'a, ketun juka' unnaa jiokot in ino bitnee'ue in ji'obilaatune'po intok inika'a neu chupsu'u tajtia, tua ka in yanti ela'u neu aune. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Jaisa eme'e, yanti elwaka jiapsiwamta nee a'abo bwiau jiapsammeu ne a' weiya'ati ea ja'ani. Ka junueni, ala, ka nau eewaka jiapsiwamta ne a'abo weiyaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bwe'ituk i'an inim bichau bicha, mamnika nau werika, inime'e ka nau eene. Bajika, jume' wooim beje'ene. Jume' woika intok, jume' bajim beje'ene. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Inen weyekai, ju'u achaiwai, a' yoemiawata beje'ene. Ju'u yoemiawai intok a' yo'owata beje'ene. Ju'u malawai a' jamut asoawata beje'ene. Ju'u marawai intok a' malawaita beje'ene. Ju'u asekawai, a' jaboraiwaita beje'ene. Ju'u jaboraiwa intok a' asekawata beje'ene. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ju'u Jesus ket ju'u yoemratau inen jiiak: ―Eme'e, jume' naamum, ta'ata aman weeche'e betana jikau cha'atume bichakai, eme'e sep, i'an yukbae'eti jiia. Intok inien yeu weama. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Intok sur betana jekata buiteo, eme'e sep, i'an tattabae'eti jiune. Intok junuen tattae. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ka tu'i yoememtaka emo tu'u joame, eme'e, juka' aniata oo teekata jachin a' machiaka'uta bichaka, taewaim ju'une'eiyaa. Taa eme'e inime'e taewaimmet enchim amet jiapsa'ummet weenemta juka' a' teuwaa'uta eme'e ka a aet ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Jaisaakai eme'e ju'u che'a emou lutu'uriatu machik intok emou tu'i machik juni'i, ka aet a ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Senuk enchi a' beje'eeo intok enchi a' ya'uraa bittuaseko, ket aamak weyeka, aamak emo tu'utenee junuen ka ya'uttau bicha enchi a' su'u tojine' betchi'bo. Bwe'ituk junako ju'u ya'ut, jume' yee e'etammeu enchi su'u tojinee intok juname'e enchi eta'ane. ");
INSERT INTO yaqNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Inen ne eu jiia, junama'a empo ka a yeu weene, ka si'imeta juka' em wikiria'uta empo ka a' beje'etuasuko. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jiba juname'e taewaimmet jeela, waate, Jesujtau yeu yajak. Inime'e intok, juka' Pilaato' teamta jume' waate, bwiaraa Kalilea' tea'po joomem a' su'aka'uta au teuwaakai. Intok inika'a aapo'ik jiba juname'e bem ojbo, jume' naikim wokekame, Liojta yo'ori betchi'bo bem su'aka'um, inime'e ojbomak ket a' kuutaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ju'u Jesus intok inen ameu jiiak: ―Jaisa eme'e, inime'e bwiaraa Kalilea' tea'po joomem, inika'a ameu yeu sika' betchi'bo, si'ime jume' waate bem bwiaarapo joomem bepa che'a ka bem tu'i yoememtuka' betchi'bo junuen am ayuk ti ea ja'ani. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kannee inien yeu a' sika'a ti jiia. Eme'e intoko junuen ka tu'ik joowamta betana ka enchim emo temaeko, si'ime eme'e juni'i ket kokkone. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Oo jaisa eme'e, wame'e woj mamni ama woj naikika, tebesi jikau bicha karita benaka ya'arita Siloe' teamta amet wecheko, inime'e kokokame, inime'e, jume' waate junama'a bwe'u jo'ara Jerusalen tea'po joomem bepa jita che'a ka tu'ik am ya'ariaka' betchi'bo junuen am ayuk ti ea ja'ani. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kannee inien yeu a' sika'a ti jiia. Eme'e intoko junuen, ka tu'ik joowamta betana ka enchim emo temaeko, si'ime eme'e juni'i ket kokkone. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Junak intok ju'u Jesus, inika'a jita ta'abwiku a' tamachiaka ameu nookan: ―Seenu, a' waj bwiapo chuna'ouwota echiakan. Intok ini'i, junaka'a a' takasuk ja'ani ti eaka, aman a' bit betchi'bo siika. Taa junama junaet tua kaita teak. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Junak intok ini'i, ju'u junaka'a wajta suuamtau inen jiiak: “Beja ne baji wasuktiapo a'abo iniat chunam jajaiwa intok ne jiba kaita tettea. A' chuktane. Jaisa betchi'bo ini'i kia beja inim bwiata jinne'ulatune”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Taa ju'u, junaka'a waj bwiata suuame inen a' yoopnak: “Inia wasuktiat jiba inim a' su'u tojinee achai, bwiata nee a' bwalkoteriaka intok bwiata utte'ata maknemta nee au to'obae. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Intok inien ya'awak, jumak juchi wasuktiat takane. Taa junuen ka a' takako, junak ala a' chuktane”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sejtul, senu aet yum jo'e ta'apo ju'u Jesus senu juriom te'opopo yee majtan. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Intok junama, jamut, woj mamni ama woj naiki wasuktiapo ko'okoeka ama aanen. Inika'a, senu bebeje'eri ka tu'i jiapsi tua po'ola a' tawaalatukan. Aapo ini'i tua ka a rutukten. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ju'u Jesus ama a' bichakai, au chaaeka: ―Jamut, empo beja, em ko'okoa betana kaita intok et aayuk ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Junak intok aapo ju'u Jesus aet mamtek. Intok junama lautipo ju'u jamut rutuktek. Intok sep, Liojtau bicha a' allea'uta teuwaa taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Taa ju'u junama'a juriom te'opopo yo'o ya'ari, ini'i o'omtek, juka' Jesujta junaka'a jamutta aet yum jo'e ta'apo a' tu'uteka' betchi'bo. Intok ini'i, jume' ama anemmeu inen jiiak: ―Busan taewaim aayuk amet tekipanoanaame. Juname'e taewaimmet eme'e tu'ibaeka a'abo katne. Intok ka ju'u aet yum jo'e ta'atchi. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Junak intok ju'u yo'owe Jesukrijto inika'a inen yoopnak: ―Ka tu'i yoemtaka juni'i emo tu'u joame. Jaisa emo betana kaabe ju'u a' wakajta oo a' buuru aet yum jo'e ta'apo a' woitaka, jakun a' ba'a ji'ituaneeme. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Inika'a jamutta intoko, ju'u Apra'am tuka'uta betana yoemiammet yeu simriata, inien ju'u bebeje'eri, iniae ko'okoae, woj mamni ama woj naiki wasuktiapo jiokot au a' bittuamta, jaisa ini'i aet yum jo'e ta'apo ka inia a' ko'okoa betana ka aet aniatu'eewan ja'ani ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Juka' Jesujta inika'a a' teuwaasuko, si'ime jume' a' beje'eka kateme, tua tiweka taawak. Taa si'ime ama yoemra tua allean Jesujta tua eiyaa watchika a' joa'uta bichakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Junak intok inen jiiak: ―Jita benasa intok jitausa nee a' tamachiane, Liojta che'a yo'otaka a' kateka'u betana ju'u nok lutu'uria. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ini'i, seenuk inim yoemta, mojtaasa bachiata a' waj bwiapo a' echaka'abena. Intok ini'i junuen tua bwe'u juyata benasi yo'otuneeka, junuen tua bwe'uuka, kia jume' jekapo naj kateme juni'i a' nassa'akariampo a am tosate'e benasi weye. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ketchia inen ameu jiiak ju'u Jesus: ―Liojta che'a yo'otaka a' kateka'u betana ju'u nok lutu'uria, jitausa ne a' tamachiane. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ini'i, senu jamutta ainam bajisi jitae yeu to'orim, iliikik reberuata junamemak nau a' kuutaka, junuen si'imek kittim a' boyotua'a benasi weye. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Bwe'u jo'ara Jerusalen tea'u bicha bo'o joakai, ju'u Jesus, ili bwere jo'arampo intok kia junama che'a ka bwere jo'arammet a' weye'ut, yee majtan. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Junama'a senu aanek: ―Achai, jaisa tua iliikinee ja'ani jume' jinne'uimtuneeme ―ti au nattemaekai. Aapo intok: ");
INSERT INTO yaqNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Na'ulaika am bicha aet aman kikkimuwa'u luula eme'e kimubaeka'eene. Bwe'ituk ineponee inen emou jiia, juebenaka aman yajibaane, taa ka a aman yajine. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Juka' jo'araka ama katekamta jaibu pueetata a' pattasuko, eme'e, jume' pa'aku aneme, junau ja'abweka a' ponaka inen: “Achai, itom kimutua”, ti eme'e jiune. Taa aapo: “Kannee ju'unea jaku'ubo enchim kate'u”, ti enchim yoopnane. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Junak intok eme'e inen jiu japtenee: “Itepotee emak rejteka emak jiji'ibwasuk. Intok empo itom bwe'u jo'arapo bo'ommet yee mamajtasuk”, ti jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Taa aapo inen enchim yoopnanee: “Jaibu ne enchim tejwaala, ka in ju'unea'po, jaku'ubo enchim kate'epo. Saka'abu'em si'ime eme'e jume' ka tu'ik joaka jiapsame”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Junaman eme'e bwannee intok enchim tamim kusisi jiune, eme'e, juka' Apra'am teamta intok Isaak teamta intok Jakoobo' teamta intok si'ime wame'e Liojta betana ju'uneetuawaka noktuawaka'um, aapo'ik Liojta che'a yo'otaka a' kateka'u aamak aneme bichakai, eme'e intoko pa'akun yeu beeprimtakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bwe'ituk junak ju'u ka nanau machi yoemra, ta'ata yeu weama'a betana intok ta'ata aman weeche'e betana intok norte betana intok sur betana ama yeu yajine, junuen, Liojta che'a yo'otaka a' kateka'po, mesau jote' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Junako, waate, jume' i'an inim che'a ka eiyaawame, inime'e junaman che'a eiyaarimtune. Wate intok, jume' i'an inim tua eiyaawame, junaman junak che'a ka eiyaarimtune. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jiba junae taewait, waate paiseeom teame Jesujtau yajaka inen jiiak: ―Inim yeu weene, bwe'ituk ju'u yo'owe, Eroorej teame enchi me'etebobae ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Taa aapo inime'e inen yoopnak: ―Eme'e aman sajaka, junae yee a' bai ta'aane' betchi'bo suawakamtau inen jiunee: “A' ju'uneiyaane, inia taewait intok yooko, inepo inim jume' bebeje'eri ka tu'i jiapsim jipueme intok jume' ko'okoeme ne am tu'uteka emo am inne'etetuane'po. Intok matchuk ta'apo inepo ansune. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Taa utte'a, inia taewait intok yooko intok matchuko, juka' in bo'o jooria'uta in a' weetuane'po.” Bwe'ituk senuk, juka' Liojta betana ju'uneetuawaka yeteu noktuawamta, mekkaa, ka jum Jerusalen tea'po yeu a' muknee'u, kaachini junuentune. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Bwe'u jo'ara Jerusalen tea'po jiapsame, eme'e, jiba jume' Liojta betana ju'uneetuawaka yeteu nonoktuawame sussu'ame. Intok jume' Liojta betana enchim tejwaane' teaka emou bittuawame am mamaasukame, jue benasi ne inim jume' jiapsame neu nau am tojaka am jinne'ubaek, juka' totoi jamutta jume' ili a' asoawam nau a' totoja'a benasia, taa eme'e tua ka junen eak. ");
INSERT INTO yaqNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yuu, i'an ju'u enchim bwe'u te'opo, junama'a ju'u Lios ka intok anneeka a' ju'uneiyaanaa. Intok inepo ne inen emou jiia, enchim ka intok nee bitne'po, junak juka' taewaita a' yuma'u tajtia inen enchim jiuneeo: “Yo'oriwaka a' alleetuanaa'u au aune, ju'u achai Liojta betana a'abo weyemtau”, ti enchim jiuneeo. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sejtul, senu aet yum jo'e taewait inen yeu siika. Ju'u Jesus, seenu, paiseom teammeu ya'utta jo'au aapo ji'ibwaseko, jume' intoko waate paiseeom aapo'ik mammateka ama aanen. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Junama'a intok ket, ae bichapo, senu tua taka bajiyaataka ko'okoeka ama aanen. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Junak intok ju'u Jesus, jume' Moiseejtuka'uta nesaurim yee majtame intok jume' paiseeom teame inen temaek: ―Jaisa tu'i machi ja'ani, senuk ko'okoemta, a' tu'uteko inien aet yum jo'e ta'apo oo ka tu'i ja'ani ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Taa inime'e ka monteka taawak. Junak intok ju'u Jesus, ju'u ko'okoemtau rukteka, a' tu'utek, intok inika'a a' sim saek. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jume' paiseommeu intok aapo: ―Jabesa emo nasuk, juka' a' buuwata oo a' boejta, bwia wojo'oku, ba'aka'po ko'om a' wecheko, ini'i ka junama sep yeu a' wikbaaneeme, inika'a junuen kia aet yum jo'e taewaituko juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Inime'e intok tua kaita a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ju'u Jesus, junaman jume' nunurim, inime'e tua bat jum yo'owem mesau jojoyee'um yeu pu'aka ama joteme bichakai, inen am nok tejwaak: ");
INSERT INTO yaqNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Senuk jum jujupwaa'u enchi a' nunuko, empo ka tua jum che'a bichau jojoowa'po yejtebaane. Bwe'ituk junama'a senu ta'abwika, ee bepa che'a eiyaawaka aman nunuritaka a ama yebijne. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Intok junak ju'u enchim aman nunukame aman eu sikaa, junak: “Ika'a junum a' yejtua”, ti eu jiune. Junak intok empo, tua tiweka juni'i, junaman che'a amau yejtene. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ala empo junuen nunuwako, junaman che'a amau jojoowa'po yejne. Junako junuen, ju'u enchim aman nunukame, yepsaka, inen eu jiunee: “In nake'u, a'abo che'a bichau yeesa”, ti jiune. Junuen empo jume' ama mesau emak jokame betana che'a uttiawaka bitnaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bwe'ituk ju'u, aapo au yo'o joame, ini'i ka eiyaawaka bitnaa. Taa ju'u intoko ka au che'ewareme, juna'a, tu'isi eiyaawaka bitnaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ketchia aapo junaman jo'arau a' nunukamtau inen jiiak: ―Empo jakwoo juni'i, taewapo oo kupteo, ji'ibwa tebo'oteko, ka jume' em nak ta'aa'um oo jume' emak werim oo jume' mekka jo'aaka em wawaimmeu oo kia jume' totomeka ee naapo jo'aakame juni'i, ka inime'e aman nunune. Bwe'ituk inime'e ket, chukula enchi ji'ibwa nunune, intok junuen empo, em ya'ari betchi'bo juchi a' mabetne. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Taa empo ala, alleewaka ji'ibwa tebo'oteko, empo, jume' jiokot eaka jiapsame, jume' ka emo taka yekame, jume' lolo'im intok jume' ka bichame, inime'e aman nunune. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Intok empo tua alleewamta bitne. Bwe'ituk inime'e kaachin a enchi a' beje'etuane. Taa ala empo chukula, jume' Liojta bichapo tu'isi tawalame kokkolamtaka am jiabijteo, junak empo juka' eu tu'ik si'imek bitne. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Inika'a jikkajakai, junama'a mesau jokame betana senu Jesujtau inen jiiak: ―Tua alleenee wa'a, junaman Liojta che'a yo'otaka a' kateka'u aman aamak ji'ibwaneeme ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iniau inen jiiak: ―Seenu, tukaapo tua bwe'uusi ji'ibwa teboka, intok ini'i tu'isi juebenam aman nunu tebok. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Intok tukaapo junama'a jaibu kupteka ji'ibwabaawao, ini'i, jume' nesauta a' jooriame betana senuk, jume' aman nunurimmeu: “A'abo em kaate, bwe'ituk jaibu si'ime yuma'isi ama jipu'uwa”, ti ameu a' jiune' betchi'bo, ameu a' bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Taa juname'e si'ime emo jiokoi tebosau japtek. Ju'u seenu, che'a bat nokakame inen jiiak: “Ju'ubwa jeela nee waj bwiata jinuk intok utte'a in aman noitine'po a' bit betchi'bo. Nee aet jiokoine”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ju'u juchi seenu, nokaka inen jiiak: “Boesim, mamni japteriam ammea mo'iti betchi'bo ne jinula. Inime'e intok ne aman ji'obilaabae. Eu ne ujbwana, nee jiokoine”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ju'u intok seenu, iniamak bajikai, ket inen jiiak: “Ju'ubwa jiba ne pajkoka juube intok jiba inia betchi'bo ne ka a aman weene”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ju'u sawame, a'abo notteka, a' tekobeu inika'a si'imeta teuwaak. Junak intok ju'u tekowai, o'omteka intok ju'u a' sawe'u inen jiiak: “Aman sikaa, lauti jum bwe'u jo'arapo amet naj katwa'ummet, si'imekut intok jume' kaitae emo ania machim intok jume' ka emo taka yekame intok jume' lolo'im, intok jume' ka bibichame a'abo am weiyaane”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Che'a chukula intok ju'u sawame: “Achai, jaibu ne si'imeta juka' em teuwaaka'uta ne a' ya'asuk. Taa intok ketuni wate im be'ee”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Junak intok ju'u tekowai, ju'u a' sawe'u: “Lauti aman yeu sikaa, jum naj katwa'apo intok bo'ommet juchi waatem, utte'apo juni'i, a'abo am nunune. Junuen inim jo'aapo am tapunne' betchi'bo”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Bwe'ituk lutu'uriapo ne inen emou jiia, wame'e che'a bat naataka a'abo in nunuka'um betana, tua kaabe inim kupteo nemak ji'ibwane”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yoemra tua juebenaka Jesujtat cha'aka kaaten. Aapo intok kuakteka inen ameu jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Kia jabetaka juni'i, ini'i nemak eaka in majti tubaeme, taa ini'i, a' yo'owam oo a' jubiawata oo a' yoemiam intok jume' aamak werim ka omola am tawaalata benasi am eiyaabaeme, intok ini'i, kia inim tu'isi a' jiapsa'uta juni'i, ka junuen a' eiyaame, ini'i kaachin nee betana a' majtitune, ka junuen au lutu'uriane. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Intok wa'a, ini'i nee betchi'bo a' jiapsiwata a' ta'arunee'ut ju'uneaka, ini'i ka junuen nemak eebaeme, juna'a kaachin nemak eaka nee betana majtitune. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Emo betana seenu, ini'i mekka bit betchi'bo, karita benaka tebesi jikau a' yo'oturianee'uta ya'abae'eteko, jiba tua ini'i, che'a bat naataka, kateka, junama'a juka' a' kima'anee'uta a' na'ikiane. Junuen ae a' chupnee'u, au a' yuma'ireaka'uta ju'unee betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ka junuentuko, ini'i, aet a' nawanee'uta naateko, chukula intok ka a' chupakai, si'ime jume' a' bichame, jaana aet nok japtene. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Intok inen jiunee: “Ini'i yoeme, karita benaka a' ya'abae'uta naatek intok ka a' chupak”, ti inime'e jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Oo senu, a' bwiawapo yo'o ya'ari, ini'i, juchi juka' senuk yo'o ya'arita beje'eka nassuabae'eteko, jiba tua ini'i ket che'a bat naataka, kateka, ju'uneebaane, jume' woj mamni miil sontaommea, aapo, juka' senu taka miil sontaom weiyaamta beje'eka, tu'isi yeu a' weene'po ju'uneebaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Intok ini'i ka ama yumakai, juka' senu yo'o ya'ata, a' beje'eka weyemta, ketuni mekka a' aneo, aapo ini'i, aapo'ik betana watem au bittuane, junae betana a' kaitatunee'uta am a'aune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Junuen san, emo betana, jabetaka juni'i, wa'a, si'imeta juka' a' jipue'uta, ka omola a' tawaame, ini'i ka nemak eaka nee betana majtitune. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Ju'u oona tua tu'i o'oben, taa ini'i a' cho'okoawata ta'aruko, kaachin intok a sawatune. ");
INSERT INTO yaqNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ini'i, kia bwiata betchi'bo juni'i ka tu'i, oo waka korapo wo'otapo juni'i ka tu'i. Ini'i, kia mekka wo'otanaa ala. Ju'u a' jikkajibaeme a' mammatene. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Si'ime jume' ya'uraata betana, tomita nau totojame, intok jume' tua ka tu'i yoemem, inime'e, Jesujta a' jikkajibaeka au ruk rukten. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Intok inia betchi'bo jume' paiseeom teame intok jume' Moiseejtuka'uta nesaurim yee majtame, inime'e aet nokaka: ―Ini'i yoeme, jume' tua ka tu'i yoemem au yaajitua, intok amemak jiji'ibwa ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Junak intok ju'u Jesus, inika'a jita ta'abwiku a' tammachiaka ameu nookan: ");
INSERT INTO yaqNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Jabe juni'i emo nasuku seenu, mamni takaam bwalam jipueka intok ini'i, junama'a wepu'ulaik ta'aruko, jiba tua ini'i, jume' naiki taka ama woj mamni ama batanim jum wajpo am suua'po, am to'o sikaa, intok ini'i, juka' bwalata a' ta'aruka'uta a' tea'u tajtia a' jariune. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Intok ini'i, junaka'a teakai, a' jenommet a' tekaka, a' nuk simne, tua alleakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Intok ini'i, a' jo'au yepsakai, jume' a' ta'aa'um intok jume' ae naapo jo'aakame nau am nunuka inen ameu jiunee: “In allea'uta eme'e nemak bitne. Bwe'ituk juka' bwalata in ta'aruka'uta, ne a' teusuk”, ti jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ineponee inen emou jiia, jiba inile benasia, teekau jiapsame nasuk che'a alleewame aune, seenuk ka tu'ik joamta, ka tu'ik betana au a' temaeko, jume' naiki taka ama woj mamni ama batanika tu'i yoemem, inime'e kaita ka tu'ikut emo temaineeme bepa. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Oo ketchia, ju'u jamut, woj mamni tosai tomim jipueka, intok ini'i, junaka'a wepu'ulaik ta'aruko, jiba su tua ini'i, tachiriata yaaka, jum a' karipo, junaka'a a' tea'u tajtia, tu'isi ama jichikne. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Intok ini'i, junaka a' teusukai, junak jume' a' nakeka a' ta'aa'um intok jume' ae naapo jo'aakame nau nunuka inen ameu jiunee: “In allea'uta eme'e i'an nemak a' bitne. Bwe'ituk juka' tosai tomita in ta'aruka'uta, ne a' teusuk”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ineponee inen emou jiia, jiba inile benasia ket, teekau, jume' Liojta ankelesim nasuk, tu'isi alleewame aune, seenuk, ka tu'ik joamta juka' ka tu'ik betana au a' temaeko. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ju'u Jesus inen jiiak ketchia: ―Senu yoeme, wooim ou yoemiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Inime'e betana intok ju'u che'a ka yo'owe, a' achaibeu: “Achai, juka' chukula neu tawanee'uta, in au lutu'uriaka'uta, baat nee a' makne”, ti au jiiak. Junak intok ju'u achaiwai, bem au lutu'urianee'uta amet na'ikimtek. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ka jaiki taewaim simsuka, chukula, ju'u che'a ka yo'owe, usiwai, junama a' atteawa nenkak. Intok junae tomie, ini'i, mekka ta'abwi bwiaraau bicha siika. Junaman, ini'i, si'imeta ae au alleetuaka, ka tu'isi jiapsaka a' lu'utak. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Taa junak inika'a si'imeta jaibu a' lu'utasukai, iniat chukula junama bwiaraapo, tua kaita bwa'amachiwaka tebaatuk. Intok ini'i tua ama tebbauri taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Junak intok ini'i, junama bwiaraapo jometa senuku yoemtau yepsak, tekilta jaiwakai. Juna'a intok junama a' wasau, kowim a' suuane' betchi'bo aman a' bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Intok junama'a, jume' ju'upam benaka, kowim bwa'ee'um bwa'aka, jobo'opean. Taa tua kaabe jita a' mimikan. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Junak intok ini'i inen au eetua taitek: “In achaimak a' tekipanoareeom, tua juebenaka bwa'aame, kaita be'eeka ameu aayuk. Inepo intok inim abe tebae muuke. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","In achaibeu bichaa ne nottinee intok ne inen au jiunee: In yo'owa, Liojta beje'eka intok kia enchi beje'eka juni'i nee ka tu'ik ya'ala. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ka neu lutu'uria, jaibu em yoemiapo em nee ta'aanee'u. Ala ime'e eu tekipanoame benasi nee mabetne”, ti eakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Junak intoko ini'i bo'o joo taitek. Intok junuen a' achaiwata jo'aau nottek. ’Inika'a ketuni mekka a' weamao, ju'u a' achaiwa a' bichaka tua a' jiokolek. A' nankika au sikaa, intok a' ibaktaka intok aet tenteka, junuen a' mabetak. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Junako ju'u yoemiawai inen au jiiak: “In yo'owa, Liojta beje'eka intok enchi beje'eka nee ka tu'ik ya'ala. Jaibu ka neu lutu'uria, em yoemiapo em nee ta'aane'po”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Taa ju'u achaiwai, jume' a' sawa'ummeu inen jiiak: “Lauti em, juka' tajo'ota che'a tuttu'ik a'abo yeu tojaka intok inika'a eme'e tajo'otuane. Mam pusiapo intok ket aniiliota a' yecha'ariane. Bochampo intok ket em a' woktuane. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Juka' beseeota, awiriarita a'abo tojaka a' me'ene. Ji'ibwaneete intok alleaka pajkota te ya'ane. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bwe'ituk ini'i in yoemia, kia mukiataka intok juchi jiapsakamta benasi neu maachi. Ite a' ta'arukan, taa i'an te a' teulaa.” Intok junuen, inime'e bwe'uusi alleewamta weetua japtek. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Taa ju'u che'a yo'owe usiwai, wasau aanen. Intok ini'i nottiseka, intok a' jo'aau jeela weyeka, jiponwamta intok yi'iwamta jikkajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Junak intok junama'a, senu usi o'outau chaaeka, ju'u ama weye'ut au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ju'u usi o'ou inen au jiiak: “Ju'u em saila yepsak. Ju'u em achai intok, juka' beseeota awiriarika a' me'e tebok. Aapo'ik kaachin machika, ka ko'okoeka a' yepsaka' betchi'bo.” ");
INSERT INTO yaqNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Taa ju'u che'a yo'owe usiwai au o'omtituak. Intok ka a' kibakbaao, ju'u a' achaiwa ama yeu siika a' kibakne' betchi'bo au nokbaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ini'i intok a' achaibeu inen jiiak: “Empo tu'isi ju'unea, juebena wasuktiapo ee betchi'bo in tekipanoalaa'po. Jakwoo juni'i ka enchi beje'eka aulatakai. Taa empo sejtul juni'i, in nak ta'aa'ummak in alleene' betchi'bo, kia ili chibata wepu'ulaik juni'i kee nee miika. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Taa i'an, ini'i em yoemia yebijlaa, ini'i, ka tu'i jaamuchimmak ju'u bu'uu tomi, kia beja a' beutakai, intok i'an empo juka' beseota che'a awiriarita a' me'elaa.” ");
INSERT INTO yaqNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Junak intok ju'u achai inen au jiiak: “In yoemia, empo inim jiba nemak aane. Intok si'ime ju'u in jipue'uta, ket empo nemak a' atteak. ");
INSERT INTO yaqNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Taa i'an tua inien utte'a, pajkoka intok alleewamta itom weetuanee'u. Bwe'ituk ju'u em saila, mukiataka intok juchi jiapsakamta benasi maachi. Intok ta'aruitukan, taa itepo a' teulaa.” ");
INSERT INTO yaqNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ju'u Jesus ket inen a' majtimmeu jiiak: ―Senu tekowai tua yu'in tomeka, ini'i, seenuk tekileu a' yo'o ya'ari jipuen. Ini'i tekowai intok, aman tejwaawak junaka'a tekilpo a' yo'o ya'ari, juka' beje'emta aapo'ik jipue'uta, kia beja a' wiutaria'po betana. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Junak intok ju'u tekowai junau chaaeka intok inen au jiiak: “Jaisa lutu'uria ja'ani, ee betana ini'i neu teuwaari. Juka' tekilta em ya'ari, nee a' ju'uneiyaatuane. Bwe'ituk ka intok empo inim in tekilpo yo'otaka tekipanoane.” ");
INSERT INTO yaqNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Junak ini'i, tekileu yo'owe: “Jaisa ne anne. I'an juka' in teeko tekilta nee a' u'aaneeo. Wajpo tekilta in ya'ane' betchi'bo ne ka utte'ak. Intok kia jak in netanee'uta, nee tiiwe”, ti ee taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“Jaibu ne ju'unea ju'u in aunee'ut, junuen ka nee tekileko, watem bem jo'aampo tu'isi nee mabbetneeme anne' betchi'bo”, ti eak. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Junak intok ini'i, jume' a' tekowata wikiriammeu, we'epulaimmeu chaaek. Ju'u bat au yepsakamtau: “Jaikiksa empo a' wikiriia juka' in teeko”, ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ini'i intok: “Mamni taka bwere bariilim oliibo aseitekame”, ti a' yoopnak. Ju'u tekileu yo'owe junak inen au jiiak: “Inim aayuk ju'u em nu'uri ji'ojteitakai. Kateka, noolia juchi seenuk inia betana nasuk'aman jiba em wikiria'uta a' ji'ojtene”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chukula intok juchi senuku: “Empo su intoko, jaikiksa a' wikiriia juka' in teeko”, ti au nattemaek. Ini'i intok: “Mamni taka tiiko sako jikimaim nee a' wikiriia”, ti a' yoopnak. Junak intok ini'i: “Inim aayuk ju'u em nu'uri ji'ojteitakai. Taa i'an noolia, kateka juchi seenum naiki takaata jiba em wikiriaa'po a' ji'ojtene”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Iniae ju'u tekowai ju'uneak, juka' ka tu'i yoemtaka, tekileu yo'ota, jita inile benak a' joonee'uta a' suawaeka'po. Bwe'ituk jume' inim bwiapo ayukamtat jiba jiapsekame, nau eaka jita bem nau a' joonee'ut, che'a tu'isi a' jooa, jume' Liojta yoemiam bepa. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Inepo ala nee, inim bwiapo tua ka tu'ik weye'po, juka' beje'eka ayukamta, inim watem junamemak eaka enchim am ta'aane' betchi'bo nee enchim a' sawaanee'uta enchim tejwaa. Junuen juka' beje'eka ayukamta emou a' lu'uteko, jum jiba yuu enchim annee'u, jume' junaman enchim mabetneeme anne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Ju'u, ka jaikika au su'u tojirimak, junaet a yoem'eiyaatukame, ketchia ini'i, juebenaka au su'u tojirimmak, junaet a yoem'eiyaatune. Ju'u intok, ka jaikika au su'u tojirimmak, junaet ka a yoem'eiyaatuka a' joame, ini'i, ju'u juebenaka au su'u tojirimmak juni'i, ka a yoem'eiyaatune. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Junuen san, eme'e inim bwiapo tua ka tu'ika beje'eka ayukamta mak eme'e ka yoem'eewatchisia a' sawaakai, Liojta betana lutu'uriapo si'imeta bepa beje'ekamta, kaabe emou a' su'u tottojine. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Intok eme'e, juka' ka enchim atteata enchim jipue'uta, ka eiyaawatchisi a' sawa'ateko, kaabe junuen juka' enchim au lutu'uriaka enchim bitnee'uta a enchim a' mabettuane. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Jabe juni'i tekipanoareotakai, kaibu wooim tekoka, nanancha a nesauta am jooriane. Bwe'ituk senuk omtaka, juka' senuk intok nakne. Oo juka' senuk che'a jikkajaka, juka' senuk intok ka a' eiyaane. Inien san kaabe, Liojta a' joo i'a'uta a' jooa intok ket junaewit yu'in tomibaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jume' paiseeom teame, inime'e jiba tua yu'in bem tominee'uta eiyaame, si'imeta inika'a jikkajan. Intok Jesujta betana inime'e jaana nookan. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesus junak inimmeu: ―Eme'e, ka tu'i yoememtaka juni'i, yoemrata bichapo emo tu'u joame. Taa ju'u Lios emot ju'unea. Bwe'ituk inimi'i, ju'u jume' yoemem betchi'bo tua bem ae emo eiyaa tebo'uta, inika'a, ju'u Lios ka a' bibitpea ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Juka' yee babatoowame, Joan teamta inim jiapsaka'po taewaimmeu tajtia, jume' Moiseejtuka'uta betana nesaurim intok jume' Liojta betana ju'uneetuawakame yee majtaka ji'ojteka'u, inim tu'ireakan. Taa junama naateka chukula bicha, Liojta che'a yo'otaka a' kateka'u betana juka' bemela tu'i nok lutu'uria yee majtawa. Junaman bicha intok, si'ime aman jiapsibaeka, emo utte'a jooria. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Teekapo chokim intok kia ini'i bwiia intok aet ayukame, che'a ka obiachi a' lu'utinee'u, Liojta nesauri ji'ojtei betana wepul nokita, kaita a' teuwa'a benasi a' tawanee'u bepa. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Seenu, ini'i a' jubiwa jimaaka intok ta'abwik jubekai, ini'i, Liojta bichapo ka tu'ik ya'arine. Intok ju'u jamut jimaarita a' jubekame, ket Liojta bichapo ka tu'ik ya'arine. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Senu yoeme tua tomeka jiapsan. Ini'i intok tua ujyoika intok beje'emta a'attean. Intok chikti ta'apo ini'i, tua ujyoisi weyeka, pajkoka au alleetuan. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Intok ketchia, senu yoeme, tua kaitae au ania machiakai, Laasaro' teaka jiapsan. Ini'i intok si'ime takaat sa'awakan. Intok junae tomekamta pueetau bichapo bwiapo yeyesan. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ini'i kaitae au ania machime, junae yu'in tomekamta ji'ibwa'po ko'om yojtemtae jobo'opeaka ama katekan. Intok inika'a kia jume' chu'um juni'i, au rukteka, sa'awapo a' tete'ebwan. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Chukula junak juna'a jiokot jiapsame muukuk. Inika'a intok jume' Liojta ankelesim, teekau, ju'u Apra'amtau, jume' Liojta yoemiam, kokkosuka bat bem yaaja'u a' tojak. Ket ju'u yu'in tomekame mukuka, ma'awak. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ju'u yu'in tomekame, jum jiba yuu taji beete'po jiokot au bichakai, jikau bitchuka, omot mekka juka' Apra'amta intok Laasaro' teamta ket aamak katekamta bichak. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Junako ini'i: “Itom yo'owa Apra'am, nee e'e jiokoe intok empo juka' Laasaro' teamta a'abo neu a' bittuane, junuen kia a' mam pusiawata juni'i, baisi ba'am a'abo tenpo net a' chaktane' betchi'bo. Bwe'ituk inim tajipo ne tua jiokot ino bicha”, ti jiaka au chaaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Taa ju'u Apra'am inen au jiiak: “Au waate'e in yoemia, junaman jiapsakai, empo tua tu'ik jiba bichak. Ini'i Laasaro' teame intok tua jiokot ka tu'isi au bichak. Taa aapo i'ani inim tu'ik alleewamta bicha, empo intoko jiokot machik bicha. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Intok ama naa buustia inim enchim intok itom joka nasuk, tua bwe'uuka, mekka ko'om jakiata benaka ito nasuk bo'oka. Junuen san jume' inim aman bicha katbaeme ka a aman yaja. Jume' intok aman joka inim bicha katbaeme juni'i ka a a'abo yaja”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Junak intok ju'u yu'in tomekame: “Eu ne ujbwana in yo'owa Apra'am, juka' Laasarota, in yo'owata jo'aau em a' bittuane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Junaman mamnika nemak wewerim, junammeu a' nokaka intok junuen, juname'e ka junuen ket a'abo inim in jiokot ino bicha'u am yajine' betchi'bo”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Taa ju'u Apra'am iniau inen jiiak: “Juname'e, juka' Moiseej tuka'uta betana nesauri ji'ojteita intok wame'e Liojta betana ju'uneetuawaka nokakame, bem ji'ojteka'uta, bempo a' jipue. Juname'e ji'ojteim ela'po bempo bichaka a' nok jikkajine”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ju'u yu'in tomeka'u inen jiiak: “Lutu'uria o'oben in yo'owa Apra'am. Taa inime'e, bempo, kokkoarim betana senu jiabijteka intok ameu weyeo, ka tu'ik betana emo temaine”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Taa ju'u Apra'am: “Inime'e, Moiseej tuka'uta betana ji'ojteita intok wame'e, Liojta betana ju'uneetuawaka nokakame ji'ojteka'uta, junaka'a ka nok jikkajakai, kia kokkoarim betana seenuk junuen ameu yepsak juni'i, junaka'a juni'i bempo ka a' sualne”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ju'u Jesus a' majtimmeu inen jiiak: ―Ju'u ka tu'uwa weyeme inim jiba aune. Taa tua jiokot au machine, ju'u yoemtawi, watem inile benak a' jootuamtawi. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Che'a au tu'i ean iniau, bwe'u teta ae tutujwamta, kutanaapo au a' suma'awaka, baweu a' jimaatunee'u, junuen inime'e, jume' illitchim nee sualeme, ka tu'ik a' jootuane'po bepa. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Eme'e emo suuane. ’Seenuk, Krijtopo emak werik enchi beje'eka, Liojta bichapo ka tu'ik a' yaako, empo junaet a' sua tejwaane. Inika'a intok junaet au temaeka'ateko, empo a' jiokoine. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Inika'a intok, senu ta'apo juni'i, woo busanisi junuen enchi beje'eka ka tu'ik a' yaako, intok ket woo busanisi inika'a eu yepsakai: “Kannee intok inika'a joone”, ti eu a' jiao, em a' jiokoinee'u eu utte'a. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jume' aapo'ik yeu pu'arim inen yo'owe Jesukrijtotau jiiak: ―Che'a juni'i Liojta itom sual ta'aane' betchi'bo, itom aniane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Junak ju'u yo'owe Jesukrijto inimmeu: ―Eme'e, kia ju'u mojtaasa bachiata beleekik juni'i, Liojta enchim a suale'uta a' ta'a'ateko, inia juya sikoomoro' teamtau a inen jiu ean: “Inim, chikti nawamak yeu sikaa, intok aman baweu kiktene”, ti jiakai, ini'i juya intok enchim a' teuwaaka'po aman au ean. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Emo nasuk seenu, senuk tekilta a' jooriamta junuen takeakai intok inika'a wasau a' mo'ite'u betana oo inika'a, bwaaram a' suua'a betana a' notteo, kaachin ini'i: “Yepsaka, ji'ibwa”, ti au jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ala iniau: “Tukaapo in bwa'anee'uta ya'ane. Intok a'abo neu a' tojisune. Ket nee ji'ibwaao, chukula intok empo ji'ibwane”, ti iniau jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Junaka'a a' sawee'uta, junuen juka' aet a' sawekame inika'a a' yaaka' betchi'bo, kaibu aet a' bai saune. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eme'e juni'i ketchia, Liojta betana si'imeta juka' tekilta enchim joo i'awa'uta eme'e junaka'a a' ya'asukai, inen eme'e jiu ean: “Tua itepo watem bepa tekoka itom tekil joa' betchi'bo tee ka tuttu'i. Bwe'ituk itepo kaita intok, tua juka' itom a' joo lutu'uriaka'uta jiba te ya'ari”, ti eme'e jiu ean. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bwe'u jo'arau Jerusalen tea'u bicha naa buusti ketun bo'o joakai ju'u Jesus, jume' bwiaraam Samaaria' tea'po intok Kalilea' tea'po aman siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Junaman ili jo'arammeu yebissusekai, woj mamnika o'owim, inime'e lepra' teamtae ko'okoekai au yeu sajak. Taa inime'e, mekka au ja'abweka taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Intok inime'e: ―Jesus, yee maj majtame, empo itom jiokole ―ti chaaen. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus inime'e bichakai: ―Aman jume' te'opopo yo'owemmeu yajaka emo ju'uneiyaa tebone ―ti ameu jiiak. Inime'e intok junam bicha ket kateka su, ju'u bem ko'okoa betana tu'ireak. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Junak intok juname betana seenu, junuen tu'isuka au bichakai, nottek, tua eakai Liojta a' bai sae'uta teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ini'i, Jesujtau tonommea kiktek bwiau tajti ko'om cha'akai. Junuen beja a' bai saubaekai. Intok ini'i yoeme, bwiaraa Samaaria' tea'po jometukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Junak ju'u Jesus: ―Che'a bempo woj mamniakan jume' bem ko'okoa betana tu'ireakame. Jaksa aane jume' waate batanikai. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Jaisa ini'i ka juriotakai omot jometa jiba, aapola a'abo nottek junuen tua junen jiaka, Liojta a' bai sae'uta a' teuwaabaekai ja'ani ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Junak intok junae yoemtau: ―Kikteka intok baa weene. Junuen Liojta em a' sualeka' betchi'bo empo tu'ireak ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jume' paiseeom teame Jesujtau nattemaek, juka' Liojta inim a' nesaunee'u betana jak weyeo a' aune'eti jiakai. Aapo intok inime'e inen yoopnak: ―Liojta inim che'a a' nesaunee'u, ini'i, ka jitae a bittuka weene. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kaabe: “Inim aane”, ti jiune, oo: “Junaman jakun aane”, ti jiune. Bwe'ituk ju'u, juka' Liojta che'a yo'otaka inim a' nesawee'u jaibu inim weye ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Junak intok a' majtimmeu inen jiiak: ―Taewai yuma'ane, junak enchim juka' inim emo benasi yoemta, sejtul ta'apo juni'i, emomak anemta enchim a' bitpeeneo, intok eme'e ka a' bitne. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Intok: “Inim aane.” Oo: “Junaman aane”, ti emou jiunaa. Taa eme'e ka am bicha katbaane. Intok kia inime'e, ka amet cha'aka rejtinee juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bwe'ituk teekapo yuku be'oktiata, ta'ata yeu weama'a betana naateka, aman a' weche'u tajtia a' jibaoka'a benasi, junuen machine, juka' inim emo benasi yoemta, junak a'abo a' notteo. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Taa ini'i, che'a bat naataka, utte'a inika'a tua jiokot au a' bitne'po. Intok jume' i'an inim jiapsame betana ka a' mabettune'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Juka' Noe'etuka'uta jiapsao yeu a' sika'a benasia ket jiba junaen yeu weene, juka' inim yoemta abe a'abo a' nottineeo. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Inime'e, ji'ibwaka, jita je'eeka, jujupwamta weetuan. Intok jume' bem maarawam am kukunatuan. Juka' Noe'etuka'uta jum bwe'u kuta kari kanoau a' kibakeo taewaita yuma'u tajtia. Inim intok, ba'ae subimneeka intok si'ime kokkok. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Juka' Loot tuka'uta jiapsao yeu a' sika'a benasia, ket jiba junaen yeu weene. Inime'e, ji'ibwawamta weetuaka intok jita je'een. Jita jinuwaka, jita nenkiwame weyen. Echaka intok karim joowan. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Taa juka' Loot teamta junama bwe'u jo'ara Sorooma' tea'a betana yeu a' siiko, teeka betana, taji asupre'ebeetemtamak kuraik ama ko'om yukuk. Intok juname'e si'imem su'aak. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ket inimmeu yeu a' sika'a benasia yeu weene, taewait juka' inim yoemta a'abo aniau yeu a' machiako. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Junae taewait, senu kari jikat aneka, ini'i, wajiwa jita jipuekai, ka ko'om cheptaka a' nu'ubaane. Senu intok, wajpo anekai juni'i, ini'i ka a' jo'aau nottibaeka'eene. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ju'u Loot tuka'uta jubibeu yeu sikamtau eme'e au waatine. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wa'a inim jiba, alleaka a' jiapsinee'uta che'a a' eiyaame, ini'i, jiba yuu a' jiapsinee'uta a' ta'arune. Taa wa'a nemak a' ea' betchi'bo junuen a' jiapsinee'uta ka a' eiyaakame, juna'a, jiba yuu a' jiapsinee'uta a' bitne. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Ineponee inen emou jiia, junae tukaariat, wepul jipetekipo, woika nau to'oka, junama'a senu nuk simnaa. Ju'u senu intoko junama tawaanaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jaamuchim, woika nau tuseme, junama senu nuk simnaa. Ju'u intoko senu junama tawaanaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wajpo wooika nau rejteka, junama'a senu nuk simnaa, ju'u intoko seenu, junama'a tawaanaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Inime'e inika'a jikkajakai: ―Achai, jakunsa ini'i yeu weene ―ti au nattemaek. Aapo intok: ―Jak juni'i mukiata bo'oka'po, junama'a jume' bwere wiirum nau yajine ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ju'u Jesus intok inimmeu junuen inime'e, ka a' rojiktaka jiba Liojtau bicha bem yee nokrianee'uta am majtabaeka, jita ta'abwikut nokaka inika'a ameu teuwaak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Inen ameu jiiak: ―Senu ili bwe'u jo'araapo, seenu, ini'i yee ya'uraa bibittuaka yo'o ya'atukan. Ini'i, kia Liojta ka yo'ori ta'aan intok inim juni'i, kaabeta au ta'aatuan. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jiba junama'a ili bwe'u jo'araapo ket, jamut jokoptui inim jo'aakan. Ini'i, kia jiba junae yo'o ya'uttau yeu yeepsan. Junuen inia bichapo, senuk a' beje'eka anemta betana jita'po aapo'ik lutu'uriata a' jipu'unee'ut, junaet a' ania i'akai. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Binwaa ta'apo juna'a yo'o ya'ari ka a' aniabaek. Taa chukula ini'i: “Ineponee kia Liojta ka yo'ori ta'aaka juni'i, intok nee kia kaabeta ino ta'aatuaka juni'i, ");
INSERT INTO yaqNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","junuentaka juni'i, inika'a jamut jokoptuita jiba a'abo neu a' sua' betchi'bo, nee iniat a' aniabae, junuen inika'a ka intoko a'abo a' suaka intok nee a' lottane' betchi'bo”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Junak intok ju'u yo'owe Jesukrijto inen jiiak: ―Inika'a junuen teuwaak ju'u ka tu'i yee ya'uraa bittuame. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ju'u Lios intok juni'i ket jiba tua ame betchi'botune, jume' aapo'ik yeu pu'arim, tukaariat intok taewait naa bujtia au bicha emo nokriame. Jaisa am bo'o bittuanee ja'ani. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ineponee inen emou jiia, aapo kia chubala juni'i ka bo'o bichaka ame betchi'botune. Taa chukula ju'u inim yoeme a'abo notteko, jiba tua ketun jume' a' sualeme inim bwiapo am teune. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ju'u Jesus juchi inika'a jita ta'abwiku a' tamachiaka, waatem, jume' che'a si'imeku tu'isi emo jiapsa'ati eaka, watem intok kia jak wa'am bichame betchi'bo a' teuwaakai. Aapo intok inen jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Woika o'owim Liojtau bicha nokbaeka, te'opou yajak. Ju'u senu paiseeo tukan. Ju'u senu intok, ya'uraatau bicha tomita weyemta junaka'a tekilekan. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ju'u paiseeo, weyeka, Liojtau bicha nokaka, inen jiian: “Empo Lios, tua ne enchi baisae, ka jume' watem benasi in machiaka' betchi'bo. Inime'e jita nunu'ee, ka tu'isi jiapsaka intok ka tu'i jaamuchimmak emo tu'uritua. Intok ne kia inia ya'uraapo tekilekamta benasi juni'i ne ka maachi. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Inepo semaanapo woisi ka ji'ibwalataka ne Liojta yoyo'ore. Intok inepo, si'ime ju'u in koba'u betana, jum woj mamnisi na'ikiaripo, wepu'ulaik ne ama eu bicha a' nana'ikia.” ");
INSERT INTO yaqNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Taa ju'u senu intok, ya'uraapo tekilekame, ini'i amau mekka taawak. Ini'i intok kia teekau bicha juni'i ka jikau bitchubaekai, ala taupo au chonaka intok: “Oo empo, achai Lios, nee jiokole, ka tu'i yoemta”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ineponee inen emou jiia, ju'u ya'uraapo tekilekame, aapo a' jo'awau notteka, ini'i jaibu tua junama wa'am Liojtamak au tu'utelatakai yepsak. Taa ju'u paiseeo, ka junuen ayukai. Bwe'ituk, ju'u che'a au yo'o joame, ini'i chukula che'a ka eiyaawaka bitnaa. Taa ju'u ka au che'ewareme, juna'a chukula che'a eiyaawaka bitnaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ketchia jume' ili uusim ju'u Jesujtau tojiwan, junaen aapo'ik amet mamtene' betchi'bo. Taa jume' Jesujta majtim inika'a bichakai, jume' aman au am tojame am nok beje'e japtek. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Taa ju'u Jesus jume' a' majtimmeu chaaeka inen ameu jiiak: ―Ake'em am su'u toja. Ela'pom neu katnee jume' ili uusim. Kate'em ammeas jajapte. Bwe'ituk ju'u Liojta aman che'a yo'otaka a' kateka'u, jume' inime'e benasi emo eetuame betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Lutu'uriapo ne inen emou jiia, ju'u, ka ili usim benasi au eetuaka, Liojta che'a yo'otaka a' kateka'u betana juka' nok lutu'uriata a' mabetakame, juna'a kaibu aman jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Junama'a jume' yoemratau yo'owem betana senu Jesujtau nattemaek: ―Tu'i yoeme, a yee majtame. Jitasa utte'a in ya'anee'u inepo junae juka' jiba yuu jiapsiwamta a' bitne ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iniau intok inen jiiak ju'u Jesus: ―Jaisaaka empo nee tu'u yoeme ti jiia. Kaabe intoko tu'i yoeme. Wepulai jiba. Ini'i intok aapo ju'u Lios juna'a ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Empo Liojta betana nesauri ji'ojteimmet ju'unea: “Ta'abwi jamutta, ka a' jubeka, ka aamak emo tu'urine. Ka yee sussu'ane. Ka jita e'etbwane. Ka aa noki'ichiata yetet nonokne. Em achai intok em ae yo'orine” ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ini'i yoeme intok: ―Inika'a si'imeta, in ili usituka'po naateka nee a' ya'ari ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Inika'a ju'u Jesus jikkajakai: ―Ketuni senu weeme eu be'ee ―ti au jiiak―. Si'imeta juka' em jipue'uta nenkaka, inika'a, jume' jiokot jiapsammet a' na'ikimtene. Intok junak empo teekau, Liojta mak, juka' che'a eiyaawatchik bitne. Chukula intok nemak weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Taa juna'a, inika'a jikkajakai tu'isi au sioktuak. Bwe'ituk aapo unnaa yu'in jita atteakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Junuen siokaka tawakamta a' bichakai, ju'u Jesus: ―Tua obiachi, jume' yu'in jita atteakame betchi'bo, inime'e, Liojta che'a yo'otaka a' kateka'u bem jiapsinee'u ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Juka' naikim wokekamta, kameeyo' teamta ji'ikia pusimpo yeu a' weene'po che'a ka obiachine, juka' yu'in tomekamta jum Liojta che'a yo'otaka kateka'u a' yebijne'po bepa ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Junako jume' a' jikkajakame: ―Junuentuko, jabesa tua a jinne'uitune ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ju'u Jesus inen ameu jiiak: ―Inim jume' jiapsame, ju'u obiachika, bem ka a joa'uta, ju'u Lios ala junaka'a a jooa ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ju'u Peeo: ―Achai, itepote si'imeta juka' itom atteasuka'uta tee a' to'o saka'i emak eaka emak rejtibaekai ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Junak aapo inen am yoopnak: ―Tua lutu'uriapo nee inen emou jiia, jabeta juni'i, a' jo'ara oo a' yo'owawam oo jume' tua aamak wewerim oo a' jubiarita oo jume' a' yoemiawam, Liojta che'a yo'otaka a' kateka'u betana juka' nok lutu'uriata a' eiya' betchi'bo, inime'e ju'u am to'o sikame, ");
INSERT INTO yaqNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ini'i ket inim jiapsaka, che'a bepa au tu'ik mabetnee intok jum chukula jiapsiwao, juka' jiba yuu jiapsiwamta bitne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ju'u Jesus intok jume' woj mamni ama wooim yeu a' pu'arim, bempola, omola nunuka: ―Itepote bwe'u jo'ara Jerusalen tea'u bicha tee bo'o joa. Junaman intok si'imeta juka'a, jume' Liojta betana ju'uneetuawaka, ju'u inim yoemta betana nokaka bem ji'ojteka'uta, junaman a' chupne'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bwe'ituk ini'i, junaman jume' ka inim yoemem mampo su'u tojinaa. Intok jaana jiaawaawaka, ka yo'oriwaka ka tu'isi au noknaa. Intok aet chit wattinaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ini'i ko'okosi ya'anaa intok chukula, juname'e a' me'ene. Taa baji taewaita weyeo, kokkoarim nasuk jiabijtene ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Taa bempo inia betana ka a' jajamek. Intok kia ka ju'unean jitat ameu a' teuwaa'po. Bwe'ituk ini'i weyeme ame betchi'bo aet ju'uneepo ameu obiachiakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Juka' Jesujta, bwe'u jo'ara Jeriko' tea'u jeela a' yebijsuseeo, senu lipti bo'o mayoat kateka, watem betana jita a' mik bo'o bichan. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ini'i, junama'a yoemrata juebenak ama wa'am katemta jikkajakai, ini'i ka bichame, ju'u ama weye'ut, watemmeu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ini'i intok, juka' Jesujta, Nasaret tea'po jometa ama wa'am a' weye'u tejwaawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Junak intok ini'i: ―Achai Jesus, Labiituka'uta betana yoemratat yeu simria, empo nee jiokole ―ti au chaaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jume' aman bat kateme, juname'e a' yaatine' betchi'bo au nookan. Taa aapo che'a juni'i: ―Achai, Labiituka'uta betana yoemratat yeu simria, empo nee jiokole ―ti chaaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Junak intok ju'u Jesus, junama kikteka, au a' toji nesaek. Au a' tojiwako, ju'u Jesus inen au nattemaek: ");
INSERT INTO yaqNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―Jitasa empo nee enchi ya'aria i'a ―ti au nattemaek. Ju'u ka bichame intok: ―Achai, juchi ne bitbae ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ju'u Jesus intok: ―Juchi bitne ―ti au jiiak―. Empo junuen em nee sualeka' betchi'bo, tu'ireaka'e ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Junama lautipo sep bichak ju'u lipti. Intok Jesujta mak yeu siika, Liojta a' bai sae'uta teuwaakai. Intok ket ju'u yoemra si'ime inika'a bichakame, ket Liojtau bicha bem allea'uta a' teuwaan. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Junak intok ju'u Jesus junama'a bwe'u jo'araa Jerikoo' tea'u kibakek intok junama bwe'u jo'araapo aman weyen. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Junama intok, senu tua yu'in jita atteaka, ini'i Sakeo' teaka aman jo'aakan. Ini'i intok, jume' ya'uraatau bicha tomita weyemta nau totojammeu yo'o tukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ini'i Sakeo' teame, Jesujta ket a' ta'aabaek. Taa ka a' bit machiakan bwe'ituk yoemra juebenaka Jesujtamak kaaten. Ini'i Sakeo' teame intok tua kome'elaa tukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Junak aapo bat buiteka intok aapo'ik junuen a' bit betchi'bo, bwe'u juya sikoomoro'o teamtat ja'amuk junama'a omola Jesujta wa'am we'ea'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Junama'a ju'u Jesus wa'am weyeka, jikau bitchuk intok: ―Sakeeo, lauti ko'om chepte. Bwe'ituk i'an nee em jo'aapo tawaabae ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Junak intok ju'u Sakeeo' teame, lauti ko'om cheptek. Intok tua alleaka, Jesujta a' jo'aau a' mabetak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Inika'a bichakai, si'ime Jesujtat nok japtek, aapo'ik senuk ka tu'i yoemta jo'aapo a' tawabaeka ama a' yepsak, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Junak ju'u Sakeeo, kikteka intok ju'u yo'owe Jesukrijtotau: ―A' bitnee achai. Si'imeta juka' tu'ik in jipue'uta, nasuk'aman nee jume' jiokot jiapsammet nee a' na'ikimtene. Intok inepo jabeta bai ta'aaka, jita a' etbwarialatuko, junae betana, naikisi che'a bepa nee a' nottane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ju'u Jesus intok inen au jiiak: ―I'an inim jo'araapo jiapsammeu yuumak ju'u am jinne'unaa'u. Beja ini'i yoeme su ket, ju'u Apra'amtuka'utat betana yoemiammet yeu simria ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bwe'ituk ju'u inim emo benasi yoeme, inim jume' ka tu'ikut emo ta'arulame, juname'e jaiwaka intok am jinne'ubaeka yebijlaa ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Juka' yoemrata Jesujta inia a' teuwaa'u betana ketun inime'e a' jikkajao su, aapo jita ta'abwiku a' tammachiaka ameu nookan. Bwe'ituk aapo bwe'u jo'ara Jerusalen tea'u jaibu ka mekka aanen. Bempo intok, aapo'ik Liojta inim aniapo che'a yo'otaka a' nesaunee'uta junama'a sep a' naate machian. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Junak intok inen ameu jiiak: ―Yoeme seenu, tua eiyaawaka yo'oriwame betana yoemiataka jiapsan. Ini'i, mekka omot bwiarau bicha siika, junuen junaman, junama yoemratau, che'a ama yo'otaka yeu a' pu'ana' betchi'bo. Intok chukula juchi nottibaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Taa kee simekai, junama'a woj mamnim jume' a' tekipanoareeommeu chaaek. Inime'e we'epulaimmet, wepul tosai tomi, tua beje'emta amet na'ikimtek. Intok inen ameu jiiak: “Inika'a tomita eme'e tekipanoane, in notte'u tajtia”, ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Taa junae a' bwiaraapo joome, ju'u yoemra ka a' waatan. Intok inime'e jum a' sika'u bicha: “Itepo inika'a o'outa te ka itou a' yo'otu i'a”, ti bem jiune' betchi'bo, aman am bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Taa ini'i, jiba junama che'a yo'otaka yeu pu'atuka, intok a' bwiaraau bicha nottek. Juna'abo ini'i nottekai, jume' tekilta a' jooriaka, tomita amet a' na'ikimteka'ummeu chaai tebok. Ini'i, juname'e, we'epulaim, jaikik am koba'iaka'ut ju'uneebaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ju'u seenu, bat au yepsaka: “Achai, ju'u em tomi, woj mamnisi naa buustia au bu'uurialaa”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ju'u yo'o ya'ari inen a' yoopnak: “Tua su tu'i, empo tu'i yoemtaka a tekilta jojooa. Ka jaikikut juni'i, tu'isi yuma'isi em yeu sika' betchi'bo, woj mamni bwere jo'arammeu ne i'an enchi yo'o ya'ane”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Juchi senu au yepsaka intok: “Achai, ju'u em tomi, mamnisia naa buustia au bu'uurialaa”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Inika'a ket aapo inen yoopnak: “Empo, mamni bwere jo'arammeu'e yo'otune”, ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Junak intok juchi senu au yepsaka, ini'i: “Achai, ju'u em tomi inim aayuk. Paayumpo nee a' jipueka a' e'erialatukan”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","“Bwe'ituk ne enchi ee majjaen, yeteu empo bettek jiapsek, kaita em jo'aripo jita em nunu'ee'po, intok ka em echaka'po em jitchupa'po ju'uneakai”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Junak ini'i yo'o ya'ari inen au jiiak: “Empo, ka tu'ika ka a tekilta jooa. Jiba ju'u em teuwaa'ue su nee ka tu'isi enchi tawaane. Empo, yeteu bettek in jiapseka'po intok kaita in jo'aripo jita in nunu'ee'po intok ka in echaka'po in jitchupa'po ju'uneakai, ");
INSERT INTO yaqNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","junako empo juka' in tomita, jume' tomita tekipanoammeu a' reu tebo ean. Intok junuen inepo nottesukai, juka' in tomita intok au a' kobaka'uta kia naa buusti a' mabet ean”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ini'i intok, jume' ama anemmeu inen jiiak: “Eme'e, juka' tomita em a' u'aa intok ika'a, jume' woj mamnim jipuemta a' makne”, ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bempo inen au jiiak: “Taa su, achai, ini'i jaibu woj mamnim tosai tomim jipue”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ju'u yo'o ya'ari inen am yoopnak: “I'an ne inen emou jiia, wa'a tu'ik weyemtat che'a juni'i jiapsekame, ini'i junuen, Liojta betana che'a juni'i a' miktune. Taa wa'a inien tu'ikut ka aet jiapsekame, ini'i kia ju'u ilikikut aet a' jiapseka'ut juni'i ae beaj koptituanaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jume' intoko nee beje'eka aneka, inime'e ka nee ameu yo'otu i'a'um betana intoko, a'abo am tojinee intok inime'e eme'e nee bichapo am su'ane”, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chukula inika'a teuwaasukai ju'u Jesus ketuni bwe'u jo'ara Jerusalen tea'u bicha bo'o joobaeka yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Junak aapo jume' ili bwere jo'aram Betpaake' tea'u intok Betaania' tea'u aman jeela yepsakai, jum Oliibo kawi' tea'u jeela, ju'u Jesus, wooi jume' a' majtim aman bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Inen ameu jiakai: ―Aman ili jo'ara, tua ka mekka itou katekamtau eme'e katne. Junaman eme'e yeu yajaka, buuta cha'akamta a' teune. Inika'a kee jabe aet yejtemta. Junaka'a woitaka, a'abo a' tojine ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Senuk intok: “Jaisaaka eme'e a' woita”, ti emou a' jiao, eme'e: “Ju'u itom achai a' sawabae”, ti eme'e au jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Inime'e a' majtim aman sajaka intok bempo si'imeta Jesujta ameu a' teuwaaka'a benasi ama a' teak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bempo intok juka' ili buuta am woitao su, jume' a' atteakame: ―Jaisaakai eme'e a' woita ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bempo intok: ―Juka' yo'owe Jesukrijtota inika'a a' sawabae' betchi'bo ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Junuen inime'e, Jesujtau aman a' tojaka intok tajo'orim bempo'immet cha'aka'um ju'u buutat to'aaka, Jesujta aet ja'amutuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aapo'ik Jesujta intok ket a' weye'ut luula, bempo, bem tajo'ori amet cha'aka'um aawas am to'o sakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aapo'ik junama Oliibo kawi' tea'po betukun bo'ot ko'om a' yebisuseo, si'ime jume' a' sualeka ama aamak kate'um, inime'e si'imeta juka' Liojta a jita joa'apo aman, suum watchisi machik bem bitlaa'u betchi'bo, alleerimmea chai japtek. Intok Liojtau bicha bem a' bai sae'uta a' teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Inime'e inen jiakai: ―A' alleetuawaka a' yo'orinaa'u au lutu'uriatune, ju'u che'a yo'o ya'ari, achai Liojta betana lutu'uriaka a'abo weyemtawi. Teekau jiapsammeu yuma'isi ka jain eewame aune. Intok che'a bepa Liojta a' yo'orinaa'u jiba au aune ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Junak intok waate paiseeom, inime'e ama bu'uurata nasuk kate'um: ―Yee majtame, inime'e emak eaka inim kateme, am nok yaatituane ―ti Jesujtau jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Taa ju'u Jesus inime'e yoopnak: ―Ineponee emou inen jiia, inime'e junuen yaateko, jume' tetam chaaine ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Junak aapo, bwe'u jo'ara Jerusalen tea'u jeela yepsakai, junaka'a bwe'u jo'arata bichakai, ju'u Jesus a' jiokoleka ae betchi'bo bwaanak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Inen jiakai: ―Kia inia taewait juni'i nee enchim ju'uneetuapea, jita tua juka' yanti jiapsiwamta emot a' autuamta. Taa i'ani ini'i tua ka a ju'uneiyaatu. Intok eme'e ka a' ju'uneiyaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bwe'ituk taewaim ka tu'ika emo betchi'bo yuma'ane. Jume' enchim beje'eka aneme konila mekka jikau enchim am koratuaka, intok junuen enchim am kontaika, si'imekut betana luula enchim amunaao. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Inim si'ime bwiau tajtia tataptune. Jume' inim jiapsame su'atune. Intok inim teta wepulaka juni'i, jak karipo ka tataptuka ama bi'ine. Bwe'ituk eme'esu inia taewait, Liojta enchim jinne'ubaeka emou a' yepsako, enchim ka a' ta'aabaeka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Junak intok ju'u Jesus junama bwe'u te'opopo yepsak. Intok junama'a wajiwa si'imem jume' jita nenkaka intok jume' jita jinume, pa'akun yeu beep taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Intok inen ameu jiiak: ―Jum Liojta nok lutu'uriapo inen ji'ojtei: “Ju'u in te'opo, Liojtau bicha emo nokria betchi'bo kari tune”, ti ji'ojtei. Taa eme'e, jume' jita e'etbwame, ama e'eusee'u kau wojo'oriata benasi a' ya'ari ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Chikti ta'apo ju'u Jesus jum te'opopo aneka yee majtan. Taa jume' jum te'opopo tekiakammeu yo'owem intok jume'e, Moiseejtuka'uta nesaurim yee majtame intok kia jume' junama yoemratau che'a yo'owem, inime'e nau eaka, Jesujta jachin bem a' me'e tebonee'ut aet tekipanoan. ");
INSERT INTO yaqNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Taa kaachin juni'i ayuka a' me'e machiakan. Bwe'ituk si'ime ju'u yoemra ama aneme, a' teuwaa'uta tua a' tu'ureka a' jikkajan. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sejtul, senu ta'apo juka' Jesujta jum te'opopo aneka intok juka' yoemrata majtaka, intok Liojta betana nok lutu'uriata juka' yee jinne'umta ameu a' majtao, jume' jum te'opopo tekiakammeu yo'owem intok jume' Moiseejtuka'uta nesaurim yee majtame, intok jume' juriommeu yo'owe ama au yajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Intok inime'e inen au nattemaek: ―Itom tejwaane, jita ya'uraata betana lutu'uriaka empo inika'a jooa. Oo jabesa inika'a em nesaunee'ut et a' autuak ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Junak Jesus inimmeu: ―Ineponee ket junaen senu weemta emou nattemaibae, nee tejwaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Juka' Joantuka'uta yee a' bato'owaane' betchi'bo, jabesa aet a' sawek, ju'u Lios oo jume' inim yoemem ja'ani, nee tejwaane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Taa inime'e bempo naas emo tetemai japtek inen jiakai: ―Jaisa te jiune. Itepo: “Junaka'a, Liojta a'abo a' bittuak”, ti itom jiao, junak aapo: “Jaisaakai eme'e ka a' sualek”, ti itou nattemaine. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Taa intok: “Inim jume' yoemem betana”, ti itom jiao, ju'u yoemra si'ime itom mamaasukai itom su'ane. Bwe'ituk inime'e, juka' Joantuka'uta, Liojta betana ju'uneetuawaka a' noktuawaka'uta tua junuen a' suale ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bempo intok ka emo ju'unea'a ti jiaka a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Junak intok ju'u Jesus: ―Junuentuko, inepo juni'i ket nee ka enchim tejwaanee jabeta betana utte'aka inika'a in a' joa'apo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chukula ju'u Jesus ju'u yoemratau nok taitek intok jita ta'abwiku a' tamachiaka ameu nookan: ―Seenu, a' wajpo, pa'asi ouwom juebenam ja'abwak. Chukula intok wate tekipanoareommeu a' reu tebok. Intok ini'i, junama'a omot bicha sikaa, aman binwatuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Juname'e pa'asim chuktawao taewaita yumako, ini'i, tekilta a' jooriamta, juname'e tekipanoareommeu a' bittuak, junama'a echipo, aapo'iku bicha a' lutu'uriatuka'po aman a' a'aune' betchi'bo. Taa juname'e, ko'okosi a' yaak intok kaita a' makaka a' simtuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Junak intok ju'u, junaka'a wajta atteakame, tekilta a' jooriamta juchi senuk aman bittuak. Taa inika'a ketchia, bempo ka a' yo'oreka au nokaka, ko'okosi a' yaaka intok kaita a' makaka a' simtuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ju'u wajta atteakame iniat cha'aka, juchi senuk aman bittuak. Taa inime'e tekipanoareeom ket inika'a juni'i, ko'okosi a' yaak intok pa'akun yeu a' tojak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Si'imemmet che'a chukula juna'a wajta atteakame: “Jaisa tua nee aune”, ti au eetuak. “Jiba nee juka' in yoemiata, tua in nake'uta nee aman bittuane. Inika'a bicha'ateko jumak juni'i inime'e a' yo'orine”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Taa jume' tekipanoareeom inika'a ameu yepsamta bichakai, inen emo tejwaak: “Ini'i juna'a ju'u chukula inika'a atteaneeme. Ate a' me'ene, junuen juka' bem at teamak itepo tawa betchi'bo”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Junak intok inime'e a' bwiseka, junama'a wajpo yeu a' nuk sajaka a' me'aak. Ju'u Jesus intok junak inen jiiak: ―Juna'a wajta atteakame, jaisa tua inime'emak aune. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Junaman sika intok ini'i, juname'e tekipanoareeom su'ane. Juka' bwiata intok tatta'abwim a' makne ―ti jiiak. Jume' aman aneme inika'a jikkajaka: ―Lios ka bat junen jiune ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Taa ju'u Jesus inime'e bitchukai inen jiiak: ―Junak su, jum Liojta nok lutu'uriapo ju'u ji'ojtei inen jiame, jitasa teuwaabae: Wa'a teta, jume' kakaateme yeu tawaaka'u, Chukula ini'i teta, che'a bat naataka ama nawataka yeu siika, ti jiame. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jabetaka juni'i ju'u inia tetat wechekame, ini'i si'imekut kot kottisune. Taa ini'i teta intok senukut ko'om wecheka, junaka'a kia a' tutujne ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jume' te'opopo tekiakammeu yo'owe intok jume' Moiseejtuka'uta nesaurim yee majtame, inime'e jiba junama sep Jesujta bwijbaeka'eak. Bwe'ituk inime'e aet mammaten, inika'a jita ta'abwiku a' tamachiaka a' nokaka'uta, jiba ame betchi'bo su a' teuwaaka'po. Taa bempo juka' yoemrata majjaen. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Junako inime'e, bempo jume' aet mammateneeme, watem yo'oriwame benasi emo ya'arikai aman bittuak. Inime'e, jita juni'i a' teuwaatuaka, junuen junaet ju'u kobanaotau a bem yeu a' tojine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jiba inia betchi'bo inime'e inen au nattemaek: ―Yee majtame, ju'uneate juka' em teuwaa'uta intok juka' em yee majta'uta, tua a' lutu'uriatuka'po. Intok ka empo inim jume' watem emo am uju'u'uta amet che'a ta'aaka am bicha. Ala empo, Liojta betana nok lutu'uriata ka ta'abwisia, tua a' lutu'uriatuka'po aman empo yee a' majta. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Itom tejwaane, jaisa tu'inee ja'ani, ju'u jum Romapo si'imem bepa yo'o ya'aritau bicha tomita weyemta a' beje'etua'po, oo ka tu'i ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Taa ju'u Jesus inimmet ju'une'eak, ka tu'ik au bicha bem ea'po intok inen ameu jiiak: ―Jaisaaka eme'e inile benakue nee ji'optuabae ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Eme'e juka' tosai tomita, senuk nee bittuane. Jabesa inika'a pujbak intok jume' team iniat ji'ojteim ―ti jiiak. Bempo intok: ―Ju'u si'imem bepa che'a yo'o ya'ari, Sesar teamta betana ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Junak intok aapo: ―Junuen san eme'e, ju'u inim si'imem bepa che'a yo'o ya'ariu bicha weyemta, au bicha a' na'ikiane. Intok Liojtau bicha weyemta ket eme'e, Liojtau bicha a' na'ikiane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Intok inime'e junuen, ju'u yoemrata bichapo, kaitat a' ji'optuak. Alla inime'e ju'u aapo'ik am yoopnaka'u betana, tua suum eaka ka montek. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Iniat chukula, waate jume' sauseeompo ta'eewame betana, Jesujtau aman noitek. Inime'e, jume' kokkokame ka am jijiabijte'eti jiia. Junuen san inime'e Jesujtau inen jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Yee majtame, ju'u Moiseejtuka'u, ji'ojteita itom a' ya'ariak, yoemta senuk, jubeka intok ka yoemiaka a' mukuko, ju'u junae sailawa, juka' jokoptulata a' jupne'eti jiakai, intok junaemak yoemianee ju'u a' saai mukukamta betchi'bo ―ti jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ket junuen san, woo busanika nau wewerika jiapsan. Ju'u che'a bat weyeme juubek. Taa ka yoemiaka muukuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ju'u iniat cha'aka weyeme intok, juka' jokoptuita juubek. Intok ini'i ket ka yoemiaka muukuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Junak intok, iniamak bajika, juchi ju'u senu a' juubek. Intok jume' waate juni'i, ket jiba junaen aayuka, woo busanim yuma'u tajtia. Intok si'ime ka yoemiaka kokkok. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Intok inime'e si'imemmet chukula, ju'u jamut juni'i ket muukuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Junak su, jume' kokkoarim am jiabijteneeo, inime betana jabesa a' jubeka tawane. Junuen jume' woo busanika a' jubekantakai ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Junak ju'u Jesus inen am yoopnak: ―I'an jume' inim bwiapo jiapsame, jume' o'owim intok jume' jaamuchim emo jujube. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Taa wame'e kokkoarim nasuk jijiabijtineeka intok aman chukula jiapsinaa'u lutu'uriaka aman yajineeme, junaman inime'e ka jujupne. Intok kia jume' marakame, inime'e, bem maram juni'i, ka am kukunatuane. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bwe'ituk inime su ka intok kokkone. Bwe'ituk inime'e, teekau jume' Liojta ankelesim bebena intok inime'e kokkoarim nasuk bem jiabijteka' betchi'bo, Lios am yoemiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kia aapo ju'u Moiseejtuka'u juni'i, jum Liojta nok lutu'uriapo, aman jum ju'u juya beete'utat a' noka'apo, ini'i, jume' kokkolam am jijiabijte'ut a itom aet ju'uneetua. Junama san juka' Liojta, juka' Apra'am teamta, waka'a Isaak teamta intok juka' Jakoop teamta bempo'im a' Lios yo'owaka'u ama a' teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Taa ju'u Lios, ka jume' jiba betchi'bo kokkolammeu Lios. Ala, jume' jiba yuu jiapsame betchi'bo. Bwe'ituk aapo'ik betchi'bo si'ime jiapsa. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Junak intok jume' Moiseej tuka'uta nesaurim yee majtame betana waate: ―Tua'e amma'ali jiia, yee majtame ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Intok junama'a bempo ka intok au ruktek, naa buusti au nattemaibaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ju'u Jesus inen ameu jiiak: ―Junak su, jaisaaka ju'u Krijto' teame, ju'u Labiituka'uta yoemiammet yeu simria, ti jiuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Bwe'ituk jiba aapo ju'u Labiituka'u, jum Salmom ji'ojteimpo inen a' teuwaak: Ju'u in yo'owa Lios, ju'u in yo'owabeu inen jiiak: “In bata tana neu yejtene, ");
INSERT INTO yaqNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Jume' enchi beje'eka kateme, in am koba'asu'u tajtia”, ti a' teuwaak. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ju'u Krijto, kaachin Labiituka'uta betana yeu simriatune, junuen jiba aapo ju'u Labii' teame a' yo'owa rokakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Si'ime ju'u yoemra ama aneme a' jikkajan, juka' Jesujta a' majtimmeu inen a' jiako: ");
INSERT INTO yaqNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Jume' Moiseej tuka'uta nesaurim yee majtame betana, eme'e emo suuane. Bwe'ituk inime'e tettebem bem supenee'uta tu'ure. Intok jum bwere jo'arampo jita nenkiwa'po che'a anwa'po, yo'orisi emo tetebotua i'a. Intok jum bem te'opompo, che'a bichau wajiwa, yo'oraata jojoye'po bem joonee'uta juni'i tu'ure. Intok ket inime'e, pajkompo bichau, che'a bat bem jojoonee'uta waata. ");
INSERT INTO yaqNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Intok inime'e ket, jume' jaamut jokoptuim, jume' bem karim bem attea, emo am attea mamaka. Chukula intok inia betana bem aet jiawitenee'uta jaiwakai, Liojta yo'ori ta'aa ti jiuna' betchi'bo, binwaa ja'abweka, Liojtau bicha emo nonoktua. Inime'e juname'e jume'e, chukula che'a bepaa jiokot emo bittuanaame. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jum Liojta te'opopo ju'u Jesus, wame'e tua yu'in totomeka, tomita Liojtau bicha weyemta, jum a' jojoawaa'po ama tojame bichak. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Junama'a ket, tua kaitae au ania machika, senuk jamut jokoptuita, wooi ili kopre tomim ama joakamta bichak. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aapo intok inen jiiak: ―Tua nee lutu'uriapo inen emou jiia, junuen inika'a, tua kaitae au ania machika jamut jokoptuita, che'a si'imem bepa yu'in ama a' jo'alatuka'u ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bwe'ituk si'ime jume' waate, juka' naa buusti yu'in bem jipue'uta a'abo totoja. Taa ini'i jamut, aapo jiokot a' jiapsa' nasuk juni'i, si'imeta a' jipue'uta, kia juka' ae a' ji'ibwa'ea'uta juni'i ama joak ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Waate junae bwe'u te'opot bem bicha'ut nau etejon. Intok junama'a tua ujyooika tetammet intok si'imeta junama'a, Liojtau bicha na'ikiaritaka aman tojirita betana. Junak intok ju'u Jesus inen jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Taewai yuma'ane, si'imeta inika'a i'an enchim bicha'uta, chibela tataptuka, tetata inim wepu'ulaik juni'i ka jikat tawane ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Junak intok au nattemaiwak: ―Yee majtame, ini'i jakwoosa yeu weeneekai. Jitaa machilaasa aunee inika'a weyemta jaibu chupneeo ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ju'u Jesus inen jiiak: ―Tua tu'isi eme'e emo suuane. Intok kaabeta eme'e enchim bai ta'aatuane. Bwe'ituk juebenaka nee betana emo kate'eti jiaka yajine. Inime'e: “Ineponee juna'a ju'u Krijto”, ti jiune. Intok ket: “Inime'e taewaim juname'e, a' nottineeo”, ti jiune. Taa eme'e ka amemak eene. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Intok junak eme'e aman jakun nassuawa ti jiuwao, intok ya'uraata emo beje'eka nassuamta jikkajakai, eme'e ka majjaune. Bwe'ituk utte'a inika'a bat weenee'u. Taa iniamak kee lu'utinee ju'u ania ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Junak intok ket inen jiiak: ―Ju'u senu yoemra, juka' ket senuk yoemrata beje'eka nassuane. Senu bwiaraapo yoemra ket, juka' senuk bwiaraapo yoemrata beje'eka nassuane. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jak chukti bwia au yoaka, ko'om kibakne. Tebaatune. Intok ko'okoa o'omot su weene. Intok teekapo tua suum watchisi machika aune. Intok jita teuwaaka, machilaa yu'in weenee ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Taa si'imeta inika'a kee yeu weyeo, eme'e bwijnaa intok emou suuanaa. Juriom nau emo totoja'po eme'e yeu tottojiwaka, ya'uraa bittuanaa. Intok eme'e e'etanaa. Intok jume' che'a yo'o ya'arim bichapo intok jume' kobanaaom bichapo, enchim nemak ea' betchi'bo eme'e yeu totojinaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Junak, inien emou weyeka nee betana juka' lutu'uriata eme'e a' teuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Junuen san eme'e a' ju'uneiyaane, junuen chukula junama enchim emo nokriaka enchim teuwaanee'uta, ka bat naataka aet enchim ju'uneenee'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bwe'ituk ineponee juka' enchim teuwaanee'uta intok suawata nee emot a' autuane. Inika'a, jume' enchim beje'eka aneme, kaabe au yuma'ane, intok kia kaabe a' beje'eka noknee juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Taa eme'e, kia jume' enchim yo'owawam betana intok jume' tua emo mak werim betana intok kia jume' enchim nakeka enchim ta'aa'um betana eme'e yeu bwijtune. Emo betana intok waate su'atune. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Intok enchim nemak ea' betchi'bo, si'imem betana eme'e omtanaa. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Taa enchim kobat, kia wepul chooni juni'i, ka ta'aruitune. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Intok inien a' machiak juni'i, eme'e enchim suale'ut ka ta'abwisi eaka jiapsa'ateko, eme'e, jiba yuu jiapsiwamta bitne. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Jum bwe'u jo'ara Jerusalen tea'po eme'e, sontaaom ka iliikim nau a' kontalame eme'e am bicha'ateko, junak junuen eme'e ju'uneene, inika'a lauti a' tataptune'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Junako, jume' bwiaraa Jurea' tea'po aneme, inime'e kawiu bicha katne. Ket jume' intok, jum bwe'u jo'ara Jerusalen tea'po aneme junama yeu katne. Intok jume' wajpo aneme, inime'e ka jum bwe'u jo'arau nottibaeka'eene. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bwe'ituk juname'e taewaimmet ju'u Lios, tua amet jiokot yee bittuane. Junak si'imeta juka'a, jum Liojta nok lutu'uriapo ji'ojteita a' chupneeo. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Intok tua jiokot ameu machine, wame'e jaamuchimmeu juname'e taewaimmet jume' abe usibaemmewi oo illitchika che'eeme asoakammewi. Bwe'ituk junakriapo inim bwiapo tua weenee ju'u unnaa jiokot emo bitwame. Intok inia yoemrata betchi'bo, tua ka jiokoliwaka amet jiokot emo bitwametune. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waate jum nassuawa'u su'anaa. Wate intok bwijrimtaka, si'ime aniat tatta'abwi yoemratau naas nuk saka'anaa. Intok jume' ka inim joomem, jum bwe'u jo'ara Jerusalen tea'po, inime'e jume' wasuktiam junuen bem ama an i'awa'um simsu'u tajtia ama nesaweka a' nayyotene. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Junak intok ta'atchi, intok ju'u mechachi, intok jume' chokimmetchi juni'i, machilaa aune. Intok jume' inim bwiapo jo'aakame, a' jita tuka'po ka a ju'uneene. Intok inime'e, tua jantiachika jum bawepo jume' ba'a biaktiam jiame jikkajaka, majjaune. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Inim si'ime aniat, juka' yeu weenemta ju'uneiyaaka, ju'u yoemra tua majjaeka kia wattine. Bwe'ituk kia jume' teekapo ka bittaka jume' utte'aka nesaweme juni'i, emo yoone. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Intok junako inime'e, juka' inim yoemta teeka betana, namupo, nesaweka intok tua yo'orisi machika a'abo weyemta a' bitne. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Inika'a weyemta yeu machi taiteko, eme'e ka ko'om eene. Intok a' bo'o bichaka, jikau bitchune. Bwe'ituk tua lauti eme'e inim jinne'uitune. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ketchia inika'a jita ta'abwiku a' tamachiaka ameu nookak: ―Eme'e, juka' chuna'ouwota mammatene, oo kia jita juyataka juni'i, ");
INSERT INTO yaqNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","eme'e, ini'i jume' sawam jaibu am basiweo, am bichakai, jiba eme'e su junuen ju'uneenee juka' tasariata a' yuma'aseo. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jiba junaen su ketchia, si'imeta inika'a eme'e a' bicha'ateko, eme'e jaibu su ju'uneene, Liojta a'abo bwiau yo'otaka a' nesaunee'u abe a' yuma'apo. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Lutu'uriapo ne inen emou jiia, si'ime ini'i yeu weene, i'an inim juka' yoemrata kee a' kokkou su. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ju'u teeka intok ini'i ju'u bwia, inime'e lu'utine. Taa ju'u in teuwaari, ini'i, ka lu'uteka, jiba yuu tawane. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Tu'isi eme'e emo suuane, ka eme'e inim juka' ka tu'ik bo'o jooriawamtat, nanaakowamtat intok inim aniapo weyemtat jiapsiwamta betchi'bo, junaet, Liojta enchim yo'oreka jiapsa'uta a' koptabaane. Junuen juka' taewaita a'abo in aet nottinee'uta, ka enchim a' etbwa nu'une' betchi'bo, ");
INSERT INTO yaqNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","jite'i yecha'ita a' wecheka'a benasia. Bwe'ituk juna'a taewai, si'ime yoemra inim si'imekut jiapsammeu junuen yuma'ane. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ka eme'e emo koptaika jiapsibaane. Intok eme'e, Liojtau bicha enchim emo nokrianee'uta ka koptane, junuen si'imeta inika'a yeu weenemta betana a enchim ama yo'eene' betchi'bo. Intok ju'u inim yoemta bichapo tu'isi enchim mabetrimtune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ju'u Jesus, taewapo jum te'opopo yee maj majtan. Tukaapo intok, kawi oliibo' tea'po tawabaeka, am bicha sisimen. ");
INSERT INTO yaqNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Junama intok ju'u yoemra si'ime, chikti ta'apo, tua ketwoo su, te'opou yeu yaajan, junuen a' jikkajibaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jaibu yuma'asekan ju'u pajko taewai, jume' paanim ka reberuakame bwa'anaao, ju'u, bwaram aet jissu'awame pajkopo ta'eewame. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jume' te'opopo tekiakammeu yo'owe intok jume' Moiseejtuka'uta nesaurim yee majtame, inime'e, juka' Jesujta, jachin ayuka bem a' me'enee'uta jaiwan. Bwe'ituk bempo juka' yoemrata majjaen. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Junak intok ju'u bebeje'eri, ju'u Juraj teamtat kibakek. Ini'i ket ju'u Ijkariootimmea ta'eewame. Ket jume' woj mamni ama wooim mak na'ikiatuka'u. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ini'i intok, jume' te'opopo tekiakammeu yo'owemmeu intok jume' ama nesawemmeu siika, intok inime mak etejok, jachin ayuka aapo'ik juka' Jesujta ameu a' su'u tojinee'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Inime'e intok tua alleak. Intok nau eaka, tomita a' mak rokak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ju'u Juuraj teame junuen amemak a' tu'ureka, intok junama naateka a' bwiseka ameu a' su'u toji betchi'bo, jakwoo che'a kaabeta aamak ane'uta bo'o bichan. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Junak yuumak ju'u taewai, paanim ka reberuaka aet bwabwa'awaao, inim junak, bwalata wasuktemta junaet a' meme'ewaao. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus intok, juka' Peota intok juka' Joanta sawek: ―Eme'e aman sajaka, kupteo, pajkot itom bwa'anee'uta, itoas a' yaaka ama a' jipu'une ―ti ameu jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bempo intok: ―Jakunsa empo junaka'a itom a' yaa i'a ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus inen am yoopnak: ―Junaman bwe'u jo'arau eme'e yajako, seenuk, bwe'u babu soto'ipo ba'am weiyaamta eme'e bitne. Inika'a eme'e, jo'arau a' yepsa'u tajtia eme'e aamak aman yajine. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Intok eme'e, junama jo'arapo yo'otau: “Ju'u yee majtame: Jaksa inim karipo inepo jume' in majtimmak, pajkot kupteo inepo ji'ibwane, ti jiia”, ti au jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Junak intok aapo, junama'a karipo, juchi senu bwe'u kari, bepa katekamta enchim tejwaane. Inika'a jaibu tu'uteita. Junama'a eme'e a' ya'anee juka' itom bwa'anee'uta ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bempo intok aman sajaka intok si'imeta juka' Jesujta tua junuen ameu a' teuwaari benasi ama a' bichak. Intok junama'a, inime'e pajkot tukaapo bwa'anaamta ama a' yaak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Junama'a junak ka machiao yumakai, ju'u Jesus intok jume' aapo'ik yeu pu'arim, mesau ruktek. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Junak intok ju'u Jesus inimmeu: ―Tua ne lutula wee'po inika'a pajkot tukaapo bwa'awamta emomak ne a' ya'apean, ketun kee inepo me'etukai ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bwe'ituk inepo inen a' lutu'uria ti jiia, ka intok inika'a pajkopo ka machiao bwa'awamta emomak juchi in a' bwa'anee'u. Chukula teekau junak achai Liojta che'a yo'otaka a' kateka'u, i'an inika'a a' teuwaa'uta in a' yuma'u tajtia ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Junak intok, pa'asi ba'awata ama auka'uta nu'uka, Liojta bai saeka intok: ―Inika'a em nu'uka, si'ime nau a' ji'ine ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bwe'ituk inika'a pa'asi ba'awata, ka intok nee a' ji'ine, chukula junak, achai Liojta yo'otaka a' nesauneeo itom a' bicha'u tajtia ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chukula ket jume' paanim nu'uka, Liojta bai saeka junak intok juname'e am rebektaka, bempo'immeu am bwisek inen jiakai: ―Ini'i in taka o'oben, emou tu'ineeka, jiokot ya'atuka me'etuneeme. Inika'a eme'e, neu waati betchi'bo a' joone ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ket chukula ji'ibwasukai, juka' pa'asi ba'awata auka'uta junuen ameu bwisek intok inen jiiak: ―Ini'i pa'asi ba'awa juna'a, ju'u emou tu'ineeka, bemelasi weyeka, Liojtamak emo tu'utewamta, ojbo in wo'otaka'ue a' chupiatuka'uta a' teuwaame ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Taa ne ju'unea, juka' nee yeu bwijneemta, inim itom ji'ibwa'po, nemak a' ane'epo. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bwe'ituk ju'u inim yoeme, Liojta nok lutu'uriapo aapo'ik betana a' ji'ojteituka'po aman junaen au chupe. Taa tua jiokot au machine, ju'u, junuen yeu a' bwijneemtawi ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Junak intok bempo naas nau nattemai japtek, jabeta tua junen yeu a' bwijne'po betana. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chukula inime'e, bempo'im nasuk, jabeta ama che'a ameu a' yo'otunemta au a' lutu'uriatunee'u betana aet nau etejok. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Taa ju'u Jesus inen ameu jiiak: ―Jume' inim bwere yoemratau che'a yo'o ya'arim, junaka'a yoemrata am tekoka'a benasia a am kuakta. Intok ketchia inime nasuk jume' che'a yo'owe, inime'e, tu'ik si'imem jooriame ti ta'eewa. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Taa emo nasuk ka junuen weene. Ala emo nasuk ju'u che'a eiyaawame, ini'i, si'imem bepa che'a chukula a' weye'e benasia au eiyaane. Ju'u intoko nesaweme, ini'i, jume' waatem nesauta a' jooria'a benasia au eiyaane. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Bwe'ituk inime'e betana, jabesa juna'a ju'u che'a eiyaawame, ju'u mesau rukteka ji'ibwaneeme, oo ju'u, bwa'amta iniau totojame. Ju'u mesau yejteka ji'ibwaneeme juna'a o'oben. Taa inepo, nee inim emo nasuk aneka, jabeta nesauta a' joa'a benasia nee jiapsa ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Eme'e su intok juname'em, jume'e, inim tua obiachiku, sioksi in ino bicha'po, jiba i'an tajtia nemak naj kuakteme. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Inia betchi'bo san, inepo, chukula, yo'otaka enchim nemak annee'u betana, lutu'uriata nee enchim makne, in achai Liojta betana in a' makrituka'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Junuen junaman, che'a yo'otaka in annee'po, mesau kateka in ji'ibwanee'u, enchim nemak ama ji'ibwane' betchi'bo. Intok eme'e, jume' che'a yo'owem jojoye'po jote'ene, junuen jume' woj mamni ama wooika, Ijra'eltuka'uta betana yoemrata, a' ya'uraa bittua betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ket inen jiiak ju'u Jesukrijto: ―Empo Simoo, a' ju'uneiyaane, juka' bebeje'erita emou suuaka, kia tiikota, jekae naas a' beba'a benasia enchim a' ji'optuabae' betchi'bo, Liojtau bicha a' noklatuka'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Taa inepo, nee jaibu Liojtau bicha enchi nokriasula, junuen, jiba Liojtat eaka em a' suale'uta, ka em a' koptane' betchi'bo. Intok empo aet chukula, inia betana tu'isi yeu simlatakai, junak jume' Krijtopo emak werim inime'e Liojta bem suale'u betana, ka ta'abwisi intok bem eene' betchi'bo am aniane. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ju'u Simo'o teame intok: ―Achai, emak eta'anaaka juni'i, intok kia ne emak me'etuneeka juni'i, jiba ne emak weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Taa ju'u Jesus: ―Inen ne eu jiia Peeo, jiba i'ani, juka' totoi o'owiata kee a' kukuseeo, bajisi empo nee betana temaiwaka, ka nee emo ta'a'a ti jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Junak intok ju'u Jesus inen ameu nattemaek: ―Sejtul, junak nee enchim naas saweko, enchim ama nu'u sakanee'uta oo tomi boosata intok kia bocham juni'i ka enchim weiyaane'eti jiakai, jaisa junak jita emou be'eka ja'ani ―ti ameu nattemaek. Bempo intok: ―Tua kaita ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Junak intok aapo inen jiiak: ―Taa i'ani, wa'a ama a' nu'unee'uta oo tomi boosata a' jipueme, ini'i a' weiyaane. Ju'u intoko ka tebe sisi'iwook kuchi'im jipueme, ini'i jume' a' bepa supewam nenkaka junae tomie am jinune. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bwe'ituk inepo nee a' lutu'uriatune'eti jiia, inika'a, jum Liojta nok lutu'uriapo inen ji'ojteita junuen neu a' chupne'po: “Intok ini'i, jume' ka tu'i yoememmak na'ikiatuk”, ti jiamta. Bwe'ituk si'ime ju'u Liojta nok lutu'uriapo nee betana ji'ojtei, utte'a junuen a' chupnee'u ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Junak intok bempo: ―Yuu achai, woika im aayuk jume' tettebe sisi'iwook kuchi'im ―ti jiiak. Aapo intok: ―Inime'e jibatune ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Junak intok ju'u Jesus junama yeu sikaa, jiba aapo'ik aman yeepsa'a benasia, oliibo'okawi' tea'u bicha siika. Jume' a' majtim intok aamak yeu sajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Junak, jum a' sika'u yepsakai, inen ameu jiiak: ―Liojtau bicha eme'e emo nokriane, junuen ka tu'ik enchim ya'anee'ut ka enchim ji'opne' betchi'bo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chukula sep ju'u Jesus, junama'a am ane'epo, che'a bichau jeela siika, senuk tetata a' mekka a' jimmaala'abe'emu. Junama intok Liojtau bicha nok betchi'bo tonommea kiktek. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Intok: ―In yo'owa, empo junen ea'ateko, inika'a bettesi jiokot machika neu weyemta betana ka nee a' bittuane. Taa ka in ea'po amantunee taa tua em junen ea'po amani ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Junak intok teeka betana senu Liojta ankeles junama au yeu machiak, ini'i junuen utte'ata aet autuasekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Intok aapo junuen tua jiokot bettesi au bichakai, che'a juni'i bepa Liojtau bicha au nokria simen. Ju'u intok a' tata bujtiawa, kia bwere ojbo chaktiam benasi bwiau ko'om yojten. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Junama'a Liojtau bicha a' noka'apo kikteka, jume' a' majtim tawala'u bicha siika. Inime'e intok siokrimmea yumiataka, kokocheme teak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Junak intok: ―Jaisaaka eme'e kokoche. Jote'em intok Liojtau bicha emo nokrianee junuen ka tu'ikut, ka enchim ji'opne' betchi'bo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Juka' Jesujta junama'a ketuni a' nokao su, waate juebenaka ama au yajak. Ju'u Juuraj ti teaka'u, ini'i jiba jume' woj mamni ama wooika Jesujta yeu pu'arimmak na'ikiatuka'u, juname bepat weyen. Intok ini'i Jesujtau ruktek a' pujbawat aet tente betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Junak ju'u Jesus: ―Juuras, jaisa empo inien aet tenteka, juka' inim emo benasi yoemta, yeu a' bwiseka, watem mampo a' su'u toja ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jume' Jesujtamak rejteme, juka' ama weyemta bichakai aapo'iku: ―Achai, jaisa tua itepo inime'e tettebe sisi'iwook kuchi'immea nassuanee ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jume' Jesujta mak rejteme betana, seenu, ju'u te'opopo tekiakammeu yo'ota sawee'uta, batatana naka chukti a' beebak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Taa ju'u Jesus: ―Kate'em ameu suua, ini'i jibatune ―ti jiiak. Junak intok ju'u Jesus, junaka'a ya'uraapo sawamta nakammet mamteka, a' tu'utek. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Junama sep, te'opopo tekiakammeu yo'owemmeu intok jume' te'opopo nesaweme intok ju'u yoemratau yo'owemmeu, jume' a' weiyaabaeka aman au yajilammeu: ―Eme'e tettebem kukuche'ekai intok kukutakai, nee jita etbwareo tuka'a benasia eme'e a'abo neu yeu sajak ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Junako chikti ta'apo jum te'opopo nee emo nasuk aneeo, eme'e kia juni'i ka neu suuak. Taa i'an ka machiku emou tu'i, juka' bebeje'erita utte'ata emot ayuka a' weyeo. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Junak intok inime'e, juka' Jesujta bwiseka, ju'u te'opopo tekiakammeu che'a yo'ota kariu aman wajiwa a' tojak. Ju'u Peeo intok mekka aet cha'aka weyen. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Junama'a wajiwa, waate jum bwe'u tebat nasuku nayaka intok junama ameu jootek. Ju'u Peeo intok ket amemak ama yejtek. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Junak intok senu jamut, junama sawame, aapo'ik junama tajiu katekamta bichakai, tua a' bitchuka, intok: ―Ini'i o'ou ket Jesujtamak weaman ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Taa ju'u Peeo, ka a' lutu'uria'ati jiubaeka: ―Kannee a' ta'aa ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Che'a chukula intok juchi senu a' bichaka: ―Empo ket juname betana weye ―ti au jiiak. Taa ju'u Peeo: ―E'e, kannee juna'a ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Che'a chukula, jumak senu orata weyekai, juchi senu ket: ―Tua lutu'uriapo ini'i yoeme aamak weaman bwe'ituk Kalilea bwiaarapo joome ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Junak intok ju'u Peeo inen jiiak: ―Empo achai, tua kannee ju'unea jitat em etejoo'ut ―ti jiiak. Jiba junama lautipo juka' Peota ketuni a' nokao su, totoi o'owia kukussuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Junak intok ju'u yo'owe Jesukrijto au bicha kuakteka junama'a Peotat remtek. Ju'u Peeo intok, ju'u yo'owe Jesukrijtota au teuwaala'u wawaatek: “I'an empo, totoi o'owiata kee kuseo, bajisi empo ka nee emo ta'a'ati jiulatune”, ti au a' jiaka'ubewi. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Junak intok ju'u Peeo junama yeu sikaa, intok tua ka alleaka bwaanak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jume' Jesujta a' suuatuawame, ka a' yo'oreka au nookan intok ko'okosi a' jooan. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Intok a' puj pattaika, pujbat a' chonaka au nattemaek: ―Ka ju'uneaka itom tejwaa, jabeta enchi chochonak ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Intok ket wate juebenak au teuwaan junuen ka a' yo'oribaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yokotuko taewapo, jume' junama jurio yoemratau yo'owe intok jume' te'opopo tekiakammeu yo'owe intok jume' Moiseej tuka'uta nesaurim yee majtame, inime'e emo nau tojak. Intok juka' Jesujta si'ime ju'u ama ya'uraatau yeu a' tojak. Junama bempo: ");
INSERT INTO yaqNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Itom tejwaane, jaisa empo juna'a ja'ani ju'u Krijto' teame ―ti au jiiak. Aapo inime'e inen yoopnak: ―Inia betana, lutu'uria ti ne emou jiao, eme'e ka nee sualne ―ti ameu jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Intok kia nee emou nattemaeo juni'i, eme'e kaibu nee tejwaane. Intok kia eme'e ka nee su'u tojinee juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Taa i'an naateka ju'u inim emo benasi yoeme, Lios, che'a si'ime utte'akamtamak a' batatana aamak yejtene ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Junako sep juname'e si'ime: ―Junak su, jaisa empo juna'a ja'ani ju'u Liojta u'usi ―ti au nattemaek. Ju'u Jesus intok: ―Jeewi, inepo nee juna'a, jiba enchim a' teuwaari benasia ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Junak bempo inen jiiak: ―Kaabe intok waatiatune, ju'u a' beje'eka a' na'atejoneeme. Jiba itepo te a' teuwaarita aet a' jikkajila. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Junak intok junama si'ime japteka, intok aapo'ik Jesujta ju'u kobanaao Pilaato'oti teakamtau a' tojak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Junama'a intok inime'e sep su a' na'atejo japtek inen jiakai: ―Itepo, tee inika'a o'outa inim itomak yoemrata, ka yanti a' eltuamta te a' ju'uneiyaa. Juka' tomita jum bwe'u jo'ara Romapo, ju'u che'a yo'o ya'aritau bicha weyemta, ka itom a' bejje'etuane'e ti jiia. Intok ketchia, aapo au ju'u che'a yo'o ya'ari a' Krijtotuka'u a' teuwaa ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Junak ju'u Pilaato inen au nattemaek: ―Jaisa empo juna'a ja'ani, ju'u, jume' juriommeu che'a yo'o ya'ari ―ti jiiak. Jesus intok: ―Ineponee juna'a, jiba em a' teuwaari benasi ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Junak intok ju'u Pilaato, jume' te'opopo tekiakammeu yo'owemmeu intok ju'u junama'a yoemratau: ―Tua ne kaita ka tu'ik inia yoemtat a' bicha ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Taa inime'e che'a juni'i jiian: ―Ini'i, yee a' majta'ue inim jurea bwiaraapo, si'ime yoemrata ka yanti eltua. Kalilea bwiaraa' tea'po naateka intok i'an inim ket junaen a' weetua ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ju'u kobanaao Pilaato inika'a jikkajaka, juka' yoemta, bwiaraa Kalilea' tea'po a' jometuka'uta nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Intok junak junaman a' jometuka'u tejwaawakai, ju'u Kalilea bwiaraa' tea'po kobanaao, Eroorej teamtau a' bittuak. Bwe'ituk ini'i ket juname'e taewaimmet, bwe'u jo'ara Jerusalen tea'po anekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ini'i Eroorej teame, Jesujta bichakai, tua alleak. Bwe'ituk binwatuk naateka a' bitpeaka ean. Bwe'ituk aapo'ik betana etejowamta jikkajilatukan. Intok ket jita a' joa'uta, machilaata aet bitbaeka ean. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aapo tua juebenak au nattemaek, taa ju'u Jesus kaita a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ketchia junama'a jume' te'opopo tekiakammeu yo'owe intok jume' Moiseejtuka'uta nesaurim yee majtame, inime'e ka yaateka a' na'atejoka ama aanen. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Junak intok ju'u Eroorej teame intok jume' a' sontaaowam, kia jak wa'am a' bichak. Intok ka a' yo'orekai, ujyooik intok beje'emta, yo'o ya'ari tajo'ori benakue a' tajo'otuak. Junama'a ju'u Eroorej teame juchi ju'u Pilaato' teamtau a' bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jiba junae taewait ju'u Pilaato intok ju'u Eroorej teame emo nau tu'uteka emo eiyaa japtek. Bwe'ituk bat naataka bempo emo bejje'een. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Junak intok ju'u Pilaato, jume' te'opopo tekiakammeu yo'owe intok jume' junama'a jurio yoemratau yo'owem intok juka' bu'uuraata nau a'awaka, ");
INSERT INTO yaqNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","intok inimmeu inen jiiak: ―Eme'e inika'a yoemta inim neu a' tojak. Intok inim yoemrata, ka yanti aapo'ik am eltua ti jiakai. Taa inepo, jiba inim enchim bichapo nee a' temaisuk intok eme'e ju'unea, ju'u enchim a' na'atejoo'u betana, ka tu'ik kaita in aet teula tuka'u. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Intok kia ju'u Eroorej teame juni'i, bwe'ituk aapo juchi a'abo itou a' bittualaa. Joo, eme'e ju'unea, ini'i kaita ka tu'ik ya'ari junae a' me'etune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Junuen san, nee a' bepsu teboka intok chukula nee a' su'u tojine ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Junae pajko taewait, juka' yoemrata alleetua betchi'bo, ju'u Pilaatotau utte'atukan, senuk eta'ita, aapo'ik a' jiokoeka yeu a' su'u tojine'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Taa juname'e si'ime nanancha chai japtek: ―Inika'a ka jiokoeka, a' me'e tebone. Juka' Barabaaj teamta yeu su'u tojine ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ini'i Barabaaj teame, jum bwe'u jo'arapo, ya'uraata beje'eka nassuawamta ya'alatukan intok yee su'ari betchi'bo, ama eta'itukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ju'u Pilaato, juka' Jesujta su'u toji peaka ean intok juchi ameu nookak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Taa bempo che'a juni'i, kusisi: ―Kuuset a' popon tebone ―ti chaaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Iniamak bajisi ju'u Pilaato: ―Jitasa ka tu'ik ya'alatakai. Nee kaita aet teulaa junae a' me'etunee'uta au chupne' betchi'bo. A' bepsu teboka, intok chukula ne a' su'u tojine ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Taa bempo che'a juni'i naa buusti chaaeka nookan, kuuset a' popontunee'u a'awakai. Intok juka' bu'uuraata intok jume' te'opopo tekiakammeu yo'owe junuen ka yaateka am chaae' betchi'bo, inime'e juka' bem a'awa'uta am ya'ariawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ju'u kobanaao Pilaato, juka' bem a'awa'uta junen su a' ya'ababaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Intok junuen aapo, juka' bem su'u toji i'a'uta ameu yeu a' su'u tojak. Juka' bem bwe'u jo'arapo ya'uraata beje'eka, nassuawamta ya'alatuka intok yee a' su'ariaka' betchi'bo ama eta'ita. Jesujta intok bempo'im mampo a' su'u tojak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Junama'a juka' Jesujta, kuuset a' popontunee'u bicha a' weiyaawa'po, juname'e, senu yoemta, bwe'u jo'ara Sireene' tea'a betana jometa, Simon teaka, waj betana weyemta nankeka, au nookak intok inika'a, juka' kuujta a' pu'aktatuaka, Jesujtat cha'aka a' weiyaatuan. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yoemra bu'uuka aet cha'aka kaaten. Intok juebena jaamuchim inime'e, aapo'ik betchi'bo tua ka bem allea'uta teuwaakai bwaanan. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Taa ju'u Jesus inime'e bitchukai, inen ameu jiiak: ―Eme'e jaamuchim Jerusalenpo joomem, kate'em nee betchi'bo bwaana. Ala eme'e emo bwanriane, intok jume' enchim yoemiam. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bwe'ituk chukula taewaim yuma'ane, junak: “Tua alleenee jume' ka a yoemiakame intok jume' kaabeta chi'ituakame”, ti jiunaao. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Junak intok ju'u yoemra, jume' kawimmeu nokaka: “Itot wattine”, ti jiu japtene. Intok jume' ili bwia kawimmeu: “Itom essone”, ti jiune. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bwe'ituk, nee, tu'ik joamta juni'i inien jiokot joakai, eme'e, ka inien jiapsame, chukula che'a juni'i jiokot joonaa ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ketchia aamak woika jume' tua ka tu'ika ya'arika weiyaawan, jum Jesujta mak nau su'abaawakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Junak bempo jum Mukia koba' tea'u yajakai, junama'a juka' Jesujta kuuset poponak. Intok ketchia jume' woika ka tu'ik ya'arika aamake. Senu a' batatana, senu intok a' miko'otana. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Juka' Jesujta, jaibu kuuset a' poponwao: ―Achai, am jiokoine, bwe'ituk inime'e ka ju'uneaka juka' bem joa'uta a' jooa ―ti jiiak. Intok jume' sontaaom, aapo'ik Jesujta tajo'orita nat na'ikimte betchi'bo, amet nau ja'atek. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ju'u yoemra junama aneka a' bitchun. Intok kia junama'a ju'u yoemratau yo'oora juni'i, ama aneka, ka a' yo'oreka nookan inen jiakai: ―Aapo watem jinne'uk. I'an ela'po aapo, aapola au jinne'une, lutu'uriapo aapo ju'u Krijto' teame, Liojta betana yeu pu'arituko ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jume' sontaaom juni'i ket junaen ka a' yo'oreka au nookan, intok au rukteka chibusi cho'okok ba'ata a' ji'ituabaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Intok inen au jiian: ―Lutu'uriapo empo ju'u juriommeu che'a yo'o ya'arituko, empo emo jinne'une ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aapo'ik a' koba bepa intok ji'ojtei chaya'atukan, ini'i rieeko nokpo intok latin nokpo intok ebreo nokpo ji'ojteitukan: “Ini'i juna'a ju'u juriommeu che'a yo'o ya'ari”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jume' ka tu'ik ya'arika junama kuusimmet aamak chaya'ituka'um betana seenu, ka a' yo'oreka: ―Lutu'uriapo empo ju'u Krijto tuko, empo emo jinne'unee intok itom ket jinne'une ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Taa ju'u seenu, iniamak ama jikat popontuka'u, iniau nookak: ―Jaisa kia jeela juni'i empo ka Liojtat ee majjae ja'ani. Jiba empo inim itomak jiokot emo bichakai ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Itepo ala tee lutu'uriaka inien jiokot ito bicha bwe'ituk itom ya'ari betchi'bo itou lutu'uria inien jiokot itom ito bitnee'u. Taa ini'i o'ou, ka tu'ik tua kaita ya'ari. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Junak aapo: ―Jesus, neu waatine, chukula empo che'a yo'otaka nesau taiteko ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ju'u Jesus iniau: ―Lutu'uriapo ne eu inen jiia, tua i'ani, jum Liojta yoemiam che'a bat yaaja'u, em nemak ama annee'u ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Junama jumak jaibu luula yejten. Junak intok si'imekut junama'a ka machika taawak. Ini'i junuen kupteo, bajim jia'u tajtia ka machikai. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ju'u ta'a juni'i ka tachiriaka taawak. Jume' intoko, jum Liojta te'opopo jume' bwe'u tajo'orim ammea a' pattituka'um, inime'e nanana'aku nasuk, jikat naateka, ko'om tajtia siutek. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Junak intok ju'u Jesus, kusisi inen chaaek: ―In yo'owa Lios, in jiapsita nee em mampo su'u toja ―ti jiakai. Inika'a intok teuwaaka, muukuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Junak ju'u Romapo betana, junama sontaaommeu ya'ut, si'imeta juka' ama yeu sikamta a' bitchukai, Liojta yo'orek inen jiakai: ―Lutula wee'po, ini'i yoeme, kaita ka tu'ik ya'ariakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Si'ime ju'u yoemra ama ane'u, juka' junama yeu sikamta jaibu bitchukai, tua bem a' juiwa'uta teuwaaka, taupo emo chonaka, junama yeu sajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Taa si'ime jume' aapo'ik Jesujta ta'aa'um intok ket jume' jaamuchim, jume' Kalilea bwiaraa' tea'a betana naateka a' sualeka, aamak rejtisuka'um, bempo junama ili aman mekka ja'abweka, inika'a weyemta a' bitchuka taawak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Junama intok senu yoeme, ini'i tua tu'i yoemtaka, intok Liojta yo'ori ta'aakai, Jose' teaka ama jiapsan. Ini'i, jurea bwiaraa' tea'po, ili bwe'u jo'ara Arima tea'ati teaka'po jometakai. Aapo junama juriommeu yo'o ya'uraapo na'ikiatukan. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ini'i Jose' teame, Liojta inim bwiapo che'a yo'otaka kateka a' nesaunee'uta a' bit bo'o bichan. Junuen san ini'i, junama juriommeu yo'oraata bem yaaka'u betana ka amemak ean. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aapo junak ju'u kobanaao, Pilaato' teamtau noiteka intok junau juka' Jesujta takaawata au a'awak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chukula junama'a kuuset ko'om a' teksukai, aapo, bwe'u tosai tajo'orimpo a' biijtak. Intok inika'a, tetapo yee ma'a betchi'bo wojo'oriata ya'aripo, kee jabeta ma'awa'po, junama a' teekak. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Inim junak yokoriapo aet yum jo'e taewaituka' betchi'bo, junaet a' yuma' betchi'bo si'ime tu'utewan. Juna'a taewai jaibu abe naatekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jume' jaamuchim, Kalilea bwiaraa' tea'a betana naateka, ju'u Jesujta mak aman yajilamtuka'um, inime'e junaman a' ma'awaka'u bicha sajaka a' bichak. Intok juka' takaata jachin a' tekwaka'ut a' mammatek. ");
INSERT INTO yaqNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Intok inime'e jaibu bem jo'arau nottisukai, bempo juka' ba'ata intok ochokok tua win jubak a' ya'ariak. Junak intok Moiseej tuka'uta junuen a' nesaweka'po aman, ju'u aet yum jo'e taewait bempo junuen yum jo'ekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Semaanata aet naate'u yeu matchukai, inime'e jaamuchim, tua ketwoo junaman tetapo wojo'oriata ya'ariu bicha nottek, juka' win jubak intok ochokok bem tu'uteka'uta weiyaakai. Waate jaamuchim intok ket amemak kaaten. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Junaman bempo yajakai, juka' bwe'u tetata wojo'oriata ae pattita, omola biaktita teak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Intok junama wajiwa bempo kiimuk. Taa juka' yo'owe Jesukrijtota a' takaawata ka ama a' teak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Inime'e bempo womtilamtukan, kaachin an machikai. Seej chukti intok wooi o'owim, tua tojsasaalaik tajo'oreka ameu ja'abwekame teak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bempo'im intok junuen ketun tua majjaeka, tonommea ja'abweka, bwiau ko'om am cha'ako, juname'e o'owim: ―Jaisaaka eme'e inim kokkolam nasuk juka' jiapsamta jaiwa ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kaabe inimi'i bwe'ituk kokkoarim nasuk juchi jiabijtela. Au waatine, aapo'ik ketuni Kalilea bwiaraa' tea'po aneka, inien emou a' jiaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","A' utte'atune'eti jiakai, aapo'ik juka' inim yoemta, ka tu'i yoememmeu a' su'u tojinaa'uta. Juname'e, kuuset a' poponne'eti jiakai. Intok baji taewaita weyeka, juchi a' jiabijtenee'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Junako bempo, aapo'ik Jesujta teuwaaka'ubeu wawaatek, ");
INSERT INTO yaqNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","intok chukula bempo jum tetapo wojo'oriata ya'ari betana nottekai, si'imeta inika'a, jume' woj mamni ama wepu'ulaika yeu a' pu'aka'ummeu intok si'ime jume' waate ama anemmeu a' teuwaak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jume' inika'a lutu'uriata, jume' Krijtota yeu pu'arimmeu a' etejokame inime'em tukan, ju'u Maria Maareena' teame, intok ju'u Joana' teame intok juka' Jakoobo' teamta ae, Maria' teame intok jume' waate jaamuchim. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Taa ini'i, bempo'im teuwaa'u, jume' Krijtota yeu pu'arim betchi'bo, ka suawakamta benaekan. Intok bempo iniat ka am sualek. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Taa junuentaka juni'i, ju'u Peeo junama yeu sikaa, intok buiteka junaman tetapo wojo'oriata ya'ariu yepsak. Intok junuen aapo junama wajiwa jiwekai, jume' bwe'u tosai tajo'orim omola katekame bichak. Junak intok a' jo'au nottek, junama yeu sikamta betchi'bo tua suum'eakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jiba junae taewaitchi, jume' majtim betana woika, ili jo'ara Ema'uj tea'u bicha kaaten. Ini'i, jum bwe'u jo'ara Jerusalen tea'u betana woj mamni ama wepul kiloometrom jiba. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Inime'e, si'imeta juka' ama yeu simlata nau etejo sakan. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Intok ketuni nau am etejoka intok emo am tettemaeo su, jiba aapo ju'u Jesus, ameu rukteka intok amemak wee taitek. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Taa inime'e intok, kia a' bichaka juni'i, aapo'ik a' jabe tuka'ut san ka aet ju'uneetuawan. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Junak intok ju'u Jesus: ―Jitasa eme'e nau etejo saka bo'o joakai. Jaisaaka eme'e tua sioka ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Inime'e betana seenu, ju'u Kleopaaj ti teame inen jiiak: ―Si'imekut ju'uneewa inime'e taewaimmet, jum bwe'u jo'ara Jerusalen tea'po yeu sikamta betana. Jaisa empo junama kateka juni'i, inika'a ka ju'uneiyaa ja'ani ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aapo junak: ―Jitasa ama yeu siika ―ti ameu nattemaek. Bempo intok: ―Ju'u Jesus, jum Nasaret tea'po jometau yeu sikame. Ini'i, chukula yeu weenemta a' tetteuwaa'u. Aapo, Liojta bichapo intok yoemrata bichapo juni'i, juka' a' joa'uta intok yee a' majta'uta tua machisi utte'aka a' weetuan. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Intok inika'a, jume' te'opopo tekiakammeu yo'owe intok jume' inim itom yoemratau yo'ooraata, aapo'ik kuuset popontuka a' mukne' betchi'bo, bempo'im aet nesaweka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Itepo intok te aet bo'o bichan, aapo'ik junuen, inim juka' Isra'el yoemrata, ta'abwi ya'uraata betana a' jinne'une'po. Intok naa buustia, i'an iniat chukula, jaibu baji taewaim weye juna'a yeu sikaari. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ito betana wate jaamuchim ala itom womtala o'oben. Bwe'ituk bempo tua ketwoo junaman tetapo wojo'orita ya'ari'u noiteka, ");
INSERT INTO yaqNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","intok inime'e junuen, junaman a' takaawata ka teakai, itom ane'u itou yajjak intok bempo, ankelesim, inime'e Jesujta a' jiapsa'po am tejwaakame emo am bichak, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Junama sepia, ito betana wate o'owim junaman tetapo wojo'oriata ya'ari'u sajaka, intok bempo, jume' jaamuchim a' teuwa'a benasi aman a' mammateka a' bichak. Taa aapo'ik juka' Jesujta ka a' bichak ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Junak ju'u Jesus inimmeu: ―Tua eme'e ka suawaka, kaita a mammate. Intok si'imeta juka'a, jume' Liojta betana ju'uneetuawaka, bem teuwaaka'uta, a' sual betchi'bo tua bibinwatu ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Jaisa emo betchi'bo jum ji'ojteimpo ka ju'unakkiachi ja'ani, juka' Krijto'o teamta, teekau kee che'a yo'otaka a' yejteeo, junuen tua jiokot au a' bitnee'uta, au a' utte'atuka'u ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Junak intok aapo, jum Liojta nok lutu'uriapo, jum Moiseejtuka'uta ji'osia ji'ojteim betana naateka, intok ket si'ime jume' Liojta betana ju'uneetuawaka nokaka bem ji'ojteim betana, juka' aapo'ik betana ama ji'ojteita, jachin a' jiubae'po, machisi ameu a' teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jum ili jo'arau, Ema'uj ti tea'u jeela bempo yajibokai, ju'u Jesus, naa buustia weebaemta benaekan. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Taa bempo, junama'a a' tawane' betchi'bo au nookak: ―Inim itomak tawane, bwe'ituk tua kupte intok abe ka machia ―ti jiakai. Junak ju'u Jesus ama jo'arau amemak yepsak ama tawabaekai. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Intok aapo jaibu mesau amemak katekai, aapo, jume' paanim nu'uka, ame betchi'bo Liojtau bicha noksukai, junak am rebektaka intok ameu am bwisek. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Junama lautipo sep bempo aet ju'uneetuawak, intok aapo'ik a' jabetuka'uta a' ta'aak. Taa junak aapo seej chukti ama kaabetuk. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Junak bempo inen nau jiian: ―I'an te ju'unea, jum bo'ot itomak a' etejo simeka intok juka' Liojta nok lutu'uriapo ji'ojteita ju'unakkiachisia itou a' teuwaao, aapo'ik betchi'bo juka' jiapsipo itom siok'allea'uta itom a' ine'aka'po ―ti nau jiian. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Junak bempo, ka intok bo'o bichaka juchi yeu sajak. Intok bwe'u jo'ara Jerusalen tea'u nottek. Junaman bempo, jume' woj mamni ama wepu'ulaika, Jesujta yeu pu'arim, intok jume' waate amemak rejteme nau emo tojilammeu yajak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Inime'e nau aneme intok: ―Lutu'uriapo jiabijtek ju'u yo'owe Jesukrijto. Ju'u Simoo' teame intok a' bichak ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Junak intok ket inime'e, jum bo'ot bem bichaka'uta, intok Jesujta, aapo'ik junuen jume' paanim rebektaka ameu am bwiseko bempo'im aet ju'uneetuawaka'uta ameu a' etejok. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bempo'im inia weyemtat ketuni nau am etejoo su, junak ju'u Jesus bempo'im nasuk kiktek intok ameu tebotek: ―Yanti elwame emou aune ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bempo tua womtilataka intok tua majjaeka, senuk ka jiapsamta emo bicha'a ti eakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Taa ju'u Jesus inimmeu: ―Jaisaakai eme'e womtilaa. Jaisa betchi'bo eme'e inia betana ka inien a' lutu'uria'ati ea ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mampo intok wokpo em nee bicha, jiba ne inepo juna'a. Net em mamma intok junuen em ju'uneene. Bwe'ituk inien takaakamta enchim nee bicha'a benasi, ju'u ka jiapsame, ka takaak ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Inien ameu jiupat intok a' mamam intok a' wokiwam am bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Taa bempo'im junuen alleerimmea intok suum'eaka, ketun ka a' sualeo, aapo ju'u Jesus: ―Jitasa in bwa'anee'u inim aayuk ja'ani ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Junak intok bempo kuchuta soba'ita rebbeik intok muumum ba'awakame au tojak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aapo a' mabetaka intok ama ame bichapo ji'ibwak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Junama sepia aapo inimmeu: ―Ju'u neu yeu sikame, jiba wa'a ketuni emomak aneka ju'u in emou teuwaaka'u. Ini'i, jum Moiseejtuka'uta ji'osia ji'ojteipo intok jume' Liojta betana ju'uneetuawakame nokaka bem ji'ojteipo intok jume' bwikim benaka salmom tea'po, ju'u neu chupne'eti jiaka, si'ime wa'a nee betana ama ji'ojtei juna'a ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Junak aapo, inime'e, Liojta betana ji'osia ji'ojteimmet, machisi amet am ju'uneetuak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Intok inen ameu jiakai: ―Junuen ji'ojtei, juka' Krijto' teamta, a' utte'atuka'u a' me'etunee'uta, taa intok ket, baji taewaita weyeka, kokkoarim nasuk a' jiabijtenee'uta ―ti jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Intok ketchia, jiba aapo'ik betana lutu'uriaka, si'ime aniat yoemratau bicha, jum bwe'u jo'ara Jerusalen tea'po naateka, inimmeu, ka tu'ik betana bem emo temaeka junuen bem ka tu'uwa ya'arimmet bem jiokoitunee'ut aapo'ik betana ameu nokna'a ―ti jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eme'e intok, inia betana si'imeta bitlamtaka, a' teuwaa saka. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Intok a' ju'uneiyaane. Inepone, juka' in achai Liojta betana emou a' chupne'eti jiaka emou na'ikiarita, ineponee emou a' bittuane. Taa inim bwe'u jo'ara Jerusalen tea'po eme'e tawane, Liojta betana weyeka, juka' utte'ata emot a' autuawa'po tajtia ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Junak intok ju'u Jesus, junama bwe'u jo'arapo yeu am nuk siika, ili jo'ara Betaania' tea'u tajtia. Junama intok ame bepa jikau mamteka Liojtau bicha ameu tu'ik am a'auriak. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Intok ketuni junuen am nokriaka su, aapo laauti jikau siika intok junuen teekau jikau tojituk. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bempo intok junama'a a' yo'orisukai, juchi junama Jerusalen tea'u nottek, tua alleakai. ");
INSERT INTO yaqNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Intok bempo, jiba jum Liojta te'opopo aanen, Liojta bem yo'oree'uta, alleaka a' teuwaakai. Junuentune.");
INSERT INTO yaqNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ke'esamriapo, si'imeta aet naateko, ju'u Krijto, Liojta betana nooki ti ta'eewame jaibu jiapsan. Ini'i nooki ti teakame, aapo Liojta mak aanen. Intok aapo Liojtukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Junuen san, aapo ke'esamriapo si'imeta aet naateo, aman Liojta mak aanen. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Si'imeta juka' inim ayukamta aapo a' ju'unaktei. Tua kaita aayuk, ju'u ka aapo'ik betana weyeka ayukame. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ju'u jiapsiwame aapo'ikut ayukan. Ini'i jiapsiwame intok, inim jume' jiapsame betchi'bo, tu'uwataka tachiriata benasi aapo a' weiyaan. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ini'i, tachiriapo teuwaawame intok, jum ka machiku, ka tu'isi weyemta beje'eka, tachiriata yeu a' machialaa. Ju'u ka machiria intok ka a' koba'amachi. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Senu inim aanek, Joan ti teakai, Liojta betana a'abo bittuaritakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ini'i, aapo juka' tachiriapo ta'eewamta betana a' nokne' betchi'bo a'abo yepsak. Junuen aapo'ik teuwaa'ue, junaka'a bem sualne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ini'i Joan, aapo ka juna'atukan ju'u tachiriapo ta'eewame. Taa aapo wepulsi junae betana a' lutu'uriatuka'uta nokne' teaka a'abo bittuaritukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ju'u tachiriapo ta'eewame, lutu'uriapo Liojta betana weyeme, ju'u si'ime jume' inim jiapsammeu tu'ik weiyaame, aapo a'abo inim yebissusekan. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Intok wa'a nooki ti teakame, aapo inim bwiapo aanen. Intok aapo inika'a aniata a' ju'unakteka juni'i, jume' inim jiapsame, a' jabetuka'po ka a' ta'aak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aapo inim bwiapo, aapo'ik ju'unakteipo yepsak. Taa inim jume' aapo'ik betana kateka jiapsame, inime'e ka a' mabetak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Junuentaka juni'i, waate tu'isi a' mabetaka intok a' sualek. Inime'e, bempo'immeu aapo, Liojta betana bem yoemiam tunee'uta ameu chupuk. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Inime'e ka jak weyeo senu yoemratat yeu katriam bebena intok ka inim yoemem yeu tom tomte'ebenakai. Intok kia ka jabe yoemta junuen a' ea' betchi'bo junuen Liojta yoemiarim. Ala inime'e, Liojta betana yoemiarim. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Intok juna'a nokipo ta'eewame, aapo ito benasi au yoem yaak. Intok inim ito nasuk jiapsak, tua yee nak ta'aakai intok lutu'uria aet ayukai. Intok jiba aapo'ik Liojta betana wepulaika a' yoemia tuka' betchi'bo, aapo'ik juka' tua ujyooik intok eiyaawatchik aet ayuka'uta, itepo tee a' bitlaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ju'u Joan, yee babatoowame, inia betana ju'uneaka, ka a' essoka, si'imem bichapo inen jiiak: ―Ini'i juna'a wa'a, junak aet nokaka: “Net cha'aka yebijneeme, juna'a che'a nee bepa eiyaawatchi, bwe'ituk aapo nee bepa che'a bat jiapsan” ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Itepo tee si'ime juka' tu'ika, kaitau a tamachiatuka, aet ayukamta intok ka a lu'utemta a' mabetri. Inika'a tu'ik junuen nat chulukai. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Jume' nesauri ji'ojteim, ju'u Moiseej tuka'uta betana weyeka ji'ojtewak. Ju'u intoko, ka itou cha'aka juni'i, yee a' nak jiokolee'u intok aapo'ik betana lutu'uriata, aapo ju'u yo'owe Jesukrijto a' weiyaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Inim tua kee jabe Liojta bicha, taa aapo'ik Liojta betana ju'u wepu'ulaika jiba a' yoemia, ini'i aapo a' yo'owa Liojtamak wepu'ulai benasi aamak jiapsame, aapo juna'a ju'u itom a' ta'aatuakame. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jume' juriom jum bwe'u jo'ara Jerusalen tea'po jo'aakame, inime'e, wate te'opopo tekiakame intok waate, inime'e te'opopo bem joa'ut am aniame, Lebiitam teame, ju'u Joan teamtau am bittuak, junuen aapo'ik a' jabetuka'ut bem au nattemaine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aapo intoko tua machisi lutu'uriata nenkak inen jiakai: ―Ineponee ka juna'a ju'u Krijto' teame ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Junak intok bempo juchi au nattemaek: ―Jabesa'akun empo. Jaisa empo juna'a ja'ani, ju'u Liojta betana ju'uneetuawaka nokakame, ju'u Eliaj tuka'u ja'ani ―ti jiakai. Ju'u Joan intok: ―Kannee juna'a ―ti jiiak. Chukula ket juchi: ―Junak su, jaisa empo juna'a ja'ani, wa'a Liojta betana ju'uneetuawaka nokneeka bo'o bitwame ―ti au nattemaiwak. Aapo intok: ―E'e ―ti am yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Junak intoko: ―Junak su jabesa empo junuentuko. Bwe'ituk utte'a, jume' a'abo itom bittuakammeu lutu'uriata itom ameu teuwaanee'u. Jaisa empo ee betana itom tejwaa machi ―ti au jiuwak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ju'u Joan inime'e inen yoopnak: ―Ineponee ju'u, mekka pa'aku, kaabeta jo'araka'po, chaaeka inen nokamta jiawai: “Juka' yo'ota a'abo yebijnemta a' mabet betchi'bo, juka' ka tu'ik su'u tojaka, aawas emo tu'utene”, ti jiame, tua ju'u Isa'iajtuka'u, Liojta betana ju'uneetuawaka aapo'ik a' teuwaaka'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jume' aman ju'u Joanta mak etejokame, inime'e, paiseeom teame betana aman au bittuarimtukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Inime'e intok: ―Junak su, empo ka ju'u Krijto tuko intok kia ka Eliaj tuko intok kia ka ju'u Liojta betana ju'uneetuawaka nokame yebijneeka bo'o bitwame tuko juni'i, jaisaaka intok empo yee babatoowa ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ju'u Joan inimmeu inen jiiak: ―Ineponee ba'ammea yee babatoowa. Taa inim emo nasuku senu aane ka enchim ta'aa'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aapo net cha'aka yebijne, ini'i ala lutu'uriapo che'a nee bepat weyeka juni'i. Inepo, jume' aapo'ik bocha wikiam in a' woitarianee'u kia juni'i kanne ino jabele ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Si'ime ini'i, jum ili jo'ara Betaabara' tea'po yeu siika. Ini'i, batwee Jooraan tea'po, ta'ata yeu we'e betana taawa. Jum juka' Joanta yee a' babatoowa'awi. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yokoriapo intok ju'u Joan, juka' Jesujta aapo'iku bicha weyemta bichaka: ―Yuu, ake'em a' bicha. Ini'i juna'a wa'a Liojta betana ili bwala ti teuwaawame, ju'u inim bwiapo jiapsame, bem ka tu'uwa ya'arita aapo a' mabetneeme. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aapo'ik betana nee nookan junak inepo: “Chukula net cha'aka senu o'ou yebijne, ini'i che'a nee bepa eiyaawatchikai. Bwe'ituk aapo che'a nee bepat jaibu jiapsan”, ti ne jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Jiba inepo juni'i, nee aapo'ik a' jabetuka'ut ne ka ju'unean. Taa inepo nee jiba junuen ba'ammea ne yee bato'owaaka ne yebijlaa, jiba junuen juka' Ijra'el yoemrata, tua lutu'uriapo a' jabetuka'uta bem a' ta'aane' betchi'bo ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ju'u Joan ket inen jiiak: ―Ineponee intok, juka' Liojta tu'u jiapsita, wokkoita benaka, teeka betana ko'om weyeka intok inia aapo'ikut tawakamta ne bichak ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Inepo ketun nee ka ju'unean, junaka'a a' jabe tuka'ut, taa ju'u, ba'ammea nee yee bato'owaane' betchi'bo nee a'abo bittuakame, juna'a ket: “Empo jak juka' Liojta tu'u jiapsita, senukut ko'om weyeka intok junaet tawakamta a' bichako, ini'i juna'atunee ju'u, Liojta tu'u jiapsita emot autuaka, junae yee babatoowaneeme”, ti neu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Inepo intok jaibu a' bitlaa intok jiba ineponee inien weyeka aapo'ik junuen Liojta betana a' yoemiatuka'uta, nee a' teuwaa ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Juchi yokoriapo intok ju'u Joan intok wooika jume' a' majtim, jiba junama'a juchi ama rejten. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Intok aapo, juka' Jesujta junama wa'am weyemta bichakai: ―Yuu, ake'em a' bicha. Ini'i juna'a ju'u, Liojta betana ili Bwala ti teuwaawame ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jume' woika Joanta majtim aapo'ik junuen jiamta a' jikkajaka, bempo ju'u Jesujta mak sajak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Junak intok ju'u Jesus, amau bitchuka intok bempo'im aet cha'aka kateme bichakai: ―Jitasa eme'e jaiwa ―ti ameu jiiak. Bempo intok: ―Yee majtame, jakunsa empo jo'aak ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus intok inimmeu: ―A'abo kateka a' bitne ―ti jiaka am yoopnak. Junak intok bempo aman sajaka intok a' jo'aaka'po a' bichak. Intok junae taewait ama aamak taawak, bwe'ituk jaibu kupten, jumak naikim jiao. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wooika jume' Joanta jikkajaka intok Jesujta mak sajakame betana, senu Antej ti teakan, Simoo Peeo' teamtamak weri. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ini'i Antej teame, tua bat, kee jita intok yaakai, juka' aamak werik, Simoo' teamta jaiwak, intok: ―Juka' Mesiaj ti teamta te a' ju'uneiyaa ―ti au jiiak. Ini'i, Krijto ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Junama sep ju'u Antej teame juka' Simoo' teamta, jum Jesujta ane'u a' tojak. Ju'u Jesus intok inika'a bichakai: ―Empo Simoo' tea juka' Jonaj teamta u'usi. Taa empo Sepaajpo ta'eenaa ―ti au jiiak. Inime'e team intok, ket Peeo ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Juchi yokoriapo intok ju'u Jesus Kalilea bwiaraa' tea'u bicha weebaeka intok senuk, Jeriipe' teamta bichaka, junau: ―Nemak weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ini'i Jeriipe' teame intok, ili jo'ara Betsaira' tea'po jometukan. Jum Antejta intok Peota jo'aaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ini'i Jeriipe' teame intok, senuk Natana'el teamta jaiwaka intok: ―I'an itepo waka'a o'outa, Moiseej tuka'uta jum a' nesauri ji'ojteimpo aapo'ik betana ji'ojtewakamta, intok ket jume' Liojta betana ju'uneetuawaka nokame, inime'e aapo'ik betana ji'ojtewakamta, junaka'a itepo aman te a' bichak, ju'u Jesus ti teakamta, ju'u Jose' teamta u'usi, jo'ara Nasaret tea'po joome ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ju'u Natana'el intok: ―Jaisa aman ili jo'ara Nasaret tea'po jitaa tu'ika a ama yeu wee machi ja'ani ―ti au jiiak. Ju'u Jeriipe intok: ―A'abo sika a' bitne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Junak Jesus intok, juka' Natana'el teamta au weyemta bichaka: ―Inim senu weye, tua lutu'uriapo Ijra'el yoemrata betana usiaritakai, aapo'ikut ju'u yee bai ta'aawame kaita aet aayuk ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Junak intok ju'u Natana'el teame: ―Jaisa empo nee ta'aa ―ti au nattemaek. Jesus intok: ―Juka' Jeriipe' teamta kee enchi tejwaao, empo aman chuna'ouwota betuk enchi kateko, nee enchi bichak ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Junak ju'u Natana'el: ―Yee majtame, empo tua juna'a ju'u Liojta yoemia. Empo tua juna'a wa'a, inim Ijra'el yoemratau che'a yo'o ya'ari ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ju'u Jesus iniau: ―Jaisa empo, chuna'ouwota betuk enchi kateko nee enchi ino bichak ti in eu jia' betchi'bo jiba, empo nee suale ja'ani ―ti au jiiak―. I'an empo inia weemta bepa che'a juni'i suum watchisi machik empo bitne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ketchia ju'u Jesus iniau: ―Tua ne a' lutu'uriatune'eti ne emou jiia, eme'e, juka' teekata au etapolaata intok jume' Liojta ankelesim, ju'u inim yoemta a' kateka'po, ae bepa ko'om bicha intok jikau bicha kateme eme'e am bitne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Baji taewaim sikaa, chukula, jum mekka ili jo'ara bwiaraa Kalilea' tea'po kateka, Kanaa' tea'po, jujupwan. Junama'a Jesujta ae ket ama aanen. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ju'u Jesus intok jume' a' majtim ket junaman jujupwa'u nunuwak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Junama'a juka' pa'asi ba'awata lu'uteko, ju'u Jesujta ae intok aapo'iku: ―Ju'u pa'asi ba'awa lu'utek ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Taa ju'u Jesus: ―Jaisaaka empo iniet nee tetejwaa. Ketun kee yuuma ju'u taewai inien weyemta in a' ya'anee'u ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Taa ju'u Maria, jume' junama'a nesauta joammeu: ―Si'imeta juka' aapo'ik enchim aet tejwaa'uta, junaka'a eme'e a' joone ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Junama'a busan bwere teta soto'im manekan. Inime'e, jume' juriom, Liojta bichapo emo tu'ute betchi'bo emo komoniaka, bem sawa'um. Junama'a we'epulaimpo, jumak naiki taka oo mamni taka liitro ba'am ama kiareakan. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ju'u Jesus, jume' ama nesauta joammeu: ―Inime'e soto'im ba'ammea am tapuniane ―ti ameu jiiak. Juname'e intok junuen, tua am tappuniak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Junak intok ju'u Jesus inimmeu: ―I'an ala, watem ama yeu to'aaka, intok eme'e ju'u inim pajko jujupwa'po junama yo'o ya'ariu am tojine ―ti ameu jiiak. Bempo intok junuen aman au am tojak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ju'u intok junama'a pajko jujupwa'po yo'o ya'ari, jume' ba'am jaibu pa'asi ba'awa tulame am jiiwek, ka ju'uneakai jakun bem nu'uwaka'u. Ala jume' nesauta ama joame jiba junammet ju'unean. Bwe'ituk bempo jume' ba'am ama yeu to'alatukan. Junuen san ju'u ama pajko jujupwa'po yo'o ya'ari, ju'u ama jubemtau chaaek, ");
INSERT INTO yaqNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","intok inen au jiiak: ―Inim si'ime, juka' pa'asi ba'awata ji'inaamta, juka' che'a tu'ik bat yeteu totoja. Chukula intok jume' nunurim jaibu junaka'a yu'in am ji'ilatuko, junak juka' che'a ka tu'ik ameu totoja. Taa empo juka' che'a tu'ik i'an ju'ubwa itou a' tojilaa ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ini'i jum ili jo'ara bwiaraa Kalilea' tea'po kateka, Kanaa' tea'po Jesujta yaaka'u, inim tua ujyoisi eiyaawatchika a' joa'uta, aapo a' bit tebobaekai, ju'u machilaa a jita a' joaka a' yaaka'uta, tua ke'esamria tukan. Jume' a' majtim intok junama'a aapo'ik sualek. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Iniat chukula aapo, bwe'u jo'ara Kapernau' tea'u bicha siika. A' aewa intok jume' a' sailawam intok jume' aapo'ik majtim ket aamak katekai. Junama'a bempo ka jaiki ta'apo aanek. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Junama san jaibu juriom pajko, bwalam aet jissu'a taewaita ka mekka a' be'eeo, ju'u Jesus, bwe'u jo'ara Jerusalen tea'u siika. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Junama Liojta bwe'u te'opopo, aapo, jume' boesim intok jume' bwaaram intok wokkoim nenenkame ama bichak. Intok ket jume' tomita nanakuliariame jum bem tekipanoa'po jokammeu yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Inika'a aapo bichakai, ju'u Jesus, tettebe wikiam nat jijjo'aaka am jibebia yaak. Intok junama'a te'opopo si'imem, chikti bem bwarammak intok bem boesimmak, pa'akun yeu am beebak. Jume' tomita nanakulia'um, juka' bem tomita ko'om am wo'otariak. Jume' intoko meesam na'ikim am wo'otariak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wame'e wokkoim ama nenenkammeu intok: ―Inika'a em pa'akun yeu tojine. In achaita te'opo, eme'e, ka jitaa ama nenki betchi'bo karita benasi a' tatawaane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Junak intok jume' a' majtim, Liojta nok lutu'uriapo inen ji'ojteitau wawaatek: “Juka' in yo'owata te'opota, aet jiapseka tua in a' eiya' betchi'bo, ini'i nee lu'uta”, ti a' jia'apo. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Junak intok jume' juriom: ―Inika'a em joone'po, lutu'uriata em jipue'ut a itom ju'uneene' betchi'bo, jitaa machilaatasa empo a itom bittua ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ju'u Jesus intok inen am yoopnak: ―Eme'e inika'a te'opota mojaktane, ineponee intok baji taewaim weyeo, juchi bemelasi nee a' yecha'ane ―ti ameu jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Junak jume' juriom inen jiiak: ―Woi taka ama busan wasuktiapo ini'i te'opo ya'awak. Empo intok kaachin junuen baji ta'apo a' yecha'ane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Taa ju'u te'opo Jesujta teuwaa'u, jiba aapo a' taka teuwaan o'oben. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Inia betchi'bo san, chukula, Jesujta kokkoarim nasuk juchi jiabijteko, jume' a' majtim inika'a aapo'ik teuwaaka'ubeu wawaatek. Intok bempo Liojta nok lutu'uria ji'ojteita sualek intok waka'a nokita aapo'ik ameu teuwaari. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Junak Jesujta jum bwe'u jo'ara Jerusalen tea'po, junama'a juriom bwalam jissu'aka pajkota weye'po a' aneo, junama'a juebenaka aapo'ik machilaata a jita a' joa'uta a' bichaka, aapo'ik sualek. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Taa aapo ju'u Jesus, inime'e ka am yoem'eiyaak. Bwe'ituk juname'e si'imemmet ju'uneiyaakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aapo tua kaabeta betana a' bo'o bichan, aapo'ik inim watem betana a' etejorianee'uta, bwe'ituk aapo, jume' inim yoeme, bem eerimmet ju'uneakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Junama'a seenu, paiseeom teame betana weyeka Nikoreemo' teaka ama aanen. Ini'i intok jume' juriommeu yo'oraata mak na'ikiaritukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ini'i Nikoreemo' teame, tukaapo Jesujta a' ane'epo au noitek intok inen au jiiak: ―Yee majtame, ju'uneate Liojta betana em itom majtane' betchi'bo a'abo em bittuarituka'po. Bwe'ituk kaabe machilaata a jita a' joa'uta a' jooa em a' joa'a benasia, Liojta ka aamak tuko ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Junak intok ju'u Jesus iniau: ―Lutu'uriapo ne inen eu jiia, wa'a ka juchi yeu yoemtukame, ini'i, Liojta che'a yo'otaka a' kateka'uta, ka a' bitne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ju'u Nikoreemo' teame aapo'iku: ―Taa jaisa tua inien ju'u o'ou, yo'otaka a juchi yeu yoemtune. Jaisa ini'i juchi a' malabeu a notteka intok junuen juchi bemelasi yeu yoemtunee ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ju'u Jesus inen au jiiak: ―Lutu'uriapo ne inen jiia, wa'a, ju'u ba'ae ta'eewamtae intok ju'u Liojta tu'u jiapsie ka juchi bemelasi yoemtukame, ini'i, Liojta che'a yo'otaka a' kateka'u, kaachin a aman jiapsine ―ti a' yoopnak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wa'a inim yoemem yo'owaka yoemtukame, ini'i, jiba inim yoemtaka jiapsine. Wa'a intok, ju'u Liojta tu'u jiapsi betana bemelasi yoemtukame, ini'i, ale benasi jiapsiwamta jipu'une. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ka empo aet jachin eene, si'imem juchi bemelasi bem yeu yoemtunee'uta a' utte'a ti in eu jia' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ju'u jeeka a' weebae'u luula weama, juka' a' jiawaita empo a' jikkaja, taa jaku'ubo a' weye'ut intok kia jakun bichaa a' weye'ut juni'i, empo ka a ju'uneene. Inien ketchia inia bebena, si'ime jume'e, Liojta tu'u jiapsita betana bemelasi yoemtulame ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Junak intok ju'u Nikoreemo: ―Jaisa tua ini'i inien tune ―ti juchi au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ju'u Jesus inika'a: ―Empo ju'u inim Ijra'el yoemrata nasuk tua yo'oriwaka yee majtakai, jaisa iniat empo ka ju'unea ja'ani ―ti a' yoopnak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Lutu'uriapo ne inen eu jiia, itepote ala, juka' itom ju'uneiyaa'uta a' teteuwaa, intok itepo, juka' itom bitlaa'uta, a' ju'uneiyaaka a' lutu'uriate. Taa eme'e intoko, juka' itom emou teuwaa'uta, eme'e ka a' suale. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Eme'e ju'u jitaa inim bwiapo ayukamta betana nee emou nokao juni'i, eme'e ka nee sualekai, jaisa tua eme'e nee sualne, teekau ayukamta betana nee emou nokao. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Inim tua kee jabe teekau Liojtau yepsa. Ala wa'a juna'abo teeka betana yepsakame jiba. Ini'i, ju'u inim emo benasi yoeme, ju'u teekau joome. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Intok jiba junaen, bat naataka, juka' Moiseejtuka'uta, jum bweka pa'aku, juka' sisi'iwook bakotta, kutat a' chayaka'a benasia, junuen ket ju'u inim emo benasi yoeme, utte'a, junuen kutat jikat a' chaya'atunee'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Junuen beja si'ime jume' a' sualeme, inime'e ka jiba betchi'bo kokkoka, taa ala inime'e, jiba yuu jiapsiwamta bem bitne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Bwe'ituk ju'u Lios, inim aniapo juka' yoemrata, tua a' nakekai, aapo juka' wepul a' yoemiata, jiokot au a' bitne' betchi'bo a' su'u tojak. Junuen beja, si'ime jume' a' sualeme, inime'e, ka jiba betchi'bo kokkoka, taa ala inime'e, jiba yuu jiapsiwamta bem bitne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ju'u Lios, ka jume' inim bwiapo jiapsame, ka tu'isi am tawaabaekai, juka' a' yoemiawta a'abo a' bittuak. Taa ala aapo, inime'e jinne'ubaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Wa'a, juka' Liojta yoemiata a' sual ta'aame, ini'i, ka tu'isi a' tawaanaa'uta, ka a' bitne. Taa wa'a ka a' sual ta'aame, ini'i jaibu ka tu'isi tawaari, junuen juka' wepu'ulaika Liojta yoemiata, aapo'ik ka a' sualeka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jume' ka a' sualeme, jaibu ka tu'isi tawaarim. Bwe'ituk juka' Liojta yoemiata, ju'u tachiriapo ta'eewame, a'abo bwiau a' yepsako, inime'e, juka' ka tu'ik, ka machik benak che'a a' tu'urek, ju'u tachiriapo ta'eewamta bepa. Bwe'ituk bempo ka tu'ik bo'o jooriakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Si'ime jume' ka tu'ik joaka jiapsame, inime'e, juka' tachiriapo ta'eewamta ka tu'ure, intok kia ka au ruktibae juni'i, junuen, juka' ka tu'ik bem bo'o jooria'ut ka amet a' ju'uneiyaana' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Taa jume'e, lutu'uriapo bem bo'o jooria'ea'uta a' joaka jiapsame, inime'e ju'u tachiriau rukte, junuen ju'u bem joa'ut, Liojta betana aniawaka bem a' joa'uta a' ju'uneiyaana' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Iniat chukula ju'u Jesus a' majtimmak Jurea bwiaraa' tea'u bicha siika. Junama'a intok aapo, jume' a' majtimmak ili juebena ta'apo ama taawak, bempo yee bato'owaakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ju'u Joan teame intok ketchia, ili jo'ara Enon tea'po, ini'i, senu jo'ara Salim tea'po ka mekka, aapo yee bato'owaan. Bwe'ituk junama'a tua ba'a bu'uureakan. Ju'u yoemra intok junaman Joantau yajaka bato'owaawan. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ini'isan, juka' Joanta jum ye'e'etawa'u kee a' tojiwao yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Junak intok waate jume' Joanta majtim, junama wate juriommak emo nok bwisek, jachin emo ba'atuawaka, junuen Liojta bichapo emo tu'utewamta betana. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Junuen san, inime'e, juka' Joanta a' tejwaaboka au sajak: ―Yee majtame, a' ju'uneiyaane, wa'a batwee Joran tea'abeas, ta'ata yeu we'e betana emak ane'u, ju'u em aapo'ik betana itou nokaka'u, i'an ket juna'a yee bato'owaa intok si'ime jeela aamak eaka au yajja ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Junak intok ju'u Joan: ―Kaabe aane, ini'i, juka' au yumaka a' joonee'uta aet ayukame, ka Liojta betana a' mabetlatkai ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jiba eme'esu nee jikkajak, machisi, ineponee ka juna'a ju'u Krijto ti nee jiako. Ala inepo nee, senu yeu pu'aritaka nee aapat bittuari ti nee jiako. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jum pajko jujupwa'po, ju'u, juka' jubiwaituneemta mabetneeme, juna'a ju'u kunawaitune. Ju'u intoko, juka' jupbaemta binwatuk naateka a' ta'aame, ini'i ama aneka intok nokamta a' jikkajaka, tua alleene. Ket jiba junaeni, inepo junae betchi'bo ne tua allea. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Juna'a, aapo che'ewa su bichau bicha, yo'orisi a' eiyaanaa'u au lutu'uriatune. Nee intoko, che'a juni'i ka eiyaawatchisi in machinee'u, utte'a. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ju'u jikat teeka betana a'abo yebijlame, utte'a, ini'i inim si'imem bepa a' yo'otunee'u. Ju'u intoko inim bwiapo yeu yoemtulame, ini'i bwiae ya'ari intok inim bwiapo ayukamtat jiba ju'uneaka a' teuwaane. Taa ju'u jikat teeka betana yebijlame, utte'a, ini'i inim si'imem bepa a' yo'otunee'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Intok aapo a' bitla'uta intok a' jikkajila'uta a' teuwaa. Taa inika'a aapo'ik teuwaa'uta, tua kaabe a' suale. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Taa seenu, wa'a a' sualeka a' mabetakame, ini'i junuen, achai Liojta betana nokita tua a' lutu'uriatuka'uta a' ju'uneiyaa tebone. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bwe'ituk ju'u, Liojta betana yeteu bittuari, ini'i, Liojta betana juka' nokta weyemta a' teuwaa. Bwe'ituk ju'u achai Lios, juka' a' yoemiawata juka' a' tu'u jiapsiwata, kaita be'eeka aet autua. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ju'u achaiwai Lios, juka' aapo'ik yoemiata a' nak ta'aa. Intok aapo, aapo'ik mampo si'imeta su'u tojilaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wa'a, juka' Liojta yoemiata sualeme, ini'i, juka' jiba yuu jiapsiwamta bitne. Taa wa'a, Liojta yoemiata ka a' sualbaeme, ka a' bitnee junaka'a yuu jiapsiwamta. Ala juna'a, Liojta betana tua jiokot au a' chupnee'u au aune. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jume' paiseeom junak, juka' Jesujta, ju'u Joanta bepa che'a juni'i juebenam aamak eame ane'epo intok che'a yu'in aapo'ik am bato'owaa'uta a' ju'uneiyaak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Lutula wee'po, ka aapo ju'u Jesus yee bato'owaan o'oben. Ala jume' aapo'ik majtim. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Intok junak, junama'a ju'u Jesus, inika'a ju'une'eiyaakai, Jurea bwiaraa betana yeu siika, junuen Kalilea bwiaraa' tea'u bicha juchi nottibaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Aapo junam bicha weyekai, bwiaraa Samaaria' tea'po wa'am a' weenee'uta utte'atukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Junuen san aapo junama senu ili jo'ara Sikar tea'u yepsak. Samaaria bwiaraa' tea'po junama waj bwia juka' Jakoop tuka'uta, a' yoemiawa Jose' teamta a' mikla'u jeela. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Junama'a jume' Jakoop teamta posom teaka ama manekan. Bo'o joo lottilatakai ju'u Jesus junama'a juname bepa yejtek. Junama jumak luula yejteo. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jume' aapo'ik majtim intok, ili jo'arau Sikar tea'u inime'e bem bwa'anee'uta jinubaeka aman saka'alamtukan. Junak san bwiaraa Samaaria' tea'po joome, senu jamut junama posou ba'am nu'useka ama yepsak. Ju'u Jesus iniau: ―Ba'am nee miika ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Junak intok ju'u jamut Samaaria' tea'po joome, Jesujtau: ―Jaisaaka empo, jurio yoemtakai, nee bwiaara Samaaria' tea'po jometau ba'a netane ―ti au nattemaek. (Bwe'ituk jume' juriom, jume' bwiaraa Samaaria' tea'po joomemmak ka nau tuttu'ireakan.) ");
INSERT INTO yaqNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Junak intok ju'u Jesus, inen a' yoopnak: ―Empo juka' tua eiyaawatchik, Liojta betana weyeka, yee a' mika'uta a' ju'uneiya'ateko intok juka' eu ba'a netanemta a' jabetuka'po, empo neu am a'au ean, ineponee intok ba'am yee jiapsituame enchi am mik ean ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ju'u jamut intok: ―Japchi, kia jita juni'i, ba'am em ae yeu wiknee'uta, empo kaita jipue. Posom intok tua mekka ko'omi. Jaksa empo jume' ba'am yee jiapsituame nu'uka, nee am mikneekai ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ju'u Jakoobo' teame, ju'u itom yo'owasuka'u, inime'e posom yaaka, itou am to'o siika. Inime'e betana junako jiba aapo'ik, intok jume' a' yoemiawam intok jume' aapo'ik wakaseka'um inim ji'isuka'po. Intok jaisa empo i'an junae aapo'ik bepa che'a yo'owe ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ju'u Jesus inen a' yoopnak: ―Si'ime jume'e, inime'e inim ba'am je'ekame, juchi ba'a ji'ipeene. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Taa wa'a, jume' ba'am in a' miknee'um am je'ekame, juna'a jakwoo juni'i ka intok ba'a ji'ipeene. Bwe'ituk jume' ba'am in a' miknee'um, inime'e, jume' ba'am ka lu'u lu'uteka yeu weyeme benasi aet aune, junuen aapo'ik ammea jiba yuu jiapsine' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Junak intok ju'u jamut: ―Japchi, juname'e ba'am nee mikne, junuen ka intok in ba'a ji'ipeene' betchi'bo intok kia ka intok a'abo ba'am maneka'u in babatne' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Junak ju'u Jesus: ―Em kunabeu aman chaaeka intok junak aapo'iku mak juchi a'abo weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ju'u jamut intok: ―Kannee kuunak ―ti au jiiak. Jesus intok junak inen au jiiak: ―Lutu'uriata'e teuwaa, junuen, ka emo kunak ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bwe'ituk empo i'an tajtia mamnim kunalataka juni'i, kia i'an ju'u em aamak kateka'uta, empo ka a' kuunak. Inien jiaka'ut empo lutu'uriata teuwaalaa ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Inika'a jikkajaka ju'u jamut: ―Japchi, i'an ne ju'unea, Liojta betana ju'uneetuawaka, chukula yeu weenemta em noka'apo ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Jume' che'a bat naataka itom yo'owasuka'um, jume' inim Samaaria' tea'po joome, bempo inim ini'i kaupo Liojta yo'orisuk. Taa eme'e jume' juriom, bwe'u jo'ara Jerusalen tea'po a' juna'ati jiia, jum itom a' yo'ori'ea'po ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ju'u Jesus inika'a inen yoopnak: ―Iniat nee sualne, taewai yuma'ane, junak enchim, kia ka inia kawiu sajaka, intok kia ka jum bwe'u jo'ara Jerusalen tea'u sajaka juni'i junak achai Liojta enchim a' yo'orineeo ―ti au jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Eme'e jume' Samaaria bwiaraa' tea'po joomem, kate'em ju'unea ju'u enchim yo'oree'ut. Taa itepo ala, tee ju'unea ju'u itom yo'oree'ut, bwe'ituk ju'u yee jinne'uneeme, juriom betana yeu machine ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Taa i'an taewai yuma'asek intok jiba i'an su juna'a, jume' lutu'uriapo achai Liojta yo'orineeme, inime'e tua junen jiaka intok Liojta tu'u jiapsi betana aniawaka, lutu'uriapo bempo'im a' yo'orineeo. Bwe'ituk ju'u achai Lios, jume' aapo'ik yo'orineeme, junuen bem a' yo'orinee'uta ame tana a' waata. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ju'u Lios ka inim bittaka aapo jiapsa. Jume' intoko a' yo'oreme, inime'e, ju'u aapo'ik tu'u jiapsie aniawaka, tua bem tu'i'eerimmea intok ka jiapsita bepa bem a' yo'orinee'uta utte'a ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Junak ju'u jamut: ―Ju'uneanee ala, juka' Mesiaj teaka juka' ket Krijtopo ta'eewamta, inim a' yebijnee'uta. Intok junak aapo a'abo yepsako, aapo si'imeta machisi itou a' teuwaane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ju'u Jesus iniau: ―Inepo nee juna'a ju'u em teuwaa'u, jiba inepo emak etejome ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Junen su jume' Jesujta majtim au yajak. Intok bempo kaachin jiu machi, juka' Jesujta junuen jamuttamak a' etejomta bichakai. Taa kaabe, ju'u a' waata'ut oo ju'u aamak a' etejoo'u betana au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Junako ju'u jamut, juka' a' babu soto'iwata ama to'o sika intok aapo junama ili jo'arau bicha siika intok jume' junaman jo'aakammeu inen jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―A'abo kateka, eme'e senu o'outa, tua si'imeta in ya'arita neu teuwaarita a' bitne. Jumak juni'i ini'i juna'a, ju'u Krijto' teame ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Junak juname'e, junama'a ili jo'arapo yeu sajakai, intok Jesujta ane'u bicha yeu kat japtek. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Imin intok ketunia jume' aapo'ik majtim Jesujtau nookan: ―Yee majtame, ili'e ji'ibwa ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Taa aapo inimmeu: ―Ineponee bwa'amta benaka in bwa'anee'uta inepo a' jipue, enchim tua ka ta'aa'uta ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jume' aapo'ik majtim junak bempo nau: ―Jaisa senu jita a' bwa'anee'uta au tojak ja'ani ―ti nau jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Taa ju'u Jesus inimmeu: ―Juka' a'abo nee bittuakamta ea'po aman in aunee'u, intok juka' aapo'ik betana tekilta in a' chupa'anee'u, ini'i juna'a, wa'a bwa'amta benasi in bicha'u ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kati'in eme'e inen jijia: “Ketuni naiki mecham be'ee echimuta chuktana' betchi'bo.” Taa ineponee inen emou jiia, jume' a'abo kateka, jinne'uimtuneeme, eme'e mammatene, inime'e echimuta jaibu a' chuktanaa'u a' tu'ireaka'a benasi maachi ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wa'a am jinne'uimtune' betchi'bo ameu nokakame, ini'i, echimuta toboktamta benasi maachi. Intok aapo, a' tekilwa betchi'bo au tu'ik bitne. Ju'u intoko a' ya'ari, ini'i, jume' jinne'uimtukame, bem jiba yuu jiapsinee'u juna'a. Junuen juka' echakamta intok juka' junaka'a toboktakamta, inime'e nau aet alleene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bwe'ituk lutu'uria ju'u inim inen jijiuwame: “Ju'u senu etne, ju'u intok inika'a toboktaneeme, ta'abwine.” ");
INSERT INTO yaqNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ineponee jum tekilta ka enchim ya'ariu, echita a' toboktanee'u enchim aman bittuala. Junuen san, waate che'a bat juname'e jume' tekipanoalame. Eme'e intok juname'em, jume' bem tekil ya'ariapo juka' ili ama be'eemta joaka, ae betana tu'ik mabetneeme. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Juebenaka jume' junama bwiaraa Samaaria' tea'po ili jo'arapo joome Jesujta sualek juka' jamutta, juka' a' lutu'uria ti jiaka ameu a' teuwaaka'u betchi'bo: “Si'imeta juka' in ya'ari neu teuwaala”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Junuen san jume' bwiaraa Samaaria' tea'po joome aman au yajakai, au ujbwanak bempo'immak a' tawane' betchi'bo. Ju'u Jesus wooi ta'apo junama amemak taawak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Intok junama'a waate che'a juebenaka jiba aapo'ik juka' a' teuwaa'uta jikkajakai a' susualek. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Junak intok inime'e ju'u jamuttau: ―I'an ka ju'u em itou teuwaaka'u betchi'bo jiba te a' suale. Ala junuen jiba itepo tee ket aapo'ik jikkajilamtakai. Intok aapo'ik tua lutu'uriapo a' Krijtotuka'uta, ju'u inim yoemrata jinne'uneeme ket itepo ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Wooi taewaim simsuk chukula ju'u Jesus, bwiaraa Samaaria' tea'po yeu sika intok bwiaara Kalilea' tea'u bicha yebijbaeka bo'o joo taitek. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bwe'ituk jiba aapo'ik Jesujta junuen jiaka'a benasia: “Seenuk, waka'a Liojta betana ju'uneaka chukula yeu weenemta tetteuwamta, ini'i, tua a' bwiaraapo ka eiyaatune”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Junak aapo'ik jum bwiaraa Kalilea' tea'u juchi a' yepsako, jume' junama'a joome tu'isi a' mabetak. Bwe'ituk inime'e ket jum bwe'u jo'ara Jerusalen tea'po, bwala jissu'awaka pajkowaka'u aanen. Intok inime'e si'imeta juka' junama pajkopo aapo'ik yaaka'uta a' bitlatukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Junak intok ju'u Jesus, bwiaraa Kalilea' tea'po, ili jo'ara Kanaa' tea'u juchi nottek. Junama aapo'ik a jita a' joa'apo aman, ba'am pa'asi ba'awata am yaaka'po. Junama intok ju'u che'a yo'o ya'arita nesawe'po tekilta joame, ini'i jum bwe'u jo'ara Kapernao' tea'u senuk ko'okoemta usekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Junako, ju'u yo'oraata betana tekilta joame, juka' Jesujta, Jurea' tea'a betana jum bwiaraa Kalilea' tea'u a' yepsaka'ut ju'uneakai, aman a' ane'u au noiteka intok a' jo'au sika intok juka' a' yoemiawata au a' ine'etetuane' betchi'bo au ujbwanak, inika'a jaibu abe mukemta. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Junak ju'u Jesus iniau inen jiiak: ―Jitaa machilaata intok juka' jita senuk a joa'uta suum watchika senuk a joa'uta ka a' bichakai, eme'e kaita sualne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Taa ju'u yo'oraata betana tekilta joame inen au jiiak: ―Achai, lauti aman weene, juka' in yoemiata kee a' mukeo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Junak ju'u Jesus iniau: ―Em jo'aau nottine. Ju'u em yoemia tu'isuk ―ti au jiiak. Ini'i, juka' Jesujta au teuwaaka'uta a' sualeka intok junuen siika. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Junak a' jo'au aapo'ik yebijsuseeo, jume' aapo'ik tekoka tekipanoame, a' nankika: ―Em yoemia tu'isuk ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Junak intok ameu nattemaek jak weyeo aapo'ik au a' ine'ete taiteka'po. Bempo intok: ―Tuuka, luula yejtesuka ko'om kuakteo, ju'u taji wechia a' su'u tojak ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ju'u yo'owe junak ju'uneak, jiba junama orapo juka' Jesujta: “Ju'u em yoemia tu'isuk”, ti au a' jiaka'po a' tu'ireaka'po. Junak aapo intok si'ime jume' aamak jo'aakame juka' Jesujta sualek. ");
INSERT INTO yaqNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ini'i san juna'atuk, iniamak woika, juka' Jesujta aapo'ik suum watchik machilaata a jita a' joa'ue a' yaaka'u, aapo'ik Jurea' tea'a betana bwiaraa Kalilea' tea'u nottekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Iniet chukula jume' juriom senu pajkota weetuan. Junak intok ju'u Jesus, bwe'u jo'ara Jerusalen tea'u juchi nottek. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Junama bwe'u jo'arapo, senu pueeta, Bwaram ama yeu rejte ti ta'eewa'u jeela, bau ba'am benam manek. Inime'e intok ebreo nokpo, Betejta' teakai. Ini'i ae konila, mamni bwereka mekka jikau, jitae ya'arim, jekkaam jipuen. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Junama'a jekka ya'arimpo jume' ko'okoeme tua juebenaka ama tojirimtaka bwiapo to'okan. Ka bibichame, jume' lolo'im, intok jume' ka emo taka yekame. Inime'e, jume' ba'am emo naas kuuta bo'o bichakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bwe'ituk wate taewaimmet, inim ba'a maneka'po senu ankeles ama ko'om yepsaka, jume' ba'am nau kuu kuutakai. Junama intok iniet chukula, ju'u che'a bat junama ba'apo kibakekame, ini'i, jita ko'okoata aet ayuka'u betana juni'i, tuttu'irean. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Juname betana senu o'ou, senu taka ama woj mamni intok ama woj naiki wasuktiapo ko'okoekai ama bo'okan. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ju'u Jesus junama bo'okamta bichakai, intok junuen jaibu binwatuk naateka junuen a' ko'okoe'ut ju'une'eakai, iniau: ―Jaisa empo emo ine'etepea ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ju'u ko'okoeme inen a' yoopnak: ―Achai, jume' ba'am emo naas kuutasuk, ju'u nee ama ko'om yecha'aneeme neu be'ee. Bwe'ituk nee ama ko'om weebae'ebeleki, ta'abwika che'a bat ama ko'om weama ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ju'u Jesus iniau: ―Yejte'e, intok juka' em aet bo'oka'uta toboktaka, weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jiba junama lautipo intok ini'i o'ou tu'ika taawak. Intok juka' aet a' bo'oka'uta nu'uka naa wee taitek. Taa junama intok sabala taewaitakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jume' juriom ju'u au ine'etetuawakamtau inen jiiak: ―I'an che'a aet yum jo'e taewai, juka' em aet bobo'uta empo ka a' pu'anam ean ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ju'u o'ou inen am yoopnak: ―Ju'u nee tu'utekame, aapo: “Juka' em aet bobo'uta nu'uka weene”, ti neu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Junak inime'e: ―Jabesa juna'a, ju'u: “Juka' em aet bobo'uta nu'uka weene”, ti eu jiakame ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Taa ini'i ka ju'unean jabeta au a' ine'etetuaka'uta, bwe'ituk ju'u Jesus ju'u bu'uura junama anemta nasuk kaabetulatukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chukula ju'u Jesus, inika'a jum bwe'u te'opopo teaka: ―A' mammatene, i'an ala empo tu'ikai, ka intok bat naataka benasi ka tu'ik joone, junuen kaita naa buusti intok, che'a ka tu'ik em bitne' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ini'i o'ou junak sikaa, intok jume' juriom tejwaak juka' a' tu'utekamta a' Jesuj tuka'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jiba inia betchi'bo san jume' juriom Jesujtau suua japtek. Intok inime'e a' me'ebaen, junuen aapo'ik aet yum jo'e ta'apo inien weemta a' joa' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Taa ju'u Jesus inimmeu: ―Ju'u in yo'owa Lios i'an tajtia jiba tu'ik jooa. Inepo intok ketchia tekilta tu'ik jooa ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jiba inia betchi'bo san jume' juriom che'a juni'i aapo'ik me'ebaeka ean. Bwe'ituk aapo junuen ka jum nesauri ji'ojteimpo aet yum jo'e taewaita jiba junuen ka a' bo'o jooriakai, taa ketchia, aapo'ik jiba ju'u Liojta benasi au a' joa' betchi'bo, aapo juka' Liojta au a' yo'owak ti a' jia'ue. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Junak ju'u Jesus inimmeu: ―Lutu'uriapo ne inen emou jiia, juka' Liojta yoemia, ini'i aapo a' ea'po tua kaita a joone. Ala wepulsi juka' a' yo'owata aapo'ik joa'uta a' bichaka'uta, junaka jiba a jooa. Juka' achaiwaita si'imeta juka' a' joa'uta, ket ju'u a' yoemiawai junaka'a a joone. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bwe'ituk ju'u achaiwai juka' a' yoemiawata nak ta'aa. Intok jiba aapo'ik si'imeta a' joa'uta, junaka'a a' ju'uneiyaatua. Intok ketchia, aapo'ik a jita a' joa'uta, inia bepa che'a suum watchisi machik a' tejwaaka a' jootuane, junaka'a a' bichaka eme'e kaachin jiu machine. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bwe'ituk jiba junuen juka' achaiwaita, jume' kokkoarim bem takaam jojoaka intok am jiapsitua'a benasia, ket jiba junalensu ju'u yoemiawa, jume' jiapsiwamta a' makbae'um, inime'e a' mamaka. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ju'u achai Lios, inim kaabeta ya'uraa bittuane. Ala aapo, juka' usiwaita si'ime lutu'uriata a' maki, inika'a yee a' ya'uraa bittuane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Junuen inim si'imem, juka' usiawaita bem a' yo'ori ta'aane' betchi'bo, jiba juka' achaiwaita bem a' yo'ori ta'a'a benasi. Ju'u, juka' yoemiarita ka a' yo'ori ta'aame, kia juka' achaiwaita, juka' a'abo a' bittuakamta juni'i, junuen ka a' yo'ori ta'aane. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Tua nee lutu'uriapo junen jiaka nee inika'a teuwaa, wa'a, juka' in teuwaa'uta a' mammateka a' jikkajame, intok juka' Liojta, a'abo nee bittuakamta a' sualeme, ini'i, jiba yuu jiapsine. Intok ini'i, ka tu'isi a' tawanee'uta ka a' bitne, bwe'ituk ini'i, Liojta bichapo ka tu'isi tawaritaka a' muk'ea'u betana jaibu jinne'uritaka, jiba yuu jiapsiwamta jipue. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tua ne lutu'uriapo junen jiaka inika'a teuwaa, taewai yuma'ane, intok jiba i'an su jaibu yuma'alaa, junak jume' kokkoarim juka' Liojta yoemiata, aapo'ik jiawaita am jikkajineeo. Jume' intoko a' jikkajakame, jiba yuu jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bwe'ituk ju'u achai Lios utte'ak, junuen jiba aapo juka' jiapsiwamta yetet a' autua betchi'bo. Intok ketchia aapo, juka' yoemiawata junaka'a utte'ata aet autuari, junuen juka' jiapsiwamta yetet a' autuane'ebetchibo. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Intok ketchia aapo'ik yee a' ya'uraa bittuane' betchi'bo, si'ime lutu'uriata aet autuari, junuen aapo'ik inim bwiapo a' yoemtuka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Iniet eme'e ka aet emo suum eetuabaane. Bwe'ituk chukula, taewai yuma'ane, junako si'ime jume' kokkoarim aapo'ik jiawaita am jikkajineeo. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Intok inime'e, jum bem ma'arimpo yeu katne. Wame'e tu'ik joaka jiapsisukame, inime'e, jiba yuu bem jiapsine' betchi'bo jiabijtetuanaa. Taa jume' intoko ka tu'ik joaka jiapsisukame, inime'e, ka tu'isi bem tawaana' betchi'bo jiabijtetuanaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Inepo kia in ea'po aman, tua ne kaita a jooa. Ala inepo nee tua in a' tejwaawa'po aman junuen nee yee bichaka ka tu'isi yee tawaa. Ju'u intok junuen, ka tu'isi in yee tatawaa'u, wepulsi junaen jiba lutu'uriak. Bwe'ituk inepo, kannee juka' in joobae'uta in ea'po aman nee a' jooa, ala inepo, juka' in yo'owata, a'abo nee bittuakamta a' ya'a i'a'uta junaka'a ne jooa. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Inepo intoko, jiba inepo in jabetuka'uta a' lutu'uriate'eteko, ju'u in teuwaa'u, nee betana tua kaita teuwaa ean. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Taa ket senu aane, ini'i, in jabetuka'usata lutu'uriata teuwaame. Inepo intok ne ju'unea, inika'a juka' nee betana a' teuwaa'uta, junuen lutu'uriataka a' teuwaa'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Eme'e, watem ju'u Joan yee babatoowamtau am nattemai betchi'bo au am bittuak. Ju'u intoko aapo'ik junammeu teuwaaka'u lutu'uria. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Taa inepo, kannee inim senuk in jabetuka'ut lutu'uriata teuwaaneemtat ea. Inika'a inepo a' teuwaa iniae enchim nee sualeka enchim jinne'uimtune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ju'u Joan, aapo inim jita beeteka a' tachiriaka'a benasia machiakan. Eme'e intoko, chuubaa juni'i weyeka, aapo'ikut enchim ju'uneiyaaka'ue tu'ik mabetaka intok, tua jiapsi yuma'isi alleak. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Taa inepo, nee ket a' ju'uneiyaa, waka'a che'a tu'isi weyeka, in jabetuka'uta, ju'u Joanta nee betana a' teuwaaka'u bepa juka' a' teuwaamta. Inim ju'u in joa'u, ini'i, jiba ju'u achai Liojta betana a' ya'asaiwaka ju'u in tejwaawaka'u, ini'i, lutu'uriapo in yo'owa Liojta betana a'abo in bittuarituka'uta a' teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ketchia, ju'u achai Lios, ju'u a'abo nee bittuakame, aapo in jabetuka'uta lutu'uriata teuwaala. Junuen ka tua aapo emou yepsaka juni'i, intok kia ka tua aapo emou noklataka juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Taa juka'a, Liojta betana weyeka nok lutu'uriata, eme'e ka tua junen jiaka a' jikkajilam. Bwe'ituk, nee, jiba juka' achai Liojta a'abo bittuakamta, eme'e ka nee suale. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Eme'e, Liojta betana weyeka jume' ji'osia ji'ojteim, tua eme'e amet suaka emo am majta. Bwe'ituk eme'e, juka' jiba yuu jiapsiwamta inim ji'ojteimpo emo a' bit machia. Taa junuentaka juni'i, inime'e Liojta betana ji'osia ji'ojteim, juname'e, jume' nee betana lutu'uriata a' teuwaame o'oben. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Eme'e intok tua ka nemak eebae, junuen juka' jiba yuu jiapsiwamta enchim bit betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Inepo nee inim tua jabeta betana juni'i, juka' yo'orisi weyeka net nokwamta kannee a' waata. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Intok naa buustia ineponee enchim ta'aa. Intok ket ne ju'unea, achai Liojta ka enchim a' nak ta'aa'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Inepo, jiba in achai Liojta betana lutu'uriaka ae betchi'bo nokaka nee inim yebijlaa. Eme'e intok ka junuen nee mabetbae. Taa senuk, kia aapo'ik au yo'o ya'arika a' weyeo, junaka'a ala, eme'e tu'isi a' mabetne. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kaachin eme'e a nee sualne, junuen eme'e emo nasuk jitat emo eiyaawaka emo bitwamta nat jaiwakai. Intok ju'u wepulsi aapolaika jiba Liojta betana eiyaawaka tu'isi enchim mabetnaa'uta ka a' jaiwa. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ka eme'e, ju'u in achai Liojta bichapo nee enchim na'atejobae'eti eene. Wa'a enchim yeu bwijneeme, jiba ju'u Moiseejtuka'u, aapo'ik nesaurimmet tu'ik enchim aet bit bo'o bicha'u juna'atune. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bwe'ituk junuen eme'e waka'a Moiseejtuka'uta teuwaaka'uta a' suale'eteko, nee juni'i ketchia eme'e sual ean, bwe'ituk aapo ju'u Moiseej tuka'u nee betana juka' neu chup'ea'uta a' ji'ojtek. ");
INSERT INTO yaqNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Taa eme'e intok, juka' aapo'ik ji'ojteka'uta eme'e ka a' sualekai, jaisa tua eme'e juka' in emou teuwaa'uta a' sualbae. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Iniat chukula aapo ju'u Jesus, junama'a bwe'u bau ba'a Kalilea' tea'po, ini'i ket jiba Tibeeriammea ta'eewakai, ba'at waetana bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yoemra tua juebenaka aapo'ikut cha'aka kaaten. Bwe'ituk inime'e, aapo'ik machilaata, tua a jita a' joaka, jume' ko'okoeme emo am ine'etetuala'uta a' bitlamtukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Junak ju'u Jesus junama senu ili bwia kawiu jikau sika intok junama'a a' majtimmak yejtek. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Junama jaibu jume' juriom bwara jisu'aka, ju'u bem pajko yuma'asekan. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ju'u Jesus junak junama'a naj bitchukai intok juka' yoemrata tua juebenaka aet cha'aka katemta bichakai, ju'u Jeriipe' teamtau: ―Jaksa tua itepo si'ime inia yoemrata betchi'bo yuma'ik bwa'amta jinunee tua ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Taa aapo inien jiiak junuen kia juka' Jeriipe' teamta a' ea'uta jikkajibaekai. Bwe'ituk jiba aapo ju'u Jesus tu'isi ju'unean ju'u a' ya'anee'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Junak ju'u Jeriipe' teame: ―Naiki miil tosai tomim paanim, kia illikika juni'i junuen we'epulaimmeu juni'i ka yuma'a ean ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Junak intok a' majtim betana seenu, Antej teame, Simoo Peeo' teamta saai inen jiiak: ");
INSERT INTO yaqNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Senu ili usi inim weama, ini'i mamni sebaara paanim nunnu'ubwa intok wooi kuchum. Taa ini'i tua ka jaiki, ju'u juebena yoemrata betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Junak intok ju'u Jesus: ―Si'imem inime'e, eme'e am jote'esaune ―ti jiiak. Junama bem ane'epo tua basotukan. Jume' intok junama jotekame jumak mamni miil o'owimtukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Junak ju'u Jesus jume' paanim nu'uka intok chukula, Liojta aapo'ik a' baisae'uta teuwaasukai, jume' a' majtimmeu am bwisek. Jume' a' majtim intoko, si'ime wame'e junama'a jokammet am na'ikimtek. Ju'u Jesus jume' kuchum intok ketchia jiba junaen ayuka amet am na'ikimtek, inika'a yoemrata tua ameu a' be'ee'po aman am mikakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Junako bempo'im junammea am yanti elao, ju'u Jesus, jume' a' majtimmeu: ―Jume' reebeim ama yeu be'ekame nau tojine, junuen kaita kia wo'otine' betchi'bo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Inime'e, bempo nau tojaka intok jume' reebeim, jume' mamni sebaara paanim betana bem bwa'asuka'po yeu be'eekame, inime'e, woj mamni ama wooi jume' che'a bwere waarim ammea tapuniak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Junak intok ju'u ama yoemra, juka' Jesujta a jita a' joa'uta, machilaata a' bichakai: ―Tua lutu'uriapo, ini'i juna'a, ju'u Liojta betana ju'uneetuawaka chukula yeu weenemta teteuwaame, inim yebijneeka bo'o bitwa'u ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Taa junak ju'u Jesus, utte'apo a' nuk sajaka junuen bempo'im junama'a ameu a' yo'o ya'abae'po amet ju'une'eakai, aapo junama kaupo juchi che'a mekka jikau siika junaman aapola anbaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Junak jaibu ka machisuko, jume' Jesujta majtim, bwe'u, bau ba'au bicha ko'om sajaka, ");
INSERT INTO yaqNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","inime'e, senu bwe'u kuta kanoau ja'amuka intok junama bwe'u bau ba'at bo'o joo japtek waetana bicha, bwe'u jo'ara Kapernao' tea'u yeu yajibaekai. Junama'a jaibu tua ka mamachiakan intok ju'u Jesus ketun kee aman ameu notten. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Junak intoko, jeeka tua utte'aka yebij taitek. Jume' ba'a buaktiam intok mekka jikau jajapten. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Junak intok bempo, mamni oo busan kiloometrom ba'at bo'o joakai, bempo juka' Jesujta, bem ama kate'u ruktemta a' bichak, ba'a bepa weyemta intok inime'e a' majjaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Taa aapo: ―Inepo nee im weye. Kate'em majjae ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Junak intok bempo, bem ama kate'u, tua junen eaka amemak a' ja'amutuak. Intok bempo chubalapo su bwiau bem sajaka'u yeu yajak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Juchi yokoriapo ju'u yoemra, junama bwe'u bau ba'ata waetana tawaka'um, inime'e ju'une'eak, jume' Jesujta majtim junama'a wepu'ulaka jiba kuta kanoapo bem sajaka'po, juka' Jesujta intok ket ka amemak a' sika'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Taa chukula junuen su wate bwere kuta kanoam, bwe'u jo'ara Tibeeria' tea'a betana ama yajak, junama'a yo'owe Jesukrijtota jume' paanim betchi'bo Liojta baisaeka bem am bwa'aka'anaapo. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ju'u bu'uura junama'a, juka' Jesujta intok kia jume' a' majtiwam juni'i, kaabe ama am bichakai, bempo, inime'e ama bwere kuta kanoammeu ja'amukan intok bwe'u jo'ara Kapernao' tea'u bicha sajak, Jesujta ama jariubokai. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Inime'e junuen, junae bwe'u bau ba'a waetana yajaka, juka' Jesujta ama teak, intok bempo: ―Yee majtame, jakwoosa empo inim yepsak ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Taa ju'u Jesus inimmeu: ―Lutu'uriapo ne inen emou jiia, eme'e nee jaiwa, kia nee betana yuma'isi enchim ji'ibwaka' betchi'bo. Intok ka juka'a, a jita joaka machilaata in yaaka'ut enchim aet ju'uneaka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ka eme'e inim ju'u bwa'amtat lu'utineemtat jiba emo temaine. Ala eme'e, Liojta betana bwa'amta benaka, ka lu'utineemtat eene. Inika'a jiba yuu jiapsiwamta enchim aet bitnee'uta. Ini'i juna'a, bwa'amta benaka, juka' inim yoemta emot a' autuanee'u. Bwe'ituk ju'u achai Lios, aapo'ik nee yeu a' pu'aka'po, iniae a' bit tebo. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Junak intok inime'e: ―Jaisa itepo ayuka intok juka' Liojta inim itom joo i'a'uta joaka, junuen aet yeu yuma'asakane ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Junak intok ju'u Jesus inimmeu: ―Juka' aapo'ik Liojta emo tana a' waataka enchim a' joo i'a'u, ini'i, ju'u aapo'ik Liojta a'abo a' bittualata enchim a' sualnee'u juna'a ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Inime'e junak inen au nattemaek: ―Jita machilaatasa empo a itom bittua, junuen junaka'a bichaka intok a enchi itom sualne' betchi'bo. Jita benaka empo a bit tebo. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wame'e bat naataka itom yo'owasuka'um, bo'o joaka, jum bweka pa'aku, bwa'aame, manna' teamta bwa'aka. Jiba jum Liojta nok lutu'uriapo: “Ju'u achai Lios, juname'e, teeka betana bwa'awamta am miikak”, ti jiaka a' ji'ojtei'i benasia. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ju'u Jesus inime'e inen yoopnak: ―Lutu'uriapo ne inen ne emou jiia, ka wa'a Moiseejtuka'u juna'atuk ju'u teeka betana bwa'amta am mikakame. Ala ju'u in yo'owa Lios juna'a, ju'u tua lutu'uriapo bwa'aame ti teaka, teeka betana weyemta enchim miklame. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bwe'ituk Liojta betana weyeka, ju'u bwa'aame ti teaka yee a' mika'u, ini'i, wa'a teeka betana yebijlame juna'a. Intok ini'i juna'a ju'u jume' inim jiapsame jiba yuu jiapsiwamta amet autuame. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Junako inime'e: ―Achai, junaka'a bwa'aamta jiba chikti ta'apo itou a' autuane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Junak ju'u Jesus: ―Ineponee juna'a, ju'u bwa'aame ti teaka, jiba yuu jiapsiwamta yetet autuame. Wa'a nemak eaka jiapsibaeme, ini'i, aapo'ik jiapsiu a' tebauri'i benasi a' ea'u, kaitatune. Wa'a intoko, nee sualeme, a' jiapsiu ba'a ji'ipea'a benasi a' ea'u, kaitatune. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Taa jaibu in emou jiaka'a benasia, eme'e inien, junuen nee bitlataka juni'i, ka nee suale. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Inim si'ime wame'e in achai Liojta neu bicha yeu pu'arim, inime'e nemak ee sakane. Ju'u intoko, junuen nee sualeka neu rukteme, kaachin nee yeu a' tawaane. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bwe'ituk kannee in ea'po aman aubaeka, teeka betana ne a'abo yepsak. Ala, juka' a'abo nee bittuakamta ea'po aman aubaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ju'u intoko, ju'u in yo'owa, a'abo nee bittuakamta, a' waataka a' chupa'a i'a'u, ini'i, si'ime wame'e aapo'ik neu bicha yeu pu'arim, jabeta juni'i, ka in a' ta'arunee'u juna'a. Ala inime'e, chukula taewait, jume' kokkoarim jiabijteneeo, in am jiabijtetuanee'u juna'a. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Waka'a a'abo nee bittuakamta waataka a' ya'a i'a'u ini'i, si'imem wame'e, juka' Liojta yoemiata bem jiapsimmea a' bichame benaka aapo'ik sualeme, inime'e juka' jiba yuu jiapsiwamta am bitnee'u juna'a. Inime'e intok chukula taewai jume' kokkoarim jiabijteneeo, ineponee am jiabijtetuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Junak jume' juriom Jesujtat nok japtek ju'u aapo'ik: “Ineponee juna'a, ju'u bwa'amta benaka teeka betana inim yepsakame”, ti a' jiaka'ue. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Intok inime'e: ―Jaisa ini'i ka juna'a ju'u Jesus, ju'u Jose' teamta u'usi ja'ani. Itepotee juka' a' achaiwata intok juka' a' malawata tee am ta'aa. Jaisaaka intok ini'i, teeka betana inim au yebijla'ati jiia ―ti bempo jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ju'u Jesus junak inimmeu: ―Kate'em intok emo nasuk, juka' in emou teuwaaka'uta a' beje'eka nooka ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kaabe inim nemak eaka nee sualne, inika'a, ka juka' in yo'owata inim a'abo nee bittuakamta, nemak a' eene' betchi'bo, ka junaet a' aniao. Ineponee intok inika'a chukula jume' kokkolam jiabijteneeo, inepo nee a' jiabijtetuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wame'e che'a bat naataka Liojta betana ju'uneetuawaka, chukula yeu weenemta nokame, jum bem ji'ojteimpo: “Ju'u Lios, inime'e si'imem majtane”, ti inen ji'ojtei. Junuen san si'ime wame'e, juka' in yo'owa Liojta betana juka' nok lutu'uriata a' jikkajame intok junama'a aapo'ik betana weyemta au a' ta'aame, inime'e nemak eaka jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Lutu'uria ala, inim tua kee jabeta juka' achai Liojta a' bicha'u. Ala ju'u aapo'ik bitlame, ini'i wa'a aapo'ik Liojta betana inim yebijlame juna'a. Aapo jiba a' bitlaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Eme'e iniat nee sualne, wa'a nemak eaka nee sualeme, ini'i, juka' jiba yuu a' jiapsinee'uta jaibu a'et aayuk. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ineponee juna'a, wa'a bwa'amta benaka, jiba yuu jiapsiwamta yetet autuame. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bat naataka wame'e enchim yo'owasuka'um jum bweka pa'aku, bempo, bwa'amta juka' mannaa' teamta bwa'aka. Taa junuentaka juni'i, juname'e si'ime kokkok. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Taa inepone, ju'u bwa'amta benaka teeka betana weyemtat nooka. Inika'a, ju'u a' bwa'akame junuen ka mukneekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ini'i bwa'amta benaka yee jiapsituaka, teeka betana yepsakame, jiba ineponee juna'a. Wa'a inika'a bwa'amta benak bwa'akame, aapo jiba yuu betchi'bo jiapsine. Ju'u bwa'amta benaka in yee bwa'atuanee'u, jiba ini'i in taka juna'a. Inika'a, inepo inim jume' jiapsame, jiba yuu bem jiapsine' betchi'bo ne a' nenkine ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Junak jume' juriom inime'e bempo chuubaa junaet nau etejok: ―Jaisa ini'i aapo a' taka itom a' bwa'atuaneekai tua ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus intok inimmeu: ―Lutu'uriapo ne inen jiia, eme'e, inia ju'u inim yoemta betana juka' a' takaawata ka a' bwa'ako intok kia juka' a' ojbowata juni'i ka a' je'ekai, eme'e kaibu jiba yuu jiapsine ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ju'u inika'a in takaata bwa'akame intok in ojbota je'eekame, ini'i juka' jiba yuu jiapsiwamta a' mabetlaa. Inepo intok, chukula taewai jume' kokolame jiabijteneeo, inepo nee a' jiabijtetuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bwe'ituk ini'i su in takaa, tua lutu'uriapo wa'a bwa'aame' teaka ta'eewame. Ju'u su intok in ojbo, ini'i tua lutu'uriapo ju'u ji'iwame' teakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wa'a inika'a in takaata bwa'ame' teaka a' bwa'aneeme intok inika'a in ojbota ji'iwame ti ta'eewamta a' ji'ineeme, wepu'ulaika benasi nemak eaka jiapsine. Inepo intok ket jiba junaen aamak jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ju'u in yo'owa Lios, ju'u a'abo nee bittuakame, jiba yuu a' jiapsa'u aapo'ikut aayuk. Aapo'ik betana intok, jiba yuu in jiapsa'u net aayuk. Jiba junuen ketchia, wa'a inika'a bwa'aame ti ta'eewamta a' bwa'aneeme, nee betana jiba yuu a' jiapsa'u aet aune. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wae bwa'aame ti teaka, teeka betana inim yepsakamtat nee emou etejo. Ini'i bwa'aame, ka ju'u bat naataka jume' enchim yo'owasuka'um bem bwa'aka'u bwa'awame manna' teamta bena, intok kia junuentaka juni'i, jiba kokkokai. Wa'a inika'a bwa'awame ti teakamta a' bwa'aneeme, jiba yuu jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ju'u Jesus, jum bwe'u jo'ara Kapernao' tea'po juriom te'opopo nau anwa'apo inika'a weyemta yee a' majtak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Inika'a yee a' majta'uta jikkajaka, juebenaka jume' a' majtim betana: ―Ini'i aapo'ik teuwaa'u, tua obiachi aet ju'uneepo. Jabesa iniat a' sual machi ―ti nau jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Junako ju'u Jesus, junae weyemtat bem ka a' tu'ureka intok emo nasuk bem aet naas noka'apo ju'uneakai: ―Jaisa ini'i inen ka enchim alleetuak ja'ani ―ti ameu nattemaek―. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Junak su, jaisa tua eme'e an ean, junuen eme'e juka' inim yoemta, teekau bat naataka a' jiapsa'u bicha juchi jikau weyemta eme'e a' bicha'ateko. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ju'u Liojta tu'u jiapsi juna'a ju'u, jiba yuu jiapsiwamta yee bittuame. Ini'i itom taka intok, iniat kaita'po yee ania. Ju'u intoko in emou teuwaari, Liojta tu'u jiapsi betana weyeka, jiba yuu jiapsiwamta yee bittua. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Taa emo nasuk ketuni wate aane, jume' ka nee sualeme ―ti jiiak. Bwe'ituk ju'u Jesus sep naatelaa'po naateka jabem junuen ka a' suale'um ju'unean. Intok juka' chukula yeu a' bwiseka a' nenkinemta a' jabetuka'ut ju'unean. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Intok: ―Inia betchi'bo san ne inen emou jiiak, inim kaabeta nemak eaka nee a' sualnee'u, in yo'owa junuen nemak a' eene' betchi'bo ka junaet a' aniao ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jiba junama naatekai juebenaka jume' Jesujta majtim aamak rejtisuka'um, a' to'o sajak. Intok ka intok au yajakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Junak intok ju'u Jesus jume' woj mamni ama wooi a' majtimmeu: ―Jaisa eme'e ket nee to'o saka'abae ja'ani ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Taa ju'u Simoo Peeo' teame: ―Achai, jabetausa intok itepo katne, enchi to'o sajakai. Ju'u em teuwaa'u nooki, jiba yuu jiapsiwamta yee bittuaka nooki. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Itepo jaibu te enchi suallaa. Intok itepo ju'unea ju'u em Krijtotuka'u ju'u Lios jiba yuu jiapsamta yoemia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ju'u Jesus inen a' yoopnak: ―Ineponee enchim woj mamnim ama wooim yeu pu'ak. Intok junuentaka juni'i, emo betana seenu, ini'i ka ta'abwi bebeje'erita bena ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Inien jiakai ju'u Jesus, ju'u Juuras Ijkarioote, senu Simoon teamta u'usibet nookan. Bwe'ituk ju'u Juuras, ini'i junuen chukula ju'u yeu a' bwijneeme tukan, jume' woj mamni ama wooimmak na'ikiaritaka juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Iniet chukula ju'u Jesus, bwiaraa Kalilea' tea'po jiba weaman intok aapo jum bwiaraa Jurea' tea'po ka anbaekai. Bwe'ituk junaman jume' juriom a' me'ebae' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Taa junako juka' pajkota, jume' juriom bem jo'aam be'ekatana juya karim joaka bem pajkota. Ini'i jurio yoemrata ket bem pajkoo abe a' yumao, ");
INSERT INTO yaqNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","jume' aapo'ik sailawam aapo'iku inen jiiak: ―Kat inim tatawa. Bwiaara Jurea' tea'u bicha weene. Junuen junaman jume' emak eaka em majtim ket juka' a jita em joa'uta, bem a' bitne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bwe'ituk seenu, ini'i, si'imekut au a' ta'aa i'a'ateko, ini'i ka etbwa a' joa'uta joone. I'an empo inile benaka eiyaawatchik joakai, kia bu'uuraata bichapo em bitna' betchi'bo a' joone ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bwe'ituk junama'a kia tua jume' a' sailawam juni'i, aapo'ik ka sualen. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Junak intok ju'u Jesus inimmeu: ―Ketun kee yuuma ju'u taewai junaet in aman weenee'u. Taa enchim aman katne' betchi'bo kaita emoas aayuk ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Jume' inim weyemta bo'o jooriaka jiapsame, enchim kaachin a omtane. Taa inime'e nee tua omta bwe'ituk inepo, inime'e, tua nee machisi juka' ka tu'ika bem joa'uta aet am ju'uneetua. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Eme'e junaman pajkou katne. Inepo nee ka aman weenee bwe'ituk kee yuuma ju'u taewai junaet in aman weenee'u ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Intok aapo inika'a ameu teuwaasukai, junama aapo, bwiaraa Kalilea' tea'po taawak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Taa chukula jume' a' sailawam am bicha am saka'asuko, aapo ju'u Jesus ket junaman pajkou siika. Taa junak aapo etbwa junuen, kaabeta tua a' bichao o'oben. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jume' juriom junama pajkopo a' jaiwan intok inime'e: ―Jaksa tua aane wa'a yoeme ―ti nat jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Junama bu'uuraata nasuk juebenaka aapo'ik betana nokaka, waate: “Tua tu'i yoeme”, ti jiian. Taa wate intok: “Ka lutu'uria, bwe'ituk inim yoemrata bai tatta'aa”, ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Taa junama'a kaabe ame betana juka' bem ae tana ea'uta machisi a' teuwaan, juka' juriommeu yo'oraata junaet am nok tejwaa majjaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Juka' pajkota jaibu taewaika nasuklaapo a' weyeo, junak ju'u Jesus te'opou yepsaka intok junama wajiwa yee majta taitek. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jume' juriom intok inia betana suum eaka taawak, intok: ―Jaisa tua ini'i yu'in jita ta'aa, ini'i ka jak au majtalatakai ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ju'u Jesus junak inime'e: ―Ju'u in yee majta'u, ka nee betana weye. Ala ini'i, wa'a inim nee a'abo bittuakamta betana weye ―ti am yoopnak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Inim jabetaka juni'i, ju'u achai Liojta waataka a' joo i'a'uta a' joobaeme, ini'i in yee majta'ut, Liojta betana a' weye'po, oo kia nee betana jiba a' weyeka in a' teuwaa'ut, machisi aet ju'uneene. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ju'u aapo a' ea'po jiba jita nokame, ini'i, yoemrata a' eiyaaka a' yo'ori i'aka junuen noknee. Taa wa'a, juka' a'abo a' bittuakamta a' eiyaawaka a' yo'ori i'aka junuen nokame, ini'i tua lutu'uriata jiba noknee. Intok yee a' bai ta'aanee'u iniat kaita aune. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Ju'u Moiseejtuka'u juka' nesauri ji'ojteita enchim ji'oteriak. Taa junuentaka juni'i, emo nasuk kia jabe juni'i, kaabe a' chupaka a' bo'o jooria. Junak su, jaisaaka eme'e nee me'ebae ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ju'u bu'uuraa inen aapo'ik yoopnak: ―Bebeje'erita betana ka tu'i jiapsita et aane. Kaabe enchi me'ebae ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus inen ameu jiiak: ―Aet yum jo'e ta'apo senu weemta in a' yaaka' betchi'bo eme'e si'ime a' suum eiyaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Taa ju'u Moiseejtuka'u, juka' sirkunsision teamta, jiba enchim a' bo'o jooriane' betchi'bo, enchim tejwaak. Taa ka aapo inika'a bat a' yaaka juni'i. Ala inika'a, che'a bat naataka enchim yo'owasuka'um a' naatekai. Intok eme'e inia betchi'bo, kia sabalata aet yum jo'e taewait juni'i, senu ili usi o'outa a' sirkunsiraaroane. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Junuen san, eme'e, Moiseejtuka'uta nesauri ji'ojtei a' chupa'abaekai, ili usi o'outa junuen aet yum jo'e ta'apo juni'i a' sirkunsiraaroaneekai, jaisaaka intok eme'e neu omte junuen aet yum jo'e ta'apo, senuk tua in a' tu'uteka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kia bitpo jiba, inim senuk ka tu'i yoemta benasi a' machiaka'ut, eme'e a' bichakai, ka junae eme'e ka tu'isi a' tatawaabaane. Ala senuk jita ka tu'ik a' joa'ut tua aet ju'uneaka, junae jiba, ka tu'isi a' tatawaane. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Junak intok waate jume' bwe'u jo'ara Jerusalen tea'po jo'aakame: ―Jaisa ka ini'i juna'a ja'ani, ju'u me'ebaawaka jariuwame ―ti jiaka nattemae japtek―. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Junum aane i'ani, juebenam mak aneka intok yee majtakai. Intok kaabe au monte. Jaisa tua lutu'uriapo ju'u ya'uraa, a' Krijtotuka'uta a' suale ja'ani ―ti jiian―. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Taa itepo tee tu'isi ju'unea inika'a jakun a' jometuka'ut. Taa ju'u Krijto'o teamta inim a' yepsako, junak tua kaabe ju'uneenee jaku'ubo a' weye'po ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Inika'a jikkajakai ju'u Jesus, intok aapo ket jum te'opopo yee majtakai, tua kusisi nokakai: ―Junuen san eme'e nee ta'aa intok eme'e, jakun in jometuka'ut ju'unea. Taa inepo nee ka kia in ea'po inim a'abo yebijlaa. Ala inepo, senuk ju'u tua a yoem eiyaatuka intok junae tua ka enchim ta'aa'u betana nee a'abo bittuaritaka weye. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Junaka'a inepo nee a' ta'aa. Bwe'ituk jiba inepo aapo'iku mak nee aman aanen intok jiba aapo a'abo nee bittuari ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Junak intok juname'e a' bwiseka a' weiyaabaaen. Taa kaabe au ruktek. Bwe'ituk junama'a, junae betchi'bo, ju'u taewai kee yuuman. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Taa juebenaka jume' junama te'opopo aneme aapo'ik sualek, intok inime'e: ―Ju'u Krijto' teame junak a'abo yepsako, kaachin a jita a' joa'uta intok machilaata inia bepa a' joone ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jume' paiseeom teame, inime'e, Jesujta betana juka' yoemrata a' teuwaa'uta jikkajak. Junak intok bempo intok jume' junama te'opopo tekiakammeu yo'owe, inime'e nau, junama'a te'opopo, waatem jume' yee suuatuawame junuen aapo'ik bem a' bwijne' betchi'bo, Jesujtau am bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Junak intok ju'u Jesus junammeu: ―Tua ka binwa inepo inim emomak annee. Intok chukula inepo ju'u a'abo nee bittuakamtau nee juchi nottine. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Eme'e inim nee jariunee taa eme'e ka jak nee teune. Bwe'ituk eme'e jum in yebijnee'u ka a aman nemak yajine ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Junak wame'e juriom, bempo nau nattemae japtek: ―Jakunsa ini'i weeneeka itepo ka a' teune. Oo jaisa aapo, aman jume' juriom, inime'e ju'u yoemra rieekom teammak kuutilammeu, intok jume' rieekom majtabaeka aman weeneekai ja'ani. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Jaisa aapo jiaka junuen: “Eme'e inim nee jariunee taa eme'e ka jak nee teune, bwe'ituk eme'e jum in annee'u ka a aman yajine”, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ju'u taewai juka' pajkota aet lu'ute'u, ini'i che'a juni'i yo'oriwan. Jiba junako, junae taewait ju'u Jesus, kikteka intok tua kusisi nokakai: ―Jabetaka juni'i, ju'u ba'a ji'ipeame, ini'i neu sika intok ba'a ji'ine ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jum Liojta betana ji'osia ji'ojteim tua junuen a' jia'a benasia: “Inim jabeta juni'i, juka' nee sual ta'aamta betana, batwee ba'am buiteme benaka yee jiapsituame ka aet lu'utine” ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Inien jiaka ju'u Jesus, jume' a' sualeme, Liojta betana juka' a' tu'u jipasiwata bem mabetnee'uta a' teuwaan. Bwe'ituk junak ju'u Liojta tu'u jiapsiwa, bempo kee a' mabettuawan. Bwe'ituk ju'u Jesus, kee junuen teekau yo'otaka yejten. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Waate junama'a bu'uuraata betana inika'a jikkajaka: ―Tua lutu'uriapo ini'i juna'a, ju'u Liojta betana ju'uneetuawaka chukula yeu weenemta teteuwaame ini'i yebijneeka bo'o bitwa'u ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wate intok: ―Ini'i juna'a, wa'a Krijto' teame ―ti jiian. Taa junama'a ket waate: ―E'e, ju'u Krijto' teame kaachin, bwiaara Kalilea' tea'a betana jometune ―ti jiaka aanen―. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Jum Liojta betana weyeka ji'osia ji'ojteimpo, juka' Krijto' teamta, ju'u che'a yo'o ya'ari Labiituka'utat yeu katriam betana a' weenee'uta intok jum ili jo'ara Beleem tea'po betana, jiba ju'u Labiituka'uta a' jiapsaka'po, junama'a a' jometunee'uta a' utte'atunee'u, ti ji'ojtei. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Junuen san ju'u yoemra, aapo'ik Jesujta betchi'bo ka nanancha eaka taawak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Waate intok, a' bwiseka a' weiyaabaen, taa kaabe au suuak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jume' ama te'opopo yee suuatuawame, inime'e, jume' paiseeom intok jume' te'opopo tekiakammeu yo'owem ane'u nottek. Juname'e intok: ―Jaisaaka eme'e ka a' nu'upak ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jume' intok ama te'opopo yee suuatuawame: ―Tua jakwoo juni'i itepo kee jabeta inim, junaka'a o'outa, aapo'ik yee a' majta'a benasi nokamta a' jikkajilamtukan ―ti am yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Junak intok jume' paiseeom, inimmeu: ―Jaisa ket eme'e inia betana emo bai ta'aa tebolam ja'ani ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ju'u itou yo'ooraata betana kaabe a' suallaa. Intok kia jume' paiseeom betana juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Taa wa'a yoemra, Moiseej tuka'uta betana juka' nesauri ji'ojteita ka a' ta'aame, inime'e ka tu'isi tawalam ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ju'u Nikoreemo' teame, ju'u che'a bat naataka Jesujta mak etejo betchi'bo tukaapo au noitekame, ini'i, jume' paiseeom mak weyen. Aapo intok: ");
INSERT INTO yaqNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Juka' inim ae itom nesawee'uta, a' jia'a benasia, itepo kaabeta ka tu'isi a' tawaane, inika'a ka bat a' jikkajakai, junuen ju'u a' yaaka'ut ju'unee betchi'bo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Junak bempo inen au jiiak: ―Jaisa empo tua lutu'uriapo, bwiaraa Kalilea' tea'po ket joome ja'ani. Liojta betana weyeka ji'osia ji'ojteim emo majta. Intok empo junuen a' ju'uneiyaane, Liojta betana ju'uneetuawaka chukula yeu weenemta nokame, kia wepu'ulaika juni'i, bwiaraa Kalilea' tea'a betana ka a' jometuka'po ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Junak intok bempo, nau etejosuka, si'ime we'epulaka, bem jo'aammeu bicha sajak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Taa ju'u Jesus, ili kawi Oliibo' tea'u bicha siika. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yokoriapo intok matchuu, aapo juchi jum te'opou nottek. Junama'a si'ime ju'u yoemra aman au ruktek. Aapo intok junama wajiwa yejteka intok bempo'im majta taitek. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Junak intok jume' Moiseej tuka'uta nesaurim yee majtame intok jume' paiseeom, inime'e, jamutta, ta'abwi o'outa, ka a' kunaka aamak au tu'uremta bem teaka'uta au tojak. Inika'a intok bempo, jume' ama aneme bichapo a' kechak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Intok Jesujtau inen jiiak: ―Yee majtame, inika'a jamutta, jiba jum ka tu'ik a' joa'apo itepo a' teak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Jum Moiseejtuka'uta nesauri ji'ojteimpo inile bebena jaamuchim, tetammea mamaasuaka bem sussu'anaa'uta a' teuwaa. Empo su inia betana jaisa jiia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bempo inime'e inika'a teuwaak junuen a' ji'optuabaekai, intok junuen chukula a aet a' na'atejo betchi'bo. Taa junak intok ju'u Jesus ko'om yejteka, intok maammea bwiapo ji'ojte taitek. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Taa inime'e intok jiba au nattemaeo, junako aapo kikteka intok: ―Emo betana, ju'u, ka tu'ik ka a' ya'alame, ini'i bat tetae a' maya'ane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Intok aapo junak juchi ko'om yejteka, bwiapo ji'ojte taitek. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Taa inime'e, bempo inika'a jikkajakai, Liojta bichapo ka tu'ik bem ya'ari'ut emo ju'uneiyaakai, we'epulaka ama yeu kat japtek, junama jume' che'a yo'owe bat yeu sajakai. Chukula intok inime'e si'imem saka'asukai, ju'u Jesus, inika'a jamutta aapolaika ama to'o saka'awakamta jiba ama bichakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Junako ju'u Jesus, kikteka intok junama'a kaabeta intok, juka' jamutta jiba ama bichaka: ―Jaksa aane jume' enchi nana'atejo'um. Jaisa juname'e betana kaabe ka tu'isi em tawaanaa'uta a' a'awak ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ju'u jamut intok: ―E'e japchi, tua kaabe ―ti au jiiak. Junak ju'u Jesus iniau: ―Kia nee inepo juni'i, kaitat ka tu'isi ne enchi tawaane. Noolia weye, taa juka' ka tu'ik ka intok a' ya'ane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ju'u Jesus juchi wee'po ju'u yoemratau nookak intok inimmeu: ―Ineponee juna'a ju'u, inim jiapsammeu, tachiriapo ta'eewaka yee aniame. Ju'u nemak eame, ini'i, nee betana juka' lutu'uriata Liojta betana weyeka intok jiba yuu yee jiapsituamta a' bitne. Intok juna'a ka intok bai ta'aaritaka, ka machiku anemta benane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Junak intok jume' paiseeom teame: ―Empo jiba empo su nokaka Liojta betana em weye'uta a' lutu'uriate. Ini'i intok ee betana em teuwaa'uta, kaita lutu'uriate ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus inen am yoopnak: ―Ju'u nee betana in teuwaa'u, ela'po inepo jiba nee betana a' teuwaaka juni'i, jiba lutu'uria. Bwe'ituk ineponee ju'unea jaku'ubo tana in yebijlaa'u. Intok ket chukula jakun bichaasa in weenee'ut. Taa eme'e, jaku'ubo tana in yebijlaa'ut intok kia jakun bichaa in weenee'ut juni'i, eme'e ka ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Eme'e, jume' inim yoemem, inime'e tua bem yee ya'raa bittua'a benasia jiba, ka tu'isi yee tatawaa. Inepo ala inim i'an, kaabeta jitat ya'uraa bittuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Taa ineponee inim yee ya'uraa bittua'ateko juni'i, ineponee ka ta'abwisi taa tua junama wa'am a' yaa ean. Bwe'ituk inepo kannee inepola junuen yee ya'uraa bittua, alla ju'u in yo'owa, a'abo nee bittuakame nemak junuen yee ya'uraa bittua. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Inim ju'u enchim ae nesawee'u ji'ojteimpo, watem wooim jita betana nanancha a' lutu'uriateeo, inime'e itom am sualnee'u ama ji'ojtei. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Junuen tuko, jiba ineponee juna'a ju'u inime betana seenu, nee betana lutu'uriata teuwaame. Ju'u intoko in yo'owa a'abo nee bittuakame juna'a ju'u juchi seenu, nee betana lutu'uriata teuwaame ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Junako bempo: ―Jaksa aane ju'u em yo'owa ―ti au nattemaek. Jesus intok: ―Eme'e, nee juni'i ka ta'aa intok kia juka' in yo'owata juni'i. Eme'e nee ta'a'ateko, ket juka' in yo'owata eme'e ta'aa ean ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ju'u Jesus inika'a weyemta teuwaak, aapo ket jum te'opopo yee majtakai. Junama wajiwa, jum tomita Liojtau bicha weyemta a' jojoawa'anaapo. Taa junama'a kaabe a' bwisek. Bwe'ituk ju'u taewai junuen au a' weenee'u kee yuuman. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus juchi inen ameu jiiak: ―Ineponee simne. Eme'e intok nee jariune. Taa eme'e inim enchim ka tu'uwa ya'arit ka jiokoirimtaka kokkone. Junae betchi'bo eme'e, jum in weenee'u ka a aman katne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Junak intok jume' juriom ama aneme inen jiian: ―Jaisa aapo au me'ebae ja'ani intok inia betchi'bo aapo, jum aapo'ik weenee'u itom ka a aman katne'e ti jiia ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Junak ju'u Jesus inimmeu: ―Eme'e inim bwiapo joome. Taa ineponee teekau yoeme. Eme'e inim jiapsiwa'a benasia inien jiapsa. Taa ineponee ka inien inim jiapsiwa'a benasi jiapsa ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Inia betchi'bo san inepone, enchim ka tu'uwa ya'arimmet ka jiokoirimtaka enchim kokkone'eti jiiak. Bwe'ituk eme'e, nee junen ju'u Liojta betana in yeu pu'arituka'uta ka junuen a' sualekai, eme'e enchim ka tu'uwa ya'arim betchi'bo, ka tu'isi tawarimtaka kokkone ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Junak intok inime'e, bempo: ―Junak su jabesa'akun empo ―ti au nattemaek. Jesus intok: ―Inia betana che'a bat nee jaibu enchim tejwaasuk ―ti am yoopnak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tua ne ketun juebenak in enchim nok tejwaanee'uta intok jitat enchim in ya'uraa bittuanee'uta nee a' ju'uneiyaa. Taa wa'a nee a'abo bittuakame, aapo lutu'uriata nooka. Ju'u intoko jume' inim jiapsammeu in teuwaa'u, ini'i aapo'ik betana in ju'uneiyaaka'u juna'a o'oben ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Taa bempo tua ka aet ju'uneak, aapo'ik ju'u a' yo'owawa Liojta betana ameu a' noka'apo. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Inia betchi'bo aapo inimmeu: ―Eme'e, chukula juka' inim emo benasi yoemta, kutat jikat a' poponsuko, junak ju'ubwa eme'e, Liojta betana in weye'ut, intok ket in ea'po aman, kaita in joa'uta, wepulsi juka' in yo'owata nee ju'uneiyaatuaka'uta, junaka'a jiba in noka'ut, eme'e net ju'uneene. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bwe'ituk wa'a, inim a'abo nee bittuakame, aapo inim nemak aane. Ju'u in yo'owa ka nee inepolaik koptalaa. Bwe'ituk ineponee jiba nee juka' aapo'ik eiyaa'uta nee a' bo'o jooria. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Junak juka' Jesujta inika'a weemta a' teuwaako, tua juebenaka a' sualek. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Junak intok ju'u Jesus, jume' juriom a' sualeka'ummeu: ―Eme'e, ju'u in emou teuwaa'u betana ka ta'abwisi eaka, ka a' kopta'ateko, lutu'uriapo eme'e in majtimtune. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Intok eme'e, juka' Liojta betana lutu'uriata a' ju'uneiyaane. Intok jiba ini'i lutu'uria, ju'u enchim teko betana enchim su'u tojinaa'ut enchim aet yeu yuma'atuane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bempo, aapo'ik: ―Itepo ju'u Apra'amtuka'uta yoemiam betana te yeu katriam. Intok itepo jakwoo juni'i tee kaabeta tekoka jiapsilaa. Jaisaakai intok empo itom su'u tojirimtune'e ti jiia ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus inimmeu: ―Lutu'uriapo ne inen emou jiia, si'ime wame'e Liojta bichapo ka tu'ik joaka jiapsame, inime'e, junae ka tu'ik betana ka a emo su'u tojame bebenane ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Senu ju'u tekokame, ini'i, ka jiba jum a' tekowata jo'aapo yoemiammak a na'ikiatu. Taa ju'u junama'a senu yoemiaritakai jiba junamemak na'ikiatune. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Junuen a' wee'po san, juka' yoemiarita aapo'ik enchim a' su'u toji teboko, junak eme'e jiba betchi'bo ka tu'ik betana su'u tojirimtaka jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Inepo jaibu ne ju'unea, ju'u Apra'amtuka'uta yoemiam betana enchim yeu katriam tuka'po. Taa eme'e nee me'ebae, bwe'ituk juka' in emou teuwaa'uta, eme'e ka tua junen jiaka a' mabetbae. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inepo nee, ju'u in yo'owa betana in ju'uneiyaatuawaka'u betana nee a' nooka. Eme'e intoko juka' enchim yo'owata enchim tejwaari, junaka'a eme'e bo'o jooria ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Junak bempo: ―Ju'u Apra'amtuka'u juna'a ju'u che'a bat naataka itom yo'owasuka'u ―ti a' yoopnak. Taa ju'u Jesus: ―Lutu'uriapo eme'e, Apra'amtuka'u betana yeu katriamtuko, eme'e aapo'ik joaka jiapsisuka'a benasi jiapsi ean. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Taa junuentaka juni'i, juka' lutu'uriata, jiba aapo'ik Liojta betana in mabetaka'uta, inika'a nee emou nokao juni'i, eme'e nee me'ebaeka'ea. Ju'u Apra'amtuka'u kaita inile benak yaak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Eme'e jiba juka' enchim yo'owata bo'o jooria'u a' bo'o joa ―ti jiiak. Junak bempo: ―Itepo, katte, jamut ka kunakamta betana kia beja yoemiarim. Itepo si'ime wepu'ulaik te yo'owak, juka' Liojta ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ju'u Jesus junako inimmeu: ―Lutu'uriapo eme'e juka' Liojta a' yo'owaka'ateko, eme'e nee nak ta'aa ean. Bwe'ituk inepone, Liojta betana weyeka ne inim aane. Inepo nee ka kia beja in ea'po inim yebijlaa, ala, aapo ju'u Lios nee a'abo bittuari. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Jaisa betchi'bo eme'e, ju'u in emou teuwaa'ut ka ju'unee machi. Inien maachi, juka' nee betana lutu'uriata in yee majta'uta, ka enchim a' jikkajibae' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ju'u enchim yo'owa, ini'i ju'u bebeje'eri juna'a. Eme'e intok jiba aapo'ik betana kaate. Intok eme'e jiba juka' aapo'ik tu'uree'uta a' joobae. Ju'u bebeje'eri che'a bat inim si'imeta ju'unaktewak naateka yee su'awamta a' weetua. Ini'i, juka' lutu'uriata tua ka a' sawa. Intok ini'i, jakwoo juni'i a' teuwaa'u ka lutu'uria. Aapo juka' aa noki'ichiata teuwa'ateko, junak jiba aapo'ik junuen a' machiaka'a benasi aane. Bwe'ituk aapo ka lutu'uriata nonoka, intok si'ime ju'u aa noki'ichia aapo'ik betana weye. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Taa nee intok junuen juka' lutu'uriata in a' teuwa' betchi'bo, eme'e ka nee suale. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Emo betana tua kaabe aane, ini'i, juka' jita ka tu'ik in ya'ari, nee ju'uneiyaaka a nee yeu bwijneeme. Intok junuen ineponee lutu'uriata nee nokao, jaisaaka eme'e ka nee suale. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wa'a Liojta mak eaka jiapsame, ini'i, Liojta betana juka' nok lutu'uriata a' jikkajine. Taa junuen, eme'e ka Liojta betana kateka, ka aamak eakai, inia betchi'bo eme'e ka a' jikkajibae ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Junak intok jume' juriom aapo'iku: ―Lutu'uriata te jipue itepo, bwiaara Samaaria' tea'a betana em jometuka'u, intok bebeje'eri ka tu'i jiapsita et ane'e ti jiakai ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Junak ju'u Jesus inimmeu: ―E'e, kia jita bebeje'eri jiapsita juni'i ka net aane. Ala ju'u in joa'u, ini'i, juka' in yo'owa Liojta a' yo'ori tebonee'u juna'a. Eme'e intok naa buustia ka nee yo'oreka nee bicha. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ineponee juka' eiyaawaka in yo'orinaa'uta nee ka a' waata. Ala seenu, ini'i nee yo'ori i'ame aane. Intok juna'a aapo inim a yee ya'uraa bittua. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wa'a in teuwaa'uta a' nok jikkajame, ini'i jakwoo juni'i ka mukne. Iniat eme'e nee sualne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Junak intok jume' juriom: ―I'an ala itepo witti ju'unea, bebeje'eri jiapsita et ane'epo ―ti au jiiak―. Ju'u Apra'amtuka'u intok si'ime jume' bat naataka Liojta betana ju'uneetuawaka chukula yeu weenemta teuwaame, si'ime kokkok. Empo intok: “Wa'a in teuwaa'uta a' nok jikkajame, ini'i, jakwoo juni'i ka mukne”, ti empo jiia. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Jaisa empo ju'u itom yo'owasuka'u Apra'amtuka'uta bepa che'a yo'owe ja'ani. Aapo muukuk intok jume' Liojta betana ju'uneetuawaka chukula yeu weenemta teuwaame si'ime ket kokkok. Jabeta benasia sa empo emo jooa ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Junak ju'u Jesus: ―Ineponee yo'orisi in eiyaanaa'uta nee betana a' waatakai, junak ju'u yo'orisi in eiyaanaa'u, kaita betchi'bo tune. Taa ju'u nee yo'ori tebome, ju'u in yo'owa juna'a, jiba ju'u, nokaka, Lioj ti enchim teuwaa'u ―ti am yoopnak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Taa eme'e junaka'a tua ka a' ta'aa. Ineponee ala nee a' ta'aa. Intok inepo ka ino a' ta'a'ati jia'ateko, tua nee emo benasi aa noki'ichi ean. Taa inepo nee tua lutu'uriapo a' ta'aa. Intok inepo juka' aapo'ik teuwaa'uta, kaita be'eeka a' noki chupa. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ju'u Apra'amtuka'u, wa'a che'a bat naataka enchim yo'owa, enchim aet yeu katria, aapo tua alleak. Bwe'ituk taewaim inim in annee'uta a' ju'uneiyaa machiakai. Intok iniat ju'uneaka junuen aapo tua ama butti alleak ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Junak jume' juriom Jesujtau: ―Empo kee san wooi taka ama woj mamni wasukte, intok empo juka' Apra'amtuka'uta jaisa emo bichak ti jiia ja'ani ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ju'u Jesus inen am yoopnak: ―Tua lutu'uriapo ne inen emou jiia, juka' Apra'amtuka'uta kee yoemtuu, inepo nee jaibu nee jiapsan ―ti ameu jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Junak intok jume' juriom, tetam nu'uka, Jesujta ammea mamaasubaekai. Taa aapo ju'u Jesus au essoka intok inimmet wa'am weyeka junama'a te'opopo yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Junama jak wa'am katekai, Jesus senuk yeu a'a tomteka'po naatekai, liptita ama bichak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jume' a' majtim intok: ―Yee majtame, jaisaaka tua ini'i yoeme, ka bichaka yeu tomtek. Jaisa jume' a' yo'owawam ka tu'ik bem a' ya'ala' betchi'bo ja'ani, oo jiba aapo'ik ka tu'ik a' ya'ari betchi'bo ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ju'u Jesus inimmeu: ―Ka ini'i aapo, ka tu'ik a' ya'ari betchi'bo, intok kia ka jume' a' yo'owawam ka tu'isi aula' betchi'bo juni'i ini'i inien yeu yoemtuk. Ala ini'i junuen yoemtuk, inien Liojta a jita joa'uta a' bitna' betchi'bo ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ketun taewaituko, itepo juka' nee a'abo bittuakamta betana tekilta itom a' ya'anee'uta utte'a. Bwe'ituk lauti ka machine, junak kaabeta a tekipanoaneeo. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Inepo ketun inim aniapo anekai, nee, jume' inim jiapsammeu, inepo tachiriata benasi nee ameu maachi ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Inika'a teuwaasuka, chukula ju'u Jesus, bwiapo chit wattek intok iniae techoata iliikik yaaka intok ju'u ka bichamta a' pusim bepa a' yaak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Junak intok inen au jiiak: ―Aman jum ba'a maneka'u, emo baksiane, Siloe' tea'awi. Inime'e team: Aman Bittuari, ti jiubae. Ju'u ka bichame aman sikaa, au baksiak. Intok ini'i notteka jaibu bichan. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Junak jume' ae naapo jo'aakame intok jume' bat naataka aapo'ik ka bichamta a' ta'aa'um, inime'e: ―Jaisa ini'i ka juna'a, bat naataka kateka netane'u ja'ani ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Waate: ―Ini'i juna'a ―ti jiian. Wate intok: ―Ka aapo juna'a, taa tua ale bena ―ti jiian. Taa jiba ini'i, aapo: ―Lutu'uria, ineponee juna'a ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Junak intok bempo: ―Jaisa empo puj tu'utewaka a bicha ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aapo intok: ―Seenu, wa'a Jesuj teame, aapo techoata yaaka, pujpo net a' yaak intok inen neu jiiak: “Aman jum ba'a maneka'u, Siloe' tea'u emo baksiane”, ti neu jiiak. Nee intok aman siika, intok nee junuen ino pujba baksiasukai beja, ne bit taitek ―ti am yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Junak inime'e: ―Jaksa intok i'an aane juna'a ―ti au nattemaek. Aapo intok: ―Kannee ju'unea ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Junak intok inime'e, juka' bat naataka liptituka'uta, jume' paiseeommeu yeu a' tojak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Taa junae taewai junuen juka' Jesujta techoata yaaka intok juka' liptita a' tu'uteko, inika'a aet a' yum jo'e taewai tuka' betchi'bo, ");
INSERT INTO yaqNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","jume' paiseeom inia o'outau juchi au nattemaek, jaisa yeu sika i'an tu'ika a' bicha'po. Aapo intoko: ―Pujpo techoata net yaak. Inepo intok ino baksiaka i'an intok ne jaibu bicha ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Junak jume' paiseeom betana waate: ―Ju'u inika'a yaakame, kaachin Liojta betana weene. Bwe'ituk ini'i, juka' aet yum jo'e taewaita ka a' yo'ore ―ti jiian. Taa wate intok: ―Jaisa tua aapo inika'a machilaata a' joone, junuen ini'i ka tu'i yoem tuko ―ti jiian. Inia betchi'bo san, bempo'im nasuk ka nau eewame ayukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Intok inime'e juchia ju'u bat naataka ka bicha'utau: ―Empo su jaisa jiia, ju'u yoeme enchi bittuakamta betana ―ti au nattemaek. Ini'i intok: ―Inepo ala nee, junaka'a, senu inim Liojta betana ju'uneaka chukula yeu weenemta tetteuwaka a' yoeme'e ti jiia ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Taa jume' juriom, inika'a, junuen bat naataka a' liptituka'uta, intok juchi a' bicha'uta ka a' sualbaen. Inime'e chukula junae yo'owammeu chai tebokai, ");
INSERT INTO yaqNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","intok junammeu: ―Jaisa ini'i juna'a enchim yoemia, ju'u enchim liptitaka yeu a' yoemtuk ti jia'u. Junak su jaisa auka i'an bicha ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jume' a' yo'owawam intok: ―Ju'uneate inika'a itom a' yoemiaka'po, intok junuen liptitaka yeu a' yoemtuka'po. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Taa itepo, katte ju'unea jachin yeu sika intok i'an a' bicha'po. Intok kia jabeta junen aapo'ik a' bittuaka'po juni'i, te ka ju'unea. Inia betana eme'e aapo'iku nattemaine, aapo su jaibu yo'owe intok jiba aapo a enchim lutu'uria maka ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jume' a' yo'owawam inien jiiak, jume' juriom bem majjae' betchi'bo. Bwe'ituk jume' juriom jaibu nau lutu'uriakan, jabeta juni'i, juka' Jesujta a' Krijto'oti jiamta, jum juriom te'opompo, ka intok ama a' lutu'urianee'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Inia betchi'bo san, jume' a' yo'owawam: “Inia betana aapo'iku nattemaine, aapo su jaibu yo'owe”, ti jiakan. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Junak intok jume' juriom, ju'u bat naataka ka bichamtau juchi chaaek intok: ―Inia betana, yuma'isi, achai Liojta jiba em a' bai sae'uta a' teuwaane. Itepo te ju'unea, junaka'a o'outa, a' ka tu'i yoem tuka'uta ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Junak intok juna'a: ―Inepone, inika'a aapo'ik a' ka tu'i yoem tuka'u betana nee ka ju'unea. Inika'a bat naataka in liptitaka, taa i'an intok in bicha'uta, inika'a ala nee ju'uneiyaa ―ti am yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Inime'e intok juchi wee'po iniau: ―Jitasa eu yaak. Jaisa enchi puj tu'utek ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ini'i intok: ―Jaibu ne enchim tejwaasuk, eme'e intok ka nee sualek. Jaisaaka eme'e juchi wee'po nee enchim tejwaa i'a. Jaisa eme'e ket aapo'ik Jesujta mak eebae ja'ani ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Junako inime'e, inika'a ka a' yo'oreka au noksuka intok: ―Empo ala junaemak eaka jiapsa. Taa itepo tee juka' Moiseej tuka'utamak eaka te jiapsa ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Itepo, juka' Liojta, ju'u Moiseej tuka'utau a' nokaka'ut tee ju'unea. Taa inika'a, kia jakun a' jometuka'ut juni'i, te ka ju'unea ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Junak ini'i o'ou inimmeu: ―Ju'u enchim teuwaa'u suakiachisi maachi. Eme'e, jakun a' jometuka'uta ka ju'unea. Aapo intok nee puj tu'uteka nee bittuak ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tu'isi ite ju'unea, juka' Liojta, jume' ka tu'ik joaka jiapsame, ju'u bem a'awa'ut aapo'ik ka a' jikkaja'po. Ala, jume' aapo'ik yo'oreka intok aapo'ik ea'po aman jiapsame, bem a'awa'ut am jikkaja ju'u Lios. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Inim jakwoo juni'i, kee senuk betana jikkajiwa senuk ka bichaka yeu tomtekamta inika'a juchi a' bittuaka'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ini'i o'ou ka Liojta betana weye'eteko, tua kaita inile benak machilaata a joo ean ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Junak intok bempo iniau: ―Empo em yeu tomteka'po naateka, ka tu'i yoemtakai, jaisa ket empo jitat itom majtabae ja'ani ―ti au jiiak. Intok inime'e, bempo bem te'opopo, juka' a' lutu'urianee'uta a' u'aak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ju'u Jesus juka' liptituka'uta, junama'a bem te'opopo ka intok ama a' lutu'uriane' betchi'bo yeu bepwakamta ju'uneiyaak. Intok chukula junaka'a bichakai: ―Jaisa empo juka' inim yoemta a' suale ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ini'i o'ou intok: ―Achai, inia betana nee tejwaanee a' jabe tuka'uta junuen nee a' sualne' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ju'u Jesus junau: ―Jaibu empo a' bitlaa. Ineponee juna'a, inim ju'u em aamak etejo'u ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Junako ini'i o'ou Jesujtau tonommea kikteka a' yo'orek intok: ―Achai, enchi nee suale ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Junako ju'u Jesus: ―Inepo nee inim bwiau ne yepsak, junuen Liojta bichapo tu'ika bemelak ya'uraata inim aune' betchi'bo, junuen iniae, jume' liliptim bebenam, inime'e am bitne' betchi'bo. Jume' intok bibichame, inime'e, liliptim benasi am tawane' betchi'bo ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Junak intok jume' paiseeom, waate junama'a aamak aneme, inika'a a' teuwaaka'uta jikkajaka: ―Jaisa itepo intok ketchia liliptim bebena ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus intok inimmeu: ―Eme'e lutu'uriapo liliptim benaeko, junak enchim ka tu'uwa ya'arim betchi'bo, ju'u ka tu'isi enchim tawaa'u ka emot au ean. Taa eme'e emo bibicha'ati jia' betchi'bo, eme'e jiba iniat juka' ka tu'ik enchim ya'ari'uta jiba emot tatawaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Tua lutu'uriapo ne inen emou jiia, ju'u, jum bwaram ja'abweka'u, ka junama'a jum bem yeu rejte'epo luula aman kibakeme, taa omot aman kibakekame, ini'i jita e'etbwametune. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Taa ju'u, junama'a, inime'e yeu rejte'epo aman luula kibakneeme, ini'i ala juna'a, ju'u inime'e bwaaram suuareeo. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Inika'a, ju'u bwaram yeu rejte'epo jiba aneka a' suuame, a' kibakne' betchi'bo, pueetata a' etaporiane. Jume' intoko bwaram inika'a jiawai ta'aane. Ini'i, jume' bwaram bem teampo ameu chaaeka intok junama'a bem ja'abweka'po yeu am nuk sisime. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Intok ini'i, si'ime jume' a' bwarawam yeu nuk simsukai, aapo ame pat weene. Intok jume' a' bwalam a' jajanee bwe'ituk a' jiawai ta'aa. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Taa inime'e, senuk ka bem ta'aa'uta, ka a' jajane. Ala junaka'a a' to'o tennine. Bwe'ituk inime'e, ju'u ka bem ta'aa'uta, ka jiawai ta'aakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ju'u Jesus inika'a, jitaa ta'abwik teuwaaka, am majtan. Taa bempo, ju'u aapo'ik ameu teuwaabae'ut ka aet ju'uneak. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Junak intok ju'u Jesus juchi wee'po inen ameu jiiak: ―Lutu'uriapo ne inen emou jiia, ineponee juna'a, ju'u, jume' bwalam ja'abweka'u aet aman am kikkimu'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Si'ime jume' nee bepat a'abo yajakame, inime'e, jita e'etbwaka intok yee ko'okosi joaka jita am u'aame. Taa jume' Liojta yoemiam, bwalam benasi ta'eewame, ka am nok jikkajak. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ineponee juna'a, ju'u aet aman kimu betchi'bo, pueetapo ta'eewame. Wa'a net yoem eaka aman yebijneeme, ini'i jinne'uitune. Intok ini'i, bwalata a' weyeka'po, yeu weamaka intok yeepsaka, tu'i bajta a' tettea'a benasi machine. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ju'u jita e'etbwaneeme, ini'i wepulsi, etbwabaeka, jissu'abaeka intok jita nasontebaekai yebijne. Taa inepo nee ala inim yebijlaa, junuen jiapsiwamta emot autua' betchi'bo, intok inika'a, kaita be'eeka, yuma'isi emot a' autua' betchi'bo ne inim yebijlaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ineponee juna'a ju'u, jume' bwaram tu'isi am bichame. Ju'u, jume' bwalam tua am nakeka am bichame, ini'i a ame betchi'bo muuke. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Taa ju'u, kia tomita betchi'bo jiba tekipanoame, ini'i, juka' roobota ameu weyemta a' bichakai, jume' bwaram su'u tojaka buitine. Bwe'ituk ini'i ka juna'a ju'u am nakeka am bichame. Intok ini'i, jume' bwaram ka aapo am atteakai. Junak intok ju'u roobo, jume' bwaram, watem am bwiseka am su'ane, jume' watem intok na'ikim beepne. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ini'i am to'o bui buite bwe'ituk aapo kia tomita betchi'bo jiba tekipanoa, intok jume' bwaram betchi'bo kaachin au eetuakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Ineponee juna'a, ju'u bwaram tua am nakeka am bichame. Juka' in yo'owata, aapo'ik nee a' ta'a'a benasia, intok nee aapo'ik a' ta'a'a benasia, ket jiba junaen ineponee jume' in bwaram nee am ta'aa. Bempo intok ket nee ta'aa. Intok inepo jume' in bwalam betchi'bo in jiapsita nenkine. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ketchia, wate tatta'abwi, ka inim bwalam nee am jipue. Inime'e ka inim bwaram benasi in eiyaa'um jiapsa'po joomem. Inime'esan, utte'a a'abo in am tojinee'u. Intok inime'e, in ameu noka'uya a' jikkajine. Junak intok inim si'ime wepulsi nau tojiritune, intok wepu'ulaine, ju'u tu'isi am nakeka am bichame. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Inia betchi'bo ju'u in yo'owa nee nak ta'aa. Bwe'ituk ineponee inim in me'etune' betchi'bo ne in jiapsita a' nenenka junuen chukula juchi in a' mabet betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Inim kaabe jiapsita a nee u'aa. Ala inepo nee in junen ea'po aman jiba a' nenkine. Neu lutu'uria, jiapsita in a' nenkaka intok chukula in a' mabetne' betchi'bo. Ini'i juna'a, ju'u, juka' in yo'owata nee aet a' saweka'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jume' juriom junak inika'a a' teuwaaka'uta a' jikkajakai, bempo'im nasuk juchi ka nau eewame ayukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Juname betana juebenaka: ―Jaisaaka eme'e a' teuwaa'uta jikkaja, inika'a bebeje'eri jiapsita aet aneka intok ka suatulata ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Taa waate, inime'e: ―Kaabe senu bebeje'eri jiapsita aet aneka intok a inien nok ean. Ju'u bebeje'erita ka tu'i jiapsekame, kaachin jume' liliptim juchi a am bittuane ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Inim sebe'etaewaim tukan. Intok jum bwe'u jo'ara Jerusalen tea'po, inim juka' bwe'u te'opota, Liojtau bicha aet a' na'ikiawaka'u waatiwaka, pajkowan. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ju'u Jesus jiba junama'a, Liojta bwe'u te'opopo, ae konila junama'a Salomon tuka'uta aapo'ik jitae mekka jikau a' jekka ya'arim tea'po ama weaman. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jume' intok juriom juebenaka inim au yajaka, konila au japteka intok: ―Jakwoo tajtiasa itepo ee betana tua kaita ju'uneiyaane. Empo junen ju'u Krijto tuko, sep witti itom tejwaane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ju'u Jesus intok inimmeu: ―Jaibu ne inia betana a' teuwaalaa intok eme'e ka nee sualek. Ju'u machilaa, ju'u in yo'owa betana lutu'uriaka in joa'u, jiba inika'a machisi a' teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Taa inika'a eme'e ka a' suale. Bwe'ituk eme'e, jume' bwalam benasi in eiyaa'ummak ka amemak na'ikiarim, jiba bat naatakai in emou jiaka'a benasia ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Jume' in at team, bwalam benasi in eiyaa'um, inime'e nee jiawai ta'aa. Ineponee am ta'aa. Bempo intok nemak eaka jiapsa. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Inime'e jiba yuu jiapsiwamta inepo nee amet autua. Intok inime'e jakwoo juni'i ka kokkone. Intok kaabe inim in am jipue'po, nee am u'aane. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Inime'e, ju'u in yo'owa nee betchi'bo yeu am pu'ari. Intok aapo inim che'a si'imem bepa yo'o utte'akai. Inien san aapo'ik am jipue'e betana tua kaabe a am nu'une. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Inepo intok ju'u in yo'owa, itepo te nau wepu'ulai. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Junak intok jume' juriom juchi wee'po tetam nu'uka, aapo'ik ammea mamaabaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus intok inimmeu: ―Inim enchim bichapo tua juebenak tu'ik nee ya'ari, ju'u in yo'owa Liojta betana a jita a' joa'ue aniawakai. Inia weyemta betana jita betchi'bosa eme'e nee mamaabae ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jume' juriom intok: ―Katte itepo inia tu'ik em ya'ari betchi'bo enchi mamaabae. Ala ju'u, Liojta beje'eka tua ka tu'ik em teuwaa'u betchi'bo. Empo wepulsi kia yoemtaka, taa intok jiba empo su emo Lios jooa ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ju'u Jesus inime'e inen yoopnak: ―Jiba jum enchim nesauri ji'ojteipo inim, juka' Liojta: “Inepone, enchim liosim ti jiia”, ti a' jiaka'u ama ji'ojtei. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Itepo su te ju'unea, juka'a, jum Liojta nok lutu'uriapo teuwaarita, ka ta'abwisi intok weyeka, a' ji'ojtei tuka'po. Intok ju'u Lios junuen, jume' aapo'ik betana juka' nok lutu'uriata a' mabetakame, aapo Liosimpo am ta'aak. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Intok junuen, nee Liojta betana yeu pu'awaka intok a'abo nee bittuawako, jaisa tua eme'e, Liojta beje'eka a' omtituamta nee a' teuwa'ati jiia, kia junuen: “Ineponee Liojta yoemia”, ti in jiaka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nee intoko, ka ju'u in yo'owa Liojta betana weyemta machilaata nee a' joao, ka eme'e nee sualne. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Taa inika'a weyemta nee a' bo'o jooriao, junuen, eme'e nee ka sualeka juni'i, taa juka' machilaata in joa'uta eme'e inika'a a' sualne. Junuen, juka' achaita, aapo'ik net a' ane'uta intok nee ket aapo'ik in yo'owabet in ane'uta a' ju'uneiyaaka, inien a' lutu'uria tuka'uta a' mabet betchi'bo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Inim juchi wee'po, inime'e, bempo a' bwiseka a' weiyaabaen. Taa ju'u Jesus, inime betana aapo au jinne'uka yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Junako ju'u Jesus, jum batwee Jooraan tea'po, ta'ata yeu we'e betana juchi aman notteka intok ama taawak, jiba junama'a, jum bat naataka juka' Joan tuka'uta yee a' bato'owaaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Junama'a juebenaka au noitek. Intok inime'e: ―Lutu'uria, ju'u Joan tuka'u kaita machilaata, a jita a' joa'uta yaaka juni'i, taa si'ime ju'u, inia yoemta betana a' teuwaaka'u lutu'uria tukan ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Junama'a a' ane'epo intok, tua juebenaka a' sualek. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Junama junak, senu Laasaro' teaka ko'okoen. Ini'i, kia ili jo'ara Betaania' tea'po jo'aakai. Ket jiba junama ju'u Maria' teamta intok a' akkoowa Maata' teamtaim bem jo'aaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ini'i Maria' teame, ju'u ko'okoemta Laasaro' teamta jamut waai, aapo juna'atukan, ju'u, yo'owe Jesukrijtota wokimmet juka' ochokok win jubakamta amet to'oka intok a' choniwammea am wachakame. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Inien san inime'e woika nau wewerika, Jesujtau nokta bittuak: ―Itom yo'owa, ju'u em aamak tu'ika, em ta'aa'u, tu'isi ko'okoe ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ju'u Jesus inika'a ju'uneiyaakai: ―Ini'i ko'okoa, ka aapo'ik a' mukne' betchi'bo weye. Ala ini'i, juka' achai Liojta tua si'imeku a' eiyaawachiaka'uta a' bitna' betchi'bo. Intok ketchia, inia ko'okoata betchi'bo, juka' Liojta usiwaita, si'imeku a' eiyaawachiaka'uta a' bitna' betchi'bo ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ju'u Jesus, juka' Maata' teamta intok juka' a' jamut waai intok juka' Laasaro' teamta, tua am nakeka juni'i, ");
INSERT INTO yaqNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","aapo juka' Laasaro' teamta a' ko'okoe'po tejwaawakai, jiba jum a' ane'epo, juchi wooi ta'apo ama taawak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chukula, aapo jume' a' majtimmeu: ―Bwiaraa Jurea' tea'u bicha te juchi nottine ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jume' a' majtim junak aapo'iku: ―Yee majtame, i'an jeela jume' juriom junama jo'aakame, tetammea enchi mamaasuka enchi me'ebaen. I'an intok, jaisa empo juchi aman weebae ja'ani ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ju'u Jesus inimmeu: ―Eme'e ju'unea, juka' taewaita, woj mamni ama wooim a' oraka'po. Ju'u taewapo weamame, ini'i ka te'itine. Bwe'ituk aapo inim aniapo tachiriata ayukamtae bichakai. Junuen san, katte jain eaka am bicha katne, bwe'ituk juka' taewaita in aet muknee'u a' yuma'anee'uta ketuni be'ee ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Taa seenu, tukaapo weama'ateko juna'a ala a te'itine, tachiriata au a' be'e' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Che'a chukula ju'u Jesus a' majtimmeu: ―Ju'u itom aamak tutu'ika itom eiyaa'u, Laasaro' teame koche. Taa ineponee aman sika a' busa'ane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Junak jume' a' majtim: ―Achai, aapo kotche'eteko, tu'ibaeka junen koche ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Taa ju'u Jesus, juka' Laasaro' teamta a' mukuka'uta ameu a' teuwaabaen o'oben. Jume' a' majtim intok, senuk inim yum jo'eka a' kotche'ut a' noka'ati ean. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Junen su, chukula ju'u Jesus ju'unakkiachisia: ―Ju'u Laasaro mukia ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Inepo, ka ama in aneka' betchi'bo nee kaachin ino eetua. Bwe'ituk ini'i, emo betchi'bo che'a tu'isi yeu weama. Junuen enchim nee sualne' betchi'bo. Taa jantebu, aman te a' bitne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Junak intok ju'u Toomaj teame, wa'a wo'oli ti teuwaawame, ini'i, jume' waate aamak yeu pu'arimmeu: ―Jantebu itepo ketchia, junuen aman aamak nau kokko betchi'bo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Aman yepsakai ju'u Jesus, juka' Laasaro tuka'uta, jaibu naiki ta'apo jum senu tetapo wojo'oriata ya'aripo a' ma'aritau aman yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ju'u ili jo'ara Betaania' teame, bwe'u jo'ara Jerusalen tea'u ka mekkaekan, jumak wooi kiloometrom ama mamni siento meetrom tukan jiba. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jume' juriom betana intok, juebenaka aman Maata' teamtau intok Maria' teamtau aanen, juka' bem abachi mukuka'a betana am jiapsi jo'abaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ju'u Maata' teame, juka' Jesujta aman a' yebijsuseka'po a' ju'une'eiyaakai, aapo a' nankibaeka yeu siika. Taa ju'u Maria' teame a' jo'awapo taawak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ini'i Maata intok ju'u Jesujtau: ―In yo'owa, enchi inim aneo, ju'u in abachi ka muk ean ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Taa ket ne ju'unea, juka' Liojta, si'imeta juka' aapo'iku bicha em a'awa'uta, a enchi a' bittua'po ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ju'u Jesus, aapo'iku: ―Ju'u em abachi juchi jiapsine ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ju'u Maata intok junak: ―Lutu'uria, ju'uneanee chukula taewait, jume' kokkoarim jiabijteneeo, juchi a' jiapsinee'u ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Junak ju'u Jesus iniau: ―Ineponee juna'a, ju'u kokkoarim nasuk yee jiabijtetuaka, jiba yuu jiapsiwamta yetet utuane. Junuen, wa'a nee sualeme, kia mukiataka juni'i, juna'a juchi jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Intok jabetaka juni'i, ketun inim jiapsaka intok nee sualeme, ini'i, jakwoo juni'i ka mukne. Jaisa empo inika'a suale ja'ani ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aapo intok: ―Jeewi in yo'owa. Inepo nee enchi junen ju'u Krijtotuka'u enchi suale. Ju'u Liojta yoemia ju'u inim bwiau yebijneeka bo'o bitwame ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chukla inika'a teuwaasukai ju'u Maata, ju'u a' waaibeu Maria' teamtau chaaebaeka au siika intok junau: ―Ju'u yee majtame im aane intok eu chaae tebo ―ti jiaka, ka kusisi a' tejwaak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kia inika'a jikkajaka jiba ju'u Maria, kikteka intok Jesujta ane'u au siika. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ju'u Jesus junama ili jo'ara Betaania' tea'u ketun kee aman kibaken. Taa ketun, jiba jum Maatata au yepsaka'po aanen. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Junak jume' juriom a' jo'apo a' jiapsi yechaka aamak ama ane'um, junuen Mariata, kikteka intok sep yeu sikamta bichakai, inime'e aet cha'aka sajak, bempo, juka' Laasaro tuka'uta ma'ariu sika aman a' bwanbae'eti eakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Junak intok ju'u Maria, Jesujta ane'u yepsakai, aapo'iku tonommea kikteka intok: ―In yo'owa, enchi im aneo, ju'u in abachi ka muk ean ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ju'u Jesus, juka' Mariata intok jume' juriom aamak ama yajakame bwaname bichakai, tua a' sioka'u intok a' jiapsipo tua a' juiwa'u aet ayukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Intok aapo: ―Jakunsa eme'e a' teekak ―ti ameu nattemaek. Bempo intok: ―Itom yo'owa, a'abo sika a' bitne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Junak ju'u Jesus bwaanak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Junak jume' juriom: ―Ake'em a' bicha, tua a' nakken ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Taa juname betana waate: ―Ini'i, waka'a liptita a' bittuakame, jaisa juka' Laasaro tuka'uta, ka a' mukne' betchi'bo a' ania ean ja'ani ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus, juchi tua jiapsipo a' juiwaka, jum tetapo wojo'orita ya'ariu ruktek. Ini'i, senu kau tejtukan. Intok ini'i, senu bwe'u tetae pattitukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Junak ju'u Jesus: ―Juka' tetata em omola kechaa ―ti jiiak. Ju'u Maata, ju'u mukukamta mak weri: ―In yo'owa, ini'i jiba tua jumak, jaibu tua juuba, bwe'ituk jaibu naiki taewaim jipue mukiatakai ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Taa ju'u Jesus iniau: ―Jaisa inepo, juka' Liojta betana tua eiyaawatchika, a jita a' joa'uta em a' bitnee'uta, ka eu teuwaala ja'ani. Inika'a enchi a' sualeo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Junak intok ju'u teta omola biaktawak. Ju'u Jesus intok teekau jikau bicha bitchuka intok: ―In yo'owa, enchi ne bai sae, bwe'ituk empo ju'u in teuwaa'ut nee jikkaja. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ju'uneane, ju'u in teuwaa'ut, jiba em nee aet jikkaja'po. Taa inika'a nee teuwaa jume' inim aneme aniabaekai, junuen inime'e, em a'abo nee bittuaka'po bem a' sualne' betchi'bo ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chukula, inika'a teuwaasuka, kusisi nokaka: ―Laasaro, junum a'abo yeu weye ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ju'u intoko mukia tuka'u, yeu siika, mampo intok wokpo tajo'orimmea biijti takai. A' pujbat intok ket tajo'orimmea bi'iti takai. Ju'u Jesus inimmeu: ―Tajo'orim em a' woitaria, a' weene' betchi'bo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Inia betchi'bo jume' juriom betana juebenaka Jesujta sualek. Jume' Mariata mak aman yajakame intok Jesujta yaaka'uta a' bichakame. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Taa inime betana waate, jume' paiseeom teammeu lauti sajaka intok inime'e juka' Jesujta yaaka'uta ameu teuwaak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Junako jume' paiseeom intok jume' te'opopo tekiakammeu yo'owe, inime'e, ju'u jurio yoemratau, si'ime ju'u yo'oraata ama emo nau toji tebok intok inimmeu: ―Jaisa tua tee aune. Ini'i o'ou, machilaata juebenak, a jita a' joa'ue a' jooa ―ti jiian―. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Itepo inika'a junuen a' su'u tojako, si'ime ju'u inim yoemra a' sualne. Junak jume'e, jum bwe'u jo'ara Rooma' tea'po yo'ooraa, sontaaom a'abo bittuaka intok inime'e itomak nassuaka, itom bwe'u te'opota tatapnee intok inim yoemrata a' lu'utane ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Taa inime'e betana seenu, Kaipaaj teame, ju'u junae wasuktiat, si'ime jume' te'opopo tekiakammeu che'a yo'o tuka'u, ini'i inimmeu: ―Eme'e kaita em tatta'aa ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Intok kia eme'e ka a' mammate juni'i, ito betchi'bo che'a a' tu'ireaka'u, junuen inim senuk itom yoemrata betchi'bo, wepu'ulaik jiba a' muknee'u. Intok ka junuen si'ime yoemrata a' lu'utanaa'u ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Taa aapo ju'u Kaipaaj teame, ka aapo a' ea'po junuen jiiak. Ala aapo junae wasuktiat, jume' te'opopo tekiakammeu che'a yo'o ya'atakai, aapo, Liojta betana aet ju'uneetuawaka junuen, Jesujta ju'u jurio yoemrata betchi'bo a' muknee'uta a' teuwaak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Intok ka kia junae yoemrata betchi'bo jiba, taa ketchia si'imem jume' Liojta yoemiam, aniat na'ikimtulame junuen nau am toji betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Junuen san, jiba junae taewait naateka, ju'u jurio yoemratau yo'oora, juka' Jesujta a' me'e tebo betchi'bo, inime'e nau etejoka a' lutu'uria yaak. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Inia betchi'bo san ju'u Jesus, ka intok ju'u jurio yoemrata nasuk ame bichapo weaman. Ala aapo, jum a' ane'u betana yeu sika intok aman bweka pa'ariau yeu ka au mekka kateka, ili bwe'u jo'ara Epra'im tea'u bicha siika. Junama'a a' majtimmak tawakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Junama'a jaibu ka mekka be'een, jume' juriom bwala jissu'aka pajko jiba bem joa'uta a' yuma'anee'u. Yoemra intok juebenaka junama'a ili ka bwere jo'aram be'ekatana junaman bwe'u jo'ara Jerusalen tea'u nau yajak. Inime'e junuen, juka' pajkota, kee a' naateo, Liojta bichapo emo tu'utewamta a' ya'abaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Junama'a waate, Jesujta jaiwan. Intok jum te'opopo anekai, bempo: ―Jaisa eme'e jiia, jaisa a'abo pajkou yebijnee ja'ani, oo ka a'abo weene ―ti nau nattemaen. ");
INSERT INTO yaqNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jume' paiseeom intok wame'e te'opopo tekiakammeu yo'owe, inime'e, jabeta juni'i, Jesujta jakun a' ane'uta a' ju'uneiyaamta, junaka'a bempo'im a' tejwaanee'uta a' teuwaalatukan, junuen bempo'im a' bwijne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Busan taewaim be'eeka, Liojta yo'oreka, juka' bwala jissu'awaka pajkowamta kee a' yumao, ju'u Jesus, jum ili jo'ara Betaania' tea'u noitek. Junaman jum Laasaro' teamta, inika'a mukiataka jiba aapo'ik Jesujta juchi a' jiabijtetuakamta a' jo'aaka'awi. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Junama'a bempo, Jesujta alleaka, tu'isi a' mabet betchi'bo, kupteo bem nau bwa'anee'uta a' yaak. Ju'u Maata ama am a'abosen. Ju'u intoko Laasaro, ama mesau jokammak katekan aapo'iku mak ji'ibwakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Junako ju'u Maria, jumak litrota nasuk'aman, juya naaro' teamta win jubaekamta, ochokok ausu'lik intok tua beje'emta, ama a' nu'upak. Intok inika'a Jesujta wokimmet a' yaakai. Chukula intok chonimmea a' wacha'ariakai. Junama karipo si'imekut junae win jubakue tapunak. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Junak intok ju'u Juuras Ijkarioote' teame, senu Simo' teamta yoemia, ini'i ket jume' Jesujta majtimmak na'ikiatuka'u intok jiba ini'i chukula aapo'ik yeu bwijnee'u, aapo: ");
INSERT INTO yaqNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Che'a tu'i ean ini'i ochokoka win jubakue ya'ari, busan miil tosai tomimpo nenkiwako, junae jume' kaitae emo ania machim aniawako ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ju'u Juuraj teame inika'a teuwaak, taa ka lutu'uriapo jume' kaitae emo ania machim a' eiya' betchi'bo. Ala ini'i, a jita etbwakai. Intok ini'i, jiba aapo su juka' bem tomi boosata a' makritakai intok junama juka' ama a'ayumta a' nunu'een. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Junak intok ju'u Jesus: ―Kia beja a' bicha. Bwe'ituk aapo inika'a, chukula nee ma'anaao betchi'bo a' e'eriala ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Jume' kaitae emo ania machim jiba eme'e inim emo nasuk am bitne. Taa nee, eme'e ka jiba inim bitne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jerusalenpo juebenaka jume' juriom betana, juka' Jesujta, jum ili jo'ara Betaania' tea'po a' ane'epo a' ju'uneiyaak. Intok inime'e aman sajak. Inime'e, ka juka' Jesujta jiba, taa ketchia junuen juka' Laasaro' teamta, juka' Jesujta mukiataka, juchi a' jiabijtetuaka'uta aman bitbaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Junako jume' te'opopo tekiakammeu yo'owe, bempo aet nau etejok, junuen juka' Laasaro' teamta ket bem a' me'e tebo betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Bwe'ituk jiba aapo'ik Laasarota betchi'bo, juebenaka jume' juriom ka intok bempo'im mak ean taa Jesujta mak eaka a' sualbaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yoemra tua juebenaka jum bwe'u jo'ara Jerusalen tea'po aanen junuen junama'a, Liojta yo'ori betchi'bo bwala jissu'awaka pajkowamta bitbaekai. Yokoriapo intok inime'e, juka' Jesujta junaman bwe'u jo'arau a' yebijnee'uta a' ju'uneiyaak. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Junako inime'e junama'a tako sawam chuktaka, intok Jesujta nanki betchi'bo yeu sajak. Intok inime'e: ―Yee jinne'ume. Yo'oriwaka tu'ikue teuwaanaa ju'u Liojta betana lutu'uriaka itou che'a yo'otaka a'abo weyeme ―ti jiian kusisia. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ju'u Jesus, ili buuta teaka intok junaet yej simen, jiba jum Liojta betana ji'osia ji'ojteimpo: ");
INSERT INTO yaqNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ka majjaunee eme'e, bwe'u jo'ara Sion tea'po joomem. A' ju'uneene, juka' inim emou che'a yo'o ya'arita, Ili buutat yej simeka a'abo emou a' weye'u, ti a' jia'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jume' a' majtim che'a bat inia weemtat tua ka aet ju'uneak. Taa chukula, junak juka' Jesujta, kokkoarim nasuk a' jiabijteko, junak inime'e au wawaatek si'imeta inika'a aapo'ik betana a' ji'ojtei tuka'po intok ket jiba junaen au yeu a' sika'apo. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ju'u yoemra, juka' Jesujta junak tetapo wojo'oriata ya'aripo intok Laasarotau nokaka, mukiataka juchi a' jiabijtetuaka, aamak ama ane'um, inime'e, juka' bem bichaka'uta naas a' teuwaan. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Inia betchi'bo ju'u bu'uuraa, Jesujta nankibaeka au yeu sajak. Bwe'ituk inime'e, juka' machilaata, a jita a' joa'uta a' yaaka'ut bem ju'uneiyaaka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Junako jume' paiseeom bempo su naas nau: ―Ake'em a' mammate, tua kaachin intok itom an machiaka'u. Yuu, si'ime ju'u inim yoemra aamak eaka aamak saka ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jum bwe'u jo'ara Jerusalen tea'po ju'u yoemra, pajkopo Liojta yo'oribaeka, jume' aman yajilame nasuku, yoemra riekom teame betana waate ama aanen. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Inime'e, Jeriipe' teamtau yajak, ju'u, jum bwiaraa Kalilea' tea'po ili jo'ara Betsaira' tea'po jo'aakamtawi, intok inime'e au ujbwanak: ―Achai, juka' Jesuj teamta te bitbae ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ju'u Jeriipe' teame intok sikaa, juka' Antej teamta tejwaak. Inime'e intok, bempo nau, Jesujtau sajaka a' tejwaak. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Junak intok ju'u Jesus inimmeu: ―Yuma'asuk ju'u taewai, juka' inim emo benasi yoemta, juka' a' ya'aa'ea'uta, aapo'ik a' chupaka junuen, yo'orisi a' eiyaanaa'uta au a' chupneeo ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Lutu'uriapo ne inen emou jiia, ju'u tiiko bachia, ka bwiapo etwa'ateko intok ini'i ka siwekai, junuen, wepulsi bachiatunee jiba. Taa ini'i, senuk mukuka, bwiapo a' ma'awaka'a benasi, ini'i junuen etwakai, intok siwekai, junak yu'in bachiane. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wa'a inim bwiapo, alleaka a' jiapsinee'uta jiba eiyaaka jiapsame, ini'i, jiba yuu a' jiapsinee'uta a' ta'arune. Taa wa'a, inim bwiapo jiba alleaka a' jiapsinee'uta ka ae betchi'bo a' eiyaakame, ini'i, jiba yuu a' jiapsinee'uta aet bitne. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Inim wa'a, in a' joo i'a'uta joaka jiapsibaeme, ini'i, nemak eaka jiapsine. Intok jum in ane'epo, ket ama an ean ju'u in a' joo i'a'uta a' joame. Inim seenuk, nemak eaka in joo i'a'uta joamta, ju'u in yo'owa inika'a a' yo'ori tebone. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’I'an tua ne kaachin an machi benasi ea. Jaisa tua ne au jiune. Jaisa inepo: “In yo'owa, i'an neu weenemta betana nee jinne'une”, ti ne au jiunee ja'ani. Taa nee jiba tua inia betchi'bo su nee a'abo ne yebijlaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","In yo'owa, tua i'an bepa yuma'isi eiyaawatchisi yo'orisi em machiaka'uta a' ju'uneiyaatuane ―ti jiiak. Junako, teeka betana jiawai jikkajituk: ―Jaibu nee tua bepa yuma'isi eiyaawatchisia yo'orisi in machiaka'uta nee yeu a' ju'uneiyaatualaa. Intok ne juchi wee'po, junuen ino ju'uneiyaa tebone ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ju'u yoemra junama aneka a' jikkajame, inime'e, teeka betana jitaa ru'u ti jiiak, ti jiian. Waate intok: ―Ankeles au nookak ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Junak intok ju'u Jesus inimmeu: ―Ini'i jiawai, ka nee betchi'bo, taa ala emo betchi'bo jikkajituk ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Jiba i'an, junuen inim aniapo jiapsame, ka tu'isi tawaka, bem ya'uraa bittuanaa'u ameu aune. Intok i'an ju'u bebeje'eri, ju'u inim si'imem sawame, ini'i koba'itaka yeu beeptune. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Intok chukula, inepo nee inim kuuset jikau toboktawako, inim si'imem jume' jinne'uimtuneeme, inepo, jiba neu bicha am waatine' betchi'bo junuen ne am eetuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Inika'a teuwaaka, jiba aapo'ik a' muknee'ut nokaka a' teuwaan o'oben. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ju'u ama yoemra intok: ―Itepo te jum itom nesauri ji'osia ji'ojteimpo inen jiaka nokwamta, juka' Krijto' teamta, jiba yuu a' jiapsine'eti jiamta tee a' jikkajilaa. Jaisaaka intoko empo, juka' inim yoemta, jikau a' toboktitune'eti jiia. Jabesa ini'i, ju'u inim yoeme ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Junako ju'u Jesus inimmeu: ―I'an ketun inim emo nasuk aane ju'u tachiriapo ta'eewame. Taa tua ka binwaa. Junuen san eme'e nemak eaka jiapsa'em, tachiriata benaka in emomak ane'epo tajtia. Junuen, ka tu'ika ka enchim bo'o jooriane' betchi'bo, seej chukti ka machiku rejteme benakai. Bwe'ituk ju'u ka machiku weamame, ini'i ka ju'unea jak luula a' weye'po ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Junuen eme'e, juka' tachiriapo ta'eewamta a' sualnee ketun inim a' aneo. Intok junuen eme'e inia tachiriapo ta'eewamtamak eame ti ta'eenaa. Inika'a weyemta teuwaasuka, chukula ju'u Jesus, yeu sika intok ame betana au essok. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Juka' Jesujta inien juebenaka a jita a' joa'u, machilaata bempo'im bichapo a' ya'alatuk juni'i, inime'e ka a' sualen. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bwe'ituk utte'atukan, inen juka' Liojta betana ju'uneaka, chukula yeu weenemta noka'uta, Isa'iaj tuka'uta a' teuwaaka'uta: Achai Lios, kaabe juka' itom ameu teuwaa'uta a' sualek. Kaabe inim juka' tua suum watchisi machika, Liojta a jita a' joa'uta a' bichaka juni'i, junuen a' suale, ti a' teuwaaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Inien san inime'e ka a' sualen. Bwe'ituk ju'u Isa'iaj tuka'u ketchia inen a' ji'ojtek: ");
INSERT INTO yaqNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ju'u Lios, bibichaka, ka bibichame benasi am tawaak. Intok a jitat bem ju'une'ea'uta am u'aak. Junuen, nee betana weyemta bichaka, ka aet bem ju'uneene' betchi'bo. Intok nee betana weyemtat, ka tua junen jiaka bem aet ju'uneene' betchi'bo. Intok kia inime'e, junuen in am jinne'une' betchi'bo, ka neu bicha am waatine' betchi'bo, ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ju'u Isa'iaj tuka'u inika'a teuwaak, jiba juka' Jesujta betana, tua yuma'isia che'a eiyaawatchisi a' machiaka'uta, aapo'ik a' bittuawaka' betchi'bo. Intok junuen aapo'ik betana a' teuwaak. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Junuentaka juni'i, jume' juriom betana juebenaka Jesujta sualek. Intok inime betana waate ya'uraata mak na'ikiarim juebenaka a' sualekai. Taa inime'e, jume' paiseeom teame majjaeka, junuen juriom bem te'opompo bem lutu'uriaka'uta, ka bem a' u'aana' betchi'bo, inime'e jum anwa'po ka witti a' etejon. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Inime'e junuen, yoemrata betana yo'oriwaka bem eiyaanaa'uta che'a juni'i bem a' tu'ure betchi'bo, Liojta betana tu'isi aet bem bitnaa'u bepa. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ju'u Jesus inim: ―Wa'a nee sualeme, ka wepulsi nee jiba sualne, taa ketchia juka' in yo'owata, a'abo nee bittuakamta junuen sualne ―ti jiiak kusisi nokakai―. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ju'u intoko inim nee bichame, ini'i ketchia juka' a'abo nee bittuakamta a' bicha. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Inepo intok nee inim tachiriapo ta'eewame inim a'abo aniau nee yebijlaa, junuen wame'e nee sualeka jiapsame, inime'e ka inim ju'u ka lutu'uriat bem ji'oplamtune' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Taa wa'a, in teuwaarita a' jikkajaka, intok ini'i ka junaka'a a' nok jiikajaka a' jiapsao, ka inepo juna'a, ju'u ka tu'isi a' tawaaneeme. Bwe'ituk inepo nee ka junuen jume' inim bwiapo jiapsame ka tu'isi am tawaa betchi'bo, ala, inepo junuen am jinne'u betchi'bo nee a'abo yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ju'u inim ka nee mabetbaeme, intok kia in teuwaarita juni'i, ka junaka'a a' nok jikkajaka jiapsame, ini'i, ju'u ka tu'isi a' tawaaneeme aane. Ju'u nok lutu'uria in teuwaari, chukula taewai, yee aet ya'uraa bittuanaao, ini'i junen juna'a, ju'u ka tu'isi a' tawaaneeme. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bwe'ituk inepo nee tua ka in ea'po aman in tu'uree'uta nooka. Ju'u in yo'owa a'abo nee bittuakame, aapo nee aet tejwaala ju'u in teuwaanee'u betana intok ju'u in yee majtanee'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Intok ju'unea nee, juka' in yo'owa betana nesaurita, inika'a jiba yuu jiapsiwamta yee bittua' betchi'bo a' weye'po. Junuen san ju'u in teuwaa'u, inika'a inepo, jiba in yo'owa nee aet a' tejwaari benasia, junuen nee a' teuwaa ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Inim beja jaibu senu taewai be'een, Liojta yo'ori betchi'bo bwala jissu'awaka pajkonaao. Ju'u Jesus, aapo'ik ka intok inim a' annee'ut intok a' yo'owabeu bicha a' nottinee'ut, juka' taewaita a' yuma'asuka'ut ju'unean. Aapo, jume' inim aapo'ikumak eaka jiapsame, jiba am nakek. I'an intoko inim, tua kaita be'eeka, aapo'ik tua am nake'uta a' bit teboka a' ju'neiyaa tebon. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Ju'u bebeje'eri junak jaibu juka' Juuras Ijkarioote' teamta, senu Simoo' teamta yoemia, inika'a, Jesujta yeu bwiseka a' nenkine' betchi'bo junuen a' eetuan. Jesus ju'unean, ju'u achai Liojta betana inim a' yebijlatuka'po, ket intok Liojtau bicha a' nottinee'ut. Intok ketchia, juka' achai Liojta, si'imeku yo'o utte'ata aet aulatuka'po. Junuen san, aapo, ka machiako bem ji'ibwa'po, mesau a' kateka'po, kikteka, bepa a' supeka'um yechaka, intok tajo'orim emo ammea wawachawame nu'uka, wikojpo am chayak. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Junak intok aapo, jum ama babajimawa'po, ba'am to'aaka intok aapo jume' a' majtim am wok baksia taitek. Intok jume' tajo'orim, wikojpo a' chaya'immea am wok wachakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Aapo'ik juka' Simoo Peeo'o teamta a' wok baksiabaao, ini'i: ―Achai, jaisa empo nee wok baksiabae ja'ani ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ju'u Jesus: ―Empo i'an ka aet ju'unea ju'u in joa'utchi. Taa iniat empo chukula ju'uneene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Taa ju'u Peeo: ―Nee ala, empo jakwoo juni'i ka nee wok baksiane ―ti au jiiak. Jesus intok: ―Ka nee enchi wok baksiako, empo ka intok nemak lutu'uriane ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Junak ju'u Simoo Peeo' teame: ―Junuentuko achai, ka wokim jiba, taa mamam intok kobat ket nee baksiane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Taa ju'u Jesus iniau: ―Ju'u ju'ubwa u'uba'alame, aet chukula wokim a' baksianee'uta jiba au bi'ine. Bwe'ituk ini'i takaat si'imekut basulatakai. Eme'e jaibu Liojta mak emo tu'utelamtakai, senuk a' uba'alatuka'abebena. Taa ka si'imetakai o'oben. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Aapo junuen: “Eme'e ka si'imetakai”, ti jiiak, bwe'ituk aapo ju'unean, jabeta yeu a' bwiseka a' nenkinee'ut. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chukula inime'e wok baksiasukai, Jesus, bepa a' tajo'oreka'umpo juchi kobateka intok jum mesau juchi yejteka intok inimmeu: ―Jaisa eme'e ju'u inim in emou ya'arit tu'isi ju'unea ja'ani ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Eme'e, yee majtame intok itom yo'owa ti nee ta'aa. Intok tu'isi em jiia, bwe'ituk inien lutu'uria. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Junuen san, inepo, yee majtame intok enchim yo'owatakai, enchim nee wok baksialatakai, ketchia emou cha'aka, emo nasuk enchim emo wok babaksianee'u. Inika'a teuwaakai, juka' enchim jaitaka, kaabeta joonee'ut enchim emo anianee'ut nee a' teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Inepo nee inika'a enchim a' suawa'une' betchi'bo a' ya'ari. Junuen jiba juka' in ya'arita, enchim a' joone' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Lutu'uriapo ne inen emou jiia, kaabe ju'u tekoka jiapsame, a' teko bepa che'a eiyaatune. Intok kaabe, ju'u yeu pu'aritaka jakun bittuari, ju'u a' saweka yei a' pu'akamta bepa che'a eiyaatuneeme. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Eme'e inia weyemtat ju'uneakai intok a' bo'o jooria'ateko, eme'e tua alleene. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Kannee si'imem emo betchi'bo inika'a teuwaa. Ju'unea nee, jabemmet junen in yeu pu'ariaka'po. Taa juka'a, jum Liojta nok lutu'uriapo ji'ojtei, utte'a a' chupne'po: “Ju'u nemak ji'ibwame, ini'i nee beje'eka kiktela”, ti a' jiaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Inika'a kee a' chupeo nee jaibu emou a' teuwaa, junuen eme'e inika'a a' chupeo a' bichakai, junak che'a bat naataka emou junuen in ino teuwaaka, nee juna'atuka'uta enchim nee sualne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tua lutu'uriapo ne inien emou jiia, wa'a, juka' in au bittuarita, tu'isi a' mabetneeme, ini'i nee mabetlatune. Wa'a intok nee mabetneeme, ini'i, waka'a nee a'abo bittuakamta mabetlatune. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chukula inika'a teuwaasukai, Jesus a' jiapsipo tua ka ine'emaisia a' juiwa'u aet ayukan. Intok junak machisi: ―Lutu'uriapo ne inen emou jiia, emo betana senu nee yeu bwiseka nee nenkine ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Junako jume' aapo'ik majtim naas emo bitchu japtek, jabetat junuen a' noka'apo tua ka ju'uneakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jume' a' majtim betana seenu, ini'i ju'u Jesujta tua nake'u, junama'a kupteo ji'ibwawa'po Jesujtau chapti kateka ji'ibwan. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ju'u Simoo Peeo' teame, inika'a maammea au jiku'ubwaka a' tejwaak, au a' nattemaine' betchi'bo jabetat junen a' noka'apo. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Junak intok ini'i Jesujtau che'a rukteka: ―Achai, jabesa juna'a ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus intok: ―Paanim ne ba'awapo ne komoniane, inime'e intok, ju'u in au am bwijnee'u, juna'atune ―ti au jiiak. Inien san paanim rebbeim ba'awapo komoniaka, intok ju'u Juuras Ijkarioote' teamtau, senu Simo' teamta yoemiabeu am bwisek. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Inika'a Juuraj teamta intok kia inime'e paanim a' nu'uka a' bwa'aka jiba, ju'u bebeje'eri a' jiapsiu yepsak. Junak ju'u Jesus: ―Juka' em ya'anee'uta, i'an lauti a' ya'ane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Taa jume' ama mesau joka ji'ibwame betana, kaabe aet ju'uneak jachin betchi'bo inien au a' jiaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Taa juka' Juraaj teamta, inika'a tomi boosata a' maktuko, waate, juka' Jesujta iniau, pajkota betchi'bo jita bem waata'uta a' jinu i'aka, oo wame'e jiokot eame, jita aapo'ik am miknee'u betana au a' noka'ati ean. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Chukula, ju'u Juuras, paanim mabetsuka, sep yeu siika. Inim beja, jaibu tukaaria tukai. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Juka' Jurajta yeu simsuko chukula ju'u Jesus inimmeu: ―I'an juka' inim emo benasi yoemta, tua bepa a' eiyaawatchiaka'u aapo'ikut bittune. Ju'u intoko aapo'ik juka' achai Liojta, che'a yo'orisi a' machiaka'uta, jiba nee betchi'bo bittune. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Junuen san, juka' achai Liojta che'a yo'orisi a' machiaka'uta, jiba ju'u inim yoemta a' ya'anee'ue aman a' bittuneekai, junuen ketchia, ju'u achai Lios, nee betana tua bepa in eiyaawatchiaka'uta a' bit tebone. Inika'a intoko aapo tua lauti a' ya'ane. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tua in nake'um, jaibu nee ka binwaa, chuubaa jiba inim emo mak annee. Eme'e nee jariune, taa jiba jume' juriommeu in jiaka'a benasi i'an ket ne emou a' teuwaa, jum in annee'u eme'e ka a aman yajine. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Inika'a bemela nesaurita enchim bo'o joorianee'uta nee enchim tejwaa, emo nasuk tua enchim emo nak ta'aanee'uta. Jiba junuen in enchim nak ta'a'a benasia, eme'e ket inien a emo naas nak ta'aane. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Jiba inien enchim naas emo nakeo, si'ime ju'u inim yoemra ju'uneene, nee betana kateka enchim nemak ea'ut. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ju'u Simoo Peeo' teame, Jesujtau: ―Achai, jakunsa empo siime ―ti au nattemaek. Ju'u Jesus intok: ―Jum in weenee'u, i'an empo ka a aman weene. Taa chukula empo a aman neu yebijne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Junak ju'u Peeo: ―Achai, jaisaaka i'an nee ka a emak weene. Kia ee betchi'bo mukneeka juni'i, kaachin ne jiia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ju'u Jesus iniau: ―Jaisa tua empo nee betchi'bo muknee ja'ani. Iniat nee sualne, totoi o'owiata kee a' kuseo, empo, temaiwaka, bajisi ka emo nee ta'a'ati jiune ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Ka eme'e a' juiwaka, unnaa jachin emo eetuane. Achai Liojtat intok net juni'i ket eme'e yoem'eene. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Aman jum in yo'owata jiapsa'u, tua juebena jume' ama jiapsinaa'um. Ka junuen a' lutu'uriatuko, ineponee jaibu nee enchim tejwaasu ean. Junuen san nee inepo aman sika intok aman enchim jiapsinee'um nee enchim tu'uteriane. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Intok chukula inepo aman sikaa, intok aman enchim jiapsine'po a' tu'utesuko, ineponee juchi a'abo nottinee junuen am bichaa enchim weiyaa betchi'bo. Junuen enchim, jum in jiapsa'u, jiba junama'a enchim anne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Intok eme'e ju'unea jakun bicha in sime'ut, intok jachin aman yaajiwa'ut eme'e ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ju'u seenu, Toomaj teame, aapo'iku: ―Achai, itepo che'a ka ju'unea jakun bicha em sime'ut, junuen jaisa itepo jak luula ama yaajiwaa'ut ju'uneene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ju'u Jesus, inika'a: ―Inepone ju'u bo'o, ju'u lutu'uria, intok ju'u jiapsiwame; kaabe in achaibeu weene, kaa ino betchi'ibotuko ―ti a' yoopnak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nee, eme'e ta'a'ateko, ket eme'e jiba juka' in yo'owata a' ta'aa ean intok aapo'ik inim naateka eme'e a' ta'aa. Bwe'ituk aapo'ik jiba inim eme'e a' bicha. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Junak intok ju'u Jeriipe' teame: ―Achai, juka' em yo'owa Liojta empo inim itom a' bittuanee intok iniae tua itepo yanti elne ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus inika'a: ―Empo Jeriipe, tua nee binwa ta'apo inim emomak aane, intok, jaisa empo kee nee ta'aa ja'ani. Wa'a nee inim bichame, ini'i, juka' in yo'owata bitlatune. Junak su, jaisaaka empo juka' in yo'owata nee enchim a' bittuane' betchi'bo neu nooka ―ti a' yoopnak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Jaisa empo jiba nee junen in yo'owabet ane'epo intok aapo'ik net a' ane'uta inien ka a' suale ja'ani. Juka' in emou teuwaa'uta, inepo kannee in ea'po aman a' teuwaa. Ju'u in yo'owa jiba aapo net jiapsame, jiba aapo'ik betana juka' machilaa, a jita a' joa'uta, a' bit tebo. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Eme'e, ju'u in yo'owabet in ane'uta, intok aapo'ik net a' ane'uta, nee betana inien a' sualne. Oo ka inien nee sualekai, kia ju'u in joa'u betchi'bo juni'i, nee sualne. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Lutu'uriapo nee inen emou jiia, wa'a nee sual ta'aame, ini'i ketchia juka' machilaa in joa'uta a' joone. Intok ini'i che'a bepa suum watchisi machik joone. Bwe'ituk inepo i'an nee ju'u in yo'owata jiapsa'u nee siime. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Intok eme'e, Liojtau bicha, jita juni'i, net yoem'eaka enchim a'awa'uta, enchim nee a' bittuane. Junuen juka' a' yoemiawata a' joa'ue, juka' a' yo'owawata che'a bepa tua yo'orisi a' machiaka'uta a' bit tebone' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kia jita juni'i, net yoem'eaka, Liojtau bicha enchim a'awa'uta, inponee enchim a' bittuane ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Lutu'uriapo eme'e nee nak ta'a'ateko, in enchim aet nesaweka in teuwaaka'uta, nee aet jikkajine. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Inepo intok nee, ju'u in yo'owabeu nokne, aapo'ik betana waka'a enchim aniaka emomak tuneemta aapo'ik emou a' bittuane' betchi'bo. Junuen inika'a, jiba emomak a' anne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ini'i ju'u Liojta tu'u jiapsi, nee betana lutu'uriat yee ju'uneetuame. Wame'e inim jiba ka Liojta ta'aaka jiapsame, inime'e ka a' mabeta. Bwe'ituk inime'e ka aet emo temaikai. Intok kia ka a' ta'aa juni'i. Taa eme'e jaibu aet ju'unea. Bwe'ituk ini'i, aapo inim emomak aane, intok jiba emot tawane. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kannee inim kia beja enchim to'o simne. Juchi nee a'abo nottine, junuen inim emomak an betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Inim taewaim ka bu'uuka be'ee, inim ju'u yoemra, ka intok nee bitneekai. Taa eme'e juchi nee bitne. Eme'e jiapsine, jiba in jiapsa' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Junaka'a taewaita yumako, eme'e machisi ju'uneene, in yo'owabet in ane'u. Enchim intok net ane'u. Nee intok ket emot ane'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wa'a, jume' nesaurim nee betana teuwaarim, am ta'aaka intok am bo'o jooriaka jiapsame, ini'i, tua lutu'uriapo nee a' nak ta'aa'uta aet bit tebo. Ju'u intoko in yo'owa, waka'a nee nak ta'aamta, aapo inika'a a' nakne. Intok inepo juni'i ketchia nee inika'a nakne. Intok aapo'ikumak in ane'uta, nee machisi a' ju'uneiyaatuane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Senu Juuras, ka ju'u Ijkarioote' teame: ―Achai, jaisaaka empo itomak em ane'uta, itom jiba a' ju'uneiyaatuane, intok ka ket junuen ju'u wate yoemra inim jiapsammewi ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ju'u Jesus iniau: ―Wa'a nee nak ta'aame, ini'i, ju'u in teuwaarit nee nok jikkajine. Ju'u intok in yo'owa aapo'ik nakne. Junak intok ju'u in yo'owa intok inepo, itepo nau iniau yajaka, aapo'ikut te jiapsine. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wa'a ka nee nak ta'aame, ini'i ju'u in teuwaarit ka a' nok jikkajaka jiapsa. Ju'u Liojta betana nok lutu'uria in teuwaaka enchim jikkaja'u, ini'i ka nee betana weye. Ini'i ju'u in yo'owa a'abo nee bittuakamta betana weye. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Si'imeta inika'a nee emou teuwaa, ketun inim emomak anekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Taa ju'u Liojta tu'u jiapsiwa juka' in yo'owata nee betchi'bo in we'ea'po emou a' bittuanee'uta, enchim aniaka intok junuen enchim jiapsi jo'ane. Ini'i si'imekut a enchim ju'uneetuanee intok si'imeta waka'a in enchim majti, au enchim waatituane. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Inim inepo yuma'isi yanti elwamta emo tana waataka nee siime. Inika'a alleerita ka jain eewamta nee betana a' mabetne. Taa inepone, ka jume' inim, ka Liojta ta'aaka jiapsame, yanti elwamta ka binwatunemta inime'e yeteu bicha a' waata'a benasi, nee emot a' autua. Ka eme'e jain eene. Intok kia ka majjaunee juni'i. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Eme'e, in simne'eti jiaka, intok ket a'abo notteka, juchi in emomak anne'eti jiaka in nokaka'uta, jaibu eme'e nee jikkajila. Eme'e lutu'uriapo nee nak ta'a'ateko, eme'e alle ean junuen in yo'owabeu bicha in sime'epo ju'uneakai. Bwe'ituk aapo che'a juni'i bepa eiyaawatchisi katek. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Inika'a inepo, kee yeu a' yumaao nee emou a' teuwaa, junuen inika'a a' chupeeo, junak enchim nee sualne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Kaita intok nee tua emomak etejonee i'ani. Bwe'ituk ju'u bebeje'eri, ju'u, jume' inim jiapsame saweme, a'abo weye. Ini'i ka nee bepa utte'ak, o'oben. ");
INSERT INTO yaqNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Utte'a inien a' chupnee'u, junuen jume' inim jiapsame, juka' in yo'owata in a' nak ta'aa'po bem ju'uneene' betchi'bo. Intok juka' aapo'ik nee tejwaaka nee aet a' saweka'uta, junaka'a in a' joa'ut, bem ju'uneene' betchi'bo. Japte'em bu, inim omot bicha te katne. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Inepo nee juna'a, inim inepolaa jiba takai, ju'u tu'i pa'asi ouwotau a tammachiatume, ju'u intok in yo'owa junuen, ju'u inika'a ouwota a' suuamta benakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Aapo, nee betana kia wepu'ulaika juni'i, jume' in nassa'akariam betana, ka tatakame, am chuk chukta. Taa aapo, jume' nassa'akariam tatakame, inime'e bicha intok am tutu'ute junuen che'a juni'i yu'in bem takane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Eme'e, jiba ju'u nok lutu'uriae, in enchim majtaka'ue, eme'e jaibu nassa'akariam tu'uteim taka'abebena. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ka eme'e nee koptaika, nemak eaka jiapsine. Jiba in enchim ka koptaka in enchim eiya'a benasia. Senu nassa'akaria, kia aapolaika, kaachin ini'i a takane, ini'i junuen, ju'u ouwou ka cha'akai. Eme'e juni'i ketchia, kaachin Liojta ea'po aman tu'ik joaka a jiapsine, eme'e nee koptaika ka nemak eaka jiapsa'ateko. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Inepo nee juna'a, ju'u pa'asi ouwopo ta'eewame, eme'e intok jume' nassa'akariam benakai. Ju'u nemak eaka jiapsame, iniamak intok inepo aamak tukai, ini'i, Liojta ea'po aman, yuma'isi tu'ik joaka jiapsine. Bwe'ituk eme'e ka net eaka jiapsakai, tua kaitau eme'e yuma'ane. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wa'a nee koptaka intok ka nemak eaka jiapsame, ini'i pa'akun jimmaa tune. Intok jume' ka tu'i nassa'akariam chuktim benaka, wakeka intok tajipo am taya'awaka'abenane. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Eme'e ka nee koptaka intok nemak eaka jiapsa'ateko, intok juka' in enchim majtaka'uta ka koptakai, eme'e Liojtau bicha juka' enchim waata'uta a' a'aune, intok eme'e a' maktune. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ju'u in yo'owa eiyaawaka yo'orinaa, inim aapo'ik ea'po aman yuma'ik tu'ik joaka enchim jipasao. Intok junuen eme'e iniae, tua lutu'uriapo nee betana kateka enchim majtimtuka'po ta'eenaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Inepo ne ala enchim nak ta'aa, jiba juka' in yo'owa Liojta aapo'ik nee a' nak ta'a'a benasia. Junuen san, eme'e nemak eaka jiapsine, enchim in nak ta'aa'uta jiba enchim a' bitne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Eme'e intoko juka' nookta, in nesaurita eme'e a' nok jikkaja'ateko, inien in yee nake'uta, jiba eme'e a' bitne. Jiba junuen juka' in yo'owata a' nesaurim in am nok jikkaja'a benasia, intok junuen aapo'ik nee a' nak ta'aa'uta jiba in a' bicha'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Inepo nee inien emou nooka, junuen, net a' bichaka nemak enchim alleene' betchi'bo. Intok inien tua yuma'isi alleewamta eme'e bitne. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ju'u nooki in nesauri, ini'i juna'a, enchim naas emo nak ta'aanee'u, in enchim nak ta'a'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tua ju'u senuk a yee a' nak ta'aa'u, ini'i, senuk aapo'ik jiapsiwata, jume' a' nak ta'aa'um betchi'bo a' nenkinee'u juna'atune. Inia bepa senuk che'a yee a' nak ta'aanee'u, kaita. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jiba eme'e in jalla'im tune, eme'e junuen juka' in teuwaari nesauta a' bo'o jooria'ateko. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ineponee i'an, kannee intok inepo, nee tekokame ti nee enchim ta'aane. Bwe'ituk juka' tekokamta, inika'a a' tekowata joa'ut kaachin a aet a' ju'uneene' betchi'bo. Ala inepone, in jalla'im ti nee enchim ta'aane. Bwe'ituk inepo, si'imeta waka'a in yo'owa betana in tejwaarita, ineponee emou a' teuwaalaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ka eme'e juname'e, nee yeu pu'akame, ala inepo nee enchim yeu pu'ari, intok ineponee emou noklaa, inim Liojta ea'po aman jiapsaka, junuen yoemratau sajaka, Liojta betana lutu'uriata enchim ameu nokne' betchi'bo. Intok inia enchim joonee'u betana weyeme, ka lu'utekai. Intok inien, ju'u achai Lios, iniat net yoem'eaka, si'imeta waka'a enchim au bicha a'awa'uta, aapo enchim a' bittuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ini'isan juna'a ju'u in enchim aet saweka'u, enchim naas emo nak ta'aanee'uta. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Eme'e inim yoemrata betana i'an omtawakai, inia betana ju'uneene, che'a bat nee juni su junuen am omtaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Enchim inien jume' inim ka Liojta ta'aaka jiapsame benasi enchim jiapsao, inime'e inim jiapsame, bempo'im naas emo eiya'a benasia enchim eiyaa ean. Taa inepo inim bempo'im nasuk ne enchim yeu pu'ala. Intok jiba inia betchi'bo juname'e enchim omta. Bwe'ituk junuen eme'e ka intok amemak eaka jiapsa. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","In emou teuwaaka'u eme'e waatinee: “Kaabe ju'u tekokame, a' tekowa bepa che'a eiyaatune”, ti jiakai. Juname'e neu suasukai, ketchia enchim juni'i, inime'e omtaka emou suuane. Intok inime'e, juka' in am majtaka'uta, a' nok jikkajisukai, ket inime'e, juka' enchim am majta'ut enchim jikkajine. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Si'imeta inika'a bempo emou ya'ane, taa jiba enchim nemak ea' betchi'bo. Bwe'ituk bempo, juka' a'abo nee bittuakamta ka a' ta'aakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Bempo tua kaita ka tu'ika amet auka'a benasi bit'eewan, nee ka inim yepsaka intok ameu nokako. Taa i'an inime'e, Liojta bichapo, juka' ka tu'ik bem ya'ari betana, kaitat jiawite machi. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Bwe'ituk ju'u nee omtame, ini'i ket juka' in yo'owata omta. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Inime'e, tua kaita ka tu'ika amet auka'a benasia bit'eewan, ame nasuk juka'a, inim jabeta juni'i kee jee a' yaaka, inika'a ka nee a' yaako. Taa inime'e inika'a jaibu a' bitchuk. Intok a' bitlataka juni'i, inime'e nee omta, intok ket junuen, juka' in yo'owata omta. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Taa ini'i inien weye, bwe'ituk utte'a inika'a nokita, bem nesauri ji'ojteimpo ji'ojteita a' chupne'po: “Inime'e, tua kaita betchi'bo nee omtak”, ti ji'ojteita. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Taa chukula, juka' yee aniaka intok yee jiapsi joamta a'abo a' yepsako, Liojta tu'u jiapsi, aapo'ik betana lutu'uriat yee ju'uneetuaneeme, ju'u in yo'owa betana in emou bittuanee'u, aapo, nee betana ju'u lutu'uriat yee ju'uneetuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Intok eme'e juni'i ketchia, inim nee betana juka' lutu'uriata a' teuwaane, bwe'ituk eme'e, inim tekilta in a' naateka'po naateka nemak aanek. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Inika'a weyemta nee emou teuwaa, junuen emou weenemta betana ka enchim ko'om eene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jum juriom te'opompo enchim lutu'uriaka'uta eme'e a' u'aatune. Intok kia taewai yuma'ane, junak emo betana senuk me'aakamta iniae Liojta betana tu'ik a' joa'a benasi a' eeneeo. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Inika'a ya'ane, bwe'ituk inime'e, juka' in yo'owata intok nee juni'i, kee jee itom ta'aakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Inika'a ne emou teuwaa, junuen, junak inika'a taewaita yumako, inia betana jaibu in emou noklatuka'u enchim au waatine' betchi'bo. ’Inika'a nee ka sep naatelaapo naateka emou a' teuwaak, inepo emomak in aneka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Taa i'an inepo nee siime, junuen aman ju'u a'abo nee bittuakamtamak juchi an betchi'bo. Emo betana intok tua kaabe neu nattemae jakun bichaa in sime'ut. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ala eme'e, enchim sioka'u tua emot aayuk inika'a weyemta in emou a' teuwaaka' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Taa inika'a lutu'uriataka nee emou a' teuwaa, emo betchi'bo che'a juni'i tu'isi yeu weama in simnee'u. Bwe'ituk junuen nee ka simeo, ju'u, enchim aniaka intok enchim jiapsi joame, aapo ka emou yebijne. Taa junuen inepo aman siiko, emou inepo nee a' bittuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Junako, ini'i yepsako, inim juka' yoemrata, ka tu'ik a' ya'ariaka'u betana, inika'a inia betana au a' temaituane. Intok Liojta betana inim tu'isi yee a' jiapsi i'a'u, inika'a a' ayuka'po. Intok bempo'im, Liojta betana am ya'uraa bittuanaa'ut emo am temaituane. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ini'i yoemra, Liojta bichapo ka tu'ik ya'ari, bempo'im ka nee sual ta'a' betchi'bo. Aapo iniat am ju'uneetuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Intok inime'e, inim Liojta tu'isi yee jiapsi i'a'uta inika'a a' ayuka'po am mammatetuane. Bwe'ituk i'an inepo ju'u in yo'owata ane'u bicha ne siime. Intok eme'e inim ka intok nee bitne. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Intok inim Liojta yee ya'uraa bittuanee'uta a' ju'uneiyaane. Bwe'ituk ju'u, juka' inim yoemrata koba'ika a' saweme, ini'i jaibu ka tu'isi au a' chupnee'uta au na'ikiari. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ketun tua juebenaka in emou etejo'ea'u aayuk o'oben, taa iniat eme'e i'an ka a aet ju'une ean. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Chukula ju'u Liojta tu'u jiapsi, lutu'uriat yee ju'uneetuame emou yepsako, ini'i si'ime ju'u nee betana lutu'uria weyemtat enchim aet ju'uneetuane. Bwe'ituk, ka ini'i kia a' ea'po aman a' tu'uree'ut enchim ju'uneetuaka enchim noktuane, ala ini'i, si'imeta waka'a Liojta betana a' jikkaja'ut enchim ju'uneetuane. Intok jiba aapo ket ju'u chukula yeu weenemtat enchim ju'uneetuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ini'i, aapo in yo'orinaa'uta jiba waatakai, yee aniane. Bwe'ituk aapo juka' nee betana lutu'uria weyemta, ne tana a' mabetaka, enchim a' ju'uneiyaatuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Si'ime ju'u, juka' in yo'owata jipue'uta, ket inepo a' atteak. Inia betchi'bo san inepo, juka' Liojta tu'u jiapsi, juka' nee betana weyemta ne tana a' mabetaka, intok inika'a, ineponee aapo'ik enchim aet a' ju'uneiyaatuane'eti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Tua ka bu'uuka be'ee, inim ka intok enchim nee bitneeo. Taa aet chukula, sep jeela, eme'e juchi nee bitne. Bwe'ituk inepo nee, ju'u in yo'owata jiapsa'u bicha nee siime. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Junako jume' a' majtim betana waate naas nau nattemaek: ―Aapo: “Tua ka bu'uuka be'ee, itom ka intok a' bitneeo, intok aet chukula, sep jeela itom juchi a' bitne'e”, ti jiakai. Intok, “Inika'a jiba aapo'ik yo'owata ane'u bicha a' sime'u betchi'bo”, ti jiakai. Jaisa ini'i jiubaeka inika'a teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Jitasa iniae aapo teuwaa: “Ka bu'uuka be'ee”, ti a' jia'ue. Katte aet ju'unea jitat a' noka'ut ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus inimmet, bem au nattemaebae'po amet mammateka: ―Ineponee emou inim: “Ka bu'uuka be'ee, enchim ka intok nee bitnee'u intok chukula sep jeela juchi enchim nee bitnee'u”, ti jiiak. Jaisa eme'e inia betana junuen nau nattemae ja'ani ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Lutu'uriapo ne inen emou jiia, chukula eme'e bwanakai intok tua siokne. Taa ju'u inim yoemra inia betana tua alleene. Taa inien eme'e tua ka alleakai juni'i, chukula ju'u enchim sioksi ea'u, ini'i, seej chukti emo betchi'bo tua alleewame tuneekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jamut seenu, usibae'eteko, junak ini'i ka alleene, taewai, jiokot au a' bitnee'uta a' yumaka' betchi'bo. Taa ini'i, chukula, juka' ili usita yeu yebijsuko, ini'i, jiokot au a' bichaka'u ka au waatine, tua alleeakai, inim ili usita yeu yoemtuka'po ju'uneakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ket jiba inieni i'an eme'e ka enchim allea'u emot aayuk. Taa chukula juchi nee enchim bitnee intok junako eme'e tua yuma'isi enchim allea'u emot aune. Ini'i alleewame junuen, ka intok lu'utineekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Junako inika'a taewaita yumako, eme'e kaita intok neu bicha a' a'aune. Lutu'uriapo ne inen emou jiia, ju'u in yo'owa, si'imeta juka' iniat net yoem'eaka, au bicha enchim a'awa'uta, aapo enchim a' bittuane. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Eme'e i'an tajtia, ka inien Liojtau enchim a'awa'uta iniat net eaka a' jooa. Inien eme'e aune, intok enchim a'awa'uta eme'e a' bitne, junuen tua yuma'isi enchim alleene' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Si'ime inika weyemta inepo nee jita ta'abwiku a' tammachiaka emou a' teuwaalaa. Taa chukula taewai yuma'ane, junako ka intok inien jita ta'abwiku a' tammachiaka in emou nokneeo. Ala inepo junak, in yo'owa betana weyemta machisi ne emou a' teuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Junako junaka'a taewaita yumako, eme'e juka' enchim waata'uta, junaet net eaka, Liojtau bicha noknee. Ineponee intok jaibu junaet in yo'owabeu ka enchim nokriane. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bwe'ituk jiba aapo ju'u in yo'owa enchim nak ta'aa, jiba nee enchim nak ta'aaka intok aapo'ik Liojta betana in a'abo yepsaka'po junuen enchim a' suale' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Lutu'uria, aman ju'u in yo'owata jiapsa'u, aapo'ik betana ne yeu siika inim anbaekai. Taa i'ani inepo nee inim yeu simnee, juchi ju'u aman in yo'owa mak anbaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Junako jume' a' majtim: ―I'an ala empo tua ju'unakkiachisi itou nooka, intok ka jita ta'abwiku a' tammachiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","I'ani itepo ju'unea, si'imekut tu'isi em ju'unea'u, intok ka utte'a inia betana eu nattemainaa'u. Inia betchi'bo, Liojta betana a'abo em yepsaka'po itepo a' suale ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Junak ju'u Jesus inimmeu: ―Junuen san, inika'a jaisa eme'e lutu'uriapo a' suale ja'ani ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bwe'ituk taewai yuuma, intok jiba i'an juna'a, junak enchim we'epulaim, enchim atteau bicha enchim na'ikimtuka intok eme'e nee inepolaik to'o saka'aneeo. Taa kannee inepolai, bwe'ituk ju'u in yo'owa nemak aane. ");
INSERT INTO yaqNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Si'imeta inika'a nee emou teuwaa junuen, net eaka, yanti elaka enchim jiapsine' betchi'bo. Inim bwiapo utte'a, jiokot enchim emo bitnee'u. Taa eme'e ka jain eene, bwe'ituk inepo, jume' inim nee beje'eka aneme, inepo nee am koba'i. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chukula inika'a teuwaasukai, Jesus teekau jikau bitchuka intok: ―In yo'owa, taewai yuma'asuk ti jiiak. Juka' em yoemiata, che'a bepa a' yo'orinaa'uta aet bit tebone, junuen juka' em yoemiata, che'a bepa em yo'orinaa'uta et a' bit tebone' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bwe'ituk jiba empo, juka' em yoemiata, si'ime yoemra inim jiapsame bepa a' nesaunee'u, utte'ata aet autualaa, junuen si'ime jume' au bicha em yeu pu'aka'um, jiba yuu jiapsiwamta aapo'ik am bittuane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ju'u jiba yuu jiapsiwamta bitwame intok, ini'i, enchi juka' wepu'ulaika tua lutu'uriapo Liojta, intok Jesukrijtota, juka' a'abo em bittuaka'uta a' ta'eewame, juna'a. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ineponee inim bwiapo enchi yo'oriwaka aet enchi eiyaanaa'uta nee a' ya'ari. Intok inepo nee a' chupa'i juka' em nee a' ya'ane'eti jiaka em nee tejwaaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Junuen san achai, bat naataka, aniata kee yeu a' machiao naateka, che'a bepa yo'oriwaka emak in aneka'a benasia, i'ani, jiba junaen nee emak jiapsituane. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Jume' inim bwiapo jiapsame betana em neu bicha yeu pu'aka'um, inepo nee, em jabetuka'uta ne machisi am ju'uneetualaa. Inime'e, empo am atteaka intok i'an empo neu bicha am na'ikialaa. Intok inime'e, ee betana juka' nok lutu'uriata, a' nok jikkajilam. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","I'an bempo ju'unea, junuen si'imeta juka' em nee aet aniaka, in ya'ari, ee betana a' weye'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bwe'ituk inepo nee ee betana juka' nokta em nee tejwaaka'uta, junaka'a nee am majtalaa. Bempo intok a' mabetlaa. Intok inime'e lutu'uriapo ee betana inim in yepsaka'uta, a' ju'uneiyaalaa. Intok em nee a'abo bittuaka'uta a' suallaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Inime'e, inepo eu bicha nokria. Kannee jume' wate inim bwiapo jiapsame nokria. Ala jume' neu bicha em yeu pu'arim nee nokria bwe'ituk empo am atteak. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Si'imeta juka' in attea, empo nemak a' atteak. Intok si'imeta juka' em attea, inepo emak a' atteak. Intok iniat eiyaawaka in yo'orinaa'u neu aayuk. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Ineponee ka nee intok inim bwiapo tawane. Taa bempo inim tawane. Inepo nee intok inim yeu siime aman emak an betchi'bo. Empo in yo'owa, wepulsi tu'ika et ayukame, jume' neu bicha em yeu pu'aka'um, jiba ee betchi'bo am aniaka am suuane, junuen inime'e yuma'isi nau eaka bem jiapsine' betchi'bo, jiba enchi nemak itom nau eaka jiapsa'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Junako, inim bwiapo inepo amemak anekai, jume' neu bicha em yeu pu'aka'um, inepo ee betana em utte'ae aniawaka nee am suuaka, ka tu'ik betana nee am aniasuk. Inime'e betana tua kaabe, jitat ta'abwisi eaka, nee betana au na'ikimtek. Taa kia wa'a jaibu bebeje'eritau au nenkilame jiba, junuen aapo'ik betana Liojta nok lutu'uriapo ji'ojteita a' chupne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’I'an nee inepo aman em ane'u bicha nee siime. Taa nee ketun inim bwiapo anekai inika'a nee teuwaa, junuen bempo'im inien tua in allea'uta, inika'a tua yuma'isi bem nemak a' bitne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Bempo'im inime'e inepo juka' ee betana nok lutu'uriata nee am majtalaa. Taa jume' inim, ka emak eaka jiapsame, inime'e omta. Bwe'ituk bempo ka jume' inim jiapsammak eaka jiapsa, jiba nee juni'i ka junamemak eaka in jiapsa'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Inepo, kannee inim yeu em am nuk simne' betchi'bo ne eu bicha am nokria. Ala bebeje'erita betana em am jinne'une' betchi'bo am nokriakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Junuen, nee ka jume' inim jiapsammak eaka in jiapsa'a benasia, bempo juni'i ket ka junamemak eaka jiapsa. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Inime'e ju'u em nok lutu'uriat bempo'im ju'uneetuaka, iniae, wepulsi ee betchi'bo bem jiapsinee'ut am ania. Ju'u ee betana nooki juna'a ju'u lutu'uria. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jiba em jume' inim aniapo jiapsammeu, em nee bittuaka'a benasia, junuen ket inepo, bempo'im nee jume' inim jiapsammeu am bittualaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Intok inepo jiba bempo'im betchi'bo nee wepulsi em nee yaa i'a'uta a' ya'abaeka nee eu ino su'u toja junuen bempo'im ket, tua lutu'uriapo, inien wepulsi eu emo su'u tojine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Taa nee ka bempo'im betchi'bo jiba ne eu bicha nooka, taa ketchia wame'e che'a chukula, jiba bempo'im nee betana ameu noknee'ue, nee sualneeme betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Si'imem inime'e yuma'isi nau eaka bem jiapsine' betchi'bo, ne eu nooka. In yo'owa, jiba enchi nemak itom nau eaka jiapsa'a benasia, bempo'im itomak wepu'ulai benasi bem jiapsine' betchi'bo. Inien bem jiapsa' betchi'bo, jume' watem inim jiapsame, em a'abo nee bittuaka'uta a' sualne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Inepo inime'e, jiba junaka'a tua eiyaawatchika weyemta, ee betana in mabetri, ineponee am bittualaa. Junuen, wepulsi nau eaka bem jiapsine' betchi'bo, enchi nemak itom nau eaka jiapsa'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Inepo, ka bittaka ne amet jiapsakai, empo intok ket net jiapsakai. Junuen beja inime'e tua yuma'isi bem nau eaka jiapsine' betchi'bo. Intok junuen jiba inia betchi'bo ju'u inim yoemra, em nee a'abo bittuaka'uta, a bem a' mammatene' betchi'bo. Intok ket tua em nee nake'e benasia, em am nake'uta. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’In yo'owa, inime'e, empo neu bicha am na'ikiari. Intok inime'e, inepo jiba jum in annee'u nemak am an i'a. Junuen inime'e aman, juka' che'a bepa eiyaawatchika ujyoriata em net autuarita, bem a' bitne' betchi'bo. Bwe'ituk empo, inim aniata kee a' ju'unaktewao naateka, empo nee nak ta'aalaa. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","In yo'owa, wepulsi a' lutu'uriatuka'po aman yee ya'uraa bittuame, eu nee nooka. Jume' inim bwiapo jiapsame ka enchi ta'aa. Taa inepo nee, ala enchi ta'aa. Intok inime'e in majtim, a'abo em nee bittuaka'ut ju'unea. ");
INSERT INTO yaqNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Inime'e, inepo tua em jabetuka'ut, nee machisi et am ju'uneetualaa. Intok ketun naa buustia nee inim enchi ju'uneiyaa tebone. Junuen em nee nak ta'a'a benasia, bempo'im ket a emo nak ta'aane' betchi'bo. Intok ket junuen jiba nee juni'i, ka bittaka in amet jiapsine' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chukula aapo inika'a teuwaasukai, ju'u Jesus jume' a' majtimmak yeu siika, junuen jakia Setroon teamta beas anbaekai. Junama'a wajpo juyam tatakaka echitukan. Inim Jesus a' majtimmak ama yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ket ju'u Juuraj teame, ju'u yeu a' bwijneeme, aapo junama'a juyam echipo ta'aan. Bwe'ituk ju'u Jesus, jume' a' majtimmake juebenasi junama a'anen. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Junuen san ju'u Juuraj teame junama yepsak, juebena sontaaom weiyaakai, intok waate, jume' te'opopo yee suuatuawammake. Inime'e, jume' te'opopo tekiakammeu yo'owem betana intok jume' paiseeom betana aman bittuarimtakai. Inime'e, tettebem kukuche'eka intok mampo tachiriam weiyaaka kaaten. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Taa ju'u Jesus, si'imeta juka' au yeu weenemta betana jaibu ju'uneakai, yeu sikaa, intok inimmeu: ―Jabetasa eme'e jaiwa ―ti ameu nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bempo: ―Juka' Jesujta, Nasaret tea'po jometa ―ti a' yoopnak. Ju'u Jesus intok: ―Ineponee juna'a ―ti ameu jiiak. Ju'u Juuraj teame, ju'u aapo'ik yeu bwisekame ket inime'emak ama weaman. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Juka' Jesujta: “Ineponee juna'a”, ti ameu a' jiako, inime'e amau rukteka intok bwiau ko'om to'otek. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Junak intok ju'u Jesus juchi: ―Jabetasa eme'e jaiwa ―ti ameu nattemaek. Bempo intoko: ―Juka' Jesujta, Nasaret tea'po jometa ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Junak ju'u Jesus: ―Jaibu su ne enchim tejwaasuk in juna'atuka'po. Eme'e nee jaiwa'ateko, inime'e nemak rejteme am saka'atuane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ini'i inien tuk, jiba aapo'ik Jesujta, ju'ubwa jeela: “Jume'e, in yo'owata neu bicha yeu a' pu'aka'um betana, tua kaabe, jitat ta'abwisi eaka, nee betana au na'ikimtek”, ti a' teuwaaka'uta, junuen a' chupne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Junak ju'u Simoo Peeo'o teame, ini'i, tebem sisi'iwook kuche'ekame, yeu am wikeka intok senuk, Malko' teaka, ju'u te'opopo tekiakammeu yo'ota sawe'uta, inika'a batatana naka chukti a' beebak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Taa Jesus, ju'u Peotau: ―Jume' kuchi'im, em yeu am wikeka'po am ketcha. Inien, juka' in yo'owata, jiokot nee ino a' bit i'ao utte'atune, inien tua jiokot in ino bitnee'u ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Junak jume' sontaaom yeu pu'arim, ju'u ameu weyekamtamake, intok jume' te'opopo yee suuatuawame, inime'e, Jesujta bwiseka intok a' sumaka, ");
INSERT INTO yaqNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","chukula ket, bempo che'a bat ju'u Anaj teamta kariu a' tojak. Juka' Anaj teamta, ju'u Kaipaaj teame a' ase'ebwakan. Ini'i ju'u junae wasuktiat ama te'opopo tekiakammeu che'a yo'otuka'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ini'i Kaipaaj teame jiba juna'atukan, ju'u juriommeu: “Si'ime jurio yoemrata betchi'bo, wepu'ulaik a' muknee'po aman, bempo'im betchi'bo che'a a' tu'inee'uta”, ti a' teuwaakame. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoo Peeo' teame intok senu Jesujta majti, inime'e Jesujtat cha'aka kaaten. Ini'i senu Jesujta majti, junama'a te'opopo tekiakammeu yo'ota betana ta'eewan. Junuen san ini'i, Jesujta mak junama'a yo'ota kariu bicha, jitae bat kora ya'ariu aman kibakek. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Taa ju'u Peeo, junama'a aman kikkimuwa'po, pa'aria tana taawak. Inien san ju'u senu majti, ju'u te'opopo tekiakammeu yo'ota betana ta'eewame, ini'i yeu sika intok juka' jamutta, aman kikkimuwa'po yee suuamta, a' tejwaaka, juka' Peota aman kibachak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Junak ju'u jamut, aman kikkimuwa'po a' suuatuawame, Peotau: ―Jaisa empo ka juna'a ketchia, inia o'outa betana senu a' majti ja'ani ―ti au nattemaek. Ju'u Peeo intok: ―E'e, ka inepo juna'a ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Junama'a sebekai, jume' junama'a jitaa suuame, intok jume' tekoka ama sawame, nayaka, oubammeu ja'abweka sukawen. Ju'u Peeo ket junama'a amemak oubammeu weyeka sukawen. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ju'u te'opopo tekiakammeu che'a yo'owe, Jesujtau nattemai taitek, jabem a' majtimtuka'ummet intok aapo'ik juka' junen yee a' majta'u betana. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iniau ju'u Jesus: ―Inepo nee inim si'imem ane'ebichapo yeteu nonoksuk. Intok jum juriom te'opompo, intok inim bwe'u te'opopo, si'ime jume' juriom nau emo totoja'po jiba aneka nee yee majtasuk. Junuen san kaita nee etbwa teuwaalaa, ");
INSERT INTO yaqNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","jaisaaka empo neu su nattemae. Jume' nee jikkajilammeu nattemainee intok bempo ela'po a' teuwaanee juka' in am majtalatuka'uta. Bempo tu'isi ju'unea juka' in ameu noklatuka'uta ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Junak Jesujta inien jiako, junama te'opopo yee suuame betana, senu ama aneme, pujbat a' chochonaka intok: ―Kat ju'u te'opopo tekiakammeu che'a yo'otau junuen jiia ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ju'u Jesus inika'a inen yoopnak: ―Ka tu'ik nee teuwaariako, junae betana a' teuwaane. Taa juka' in teuwaarita a' tu'ireako, jaisaaka empo nee chona ―ti au jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Junak ju'u Anaas, aapo'ik suma'ita, Kaipaaj teamtau, ju'u te'opopo tekiakammeu che'a yo'otau a' bittuak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ju'u Peeo ketun junama'a tajimmeu weeka sukawen. Iniau intok: ―Jaisa empo ka juna'a, ju'u inia o'outa betana majti ja'ani ―ti au jiuwak. Peeo intok: ―E'e, ka inepo juna'a ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Junak intok seenu, juka' te'opopo tekiakammeu che'a yo'ota tekokame, ini'i ju'u seenu, Peota naka chukti a' bebaka'uta a' wawaekame, aapo Peotau: ―Jaisa nee ka enchi jum juya etripo aamak bichak ja'ani ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ju'u Peeo, juchi ka au a' ta'aa ti jiaka nookak. Junama'a intok sep, totoi o'owia kukussuk. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Junak intok ju'u Jesus, Kaipaaj teamta kari a' kateka'a betana, aman ju'u kobanaaota bwe'u kariu nu'upawak. Junama'a jaibu matchun. Jume' juriom intok junaman bwe'u kariu ka aman kiimuk. Inime'e, Liojta junuen bem a' yo'oree'ut, junuen ayuka Liojta bichapo ka tu'ik emo ya'a machiakai. Intok junuen, Liojta yo'ori betchi'bo, kupteo, bwala jissobata bem bwa'ee'uta, ka a emo a' bwa'ane'eti eakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Inia betchi'bo ju'u kobanao Pilaato' teame, pa'akun yeu siika junuen ameu nokbaekai. Intok aapo inimmeu: ―Jitat sa eme'e inika'a o'outa a' na'atejo ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bempo, inika'a: ―Ka tu'ik ka a' ya'ariako, itepo ka eu a' toji ean ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Junak ju'u Pilaato: ―Eme'e a' nuk sajaka intok jiba enchim jachin nesawe'po aman a' ya'uraa bittuane ―ti ameu jiiak. Jume' juriom intok: ―Taa itepo jume' juriom, ka iniau lutu'uriak, senuk a' me'etunee'ut itom aet nesaune' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Junuen chupuk ju'u, aapo'ik Jesujta, tua jachin weyeka a' muknee'u betana a' teuwaariaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilaato, jum bwe'u kariu wajiwa juchi aman kibakeka, Jesujtau chaai teboka intok: ―Jaisa empo juna'a ja'ani, ju'u, jurio yoemratau che'a yo'o ya'ari ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus intok iniau: ―Inika'a inia betana nattemaekai, jaisa empo kia emo a' ju'uneiyaaka a' nattemae ja'ani, inika'a inim in che'a yo'o ya'ari tuka'u, oo watem betana a' jikkajilatakai ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaato ju'u kobanaao a' yoopnak: ―Ineponee ka jurio. Ju'u inim ele benasi jurio yoemra intok jume' te'opopo tekiakammeu yo'owe, inime'e junen enchi a'abo neu tojak. Jitasa empo ya'ari ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Junak ju'u Jesus: ―Che'a yo'otaka in nesaunee'u, ka i'an inim juna'a. Nee junuen inim nesaweo, junak jume' nemak eaka rejteme, nassua ean, junuen, juriommeu ka in su'u tojina' betchi'bo. Taa che'a yo'otaka in nesawe'u, ka i'an inim juna'a ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilaato intok: ―Junak su, jaisa empo lutu'uriapo juna'a ja'ani, ju'u che'a yo'o ya'ari ―ti au nattemaek. Jesus inika'a: ―Ineponee juna'a ju'u che'a yo'o ya'ari, jiba em a' teuwa'a benasia. Ineponee inim yoemtuk, intok inepo juka' lutu'uriata ju'uneiyaa tebobaekai nee inim a'abo yepsak. Si'ime jume'e, juka' lutu'uriata bo'o jooriaka jiapsame, inime'e, juka' in teuwaa'uta a' jikkajine ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ju'u Pilaato aapo'iku: ―Jitasa intok juna'a, ini'i lutu'uria ―ti au jiiak. Inien au nattemaisuka ju'u Pilaato juchi yeu siika, jume' juriommeu nokbaekai. Intok junammeu: ―Kaita ka tu'ik nee inia o'outat teu machi ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Taa eme'e au joiwalataka jiba junuen a' bibicha, chikti bwala jissu'awaka pajko taewaitchi, seenuk eta'ita in emou a' su'u tottojamta. Junak su, jaisa eme'e juka' juriommeu che'a yo'o ya'arita nee a' su'u toji i'a ja'ani ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Junako si'ime juchi chaai japtek: ―Ka junuka'a su'u tojine. Ala juka' Barabaaj teamta su'u tojine ―ti jiakai. Ini'i Barabaaj teame intok jita etbwawamta tu'uren. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Junako ju'u Pilaato, juka' Jesujta, sep tua jiokot maisi a' bepsu tebok. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jume' sontaaom intok, juya wichakamta nat ko'elaa yaaka, Jesujta kobat a' yechak. Kutko sikiim intok a' supetuak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chukula inime'e, au rukteka: ―Ketchi allea, empo jurio yoemratau che'a yo'o ya'ari ―ti au jiiak. Intok inime'e, pujbat a' chonan. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Junako ju'u Pilaato juchi yeu sika intok junammeu: ―Ake'em a' bicha. Inim ne yeu a' tojilaa junuen enchim ju'unee i'akai juka' ka tu'ik, kaita in aet tettea'po ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesus intok aman yeu siika, juka' juyata wichakamta nat ko'elaisi ya'arita, kobat jipuekai intok jume' kutko sikiim supe simekai. Junak ju'u Pilaato: ―Ini'i juna'a, ju'u o'ou ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Junak jume' te'opopo tekiakammeu yo'owe intok jume' te'opopo yee suuatuawame a' bichaka: ―Kuuset a' popon tebone, kuuset a' popon tebone ―ti chaai japtek. Junak ju'u Pilaato inimmeu: ―Eme'e a' weiyaaka intok junuen kuuset a' poponnee ma. Bwe'ituk ineponee tua kaita ka tu'ik aapo'ikut tettea ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Taa inime'e juriom aapo'iku: ―Itepo te inim itom ae nesawee'uta a' jipue. Intok inia nesauripo a' jia'a benasia a' muknee'uta au chupne. Bwe'ituk ini'i, Liojta betana a' yoemiarituka'a benasi au ta'aa tebon ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Inika'a ju'u Pilaato jikkajaka, che'a juni'i majaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Aapo juchi wee'po junama bwe'u kariu bicha kibakeka intok aapo Jesujtau: ―Jakunsa empo joome ―ti au jiiak. Taa ju'u Jesus kaita a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Junak ju'u Pilaato: ―Nee empo kaita yoopnabae ja'ani. Jaisa empo ka ju'unea ja'ani, kuuset enchi popon tebo betchi'bo, intok ketchia, enchi su'u toji tebo betchi'bo juni'i, in a nesawe'u ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ju'u Jesus inika'a: ―Tua kaita empo yo'otaka em net a nesaunee'uta jipu'u ean, Liojta betana ka a' maktuko. Inia betchi'bo, wa'a, nee eu tojakame, che'a juni'i ee bepa ka tu'ik ya'ari ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jiba inim naatekai ju'u Pilaato, jatchin juni'i ayuka, Jesujta a' su'u tojibaeka ean. Taa jume' juriom: ―Inika'a empo yeu su'u tojako, juka' che'a yo'o ya'arita Sesar teamta, empo a' beje'eka annee. Inim jabetaka juni'i, aapo che'a si'imem bepa au yo'o joobaeme, ini'i juka' Sesar teamta, jum Romapo che'a yo'otaka katekamta a' beje'eka annee ―ti aet chaaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Junak ju'u Pilaato, inika'a jikkajaka, Jesujta pa'akun yeeu a' toji teboka, intok aapo, jum yo'o ya'arim yeyesa'po yejtek. Ebreo nokpo Kabaata' tea'po. Ini'i nooki, bwiapo teta chitta chibelai, ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Inimi'i jaibu senu taewai be'een, Liojta yo'ori betchi'bo bwala jissu'uawaka, pajkota weeneeo. Jaibu jumak luula yejteo. Junak ju'u Pilaato, jume' juriommeu: ―Inim aane ju'u, emou che'a yo'o ya'ari ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Taa bempo: ―Me'etune, me'etune, kuuset a' popon tebone ―ti chaaen. Ju'u Pilaato inimmeu: ―Jaisa inepo inika'a emou yo'o ya'arita kuuset a' popon tebonee ja'ani ―ti ameu nattemaek. Taa jume' te'opopo tekiakammeu yo'owe: ―Itepo kaabeta intok ta'abwik che'a itou yo'o ya'arita te a' jipue, waka'a jum bwe'u jo'ara Roma' tea'po yo'otaka katekamta jiba ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Junak ju'u Pilaato ameu a' su'u tojak junuen kuuset a' popontune' betchi'bo. Bempo intok yeu a' nuk sajak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Junuen ju'u Jesus yeu siika, juka' kuujta pu'atekai. Junuen, jum ili kawi Mukia koba' tea'u yebijneekai. Ebreo nokpo Kolkota' tea'u. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Junama'a, aapo kuuset popontuk. Intok aapo'iku mak ket woika kuusimmet jikat poponwak, aapo'ik kecha'awaka'po nau bicha, Jesujta nasuk tawaakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ju'u Pilaato, ji'ojteita kuuset bepa jikat a' popon tebok: “Jesus, Nasaret tea'po joome, juriommeu che'a yo'o ya'ari”, ti jiamta. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jume' juriom betana juebenaka inika'a ama ji'ojteita nookak. Bwe'ituk jum Jesujta kuuset a' poponwaka'po, bwe'u jo'arau ka mekkaekan. Ini'i ji'ojtei intok, ebreeo nokpo intok rieeko nokpo intok latin nokpo ji'ojteitukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Inia betchi'bo juriom betana jume' te'opopo tekiakammeu yo'owe, inime'e Pilaatotau: ―Inika'a ka junuen: “Juriommeu che'a yo'o ya'ari”, ti a' ji'ojtene. Ala empo: “Ini'i, ju'u juriommeu che'a yo'o ya'ari ti au teuwaame”, ti ji'ojtene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Taa ju'u Pilaato, inime'e: ―Ju'u in ji'ojteka'u junuen tawane ―ti am yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Chukula jume' sontaaom, Jesujta kuuset a' poponsuka, a' tajo'oriwata nu'uka intok naikisi nat a' na'ikimtek, inika'a bempo'im we'epulaim betchi'bo. Bempo ket, jume' tebe tajo'orim bepa a' jineka'um, am nu'uka. Inime'e intoko, ka jak nau am ji'ikrituka' betchi'bo, jikat ko'om tajti wepu'ulaikai, ");
INSERT INTO yaqNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","jume' sontaaom: ―Katte am siutane ―ti nau jiiak―. Ala te amet nau ja'atek tu'inee junuen jabeta amemak a' tawaanee'ut ju'unee betchi'bo ―ti nau jiiak. Inien chupuk wa'a bat naataka jum Liojta betana ji'osia ji'ojteimpo: “Inime'e, juka' in tajo'ori nat na'ikimtek, aet nau ja'atekai”, ti a' jiaka'po. Inien, inika'a junen yaak jume' sontaaom. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Junama'a kuuseu, Jesujta aet poponiu, Jesujta ae intok a' aewata akkoowa, intok Maria, Kleeopaj teamta jubiawa, intok Maria Maareena' teame ama aanen. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ju'u Jesus, a' malawata intok waka'a a' majtita, tua a' nake'uta ae naapo weyekamta bichakai, a' aebeu: ―Ju'u eu weyekame, em yoemiatune ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chukula ket ju'u a' majtibeu: ―Inika'a eu weyekamta, empo aek ―ti au jiiak. Intok junama'a naateka, ini'i majti, aapo'ik jo'au a' jo'ane' betchi'bo a' mabetak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iniat chukula ju'u Jesus junuen juka' a' ya'a'ea'uta si'imeta jaibu a' chupsuka'ut ju'uneakai, juka' jum Liojta betana ji'osia ji'ojteimpo ji'ojteita a' chupne' betchi'bo: ―Ba'ae ne muuke ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Junama'a ili soto'i, binaakre' teamtae tapunika ama manekan. Junak intok juname'e, junama'a, ba'ata nunu'emta, ejponja' teamta komoniaka, tebe kuta, isoopo' teamtat a' chayaka intok jikau, teniu au a' noitak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesus inika'a binaakreta je'eka, chukula aapo: ―Jaibu si'ime chupsuk ―ti jiiak. Junak intok aapo, ko'om kobateka, muukuk. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Inimi'i wepul taewai jiba be'een, bwala jisuawaka pajkota weene' betchi'bo, jume' juriom intok, jume' takaam ka kuusimmet aet yum jo'e taewait am tawaa i'an. Bwe'ituk juna'a aet yum jo'e taewai, tua beja yo'oriwaka eiyaawan. Inia betchi'bo bempo, Pilaatotau nookak, jume' kuuset cha'akame, aapo'ik am wok kotta tebone' betchi'bo, intok junuen inime'e lauti kokoka, inime'e, bem takaam junama bem ko'om jo'ana' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Junako jume' sontaaom aman sajaka, intok bempo junaman jume' woika aman kuusimmet popontukame, inime'e nanancha nau bicha wokim am kottariak. Jume' Jesujta mak ama popontukame. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Taa inime'e, Jesujtau japtekai, jaibu mukiata bichaka intok inia betchi'bo ka a' wok kottak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Taa jume' sontaaom betana, seenu, aapo'ik tebe kuta sisi'iwookta bwawiakamtae, sana'ita betuk a' so'ak. Inim intok sep, ojbo ba'amak ama yeu siika. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ju'u inika'a inim a' teuwaame, ini'i a' bichak. Intok ini'i lutu'uriata nooka. Aapo, lutu'uriata a' noka'apo ju'unea, intok aapo inika'a teuwaa, junuen ket enchim a' sualne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bwe'ituk ini'i inien yeu sikame inien tuk, junuen, Liojta betana ji'osia ji'ojteimpo: “Ini'i, ota wepu'ulaik juni'i, ka a' kottarianaa”, ti jiamta a' chup betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Omot intok ket, Liojta betana ji'osia ji'ojteimpo: “Bempo, waka'a takaata bem so'aka'uta, a' bitne”, ti jiia. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Iniat chukula ju'u Josee' teame, wa'a ili jo'ara Arima tea'ati teaka'u jo'aakame, ini'i, Pilaatotau nookak, juka' Jesujta takaawata a' weiyaabaekai. Ini'i Josee, Jesujta mak eaka a' sualen, junuen aapo ka au ju'uneiyaa teboika juni'i, jume' juriom a' majjae' betchi'bo. Inika'a, Pilaato a' nok mabetak. Ju'u Josee intok aman siika juka' Jesujta takaata a' nu'u betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ketchia ju'u Nikoreemo' teame, ini'i bat naataka tukaapo Jesujta mak etejokame, ini'i, senu taka ama woj mamni kiilom betteakamta, miira' teamta intok alooej teamta nau kuutik aman au a' nu'upak. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Junuen san ini'i Josee intok ju'u Nikoreemo, bempo juka' Jesujta takaata toboktaka intok bempo, tajo'orim, tettebesi yeu wo'otim, iniae nau kuutia win jubasi ya'arimmea a' biijtak, inika'a, jume' juriom jume' kokolam ma'a betchi'bo, bem a' joa'a benasia ayukai. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Junama'a, jum Jesujta kuuset poponwaka'anaapo, ujyoisi juya etritukan, intok jiba inim, yee ma'a betchi'bo, tetapo wojo'oriata bemelasi ya'atukan, kee jabeta ama ma'awakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Junama'a bempo a' teekak juka' Jesujta takaata. Bwe'ituk ini'i tetapo wojo'oriata ya'ari, junama ka mekkaakai. Intok junama'a jume' juriom juka' aet yum jo'e betchi'bo taewaita jaibu abe a' naate' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lominkot, semaanata aet naateo, ju'u Maria Maareena' teame, tua ketwoo, jum tetapo wojo'oriata ya'ariu siika, ketun ka machiako. Intok aapo junaka'a tetapo wojo'oriata ya'arita jaibu ka pattita teak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Junak intok aapo, jum Simoo Peeo' teamta intok juka' senu majtita, wa'a, Jesujta tua naksuka'uta, inime'e joka'u tajtia buiteka intok: ―Itom yo'owa, tetapo wojo'oriata ya'ari betana yeu nuk saka'awak, itepo intok tee ka ju'unea jakun a' tojiwaka'u ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Junak intok Peeo intok ju'u senu majti, bempo junaman tetapo wojo'oriata ya'ariu bicha yeu sajak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Inime'e woika nau tenni japtek. Taa ju'u seenu, Peota bepa che'a utte'a buiteka intok ini'i, tetapo wojo'oriata ya'ariu bat yepsak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Aapo kia aman wajiwa ko'om bitchuka intok junama'a jume' tajo'orim, tettebesi yeu wo'otim ama jokame jiba bichak. Taa ka aman kibakekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Chukula ket ju'u Simoo Peeo' teame, aet cha'aka ama yepsak. Intok aapo aman kibakek tetapo wojo'oriata ya'ari'po. Aapo ketchia juname'e tajo'orim tettebesi yeu wo'otim ama jo'arim bichak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Intok ketchia ini'i, jume' tajo'orim, aapo'ik pujbat intok kobat ammea a' suma'im tuka'um, ka jume' tettebesi yeu wo'otim mak katekame, ala tottimtaka intok omola yecha'im ama am bichak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Junak intok ketchia ju'u senu, Jesujta majti aman kibakek. Ju'u che'a bat aman tetapo wojo'oriata ya'ariu yepsaka'u. Intok ini'i, juka' ama yeu sikamta bichaka intok kokkoarim nasuk a' jiabijteka'uta a' sualek. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bwe'ituk inime'e, jum Liojta betana ji'osia ji'ojteimpo weyemta, juka' Jesujta kokkoarim nasuk a' jiabijtenee'u a' utte'atuka'ut, kee aet ju'unean. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Junak intok juname'e Jesujta majtim, bem jo'aau bicha nottek. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Taa ju'u Maria, junama'a pa'aku tetapo wojo'oriata ya'aripo naapo taawak, bwanakai. Ketun bwanakai, aapo aman ruktek junuen junama tetapo wojo'oriata ya'ariu wajiwa aman bitchubaekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Junama intok wooi ankelesim, tua tosaalaim tajo'orekame, Jesujta takaata bo'osuka'po jokame bichak. Senu a' kobasuka'a betana katekame. Senu intok a' woksuka'a betana katekame. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Inime'e ankelesim intok aapo'iku: ―Jamut, jaisaaka empo bwaana ―ti au nattemaek. Aapo inimmeu: ―Juka' in yo'owata a' nuk saka'awaka' betchi'bo. Nee intok ka ju'unea jakun a' tojiwaka'ut ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Aapo inien jiusuka, junak kuakteka intok Jesujta ama weekamta bichak. Taa ka ju'unean aapo'ik junen a' Jesuj tuka'po. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Junak ju'u Jesus: ―Jamut, jaisaakai empo bwaana. Jabetasa empo jaiwa ―ti au nattemaek. Aapo, juka' junama'a juya etrita suuamta ama ane'eti eaka: ―Japchi, empo a' nuk simlatuko, nee tejwaa jakun em a' tojaka'po, in aman a' nu'une' betchi'bo ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ju'u Jesus junak: ―Maria ―ti au jiiak. Aapo ju'u Maria, au kuakteka intok a' ta'aaka, ebreeo nokpo: ―Rabboni ―ti au jiiak. Ini'i, yee majtame ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus iniau: ―Inim nee sim tua. Bwe'ituk ketun nee kee aman in yo'owata a' jiapsa'u jikau weye. Taa ala, sika intok aman jume' nemak werim tejwaane, in yo'owabeu intok ket enchim yo'owabeu, intok in Liojtau intok enchim Liojtau bicha nee weebae'eti jiune. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Junak intok ju'u Maria Maareena' teame, ini'i, jume' Jesujta majtim aman tejwaak, aapo'ik juka' yo'ota a' bichaka'uta. Intok jiba Jesujta junaka'a bemela weyemta au a' teuwaaka'po. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jiba junae taewait, semaanata aet naate'utchi, tukaapo, jume' Jesujta majtim nau aanen. Intok ama yeu rejtiwa'um eta'ikai, jume' juriom bem majjae' betchi'bo. Junama'a ju'u Jesus yepsaka intok jume' aapo'ik majtim nasuk kikteka intok ameu tebotek: ―Ka jain eaka enchim yanti elnee'u emou aune ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Inien jiusuka aapo chukula a' mamam intok sana'ita betuk ko'okosi a' ya'ari'po am bittuak. Intok bempo tua alleak aapo'ik juka' yo'ota juchi a' bichakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Junak intok ju'u Jesus, juchi: ―Enchim yanti elnee'u emou aune ―ti ameu jiiak―. Jiba juka' in yo'owata inim nee yeteu a' bittuaka'a benasia, jiba inien ineponee inim enchim naas bittuabae ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Junak intok aapo ame bepa jiabijtekamta benasi ayuka: ―Liojta betana juka' tu'u jiapsita eme'e mabetne ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Inim wame'e enchim, Liojta tu'u jiapsi betana aniawaka, inime'e, bem ka tu'uwa ya'arimmet enchim am jiokoi tebonee'um, inime'e, bem ka tu'uwa ya'arimmet jiokoitune. Wame'e intoko, bem ka tu'uwa ya'arimmet, Liojta tu'u jiapsi betana aniawakai enchim ka jiokoi tebonee'um, inime'e, bem ka tu'uwa ya'arimmet ka jiokoitune ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Taa ju'u Toomaj teame, jume' woj mamni ama woika, jume' Jesujta majtim mak weyeme, ju'u wo'ori ti teuwaawame, ini'i, ka ama amemak aanen, juka' Jesujta ameu a' noiteo. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chukula wate aapo'ik majtim iniau: ―Juka' yo'ota, itepo a' bitlaa ―ti au jiiak. Taa ju'u Toomas junammeu: ―A' mampo a' wojoktipo ka bichakai, intok jum sisi'iwookim japsuka'po nee ka mam pusiateko, intok kia jum a' sana'ita betuk a' so'aripo ka aet mamteko, kannee a' sualne ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Woj naiki taewaim simsuka chukula, jume' Jesujta majtim juchi senu karipo nau aanen. Taa inim ala ju'u Toomas amemak aanen. Junako, junaka'a tu'isi a' pattituk juni'i, ju'u Jesus aman kibakeka ka teutaka, ame nasuk kikteka intok ameu tebotek: ―Enchim yanti elnee'u emou aune ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Junama'a aapo sep Tomajtau: ―Em mam pusiam im tutta. Intok ime'e in mamam bicha. Intok empo im in sana'ita betuk, ama net mamtene. Intok ka naa buusti nee betana ta'abwisi eene, ala empo nee sual ta'aane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Junak ju'u Toomas, aapo'iku: ―In yo'owa intok in achai Lios ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus intok iniau: ―Toomas, i'an ala empo nee suale, taa kia junuen tua nee bichaka jiba. Tua alleewame tu'uwa ame tana waatianaa, wame'e, kaita bichaka, nee sualekame ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ketchia ju'u Jesus, jume' a' majtim bichapo tua juebenak machilaata a jita a' joa'ue a' yaak, ini'i, inim ji'osia ji'ojteimpo ka weyekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Taa ini'i weyeme machilaa i'an inim ji'ojtewak, juka' Jesujta, Liojta betana usiwaitaka a'abo a' bittuarituka'uta enchim a' sualne' betchi'bo, intok junuen eme'e a' sualekai, jiba yuu jiapsiwamta enchim bitne' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Iniat chukula ju'u Jesus, jume' a' majtimmeu juchi au yeu machiak, jum bwe'u bau ba'a Tibeeriaj tea'po bwikola. Inen aapo ayukai. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Inimi'i, Simoo Peeo, intok Toomas ju'u wo'ori ti ta'eewame, ju'u Natana'el teame, ini'i jum bwiaraa Kalileapo ili jo'ara Kanaa' teapo joome, jume' Sebereeo' teamta u'usim intok juchi wate woika jume' Jesujta majtim, inime'e ama nau aanen. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Wa'a Simoo Peeo' teame inimmeu: ―Kuchum ne yeu bause ―ti ameu jiiak. Bempo: ―Itepo ket te aman emak katbae ―ti au jiiak. Inime'e aman sajaka intok kuta kanoau ja'amuk. Taa bempo junae tukaariat kaita yeu wikek. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Junak junama'a jaibu yeu matchuu, Jesus junama'a bawe mayoat yeu machiak. Taa jume' a' majtim ka ju'unean, juka' ama anemta aapo'ik juna'atuka'po. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Junak ju'u Jesus, inimmeu: ―Uusim, jaisa eme'e kee jita yeu wike ja'ani ―ti ameu nattemaek. Bempo intok: ―Kaita ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Junak intok ju'u Jesus, inimmeu: ―Batatana bicha am jimmaanee jume' jite'im, intok eme'e junama'a yeu am wikne ―ti ameu jiiak. Inien inime'e aayuk. Intok chukula bempo, jume' jite'im junama ba'apo ka a yeu am wiken, kuchum inim tua yu'in am weiyaakai. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Junako ju'u aapo'ik majti, Jesujta tua nake'u, ju'u Peotau: ―Ju'u itom yo'owa ama weama ―ti au jiiak. Ju'u Simoo Peeo, junaka'a juka' bem yo'owata ama ane'uta a' jikkajakai jiba, tajo'po kobateka, ba'au au jimaak, mayoau tajtia bajumbaekai. Bwe'ituk tajo'owattilatukan. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jume' waate Jesujta majtim, kuta kanoapo ba'a mayoau yeu yajak. Inime'e, jume' jite'im kuchummea tapunim yeu wik sakakai. Bwe'ituk junama'a mayoau tajtia kia jumak mamni taka waaktitukan jiba. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bwiau yeu yajakai, inime'e junama'a taji oubampo kuchuta ama bo'okamta intok ket paanim ama teak. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ju'u Jesus inimmeu: ―Jume' kuchum ju'ubwa enchim yeu wikeka'um watem a'abo tojine ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ju'u Simoo Peeo, kuta kanoau ja'amuka intok mayoau tajti jume' jite'im, kuchummea tappunim yeu wikek. Woo busan taka ama woj mamni ama baji kuchum tukan. Inime'e intok tua juebenaeka juni'i, ka chuktek jume' jite'im. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Junak ju'u Jesus, inimmeu: ―A'abo kateka em ji'ibwa ―ti ameu jiiak. Inime'e a' majtim betana, tua kaabe au nattemaek aapo'ik jabetuka'ut, bwe'ituk juka' bem yo'owata ama ane'uta emo ju'unea'ati ean. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Junako ju'u Jesus, aman rukteka intok jume' paanim nu'uka intok bempo'immeu am bwisek. Intok juka' kuchuta juni'i jiba junaen ameu a' bwisekai. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Inim iniamak ju'u Jesus, a' majtimmeu bajisi ameu au yeu machialatukan aapo chukula kokkoarim nasuk jiabijtesukai. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Junama'a ketwoo, bempo ji'ibwasukai, ju'u Jesus, Simoo Peeotau: ―Simoo, Jonaj teamta yoemia, jaisa empo inime'ebepa nee nakke ja'ani ―ti au nattemaek. Ju'u Peeo intok: ―Jeewi in yo'owe, empo ju'unea in enchi eiyaa'u ―ti a' yoopnak. Ju'u Jesus iniau: ―Inientuko, empo jume' ju'ubwa nee sual japteme, bwala aso'olam benasia in eiyaa'um, inime'e am majtaka tu'isi nee am suuariane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chukula juchia, iniamak woosa: ―Simoo, Jonaj teamta u'usi, jaisa empo nee nakke ja'ani ―ti au nattemaek. Ju'u Peeo: ―Jeewi in yo'owe, empo ju'unea in enchi eiyaa'u ―ti a' yoopnak. Aapo: ―Junuentuko, jume' nee sualeka, bwaram benasi in eiyaa'um, inime'e nee betana weyemtat am aniane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iniamak bajisia aapo: ―Simoo, Jonaj teamta u'usi, jaisa empo lutu'uriapo tu'isi nee eiyaa ja'ani ―ti au nattemaek. Ju'u Peeo intok junak au sioktua taitek junuen, iniamak bajisia: “Jaisa empo tu'isi nee eiyaa”, ti au a' nattemaeka' betchi'bo, intok aapo: ―In yo'owe, empo'e si'imekut ju'unea, empo ju'unea junuen in enchi eiyaa'u ―ti au jiiak. Ju'u Jesus iniau: ―Junaentuko, empo wame'e nee sualeka, bwalam benasi in eiyaa'um, nee betana weyemtat am majtaka, nee am suuariane ―ti au jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iniat empo nee sualne, junak empo bat che'a ju'ubwa yo'otukai, empo em tajo'po kobateka intok empo em yeu weebae'u bicha wewe'aman. Taa chukula, empo jaibu yo'otuitakai, junak em mamam empo na'ikim am to'one, intok ta'abwika enchi tajo'otuane, intok juna'a, ka em weebae'u bicha juni'i, enchi weiyaane ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Inika'a teuwaakai ju'u Jesus, juka' Peota jachin ayuka, mukuka intok iniae aapo'ik Liojta a' yo'ori tebonee'uta a' teuwaak. Chukula intok aapo ju'u Jesus, Peotau: ―Empo jiba nemak eaka jiapsine ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Juchi bicha kuaktekai, ju'u Peeo, juka' Jesujta majti aapo'ik tua nake'uta, inika'a amet cha'aka weyemta bichak. Jiba wa'a, kupteo ka machiako, Jesujta amemak ji'ibwaka'po aapo'iku pitti kateka'uta, intok ini'i: “Achai, jabesa juna'atune, ju'u enchi yeu bwijneeme”, ti au nattemaeka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Junako, ju'u Peeo inika'a bichakai, Jesujtau: ―In achai, iniau su, jaisa au chupne ―ti au nattemaek. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus inika'a: ―Junuen inika'a, chukula nee a'abo notteo tajtia inim nee a' jiapsi i'ao juni'i, empo inim iniat kaachin eene. Empo jiba nemak eaka jiapsine ―ti a' yoopnak. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Junako, jume' Krijto nau sualeme nasuk, inika'a Jesujta majti ka a' muknee'uta etejowan. Taa Jesus iniau ka junuen ka a' muknee'uta au teuwaak, ala aapo: “Inika'a, chukula nee a'abo notteo tajtia inim nee a' jiapsi i'ao juni'i, empo inim iniat kaachin eene”, ti jiiak jiba. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ini'i jiba juna'a ju'u Jesujta majti, inim ae betana etejowame, ju'u inika'a a' lutu'uriateka a' teuwaaka intok inika'a weyemta ji'ojtekame. Ite intok ju'unea, si'imeta juka' a' teuwaa'uta, lutu'uriataka a' weye'uta. ");
INSERT INTO yaqNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ketchia tua juebenaka, wate weyeme aayuk, Jesujta ya'ari, ini'i intok we'epulaka ji'ojte tuko, si'ime jume' ji'osia ji'ojtei tu'ea'um, kia jumak inim aniapo ka kia ean, ti ne ea. Tua junuentune.");
INSERT INTO yaqNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tua in nake'u Teopilo' teame, jum che'a bat weyeka ji'osiata in eu ji'ojteipo, Jesukrijtota betana si'imeta, bat naataka naateka, intok aapo'ik, teeka betana jikau a' mabetwa'po tajtia, si'imeta juka' aapo'ik yaaka intok juka' yee a' majtasuka'uta betana ne eu ji'ojtek. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Aapo junak kee teekau nottekai, jume' yeu a' pu'arim, aapo, Liojta tu'u jiapsie aniawaka, bem joonee'ut am tejwaak. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Chukula, aapo me'etuka, jiabijtesukai, aapo ju'u Jesus jiapsaka ameu au yeu machiak. Intok chukula, aapo junuen junama'a woi taka taewaimmeu tajtia ameu au yeu mamachiakai. Junuen tua lutu'uriapo a' jiapsa'uta bempo'im a' ju'uneiyaatuakai. Intok ket aapo, achai Liojta yo'o nesaweka a' kateka'u betana juka' lutu'uriata ameu a' teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Intok aapo ketuni amemak anekai, jum bwe'u jo'ara Jerusalen tea'po kaakun am katnee'po betana am tejwaak. Inimmeu aapo: ―Inim eme'e bo'o bitne, achai Liojta betana waka'a emou a' chupne'eti jiaka a' teuwaarita, jiba in emou a' teuwaaka'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Bwe'ituk ju'u Joan, yee babatoowame ba'ammea yee babatoowak. Taa ka juebena taewaim sikaa, inepone, Liojta betana, juka' a' tu'u jiapsita ne emou a' bittuane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Junak bempo Jesujtamak si'ime nau anekai, aapo'iku nattemaek: ―Itom yo'owa, jaisa jiba i'an junen empo inim itom jume' juriom, romaano ya'uraata betana su'u tojiwaka, juchi inim itom nesaunee'ut iniat itom aniaka itom a' tu'uteriane, ja'ani ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Aapo intok inimmeu: ―Eme'e, jakwoo, oo jita ta'apo juka' in yo'owa Liojta, aapo'ik jiba au lutu'uriaka a' ya'anee'uta, junae betana enchim a' ju'uneiyaanee'uta ka emou lutu'uria ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Taaeme'e chukula, juka' Liojta tu'u jiapsita mabetsukai, eme'e inim si'imekuu yuma'anee intok ka jain eaka, yeu sajaka nee betana weyeka, juka' nok lutu'uriata inim bwe'u jo'ara Jerusalen tea'po intok bwiaraa Jurea' tea'po intok ket jumun bwiaraa Samaaria' tea'po, intok kia inim bwiapo, che'a mekka bicha tajti eme'e a' teuwaane ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Inika'a aapo teuwaasukai, bempo'im ketun a' bitchuu su, ju'u Jesus junama'a yeeu, teekau jikau siika intok aapo junaman namupo kaabetuk. Inime'e intok ka intok inim a' bichak. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bempo'im junuen juka' Jesujta a' simeo, aman teekau a' bitchuu su, junama'a o'owim woika, tojsassaalaik atteaka bempo'im naapo yeu machiak. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Inime'e intok bempo'immeu: ―Eme'e, bwiaraa Kalilea' tea'po joomem, ka intok teekau jikau a' bitchune. Jiba ini'i Jesus, inim emo tana, teekau jikau sikame, aapo jiba inien, junuen a' sika enchim a' bichaka'a benasia juchi nottine ―ti ameu jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Junak inime'e junama'a Oliibo kawi' tea'a betana yeu sajaka intok bwe'u jo'ara Jerusalen tea'u nottek. Juna'abo aman ka mekkaa, jumak wepul kiloometro tukan jiba. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Junak bempo jum Jerusalen tea'u yajakai, junama'a kari bem ama joka'apo, junama'a karita bepa juchi senu bepaata ya'ariu jikau ja'amuk. Inime' nasuk, inen teakame ama aanen: ju'u Peeo' teame, ju'u Jakoobo, ju'u Joan, ju'u Anteej teame, ju'u Jeriipe, ju'u Toomas, ju'u Baatolomee' teame, ju'u Mateeo, ju'u senu Jakoobo, ini'i senu Alpeo' teamta yoemia, ju'u Simoo, ini'i jume' kananijtam ti emo teuwaammak ea'u, intok ju'u Juuras, juka' Jakoobo' teamta mak weri. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Inime'e si'ime jiba wee'po, nau eaka, jume' Jesujta mak werimmak intok juka' a' aewata Maria' teamta mak, intok junama'a jume' waate jaamuchimmake emo nau totojan junuen Liojta yo'oreka intok au bicha yee nokria betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Juname'e taewaimmet ju'u Peeo, junama'a jume' Krijtota nau sualeme nasuk kiktek. Inime'e jumak si'ime nau, busan taka tukan. Aapo intok inimmeu: ");
INSERT INTO yaqNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Krijtopo nemak werim, utte'atukan, wa'a, jum Liojta betana ji'osia ji'ojteimpo, bat naataka jaibu Labiituka'uta, Liojta tu'u jiapsie noktuawaka junuen Jurajtuka'uta betana, ju'u, jume' Jesujta bwiseka a' nuk sajakame am tejwaakamta betana a' teuwaaka'uta junuen a' chupne'po ―ti ameu jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Bwe'ituk ju'u Juurajtuka'u itomak na'ikiatukan intok ketchia aapo, jiba ito benasi itom tekil jooan. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Taa juna'a, sikaa, intok ju'u tomie, ka tu'ik ya'arika a' makwaka'ue, waj bwiata jinuk. Chukula intok aapo, jikat betana kobae ko'om wecheka intok toma pejteka, intok a' tompo ayukame si'ime yeu wattek. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chukula, jume'e, bwe'u jo'ara Jerusalen tea'po jiapsame junae betana a' ju'uneiyaaka, bempo, junaka'a waj bwiata, Akellamak ti a' teatuak. Ini'i nooki, bem nokpo, Waj bwia ojboe beje'etuari, ti jiubae. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bwe'ituk jum ji'osia ji'ojteim, Salmom tea'po: Ju'u a' kariwa jimmaatunee intok kaabe ama jo'ane, ti jiia. Intok ketchia jiba junama'a ji'ojteimpo: Ta'abwika, tekil a' joa'uu tawane, ti ji'ojtei. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Inim ito nasuk wate aane, inime'e, juka' yo'owe Jesukrijtota inim itomak a' aneka'po tajtia, bat junak ju'u Joan tuka'uta betana a' bato'owaawaka'po naateka, chukula aapo'ik teekau a' notteka'po tajtia, jiba ta'apo itomak aneme. Inien san i'an junuen, inime betana seenuk, juka' yo'owe Jesukrijtota, kokkoarim nasuk a' jiabijteka'po itomak a' teuwaaneemta, inime'e betana itom yeu a' pu'anee'uta utte'a. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Junama'a ame betana senuk amemak tawaane' betchi'bo, woika yeu pu'awak. Ju'u seenu, Jose Barsabaj teame, ket Jujto'oti teuwaawame. Intok seenu, Matiaj ti teakai. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Intok chukula bempo Liojtau bicha am nokriak: ―Achai Lios, empo junen inim si'imem jiapsi ta'aame, inime'e woim betana jabeta em yeu pu'aariaka'uta itom yeu a' pu'ane' betchi'bo itom ania ―ti jiakai―. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Junuen aapo'ik, jume' Krijtota betana yeu pu'arim, tekilta bem joa'uta, jiba juka' Juraj tuka'uta, ka tu'ik ya'arika junuen a' tawa'ea'uta junuen au chupuka a' ta'aruka'uta, inika'a a' joone' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Junako bempo junammet ju'unee betchi'bo, jitae amet nau yeewekame benasi aayuk. Intok junak junuen inim ju'u Matiaj teame ama teuwaatuk. Junama naateka ini'i, aapo, waate jume' woj mamni ama wepu'ulaika jume' Krijtota yeu pu'arimmak na'ikiatuk. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Junak chukula, Jesukrijtota muksuka intok aapo'ik kokkoarim nasuk a' jiabijtesuka, woo busan semaanam simsuko, taewai, bem nokpo Pentekojtej ti ta'eewame yumaka, si'ime wame'e Krijtota nau sualeme, inime'e wepulsi karipo si'ime nau aanen. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Junama'a seej chuktia, teeka betana weyeka, jiawai, suum watchika jikkajituk. Inika'a, bwe'u jekata yepsaka'abenakai. Intok junuen, jum kari bem joka'apo si'imekut yumakai. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Junak intok, bempo'im ane'epo taji buaktiam benaka ama bittuk. Inime'e bempo'im we'epulaim bepa cha'atukai. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Intok junak inime'e si'ime, Liojta betana a' tu'u jiapsiwata yuma'isi a' mabetak. Intok inime'e si'ime, tatta'abwi, ka bem nokpo, nok japtek. Junuen jiba juka' Liojta tu'u jiapsita am noktua'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jiba juname'e taewaimmet junama'a bwe'u jo'ara Jerusalen ti teaka'po, jurio yoemra, inime'e Liojta yo'ori betchi'bo, bem suale'ut tua yuma'isi a' joame, inime san, mekka omot tatta'abwi bwiaraam betana jomemtaka ama anekai. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Junak junama bem ane'epo, junaka'a jiawaita a' jikkajituko, junama ju'u bu'uuraa ama nau yajak. Intok inime'e betana kaachin ee machika kialam bitchuka taawak. Bwe'ituk inime'e, juname'e si'ime, we'epulaka bem nokpo nokame jikkajan. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Inime san junen tua suum eaka am bichaka intok bempo: ―Si'ime inime'e nokame itom jikkaja'um, bwiaraa Kalilea' tea'po joomem o'oben ―ti nau jiian―. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Taa itepo i'an inime'e, bempo'im we'epulaka, itom aamak yo'otuka itom nokpo nokame jikkaja. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Inim ito nasuk yoemra aane, bwiaaram inen teaka'po betana joome. Jum Paartia' tea'po, jum Meeria' tea'a betana, jum Elamiita' tea'a betana, jum Mesopotaamia' tea'po joome. Ket jum Jurea'a betana, jum Kapparoosia' tea'a betana, jum Ponto' tea'a betana, Aasia' tea'a betana. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Jum Riijia' tea'a betana, jum Pampiilia' tea'a betana, jum Ejiipto' tea'a betana. Jum Aprika' tea'po senu bwe'u jo'araa Sireene' tea'a betana jume' che'a wa'am bicha jo'aakame. Inim ketchia, yoemra Roma' tea'a betana inim jooka. Inime'e betana waate juriom yeu yoemtulamtakai, wate intok ka juriomtaka, taa juriom junuen Liojta yo'oreka bem bo'o jooria'uta ame benasi a' sualeme. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ketchia waate jum bwiaraa bawepo kateka, Kreeta' tea'a betana, intok ket bwiaraa Araabia' tea'a betana inim aane. Taa junuen taka juni'i, si'ime itepo inim, bempo'im, Liojta betana juka' che'a bepa eiyaawatchika kaitau a tamachiatuka a' ya'arita, itepo, we'epulaka, tua itom tatta'abwi nokpo a' teuwaame jikkaja. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Si'ime jume' am bichame suum eaka intok kaachin ee machiakan. Intok inime'e: ―Jitasa tua si'ime ini'i itom bicha'u ―ti nau nattemaen. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Taa waate kia am junn jiaawaka intok: ―Inime'e che'a, pa'asi ba'awata yee nanaakomta ji'ilamtaka june'ela ―ti jiian. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Junako ju'u Peeo, watem jume' woj mamni ama weepulaika, Jesukrijtota yeu pu'arimmak, ama kikteka intok kusisi nokaka: ―Eme'e, Jurea bwiaarapo joomem intok eme'e inim bwe'u jo'ara Jerusalen tea'po jiapsame, inika'a ju'uneiyaanee intok inika'a in emou teuwaabae'uta a' mammatene. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Inime'e enchim bicha'um, katim naako enchim am eiya'a benasia. Bwe'ituk ketuni ketwoo, ju'ubwasu batanim jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ala ini'i enchim bicha'u, juna'a ju'u chukula yeu weenemta tetteuwaame, Joel tuka'uta, che'a bat naataka aapo'ik teuwaari juna'a. Junak inen jiakai: ");
INSERT INTO yaqNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Che'a chukula taewaimmetchi ti jiia ju'u Lios, nee betana inepo juka' in tu'u jiapsita ne si'ime im bwiapo jiapsame nee a' ju'uneiyaatuane. Jume' enchim yoemiarim, o'owimtaka, jaamuchimtakai, juka' nee betana weyemta a' teuwaane. Jume' ju'ubwa yo'otume, ka si'imem a bicha'uta bibittuanaa. Jume' intoko yo'otuim, inime'e jita tettenku tuanaa, ti jiiak ju'u Joeltuka'u. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jiba juname'e taewaimmet, inepo juka' nee betana tu'u jiapsita nee jume' in yeu pu'arimmet, o'owimtaka intok jaamuchimtaka, nee a' ju'uneiyaatuane. Inime'e intok, juka' nee betana weyemta a' teuwaane. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Jikat teekau inepo, jita ka jiba bitwaka, junerak a' bit tebone. Intok inim bwiapo inepo machilaata ne ya'ane. Ojbota benak, tajita intok bwichiata benak, jaawata benasi weyemta. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ju'u intoko ta'a, tua ka machisi tawane. Ju'u intok meecha, ojbota benasi sikii chukuisi bittune. Ini'i, wa'a yo'owe Jesukrijtota aapo'ik yeu pu'arita taewaita kee a' yumao. Junak juna'a taewai, che'a bepa kaita intok ale benasi taewai che'a machika bittuneekai. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Intok junak, jabetaka juni'i, wa'a tua junen jiaka ju'u itom yo'owabeu bicha aapo'ik a' jiokolinee'uta a'awame, juna'a jinne'ui tune, ti jiiak ju'u Joeltuka'u. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Junuen san eme'e, Ijra'el tuka'uta betana a' yoemiammet yeu katriam, inika'a in teuwaabae'uta a' jikkajine. Jesus, ju'u Nasaret tea'po joome, aapo, achai Liojta betana inim emo bichapo, aapo'ik che'a bepa kaitau a tamachiatuka a jita a' joa'ue a' yaaka'ue, intok si'imeta machilaata, jiba aapo'ik achai Liojta emo bichapo aapo'ik Jesujta a' ya'atuakai, junae a' Krijtotuka'uta a' teuwaak, enchim jaibu a' ju'uneiya'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Taa junuentaka juni'i, inika'a che'a bat naataka naateka, juka' Liojta tua junuen a' chup i'a'po aman, aapo'ik emou a' su'u tojiwako, junak eme'e a' bwiseka intok junuen wame'e ka Liojta yo'ori ta'aame betana aniawaka, eme'e, kuuset a' popon tebokai a' me'aak. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Taa ju'u Lios, aapo'ik mukiataka, juchi a' jiapsituak, kokkowamta betana ama a' yo'eetuakai. Bwe'ituk aapo kaachin mukiataka junuen tawa ean. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Bwe'ituk ju'u che'a yo'o ya'ari, Labiituka'u, jiba aapo'ik Jesujtat nokaka: Ineponee juka' achai Liojta jiba nemak aneka intok jiba nee aniamta nee a' yoem eiyaak. Intok junuen, kaita in majjaune' betchi'bo, aapo si'imeku yumaka nemak tukai. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jiba inia betchi'bo inepo in allea'u tu'isi net ayukan, Intok inepo tua alleaka, aapo'ik in bai sae'uta ne a' teuwaak. Ket jiba inia betchi'bo san, kaitat jain eaka nee bo'otene. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bwe'ituk empo kaachin, jume' kokkoarim jiba betchi'bo ane'u nee tawaane. Intok kia empo, inika'a em yeu pu'arita, aapo'ik takaawata nasontene' betchi'bo, ka ama a' su'u tojine. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ketchia empo, jum jiba yuu jiapsiwa'u jachin aman yaajiwa'uta, nee a' ju'uneiyaatuak. Intok empo nemak aneka, tua alleewamta nee a' bittuane, ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Eme'e, nele benasi inim yoemem, a itepo a' ju'uneiyaa, juka' che'a bat weyeka itom yo'owasuka'uta, Labiituka'uta a' mukuka'po intok ket a' ma'atuka'po. Bwe'ituk tetapo wojo'oria a' ma'awaka'po, ini'i ketun tee im a' bicha. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Taa ju'u Labii tuka'u aapo, Liojta betana ju'uneetuawaka, chukula yeu weemta teuwaan. Intok aapo ju'unean, juka' Liojta jita teuwaaka tua a' lutu'uriatunee ti jiakai, aapo'ik yeu katriam betana juka' seenuk, Liojta yeu pu'arita a' yebijne'po. Intok aapo'ik yo'otaka a' yej suka'po, inika'a ama yo'otaka a' yejtenee'uta. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Junuen san ju'u Labii tuka'u, tua ju'uneamta benasi, Jesukrijtota, kokkoarim nasuk a' jiabijtenee'uta a' teuwaak. Intok ketchia aapo'ik, jume' kokkoarim jiba yuu betchi'bo bem ane'u, aapo'ik ka ama a' tawanee'uta. Intok kia aapo'ik taka juni'i, ka ama a' nasontunee'uta a' teuwaak. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Intok ini'i, ju'u Lios, jiba inika'a Jesujta, kokkoarim nasuk a' jiabijtetuak. Intok jiba inien yeu sikamta betana jiba itepo tee a' ju'uneiyaaka a' teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Junuen san jiba aapo, achai Liojta a' kateka'u sikaa, a' batatana yejtek. Intok a' yo'owa betana juka' a' tu'u jiapsiwata au a' na'ikiarita, aapo a' mabetak. Intok si'ime ini'i enchim bichaka'u intok enchim jikkajaka'u, jiba aapo'ik betana weye. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Bwe'ituk ka ju'u Labiituka'u juna'atuk ju'u teekau sikame. Bwe'ituk jiba aapo ju'u Labii tuka'u: Ju'u in yo'owa Lios, ju'u yeu pu'ari in yo'owabeu: “Inim in kateka'po, batatana yesa'e”, ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“Chukula, si'ime wame'e enchi beje'eka aneme, yuma'isi bem eu emo su'u toja'po tajti, Junaet in enchi aniasu'po tajtia”, ti jiiak ju'u Labii tuka'u. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Si'ime ju'u im Ijra'el yoemra tua witti a' lutu'uriatuka'po a' ju'uneiyaa'em, inika'a Jesujta enchim kuuset poponaka'uta, juka' achai Liojta, si'imemmeu a' Krijtotaka intok si'imeku aapo'ik a' yo'o ya'ariaka'uta. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Inika'a bempo jikkajisukai, inime'e, bem sioksi ea'u amet ayukan, intok ju'u Peo' teamtau intok jume' waate Krijtota yeu pu'arimmeu nattemaek: ―Ito mak werim, itom tejwaanee inia betana, jaisa te annee ―ti ameu jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Junako ju'u Peeo: ―Liojta bichapo eme'e, ka tu'ikut betana emo temaeka a' koptane. Intok we'epulaka, eme'e Jesujtau bicha nokaka, ae betchi'bo emo bato'owaa tebonee junuen enchim ka tu'uwa ya'arimmet enchim jiokoina' betchi'bo. Intok junuen aapo ju'u Lios, juka' aapo'ik betana a' tu'u jiapsita emot a' autuane ―ti jiiak―. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bwe'ituk ini'i yetet autuanna'ateaka ju'u chupneeka, bat naataka teuwaari, jiba emo betchi'bo intok kia jume' enchim yoemiam betchi'bo juni'i weye. Intok kia si'ime wame'e, che'a mekka tajti jiapsame betchi'bo ketchia, ini'i, wame'e juka' achai Liojta aapo'iku bicha yeu a' pu'abae'um betchi'bo weyekai ―ti jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Inia betana ameu nokakai intok, ket watek ameu teuwaakai, ju'u Peeo inimmeu nookak intok tu'ik betana am sua tejwaakai, intok: ―Inim ka tu'ik joaka jiapsammak ka amemak eene ―ti jiakai. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Junuen san juname'e inime betana juka' Liojta betana nok lutu'uriata sualeka a' mabetakame bato'owaaimtuk. Intok jiba junae taewait, jumak baji miiltaka junama'a jume' Krijtota sualemmak ee japtek. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Intok si'ime, jume' Krijtota yeu pu'arim betana bem majtawa'ut jiapseka a' bo'o joorian. Intok si'ime, si'imeku nanancha eaka jiapsan. Intok Liojtau bicha yee nokriakai. Intok paanim rebekta betchi'bo emo nau totojan, junuen Jesukrijtota a' mukuka'u waati betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Intok si'ime jume' ama aneme, si'imeku Liojtat ee majjaen. Intok Liojta a jita joa' betchi'bo, ka a joo tu machik intok machilaata, jume' Krijtota yeu pu'arim a' jootuawan. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Intok si'ime wame'e Krijtota sualekame, juname'e jiba wee'po nau aanen. Intok bempo, juka' bem attea, si'ime nau a nau a' jipuen. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Inime'e, juka' bem atteata, intok si'imeta waka'a bem jipue'uta a' nenenkan intok junuen bempo, junaka'a tomita, junama'a bempo'immeu a' be'ee'po aman nat a' na'ikimtekai. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Intok chikti ta'apo bempo jum Liojta bwe'u te'opopo emo nau totojan. Intok ketchia, chukula, watem jo'aa be'ekatana sajaka, paanim rebekta betchi'bo, Jesukrijtota a' mukuka'u waatekai. Intok bempo tua alleaka intok kaabe emo che'ewareka nau aneka jiji'ibwan. ");
INSERT INTO yaqNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Intok Liojta yo'oreka, au bicha bem allea'uta a' teuwaan. Intok junama'a bem bwe'u jo'arapo, si'ime ju'u yoemra am eiyaaka am bichan. Intok junuen ju'u yo'owe Jesukrijto, chikti ta'apo, ama aapo'ik sualeme jume' jinne'uim tume, che'a juni'i am bu'uurian. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sejtul wee'po ju'u Peeo intok ju'u Joan teame, inime'e kupteo, bajim jia'apo, junama'a junak Liojtau bicha nokwamta joowao, bempo te'opou yajibokan. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Junama'a, chikti ta'apo senu ama yoeme, yeu a' tomteka'po naateka lo'itakai, ini'i jiba ama a'anen. Ini'i jum te'opou jiba totojiwan junama'a ama kimuwa'po, ini'i Tua Ujyooi ti ta'eewa'po intok junama'a yeechawan junuen jume' aman yajammeu a' netane' betchi'bo. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Junak junama'a, ju'u lo'itaka yeu tomtekame, Peota intok Joanta, jum te'opou kimume bichakai, bempo'im a' jiokoleka a' mikne' betchi'bo ameu netanen. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Junako ju'u Peeo intok ju'u Joan, a' mammateka a' bitchun. Ju'u Peeo intok: ―Itom mammatene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ini'i junuen amet bo'o bichan, juname'e jita a' mik machiakai. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Taa ju'u Peeo: ―Sawai tomi intok kia tosai tomi juni'i kaita. Taa in jipueka in ju'uneiyaa'uta nee enchi ya'ariane. Ju'u Jesus, Nasaret tea'po jometa betana lutu'uriaka ne eu nooka, kikteka intok weene ―ti au jiiak. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Junak intok ju'u Peeo, batatana mampo a' bwiseka a' kechak. Intok sep junama'a, aapo, wokpo intok tero'okimpo utte'ituk. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Junako wa'a lo'itaka yeu tomtekame, kupti kikteka intok junuen a' wokimmet weyeka wee taitek. Ini'i intok bempo'immak jum te'opou kibakek, tu'isi weyeka, jikau chepti simeka, Liojta alleaka a' bai sae'uta au bicha teuwaakai. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Junama'a si'ime yoemra, junuen weamamta intok Liojta alleaka a' bai sae'uta au bicha a' teuwaamta a' bichak. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Intok inime'e, juka' ama yeu sikamta betchi'bo, tua suum eaka a' bichak. Bempo su junaka'a yoemta tu'isi a' ta'aan. Intok ju'unean, jiba aapo'ik juna'a tuka'u, ju'u, te'opopo, pueeta Tua Ujyooi ti ta'eewa'po, ama kateka a' netansuka'u. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ju'u lo'itaka yeu tomteka'u, ini'i junama tu'ireakame, Peota intok juka' Joanta am bwisika, ka am su'u tottojan. Junak intok junama'a ju'u bu'uuraa, ama yeu sikamta tua a' suum eiyaaka, ama te'opopo lebela, jekka ya'ari Salomonta attea ti ta'eewa'po, junama Peotaim ane'u tenneka ama nau yajak. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Juname'e junuen bichakai ju'u Peeo, junae yoemratau: ―Ijra'el yoemra, jaisaaka eme'e itom su bichaka suum ea, junuen itom a jita joa' betchi'bo, oo Liojta tua itom yo'ori ta'aa betchi'bo, inika'a, itom au a' tu'uteka'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ala, ju'u Apra'amtuka'uta Lios, intok juka' Isaak tuka'uta intok Jakoop tuka'uta intok jume' itom yo'owasuka'um Lios, aapo, juka' a' yoemiata, Jesujta, jiba juka' enchim inim ju'u yo'o ya'araatau yeu tojaka'uta, aapo, inika'a tua a' eiyaa teboka a' yo'o ya'ari. Junak aapo'ik juka' kobanao Pilaatota, jiba a' jiokoeka a' su'u tojibaao juni'i, eme'e ka junen eak. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Eme'esan junaen, waka'a wepulsi Liojta betchi'bo jiapsaka intok si'imeku lutu'uriata a' jooriaka jiapsaka'uta a' jiokoi tebo'eaka su, eme'e senuk yee su'arika, eta'ita junaka'a a' su'u toji tebok. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Junuen eme'e a' me'aak, aapo'ik juka' jiba yuu jiapsiwamta yetet autuamta. Taa ju'u Lios, junuen mukukamta, kokkoarim nasuk a' jiabijtetuak. Intok itepo inia weyemta betana ju'uneiyaaka a' teuwaa. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jiba aapo ju'u Jesus juna'a, oo junuen aapo'ik Jesujta itom yoem eiyaa'u juna'a, inika'a o'outa inim enchim bichaka intok enchim ta'aa'uta inien utte'ata aet autuakame. Inien aapo'ik Jesujta sualwame, tua yuma'isi au a' ine'etetualaa jiba enchim si'imem a' bicha'a benasia. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Nele benasi inim yoemem, ju'uneanee junuen junak enchim intok jume' enchim ya'uraata, aapo'ik Jesujta me'aakai, aapo'ik tua a' jabe tuka'ut ka enchim ju'unea' betchi'bo, junuen enchim auka'po. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Taa ju'u achai Lios, jiba inien weyemtae a' chupan waka'a che'a bat naataka, jume' yeu pu'arim chukula yeu weenemta teuwaame jaibu a' teuwaarita, a' utte'atuka'u, aapo'ik yeu pu'arik Krijtota tua jiokot au bitnee'uta. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Inia betchi'bo, eme'e ka tu'ik betana emo temaine. Intok juchi Liojta mak emo tu'utenee junuen enchim ka tu'uwa ya'arimmet enchim jiokoina' betchi'bo. Junako ju'u itom achai Lios, emou tu'ika, yuma'isi jiapsi yanti elwamta enchim bittuane, ");
INSERT INTO yaqNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","junuen juka' Jesukrijtota, juka' bat naateka jiba emo betchi'bo yeu pu'arita emou a' bittuakai. ");
INSERT INTO yaqNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Junuentaka juni'i,