﻿USE sofia;
DROP TABLE IF EXISTS sofia.yao_vpl;
CREATE TABLE yao_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yao_vpl WRITE;
INSERT INTO yao_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Achi chili chitabu cha meena ga lukosyo lu Che Yesu Kilisito, Che Yesu Kilisito jwaliji jwa uŵelesi u che Daudi, jwa uŵelesi u che Iblahimu. ");
INSERT INTO yao_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Che Iblahimu ŵammeleche che Isaka ni che Isaka ŵammeleche che Yakobo ni che Yakobo ŵammeleche che Yuda ni achapwakwe. ");
INSERT INTO yao_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Che Yuda ŵammeleche che Pelesi ni che Sela, achikulu ŵao ŵaliji che Tamali ni che Pelesi ŵammeleche che Esloni ni che Esloni ŵammeleche che Alamu. ");
INSERT INTO yao_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Che Alamu ŵammeleche che Aminadabu ni che Aminadabu ŵammeleche che Nashoni ni che Nashoni ŵammeleche che Salumoni ni, ");
INSERT INTO yao_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Che Salumoni ŵammeleche che Boasi, achikulu ŵao che Boasi ŵaliji che Lahabu. Che Boasi ni che Lusi ŵaliji achaŵelesi ŵa che Obedi ni che Obedi ŵammeleche che Yese, ");
INSERT INTO yao_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","nombe che Yese ŵammeleche Mwenye che Daudi. Che Daudi ŵammeleche che Selemani, achikulu ŵao che Selemani ŵaliji ŵankwawo che Ulia. ");
INSERT INTO yao_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Che Selemani ŵammeleche che Lehoboamu ni, che Lehoboamu ŵammeleche che Abiya ni che Abiya ŵammeleche che Asa ni, ");
INSERT INTO yao_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","che Asa ŵammeleche che Yehoshafati ni che Yehoshafati ŵammeleche che Yolamu ni che Yolamu ŵammeleche che Usia ni, ");
INSERT INTO yao_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Che Usia ŵammeleche che Yosamu ni che Yosamu ŵammeleche che Ahasi ni che Ahasi ŵammeleche che Esekiya ni, ");
INSERT INTO yao_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Che Esekiya ŵammeleche che Manase ni che Manase ŵammeleche che Amoni ni che Amoni ŵammeleche che Yosia ni, ");
INSERT INTO yao_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Che Yosia ŵammeleche che Yekonia ni achapwakwe. Keleko kaliji katema kakwasamichisya Ŵayahudi ku chilambo cha ku Babeli. ");
INSERT INTO yao_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nipele, Ŵayahudi paŵaiche ku chilambo cha Babeli, che Yekonia ŵammeleche che Sealitieli ni che Sealitieli ŵammeleche che Selubabeli ni, ");
INSERT INTO yao_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Che Selubabeli ŵammeleche che Abiudi ni che Abiudi ŵammeleche che Eliakimu ni che Eliakimu ŵammeleche che Asoli. ");
INSERT INTO yao_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Che Asoli ŵammeleche che Sadoki ni che Sadoki ŵammeleche che Akimu ni che Akimu ŵammeleche che Eliudi, ");
INSERT INTO yao_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Che Eliudi ŵammeleche che Eliasali ni che Eliasali ŵammeleche che Matani ni che Matani ŵammeleche che Yakobo, ");
INSERT INTO yao_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Che Yakobo ŵammeleche che Yusufu, ŵankwawo che Maliamu achikulugwe Che Yesu ŵakuŵilanjikwa Kilisito Jwakuwombola. ");
INSERT INTO yao_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pelepo paliji ni iŵelesi kumi na nne kutyochela che Iblahimu kwaichilila che Daudi, iŵelesi kumi na nne kutyochela che Daudi mpaka Ŵayahudi paŵajigalikwe ku usami ku Babeli ni iŵelesi kumi na nne kutyochela kwigalikwa ku usami kuichila katema ka Kilisito. ");
INSERT INTO yao_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yelei ni iŵatite pakupagwa Che Yesu Kilisito, che Maliamu, achikulugwe, ŵaliji atomelwe ni che Yusufu. Nambo akanaŵe kuwonegana mpela mundu ni ŵankwakwe, che Maliamu ŵalisimene ali ŵapachiilu kwa ukombole wa Mbumu jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nombe che Yusufu ŵankwakwe pakuŵa ŵaliji mundu jwambone paujo pa Akunnungu nganasaka kwachembulusya che Maliamu pa ŵandu, ŵasachile kwaleka pangaimanyilila ŵandu. ");
INSERT INTO yao_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nombewo paŵaliji aninkuganisya yeleyo, katumetume jwa kwinani jwa Ambuje ŵankopochele mu sagamisi, ŵansalile, “Che Yusufu mwana ju che Daudi nkajogopa kwajigala che Maliamu kuŵa ŵankwenu, ligongo ali ŵapachiilu kwa ukombole wa Mbumu jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Chaligopole mwanache jwannume nomwe chimwape liina lyakwe Che Yesu, pakuŵa jwelejo ni juchiŵakulupusye ŵandu ŵakwe mu sambi syao.” ");
INSERT INTO yao_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nipele yoseyo yakopochele kuti liŵe isyene, liloŵe lya Ambuje liŵaŵechete kwa litala lya jwakulondola jwa Akunnungu achitiji, ");
INSERT INTO yao_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mwalimwalipe chaŵe jwapachiilu, chaligopole mwanache jwannume, nombewo chachaŵilanga Emanueli” malumbo gakwe, “Akunnungu ali pamo ni uwe.” ");
INSERT INTO yao_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nombe che Yusufu paŵajimwiche, ŵatesile ilaila iŵatite pakusala katumetume jwa kwinani jwa Ambuje, ŵanjigele che Maliamu ŵankwawo ni kwaulanawo kumangwao. ");
INSERT INTO yao_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nambo nganawonegana nawo mpaka che Maliamu paŵaligopwele mwanache jwannume. Nombe che Yusufu ŵampele liina lyakwe Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Che Yesu ŵapagwile mmusi wa ku Beselehemu, muchilambo cha ku Yudea, kele katemako che Helode ali mwenye. Napagwa pe, ŵandu ŵaŵaimanyichisye nnope ndondwa kutyochela kungopochelo lyuŵa ŵaiche ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ŵausisye ŵandu, “Ana alikwapi mwanache jwapagwile, kuŵa Mwenye jwa Ŵayahudi? Tujiweni ndondwa jakwe pajikopochele kungopochelo lyuŵa ni weleu tuiche kukwapopelela.” ");
INSERT INTO yao_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mwenye che Helode paŵapilikene yeleyo ni ŵapwele ntima, ŵelewo pamo ni ŵandu wose ŵa ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nipele, ŵaaŵilasile pamo achakulungwa wose ŵambopesi ni ŵakwiganya Malajisyo ga Akunnungu gaŵapele che Musa, ŵausisye kuti, “Ana Kilisito Jwakuwombola chapagwe kwapi?” ");
INSERT INTO yao_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nombewo ŵajanjile, “Mu musi wa ku Beselehemu, muchilambo cha ku Yudea, pakuŵa yeleyo ni yaitite pakulembekwa ni jwakulondola jwa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mmwe Beselehemu chilambo cha ku Yudea, mmwe nganimma jwamwana kose pasikati misi ja chilambo cha ku Yudea, pakuŵa kutyochela kukwenu chakopochele chilongola juchiŵalongosye ŵandu ŵangu, Ŵaisilaeli.’ ” ");
INSERT INTO yao_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pelepo, che Helode ŵaaŵilasile pachisyepela ŵanyawo ŵaŵaimanyichisye nnope ndondwa ni ŵausisye katema chi jele ndondwa jo pijakopochele. ");
INSERT INTO yao_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nipele ŵatumile ku Beselehemu aninkuti, “Njaulanje nkauchilichisye uchenene ngani sya jwele mwanache. Mwamalaga kummona, nkauje kukuusalila, ni une jwakwe nyaule ngaatindiŵalile.” ");
INSERT INTO yao_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Paŵamalisisye kumpilikanila mwenye, ŵajendelechele ni ulendo wao nipele jele ndondwa jo jiŵajiweni kungopochelo lyuŵa jalongolele mmbujo mwao mpaka pajaiche ni kwima pachanya nyuumba jiŵaliji mwanache. ");
INSERT INTO yao_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Paŵajiweni jele ndondwa jo ŵasengwile nnope. ");
INSERT INTO yao_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ŵajinjile nkati ni ŵammweni mwanache jula pamo ni che Maliamu achikulugwe, ŵatindiŵalile ni kunkotamila. Pelepo ni ŵagopwele mmalombo gao ni ŵampele ntuuka, sahabu ni ubani ni mauta gagakuŵilanjikwa manemane. ");
INSERT INTO yao_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Akunnungu ŵakanyisye mu sagamisi kuti akaujila sooni ku che Helode, nipele ŵausile kumangwao kwa litala line. ");
INSERT INTO yao_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Paŵamasile kutyoka achalendo ŵala, katumetume jwa kwinani jwa Ambuje ŵankopochele che Yusufu mu sagamisi ni kwasalila, “Njimuche! Munjigale mwanache jo pamo ni achikulugwe ni mmutuchile ku Misili. Ntamanje kweleko mpaka pachinantanjile, pakuŵa che Helode akusaka kummulaga mwanache ju.” ");
INSERT INTO yao_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nipele che Yusufu ŵajimwiche ni kunjigala mwanache pamo ni achikulugwe, ŵatyosile chilo, ŵajawile ku Misili. ");
INSERT INTO yao_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ŵatemi kweleko mpaka che Helode paŵajasiche. Yeleyo yatendekwe kuti liloŵe liŵaŵechete Ambuje kwa litala lya jwakulondola jwakwe liŵe isyene, “Nammilasile mwanangu kutyochela ku Misili.” ");
INSERT INTO yao_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Che Helode paŵaimanyi kuti ŵaŵaimanyichisye ndondwa kwa nnope ŵala ŵalambwisye, ŵatumbile nnope. Ŵalajisye ŵandu ŵakwe akaaulaje ŵanache achanandi wose ŵachilume ŵapagwile ku Beselehemu ni mumbali mwakwe ŵaali ni yaka iŵili ni paasi ja pelepo. Ŵatesile yeleyo malinga ni katema paŵaimanyi kutyochela kwa ŵele ŵaŵaimanyichisye nnope ndondwa. ");
INSERT INTO yao_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yeleyo ni igatite kuŵa isyene maloŵe gagaŵechetekwe kwa litala lya che Yelemia juŵaliji jwakulondola jwa Akunnungu achitiji, ");
INSERT INTO yao_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Liloŵe lipikaniche ku Lama ko, kulila kwa kupeteka ni kulila kwa malumbo. Che Laheli akwalilila ŵanache ŵao, ni ngaakusaka kwamyalasya, pakuŵa ŵanache wose ajasiche.” ");
INSERT INTO yao_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Paŵawile che Helode, katumetume jwa kwinani jwa Ambuje ŵankopochele che Yusufu mu sagamisi ku Misili kula, ");
INSERT INTO yao_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ŵansalile, “Njimuche! Munjigale mwanache jo pamo ni achikulugwe, mmuje sooni ku chilambo cha Isilaeli, pakuŵa ŵandu ŵaŵasakaga kummulaga mwanache jo ŵamale kwasika.” ");
INSERT INTO yao_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nipele che Yusufu ŵajimwiche ni ŵanjigele mwanache pamo ni achikulugwe, ŵausile ku chilambo cha Isilaeli. ");
INSERT INTO yao_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nambo che Yusufu paŵapilikene kuti che Alikelao mwanache ju che Helode, akamulile umwenye wa atatigwe, ŵajogwepe kwaula ku Yudea. Nombe, paŵamasile kukanyikwa mu sagamisi, ŵajawile mbande sya ku Galilaya, ");
INSERT INTO yao_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ŵajawile kutama mu musi waukuŵilanjikwa ku Nasaleti. Yele ni iyatite pakuŵa isyene maloŵe gagaŵechetekwe kwa litala lya ŵakulondola ŵa Akunnungu gagakuti, “Chaŵilanjikwe jwa ku Nasaleti.” ");
INSERT INTO yao_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Agala moŵa gala ŵakopochele che Yohana Ŵakubatisya, ŵatandite kwalalichila ŵandu mu lipululu lya ku Yudea. ");
INSERT INTO yao_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ŵatite, “Nneche sambi, pakuŵa Umwenye wa kwinani uŵandichile.” ");
INSERT INTO yao_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aŵa ni ŵeŵala che Yohana ŵala, juŵagambagwa ni che Isaya jwakulondola jwa Akunnungu paŵatite, “Liloŵe lya mundu likuŵilanga mwipululu, ‘Mwakolochesye Ambuje litala lyakwe, ngolosyanje litala lyakwe.’ ” ");
INSERT INTO yao_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Che Yohana ŵawete chiwalo chichakolochekwe ni manyunya ga chinyama chachikuŵilanjikwa ngamia ni nkaanda wa lipende nchiunu mwao, chakulya chao chaliji itete ni uchi wa mwikonde. ");
INSERT INTO yao_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ŵandu ŵa ku Yelusalemu ni kutyochela kosekose ku chilambo cha Yudea ni ilambo yose yaili mungulugulu lusulo lwa Yolodani, ŵajaulile, ");
INSERT INTO yao_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ŵajitichisye sambi syao ni kuleka, nombewo ŵabatisye mu lusulo lwa Yolodani. ");
INSERT INTO yao_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nambo che Yohana paŵaweni Mafalisayo achajinji ni Masadukayo aninkwaichilila kuti ŵabatisye ni ŵaasalile, “Ŵanyamwe uŵelesi wa lijoka! Ŵaani ŵanjamwiche muuŵambale uchimwa wa Akunnungu waukwika? ");
INSERT INTO yao_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nnosye kwa isambo kuti nnesile sambi. ");
INSERT INTO yao_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nkaganisya ni kuliŵechetela muntima kuti, ‘Tukwete ambuje ŵetu che Iblahimu!’ Ngunsalila isyene kuti, Akunnungu akupakombola kugapanganya maganga ga gaŵe uŵelesi u che Iblahimu. ");
INSERT INTO yao_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sambano jino liŵago lili chile kata michiga ja itela, nipele, chitela chachili chose changasogola isogosi yambone chichigwisikwe ni kujasikwa pa mooto. ");
INSERT INTO yao_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Une ngumbatisyanga ni meesi kulosya kuti nnesile sambi. Nambo ŵakwika kunyuma kwangu akwete machili nnope kumbunda une, ni une nganguŵajilwa namose kwawula ilatu yao. Ŵelewo chambatisyanje ni Mbumu jwa Akunnungu ni kwa mooto. ");
INSERT INTO yao_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ŵelewo akwete lupeta mmakono mwao ali chile kupeta ngano. Chakumbikanye ngano jambone ni kutaga mu ngokwe ni ikambi kuitinisya pa mooto wangasimika.” ");
INSERT INTO yao_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kele katema ko Che Yesu ŵatyosile ku Galilaya ni kwika mu lusulo lwa Yolodani ku che Yohana, kuti nombewo abatiswe. ");
INSERT INTO yao_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nambo che Yohana ŵalinjile kwasiŵila aninkuti, “Une ni jungusachilwa kubatiswa ni mmwe sambano iŵele uli mmwe kwika kukwangu nambatisye?” ");
INSERT INTO yao_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nambo Che Yesu ŵajanjile, “Nneche kaje itendekwe yeleyo kwa sambano, pakuŵa ikusachilwa itendekwe yeila yose yaili yambone paujo pa Akunnungu.” Pelepo che Yohana ŵajitichisye. ");
INSERT INTO yao_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Che Yesu paŵamasile kubatiswa ŵatyosile mmeesi ni papopo kwinani kwaugwiche, ŵammweni Mbumu jwa Akunnungu achitulukaga mpela nguunda ni kwatula pachanya pakwe. ");
INSERT INTO yao_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nipele Liloŵe kutyochela kwinani lyaŵechete, “Jweleju ni Mwanangu jungunnonyela nonyelwe nawo.” ");
INSERT INTO yao_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nipele Mbumu jwa Akunnungu jwanlongwesye Che Yesu mwikonde kuti alinjikwe ni Shetani. ");
INSERT INTO yao_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Paŵatemi pangalya moŵa alobaini muusi ni chilo, mbesi jakwe jakwete sala. ");
INSERT INTO yao_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nipele Shetani ŵannyichilile, ni ŵansalile, “Iŵaga mmwe ndi Mwana jwa Akunnungu ngasalile aga maganga gagalauche gaŵe mikate.” ");
INSERT INTO yao_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Che Yesu ŵajanjile, “Ilembekwe mu Malembelo ga Akunnungu kuti, ‘Mundu ngakulama ni nkate pe, nambo kwa liloŵe lyalili lyose lyakuŵecheta Akunnungu.’ ” ");
INSERT INTO yao_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nipele, Shetani ŵanjigele Che Yesu mpaka ku Yelusalemu pa musi wa Akunnungu, ŵammisile penani pa lusonga lwa Nyuumba ja Akunnungu, ");
INSERT INTO yao_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ŵaasalile, “Iŵaga mmwe ndi Mwana jwa Akunnungu, nliponye paasi pakuŵa ilembekwe, ‘Akunnungu chachatuma achikatumetume ŵao ŵa kwinani kwa ligongo lyenu, channyakule mmakono mwao, ntakuligomba lukongolo lwenu pa liganga.’ ” ");
INSERT INTO yao_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Che Yesu ŵajanjile, “Ilembekwe sooni mu Malembelo ga Akunnungu, ‘Nkaalinga Ambuje Akunnungu ŵenu.’ ” ");
INSERT INTO yao_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nipele Shetani ŵanjigele Che Yesu sooni ku chitumbi cheleu ni kwalosya mwenye syose sya chilambo ni ukulu wakwe. ");
INSERT INTO yao_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ŵansalile, “Ni yose yi chinampe ni kuŵa yenu iŵaga chimundindiŵalile ni kumbopelela.” ");
INSERT INTO yao_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pelepo, Che Yesu ŵanjanjile, “Shetani ngambe kwaula! Ilembekwe mu Malembelo ga Akunnungu, ‘Chimwatindiŵalile Ambuje Akunnungu ŵenu ni kwapopelela ŵawowo pewo.’ ” ");
INSERT INTO yao_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nipele Shetani, ŵannesile Che Yesu, ni ŵaiche achikatumetume ŵa kwinani ni kwatumichila. ");
INSERT INTO yao_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Che Yesu paŵapilikene kuti che Yohana ataŵikwe mu nyuumba jakutaŵilwa ŵandu, ŵajawile ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ŵatyosile ku Nasaleti ni kwaula kutama ku Kapelenaumu musi wauli mbwani ja litanda lya Galilaya, mu chilambo cha Sabuloni ni Nafutali. ");
INSERT INTO yao_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yeleyo ni ilyatite pakuŵa isyene liloŵe lilyaŵechetekwe kwa litala lya che Isaya jwakulondola jwa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Chilambo cha ku Sabuloni ni chilambo cha ku Nafutali, litala lyalikwaula ku bahali, peesi lusulo lwa Yolodani, ku Galilaya, chilambo cha ŵandu ŵangaŵa Ŵayahudi! ");
INSERT INTO yao_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ŵandu ŵakutama mu chipi chaliwone lilanguka lyalikulungwa. Nombe ŵandu ŵakutamanga pa chilambo cha chipi ni pa mmwilili wa chiwa, lilanguka chilyalanguchisye!” ");
INSERT INTO yao_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kutandilila kele katema Che Yesu ŵatandite kulalichila achitiji, “Nneche sambi, pakuŵa Umwenye wa kwinani uŵandichile!” ");
INSERT INTO yao_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Che Yesu paŵajimajimaga mungulugulu litanda lya Galilaya, ŵaweni ŵanakajumo ŵaŵili ŵakukoka, che Simoni jwakuŵilanjikwa che Petulo ni che Andulea mpwakwe. Ŵaliji mu litanda aninkukoka somba kwa lwau pakuŵa ŵaliji ŵakukoka somba. ");
INSERT INTO yao_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Che Yesu ŵaasalile, “Munguye, none chinantende ŵanyamwe mme ŵakwaikanawo ŵandu kwa Ambuje.” ");
INSERT INTO yao_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Papopo ŵalesile nyau syao ni kwakuya. ");
INSERT INTO yao_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Paŵajawile mmbujo kanandi ŵaweni ŵanakajumo ŵane ŵaŵili che Yakobo ni che Yohana ŵanache ŵa che Sebedayo. Ŵanyawo ŵaliji mu ngalaŵa pampepe ni che Sebedayo atati ŵao aninkusaula nyau syao. Nipele Che Yesu ŵaaŵilasile. ");
INSERT INTO yao_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Papopo ŵajilesile ngalaŵa jila pamo ni atati ŵao, ni kwakuya. ");
INSERT INTO yao_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Che Yesu ŵajaulaga papalipose pala mu chilambo cha ku Galilaya, achijiganyaga mmajumba ga kupopelela ni kulalichila Ngani Jambone ja Umwenye wa Akunnungu. Ŵalamisye ŵandu ilwele yakupisyangana iŵaliji nayo. ");
INSERT INTO yao_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ngani syakwe syajenele mbande syose sya ku Silia. Ŵakulwala wose ŵaŵaliji ni ilwele yakupisyangana ni aŵala ŵakulaga, ŵaŵakamwilwe ni masoka ni ŵaali ni njilinjili ni ŵandu ŵakulemala ŵajawisye kweleko nombewo ŵalamisye ŵana wose. ");
INSERT INTO yao_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mipingo ja ŵandu achajinji kutyochela ku Galilaya ni ku Dekapoli yaani misi likumi ni ku Yelusalemu ni ku Yudea ni peesi lusulo lwa Yolodani ŵankuiye. ");
INSERT INTO yao_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Che Yesu paŵauweni mpingo wa ŵandu ŵakwesile pa chitumbi ni kutama. Ŵakulijiganya ŵao ŵajaulile, ");
INSERT INTO yao_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nombewo ŵatandite kwajiganya. ");
INSERT INTO yao_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Akwete upile ŵele ŵakwakulupilila Akunnungu, pakuŵa umwenye wa kwinani uli wao. ");
INSERT INTO yao_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Akwete upile ŵele ŵakulilasika muntima, pakuŵa chatulaswe. ");
INSERT INTO yao_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Akwete upile ŵele ŵakulitimalika, pakuŵa chapochele chilanga cha Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Akwete upile ŵele ŵajakwete sala ni njota ja kupanganya yaili yambone paujo pa Akunnungu, pakuŵa Akunnungu chachajikutisya. ");
INSERT INTO yao_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Akwete upile ŵaali ni chanasa kwa ŵane, pakuŵa chachikolelwa chanasa. ");
INSERT INTO yao_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Akwete upile ŵaali ni ntima wambone, pakuŵa chachawona Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Akwete upile ŵakwalumbanya ŵandu, pakuŵa ŵanyawo chachiŵilanjikwa ŵanache ŵa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Akwete upile ŵele ŵakusaukanga ligongo lya kupanganya yaili yambone paujo pa Akunnungu, pakuŵa Umwenye wa kwinani uli wao. ");
INSERT INTO yao_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nsangalale ŵanyamwe ŵandu pachachintukananga ni kunnagasya ni kummechetela yangalumbana kwa ligongo lyangu. ");
INSERT INTO yao_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nsangalale ni kuchina pakuŵa mbote jenu jili jekulungwa kwinani. Pakuŵa iyoyo peyo ni iŵapanganyichisye ŵakulondola ŵa Akunnungu ŵaŵapali nkanaŵe ŵanyamwe. ");
INSERT INTO yao_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ŵanyamwe ndi njete ja pachilambo! Nambo njete jasoyesyaga kulasa kwakwe chintaje chichi kuti unonye wakwe uujile sooni? Ngajikufai kulikose, nambo jikwasikwa paasa ni kuliŵatikwa ni ŵandu. ");
INSERT INTO yao_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ŵanyamwe ndi lilanguka lya pachilambo! Musi wautaŵikwe pachanya chitumbi ngaukukomboleka kusisika. ");
INSERT INTO yao_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ŵandu ngakupamba lumuli ni kuluunichila ni lulo, nambo akuluŵika pachanya chindu chakuŵichila lumuli pakuti lwalanguchisye ŵaali nkati mo. ");
INSERT INTO yao_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Iyoyo peyo lilanguka lyenu likusachilwa lilanguchisye paujo pa ŵandu, kuti aiwone isambo yenu yambone, ni ŵakusye Atati ŵenu ŵaali kwinani. ");
INSERT INTO yao_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nkaganisya kuti naiche kukugatyosya Malajisyo ni majiganyo ga ŵakulondola ŵa Akunnungu. Nganiika kukugatyosya nambo kukugamalichisya. ");
INSERT INTO yao_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngunsalila isyene kuti, mpaka pelepo kwinani ni chilambo pachiimale kupita, ngapagwa namose nukuta pane chindu chamwana mu malajisyo chachichityochekwe mpaka imalile yose. ");
INSERT INTO yao_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nipele, mundu jwalijose jwangajitichisya namose likanyo limo mmalamulo ga mwana ga ni kwajiganya ŵane, jwelejo chaŵe jwannandi nnope mu Umwenye wa kwinani. Nambo jwelejo juchalikamulichisye ni kwajiganya ŵane, jwelejo chaŵe jwankulungwa mu Umwenye wa kwinani. ");
INSERT INTO yao_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nipele ngunsalila kuti, iŵaga umbone wenu ngaupunda aula wa ŵakwiganya Malajisyo ga Akunnungu gaŵapele che Musa ni Mafalisayo nganjinjila ng'oo mu Umwenye wa kwinani. ");
INSERT INTO yao_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mpilikene kuti ŵandu ŵa chiikala ŵasalilwe kuti, ‘Nkaulaga! Juchaulaje akusachilwa alamulikwe.’ ");
INSERT INTO yao_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nambo une ngunsalila kuti, mundu jwalijose jwakuntumbilila mpwakwe, chiimbajile kulamulikwa. Jwakwachembulusya apwao chachajausya pa nkungulu. Ni jwakummilanga mpwao ‘Jwakuloŵela,’ chaŵajilwe kwinjila ku mooto wangasimika moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nipele mwapelekaga mbopesi jenu pa chilisa ni papopo mwakumbuchilaga kuti apwenu ŵana umenyani nomwe, ");
INSERT INTO yao_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","njileche mbopesi jenu mmbujo mwa chilisa, njaule kaje nkajilane ni mpwenu jo ni mmujeje ni kujityosya mbopesi jenu. ");
INSERT INTO yao_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Njilane chitema ni jwammagongo ndi mwitala nkanaŵe kwika ku nkungulu. Yapundaga pelepo jwammagongo jwenu chantaje mmakono mwa jwakulamula, nombe jwakulamula jo chantaje mmakono mwa jwangondo, nombejo champonye mu nyuumba jakutaŵilwa. ");
INSERT INTO yao_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ngunsalila isyene kuti, ngantyoka mwelemo mpaka pachimmalisye kulipa mbiya ja mbesi. ");
INSERT INTO yao_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mpilikene kuti, ŵandu ŵasalilwe, ‘Nkatenda chikululu!’ ");
INSERT INTO yao_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nambo une ngunsalila, kila mundu juchannolechesye jwankongwe kwa kunsaka, amasile kutenda chikululu nawo muntima mwakwe. ");
INSERT INTO yao_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nipele, iŵaga liso lyenu lya kundyo likunneŵasya nlityosye ni kulijasila kwakutalika. Mmbaya nnope kupotesya chiŵalo chenu chimo cha pachiilu, kupunda chiilu chenu chose chiponyekwe pa mooto wangasimika, moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ni iŵaga nkono wenu wa kundyo ukunneŵasya, nkate nkaujase kwakutalika. Mmbaya kukwenu kupotesya chiŵalo chimo cha chiilu kupunda chiilu chose chiponyekwe pa mooto wangasimika moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Iŵechetekwe kuti, ‘Jwakunleka ŵankwakwe, akusachilwa ŵaape talaka.’ ");
INSERT INTO yao_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nambo une ngunsalila kuti, kila mundu jwakunleka ŵankwakwe, pangaŵa kwa ligongo lya chikululu, akwatenda atende chikululu, nombe jwannume alombelaga jwankongwe jwalesilwe, akutenda chikululu. ");
INSERT INTO yao_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Sooni mpilikene kuti ŵandu ŵa kalakala ŵasalilwe kuti, ‘Nkalumbila kwa unami, nambo mpanganye mpela imwalumbile kupanganya kwa Ambuje.’ ");
INSERT INTO yao_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nambo une ngunsalila, nkalumbila ng'o, atamuno kwa kwinani, pakuŵa chili chitengu cha umwenye cha Akunnungu, ");
INSERT INTO yao_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","atamuno kulumbila kwa chilambo, pakuŵa chili chitengu chao cha kuŵichila makongolo, atamuno kulumbila kwa musi wa Yelusalemu, pakuŵa uli musi wa Mwenye jwankulu. ");
INSERT INTO yao_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Atamuno nkalumbila kwa ntwe wenu, pakuŵa ngankukombola kupanganya luumbo lumo kuŵa lweswela atamuno lwepiliu. ");
INSERT INTO yao_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mwatiji, ‘Elo’, jiŵe ‘Elo’, ni mwatiji, ‘Ngwamba’, jiŵe ‘Ngwamba’. Chachili chose cha kupunda yeleyo chikutyoka kwa jwangalumbana jula. ");
INSERT INTO yao_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mpilikene kuti isasilwe, ‘Liso kwa liso, ni Liino kwa liino.’ ");
INSERT INTO yao_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nambo une ngunsalila kuti, nkaliuchisya kwa jwangalumbana. Mundu jwalijose juchampute lijanda pa lijeje lya kundyo, mwagalauchisye ni lijakwe. ");
INSERT INTO yao_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mundu anjausyaga ku nkungulu kukummechetela magambo melepe ansumule lishati lyenu, munnechele ni likoti lyenu. ");
INSERT INTO yao_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mundu jwalijose ankanganichisyaga njigale nsigo wao njaule nawo kilomita jimo, njende nawo kilomita siŵili. ");
INSERT INTO yao_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jwakummenda mumpe, nombe jwakusaka kunkongola, ngasimwajima. ");
INSERT INTO yao_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mpilikene kuti isasilwe, ‘Munnonyele njenu ni munchime jwammagongo jwenu.’ ");
INSERT INTO yao_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nambo une ngunsalila, mwanonyele ŵammagongo ŵenu ni mwapopelele aŵala ŵakunlagasya, ");
INSERT INTO yao_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kuti mme ŵanache ŵa Atati ŵenu ŵaali kwinani. Pakuŵa akwalanguchisya lyuŵa lyakwe ŵandu ŵangalumbana ni ŵambone ni kwanyelela ula ŵandu ŵambone paujo pa Akunnungu ni ŵangalumbana. ");
INSERT INTO yao_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ana chimpate mbote chi mwanonyelaga pe ŵakunnonyela ŵanyamwe? Ngwamba! Pakuŵa ŵakukumbikanya nsongo nombe akutenda iyoyo? ");
INSERT INTO yao_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Iŵaga nkwakomasyaga achapwenu pe, ana ntesile chapi chakupunda kwapunda ŵane? Ana ngati ŵangakwamanyilila Akunnungu akutenda iyoyo. ");
INSERT INTO yao_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nipele mme ŵautindimisyo mu ntima kwati mpela Atati ŵenu ŵa kwinani yatite kuŵa jwautindimisyo. ");
INSERT INTO yao_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nlilolechesye, nkatenda yambone pa ŵandu kuti mmoneche. Pakuŵa mwatendaga yeleyo ngampegwa ntuuka kutyochela kwa Atati ŵenu ŵa kwinani. ");
INSERT INTO yao_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nipele pankunkamuchisya jwakulaga, nkagomba lipenga. Nkatenda mpela yakuti pakutenda ŵaulamba mmajumba ga kupopelela ni mmatala kuti ŵandu anlape. Ngunsalila isyene, ŵelewo ŵamale kupochela ntuuka wao. ");
INSERT INTO yao_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nambo mmwe pankunkamuchisya jwakulaga, ntende yeleyo mwakusisa namose ambusanga ŵenu akamanyilila, ");
INSERT INTO yao_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","nipele mwakamuchisye ŵakulaga mwakusisika ni Atati ŵenu ŵakulola yakusisika, chachimpa mbote. ");
INSERT INTO yao_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Sooni pankupopela, nkaŵa mpela ŵaulamba. Pakuŵa ŵelewo ikwanonyela kupopela achijimaga mmajumba ga kupopelela ni pamalekano melepe aoneche ni ŵandu. Ngunsalila isyene, ŵelewo ŵamale kupochela mbote jao. ");
INSERT INTO yao_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nambo mmweji pankupopela, njinjile nkati mwenu, mmugale nnango ni mwapopele Atati ŵenu ŵangakuwonekana. Nombe Atati ŵenu ŵakulola inkuipanganya kwakusisika, champe mbote. ");
INSERT INTO yao_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pankupopela, nkaŵecheta maloŵe ga wamba mpela ŵandu ŵangakwamanyilila Akunnungu. Pakuŵa ŵanyawo akuganisya kuti Akunnungu chachapilikanila kwa ligongo lya maloŵe gao gamajinji. ");
INSERT INTO yao_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nipele nkalandana ni ŵanyawo, pakuŵa Atati ŵenu akumanyilila chinkusaka nkanaŵe kwaŵenda. ");
INSERT INTO yao_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nipele ŵanyamwe mpopeleje yeleyi, ‘Atati ŵetu ŵandi kwinani, Liina lyenu lichimbichikwe kwannope. ");
INSERT INTO yao_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Umwenye wenu uiche. Chinkusaka cho chitendekwe pachilambo pano mpela kwinani. ");
INSERT INTO yao_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ntupe chakulya chetu cha lyuŵa ni lyuŵa. ");
INSERT INTO yao_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ntulechelesye ileŵo yetu, mpela uweji itukuti kwalechelesya wose ŵakutuleŵela. ");
INSERT INTO yao_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nkatujinjisya nkulinjikwa, nambo ntukulupusye ni jwangalumbana.’ Pakuŵa umwenye uli wenu ni machili ni ukulu moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Pakuŵa mwalechelesyaga ŵandu ileŵo yao, Atati ŵenu ŵa kwinani channechelesye ni ŵanyamwe ŵakwe. ");
INSERT INTO yao_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nambo iŵaga ngamwalechelesya ŵandu, nombe Atati ŵenu ŵa kwinani ngasannechelesya ni ŵanyamwe ŵakwe. ");
INSERT INTO yao_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pankutaŵa, ngasimma mpela ŵaulamba. Ŵanyawo akutaŵa sinya ku meeso kwao melepe awoneche ni ŵandu kuti akutaŵa. Nambo une ngunsalila isyene kuti ŵelewo ŵamale kupochela ntuuka wao. ");
INSERT INTO yao_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nambo mwe pankutaŵa, nsukusule ku meeso ni kupakala mauta muntwe, ");
INSERT INTO yao_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kuti ŵandu anamanyilile kuti nkutaŵa, nambo mmanyiche ni Atati ŵenu ŵangakuwoneka. Nombe Atati ŵenu pe ŵakulola yakusisika, chachimpa mbote jenu. ");
INSERT INTO yao_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nkaligosela mbiko pa chilambo pano pajikonasika ni idudu ni imbulukutu, ni ŵawiyi akwinjila ni kwiŵa. ");
INSERT INTO yao_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nambo nligosele mbiko kwinani kwangajonasika chindu ni idudu namose imbulukutu, atamuno ŵawiyi ngakukombola kwinjila ni kwiŵa. ");
INSERT INTO yao_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pakuŵa pajili mbiko jenu pele ntima wenu ni pachiuŵe. ");
INSERT INTO yao_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Liso lili lulanga lwa chiilu. Nipele liso lyenu lyaŵaga lyansima, chiilu chenu chose chichiŵe mu lilanguka. ");
INSERT INTO yao_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nambo liso lyenu lyaŵaga ngaŵa lyansima, chiilu chenu chose chichiŵe mu chipi. Nipele lilanguka lyalili nkati mwenu lyaŵaga mu chipi, chipi cho chili totoloo! ");
INSERT INTO yao_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ngapagwa jwakukombola kwatumichila achambuje ŵaŵili. Pakuŵa chanchime jumo ni kunnonyela jwine. Pane chanchimbichisye jumo ni kunnyelusya jwine. Ngankukombola kwatumichila Akunnungu nchitumichilaga mbiya kwanakamo. ");
INSERT INTO yao_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kwa lyele ligongo ngunsalila, ngasinlilagasya kwa ligongo lya umi wenu kuti chindye chichi ni ching'we chichi namose kwa ligongo lya iilu kuti chimmwale chichi. Pakuŵa umi utopele kupunda yakulya ni chiilu chitopele kupunda iwalo. ");
INSERT INTO yao_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nnyilole ijuni ya mwikonde, ngaikupanda namose ngaikugungula atamuno nganiikola ikuti yaili yose. Nambo Atati ŵenu ŵa kwinani akuilisya. Ŵanyamwe ndi wakutopela kwipunda ijuni yo. ");
INSERT INTO yao_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nipele, ŵaani mwa ŵanyamwe kwakulichenjeusya nnope akukombola kulijonjechesya namose lyuŵa limo mmoŵa ga umi wakwe? ");
INSERT INTO yao_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Yankati iwalo, kwachichi nkulajilila? Nnole uluŵa wa mwikonde yaukuti umele wakwe. Ngaukupanganya masengo atamuno ngaukuliluchila iwalo. ");
INSERT INTO yao_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nambo ngunsalila kuti, namose mwenye che Selemani ni ukulu wao wose nganawale yambone mpela limo lya uluŵa wo. ");
INSERT INTO yao_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nipele iŵaga Akunnungu akulitakusya yeleyo lisamba lya mwitinji lyalikumela lelo ni malaŵi likupatuka ni kwasikwa pa mooto ana ngati chantakusye kwakupunda ŵanyamwe ŵandi ni chikulupi chamwana? ");
INSERT INTO yao_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Nipele ngasinkola lipamba chindye chichi? Atamuno ching'we chichi? Namose chimbwale chichi? ");
INSERT INTO yao_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pakuŵa yose yo ikuchenjeuchilwa ni ŵandu ŵangakwamanyilila Akunnungu. Nambo mwanya Atati ŵenu ŵa kwinani akumanyilila kuti nkuilajila yele indu. ");
INSERT INTO yao_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nipele nsose kaje Umwenye wa Akunnungu ni kupanganya yaili yambone paujo pa Akunnungu, ni indu ine chiijonjechekwe kukwenu. ");
INSERT INTO yao_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nipele ngasinkola lipamba yankati malaŵi, pakuŵa malaŵi ikwete yakwe. Kulaga kwa lyuŵa limo kukunkwana kwa lyele lyuŵa. ");
INSERT INTO yao_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ngasimwalamula ŵane, kuti ni ŵanyamwe nkaika kulamulikwa ni Akunnungu, ");
INSERT INTO yao_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","pakuŵa chinchilamulikwa ni Akunnungu mpela inkuti kwalamula ŵane ni chipimo chilachila chinkupimila kwalamulila ŵane ni chichocho chachipimila Akunnungu kunlamula ŵanyamwe. ");
INSERT INTO yao_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ligongo chi nkulolechesya chiswani chachili mu liso lya mpwenu, ni papopo ngankulola chitela chachili mu liso lyenu? ");
INSERT INTO yao_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pane nkukombola chinauli kunsalila mpwenu kuti, ‘Mpwanga, nninde kaje nantyosye chiswani chachili mu liso lyenu’, akuno mu liso lyenu kwana chitela? ");
INSERT INTO yao_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jwaulamba mmwejo! Ntyosye kaje chitela chachili mu liso lyenu nipele chinlole uchenene ni kukombola kuchityosya chiswani chachili mu liso lya mpwenu. ");
INSERT INTO yao_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ngasimwapa mbwa chachili chachiswela, ngakaŵa chagalauche ni kumpalula, namose ngasimwajasila maguluŵe igogo yenu ya ndalama, ngakaŵa chailiŵate. ");
INSERT INTO yao_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mmende ni ŵanyamwe chimpegwe, nsose ni ŵanyamwe chinnyiwone, mpoposye ni ŵanyamwe chachimbugulila nnango. ");
INSERT INTO yao_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pakuŵa jwalijose jwakuŵenda akupegwa ni jwakusosa akwiwona ni jwakupoposya nnango ukuugulikwa kwa ligongo lyakwe. ");
INSERT INTO yao_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ana jwapi mwa ŵanyamwe, mwanache aŵendaga nkate chiŵape liganga? ");
INSERT INTO yao_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pane aŵendaga somba, chiŵape lijoka? ");
INSERT INTO yao_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Iŵaga ŵanyamwe ŵangalumbana, nkumanyilila kwapa achiŵana ŵenu indu yambone, isyene Atati ŵenu ŵa kwinani chatende mwakupunda, chiŵape yambone aŵala ŵakwaŵenda. ");
INSERT INTO yao_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nipele yose inkusaka ŵandu ampanganyichisye, ni ŵanyamwe ŵakwe mwapanganyichisye iyoyo. Pakuŵa gelega gali malumbo ga malajisyo ga che Musa ni majiganyo ga ŵakulondola ŵa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Njinjile kwa kupitila nnango wakunyilila. Pakuŵa litala lyalikwaula ku uwonasi lipangwiche, ni nnango wakwinjilila mwelemo uli wepanguche ni ŵakwinjila mwelemo atupile. ");
INSERT INTO yao_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nambo litala lya kwinjilila mu umi linyilile ni nnango wakwinjilila mwelemo uli wakunyilila ni ŵandu ŵakulimanyilila litala lyo nganatupa. ");
INSERT INTO yao_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nlilolechesye ni ŵakulondola ŵa unami. Ŵelewo akwika kukwenu ali nkuwoneka mpela ngondolo kwa paasa, nambo kwa munkati ali masogo gakalipa. ");
INSERT INTO yao_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Chimwamanyilile kwa isambo yao. Uli?, Ŵandu akukombola kukaŵa sabibu pa chitela cha miiŵa, pane tini pa nkwanga? Ngwamba! ");
INSERT INTO yao_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nipele, chitela chambone chikusogola isogosi yambone, ni chitela changalumbana chikusogola isogosi yangalumbana. ");
INSERT INTO yao_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Chitela chambone ngachikusogola isogosi yangalumbana, ni chitela changalumbana ngachikusogola isogosi yambone. ");
INSERT INTO yao_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Chitela chachili chose chingachikusogola isogosi yambone chachichigwisya ni kwasila pa mooto. ");
INSERT INTO yao_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nipele chinchamanyilila kwa isambo yao. ");
INSERT INTO yao_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ngaŵa kila mundu jwakumilanga, ‘Ambuje, Ambuje’, juchajinjile mu umwenye wa kwinani, nambo ajula jwakwitenda yakwisaka Atati ŵangu ŵaali kwinani. ");
INSERT INTO yao_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lyuŵa lya malamulo lyo ŵajinji chaasalile, ‘Ambuje, Ambuje! Uwe ni ŵeŵala utwalalichilaga ngani syenu kwa liina lyenu, ni kwa liina lyenu twagakoposyaga masoka ni kupanganya yakusimonjeka yejinji’ ");
INSERT INTO yao_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pelepo chinjasalila kwa kang'wa jangu, ‘Ŵanyamwe nganinammanya ng'o, ntyoche mmbujo mwangu, ŵanyamwe ŵankupanganya yaigongomalo.’ ");
INSERT INTO yao_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nipele jwalijose jwakugapilikana maloŵe gangu ni kugapanganya, akulandana ni mundu jwakwete lunda, jwataŵile nyuumba jakwe pa lwala. ");
INSERT INTO yao_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pajanyele ula, sulo syasewiche, mbungo japujile ni kujigomba nyuumba jila. Nambo nyuumba jo nganijigwa pakuŵa jaliji jitaŵikwe pachanya lwala. ");
INSERT INTO yao_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Nambo jwalijose jwakugapilikanila maloŵe gangu ga nombejo anapanganye chachili chose, jwelejo akulandana ni mundu jwakuloŵela jwataŵile nyuumba jakwe pa nsanga. ");
INSERT INTO yao_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pajanyele ula, sulo syasewiche, ni mbungo japujile, ni kujigomba nyuumba jila, nombejo jagwile ni kugumuka jose.” ");
INSERT INTO yao_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nipele, Che Yesu paŵamasile kuŵecheta maloŵe go, mpingo wa ŵandu ŵasimosile yatite kwiganya. ");
INSERT INTO yao_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pakuŵa ŵajiganyaga nti mundu jwali ni ukombole, ngaŵa mpela yakuti kwiganya ŵakwiganya Malajisyo ŵao. ");
INSERT INTO yao_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Che Yesu paŵatulwiche pa chitumbi, mipingo jekulungwa ja ŵandu jakuiye. ");
INSERT INTO yao_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nipele, ŵaiche mundu jwa matana, ŵatindiŵalile ni kwakotamila ni kuti, “Ambuje, mwasakaga, nkukombola kuswejesya!” ");
INSERT INTO yao_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Che Yesu ŵajongwele nkono, ŵakwayiye ni kuti, “Ngusaka, nswejele.” Papopo mundu jo ŵalamile matana gao. ");
INSERT INTO yao_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nipele Che Yesu ŵansalile, “Mpilikane, munansalile mundu jwalijose, nambo njaule nkalilosye kwa jwambopesi, nkatyosye mbopesi mpela iŵatite pakusala che Musa kwalosya ŵandu wose kuti nnamile.” ");
INSERT INTO yao_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Che Yesu paŵajinjilaga musi wa Kapelenaumu, chilongola jumo jwa ŵandu ŵangondo ŵa chilambo cha ku Loma ŵanjaulile ni kwachondelela ŵakamusye ");
INSERT INTO yao_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","achitiji, “Ambuje, katumetume jwangu agonile mu nyuumba atatele, ni akupotekwa nnope.” ");
INSERT INTO yao_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nipele Che Yesu ŵansalile, “Chiiche kukunnamya.” ");
INSERT INTO yao_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chilongola jwa ŵandu ŵangondo jo ŵanjanjile, “Ambuje, nganguŵajilwa mmwe njinjile mu nyuumba jangu. Nambo mmechete liloŵe pe ni katumetume jwangu chalame. ");
INSERT INTO yao_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pakuŵa noneji nombe ndili mundu jundi paasi pa ukombole wa achakulungwa, sooni ngwete ŵangondo paasi pa une. Nansalilaga jumo, ‘Njaule!’ Nombejo akwaula ni jwine, ‘Njise!’ Nombejo akwika ni kapolo jwangu, ‘Ntende achi!’, Nombejo akuchitenda.” ");
INSERT INTO yao_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nipele, Che Yesu paŵagapilikene maloŵe go, ŵasimosile, ni ŵasalile ŵandu ŵaŵaliji aninkwakuya, “Ngunsalila isyene, nganinammone mundu jwali ni chikulupi mpela achi namuno mu chilambo cha ku Isilaeli. ");
INSERT INTO yao_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nipele, ngunsalila kuti, ŵandu achajinji chaiche kutyochela kungopochelo lyuŵa ni kulikuswela lyuŵa, ni ŵanyawo chatame pachindimba cha chakulya pamo ni che Iblahimu ni che Isaka ni che Yakobo mu Umwenye wa kwinani. ");
INSERT INTO yao_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nambo ŵelewo ŵati aŵe mu Umwenye wo chaponyekwe paasa, pa chipi, kweleko chalile ni kuchilimya meeno.” ");
INSERT INTO yao_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nipele, Che Yesu ŵansalile chilongola jwa ŵandu ŵangondo jula, “Njaule kumangwenu ni itendekwe kukwenu mpela inkuti pakukulupilila.” Ni katumetume jwao ŵalamile katema kakoko. ");
INSERT INTO yao_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Che Yesu ŵaiche kumusi ku che Petulo, ŵasimene akwegwao ŵa chikongwe che Petulo ali agonile pachindanda, aninkulwala chiboko. ");
INSERT INTO yao_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nipele, Che Yesu ŵankwaiye nkono jwankongwe, nombewo ŵalamile ni ŵajimwiche ni kwatumichila. ");
INSERT INTO yao_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ligulo lyakwe, ŵaichisye ŵandu achajinji ŵaŵakamwilwe ni masoka, nombejo kwa litala lya majiganyo gakwe, ŵagaŵinjile masoka go ni kwalamya wose ŵaŵalwalaga. ");
INSERT INTO yao_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ŵatesile yeleyo kuti gamalile maloŵe gaŵaŵechete che Isaya jwakulondola jwa Akunnungu gagakuti, “Asyene akutyosisye kulaga kwetu, ni kutulamya ilwele yetu.” ");
INSERT INTO yao_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nipele, Che Yesu paŵauweni mpingo wa ŵandu uninkwasyungula, ŵaasalile ŵakulijiganya ŵao ajomboche ajaulangane peesi litanda. ");
INSERT INTO yao_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jwakwiganya Malajisyo jumo ŵanjaulile Che Yesu ni kwasalila, “Jwakwiganya, une chinankuye kwakulikose kuchinjaule.” ");
INSERT INTO yao_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Che Yesu ŵatite, “Macheto gakwete masomwa, ni ijuni ikwete isusi, nambo Mwana jwa Mundu nganakola peuto pakupumulila.” ");
INSERT INTO yao_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nipele, mundu jwine mwa ŵakulijiganya ŵao ŵansalile, “Ambuje muuneche kaje nyaule ngaasiche atati ŵangu.” ");
INSERT INTO yao_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nambo Che Yesu ŵansalile, “Munguye, mwaleche ŵawe ŵaasiche ŵawe ŵao.” ");
INSERT INTO yao_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Che Yesu ŵajinjile mu ngalaŵa ni ŵakulijiganya ŵao ŵajawile nawo. ");
INSERT INTO yao_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Chisisimuchile jatandite kupuga chimbunga chekulungwa mu litanda ni matumbela gatandite kujiunichila ngalaŵa. Nambo Che Yesu ŵaliji agonile lugono. ");
INSERT INTO yao_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ŵakulijiganya ŵao ŵajaulile kukwajimusya achitiji, “Ambuje ntukulupusye, tulinkwasika!” ");
INSERT INTO yao_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Che Yesu ŵaasalile, “Ŵanyamwe ŵandu ŵandi ni chikulupi chamwana, ligongo chi nkogopa?” Nipele, ŵajinamukwiche, ni kuchikalipila chimbunga ni matumbela, ni kwatulele jii. ");
INSERT INTO yao_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ni ŵandu ŵasimonjile ni ŵatite, “Ana mundu ju ali jwanti uli? Namuno chimbunga ni matumbela ikwapilikanila!” ");
INSERT INTO yao_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Che Yesu paŵaiche peesi litanda mu chilambo cha Ŵagelasi, ŵandu ŵaŵili ŵaŵakamwilwe ni masoka ŵasimene nawo achikopochelaga kumalembe. Ŵandu wo ŵajogoyaga nnope, namose ŵandu nganapitaga litala lyo. ");
INSERT INTO yao_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nipele, ŵatandite kunyanyisya achitiji, “Nkusaka ichichi kwetuwe, alakwe Mwana jwa Akunnungu? Ana nnyiche kukutulagasya kakanaŵe katema ketu?” ");
INSERT INTO yao_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chiŵandi ni pelepo kwaliji ni mpingo wa maguluŵe ganinkulya. ");
INSERT INTO yao_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nipele, masoka gala gaachondelele Che Yesu ganinkuti, “Iŵaga nkutukoposya, ntusalile tukagajinjile maguluŵe gala.” ");
INSERT INTO yao_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Che Yesu ŵagasalile, “Ayaga, njaule.” Papopo gakopweche kwa ŵandu ŵala ni kwinjila mmaguluŵe. Mpingo wose wa maguluŵe waselelechele mu litanda ni maguluŵe gose gawile mmeesi. ");
INSERT INTO yao_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ŵakuchinga maguluŵe gala ŵautwiche, ŵajawile mmusi. Kweleko ŵaasalile ŵandu ngani syose ni indu iyasimene ŵandu ŵaŵili ŵaŵakamwilwe ni masoka ŵala. ");
INSERT INTO yao_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nipele, ŵandu wose ŵa musi wo ŵatyosile kukwachingamila Che Yesu, paŵaweni ŵachondelele kuti atyoche mu chilambo chao. ");
INSERT INTO yao_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Che Yesu ŵajinjile mu ngalaŵa, ŵajombweche litanda ni kwika mmusi wao. ");
INSERT INTO yao_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pelepo ŵandu ŵampeleche mundu jumo jwatatele chiilu, ali agonile mu chitagala. Nipele Che Yesu paŵachiweni chikulupi chao, ŵansalile mundu jwakutatala jula, “Muusimane mtima, ambusanga! Nlecheleswe sambi syenu.” ");
INSERT INTO yao_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nipele, ŵakwiganya Malajisyo ŵane ŵatandite ganisya mmitima jao aninkuti, “Mundu ju akwatukana Akunnungu!” ");
INSERT INTO yao_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Che Yesu ŵasimanyi ng'anisyo syao ni ŵausisye, “Kwachichi nkuganisya yangalumbana mmitima jenu? ");
INSERT INTO yao_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Chichi chili chakwepepala nnope, kusala, ‘Sambi syenu silecheleswe,’ pane kusala, ‘Njimuche, Njaule?’ ");
INSERT INTO yao_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nambo, ngusaka mmanyilile kuti Mwana jwa Mundu akwete ukombole pa chilambo pano wa kwalechelesya ŵandu sambi syao.” Pelepo ŵansalile jwakutatala jo, “Njimuche, njigale chitagala chenu njaule kumangwenu.” ");
INSERT INTO yao_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nipele, mundu jo ŵajimwiche ni kwaula kumangwao. ");
INSERT INTO yao_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ŵandu wose mu mpingo wo paŵaiweni yeleyo, ŵasimosile ni kukamulwa ni lipamba, ŵaakusisye Akunnungu uŵapele ŵandu ukombole wanti yele. ");
INSERT INTO yao_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Che Yesu ŵatyosile pelepo, ni paŵajaulaga, ŵambweni mundu jumo ali atemi mu nyuumba ja kulipila nsongo liina lyakwe che Matayo. Nipele Che Yesu ŵansalile, “Munguye.” Nombe che Matayo, ŵajimwiche ni kwakuya. ");
INSERT INTO yao_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Che Yesu paŵaliji mu nyuumba ji che Matayo kulya chakulya, ŵakukumbikanya nsongo ŵajinji ni ŵaali ni sambi ŵaiche ni kutama pamo nawo ni ŵakulijiganya ŵao. ");
INSERT INTO yao_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo paŵaiweni yeleyo, ŵausisye ŵakulijiganya ŵa Che Yesu, “Kwachichi jwakunjiganya akulya pamo ni ŵakukumbikanya nsongo ni ŵaali ni sambi?” ");
INSERT INTO yao_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Che Yesu ŵagapilikene gelego ni ŵajanjile, “Ŵangakulwala ngakwalajila ŵantela, ikaŵe ŵakulwala ni ŵakwalajila ŵantela. ");
INSERT INTO yao_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nipele, njaule nkalijiganye malumbo ga maloŵe ga, ‘Ngusaka chanasa, ngaŵa mbopesi.’ Nganiika kukwaŵilanga ŵandu ŵakupanganya yambone paujo pa Akunnungu nambo ŵaali ni sambi.” ");
INSERT INTO yao_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nipele, ŵakulijiganya ŵa che Yohana Ŵakubatisya ŵajaulile Che Yesu ni kwausya, “Uweji ni Mafalisayo tukutaŵa kaŵilikaŵili, kwachichi ŵakulijiganya ŵenu ngakutaŵa?” ");
INSERT INTO yao_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Che Yesu ŵajanjile, “Uli, nkuganisya kuti nkukombola kwatendekasya achambusanga ŵa mlombela asupuche akuno ali pamo nawo? Ngwamba! Nambo chikaiche katema pachajigalikwe mlombela jo pasikati jao, gele moŵa go chachitaŵa. ");
INSERT INTO yao_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ngapagwa mundu jwakutotela chigamba cha nguo jasambano mu nguo jewisale. Atamuno atendaga yeleyo chigamba chasambano cho chichipapule nguo jo, ni upapuche wakwe chiupundanganye. ");
INSERT INTO yao_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sooni ngapagwa ŵandu ŵakutaga divai jasambano mu misaku jewisale jekolochekwe ni mapende. Pakuŵa jele divai jasambano jo chijipapule misaku ni divai chijimwasiche ni misaku jo chijijonasiche. Nambo ŵandu akutaga divai jasambano mu misaku jasambano ni yose yana iŵili ikugosekwa.” ");
INSERT INTO yao_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nipele, Che Yesu paŵaliji nkuŵecheta gelego, ŵaiche chilongola jumo jwa Chiyahudi, ŵatindiŵalile ni kuti, “Mwali jwangu akuwa sampano. Nambo, choonde twende nkaasajichile nkono wenu kuti akole umi.” ");
INSERT INTO yao_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Che Yesu ŵajimi ni kunkuya, ŵakulijiganya ŵao ŵajawile pamo nawo. ");
INSERT INTO yao_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jwakopochele jwankongwe jumo juŵalwalaga magono kwa yaka likumi ni iŵili, ŵannyichilile Che Yesu panyuma, ŵakwaiye lujenje lwa mwinjilo wao. ");
INSERT INTO yao_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ŵatesile yeleyo pakuŵa ŵaganisisye muntima mwao kuti, “Nakwayaga pe mwinjilo wakwe, chilame.” ");
INSERT INTO yao_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nombe Che Yesu ŵagalawiche, ŵamweni ni ŵansalile, “Muusimane ntima, mwanangu, chikulupi chenu chinnamisye.” Jwankongwe jo ŵalamile katema kakoko. ");
INSERT INTO yao_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nipele Che Yesu ŵaiche mu nyuumba ja chilongola jula. Ni ŵaweni ŵakugomba ipeta ni mpingo wa ŵandu aninkulila kwa malumbo, ");
INSERT INTO yao_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ni ŵatite, “Ntyochanje pelepa, pakuŵa mwali ju nganajasika, agambile gona pe.” Ni ŵanyawo ŵaasechile. ");
INSERT INTO yao_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ŵandu ŵala paŵaŵinjikwe, Che Yesu ŵajinjile nkati, ŵankamwile nkono mwali jula, nombejo ŵajimwiche. ");
INSERT INTO yao_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ngani jila jajenele pa chilambo pala pose. ");
INSERT INTO yao_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Che Yesu ŵatyosile pelepo, ni paŵaliji nkwaula, ŵandu ŵaŵili ŵangakulola ŵankuiye achinyanyisyaga, “Choonde Mwana ju che Daudi ntukolele chanasa!” ");
INSERT INTO yao_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Che Yesu paŵajinjile mu nyuumba, ŵangakulola wala ŵajaulile, nombejo ŵausisye, “Ana nkukulupilila kuti ngukombola kunlamya?” Nombewo ŵajanjile, “Elo, Ambuje.” ");
INSERT INTO yao_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pelepo Che Yesu ŵagakwaiye meeso gao, ŵatite, “Iŵeje kukwenu mpela inkuti pakukulupilila.” ");
INSERT INTO yao_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Meeso gao gaugwiche. Nombe Che Yesu ŵakanyisye kwa nnope kuti, “Ngasimunsalila mundu jwalijose ngani ji.” ");
INSERT INTO yao_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nambo ŵanyawo ŵatyosile ni kutanda kwenesya ngani si Che Yesu mchilambo chila chose. ");
INSERT INTO yao_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ŵandu ŵaŵili ŵala paŵaliji nkutyoka, ŵandu ŵane ŵannyichisye Che Yesu mundu jumo jwangakuŵecheta kwa ligongo lya kukamulwa ni masoka. ");
INSERT INTO yao_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Paŵankopwesye masoka papopo mundu jwangakuŵecheta jula, ŵatandite kuŵecheta. Ŵandu ŵasimosile nikuti, “Nganigawoneche kose gelega mu chilambo cha ku Isilaeli!” ");
INSERT INTO yao_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nambo Mafalisayo ŵatite, “Akugakoposya masoka kwa machili ga jwankulu jwa masoka.” ");
INSERT INTO yao_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Che Yesu ŵasyungwile mose mmisi ni mmisinda jose, achijiganyaga mmajumba gao ga kupopelela, ni kulalichila Ngani Jambone ja Umwenye wa Akunnungu ni kwalamisya ŵandu ilwele yose ni kulaga kwakulikose. ");
INSERT INTO yao_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nipele, paŵaweni ŵandu, mipingo kwa mipingo, ŵakolele chanasa pakuŵa ŵapesile ni kukola lipamba chisau ngondolo syangali ni jwakuchinga. ");
INSERT INTO yao_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pelepo ŵaasalile ŵakulijiganya ŵao, “Magungulo gali gamajinji, nambo ŵakugungula nganatupa. ");
INSERT INTO yao_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nipele mwapopele Ambuje ŵa magungulo, apeleche ŵakupanganya masengo mmagungulo gao.” ");
INSERT INTO yao_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Che Yesu ŵaaŵilasile pamo ŵakulijiganya ŵao likumi ni ŵaŵili, ŵapele ukombole wa kugakoposya masoka, ni kwalamya ŵandu ilwele yose ni kulaga kwakulikose. ");
INSERT INTO yao_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ni meena ga ŵele achinduna likumi ni ŵaŵili wo gali gelega: Che Simoni jwakuŵilanjikwa che Petulo ni che Andulea mpwao, che Yakobo mwanagwao che Sebedayo ni che Yohana mpwao, ");
INSERT INTO yao_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Che Filipo ni che Batolomayo, che Tomasi ni che Matayo juŵaliji jwakukumbikanya nsongo, che Yakobo mwanagwao che Alufayo ni che Tadayo, ");
INSERT INTO yao_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Che Simoni jwa ku Kanani ni che Yuda Isikaliote juŵangalawiche Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nipele, Che Yesu ŵaatumile ŵanyawo kumi na mbili ni kwapa ulamusi achitiji: “Nkajaula mmajumba ga ŵandu ŵangaŵa Ŵayahudi, atamuno nkajinjila mmisi ja Ŵasamalia. ");
INSERT INTO yao_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nambo njaule kwa ŵandu ŵa ku Isilaeli ŵasochelele mpela ngondolo syangali ni jwakuchinga. ");
INSERT INTO yao_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pinkwaulanga nkalalicheje yeleyi, ‘Umwenye wa kwinani uŵandichile.’ ");
INSERT INTO yao_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nkaalamye ŵakulwala, nkaasyusye ŵawile, nkaaswejesye ŵaali ni matana, nkagakoposye masoka. Mwapochele pangali malipilo, nkapeleganye pangali malipilo. ");
INSERT INTO yao_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kasinjigala sahabu atamuno mbiya atamuno makobili ga shaba mu ulendo wenu. ");
INSERT INTO yao_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nkajigala nsaku wa ulendo atamuno mwinjilo waaŵili, atamuno ilatu, atamuno nkongojo. Pakuŵa jwakupanganya masengo immajile kupegwa chakulya chakwe. ");
INSERT INTO yao_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Sooni pachinkajinjile mu musi wauli wose atamuno mu nsinda, nkasose mwelemo mundu juchasache kumpochela, ni nkalonjele mwelemo mpaka pachinkatyoche. ");
INSERT INTO yao_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pachinjinjile mu nyuumba mwakomasye nchitiji, ‘Chitendewele chiŵe kukwenu.’ ");
INSERT INTO yao_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nipele, ŵele ŵakutama mu nyuumba mo ampochelaga, chitendewele chenu chichitame kwa ŵanyawo. Nambo yaŵaga ngakumpochela, nipele, chitendewele chenu chichimmujile mwachinsyene. ");
INSERT INTO yao_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nipele, akanaga kumpochela mundu jwalijose atamuno kugapilikana maloŵe genu, pachinkopoche mu jele nyuumba jo atamuno mu wele musi wo, nkung'unde luundu mmakongolo mwenu kulosya kuti mkwajamuka. ");
INSERT INTO yao_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngunsalila isyene, lyuŵa lya malamulo, ŵandu ŵa wele musi wo chakole magambo gamakulungwa kupunda gegala ga ku Sodoma ni ku Gomola. ");
INSERT INTO yao_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nnole, nguntuma ŵanyamwe mpela ngondolo mmasogo. Nipele nkole lunda mpela majoka, ni ŵakulitimalika mpela nguunda. ");
INSERT INTO yao_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mlilolechesye ni ŵandu, pakuŵa chachinjausya ŵanyamwe pankungulu ni chachimputa mbokola mmajumba gao ga kupopelela. ");
INSERT INTO yao_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chachinjausya kwa achakulu ni mamwenye kwa ligongo lyangu une, mpatanje kwasalila ŵanyawo Ngani Jambone jankati une ni kwa ŵandu ŵangaŵa Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nipele pachachinjausya ŵanyamwe pa nkungulu, nkakola lipamba lyati chimmechete chichi pane chimmechete chinauli, pichikaiche katema, chimpegwe chakuŵecheta. ");
INSERT INTO yao_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pakuŵa ngaŵa ŵanyamwe ni uchimmechete, nambo Mbumu jwa Atati ŵenu jwaali nkati mwenu ni juchaŵechete. ");
INSERT INTO yao_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nipele, jwankulungwa changalauche jwamnung'una aulajikwe, ni atati changalauche mwanagwe, ni ŵanache chiŵagalauche achaŵelesi ŵao ni kwaulaga. ");
INSERT INTO yao_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ŵandu chanchimanje ŵanyamwe kwaligongo lya kuungulupilila une. Nambo juchapililile mpaka kumbesi, jwelejo ni juchakulupuche. ");
INSERT INTO yao_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Annagasyaga ŵandu mmusi umo, mmutuchilanje mmusi wine. Ngunsalila isyene, ngammalisya kuutuchila misi jinajose ja ku Isilaeli akanaŵe kwika Mwana jwa Mundu. ");
INSERT INTO yao_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Jwakulijiganya ngakumpunda jwakwiganya pane kapolo ngakumpunda mmbujegwe. ");
INSERT INTO yao_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Paichile pa jwakulijiganya kuŵa mpela jwakujiganya ni kapolo mpela mmbujegwe. Iŵaga ammilasile nsyene nyuumba Belesebuli, uli ana ngati chakapunde kwaŵilanga ŵandu ŵaali mu nyuumba jo meena gakusakala nnope. ");
INSERT INTO yao_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nipele, kasimwajogopa ŵandu. Pakuŵa kila chindu cheunichikwe chichiŵe cheunukukwe, ni kila chachisisikwe chichimanyiche. ");
INSERT INTO yao_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chingunsalila pa chipi, nchisale palulanga, ni chinkupilikana mwipikanilo kwakunsongonela, nkachisale kwa ŵandu pangasisa. ");
INSERT INTO yao_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kasimwajogopa ŵakuchiulaga chiilu, nambo ngakukombola kujiulaga mbumu. Mmbaya mwajogope ŵakukombola kuchijonanga chiilu ni mbumu ku mooto wangasimika moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ijojolo iŵili ikusumichikwa kwa senti jimo. Namose ngapagwa hata chimo chachikuwa pangali Atati ŵenu kusaka. ");
INSERT INTO yao_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nambo kukwenu ŵanyamwe, atamuno umbo sya muntwe wenu nombe nasyo siŵalanjikwe syose. ");
INSERT INTO yao_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kwayele ngasinjogopa, ŵanyamwe ndi ŵakutopela mwakuipunda ijojolo. ");
INSERT INTO yao_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nipele, jwalijose jwakunyitichisya une paujo pa ŵandu kuti jwele ali jwangune, noneji chinankunde jwelejo paujo pa Atati ŵangu ŵaali kwinani. ");
INSERT INTO yao_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nambo jwalijose juchachingana paujo pa ŵandu, noneji chinamkane paujo pa Atati ŵangu ŵaali kwinani. ");
INSERT INTO yao_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nkaganisya kuti ichenawo chitendewele pachilambo pano. Ngwamba! Nganiikanawo chitendewele nambo ichenawo ngondo. ");
INSERT INTO yao_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Pakuŵa iche kukuntindanya mundu ni atatigwe, mwali ni achikulugwe, akwegwe ni nkwegwakwe. ");
INSERT INTO yao_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ni ŵammagongo ŵa mundu chaŵe ŵandu ŵaali mu nyuumba jakwe. ");
INSERT INTO yao_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Jwakunnonyela atatigwe pane achikulugwe kumbunda une, jwelejo ngakuŵajilwa kuŵa jwakulijiganya jwangu. Ni jwakunnonyela mwana jwannume pane mwana jwankongwe kumbunda une, jwelejo ngakuŵajilwa kuŵa jwakulijiganya jwangu. ");
INSERT INTO yao_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mundu jwangakuujigala nsalaba wakwe ni kunguya, jwelejo ngakuŵajilwa kuŵa jwakulijiganya jwangu. ");
INSERT INTO yao_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nipele, jwalijose jwakuugosa umi wakwe, chaujase, nambo jwele juchautyosye umi wakwe kwa ligongo lya kungulupilila une, chachiusimana. ");
INSERT INTO yao_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Jwakumpochela ŵanyamwe, akumbochela une ni jwakumbochela une, akwapochela ŵele ŵandumile une wo. ");
INSERT INTO yao_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jwakumpochela jwakulondola jwa Akunnungu ligongo atekuŵa jwakulondola, chachipochela mbote ja jwakulondola. Nombe jwakumpochela mundu jwakupanganya yambone paujo pa Akunnungu pakuŵa ali jwambone, chachipochela mbote ja mundu jwakupanganya yambone paujo pa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ngunsalila isyene, jwalijose juchachimpa jumo jwa ŵangamanyika kwannope ŵa ngao wa meesi gamasisi, pakuŵa ali ŵakulijiganya ŵangu, isyene, jwelejo chachipochela mbote jakwe.” ");
INSERT INTO yao_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nipele, Che Yesu paŵamalisisye kwalajisya ŵakulijiganya ŵao likumi ni ŵaŵili, ŵatyosile kweleko, ŵajawile kwiganya ni kulalichila mmisi jajili ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nombe che Yohana paŵaliji mu nyuumba jakutaŵilwa ŵapilikene ngani ja masengo ga Kilisito Jwakuwombola, ŵaatumile ŵakulijiganya ŵao, ");
INSERT INTO yao_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","akausye, “Ana mmwe ni ŵele ŵakwika ŵala pane twalolele ŵane?” ");
INSERT INTO yao_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Che Yesu ŵaajanjile, “Njaulanje nkaasalile che Yohana aila inkuipilikana ni kuilola. ");
INSERT INTO yao_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ŵangalola akulola, ni ŵangajenda akwenda, ni ŵamatana akuswejeswa, ni ŵangapilikana akupilikana, ni ŵawe akusyuswa, ni ŵakulaga akusalilwa Ngani Jambone. ");
INSERT INTO yao_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jwana upile jwele mundu jwangakungolela lipamba.” ");
INSERT INTO yao_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nipele, ŵele ŵakulijiganya ŵa che Yohana paŵaliji nkwenda, Che Yesu ŵatandite kwasalila ŵandu ngani si che Yohana aninkuti, “Ana mwajawile kukulola chichi kwele kwipululu ko? Uli, mwajawile kukulilola litete lili nkupungunyikwa ni mbungo?” ");
INSERT INTO yao_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Iŵaga ngaŵa yeleyo ana mwajawile kukulola chichi? Mwajawile kukunnola mundu jwawete iwalo yambone? Ŵandu ŵakuwala iwalo yambone akutama mmajumba ga mamwenye. ");
INSERT INTO yao_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nambo, ana mwajawile kukulola chichi? Mwajawile kukunnola Jwakulondola jwa Akunnungu? Elo, ngunsalila, jwakumpunda jwakulondola jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jwelejo ni che Yohana, Akunnungu juŵangambaga mmalembelo ga Akunnungu, Nnole, nguntuma jwantenga jwangu mmbujo mwenu, juchakankolochesye litala lyenu. ");
INSERT INTO yao_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngunsalila isyene, mwa ŵandu ŵakutama mu chilambo, nganatyochele mundu jwali jwankulungwa kumpunda che Yohana Ŵakubatisya. Nambo jwalijose jwakulolechela jwannandi mu Umwenye wa kwinani ali jwankulungwa kumpunda jwelejo. ");
INSERT INTO yao_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Chitandile katema kaŵalalichilaga che Yohana Ŵakubatisya mpaka lelo, umwenye wa kwinani ukukanikwa, ni ŵandu ŵaali ni machili akulinga kuujigala kwa machili. ");
INSERT INTO yao_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Majiganyo gose ga ŵakulondola ŵa Akunnungu ni Malajisyo gakunguluchile ngani ja umwenye wa Akunnungu mpaka katema ka che Yohana. ");
INSERT INTO yao_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iŵaga nkusaka kwitichisya gelega, che Yohana ju ni che Elia juchaiche. ");
INSERT INTO yao_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jwakwete mapilikanilo, apilikane! ");
INSERT INTO yao_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Chinaulandanye ni chichi uŵelesi wu? Ulandene ni achachanda ŵaŵatemi paluŵala lwa kusumichisya malonda, ni kuŵechetesyana ni achinjao, ");
INSERT INTO yao_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Twangombele ngoma nambo nganintyala! Twanjimbile nyimbo sya pamalilo nambo nganinlila!’ ");
INSERT INTO yao_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pakuŵa Che Yohana ŵaiche, ŵataŵaga ni nganang'waga divai, ni ŵanyawo ŵatite, ‘Akamwilwe ni masoka.’ ");
INSERT INTO yao_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana jwa Mundu ŵaiche, achilyaga ni aching'waga ni ŵanyawo ŵatite, ‘Munnole aju, jwakutolwa ni jwakolelwa, mmbusanga jwa ŵakukumbikanya nsongo ni ŵa sambi!’ Nambo lunda lwa Akunnungu lwawoneche kuŵa lwambone kwa litala lya ipanganyo yakwe.” ");
INSERT INTO yao_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nipele, Che Yesu ŵatandite kwakalipila ŵandu ŵa misi jo jiŵatesile yakusimonjeka, nambo ŵandu ŵakwe nganaleka sambi. ");
INSERT INTO yao_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ulaje kukwenu ku Kolasini! Ulaje kukwenu ku Besesaida! Pakuŵa, ayi yakusimosya yaitendekwe kukwenu, ikatendekwe akula ku Tilo ni ku Sidoni kula, ŵandu ŵakwe akawasile magunia ni kutama mu itutu kulosya kuti alesile sambi syao. ");
INSERT INTO yao_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nambo ngunsalila, lyuŵa lya kulamula, ŵanyamwe chinjamukwe kwannope kupunda ŵandu ŵa ku Tilo ni ku Sidoni. ");
INSERT INTO yao_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nomwe Kapelenaumu ana chinlikusye mpaka kwinani? Chinchituluswa mpaka kwiuto kwa ŵandu ŵawile. Pakuŵa, yakusimosya yaitendekwe kukwenu ikatendekwe ku Sodoma, wele musi wo ukaliji chiŵela mpaka lelo. ");
INSERT INTO yao_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nambo ngunsalila, lyuŵa lya kulamula mmwe chinjamukwe kwannope kupunda ŵandu ŵa ku Sodoma.” ");
INSERT INTO yao_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Katema kakoko, Che Yesu ŵatite, “Nguntogolela Atati, Ambuje ŵa kwinani ni chilambo, pakuŵa mwasisile indu yi ŵandu ŵa lunda ni ŵandu ŵa umanyilisi ni kwaunukulila ŵanache. ");
INSERT INTO yao_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Elo, Atati, pakuŵa yeleyo ni yaitite pakunnonyela. ");
INSERT INTO yao_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Atati ŵangu ambele indu yose. Ngapagwa jwakummanyilila Mwana, akaŵe Atati, ni sooni ngapagwa jwakummanyilila Atati, akaŵe Mwana ni jwalijose jwakunsaka Mwana kuti ammunukulile. ");
INSERT INTO yao_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Njisanje kukwangu ŵanyamwe wose unkusauka ni kutopelwa ni misigo jakutopa, none chinampumusye. ");
INSERT INTO yao_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mungunde, nkalijiganye kukwangu, pakuŵa une ndili jwakutulala ni jwakulitulusya, nomwe chinkapumule mmitima jenu. ");
INSERT INTO yao_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pakuŵa chingunsalila mpanganye chili chambone kukwenu ni chingumpa njigale ngachikutopa.” ");
INSERT INTO yao_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kele katema ko Che Yesu ŵapitaga mmigunda ja ngano pa Lyuŵa lya Kupumulila. Nipele, ŵakulijiganya ŵao jakwete sala, ŵatandite kupulula masache ga ngano ni kulya. ");
INSERT INTO yao_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nambo Mafalisayo paŵaiweni yeleyo, ŵaasalile Che Yesu, “Nnole, ŵakulijiganya ŵenu akugapanganya gamakanye kugapanganya pa Lyuŵa lya Kupumulila.” ");
INSERT INTO yao_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Che Yesu ŵajanjile ŵanyawo kuti, “Uli nganinsyome iŵatite pakupanganya che Daudi pamo ni achinjakwe pajakwete sala? ");
INSERT INTO yao_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jwelejo jwajinjile mu Nyuumba ja Akunnungu, ŵajigele ni kulya mikate jijatyosyekwe kwa ligongo lya Akunnungu. Che Daudi ni achinjakwe nganasachilwa kulya ikaŵe ŵambopesi pe. ");
INSERT INTO yao_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pane, uli ngannaŵe kusyoma mmalembelo ga Malajisyo ga Akunnungu gaŵapele che Musa kila Lyuŵa lya Kupumulila ŵambopesi akugatema Malajisyo pa nyuumba ja Akunnungu, nambo ngakuŵalanjilwa kuŵa aleŵile? ");
INSERT INTO yao_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nipele, ngunsalila kuti apano apali jwaali jwankulu kujipunda Nyuumba ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nambo nkagamanyilile malumbo gakwe aga maloŵe ga gaasasile Akunnungu, ‘Ngusaka chanasa ngaŵa mbopesi,’ ngankaalamule ŵandu ŵangali ni sambi. ");
INSERT INTO yao_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pakuŵa Mwana jwa Mundu ali Ambuje ŵa Lyuŵa lya Kupumulila.” ");
INSERT INTO yao_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nipele, Che Yesu ŵatyosile pelepo, ŵajinjile mu nyuumba ja kupopelela. ");
INSERT INTO yao_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mwaliji ni mundu jumo jwali ni nkono wakutatala. Nipele, ŵandu ŵausisye Che Yesu, “Uli, ili yambone kunnamya mundu pa Lyuŵa lya Kupumulila?” Ŵambusisye yeleyo kuti akolanje ligongo lya kwaŵechetela. ");
INSERT INTO yao_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nambo Che Yesu ŵaasalile, “Tujile jumo jwenu akwete ngondolo jimo, nombe najo jitumbuchile mwisimbo, uli, ana nganjenda kujikamula ni kujityosya pakuŵa lili Lyuŵa lya Kupumulila? ");
INSERT INTO yao_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nambo, mundu atopele kujipunda ngondolo! Nipele, ili yambone kupanganya yaili yambone pa Lyuŵa lya Kupumulila.” ");
INSERT INTO yao_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nipele, ŵansalile mundu jo kuti, “Ngolosye nkono wenu.” Ŵaugolwesye, nombe ni ŵalamile chisau nkono wine ula. ");
INSERT INTO yao_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nipele, Mafalisayo ŵatyosile paasa ni kuusyana ichajile pakwaulaga Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nambo Che Yesu paŵasimanyi ng'anisyo syao, ŵatyosile pepala. Ŵandu achajinji ŵakuiye ni ŵaalamisye ŵakulwala wose, ");
INSERT INTO yao_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ŵakanyisye ngasiŵamanyisya ŵandu ngani syakwe, ");
INSERT INTO yao_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","pakuti gamalile maloŵe gaŵechete jwakulondola che Isaya, ");
INSERT INTO yao_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nnole, jwakutumichila jwangu junansagwile, jwakunonyelwa jwangu jwakuusengwasya nnope ntima wangu. Chinantaje Mbumu jwangu, nombejo chakaasalile ŵandu ŵa ilambo kulamula kwangu. ");
INSERT INTO yao_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ngasakola makani atamuno nganyanyisya, ni liloŵe lyao ngalipikanika mwitala. ");
INSERT INTO yao_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Chapunde kwakolela chanasa ŵandu ŵakwete masauko ga kuputikwa kwa nnasi, ni kwakamulisya ntima ŵandu ŵangali machili, mpaka ulamusi waukusachilwa pachiukomboleswe kulamula. ");
INSERT INTO yao_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ŵandu wose ŵa ilambo yose chakole chilolelo kwa jwelejo.” ");
INSERT INTO yao_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Papopo ŵandu ŵannyichisye Che Yesu mundu jwangalola atamuno kuŵecheta kwa ligongo lya kukamulwa ni masoka. Nipele ŵannamisye jwangaŵecheta jo ni jwaŵechete ni kulola. ");
INSERT INTO yao_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mpingo wose wa ŵandu ŵasimosile ni ŵatite, “Jweleju ngati Mwana ju che Daudi?” ");
INSERT INTO yao_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nambo Mafalisayo paŵapilikene gelego, ŵatite, “Mundu ju akugakoposya masoka kwa machili ga Belesebuli jwankulu jwa masoka.” ");
INSERT INTO yao_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Che Yesu ŵasimanyilile ng'anisyo syao, ŵaasalile, “Umwenye wauliwose waugaŵanyiche maunjili maunjili gagakumenyana, ngaukulonjela, yalumo peyo, musi pane ŵandu ŵa nyuumba jajilijose agaŵanyikaga maunjili maunjili gagakumenyana achinsyene pe, nyuumba jo ngajijima. ");
INSERT INTO yao_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Iŵaga mpingo umo ukumenyana ni mpingo wine mu umwenye wa Shetani, malumbo gakwe umwenye wo ugaŵanyiche, nipele, chiujime chinauli? ");
INSERT INTO yao_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ŵanyamwe nkutinji une ngugakoposya masoka kwa machili ga Belesebuli, uli, ŵakulijiganya ŵenu akugakoposya kwa machili ga acheni? Kwa lye ligongo lyo ŵandu ŵakunkuya ni ŵachammechetele ŵanyamwe. ");
INSERT INTO yao_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nambo iŵaga une ngugakoposya masoka kwa ukombole wa Mbumu jwa Akunnungu, pelepo mmanyilile kuti umwenye wa Akunnungu unnyichilile. ");
INSERT INTO yao_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Sooni mundu akukombola chinauli kwinjila mu nyuumba ja mundu jwali ni machili ni kunsumula chipanje chakwe, akanamtaŵe kaje mundu jwali ni machili jula? Pele ni pachapakombole kunsumula chipanje chakwe. ");
INSERT INTO yao_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Jwalijose jwanganaŵa pamo none, akunganila une ni jwangasonganganya ŵandu pamo none, akwapwilinganya. ");
INSERT INTO yao_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kwa lye ligongo lyo ngunsalila, ŵandu chalecheleswe sambi ni liloŵe lyalili lyose lyakwatukana Akunnungu, nambo juchantukane Mbumu jwa Akunnungu jwelejo ngalecheleswa. ");
INSERT INTO yao_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ni jwalijose juchaŵechete liloŵe lya kunkanila Mwana jwa Mundu, chalecheleswe, nambo jwele juchaŵechete liloŵe lya kunkanila Mbumu jwa Akunnungu jo, ngalecheleswa, ngaŵa pa chilambo cha sambano chi atamuno pa chilambo chachikwika cho. ");
INSERT INTO yao_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Chitela chambone chikusogola isogosi yambone ni chitela changalumbana chikusogola isogosi yangalumbana. Nipele chitela chikumanyika kwa isogosi yakwe. ");
INSERT INTO yao_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ŵanyamwe uŵelesi wa majoka! Nkukombola chinauli kusala gambone mwasyene mwaŵaga ŵangalumbana? Pakuŵa mundu akuŵecheta agala gagagumbele mu ntima wakwe. ");
INSERT INTO yao_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundu jwambone akukoposya gambone mu ngokwe jakwe jambone, ni mundu jwangalumbana akukoposya gangalumbana mu ngokwe jakwe jangalumbana. ");
INSERT INTO yao_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nipele, ngunsalila, lyuŵa lya kulamula ŵandu chasachilwe kwanga kwa liloŵe lyalili lyose lyangalumbana lyaŵaŵechete. ");
INSERT INTO yao_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pakuŵa kwa maloŵe genu gambone chachimmalanjila kuti ndi ŵambone paujo pa Akunnungu, ni kwa maloŵe genu gakusakala chinchilamulwa.” ");
INSERT INTO yao_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nipele, ŵane ŵa ŵakwiganya Malajisyo ni Mafalisayo ŵaasalile Che Yesu kuti, “Jwakwiganya, tukusaka kulola chimanyisyo kutyochela kukwenu.” ");
INSERT INTO yao_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nombejo ŵaajanjile, “Uŵelesi wangalumbana ni wangakulupilichika! Nkusakanga chimanyisyo, nambo ngampegwa chimanyisyo ikaŵe achila pe chimanyisyo cha che Yona jwakulondola jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pakuŵa mpela che Yona iŵatite pakutama moŵa gatatu muusi ni chilo mlutumbo lwa somba jajikulungwa, iyoyo Mwana jwa Mundu nombe ni ichajile pakutama mu lisi moŵa gatatu muusi ni chilo. ");
INSERT INTO yao_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ŵandu ŵa ku Ninawi chakopochele katema kakulamula, nombewo chasale kuti au uŵelesi u wana magambo. Pakuŵa ŵandu ŵa ku Ninawi ŵalesile sambi syao kwa ligongo lya kulalichila ku che Yona, ni nnole, apano apali jwampundile che Yona! ");
INSERT INTO yao_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mwenye jwankongwe jwa chilambo cha ku Sheba chakopochele katema au uŵelesi u pachiulamulikwe, nombe chasale kuti uŵelesi u wana magambo. Pakuŵa ŵelewo ŵaiche kutyochela kwakutalika, ŵaiche kukugapilikanila maloŵe ga lunda ga mwenye che Selemani, nambo pelepa kwana jwankulungwa kupunda mwenye che Selemani. ");
INSERT INTO yao_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Lisoka palikunkopoka mundu, likusyungula syungula mwipululu mwangali meesi lichisosaga pakupumulila, nambo lyalepelaga kupata, ");
INSERT INTO yao_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","pelepo ni likuti, ‘Chimujile ku nyuumba jangu akula kungopochele kula.’ Nambo palikuuja ni kujisimana nyuumba jila jili jangali chindu ni jepyajile ni jekolosye, ");
INSERT INTO yao_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","pele likwaula kukugajigala masoka gane saba gakusakala kupunda ŵelewo, gose gakwaula kukunjinjila jwele mundu jo. Ni jwele mundu jo akuŵa jwangalumbana nnope kupunda iŵaliji kundanda. Yeleyo ni ichijile pakutyochela kwa ŵandu ŵangalumbana.” ");
INSERT INTO yao_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Che Yesu paŵaliji aninkwendelechela kukunguluka ni mipingo ja ŵandu, achikulu ŵao ni achalongo ajao ŵaiche ni kwima paasa, ŵasachile kunguluka nawo. ");
INSERT INTO yao_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nipele, mundu jumo ŵaasalile Che Yesu kuti, “Achikulu ŵenu ni achalongo ajenu ajimi paasa, akusaka kuŵecheta nomwe.” ");
INSERT INTO yao_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nambo Che Yesu ŵanjanjile jwele mundu jo kuti, “Ŵaani achikulu ŵangu? Ni ŵaani achalongo ajangu?” ");
INSERT INTO yao_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Che Yesu ŵanlanjile mundu jula ŵakulijiganya ŵao achitiji, “Ŵeleŵa ni ŵaali achikulu ŵangu ni achalongo achinjangu! ");
INSERT INTO yao_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pakuŵa jwalijose jwakupanganya yakuisaka Atati ŵangu ŵa kwinani, jwelejo ni mpwanga ni mlumbwangu ni achikulu ŵangu.” ");
INSERT INTO yao_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ndaŵi jijojo, Che Yesu ŵakopweche mu nyuumba jila, ŵajawile kukutama mungulugulu litanda. ");
INSERT INTO yao_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mipingo jajikulungwa ja ŵandu jansyungwile nipele ŵakwesile mu ngalaŵa ni kutama. Ŵandu wose ŵajimi mungulugulu litanda, ");
INSERT INTO yao_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","nombe Che Yesu ŵaasalile indu yejinji kwa itagu, achitiji, “Mpilikane! Jwakupanda ŵajawile kukumisa mbeju. ");
INSERT INTO yao_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Paŵaliji nkumisa mbeju, sine syapatuchile mungulugulu matala ga mmigunda, nipele yaiche ijuni ni kusimila. ");
INSERT INTO yao_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sine syapatuchile mmaganga pangali litaka lyejinji. Syawoneche simesile kwachitema pakuŵa litaka lyaliji kanandi. ");
INSERT INTO yao_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nipele, lyuŵa palyaŵasile syatiniche ligongo michiga jakwe jaliji nganijijinjilisya paasi, syajumwile. ");
INSERT INTO yao_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sine syapatuchile pa miiŵa, nombe miiŵa jo jamesile ni kusiŵijikanya. ");
INSERT INTO yao_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sine syapatuchile pa litaka lya chajila, syamesile, ni kusogola, sine mia moja, sine sitini ni sine selasini. ");
INSERT INTO yao_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jwakwete mapilikanilo ga kupilikanila, apilikane!” ");
INSERT INTO yao_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ŵakulijiganya ŵao Che Yesu ŵajaulile ni kwausya kuti, “Ana ligongo chi nkuŵecheta ni ŵandu kwa itagu?” ");
INSERT INTO yao_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Che Yesu ŵajanjile, “Ŵanyamwe mpegwilwe ukombole wa kumanyilila yantemela ya umwenye wa kwinani nambo ŵanewo nganapegwa. ");
INSERT INTO yao_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pakuŵa jwalijose jwakwete chindu chapegwe ni kujonjecheswa, nambo jwele jwanganakola chindu, atamuno chele chakwete cho chasumulwe. ");
INSERT INTO yao_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kwa ligongo lyo nguŵecheta nawo kwa itagu, pakuŵa akulola nambo ngakulola, akupilikana nambo ngakupilikanichisya atamuno ngakumanyilila. ");
INSERT INTO yao_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwa ŵelewo gamalile agala maloŵe gaŵechete che Isaya jwakulondola jwa Akunnungu gagakuti: ‘Kupilikana chimpilikane nambo ngammanyilila. Kulola chinlolechesye nambo ngammona. ");
INSERT INTO yao_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Pakuŵa lunda lwa ŵele ŵandu wo lupungwene, agasiŵile mapilikanilo gao, akupilenje. Nambo ikaliji akulola kwa meeso gao, ni kupilikana kwa mapilikanilo gao, nombe akamanyilile kwa lunda lwao, ni kung'alauchila, none ngaalamisye.’ ");
INSERT INTO yao_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nambo nkwete upile ŵanyamwe pakuŵa meeso genu gakulola ni mapilikanilo genu gakupilikana. ");
INSERT INTO yao_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngunsalila isyene kuti ŵakulondola achajinji ni ŵandu ŵajinji ŵakupanganya yambone paujo pa Akunnungu, ŵasachile kugaona gankugaona nambo nganagaona ni kugapilikana gamkugapilikana nambo nganagapilikana. ");
INSERT INTO yao_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nipele, ŵanyamwe mpilikane malumbo ga achi chitagu cha jwakupanda chi. ");
INSERT INTO yao_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jwalijose jwakulipilikana liloŵe lyankati Umwenye wa Akunnungu pangalimanyilila, ali mpela mbeju sisyapatuchile mmatala ga mmigunda, Jwangalumbana jula akwika kuchityosya chele chepandikwe mu ntima mwakwe cho. ");
INSERT INTO yao_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nombe syele mbeju sisyapatuchile mmaganga, sili mpela mundu jwakupilikana liloŵe ni kulipochela kwa unonyelo. ");
INSERT INTO yao_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nambo ngakulikamulichisya ni nganakola michiga nkati mwakwe, akulikamula katema kakajipi pe, pakukutyochela kulaga ni kusauka kwa ligongo lya liloŵe lyo, papopo akuleka kulikulupilila liloŵe. ");
INSERT INTO yao_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nombe syele mbeju sisyapatuchile pa miiŵa syo sili mpela mundu jwakulipilikana liloŵe, nambo kwa ligongo lya kuchenjeuchila masengo ga umi watulinawo ni kuchinonyela kwannope chipanje kukuliŵijikanya liloŵe lyo, nombejo ngakusogola isogosi, yaani kupanganya yaikwanonyelesya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nombe syele mbeju sisyapatuchile pa litaka lyambone sili mpela mundu jwakupilikana liloŵe ni kulimanyilila, jwelejo akupanganya yejinji yambone yaikusachilwa mpela mbeju ijikuti pakusogola, jimo mia moja, jine sitini, ni jine selasini.” ");
INSERT INTO yao_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Che Yesu ŵaasalile ŵakulijiganya chitagu chine kuti, “Umwenye wa kwinani ukulandana ni mundu jwapandile mbeju syambone mu ngunda wakwe. ");
INSERT INTO yao_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nambo ŵandu paŵaliji agonile, ŵaiche jwammagongo jwakwe, ŵapandile masindi mwepande ngano, ni kutyoka. ");
INSERT INTO yao_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nipele, pasyamesile mbeju ni kutanda kusogola ni masindi gatandite kuwoneka. ");
INSERT INTO yao_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Achikapolo ŵa asyene ngunda ŵaiche nikuti, ‘Ambuje, ngati mwapandile mbeju syambone mu ngunda mwenu? Sambano gatyochele kwapi masindi?’ ");
INSERT INTO yao_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nipele ŵatite, ‘Jwammagongo ni jwatesile yeleyo.’ Nipele, achikapolo wakwe ŵaausisye, ‘Uli, nkusaka tujaule tukagatupule?’ ");
INSERT INTO yao_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nombejo ŵajanjile, ‘Ngwamba, pachintupule masindi, pane chinkatupule pamo ni ngano. ");
INSERT INTO yao_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nneche ikule yose pamo mpaka katema ka kugungula. Nipele, katema ka kugungula chinjasalila ŵakugungula kuti, nsonganganye kaje masindi nkagataŵikanye ilingo ilingo, nkagatinisye. Nambo ngano nsonganganye ni kutaga mu ngokwe jangu.’ ” ");
INSERT INTO yao_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nipele, Che Yesu ŵaatagulile ŵandu chitagu chine kuti, “Umwenye wa kwinani ulandene ni mbeju jajinandi nnope jajikuŵilanjikwa haladali jatosile mundu ni kujipanda mungunda mwakwe. ");
INSERT INTO yao_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jisyene jili jajinandi kusipunda mbeju sine syose, nambo jamelaga ni kukula jikuŵa jajikulungwa kupunda mimela jose. Ukukula ni kuŵa chitela mpaka ijuni ya mwinani ikwika ni kutaŵa isusi mu nyambi syakwe.” ");
INSERT INTO yao_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Che Yesu ŵaasalile ŵandu chitagu chine kuti, “Umwenye wa kwinani ulandene ni amila jajigele jwankongwe jumo, ni kuwanganya ni utandi mbisi siŵili ni nusu, ni utandi wose wasaseŵele.” ");
INSERT INTO yao_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Che Yesu ŵaasalile ŵandu yose kwa itagu. Ni pangali chitagu nganiŵasalila chachili chose. ");
INSERT INTO yao_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pakuti limalile liloŵe lyaŵechete jwakulondola jwa Akunnungu: “Chiŵechetenawo kwa itagu, chinaasalile ŵandu indu yaisisikwe chitandile kugumbikwa chilambo.” ");
INSERT INTO yao_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nipele, Che Yesu ŵaulesile mpingo wa ŵandu, ŵajinjile mu nyuumba. Ŵakulijiganya ŵao ŵaichile ni kwasalila, “Ntugopolele chitagu cha masindi ga mungunda.” ");
INSERT INTO yao_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Che Yesu ŵaasalile, “Jwakupanda mbeju syambone ni Mwana jwa Mundu. ");
INSERT INTO yao_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nombe ngunda uli chilambo chino. Nombe syele mbeju syambone syo sili ŵele ŵandu ŵati Umwenye uli wo. Nambo masindi ali ŵandu ŵa jwangalumbana jula. ");
INSERT INTO yao_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nombe jwammagongo jwapandile masindi ali Shetani. Magungulo gali mbesi ja chilambo chino, nombe ŵakugungula ali achikatumetume ŵa kwinani. ");
INSERT INTO yao_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mpela ila masindi igakuti pakusonganganywa ni kutinisya, iyoyo ichichiŵa kumbesi kwa chilambo chino. ");
INSERT INTO yao_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana jwa Mundu chachalajisya achikatumetume ŵao ŵa kwinani kuti asonganganye kutyochela mu Umwenye wao wose aŵala ŵakwaleŵekasya ŵandu atende sambi ni wose ŵatesile ya sambi. ");
INSERT INTO yao_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ni achikatumetume ŵa kwinani wo chiŵaponye ŵandu pa litanuli lya mooto wakalipa ni kweleko chalile ni kuchilimya meeno. ");
INSERT INTO yao_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kele katema ko ŵandu ŵakupanganya yaili yambone paujo pa Akunnungu chachimelemenda mpela lyuŵa mu Umwenye wa Atati ŵao. Ŵakwete mapikanilo, apikanile! ");
INSERT INTO yao_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Umwenye wa kwinani ulandene ni mbiko jajisisiche mu ngunda. Mundu jumpepe ŵajiweni ni kujisisa sooni. Nipele ŵasangalele nnope ni ŵajawile kukuisumisya iŵakwete yose ni kusuma ngunda ula. ");
INSERT INTO yao_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Sooni, umwenye wa kwinani ulandene ni mundu jwakusumisya malonda achisosaga igogo yambone. ");
INSERT INTO yao_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nombe paŵachiweni chigogo chimo cha ndalama jajikulungwa, ŵajawile, ŵaisumisye iŵakwete yose, ŵachisumile chigogo chila. ");
INSERT INTO yao_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Sooni, Umwenye wa kwinani ulandene ni lwau lwauponyekwe mu litanda, lwatanjile somba syasili syose. ");
INSERT INTO yao_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lwau palwagumbele, ŵakukoka somba ŵaluutile kumbwani, ŵatemi kusagula somba syambone ni kusitaga mu itundu yao ni somba syangalumbana ŵasijasile. ");
INSERT INTO yao_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Yeleyi ni ichichiŵa kumbesi kwa chilambo chino, achikatumetume ŵa kwinani chachikopochela, chiŵalekanganye ŵandu ŵambone ni ŵangalumbana. ");
INSERT INTO yao_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nombe ŵele ŵangalumbana wo chiŵajasile pa litanuli lya mooto. Kweleko chachilila ni kuchilimya meeno.” ");
INSERT INTO yao_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Che Yesu ŵausisye, “Ana gele gose ga nkugamanyilila?” Ŵajanjile, “Elo.” ");
INSERT INTO yao_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nombewo ŵaasalile, “Kwa ligongo lyo, jwakwiganya Malajisyo ga Akunnungu gaŵapele che Musa jwalijose jwakuŵa jwakulijiganya jwa Umwenye wa kwinani, alandene ni nsyene nyuumba jwakukoposya mu mbiko jakwe indu ya ndalama ya sambano ni indu ya ndalama ya kalakala.” ");
INSERT INTO yao_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Che Yesu paŵamasile kuŵecheta yele itagu yo, ŵatyosile pelepo, ");
INSERT INTO yao_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ni ŵapite mu musi wao. Kweleko ŵajiganyaga ŵandu mu nyuumba jao ja kupopelela, nombewo ŵasimosile nikuti, “Jweleju apatile kwapi alu lunda lu ni ukombole wa kuipanganya yakusimonjeka? ");
INSERT INTO yao_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ana ajuju ngati mwana jwa jwakusepa itela? Achikulu ŵao ngati akuŵilanjikwa che Maliamu ni achapwakwe ngati che Yakobo ni che Yusufu ni che Simoni ni che Yuda? ");
INSERT INTO yao_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Achalumbugwe wose ngati ali pamo ni uweji? Nambi ajuju apatile kwapi aga gose ga?” ");
INSERT INTO yao_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nipele, nganiŵakunda. Nambo Che Yesu ŵaasalile, “Jwakulondola jwa Akunnungu akuchimbichikwa nambo ngaakuchimbichikwa mu chilambo chakwe ni mu nyuumba jakwe!” ");
INSERT INTO yao_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kwa ligongo lyo, nganatenda yakusimonjeka yaijinji ligongo lya ungali chikulupi wao. ");
INSERT INTO yao_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kele katema ko chilongola che Helode ŵapilikene ngani si Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nipele, ŵaasalile achikatumetume ŵao, “Jwele mundu ni che Yohana Ŵakubatisya asyuchile mchiwa, lyele ni ligongo machili gakupanganya yakusimonjeka gakupanganya masengo nkati mwakwe.” ");
INSERT INTO yao_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Che Helode ni juŵankamwile che Yohana ni kuntaŵa kwa minyolo, ŵammisile mu nyuumba jakutaŵilwa kwa ligongo lya che Helodia, ŵankwawo che Filipo nkulugwe. ");
INSERT INTO yao_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ligongo che Yohana ŵansalile che Helode kuti, “Ngankusachilwa kunnombela jwele jwankongwe jo!” ");
INSERT INTO yao_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Che Helode ŵasachile kwaulaga che Yohana, nambo ŵajogwepe ŵandu pakuŵa kukwao che Yohana ŵaliji jwakulondola jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nipele, pa chindimba cha lyuŵa lyekulungwa lya kupagwa kwao che Helode, mwali jwao che Helodia ŵatyasile mmbujo mwa achalendo ni mwali jula ŵaasengwasisye che Helode, ");
INSERT INTO yao_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mpaka ŵalanjile achitiji, “Ngulumbilila, chinampe chachili chose chachinsache.” ");
INSERT INTO yao_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nombejo ŵanyenjekwe ni achikulugwe, ŵatite, “Mumbeje panopano ntwe u che Yohana Ŵakubatisya mumbale.” ");
INSERT INTO yao_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mwenye ŵasupwiche, nambo kwa ligongo lya kulumbila kwao ni ligongo lya achalendo ŵaŵatemi pamo nawo, ŵalajisye apegwe. ");
INSERT INTO yao_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nipele, che Helode ŵannajisye mundu ku nyuumba ja kutaŵila ŵandu kuti ŵakate che Yohana ntwe. ");
INSERT INTO yao_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ntwe wakwe wajigalikwe mu mbale ni kumpa mwali, nombejo ŵampele achikulugwe. ");
INSERT INTO yao_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ŵakulijiganya ŵa che Yohana ŵaiche, ŵachijigele chiilu chakwe, ŵachisichile. Nipele ŵajawile kukwasalila Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Che Yesu paŵapilikene ngani syo, ŵatyosile pepala kwa ngalaŵa, ŵajawile pantemela pajikape. Nambo ŵandu paŵapilikene, ŵakuiye kwa makongolo achityochelaga mmisi jao. ");
INSERT INTO yao_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nipele, paŵaiche kumbwani, ŵauweni mpingo wekulungwa wa ŵandu, ŵakolele chanasa ni ŵalamisye ŵakulwala ŵao. ");
INSERT INTO yao_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pakwaswele, ŵakulijiganya ŵao ŵaichilile ni kwasalila, “Apano patuli pa mwikonde ni sambano kuswele. Sambano, mwalanje ŵandu wo kuti ajaule mmisinda akalisumile chakulya.” ");
INSERT INTO yao_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Che Yesu ŵaasalile, “Nganakola ligongo lya kwaula, ŵanyamwe mwape chakulya.” ");
INSERT INTO yao_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nambo ŵanyawo ŵanjanjile, “Tukwete mikate nsano pe ni somba siŵili.” ");
INSERT INTO yao_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Che Yesu ŵaasalile, “Njise nawo apano.” ");
INSERT INTO yao_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ŵaasalile ŵandu kuti atame paasi pa manyasi. Nipele, Che Yesu ŵajigele mikate nsano ni somba sila, ŵalolite kwinani, ŵatogolele Akunnungu ni kugaŵanya ni kwapa ŵakulijiganya mikate jo, nombewo ŵagaŵenye ŵandu. ");
INSERT INTO yao_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ŵalile wose, ŵajikwite. Nipele ŵakulijiganya ŵalokwete sigasi sya mikate jila, ŵagumbesye itundu kumi na mbili. ");
INSERT INTO yao_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wose ŵaŵalile ŵala ŵaliji achalume mpela elufu tano, pangaŵalanjikwa achimmasyeto ni ŵanache. ");
INSERT INTO yao_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pangakaŵa, Che Yesu ŵaasalile ŵakulijiganya ŵao akwele mu ngalaŵa kuti alongolele peesi litanda asyene aninkujilanga mipingo ja ŵandu. ");
INSERT INTO yao_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Paŵamasile kwalanga ŵandu, ŵakwesile kwitumbi ali jikape kukupopela. Pakwaswele, ŵelewo ŵaliji kweleko jikape. ");
INSERT INTO yao_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kele katema ko ngalaŵa jo jaŵandichile pambindikati litanda, nambo jaliji nkupungunyikwa kwannope ni matumbela pakuŵa mbungo jaliji nkujiputa. ");
INSERT INTO yao_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kumasikusiku, Che Yesu ŵaichile ŵakulijiganya ŵao achendaga mmeesi. ");
INSERT INTO yao_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ŵakulijiganya ŵao paŵaweni achendaga mmeesi, ŵajogwepe nnope ni ŵatite, “Lili lilaika!” Ŵagumilangaga kwa woga. ");
INSERT INTO yao_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Papopo, Che Yesu ŵasalile, “Muusimane ntima, ndili une, nkajogopa!” ");
INSERT INTO yao_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Che Petulo ŵatite, “Ambuje mwaŵaga mmwe, muusalile iche kukwenu njendaga mmeesi.” ");
INSERT INTO yao_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Che Yesu ŵatite, “Njise.” Nipele che Petulo ŵatulwiche mu ngalaŵa, ŵajesile mmeesi, kwajaulila Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nambo paŵajiweni mbungo, ŵajogwepe ni ŵatandite kutiŵila, ŵagumisile achitiji, “Ambuje mungulupusye!” ");
INSERT INTO yao_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Papopo Che Yesu ŵagolwesye nkono wao, ŵankamwile ni ŵansalile, “Mmwe ŵa chikulupi chachinandi, ligongo chi nkukola lipamba?” ");
INSERT INTO yao_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nipele, wose ŵakwesile mu ngalaŵa, ni mbungo jatulele. ");
INSERT INTO yao_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nombe, wose ŵaŵaliji mu ngalaŵa ŵatindiŵalile ni kwakotamila, achitiji, “Isyene alakwe ndi Mwana jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ŵajombweche litanda ni ŵaiche ku msinda wa ku Genesaleti. ");
INSERT INTO yao_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ŵandu ŵa pepala paŵaamanyi Che Yesu, ŵajenesye ngani muumbali mose mumwasyungwile. Nipele, ŵannyichisye ŵakulwala wose, ");
INSERT INTO yao_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ni ŵachondelele kuti akwaye atamuno lujenje lya mwinjilo ŵao. Nombe wose ŵaŵankwaiye ŵalamile. ");
INSERT INTO yao_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nipele, Mafalisayo ni ŵakwiganya Malajisyo ŵaichile Che Yesu kutyochela ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Paŵaiche ŵambusisye, “Kwachichi ŵakulijiganya wenu akugapwanya majiganyo gatupochele kutyochela kwa achambuje ŵetu? Ngakunaŵa makono yambone akanaŵe kutanda kulya?” ");
INSERT INTO yao_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Che Yesu ŵajanjile, “Kwachichi ŵanyamwe mkupwanya makanyo ga Akunnungu kwa kusechelela majiganyo genu mwachinsyene? ");
INSERT INTO yao_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Akunnungu atite, ‘Mwachimbichisye atati ŵenu ni achikulu ŵenu,’ ni ‘Jwakunlwesya atatigwe atamuno achikulugwe, akusachilwa kuulajikwa.’ ");
INSERT INTO yao_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nambo ŵanyamwe nkwiganya kuti, mundu aŵaga ni chindu cha kwakamuchisya atatigwe atamuno achikulugwe, ni atiji, ‘Achi chindu chi ndyosisye sadaka kwa Akunnungu.’ ");
INSERT INTO yao_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nipele, jwele mundu jo ngakwachimbichisya atatigwe! Yele ni inkuti pakulinyelusya lilamulo lya Akunnungu ni kugakuya majiganyo genu mwachinsyene. ");
INSERT INTO yao_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ŵanyamwe ŵaulamba! Che Isaya jwakulondola jwa Akunnungu ŵasagamukwile yambone yankati ŵanyamwe paŵatite, ");
INSERT INTO yao_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Akunnungu akuti, aŵa ŵandu ŵa akunjimbichisyanga ni ngomo pe, nambo mmitima jao atalikengene ni une. ");
INSERT INTO yao_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nombe akumbopela iyiyipe, pakuŵa indu yakwiganya ili malajisyo ga ŵandu pe.’ ” ");
INSERT INTO yao_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nipele, Che Yesu ŵauŵilasile mpingo wa ŵandu, ŵaasalile, “Mpilikane ni kumanyilila! ");
INSERT INTO yao_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chindu chachikuntaga mundu usakwa ngaŵa chachikwinjila nkang'wa, nambo achila chachikutyoka nkang'wa ni chachikuntaga mundu usakwa.” ");
INSERT INTO yao_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nipele ŵakulijiganya ŵao ŵajaulile ni kwasalila, “Ana nkumanyilila kuti Mafalisayo yachimile paŵapilikene maloŵe genu?” ");
INSERT INTO yao_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nambo ŵelewo ŵatite, “Mmela wauliwose wanganapande Atati ŵangu ŵa kwinani, chiuchitupulwa. ");
INSERT INTO yao_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mwaleche ŵanyawo! Ŵele ali ŵangalola ŵakwalongosya ŵangalola. Jwangalola annongosyaga jwangalola njakwe, wose ŵaŵili chatumbuchile mwisimbo.” ");
INSERT INTO yao_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Che Petulo ŵatite, “Ntugopolele chele chitagu cho.” ");
INSERT INTO yao_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Che Yesu ŵaasalile, “Nombe ŵanyamwe ŵakwe ngankumanyilila? ");
INSERT INTO yao_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ana ngankumanyilila kuti chindu chachikwinjila nkang'wa chikupita nnutumbo ni chikujasikwa kulindi? ");
INSERT INTO yao_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nambo yaikutyoka nkang'wa ikutyochela mu ntima, yele ni yaikuntaga mundu usakwa. ");
INSERT INTO yao_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pakuŵa mu ntima sikukopoka ng'anisyo syangalumbana sya kuulaga ni chikululu ni chigwagwa ni wiyi ni kuŵecheta yaunami ni kutukana. ");
INSERT INTO yao_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gelego ni gakuntaga mundu usakwa. Nambo kulya panganaŵa makono ngakukuntaga mundu usakwa.” ");
INSERT INTO yao_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Che Yesu ŵatyosile kweleko ni ŵajile ku chilambo cha ku Tilo ni ku Sidoni. ");
INSERT INTO yao_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nipele, jwankongwe jumo Mkanaani, kutyochela chilambo chilachila, ŵaichilile achinyanyisyaga, “Ambuje, Mwana ju che Daudi, mungolele chanasa! Mwali jwangu akamwilwe ni masoka kwannope.” ");
INSERT INTO yao_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nambo Che Yesu ngananjanga liloŵe. Ŵakulijiganya ŵao ŵajaulile ni kwachondelela achitiji, “Mwasalile ajaule, pakuŵa akutukuya ali nkunyokonya.” ");
INSERT INTO yao_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Che Yesu ŵajanjile, “Akunnungu andumile kukwakulupusya ŵandu ŵa ku Isilaeli ŵaŵapotele mpela ngondolo.” ");
INSERT INTO yao_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pelepo jwambumba jula ŵaiche ni kwatindiŵalila paujo pao achitiji, “Ambuje, mungamuchisye.” ");
INSERT INTO yao_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Che Yesu ŵajanjile, “Ngaŵa yambone kutola chakulya cha ŵanache ni kusiponyela mbwa.” ");
INSERT INTO yao_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jwankongwe jo ŵajanjile, “Elo, Ambuje, nambo mbwa sikulya mbakatika sisikupatuka pakulila achambuje ŵao.” ");
INSERT INTO yao_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pelepo Che Yesu ŵajanjile, “Jwankongwe, chikulupi chenu chachikulungwa, nipele, chitendekwe kukwenu chinkusaka.” Mwali jwao jula ni ŵalamile katema kakoko. ");
INSERT INTO yao_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Che Yesu ŵatyosile pelepo ni kwaula mungulugulu litanda lya Galilaya, ŵakwesile kwitumbi, ŵatemi paasi. ");
INSERT INTO yao_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nipele, jaichile mipingo ja ŵandu ŵajinji, ŵampelechele ŵandu ŵangajenda ni ŵangalola ni ŵakulemala ni ŵangaŵecheta ni ŵane ŵajinji ŵakulwala, nipele ŵaŵisile mmbujo mwakwe ni kwalamya. ");
INSERT INTO yao_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nombe mpingo wa ŵandu ula wasimonjile nnope paŵaweni ŵangaŵecheta aninkuŵecheta ni ŵangalola aninkulola ni ŵakulemala ali alamile ni ŵangajenda aninkwenda, ŵandu ŵaakusisye Akunnungu ŵa ku Isilaeli. ");
INSERT INTO yao_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Che Yesu ŵaaŵilasile ŵakulijiganya ŵao, ŵaasalile, “Ngwakolela chanasa aŵa ŵandu ŵa pakuŵa atemi ni une moŵa gatatu sambano ni nganakola chakulya. Ngangusaka naaleche ajaule pangalya ngakaŵa chakomoche mwitala.” ");
INSERT INTO yao_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ŵakulijiganya ŵala ni ŵatite, “Tutupate kwapi chakulya chachijinji cha kwajikutisya ŵele ŵandu ŵa?” ");
INSERT INTO yao_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Che Yesu ŵaausisye, “Nkwete mikate jilingwa?” Ŵajanjile, “Saba ni tusomba kanandi pe.” ");
INSERT INTO yao_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nipele Che Yesu ŵaasalile ŵandu atamanje paasi. ");
INSERT INTO yao_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ŵajitosile mikate saba ni tusomba tula, ŵatogolele Akunnungu, ŵajigaŵenye ni kwapa ŵakulijiganya ŵao, nombe ŵakulijiganya wo ŵagaŵenye ŵandu. ");
INSERT INTO yao_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ŵalile wose, ŵajikwite. Paŵamasile kulya ŵalokotenye mbakatika ja mikate ni somba sila itundu saba yegumbale. ");
INSERT INTO yao_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ŵele uŵalile wo ŵaliji achalume elufu nne, pangaŵalanjila achakongwe ni ŵanache. ");
INSERT INTO yao_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nipele, Che Yesu ŵalanjile ŵandu, ŵakwesile mu ngalaŵa ni kwaula ku chilambo cha Magadani. ");
INSERT INTO yao_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo ni Masadukayo ŵaajaulile Che Yesu, ni kwa kwalinga ŵaŵendile ŵalosye chimanyisyo kutyochela kwinani. ");
INSERT INTO yao_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nambo Che Yesu ŵaasalile, “Lyaikaga ligulo ŵanyamwe nkutinji, ‘Lelo chikulanguche pakuŵa kwiunde kuchejele!’ ");
INSERT INTO yao_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ni kuninkucha nkutinji, ‘Lelo mbungo chijipuje, pakuŵa kwiunde kuchejele sooni maunde gagumbele!’ Nipele, ŵanyamwe nkukombola kumanyilila upagwe wa liunde, nambo imanyisyo ya katema kano ngankukombola kuimanyilila. ");
INSERT INTO yao_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Uŵelesi wangalumbana ni wangali ni chikulupi ukusosa chimanyisyo, nambo ngaupegwa chimanyisyo ikaŵe chimanyisyo chi che Yona.” Nipele ŵalesile ni kwaula. ");
INSERT INTO yao_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ŵakulijiganya ŵao paŵamasile koombochela mbande jine ja litanda, ŵaliji aliŵalile kwigala mikate. ");
INSERT INTO yao_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Che Yesu ŵaasalile kuti, “Nlilolechesye ni nligose ni amila ja Mafalisayo ni Masadukayo!” ");
INSERT INTO yao_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nambo ŵele ŵanyawo ŵaliji nkuusyana achinsyene pe achitiji, “Akuŵecheta yeleyo pakuŵa nganitujigala mikate.” ");
INSERT INTO yao_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Che Yesu ŵasimanyilile ng'anisyo syao ni kwasalila, “Ligongo chi nkuusyana mwachinsyene pe, ŵanyamwe ŵa chikulupi chachinandi kuti nganinjigala mikate? ");
INSERT INTO yao_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ana ngankumanyilila atamuno kukumbuchila panagaŵenye mikate tano jila, kwa ŵandu elufu tano ŵala? Ana itundu ilingwa ya mbakatika imwagumbesye? ");
INSERT INTO yao_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pane mikate saba jila jiŵagaŵenye ŵandu elufu nne, ana itundu ilingwa ya mbakatika imwalokotenye? ");
INSERT INTO yao_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Uli, ngankumanyilila kuti nganingunguluchilaga mikate? Nambo nlilolechesye ni amila ja Mafalisayo ni Masadukayo!” ");
INSERT INTO yao_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pelepo ŵakulijiganya ŵaimanyilile kuti nganaŵecheta yankati amila ja mikate, nambo majiganyo ga Mafalisayo ni Masadukayo. ");
INSERT INTO yao_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Che Yesu paŵaiche mmusi wa Kaisalia Filipi, ŵausisye ŵakulijiganya ŵao kuti, “Ŵandu akuti Mwana jwa Mundu ali nduni?” ");
INSERT INTO yao_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ŵajanjile, “Ŵane akuti che Yohana Ŵakubatisya ni ŵane akuti che Elia ni ŵane akuti che Yelemia, pane jumo jwao ŵakulondola ŵa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Che Yesu ŵaausisye sooni, “Nombe ŵanyamwe nkuti une ndili nduni?” ");
INSERT INTO yao_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Che Simoni Petulo ŵajanjile, “Alakwe ni Kilisito Jwakuwombola, Mwana jwa Akunnungu ŵaali ŵajumi.” ");
INSERT INTO yao_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Che Yesu ŵatite, “Nkwete upile mmwe che Simoni mwana ju che Yona, pakuŵa ngaŵa mundu jwammunukulile ngani jo, nambo Atati ŵangu ŵaali kwinani. ");
INSERT INTO yao_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","None ngunsalila, mmwe ni che Petulo ni pa lwele lwala lu chindandisye mpingo wa ŵandu ŵakunkulupilila Kilisito ni machili ga chiwa ngagaika kuukombola. ");
INSERT INTO yao_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","None chinampe iugulilo ya Umwenye wa kwinani, ni chachili chose chachinchitaŵe pa chilambo pano, chichiŵe chetaŵikwe kwinani ni chachili chose chachinchigopole pa chilambo pano, chichiŵe chegopolwe kwinani.” ");
INSERT INTO yao_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nipele ŵakanyisye kwa nnope ŵakulijiganya ŵao kuti akansalila mundu kuti ŵelewo ali Kilisito. ");
INSERT INTO yao_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chitandile ke katema ko Che Yesu ŵatandite kwalosya pangasisika ŵakulijiganya ŵao kuti yaŵajile kwaula ku Yelusalemu ni kweleko chalagaswe ni achachekulu ni ilongola ŵa achakulu ŵambopesi ni ŵakwiganya Malajisyo. Nipele chachiulagwa ni pa lyuŵa lyaatatu chasyuche. ");
INSERT INTO yao_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pelepo che Petulo ŵaajigele Che Yesu pambali ni ŵatandite kwakalipila achitiji, “Ngwamba Ambuje! Ngagansimana gelego!” ");
INSERT INTO yao_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nambo Che Yesu ŵagalauchile ni kwasalila che Petulo, “Ntyoche paujo pangu, Shetani! Mmwe nkusiŵila litala paujo pangu, pakuŵa ngankuganisya gagali ga Akunnungu, nambo ga ŵandu!” ");
INSERT INTO yao_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nipele, Che Yesu ŵaasalile ŵakulijiganya ŵao, “Mundu jwakusaka kunguya, alikane nsyene, atwichile nsalaba wakwe, anguye une. ");
INSERT INTO yao_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pakuŵa, mundu jwalijose jwakusaka kuukulupusya umi wakwe, chaujase. Nambo mundu jwakuutyosya umi wakwe kwaligongo lyangu, chaukole sooni. ");
INSERT INTO yao_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ana mundu chapate chichi akolaga chipanje cha pa chilambo, ali ajasile umi wakwe? Pane mundu chatyosye chichi pamalo pa umi wakwe? ");
INSERT INTO yao_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pakuŵa Mwana jwa Mundu chachiika mu ukulu wa Atatigwe pamo ni achikatumetume ŵakwe ŵa kwinani, pelepo chachinlipa jwalijose malinga ni masengo gao. ");
INSERT INTO yao_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ngunsalila isyene, apali ŵane mwa ŵanjimi apano ngaapasya chiwa akanaŵe kummona Mwana jwa Mundu achiikaga ali Mwenye.” ");
INSERT INTO yao_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagamasile moŵa sita, Che Yesu ŵajigele che Petulo ni che Yakobo ni che Yohana mpwao, ŵakwesile pamo nawo penani chitumbi cheleu, kweleko ŵaliji ŵanyapewo. ");
INSERT INTO yao_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kweleko, Che Yesu ŵagalawiche uwoneche wakwe paujo pao, ku meeso kwao kwamelemendaga mpela lyuŵa ni iwalo yao yaliji yeswela mpela lulanga. ");
INSERT INTO yao_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chisisimuchile che Musa ni che Elia ŵaakopochele, ŵaliji nkukunguluka ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pelepo che Petulo ŵaasalile Che Yesu, “Ambuje, yambone uwe kuŵa apano! Mwasakaga chindaŵe masakasa gatatu, limo lyenumwe ni line li che Musa ni line li che Elia.” ");
INSERT INTO yao_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Paŵaŵechetaga gelego, liunde lyeswela lyaunichile ŵanyawo, ni lyapikaniche liloŵe kutyochela mu liunde lila lichitiji, “Aju ali Mwanangu jungunnonyela, nonyelwe nawo, mumpilikanichisye jwelejo.” ");
INSERT INTO yao_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ŵakulijiganya paŵapilikene yeleyo ŵajogwepe nnope, ŵagwile manguku. ");
INSERT INTO yao_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nipele Che Yesu ŵaichilile, ŵakwayiye achitiji, “Njimuche, nkajogopa!” ");
INSERT INTO yao_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Paŵalolite kwinani nganammona mundu jwalijose akaŵe Che Yesu jika pe. ");
INSERT INTO yao_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nipele, paŵatulukaga pa chitumbi po, Che Yesu ŵaasalile, “Kasimunsalila mundu jwalijose inyiweni ila, mpaka patachisyuka Mwana jwa Mundu kutyochela mu chiwa.” ");
INSERT INTO yao_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nipele ŵakulijiganya ŵao ŵammusisye, “Kwachichi nambi ŵakwiganya Malajisyo ga Akunnungu gaŵapele che Musa akuti chaiche kaje che Elia?” ");
INSERT INTO yao_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Che Yesu ŵajanjile, “Isyene, che Elia chaiche kaje ni kukolosya indu yose iŵe chile. ");
INSERT INTO yao_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nambo ngunsalila, che Elia amasile kwika, nganammanyilila, nambo ŵantendele iŵasachile. Nombewo chachinnagasya Mwana jwa Mundu iyoyopeyo.” ");
INSERT INTO yao_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pelepo ŵakulijiganya ŵala ŵaimanyilile kuti ŵangambaga che Yohana Ŵakubatisya. ");
INSERT INTO yao_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Paŵaiche sooni pa wele mpingo wa ŵandu ula, ŵaiche mundu jumo mmbujo pa Che Yesu ni kwatindiŵalila, ");
INSERT INTO yao_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ŵatite, “Ambuje, munkolele chanasa mwanangu pakuŵa akulwala njilinjili ni kulaga nnope, katema kakajinji akugwilila pa mooto pane mmeesi. ");
INSERT INTO yao_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nannyichisye kwa ŵakulijiganya ŵenu, nambo nganakombola kunnamya.” ");
INSERT INTO yao_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Che Yesu ŵajanjile, “Uŵelesi wangali chikulupi ni wakulyungasika, ana chime ni ŵanyamwe mpaka chakachi? Mpaka chakachi chinampililile? Munjise nawo apano.” ");
INSERT INTO yao_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nipele, Che Yesu ŵalikalipile lisoka lila, nombelyo lyankopweche ni jwanchanda jula ŵalamile katema kakoko. ");
INSERT INTO yao_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nipele, ŵakulijiganya ŵaichile Che Yesu kwa chisyepela ni kwausya, “Ligongo chi nganitukombola kulikoposya lisoka lila?” ");
INSERT INTO yao_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Che Yesu ŵajanjile, “Kwa ligongo lya chikulupi chenu chachinandi. Ngunsalila isyene, mwaŵaga ni chikulupi atamuno chaŵaga chachinandi chisau mbeju jajinandi nnope jajikuŵilanjikwa haladali, chinkombole kuchisalila achi chitumbi chi, ‘Ntyoche apa njaule ako,’ nombecho chichityoche. Ngalipagwa liloŵe lyangalikombolecheka kukwenu.” ");
INSERT INTO yao_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nambo lisoka lyanti yele ngalikutyosyekwa ikaŵe kwa kupopela ni kutaŵa. ");
INSERT INTO yao_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ŵakulijiganya paŵaliji pamo ku Galilaya, Che Yesu ŵaasalile, “Mwana jwa Mundu akwaula kukutagwa mmakono ga ŵandu. ");
INSERT INTO yao_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nombewo chachimmulaga, nambo chachisyuka pa lyuŵa lyaatatu.” Pelepo ŵakulijiganya ŵasongoneche nnope. ");
INSERT INTO yao_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Che Yesu ni ŵakulijiganya ŵao paŵaiche ku Kapelenaumu ŵandu ŵakukumbikanya nsongo wa Nyuumba ja Akunnungu ŵaichilile che Petulo, ŵausisye, “Ana jwakwiganya jwenu akulipa nsongo wa Nyuumba ja Akunnungu?” ");
INSERT INTO yao_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Che Petulo ŵajanjile, “Elo, akulipa.” Nipele, che Petulo paŵajinjile mu nyuumba, akanaŵe kuŵecheta liloŵe, Che Yesu ŵalongolele kummusya achitiji, “Che Simoni, mmwe nkuti uli? Mamwenye ŵa pa chilambo akukumbikanya nsongo atamuno ushulu kwa ŵandu chi? Kutyochela kwa achinsyene musi pane kwa achalendo?” ");
INSERT INTO yao_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Che Petulo ŵajanjile, “Kutyochela kwa achalendo.” Che Yesu ŵansalile, “Nipele, iŵaga ili yeleyo, achinsyene musi wo ngakusachilwa kulipa. ");
INSERT INTO yao_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nambo tukaachima ŵandu ŵa. Njaule kulitanda nkaloposye, ni somba jandanda kutanjila pa ndowana, nkajiunukule kang'wa ni chinkasisimane mbiya sya nsongo. Njigale ni kwapa ligongo lyangune ni lyenu mmwe.” ");
INSERT INTO yao_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kekala katema kala ŵakulijiganya ŵaichilile Che Yesu ni kwausya, “Ana nduni jwaali jwankulungwa mu Umwenye wa kwinani?” ");
INSERT INTO yao_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Che Yesu ŵambilasile mwanache, ŵanjimiche mmbujo mwao. ");
INSERT INTO yao_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nipele ŵatite, “Isyene ngunsalila, iŵaga ngankugalauka ni kuŵa mpela ŵanache, nganjinjila kose mu umwenye wa kwinani. ");
INSERT INTO yao_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nipele jwalijose jwakulitimalika mpela aju mwanache ju, jwelejo ni jwali jwankulungwa mu umwenye wa kwinani. ");
INSERT INTO yao_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jwalijose jwakumpochela mwanache jumo mpela aju mu liina lyangu, jwelejo akumbochela une.” ");
INSERT INTO yao_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nambo jwalijose juchantende jumo jwa achanandi ŵa, ŵakungulupilila une atende sambi, ikaliji yambone kwa ŵelewo ataŵikwe pa lukosi liganga lyekulungwa lya kusyajila ni kumponya mu bahali pakwendesya nnope. ");
INSERT INTO yao_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ulaje chiuŵe kwa ŵandu ŵa pa chilambo kwa ligongo lya kuichisya indu ya kwatenda ŵandu atende sambi. Indu yo ikusachilwa ikopochele nambo ulaje kukwakwe mundu juchaichenawo indu yo. ");
INSERT INTO yao_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Iŵaga nkono wenu pane lukongolo lwenu lukuntenda ntende sambi, mmukate nkaujase kwakutalika. Mmbaya kukwenu kwinjila mu umi pangali nkono umo pane lukongolo lumo kupunda kuponyekwa pa mooto wa moŵa gose pangali mbesi wangasimika ndi ni makono gaŵili ni makongolo gaŵili. ");
INSERT INTO yao_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ni liso lyenu lyantendaga ntende sambi, nlikolopole ni kuliponya kwakutalika. Mmbaya kukwenu kwinjila mu umi wangamala ni liso limo, kupunda kuponyekwa pa mooto wangasimika moŵa gose pangali mbesi ndi ni meeso gaŵili. ");
INSERT INTO yao_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nlilolechesye! Nkanchembulusya jumo jwa achanandi ŵa. Ngunsalila, achikatumetume ŵao kwinani ko moŵa gose akulola usyo wa Atati ŵaali kwinani. ");
INSERT INTO yao_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Pakuŵa Mwana jwa Mundu ŵaiche kukwakulupusya aŵala ŵaŵasochele. ");
INSERT INTO yao_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ana ŵanyamwe nkuti uli, Mundu akolaga ngondolo mia moja, ni jasochelaga ngondolo jimo, ngaasileka ngondolo tisini na tisa sila pasyaliji po ni kwaula kukujisosa jajisochele jila? ");
INSERT INTO yao_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ajisimanaga, ngunsalila isyene, akusengwa ligongo lya jejila kusipunda tisini na tisa syangasochela sila. ");
INSERT INTO yao_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iyoyo Atati ŵenu ŵa kwinani ngakusaka ata jumo jwa achanandi ŵa kuti asochele. ");
INSERT INTO yao_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nlongo njenu anleŵelaga, munjaulile nkanlosye chileŵo chakwe nli ŵaŵili pe. Ampilikanilaga chimme mumpatile nlongo njenu. ");
INSERT INTO yao_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nambo iŵaga ngakumpilikanila, munjigale mundu jumo pane ŵaŵili pakuti kwa kang'wa sya ŵaumboni ŵaŵili pane ŵatatu, kila liloŵe likaluche, mpela Malembelo ga Akunnungu yagakuti pakusala. ");
INSERT INTO yao_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Akanaga kwapilikanichisya ŵanyawo, muusalile mpingo wa ŵandu ŵakunkulupilila Kilisito. Ni akanaga kuupilikanila mpingo wa ŵandu ŵakunkulupilila Kilisito, mummalanjile yalumo mundu jwangakwamanyilila Akunnungu ni jwakukumbikanya nsongo. ");
INSERT INTO yao_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ngunsalila isyene, gagali gose gachingakanye pachilambo chigaŵe gamakanikwe kwinani ni gagali gose gachingakunde pachilambo, chigaŵe gamakundikwe kwinani. ");
INSERT INTO yao_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ngunsalila isyene, ŵaŵili pasikati jenu ajilanaga pachilambo pano kwa chindu chachilichose chichaŵende, Atati ŵangu ŵa kwinani chiŵapanganyichisye chindu cho. ");
INSERT INTO yao_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pakuŵa palipose pakusongangana ŵandu ŵaŵili pane ŵatatu pamo kwa liina lyangu, une ndili pelepo ni ŵanyawo.” ");
INSERT INTO yao_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nipele, che Petulo ŵaichile Che Yesu nikuti, “Ambuje, ana mpwanga aneŵele kalingwa none naalechelesye? Mala saba?” ");
INSERT INTO yao_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Che Yesu ŵajanjile, “Ngangunsalila mala saba pe, nambo saba mala sabini. ");
INSERT INTO yao_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwayele, Umwenye wa kwinani ulandene ni mwenye jumo juŵasakaga kulola achikapolo ŵakwe yatite pakupanganya. ");
INSERT INTO yao_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Paŵatandite kulola, ŵannyichisye mundu jumo juŵaliji ni ligambo lya mamilioni kwa mamilioni. ");
INSERT INTO yao_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mundu jo nganakola chakulipa, kwayele ambujegwe ŵalamwile asumisikwe nti kapolo mundu jula ni ŵankwakwe ni achiŵanagwe ni yanayose iŵakwete, kuti ligambo limale. ");
INSERT INTO yao_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nipele, kapolo jula ŵatindiŵele mmbujo pa ambujegwe ni kwaŵenda achitiji, ‘Ambuje mumbililile kaje, none chinanlipe yose.’ ");
INSERT INTO yao_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mmbujegwe kapolo jula ŵankolele chanasa, ŵannechelesye ligambo lila, ni kuntendela ajaule. ");
INSERT INTO yao_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nambo kapolo jula ŵatyosile, ŵansimene jumo jwa achikapolo achinjakwe juŵandaiji mbiya kanandi. Ŵankamwile ni kunkamula pa lukosi achitiji, ‘Nlipe ligambo lyenu!’ ");
INSERT INTO yao_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nombe kapolo njakwe jula ŵatindiŵele pa makongolo gakwe ŵanchondelele achitiji, ‘Mumbililile kaje, none chinanlipe yose’. ");
INSERT INTO yao_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nombejo ŵakanile, ŵajawile kukumponya mu nyuumba jakutaŵilwa, mpaka patachilipa ligambo lila. ");
INSERT INTO yao_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Nipele, achikapolo achinjakwe paŵaiweni yeleyo ŵasongoneche nnope, ŵajawile kukwasalila ambuje ŵao yose iyatendekwe. ");
INSERT INTO yao_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pele ambujegwe ŵammilasile ni kunsalila, ‘Ugwe jwakutumichila jwangalumbana nnope! Nannechelesye ligambo lila lyose pamwanjondelele. ");
INSERT INTO yao_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ana nganinsachilwa kunkolela chanasa kapolo njenu jo mpela inatite pakunkolela chanasa mmwe?’ ");
INSERT INTO yao_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Nipele mmbujegwe jula ŵatumbile nnope, ŵampeleche katumetume jula kwa ŵakulagasya mpaka pele patachilipa ligambo lyose. ");
INSERT INTO yao_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ni atati ŵangu ŵa kwinani chachintendela iyoyo peyo iŵaga jwalijose mwa ŵanyamwe ngannechelesya mpwakwe ni mtima wakwe wose.” ");
INSERT INTO yao_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Che Yesu paŵamasile kuŵecheta gele maloŵe go, ŵatyosile ku Galilaya, ŵapite ku Yudea peesi lusulo lwa Yolodani. ");
INSERT INTO yao_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ŵandu achajinji ŵakuiye ŵelewo kweleko, nombejo ŵalamisye ilwele yao. ");
INSERT INTO yao_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisayo ŵaichile achalingaga achitiji, “Uli, ana ikusachilwa mundu kunleka ŵankwakwe kwa ligongo lililyose?” ");
INSERT INTO yao_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Che Yesu ŵajanjile, “Uli, ana nganinsyoma Mmalembelo ga Akunnungu kuti Akunnungu juŵangumbile mundu kutyochela kundanda ŵaagumbile jwannume ni jwankongwe? ");
INSERT INTO yao_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ŵapundile kusala, ‘Kwaligongo lyo jwannume chiŵaaleche atatigwe ni achikulugwe, chalumbikane ni ŵankwakwe, nombe ŵaŵili wo chachiŵa chiilu chimo?’ ");
INSERT INTO yao_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kwa yeleyo, ngaaŵa sooni ŵaŵili, nambo chiilu chimo. Nipele chalumbikenye Akunnungu, mundu akachilekanganya.” ");
INSERT INTO yao_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nambo ŵele ŵanyawo ŵausisye, “Nambi kwachichi che Musa ŵatulamwile kuti jwankongwe apegwe talaka ni kunleka?” ");
INSERT INTO yao_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Che Yesu ŵajanjile, “Che Musa ŵannechelele nlekangane ni achiŵankwenu kwa ligongo lya kukakatima kwa mitima jenu. Nambo chitandile kundanda nginiŵa yeleyi. ");
INSERT INTO yao_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nipele none ngunsalila ŵanyamwe, mundu juchalekangane ni ŵankwakwe kwaligongo lililyose ni kulombela jwankongwe jwine, ikaŵe kwa ligongo lya chikululu, akutenda chikululu.” ");
INSERT INTO yao_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ŵakulijiganya ŵao ŵaasalile, “Iŵaga yele kwa mundu ni ŵankwakwe, nipele mmbaya kutama pangalombela.” ");
INSERT INTO yao_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Che Yesu ŵaasalile, “Ngaŵa ŵanawose ŵakukombola kulipochela liloŵe li, nambo ikaŵe ŵele ŵandu ŵapegwile ni Akunnungu machili ga kulipochela liloŵe li. ");
INSERT INTO yao_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pakuŵa kwana indu yakupisyangana yaikuntendekasya mundu kutama pangalombela, apali ŵaŵaŵelekwe yeleyo, ni ŵane atesilwe ni ŵandu atame ŵangalombela ni ŵane asachile achinsyene atame pangalombela kwaligongo lya umwenye wa kwinani. Jwakukombola kulipochela liloŵe li apochele.” ");
INSERT INTO yao_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nipele ŵannyichisye Che Yesu ŵanache achanandi kuti ŵasajichile makono ni kwapopelela. Nambo ŵakulijiganya ŵao ni ŵakalipile. ");
INSERT INTO yao_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Che Yesu ŵatite, “Mwaleche ŵanache aichanje kukwangu ni nkaasiŵila, pakuŵa Umwenye wa kwinani uli wa ŵandu ŵaali mpela ŵanache ŵa.” ");
INSERT INTO yao_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nipele, ŵasajichile makono kuti ŵape upile, ni ŵatyosile pelepo. ");
INSERT INTO yao_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mundu jumo ŵaichile Che Yesu ŵausisye, “Jwakwiganya, ana ndende chindu chi chichili chambone kuti ngapate umi wa moŵa gose pangali mbesi?” ");
INSERT INTO yao_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Che Yesu ŵansalile, “Kwachichi nkuusya yankati umbone? Ngapagwa jwambone, nambo jumope yaani Akunnungu. Mwasakaga kwinjila mu umi, ngakamulichisye makanyo.” ");
INSERT INTO yao_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mundu jula ŵausisye, “Makanyo chi?” Che Yesu ŵatite, “Kasimmulaga ni Kasintenda chikululu ni Kasinjiŵa ni Kasinsala ya unami. ");
INSERT INTO yao_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Sooni, mwachimbichisye atati ŵenu ni achikulu ŵenu ni Munnonyele njenu mpela inkuti pakulinonyela mwasyene.” ");
INSERT INTO yao_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jwanchanda jula ŵatite, “Makanyo ganagose nagakamulisye chitandile wanache wangu, chisoŵile chindu chi sooni?” ");
INSERT INTO yao_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Che Yesu ŵansalile jwelejo, “Mwasakaga kuŵa jwautindimisyo, njaule nkasumisye yose inkwete ni mbiya syo nkaape ŵandu ŵakulaga, nomwe chinkole mbiko kwinani, mwamalaga muunguye.” ");
INSERT INTO yao_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Paŵapilikene yele jwele nchanda jo, ŵajawile aninkusongoneka mu ntima, pakuŵa ŵakwete chipanje chachijinji. ");
INSERT INTO yao_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pelepo Che Yesu ŵaasalile ŵakulijiganya ŵao, “Ngunsalila isyene, chiiŵe yakulimba jwachipanje kwinjila mu Umwenye wa kwinani. ");
INSERT INTO yao_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ngunsalila sooni, ili yakwaluka kwa chinyama chachikuŵilanjikwa ngamia kupeleta pachipowo cha sindano, kupunda jwachipanje kwinjila mu umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ŵakulijiganya ŵao paŵapilikene yele, ŵasimosile nnope, ŵausisye, “Ŵaani nambi, akukombola kukulupuka?” ");
INSERT INTO yao_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Che Yesu ŵalolite, nikuti, “Lyeleli lili lyangakomboleka kwa ŵandu, nambo kwa Akunnungu indu yose ikukomboleka.” ");
INSERT INTO yao_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nipele, che Petulo ŵajanjile, “Nnole, uwe tulesile yose ni kunkuya, chitupate chichi nambi?” ");
INSERT INTO yao_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Che Yesu ŵaasalile, “Ngunsalila isyene, Mwana jwa Mundu pachatame pa chitengu cha umwenye cha ukulu wao mu chilambo cha sambano, ŵanyamwe umunguiye chintame mu itengu kumi na mbili ni kusilamula ngosyo kumi na mbili sya ŵandu ŵa ku Isilaeli. ");
INSERT INTO yao_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ni jwalijose jwalesile nyuumba pane achapwakwe pane achalumbugwe pane atatigwe pane achikulugwe pane ŵanache pane migunda, kwa ligongo lyangu, chachipochela mala mia, ni chachinjila mu umi wa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nambo ŵajinji ŵaali ŵandanda sambano chachiŵa ŵambesi ni ŵaali ŵambesi sambano chachiŵa ŵandanda. ");
INSERT INTO yao_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Umwenye wa kwinani ulandene ni mundu jwaali ni ngunda wa sabibu, juŵatyosile kundaŵi pe kukwaŵika ŵandu ŵakulima mu ngunda wao. ");
INSERT INTO yao_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Paŵamasile kulangana ni ŵakulima kuti chachalipa chipande chimo cha madini ga feza malinga ni malipilo ga lyuŵa limo, ŵapeleche ku ngunda wa sabibu. ");
INSERT INTO yao_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ŵatyosile saa tatu kundaŵi, ŵaweni ŵane ŵangali ni masengo ali ajimi pakusumichisya malonda. ");
INSERT INTO yao_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ŵaasalile, ‘Njende ni ŵanyamwe ku ngunda wa sabibu, none chinanlipe.’ ");
INSERT INTO yao_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nipele, ŵapite. Asyene ngunda ŵala ŵatyosile sooni saa sita ni saa tisa, ŵatesile iyoyo. ");
INSERT INTO yao_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pajaŵandichile saa kumi na moja, ŵatyosile sooni, ŵasimene ŵandu ŵane ali ajimi papopo pakusumisya malonda. Nipele ŵausisye, ‘Kwachichi nkwima apano muusi wose u pangali masengo?’ ");
INSERT INTO yao_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ŵajanjile, ‘Pakuŵa ngapagwa mundu jwatupele masengo.’ Nombejo ŵaasalile, ‘Njaule ni ŵanyamwe nkapanganye masengo ku ngunda wa sabibu.’ ");
INSERT INTO yao_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pakwaswele, nsyene ngunda wa sabibu jula ŵansalile jwakulolela masengo gao kuti, ‘Nkaaŵilanje ŵamasengo mwape malipilo gao, kutandila ŵa kumbesi mpaka ŵa kundanda.’ ");
INSERT INTO yao_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nipele, ŵaiche ŵele ŵaŵapegwilwe masengo katema ka saa kumi na moja, jwalijose ŵapochele chipande chimo cha madini ga feza. ");
INSERT INTO yao_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ni ŵandanda ŵala paŵaiche ŵaganichisye kuti chapochele yakupunda, nambo nombe ŵanyawo ŵapochele chipande chimo cha madini ga feza yalumo ni achinjao. ");
INSERT INTO yao_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Paŵapochele mbiya syao, ŵatandite kwasongonechela asyene ngunda ŵala. ");
INSERT INTO yao_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ŵatite, ‘Aŵaŵa ŵaŵapele masengo kumbesi apangenye masengo kwa katema ka lisaa limo pe, kwachichi ntulipile yalumo ni ŵanyaŵa akuno uweji tupililile masengo gakulimba muusi wose ni lyuŵa lili nkuŵala?’ ");
INSERT INTO yao_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Pelepo nsyene ngunda jula ŵanjanjile jumo jwao kuti, ‘Ambusanga, ngangummonela! Ana nganitulangana none kwa malipilo ga chipande chimo cha madini ga feza? ");
INSERT INTO yao_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Njigale chichili chenu, njaule kumangwenu. Ngunonyelwa kumpa aju junampele masengo kumbesi yalumo ni mmwe. ");
INSERT INTO yao_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Uli, ngangusachilwa kutenda indu ingunonyelwa nkati yose ingwete? Ana nkukola wiwu pakuŵa une ndili jwambone?’ ” ");
INSERT INTO yao_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nipele Che Yesu ŵamalichisye kwa kusala, “Iyoyo ŵaali ŵambesi chachiŵa ŵandanda ni ŵaali ŵandanda chachiŵa ŵambesi.” ");
INSERT INTO yao_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Che Yesu paŵaliji nkukwela kwaula ku Yelusalemu, ŵaajigele ŵakulijiganya ŵao kumi na mbili, paŵaliji nkwenda mwitala, peuto pangali ŵandu ŵane, ŵaasalile, ");
INSERT INTO yao_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nnole! Tukwaula ku Yelusalemu, ni kwele Mwana jwa Mundu chakatajikwe mmakono mwa achakulu ŵambopesi ni ŵakwiganya Malajisyo, nombewo chalamulikwe aulajikwe. ");
INSERT INTO yao_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chakampeleche kwa ŵandu ŵangaŵa Ŵayahudi apate kuntendela chanache ni kumputa mbokola ni kwaŵamba pa nsalaba ni pa lyuŵa lyaatatu chachisyuka.” ");
INSERT INTO yao_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nipele achikulu ŵa ŵanache ŵa che Sebedayo ŵaichile Che Yesu, pamo ni achiŵanagwe, ŵatindiŵalile ni kwaŵenda chindu. ");
INSERT INTO yao_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Che Yesu ŵammusisye, “Chichi nkusaka?” Ŵatite, “Choonde nlanje kuti mu umwenye wenu, achiŵanangu ŵaŵili ŵa chatame, jumo kundyo kwenu ni jwine kunchiji kwenu.” ");
INSERT INTO yao_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Che Yesu ŵajanjile, “Ana nkumanyilila chinkuchiŵenda! Uli chinkombole kuching'welela chikombe cha masauko chiching'wele une?” Ŵanyawo ŵajanjile, “Tukupakombola.” ");
INSERT INTO yao_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Che Yesu ŵaasalile, “Isyene chinng'welele chikombe changu cha masauko, nambo kutama kundyo ni kunchiji kwangu nganigaŵa masengo gangu nambo Akunnungu chachapa lipesa lyo ŵele ŵaŵakolochesye.” ");
INSERT INTO yao_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nombe ŵakulijiganya ŵane likumi ŵala paŵapilikene gele, ŵatumbilile ŵaŵili wo. ");
INSERT INTO yao_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nipele Che Yesu ŵaaŵilasile ni kwasalila, “Nkumanyilila kuti mamwenye ŵa ilambo akwalongosya ŵandu ŵao kwa machili, ni achakulu ŵao akwatenda ali ŵandu ŵao. ");
INSERT INTO yao_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nambo inaŵe yele kukwenu, nambo jwalijose jwakusaka kuŵa jwamkulungwa kukwenu akusachilwa aŵe katumetume jwa wose. ");
INSERT INTO yao_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ni jwalijose jwakusaka kuŵa jwaandanda kukwenu akusachilwa aŵe jwakutumichila jwenu. ");
INSERT INTO yao_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Iyoyopeyo, Mwana jwa Mundu nganaika kuti atumichilwe nambo kuti atumichile, ni kuutyosya umi wakwe kuti gaŵe malipilo kwa ligongo lya chiwombolo cha ŵandu ŵajinji.” ");
INSERT INTO yao_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Che Yesu ni ŵakulijiganya ŵao paŵaliji nkutyoka ku Yeliko, mpingo wa ŵandu ŵaliji nkwakuya. ");
INSERT INTO yao_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nipele, ŵapali ŵangalola ŵaŵili uŵatemi mungulugulu litala, nombewo paŵapikene kuti Che Yesu ŵaliji nkupita pelepo, ŵanyanyisye achitiji, “Ambuje, Mwana ju che Daudi, choonde ntukolele chanasa!” ");
INSERT INTO yao_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mpingo wa ŵandu wakalipile ni kwasalila amyalale. Nambo ŵanyawo ŵapundangenye kunyanyisya, achitiji, “Ambuje, Mwana ju che Daudi, choonde ntukolele chanasa!” ");
INSERT INTO yao_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Che Yesu ŵajimi, ŵaaŵilasile ni kwausya, “Ana nkusaka nampanganyichisye ichichi?” ");
INSERT INTO yao_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ŵajanjile, “Ambuje, tukummenda gaunukuche meeso getu.” ");
INSERT INTO yao_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nipele, Che Yesu ŵakolele chanasa, ŵakwaiye meeso gao ni papopo ŵakombwele kulola, ni ŵankuiye. ");
INSERT INTO yao_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Che Yesu pamo ni ŵakulijiganya ŵao ŵaŵandichile ku Yelusalemu, ni paŵaiche ku Besefage pachikwesya cha Miseituni, ŵatumile ŵakulijiganya ŵaŵili. ");
INSERT INTO yao_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ŵaasalile, “Njaule kunsinda wauli mmbujo mwenu, ni kweleko chinkajisimane mbunda jajitaŵikwe ni mwanambunda pamo najo. Nkaagopole njise nawo kwangune. ");
INSERT INTO yao_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Iŵaga chakammusye mundu ligongo lya kwagopola, nkajile, ‘Ambuje akusisaka,’ ni pangakaŵa chakannechele.” ");
INSERT INTO yao_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ali lyatendekwe kuti gamalile gaŵaŵechete jwakulondola jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mwasalile ŵandu ŵa musi wa Sayuni, Nnole, Mwenye jwenu akunnyichilila! Atulele, ni akwesile mbunda, ni mwanambunda, chinyama chachikujigala itutule.” ");
INSERT INTO yao_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ŵakulijiganya ŵala ŵajawile, ŵatesile mpela iŵatite pakusalilwa ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ŵajiichenawo mbunda ni mwanambunda, ŵatandiche nguo syao pachanya pawo ni Che Yesu ŵatemi pachanya pakwe. ");
INSERT INTO yao_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mpingo wekulungwa wa ŵandu watandiche nguo syao mwitala, ni ŵane ŵakatile nyambi sya mwana sya itela ni ŵatandiche mwitala. ");
INSERT INTO yao_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mipingo ja ŵandu ŵaŵalongolele ni ŵaŵakuiye ŵanyanyisye achitiji, “Ajinichilwe Mwana ju che Daudi, Akole upile jwele jwakwika mu liina lya Ambuje! Ajinichilwe Akunnungu ŵaali kwinani!” ");
INSERT INTO yao_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Che Yesu paŵajinjilaga ku Yelusalemu, ŵandu ŵa musi wose ŵaliji jugulijuguli. Ŵandu ŵaliji nkuusyana, “Ana aju ali nduni?” ");
INSERT INTO yao_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ŵandu mu mpingo ula ŵatite, “Ŵeleŵa ni Che Yesu, jwakulondola jwa Akunnungu kutyochela ku Nasaleti musi wa ku Galilaya.” ");
INSERT INTO yao_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nipele, Che Yesu ŵajinjile mu lutenje lwa Nyuumba ja Akunnungu, ŵaaŵinjile ŵanawose uŵasumisyaga ni kusuma malonda pepala, ŵapitikwisye mesa sya ŵaŵasumanyaga mbiya, ni itengu yao ŵaŵasumisyaga nguunda. ");
INSERT INTO yao_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ŵaasalile, “Ilembekwe Mmalembelo ga Akunnungu, ‘Nyuumba jangu chijiŵilanjikwe nyuumba ja kupopelela.’ Nambo ŵanyamwe njitesile peuto pakulisisila ŵa wiyi.” ");
INSERT INTO yao_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ŵangalola ni ŵakulemala ŵanjaulile pa Nyuumba ja Akunnungu, nombe Che Yesu ŵalamisye. ");
INSERT INTO yao_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Achakulu ŵambopesi ni ŵakwiganya Malajisyo paŵaiweni indu yambone nnope iŵaitesile Che Yesu ni ŵanache ali nkunyanyisya pa Nyuumba ja Akunnungu achitiji, “Ajinichilwe Mwana ju che Daudi,” ŵanyawo ŵatumbile. ");
INSERT INTO yao_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ŵausisye, “Uli ngankupilikana yakuti ŵanache?” Che Yesu ŵajanjile, “Elo, ngupikana! Ana nganinsyome Maloŵe ga? ‘Kutyochela nkang'wa sya ŵanache achanandi ni ŵakonga, nlipatile lumbili lwemalilwe.’ ” ");
INSERT INTO yao_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nipele, ŵalesile, ŵakopweche mmusi ni kwaula ku Besania ni kugona kweleko. ");
INSERT INTO yao_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kundaŵi, Che Yesu paŵaujaga kwaula ku Yelusalemu, jakwete sala. ");
INSERT INTO yao_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ŵauweni ntini mungulugulu litala, ŵaujaulile, nambo nganachisimana chindu mwelemo, ŵausimene uli masamba pe. Ŵausalile, “Nkasogola isogosi sooni moŵa gose pangali mbesi!” Papopo nkuju wo wanyasile. ");
INSERT INTO yao_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ŵakulijiganya paŵauweni, ŵasimosile, ŵaliusisye, “Ntini u ujumwile chinauli chitema kwantinyi?” ");
INSERT INTO yao_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Che Yesu ŵajanjile, “Ngunsalila isyene, mwaŵaga ni chikulupi pangali lipamba lili lyose, chinkombole kupanganya ngaŵa yeleyo pe yaitendekwe mu chitela cha ntini, nambo atamuno mwachisalilaga achi chitumbi chi, ‘Ntupuche ni kuliponya mu bahali,’ chiitendekwe iyoyo. ");
INSERT INTO yao_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mwakolaga chikulupi, chachilichose chachimmende nkupopela, chimpate.” ");
INSERT INTO yao_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Che Yesu ŵajinjile pa Nyuumba ja Akunnungu, ni kwiganya. Paŵajiganyaga, achakulu ŵa mbopesi ni achakulu ŵane ŵa ŵandu ŵausisye kuti, “Ana kwa ukombole chi nkutenda yele indu yi? Ŵaani ŵampele wele ukombole u?” ");
INSERT INTO yao_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Che Yesu ŵajanjile, “None chinammusye liusyo limo pe, mwanyangaga, nipele, none chinansalile kwa ukombole chi nguitenda indu yi. ");
INSERT INTO yao_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Uli ukombole u che Yohana wa kubatisya watyochele kwapi? Watyochele kwinani pane kwa ŵandu?” Nambo ŵaŵechetesyene achinsyene pe achitiji, “Twajilaga, ‘Watyosile kwinani,’ chatuusye, ‘Nambi kwachichi nganimunkulupilila?’ ");
INSERT INTO yao_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nambo twajilaga, ‘Watyochele kwa ŵandu,’ tukogopa mpingo wa ŵandu pakuŵa ŵanawose akwitichisya kuti che Yohana ali jwakulondola jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nipele, ŵajanjile, “Ngatukumanyilila!” Nombe Che Yesu ŵatite, “Atamuno une ngangunsalila ŵanyamwe kwa ukombole chi nguitenda indu yi. ");
INSERT INTO yao_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ŵanyamwe nkuganisya uli? Mundu jumo ŵakwete achachanda ŵaŵili. Ŵantendele jwaandanda jo kuti, ‘Mwanangu, lelo njaule nkapanganye masengo mungunda wa sabibu.’ ");
INSERT INTO yao_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nchanda jo ŵajanjile, ‘Ngangusaka!’ Nambo kanyuma kakwe ŵapitikwiche ntima, ŵajawile kupanganya masengo. ");
INSERT INTO yao_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Atati ŵala ŵanjaulile mwanagwe jwaaŵili jo ni kunsalila ilaila, nombe ŵajanjile ŵatite, ‘Elo, atati!’ Nambo nganajaula kumasengo. ");
INSERT INTO yao_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ana jwapi jwa ŵele ŵaŵili wo jwatesile yakuisaka atatigwe?” Ŵajanjile, “Jwanchanda jwaandanda jo.” Che Yesu ŵatite, “Ngunsalila isyene, ŵakukumbikanya nsongo ni ŵakulaŵalaŵa chajinjile mu Umwenye wa Akunnungu nkanaŵe kwinjila. ");
INSERT INTO yao_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pakuŵa che Yohana ŵaiche kukwenu ni kunnanjila kutama yambone nti yakuti pakusaka Akunnungu, ni ŵanyamwe nganimunkulupilila, nambo ŵakukumbikanya nsongo ni ŵakulaŵalaŵa ŵankulupilile. Ni ŵanyamwe pammasile kugawona gele nganinleka sambi ni kunkulupilila.” ");
INSERT INTO yao_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Che Yesu ŵatite, “Mpilikanile chitagu chine. Jwapali mundu jumo nsyene nyuumba ŵalimile ngunda wa sabibu, ŵausyunguchisye lutenje ni ŵakolosisye pakuminyila sabibu, ŵataŵile chilindo mmomopemo. Nipele ŵaujasimisye kwa ŵakulima ni kwaula ku chilambo cha kutalika. ");
INSERT INTO yao_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Katema ka kugungula, ŵatumile achikapolo ŵao kwa ŵakulima ŵala, kuti akajigale liunjili lyakwe lya magungulo. ");
INSERT INTO yao_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ŵakulima ŵala ŵakamwile achikapolo ŵao, jumo ŵamputile, ni jwine ŵammuleje, ni jwine ŵamponyile maganga. ");
INSERT INTO yao_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sooni ŵatumile achikapolo ŵane ŵajinji kupunda ŵa kundanda. Ŵakulima ŵala ŵajasime ngunda ŵatendele ilaila. ");
INSERT INTO yao_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kumbesi kwakwe ŵantumile mwanagwe achiganisyaga mu ntima wakwe achitiji, ‘Chakanchimbichisye mwanangu.’ ");
INSERT INTO yao_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nambo ŵakulima ŵala paŵammweni mwanagwao ŵaŵechetesyene achinsyene pe, ‘Aju ni juchapochele iŵagosele, twende tummulaje kuti indu iŵagosele tujigale uwe!’ ");
INSERT INTO yao_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nipele, ŵankamwile, ŵantyosisye paasa ngunda wa sabibu, ŵammuleje. ");
INSERT INTO yao_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Sambano, nsyene ngunda wa sabibu jula pachachiika, chachatenda ichichi ŵakulima ŵala?” ");
INSERT INTO yao_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ŵanyawo ŵajanjile, “Chachajonanga wamba ŵele ŵachigongomalo wo ni ngunda wa sabibu ula chachiujasimisya kwa ŵakulima ŵane uchachapa liunjili lyakwe lya magungulo kwa katema kakwe.” ");
INSERT INTO yao_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Pelepo Che Yesu ŵaasalile, “Uli ana nganinsyome lye liloŵe li Mmalembelo ga Akunnungu? ‘Liganga liŵalikanile ŵakutaŵa sambano lilyolyo lili lyetendekwe liganga lyalikusachilwa kwannope kugapunda maganga gose. Ambuje ni ŵatesile achi chindu chi, nombe chili chakusimonjeka nnope kwetuwe!’ ");
INSERT INTO yao_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kwayele ngunsalila, Umwenye wa Akunnungu chiutyosekwe kukwenu, ni kupegwa ŵandu ŵakupanganya yakuisaka Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jwalijose juchagwilile pa liganga lyo chakasiche ipande ipande, ni jwalijose juchilyagwilile, chilinkanyatekanyate. ");
INSERT INTO yao_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Achakulu ŵa mbopesi ni Mafalisayo paŵapilikene itagu yao, ŵamanyilile kuti ŵaliji nkwagamba ŵanyawo. ");
INSERT INTO yao_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nipele ŵasosaga litala lya kwakamula, nambo ŵajogwepe ŵandu pakuŵa ŵanyawo ŵanganisisye nti jwakulondola jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Che Yesu ŵaŵechetenawo sooni kwa itagu achitiji, ");
INSERT INTO yao_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Umwenye wa kwinani ulandene ni mwenye jumpepe juŵantendele mwanagwe chindimba cha chakulya cha ulombela. ");
INSERT INTO yao_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nipele ŵatumile achikapolo ŵao kukwaŵilanga ŵaalaliche kwika ku ulombela, nambo ŵakanile kwika. ");
INSERT INTO yao_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ŵaatumile sooni achikapolo ŵane, achitiji, ‘Mwasalile ŵalalichikwe ŵala kuti, jwammale kolosya yakulya yangu, sikite ng'ombe jangu ja nkambaku ni ng'ombe sine syakunakana, inayose ili chile, njise ku ulombela.’ ");
INSERT INTO yao_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nambo ŵandu ŵala ŵakanile kwika, ŵajawile, jumo ku ngunda wakwe, ni jwine ku masengo gakwe, ");
INSERT INTO yao_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ni ŵane ŵaakamwile achikapolo ŵala ŵaputile ni ŵane kwaulaga. ");
INSERT INTO yao_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mwenye jula ŵatumbile, ŵaatumile ŵandu ŵangondo ŵao kuti akaaulaje ŵakuulaga ŵala ni kuchoma mooto musi wao. ");
INSERT INTO yao_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nipele ŵaasalile achikapolo ŵao, ‘Ulombela uli chile, nambo unalaliche ŵala nganaŵajilwa. ");
INSERT INTO yao_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nipele njaule mmalekano ni ŵanawose uchinkaasimane, nkaaŵilanje aichanje ku chindimba cha chakulya cha ulombela.’ ");
INSERT INTO yao_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Achikapolo ŵao ŵala ŵatyosile, ŵajawile mmatala, ŵaichenawo wose uŵasimene nawo, ŵangalumbana ni ŵambone. Nyuumba ja ulombela jagumbele achalendo. ");
INSERT INTO yao_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nambo paŵajinjile mwenye ku kwalola achalendo, ŵammweni mundu jumo jwanganatakula nguo sya ulombela. ");
INSERT INTO yao_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mwenye ŵammusisye, ‘Ambusanga, njinjile chinauli, nomwe nganinkola nguo sya ulombela?’ Nambo ŵelewo ŵamyalele. ");
INSERT INTO yao_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nipele, mwenye ŵaasalile achikatumetume ŵao, ‘Muntaŵe makongolo ni makono, mkamponye paasa ku chipi, kweleko chakalile ni kuchilimya meeno.’ ” ");
INSERT INTO yao_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Che Yesu ŵamalichisye achitiji, “Ŵajinji ŵakuŵilanjikwa, nambo ŵasagulikwe nganatupa.” ");
INSERT INTO yao_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nipele, Mafalisayo ŵajawile, ŵajilene itajile pa kwatanjisya Che Yesu kwa maloŵe gao. ");
INSERT INTO yao_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nipele, ŵaatumile ŵakulijiganya ŵao, pamo ni ŵakulijiganya ŵa mumpingo u che Helode ku Che Yesu. Ŵausisye achitiji, “Jwakwiganya, tukumanyilila kuti mmwe ndi mundu jwakulupilichika, nkwiganya litala lya Akunnungu kwa usyene, pangaganisya ŵandu akusala chichi, pakuŵa ngankulola ukulu wa mundu. ");
INSERT INTO yao_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sambano, ntusalile, nkuganisya ichichi? Uli ili yambone kulipa nsongo kwa mwenye jwankulu jwa ku Loma pane akuŵilanjikwa che Kaisali, pane tunalipe?” ");
INSERT INTO yao_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nambo Che Yesu ŵaumanyilile nningwa wao wangalumbana, ŵaasalile, “Kwachichi nkuuninga, ŵanyamwe ŵaulamba? ");
INSERT INTO yao_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Munosye mbiya ja kulipila nsongo.” Nombewo ŵaiche nawo likobili. ");
INSERT INTO yao_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nipele, Che Yesu ŵausisye, “Aku ku meeso ku ni liina li ya ŵaani?” ");
INSERT INTO yao_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ŵajanjile, “Che Kaisali.” Pelepo Che Yesu ŵaasalile ŵanyawo kuti, “Nipele, i che Kaisali mwapeje che Kaisali, ni ya Akunnungu mwapeje Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Paŵagapilikene gele ŵasimosile, ŵalesile, ŵajawile. ");
INSERT INTO yao_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lye lyuŵa lyo, Masadukayo ŵane ŵakuti ngapagwa kusyuka ŵaichilile Che Yesu, ");
INSERT INTO yao_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","nipele, ŵausisye, “Jwakwiganya, che Musa ŵatite mundu jwalombele awaga pangaleka ŵanache, ikusachilwa mpwakwe annombele jwankongwe jwawililwe ni ŵankwakwe, kuti ammelechele ŵanache nkulugwe. ");
INSERT INTO yao_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nipele, pa musi petu pano ŵapali ŵandu saba ŵaŵapagwile lutumbo lumo. Jwaandanda jo ŵalombele ni ŵawile pangali ŵanache, ni mpwakwe ŵannombile jwankongwe jula. ");
INSERT INTO yao_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Iyoyo yaliji kwa jwaaŵili jula ni jwaatatu ni mpaka ŵanawose saba. ");
INSERT INTO yao_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Paŵamasile kuwa ŵanawose saba, jwankongwe jula ŵawile. ");
INSERT INTO yao_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nambi, pa lyuŵa lya kusyuka jwele jwankongwe chaŵe jwa ŵaani mwa ŵele saba wo? Pakuŵa wose saba ŵannombile.” ");
INSERT INTO yao_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Che Yesu ŵajanjile ŵanyawo, “Ŵanyamwe nkosele pakuŵa ngankugamanyilila Malembelo ga Akunnungu atamuno ukombole wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pakuŵa pachachisyuka ŵawe ngalombela atamuno kulombwa, chaaŵe mpela achikatumetume ŵa kwinani. ");
INSERT INTO yao_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nambo yankati kusyuka kwa ŵawe, uli, nganinsyoma aila iŵansalile Akunnungu? Ŵansalile, ");
INSERT INTO yao_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Une ndili Akunnungu ŵa che Iblahimu ni Akunnungu ŵa che Isaka ni Akunnungu ŵa che Yakobo.’ Nipele ŵele nganaŵa Akunnungu ŵa ŵawe, nambo ŵa ŵajumi.” ");
INSERT INTO yao_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mpingo wa ŵandu ula paŵapilikene yeleyo, ŵagasimosile majiganyo gao. ");
INSERT INTO yao_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafalisayo paŵapilikene kuti Che Yesu ŵamyalesye Masadukayo, ŵasongangene pamo. ");
INSERT INTO yao_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jumo jwao, ŵakwiganya malajisyo, ŵausisye Che Yesu achalingaga kuti, ");
INSERT INTO yao_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Jwakwiganya, likanyo chi lyalili lyekulungwa mu Malajisyo?” ");
INSERT INTO yao_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Che Yesu ŵanjanjile, “ ‘Mwanonyele Ambuje Akunnungu ŵenu ni ntima wenu wose ni mbumu jenu jose ni lunda lwenu lose.’ ");
INSERT INTO yao_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Alili ni likanyo lyekulungwa ni lyaandanda. ");
INSERT INTO yao_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ni lyaaŵili lyalikulandana ni lyele, lili, ‘Munnonyele njenu mpela yankuti pakulinonyela mwasyene.’ ");
INSERT INTO yao_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malajisyo gose ga Akunnungu gaŵapele che Musa ni majiganyo ga ŵakulondola ŵa Akunnungu gakukulupilila ge makanyo gaŵili ga.” ");
INSERT INTO yao_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Paŵasongangene pamo Mafalisayo, Che Yesu ŵausisye, ");
INSERT INTO yao_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ŵanyamwe nkuganisya uli yankati Kilisito? Uli ali mwanagwao ŵaani?” Ŵajanjile, “Ŵa che Daudi.” ");
INSERT INTO yao_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Che Yesu ŵaasalile, “Nipele, kwachichi che Daudi kwa ukombole wa Mbumu jwa Akunnungu akwaŵilanga Ambuje? Pakuŵa ŵatite, ");
INSERT INTO yao_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ambuje ŵaasalile Ambuje ŵangu, ntame kundyo, mpaka pachinaaŵiche ŵammagongo ŵenu paasi pa makongolo genu.’ ");
INSERT INTO yao_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nipele, iŵaga che Daudi akwaŵilanga Kilisito ‘Ambuje’ ikukomboleka chinauli kuti ali mwanagwao?” ");
INSERT INTO yao_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ngapagwa mundu jwalijose juŵakombwele kwanga. Chitandile lyuŵa lyo ngapagwa juŵalinjile sooni kummusya. ");
INSERT INTO yao_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nipele, Che Yesu ŵausalile mpingo wa ŵandu ni ŵakulijiganya ŵao kuti, ");
INSERT INTO yao_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ŵakwiganya malajisyo ni Mafalisayo akwete ukombole wa kusala uchenene Malajisyo. ");
INSERT INTO yao_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kwalye ligongo lyo mpikanichisye ni kutenda chachili chose chichansalile. Nambo nkasyasya isambo yao, pakuŵa ngakutenda yele yakuisala yo. ");
INSERT INTO yao_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Akutaŵanga misigo jakutopela ni kwatwika ŵandu mmakoyo, nambo ŵele achinsyene wo ngakusaka atamuno kukwaya ni chala. ");
INSERT INTO yao_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ŵanyawo akugatenda masengo gao gose kuti apate kuloleka ni ŵandu. Akuwala indu yailembekwe malembelo ga malajisyo pachanya meeso ni konjechesya ukulu wa nguo syao kuti aloleche ali ŵandu ŵa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ikwanonyela kutama peuto pa kuchimbichikwa mu indimba ni itengu ya kuchimbichikwa mmajumba ga kupopelela. ");
INSERT INTO yao_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ikwanonyela kwakomasya kwa kwachimbichisya pa kusumichisya malonda ni kusaka ŵandu ŵaŵilanje, ‘Jwakwiganya.’ ");
INSERT INTO yao_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nambo ŵanyamwe nkaŵilanjikwa ‘Jwakwiganya,’ pakuŵa jwakwiganya jwenu ali jumo pe, ni wose ndi achalongo. ");
INSERT INTO yao_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Atamuno ngasimummilanga mundu ‘Atati’ pa chilambo pano, pakuŵa Atati ŵetu ali ŵamo pe, ŵaali kwinani. ");
INSERT INTO yao_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Atamuno ngasimmilanjikwa ‘ilongola’ pakuŵa chilongola jwenu ali jumo pe, yaani Kilisito. ");
INSERT INTO yao_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nombe jwali jwankulungwa jwenu chaaŵe katumetume jwenu. ");
INSERT INTO yao_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jwakulikwesya chatuluswe ni jwakulitulusya chachikweswa. ");
INSERT INTO yao_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ulaje uwe kukwenu ŵakwiganya Malajisyo ni Mafalisayo, ŵaulamba! Pakuŵa nkuugala nnango wa Umwenye wa kwinani mmbujo pa ŵandu. Ni ŵanyamwe mwachinsyene ngankwinjila, atamuno ngankwaleka ŵakusaka kwinjila ajinjile. ");
INSERT INTO yao_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ulaje uwe kukwenu ŵakwiganya Malajisyo ni Mafalisayo, ŵaulamba! Nkwasumula ŵawililwe ni achiŵankwawo ipanje yao nchilitendaga ŵandu ŵambone nkupopela mapopelo gamaleu, kwa lye ligongo lyo kulaga kwenu chikuŵe kwakukulungwa nnope. ");
INSERT INTO yao_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ulaje uwe kukwenu ŵakwiganya Malajisyo ni Mafalisayo, ŵaulamba! Pakuŵa nkutaŵa ulendo mu bahali ni pa chilambo kuti nkombole kuntenda namose mundu jumo aŵe jwa kunkuya mwanya. Pankumpata, nkuntenda aŵe mundu jwakwinjila ku jehanamu kumpunda mwachinsyene. ");
INSERT INTO yao_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ulaje uwe kukwenu ilongola ŵangalola! Ŵanyamwe nkutinji mundu alumbililaga kwa Nyuumba ja Akunnungu, kwele kulumbila ko ngaŵa chindu, nambo alumbililaga kwa sahabu ja Nyuumba ja Akunnungu, kwele kulumbilila ko kukwakanganichisya kuchitenda chalumbilile. ");
INSERT INTO yao_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ŵanyamwe ŵangalola ŵakuloŵela! Chapi chachili cha malumbo nnope, sahabu pane Nyuumba ja Akunnungu jajikujitenda sahabu jiŵe jeswela? ");
INSERT INTO yao_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Sooni nkutinji mundu alumbililaga pa chilisa ngaŵa chindu, nambo alumbilaga nkujikolanga mbopesi jajili pa chilisa, kwele kulumbilila ko kukwakanganichisya kuchitenda chalumbilile. ");
INSERT INTO yao_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ŵanyamwe ŵangalola! Ana kulumbilila chi kwakuli kwamalumbo nnope, kwa mbopesi pane kwa chilisa chachikujitenda mbopesi jiŵe jeswela? ");
INSERT INTO yao_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jwakulumbila kwa chilisa akulumbilila kwa chele chilisa cho, ni kwa chose chachili pachanya pakwe. ");
INSERT INTO yao_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ni jwakulumbila kwa Nyuumba ja Akunnungu akulumbilila kwa Nyuumba ja Akunnungu ni kwa jwele jwakutama nkati mo. ");
INSERT INTO yao_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nombe jwakulumbila kwa kwinani akulumbilila kwa chitengu cha Umwenye wa Akunnungu, ni kwa jwele jwakutama pachanya pakwe. ");
INSERT INTO yao_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ulaje uwe kukwenu ŵakwiganya Malajisyo ni Mafalisayo, ŵaulamba! Nkupochela mbopesi kwa ŵandu, atamuno pa masamba ga kununjila, ni bisali ni jila, nkuileka indu yekulungwa yailajichikwe ni Malajisyo mpela ila kupanganya yaikwanonyelesya Akunnungu ni chanasa ni chikulupi. Gelega ni gankusachilwa kugakamulisya pangagaliŵalila gane. ");
INSERT INTO yao_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ilongola ŵangalola! Nkujityosya membe mu yakung'wa, nambo nkuchimila chinyama chachikuŵilanjikwa ngamia! ");
INSERT INTO yao_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ulaje uwe kukwenu ŵakwiganya Malajisyo ni Mafalisayo, ŵaulamba! Nkosya chikombe ni mbale kwa paasa, nambo nkati nkuleka indu impatile kwa wiyi ni nsese. ");
INSERT INTO yao_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ugwe Mfalisayo jwangalola! Njosye chikombe nkati kaje ni paasa chipasalale. ");
INSERT INTO yao_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ulaje uwe kukwenu ŵakwiganya Malajisyo ni Mafalisayo, ŵaulamba! Pakuŵa nkulandana ni malembe gagasililwe ni chokaa, nombe kwa paasa gakuwoneka kuŵa gambone, nambo nkati mwakwe gagumbele maupa ga ŵawe ni usakwa wejinji. ");
INSERT INTO yao_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Iyoyopeyo ni ŵanyamwe kwa paasa nkuoneka ni ŵandu kuŵa ŵambone nambo nkati ngumbele ulamba ni ungalimate. ");
INSERT INTO yao_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ulaje uwe kukwenu ŵakwiganya Malajisyo ni Mafalisayo, ŵaulamba! Nkugumba malembe ga ŵakulondola ŵa Akunnungu ni kugasalalisya malembe ga ŵandu ŵambone. ");
INSERT INTO yao_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nkutinji, ‘Tukaapali kalakala katema ka achambuje ŵetu, ngatukaŵe pamo mmaulajo ga ŵakulondola ŵa Akunnungu!’ ");
INSERT INTO yao_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kwakuŵecheta yeleyo nkulilosya mwachinsyene kuti ŵanyamwe ndi achiŵana ŵa aŵala ŵaŵauleje ŵakulondola ŵa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hayaga, mmalichisye masengo gaŵachokwele achambuje ŵenu! ");
INSERT INTO yao_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ŵanyamwe ŵa uŵelesi wa lijoka lya sumu! Chimmutuche chinauli ulamusi wa ku jehanamu? ");
INSERT INTO yao_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nipele lye ligongo lyo une ngumpelechela ŵanyamwe ŵakulondola ŵa Akunnungu, ŵandu ŵa lunda ni ŵakwiganya malajisyo, ŵane mwa ŵanyawo chimwaulaje ni kwaŵamba pa nsalaba, ni ŵane chimwapute ibokola mmajumba genu ga kupopelela ni kwasosa mmisi jinajose. ");
INSERT INTO yao_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nipele chileŵo chichiŵe kukwenu kwa ligongo lya miasi ja ŵandu ŵambone jajijitiche mu chilambo muno. Elo chitandile chiwa chi che Habili jwanganakola chileŵo mpaka chi che Sakalia, mwana ju che Balakia, jumwammuleje pa Nyuumba ja Akunnungu pasikati ja papaswela ni chilisa. ");
INSERT INTO yao_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Isyene ngunsalila kuti, ŵandu ŵa uŵelesi u chalamulikwe kwa ligongo lya indu yi. ");
INSERT INTO yao_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalemu! Ugwe Yelusalemu! Nkwaulaga ŵakulondola ŵa Akunnungu ni kwaputa maganga ŵelewo ŵaŵatumikwe kukwenu. Ana kalingwa nasachile kwasonganganya achiŵana ŵenu, mpela nguku ijikuti pakwasonganganya achiŵanagwe kusi kwa mapapiko gakwe, nambo mwakanile. ");
INSERT INTO yao_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ayaga nipele, nyuumba jenu chijisigale lisame pe. ");
INSERT INTO yao_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ngunsalila, ngamuumona sooni mpaka pachinchiti, ‘Akole upile jwele jwakwika mu liina lya Ambuje.’ ” ");
INSERT INTO yao_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Che Yesu ŵakopweche pa Nyuumba ja Akunnungu, ni paŵajaulaga, ŵakulijiganya ŵao ŵajaulile ni kwalosya majumba ga Nyuumba ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Che Yesu ŵaasalile, “Elo, gose gankugawona ga! Isyene ngunsalila kuti, ngapagwa liganga namuno limo lichilisigale pa line, kila chindu chichijonasikwe.” ");
INSERT INTO yao_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Che Yesu paŵatemi ku chitumbi cha Miseituni, ŵakulijiganya ŵajaulile pa chisyepela, ŵausisye, “Ntusalile ana gelega chigatyochele chakachi? Ni chimanyisyo chi chakutulosya kwika kwenu ni kumbesi kwa chilambo chino?” ");
INSERT INTO yao_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Che Yesu ŵajanjile, “Nlilolechesye kuti akaika kunnambusya mundu. ");
INSERT INTO yao_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pakuŵa achajinji chakopochele aninkuti, une ndili Kilisito nombewo chachasoyasya ŵandu ŵajinji. ");
INSERT INTO yao_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Chimpikane yankati ngondo ni kusongona yankati ngondo, nambo nkatojima, pakuŵa gelega gakusachilwa gatyochele kaje, nambo kumbesi kwakwe kukanaŵe. ");
INSERT INTO yao_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chilambo chimo chichiputane ni chine, umwenye umo chiuputane ni wine. Kosekose kuchichiŵa ni sala ni chindendemesi cha chilambo. ");
INSERT INTO yao_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aga ganagose ga gali mpela kutanda kwa chilungusi. ");
INSERT INTO yao_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nipele chachintyosya kuti ansausye ni kummulaga. Chinchichimwa ni ŵandu ŵa ilambo yose ligongo lya liina lyangu. ");
INSERT INTO yao_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sooni, achajinji chachileche chikulupi chao, chachigalaukana ni kuchimana jwine ni jwine. ");
INSERT INTO yao_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Chachikopochela ŵakulondola ŵa unami achajinji chiŵalambusye ŵandu ŵajinji ");
INSERT INTO yao_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ligongo lya winji wa ungalimate, unonyelo wa ŵandu ŵajinji chiuchinandupa. ");
INSERT INTO yao_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nambo jwalijose juchapililile mpaka kumbesi, jwelejo ni juchakulupuche. ");
INSERT INTO yao_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nambo, kukanaŵe kwika kumbesi, aji Ngani Jambone ja umwenye wa Akunnungu chijilalichikwe pa chilambo chose jiŵe umboni kwa ilambo yose. ");
INSERT INTO yao_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nipele, pachinchione ‘Chindu cha soni chachikusakasya Nyuumba ja Akunnungu’ chichaŵechetekwe ni che Danieli, jwakulondola jwa Akunnungu kuti chijimi peuto papaswela, ŵakusyoma amanyilile malumbo gakwe. ");
INSERT INTO yao_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pelepo, ŵaali ku Yudea autuchile kumatumbi. ");
INSERT INTO yao_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jwaali pachanya nyuumba akatuluka ni kwinjila nkati kukwigala chindu. ");
INSERT INTO yao_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jwaali ku migunda akauja panyuma kukwigala nguo jao. ");
INSERT INTO yao_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ulaje kukwao ŵele utachiŵa pachiilu ni ŵachajonjesye gele moŵa go! ");
INSERT INTO yao_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mpopele kuti kuutuka kwenu kunaŵe katema ka mbepo, atamuno Lyuŵa lya Kupumulila! ");
INSERT INTO yao_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Pakuŵa kele katema ko chikupagwe kulaga kwakukulungwa kwati nganikupagwe chitandile kugumbikwa chilambo chino mpaka sambano, atamuno ngali pachikutyochele sooni. ");
INSERT INTO yao_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Iŵaga gele moŵa go ngagakapunguchikwe, ngapagwa mundu jwakakulupwiche, nambo gele moŵa go chigapunguchikwe kwa ligongo lya ŵele ŵaŵasagulikwe. ");
INSERT INTO yao_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nipele, kele katema ko mundu aikaga kunsalila, ‘Kilisito ali apa’ pane ‘Ali akuno,’ nkakulupilila. ");
INSERT INTO yao_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pakuŵa chachikopochela ŵanya kilisito ŵa unami ni ŵakulondola ŵa unami. Chachitenda imanyisyo yaikulungwa ni yakusimonjeka ya kwalambusya ŵandu yakombolekaga namose ŵasagulikwe ŵa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mpilikane, nanjamwiche chile kakanaŵe katema. ");
INSERT INTO yao_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nipele, ansalilaga kuti, ‘Nnole, ali mwipululu,’ nkajaula kweleko, pane ‘Nnole, ali munkati,’ nkakulupilila. ");
INSERT INTO yao_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pakuŵa, mpela njasi ijikuti kumesya kutyochela kungopochelo lyuŵa mpaka kulikutiŵila lyuŵa, iyoyo peyo ni ichijile kwika kwa Mwana jwa Mundu. ");
INSERT INTO yao_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pele pauli ntembo, ni patachisongangana achikapungu. ");
INSERT INTO yao_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nambo nkumala kulaga kwa ge moŵa go, lyuŵa chilipilile, ni lwesi ngalulanguchisya, ni ndondwa sisipatuche kutyochela kwinani ni machili ga kwinani chigachitinganyika. ");
INSERT INTO yao_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nipele, chimanyisyo cha Mwana jwa Mundu chichioneche kwinani, pelepo ŵandu wose ŵa pa chilambo chalile, Chachimmona Mwana jwa Mundu ali nkwika pachanya maunde ga kwiunde, ni machili ni ukulu wekulungwa. ");
INSERT INTO yao_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nombe chachatuma achikatumetume ŵao ŵa kwinani ali akamulile mapenga ga kusona nnope, ni ŵanyawo chachasonganganya ŵandu ŵao uŵasagulikwe kutyochela mbande syose ncheche sya chilambo, chitandile aji mbesi ja kwinani mpaka aji mbesi ji. ");
INSERT INTO yao_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kwa chitela cha ntini nlijiganye achi chitagu chi, Paukutanda kola nyambi ni kusipuka masamba, ŵanyamwe nkumanyilila kuti katema ka chuuku kaŵandichile. ");
INSERT INTO yao_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iyoyo peyo ŵanyamwe pachingaone aga gose ga gali nkutendekwa, mmanyilile kuti katema ka une kuuja kaŵandichile. ");
INSERT INTO yao_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Isyene ngunsalila, Au uŵelesi u ngaupita gakanaŵe kutendekwa aga gose ga. ");
INSERT INTO yao_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kwinani ni chilambo chiichipita, nambo maloŵe gangu ngagapita ng'o. ");
INSERT INTO yao_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nambo, yankati lyuŵa ni saa, ngapagwa ŵakuimanyilila chakachi chiikopochele, atamuno achikatumetume ŵa kwinani, atamuno Mwana, Atati jika pe ni ŵakumanyilila. ");
INSERT INTO yao_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Pakuŵa yaitite mmoŵa ga che Nuhu, ni iyoyo ichichiŵa kwika kwa Mwana jwa Mundu. ");
INSERT INTO yao_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pakuŵa gele moŵa go, chikumba meesi chachikulungwa chikanaŵe, ŵandu ŵalyaga ni kung'wa, ni ŵalombelaga ni kulombwa, mpaka lye lyuŵa lyo che Nuhu paŵajinjile mu safina. ");
INSERT INTO yao_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nganamanyilila mpaka chikumba meesi pachaiche ni kwakumba wose. Ni iyoyo ichichiŵa kwika kwa Mwana jwa Mundu. ");
INSERT INTO yao_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kele katema ko ŵandu ŵaŵili chachiŵa ku ngunda, jumo chachijigalikwa ni jwine kulekwa. ");
INSERT INTO yao_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Achakongwe ŵaŵili chachiŵa aninkusyaga, jumo chachijigalikwa ni jwine kulekwa. ");
INSERT INTO yao_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nipele, nlilolechesye, pakuŵa ngankumanyilila lyuŵa chi litaiche Ambuje wenu. ");
INSERT INTO yao_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nambo nkumbuchile lyeleli, kuti akaimanyi nsyene nyuumba katema chi jwawiyi pataiche, akachesisye, ngakajileche nyuumba jakwe jijonasikwe. ");
INSERT INTO yao_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kwalye ligongo lyo, ŵanyamwe nliŵiche chile, pakuŵa ngankumanyilila katema kachaiche Mwana jwa Mundu.” ");
INSERT INTO yao_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Che Yesu ŵapundile kuŵecheta, “Nipele nduni jwali jwakutumichila jwakukulupilichika ni lunda, jwati ambujegwe chammiche pachanya pa ŵandu ŵao, ŵape chakulya katema kakwe? ");
INSERT INTO yao_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jwana upile jwakutumichila jo pataiche ambujegwe juchansimane aninkutendekanya yeleyo. ");
INSERT INTO yao_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Isyene ngunsalila, chachimmika jwele katumetume jo alindilile chipanje chakwe chose. ");
INSERT INTO yao_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nambo jwakutumichila aŵaga jwangalumbana atiji muntima mwakwe kuti, ‘Ambuje ŵangu akukaŵa kuuja,’ ");
INSERT INTO yao_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ni kutanda kwaputa achikapolo achinjakwe ni kulya ni kung'wa pamo ni ŵakolelwa, ");
INSERT INTO yao_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ambujegwe kapolo jula chachiika lyuŵa lyangakulilolela ni saa jangakujimanya. ");
INSERT INTO yao_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chachinjamuka wamba ni kummika mu mpingo umo ni ŵaulamba. Kweleko chikuŵe ni kulila ni kuchilimya meeno. ");
INSERT INTO yao_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kele katema ko, Umwenye wa kwinani chiulandane ni achiŵali likumi ŵaŵajigele ibatali yao, ŵatyosile kwachingamila ambuje ŵa ulombela. ");
INSERT INTO yao_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nsano ŵao ŵaliji ŵakuloŵela ni nsano ŵaliji ŵakalamuka. ");
INSERT INTO yao_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ŵaŵaliji ŵakuloŵela ŵala ŵajigele ibatali yao, nambo nganajigala mauta ga akiba. ");
INSERT INTO yao_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nambo ŵele ŵaŵaliji ŵakalamuka ŵala ŵajigele mauta mu yupa pamo ni ibatali yao. ");
INSERT INTO yao_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pakuŵa ambuje ŵaulombela ŵakaŵile kwika, achiŵali ŵala wose ŵagwesele ni kugona. ");
INSERT INTO yao_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nambo sikati chilo nnope kwapali kunyokonya, ‘Nnole! Ambuje ŵaulombela akwika, njaule nkaachingamile.’ ");
INSERT INTO yao_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pelepo achiŵali ŵala wose ŵajimwiche, ŵaiŵisile chile ibatali yao. ");
INSERT INTO yao_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ŵele ŵakuloŵela ŵala ŵaasalile ŵakalamuka kuti, ‘Mtupe mauta genu kanandi pakuŵa ibatali yetu ikusimika.’ ");
INSERT INTO yao_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nambo ŵakalamuka ŵala ŵajanjile, ‘Ngagatukwana uwe ni ŵanyamwe! Mmbaya njaule kwa kusumisya nkalisumile mwachinsyene!’ ");
INSERT INTO yao_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nipele, ŵele achiŵali ŵakuloŵela wo paŵajawile kusuma mauta, ambuje ŵaulombela ŵaiche, ni achiŵali ŵaŵaliŵisile chile ŵajinjile pamo nawo mu nyuumba ja ulombela ni nnango waugalikwe. ");
INSERT INTO yao_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kanyuma achiŵali ŵane ŵala ŵaiche, ŵaaŵilasile, ‘Achimwene, achimwene, ntuugulile!’ ");
INSERT INTO yao_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nambo ŵelewo ŵajanjile, ‘Ngunsalila isyene, ngangummanyilila ŵanyamwe.’ ” ");
INSERT INTO yao_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nipele, Che Yesu ŵatite, “Nlilolechesye, pakuŵa ngankumanyilila lyuŵa atamuno saa pachaiche Mwana jwa Mundu. ");
INSERT INTO yao_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Pakuŵa Umwenye wa kwinani uli mpela mundu jwasachile kwaula ulendo, ŵaaŵilasile ŵakutumichila ŵao ni kwalechela chipanje chakwe. ");
INSERT INTO yao_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ŵampele kila jumo ichaikombole, jumo maunjili nsano ga mbiya, ni jwine maunjili gaŵili ni jwine liunjili limo, ni ŵajawile. ");
INSERT INTO yao_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nipele, juŵapochele mbiya maunjili nsano ŵajawile kukusumisya malonda ni ŵapatile mbiya sine maunjili nsano. ");
INSERT INTO yao_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ilaila juŵapochele mbiya maunjili gaŵili jula, ŵapatile sine maunjili gaŵili. ");
INSERT INTO yao_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nambo jwele juŵapochele mbiya liunjili limo jula, ŵajawile, ni kusola lisimbo paasi, ni ŵasisile mbiya ja achimwene jwao. ");
INSERT INTO yao_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagapite moŵa gamajinji, achimwene jwa ŵakutumichila ŵala ŵausile, ni ŵatandite kuŵalanjila mbiya sisyatumiche ni mbiya sisyapatikene mu mbiya syakwe. ");
INSERT INTO yao_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Katumetume juŵapochele mbiya maunjili nsano ŵaiche ali ajigele gane nsano, ŵaasalile, ‘Achimwene, mwambele maunjili nsano ga mbiya, nnole, nyonjechesye maunjili gane nsano.’ ");
INSERT INTO yao_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Achimwene jwao ŵansalile jwelejo kuti, ‘Yambone, jwakutumichila jwambone ni jwakukulupilichika. Ndi jwakukulupilichika kwa indu yainandi pe, chinampe yejinji. Njise kukusengwa pamo ni achimwene jwenu.’ ");
INSERT INTO yao_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Sooni jwakutumichila juŵapochele mbiya maunjili gaŵili ŵaiche, ŵatyosisye mbiya sine maunjili gaŵili gagajonjechekwe, ŵatite, ‘Achimwene, mwambele mbiya maunjili gaŵili. Nnole, mbatile sine maunjili gaŵili gagajonjechekwe.’ ");
INSERT INTO yao_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Achimwene jwao ŵansalile jwelejo kuti, ‘Yambone, jwakutumichila jwambone ni jwakukulupilichika. Ndi jwakukulupilichika kwa indu yainandi pe, chinampe yejinji. Njise kukusengwa pamo ni achimwene jwenu.’ ");
INSERT INTO yao_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nambo juŵapochele mbiya liunjili limo jula ŵaiche, ŵatite, ‘Achimwene, nguimanyilila kuti mwe ndi ŵakulimba, mmweji nkugungula pa nganimpande, ni kusonganganya panganimmisa. ");
INSERT INTO yao_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Najogwepe, najisisile mbiya jenu paasi. Nipele njigale mbiya jenu.’ ");
INSERT INTO yao_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Achimwene jwao ŵanjanjile, ‘Mwe ndi jwakutumichila jwangalumbana ni jwa ulesi! Nkuumanyilila kuti une ngugungula panganimbande, ni kusonganganya panganimisa. ");
INSERT INTO yao_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nipele yammajile kujiŵika mbiya jangu mu nyuumba ja kugosela mbiya, none pachiiche ngajijigele jajili jangu ni chakonjecheka chakwe! ");
INSERT INTO yao_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Munsumule mbiya jo mumpe jwakwete mbiya maunjili likumi. ");
INSERT INTO yao_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pakuŵa, jwali ni chindu chapegwe ni konjechekwa. Nambo jwanganakola chindu, ata chele chakwete cho chichijigalikwe. ");
INSERT INTO yao_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yankati jwakutumichila jwangaikanacho chakonjecheka, mumponye paasa ku chipi! Kweleko chikuŵe ni kulila ni kuchilimya meeno.’ ” ");
INSERT INTO yao_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Katema kachaiche Mwana jwa Mundu mu ukulu wakwe ni achikatumetume ŵa kwinani wose ali pamo nawo, pelepo chachitama pa chitengu chao cha umwenye chachili ni ukulu. ");
INSERT INTO yao_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ŵandu ŵa ilambo yose chasongangane mmbujo mwao, nombe chachalekanganya ŵandu mpela ŵakuchinga yakuti pakusilekanganya ngondolo ni mbusi. ");
INSERT INTO yao_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Chaachisiŵika ngondolo yaani ŵandu ŵambone kundyo kwakwe ni mbusi yaani ŵandu ŵangalumbana kunchiji kwakwe. ");
INSERT INTO yao_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Nombe Mwenye chiŵasalile ŵaali ŵa kundyo kwakwe kuti, ‘Njise ŵanyamwe ŵampegwile upile ni Atati ŵangu, mpochele umwenye ŵampanganyichisye chile chitandile kugumbikwa chilambo. ");
INSERT INTO yao_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pakuŵa jangwete sala ni ŵanyamwe mwambele chakulya ni jangwete njota ni ŵanyamwe mwambele meesi ni naliji jwannendo ni ŵanyamwe mwambochele mmajumba genu. ");
INSERT INTO yao_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Naliji matakope, ŵanyamwe mwandakwisye ni naliji jwakulwala ŵanyamwe mwaaiche kukuunola ni naliji jwantawe ŵanyamwe mwanyimajimile.’ ");
INSERT INTO yao_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pelepo, ŵandu ŵakupanganya yaili yambone paujo pa Akunnungu chiŵajanje mwenye kuti, ‘Ambuje, ana chakachi twambweni ŵa sala ni kumpa chakulya, pane jinkwete njota ni kung'wesya meesi? ");
INSERT INTO yao_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ana chakachi twammweni nli jwannendo ni kumpochela, pane matakope ni kuntakusya? ");
INSERT INTO yao_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Chakachi twammweni ndi nkulwala pane jwantawe ni kwika kukunnola?’ ");
INSERT INTO yao_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mwenye chiŵajanje, ‘Ngunsalila isyene, chachilichose chimwantendele jumo jwa ŵanyaŵa achalongo ŵangu achanandi, mwandendele une.’ ");
INSERT INTO yao_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nipele chiŵasalile ŵele ŵaali kunchiji kwao, ‘Ntyoche mmbujo mwangu ŵanyamwe ŵankwete malweso! Njaule ku mooto moŵa gose pangali mbesi wangasimika, wauŵichikwe chile kwa ligongo lya Shetani ni achikatumetume ŵakwe. ");
INSERT INTO yao_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pakuŵa jangwete sala nganimumba chakulya, jangwete njota nganimumba meesi. ");
INSERT INTO yao_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Naliji jwannendo nganimumbochela mmajumba genu ni panaliji matakope nganimumba nguo ni nalwalaga ni nataŵikwe nganinnyika kukulola.’ ");
INSERT INTO yao_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Pelepo nombe chajanje, ‘Ambuje, ana chakachi twammweni ndi jinkwete sala ni njota, ni ndi jwannendo pane matakope, ni ndi nkulwala pane jwantaŵikwe, nowe nganitunkamusya?’ ");
INSERT INTO yao_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mwenye chajanje, ‘Ngunsalila isyene, kila pamwakanaga kumpanganichisya gelega jumo jwa ŵanyaŵa achanandi ŵa, mwakanile kuumbanganichisya une.’ ");
INSERT INTO yao_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nipele, ŵanyaŵa chajaule kumasausyo moŵa gose pangali mbesi, nambo ŵandu ŵakupanganya yaili yambone paujo pa Akunnungu chajaule ku umi wa moŵa gose pangali mbesi.” ");
INSERT INTO yao_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Che Yesu paŵamalisisye kuŵecheta gelego gose, ŵaasalile ŵakulijiganya ŵao, ");
INSERT INTO yao_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nkumanyilila kuti pachigamale moŵa gaŵili chichiŵe chindimba cha Pasaka, ni Mwana jwa Mundu chakatyosyekwe kuti aŵambikwe pa nsalaba.” ");
INSERT INTO yao_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Katema ko achakulu ŵa mbopesi ni achakulu ŵa ŵandu ŵasimene pa nsana wa nyuumba ja Jwankulu Jwambopesi jwaŵilanjikwe che Kayafa. ");
INSERT INTO yao_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ŵajilene ichajile pa kwakamula Che Yesu kwa malindi ni kwaulaga. ");
INSERT INTO yao_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nambo ŵatite chele chindu chinatyochele katema ka lyuŵa lya chindimba cha Pasaka, ngakaŵa chikutyochele kutindiganya pa ŵandu. ");
INSERT INTO yao_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Che Yesu paŵaliji ku Besania, ku nyuumba ji che Simoni, juŵalamile matana. ");
INSERT INTO yao_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jwankongwe jumo juŵaliji ni chuupa chachikolochekwe ni liganga lya alabasta chachili ni mauta ga kununjila nnope ni ga ndalama jajikulungwa, ŵaichilile Che Yesu paŵatemi kulya chakulya, ŵajitile mauta muntwe. ");
INSERT INTO yao_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ŵakulijiganya ŵao paŵaiweni yele ŵatumbile, ŵatite, “Awu uwonasi u wa chichi? ");
INSERT INTO yao_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aga mauta ga ngati gakasumichikwe kwa mbiya jekulungwa, ni kupegwa ŵakulaga.” ");
INSERT INTO yao_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Che Yesu ŵasimanyilile ng'anisyo syao, ŵaasalile, “Ligongo chi nkunsausya jwankongwe jo? Jwele atesile yambone kukwangu.” ");
INSERT INTO yao_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ŵakulaga alinji moŵa gose ni ŵanyamwe, nambo une nguuŵa ni ŵanyamwe moŵa gose. ");
INSERT INTO yao_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aju jwankongwe ju anyitilile pa chiilu mauta ga kununjila kuti amiche chile kwa masiko gangu. ");
INSERT INTO yao_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ngunsalila isyene, papali pose pa chilambo pano patachilalichila Ngani Jambone ji, achi chatesile jwankongwe ju chichisalichikwe kwa kunkumbuchila. ");
INSERT INTO yao_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nipele, che Yuda Isikaliote, jumo jwa likumi ni ŵaŵili ŵala, ŵajawile kwa achakulu ŵa mbopesi, ");
INSERT INTO yao_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ŵausisye, “Ana chimuumbe ichichi nannyichisyaga Che Yesu kukwenu?” Ŵaŵalanjile ipande selasini ya feza. ");
INSERT INTO yao_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chitandile kele katema ko che Yuda ŵasosaga lipesa lya kwaichisya kukwao. ");
INSERT INTO yao_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lyuŵa limo likanaŵe lyuŵa lya chindimba cha mikate jangatagwa amila, ŵakulijiganya ŵajaulile Che Yesu ni kwausya, “Ana kwapi nkusaka tukankolochesye chakulya cha Pasaka?” ");
INSERT INTO yao_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ŵajanjile, “Njaule mmusi kwa mundu jumpepe, nkansalile, ‘Jwakwiganya akuti, katema kangu kaiche, chindye chakulya cha Pasaka kumangwenu pamo ni ŵakulijiganya ŵangu.’ ” ");
INSERT INTO yao_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ŵakulijiganya ŵala ŵatesile mpela iŵatite pakusalilwa ni Che Yesu, ŵakolosisye chakulya cha Pasaka. ");
INSERT INTO yao_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ligulo, Che Yesu ŵatemi pakulila chakulya pamo ni ŵakulijiganya ŵao kumi na mbili. ");
INSERT INTO yao_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Paŵalyaga, Che Yesu ŵatite, “Ngunsalila isyene, jumo jwenu chakang'alauche.” ");
INSERT INTO yao_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ŵakulijiganya ŵasupwiche nnope, ŵatandite kuusya jumo jumo, “Ambuje! Uli, ndili une?” ");
INSERT INTO yao_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Che Yesu ŵajanjile, “Juchakatoŵele nkate mumbale pampepe ni une jujojo ni juchakang'alauche. ");
INSERT INTO yao_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Elo, Mwana jwa Mundu chawe mpela Malembelo ga Akunnungu igakuti pakusala, nambo ulaje kwa jwelejo juchakangalauche Mwana jwa Mundu! Ikaliji mmbaya ngakapagwe jwele mundu jo.” ");
INSERT INTO yao_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Che Yuda, juŵangalawiche, ŵausisye, “Jwakwiganya! Ndili une?” Che Yesu ŵajanjile, “Ugwe mmechete.” ");
INSERT INTO yao_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Paŵalyaga, Che Yesu ŵaujigele nkate, ŵatogolele Akunnungu, ŵaugaŵenye, ŵapele ŵakulijiganya ŵao achitiji, “Njigale ndye, achi ni chiilu changu.” ");
INSERT INTO yao_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nipele ŵachijigele chikombe cha divai, ŵatogolele, ŵapele achitiji, “Nng'welele achi ŵanawose, ");
INSERT INTO yao_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","pakuŵa aji ni miasi jangu ja lilangano jajikwitika kwa ligongo lya ŵajinji kwa kwalechelesya sambi. ");
INSERT INTO yao_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nambo ngunsalila kuti nguung'wa sooni divai ja sabibu mpaka paching'we jasambano pamo ni ŵanyamwe mu umwenye wa Atati ŵangu.” ");
INSERT INTO yao_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Paŵamasile kwimba lujimbo lwa kulapa, ŵatyosile, ŵajawile kuchikwesya cha Miseituni. ");
INSERT INTO yao_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nipele Che Yesu ŵaasalile sooni, “Chilo cha lelo jino, ŵanyamwe ŵanawose chinchimwe ni une, pakuŵa Malembelo ga Akunnungu gakuti, ‘Chinampute jwakuchinga ni mpingo wa ngondolo chipwilingane.’ ");
INSERT INTO yao_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nambo pachimale kusyuka, chinannongolele ku Galilaya.” ");
INSERT INTO yao_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Che Petulo ŵaasalile Che Yesu, “Nachiŵamuno ŵanawose chachimwe ni mmwe ni kunneka, nambo une ngali pachinanneche.” ");
INSERT INTO yao_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Che Yesu ŵansalile che Petulo, “Ngunsalila isyene, chilo chino jikanaŵe kutongola tambala, chimungane katatu.” ");
INSERT INTO yao_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Che Petulo ŵatite, “Iŵaga chingawe pamo nomwe, ngasinankana.” Ŵakulijiganya ŵane ŵala ŵanawose ŵatite iyoyo. ");
INSERT INTO yao_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nipele Che Yesu ŵajawile pamo nawo kwiuto kwakukuŵilanjikwa ku Getesemane, ŵaasalile ŵakulijiganya ŵao kuti, “Ntame apano une ngwaula ako kukupopela.” ");
INSERT INTO yao_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ŵalongene nawo che Petulo pamo ni ŵanache ŵaŵili ŵa chilume ŵa che Sebedayo, ŵatandite kusupuka nnope ni kulagasika. ");
INSERT INTO yao_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pelepo ŵaasalile, “Ngusupuka nnope muntima mpaka chiŵandi kuwa. Ntame apano ni nchesye pamo ni une.” ");
INSERT INTO yao_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nipele, ŵajawile mmbujo kanandi, ŵagwile manguku, ŵapopele achitiji, “Atati ŵangu, iŵaga ikukomboleka, achi chikombe cha malagasyo chimbite, nambo ngaŵa kwa kusaka une, nambo iŵe mpela inkuti pakusaka mmwe.” ");
INSERT INTO yao_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ŵajaulile ŵakulijiganya ŵala, ŵasimene agonile, ŵaasalile che Petulo, “Ana uli, nganinkombola kuchesya pamo ni une atamuno saa jimope? ");
INSERT INTO yao_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nchesye ni kupopela kuti nkaika kwinjila nkulinjikwa. Mbumu jikusaka nambo chiilu changali machili.” ");
INSERT INTO yao_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Che Yesu ŵajawile sooni kaaŵili kukupopela, “Atati ŵangu, iŵaga ngaikomboleka achi chikombe cha malagasyo chipite pangang'welela une, nipele, chinkusaka chitendekwe.” ");
INSERT INTO yao_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ŵajaulile sooni ŵakulijiganya ŵao, ŵasimene agonile, pakuŵa meeso gao gatopelwe ni lugono. ");
INSERT INTO yao_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nipele ŵalesile, ŵajawile sooni kukupopela kaatatu kwa maloŵe galagala. ");
INSERT INTO yao_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nipele ŵajaulile ŵakulijiganya ŵala, ŵaasalile, “Ana uli, chiŵela nli mu lugono ni kupumulila? Nnole katema kasyene kaiche, ni Mwana jwa Mundu chatajikwe mmakono mwa ŵandu ŵa sambi. ");
INSERT INTO yao_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Njime, twende. Nnole! Akwika jwakuung'alauka.” ");
INSERT INTO yao_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nipele, Che Yesu paŵaliji nkuŵecheta nawo, ŵaiche che Yuda, jumo jwa ŵakulijiganya kumi na mbili ŵala. Pamo nawo ŵaiche ŵandu ŵajinji ali ajigele mapanga ni imbonga ŵaŵatumikwe ni achakulu ŵambopesi ni achakulu ŵa ŵandu. ");
INSERT INTO yao_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Juŵasachile kungalauka Che Yesu jo, ŵapele chimanyisyo kuti, “Juchinankomasye kwa kwakunnonyela ni jujojo, munkamule.” ");
INSERT INTO yao_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Che Yuda ŵammandichile Che Yesu, ŵaasalile, “Ngunkomasya jwakwiganya!” Nipele ŵankomasisye kwa kwakumbata. ");
INSERT INTO yao_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Che Yesu ŵansalile, “Ambusanga, ntende chinnyichile.” Pelepo ŵaiche ŵandu ŵala, ŵankamwile Che Yesu ni kwaŵika paasi pa ulamusi wao. ");
INSERT INTO yao_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jumo jwa ŵaŵaliji pamo ni Che Yesu ŵalisolomwele lipanga lyakwe, ŵamputile kapolo jwa Jwankulu Jwambopesi, ŵankatile liwiwi. ");
INSERT INTO yao_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pelepo Che Yesu ŵansalile jwejo, “Mmusye upanga wenu mwigonelo mwakwe, pakuŵa jwalijose jwakuulaga ni lipanga, chaulajikwe ni lipanga. ");
INSERT INTO yao_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Uli ana ngankwimanyilila kuti ngukombola kwaŵenda Atati ŵangu ni kuumbelechela kupunda ŵangondo mipingo kumi na mbili ŵa achikatumetume ŵa kwinani? ");
INSERT INTO yao_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nambo chigamalile chinauli Malembelo ga Akunnungu gagakuti ikuŵajilwa kuwa?” ");
INSERT INTO yao_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Katema kakoko Che Yesu ŵausalile mpingo wa ŵandu uŵaiche kukwakamula, “Uli nnyiche kukungamula kwa mapanga ni imbonga mpela ndili mundu jwangangugakamulichisya malajisyo? Moŵa gose naliji pa Nyuumba ja Akunnungu njijiganyaga, nambo nganimungamula! ");
INSERT INTO yao_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nambo aga gose ga gatendekwe pakuti gamalile malembelo ga ŵakulondola ŵa Akunnungu.” Pelepo ŵakulijiganya ŵanawose ŵalesile, ŵatisile. ");
INSERT INTO yao_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nipele, ŵele ŵandu ŵaŵankamwile Che Yesu ŵanjawisye ku nyuumba ji che Kayafa juŵaliji Jwankulu Jwambopesi, kuŵasongangene ŵakwiganya Malajisyo ni achachekulu. ");
INSERT INTO yao_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Che Petulo ŵankuiye kwa kutali mpaka mu lutenje lwa Jwambopesi Jwankulu, ŵajinjile nkati pamo ni ŵakulindilila kuti alole ichikatendekwe. ");
INSERT INTO yao_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nipele, achakulu ŵambopesi ni nkungulu wose ŵausosile umboni wa unami kuti akombole kumbulaga Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nambo nganapata umboni wauli wose, nachiŵamuno ŵaiche ŵandu ŵajinji ŵa unami. Kumbesi kwakwe ŵaiche ŵandu ŵaŵili. ");
INSERT INTO yao_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ŵatite, “Aju mundu ju ŵatite, ‘Ngukombola kujigumula Nyuumba ja Akunnungu ni kujitaŵa sooni kwa moŵa gatatu.’ ” ");
INSERT INTO yao_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jwambopesi Jwankulu ŵajimi, ŵammusisye Che Yesu, “Ana ngankwanga liloŵe? Ana ŵandu ŵa akummechetela chichi?” ");
INSERT INTO yao_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nambo Che Yesu ŵatemi ji. Jwambopesi Jwankulu ŵansalile, “Ngunnumbisya kwa Akunnungu ŵaali ŵajumi, ntusalile naga isyene mmwe ni Kilisito, Mwana jwa Akunnungu!” ");
INSERT INTO yao_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Che Yesu ŵanjanjile, “Mmwe mmechete! Nambo ngunsalila kuti, chitandile sambano chimumbone Mwana jwa Mundu ali atemi kundyo kwa Ambuje ŵa machili, chimumbone iyoyo achiikaga pa maunde ga kwinani.” ");
INSERT INTO yao_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pelepo, Jwambopesi Jwankulu ŵapapulenye nguo syao, ŵatite, “Ŵatukene Akunnungu! Uli tukuusaka sooni umboni nkati jweleju? Sambano mpilikene yatite pakwatukana Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ŵanyamwe nkuti uli?” Ŵanyawo ŵanjanjile, “Aŵajilwe kuwa!” ");
INSERT INTO yao_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nipele ŵansunile mata ku meeso, ŵamputile. Ŵane ŵamputile majanda palijeje, ");
INSERT INTO yao_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","achitiji, “Nlondole, alakwe Kilisito Jwakuwombola, ŵaani ŵamputile!” ");
INSERT INTO yao_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Che Petulo ŵatemi paasa mu lutenje. Nipele, jwakutumichila jumo jwankongwe ŵanjaulile, nikuti, “Alakwe mwaliji pampepe ni Che Yesu jwa ku Galilaya.” ");
INSERT INTO yao_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nambo che Petulo ŵakanile mmbujo mwa ŵanawose achitiji, “Ngangumanyilila inkuŵecheta yo.” ");
INSERT INTO yao_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Paŵakopokaga paasa, katumetume jwine jwankongwe ŵammweni, ŵaasalile uŵaliji pelepo kuti, “Mundu ju ŵaliji pamo ni Che Yesu jwa ku Nasaleti.” ");
INSERT INTO yao_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Che Petulo ŵakanile sooni kwa kulumbilila, “Ngangummanyilila mundu ju.” ");
INSERT INTO yao_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kanyuma kanandi, ŵandu ŵaŵaliji pelepo ŵajaulile che Petulo, ŵansalile, “Kusyene, mmwe nomwe nli jumo jwakwe, pakuŵa uŵechete wenu ukummanyisya.” ");
INSERT INTO yao_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pelepo che Petulo ŵatandite kulumbilila kwakulilwesya achitiji, “Ngangummanyilila mundu ju!” Katema kakoko tambala jatongwele. ");
INSERT INTO yao_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Che Petulo ŵagakumbuchile maloŵe gaŵasalilwe ni Che Yesu kuti, “Chimungane katatu, jikanaŵe kutongola tambala.” Nipele, ŵatyosile paasa, ŵalisile nnope. ");
INSERT INTO yao_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pakwachele, achakulu ŵambopesi ni achakulu ŵa ŵandu ŵajilene ichajile pakwaulaga Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ŵataŵile magwedegwede, ŵanjigele, ŵampeleche ku che Pilato, jwankulu jwa Chiloma. ");
INSERT INTO yao_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pelepo, che Yuda juŵangalawiche, paŵaiweni kuti Che Yesu amasile kulamulikwa, ŵalilasiche muntima, ŵausisye kwa achakulu ŵambopesi ni achakulu ŵa ŵandu ipande selasini ya feza. ");
INSERT INTO yao_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ŵaasalile, “Leŵile kwa kuntyosya mundu jwangali ni sambi aulajikwe.” Nambo ŵele ŵanyawo ŵatite, “Yeleyo ili yetuwe? Chimmanyilile mwasyene.” ");
INSERT INTO yao_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nombejo ŵaponyele feza sila pa Nyuumba ja Akunnungu, ŵakopweche paasa, ŵajawile kukulitaŵilila. ");
INSERT INTO yao_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Achakulu ŵambopesi ŵasijigele feza sila, nikuti, “Ngalumbana kusiŵika kwa jwakugosa feza sya Nyuumba ja Akunnungu pakuŵa sili feza sisyapatikene kwa kuulaga.” ");
INSERT INTO yao_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nipele, ŵajilene, ŵasumile ngunda wa lilongo kuti paŵe pakwasichila achalendo. ");
INSERT INTO yao_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nipele, mpaka lelo jino wele ngunda wo ukuŵilanjikwa ngunda uwasumikwe kwa feza sisyapatikene kwa kuulaga. ");
INSERT INTO yao_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kwa yeleyo maloŵe gaŵaŵechete che Yelemia jwakulondola jwa Akunnungu gamalile gagakuti, “Ŵajigele ipande selasini ya feza, malinga ni malipilo gaŵajilene Ŵaisilaeli kulipa kwa ligongo lyao. ");
INSERT INTO yao_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Feza syo ŵasumile ngunda wa lilongo, mpela iŵanajisye Ambuje.” ");
INSERT INTO yao_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Che Yesu ŵajimi mmbujo mwa jwankulu jwa chilambo. Nipele, jwankulu jwa Chiloma ŵammusisye, “Ana mmwe ni Mwenye jwa Ŵayahudi?” Che Yesu ŵanjanjile, “Mmwe mmechete.” ");
INSERT INTO yao_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nambo achakulu ŵambopesi ni achachekulu paŵammechetelaga, nganajanga. ");
INSERT INTO yao_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nipele che Pilato ŵammusisye, “Ana ngankupilikana ganagose gele gakummechetela go?” ");
INSERT INTO yao_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nambo Che Yesu nganajanga namose liloŵe limo, jwankulu jwa Chiloma jo ŵasimosile nnope. ");
INSERT INTO yao_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yasyoŵeleche jwankulu jwa Chiloma kwagopolela Myahudi jumo jwataŵikwe juŵansachile katema ka chindimba cha Pasaka. ");
INSERT INTO yao_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kele katema ko paliji ni jwantawe juŵamanyiche nnope, liina lyakwe che Balaba. ");
INSERT INTO yao_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nipele, paŵasongangene ŵandu pamo, che Pilato ŵausisye, “Ana nkusaka nangopole jwapi mwa ŵele ŵaŵili, che Balaba pane Che Yesu jwakuŵilanjikwa Kilisito?” ");
INSERT INTO yao_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pakuŵa ŵaimanyilile kuti ŵantyosisye kwa ligongo lya wiu. ");
INSERT INTO yao_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Che Pilato paŵatemi pa chitengu cha kulamulila, ŵankwawo ŵaichenawo utenga wanti, “Nkalipasyapasya kutenda chachili chose nkati jwele mundu jwambone jo, pakuŵa lelo lasile mu sagamisi kwa ligongo lyakwe.” ");
INSERT INTO yao_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nambo achakulu ŵambopesi ni achakulu ŵane ŵanyenjile ŵandu kuti ŵaŵende agopolwe che Balaba ni ŵaulaje Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Che Pilato ŵausisye ŵanyawo, “Nkunsaka jwapi nangopolele mwa ŵele ŵaŵili ŵa?” Ŵajanjile, “Che Balaba!” ");
INSERT INTO yao_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Che Pilato ŵausisye ŵanyawo, “Sano, naatende chichi Che Yesu jwakuŵilanjikwa Kilisito?” Ŵanawose ŵatite, “Mwaŵambe pa nsalaba!” ");
INSERT INTO yao_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nambo che Pilato ŵausisye, “Ligongochi? Ungalumbana chi watesile?” Ŵanyawo ŵanyanyisye achitiji, “Mwaŵambe pa nsalaba!” ");
INSERT INTO yao_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nipele, che Pilato paŵaiweni kuti ngakukombola kupanganya chachili chose nambo kutindiganya kukutanda, ŵajigele meesi ni kunaŵa makono mmbujo pa ŵandu ni ŵatite, “Une ngangulipasyapasya nkati chiwa cha aju mundu ju, chinyimanyilile mwachinsyene.” ");
INSERT INTO yao_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ŵandu ŵanawose ŵatite, “Miasi jao jiŵe pachanya petu ni achiŵana ŵetu!” ");
INSERT INTO yao_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nipele che Pilato ŵagopolele che Balaba kutyochela mu nyuumba jakutaŵilwa, nambo paŵamasile kumputa Che Yesu ibokola ŵantyosisye kukwaŵamba pa nsalaba. ");
INSERT INTO yao_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nipele ŵangondo ŵa jwankulu jwa Chiloma ŵanjinjisye Che Yesu nkati likome, wansyungwile mpingo wose. ");
INSERT INTO yao_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ŵammusile nguo syao, ŵammwasisye mwinjilo wechejeu wa chimwenye. ");
INSERT INTO yao_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nipele ŵakolosiye chindu mpela singwa ja miiŵa, ŵammwasisye mu ntwe, sooni ŵammichile nnasi kundyo. Ŵatindiŵele mmbujo mwao ni kuntendela chanache achitiji, “Tukunkomasya Mwenye jwa Ŵayahudi!” ");
INSERT INTO yao_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ŵansunile mata, ŵaujigele nnasi ula ni kumputa mu ntwe. ");
INSERT INTO yao_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Paŵamasile kuntendela chanache, ŵammusile mwinjilo ula ni kuntakusya nguo syao, nipele ŵampeleche kukwaŵamba pa nsalaba. ");
INSERT INTO yao_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Paŵajaulaga, ŵansimene mundu jumo liina lyakwe che Simoni jwa musi wa ku Kulene, ŵankanganichisye kujigala nsalaba u Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Paŵaiche peuto papakuŵilanjikwa Goligota, malumbo gakwe, peuto pa Chikalakasa cha Ntwe, ");
INSERT INTO yao_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ŵampele divai jewanganye chindu chakuŵaŵa kutyosya kupeteka. Nambo Che Yesu nkupasya pe ŵakanile kung'wa. ");
INSERT INTO yao_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ŵaŵambile pa nsalaba, nipele ŵagaŵene nguo syao kwakutendela gudugudu. ");
INSERT INTO yao_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ŵatemi pepala, ŵaliji nkwalindilila. ");
INSERT INTO yao_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pachanya ntwe wakwe pa nsalaba ŵaŵisile chibao cha maloŵe gagalembekwe, “Aŵa ni Che Yesu, Mwenye jwa Ŵayahudi.” ");
INSERT INTO yao_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Paliji ni ŵachiswamba ŵaŵili ŵaŵambikwe pamo nawo, jumo kunchiji ni jwine kundyo. ");
INSERT INTO yao_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ŵandu ŵaŵapitaga pelepo ŵantukene achipukunyaga mitwe jao nikuti, ");
INSERT INTO yao_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Mmwe jumwatite kuti nkukombola kujigumula Nyuumba ja Akunnungu ni kujitaŵa kwa moŵa gatatu. Sambano nlikulupusye mwasyene. Iŵaga mmwe ndi Mwana jwa Akunnungu, ntuluche pa nsalaba po!” ");
INSERT INTO yao_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iyoyo peyo achakulu ŵambopesi pamo ni ŵakwiganya malajisyo ni achachekulu ŵantendele chanache achitiji, ");
INSERT INTO yao_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ŵakulupwisye ŵane, nambo asyene ngakukombola kulikulupusya! Iŵaga ŵele ali Mwenye jwa Ŵaisilaeli! Sambano atuluche pa nsalaba po, noweji tutwakulupile. ");
INSERT INTO yao_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ŵaakulupilile Akunnungu ni kuŵecheta kuti ŵele ali Mwana jwa Akunnungu, nipele, iŵaga Akunnungu akunsaka ŵakulupusye sambano.” ");
INSERT INTO yao_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iyoyo peyo ŵeŵala uŵaŵambikwe pamo nawo pa nsalaba nombe ŵantukene. ");
INSERT INTO yao_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chitandile lyuŵa pantwe mpaka saa tisa, chilambo chose chaliji chipi. ");
INSERT INTO yao_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pajaiche saa tisa Che Yesu ŵalisile kwa liloŵe lyekulungwa, “Eloi, Eloi, lama sabakitani?” Malumbo gakwe, “Akunnungu ŵangu, Akunnungu ŵangu, kwachichi mulesile?” ");
INSERT INTO yao_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nambo ŵandu ŵane ŵaŵajimi pele paŵapilikene yele ŵatite, “Akwaŵilanga che Elia.” ");
INSERT INTO yao_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jumo jwao ŵautwiche, ŵajigele lidodoki ni kunyoya mu divai jakuipa, ŵajiŵisile mu nnasi, ŵapele ang'we. ");
INSERT INTO yao_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ŵane ŵatite, “Nnindilile tulole iŵaga che Elia chaiche kukwakulupusya.” ");
INSERT INTO yao_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nipele, Che Yesu ŵalisile sooni kwa liloŵe lyekulungwa, ŵajasiche. ");
INSERT INTO yao_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pelepo nguo ja lusasa ja Nyuumba ja Akunnungu japapwiche pambindikati, kutyochela mwinani mpaka paasi, chilambo chatinganyiche ni lwala syapalwiche. ");
INSERT INTO yao_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Malembe gaunukwiche ni iilu ya ŵandu ŵajinji ŵa Akunnungu ŵaŵajasiche ŵasyuchikwe. ");
INSERT INTO yao_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nombewo ŵakopweche mmalembe, ni Che Yesu paŵamasile kusyuka, ŵajinjile mu mmusi wa Akunnungu, yaani Yelusalemu, ni ŵandu ŵajinji ŵaweni. ");
INSERT INTO yao_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nipele, jwankulu jwa ŵangondo ni ŵangondo ŵane ŵaŵaliji pamo nawo achinlindililaga Che Yesu paŵachiweni chilambo chininkutinganyika ni gagakopochele gala, ŵajogwepe nnope, ŵatite, “Isyene aju mundu ju ŵaliji Mwana jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pelepo paliji ni achakongwe ŵajinji ŵaŵalolechesyaga kwakutali. Ŵanyawo ni ŵeŵala ŵaŵankuiye Che Yesu kutyochela ku Galilaya ni kwatumichila. ");
INSERT INTO yao_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mwa ŵele ŵanyawo ŵaliji che Maliamu jwa musi wa ku Magidala ni che Maliamu achikulugwe che Yakobo ni che Yusufu, pamo ni achikulu ŵa ŵanache ŵa che Sebedayo. ");
INSERT INTO yao_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pakwaswele, ŵaiche mundu jumo jwa chipanje jwa musi wa ku Alimataya liina lyao che Yusufu, nombejo jwaliji jwakulijiganya jwa Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ŵajawile kwa che Pilato, ŵaŵendile apegwe chiilu chi Che Yesu. Che Pilato ŵalamwile kuti apegwe. ");
INSERT INTO yao_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Che Yusufu ŵachijigele chiilu chila, ŵachiŵijilile nguo jeswela mbee jajili jasambano, ");
INSERT INTO yao_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Che Yusufu ŵachiŵisile chiilu chi Che Yesu mu lilembe lyasambano liŵasepile palwala kwa ligongo lyakwe nsyene. Nipele, ŵaligalambulile liganga lyekulungwa pa nnango wa lilembe ni kutyoka. ");
INSERT INTO yao_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Che Maliamu jwa musi wa ku Magidala ni che Maliamu ŵane ŵala ŵatemi aninkulolechesya ku lilembe. ");
INSERT INTO yao_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Malaŵi jakwe, yaani lyuŵa lyakuliŵika chile kwa ligongo lya Lyuŵa lya Kupumulila, achakulu ŵambopesi ni Mafalisayo ŵajaulile che Pilato, ");
INSERT INTO yao_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ŵatite, “Achimwene, tukukumbuchila kuti jwakulambusya jula akanaŵe kuwa ŵatite, ‘Pakumala moŵa gatatu chisyuche.’ ");
INSERT INTO yao_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwayele tukummenda mwasalile ŵangondo ajaule akalilindilile lilembe kwa moŵa gatatu, kuti ŵakulijiganya ŵao anakombole kuchijigala chiilu chao ni kwasalila ŵandu kuti asyuchile. Akuno kulambusya kwa mbesi kuno chikuŵe kwawamba nnope kupunda kwaandanda kula.” ");
INSERT INTO yao_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Che Pilato ŵaasalile, “Ayaga, nkwete ŵangondo, njaule nkalilindilile inkuti pakukombola.” ");
INSERT INTO yao_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nipele, ŵajawile, ŵalilindilile lilembe, ŵaŵisile chiugulilo peganga ni kwaleka ŵangondo kulindilila. ");
INSERT INTO yao_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Palyamasile Lyuŵa lya Kupumulila, kuninkucha lyuŵa lyaandanda lya chijuma, che Maliamu jwa musi wa ku Magidala ni che Maliamu jwine ŵajawile kukulilola lilembe. ");
INSERT INTO yao_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chisisimuchile chakopochele chindendemesi chachikulungwa cha chilambo, katumetume jwa kwinani jwa Ambuje ŵatulwiche kutyochela kwinani, ŵaligalambwile liganga lila ni kutamila. ");
INSERT INTO yao_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Uwoneche wakwe waliji mpela kumesya ni nguo syakwe syaliji syeswela mbee. ");
INSERT INTO yao_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ŵakulindilila lilembe lila ŵatetemele kwa lipamba nnope, ŵaliji mpela ŵawe. ");
INSERT INTO yao_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nambo katumetume jwa kwinani jula ŵaasalile achakongwe ŵala achitiji, “Ŵanyamwe nkajogopa! Ngumanyilila kuti nkunsosa Che Yesu juŵaŵambikwe pa nsalaba. ");
INSERT INTO yao_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nganapagwa pelepa pakuŵa ŵamale kusyuka mpela iŵasasile. Njise kunnole paŵagonile. ");
INSERT INTO yao_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nipele, njaule chitema nkaasalile ŵakulijiganya ŵao kuti asyuchile, nombewo akunnongolela ku Galilaya, kweleko chimwasimane. Ayaga, une jwammale kunsalila.” ");
INSERT INTO yao_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Achiŵaga ni lipamba ni kusengwa kwakukulungwa, achakongwe wo ŵatyosile chitema ku lilembe, achiutukaga kukwasalila ŵakulijiganya ŵao. ");
INSERT INTO yao_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Chisisimuchile, Che Yesu ŵasimene nawo, ŵatite “Ngunkomasya.” Achakongwe ŵala ŵajawile, ŵagakamwile makongolo gao ni kwapopelela. ");
INSERT INTO yao_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nipele Che Yesu ŵaasalile, “Nkajogopa! Njaule nkaasalile achalongo ŵangu ajaule ku Galilaya, kweleko ni kuchakamone une.” ");
INSERT INTO yao_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Achakongwe ŵala pawajaulaga, ŵakulindilila ŵampepe ŵa lilembe ŵajawile mu mmusi kukwasalila achakulu ŵambopesi yanayose iyatendekwe. ");
INSERT INTO yao_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nipele, ŵasimene pamo ni achachekulu, ŵatemi nkungulu, pakumala kukunguluka ŵapele ŵakulindilila ŵala mbiya syasijinji, ");
INSERT INTO yao_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ni kwasalila, “Ŵanyamwe chinjile yeleyi, ‘Ŵakulijiganya ŵao ŵaiche chilo, ŵachijiŵile chiilu uwe tuli tugonile.’ ");
INSERT INTO yao_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Iŵaga chaimanye yeleyi jwankulu jwa chilambo, uwe chitwanyenje, ni ŵanyamwe ngamma ni masausyo.” ");
INSERT INTO yao_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ŵakulindilila ŵala ŵasijigele mbiya sila, ŵatesile mpela iŵatite pakusalilwa. Jele ngani jo jajenele pasikati ja Ŵayahudi mpaka lelo jino. ");
INSERT INTO yao_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ŵakulijiganya kumi na moja ŵala ŵajawile ku Galilaya ku chitumbi kwaŵasalilwe ni Che Yesu ajaule. ");
INSERT INTO yao_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Paŵamweni, ŵampopelele, nambo ŵampepe mwa ŵanyawo ŵaliji ni lipamba. ");
INSERT INTO yao_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nipele Che Yesu ŵaiche chiŵandi, ŵaasalile, “Mbegwile ukombole wose kwinani ni pachilambo. ");
INSERT INTO yao_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nipele njaule, nkaatende ŵandu ŵa ilambo yose aŵe ŵakulijiganya ŵangu, nchabatisyaga kwa liina lya Atati ni lya Mwana ni lya Mbumu jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nkaajiganye kugakamulichisya gose mpela ila indite pakunnajisya ŵanyamwe. None ndili pamo ni ŵanyamwe moŵa gose, elo, mpaka kumbesi kwa chilambo.”");
INSERT INTO yao_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jeleji jili ndande ja Ngani Jambone ji Che Yesu Kilisito, Mwana jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mpela ijitite pakulembekwa mmalembo ga che Isaya juŵaliji jwakulondola jwa Akunnungu, “Akunnungu ŵatite, ‘Nguntuma jwantenga jwangu annongolele, jwejejo ni juchankolochesye litala lyenu.’ ");
INSERT INTO yao_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mundu akunyanyisya mwipululu achitiji, ‘Mwakolochesye Ambuje litala lyao, ngolosye mwakusaka kupita.’ ” ");
INSERT INTO yao_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Che Yohana Ŵakubatisya ŵatamaga mwipululu ni kwalalichila ŵandu aleche sambi ni kwabatisya kuti Akunnungu ŵalechelesye sambi syao. ");
INSERT INTO yao_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ŵandu achajinji kutyochela chilambo cha Ŵayahudi ni musi wa ku Yelusalemu wose ŵajawile kukwapikanila che Yohana, ŵajitichisye sambi syao nombejo ŵabatisye mu lusulo lwa Yolodani. ");
INSERT INTO yao_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Che Yohana ŵaliji awasile mwinjilo uwapotekwe ni manyunya ga chinyama chachikuŵilanjikwa ngamia ni nkaanda wa lipende nchiunu. Nombejo ŵalyaga itete ni uchi. ");
INSERT INTO yao_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ni ŵalalichilaga kwa ŵandu kuti, “Panyuma pangu akwika jwali ni machili kumbunda une. None nganguŵajilwa namose kukotama ni kugopola ngoji sya italawanda yakwe. ");
INSERT INTO yao_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Uneji ngumbatisya ni meesi, nambo jwelejo chaachimbatisya kwa Mbumu jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Moŵa go, Che Yesu ŵaiche kutyochela musi wa ku Nasaleti wauli mu chilambo cha ku Galilaya ni ŵabatiswe ni che Yohana mu lusulo lwa Yolodani. ");
INSERT INTO yao_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Che Yesu paŵakopokaga mmeesi, ŵakuweni kwinani kuugwiche ni Mbumu jwa Akunnungu ŵantuluchile achiŵaga mpela nguunda. ");
INSERT INTO yao_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Liloŵe lya Akunnungu lyapikaniche kutyochela kwinani lichitiji, “Mmwejo ni Mwanangu jungunnonyela, nonyelwe nomwe.” ");
INSERT INTO yao_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Papopo Mbumu jwa Akunnungu ŵanlongwesye Che Yesu kwaula mwipululu. ");
INSERT INTO yao_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ni ŵatemi mwipululu mo moŵa alobaini achilinjikwaga ni Shetani. Kukoko ŵatamaga pamo ni inyama ya mwitinji, nambo achikatumetume ŵa kwinani ŵaliji nkwakamuchisya. ");
INSERT INTO yao_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Che Yohana paŵataŵikwe mu nyuumba jakutaŵilwa ŵandu, Che Yesu ŵajawile ku chilambo cha ku Galilaya kwalalichila ŵandu Ngani Jambone ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ŵatite, “Katema kaiche ni Umwenye wa Akunnungu uŵandichile. Nneche sambi syenu ni kujikulupilila Ngani Jambone!” ");
INSERT INTO yao_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Che Yesu paŵapitaga mungulugulu litanda lya Galilaya, ŵaweni ŵakukoka ŵaŵili, che Simoni pamo ni che Andulea mpwakwe ali nkukoka somba kwa lwau. ");
INSERT INTO yao_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Che Yesu ŵaasalile, “Munguye, none chinantende ŵanyamwe mme ŵakwaikanawo ŵandu kwa Ambuje.” ");
INSERT INTO yao_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Papopo ŵalesile nyau syao ni kwakuya. ");
INSERT INTO yao_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Che Yesu paŵajawile mmbujo kanandi, ŵaweni che Yakobo ni che Yohana, ŵanache ŵa che Sebedayo. Ni ŵanyawo ŵaliji mu ngalaŵa jao achisaulaga nyau syao. ");
INSERT INTO yao_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Papopo Che Yesu paŵaweni, ŵaaŵilasile, ni ŵanyawo ŵalesile che Sebedayo atati ŵao mu ngalaŵa pamo ni ŵakwapanganyichisya masengo, ni ŵakuiye Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Che Yesu pamo ni ŵakulijiganya ŵao ŵaiche musi wa Kapelenaumu, ni palyaiche Lyuŵa lya Kupumulila, Che Yesu ŵajinjile mu nyuumba ja kusimanilana Ŵayahudi, ni ŵatandite kwajiganya ŵandu maloŵe gambone ga Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ŵandu wose ŵaŵampilikene ŵasimosile ni uwiganye wakwe, pakuŵa nganajiganya mpela ŵakwiganya Malajisyo, nambo ŵajiganyaga nti mundu jwali ni ulamusi. ");
INSERT INTO yao_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Papopo mundu jwakamwilwe ni lisoka juŵaliji mu nyuumba ja kusimanilana jila ŵanyanyisye, ");
INSERT INTO yao_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","achitiji, “Ana nkusaka kututenda ichichi, mmwe Che Yesu jwa ku Nasaleti? Ana nnyiche kukutujonanga? Ngummanyilila kuti mmwejo ndi Jwanswela jwa Akunnungu!” ");
INSERT INTO yao_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Che Yesu ŵalikalipile lisoka lyo achitiji, “Mmyalale! Munkopoche mundu jo.” ");
INSERT INTO yao_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nipele lisoka lyo lyantinganyisye mundu jula kwa machili ni kunyanyisya, ni lyakopweche. ");
INSERT INTO yao_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ŵandu wose ŵasimosile nnope ni ŵaliji nkuusyana, “Ana yelei ni yatiuli? Uli, gelega gali majiganyo ga sambano? Mundu ju akwete ulamusi wa kugakoposya namose masoka, nombego gakwajitichisya!” ");
INSERT INTO yao_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nipele, ngani jakwe Che Yesu jajenele kwachitema palipose, kuchilambo chose cha ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Che Yesu ni ŵakulijiganya ŵao pamo ni che Yakobo ni che Yohana ŵakopweche mu nyuumba ja kusimanilana jila ni kwaula ku nyuumba ja ŵanya che Simoni ni che Andulea. ");
INSERT INTO yao_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Akwegwao che Simoni jwankongwe, ŵagonile pachindanda ali nkulwala chiilu, ni Che Yesu naikape ŵasalilwe yankati jwakulwala jo. ");
INSERT INTO yao_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nipele Che Yesu ŵanjaulile jwankongwe jo ni ŵankamwile nkono ni kunjinamukula. Ulwele ula wannesile nipele ŵatandite kwatelechela. ");
INSERT INTO yao_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ligulo, lyuŵa lili litiŵile, ŵandu ŵaajauchisye Che Yesu ŵakulwala wose ni ŵaŵakamwilwe ni masoka. ");
INSERT INTO yao_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ŵandu wose ŵa musi wo ŵasongangene paluŵala lwa nyuumba. ");
INSERT INTO yao_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Che Yesu ŵalamisye ŵandu ŵajinji ŵaŵaliji ni ilwele yakupisyangana ni kugakoposya masoka gamajinji gagaliji mwa ŵandu ŵala. Nganiŵapa masoka lipesa lyakuŵecheta chachilichose ligongo gaamanyilile ali ŵaani. ");
INSERT INTO yao_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kundaŵipe kukanaŵe kucha, Che Yesu ŵakopweche mu nyuumba jo ni kwaula paasa musi, pangali ŵandu kukupopela. ");
INSERT INTO yao_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Che Simoni ni achinjakwe ŵala ŵajawile kukwasosa. ");
INSERT INTO yao_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Paŵammweni ŵansalile, “Ŵandu wose ali nkunsosa mmwe.” ");
INSERT INTO yao_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Che Yesu ŵaasalile, “Tukusachilwa tujaule mmisinda jine jajiŵandichile akuno, ni kweleko ngusachilwa ngalalichile Ngani Jambone, pakuŵa yelei ni inyichile.” ");
INSERT INTO yao_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nipele, Che Yesu ŵajesilejesile ku Galilaya kose, achilalichilaga mmajumba gao ga kupopelela ni kugakoposya masoka. ");
INSERT INTO yao_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lyuŵa limo mundu jwa matana ŵaiche ku Che Yesu ni kwatindiŵalila ni kwachondelela kuti, “Mwasakaga muuswejesye!” ");
INSERT INTO yao_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Che Yesu ŵankolele chanasa, ŵajongwele nkono wao ni ŵankwaiye ni kwasalila, “Ngusaka, Nswejele!” ");
INSERT INTO yao_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Papopo matana gakwe gala gannesile ni ŵaswejele. ");
INSERT INTO yao_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nipele Che Yesu ŵansalile ajaule achinjamukaga kwa machili, achinsalilaga, ");
INSERT INTO yao_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nnole, munansalile mundu jwalijose chindu chi, nambo njaule nkalilosye kwa jwambopesi, nkatyosye mbopesi mpela iŵatite pakusala che Musa kwalosya ŵandu wose kuti nnamile.” ");
INSERT INTO yao_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nambo mundu jula paŵakopweche, ŵatandite kwenesya ngani jo papalipose, namose Che Yesu nganakombola kwinjila sooni mmusi kwakulilosya. Nambo ŵatemi paasa musi, pangali ŵandu, atamuno yeleyo ŵandu kopochela papalipose ŵanjaulile kukokopeko. ");
INSERT INTO yao_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pagapite moŵa gampepe, Che Yesu ŵaujile sooni ku Kapelenaumu ni ŵandu ŵapilikene kuti ali pamusi. ");
INSERT INTO yao_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nipele ŵandu ŵajinji ŵasongangene atamuno nganilisigala lipesa lyalililyose, ni ŵagumbele mpaka paluŵala. Che Yesu ŵaliji nkwalalichila Liloŵe lya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pelepo ŵandu ncheche, ŵannyichisye mundu jwatatele ku Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nambo kwaligongo lya winji wa ŵandu, nganakombola kunjausya jwakulwala pachiŵandi ni Che Yesu. Nipele, ŵapesekwile pa chipagala cha nyuumba palapala paŵaliji Che Yesu. Pelepo ŵantulwisye mundu jo ali agonile pa chitagala. ");
INSERT INTO yao_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Che Yesu paŵachiweni chikulupi chao chila, ŵansalile jwakutatala jula, “Mwanangu, nlecheleswe sambi syenu.” ");
INSERT INTO yao_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ŵampepe mwa ŵakwiganya Malajisyo ga Akunnungu gaŵapele che Musa ŵaŵatemi pepala, ŵaliji nkuliusya mmitima jao, ");
INSERT INTO yao_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ana akukombola chinauli kuŵecheta yelei? Akwatukana Akunnungu! Akunnungu pe ni ŵakukombola kulechelesya sambi.” ");
INSERT INTO yao_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Papopo Che Yesu ŵaimanyilile yanayose iŵaganisyaga mmitima jao, ni ŵausisye, “Ana ligongo chi nkuganisya yelei mmitima jenu? ");
INSERT INTO yao_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ana chapi chachili chakwepepala, kunsalila mundu jwatatele ju, ‘Nlecheleswe sambi syenu,’ pane kunsalila, ‘Njimuche, njigale chitagala chenu njende’? ");
INSERT INTO yao_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nipele, ngusaka mmanyilile kuti Mwana jwa Mundu akwete ulamusi wa kulechelesya sambi sya ŵandu pachilambo pano.” Papopo ŵansalile mundu jwatatele jula, ");
INSERT INTO yao_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngunsalila, njimuche, njigale chitagala chenu, njaule kumangwenu!” ");
INSERT INTO yao_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ŵandu paŵannolechesyaga, mundu jula ŵajimwiche, ŵajigele chitagala chao ni kukopoka. Ŵandu wose ŵasimosile ni kwakusya Akunnungu achitiji, “Ngapagwa kose patwaiweni yanti yeleyi!” ");
INSERT INTO yao_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Che Yesu ŵajawile sooni mungulugulu litanda lya Galilaya. Mpingo wa ŵandu wanjaulile ni Che Yesu ŵatandite kwajiganya. ");
INSERT INTO yao_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Paŵaliji nkupita, ŵammweni che Lawi mwanache ju che Alufayo ali atemi pa nyuumba ja kukumbikanyila nsongo. Che Yesu ŵansalile, “Munguye!” Che Lawi ŵajimi ni ŵankuiye. ");
INSERT INTO yao_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kanyuma, Che Yesu ŵatemi mu nyuumba ji che Lawi kulya chakulya. Ŵakukumbikanya nsongo ŵajinji ni ŵandu ŵa sambi ni ŵandu, ŵaakuiye Che Yesu. Ni ŵajinji mwa ŵelewo ŵaliji nkulya pamo nawo ni ŵakulijiganya ŵao. ");
INSERT INTO yao_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ŵakwiganya Malajisyo ŵampepe ŵaŵaliji Mafalisayo, paŵaiweni kuti Che Yesu akulya pamo ni ŵandu ŵangakukundikwa ni ŵandu ni ŵakukumbikanya nsongo, ŵausisye ŵakulijiganya ŵao ŵala, “Kwachichi akulya ni ŵandu nti ŵeleŵa?” ");
INSERT INTO yao_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Che Yesu paŵapilikene ŵaasalile, “Ŵandu ŵangakulwala ngakunlajila jwantela, nambo ŵakulwala. Une nganiika kukwaŵilanga ŵandu ŵambone, nambo ŵandu ŵa sambi.” ");
INSERT INTO yao_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Katema kampepe ŵakulijiganya ŵa che Yohana ni ŵakulijiganya ŵa Mafalisayo ŵaliji nkutaŵa. Ŵandu ŵampepe ŵaiche ku Che Yesu ni kumbusya, “Ana ligongo chi ŵakulijiganya ŵa che Yohana ni ŵakulijiganya ŵa Mafalisayo akutaŵanga, nambo ŵakulijiganya ŵenu ngaakutaŵa?” ");
INSERT INTO yao_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Che Yesu ŵajanjile, “Ana ŵakuŵilanjikwa ku ulombela akukombola kutaŵa ni jwanlombela ali pamo nawo? Ngwamba! Ngaakukombola kutaŵa. ");
INSERT INTO yao_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nambo chiliiche lyuŵa mlombela jo pachajigalikwe mwa ŵanyawo, moŵa go ni pachachitaŵa. ");
INSERT INTO yao_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ngapagwa mundu jwakukata chigamba cha nguo ja sambano ni kuchitotela mu nguo jakuwisala. Pakuŵa atendaga yeleyo chigamba chasambano cho chichinyale ni kupapula nguo jakuwisala jo ni papapapwiche po chipapunde kupapuka. ");
INSERT INTO yao_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ni sooni ngapagwa mundu jwakutaga divai jasambano mmisaku ja mapende jakuwisala. Pakuŵa atendaga yeleyo divai jasambano chijitutumule misaku jo ni kujipapula, divai chijimwasiche ni misaku chijijonasiche. Divai ja sambano jikutajikwa mmisaku ja mapende ja sambano.” ");
INSERT INTO yao_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa Lyuŵa lya Kupumulila limo, Che Yesu pamo ni ŵakulijiganya ŵao ŵaliji nkupita mmigunda ja ngano. Paŵaliji nkwenda ŵakulijiganya ŵao ŵatandite kutema masache ga ngano. ");
INSERT INTO yao_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafalisayo ŵaausisye Che Yesu achitiji, “Nnole! Ligongo chi ŵakulijiganya ŵenu akutenda yaikanichikwe kuipanganya pa Lyuŵa lya Kupumulila?” ");
INSERT INTO yao_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Che Yesu ŵajanjile, “Ana nganinsyome iŵatesile che Daudi ni achinjakwe pajakwete sala? ");
INSERT INTO yao_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Che Daudi ŵajinjile pa Nyuumba ja Akunnungu ni ŵalile mikate jijatyochekwe nti sadaka kwa Akunnungu. Yeleyi yatendekwe katema che Abiasali ali Jwambopesi Jwankulu. Ŵambopesi pe ni ŵaŵasachilwe kulya mikate jo, nambo che Daudi ŵalile, sooni ŵapele achinjakwe.” ");
INSERT INTO yao_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nipele Che Yesu ŵamalichisye kuŵecheta, “Lyuŵa lya Kupumulila lyaŵichikwe kwaligongo lya kwakamuchisya ŵandu nambo ngaŵa ŵandu kulitumichila Lyuŵa lya Kupumulila. ");
INSERT INTO yao_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nipele Mwana jwa Mundu ali Ambuje atamuno pa Lyuŵa lya Kupumulila.” ");
INSERT INTO yao_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nipele Che Yesu ŵajinjile sooni mu nyuumba ja kusimanilana Ŵayahudi ni mmomo mwaliji ni mundu jwapombotele nkono. ");
INSERT INTO yao_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ŵandu ŵampepe ŵaliji nkusosa ligongo lya kwakamulila Che Yesu. Nipele ŵaliji nkunnolechesya panepa chanlamye mundu jo pa Lyuŵa lya Kupumulila. ");
INSERT INTO yao_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Che Yesu ŵansalile mundu jwapombotele nkono jula, “Njise paujo.” ");
INSERT INTO yao_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nipele Che Yesu ŵausisye, “Ana ili yambone pa Lyuŵa lya Kupumulila kuitendekanya yambone pane yangalumbana? Kukulupusya pane kuulaga?” Nambo ŵanyawo ŵamyalele. ");
INSERT INTO yao_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Che Yesu ŵalolechesye wose kwa lutumbilo, ni ŵasupwiche ligongo mitima jao jaliji jekakatime. Nipele ŵansalile mundu jula, “Njongole nkono wenu!” Nombejo ŵaujongwele, ni nkono wao walamile. ");
INSERT INTO yao_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Papopo, Mafalisayo ŵakopweche paasa pa nyuumba ja kusimanilana ni kuŵechetesyana ni ŵandu ŵa mpingo u che Helode itajile pakwaulaga Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Che Yesu pamo ni ŵakulijiganya ŵao ŵatyosile pelepo ni kwaula mungulugulu litanda lya Galilaya ni mpingo wa ŵandu wankuiye. Ŵandu wo ŵaumile mmisi ja ku Galilaya ni ku Yudea. ");
INSERT INTO yao_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Paŵapilikene iŵaitesile Che Yesu, ŵandu ŵane ŵaichilile kutyochela mmisi ja ku Yelusalemu ni ku Idumea ni mmisi jajili peesi lusulo lwa Yolodani, ni kutyochela mmisi ja ku Tilo ni ku Sidoni. ");
INSERT INTO yao_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pakuŵa ŵandu ŵaliji ŵajinji, Che Yesu ŵaasalile ŵakulijiganya ŵao ŵaŵichile chile ngalaŵa kuti ŵandu anaiche kwaŵijikanya. ");
INSERT INTO yao_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pakuŵa ŵaalamisye ŵandu ŵajinji, ŵakulwala wose ŵaliji nkututana kuti ŵakwaye. ");
INSERT INTO yao_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ni ŵandu ŵaŵakamwilwe ni masoka paŵammonaga, ŵaligwisisye paujo pao ni kunyanyisya achitiji, “Mmwejo ni Mwana jwa Akunnungu!” ");
INSERT INTO yao_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nambo Che Yesu ŵagakanyisye kwa chikali masoka ganaamanyisye ŵandu ŵane kuti ŵele ali ŵaani. ");
INSERT INTO yao_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Che Yesu ŵakwesile kwitumbi ni kwaŵilanga ŵandu ŵaŵasachile nsyene, nombewo ŵajaulile. ");
INSERT INTO yao_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nipele ŵasagwile ŵandu likumi ni ŵaŵili ŵaŵaaŵilasile achinduna ni kwasalila, “Nansagwile nnonjele pamo none, sooni chinantume kukwalalichila ŵandu Ngani Jambone, ");
INSERT INTO yao_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ni ŵanyamwe chinkole ulamusi wa kugakoposya masoka.” ");
INSERT INTO yao_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ŵeleŵa ni ŵandu likumi ni ŵaŵili ŵaŵasagwile, che Simoni ajula Che Yesu juŵampele liina liine che Petulo, ");
INSERT INTO yao_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ni Che Yakobo ni mpwakwe che Yohana ŵanache wa che Sebedayo, Che Yesu ŵapele liina liine Boanelige malumbo gakwe “Ŵandu ŵaali mpela ilindimo, pane akuŵilanjikwa ŵandu ŵaambumu.” ");
INSERT INTO yao_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ŵane ŵaliji che Andulea ni che Filipo ni che Batolomayo ni che Matayo ni che Tomasi ni che Yakobo mwana ju che Alufayo, che Tadayo ni che Simoni jwakuŵilanjikwa Selote, ligongo ŵaliji jwakumenyanila chilambo chakwe, ");
INSERT INTO yao_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni che Yuda Isikaliote, juŵangalawiche Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nipele Che Yesu ŵausile kumangwao. Mpingo wekulungwa wa ŵandu ŵasongangene sooni, mpaka Che Yesu ni ŵakulijiganya ŵao nganakombola kulya. ");
INSERT INTO yao_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Achalongo achinjakwe paŵapilikene yelei, ŵapite kukwajigala ligongo ŵatite kuti jwampugwe. ");
INSERT INTO yao_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ŵakwiganya Malajisyo ŵaŵaumile ku Yelusalemu ŵatite, “Akwete Belesebuli! Jwankulu jwa masoka, jwakwapa machili ga kugakoposya masoka.” ");
INSERT INTO yao_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pelepo Che Yesu ŵaaŵilasile ŵandu ni kwasalila kwa itagu achitiji, “Ana ikukomboleka Shetani kunkoposya Shetani njakwe? ");
INSERT INTO yao_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Iŵaga umwenye usapulene mipingo mipingo jajikumenyana, umwenye wo ngaujendelechela. ");
INSERT INTO yao_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sooni iŵaga ŵandu ŵa nyuumba jimo asapulanaga mipingo mipingo ni kumenyana, ŵandu wo chajonasiche. ");
INSERT INTO yao_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Iyoyo peyo, umwenye wa Shetani, wasapulanaga mipingo mipingo ngaukola machili. ");
INSERT INTO yao_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ngapagwa jwakupakombola kwinjila mu nyuumba ja jwamachili ni kunsumula ipanje yakwe yose, pangantaŵa kaje jwamachili jo. Pelepo ni pachachikombola kunsumula ipanje yakwe yose. ");
INSERT INTO yao_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Isyene ngunsalila, ŵandu chaalecheleswe sambi syao syose ni kwatukana kwao Akunnungu kose. ");
INSERT INTO yao_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nambo, mundu jwalijose jwakuntukana Mbumu jwa Akunnungu ngalecheleswa sambi syo ng'o, pakuŵa chakole sambi sya moŵa gose pangali mbesi.” ");
INSERT INTO yao_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Che Yesu ŵaŵechete yeleyo ligongo ŵandu ŵaliji nkusala kuti, “Akamwilwe ni lisoka.” ");
INSERT INTO yao_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Achikulugwe ni achapwakwe Che Yesu ŵaiche pelepo, ŵajimi paasa ni kuntuma mundu akaaŵilanje Che Yesu nkati. ");
INSERT INTO yao_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mpingo wa ŵandu watemi kwakwasyungula Che Yesu. Nipele jumo jwao ŵansalile, “Achikulu ŵenu ni achapwenu alinji paasa, akunsosa.” ");
INSERT INTO yao_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nambo Che Yesu ŵaasalile, “Ana achikulu ŵangu ni achapwanga ali ŵaani?” ");
INSERT INTO yao_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pelepo ŵaalolechesye ŵandu uŵansyungwile ŵala ni kuti, “Nnole, ngwaona ŵandu ŵa mpela achikulu ŵangu ni achalongo ŵangu. ");
INSERT INTO yao_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pakuŵa mundu jwalijose jwakuitendekanya yakuisaka Akunnungu, jwelejo ali achimwene jwangu ni mlumbwangu ni achikulu ŵangu.” ");
INSERT INTO yao_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Che Yesu ŵatandite sooni kwiganya ali mungulugulu litanda lya Galilaya. Mpingo wekulungwa wa ŵandu wansyungwile mpaka ŵajinjile mu ngalaŵa ni kutama mmomo. Ŵandu wose ŵatemi mungulugulu litanda. ");
INSERT INTO yao_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Che Yesu ŵatandite kwajiganya indu yejinji kwa itagu. Mmajiganyo gakwe ŵaasalile. ");
INSERT INTO yao_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mpilikanichisye! Jwakupanda ŵajawile kukumisa mbeju. ");
INSERT INTO yao_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Paŵamisaga, mbeju sine syagwilile mwitala ni ijuni yaiche ni kusimila. ");
INSERT INTO yao_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mbeju sine syagwilile pa lwala papaliji ni litaka kanandi, mbeju syamesile kwachitema pakuŵa litaka lyakwe lyaliji kanandi. ");
INSERT INTO yao_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ni palyakopweche lyuŵa lyatinisye mimela, ligongo michiga jakwe nganijijinjilisya paasi. ");
INSERT INTO yao_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeju sine syagwilile pa miiŵa, miiŵa jila jakusile ni kuiŵijikanya mimela, nombe mimela jo nganijisogola isogosi. ");
INSERT INTO yao_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mbeju sine syagwilile pa chaajila, syamesile ni syakusile ni kusogola. Sine syasogwele makumi gatatu ni sine makumi nsano ni limo ni sine makumi likumi.” ");
INSERT INTO yao_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Che Yesu ŵatite, “Ŵaali ni mapilikanilo gakupilikana, apilikane.” ");
INSERT INTO yao_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Che Yesu paŵaliji pajika, ŵane mwa ŵaŵampilikene ŵala pamo ni ŵakulijiganya ŵao likumi ni ŵaŵili ŵanjaulile ni kumbusya malumbo ga itagu yo. ");
INSERT INTO yao_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Che Yesu ŵajanjile, “Ŵanyamwe mpegwilwe kumanyilila yantemela ya Umwenye wa Akunnungu. Nambo kwa ŵane ŵaali paasa chalijiganye indu yose kwa itagu pe, ");
INSERT INTO yao_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kuti, ‘Alolechesye, nambo anaone. Apilikanile, nambo anaimanyilile. Pakuŵa amanyililaga chiŵagalauchile Akunnungu, nombejo akaalechelesye sambi syao.’ ” ");
INSERT INTO yao_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nipele, Che Yesu ŵausisye, “Uli ngankugamanyilila malumbo ga chitagu chi? Nambi chimmanyilile chinauli malumbo ga itagu ine? ");
INSERT INTO yao_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jwakupanda mbeju akupanda Liloŵe lya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ŵandu ŵane akulandana ni mbeju sisyagwilile mwitala. Pakulipilikana Liloŵe lya Akunnungu, Shetani akwika ni kulityosya Liloŵe lyalipandikwe mmitima jao. ");
INSERT INTO yao_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ni ŵandu ŵane ali mpela mbeju sisyagwilile pa lwala. Ŵandu wo apilikanaga Liloŵe lya Akunnungu, papopo akulijitichisya mu kusangalala. ");
INSERT INTO yao_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nambo ngalikwajinjila ni kola michiga mwa ŵanyawo, akulikamulisya kwa katema kakajipi. Nipele, kwatyochelaga kulaga pane masauko ligongo lya Liloŵe lya Akunnungu lila, pelepo akulilekanga. ");
INSERT INTO yao_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ŵandu ŵane ali mpela mbeju sisyagwilile pa miiŵa. Ŵandu wo ni ŵeŵala ŵakulipilikana Liloŵe lya Akunnungu, ");
INSERT INTO yao_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ligongo lya lipamba lya umi wu ni kunonyelwa ni ipanje pamo ni kulajila indu ine yejinji, ikwajinjila ni kuliŵijikanya Liloŵe lyo, nombewo ngakukombola kulijitichisya Liloŵe yalikuti ni kusogola isogosi. ");
INSERT INTO yao_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nambo ŵandu ŵane ali mpela mbeju sisyagwilile pa chaajila sila. Ŵelewo akulipilikana Liloŵe lyo ni kulijitichisya, nombewo akusogola isogosi ŵane makumi gatatu ni ŵane makumi nsano ni limo ni ŵane makumi likumi.” ");
INSERT INTO yao_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Che Yesu ŵapundile kwasalila, “Ana mundu akupamba lumuli ni kuluikanawo nkati ni kuluunichila ni lulo pane kuluŵika kuusi chindanda? Ngwamba! Akuluŵika pachanya chindu chakuŵichila lumuli. ");
INSERT INTO yao_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iyoyo, chindu chachilichose chachisisikwe chichioneche pakulanguka, ni chachilichose cheunichikwe chichiunukulikwe. ");
INSERT INTO yao_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ŵaali ni mapilikanilo gakupilikana, apilikane!” ");
INSERT INTO yao_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ni ŵapundile kwasalila, “Mpilikanichisye yambone inkwipikana yo! Lilamulo lilalila linkwalamulila ŵandu ŵane, Akunnungu chaachinnamulila ni ŵanyamwe wakwe, sooni chanjonjechesye. ");
INSERT INTO yao_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pakuŵa mundu jwakwete chindu chajonjechekwe ni mundu jwanganakola chindu chasumulwe atamuno kanandi chakwete.” ");
INSERT INTO yao_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Che Yesu ŵajendelechele kuŵecheta, “Umwenye wa Akunnungu ukulandana ni mundu jwakumisa mbeju mu ngunda. ");
INSERT INTO yao_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chilo akugona ni muusi akuŵa meeso, mbeju sikumela ni kukula. Nombejo ngakuimanyilila yaikutendekwa. ");
INSERT INTO yao_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Litaka lisyene likutendekasya mmela kukula ni kusogola. Kundanda ukumela, sooni ukukoposya lisache kumbesi ukusogola ngano. ");
INSERT INTO yao_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","isogosi yakomalaga pe, mundu jula akugungula ni chikwakwa chakwe, pakuŵa katema ka magungulo kaiche.” ");
INSERT INTO yao_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Che Yesu ŵausisye sooni, “Ana tutuulandanichisye ni chichi Umwenye wa Akunnungu? Kwaali tuutanje kwa chitagu chi? ");
INSERT INTO yao_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ukulandana ni mbeju ja haladali, mbeju jamwana nnope kupunda mbeju syose syasikupandikwa pachilambo. ");
INSERT INTO yao_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nambo japandikwaga jikukula ni kuŵa chitela chachikulungwa kupunda mimela jose ja mu ngunda, nombecho chikuŵa ni nyambi syasikulungwa nnope ni ijuni ikwika kutaŵa isusi mu nyambi syakwe.” ");
INSERT INTO yao_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Che Yesu ŵalalichile ŵandu utenga wao kwa itagu yejinji yanti yele, ŵakungulwiche nawo mpela iŵatite pakukombola ŵanyawo kumanyilila. ");
INSERT INTO yao_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nganaŵecheta ni ŵandu chachilichose pangali itagu, nambo paŵaliji pamo ni ŵakulijiganya ŵao pachisyepela ŵatagulile yose. ");
INSERT INTO yao_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lyuŵa lilyolyo ligulo, Che Yesu ŵaasalile ŵakulijiganya ŵakwe, “Tujombochele peesi litanda.” ");
INSERT INTO yao_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nipele ŵakulijiganya ŵao ŵaulesile mpingo wa ŵandu ula, ni kwinjila mu ngalaŵa jiŵaliji Che Yesu ni kwaula nawo. Ilaila paliji ni ngalaŵa sine. ");
INSERT INTO yao_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nipele jatandite kupuga mbungo jejikulungwa ni matumbela gajiputile ngalaŵa jila, nombejo jatandite gumbala meesi. ");
INSERT INTO yao_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Che Yesu ŵaliji panyuma mu ngalaŵa ali agonile pa nsamilo. Ŵakulijiganya ŵao ŵaajimwisye ni kwasalila, “Jwakwiganya, ana uli ngankuikosya kuti uweji tulinkonasika?” ");
INSERT INTO yao_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Che Yesu ŵajimwiche, ni kujikalipila mbungo jejikulungwa ni kugasalila matumbela, “Tulalani!” Papopo mbungo jatulele ni kwaliji jii. ");
INSERT INTO yao_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nipele Che Yesu ŵaasalile ŵakulijiganya ŵao, “Kwachichi nkogopanga? Ana nganimme kola chikulupi?” ");
INSERT INTO yao_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ŵakulijiganya ŵajogwepe nnope ni ŵausyanaga, “Ana jweleju ali mundu jwanti uli? Mpaka chimbunga ni matumbela ikwapilikanila!” ");
INSERT INTO yao_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Che Yesu ni ŵakulijiganya ŵao ŵaiche peesi litanda lya Galilaya, ku chilambo cha ku Gelasi. ");
INSERT INTO yao_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nakopokape Che Yesu mu ngalaŵa, ŵasimene ni mundu juŵaliji ni lisoka achityochelaga ku malembe. ");
INSERT INTO yao_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mundu jo ŵaliji nkutama ku malembe. Nganapagwa mundu juŵankombolaga kuntaŵa sooni namose ni minyolo. ");
INSERT INTO yao_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Katema kakajinji ŵantaŵile makongolo ni makono gakwe kwa minyolo ni magwedegwede, nambo ŵagambaga kutulanya minyolo jo ni kutemanya magwedegwede mmakongolo. Ni ngapagwa mundu jwamachili juŵapakombwele kunkamula. ");
INSERT INTO yao_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Muusi ni chilo ŵaliji nkwendajenda ku malembe ni mmatumbi achinyanyisyaga ni kulikatanya ni maganga. ");
INSERT INTO yao_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mundu jo paŵambweni Che Yesu kwakutalichila, ŵambutuchile ni kwatindiŵalila. ");
INSERT INTO yao_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ŵanyanyisye achitiji, “Mmwe Che Yesu, Mwana jwa Akumanani, ana nkusaka chichi kwanguune? Mu liina lya Akunnungu, ngunchondelela nnalagasye!” ");
INSERT INTO yao_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ŵaŵechete yeleyo pakuŵa Che Yesu ŵansalile, “Mmwe lisoka, nkopoche mwa mundu ju.” ");
INSERT INTO yao_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Che Yesu ŵambusisye, “Liina lyenu ŵaani?” Nombejo ŵajanjile, “Liina lyangu Mpingo, pakuŵa tuli achajinji.” ");
INSERT INTO yao_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nipele ŵachondelele kwannope Che Yesu kuti akasagakopochesya masoka go paasa musi ula. ");
INSERT INTO yao_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chiŵandi ni chitulusya kwaliji ni mpingo wekulungwa wa maguluŵe gachilyaga. ");
INSERT INTO yao_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nipele, masoka gaachondelele Che Yesu gachitiji, “Ntujausye ku maguluŵe gala, tukagajinjile gelego.” ");
INSERT INTO yao_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nombe Che Yesu ŵagalechele. Nipele masoka gala gankopweche mundu jula ni kwinjila mmaguluŵe. Mpingo wose wa maguluŵe waliji mpela mianda jiŵili waselelechele mu litanda, watitimile mmeesi ni kuwa. ");
INSERT INTO yao_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ŵandu ŵaŵachingaga maguluŵe go, ŵautuchile mmusi ni mmigunda kukwasalila ŵandu iyatendekwe yo. Ŵandu ŵaiche kukulola iyatyochele. ");
INSERT INTO yao_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Paŵaiche kuŵaliji Che Yesu kula, ŵammweni mundu julajula juŵakamwilwe ni mpingo wa masoka. Jwatemi ali awasile nguo syakwe ni jwana lunda, ni ŵandu ŵajogwepe nnope. ");
INSERT INTO yao_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ni ŵandu ŵaŵaiweni aila iyatyochele, ŵaasalile ŵandu ŵane iyansimene mundu jwakamwilwe ni masoka jula ni ngani ja maguluŵe. ");
INSERT INTO yao_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nipele, ŵandu ŵatandite kwachondelela Che Yesu kuti akopoche mu chilambo chao. ");
INSERT INTO yao_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Che Yesu paŵaliji nkwinjila mu ngalaŵa, mundu juŵakamwilwe ni masoka jula ŵachondelele kuti alongane nawo. ");
INSERT INTO yao_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nambo, Che Yesu ŵakanile ni kwasalila, “Njaule kumangwenu, kwa achalongo achinjenu, nkaasalile yanayose yambone yampanganyichisye Ambuje ni yatite pakunkolela chanasa.” ");
INSERT INTO yao_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nipele mundu jula ŵajawile ni kutanda kwenesya ku chilambo chose cha Dekapoli, yaani misi likumi, indu yaikulungwa iŵapanganyichisye Che Yesu. Ŵandu wose ŵaŵapilikene ŵasimosile. ");
INSERT INTO yao_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Che Yesu ŵajombweche sooni litanda lya Galilaya ni ngalaŵa. Paŵaliji mungulugulu litanda, mpingo wekulungwa wa ŵandu wasongangene pachiŵandi nawo. ");
INSERT INTO yao_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pelepo jwaiche mundu jumo, jwankulu jwa nyuumba ja kusimanilana Ŵayahudi, liina lyakwe che Yailo. Paŵambweni Che Yesu, ŵaligwisisye paujo pa Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nipele, ŵachondelele nnope achitiji, “Mwali jwangu akulwala nnope, ngummenda twende nkansajichile makono kuti alame ni kukola umi.” ");
INSERT INTO yao_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nipele, Che Yesu ŵatyosile achilonganaga ni mundu jula. Ŵandu ŵajinji ŵakuiye ni ŵaliji nkwaŵijikanya kosekose. ");
INSERT INTO yao_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pelepo paliji ni jwankongwe juŵaliji ni magono kwa yaka likumi ni iŵili. ");
INSERT INTO yao_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jwankongwe jo, ŵalasile nnope kwajaulila ŵamitela ŵajinji. Namuno ŵaliji atyosisye ipanje yakwe yose, nambo nganapata eja ni ulwele ula waliji nkuendelechela pe. ");
INSERT INTO yao_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jwankongwe jo paŵapilikene kuti Che Yesu akwalamya ŵandu, ŵapelete mu mpingo wa ŵandu ula ni kwajaulila Che Yesu kwa panyuma ni kukwaya chiwalo chakwe. ");
INSERT INTO yao_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ŵaganisisye, “Nakwayaga pe chiwalo chao, chiilame.” ");
INSERT INTO yao_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Paŵakwaiye pe chiwalo chi Che Yesu, papopo magono gakwe galesile, nombe ŵalipikene pachiilu kuti alamile. ");
INSERT INTO yao_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Papopo Che Yesu ŵamanyilile kuti machili gakwe ganlamisye mundu. Nipele ŵaugalauchile mpingo wa ŵandu ni kuusya, “Ana nduni jwakwaiye iwalo yangu?” ");
INSERT INTO yao_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ŵakulijiganya ŵao ŵajanjile, “Ngankwaona ŵandu yatiteje pakumbijikanya? Nambi nkuusya uli kuti, ‘Nduni jwangwaiye?’ ” ");
INSERT INTO yao_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nambo Che Yesu ŵapundile kulolesyalolesya kuti ŵaone juŵatesile yeleyo jo. ");
INSERT INTO yao_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pelepo jwankongwe jo achimanyililaga iyasimene, ŵajaulile Che Yesu alinkutetemela kwa lipamba ni kuligwisya paujo pao, ni kwasalila usyene wose. ");
INSERT INTO yao_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Che Yesu ŵansalile, “Mwanangu, chikulupi chenu chinnamisye. Njaule kwa chitendewele ni nlame ulwele wenu.” ");
INSERT INTO yao_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Che Yesu paŵaliji nkuŵecheta, ŵaiche ŵandu kutyochela ku nyuumba ji che Yailo, jwankulu jwa nyuumba ja kusimanilana Ŵayahudi jula ni ŵansalile, “Mwali jwenu jula ajasiche. Ligongochi nkunsausya Jwakwiganya?” ");
INSERT INTO yao_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nambo Che Yesu nganagakosya maloŵe gaŵaŵechete ŵandu wo, nipele ŵansalile jwankulu jwa nyuumba ja kusimanilana Ŵayahudi jula, “Kasinjogopa, ngambe kulupilila pe.” ");
INSERT INTO yao_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nipele Che Yesu nganasaka kulongana ni mundu jwalijose, ikaŵe che Petulo ni che Yakobo ni che Yohana mpwakwe che Yakobo. ");
INSERT INTO yao_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Paŵaiche ku nyuumba ji che Yailo, Che Yesu ŵaweni ŵandu alinkunyokonya kwa ililo ni kulila kwa malumbo. ");
INSERT INTO yao_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Che Yesu ŵajinjile mu nyuumba ni kwasalila ŵandu, “Kwachichi nkunyokonya ni kulila? Mwali nganajasika, agambile gona pe.” ");
INSERT INTO yao_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nombe ŵanyawo ŵansechile. Nipele Che Yesu ŵaakopwesye paasa wose, ŵaajigele atatigwe ni achikulugwe mwali jo pamo ni ŵakulijiganya ŵao ŵatatu, ŵajinjile mu chuumba chiŵagonile mwali jo. ");
INSERT INTO yao_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ŵankamwile nkono ni ŵansalile, “Talisa, kumi,” malumbo gakwe, “Mwali, ngunsalila njimuche!” ");
INSERT INTO yao_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Papopo mwali jo ŵajimwiche ni ŵajesile. Mwali jo ŵaliji ni yaka likumi ni iŵili. Pichakopochele chelecho ŵandu ŵala ŵasimosile kwa nnope. ");
INSERT INTO yao_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nambo Che Yesu ŵaalekasisye kwannope anaasalile ŵandu ŵane ngani jo. Nipele ŵaasalile, “Mwape chakulya alye.” ");
INSERT INTO yao_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Che Yesu ŵatyosile pepala, ŵalongene ni ŵakulijiganya ŵao ni kwaula ku nsinda wakwe. ");
INSERT INTO yao_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Palyaiche Lyuŵa lya Kupumulila, Che Yesu ŵatandite kwiganya mu nyuumba ja kusimanilana Ŵayahudi. Ŵandu ŵajinji ŵaŵampilikene ŵasimosile achitiji, “Ana apatile kwapi yele indu yakuisala yi? Ana apatile kwapi lunda lu mundu ju mpaka akombole kuitendekanya yakusimonjeka? ");
INSERT INTO yao_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ana aju ngaŵa jwakusepa jula, mwana ju che Maliamu ni achapwakwe ngaŵa che Yakobo ni che Yusufu ni che Yuda ni che Simoni? Ana achalumbugwe ngakutamanga papapa pamangwetu pa?” Kwa yele ŵankanile. ");
INSERT INTO yao_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nambo Che Yesu ŵaasalile, “Jwakulondola jwa Akunnungu akuchimbichikwa papalipose, nambo ngakuchimbichikwa mchilambo chakwe ni mwa achalongo achinjakwe ni kwa ŵandu ŵaali mu nyuumba jakwe.” ");
INSERT INTO yao_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Che Yesu nganakombola kuitendekanya indu yakusimosya pa Nasaleti po, nambo nganatupa ŵakulwala ŵaŵaasajichile makono ni kwalamya. ");
INSERT INTO yao_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nombejo ŵasimosile nnope, ligongo ŵandu ŵa kweleko wo nganakulupililanga. Nipele Che Yesu ŵasyungwile mmisinda ja pachiŵandi ni pepala ni kwajiganya ŵandu. ");
INSERT INTO yao_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Che Yesu ŵaaŵilasile ŵakulijiganya ŵao likumi ni ŵaŵili ŵala, ŵatandite kwatuma ŵaŵili ŵaŵili ni kwapa ukombole wa kugakoposya masoka. ");
INSERT INTO yao_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ni ŵaasalile, “Ngasinjigala chindu chachilichose mu ulendo ikaŵe nkongojo pe. Ngasinjigala chakulya chachilichose atamuno nsaku atamuno mbiya. ");
INSERT INTO yao_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mbwale italawanda nambo ngasinjigala mwinjilo wine. ");
INSERT INTO yao_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Papalipose pachampochele nnonjele mmomo mpaka pachintyoche pelepo. ");
INSERT INTO yao_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Papalipose pachankane kumpochela ni kukana kumpilikanila, ntyoche pelepo nchikung'undaga luundu mmakongolo mwenu, kulosya kuti nkwajamuka, pakuŵa akanile kuupochela utenga wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nipele ŵatyosile, ŵaalalichile ŵandu aleche sambi syao. ");
INSERT INTO yao_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ŵagakopwesye masoka gamajinji, sooni ŵaapakesye mauta ŵakulwala ŵajinji ni kwalamya. ");
INSERT INTO yao_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mwenye che Helode ŵasipikene ngani syo, pakuŵa liina li Che Yesu lyamanyiche papalipose. Ŵandu ŵampepe ŵatite, “Mundu ju ali che Yohana Jwakubatisya, asyuchile! Kwaligongo lyo akwete machili ga kupanganya yakusimonjeka.” ");
INSERT INTO yao_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nambo ŵane ŵatite, “Mundu ju ali che Elia.” Nombe ŵane ŵatite, “Ali jwakulondola jwa Akunnungu mpela aŵala ŵakulondola ŵa kalakala.” ");
INSERT INTO yao_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nambo che Helode paŵapilikene yeleyi, ŵatite, “Jweleju ali che Yohana Jwakubatisya junankatile ntwe, asyuchile!” ");
INSERT INTO yao_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Che Helode ŵaganisisye yeleyo pakuŵa, kundanda ko ŵaalajisye ŵandu kuti ŵakamule che Yohana ni kwataŵa mu nyuumba jakutaŵilwa ŵandu. Che Helode ŵatesile yeleyo ligongo ŵalombile che Helodia juŵaliji ŵankwakwe che Filipo mpwakwe. ");
INSERT INTO yao_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Che Yohana Ŵakubatisya ŵaasalilaga che Helode, “Ngaikuŵajilwa mmwe kwalomba ŵankwakwe mpwenu.” ");
INSERT INTO yao_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nipele che Helodia, ŵankwakwe mwenye, ŵanchimile nnope che Yohana, ŵasachile kwaulaga, nambo nganakombola. ");
INSERT INTO yao_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Che Helode ŵanjogopaga che Yohana pakuŵa ŵaimanyilile kuti ŵaliji jwambone ni jwanswela, kwapele ŵanlindilile. Che Helode yaanonyelaga kwapilikanila che Yohana, nachiŵamuno yaapetekaga ntima kwannope paŵamalisyaga kwapikanila. ");
INSERT INTO yao_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nambo lyuŵa limo, che Helodia ŵapatile lipesa pa lyuŵa lyakumbuchila kupagwa kwa che Helode. Che Helode ŵaapanganyichisye chindimba achakulu ŵa nkungulu wakwe, achakulu ŵa ŵandu ŵangondo ni ilongola ŵa chilambo cha ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nipele, mwali ju che Helodia ŵajinjile, ŵatyasile ni kunnonyelesya kwannope mwenye che Helode ni achalendo ŵakwe. Mwenye che Helode ŵansalile mwali jula, “Mumende chachilichose chinkuchisaka, chinampe.” ");
INSERT INTO yao_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ni sooni ŵalumbilile, “Chachilichose chachimumende chinampe, atamuno mbindikati ja umwenye wangu.” ");
INSERT INTO yao_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mwali jo ŵakopweche ni kwaula kwa achikulugwe kukwausya, “Ŵeende chichi?” Achikulugwe ŵajanjile, “Mmende ntwe u che Yohana Jwakubatisya.” ");
INSERT INTO yao_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mwali jula ŵausile kwa chitema kwa mwenye ni ŵaasalile, “Ngusaka muumbe sambano pejino, ntwe u che Yohana Ŵakubatisya mu mbale.” ");
INSERT INTO yao_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mwenye jula ŵasupwiche nnope, nambo pakuŵa ŵanlumbilile paujo pa achalendo ŵakwe, nganakombola kunkanila. ");
INSERT INTO yao_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Papopo mwenye ŵantumile jwangondo akajigale ntwe u che Yohana. Jwangondo ŵajawile mu nyuumba jakutaŵilwa ŵandu ni kwakata che Yohana ntwe. ");
INSERT INTO yao_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ŵaichenawo ntwe ula mu mbale ni kumpa mwali, nombejo ŵampele achikulugwe. ");
INSERT INTO yao_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ŵakulijiganya ŵa che Yohana paŵajipilikene ngani jo, ŵapite kukwigala chiilu chakwe ni kuchisika. ");
INSERT INTO yao_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Achinduna ŵala ŵausile ku ulendo wao ni kunsalila Che Yesu yose iŵaitesile ni iŵaijigenye. ");
INSERT INTO yao_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Che Yesu ŵaasalile, “Tujaule peuto pangali ŵandu kuti nkapumulile.” Ŵaŵechete yeleyo ligongo kwaliji kwana ŵandu ŵajinji ŵaŵaikaga ni kutyoka, namose Che Yesu ni ŵakulijiganya ŵakwe nganapatanga lipesa lyakuti alyanje. ");
INSERT INTO yao_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nipele ŵajinjile mu ngalaŵa achinsyene pe kwaula peuto pangali ŵandu. ");
INSERT INTO yao_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nambo ŵandu ŵajinji ŵaaweni paŵajaulaga po, ni ŵamanyilile. Nipele ŵandu ŵajinji ŵaumile misi jose ŵautuchile ni ŵalongolele kwika kwiuto kula, Che Yesu ni ŵakulijiganya ŵao akanaiche. ");
INSERT INTO yao_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Paŵatulwiche mu ngalaŵa, Che Yesu ŵauweni mpingo wekulungwa wa ŵandu, ŵaukolele chanasa ligongo ŵaliji mpela ngondolo syangali ni jwakuchinga ni ŵatandite kwajiganya indu yejinji. ");
INSERT INTO yao_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Palyaiche ligulo ŵakulijiganya ŵaajaulile Che Yesu ni kwasalila, “Sambano kuswele ni sooni mutuli muno mwipululu. ");
INSERT INTO yao_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mwalanje ŵandu ŵa ajaulangane mmisinda jajiŵandichile pane mmigunda, akalisumile yakulya.” ");
INSERT INTO yao_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nambo Che Yesu ŵatite, “Ŵanyamwe mwape chakulya alyanje.” Ŵanyawo ŵausisye, “Ana nkusaka tukasume mikate kwa mbiya syasijinji syanti yele, ni kwapa alyanje?” ");
INSERT INTO yao_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nambo Che Yesu ŵausisye, “Nkwete mikate jilingwa? Njaule nkalole.” Paŵajawile kukulola ni ŵansalile, “Jipali mikate nsano ni somba siŵili.” ");
INSERT INTO yao_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Che Yesu ŵaasalile ŵakulijiganya ŵao ŵatamiche ŵandu wo pa manyasi gamaŵisi mipingo mipingo. ");
INSERT INTO yao_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nombewo ŵatemi mmipingo ja ŵandu mia moja ni ja ŵandu hansini. ");
INSERT INTO yao_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nipele Che Yesu ŵajigele mikate nsano jila pamo ni somba siŵili sila. Ŵalolite kwinani ni kwatogolela Akunnungu ni kujigaŵanya mikate jila. Ni ŵapele ŵakulijiganya ŵao kuti ŵagaŵanyichisye ŵandu. Ilaila ŵagaŵilenye ŵandu wose somba siŵili sila. ");
INSERT INTO yao_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ŵandu wose ŵalile ni kwikuta. ");
INSERT INTO yao_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nipele ŵakulijiganya ŵakumbikenye sigasi sya mikate ni somba, ŵagumbesye itundu kumi na mbili. ");
INSERT INTO yao_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Achalume ŵaŵalile mikate jo ŵaliji mianda nsano. ");
INSERT INTO yao_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Papopo Che Yesu ŵaasalile ŵakulijiganya ŵao ajinjilanje mu ngalaŵa alongolele ku Besesaida kwakuli peesi litanda. Nombejo ŵasigalile kuti aulanje mpingo wa ŵandu ula. ");
INSERT INTO yao_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Paŵamasile kwalanga ŵandu, Che Yesu ŵakwesile kwitumbi kukupopela. ");
INSERT INTO yao_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Palyaiche ligulo, ngalaŵa jila jaliji pambindikati litanda, katema ko Che Yesu ŵaliji jikape kunsanga. ");
INSERT INTO yao_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nipele ŵaweni ŵakulijiganya ŵao ŵala achilagaga mu ngalaŵa, ligongo mbungo jaliji jininkwaputa. Kuninkucha Che Yesu ŵaŵandichile achendaga pachanya meesi ni ŵalitesile akwapelenganya. ");
INSERT INTO yao_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nambo ŵakulijiganya ŵala paŵammweni ali nkwenda pachanya meesi, ŵaganisisye lilaika, ni ŵatandite gumilanga. ");
INSERT INTO yao_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pakuŵa wose paŵambweni ŵajogwepe nnope. Papopo Che Yesu ŵaasalile, “Muusimane ntima, ndili une, kasinjogopanga.” ");
INSERT INTO yao_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nipele ŵajinjile mu ngalaŵa jiŵaliji ŵakulijiganya ŵao mula ni mbungo jatulele. Ŵakulijiganya ŵasimosile nnope, ");
INSERT INTO yao_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ligongo, ŵaliji akanamanyilile chatesile Che Yesu nkati mikate jila, pakuŵa mitima jao jatopelwe kumanyilila. ");
INSERT INTO yao_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Che Yesu pamo ni ŵakulijiganya ŵao ŵajombweche litanda, ŵaiche ku Genesaleti, pelepo ŵajijimiche ngalaŵa jao. ");
INSERT INTO yao_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Paŵakopweche mu ngalaŵa, papopo ŵandu ŵaamanyilile Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nipele ŵautwiche achisyungulaga pachilambo pose, ni kutanda kwajigalanga ŵakulwala ali agonile mmigono jao, ni kwajausya kulikose kuŵapilikene kuti Che Yesu ali kweleko. ");
INSERT INTO yao_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kulikose kuŵajawile Che Yesu, mmisinda, mmisi ni mmigunda, ŵandu ŵaliji nkwagoneka ŵakulwala peuto pakusumichisya malonda, ŵachondelele Che Yesu kuti ŵakulwala ŵakwaye namose luminiko lwa mwinjilo wao. Ni wose ŵaŵakwaiye ŵalamile. ");
INSERT INTO yao_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayo ŵampepe ni jwakwiganya Malajisyo ŵaŵatyochele ku Yelusalemu ŵasongangene paujo pa Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ŵanyawo ŵaweni ŵakulijiganya ŵampepe ŵa Che Yesu akulya panganaŵa makono mpela iyasachilwaga ni Malajisyo ga Chiyahudi. ");
INSERT INTO yao_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pakuŵa, Mafalisayo ni Ŵayahudi wose ngakulya chakulya panganaŵa mmakono, mpaka pachisukusuku achikamulisyaga masyoŵelo ga achachekulu ŵachiikala. ");
INSERT INTO yao_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sooni paakutyokanga pakusumichisya malonda ngakulya chachilichose pangajosya kaje. Nombe akugakuyanga masyoŵelo gamajinji gaŵapochele kutyochela kwa achachekulu, mpela ila yakuti pakosya migao ni iteleko ni yoombo ya libati. ");
INSERT INTO yao_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nipele Mafalisayo ni Ŵakwiganya Malajisyo ŵala ŵausisye Che Yesu, “Kwachichi ŵakulijiganya ŵenu ngakugakuya masyoŵelo gitupochele kwa achachekulu ŵetu, nambo akwamba kulya chakulya mmakono muli musakele?” ");
INSERT INTO yao_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Che Yesu ŵajanjile, “Ŵaulamba ŵanyamwe! Che Isaya, jwakulondola jwa Akunnungu, ŵalondwele yambone pa ŵanyamwe mpela iŵatite pakulemba, ‘Akunnungu akuti, ŵandu ŵa akunjimbichisyanga pakang'wa pe, nambo mmitima jao ali kwakutalikangana ni une. ");
INSERT INTO yao_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kumbopelela kwao kwangali chindu, ligongo akwiganya malajisyo ga ŵandu mpela ila akugajiganya Malajisyo ga Akunnungu.’ ");
INSERT INTO yao_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Ŵanyamwe nkugaleka Malajisyo ga Akunnungu ni kugakamulisya masyoŵelo ga ŵandu.” ");
INSERT INTO yao_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Che Yesu ŵapundile kuŵecheta, “Ŵanyamwe nkumanyi kukana kwa lunda lwenu Malajisyo ga Akunnungu kuti ngakuye masyoŵelo genu mwachinsyene! ");
INSERT INTO yao_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pakuŵa che Musa ŵalajisye, ‘Mwachimbichisye atati ŵenu ni achikulu ŵenu,’ ni, ‘Mundu jwalijose juchantukane atatigwe pane achikulugwe, aulajikwe.’ ");
INSERT INTO yao_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nambo ŵanyamwe nkwiganya, iŵaga mundu akwete chindu chakombola kwakamuchisya achikulugwe pane atatigwe, nambo nkuti chindu cho chili ‘Kolibani’, malumbo gakwe chindu cho chityosyekwe sadaka kwa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nipele mundu jo ngakusachilwa sooni kwakamuchisya atatigwe pane achikulugwe. ");
INSERT INTO yao_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yeleyo ni inkuti pakulijalusya Liloŵe lya Akunnungu kwa masyoŵelo ginkujiganyana. Ni sooni nkugatendekanya gamajinji ganti iyoyo.” ");
INSERT INTO yao_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Che Yesu ŵauŵilasile sooni mpingo wekulungwa wa ŵandu ula ni kwasalila, “Mumbikanichisye wose, ni mmanyilile. ");
INSERT INTO yao_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ngapagwa chakulya chaakulya mundu, chachikuntendekasya aŵe jwangakundikwa ni Akunnungu. Nambo chachikukopoka nkati mwa mundu, ni chachikuntendekasya mundu jo aŵe jwangakundikwa ni Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ŵaali ni mapilikanilo gakupilikana, apilikane!” ");
INSERT INTO yao_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Paŵalekangene ni ŵandu ŵala ni kwinjila mu nyuumba, ŵakulijiganya ŵao ŵambusisye malumbo ga chitagu cho. ");
INSERT INTO yao_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nombe Che Yesu ŵaasalile, “Ni ŵanyamwe nganinkola umanyilisi? Ana ngankumanyilila kuti chakulya chaakulya mundu ngachikukombola kuntendekasya aŵe jwangakundikwa ni Akunnungu? ");
INSERT INTO yao_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pakuŵa ngachikwinjila mu ntima mwakwe, nambo mlutumbo ni chikukopoka paasa pa chiilu pakwe.” Paŵaŵechete yeleyo Che Yesu ŵaitesile yakulya yose ikomboleche kuligwa. ");
INSERT INTO yao_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ŵapundile kuŵecheta, “Chachikukopoka nkati mwa mundu ni chachikuntendekasya mundu jo aŵe jwangakundikwa ni Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pakuŵa mu ntima mwa mundu ni mwamukukopoka ng'anisyo syangalimate, ni chikululu ni wiyi ni uulasi, ");
INSERT INTO yao_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ni chikululu ni lipamo ni ungalumbana ni kulambusya ni kunyenga ni wiu ni kutukana ni chibuli ni kuloŵela. ");
INSERT INTO yao_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yangalumbana yose yo, ikukopoka nkati mwa mundu, yose yo ni yaikuntendekasya mundu aŵe jwangakundikwa ni Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Che Yesu ŵatyosile pelepo, ŵajawile mu mmusi wauŵandikene ni ku Tilo. Ni kweleko ŵajinjile mu nyuumba jimo ni nganasaka mundu jwalijose aimanyilile, nambo nganakombola kulisisa. ");
INSERT INTO yao_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Jwankongwe jumo, juŵaliji ni mwali juŵakamwilwe ni lisoka, ŵapilikene ngani si Che Yesu. Ni ŵaajaulile ni kuligwisya pa makongolo gao. ");
INSERT INTO yao_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jwankongwe jo ŵaliji Mgiliki ni nganaŵa Myahudi, juŵapagwile musi wa ku Silofonike ku chilambo cha ku Silia. Ŵaachondelele Che Yesu akankoposye mwali jwao lisoka. ");
INSERT INTO yao_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nambo Che Yesu ŵajanjile, “Ajikute kaje ŵanache, pakuŵa ngaŵa yambone kwigala chakulya cha ŵanache ni kusijasila mbwa syao.” ");
INSERT INTO yao_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nambo jwankongwe jo ŵatite, “Elo, Ambuje, nambo ngati atamuno mbwa syasikutama kuusi mesa, sikulya mbakatika syakusigwisya ŵanache.” ");
INSERT INTO yao_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pelepo Che Yesu ŵasalile, “Kwaligongo lya intite pakwanga, njaule kumusi. Lisoka linkopweche mwali jwenu.” ");
INSERT INTO yao_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nipele jwankongwe jo ŵausile kumangwao, ŵansimene mwanagwe agonile pachindanda ni lisoka lili linkopweche. ");
INSERT INTO yao_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nipele Che Yesu ŵatyosile ku chilambo cha ku Tilo ni kwaula ku litanda lya Galilaya achipitilaga ku Sidoni ni ku Dekapoli. ");
INSERT INTO yao_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ŵaiche ŵandu ŵampepe ali anjigele mundu juŵaliji jwangapikana ni jwangaŵecheta, ŵaachondelele Che Yesu ansajichile makono mundu jo ni kunlamya. ");
INSERT INTO yao_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Che Yesu ŵantyosisye mundu jo mu mpingo wa ŵandu ni kunjausya pangali ŵandu, ŵaŵisile yala mmapilikanilo ga mundu jula. Ŵasunile mata pa chaala chakwe ni kunkwaya lulimi mundu jula. ");
INSERT INTO yao_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nipele Che Yesu ŵalolite kwinani kwa Akunnungu ni kwisya ntima, ŵansalile mundu jo, “Efata,” malumbo gakwe “Mbuguche.” ");
INSERT INTO yao_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Papopo mapilikanilo ga mundu jula gaugwiche ni lulimi lwakwe lwagopweche, nipele ŵatandite kuŵecheta uchenene. ");
INSERT INTO yao_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Che Yesu ŵakanyisye ŵandu ŵala kuti akansalila mundu jwalijose yelei. Namuno ŵapundile kwakanyisya, ŵanyawo ŵapundisye kuijenesya yeleyo. ");
INSERT INTO yao_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ni ŵandu ŵasimosile nnope ni kuti, “Atesile yose mwambonepe, namose ŵangapilikana akwatenda apilikane ni ŵangaŵecheta akwatenda aŵechete!” ");
INSERT INTO yao_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pa moŵa go, mpingo wekulungwa wa ŵandu wasongangene sooni. Pakuŵa nganakolanga chakulya, Che Yesu ŵaaŵilasile ŵakulijiganya ŵao ni kwasalila, ");
INSERT INTO yao_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ngwakolela chanasa ŵandu ŵa, ligongo atemi none kwa moŵa gatatu ni nganakolanga chakulya. ");
INSERT INTO yao_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Naalekaga ajaulangane mmangwao ni sala, komboleka chakomochanje mwitala, pakuŵa ŵampepe mwa ŵanyaŵa atyochele kwakutalika.” ");
INSERT INTO yao_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ŵakulijiganya ŵao ŵambusisye, “Patuli pano mwipululu, ana chitupate kwapi chakulya chakomboleka kwalisya ŵandu wose ŵa?” ");
INSERT INTO yao_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Che Yesu ŵausisye, “Ana nkwete mikate jilingwa?” Ŵanyawo ŵajanjile, “Saba.” ");
INSERT INTO yao_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Che Yesu ŵaasalile ŵandu ŵala atame paasi. Ŵajigele mikate saba jila ni ŵaatogolele Akunnungu, ŵagaŵenye ni kwapa ŵakulijiganya ŵao ŵala kuti ŵaagaŵile ŵandu, nombewo ŵaagaŵile ŵandu wo. ");
INSERT INTO yao_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sooni ŵakwete tusomba kanandi. Che Yesu ŵaatogolele Akunnungu ni ŵaasalile ŵakulijiganya ŵao ŵaagaŵile ŵandu. ");
INSERT INTO yao_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ŵandu ŵala ŵalile ni kwikuta. Nipele ŵakulijiganya ŵakumbikenye sigasi ni ŵagumbesye itundu saba. ");
INSERT INTO yao_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ŵandu ŵaŵalile ŵala ŵaliji mpela elufu nne. Nipele Che Yesu ŵalanjile, ");
INSERT INTO yao_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","papopo ŵakwesile mu ngalaŵa pamo ni ŵakulijiganya ŵao ni kwaula chilambo cha ku Dalamanuta. ");
INSERT INTO yao_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ŵaiche Mafalisayo ŵane ni ŵagatandite makani ni Che Yesu achisakaga kwatanjisya. Ŵaasachile atende chimanyisyo kulosya kuti ukombole wao ukutyochela kwinani kwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Che Yesu ŵasupwiche nikuti, “Kwachichi ŵandu ŵa moŵa gano akusakanga chimanyisyo? Isyene ngunsalila, ŵandu ŵa ngaapegwa chimanyisyo chachilichose.” ");
INSERT INTO yao_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nipele, Che Yesu ŵalekangene nawo ŵandu ŵala, ŵajinjile mu ngalaŵa ni kombochela peesi. ");
INSERT INTO yao_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ŵakulijiganya ŵa Che Yesu ŵaliŵalile kwigala mikate, ŵakwete nkate umo pe mu ngalaŵa mula. ");
INSERT INTO yao_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Che Yesu ŵaajamwiche achitiji, “Nlilolechesye, ni kuligosa ni amila ja Mafalisayo ni ja che Helode.” ");
INSERT INTO yao_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ŵakulijiganya ŵala ŵatandite kuŵechetesyana achinsyene pe, “Akuŵecheta yelei ligongo nganitukola mikate.” ");
INSERT INTO yao_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Che Yesu ŵaimanyilile iŵaliji nkuŵechetesyana, ni ŵausisye, “Kwachichi nkuusyana yati nganinjigala mikate? Ana mpaka sambano ngankulijiganya pane kumanyilila? Kwachichi ngankuganisya? ");
INSERT INTO yao_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Meeso nkwete, ana ngankulolanga? Mapilikanilo nkwete, ana ngankupilikana? Ana ngankukumbuchila ");
INSERT INTO yao_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","panagaŵenye mikate nsano jila ni kwapa ŵandu elufu tano, mwagumbesye itundu ilingwa ya sigasi?” Ŵakulijiganya ŵajanjile, “Itundu kumi na mbili.” ");
INSERT INTO yao_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ŵausisye sooni, “Panagaŵenye mikate nsano ni jiŵili ni kwapa ŵandu elufu nne, ana mwagumbesye itundu ilingwa ya sigasi?” Ŵakulijiganya ŵala ŵajanjile, “Itundu saba.” ");
INSERT INTO yao_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Che Yesu ŵausisye, “Nganimme kumanyilila?” ");
INSERT INTO yao_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Che Yesu pamo ni ŵakulijiganya ŵao ŵaiche ku nsinda wa ku Besesaida. Kukoko ŵandu ŵampelechele mundu jwangalola, ni ŵaachondelele Che Yesu kuti ankwaye kuti anlamye. ");
INSERT INTO yao_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Che Yesu ŵankamwile nkono mundu jwangalola jo ni ŵakopweche nawo paasa nsinda. Ni ŵansunile mata mmeeso, ŵasajichile makono ni ŵambusisye, “Nkukombola kuchiona chachilichose?” ");
INSERT INTO yao_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mundu jwangalola jula ŵalolite nikuti, “Ngwaona ŵandu ali nkuoneka mpela itela ili nkwenda.” ");
INSERT INTO yao_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Che Yesu ŵasajiche sooni makono gakwe mmeeso mwa jwangalola jula, nombejo ukombole wakwe wa kulola wammujilile. ");
INSERT INTO yao_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Che Yesu ŵansalile mundu jo ajaule kumangwakwe ni kunkanya achitiji, “Nkaujila ku nsinda ni kwasalila ŵandu.” ");
INSERT INTO yao_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Che Yesu ni ŵakulijiganya ŵao ŵajawile ku misi ja Kaisalia Filipi. Paŵaliji mwitala, Che Yesu ŵausisye ŵakulijiganya ŵao, “Ana ŵandu akuti une ndili nduni?” ");
INSERT INTO yao_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ŵakulijiganya ŵala ŵajanjile, “Ŵane akuti ŵalakwe ndi che Yohana Ŵakubatisya, ŵane akuti ndi che Elia ni ŵane akuti ndi jumo jwa Ŵakulondola ŵa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Che Yesu ŵausisye ŵakulijiganya ŵao, “Ŵanyamwe nkuti uneji nduni?” Che Petulo ŵajanjile, “Ŵalakwe ndi Kilisito, Jwasagulikwe ni Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nipele Che Yesu ŵajamwiche achitiji, “Ngasimunsalila mundu jwalijose chelechi nkati une.” ");
INSERT INTO yao_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Che Yesu ŵatandite kwajiganya ŵakulijiganya ŵao achitiji, “Mwana jwa Mundu akusachilwa asauche kwannope ni kukanikwa ni achachekulu ni achakulu ŵambopesi ni ŵakwiganya Malajisyo. Nipele chachiulajikwa, nambo chasyuche pa lyuŵa lyaatatu.” ");
INSERT INTO yao_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Che Yesu ŵaasalile yelei pangasisa. Nipele che Petulo ŵanjigele Che Yesu pajika ni kutanda kwakalipila kuti anasale indu yo. ");
INSERT INTO yao_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nambo Che Yesu ŵagalawiche, ŵaalolechesye ŵakulijiganya ŵao ni kwakalipila che Petulo achitiji, “Shetani, ntyoche apa! Pakuwa ngankuganisya ngani ja Akunnungu nambo nkuganisya ngani sya ŵandu.” ");
INSERT INTO yao_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nipele ŵauŵilasile mpingo wa ŵandu pamo ni ŵakulijiganya ŵao ni kwasalila, “Mundu jwalijose jwakusaka kuunguya, akatenda yakuisaka nsyene, aŵeje chile kusauka kwa kulitwika nsalaba wakwe kwaligongo lyangu une ni kuunguya. ");
INSERT INTO yao_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pakuŵa jwalijose jwakusaka kuukulupusya umi wakwe nsyene, chaujase. Nambo, jwalijose jwakuujasa umi wakwe, kwaligongo lyangu une, ni sooni kwaligongo lya Ngani Jambone, chaukulupusye. ");
INSERT INTO yao_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ana mundu chapate chichi achikolaga chipanje chose cha pachilambo ni kwasa umi wakwe wa moŵa gose pangali mbesi? ");
INSERT INTO yao_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pane mundu chatyosye chichi kuti auusye umi wakwe wa moŵa gose pangali mbesi? ");
INSERT INTO yao_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mundu jwalijose angolelaga soni une pamo ni ngani jangu mu uŵelesi wu wangalumbana ni wangaajogopa Akunnungu, Mwana jwa Mundu chankolele soni mundu jo, katema kachaiche mu ukulu wa Atati ŵakwe, pamo ni achikatumetume ŵa kwinani ŵaswela.” ");
INSERT INTO yao_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Che Yesu ŵapundile kwasalila, “Isyene ngunsalila, apali ŵandu ŵane papapa chiŵaone Akunnungu achitawalaga ni machili kwa matala gakupisyangana akanaŵe kuwa.” ");
INSERT INTO yao_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagapite moŵa nsano ni limo, Che Yesu ŵaajigele che Petulo ni che Yakobo ni Che Yohana, ŵalongene nawo pa chitumbi cheleu pajikape. Kweleko ku meeso ku Che Yesu kwagalawiche paujo pao. ");
INSERT INTO yao_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Iwalo yakwe yaliji yeswela mbee yanti mundu jwalijose jwa pachilambo pano ngakupakombola kuswejesya chanti yeleyo. ");
INSERT INTO yao_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nipele, che Elia ni che Musa ŵakopochele paujo pao ni ŵaliji nkukunguluka ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Che Petulo ŵasalile Che Yesu achitiji, “Jwakwiganya, ikaliji yambone kuti uwe tutame panopano. Tutaŵe masakasa gatatu, limo lyenu ni limo li che Musa ni liine li che Elia.” ");
INSERT INTO yao_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Che Petulo nganachimanya chakuŵecheta pakuŵa wose ŵajogwepe kwannope. ");
INSERT INTO yao_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nipele, lyakopochele liunde ni kwaunichila, liloŵe lyakopochele mu liunde lichitiji, “Aju ni Mwanangu jungunnonyela, mumpilikanile jwelejo.” ");
INSERT INTO yao_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Papopo ŵakulijiganya ŵalolite akuno ni akunokuno, nambo nganambona mundu jwine ikaŵe Che Yesu pe. ");
INSERT INTO yao_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Paŵatulukaga pa chitumbi, Che Yesu ŵakanyisye ŵanyawo kuti yele iŵaiweni akansalila mundu jwalijose mpaka Mwana jwa Mundu pachachisyuka. ");
INSERT INTO yao_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nipele, ŵakulijiganya ŵagakamulichisye maloŵe go, nambo ŵaliji nkuusyana achinsyene pe, “Kusyuka malumbo gakwe chichi?” ");
INSERT INTO yao_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nipele, ŵausisye Che Yesu, “Ana kwachichi ŵakwiganya Malajisyo akusala kuti, chaiche kaje Che Elia?” ");
INSERT INTO yao_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Che Yesu ŵajanjile, “Elo, che Elia chaiche kaje kukuŵika chile indu yose. Nambi kwachichi ilembekwe Mmalembelo ga Akunnungu kuti, Mwana jwa Mundu chasauche kwannope ni kukanikwa? ");
INSERT INTO yao_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nambo une ngunsalila, che Elia ŵamasile kwika ni ŵandu ŵampanganyichisye chachilichose chiŵasachile, mpela Malembelo ga Akunnungu yagakuti kusala nkati ŵelewo.” ");
INSERT INTO yao_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Che Yesu ni aŵala ŵakulijiganya ŵatatu paŵaaichilile ŵakulijiganya ŵane ŵala, ŵaweni ŵandu ŵajinji ali ŵasyungwile achikanilanaga ni ŵakwiganya Malajisyo. ");
INSERT INTO yao_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Papopo, ŵandu wose paŵambweni Che Yesu, ŵasimosile kwannope, ŵautuchile kukwakomasya. ");
INSERT INTO yao_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Che Yesu ŵausisye ŵakulijiganya ŵao, “Ana nkukanilana nawo ichichi?” ");
INSERT INTO yao_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mundu jumo mu mpingo wa ŵandu mula ŵajanjile, “Jwakwiganya, nannyichenawo mwanangu kukwenu jwakamwilwe ni lisoka lyalikuntendekasya anakombole kuŵecheta. ");
INSERT INTO yao_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Katema kose lisoka palikunjinjila, likungwisya paasi ni likuntendekasya mwanache jo chikopoche chiulo nkang'wa, achichilimyaga meeno ni kukakamala chiilu. Naaŵendile ŵakulijiganya ŵenu alikoposye, nambo ŵalepele.” ");
INSERT INTO yao_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nipele, Che Yesu ŵaasalile ŵakulijiganya ŵao, “Mwanya uŵelesi wangali chikulupi! Ana chindame ni ŵanyamwe mpaka chakachi? Chinampililile mpaka chakachi? Munyichisye mwanache jo.” ");
INSERT INTO yao_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ŵannyichisye ku Che Yesu. Lisoka palyambweni Che Yesu, papopo lyantasile njilinjili jwanchanda jo, nombe ŵagwile paasi, ŵagalagete akuno alinkukopoka chiulo kukang'wa. ");
INSERT INTO yao_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Che Yesu ŵammusisye atatigwe jwanchanda jo, “Jwanchanda ju yatandite chakachi yelei?” Ŵajanjile, “Chitandile wanache wakwe. ");
INSERT INTO yao_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Katema kakajinji lisoka lyo lyangwisyaga pa mooto ni mmeesi kuti lyaulaje. Nambo iŵaga nkukombola kutendekanya chachilichose, ntukolele chanasa ni kutukamusya!” ");
INSERT INTO yao_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Che Yesu ŵansalile, “Kwachichi nkuti, ‘Iŵaga ngukombola’? Yose ikukomboleka kwa mundu jwakukulupilila.” ");
INSERT INTO yao_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Papopo atatigwe jwanchanda jo ŵanyanyisye, “Ngukulupilila! Nambo chikulupi changu chili chamwana, mungamuchisye ngole chikulupi chachikulungwa.” ");
INSERT INTO yao_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Che Yesu paŵaweni kuti ŵandu ŵajinji ali nkusongangana paujo pao, walijamwiche lisoka lila ni kulisalila, “Mmwe lisoka linkulekasya kuŵecheta ni kupilikana, ngunlamula nkopoche mwa jwanchanda ju, ni nkajinjila sooni.” ");
INSERT INTO yao_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pelepo lisoka lyanyanyisye, lyangwisisye njilinjili jwanchanda jo ni lyankopweche. Jwanchanda jwaoneche mpela jwammwe, ni ŵandu ŵane ŵatite “Awile!” ");
INSERT INTO yao_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nambo Che Yesu ŵankamwile nkono jwanchanda jo, ŵankamwisye ajimuche, nombejo ŵajimi. ");
INSERT INTO yao_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Che Yesu paŵajinjile mu nyuumba, ŵakulijiganya ŵao ŵausisye pajika, “Kwachichi twalepele kulikoposya lisoka lyo?” ");
INSERT INTO yao_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Che Yesu ŵajanjile, “Lisoka lyanti yelei ngalikukopoka kwa litala lyalililyose ikaŵe kwa kwapopelela Akunnungu pe.” ");
INSERT INTO yao_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Che Yesu ni ŵakulijiganya ŵao ŵatyosile peuto pala, ni ŵajendelechele ni ulendo kupitila ku chilambo cha ku Galilaya. Nganasaka mundu jwalijose akumanye kuŵaliji, ");
INSERT INTO yao_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","pakuŵa ŵaliji nkwajiganya ŵakulijiganya ŵao, ŵasalile, “Mwana jwa Mundu chaŵichikwe mmakono mwa ŵandu, nombewo chammbulaje. Nambo pa lyuŵa lyaatatu chiulajikwa pe chasyuche.” ");
INSERT INTO yao_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nambo ŵakulijiganya ŵao nganagamanyililaga malumbo ga maloŵe go, ni ŵajogwepe kumbusya. ");
INSERT INTO yao_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Paŵaiche musi wa ku Kapelenaumu ŵajinjile mu nyuumba, nombe Che Yesu ŵausisye ŵakulijiganya ŵao, “Ana mwitala mula mwakanilanaga ichichi?” ");
INSERT INTO yao_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nambo ŵanyawo ŵamyalele, pakuŵa paŵaliji mwitala mula, ŵaliji nkukanilana yankati nduni jwali jwankulungwa mwa ŵanyawo. ");
INSERT INTO yao_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Che Yesu ŵatemi paasi, ni ŵaaŵilasile ŵakulijiganya ŵao likumi ni ŵaŵili ŵaasalile, “Mundu jwakusaka kuŵa jwankulu akusachilwa alitulusye ni kuŵa jwannandi ni katumetume jwa wose.” ");
INSERT INTO yao_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sooni ŵanjigele mwanache ni kunjimika pasikati jao, ŵanjangete ni kwasalila, ");
INSERT INTO yao_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Jwalijose jwakumpochela mwanache mpela aju mu liina lyangu, akuumbochela une, ni mundu jwakuumbochela une akwapochela ŵelewo ŵandumile une.” ");
INSERT INTO yao_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Che Yohana ŵaasalile Che Yesu, “Jwakwiganya, twammweni mundu ali nkugakoposya masoka mu liina lyenu, ni twankanyisye ligongo nganaŵa njetu.” ");
INSERT INTO yao_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nambo Che Yesu ŵatite, “Kasimunkanya, pakuŵa ngapagwa mundu jwakupanganya yakusimonjeka kwa liina lyangu ni papopo kumechetela gangalumbana. ");
INSERT INTO yao_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ligongo mundu jwalijose jwangakutukanila ali pamo ni uwe. ");
INSERT INTO yao_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Isyene ngunsalila, mundu jwalijose jwakumpa ngao wa meesi ga kung'wa, ligongo mwanya ndi ŵandu ŵakwe Kilisito, isyene jwelejo chapochele mbote jakwe. ");
INSERT INTO yao_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mundu jwalijose juchantendekasye jumo jwa achanandi ŵa ŵakungulupilila une atende sambi, ikaliji yambone kwa jwelejo litaŵikwe liganga lyekulungwa lya kusyajila pa lukosi pao ni kwaponya mu bahali kupunda kulamulikwa ni Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Iŵaga nkono wenu ukunneŵasya, mmukate! Mmbaya kwinjila mu umi ni nkono umo, kupunda kuŵa ni makono gaŵili ni kuponyekwa pa mooto wangasimika, moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kweleko mbisu ngasikuwa ni mooto wakwe ngaukusima. ");
INSERT INTO yao_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ni iŵaga lukongolo lwenu lukunneŵasya, mmukate! Mmbaya kwinjila mu umi ni lukongolo lumo kupunda kuŵa ni makongolo gaŵili ni kuponyekwa ku jehanamu pa mooto wangasimika, moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kweleko mbisu ngasikuwa ni mooto wakwe ngaukusima. ");
INSERT INTO yao_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Iyoyo peyo iŵaga liso lyenu likunneŵasya, nlikolopole! Mbaya kwinjila ku umwenye wa Akunnungu ni liso limo kupunda kuŵa ni meeso gaŵili ni kuponyekwa pa mooto wangasimika, moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kweleko mbisu ngasikuwa ni mooto wakwe ngaukusima. ");
INSERT INTO yao_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Pakuŵa jwalijose chaachiswejeswa ni mooto mpela mbopesi ijikuti pakuswejeswa ni njete. ");
INSERT INTO yao_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Njete jili jambone, nambo njete jasoyesyaga kulasa kwakwe, chintaje chichi kuti unonye wakwe uujile sooni? “Nkolanje njete ja uganja pasikati jenu, ntamanje mu chitendewele.” ");
INSERT INTO yao_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Che Yesu ŵatyosile pelepo, ŵajawile kuchilambo cha ku Yudea mpaka peesi lusulo lwa Yolodani. Mpingo wa ŵandu ŵajinji waajaulile sooni, nombejo ŵajiganyisye mpela iŵatite pakusyoŵelela. ");
INSERT INTO yao_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nipele, Mafalisayo ŵane ŵajaulile ni kwalinga kwa kwawusya, “Ana Malajisyo ga Akunnungu gakukunda kuti jwannume kwaleka ŵankwakwe?” ");
INSERT INTO yao_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Che Yesu ŵajanjile, “Ana che Musa ŵannajisye chichi?” ");
INSERT INTO yao_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ŵanyawo ŵajanjile, “Che Musa ŵalajisye kuti, jwannume akukombola kumpa talaka ŵankwakwe ni kwaleka.” ");
INSERT INTO yao_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Che Yesu ŵaasalile, “Che Musa ŵagalembile malajisyo go kwaligongo lya ungajiganyikwa wenu. ");
INSERT INTO yao_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nambo che Musa ŵalembile, chitandile kupagwa kwa chilambo, Akunnungu ŵangumbile jwannume ni jwankongwe. ");
INSERT INTO yao_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kwa ligongo lyo jwannume chachinleka atatigwe ni achikulugwe, nombejo chalumbikane ni ŵankwakwe, ");
INSERT INTO yao_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ni ŵaŵili wo chachiŵa chiilu chimo. Sambano ngakuŵa ŵaŵili sooni, nambo chiilu chimo. ");
INSERT INTO yao_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nipele, chalumbikenye Akunnungu, mundu ngasachilekanganya.” ");
INSERT INTO yao_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Paŵausile sooni mu nyuumba, ŵakulijiganya ŵaausisye Che Yesu nkati majiganyo go. ");
INSERT INTO yao_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nombewo ŵaasalile, “Mundu jwalijose jwakunleka ŵankwakwe ni kulombela jwankongwe jwine, akuntendela chikululu ŵankwakwe. ");
INSERT INTO yao_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Iyoyo, jwankongwe jwakunleka jwannume jwao ni kulombwa ni jwannume jwine, akuntendela chikululu jwannume jwao.” ");
INSERT INTO yao_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ŵandu ŵampepe ŵannyichisye Che Yesu ŵanache achanandi ŵasajichile makono gao, nambo ŵakulijiganya ŵao ŵaakalipile ŵandu wo. ");
INSERT INTO yao_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Che Yesu paŵaiweni yeleyo, yachimile ni ŵaasalile, “Mwaleche ŵanache achanandi aichanje kukwangu, kasimwalekasya, pakuŵa Umwenye wa Akunnungu uli wa ŵandu mpela ŵeleŵa. ");
INSERT INTO yao_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Isyene ngunsalila, mundu jwalijose jwangakuupochela Umwenye wa Akunnungu mpela ŵanache achanandi ngaajinjila mwelemo ng'oo.” ");
INSERT INTO yao_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nipele, ŵajangete ŵanache ni kwasajichila makono ni kwapa upile. ");
INSERT INTO yao_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Che Yesu paŵatandite sooni ulendo wao, mundu jumo ŵambutuchile ni kwatindiŵalila ni ŵausisye, “Jwakwiganya jwambone, ana ndende chichi pakuti mbochele umi wa moŵa gose pangali mbesi?” ");
INSERT INTO yao_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Che Yesu ŵajanjile, “Ana ligongo chi nkuumilanga jwambone? Ngapagwa mundu jwaali jwambone ikaŵe Akunnungu jika pe. ");
INSERT INTO yao_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ntakugamanyilila makanyo gagakuti, ‘Kasimmulaga ni Kasintenda chikululu ni Kasinjiŵa ni Kasinsala ya unami ni Kasimunnambuchisya njenu, ni Mwachimbichisye atati ŵenu ni achikulu ŵenu.’ ” ");
INSERT INTO yao_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mundu jula ŵajanjile, “Jwakwiganya, makanyo gose go nagakamulichisye chitandilile ku uwanache wangu.” ");
INSERT INTO yao_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Che Yesu ŵalolechesye kwa kwanonyela, ŵansalile, “Chinsoŵile chindu chimo. Njaule nkasumisye yose inkwete, ni mbiya syo nkaape ŵakulaga, nombe mmwe chinkole chipanje kwinani kwa Akunnungu. Nipele nnyiche munguye.” ");
INSERT INTO yao_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mundu jo paŵapilikene yeleyo, ŵapwele ntima ni ŵajawile achipukunyaga ntwe, pakuŵa ŵaliji ni ipanje yejinji ni nganasaka kwapa ŵane ipanje yao. ");
INSERT INTO yao_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nipele Che Yesu ŵalolite kosekose, ni ŵaasalile ŵakulijiganya ŵao, “Chiilimbe kwannope kwa ŵandu ŵaipanje kwalechelela Akunnungu ŵaatawale!” ");
INSERT INTO yao_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ŵakulijiganya ŵagasimosile maloŵe gao, nambo Che Yesu ŵaasalile sooni, “Achiŵanangu, chiilimbe kwannope kwa ŵandu kwalechelela Akunnungu ŵaatawale! ");
INSERT INTO yao_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chiiŵe yakulimba kuchitenda chinyama chachikuŵilanjikwa ngamia, kupeleta pa chipowo cha sindano. Iyoyo peyo, ikuloleka kuti, chiiŵe yakulimba kwannope kwa mundu jwachipanje kwalechela Akunnungu ŵaatawale!” ");
INSERT INTO yao_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ŵakulijiganya ŵao ŵasimosile nnope, ŵaliusisye, “Ana sambano nduni juchakombole kulupuswa?” ");
INSERT INTO yao_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Che Yesu ŵalolechesye ni kwasalila, “Kwa ŵandu ngaikukomboleka, nambo ngaŵa yeleyo kwa Akunnungu, pakuŵa kwa Akunnungu yanayose ikukomboleka.” ");
INSERT INTO yao_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Che Petulo ŵansalile Che Yesu, “Nnole! Ni uweji tulesile indu yose ni kunkuya mmwe!” ");
INSERT INTO yao_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Che Yesu ŵatite, “Isyene ngunsalila, mundu jwalijose jwajilesile nyuumba jakwe pane achapwakwe pane achalumbugwe pane achikulugwe pane atatigwe pane achiŵanagwe pane migunda, kwa ligongo lyangu une ni kwa ligongo lya Ngani Jambone, ");
INSERT INTO yao_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mundu jo chapochele mbwee katema kakaka. Chapochele nyuumba syasijinji ni achalongo ni achalumbu ni achaŵelesi ni ŵanache ni migunda pamo ni masauko. Nambo mchilambo chachikwika, chapochele umi wa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nambo achajinji ŵakuliganichisya kuti ali achakulu sambano, chatuluswe ni ŵandu ŵakulitulusya sambano, chachiŵa achakulu.” ");
INSERT INTO yao_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Che Yesu ni ŵakulijiganya ŵao ŵaliji nkukwesya kwaula ku Yelusalemu nombe Che Yesu ŵalongolele. Ŵakulijiganya ŵao ŵasimosile, ni ŵandu ŵaŵaliji nkwakuya wose ŵajogwepe. Che Yesu ŵaajigele sooni ŵakulijiganya ŵao likumi ni ŵaŵili pachisyepela, ni kwasalila indu ichiyakopochele. ");
INSERT INTO yao_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ŵaasalile, “Mpilikane, tukukwesya kwaula ku Yelusalemu, ni kweleko Mwana jwa Mundu chajaule kukutyosyekwa kwa achakulu ŵambopesi ni ŵakwiganya Malajisyo. Ni ŵanyawo chanlamulile chiwa ni kwataga mmakono ga ŵandu ŵangaŵa Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nombe chaachintendela chanache ni chaachinsunila mata ni chaachimputa mbokola ni kumbulaga. Nambo pa lyuŵa lyaatatu chasyuche.” ");
INSERT INTO yao_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nipele che Yakobo ni che Yohana ŵanache ŵa che Sebedayo, ŵajawile ku Che Yesu ni ŵatite, “Jwakwiganya, tukusaka ntupanganyichisye chindu chachitummende.” ");
INSERT INTO yao_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Che Yesu ŵausisye, “Ana nkusaka nampanganyichisye chichi?” ");
INSERT INTO yao_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ni ŵajanjile, “Pachintawale mu ukulu wenu, tukummenda tutame jumo kundyo ni jwine kunchiji kwenu.” ");
INSERT INTO yao_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nambo Che Yesu ŵaasalile, “Ngankuchimanyilila chinkuchiŵenda! Uli chinkombole kuching'welela chikombe cha masauko chingung'welela une pane kubatiswa mu ubatiso ungubatiswa une?” ");
INSERT INTO yao_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ŵajanjile, “Tukupakombola.” Che Yesu ŵaasalile, “Isyene chinng'welele chikombe chingung'welela une ni kubatiswa ubatiso ungubatiswa une. ");
INSERT INTO yao_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ni kwa aŵala ŵachatame kundyo pane kunchiji kwangu, ngaŵa masengo gangu. Nambo Akunnungu chachapa lipesa lyo ŵele ŵaŵaasagwile.” ");
INSERT INTO yao_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ŵele ŵakulijiganya likumi paŵapilikene chechila chiŵaŵendile che Yakobo ni che Yohana, ŵaatumbilile. ");
INSERT INTO yao_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nipele, Che Yesu ŵaaŵilasile ŵakulijiganya wo ni ŵaasalile, “Nkumanyilila kuti ŵandu ŵakuganichikwa ali ilongola wa ŵandu ŵangaŵa Ŵayahudi, akwalongosya ŵandu ŵao kwa machili. Ni ŵele ilongola wo akwete ulamusi waukulungwa pachanya ŵandu ŵao. ");
INSERT INTO yao_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nambo ikaaŵa yeleyo kwa ŵanyamwe, sooni jwalijose jwakusaka kuŵa jwankulu pasikati jenu, aŵeje katumetume jwa wose. ");
INSERT INTO yao_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nombe jwalijose jwakusaka kuŵa jwankulu kupunda wose aŵeje kapolo jwa wose. ");
INSERT INTO yao_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pakuŵa Mwana jwa Mundu nganaika kukutumichilwa, nambo aiche kukutumichila ni kuutyosya umi wao kwa kwawombola ŵandu ŵajinji.” ");
INSERT INTO yao_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nipele, ŵaiche ku Yeliko. Che Yesu ni ŵakulijiganya ŵao pamo ni mpingo wekulungwa wa ŵandu paŵaliji nkutyoka mu musi wo, mundu jumo juŵaliji ngakulola, liina lyakwe che Batimayo mwanagwe che Timayo, ŵatemi mungulugulu litala achiŵendaga. ");
INSERT INTO yao_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Paŵapilikene kuti ali Che Yesu jwa ku Nasaleti ŵaliji nkupita pelepo, ŵatandite kunyanyisya achitiji, “Che Yesu, Mwana ju che Daudi, mungolele chanasa!” ");
INSERT INTO yao_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ŵandu ŵajinji ŵankalipile kuti amyalale, nambo jwelejo ŵajendelechele kunyanyisya achitiji, “Mwana ju che Daudi, mungolele chanasa!” ");
INSERT INTO yao_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Che Yesu ŵajimi ni ŵatite, “Mwaŵilanje.” Nipele, ŵammilasile mundu jwangalola jula, ŵansalile, “Nkamulisye ntima! Njimuche, akummilanga.” ");
INSERT INTO yao_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nombejo ŵaponyisye kwakutalichila mwinjilo wakwe, ŵagulwiche, ni ŵajaulile Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Che Yesu ŵammusisye jwelejo, “Nkusaka nampanganyichisye ichichi?” Jwangalola jo ŵanjanjile, “Jwakwiganya, ngusaka mbate kulola.” ");
INSERT INTO yao_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Che Yesu ŵansalile, “Njaule chikulupi chenu chinnamisye.” Papopo mundu jo ŵatandite kulola, nipele ŵalongene nawo Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Paŵaliji nkuŵandichila ku Yelusalemu, ŵaiche mmisinda ja ku Besefage ni ku Besania, chiŵandi ni Chikwesya cha Miseituni. Pelepo Che Yesu ŵaatumile ŵakulijiganya ŵao ŵaŵili. ");
INSERT INTO yao_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ni ŵaasalile, “Njaule pansinda wauli mmbujo mwenu, pachinkajinjileje po chinkansimane mwanambunda jwanganakwelekwe ni mundu kose, ali ataŵikwe, nkangopole ni kunnyika nawo apano. ");
INSERT INTO yao_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ambusyaga mundu, ‘Ligongo chi nkutenda yeleyo?’ Mwasalile, ‘Ambuje akunsaka, ni chaachimmusya mwachitema pe.’ ” ");
INSERT INTO yao_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nipele, ŵakulijiganya wo ŵajawile ni kunsimana mwanambunda ali ataŵikwe pachiŵandi ni nnango, muumbali mwa litala. Paŵangopolaga, ");
INSERT INTO yao_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ŵandu ŵampepe ŵaŵajimi pelepo ŵausisye, “Uli, mbona nkungopola mwanambunda jo?” ");
INSERT INTO yao_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ŵakulijiganya ŵajanjile mpela iŵatite pakusalilwa ni Che Yesu, ni ŵandu ŵala ŵaalesile ajaule najo. ");
INSERT INTO yao_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ŵampelechele Che Yesu mwanambunda jula. Ŵatandiche iwalo yao pangongo wa mwanambunda jula, ni Che Yesu ŵatemi pachanya pakwe. ");
INSERT INTO yao_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ŵandu ŵajinji ŵatandiche iwalo yao mwitala, ni ŵane ŵatemenye nyambi sya mwana sya itela mmigunda ni kutandika mwitala kwa kwachimbichisya. ");
INSERT INTO yao_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nipele ŵandu ŵaŵalongolele ni ŵane ŵaŵakuyaga panyuma ŵanyanyisye achitiji, “Alapikwe Akunnungu! Akunnungu ampe upile jwelejo jwakwika mu liina lya Ambuje! ");
INSERT INTO yao_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Akunnungu aupe upile umwenye waukwika wa atati ŵetu Mwenye che Daudi. Ajinichilwe Akumanani!” ");
INSERT INTO yao_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Che Yesu wajinjile mmusi wa ku Yelusalemu, ni ŵapelengenye pa Nyuumba ja Akunnungu, ni ŵalolesyelolesye. Nambo pakuŵa jaliji ligulo, ŵajawile kunsinda wa ku Besania pamo ni ŵakulijiganya ŵao likumi ni ŵaŵili. ");
INSERT INTO yao_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Malaŵi jakwe, paŵatyochelaga ku Besania, Che Yesu jakwete sala. ");
INSERT INTO yao_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nipele, ali kwakutalichila ŵachiweni chitela cha ntini chana masamba gamajinji. Ŵajawile kukuchilola, alole iŵaga chakombole kupata chisogosi chachili chose. Paŵaiche pachitela pala ŵachisimene masamba pe pangali chisogosi, ligongo nganikaŵa katema kakwe ka kusogola. ");
INSERT INTO yao_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pelepo Che Yesu ŵachisalile chitela chila, “Chitandile sambano ni kuendelechela, ngapagwa mundu juchalye sooni isogosi yenu!” Ni ŵakulijiganya ŵao ŵampilikene paŵaŵechete gelego. ");
INSERT INTO yao_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nipele paŵaiche ku Yelusalemu, Che Yesu ŵajinjile pa Nyuumba ja Akunnungu. Ni ŵatandite kwatopolela paasa, ŵandu ŵaŵaliji nkusumisya ni kusuma indu mwelemo. Ŵapikwile mesa sya ŵakutindanya mbiya ni itengu ya ŵandu ŵaŵasumisyaga nguunda. ");
INSERT INTO yao_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Iyoyo, ŵakanyisye mundu jwalijose akajigala chachili chose kutyochela pa Nyuumba ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nipele, ŵajiganyisye, “Mmalembelo ga Akunnungu, Akunnungu akuti, ‘Nyuumba jangu chijiŵilanjikwe nyuumba ja kupopelela kwa ŵandu wose ŵa pachilambo!’ Nambo ŵanyamwe njitesile jiŵe mbugu ja kulisisila ŵa wiyi!” ");
INSERT INTO yao_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Achakulu ŵambopesi ni ŵakwiganya Malajisyo paŵapilikene yelei, ŵatandite kusosa litala lya kwaulaga Che Yesu. Nambo ŵanjogwepe, ligongo ŵandu ŵajinji ŵaliji nkusimonga wiganye wakwe. ");
INSERT INTO yao_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pakwaswele, Che Yesu ni ŵakulijiganya ŵao ŵakopweche musi wo. ");
INSERT INTO yao_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kundaŵi jakwe, paŵapitaga ŵachiweni chitela cha ntini chila chili chijumwile koo, kutandilila mmichiga mpaka ku nyambi. ");
INSERT INTO yao_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Che Petulo ŵagakumbuchile agala gaŵaŵechete Che Yesu, ni ŵansalile, “Jwakwiganya, nnole! Chitela cha ntini chimwalwesisye chila chijumwile!” ");
INSERT INTO yao_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Che Yesu ŵaasalile, “Mwakulupilile Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Isyene ngunsalila, mundu achichisalilaga chitumbi chi, ‘Ntupuche nkaliponye mbahali,’ pangakola lipamba mu ntima mwakwe ni akulupililaga kuti chaŵechete cho chichitendekwe, chichitendekwe kukwakwe. ");
INSERT INTO yao_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kwa ligongo lyo ngunsalila, pankupopela ni kuŵenda chindu, nkulupilile kuti nkuchipochela, nombecho chichiŵe chenu. ");
INSERT INTO yao_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pankupopela, iŵaga kwana mundu jwanneŵele, mwalechelesye yangalumbana yantendele, kuti Atati ŵenu ŵa kwinani annechelesye sambi syenu. ");
INSERT INTO yao_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nambo iŵaga ngumwalechelesya ŵane sambi syao, Atati ŵenu ŵa kwinani nombe ngannechelesya sambi syenu.” ");
INSERT INTO yao_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nipele ŵaiche sooni ku Yelusalemu. Che Yesu paŵaliji nkwendajenda pa Nyuumba ja Akunnungu, achakulu ŵambopesi ni ŵakwiganya Malajisyo ni achachekulu ŵajaulile, ");
INSERT INTO yao_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ni ŵausisye, “Ana nkugatendekanya gelega kwa ulamusi wa acheni? Ŵaani ŵampele ulamusi wa kuitendekanya yeleyi?” ");
INSERT INTO yao_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Che Yesu ŵajanjile, “None chinambusye liusyo limo. Iŵaga chimunyanje none chinansalile kwa ulamusi wa acheni nguitenda indu yi. ");
INSERT INTO yao_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Musalile, ubatiso u che Yohana waumile kwinani, pane kwa ŵandu?” ");
INSERT INTO yao_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ŵanyawo ŵatandite kuusyana jwine ni jwine achitiji, “Twajilaga, ‘Waumile kwinani’, chatuusye, ‘Kwachichi nganimwakulupilila che Yohana?’ ");
INSERT INTO yao_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ni twatiji, ‘Waumile kwa ŵandu,’ chiiŵe uli?” Ŵaujogwepe mpingo wa ŵandu, pakuŵa ŵandu wose ŵakulupilile kuti che Yohana ŵaliji jwakulondola jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nipele, ŵanjanjile Che Yesu, “Ngatukumanyilila.” Nombejo ŵaasalile, “None jwakwe ngangunsalila kwa ulamusi wa acheni nguitendekanya yeleyi.” ");
INSERT INTO yao_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Che Yesu ŵatandite kuŵecheta nawo kwa itagu achitiji, “Mundu jumo ŵalimile ngunda wa misabibu. Ŵausunguchisye lutenje ni ŵasolite pakuminyila sabibu, ni ŵataŵile chilindo cha penani. Nipele ŵaajasimisye ŵandu ngunda wo, nombejo ŵajawile kuchilambo chine. ");
INSERT INTO yao_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Katema ka magungulo, ŵantumile kapolo jwao ku ngunda wa misabibu kwa ŵakulima ŵala kukujigala chigaŵanyo cha magowolo gao. ");
INSERT INTO yao_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ŵakulima ŵala ŵankamwile kapolo jo, ŵamputile ni kumminga makono pe. ");
INSERT INTO yao_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nipele nsyene ngunda jula, ŵantumile sooni kapolo jwine. Ŵakulima ŵala ŵammulesye mu ntwe kapolo jo ni kumpanganyichisya indu ya soni. ");
INSERT INTO yao_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Iyoyo peyo, nsyene ngunda jo ŵantumile sooni kapolo jwine, jwelejo ŵagambile kumbulaga. Ni ŵane ŵajinji uŵatumikwe, ŵane ŵaputikwe ni ŵane ŵaulajikwe.” ");
INSERT INTO yao_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Che Yesu ŵajendelechele kuŵecheta, “Mundu jula ŵasigalilwe ni mundu jumo, mwanagwe jwakunonyelwa. Mbesi jakwe ŵantumile jwelejo achitiji, ‘Champikanile pakuŵa ali mwanangu.’ ");
INSERT INTO yao_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nambo ŵakulima ŵala paŵammweni ŵaŵechetesyene achitiji, ‘Aju ni juchapochele iŵagosele, twende tummulaje kuti indu iŵagosele tujigale uwe!’ ");
INSERT INTO yao_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nipele ŵankamwile ni kummulaga ni kumponyela paasa pa ngunda wa misabibu wo.” ");
INSERT INTO yao_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Che Yesu ŵausisye, “Nipele, ana nsyene ngunda wo chaachitenda chichi? Chaiche ni kwaulaga ŵakulima wo ni kwapa ŵakulima ŵane ngunda wa misabibu wo. ");
INSERT INTO yao_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ana nganinsyome Mmalembelo ga Akunnungu? ‘Liganga liŵalikanile ŵakutaŵa sambano, lilyolyo litendekwe liganga lyekulungwa lya nsingi. ");
INSERT INTO yao_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ambuje ni ŵachitesile chindu chi, nombecho chikutusimosya!’ ” ");
INSERT INTO yao_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Achakulu ŵambopesi ni ŵakwiganya Malajisyo ni achachekulu, ŵaimanyi kuti chitagu cho chaliji nkwagamba ŵanyawo. Ŵasachile ŵakamule Che Yesu, nambo ŵajogwepe ŵandu, ŵannesile, ni ŵanyawo ŵatyosile. ");
INSERT INTO yao_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kanyuma, Mafalisayo ŵampepe ni ŵandu ŵa mpingo u che Helode, ŵatumikwe kuti akaatanjisye Che Yesu kwa maloŵe gao. ");
INSERT INTO yao_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ŵaajaulile ni kwasalila, “Jwakwiganya, tukumanyilila kuti alakwe ni mundu junkuŵecheta yaili isyene, pakuŵa ngankogopa ukulu wa mundu namose nganinkola lusagu, nambo nkwiganya usyene wa litala lya Akunnungu. Ntusalile, ana ili yambone pane ngaŵa yambone kwausya nsongo kwa Mwenye jwa ku Loma? Tujaule tukalipe pane tunajaule?” ");
INSERT INTO yao_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nambo Che Yesu ŵaumayilile ulamba wao, ŵausisye, “Kwachichi nkuuninga? Muunyichisye mbiya najilole.” ");
INSERT INTO yao_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ŵampelechele mbiya jo. Nombejo ŵausisye, “Ana ku meeso ku ni liina li, ya acheni?” Ni ŵanyawo ŵanjanjile, “Ya Mwenye jwa ku Loma.” ");
INSERT INTO yao_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nipele Che Yesu ŵaasalile, “Yaili ya Mwenye jwa ku Loma mwapeje Mwenye jwa ku Loma ni yaili ya Akunnungu mwapeje Akunnungu.” Ŵandu ŵala ŵansimosile nnope Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nipele Masadukayo ŵakuti ngapagwa kusyuka ŵanjaulile Che Yesu ni kummusya, ");
INSERT INTO yao_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Jwakwiganya, che Musa ŵatulembele kuti, ‘Mundu awililwagwa ni mpwakwe ni mundu jwawile jo annekaga ŵankwakwe pangali ŵanache, mpwakwe mundu jo akusachilwa annombele jwakuwililwa jo kuti ammelechele mpwakwe ŵanache.’ ");
INSERT INTO yao_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tujileje, ŵapali achachanda nsano ni ŵaŵili, jwa kwitiwo ŵalombele nambo ŵawile pangaleka mwanache. ");
INSERT INTO yao_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ni jwaaŵili ŵajinjile majuumba, nombejo ŵawile pangaleka mwanache. Yakopochele iyoyo ni kwa mpwakwe jwaatatu. ");
INSERT INTO yao_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Wose nsano ni ŵaŵili wo, ŵawile pangaleka ŵanache. Mbesi jakwe jwankongwe jo ŵawile nombejo. ");
INSERT INTO yao_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nipele, pa lyuŵa lya kusyuka kwa ŵandu, jwankongwe jo chachiŵa jwa ŵaani? Pakuŵa achalongo wose nsano ni ŵaŵili ŵala ŵannombele jwelejo.” ");
INSERT INTO yao_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Che Yesu ŵaasalile, “Ŵanyamwe nsochele, ligongo ngankugamanyilila Malembelo ga Akunnungu namose machili ga Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ŵandu ŵawile pachachisyuka, ngasalombela atamuno kulombwa, chachiŵa mpela achikatumetume ŵa kwinani. ");
INSERT INTO yao_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nambo ngani jankati kusyuka kwa ŵandu ŵawile, ana nganinsyome mmalembo ga che Musa, ngani ja chisukutu chichakolelaga mooto? Akunnungu ŵansalile che Musa, ‘Une ndili Akunnungu ŵa che Iblahimu ni Akunnungu ŵa che Isaka ni Akunnungu ŵa che Yakobo.’ ");
INSERT INTO yao_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nipele, ŵelewo nganaŵa Akunnungu ŵa ŵandu ŵawile, nambo ali Akunnungu ŵa ŵandu ŵajumi. Ŵanyamwe nsochele nnope.” ");
INSERT INTO yao_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jumo jwa ŵakwiganya Malajisyo ŵaiche pelepo ni ŵagapilikene makani gao. Paŵaiweni kuti Che Yesu ŵaajanjile uchenene Masadukayo ŵala, ŵansejelele Che Yesu ni kumbusya, “Ana Lilajisyo chi lyalili lyekulu kupunda gose?” ");
INSERT INTO yao_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Che Yesu ŵajanjile, “Lilajisyo lyalili lyekulu ni ali: ‘Mpilikane, ŵanyamwe ŵandu ŵa ku Isilaeli! Ambuje Akunnungu ŵetu, jika pe ali Ambuje. ");
INSERT INTO yao_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mwanonyele Ambuje Akunnungu ŵenu kwa ntima wenu wose ni kwa umi wenu wose ni kwa lunda lwenu wose ni kwa machili genu gose.’ ");
INSERT INTO yao_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lilajisyo lyaaŵili lyalili lyekulu lili ali: ‘Munnonyele njenu mpela inkuti pakulinonyela mwasyene.’ Ngapagwa Lilajisyo liine lyalili lyekulu kupunda Malajisyo gaŵili ga.” ");
INSERT INTO yao_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nipele, jwakwiganya Malajisyo jula ŵansalile Che Yesu, “Jwakwiganya, njanjile yambone! Isyene Akunnungu ali ŵamo pe, ni ngapagwa jwine nambo ŵelewo jika pe. ");
INSERT INTO yao_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ni mundu akusachilwa annonyele Akunnungu ni ntima wose ni lunda lwao lose ni machili gao gose ni kunnonyela njakwe mpela yakuti pakulinonyela nsyene. Kutenda yeleyo ili yambone kupunda kwatyochesya Akunnungu mbopesi sya kocha ni sadaka sine syasikutyosyekwa kwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Che Yesu paŵaiweni kuti mundu jo ajanjile kwa lunda ŵansalile, “Mmwejo nganimme kwakutalichila kwalechelela Akunnungu antawale.” Kutandilila katema ko ngapagwa mundu juŵalinjile sooni kumbusya Che Yesu chachili chose. ");
INSERT INTO yao_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Che Yesu paŵaliji nkwajiganya ŵandu pa Nyuumba ja Akunnungu, ŵausisye ŵandu, “Kwachichi ŵakwiganya Malajisyo akusala kuti Kilisito, ali jumo pe mu uŵelesi u che Daudi? ");
INSERT INTO yao_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mbumu jwa Akunnungu ŵanlongwesye che Daudi, nombejo ŵatite, ‘Ambuje ŵansalile Ambuje ŵangu, Ntame kundyo kwangu, mpaka pachinaatamiche ŵammagongo ŵenu paasi pa sajo syenu.’ ");
INSERT INTO yao_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Che Daudi nsyene akummilanga Kilisito, ‘Ambuje,’ iŵele uli sooni Kilisito aŵe jumo pe mu uŵelesi u che Daudi?” Mpingo wa ŵandu ŵampilikanile kwa lukondwa. ");
INSERT INTO yao_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Che Yesu paŵajiganyaga ŵatite, “Nlilolechesye ni ŵakwiganya Malajisyo ŵakusaka kwendajenda ali awete minjilo jajileu, ŵakunonyelwa akomasikwe kwa kuchimbichikwa peuto pakusumichisya malonda. ");
INSERT INTO yao_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sooni akunonyelwa kutama mu itengu ya mmbujo, mmajumba ga kupopelela Ŵayahudi ni kutama mmauto ga kuchimbichikwa, pa chindimba cha chakulya. ");
INSERT INTO yao_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kwa kwalambusya, akwasumula ipanje achakongwe ŵawililwe ni achiŵankwawo, ni kwa kulilosya kuti ali ŵandu ŵambone, akupopela mapopelo gamaleu. Kwalyele ligongo lyo, chalamulikwe kwa chikali nnope kupunda ŵandu ŵane.” ");
INSERT INTO yao_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Che Yesu ŵatemi chiŵandi ni lisanduku lya kugosela sadaka pa Nyuumba ja Akunnungu, ŵaliji nkulolechesya ŵandu paŵalinji nkutaga mbiya. Ŵaipanje ŵajinji ŵatasile mbiya syasijinji. ");
INSERT INTO yao_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nipele ŵaiche jwankongwe jwakulaga jwawililwe ni ŵankwawo, jwelejo ŵatasile mbiya syasinandi siŵili. ");
INSERT INTO yao_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pelepo Che Yesu ŵaaŵilasile ŵakulijiganya ŵao, ŵaasalile, “Isyene ngunsalila, jwankongwe jwakulaga jwawililwe ni ŵankwakwe ju, atasile yejinji mu lisanduku lya kugosela sadaka, kwapunda ŵandu ŵane wose. ");
INSERT INTO yao_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pakuŵa ŵandu ŵane wose atasile sadaka syao kutyochela mu yakupunda ya mu ipanje yao. Nambo jwankongwe ju nkulaga kwakwe, atasile yose yakwete.” ");
INSERT INTO yao_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Che Yesu paŵaliji nkukopoka pa Nyuumba ja Akunnungu, jumo jwa ŵakulijiganya ŵao ŵatite, “Jwakwiganya, nlole maganga ga ni nyuumba si isitite pakusalala ni kusimosya!” ");
INSERT INTO yao_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Che Yesu ŵansalile, “Ana nkugawona majumba gamakulungwa ga? Ngalisigalila liganga pa liganga liine, liganga lyalililyose chilityochekwe.” ");
INSERT INTO yao_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Che Yesu paŵatemi pa chitumbi chachigumbele itela ya Miseituni chachikulolegana ni Nyuumba ja Akunnungu, che Petulo ni che Yakobo ni che Yohana ni che Andulea ŵausisye Che Yesu paŵaliji jika pe. ");
INSERT INTO yao_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Choonde ntusalile, gelego chigakopochele chakachi? Ana chimanyisyo chi chachichilosye kuti gaŵandichile kukopochela gelego?” ");
INSERT INTO yao_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Che Yesu ŵaasalile, “Nlilolechesye, mundu akanlambusya. ");
INSERT INTO yao_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ŵandu ŵajinji chaaiche kwa liina lyangu, achitiji, ‘Une ndili Kilisito!’ Nombewo chiŵalambusye ŵandu ŵajinji. ");
INSERT INTO yao_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ni ŵanyamwe pachinchipikana ya ngondo ni usone wa ngani ja ngondo, ngasinjogopa. Gelego gakusachilwa gatyochele, nambo mbesi jila jikanaŵe kwika. ");
INSERT INTO yao_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ŵandu ŵa chilambo chimo chaachimenyana ni ŵandu ŵa chilambo chine, ni ŵandu ŵa umwenye umo chaputane ni ŵandu ŵa umwenye wine. Chichityochele chindendemesi cha chilambo ni sala jajikulungwa panepane. Yele yose chiiŵe mpela ndande ja chilungusi cha kuligopola. ");
INSERT INTO yao_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ŵanyamwe nlilolechesye, pakuŵa ŵandu chankamule ni kunjausya mmikungulu ni kumputanga mmajumba ga kupopelela Ŵayahudi. Chaachinjausya paujo pa ŵakulamula ni mamwenye ligongo lyangu kuti nkombole kuuŵalanjila umboni wa ngani syangu. ");
INSERT INTO yao_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nambo mbesi jikanaŵe kwika, Ngani Jambone jikusachilwa jilalichilwe kaje kwa ŵandu wose. ");
INSERT INTO yao_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nombewo pachachinkamula ni kunjausya pankungulu, nkaganisya kaje ichimmechete. Mmecheteje chachili chose chachimpegwe katema ko, pakuŵa ngaŵa ŵanyamwe uchimmechete nambo Mbumu jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nlongo changalauche nlongo njakwe aulajikwe, nombe atati changalauche mwanagwe aulajikwe, nombe ŵanache chiŵakane ni kwaulaga achaŵelesi ŵao. ");
INSERT INTO yao_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ŵandu wose chaachinchima ŵanyamwe kwa ligongo lya liina lyangu. Nambo juchapililile mpaka kumbesi jo chakulupuswe mu kulamulikwa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nambo pachinchione, ‘Chindu cha uchimwa chachikwikanawo uwonasi,’ chijimi pangaŵa pakwe.” Jwakusyoma amanyilile malumbo gakwe. “Ŵandu ŵaali kuchilambo cha ku Yudea autuchile kumatumbi. ");
INSERT INTO yao_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mundu jwali paasa nyuumba jao, akalikaŵisya kwinjila nkati kukujigala chindu, nambo agambe kuutuka! ");
INSERT INTO yao_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ni mundu jwali kumigunda, akauja sooni kumusi kukujigala mwinjilo wakwe. ");
INSERT INTO yao_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ngwakolela chanasa achakongwe ŵachakole itumbo ni ŵachajonjesye pa moŵa go, pakuŵa chalaje kwannope! ");
INSERT INTO yao_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mpopele kuti indu yo ikakopochela pa moŵa ga mbepo. ");
INSERT INTO yao_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Pakuŵa pa moŵa go ŵandu chalaje ulaje wanganiutyochele chitandile kundanda, Akunnungu paŵagumbile chilambo mpaka lelo, ni ngautyochela sooni. ");
INSERT INTO yao_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nambo ikaliji Ambuje ngakapungusye moŵa go, ngapagwa mundu jwakakulupwiche. Nambo kwa ligongo lya ŵandu ŵao ŵaŵasagwile, apungwisye moŵa go. ");
INSERT INTO yao_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nipele, pa moŵa go ansalilaga mundu, ‘Nnole, Kilisito ali apano,’ pane ‘Ali apala,’ ngasimwakulupilila. ");
INSERT INTO yao_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pakuŵa chachikopochela ŵanya Kilisito ŵa unami ni ŵakulondola ŵa unami. Chachitenda imanyisyo ni yakusimosya, yakombolekaga, ŵalyungasye ŵandu ŵasagulikwe ni Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nambo ŵanyamwe nlilolechesye. Une masile kunsalila chile gose gakanaŵe kukopochela. ");
INSERT INTO yao_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nambo gamalaga moŵa ga malagasyo go, lyuŵa chilipilile ni lwesi ngalulanguchisya. ");
INSERT INTO yao_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ndondwa sisipatuche kutyochela kwinani ni indu yose yaili ni machili kumaunde chiitinganyikwe. ");
INSERT INTO yao_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pelepo chachimmona Mwana jwa Mundu, achiikaga mwiunde kwa machili gamakulungwa ni ukulu. ");
INSERT INTO yao_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chiŵatume achikatumetume ŵao ŵa kwinani kukwasonganya ŵandu ŵaŵasagulikwe ni Akunnungu kutyochela mbande syose ncheche sya chilambo. Kutyochela kwakulikose pa chilambo. ");
INSERT INTO yao_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nlijiganye yeleyi kutyochela mu chitagu cha chitela cha ntini. Pankusiona nyambi syakwe sitepetele ni kusipuka masamba, nkumanyilila kuti katema ka ula kaŵandichile. ");
INSERT INTO yao_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iyoyo peyo, ŵanyamwe pachinchiiona yeleyo ichikopochelaga, mmanyilile kuti, Mwana jwa Mundu aŵandichile nnope kwika. ");
INSERT INTO yao_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Isyene ngunsalila, uŵelesi wu ngaumala gakanaŵe kukopochela gele gose. ");
INSERT INTO yao_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kwinani ni chilambo chiimale, nambo maloŵe gangu chigakopochele isyene mpela indite pa kusala. ");
INSERT INTO yao_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nambo, pachanya lyuŵa lya mbesi namose saa jakwe, ngapagwa mundu jwakumanyilila, atamuno achikatumetume ŵa kwinani ngakumanyilila, namose Mwana jwa Akunnungu ngakumanyilila. Ikaŵe Atati Akunnungu pe ni ŵakumanyilila. ");
INSERT INTO yao_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nlilolechesye ni kuliŵika chile, pakuŵa ngankukamanyilila katema ko chikaiche chakachi. ");
INSERT INTO yao_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Chiichiŵa mpela mundu jwakwaula ulendo, kujileka nyuumba jakwe ni kwalechela ulamusi achikapolo ŵao, jwalijose ni masengo gakwe, nipele ŵannajisye jwakulindilila pannango kuti aŵeje meeso pe. ");
INSERT INTO yao_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nipele nliŵiche chile, pakuŵa ngankumanyilila nsyene nyuumba chauje katema chi. Pane chauje ligulo, pane pasikati chilo, pane kuninkucha ni pane kundaŵi. ");
INSERT INTO yao_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nliŵiche chile, aujaga chisisimuchile, ansimane ndi meeso pe. ");
INSERT INTO yao_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ingunsalila ŵanyamwe ni ingwasalila wose, nliŵiche chile!” ");
INSERT INTO yao_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gasigalile moŵa gaŵili likanaŵe lyuŵa lya chindimba cha Pasaka ni chindimba cha mikate jangataga amila. Achakulu ŵambopesi ni ŵakwiganya Malajisyo ŵaliji nkusosa itajile pakwakamula Che Yesu, mwangamanyilila jwalijose ni kummulaga. ");
INSERT INTO yao_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ŵatite, “Tukatenda yeleyo katema ka chindimba cha Pasaka, kuti ŵandu akatindiganya.” ");
INSERT INTO yao_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Che Yesu ŵaliji ku Besania, kumusi ku che Simoni juŵaliji jwamatana. Paŵalyaga, ŵaiche jwankongwe jumo juŵaliji ni chuupa chachikolochekwe ni liganga lyalikuŵilanjikwa alabasta, chachili ni mauta ga kununjila nnope ga ntengo wekulungwa gagakuŵilanjikwa nado. Ŵakasile chuupa cho, ni kwajitila mauta Che Yesu mu ntwe. ");
INSERT INTO yao_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ŵandu ŵampepe ŵaŵaliji pamo ni Che Yesu yachimile achitiji, “Kwachichi akugajonanga mauta ga ntengo ga? ");
INSERT INTO yao_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngati akasumisye mauta ga ni kupata mbiya syasijinji ni kwapa ŵandu ŵakulaga!” Nipele ŵankalipile kwannope jwankongwe jo. ");
INSERT INTO yao_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nambo Che Yesu ŵaasalile, “Munneche! Nkunsauchisya ichichi? Jweleju ambanganyichisye chindu chambone. ");
INSERT INTO yao_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ŵandu ŵakulaga chaŵe ni ŵanyamwe moŵa gose, iŵaga nkusaka kwakamuchisya nkukombola. Nambo une nguŵa ni ŵanyamwe moŵa gose. ");
INSERT INTO yao_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jweleju atesile yakombwele. Alongolele kuchijitilila mauta chiilu changu, kuchiŵika chile, gakanaŵe masiiko gangu. ");
INSERT INTO yao_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Isyene ngunsalila, kwakulikose pachilambo pachijilalichikwe Ngani Jambone ni achi chatesile jwankongwe ju chichisalichikwe kwakwakumbuchila.” ");
INSERT INTO yao_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nipele, che Yuda Isikaliote, jumo jwa achinduna kumi na mbili ŵala, ŵajawile kwa achakulu ŵambopesi kuti akombole kwagalauka Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Achakulu ŵambopesi ŵasangalele pakupikana ngani jo, ni ŵannanjile kuti chiŵaape mbiya. Nipele che Yuda ŵasosile lipesa lyambone lya kungalauka Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pa lyuŵa lya kutanda lya chindimba cha mikate jangataga Amila, katema paŵasikitaga mwanangondolo jwa Pasaka, ŵakulijiganya ŵao ŵausisye, “Ana kwapi nkusaka tukachikolochesye chakulya cha Pasaka?” ");
INSERT INTO yao_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nipele Che Yesu ŵaatumile ŵaŵili mwa ŵakulijiganya ŵao ni ŵaasalile, “Njaule mu musi, ni mwelemo chinkasimane ni jwannume ali atwichile lulo lwa meesi. Nkankuye ");
INSERT INTO yao_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mpaka nyuumba jichakajinjile, nkansalile nsyene nyuumba jo, ‘Jwakwiganya akummusya, chili kwapi chuumba muchingalile chakulya cha Pasaka pamo ni ŵakulijiganya ŵangu?’ ");
INSERT INTO yao_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nombejo chakannosye chuumba chachikulungwa cha penani chachili chile ni kupambwa. Nkatukulumichisye mwelemo.” ");
INSERT INTO yao_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ŵakulijiganya ŵala ŵatyosile, ni kwaula mmusi, ŵaisimene yose ili mpela iŵatite pakusalilwa ni Che Yesu. Nombewo ŵakulumisye chakulya cha Pasaka. ");
INSERT INTO yao_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kuli kuswele, Che Yesu ŵaiche pamo ni ŵakulijiganya ŵao kumi na mbili. ");
INSERT INTO yao_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Paŵaliji aninkulya, Che Yesu ŵatite, “Isyene ngunsalila, jumo mwa ŵanyamwe jwakulya pamo ni une, chang'alauche.” ");
INSERT INTO yao_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pelepo ŵakulijiganya ŵao ŵatandite kusupuka, ni ŵatandite kummusya jumojumo, “Ana ndili une?” ");
INSERT INTO yao_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Che Yesu ŵaasalile, “Jumo mwa ŵanyamwe kumi na mbili, jwakupamba nkate wakwe mu mbale pamo ni une. ");
INSERT INTO yao_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pakuŵa Mwana jwa Mundu chawe mpela iilembekwe Mmalembelo Gamaswela nkati ŵelewo. Nambo chalaje mundu jwakungalauka Mwana jwa Mundu! Ikaliji mmbaya mundu jo ngakapagwe!” ");
INSERT INTO yao_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Paŵalyaga, Che Yesu ŵajigele nkate, ŵatogolele Akunnungu, ŵaugaŵenye ni kwapa ŵakulijiganya ŵao, achitiji, “Mpochele, nlyanje, chelechi ni chiilu changu.” ");
INSERT INTO yao_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sooni ŵajigele chikombe cha divai, ŵatogolele Akunnungu, ni kwapa, ni wose ŵang'welele divai mu chikombe cho. ");
INSERT INTO yao_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Che Yesu ŵaasalile, “Jeleji ni miasi jangu ja lilangano lya Akunnungu, jajikwitika kwa ligongo lya kwalechelesya ŵandu ŵajinji. ");
INSERT INTO yao_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Isyene ngunsalila, ngung'wa sooni divai mpaka lyuŵa paching'we divai jasambano mu Umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Paŵamasile kwimba lujimbo lwa kwatogolela Akunnungu, ŵatyosile kwaula ku Chikwesya chachigumbele itela ya Miseituni. ");
INSERT INTO yao_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Che Yesu ŵaasalile ŵakulijiganya ŵao, “Ŵanyamwe wose chimmutuche ni kuuneka, pakuŵa Mmalembelo Gamaswela Akunnungu akuti, ‘Chinambulaje jwakuchinga, ni ngondolo sisipwilingane.’ ");
INSERT INTO yao_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nambo pachinjisyuka, chinjinnongolela kwaula ku Galilaya.” ");
INSERT INTO yao_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Che Petulo ŵansalile, “Atamuno annekaga wose, une ngangunneka ng'oo!” ");
INSERT INTO yao_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Che Yesu ŵansalile che Petulo, “Isyene ngunsalila, chilo cha lelo chino, tambala jikanaŵe kutongola kaŵili, chimungane katatu kuti ngankuumanyilila.” ");
INSERT INTO yao_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nambo che Petulo ŵapundile kulimbila kuti, “Atamuno iŵaga ngusachilwa kuwa pamo nomwe ngangunneka ng'oo!” Ni ŵakulijiganya ŵane ŵala ŵaŵechete iyoyo peyo. ");
INSERT INTO yao_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ŵaichenje pa ngunda wa mwana waukuŵilanjikwa Getesemane, Che Yesu ŵaasalile ŵakulijiganya ŵao, “Ntamanje apano katema pangwaula kukwapopela Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nipele ŵaajigele che Petulo ni che Yakobo ni che Yohana, ŵatandite kusupuka kwannope ni kupotekwa mu ntima. ");
INSERT INTO yao_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ni ŵaasalile, “Ngupotekwa kwannope mu ntima ni chipwetesi chachikukombola kumulaga. Ntamanje apano ni kuŵa meeso pe.” ");
INSERT INTO yao_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nipele ŵajawile mmbujo kanandi, ni ŵagwile manguuku, ŵapopelele kuti, yakombolekaga anajinjile mu katema ka malagasyo ko. ");
INSERT INTO yao_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ni ŵatite, “Atati wangu, yose ikukomboleka kukwenu. Mundyochesye chikombe cha malagasyo chi. Ngaŵa mpela ingusaka une, nambo mpela inkusaka mmwe.” ");
INSERT INTO yao_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nipele, ŵausile kwa ŵakulijiganya ŵatatu ŵala, ni ŵaasimene agonile. Ŵammusisye che Petulo, “Che Simoni, uli ngonile? Nganinkombola kutama meeso pe namose saa jimo?” ");
INSERT INTO yao_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nipele ŵaasalile, “Ntamanje meeso pe ni kupopela kuti nkajinjila nkulinjikwa. Pakuŵa ntima ukusaka kupanganya yambone, nambo chiilu chilepetele.” ");
INSERT INTO yao_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ŵajawile sooni kukupopela achiujilaga maloŵe gagogo pego. ");
INSERT INTO yao_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Paŵausile sooni, ŵasimene ŵakulijiganya ŵala ali agonile, ligongo ŵatopelwe ni lugono. Nombewo nganachimanyilila chakwajanga Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kaatatu paŵaichilile ŵaasalile, “Ana ndi chigonele ni kupumulila? Sambano njimuche! Nnole, saa jiiche Mwana jwa Mundu akutajikwa mmakono ga ŵandu ŵaali ni sambi. ");
INSERT INTO yao_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Njimuchanje, twende. Nnole mundu jwakung'alauka aŵandichile.” ");
INSERT INTO yao_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Che Yesu paŵaliji nkuŵecheta, che Yuda, jumo jwa achinduna kumi na mbili, ŵaiche. Ŵaiche ni mpingo wa ŵandu ŵaŵatumikwe ni achakulu ŵambopesi ni ŵakwiganya Malajisyo ni achachekulu, ali ajigele mapanga ni imbonga. ");
INSERT INTO yao_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Che Yuda jwakugalauka jula ŵapele ŵanyawo chimanyisyo chi, “Ajula juchingankomasye kwa kwanonyela ni jujojo junkunsaka. Munkamule ni kunlindilila.” ");
INSERT INTO yao_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Che Yuda paŵaiche pe, papopo ŵajaulile Che Yesu ni kwasalila, “Jwakwiganya!” Nipele ŵankomasisye kwa unonyelo. ");
INSERT INTO yao_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nipele ŵandu ŵala ŵankamwile Che Yesu ni kuntaŵa. ");
INSERT INTO yao_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nambo jumo jwa ŵeŵala uŵajimi pelepo pamo ni Che Yesu, ŵasolomwele lipanga lyakwe ni kumputila kapolo jwa Jwambopesi Jwankulu, ni ŵankapile liwiwi. ");
INSERT INTO yao_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Che Yesu ŵaasalile, “Ana nnyiche ni mapanga ni imbonga kukungamula mpela ila une ndili jwachiswamba? ");
INSERT INTO yao_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Moŵa gose naliji pamo ni ŵanyamwe njijiganyaga pa Nyuumba ja Akunnungu, nganimungamula. Nambo sambano ngaleche Malembelo ga Akunnungu gamalile.” ");
INSERT INTO yao_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pelepo ŵakulijiganya ŵao wose ŵannesile ni kulukunula. ");
INSERT INTO yao_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jwapali jwanchanda jumo juŵaliji nkwakuya Che Yesu ali aliŵagele shuka pe. Ni ŵanyawo ŵasachile kunkamula, ");
INSERT INTO yao_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nambo jwanchanda jula ŵapelete, ŵalesile shuka jila ni kutila matakope. ");
INSERT INTO yao_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nipele, ŵampeleche Che Yesu ku nyuumba ja Jwambopesi Jwankulu, kuŵasongangene achakulu ŵambopesi wose ni achachekulu ni ŵakwiganya Malajisyo. ");
INSERT INTO yao_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Che Petulo ŵankuiye Che Yesu kwakutalichila, ŵajinjile mu lutenje lwa nyuumba ja Jwambopesi Jwankulu. Pelepo ŵatemi pamo ni ŵakulindilila achijotelaga mooto. ");
INSERT INTO yao_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nipele, achakulu ŵambopesi ni ŵandu ŵane wose pa Nkungulu pala ŵasosile umboni wa kummechetela Che Yesu kuti ŵaulaje, nambo wasoŵile. ");
INSERT INTO yao_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ŵandu ŵajinji ŵaŵechetele Che Yesu umboni wa unami, nambo umboni wao nganiujilana. ");
INSERT INTO yao_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nipele ŵane wajimi ni kuŵecheta umboni wa unami, achitiji, ");
INSERT INTO yao_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Twampilikene ali nkuŵecheta, ‘Une chinajigumule Nyuumba ja Akunnungu ji, jajitaŵikwe ni ŵandu ni kutaŵa kwa moŵa gatatu jine jangataŵikwa ni ŵandu.’ ” ");
INSERT INTO yao_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Namose yeleyo, umboni wao nganiujilana. ");
INSERT INTO yao_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nipele Jwambopesi Jwankulu ŵajimi paujo pa ŵandu ni kwausya Che Yesu, “Uli, ngankwanga chachili chose kwa wele umboni ŵakumbechetela wo?” ");
INSERT INTO yao_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nambo Che Yesu ŵaliji jii, nganaŵecheta chachili chose. Jwambopesi Jwankulu ŵammusisye sooni, “Ana mmweji ni Kilisito, Mwana jwa Akunnungu Ŵakulu?” ");
INSERT INTO yao_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Che Yesu ŵajanjile, “Elo, ndili une. Sooni, chinchimmona Mwana jwa Mundu ali atemi kundyo kwa Akunnungu ŵa machili, ali nkwika mmaunde ga kwinani.” ");
INSERT INTO yao_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jwambopesi Jwankulu paŵapilikene yeleyo ŵapapwile mwinjilo wakwe achitiji, “Ngatukusaka sooni umboni wine nkati mundu ju! ");
INSERT INTO yao_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mumpilikene yatite pakwatukana Akunnungu! Ŵanyamwe nkuti uli?” Wose ŵanlamwile aulajikwe. ");
INSERT INTO yao_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ŵandu ŵane ŵatandite kunsunila mata Che Yesu, ni ŵansiŵilile mmeeso ni ŵamputile ni kunsalila, “Nlondole, nduni jwamputile!” Iyoyo peyo ŵakulindilila ŵanjigele ni kumputa majanda. ");
INSERT INTO yao_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Che Petulo paŵaliji chiŵela mu lutenje, ŵaiche mwali jumo mwa achikatumetume ŵa Jwambopesi Jwankulu. ");
INSERT INTO yao_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Paŵammweni che Petulo achijotelaga mooto, ŵankolondolele ni kunsalila, “Nombe mmwejo iyoyo mwaliji pamo ni Che Yesu jwa ku Nasaleti.” ");
INSERT INTO yao_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nambo che Petulo ŵakanile achitiji, “Ngangwamanya namose nganguchimanyilila chinkuŵecheta cho.” Nipele ŵakopweche paasa, papopo tambala jatongwele. ");
INSERT INTO yao_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mwali jula ŵammweni sooni che Petulo, ŵatandite kwasalila ŵandu uŵajimi pelepo, “Mundu ju ali jumo jwao.” ");
INSERT INTO yao_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nambo che Petulo ŵakanile sooni. Pangakaŵa, ŵandu uŵajimi pelepo ŵaasalile che Petulo, “Isyene mmwe ndi jumo jwao, pakuŵa mmwejo nombe ndi mundu jwa ku Galilaya.” ");
INSERT INTO yao_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nambo che Petulo ŵatandite kusala, “Nweseche iŵaga ngusala unami, ngulumbilila kuti, isyene ngangummanyilila mundu ju junkungamba.” ");
INSERT INTO yao_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Papopo pepo tambala jatongwele kaaŵili. Che Petulo ŵalikumbuchile liloŵe li Che Yesu liŵaasalile, “Tambala jikanaŵe kutongola kaŵili, chimungane katatu.” Nipele ŵaligwisisye paasi ni kulila. ");
INSERT INTO yao_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kundaŵi pe, achakulu ŵambopesi ni achachekulu ni ŵakwiganya Malajisyo, pamo ni Nkungulu wose, ŵatemi, ŵajilene kunjausya Che Yesu ku che Pilato. Nipele ŵantaŵile, ni kunjausya ku che Pilato. ");
INSERT INTO yao_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Che Pilato ŵammusisye Che Yesu, “Ana mmweji ndi mwenye jwa Ŵayahudi?” Che Yesu ŵajanjile, “Elo, mpela mmwejo intite pakuŵecheta.” ");
INSERT INTO yao_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Achakulu ŵambopesi ŵaŵechetele Che Yesu maloŵe gamajinji. ");
INSERT INTO yao_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Che Pilato ŵammusisye sooni Che Yesu, “Ana ngakwanga chachili chose? Mpilikane maloŵe gose gakummechetela ga.” ");
INSERT INTO yao_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nambo Che Yesu nganajanga liloŵe, mpaka che Pilato ŵasimosile. ");
INSERT INTO yao_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pa katema ka chindimba cha Pasaka, che Pilato ŵasyoŵelele kwagopolela jwataŵikwe juŵansachile ŵandu. ");
INSERT INTO yao_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kwaliji ni jwataŵikwe jumo, liina lyakwe che Balaba, juŵaliji ataŵikwe pamo ni ŵandu ŵane ŵaŵatandisye utindiganyo ni kwaulaga ŵandu ŵane. ");
INSERT INTO yao_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mpingo wa ŵandu waichilile che Pilato, ŵatandite kwaŵenda ŵapanganyichisye mpela iŵatendaga. ");
INSERT INTO yao_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Che Pilato ŵausisye, “Ana nkusaka nangopolele Mwenye jwa Ŵayahudi?” ");
INSERT INTO yao_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Che Pilato ŵatite yeleyo pakuŵa ŵaimanyilile kuti, achakulu ŵambopesi ŵannyichisye Che Yesu kukwao ligongo lya kwakolela wiu. ");
INSERT INTO yao_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nambo achakulu ŵambopesi ŵala, ŵachisisye ŵandu ŵaŵende che Pilato ŵagopolele che Balaba pamalo pa Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Che Pilato ŵausisye ŵandu sooni, “Sambano, nkusaka naapanganyichisye ichichi aju mundu junkuti Mwenye jwa Ŵayahudi?” ");
INSERT INTO yao_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ŵanyanyisye sooni achitiji, “Mwaŵambe pa nsalaba!” ");
INSERT INTO yao_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nambo che Pilato ŵausisye, “Atesile chakusakala chanti uli?” Nambo ŵanyawo ŵapundile kunyanyisya achitiji, “Mwaŵambe pa nsalaba!” ");
INSERT INTO yao_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Che Pilato ŵasachile kwanonyelesya ŵandu, ŵagopolele che Balaba. Nipele ŵalamwile Che Yesu aputikwe mbokola ni kwapa ŵaŵambe pa nsalaba. ");
INSERT INTO yao_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ŵangondo ŵanjawisye Che Yesu pa nsana wa likome li che Pilato, jwankulu jwa chilambo. Ŵausimanisye mpingo wose wa ŵangondo. ");
INSERT INTO yao_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ŵambwasisye mwinjilo wa sambalau nti mwenye, ŵakolosisye chindu mpela singwa ja miiŵa, ŵambwasisye mu ntwe. ");
INSERT INTO yao_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nipele ŵatandite kunkomasya achitiji, “Kutusimana, Mwenye jwa Ŵayahudi!” ");
INSERT INTO yao_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ŵamputile pa ntwe ni lubokola lwa nnasi, ŵansunile mata, ŵantindiŵalile ni kwakotamila. ");
INSERT INTO yao_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Paŵamasile kwachembulusya, ŵammusile mwinjilo wa sambalau ni kwawasya iwalo yao. Nipele ŵantyosisye paasa ni kwaŵamba pa nsalaba. ");
INSERT INTO yao_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Paŵaliji mwitala, ŵasimene ni mundu liina lyao che Simoni, jwa ku Kulene jwaŵaliji atati ŵa che Alekisanda ni che Lufo. Jweleju ŵatyochelaga kunsinda kwinjila mmusi. Ŵangondo ŵankanganichisye atwichile nsalaba uŵajigele Che Yesu ula. ");
INSERT INTO yao_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nipele ŵanjigele Che Yesu mpaka peuto papaŵilanjikwe Goligota, malumbo gakwe, “Peuto papakuloleka nti, Chikalakasa cha Ntwe.” ");
INSERT INTO yao_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pelepo, ŵampele divai jewanganye ni ntela waukuŵilanjikwa manemane, nambo Che Yesu ŵakanile kung'wa. ");
INSERT INTO yao_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ŵammambile pa nsalaba ni ŵagaŵene iwalo yakwe kwa kuitendela gudugudu, pakuti alole ŵaani chapate chiwalo chi. ");
INSERT INTO yao_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jaliji saa tatu kundaŵi paŵammambile pa nsalaba. ");
INSERT INTO yao_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ni pachanya nsalaba, ŵaŵisile chindu chachilembekwe magambo ga, “MWENYE JWA ŴAYAHUDI.” ");
INSERT INTO yao_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Papopopepo ŵaŵambikwe pa misalaba ŵachiswamba ŵaŵili, jwine kundyo ku Che Yesu ni jwine kunchiji. ");
INSERT INTO yao_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yeleyi yamalichisye Malembelo ga Akunnungu gagakuti, “Jwaŵichikwe pamo ni ŵandu ŵangalumbana.” ");
INSERT INTO yao_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ŵandu ŵaŵapitaga pelepo ŵapukunyaga mitwe jao ni kwatukana Che Yesu, alinkuti, “Ama! Mmwe ngati mwatiji chinchigumula Nyuumba ja Akunnungu, ni kujitaŵa kwa moŵa gatatu! ");
INSERT INTO yao_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sambano, ntuluche pa nsalaba, ndikulupusye mwasyene!” ");
INSERT INTO yao_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Iyoyo peyo achakulu ŵambopesi ni ŵakwiganya Malajisyo wala ŵanchembulwisye achisalilanaga, “Ŵakulupwisye ŵandu ŵane, nambo ngakukombola kulikulupusya nsyene! ");
INSERT INTO yao_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nneche twalole Kilisito, Mwenye jwa Isilaeli! Atuluche etu pa nsalaba po kuti tulole ni kwakulupilila.” Iyoyo peyo ŵandu uŵaŵambikwe pa misalaba chiŵandi ni Che Yesu, ni ŵanyawo nombe ŵaliji nkutukana. ");
INSERT INTO yao_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Palyaiche lyuŵa pantwe, chilambo chose chaunichikwe ni chipi mpaka saa tisa ja muusi. ");
INSERT INTO yao_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa tisa ja muusi Che Yesu ŵanyanyisye achitiji, “Eloi, Eloi, lama sabakitani?” Malumbo gakwe, “Akunnungu ŵangu, Akunnungu ŵangu, kwachichi munesile?” ");
INSERT INTO yao_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aŵala ŵandu ŵane ŵaŵajimi pepala ŵala, paŵapilikene maloŵe go ŵatite, “Mpilikanile! Akwaŵilanga che Elia!” ");
INSERT INTO yao_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jumo jwao ŵautwiche kukunyoya chindu mpela lidodoki mu divai jakuŵipa, ŵakoleche pa nnasi, ŵambichile Che Yesu pakang'wa, achitiji, “Nneche tulole iŵaga che Elia chaiche kukuntulusya pa nsalaba!” ");
INSERT INTO yao_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nipele Che Yesu ŵanyanyisye ni ŵajasiche. ");
INSERT INTO yao_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Katema kakoko, nguo ja lusasa ja mu Nyuumba ja Akunnungu japapwiche pambindikati, kutyochela penani mpaka paasi. ");
INSERT INTO yao_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jwankulu jwa ŵangondo juŵajimi mmbujo mwa nsalaba, paŵaweni Che Yesu ajasiche kwanti yeleyo, ŵatite, “Isyene mundu ju ŵaliji Mwana jwa Akunnungu!” ");
INSERT INTO yao_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Achakongwe ŵampepe ŵaliji nkulolechesya kwakutalichila. Mwa ŵanyawo, ŵapali che Maliamu jwa musi wa ku Magidala ni che Salome ni che Maliamu achikulu ŵao che Yakobo jwannandi ni che Yusufu. ");
INSERT INTO yao_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Achakongwe ŵa ni aŵala ŵaŵaliji nkwakuya Che Yesu paŵaliji ku Galilaya ni kwatumichila. Iyoyo peyo ŵapali achakongwe ŵane pepala, ŵaŵaiche ku Yelusalemu pamo nawo. ");
INSERT INTO yao_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Lyaiche ligulo lya lyuŵa lya kuliŵika chile, likanaŵe Lyuŵa lya Kupumulila. ");
INSERT INTO yao_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Che Yusufu jwa musi wa ku Alimataya, juŵaliji jumo jwa achakulu ŵa Nkungulu ni jwakuchimbichikwa nnope ŵaiche. Jwelejo ŵaliji nkulolela kwika kwa Umwenye wa Akunnungu. Nipele che Yusufu ŵanjaulile che Pilato pangajogopa ni kwaŵenda ŵaape chiilu chi Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Che Pilato ŵasimosile kupilikana kuti Che Yesu ajasiche. Nipele, ŵammilasile jwankulu jwa ŵangondo, ŵambusisye iŵaga Che Yesu ŵajasiche. ");
INSERT INTO yao_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nipele, che Pilato paŵaimanyi kutyochela kwa jwankulu jwa ŵangondo jula, ŵannechele che Yusufu ajigale chiilu chi Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Che Yusufu ŵasumile saanda, ni ŵachitulwisye paasi chiilu chi Che Yesu ni kuchiŵilijila saanda jila. Ŵachiŵisile mwilembe lilyasepekwe pa lwala. Nipele ŵalipitikulile liganga lyalikulungwa pannango. ");
INSERT INTO yao_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Che Maliamu jwa musi wa ku Magidala pamo ni che Maliamu achikulugwe che Yusufu ŵapaweni pelepo paŵachiŵisile chiilu chi Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Palyapite Lyuŵa lya Kupumulila, che Maliamu jwa musi wa ku Magidala ni che Salome ni che Maliamu achikulugwe che Yakobo ŵagasumile mauta gakununjila. Ŵajawile kukuchipakasya chiilu chi Che Yesu. ");
INSERT INTO yao_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kundaŵi pe, lyuŵa lyaandanda lya chijuma, lyuŵa lininkukopoka ŵaiche kumalembe. ");
INSERT INTO yao_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nombewo paŵaliji mwitala ŵausyanaga, “Ana ŵaani juchakatugalambulile liganga pannango wa lilembe?” ");
INSERT INTO yao_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nambo paŵalolechesye, ŵaliweni liganga lyekulungwa nnope lila lili lyegalambulile pambali. ");
INSERT INTO yao_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pele ŵajinjile mwilembe, ŵammweni jwanchanda jwawete chiwalo cheswela ali atemi kundyo ni ŵasimosile nnope. ");
INSERT INTO yao_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nambo jwanchanda jula ŵaasalile, “Kasinsimonga, nguimanyilila kuti nkunsosa Che Yesu jwa ku Nasaleti juŵammambile pa nsalaba. Nganapagwa pelepa, asyuchile. Nnole peuto paŵangoneche. ");
INSERT INTO yao_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nambo ŵanyamwe njaule nkasalile che Petulo ni ŵakulijiganya ŵane kuti, ‘Che Yesu alongolele kwaula ku Galilaya. Kweleko chinkaawone mpela iŵatite pakunsalila.’ ” ");
INSERT INTO yao_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nipele, ŵatyosile kumalembe ali nkuutuka ni ali nkutetemela kwa lipamba ni kusimonga. Nganasala chindu chachili chose kwa mundu, pakuŵa ŵaliji nkogopanga kwannope. ");
INSERT INTO yao_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Che Yesu paŵasyuchile, kundaŵi pe, lyuŵa lyaandanda lya chijuma ŵankopochele kaje che Maliamu jwa musi wa ku Magidala, ajula jwaŵankopwesye masoka nsano ni gaŵili. ");
INSERT INTO yao_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Che Maliamu jwa musi wa ku Magidala, ŵajawile ni kwasalila aŵala ŵakulijiganya ŵa Che Yesu, katema ko ŵanyawo ŵaliji nkulila ni kulila kwa malumbo. ");
INSERT INTO yao_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nambo paŵapilikene kuti Che Yesu asyuchile ni kuti che Maliamu jwa musi wa Kumagidala ammweni, nganiŵakulupilila. ");
INSERT INTO yao_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kanyuma kakwe Che Yesu ŵakopochele ŵakulijiganya ŵao ŵaŵili ŵaŵaliji nkwaula mmisinda. Ni ŵakulijiganya wo, kundanda nganiŵaamanyilila. ");
INSERT INTO yao_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nombewo ŵausile kukwasalila ŵakulijiganya achinjao, ni ŵanyawo nombe, nganiŵakulupilila iyoyo. ");
INSERT INTO yao_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mbesi jakwe Che Yesu ŵaakopochele ŵakulijiganya ŵao likumi ni jumo paŵaliji nkulya. Nipele, ŵaakalipile kwa ungakulupilila ni kukakatima kwa mitima jao, pakuŵa nganiŵakulupilila aŵala ŵaŵaweni ŵelewo pakumala kusyuka. ");
INSERT INTO yao_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ni ŵaasalile, “Njaulanje pachilambo pose nkalalichile Ngani Jambone kwa ŵandu wose. ");
INSERT INTO yao_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mundu jwalijose juchakulupilile ni kubatiswa, Akunnungu chankulupusye. Nambo mundu jwangakukulupilila, Akunnungu chanlamule. ");
INSERT INTO yao_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ni wose ŵachakulupilile chaitendekanye imanyisyo yanti, chagakoposye masoka kwa liina lyangu ni kuŵecheta chiŵecheto chasambano. ");
INSERT INTO yao_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Akamulangaga majoka pane kung'wa chindu chachilichose chakuulaga, ngachaulaga. Chaachasajichila makono ŵakulwala, ni Akunnungu chiŵaalamye.” ");
INSERT INTO yao_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nipele, Ambuje Che Yesu paŵamasile kuŵecheta nawo, ŵajigalikwe kwaula kwinani, ni ŵatemi kunkono wa kundyo wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nombe ŵakulijiganya ŵala, ŵajawile kukulalichila Ngani Jambone palipose. Ambuje ŵapangenye masengo pamo nawo ni kutendekanya imanyisyo yejinji, kulosya kuti utenga waukwagamba ŵelewo, uli isyene.");
INSERT INTO yao_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ambuje che Teofilo: Ŵandu ŵajinji ŵatesile iŵakombwele kulemba kwa ukotopasyo asila ngani syasikopochele pa uweji. ");
INSERT INTO yao_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ŵalembile mpela yatite pakusalilwa ni ŵandu ŵaŵasiweni ngani syo kwa meeso gao chitandile kundanda ni kuŵa achikatumetume ŵa Liloŵe lya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kwapele ambuje che Teofilo, panamasile kuusosasosa usyene wose chambone kwa moŵa gamajinji, naiweni yambone kuti nannembele kwa uchenene mpela iyatite paakopochela, ");
INSERT INTO yao_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kuti nomwe nkombole kuumanyilila usyene wa yeila yanjiganyikwe. ");
INSERT INTO yao_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Katema che Helode paŵaliji mwenye jwa ku Yudea, paliji ni jwambopesi jwa Akunnungu jumo liina lyao che Sakalia jwa mpingo wa ŵambopesi waukwimililwa ni che Abiya. Ŵankwawo ŵaŵilangagwa che Elisabeti, nombewo ŵaliji ŵa lukosyo lwa jwambopesi che Haluni. ");
INSERT INTO yao_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wose ŵaŵili ŵaliji ŵambone paujo pa Akunnungu, achitamaga nkukamulisya makanyo ni malajisyo ga Ambuje pangali sambi. ");
INSERT INTO yao_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nganaakola ŵanache pakuŵa che Elisabeti ŵaliji ngakuŵeleka, nombe wose ŵaŵili ŵaliji achekulwipe nnope. ");
INSERT INTO yao_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lyuŵa limo che Sakalia pajaliji samu jao jakupanganya masengo ga chimbopesi pa Nyuumba ja Akunnungu, ");
INSERT INTO yao_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mpela iyatite pakusyoŵeleka che Sakalia ŵasagulikwe ni Akunnungu kwagudugudu, kuti ajinjile pa Nyuumba ja Ambuje atutumye ubani. ");
INSERT INTO yao_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ŵandu wose ŵaŵasongangene ŵaliji paasa aninkupopela katema kakututumya ubani. ");
INSERT INTO yao_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Katumetume jwa kwinani jwa Ambuje jwankopochele che Sakalia ni kwima kundyo kwa chilisa cha kututumichisya ubani. ");
INSERT INTO yao_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Che Sakalia paŵammweni katumetume jwa kwinani ŵasupwiche ni kukamulwa ni lipamba. ");
INSERT INTO yao_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nambo katumetume jwa kwinani ŵansalile, “Che Sakalia nkajogopa pakuŵa Akunnungu akupikene kupopela kwenu ni ŵankwenu che Elisabeti chammelechele mwanache jwannume, nomwe chimwaŵilanje a Yohana. ");
INSERT INTO yao_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Chinsangalale nnope ni ŵandu ŵajinji chachine ligongo lya kupagwa kwakwe. ");
INSERT INTO yao_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Chachiŵa jwankulu paujo pa Ambuje. Ngaang'wa divai ng'o, chalongoswe ni Mbumu jwa Akunnungu kutyochela nnutumbo mwa achikulugwe. ");
INSERT INTO yao_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Che Yohana chiŵausye ŵandu ŵajinji ŵa ku Isilaeli kwa Ambuje Akunnungu ŵao. ");
INSERT INTO yao_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ŵelewo chiŵalongolele Ambuje akuno achilongoswaga ni machili ni mbumu mpela ji che Elia, kuti ŵalumbanye achatati ni achiŵana ŵao, chiŵatende ŵangakwajitichisya Akunnungu aŵanje ni nganisyo syambone ni kwaŵika chile ŵandu kwa Ambuje.” ");
INSERT INTO yao_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Che Sakalia ŵammusisye katumetume jwa kwinani jo kuti, “Chichi chachichiimanyisye yeleyo? Pakuŵa uneji ni ŵankwangu tuchekulwipe.” ");
INSERT INTO yao_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Katumetume jwa kwinani jo ŵaajanjile che Sakalia, “Une ni Gabulieli, katumetume jwa Akunnungu, ndumikwe kuŵecheta nomwe ni kunsalila ngani jambone ji. ");
INSERT INTO yao_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mpikane, chimme jwangaŵelecheta, ngankombola kuŵecheta mpaka lyuŵa pachigakopochele gelego, pakuŵa nganingakulupilila maloŵe gangu, nombego chigatimile kwa katema kakwe.” ");
INSERT INTO yao_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kele katema ko ŵandu wose ŵaliji aninkwalindilila che Sakalia akuno achisimongaga kukaŵa kwao mu Nyuumba ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Che Sakalia paŵakopweche paasa nganakombola kuŵecheta nawo. Nipele ŵandu ŵaimanyilile kuti aiweni yakwiwona mu Nyuumba ja Akunnungu. Ŵajendelechele kuŵecheta nawo kwa makono pakuŵa ŵaliji ngakuŵecheta. ");
INSERT INTO yao_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Paŵamalisisye moŵa gao ga kupanganya masengo ga umbopesi, che Sakalia ŵausile kumusi. ");
INSERT INTO yao_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kanyuma kanandi che Elisabeti ŵankwawo che Sakalia ŵaliji pachiilu. Nganatyoka mu nyuumba katema ka miesi nsano. ");
INSERT INTO yao_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Achiŵechetaga kuti, “Yeleyi ni yambanganyichisye Ambuje, angamwisye ni kundyosyesya soni syangu paujo pa ŵandu.” ");
INSERT INTO yao_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pa mwesi wa sita wa chitumbo cha che Elisabeti, Akunnungu ŵantumile Gabulieli, katumetume jwa kwinani ajaule musi wa ku Nasaleti chilambo cha ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ajaule kwa mwalimwalipe liina lyao che Maliamu juŵatomelwe ni jwannume, liina lyao che Yusufu, jwa lukosyo lwa che Daudi. ");
INSERT INTO yao_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Katumetume jwa kwinani ŵanjaulile ni kwasalila, “Ngunkomasya, mmwejo jundi ni upile! Ambuje ali pamo nomwe!” ");
INSERT INTO yao_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Che Maliamu paŵagapilikene gele maloŵe go ŵasupwiche nnope ni kuganisya kuti chikomasyo chi malumbo gakwe chichi? ");
INSERT INTO yao_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Katumetume jwa kwinani ŵansalile, “Che Maliamu, nkajogopa pakuŵa Akunnungu anonyelwe nomwe. ");
INSERT INTO yao_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mpikane, chimme ŵa pachiilu, chimummeleche mwanache jwannume, nomwe chimummilanje Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jwelejo chaŵe jwankulu ni chaŵilanjikwe Mwana jwa Akumanani. Ambuje Akunnungu chiŵape umwenye wa che Daudi, Ambuje ŵao. ");
INSERT INTO yao_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Pelepo chachilulongosya lukosyo lwa che Yakobo moŵa gose pangali mbesi, ni umwenye wakwe ngauika kumbesi.” ");
INSERT INTO yao_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Che Maliamu ŵanjanjile Katumetume jwa kwinani, “Ana chiikomboleche chinauli pakuŵa une ngangummanyilila jwannume?” ");
INSERT INTO yao_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Katumetume jwa kwinani ŵanjanjile che Maliamu, “Mbumu jwa Akunnungu chantuluchile ni machili ga Akumanani chigammunichile mpela mmwilili, kwaligongo lyo, mwanache juchapagwe chaŵilanjikwe Jwanswela ni Mwana jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Atamuno che Elisabeti, alongo ajenu nombe ŵana chiilu cha mwana jwannume atamuno achekulwipe, awu mwesi wao wa sita kwa jwelejo juŵamanyiche ni ŵandu kuti ngakuŵeleka. ");
INSERT INTO yao_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pakuŵa ngapagwa chindu changachikukomboleka kwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Che Maliamu ŵatite, “Une ndili apano kapolo jwa Ambuje, ipanganyiche kwa une mpela intite pakusala.” Nipele katumetume jwa kwinani jula ŵajawile. ");
INSERT INTO yao_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pangakaŵa, che Maliamu ŵalinganyisye ulendo ni ŵajawile kwa kwanguya mu musi umo wauli mu ikwesya ya ku Yuda. ");
INSERT INTO yao_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kweleko, che Maliamu ŵajinjile mu nyuumba ji che Sakalia ni kwakomasya che Elisabeti. ");
INSERT INTO yao_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Che Elisabeti paŵapilikene chikomasyo chi che Maliamu, papopo mwanache juŵaliji nnutumbo mu che Elisabeti jwatungunyiche kwa kusangalala. Nombe che Elisabeti ŵalongweswe ni Mbumu jwa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ŵanyanyisye, “Mpegwile upile kwapunda achakongwe wose ni jwele juchimummeleche jwana upile. ");
INSERT INTO yao_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Une ni ŵaani atamuno achikulugwe Ambuje ŵangu aiche kukwangu? ");
INSERT INTO yao_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nnole pambilikene pe chikomasyo chenu, kanache kakali nnutumbo mwangu katungunyiche nkusangalala. ");
INSERT INTO yao_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ndi ni upile mmwejo unkulupilile kuti chigatyochele gantanjile Ambuje.” ");
INSERT INTO yao_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nombe che Maliamu ŵatite, “Ntima wangu ukwakusya Ambuje, ");
INSERT INTO yao_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ni mbumu jangu jikusangalala ligongo lya Akunnungu, Nkulupusyo jwangu. ");
INSERT INTO yao_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pakuŵa Akunnungu akulolite kwa chanasa kulitulusya kwa kapolo jwao. Kwa yeleyo kutandilila sambano iŵelesi yose chachimilanga jundi ni upile, ");
INSERT INTO yao_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","pakuŵa Akunnungu ŵaali ni Ukombole ambanganyichisye gamakulungwa, liina lyao lili lyeswela. ");
INSERT INTO yao_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Chanasa chao ngachikumala kwa chiŵelesi ni chiŵelesi, kwa ŵandu ŵakwachimbichisya. ");
INSERT INTO yao_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Atesile yekulungwa kwa nkono wao, ŵapwilingenye ŵakulikanganichila mu ng'anisyo sya mitima jao. ");
INSERT INTO yao_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ŵatulwisye mamwenye mu itengu yao ya umwenye, ni ŵakwesisye ŵandu ŵakulitulusya. ");
INSERT INTO yao_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ŵakulaga ŵajikutisye indu yambone, ni ŵaali ni ipanje ŵalesile ajaule makono pe. ");
INSERT INTO yao_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Achikamwisye chilambo cha ku Isilaeli katumetume jwao, achikumbuchilaga kwalosya chanasa chao, ");
INSERT INTO yao_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kwa che Iblahimu ni uŵelesi wao moŵa gose pangali mbesi mpela iŵatite pakwalanga achambuje ŵetu.” ");
INSERT INTO yao_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Che Maliamu ŵatemi ni che Elisabeti mpela miesi jitatu ni ŵausile kumangwao. ");
INSERT INTO yao_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kaaiche katema kakuligopola che Elisabeti, ŵaligopwele mwanache jwannume. ");
INSERT INTO yao_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ŵapachiŵandi pao ni achalongo achinjao paŵapikene kuti Ambuje ammonele chanasa ni ŵasangalele pamo nawo. ");
INSERT INTO yao_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pagaiche moŵa nane chitandile mwanache kupagwa ŵaiche kukummumbasya. Ŵasachile kwapa liina lya che Sakalia, atatigwe. ");
INSERT INTO yao_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nambo achikulugwe ŵatite, “Ngaŵa, nambo chaŵilanjikwe a Yohana.” ");
INSERT INTO yao_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ŵanyawo ŵansalile, “Nambo, ngapagwa mundu jwalijose jwali ni lyele liina mulukosyo lwao.” ");
INSERT INTO yao_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pelepo ŵammusisye atatigwe kwa imanyisyo kuti asale liina chi lyasachile ŵaŵilanjile mwanagwao. ");
INSERT INTO yao_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nombewo ŵaŵilasisye chibao pa kulembelela, ni ŵalembile yeleyi, “Liina lyakwe a Yohana.” Wose ni ŵasimonjile. ");
INSERT INTO yao_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Papopo pepo che Sakalia ŵatandite sooni kuŵecheta achalapaga Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ŵandu wose ŵaŵatamaga pachiŵandi nawo ŵajinjilwe ni lipamba ni ngani syo syakunguluchilwe mbande syose mu chilambo cha ikwesya ya ku Yudea. ");
INSERT INTO yao_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ŵandu wose ŵaŵapikene yeleyo, ŵaganisisye mmitima jao achiliusyaga, “Ana mwanache ju chaaŵe jwantiuli?” Pakuŵa, isyene machili ga Ambuje galiji pamo nawo. ");
INSERT INTO yao_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Che Sakalia, atatigwe jwele mwanache jo, ŵalongweswe ni Mbumu jwa Akunnungu ni ŵalondwele achitiji, ");
INSERT INTO yao_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Twakusye Ambuje, Akunnungu ŵa ku Isilaeli, pakuŵa ŵaichilile ni kwawombola ŵandu ŵakwe. ");
INSERT INTO yao_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atupele Nkulupusyo jwaali ni machili, jwa uŵelesi u che Daudi katumetume jwao. ");
INSERT INTO yao_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mpela iŵatite pakusala kalakala, kwa kang'wa sya ŵakulondola ŵao ŵaswela, ");
INSERT INTO yao_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kuti chachitukulupusya mmakono mwa ŵammagongo ŵetu, ni ŵandu ŵakutuchima. ");
INSERT INTO yao_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ŵaŵechete kuti chalosye chanasa chao kwa achambuje ŵetu, ni kulikumbuchila lilangano lyao lyeswela. ");
INSERT INTO yao_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ŵaalumbilile ambuje ŵetu che Iblahimu, kuti chatupe uwe upile. ");
INSERT INTO yao_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Chatukulupusye mmakono mwa ŵammagongo ŵetu, ni kwapopelela pangali lipamba, ");
INSERT INTO yao_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mu uswela ni umbone, moŵa gose ga umi wetu. ");
INSERT INTO yao_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nomwe mwanangu chimmilanjikwe, jwakulondola jwa Akumanani, chimwalongolele Ambuje ni kwakolochesya litala lyao, ");
INSERT INTO yao_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ni kwamanyisya ŵandu ŵao kuti chiŵakulupusye kwa kwalechelesya sambi syao. ");
INSERT INTO yao_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Akunnungu ŵetu chatende yeleyo ligongo akwete ntima wa unonyelo ni wa chanasa, ni chiwombolo kutyochela kwinani chichituichilile mpela lulanga lwa lyuŵa lya kundaŵi, ");
INSERT INTO yao_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ni kwalanguchisya wose ŵakutama mu chipi chekulungwa cha chiwa, chatulongosye kutama mu utame wa chitendewele.” ");
INSERT INTO yao_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwanache jwakusile ni kulimbichika mmbumu mwakwe. Jwatemi mwipululu mpaka lyuŵa liŵalilosisye kwa ŵandu ŵa ku Isilaeli. ");
INSERT INTO yao_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gele moŵa go che Agusto juŵaliji jwankulu jwa mamwenye wa umwenye wa ku Loma ŵalajisye kuti ŵandu wose pachilambo alembekwe meena gao mu chitabu. ");
INSERT INTO yao_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kuŵalanjikwa ko kwaliji kwaandanda, katema che Kulenio paŵaliji jwankulu jwa chilambo cha ku Silia. ");
INSERT INTO yao_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nipele, ŵandu wose ŵajawile kukuŵalanjikwa, kila mundu ku musi wao. ");
INSERT INTO yao_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Che Yusufu nombe ŵatyosile ku Nasaleti chilambo cha ku Galilaya ni kwaula ku Beselehemu chilambo cha ku Yudea kuŵapagwile che Daudi, ligongo ŵaliji jwa lukosyo lu che Daudi. ");
INSERT INTO yao_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ŵajawile kukulembekwa pamo ni che Maliamu juŵantomele, juŵaliji pa chiilu. ");
INSERT INTO yao_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Paŵaliji ku Beselehemu ko, lyuŵa lya kuligopola ku che Maliamu lyaiche. ");
INSERT INTO yao_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ŵaligopwele mwanache jwao jwa litiwo jwannume, ŵammilijile iwalo ya chanache ni ŵangoneche mu lichinga mu chombo chakulichisya inyama, pakuŵa nganilipagwa lipesa kwa ŵelewo mu nyuumba ja achalendo. ");
INSERT INTO yao_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nipele pachilambo pala paliji ni ŵakuchinga mwitinji ŵaŵalindililaga kwakupisyangana mpingo wa ngondolo syao chilo. ");
INSERT INTO yao_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Katumetume jwa kwinani jwa Akunnungu ŵakopochele chisisimuchile ni lulanga lwa ukulu wa Ambuje lwalanguchisye mbande syose. Nombewo ŵajogwepe kwannope. ");
INSERT INTO yao_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nambo katumetume jwa kwinani jo ŵaasalile, “Nkajogopa! Nnole, nanjigalile ngani jambone jakwasengwasya nnope ŵandu wose ŵa ku Isilaeli. ");
INSERT INTO yao_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Pakuŵa lelo jino mu musi u che Daudi, apagwile Nkulupusyo kwaligongo lyenu, ali Kilisito Ambuje. ");
INSERT INTO yao_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ni achichi chichiŵe chimanyisyo chenu, chimunsimane mwanache jwannandi ŵaŵilijile nguo sya chanache ni sooni ŵagoneche mu lichinga mu chombo chakulichisya inyama.” ");
INSERT INTO yao_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chitema pe kwaoneche mpingo wekulungwa wa achikatumetume ŵa kwinani uli pamo ni katumetume jula, ŵaakusisye Akunnungu, achitiji, ");
INSERT INTO yao_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ukulu kwa Akumanani, ni pachilambo pano chipagwe chitendewele kwa ŵandu ŵakwanonyela.” ");
INSERT INTO yao_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Achikatumetume ŵa kwinani ŵala paŵajaulangene kwinani, ŵakuchinga ŵasalilene, “Tujaulangane sambano jino ku Beselehemu, tukachilole chachikopochele chatumanyisisye Ambuje.” ");
INSERT INTO yao_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nipele, ŵajawile kwa chitema ni ŵansimene che Maliamu ni che Yusufu ni mwanache jwannandi ali angoneche mu lichinga mu chombo chakulichisya inyama. ");
INSERT INTO yao_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ŵele ŵakuchinga paŵammweni mwanache jo, ŵaamanyisye ŵandu wose ngani jiŵajipikene kutyochela kwa achikatumetume nkati mwanache jo. ");
INSERT INTO yao_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wose ŵaŵapikene jele ngani jiŵasalilwe ni ŵakuchinga ŵasimosile. ");
INSERT INTO yao_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nambo che Maliamu ŵapundile kugaŵika maloŵe go mu ntima mwao achigaganisyaga. ");
INSERT INTO yao_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ŵakuchinga ŵala ŵausile mmangwao aninkwakusya ni kwalapa Akunnungu kwa yose iŵaipilikene ni kwiwona, yose yaliji mpela iŵatite pakusalilwa ni achikatumetume ŵa kwinani. ");
INSERT INTO yao_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lyuŵa lya nane kutyochela paŵapagwile ŵamumbesye mwanache, ŵammilasile Che Yesu, liina lilyaliji apegwilwe ni katumetume jwa kwinani katema che Maliamu akanaŵe kuŵa ni chiilu. ");
INSERT INTO yao_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pagamasile moŵa ga kutama munnuli lyaiche lyuŵa lya kuswejeswa mpela Malajisyo ga Akunnungu gaŵapele che Musa igakuti kulajisya, che Yusufu ni che Maliamu ŵanjigele mwanache ni ŵajawile nawo ku Yelusalemu kukwaŵika paujo pa Ambuje. ");
INSERT INTO yao_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mpela itite pakulembekwa mu Malajisyo, “Jwalijose jwakupagwa jwannume jwa litiwo chaŵilanjikwe jwanswela ni kutyosyekwa kwa ligongo lya masengo ga Ambuje.” ");
INSERT INTO yao_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nipele ŵajawile kuti akatyosye sadaka, njuŵa siŵili pane makandi gaŵili ga ngunda mpela itite pakusachilwa ni Malajisyo ga Ambuje. ");
INSERT INTO yao_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kele katema ko kwaliji ni mundu jumo ku Yelusalemu, liina lyakwe che Simeoni, ŵaliji nkupanganya yaili yambone paujo pa Akunnungu. Jweleju jwalindililaga katema ka kutuswa mitima kwa ŵandu ŵa ku Isilaeli. Mbumu jwa Akunnungu ŵaliji pamo nawo. ");
INSERT INTO yao_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mbumu jwa Akunnungu ŵammunukulile jwelejo kuti ngaawa akanaŵe kwawona Kilisito Nkulupusyo, jwasagulikwe juŵaliji chilanga cha Ambuje. ");
INSERT INTO yao_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nipele, che Simeoni ŵaiche pa Nyuumba ja Akunnungu ali alongweswe ni Mbumu Jwanswela. Kele katemako achaŵelesi ŵa Che Yesu ŵannyichenawo mwanache jwao pa Nyuumba ja Akunnungu kuti ŵapanganyichisye mpela chisyoŵelo cha Malajisyo. ");
INSERT INTO yao_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Che Simeoni ŵampochele mwanache mmakono mwao aninkwatogolela Akunnungu, achitiji, ");
INSERT INTO yao_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ambuje, sambano nkunechelela kapolo jwenu nyaule kwa chitendewele, mpela intite pakulanga. ");
INSERT INTO yao_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Pakuŵa meeso gangu gauweni ukulupusyo wenu, ");
INSERT INTO yao_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","umuupanganyisye paujo pa ŵandu ŵa ilambo yose, ");
INSERT INTO yao_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","alu ni lulanga lwalukugopola nganisyo sya ŵandu ŵangaŵa Ŵayahudi ni ukulu kwa ŵandu ŵenu ŵa ku Isilaeli.” ");
INSERT INTO yao_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Atatigwe Che Yesu ni achikulugwe ŵaliji nkugasimonga maloŵe gagaŵechetekwe nkati mwana. ");
INSERT INTO yao_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nipele che Simeoni ŵapele upile ni ŵaasalile che Maliamu achikulugwe Che Yesu, “Nnole, mwanache ju apagwile kwa ligongo lya kugwa kwa ŵandu ŵajinji ni kwinamuka kwa ŵandu ŵajinji ŵa ku Isilaeli. Nombe chaaŵe chimanyisyo chachichikanikwe ni ŵandu, ");
INSERT INTO yao_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kuti nganisyo sya ŵandu ŵajinji siwoneche pangali kusisika. Nomwe mwasyene chiimpoteche mu ntima mwenu mpela nkusomwa ni chipula.” ");
INSERT INTO yao_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Sooni jwapali jwankongwe jumpepe, jwakulondola jwa Akunnungu juŵachekulwipe nnope, liina lyao lyaliji che Ana binti Fanueli jwa lukosyo lwa Asheli. Mu umwali wao ŵalombekwe ni kutama ni ŵankwakwe kwa yaka saba pe. ");
INSERT INTO yao_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nombewo ŵasigele ŵakuwililwa ni ŵankwakwe mpaka katema paŵaliji jwanchekulu jwa yaka semanini na nne. Katema kose ko ŵalonjelaga pa Nyuumba ja Akunnungu achitaŵaga ni kupopela muusi ni chilo. ");
INSERT INTO yao_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Papopo pepo jwankongwe jo ŵalikopwesye paujo ni kwatogolela Akunnungu ni kusala ngani sya mwanache jo kwa ŵandu wose ŵaŵaliji nkulolela kuwombolwa ni kulecheleswa kwa Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Achaŵelesi ŵa Che Yesu paŵamasile kupanganya yose iyaliji mu malajisyo ga Ambuje, ŵausile kumangwao ku Nasaleti chilambo cha ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jwele mwanache jwakusile ni jwalimbangene, jwagumbele lunda ni ntuuka wa Akunnungu ŵaliji pamo nawo. ");
INSERT INTO yao_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Achaŵelesi ŵa Che Yesu ŵaliji ni chisyoŵelo cha kwaula ku Yelusalemu chaka ni chaka katema ka chindimba cha Pasaka ja Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Che Yesu paŵaliji ni yaka kumi na mbili, ŵapite pamo nawo ku chindimba cho mpela itite pakuŵa chisyoŵelo. ");
INSERT INTO yao_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagamasile moŵa ga chindimba cho, ŵatandite ulendo wa kuuja mmangwao, nambo mwanache Che Yesu ŵasigele ku Yelusalemu pangaimanyilila achaŵelesi ŵao. ");
INSERT INTO yao_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ŵaganisisye kuti ŵaliji pamo mumpingo wa ŵandu ŵa ulendo, ŵajesile lyuŵa tetete, nipele ŵatandite kwasosa mwa achalongo achinjao ni achambusanga ŵao. ");
INSERT INTO yao_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Paŵalepele kwaona ŵausile ku Yelusalemu achasosaga. ");
INSERT INTO yao_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pagapite moŵa gatatu, ŵansimene atemi pasikati ŵakwiganya Malajisyo pa Nyuumba ja Akunnungu, achapilikanilaga ni kwausya mausyo. ");
INSERT INTO yao_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wose ŵaŵapikene maloŵe gao ŵausimosile umanyilisi wakwe ni iŵatiji pakwanga kwa lunda. ");
INSERT INTO yao_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Achaŵelesi ŵao paŵammweni ŵasimosile. Che Maliamu achikulugwe, ŵammusisye Che Yesu, “Ana mmwe mwanangu, ligongo lyachi ntutesile yeleyi? Nnole, atati ŵenu noneji twaliji nkunsosa tuli ni lipamba.” ");
INSERT INTO yao_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nombejo ŵajanjile, “Nambo mwansosaga ligongo lyachi? Nganinnyimanyilila kuti ngusachilwa kuŵa pa nyuumba ja Atati ŵangu?” ");
INSERT INTO yao_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nambo achaŵelesi ŵao nganagamanyilila malumbo ga maloŵe gaŵasalilaga. ");
INSERT INTO yao_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nipele ŵausile nawo ku Nasaleti ni ŵaliji nkwapilikanichisya. Achikulugwe ŵapundile kuiganisya indu yose mu ntima mwao. ");
INSERT INTO yao_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nombe Che Yesu ŵapundile kula mu lunda ni lisusa ni ŵapundile kunonyelwa ni Akunnungu ni ŵandu. ");
INSERT INTO yao_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chaka cha kumi na tano cha ulamusi wa Kaisali, yaani mwenye jwankulu che Tibelio, Pontio Pilato ŵaliji jwankulu jwa musi wa ku Yudea. Che Helode ŵaliji jwankulu jwa ku Galilaya ni nkulugwe che Filipo ŵaliji jwankulu jwa ku Itulea ni ku Tilakoniti. Ni che Lisania ŵaliji jwankulu jwa ku Abilene. ");
INSERT INTO yao_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Katema che Anasi ni che Kayafa paŵaliji achakulu ŵambopesi, liloŵe lya Akunnungu lyaichilile che Yohana mwana ju che Sakalia kwipululu kula. ");
INSERT INTO yao_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nipele che Yohana ŵajawile mbande syose sisili mumpika mwa lusulo lwa Yolodani. Ŵaliji nkutangasya kuti ŵandu aleche kwaleŵela Akunnungu ni kubatiswa kuti Akunnungu ŵalechelesye sambi syao. ");
INSERT INTO yao_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mpela itite pakulembekwa mu malembo ga jwakulondola jwa Akunnungu che Isaya kuti, “Mundu akunyanyisya mwipululu, ‘Mwakolochesye Ambuje litala lyao, ngolosye mwakusaka kupita. ");
INSERT INTO yao_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Machemba gose gauchilwe, ikwesya ni itumbi iŵe yekolosye uchenene, papapindiche pagolochekwe, ni matala gagali ni tusimbo gakolochekwe uchenene. ");
INSERT INTO yao_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ni ŵandu wose chauwone ukulupusyo kutyochela kwa Akunnungu.’ ” ");
INSERT INTO yao_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Che Yohana ŵaasalile ŵandu ŵajinji uŵaiche achisakaga kubatiswa achitiji, “Ŵanyamwe uŵelesi wa lijoka! Ŵaani ŵansalile kuti chinkombole kuutila uchimwa wa Akunnungu wauŵandichile kwika? ");
INSERT INTO yao_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mpela ila itela ya isogosi yaikusachilwa kusogola ni ŵanyamwe nnosye kwa isambo kuti nnesile sambi, nkatanda sambano kulisalila mmitima jenu kuti, ‘Tukwete ambuje ŵetu che Iblahimu!’ Ngunsalila kuti, Akunnungu akupakombola kugapanganya maganga ga gaŵe uŵelesi u che Iblahimu. ");
INSERT INTO yao_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sambano jino liŵago lili chile kata michiga ja itela, nipele, chitela chachili chose changasogola isogosi yambone chichigwisikwe ni kujasikwa pa mooto.” ");
INSERT INTO yao_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mpingo wa ŵandu ula wausisye, “Sambano tupanganye ichichi?” ");
INSERT INTO yao_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Che Yohana ŵajanjile, “Ŵaali ni minjilo jiŵili ŵagaŵile ŵanganakola mwinjilo ni ŵaali ni yakulya apanganye iyoyo peyo.” ");
INSERT INTO yao_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nombe ŵakukumbikanya nsongo ŵaiche achisakaga kubatiswa, ŵausisye, “Jwakwiganya, noweji tupanganye ichichi?” ");
INSERT INTO yao_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nombe ŵaasalile, “Nkapochela nsongo kupunda iŵannajisye.” ");
INSERT INTO yao_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nombe ŵangondo ŵausisye, “Noweji tupanganye ichichi?” Nombe ŵajanjile, “Nkapokola mbiya kwa mundu jwalijose jula atamuno nkammechetela jwalijose jula ya unami. Njikute ni mbote syenu pesyo.” ");
INSERT INTO yao_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ŵandu wose ŵaliji nkulolela kwika kwa Nkulupusyo, ŵaliusyaga mmitima jao i che Yohana achitiji panepa ŵelewo ni Kilisito Nkulupusyo jwaŵalanjile Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Che Yohana ŵaajanjile wose, “Uneji ngumbatisya ni meesi, nambo atakwika jwali ni machili kuumbunda une, none nganguŵajilwa kugopola migoji ja italawanda yao. Ŵelewo chachimbatisya kwa Mbumu jwa Akunnungu ni kwa mooto. ");
INSERT INTO yao_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ŵelewo akwete lupeta mmakono mwao ali chile kupeta ngano, chakumbikanye ngano jambone ni kutaga mu ngokwe ni ikambi kuitinisya pa mooto wangasimika.” ");
INSERT INTO yao_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kwa maloŵe gane gamajinji che Yohana ŵachisisye ŵandu kuleka sambi kwa kwalalichila Ngani Jambone. ");
INSERT INTO yao_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nambo che Yohana ŵanjamwiche jwankulu che Helode ligongo lya kwajigala che Helodia ŵankwawo nkulugwe ni kwatenda ŵankwawo ni yose yangalumbana iŵaitesile. ");
INSERT INTO yao_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Che Helode ŵapundangenye ungalimate kwa kwataŵa che Yohana mu nyuumba jakutaŵilwa. ");
INSERT INTO yao_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ŵandu wose paŵamasile kubatiswa, nombe Che Yesu ŵabatiswe. Paŵaliji nkupopela, kwinani kwaugwiche, ");
INSERT INTO yao_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ni Mbumu jwa Akunnungu ŵantuluchile achiŵaga mpela njuŵa. Ni liloŵe lyapikaniche kutyochela kwinani lichitiji, “Mmwejo ni mwanangu nonyelwe nomwe.” ");
INSERT INTO yao_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Che Yesu paŵatandite masengo gao ŵaŵandichile yaka selasini ni ŵandu ŵaganisisye kuti ŵelewo ŵaliji mwanagwao che Yusufu mwana ju che Heli. ");
INSERT INTO yao_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Che Heli ŵaliji mwana ju che Matati ni che Matati ŵaliji mwana ju che Lawi ni che Lawi ŵaliji mwana ju che Meliki ni che Meliki mwana ju che Yanai ni che Yanai ŵaliji mwana ju che Yusufu ni, ");
INSERT INTO yao_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","che Yusufu ŵaliji mwana ju che Matatia ni che Matatia ŵaliji mwana ju che Amosi ni che Amosi ŵaliji mwana ju che Nahumu ni che Nahumu ŵaliji mwana ju che Hesli ni che Hesli ŵaliji mwana ju che Nagai ni, ");
INSERT INTO yao_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","che Nagai ŵaliji mwana ju che Maati ni che Maati ŵaliji mwana ju che Matatia ni che Matatia ŵaliji mwana ju che Semeini ni che Semeini ŵaliji mwana ju che Yoseki ni che Yoseki ŵaliji mwana ju che Yuda ni, ");
INSERT INTO yao_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","che Yuda ŵaliji mwana ju che Yohana ni che Yohana ŵaliji mwana ju che Lesa ni che Lesa ŵaliji mwana ju che Selubabeli ni che Selubabeli ŵaliji mwana ju che Sealitieli ni che Shelitieli ŵaliji mwana ju che Neli ni, ");
INSERT INTO yao_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","che Neli ŵaliji mwana ju che Meliki ni che Meliki ŵaliji mwana ju che Adi ni che Adi ŵaliji mwana ju che Kosamu ni che Kosamu ŵaliji mwana ju che Elimadamu ni che Elimadamu ŵaliji mwana ju che Eli ni, ");
INSERT INTO yao_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","che Eli ŵaliji mwana ju che Yoshua ni che Yoshua ŵaliji mwana ju che Elieseli ni che Elieseli ŵaliji mwana ju che Yolimu ni che Yolimu ŵaliji mwana ju che Matati ni che Matati ŵaliji mwana ju che Lawi ni, ");
INSERT INTO yao_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","che Lawi ŵaliji mwana ju che Simoni ni che Simoni ŵaliji mwana ju che Yuda ni che Yuda ŵaliji mwana ju che Yusufu ni che Yusufu ŵaliji mwana ju che Yonamu ni che Yonamu ŵaliji mwana ju che Eliakimu ni, ");
INSERT INTO yao_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","che Eliakimu ŵaliji mwana ju che Melea ni che Melea ŵaliji mwana ju che Mena ni che Mena ŵaliji mwana ju che Matata ni che Matata ŵaliji mwana ju che Natani ni che Natani ŵaliji mwana ju che Daudi ni, ");
INSERT INTO yao_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","che Daudi ŵaliji mwana ju che Yese ni che Yese ŵaliji mwana ju che Obedi ni che Obedi ŵaliji mwana ju che Boasi ni che Boasi ŵaliji mwana ju che Salumoni ni che Salumoni ŵaliji mwana ju che Nashoni ni ");
INSERT INTO yao_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","che Nashoni ŵaliji mwana ju che Aminadabu ni che Aminadabu ŵaliji mwana ju che Adimini ni che Adimini ŵaliji mwana ju che Alini ni che Alini ŵaliji mwana ju che Esloni ni che Esloni ŵaliji mwana ju che Pelesi ni che Pelesi ŵaliji mwana ju che Yuda ni ");
INSERT INTO yao_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","che Yuda ŵaliji mwana ju che Yakobo ni che Yakobo ŵaliji mwana ju che Isaka ni che Isaka ŵaliji mwana ju che Iblahimu ni che Iblahimu ŵaliji mwana ju che Tela ni che Tela ŵaliji mwana ju che Naholi ni ");
INSERT INTO yao_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","che Naholi ŵaliji mwana ju che Selugi ni che Selugi ŵaliji mwana ju che Leu ni che Leu ŵaliji mwana ju che Pelegi ni che Pelegi ŵaliji mwana ju che Ebeli ni che Ebeli ŵaliji mwana ju che Sala ni ");
INSERT INTO yao_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","che Sala ŵaliji mwana ju che Kainamu ni che Kainamu ŵaliji mwana ju che Alufakisadi ni che Alufakisadi ŵaliji mwana ju che Shemu ni che Shemu ŵaliji mwana ju che Nuhu ni che Nuhu ŵaliji mwana ju che Lameki ni ");
INSERT INTO yao_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","che Lameki ŵaliji mwana ju che Metusela ni che Metusela ŵaliji mwana ju che Enoki ni che Enoki ŵaliji mwana ju che Yaledi ni che Yeledi ŵaliji mwana ju che Mahalaleli ni che Mahalaleli ŵaliji mwana ju che Kainamu ni ");
INSERT INTO yao_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","che Kainamu ŵaliji mwana ju che Enoshi ni che Enoshi ŵaliji mwana ju che Seti ni che Seti ŵaliji mwana ju che Adamu ni che Adamu ŵaliji jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Che Yesu ŵatyosile mu lusulo lwa Yolodani ali aguumbele Mbumu jwa Akunnungu ni ŵalongweswe ni Mbumu kwaula mwipululu. ");
INSERT INTO yao_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kweleko ŵalinjikwe ni Shetani kwa moŵa alobaini. Katema kose ko, nganalya chachili chose ni pagamasile moŵa go, jakwete sala. ");
INSERT INTO yao_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Shetani ŵaasalile, “Iŵaga mmwejo ni Mwana jwa Akunnungu, nlisalile ali liganga li ligalauche liŵe nkate.” ");
INSERT INTO yao_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Che Yesu ŵaajanjile, “Ilembekwe mu Malembelo ga Akunnungu, ‘Mundu ngakulama kwa kulya nkate pe.’ ” ");
INSERT INTO yao_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Shetani ŵankwesisye Che Yesu kwinani ni kunlosya kwanakamo mwenye syose sya pa chilambo. ");
INSERT INTO yao_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Shetani ŵansalile Che Yesu kuti, “Chinampe ulamusi wa ipanje yose ni ukulu wakwe, pakuŵa yose yi ambele une, ngukombola kumpa mundu jwalijose jungunsaka. ");
INSERT INTO yao_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ni yose yi chinampe ni kuŵa yenu iŵaga chimundindiŵalile ni kumbopelela.” ");
INSERT INTO yao_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Che Yesu ŵajanjile, “Ilembekwe mu Malembelo ga Akunnungu, ‘Chimwatindiŵalile Ambuje Akunnungu ŵenu ni kwapopelela ŵawowo pewo.’ ” ");
INSERT INTO yao_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Shetani ŵanjigele Che Yesu mpaka ku Yelusalemu ni ŵanjimiche penani pa lusonga lwa Nyuumba ja Akunnungu ni kwasalila kuti “Iŵaga mmwejo nli Mwana jwa Akunnungu, nlipatusye paasi. ");
INSERT INTO yao_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pakuŵa ilembekwe, ‘Chachatuma achikatumetume ŵao ŵa kwinani angose.’ ");
INSERT INTO yao_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ni sooni, ‘Channyakule mmakono mwao, ntakuligomba lukongolo lwenu paliganga.’ ” ");
INSERT INTO yao_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nambo Che Yesu ŵajanjile, “Ilembekwe mu Malembelo ga Akunnungu, ‘Kasimwalinga Ambuje Akunnungu ŵenu.’ ” ");
INSERT INTO yao_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Shetani paŵamasile kwalinga ŵannesile kwa katema. ");
INSERT INTO yao_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Che Yesu ŵausile ku chilambo cha ku Galilaya achilongoswaga ni machili ga Mbumu jwa Akunnungu ni ngani syao syajenele mu Galilaya ni mu misi jose jajiŵandikene. ");
INSERT INTO yao_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nombe ŵaliji nkwajiganya ŵandu mu majumba gao ga kupopelela ni wose ŵaliji nkwalapa ŵelewo. ");
INSERT INTO yao_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Che Yesu ŵajawile ku Nasaleti, musi wawakulile ni Lyuŵa lya Kupumulila, ŵajinjile mu nyuumba ja kupopelela mpela iyatite pakuŵa chisyoŵelo. Ŵajimi kuti agasyome Malembelo ga Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ŵapochele chitabu chi che Isaya jwakulondola jwa Akunnungu ni ŵaunukwile, ŵasosile ni kupasimana papalembekwe yati ");
INSERT INTO yao_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mbumu jwa Ambuje ali pamo ni une, pakuŵa asagwile kuti nalichile Ngani Jambone kwa ŵandu ŵakulaga. Andumile kukwatangachisya ŵataŵikwe kugopolekwa kwao, ni ŵangalola akombole kulola, ni kukwawombola ŵakukotochelwa. ");
INSERT INTO yao_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ni kwenesya chaka cha Ambuje chakulosya umbone kwa ŵandu ŵakwe.” ");
INSERT INTO yao_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nipele ŵaunichile chitabu chila ni ŵampele katumetume, ŵatemi ni ŵandu wose ŵaŵaliji mu nyuumba ja kupopelela ŵannolechesye kwa nnope. ");
INSERT INTO yao_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nombewo ŵaasalile, “Lelo Malembelo ga Akunnungu ga gaŵele isyene pamumbilikene ndi ngusyoma.” ");
INSERT INTO yao_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wose ŵanonyelwe nawo ni ŵagasimosile maloŵe gambone gaŵaŵechete. Ŵausyanaga, “Ana, aju ngaŵa mwana ju che Yusufu?” ");
INSERT INTO yao_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Che Yesu ŵaasalile, “Ngumanyilila chimusalile chitagu chi, ‘Jwantela nlilamye mwasyene.’ Ni sooni chinchiti, ‘Ituipilikene kuti mpanganyisye ku Kapelenaumu mpanganye nombe pamusi pano.’ ” ");
INSERT INTO yao_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ŵapundile kuŵecheta, “Ngunsalila isyene, ngapagwa jwakulondola jwa Akunnungu jwakukundikwa mu chilambo chakwe. ");
INSERT INTO yao_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nambo mpilikane! Isyene ngunsalila ŵapali achakongwe ŵakuwililwa ni achiŵankwawo ŵajinji mu chilambo cha Isilaeli katema ka che Elia. Kele katema ko nganijinyaga ula kwa yaka itatu ni miesi sita ni kwaliji ni sala jekulungwa pa chilambo chose. ");
INSERT INTO yao_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Namose yeleyo che Elia nganalajiswa kwa jwalijose jwakuwililwa ni ŵankwakwe ikaŵe kwa jwankongwe jwa kuwililwa jwa ku Salepita chilambo cha ku Sidoni. ");
INSERT INTO yao_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ni sooni paliji ni ŵamatana ŵajinji chilambo cha ku Isilaeli katema ka jwakulondola jwa Akunnungu che Elisha. Nipele, nganapagwa jwalijose juŵaswejele ikaŵe che Naamani pe jwa ku Silia.” ");
INSERT INTO yao_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wose ŵaŵaliji mu nyuumba ja kupopelela jila paŵapikene yeleyo ŵatumbile nnope. ");
INSERT INTO yao_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ŵajimi ni kwatyosya paasa musi wao wautaŵikwe pachanya chitumbi ni ŵampeleche mungulugulu chitumbi akombole kwatutila paasi. ");
INSERT INTO yao_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nambo Che Yesu ŵapelete mbindikati jao ni kwaula. ");
INSERT INTO yao_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Che Yesu ŵajawile ku Kapelenaumu chilambo cha ku Galilaya ni kwajiganya ŵandu pa Lyuŵa lya Kupumulila. ");
INSERT INTO yao_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ŵasimosile majiganyo gao pakuŵa utenga wao waliji ni ulamusi. ");
INSERT INTO yao_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ni mu nyuumba ja kupopelela jila mwaliji ni mundu juŵaliji ni lisoka, ŵanyanyisye achitiji, ");
INSERT INTO yao_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Okwe, Che Yesu jwa ku Nasaleti nkwete ichichi nowe? Ana nnyiche kukutujonanga? Ngummanyilila kuti mmwe nli ŵaani, mmwejo ni Ŵaswela ŵa Akunnungu!” ");
INSERT INTO yao_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Che Yesu ŵalikalipile lisoka achitiji, “Mmyalale! Munkopoche mundu ju!” Nipele lisoka lyo lyangwisisye mundu jo paujo pa ŵandu ni kunkopoka pangampoteka. ");
INSERT INTO yao_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ŵandu wose ŵasimosile ni kuŵechetesyana, “Gelega gali majiganyo chi? Mundu ju akwete ulamusi ni machili ga kugasalila masoka gakopoche nombego gakukopoka!” ");
INSERT INTO yao_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ngani si Che Yesu syajenele panapose pachilambo pala. ");
INSERT INTO yao_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Che Yesu ŵakopweche mu nyuumba ja kupopelela jila ni kwaula kumusi ku che Simoni. Ŵaŵendile kuti ŵalamye akwegwao che Simoni pakuŵa ŵalwalaga chiboko. ");
INSERT INTO yao_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nipele Che Yesu ŵaiche ni kwajinamila, ŵachikalipile chiboko nombecho channesile, papopo jwankongwe jo ŵajimwiche ni kwatelechela. ");
INSERT INTO yao_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Palyaiche ligulo, ŵandu wose ŵaŵalwalaga ilwele yakupisyangana ŵaichisye ku Che Yesu nombewo ŵasajiche makono gao pa kila jumo ni kwalamya. ");
INSERT INTO yao_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nombe masoka gaakopweche ŵandu ŵajinji, ganyanyisye gachitiji, “Alakwe nli Mwana jwa Akunnungu!” Nambo Che Yesu nganagalechelela gaŵechete, pakuŵa gaamanyilile kuti ŵelewo ali Kilisito Nkulupusyo. ");
INSERT INTO yao_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kundaŵi jakwe, Che Yesu ŵajawile pachisyepela. Ŵandu ŵala ŵaliji nkwasosasosa. Paŵaichilile paŵaliji ŵalinjile kunsiŵila kuti anatyoche. ");
INSERT INTO yao_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nambo ŵelewo ŵaasalile kuti, “Ngusachilwa kulalichila Ngani Jambone ja umwenye wa Akunnungu mu misi jine nombe pakuŵa ndumigwe kwa ligongo lyo.” ");
INSERT INTO yao_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ŵapundile kulalichila Ngani Jambone mmajumba ga kupopelela ga ku Yudea. ");
INSERT INTO yao_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lyuŵa limo Che Yesu ŵajimi mungulugulu litanda lya Genesaleti ni ŵandu ŵajinji ŵansyungwile ni kwaŵijikanya ali nkupilikanila liloŵe lya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ŵasiweni ngalaŵa siŵili mungulugulu litanda ni ŵakukoka somba ali akopweche, ali nkusaula nyau syao. ");
INSERT INTO yao_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Che Yesu ŵajinjile mu ngalaŵa jimo jijaliji ji che Simoni, ŵaaŵendile che Simoni ajisojechesye mmeesi, kwakutalichila kanandi kutyochela mungulugulu litanda. Ŵaujiganyisye mpingo wa ŵandu ali atemi mu ngalaŵa. ");
INSERT INTO yao_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Paŵamasile kwiganya ŵaasalile che Simoni, “Njitute ngalaŵa kwaula pa meesi ga kwendesya mu litanda, nsiponye nyau syenu ni kukoka somba.” ");
INSERT INTO yao_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Che Simoni ŵajanjile kuti, “Ambuje, tulajilile kukoka somba chilo chose pangapata chindu, nambo pakuŵa nsaasile chinasiponye nyau.” ");
INSERT INTO yao_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Paŵapanganyisye yeleyo ŵakokwele somba syesijinji nnope ni nyau syao syatandite kukutuka. ");
INSERT INTO yao_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ŵaaŵilasile achinjao ŵaŵaliji mu ngalaŵa jiine aichanje kukwakamusya. Ŵaiche ni ŵagumbesye somba ngalaŵa siŵili ni ngalaŵa syo syatandite kutitimila. ");
INSERT INTO yao_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Che Simoni Petulo paŵaiweni yeleyo, ŵatindiŵele paujo pa Che Yesu achitiji, “Ambuje, ntyoche paujo pangu pakuŵa uneji ndili mundu jwa sambi!” ");
INSERT INTO yao_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Che Simoni pamo ni achinjakwe ŵasimosile ligongo lya winji wa somba syapatile sila. ");
INSERT INTO yao_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Iyoyo peyo che Yakobo ni che Yohana ŵanache ŵa che Sebedayo, ŵakukoka achinjakwe che Simoni nombewo ŵasimosile. Che Yesu ŵaasalile che Simoni, “Nkajogopa, kutandilila sambano chimme ŵakwaikanawo ŵandu kwa Ambuje.” ");
INSERT INTO yao_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nipele paŵamasile kusiichisya ngalaŵa sila mungulugulu litanda, ŵalesile yose ni ŵakuiye Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Che Yesu paŵaliji musi umo mu misi ja kweleko, paliji ni jwannume juŵaliji ni matana chiilu chose, nombejo paŵammweni Che Yesu ŵagonile manguku ni kwachondelela aninkuti, “Ambuje mwasakaga muswejesye.” ");
INSERT INTO yao_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Che Yesu ŵajongwele nkono ni ŵankwaiye ni kuti, “Ngusaka, nswejele!” Papopo mundu jo ŵalamile matana. ");
INSERT INTO yao_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nombe Che Yesu ŵansalile, “Munansalile mundu jwalijose nambo njaule nkalilosye kwa jwambopesi, nkatyosye mbopesi kwa ligongo lya kuswejela kwenu mpela iŵatite pakusala che Musa uŵe umboni kuti nnamile.” ");
INSERT INTO yao_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nambo ngani syasikwagamba Che Yesu syapundile kwenela pana pose ni mipingo ja ŵandu jasongangene kukwapikanila ni kulamiswa ilwele yao. ");
INSERT INTO yao_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nambo Che Yesu ŵalisapwile pajika pe ni kupopela. ");
INSERT INTO yao_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lyuŵa limo, Che Yesu ŵaliji nkwiganya, Mafalisayo ni ŵakwiganya malajisyo kutyochela misi jose ja ku Yudea ni ku Galilaya ni ku Yelusalemu ŵatemi papopo. Nipele machili ga Ambuje galiji pamo ni Che Yesu ligongo lya kwalamya ŵandu ŵa kulwala. ");
INSERT INTO yao_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ŵaiche ŵandu ŵampepe ali anjigele mundu jwakutatala ali agonile mu chitagala, ŵalinjile kwajinjisya nkati achisakaga kwaŵika paujo pa Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nambo ŵalepele kwinjila nkati ligongo lya winji wa ŵandu. Nipele ŵakwesile pachanya nyuumba, ŵapowele chipagala ni kwatulusya pamo ni chitagala mbindikati ja ŵandu paujo pa Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nombe Che Yesu paŵachiweni chikulupi chao ŵansalile, “Ambusanga, nlecheleswe sambi syenu.” ");
INSERT INTO yao_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mafalisayo ni ŵakwiganya Malajisyo ŵatandite kuliusyanga achitiji, “Aŵa ni ŵaani ŵakwatukana Akunnungu? Ngapagwa mundu jwakukombola kulechelesya sambi ikaŵe Akunnungu pe!” ");
INSERT INTO yao_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nambo Che Yesu ŵasimanyi ng'anisyo syao ni ŵausisye kuti “Kwachichi nkuliusya yeleyi mmitima jenu? ");
INSERT INTO yao_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Chaapi chili chakwepepala nnope, kusala, ‘Sambi syenu silecheleswe,’ pane kusala, ‘Njimuche njaule?’ ");
INSERT INTO yao_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nipele ngusaka mmanyilile kuti Mwana jwa Mundu akwete ulamusi wa kwalechelesya ŵandu sambi syao pachilambo pano.” Pelepo ŵansalile mundu jwakutatala jo, “Njimuche, njigale chitagala chenu, njaule kumangwenu.” ");
INSERT INTO yao_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Papopo mundu jula ŵajimwiche paujo pao ni kunyakula chitagala chao chiŵagonele ni kwaula kumangwao achakusyaga Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ŵanawose ŵasimosile ni kukamulwa ni lipamba, ŵaakusisye Akunnungu achitiji “Lelo tuiweni yakusimonjeka.” ");
INSERT INTO yao_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Paŵamasile gelego, Che Yesu ŵakopweche paasa ni ŵammweni mundu jumpepe jwakukumbikanya nsongo liina lyakwe che Lawi ali atemi mu nyuumba ja kulipila nsongo ni Che Yesu ŵansalile, “Munguye une!” ");
INSERT INTO yao_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nombe che Lawi ŵajimi, ŵalesile yose ni kwakuya. ");
INSERT INTO yao_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Che Lawi ŵaalaliche Che Yesu aiche kulya mu nyuumba jao. Mpingo wa ŵandu ŵakukumbikanya nsongo ni ŵandu ŵane ŵatemi kulya pamo nawo. ");
INSERT INTO yao_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafalisayo ni ŵakwiganya Malajisyo ŵaali mu mpingo wao ŵaalalamichile ŵakulijiganya ŵa Che Yesu aninkuti, “Kwachichi nkulya ni kung'wa pamo ni ŵakukumbikanya nsongo ni ŵaali ni sambi?” ");
INSERT INTO yao_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Che Yesu ŵajanjile, “Ŵangakulwala ngakwalajila ŵantela ikaŵe ŵakulwala. ");
INSERT INTO yao_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nganiika kukwaŵilanga ŵandu ŵakupanganya yaili yambone paujo pa Akunnungu nambo ŵaali ni sambi kuti aleche sambi.” ");
INSERT INTO yao_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ŵandu ŵane ŵa mumpingo ula ŵaasalile Che Yesu, “Ŵakulijiganya ŵa che Yohana Ŵakubatisya akutaŵa kaŵilikaŵili ni kupopela ni ŵakulijiganya ŵa Mafalisayo akupanganya iyoyo peyo. Nambo ŵakulijiganya ŵenu akulya ni kung'wa.” ");
INSERT INTO yao_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Che Yesu ŵajanjile, “Uli, ana nkuganisya kuti nkukombola kwatendekasya achambusanga ŵa mlombela ataŵe akuno ali pamo nawo? ");
INSERT INTO yao_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nambo chikaiche katema pachajigalikwe mlombela jo pasikati jao, gele moŵa go chachitaŵa.” ");
INSERT INTO yao_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Che Yesu ŵatanjile achi chitagu chi, “Ngapagwa mundu jwakupapula chigamba mu nguo jasambano ni kutotela mu nguo jewisale atamuno atendaga yeleyo chajijonanje nguo jasambano jo ni sooni, chele chigamba cha nguo jasambano cho ngachijilana ni jewisale jo. ");
INSERT INTO yao_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sooni ngapagwa mundu jwakutaga divai jasambano mu misaku jewisale jekolochekwe ni mapende pakuŵa jele divai jasambano jo chijipapule misaku ni divai chijimwasiche ni misaku jo chijijonasiche. ");
INSERT INTO yao_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nambo divai jasambano jikutajikwa mu misaku jasambano. ");
INSERT INTO yao_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ngapagwa jwakusaka kung'wa divai jasambano ali ang'wele jakalakala pakuŵa akuti, ‘Jele jakalakala jo ni jambone nnope.’ ” ");
INSERT INTO yao_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nambo Lyuŵa lya Kupumulila, Che Yesu ŵaliji nkupita mu migunda ja ngano ni ŵakulijiganya ŵao ŵatandite kutema masache ga ngano, ŵagatikite ni kutauna. ");
INSERT INTO yao_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nambo Mafalisayo ŵane ŵausisye, “Uli, ligongo chi nkupanganya indu yangaikusachilwa kupanganyikwa pa Lyuŵa lya Kupumulila?” ");
INSERT INTO yao_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Che Yesu ŵaajanjile, “Uli, ana nganinsyome iŵatite pakupanganya che Daudi pamo ni achinjakwe pijakwete sala? ");
INSERT INTO yao_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jwelejo ŵajinjile pa Nyuumba ja Akunnungu ni ŵajigele mikate jijaŵichikwe paali Akunnungu, ŵalile ni kwapa achinjakwe. Sooni Malajisyo gakukanya mundu jwali jose kulya mikate jo ikaŵe ŵambopesi pe.” ");
INSERT INTO yao_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nipele Che Yesu ŵaasalile, “Mwana jwa Mundu ali Ambuje ŵa Lyuŵa lya Kupumulila.” ");
INSERT INTO yao_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lyuŵa lya Kupumulila liine, Che Yesu ŵajinjile mu nyuumba ja kupopelela ni kwiganya. Mmomo pemo, mwaliji ni mundu jwapombotele nkono wa kundyo. ");
INSERT INTO yao_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ŵakwiganya Malajisyo ni Mafalisayo ŵalolechesyaga Che Yesu kuti alole pane channamye mundu pa Lyuŵa lya Kupumulila ni ŵanyawo akole chakwaŵechetela. ");
INSERT INTO yao_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nambo Che Yesu ŵasimanyilile ng'anisyo syao ni ŵansalile jwapombotele nkono jo kuti, “Njimuche, njime paujo pa ŵandu.” Ni mundu jula ŵajawile ni kwima pepala. ");
INSERT INTO yao_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nipele Che Yesu ŵaasalile, “Ngumbusya, Ana malajisyo getu gakuti uli kwambaga Lyuŵa lya Kupumulila? Ana tukukombola kupanganya yambone pane yangalimate? Ana tukukombola kuukulupusya umi wa mundu pane kuujonanga?” ");
INSERT INTO yao_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ŵaalolechesye ŵandu wose kosekose uŵaliji pepala ni ŵansalile mundu jo, “Njongole nkono ŵenu.” Nombejo ŵaujongwele ni nkono wakwe wakwete machili. ");
INSERT INTO yao_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nambo ŵanyawo yachimile kwannope, nipele ŵaŵechetesyene achinsyene pe ichiŵatende Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pagapite moŵa kanandi Che Yesu ŵajawile kwitumbi kukupopela ni ŵachesisye chilo chose ali nkwapopela Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pakwachele, ŵaaŵilasile ŵakulijiganya ŵao, mwa ŵanyawo ŵaasagwile ŵandu kumi na mbili ni kwaŵilanga achinduna. ");
INSERT INTO yao_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Che Simoni, sooni ŵaŵilanjikwe che Petulo liina liŵaŵilanjikwe ni Che Yesu ni che Andulea mpwao che Simoni ni che Yakobo ni che Yohana ni che Filipo ni che Batolomayo ");
INSERT INTO yao_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ni che Matayo ni che Tomasi ni che Yakobo mwana ju che Alufayo ni che Simoni, juŵaŵilanjikwe Selote, ligongo ŵaliji jwakumenyanila chilambo chakwe ");
INSERT INTO yao_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ni che Yuda mwana ju che Yakobo ni che Yuda Isikaliote juŵangalawiche Che Yesu mmbujo. ");
INSERT INTO yao_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Paŵatulwiche pamo nawo, Che Yesu ŵajimi pa chiŵata. Pelepo paliji ni mpingo wekulungwa wa ŵakulijiganya ŵao ni mpingo wa ŵandu ŵaŵatyosile mosemose ku Yudea ni ku Yelusalemu ni mbwani ja ku Tilo ni ku Sidoni. ");
INSERT INTO yao_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ŵandu wo ŵaiche kukwapikanila Che Yesu ni kulamwa ilwele yao, nombewo ŵalamisye ŵaŵaliji nkulagaswa ni masoka. ");
INSERT INTO yao_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ŵandu wose ŵalinjile kwakwaya, pakuŵa machili gakulamya galiji ganinkwakopoka ni kwalamya wose. ");
INSERT INTO yao_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Che Yesu ŵagalauchile ŵakulijiganya ŵao ni kuti, “Nkwete upile ŵanyamwe unkwakulupilila Akunnungu, pakuŵa Umwenye wa Akunnungu uli wenu! ");
INSERT INTO yao_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nsangalale ŵanyamwe ŵajinkwete sala sambano, pakuŵa chinjikute. Nsangalale ŵanyamwe ŵankulila sambano, pakuŵa chinseche. ");
INSERT INTO yao_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nsangalale ŵanyamwe iŵaga chanchime ŵandu ni kulekangana nomwe ni kuntukana ni kunsala mwanyamwe kuti ŵangalumbana ligongo lya Mwana jwa Mundu. ");
INSERT INTO yao_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nsangalale ni kutyala katema pachigakopochele gelego pakuŵa mbote jenu jili jekulungwa kwinani. Pakuŵa achambuje ŵao ŵapanganyichisye iyoyo peyo ŵakulondola ŵa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nambo ulaje chiuŵe kukwenu ŵanyamwe ŵakusichila, pakuŵa upoche ŵenu chiuŵe wemale. ");
INSERT INTO yao_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ulaje chiuŵe kukwenu ŵanyamwe ŵankwikuta sambano, pakuŵa chijinkole sala. Ulaje chiuŵe kukwenu ŵanyamwe ŵankuseka sambano, pakuŵa chinchilila malilo ni kulila. ");
INSERT INTO yao_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ulaje chiuŵe kukwenu ŵanyamwe iŵaga ŵandu wose akunlapa, pakuŵa achambuje ŵao ŵaapanganyichisye iyoyo peyo ŵakulondola ŵa unami. ");
INSERT INTO yao_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nambo ngunsalila ŵanyamwe ŵankumbikanila une kuti mwanonyele ŵammagongo ŵenu, mwapanganyichisye yambone ŵaakunchima. ");
INSERT INTO yao_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mwasachile upile ŵaakunlwesya ni mwapopelele ŵaakumpanganyichisya wamba. ");
INSERT INTO yao_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mundu amputaga lijanda pa lijeje limo mwagalauchisye ni liine. Ni mundu ansumulaga likoti lyenu munnechele ni mwinjilo wenu. ");
INSERT INTO yao_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mundu jwalijose jwakummenda mumpe ni mundu ansumulaga chipanje chenu munansalile ammuchisye. ");
INSERT INTO yao_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chinkusaka kuti ŵandu ampanganyichisye ŵanyamwe, iyoyo peyo mwapanganyichisye ŵanyawo. ");
INSERT INTO yao_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Iŵaga nkwanonyela pe ŵakunnonyela ŵanyamwe, ana chimpate mbote chi? Ngapagwa! Atamuno ŵaali ni sambi nombewo akwanonyela ŵakwanonyela. ");
INSERT INTO yao_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ni iŵaga chimwapanganyichisye yaili yambone ŵeŵala pe ŵakumpanganyichisya yambone, chimpate mbote chi? Nombe ŵaali ni sambi akupanganya iyoyo peyo. ");
INSERT INTO yao_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ni iŵaga chimwakongosye ŵeŵala pe ŵankwalolela kuti chachimuchisya, ana chimpate mbote chi? Nombe ŵaali ni sambi akwakongosya ŵaali ni sambi achinjao kuti ŵauchisye mpela chila chila. ");
INSERT INTO yao_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nambo ŵanyamwe mwanonyele ŵammagongo ŵenu ni mwapanganyichisye yaili yambone. Nkongosye pangalolela kummuchisya. Ni mbote syenu sisiŵe syekulungwa ni ŵanyamwe chimme ŵanache ŵa Akunnungu Ŵakulu. Pakuŵa ŵelewo ali ŵambone kwa ŵeŵala ŵachigongomalo ŵangakutogolela. ");
INSERT INTO yao_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mmeje ni chanasa mpela Atati ŵenu yatite pakuŵa ni chanasa. ");
INSERT INTO yao_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ngasimwalamula ŵane nombe ŵanyamwe nganlamulikwa, ngasimwalalatila ŵane nombe ŵanyamwe nganlalatilwa ni mwalechelesye ŵane ni ŵanyamwe chinnecheleswe. ");
INSERT INTO yao_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mwapeje ŵane yakusaka ni Akunnungu chachimpa ŵanyamwe. Elo, chinchipochela chipimo chambone chakugumbala, chechinyindile ni chekusangwisye ni kumwasika chichitajikwe mu misaku jenu. Pakuŵa chilachila chimpimile kwa ŵane ni chichocho chinchipimilwa ŵanyamwe ni Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Che Yesu ŵaatanjile achi chitagu chi, “Ana ŵangalola akukombola kwalongosya ŵangalola ajao? Ngaikomboleka! Wose chagwilile mwisimbo. ");
INSERT INTO yao_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jwakulijiganya ngakumpunda jwakwiganya jwao, nambo jwalijose jwakulijiganya amalisyaga kulijiganya akuŵa mpela jwakwiganya jwao. ");
INSERT INTO yao_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ligongo chi nkulolechesya chiswani chachili mu liso lya mpwenu nambo papopo ngankulola chitela chachili mu liso lyenu? ");
INSERT INTO yao_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pane nkukombola chinauli kunsalila mpwenu kuti, ‘Mpwanga, nninde kaje nantyosye chiswani chachili mu liso lyenu,’ ni akuno ngankulola chitela chachili mu liso lyenu mwasyene? Jwaulamba mmwejo! Ntyosye kaje chitela chachili mu liso lyenu, nipele chinlole uchenene pakuchityosya chiswani chachili mu liso lya mpwenu. ");
INSERT INTO yao_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Iyoyo peyo ngapagwa chitela chambone chachikusogola isogosi yangalimate ni ngapagwa chitela changalimate chachikusogola isogosi yambone. ");
INSERT INTO yao_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chitela chachili chose chikumanyika kwa isogosi yakwe. Ŵandu ngakukombola kukaŵa isogosi ya tini pa chisukutu cha miiŵa atamuno sabibu pa nkwanga. ");
INSERT INTO yao_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mundu jwambone akutyosya indu yambone yagosile mu ntima wakwe. Ni mundu jwangalumbana akutyosya yangalumbana yagosile mu ntima wakwe. Pakuŵa mundu akuŵecheta kutyochela mu yaigumbele mu ntima wakwe.” ");
INSERT INTO yao_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kwachichi nkumilanga une, ‘Ambuje, Ambuje,’ nambo ngankupanganya ingusaka? ");
INSERT INTO yao_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chinannosye chitagu cha mundu jwalijose jwakwika kwangune ni kugapilikana maloŵe gangu ni kugapanganya, ");
INSERT INTO yao_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","jwelejo akulandana ni mundu jwataŵile nyuumba, juŵasolesye paasi nnope mpaka palwala ni kutanda kutaŵa pepala. Pajanyele ula jekulungwa nnope meesi gasewiche ni kujigomba nyuumba jila nambo nganijitinganyika, pakuŵa jaliji jetaŵe kwakulimbila. ");
INSERT INTO yao_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nambo mundu jwalijose jwakugapikanila maloŵe gangu nombejo anapanganye chachili chose, jwelejo akulandana ni mundu jwataŵile nyuumba jakwe pa nsanga, pangasolesya paasi nnope. Pajanyele ula jekulungwa nnope meesi gasewiche ni kujigomba nyuumba jila ni jagwile ni kugumuka jose!” ");
INSERT INTO yao_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Che Yesu paŵamasile kuŵecheta yeleyi kwa ŵandu ŵajawile ku Kapelenaumu. ");
INSERT INTO yao_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kweleko kwaliji ni chilongola jumo jwa ŵandu ŵangondo mia moja ŵa chiloma juŵaliji ni kapolo juŵankundile nnope. Jwele kapolo jo ŵaliji nkulwala chiŵandi ni kuwa. ");
INSERT INTO yao_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chilongola jula paŵasipilikene ngani si Che Yesu, ŵaatumile achachekulu ŵane ŵa Ŵayahudi ajaule akaachondelele kuti aiche kukunlamya kapolo jwao. ");
INSERT INTO yao_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Paŵaiche ku Che Yesu, ŵanchondelele nnope achitiji, “Mundu ju akuŵajilwa kukamuchiswa, ");
INSERT INTO yao_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","pakuŵa akwanonyela ŵandu ŵetu, sooni ni jwatutaŵile nyuumba ja kupopelela.” ");
INSERT INTO yao_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nipele Che Yesu ŵalongene nawo. Paŵaliji nkuŵandichila kwika pa nyuumba ja chilongola jula, chilongola jula ŵaatumile achambusangagwe ŵaasalile Che Yesu kuti, “Ambuje nnalisausye nnope, pakuŵa une nganguŵajilwa mmwejo njinjile mu nyuumba jangu. ");
INSERT INTO yao_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ali ni ligongo naliweni nganguŵajilwa kwika kukwenu nansyene. Nambo mmechete liloŵe pe ni jwakutumichila jwangu chalame. ");
INSERT INTO yao_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pakuŵa noneji nombe ndili mundu jundi paasi pa ulamusi, sooni ngwete ŵangondo paasi pa une. Nansalilaga jumo ‘Njaule!’ Nombejo akwaula ni jwine, ‘Njise!’ Nombejo akwika ni kapolo jwangu, ‘Ntende achi!’ Nombejo akuchitenda.” ");
INSERT INTO yao_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Che Yesu paŵapikene yeleyo, ŵansimosile, nombejo ŵagalauchile ŵandu ŵajinji ŵala ŵaŵaliji nkwakuya ni ŵaasalile, “Nganinachiwone chikulupi chachikulungwa mpela achi namuno mu ŵandu ŵa Isilaeli!” ");
INSERT INTO yao_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ŵandu ŵaŵatumikwe ŵala paŵaiche kumusi kwa chilongola jula ŵansimene kapolo jwao jula ali alamile. ");
INSERT INTO yao_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kundaŵi jakwe, Che Yesu ŵajawile mu musi umo waukuŵilanjikwa Naini, mpingo wa ŵandu ni ŵakulijiganya ŵao ŵalongene nawo. ");
INSERT INTO yao_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nipele paŵaliji aninkuŵandichila pannango wa musi, ŵakopochele ŵandu ali ajigele malilo ga jwanchanda, mwana jwajikajika pe jwa jwankongwe jwawililwe ni ŵankwakwe. Ni ŵandu achajinji wa musi ula ŵaliji pamo ni jwankongwe jula. ");
INSERT INTO yao_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ambuje Che Yesu paŵammweni jwankongwe jo ŵankolele chanasa, ni ŵansalile, “Nkalila.” ");
INSERT INTO yao_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nipele ŵajawile ni kuchikwaya chitagala chila ni ŵaŵajigele ŵala ŵajimi. Nipele ŵatite, “Mmwe nchanda! Ngunsalila, njimuche!” ");
INSERT INTO yao_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jwamwe jula ŵajimwiche ni kutama ni ŵatandite kuŵecheta. Ni Che Yesu ŵauchisye achikulugwe. ");
INSERT INTO yao_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ŵandu wose ŵakamwilwe ni lipamba ni ŵaliji nkwakusya Akunnungu achitiji, “Jwakulondola jwankulu jwa Akunnungu akopochele kukwetu. Akunnungu aiiche kukwakamusya ŵandu ŵao.” ");
INSERT INTO yao_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ngani jo jajenele mu chilambo chose cha ku Yudea ni mu ilambo ine iyasyungwile. ");
INSERT INTO yao_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ŵakulijiganya ŵa che Yohana ŵaŵalanjile che Yohana yankati syele ngani syose. Nombewo ŵaaŵilasile ŵakulijiganya ŵaŵili mwa ŵakulijiganya ŵao. ");
INSERT INTO yao_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ŵalajichisye kwa Ambuje Che Yesu akausye kuti, “Mmwe ni nkulupusyo jwakwika pane twalolele ŵane?” ");
INSERT INTO yao_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ŵandu ŵala paŵaiche ku Che Yesu ni ŵatite “Che Yohana Ŵakubatisya atulajisye kukwenu tummusye kuti, ‘Ana alakwe ni nkulupusyo jwakwika pane twalolele ŵane?’ ” ");
INSERT INTO yao_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Katema kakoko Che Yesu ŵaliji nkwalamya ŵandu ŵajinji ŵaŵaliji nkulagaswa ni ilwele ni ŵakulwala ni kugatyosya masoka ni ŵangalola achajinji kwatenda akombole kulola. ");
INSERT INTO yao_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nipele Che Yesu ŵaajanjile, “Njaule nkaasalile che Yohana yose inyiweni mwachinsyene ni kupilikana. Ŵangalola atakulola ni ŵangajenda atakwenda ni ŵaali ni matana akuswejeswa ni ŵangapilikana akupilikana ni ŵawile akusyuswa ni ŵakulaga akulalichilwa Ngani Jambone. ");
INSERT INTO yao_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Asangalale jwele mundu jwangakuchimwa ni une!” ");
INSERT INTO yao_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pelepo ŵakulijiganya ŵa che Yohana paŵatyosile, Che Yesu ŵatandite kuusalila mpingo wa ŵandu yankati che Yohana achitiji, “Pamwajawile kukunnola che Yohana mwipululu mula mwalolele kuti chinchione chichi? Ana mwaganisye kuti chinkammone mundu jwali mpela litete lili nkupungunyikwa ni mbungo? ");
INSERT INTO yao_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nipele mwajawile kukulola ichichi? Mwajawile kukunnola mundu jwawasile iwalo yakusalala? Ngwamba! Ŵakuwala iwalo yanti yele ni kutama mu upoche ali mu majumba ga chimwenye! ");
INSERT INTO yao_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Musalile, mwajawile kukulola ichichi? Mwajawile kukunnola jwakulondola jwa Akunnungu? Elo, sooni kupunda jwakulondola jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ngani sya jweleju ni syasilembekwe mu Malembelo ga Akunnungu, ‘Nnole, nguntuma jwakutumichila jwangu annongolele juchankolochesye litala lyenu.’ ” ");
INSERT INTO yao_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Che Yesu ŵapundile kuŵecheta ngunsalila, “Mwa ŵandu ŵaŵelekwe ni jwankongwe ngapagwa jwankulu kumpunda che Yohana Ŵakubatiswa. Nambo jwali jwannandi mu Umwenye wa Akunnungu ni jwankulu kupunda jwelejo.” ");
INSERT INTO yao_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ŵandu wose pamo ni ŵakukumbikanya nsongo ŵaŵabatiswe ni che Yohana paŵapilikene yeleyo ŵajitichisye kuti Akunnungu ali ŵa usyene. ");
INSERT INTO yao_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nambo Mafalisayo ni ŵakwiganya Malajisyo ŵanganabatiswa ni che Yohana ŵakanile chikotopasyo cha Akunnungu chachikwagamba ŵanyawo. ");
INSERT INTO yao_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Che Yesu ŵapundile kuŵecheta, “Chinaalandanye ni chichi ŵandu ŵa au uŵelesi wu? Ana akulandana ni chichi? ");
INSERT INTO yao_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Akulandana ni ŵanache ŵaŵatemi peuto pakusumichisya malonda ni kuŵilangana mpingo ni mpingo, ‘Twangombele ipeta, nambo nganintyala! Twanjimbile nyimbo sya pamalilo nambo nganinlila!’ ");
INSERT INTO yao_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pakuŵa che Yohana Ŵakubatisya ŵaiche, nombe ŵaliji nkutaŵa ni nganang'waga divai ni ŵanyamwe mwatite ‘Ali ni lisoka!’ ");
INSERT INTO yao_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nombe Mwana jwa Mundu aiche, akulya ni kung'wa ni ŵanyamwe mwatite, ‘Munnole aju jwakutolwa ju ni jwakolelwa ambusanga jwa ŵakukumbikanya nsongo ni ŵa sambi!’ ");
INSERT INTO yao_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nambo lunda lwa Akunnungu lusalichikwe kuti luli lwambone ni wose ŵakwitichisya ŵala.” ");
INSERT INTO yao_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayo jumpepe ŵanlaliche Che Yesu kukulya chakulya kumangwao. Ŵajinjile nkati mwa jwele Mfalisayo jo, ŵatemi ni kulya. ");
INSERT INTO yao_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pamusi pala paliji ni jwankongwe jumpepe jwali ni sambi. Paŵapilikene kuti Che Yesu ali nkulya mu nyuumba ja Mfalisayo jula ŵajigele kachupa kakakolechekwe ni liganga lyalikuŵilanjikwa alabasta kakagumbele mauta gakununjila. ");
INSERT INTO yao_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ŵaiche ni kwima pachiŵandi makongolo ga Che Yesu, achililaga, ni misosi jakwe japatuchile pa makongolo ga Che Yesu. Jwele jwankongwe jo ŵagatikite makongolo ga Che Yesu kwa umbo syakwe. Ŵagakomasisye makongolo kwa ngomo syakwe ni ŵagapachile mauta. ");
INSERT INTO yao_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jwele Mfalisayo juŵanlaliche Che Yesu paŵaiweni yeleyo, ŵaganisisye mu ntima mwakwe kuti, “Aju mundu ju akaŵe jwakulondola jwa Akunnungu, akaimanyi kuti jwankongwe jwakunkwaya ju ali jwanti uli, kuti ali ni sambi.” ");
INSERT INTO yao_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Che Yesu ŵansalile jwele Mfalisayo jo kuti “Che Simoni, ngwete chakunsalila.” Nombe che Simoni ŵajitichisye, “Elo jwakwiganya, mmechete.” ");
INSERT INTO yao_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Che Yesu ŵatandite kuŵecheta, “Ŵandu ŵaŵili ŵankongwele mbiya mundu jumpepe, jumo ŵakongwele mbiya malinga ni malipilo ga masengo ga chaka chimo ni nusu ni jwine ŵakongwele mbiya malinga ni malipilo ga masengo ga mwesi umo ni nusu. ");
INSERT INTO yao_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Paŵalepele kummuchisya, jwele mundu jo ŵalechelesye wose ŵaŵili. Mwa ŵandu ŵaŵili wo jwapi juchannonyele nnope jwakukongosya jula?” ");
INSERT INTO yao_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Che Simoni ŵajanjile, “Isyene ni ajula juŵannechelesye ligambo lyekulungwa nnope ni juchannonyele nnope Ambuje.” Che Yesu ni ŵatite, “Njanjile uchenene.” ");
INSERT INTO yao_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nipele ŵangalauchile jwankongwe jo ni ŵaasalile che Simoni, “Ana ngati nkummona jwankongwe ju? Panajinjile mu nyuumba jenu nganimumba meesi ga kulikunda pa makongolo gangu nambo jwankongwe ju ŵambatuchisye misosi jakwe pa makongolo gangu ni kundikita ni umbo syakwe. ");
INSERT INTO yao_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mmwejo nganimungomasya kwa kunonyela pejeje, nambo une chijinjilile mu nyuumba ji jwankongwe ju nganaleka kungomasya kwa kunonyela pa makongolo gangu. ");
INSERT INTO yao_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mmwejo nganimumbakasya mauta muntwe, nambo ajuju ambachile mauta pa makongolo gangu. ");
INSERT INTO yao_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ngunsalila kuti unonyelo wekulungwa ŵaulosisye ukumanyisya kuti alecheleswe sambi syakwe syasitupile. Nambo jwakulecheleswa indu yaili kanandi, akunonyela kanandi.” ");
INSERT INTO yao_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nipele Che Yesu ŵansalile jwankongwe jo, “Sambi syenu silecheleswe.” ");
INSERT INTO yao_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ŵeŵala ŵaŵalyaga pamo ni Che Yesu ŵausyene achinsyene achitiji, “Ana mundu ju ali ŵaani, jwakukombola atamuno kulechelesya sambi?” ");
INSERT INTO yao_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nombe Che Yesu ŵansalile jwankongwe jo, “Chikulupi chenu chinnamisye, njaule kwa chitendewele.” ");
INSERT INTO yao_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pagamasile gelego, Che Yesu ŵapite mu misi ni misinda achilalichilaga Ngani Jambone ja Umwenye wa Akunnungu. Ni ŵakulijiganya kumi na mbili ŵala ŵalongene nawo. ");
INSERT INTO yao_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nipele achakongwe ŵane ŵaŵaakopwesye masoka ni kwalamya ilwele ŵalongene nawo. Ŵelewo ni ŵanya che Maliamu jwa musi wa ku Magidala jwati Che Yesu ŵankopwesye masoka saba, ");
INSERT INTO yao_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ni che Joana ŵankwawo che Kusa, che Kusa ŵaliji jwakulindilila nyuumba ji che Helode ni che Susana ni ŵane ŵajinji. Ŵele achakongwe wo ŵaliji nkwakamusya Che Yesu ni ŵakulijiganya ŵao kwa ipanje yao achinsyene. ");
INSERT INTO yao_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mpingo wa ŵandu ŵaliji uninkusongangana ni ŵandu kukopochela misi jina jose ŵaliji nkwaichilila Che Yesu. Nombewo ŵatanjile achi chitagu chi. ");
INSERT INTO yao_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mundu jwakulima ŵajawile kukumisa mbeju syakwe. Paŵamisaga sine syapatuchile mwitala ni uŵajesile mwitala mo ŵasiliŵete ni ijuni yalile. ");
INSERT INTO yao_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mbeju sine syapatuchile palitaka lyalili ni maganga ni pasyamesile syanyasile ligongo litaka nganilikola meesi. ");
INSERT INTO yao_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sine syapatuchile pasikati miiŵa. Jele miiŵa jo jamesile pamo nasyo ni kusiŵijikanya. ");
INSERT INTO yao_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mbeju sine syapatuchile palitaka lyambone ni syamesile ni kusogola ni jili jose jasogwele pwela.” Che Yesu paŵamalisisye gelego, ŵanyanyisye, “Ŵaali ni mapikanilo, gakupilikana apilikane!” ");
INSERT INTO yao_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ŵakulijiganya ŵao ŵausisye Che Yesu malumbo ga chele chitagu cho. ");
INSERT INTO yao_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nombe ŵajanjile, “Ŵanyamwe mpegwile kumanyilila yantemela ya umwenye wa Akunnungu, nambo kwa ŵanewo ngwamba, ŵelewo akusalilwa kwa itagu kuti pakulola anakombole kulola ni pakupilikana anaimanyilile. ");
INSERT INTO yao_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nipele, malumbo ga chitagu chi ni aga, Mbeju lili liloŵe lya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Chachikukopochela kwa mbeju sisyapatuchile mwitala sila chikulandana ni chitagu cha ŵandu ŵakulipilikana liloŵe lya Akunnungu ni Shetani akwika ni kulityosya mu mitima jao kuti akakulupilila ni kukulupuswa. ");
INSERT INTO yao_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nombe chachikukopochela kwa mbeju sisyapatuchile palwala sila, chikulandana ni chitagu cha ŵandu ŵakupilikana liloŵe lya Akunnungu akulipochela kwa sangalala. Nambo mpela asila mbeju sila, ŵele ŵanduwo ngakukola michiga pakuŵa akukulupilila katema kanandi ni pakulinjikwa akulekanga kulupilila. ");
INSERT INTO yao_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sooni chachikukopochela kwa mbeju sisyapatuchile pa miiŵa sila chikulandana ni chitagu cha ŵandu ŵakupilikana liloŵe lya Akunnungu, nambo mbolembole akuŵijikanywa ni lipamba ni ipanje ni upoche wa pachilambo. Ŵele ŵandu wo isogosi yao ngaikukomala. ");
INSERT INTO yao_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ni chachikukopochela kwa mbeju sisyapatuchile pa chaajila sila chikulandana ni chitagu cha ŵandu ŵakupilikana liloŵe lya Akunnungu ni kulikamulisya kwa ntima wambone ni wakukunda. Ŵandu wo akupililila ni kumbesi kusogola isogosi yambone. ");
INSERT INTO yao_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ŵandu ngakupamba lumuli ni kuluunichila ni lulo pane kuluŵika kuusi chindanda. Nambo akuluŵika pachanya chindu chakuŵichila lumuli kuti ŵakwinjila mwelemo akombole kulola lulanga lwakwe. ");
INSERT INTO yao_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Chachilichose chachisisikwe, chichiŵichikwe pakulanguka ni chachilichose cheunichile chichiŵe cheunukulikwe ni kuŵichikwa pakulanguka. ");
INSERT INTO yao_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nipele nlilolechesye ni upilikane wenu, pakuŵa jwakwete chindu chajonjechekwe nambo jwanganakola chindu, chasumulwe atamuno kanandi chakuchiganisya kuti akwete.” ");
INSERT INTO yao_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pelepo achikulugwe ni achapwakwe Che Yesu ŵajawile kukwalola, nambo nganakombola kwaŵandichila ligongo lya winji wa ŵandu. ");
INSERT INTO yao_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mundu jumo ŵansalile Che Yesu kuti, “Achikulu ŵenu ni achapwenu alinji paasa, akusaka kunnola.” ");
INSERT INTO yao_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nambo Che Yesu ŵaasalile ŵandu wose, “Achikulu ŵangu ni achapwanga ali ŵeŵala ŵakupilikana liloŵe lya Akunnungu ni kulikamula.” ");
INSERT INTO yao_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sooni lyuŵa limo Che Yesu ŵajinjile mu ngalaŵa ni ŵakulijiganya ŵao, ŵaasalile, “Tujaule peesi litanda.” Nipele, ŵatandite ulendo. ");
INSERT INTO yao_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Paŵaliji mu ngalaŵa Che Yesu ŵaliji ni lugono ni ŵagonile. Nipele jatandite kupuga mbungo jekulungwa ni gatandite kwinjila meesi mu ngalaŵa ni ŵaliji mu chakogoya. ");
INSERT INTO yao_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ŵakulijiganya ŵala ŵajaulile Che Yesu kukwajimusya achitiji, “Ambuje, Ambuje! Tulinkwasika!” Che Yesu ŵajimwiche ni kujikalipila mbungo jekulungwa ni matumbela ga meesi, yose yamyalele ni kwaliji kutulele. ");
INSERT INTO yao_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ni sooni ŵaasalile, “Chikulupi chenu chili kwapi?” Nambo ŵanyawo ŵasimosile ni kamulwa ni lipamba ni kusalilana jwine ni jwine, “Mundu ju ali jwanti uli? Pakuŵa akujilamula namuno mbungo jekulungwa ni matumbela ga meesi ni yose ikwapilikanila.” ");
INSERT INTO yao_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Che Yesu pamo ni ŵakulijiganya ŵao ŵajendelechele ni ulendo ni ŵaiche ku mbwani ja chilambo cha Ŵagelasi chachili peesi litanda lyaliŵandikene ni ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Che Yesu paŵatulwiche mu ngalaŵa ni kuliŵata mbwani, mundu jumo jwa musi ula juŵaliji ni masoka ŵannyichilile. Nambo mundu jo kwa moŵa gamajinji nganatakulaga namose nganatamaga mu nyuumba nambo ŵatamaga mu mbugu sya kusichila ŵandu. ");
INSERT INTO yao_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Paŵammweni Che Yesu ŵalisile, ŵaligwisisye paasi paujo pao ni kunyanyisya, “Mmwejo, Che Yesu Mwana jwa Akunnungu Ŵakulu, nkusaka ichichi kwangune? Ngunchondelela ngasimulagasya!” ");
INSERT INTO yao_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ŵaŵechete yeleyo pakuŵa Che Yesu ŵalikalipile lisoka linkopoche mundu jo. Lyele lisoka lyo lyaliji nkunkamula mundu jo kaŵilikaŵili, natamuno ŵandu ŵambisile nkati ni kwataŵilisya makono ni makongolo ni unyolo ni magwedegwede, nambo ŵakutulaga nyolo syo ni magwedegwede ni lisoka lyo lyanjausyaga mwipululu. ");
INSERT INTO yao_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Che Yesu ŵammusisye, “Liina lyenu ŵaani?” Ŵajanjile, “Liina lyangu lili ‘Mpingo.’ ” Ŵajanjile yeleyo pakuŵa ŵaliji ni masoka gamajinji. ");
INSERT INTO yao_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Gele masoka go gaachondelele kuti ngasiŵajausya mu lisimbo lyangali mbesi. ");
INSERT INTO yao_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pele paliji ni mpingo wekulungwa wa maguluŵe galiji ganinkulya mungulugulu chitumbi. Masoka gala gaachondelele Che Yesu gajaule gakagajinjile maguluŵe. Nombe Che Yesu ŵagalesile gajaule. ");
INSERT INTO yao_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Masoka gankopweche mundu jo ni gajinjile mu maguluŵe ni mpingo wose wa maguluŵe waselelechele mu litanda lyalili chiŵandi ni chitumbi ni kutiŵila mu meesi. ");
INSERT INTO yao_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ŵakuchinga ŵala paŵaiweni yose yaitendekwe yo ŵautwiche, ŵajawile kukwasalila ŵandu ngani syo mu migunda ni misi. ");
INSERT INTO yao_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ŵandu ŵaiche kukulola iyakopochele. Ni ŵajaulile Che Yesu, ŵansimene mundu jugantyosile masoka jo ali atemi chiŵandi ni makongolo ga Che Yesu, ali awasile nguo ni ali ni lunda lwambone, nombewo ŵajogwepenje. ");
INSERT INTO yao_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ŵandu uŵalolite jele ngani jininkukopochela ŵaasalile ŵanyawo iŵatite pakulamwa mundu jwakamwilwe ni masoka jo. ");
INSERT INTO yao_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ni ŵandu wose ŵa chilambo cha ku Gelasi chila ŵakamwilwe ni lipamba lyekulungwa. Nipele ŵaachondelele Che Yesu atyoche, nombe Che Yesu ŵakwesile sooni mu ngalaŵa ni kwaula. ");
INSERT INTO yao_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mundu jugankopweche masoka jula ŵaachondelele Che Yesu kuti alongane nawo. Nambo Che Yesu ŵanlanjile, ni ŵansalile, ");
INSERT INTO yao_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mmuje kumusi nkasale yose yatesile Akunnungu kukwenu.” Nipele, mundu jula ŵajawile ni kwenesya mu musi wose indu yose iŵapanganyichiswe ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Che Yesu paŵajombweche litanda ni kwaula kwine, mpingo wa ŵandu ŵapochele, pakuŵa wose ŵaliji nkwalindilila. ");
INSERT INTO yao_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pelepo ŵaiche mundu jumo liina lyakwe che Yailo, juŵaliji chilongola jwa nyuumba ja kupopelela, ŵatindiŵele pa makongolo ga Che Yesu ni ŵaachondelele kuti ajaule kumangwao, ");
INSERT INTO yao_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","pakuŵa mwali jwao jwajika pe jwa yaka mpela kumi na mbili ŵaliji nkulwala chiŵandika kuwa. Che Yesu paŵaliji nkwaula, ŵandu ŵaliji nkwaŵijikanya kosekose. ");
INSERT INTO yao_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nipele paliji ni jwankongwe jumo mumpingo wa ŵandu mula, juŵalwalaga magono kwa yaka kumi na mbili, juŵamasile chipanje chakwe chose kwa ŵamitela ni ngapagwa juŵankombwele kunnamya. ");
INSERT INTO yao_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jwankongwe jo ŵannyichilile Che Yesu kunyuma ni ŵakwaiye lujenje lwa mwinjilo wao. Papopo ŵalamile magono. ");
INSERT INTO yao_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Che Yesu ŵausisye achitiji, “Ana ŵaani ŵangwaiye?” Wose ŵatite ngapagwa mundu jwankwaiye. Nombe che Petulo ŵatite, “Ambuje, mpingo wa ŵandu unsyungwile ni kummijikanya!” ");
INSERT INTO yao_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nambo Che Yesu ŵatite, “Apali mundu jwangwaiye, nguimanyilila pakuŵa machili gangopweche.” ");
INSERT INTO yao_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jwankongwe jula paŵaiweni kuti ngakukombola kulisisa, ŵalikopwesye achitetemelaga kwa lipamba ni ŵatindiŵele paujo pa Che Yesu. Pelepo ni ŵasasile mmbujo mwa wose ligongo lya kwakwaya Che Yesu ni iŵatite pakulamwa kwanakamo. ");
INSERT INTO yao_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Che Yesu ŵansalile jwankongwe jula kuti, “Mwanangu, chikulupi chenu chinnamisye. Njaule kwa chitendewele.” ");
INSERT INTO yao_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Che Yesu akanaŵe kumalisya kuŵecheta jwaiche mundu jumo kutyochela ku nyuumba ja chilongola jula kukwasalila che Yailo kuti, “Mwanagwenu awile, nkapunda kunsausya jwakwiganya.” ");
INSERT INTO yao_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nambo Che Yesu paŵapilikene yeleyo ŵaasalile che Yailo, “Kasinjogopa, ngambe kukulupilila, nombewo chalame.” ");
INSERT INTO yao_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Paŵaiche pa nyuumba po nganansalila mundu jwine kuti ajinjile pamo nawo, ikaŵe che Petulo ni che Yohana ni che Yakobo ni achikulugwe ni atatigwe mwali jo. ");
INSERT INTO yao_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ŵandu wose ŵaliji nkulila ni kwalilila malilo. Nambo Che Yesu ŵaasalile ŵanyawo, “Mmyalale, pakuŵa nganawa nambo agambile gona pe!” ");
INSERT INTO yao_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ni ŵanyawo ŵansechile pakuŵa ŵaimanyililaga kuti awile. ");
INSERT INTO yao_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nambo Che Yesu ŵankamwile nkono mwali jula ni kummilanga “Mwanangu njimuche!” ");
INSERT INTO yao_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Umi wao waujilile ni papopo ŵajimi. Ni Che Yesu ŵaasalile kuti ŵape chakulya. ");
INSERT INTO yao_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Achaŵelesi ŵao ŵasimosile nnope nambo Che Yesu ŵaakanyisye kuti akansalila mundu jwalijose yaitendekweyo. ");
INSERT INTO yao_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Che Yesu ŵaaŵilasile pamo ŵakulijiganya ŵao kumi na mbili, ŵapele machili ni ulamusi wa kugakoposya masoka gose ni kulamya ilwele. ");
INSERT INTO yao_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ŵatumile ajaulangane kukwalalichila ŵandu Umwenye wa Akunnungu ni kwalamya ŵakulwala. ");
INSERT INTO yao_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ŵasalile, “Nkajigala chindu chachili chose mulendo atamuno ntindiso atamuno nsaku atamuno chakulya atamuno mbiya atamuno iwalo iŵili. ");
INSERT INTO yao_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyuumba jajili jose jichinkajinjile ni kumpochela nlonjele pelepo, mpaka pachintyoche musi wo. ");
INSERT INTO yao_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ŵandu akanaga kumpochela, ntyochanje mu musi mo nombe ŵanyamwe pachintyoche nkung'unde luundu mmakongolo mwenu kulosya kuti achinsyene asagwile kuukana utenga wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nipele, ŵatandite ulendo, ŵapitaga msinda ni msinda ŵalalichilaga Ngani Jambone ni kwalamya ŵakulwala pali pose. ");
INSERT INTO yao_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ni chilongola che Helode ŵapilikene indu yose iyatendekwe ni ŵakanganiche pakuŵa ŵane ŵatiji, “Che Yohana Ŵakubatisya ŵala asyuchile!” ");
INSERT INTO yao_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nambo ŵane ŵatiji che Elia ŵala atyochele ni ŵane ŵatiji kuti jumo jwakwe jwa ŵakulondola ŵa Akunnungu ŵakalakala asyuchile. ");
INSERT INTO yao_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nambo che Helode ŵatite, “Ŵele che Yohana wo ngati nakatile ntwe sambano ŵele ni ŵaani ungupilikana ngani syakwesi?” Nipele ŵansosaga kuti ŵawone. ");
INSERT INTO yao_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Achinduna ŵala paŵausile, ŵaŵalanjile Che Yesu yose yaitesile. Che Yesu ŵaajigele ŵanyawo, ŵajawile pajika mu musi waukuŵilanjikwa Besesaida. ");
INSERT INTO yao_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nambo mpingo wa ŵandu ula paŵaimanyi kuŵajawile, ŵakuiye. Nombe Che Yesu ŵapochele ni ŵaŵechete nawo ya umwenye wa Akunnungu ni kwalamya ŵaŵasachile kulamwa. ");
INSERT INTO yao_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lyuŵa palyatandite kutiŵila, ŵakulijiganya kumi na mbili ŵala ŵanjaulile Che Yesu kukwasalila kuti, “Mwalanje ŵandu ajaulangane mu misi ni migunda jakuŵandichila akasose yakulya ni pagona, pakuŵa patuli pa pali pajika.” ");
INSERT INTO yao_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nambo Che Yesu ŵaasalile, “Ŵanyamwe mwape ŵanyawo chindu chakulya.” Nipele ŵajanjile, “Nganitukola yakupunda nambo tukwete mikate nsano ni somba siŵili pe. Panepa tujaule tukaasumile yakulya mpingo wose wu?” ");
INSERT INTO yao_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ŵandu uŵaliji pepala, ŵaliji achalume mpela elufu tano. Nipele Che Yesu ŵaasalile ŵakulijiganya ŵao kuti, “Mwatamiche paasi mipingo ja ŵandu mpela hansinihansini.” ");
INSERT INTO yao_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ŵakulijiganya ŵao ŵatesile mpela iŵatite pakusalilwa ni ŵatamiche wose. ");
INSERT INTO yao_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nipele Che Yesu ŵajigele mikate nsano jila ni somba siŵili sila ni ŵalolite kwinani ni kwatogolela Akunnungu ni kwipa upile ni kugaŵanya, ŵapele ŵakulijiganya ŵao kuti ŵapeleganye ŵandu. ");
INSERT INTO yao_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ŵandu wose ŵalile ni kwikuta. Ŵalokotenye isigasi ya mbakatika ni kugumbasya itundu kumi na mbili. ");
INSERT INTO yao_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lyuŵa limo, Che Yesu ŵaliji nkupopela jika pe ni ŵakulijiganya ŵao ŵaliji pachiŵandi. Nipele ŵausisye ŵanyawo, “Ana ŵandu akuti une ndili ŵaani?” ");
INSERT INTO yao_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ŵajanjile, “Ŵane akuti mmwejo ni che Yohana Ŵakubatisya ni ŵane akuti che Elia ni ŵane akuti jumo jwao ŵakulondola ŵakalakala ŵa Akunnungu asyuchile.” ");
INSERT INTO yao_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pelepo ŵausisye ŵanyawo, “Nombe ŵanyamwe nkutinji une ndili ŵaani?” Che Petulo ŵajanjile, “Mmwejo ni Kilisito Nkulupusyo chilanga chiŵalanjile Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Che Yesu ŵalamwile ŵanyawo ni kwakanya kuti akasala kwa mundu jwalijose jele ngani jo. ");
INSERT INTO yao_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ŵapundile kuŵecheta kuti Mwana jwa Mundu akusachilwa kulaga nnope ni kukanikwa ni achachekulu ni achakulu ŵambopesi ni ŵakwiganya Malajisyo ga che Musa ni kuulajikwa nambo lyuŵa lyaatatu lya chiwa chao chachisyuka. ");
INSERT INTO yao_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nipele, ŵaasalile ŵandu wose kuti, “Mundu jwalijose jwakusaka kuunguya akusachilwa alikane nsyene ni atwichile nsalaba wakwe moŵa gose ni kunguya. ");
INSERT INTO yao_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pakuŵa jwalijose jwakusaka kuukulupusya umi wakwe chaujase ni jwalijose juchaujase umi wakwe ligongo lyangune, jwelejo chaukulupusye. ");
INSERT INTO yao_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ana mundu chapate chichi, aŵaga ni ipanje yose ya pachilambo kwa kulijasa natamuno kulijonanga nsyene? ");
INSERT INTO yao_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pakuŵa mundu jwalijose jutachingolela soni une ni majiganyo gangu, Mwana jwa Mundu tachinkolela soni mundu jo pachachiika mu ukulu wakwe ni wa Atati ni wa achikatumetume ŵa kwinani ŵaswela. ");
INSERT INTO yao_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngunsalila isyene kuti, apali ŵane mwa ŵanyaŵa ngaawa pangauwona Umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Galiji moŵa nane paŵamasile kuŵecheta gelego, Che Yesu ŵaajigele che Petulo ni che Yohana ni che Yakobo, ŵakwesile nawo pa chitumbi kukupopela. ");
INSERT INTO yao_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Paŵaliji nkupopela, kuloleka kwa ku meeso kwao kwagalawiche ni iwalo yao yaliji yeswela ni kung'alima nnope. ");
INSERT INTO yao_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Papopo ŵandu ŵaŵili ŵaoneche aninkukunguluka nawo, nombe ŵandu wo ŵaliji che Elia ni che Musa, ");
INSERT INTO yao_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ŵaŵakopochele ali ni ukulu, uŵaŵechetaga nawo Che Yesu yankati ichiyaakopochele ku Yelusalemu ko kuti agumbalichisye yailembekwe nkati ŵelewo. ");
INSERT INTO yao_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Che Petulo ni achinjakwe ŵatopelwe ni lugono, nambo paŵajimwiche, ŵauweni ukulu wa Che Yesu ni ŵandu ŵaŵili uŵajimi nawo. ");
INSERT INTO yao_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ŵandu ŵaŵili wo paŵaliji aninkulekangana ni Che Yesu, che Petulo ŵaasalile Che Yesu, “Ambuje, ili yambone uwe kutama apano! Tutaŵe masakasa gatatu, limo lyenu ni limo li che Musa ni line li che Elia.” Nganaimanyililaga chaŵaŵechetaga cho. ");
INSERT INTO yao_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Che Petulo paŵaliji aninkuŵecheta yeleyo, liunde lyaichilile ni ŵakulijiganya ŵala ŵajogwepe pakuŵa liunde lyo lyaliji lininkwaichilila. ");
INSERT INTO yao_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lyakopochele liloŵe mwiunde mula, lichitiji, “Aju ni Mwanangu junansagwile, mumpilikanichisye.” ");
INSERT INTO yao_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Palyamasile kupilikanika liloŵe lyo, Che Yesu ŵaoneche ali jika pe. Ŵakulijiganya ŵao ŵamyalele ni nganansalila mundu jwalijose gele moŵa go yankati yele yose iŵaiweni yo. ");
INSERT INTO yao_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Malaŵi jakwe Che Yesu ni ŵakulijiganya ŵatatu ŵala paŵaliji aninkutuluka mwitumbi, mpingo wekulungwa wa ŵandu ŵaichilile. ");
INSERT INTO yao_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mundu jumo mu mpingo mwa ŵandu mula ŵanyanyisye achitiji, “Jwakwiganya, ngunchondelela munkolele chanasa mwanangu ju pakuŵa ali mwanangu jwa jika pe! ");
INSERT INTO yao_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nnole lisoka lyakwe likusomoka ni chitema pe likuntenda agumile ni kuntaga njilinjili ni kunkopoka chiulo nkang'wa. Likupunda kunnagasya nnope ni ngalikunneka kwakwepepala. ");
INSERT INTO yao_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nipele, nachondelele ŵakulijiganya ŵenu kuti akalityosye, nambo nganakombolanga.” ");
INSERT INTO yao_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Che Yesu ŵajanjile, “Ŵanyamwe uŵelesi wangali chikulupi, ni ŵakusochela, chindame ni ŵanyamwe ni kumpililila mpaka chaka chi?” Nipele, Che Yesu ŵansalile mundu jo kuti, “Munjise nawo apano mwanagwenu jo.” ");
INSERT INTO yao_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Katema jwele mwanache jo paŵaliji aninkwaichilila Che Yesu, lisoka lila lyangwisisye paasi ni kuntaga njilinjili. Nambo Che Yesu ŵalikalipile lisoka lila ni kunnamya mwanache ni kwauchisya atatigwe. ");
INSERT INTO yao_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ŵandu wose ŵasimosile nnope kugalola machili gamakulungwa ga Akunnungu. Ŵandu ŵala paŵaliji nkusimonga yankati yose yaitesile, Che Yesu ŵaasalile ŵakulijiganya ŵao, ");
INSERT INTO yao_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ngasinliŵalila chingusaka kuŵecheta ni ŵanyamwe chi, Mwana jwa Mundu chatagwe mmakono ga ŵandu.” ");
INSERT INTO yao_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nambo ŵanyawo nganagamanyilila malumbo ga maloŵe gaŵaŵechete. Lyele lyaliji lyakusisika kwa ŵanyawo kuti anamanyichisye, nombe ŵanyawo ŵajogwepe kwausya malumbo ga maloŵe go. ");
INSERT INTO yao_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gatyochele makani kwa ŵakulijiganya ŵala gati ŵaani ŵaali ŵakulungwa kupunda achinjakwe. ");
INSERT INTO yao_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nambo Che Yesu ŵasimanyilile nganisyo sisyaliji mmitima jao nipele ŵanjigele mwanache jwannandi ni ŵanjimiche chiŵandika nawo, ");
INSERT INTO yao_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ŵaasalile, “Mundu jwalijose jwakumpochela aju mwanache jwannandi ju kwa liina lyangu, jwelejo akumbochela une ni jwalijose jwakumbochela une, akumpochela jwelejo jwandumile une. Pakuŵa jwali jwannandi kupunda wose pasikati jenu, jwelejo ni jwali jwankulungwa.” ");
INSERT INTO yao_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Che Yohana ŵaŵechete kuti, “Ambuje, tummweni mundu jumo achikoposyaga masoka mu liina lyenu nombe uweji twalinjile kunnekasya ligongo jwelejo nganaŵa jumo jwetu.” ");
INSERT INTO yao_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nambo Che Yesu ŵaasalile ŵanyawo kuti, “Nkannekasya, pakuŵa jwalijose jwangankanila ŵanyamwe, jwelejo ali pamo ni ŵanyamwe.” ");
INSERT INTO yao_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nipele, pagaŵandichile moŵa ga Che Yesu kujigalikwa kwinani ŵasachile kwaula ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ŵatumile ŵantenga ŵalongolele, nombewo ŵajawile ni kwinjila mu musi umo wa Ŵasamalia kukuŵika chile indu yose kwa ligongo lyao. ");
INSERT INTO yao_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nambo ŵandu ŵa wele musi wo ŵakanile kumpochela ligongo ŵaimanyilile kuti ŵasachile kwaula ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Katema ŵakulijiganya ŵakwe paŵaiweni yeleyo, che Yohana ni che Yakobo ŵatite, “Ambuje, ana nkusaka tuŵilasye mooto kutyochela kwinani kuti wajonanje ŵanyaŵa?” ");
INSERT INTO yao_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nambo Che Yesu ŵagalauchile ŵanyawo ni kwakalipila. ");
INSERT INTO yao_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Che Yesu ni ŵakulijiganya ŵao ŵatyosile ni kwaula kunsinda wine. ");
INSERT INTO yao_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Paŵaliji mu ulendo, mundu jumpepe ŵansalile Che Yesu kuti, “Chinankuye kwakulikose kuchinjaule.” ");
INSERT INTO yao_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Che Yesu ŵatite, “Macheto gakwete masomwa ni ijuni ikwete isusi, nambo Mwana jwa Mundu nganakola pagona ni kupumulila.” ");
INSERT INTO yao_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nipele, ŵansalile mundu jwine kuti, “Munguye.” Nambo jwelejo ŵatite, “Ambuje, muuneche kaje nyaule ngaasiche atati ŵangu.” ");
INSERT INTO yao_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nambo Che Yesu ŵansalile jwelejo kuti, “Mwaleche ŵawe ŵaasiche ŵawe ŵao, nambo mmwejo njaule nkalalichile ngani ja Umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ni mundu jwine ŵansalile Che Yesu kuti, “Ambuje chinankuye, nambo muuneche kaje ngaalanje ŵaali kumusi kwangu ŵala.” ");
INSERT INTO yao_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nambo Che Yesu ŵajanjile, “Jwalijose jwakamwile lijela ni kotama kulima agalaukaga ni kulola panyuma, jwelejo ngakuŵajilwa mu Umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagamasile gelego, Ambuje ŵaasagwile ŵakulijiganya sabini na mbili. Ni ŵaatumile ŵakulijiganya ŵaŵili ŵaŵili ŵalongolele paujo pao pa misinda jilijose ni kulikose kuŵasachile nsyene kwaula. ");
INSERT INTO yao_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ŵasalile ŵanyawo kuti, “Magungulo gali gamajinji nambo ŵakugungula ali kanandi. Nipele mwaŵende asyene ngunda kuti ŵatume ŵakugungula mu ngunda mwao. ");
INSERT INTO yao_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sambano njaulangane, mmanyilile kuti nguntuma ŵanyamwe mpela mwanangondolo pasikati masogo. ");
INSERT INTO yao_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ngasinjigala chilolo pane nsaku pane ilatu ine, nkankomasya mundu jwalijose mwitala. ");
INSERT INTO yao_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mwajinjilaga mu nyuumba jajili jose, mwakomasye yelei kaje, ‘Chitendewele chipagwe mu nyuumba ji!’ ");
INSERT INTO yao_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Iŵaga chapagwe jwakunonyelwa ni chitendewele mwelemo, chitendewele chenu chichitame najo, nambo iŵaga ngapagwa jwachitendewele, chitendewele chichimbujile kukwenu sooni. ");
INSERT INTO yao_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nlonjele pa nyuumba jo nchilyaga ni kung'wa yakumpanga, pakuŵa jwakupanganya masengo akuŵajilwa mbote. Ngasinsama nyuumba ji kwaula nyuumba jo. ");
INSERT INTO yao_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mwaikaga mmusi wauli wose ni kumpochela, nlyanje yaili yose yakumpa. ");
INSERT INTO yao_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mwalamye ŵandu ŵakulwala ŵaali kweleko, mwasalile, ‘Umwenye wa Akunnungu uŵandichile kukwenu.’ ");
INSERT INTO yao_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nambo mwajinjilaga mmusi wauli wose ni akanaga kumpochela, ntyoche, nomwe pankupita mmatala gao nkajileje, ");
INSERT INTO yao_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Atamuno luundu lwa pamusi wenu lwalunyambatile pa sajo syetu, tukumpatila ŵanyamwe kulosya kuti mwachinsyene nsagwile kuukana utenga wa Akunnungu. Nambo, mmanyilile kuti, umwenye wa Akunnungu uŵandichile.’ ");
INSERT INTO yao_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngunsalila kuti, pa lyuŵa lya malamulo magambo ga ŵandu wa musi wo chigaŵe gamakulungwa kupunda magambo ga ŵandu ŵa ku Sodoma. ");
INSERT INTO yao_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ulaje uŵe kukwenu, ku Kolasini! Ulaje uŵe kukwenu, ku Besesaida! Pakuŵa, iŵaga yakusimosya iyatendekwe kukwenu, ikatendekwe ku Tilo ni ku Sidoni kula, ŵandu ŵa kwele kalakala pe akatemi paliu ali atakwile magunia ni kulitaga liu muntwe kulosya kuti alesile sambi syao. ");
INSERT INTO yao_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nambo pa lyuŵa lya malamulo magambo genu chigaŵe gamakulungwa kupunda magambo ga ku Tilo ni ku Sidoni. ");
INSERT INTO yao_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ni mmwejo Kapelenaumu, ana nkuganisya kuti chinlikusye mpaka kwinani? Ngwamba chinchituluswa mpaka kwiuto kwa ŵandu ŵawile.” ");
INSERT INTO yao_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nipele Che Yesu ŵapundile kwasalila ŵakulijiganya ŵao kuti, “Jwakumpilikana ŵanyamwe, akumbilikana une, jwakumpochela ŵanyamwe akumbochela une. Ni jwalijose jwakukana kumbochela une, akwakana ŵandumile une.” ");
INSERT INTO yao_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kanyuma ŵakulijiganya sabini ŵausile achisengwaga, achitiji, “Ambuje, atamuno masoka gatujitichisye kwa liina lyenu.” ");
INSERT INTO yao_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ŵelewo ŵaasalile ŵanyawo kuti, “Nambweni Shetani yatiteje pakugwa mpela njasi kutyochela kwinani. ");
INSERT INTO yao_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Elo, nampele ulamusi wa kuliŵata majoka ni makoloto ni ulamusi wa pachanya machili gose ga jwammagongo ni ngapagwa chindu chachili chose chakummenga. ");
INSERT INTO yao_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nambo nkasechelelela ligongo lyakuti masoka ganjitichisye, nambo nsechelele ligongo lya meena genu galembikwe kwinani.” ");
INSERT INTO yao_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Katema kakoko peko, Che Yesu ŵasangalele kwa ulamusi wa Mbumu jwa Akunnungu, ŵatite, “Nguntogolela Atati, Ambuje ŵa kwinani ni chilambo, pakuŵa mwasisile yelei ŵa lunda ni ŵa umanyilisi ni kwaunukulila ŵanache. Elo, Atati, pakuŵa yeleyi ni yaitite pakunnonyela.” ");
INSERT INTO yao_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nipele ŵatite, “Atati ŵangu ambele une indu yose. Ngapagwa jwakummanyilila Mwana akaŵe Atati, ni Atati akaŵe Mwana, ni jwalijose jwakunsaka Mwana akumbunukulila.” ");
INSERT INTO yao_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nipele Che Yesu ŵagalauchile ŵakulijiganya ŵao ni kuŵecheta nawo kwantemela kuti, “Nkwete upile ŵanyamwe kwakwiwona inkwiwona yi. ");
INSERT INTO yao_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngunsalila kuti ŵakulondola ŵa Akunnungu ni mamwenye ŵasachile kwiwona inkwiwona ŵanyamwe nambo nganaiwona ni kupilikana inkwipilikana ŵanyamwe, nambo nganaipikana.” ");
INSERT INTO yao_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kanyuma, jwakwiganya Malajisyo jumo ŵajimi ni kwausya Che Yesu kwa kwalinga achitiji, “Jwakwiganya, ana ndende chichi pakuti ngole umi wa moŵa gose pangali mbesi?” ");
INSERT INTO yao_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Che Yesu ŵambusisye kuti, “Ana ilembechekwe chichi mu Malajisyo che Musa? Ana nkusyoma chichi mwelemo?” ");
INSERT INTO yao_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ŵajanjile, “Mwanonyele Ambuje Akunnungu ŵenu ni ntima wenu wose ni uumi wenu wose ni machili genu gose ni umanyilisi wenu wose ni njenu mpela mwasyene.” ");
INSERT INTO yao_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Che Yesu ŵansalile, “Njanjile uchenene! Ntendeje yeleyo, nomwe chinkole umi.” ");
INSERT INTO yao_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nambo ŵelewo, ŵasachile kuliŵalanjila kuti akuchimanyilila chakuusya cho, ŵausisye Che Yesu, “Ana njangu jo ni ŵaani?” ");
INSERT INTO yao_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Che Yesu ŵajanjile, “Jwapali mundu jumo jwaŵaumilaga ku Yelusalemu kutuluchila ku Yeliko. Paŵaliji mwitala, ŵasimene ŵachiswamba ni ŵambusile iwalo yakwe ni kumputa ni ŵatyosile ni kunneka achiŵandichilaga kuwa. ");
INSERT INTO yao_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pangalolela, jwambopesi jumo ŵaliji nkupita mulamula mwitala mula, nambo paŵambweni ni ŵasepwiche pambali ni kwaula. ");
INSERT INTO yao_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Iyoyo peyo, Mlawi jumo paŵaiche pelepo ŵambweni, ni ŵasepwiche pambali ni kwaula. ");
INSERT INTO yao_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nambo Msamalia jumo juŵaliji muulendo ŵaiche pepala paŵaliji mundu jula, nombe paŵambweni ŵambonele chanasa. ");
INSERT INTO yao_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nipele, ŵanjaulile, ŵagajosisye maŵanga gao kwa mauta ni divai ni kugataŵa maŵanga, paŵamasile kutenda yeleyo ŵanjigele pa chinyama chakwe, ni ŵanjawisye kukwalwasya mu nyuumba ja achalendo. ");
INSERT INTO yao_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Malaŵi jakwe ŵatyosisye lupia siŵili sya mbiya, ŵampele jwakujigosa nyuumba jila ni ŵansalile kuti, ‘Munlwasye mundu ju ni chachili chose chachichipunde kwa jweleju, chinjilipila une pachimuje.’ ” ");
INSERT INTO yao_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Che Yesu ŵausisye, “Mwa ŵele ŵatatu wo, ŵaani ŵalosisye kuti ali njakwe mundu juŵaputikwe ni ŵachiswamba?” ");
INSERT INTO yao_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jwakwiganya Malajisyo jula ŵajanjile, “Jwejula juŵankolele chanasa jula.” Che Yesu ŵansalile, “Njaule nkatende iyoyo peyo.” ");
INSERT INTO yao_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Che Yesu ni ŵakulijiganya ŵao paŵaliji muulendo, ŵaiche kunsinda umo ni jwankongwe jumo liina lyao che Masa ŵampochele kumangwao. ");
INSERT INTO yao_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Che Masa ŵaliji ni mpwakwe liina lyao che Maliamu, jweleju ŵatemi chiŵandi ni Ambuje Che Yesu achipikanilaga majiganyo gao. ");
INSERT INTO yao_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nambo che Masa ŵaliji nkuchenjeuka ni masengo gamajinji. Nipele ŵajaulile Che Yesu kukwasalila achitiji, “Ambuje, ana ngankulola kuti apwanga anesile une mbanganye masengo jika? Mwasalile aiche kukungamusya.” ");
INSERT INTO yao_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nambo Ambuje ŵajanjile kuti, “Che Masa, che Masa, nkuchenjeuka ni kulisausya ni yejinji. ");
INSERT INTO yao_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nambo chipali chindu chimo pe chachikusachikwa. Che Maliamu asagwile liunjili lyambone ni sooni ngapagwa mundu juchachityosye kukwakwe.” ");
INSERT INTO yao_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lyuŵa limo, Che Yesu ŵaliji nkupopela peuto pamo, paŵamasile, jumo jwa ŵakulijiganya ŵao ŵatite, “Ambuje, ntujiganye kupopela, kwati mpela che Yohana Ŵakubatisya iŵatite pakwajiganya ŵakulijiganya ŵao.” ");
INSERT INTO yao_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Che Yesu ŵaasalile, “Pankupopela, njileje yelei, ‘Atati, Liina lyenu lijinichilwe, Umwenye wenu uiche. ");
INSERT INTO yao_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ntupe chakulya chetu cha lyuŵa ni lyuŵa. ");
INSERT INTO yao_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ntulechelesye sambi syetu, pakuŵa uweji nombe tukwalechelesya wose ŵakutuleŵela. Ni sooni nkatujinjisya nkulinjikwa.’ ” ");
INSERT INTO yao_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ni Che Yesu ŵaasalile kuti, “Tujile jumo jwenu akwete ambusanga ni anjaulilaga pasikati chilo ni kunsalila, ‘Ambusanga, mungongosye mikate jitatu none chinambuchisye, ");
INSERT INTO yao_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","pakuŵa ambusanga ŵangu ali mu ulendo, asepuchile kumusi none nganingola chakwapa.’ ");
INSERT INTO yao_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nganichisye kuti ambusanga ŵenu akanjanjile ali nkati, ‘Nkaasausya une! Pakuŵa masile kuugala nnango. Une ni achiŵanangu tugonile ni ngangukombola kwimuka ni kumpa!’ ");
INSERT INTO yao_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Isyene ngunsalila kuti, ngaajimuka ni kwapa atamuno ali ambusanga gwao pe, nambo ligongo lya mundu jo ichajile pakupunda kwachondelela, chajimuche ni kwapa chachili chose chakuchisaka. ");
INSERT INTO yao_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Nipele none ngunsalila yakuti, mmende ni ŵanyamwe chimpegwe, nsose ni ŵanyamwe chinnyiwone, mpoposye ni ŵanyamwe chachimbugulila nnango. ");
INSERT INTO yao_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pakuŵa jwalijose jwakuŵenda akupegwa ni jwakusosa akupata ni jwakupoposya, nnango ukuugulikwa kwa ligongo lyakwe. ");
INSERT INTO yao_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ana, atati chi mwa ŵanyamwe, mwanache aŵendaga somba, chachiapa lijoka kuleka kwapa somba? ");
INSERT INTO yao_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pane ŵaŵendaga lindanda, ana chachapa likoloto? ");
INSERT INTO yao_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Chisau ŵanyamwe ŵangalumbana, nkumanyilila kwapa achiŵana ŵenu indu yambone, isyene Atati ŵenu ŵa kwinani chiŵape Mbumu jwa Akunnungu aŵala ŵakwaŵenda.” ");
INSERT INTO yao_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lyuŵa limo Che Yesu ŵaliji nkukoposya lisoka lilyantendekenye mundu anaŵechete. Pilyakopweche lisoka lyo, jwangaŵecheta jo, ŵakombwele kuŵecheta, ni mpingo wa ŵandu ŵasimosile. ");
INSERT INTO yao_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nambo ŵane mwa ŵelewo ŵatite, “Akugakoposya masoka kwa ulamusi wa Belesebuli, jwankulu jwa masoka.” ");
INSERT INTO yao_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ni ŵane ŵalinjile kwakwaŵenda ŵalosye chimanyisyo chakuti ulamusi wao utyochele kwinani. ");
INSERT INTO yao_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nambo Che Yesu, achimanyililaga ng'anisyo syao ni ŵaasalile ŵanyawo, “Ŵandu ŵa umwenye wauliwose aputanaga achinsyene pe wele umwenye wo chiugwe ni ŵandu wa nyuumba jajili jose ŵaputanaga achinsyene pe ŵandu ŵa nyuumba jo chajonasiche. ");
INSERT INTO yao_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nipele iŵaga Shetani akulikanila nsyene, umwenye wakwe chiulame? Nguti yeleyi pakuŵa ŵanyamwe nkuumecheta kuti ngugakoposya masoka kwa ulamusi wa Belesebuli. ");
INSERT INTO yao_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ŵakulijiganya ŵenu nombe akugakoposya masoka mpela inguti kupanganya une, iŵele uli menema musalile kuti ngugakoposya masoka kwa ulamusi wa Belesebuli? Nipele ŵanyawo ni utachinnamula ŵanyamwe. ");
INSERT INTO yao_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nambo iŵaga ngugakoposya masoka kwa ulamusi wa Akunnungu, nipele nnyimanyilile kuti Umwenye wa Akunnungu umasile kwika kukwenu. ");
INSERT INTO yao_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mundu jwali ni machili pakulindilila nyuumba jakwe ni yakumenyanila yakwe, ipanje yakwe yose chigosekwe. ");
INSERT INTO yao_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nambo aikaga jŵapundile machili ni kumputa, jwelejo akunsumula yakumenyanila yose iyaikulupililaga yo ni kuigaŵanya iŵasumwile. ");
INSERT INTO yao_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mundu jwalijose jwanganaŵa pamo ni une, akunganila ni mundu jwalijose jwangakusakulila pamo ni une, jwelejo akupwilinganya. ");
INSERT INTO yao_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Lisoka lyankopokaga mundu likusyungula syungula mwipululu mwangali meesi lichisosaga pakupumulila. Palikulepela likuti, ‘Chimujile ku nyuumba jangu kungopochela kula.’ ");
INSERT INTO yao_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Palikuujila, akujisimana nyuumba jila jili jepyajile ni mwekotopasye. ");
INSERT INTO yao_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nipele likwaula kukugajigala masoka gane saba gakusakala kupunda ŵelewo, gose gakwaula kukunjinjila mundu jula. Kumbesi kwakwe mundu jo akuŵa jwakusakala kupunda iŵaliji kundanda.” ");
INSERT INTO yao_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Che Yesu paŵaliji nkuŵecheta gelego, jumo jwa achakongwe jwa mumpingo mwa ŵandu mula, ŵanyanyisye liloŵe achitiji, “Jwana upile jwankongwe jwambeleche ni kunjonjesya jo!” ");
INSERT INTO yao_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nambo Che Yesu ŵaŵechete, “Nambo ŵana upile wakupunda ŵakulipilikanichisya liloŵe lya Akunnungu ni kwitichisya.” ");
INSERT INTO yao_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nipele, mpingo wa ŵandu paŵaliji nkoonjecheka, Che Yesu ŵatandite kusala, “Uŵelesi wu uli uŵelesi wa kusakala. Ukusaka chimanyisyo, nambo ngaupegwa chimanyisyo chachili chose ikaŵe chimanyisyo chi che Yona chila. ");
INSERT INTO yao_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mpela che Yona iŵaliji chimanyisyo cha ŵandu wa ku Ninawi ni iyoyo peyo Mwana jwa Mundu chachiŵa chimanyisyo kwa uŵelesi wu. ");
INSERT INTO yao_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Iyoyo peyo pa lyuŵa lyakulamulila Mwenye jwankongwe jwa ku Sheba chakopochele pamo ni ŵandu wa uŵelesi wu, nombewo chachisala kuti uŵelesi wu wanamagambo. Pakuŵa ŵelewo ŵaumile kwakutalichila, ŵaiche kukugapikanila maloŵe gambone ga lunda ga mwenye che Selemani, nambo pelepa apali jwankulu kupunda mwenye che Selemani. ");
INSERT INTO yao_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ŵandu ŵa ku Ninawi chakopochele pa lyuŵa lya malamulo lyo pamo ni ŵandu ŵa uŵelesi wu, nombewo chachisala kuti uŵelesi wu wanamagambo. Pakuŵa ŵandu ŵa ku Ninawi ŵalesile sambi ligongo lya kulalichilwa utenga wa Akunnungu ni che Yona, nambo pelepa kwana jwankulu kwapunda che Yona. ");
INSERT INTO yao_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ngapagwa mundu jwakupamba lumuli ni kulusisa pane kuluunichila ni lulo nambo akuluŵika pachanya chindu chakuŵichila lumuli, kuti ŵakwinjila mwelemo akombole kulola lilanguka lyakwe. ");
INSERT INTO yao_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lumuli lwa chiilu chenu luli liso lyenu, lyaŵaga lyansima, chiilu chenu chose chichiŵe mu lilanguka, nambo lyaŵaga ngaŵa lyansima, nombe chiilu chenu chichiŵe muchipi. ");
INSERT INTO yao_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nlilolechesye yambone kuti lilanguka lyalili nkati mwenu likaika kugalauka kuŵa chipi. ");
INSERT INTO yao_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nipele, iŵaga chiilu chenu chose chaŵaga ni lilanguka, pangali chiŵalo chachichiŵe pa chipi, chiilu cho chiching'alime yambone mpela lumuli lwalukuti pakunlanguchisya ni lilanguka lyakwe.” ");
INSERT INTO yao_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Che Yesu paŵamasile kusala yeleyo, Mfalisayo jumo ŵaalaliche kumangwao kuti akalye nawo chakulya, nombewo ŵajinjile ni kutama kulya. ");
INSERT INTO yao_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nambo Mfalisayo jo ŵansimosile Che Yesu kwawona alinkutama panganaŵa kaje chikanaŵe chakulya. ");
INSERT INTO yao_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pele Ambuje ŵansalile, “Ŵanyamwe Mafalisayo, nkosya ngao ni mbale kwa paasa, nambo nkati mwenu ngumbele chigongomalo ni ungalimate. ");
INSERT INTO yao_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ŵakuloŵela ŵanyamwe! Ana, ngaŵa Akunnungu ŵaŵapanganyisye paasa ni ŵaŵapanganyisye nkati mo? ");
INSERT INTO yao_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nambo mwapeje ŵandu ŵakulaga indu yaili nkati ngao ni mbale ni indu ine yose chiiŵe yambone kukwenu. ");
INSERT INTO yao_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nambo ulaje uŵe kukwenu ŵanyamwe Mafalisayo, pakuŵa nkwausya liunjili lya kumi namose pachanya masamba ga kununjila ga mimela gakunonyesya chakulya ni mchicha ni masamba gane gane ni kuleka kwapanganyichisya ŵandu yaikuŵajilwa ni kwanonyela Akunnungu. Mwaŵajilwe kukamulisya yaandanda yo pangaliŵalila yaaŵili yo. ");
INSERT INTO yao_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nambo ulaje uŵe kukwenu, ŵanyamwe Mafalisayo, pakuŵa ikunnonyela kutama mmbujo mu itengu ya achakulungwa mu mmajumba ga kupopelela ni kunkomasya kwa kuchimbichisya paŵachingangene ŵandu. ");
INSERT INTO yao_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ulaje uŵe kukwenu, pakuŵa nkulandana ni malembe gangali chilosyo, ŵandu akupita pachanya pakwe, pangaimanyilila.” ");
INSERT INTO yao_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jumo jwa ŵamalamulo ŵajanjile, “Jwakwiganya, pankusala yelei ngati nkutujalusya nowe ŵakwe.” ");
INSERT INTO yao_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Che Yesu ŵajanjile, “Ulaje uŵe kukwenu ŵanyamwe ŵakwiganya Malajisyo, pakuŵa nkwatwika ŵandu misigo jakutopela jangatwichilika ni mwachinsyene ngankujongola namose chala kwakamusya. ");
INSERT INTO yao_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ulaje uŵe kukwenu, pakuŵa nkugumba malembe ga ŵakulondola ŵa Akunnungu, ŵaŵaulajikwe ni achambuje ŵenu. ");
INSERT INTO yao_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iyoyo peyo ŵanyamwe nkuŵalanga ni kwitichisya masengo ga achambuje ŵenu pakuŵa ŵelewo ŵauleje ŵakulondola ŵa Akunnungu ni ŵanyamwe nkugumba malembe gao. ");
INSERT INTO yao_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ni kwaligongo lyo, lunda lwa Akunnungu lwatite, ‘Chinampe ŵakulondola ŵa Akunnungu ni achinduna, nambo ŵane mwa ŵanyawo chachaulaga ni ŵane ŵao chachalagasya.’ ");
INSERT INTO yao_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nipele uŵelesi uu chiuchilagaswa kwaligongo lya chiwa cha ŵakulondola ŵa Akunnungu ŵana wose ŵaŵaulegwe chitandile kupagwa chilambo, ");
INSERT INTO yao_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","chitandile kuulagwa ku che Habili kwichila che Sakalia, juŵaulegwe pasikati ja chilisa ni Nyuumba ja Akunnungu. Eloo, ngunsalila kuti, au uŵelesi uu chiuchilagaswa kwa yele isambo yo. ");
INSERT INTO yao_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ulaje uŵe kukwenu ŵanyamwe ŵakwiganya Malajisyo pakuŵa njigele chiugulilo cha nnango wa umanyilisi ni mwachinsyene nganinjinjila ni ŵaŵajinjilaga mwelemo mwalekasisye kuti akajinjila.” ");
INSERT INTO yao_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Che Yesu ŵatyosile mwelemo, chitandile pelepo ŵakwiganya Malajisyo ni Mafalisayo ŵatandite kwachima kwannope ni kwausya mausyo gamajinji. ");
INSERT INTO yao_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ŵasakaga ŵatanjisye kwa maloŵe gao. ");
INSERT INTO yao_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Katema kakoko ŵasongangene ŵandu ŵajinji mpaka kuliŵatana, Che Yesu ŵatandite kwasalila kaje ŵakulijiganya ŵao kuti, “Nlisepusye ni chilungo cha Mafalisayo, chachili cha ulamba. ");
INSERT INTO yao_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ngachipagwa chachiunichikwe chingachiunukukwa ni chachisisikwe chingachimanyika. ");
INSERT INTO yao_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Lyele ligongo lyo chachili chose chimwaŵechete pa chipi, ŵandu chapikane pa lilanguka ni chimwasongonaga pa chisyepela, muchumba cheugalikwe, chichijenele muchilambo chose. ");
INSERT INTO yao_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ngunsalila ŵanyamwe achambusanga ŵangu kuti ngasimwajogopa ŵelewo ŵakuchiulaga chiilu nambo ngapagwa chakupunda chakuchikombola kuchipanganya. ");
INSERT INTO yao_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nambo chinannosye ŵakusachilwa kwajogopa, mwajogope Akunnungu pakuŵa amalaga kuulaga akwete ulamusi wakumponya ku jehanamu. Eloo, mwajogope ŵelewo. ");
INSERT INTO yao_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ana ngati ikumanyika kuti ijojolo nsano ikusumichikwa kwa ndalama jajinandi nnope? Nambo ngapagwa chijuni chakuliŵalichikwa ni Akunnungu namuno chimo. ");
INSERT INTO yao_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Atamuno umbo sya mitwe jenu Akunnungu akusimanyilila sili silingwa. Ngasinjogopa, ŵanyamwe ndi ŵakutopela kwannope kupunda ijojolo yejinji! ");
INSERT INTO yao_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ngunsalila isyene, jwalijose jwakunyitichisya une pa ŵandu kuti jwele ali jwangune, iyoyo peyo Mwana jwa Mundu chachinjitichisya jwelejo mmbujo mwa achikatumetume ŵa kwinani ŵa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nambo, jwalijose jwakungana une pa ŵandu, nombejo chakanikwe mmbujo mwa achikatumetume ŵa kwinani ŵa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mundu jwalijose jwakwaŵechetela yangalumbana Mwana jwa Mundu chalecheleswe, nambo juchannyelusye Mbumu jwa Akunnungu, ngalecheleswa ng'oo. ");
INSERT INTO yao_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pachachinjigala kwa machili mmajumba ga kupopelela pane mmbujo mwa mamwenye ni ŵakulamula kuti nlamulikwe, nkapwelela kuti chinjanje chichi pane ichimmechete. ");
INSERT INTO yao_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pakuŵa Mbumu jwa Akunnungu chanjiganye chakuŵecheta katema kakoko.” ");
INSERT INTO yao_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mundu jumo mumpingo wa ŵandu mula, ŵansalile Che Yesu kuti, “Jwakwiganya, mwasalile akulu ŵangu tusapulane ipanje yatulechele atati ŵetu.” ");
INSERT INTO yao_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Che Yesu ŵajanjile, “Ambusanga, ana ŵaani ŵamisile une kuŵa jwakulamula pasikati jenu pane jwakungaŵanyichisya ipanje yenu?” ");
INSERT INTO yao_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nipele ŵaasalile wose kuti, “Nlisepusye ni tama ja indu yejinji pakuŵa umi wa mundu nganiupagwa mu winji wa indu yakwete.” ");
INSERT INTO yao_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nipele ŵatanjile chitagu chanti, “Kwaliji ni jwachipanje jumo juŵaliji ni ngunda uwasogwele nnope. ");
INSERT INTO yao_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jwachipanje jo ŵaganisisye muntima mwakwe achitiji, ‘Chindende uli pakuŵa une nganingola pakugosela magowolo gangu?’ ");
INSERT INTO yao_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ŵatite ‘Chindende yelei, chingagumule ngokwe syangu ni kutaŵa jajikulungwa nnope. Mwelemo chingaŵiche magowolo gangu gose ga ngano ni ipanje yangu.’ ");
INSERT INTO yao_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pelepo chinalisalile nansyene, ‘Sambano nkwete ipanje yejinji imwaligosele kwa yaka yejinji, mpumule, ndye ni kung'wa ni kusengwa!’ ");
INSERT INTO yao_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nambo Akunnungu ŵaasalile, ‘Mmwejo Jwakuloŵela, achi chilo chino umi wenu chiujigalikwe ni yose indigosele ana chiiŵe ya ŵaani?’ ” ");
INSERT INTO yao_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Che Yesu ŵamalichisye kuŵecheta, “Yele ni yaili kwa mundu jwakuligosela ipanje yejinji, nambo paujo pa Akunnungu ngakuŵalanjikwa kuti akwete chindu.” ");
INSERT INTO yao_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nipele Che Yesu ŵaasalile ŵakulijiganya ŵao, “Kwaligongo lyo ngunsalila, ngasinlilagasya kwa ligongo lya umi wenu kuti chindye chichi atamuno kwa ligongo lya iilu yenu kuti chimmwale chichi. ");
INSERT INTO yao_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pakuŵa umi upundile kwa yakulya ni chiilu chipundile kwa iwalo. ");
INSERT INTO yao_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ngalole makungulu, ngagakupanda namose kugungula, nganigakola ngokwe namose magulu nambo Akunnungu akugalisya. Ni ŵanyamwe ndi ŵakutopela kugapunda makungulu! ");
INSERT INTO yao_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nipele, ŵaani mwa ŵanyamwe kwakulichenjeusya nnope akukombola kulijonjechesya namose lyuŵa limo mmoŵa ga umi wakwe? ");
INSERT INTO yao_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nipele, iŵaga ngankukombola kuchitenda chachinandi mpela chelecho, ligongo chi nkuchenjeuchila ine yo? ");
INSERT INTO yao_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nnole uluŵa umele wakwe. Ngaukupanganya masengo, atamuno ngaukuliluchila iwalo. Nambo ngunsalila kuti namose mwenye che Selemani ni ukulu wao wose nganawale yambone mpela limo lya uluŵa wo. ");
INSERT INTO yao_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nipele iŵaga Akunnungu akulitakusya yeleyo lisamba lya mwitinji lyalikumela lelo ni malaŵi likupatuka ni kwasikwa pa mooto, ana ngati chantakusye kwakupunda ŵanyamwe ŵandi ni chikulupi chamwana? ");
INSERT INTO yao_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Nipele, ngasinlajila ichinlye atamuno iching'we namose ngasimma ni lipamba. ");
INSERT INTO yao_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pakuŵa yose yo ikuchenjeuchilwa ni ŵandu ŵangakulupilila ŵa ilambo ine ya pachilambo pano. Nambo mwanya Atati ŵenu akumanyilila kuti nkuilajila yele indu. ");
INSERT INTO yao_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nipele nsoseje kaje Umwenye wa Akunnungu ni indu ine chiijonjechekwe kukwenu. ");
INSERT INTO yao_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ngasinjogopa, ŵanyamwe mpingo wenondi! Pakuŵa Atati ŵenu yanonyele kumpa Umwenye wao. ");
INSERT INTO yao_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nsumisye inkwete nkaape ŵandu ŵakulaga mbiya syo. Nlipanganyichisye ilolo yangawisala ni kuligosela mbiko jangapunguka ni jangamala kwinani. Kwangaŵandichila ŵa wiyi atamuno konasika ni idudu. ");
INSERT INTO yao_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pakuŵa pajili mbiko jenu, pele ntima wenu ni pachiuŵe. ");
INSERT INTO yao_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nliŵiche chile kwakutumichila ni kuleka imulichilo yenu ininkukolela. ");
INSERT INTO yao_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mbe mpela achikapolo ŵakwalindilila ambuje ŵao kutyochela kuulombela kuti pakupoposya ŵaugulile nnango kwachitema. ");
INSERT INTO yao_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ŵana upile ŵele achikapolo ŵachachasimana ali meeso pachauje Ambuje ŵao! Isyene ngunsalila kuti ambuje wo chaaŵe chile kwatumichila, chiŵatamiche pakulila ni kwatumichila. ");
INSERT INTO yao_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Iŵaga chauje pasikati chilo pane atamuno kuninkucha ni kwasimana ali meeso, ŵana upile achikapolo wo. ");
INSERT INTO yao_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nambo mmanyilileje kuti iŵaga nsyene nyuumba akakamanyilile katema chi chaiche jwa wiyi, akaliji meeso, ngakajileche nyuumba jakwe jininkugumulikwa. ");
INSERT INTO yao_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ŵanyamwe nombe nliŵiche chile, pakuŵa Mwana jwa Mundu akwika katema kangankulolela.” ");
INSERT INTO yao_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Che Petulo ŵausisye Che Yesu kuti, “Ambuje, ana chitagu chi chikutugamba uweji pe pane ŵandu wose?” ");
INSERT INTO yao_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ambuje ŵajanjile, “Ana kapolo jwakwimilila chi jwali jwakukulupilichika ni jwalunda, jwaŵichikwe ni ambujegwe kwajimilila achikapolo ŵao kuti ŵagaŵanyichisye yakulya pa katema kakusachilwa? ");
INSERT INTO yao_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jwana upile kapolo juchasimanikwe ni ambujegwe ali nkupanganya yele katema pachauje. ");
INSERT INTO yao_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Isyene ngunsalila kuti ambujegwe chambiche kapolojo kwimilila ipanje yakwe yose. ");
INSERT INTO yao_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nambo, jwakutumichila ajilaga muntima mwakwe kuti, ambuje ŵangu akukaŵa kuuja ni kutanda kwaputa achikapolo achinjakwe achalume pane achakongwe ni kulya ni kung'wa ni kukolelwa, ");
INSERT INTO yao_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ambujegwe kapolo jula chauje pa lyuŵa lyangalilolela ni katema kangakukamanyilila chiŵakatanye ipande ipande ni kwaŵika liunjili limo ni ŵangakukulupilila. ");
INSERT INTO yao_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ni kapolo jwakumanyilila chakuchisaka ambujegwe, nambo ngakuliŵika chile kwa kupanganya yakusachilwa kupanganya ni ambujegwe, chaputikwe kwa nnope. ");
INSERT INTO yao_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nambo jwangakuimanyilila indu yakuisaka ambujegwe nombe akupanganya indu yaikuŵajilwa kulagaswa chaputikwe kwakanandi. Pakuŵa jwalijose juchapegwe yejinji chasachilwe kutyosya yejinji ni jwalijose jwapegwile kamulila yejinji chasachilwe kuusya yejinji nnope. ");
INSERT INTO yao_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nyiche kukukolesya mooto pachilambo, none ngasachile nnope kuulola uli ukolele! ");
INSERT INTO yao_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nambo ngwete ubatiso wa masausyo gangusachilwa nagakole, nguŵijikanywa nnope mpaka masausyo ga ubatiso wo pachigamale. ");
INSERT INTO yao_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ana nkuganisya kuti nyiche nacho chitendewele pachilambo pano? Ngunsalila, ngwamba, nambo nyiche kukuntindanya. ");
INSERT INTO yao_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kutandila sambano, ŵandu nsano ŵa uŵelesi umo chatindigane, ŵandu ŵatatu chaputane ni ŵandu ŵaŵili ni ŵandu ŵaŵili chaputane ni ŵandu ŵatatu. ");
INSERT INTO yao_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Atati chatindane ni mwanagwao nombe mwanache chatindane ni atatigwe, achikulu chatindane ni mwanagwe mwali nombe mwali chatindane ni achikulugwe, jwankongwe chatindane ni akwegwao nombe ŵelewo chatindane ni nkwegwao.” ");
INSERT INTO yao_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Che Yesu ŵajisalile sooni mipingo ja ŵandu kuti, “Pankugawona maunde ganinkutyochela kulikutiŵilila lyuŵa, papopo ni nkuti lelo chijinye ula ni jikunya. ");
INSERT INTO yao_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pajikupuga mbungo kutyochela kulujenda nkuti, ‘Lyuŵa chiliŵale lelo’ ni iyoyo peyo ikutyochela. ");
INSERT INTO yao_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ŵanyamwe ŵa ulamba, nkukombola kulondola iichiŵe lelo kwakulola chilambo ni kwinani kwachichi nipele nkulepela kugamanyilila malumbo gakatemaka? ");
INSERT INTO yao_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Sooni kwachichi ngankulilamulila mwachimisyene chachili chambone chakuchipanganya? ");
INSERT INTO yao_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pakuŵa ikaliji yambone ntende yaili yose kwilana nawo jwammagongo nli mwitala. Iŵaga ngaŵa yeleyo chanjausye kwa jwakulamula nombejo chanjausye kwa jwangondo nombejo champonye mu nyuumba jakutaŵilwa. ");
INSERT INTO yao_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngunsalila isyene kuti ngantyoka mwelemo mpaka pachimmalisye kulipa mbiya ja mbesi.” ");
INSERT INTO yao_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Katema kakoko ŵaiche ŵandu ŵampepe ni ŵaasalile Che Yesu ngani sya ŵandu ŵa ku Galilaya ŵaŵaulegwe ni che Pilato paŵaliji nkusikita inyama yao ya mbopesi ni miasi jao jawanganyiche ni mbopesi jao. ");
INSERT INTO yao_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Che Yesu ŵajanjile kuti, “Pakuŵa Ŵagalilaya ŵala ŵaulajikwe kwanti yele, nkuganisya ŵaliji ŵakuleŵa kwapunda Ŵagalilaya ŵane wose? ");
INSERT INTO yao_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Isyene ngunsalila kuti ngaŵa yele, nambo iŵaga nganneka sambi syenu ŵanyamwe nombe chinjonasiche. ");
INSERT INTO yao_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Iyoyo peyo ana nkuganichisya kuti ŵandu kumi na nane ŵala, ŵaŵagwililwe ni nyuumba jeleu ku Siloamu kula ni kuwa ŵaliji ŵakuleŵa kupunda ŵane wose ŵakutama ku Yelusalemu? ");
INSERT INTO yao_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ngunsalila kuti ngaŵa, nambo ŵanyamwe nombe iŵaga nganneka sambi syenu, ŵanyamwe nombe chinjonasiche.” ");
INSERT INTO yao_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nipele, Che Yesu ŵatanjile chitagu chi, “Paliji ni mundu jumpepe juŵaliji ni chitela chachikuŵilanjikwa cha ntini chichapandikwe mu ngunda wa Misabibu. Mundu jo ŵajawile kukusosa isogosi yakwe nambo nganachisimana chindu. ");
INSERT INTO yao_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nipele, mundu jo ŵansalile jwakuugosa ngunda wo kuti, ‘Mpilikane! Une iicheje yaka itatu yi kukusosa isogosi ya chitela cha ntini chi, nambo nachisimene changasogola. Nchigwisye! Pakuŵa chikumala chajila pangali chindu?’ ");
INSERT INTO yao_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nambo ŵelewo ŵajanjile kuti, ‘Ambuje, tuchileche kaje namyaka chingachisyunguchisye lisimbo ni kutaga chajila. ");
INSERT INTO yao_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Iŵaga chichisogole isogosi chaka chachikwika chi, yambone, nambo iŵaga ngachisogola chinchigwisye.’ ” ");
INSERT INTO yao_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pa Lyuŵa lya Kupumulila limo, Che Yesu ŵaliji nkwiganya mu nyuumba ja kupopelela. ");
INSERT INTO yao_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ni sooni paliji ni jwankongwe jwakulwala papopo pepo juŵakamwilwe ni lisoka kwa yaka likumi ni nsano ni itatu. Ngongo wakwe wapindiche ni nganakombolaga kulijongola uchenene ng'oo. ");
INSERT INTO yao_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Che Yesu paŵambweni jwankongwe jo ŵambilasile ni ŵansalile, “Jwankongwe, nlecheleswe, ulwele wenu ulamile!” ");
INSERT INTO yao_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ŵansajichile makono gao ni papopo ŵajongweche ni kutanda kwakusya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nambo jwankulungwa jwa nyuumba jakupopelela ŵatumbile ligongo Che Yesu ŵannamisye jwankongwe jo pa Lyuŵa lya Kupumulila, nipele ŵausalile mpingo wa ŵandu ula kuti, “Gapali moŵa nsano ni limo gakwaŵajila ŵandu kupanganya masengo. Kwa gele moŵa njise kukulamwa ilwele yenu nambo ngaŵa Lyuŵa lya Kupumulila!” ");
INSERT INTO yao_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pelepo Ambuje ŵajanjile, “Ŵaulamba ŵanyamwe! Ana ŵaani pasikati jenu jwangakujiugulila ng'ombe jakwe pane mbunda jakwe mulichinga ni kujilongosya kukung'wa meesi atamuno lili Lyuŵa lya Kupumulila? ");
INSERT INTO yao_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sambano, jwankongwe ju, uŵelesi u che Iblahimu, juŵataŵikwe ni Shetani kwa yaka likumi ni nsano ni itatu. Ana ngaikusachilwa kunnamya jwankongwe ju namuno lili Lyuŵa lya Kupumulila?” ");
INSERT INTO yao_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Paŵamasile kuŵecheta gelego, ŵamakani ŵao wose yatesile soni nambo ŵandu ŵane wose ŵasengwile kwaligongo lya indu yose yakusimosya iŵaipangenye. ");
INSERT INTO yao_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nipele Che Yesu ŵausisye kuti, “Ana Umwenye wa Akunnungu ukulandana ni chichi? Chinaulandanye ni chichi? ");
INSERT INTO yao_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ukulandana ni mbeju jamwana ja chitela chachikuŵilanjikwa haladali jiŵajigele mundu jumo ni kujipanda mungunda mwakwe. Jamesile ni chaliji chitela chachikulungwa ni ijuni yataŵile isusi mu nyambi syakwe.” ");
INSERT INTO yao_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Che Yesu ŵausisye sooni, “Ana Umwenye wa Akunnungu chinaulandanye ni chichi? ");
INSERT INTO yao_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ukulandana ni chilungo chiŵachijigele jwankongwe jumo ni kuwanganya pamo ni utandi wejinji, nipele utandi wose waumwiche.” ");
INSERT INTO yao_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Che Yesu ŵajendelechele ni ulendo wao wa ku Yelusalemu akuno achajiganyaga ŵandu mmisi ni mmisinda. ");
INSERT INTO yao_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mundu jumo ŵambusisye Che Yesu kuti, “Ana Ambuje, nganatupa ŵandu ŵachakulupuswe?” Che Yesu ŵajanjile kuti, ");
INSERT INTO yao_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nlimbile kwinjila kwa kupitila nnango wakunyilila pakuŵa ngunsalila kuti, ŵajinji chalinje kwinjila mwelemo, nambo chalepele. ");
INSERT INTO yao_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Chikaiche katema ka nsyene nyuumba pachajimuche ni kuugala nnango. Ŵanyamwe chinjime pasa ni kutanda kupoposya nchitiji, ‘Ambuje, ntuugulile nnango.’ Nambo ŵelewo chachijanga kuti, ‘Ngangummanyilila namose ngangukumanyilila kuntyochele.’ ");
INSERT INTO yao_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pelepo chintande kwasalila, ‘Uwe ni ŵeŵala utwalile ni kung'wa pampepe nomwe, nomwe mwajiganyisye mmisi jetu.’ ");
INSERT INTO yao_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nambo ŵelewo chaachiti, ‘Ngangummanyilila namose kuntyochele, ntyoche mmbujo mwangu ŵanyamwe wose ŵankupanganya yaigongomalo.’ ");
INSERT INTO yao_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nipele kweleko chikupagwe ni kulila ni kuchilimya meeno, pachinchawona che Iblahimu ni che Isaka ni che Yakobo ni ŵakulondola ŵa Akunnungu wose ali mu Umwenye wa Akunnungu nambo mwachinsyene nkanikwe kwinjila. ");
INSERT INTO yao_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ŵandu chaiche kutyochela mumbali mose mwa chilambo ni kutama kulya mu Umwenye wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Elo, kwana ŵane ŵaali ŵambesi chaaŵe ŵandanda ni ŵane ŵaali ŵandanda chaaŵe ŵambesi.” ");
INSERT INTO yao_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Katema kakoko Mafalisayo ŵampepe ŵajaulile Che Yesu ni ŵaasalile kuti, “Ntyoche pelepa njaule kwine, pakuŵa mwenye che Helode akusaka kumbulaga.” ");
INSERT INTO yao_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Che Yesu ŵajanjile, “Njaule nkalisalile lyele licheto kuti, ‘Nnole, lelo ni malaŵi ngugakoposya masoka ni kwalamya ŵakulwala ni ntondo chimalichisye masengo gangu.’ ");
INSERT INTO yao_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nambo ikuumajila kwaula ulendo wangu lelo ni malaŵi ni ntondo, pakuŵa ngaikomboleka kuti jwakulondola jwa Akunnungu aulajikwe kwine ikaŵe ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ugwe Yelusalemu! Yelusalemu! Nkwaulaga ŵakulondola ŵa Akunnungu ni kwaputa maganga ŵaŵatumikwe kukwenu ŵala. Ana kalingwa nasachile kwakumbikanya ŵanache ŵenu pamo, mpela nguku ijikuti pakwautamila ŵanache ŵakwe nambo mwanya nganinsaka. ");
INSERT INTO yao_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nnole! Mwanya chachinnechela musi wenu. Nipele ngunsalila kuti ngamumona une mpaka kele katema pachinchiti, ‘Akole upile ŵelewo ŵakwika mu liina lya Ambuje.’ ” ");
INSERT INTO yao_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lyuŵa lya Kupumulila limo, Che Yesu ŵajawile kukulya chakulya mu nyuumba ja jumo jwa achakulu ŵa Mafalisayo ni ŵandu ŵaŵaliji pelepo ŵaliji nkwalolechesya. ");
INSERT INTO yao_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ni mmbujo mwa Che Yesu paliji ni mundu jumo juŵaliji ni chilwele cha kuimbangana chiilu. ");
INSERT INTO yao_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nipele Che Yesu ŵausisye ŵakwiganya Malajisyo ga che Musa ni Mafalisayo kuti, “Ana Malajisyo gakutusaka kunnamya mundu pa Lyuŵa lya Kupumulila pane ngwamba?” ");
INSERT INTO yao_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nambo ŵanyawo ŵamyalele. Che Yesu ŵankamwile jwakulwala jo ni kunnamya ni ŵannesile ajaule. ");
INSERT INTO yao_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nipele ŵaasalile ŵanyawo, “Ana jwapi jwa ŵanyamwe iŵaga mwanagwe pane ng'ombe jakwe jagwililaga mu chisima ngakujityosya papopo atamuno liŵeje Lyuŵa lya Kupumulila?” ");
INSERT INTO yao_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nambo ŵanyawo ŵalepele kwanga. ");
INSERT INTO yao_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Che Yesu ŵaweni uŵaŵilanjikwe ŵala yatiteje pakulisagulila pakutama pakuchimbichikwa, nipele ŵaajigenye kwa chitagu chi, ");
INSERT INTO yao_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Iŵaga chammilanje mundu kuchindimba cha ulombela, nkatama mmbujo pakuchimbichikwa, panepa apali jwaŵilanjikwe jwine jwakuchimbichikwa kumpunda mmwe. ");
INSERT INTO yao_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jwambilasile mmwe ni njenu jo chaiche ni kunsalila, ‘Mwalechele aŵa pele peuto pao.’ Pelepo chinkole soni pa ŵandu ni kutanda kusejela ni kutama mu itengu yangachimbichikwa. ");
INSERT INTO yao_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nambo ŵannalikaga ku chindimba, njaule nkatame peuto pangachimbichikwa kuti pachaiche jwambilasile jo ansalile, ‘Ambusanga, nsejelele pambone nnope pa.’ Pelepo chinchimbichikwe mmbujo mwa wose ŵatemi pampepe nomwe. ");
INSERT INTO yao_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pakuŵa jwalijose jwakulikusya, chatuluswe ni jwakulitulusya, chakuswe.” ");
INSERT INTO yao_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nipele ŵansalile juŵanŵilasile jo, “Iŵaga chimwakolochesye ŵandu chakulya cha muusi pane ligulo, ngasimwaŵilanga achambusanga ŵenu atamuno achapwenu atamuno achalongo ajenu atamuno ŵapachiŵandi penu atamuno ŵakusichila ajenu ngakaŵa nombewo chachimbilanga ni kumbuchisya mpela chimwaakolochesye chila. ");
INSERT INTO yao_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nambo pankukulumisya chakulya cha chindimba, mwaŵilanje ŵandu ŵakulaga ni ŵakulemala ni ŵangajenda ni ŵangalola, ");
INSERT INTO yao_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nomwe chinkole upile, pakuŵa ŵanyawo ngaakola chakumbuchisya mmwejo. Akunnungu champe ntulilo wenu katema pachachasyusya ŵakupanganya yaili yambone paujo pa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jumo jwao jwa ŵaŵatemi pamo ni Che Yesu ŵatite, “Jwana upile jwele mundu juchaakalye mu Umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nipele Che Yesu ŵajanjile, “Jwapali mundu juŵakulumisye chakulya cha chindimba chachikulungwa ni ŵaaŵilasile ŵandu ŵajinji. ");
INSERT INTO yao_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pajaiche ndaŵi ja chakulya ŵannajisye kapolo jwao kukwaŵilanga ŵandu ŵaŵaŵilanjikwe wo, ‘Njisangane, pakuŵa indu yose ili chile.’ ");
INSERT INTO yao_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nambo wose ŵatandite kuŵalanga ligongo lya kulepela kwika. Jwandanda ŵansalile kapolo jo, ‘Sumile ngunda, ngusachilwa nyaule kukuulola, ngunchondelela mulechelesye.’ ");
INSERT INTO yao_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jwine ni ŵatite, ‘Sumile ng'ombe likumi sya kulima, sambano ndili mwitala ngwaula kukusilinjila, ngunchondelela mulechelesye.’ ");
INSERT INTO yao_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ni jwine ŵatite, ‘Nombele moŵa gagaga, nipele ngangukombola kwika.’ ");
INSERT INTO yao_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Jwele kapolojo ŵausile ni kwasalila ambujegwe yeleyo. Pelepo nsyene nyuumba jo ŵatumbile, ni kunsalila kapolo jwao kuti, ‘Njaule chitema mmatala gamakulungwa ni matala gamanandi ga musi, nkaichenawo amuno ŵakulaga ni ŵangajenda ni ŵangalola ni ŵalemele.’ ");
INSERT INTO yao_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kanyuma kakwe kapolo jo ŵatite, ‘Ambuje, chimwalajichisye chila chemale kutendekwe mpela imwatite kuunajichisya nambo lisigalile liuto.’ ");
INSERT INTO yao_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nipele ambuje ŵala ŵansalile kapolo kuti, ‘Njaule mmatala gamakulungwa ni mmatala gamanandi ga musi ni kwakanganyichisya ŵandu kwinjila kuti, nyuumba jangu jigumbale. ");
INSERT INTO yao_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pakuŵa, ngunsalila kuti ngapagwa jwalijose mwa ŵandu ŵaŵalalichikwe kundanda ŵala juchapasye chakulya changu cha chindimba.’ ” ");
INSERT INTO yao_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pelepo, mipingo jejinji ja ŵandu ŵaliji nkulongana nawo Che Yesu. Nipele Che Yesu ŵagalauchilile ŵandu ni kwasalila, ");
INSERT INTO yao_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yaŵaga kwana mundu jwakwika kukwangu akusachilwa kaje kunonyela une kupunda yakuti kwanonyela atatigwe ni achikulugwe ni ŵankwawo ni achiŵanagwe ni achapwakwe ni achalumbugwe, eloo ni yakuti kulinonyela nsyene, naga ngakutenda yele ngakukombola kuŵa jwakulijiganya jwangu. ");
INSERT INTO yao_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ni jwalijose jwangakulijigalila nsalaba wakwe nsyene ni kunguya ngakukombola kuŵa jwakulijiganya jwangu. ");
INSERT INTO yao_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Pakuŵa, ana ŵaani mwa ŵanyamwe asakaga kutaŵa nyuumba jeleu, jwangatama kaje ni kuŵalanga ndalama jakwe pakuti alole iŵaga akwete ipanje yakombola kumalichisya? ");
INSERT INTO yao_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pakuŵa amalaga kutaŵa nsingi ni kulepela kumalichisya kutaŵa nyuumba jeleu jo, ŵandu wose ŵakwilola chatande kunseka ");
INSERT INTO yao_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","achitiji, ‘Aju mundu ju ŵatandite kutaŵa nambo alepele kumalichisya.’ ");
INSERT INTO yao_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Pane, mwenye chi jwakwaula kukumenyana ni mwenye jwine, jwangakutama kaje ni kuganisya kuti ŵandu ŵakwe ŵangondo mianda likumi chakombole kumenyana ni ŵandu ŵangondo mianda makumi gaŵili wa mwenye jwakwika? ");
INSERT INTO yao_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ni amanyililaga kuti ngakombola, chachalajisya ŵantenga ŵao kuti ajaule kukuusya yati pakwikanacho chitendewele, kele katema ko jwele mwenye jwine jo ali kwakutalichila. ");
INSERT INTO yao_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iyoyo peyo, ngapagwa jwalijose jwa ŵanyamwe juchaŵe jwakulijiganya jwangu iŵaga ngaileka yose yakwete yo. ");
INSERT INTO yao_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Njete jili jambone, nambo njete jasoyesyaga unonye wakwe chintaje chichi kuti unonye wakwe uujile sooni? ");
INSERT INTO yao_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ngajikufai kulikose kwa litaka atamuno kwakutenda chajila, ŵandu chajasepe. Jwakwete mapikanilo gakupikanila, apikane!” ");
INSERT INTO yao_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lyuŵa limo, ŵakukumbikanya nsongo ŵajinji ni ŵa sambi ŵajinji ŵaiche ku Che Yesu kukwapilikanila. ");
INSERT INTO yao_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafalisayo ni ŵakwiganya Malajisyo ga che Musa ŵatandite kunyinyita achitiji, “Munnole mundu ju! Akwapochela ŵaali ni sambi, sooni akulya nawo pamo.” ");
INSERT INTO yao_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Che Yesu ŵaasalile chitagu chati, ");
INSERT INTO yao_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ana jwapi mwa ŵanyamwe akolaga ngondolo mia moja, amanyililaga kuti jisoŵile jimo, ngakusileka asila tisini na tisa mwitinji ni kwaula kukujisosa jajisoŵile jila mpaka patajione? ");
INSERT INTO yao_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ni patajione chajijigale mmakoyo, achisangalalaga. ");
INSERT INTO yao_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pakwika kumangwao, chachaŵilanga achambusanga ŵao ni ŵapachiŵandi pao kwasalila, ‘Nsangalale pamo ni une, pakuŵa ngondolo jangu jijasoŵile jila najipatile. ");
INSERT INTO yao_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngunsalila kuti kwati iyoyo peyo ni kutichiŵa sangalala kwinani kwa ligongo lya mundu jumo jwali ni sambi kuleka sambi, kupunda ŵandu ŵakupanganya yaili yambone paujo pa Akunnungu tisini na tisa ŵangakusaka kuleka sambi. ");
INSERT INTO yao_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Atamuno tujile, jwankongwe jumpepe jwana mbiya likumi, asoyesyaga mbiya jimo, ngaapamba lumuli ni kupyajila nyuumba achisosaga uchenene mpaka ajisimane? ");
INSERT INTO yao_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ajisimanaga, chachaŵilanga achambusanga ŵao ni ŵapachiŵandi pao ni kuti, ‘Nsangalale pamo ni une, pakuŵa mbiya jangu jijasoŵile jila najiweni.’ ");
INSERT INTO yao_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ngunsalila, kwati iyoyo peyo ni yakuti pakusangalala achikatumetume ŵa kwinani ŵa Akunnungu ligongo lya jumo jwalesile sambi.” ");
INSERT INTO yao_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Che Yesu ŵapundile kuŵecheta kwa chitagu achitiji, “Jwapali mundu jumo juŵakwete achachanda ŵaŵili. ");
INSERT INTO yao_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jwannung'una jula ŵansalile atatigwe kuti, ‘Atati mumbe chigaŵanyo cha ipanje chachikung'wilila une.’ Nombewo ŵagaŵanyichisye wose ŵaŵili ipanje iŵakwete. ");
INSERT INTO yao_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pangakaŵa moŵa, jwannung'una jula ŵajigele yakwe ila ni kwaula kuchilambo cha kutalika ni kweleko ŵatumie ipanje yakwe yose kwa wamba. ");
INSERT INTO yao_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Payamalile yose, kwatyochele sala jajikulungwa mchilambo mo ni ŵatandite kuchenjeuka pakuŵa nganakola chindu. ");
INSERT INTO yao_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ŵajawile kwa mundu jumo jwa mwele mchilambo kukuŵenda masengo, nombewo ŵanjawisye kungunda ŵao kukugagosa maguluŵe. ");
INSERT INTO yao_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ŵalajile kulya chakulya cha maguluŵe gala nambo ngapagwa mundu juŵampele chindu. ");
INSERT INTO yao_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Paŵaimanyilile iŵaliji ŵakuloŵela kundanda ŵatite, ‘Ana kwana ŵamasengo ŵalingwa kwa atati ŵangu ŵakulyanga ni kusigasya, none ligongo chi nguwa sala? ");
INSERT INTO yao_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Chimujile kwa atati ŵangu ni kwasalila, Atati une naleŵele Akunnungu ni nanneŵele nomwe ŵakwe. ");
INSERT INTO yao_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nganguŵajilwa sooni kuŵilanjikwa mwanagwenu. Mundende mpela jumo jwa ŵamasengo ŵenu.’ ");
INSERT INTO yao_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ŵatandite ulendo kuuja kwa atati ŵao. “Paŵaliji kwakutalichila kanandi, atatigwe ŵambweni ni kunkolela chanasa ni ŵammutuchile ni kwakomasya kwa unonyelo. ");
INSERT INTO yao_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwanagwao jula ŵansalile, ‘Atati, une naleŵele Akunnungu ni nanneŵele nomwe ŵakwe. Nganguŵajilwa sooni kuŵilanjikwa mwanagwenu.’ ");
INSERT INTO yao_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nambo atatigwe ŵaasalile achikapolo ŵao kuti, ‘Njanguye! Nkajigale chiwalo chambone mumwasye! Mumwasye pete ni italawanda! ");
INSERT INTO yao_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nkajijigale ng'ombe jamwana jakunakana jila njisikite, tulye ni kusangalala pamo! ");
INSERT INTO yao_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pakuŵa mwanangu ju kwangu une ŵaliji mpela jwamwe, nambo ali jwanjumi, ŵaliji asoŵile nambo sambano awoneche.’ Ni ŵatandite kusangalala pamo. ");
INSERT INTO yao_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kele katemako mwanagwao jwankulungwa jula ŵaliji ku ngunda. Paŵaujaga ni kuŵandichila kumangwao, ŵakupikene kwimba ni kutyala. ");
INSERT INTO yao_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ŵambilasile jwakutumichila jumo ni ŵambusisye kuti, ‘Ana kwana chichi?’ ");
INSERT INTO yao_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ni kapolo jula ŵanjanjile, ‘Apwenu ausile pamusi ni atati ŵenu asikite ng'ombe jamwana jakunakana ligongo lya ŵelewo pakuŵa ampochele ali jwanjumi.’ ");
INSERT INTO yao_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nambo nchanda jwankulungwa jo ŵatumbile ni ŵakanile kwinjila nkati. Nipele atatigwe ŵakopweche ni kunchondelela kuti ajinjile. ");
INSERT INTO yao_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nambo ŵelewo ŵanjanjile atatigwe kuti, ‘Nnole! Yaka yejinji i nantumichile mpela kapolo ni nganingane kunjitichisya makanyo genu. Mumbele chichi? Nganimumba atamuno kambusi kuti sangalale pamo ni achambusanga ŵangu! ");
INSERT INTO yao_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nambo paŵaiche aju mwanagwenu jwajonasile chipanje chenu kwa kulaŵalaŵa, munsikitile jwelejo ng'ombe jamwana jakunakana jila.’ ");
INSERT INTO yao_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Atatigwe ŵanjanjile kuti, ‘Mwanangu, mmwe nndi pamo none moŵa gose ni yose ingwete ili yenu. ");
INSERT INTO yao_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kwa yele yatuŵajile kutenda chindimba ni kusangalala, ligongo mpwenuju, kwanguune ŵaliji mpela jwamwe nambo sambano ali jwanjumi ni ŵaliji asoŵile nambo sambano awoneche.’ ” ");
INSERT INTO yao_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Che Yesu ŵaasalile ŵakulijiganya ŵao kuti, “Jwapali jwachipanje juŵakwete jwakwimilila ipanje yakwe. Jwachipanje ŵasalilwe kuti jwakwimililajo akonanga ipanje yenu. ");
INSERT INTO yao_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nipele jwachipanje jo ŵambilasile ni kunsalila kuti, ‘Ana achi ni chichi chinguchipikana chachikungamba mmwejo? Mmalanje imwatite pakwimilila ipanje yangu yose, ligongo ngamma jwakwimilila ipanje yangu sooni’ ");
INSERT INTO yao_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jwakwimilila jula ŵaganisisye mu ntima mwakwe achitiji, ‘Ambuje ŵangu akuuminga masengo ga kwimilila ipanje yao, sambano chindende chichi? Ngangombola kulima ni kuŵa ŵakuŵendaŵenda ikundesya soni. ");
INSERT INTO yao_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Elo, nachimanyi chakutenda, kuti patachiminga masengo ga kwimilila ipanje ŵandu akombole kumbochela mmajumba gao.’ ");
INSERT INTO yao_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Nipele, ŵaaŵilasile ŵaali ni magambo wose ŵa ambujegwe jumo jumo, ŵambusisye jwaandanda, ‘Mwakongwele ilingwa kwa ambuje ŵangu?’ ");
INSERT INTO yao_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nombe ŵanjanjile ‘Mapipa mia moja ga mauta ga seituni’ Ni ŵansalile, ‘Ntole chikalata cha ligambo lyenu, ntame kwachitema ni kulemba mapipa ansini.’ ");
INSERT INTO yao_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nipele, ŵammusisye jwamagambo jwine kuti, ‘Nomweji mwakongwele ilingwa?’ Ŵatite, ‘Magunia mia tatu ga ngano.’ Ni ŵansalile, ‘Ntole chikalata cha ligambo lyenu ni kulemba kwachitema magunia mia mbili ni alobaini.’ ");
INSERT INTO yao_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nambo mmbujegwe jula ŵannapile jwakwimilila ipanje yakwe jwangakukulupilichika jula ligongo ŵatesile mwakalamuka. Pakuŵa ŵandu ŵa pachilambo chi akalamwiche kwannope kwakupanganya indu yao ni achinjao kupunda ŵandu ŵaali mu Umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nombe Che Yesu ŵapundile kuŵecheta, “None ngunsalila kuti ntende uganja ni ŵane kwa ipanje ya pachilambo kuti, ipanje pachiilepele kunkamusya mpochelwe mu utame wa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jwakukulupilichika mu yamwana nnope jwelejo akukulupilichika atamuno mu yeikulungwa nombeyo. Ni jwangakukulupilichika mu yamwana ngaakukulupilichika atamuno mu yeikulungwa nombeyo. ");
INSERT INTO yao_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nipele iŵaga ŵanyamwe ngankukulupilichika mu ipanje ya pachilambo ŵaani ŵachachimpa ipanje yaili isyene? ");
INSERT INTO yao_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Iŵaga ŵanyamwe ngankukulupilichika mu indu ya mundu jwine ana ŵaani ŵachampe yaili yenu mwachinsyene? ");
INSERT INTO yao_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ngapagwa kapolo jwakukombola kwatumichila achambuje ŵaŵili, pakuŵa chanchime jumo ni kunnonyela jwine pane chanchimbichisye jumo ni kunnyelusya jwine. Ngankukombola kwatumichila Akunnungu akuno nchitumichilaga mbiya kwanakamo.” ");
INSERT INTO yao_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafalisayo ŵakunonyelwa mbiya paŵagapilikene gelego ŵanyelwisye Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pelepo Che Yesu ŵaasalile, “Mwanya nkuliŵalanjila nli ŵambone pa meeso pa ŵandu, nambo Akunnungu akujimanyilila mitima jenu. Pakuŵa chindu chachikuoneka chili chambone kwannope pa meeso pa ŵandu paujo pa Akunnungu chikuoneka chili chindu cha uchimwa. ");
INSERT INTO yao_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Malajisyo ga che Musa ni malembelo ga ŵakulondola ŵa Akunnungu galiji ganinkulalichikwa mpaka paŵaiche che Yohana Ŵakubatisya. Chitandile kele katema Ngani Jambone ja Umwenye wa Akunnungu jikulalichikwa ni jwalijose akwinjila mwelemo kwa machili. ");
INSERT INTO yao_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nambo kwinani ni chilambo ikukomboleka kumala, kupunda kalembo kamo ka Malajisyo ga che Musa kutyosyekwa. ");
INSERT INTO yao_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mundu jwalijose jwakulekangana ni ŵankwawo ni kulombela jwine akutenda chikululu ni jwakunnombela juŵalekangene ni ŵankwawo, akutenda chikululu.” ");
INSERT INTO yao_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Jwapali mundu jwachipanje juŵawalaga iwalo ya ndalama jekulungwa ni kupoka moŵa gose. ");
INSERT INTO yao_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Paliji ni jwakulaga liina lyakwe che Lasalo juŵagumbele maŵanga pachiilu chose nombe ŵandu ŵane ŵagonekaga ŵelewo pannango wa nyuumba ja jwachipanje. ");
INSERT INTO yao_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Che Lasalo ŵalajile apegwe mbakatika sisyagwaga pakulila pa jwachipanje jo ni kupunda yeleyo mbwa syaikaga kukulapita maŵanga gakwego. ");
INSERT INTO yao_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Lyuŵa limo jwakulaga jo ŵawile ni achikatumetume ŵa kwinani ŵanjigele ni kummika chiŵandi ni che Iblahimu. Nombe jwachipanje jula ŵawile ni kusikwa. ");
INSERT INTO yao_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jwachipanje jo ŵalasile nnope kwiuto kwa ŵandu ŵawile ni ŵalolite kwinani ni kwaona che Iblahimu ali atemi pachiŵandi ni che Lasalo. ");
INSERT INTO yao_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ŵanyanyisye achitiji, ‘Atati che Iblahimu, mungolele chanasa, mwalajisye che Lasalo kuti anyoye kumbesi kwa chala chakwe mmeesi ni asisimisye lulimi lwangu, pakuŵa ndili nkusauka nnope mu mooto wu.’ ");
INSERT INTO yao_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nambo che Iblahimu ŵajanjile, ‘Mwanangu, nkumbuchile kuti mmwe pamwaliji ni umi pachilambo mwamasile kupochela yambone yose iyammajile nombe che Lasalo ŵalasile. Nambo sambano akuno che Lasalo ali nkutuswa ntima ni mmwe ndi mkusauka. ");
INSERT INTO yao_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kupunda yeleyi, pasikati jetu ni ŵanyamwe kwana lisimbo lyekulungwa pakuti ŵakusaka kutyoka akuno kwika kweleko anakombole ni anajomboche mundu jwakweleko kwika akuno.’ ");
INSERT INTO yao_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Pele jwachipanje jula ŵatite, ‘Ngunchondelela, atati che Iblahimu kuti munnajisye che Lasalo jo ajaule kwa achalongo ŵangu, ");
INSERT INTO yao_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ligongo ngwete achapwanga nsano, ajaule akaajamuche kuti nombewo anaiche peuto pamasausyo pano. ");
INSERT INTO yao_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Nambo che Iblahimu ŵansalile, ‘Achapwenu akwete malembelo ga che Musa ni ŵakulondola ŵa Akunnungu mwaleche ŵapilikanile ŵelewo.’ ");
INSERT INTO yao_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nambo jwachipanje jo ŵatite sooni, ‘Atati che Iblahimu ngaŵa yeleyo nambo iŵaga mundu jumo chasyuche ni kwajaulila, chaleche sambi syao.’ ");
INSERT INTO yao_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nombe che Iblahimu ŵatite, ‘Iŵaga ngakugapilikanichisya ni kugakulupilila malembelo ga che Musa ni ŵakulondola ŵa Akunnungu atamuno asyuche jwalijose ni kwajaulila ngakombola kwanyenga.’ ” ");
INSERT INTO yao_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Che Yesu ŵaasalile ŵakulijiganya ŵao kuti, “Ngaikomboleka kuti ikatyochela yakunleŵesya ni kukola sambi nambo ulaje uŵe kwa jwakwikanawo yakuleŵesya. ");
INSERT INTO yao_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ikaliji mbaya jwakwaleŵasya jo ataŵikwe lisyago pa lukosi ni kwaponya mu bahali kupunda kunsiŵilila jumo jwa achanandi ŵa. ");
INSERT INTO yao_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nlilolechesye mwachinsyene! “Mpwenu aleŵaga, munjamuche, iŵaga chaleche sambi, munnechelesye. ");
INSERT INTO yao_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Atamuno anneŵelaga mala saba pa lyuŵa limo ni kuuja kukwenu mala saba achitiji, ‘Lesile sambi,’ nkusachilwa kunnechelesya.” ");
INSERT INTO yao_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Achinduna ŵaasalile Ambuje Che Yesu kuti, “Ntujonjechesye chikulupi.” ");
INSERT INTO yao_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ambuje ŵajanjile, “Nkaakwete chikulupi atamuno chamwana chati mpela lusongolo lwamwana nnope mpela lwa haladali, nkakombwele kuchisalila chitela cha nkuju chi kuti, ‘Ntupuche nkalipandichisye mu bahali,’ nombecho chikajitichisye. ");
INSERT INTO yao_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nambo jwapi mwa ŵanyamwe jwakwete kapolo jwakulima pane jwakuchinga ngondolo pakuuja kutyochela kungunda, akunsalila katema kakoko peko ‘Njise kwachitema, kundye chakulya’? ");
INSERT INTO yao_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ngaŵa chansalile kuti, ‘Mungulumichisye chakulya, mmeje chile kwa kundumichila mpaka pachimalisye kulya ni kung'wa nomweji ni pachinlye ni kung'wa.’ ");
INSERT INTO yao_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ana ngati ambuje chantogolele kapolo jo pakuŵa amasile kupanganya iŵalamulikwe yo? ");
INSERT INTO yao_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iyoyo peyo ni ŵanyamwe pachimmale kupanganya yose iŵanlamulile yo, nsaleje kuti, ‘Uwe tuli achikapolo, tupanganyisye masengo agala pe gatuŵajilwe nago.’ ” ");
INSERT INTO yao_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Che Yesu paŵajaulaga ku Yelusalemu ŵajesile mumpika wa ku Samalia ni ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Paŵajinjilaga mu nsinda umo, ŵandu likumi ŵa matana ŵaichile Che Yesu ni kwima kwakutalichila. ");
INSERT INTO yao_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ŵanyanyisye achitiji, “Che Yesu Ambuje, ntukolele chanasa!” ");
INSERT INTO yao_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Che Yesu paŵaweni ŵaasalile, “Njaulangane nkalilosye kwa ŵambopesi.” Nombe ŵanyawo paŵajaulaga kweleko, ŵaswejele. ");
INSERT INTO yao_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jumo jwa ŵanyawo paŵaliweni kuti amasile kulamwa, ŵausile aninkwakusya Akunnungu achinyanyisyaga. ");
INSERT INTO yao_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ŵagwile manguku pa sajo si Che Yesu achatogolelaga. Mundu jo ŵaliji Msamalia. ");
INSERT INTO yao_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nambo Che Yesu ŵausisye, “Ana ngati ŵaliji ŵandu likumi ŵaŵaswejeswe? Ali kwapi tisa ŵala? ");
INSERT INTO yao_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ana ngapagwa ŵandu ŵane ŵausile kukwatogolela Akunnungu ikaŵe jwakwikape?” ");
INSERT INTO yao_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nombe Che Yesu ŵansalile mundu jo kuti, “Njimuche, njaule chikulupi chenu chinnamisye.” ");
INSERT INTO yao_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Katema kampepe Mafalisayo ŵausisye Che Yesu kuti, “Ana Umwenye wa Akunnungu ukwika chakachi?” Nombewo ŵajanjile, “Umwenye wa Akunnungu ngaukwika kwakulolecheka. ");
INSERT INTO yao_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Atamuno menema ngapagwa juchakombole kusala, ‘Nnole uli akuno,’ pane ‘Uli apala.’ Pakuŵa Umwenye wa Akunnungu uli pasikati jenu.” ");
INSERT INTO yao_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sooni, ŵaasalile ŵakulijiganya ŵao kuti, “Gakwika moŵa pachinnajile kulola lyuŵa limo mwa moŵa ga Mwana jwa Mundu, nambo nganliona. ");
INSERT INTO yao_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ni ŵandu chachinsalila kuti, ‘Nnole, ali ako!’ Pane, ‘Nnole, ali akuno!’ Nambo ŵanyamwe nkatyoka atamuno kwakuya. ");
INSERT INTO yao_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pakuŵa chiiŵe mpela njasi pajikumesya ni kuloleka kwiunde kose, iyoyo peyo ni ichichiŵa pa lyuŵa lya kwika kwakwe Mwana jwa Mundu. ");
INSERT INTO yao_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nambo gakanaŵe gelego, akusachilwa asauche nnope ni kukanikwa ni ŵandu ŵa uŵelesi u. ");
INSERT INTO yao_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mpela iyaliji pa moŵa ga che Nuhu ni iyoyopeyo ni ichichiŵa pa moŵa ga kwika Mwana jwa Mundu. ");
INSERT INTO yao_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ŵandu ŵalyaga ni kung'wa, ŵalombelaga ni kulombwa mpaka lyuŵa liŵajinjilaga che Nuhu mu ngalaŵa jekulungwa lila. Nipele jaiche ula jekulungwa nnope ni kwajonanga wose. ");
INSERT INTO yao_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Iyoyopeyo ni ichiŵe mpela iyaliji pakutyochela pa moŵa ga che Lutu. Ŵandu ŵalyaga ni kung'wa, ŵasumisyaga ni kusuma, ŵapandaga mbeju ni kutaŵa majuumba. ");
INSERT INTO yao_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nambo lyuŵa liŵakopweche che Lutu Msodoma lila, mooto ni chibiliti yatulwiche kutyochela kwinani nti ula ni kwaulaga wose. ");
INSERT INTO yao_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ilaila peila ni ichichiŵa pa lyuŵa lya kwika Mwana jwa Mundu.” ");
INSERT INTO yao_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ŵapundile kuŵecheta, “Lyele lyuŵa lyo, jwalijose juchaŵe paasa nyuumba kasajinjila kukujigala chipanje chakwe chachili mu nyuumba. Iyoyopeyo juchaŵe ku ngunda kasauja kukutola yailesile panyuma. ");
INSERT INTO yao_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nkumbuchile iyasimene ŵankwawo che Lutu. ");
INSERT INTO yao_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mundu jwalijose jwakusaka kuukulupusya umi wakwe, chaujase. Ni mundu jwalijose juchaujase umi wakwe, chaugose. ");
INSERT INTO yao_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngunsalila kuti, chilo cho ŵandu ŵaŵili chagone pachindanda chimo, jumo chajigalikwe ni jwine chachilekwa. ");
INSERT INTO yao_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Achakongwe ŵaŵili chachiŵa aninkusyaga pampepe, jumo chajigalikwe ni jwine chachilekwa. ");
INSERT INTO yao_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ŵandu ŵaŵili chachiŵa mu ngunda umo, jumo chajigalikwe ni jwine chachilekwa.” ");
INSERT INTO yao_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ŵakulijiganya ŵausisye kuti, “Ana kwapi Ambuje?” Nombe Che Yesu ŵajanjile, “Kwauli ntembo kweleko ni kuchakasongangane achikapungu.” ");
INSERT INTO yao_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Che Yesu ŵaasalile ŵakulijiganya ŵao chitagu chati, ŵandu akusachilwa apopeleje katema kose pangapela. ");
INSERT INTO yao_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ŵatite kuti, “Pamusi umo, jwapali jwakulamula jumo, jwanganjogopa Akunnungu natamuno kwachimbichisya ŵandu. ");
INSERT INTO yao_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nipele, jwapali jwankongwe jwakuŵililwa jumo pa musi wo juŵajaulilaga kaŵili kaŵili jwakulamulajo achitiji, ‘Munjenjele kuti ngole chigolochelo changu kutyochela kwa jwammagongo jwangu.’ ");
INSERT INTO yao_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa moŵa gamajinji jwakulamula jo nganasaka kwachenjela nambo kambesi kakwe ŵatite mu ntima mwakwe, ‘Atamuno ngangwajogopa Akunnungu namuno kwachimbichisya ŵandu, ");
INSERT INTO yao_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nambo kwaligongo lya jwakuwililwa ju akuusakalisya une, chinaachenjele kuti akole chigolochelo chakwe nambo iŵaga ngambanganya yeleyo chambesye une pakwika kaŵili kaŵili!’ ” ");
INSERT INTO yao_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nipele, Ambuje ŵajendelechele, “Mpilikane yatite pakuŵecheta jwakulamula jwangalumbana jo. ");
INSERT INTO yao_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Uli, Akunnungu ngaŵaachenjela ŵele ŵandu uŵasagwile, ŵakwalilila muusi ni chilo ŵala? Ana pane chakaŵe kwapilikanila? ");
INSERT INTO yao_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngunsalila kuti chachachenjela ŵanyawo chitema pe. Nambo uli pachaiche Mwana jwa Mundu chiŵasimane ŵandu ŵakunkulupilila pachilambo pano?” ");
INSERT INTO yao_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nombe Che Yesu ŵatanjile sooni chitagu kwa ŵakuliganisya kuti akupanganya yaili yambone paujo pa Akunnungu ni kwanyelusya ŵane. ");
INSERT INTO yao_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ŵandu ŵaŵili ŵajawile pa Nyuumba ja Akunnungu kukupopela, jumo ŵaliji Mfalisayo ni jwine ŵaliji jwakukumbikanya nsongo. ");
INSERT INTO yao_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Jwele Mfalisayo jo ŵajimi ni kupopela chikatikati achitiji, ‘Akunnungu, nguntogolela pakuŵa uneji nganima chisau ŵandu ŵane, ŵachiswamba ni ŵachigongomalo ni ŵachikululu. Natamuno chisau jwakukumbikanya nsongo ju. ");
INSERT INTO yao_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngutaŵa kaŵili kwa chijuma ni ngutyosya liunjili lya kakumi lya indu yose ingupata.’ ");
INSERT INTO yao_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nambo jwakukumbikanya nsongo jula, ŵajimi kwakutalichila, nombejo nganalinga kulola kwinani nambo ŵaliputile pa ntima pao kwa kulilasika achitiji, ‘Akunnungu, mungolele chanasa une jundi ni sambi!’ ” ");
INSERT INTO yao_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Che Yesu ŵatite, “Ngunsalila mwanya, jwakukumbikanya nsongo jo ŵausile kumangwao ali akundikwe ni Akunnungu kumpunda Mfalisayo jo. Pakuŵa jwalijose jwakulikwesya chatuluswe ni jwakulitulusya chakweswe.” ");
INSERT INTO yao_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ŵandu ŵampepe ŵannyichisye Che Yesu ŵanache achanandi kuti ŵasajichile makono ni kwapa upile. Nambo ŵakulijiganya ŵao paŵaiweni ŵakalipile. ");
INSERT INTO yao_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nambo Che Yesu ŵaaŵilasile ŵanache achanandi achitiji, “Mwaleche ŵanache achanandi aichanje kukwangu, nkalekasya pakuŵa Umwenye wa Akunnungu uli wa ŵandu mpela aŵa. ");
INSERT INTO yao_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ngunsalila isyene kuti jwalijose jwangakuupochela Umwenye wa Akunnungu mpela mwanache jwannandi, ngajinjila mu Umwenye ng'oo.” ");
INSERT INTO yao_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chilongola jumo jwa Ŵayahudi ŵammusisye Che Yesu achitiji, “Jwakwiganya jwambone ana ndende chichi pakuti ngole umi wa moŵa gose pangali mbesi?” ");
INSERT INTO yao_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Che Yesu ŵansalile, “Ligongo chi nkuumilanga une jwambone? Ngapagwa jwali jwambone akaŵe Akunnungu pe. ");
INSERT INTO yao_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nkugamanyilila makanyo ga Akunnungu, ‘Kasintenda chikululu atamuno kasimmulaga ni kasinjiŵa atamuno kasinsala ya unami ni mwachimbichisye atati ŵenu ni achikulu ŵenu.’ ” ");
INSERT INTO yao_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ŵelewo ŵatite, “Yeleyo yose naikamulichisye chitandilile mu uchanda wangu.” ");
INSERT INTO yao_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Che Yesu paŵapilikene gelego ŵansalile kuti, “Chindu chimo chisoŵile kukwenu, nkasumisye yose inkwete ni mbiya syo nkaasapulile ŵakulaga, nomwe ni pachinchikola ipanje kwinani, nipele njise munguye.” ");
INSERT INTO yao_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nambo mundu jo paŵapilikene yeleyo, ŵasupwiche nnope pakuŵa ŵaliji ni ipanje yejinji. ");
INSERT INTO yao_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Che Yesu paŵammweni mundu jo aninkusongoneka ni ŵatite “Yaikuti pakulepelecheka kwa ŵandu ŵaali ni ipanje kwinjila mu Umwenye wa Akunnungu! ");
INSERT INTO yao_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Eloo, ili yangalemwa kwa chinyama chachikuŵilanjikwa ngamia kwinjila pachipowo cha sindano kupunda jwaali ni chipanje kwinjila mu Umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ŵandu ŵaŵapilikene yeleyo ŵausisye, “Ana ŵaani uchakombole kulupuswa?” ");
INSERT INTO yao_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Che Yesu ŵajanjile achitiji, “Indu yangaikukomboleka kwa ŵandu, kwa Akunnungu ikukomboleka.” ");
INSERT INTO yao_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Che Petulo ŵansalile Che Yesu, “Nnole, uwe tulesile indu yetu yose ni kunkuya alakwe!” ");
INSERT INTO yao_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nipele, Che Yesu ŵaasalile, “Isyene ngunsalila, mundu jwalijose jwajilesile nyuumba pane ŵankwawo pane achapwakwe pane achaŵelesi pane achiŵanagwe ligongo lya Umwenye wa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","chapochele yejinji nnope aka katemaka ni katema kakakwika chachipochela umi wa moŵa gose pangali mbesi.” ");
INSERT INTO yao_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Che Yesu ŵaajigele pajika ŵakulijiganya ŵao kumi na mbili, ŵaasalile, “Mpilikane! Tukukwesya kwaula ku Yelusalemu ni kweleko indu yose iyalembekwe ni ŵakulondola ŵa Akunnungu yankati Mwana jwa Mundu chiiŵe isyene. ");
INSERT INTO yao_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pakuŵa chachajausya kwa ŵandu ŵangosyo sine nombe ŵanyawo chachanyelusya ni kwatukana ni kunsunila mata. ");
INSERT INTO yao_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Champute ibokola ni kummulaga nambo pa lyuŵa lyaatatu kutyochela pa chiwa chao chasyuche.” ");
INSERT INTO yao_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ŵakulijiganya ŵala nganagamanyililaga malumbo ga maloŵe gaŵecheteje Che Yesu go pakuŵa galiji gamasisikwe kukwao nombewo nganaimanyilila kuti Che Yesu akuŵecheta nkati chichi. ");
INSERT INTO yao_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Katema Che Yesu paŵaŵandichile ku Yeliko, jwapali mundu jumo jwangalola juŵatemi mungulugulu litala achiŵendaga. ");
INSERT INTO yao_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Paŵapilikene ŵandu ŵajinji aninkupita ŵausisye “Ana kwana chichi?” ");
INSERT INTO yao_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ŵansalile, “Che Yesu ŵa ku Nasaleti akupita.” ");
INSERT INTO yao_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nombewo ŵanyanyisye achitiji, “Che Yesu, Uŵelesi u che Daudi, choonde mungolele chanasa!” ");
INSERT INTO yao_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ŵandu uŵalongolele ŵala ŵankalipile kuti amyalale, nambo ŵelewo ŵapundangenye kunyanyisya achitiji, “Uŵelesi u che Daudi, choonde mungolele chanasa!” ");
INSERT INTO yao_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Che Yesu ŵajimi ni ŵalamwile kuti ŵapeleche paujo pao. Jwangalola jula paŵaŵandichile Che Yesu ŵammusisye, ");
INSERT INTO yao_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ana nkusaka nampanganyichisye ichichi?” Ŵajanjile, “Ambuje, ngusaka ngombole kulola sooni.” ");
INSERT INTO yao_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Che Yesu ŵansalile, “Nnole! Chikulupi chenu chinnamisye.” ");
INSERT INTO yao_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Papopo pepo ŵakombwele kulola sooni ni ŵakuiye Che Yesu achakusyaga Akunnungu. Ŵandu wose paŵaiweni yeleyo ŵalapile Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Che Yesu ŵajinjile ku Yeliko ni ŵaliji nkupita. ");
INSERT INTO yao_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jwapali mundu jumo liina lyakwe che Sakayo, juŵaliji jwankulu jwa ŵakukumbikanya nsongo, nombe jwaliji jwachipanje. ");
INSERT INTO yao_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ŵasachile kwawona Che Yesu kuti ŵaliji ŵaani nambo ŵalepele ligongo lya winji wa ŵandu ni pakuŵa ŵaliji jwanjipi. ");
INSERT INTO yao_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nipele, ŵautuchile mmbujo ni ŵakwesile chitela chachikulungwa cha nkuju kuti akombole kwawona pakuŵa ŵaliji nkupita lyele litala lyo. ");
INSERT INTO yao_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Che Yesu paŵaiche peuto po ŵalolite mwinani ni ŵansalile, “Che Sakayo, ntuluche chitema pakuŵa lelo jino ikumajila kulonjela mu nyuumba jenu.” ");
INSERT INTO yao_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Che Sakayo ŵajangwiye kutuluka ni ŵapochele kwa kusengwa. ");
INSERT INTO yao_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ŵandu wose paŵaiweni yele, ŵatandite kunyinyita achitiji, “Ajinjile kulonjela kwa mundu jwa sambi.” ");
INSERT INTO yao_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nambo che Sakayo ŵajimi paujo ni ŵaasalile Che Yesu, “Ambuje mumbilikanichisye! Une ching'aŵanye ipanje yangu pambindikati ni chinape ŵandu ŵakulaga ni iŵaga najigele chindu cha mundu jwalijose kwa chigongomalo, chinauchisye kacheche.” ");
INSERT INTO yao_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Che Yesu ŵansalile kuti, “Lelo jino ukulupusyo uiche mu nyuumba ji pakuŵa nombejo ali jwauŵelesi u che Iblahimu. ");
INSERT INTO yao_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pakuŵa Mwana jwa Mundu aiche kukwasosa ni kukwakulupusya ŵasochele.” ");
INSERT INTO yao_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ŵandu ŵaliji nkwapilikanila Che Yesu. Ni paŵaliji nkuŵandichila ku Yelusalemu ŵandu ŵaganisyaga kuti Umwenye wa Akunnungu uŵandichile kuoneka. Kwa ligongo lyo ŵatanjile sooni chitagu. ");
INSERT INTO yao_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ŵatite, “Jwapali mundu jwa lukosyo lwa umwenye juŵajawile kuchilambo cha kutalika kuti akapegwe umwenye ni jwankulu jwa mamwenye ni kuuja. ");
INSERT INTO yao_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Akanaŵe kwaula, ŵaaŵilasile achikapolo ŵao likumi ni ŵapele kila mundu mbiya liunjili limo ni mbiya jimo malinga ni mbote ja miesi jitatu ni kwasalila, ‘Nsumisye malonda mpaka pachiuje.’ ");
INSERT INTO yao_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nambo achinsyene musi, ŵanchimile ni ŵalajisye ŵantenga ajaule akajile ‘Ngatukunsaka mundu ju atulongosye uwe.’ ");
INSERT INTO yao_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Nambo, mundu jo ŵausile sooni kumusi ali amasile kupochela umwenye ni ŵalamwile kuti akaaŵilanjile achikapolo uŵapele mbiya ŵala kuti achimanyilile chachipundile chajinjisye kila mundu. ");
INSERT INTO yao_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kapolo jwaandanda jwaiche paujo pao ni ŵatite, ‘Ambuje, mbiya jenu jimwambele jijonjesyeche mbiya likumi.’ ");
INSERT INTO yao_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nombewo ŵansalile, ‘Ntesile yambone, mmwejo ndi kapolo jwambone. Pakuŵa mwaliji jwakukulupilichika pa indu yenandi, nkoleje ulamusi pachanya pa misi likumi!’ ");
INSERT INTO yao_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kapolo jwaaŵili jwaiche nikuti, ‘Ambuje, mbiya jenu jimwambele jijonjesyeche mbiya sine nsano.’ ");
INSERT INTO yao_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nombewo ŵansalile jwelejo kuti, ‘Nomwe ŵakwe nkoleje ulamusi pachanya misi nsano.’ ");
INSERT INTO yao_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nipele, kapolo jwine jwaiche achitiji, ‘Ambuje, aji ni mbiya jenu jimwambele jila, nagosile uchenene mu chiguo cha mwana chammakono. ");
INSERT INTO yao_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ligongo nanjogopaga, pakuŵa mmwe ndi mundu jwakunonopa ntima. Mundu junkuigala yangaŵa yenu ni kugoola yanganimpande.’ ");
INSERT INTO yao_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nombewo ŵansalile, ‘Ngunnamula kwaligongo lya intite pakuŵecheta mmwe kapolo jwangalumbana! Ngati mwaamanyilile kuti une ndili mundu jwakunonopa ntima, jungwigala yangaŵa yangu ni jungugowola yanganimbande. ");
INSERT INTO yao_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ligongo chi nganinjausya mbiya jangu kwa ŵakutyosya yakoonjecheka, kuti une pachiuje nyaule ngajigale ni yakupunda yakwe?’ ");
INSERT INTO yao_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Pelepo ŵaasalile uŵajimi pepala ŵala, ‘Munsumule mbiya jo, nkaape jwakwete mbiya likumi jula.’ ");
INSERT INTO yao_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ŵanyawo ŵansalile, ‘Ambuje, nambo jwelejo akwete chile mbiya likumi!’ ");
INSERT INTO yao_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nombewo ŵajanjile kuti, ‘Ngunsalila, kwa jwalijose jwakwete chindu chachipegwa ni kujonjechekwa. Nambo kwa jwanganakola chindu atamuno chamwana chakwete cho chichijigalikwe. ");
INSERT INTO yao_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nambo, yankati aŵaŵa ŵammagongo ŵangu uŵakanile kuti ninaalongosye, mwaichisye apano ni kwasikita paujo pangu.’ ” ");
INSERT INTO yao_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Che Yesu paŵaŵechete gelego, ŵajendelechele ni ulendo paujo pao wa ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Paŵaŵandichile ku Besefage ni ku Besania, chiŵandi ni chikwesya chachigumbele itela ya Miseituni, ŵalajisye ŵaŵili mwa ŵakulijiganya ŵao. ");
INSERT INTO yao_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ŵasalile kuti, “Njaule pa nsinda wauli mmbujo mwenu. Pachinkajinjile mu nsinda mo, chinkansimane mwanambunda jwataŵikwe jwanganakwelekwe ni mundu. Nkangopole ni kunnyikanawo apano. ");
INSERT INTO yao_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sooni iŵaga chakammusye mundu kuti, ligongo chi nkungopola? Nkajile, ‘Ambuje akunsaka.’ ” ");
INSERT INTO yao_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nipele, uŵalajisye ŵala ŵajawile ni ŵaisimene mpela iŵatite pakusalilwa ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Paŵaliji nkungopola mwanambunda jula, achinsyene ni ŵausisye, “Ana ligongo chi nkungopola mwanambunda ju?” ");
INSERT INTO yao_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ŵajanjile, “Ambuje akunsaka.” ");
INSERT INTO yao_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ŵanjigele mwanambunda jula ni kwapelechela Che Yesu. Ŵatandiche iwalo yao pachanya pa mwanambunda jo ni ŵankwesisye Che Yesu pachanya pakwe. ");
INSERT INTO yao_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Paŵajendelechelelaga ni ulendo ŵandu ŵatandiche iwalo yao mwitala. ");
INSERT INTO yao_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Paŵaŵandichile ku Yelusalemu, palitala lyalikutuluchila kuchikwesya chachigumbele itela ya Miseituni, mpingo wose wa ŵandu ni ŵakulijiganya ŵao ŵatandite kuchina ni kwatogolela Akunnungu achinyanyisyaga ligongo lya yakusimonjeka yose iŵaiweni ");
INSERT INTO yao_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ŵatite “Akole upile Mwenye jwakwika mu liina lya Ambuje. Chitendewele kwinani ni ukulu kwa Akumanani.” ");
INSERT INTO yao_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mafalisayo ŵampepe ŵaŵaliji mu mpingo wa ŵandu mula ŵansalile Che Yesu kuti, “Jŵakwiganya, mwakalipile ŵakulijiganya ŵenu!” ");
INSERT INTO yao_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Che Yesu ŵajanjile kuti, “Ngunsalila ŵanyamwe, naga chamyalale ŵanyaŵa, maganga chigatande kunyokonya.” ");
INSERT INTO yao_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Paŵaŵandichile ni kuulola musi wa ku Yelusalemu, Che Yesu ŵalisile ligongo lya musi wo ");
INSERT INTO yao_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","achitiji, “Ikaliji mbaya nkaimanyilile lelo jino, indu yaikwikanawo chitendewele! Nambo sambano isisiche pa meeso genu. ");
INSERT INTO yao_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pakuŵa moŵa chigannyichile mmwe ni ŵammagongo ŵenu chansyunguchisye likumba ni chachinsyungula ni kummijikanya kosekose. ");
INSERT INTO yao_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chankasanye mmwe ni ŵaali nkati likumba lya musi wose ngapagwa liganga lichilisigale palijakwe, ligongo nganinkamanyilila katema paŵannyichile Akunnungu kukunkulupusya.” ");
INSERT INTO yao_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nipele, Che Yesu ŵajinjile pa Nyuumba ja Akunnungu ni ŵatandite kwaŵinjila paasa ŵaŵasumisyaga malonda, ");
INSERT INTO yao_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","achitiji, “Ilembekwe yati, ‘Nyuumba jangu chijiŵe nyuumba ja kupopela’, nambo ŵanyamwe njitesile peuto pakulisisila ŵawiyi.” ");
INSERT INTO yao_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Che Yesu ŵaliji nkwiganya pa Nyuumba ja Akunnungu lyuŵa ni lyuŵa. Nambo achakulu ŵambopesi ni ŵakwiganya Malajisyo ga che Musa ni ilongola ya ŵandu ŵasosile litala lya kwaulaga, ");
INSERT INTO yao_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nambo nganamanyilila ichajile pakupanganya, pakuŵa ŵandu wose ŵaliji nkwapilikanichisya uchenene. ");
INSERT INTO yao_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lyuŵa limo Che Yesu paŵaliji nkwajiganya ŵandu pa Nyuumba ja Akunnungu ni kulalichila Ngani Jambone, ŵaiche achakulu ŵambopesi ni ŵakwiganya Malajisyo ga che Musa ni achachekulu ");
INSERT INTO yao_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ŵammusisye, “Ntusalile! Ana kwa ulamusi chi nkupanganya yeleyi? Sooni ŵaani ŵampele mmwe ulamusi u?” ");
INSERT INTO yao_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Che Yesu ŵajanjile, “Nomwe ŵakwe chinammusye liusyo, musalile, ");
INSERT INTO yao_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ana ulamusi u che Yohana wa kubatisya watyochele kwa Akunnungu pane kwa ŵandu?” ");
INSERT INTO yao_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nambo ŵanyawo ŵaŵechetesyene achitiji yeleyi, “Twajilaga watyochele kwa Akunnungu, chatuusye, ‘Ligongo chi nganimunkulupilila jwelejo?’ ");
INSERT INTO yao_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ni twajilaga watyochele kwa ŵandu, ŵandu wose ŵa chatuulaje ni maganga, pakuŵa ŵandu wose akukulupilila kuti che Yohana ŵaliji jwakulondola jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nipele ŵajanjile, “Ngatukumanyilila kwautyochele ulamusi wo.” ");
INSERT INTO yao_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Che Yesu ŵaasalile ŵanyawo, “None jwakwe ngangunsalila ngutenda yeleyi kwa ulamusi chi.” ");
INSERT INTO yao_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Che Yesu ŵapundile kwatanjila ŵandu chitagu chati, “Mundu jumo ŵalimile ngunda wa misabibu ni ŵakodisisye ŵakulima, nipele ŵajawile ku chilambo chine ni ŵalonjele kweleko moŵa gamajinji. ");
INSERT INTO yao_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Katema kamagungulo, mundu jo ŵantumile kapolo jwao ku ngunda wa misabibu kwa ŵakulima ŵala, kukujigala liunjili lyakwe lya magungulo. Nambo ŵakulima ŵala ŵamputile kapolo jo ni kummusya makono pe. ");
INSERT INTO yao_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nsyene ngunda jula ŵantumile kapolo jwine, nambo jwelejo nombe ni ŵamputile ni kuntendela ya chipongo ni kummusya makono pe. ");
INSERT INTO yao_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ŵantumile sooni jwaatatu, jwelejo nombe ŵammulesye ni kwajasila paasa ngunda. ");
INSERT INTO yao_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nipele nsyene ngunda wa misabibu jula ŵaganisisye achitiji, ‘Chindende ichichi? Chinampeleche mwanangu jwajika jwakunonyelwa pane chakanchimbichisye jwelejo.’ ");
INSERT INTO yao_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nambo ŵakulima ŵala paŵammweni, ŵaŵechetesyene jwine ni jwine, achitiji, ‘Aju ni juchapochele iŵagosele, twende tummulaje kuti indu iŵagosele tujigale uwe.’ ");
INSERT INTO yao_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nipele, ŵankopwesye paasa ngunda wa misabibu ula ni kummulaga.” Nipele Che Yesu ŵausisye, “Ana nsyene ngunda wo, chachatenda ichichi ŵakulima wo?” ");
INSERT INTO yao_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Chaiche ni kwaulaga ŵakulima wo ni kwapa ŵakulima ŵane ngunda wa misabibu wo.” Ŵandu paŵagapilikene gele maloŵe ni ŵatite, “Ngwamba! Gakatukopochela namose kanandi!” ");
INSERT INTO yao_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nambo Che Yesu ŵalolite ŵanyawo ni kwausya, “Ana aga Malembelo ga Akunnungu ga gana malumbo chi? Gagakuti, ‘Liganga lyalikanile ŵakutaŵa, sambano lilyolyo lili lyetendekwe liganga lyekulungwa lyakwimichila nyuumba!’ ");
INSERT INTO yao_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mundu jwalijose juchalikuŵale pa liganga lyo, chakasiche ipande ni lyangwililaga mundu jwalijose chilinsyaje.” ");
INSERT INTO yao_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ŵakwiganya Malajisyo ga Akunnungu ni achakulu ŵambopesi ŵasakaga kunkamula Che Yesu ndaŵi jo, pakuŵa ŵaimanyilile kuti chitagu chi chaliji nkwagamba ŵanyawo nambo ŵaajogwepe ŵandu. ");
INSERT INTO yao_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ŵaliji nkwakuilichisya uchenene nipele, ŵalajisye ŵakuuchilichisya ŵaŵalitendaga ŵambone. Ŵatesile yele kuti ŵatanjisye Che Yesu kwa maloŵe gao ni kwajausya pa ulamusi wa jwankulu jwa chilambo. ");
INSERT INTO yao_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ŵakuuchilichisya wo, ŵammusisye Che Yesu achitiji, “Jwakwiganya, tukumanyilila kuti nkusala ni kwiganya maloŵe ga isyene ni tukumanyilila kuti nganinkola lusagu kwa mundu jwalijose nambo nkwiganya yakuti matame mpela ila Akunnungu yakutulajichisya. ");
INSERT INTO yao_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ntusalile, ana ili yambone kwausya nsongo kwa Mwenye jwa ku Loma pane ngwamba?” ");
INSERT INTO yao_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nambo Che Yesu ŵachimanyilile chitanji chao ni ŵaasalile kuti, ");
INSERT INTO yao_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Muunosye mbiya. Ni ŵausisye kuti ana ku meeso ku ni liina li lyacheni?” Nombewo ŵajanjile, “Ja mwenye jwa ku Loma.” ");
INSERT INTO yao_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Che Yesu ŵaasalile, “Nipele mwape Mwenye jwa ku Loma yaili yao ni Akunnungu yaili yao.” ");
INSERT INTO yao_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nganakombola kwakamula atamuno kwa liloŵe lililyose paujo pa ŵandu nambo ŵasimosile kwanga kwao ni ŵamyalele. ");
INSERT INTO yao_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Masadukayo ŵampepe ŵakutinji, ngapagwa kusyuka kwa ŵandu ŵawile ŵanjaulile Che Yesu ni kwausya, ");
INSERT INTO yao_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Jwakwiganya, che Musa ŵatulembele kuti iŵaga chawe nkulugwe mundu jumo ni kunleka ŵankwakwe pangali ŵanache, mpwakwe ajinjile majumba kuti akombole kummelechela nkulugwe jo ŵanache. ");
INSERT INTO yao_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nipele, ŵapali achachanda saba uŵaŵelekwe ni mundu jumo. Jwaandanda ŵalombele jwankongwe ni ŵawile pangaleka mwanache. ");
INSERT INTO yao_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ni jwaaŵili ŵajinjile majumba nombejo ŵawile pangaleka mwanache, ");
INSERT INTO yao_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ni jwaatatu ŵajinjile majumba, iyoyo peyo wose saba ŵamasile kuwa pangaleka ŵanache. ");
INSERT INTO yao_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kumbesi jwankongwe jula nombe ŵawile. ");
INSERT INTO yao_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Sambano, ana pakumala kusyuka ŵawe jwankongwe jo chachiŵa jwankongwe jwa ŵaani? Pakuŵa wose saba ŵala ŵanlombele jwelejo.” ");
INSERT INTO yao_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Che Yesu ŵaasalile, “Ŵandu ŵa moŵa gano, mchilambo mu akulombela ni kulombekwa, ");
INSERT INTO yao_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","nambo uchaŵalanjikwe kuti akuŵajilwa kusyuswa ni kutama mu katema kakakwika ngasalombela atamuno kulombwa. ");
INSERT INTO yao_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Usyene ukuti ngaikomboleka kuwa sooni, ligongo chachiŵa mpela achikatumetume ŵa kwinani ŵa Akunnungu nombewo chaaŵe ŵanache ŵa Akunnungu, pakuŵa asyuchile. ");
INSERT INTO yao_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Namose che Musa ŵalosisye pangasisa kuti ŵawile chachisyuswa. Mmalembelo gakwe gagalembekwe nkati chisukutu chichakolelaga mooto, ŵelewo akwatanga Ambuje kuti ali Akunnungu ŵa che Iblahimu ni Akunnungu ŵa che Isaka ni Akunnungu ŵa che Yakobo. ");
INSERT INTO yao_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ŵelewo nganaŵa Akunnungu ŵa ŵawile nambo ali Akunnungu ŵa ŵajumi, pakuŵa kwa ŵelewo wose akukola umi.” ");
INSERT INTO yao_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ŵakwiganya malajisyo ŵampepe ŵanjanjile, “Jwakwiganya, elo njanjile isyene.” ");
INSERT INTO yao_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ŵanyawo nganalinga kummusya sooni liusyo line. ");
INSERT INTO yao_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Che Yesu ŵausisye kuti, “Kwa chichi ŵandu akuti Kilisito Nkulupusyo ali wa uŵelesi u che Daudi? ");
INSERT INTO yao_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Che Daudi asyene akuŵecheta mmalembelo ga Sabuli, ‘Ambuje ŵaasalile Ambuje ŵangu, Ntame kundyo kwangu ");
INSERT INTO yao_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpaka pachinaaŵiche ŵammagongo ŵenu paasi pa sajo syenu.’ ");
INSERT INTO yao_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nipele iŵaga che Daudi akwaŵilanga Kilisito Nkulupusyo ‘Ambuje,’ iŵele uli sooni aŵe uŵelesi u che Daudi?” ");
INSERT INTO yao_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ŵandu wose paŵaliji aninkwapilikanila Che Yesu, ŵelewo ŵaasalile ŵakulijiganya ŵao kuti, ");
INSERT INTO yao_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nlilolechesye ni ŵakwiganya malajisyo ŵakusaka kwendajenda ali awete minjilo jajileu. Ŵakunonyelwa akomasikwe kwakuchimbichikwa peuto pakuchingangana ŵandu achajinji ni ŵakutama mu itengu yakuchimbichika mmajumba ga kupopelela ni kutama mmauto gakuchimbichikwa pa chakulya. ");
INSERT INTO yao_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ŵakwasumula majumba achakongwe ŵawililwe ni achiŵankwawo ni kupopela mapopelo gamaleu kuti aloleche ŵambone paujo pa ŵandu. Kwalyele ligongo lyo chalamulikwe kwachikali nnope kupunda ŵane!” ");
INSERT INTO yao_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Che Yesu ŵalolechesye kwa nnope, ŵaaweni ŵaipanje ali nkutaga sadaka syao mu lisanduku lya kugosela sadaka pa Nyuumba ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ŵammweni jwakulaga jwawililwe ni ŵankwawo ali nkutaga senti siŵili. ");
INSERT INTO yao_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nipele, ŵatite, “Isyene ngunsalila kuti, aju jwakulaga jwawililwe ni ŵankwawo atasile yaijinji kwapunda wose. ");
INSERT INTO yao_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pakuŵa ŵane wose atasile sadaka syao kutyochela mu yakupunda ya muipanje yao nambo jweleju nkulaga kwakwe atasile yose yakwete ya umi wakwe.” ");
INSERT INTO yao_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ŵandu ŵampepe ŵa Che Yesu ŵaliji nkukunguluchila yankati Nyuumba ja Akunnungu ijatite pakoloswa ni maganga gambone pampepe ni sadaka sisyatyosikwe kwa Akunnungu. Nipele Che Yesu ŵatite, ");
INSERT INTO yao_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Yele yose inkwiwona chigaiche moŵa gaati ngalisigalila liganga paliganga line pakuŵa yose yo chigumulikwe.” ");
INSERT INTO yao_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nipele ŵakulijiganya ŵao ŵausisye, “Jwakwiganya, ana chigatyochele chakachi gele? Ana chimanyisyo chi chachichilosye kuti gaŵandichile kutendekwa gelego?” ");
INSERT INTO yao_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Che Yesu ŵaajanjile, “Nlilolechesye, ngasinlambuchikwa. Ŵandu ŵajinji chachiika achilitendaga ŵanyawo ali une, achitiji ‘Une ndili Kilisito Nkulupusyo!’ Ni kuti, ‘Katema kaŵandichile.’ Nambo ŵanyamwe ngasimwakuya. ");
INSERT INTO yao_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pachinchipilikana yangondo ni utinda ngasinjogopa pakuŵa ikusachilwa iwoneche kaje yeleyi nambo mbesi ngajityochela kwanakamo.” ");
INSERT INTO yao_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sooni ŵajendelechele kuŵecheta, “Ŵandu ŵa chilambo chimo chachimenyana ni ŵandu ŵa chilambo chine ni umwenye chiuputane ni umwenye wine. ");
INSERT INTO yao_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Chichityochele chindendemesi chachikulungwa cha chilambo ni sala ni ilwele yakogoya panepane. Chiipagwe indu yakogoya ni imanyisyo yaikulungwa kwinani. ");
INSERT INTO yao_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nambo gakanaŵe kukopochela gelego, chinchikamulwa ni kunnagasya ni kunjausya mmajumba ga kupopelela ni kwaŵechetelela ni chachinjausya mmajumba ga kutaŵilwa ŵandu. Chanjigale paujo pa mamwenye ni pa ŵakulamula ligongo lya kungulupilila une, ");
INSERT INTO yao_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","melepe nkombole kuusala umboni wangu kukwao. ");
INSERT INTO yao_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nlapilile mmitima jenu kuti nganganisya kaje ichinjile pakulichenjela. ");
INSERT INTO yao_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Pakuŵa une chinampe ŵanyamwe maloŵe gakuŵecheta pamo ni lunda nombe ŵammagongo ŵenu ngakombola kugakanila namose kugakana. ");
INSERT INTO yao_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Achaŵelesi ŵenu ni achalongo achinjenu ni achapwenu ni achambusanga ŵenu changalauche ŵanyamwe. Ni ŵampepe mwa ŵanyamwe chimmulajikwe. ");
INSERT INTO yao_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ŵandu wose chachinchima ŵanyamwe ligongo lya kungulupilila une. ");
INSERT INTO yao_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nambo namose luumbo lwa mmitwe jenu ngalusoŵa. ");
INSERT INTO yao_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nambo mpunde kupililila, pakuŵa kwa lyele litalalyo chimuukulupusye umi wenu. ");
INSERT INTO yao_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pachinchiuwona musi wa ku Yelusalemu ali asyungwile mipingo ja ŵangondo, pelepo mmanyilile kuti kugumulikwa kwakwe kuŵandichile. ");
INSERT INTO yao_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pelepo, ŵaali ku Yudea autuchile mmatumbi ni ŵaali nkati Yelusalemu akopoche paasa ni ŵele ŵaali mmingunda akaujinjila wele musi wo. ");
INSERT INTO yao_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Pakuŵa gele ni moŵa ga Akunnungu kwalamula ŵandu ŵakwe ŵa ku Isilaeli, kuti gose gagalembekwe Mmalembelo Gamaswela gaŵe isyene. ");
INSERT INTO yao_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Chalaje ŵaali ni iilu ni ŵakonjesya gele moŵago! Pakuŵa chikupagwe kulaga kwakukulungwa pachilambo ni uchimwa wa Akunnungu chiuŵe kwa ŵandu ŵa chilambo chi. ");
INSERT INTO yao_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ni ŵandu ŵampepe chaulagwe kwa lipanga ni ŵane chajigalikwe mateeka ni kwapwilinganya mu ilambo yose. Musi wa Yelusalemu chiulamulikwe ni ŵandu ŵa ilambo ine mpaka pachiumalile ulamusi wao. ");
INSERT INTO yao_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Chiipagwe imanyisyo mu lyuŵa ni mu lwesi ni mu ndondwa. Ŵandu ŵa pa chilambo chasupuche ni kukola lipamba ligongo lya kulindima kwa matumbela ga mu bahali. ");
INSERT INTO yao_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ŵandu chapwe mitima ligongo lya lipamba achilolelaga indu ichityochele pachilambo pano, pakuŵa indu yose yaili ni machili kwiunde chisau lyuŵa ni lwesi ni ndondwa ni ine yose chiitinganyikwe. ");
INSERT INTO yao_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pelepo, chachimmona Mwana jwa Mundu achiikaga mwiunde ni machili gamakulungwa ni ukulu wakwe. ");
INSERT INTO yao_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pachigatande kopochela gelego, njime mwa kulimba nchijinamukula mitwe jenu ligongo chiwombolo chenu chiŵandichile.” ");
INSERT INTO yao_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nipele, Che Yesu ŵatanjile ŵanyawo chitagu chati, “Nnolechesye chitela cha ntini ni itela ine yose. ");
INSERT INTO yao_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nnyiwonaga itela ininkusipuka nkuimanyilila kuti chuuku chiŵandichile. ");
INSERT INTO yao_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iyoyo peyo, nomwe ŵakwe pachinchiiwona yeleyo ichikopochelaga, mmanyilile kuti Umwenye wa Akunnungu uŵandichile. ");
INSERT INTO yao_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Isyene ngunsalila, au uŵelesi wu ngaumala mpaka indu yose pachiimalichikwe. ");
INSERT INTO yao_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kwinani ni chilambo chiimale nambo maloŵe gangu ngagamala ng'oo.” ");
INSERT INTO yao_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nambo nlilolechesye mwachimisyene, kuti mitima jenu ngasijitopelwa ni upoche ni kukolelwa ni kusauchila umi u. Pakuŵa lyele lyuŵa lyo chilinnyichilile chisisimuchile. ");
INSERT INTO yao_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Pakuŵa chilyaichilile mpela chitanji wose ŵakutama mu chilambo chose. ");
INSERT INTO yao_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nipele nlilolechesye ni kupopela katema kose kuti nkole machili mpakombole kuŵambala yele yose ichityochele ni kwima paujo pa Mwana jwa Mundu.” ");
INSERT INTO yao_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Che Yesu ŵaliji nkwajiganya ŵandu pa Nyuumba ja Akunnungu katema kose ka muusi nambo katema ka chilo ŵajaulaga kukutama kuchikwesya cha Miseituni. ");
INSERT INTO yao_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ŵandu wose ŵajimukaga kundaŵi pe ni nkwaula pa Nyuumba ja Akunnungu kukwapilikanila Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lyaŵandichile lyuŵa lyekulungwa lya mikate jangatajikwa chilungo lyalikuŵilanjikwa Pasaka. ");
INSERT INTO yao_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Achakulu ŵambopesi ni ŵakwiganya Malajisyo ŵaliji nkusosa itajile pakwaulaga Che Yesu nambo ŵaliji nkwajogopa ŵandu. ");
INSERT INTO yao_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nipele Shetani ŵanjinjile che Yuda jwakuŵilanjikwa Isikaliote, jumo jwa achinduna kumi na mbili ŵala. ");
INSERT INTO yao_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Che Yuda ŵajawile ni kuŵechetesyana ni achakulu ŵambopesi ni achakulungwa ŵa ŵakulindilila Nyuumba ja Akunnungu itajile pakwakamusya kwakamula Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nombewo ŵasengwile ni kwilana nawo kuti chiŵape mbiya. ");
INSERT INTO yao_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Che Yuda ŵajitichisye ni kutanda kusosa lipesa lyambone lyakwakamusya kwakamula Che Yesu pangali kumanyilila ŵandu. ");
INSERT INTO yao_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nipele, lyaiche lyuŵa lya mikate jangatajikwa chilungo. Iyoyo peyo ni lyuŵa lyalikusachilwa kusikita mwanangondolo jwa Pasaka. ");
INSERT INTO yao_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Che Yesu ŵaatumile che Petulo ni che Yohana achitiji, “Njaulangane nkatukulumichisye chakulya cha Pasaka kuti tulye.” ");
INSERT INTO yao_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nombewo ŵausisye Che Yesu, “Ana nkusaka tukachikolochesye kwapi?” ");
INSERT INTO yao_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ni ŵajanjile, “Mpilikanile! Pachinkajinjile pa musi po, chinkasimane ni jwannume ali atwichile lulo lwa meesi. Nkaakuye ŵelewo mpaka mu nyuumba jichakajinjile. ");
INSERT INTO yao_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mwasalile asyene nyuumba jo, ‘Jwakwiganya akummusya, chili kwapi chuumba muchingalile chakulya cha Pasaka pamo ni ŵakulijiganya ŵangu?’ ");
INSERT INTO yao_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nombewo chakannosye chuumba chachikulungwa cha penani chachili ni indu yose yaikusachilwa mu chuumba. Nkakulumisye mwelemo.” ");
INSERT INTO yao_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ŵajawile ni ŵaisimene indu yose ili mpela iŵatite pakusalilwa ni Che Yesu, nombewo ŵakulumisye chakulya cha Pasaka. ");
INSERT INTO yao_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pakaiche katema, Che Yesu ŵatemi kulya pamo ni achinduna ŵakwe. ");
INSERT INTO yao_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ŵasalile, “Najile kwannope kulya chakulya cha Pasaka pamo ni ŵanyamwe nganime kulagaswa. ");
INSERT INTO yao_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pakuŵa ngunsalila kuti, nguulya sooni chakulya cha Pasaka mpaka pachiŵe isyene mu Umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nipele Che Yesu ŵajigele chikombe ni paŵamasile kwatogolela Akunnungu ŵatite, “Mpochele ni mpelegane mwachimisyene. ");
INSERT INTO yao_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pakuŵa ngunsalila kuti, chitandile sambano ngaang'wa sooni divai mpaka pachiuiche Umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sooni ŵajigele nkate ni kwatogolela Akunnungu, ŵagaŵenye ni kwapa achitiji, “Chelechi ni chiilu changu chachikutyochekwa ligongo lyenu. Ntendeje yeleyi kwa kungumbuchila une.” ");
INSERT INTO yao_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Iyoyo peyo paŵamasile kulya ni ŵajigele chikombe achitiji, “Achi chikombechi lili lilangano lya sambano lya Akunnungu lyalikutendekwa kwa miasi jangu jajikwitika kwa ligongo lyenu. ");
INSERT INTO yao_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nambo, nnole! Jwejula jwakung'alauka ali papapa akulya pamo ni une. ");
INSERT INTO yao_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Pakuŵa Mwana jwa Mundu chajaule kukuulagwa mpela iŵasachile Akunnungu, nambo ulaje uŵe kwa mundu jwakungalauka jo.” ");
INSERT INTO yao_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pelepo ŵatandite kuusyana achinsyene pe, ana ŵaani ŵelewo uchatende chele chinducho! ");
INSERT INTO yao_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Gatyochele makani pasikati ja ŵakulijiganya gankati ŵaani jwali jwankulungwa kupunda ŵane. ");
INSERT INTO yao_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Che Yesu ŵaasalile, “Mamwenye ŵa pachilambo akwalamula ŵandu ŵao kwa machili, nombe ŵakwete ulamusi pachanya pao akuliŵilanga, ‘achambusanga ŵa ŵandu’. ");
INSERT INTO yao_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nambo inaŵe yeleyo kukwenu, jwali jwankulungwa aŵeje nti jwannandi mwa wose ni jwali chilongola aŵeje nti jwakutumichila. ");
INSERT INTO yao_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Pakuŵa, ŵaani jwali jwankulungwa, jwatemi kulya pane jwakutumichila? Isyene ni jwejula jwatemi paasi kulya! Nambo une ndili pasikati jenu mpela jwakutumichila. ");
INSERT INTO yao_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ŵanyamwe ni untemiji pamo ni une katema kose kakulinjikwa kwangune. ");
INSERT INTO yao_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mpela ila Atati ŵangu iŵatite pakuumba une ulamusi wa umwenye kulamula iyoyo peyo noneji ngumpa ulamusi wa kulamula. ");
INSERT INTO yao_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kuti ndye ni kung'wa pamo ni une mu Umwenye wangu. Chintame mu itengu ya Umwenye nchilamulaga ngosyo kumi na mbili sya Ŵaisilaeli.” ");
INSERT INTO yao_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Che Yesu ŵatite, “Che Simoni, che Simoni! Mpilikane! Shetani aŵendile luusa kwa Akunnungu ja kunlinga ŵanyamwe mpela mundu yakuti kupeta ngano alole iŵaga chimpunde kuŵa ŵakulupilichika. ");
INSERT INTO yao_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nambo une nampopelele mmwe kuti chikulupi chenu chikapunguka. Nomwe pachimumujilile sooni, mwalimbisye mitima achinjenu.” ");
INSERT INTO yao_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Che Petulo ŵajanjile, “Ambuje, une ndili chile kutaŵikwa pamo nomwe ni kuwa pamo nomwejo.” ");
INSERT INTO yao_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nambo Che Yesu ŵanjanjile, “Ngunsalila mwe che Petulo, lelo jino jikanaŵe kutongola tambala chimungane katatu kuti ngankuumanyilila une.” ");
INSERT INTO yao_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nipele Che Yesu ŵausisye ŵakulijiganya ŵao, “Panantumile pangali chilolo ni nsaku ni ilatu ine pala ana mwasoŵikwe ni chichi?” Ni ŵanjanjile, “Ngapagwa.” ");
INSERT INTO yao_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nombe Che Yesu ŵaasalile, “Nambo sambano, jwakwete chilolo ajigale ni nsaku iyoyo peyo. Ni jwanganakola lipanga, asumisye mwinjilo wao akasume limo. ");
INSERT INTO yao_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ilembechekwe Mmalembo ga Akunnungu, ‘Ŵaŵalanjikwe ali jumo jwao pasikati ŵandu ŵa sambi.’ Ngunsalila yeleyi Malembelo gakusachilwa gaŵe isyene kwa une, pakuŵa uumi wangu ukuichila kumbesi.” ");
INSERT INTO yao_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ŵakulijiganya ŵatite, “Ambuje, nnole, apano tukwete mapanga gaŵilipe.” Nombewo ŵajanjile, “Ayaga!” ");
INSERT INTO yao_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Che Yesu ŵatyosile ni kwaula pa chitumbi cha Miseituni mpela iŵatite pakusyoŵelela ni ŵakulijiganya ŵao ŵakuiye. ");
INSERT INTO yao_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Paŵaiche pelepo, ŵaasalile ŵanyawo, “Mpopele kuti nkajinjila nkulinjikwa.” ");
INSERT INTO yao_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nipele, ŵalesile ŵanyawo ni ŵajawile kwati mundu nkukombola kuponya liganga ni ŵatindiŵele ni kupopela. ");
INSERT INTO yao_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ni ŵatiji, “Atati, mwasakaga mundyochesye achi chikombe cha malagasyo, nambo gankugasaka mmwe gapanganyikwe ni ngaŵa kwa kusaka kwangu.” ");
INSERT INTO yao_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Pele katumetume jwa kwinani jwakopochele ni kwataga machili. ");
INSERT INTO yao_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Che Yesu ŵaliji mchipwetesi chachikulungwa ni ŵapundile kupopela kwannope. Chitukuta chatyosile ni chaliji mpela mandondwa ga miasi gagaliji nkwilima mpaka paasi. ");
INSERT INTO yao_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Paŵamasile kupopela, ŵajimwiche ni kwajaulila ŵakulijiganya ŵao ni ŵasimene nnugono ligongo ŵaliji nkusupuka. ");
INSERT INTO yao_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ŵaasalile, “Ana ligongo chi nkugona? Njimuche ni kupopela kuti nkajinjila nkulinjikwa.” ");
INSERT INTO yao_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Che Yesu paŵaliji nkuŵecheta, mpingo wa ŵandu waiche uchilongolelwaga ni che Yuda juŵaliji jumo jwa achinduna kumi na mbili. Che Yuda ŵajawile ni kwakomasya Che Yesu kwa kwanonyela. ");
INSERT INTO yao_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nambo Che Yesu ŵansalile, “Che Yuda! Ana nkungalauka Mwana jwa Mundu kwa chikomasyo cha ngomo mmajeje?” ");
INSERT INTO yao_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ŵele ŵakulijiganya ŵa Che Yesu paŵaimanyi ichityochele ni ŵatite, “Ambuje, twakunule ni mapanga?” ");
INSERT INTO yao_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ni jumo jwao ŵankunwile kapolo jwa jwankulungwa jwambopesi ni kwakapa lipikanilo lya kundyo. ");
INSERT INTO yao_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pelepo Che Yesu ŵaŵechete, “Nneche! Ikwanile.” Ni ŵalikwaiye lipikanilo lya jwele mundu jo ni kunnamya. ");
INSERT INTO yao_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nipele Che Yesu ŵaasalile achakulu ŵambopesi ni achakulungwa ŵa ŵakulindilila nyuumba ja Akunnungu ni achachekulu uŵaikangene kukwakamula, “Ana nnyiche ni mapanga ni imbonga kukungamula mpela ndili jwachiswamba? ");
INSERT INTO yao_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Panaliji pamo ni ŵanyamwe moŵa gose pa Nyuumba ja Akunnungu nganimungamula. Nambo aka ni katema kenu, katema ka jwaulamusi wa chipi.” ");
INSERT INTO yao_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nipele ŵankamwile ŵanjigele ni kwajausya ku nyuumba ja Jwankulu Jwambopesi. Che Petulo ŵankuiye chakunyuma kwakutalichila. ");
INSERT INTO yao_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ŵakolesisye mooto pasikati lwani, ŵatemi pamo nombe che Petulo ŵaiche ni kutama pamo nawo. ");
INSERT INTO yao_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kapolo jumo jwankongwe, paŵammweni che Petulo ali atemi chiŵandi ni mooto wo ŵaalolechesye kwannope ni kuti, “Ni mundu ju nombe ŵaliji pamo ni Che Yesu.” ");
INSERT INTO yao_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nambo che Petulo ŵakanile achitiji, “Mmwe jwankongwe, ngangummanyilila jwelejo!” ");
INSERT INTO yao_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kanyuma kanandi, mundu jwine ŵammweni che Petulo ni ŵatite, “Ni mmwe ŵakwe nndi jumo jwao.” Nambo che Petulo ŵanjanjile “Alakwe ngaŵa une!” ");
INSERT INTO yao_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mpela lisaa limo mmbujo, mundu jwine ŵaŵechete achitiji, “Isyene nguti, aju mundu ju nombe ŵaliji pamo nawo pakuŵa jwelejo nombe ali Mgalilaya.” ");
INSERT INTO yao_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nambo che Petulo ŵatite, “Alakwe, nganguchimanyilila chinkuŵecheta cho!” Papopo akanaŵe kumalisya kuŵecheta, tambala jatongwele. ");
INSERT INTO yao_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ambuje ŵagalawiche ni kwalolechesya che Petulo, nombe che Petulo ŵagakumbuchile maloŵe ga Ambuje gaŵansalile, “Chilo cha lelo jino jikanaŵe kutongola tambala, chimungane katatu.” ");
INSERT INTO yao_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pelepo ŵakopweche paasa ni ŵalisile kwa nnope. ");
INSERT INTO yao_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ŵandu uŵankamwile Che Yesu ŵala, ŵatandite kwatendela chanache ni kwagomba. ");
INSERT INTO yao_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ŵantaŵile chiguo ku meeso ni ŵammusisye, “Nsagamukule, Ana ŵaani ŵangombile mmwe?” ");
INSERT INTO yao_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ŵammechetele maloŵe gamajinji ga kwatukana. ");
INSERT INTO yao_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pakwachele, nkungulu wa achachekulu ni achakulu ŵambopesi ni ŵakwiganya Malajisyo ŵasimene pamo, ni ŵannyichenawo Che Yesu pankungulu wao wekulungwa wa Chiyahudi. ");
INSERT INTO yao_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ni ŵausisye “Ntusalile! Ana mmwejo ni Kilisito Nkulupusyo?” Che Yesu ŵajanjile, “Atamuno nansalilaga, ngamungulupilila ng'oo, ");
INSERT INTO yao_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","sooni, natamuno nammusyaga liusyo, ngamunyanga. ");
INSERT INTO yao_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nambo chitandile sambano, Mwana jwa Mundu chatame kundyo kwa Akunnungu ŵaali ni Machili.” ");
INSERT INTO yao_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pelepo wose ŵammusisye, “Ni kuti mmwejo ni Mwana jwa Akunnungu?” Ŵajanjile, “Ŵanyamwe nkutinji ndili une.” ");
INSERT INTO yao_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nombewo ŵatite, “Ana umboni chi sooni utukusaka? Pakuŵa tupilikene twachinsyene achiŵechetaga pakang'wa jakwe asyene!” ");
INSERT INTO yao_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nipele, ŵandu wose uŵachingangene pepala ŵajimi ni kwajausya Che Yesu mmbujo mwa che Pilato. ");
INSERT INTO yao_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ŵatandite kwaŵechetela, achitiji, “Twansimene mundu ju ali nkwalyungasya ŵandu ŵa chilambo chetu ali nkwakanya ŵandu kutyosya nsongo kwa Mwenye jwa ku Loma ni kulitenda kuti jwelejo ali Kilisito Nkulupusyo, Mwenye.” ");
INSERT INTO yao_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Che Pilato ŵammusisye Che Yesu, “Ana mmweji ni mwenye jwa Ŵayahudi?” Che Yesu ŵajanjile, “Mmwejo mwasyene ni ummechete.” ");
INSERT INTO yao_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nipele, che Pilato ŵaasalile achakulu ŵambopesi ni mpingo wa ŵandu, “Nganguchiwona chachili chose chakuti nannamule mundu ju.” ");
INSERT INTO yao_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nambo ŵanyawo ŵachalile nnope achitiji, “Akwalyungasya ŵandu kwa majiganyo gao mu chilambo chose cha ku Yudea. Ŵatandite ku Galilaya ni sambano aiche apano.” ");
INSERT INTO yao_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Che Pilato paŵapilikene yeleyo, ŵausisye, “Ana mundu ju ali jwa ku Galilaya?” ");
INSERT INTO yao_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Paŵaimanyilile kuti Che Yesu ŵaliji jwa chilambo chachili mu ulamusi u che Helode, ŵampeleche ku che Helode, juŵaliji kukoko ku Yelusalemu gele moŵa go. ");
INSERT INTO yao_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Che Helode paŵammweni Che Yesu ŵasangalele nnope. Chitandile kalakala ŵalajile kwawona pakuŵa ŵapilikene ngani syao, nombewo ŵalolelaga kwawona Che Yesu ali nkupanganya imanyisyo. ");
INSERT INTO yao_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nipele che Helode ŵammusisye Che Yesu mausyo gamajinji nambo Che Yesu nganajanga lili lyose. ");
INSERT INTO yao_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Achakulu ŵambopesi ni ŵakwiganya Malajisyo uŵaliji pelepo ŵaŵechetele Che Yesu kwa machili. ");
INSERT INTO yao_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nipele, che Helode ni ŵangondo ŵakwe, ŵanyelwisye ni kwatukana Che Yesu ni kwawasya iwalo yakusalala ni ŵammuchisye ku che Pilato. ");
INSERT INTO yao_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lye lyuŵa lyo che Helode ni che Pilato ŵajilene ni kuŵa uganja pakuŵa chitandilile kalakala ŵatindene lyasi. ");
INSERT INTO yao_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nipele, che Pilato ŵasimanisye achakulu ŵambopesi ni ilongola ni ŵandu, ");
INSERT INTO yao_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ni ŵaasalile, “Mumbelechele mundu ju nchitiji ŵaliji nkwalyungasya ŵandu. Sambano mpilikane! Uneji sosilesosile ngani syao mmbujo mwenu nambo nganinansimana ni ligambo lili lyose lyankati indu imwammechetele. ");
INSERT INTO yao_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ngaŵa uneji pe, atamuno che Helode ammuchisye kukwetu pakuŵa nganaliwona ligambo lili lyose. Usyene ukulosya kuti mundu ju nganatenda chachili chose changalumbana chakwaŵajila chiwa. ");
INSERT INTO yao_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nipele, chilamule kuti aputikwe mbokola nombe chinalechelele.” ");
INSERT INTO yao_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pakuŵa ŵasachilwe kwaugulila jwataŵikwe jumo katema ka Pasaka. ");
INSERT INTO yao_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nambo wose ŵatandite kunyanyisya kwanakamo achitiji, “Mummulaje mundu ju, ntugopolele che Balaba!” ");
INSERT INTO yao_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Che Balaba ŵataŵikwe mu nyuumba jakutaŵilwa ligongo lya kukamulangana ni ŵandu ŵaŵatindigenye mu musi ni mu utinda wo ŵaulajikwe mundu jumo. ");
INSERT INTO yao_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Che Pilato ŵasachile kwalechelela Che Yesu, ŵaŵechete nawo kaaŵili kwakunyanyisya. ");
INSERT INTO yao_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nambo ŵanyawo ŵanyanyisye sooni, “Mwaŵambe pa nsalaba, Mwaŵambe pa nsalaba!” ");
INSERT INTO yao_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Che Pilato ŵaasalile kaatatu, “Ana changalumbana chi chatesile mundu ju? Nganguliwona ligambo lililyose nkati mundu ju lyati ikwaŵajila chiwa. Nipele chilamule aputikwe mbokola ni kwalechelela.” ");
INSERT INTO yao_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nambo ŵanyawo ŵapundile kunyanyisya kwa machili nnope kuti Che Yesu akusachilwa kuŵambikwa pa nsalaba. Kumbesi kwakwe, maloŵe gao gapikaniche. ");
INSERT INTO yao_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Che Pilato ŵalamwile kuti chasachilenje chipanganikwe. ");
INSERT INTO yao_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ŵangopwele jwelejo juŵataŵikwe kwa ligongo lya kutindiganya ni kuulaga ni kwatyochesya Che Yesu kwa ŵangondo kuti ŵatende mpela iŵasakaga. ");
INSERT INTO yao_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ŵangondo paŵalinji nkwajausya Che Yesu kukwaŵamba pa nsalaba ŵasimene ni mundu liina lyao che Simoni jwa ku Kulene, juŵatyochelaga mu nsinda kwinjila mu musi. Ŵankamwile ni kwatwika nsalaba ni kwakuya Che Yesu panyuma. ");
INSERT INTO yao_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mpingo wekulungwa wa ŵandu wankuiye, mwa ŵanyawo ŵapali achakongwe uŵaliji nkulila nnope ni kulila kwa malumbo. ");
INSERT INTO yao_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Che Yesu ŵaagalauchile ŵanyawo ni kwasalila, “Mwanya achakongwe ŵa ku Yelusalemu! Ngasimulilila une nambo nlililile mwachinsyene ni ŵanache ŵenu. ");
INSERT INTO yao_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pakuŵa moŵa chigaiche pachachiti, ‘Ŵana upile ŵangakuŵeleka ni ŵanganaŵeleka ni konjesya!’ ");
INSERT INTO yao_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pelepo ni pachatande kuisalila ikwesya kuti ‘Ntugwilile!’ Ni matumbi, ‘Ntuunichile!’ ");
INSERT INTO yao_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pakuŵa, iŵaga ŵandu akutenda yeleyi kwa une jundi mpela chitela chachiŵisi. Ana chatende chichi kukwenu ŵandi mpela chitela chejumu?” ");
INSERT INTO yao_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nombe ŵapali ŵandu ŵane ŵaŵili, uŵatendaga yangalumbana, ŵajigalikwe kukuulajikwa pamo ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Paŵaiche kwiuto, liina lyakwe, “Chikalakasa cha Ntwe,” Nipele kweleko ŵaŵambile pa nsalaba Che Yesu pamo ni aŵala ŵaŵili uŵaitendekanyaga yangalumbana, jumo kundyo kwao ni jwine kunchiji. ");
INSERT INTO yao_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Che Yesu ŵatite, “Atati, mwalechelesye pakuŵa ngakuimanyilila yakuitendayi.” Nipele, ŵagaŵene iwalo yao kwa kuitendela gudugudu. ");
INSERT INTO yao_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ŵandu ŵajimi achilolaga. Achakulu ŵa chiyahudi ŵanjalwisye Che Yesu achitiji, “Ŵakulupwisye ŵane, sambano alikulupusye nsyene iŵaga jwelejo ni Kilisito Nkulupusyo jwasagulikwe ni Akunnungu!” ");
INSERT INTO yao_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ŵangondo nombewo ŵanjalwisye Che Yesu ni kwapelechela divai ja kuipa, ");
INSERT INTO yao_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ni ŵanyawo ŵansalile, “Iŵaga isyene mmwejo ni Mwenye jwa Ŵayahudi, nlikulupusye mwasyene.” ");
INSERT INTO yao_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ni pachanya nsalaba ŵaŵisile chindu chachilembekwe yele, “Aŵaŵa ALI MWENYE JWA ŴAYAHUDI.” ");
INSERT INTO yao_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jumo jwa aŵala uŵatendaga yangalumbana uŵaŵambikwe pepala ŵantukene Che Yesu achitiji, “Ana mmwejo ngati ni Kilisito Nkulupusyo? Nlikulupusye mwasyene noweji iyoyo peyo.” ");
INSERT INTO yao_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nambo jwine jula ŵankalipile achitiji, “Ana mmweji ngankwajogopa Akunnungu namose kanandi? Namuno mmwejo nnamulikwe chisau ni ŵele. ");
INSERT INTO yao_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mmwe ni une tukuŵajilwa, pakuŵa aji ni mbote ja sambi syatutesile. Nambo aju mundu ju nganapanganya chachili chose changalumbana.” ");
INSERT INTO yao_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nipele ŵaŵechete, “Choonde Che Yesu! Mungumbuchile pachinchiinjila mu umwenye wenu.” ");
INSERT INTO yao_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Che Yesu ŵanjanjile jwelejo, “Isyene ngunsalila, lelo jino chimme pampepe none kumbepo.” ");
INSERT INTO yao_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kaliji mpela katema ka lyuŵa pantwe, sooni kwaliji chipi pachilambo chose mpaka saa tisa, ");
INSERT INTO yao_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ni lyuŵa lyalesile kuŵala ni nguo ja lusasa ja mu Nyuumba ja Akunnungu japapwiche pambindikati. ");
INSERT INTO yao_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Che Yesu ŵanyanyisye achitiji, “Atati, ngujiŵika mbumu jangu mmakono mwenu.” Paŵamasile kuŵecheta gelego, ŵawile. ");
INSERT INTO yao_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jwankulu jwaŵangondo paŵaiweni iyatendekweyo, ŵaakusisye Akunnungu achitiji, “Isyenepe, mundu ju jwaliji jwambone.” ");
INSERT INTO yao_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mpingo wa ŵandu wasongangene ligongo lyakulola iyatendekwe, paŵaiweni yeleyo, ŵaujangene mmangwawo aninkuliputa pa ntima pao kwakulilasika. ");
INSERT INTO yao_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Achambusanga ŵao wose ni achakongwe uŵalongene nawo kutyochela ku Galilaya, ŵajimi kwakutalichila, aninkulola yaikutyochela. ");
INSERT INTO yao_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jwapali mundu liina lyao che Yusufu, jumo jwa ŵantenga ŵa nkungulu wekulungwa wa Chiyahudi. Mundu ju ŵaliji jwambone ni jwakupanganya yaikwanonyelesya Akunnungu, ");
INSERT INTO yao_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ni nganajitichisyana nawo iŵaisachile ni kuipanganya. Jweleju jwaliji mundu jwa nsinda umo wa Chiyahudi waukuŵilanjikwa Alimataya ni jwaliji nkulolela Umwenye wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nipele, jwele mundu ŵajawile ku che Pilato, ŵaŵendile apegwe chiilu chi Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nipele, che Yusufu ŵachitulwisye chiilu pa nsalaba ni kuchiŵilijila ni sanda ni ŵachiŵisile mwilembe lilyasepekwe palwala, lilyaliji likanaŵe kuŵichikwa mundu. ");
INSERT INTO yao_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lyele lyuŵa lyo lyaliji lyuŵa lyakuliŵika chile kwa ligongo lya Lyuŵa lya Kupumulila. ");
INSERT INTO yao_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ni achakongwe uŵalongene nawo Che Yesu kutyochela ku Galilaya ŵala, ŵakuiye che Yusufu ni ŵaliweni lilembe lyo ni yachitite pakuŵichikwa chiilu chi Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nipele, ŵausile kumusi ni kulinganya mauta ga malahamu ni mauta gakununjila gakugapakasya chiilu chi Che Yesu. Lyuŵa lya Kupumulila ŵapumulile mpela igakuti kulamula Malajisyo. ");
INSERT INTO yao_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lyuŵa lyaandanda lya chijuma kundaŵi pe, achakongwe ŵala ŵapite ku lilembe ali ajigele mauta gakununjila gaŵalingenye. ");
INSERT INTO yao_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Paŵaiche ŵalisimene liganga lyekulungwa lila lili lyegalambule pambali kutyochela pakwinjilila mwilembe. ");
INSERT INTO yao_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nambo paŵajinjile nkati mo nganachisimana chiilu cha Ambuje Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Paŵaliji nkusimonga kwa ligongo lya yeleyo, kwanakamo ŵandu ŵaŵili uŵawete minjilo jakung'alima nnope ŵajimi pachiŵandi. ");
INSERT INTO yao_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ŵele achakongwe wo ŵakamwilwe ni lipamba, ŵakoteme. Nambo ŵandu ŵala ŵaasalile, “Kwa chichi nkunsosa jwanjumi pasikati pa ŵandu ŵawe? ");
INSERT INTO yao_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ŵelewo nganapagwa apano, asyuchile! Nkumbuchile iŵatite pakunsalila paŵaliji chiŵela ku Galilaya kula, ");
INSERT INTO yao_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","achitiji, ‘Mwana jwa Mundu akusachilwa kuŵichikwa mmakono mwa ŵandu ŵa sambi ni kwaŵamba pa nsalaba nambo pa lyuŵa lyaatatu pakumala chiwa chao chachisyuka.’ ” ");
INSERT INTO yao_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pelepo achakongwe wo ŵagakumbuchile maloŵe ga Che Yesu. ");
INSERT INTO yao_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ŵausile kutyochela ku lilembe ni kwasalila achinduna kumi na moja pamo ni ŵakulijiganya ŵane ngani sya yele yose yo. ");
INSERT INTO yao_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ŵele uŵaapelechele achinduna syele ngani ŵaliji che Maliamu kutyochela musi wa ku Magidala ni che Joana ni che Maliamu achikulugwe che Yakobo pamo ni achakongwe ŵane uŵalongene nawo. ");
INSERT INTO yao_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nambo achinduna ŵala nganagakulupililaga maloŵe ga ŵele achakongwe wo ŵaganisisye galiji gangali malumbo. ");
INSERT INTO yao_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nambo che Petulo ŵajimwiche, ŵalukunwile mpaka ku lilembe ni ŵakoteme ni kulingulila nkati, ŵajiweni sanda pe. Nipele ŵatyosile achisimongaga ni kuliusya yele iyakopochele. ");
INSERT INTO yao_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lyuŵa lilyolyo, ŵaŵili mwa ŵaŵankuyaga Che Yesu ŵajaulaga ku nsinda umo liina lyakwe Emau, uwaliji kwakutalikangana ni ku Yelusalemu mpela ulendo wa masaa gaŵili. ");
INSERT INTO yao_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ŵalinji nkukunguluchila yankati yose iyakopochele. ");
INSERT INTO yao_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Paŵakungulukaga ni kuusyana, Che Yesu asyene ŵaŵandichile ni kulongana nawo. ");
INSERT INTO yao_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ŵaweni kwa meeso gao nambo gasiŵikwe kuti ngasiŵamanyilila. ");
INSERT INTO yao_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Che Yesu ŵausisye, “Ana ngani chi asi sinkukunguluchila nli nkwenda?” Nombewo ŵajimi chimyalalile ni ku meeso kwao kwalilasiche. ");
INSERT INTO yao_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jumo jwao, liina lyakwe che Kileopa, ŵanjanjile, “Ana mmwemwe pe jwannendo mu Yelusalemu ni ngankuimanyilila indu yaikopochele kweleko agano moŵa ga?” ");
INSERT INTO yao_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Che Yesu ŵausisye, “Ana ngani chi?” Ŵanyawo ŵanjanjile, “Ngani jankati Che Yesu jwa ku Nasaleti. Jwelejo ŵawoneche ni Akunnungu ni ŵandu wose kuti ŵaliji jwakulondola jwa Akunnungu jwali ni ukombole mu indu iŵapanganyaga ni kuŵecheta. ");
INSERT INTO yao_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Achakulu ŵambopesi ni ilongola ŵetu ŵantyosisye melepe alamulikwe chiwa, nombewo ŵaŵambile pa nsalaba. ");
INSERT INTO yao_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Noweji twaliji ni chilolelo chakuti ŵelewo ni ŵaŵatumikwe kwawombola ŵandu ŵa ku Isilaeli. Nambo lelo jino lili lyuŵa lyaatatu chitandilile kutendekwa yeleyo. ");
INSERT INTO yao_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sooni achakongwe ŵampepe mumpingo wetu ŵatutojimye. Ŵajawile ku lilembe kundaŵi pe, ");
INSERT INTO yao_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nambo nganachisimana chiilu chi Che Yesu. Ŵausile ni kutusalila kuti ŵakopochelwe ni achikatumetume ŵa kwinani ŵaŵaasalile kuti ŵelewo ali ŵajumi. ");
INSERT INTO yao_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ŵandu ŵampepe uŵaliji pamo ni uwe ŵajawile ku lilembe kukulola yele yaŵecheteje achakongwe wo, nambo Che Yesu nganiŵawona.” ");
INSERT INTO yao_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nipele, Che Yesu ŵaasalile, “Mwanya nli ŵakuloŵela kwanti yele ni mitima jenu jili jakutopela nkukulupilila maloŵe gose gaŵaŵechete ŵakulondola ŵa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ana nganiyaŵajila Kilisito Nkulupusyo akole masauko ga ni kwanti yeleyo ajinjile mu ukulu wao?” ");
INSERT INTO yao_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nipele, ŵaasagamulile gose gagaliji nkwagamba Mmalembelo ga Akunnungu kutandilila mmalembo ga che Musa mpaka mmalembo ga ŵakulondola ŵa Akunnungu wose. ");
INSERT INTO yao_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Paŵaŵandichile aula nsinda uŵajaulaga, Che Yesu ŵatesile mpela akwaula mmbujo ni ulendo. ");
INSERT INTO yao_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nambo ŵanyawo ŵachondelele kwa kuchalila achitiji, “Ntame nowe pakuŵa sambano kuswele ni chilo chikwinjila.” Nipele ŵajinjile nkati ni kutama nawo. ");
INSERT INTO yao_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Paŵatemi kulya chakulya pamo nawo ŵaujigele nkate ni kwatogolela Akunnungu ni ŵaugaŵenye ni kwapa. ");
INSERT INTO yao_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kwanakamo meeso gao gaunukwiche ni ŵaamanyilile, nambo Che Yesu ŵatyosile pasikati jao. ");
INSERT INTO yao_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nipele ŵaŵechetesyene, “Ana ngaŵa mitima jetu jasisimwiche paŵaŵechetaga nowe mwitala mula ni kutusagamukulila Malembelo ga Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Papopo ŵajimi ni kuujila ku Yelusalemu, ŵaasimene achinduna kumi na moja ŵala pamo ni ŵandu ŵane ali asongangene pamo ");
INSERT INTO yao_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","achitiji, “Isyene Ambuje asyuchile ni ŵakopochele che Simoni.” ");
INSERT INTO yao_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ni uŵakuyaga Che Yesu ŵaŵili ŵala ŵamanyisye yose iyakopochele mwitala mula ni iŵatite pakwamanyilila Che Yesu paŵagaŵenye nkate. ");
INSERT INTO yao_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Paŵaliji nkuŵecheta gelego, Che Yesu nsyene ŵajimi pasikati pao ni ŵaasalile, “Chitendewele chiŵe kukwenu.” ");
INSERT INTO yao_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ŵatojime ni kogopa kwannope achiganisyaga kuti akuliwona lisoka. ");
INSERT INTO yao_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nambo ŵelewo ŵaasalile, “Uli nkutenguka chichi ni kuŵa ni lipamba mmitima jenu? ");
INSERT INTO yao_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nnolanje makono gangu ni makongolo gangu, mmanyililanje kuti ndili une. Mumbapasye mulole pakuŵa lisoka nganilikola chiilu namuno maupa mpela inkuti kunola une.” ");
INSERT INTO yao_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Paŵamasile kuŵecheta gelego ŵalosisye makono ni makongolo gao. ");
INSERT INTO yao_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Paŵaliji akanaŵe kulupilila kwa ligongo lya kusengwa ni kusimonga Che Yesu ŵausisye, “Nkwete chakulya chachili chose pelepa?” ");
INSERT INTO yao_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ŵapele chipande cha somba jejoche. ");
INSERT INTO yao_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ŵachijigele ni kulya paujo pao. ");
INSERT INTO yao_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nipele ŵaasalile, “Gelega ni malumbo ga maloŵe ganansalile panaliji pamo ni ŵanyamwe kuti, gaŵajilwe gamalichikwe gose gagalembekwe gagang'ambaga une mu Malajisyo ga Akunnungu gaŵapele che Musa ni itabu ya ŵakulondola ŵa Akunnungu ni mu Sabuli.” ");
INSERT INTO yao_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nipele ŵaaunukwile mu lunda lwao kuti akolanje kugamanyilila Malembelo ga Akunnungu, ");
INSERT INTO yao_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ŵaasalile, “Ilembechekwe Mmalembelo ga Akunnungu kuti Kilisito Nkulupusyo chalagaswe ni chasyuche lyuŵa lyaatatu pakumala chiwa chao, ");
INSERT INTO yao_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ni kuti ŵandu ŵa ilambo yose chitandile ku Yelusalemu alalichilwe kwa liina lyangu kuti alechanje sambi, nombe Akunnungu chiŵalechelesye. ");
INSERT INTO yao_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ŵanyamwe ni uchimwasalile ŵandu umboni u. ");
INSERT INTO yao_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","None nansyene chinampelechele chilanga cha Atati ŵangu pachanya penu, nambo nnindilile kaje ku Yelusalemu kula mpaka pachimpegwe machili kutyochela kwinani.” ");
INSERT INTO yao_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nipele Che Yesu ŵalongwesye kwaula mpaka ku nsinda wa Besania ni ŵanyakwile makono gakwe ni kwapa upile. ");
INSERT INTO yao_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Paŵaliji nkwapa upile po ŵalisapwile ni ŵajigalikwe kwaula kwinani. ");
INSERT INTO yao_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ŵanyawo ŵapopelele, nombewo ŵausile ku Yelusalemu achichinaga, ");
INSERT INTO yao_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ŵalonjele pa Nyuumba ja Akunnungu moŵa gose achalapaga Akunnungu.");
INSERT INTO yao_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Chikanaŵe gumbikwa chachilichose jwapali jumo jwaŵilanjikwe Liloŵe, nombe jwele liloŵe jo ŵaliji pamo ni Akunnungu, nombejo ŵaliji Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Chitandilile kundanda Liloŵe jo ŵaliji ni Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Indu yose yagumbichikwe ni ŵelewo ni pangali ŵelewo nganichipagwa chachili chose chichagumbichikwe. ");
INSERT INTO yao_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jwelejo ŵaliji ndande ja umi ni wele umi wo uichenawo lilanguka kwa ŵandu. ");
INSERT INTO yao_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ni lyele lilanguka lyo likulanguchisya mu chipi atamuno chipi cho ngachikukombola kulisima lilanguka. ");
INSERT INTO yao_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Akunnungu ŵantumile mundu jumpepe liina lyakwe Yohana, ");
INSERT INTO yao_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","jwelejo ŵaiche kukwasalila ŵandu umboni nkati lilanguka lyo, kuti ŵandu wose apilikane ni kukulupilila. ");
INSERT INTO yao_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Che Yohana nsyene nganaŵa lilanguka lyo nambo ŵaiche kukwasalila ŵandu pangasisa nkati lilanguka lyo. ");
INSERT INTO yao_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lyelelyo lili lilanguka lisyene, lilanguka lyalikwika pachilambo ni kwalanguchisya ŵandu wose. ");
INSERT INTO yao_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jwelejo jwapali pachilambo pano ni kwa jwelejo Akunnungu ŵachigumbile chilambo nambo ŵandu ŵa pachilambo nganiŵamanyilila. ");
INSERT INTO yao_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ŵaiche kwa ŵandu ŵakwe nsyene, nambo ŵandu ŵakwe nganiŵapochela. ");
INSERT INTO yao_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nambo ŵanawose ŵaŵaapochele ni kwakulupilila, ŵaatesile akombole kuŵa ŵanache ŵa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","aŵele ŵanache ŵa Akunnungu ngaŵa kwa kupagwa mpela ŵandu yakuti pa kupagwa ni ngaŵa kwa kusaka kwa mundu nambo apagwile kwa usache wakwe Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nombe Liloŵe jo ŵaliji mundu ni ŵatemi noweji. Ni uweji tuuweni ukulu wao, ukulu wao jwelejo jwajikape jwatyosile kwa Atati Akunnungu, aguumbele umbone ni usyene. ");
INSERT INTO yao_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Che Yohana nsyene paŵambweni ŵaasalile ŵandu ngani jankati jwelejo kwa kunyanyisya achitiji, “Aju ni jwejula junangambaga katema panasasile kuti, ‘Akwika mundu jumo kanyuma kangu jwali jwankulungwa kumbunda une, pakuŵa jwapali uneji ngunaŵe kupagwa.’ ” ");
INSERT INTO yao_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Malinga ni winji wa umbone wao, uweji wose tupochele ntuuka wejinji nnope. ");
INSERT INTO yao_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pakuŵa Akunnungu ŵagaichisye Malajisyo kwa litala li che Musa nambo umbone wa Akunnungu ni usyene ituichile kwa litala li Che Yesu Kilisito. ");
INSERT INTO yao_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ngapagwa mundu juŵambweni Akunnungu katema kakalikose. Mwana jwajikape, jwaali Akunnungu jwausyene, ni jwakunonyelwa ni Atati, jwelejo ni jwatumanyisye Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Au uli umboni wautyosisye che Yohana, katema ilongola ŵa Ŵayahudi kutyochela ku Yelusalemu paŵaatumile ŵambopesi ni Ŵalawi kukwausya, “Ana mmwe ndi ŵaani?” ");
INSERT INTO yao_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Che Yohana nganakaana kwanga, ŵajitichisye pangasisa, “Uneji nguniŵa Kilisito Jwakuwombola.” ");
INSERT INTO yao_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pelepo ŵambusisye, “Sambano mmwe ndi ŵaani? Ana mmwe ni che Elia?” Che Yohana ŵajanjile, “Une nguniŵa che Elia.” Ni ŵambusisye sooni, “Ana mmwe ndi jwakulondola jwa Akunnungu jula juŵatite akwika?” Che Yohana ŵajanjile, “Ngwamba.” ");
INSERT INTO yao_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ni ŵanyawo ŵambusisye, “Sambano mmwe ndi ŵaani? Nkuliŵalanga ichichi? Ntusalile tukaasalile aŵala ŵatutumile kukumbusya.” ");
INSERT INTO yao_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Che Yohana ŵajanjile, mpela ila che Isaya jwakulondola jwa Akunnungu iŵang'ambaga, “Uneji ndili mundu jungunyanyisya liloŵe mwipululu, ‘Njongole litala lya Ambuje.’ ” ");
INSERT INTO yao_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ni aŵala ŵandu ŵaŵalajiswe ni Mafalisayo, ");
INSERT INTO yao_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ŵambusisye che Yohana, “Iŵaga mmwe nganimma Kilisito Jwakuwombola pane che Elia pane jwakulondola jwa Akunnungu jula, kwachichi nkubatisya?” ");
INSERT INTO yao_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Che Yohana ŵajanjile, “Uneji ngubatisya ni meesi, nambo apali jumo mwa ŵanyamwe, jwangankummanyilila. ");
INSERT INTO yao_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ni jwejula jwakwika kanyuma, une nganguŵajilwa kuŵa katumetume jwakuugula migoji ja italawanda yao.” ");
INSERT INTO yao_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yelei yatendekwe mmusi wa ku Besania peesi lusulo lwa Yolodani apala che Yohana paŵabatisyaga ŵandu. ");
INSERT INTO yao_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Malaŵi jakwe, che Yohana ŵambweni Che Yesu aninkwaichilila ni ŵatite, “Nnole, jweleju ali Mwanangondolo jwa Akunnungu jwakwigala sambi sya ŵandu ŵa pachilambo! ");
INSERT INTO yao_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ajuju ni jwejula junangambaga panatite, ‘Kanyuma akwika mundu jumo jwali jwankulungwa kuumbunda une, pakuŵa jwapali uneji ngunaŵe kupagwa!’ ");
INSERT INTO yao_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Uneji nganinaamanyilila, nambo nyiche kukubatisya ni meesi kuti ŵandu ŵa ku Isilaeli ŵaamanyilile.” ");
INSERT INTO yao_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Che Yohana ŵatusalile indu iyaiweni achitiji, “Nambweni Mbumu jwa Akunnungu achitulukaga kutyochela kwinani mpela nguunda ni kwatula pachanya pao. ");
INSERT INTO yao_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Uneji nganinaamanyilila nambo jwelejo juŵandumile ngabatisye ni meesi ŵaasalile, ‘Jwelejo juchimwaone ali nkutuluchilwa ni Mbumu jwa Akunnungu ni kwatula pachanya pao, jwelejo ni juchabatisye ni Mbumu jwa Akunnungu.’ ” ");
INSERT INTO yao_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nipele che Yohana ŵatite, “Uneji naiweni yeleyi ni malasile umboni kuti ajuju ni Mwana jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Malaŵi jakwe, che Yohana ŵaliji sooni ni ŵakulijiganya ŵao ŵaŵili. ");
INSERT INTO yao_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Paŵaweni Che Yesu ali nkupita, ŵatite, “Munnole, ajuju ali Mwanangondolo jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ni aŵala ŵakulijiganya ŵaŵili paŵampilikene che Yohana achiŵechetaga maloŵe go, ŵaakuiye Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nipele, Che Yesu ŵagalawiche, ŵaweni ŵakulijiganya ŵaŵili ŵa che Yohana achakuyaga ŵausisye, “Ana nkusosanga ichichi?” Ni ŵanyawo ŵajanjile, “Labi, ana nkutama kwapi?” Labi malumbo gakwe Jwakwiganya. ");
INSERT INTO yao_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Che Yesu ŵajanjile, “Njisangane ni ŵanyamwe chimmone.” Ŵakulijiganya wo ŵaakuiye, ŵapaweni paŵatamaga, jaliji mpela saa kumi ja ligulo ni ŵanyawo ŵatemi nawo lyuŵa lila. ");
INSERT INTO yao_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jumo jwa aŵala ŵakulijiganya ŵaŵili ŵaŵampilikene che Yohana achiŵechetaga maloŵe go ni kwakuya Che Yesu ŵaliji che Andulea, mpwao che Simoni Petulo. ");
INSERT INTO yao_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Che Andulea ŵansimene kaje che Simoni mpwakwe, ni ŵansalile, “Tummweni Masiya,” yaani “Kilisito Jwakuwombola”. ");
INSERT INTO yao_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nipele, ŵanjawisye ku Che Yesu. Ni Che Yesu ŵannolite che Simoni ni ŵatite, “Mmwejo ni che Simoni mwanagwao che Yohana. Sano chimmilanjikwe che Kefa.” Mchigiliki Petulo, malumbo gakwe, “Lwala.” ");
INSERT INTO yao_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Malaŵi jakwe Che Yesu ŵapite ku chilambo cha Galilaya. Nipele ŵansimene che Filipo ni kunsalila, “Munguye.” ");
INSERT INTO yao_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Che Filipo ŵaliji mundu jwa musi wa ku Besesaida, musi uŵatamaga che Andulea ni che Petulo. ");
INSERT INTO yao_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nipele che Filipo ŵansosile che Nasanieli, ni paŵammweni ŵansalile, “Tummweni ajula juŵalembekwe mmalajisyo ga Akunnungu gaŵapele che Musa ni mu itabu ya ŵakulondola ŵa Akunnungu, Che Yesu kutyochela musi wa ku Nasaleti Mwana ju che Yusufu.” ");
INSERT INTO yao_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nombe che Nasanieli ŵambusisye che Filipo, “Ana chindu chambone chikukomboleka kutyochela ku Nasaleti?” Che Filipo ŵansalile, “Njise kunnole.” ");
INSERT INTO yao_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Che Yesu paŵambweni che Nasanieli achaichililaga ŵatite, “Nnole! Jwele ali Mwisilaeli nsyenesyene, nkati mwakwe mwangali unami.” ");
INSERT INTO yao_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Che Nasanieli ŵausisye Che Yesu, “Ana mumanyilile chinauli?” Che Yesu ŵajanjile, “Akanammilanje che Filipo, nambweni ndi ntemi paasi pa chitela cha ntini pala.” ");
INSERT INTO yao_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Pelepo che Nasanieli ŵatite, “Jwakwiganya, mmwe ndi Mwana jwa Akunnungu, mmwe ndi Mwenye jwa ku Isilaeli!” ");
INSERT INTO yao_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Che Yesu ŵansalile, “Ana mungulupilile pakuŵa nansalile kuti nammweni paasi pa chitela cha ntini pala? Chingawone gamakulungwa kupunda gelega.” ");
INSERT INTO yao_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Che Yesu ŵajendelechele kusala, “Isyene ngunsalila, chinkuwone kwinani kweugule ni achikatumetume ŵa kwinani ŵa Akunnungu achikwelaga ni kutuluka pa Mwana jwa Mundu.” ");
INSERT INTO yao_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pagamasile moŵa gaŵili wapali ulombela musi wa ku Kana chilambo cha ku Galilaya. Ni achikulugwe Che Yesu ŵaliji kweleko, ");
INSERT INTO yao_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Che Yesu ni ŵakulijiganya ŵao nombe ŵalalichikwe ku ulombela wo. ");
INSERT INTO yao_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pajamasile divai jiŵalingenye kwa ligongo lya ulombela, achikulugwe Che Yesu ŵansalile, “Nganakola divai!” ");
INSERT INTO yao_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Che Yesu ŵajanjile, “Nkaasalila chakupanganya, katema kangu kakanaŵe kwika.” ");
INSERT INTO yao_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pelepo achikulugwe Che Yesu ŵaasalile achikatumetume, “Chachilichose chichansalile, mpanganye.” ");
INSERT INTO yao_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pelepo syapali lulo syekulungwa nsano ni umo sya maganga, lwaluli lose lwakombwele kugumbala lulo sya mwana siŵili pane sitatu sya meesi. Syaŵichikwe pelepo mpela itite pakusyoŵeleka kwa Ŵayahudi kutaga meesi ga kuliswejesya kwaligongo lya kwapopelela Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Che Yesu ŵaasalile achikatumetume ŵala, “Ngumbasye meesi lulo syo.” Ni ŵanyawo ŵagumbesye ndendende. ");
INSERT INTO yao_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nipele ŵaasalile, “Sano ntechanje munjauchisye jwankulu jwa chindimba.” Ni ŵanjauchisye. ");
INSERT INTO yao_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jwankulu jwa chindimba paŵajipasisye divai jijaliji meesi kundanda, nombejo nganakumanyilila kujikopochele divai jo, nambo achikatumetume ŵala ŵaimanyi. Jwankulu jwa chindimba jula ŵambilasile nlombela, ");
INSERT INTO yao_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ni kunsalila, “Mundu jwalijose kundanda akwapa ŵandu divai jambone ni ŵamalaga kung'wa ni kukolelwa akwapa janganong'a nnope. Nambo mmwejo ntupele divai jambone mpaka sambano.” ");
INSERT INTO yao_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chelechi chili chimanyisyo chakusimosya chandanda chiŵapanganyisye Che Yesu mmusi wa ku Kana chilambo cha ku Galilaya ni ŵaulosisye ukulu wao nombe ŵakulijiganya ŵao ŵaakulupilile. ");
INSERT INTO yao_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Payamasile yeleyo, Che Yesu pamo ni achikulugwe ni achapwakwe ni ŵakulijiganya ŵao ŵala ŵatuluchile ku Kapelenaumu. Ŵatemi kweleko moŵa kanandi. ");
INSERT INTO yao_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Katema ka lyuŵa lyekulungwa lya Pasaka ja Ŵayahudi kaŵandichile ni Che Yesu ŵakwesile ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pa Nyuumba ja Akunnungu ŵaasimene ŵandu achisumisyaga ng'ombe ni ngondolo ni nguunda ni ŵakutindanya mbiya ali atemi. ");
INSERT INTO yao_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ŵapotile ngonji ni kuŵa lubokola ni ŵaaŵinjile wose paasa pa Nyuumba ja Akunnungu pamo ni ng'ombe ni ngondolo syao. Ni ŵapikulenye mesa sya ŵakutindanya mbiya ŵala ni kumwasya mbiya syao. ");
INSERT INTO yao_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ni ŵaŵaliji nkusumisya nguunda ŵala ŵaasalile, “Ntyosyanje pelepa indu yi. Nkajipanganya nyuumba ja Atati ŵangu kuŵa nyuumba jakusumichisya malonda!” ");
INSERT INTO yao_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ŵakulijiganya ŵao ŵakumbuchile kuti, malembelo gakusala, “Alakwe Akunnungu, unonyelo wangu kwa nyuumba jenu ukundinisya mpela mooto mu ntima.” ");
INSERT INTO yao_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ilongola ŵa Ŵayahudi ŵausisye Che Yesu, “Ana chimpanganye chimanyisyo chachi chakusimosya chakutulosya kuti nkwete lilamulo lya kupanganya yelei?” ");
INSERT INTO yao_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Che Yesu ŵaasalile, “Ngumulanje Nyuumba ja Akunnungu ji, ni uneji chindaŵe kwa moŵa gatatu pe.” ");
INSERT INTO yao_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pelepo Ŵayahudi ŵala ŵatite, “Aji Nyuumba ja Akunnungu ji twataŵile kwa yaka makumi ncheche konjechesya nsano ni umo. Ana mmwejo chinkombole chinauli kujitaŵa kwa moŵa gatatu?” ");
INSERT INTO yao_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nambo Nyuumba ja Akunnungu jiŵajigambaga Che Yesu jo jaliji chiilu chakwe nsyene. ");
INSERT INTO yao_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nipele Che Yesu paŵasyuchile, ŵakulijiganya ŵao ŵakumbuchile kuti ŵaŵechete gelega, ni ŵagakulupilile Malembelo ga Akunnungu ni maloŵe gaŵaŵechete Che Yesu gala. ");
INSERT INTO yao_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Che Yesu paŵaliji ku Yelusalemu mmoŵa ga chindimba cha Pasaka ŵandu ŵajinji paŵaiweni imanyisyo iŵaipanganyisye ŵaakulupilile. ");
INSERT INTO yao_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nambo Che Yesu nganalilechelelaga kukwao pakuŵa ŵajimanyilile mitima jao ");
INSERT INTO yao_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ni pakuŵa ŵaimanyilile uchenene yaili mmitima jao, nganasaka kusalilwa chachilichose nkati ŵandu ŵane. ");
INSERT INTO yao_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jwapali chilongola jwa Chiyahudi liina lyakwe che Nikodemu juŵaliji mu mpingo wa Mafalisayo. ");
INSERT INTO yao_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chilo chimo che Nikodemu ŵanjaulile Che Yesu ni kunsalila, “Jwakwiganya, tukwimanyilila kuti mmwe ndi jwakwiganya jwalajiswe ni Akunnungu, pakuŵa ngapagwa mundu jwakukombola kupanganya imanyisyo inkwitendekanya mmwe akaŵe Akunnungu ali pamo najo.” ");
INSERT INTO yao_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Che Yesu ŵanjanjile, “Isyene ngunsalila, iŵaga mundu ngakupagwa kaaŵili, ngaakombola kwinjila mu umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Che Nikodemu ŵambusisye, “Ana mundu akukombola chinauli kupagwa kaaŵili ali akusile? Akukombola chinauli kwinjila mu lutumbo lwa achikulugwe ni kupagwa kaaŵili?” ");
INSERT INTO yao_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Che Yesu ŵanjanjile, “Isyene ngunsalila, iŵaga mundu ngaapagwa kwa meesi ni kwa Mbumu jwa Akunnungu, ngaakombola kwinjila mu umwenye wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kwa chiilu mundu akupagwa ni atati ni achikulugwe, nambo akupagwa kwa mbumu, akupagwa kwa Mbumu jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nkasimonga pakuŵa ndite kuti nkusachilwa mpagwe kaaŵili. ");
INSERT INTO yao_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mbungo jikupuga kujikusaka, nkujipikana pajikupuga, nambo ngankukumanyilila kujikukopochela atamuno kujikwaula. Ikuŵa yelei kwa jwalijose jwapagwilwe kwa Mbumu jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Che Nikodemu ŵausisye Che Yesu, “Ayi indu yi ana chiikomboleche chinauli?” ");
INSERT INTO yao_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Che Yesu ŵanjanjile, “Mmwejo ndi jwakwiganya jwa Ŵaisilaeli ana iŵele uli ngankwimanyilila indu yi? ");
INSERT INTO yao_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Isyene ngunsalila, uweji tukuŵecheta itukwimanyilila ni kuŵalanga umboni wa itwiweni, nambo ŵanyamwe ngankusaka kuujitichisya utenga wetu. ");
INSERT INTO yao_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iŵaga nantanjile indu ya pachilambo ni ŵanyamwe nganinjitichisya, ana nantanjilaga indu ya kwinani chinjitichisye chinauli? ");
INSERT INTO yao_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ngapagwa jwalijose jwajawile kwinani ikaŵe Mwana jwa Mundu juŵatulwiche kutyochela kwinani.” ");
INSERT INTO yao_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mpela ila che Musa iŵatite pakulikoleka penani pa luchanamila lijoka lilyakolochekwe ni shaba mwipululu mula, iyoyo peyo Mwana jwa Mundu ikusachilwa anyakulikwe mwinani, ");
INSERT INTO yao_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kuti jwalijose juchankulupilile akole umi wa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pakuŵa Akunnungu ŵaanonyele nnope ŵandu ŵa pachilambo, nipele ŵantyosisye Mwanagwe jwajikape, kuti jwalijose jwakunkulupilila akajonasika, nambo akole umi wa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pakuŵa Akunnungu nganantuma Mwanagwe pachilambo kuti aiche kukwalamula ŵandu, nambo aiche kukwakulupusya. ");
INSERT INTO yao_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jwakunkulupilila Mwana jwa Akunnungu, jwelejo ngakulamulwa, nambo jwangankulupilila jwelejo amasile kulamulikwa, pakuŵa nganankulupilila Mwana jwajikape jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lilamulo lili lyeleli, lilanguka liiche pachilambo nambo ŵandu achinonyele nnope chipi kupunda lilanguka, pakuŵa akupanganya ya chigongomalo. ");
INSERT INTO yao_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mundu jwalijose jwakupanganya ya chigongomalo akulichima lilanguka, ngakwika kulilanguka pakuŵa ngakusaka iwoneche indu yao ya chigongomalo. ");
INSERT INTO yao_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nambo jwakuukamulisya usyene akwika kulilanguka kuti yakuipanganya iwoneche kuti ipanganyiche kwa kwajitichisya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Payamasile yeleyo Che Yesu pamo ni ŵakulijiganya ŵao ŵajawile ku chilambo cha Ŵayahudi. Ŵatemi pamo nawo kweleko, achibatisyaga ŵandu. ");
INSERT INTO yao_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Che Yohana nombe ŵaliji ku Ainoni, pachiŵandi ku Salimu achibatisyaga ŵandu, pakuŵa kweleko kwaliji ni meesi gamajinji. Ŵandu ŵanjaulilaga, nombewo ŵabatisye. ");
INSERT INTO yao_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yeleyo yakopochele katema che Yohana nganataŵikwe mu nyuumba jakutaŵilwa. ");
INSERT INTO yao_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Gakopochele makani pasikati ja Myahudi jumo ni ŵakulijiganya ŵampepe ŵa che Yohana nkati masyoŵelelo ga kuliswejesya kwaligongo lya kwapopelela Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nipele, ŵakulijiganya wo ŵanjaulile che Yohana ni kunsalila, “Jwakwiganya, ajula mundu juŵaliji pamo nomwe peesi Yolodani, jumwaŵalasile ngani syakwe, nombejo sambano akubatisya, ni ŵandu wose akwajaulila.” ");
INSERT INTO yao_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Che Yohana ŵajanjile, “Mundu ngakukombola kukola chachilichose ikaŵe apegwilwe ni Akunnungu ŵa kwinani. ");
INSERT INTO yao_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ni ŵanyamwe mwachinsyene nkumanyilila kuti nasasile, ‘Uneji nguniŵa Kilisito Jwakuwombola, nambo nalajiswe kuti naalongolele!’ ");
INSERT INTO yao_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jwakulombekwa ali jwakwe nnombela, nambo nkamusi jwa nnombela akwima kuntumichila nnombela, nkamusi jo akusangalala nnope pakupilikana liloŵe lya nnombela ali nkukunguluka. Iyoyo peyo ni uneji ngusangalala nnope. ");
INSERT INTO yao_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Che Yesu ikusachilwa aŵe jwankulu, ni uneji mme jwannondi. ");
INSERT INTO yao_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Jwakwika kutyochela kwinani ali jwankulu kwapunda wose. Jwakutyochela pachilambo ali jwa pachilambo nombe akuŵecheta mpela mundu jwa pachilambo. Nambo jwakwika kutyochela kwinani akuilongosya indu yose. ");
INSERT INTO yao_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jwelejo akutyosya umboni wa indu yaiweni ni kuilipikana, nambo ngapagwa mundu jwakukunda indu yakuisala. ");
INSERT INTO yao_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nambo mundu jwalijose jwakukunda umboni wakuusala jwelejo, akwitichisya kuti Akunnungu ali usyene. ");
INSERT INTO yao_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ajula jwatumikwe ni Akunnungu akusala maloŵe ga Akunnungu, pakuŵa Akunnungu akwapa Mbumu jwa Akunnungu kwa winji. ");
INSERT INTO yao_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Akunnungu akunnonyela Mwana ni indu yose aŵisile mu ulamusi wao. ");
INSERT INTO yao_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jwakunkulupilila Mwana akwete umi wa moŵa gose pangali mbesi, jwangakunkulupilila Mwana ngakola umi, ni uchimwa wa Akunnungu uli pa jwelejo.” ");
INSERT INTO yao_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayo ŵapilikene kuti Che Yesu akupata ŵakulijiganya ŵajinji ni kwabatisya kwapunda che Yohana. ");
INSERT INTO yao_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nambo Che Yesu nsyene nganiŵabatisya ŵandu, ŵakulijiganya ŵao ni ŵaŵabatisyaga ŵandu. ");
INSERT INTO yao_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nipele, Che Yesu paŵapilikene yeleyo ŵatyosile ku Yudea ni kuuja ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mu ulendo wao ŵasachilwe kupita ku Samalia. ");
INSERT INTO yao_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nipele, ŵaiche ku Sikali musi umo wa ku Samalia, pachiŵandi ngunda u che Yusufu wapegwilwe ni che Yakobo atatigwe. ");
INSERT INTO yao_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pelepo paliji ni chisima chi che Yakobo, nombe Che Yesu pakuŵa ŵapesile ni ulendo, ŵatemi mungulugulu chisima. Yaliji muusi lyuŵa pantwe. ");
INSERT INTO yao_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nipele jwankongwe jumo Msamalia ŵaiche kukuteka meesi. Ni Che Yesu ŵansalile jwankongwe jo, “Nguŵenda meesi gakung'wa.” ");
INSERT INTO yao_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Katema ko ŵakulijiganya ŵakwe ŵajile mu mmusi kukusuma yakulya. ");
INSERT INTO yao_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nambo jwankongwe jo ŵatite, “Mmwejo Myahudi, ana nkukombola chinauli kuumenda meesi gakung'wa uneji jwankongwe Msamalia?” Ŵatite yele pakuŵa Ŵayahudi ngakukamulangana ni Ŵasamalia. ");
INSERT INTO yao_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Che Yesu ŵajanjile, “Nkachimanyi chichi chakusaka Akunnungu kumpa ni ŵaani ŵakummenda meesi gakung'wa, nkammendile jwelejo, nombejo akampele meesi gagakwikanawo umi.” ");
INSERT INTO yao_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jwankongwe jo ŵatite, “Ambuje, mmwe nganinkola ngao ni chisima chi chilewipe nnope. Ana mpatile kwapi meesi gagakwikanawo umi go? ");
INSERT INTO yao_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ambuje ŵetu che Yakobo ni ŵatupele uweji chisima chi, nsyene ni ŵanagwe ni ilango yakwe ŵang'wele meesi ga chisima chi. Ana mmwejo nkulitenda jwankulu nnope kwapunda che Yakobo?” ");
INSERT INTO yao_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Che Yesu ŵanjanjile, “Jwalijose juchang'we meesi ga chisima chi chijakole njota sooni. ");
INSERT INTO yao_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nambo juchang'we meesi gachinaape une ngajakola njota ng'oo. Meesi gachinaape une chigaŵe nti meesi gagakuulika nkati mwakwe, gagakwikanawo umi wa moŵa gose pangali mbesi.” ");
INSERT INTO yao_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jwankongwe jo ŵansalile, “Ambuje, nguŵenda meesi go kuti jinangole njota sooni ni ninaiche sooni pelepa kukuteka meesi.” ");
INSERT INTO yao_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Che Yesu ŵansalile jwankongwe jo, “Njaule nkaaŵilanje ŵankwenu, nkaiche pamo nawo pelepa.” ");
INSERT INTO yao_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jwankongwe jo ŵajanjile, “Uneji nganingola ŵalume.” Che Yesu ŵansalile, “Njanjile yambone kuti nganinkola ŵalume. ");
INSERT INTO yao_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pakuŵa mwalombilwe kasano, ni jwannume junkutama nawo sambano jo nganaŵa ŵankwenu. Pelepo chinsasile cho chili chisyene.” ");
INSERT INTO yao_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jwankongwe jo ŵaasalile, “Ambuje, nguwona kuti mmwejo ndi jwakulondola jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Achambuje ŵetu ŵa Chisamalia ŵaapopelele Akunnungu mwinani mwa chitumbi chi, nambo ŵanyamwe Ŵayahudi nkuti, tukusachilwa kwapopelela Akunnungu ku Yelusalemu.” ");
INSERT INTO yao_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Che Yesu ŵanjanjile, “Amao, nkulupilile chinguchisala, chikaiche katema ngamwapopelela Atati mwinani mwa chitumbi chi atamuno ku Yelusalemu kula. ");
INSERT INTO yao_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ŵanyamwe Ŵasamalia nkwapopelela ŵangankwamanyilila, nambo uweji Ŵayahudi tukwamanyilila ŵatukwapopelela, pakuŵa ukulupusyo wa Akunnungu chiutyochele kwa litala lya Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nambo chikaiche katema, sooni kaiche, ŵakupopelela kwa usyene chiŵaapopelele Atati achilongoswaga ni Mbumu jwa Akunnungu ni usyene. Pakuŵa Atati akwasaka ŵandu ŵakwapopelela chanti yeleyo. ");
INSERT INTO yao_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Akunnungu ali Mbumu, ni ŵakwapopelela ŵelewo ŵapopeleleje achilongoswaga ni Mbumu jwa Akunnungu ni kuumanyilila usyene.” ");
INSERT INTO yao_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jwankongwe jo ŵansalile, “Ngumanyilila kuti chaiche Masiya jwakuŵilanjikwa Kilisito Jwakuwombola. Pachaiche chatumanyisye inayose.” ");
INSERT INTO yao_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Che Yesu ŵansalile, “Uneji junguŵecheta nomwe ndili jwelejo.” ");
INSERT INTO yao_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Papopo ŵakulijiganya ŵakwe ŵausile, ŵasimosile ligongo ŵaasimene Che Yesu alinkukunguluka ni jwankongwe. Nambo ngapagwa jwalijose juŵambusisye Che Yesu, “Ana nkusaka chichi? Pane kwaligongo chi nkukunguluka ni jwankongwe?” ");
INSERT INTO yao_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jwankongwe jo ŵalesile lulo lwakwe palapala, ŵajawile mmusi ni kwasalila ŵandu achitiji, ");
INSERT INTO yao_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Njisangane nkannole mundu jwasalile yanayose imbanganyisye! Ikukomboleka kuti jweleju ali Kilisito Jwakuwombola?” ");
INSERT INTO yao_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nipele ŵandu ŵakopweche mmusi ula ni kwajaulila Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Katema kakoko ŵakulijiganya ŵakwe ŵaliji nkwachondelela Che Yesu achitiji, “Chondechonde Jwakwiganya, ndye.” ");
INSERT INTO yao_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nambo Che Yesu ŵaasalile, “Uneji ngwete chakulya chingankuchimanyilila ŵanyamwe.” ");
INSERT INTO yao_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ŵakulijiganya ŵakwe ŵatandite kuusyana achinsyene pe, “Ana kwana mundu jwanjigalile chakulya?” ");
INSERT INTO yao_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Che Yesu ŵaasalile, “Chakulya changu chili kutendekanya chakusaka aŵala ŵandumile ni kugamalisya masengo gao. ");
INSERT INTO yao_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ŵanyamwe ngankuti, ‘Jisigalile miesi ncheche, pakwika katema ka kugungula?’ Nambo uneji ngunsalila nnole migunda ji jili chile kwa kugungula. ");
INSERT INTO yao_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jwakugungula akupochela mbote ni akukumbikanya pamo magungulo kuti gakole umi wa moŵa gose pangali mbesi, nipele jwakupanda asengwe yalumo ni jwakugungula. ");
INSERT INTO yao_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chiŵecheto chi chili chisyene, ‘Jumo akupanda ni jwine akugungula.’ ");
INSERT INTO yao_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Uneji nantumile nkagungule magowolo ganganimpande ŵanyamwe, ŵane ŵapanganyisye masengo gakulimba, nambo gelego ginkupata ŵanyamwe gali kwa ligongo lya masengo gao.” ");
INSERT INTO yao_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ŵasamalia ŵajinji ŵa musi ula ŵaakulupilile Che Yesu kwa ligongo lya umboni wa maloŵe gaŵaŵechete jwankongwe jo gagakuti, “Asalile inayose imbanganyisye.” ");
INSERT INTO yao_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ŵasamalia ŵajaulile Che Yesu ni kwachondelela atame pamo nawo, nombejo ŵatemi pepala moŵa gaŵili. ");
INSERT INTO yao_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nipele ŵandu ŵajinji nnope ŵaakulupilile Che Yesu ligongo lya maloŵe gao. ");
INSERT INTO yao_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ŵansalile jwankongwe jo, “Sano tukukulupilila ngaŵa kwaligongo lya kuŵecheta kwenu pe, nambo pakuŵa tupilikene twachinsyene, ni tukumanyilila kuti isyene ajuju ni Nkulupusyo jwa ŵandu ŵapachilambo.” ");
INSERT INTO yao_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagapite moŵa gaŵili Che Yesu ŵausile sooni ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Pakuŵa Che Yesu nsyene ŵasasile pangasisa kuti, “Jwakulondola jwa Akunnungu ngakuchimbichikwa mchilambo chakwe nsyene.” ");
INSERT INTO yao_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Paŵaiche ku Galilaya, ŵandu ŵajinji ŵakweleko ŵapochele, pakuŵa ŵanyawo nombe ŵaliji ku Yelusalemu kuchindimba cha Pasaka, ŵaiweni yose yaitesileje Che Yesu pachindimba. ");
INSERT INTO yao_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nipele Che Yesu ŵaujile sooni mmusi wa ku Kana, chilambo cha ku Galilaya, peuto paŵagatesile meesi gaŵe divai pala. Pepala paliji ni jwankulu jumo juŵaliji ni mwanache jwakulwala ku Kapelenaumu ko. ");
INSERT INTO yao_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nipele jwankulu jo paŵapilikene kuti Che Yesu atyosile ku Yudea ni kwika ku Galilaya, ŵajaulile ni kwachondelela ajaule ku Kapelenaumu akannamye mwanagwe juŵalwalaga kuŵandichila kuwa. ");
INSERT INTO yao_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Che Yesu ŵansalile, “Ŵanyamwe ngankwakulupilila Akunnungu pangaiwona imanyisyo ni yakusimonjeka!” ");
INSERT INTO yao_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jwankulu jo ŵanjanjile, “Ambuje, chondechonde tujaule mwanangu akanaŵe kuwa.” ");
INSERT INTO yao_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Che Yesu ŵansalile, “Njauleje, mwanagwenu chalame.” Mundu jo ŵalikulupilile liloŵe liŵasalilwe ni Che Yesu ni ŵajawile. ");
INSERT INTO yao_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Paŵaliji nkutuluka, ŵasimene ni achikapolo ŵao ni ŵansalile kuti mwanache jwao alamile. ");
INSERT INTO yao_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nombejo ŵausisye katema kaŵatandite mwanagwe kupata eja, ni ŵanyawo ŵajanjile, “Ulwele wannesile liiso saa saba ja musi.” ");
INSERT INTO yao_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nipele atati jo ŵajimanyilile kuti jaliji saa jilajila jiŵasalilwe ni Che Yesu kuti, “Mwanagwenu chalame.” Pelepo nsyene pamo ni achalongo ŵakwe wose ŵankulupilile Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chelechi chaliji chimanyisyo cha kusimosya chaaŵili chiŵachipanganyisye Che Yesu paŵatyosile ku Yudea kuuja ku Galilaya. ");
INSERT INTO yao_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Payamasile yeleyo, Che Yesu ŵakwesile kwaula ku Yelusalemu ku chindimba cha Ŵayahudi, ");
INSERT INTO yao_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ni ku Yelusalemu ko, pachiŵandi nnango wekulungwa waukuŵilanjikwa nnango wa ngondolo, kwaliji ni litanda lyalikuŵilanjikwa Mchiebulania Betisasa lyalili ni mapenu nsano. ");
INSERT INTO yao_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ŵakulwala ŵajinji ŵagonaga mmapenu mo, kwaliji ni ŵangalola ni ŵakulemala ni ŵakutatala. ");
INSERT INTO yao_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ŵalolelaga meesi gatinganyikwe, pakuŵa kapali katema katumetume jwa kwinani jwa Ambuje ŵatuluchilaga mmeesi ni kugatinganya. Jwakulwala jwalijose juŵaliji jwaandanda kwinjila mmeesi gagatinganyikwe, ŵalamile ulwele uliwose walinawo. ");
INSERT INTO yao_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pelepo paliji ni mundu jumo juŵatatele yaka makumi gatatu kupambula nsano ni itatu. ");
INSERT INTO yao_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Che Yesu paŵambweni mundu jula ali agonile pepala ni kwimanyilila kuti ali jwakulwala moŵa gamajinji, ŵambusisye, “Ana nkusaka kulama?” ");
INSERT INTO yao_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jwakulwala jo ŵajanjile, “Ambuje, uneji nganingola jwakunyinjisya mu litanda katema meesi pagakutinganyikwa. Pingulinga kwinjila, mundu jwine akuunongolela kwinjila.” ");
INSERT INTO yao_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nipele Che Yesu ŵansalile, “Njimuche, njigale ugono wenu njaule.” ");
INSERT INTO yao_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Papopo pepo mundu jo ŵalamile, ŵajigele ugono wakwe ni kwaula. Yeleyo yatendekwe pa Lyuŵa lya Kupumulila. ");
INSERT INTO yao_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nipele achakulu ŵa Ŵayahudi ŵansalile mundu jwalamile jo, “Lelo jino lili Lyuŵa lya Kupumulila ni malajisyo ga Akunnungu gaŵapele che Musa gakukanya kunyakula ugono wenu.” ");
INSERT INTO yao_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nambo mundu jo ŵaajanjile ŵanyawo, “Mundu jwanamisye jula andanjile, ‘Njigale ugono wenu, njaule.’ ” ");
INSERT INTO yao_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ŵanyawo ŵambusisye, “Ana ŵaani ansalile njigale ugono wenu njaule?” ");
INSERT INTO yao_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nambo mundu juŵalamiswe jula nganammanyilila Che Yesu kuti ali ŵaani, pakuŵa pepala paliji ni mpingo wekulungwa wa ŵandu ni Che Yesu ŵatyosile pepala. ");
INSERT INTO yao_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kanyuma Che Yesu ŵansimene mundu juŵannamisye jula pa Nyuumba ja Akunnungu, ni ŵansalile, “Mpilikane sambano nnamile, kasintenda sooni sambi, chinaiche kunsimana chindu chakusakala kupunda achichi.” ");
INSERT INTO yao_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mundu jula ŵajawile kukwasalila achakulu ŵa Ŵayahudi kuti Che Yesu ni juŵalamisye. ");
INSERT INTO yao_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pakuŵa Che Yesu ŵatendekenye yeleyo pa Lyuŵa lya Kupumulila, Ŵayahudi ŵatandite kunchima. ");
INSERT INTO yao_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nambo Che Yesu ŵaasalile, “Atati ŵangu akupanganya masengo moŵa gose ni uneji ngugapanganya iyoyo peyo.” ");
INSERT INTO yao_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kwa ligongo lyo, achakulu ŵa Ŵayahudi ŵapundile kusosasosa litala lyakwaulaga Che Yesu ngaŵa ligongo lyakutema malajisyo ga Lyuŵa lya Kupumulila pe, nambo pakuŵa alitesile kuti Akunnungu ali Atatigwe ni kulitenda chisau ni Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Che Yesu ŵaasalile, “Ngunsalila isyene, Mwana ngakukombola kupanganya chachilichose jikape. Mwana akukombola kupanganya achilape chakuchiwona alinkupanganya Atati. Pakuŵa achila chaakuchipanganya Atati Mwana nombejo akupanganya ilaila peila. ");
INSERT INTO yao_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Atati akunnonyela Mwana ni kunlosya indu yose yakupanganya nsyene. Sooni chiŵalosye indu yekulungwa kupunda ayiyi, ni ŵanyamwe chinsimonje. ");
INSERT INTO yao_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mpela ila Atati iyakuti pakwasyusya ŵawile ni kwapa umi, iyoyo peyo ni Mwana akwapa umi aŵala ŵakwasaka. ");
INSERT INTO yao_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Atati ngakunlamula mundu jwalijose, nambo ampele Mwanagwe ukombole wose wakwalamula ŵandu, ");
INSERT INTO yao_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kuti ŵandu wose anchimbichisye Mwana mpela yakuti pakwachimbichisya Atati. Mundu jwalijose jwangakunchimbichisya Mwana ngakunchimbichisya Atati juŵantumile.” ");
INSERT INTO yao_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ngunsalila isyene, jwakulipikanila liloŵe lyangu ni kwakulupilila ŵandumile une ŵala, jwelejo akwete umi wa moŵa gose pangali mbesi. Nombejo ngaalamulikwa ng'oo, pakuŵa amasile kukopoka muchiwa ni kwinjila mu umi. ");
INSERT INTO yao_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ngunsalila isyene, chikaiche katema ni sambano kaiche chanti ŵandu ŵawile chalipilikane liloŵe lya Mwana jwa Akunnungu nombe ŵandu ŵachalipilikane wo chakole umi. ");
INSERT INTO yao_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mpela ila Atati yatite kuŵa ndande ja umi, iyoyo peyo ampele Mwana kuŵa ndande ja umi. ");
INSERT INTO yao_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sooni ampele Mwana ukombole wa kulamula ligongo jwelejo ali Mwana jwa Mundu. ");
INSERT INTO yao_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nkachisimonga achichi pakuŵa chikaiche katema chati ŵandu wose ŵaali kumalembe chalipilikane liloŵe lyao, ");
INSERT INTO yao_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nombe chasyuche, aŵala ŵaŵatendekenye yambone chasyuche ni kupata umi ni aŵala ŵaŵatendekenye yangalumbana chasyuche ni kulamulikwa.” ");
INSERT INTO yao_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Uneji jikape ngangukombola kuchitendekanya chindu kwa ukombole wangu nansyene. Ngulamula mpela inguti pakupilikana kutyochela kwa Atati, ni kulamula kwangu kuli kwa usyene pakuŵa ngangupanganya ingusaka nansyene, nambo yambone paujo pao ŵandumile une ŵala. ");
INSERT INTO yao_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Naliŵalangaga nansyene umboni wangu uli wa unami. ");
INSERT INTO yao_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nambo apali jwine jwakusala umboni pa une, noneji ngumanyilila kuti yose yakusala nkati uneji ili isyene. ");
INSERT INTO yao_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ŵanyamwe mwalajisye ŵantenga ku che Yohana Ŵakubatisya, ni umboni wasasile nkati une uli usyene. ");
INSERT INTO yao_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngaŵa kuti uneji nguukulupilila umboni wa ŵandu, nambo ngusala yelei kuti ŵanyamwe nkulupuswe. ");
INSERT INTO yao_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Che Yohana ŵaliji mpela lumuli lulwakolelaga ni kulanguchisya, ni ŵanyamwe mwaliji chile kusengwa ni lilanguka lyakwe kwa katema pe. ");
INSERT INTO yao_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nambo uneji ngwete umboni kukwangu wauli wekulungwa kupunda u che Yohana. Pakuŵa masengo gingugapanganya gaambele Atati malichisye ni gagakulosya pangasisika kuti Atati ni ŵandumile. ");
INSERT INTO yao_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Atati uŵandumile, iyoyo akusala umboni nkati une. Ŵanyamwe nganimme kulipilikana liloŵe lyao atamuno kukulola ku meeso kwao, ");
INSERT INTO yao_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ni liloŵe lyao ngalikutama nkati mwenu, pakuŵa nganimunkulupilila ajula juŵamtumile. ");
INSERT INTO yao_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nkugasosasosa Malembelo ga Akunnungu nchiganisyaga kuti mu gelego chimpate umi wa moŵa gose pangali mbesi. Ni Malembelo ga Akunnungu go gakuŵalanga umboni nkati une! ");
INSERT INTO yao_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ni ŵanyamwe ngankusaka kwika kukwangu kuti nkole umi wa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ngangusosa kuchimbichikwa ni ŵandu. ");
INSERT INTO yao_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nambo ngummanyilila ŵanyamwe kuti nganinkola unonyelo wa Akunnungu mmitima jenu. ");
INSERT INTO yao_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Uneji iiche kwa ulamusi wa Atati ŵangu, ni ŵanyamwe nganimungulupilila. Aikaga mundu jwine kwa ulamusi wakwe nsyene, chimunkulupilile. ");
INSERT INTO yao_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ana chinkombole chinauli kungulupilila iŵaga ŵanyamwe nkusaka kulapikwa kutyochela kwa achinjenu nambo nkukana kulapikwa kwakukutyochela kwa Akunnungu ŵaali jikape? ");
INSERT INTO yao_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nkaganisyaga kuti uneji chinambechetele kwa Atati. Che Musa junkunlolela ŵanyamwe ni juchambechetele kwa Atati. ");
INSERT INTO yao_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nkankulupilile che Musa nkaangulupilile ni une ŵakwe pakuŵa che Musa ŵalembile ngani syangu. ");
INSERT INTO yao_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nambo iŵaga ngankugakulupilila gaŵagalembile che Musa gala, sano chinkombole chinauli kugakulupilila ginguŵecheta?” ");
INSERT INTO yao_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Payamasile yeleyo Che Yesu ŵajombweche litanda lya Galilaya pane likuŵilanjikwa litanda lya Tibelia. ");
INSERT INTO yao_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mpingo wekulungwa wa ŵandu wakuiye ligongo ŵandu wo ŵaiweni imanyisyo iŵapanganyisye kwa kwalamya ŵandu. ");
INSERT INTO yao_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nipele Che Yesu pamo ni ŵakulijiganya ŵao ŵakwesile mwitumbi ni kutama. ");
INSERT INTO yao_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Katema ka chindimba cha Pasaka ja Ŵayahudi kaŵandichile. ");
INSERT INTO yao_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Che Yesu paŵalolesyelolesye ŵauweni mpingo wekulungwa wa ŵandu uchaichililaga, nipele ŵausisye che Filipo, “Ana chitusume kwapi chakulya kuti twape ŵandu ŵa alye?” ");
INSERT INTO yao_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ŵaŵechete yeleyo kuti ŵalinje che Filipo, pakuŵa asyene ŵaimanyi chichaapanganye. ");
INSERT INTO yao_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Che Filipo ŵajanjile, “Ipande machila gaŵili ga madini ga feza ngaikukwana kusumila mikate kwa kila mundu!” ");
INSERT INTO yao_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jumo jwa ŵakulijiganya ŵa Che Yesu jwakuŵilanjikwa che Andulea, mpwao che Simoni Petulo, ŵaasalile Che Yesu, ");
INSERT INTO yao_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kwana jwanchanda pelepa jwali ni ipande nsano ya mikate ja shayili ni somba siŵili. Nambo yakulya yi kanandi ngayajikutisya ŵandu ŵajinji ŵanti nyi?” ");
INSERT INTO yao_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Che Yesu ŵaasalile ŵakulijiganya ŵao, “Mwasalile ŵandu atame paasi.” Pelepo paliji ni manyasi, nipele ŵandu wose ŵatemi paasi, winji wa achalume pe waliji mpela elufu tano. ");
INSERT INTO yao_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nipele Che Yesu ŵaijigele ipande ya mikate ila, ni ŵatogolele Akunnungu ni kwagaŵila ŵandu ŵaŵatemi paasi ŵala. Ŵatesile iyoyo peyo ni somba sila ni kila mundu ŵapatile mpela iŵatite pakusaka. ");
INSERT INTO yao_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ŵandu wo paŵajikwite Che Yesu ŵaasalile ŵakulijiganya ŵao, “Nkumbikanye mbakatika yaisigele yo kuti inapotele.” ");
INSERT INTO yao_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nipele, ŵakulijiganya ŵala ŵakumbikenye isigasi ya mikate nsano ja shayili iyasigesye ŵandu ŵaŵalile ŵala, ŵagumbesye itundu likumi ni iŵili. ");
INSERT INTO yao_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ŵandu paŵachiweni chimanyisyo chiŵachipanganyisye Che Yesu cho, ŵatite, “Isyene ajuju ni jwakulondola jwa Akunnungu jwaŵechetekwe kuti chaiche pachilambo.” ");
INSERT INTO yao_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Che Yesu ŵaimanyi kuti ŵandu ŵasachile kwakanganichisya aŵe mwenye jwao, ni ŵatyosile sooni jikape ni kwaula ku chitumbi. ");
INSERT INTO yao_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pakwaswele ŵakulijiganya ŵa Che Yesu ŵatulwiche kwaula ku litanda. ");
INSERT INTO yao_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ŵajinjile mu ngalaŵa ŵatandite komboka kwaula ku Kapelenaumu. Chipi chajinjile ni Che Yesu ŵaliji akanaŵe kwaichilila. ");
INSERT INTO yao_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Litanda lyatandite matumbela kwa ligongo lya chimbunga chekulungwa chichaliji chininkupuga. ");
INSERT INTO yao_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ŵakulijiganya ŵao paŵajawile kwakutalichila uleu wa maili sitatu pane ncheche, ŵammweni Che Yesu alinkwenda pachanya meesi, ni kujiŵandichila ngalaŵa, ŵajogwepe nnope. ");
INSERT INTO yao_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Che Yesu ŵaasalile, “Nkajogopa, ndili uneji!” ");
INSERT INTO yao_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nipele ŵakulijiganya ŵala kwakusangalala ŵammendile Che Yesu ajinjile mu ngalaŵa mula. Palapala ngalaŵa jaiche mungulugulu litanda kuŵajaulaga. ");
INSERT INTO yao_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Malaŵi jakwe mpingo wa ŵandu uŵasigele peesi litanda ula ŵaimanyi kuti apala paliji ni ngalaŵa jimo pe. Che Yesu nganajinjila mu ngalaŵa pamo ni ŵakulijiganya ŵao, nambo ŵakulijiganya ŵao wo ŵajawile achinsyene pe. ");
INSERT INTO yao_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Syaiche ngalaŵa sine kutyochela ku Tibelia pepala mpingo wekulungwa wa ŵandu paŵalile mikate, Ambuje ali amasile kwatogolela Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nipele, ŵandu wo paŵaimanyi kuti Che Yesu ni ŵakulijiganya ŵao nganapagwa pepala, ŵasikwesile ngalaŵa sila ni kwaula ku Kapelenaumu achinsosaga. ");
INSERT INTO yao_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ŵandu ŵala paŵasimene Che Yesu ali ajombweche ŵambusisye, “Ana, Jwakwiganya akuno nnyiche katema chi?” ");
INSERT INTO yao_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Che Yesu ŵaajanjile, “Ngunsalila isyene, nkusosasosa une ngaŵa kwaligongo mwaiweni imanyisyo imbanganyisye, nambo kwaligongo mwalile mikate jila ni kwikuta. ");
INSERT INTO yao_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kasinchenjeuchila chakulya chachikuwola, nambo nchenjeuchile chakulya chingachikuwola cha umi wa moŵa gose pangali mbesi. Mwana jwa Mundu champe chakulya chi pakuŵa Akunnungu Atati, alosisye kuti ansagwile ni kunkunda.” ");
INSERT INTO yao_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nombewo ŵambusisye Che Yesu, “Tutende chichi kuti tukombole kugapanganya masengo gakugasakaga Akunnungu tugapanganye?” ");
INSERT INTO yao_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Che Yesu ŵaajanjile, “Chelechi ni chakuchisaka Akunnungu nchipanganye, munkulupilile jwantumile jula.” ");
INSERT INTO yao_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pelepo ŵaasalile, “Ana chintende chimanyisyo chi tulole kuti tunkulupilile mmwe? Chintende chichi? ");
INSERT INTO yao_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Achambuje ŵetu ŵalile chakulya chachikuŵilanjikwa mana mwipululu mula mpela igakuti pakusala Malembelo ga Akunnungu, ‘Ŵalisisye mikate jajityochele kwinani.’ ” ");
INSERT INTO yao_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Che Yesu ŵaasalile, “Ngunsalila isyene, che Musa nganampanga nkate kutyochela kwinani, nambo Atati ŵangu ni ŵampele ŵanyamwe nkate usyene kutyochela kwinani. ");
INSERT INTO yao_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pakuŵa nkate wakutupa Akunnungu uli ajula jwatulwiche kutyochela kwinani ni kwapa umi ŵandu ŵaali mchilambo.” ");
INSERT INTO yao_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nipele ŵaasalile, “Ambuje, ntupeje nkate wu kila lyuŵa.” ");
INSERT INTO yao_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nambo Che Yesu ŵaasalile, “Uneji ndili nkate waukwikanawo umi. Jwakwika kukwangu ngasijinkola sala, jwakungulupilila une ngasijinkola njota ng'oo. ");
INSERT INTO yao_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nambo nansalile kuti namuno muuweni, nganimme kungulupilila. ");
INSERT INTO yao_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wose ŵakuumba Atati chaiche kukwangu, noneji jwalijose jwakwika kukwangu ngasinankana ng'oo. ");
INSERT INTO yao_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nganinduluka kutyochela kwinani kwaligongo lya kuitendekanya ingusaka uneji, nambo ndulwiche kuti ndendekanye yakusaka ŵandumile une ŵala. ");
INSERT INTO yao_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yakusaka ŵandumile une ŵala ni ayiyi, ninanjase jwalijose juŵambele, nambo naasyusye pa lyuŵa lya mbesi. ");
INSERT INTO yao_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Pakuŵa chakusaka Atati ŵangu ni achichi, jwalijose jwakunlola Mwana ni kunkulupilila akole umi wa moŵa gose pangali mbesi, ni uneji chinansyusye pa lyuŵa lya mbesi.” ");
INSERT INTO yao_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nipele Ŵayahudi ŵatandite kwasongonechela Che Yesu pakuŵa ŵatite, “Uneji ndili nkate wautulwiche kutyochela kwinani.” ");
INSERT INTO yao_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ni ŵatite, “Uli, ajuju ngaŵa Che Yesu mwana ju che Yusufu jula? Atatigwe ni achikulugwe twamanyi! Ana akukombola chinauli kuti atulwiche kutyochela kwinani?” ");
INSERT INTO yao_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Che Yesu ŵaasalile, “Nneche kusongonechelana jwine ni jwine. ");
INSERT INTO yao_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ngapagwa mundu juchakombole kwika kukwangu pangali Atati juŵandumile une jo kwautila kukwangu, ni une chinansyusye mundu jo pa lyuŵa lyambesi. ");
INSERT INTO yao_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ŵakulondola ŵa Akunnungu ŵalembile kuti, ‘Ŵandu wose chajiganyikwe ni Akunnungu.’ Mundu jwalijose jwakumpilikana Atati ni kulijiganya kutyochela kwa ŵelewo, chaiche kukwangu. ");
INSERT INTO yao_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ngapagwa mundu jwambweni Atati, ikaŵe ajula pe jwatyosile kwa Akunnungu, jwelejo ni juŵambweni Atati. ");
INSERT INTO yao_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ngunsalila isyene, jwakukulupilila akwete umi wa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Uneji ndili nkate waukwikanawo umi. ");
INSERT INTO yao_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Achambuje ŵenu ŵalile mana mwipululu mula, nambo ŵawile. ");
INSERT INTO yao_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nambo weleu ni nkate waukutuluka kutyochela kwinani kuti jwalijose jwakulya anajasiche. ");
INSERT INTO yao_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Uneji ndili nkate waukwikanawo umi wautulwiche kutyochela kwinani. Mundu jwalijose alyaga nkate wo chalame moŵa gose pangali mbesi. Ni nkate uchinaape wo uli chiilu changu chinguchityosya kuti ŵandu wose ŵapachilambo akole umi.” ");
INSERT INTO yao_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nipele Ŵayahudi ŵatandite kwangangana achinsyene pe, “Ana aju akukombola chinauli kutupa uwe chiilu chakwe kuti tulye?” ");
INSERT INTO yao_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Che Yesu ŵaasalile, “Ngunsalila isyene, iŵaga ngankulya chiilu cha Mwana jwa Mundu ni kung'wa miasi jakwe, ngankola umi nkati mwenu. ");
INSERT INTO yao_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mundu jwalijose jwakulya chiilu changu ni kungwa miasi jangu akwete umi wa moŵa gose pangali mbesi, ni uneji chinansyusye pa lyuŵa lyambesi. ");
INSERT INTO yao_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pakuŵa chiilu changu chili chakulya chisyenesyene, ni miasi jangu jili chakung'wa chisyenesyene. ");
INSERT INTO yao_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mundu jwalijose jwakulya chiilu changu ni kung'wa miasi jangu, jwelejo akutama nkati mwangu ni uneji ngutama mwa jwelejo. ");
INSERT INTO yao_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mpela ila Atati ŵaali ŵajumi iŵandumile, ni kwa ligongo lya Atati ndili ŵajumi, kwayele jwakundya une chaŵe ŵajumi kwa ligongo lyangu. ");
INSERT INTO yao_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nipele, weleu uli nkate wautulwiche kutyochela kwinani, ngaŵa mpela mana jiŵalile achambuje ŵenu ni kuwa. Nambo juchalye nkate wu chakole umi wa moŵa gose pangali mbesi.” ");
INSERT INTO yao_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Che Yesu ŵaŵechete yeleyo paŵaliji nkwiganya mu nyuumba ja kusimanilana Ŵayahudi ku Kapelenaumu kula. ");
INSERT INTO yao_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nipele ŵakulijiganya ŵao ŵajinji paŵapilikene yeleyo ŵatite, “Aga majiganyo ga gali gakulimba! Ana nduni juchakombole kugakunda?” ");
INSERT INTO yao_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Che Yesu ŵaimanyi pangasalilwa ni mundu kuti ŵakulijiganya ŵao ŵaliji nkusongoneka yankati yeleyo, ni ŵausisye, “Ana majiganyo ga gakuntesya nneche kungulupilila? ");
INSERT INTO yao_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nambi chiiŵe uli pachimummone Mwana jwa Mundu alinkujigalikwa kwaula kwinani kuŵaliji kundanda? ");
INSERT INTO yao_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mbumu jwa Akunnungu ni jwakwichisya umi, machili ga mundu gangali chindu. Maloŵe ginansalile gali Mbumu nombe gali umi. ");
INSERT INTO yao_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Natamuno yeleyo apali ŵane mwa ŵanyamwe ŵangakukulupilila.” Che Yesu ŵaŵechete yeleyo pakuŵa ŵaimanyi chitandile kundanda kuti ŵaani ŵangakulupilila ni nduni juchangalauche. ");
INSERT INTO yao_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nipele Che Yesu ŵaŵechete sooni, “Kwa ligongo lyo nansalile kuti ngapagwa juchakombole kwika kukwangu mpaka akamuchikwe ni Atati ŵangu.” ");
INSERT INTO yao_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kutyochela lyuŵa lyo ŵakulijiganya ŵao ŵajinji ŵalesile kulongana nawo kwaligongo lya maloŵe gala ni ŵaujile panyuma. ");
INSERT INTO yao_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nipele Che Yesu ŵausisye ŵakulijiganya likumi ni ŵaŵili ŵala, “Ana, ni ŵanyamwe nombe nkusaka kwaula?” ");
INSERT INTO yao_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Che Simoni Petulo ŵajanjile, “Ambuje, tutujaule kwa acheni? Mmwejo nkwete maloŵe gagakwikanawo umi wa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Uweji tukukulupilila ni sooni tukwimanyilila kuti mmwejo ndi Jwanswela kutyochela kwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Che Yesu ŵaasalile, “Uli, nganinansagula ŵanyamwe likumi ni ŵaŵili? Nambo jumo jwenu ali Shetani.” ");
INSERT INTO yao_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nambo Che Yesu ŵaliji nkwagamba che Yuda mwana ju che Simoni Isikaliote, pakuŵa jwelejo ni juchangalauche namuno ali jumo jwa ŵakulijiganya likumi ni ŵaŵili ŵala. ");
INSERT INTO yao_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Payamasile yeleyo, Che Yesu ŵaliji nkwendajenda ku Galilaya ko. Nganasaka kwendajenda ku Yudea ligongo achakulu ŵa Ŵayahudi ŵasachile kwaulaga. ");
INSERT INTO yao_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Chindimba cha Ŵayahudi cha masakasa chaŵandichile. ");
INSERT INTO yao_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nipele achapwakwe Che Yesu ŵaasalile, “Ntyoche pelepa njaule ku Yudea kuti ŵakunkuya mmwe nombewo aiwone yakusimonjeka inkwipanganya. ");
INSERT INTO yao_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ngapagwa mundu jwakupanganya chindu kwakulisisa iŵaga akusaka kumanyika ni ŵandu. Pakuŵa nkupanganya yelei, nlilosye mwasyene kwa ŵandu ŵa pachilambo.” ");
INSERT INTO yao_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Namose achapwakwe nganiŵakulupilila. ");
INSERT INTO yao_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nipele, Che Yesu ŵaasalile, “Katema kambone kukwangu kakanaŵe kwika, kukwenu ŵanyamwe katema kakalikose kali kambone. ");
INSERT INTO yao_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ŵandu ŵa pachilambo ngakombola kunchima ŵanyamwe, nambo uneji akunjima pakuŵa naasalile kuti yakuitendekanya yo ili yangalumbana. ");
INSERT INTO yao_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ŵanyamwe njaule kuchindimba cho. Uneji ngunyaula kuchindimba cho pakuŵa katema kambone kukwangu kakanaŵe kwika.” ");
INSERT INTO yao_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ŵaŵechete yeleyo ni kusigala pa Galilaya palapala. ");
INSERT INTO yao_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Achapwakwe paŵamasile kwaula kuchindimba cha masakasa, Che Yesu nombe ŵajawile, nambo nganajaula kwakulilosya, ŵajawile kwakulisisa. ");
INSERT INTO yao_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kuchindimba cho achakulu ŵa Ŵayahudi ŵaliji nkwasosasosa Che Yesu, ni ŵausyene, “Ana ali kwapi ŵelewo?” ");
INSERT INTO yao_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mpingo wa ŵandu waliji nkusongona jwine ni jwine yankati Che Yesu. Ŵandu ŵane ŵatite, “Ali mundu jwambone.” Ni ŵane ŵatite, “Ngaŵa! Akwalambusya ŵandu.” ");
INSERT INTO yao_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Atamuno yeleyo ngapagwa mundu jwalijose jwalinjile kuŵecheta ngani syakwe pelanga kwa ligongo lya kwajogopa achakulu ŵa Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chindimba cho pichaŵandichile kumala, Che Yesu ŵajawile pa Nyuumba ja Akunnungu ni kutanda kwiganya. ");
INSERT INTO yao_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nipele achakulu ŵa Ŵayahudi ŵasimosile ni kuti, “Ana mundu ju agapatile kwapi majiganyo ga, nombejo nganajaule kukulijiganya?” ");
INSERT INTO yao_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pelepo Che Yesu ŵaajanjile, “Majiganyo gungwiganya nganigaŵa gangu, nambo gakutyochela kwa ŵelewo ŵandumile une. ");
INSERT INTO yao_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mundu asakaga kupanganya yakusaka Akunnungu, chaimanyilile kuti majiganyo gungwiganya gatyosile kwa Akunnungu pane nguŵecheta kwa ukombole wangu nansyene. ");
INSERT INTO yao_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jwelejo jwakuŵecheta ngani syakwe nsyene akusosasosa ukulu wakwe nsyene, nambo jwakusosasosa ukulu wa jwannajisye jula, jwelejo ali jwausyene ni mwa jwelejo ngapagwa unami. ");
INSERT INTO yao_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ana che Musa nganampanga malajisyo? Atamuno yeleyo, ngapagwa jwalijose mwa ŵanyamwe jwakugatendekanya gagalembekwe mmalajisyo go. Ana ligongo chi nkusaka kumulaga?” ");
INSERT INTO yao_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Papopo mpingo wekulungwa wa ŵandu wajanjile, “Ana mmwe nkwete masoka! Nduni jwakusaka kummulaga mmwe?” ");
INSERT INTO yao_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Che Yesu ŵaajanjile, “Mbanganyisye chakusimonjeka chimo ni ŵanyamwe nkuchisimonga. ");
INSERT INTO yao_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Che Musa ŵampele chisyoŵelo cha kwaumbasya achiŵana ŵenu. Nambo chisyoŵelo cho nganichityochela ku che Musa nambo chatyochele kwa achambuje ŵenu. Sambano ŵanyamwe nkummumbasya mwanache pa Lyuŵa lya Kupumulila. ");
INSERT INTO yao_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Iŵaga mundu akuumbala pa Lyuŵa lya Kupumulila kuti ganatemeche malajisyo, sambano kwa chichi nkuundumbilila une ligongo nannamisye mundu pa Lyuŵa lya Kupumulila? ");
INSERT INTO yao_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kasinlamula kwa meeso pe, nambo nlamule kwa goloka.” ");
INSERT INTO yao_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ŵandu ŵane ŵa ku Yelusalemu ŵatandite kuliusya, “Ana mundu ju ngaŵa ajula jwakusosekwa ni ilongola kuti ammulaje? ");
INSERT INTO yao_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nnole, sambano akuŵecheta pelanga, nombe ngapagwa mundu jwakuntanjila chachilichose. Uli, ilongola akwimanyilila kuti aju ali Kilisito Jwakuwombola? ");
INSERT INTO yao_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pachaiche Kilisito ngapagwa mundu juchakumanye kwakopochele, nambo uweji tukumanyi kwakopochele mundu ju!” ");
INSERT INTO yao_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nipele Che Yesu paŵaliji nkwiganya pa Nyuumba ja Akunnungu ŵanyanyisye achitiji, “Ana ŵanyamwe nkuumanyilila une ni sooni nkumanyi kungopochele? Une nguniika kwa ulamusi wangu nansyene, nambo ŵandumile une wo ali ŵausyenesyene, ni ŵanyamwe ngunkwamanyilila, ");
INSERT INTO yao_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","uneji ngwamanyilila pakuŵa ngopochele kwa ŵelewo, nombewo ni ŵandumile une.” ");
INSERT INTO yao_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nipele ŵandu ŵasachile kwakamula, nambo nganapagwa mundu jwalijose jwalinjile kunkwaya, ligongo katema kakwe kaliji kakanaŵe kwika. ");
INSERT INTO yao_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mumpingo wa ŵandu mula, ŵandu ŵajinji ŵakulupilile ni kuti, “Ana aikaga Kilisito Jwakuwombola chapanganye imanyisyo yekulungwa kupunda ayiyi yakuitendekanya aŵa?” ");
INSERT INTO yao_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafalisayo ŵapilikene ŵandu achisongonaga jwine ni jwine yankati Che Yesu. Nipele achakulu ŵambopesi pamo ni Mafalisayo ŵatumile ŵakulindilila Nyuumba ja Akunnungu akaakamule Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Che Yesu ŵaasalile, “Chindame ni ŵanyamwe kwa katema kakajipi, nipele chinyaule kwa ŵandumile ŵala. ");
INSERT INTO yao_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chimuusose nambo ngamuuwona, pakuŵa pepala pachime ŵanyamwe ngankombolanga kwika.” ");
INSERT INTO yao_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Achakulu ŵa Ŵayahudi ŵausyanaga achinsyene pe, “Ana mundu ju chajaule kwapi kwakuti ngatukombola kwawona? Ana chajaule kwa Ŵayahudi ŵapwilingene ni kutama mu misi ja Ŵagiliki ni kwajiganya Ŵagiliki? ");
INSERT INTO yao_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ana malumbo gakwe chichi pakuti, ‘Chimuusose nambo ngamuuwona, ni pepala pachime ŵanyamwe ngankombola kwika?’ ” ");
INSERT INTO yao_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lyuŵa lya mbesi lya chindimba cho lyaliji lyuŵa lyekulungwa. Che Yesu ŵajimi ni kuŵecheta kwa liloŵe lyakunyanyisya, “Mundu jwalijose jwakwete njota aiche kung'wa kukwangu. ");
INSERT INTO yao_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mpela Malembelo ga Akunnungu yagakuti pakusala, ‘Jwakungulupilila uneji, sulo sya meesi gagakwikanawo umi chigajilime kutyochela nkati mwao!’ ” ");
INSERT INTO yao_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ŵaŵechete yeleyo nkati Mbumu jwa Akunnungu juchapochelwe ni aŵala ŵakwakulupilila Che Yesu. Mpaka katema ko ŵandu ŵaliji nganampochele Mbumu jwa Akunnungu pakuŵa Akunnungu ŵaliji akanaŵe kunkusya Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ŵandu ŵane mu mpingo ula ŵapilikene maloŵe go, ni ŵatite, “Isyene mundu ju ali jwakulondola jula!” ");
INSERT INTO yao_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ŵandu ŵane ŵatite, “Aju ali Kilisito Jwakuwombola!” Nambo ŵandu ŵane ŵaliji nkuliusya, “Ana ikukomboleka Kilisito akopochele ku Galilaya? ");
INSERT INTO yao_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ana Malembelo ga Akunnungu ngagakuti, ‘Kilisito Jwakuwombola chakopochele mu lukosyo lwa mwenye che Daudi, ni chapagwe ku Beselehemu, musi uŵatemi mwenye che Daudi?’ ” ");
INSERT INTO yao_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nipele, ŵandu ŵa mumpingo ŵalekangene kwa ligongo lya Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ŵandu ŵane ŵasachile kwakamula nambo ngapagwa mundu jwalijose juŵankwaiye. ");
INSERT INTO yao_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nipele ŵakulindilila Nyuumba ja Akunnungu paŵausile, achakulu ŵambopesi ni Mafalisayo, ŵausisye, “Kwachichi nganimwaichisya Che Yesu?” ");
INSERT INTO yao_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ŵakulindilila ŵala ŵajanjile, “Nganapagwe mundu jwalijose jwakombwele kuŵecheta mpela mundu ju!” ");
INSERT INTO yao_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nipele Mafalisayo ŵausisye, “Ana annambwisye ni ŵanyamwe ŵakwe? ");
INSERT INTO yao_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ana mpatile kumbona jumo jwa ilongola, pane jumo jwa Mafalisayo jwankulupilile jwelejo? ");
INSERT INTO yao_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ngwamba, nambo ŵandu ŵa ngakugamanyilila malajisyo ga Akunnungu gaŵapele che Musa, kwayele Akunnungu ŵalwesisye!” ");
INSERT INTO yao_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jumo jwao ŵaliji che Nikodemu jumo jwa Mafalisayo juŵajaulile Che Yesu kundanda, ŵaasalile achinjakwe, ");
INSERT INTO yao_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Malajisyo getu gakusala kuti, ngatukukombola kunlamula mundu jwalijose pangampilikanila kaje ni kwimanyilila chichi chakupanganya.” ");
INSERT INTO yao_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ni ŵanyawo ŵanjanjile, “Ni ŵanyamwe ŵakwe ntyochele ku Galilaya? Nsosesose Mmalembelo Gamaswela nomwe chinnole kuti ku Galilaya ngaakopochela jwakulondola jwa Akunnungu!” ");
INSERT INTO yao_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nipele kila mundu ŵausile kumangwakwe. ");
INSERT INTO yao_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pakumala yeleyo Che Yesu ŵajawile ku chikwesya cha Miseituni. ");
INSERT INTO yao_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Malaŵi jakwe kundaŵi pe, Che Yesu ŵajawile sooni pa Nyuumba ja Akunnungu. Ŵandu wose ŵansyungwile, nombewo ŵatemi ni kutanda kwajiganya. ");
INSERT INTO yao_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nipele Ŵakwiganya malajisyo pamo ni Mafalisayo ŵannyichenawo jwankongwe juŵakamwilwe ali nkutenda chikululu. Ŵanjimiche jwankongwe jo paujo pa ŵandu. ");
INSERT INTO yao_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nipele ŵambusisye Che Yesu, “Jwakwiganya, jwankongwe ju akamwilwe ali nkutenda chikululu. ");
INSERT INTO yao_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mmalajisyo getu che Musa ŵatulajisye yele, jwankongwe mpela aju aulajikwe kwa kuputikwa ni maganga. Nambi mmwejo nkuti uli?” ");
INSERT INTO yao_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ŵatite yeleyo kuti ŵalinje Che Yesu akole chakumbechetela. Nambo Che Yesu ŵakoteme ni kulemba paasi ni chala chakwe. ");
INSERT INTO yao_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Paŵapundile kumbusya, Che Yesu ŵajinamukwiche ni kwasalila, “Naga kwana mundu jwalijose mwa ŵanyamwe jwanganakola sambi aŵe jwaandanda kumponya liganga.” ");
INSERT INTO yao_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nipele ŵakoteme sooni ni kulemba paasi. ");
INSERT INTO yao_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Paŵapilikene yeleyo ŵatandite kutyoka jumo jumo achilongolelaga achachekulu. Che Yesu ŵasigele jikape ni jwankongwe jula ali ajimi palapala. ");
INSERT INTO yao_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ni Che Yesu paŵajinamukwiche ŵambusisye jwankongwe jula, “Amao, ŵandu ŵala alinji kwapi? Uli, ngapagwa jwanlamwile mmwejo?” ");
INSERT INTO yao_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jwankongwe jula ŵajanjile, “Ambuje, ngapagwa namose jumo jwanamwile!” Nombe Che Yesu ŵansalile, “Uneji nombe ngangunlamula. Njaule, nambo kutandila sambano nkatenda sambi sooni.” ");
INSERT INTO yao_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Che Yesu ŵakungulwiche sooni ni ŵandu achitiji, “Uneji ndili lilanguka lya pachilambo pano. Mundu jwalijose jwakunguya uneji ngajenda mu chipi ng'o, nambo chakole ni lilanguka lya umi.” ");
INSERT INTO yao_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nipele Mafalisayo ŵansalile, “Nkusala umboni wenu mwasyene, sambano umboni wenu uli wa unami.” ");
INSERT INTO yao_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Che Yesu ŵaajanjile, “Atamuno nasalaga umboni wangu nansyene, umboni wangu uli usyene ligongo uneji nakumanyi kungopochele ni kungwaula. Nambo mwanya ngankukumanyilila kungopochele ni kungwaula. ");
INSERT INTO yao_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ŵanyamwe nkulamula kwa ng'anisyo sya chiundu nambo uneji ngangunlamula mundu. ");
INSERT INTO yao_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Naatamuno nalamulaga, ulamusi wangu uli usyene ligongo uneji ngangupanganya masengo jika, Atati ŵandumile une wo ali pamo ni une. ");
INSERT INTO yao_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ilembekwe mmalajisyo genu, umboni wa ŵandu ŵaŵili uli wa usyene. ");
INSERT INTO yao_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Uneji ngusala umboni wangu nansyene, ni Atati ŵandumile nombe akusala umboni wangu.” ");
INSERT INTO yao_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pelepo ŵambusisye, “Ana Atati ŵenu ali kwapi?” Che Yesu ŵajanjile, “Ŵanyamwe ngankuumanyilila uneji atamuno ngankummanyilila Atati ŵangu. Nkaamanyilile uneji nkaamanyilile Atati ŵangu nombe.” ");
INSERT INTO yao_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Che Yesu ŵaŵechete maloŵe go mu chuumba cha mbiko, paŵaliji nkwiganya pa Nyuumba ja Akunnungu. Ni nganapagwa mundu juŵankamwile pakuŵa katema kakwe kaliji kakanaŵe kwika. ");
INSERT INTO yao_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Che Yesu ŵaasalile sooni, “Uneji ngwaula ni ŵanyamwe chimuusose, nambo chimmwe mu sambi syenu. Kungwaula uneji, ŵanyamwe ngankombola kwika.” ");
INSERT INTO yao_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nipele, achakulu ŵa Ŵayahudi ŵatite, “Ana chaliulaje? Ana kwa ligongo chi akuti, ‘Kungwaula ŵanyamwe ngankombola kwika?’ ” ");
INSERT INTO yao_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Che Yesu ŵaasalile, “Ŵanyamwe nkopochele papapa pachilambo cha paasi, nambo uneji ngopochele kwinani. Ŵanyamwe nlinji ŵa pachilambo pano, nambo uneji nguniŵa jwa pachilambo pano. ");
INSERT INTO yao_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kwaligongo lyo nansalile kuti chimmwe mu sambi syenu. Pakuŵa ngankukulupilila kuti, ‘Uneji ndili jwelejo’ chimmwe mu sambi syenu.” ");
INSERT INTO yao_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nombe ŵanyawo ŵambusisye, “Ana mmwejo ni ŵaani?” Che Yesu ŵajanjile, “Uneji ndili jwelejo, mpela inansalile chitandile kundanda! ");
INSERT INTO yao_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ngwete yejinji yakuŵecheta ni kulamula nkati ŵanyamwe. Nambo ŵandumile une ali ŵausyene, none ngwasalila ŵandu wose ŵa pachilambo yeila pe imbilikene kutyochela kwa ŵelewo.” ");
INSERT INTO yao_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ŵanyawo nganaimanyilila kuti Che Yesu ŵaŵechetaga nawo yankati ngani sya Akunnungu, Atati ŵao. ");
INSERT INTO yao_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nipele Che Yesu ŵaasalile, “Pachimunnyakule Mwana jwa Mundu, pelepo ni pachimmanyilile kuti, ‘Uneji ndili jwelejo,’ ni chimmanyilile kuti ngangupanganya chachili chose nansyene, nambo nguŵecheta yeila pe inyiganyikwe ni Atati. ");
INSERT INTO yao_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ŵandumile ŵala ali pamo ni uneji, nganaaneka jika, pakuŵa moŵa gose nguitendekanya aila yaikwanonyela.” ");
INSERT INTO yao_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ŵandu ŵajinji ŵaŵampilikanile Che Yesu achiŵechetaga maloŵe ga ŵankulupilile. ");
INSERT INTO yao_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nipele Che Yesu ŵaasalile Ŵayahudi ŵaŵakulupilile ŵala kuti, “Mwaikamulichisyaga inanjigenye, chimme ŵakulijiganya ŵangu ŵa usyenesyene. ");
INSERT INTO yao_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chimuumanyilile usyene, ni usyene wo chiuntende ŵalecheleswe.” ");
INSERT INTO yao_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nombe ŵanyawo ŵanjanjile, “Tuli uŵelesi u che Iblahimu ni nganituŵa achikapolo ŵa mundu jwalijose. Ana malumbo gakwe chichi pankuti, ‘Chinchilecheleswa?’ ” ");
INSERT INTO yao_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Che Yesu ŵaajanjile, “Ngunsalila isyene, mundu jwalijose jwakutendekanya sambi ali kapolo jwa sambi. ");
INSERT INTO yao_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kapolo ngakutama pamusi moŵa gose, nambo mwanache akutama pamusi moŵa gose. ");
INSERT INTO yao_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nipele Mwana annechelesyaga ŵanyamwe nombe chimbe ŵalecheleswe kusyenesyene. ");
INSERT INTO yao_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Naimanyi kuti ŵanyamwe nlinji uŵelesi u che Iblahimu. Nambo nkusaka kumulaga ligongo nkugakana majiganyo gangu. ");
INSERT INTO yao_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Uneji nguŵecheta aila pe yanosisye Atati ŵangu, nambo ŵanyamwe nkupanganya aila yansalile atati ŵenu.” ");
INSERT INTO yao_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ŵanyawo ŵanjanjile, “Uweji Atati ŵetu ali che Iblahimu!” Che Yesu ŵaasalile, “Ŵanyamwe nkaŵe ŵanache ŵa che Iblahimu nkaitendekenye aila iŵaitendekenye che Iblahimu. ");
INSERT INTO yao_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Uneji nansalile usyene unaupilikene kutyochela kwa Akunnungu, atamuno yeleyo ŵanyamwe nkusaka kumulaga. Che Iblahimu nganapanganya yeleyo! ");
INSERT INTO yao_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ŵanyamwe nkutendekanya ilaila yaitesile atati ŵenu.” Ŵanyawo ŵansalile, “Uweji nganitupagwe kwa chikululu! Tukwete atati ŵamope, ŵelewo ali Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Che Yesu ŵaasalile, “Ikaŵe Akunnungu ali Atati ŵenu, nkaanonyele uneji pakuŵa uneji natyosile kwa Akunnungu ni sambano ndili papapa pepa. Nguniika kwa malamulo gangu nansyene nambo kwa malamulo ga ŵandumile une wo. ");
INSERT INTO yao_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ana kwachichi ngankugapilikanichisya ginguŵecheta ga? Ligongo ngankusaka kugapilikana maloŵe gangu. ");
INSERT INTO yao_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ŵanyamwe atati ŵenu Jwakulinga ni ŵanyamwe nkusaka kutendekanya yaikwanonyelesya atati ŵenu. Chitandile kundanda jwelejo ŵaliji jwakuulaga, ni nganawai kwima ku upande wa usyene, mwa jwelejo nganiupagwa usyene. Paakuŵecheta ya unami, akuŵecheta yatite kusyoŵelela, pakuŵa jwelejo ali jwa unami ni atati jwa unami wose. ");
INSERT INTO yao_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pakuŵa uneji ngunsalila usyene, ŵanyamwe ngankungulupilila. ");
INSERT INTO yao_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mwa ŵanyamwe nduni juchakombole kuŵalanga umboni kuti uneji ngwete sambi? Ana iŵaga nguŵecheta usyene, kwachichi ngankungulupilila? ");
INSERT INTO yao_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ŵandu ŵa Akunnungu akugapilikana maloŵe gakuŵecheta Akunnungu, ŵanyamwe ngankupilikana pakuŵa ŵanyamwe nganimma ŵandu ŵa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ŵayahudi ŵanjanjile Che Yesu, “Ana nganitusala uchenene kuti mmwejo ndi Msamalia ni sooni nkwete lisoka?” ");
INSERT INTO yao_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Che Yesu ŵajanjile, “Uneji nganingola lisoka. Uneji ngwachimbichisya Atati ŵangu, nambo ŵanyamwe ngankunjimbichisya une. ");
INSERT INTO yao_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Uneji ngangulisosela ukulu wangu nansyene. Apali jumo jwakuusosela ukulu wo, nombejo ali jwakulamula. ");
INSERT INTO yao_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ngunsalila isyene, mundu jwalijose jwakugakamulichisya majiganyo gangu ngaawa nambo chatame moŵa gose pangali mbesi.” ");
INSERT INTO yao_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ŵayahudi ŵansalile Che Yesu, “Sambano twimanyi uchenene kuti mmwejo nkwete lisoka! Che Iblahimu ŵawile, ni ŵakulondola ŵa Akunnungu ŵawile iyoyo peyo, nomwe nkuti, ‘Mundu jwalijose agakamulichisyaga majiganyo gangu ngaawa!’ ");
INSERT INTO yao_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ana mmwejo nkulitenda ŵakulungwa kwapunda atati ŵetu che Iblahimu juŵawile jula? Natamuno ŵakulondola ŵa Akunnungu ŵawile nombewo. Sambano mmwejo nkulitenda ŵaani?” ");
INSERT INTO yao_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Che Yesu ŵajanjile, “Nalikusyaga une nansyene, ukulu wangu ngaŵa chindu. Atati ŵangu ŵankwaŵilanga Akunnungu ŵenu, ŵelewo ni ŵakungusya une. ");
INSERT INTO yao_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ŵanyamwe ngannaŵe kwamanyilila, nambo uneji naamanyi. Nombe nasalaga kuti ngangwamanyilila, chime jwaunami mpela ŵanyamwe. Uneji ngwamanyilila ni ngulikamulichisya liloŵe lyao. ");
INSERT INTO yao_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Atati ŵenu che Iblahimu ŵasangalele aliwone lyuŵa lya kwika kwangu, nombewo ŵaliweni ni ŵasengwile.” ");
INSERT INTO yao_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nipele Ŵayahudi ŵaasalile, “Mmwejo nkuti uli kuti mwaweni che Iblahimu nomwe nganinnyiche yaka makumi nsano?” ");
INSERT INTO yao_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Che Yesu ŵaasalile, “Ngunsalila isyene, akanaŵe kupagwa che Iblahimu uneji napali.” ");
INSERT INTO yao_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pelepo ŵalokwete maganga achisakaga kwaponya, nambo Che Yesu ŵaalesile ni kutyoka pa Nyuumba ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Che Yesu paŵapitaga, ŵambweni mundu jwangalola chitandile kupagwa kwakwe. ");
INSERT INTO yao_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nipele ŵakulijiganya ŵao ŵausisye, “Jwakwiganya, Ana ŵaani ŵatesile sambi mpaka mundu ju apagwe ali ngakulola, mundu ju pane achaŵelesi ŵakwe?” ");
INSERT INTO yao_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Che Yesu ŵajanjile, “Ngaŵa mundu ju atamuno achaŵelesi ŵakwe ŵaŵatesile sambi, nambo apagwile jwangalola kuti machili ga Akunnungu gawoneche gachipanganyaga masengo mu utame wakwe. ");
INSERT INTO yao_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tukusachilwa kupanganya masengo ga ŵandumile une ŵala muusi uli chiŵela. Pakuŵa chilo chikwika ni ngapagwa mundu jwakukombola kupanganya masengo. ");
INSERT INTO yao_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ndili chiŵela mchilambo, uneji ndili lulanga lwa ŵandu ŵa pachilambo.” ");
INSERT INTO yao_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Che Yesu paŵamasile kuŵecheta yeleyo, ŵasunile mata paasi ŵagumbile litaka ni mata ni kumpakasya pa meeso jwangalola jula. ");
INSERT INTO yao_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nipele ŵansalile jwangalola jula, “Njaule nkasukusule mu litanda lya Siloamu.” Siloamu malumbo gakwe “Ŵaŵalajiswe.” Pelepo jwangalola jo ŵajawile ni kusukusula, nipele ŵausile kumusi ali nkulola. ");
INSERT INTO yao_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nipele, ŵapachiŵandi ŵakwe ni aŵala ŵaŵambweni ali nkuŵendaŵenda kundanda ŵaliusisye, “Ana ajuju nganaŵa ajula mundu juŵaŵendaŵendaga?” ");
INSERT INTO yao_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ŵandu ŵane ŵatite, “Ni jwelejo.” Nambo ŵane ŵatite, “Ajuju nganaŵa jwelejo agambile kulandana.” Nambo nsyene ŵatite, “Uneji ndili jujojo junaŵendaŵendaga!” ");
INSERT INTO yao_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nipele ŵambusisye, “Sambano iŵele uli nkulola?” ");
INSERT INTO yao_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nombewo ŵajanjile, “Mundu jwakuŵilanjikwa Che Yesu jula ŵagumbile litaka, ŵambakesye pa meeso ni kuusalila, ‘Njaule nkasukusule mu litanda lya Siloamu.’ Pelepo uneji najawile ni panasukusulaga natandite kulola.” ");
INSERT INTO yao_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ni ŵambusisye, “Ana mundu jo alikwapi?” Nombejo ŵaajanjile, “Kwaalini!” ");
INSERT INTO yao_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nipele ŵandu ŵanjawisye ajula juŵaliji ngakulola kundanda kwa Mafalisayo. ");
INSERT INTO yao_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lyuŵa lyo Che Yesu paŵagumbile litaka ni kumbugula meeso jwangalola jula lyaliji Lyuŵa lya Kupumulila. ");
INSERT INTO yao_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nipele Mafalisayo ŵambusisye ajula mundu juŵaliji ngakulola kundanda, “Ana nkombwele chinauli kulola?” Nombejo ŵajanjile, “Ŵambakesye litaka pa meeso, none nasukuswile ni sambano ngulola.” ");
INSERT INTO yao_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafalisayo ŵane ŵatite, “Mundu jwatesile yeleyi nganatyochela kwa Akunnungu pakuŵa ngakugakamula malajisyo ga Lyuŵa lya Kupumulila.” Nambo ŵandu ŵane ŵatite, “Ana mundu jwali ni sambi chakombole kutendekanya imanyisyo mpela ayiyi?” Nipele, kwaliji ni utinda mwa ŵandu wo. ");
INSERT INTO yao_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nipele Mafalisayo ŵambusisye sooni juŵaliji ngakulola jula, “Nkuti ambugwile meeso genu, sambano mmwejo nkuŵecheta ichichi nkati mundu jo?” Nombejo ŵajanjile, “Mundu jo ali jwakulondola jwa Akunnungu!” ");
INSERT INTO yao_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Achakulu ŵa Ŵayahudi nganajitichisya kuti mundu jo ŵaliji ngakulola chitandilile kundanda ni sambano akulola, mpaka paŵaaŵilasile achaŵelesi ŵakwe. ");
INSERT INTO yao_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ŵausisye, “Ana aju ngati ni mwanagwenu junkuti ŵapagwile ngakulola? Ana sambano akombwele chinauli kulola?” ");
INSERT INTO yao_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Achaŵelesi ŵakwe ŵajanjile, “Tukwimanyilila kuti ajuju ni mwanagwetu ni tukwimanyilila kuti ŵapagwile jwangalola. ");
INSERT INTO yao_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nambo akombwele chinauli kulola ngatukumanyilila, ni jwantesile akombole kulola nombejo ngatukwamanyilila. Mumbusye nsyene, jwelejo ali jwankule, chaliŵalanje.” ");
INSERT INTO yao_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Achaŵelesi ŵakwe ŵaŵechete yeleyo ligongo ŵaajogwepe achakulu ŵa Ŵayahudi, pakuŵa ŵelewo ŵalangene chile kuti, mundu jwalijose ajitichisyaga kuti Che Yesu ali Kilisito Jwakuwombola chaŵinjikwe mu nyuumba ja kupopelela. ");
INSERT INTO yao_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Lyelelyo ni ligongo achaŵelesi ŵakwe ŵatite, “Jwelejo ali jwankule, mumbusye nsyene.” ");
INSERT INTO yao_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nipele ŵambilasile kaaŵili juŵapagwile ali ngakulola jula ni kunsalila, “Nnumbile kwa Akunnungu iŵaga nkusala isyene! Uweji tukwimanyilila kuti mundu jwannamisye mmwe ali jwa sambi.” ");
INSERT INTO yao_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nombejo ŵajanjile, “Iŵaga mundu ju ali jwa sambi pane nganakola sambi une ngangwimanyilila. Nambo une nguchimanyilila chindu chimo, kuti naliji jwangalola ni sambano ngulola.” ");
INSERT INTO yao_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nipele Ŵambusisye sooni, “Ana antesile chichi? Ana agaugwile chinauli meeso genu?” ");
INSERT INTO yao_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mundu jo ŵajanjile, “Nansalile sampano, ni ŵanyamwe nganinsaka kupilikanichisya, kwachichi nkusaka kupilikanila sooni ngani ji? Uli, nombe ŵanyamwe nkusaka kuŵa ŵakulijiganya ŵakwe?” ");
INSERT INTO yao_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nambo ŵanyawo ŵantukene achitiji, “Mmwe ndi jwakulijiganya jwa mundu jo, nambo uweji tuli ŵakulijiganya ŵa che Musa. ");
INSERT INTO yao_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Uweji tuimanyi kuti Akunnungu ŵaŵechete ni che Musa, nambo mundu ju ngatukukumanyilila kwakopochele!” ");
INSERT INTO yao_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nombejo ŵaajanjile, “Ŵanyamwe nkuusimosya! Ŵanyamwe ngankukumanyilila kwakopochele mundu ju, nambo agaugwile meeso gangu! ");
INSERT INTO yao_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tukumanyilila kuti Akunnungu ngakwapilikanila ŵandu ŵaali ni sambi, nambo Akunnungu akumpilikanila mundu jwakunchimbichisya ni kupanganya yakusaka. ");
INSERT INTO yao_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Chitandile gumbikwa chilambo ngapagwa mundu jwapilikene kuti mundu agaugwile meeso ga mundu jwapagwilwe ali ngakulola. ");
INSERT INTO yao_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iŵaga mundu ju nganatyochela kwa Akunnungu, ngaakakombole kupanganya chachili chose!” ");
INSERT INTO yao_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ŵanyawo ŵajanjile, “Mmwejo mwapagwilwe ni kukula mu sambi ana nomwe nkusaka kutujiganya uweji?” Nipele Ŵayahudi ŵambinjile mundu jo mu nyuumba ja kupopelela. ");
INSERT INTO yao_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Che Yesu ŵapilikene kuti mundu juŵannamisye jula aŵinjikwe pa Nyuumba ja Kupopelela. Nipele paŵansimene ŵambusisye, “Ana mmwejo nkunkulupilila Mwana jwa Mundu?” ");
INSERT INTO yao_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mundu jo ŵajanjile, “Ambuje, ana ŵelewo ali ŵaani, musalile kuti nakulupilile.” ");
INSERT INTO yao_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Che Yesu ŵansalile, “Sambano mummweni, nombe ni jwelejo jwakukunguluka nomwe.” ");
INSERT INTO yao_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nipele mundu jo ŵatite, “Ambuje, ngukulupilila!” Ni ŵatindiŵele ni kwakotamila. ");
INSERT INTO yao_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Che Yesu ŵatite, “Uneji nyiche pachilambo pano kukwasapulanya ŵandu, kuti ŵangalola akombole kulola, ni ŵakulola aŵeje ŵangalola.” ");
INSERT INTO yao_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafalisayo ŵane ŵaŵaliji pamo ni Che Yesu ŵagapilikene maloŵe go, ni ŵambusisye, “Uli, nowe ŵakwe tuli ŵangalola?” ");
INSERT INTO yao_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Che Yesu ŵajanjile, “Nkaliji ŵangalola, ngankaŵe ni sambi, nambo sambano ŵanyamwe nkulitenda, ‘Uweji tukulola,’ yelei ikulosya kuti nli mu sambi.” ");
INSERT INTO yao_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Che Yesu ŵaasalile, “Ngunsalila isyene, mundu jwalijose jwakwinjila mu lichinga lya ngondolo pangajinjilila pa nnango, nambo akwinjilila kwine, jwelejo ali jwawiyi ni jwakusumula. ");
INSERT INTO yao_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nambo jwakwinjilila pa nnango, jwelejo ali jwakuchinga ngondolo. ");
INSERT INTO yao_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jwakulindilila akumbugulila nnango mundu jo, ni ngondolo sikupilikana liloŵe lya jwakuchinga, nombejo akusiŵilanga ngondolo syakwe jwalijose kwa liina lyakwe ni kusikoposya paasa. ");
INSERT INTO yao_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Amalaga kusikoposya paasa akusilongolela, nombe ngondolo syo sikunkuya, pakuŵa sikulimanyilila liloŵe lyakwe. ");
INSERT INTO yao_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ngondolo syo ngasikombola kunkuya jwannendo, nambo sisimmutuche pakuŵa ngasikumanyilila liloŵe lyakwe.” ");
INSERT INTO yao_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Che Yesu ŵaasalile chitagu cho, nambo ŵandu wo nganaimanyilila chasachile kwasalila. ");
INSERT INTO yao_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nipele Che Yesu ŵaŵechete sooni, “Ngunsalila isyene, uneji ndili nnango wa kwinjilila ngondolo. ");
INSERT INTO yao_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ŵane wose ŵaŵanongolele kwika ŵaliji ŵawiyi ni ŵakusumula, nombe ngondolo syo nganisyapilikanila. ");
INSERT INTO yao_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Uneji ndili nnango, mundu jwalijose jwakwinjila mu lichinga kwa kwinjilila kukwangu chakulupuswe, chajinjile ni kukopoka, ni kupata yakulya. ");
INSERT INTO yao_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jwawiyi akwika achisakaga kwiŵa ni kuulaga ni kujonanga. Uneji iiche kuti akole umi wa usyene, wangaukupungula.” ");
INSERT INTO yao_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Uneji ndili jwakuchinga jwambone. Jwakuchinga jwambone akuutyosya umi wakwe kwa ligongo lya ngondolo syakwe. ");
INSERT INTO yao_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jwamasengo jwanganaŵa jwakuchinga, namose nganaŵa nsyene ngondolo. Pakugawona masogo gali nkwika, akusileka ngondolo ni kuutuka. Nipele masogo gakusikamula ni kusipwilinganya. ");
INSERT INTO yao_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mundu jo akuutuka pakuŵa ali mundu jwamasengo jwa malipilo ni ngondolo ngaŵa chindu kukwakwe. ");
INSERT INTO yao_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Uneji ndili jwakuchinga jwambone. Ngusimanyilila ngondolo syangu ni ngondolo syangu sikuumanyilila une, ");
INSERT INTO yao_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","mpela ila Atati yakuti pakuumanyilila, ni uneji inguti pakwamanyilila Atati. Uneji nguutyosya umi wangu kwa ligongo lya ngondolo. ");
INSERT INTO yao_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sooni ngwete ngondolo sine syangaŵa sya lichinga li. Nombesyo ngusachilwa kusiichisya, nombesyo sisipilikane liloŵe lyangu ni chikuŵe mpingo umo ni jwakuchinga jumo.” ");
INSERT INTO yao_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Atati akuunonyela une ligongo nguutyosya umi wangu kuti mbochele sooni. ");
INSERT INTO yao_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ngapagwa mundu jwakuusumula umi wangu, uneji nguutyosya nansyene. Ngwete ukombole wa kuutyosya ni ukombole wa kuutola. Yelei ni yatite pakulajisya Atati ŵangu mbanganye.” ");
INSERT INTO yao_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kwa ligongo lya maloŵe ga Che Yesu, Ŵayahudi ŵatindene sooni. ");
INSERT INTO yao_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ŵajinji mwa ŵelewo ŵatite, “Akwete lisoka, ni sooni jwampugwe! Kwachichi nkumpilikanila?” ");
INSERT INTO yao_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ŵandu ŵane ŵatite, “Mundu jwakamwilwe ni lisoka ngakukombola kuŵecheta yelei. Ana lisoka likukombola kugaugula meeso ga ŵandu ŵangalola?” ");
INSERT INTO yao_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ku Yelusalemu ko kwaliji ni chindimba chakukumbuchila kujiŵika pajika Nyuumba kwa ligongo lya Ambuje. Ni katema ko kaliji katema ka mbepo. ");
INSERT INTO yao_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nombe Che Yesu ŵaliji nkwendajenda pa Nyuumba ja Akunnungu pansana pa mwenye Che Selemani. ");
INSERT INTO yao_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nipele Ŵayahudi ŵaasyungwile, ni ŵambusisye, “Ana chintuleche tuli nkuganisya mpaka chakachi? Iŵaga mmwe ndi Kilisito Jwakuwombola, ntusalile uchenene.” ");
INSERT INTO yao_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Che Yesu ŵajanjile, “Nansalile, nambo nganimungulupilila. Masengo gingugapanganya kwa ulamusi wa Atati ŵangu gakulosya kuti une ndili jwelejo. ");
INSERT INTO yao_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nambo ŵanyamwe ngankukulupilila pakuŵa ŵanyamwe nganimma ngondolo syangu. ");
INSERT INTO yao_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ngondolo syangu sikupilikana liloŵe lyangu. Uneji ngusimanyilila, nombesyo sikuunguya. ");
INSERT INTO yao_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Uneji ngusipa umi wa moŵa gose pangali mbesi, nombesyo ngasiwa ng'o. Ngapagwa mundu jwalijose juchakombole kuumbokonya. ");
INSERT INTO yao_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Atati ŵangu juŵambele ngondolo syo ali jwankulu kupunda wose, nombe ngapagwa mundu jwalijose juchakombole kusipokonya mmakono mwa Atati ŵangu. ");
INSERT INTO yao_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Uneji ni Atati ŵangu tuli ŵamo.” ");
INSERT INTO yao_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nipele Ŵayahudi ŵalokwete sooni maganga kuti ŵaulaje Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Che Yesu ŵaasalile, “Nannosisye masengo gambone gamajinji gaŵambele Atati ŵangu kuti nagapanganye. Ana masengo chi gambone mwa gelego gankusaka kumulajila?” ");
INSERT INTO yao_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ŵayahudi ŵajanjile, “Ngatukumponya maganga kwa ligongo lya masengo gambone, nambo kwa ligongo lya kwatukana Akunnungu! Pakuŵa mmwejo ndi mundu pe, nambo nkulitenda Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Che Yesu ŵajanjile, “Ilembekwe Mmalajisyo genu kuti, Akunnungu ŵatite, ‘Ŵanyamwe ndi achiminungu?’ ");
INSERT INTO yao_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Akunnungu ŵaaŵilasile achiminungu aŵala wose ŵaŵasalilwe liloŵe lyao, ni uweji tuimanyi kuti Malembelo ga Akunnungu gakuŵecheta usyene moŵa gose. ");
INSERT INTO yao_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sambano Atati asagwile ni kunduma pachilambo pa. Kwachichi ŵanyamwe kuusalila, ngwatukana Akunnungu, panguti, uneji ndili Mwana jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Iŵaga ngangupanganya masengo gaasachile Atati ŵangu nagapanganye, nkangulupilila une. ");
INSERT INTO yao_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nambo iŵaga ngugapanganya masengo gao, natamuno munaangulupilile uneji, ngakulupilile masengo gangu. Pelepo chimmanyilile kusyene kuti Atati ali mwangu une ni uneji ndili mwa Atati.” ");
INSERT INTO yao_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nipele ŵalinjile sooni kwakamula Che Yesu, nambo ŵalikulupwisye ni kutyoka. ");
INSERT INTO yao_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Che Yesu ŵajawile sooni pesi lusulo lwa Yolodani, kwiuto kuŵabatisyaga che Yohana ŵandu kula ni kutama kweleko. ");
INSERT INTO yao_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ŵandu ŵajinji ŵanjaulile ni kuti, “Che Yohana nganaapanganya chimanyisyo chachili chose. Nambo yose yaisasile che Yohana nkati mundu ju ili isyene.” ");
INSERT INTO yao_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kweleko ŵandu ŵajinji ŵaakulupilile Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mundu jumo jwakuŵilanjikwa che Lasalo juŵatamaga nsinda wa ku Besania ŵaliji jwakulwala. Che Maliamu ni nlumbugwe che Masa ŵatamaga nsinda ulaula. ");
INSERT INTO yao_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Che Maliamu ju ni jwejula juŵampakesye mauta ga kununjila Ambuje Che Yesu mmakongolo ni kwasyula ni umbo syakwe. Che Lasalo mpwakwe che Maliamu ni juŵalwalaga. ");
INSERT INTO yao_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nipele achalumbugwe ŵalajisye utenga ku Che Yesu achitiji, “Ambuje, mbusanga gwenu junkunnonyela akulwala!” ");
INSERT INTO yao_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Che Yesu paŵapilikene yeleyo ŵatite, “Ulwele wo ngaummulaga che Lasalo, nambo ulwele wo ukopochele kwaligongo lya ukulu wa Akunnungu, kuti Mwana jwa Akunnungu apochele ukulu kwa litala lya ulwele wo.” ");
INSERT INTO yao_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Che Yesu ŵaanonyele che Masa ni che Maliamu pamo ni che Lasalo. ");
INSERT INTO yao_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Che Yesu paŵapilikene kuti che Lasalo akulwala, ŵajonjechesye moŵa gane gaŵili ga kutama paŵaliji pala. ");
INSERT INTO yao_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nipele ŵaasalile ŵakulijiganya ŵao, “Tuujile sooni ku Yudea!” ");
INSERT INTO yao_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ŵakulijiganya ŵao ŵaasalile, “Jwakwiganya, nganagapite moŵa gamajinji Ŵayahudi ŵasachile kummulaga ni maganga, kwachichi nkusaka tuujile sooni kweleko?” ");
INSERT INTO yao_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Che Yesu ŵajanjile, “Ana ngati gapali masaa likumi ni gaŵili ga muusi? Mundu ajendaga muusi ngaakombola kulikuŵala pakuŵa akuliwona lilanguka lya pachilambo chi. ");
INSERT INTO yao_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nambo mundu ajendaga chilo chalikuŵale pakuŵa lilanguka nganilipagwa.” ");
INSERT INTO yao_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Che Yesu paŵamasile kuŵecheta yeleyo ŵaasalile, “Mbusanga jwetu che Lasalo agonile, nambo uneji chinyaule kukunjimusya.” ");
INSERT INTO yao_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ŵakulijiganya ŵao ŵansalile, “Ambuje iŵaga agonile chalame.” ");
INSERT INTO yao_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Che Yesu ŵaŵechetaga nkati chiwa chi che Lasalo, nambo ŵakulijiganya ŵao ŵaganisyaga kuti che Lasalo agonile. ");
INSERT INTO yao_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nipele Che Yesu ŵaasalile pangasisa kuti, “Che Lasalo ajasiche, ");
INSERT INTO yao_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","nambo kwa ligongo lyenu ngusengwa, pakuŵa nganima kweleko, kuti ŵanyamwe nkulupilile. Sambano tujaule kwa jwelejo.” ");
INSERT INTO yao_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Che Tomasi jwakuŵilanjikwa Maŵila, ŵaasalile achinjakwe, “Ni uweji tujaule pamo ni Jwakwiganya kuti tukawe pamo nawo!” ");
INSERT INTO yao_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nipele, Che Yesu paŵaiche kweleko, ŵachisimene chiilu chi che Lasalo chili mwilembe kwa moŵa ncheche. ");
INSERT INTO yao_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nsinda wa ku Besania waŵandichile ku Yelusalemu mpela maili siŵili. ");
INSERT INTO yao_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ŵayahudi ŵajinji ŵaiche kukwatusya ntima che Masa ni che Maliamu kwa ligongo lya chiwa cha mpwao. ");
INSERT INTO yao_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nipele che Masa paŵapilikene kuti Che Yesu akwika, ŵajawile kukwachingamila, nambo che Maliamu ŵasigele pamusi. ");
INSERT INTO yao_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Che Masa ŵaasalile Che Yesu, “Ambuje, nkaliji papapa pepa mpwangu ngakajasiche. ");
INSERT INTO yao_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nambo, namuno sambano ngumanyilila kuti chachili chose chichimwaŵende Akunnungu champe.” ");
INSERT INTO yao_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Che Yesu ŵansalile, “Mpwenu chasyuche.” ");
INSERT INTO yao_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Che Masa ŵajanjile, “Ngumanyilila kuti chachisyuka pa lyuŵa lya mbesi Akunnungu pachiŵasyusye ŵandu.” ");
INSERT INTO yao_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Che Yesu ŵansalile, “Uneji ndili usyusyo ni jungwapa ŵandu umi. Mundu jwakungulupilila uneji atamuno ajasikaga, chakole umi, ");
INSERT INTO yao_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ni mundu jwalijose jwakutama ni kungulupilila une ngajasika sooni. Uli nkugakulupilila gelego?” ");
INSERT INTO yao_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Che Masa ŵansalile Che Yesu, “Elo Ambuje! Ngukulupilila kuti ŵalakwe ni Kilisito, Mwana jwa Akunnungu, ŵakwika pa chilambo pano.” ");
INSERT INTO yao_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Che Masa paŵaŵechete yeleyo ŵajinjile nkati ni kwaŵilanga che Maliamu mlumbugwe ni kwasalila chipasipasi, “Jwakwiganya aiche ni sooni akumbilanga.” ");
INSERT INTO yao_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nombe che Maliamu paŵapilikene yeleyo ŵajimwiche kwakwanguya ni kwajaulila Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Che Yesu ŵaliji nganajinjile mu nsinda, nambo ŵaliji kulakula kuŵachingamilwe ni che Masa. ");
INSERT INTO yao_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nipele, Ŵayahudi ŵaŵaliji nkati ali nkwatulasya ntima che Maliamu, paŵambweni che Maliamu ajimwiche ni pangakaŵa akopweche paasa, ŵaakuiye. Ŵaganisisye kuti akwaula kumalembe kukulila. ");
INSERT INTO yao_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nipele, che Maliamu paŵaiche paŵaliji Che Yesu pala ni paŵambweni Che Yesu, ŵatindiŵele ni kwasalila, “Ambuje, nkaliji papapa pepa mpwangu ngakajasiche!” ");
INSERT INTO yao_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Che Yesu paŵambweni che Maliamu ali nkulila, ni Ŵayahudi ŵaŵalongene ni che Maliamu nombe akulila, Che Yesu ŵasupwiche nnope ni kupwa ntima. ");
INSERT INTO yao_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nipele ŵausisye, “Ana mummisile kwapi?” Ni ŵansalile, “Ambuje, njise kunnole.” ");
INSERT INTO yao_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Che Yesu ŵalisile. ");
INSERT INTO yao_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nipele Ŵayahudi ŵatite, “Nnole yatite pakunnonyela!” ");
INSERT INTO yao_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nambo ŵandu ŵane ŵatite, “Iŵaga ŵagalamisye meeso ga jwangalola jula, kwachichi nganakombola kuntenda che Lasalo anajasiche?” ");
INSERT INTO yao_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nipele Che Yesu akuno ali nkusupuka sooni mu ntima mwao, ŵaiche pa lilembe. Lilembe lyene lyaliji mbugu lyaliunichikwe ni liganga. ");
INSERT INTO yao_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Che Yesu ŵasalile, “Ngalambule liganga lyo!” Che Masa alumbugwe jwajasiche jo, ŵaasalile, “Ambuje, atandite kununga, pakuŵa atemi mwilembe moŵa ncheche!” ");
INSERT INTO yao_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Che Yesu ŵansalile che Masa, “Ana nganinansalila kuti mwakulupililaga chimuuwone ukulu wa Akunnungu?” ");
INSERT INTO yao_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nipele ŵagalambwile liganga lila. Che Yesu ŵalolite kwinani ni ŵatite, “Atati nguntogolela pakuŵa mmwejo nkuumbilikanila. ");
INSERT INTO yao_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","None ngumanyilila kuti nkuumbilikanila moŵa gose. Nambo ŵechete yelei ligongo lyao ŵandu ŵasongangene pelepa ŵa kuti akulupilile kuti mmwejo mundumile une!” ");
INSERT INTO yao_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Paŵamasile kuŵecheta yeleyo, ŵaŵilasile kwaliloŵe lyekulungwa, “Che Lasalo! Nkopoche paasa!” ");
INSERT INTO yao_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Juŵajasiche jo ŵakopweche paasa akuno ali ataŵikwe saanda mmakongolo ni makono ni ku meeso. Che Yesu ŵaasalile ŵandu, “Mummugule, munneche ajaule.” ");
INSERT INTO yao_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nipele Ŵayahudi ŵajinji ŵaŵaiche ku che Maliamu paŵaiweni yaitesile Che Yesu yo, ŵakulupilile. ");
INSERT INTO yao_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nambo ŵandu ŵane mwa ŵelewo ŵajawile kwa Mafalisayo ni kwasalila aila yaitesile Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Achakulu ŵambopesi ni Mafalisayo ŵausimanisye Nkungulu wekulu wa Ŵayahudi, ŵaliusisye, “Tutende chichi? Pakuŵa mundu ju akupanganya imanyisyo yejinji. ");
INSERT INTO yao_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Twannekaga ajendelechele, ŵandu wose chankulupilile, ni achakulu ŵa Chiloma chaiche kukujijonanga Nyuumba jetu ja Akunnungu ni ŵandu ŵetu ni chilambo chetu.” ");
INSERT INTO yao_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pelepo jumo jwao jwakuŵilanjikwa che Kayafa, chele chaka cho ŵaliji Jwambopesi Jwankulu, ŵaasalile, “Ŵanyamwe ngankumanyilila kose! ");
INSERT INTO yao_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ana ngankuganisya kuti ikuŵajilwa mundu jumo ŵawile ŵandu wose, kupunda chijonanjikwe chilambo chose?” ");
INSERT INTO yao_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ŵelewo nganaŵecheta yeleyo kwa kusaka kwakwe nsyene, nambo ligongo ŵaliji Jwambopesi Jwankulu chele chaka cho, ŵalondwele kuti Che Yesu chawe kwa ligongo lya ŵandu ŵa chilambo cha Ŵayahudi, ");
INSERT INTO yao_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","sooni ngaŵa kwa Ŵayahudi pe nambo kuti ŵasonganganye pamo ŵandu ŵa Akunnungu ŵaŵapwilingene mwinemwine kuti aŵe chindu chimo. ");
INSERT INTO yao_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nipele kutandilila lyuŵa lyo achakulu ŵa Ŵayahudi ŵajilene kwaulaga Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kwa yele, Che Yesu nganajendajendaga sooni kwa kulilosya pasikati ja Ŵayahudi, nambo ŵatyosile pelepo, ŵajawile kwiuto kwakuŵandikene ni lipululu, musi waukuŵilanjikwa Eflaimu. Ŵatemi kweleko pamo ni ŵakulijiganya ŵao. ");
INSERT INTO yao_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lyuŵa lyekulungwa lya Pasaka ja Ŵayahudi lyaŵandichile, ni ŵandu ŵajinji ŵakwesile kwaula ku Yelusalemu kuti aliswejesye kwaligongo lya kwapopelela Akunnungu, likanaŵe lyuŵa lyekulungwa lya Pasaka. ");
INSERT INTO yao_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nipele ŵaliji nkwasosa Che Yesu. Nombewo paŵasongangene pamo pa Nyuumba ja Akunnungu, ŵausyene, “Ana nkuganisya uli? Nkuti ngaaika ku chindimba chi?” ");
INSERT INTO yao_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Achakulu ŵambopesi ni Mafalisayo ŵalajisye kuti iŵaga kwana mundu jwakumanyi kwali Che Yesu, asale kuti ŵaakamule. ");
INSERT INTO yao_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Moŵa nsano ni limo likanaŵe lyuŵa lya chindimba cha Pasaka, Che Yesu ŵaiche ku Besania, paŵatamaga che Lasalo, mundu juŵasyuchikwe ni Che Yesu jula. ");
INSERT INTO yao_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kweleko ŵankolochesye Che Yesu chakulya cha ligulo ni che Masa ŵaliji nkwatumichila. Che Lasalo ŵaliji jumo jwao jwa ŵeŵala ŵaŵatemi pa chakulya pamo ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nipele, che Maliamu ŵajigele chuupa cha mauta gambone gakununjila ga ntengo wekulungwa gagakolochekwe ni chitela chachikuŵilanjikwa nado, ni kwapakasya Che Yesu mmakongolo mwao ni ŵagasyusile makongolo ni umbo syakwe. Nyuumba jose janunjile chambone. ");
INSERT INTO yao_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nambo che Yuda Isikaliote, jumo jwa ŵakulijiganya ŵao juchiŵagalauche Che Yesu ŵatite, ");
INSERT INTO yao_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ana ligongo chi pangagasumisya mauta go kwa ipaande selasini ya feza, ni feza syo kwapa ŵakulaga?” ");
INSERT INTO yao_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ŵaŵechete yeleyo, ngaŵa kuti ŵaakolelaga chanasa ŵakulaga, nambo ŵaŵechete yeleyo kwa ligongo ŵaliji jwakugosa mbiko. Pakuŵa ŵaliji jwawiyi ŵajiŵaga kutyochela mu mbiko jo. ");
INSERT INTO yao_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nambo Che Yesu ŵatite, “Munansausye jwankongwe ju! Munneche, atesile yelei kwa ligongo lya lyuŵa lya masiko gangu. ");
INSERT INTO yao_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ŵakulaga chaŵe pamo ni ŵanyamwe moŵa gose, nambo uneji nguŵa ni ŵanyamwe moŵa gose.” ");
INSERT INTO yao_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ŵayahudi ŵajinji ŵapilikene kuti Che Yesu ŵaliji ku Besania. Nipele, ŵaiche kweleko ngaŵa kuti kwa ligongo lya kwawona Che Yesu pe, nambo ŵasachile kwawona che Lasalo nombe, mundu juŵasyusikwe ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nipele, achakulu ŵambopesi ŵajilene kwaulaga che Lasalo nombe, ");
INSERT INTO yao_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ni kwaligongo lya iyankopochele che Lasalo, Ŵayahudi ŵajinji ŵaakanile ilongola ŵao, ni kunkulupilila Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Malaŵi jakwe, mpingo wekulungwa wa ŵandu uwaiche kuchindimba cha Pasaka ŵapilikene kuti Che Yesu ali mwitala kwika ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nipele, ŵajigele nyambi sya itela ya mitende ni ŵajawile kukwachingamila, ŵanyanyisye achitiji, “Alapikwe Akunnungu! Akole upile ŵelewo ŵakwika mu liina lya Ambuje. Akole upile mwenye jwa ku Isilaeli.” ");
INSERT INTO yao_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Che Yesu ŵampatile mwanambunda, ŵakwesile mpela iyalembekwe Mmalembelo Gamaswela, ");
INSERT INTO yao_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Munajogope ŵandu ŵankutama ku Sayuni! Nnole, Mwenye jwenu akwika, akwesile mwanambunda!” ");
INSERT INTO yao_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kundanda ŵakulijiganya ŵao nganaimanyililaga indu iyatyochele, nambo paŵasyuchile Che Yesu ni kukuswa, pelepo ŵakulijiganya ŵagakumbuchile Malembelo ga Akunnungu apala pagasasile yankati ŵelewo, ni ŵandu iŵatite pakumpanganyichisya. ");
INSERT INTO yao_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mpingo wa ŵandu ŵaŵaliji pamo ni Che Yesu paŵambilasile che Lasalo kutyochela mwilembe ni kwasyusya, ŵasalile ŵandu aila indu iyatendekwe. ");
INSERT INTO yao_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nipele, mpingo wa ŵandu ula wajawile kukwachingamila, pakuŵa wose ŵapilikene kuti Che Yesu apanganyisye chimanyisyo cho. ");
INSERT INTO yao_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nipele, Mafalisayo ŵaŵechetesyene jwine ni jwine achitiji, “Nnole! Ngatukukombola kupanganya chachili chose! Ŵandu wose ŵa pachilambo akunkuya.” ");
INSERT INTO yao_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kwaliji ni Ŵagiliki ŵampepe mwa ŵandu ŵaŵaiche ku Yelusalemu kukupopela katema ka chindimba cha Pasaka chila. ");
INSERT INTO yao_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ŵanyawo ŵajaulile che Filipo, juŵatyochele musi wa ku Besesaida chilambo cha ku Galilaya ni kwasalila, “Achimwene, tukusaka twawone Che Yesu.” ");
INSERT INTO yao_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Che Filipo ŵajawile kukwasalila che Andulea, ni wose ŵanaŵaŵili ŵajawile kukwasalila Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nambo Che Yesu ŵaajanjile, “Saa jiiche ja Mwana jwa Mundu kukuswa! ");
INSERT INTO yao_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ngunsalila isyene lusongolo lwa ngano chilusigalile kuŵa lusongolo lwa ngano pe, iŵaga nganilugwa paasi ni kuwa. Nambo lwawaga, lukumela ni kusogosya songolo sine syejinji. ");
INSERT INTO yao_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mundu jwakuunonyela umi wakwe, jwelejo chausoyasye, nambo jwakusaka kuutyosya umi wakwe kwa Kilisito mu chilambo chi, jwelejo chaugose mpaka pachapegwe umi wa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mundu jwakusaka kuundumichila, anguye, kuti papalipose pachime une ni katumetume jwangu ni pachaaŵe. Mundu jwalijose jwakuundumichila uneji, Atati ŵangu chamchimbichisye. ");
INSERT INTO yao_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Sambano Mbumu jangu jikusupuka, none ana mechete chichi? Ana mechete kuti, ‘Atati ŵangu mungulupusye ni ichitendekwe pa katema ka?’ Ngwamba, chelecho ni chinaichile, mbite pa katema ka masausyo. ");
INSERT INTO yao_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Atati, nlikusye liina lyenu.” Pelepo lyapikaniche liloŵe kutyochela kwinani lichitiji, “Nalikusisye, ni chinalikusye sooni.” ");
INSERT INTO yao_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mpingo wa ŵandu ŵaŵajimi pelepo ŵapilikene liloŵe lyo ni ŵane mwa ŵelewo ŵatite kwaliji ni kulindima ni ŵane ŵatite, “Katumetume jwa kwinani ŵaŵechete nawo!” ");
INSERT INTO yao_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nambo Che Yesu ŵaasalile, “Liloŵe limwalipikene nganiliŵa kwa ligongo lyangu une, nambo kwa ligongo lyenu. ");
INSERT INTO yao_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Keleka kali katema ka kwalamula ŵandu ŵa chilambo chi, sambano Shetani jwakutawala pa chilambo chi chaŵinjikwe. ");
INSERT INTO yao_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nambo une pachinyakulikwe pachilambo, wose chinautile kukwangu.” ");
INSERT INTO yao_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kwa kuŵecheta yeleyo ŵalosilye chiwa chachi chichawe. ");
INSERT INTO yao_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mpingo wa ŵandu ula wajanjile, “Uweji tupilikene Mmalajisyo getu kuti Kilisito chatame moŵa gose pangali mbesi. Mmwe nkuti uli, Mwana jwa Mundu aŵajilwe kunyakulwa? Ana aju Mwana jwa Mundu ju ali ŵaani?” ");
INSERT INTO yao_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Che Yesu ŵaajanjile, “Lilanguka lili pamo ni ŵanyamwe kwa moŵa kanandi. Njendeje katema lilanguka lyo lili lipali kuti chinansimane chipi, pakuŵa jwakwenda mu chipi ngakukumanyilila kwakwaula. ");
INSERT INTO yao_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Katema nli nkwete lilanguka lyo nkulupilile lilanguka lyo mmeje ŵandu ŵa lilanguka.” Paŵamasile kuŵecheta yeleyo Che Yesu ŵatyosile ni kulisisa. ");
INSERT INTO yao_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Namuno Che Yesu ŵaitendekenye imanyisyo yo mmbujo mwao, nambo ŵanyawo nganiŵakulupilila. ");
INSERT INTO yao_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nipele maloŵe gaŵaŵechete jwakulondola jwa Akunnungu che Isaya gamaliile paŵatite, “Ambuje, ana ŵaani ŵaukulupilile utenga wetu? Ni machili ga Ambuje gawoneche kwa ŵaani?” ");
INSERT INTO yao_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nambo nganakombola kukulupilila, pakuŵa che Isaya ŵasasile sooni kuti, ");
INSERT INTO yao_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Akunnungu ŵaatatesye meeso gao, kuti akalola ni meeso gao, sooni nalyungesye lunda lwao kuti akaimanyilila ni lunda lwao, akapitikwisye mitima jao kuti nalamye.” ");
INSERT INTO yao_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Che Isaya ŵaŵechete yeleyo pakuŵa ŵauweni ukulu u Che Yesu ni kunkunguluchila ngani syao. ");
INSERT INTO yao_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Natamuno yeleyo, achakulu ŵajinji ŵa Ŵayahudi ŵaakulupilile Che Yesu. Nambo kwa ligongo lya kwajogopa Mafalisayo, nganajitichisya kwakulilosya kuti akaaŵinga mu nyuumba jakupopelela. ");
INSERT INTO yao_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pakuŵa yanonyele kulapikwa ni ŵandu kupunda kulapikwa ni Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nipele, Che Yesu ŵanyanyisye achitiji, “Mundu jwakungulupilila une, ngakungulupilila une pe, nambo akwakulupilila iyoyo ŵeŵala ŵandumile une. ");
INSERT INTO yao_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jwakumona une akwawona iyoyo ŵeŵala ŵandumile une. ");
INSERT INTO yao_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Uneji iiche pachilambo meje lilanguka kuti ŵanawose ŵakungulupilila une akatama mu chipi. ");
INSERT INTO yao_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mundu jwakugapilikana maloŵe gangu nambo ngakugakamulisya, uneji ngaŵa juchinanlamule. Nguniika kukwalamula ŵandu ŵa pachilambo nambo iiche kukwakulupusya. ");
INSERT INTO yao_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jwakungana une ni kugakana maloŵe gangu jwelejo akwete jwakwalamula. Liloŵe limechete lila chilyalamule pa lyuŵa lya mbesi. ");
INSERT INTO yao_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nganiŵecheta kwa malamulo gangu nansyene, nambo Atati ŵangu ŵandumile ŵelewo ni ŵanajisye chakuŵecheta ni chakwasalila ŵandu. ");
INSERT INTO yao_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ni uneji ngumanyilila kuti malamulo gakwe gakwikanawo umi wa moŵa gose pangali mbesi. Nipele uneji nguŵecheta agala pe gaŵanajisye Atati ŵangu kuti nagaŵechete.” ");
INSERT INTO yao_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lyaliji likanaŵe lyuŵa lyekulungwa lya Pasaka. Che Yesu achimanyililaga kuti katema kao kakutyoka pachilambo chino ni kwaula kwa Atati ŵao kaiche. Moŵa gose ŵanonyele ŵandu ŵao ŵaali pachilambo, elo, ŵanonyele kwa unonyelo wangali mbesi! ");
INSERT INTO yao_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nipele Che Yesu ni ŵakulijiganya ŵao ŵatemi achilyaga chakulya cha ligulo. Jwakulinga ŵamasile kwajinjila che Yuda, mwana ju che Simoni Isikaliote ni kwapa nganisyo sya kwagalauka Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Che Yesu ŵaimanyi kuti Atati ŵao aŵisile indu yose paasi pa ulamusi wakwe, ni kuti nsyene ŵatyosile kwa Akunnungu ni akuuja kwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nipele, ŵatyosile pachakulya pala, ŵawusile likoti lyakwe ni kuŵika pambali, ŵajigele chitambaa ni kulitaŵa mchiunu. ");
INSERT INTO yao_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nipele ŵatechile meesi mu nkambo wa mwana ni kutanda kwakunda makongolo ŵakulijiganya ŵao ni kwasyula ni chitambaa chiŵalitawile mchiunu chila. ");
INSERT INTO yao_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Paŵaiche ku che Simoni Petulo, jwelejo ŵammusisye Che Yesu, “Ambuje, ana mmwe nkusaka kuungunda makongolo gangu?” ");
INSERT INTO yao_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Che Yesu ŵajanjile, “Ngankuchimanya chingupanganya sambano, nambo chinchimanye kanyuma.” ");
INSERT INTO yao_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Che Petulo ŵansalile Che Yesu, “Mmwe ngamungunda makongolo gangu kose.” Che Yesu ŵajanjile, “Iŵaga ngangugakunda makongolo genu, mmwejo ngamma jwakulijiganya jwangu.” ");
INSERT INTO yao_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Che Simoni Petulo ŵanjanjile, “Ambuje, mungunde, ngaŵa makongolo pe, nambo ni makono gangu ni ntwe wangu nombe nawo.” ");
INSERT INTO yao_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Che Yesu ŵansalile, “Jwanjoje amasile kusalala, akusachilwa kulikunda mmakongolo pe. Ŵanyamwe nsalele, ikaŵe mundu jumo pe.” ");
INSERT INTO yao_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Che Yesu ŵammanyilile ajula juchiŵagalauche, kwa ligongo lyo ŵatite, “Ŵanyamwe nsalele, ikaŵe mundu jumo pe.” ");
INSERT INTO yao_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Paŵamalisisye kwakunda makongolo gao, ŵawasile likoti lyakwe, ŵatemi sooni ni kwausya, “Ana nchimanyi chele chindesile kukwenu cho? ");
INSERT INTO yao_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ŵanyamwe nkuumilanga une Jwakwiganya ni Ambuje, nkuŵecheta uchenene, pakuŵa yeleyo ni indite pakuŵa. ");
INSERT INTO yao_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nipele iŵaga uneji jundi Ambuje ni Jwakwiganya, nankundile makongolo genu ni ŵanyamwe nkuŵajilwa nkundane makongolo jwine ni jwine. ");
INSERT INTO yao_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nampele chitagu chi, kuti ni ŵanyamwe mpanganyeje iyoyo mpela inampanganyichisye ŵanyamwe. ");
INSERT INTO yao_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ngunsalila isyene, ngapagwa kapolo jwakumpunda mmbujegwe, atamuno ngapagwa jwakutumichila jwakumpunda jwantumile. ");
INSERT INTO yao_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nipele iŵaga ngamanyi gelego, chinkole upile iŵaga chingatende.” ");
INSERT INTO yao_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ginguŵecheta ga ngaŵa kwa ŵanyamwe ŵanawose. Uneji ngwamanyilila yatite pakuŵa ŵanawose unasagwile ŵala. Nambo gakusachilwa gamalile Malembelo ga Akunnungu gagakuti, ‘Mundu jwakulya chakulya pamo ni uneji amujilile nkusa.’ ");
INSERT INTO yao_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Uneji nansalile gelega sambano gakanaŵe kopochela, kuti pachigakopochele po nkulupilile kuti, ‘Uneji ndili jwelejo.’ ");
INSERT INTO yao_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ngunsalila isyene, mundu jwalijose juchampochele junguntuma, jwelejo akumbochela ni une, ni mundu jwakumbochela uneji akumpochela jwele jwandumile une.” ");
INSERT INTO yao_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Che Yesu paŵamasile kuŵecheta yeleyo ŵasupwiche nnope mmbumu jao, ŵaŵechete pangasisa kuti, “Ngunsalila isyene, jumo jwenu chang'alauche!” ");
INSERT INTO yao_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ŵakulijiganya ŵao ŵalolegene anakombole kwimanyilila kuti ŵagambaga ŵaani. ");
INSERT INTO yao_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jumo jwa ŵakulijiganya ŵao juŵanonyelwe nnope ni Che Yesu, ŵatemi pachiŵandi ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nipele che Simoni Petulo ŵankupilile jwakulijiganya jula kunsalila, “Mwausye ana akwagamba ŵaani?” ");
INSERT INTO yao_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jwakulijiganya jo ŵammandichile nnope Che Yesu ni kwausya, “Ambuje ana ŵaani nkwagamba?” ");
INSERT INTO yao_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Che Yesu ŵajanjile, “Jwelejo ni ajula juchinampambile chipande cha nkate ni kwapa.” Nipele ŵajigele chipande cha nkate, ni kupamba mu mbaale, ŵampele che Yuda mwana ju che Simoni Isikaliote. ");
INSERT INTO yao_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Che Yuda napochelape chipande cho, ŵajinjilwe ni Shetani. Nipele Che Yesu ŵansalile, “Chinkusaka kuchipanganya, nchipanganye chitema pe!” ");
INSERT INTO yao_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nambo ngapagwa mundu jwalijose mwa aŵala ŵaŵatemi pachakulya pala juŵaimanyilile ligongo lya kwasalila yeleyo. ");
INSERT INTO yao_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pakuŵa che Yuda ŵaliji jwakugosa mbiko, ŵakulijiganya ŵane ŵaganisisye kuti Che Yesu ŵaasalile che Yuda kuti ajaule akasume indu yaikusachilwa ku chindimba cha Pasaka, pane ŵaasalile kuti akapeleganye chachili chose kwa ŵakulaga. ");
INSERT INTO yao_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nipele, che Yuda napochelape chipande cha nkate chila, ŵakopweche paasa. Ni kele katema ko kaliji chilo. ");
INSERT INTO yao_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Che Yuda paŵakopweche, Che Yesu ŵatite, “Sambano Mwana jwa Mundu apatile ukulu, ni Akunnungu nombe apatile ukulu mwa jwelejo. ");
INSERT INTO yao_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Iŵaga ukulu wa Akunnungu uwunukwiche kwa litala lya Mwana jwa Mundu, nipele Akunnungu asyene chauunukule ukulu wa Mwana jwa Mundu, nombewo chiŵakusye chitema pe.” ");
INSERT INTO yao_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Achiŵanangu, ndili ni ŵanyamwe kwa moŵa kanandi pe. Chimuusose, nambo sambano ngunsalila aila inaasalile achakulu ŵa Ŵayahudi kuti, ‘Kungwaula ŵanyamwe ngankombolanga kwika!’ ");
INSERT INTO yao_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Malajisyo ga sambano ngumpanga gati nnonyelane jwine ni jwine. Mpela indite pakunnonyela ŵanyamwe, kwanti iyoyo peyo nnonyelane jwine ni jwine. ");
INSERT INTO yao_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mwanonyelanaga jwine ni jwine, ŵandu ŵanawose chachimanyilila kuti ŵanyamwe ndi ŵakulijiganya ŵangu.” ");
INSERT INTO yao_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Che Simoni Petulo ŵambusisye Che Yesu, “Ana Ambuje nkwenda kwapi?” Ni Che Yesu ŵajanjile, “Kungwaula sambano ngankombola kuunguya, nambo chimuunguye kanyuma.” ");
INSERT INTO yao_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Che Petulo ŵansalile, “Ambuje, ligongo chi lichilepele kunkuya sambano? Ndili chile kuwa kwa ligongo lyenu!” ");
INSERT INTO yao_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Che Yesu ŵajanjile, “Ana isyene ndi chile kuwa kwa ligongo lyangu une? Isyene ngunsalila, jikanaŵe kutongola tambala chimuungane katatu!” ");
INSERT INTO yao_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Che Yesu ŵaasalile, “Nkapotekwa mmitima jenu. Mwakulupilile Akunnungu ni mungulupilile une ŵakwe. ");
INSERT INTO yao_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ku nyuumba ja Atati kwana yuumba yejinji, ngaikaŵe yeleyo, ngansalile. Sambano ngwaula kukunkolochesya liuto. ");
INSERT INTO yao_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Najaulaga ni kunkolochesya liuto, chingauje ni kunjigala, kuti pandili une, ni ŵanyamwe mbe pelepo. ");
INSERT INTO yao_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kungwaula ko nkulimanyilila litala lyakwe.” ");
INSERT INTO yao_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Che Tomasi ŵambusisye, “Ambuje, ngatukumanyilila kunkwaula ko, ana tutukombole chinauli kulimanyilila litala lyakwe?” ");
INSERT INTO yao_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Che Yesu ŵanjanjile, “Uneji ndili litala ni usyene ni umi usyene. Ngapagwa mundu jwakwaula kwa Atati pangapitila kwa uneji. ");
INSERT INTO yao_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Iŵaga nkuumanyilila uneji, Atati ŵangu nombe mwamanyi. Chitandile sambano, mwamanyi, ni sooni mwaweni.” ");
INSERT INTO yao_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Che Filipo ŵansalile, “Ambuje, ntulosye Atati, chelecho ni chitukuchisaka.” ");
INSERT INTO yao_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Che Yesu ŵansalile, “Che Filipo, ndemi ni ŵanyamwe moŵa gose ga, ngunnaŵe kuumanyilila? Mundu jwalijose jwamweni une, ŵaweni Atati. Ana kwachichi nkuti, ‘Ntulosye Atati?’ ");
INSERT INTO yao_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ana ngankukulupilila kuti uneji ndili mwa Atati, nombe Atati ali mwa uneji? Gelega maloŵe gingunsalila ga nganguŵecheta kwa ulamusi wangu nansyene, nambo Atati ŵakutama mwangu une akupanganya masengo gao. ");
INSERT INTO yao_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nkusachilwa kukulupilila pinguti, uneji ndili mwa Atati nombe Atati ali mwa uneji. Naga ngaŵa yele, nkulupilile kwa ligongo lya masengo gingugapanganya go. ");
INSERT INTO yao_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ngunsalila isyene, jwakungulupilila uneji chagapanganye masengo gingugapanganya une. Elo, chagapanganye namose masengo gamakulungwa kupunda agaga, ligongo uneji ngwaula kwa Atati. ");
INSERT INTO yao_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ni ŵanyamwe mwaŵendaga chachilichose mu liina lyangu chinampanganyichisye, kuti Atati apate ukulu kwa litala lya Mwana. ");
INSERT INTO yao_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mwamendaga chachilichose kwa ukombole wa liina lyangu, chinampanganyichisye. ");
INSERT INTO yao_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Mwanonyelaga uneji, chingajitichisye malajisyo gangu. ");
INSERT INTO yao_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Uneji chinaachondelele Atati nombewo chachimpanga Nkamusi jwine, jwelejo chatame ni ŵanyamwe moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jwelejo ni Mbumu jwa Akunnungu jwakutusalila ngani sya usyene nkati Akunnungu. Ŵandu ŵa pachilambo pano ngaakombola kumpochela jwelejo pakuŵa ngakukombola kumbona atamuno kummanyilila. Nambo ŵanyamwe nkummanyilila ligongo akutama ni ŵanyamwe ni sooni ali nkati mwenu. ");
INSERT INTO yao_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Pachindyoche nginanneka jika mpela ŵandu ŵakulekwa, nambo chinjiika sooni kukwenu. ");
INSERT INTO yao_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Gasigele moŵa kanandi ŵandu ŵa pachilambo pano ngaawona uneji sooni, nambo ŵanyamwe chimuuwone. Pakuŵa uneji ngwete umi, nombe ŵanyamwe chinkole umi. ");
INSERT INTO yao_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lyuŵa lyo pachiliiche chinchimanyilila kuti uneji ndili mwa Atati ŵangu, nombe ŵanyamwe ndi mwangu une, ni uneji ndili mwa ŵanyamwe. ");
INSERT INTO yao_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jwapochele malajisyo gangu ni kugatendekanya, jwelejo ni jwakuunonyela une. Nombe jwakuunonyela une chanonyelwe ni Atati ŵangu ni uneji chinjinnonyela ni kulimanyukusya kwa jwelejo.” ");
INSERT INTO yao_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Che Yuda, jwanganaŵa Isikaliote, ŵausisye, “Ambuje, ana chiikomboleche chinauli nlimanyisye kukwetu pe ni ngaŵa kwa ŵandu ŵa chilambo chose?” ");
INSERT INTO yao_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Che Yesu ŵanjanjile, “Mundu jwalijose anonyelaga une chagakamulisye majiganyo gangu, ni Atati ŵangu chanonyelwe ni mundu jo, une ni Atati ŵangu chituiche kukuŵika ndamo kukwakwe. ");
INSERT INTO yao_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mundu jwangakuunonyela une ngakugajitichisya majiganyo gangu. Majiganyo ginkugapilikana go ngaŵa gangu, nambo gakutyochela kwa Atati ŵandumile. ");
INSERT INTO yao_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ayiyi nansalile ndili chiŵela pamo ni ŵanyamwe, ");
INSERT INTO yao_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","nambo nkamusi jo, jwelejo Mbumu jwa Akunnungu juchalajiswe ni Atati ŵangu kwa liina lyangu, chachinjiganya indu yose ni kunkumbusya yose inansalile.” ");
INSERT INTO yao_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ngunlechelanga chitendewele, chitendewele changu ngumpanga. Ngangumpanga ŵanyamwe mpela ila ŵandu ŵa pachilambo iyakuti pakupanganya. Nkapotekwa mmitima jenu, natamuno nkajogopa. ");
INSERT INTO yao_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ana ngati mwapilikene njinsalilaga kuti, ‘Ngwaula, nipele chinjimmujilila.’ Nkaanonyele nkasangalele ligongo ngwaula kwa Atati ŵangu, pakuŵa ŵelewo ali ŵakulungwa kumbunda une. ");
INSERT INTO yao_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nansalile gelega sambano gakanaŵe kopochela, kuti pachigakopochele po nkulupilile. ");
INSERT INTO yao_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nguuŵecheta sooni maloŵe gamajinji ni ŵanyamwe, pakuŵa Shetani, chilongola jwa chilambo chi akwika. Nambo nganakola machili kukwangu, ");
INSERT INTO yao_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","nambo ŵandu ŵa pachilambo amanyilile kuti ngwanonyela Atati. Kwa ligongo lyo ngupanganya yailiyose mpela Atati iŵatite pakuulajisya. Njimanje tutyoche pelepa! ");
INSERT INTO yao_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Uneji ndili chitela chisyenesyene cha msabibu, ni Atati ŵangu ali jwakulima. ");
INSERT INTO yao_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lujambi lwaluli lose lwaluli mwangu une lwangalukusogola akulutyosya ni lujambi lwaluli lose lwalukusogola akulupogolela kuti lupunde kusogola. ");
INSERT INTO yao_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ŵanyamwe mmasile kuŵa ŵasalele kwa ligongo lya majiganyo gangu ginansalile. ");
INSERT INTO yao_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ntame nkati mwangu, ni uneji chindame nkati mwenu. Mpela ila lujambi ngalukombola kusogola isogosi iŵaga nganilusigala pa msabibu usyene, iyoyo peyo ni ŵanyamwe iŵaga ngankutama munkati mwangu chinnepele kusogola isogosi. ");
INSERT INTO yao_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Uneji ndili mpela chitela cha msabibu ni ŵanyamwe ndi nyambi. Jwakutama mwa uneji, ni uneji mwa jwelejo, jwelejo chasogole isogosi yejinji, pakuŵa ŵanyamwe jikape ngankukombola kupanganya chachili chose. ");
INSERT INTO yao_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mundu jwalijose iŵaga ngakutama mwa uneji akulandana ni lujambi lwalujasikwe kwakutalichila ni kuumula. Syele nyambi sikukumbikwa ni kutinisya pa mooto ni kutinika. ");
INSERT INTO yao_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mwatamaga mwa uneji ni maloŵe gangu gatamaga nkati mwenu, mmende chachili chose chinkuchisaka ni ŵanyamwe chimpegwe. ");
INSERT INTO yao_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mwasogolaga isogosi yejinji, Atati ŵangu chakuswe ni ŵanyamwe chimme ŵakulijiganya ŵangu. ");
INSERT INTO yao_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Uneji nannonyele ŵanyamwe mpela ila Atati ŵangu iŵanonyele une. Ntameje mu unonyelo wangu. ");
INSERT INTO yao_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mwagakamulichisyaga malajisyo gangu chintame mu unonyelo wangu, mpela ila indite pakugakamulichisya malajisyo ga Atati ŵangu ni kutama mu unonyelo wao. ");
INSERT INTO yao_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nansalile yelei yose kuti usangalale wangu utame nkati mwenu, ni usangalale wenu upunde. ");
INSERT INTO yao_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Alili lili lilajisyo lyangu: Nnonyelane jwine ni jwine mpela indite pakunnonyela ŵanyamwe. ");
INSERT INTO yao_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ngapangwa unonyelo wauli wekulungwa kuupunda unonyelo wa mundu jwakuutyosya umi wakwe kwa ligongo lya achambusanga ŵao. ");
INSERT INTO yao_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ŵanyamwe ndi achambusanga ŵangu mwatendaga chele chingunnajisya. ");
INSERT INTO yao_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Uneji ngangummilanga sooni ŵakutumichila, pakuŵa jwakutumichila ngakuchimanyilila chakupanganya mmbujegwe. Nambo uneji nammilasile ŵanyamwe achambusanga ŵangu, pakuŵa nammanyisye yose inaipilikene kutyochela kwa Atati ŵangu. ");
INSERT INTO yao_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ŵanyamwe nganimuusagula uneji, nambo uneji nansagwile ŵanyamwe ni kuntuma njaule nkasogole isogosi yejinji yaani ipanganyo yambone, ichitame moŵa gose, nipele chachili chose chachimwaŵende Atati ŵangu kwa liina lyangu chimpegwe. ");
INSERT INTO yao_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nipele, lilajisyo lyangu kukwenu lili ali, nnonyelane jwine ni jwine. ");
INSERT INTO yao_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Iŵaga ŵandu ŵa pachilambo pano akunchima ŵanyamwe, mmanyilile kuti akanaŵe kunchima ŵanyamwe, ŵanjimile uneji kaje. ");
INSERT INTO yao_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nkaliji ŵandu ŵa pachilambo, ŵandu akunnonyela ŵanyamwe mpela achinjao. Ŵanyamwe nganimma ŵandu ŵa pachilambo, nambo une nansagwile ŵanyamwe pasikati ja ŵandu ŵa pachilambo. Kwa ligongo lyo ŵandu ŵa pachilambo akunchima ŵanyamwe. ");
INSERT INTO yao_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nkumbuchile inansalile yo kuti, ‘Jwakutumichila nganaŵa jwankulungwa kumpunda mmbujegwe.’ Iŵaga ŵalagesye uneji, ni ŵanyamwe nombe chanlagasye, agakamulichisyaga majiganyo gangu, ni majiganyo genu chagakamulisye. ");
INSERT INTO yao_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nambo champanganyichisye ŵanyamwe yeleyo yose pakuŵa ŵanyamwe ndi ŵandu ŵangu, ligongo ngakwamanyilila ŵelewo ŵandumile une. ");
INSERT INTO yao_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ngungaiche ni kuŵecheta nawo, ngakaŵe ni sambi, nambo sambano ngakukombola kulichenjela kuti nganakola sambi. ");
INSERT INTO yao_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jwakunjima une, akwachima Atati ŵangu nombe. ");
INSERT INTO yao_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ngangapanganye kukwao masengo ganganagapanganye jwine, ngaakakole sambi, nambo sambano aiweni yakusimonjeka indesile, ali chiŵela kutuchima une ni Atati ŵangu. ");
INSERT INTO yao_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nambo itendekwe yele kuti gamalile maloŵe gagalembekwe Mmalajisyo gao gagakuti, ‘Ŵanjimile pangali ligongo.’ ");
INSERT INTO yao_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Chinantume nkamusi kutyochela kwa Atati ŵangu, jwele ali Mbumu jwa Akunnungu, juchasale usyene nkati Akunnungu. Chinantume kukwenu kutyochela kwa Atati kuti ansalile usyene nkati uneji. ");
INSERT INTO yao_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ni ŵanyamwe nombe chimwasalile ŵandu nkati une pakuŵa ntemi pamo ni une chitandile kundanda. ");
INSERT INTO yao_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nansalile yelei kuti nkaleka kukulupilila kwenu. ");
INSERT INTO yao_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ŵandu chamminje ŵanyamwe mmajumba gao gakupopelela. Sooni chikaiche katema kanti jwalijose juchambulaje pasikati ja ŵanyamwe chaganisye kuti akwatyosyesya Akunnungu mbopesi. ");
INSERT INTO yao_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chantende yeleyo pakuŵa ngakwamanyilila Atati natamuno ngakuumanyilila uneji. ");
INSERT INTO yao_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nambo, nansalile yelei kuti pachikaiche katema ka kukopochela nkumbuchile kuti nansalile. “Nganinansalila yelei kutyochela kundanda pakuŵa naliji pamo ni ŵanyamwe. ");
INSERT INTO yao_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nambo sambano ngwaula kwa ŵandumile une ŵala, ni ngapagwa namuno jumo jwenu jwakumusya kuti, ‘Nkwaula kwapi?’ ");
INSERT INTO yao_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pakuŵa nansalile yelei nsupwiche mmitima jenu. ");
INSERT INTO yao_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nambo ngunsalila isyene, kwa liwamba lyenu mmbaya uneji nyaule, pakuŵa iŵaga ngunyaula, nkamusi jo ngaika kukwenu. Nambo najaulaga, chingantume kukwenu. ");
INSERT INTO yao_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nombewo pachaiche, chachamanyisya ŵandu ŵa pachilambo chi kuti ngakuumanyilila usyene nkati sambi ni nkati kupanganya yambone paujo pa Akunnungu ni nkati ŵandu kulamulikwa ni Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ngakuumanyilila usyene nkati sambi ligongo nganangulupilila une. ");
INSERT INTO yao_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ngakuumanyilila usyene nkati kupanganya yambone paujo pa Akunnungu, ligongo ngwaula kwa Atati ŵangu ni ŵanyamwe ngamuuwona sooni. ");
INSERT INTO yao_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ngakuumanyilila usyene nkati ŵandu kulamulikwa ni Akunnungu, ligongo Shetani jwakutawala chilambo chi amasile kulamulikwa. ");
INSERT INTO yao_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ngwete yejinji yakunsalila, nambo sambano chinnepele kwipililila. ");
INSERT INTO yao_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nambo pachaiche Mbumu jwa Akunnungu juchansalile usyene nkati Akunnungu, chachinlongosya mu usyene wose. Ngaasala kwa ulamusi wakwe nsyene nambo chachisala ichaipilikane kutyochela kwa Atati ni kummanyisya ichiiche. ");
INSERT INTO yao_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ŵelewo changusye une ligongo chachinsalila yeila ichinansalile une. ");
INSERT INTO yao_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yose yalinayo Atati ŵangu ili yangu une, kwa ligongo lyo sasile kuti Mbumu jo chachinsalila ichinaasalile une. ");
INSERT INTO yao_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Gasigele moŵa kanandi ni ŵanyamwe ngamuuwona sooni, ni pakumala moŵa kanandi, chimuuwone sooni!” ");
INSERT INTO yao_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Pelepo ŵakulijiganya ŵao ŵampepe ŵausyene, “Malumbo gakwe chichi pakutusalila, ‘Gasigele moŵa kanandi ni ŵanyamwe ngamuuwona sooni, ni pakumala moŵa kanandi, chimuuwone sooni?’ Ni sooni ŵatite, ‘Pakuŵa ngwaula kwa Atati ŵangu!’ ” ");
INSERT INTO yao_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nipele, ŵajendelechele kuusyana, “Ana malumbo gakwe chichi pakuŵecheta, ‘Gasigele moŵa kanandi?’ Ngatukuchimanyilila chakuchigamba cho.” ");
INSERT INTO yao_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Che Yesu ŵaimanyi kuti ŵakulijiganya ŵao ŵasachile kwausya yankati yeleyo, nipele ŵaasalile, “Ana nkuusyana nkati yeila imechete kuti, ‘Gasigele moŵa kanandi ni ŵanyamwe ngamuuwona sooni, ni pakumala moŵa kanandi, chimuuwone sooni?’ ");
INSERT INTO yao_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ngunsalila isyene, ŵanyamwe chinlile ni kulila kwa malumbo, nambo ŵandu ŵa pachilambo pano chasangalale. Ŵanyamwe chinsupuche nambo kusupuka kwenu chikugalauche kusangalala. ");
INSERT INTO yao_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Katema ka kuligopola jwankongwe chikwasimana chilungusi ligongo katema kakwe ka kupeteka kaiche, nambo aligopolaga mwanache ngakukumbuchilila kupeteka kula, nambo akusangalala pakuŵa apagwile mwanache mchilambo. ");
INSERT INTO yao_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nombe ŵanyamwe sambano nkusupuka, nambo pachinambone sooni chinsangalale mmitima jenu ni sangalala jo ngapagwa jwalijose juchakombole kujityosya kukwenu. ");
INSERT INTO yao_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Lyele lyuŵa lyo ngamuusya chachili chose. Ngunsalila isyene, chachili chose chachimwaŵende Atati champe kwa liina lyangu. ");
INSERT INTO yao_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Natamuno sambano nganimmende chachili chose kwa liina lyangu. Mmende ni ŵanyamwe chinchipata kuti sangalale jenu jimalile. ");
INSERT INTO yao_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nansalile gelega kwa itagu. Nambo chijiiche ndaŵi jati ngamecheta ni ŵanyamwe sooni kwa itagu, nambo chinansalile pangasisa yankati Atati. ");
INSERT INTO yao_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lyuŵa lyo chinchiŵenda kwa liina lyangu, ni ngangunsalila kuti chisachilwe kummendela kwa Atati, ");
INSERT INTO yao_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","pakuŵa Atati asyene akunnonyela ŵanyamwe. Akunnonyela ŵanyamwe ligongo ŵanyamwe muunonyele uneji, ni kukulupilila kuti uneji natyochele kwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Uneji natyochele kwa Atati, ni kwika pachilambo, ni sambano nguchileka chilambo ni kuuja kwa Atati.” ");
INSERT INTO yao_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nipele ŵakulijiganya ŵao ŵaasalile, “Nnole sambano nkuŵecheta pangasisa, ngankuŵecheta kwa itagu. ");
INSERT INTO yao_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sambano tuimanyi kuti mmwe nkuimanyilila yose ni ngapagwa ligongo lya mundu jwalijose kummusya, chelecho ni chachikututenda tukulupilile kuti nkopochele kwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Che Yesu ŵajanjile, “Ana sambano nkukulupilila? ");
INSERT INTO yao_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nnole lyuŵa likwika, sooni liiche lyati chimpwilingane jwalijose kumangwakwe, ni kuuneka jika. Nambo uneji nguuŵa jika, pakuŵa Atati ali pamo ni une. ");
INSERT INTO yao_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nansalile gelega kuti nlumbikane ni uneji ni kukola chitendewele. Mchilambo chinsauche, nambo muusimane ntima! Uneji nachipundile chilambo!” ");
INSERT INTO yao_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Che Yesu paŵamasile kuŵecheta yeleyo, ŵalolite kwinani ni kuti, “Atati, katema kaiche. Mwape ukulu Mwana gwenu kuti Mwana gwenu nombe ampe ukulu. ");
INSERT INTO yao_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pakuŵa mwapele Mwana gwenu ulamusi pa ŵandu wose kuti ŵandu wose umwapele ŵape umi wa moŵa gose pangali mbesi. ");
INSERT INTO yao_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ni umi wa moŵa gose pangali mbesi wo ni au, ŵandu ammanyilile mmwe ŵandi Akunnungu ŵamope ŵa usyene, ni kwamanya Che Yesu Kilisito umwatumile. ");
INSERT INTO yao_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Uneji jwammale kunkusya pachilambo kwa kumalisya masengo gamwambele kuti nagapanganye. ");
INSERT INTO yao_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Atati ŵangu, sambano mumbe ukulu paujo penu, ukulu ulaula unakwete pamo nomwe, chikanaŵe gumbikwa chilambo. ");
INSERT INTO yao_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nantesile mmanyiche ni ŵandu umwambele pachilambo ŵala. Ŵanyawo ŵaliji ŵenu ni mwambele uneji kuti aŵe ŵangu, nombewo alijitichisye liloŵe lyenu. ");
INSERT INTO yao_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sambano ŵanyawo akuimanyilila kuti yose imwambele uneji ityosile kukwenu. ");
INSERT INTO yao_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pakuŵa maloŵe gamwambele uneji napele ŵanyawo, ni ŵanyawo akugakulupilila maloŵe go. Akumanyilila kwa isyene kuti natyochele kukwenu, ni sooni ajitichisye kuti mmwe ni jumwandumile une. ");
INSERT INTO yao_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ngwapopelela ŵanyawo. Ngangwapopelela ŵandu wose ŵa pachilambo, nambo ŵele umwambele wo pakuŵa ali ŵenu. ");
INSERT INTO yao_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wose ungwete ali ŵenu, ni ŵenu ali ŵangu, ni ukulu wangu uwoneche kwa litala lya ŵele umwambele wo. ");
INSERT INTO yao_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ni sambano ngwika kukwenu, uneji nguuŵa sooni pachilambo, nambo aŵaŵa alinji pachilambo. Atati ŵangu Ŵaswela mwagose kwa machili ga liina lyenu limumbele, kuti aŵe ŵamo mpela une ni mmwe ituli ŵamo. ");
INSERT INTO yao_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Panaliji pamo nawo, une naagosile kwa machili ga liina lyenu limumbele, naagosile ni ngapagwa mundu jwalijose jwasochele ikaŵe ajula juŵasagulikwe kujonasika, kuti Malembelo ga Akunnungu gamalile. ");
INSERT INTO yao_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nambo sambano ngwika kukwenu, nguŵecheta gelega pachilambo kuti ŵanyawo agumbale kusengwa kwangu mmitima jao. ");
INSERT INTO yao_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Une napele liloŵe lyenu, ni ŵandu ŵa pachilambo ŵaachimile ŵanyawo pakuŵa ŵanyawo nganaŵa ŵa pachilambo, mpela ila uneji nganima jwa pachilambo. ");
INSERT INTO yao_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nganguŵenda kuti mmwe mwatyosye mchilambo, nambo ngupopela mwagose ni Shetani jwaali jwangalumbana. ");
INSERT INTO yao_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ŵanyawo nganaŵa ŵa pachilambo pano, uneji nombe nganiŵa jwa pachilambo. ");
INSERT INTO yao_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mwatende aŵe ŵandu ŵenu ŵaswela kwa litala lya usyene, liloŵe lyenu lili usyene. ");
INSERT INTO yao_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mpela ila imwatite pakunduma une mchilambo, ni une nombe natumile ŵelewo mchilambo. ");
INSERT INTO yao_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Une ngulityosya nansyene kwaligongo lyao, kuti nombewo alityosye kusyene kukwenu. ");
INSERT INTO yao_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ngangwapopelela ŵanyawo pe, nambo ngwapopelela nombe ŵandu wose ŵachangulupilile kwaligongo lya majiganyo gao. ");
INSERT INTO yao_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ngupopela kuti wose aŵe chindu chimo. Atati, ngupopela kuti atame nkati mwetu mpela ila mmwe inkuti kutama nkati mwangu, noneji inguti kutama nkati mwenu. Ngupopela aŵe chindu chimo kuti ŵandu ŵa pachilambo akulupilile kuti mmwe ni jumundumile une. ");
INSERT INTO yao_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Noneji naapele ukulu ulaula umwambele uneji, kuti aŵeje ŵamo mpela ila uweji ituli ŵamo. ");
INSERT INTO yao_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Uneji ndame mwa ŵanyawo nombe mmwe mwa uneji. Atendekwe kuŵa ŵamo, ni ŵandu wose ŵa pachilambo amanyilile kuti mmwe ni jumwandumile ni kuti nkwanonyela ŵelewo mpela inkuti pakunonyela uneji. ");
INSERT INTO yao_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Atati, wose umumbele ngusaka aŵeje pamo ni uneji pepala pandili une kuti aulole ukulu wangu, ukulu umumbele ligongo mwanonyele uneji chilambo chikanigumbikwe. ");
INSERT INTO yao_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Atati ŵambone, namuno ŵandu ŵa pachilambo ngakummanya nambo uneji nammanyi. Ŵelewo nombe akumanyilila kuti mmwe mwandumile une. ");
INSERT INTO yao_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nantesile mmanyiche kukwao, nombe chimbundisye kutenda yeleyo kuti unonyelo undi nawo kukwangu uŵe mwa ŵanyawo, ni uneji meje mwa ŵanyawo.” ");
INSERT INTO yao_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Che Yesu paŵamasile kupopela, ŵajombweche kasulo ka Keduloni pamo ni ŵakulijiganya ŵao. Pelepo paliji ni ngunda wa mwana, nombe Che Yesu ŵajinjile mwelemo pamo ni ŵakulijiganya ŵao. ");
INSERT INTO yao_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Che Yuda, ajula juŵangalawiche Che Yesu, ŵapamanyilile pelepo ligongo kaŵili kaŵili Che Yesu ŵasimene ni ŵakulijiganya ŵao kweleko. ");
INSERT INTO yao_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nipele che Yuda ŵajawile ku wele ngunda wo, ŵajawile pamo ni mpingo wa ŵangondo ŵa Chiloma ni ŵakulindilila Nyuumba ja Akunnungu ŵaŵalajiswe ni achakulu ŵambopesi ni Mafalisayo, ali ajigele ibatali ni mimuli ni yakumenyanila. ");
INSERT INTO yao_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Che Yesu, akuno achimanyililaga ichiyasimane yose, ŵajaulile ni ŵausisye, “Ana nkwasosa ŵaani?” ");
INSERT INTO yao_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nombewo ŵajanjile, “Che Yesu jwa ku Nasaleti!” Che Yesu ŵaasalile, “Ndili une.” Che Yuda juŵangalawiche jula ŵajimi pelepo pamo ni ŵanyawo. ");
INSERT INTO yao_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nipele Che Yesu paŵaasalile, “Ndili une,” ŵanyawo ŵaujile panyuma ni kugwa. ");
INSERT INTO yao_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Che Yesu ŵausisye sooni, “Ana nkwasosa ŵaani?” Ni ŵajanjile, “Che Yesu jwa ku Nasaleti!” ");
INSERT INTO yao_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Che Yesu ŵaasalile, “Nansalile kuti ndili une. Iŵaga nkuusosa une, mwaleche ŵanyaŵa ajaule.” ");
INSERT INTO yao_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ŵaŵechete yeleyo kuti gamalile maloŵe gagatite, “Atati, nganinanjasa mundu jwalijose mwa ŵeŵala umwambele.” ");
INSERT INTO yao_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Che Simoni Petulo ŵakwete lipanga, nipele, ŵalisolomwele ni kwakata liwiwi lyao lya kundyo kapolo jwa Jwambopesi Jwankulu. Kapolo jo liina lyakwe che Maliko. ");
INSERT INTO yao_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nipele Che Yesu ŵansalile che Petulo, “Mmusye lipanga lyenu mwigonelo mwakwe. Ana nkuganisya kuti nganguŵajilwa kugapata masausyo gaasachile Atati ŵangu kuti nagapate?” ");
INSERT INTO yao_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wele mpingo wa ŵangondo ŵa Chiloma ni jwankulu jwao pamo ni ŵakulindilila ŵa Chiyahudi ŵankamwile Che Yesu ni kuntaŵa. ");
INSERT INTO yao_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ŵanjigele ni kunjausya kaje ku che Anasi. Che Anasi ŵaliji akwegwao che Kayafa juŵaliji Jwambopesi Jwankulu chele chaka cho. ");
INSERT INTO yao_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Che Kayafa ju ni jwejula juŵaasalile achakulu ŵa Ŵayahudi kuti, ikuŵajilwa mundu jumo aweje kwaligongo lya ŵandu wose. ");
INSERT INTO yao_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Che Simoni Petulo pamo ni jwakulijiganya jwine ŵakuiye Che Yesu. Jwakulijiganya jwine jo ŵamanyiche ku Jwambopesi Jwankulu, nipele ŵajinjile pamo ni Che Yesu pansana pao Jwambopesi Jwankulu. ");
INSERT INTO yao_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nambo che Petulo ŵajimi paasa, kuŵandikana ni nnango. Nipele, jwakulijiganya jwine juŵamanyiche kwa Jwambopesi Jwankulu jula ŵakopweche ni kuŵecheta nawo mwali jwakulindilila pannango, ni ŵansalile che Petulo ajinjile nkati. ");
INSERT INTO yao_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mwali jwakulindilila pannango jula ŵambusisye che Petulo, “Ana mmwejo nganimma jumo jwa ŵakulijiganya ŵa mundu jo?” Che Petulo ŵajanjile, “Ngaŵa une!” ");
INSERT INTO yao_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pakuŵa kaliji katema ka mbepo, achikapolo ni ŵakulindilila ŵakolesisye mooto ni ŵaliji nkuotanga. Che Petulo nombejo ŵajimi pamo nawo achijotelaga mooto. ");
INSERT INTO yao_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nipele Jwambopesi Jwankulu ŵambusisye Che Yesu nkati ŵakulijiganya ŵao ni sooni nkati majiganyo gao. ");
INSERT INTO yao_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Che Yesu ŵajanjile, “Mechete yose pelanga ni ŵandu wose. Moŵa gose najiganisye mmajumba ga kupopelela ni pa Nyuumba ja Akunnungu, mwakusimanilana Ŵayahudi wose, ni nganimecheta chachili chose kwakulisisa. ");
INSERT INTO yao_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ligongo chi nkumusya une? Mwausye ŵandu ŵaŵapilikene indu inaasalile. Ŵelewo akwimanyilila inaŵechete.” ");
INSERT INTO yao_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Paŵamasile kuŵecheta yeleyo jumo jwao ŵakulindilila juŵajimi pelepo ŵamputile Che Yesu lijanda achitiji, “Uli, ana yelei ni inkuti pakunjanga Jwambopesi Jwankulu?” ");
INSERT INTO yao_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Che Yesu ŵaasalile, “Iŵaga mechete yangalumbana, nlosye changalumbana cho nambo iŵaga mechete yambone ana nkuumbutila ichichi?” ");
INSERT INTO yao_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nipele che Anasi ŵanjigele Che Yesu ali ataŵikwe ni kunjausya ku che Kayafa Jwambopesi Jwankulu. ");
INSERT INTO yao_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nambo che Simoni Petulo ŵaliji pelepo alinkujotela mooto. Nipele ŵambusisye, “Ana mmwejo nombe nganimma jumo jwa ŵakulijiganya ŵao?” Che Petulo ŵakanile ni kuti, “Ngaŵa une!” ");
INSERT INTO yao_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jumo jwao achikapolo ŵa Jwambopesi Jwankulu ŵaliji pelepo. Jweleju ni nlongo njakwe mundu jula juŵankatile liwiwi ni che Petulo, ŵambusisye, “Ana uneji nganinammona mmwejo mungunda wa mwana pamo ni Che Yesu?” ");
INSERT INTO yao_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nambo che Petulo ŵakanile sooni, ni papopo tambala jatongwele. ");
INSERT INTO yao_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kundaŵi pe ŵakulindilila ŵanjigele Che Yesu kopoka mu nyuumba ji Che Kayafa, ni kunjausya mu nyuumba ja mwenye jwa Chiloma. Nambo achakulu ŵa Ŵayahudi nganajinjila nkati mwa nyuumba ja mwenye jwa Chiloma kuti aŵe ŵaswejele paujo pa Akunnungu kuti akombole kulya chakulya cha Pasaka. ");
INSERT INTO yao_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Che Pilato ŵakopweche paasa ni kwausya, “Ana kwana magambo chi kwa mundu ju?” ");
INSERT INTO yao_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nombewo ŵajanjile, “Mundu ju ngakaŵe ni magambo ngatukannyichenawo kukwenu.” ");
INSERT INTO yao_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Che Pilato ŵaasalile, “Ayaga, munjigale mwachinsyene, nkanlamule ni malajisyo genu.” Ŵayahudi ŵajanjile, “Uweji ngatukuŵajilwa kunlamula mundu jwalijose chiwa.” ");
INSERT INTO yao_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yatendekwe yeleyo kuti gamalile maloŵe ga Che Yesu gaŵasasile achilosyaga chachiwa chiwa chanti uli. ");
INSERT INTO yao_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Che Pilato ŵajinjile sooni mu nyuumba jakwe, ŵammilasile Che Yesu ni kwausya, “Ana mmwejo ni Mwenye jwa Ŵayahudi?” ");
INSERT INTO yao_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Che Yesu ŵajanjile, “Ana gele maloŵe go genu, pane ŵandu ŵane ansalile ngani jangu?” ");
INSERT INTO yao_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Che Pilato ŵajanjile, “Ana nkuganisya uneji ndili Myahudi? Ŵandu ŵenu ni achakulu ŵambopesi annyichisye mmwejo kukwangu. Ana ntesile ichichi?” ");
INSERT INTO yao_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Che Yesu ŵajanjile, “Umwenye wangu nganiuŵa wa pachilambo pano. Ikaŵe umwenye wangu uli wa pachilambo pano, ŵakunguya akatesile ngondo kuti achakulu ŵa Ŵayahudi anaangamule. Nambo sambano umwenye wangu nganiuŵa wa pachilambo pa.” ");
INSERT INTO yao_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pelepo che Pilato ŵammusisye, “Ana mmwejo ndi Mwenye?” Che Yesu ŵajanjile, “Mmwe nkuti uneji ndili Mwenye. Kwa ligongo lyo uneji mbagwile ni kwika pachilambo kukwasalila ŵandu usyene. Mundu jwalijose jwakuunonyela usyene akumbilikana.” ");
INSERT INTO yao_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Che Pilato ŵambusisye, “Usyene ni chichi?” Nipele che Pilato ŵakopweche paasa ni kwasalila Ŵayahudi, “Ngangugawona magambo gagaligose ga kunlamula mundu ju. ");
INSERT INTO yao_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nambo nkwete chisyoŵelo chakuti uneji ngungopolela jwantawe jumo katema ka Pasaka. Nipele ana nkusaka nangopolele Mwenye jwa Ŵayahudi?” ");
INSERT INTO yao_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pelepo ŵanyanyisye, “Ngaŵa, ngaŵa ajuju! Tukwasaka che Balaba!” Nombe che Balaba ŵaliji jwachiswamba. ");
INSERT INTO yao_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nipele, che Pilato ŵalamwile kuti Che Yesu ajigalikwe, aputikwe mbokola. ");
INSERT INTO yao_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ŵangondo nombe ŵakolosisye chindu mpela singwa ja miiŵa, ŵambwasisye Che Yesu mu ntwe wao ni kuntakusya mwinjilo wa chimwenye. ");
INSERT INTO yao_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ŵaliji nkwaichilila ni kuti, “Tukunkomasya, Mwenye jwa Ŵayahudi!” Nipele ŵamputile majanda. ");
INSERT INTO yao_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Che Pilato ŵakopweche sooni paasa ni kwasalila Ŵayahudi, “Nnole, ngunyikanawo paasa, mmanyilile kuti uneji nganinansimana ni magambo gagaligose ga kunlamula mundu ju.” ");
INSERT INTO yao_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nipele Che Yesu ŵakopweche paasa ali awasile chindu mpela singwa ja miiŵa mu ntwe mwao ni mwinjilo wa chimwenye. Che Pilato ŵasalile Ŵayahudi, “Nnole mundu nsyene ni aju.” ");
INSERT INTO yao_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Achakulu ŵambopesi ni ŵakulindilila Nyuumba ja Akunnungu paŵambweni Che Yesu ŵanyanyisye, “Mwaŵambe pansalaba! Mwaŵambe pansalaba!” Che Pilato ŵaasalile, “Munjigale mwachinsyene nkaŵambe pansalaba, pakuŵa uneji ngangugawona magambo gagaligose gakunlamula mundu ju.” ");
INSERT INTO yao_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ŵayahudi ŵajanjile, “Uweji tukwete malajisyo ni kwa malajisyo go ikusachilwa aweje, ligongo alitesile kuŵa Mwana jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Che Pilato paŵagapilikene maloŵe go ŵapundile kogopa. ");
INSERT INTO yao_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nipele ŵajinjile sooni mu nyuumba jakwe, ŵambusisye Che Yesu, “Ana mmweji nkutyochela kwapi?” Nambo Che Yesu ngananjanga chachili chose. ");
INSERT INTO yao_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Che Pilato ŵansalile, “Ana ngankusaka kuŵecheta ni une? Ana ngankumanyilila kuti ngwete ulamusi wa kungopola pane kummamba pansalaba?” ");
INSERT INTO yao_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Che Yesu ŵanjanjile, “Ngankakole ulamusi wauli wose kwa uneji ngankapegwe ni Akunnungu. Kwa ligongo lyo mundu jwambeleche uneji kukwenu jwelejo apundile kuŵa ni sambi syejinji.” ");
INSERT INTO yao_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chitandile pelepo, che Pilato ŵasosile litala lya kwalechelela Che Yesu. Nambo Ŵayahudi ŵanyanyisye, “Mwannechelelaga mundu ju, mmwejo nganimma mbusanga jwa mwenye jwa ku Loma, pakuŵa mundu jwalijose jwakulitenda mwenye akunkanila mwenye jwankulu jwa ku Loma!” ");
INSERT INTO yao_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nipele che Pilato paŵagapilikene maloŵe go ŵanyichenawo Che Yesu paasa, ni nsyene ŵatemi pa chitengu cha kulamula, pelepo pakuŵilanjikwa, “Luŵala lwa Maganga.” Mchiebulania, Gabata. ");
INSERT INTO yao_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lyuŵa lyaliji pamtwe, lyuŵa lyakuŵichila chile Pasaka. Che Pilato ŵaasalile Ŵayahudi, “Mwenye jwenu aju!” ");
INSERT INTO yao_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ŵanyawo ŵanyanyisye, “Mwaulaje! Mwaulaje! Mwaŵambe pansalaba!” Che Pilato ŵausisye, “Uli, nammambe mwenye jwenu?” Achakulu ŵambopesi ŵajanjile, “Uweji nganitukola mwenye jwine ikaŵe mwenye jwa ku Loma pe!” ");
INSERT INTO yao_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pelepo che Pilato ŵampeleche Che Yesu mmakono mwa ŵangondo kuti akaaŵambe pansalaba. Nipele, ŵangondo ŵanjigele Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Che Yesu ŵakopweche ali ajigele nsalaba wakwe kwaula kwiuto kwakukuŵilanjikwa, “Chikalakasa cha Ntwe”, Mchiebulania pakuŵilanjikwa Goligota. ");
INSERT INTO yao_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pelepo ni paŵaŵambile Che Yesu, ni ŵandu ŵane ŵaŵili pamo nawo, jwine kunchiji ni jwine kundyo kwao ni Che Yesu pambindikati. ");
INSERT INTO yao_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Che Pilato ŵalembile chimanyisyo ni ŵachiŵisile pachanya nsalaba. Ni chimanyisyo cho chalembekwe yelei, “Che Yesu jwa ku Nasaleti, Mwenye jwa Ŵayahudi.” ");
INSERT INTO yao_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nipele Ŵayahudi ŵajinji ŵachisyomile chimanyisyo cho pakuŵa paŵaŵambile Che Yesu pala paliji chiŵandi ni musi. Sooni chimanyisyo cho chalembekwe Mchiebulania ni Chilatini ni Chigiliki. ");
INSERT INTO yao_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nipele achakulu ŵambopesi ŵa Ŵayahudi ŵaasalile che Pilato kuti, “Nkalemba, ‘Mwenye jwa Ŵayahudi,’ nambo mundu ju ŵatite, ‘Uneji ndili Mwenye jwa Ŵayahudi.’ ” ");
INSERT INTO yao_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Che Pilato ŵaasalile, “Chilembile, nembile!” ");
INSERT INTO yao_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ŵangondo paŵamasile kwaŵamba Che Yesu pansalaba, ŵajigele iwalo yao ni ŵagaŵenye maunjili ncheche, jwangondo jwalijose liunjili limo. Sooni ŵajigele mwinjilo wakwe, wanganiukola papatotekwe, waliji chipande chimo chachiluchikwe kutyochela mwinani mpaka paasi. ");
INSERT INTO yao_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nipele ŵangondo wo ŵasalilene, “Tunapapulanye nambo tutende gudugudu kuti uwe wacheni.” Yeleyo yatendekwe kuti gamalile Malembelo ga Akunnungu gagakuti, “Ŵagaŵene iwalo yangu, ni mwinjilo wangu ŵatendele gudugudu.” Yeleyo ni yatite pakupanganya ŵangondo wo. ");
INSERT INTO yao_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pachiŵandi ni nsalaba u Che Yesu ŵajimi achikulugwe Che Yesu ni apwao achikulugwe ni che Maliamu ŵankwawo che Kileopa ni che Maliamu jwa musi wa ku Magidala. ");
INSERT INTO yao_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Che Yesu paŵambweni achikulugwe ni jwakulijiganya juŵannonyele nnope jula ajimi kuŵandikana ni pepala, ŵaasalile achikulugwe, “Amao, jwelejo ni mwanagwenu.” ");
INSERT INTO yao_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sooni ŵansalile jwakulijiganya jula kuti, “Nnole, jwelejo ni achikulu ŵenu.” Ni kutandila lyuŵa lyo jwakulijiganya jo ŵanjigele che Maliamu kuti akatame nawo kumangwakwe. ");
INSERT INTO yao_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Che Yesu ŵaimanyilile kuti yose yaliji imalile, ni Malembelo ga Akunnungu kuti gamalile, ŵatite, “Jingwete njota.” ");
INSERT INTO yao_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chapali kweleko chiŵiga chigumbele divai jakuipa. Nipele, ŵajigele chindu mpela lidodoki ni ŵatoŵele mu divai mo ni kutaŵilila pachitela chachikuŵilanjikwa esopo ni kuchiŵika pakang'wa pa Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Che Yesu paŵamasile kupegwa divai jo, ŵatite, “Yose imalile!” Ni ŵakotamisye ntwe wao ni kwasika. ");
INSERT INTO yao_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lyaliji lyuŵa lya kuŵichila chile kwa kupumulila likanaŵe Lyuŵa lya Pasaka. Nipele achakulu ŵa Ŵayahudi nganasaka iilu itaame pa nsalaba pa Lyuŵa lya Kupumulila ligongo Lyuŵa lya Kupumulila lyaliji lyuŵa lyajikape. Kwapele ŵaŵendile che Pilato apokosole makongolo ga ŵele ŵaŵaŵambikwe pa nsalaba ni kuitulusya iilu yao. ");
INSERT INTO yao_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nipele ŵangondo ŵajawile ni kugapokosola makongolo ga mundu jwaandanda ni jwaaŵili ŵaŵaliji aŵambikwe pansalaba pamo ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nambo paŵaichilile Che Yesu, ŵaiweni kuti awile, kwapele nganagapokosola makongolo gao. ");
INSERT INTO yao_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nambo jwangondo jumo ŵansomile Che Yesu mpaamba pa luŵalati, ni papopo jakopweche miasi ni meesi. ");
INSERT INTO yao_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nombe juŵaiweni yeleyo ilinkutendekwa aŵalasile umboni melepe ni ŵanyamwe nkombole kukulupilila. Ni umboni wasasile uli usyene, sooni jwelejo akumanyilila kuti akusala usyene. ");
INSERT INTO yao_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yelei yatendekwe kuti gamalile Malembelo ga Akunnungu gagakuti, “Ngapagwa liupa lyao lichilipokoswe.” ");
INSERT INTO yao_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nipele Malembelo ga Akunnungu gakusala sooni, “Chiŵalole ŵeŵala ŵaŵansomile.” ");
INSERT INTO yao_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Payamasile yeleyo che Yusufu jwa ku Alimataya, ŵaŵendile che Pilato kuti achitulusye chiilu chi Che Yesu pa nsalaba. Che Yusufu ŵaliji jwakulijiganya jwao Che Yesu, nambo nganalilosyaga, pakuŵa ŵajogopaga achakulu ŵa Ŵayahudi. Nipele che Pilato ŵajitichisye. Che Yusufu ŵajawile ni kuchijigala chiilu chi Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Che Yusufu ŵalongene ni che Nikodemu, che Nikodemu ju ni jwejula juŵajaulile Che Yesu chilo kundanda ko, ŵaiche ali ajigele mauta gakununjila yambone ga manemane kuwanganya ni ubani, mpela mbiisi saba ni ibaba iŵili. ");
INSERT INTO yao_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nipele ŵachijigele chiilu chi Che Yesu ni kuchiŵijilila mu nguo jeswela pamo ni yakununjila mpela chisyoŵelo cha Ŵayahudi katema ka kusika. ");
INSERT INTO yao_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nambo peuto paŵaŵambikwe Che Yesu pala wapali ngunda wa mwana, ni mu ngunda mo mwaliji mwana lilembe lya sambano mwakanaŵichikwa mundu jwalijose. ");
INSERT INTO yao_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nipele ligongo lyaliji lyuŵa lya Ŵayahudi kuliŵika chile kupumulila, ni sooni pakuŵa lilembe lyo lyaliji pachiŵandi, ŵachiŵisile chiilu chi Che Yesu mwelemo. ");
INSERT INTO yao_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kundaŵi pe kukanaŵe kucha, lyuŵa lyaandanda lya chijuma pakumala Lyuŵa lya kupumulila, che Maliamu jwa ku Magidala ŵajawile ku lilembe, ni ŵaliŵeni liganga lila lili lyegalambule pambali kutyochela pakwinjilila mwilembe. ");
INSERT INTO yao_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nipele, ŵautuchile ku che Simoni Petulo ni ajula jwakulijiganya jwine juŵanonyelwe nnope ni Che Yesu ni kwasalila, “Achikopwesye chiilu cha Ambuje mwilembe mula, ni sooni ngatukukumanyilila kwapi ambisile.” ");
INSERT INTO yao_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Che Petulo pamo ni jwakulijiganya jwine jula ŵajawile ku lilembe. ");
INSERT INTO yao_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wose ŵanaŵaŵili ŵautwiche nambo jwakulijiganya jwine jula jwampundile che Petulo, jwaliji jwaandanda kwika ku lilembe. ");
INSERT INTO yao_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Paŵakoteme ni kulingulila, ŵasiweni nguo syeswela pe, nambo nganajinjila. ");
INSERT INTO yao_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nipele, che Simoni Petulo nombejo ŵaiche achakuyaga, ŵajinjile mwilembe ni ŵasiweni nguo syeswela sisyaŵijilile chiilu chi Che Yesu, ");
INSERT INTO yao_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ni chiguo chiŵammijilile Che Yesu mu ntwe. Chiguo chila nganichiŵa pamo ni nguo syeswela sila, nambo chaliji chepinde ni chaliji pajika. ");
INSERT INTO yao_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pelepo jwakulijiganya jwine juŵalongolele kwika ku lilembe jula, nombejo ŵajinjile nkati, ni ŵaiweni ni kukulupilila. ");
INSERT INTO yao_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ŵaliji nganaŵe kugamanya Malembelo ga Akunnungu gagakuti Che Yesu akusachilwa asyuche. ");
INSERT INTO yao_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nipele ŵakulijiganya wo ŵausile kumangwao. ");
INSERT INTO yao_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Che Maliamu ŵajimi paasa lilembe, achililaga. Paŵalilaga, ŵakoteme achilingulilaga mwilembe mula, ");
INSERT INTO yao_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ni ŵaweni achikatumetume ŵa kwinani ŵaŵili ŵaŵawasile iwalo yeswela, atemi paŵachigoneche chiilu chi Che Yesu pala jumo kuntwe ni jwine ku makongolo. ");
INSERT INTO yao_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ni achikatumetume ŵa kwinani wo ŵambusisye, “Amao, nkulila ichichi?” Ni ŵajanjile, “Achikopwesye chiilu cha Ambuje ŵangu, ni sooni ngangukumanyilila kwapi achiŵisile!” ");
INSERT INTO yao_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nipele che Maliamu paŵamasile kuŵecheta yeleyo, ŵagalawiche panyuma ni kwaona Che Yesu ali ajimi pelepo, nambo nganaimanyilila kuti jwelejo ali Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Che Yesu ŵambusisye, “Amao, ana nkulilila ichichi? Ana nkwasosa ŵaani?” Che Maliamu akuno achiganisyaga kuti akukunguluka ni jwakuugosa ngunda wa mwana, ŵajanjile, “Achimwene, iŵaga mmwejo nchijigele chiilu chi Che Yesu, musalile kunchiŵisile ni uneji chingachijigale.” ");
INSERT INTO yao_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Che Yesu ŵansalile, “Che Maliamu!” Ni che Maliamu ŵagalawiche panyuma, ni kwasalila Mchiebulania, “Laboni!” Malumbo gakwe “Jwakwiganya.” ");
INSERT INTO yao_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Che Yesu ŵansalile, “Nkangamula, pakuŵa ngunaŵe kwaula kwa Atati. Nambo njaule kwa achalongo achinjangu nkaasalile kuti, ngwaula kwa Atati ŵangu ŵaali Atati ŵenu, Akunnungu ŵangu ŵaali Akunnungu ŵenu.” ");
INSERT INTO yao_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nipele che Maliamu jwa ku Magidala ŵajawile kukwasalila ŵakulijiganya kuti, ŵaweni Ambuje ni ŵaasalile achila chiŵasalilwe ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Lyaliji ligulo lya lyuŵa lyaandanda lya chijuma pakumala Lyuŵa lya Kupumulila. Ŵakulijiganya ŵao ŵasongangene pamo mu nyuumba ni minango jaliji jeugale ligongo lya kwajogopa achakulu ŵa Ŵayahudi. Pelepo ŵaiche Che Yesu ni kwima pasikati jao ni kwasalila, “Chitendewele kukwenu!” ");
INSERT INTO yao_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Paŵamasile kuŵecheta yeleyo, Che Yesu ŵalosisye makono gao ni luŵalati lwao. Nipele ŵakulijiganya wo ŵasengwile nnope kwawona Ambuje. ");
INSERT INTO yao_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Che Yesu ŵaasalile sooni, “Chitendewele kukwenu! Mpela ila Atati iŵandumile une, ni uneji nguntuma ŵanyamwe.” ");
INSERT INTO yao_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Paŵamasile kuŵecheta yeleyo ŵapepelele ni kwasalila, “Mumpochele Mbumu jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mwalechelesyaga ŵandu sambi syao, ŵele ŵandu chalecheleswe, ni aŵala ŵangankwalechelesya, ŵele ŵandu ngalecheleswa.” ");
INSERT INTO yao_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Che Tomasi jumo jwa ŵakulijiganya likumi ni ŵaŵili ŵala, jwakuŵilanjikwa maŵila, nganaŵa pamo ni achinjakwe paŵaiche Che Yesu. ");
INSERT INTO yao_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nipele ŵakulijiganya ŵane ŵala ŵansalile, “Twaweni Ambuje.” Che Tomasi ŵaasalile, “Chingulupilile pachinagawone maŵasi ga misumali ni kuchiŵika chala changu pa maŵasi go ni kuuŵika nkono wangu pa luŵalati lwao.” ");
INSERT INTO yao_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nipele pagapite moŵa nsano ni gatatu ŵakulijiganya wo ŵasongangene sooni nkati mula ni che Tomasi ŵaliji pamo nawo. Minango jaliji jeugale, ni Che Yesu ŵaiche ni kwima pasikati jao ni kuti, “Chitendewele kukwenu!” ");
INSERT INTO yao_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nipele Che Yesu ŵansalile che Tomasi, “Mbiche chala chenu pelepa nnole magasa gangu ni njisenawo nkono wenu mbiche pa luŵalati lwangu. Nkakola lipamba nambo nkulupilile!” ");
INSERT INTO yao_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Che Tomasi ŵajanjile, “Mmwe ndi Ambuje ŵangu ni mmwe ndi Akunnungu ŵangu!” ");
INSERT INTO yao_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Che Yesu ŵansalile, “Ana nkukulupilila ligongo muuweni? Akwete upile ŵelewo ŵakukulupilila pangamona.” ");
INSERT INTO yao_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Che Yesu ŵapanganyisye imanyisyo ine yejinji paŵaliji ni ŵakulijiganya ŵao yanganiilembekwe mchitabu chi. ");
INSERT INTO yao_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nambo ayiyi ilembekwe nkole kukulupilila kuti Che Yesu ali Kilisito Jwakuwombola, Mwana jwa Akunnungu ni kwa kunkulupilila nkole umi wausyene kwa machili ga liina lyao. ");
INSERT INTO yao_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Payamasile yeleyo, Che Yesu ŵaakopochele sooni ŵakulijiganya ŵao mungulugulu litanda lya Tibelia. Ni ŵalilosisye kwanti yelei, ");
INSERT INTO yao_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Che Simoni Petulo ni che Tomasi jwakuŵilanjikwa maŵila ni che Nasanieli jwa ku Kana ja ku Galilaya ni ŵanache ŵa che Sebedayo ni ŵakulijiganya ŵao ŵane ŵaŵili, wose ŵaliji pamo. ");
INSERT INTO yao_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Che Simoni Petulo ŵaasalile achinjakwe, “Ngwaula kukukoka somba.” Ni ŵanyawo nombe ŵansalile, “Noweji tutulongane nomwe.” Nipele ŵatyosile ni ŵakwesile ngalaŵa nambo chilo chila chose nganapatanga chachili chose. ");
INSERT INTO yao_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kundaŵi pe, Che Yesu ŵajimi mungulugulu litanda nambo ŵakulijiganya nganamanyililaga kuti ŵaliji ŵelewo. ");
INSERT INTO yao_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nipele Che Yesu ŵausisye, “Achachanda, ana nganimpate somba syasilisyose?” Ŵanyawo ŵajanjile, “Elo, nganitupate somba.” ");
INSERT INTO yao_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Che Yesu ŵaasalile, “Mponye lwau kundyo kwa ngalaŵa chimpate somba.” Nipele ŵaponyisye lwau ni sambano nganakombolanga kulukwekwelemya ligongo somba syaliji syesijinji nnope. ");
INSERT INTO yao_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pelepo jwakulijiganya juŵanonyelwe nnope ni Che Yesu jula ŵansalile che Petulo, “Ambuje ŵelewo!” Palapala che Simoni Petulo paŵapilikene kuti Ambuje, ŵatakwile mwinjilo wao ligongo ŵaliji ausile ni kuliponyela mmeesi. ");
INSERT INTO yao_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nambo ŵakulijiganya ŵane ŵala ŵaiche ku mbwani ni ngalaŵa ali nkulukwekwelemya lwau lwalugumbele somba pakuŵa nganatalichila kunsanga, mpela makongolo mia moja. ");
INSERT INTO yao_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Paŵaiche kunsanga ŵauweni mooto wa makala ni pachanya pakwe paŵichikwe somba ni nkate. ");
INSERT INTO yao_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Che Yesu ŵaasalile, “Muumbe somba simpepe simpatile sampano.” ");
INSERT INTO yao_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nipele che Simoni Petulo ŵakwesile mu ngalaŵa, ŵaluwutile kunsanga lwau lwalugumbele somba syekulungwa mia moja na hansini na tatu. Namuno somba syo syaliji syesijinji kwanti yele, lwau nganilupapuka. ");
INSERT INTO yao_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Che Yesu ŵaasalile, “Njisangane kunlye.” Nganapagwa namose jumo jwa ŵakulijiganya ŵao juŵalinjile kumbusya, “Ana mmwe ndi ŵaani,” pakuŵa ŵamanyilile kuti ali Ambuje. ");
INSERT INTO yao_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Che Yesu ŵaiche, ŵajigele nkate ni kwapa. Ŵatesile iyoyo peyo ni somba sila. ");
INSERT INTO yao_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Keleka kaliji kaatatu Che Yesu kwakopochela ŵakulijiganya ŵao paŵamasile kusyuka. ");
INSERT INTO yao_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Paŵamasile kulya, Che Yesu ŵambusisye che Simoni Petulo, “Che Simoni mwanagwao che Yohana! Ana nkuunonyela une kwapunda ŵane wa?” Nombejo ŵajanjile, “Elo, Ambuje, nnyimanyi kuti uneji ngunnonyela.” Che Yesu ŵansalile, “Nsigose ngondolo syangu sya mwana.” ");
INSERT INTO yao_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nipele ŵambusisye sooni kaaŵili, “Che Simoni mwanagwao che Yohana! Ana nkuunonyela une?” Che Petulo wajanjile, “Elo, Ambuje, nnyimanyi kuti ngunnonyela.” Che Yesu ŵansalile, “Nsigose ngondolo syangu.” ");
INSERT INTO yao_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nipele ŵambusisye sooni kaatatu kuti, “Che Simoni mwanagwao che Yohana! Ana nkuunonyela une?” Pelepo che Petulo ŵalilasiche muntima pakuŵa ŵausisye kaatatu, “Nkuunonyela?” Ni ŵajanjile, “Ambuje, mmwe nnyimanyi yose, mmwe nnyimanyi kuti uneji ngunnonyela.” Che Yesu ŵansalile, “Nsigose ngondolo syangu! ");
INSERT INTO yao_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ngunsalila isyene, pamwaliji jwanchanda, mwasyoŵelele kulitaŵa mpumbulu mwasyene ni kwaula kwakulikose kumwasachile kwaula. Nambo pachinchekulupe, chinchijongola makono genu ni mundu jwine chachintaŵa ni kunjausya kungankukusaka kwaula.” ");
INSERT INTO yao_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kwakuŵecheta yeleyo, Che Yesu ŵalosisye chiwa chichawe che Petulo ni kwapa ukulu Akunnungu. Paŵamasile kuŵecheta yeleyo ŵansalile, “Munguye.” ");
INSERT INTO yao_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pelepo che Petulo ŵagalawiche ni kumbona jwakulijiganya juŵanonyelwe nnope ni Che Yesu achakuyaga. Jwakulijiganya ju ni jwejula juŵatemi kuŵandikana nnope ni Che Yesu katema ka chakulya cha Pasaka ni kwausya Che Yesu, “Ambuje ana nduni juchangalauche?” ");
INSERT INTO yao_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Che Petulo paŵambweni jwelejo ŵambusisye Che Yesu, “Ambuje, nambi jwelejo chiyasimane ichichi?” ");
INSERT INTO yao_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Che Yesu ŵajanjile, “Nasakaga asigale mpaka pachimuje ana mmwe ikumbandichila chichi? Mmwejo munguye une.” ");
INSERT INTO yao_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nipele ngani jo jajenele kwa ŵandu ŵakunkulupilila Kilisito kuti jwakulijiganya jo ngaawa. Nambo Che Yesu nganasala kuti ngaawa, nambo ŵatite, “Nasakaga asigale mpaka pachimuje ana mmwe ikumbandichila chichi?” ");
INSERT INTO yao_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jwakulijiganya ju ni jwejula jwaŵalasile umboni wa indu yi ni kulemba. Uweji tukumanyilila kuti yasasile ili isyene. ");
INSERT INTO yao_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ipali indu ine yejinji iŵaitendekenye Che Yesu. Yeleyo ikalembekwe yose chimo chimo nguganisya kuti namose chilambo chose ngachikajenele kuŵika itabu yaikalembekwe.");
INSERT INTO yao_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Alakwe che Teofilo, mu chitabu chachilongolele nalembile yankati indu yanayose iŵaitesile Che Yesu ni iŵaijigenye chitandile kundanda kwa masengo gakwe, ");
INSERT INTO yao_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mpaka lyuŵa lila paŵajigalikwe kwinani. Nambo akanaŵe kwigalikwa kwinani ŵapele malajisyo ga ulamusi wa Mbumu jwa Akunnungu achinduna ŵaŵaasagwile ŵala. ");
INSERT INTO yao_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kwa moŵa alobaini pakumala chiwa chao, Che Yesu ŵaakopochele ŵanyawo sooni ni sooni achilosyaga kuti ŵaliji ŵajumi. Ŵanyawo ŵammweni nombejo ŵaŵechete nawo yankati Umwenye wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Katema kampepe paŵalyaga nawo ŵapele chilanga chi, “Nkasatyoka ku Yelusalemu, nambo ndindilile ntuuka walanjile Atati umwambilikene njisalaga ngani syakwe. ");
INSERT INTO yao_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Pakuŵa che Yohana ŵabatisye ni meesi, nambo pangakaŵa moŵa ŵanyamwe chinchibatiswa ni Mbumu jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nipele, achinduna paŵasongangene ni Che Yesu pamo ŵausisye, “Ambuje, ana katema kano ni pachimwauchisye sooni Ŵaisilaeli Umwenye?” ");
INSERT INTO yao_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nambo Che Yesu ŵaasalile, “Katema ni lyuŵa lya indu yo ili paasi pa ulamusi wa Atati ŵangu, ni ngaŵa masengo genu kumanyilila chiiŵe chakachi. ");
INSERT INTO yao_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nambo pachantuluchile Mbumu jwa Akunnungu chinchipochela machili ni sooni chinchiŵa ŵaumboni ŵangu musi wa Yelusalemu ni mu ilambo ya Yudea yose ni Samalia natamuno kumbesi kwa chilambo.” ");
INSERT INTO yao_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Paŵamasile kuŵecheta yeleyo, Che Yesu ŵajigalikwe kwinani akuno ŵanawose achinnolechesyaga, liunde lyaunichile ni ŵanyawo nganiŵaona sooni. ");
INSERT INTO yao_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Achinduna ŵala paŵaliji nkulolechesya kwiunde Che Yesu ali nkwaula, papopo ŵandu ŵaŵili ŵaŵawasile iwalo yeswela, ŵajimi nkuŵandikana nawo, ");
INSERT INTO yao_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ni ŵatite, “Ŵanyamwe ŵandu ŵa ku Galilaya, ana ligongo lyachi nkwima pelepa ndi nkulolechesya kwinani? Ŵele Che Yesu ŵajigalikwe kwinani kutyochela kukwenu chachiika sooni chisau intite pakwawona ali nkwaula kwinani.” ");
INSERT INTO yao_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nipele achinduna ŵala ŵaujile ku Yelusalemu kutyochela ku chikwesya cha Miseituni, chichaliji pachiŵandi ni musi wo chisau ni lwendo lwa kilomita jimo. ");
INSERT INTO yao_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Paŵaiche mmusi ŵajinjile mu chuumba cha penani chiŵatamaga, nombewo ŵaliji che Petulo ni che Yohana ni che Yakobo ni che Andulea ni che Filipo ni che Tomasi ni che Batolomayo ni che Matayo ni che Yakobo mwanagwao che Alufayo ni che Simoni jwakuŵilanjikwa Selote, ligongo ŵaliji jwakumenyanila chilambo chakwe ni che Yuda mwanagwao che Yakobo. ");
INSERT INTO yao_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ŵanawose wo pamo ni achakongwe ŵampepe pamo ni che Maliamu achikulugwe Che Yesu ni achapwakwe, ŵaliji nkusongangana pamo kupopela kwa ntima umo. ");
INSERT INTO yao_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pa moŵa go ŵajimi che Petulo pasikati ja ŵakukulupilila achinjakwe ŵaŵasongangene, waliji mpingo wa ŵandu mia moja ni ishilini. ");
INSERT INTO yao_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Che Petulo ŵatite, “Ŵakukulupilila achinjangu, yaŵajilwe Malembelo ga Akunnungu gamalile. Kalakala Mbumu jwa Akunnungu ŵaŵechete kwa kang'wa ji che Daudi, che Daudi ŵalondwele nkati che Yuda, juŵaalongwesye aŵala ŵandu ŵaŵankamwile Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Che Yuda ŵaliji jumo jwetu pakuŵa ŵasagulikwe ni Che Yesu tupanganye masengo pamo nawo.” ");
INSERT INTO yao_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ngunda wasumichikwe kwa mbiya siŵasipatile che Yuda kwa ligongo lya kusinonyela mbiya sya chigongomalo. Ni ŵagwile mwelemo, ŵapapwiche ni matuumbo gakwe gose gakopweche. ");
INSERT INTO yao_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ni ngani ja chiwa chi che Yuda jamanyiche kwa ŵanawose ŵaŵatemi ku Yelusalemu, nipele ngunda wo waŵilanjikwe mchiŵecheto chao Akelidama, malumbo gakwe, “Ngunda wa Miasi.” ");
INSERT INTO yao_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Che Petulo ŵatite, “Pakuŵa ilembekwe mu chitabu cha Sabuli kuti, ‘Pakutama pakwe paŵe masame ni anapagwe mundu juchatame mwelemo.’ Sooni ilembekwe kuti, ‘Masengo gakwe ga kwimilila atole jwine.’ ");
INSERT INTO yao_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Kwapele, ikuŵajilwa asagulikwe mundu jumo mwa ŵandu ŵaŵajesile noweji katema kose Ambuje Che Yesu paŵajendagajendaga pamo noweji, ");
INSERT INTO yao_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kutandila katema che Yohana paŵabatisyaga mpaka lyuŵa lila paŵajigalikwe Che Yesu kwinani kutyochela kukwetu. Jwelejo aŵe jwa umboni pamo ni uweji nkati kusyuka ku Che Yesu.” ");
INSERT INTO yao_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pelepo ŵakolasile meena ga ŵandu ŵaŵili, che Yusufu jwakuŵilanjikwa che Balisaba pane akuŵilanjikwa che Yusto ni jwine che Matia. ");
INSERT INTO yao_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nipele ŵapopesile achitiji, “Ambuje, alakwe ŵakujimanyilila mitima ja ŵandu wose, sambano ntulanjile jwapi mwa ŵaŵili ŵa jumunsagwile alakwe, ");
INSERT INTO yao_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kuti ajigale lipesa lya masengo ga unduna uŵaulesile che Yuda ni kwaula kuŵaŵajilwe.” ");
INSERT INTO yao_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ni ŵatesile gudugudu ni gudugudu jila jangwilile che Matia, nipele che Matia ŵaŵalanjikwe pamo ni achinduna kumi na moja ŵala. ");
INSERT INTO yao_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Palyaiche lyuŵa lya Pentekosite ŵakukulupilila wose ŵasongangene peuto pamo. ");
INSERT INTO yao_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chisisimuchile, lyapikaniche liloŵe mpela mbungo ja machili kutyochela kwinani ni lyagumbele mu nyuumba mose muŵatemi ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nipele, yakopochele indu iyaoneche mpela malamba ga mooto, yajenele ni yatusile pachanya pa kila jumo jwao. ");
INSERT INTO yao_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wose ŵagumbele Mbumu jwa Akunnungu ni ŵatandite kuŵecheta iŵecheto ineine mpela Mbumu iŵatite pakwakombolesya. ");
INSERT INTO yao_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ku Yelusalemu kula kwaliji ni Ŵayahudi, ŵandu ŵakwajitichisya Akunnungu ŵaŵakopochele mu misi jinejine pa chilambo pano. ");
INSERT INTO yao_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ŵandu paŵapilikene liloŵe lyo, mpingo wekulungwa wa ŵandu wasongangene. Ni wose ŵasimosile nnope pakuŵa mundu jwalijose ŵaapikanaga ŵanyawo achiŵechetaga chiŵecheto chakwe nsyene. ");
INSERT INTO yao_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ni wose ŵasimosile akuno achitiji, “Ana wose utukwapilikana achiŵechetaga yelei nganaŵa ŵandu ŵa ku Galilaya? ");
INSERT INTO yao_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ana iŵele uli ŵanyaŵa pakuŵecheta uweji tukupilikana jwalijose mchiŵecheto chetu twachinsyene? ");
INSERT INTO yao_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ŵampepe mwa uweji ali Ŵapalisi ni Ŵamedi ni Ŵaelami, ŵane akutamanga ku Mesopotamia ni ku Yudea ni ku Kapadokia ni ku Ponto ni ku Asia ni ");
INSERT INTO yao_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ku Filigia ni ku Pamfilia ni ku Misili ni ilambo ya ku Libia kuŵandikana ni ku Kulene, ŵane mwa uweji ali achalendo kutyochela ku Loma. ");
INSERT INTO yao_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ŵayahudi ni ŵandu ŵaŵajinjile mu dini ja Chiyahudi, ŵane ŵakopochele ku Kilete ni ku Alabia. Uweji wose tukwapikana ŵandu wo ali nkuŵecheta mu iŵecheto yetu twachinsyene yankati masengo gamakulungwa ga Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wose ŵasimosile ni kukangana akuno achiusyanaga kuti, “Chelechi malumbo gakwe chichi?” ");
INSERT INTO yao_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nambo ŵane ŵanyelwisye achitiji, “Ŵandu ŵa akolelwe.” ");
INSERT INTO yao_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nambo che Petulo ŵajimi pamo ni achinduna likumi ni jumo ŵala ni ŵatandite kwasalila ŵandu kwa kunyanyisya, “Ŵanyamwe Ŵayahudi achinjangu ni ŵandu wose ŵankutama pa Yelusalemu pano nninde nansalile ni ŵanyamwe mumbilikanile chenene maloŵe gangu. ");
INSERT INTO yao_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ŵandu ŵa nganakolelwa mpela inkuti pakuganisya, pakuŵa sambano jino jili saa tatu ja kundaŵi. ");
INSERT INTO yao_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Usyene uli awu, chachikopochele chi ni chechila chasasile che Yoeli jwakulondola jwa Akunnungu paŵatite, ");
INSERT INTO yao_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Akunnungu akuti, pa gele moŵa ga mbesi, chinaape ŵandu wose Mbumu jwangu. Achiŵana ŵenu ŵachilume ni ŵachikongwe chaachilondola, ni achachanda ŵenu chaachilola yakulola, ni achachekulu ŵenu chachisagamila. ");
INSERT INTO yao_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Elo, iyoyo achikapolo ŵangu achalume ni achakongwe, moŵa go chinaape Mbumu jwangu, nombewo chaachilondola. ");
INSERT INTO yao_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Chinjitendekanya yakusimonjeka kwiunde, ni imanyisyo pa chilambo, kuchiwe ni miasi ni mooto ni lyosi lyakutopela, ");
INSERT INTO yao_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lyuŵa chilichigalauka kuŵa chipi, ni lwesi chiluŵe lwechejeu mpela miasi, likaniiche lyelila lyuŵa lya Ambuje lyekulungwa ni lya ukulu. ");
INSERT INTO yao_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pelepo, jwalijose juchapopele kwa liina lya Ambuje chakulupuswe.’ ");
INSERT INTO yao_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ŵanyamwe Ŵaisilaeli, mpilikanichisye maloŵe ga! Akunnungu ŵammanyisye kukwenu Che Yesu jwa ku Nasaleti kwa ilosyo ni yakusimonjeka ni imanyisyo iŵaipanganyisye Akunnungu mwa ŵanyamwe kwa litala lyakwe mpela inkuti pakwimanyilila mwachinsyene. ");
INSERT INTO yao_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pakuŵa kutyochela kundanda Akunnungu asyene ŵasachile kuti ŵanyamwe mummulaje Che Yesu, ni ŵanyamwe mwammuleje kwa kwalechela ŵandu ŵangalumbana ŵaŵambe pansalaba. ");
INSERT INTO yao_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nambo Akunnungu ŵansyusisye, ni ŵankulupwisye mu ipwetesi ya chiwa pakuŵa nginikomboleka kuti chiwa chaugalile. ");
INSERT INTO yao_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pakuŵa che Daudi ŵankunguluchile Che Yesu yeleyi, ‘Naaweni Ambuje mmbujo mwangu moŵa gose, pakuŵa ali kundyo kwangu ngandinganyika. ");
INSERT INTO yao_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kwa ligongo lyo ntima wangu wasangalele, sooni nagombile ilulu yakusengwa. Chiilu changu chichitame mu chilolelo, ");
INSERT INTO yao_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","pakuŵa, alakwe Akunnungu nganjileka mbumu jangu kwiuto kwa ŵandu ŵawile, natamuno kwitichisya Jwanswela jwenu asigale ali awile mwilembe. ");
INSERT INTO yao_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Muunosisye matala ga umi, chimung'umbasye kusengwa kwa upagwe wenu!’ ");
INSERT INTO yao_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Achalongo achinjangu, ngusaka nansalile pangasisa yankati indu iyaasimene atati ŵetu che Daudi. Ŵelewo ŵajasiche ni kusichikwa, ni sooni lilembe lyakwe lili papapa pamangwetu mpaka lelo jino. ");
INSERT INTO yao_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nambo pakuŵa che Daudi ŵaliji jwakulondola jwa Akunnungu, ŵaimanyi kuti Akunnungu ŵaalumbilile ni chilumbilo kuti jumo jwa wisukulu wao chaachintenda mwenye mpela yatite kuŵa che Daudi. ");
INSERT INTO yao_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Che Daudi ŵalongolele kwiwona indu ichaitendekanye Akunnungu, nipele ŵaŵechete yankati kusyuka kwa Kilisito Chiwombosyo paŵatite, ‘Nganalekwa kwiuto kwa ŵandu ŵawile, atamuno chiilu chao nganichiola.’ ");
INSERT INTO yao_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nipele, Akunnungu ni ŵaŵansyusisye Che Yesu jo ni uweji wose tuli ŵa umboni wa indu yo. ");
INSERT INTO yao_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Che Yesu paŵakwesiswe ni kuŵichikwa ni Akunnungu kundyo kwao, ŵampochele Mbumu jwa Akunnungu kutyochela kwa Atati ŵao mpela iŵatite pakulanga. Atupele mbumu jo, chelecho ni chinkuchiwona ni kuchipilikana sambano. ");
INSERT INTO yao_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pakuŵa che Daudi nsyene nganakwela mpaka kwinani, nambo ŵatite, ‘Ambuje ŵaasalile Ambuje ŵangu, ntame apano kundyo kwangu, ");
INSERT INTO yao_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mpaka pachinaatende ŵammagongo ŵenu kuŵa chitengu cha kuŵichila makongolo genu.’ ” ");
INSERT INTO yao_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ŵandu wose ŵa ku Isilaeli akusachilwa amanyilile kwa isyene kuti jwejula Che Yesu jumwaŵambile pansalaba, Akunnungu antesile kuŵa Ambuje ni Kilisito Chiwombosyo.” ");
INSERT INTO yao_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ni ŵandu paŵapilikene yeleyo, yaapeteche mmitima ni ŵausisye Che Petulo ni achinduna ŵane ŵala kuti, “Achalongo achinjetu, ana tutende chichi?” ");
INSERT INTO yao_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Che Petulo ŵaajanjile, “Mundu jwalijose aleche sambi syakwe ni kubatiswa kwa ulamusi u Che Yesu Kilisito ni Akunnungu channechelesye sambi syenu ni kupochela chilanga cha Akunnungu chachili Mbumu jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pakuŵa chilanga chila chaliji kwa ligongo lyenu ni kwa ligongo lya achiŵana ŵenu ni kwa ligongo lya ŵandu wose ŵakutama kwakutalika, ni mundu jwali jose juchaŵilanjikwe ni Ambuje Akunnungu ŵetu.” ");
INSERT INTO yao_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwa maloŵe gamajinji che Petulo ŵaajamwiche ŵandu ni kwachondelela achitiji, “Nlikulupusye mwachinsyene mu uŵelesi wangalumbana wu.” ");
INSERT INTO yao_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ŵandu ŵajinji ŵajitichisye maloŵe gakwe ni kubatiswa. Pa lyuŵa lyo ŵandu elufu tatu ŵajonjesyeche. ");
INSERT INTO yao_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ŵelewo wose ŵapundile kujiganyikwa ni achinduna ŵa Che Yesu, ŵatemi pamo chiulongo, ŵalile chakulya cha Ambuje pamo ni kupopela. ");
INSERT INTO yao_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yakusimonjeka ni imanyisyo yejinji yatendekwe ni achinduna ŵala ni jwalijose ŵakamwilwe ni woga. ");
INSERT INTO yao_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ŵakukulupilila wose ŵatemi pamo ni iŵakwete yose ŵagaŵene. ");
INSERT INTO yao_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ni ŵasumisye indu ni ipanje yao ni kugaŵilana mbiya mundu jwalijose yaikuti pakunsoŵa. ");
INSERT INTO yao_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lyuŵa ni lyuŵa ŵachinganganaga pa Nyuumba ja Akunnungu. Ŵalyaga chakulya pamo mmajumba gao kwa kusangalala ni kwa ntima weswela. ");
INSERT INTO yao_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ŵaalapile Akunnungu ni ŵandu wose ŵaanonyele ŵandu wo. Ni lyuŵa ni lyuŵa Ambuje ŵaajonjechesye ŵandu ŵaŵaliji nkukulupuswa. ");
INSERT INTO yao_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lyuŵa limo, che Petulo ni che Yohana ŵaliji nkwaula pa Nyuumba ja Akunnungu katema ka kupopela, saa tisa ja muusi. ");
INSERT INTO yao_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Katema ko ŵandu ŵanjigalaga mundu jumo jwangajenda chipagwile. Ŵandu wo ŵambikaga mundu jo lyuŵa ni lyuŵa pannango wa Nyuumba ja Akunnungu waukuŵilanjikwa “Nnango Wakusalala,” kuti aŵende chachilichose kwa ŵaŵajinjilaga pa Nyuumba ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Paŵaweni che Petulo ni che Yohana achisakaga kwinjila pa Nyuumba ja Akunnungu, ŵaŵendile kuti ŵaape chachilichose. ");
INSERT INTO yao_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Che Petulo ni che Yohana ŵankolondolele, nombe che Petulo wo ŵansalile, “Ntulolechesye uwe.” ");
INSERT INTO yao_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nombejo ŵaalolechesye achilolelaga kuti chapochele chindu kutyochela kwa ŵanyawo. ");
INSERT INTO yao_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nambo che Petulo ŵansalile, “Nganingola mbiya namuno sahabu, nambo chingwete cho chinampe. Kwa ulamusi u Che Yesu Kilisito jwa ku Nasaleti, njime njende.” ");
INSERT INTO yao_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nipele ŵankamwile nkono wa kundyo ni kunjimika. Papopo makongolo ni malungo gakwe galimbile. ");
INSERT INTO yao_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ŵagulwiche ni kwima ni kutanda kwenda. Ni ŵajinjile pamo nawo pa Nyuumba ja Akunnungu, achendaga ni gulukaguluka akuno achalapaga Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ŵandu wose paŵammweni achendaga ni kwalapa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ŵaamanyilile kuti ali jwejula juŵatamaga pa Nnango Wakusalala wa Nyuumba ja Akunnungu ni kuŵendaŵenda, ŵatojime ni kusimonga kwa chele chichasimene. ");
INSERT INTO yao_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jwejula mundu paŵaliji nkulongana ni che Petulo ni che Yohana, ŵandu wose ŵasimosile nnope ni kutanda kuutuchila pa nsana wauli pa Nyuumba ja Akunnungu waukuŵilanjikwa, “Nsana u che Selemani.” ");
INSERT INTO yao_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nipele, che Petulo paŵaiweni yeleyi ŵaasalile, “Ŵanyamwe Ŵaisilaeli, ana ligongo lyachi nkuchisimonga chachikopochele chi? Ana ligongo chi nkutulolechesya mpela uweji ni utuntesile mundu ju ajende kwa machili getu pane nkuganisya kuti uweji tuli ŵambone paujo pa Akunnungu? ");
INSERT INTO yao_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Akunnungu ŵa achatati ŵetu che Iblahimu ni che Isaka ni che Yakobo, ŵaakusisye Che Yesu katumetume jwao. Nambo ŵanyamwe mwankamwile kuti aulajikwe ni ŵanyamwe mwankanile paujo pa che Pilato, nachiŵamuno che Pilato ŵasachile kungopola. ");
INSERT INTO yao_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jwelejo ŵaliji Jwanswela ni jwambone, nambo ŵanyamwe mwankanile, mwaŵendile che Pilato alechelelwe mundu jwine juŵaliji jwakuulaga. ");
INSERT INTO yao_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nipele, mwambuleje jwelejo juŵaliji ndandililo ja umi. Nambo Akunnungu ŵansyusisye ni uweji tuli ŵa umboni ŵa yeleyo iyakopochele. ");
INSERT INTO yao_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kwa litala lya kulikulupilila liina li Che Yesu, liina li Che Yesu limpele machili mundu ju junkummona ni kummanyilila. Kwa kulikulupilila liina li Che Yesu kuntesile mundu ju alame mpela inkuti pakumbona. ");
INSERT INTO yao_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Sambano achalongo achinjangu, naimanyi kuti ŵanyamwe ni achakulu ŵenu mwatesile yelei kwaligongo lya ungamanyilila wenu. ");
INSERT INTO yao_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nambo kwanti yeleyo Akunnungu ŵamalichisye yeila yaisasile kalakala kwa kang'wa sya ŵakulondola wose kuti Kilisito chalagaswe. ");
INSERT INTO yao_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nipele, nleche sambi syenu, mwaujilile Akunnungu kuti annechelesye sambi syenu. ");
INSERT INTO yao_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mwatendaga yeleyo chinjonjechekwe machili ga Mbumu kutyochela kwa Ambuje, nombewo chantume Che Yesu Kilisito aŵe Chiwombosyo kwa ligongo lyenu. ");
INSERT INTO yao_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ikusachilwa ŵelewo asigale kwinani ko mpaka pichikaiche katema ka Akunnungu patatende indu yose kuŵa yasambano, mpela iŵatite pakusala kalakala kwa kang'wa sya ŵakulondola ŵakwe ŵaswela. ");
INSERT INTO yao_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pakuŵa che Musa ŵatite, ‘Ambuje Akunnungu ŵenu channyichisye jwakulondola jwa Akunnungu mpela uneji, jwelejo chakopochele pasikati jenu ni ŵanyamwe nkusachilwa kumpilikanichisya yose ichansalile. ");
INSERT INTO yao_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ni mundu jwalijose jwangakumpilikanila jwakulondola jo chaŵichikwe pajika kutyochela mu ŵandu ŵa Akunnungu ni kuulajikwa.’ ");
INSERT INTO yao_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Elo, ŵakulondola ŵa Akunnungu wose, chitandile che Samweli ni ŵeŵala ŵaŵakuiye, ŵalalichile ngani sya yelei yaikukopochela mmoŵa gano. ");
INSERT INTO yao_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chilanga cha Akunnungu chatesile kwa litala lya ŵakulondola chili kwa ligongo lyenu ni ŵanyamwe ndi mu gele malangano gaatesile Akunnungu ni achambuje ŵenu, mpela iŵatite pakwasalila che Iblahimu kuti, ‘Kwa litala lya uŵelesi wenu ŵandu wose ŵa pachilambo chapegwe upile.’ ");
INSERT INTO yao_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nipele, Akunnungu ŵansyusisye katumetume jwao ni kundanda, ŵantumile kukwenu kuti ampe upile ŵanyamwe kwa kuntenda jwalijose alekangane ni yangalumbana yakwe.” ");
INSERT INTO yao_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Che Petulo ni che Yohana paŵaliji nkukunguluka ni ŵandu, ŵaiche ŵambopesi ni jwankulu jwa ŵakulindilila Nyuumba ja Akunnungu pamo ni Masadukayo. ");
INSERT INTO yao_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ŵatumbile nnope pakuŵa achinduna ŵala ŵaajiganyaga ŵandu kuti Che Yesu ŵasyuchile, chindu chachikulosya pangasisa kuti ŵandu ŵawile chachisyuka. ");
INSERT INTO yao_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nipele ŵakamwile che Petulo ni che Yohana, ŵaŵisile mu nyuumba jakutaŵilwa mpaka malaŵi jakwe, pakuŵa chaŵandichile chilo. ");
INSERT INTO yao_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nambo ŵajinji mwa ŵelewo ŵaŵapilikanile utenga u che Petulo ni che Yohana ŵakulupilile, ni ŵandu ŵaŵakulupilile ŵajonjesyeche ŵaliji mpela achalume elufu tano. ");
INSERT INTO yao_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Malaŵi jakwe, achakulu ŵa Ŵayahudi ni achachekulu ni ŵakwiganya Malajisyo ga Akunnungu gaŵapele che Musa ŵasongangene pamo ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ŵachingangene nawo che Anasi Jwambopesi Jwankulu ni che Kayafa ni che Yohana ni che Alekisanda ni ŵaneŵane ŵaŵaliji ŵa lukosyo lwao Jwambopesi Jwankulu. ");
INSERT INTO yao_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ŵaajimiche che Petulo ni che Yohana paujo pao, ŵaausisye, “Ana ŵanyamwe ntesile chelechi kwa machili chi ni kwa ulamusi wa acheni?” ");
INSERT INTO yao_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pelepo che Petulo ali aguumbele Mbumu jwa Akunnungu, ŵajanjile, “Mwanya Ilongola ŵa ŵandu ni achachekulu! ");
INSERT INTO yao_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Iŵaga lelo jino nkutuusya yankati chindu chambone chachitendekwe kwa mundu juŵaliji ngakwenda ni iyatite pakulama, ");
INSERT INTO yao_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nipele, ŵanyamwe ni ŵandu wose ŵa ku Isilaeli nkusachilwa kumanyilila kuti mundu ju akwima paujo penu lelo jino, alamiswe kwa machili ga liina li Che Yesu Kilisito jwa ku Nasaleti jumwaŵambile pansalaba, nambo Akunnungu ŵansyusisye. ");
INSERT INTO yao_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Che Yesu ni jwakungamba Mmalembelo Gamaswela gagakuti, ‘Liganga limwalikanile ŵanyamwe ŵakutaŵa, sambano lilyolyo litendekwe kuŵa liganga lyekulungwa lya nsingi wa nyuumba.’ ");
INSERT INTO yao_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jwelejo jikape ni jwakukombola kwakulupusya ŵandu, pakuŵa pachilambo pose ngapagwa liina litupegwilwe lyalitukukombola kukulupuswa nalyo.” ");
INSERT INTO yao_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Achakulu ŵa Nkungulu wo ŵaimanyilile kuti che Petulo ni che Yohana ŵaliji ŵanduŵandupe ni ŵandu ŵangasyoma, nipele ŵasimosile nnope kuwona iŵatite pakwanga pangali lipamba, ŵaimanyilile kuti ŵaliji pamo ni Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nambo paŵambweni mundu juŵalamiswe jula ali ajimi pamo nawo, nganakola chakuŵecheta. ");
INSERT INTO yao_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nipele, ŵalamwile che Petulo ni che Yohana ajaulangane paasa pa Nkungulu ni achakulu ŵa Nkungulu ŵasigalile nkati achiusyanaga achinsyene pe. ");
INSERT INTO yao_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ni ŵausyene, “Twatende ichichi ŵandu ŵa? Pakuŵa wose ŵakutama mu Yelusalemu akumanyilila chenene kuti atesile chimanyisyo chachikulungwa ni uweji ngatukukombola kukanila. ");
INSERT INTO yao_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nambo pakuti tusiŵile ikajenela nnope kwa ŵandu twajamuche kuti akaŵecheta ni mundu jwalijose kwa liina li Che Yesu.” ");
INSERT INTO yao_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nipele ilongola ŵaaŵilasile sooni nkati ni kwakanya kuti anaŵechete sooni pelanga, atamuno kwiganya mu liina li Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nambo che Petulo ni che Yohana ŵaajanjile ŵanyawo, “Iŵaga ili yambone paujo pa Akunnungu kunchimbichisyanga ŵanyamwe kupunda Akunnungu, nlamule mwachinsyene. ");
INSERT INTO yao_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pakuŵa ngatukombola kuleka kusala yeila itwiweni ni kuipilikana.” ");
INSERT INTO yao_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nipele achakulu ŵa Nkungulu wo ŵaakanyisye sooni che Petulo ni che Yohana kwa kalipa nnope ni kwagopola. Nganakombolanga kwajamuka pakuŵa ŵandu wose ŵaliji nkwakusya Akunnungu kwaligongo lya chichatendekwe cho. ");
INSERT INTO yao_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ni ajula mundu juŵalamiswe kwa litala lya chimanyisyo chi, ŵaliji jwampunde yaka alobaini. ");
INSERT INTO yao_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Papopo che Petulo ni che Yohana paŵaagopwele ŵaiche kwa achinjao ni kwaŵalanjila yose iŵasalilwe ni ŵambopesi ni achachekulu. ");
INSERT INTO yao_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ŵanyawo paŵajipilikene ngani jo, kwa ntima umo ŵaapopelele Akunnungu achitiji, “Ambuje, alakwe ni jumwagumbile kwinani ni chilambo ni bahali ni indu yose yaili mwelemo! ");
INSERT INTO yao_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mwaŵechete kwa litala lya Mbumu jwa Akunnungu kwa kang'wa ja katumetume jwenu che Daudi atati ŵetu, ‘Ana kwachichi ŵandu ŵa ilambo ine atumbile? Ana kwachichi ŵandu akuganisya yangalimate? ");
INSERT INTO yao_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mamwenye ŵa ilambo aliŵichile chile, ni achakulu asongangene pamo, kuti ŵakanile Ambuje, ni Kilisito jwao juŵansagwile.’ ");
INSERT INTO yao_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Pakuŵa, kusyene che Helode ni che Pontio Pilato ni ŵandu ŵa ku Isilaeli pamo ni ŵandu ŵangaŵa Ŵayahudi, ŵasongangene papapa pa musi, kunkanila Che Yesu katumetume jwenu jwanswela jumunsagwile aŵe Kilisito. ");
INSERT INTO yao_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Elo, ŵasongangene kukutendekanya yeila imwaisachile chitandile kundanda ikopochele kwa ulamusi wenu. ");
INSERT INTO yao_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nambo, alakwe Ambuje, nnole sambano kutujogoya kwao. Ntukombolechesye uweji achikapolo ŵenu kulalichila liloŵe lyenu pangajogopa. ");
INSERT INTO yao_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ngolosye nkono wenu mwalamye ŵandu ni kutendekanya imanyisyo ni yakusimonjeka kwa ulamusi u Che Yesu Katumetume jwenu Jwanswela.” ");
INSERT INTO yao_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Paŵamalisisye kupopela, peuto paŵasongangene pala patenganiche, ni wose ŵagumbele Mbumu jwa Akunnungu ni ŵajendelechele kulalichila liloŵe lya Akunnungu pangali lipamba. ");
INSERT INTO yao_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ni mpingo wa ŵelewo ŵakukulupilila waliji ni ntima umo ni nningwa umo. Ni nganapagwa mundu juŵatite kuti iŵakwete yo yakwe nsyene, nambo ŵagaŵene yose iŵakwete. ");
INSERT INTO yao_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kwa machili gamajinji achinduna ŵala ŵaŵalasile umboni wa kusyuka kwa Ambuje Che Yesu, nombe Akunnungu ŵapele upile weujinji. ");
INSERT INTO yao_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nganapagwa mundu jwalijose juŵasoŵilwe ni chachilichose, pakuŵa juŵakwete ngunda atamuno majumba ŵasumisyaga ni kwikanasyo mbiya, ");
INSERT INTO yao_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ni kwapa achinduna, nombewo ŵagaŵenye kwa jwalijose mpela yaikuti pakunsoŵa. ");
INSERT INTO yao_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ni kwaliji ni Mlawi, juŵapagwile ku Kupulo, liina lyakwe che Yusufu, ni achinduna ŵala ŵammilasile che Banaba, malumbo gakwe, “Mundu jwakwatulasya ŵandu mitima.” ");
INSERT INTO yao_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nombejo ŵakwete ngunda wakwe, ni ŵausumisye, ŵajigele mbiya syo ni kwapa achinduna. ");
INSERT INTO yao_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Jwapali mundu jumo jwakuŵilanjikwa che Anania pamo ni ŵankwakwe che Safila, nombewo iyoyo peyo ŵasumisye ngunda wao. ");
INSERT INTO yao_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nambo che Anania ŵasapwile mbiya siŵapatile ni kusisa akuno ŵankwakwe ali nkumanyilila yeleyo ni sine ŵapelechele achinduna ŵala. ");
INSERT INTO yao_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nipele che Petulo ŵammusisye, “Che Anania, kwaligongo chi nkunneka Shetani ajinjile mu ntima mwenu ni kuntenda munnambusye Mbumu jwa Akunnungu kwa kusisa mbiya simwapatile pamwasumisye ngunda ula? ");
INSERT INTO yao_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pamwaliji ngannasumisye, ngunda wo waliji wenu ni pamwasumisye ngunda wo, mbiya simwapatile syo syaliji syenu, nkakombwele kupanganyichisya kwa yaili yose imwaisachile. Ana kwachichi mwasachile mu ntima mwenu kuchitendekanya chelechi? Nganimunlambusya mundu nambo mwalambwisye Akunnungu!” ");
INSERT INTO yao_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Che Anania nkupilikana pe yeleyo, ŵagwile paasi ni kuwa. Ŵandu wose ŵaŵapilikene ngani jo ŵakamwilwe ni lipamba kwannope. ");
INSERT INTO yao_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Achachanda ŵajimi ni kuchiŵilijila saanda chiilu chakwe, ŵankopwesye paasa ni kwaula kukunsika. ");
INSERT INTO yao_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nti masaa gatatu ŵankwakwe ŵajinjile nkati pangaimanyilila indu iyatyochele. ");
INSERT INTO yao_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nipele che Petulo ŵambusisye, “Musalile! Ana syelesi ni mbiya syose simwapatile kwa kusumisya ngunda wenu mmwe ni ŵankwenu?” Che Safila ŵajanjile, “Elo, kwa syele mbiya syo.” ");
INSERT INTO yao_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Che Petulo ŵansalile, “Ligongo chi mmwe ni ŵankwenu mwajilene kunlinga Mbumu jwa Ambuje? Nnole! Aŵala ŵandu ŵaŵajawile kukunsika ŵankwenu, sambano ali pannango, ni sooni chanjigale nomweji ŵakwe.” ");
INSERT INTO yao_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Papopo che Safila ŵagwile paasi, mmbujo mwa che Petulo ni kuwa. Achachanda ŵala paŵajinjile ŵansimene ali awile, nipele ŵankopwesye paasa ni kunsika chiŵandika ni ŵankwakwe. ");
INSERT INTO yao_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mpingo wa ŵandu ŵakunkulupilila Kilisito wose ni ŵandu wose ŵaŵapilikene ngani jo ŵakamwilwe ni lipamba lyelikulungwa. ");
INSERT INTO yao_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Achinduna ŵala ŵapanganyisye imanyisyo yejinji ni yakusimonjeka pasikati ja ŵandu ŵala. Ŵakukulupilila ŵala ŵachinganganaga pamo pansana u che Selemani wauli pa Nyuumba ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ni nganapagwa mundu jwalijose mwa ŵangakunkulupilila Kilisito juŵalinjile kuwanganyikana nawo. Nambo ŵandu ŵane mwa ŵangakunkulupilila Kilisito wo ŵalapile ŵakukulupilila ŵala. ");
INSERT INTO yao_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Winji wa ŵandu ŵaŵakulupilile Ambuje wapundaga konjecheka nnope achalume ni achakongwe, ");
INSERT INTO yao_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","namose ŵandu ŵajausyaga ŵakulwala mwitala ni kwagoneka mu indanda ni mu igono kuti apitaga che Petulo atamuno chiwilili chao chaichilile ŵampepe ŵao. ");
INSERT INTO yao_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ŵandu ŵajinji kutyochela mmisi ja muumbali mwa Yelusalemu ŵaiche achajigalaga ŵakulwala ni ŵaali ni masoka, ni wose ŵalamiswe. ");
INSERT INTO yao_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nipele Jwambopesi Jwankulu ni achinjakwe ŵaŵaliji ŵampingo wa Masadukayo ŵaŵatemi pelepo, ŵaakolele wiu achinduna ŵala. ");
INSERT INTO yao_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nipele, ŵakamwile achinduna ni kwaŵika mu nyuumba jakutaŵilwa ja ŵandu achajinji. ");
INSERT INTO yao_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nambo chilo katumetume jwa kwinani jwa Ambuje ŵajiugwile minango ja nyuumba jakutaŵilwa ni ŵakopwesye paasa ni kwasalila, ");
INSERT INTO yao_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Njaulanje nkajime pa Nyuumba ja Akunnungu nkaasalile ŵandu maloŵe gose ga umi wa sambano wu.” ");
INSERT INTO yao_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Achinduna ŵala ŵajitichisye, kundaŵi pe ŵajinjilenje pa Nyuumba ja Akunnungu ni kutanda kwiganya. Jwambopesi Jwankulu ni achinjakwe paŵaiche, ŵaaŵilasile achachekulu ŵa Ŵaisilaeli ni kutama nawo Nkungulu wekulungwa. Ni ŵalajisye ŵandu ku nyuumba jakutaŵilwa kuti akaajigale achinduna ŵala. ");
INSERT INTO yao_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nambo ŵakulindilila ŵala paŵaiche mu nyuumba jakutaŵilwa, nganiŵasimana achinduna ŵala. Nipele ŵausile pa Nkungulu ni kwasalila ngani jo ");
INSERT INTO yao_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","achitiji, “Tujisimene nyuumba jakutaŵilwa jajiugale mbande syose ni ŵakulindilila achilindililaga mminango. Nambo patwaugwile nganitunsimana mundu jwalijose nkati.” ");
INSERT INTO yao_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jwankulu jwa ŵakulindilila Nyuumba ja Akunnungu ni Achakulu Ŵambopesi paŵapilikene ngani jo ŵajinjilwe ni lipamba, nganaimanyilila iyasimene achinduna ŵa Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nipele ŵaiche mundu ni kwasalila, “Ŵandu umwaŵisile mu nyuumba jakutaŵilwa ŵala, sambano ali pa Nyuumba ja Akunnungu achajiganyaga ŵandu.” ");
INSERT INTO yao_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nipele jwankulu jwa ŵakulindilila Nyuumba ja Akunnungu pamo ni achinjakwe ŵajawile ku Nyuumba ja Akunnungu ni kwajigala achinduna ni kwaikanawo pa Nkungulu. Nambo nganiŵakamula kwa machili pakuŵa ŵajogopaga kuti ŵandu chachaponya maganga. ");
INSERT INTO yao_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nipele ŵaajigele achinduna ni kwajimika paujo pa Nkungulu. Jwambopesi Jwankulu ŵasalile ŵanyawo, ");
INSERT INTO yao_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Twannekasisye kwamachili kuti nkajiganya sooni kwa liina lya mundu ju, ni sambano nnole chintesile, njenesye majiganyo genu mu Yelusalemu mose ni sooni nkusaka kutulalatila nkati chiwa cha mundu ju.” ");
INSERT INTO yao_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pelepo che Petulo pamo ni achinduna achinjakwe ŵajanjile, “Ikutuŵajila kwapilikanichisya Akunnungu, ngaŵa ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Akunnungu ŵa achambuje ŵetu ŵansyusisye Che Yesu ajula jumwammuleje kwa kwaŵamba pansalaba. ");
INSERT INTO yao_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jweleju ni jwejula jwakwesiswe ni Akunnungu mpaka kundyo kwao aŵe Chilongola ni Nkulupusyo kuti ŵakamuchisye Ŵaisilaeli aleche sambi syao nombejo ŵalechelesye sambi syao. ");
INSERT INTO yao_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Noweji tuli ŵaumboni ŵa yeleyo pamo ni Mbumu jwa Akunnungu ŵaŵapele aŵala ŵakwajitichisya Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mpingo wose wa Nkungulu paŵapilikene yeleyo, yachimile nnope ni ŵasachile kwaulaga achinduna ŵala. ");
INSERT INTO yao_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nambo Mfalisayo jumo jwakuŵilanjikwa che Gamalieli juŵaliji jwakwiganya jwa Malajisyo ga Akunnungu gaŵapele che Musa juŵachimbichikwe nnope ni ŵandu wose, ŵajimi paujo pa Nkungulu wa Ŵayahudi ni kulamula kwakoposya paasa achinduna ŵala kwa katema kakajipi. ");
INSERT INTO yao_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ni kuusalila mpingo wa Nkungulu ula, “Ŵanyamwe Ŵaisilaeli achinjangu, nlilolechesye mwachinsyene nkanaŵe kupanganya inkwisaka kwapanganyichisya ŵandu ŵa! ");
INSERT INTO yao_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kalakala kanandi kwakopochele mundu jumo liina lyakwe che Seuda, achilitendaga jwankulu ni ŵandu mpela mia nne ŵankuiye. Nambo jwelejo ŵaulajikwe ni ŵaŵankulupililaga wose ŵapwilingene ni ngani jakwe jamalile. ");
INSERT INTO yao_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ni sooni kanyuma mundu jo, pa moŵa ga kuŵalanga ŵandu gala ŵatyochele che Yuda jwa ku Galilaya. Nombe ju ŵaachisisye ŵandu ŵajinji ni ŵankuiye, nambo jwelejo nombe ŵaulajikwe ni ŵanawose ŵaŵankulupililaga ŵapwilingene. ");
INSERT INTO yao_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ni sambano ngunsalila ŵanyamwe, nkaatenda chachili chose ŵandu ŵa, mwaleche! Pakuŵa iŵaga liloŵe li atamuno masengo ga gali ga ŵandu, chigaweseche. ");
INSERT INTO yao_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nambo iŵaga masengo ga gakutyochela kwa Akunnungu nsyene, ngaŵa kuti chinnepele pe, nambo chimmoneche nti nkwakanila Akunnungu.” Nipele ŵandu wose ŵa Nkungulu ŵanjitichisye jwelejo. ");
INSERT INTO yao_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nipele ŵaaŵilasile achinduna ŵala munkati, ŵalamwile kuti aputikwe mbokola ni kwajamuka kuti ngasaŵecheta sooni kwa liina li Che Yesu, ni ŵaalesile ajaulangane. ");
INSERT INTO yao_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nipele achinduna ŵala ŵakopweche paasa Nkungulu ula ali nkusangalala nnope, pakuŵa Akunnungu ŵaiweni kuti aŵajilwe kujaluswa ligongo li Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ni moŵa gose ŵapundile kwiganya ni kulalichila Ngani Jambone pa Nyuumba ja Akunnungu ni mmajumba ga ŵandu kuti Che Yesu ali Kilisito. ");
INSERT INTO yao_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kanyuma, winji wa ŵakulijiganya pawaliji nkonjecheka, kwatyochele kunyinyita mwa ŵakukulupilila ŵaŵaŵechetaga Chigiliki ni aŵala ŵaŵaŵechetaga Chiebulania. Aŵala ŵaŵaŵechetaga Chigiliki ŵanyinyitaga kuti achakongwe ŵa Chigiliki ŵaŵawililwe ni achiŵankwawo, ŵaliŵalikwe kwagaŵila yakulya moŵa gose. ");
INSERT INTO yao_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nipele, achinduna likumi ni ŵaŵili ŵala ŵauŵilasile mpingo wose wa ŵakulijiganya nikuti, “Ngaikuŵajilwa kuti tuleche kulalichila liloŵe lya Akunnungu kuti tuŵeje ŵagaŵanya yakulya. ");
INSERT INTO yao_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nipele achalongo achinjetu, mwasagule ŵandu nsano ni ŵaŵili ŵakumanyika kuti ali ni umboni ŵambone, ŵaagumbale Mbumu jwa Akunnungu ni lunda ni uweji chitwape masengo go. ");
INSERT INTO yao_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nambo uweji tutulimbichile nkupopela ni kulalichila Liloŵe lya Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ngani jo jaanonyelesye mpingo wose wa ŵakukulupilila ŵala. Ni ŵaasagwile che Stefano jwagumbele chikulupi ni Mbumu jwa Akunnungu ni che Filipo ni che Plokolo ni che Nikanoli ni che Timona ni che Pamena ni che Nikolau jwa ku Antiokia juŵajinjile dini ja Chiyahudi. ");
INSERT INTO yao_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ŵaajimiche mmbujo pa achinduna, nombewo ŵapopele ni kwasajichila makono gao. ");
INSERT INTO yao_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ni liloŵe lya Akunnungu lyapundile kwenela, ni ku Yelusalemu ko winji wa ŵakukulupilila wajonjesyeche nnope, ni mpingo wekulungwa wa ŵambopesi ŵaakulupilile Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Akunnungu ŵapele che Stefano upile weujinji ni ukombole ni ŵapanganyaga imanyisyo ni yakusimonjeka yejinji pasikati ja ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nambo ŵakopochele ŵandu achisakaga kutenda makani ni che Stefano. Ŵampepe mwa ŵandu wo ŵaliji ŵa nyuumba jimo ja kupopelela jajikuŵilanjikwa, “Nyuumba ja kupopelela ŵandu Hulu,” ni ŵandu wo ŵatyochelaga ku Kulene ni ku Alekisandilia ni ŵane kutyochela ku Kilikia ni ku Asia. ");
INSERT INTO yao_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nambo Mbumu jwa Akunnungu ŵampele che Stefano lunda, kwa yele nganakombolanga kumpunda paŵaŵechetaga. ");
INSERT INTO yao_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nipele ŵaonjile ŵandu ŵampepe aŵechete kuti, “Twampilikene che Stefano achiŵechetaga maloŵe ga kwatukana che Musa ni Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kwanti yeleyi, ŵaachisisye ŵandu ni achachekulu ni ŵakwiganya Malajisyo ga Akunnungu gaŵapele che Musa. Nipele, ŵankamwile che Stefano ni kunnyikanawo paujo pa Nkungulu wekulu. ");
INSERT INTO yao_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ni ŵajimiche ŵaumboni ŵa unami ŵaŵatite, “Mundu ju ngaakuleka ng'o kujichembulusya Nyuumba ja Akunnungu jajiswela ji ni kugachembulusya Malajisyo. ");
INSERT INTO yao_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Pakuŵa twampilikene achiŵechetaga kuti jwele Che Yesu jwa ku Nasaleti chajijonanje Nyuumba ja Akunnungu ji ni kuchigalausya chisyoŵelo chiŵatupele che Musa.” ");
INSERT INTO yao_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wose ŵaŵaliji pa Nkungulu ŵankolondolele che Stefano, ŵambweni ku meeso kwakwe kuli mpela ku meeso kwa katumetume jwa kwinani. ");
INSERT INTO yao_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nipele, Jwambopesi Jwankulu ŵambusisye che Stefano, “Ana yelei ni iyoyo?” ");
INSERT INTO yao_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Che Stefano nombe ŵaajanjile, “Achalongo achinjangu ni achatati, mumbilikanile! Akunnungu Ŵakulu ŵaakopochele atati ŵetu che Iblahimu paŵaliji ku Mesopotamia akanaŵe kwaula kukutama ku Halani. ");
INSERT INTO yao_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Akunnungu ŵansalile che Iblahimu, ‘Ntyoche mchilambo chenu, mwaleche ŵandu ŵa lukosyo lwenu, njaule kuchilambo chatinganlanjile cho.’ ");
INSERT INTO yao_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nipele, che Iblahimu ŵasamile chilambo cha Ŵakalidayo, ŵajawile kukutama ku Halani. Paŵawile atatigwe, Akunnungu ŵansamisye sooni ku Halani ni kwika kukutama ku chilambo chino munkutamanga ŵanyamwe sambano jino. ");
INSERT INTO yao_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Akunnungu nganiŵapa che Iblahimu namose chipande cha chilambo chi kuti chiŵe chao, nambo ŵannanjile kwapa chilambo chi chiŵe chakwe nsyene ni cha uŵelesi wakwe, namuno katema ko ŵaliji akanaŵe kola mwanache. ");
INSERT INTO yao_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Akunnungu ŵansalile yeleyi, ‘Uŵelesi wenu chiutame mu chilambo cha chilendo, ni kweleko chachatenda achikapolo ni kwasausya yaka mia nne. ");
INSERT INTO yao_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nambo Akunnungu akuti, uneji chinjalamula ŵandu ŵa chilambo uchachatenda achikapolo. Nipele chinjakoposya mchilambo cho ni kwaikanawo apano kuti ambopele.’ ");
INSERT INTO yao_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ni Akunnungu ŵatesile malangano ni che Iblahimu ga kuumbala gaŵe chimanyisyo cha kugakunda malangano gao. Nipele che Iblahimu ŵambumbesye che Isaka mwanagwe pa lyuŵa lya ncheche ni ncheche pakumala kupagwa. Ni che Isaka nombe ŵambumbesye che Yakobo mwanagwe, ni che Yakobo nombe ŵaatesile iyoyo peyo achambuje ŵetu likumi ni ŵaŵili ŵala. ");
INSERT INTO yao_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Aŵala achambuje ŵetu ŵankolele wiu che Yusufu, ni ŵansyumisye aŵe kapolo ku chilambo cha Misili. Nambo Akunnungu ŵaliji pamo nawo, ");
INSERT INTO yao_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ni kunkulupusya mmasausyo gakwe gose. Akunnungu ŵampele che Yusufu upile ni lunda paujo pa Falao, mwenye jwa ku Misili, ni mwenye Falao ŵammisile che Yusufu kuŵa jwankulu jwa chilambo ni jwa wose ŵaali mu nyuumba jao ja chimwenye. ");
INSERT INTO yao_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nipele kwatyochele sala jajikulungwa pa chilambo cha ku Misili ni ku Kanaani, ni ŵandu ŵalasile kwannope ligongo lya sala. Achambuje ŵetu nganakombola kuchipata chakulya chachilichose. ");
INSERT INTO yao_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nipele, che Yakobo paŵapilikene kuti kwana yakulya ku Misili ko, ŵaalajisye achiŵanagwe, yaani achatati ŵetu, ajaulangane kaandanda ku Misili ko. ");
INSERT INTO yao_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ni pa ulendo wao waŵili, che Yusufu ŵalikolasile kwa achapwakwe, ni mwenye jwa ku Misili ŵalumanyilile lukosyo lu che Yusufu. ");
INSERT INTO yao_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ni che Yusufu ŵaalajisye ŵandu kukwaŵilanga che Yakobo atatigwe ni achalongo achinjakwe wose, ŵandu sabini na mbili aichanje ku Misili. ");
INSERT INTO yao_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Che Yakobo ŵajawile ku Misili, kweleko ni kuŵawilile pamo ni achambuje ŵetu. ");
INSERT INTO yao_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ni malilo gao gajigalikwe mpaka ku Shekemu, ni kusikwa mwilembe liŵasumile che Iblahimu kutyochela ku lukosyo lwa Hamoli kwa mbiya simpepe.” ");
INSERT INTO yao_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nambo pikaiche katema ka chilanga chiŵalumbile Akunnungu ku che Iblahimu, ŵandu ŵala ŵatupile ni konjecheka kwa nnope ku Misili kula. ");
INSERT INTO yao_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nipele ŵajimwiche mwenye jwine ku Misili jwanganammanyilila che Yusufu. ");
INSERT INTO yao_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mwenye jo ŵaatesile yangalumbana ni kwaonela achambuje ŵetu kwa kwakanganichisya akaajase achiŵana ŵao achanandi kuti nganasaka akole umi. ");
INSERT INTO yao_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Katema ko che Musa ŵapagwile, nombejo ŵaliji jwambone paujo pa Akunnungu. Ŵalelitwe pa musi pa atatigwe kwa miesi jitatu, ");
INSERT INTO yao_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ni paŵalepele kungosa mwakupunda mu nyuumba ŵankopwesye paasa, mwali jwa mwenye jwa ku Misili ŵanjigele ni kunlela mpela mwanagwe nsyene. ");
INSERT INTO yao_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Che Musa ŵajigenywe indu ya lunda lwa Ŵamisili nombejo ŵaliji jwakulimbangana kwa maloŵe ni masengo. ");
INSERT INTO yao_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Paŵaliji ni yaka alobaini, ntima wakwe wasachile kwajimajimila achinjakwe Ŵaisilaeli kukulola indu iŵapanganyichiswaga. ");
INSERT INTO yao_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kweleko ŵambweni Mmisili jumo achimpanganyichisyaga yangalumbana jumo jwa achalongo achinjakwe, ŵapokasisye, ni che Musa kwakwauchisya ŵambuleje Mmisili jula. ");
INSERT INTO yao_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ŵaganisisye kuti achalongo achinjakwe Ŵaisilaeli akaimanyilile kuti Akunnungu akuntuma jwelejo kwakulupusya, nambo nganaimanyilila. ");
INSERT INTO yao_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Malaŵi jakwe, ŵaweni Ŵaisilaeli ŵaŵili ali nkuputana achinsyene pe, ni ŵalinjile kwajilanya achitiji; ‘Ŵanyamwe ndi ŵa lukosyo lumo, ligongo chi nkusaka kuulasyana achinsyene pe?’ ");
INSERT INTO yao_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nambo jwejula juŵamputaga njakwe jula ŵantutile pambali che Musa ni kunsalila, ‘Ana ŵaani ŵambisile mmwejo kuŵa chilongola ni jwakulamula pa uweji? ");
INSERT INTO yao_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ana nkusaka kumulaga mpela imwatite pakummulaga Mmisili jula liiso?’ ");
INSERT INTO yao_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Che Musa paŵagapilikene maloŵe go ŵatisile, ŵatemi ku chilambo cha ku Midiani nti jwannendo, ni kweleko ŵaŵelechele ŵanache ŵaŵili ŵachilume. ");
INSERT INTO yao_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Payaichile yaka alobaini, katumetume jwa kwinani jwa Ambuje jwankopochele che Musa pa chisukutu chichakolelaga mooto kwipululu kula pachiŵandi ni Litumbi lya Sinai. ");
INSERT INTO yao_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Che Musa ŵachisimonjile nnope chichaoneche cho, ŵasejelele pachiŵandi kukulolechesya uchenene, nambo ŵapilikene liloŵe lya Ambuje lilinkuti, ");
INSERT INTO yao_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Uneji ndili Akunnungu ŵa achambuje ŵenu, Akunnungu ŵa che Iblahimu ni ŵa che Isaka ni ŵa che Yakobo!’ Che Musa ŵatetemele kwa lipamba ni nganapunda kulolechesya sooni. ");
INSERT INTO yao_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ambuje ŵansalile, ‘Mmuule italawanda yenu pakuŵa pelepo panjimi pali papaswela. ");
INSERT INTO yao_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Naiweni yangalumbana yakwapanganyichisya ŵandu ŵangu ŵakutama ku Misili. Mbilikene kulilasika kwao none ndulwiche kukwakulupusya, ni sambano chinantume ku Misili.’ ");
INSERT INTO yao_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Che Musa aju ni jwejula juŵankanile Ŵaisilaeli paŵansalile, ‘Ana ŵaani ŵambisile mmwejo kuŵa chilongola ni jwakulamula pa uweji?’ Kwa litala lya julajula katumetume jwa kwinani juŵankopochele che Musa mu chisukutu chichakolelaga mooto, Akunnungu ŵantumile che Musa wo aŵe chilongola ni nkulupusyo. ");
INSERT INTO yao_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jwelejo ni juŵaalongwesye ŵandu akopoche ku Misili kwa kupanganya imanyisyo ni yakusimonjeka mu chilambo cha ku Misili ni mu bahali ja Shamu ni mwipululu, kwa yaka alobaini. ");
INSERT INTO yao_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Che Musa ni juŵaasalile Ŵaisilaeli, ‘Akunnungu chanjimuchisye jwakulondola mpela uneji kutyochela mwa achalongo achinjenu mwachinsyene.’ ");
INSERT INTO yao_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ŵaisilaeli paŵasongangene mwipululu mula, che Musa ŵaliji kweleko pamo ni achambuje ŵetu ni katumetume jwa kwinani juŵaŵechete najo mu Litumbi lya Sinai. Jweleju ni juŵagapochele maloŵe gagakwikanawo umi kutupa uweji. ");
INSERT INTO yao_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nambo achambuje ŵetu nganasakanga kumpilikanila che Musa, ŵantutile pambali ni ŵasachile mmitima jao kuujila ku Misili. ");
INSERT INTO yao_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ŵansalile che Haluni, ‘Ntupanganyichisye achiminungu jati tujipopelele ni jitulongosye mwitala, pakuŵa che Musa juŵatulongwesye kopoka ku Misili ngatukuchimanyilila chichasimene!’ ");
INSERT INTO yao_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Katema ko ŵapanganyisye chinyago cha ng'ombe ja mwana, ni ŵatasile mbopesi kwa chinyago ni kuchijangalila chindu chichaliji masengo ga makono gao achinsyene. ");
INSERT INTO yao_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nambo Akunnungu ŵatyosile pa ŵanyawo, ŵaalesile asipopele ndondwa sya kwiunde, mpela yaitite pakulembekwa mchitabu cha ŵakulondola ŵa Akunnungu, ‘Ŵanyamwe ŵandu ŵa chilambo cha ku Isilaeli! Ana ŵanyamwe mwambelechele inyama yesinje ni sadaka kwa yaka alobaini mwipululu mula? ");
INSERT INTO yao_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ŵanyamwe mwalijigele lisakasa lya nnungu jwenu Moleki, ni chinyago cha ndondwa ja nnungu jwenu Lefani. Inyago imwaipanganyisye ni iyoyo imwaipopele. Kwa ligongo lyo chinansamichisye ku ukapolo kwakutalika kupita ku Babeli!’ ");
INSERT INTO yao_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Achambuje ŵenu ŵakwete lisakasa lya umboni lyalikulosya kuti Akunnungu ali mwele mwipululu. Lisakasa lila lyakolochekwe mpela Akunnungu iŵatite pakwasalila che Musa akolosye, chisau ni achila chiŵachiweni. ");
INSERT INTO yao_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nipele achambuje ŵetu ŵapochelangene achinsyene pe mpaka katema ka che Yoshua, paŵachipatile chilambo chi kutyochela kwa ŵandu ŵaŵaŵinjikwe ni Akunnungu paujo pao. Lyatemi pelepo mpaka katema ka che Daudi. ");
INSERT INTO yao_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Che Daudi ŵanonyelwe ni Akunnungu nombe che Daudi ŵaŵendile Akunnungu ŵaataŵile nyuumba ŵele ŵaali Akunnungu ŵa che Yakobo. ");
INSERT INTO yao_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nambo che Selemani ni juŵantaŵile Akunnungu nyuumba.” ");
INSERT INTO yao_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Natamuno yeleyo, Akumanani ngakutama mmajumba gagataŵikwe ni ŵandu, mpela yakuti jwakulondola jwa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ambuje akuti, ‘Kwinani kuli chitengu changu cha umwenye ni chilambo chili pakuŵichila makongolo gangu. Nyuumba jati uli jichimundaŵile une, ni liuto chi pachimbumulile? ");
INSERT INTO yao_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ana ngaŵa uneji jumbanganyisye yelei yose?’ ” ");
INSERT INTO yao_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Che Stefano ŵapundile kuŵecheta, “Ŵakukanila achakulungwa ŵanyamwe! Mitima ni mawiwi genu gali mpela ga ŵandu ŵangakwamanyilila Akunnungu. Ŵanyamwe nli mpela achambuje ŵenu, moŵa gose nkukanilana ni Mbumu jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ana jwapi mwa ŵakulondola jwangananlagasya achambuje ŵenu? Ŵaauleje ŵelewo ŵaŵalajiswe kalakala ni Akunnungu asale kwika kwa ajula jwakupanganya yaili yambone. Ni sambano ŵanyamwe mungalawiche ni kumbulaga. ");
INSERT INTO yao_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ŵanyamwe mwagapochele Malajisyo ga Akunnungu gagaiche kukwenu ni achikatumetume ŵa kwinani, nambo nganingakamulichisya.” ");
INSERT INTO yao_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Achakulu ŵa Nkungulu paŵagapilikene maloŵe go, yachimile nnope ni kuchilimya meeno. ");
INSERT INTO yao_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nambo che Stefano ali aguumbele Mbumu jwa Akunnungu, ŵalolite kwinani, ŵauweni ukulu wa Akunnungu ni Che Yesu ali ajimi kundyo kwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ni ŵatite, “Nnole! Ngukuwona kwinani kwakuugule ni Mwana jwa Mundu ajimi kundyo kwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pelepo ŵandu wose ŵaŵaliji pa Nkungulu ula ŵagumisile kwa liloŵe lyekulungwa ni kusiŵila mawiwi ni makono gao. Nipele ŵanguluchile ŵanawose kwana kamo, ");
INSERT INTO yao_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ni ŵankopwesye mmusi ni kumponya maganga. Ŵaumboni ŵala ŵaŵisile yakuwala yao kwa jwanchanda jumo liina lyakwe che Sauli kuti aigose. ");
INSERT INTO yao_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Paŵapundile kwaponya maganga, che Stefano ŵapopele achitiji, “Alakwe Ambuje Che Yesu, mpochele mbumu jangu!” ");
INSERT INTO yao_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ŵatindiŵele ni ŵanyanyisye achitiji, “Ambuje nkaaŵalanjila sambi si.” Paŵaŵechete yeleyo ŵajasiche. Ni che Sauli ŵakundile kuti che Stefano akuŵajilwa kuulajikwa. ");
INSERT INTO yao_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Lyuŵa lilyolyo gatandite malagasyo gannope kwa mpingo wa ŵandu ŵakunkulupilila Kilisito ŵa ku Yelusalemu. Ŵandu ŵakunkulupilila Kilisito wose ŵapwilingene mu ilambo ya ku Yudea ni ku Samalia, akaŵe achinduna pe. ");
INSERT INTO yao_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ŵandu ŵakwajogopa Akunnungu ŵansichile che Stefano ni kwalilila kwa malumbo gamakulungwa. ");
INSERT INTO yao_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nambo che Sauli ŵalinjile kuuwesesya mpingo wa ŵandu ŵakunkulupilila Kilisito. Ŵajawile mu nyuumba jajili jose ni kwakoposya paasa ŵandu ŵakunkulupilila Che Yesu wose achalume ni achakongwe ni kwaŵika mu nyuumba jakutaŵilwa. ");
INSERT INTO yao_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Aŵala ŵandu ŵakunkulupilila Che Yesu ŵaŵapwilingene ŵajesilejesile mosemose achilalichilaga Ngani Jambone. ");
INSERT INTO yao_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Che Filipo nombe ŵajinjile mu mmusi wauli ku chilambo cha ku Samalia achilalichilaga ngani ja Kilisito ni Akunnungu kwa ŵandu ŵakutama pelepo. ");
INSERT INTO yao_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mpingo wa ŵandu paŵagapilikene maloŵe gaŵaŵechete che Filipo ni kwiwona imanyisyo iŵaitesile, wose ŵaapilikanichisye kwa uchenene. ");
INSERT INTO yao_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pakuŵa ŵandu ŵajinji ŵaŵakwete masoka, gakopweche gachigumilaga kwa liloŵe lyekulungwa. Ni sooni ŵandu ŵajinji ŵaŵatatele iŵalo ni ŵaŵalemele ŵalamiswe. ");
INSERT INTO yao_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nipele kwaliji ni kusengwa kwakukulungwa mmusi wo. ");
INSERT INTO yao_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jwapali mundu jumo liina lyakwe che Simoni juŵatendaga usaŵi mmusi mo kwa moŵa gamajinji ni kwasimosya ŵandu ŵa ku Samalia, achilitendaga kuti jwelejo ali jwankulu. ");
INSERT INTO yao_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ŵandu wose chitandile jwannandi kwichila jwankulungwa ŵampilikene jwelejo ni kuti, “Mundu ju akwete ukombole wa Akunnungu waukuŵilanjikwa ‘Ukombole Weukulungwa.’ ” ");
INSERT INTO yao_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ŵampilikanichisye jwelejo pakuŵa ŵaasimosisye kwa moŵa gamajinji kwa usaŵi wakwe. ");
INSERT INTO yao_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nambo paŵaukulupilile utenga u che Filipo nkati Ngani Jambone ja Umwenye wa Akunnungu ni ngani ji Che Yesu Kilisito, ŵabatiswe achalume ni achakongwe. ");
INSERT INTO yao_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Che Simoni nombejo ŵakulupilile, ni paŵabatiswe, ŵajesile ni che Filipo, ŵasimosile paŵaiweni imanyisyo ni yakusimonjeka iyatendekwe. ");
INSERT INTO yao_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Achinduna ŵaŵaliji ku Yelusalemu paŵapilikene kuti ŵandu ŵa ku Samalia nombewo ajitichisye Liloŵe lya Akunnungu, ŵaatumile che Petulo ni che Yohana kukwao. ");
INSERT INTO yao_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Che Petulo ni che Yohana paŵaiche kweleko ŵaapopelele ŵakukulupilila ŵala kuti ampochele Mbumu jwa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","pakuŵa Mbumu jwa Akunnungu ŵaliji akanantuluchile mundu jwalijose mwa ŵanyawo, nambo ŵagambile kubatiswa pe kwa liina lya Ambuje Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nipele, che Petulo ni che Yohana ŵaasajichile makono gao ŵakukulupilila wala, ni ŵapochele Mbumu jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pelepo che Simoni paŵaimanyi kuti ŵandu akupegwa Mbumu jwa Akunnungu kwa kusajichilwa makono ga achinduna, ŵasachile kwapa mbiya che Petulo ni che Yohana ");
INSERT INTO yao_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","achitiji, “Mumbeje none jwakwe ukombole wo kuti mundu jwalijose juchingansajichile makono ampochele Mbumu jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nambo che Petulo ŵansalile, “Njonasiche mwasyene pamo ni mbiya syenu, pakuŵa nkuganisya kuti nkukombola kusuma ukombole wa Akunnungu kwa mbiya! ");
INSERT INTO yao_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nganinkola chachili chose atamuno lipesa pamasengo go pakuŵa ntima wenu nganiuŵa wambone paujo pa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kwapele nleche ungalumbana wenu wu, ni kwapopela Ambuje nombewo panepa channechelesye sambi sya kuganisya yeleyo. ");
INSERT INTO yao_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Pakuŵa ngummona mgumbele ligogo ni sooni ntaŵikwe ni sambi!” ");
INSERT INTO yao_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Che Simoni ŵajanjile, “Ngummenda mwanya mumbopelele kwa Ambuje ganaiche kuumbata gagaligose mwa gelego gansasile go.” ");
INSERT INTO yao_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Che Petulo ni che Yohana paŵamalisisye kuŵalanga umboni ni kulalichila Liloŵe lya Ambuje, ŵaujile ku Yelusalemu. Paŵaujaga ŵaalalichile ŵandu Ngani Jambone mmisinda jejinji ja ku Samalia. ");
INSERT INTO yao_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Katumetume jwa kwinani jwa Ambuje ŵansalile che Filipo, “Nliŵiche chile njaule kulujenda ku litala lyalikupitila mwipululu lyalikutuluchila ku Yelusalemu kwaula ku Gaza.” ");
INSERT INTO yao_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nipele, che Filipo ŵaliŵisile chile ni kutanda ulendo. Katema ko kwaliji ni mundu jwa ku Esiopia jwakugosa mbiya mu umwenye wa Kandake mwenye jwankongwe jwa ku Esiopia, mundu jo ŵatamaga liuli. Jwelejo ŵajawile ku Yelusalemu kukwapopela Akunnungu, ni katema ko ŵaliji nkuuja ali akwesile mutuka ja kukwekwelemya. ");
INSERT INTO yao_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Paŵaujaga, ŵatemi mmutuka akuno ali nkusyoma chitabu chi che Isaya jwakulondola jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nipele, Mbumu jwa Akunnungu ŵansalile che Filipo, “Mmandichile mutuka jo ni kulongana najo.” ");
INSERT INTO yao_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Che Filipo ŵautwiche ni kujiŵandichila mutuka jila, ŵampilikene mundu jula ali nkusyoma chitabu chi che Isaya jwakulondola jwa Akunnungu. Pelepo che Filipo ŵammusisye, “Ana nkuimanyilila uchenene inkusyoma yo?” ");
INSERT INTO yao_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mundu jo ŵanjanjile, “Ana chingombole uli kuimanyilila pangali mundu jwakundagulila?” Pelepo ŵanchondelele che Filipo kuti akwele mu mutuka ni kutama pamo nawo. ");
INSERT INTO yao_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ni liunjili lya Malembelo ga Akunnungu liŵaliji nkusyoma ni ali, “Ŵaliji mpela ngondolo jiŵajijausyaga kukujisinga, ŵamyalele mpela mwanangondolo pakunkata manyunya, Nombewo nganaŵecheta chachili chose. ");
INSERT INTO yao_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ŵachembulwisye ni kwaonela. Ngapagwa juchakombole kuŵecheta yankati uŵelesi wakwe, pakuŵa umi wakwe ujigalikwe kutyochela pachilambo.” ");
INSERT INTO yao_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mundu jwa ku Esiopia jo ŵansalile che Filipo, “Choonde musalile, jwakulondola jwa Akunnungu ju akuŵecheta yankati ŵaani? Ana akuŵecheta yankati nsyene pane mundu jwine?” ");
INSERT INTO yao_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nipele, che Filipo ŵatandilile pelepo pa Malembelo ga Akunnungu ŵansalile Ngani Jambone ji Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Paŵaliji chiŵela ni ulendo wo, ŵaiche pagali meesi, ni juŵatamaga liuli jula ŵatite, “Peuto pa kwana meesi, ana kwana chachili chose chakuunekasya une ninabatiswe?” ");
INSERT INTO yao_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Che Filipo ŵatite, “Mwakulupililaga ni ntima wenu wose nkukombola kubatiswa.” Nombejo ŵatite, “Elo ngukulupilila kuti Che Yesu Kilisito ali Mwana jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mundu jula ŵalamwile mutuka jijime, ni ŵanawose ŵaŵili ŵatulwiche ni kwinjila mmeesi, che Filipo ŵambatisye mundu jula. ");
INSERT INTO yao_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Paŵakopweche mmeesi papopo Mbumu jwa Ambuje ŵanjigele che Filipo ni mundu jwa ku Esiopia jula nganambona sooni che Filipo, nambo ŵajendelechele ni ulendo achisengwaga. ");
INSERT INTO yao_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nambo che Filipo ŵalisimene aiche mmusi wa ku Azoto, ni paŵapitaga ŵaalalichile ŵandu Ngani Jambone mmisi jose mpaka ŵaiche ku Kaisalia. ");
INSERT INTO yao_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Katema ko che Sauli ŵapundile kwajogoya nnope ŵakwakuya Ambuje kuti chiŵaulaje. Ŵajawile kwa Jwambopesi Jwankulu, ");
INSERT INTO yao_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kukuŵenda ŵaape chikalata chakwamanyisya mmajumba ga kupopelela ga ku Damesiki kula kuti, ŵaasimanaga kweleko ŵandu ŵakulikuya Litala lya Ambuje, achalume atamuno achakongwe ŵakamule ni kwaikanawo ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nambo che Sauli paŵaliji mwitala pachiŵandi ni kwika ku Damesiki, chisisimuchile lulanga kutyochela kwinani lwalanguchisye mbande syose. ");
INSERT INTO yao_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ŵagwile paasi ni kupilikana liloŵe lichasalilaga, “Che Sauli, che Sauli! Ligongo chi nkuunagasya?” ");
INSERT INTO yao_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Che Sauli nombe ŵausisye, “Ambuje, ana ŵaani alakwe?” Ni liloŵe lyo lyajanjile, “Uneji ndili Che Yesu junkunlagasya. ");
INSERT INTO yao_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nambo sambano njime, njinjile mmusi ni kweleko chansalile chachikummajila kuchipanganya.” ");
INSERT INTO yao_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ni ŵandu ŵaŵaliji pamo nawo mu ulendo ŵala, ŵajimi ali jii, ŵapilikanaga liloŵe lyo nambo nganammona mundu. ");
INSERT INTO yao_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Che Sauli ŵajimi, nambo paŵatatanukwile meeso gakwe nganakombola kuchiwona chachili chose, nipele ŵandu ŵaŵalongene nawo ŵala ŵankamwile nkono ni kunnongosya mpaka ku Damesiki. ");
INSERT INTO yao_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Che Sauli ŵatemi moŵa gatatu pangalola, ni nganalya natamuno kung'wa chachili chose. ");
INSERT INTO yao_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ku Damesiki ko jwapali jwakulijiganya ju Che Yesu liina lyakwe che Anania. Ambuje ŵammilasile mu yakwiwona, “Che Anania!” Che Anania ŵajitiche, “Une ndili pelepa Ambuje.” ");
INSERT INTO yao_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ambuje ŵansalile, “Njimuche njaule ku litala lyalikuŵilanjikwa Litala Lyagoloka, nkauchilichisye mu nyuumba ji che Yuda mundu liina lyakwe che Sauli jwa ku Taso. Ni sambano ali nkupopela, ");
INSERT INTO yao_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","nombewo mu yakwiwona ambweni mundu liina lyakwe che Anania achijinjilaga nkati ni kunsajichila makono gakwe kuti akombole kulola sooni.” ");
INSERT INTO yao_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nambo che Anania ŵajanjile, “Ambuje, mbilikene ngani sya mundu ju kutyochela kwa ŵandu ŵajinji, mbilikene yangalumbana iŵaapanganyichisye ŵaswela ŵenu ku Yelusalemu kula. ");
INSERT INTO yao_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ni apano aiche ali ni ulamusi kutyochela kwa achakulu ŵambopesi, ŵakamule ŵandu wose ŵakunkulupilila mmwe Che Yesu.” ");
INSERT INTO yao_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nambo Ambuje ŵansalile che Anania, “Njauleje pe, pakuŵa naasagwile kuti andumichile, ajenesye ngani syangu kwa ŵandu ŵangaŵa Ŵayahudi ni kwa mamwenye ni kwa Ŵaisilaeli nombe. ");
INSERT INTO yao_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Uneji nansyene chinaalosye indu yekulungwa ichaŵajilwe kulagaswa nayo kwaligongo lyangu.” ");
INSERT INTO yao_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nipele, che Anania ŵajawile ni kwinjila mu nyuumba jo. Ŵaasajichile makono che Sauli ni kuti, “Nlongo njangu che Sauli, Ambuje Che Yesu juŵakukopochele pamwaliji mwitala kwika apano, andumile kuti nkombole kulola sooni ni kugumbaswa Mbumu jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Papopo yagwile mmeeso mwakwe che Sauli indu mpela ikalaŵesya ni ŵakombwele kulola sooni. Ni ŵajimwiche ni kubatiswa. ");
INSERT INTO yao_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nipele ŵalile chakulya ni kukola machili sooni. Che Sauli ŵatemi pamo ni ŵakulijiganya ŵa Che Yesu kwa moŵa kanandi ku Damesiki kula. ");
INSERT INTO yao_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Papopo ŵatandite kulalichila mmajumba ga kupopelela ga Ŵayahudi kuti Che Yesu ali Mwana jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ŵandu wose ŵaŵampilikene ŵasimosile ni kuti, “Ana jweleju ngaŵa julajula jwaŵauleje aŵala ŵaŵankulupililaga Che Yesu ku Yelusalemu kula? Ni sooni ŵaiche akuno kuti ŵakamule ŵanyawo ni kwajausya kwa achakulu ŵambopesi!” ");
INSERT INTO yao_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Che Sauli ŵapundile kukola machili, ni kwasimosya Ŵayahudi ŵakutama ku Damesiki iŵatite pakulosya pangasisa kuti, Che Yesu ali Kilisito. ");
INSERT INTO yao_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pagapite moŵa gamajinji, Ŵayahudi ŵajilene ni kusosa itajile pakwaulaga che Sauli. ");
INSERT INTO yao_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nambo che Sauli ŵapilikene ngani jo. Nipele ŵandu ŵaliji nkwajuŵilila mminango ja kwinjilila mmusi wo muusi ni chilo, kuti ŵaulaje. ");
INSERT INTO yao_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nambo chilo chimo ŵakulijiganya ŵakwe ŵanjigele mu chitundu ni kumpelesya pepowo pa likumba lya musi ni kunselelesya mpaka paasi. ");
INSERT INTO yao_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Che Sauli paŵaiche ku Yelusalemu ŵasachile kuliwanganya ni ŵakulijiganya ŵane ŵala. Nambo wose ŵanjogwepe, nganakulupilila kuti che Sauli ŵaliji jwakulijiganya njao. ");
INSERT INTO yao_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nipele che Banaba ŵanjigele che Sauli ni kunjausya kwa achinduna, ni kwasalila yankati che Sauli iŵatite pakwawona Ambuje Che Yesu mwitala ni kukunguluka nawo, ni iŵatite pakwalalichila ŵandu ngani si Che Yesu pangali lipamba ku Damesiki kula. ");
INSERT INTO yao_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nipele che Sauli ŵatemi pamo nawo, ni ŵajesile mu Yelusalemu mose achilalichilaga ŵandu Liloŵe lya Ambuje pangali lipamba. ");
INSERT INTO yao_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ni sooni ŵakungulwiche ni kukanilana ni Ŵayahudi ŵakuŵecheta Chigiliki, nambo ŵanyawo ŵasachile kummulaga. ");
INSERT INTO yao_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ŵakukulupilila ŵala paŵaimanyilile yeleyo, ŵanjigele che Sauli ni kunjausya ku Kaisalia, ni ŵannesile kweleko kuti ajaule ku Taso. ");
INSERT INTO yao_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Katema ko mpingo wa ŵandu ŵakunkulupilila Kilisito ŵala ŵakwete chitendewele ku Yudea kose ni ku Galilaya kose ni ku Samalia kose. Mbumu jwa Akunnungu ŵapele machili ni ŵajonjesyeche ni ŵatemi kwa kwajogopa Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Che Petulo paŵaliji nkwendajenda pali pose, ŵaiche sooni kwa ŵakukulupilila ŵakutama ku Luda. ");
INSERT INTO yao_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ŵansimene kweleko mundu jwakuŵilanjikwa che Ainea, juŵagonile pa chindanda kwa yaka nsano ni itatu pakuŵa ŵatatele. ");
INSERT INTO yao_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nipele, che Petulo ŵansalile, “Che Ainea, Che Yesu Kilisito akunnamisya. Njimuche, ntandiche chindanda chenu.” Papopo che Ainea ŵajimwiche. ");
INSERT INTO yao_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ŵandu wose ŵaŵatemi ku Luda ni ku Shaloni ŵambweni che Ainea, ni wose ŵankulupilile Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ku Yopa ko jwapali jwakulijiganya jwankongwe liina lyakwe che Tabisa, mu Chigiliki che Doka, malumbo gakwe, ngolombwe. Jweleju ŵapanganyaga yambone ni kwakamuchisya ŵakulaga moŵa gose. ");
INSERT INTO yao_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Moŵa gala ŵalwasile ni ŵajasiche. Ŵandu ŵagajojesye malilo gakwe ni ŵagaŵisile mu chuumba cha mwinani. ");
INSERT INTO yao_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ku Yopa nganikutalikangana ni ku Luda, nipele ŵakulijiganya paŵapilikene kuti che Petulo ali ku Luda, ŵalajisye ŵandu ŵaŵili kukwao ni kwachondelela kuti, “Nnyiche chitema pe kukwetu.” ");
INSERT INTO yao_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nipele, che Petulo ŵalongene nawo. Paŵaiche, ŵanlongwesye ku chuumba cha mwinani. Kweleko ŵaŵililwe ni achiŵankwawo wose ŵansyungwile che Petulo achililaga ni kwalosya minjilo ni yakuwala ine iŵaipanganyisye che Doka akanaŵe kwasika. ");
INSERT INTO yao_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Che Petulo ŵaakopwesye paasa wose, ŵatindiŵele ni kupopela. Nipele, ŵagagalauchile malilo gala ni kuti, “Che Tabisa njimuche.” Nombejo ŵatatanukwile meeso gao, ni paŵaweni che Petulo ŵajimwiche ni kutama. ");
INSERT INTO yao_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Che Petulo ŵankamwile nkono ni kunjimika, ni ŵaaŵilasile ŵandu ŵakukulupilila ni ŵaŵililwe ni achiŵankwawo ŵala, ŵapele ali jwanjumi. ");
INSERT INTO yao_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ngani jo jajenele papali pose ku Yopa ko, ni ŵandu ŵajinji ŵaakulupilile Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Che Petulo ŵalonjele ku Yopa kula moŵa gampepe, achitamaga mu nyuumba ja mundu jwakuŵilanjikwa che Simoni jwakukolosya mapende. ");
INSERT INTO yao_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ni jwapali mundu ku Kaisalia liina lyakwe che Konolio, chilongola jwa mpingo wa ŵangondo mia moja waukuŵilanjikwa “Mpingo wa Italia.” ");
INSERT INTO yao_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jweleju pamo ni ŵaali mu nyuumba jao wose ŵajogopaga Akunnungu, nombejo ŵakamwisye ŵakulaga ni kupopela moŵa gose. ");
INSERT INTO yao_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mpela saa tisa ja muusi ŵammweni pangasisika katumetume jwa kwinani jwa Akunnungu mu yakwiwona achaichililaga ni kwasalila, “Che Konolio!” ");
INSERT INTO yao_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Che Konolio ŵankolondolele katumetume jo ali ni lipamba, ni kummusya, “Kwana chichi Ambuje?” Katumetume jo ŵanjanjile che Konolio, “Akunnungu apochele mapopelo ni sadaka syenu kwa ŵakulaga, ni sooni ngasanliŵalila kose. ");
INSERT INTO yao_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sambano, mwalajisye ŵandu ku Yopa akammilanje mundu liina lyakwe che Simoni, pane akummilanga che Petulo. ");
INSERT INTO yao_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jwelejo akutama ku che Simoni jwakukolosya mapende, nyuumba jakwe jili mungulugulu mbwani.” ");
INSERT INTO yao_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ajula katumetume jwa kwinani jwaŵechete maloŵe go paŵatyosile, che Konolio ŵaaŵilasile ŵakutumichila ŵakwe ŵaŵili pamo ni jumo jwa ŵangondo ŵakwe juŵantumichilaga, juŵaliji jwakwajogopa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ŵaasalile yose iyakopochele, ni kwalajisya ku Yopa. ");
INSERT INTO yao_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Malaŵi jakwe lyuŵa lili pa ntwe, ŵandu ŵatatu wo ali chiŵela mu ulendo, achiŵandichilaga ku Yopa che Petulo ŵakwesile penani pa nyuumba kukupopela. ");
INSERT INTO yao_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ni jakwete sala, ŵasachile chakulya. Paŵankulumichisyaga chakulya, ŵaiweni yakwiwona. ");
INSERT INTO yao_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ni ŵakuweni kwinani kweugule ni chindu chisau shuka jejikulungwa jili jeŵambe mmalombo gakwe gancheche chili nkutuluswa. ");
INSERT INTO yao_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mwelemo mwaliji mwana inyama inayose yana makongolo gancheche ni inyama yaikukwaŵa ni ijuni ya kwiunde. ");
INSERT INTO yao_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nipele, ŵalipilikene liloŵe lichasalilaga, “Che Petulo njimuche, nsikite nlye.” ");
INSERT INTO yao_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nambo che Petulo ŵajanjile, “Ngwamba, Ambuje, uneji nganilye chindu chachili chose chekanye kuligwa atamuno chakusakala.” ");
INSERT INTO yao_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Liloŵe lila lyapikaniche sooni lichasalilaga, “Indu yaiswejesye Akunnungu nkaiŵilanga yakusakala!” ");
INSERT INTO yao_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chelechi chakwasalila che Petulo nsikite nlye ŵasalilwe katatu, ni papopo shuka jila janyakulikwe kwinani. ");
INSERT INTO yao_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Che Petulo paŵaliji nkusimonga nkati malumbo ga yakwiwona yaiweni yo, ŵandu ŵaŵalajiswe ni che Konolio ŵala, ali amasile kuuchilichisya, ŵaiche pa nyuumba ji che Simoni jwakukolosya mapende, ni kwima pannango, ");
INSERT INTO yao_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ni ŵapoposile ni kuusya, “Ana mwelemu kwana jwannendo jwakuŵilanjikwa che Simoni jwakuŵilanjikwa che Petulo?” ");
INSERT INTO yao_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ni che Petulo paŵaliji nkuganisya yankati yakwiwona ila. Papopo Mbumu jwa Akunnungu ŵasalile, “Che Simoni, Kwana ŵandu ŵatatu pelepa akunsosa. ");
INSERT INTO yao_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ntuluche chitema pe ni sooni nkaliusyausya kulongana pamo nawo pakuŵa une ni junaatumile.” ");
INSERT INTO yao_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nipele, che Petulo ŵatulwiche ni kwasalila ŵandu wo, “Uneji ndili jwelejo junkunsosa. Ana nkusosa chichi pelepa?” ");
INSERT INTO yao_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ŵanyawo ŵanjanjile, “Atutumile che Konolio jwankulu jwa ŵangondo, mundu jwakuŵalanjikwa umboni wambone, jwakwajogopa Akunnungu ni kuchimbichikwa ni Ŵayahudi wose. Ŵasalilwe ni katumetume jwa kwinani kuti ambilanje alakwe kumangwakwe kuti apilikanile chinkusaka kuŵecheta.” ");
INSERT INTO yao_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Che Petulo ŵaaŵilasile ajinjilanje nkati, ŵapele pagona. Malaŵi jakwe, che Petulo ŵatandite ulendo pamo ni ŵanyawo, ni ŵandu ŵane ŵakwakulupilila Che Yesu ŵa ku Yopa ŵalongene nawo. ");
INSERT INTO yao_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lyuŵa lyaaŵili lyakwe ŵaiche ku Kaisalia, kweleko che Konolio ŵaalaliche achalongo achinjakwe ni achambusangagwe, ni ŵaliji nkwalindilila ŵanyawo. ");
INSERT INTO yao_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nipele che Petulo paŵajinjilaga nkati, che Konolio ŵakopweche paasa kukwachingamila, ŵatindiŵele paujo pa che Petulo ni kwakotamila. ");
INSERT INTO yao_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nambo che Petulo ŵanjimiche ni kunsalila, “Njime pakuŵa none jwakwe ndili mundu mpela alakwe.” ");
INSERT INTO yao_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Che Petulo ŵapundile kukunguluka ni che Konolio ali nkwinjila nkati ni ŵasimene ŵandu ŵajinji asongangene. ");
INSERT INTO yao_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Che Petulo ŵaasalile, “Ŵanyamwe mwachinsyene nkumanyilila kuti malajisyo ga dini jetu ja Chiyahudi gakutukanya kukamulangana atamuno kwajimajimila ŵandu ŵangaŵa Ŵayahudi. Nambo Akunnungu aamanyisye uneji kuti ninanganichisye mundu jwalijose kuti ali jwangaswejeswa atamuno jwakusakala. ");
INSERT INTO yao_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kwa ligongo lyo pamumilasile nganiingana kwika. Nipele, ngummusya kwaligongo chi mumilasile?” ");
INSERT INTO yao_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Che Konolio ŵajanjile, “Gapite moŵa gatatu mpela saa jijiji ja saa tisa, naliji nkupopela mu nyuumba jangu. Chisisimuchile nammweni mundu jwawasile iwalo yeswela mbee ajimi paujo pangu, ");
INSERT INTO yao_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ni ŵatite, ‘Che Konolio! Akunnungu akupilikene kupopela kwenu ni akusikumbuchila sadaka simwapele ŵakulaga. ");
INSERT INTO yao_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nipele muntume mundu ku Yopa akammilanje mundu liina lyakwe che Simoni, pane akummilanga che Petulo, jweleju akutama ku che Simoni jwakukolosya mapende, nyuumba jakwe jili mungulugulu mbwani.’ ");
INSERT INTO yao_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nipele, chitema pe naatumile ŵandu kukwenu, nomwe ntesile yambone pa kwika. Sambano uweji wose tuli paujo pa Akunnungu, kupilikanila chachili chose chantumile Ambuje kusala.” ");
INSERT INTO yao_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pelepo che Petulo ŵatandite kuŵecheta achitiji, “Sambano ngumanyilila kuti isyene Akunnungu nganakola lusagu. ");
INSERT INTO yao_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nambo mundu jwa chilambo chachili chose, jwakwajogopa Akunnungu ni kupanganya yaili yambone paujo pao, akukundikwa nawo. ");
INSERT INTO yao_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ŵanyamwe nkuumanyilila utenga uŵaupeleche Akunnungu kwa ŵandu ŵa ku Isilaeli, achijenesyaga Ngani Jambone jajikwikanawo chitendewele kwa litala li Che Yesu Kilisito, ŵaali Ambuje ŵa wose. ");
INSERT INTO yao_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ŵanyamwe nkulimanyilila alila lilyatyochele mchilambo chose cha Ŵayahudi, chitandile ku Galilaya, che Yohana paŵamasile kulalichila utenga wa ubatiso. ");
INSERT INTO yao_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nkumanyilila iŵatite Akunnungu pakunsagula Che Yesu jwa ku Nasaleti kwa kwatuluchisya Mbumu jwa Akunnungu ni machili. Pakuŵa Akunnungu ŵaliji pamo nawo, nipele ŵaliji nkwendajenda akuno ni akunokuno achitendaga yambone ni kwalamya wose ŵaŵakamwilwe ni Ibilisi. ");
INSERT INTO yao_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Noweji tuli ŵaumboni wa yose iŵatesile mmusi wa Ŵayahudi ni mu Yelusalemu. Ŵambuleje kwa kwaŵamba pansalaba, ");
INSERT INTO yao_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","nambo Akunnungu ŵansyusisye pa lyuŵa lyaatatu ni kwatenda awoneche pangasisika. ");
INSERT INTO yao_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nganawoneka kwa ŵandu wose, nambo kwa aŵala ŵaumboni ŵaŵasagwile Akunnungu, yaani uweji utwalile ni kung'wa pamo nawo, paŵamasile kusyuka. ");
INSERT INTO yao_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ni ŵatulajisye tulalichile Ngani Jambone kwa ŵandu wose ni kuŵalanga umboni kuti Che Yesu ni ŵaŵasagulikwe ni Akunnungu kuti ŵaalamule ŵajumi ni ŵawe. ");
INSERT INTO yao_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ŵakulondola ŵa Akunnungu wose ŵasasile umboni nkati ŵelewo kuti mu liina lyao, jwalijose jwakwakulupilila chalecheleswe sambi syakwe syose.” ");
INSERT INTO yao_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Che Petulo paŵaŵechetaga maloŵe go, Mbumu jwa Akunnungu ŵatuluchile ŵanawose ŵaŵaupilikanilaga utenga wao. ");
INSERT INTO yao_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ni Ŵayahudi ŵaŵakulupilile ŵaŵapechesye che Petulo kutyochela ku Yopa ŵala ŵasimosile kuwona kuti Akunnungu ŵatuluchisye ukombole wa Mbumu jwa Akunnungu ŵandu ŵangaŵa Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Pakuŵa ŵaapilikene achiŵechetaga iŵecheto yakusimosya paŵakusyaga Akunnungu. Pelepo che Petulo ŵatite, ");
INSERT INTO yao_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ŵandu ŵa apochele Mbumu jwa Akunnungu mpela uweji itutite pakupochela. Ana kwana mundu jwalijose juchakombole kwakanya kuti anabatiswe ni meesi?” ");
INSERT INTO yao_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nipele, ŵalamwile kuti abatiswe kwa liina li Che Yesu Kilisito. Nipele ŵandu ŵala ŵaachondelele che Petulo kuti atame nawo moŵa gampepe. ");
INSERT INTO yao_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Achinduna ni ŵandu ŵane ŵakunkulupilila Che Yesu ŵaŵatemi ku Yudea ŵapilikene kuti ŵandu ŵangaŵa Ŵayahudi nombe apochele Liloŵe lya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nipele, che Petulo paŵausile ku Yelusalemu, aŵala Ŵayahudi ŵaŵakulupilile Che Yesu ŵaŵaumbele, ŵaalalatile, ");
INSERT INTO yao_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","achitiji, “Mmwejo mwajawile kukutama ni ŵandu ŵangaumbala ni kulya nawo!” ");
INSERT INTO yao_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pelepo che Petulo ŵatandite kwagopolela yeleyo chimo chimo kuti. ");
INSERT INTO yao_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Lyuŵa limo naliji nkupopela musi wa ku Yopa, pelepo naiweni yakwiwona, nachiweni chindu mpela shuka jajikulungwa jili jeŵambe mmalombo gakwe gancheche chilinkutuluswa kutyochela kwinani, ni kwika panaliji une. ");
INSERT INTO yao_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nalingulile uchenene nkati, naiweni inyama ya kulangwa yana makongolo ncheche ni inyama ya mwikonde ni inyama yaikukwaŵa ni ijuni. ");
INSERT INTO yao_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nipele napilikene liloŵe lichisalilaga, ‘Che Petulo njime, nsikite ndye.’ ");
INSERT INTO yao_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ni uneji najanjile, ‘Ngwamba, Ambuje, pakuŵa chindu chachili chose changaswejeswa atamuno chakusakala nganichijinjile ng'o pakang'wa pangu.’ ");
INSERT INTO yao_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nambo liloŵe lila lyapikaniche kaaŵili kutyochela kwinani lichitiji, ‘Yaiswejesye Akunnungu, alakwe nkaiŵilanga yakusakala.’ ");
INSERT INTO yao_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Chelechi chatendekwe katatu, ni mbesi jakwe indu yose yanyakulikwe sooni kwinani. ");
INSERT INTO yao_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Pangakaŵa, ŵandu ŵatatu ŵaŵalajiswe kukwangu kutyochela ku Kaisalia ŵaiche pa nyuumba jinatamaga. ");
INSERT INTO yao_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mbumu Jwanswela ŵasalile longane nawo pangali lipamba. Ni ŵanyaŵa sita nalongene nawo ku Kaisalia ni kweleko twajinjile mu nyuumba ji che Konolio. ");
INSERT INTO yao_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Che Konolio ŵatusalile iŵatite pakummona katumetume jwa kwinani juŵajimi mu nyuumba jakwe ni kunsalila, ‘Muntume mundu ku Yopa akammilanje mundu liina lyakwe che Simoni, pane akuŵilanjikwa che Petulo. ");
INSERT INTO yao_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ŵelewo chaachinsalila maloŵe, ganti chigankulupusye mmwejo ni ŵandu ŵaali mu nyuumba jenu wose.’ ");
INSERT INTO yao_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Panatandite kuŵecheta, Mbumu jwa Akunnungu ŵaatuluchile mpela yatite pakututuluchila uweji kundanda. ");
INSERT INTO yao_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Pelepo nagakumbuchile maloŵe ga Ambuje paŵatite, ‘Che Yohana ŵabatisye kwa meesi, nambo ŵanyamwe chimbatiswe kwa Mbumu jwa Akunnungu.’ ");
INSERT INTO yao_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nipele iŵaga Akunnungu ŵapele ŵandu ŵangaŵa Ŵayahudi ntuuka ulaula watupele uweji utukwakulupilila Ambuje Che Yesu Kilisito, ana uneji ŵaani naakanile Akunnungu?” ");
INSERT INTO yao_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Paŵapilikene yeleyo, ŵalesile makani ni kwakusya Akunnungu achitiji, “Akunnungu ŵapele ŵandu ŵangaŵa Ŵayahudi lipesa lya kuleka sambi, akole umi wa moŵa gose pangali mbesi!” ");
INSERT INTO yao_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ligongo lya kulagaswa kukwatandite paŵauleje che Stefano, ŵandu ŵaŵakulupilile Che Yesu ŵala ŵapwilingene. Ŵane ŵajawile mpaka ku Foinike ni ku Kupulo ni ku Antiokia achilalichilaga Liloŵe lya Akunnungu kwa Ŵayahudi pe. ");
INSERT INTO yao_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nambo ŵapali ŵane ŵa ŵanyawo ŵaŵatyochele ku Kupulo ni ku Kulene, ŵajawile ku Antiokia ni kwenesya ngani jo kwa ŵandu ŵangaŵa Ŵayahudi, achilalichilaga Ngani Jambone ja Ambuje Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ambuje ŵaalongwesye kwa ukombole wao, ni ŵandu ŵajinji ŵakulupilile ni kwaujilila Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ni ngani syo syapikaniche kwa mpingo wa ŵandu ŵakunkulupilila Kilisito ku Yelusalemu. Nipele ŵantumile che Banaba ajaule ku Antiokia. ");
INSERT INTO yao_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nombejo paŵaiche kweleko ni kwiwona iŵatite Akunnungu pakwapa upile ŵandu ŵala, ŵasengwile ni kwachisya ŵandu apunde kwakulupilila Ambuje kwa mitima jao jose. ");
INSERT INTO yao_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Che Banaba ŵaliji mundu jwambone ni jwagumbele Mbumu jwa Akunnungu ni chikulupi. Kwa ligongo li che Banaba, mpingo wekulungwa wa ŵandu wajonjesyeche kwa Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nipele che Banaba ŵajawile ku Taso kukwasosa che Sauli. ");
INSERT INTO yao_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Paŵasimene, ŵalongene nawo ku Antiokia. Ni wose ŵanaŵaŵili ŵatemi ni mpingo wa ŵandu ŵakunkulupilila Kilisito chaka chansima, achiujiganyaga mpingo wekulungwa wa ŵandu. Ku Antiokia ko ni kukwaliji kwaandanda ŵakulijiganya kuŵilanjikwa Ŵakilisito. ");
INSERT INTO yao_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ni katema kakoko, ku Antiokia ko ŵaiche ŵakulondola ŵa Akunnungu ŵampepe kutyochela ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nipele, jumo jwa ŵanyawo liina lyakwe che Agabo ŵajimi ni kwa machili ga Mbumu jwa Akunnungu ŵalondwele kuti, chijityochele sala jajikulungwa mchilambo chose. Sala jo jatyochele katema ka mwenye che Kilaudio. ");
INSERT INTO yao_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ŵakulijiganya ŵala, jwalijose malinga ni ukombole wakwe ŵaakamuchisye achinjao ŵaŵakulupilile Che Yesu ŵaŵatamaga ku Yudea. ");
INSERT INTO yao_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nipele, ŵatesile yeleyo ni kwatuma che Banaba ni che Sauli kuti apeleche kwa achakulu ŵa mpingo wa ŵandu ŵakunkulupilila Kilisito. ");
INSERT INTO yao_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Katema kakoko mwenye che Helode, ŵatandite kwalagasya ŵandu ŵampepe wa mu mpingo wa ŵandu ŵakunkulupilila Kilisito. ");
INSERT INTO yao_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ni ŵambuleje che Yakobo mpwakwe che Yohana ni lipanga. ");
INSERT INTO yao_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Paŵaiweni kuti chitendo cho chanonyelesye Ŵayahudi, ŵapundisye, ŵaakamwile che Petulo nombe nawo. Yeleyo yatendekwe katema ka chindimba cha mikate jangatajikwa amila. ");
INSERT INTO yao_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Paŵankamwile che Petulo, ŵammisile mu nyuumba jakutaŵilwa ni kwaŵika paasi pa mipingo ncheche ja ŵangondo ncheche ncheche kuti ŵalindilile. Che Helode ŵasachile kwakoposya che Petulo kwa ŵandu pakumala chindimba cha Ŵayahudi cha mikate jangatajikwa amila chachikuŵilanjikwa Pasaka. ");
INSERT INTO yao_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nipele, che Petulo paŵaliji mu nyuumba jakutaŵilwa jila, katema kakoko mpingo wa ŵandu ŵakunkulupilila Kilisito ŵalimbile kwapopelela kwa Akunnungu kwa mitima jao jose. ");
INSERT INTO yao_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Chilo, likanaŵe kwika lyuŵa lilyatiji che Helode ankoposye che Petulo pa ŵandu, che Petulo ŵagonile pasikati ja ŵangondo ŵaŵili, ali ataŵikwe ni minyolo jiŵili ni ŵakulindilila ŵaliji nkulindilila pannango wa nyuumba jakutaŵilwa jila. ");
INSERT INTO yao_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Chisisimuchile, katumetume jwa kwinani jwa Ambuje ŵajimilile ni lilanguka lyalanguchisye mu chuumba mo. Ni katumetume jo ŵantingenye che Petulo mu mbalati ni kwajimusya achitiji, “Njimuche chitema pe!” Papopo unyolo wawantaŵile mmakono wakutwiche ni kugwa paasi. ");
INSERT INTO yao_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Katumetume jwa kwinani ŵansalile, “Nlitaŵe nkaanda wenu, mmwale ni italawanda yenu.” Che Petulo ŵatesile yeleyo ni katumetume jo ŵansalile, “Mmwale likoti lyenu munguye.” ");
INSERT INTO yao_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Che Petulo ŵankuiye mpaka paasa pa nyuumba jakutaŵilwa, nambo nganamanyililaga kuti yele iyatendekwaga ni katumetume jwa kwinani jo yaliji isyene, ŵaganisisye kuti akwiwona yakwiwona. ");
INSERT INTO yao_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ŵapite liuto lyaandanda ni lyaaŵili lya ŵakulindilila, ŵaiche pannango wa chisyano wakwinjilila mmusi. Nnango wo waugwiche usyene, nombewo ŵakopweche paasa. Ni ŵaliji nkwenda litala limo ni papopo katumetume jwa kwinani jo ŵannesile che Petulo jikape. ");
INSERT INTO yao_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pelepo che Petulo ŵaimanyi iyakopochele ni ŵatite, “Sambano ngumanyilila kusyene kuti, Ambuje antumile katumetume jwao jwa kwinani kukungulupusya mu ulamusi u che Helode ni kungoposya mu iŵailolelaga Ŵayahudi kuti ikopochele.” ");
INSERT INTO yao_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Paŵaimanyilile yeleyo ŵajawile ku nyuumba ji che Maliamu achikulugwe che Yohana jwakuŵilanjikwa che Maliko. Mwelemo ŵasongangene ŵandu ŵajinji kupopela. ");
INSERT INTO yao_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Che Petulo ŵapoposile pannango wa paasa ni ŵaiche katumetume mwali liina lyakwe che Loda kukupilikanila. ");
INSERT INTO yao_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mwali jo paŵalimanyilile liloŵe li che Petulo, nganaugula nnango kwa ligongo lya kusengwa, nambo ŵautuchile nkati ni kwasalila kuti che Petulo ali pannango. ");
INSERT INTO yao_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ni ŵanyawo ŵansalile mwali jo, “Ntekupungwana!” Nombejo ŵalimbile kuti isyene ali ŵawowo. Ni ŵanyawo ŵansalile, “Jwelejo ali katumetume jwao jwa kwinani.” ");
INSERT INTO yao_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ni katema kakoko che Petulo ŵapundile kupoposya pannango. Nipele paŵaugwile nnango ŵambweni, ni kusimonga. ");
INSERT INTO yao_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Che Petulo ŵagolwesye nkono kuti amyalale, ni kwasalila iŵatite Ambuje pakwakoposya mu nyuumba jakutaŵilwa. Nipele ŵaasalile akaalanjile yelei che Yakobo ni achalongo ŵane ŵakunkulupilila Kilisito, nombejo ŵatyosile ni kwaula kwine. ");
INSERT INTO yao_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pakwachele, ŵangondo ŵala ŵapundile kola lipamba lyelikulungwa yankati chichasimene che Petulo. ");
INSERT INTO yao_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nipele che Helode ŵatite asosekwe nambo nganiŵaona. Nipele ŵalamwile kuti ŵaausye ŵangondo ŵala, ni ŵatyosisye lilamulo kuti aulajikwe. Nipele che Helode ŵatyosile ku Yudea, ŵajawile ku Kaisalia ni kutama kukoko kwa moŵa gampepe. ");
INSERT INTO yao_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Che Helode ŵaatumbilile nnope ŵandu ŵa ku Tilo ni ku Sidoni. Nambo ŵanyawo kwa pamo ŵaajaulile che Helode. Ŵakombwele kusyoŵekana ni che Blasto juŵaliji jwakuchimbichikwa ni jwakulindilila nyuumba ja mwenye, kuti aŵe pamo ni ŵanyawo. Che Blasto ŵaajaulile che Helode ni kwachondelela kuti kuŵe ni chitendewele, pakuŵa chilambo chao chakulupililaga chakulya kutyochela ku chilambo cha mwenye. ");
INSERT INTO yao_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pa lyuŵa lilyasagulikwe, che Helode ŵawete iwalo ya umwenye ni kutama pa chitengu chao cha umwenye, ni kukunguluka ni ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ni ŵandu ŵala ŵanyanyisye achitiji, “Ali lili liloŵe lya nnungu, nganiliŵa lya mundu.” ");
INSERT INTO yao_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Papopo katumetume jwa kwinani jwa Ambuje ŵangwisisye che Helode paasi, pakuŵa nganiŵapa Akunnungu ukulu wo. Ni jakamwile mbango ni kuwa. ");
INSERT INTO yao_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nambo Liloŵe lya Akunnungu lyapundile kwenela. ");
INSERT INTO yao_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Che Banaba ni che Sauli paŵamalisisye masengo ga Akunnungu, ŵanjigele che Yohana jwakuŵilanjikwa che Maliko ni kuuja kutyochela ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mu mpingo wa ŵandu ŵakunkulupilila Kilisito ŵa ku Antiokia, ŵapali ŵane ŵaŵaliji ŵakulondola ŵa Akunnungu ni ŵakwiganya. Mwa ŵelewo, ŵapali che Banaba ni che Simeoni jwakuŵilanjikwa jwampiliu ni che Lukio jwa ku Kulene ni che Sauli ni che Manaeni ŵaŵalelitwe pamo ni mwenye che Helode. ");
INSERT INTO yao_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nipele, paŵaliji nkupopela kwa Ambuje ni kutaŵa, Mbumu jwa Akunnungu ŵatite, “Mumichile pajika che Banaba ni che Sauli, kwa ligongo lya masengo ganaŵilasile.” ");
INSERT INTO yao_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nipele, paŵamasile kutaŵa ni kupopela, ŵaasajichile makono gao ni kwaleka ajaulangane. ");
INSERT INTO yao_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nipele, che Banaba ni che Sauli ali alajiswe ni Mbumu jwa Akunnungu ŵatulwiche mpaka ku Seleukia, kutyochela kweleko ŵakwesile ngalaŵa mpaka ku chilumba cha Kupulo. ");
INSERT INTO yao_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Paŵaiche ku Salami, ŵaalalichile ŵandu Liloŵe lya Akunnungu mmajumba ga kupopelela Ŵayahudi, che Yohana Maliko ŵaliji pamo nawo nti jwakwatumichila. ");
INSERT INTO yao_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Paŵajesilejesile mchilumba chose mpaka ku Pafo, ŵansimene nsaŵi jumo Myahudi, jwakulondola jwa unami liina lyakwe Baliyesu. ");
INSERT INTO yao_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jweleju ŵaliji pamo ni che Selujio Paolo jwankulu jwa chilumba, mundu juŵaliji ni lunda nnope. Che Selujio Paolo ŵaaŵilasile che Banaba ni che Sauli kuti apilikane Liloŵe lya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nambo Elima nsaŵi jo, Elima Mchigiliki malumbo gakwe Jwakukanila, ŵasachile kunsiŵila jwankulu jwa chilumba anaukulupilile Ukilisito. ");
INSERT INTO yao_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nipele che Sauli jwakuŵilanjikwa che Paolo, ali aguumbele Mbumu jwa Akunnungu, ŵankolondolele Elima, ");
INSERT INTO yao_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ni kuti, “Mmwe nli mwanache jwa Shetani! Mmwe nli jwammagongo jwa ya usyene yose! Mmwe nli jwaunami jwankulu ni jwaulamba! Moŵa gose ngankuleka kugalyungasya matala ga goloka ga Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sambano, ulamusi wa Ambuje chiunlamule, chimme jwangalola ni nganliwona lyuŵa kwa katema.” Papopo pepo lyannyichilile lipundugulu ni chipi, ni ŵajendajendaga achinsosaga mundu jwakunkamula nkono kuti ŵaalongosye. ");
INSERT INTO yao_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jwankulu jwa chilumba jula paŵaiweni iyatendekwe yo, ŵankulupilile Che Yesu, ni ŵagasimosile nnope majiganyo gaŵagapilikene gankati Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nipele, che Paolo ni mpingo wakwe ŵakwesile ngalaŵa kutyochela ku Pafo ni ŵaichenje ku Pega mmusi wa Pamfilia, nambo che Yohana Maliko ŵaalesile ni kuujila ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nambo ŵanyawo ŵapelengenye kutyochela ku Pega mpaka ku Pisidia mmusi wa ku Antiokia. Nipele ŵajinjile mu nyuumba ja kupopelela pa Lyuŵa lya Kupumulila ni kutama. ");
INSERT INTO yao_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Paŵamasile kusyoma mchitabu cha Malajisyo ni mu itabu ya Ŵakulondola, ilongola ŵa nyuumba ja kupopelela jila ŵalajisye utenga kukwao kuti, “Achalongo achinjetu, iŵaga nkwete maloŵe gagali gose gakwalimbisya mitima ŵandu ŵa, mmechete.” ");
INSERT INTO yao_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nipele, che Paolo ŵajimi, ŵajongwele nkono ni kutanda kuŵecheta, “Ŵanyamwe Ŵaisilaeli achinjangu ni wose unkwalamba Akunnungu, mpilikanichisye! ");
INSERT INTO yao_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Akunnungu ŵa ŵandu Ŵaisilaeli ŵaasagwile achambuje ŵetu, ni kwakusya paŵatamaga kuchilendo ku Misili kula. Ni kwa ukombole wao wekulungwa ŵaakopwesye kweleko. ");
INSERT INTO yao_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ni ŵaapililile mwipululu mula kwa yaka alobaini. ");
INSERT INTO yao_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nipele, ŵasijonasile ngosyo nsano ni siŵili sya mchilambo cha Kanaani ni ŵapele ŵanyawo chilambo cho kuti ajinjilanje majumba. ");
INSERT INTO yao_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yeleyo yatendekwe kwa yaka mia nne na hansini. “Payamasile yele Akunnungu ŵapele ŵakulamula kuti ŵaalongosye mpaka katema ka che Samweli jwakulondola jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ni pelepo ŵasachile kuŵa ni mwenye, ni Akunnungu ŵapele che Sauli mwanagwao che Kishi jwa lukosyo lu che Benyamini aŵe mwenye jwao kwa yaka makumi ncheche. ");
INSERT INTO yao_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Akunnungu paŵantyosisye che Sauli, ŵansagwile che Daudi kuŵa mwenye jwao. Ŵalosisye kwakunda paŵasasile umboni nkati jwelejo paŵatite, ‘Nammweni che Daudi mwanagwao che Yese, mundu jwakuunonyelesya ntima wangu, juchagatendekanye gose gingusaka kugatendekanya.’ ");
INSERT INTO yao_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kutyochela mu lukosyo lu che Daudi Akunnungu ŵaapele Ŵaisilaeli Nkulupusyo, jwelejo ali Che Yesu mpela iŵatite pakulanga. ");
INSERT INTO yao_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Che Yesu akanaŵe kugatanda masengo, ŵalongolele che Yohana achaalalichilaga ŵandu wose ŵa ku Isilaeli aleche sambi ni kubatiswa. ");
INSERT INTO yao_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nkumalisya masengo gakwe, che Yohana ŵaausisye ŵandu, ‘Ana nkuganisya kuti uneji ndili Chiwombosyo? Uneji nganima ŵelewo ŵankwalindilila. Ŵelewo akwika panyuma pangu, ni uneji nganguŵajilwa kugopola migoji ja italawanda yao.’ ");
INSERT INTO yao_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Achalongo achinjangu ŵanli ŵanache ŵa che Iblahimu, ni ŵanyamwe ŵanganimma Ŵayahudi ŵankwalamba Akunnungu! Au utenga wa ukulupusyo wu uiche kukwetu. ");
INSERT INTO yao_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Pakuŵa ŵanyawo ŵakutama ku Yelusalemu pamo ni achakulu ŵao nganiŵamanyilila Che Yesu kuti ali Nkulupusyo, iyoyo nganagamanyilila malembelo ga ŵakulondola ŵa Akunnungu gagakusyomekwa pa Lyuŵa lya Kupumulila lyalili lyose. Kwa ligongo lyo ŵagamalichisye maloŵe ga ŵakulondola ŵa Akunnungu pakwalamula Che Yesu kuŵambikwa pa nsalaba. ");
INSERT INTO yao_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Atamuno nganalisimana liwamba lyakuulagwa, nambo ŵaŵendile che Pilato aulajikwe. ");
INSERT INTO yao_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Paŵamalisisye kupanganya yanayose iyalembekwe mmalembelo yankati ŵelewo, nipele ŵaatulwisye pa nsalaba ni kwasika mu lilembe lya mbugu. ");
INSERT INTO yao_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nambo Akunnungu ŵansyusisye. ");
INSERT INTO yao_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kwa moŵa gamajinji ŵaonekanaga kwa aŵala ŵaŵakwesile nawo kutyochela ku Galilaya kwaula ku Yelusalemu. Nombewo sambano ali ŵaumboni ŵakwe kwa ŵandu ŵa ku Isilaeli. ");
INSERT INTO yao_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ni uweji tuiche pelepa kukwalalichila Ngani Jambone ja chilanga chiŵachiŵisile Akunnungu kwa achambuje ŵetu. ");
INSERT INTO yao_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Akunnungu achimalisisye chilanga cho sambano kwa ligongo lyetu uweji ŵatuli isukulu yao pakwasyusya Che Yesu. Mpela yaitite pakulembekwa mu Sabuli ja kaŵili, ‘Mmweji nli Mwanangu, uneji lelo jino mele Atati ŵenu.’ ");
INSERT INTO yao_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yankati kusyuka ku Che Yesu, kuti ngasawa sooni, Akunnungu ŵatite yelei, ‘Chinampe upile weswela wausyene unalanjile che Daudi.’ ");
INSERT INTO yao_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Elo, ni mwine mwine mu Sabuli akuti, ‘Ngamunneka Jwanswela jwenu aweje.’ ");
INSERT INTO yao_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nambo nginiŵa yele ku che Daudi, pakuŵa che Daudi nsyene ŵatendekenye malinga ni iŵaisachile Akunnungu kutendekanya katema kao, nipele ŵawile ni ŵaasichile mu lilembe lya mbugu pachiŵandi ni achatati ŵao, ni chiilu chao chaosile. ");
INSERT INTO yao_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nambo, jwele juŵasyusikwe ni Akunnungu ngasawola. ");
INSERT INTO yao_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nipele, achalongo achinjangu Ŵaisilaeli, mmanyilile kuti kwa litala li Che Yesu, utenga wa kulecheleswa sambi ukulalichilwa kukwenu, nikuti jwalijose jwakunkulupilila Kilisito akulecheleswa sambi syose, chindu changachikukomboleka kukundikwa kwa litala lya Malajisyo ga Akunnungu gaŵapele che Musa. ");
INSERT INTO yao_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Jwalijose juchankulupilile Jwelejo chaŵalanjikwe ŵambone paujo pa Akunnungu chindu chati Malajisyo ga che Musa ngagakukombola kuchipanganya. ");
INSERT INTO yao_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nipele, nlilolechesye chikansimana chechila chiŵachisasile ŵakulondola ŵa Akunnungu, ");
INSERT INTO yao_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mpilikanichisye ŵanyamwe ŵakulikanganichila, nsimonje nkawe! Pakuŵa chindu chinguchipanganya, mmoŵa ga, chindu cho ngankajitichisye atamuno mundu akansalile.’ ” ");
INSERT INTO yao_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Che Paolo ni che Banaba paŵakopokaga mu nyuumba ja kupopelela jila, ŵandu ŵala ŵaachondelele aichanje sooni kukwasalila maloŵe go, Lyuŵa lya Kupumulila lyalikwika. ");
INSERT INTO yao_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Paŵapwilingene mu nyuumba ja kupopelela mula, Ŵayahudi ŵajinji ni ŵandu ŵangaŵa Ŵayahudi ŵaŵajitichisye dini ja Chiyahudi ŵaakuiye che Paolo ni che Banaba. Ŵanyawo ŵaŵechete nawo, ni kwalimbisya mitima kuti atamanje achikulupililaga upile wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ni Lyuŵa lya Kupumulila liine, ŵandu ŵajinji, chiŵandi kwichila musi wose ŵasongangene kukupilikanila Liloŵe lya Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nambo Ŵayahudi paŵauweni mpingo wa ŵandu wo ŵagumbele wiu, nipele ŵachikanile chichasalaga che Paolo ni kwatukana. ");
INSERT INTO yao_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Atamuno yeleyo, che Paolo ni che Banaba ŵaŵechete pangali lipamba, “Yaŵajilwe kuti Liloŵe lya Akunnungu litande kusalikwa kaje kwa ŵanyamwe. Nambo pakuŵa nlikanile ni kuganisya mwachinsyene kuti, ngankuŵajilwa kukola umi wa moŵa gose pangali mbesi, nipele tukunneka ni kwagalauchila ŵandu ŵangaŵa Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Pakuŵa Ambuje atulajisye yelei, ‘Nambisile mmweji kuŵa lilanguka kwa ŵandu ŵangaŵa Ŵayahudi, kuti ŵandu wose ŵa pachilambo akulupuswe.’ ” ");
INSERT INTO yao_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ŵandu ŵangaŵa Ŵayahudi paŵapilikene yele ŵasengwile, ni kuulapa utenga wa Ambuje, ni ŵandu wose ŵaŵasagulikwe kukola umi wa moŵa gose pangali mbesi, ŵaakulupilile Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Liloŵe lya Ambuje lyajenele mchilambo chila chose. ");
INSERT INTO yao_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nambo Ŵayahudi ŵaachisisye achakongwe ŵakusichila, ŵakwapopela Akunnungu ni achalume ŵakumanyika ŵa mmusi wo. Ni ŵatandite kwalagasya che Paolo ni che Banaba, ni kwaŵinga mchilambo chao. ");
INSERT INTO yao_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nipele, achinduna ŵala ŵakung'undile luundu mmakongolo gao kulosya kuti akanikwe, ni ŵajawile ku Ikonio. ");
INSERT INTO yao_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nambo ŵakulijiganya ŵa Che Yesu ku Antiokia kula ŵasengwile ni kugumbala Mbumu jwa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Nipele, ku Ikonio ko che Paolo ni che Banaba ŵajawile mu nyuumba ja kupopelela Ŵayahudi mpela iŵatite pakusyoŵelela ni kuŵecheta pangali lipamba, mpaka Ŵayahudi ŵajinji ni Ŵagiliki ŵakulupilile. ");
INSERT INTO yao_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nambo Ŵayahudi ŵangakwakulupilila Che Yesu ŵaachisisye ŵandu ŵangaŵa Ŵayahudi kuti ŵaachime che Paolo ni che Banaba. ");
INSERT INTO yao_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Che Paolo ni che Banaba ŵatemi kweleko moŵa gamajinji. Ŵaŵechete pangali lipamba yankati Ambuje, ni Ambuje wo ŵalosisye pangasisa usyene wa utenga waujenesye nkati upile wao, kwa kwakombolechesya kutendekanya imanyisyo ni yakusimonjeka. ");
INSERT INTO yao_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nambo ŵandu wose ŵa musi wo ŵasapulene, ŵane ŵalumbikene ni Ŵayahudi ni ŵane ŵalumbikene ni achinduna ŵala. ");
INSERT INTO yao_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nipele, ŵampepe mwa ŵandu ŵangaŵa Ŵayahudi ni Ŵayahudi pamo ni ilongola ŵao, ŵalamwile kwapanganyichisya yangalumbana achinduna ŵala ni kwaulaga kwa kwaputa maganga. ");
INSERT INTO yao_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Achinduna nkumanyilila yeleyo ni ŵautuchile kuchilambo cha ku Likaonio mmisi ja ku Lisita ni ku Debe, ni ilambo yaili mumbali mwakwe, ");
INSERT INTO yao_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ni ŵajendelechele kwalalichila ŵandu Ngani Jambone mmisi jo. ");
INSERT INTO yao_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ku Lisita ko jwapali mundu juŵaliji jwakulemala, ni jwanganajenda kose chitandile kupagwa kwakwe. ");
INSERT INTO yao_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mundu jo ŵampilikanichisye che Paolo paŵalalichilaga. Nipele che Paolo ŵanlolechesye uchenene, ni paŵaimanyilile kuti akwete chikulupi chakombola kulamwa, ");
INSERT INTO yao_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ŵaŵechete kwa kunyanyisya kuti, “Njime uchenene ni makongolo genu!” Papopo mundu jo ŵasumbile ni kutanda kwenda. ");
INSERT INTO yao_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mpingo wa ŵandu ula paŵachiweni chiŵachipanganyisye che Paolo, ŵatandite kunyanyisya Mchilikaonia achitiji, “Achiminungu atutuluchile chisau ŵandu!” ");
INSERT INTO yao_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Che Banaba ŵaŵilanjikwe Seu ni pakuŵa che Paolo ŵaliji jwakuŵecheta jwankulu, ŵaŵilanjikwe Helime. ");
INSERT INTO yao_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ni jŵambopesi jwa nyuumba ja nnungu Seu jijaliji paasa pa musi, ŵajigele ng'ombe ni uluŵa paujo pa nnango wekulungwa wa musi, nsyene pamo ni mpingo wa ŵandu ula ŵasachile ŵatajile mbopesi che Paolo ni che Banaba. ");
INSERT INTO yao_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nambo che Banaba ni che Paolo paŵajipilikene ngani jo ŵapapwile iwalo yao ni ŵautuchile kwauli mpingo wa ŵandu kula achinyanyisyaga, ");
INSERT INTO yao_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","alinkuti, “Mwanya, ana ligongo chi nkutendekanya yelei? Noweji tuli ŵandu pe mpela ŵanyamwe. Ni sooni tuiche pelepa kukunlalichila Ngani Jambone kuti nneche inyago pe ni kwagalauchila Akunnungu ŵaali ŵajumi, ŵaŵagumbile kwinani ni chilambo ni mbwani ni yose yaili mwelemo. ");
INSERT INTO yao_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kalakala ko Akunnungu ŵaalesile ŵandu wose ŵa pachilambo atendekanye iŵasachile. ");
INSERT INTO yao_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Natamuno yeleyo Akunnungu nganaleka kulilosya kwakwapanganyichisya yambone, achanyesyesyaga ula kutyochela kwinani ni kwapa masika gambone kwa katema kakwe, akumpa yakulya ni kungumbasya kusengwa mmitima jenu.” ");
INSERT INTO yao_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Namuno achinduna ŵala ŵatite yeleyo, yalemile kwalekasya ŵandu ŵala akasaŵatajila mbopesi. ");
INSERT INTO yao_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nambo ŵaiche Ŵayahudi ŵampepe kutyochela ku Antiokia ni ku Ikonio, ni ŵanyenjile ŵandu ŵapanganyichisye yangalimate che Paolo ni che Banaba. Ni ŵamponyile che Paolo maganga ni kwautila paasa musi achiganisyaga kuti awile. ");
INSERT INTO yao_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nambo ŵandu ŵakwakulupilila Che Yesu paŵansyungwile, ŵajimwiche ni kwinjila mmusi. Malaŵi jakwe ŵatyosile pamo ni che Banaba kwaula ku Debe. ");
INSERT INTO yao_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Che Paolo ni che Banaba ŵaalalichile ŵandu Ngani Jambone ku Debe ko ni kwapata ŵakulijiganya ŵajinji, nipele ŵaujile ku Antiokia achipitilaga ku Lisita ni ku Ikonio. ");
INSERT INTO yao_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ni ŵaalimbisye ŵandu ŵakunkulupilila Che Yesu ŵa misi jo ni kwatulasya ntima kuti atame mchikulupi nkulimbangana. Ni ŵaasalile, “Tukusachilwa kugapitila masausyo gamajinji kuti tujinjile mu Umwenye wa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Che Paolo ni che Banaba paŵamasile kwasagula achakulu mu kila mpingo wa ŵandu ŵakunkulupilila Kilisito, ŵapopele ni kutaŵa nipele ŵaapopelele kwa Ambuje ŵaŵakulupilile kuti chiŵaagose. ");
INSERT INTO yao_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Che Paolo ni che Banaba paŵapitaga ku Pisidia ŵaiche ku chilambo cha Pamfilia. ");
INSERT INTO yao_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Paŵamasile kulalichila Ngani Jambone kwa ŵandu ŵa ku Pega, ŵatuluchile ku Atalia. ");
INSERT INTO yao_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kutyochela ku Atalia ŵajendelechele ni ulendo kwa ngalaŵa jajikulungwa ni kuuja ku Antiokia kuŵaŵisilwe mmakono ga Akunnungu ni kupegwa upile kwa ligongo lya masengo gagali gamamale. ");
INSERT INTO yao_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Che Paolo ni che Banaba paŵaiche ku Antiokia ko, ŵasongangenye mpingo wa ŵandu ŵakunkulupilila Kilisito ŵa pelepo, nipele ŵaasalile yanayose iŵaitesile Akunnungu pamo nawo, ni iŵatite pakwaugulila litala ŵandu ŵangaŵa Ŵayahudi ŵakulupilile Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nipele ŵatemi kweleko moŵa gamajinji pamo ni ŵandu ŵakunkulupilila Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ŵaiche ŵandu ŵane ku Antiokia kutyochela ku Yudea ni kutanda kwajiganya achalongo ŵala achitiji, “Iŵaga ngammumbala malinga ni chisyoŵelo chiŵalamwile che Musa, ngankombola kukulupuka.” ");
INSERT INTO yao_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Che Paolo ni che Banaba ŵakanilanaga nawo yankati ngani jo, nipele ŵaasagwile che Paolo ni che Banaba pamo ni mpingo wa ŵandu ŵakunkulupilila Kilisito ŵampepe ŵa ku Antiokia ko ajaulangane kwa achinduna ni achachekulu ku Yelusalemu kukukunguluchila ngani jo. ");
INSERT INTO yao_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nipele mpingo wa ŵandu ŵakunkulupilila Kilisito ŵala ŵaalanjile, ni ŵanyawo ŵapite ku Foinike ni ku Samalia achisalaga yankati ŵandu ŵangaŵa Ŵayahudi iŵatite pakwagalauchila Akunnungu. Ni ngani jo jaasengwasisye nnope ŵandu ŵakunkulupilila Kilisito. ");
INSERT INTO yao_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Paŵaiche ku Yelusalemu, mpingo wa ŵandu ŵakunkulupilila Kilisito ni achinduna ni achachekulu ŵaapochele ŵanyawo, nombewo ŵaasalile yanayose iŵaitesile Akunnungu pamo nawo. ");
INSERT INTO yao_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ni ŵandu ŵakunkulupilila Kilisito ŵane ŵa mpingo wa Mafalisayo ŵajimi ni kuti, “Iŵajilwe ŵandu ŵangaŵa Ŵayahudi kwaumbasya ni kwajiganya kugakamulichisya Malajisyo ga Akunnungu gaŵapele che Musa.” ");
INSERT INTO yao_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nipele achinduna ni achachekulu ŵasongangene kuti asosesose yankati liloŵe lyo. ");
INSERT INTO yao_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Paŵapundaga kuusyausyana, che Petulo ŵajimi ni kuti, “Achalongo achinjangu, mwachinsyene nkumanyilila kuti moŵa gagapite Akunnungu yanonyele kuusagula une pasikati jenu nalichile Ngani Jambone kwa ŵandu ŵangaŵa Ŵayahudi, kuti apilikane ni kukulupilila. ");
INSERT INTO yao_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nombe Akunnungu ŵakujimanyilila mitima ja ŵandu wose, ŵalosisye pangasisa kuti ŵapochele pakwapa Mbumu jwa Akunnungu mpela iŵatite pakutupa uweji. ");
INSERT INTO yao_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nganatenda lusagu pasikati jetu ni ŵanyawo, ŵajiswejesye mitima jao ligongo ŵakulupilile. ");
INSERT INTO yao_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Sambano, ana ligongo chi nkwalinga Akunnungu? Ana kwa chichi nkulinga kwatwika ŵakulijiganya ŵala misigo jakutopa janganakombola kutwichila achambuje ŵetu natamuno uweji? ");
INSERT INTO yao_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ikaŵaga yeleyo, nambo tukukulupilila kuti tutukulupuswe ni upile wa Ambuje Che Yesu, mpela ŵanyawo yakuti pakukulupilila.” ");
INSERT INTO yao_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Mpingo wose wamyalele ni kwapilikanila che Banaba ni che Paolo ŵaŵaliji nkwatanjila imanyisyo ni yakusimonjeka yose yaitesile Akunnungu ni makono gao mwa ŵandu ŵangaŵa Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Paŵamyalele, ŵatandite kuŵecheta che Yakobo kuti, “Achalongo achinjangu, mumbilikanile, ");
INSERT INTO yao_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Che Simoni jwakuŵilanjikwa che Petulo atusalile iŵatite Akunnungu kundanda pakwalola ŵandu ŵangaŵa Ŵayahudi ni kwasagula ŵampepe mwa ŵelewo kuti aŵeje ŵao. ");
INSERT INTO yao_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Chelechi chikwilana ni maloŵe ga ŵakulondola ŵa Akunnungu mpela Malembelo ga Akunnungu yagakuti pakusala, ");
INSERT INTO yao_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Akunnungu akuti ‘Pakumala yelei chinjiuja, ni kutaŵa sooni lisakasa li che Daudi lilyagwile, chinjikolosya masame gakwe ni kutaŵa sooni. ");
INSERT INTO yao_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Pelepo ŵandu ŵaŵasigele wose, ŵandu ŵangaŵa Ŵayahudi wose unaŵilasile aŵeje ŵandu ŵangu chiŵasose Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ambuje ni iyakuti pakusala, ŵelewo ni ŵaŵatesile yelei imanyiche chitandile kalakala ko.’ ” ");
INSERT INTO yao_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Che Yakobo ŵapundile kuŵecheta, “Une ngulamula kuti, tukaasakalisya ŵandu ŵangaŵa Ŵayahudi ŵakwagalauchila Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nambo twalembele chikalata ni kwasalila kuti analye yakulya yaitajikwe mbopesi ku inyago, aleche chikululu ni akalya inyama yakupopotola ni kuleka kulya miasi. ");
INSERT INTO yao_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Pakuŵa chitandile kalakala Malajisyo ga Akunnungu gaŵapele che Musa galiji nkusyomekwa moŵa gose mmajumba ga kupopelela pa Lyuŵa lya Kupumulila lyalili lyose ni kulalichilwa mmisi jajili jose.” ");
INSERT INTO yao_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nipele, achinduna ni achachekulu pamo ni mpingo wa ŵandu ŵakunkulupilila Kilisito wose ŵa ku Yelusalemu ŵalamwile kwasagula ŵandu ŵampepe mwa achinsyene pe ni kwalajisya ku Antiokia pamo ni che Paolo ni che Banaba. Nipele ŵaasagwile che Yuda pane akummilanga che Balisaba ni che Sila, ŵanyawo ŵaliji ilongola mwa ŵa ŵandu ŵaŵankulupilile Kilisito. ");
INSERT INTO yao_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nipele ŵapele chikalata chichalembekwe yele, “Uweji achinduna ni achachekulu, achalongo achinjenu, tukunkomasya mwanya achalongo achinjetu ŵandu ŵangaŵa Ŵayahudi ŵa Ku Antiokia ni ku Silia ni ku Kilikia. ");
INSERT INTO yao_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tupilikene kuti ŵandu ŵane ŵaŵatyosile kukwetu uwe ŵansakalisye ŵanyamwe ni kuntaga lipamba mitima jenu kwa maloŵe gao. Nambo ŵanyawo nganitwatuma kose. ");
INSERT INTO yao_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nipele, tujilene kwa pamo kwasagula ŵandu ŵampepe ni kwatuma kukwenu pamo ni ŵakunonyelwa ŵetu che Banaba ni che Paolo, ");
INSERT INTO yao_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ŵandu ŵautyosisye umi wao kwaligongo lya masengo ga Ambuje ŵetu Che Yesu Kilisito. ");
INSERT INTO yao_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nipele, twatumile che Yuda ni che Sila kukwenu, ŵele ŵanyawo chansalile itulembile yo kwa kang'wa syao. ");
INSERT INTO yao_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Pakuŵa Mbumu jwa Akunnungu pamo ni uweji tujitichisye kuti tukaatwika nsigo wine wakutopela kupunda ayi inkusachilwa kuimanyilila. ");
INSERT INTO yao_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nkalya yakulya yaitajikwe mbopesi ku inyago ni nkalya miasi ni nkalya nyama ja inyama yakupopotola ni nneche chikululu. Chintende yambone naga chintende yeleyo, ntame kwa chitendewele.” ");
INSERT INTO yao_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Paŵalanjile, ŵanyawo ŵatyosile ku Yelusalemu ni kutuluchila ku Antiokia, kwele ŵauŵilasile pamo mpingo wa ŵandu ŵakunkulupilila Kilisito wose, ni kwapa chikalata chila. ");
INSERT INTO yao_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ni paŵachisyomile chikalata chila, ŵasangalele kwannope ligongo maloŵe gakwe gaatulesye mitima. ");
INSERT INTO yao_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Che Yuda ni che Sila ŵaŵaliji ŵakulondola ŵa Akunnungu, ŵaajamwiche achalongo kwa maloŵe gamajinji ni kwalimbisya ŵandu ŵakukulupilila. ");
INSERT INTO yao_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Paŵatemi moŵa gampepe ku Antiokia, ŵandu ŵakunkulupilila Kilisito ŵaalanjile ajaulangane kwa chitendewele, kuuja kwa ŵaŵatumile ŵala. ");
INSERT INTO yao_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nambo che Sila ŵasachile kusigala. ");
INSERT INTO yao_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Che Paolo ni che Banaba ŵasigele ku Antiokia kwa moŵa, achijiganyaga ni kulalichila Liloŵe lya Ambuje pamo ni ŵandu ŵane. ");
INSERT INTO yao_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pagapite moŵa gampepe, che Paolo ŵansalile che Banaba, “Twende tuuje, tukaalole achinjetu ŵakunkulupilila Che Yesu ŵala ku misi jajili jose kutwalalichile Liloŵe lya Ambuje ni kulola yakuti pakwendelechela.” ");
INSERT INTO yao_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nipele, che Banaba ŵasachile kwajigala che Yohana Maliko kuti alongane nawo. ");
INSERT INTO yao_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nambo che Paolo nganasaka kulongana ni che Maliko, ligongo ŵanlesile ku Pamfilia kundanda ni nganasaka kukamulangana pa masengo gao. ");
INSERT INTO yao_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nipele, ŵakanilene kwannope ni kulekangana matala. Che Banaba ŵalongene ni che Maliko, ŵakwesile ngalaŵa ni kwaula ku Kupulo. ");
INSERT INTO yao_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nombe che Paolo ŵansagwile che Sila, ni ŵandu ŵakwakulupilila Che Yesu ŵa pelepo ŵampopelele apegwe upile wa Ambuje ni kwaula. ");
INSERT INTO yao_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ni mu ulendo wo ŵajesile mu ilambo ya ku Silia ni ku Kilikia achalimbisyaga mipingo ja ŵandu ŵakunkulupilila Kilisito mu ilambo yo. ");
INSERT INTO yao_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Che Paolo ŵaiche ku Debe ni ku Lisita, kweleko ŵatemi mundu jwakunkuya Che Yesu liina lyakwe che Timoseo. Achikulugwe che Timoseo ŵaliji Myahudi nombejo ŵaliji mundu jwakwakulupilila Che Yesu, nambo atatigwe ŵaliji Mgiliki. ");
INSERT INTO yao_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Che Timoseo ŵakunguluchilwaga umboni wambone ni ŵandu ŵakunkulupilila Kilisito ŵa ku Lisita ni ku Ikonio. ");
INSERT INTO yao_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Che Paolo ŵasachile kunjigala che Timoseo mu ulendo wao, nipele ŵambumbesye. Ŵatesile yeleyo ligongo lya Ŵayahudi ŵaŵaliji mu ilambo mo pakuŵa wose ŵamanyilile kuti atatigwe che Timoseo ŵaliji Mgiliki. ");
INSERT INTO yao_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Paŵapitaga mmisi jila ŵapele ŵandu malajisyo gaŵakopwesye achinduna ni achachekulu ku Yelusalemu kula ni kwasalila kuti agakamulichisye. ");
INSERT INTO yao_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nipele, mipingo ja ŵandu ŵakunkulupilila Kilisito japundile kulimbangana mu chikulupi, ni winji wa ŵandu ŵakunkulupilila Che Yesu wajonjesyeche lyuŵa ni lyuŵa. ");
INSERT INTO yao_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Che Paolo ni achinjakwe ŵapite mu ilambo ya ku Filigia ni ku Galatia ligongo Mbumu jwa Akunnungu ŵakanyisye akaalalichila ŵandu utenga wo mu chilambo cha ku Asia. ");
INSERT INTO yao_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Paŵaiche mmipika ja ku Misia, ŵasachile kwaula ku Bisinia, nambo Mbumu ju Che Yesu ŵakanyisye. ");
INSERT INTO yao_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nipele ŵapelengenye Misia ni kutuluchila ku Tuloa. ");
INSERT INTO yao_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Chilo chichocho pecho, che Paolo ŵaiweni yakuwona yati, mundu jwa ku Makedonia ŵajimi achachondelelaga achitiji, “Njomboche, nnyiche ku Makedonia kuntukamusye.” ");
INSERT INTO yao_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Che Paolo paŵagaweni gelego mu yakuwona, papopo twaliŵichile chile kwaula ku Makedonia pakuŵa twaiweni kuti Akunnungu atuŵilasile tukaalalichile ŵandu Ngani Jambone. ");
INSERT INTO yao_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kutyochela ku Tuloa twajesile ni ngalaŵa mpaka ku Samotalaki, malaŵi jakwe twaiche ku Neapoli. ");
INSERT INTO yao_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kutyochela kweleko, twajawile mpaka ku Filipi musi wekulungwa wa chilambo cha ku Makedonia ni sooni musi wo waliji musi wautaŵikwe ni Ŵaloma. Twatemi mmusi mo kwa moŵa gampepe. ");
INSERT INTO yao_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pa lyuŵa lya Kupumulila twakopweche paasa musi ni twajawile kungulugulu lusulo kutwaganisyaga kuti kwana kwakupopelela. Twatemi ni kukunguluka ni achakongwe ŵaŵasongangene pelepo. ");
INSERT INTO yao_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mwa ŵaŵatupikanilaga ŵala jwapali jwankongwe jwakwapopela Akunnungu liina lyao che Lidia jwa musi wa ku Siatila, juŵasumisyaga iwalo ya ntengo. Ambuje ŵaugwile ntima wakwe kuti akamulisye iŵaŵechetaga che Paolo yo. ");
INSERT INTO yao_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Che Lidia paŵabatiswe pamo ni ŵaali mu nyuumba jakwe, ŵatuchondelele achitiji, “Iŵaga nkulola kuti ngwakulupilila Ambuje, njinjilanje mu nyuumba jangu ni kutama mwelemo.” Ni ŵatuchisisye tujaule. ");
INSERT INTO yao_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lyuŵa limo patwajaulaga kwiuto kwa mapopelelo kula, twasimene ni kapolo mwali jwana lisoka lya kulondola. Mwali jo ŵaliji nkwapa achambujegwe mbiya syesijinji kwa ulondole wakwe. ");
INSERT INTO yao_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nipele mwali jo ŵankuiye che Paolo noweji achinyokonyaga kuti, “Ŵandu ŵa ali achikapolo ŵa Akunnungu Ŵakulu. Akunsalila ichinjile pakukulupuswa.” ");
INSERT INTO yao_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Yeleyo ŵatendaga moŵa gamajinji, mbesi lyuŵa limo che Paolo yachimile ni ŵangalauchile ni kulisalila lisoka lyo, “Ngunlamula kwa ulamusi u Che Yesu Kilisito nkopoche mwa mwali ju!” Papopo lisoka lyo lyakopweche. ");
INSERT INTO yao_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nambo achambujegwe mwali jo paŵaiweni kuti chilolelo chao chakupata ipanje chimasile, ŵaakamwile che Paolo ni che Sila ni kwakwekwelemya mpaka pakusumichisya malonda, mmbujo mwa achakulu ŵa musi. ");
INSERT INTO yao_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nipele ŵaapeleche kwa ŵamalamulo achitiji, “Ŵandu ŵa ali Ŵayahudi ŵakuutindiganya musi wetu. ");
INSERT INTO yao_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Akwiganya masyoŵelo gangaŵajilwa mmalajisyo getu uweji ŵatuli Ŵaloma ngatukukombola kwajitichisya atamuno kuipanganya.” ");
INSERT INTO yao_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mpingo wa ŵandu walumbikene ni kwaputa che Paolo ni che Sila, nipele ŵamalamulo ŵala ŵaausile che Paolo ni che Sila iwalo yao ni kwalamula aputikwe mbokola. ");
INSERT INTO yao_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Paŵamasile kwaputa kwannope ŵaaŵisile mu nyuumba jakutaŵilwa ni kunlajisya jwakulindilila nyuumba jakutaŵilwa kuti ŵaagose uchenene. ");
INSERT INTO yao_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nombe paŵagapochele malajisyo gala, ŵaaŵisile che Paolo ni che Sila mu chuumba cha munkati nnope mu nyuumba jakutaŵilwa jila ni ŵaataŵilile makongolo gao pa likongwa. ");
INSERT INTO yao_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nambo pasikati chilo che Paolo ni che Sila ŵaliji nkwapopela Akunnungu ni kwajimbila nyimbo sya kwalapa ŵaŵataŵikwe ŵane ŵala ŵaliji nkwapikanila. ");
INSERT INTO yao_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Chisisimuchile chakopochele chindendemesi chekulungwa cha lisi chati misingi ja nyuumba jakutaŵilwa jatinganyiche. Papopo minango jose jaugwiche ni minyolo jijaataŵile ŵaŵataŵikwe ŵala jakutwiche. ");
INSERT INTO yao_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Jwakulindilila nyuumba jakutaŵilwa jula paŵajimwiche ni kujiwona minango ja nyuumba jeugule ŵaganisisye kuti ŵaŵataŵikwe wose ŵatisile. Nipele ŵasolomwele upanga wakwe, ŵatiji aliulaje. ");
INSERT INTO yao_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nambo che Paolo ŵambilasile kwa liloŵe lyekulungwa, “Nkaliulaga pakuŵa wose tuli mmumu.” ");
INSERT INTO yao_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Jwakulindilila nyuumba jakutaŵilwa jula paŵaŵendile apegwe lumuli, ŵaguluchile nkati ni kugwa mmbujo pa makongolo ga che Paolo ni che Sila achitetemelaga kwa lipamba. ");
INSERT INTO yao_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nipele ŵaajigele che Paolo ni che Sila ni kwakoposya paasa ni kwausya, “Achambuje, ana ikuumajila kupanganya chichi pakuti ngulupuche?” ");
INSERT INTO yao_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Che Paolo ni che Sila ŵajanjile, “Mwakulupilile Ambuje Che Yesu, ni pachinchikulupuswa mmwejo ni ŵaali mu nyuumba jenu.” ");
INSERT INTO yao_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nipele che Paolo ni che Sila ŵanlalichile Liloŵe lya Ambuje jwakulindilila jo pamo ni wose ŵaali mu nyuumba jakwe. ");
INSERT INTO yao_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Katema kakoko ka chilo jwakulindilila jwa nyuumba jakutaŵilwa jo ŵaajigele che Paolo ni che Sila ni kugajosya maŵanga gao. Nipele ŵabatiswe jwakulindilila pamo ni wose ŵaali mu nyuumba jakwe. ");
INSERT INTO yao_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nipele jwakulindilila jwa nyuumba jakutaŵilwa jo ŵaajigele che Paolo ni che Sila ni kwajausya ku nyuumba jakwe ni ŵapele chakulya. Ni nsyene pamo ni ŵaali mu nyuumba jakwe ŵasangalele kwannope pakuŵa sano akwakulupilila Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pakwachele ŵamalamulo ŵa Chiloma ŵalajisye achakulu ŵa ŵakulindilila nyuumba jakutaŵilwa achitiji, “Mwalechele ŵandu ŵala ajaulangane.” ");
INSERT INTO yao_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Jwakulindilila nyuumba jakutaŵilwa jula ŵansalile che Paolo ngani jo achitiji, “Ŵamalamulo alajisye utenga kuti alakwe ni che Sila nlecheleswe. Sambano njaule kwa chitendewele.” ");
INSERT INTO yao_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nambo che Paolo ŵansalile jwankulu jwa ŵakulindilila jo, “Nkuti uli? Nachiŵamuno nganitukola magambo, atuputile mbokola pelanga akuno uweji tuli Ŵaloma. Sooni ŵatuŵisile mu nyuumba jakutaŵilwa ni sambano ana akutukoposya kwachisyepela? Ngwamba! Akusachilwa aichanje achinsyene kukutukoposya.” ");
INSERT INTO yao_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Achakulu ŵa ŵakulindilila ŵala ŵajawile kukwasalila ŵamalamulo yankati ngani jo, ni ŵamalamulo ŵala paŵapilikene kuti che Paolo ni che Sila ŵaliji Ŵaloma, ŵajogwepe. ");
INSERT INTO yao_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nipele, ŵaiche ni kwachondelela ŵanyawo kuti ŵalechelesye ni paŵakopwesye ŵachondelele kuti akopoche pa musi wo. ");
INSERT INTO yao_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Che Paolo ni che Sila ŵakopweche mu nyuumba jakutaŵilwa ni kwaula ku nyuumba ji che Lidia. Kweleko ŵasimene ni ŵandu ŵakunkulupilila Che Yesu ŵakamulisye mitima ni ŵatyosile. ");
INSERT INTO yao_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nipele che Paolo ni che Sila ŵapelengenye ku Amfipoli ni ku Apolonia, ni ŵaiche ku Sesalonike kujaliji nyuumba ja kupopelela ja Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ni che Paolo malinga ni masyoŵelo gakwe ŵalumbikene nawo ni kuusyausyana nawo nkati Malembelo ga Akunnungu kwa moŵa gatatu ga Lyuŵa lya Kupumulila. ");
INSERT INTO yao_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ŵaagopolele ni kwasalila pangasisika kuti yaŵajilwe Kilisito asauche ni kusyuka. Ŵaasalile, “Aŵa Che Yesu ŵangwajenesya kukwenu, ŵelewo ali Kilisito.” ");
INSERT INTO yao_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ŵane mwa ŵanyawo ŵakulupilile ni ŵalumbikene ni che Paolo ni che Sila. Ni sooni, mpingo wekulungwa wa Ŵagiliki ŵaŵaliji nkwapopela Akunnungu ni achakongwe ŵakuchimbichikwa ŵajinji ŵaakulupilile Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nambo Ŵayahudi ŵagumbele wiu ni ŵaajigele ŵandu ŵangalumbana ŵa pakusumichisya malonda ni ŵalumbikene pamo ni kutanda kutindiganya pamusi pose. Ŵajijimuchile nyuumba ji che Yasoni achiganisyaga kuti chiŵasimane che Paolo ni che Sila mwelemo kuti ŵakoposye kwa ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nambo nganiŵasimana, nipele ŵaajigele che Yasoni pamo ni ŵandu ŵane ŵakunkulupilila Che Yesu ni kwakwekwelemya mpaka kwa achakulu ŵa musi achinyanyisyaga kuti, “Ŵandu ŵa akutindiganya chilambo chose ni sano alinji pamusi pano. ");
INSERT INTO yao_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Che Yasoni ŵaapochele mu nyuumba jao. Wose akukananga kugakuya malajisyo ga Mwenye jwa ku Loma achitiji, eti, ‘Apali mwenye jwine jwakuŵilanjikwa Che Yesu.’ ” ");
INSERT INTO yao_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Achakulu ŵa musi pamo ni mpingo wa ŵandu ula paŵagapilikene maloŵe go yatindigenye mu ntwe. ");
INSERT INTO yao_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nipele ŵaatesile che Yasoni ni achinjakwe atyosye chikole ni ŵalesile ajaulangane. ");
INSERT INTO yao_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Chilo, ŵandu ŵakunkulupilila Che Yesu ŵa ku Sesalonike ŵala ŵachisisye che Paolo ni njakwe che Sila ajaulangane ku Belea. Ni ŵanyawo paŵaiche kweleko ŵajinjile mu nyuumba ja kupopelela ja Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nambo, ŵandu ŵa ku Belea ŵaliji ŵakupilikanichisya nnope kupunda ŵa ku Sesalonike. Ŵalipochele Liloŵe lya Akunnungu kwa lung'wanu lwekulungwa ni moŵa gose ŵaliji nkugalolechesya lolechesya Malembelo ga Akunnungu kanga yaŵaiŵechetaga che Paolo yo yaliji isyenesyene. ");
INSERT INTO yao_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ŵayahudi ŵajinji ŵakulupilile pamo ni achakongwe ni achalume ŵa Chigiliki ŵakuchimbichikwa. ");
INSERT INTO yao_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nambo Ŵayahudi ŵa ku Sesalonike paŵaimanyi kuti che Paolo ŵaliji nkulalichila Liloŵe lya Akunnungu ku Belea ko, ŵajawile kweleko nombe ni kutanda kutindiganya ni kujichisya mipingo ja ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Papopo ŵandu ŵakunkulupilila Che Yesu ŵapechesye che Paolo ku mbwani nambo che Sila ni che Timoseo ŵasigele ku Belea. ");
INSERT INTO yao_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ŵandu ŵaŵampechesye che Paolo ŵala ŵampechesye mpaka ku Asene. Nombewo ŵausile ku Belea ali ni malajisyo kutyochela ku che Paolo gagakuti che Sila ni che Timoseo ŵakuye chitema pe. ");
INSERT INTO yao_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Che Paolo paŵaliji ku Asene nkwalindilila ŵanya che Sila ni che Timoseo, yachimile nnope muntima mwao pakuŵa ŵauweni musi wo ugumbele inyago ya achiminungu. ");
INSERT INTO yao_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nipele ŵausyeneusyene ni Ŵayahudi ni ŵandu ŵangaŵa Ŵayahudi ŵaŵaliji nkwalamba Akunnungu mu nyuumba ja kupopelela, lyuŵa ni lyuŵa ŵausyeneusyene ni ŵandu ŵaŵasimanaga nawo pakusumichisya malonda. ");
INSERT INTO yao_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ŵandu ŵaŵalijigenye lunda lwa Chiepikulo ni Chisitoiki ŵatesile makani ni che Paolo. Ŵane ŵatite, “Ana ujinga chi wakuusala mundu ju?” Ŵane ŵatite, “Akuwoneka mpela akulalichila ngani ja achiminungu achalendo.” Ŵatite yeleyo pakuŵa che Paolo ŵaliji nkulalichila ngani ji Che Yesu ni yatite kusyuka, ");
INSERT INTO yao_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nipele ŵanjigele che Paolo ku Aleopago achitiji, “Tukusaka tukombole kugamanyilila gele majiganyo gasambano ginkusala ga. ");
INSERT INTO yao_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Indu ine itwipilikene mmawiwi getu ikuwoneka kuŵa ya chilendo kukwetu. Nipele tukusaka kugamanyilila malumbo ga yele indu yo.” ");
INSERT INTO yao_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ŵandu ŵa ku Asene ni achalendo wose ŵakulonjela kweleko ŵajigele katema kakajinji kutagula ni kupilikanila ngani ja sambano. ");
INSERT INTO yao_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nipele che Paolo ŵajimi paujo pa nkungulu wa Aleopago ni kuti, “Ŵanyamwe ŵandu ŵa ku Asene, nguwona kuti ŵanyamwe nli ŵandu ŵa dini nnope, ");
INSERT INTO yao_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","pakuŵa panaliji nkwendajenda akuno ni akunokuno napaweni peuto pankutyochesya mbopesi, ni sooni nachisimene chilisa chimo chilembekwe, ‘Kwa Akunnungu ŵangamanyika.’ Nipele ngunlalichila ŵanyamwe chele chindu chinkuchipopelela pangachimanyilila. ");
INSERT INTO yao_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Akunnungu ŵaŵachigumbile chilambo ni yose yaili mwelemo, ŵelewo ni Ambuje ŵa kwinani ni chilambo chino, ŵelewo ngakutama mmajumba ga Akunnungu getaŵe ni ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Sooni ngakutumichilwa ni makono ga ŵandu ni ngakuchisaka chachili chose, pakuŵa asyene akwapa ŵandu wose umi ni kwakombolechesya kupumula ni kwapa indu yose. ");
INSERT INTO yao_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kutyochela mwa mundu jumo ŵapanganyisye ŵandu wose ŵa pachilambo pano ni kwakombolechesya kutama palipose pachilambo pano. Ŵalamwile kutyochela kundanda katema chi ni papi pachatame ŵandu wo. ");
INSERT INTO yao_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ŵatesile yeleyo kuti ŵandu ŵa ilambo yo ŵasoseje Akunnungu namuno kwakwapapasya ŵasimane. Natamuno yeleyo Akunnungu ngakutalikangana ni jwalijose. ");
INSERT INTO yao_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mpela ila mundu jumo iŵatite pakusala, ‘Mwa ŵelewo uweji tukwete umi, tukwenda ni kutama!’ Mpela ila ŵakwimba ŵenu ŵane, ŵatite, ‘Uweji wose tuli ŵanache ŵao.’ ");
INSERT INTO yao_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nipele pakuŵa tuli ŵanache ŵao Akunnungu, ngaikuŵajilwa kuganisya kuti Akunnungu akulandana ni sahabu ni madini ga mbiya atamuno liganga lyesepe uchenene kwa lunda lwa ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ndema sya ungamanyilila wao, Akunnungu ŵalitesile nti ngakulola. Nambo sambano akulajisya kuti ŵandu wose ŵa palipose aleche sambi. ");
INSERT INTO yao_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Pakuŵa aŵisile lyuŵa lichiŵalamule ŵandu ŵa pachilambo kwa goloka, kwa litala lya mundu jumo jwansagwile. Nombe Akunnungu ŵaalosisye pangasisa ŵandu wose ngani ji, pakunsyusya mundu jo!” ");
INSERT INTO yao_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nipele paŵampilikene che Paolo achiŵechetaga yankati kusyuka kwa ŵawe, ŵane mwa ŵanyawo ŵatesile chanache, nambo ŵane ŵatite, “Tukusaka tumpikanile sooni nkati yeleyo.” ");
INSERT INTO yao_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Che Paolo ŵatyosile pankungulu ni kwalekanga. ");
INSERT INTO yao_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nambo ŵandu ŵampepe ŵalongene nawo ni kwakulupilila Che Yesu. Mwa ŵandu wo ŵapali che Dionisio jumo jwa mpingo waukuŵilanjikwa Aleopago ni jwankongwe liina lyakwe che Damali ni ŵandu ŵane. ");
INSERT INTO yao_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Payamasile yeleyo, che Paolo ŵatyosile ku Asene ni kwaula ku Kolinto. ");
INSERT INTO yao_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ku Kolinto ko ŵansimene Myahudi jumo jwa ku Ponto liina lyakwe che Akila. Che Akila ŵaliji pamo ni ŵankwawo jwakuŵilanjikwa che Pilisila, ni mmoŵa gagogo pego ŵausile kutyochela ku Italia pakuŵa mwenye che Kilaudio ŵalamwile kuti Ŵayahudi wose atyoche ku Loma. Che Paolo ni ŵajawile kukwalola, ");
INSERT INTO yao_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ni pakuŵa masengo gao galiji gamo, masengo gakutota mahema, che Paolo ŵatemi nawo ni kupanganya masengo. ");
INSERT INTO yao_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Lyuŵa lya Kupumulila lili lyose che Paolo ŵaŵechetesyene ni ŵandu mu nyuumba ja kupopelela achilingaga kwachisya Ŵayahudi ni Ŵagiliki. ");
INSERT INTO yao_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Che Sila ni che Timoseo paŵaiche kutyochela ku Makedonia, che Paolo ŵalityosisye kwa katema kakajinji kulalichila Liloŵe achalosyaga pangasisa Ŵayahudi kuti Che Yesu ali Chiwombosyo. ");
INSERT INTO yao_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nambo paŵankanile ni kuntukana, che Paolo ŵakung'undile luundu mu iwalo yao paujo pao ni kuti, “Mwajonasikaga, chinnyimanyilile mwachinsyene, uneji nganingola magambo. Ni kutandila sambano chinaajaulile ŵandu ŵangaŵa Ŵayahudi.” ");
INSERT INTO yao_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nipele che Paolo ŵatyosile kweleko ni kwaula kutama mu nyuumba ja mundu jumo jwangaŵa Myahudi, juŵaajogopaga Akunnungu, mundu jo liina lyakwe che Tito Yusto, nyuumba jao jaŵandikene ni nyuumba ja kupopelela. ");
INSERT INTO yao_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Che Kilispo, juŵaliji jwankulu jwa nyuumba ja kupopelela jila pamo ni ŵaali mu nyuumba jao wose ŵaakulupilile Ambuje. Ŵakolinto ŵajinji ŵaupilikanile utenga wo nipele ŵakulupilile ni kubatiswa. ");
INSERT INTO yao_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Chilo chimo Ambuje ŵansalile che Paolo mu yakwiwona, “Kasinjogopa, nlimbile kulalichila pe ni nkaleka kupanganya chinkuchipanganya cho, ");
INSERT INTO yao_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","pakuŵa uneji nansyene ndili pamo nomwe. Ngapagwa jwalijose juchalinje kumpoteka pakuŵa pamusi wu ngwete ŵandu ŵajinji.” ");
INSERT INTO yao_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nipele, che Paolo ŵatemi kweleko chaka ni miesi nsano ni umo achajiganyaga ŵandu Liloŵe lya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nambo katema che Galio paŵaliji jwankulu jwa chilambo cha Akaya, Ŵayahudi ŵasimene, ŵankamwile che Paolo ni kunjausya ku nkungulu. ");
INSERT INTO yao_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ni ŵatite, “Mundu ju akwachisya ŵandu ŵapopelele Akunnungu pangagakuya Malajisyo ga Akunnungu gaŵapele che Musa.” ");
INSERT INTO yao_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Che Paolo akanaŵe kuŵecheta, che Galio ŵaasalile Ŵayahudi, “Mpilikanile ŵanyamwe Ŵayahudi! Ikaliji isyene mundu ju aleŵile pane atesile yangalumbana ngampilikanichisye. ");
INSERT INTO yao_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nambo iŵaga makani ga gali gankati maloŵe ni meena ni malajisyo genu, nlamule mwachinsyene. Uneji ngangusaka kuŵa jwakulamula jwa indu yo!” ");
INSERT INTO yao_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nipele ŵaaŵinjile ŵanyawo akopoche pa nkungulu. ");
INSERT INTO yao_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ni ŵandu wose ŵankamwile che Sositene juŵaliji jwankulu jwa nyuumba ja kupopelela jila ni ŵamputile palapala paujo pa nkungulu ula. Nambo che Galio nganaikosya yeleyo. ");
INSERT INTO yao_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Che Paolo ŵatemi ni ŵandu ŵakunkulupilila Che Yesu ŵala ku Kolinto ko moŵa gamajinji. Nipele ŵaalanjile, ŵakwesile ngalaŵa pamo ni che Pilisila ni che Akila ni kwaula ku Silia. Paŵaiche ku Kenkelea, che Paolo ŵamyosile umbo syao mu ntwe ligongo ŵataŵile nasili. ");
INSERT INTO yao_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ni ŵaiche ku Efeso, kweleko che Paolo ŵalesile che Pilisila ni che Akila, ŵajinjile mu nyuumba ja kupopelela ni kutanda kuusyausyana ni Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ŵandu ŵa pelepo ŵachondelele che Paolo atame pamo ni ŵandu wo moŵa gamajinji gane, nambo che Paolo nganasaka. ");
INSERT INTO yao_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nambo paŵalangaga ŵatite, “Chimuje sooni kukwenu Akunnungu asakaga.” Ni ŵakwesile mu ngalaŵa jekulungwa ni kutyoka mu Efeso mula. ");
INSERT INTO yao_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Che Paolo paŵaiche ku Kaisalia, ŵajawile ku Yelusalemu kukuukomasya mpingo wa ŵandu ŵakunkulupilila Kilisito ŵa kweleko, nipele ŵatuluchile ku Antiokia. ");
INSERT INTO yao_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Che Paolo ŵatemi kweleko moŵa kanandipe ni ŵatandite ulendo achipitilaga ku Galatia ni ku Filigia achalimbisyaga mitima ŵandu wose ŵakwakuya Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nipele Myahudi jumo liina lyakwe che Apolo mundu jwa ku Alekisandilia, ŵaiche ku Efeso. Mundu ju ŵaliji jwakuŵecheta uchenene ni juŵagamanyililaga Malembelo ga Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mundu ju ŵajiganyikwe litala lya Ambuje ni mu mbumu ŵachalilaga kusala ngani si Che Yesu, ŵajiganyisye chenene ngani si Che Yesu namuno ŵaumanyilile ubatiso u che Yohana pe. ");
INSERT INTO yao_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Che Pilisila ni che Akila paŵampilikene mundu jo ali nkuŵecheta mu nyuumba ja kupopelela pangajogopa, ŵanjigele kumangwao ni kunjiganya Litala lya Akunnungu kwa uchenene nnope. ");
INSERT INTO yao_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Che Apolo paŵasachile kwaula ku Akaya, ŵandu ŵakunkulupilila Che Yesu ŵa ku Efeso ŵanlimbisye ntima ni kwalembela ŵakulijiganya ŵa ku Akaya kuti ampochele. Che Apolo paŵaiche kweleko, Akunnungu ŵankamuchisye mu upile wao, ni ŵakombwele kwakamusya nnope ŵandu ŵakunkulupilila Che Yesu, ");
INSERT INTO yao_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","kwa ukombole wao wa kuŵecheta ŵapundile Ŵayahudi paujo pa ŵandu achalosyaga Mmalembelo ga Akunnungu kuti Che Yesu ali Kilisito. ");
INSERT INTO yao_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nipele, yaliji che Apolo paŵaliji ku Kolinto, che Paolo ŵapite kuchilambo cha ikwesya ni ŵaiche ku Efeso. Kweleko ŵaasimene ŵakulijiganya ŵane ŵa Che Yesu, ");
INSERT INTO yao_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ni ŵausisye, “Ana pamwakulupilile Che Yesu mwampochele Mbumu jwa Akunnungu?” Ni ŵanyawo ŵajanjile, “Ngwamba! Natamuno kupilikana kose nganitupilikane kuti apali Mbumu jwa Akunnungu.” ");
INSERT INTO yao_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ni che Paolo ŵausisye, “Nambi mwabatiswe ubatiso chi?” Ni ŵanyawo ŵajanjile, “Ubatiso u che Yohana.” ");
INSERT INTO yao_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Che Paolo ŵatite, “Ubatiso u che Yohana waliji wakulosya kuti ŵandu alesile sambi. Che Yohana ŵaasalile ŵandu ŵaakulupilile ŵatachiika panyuma pao, ŵelewo ali Che Yesu.” ");
INSERT INTO yao_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Paŵapilikene yeleyo ŵabatiswe kwa liina lya Ambuje Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nipele, che Paolo ŵaŵisile makono gao pa ŵanyawo, ni Mbumu jwa Akunnungu ŵaatuluchile ni ŵatandite kuŵechetanga iŵecheto ineine, iyoyo ŵatandite kulalichila utenga wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ŵandu wose wo ŵaliji mpela ŵandu likumi ni ŵaŵili. ");
INSERT INTO yao_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Che Paolo ŵajinjilaga mu nyuumba ja kupopelela jila kwa miesi jitatu ni ŵaachisyaga kuti akulupilile Umwenye wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nambo ŵandu ŵane ŵaliji ŵakukakatima mitima ni ŵakanile kukulupilila, ŵatandite kuŵechetanga yangalumbana nkati ŵandu ŵakulikuya Litala lya Ambuje pasikati ja ŵandu. Pelepo che Paolo ŵaalesile, ŵaajigele ŵakulijiganya ŵa Ambuje ni ŵaliji nkukunguluka nawo moŵa gose mu chuumba chakulijiganyila chi che Tulona. ");
INSERT INTO yao_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Yeleyo yatendekwe yaka iŵili mpaka ŵandu wose ŵaŵatamaga ku Asia ni Ŵayahudi pamo ni Ŵagiliki, ŵapilikene Liloŵe lya Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Akunnungu ŵapanganyisye yakusimonjeka yejinji kwa makono ga che Paolo. ");
INSERT INTO yao_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ŵandu ŵajigalaga namose iguo ya mwana ni iwalo ine iŵaikwaiye che Paolo, ŵaijawisye kwa ŵakulwala ni ŵakulwala wo ŵalamiswe ilwele yao, ni aŵala ŵaŵakwete masoka gaakopweche. ");
INSERT INTO yao_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ŵayahudi ŵampepe ŵakugaŵinga masoka mwa ŵandu, ŵajesilejesile akuno ni akunokuno achilingaga kulikolanga liina lya Ambuje Che Yesu, kwa ŵele ŵaŵakwete masoka achitiji, “Ngunsalila kwa liina lya Ambuje Che Yesu jwakulalichilwa ni che Paolo, ntyoche.” ");
INSERT INTO yao_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ŵaŵatendaga yeleyo, ŵaliji ŵanache nsano ni ŵaŵili wa che Sikewa Jŵambopesi Jwankulu jwa Chiyahudi. ");
INSERT INTO yao_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nambo lisoka lila lyaajanjile ŵanyawo, “Che Yesu ngwamanyilila ni che Paolo nombejo ngummanyilila, nambo ŵanyamwe ndi ŵaani?” ");
INSERT INTO yao_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nipele jwamasoka jo ŵasumbile ni kwagalagasya mpaka ŵanache ŵa che Sikewa wo ŵautwiche mu nyuumba jo ali matakope ni maŵanga gakwe. ");
INSERT INTO yao_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ngani ji jamanyiche kwa jwalijose juŵatamaga ku Efeso, kutandila Myahudi kwichila Ŵagiliki. Wose ŵakamwilwe ni lipamba, ni ŵalikusisye liina lya Ambuje Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ŵajinji mwa ŵele ŵaŵakulupilile Che Yesu ŵaiche ni ŵajitichisye paujo pa ŵandu yangalimate iŵaitesile. ");
INSERT INTO yao_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ŵane ŵaŵatendaga usaŵi ndanda jo, ŵajigele itabu yao iŵaitendelaga usaŵi yo ni kwijocha paujo pa ŵandu. Ŵaŵalasile ntengo wa itabu yo ni kusimana mbiya syesijinji. ");
INSERT INTO yao_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kwanti yeleyo, Liloŵe lya Ambuje lyapundile ni kwenela ni kola machili nnope. ");
INSERT INTO yao_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Payamasile yeleyo, che Paolo ŵasachile kwaula ku Yelusalemu achipitilaga ku Makedonia ni ku Akaya. Ŵatite, “Pachiiche kweleko, ikuumajila kwaula ku Loma nombe.” ");
INSERT INTO yao_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ni ŵalajisye ŵaŵili mwa ŵakwakamuchisya ŵao, che Timoseo ni che Elasto, kuti ŵalongolele ku Makedonia ni nsyene ŵasigalile mu Asia kwa katema. ");
INSERT INTO yao_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Katema ko ni katema kakatyochele utinda wekulungwa ku Efeso ko ligongo lya Litala lya Ambuje. ");
INSERT INTO yao_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Jwapali mundu liina lyakwe che Demetilio jwakusyana madini ga feza. Jweleju ŵaliji ni masengo ga kolosya inyago ya nyuumba sya mwana sisyaliji mpela nyuumba ja nnungu jwankongwe jwakuŵilanjikwa Atemi. Masengo go gaapokasisye kwannope ŵamasengo ŵao. ");
INSERT INTO yao_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Che Demetilio ŵasongangenye ŵamasengo ŵao pamo ni ŵandu ŵane ŵaŵaliji ŵamasengo mpela gagogo pego ni kwasalila, “Ŵandumwe, nkumanyililanga kuti ipanje yetu itukupata yi ikukopoka mmalonda gagaga pega. ");
INSERT INTO yao_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Sano nkulola ni kulipikanila mwachinsyene che Paolo yakuti pakupanganya, nombe ngaŵa pa Efeso pe nambo pa Asia pose. Che Paolo ju ŵaachisisye ni kwagalausya ŵandu ajitichisye kuti achiminungu ŵapanganyiswe ni makono ga ŵandu ngaŵa achiminungu ŵa usyene. ");
INSERT INTO yao_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nipele kupikaniche kuti malonda getu ga chigajaluche. Ni ngaŵa malonda getu pega, nambo ni nyuumba ja nnungu jwankongwe Atemi ngajichimbichikwa kose. Ni mbesi jakwe lumbili lwa ŵelewo ŵakunlamba ŵa Asia wose ni ŵandu wose ŵa mchilambo chiuchimala.” ");
INSERT INTO yao_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ŵandu ŵala paŵapilikene yeleyo yaachimile kwannope ni kutanda gumilanga achitiji, “Jwankulu ali Atemi jwa Ŵaefeso!” ");
INSERT INTO yao_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Musi wose wagumbele utindiganyo. Ni ŵaakamwile che Gayo ni che Alisitako, ŵaŵatamaga ku Makedonia ŵaŵaliji mu ulendo umo ni che Paolo, ni ŵaajawisye kwa kwanguya kuluŵala lwa micheso. ");
INSERT INTO yao_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Che Paolo nsyene ŵasachile kwinjila mu mpingo wa ŵandu mula nambo ŵakwakuya ŵala ŵankanyisye. ");
INSERT INTO yao_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Achakulu ŵane ŵa chilambo cha ku Asia ŵaliji achambusanga ŵao che Paolo, ŵapelechele utenga wakwachondelela kuti akalijausya nsyene ku luŵala lwa micheso ko. ");
INSERT INTO yao_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Katema ko kila mundu jwagumisile, ŵane achi ni ŵane achila, pakuŵa nkungulu ula waliji jugulijuguli, ŵajinji nganaimanyililanga ligongo lya kusongangana kwao. ");
INSERT INTO yao_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Pakuŵa Ŵayahudi ŵantesile che Alekisanda akopoche mmbujo mwa ŵandu, ŵandu ŵampepe mu mpingo mula ŵaganisisye kuti ali jwelejo. Nipele che Alekisanda ŵajongwele nkono ni kwamyalasya achisakaga kuliŵalanga paujo pa mpingo wa ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nambo paŵammanyilile kuti ŵaliji Myahudi, wose ŵagumisile kwana kamo kwa masaa gaŵili, “Jwankulu ali Atemi jwa Ŵaefeso!” ");
INSERT INTO yao_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mbesi, jwakulemba jwa pamusi po ŵakombwele kwamyalasya, ŵaasalile, “Ŵanyamwe ŵandu ŵa ku Efeso, kila mundu pelepa akumanyilila kuti ŵandu ŵa musi wa Efeso wu, ni ŵakujilindilila nyuumba ja nnungu Atemi, ni ŵakuligosa liganga lyeswela lilyagwile kutyochela kwinani lila. ");
INSERT INTO yao_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ngapagwa jwalijose jwakukombola kukanila yeleyo. Nipele mmyalalanje, nkatenda chachili chose kwakwanguya. ");
INSERT INTO yao_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mwaŵilasile ŵandu ŵa pelepa namuno nganajinyelusya nyuumba ja nnungu pane kuntukana nnungu jwetu jwankongwe. ");
INSERT INTO yao_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nipele, iŵaga che Demetilio ni ŵamasengo ŵao akwete magambo gao nkati ŵandu ŵa, mikungulu jipali ni achakulu ŵa ilambo nombe nawo apali, akukombola kuŵechetelana kweleko. ");
INSERT INTO yao_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nambo iŵaga kwana magambo gane njausye ku nkungulu waukukundikwa. ");
INSERT INTO yao_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Pakuŵa akakombwele kutuŵechetela ligongo lya kutindiganya kwatukutesile lelo jino. Kutindiganya ku nganilipagwa ligongo ni sooni ngatukombola kusala ligongo lya kutenda nkungulu wu.” ");
INSERT INTO yao_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Paŵamasile kuŵecheta yeleyo, ŵamwasisye ŵandu ŵaŵasongangene wo. ");
INSERT INTO yao_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Pawamasile utinda ku Efeso, che Paolo ŵaaŵilasile ŵakwakuya ŵala pamo, ni kwalimbisya ntima. Ni ŵaalanjile ni kutanda ulendo wa ku Makedonia. ");
INSERT INTO yao_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ni ŵapite mu ilambo ila ni kwalimbisya ntima kwa maloŵe gamajinji ŵakukulupilila ŵa misi jo. Nipele ŵaiche ku Ugiliki, ");
INSERT INTO yao_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","kweleko ŵatemi miesi jitatu. Paŵaliji nkuliŵika chile kwa ulendo wa ku Silia kwa litala lya mmeesi, ŵaimanyi kuti Ŵayahudi ŵatamilile ntemela wangalimate, nipele ŵaamwiwe kuuja achipitilaga ku Makedonia. ");
INSERT INTO yao_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Che Sopatula mwana ju che Piho mundu jwa ku Belea ŵalongene ni che Paolo pamo ni che Alisitako ni che Sekundo jwa ku Sesalonike, che Gayo jwa ku Debe ni che Timoseo, che Tukiko ni che Tilofimo jwa ku Asia. ");
INSERT INTO yao_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ŵandu wo ŵatulongolele ni ŵaliji nkutulolela ku Tuloa kula. ");
INSERT INTO yao_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pagapite moŵa ga mikate jangatajikwa amila, uweji twakwesile ngalaŵa kutyochela ku Filipi ni pagamasile moŵa nsano, twaiche ku Tuloa kula. Ni kweleko twatemi chijuma chimo. ");
INSERT INTO yao_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lyuŵa lyaandanda lya chijuma twachingangene kuti tulye pamo. Ni che Paolo pakuŵa ŵasachile kuti atyoche malaŵi jakwe, ŵakungulwiche ni ŵandu, ni sooni ŵajendelechele kukunguluka ni ŵandu wo mpaka chilo nnope. ");
INSERT INTO yao_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mu chuumba cha mwinani kutwasongangene ko kwaliji ni ibatali yejinji ichikolelaga. ");
INSERT INTO yao_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ni jwapali nchanda liina lyakwe che Eutiko juŵatemi pedilisha. Che Paolo paŵajendelechelaga kukunguluka, che Eutiko ŵatandite kugwesela kanandikanandi. Kumbesi ŵagonile ni ŵagwile paasi kutyochela chuumba chaatatu cha mwinani. Ni paŵannyakwile ŵaliji ŵamale kuwa. ");
INSERT INTO yao_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nambo che Paolo ŵatulwiche paasi ni ŵatindiŵele ni kwakumbata ni kuti, “Kasinlilanga pakuŵa ali jwanjumi.” ");
INSERT INTO yao_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ni ŵakwesile sooni ku chuumba cha mwinani kula ŵagaŵenye nkate ni ŵalile. Ŵajendelechele kulalichila mpaka kundaŵi pe nipele ŵatyosile. ");
INSERT INTO yao_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ŵandu ŵala ŵanjigele nchanda jula kumangwao ali jwanjumi, nipele mitima jao jatulele. ");
INSERT INTO yao_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Uweji twalongolele ku Aso ni ngalaŵa jekulungwa, kweleko twatiji twajigale che Paolo. Yeleyo ni yatite pakulajisya nnigwa wao kuti aiche kweleko wapasi. ");
INSERT INTO yao_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nipele che Paolo ŵatusimene ku Aso kula, ni twakwesile mu ngalaŵa ni twajawile ku Mitulene. ");
INSERT INTO yao_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kutyochela kweleko twajendelechele ni ulendo ni malaŵi jakwe twaiche ku Kio. Pa lyuŵa lyaaŵili twapelengenye ku Samo ni malaŵi jakwe twaiche ku Mileto. ");
INSERT INTO yao_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pakuŵa che Paolo ŵasachile kwendelechela ni ulendo wao ni ngalaŵa pangasepuchila ku Efeso kuti akasakaŵa nnope ku Asia ko. Ŵachelengaga nningwa wao kuti yakombolekaga aiche ku Yelusalemu kwaligongo lya lyuŵa lya Pentekosite. ");
INSERT INTO yao_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Che Paolo paŵaliji ku Mileto ŵalajisye utenga wa kwaŵilanga achachekulu ŵa mipingo ja ŵandu ŵakunkulupilila Kilisito ja ku Efeso kuti achingangane. ");
INSERT INTO yao_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Achachekulu ŵala paŵaiche, che Paolo ŵaasalile, “Mwachinsyene nkumanyililanga indite pakutama ni ŵanyamwe moŵa gose chitandile lyuŵa lyaandanda lila panaiche pachilambo cha ku Asia. ");
INSERT INTO yao_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nkumanyililanga indite pakwatumichila Ambuje nkulitulusya kose ni misosi ni masausyo gagambatile kwaligongo lya malindi ga Ŵayahudi ŵampepe. ");
INSERT INTO yao_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nkumanyililanga kuti uneji nganinyogopa namose kanandi kunlalichila pelanga ni mmajumba genu ni kunjiganya chakunkamuchisya chachili chose. ");
INSERT INTO yao_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Naajamwiche kwakalipa nnope Ŵayahudi ni Ŵagiliki aleche sambi syao ni kwaujilila Akunnungu ni kunkulupilila Ambuje ŵetu Che Yesu. ");
INSERT INTO yao_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Sano, uneji ngumpilikanichisya Mbumu jwa Akunnungu, ngwaula ku Yelusalemu pangaimanyilila chachili chose chachichiisimane kweleko. ");
INSERT INTO yao_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nguchimanyilila chindu chimo kuti mmusi wauliwose Mbumu jwa Akunnungu akusalila kuti kutaŵikwa ni masausyo gakunindilila. ");
INSERT INTO yao_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nambo nganguuŵalanjila umi wangu kuti wana chindu nnope kwa uneji nningwa wangu malichisye unduna wangu ni masengo gaŵambele Ambuje Che Yesu nagapanganye, yaani naalalichile ŵandu Ngani Jambone ja upile wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Mbiite mwa ŵanyamwe wose njilalichilaga Umwenye wa Akunnungu. Nambo sambano ngumanyilila kuti ngapagwa jwalijose mwa ŵanyamwe juchachimona une sooni. ");
INSERT INTO yao_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nipele lelo jino ngunsalila kuti yakopochelaga jumo jwenu kujonasika, uneji nganingola magambo. ");
INSERT INTO yao_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Pakuŵa nganileka kunlalichila yanayose yakusaka kuipanganya Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nlilolechesye mwachinsyene, mwagose ŵandu wose ŵampele Mbumu jwa Akunnungu kuti mwalele ŵanyawo. Nkaachunje ŵandu ŵa Akunnungu ŵaŵapatile kwa miasi ja Mwanagwe. ");
INSERT INTO yao_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nguimanyilila uchenene kuti pingutyoka masogo gakalipa chiganjimuchile ni ngagakola chanasa kwa mpingo wo. ");
INSERT INTO yao_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ni sooni mwa mwachinsyene chakopochele ŵandu ŵachaŵechete ya unami kwasoyasya ŵakulijiganya ni kwatenda ŵaakuye ŵanyawo. ");
INSERT INTO yao_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nipele, nlilolechesye nchikumbuchilaga kuti kwa moŵa ga yaka itatu chilo ni muusi, nganileka kunjamuka kila jumo mwa ŵanyamwe kwa misosi. ");
INSERT INTO yao_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Nipele sambano, ŵanyamwe ngummikanga mmakono ga Akunnungu ni pa utenga wa upile wao, waukukombola kunkolosya ni kumpa ntuuka pamo ni ŵandu ŵao ŵaŵaswejeswe. ");
INSERT INTO yao_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Uneji nganisaka madini ga feza pane sahabu pane iwalo ya mundu jwalijose. ");
INSERT INTO yao_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mwachinsyene nkumanyililanga kuti napanganisye masengo ni makono gangu nansyene kuti mbate yaikunsoŵa ni yaikwasoŵa achinjangu nombewo. ");
INSERT INTO yao_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Moŵa gose mbanganyisye masengo nti itagu kukwenu, kunnosya kuti tukusachilwa kwakamuchisya ŵakulaga, tuchikumbuchilaga maloŵe ga Ambuje Che Yesu nsyene gagakuti, ‘Mbaya kutyosya kupunda kupochela.’ ” ");
INSERT INTO yao_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Che Paolo paŵamasile kuŵecheta yeleyo ŵatindiŵele pamo ni ŵanyawo wose ni kwapopela Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Wose ŵaliji nkulilanga ni ŵaalanjile che Paolo kwakwakumbata ni kwalosya unonyelo wekulungwa. ");
INSERT INTO yao_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Chindu chichatesile asupuche nnope chaliji liloŵe liŵaŵechete che Paolo paŵatite, “Ngamuuwona sooni.” Nipele ŵaapechesye mpaka mu ngalaŵa jekulungwa. ");
INSERT INTO yao_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Pitwalangene nawo, twakwesile mu ngalaŵa jekulungwa ni twajawile mpaka ku Kosi. Malaŵi jakwe twaiche musi wa ku Lode ni kutyochela kweleko twajawile ku Patala. ");
INSERT INTO yao_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ni kweleko twajisimene ngalaŵa jekulungwa jijajombokaga kwaula ku Foinike, twakwesile ni kwendelechela ni ulendo. ");
INSERT INTO yao_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Pitwaiche pakukombola kujiwona Kupulo, twapite upande wa kunchiji ni kwaula ku Silia. Twajimi musi wa ku Tilo ni kujitulusya misigo kutyochela mu ngalaŵa jekulungwa. ");
INSERT INTO yao_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kweleko twaasimene ŵandu ŵakunkulupilila Che Yesu, ni twatemi pamo ni ŵanyawo chijuma chimo. Kwa machili ga Mbumu jwa Akunnungu ŵanchondelele che Paolo kuti akajaula ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nambo pikamasile katema ka kutama ni ŵanyawo, twajendelechele ni ulendo wetu. Ŵandu wose pamo ni achiŵankwawo ni achiŵana ŵao ŵatupechesye mpaka paasa musi. Pitwaiche ku mbwani twatindiŵele ŵanawose ni kwapopela Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nipele twalangene, noweji twakwesile mu ngalaŵa jekulungwa ni ŵanyawo ŵausile mmangwao. ");
INSERT INTO yao_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kutyochela ku Tilo twajendelechele ni ulendo wetu mpaka twaiche ku Tolemaisi, ni kweleko twajawile kukwakomasya ŵakukulupilila achinjetu, twatemi nawo kwa lyuŵa limo. ");
INSERT INTO yao_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Malaŵi jakwe twajendelechele ni ulendo ni kwika ku Kaisalia. Ni kweleko twajawile ku nyuumba ji che Filipo jwakulalichila Ngani Jambone. Jwelejo ŵaliji jumo jwa aŵala saba ŵaŵasagulikwe ku Yelusalemu kula. ");
INSERT INTO yao_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Mundu jo ŵakwete achiŵaliŵalipe ncheche ŵaŵalondolaga utenga wa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Pitwatemi kweleko moŵa gampepe ŵaiche jwakulondola jwa Akunnungu jumo kutyochela ku Yudea liina lyakwe che Agabo. ");
INSERT INTO yao_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ni ŵaiche pitwaliji, ŵaujigele nkaanda u che Paolo ni ŵalitaŵile mmakono ni makongolo ni kuti, “Mbumu jwa Akunnungu akuti, ‘Ŵayahudi ŵa ku Yelusalemu kula chantaŵe nsyene nkaanda wu kwanti nnyi ni kunjausya mmakono ga ŵandu ŵangaŵa Ŵayahudi.’ ” ");
INSERT INTO yao_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Patwapilikene yeleyo, uweji ni ŵandu ŵane ŵaŵaliji pepala twachondelele che Paolo kuti akajaula ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nambo che Paolo nsyene ŵajanjile, “Ana nkusaka kupanganya chichi? Nkusaka kuusupusya ntima wangu ni misosi jenu? Ndili chile ngaŵa kutaŵikwa pe ku Yelusalemu kula, nambo atamuno kuwa kwa ligongo lya Ambuje Che Yesu.” ");
INSERT INTO yao_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Paŵakanile kutupilikanila twannesile nikuti, “Chakusaka Ambuje chitendekwe!” ");
INSERT INTO yao_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Pitwatemi pepala moŵa gampepe, twataŵile misigo jetu ni twajendelechele ni ulendo wa ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ŵakulijiganya ŵampepe ŵa ku Kaisalia kula ŵalongene ni uweji, ni ŵatupechesye ku nyuumba ji che Mnasoni kutwajile kukutama ni jwelejo moŵa gampepe. Che Mnasoni ŵaliji mundu jwa ku Kupulo ni juŵaliji jwakukulupilila jwa kalakala. ");
INSERT INTO yao_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Patwaiche ku Yelusalemu, ŵandu ŵakunkulupilila Che Yesu achinjetu ŵa kweleko ŵatupochele uchenene nnope. ");
INSERT INTO yao_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Malaŵi jakwe che Paolo ŵalongene ni uweji kukwakomasya che Yakobo, achachekulu wose ŵa ŵandu ŵakunkulupilila Che Yesu ŵa kweleko ŵaliji palapala. ");
INSERT INTO yao_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Patwamasile kwakomasya, che Paolo ŵatandite kwasalila yanayose nkati iŵaitesile Akunnungu kwa masengo ga che Paolo kwa ŵandu ŵangaŵa Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ŵandu ŵala paŵapilikene yeleyo ŵaakusisye Akunnungu. Nipele ŵansalile che Paolo, “Nlongo njetu, nkukombola kuwona kuti kwana mianda ja Ŵayahudi aŵele ŵakukulupilila sambano ni wose akulimbila kugakamulichisya Malajisyo ga Akunnungu gaŵapele che Musa. ");
INSERT INTO yao_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Apilikene kuti alakwe nkwajiganya Ŵayahudi ŵakutama pasikati ja ŵandu ŵangaŵa Ŵayahudi anagakamulisye Malajisyo ga Akunnungu gaŵapele che Musa, ni mwasalile akaumbasya ŵanache ŵao namose kugakamulichisya masyoŵelo ga Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nambi chiiŵe uli? Isyene ŵandu chapilikane kuti nnyiche. ");
INSERT INTO yao_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mbaya ntendekanye chitukunsalila uwe. Tukwete achalume ncheche pelepa ŵaŵataŵile nasili paujo pa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nliwanganye ni ŵanyawo mu kupopela kwa kuliswejesya, nlipe ntengo waukusachilwa kwa ŵanyamwe wose, nipele ŵandu wo amyolekwe umbo. Kwakutenda yeleyo ŵandu wose chamanyilile kuti ngani siŵasipilikene syo nkati alakwe nganisiŵa sisyene nomwe mwasyene nkugakamulisya Malajisyo ga Akunnungu gaŵapele che Musa. ");
INSERT INTO yao_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Yankati ŵandu ŵangaŵa Ŵayahudi ŵaŵakulupilile Che Yesu, uweji twalembele chikalata ni kwasalila itwilamwile ni kwapelechela, chachikuti, akalya chachili chose chetaje mbopesi sya minungu ja unami, ni akalya miasi, ni akalya nyama ja chinyama chepopotolwe ni aleche chikululu.” ");
INSERT INTO yao_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nipele malaŵi jakwe che Paolo ŵaajigele ŵandu ŵala ni kupopela kwa kuliswejesya pamo nawo. Nipele ŵajinjile pa Nyuumba ja Akunnungu kukusala mbesi ja moŵa gakuliswejesya ni yankati mbopesi ja malipilo jichijityosyekwe kwaligongo lya jwalijose mwa ŵanyawo. ");
INSERT INTO yao_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Moŵa nsano ni gaŵili gala gachiŵandichilaga kumala, Ŵayahudi ŵaŵakopochele ku Asia ŵambweni che Paolo ali pa Nyuumba ja Akunnungu. Nipele ŵaatesile ŵandu wose ŵaachime che Paolo ni ŵankamwile, ");
INSERT INTO yao_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","achinyanyisyaga, “Ŵanyamwe Ŵaisilaeli, kuntukamusye! Mundu ju ni jwejula jwakwajiganya achalume wose indu yakukanilana ni Ŵaisilaeli pamo ni Malajisyo ga Akunnungu gaŵapele che Musa ni Nyuumba ja Akunnungu ji. Ni sooni ŵajinjisye Ŵagiliki pa Nyuumba ja Akunnungu ni kupasakasya peuto papaswela pa.” ");
INSERT INTO yao_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ŵatite yeleyo ligongo ŵambweni che Tilofimo mundu jwa ku Efeso, mu musi, ali pamo ni che Paolo ni ŵaganisisye kuti che Paolo ŵanjinjisye pa Nyuumba ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nipele musi wose wagumbele utindiganyo ni ŵaiche ŵandu kutyochela mbande syose kuti ŵaakamule che Paolo, ŵakwekwelemye ni kwakoposya pa Nyuumba ja Akunnungu, ni papopo ŵaugele minango ja Nyuumba ja Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ŵaliŵisile chile kuti ŵaulaje, nambo ngani jo japikaniche kwa jwankulu jwa ŵangondo lichila ŵa Chiloma kuti Yelusalemu jose jili tametame. ");
INSERT INTO yao_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Pangakaŵa jwankulu jwa ŵangondo mia moja jula ŵaajigele ŵangondo ŵakwe ni achakulu ŵao ni ŵautuchile ku mpingo wa ŵandu kula. Ni ŵanyawo paŵammweni jwankulu jo ni ŵangondo ŵakwe ŵalesile kumputa che Paolo. ");
INSERT INTO yao_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Nipele jwankulu jwa ŵangondo jula ŵanjaulile che Paolo, ŵankamwile ni kulamula kuti ataŵikwe minyolo jiŵili. Ni ŵausisye achitiji, “Ana ncheni jweleju, nombe atesile chichi?” ");
INSERT INTO yao_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ŵane ŵaali mu mpingo wa ŵandu mula ŵagumilangaga, ŵane achi ni ŵane acho. Ligongo lya wele utinda wo, jwankulu jwa ŵangondo jula nganakombola kugamanyilila magambo gasyenesyene. Nipele ŵalamwile ŵangondo ŵala kuti ŵajigale che Paolo ni kunjausya mu likome. ");
INSERT INTO yao_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Che Paolo paŵaiche pakukwelela kwinjilila nkati, ŵangondo ŵannyakwile ligongo lya utindiganyo wa ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Mpingo wekulungwa wa ŵandu ŵakuiye achinyanyisyaga, “Mwaulaje!” ");
INSERT INTO yao_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paŵanjinjisyaga mu likome, che Paolo ŵanchondelele jwankulu jwa ŵangondo mia moja jula achitiji, “Ana ngukombola kuŵecheta chindu nomwe?” Jwankulu jula ŵajanjile, “Ana nkumanyilila kuŵecheta Chigiliki? ");
INSERT INTO yao_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ana mmweji ngati Mmisili jumwachisisye ŵandu atindiganye ni kwalongosya ŵakuulaga elufu nne ŵala mpaka mwipululu?” ");
INSERT INTO yao_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Che Paolo ŵajanjile, “Ngwamba! Uneji ndili Myahudi, jumbagwilwe ku Taso, musi wa ku Kilikia, uneji jwa musi waumanyiche nnope. Choonde, munyitichisye mechete ni ŵandu ŵa.” ");
INSERT INTO yao_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Jwankulu jula ŵajitichisye, nipele che Paolo ŵajimi pakukwelela pala, ŵagolwesye nkono kwamyalasya ŵandu ŵala, ni ŵandu ŵala ŵamyalele ni ŵatandite kuŵecheta nawo Mchiebulania. ");
INSERT INTO yao_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Achalongo achinjangu ni achatati, mumbilikanile uchenene inguti kulichenjela paujo penu!” ");
INSERT INTO yao_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ŵandu ŵala paŵampilikene che Paolo achikungulukaga nawo Mchiebulania ŵamyalele jii. Ni che Paolo ŵajendelechele kuŵecheta, ");
INSERT INTO yao_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Uneji ndili Myahudi, napagwilwe ku Taso, musi wa ku Kilikia. Nambo ngulile papapa pa Yelusalemu, naliji jwakulijiganya ju che Gamalieli. Nalijiganyisye uchenene kukamula malajisyo ga achambuje ŵetu. Nalityosisye ni ntima wose kwa Akunnungu mpela intite ŵanyamwe lelo jino. ");
INSERT INTO yao_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Naalagesye ŵandu Ŵakwakuya Che Yesu mpaka kwaulaga. Naakamwile achalume ni achakongwe ŵakwe ni kwataŵa mu nyuumba jakutaŵilwa. ");
INSERT INTO yao_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Jŵambopesi jwankulu pamo ni nkungulu wa achachekulu akukombola kuutyosya umboni wa yeleyo. Ŵanyawo ni ŵaŵambele chikalata chakwapelechela Ŵayahudi ŵakutama ku Damesiki. Najawile ku Damesiki kuti ngaakamule ŵandu wo ni kwajigala kuja nawo ku Yelusalemu ali ataŵikwe kuti ajamukwe.” ");
INSERT INTO yao_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Nipele, panaliji mwitala kuŵandichila ku Damesiki, muusi mpela lyuŵa pa ntwe chisisimuchile kwinani kwakopochele lulanga lwekulungwa ni lwalanguchisye une mbande syose. ");
INSERT INTO yao_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Pelepo nagwile paasi, nipele napilikene liloŵe lichisalilaga, ‘Che Sauli, che Sauli! Ana ligongo chi nkuunagasya une?’ ");
INSERT INTO yao_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Noneji nausisye, ‘Ana ŵaani alakwe, Ambuje?’ Nombewo ŵajanjile, ‘Uneji ndili Che Yesu jwa ku Nasaleti junkunagasya.’ ");
INSERT INTO yao_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Achinjangu ŵanaliji nawo mu ulendo ŵala ŵaliweni lilanguka lila nambo nganalipikana liloŵe lya ajula jwaŵaŵechetaga ni une. ");
INSERT INTO yao_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nipele uneji nausisye, ‘Ana ndende chichi Ambuje?’ Nombe Ambuje ŵanyanjile, ‘Njime, njaule ku Damesiki ni kweleko chansalile yose yaikummajila kuipanganya.’ ");
INSERT INTO yao_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kwa ligongo lya kung'alima kwa lilanguka lila nalepele kulola nipele achinjangu unalongene nawo mu ulendo ŵala ŵangamwile nkono ni kunongosya mpaka naiche ku Damesiki. ");
INSERT INTO yao_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ni ku Damesiki ko jwapali mundu jumo liina lyakwe che Anania, mundu jwakwalamba Akunnungu ni jwakugakamulichisya Malajisyo ga Akunnungu gaŵapele che Musa ni juŵaŵalanjikwe umboni kuti ali jwambone ni Ŵayahudi ŵakutama ku Damesiki. ");
INSERT INTO yao_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Jwelejo ŵaiche kukuunola, ni ŵajimi pachiŵandi ni uneji ni kuti, ‘Mpwanga che Sauli! Nkombole kulola sooni.’ Papopo nakombwele kulola sooni ni nammweni. ");
INSERT INTO yao_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nipele che Anania ŵatite, ‘Akunnungu ŵa achambuje ŵetu ansagwile mmwe kuti mmanyilile yakuisaka, ni kummona jwelejo Jwakupanganya yambone paujo pa Akunnungu, ni kumpilikana nsyene achiŵechetaga. ");
INSERT INTO yao_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Pakuŵa chimme jwaumboni jwakwe kwa ŵandu wose nchasalilaga aila yose inyiweni ni kwipilikana. ");
INSERT INTO yao_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nipele sano nkulindilila ichichi, njime mbatiswe ni kutyosyekwa sambi syenu, kwakutenda yelei nkuliŵilanga liina lya Ambuje.’ ");
INSERT INTO yao_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nipele, nausile ku Yelusalemu ni panapopelaga pa Nyuumba ja Akunnungu pala naiweni yakwiwona. ");
INSERT INTO yao_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nammweni Ambuje achiisalilaga, ‘Njanguye! Ntyoche chitema mu Yelusalemu pakuŵa ŵandu ŵa pelepa ŵa ngaapochela umboni wenu nkati une.’ ");
INSERT INTO yao_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Noneji najanjile, ‘Ambuje, ŵanyawo akumanyilila kuti uneji ni jwejula junajendagajendaga mmajumba gao ga kupopelela ni kwataŵa mu nyuumba jakutaŵilwa aŵala ŵaŵankulupilile mmweji ni kwaputa. ");
INSERT INTO yao_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ni katema paŵammuleje che Stefano jwa umboni jwenu, uneji nansyene naliji palapala ni sooni najitichisye kuti ŵaulaje ni nalindilile nguo sya ŵaŵambuleje ŵala.’ ");
INSERT INTO yao_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ambuje ŵaasalile, ‘Njaule, chinantume kwakutalika, kwa ŵandu ŵangaŵa Ŵayahudi.’ ” ");
INSERT INTO yao_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ŵandu ŵala ŵapilikanilaga mpaka paŵaŵechete maloŵe go, nipele, ŵatandite kunyanyisya achitiji, “Mumbulaje! Mundu jwati yelei ngaakuŵajilwa kulama.” ");
INSERT INTO yao_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ni ŵajendelechele kunyanyisya akuno achiulaga iwalo yao ni kututumya luundu mwinani. ");
INSERT INTO yao_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Jwankulu jwa ŵangondo lichila jula ŵaalamwile ŵangondo ŵao anjigale che Paolo ni kunjinjisya mu likome, ni ŵaalajisye ŵaapute mbokola ali nkumbusya kuti ŵamanyisye ligongo lya Ŵayahudi kunyanyisya. ");
INSERT INTO yao_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nambo paŵantaŵile ngonji kuti ŵapute, che Paolo ŵambusisye jwankulu jumo juŵajimi pepala, “Ana malajisyo gakutusaka kumputa mbokola Mloma akanaŵe kulamulikwa?” ");
INSERT INTO yao_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Jwankulu jula paŵapilikene yeleyo, ŵajawile ku jwankulu jwa ŵangondo jula ni kwasalila, “Ana nkusaka kutenda chichi? Pakuŵa mundu ju ali Mloma!” ");
INSERT INTO yao_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nipele jwankulu jwa ŵangondo jula ŵanjaulile che Paolo ni kummusya, “Musalile, ana mmwe Mloma?” Che Paolo ŵajanjile, “Elo.” ");
INSERT INTO yao_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Jwankulu jwa ŵangondo jula ŵatite, “Uneji none ndili Mloma kwa kusuma ni ntengo wekulungwa.” Che Paolo ŵatite, “Nambo uneji ndili Mloma jwakupagwa.” ");
INSERT INTO yao_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nipele ŵandu ŵaŵasachile kumbusya ali nkumputa che Paolo ŵala papopo ŵatyosile. Ni jwankulu jwa ŵangondo jula paŵaimanyilile kuti che Paolo ŵaliji Mloma ŵajogwepe pakuŵa ŵantaŵile ni minyolo. ");
INSERT INTO yao_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Malaŵi jakwe, jwankulu jwa ŵangondo mia moja jula ŵasachile kugamanyilila magambo gasyenesyene gakuŵechetelwa che Paolo ni Ŵayahudi. Nipele ŵangopwele minyolo jila ni ŵaalamwile achakulu ŵambopesi ni achakulu ŵa nkungulu asimane. Nipele ŵanjigele che Paolo ni kuntulusya paasi ni kunjimika paujo pa nkungulu. ");
INSERT INTO yao_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Che Paolo ŵalolechesye kwannope ŵankungulu ŵala ni ŵatandite kuŵecheta achitiji, “Achalongo achinjangu, naatumichile Akunnungu kwa ntima wambone mpaka lelo jino.” ");
INSERT INTO yao_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Pelepo che Anania Jwambopesi Jwankulu ŵalamwile kuti aŵala ŵaŵaliji kuŵandikana ni che Paolo ŵapute lijanda pakang'wa jao. ");
INSERT INTO yao_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nipele, che Paolo ŵansalile che Anania, “Akunnungu nsyene champute alakwe jwaulamba! Ana nomwejo nteemi pelepo kuti mulamule malinga ni malajisyo nomweji mwasyene ngankugakuya malajisyo kwa kwasalila ŵandu aambute?” ");
INSERT INTO yao_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ŵandu ŵaŵajimi pepala ŵala ŵansalile che Paolo “Mmwejo, nkuntukana Jwambopesi Jwankulu jwa Akunnungu?” ");
INSERT INTO yao_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ni che Paolo ŵatite, “Achalongo achinjangu nganinamanyililaga kuti ŵelewo ali Jŵambopesi Jwankulu. Pakuŵa Malembelo ga Akunnungu gakuti, ‘Ngasimmecheta yangalimate nkati jwankulu jwa ŵandu ŵenu.’ ” ");
INSERT INTO yao_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nipele che Paolo ŵaimanyilile kuti mpingo umo wa ŵankungulu ŵala waliji Masadukayo ni wine waliji Mafalisayo. Nipele ŵanyanyisye kwannope paujo pa nkungulu ula achitiji, “Achalongo achinjangu, uneji ndili Mfalisayo mwanache jwa Mfalisayo. Uneji ndili pa nkungulu pa kulamulikwa ligongo ngulolela kuti ŵawe chasyuche.” ");
INSERT INTO yao_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Palapala paŵaŵechete yeleyo, gakopochele makani gamakulungwa pasikati ja Mafalisayo ni Masadukayo ni nkungulu ula wasapulene. ");
INSERT INTO yao_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Pakuŵa Masadukayo akuti nganikupagwa kusyuka atamuno achikatumetume ŵa kwinani, ni mbumu nombe nasyo nganisipagwa. Nambo Mafalisayo akwitichisya yanayose itatu. ");
INSERT INTO yao_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ngomo sila syapundile ni ŵampepe mwa ŵakwiganya Malajisyo ga Akunnungu gaŵapele che Musa ŵa mpingo ŵa Mafalisayo ŵajimi ni koposya maloŵe gao kwamachili achitiji, “Ngatukugawona magambo gagaligose kwa mundu ju, ikukomboleka mbumu pane katumetume jwa kwinani aŵechete ni jwelejo.” ");
INSERT INTO yao_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Makani gala gapundile kuŵa gamakulungwa nnope, nipele jwankulu jwa ŵangondo jula ŵajogopaga kuti ŵandu ŵala chankatanye che Paolo iŵaloiŵalo. Nipele, ŵaalamwile ŵangondo ŵakwe atuluchile kwauli mpingo wa ŵandu kula ni kunjigala che Paolo kwa machili ni kunjausya nkati. ");
INSERT INTO yao_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Chilo cho, Ambuje ŵajimi chiŵandi ni che Paolo ni kuti, “Nkamulisye ntima! Mumalasile umboni pa Yelusalemu pano, chintende iyoyo peyo ni ku Loma.” ");
INSERT INTO yao_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Pikwachele, Ŵayahudi ŵatesile ntemela. Ni ŵalitaŵilile kuti, “Ngatulya pane kung'wa chachili chose mpaka pachitwaulaje che Paolo.” ");
INSERT INTO yao_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ŵandu ŵaŵatesile yeleyo wo ŵaliji ŵandu mpela alobaini. ");
INSERT INTO yao_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Nipele, ŵandu wo ŵajawile kwa achakulu ŵambopesi ni achachekulu ni kuti, “Tulitaŵilile twachinsyene kuti ngatupasya chachili chose mpaka pachitwaulaje che Paolo. ");
INSERT INTO yao_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nipele sano, ŵanyamwe pamo ni ŵankungulu nnajisye utenga kwa jwankulu jwa ŵangondo mia moja kuti antulusye kukwenu nchinamanilaga kuti nkusakanga kumanyilila uchenene magambo gakwe. Noweji akanaŵandichile tuliŵichile chile kummulaga.” ");
INSERT INTO yao_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nambo mwipwagwe che Paolo ŵapilikene ngani jo, nipele ŵaiche ni kwinjila mu likome mula ni kwasalila che Paolo nkati ngani jo. ");
INSERT INTO yao_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Che Paolo ŵammilasile jumo jwa ŵangondo ni kunsalila, “Munjausye nchanda ju kwa jwankulu jwa ŵangondo mia moja pakuŵa akwete chindu chakwasalila.” ");
INSERT INTO yao_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Jwangondo jula ŵanjigele nchanda jula ni kulongana nawo mpaka kwa jwankulu jwa ŵangondo ni kuti, “Che Paolo jwantawe jula ŵamilasile ni kuumenda kuti nannyichenawo jwanchanda ju kukwenu pakuŵa akwete indu yakwasalila.” ");
INSERT INTO yao_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Jwankulu jwa ŵangondo jula ŵankamwile nchanda jula nkono, ŵanjigele pachisyepela ni kummusya, “Ana nkusaka kuusalila chichi?” ");
INSERT INTO yao_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nchanda jula ŵatite, “Ŵayahudi alangene kummenda alakwe malaŵi munjausye che Paolo pa Nkungulu, achinamanilaga kuti akusaka amanyilile uchenene ngani syakwe. ");
INSERT INTO yao_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nambo alakwe ngasimwajitichisya pakuŵa kwana ŵandu kupunda alobaini ŵakwajuŵilila kwaulaga. Alitaŵilile kuti ngalya natamuno kung'wa chachili chose mpaka ŵaulaje che Paolo ni sambano akulolela ichinjile pakulamula.” ");
INSERT INTO yao_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nipele jwankulu jwa ŵangondo jula ŵanlesile nchanda jula ajaule ni kunjamuka kuti, “Nkasala kwa mundu jwalijose kuti mumanyisye yeleyo.” ");
INSERT INTO yao_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nipele jwankulu jwa ŵangondo mia moja jula ŵaaŵilasile achakulu ŵaŵili mwa ŵangondo ŵakwe ni kwalajisya, “Mwaŵiche chile ŵangondo mia mbili ni ŵangondo ŵakwela mu falasi sabini ni ŵangondo ŵa mipamba mia mbili ajaulangane ku Kaisalia saa tatu ja chilo cha lelo. ");
INSERT INTO yao_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mwaŵiche chile falasi ŵampepe kuti ŵakwesye che Paolo aiche uchenene ku che Felikisi jwankulu jwa Chiloma mu chilambo cha ku Yudea.” ");
INSERT INTO yao_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Jwankulu jwa ŵangondo mia moja jula ŵalembile chikalata chanti nyi. ");
INSERT INTO yao_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ngunnamuchila alakwe che Felikisi jwankulu jwa Chiloma mu chilambo cha ku Yudea, uneji che Kilaudio Lusia ngunlembela. ");
INSERT INTO yao_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ŵayahudi ŵankamwile Mundu ju ni ŵatiji ammulaje. Nambo panaimanyi kuti ali Mloma nipele najawile ni mpingo wa ŵangondo kukunkulupusya. ");
INSERT INTO yao_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nanjawisye ku Nkungulu wao wekulu njisakaga kuti manyilile magambo gaŵaŵechetelaga. ");
INSERT INTO yao_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Naimanyi kuti ŵaaŵechetelaga nkati malajisyo gao, nambo uneji naiweni kuti nganakola magambo gagaligose gakuŵajilwa kuulajikwa atamuno kwataŵa mu nyuumba jakutaŵilwa. ");
INSERT INTO yao_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ŵandu paŵamanyisye une kuti Ŵayahudi akusosa itajile pakumbulaga mundu ju, pangakaŵa nalamwile kwaikanawo kukwenu, ni naasalile ŵaŵaŵechetelaga wo kuti aŵechete magambo gao kukwenu.” ");
INSERT INTO yao_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nipele ŵangondo ŵanjigele che Paolo mpela iŵatite pakusalilwa ni chilo chichocho ŵanjawisye ku Antipatili. ");
INSERT INTO yao_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Malaŵi jakwe ŵangondo mia mbili ŵaŵajendaga wamakongolo ŵaujile ku likome, ŵaalesile ŵangondo ŵaŵakwesile falasi ŵala ajendelechele ni ulendo wa kwapechesya che Paolo. ");
INSERT INTO yao_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ŵangondo ŵaŵakwesile falasi paŵaiche ku Kaisalia, ŵampele che Felikisi jwankulu jwa chilambo jo chikalata chila ni kwaŵika che Paolo mu ulamusi wao. ");
INSERT INTO yao_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Jwankulu jwa chilambo paŵachisyomile chikalata chila ŵausisye kuti che Paolo wa musi chi. Paŵapilikene kuti jwa ku Kilikia, ");
INSERT INTO yao_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ŵatite, “Chinagapilikanile magambo genu pataiche ŵandu ŵakumbechetela.” Nipele ŵalamwile kuti ŵaagose che Paolo mu nyuumba ja chimwenye ji che Helode. ");
INSERT INTO yao_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pagapite moŵa nsano, che Anania Jŵambopesi Jwankulu pamo ni achachekulu ŵampepe ni mundu jwa malajisyo ga Chiloma liina lyakwe che Telitulo ŵatuluchile ku Kaisalia. Ni ŵajawile kwa che Felikisi jula ni ŵansalile yanayose iŵammechetelaga che Paolo. ");
INSERT INTO yao_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Che Felikisi ŵammilasile che Paolo ni che Telitulo ŵatandite kwaŵechetela achitiji. “Alakwe ambuje che Felikisi, ntulongwesye yambone ni uweji tukutama kwa chitendewele katema kose ni kulinganya kwa indu kukupanganyikwa kwa upoche wa ŵandu ŵetu. ");
INSERT INTO yao_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tukwitichisya yelei mu kusengwa moŵa gose ni kuntogolela kwannope alakwe papalipose. ");
INSERT INTO yao_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nambo pangansakalisya nnope, ngunchondelela ntupililile ni kutupilikanila itukuŵecheta. ");
INSERT INTO yao_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tukumanyilila kuti mundu ju ali jwakogoya nnope. Atandisye utindiganyo mwa Ŵayahudi papalipose pachilambo pose ni sooni ali jwankulu jwa mpingo wa chidini wa Ŵanasaleti. ");
INSERT INTO yao_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ni sooni ŵalingaga kujisakasya Nyuumba ja Akunnungu, noweji twankamwile. Twasachile kwalamula ni malajisyo getu twachinsyene. ");
INSERT INTO yao_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nambo che Lusia jwankulu jwa ŵangondo mia moja, ŵaiche ni kunjigala mmakono mwetu kwa machili. ");
INSERT INTO yao_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ni ŵalamwile kuti ŵakwaŵechetela wo aichanje kukwenu, nomwe mwasyene chinkombole kwauchilichisya ni kwimanyilila uchenene indu itukwaŵechetela.” ");
INSERT INTO yao_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ŵayahudi wose nombe ŵajitichisye chiŵaŵechete che Telitulo kuti chili chisyene. ");
INSERT INTO yao_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nipele jwankulu jwa chilambo jula ŵangolochesye nkono che Paolo kuti aŵechete. Che Paolo ni ŵatite, “Ngusangalala nnope kulichenjela paujo penu pakuŵa ngumanyilila kuti alakwe ndi jwakulamula jwa ŵandu ŵetu kwa yaka yejinji. ");
INSERT INTO yao_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Pakuŵa alakwe mwasyene nkumanyilila kuti nganigapunde moŵa kumi na mbili chitandile panajawile kukupopela ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ŵayahudi nganasimana une njianganganaga ni mundu jwalijose. Nganasimana une njitindiganyaga pa Nyuumba ja Akunnungu pane mmajumba gao ga kupopelela atamuno palipose mmusi mo. ");
INSERT INTO yao_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Sooni ŵanyaŵa ngaakombola kunsalila alakwe usyene wa yakumechetela une sambano yo. ");
INSERT INTO yao_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Chingwitichisya paujo penu chili chimo, uneji ngwapopelela Akunnungu ŵa achambuje ŵetu, njilikuyaga alila litala lyaakuliŵilanga ŵanyawo kuti lili lya unami. Ngukulupilila yanayose yailembekwe mu itabu ya Malajisyo ga Akunnungu gaŵapele che Musa ni itabu ya ŵakulondola ŵa Akunnungu. ");
INSERT INTO yao_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Uneji ngwete chilolelo kwa Akunnungu mpela ŵanyawo yakuti pakulolela, kuti chikupagwe kusyuka kwa ŵandu ŵambone ni ŵangalumbana. ");
INSERT INTO yao_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nipele moŵa gose ngulinga nningwa wangu uŵe wambone paujo pa Akunnungu ni kwa ŵandu. ");
INSERT INTO yao_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Panatemi yaka yejinji kwakutalika ko, nausile ku Yelusalemu kuti naaichisye ŵandu ŵa chilambo changu yakwakamuchisya kwa ligongo lya ŵakulaga ni kukutaga mbopesi. ");
INSERT INTO yao_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Panaliji nkutenda yeleyo ni paŵasimene une pa Nyuumba ja Akunnungu ndili masile kuliswejesya. Nganiupagwa mpingo wa ŵandu natamuno utindiganyo. ");
INSERT INTO yao_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nambo ŵapali Ŵayahudi ŵane ŵaŵatyochele ku Asia, ŵanyawo ni ŵaŵaŵajilwe kuŵa paujo penu ni kuumechetela une iŵaga akwete chakuumechetela. ");
INSERT INTO yao_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Pane achinsyene ŵa asale chileŵo chiŵachisimene kukwangu panaliji pa Nkungulu wao wekulu, ");
INSERT INTO yao_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ikaŵe yankati liloŵe limo peli linaŵechete panajimi paujo pao kuti, ‘Ngulamulikwa lelo jino pakuŵa ngukulupilila kuti ŵawile chasyuswe.’ ” ");
INSERT INTO yao_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Nambo che Felikisi nsyene ŵaliji nkulimanyilila uchenene litala lyo, ŵaunichile ligambo lila ni kwasalila, “Pataiche che Lusia jwankulu jwa ŵangondo mia moja jo, chilamule magambo genu.” ");
INSERT INTO yao_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ni jwankulu jula ŵalamwile anjigale che Paolo ni kwalindilila, nambo aŵe ni uhulu kanandi ni akasaalekasya achambusangagwe kwapa yaikwasoŵa. ");
INSERT INTO yao_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pagapite moŵa gampepe, ŵaiche che Felikisi pamo ni che Dulusila ŵankwawo juŵaliji Myahudi. Ŵalamwile kuti aŵilanjikwe che Paolo ni ŵampilikanilaga achiŵechetaga yankati kwakulupilila Che Yesu Kilisito. ");
INSERT INTO yao_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nambo paŵatandite che Paolo kuŵecheta yankati indu yaikwatenda ŵandu aŵe ŵambone ni ungapundanganya ni lyuŵa Akunnungu lichiŵalamule ŵandu wose, che Felikisi ŵajogwepe ni ŵatite, “Sano njauleje, chinammilanje sooni napataga lipesa.” ");
INSERT INTO yao_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Katema ko che Felikisi ŵalolelaga kuti chapegwe mbiya ni che Paolo. Ligongo lyo ŵapundile kwaŵilanga sooni ni sooni kunguluka nawo. ");
INSERT INTO yao_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Payapite yaka iŵili, che Polikio Festo ŵaliji chilongola pamalo pa che Felikisi juŵaliji jwankulu jwa chilambo. Pakuŵa che Felikisi ŵasachile kwanonyelesya Ŵayahudi ŵalesile che Paolo mu nyuumba jakutaŵilwa mula. ");
INSERT INTO yao_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Moŵa gatatu pakumala che Festo kwinjila ku Kaisalia kugatanda masengo gakwe, ŵakwesile kwaula ku Yelusalemu. ");
INSERT INTO yao_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kweleko achakulu ŵambopesi pamo ni ilongola ŵa Ŵayahudi ŵansalile che Festo magambo ga che Paolo. ");
INSERT INTO yao_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ŵachondelele che Festo kuti ŵasalalisye ntima kwa kwaikanawo che Paolo ku Yelusalemu kuti ŵajuŵilile petala ni kwaulaga. ");
INSERT INTO yao_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nambo che Festo ŵaajanjile, “Che Paolo ali mu nyuumba jakutaŵilwa ku Kaisalia ni nansyene chinyaule kukoko pangakaŵa. ");
INSERT INTO yao_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mwaleche ilongola ŵenu ajaulangane pamo ni une kweleko akaaŵechetele naga atesile yangalumbana.” ");
INSERT INTO yao_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Che Festo ŵatemi nawo kwa moŵa nane pane likumi, nipele ŵaujile ku Kaisalia. Malaŵi jakwe ŵajawile ni kutama pa chitengu cha ulamusi, ŵalamwile kuti ŵaichenawo che Paolo. ");
INSERT INTO yao_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paŵaiche che Paolo, Ŵayahudi ŵaŵakopochele ku Yelusalemu ŵansyungwile ni kutanda kwaŵechetela yejinji yakutopa ni nganakombolanga kuisalichisya. ");
INSERT INTO yao_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Nkulichenjela, che Paolo ŵatite, “Uneji nganimbanganya magambo gagaligose gankati malajisyo ga Ŵayahudi pane nkati Nyuumba ja Akunnungu natamuno kwa Mwenye jwa ku Loma.” ");
INSERT INTO yao_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nambo che Festo ŵasachile kulinonyelesya kwa Ŵayahudi ni ŵambusisye che Paolo, “Ana nkusaka kwaula ku Yelusalemu nkalamulikwe kweleko yankati magambo ga paujo pangu?” ");
INSERT INTO yao_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Nambo che Paolo ŵatite, “Ngwima paujo pa nkungulu wa Mwenye jwa ku Loma, pelepa ni panguŵajilwa kulamulikwa. Alakwe mwasyene nkumanyilila uchenene, uneji nganinaapanganichisya Ŵayahudi changalumbana chachili chose. ");
INSERT INTO yao_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nipele iŵaga ngwete magambo pane ndesile yangalumbana yakuŵajilwa kuulajikwa, ngangukana kuwa. Nambo iŵaga ngapagwa usyene wa magambo gakumechetela une ŵandu ŵa, ngapagwa mundu juchakombole kuundaga mmakono mwa ŵanyawo. Ngusaka mumbeleche kwa Mwenye jwa ku Loma.” ");
INSERT INTO yao_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nipele che Festo paŵamasile kuŵecheta ni ŵandu ŵa nkungulu ŵansalile che Paolo, “Nkusaka kunjausya kwa Mwenye jwa ku Loma, ayaga, chinjaule kwa Mwenye jwa ku Loma.” ");
INSERT INTO yao_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Gali gapite moŵa gampepe, mwenye che Agilipa ni che Belinike nlumbugwe, ŵaiche ku Kaisalia kukwakomasya che Festo. ");
INSERT INTO yao_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ni ŵatemi kweleko moŵa gampepe ni che Festo nombe ŵansalile mwenye ngani ja magambo ga che Paolo achitiji, “Kwana mundu jumo pelepa juŵannesile che Felikisi ali mu nyuumba jakutaŵilwa. ");
INSERT INTO yao_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Panajawile ku Yelusalemu achakulu ŵambopesi pamo ni achachekulu ŵa Ŵayahudi ŵambechetele mundu jo ni kuunjondelela kuti naalamule ni kwajamuka. ");
INSERT INTO yao_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nambo uneji naasalile kuti Ŵaloma nganakola masyoŵelo go ga kuntyosya mundu alamulikwe akanaŵe kuchingangana ni ŵandu ŵakumbechetela meeso ni meeso, ni kwapa lipesa lya kulichenjela kwa iŵambechetele yo. ");
INSERT INTO yao_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Nipele, paŵasongangene apano, nganingaŵa, malaŵi jakwe natemi pachitengu changu cha ulamusi ni kulajisya annyichenawo mundu jo. ");
INSERT INTO yao_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ŵakumbechetela ŵakwe paŵajimi, nganakoposya magambo ga yangalumbana mpela inaganisyaga. ");
INSERT INTO yao_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nambo ŵakanilanaga ine pe yankati dini jao ni yankati mundu jumo jwakuŵilanjikwa Che Yesu jwaŵawile nambo che Paolo akulimbila kuti ali ŵajumi. ");
INSERT INTO yao_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nganinaimanyilila chakutenda nkati magambo ga. Nipele, nambusisye che Paolo iŵaga chasache kwaula ku Yelusalemu kukulamulikwa kweleko magambo ga. ");
INSERT INTO yao_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nambo che Paolo ŵasachile kulamulikwa ni Mwenye jwa ku Loma, nalamwile kuti angose mu nyuumba jakutaŵilwa mpaka pachinaapeleche kwa Mwenye jwa ku Loma.” ");
INSERT INTO yao_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Che Agilipa ŵane juŵaliji mwenye jwa liuto liine ŵansalile che Festo, “None ngusaka kumpilikanila nansyene mundu jo.” Che Festo ŵatite, “Chimumpikanile malaŵi.” ");
INSERT INTO yao_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Malaŵi jakwe che Agilipa ni che Belinike ŵaiche ali nkusangalala pa nkungulu ali alongene ni achakulu ŵa ŵangondo ni achakulu ŵa musi. Che Festo ŵalamwile kuti ŵaichenawo che Paolo. ");
INSERT INTO yao_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Che Festo ŵatite, “Mwenye che Agilipa ni ŵanawose ŵantemi apano pamo ni uweji! Ŵayahudi wose ŵa pelepa ni ŵa ku Yelusalemu akummechetela mundu ju kukwangu ni akusaka aulajikwe. ");
INSERT INTO yao_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nambo uneji nganinagawona magambo gagaligose gakwaŵajila kuulajikwa. Ni pakuŵa che Paolo nsyene ŵasachile alamulikwe ni Mwenye jwa ku Loma, noneji najitichisye kunjausya ku Loma. ");
INSERT INTO yao_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kwa uneji nganingola usyene wankati ŵelewo wakunlembela Mwenye jwa ku Loma. Kwa ligongo lyo nannyichenawo paujo penu nnopennope kukwenu achimwene mwenye che Agilipa, mwamalaga kumbusyausya mbate chakulemba. ");
INSERT INTO yao_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Pakuŵa nguwona chiiŵe yakusekasya kwajauchisya jwantawe pangasala uchenene yakwaŵechetela yo.” ");
INSERT INTO yao_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Nipele che Agilipa ŵansalile che Paolo, “Nkukombola kulichenjela.” Pelepo che Paolo ŵagolwesye nkono wao ni kulichenjela, achitiji. ");
INSERT INTO yao_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mwenye che Agilipa, nguliwona ngwete upile lelo jino kwima paujo penu ni kulichenjela yankati yanayose yakumechetela une Ŵayahudi. ");
INSERT INTO yao_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nnopennope pakuŵa alakwe mwasyene nkumanyilila uchenene masyoŵelo ga Ŵayahudi ni umenyani wao, ngunchondelela mumbilikanile mu upililiu. ");
INSERT INTO yao_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ŵayahudi wose akuumanyilila une uchenene chitandile uchanda wangu. Akumanyilila inatite pakutama ni ŵanyawo mu chilambo changu ni ku Yelusalemu nombeko chitandile ndanda jo. ");
INSERT INTO yao_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Akuumanyilila une chitandile kalakala ni asakaga akukombola kuŵalanga umboni kuti chitandile ndanda jo naliji jumo jwa mpingo wa Mafalisayo ŵakwapopelela Akunnungu kupunda ŵandu ŵane wose. ");
INSERT INTO yao_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ni sambano nyimi pelepa kulamulikwa ligongo nguchilolela chilanga chiŵalanjile Akunnungu kwa achambuje ŵetu chila. ");
INSERT INTO yao_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Chilanga cho ni chichocho chaakuchilolela ngosyo kumi na mbili sya ŵandu ŵetu kuti chimalile, achatumichilaga Akunnungu nkulimbangana muusi ni chilo. Ni kwaligongo lyo alakwe mwenye, Ŵayahudi ŵa akuumechetela une. ");
INSERT INTO yao_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ŵanyamwe wose ŵandi apano kwa chichi nkuganisya kuti Akunnungu ngakukombola kwasyusya ŵawe? ");
INSERT INTO yao_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Isyene uneji nansyene naliweni kuti ngusachilwa kutendekanya yejinji yakunkanila Che Yesu jwa ku Nasaleti. ");
INSERT INTO yao_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yelei ni inaitesile ku Yelusalemu kula. Napochele lilamulo kutyochela kwa achakulu ŵambopesi, naakamwile ŵandu ŵajinji mwa ŵandu ŵa Akunnungu ni kwataŵa mu nyuumba jakutaŵilwa. Ni ŵanyawo paŵalamulikwe kuulajikwa, uneji nakundile aulajikwe. ");
INSERT INTO yao_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Naalagesye mmajumba gao ga kupopelela ni kwakanganichisya atukane. Naatumbilile kwannope namose najawile kukwasosasosa mmisi ja ilambo yakutalichila kuti naalagasye. ");
INSERT INTO yao_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ligongo lya masengo gagogo pego najawile ku Damesiki ndili ni ulamusi ni malajisyo ga achakulu ŵambopesi. ");
INSERT INTO yao_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Alakwe mwenye, panaliji mwitala muusi, lyuŵa lili pa ntwe naliweni lilanguka lyekulungwa kupunda lilanguka lya lyuŵa lichilanguchisyaga kutyochela kwinani. Ni lyatusyungwile uneji pamo ni achinjangu ŵanaliji nawo mu ulendo mo. ");
INSERT INTO yao_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Wose twagwile, none napilikene liloŵe lichisalilaga mchiebulania, ‘Che Sauli, che Sauli! Ligongo chi nkuulagasya? Nkuliulasya mwasyene pangali ligongo mpela ng'ombe jajikuchiputa chiboko cha mmbujegwe.’ ");
INSERT INTO yao_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Noneji nausisye, ‘Ana ŵaani alakwe, Ambuje?’ Ni Ambuje wo ŵajanjile, ‘Uneji ndili Che Yesu junkunlagasya mmwejo. ");
INSERT INTO yao_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nambo Sambano njime, nankopochele kuti nambiche mme nkamusi jwangu. Mmwejo chimmalanje ya uneji, chimwasalile ŵandu yanyiweni lelo jino ni ichinannosye kanyuma. ");
INSERT INTO yao_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Chinankulupusye kutyoka mwa ŵandu wa ku Isilaeli pamo ni ŵandu ŵangaŵa Ŵayahudi kuchinantume une ko. ");
INSERT INTO yao_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mwatatanukule meeso gao kuti akombole kopoka mu chipi ni kwinjila mu lulanga nombe akopoche mu ulamusi wa Shetani ni kwagalauchila Akunnungu kuti kwa kungulupilila une alecheleswe sambi syao ni kwinjila majumba pamo ni ŵandu ŵasagulikwe ni Akunnungu.’ ");
INSERT INTO yao_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Kwapele, alakwe mwenye che Agilipa, uneji nganileka kwitichisya yakwiwona yaikopochele kwinani. ");
INSERT INTO yao_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nipele natandite kulalichila maloŵe ga Akunnungu kwa ŵakutama ku Damesiki ni ku Yelusalemu ni chilambo chose cha ku Yudea pamo ni ŵandu ŵangaŵa Ŵayahudi. Naalalichile aleche sambi ni kwaujilila Akunnungu ni kulosya kwa isambo yao kuti alesile sambi. ");
INSERT INTO yao_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwa ligongo lya maloŵe go Ŵayahudi ŵangamwile une ndili pa Nyuumba ja Akunnungu ni kusaka kumulaga. ");
INSERT INTO yao_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nambo Akunnungu aang'osile, mpaka lelo jino ndili jwansima. Noneji nguŵalanga kwa achanandi ni achakulungwa. Ngangusala ine ikaŵe yeila yasasile ŵakulondola ŵa Akunnungu ni che Musa kuti chiikopochele, ");
INSERT INTO yao_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","yakuti yaŵajilwe Kilisito alaje ni kuŵa mundu jwaandanda kusyuka mwa wose ŵawile. Nombejo chakombole kwaichisya lilanguka Ŵayahudi ni ŵandu ŵangaŵa Ŵayahudi.” ");
INSERT INTO yao_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Che Paolo paŵalichenjele mpaka pelepo, che Festo ŵaŵechete kwa liloŵe lyekulungwa, “Mmwe che Paolo ntekupungwana! Kulijiganya kose kuntesile mpungwane.” ");
INSERT INTO yao_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Che Paolo ŵajanjile, “Nganimbungwana, alakwe ambuje che Festo. Chinguŵecheta cho chili chisyene ni cha lunda. ");
INSERT INTO yao_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Alakwe mwenye che Agilipa nkuimanyilila uchenene yose yaikopochele yo. Noneji ngukombola kuŵecheta pangali lipamba paujo penu pakuŵa nguimanyilila isyene kuti ngapagwa chichatendekwe pachisyepela. ");
INSERT INTO yao_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mwenye che Agilipa, ana nkugakulupilila maloŵe gaŵaŵechete ŵakulondola ŵa Akunnungu, ŵa kalakala? Ngumanyilila kuti nkugakulupilila!” ");
INSERT INTO yao_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ni che Agilipa ŵansalile che Paolo, “Ana nkuganisya kuti kwa katema kakajipi peka chinkombole kundendekasya meje Mkilisito?” ");
INSERT INTO yao_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Che Paolo ŵajanjile, “Iŵaga kwa katema kakajipi pane kakajinji, ngwapopelela Akunnungu, ngaŵa alakwe pe nambo ni ŵanawose ŵakumbikanila lelo jino ŵa aŵanje mpela indite pakuŵa une, nambo anaichile kutaŵikwa minyolo mpela une.” ");
INSERT INTO yao_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pelepo mwenye che Agilipa ni jwankulu che Festo ni che Belinike pamo ni ŵane wose ŵaŵaliji pamo nawo ŵajimi. ");
INSERT INTO yao_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ni paŵakopokaga ŵasalilene, “Mundu ju nganapanganya chachili chose chakusachilwa kuulajikwa natamuno kwataŵa.” ");
INSERT INTO yao_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Che Agilipa ŵansalile che Festo, “Ikakomboleche kungopola mundu ju ngaakaŵende kulamulikwa ni Mwenye jwa ku Loma.” ");
INSERT INTO yao_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Paŵalamwile kuti tujaule ku Italia ni ngalaŵa ŵammisile che Paolo pamo ni ŵatawe ŵane mmakono ga che Juliasi, juŵaliji jwankulu jwa ŵangondo mumpingo waukuŵilanjikwa “Mpingo wa Agusto.” ");
INSERT INTO yao_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Twakwesile ngalaŵa jekulungwa jijatyochelaga ku Adiliamiti, jijaliji chile kutanda ulendo kupitila mbwani ja chilambo cha ku Asia ni twatandite ulendo. Che Alisitako mundu jwa ku Makedonia kutyochela ku Sesalonike ŵalongene noweji. ");
INSERT INTO yao_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Lyuŵa lyaaŵili twaiche ku Sidoni ni ngalaŵa. Nipele che Juliasi ŵaapanganichisye yambone che Paolo, ŵalesile ajaule kwa achambusangagwe kuti apegwe yaikwasoŵa. ");
INSERT INTO yao_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kutyochela kweleko twajendelechele ni ulendo, ni twapite mungulugulu chilumba cha Kupulo tuchilisepusyaga ni mbungo jijaliji jininkupuga nnope kutyochela paujo petu. ");
INSERT INTO yao_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Twajombweche bahali ja Kilikia ni Pamfilia ni twaiche mmusi wa Mila chilambo cha ku Likia. ");
INSERT INTO yao_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ni kweleko jwankulu jwa ŵangondo jula ŵajisimene ngalaŵa jekulungwa jichikopochelaga ku Alekisandilia kwaula ku Italia, nombejo ŵatujinjisye mwelemo. ");
INSERT INTO yao_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Twajesile mbolembole moŵa gamajinji ni twaiche pachiŵandi ni Nido nkulaga. Pakuŵa mbungo jatusiŵilile kuendelechela ni twapite kusini kwa chilumba cha Kilete kuŵandikana ni Salomone. ");
INSERT INTO yao_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Twapite mumbwani kwa kulaga ni twaiche peuto papakuŵilanjikwa “Bandari jambone,” pachiŵandi musi wa Lasea. ");
INSERT INTO yao_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Gaapite moŵa gamajinji ni moŵa gakutaŵa gaapite, ni twaliji mmoŵa ga kogoya kuendelechela ni ulendo wa mu ngalaŵa. Nipele che Paolo ŵaajamwiche achitiji, ");
INSERT INTO yao_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Achalongo achinjangu, nguwona kuti ulendo wu chiuŵe wa kogoya ni kusoyesya indu, ngaŵa kwa ndundu ni ngalaŵa pe, nambo kwa umi wetu nombe.” ");
INSERT INTO yao_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Nambo jwankulu jwa ŵangondo jula ŵagapikanile nnope maloŵe ga juŵalongosyaga ngalaŵa ni nsyene ngalaŵa kupunda maloŵe gaŵaŵechete che Paolo gala. ");
INSERT INTO yao_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Pakuŵa bandari jo nganijiŵa jambone kutama moŵa ga mbepo, ŵandu ŵaŵatupile ŵajitichisye kuendelechela ni ulendo yakombolekaga aichanje ku Finikisi ni kutama kweleko katema ka mbepo ko. Finikisi jili bandari ja Kilete jajilolite kwiŵanda ni kwichela. ");
INSERT INTO yao_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mbungo ja kusi jatandite kupuga ni ŵaganisisye kuti chakombole kutendekanya iŵasachile yo. Nipele ŵanyakwile nanga ni kuŵika mu ngalaŵa, ŵajendelechele ni ulendo ŵapite mbwani kwa mbwani ni kwika ku mbwani ja Kilete. ");
INSERT INTO yao_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nambo pangakaŵa, mbungo jekulungwa jati mpela chimbunga jajikuŵilanjikwa “Mbungo ja kaskazi” japujile kutyochela ku chilumba. ");
INSERT INTO yao_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ngalaŵa jila jagombilwe ni mbungo, nombejo nganijikombola kujipunda mbungo, nipele twajilesile jiseleleche ni mbungo. ");
INSERT INTO yao_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nkwenda mo twapite upande wa kusini mwa chilumba chachinandi liina lyakwe Kauda, twakombwele kwakulimba nnope kugopola ntumbwi wa kwakulupuchisya ŵandu mu ngalaŵa jekulungwa jila. ");
INSERT INTO yao_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Achikatumetume ŵaali mu ngalaŵa ŵala paŵanyakulile ntumbwi ula nkati, ŵautaŵilile mu ngalaŵa jila ni ngonji kuulimbisya kuti unajonasiche ni mbungo. Ni pakuŵa ŵajogopaga kutitimila munsanga wejinji mu mbwani ja Libia, kwa yele ŵagatulwisye matanga ni ŵagambaga kwenda pe ni mbungo. ");
INSERT INTO yao_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Mbungo jekulungwa jila jajendelechele kupuga ni malaŵi jakwe ŵatandite kwasila ndundu mu bahali. ");
INSERT INTO yao_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ni lyuŵa lyaatatu ŵajasile ni makono gao achinsyene yoombo ya mu ngalaŵa jekulungwa. ");
INSERT INTO yao_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Moŵa gamajinji nganitukombola kuliwona lyuŵa atamuno ndondwa ni mbungo jekulungwa jila japundile nnope. Chilolelo chose chati tutulame chamasile. ");
INSERT INTO yao_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Paŵatemi pangalya moŵa gamajinji, wajimi che Paolo pasikati pao ni kuti, “Achambusanga ŵangu nkambikanichisye une kuti kasintyoka ku Kilete ngankalaje kwantinyi ni kupotesya indu yi. ");
INSERT INTO yao_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Sambano ngunchondelela, nkamulichisye ntima pakuŵa ngapagwa jwalijose mwa ŵanyamwe juchawe nambo ngalaŵa pe ni jichijijonasiche. ");
INSERT INTO yao_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Pakuŵa chilo katumetume jwa kwinani jwa Akunnungu, Akunnungu jwandesile une kuŵa jwao ni jungwapopelela ŵangopochele, ");
INSERT INTO yao_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ni kuusalila, ‘Kasinjogopa che Paolo! Ikuŵajilwa mmwejo kwima paujo pa Mwenye jwa ku Loma. Kwaligongo lyenu mwe Akunnungu chiŵakulupusye wose ŵaali mu ulendo pamo nomwe.’ ");
INSERT INTO yao_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nipele nkamulichisye ntima, pakuŵa ngwakulupilila Akunnungu kuti chiitendekwe mpela indite pakusalilwa. ");
INSERT INTO yao_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nambo chituponyekwe pa chilumba chimo.” ");
INSERT INTO yao_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Chilo cha lyuŵa lya kumi na nne twaliji tuninkukwekwelemya akuno ni akunokuno ni meesi mu bahali ja Mediteleniani. Chilo nnope achikatumetume ŵaali mu ngalaŵa ŵaganisisye kuti tuŵandichile munsanga. ");
INSERT INTO yao_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Nipele ŵatulwisye ngoji wawataŵilile chindu chakutopela achisakaga kupima amanyilile ipatite kwendesya ni ŵapatile makono alobaini. Kanyuma kanandi ŵapimile sooni ni ŵapatile makono selasini. ");
INSERT INTO yao_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ni pakuŵa ŵajogopaga kukwama papali ni lwala, ŵatulwisye nanga ncheche sya kunyuma kwa ngalaŵa ni kupopela kuti kucheje. ");
INSERT INTO yao_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ni ŵaŵalongosyaga ngalaŵa ŵala ŵasachile kutila kutyochela mu ngalaŵa ni ŵautulwisye ntumbwi ula achinamanilaga akutulusya nanga sya paujo. ");
INSERT INTO yao_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nambo che Paolo ŵansalile jwankulu jwa ŵangondo jula pamo ni ŵangondo ŵane, “Iŵaga ŵanyaŵa ngaatama mu ngalaŵa ngankulupuswa.” ");
INSERT INTO yao_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Papopo ŵangondo ŵala ŵakatile migoji jijakamulile ntumbwi ni ŵaulesile ujigalikwe ni meesi. ");
INSERT INTO yao_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kukanaŵe kucha che Paolo ŵachondelele wose kuti alye chakulya achitiji, “Lelo jino lyuŵa lya kumi na nne ntemi ni sala nli nkulolela, pangalya chindu chachili chose. ");
INSERT INTO yao_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nipele ngunchondelela nlye, pakuŵa chichinkulupusye kuti nkawa. Pakuŵa ngalujasika namuno luumbo lumo lwa pa mitwe jenu.” ");
INSERT INTO yao_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Che Paolo paŵamasile kuŵecheta yeleyo ŵajigele nkate, nipele ŵatogolele Akunnungu paujo pa wose, ŵagaŵenye ni kutanda kulya. ");
INSERT INTO yao_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Nipele wose ŵakamulisye ntima, nombewo ŵalile. ");
INSERT INTO yao_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ŵatwaliji mu ngalaŵa twaliji ŵandu mia mbili ni sabini na sita. ");
INSERT INTO yao_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Patwalile wose ni kwikuta, ŵajijalwisye ngalaŵa jekulungwa kwakwasila ngano mu bahali. ");
INSERT INTO yao_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Pakwachele ŵaŵalongosyaga ngalaŵa ŵala nganachimanyilila chilambo chila, nambo ŵauweni nsanga ku mbwani. Nipele ŵasachile kujijimika ngalaŵa kweleko naga chakombole. ");
INSERT INTO yao_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ŵakatile ngonji sya nanga ni kusileka mu bahali ni ŵagopwele ngonji sisyataŵikwe pa usukani ni kwinamukula tanga ja paujo pa ngalaŵa kuti jikamule mbungo ni kwajausya ku mbwani. ");
INSERT INTO yao_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nambo ŵaiche pamalekano pagachingangene matala gaŵili ga meesi ga bahali ni ngalaŵa jatanjile palapala. Upaande wa paujo pa ngalaŵa watitimile munsanga pangali kutinganyika, nambo upaande wa panyuma watandite kutemeka kwa ligongo lya machili ga matumbela. ");
INSERT INTO yao_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ŵangondo ŵasachile ŵaulaje ŵataŵikwe wose atakojelela ŵane ni kutila. ");
INSERT INTO yao_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nambo jwankulu jwa ŵangondo achisakaga kwakulupusya che Paolo, ŵaalekasisye ŵangondo akatenda yeleyo. Ŵalamwile ŵaakukombola kojelela alilechelele mmeesi ni kwika kunsanga. ");
INSERT INTO yao_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ni ŵaakusigalila wo, ŵane akamulile mbao ni ŵane ipitingwa iyatemeche mu ngalaŵa. Iyoyo ŵandu wose ŵaiche kwa chitendewele ku nsanga. ");
INSERT INTO yao_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Patwaiche kwa chitendewele ku nsanga, twaimanyi kuti chilumba chila chikuŵilanjikwa Melita. ");
INSERT INTO yao_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ni ŵandu ŵangali lunda ŵatutendele yambone nnope. Ula jatandite kunya ni kwaliji ni mbepo, ŵatukolechesye mooto tujootele ni kutukalibisya. ");
INSERT INTO yao_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Che Paolo ŵalokwete litenje lya sasu ni ŵasiŵisile pa mooto. Paŵaŵikaga, lijoka lyakopweche ligongo lya ntukuta wa mooto ula lyaliŵilijile pankono wakwe. ");
INSERT INTO yao_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ŵandu ŵa kweleko wo paŵaliweni lijoka lili nkuliŵilijila pankono wakwe ŵasalilene, “Kusyene mundu ju ali jwakuulaga, namuno akulupwiche mmeesi nambo chisasi cha nnungu jwetu jwankongwe jwakuŵilanjikwa Haki ngachikunneka alame.” ");
INSERT INTO yao_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Nambo che Paolo ŵalikung'undile lijoka lyo pa mooto ni nganilimpeteka namose kanandi. ");
INSERT INTO yao_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ŵandu ŵala ŵaliji nkulolela kuti pane tuimbe nkono, pane chagwe ni kuwa papopo. Nambo paŵalolele nnope ni nganachiwona chindu chakwaŵenga chichapatile, ni ŵagalawisye ng'anisyo syao ni kuti ali jumo jwa achiminungu. ");
INSERT INTO yao_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Pachiŵandi ni pepala kwaliji ni migunda ja jwankulu jwa chilumba chila jwakuŵilanjikwa che Pabulio. Mundu ju ŵatupochele yambone ni twatemi mu nyuumba jao ja achalendo kwa moŵa gatatu. ");
INSERT INTO yao_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Atati ŵao che Pabulio ŵaliji agonile ali nkulwala chiilu ni mmatumbo mwa miasi. Che Paolo ŵajawile kukwalola ni paŵamasile kupopela, ŵasajichile makono gao ni kunlamya. ");
INSERT INTO yao_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Payakopochele yeleyo, iyoyo peyo ŵakulwala ŵajinji ŵaŵatamaga mu chilumba chila ŵaiche, nombewo ŵalamiswe. ");
INSERT INTO yao_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ŵandu ŵala ŵatuchimbichisye nnope, ni katema patwatyokaga ŵatupele yose iyatusoŵile mu ulendo wetu. ");
INSERT INTO yao_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Pajapite miesi jitatu, twatandite sooni ulendo wetu kwa ngalaŵa jekulungwa jimo jijasigele mu chilumba mula, jichilindililaga gapite kaje moŵa ga mbepo. Ngalaŵa jila jakopochele ku Alekisandilia ni jaŵilanjikwe “Achiminungu Maŵila.” ");
INSERT INTO yao_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Twaiche ku Silakusa ni twatemi pelepo moŵa gatatu. ");
INSERT INTO yao_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kutyochela pelepo twasyungwile mumbali ni twaiche ku Legio. Malaŵi jakwe jatandite kupuga mbungo kutyochela kulujenda ni pagapite moŵa gaŵili twaiche ku Puteoli. ");
INSERT INTO yao_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kweleko twasimene ŵandu ŵakunkulupilila Che Yesu achinjetu ni ŵatuchondelele tutame pamo nawo chijuma chimo. Kwanti nyi ni itwatite pakwika ku Loma. ");
INSERT INTO yao_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ŵandu ŵakunkulupilila Che Yesu ŵa ku Loma paŵapilikene ngani syetu ŵaiche mpaka Pakusumichisya Malonda che Apio ni ŵane ku Majumba Gatatu ga Achalendo kukutuchingamila. Che Paolo paŵaweni ŵelewo ŵaatogolele Akunnungu ni ŵalimbiswe ntima. ");
INSERT INTO yao_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Patwaiche ku Loma ŵakundile kuti che Paolo atame pajikape pamo ni jwangondo juŵanlindililaga. ");
INSERT INTO yao_vpl VALUES ("AC28