﻿USE sofia;
DROP TABLE IF EXISTS sofia.yam_vpl;
CREATE TABLE yam_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yam_vpl WRITE;
INSERT INTO yam_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yè'e mvə̀'nə̀ ŋgwì bʉ̀ nə̀ Jisos Krɛst à tesə bohòwo à ye. Jisòs à tesə bohòŋgwì bʉ̀ nə̀ Devìd. Devìd à tesə bohòŋgwì bʉ̀ nə̀ Abràham. ");
INSERT INTO yam_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abràham dzə Azìk; Azìk dzə Jàkop; Jàkop dzə Judà bə bwe ma ye wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judà à dzə Perè bə Zerà. (Liŋ ma àwo à ye də Tamà.) Perè dzə ye Hezròŋ; Hezròŋ dzə Ràm; ");
INSERT INTO yam_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ràm dzə Àminadàp; Àminadàp dzə Nasòŋ; Nasòŋ dzə Samòŋ; ");
INSERT INTO yam_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Samòŋ dzə Bowàs. (Liŋ ma Bowàs à ye də Rahàp.) Bowàs dzə Obè. (Liŋ ma Obè à ye də Rus.) Obè nə à dzə ye Jesì; ");
INSERT INTO yam_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesì à dzə ŋkum Devìd yi. Devìd nə dzə Sòlomù. (Ma Sòlomù nə ànə ye to me ŋgwe Yùriyà sə̀'.) ");
INSERT INTO yam_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sòlomù dzə Rèhobòm; Rèhobòm dzə Àbijà; Àbijà dzə Asà; ");
INSERT INTO yam_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asà dzə Jèhosafà; Jèhosafà dzə Joràm; Joràm dzə Uziyà; ");
INSERT INTO yam_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziyà dzə Jotàm; Jotàm dzə Ahàs; Ahàs dzə Hèzìkayà; ");
INSERT INTO yam_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hèzìkayà dzə Mànasì; Mànasì dzə Amòn; Amòn dzə Jòsayà; ");
INSERT INTO yam_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jòsayà dzə Jèkòniyà bə bwe ma ye wèŋ. Yi à dzə yà' ghà nə̀ bʉ̀ʉ Babilòŋ wèŋ à kə̀ ko kùrə lòbʉ̀ʉ Izùrɛ wèŋ la'à wo co ŋkwɛ̀ŋ yà'a. ");
INSERT INTO yam_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ghà nə̀ wo ànə jəŋ lo me wo mvwe' lak Babilòŋ anə vɛ'nə fana Jèkòniyà dzə Seatì; Seatì dzə Zèrubabè; ");
INSERT INTO yam_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zèrubabè dzə Àbiyù; Àbiyù dzə Èliyakìm; Èliyakìm dzə Azò; ");
INSERT INTO yam_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azòdzə Zadòk; Zadòk dzə Acìm; Acìm dzə Eliyù; ");
INSERT INTO yam_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyù dzə Eliyazà; Eliyazà dzə Matàn; Matàn dzə Jàkop; ");
INSERT INTO yam_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jàkop dzə Jòsep nə̀ yi à ye ndu Mèri. Mèri nə̀ yi à ye ma Jisòs, wo to yi mok də Krɛst. (A yà'a də, ŋkum ŋgà gèm bwìŋ.) ");
INSERT INTO yam_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A yà'a də, ye jəŋ mʉni'ì Abràham kə dzeŋ mʉni'ì Devìd, yà' sə nìtsə̀' də tàcicii bwìŋ à ye hum-ncòp-kwè. Ye jəŋ bwi mʉni'ì Devìd kə dzeŋ mvə̀'nə̀ wo à ko lòbʉ̀ʉ sə mvwe' lak Babilòŋ fana tàcicii bwìŋ à ye sə̀' hum-ncòp-kwè. Ye ŋga'a fa'nə kə dzeŋ mvə̀'nə̀ wo à dzə Krɛst nə, a sə̀' hum-ncòp-kwè. ");
INSERT INTO yam_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nsàp mandzə̀ nə̀ wo ànə dzə Jisòs Krɛst à ye mʉmvə̀' nè'e. Jòsep à sə sak ma ye Mèri gù. Yi kà nà' ntòsə̀ jə fana Mèri nə tse' zʉm bə ŋàaŋ Yòŋsə̀ nə̀ Rərɛŋ nə. Bwìŋ à rɛɛŋ də Mèri bə zʉm. ");
INSERT INTO yam_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jòsep à ye ŋwə̀ nəmòk nə̀ yi à sə gʉ̀gə̀ bum ye pwe' bə mandzə̀ nə̀ kə̀kʉrə̀. Fana yi kà dzəm də yi fa Mèri marè'tu mʉtsətsə'rə bwìŋ dzəm. Yi sə tsərə mʉmvə̀'nə̀ yi nə co'rə fis bo sənə nzak gù nə̀ bə Mèri tse' nə gəe'. ");
INSERT INTO yam_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yi ànə sə tsərə bum yè'sə fana masinjà Tà Nwì və̀ bohòyi ndzə loò, nə dʉk fa yi də, <<Wùu Jòsep ŋgwì bʉ̀ Devìd, kà də wu wəp ŋgòjə Mèri də yi ye ŋgwe yo dʉk. Bʉsə̀ yi a tse' zʉm yà'sə bə ŋàaŋ Yòŋsə̀ nə̀ Rərɛŋ nə. ");
INSERT INTO yam_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mèri nə nə dzə mombam. Yi dzə nà', wù to fa yi liŋ də Jisòs, bʉ̀ʉsə̀ a yi nə̀ yi nə fis bʉ̀ʉ ye wèŋ mvwe' bʉp awo sə̀ wo gʉ̀ʉ.>> ");
INSERT INTO yam_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bum yè'sə à sə ye vɛ'nə pwe'fo' ŋgògʉ̀ də ya yusə̀ Tà Nwì ànə cep casə yà' mʉ cùhù ŋgàa tsòhòbum ye wèeŋ bʉʉŋ və zìnə. Wo à tsə̀' də, ");
INSERT INTO yam_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","<<Mʉwà'ŋgwɛ̀ŋ nə̀ yi ka ŋwə̀mbam riŋ yuk nə zʉʉ. Yi nə dzə mwembam, wo to liŋ ye də Ìmanùwè.>> (Liŋ yà'sə də, Nwì cu venə wèŋ.) ");
INSERT INTO yam_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jòsep ànə yəəŋ və fana yi gʉ megu sə̀' mʉmvə̀'nə̀ masinjà Tà Nwì anə tsok yi sə. Yi jəŋ Mèri ŋgòye ŋgwe ye. ");
INSERT INTO yam_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bə nà' à ka kè co ŋgwe bə ndum be'lə lok tè yi dzə mo nə. Yi à dzə nà', Jòsep to fa nà' liŋ də Jisòs. ");
INSERT INTO yam_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Wo à dzə Jisòs mvwe' mʉbuk lak Betèrèhem, mvwe' nzeŋgòŋ Jùdiyà. Ghà nə̀ wo à dzə yi nə, à ye ŋga Heròcu ŋkum yi. À ka ŋkʉ̀ʉŋ sap fana bʉ̀ʉ səmok sə̀ wo rì fàha ŋkə̀ŋkàŋ wèŋ və ma ntonùm. Wo à kə̀ dzèŋ mvwe' lak Jòrosalèm, ");
INSERT INTO yam_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","wo fek də, <<Ŋkum bʉ̀ʉ Jus wèŋ nə̀ wo dzə yi nə fòlɛ? Vès yə ŋkə̀ŋkà ye ŋga nà' tesə kok ma nùm fana vès və̀ də vèes kə kuksə yi.>> ");
INSERT INTO yam_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ŋkum Heròànə yuk bum yè'sə fana yà' fa yi ŋgə' vɛ'ɛ wùriŋ. Yà' fa bʉ̀ʉ sə̀ mvwe' lak Jòrosalèm pwe' ŋgə' sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Fana yi to benə ŋgàa fa satikà' sə̀ ghaŋ sə̀ wo fagə̀ Nwì satikà' mʉmvwe' ndap Nwì nə̀ ghaŋ nə, nə ye bə ŋgàa yə'rə̀ fa bwìŋ lʉ̀k wèŋ. Yi to benə yà' mvwe' mò'fis, nə fek yà'wèŋ dʉk də, <<Wo à də wo nə̀ dzə Ŋkum ŋgà gèm bwìŋ nə yè'e ma nə̀ fò?>> ");
INSERT INTO yam_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wo dʉk fa yi də, <<Mvwe' buk lak Betèrèhem nə̀ mvwe' nzeŋgòŋ Jùdiyà. Bʉsə̀ ŋgàa tsòhòbum Nwì wèŋ à còm nòŋsə vɛ'nə də, ");
INSERT INTO yam_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<Mʉbuk lak Betèrèhem nə̀ mvwe' nze Judà, wù ka bʉ̀ʉ ŋkəŋkum sə̀ mvwe' nze Judà pwe' wù jə'rə ghak. A vɛ'nə bʉ̀ʉsə̀ ŋwə̀ nə̀ mantombì mòok nə tesə bohòwù nə̀ yi nə sə jəŋ ŋkərə̀ bohòbʉ̀ʉ am Izùrɛ yi.> >> ");
INSERT INTO yam_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ŋkum Heròànə yuk me vɛ'nə fana yi to swihi lo bʉ̀ʉ sə̀ wo və̀ ma ntonùm sə mvwe' mok. Yi fek tsə'rə yà'wèŋ ghà nə̀ wo anə ye ŋga sɛ̀ŋ nə ko' nə bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yi ànə fek wes wo fana yi dʉk fa yà'wèŋ də, <<Wèeŋ du mvwe' lak Betèrèhem sə. Wèeŋ kə̀ dzèeŋ, wèŋ lap tse' mvwe' sə̀ mo nə cu sə bə̀boŋ. Wèeŋ yə yi, wèŋ gʉ co mʉ riŋ ya mʉ nə geŋ kə kuksə yi yàm sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wo ànə yuk vɛ'nə, wo lo. À kə̀ wɛ̀s mandzə̀, wo ye fe'lə sɛ̀ nə sə̀mok. Ànə ye megu sə̀' ŋkə̀ŋkà nə̀ wo à yə nà' ma ntonùm nə. Nà' à sə lòmantombìi wo tə̀tè nà' kə təəŋ mam mvwe' sə̀ mo nə cu sə. ");
INSERT INTO yam_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wo à kwa, ni' mòk boŋ wo vɛ'ɛ nsàp mòk, mvəsə̀ wo ànə ye ŋkə̀ŋkà nə! ");
INSERT INTO yam_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Wo ni lo mʉnda'à anə, nə ye mo nə bə ma ye Mèri. Wo təəŋ bə tumfərə, nə kuksə mo nə. Wo muk bàam awo, nə fis dasə fa mo nə bum səmok. Bum sə̀ wo à fa yi sə à ye nsàp mbàm mòk nə̀ wo togə̀ nà' də guù. Bə nsàp làmindà mòk nə̀ wo to nà' də frankisì. Nə ye bə nsàp mve' nəmòk nə̀ wo togə̀ nà' də meè. ");
INSERT INTO yam_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ànə geŋ, Nwì tipsə wo ndzənə lo də yà'wèeŋ kà bohòŋkum Heròmok bwìŋ fohòlòfe'lə̀. Wo à bɛ' mandzə̀ nə̀ zok, nə foho lo la'à wo. ");
INSERT INTO yam_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bʉ̀ʉ yè'sə ànə lo wes me fana masinjà Tà Nwì kə cep bohòJòsep ndzə loòdə, <<Lòkok mʉtsə̀, nə jəŋ mo nə bə ma ye, wenə wèeŋ caŋ lo mvwe' nzeŋgòŋ Ijìp. A kə̀ dzèŋ fo', wèŋ cum tə̀tè nùmbu nə̀ mʉ tsə̀' weŋ də wèeŋ bwi foho və ŋkuŋ. Mʉ̀ dʉk yè'sə bʉ̀ʉsə̀ ŋkum Heròo nə lap mandzə̀ də yi zə nà'.>> ");
INSERT INTO yam_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jòsep à lòkok nòoŋ, nə jəŋ mo nə bə ma nə wèŋ pwe', wo caŋ lo nooŋ mvwe' lak Ijìp anə ndzəmə̀. ");
INSERT INTO yam_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wo à cu fo' tə̀tè Heròkpʉ. Yè'sə ànə ye vɛ'nə ya yusə̀ Tà Nwì ànə cep casə cùhu ŋgàa tsòhòbum Nwì wèeŋ ye zìnə. Yusə̀ wo à cèp sə à ye də, <<Mʉ̀ a to fis və̀ mo àm mvwe' nzeŋgòŋ Ijìp.>> ");
INSERT INTO yam_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ghà nə̀ Heròànə riŋ ŋga'a də bʉ̀ʉ sə̀ ma ntonùm wèŋ sə bòrə yi laŋ fana ntʉm yaaŋ yi wùriŋ. Yi fa ŋàŋ də wo lo mvwe' lak Betèrèhem nə ye bəbwe buhu lak sə̀ yà' kʉəp fo' pwe', nə zə bweŋke' sə̀ mbəmbam. Yi də wo zə sə̀ wo lùumŋgòŋ ba nə foho və ma ŋkwɛ̀ŋ pwe'. Yi à sə cèp yè'sə, yi sə fʉhʉ lo bə mvə̀k nə̀ bʉ̀ʉ sə̀ wo à və̀ ma ntonùm wèŋ à tsə̀' yi də sɛ̀ nə à tesə nə. ");
INSERT INTO yam_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yè'sə ànə gʉ fana yusə̀ Jèrèmiyà nə̀ yi à ye ŋgà tsòhòbum Nwì ànə cep bʉʉŋ və zìnə. Yi ànə cep də, ");
INSERT INTO yam_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<Ŋgì mòk sə yuhu və̀ mvwe' lak Ramà. A ŋgì ŋgùŋ bə waŋ vɛ'ɛ nə̀bʉp. Recà sə wa bwe ye wèŋ. Yi sə wa yà' nsàp nə̀ wo tsəpsə yi bʉ̀ə̀, bʉ̀ʉsə̀ wo kpʉ wes pwe' nə̀ pwe'.>> ");
INSERT INTO yam_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herònə ànə kpʉ fana masinjà Tà Nwì à və̀ bohòJòsep ndzə loòmvwe' nzeŋgòŋ Ijìp anə sə̀mok, ");
INSERT INTO yam_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","nə dʉk fa nà' dʉk də, <<Lòkok mʉtsə̀, nə jəŋ mo nə bə ma ba fo'. Wenə wèeŋ bwi lo mvwe' lak Izùrɛ, bʉ̀ʉsə̀ bʉ̀ʉ sə̀ wo ànə sə lap mandzə̀ də wo zə mo nə sə a kpʉ wes pwe' laŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Fana Jòsep lòkok, nə jəŋ ma mo nə, bə mo nə wèŋ bwi foho və fe'lə mvwe' lak Izùrɛ. ");
INSERT INTO yam_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Jòsep ànə yuk də Àcilaòa kok gaŋ tɛ̀' ye Heròco ŋkum Jùdiyà yi fana yi wəp ŋgòcu mʉmvwe' ànə. Wo à kə̀ tipsə fe'lə yi ndzə loòsə̀mok fana yi lo kə cum mvwe' nze Galìli. ");
INSERT INTO yam_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","À kə̀ dzèŋ fo', yi ci lak ye mʉmvwe' nəmòk nə̀ wo to fo' də Nazàrɛ. Yi ànə gʉ vɛ'nə fana yusə̀ ŋgàa tsòhòbum Nwì wèŋ à cèp bʉʉŋ və zìnə. Yusə̀ wo à cèep sə də, <<Wo nə̀ to fa mo nə liŋ mok də ŋwə̀ lak Nazàrɛ.>> ");
INSERT INTO yam_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mvə̀k ànə à ye, ŋga Jon ŋgà bàptɛsə̀ bwìŋ à və̀ə, nə sə tsoho nzak Nwì. Yi à sə cu sə ŋgəà, bwìŋ sə tesə və mvwe' nzeŋgòŋ Jùdiyà nə sə kə yuk yusə̀ yi sə cèep. ");
INSERT INTO yam_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Yi à sə tsòho dʉk də, <<Wèeŋ kupsə, nə bwi fa bʉp awèŋ ŋkwɛ̀ŋ, njo nə̀ gaŋ ŋkum sə̀ mʉbu kʉəp ŋgòye sə nzeŋgòŋ fɛŋ laŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ŋwə̀ nəmòk à ye ŋgà tsòhòbum Nwì taŋntɛ̀ŋ nə̀ liŋ ye à ye Ìzayà nà'a à dʉk də, <<Ŋgì ŋwə̀ nəmòk sə cèp torə və̀ sə ŋgəà, nə sə yuhu də, <Gʉ̀ tsə'rə fa Tà Nwì mandzə̀ ye, rəŋsə tsə'rə fa yi bwe cwèe mandzə̀ ŋgògì cà ca.> >> Yi à sə cèp yè'sə ŋga yi sə dʉk yà'sə Jon ŋgà bàptɛsə̀ bwìŋ nə. ");
INSERT INTO yam_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon à sə ni nsàap cə̀ək mok sə̀ wo à sə gʉ̀ yà' bə nwɛ̀ɛs nàm nəmòk nə̀ wo togə̀ nà' də kàme. Yi à ni tse' korə ŋgùp sə mbwèe yi. Yi à sə zʉ ŋgwim bə nu. ");
INSERT INTO yam_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bwìŋ à tesə və̀ mvwe' lak Jòrosalèm nə ye nzeŋgòŋ Jùdiyà pwe' ŋgòkə̀ tsèŋ yi. Mok sə və mvwe' lak sə̀ yà' kʉəp ndzəp Jòridàŋ pwe'. ");
INSERT INTO yam_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wo à və̀, nə dʉk də wo kəàcù bə bʉp awo laŋ fana yi bàptɛsə yà'wèŋ sənə ndzəp Jòridàŋ nə. ");
INSERT INTO yam_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon à yə ŋga bòp bʉ̀ Faràsi bə bòp bʉ̀ Sadusì wèŋ sə kpəəŋ və̀ə də yi baptɛsə wo. Yi dʉk fa yà'wèŋ də, <<Wèŋ ŋgwì bʉ̀ no, tsə̀' weŋ ŋga'a ndà də wèeŋ caŋ, nə swirə ŋgə' nə̀ Nwìi nə̀ fa bwìŋ ɛ̀? ");
INSERT INTO yam_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wèeŋ gʉ yusə̀ aco yà' ni tsok də wèŋ bwìŋ fa bʉp awèŋ ŋkwɛ̀ŋ laŋ. ");
INSERT INTO yam_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Wèeŋ kà də wèeŋ sə tsərə də wèeŋ nə swirə bʉ̀ʉsə̀ wèŋ sə dʉhʉ də, <Tàcici avès à ye Abràham> dʉk. Bʉsə̀ mʉ̀ sə tsə̀' weŋ də aco Nwì jəŋ lìis yè'e, nə gʉ fa Abràham bwe bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yuk a. Njàm nə nòsə kʉ̀' ŋgògbɛ̀' màk tʉ nə sə mbwè. Tʉ nə̀ fòpwe' nə̀ nà'a kà-a nto'o sə̀ bə̀boŋ zəm, wo nə gbɛ' mak nà' sə nze, nə te' tɛŋ gèsə nà' sə misə̀. ");
INSERT INTO yam_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mʉ bàptɛsə mègù yàm bwìŋ bə ndzəp ŋgònìtsə̀' də wo a bwìŋ fa bʉp awo ŋkwɛ̀ŋ laŋ. Ŋwə̀ nə̀ yi nə və maŋkwɛ̀ɛŋ mʉ̀ʉ nə baptɛsə bwìŋ ye bə Yòŋsə̀ nə̀ Rərɛŋ nə nə ye bə mis. Yi yam ghak mʉ yi. Mʉ̀ ka yè'e kə̀kʉrə̀ co mʉ̀ bək fa yi kùuŋgùp ye yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yi tse' wàam nzaŋ ye ndzə bohòyi ŋgòcìs nzaŋ bə zeŋ. Yi nə nəmsə nzaŋ sə mʉ tàpə, nə tɛŋ dzə̀dzə̀ə sə sə mvwe' mis nə̀ nà'a kà liìgə̀.>> ");
INSERT INTO yam_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mvə̀k nə̀ Jon à sə bàptɛsə bwìŋ ànə à ye fana Jisòs ye'e me'rə nzeŋgòŋ Galìli, nə lo mvwe' ndzəp Jòridàŋ. À kə̀ dzèŋ fo', yi kə ye Jon də nà'a baptɛsə yi. ");
INSERT INTO yam_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jon lap mandzə̀ ŋgògʉ̀ də ya Jisòos teŋsə. Yi dʉk fa Jisòs nə də, <<A nə ye co wu bàptɛsə mʉ wù, wù sə və bwìŋ də mʉ bàptɛsə wu mʉ̀ yè'sə va?>> ");
INSERT INTO yam_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jisòs dʉk fa nà' də, <<Mʉ̀ rì vɛ'nə sə̀' laŋ, bàptɛsə mʉ ntɛ̀ŋ. Bʉsə̀ a gʉ̀-a vɛ'nə ye də a gʉ̀ yà'sə yusə̀ yà'a kə̀kʉrə̀ bohòNwì.>> Yi ànə dʉk vɛ'nə, Jon nə dzəm. ");
INSERT INTO yam_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mvə̀k nə̀ wo ànə bàptɛsə wes yi ntɛ̀ŋ fana Jisòs tesə kok sə ndzəpə̀ anə. Ntòbu à mùhu nòoŋ to. Yi ye ŋga Yòŋsə̀ nə̀ Nwì nə tsə tesə və̀ mbwa co kəkəbʉ̀ŋ, nə kə naaŋ yi mʉtuhù. ");
INSERT INTO yam_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ànə geŋ, ŋgì mòk cep tsoŋ mʉbu anə də, <<Nè'e mo àm nə̀ mʉ̀ dzəm yi sə ntʉʉ̀ mʉ̀. Mʉ kwagə̀ bohòyi vɛ'ɛ wùriŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yòŋsə̀ nə à jə lòJisòs mvwe' səmok sə ŋgəà də ya Satà nə̀ yi ŋkum ze' nə mumsə ja'a nà'. ");
INSERT INTO yam_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ghà nə̀ yi à cu fo' ndzəm hum kwè bə maràŋ sə̀' hum kwè ŋga yi ka mʉzə̀p yumok kə̀ cùhù gesə lok fana njè yaŋ yi. ");
INSERT INTO yam_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Fana Satà nə və bohòyi, nə dʉk fa Jisòs də, <<A ye-a də wu mo Nwì, cep-a ya lìis yè'e bʉʉŋ na bɛŋ ŋga wu zʉ.>> ");
INSERT INTO yam_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisòs à dʉk fəsə fa nà' də, <<Wo à còm nòŋsə ndzənə Ŋwàk Nwì dʉk də, <Kaco ŋwè cum megu bʉ̀ʉ ŋàaŋ zʉzʉ yeŋ.> >> ");
INSERT INTO yam_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ànə gèŋ, Satà nə jə lo Jisòs mvwe' ntʉm lak nə̀ rərɛŋ nə. Ntʉm lak nə̀ rərɛŋ nà'nə, a lak Jòrosalèm. Yi kə tes nà' mʉ ndùndap Nwì nə̀ ghaŋ nə, mvwe' sə̀ yà' sàp wùriŋ, ");
INSERT INTO yam_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nə dʉk fa Jisòs nə də, <<A ye-a də wu mo Nwì, wù li gbʉ tsoŋ lo-a sə nze-ɛ̀. Bʉsə̀ yà' cu ndzənə ŋwàk Nwì də, <Nwìi nə fa masinjàa ye ŋàŋ ŋgòjə ŋkərə̀ bohòwù, də yà'wèeŋ kotse' wu mʉtsə̀ bə bo awo ya wu nə kà kù nə̀ kù ta.> >> ");
INSERT INTO yam_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisòs cep fəsə fa yi də, <<Ŋwàk Nwì sə dʉk sə̀' də, <Wù ka tse' ŋgòbʉə ja'a Tà nə̀ yi Nwì yòyeŋ.> >> ");
INSERT INTO yam_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satà nə jəŋ mali lo yi mʉmvwe' tu nda mòk nə̀ nà' sàp lòmʉtsə̀ vɛ'ɛ wùriŋ. Wo à təəŋ mbwa, yi niŋ tsok fa Jisòs lak bə ghàak sə̀ sənə nzeŋgònè'e pwe'. ");
INSERT INTO yam_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yi dʉk fa nà' də, <<A ye-a ŋga wù təəŋ-na bə tumfərə, nə kuksə mʉ fana bum sə̀ wù sə yə yà' yè'e pwe', mʉ nə fa wu yà'.>> ");
INSERT INTO yam_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisòs dʉk fa nà' də, <<Satà, coho gɛsə fo'. Ŋwàk Nwì sə dʉk də, <Ŋwè tse' ŋgòkùksə mègù Tà nə̀ yi Nwì ye, nə fak megu sə̀' bohòyi yiìyi.> >> ");
INSERT INTO yam_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yà'a mvwe' sə̀ Satà nə à mè'rə Jisòs, nə lo. Masinjàa Nwì wèŋ və, nə kə jəŋ ŋkərə̀ bohòJisòs nə. ");
INSERT INTO yam_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisòs ànə yuk də wo nisə Jon ndapndzəm fana yi ye'e lo yuye mvwe' nzeŋgòŋ Galìli. ");
INSERT INTO yam_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yi à ka mok mvwe' lak ye Nazàrɛ cum. Yi à kə̀ cu mok mvwe' lak Kàpanùm. Kàpanùum mʉlak mòk nə̀ nà'a ŋgʉ tə̀m Galìli. Tse' nze nə fo' bʉ̀ʉ Zebulòbə bʉ̀ʉ Naptalè wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yi à kə̀ cu fo' ya yusə̀ ŋgà tsòhòbum Nwì nə̀ liŋ yee Ìzayà à cèep ye zìnə. Yusə̀ yi à cèp sə də, ");
INSERT INTO yam_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Nze bʉ̀ʉ Zebulòbə bʉ̀ʉ Naptalè nə̀ nà' kʉəp mvwe' ndzəp nə̀ ghaŋ, nə̀ nà'a ŋga wù to càsə Jòridàŋ. Wo togə̀ nze nə də Galìli, lak bʉ̀ mvumvum wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wèŋ sə̀ wèeŋ cugə̀ sənə ndzəm, wèŋ a yə marɛŋ mòk nə̀ ghaŋ. Marɛŋ nə nə rɛɛŋ bohòwèŋ sə̀ wèŋ à sə cu sə mvwe' nzeŋgòŋ ŋgə' kpʉ yà'a. ");
INSERT INTO yam_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","À yè jə mvə̀k ànə, Jisòs sə tsoho kɛ' ncèp ye. Yi sə dʉk də, <<Wèeŋ kupsə, nə bwi fa bʉp awèŋ ŋkwɛ̀ŋ, bʉ̀ʉsə̀ gaŋ ŋkum sə̀ mʉbu kʉəp ŋgòye sə nzeŋgòŋ fɛŋ laŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mvəsə̀ Jisòs à sə gì ŋgʉ tə̀m Galìli fana yi ye ŋwə̀ nəmòk bə moma ye wo ba. Wo à ye Saimʉ̀ (nə̀ wo togə̀ yi sə̀' də Pità) bə Andrù. Wo à ye ŋgàa ko fuk ŋga wo sə fuk bə ram. ");
INSERT INTO yam_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisòs dʉk fa yà'wèŋ də, <<Wèeŋ bɛ' və mʉ ya mʉ yə'rə weŋ ŋgòko jə və̀ fa mʉ bwìŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wo à yuk vɛ'nə ntɛ̀ŋ, wo me'rə mak noŋsə ram awo sə, nə yuŋ lo yi. ");
INSERT INTO yam_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yi à lòghàr, yi ye fe'lə mok sə̀' bwìŋ ba. À ye sə̀' bwe ŋwə̀ nə̀ mò'fis. Liŋ awo à ye Jem bə Jon. Liŋ tɛ̀' awo à ye də Zebèdi. Yi à yə wo ŋga wo cu sə ŋgwesə̀ bə tɛ̀' awo nə wèŋ ŋga wo sə gʉ̀hʉ tsə'rə ram awo. Jisòs to wo. ");
INSERT INTO yam_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wo à yuk ntɛ̀ŋ, wo me'rə ŋgwes awo bə tɛ̀' awo sə̀', nə yuŋ lo Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisòs à kɛ' nzeŋgòŋ Galìli pwe'. Yi sə yə'rə bwìŋ mʉmvwe' ndap pìriyà bʉ̀ʉ Jus, nə sə tsoho Ntirə̀ nə̀ Bə̀boŋ nə̀ nà'a bə nzak gaŋ ŋkum Nwì nə. Yi à sə gʉŋsə bwìŋ bə nsàp yiya nə̀ fòpwe' nə̀ wo à tse'. ");
INSERT INTO yam_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bwìŋ à yuk lòwes yusə̀ yi à sə gʉ̀ sə mvwe' lak yà'sə, nə ye mvwe' nze Sìriyà nə pwe'fo'. Yà'sə à gʉ̀ʉ, wo sə jə və fa yi bʉ̀ʉ sə̀ wo à tse' nsàp yiyaŋ nə̀ fòpwe'. Mok à ye bʉ̀ʉ sə̀ yòŋsə̀ ze' à ye ndzə ni'ì wo, sə̀ wo sə gbʉ̀ nə̀nò' bə sə̀ wo à kpʉ sak kɛ' ni' mamòk wèŋ pwe'. Wo à jə və̀ wo vɛ'nə, yi gʉ wo pwe', wo gʉŋ. ");
INSERT INTO yam_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mfèŋ-bwìŋ à tesə, nə sə yuŋ lo yi. Bʉ̀ʉ yè'sə à tesə və̀ mvwe' Galìli, Dìkàpolìs, Jòrosalèm, Jùdiyà nə ye ma ndzəp Jòridàŋ mamòk. ");
INSERT INTO yam_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisòs à yə mvə̀'nə̀ bwìŋ à kə̀ mà wùriŋ fana yi kok lo mʉmvwe' nda nəmòk. Ŋgàa fàak ye wèŋ à kə̀ gʉ̀m yi ghʉ̀r fana yi cum tsoŋ nze, ");
INSERT INTO yam_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nə yeto ŋgòyə'rə wo dʉk də, ");
INSERT INTO yam_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<A rɛŋsi bohòbʉ̀ʉ sə̀ wo rì də wo ka kə̀kʉrə̀ bohòNwì yeŋ, bʉ̀ʉsə̀ tse' gaŋ sə̀ mʉbu nsàp bʉ̀ ànə. ");
INSERT INTO yam_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","A rɛŋsi bohòbʉ̀ʉ sə̀ wo sə tɛ', bʉ̀ʉsə̀ Nwìi nə̀ yìsə fa wo ndzəplis awo. ");
INSERT INTO yam_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","A rɛŋsi bohòbʉ̀ʉ sə̀ wo fʉ̀ə̀, bʉ̀ʉsə̀ Nwìi nə̀ ghaksə wo bə yusə̀ yi à kà' də yi nə fa bʉ̀ʉ ye wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","A rɛŋsi bohòbʉ̀ʉ sə̀ tsətsərə̀ə awo cu ghak ŋkʉ̀ʉŋ ŋgògʉ̀ yusə̀ yà'a kə̀kʉrə̀ bohòNwì, bʉ̀ʉsə̀ Nwìi nə̀ kə̀ ze'sə wo bə yusə̀ wo sə tsərə sə. ");
INSERT INTO yam_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","A rɛŋsi bohòbʉ̀ʉ sə̀ wo koksəgə̀ manziŋ bohòbwìŋ, bʉ̀ʉsə̀ Nwìi nə̀ koksə manziŋ bohòwo sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","A rɛŋsi bohòbʉ̀ʉ sə̀ wo tse' ntʉm sə̀ rərɛŋ, bʉ̀ʉsə̀ wo nə̀ kə̀ yə Nwì bə lis. ");
INSERT INTO yam_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","A rɛŋsi bohòbʉ̀ʉ sə̀ wo fagə̀ fifi mʉtsətsə'rə̀ə bwìŋ, bʉ̀ʉsə̀ Nwìi nə̀ to wo də bwe ye. ");
INSERT INTO yam_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","A rɛŋsi bohòbʉ̀ʉ sə̀ bwìŋ sə yeŋsə wo ŋgə' njo nə̀ wo sə gʉ̀ yusə̀ yà'a kə̀kʉrə̀ bohòNwì, bʉ̀ʉsə̀ tse' gaŋ sə̀ mʉbu sə nsàp bʉ̀ ànə. ");
INSERT INTO yam_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","<<A rɛŋsi bohòwèŋ ŋga bwìŋ sə yàk weŋ, sə fa weŋ ŋgə', nə sə ci' nsàap mvwèes sə̀ bʉp pwe' mʉ tuhù wèŋ njo nə̀ wèŋ sə yù mandzə̀ àm. ");
INSERT INTO yam_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wèeŋ kwa, nə kà fʉ̀' bʉ̀ʉsə̀ wèeŋ nə̀ kə̀ tse' lə̀làk mʉbu ŋkʉ̀ʉŋntɛ̀ŋ. Yà'a mègù sə̀' mvə̀'nə̀ wo ànə yeŋsə ŋgàa tsòhòbum Nwì wèŋ sə̀ wo à ye to mantombìi wèŋ ŋgə' sə̀' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","<<Wèeŋ co ci' bohòbwìŋ sə nzeŋgòŋ pwe'fo'. A ye-a ŋga ci' cwɛ̀'lə bʉp, mandzə̀ nə̀ ŋgògʉ̀ yà' lʉm fe'lə kà mok ye. Yà' kà fàk mok tse', wo nə kɛ'mak yà' sə nze, maŋgòŋ nəŋ ca kù mbwa. ");
INSERT INTO yam_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","<<Wèeŋ co marɛŋ bohòbwìŋ sə nzeŋgòŋ pwe'fo'. Wo ci tes-a lak mʉtu nda, kaco yà' ye sə̀swihì yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kaco ŋwè bwe' laàm, nə swihi nà' sənə tasà yeŋ. Yi nə tes nà' mʉnə yumok jəja ya nà'a sə rɛŋ bohòbwìŋ mʉ nda'à anə pwe'. ");
INSERT INTO yam_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yà' mègù sə̀' vɛ'nə də wèeŋ gʉ marɛŋ awèeŋ rɛŋ bohòbwìŋ. Nà'a rɛŋ ya ŋga wo yə bə̀bo àwèŋ nə̀ wèŋ sə gʉ̀ʉ, wo kuksə Tɛ̀' awèŋ nə̀ yi cu mʉbu. ");
INSERT INTO yam_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","<<Kà də wèeŋ tsəm də mʉ̀ a və̀ ŋgòlə̀sə lʉ̀ʉk Musì nə ye bum sə̀ ŋgàa tsòhòbum Nwì wèŋ à yə'rə fa bwìŋ yà'a dʉk. Mʉ̀ a ka ŋgòlə̀sə yà' və, mʉ̀ a və̀ ŋgòkə̀ gʉ̀ fàak am də ya bwìiŋ riŋ də, yusə̀ wo à yə'rə sə yà' kʉ̀rə lòbə zeŋ. ");
INSERT INTO yam_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Wèeŋ yuk, nə tsərə tse' yusə̀ mʉ̀ sə cèp yè'e bə̀boŋ. A ye-a ŋga ntòbu bə nzeŋgòŋ cu mali mvə̀'nə̀ yà'a yè'e, ye də mʉbè'lə̀ yumòok nə kà ndzənə lʉ̀k nə̀ mò'fis momjo vɛ'ɛ coho tesə yuk. A nə kà cohòyuk tə̀tè fàak awo kə me ŋkuŋ. ");
INSERT INTO yam_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ye də a ye-a ŋga mʉbè'lə̀ lʉ̀k mègù-a momjo vɛ', ŋwè kà nà' nòŋsə̀, nə yə'rə fa bwìŋ sə̀' də wo kà nà' sə̀' nòŋsə̀, fana ye də ŋwə̀ ànə nə ye momntilip mvwe' gaŋ ŋkum Nwì. Nə ye sə̀' də, a ye-a sə̀ ndà pwe' nə̀ yi noŋsə lʉ̀ʉk sə, nə yə'rə fa bwìŋ ŋgònòŋsə yà' sə̀' fana ŋwə̀ ànə nə ye ŋwə̀ nə̀ ghaŋ mvwe' gaŋ Nwì. ");
INSERT INTO yam_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mʉ̀ sə tsə̀' fa weŋ də, kaco wèeŋ nə̀ cu mvwe' gaŋ Nwì yeŋ tse'ŋga wèŋ dzəm zìnə ŋgògʉ̀ yusə̀ yà'a kə̀kʉrə̀ bohòNwì nə ghak casə mvəsə̀ ŋgàa yə'rə̀ bwìŋ lʉ̀k nə ye bʉ̀ʉ Faràsi wèeŋ gʉ̀gə̀ə. ");
INSERT INTO yam_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","<<Wèŋ ànə yuk də wo à dʉk fa bʉ̀ njamòk wèŋ də, kà də ŋwèe zə ŋwè dʉk. Də a ye-a ŋga ŋwə̀ nəmòk zə mòk fana wo nə jəŋ və yi mvwe' nzak. ");
INSERT INTO yam_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mʉ̀ sə tsə̀' weŋ nə̀ ŋga'a nè'e də, a ye-a ŋga ŋwə̀ nəmòk jòk bohòmòk wà jì njo, yi nə tse' nzak. Nə ye sə̀' də a ye-a sə̀ ndà, ŋga yi to-a moma ye mòk də <Wu yu nə̀ wà> fana yi nə ye li kaŋsurù ŋkuŋ. Nə ye mali sə̀' də, a ye-a ŋga ŋwè to ŋwə̀ nəmòk də <Wùu ləm>, fana yi tse' ŋgə' nə̀ ŋgòkə̀ sə sə misə̀. ");
INSERT INTO yam_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ye də a ye-a ŋga wù də wu kuksə Nwì bə fəfa yò, nə kə dzeŋ-a mvwe' kàm nə̀ wo fagə̀ Nwì fəfa mbwa nə fana wù tsərə kok də moma yo mòk tse' jə̀jòk bohòwù, ");
INSERT INTO yam_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wù me'rə tes yusə̀ wù anə də wu fa sə fo', nə lo kə mesə və weŋ moma yònə. Wenə mèsə ŋkuŋ wù bwi və, nə kə fa Nwì fəfa yònə. ");
INSERT INTO yam_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","A ye-a ŋga ŋwə̀ nəmòk də yi gʉ nzak wenə mʉ kot, boŋ ghak də wenə mesə bə mvə̀k nə̀ wèŋ ka mʉ kot anə ntòkə dzeŋ. Bʉsə̀ wu kə dzeŋ mʉ kot, yi nə fa wu ndzə bohòŋgà sak nzak. Ŋgà sak nzak nə nə fa wu bohòŋgàa tàm wèŋ fana wo nisə wu ndapndzəm. ");
INSERT INTO yam_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mʉ tsə̀' wu yusə̀ zìnə də wu nə cum mam mbwa tə̀tè tse'ŋga wù làk wes mbàam sə, dolà kà cu ŋkuŋ wù tesə. ");
INSERT INTO yam_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","<<Wèŋ ànə yuk laŋ də wo à dʉk də, ŋwèe kà nto ko. ");
INSERT INTO yam_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nə̀ ŋga'a nè'e mʉ̀ sə tsə̀' weŋ də, a ye-a ŋga ŋwə̀ nəmòk kʉ̀k mègù-a ŋwàŋwè bə lis də ŋwà nè'e bòco bə nà' nooŋ fana ye də yi ko nto bə nà' sə ntʉʉ̀ yi yà'sə laŋ. ");
INSERT INTO yam_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ye də a ye-a ŋga lis yo sə̀ ma mòk sə gʉ̀-a wu ŋgògʉ̀ bʉp fana wù fis mak tosə yà', a dzəm nà' ye lis yo sə̀ ma zʉ. Bògha' də ni' yònə bisə ma mòk vɛ'nə ntɛ̀ŋ nə noŋsə nə̀ də yà'a cum fo' lòoŋ, wù kə ni bə zeŋ mvwe' ŋgə' nə̀ sə misə̀. ");
INSERT INTO yam_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nə ye sə̀' də a ye-a ŋga bo ma zʉʉ yo sə gʉ̀-a wu ŋgògʉ̀ bʉp fana wù gwɛ' tiŋ mak nà'. Bògha' nə̀ də ni' yòo nə bisə ma mòk vɛ'nə ntɛ̀ŋ nə noŋsə nə̀ də nà'a cum fo' pwe', wù kə ni bə zeŋ sə misə̀. ");
INSERT INTO yam_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","<<Wo ànə dʉk sə̀' də, ŋwə̀ nə̀ yi dʉk-a də yi me'rə ŋgwe ye fana yi com fa nà' ŋwàk ndzə bohòdə yi mè'rə nà' laŋ. ");
INSERT INTO yam_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nə ye də mʉ̀ sə tsə̀' weŋ ŋga'a də, a ye-a ŋga ŋwè me'rə ŋgwe ye, ŋga ka bʉ̀ʉ njo nə̀ də nà' sə yù mbəmbam sə mbiŋ yeŋ fana ye də yi gʉ̀ ŋwà nə yi ŋkuŋ nà' ko nto. Ŋwə̀ nəmòok kə jə-a ŋwà nə̀ wo me'rə yi nà'nə, ye də ŋgə̀ŋgàŋ ko sə̀' nto. ");
INSERT INTO yam_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","<<Wèŋ nà yuk sə̀' də wo à dʉk fa bʉ̀ njamòk wèŋ də, ŋwèe nə kà wà kɛ̀ŋ basə̀. Də yusə̀ ŋwè kɛ̀ŋ yà' bohòTà laŋ àlɛ yà' təəŋ megu vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nə̀ ŋga'a nè'e mʉ̀ sə tsə̀' weŋ də a ye-a ŋga wù də wu kak tes yusəmok fana wù kà kɛ̀ŋ lok nə̀ kɛ̀' mò'fis. Kà də wu kɛŋ ntòbu dʉk, bʉ̀ʉsə̀ nà'a yà'sə kapràk Nwì. ");
INSERT INTO yam_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kà ŋgùp nze nè'e sə̀' kɛ̀ŋ bʉ̀ʉsə̀ nà'a yà'sə mvwe' sə̀ Nwì tes kùu ye. Ŋwèe kà lak Jòrosalèm sə̀' kɛ̀ŋ bʉ̀ʉsə̀ yà'a yà'sə ntʉm lak ŋkum nə̀ ghaŋ nə. ");
INSERT INTO yam_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ŋwèe kà tu ye sə̀' kɛ̀ŋ lok, bʉ̀ʉsə̀ kaco wu gʉ kupsə riŋ to nʉ̀ə̀mtu nə̀ mò'fis ŋgòye fəfop kè səseŋ àlɛ' yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yusə̀ wù dʉk-a də wu cep pwe', yà'a ye megu <Ŋ̀ bə Hai'> ba. A càsə-a mʉ mvə̀' ènə ye də yà' və̀ yà'sə mok bohòSatà. ");
INSERT INTO yam_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","<<Wo ànə dʉk sə̀' də, lis bə lis, nzòŋ bə nzòŋ. ");
INSERT INTO yam_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nə̀ ŋga'a nè'e mʉ̀ sə tsə̀' weŋ də, ŋwə̀ nəmòok gʉ̀-a wu bʉp, wù kà yi bʉp gʉ̀ fəsə̀ fa. A ye-a ŋga ŋwə̀ nəmòk sam wu mbumbuk ma zʉ mpaaŋ, wù me'rə yi sam wu mbumbuk ma ŋkwìp sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A ye-a ŋga ŋwè somsə wu mʉ kot, nə jəŋ cə̀k yòfana wù me'rə yi jəŋ nə̀ ndzə tsətsə'rə̀ nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A ye-a ŋga ŋgà tàm mòk ko wu bə ŋàŋ də wu bək bum ye, wù bək casə mvwe' sə̀ yi də kʉ̀rə sə. ");
INSERT INTO yam_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ŋwèe lɛŋ-a yumok bohòwù, wù fa yi. Ŋwə̀ nəmòok dʉk-a də wu samsə fa yi yumok, wù samsə fa yi yà'. ");
INSERT INTO yam_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","<<Wo ànə dʉk sə̀' də, dzəm ŋge' yo wèŋ, nə bɛŋ bʉ̀ʉ sə̀ wo bɛ̀ŋgə̀ wu. ");
INSERT INTO yam_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mʉ̀ dʉk yàm ŋga'a də, dzəm bʉ̀ʉ sə̀ wo bɛ̀ŋgə̀ wu sə sə̀', nə sə lɛŋ fa bʉ̀ʉ sə̀ wo sə yeŋsə wu ŋgə' wèŋ pìriyà. ");
INSERT INTO yam_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Wèeŋ gʉ vɛ'nə, wèŋ ye bwe Tɛ̀' awèŋ nə̀ yi cu mʉbu nə, bʉ̀ʉsə̀ yi gʉ̀gə̀ nùm ye nà' sə to bohòbʉ̀ʉ sə̀ bʉp bə sə̀ bə̀boŋ wèŋ pwe' yəyərə̀. Nə ye fe'lə sə̀' də yi gʉ̀gə̀ mbʉ̀ŋ li bohòbʉ̀ʉ sə̀ bə̀boŋ bə sə̀ bʉp pwe' sə̀' yəyərə̀. ");
INSERT INTO yam_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","A ye-a ŋga wèŋ sə dzəm mègù bʉ̀ʉ sə̀ wo sə dzəm weŋ, ye də aco Nwì lak weŋ bʉ̀ʉ yà? A mègù-a bʉ̀ʉ sə̀ bʉp sə̀ wo ŋgàa benə̀ mbàam tas yà'a wo gʉ̀gə̀ ka sə̀' vɛ'nə yeŋ à? ");
INSERT INTO yam_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nə ye də a ye-a ŋga wèeŋ cepsə megu-a ŋge' awèŋ, ye də yusə̀ wèŋ gʉ̀ fis zok sə yè'sə yà? Mʉ̀ də bʉ̀ pegè wèeŋ gʉ̀gə̀ sə̀' vɛ'nə àlaa. ");
INSERT INTO yam_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Wèŋ tse' ŋgògʉ̀ bə̀boŋ bə bum pwe' mvə̀'nə̀ Tɛ̀' awèŋ nə̀ mʉbu gʉ̀gə̀ə. ");
INSERT INTO yam_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","<<Jəŋ ŋkərə̀ də wu kà fàha Nwìi yo mantombìi bwìŋ də ya wo kwasə wu gʉ̀. Bʉsə̀ wu gʉ̀-a bum yè'sə mvwe' bwìŋ vɛ'nə fana Tɛ̀' yo nə̀ yi cu mʉbu nə kà wu làk. ");
INSERT INTO yam_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ye də a ye-a ŋga wù də wu fa ŋwə̀ nə̀ yi ka yumok tse' yumok fana wù kà də wu yəm bʉsə yà' ŋkì dʉk. A yəmgə̀ nsàap ŋkìi yà'sə ŋgàa tè'èŋkup yà'a. Wo gʉ̀gə̀ vɛ'nə mvwe' ndap pìriyà bə ŋgʉ mandzə̀ də ya bwìiŋ ye wo, nə kwasə wo. Mʉ tsə̀' weŋ kek də wo gʉ̀ vɛ'nə yà'sə ye də wo tse' wes lə̀là' awo yà'sə laŋ. ");
INSERT INTO yam_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bə̀boŋ də wu dzəm-a ŋgòfa ŋgà jìŋ yumok fana wu gʉ̀ co bo ma mòok kà yusə̀ bo ma mòk sə gʉ̀ʉ rì. ");
INSERT INTO yam_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yà'a nə ye sə̀swihì, fana Tɛ̀' nə̀ yi yəgə̀ mvwe' sə̀swihì nə nə lak wu. ");
INSERT INTO yam_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","<<Nə ye də wèeŋ cu ŋgògʉ̀ pìriyà fana wèŋ kà də wèeŋ gʉ co ŋgàa tè'èŋkup yà'a dʉk. Wo dzəmgə̀ ŋgòlòkok təəŋ mʉtsə̀, nə sə lɛŋ pìriyà mʉmvwe' ndaap pìriyà nə ye mvwe' ga'a ndumandzə̀ wèŋ də ya bwìiŋ ye wo. Mʉ tsə̀' weŋ zìnə də nsàp bʉ̀ ànə gʉ̀ vɛ'nə yà'sə, ye də wo tse' lə̀là' awo yà'sə laŋ. ");
INSERT INTO yam_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yusə də wu dzəm ŋgògʉ̀ pìriyà fana wù ni lo ndzə rum nda'à wù, nə kosə ncù, nə gʉ pìriyà bohòTɛ̀' yo nə̀ yi cu mvwe' sə̀swihì nə. Wu gʉ̀ mvə̀' ànə fana Tɛ̀' yo nə̀ yi yəgə̀ bum sə̀ yà'a sə̀swihì nə nə lak wu. ");
INSERT INTO yam_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nə ye sə̀' də wèeŋ cu ŋgògʉ̀ pìriyà nə fana wèŋ kà də wèeŋ sə dʉhʉ yiskok yusə̀ yà' ka fàk tse' co bʉ̀ pegè wèŋ dʉk. Wo tsərəgə̀ yàwo də wu lɛŋ-a, nə sə cep fəsə sə̀' yusə̀ wu cèep sə tə̀tè àlɛ, Nwì yuk pìriyà nə bʉ̀ʉ zeŋ. ");
INSERT INTO yam_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wèeŋ kà də wèeŋ ye co wo dʉk, bʉ̀ʉsə̀ ŋkuŋ wù sə muk cù ŋgòfek Tɛ̀' yo nə yumok fana ŋga yi nə riŋ lo ye yusə̀ wù sə dzəm bohòyi sə tè. ");
INSERT INTO yam_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","<<Ye də wèeŋ nə sə lɛŋ mʉmvə̀k nè'e: <Tɛ̀' avès nə̀ wù cu mʉbu, kə̀kùksə̀ə ye bə liŋ yo. ");
INSERT INTO yam_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gaŋ Ŋkum yòsə və. Yusə̀ wù dzəm də yà'a fak, wù gʉ yà' fak sə nzeŋgòŋ sə̀' mʉmvə̀'nə̀ wu gʉ̀gə̀ bum yo sə fak mʉbu. ");
INSERT INTO yam_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fa a ves bɛŋ sə̀ vèes nə zʉ yà' ntinə. ");
INSERT INTO yam_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Swì fa vèes bʉp avès sə̀' mvə̀'nə̀ ves swì fagə̀ bʉ̀ʉ sə̀ wo gʉ̀gə̀ ves bʉp. ");
INSERT INTO yam_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nə kà ves mvwe' sə̀ co mə̀mumsə̀ kə tseŋ ves jə lò. Mvwe' sə̀ Satà nə cu, wù caŋsə gɛsə fis ves fo'.> ");
INSERT INTO yam_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Bʉsə̀ a ye-a ŋga ŋwè gʉ̀ wu bʉp, wù swi fa yi fana Tɛ̀' yo nə̀ yi cu mʉbu nə nə swi fa wu yòsə̀'. ");
INSERT INTO yam_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wu kà-a bwìŋ bʉp sə̀ wo gʉ̀ bohòwù swì fa fana Tɛ̀' yo nə kà wu yòsə̀' swì fa. ");
INSERT INTO yam_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","<<A sə̀' də ghà nə̀ wèŋ sə dzə̀ zʉzʉ fana wèŋ kà də wèeŋ gʉ̀ tse' si awèŋ co ŋwə̀ nə̀ njè sə ya yi, mvəsə̀ ŋgàa tè'èŋkup wèeŋ gʉ̀gə̀ yà'a dʉk. Wo gʉ̀ tse'gə̀ si awo co njè sə ya wo vɛ'ɛ də ya bwìiŋ ye riŋ də wo sə dzə̀ zʉzʉ. Mʉ̀ sə tsə̀' fa weŋ zìnə də wo gʉ̀ vɛ'nə fana ye də wo tse' wes lə̀là' awo yà'sə laŋ. ");
INSERT INTO yam_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ghà nə̀ wù cu-a də wu dzə zʉzʉ fana wù kwak si yo làaŋ, nə swak tu yo bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ya bwìiŋ kà də wù sə dzə̀ zʉzʉ rì. A riŋ megu Tɛ̀' yo nə̀ yi cu mvwe' sə̀swihì nə yiìyi. Tɛ̀' yo nə̀ yi rìgə̀ yusə̀ yà' cu mvwe' sə̀swihì ènə nə lak wu yi. ");
INSERT INTO yam_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","<<Kà də wèeŋ loksə ghàha awèŋ sə nzeŋgòŋ fɛŋ dʉk. A fɛɛŋ mvwe' sə̀ aco ndu bə nzək nə ye ŋgàa yə̀ wèŋ gʉ bʉpsə yà'. ");
INSERT INTO yam_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bògha' də wèeŋ loksə ghàha awèŋ lɛ mʉbu. A mbwa mvwe' sə̀ kaco nzək bə ndu nə ye ŋgàa yə̀ wèŋ gʉ lok yà' yumok yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mʉ̀ dʉk vɛ'nə bʉ̀ʉsə̀ mvwe' sə̀ ghàha awèŋ cu-a fana ntʉm awèeŋ nə cum megu sə̀' fo'. ");
INSERT INTO yam_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lis yoo marɛŋ nə̀ ndzə ni'ì wù yi. A ye-a ŋga lis yoo bə̀boŋ fana ye də ni' yònə, nə rwiŋ bə marɛŋ. ");
INSERT INTO yam_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yà'a sə̀' də a ye-a ŋga lis yo ka bə̀boŋ yeŋ fana ye də ni' yòpwe' rwiŋ bə mandzəm. Ye də a ye-a ŋga ni' yo nə rwiŋ bə mandzəm vɛ'nə ye də a ŋgʉŋgʉi' ndzəm nə̀ fɛŋ bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","<<Kaco ŋwè fak ŋkwɛ̀ŋ bohòmasà ba yeŋ. Yi nə dzəm fis mòk, nə bɛŋ mòk kènə aco yi sə fak bohòmòk zìnə nə kà mòk nə co yumok jə lok. Kaco wù fak bohòNwì nə ye bohòmbàm yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ye də mʉ̀ sə tsə̀' weŋ də, kà də wèeŋ sə tɛ' kɛ'ca bə yòŋsə̀ə awèŋ njo zʉzʉ bə nəno kènə də bə cə̀ək sə̀ ŋgònitse' mʉ ni'ì wèŋ àlɛ' dʉk. Yam gha' ka yòŋsə̀ ŋwè nə noŋsə zʉzʉ yeŋ à? Nə ye sə̀' də yam gha' ka ŋgùpni' ŋwè nə casə cə̀k yeŋ à? ");
INSERT INTO yam_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wèeŋ kʉk ja'a na swiŋ sə̀ yà'a mʉbu yè'e nɛ̀. Wo kà yumok mʉnzuù bìgə̀, nə kà sə̀' kʉp nə kà tàp sə̀' tse'. Wo ye-a sə̀ vɛ'nə, Tɛ̀' awèŋ nə̀ mʉbu fagə̀ wo zʉzʉ. Ghak yè'sə wèŋ kè swiŋ ɛ? ");
INSERT INTO yam_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A mʉŋgorə̀ wèŋ ndà nə̀ də aco yi naaŋ gesə nùumbu mok mʉnə nùumbu ye də bʉ̀ʉsə̀ yi jìk yi ɛ? ");
INSERT INTO yam_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Bə ma nə̀ cə̀k, wèŋ sə tɛ' bə nzak cə̀k ye bʉ̀ʉ yà? Tsərə a bə nzàamŋgaŋ sə̀ yà'a fomgə̀ yè'e mʉmvə̀'nə̀ yà'a kùkgə̀ə ɛ̀. Wo kà ndàp caŋsə̀gə̀, nə kà cə̀k sə̀' ba'. ");
INSERT INTO yam_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ye də mʉ̀ sə tsə̀' weŋ də a megu-a sə̀ ŋkum Sòlomù bə ghàha ye sə̀ yi à tse' sə pwe', yi à ka nsàp cə̀k mòk co nzàamŋgaŋ yè'sə ni yuk. ");
INSERT INTO yam_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A ye-a də ŋgaŋ sə̀ wà sə̀ aco wù ye yà' ntinə, a ye zòŋ ŋga wo tɛ̀ŋ səsə yà' laŋ yè'e Nwì sə jəŋ ŋkərə̀ bohòwo vɛ'nə, ye də kaco yi jəŋ casə ghak ŋkərə̀ bohòŋwè yeŋ à? Oòbʉ̀ʉ am wèŋ, wèŋ ka Nwì ntʉm awèŋ pwe' fa. ");
INSERT INTO yam_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Bum yè'sə nə yeè nə vɛ'nə fana kà də wèeŋ sə tɛ' kɛ'ca də vèes nə zʉ kok yè'sə yà lɛ-ò, vèes nə no kok yè'sə yà lɛ-òkè də vèes nə jəŋ kok cə̀k yè'sə fòlɛ-òdʉk. ");
INSERT INTO yam_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bʉsə̀ a làpgə̀ nsàap bum yè'sə gʉgʉŋ bʉ̀ʉ sə̀ wo ka Nwì riŋ. Bohòma njàwèŋ fana Tɛ̀' awèŋ nə̀ mʉbu rìŋ də wèŋ tse' ŋgòtse' bum yè'sə pwe' laŋ. ");
INSERT INTO yam_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Làp to mantombì lɛ gaŋ ŋkum Nwì, nə ye ŋgòye kə̀kʉrə̀ mantombìi yi ŋkuŋ fana bum mok yè'e pwe' nə ye sə̀' sə̀ yàwèŋ. ");
INSERT INTO yam_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ye də ŋwèe kà də yi tɛ' fa zòŋ dʉk, zòoŋ nə tɛ' tu ye yi. Nùmbu nə̀ fòpwe' tse' ŋgə' nje kə̀kʉrə̀ bə nùmbu nə. ");
INSERT INTO yam_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","<<Kà də wu sak ŋwə̀ nəmòk dʉk ya Nwìi kà wu yòsə̀' kə̀ sak. ");
INSERT INTO yam_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mʉ̀ dʉk vɛ'nə bʉ̀ʉsə̀ Nwìi nə̀ kə̀ sak wu sə̀' mvə̀'nə̀ wù sə sak bʉ̀ʉ mok wèŋ. A sə̀' də mvə̀'nə̀ wu fʉ̀' fa bwìŋ fana yi nə̀ fʉ̀k fəsə fa wu sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Njo nə̀ wu kʉ̀kgə̀ mʉjep nə̀ jo nə̀ nà' cu mʉ lisə̀ moma yo, nə swi də bɛ̀s tʉ nə̀ ghaŋ cu mʉ lisə̀ wùu yè'e bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kènə aco wù dʉk fa to moma yo mòk də, <Tse' vesə lis ya mʉ̀ fis fa wu mʉ jep nə̀ mʉ lisə̀ wu> nà'a, ŋga ŋkə̀ŋkʉ̀m jep nə jep cu ma mʉ lisə̀ wù yè'sə va? ");
INSERT INTO yam_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wèŋ ŋgàa tè'èŋkup wèŋ, fis to lɛ ntòjep nə̀ ghaŋ nə̀ mʉ lisə̀ wù nà'a ŋkuŋ ya wu nə tse' mandzə̀ ŋgòyə rì nə̀ jo nə̀ nà' cu mʉ lisə̀ moma yo nə. ");
INSERT INTO yam_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","<<Kà də wu fa bʉ̀ʉ sə̀ wo bɛ̀ŋ bum sə̀ yà'a rərɛŋ bə ma nə̀ Nwì dʉk, bʉ̀ʉsə̀ wo nə kà yà' co yumok jə. Wo nə nəŋ bʉpsə yà' bə kù, nə bʉʉŋ ko wu lʉ̀. ");
INSERT INTO yam_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","<<Lɛŋ Nwì ya yi nə fa wu, làap ya wu nə tse', kùum ya wo nə muk fa wu. ");
INSERT INTO yam_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bʉsə̀ ŋwə̀ nə̀ yi lɛŋ-a, ŋgə̀ŋgàaŋ nə tse', ŋwə̀ nə̀ yi lap-a, ŋgə̀ŋgàaŋ nə ye, ŋwə̀ nə̀ yi kum-a, wo nə muk fa ŋwə̀ ànə. ");
INSERT INTO yam_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wèŋ sə̀ wèeŋ tɛ̀'ɛ bwe, mòk cu yo nə̀ ŋga mo ye lɛŋ-a bɛŋ, yi fa nà' lìs à? ");
INSERT INTO yam_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kènə mòok yo nə̀ mo ye fek-a də nà'a fa yi fuk, nà' fa yi no-ɛ? ");
INSERT INTO yam_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A ye-a ŋga wèŋ sə̀ wèeŋ bʉp yè'e riŋ ŋgòfa bwe awèŋ bum sə̀ bə̀boŋ, ye də aco Tɛ̀' nə̀ mʉbu nə, nə fa bum sə̀ bə̀boŋ bohòbʉ̀ʉ sə̀ wo lɛŋ yi sə wèŋ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Bum yè'sə də yusə̀ wu dzəm-a də bwìiŋ gʉ fa wu, wù gʉ fa wo sə̀' vɛ'nə. Yà'a yusə̀ lʉ̀ʉk Musì bə ncèep ŋgàa tsòhòbum Nwì wèŋ pwe' sə cèp vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","<<Ni mvwe' ncùu ŋka' sə̀ yà'a fəferə̀ yà'a, bʉ̀ʉsə̀ ncùu ŋka' sə̀ wə̀wə̀ŋ sə̀ yà' tse' mandzə̀ nə̀ bə̀boŋ yà'a, a mandzə̀ kpʉ. Bwìiŋ ŋkʉ̀ʉŋ sə̀ wo sə yù lònà'. ");
INSERT INTO yam_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ncùu ŋka' lùuŋ fəferə̀, mandzə̀ nə gʉŋ te'lə sə̀' nə̀bʉp. Bʉ̀ʉ sə̀ wo yə mandzə̀ ènə, wo moòm gha bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","<<Wèeŋ jəŋ ŋkərə̀ bohòbʉ̀ʉ sə̀ wo sə gʉ̀ basə də wo ŋgàa tsòhòbum Nwì yà'a. Wo və̀ə, wù sə ye mʉŋgùpni' də a nsùŋgaŋ ŋga wo ma ndzə tsətsə'rə̀ furù' nə̀ bʉp. ");
INSERT INTO yam_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wèeŋ nə riŋ wo bə nsàp mandzə̀ nə̀ wo sə gʉ̀ bum awo. Kaco lèmu zəm yuk mʉnə ntwìnə̀nɛ' yeŋ, nə ye sə̀' də kaco wo kwiŋ yuk pià mʉnə ndi'ntsə̀ə sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tʉ sə̀ bə̀boŋ pwe' zəmgə̀ nto'o sə̀ bə̀boŋ. Tʉ sə̀ bʉp zəm sə̀' nto'o sə̀ bʉp. ");
INSERT INTO yam_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kaco tʉ nə̀ bə̀boŋ zəm nto'o sə̀ bʉp yeŋ. Tʉ nə̀ bʉp kà nto'o sə̀ bə̀boŋ sə̀' zəm bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tʉ nə̀ fòpwe' nə̀ nà' ka-a nto'o sə̀ bə̀boŋ zəm, wo gwɛ' mak nà' sə nze, nə te' tɛŋ gesə nà' sə misə̀. ");
INSERT INTO yam_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nà'a njo nə̀ mʉ̀ dʉk weŋ də wèeŋ nə riŋ bʉ̀ʉ sə̀ wo sə gʉ̀ basə də wo ŋgàa tsòhòbum Nwì sə wèŋ bə nsàp mandzə̀ nə̀ wo sə gʉ̀ bum awo sə. ");
INSERT INTO yam_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","<<Ka də ndàaŋwè pwe' nə̀ yi togə̀ mʉ də Tàa nə̀ kə̀ ni mvwe' gaŋ ŋkum sə̀ mʉbu sə yeŋ. A nə̀ kə̀ ni mbwa ŋwə̀ nə̀ yi sə gʉ̀ yusə̀ Tɛ̀' am nə̀ mʉbu nə sə dzəm də ŋwèe gʉ. ");
INSERT INTO yam_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nùmbu sak nzak kə̀ dzèŋ nùu fana bwìŋ ŋkʉ̀ʉŋ nə sə kə dʉhʉ fa mʉ dʉk də, <Tà, Tà, mʉ̀ də vès à sə cèp bum Nwì bə liŋ yo àlaa. Vès à bɛ' fis fa bwìŋ yòŋsə̀ə ze' wèŋ bə liŋ yo, nə sə gʉ bum maŋgəŋgèŋ sə̀' bə liŋ yo.> ");
INSERT INTO yam_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mʉ nə tsok fa wo də, <Coho gɛsə lo ŋgʉ ni'ì mʉ̀ fo', mʉ̀ ka weŋ co bʉ̀ʉ am riŋ yuk. Wèŋ ŋgàa gʉ̀ bʉp wèŋ.> ");
INSERT INTO yam_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","<<Ŋwə̀ nə̀ yi yuk-a ncèp àm nə̀ mʉ̀ cèep, nə gʉ mvə̀'nə̀ mʉ̀ dʉk sə, fana ye də yi co ŋgà ŋkərə̀ nə̀ yi à bom ndap ye mʉnə lìs. ");
INSERT INTO yam_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yi ànə ci nà' mbwa fana mbʉ̀ŋ li, ndzəp rwiŋ bə fə̀fə̀ wèŋ pwe' bwi' ndap nə, nà' kà gbʉ̀ bʉ̀ʉsə̀ wo à ci nà' mʉnə lìs. ");
INSERT INTO yam_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nə ye sə̀' də ŋwə̀ nə̀ yi yuk-a ncèp àm nə, nə kà mvə̀'nə̀ mʉ̀ dʉk sə gʉ̀ fana ye də yi ye co ŋwə̀ nə̀ ləm nə̀ yi à kə̀ ci ndap nje mʉnə ŋgwansa. ");
INSERT INTO yam_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yi ànə ci wes nà' fana mbʉ̀ŋ li, ndzəp rwiŋ bə fə̀fə̀ wèŋ kə bwi' ndap nə nà' gbʉ. Gbʉ̀ nə̀ nà' à gbʉ̀ʉ nə à ka gbʉ̀ nə̀ jo yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisòs ànə cep wes bum yè'sə fana maŋgo bʉ̀ nə̀ nà' ànə ye fo' nə à sɛ̀ɛŋ mam təəŋ bə nsàp yəyə'rə̀ nə̀ wo yuk nə. ");
INSERT INTO yam_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Wo à sɛ̀ɛŋ vɛ'nə bʉ̀ʉsə̀ yi à sə yə'rə ye sə zok co ŋwə̀ nə̀ yi tse' ŋàŋ. Yi à ka ye sə co bʉ̀ʉ sə̀ wo yə'rə fagə̀ bwìŋ lʉ̀ʉk Musì wèŋ yà'a yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisòs ànə sə tsooŋ mʉndahà anə fana maŋgo bʉ̀ mòk yuŋ yi vɛ'ɛ nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ànə geŋ, ŋgà kuturu nəmòk və, nə kə bʉhʉ kə̀ mantombìi Jisòs, nə dʉk fa yi də, <<Tà, a bò-a wu co wù tɛsə mʉ na, wù gʉ fa mʉ yiya àm nè'e me.>> ");
INSERT INTO yam_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yi ànə dʉk vɛ'nə fana Jisòs fis bo, nə jwɛŋ nà' bə zeŋ. Yi à sə jwɛ̀ŋ nà', yi sə dʉk də, <<Mʉ̀ dzəm laŋ, yiya yònə nà'a me.>> Yiya ye nə à mè mègù fo' sə̀' ghà ànə. ");
INSERT INTO yam_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yi dʉk fa fe'lə nà' də, <<Dù, nə kà ŋwə̀ nəmòk tsə̀' fa swì. Cà lògù bohòŋgà fa satikà', nə ni fa yi ni' yò, yi kʉk ja'a wu. Yi kʉ̀' mèsə, wù fa fəfa nə̀ Musì à dʉk nə, ŋgònì tsə̀' fa bwìŋ də yiyaŋ yòa mè laŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisòs ànə və mvwe' lak Kàpanùm. Mvə̀'nə̀ yi à ni və ntɛ̀ŋ, ŋkum sojà mòk kə tseŋ yi mʉtsə̀, nə sə lɛŋ nà'. ");
INSERT INTO yam_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Yi sə dʉk fa Jisòs nə də, <<Tà, mo mòk nə̀ vesi cugə̀ə yi sə tɛsə mʉ bə fàk, yi nòyiyaŋ nda'à mʉ̀ anə vɛ'ɛ nə̀ co wù kà cèp to. Yiya nə a kpʉsə yi ni' nsàp nə̀ co yi kà bʉ̀ʉ̀ŋ lok.>> ");
INSERT INTO yam_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisòs dʉk fa ŋgà' nə də, yi nə və kə gʉ mo nə ya nà'a gʉŋ. ");
INSERT INTO yam_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ŋkum sojà nə dʉk də, <<Hai', kà wù və̀ Tà, bʉ̀ʉsə̀ mʉ̀ ka kə̀kʉrə̀ co wù kə ni mʉnda'à mʉ̀ yeŋ. Cep megu lɛ bə cù fana ya mo fàk àm nə nə gʉŋ. ");
INSERT INTO yam_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mʉ̀ rì vɛ'nə bʉ̀ʉsə̀ mʉ yè'sə ŋwə̀ nə̀ mʉ̀ tse' ŋkwàha bʉ̀ʉ mok mantombìi mʉ̀ sə̀ mʉ̀ sə yuk bohòwo sə̀'. Sojàa mok cu sə̀ wo yukgə̀ yàwo bohòmʉ̀ sə̀' yo. Aco mʉ̀ to mòk dʉk də, <Və̀ə>, yi və. Mʉ̀ dʉk fa mòk də <Lòfa'>, yi geŋ. Nə dʉk fa mali mòk də <Gʉ̀ yu yè'e>, yi gʉ yà'.>> ");
INSERT INTO yam_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisòs ànə yuk yusə̀ yi à cèep fana yi mərə, nə dʉk fa bohòbʉ̀ʉ sə̀ wo à yù və̀ yi fo' sə də, <<Mʉ̀ sə tsə̀' fa weŋ ŋkèm dʉk də, a mègù-a sə̀ mʉtsətsə'rəə bʉ̀ʉ Izùrɛ ma, mʉ̀ ka ŋwə̀ nəmòk fo' nə̀ yi tse' nsàp dzədzəm nə̀ də aco mʉ̀ gʉ to fàk bə ncèp cù àm ye yuk.>> ");
INSERT INTO yam_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yi dʉk fe'lə də, <<Mʉ̀ sə cèp zìnə də ntsə' dinà nə̀ mvwe' gaŋ sə̀ mʉbu sə kə̀ wɛ̀s nùmbu nə fana bwìiŋ nə və mvwe' bòop lak sə̀ wo tse' ŋgwìi bwìŋ fo' zəzok, nə kə zʉ be'lə bə Abràham wèŋ. Wo zʉ be'lə bə Azìk nə ye Jàkop wèŋ bəbɛ'. ");
INSERT INTO yam_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wo nə zʉ fo' vɛ'nə ŋga bʉ̀ʉ Jus sə̀ a nə ye co wo zʉ fo' lɛ wo sə, wo nə bɛ' fis gɛsə wo sə mbiŋ mvwe' ndzəm. Wo nə cum ca sə waŋ, nə sə zʉ nzòŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jisòs bʉ̀ʉŋ dʉk fa bohòŋkum sojà nə dʉk də, <<Bwì foho lòlak. Mvə̀'nə̀ wù dzəm tse' sə ntʉʉ̀ wù yà'a, yà'a nə ye sə̀' vɛ'nə.>> Yiya mo ŋgà' nə à mè gù sə̀' ghà nə̀ wo à sə cèep nə. ");
INSERT INTO yam_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisòs à kə ni mʉnda'à Pità, nə tseŋ malii nà' mbwa ŋga yi nònze bə yiyaŋ. ");
INSERT INTO yam_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisòs jwɛŋ bo ŋwà nə fana yiya nə me. Ŋwà nə lokok, nə lap fa wo zʉzʉ. ");
INSERT INTO yam_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nùmbu ànə à ye ŋga nùm sə co tsə lòo fana wo jə və fa yi bʉ̀ʉ sə̀ wo à tse' yòŋsə̀ə ze' ndzə ni'ì wo vɛ'ɛ wùriŋ. Yi à cèp gù ncèp mò'fis, nə bɛ' fis wes ze' sə bə zeŋ pwe'. Yi à gʉŋsə bʉ̀ʉ sə̀ wo à sə yaya wèŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yi à gʉ̀ vɛ'nə ya yusə̀ Ìzayà ŋgà tsòhòbum Nwì ànə ceep bʉʉŋ və zìnə. Ìzayà nə ànə cep dʉk də, <<Yi a jə lògɛsə wòwoo avès bə yiyaŋ avès yi bə tu ye.>> ");
INSERT INTO yam_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisòs ànə ye mvə̀'nə̀ bwìŋ mà ŋgʉ ni'ì yi wùriŋ fana yi dʉk fa ŋgàa fàak ye wèŋ də bə yà'wèeŋ to lo ŋkùp ndzəp mamòk. ");
INSERT INTO yam_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Fana ŋgà' nəmòk nə̀ yi ŋgà yə'rə̀ fa bwìŋ lʉ̀ʉk Musì caŋ və, nə kə dʉk fa nà' də, <<Cicà, mʉ̀ dzəm də mʉ nə bɛ' lo wu ma nə̀ fòlòoŋ fo' nə̀ wù sə lòo.>> ");
INSERT INTO yam_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisòs dʉk fa nà' də, <<Còp wèŋ tse' mvòk co wo cum ca, swiŋ wèŋ tse' ndap awo fana mʉ̀ʉ mo ŋwè mʉ̀ ka mvwe' sə̀ co mʉ̀ noŋsə tsoŋ tu am nə nooŋ yoŋsə tse'.>> ");
INSERT INTO yam_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ŋgà fàk nəmòk dʉk fa yi də, <<Tà, mʉ foho lo-a maŋkwɛ̀ŋ, nə kə tuuŋ tɛ̀' lam ŋkuŋ ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Fana Jisòs dʉk fəsə fa nà' də, <<Yuŋ və mʉ, nə me'rə bʉ̀ʉ sə̀ wo kpʉ laŋ wèeŋ tuuŋ bʉ̀ kpʉkpʉ awo.>> ");
INSERT INTO yam_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisòs ànə ni lo sənə ŋgwes nə fana ŋgàa fàak ye wèŋ sə yuŋ lo yi sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mvə̀'nə̀ wo à sə lòo, fə̀fə̀ nə̀ bʉp cwiŋ və ye mʉ ndzəpə̀ anə. Nà' sə bwi'lə kɛ' ŋgwes nə, ndzəp sə ci ni lo ca nsàp nə̀bʉp. Yè'sə à sə ye vɛ'nə lòoŋ ŋga Jisòs nə sə dzəm ye lo. ");
INSERT INTO yam_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wo à kə̀ to yə̀msə yi, nə dʉk fa yi də, <<Tà, vesùwèŋ sə kpʉ yè'e kpʉ.>> ");
INSERT INTO yam_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yi dʉk fa yà'wèŋ dʉk də, <<Wèeŋ wəp yè'sə yà, wèŋ ŋgàa dzədzəm moòmjo wèŋ.>> Yi à dʉk vɛ'nə, yi lokok, nə dʉk fa fə̀fə̀ nə ye ndzəp nə də, <<Teŋsə, nə kà mok cà fe'lə̀.>> Yi ànə cep ntɛ̀ŋ, bum pwe' teŋsə, ci'i təəŋ fo' wʉmm. ");
INSERT INTO yam_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bʉ̀ʉ sə wèŋ à mərə vɛ'ɛ, nə dʉk də, <<Nè'e nsàp ŋwə̀ nə̀ fò, fə̀fə̀ bə ndzəp wèŋ sə yuk yi ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yi ànə to tesə lo nto ndzəp ma nja fana yi tesə və mvwe' lak Gadàrin. Bʉ̀ʉ səmok wèŋ à kə̀ tsèŋ yi bwìŋ ba. Bʉ̀ʉ yè'sə wèŋ ànə tse' yòŋsə̀ə ze' ndzə ni'ì wo. Wo à sə cu mvwe' sə̀ wo tuuŋgə̀ bwìŋ. Yòŋsə̀ə ze' sə à sə gʉ̀ wo, wo bʉp ntʉm vɛ'ɛ nsàp nə̀ co ŋwè kà mandzə̀ ma nə̀ wo cu nə cà. ");
INSERT INTO yam_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wo ànə ye Jisòs ntɛ̀ŋ, wo cep torə fis dʉk də, <<Mo Nwì, wu làp bohòvès yà? Wù və̀ də wu sə kə fa ves ŋgə' ŋga mvə̀k nə ka ntòkʉrə à?>> ");
INSERT INTO yam_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ànə ye ŋga bòp ŋgùnaŋ mòk nə̀ ghaŋ à sə zʉ kɛ'cà mʉmvwe' nəmòk fo' sə̀ moòm sə̀sap. ");
INSERT INTO yam_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Fana ze' sə lɛŋ Jisòs də a ye-a ŋga nà' də nà'a bɛ' fis wo àlɛ, nà'a dʉk də wo kə ni ndzə ni'ì bòp ŋgùnaaŋ yà'a. ");
INSERT INTO yam_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisòs dʉk fa yà' də yà'a geŋ. Wo tesə, nə kə ni ndzənə ŋgùnaaŋ sə. Ŋgùnaaŋ sə pwe' à ca durə tsə ndzə baàŋ anə, nə kə gbʉ ni sənə ndzəp Galìli nə, nə kpʉ wes ca pwe'. ");
INSERT INTO yam_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","À nə ye vɛ'nə fana, bʉ̀ʉ sə̀ wo à sə gʉ̀msə ŋgùnaaŋ sə wèŋ carə lo yàwo sə mʉ ntòlak anə fana nə tsoho fa bwìŋ yusə̀ yà' anə ye sə pwe'. Wo à tsə̀' bwìŋ yusə̀ yà' anə gʉ̀ ŋgàa yòŋsə̀ə ze' wèŋ sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bʉ̀ʉ sə̀ mʉ ntòlak sə pwe'fo' à tesə və̀ ŋgòkə̀ yə Jisòs. Wo ànə ye yi fana wo lɛŋ nà' də nà'a lo gɛsə mvwe' lak awo fo'. ");
INSERT INTO yam_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisòs à ni sə ŋgwesə̀, nə to tesə lo ntondzəp ma nə̀ nja, nə tesə və mvwe' lak ye. ");
INSERT INTO yam_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","À kə̀ dzèŋ fo' fana bʉ̀ʉ səmok wèŋ bək jə və fa yi ŋwə̀ nəmòk mʉkèhe ŋga ŋgə̀ŋgàŋ à bù'rə bù'rə. Jisòs à yə də wo tse' dzədzəm nə̀ də aco yi gʉ yiyaŋ ŋwə̀ nə me. Yi dʉk bohòŋwə̀ nə̀ yi kà gìgə̀ nə də, <<Mo àm, kà wəp, mʉ̀ swì fa wu bʉp yo laŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ŋgàa yə'rə̀ fa bwìŋ lʉ̀k mok wèŋ à ye fo', nə yuk yusə̀ Jisòs cèp yè'sə. Wo dʉk sə və̀ə wo də, <<Ŋwə̀ ènə sə gʉ̀ bʉpsə liŋ Nwì wà.>> ");
INSERT INTO yam_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisòs riŋ yusə̀ wo sə tsərə sə ntʉʉ̀ wo sə, nə dʉk fa yà'wèŋ də, <<Wèŋ sə tsərə nsàp bʉp ànə sə ntʉʉ̀ wèŋ vɛ'nə bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Co joho gha' yè'e nə̀ ŋgòdʉk də, <Mʉ̀ swì fa wu bʉp yòlaŋ>, kè nə̀ ŋgòdʉk də, <Lòkok mʉtsə̀, nə gi lo yuyo> ɛ? ");
INSERT INTO yam_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Fana mʉ nə niŋ fa weŋ də mʉ̀ʉ mo ŋwè, mʉ̀ tse' ŋàŋ sə nze ŋgòswì fa bwìŋ bʉp awo.>> Fana yi dʉk fa ŋgà' nə̀ yi kà gìgə̀ nə də, <<Lokok, te' kəà yò, nə lo la'à wù.>> ");
INSERT INTO yam_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jisòs à dʉk vɛ'nə, yi lokok, nə lo yuye. ");
INSERT INTO yam_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bʉ̀ʉ sə̀ wo à ye fo' sə à yə vɛ'nə fana wo wəp, nə kuksə Nwì nə̀ yi a fa bwìŋ nsàp ŋàŋ ànə. ");
INSERT INTO yam_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisòs ànə casə fa'nə fana yi ye ŋwə̀ nəmòk nə̀ liŋ yee də Màtiyò. Yi à yə Màtiyònə ŋga nà' cu mvwe' sə̀ wo là'gə̀ mbàam tas fo'. Jisòs dʉk fa nà' də, <<Bɛ' və mʉ.>> Yi à lòkok, nə bɛ' lo nà'. ");
INSERT INTO yam_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisòs à kə cu mʉnda'à Màtiyònə ŋgòzʉ zʉzʉ mbwa. Ŋgàa ko mbàam tas bə bʉ̀ʉ sə̀ wo ŋgàa gʉ̀ bʉp wèŋ à kə cu be'lə bə nà' nə ye ŋgàa fàak ye wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bʉ̀ʉ Faràsi wèŋ ànə ye vɛ'nə fana wo fek ŋgàa fàak Jisòs sə wèŋ də, <<Cicà àwèŋ nə sə zʉ be'lə zʉzʉ bə ŋgàa ko tas, nə ye bʉ̀ʉ mok sə̀ ŋgàa gʉ̀ bʉp wèŋ bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisòs à yuk fana yi dʉk fa yà'wèŋ də, <<Bʉ̀ʉ sə̀ wo ka yiyaŋ tse', wo kà doktà làpgə̀. A làp mègù doktà ŋwə̀ nə̀ yi sə yaya. ");
INSERT INTO yam_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wèeŋ mum və̀m bə ncèp nə̀ wo à còm nà' ndzənə Ŋwàk Nwì də, <Mʉ̀ dzəm ghak yàm ntʉm nə̀ nà' tse' koksə̀manziŋ nə noŋsə ŋgòfa satikà' nə̀ lʉ̀k sə dzəm.> Mʉ̀ dʉk vɛ'nə bʉ̀ʉsə̀ mʉ̀ à ka bʉ̀ʉ bʉ̀ʉ sə̀ bə̀boŋ wèŋ və, mʉ̀ à və̀ ŋgòto bʉ̀ ŋgàa gʉ̀ bʉp wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ŋgàa fàak Jon wèŋ à və̀ kə̀ fek Jisòs də, wo bə bʉ̀ʉ Faràsi wèeŋ dzə̀gə̀ zʉzʉ nùumbu mok, nə sə gʉ pìriyà, ŋgàa fàak ye kà yàwo gʉ̀ yè'sə bʉ̀ʉ yàlɛ? ");
INSERT INTO yam_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yi dʉk fəsə fa yà' də, <<Aco bʉ̀ʉ sə̀ wo və̀ mvwe' sə̀ wo sə zʉ bum gù wèŋ dzə zʉzʉ à? Ka vɛ'nə sə̀ yeŋ. Mvə̀k nəmòk cu nə̀ wo nə jəŋ gɛsə lo ndugù nə, fana bʉ̀ʉ sə nə dzə zʉzʉ mvə̀k ànə. ");
INSERT INTO yam_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wèeŋ yuk-a, kaco ŋwè jəŋ cə̀k nə̀ fi, nə te' lok cə̀k nə̀ nà' və̀p laŋ bə zeŋ yeŋ. Bʉsə̀ nə̀ fi nə nə saha tesə ndzənə nə̀ zəm nə fana yam ghak wesə ŋga'a mvwe' sə̀ nà' sàha maŋkwɛ̀ŋ sə. ");
INSERT INTO yam_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yumook sə̀' də wo kà dzə̀ rùk sənə bɛ̀s nə̀ zəm kep gèsə̀gə̀, bʉ̀ʉsə̀ yà'a nə duk, nə vok bɛ̀s nə. Fana rùuk sə nə bʉp bə bɛ̀s nə mwè. Bògha' lɛ də wo gesə dzə̀ rùk sənə bɛ̀s nə̀ fi ya rùuk sə bə bɛ̀s nə pwe' cum fo' bə̀boŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisòs ànə sə cep mali bohòwo ntòvɛ'nə fana ŋkwà' ŋwə̀ nəmòk nə̀ mʉmvwe' ndap pìriyà bʉ̀ʉ Jus wèŋ və kə tseŋ yi fo'. Yi təəŋ mantombìi Jisòs bə tumfərə, nə dʉk fa nà' dʉk də, <<Mo àm nə̀ ŋwàŋwè kpʉ fana kwəkwè' və̀ə, nə kə naaŋ fa yi bo yo ya yi luŋ sə̀mok.>> ");
INSERT INTO yam_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jisòs à lòkok, nə bɛ' lo yi. Ŋgàa fàak Jisòs sə wèŋ à yù lòwo sə̀' fo'. ");
INSERT INTO yam_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ànə geŋ, ŋwà nəmòk nə̀ ndʉəm à sə ca yi ndzə ni'ì mʉnə lùumŋgòŋ hum-ncòp-ba à nee və̀ fʉ ŋkwɛ̀ɛŋ Jisòs, nə jwɛŋ gesə cù cə̀k nà' bə bo. ");
INSERT INTO yam_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yi à jwɛŋ nà' ŋga yi sə tsərə sə ntʉʉ̀ yi də, a ye-a ŋga yi jwɛ̀ŋ megu-a cù cə̀k nà' nə àlɛ, yiya ye nə nə me. ");
INSERT INTO yam_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisòs à bʉ̀ʉŋ kʉ̀' ŋwà nə. Yi à yə nà', yi dʉk fa nà' də, <<Ko ntʉm njɛ̀'gù. Dzədzəm yònə̀ wù tse' nə gʉŋsə wu laŋ.>> Yi à dʉk mèsə vɛ'nə ntɛ̀ŋ, yiya ŋwà nə me gu sə̀' fo' ghà ànə. ");
INSERT INTO yam_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jisòs ànə kə ni mʉnda'à ŋkwà' ŋwə̀ nə̀ nà' anə to yi nə fana yi ye bʉ̀ ŋgàa kà kpʉ wèŋ ŋga wo rwiŋ fo' hip. Wo sə fʉəp ŋkìi kpʉ bə ntàŋ, nə sə kɛ'ŋgùŋ. ");
INSERT INTO yam_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yi dʉk fa yà' də, <<Wèeŋ tesə sə mbi pwe'. Mo ènə ka kpʉ, yi sə dzəm mègù lo.>> Wo à yuk vɛ'nə fana wo ywì'lə yi swee. ");
INSERT INTO yam_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wo anə fis wes bʉ̀ʉ sə wèŋ sə mbi anə fana yi ni lo mʉnda'à anə, nə kə ko bo mʉŋwà nə. Yi à ko bo nà' sə vɛ'nə fana nà' lokok. ");
INSERT INTO yam_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yusə̀ yi à gʉ̀ yè'sə à yuhu mvwe' lak sə̀ fo' sə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisòs à mè'rə fa'nə, nə sə lo fana ŋgàa ntwì lis mok wèŋ bwìŋ ba və, nə sə waŋ torə yuŋ yi. Wo sə dʉk də, <<Mo Devìd, koksə-a manziŋ bohòvès-ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yi ànə kə ni mʉnda'à fana bʉ̀ʉ sə̀ ba sə wèŋ kə tseŋ yi mbwa. Yi fek yà' də yà' dzəm sə ntʉʉ̀ yà' də aco yi gʉ to nsàp fàk ènə àlɛ? Bʉ̀ʉ sə də hòli, Tà. ");
INSERT INTO yam_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Fana yi jwɛŋ lis yà'wèŋ sə bə bo ye. Yi à sə jwɛ̀ŋ yà', yi sə dʉk də, <<Yà'a ye bohòwèŋ sə̀' mʉmvə̀'nə̀ wèŋ dzəm tse' sə ntʉʉ̀ wèŋ sə.>> ");
INSERT INTO yam_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Lis awo sə à mùhu. Ànə geŋ Jisòs cep bohòwo vɛ'ɛ gʉgʉŋ də yà'a kà ŋwə̀ nəmòk tsə̀' fa swì. ");
INSERT INTO yam_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wo à lòyàwo, wo to lo liŋ nà' sə mvwe' lak yà'sə vɛ'ɛ pwe' nə̀ pwe'. ");
INSERT INTO yam_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bʉ̀ʉ yè'sə wèŋ à sə tesə lòfana bʉ̀ʉ mok wèŋ jə və fa Jisòs ŋwə̀ nəmòk ŋga yi kà cù cèpgə̀. Yi à sə kà cèp vɛ'nə bʉ̀ʉsə̀ yòŋsə̀ ze' à cu ndzə ni'ì yi anə. ");
INSERT INTO yam_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisòs ànə bɛ' fis ze' nə ntɛ̀ŋ, ŋgà' nə yeto ŋgòcèp cù. Bʉ̀ʉ sə̀ wo à ye fo' sə à mərə. Wo dʉk də, <<Vès ka yàvès yumok mvwe' nzeŋgòŋ Izùrɛ mʉmvə̀' nè'e nùmbu mòk ntòye yuk.>> ");
INSERT INTO yam_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bʉ̀ʉ Faràsi wèŋ dʉk yàwo də Jisòs sə bɛ' fis ze' sə bə ŋàaŋ sə̀ sə fa yi yà' ŋkum ze'. ");
INSERT INTO yam_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ànə geŋ Jisòs kɛ' kɛ' fo' mvwe' buhu lak sə̀ jo bə sə̀ ghaŋ wèŋ pwe'. Yi à sə yə'rə kɛ' mʉmvwe' ndaap pìriyà wèŋ, nə sə tsoho fa wo Ntirə̀ nə̀ Bə̀boŋ bə nzak gaŋ ŋkum Nwì. Yi à sə gʉ̀ lòbʉ̀ ŋgàa yiyaŋ wèŋ gʉŋ. Sə̀ yà' sə ya bə nsàp yu yà lòoŋ yi gʉŋsə yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yi à kʉ̀k ja'a bʉ̀ʉ sə̀ wo à mà fo' fana manziŋ ko yi wùriŋ bʉ̀ʉsə̀ bʉ̀ʉ sə wèŋ à cu ncu ŋgə', ŋwə̀ nə̀ co nà' tɛsə wo ye bʉ̀ə̀. Wo ye co nsùŋgaaŋ sə̀ wo sə jàm kɛ' jì ganakù'. ");
INSERT INTO yam_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Fana yi cep bohòŋgàa fàak ye sə wèŋ dʉk də, <<Nzum sə ŋkʉ̀ʉŋ, ŋgàa kʉkʉp sə ye ŋga'a kə jo. ");
INSERT INTO yam_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Wèeŋ lɛŋ bohòTà ŋgà nzum nə ya yi tumsə vesə bʉ̀ʉ sə̀ co wo kʉp.>> ");
INSERT INTO yam_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisòs à to benə ŋgàa fàak ye sə̀ hum-ncòp-ba, nə fa yà'wèŋ ŋàŋ ŋgòbɛ' fis fa bwìŋ yòŋsə̀ə ze'. Yi à fa yà' ŋàŋ ŋgògʉŋsə bʉ̀ʉ sə̀ wo tse' nsàp yiya nə̀ fòpwe' sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Liŋ ŋgàa ntum ye wèŋ sə̀ hum-ncòp-ba sə də vɛ'ɛ: Saimʉ̀ nə̀ liŋ ye mook də Pità, Andrù moma Pità nə. Jem nə̀ liŋ tɛ̀' yee də Zebèdi. Jem nə à ye bə moma ye Jon sə̀' bwìŋ ba. ");
INSERT INTO yam_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filìp, Bàtòlomì, Tomos, Màtiyònə̀ ŋgà ko mbàam tas, Jem mòk sə̀' nə̀ liŋ tɛ̀' yee də Alfòs, bə Tàdiyòs. ");
INSERT INTO yam_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimʉ̀ nə̀ yi à ye mòk bə bòp bʉ̀ nə̀ wo togə̀ wo də Kenènat. Nə ləsə Judàs Iskarəyà nə̀ yi ànə seŋ Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisòs à tumsə bʉ̀ʉ sə̀ hum-ncòp-ba yè'sə, nə tipsə yà'wèŋ dʉk də, wo kà bohòbʉ̀ lakmvum nə ye bʉ̀ʉ nzeŋgòŋ Sàmàriyà wèŋ lò. ");
INSERT INTO yam_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yà'wèeŋ lo lɛ bohòbʉ̀ʉ Izùrɛ wèŋ sə̀ wo co nsùŋgaaŋ Nwì sə̀ wo ànə jàm bisə jàmə. ");
INSERT INTO yam_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yà'wèeŋ lòo, yà' tsoho lo nzak Nwì də gaŋ ŋkum sə̀ mʉbu sə yà' kʉəp ŋgòye sə nzeŋgòŋ fɛŋ laŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Də wo gʉŋsə ŋgàa yiyaŋ wèŋ, nə lokoksə bwìŋ mvwe' kpʉ, nə mesə fa ŋgàa kuturu wèŋ yiyaŋ awo, nə bɛ' fis fa bwìŋ yòŋsə̀ə ze' ndzə ni'ì sə̀'. <<Ŋàaŋ sə̀ mʉ̀ fa weŋ yè'sə, wèŋ ka yà' ywiywiŋ, ye də wèeŋ gʉ fa lo bwìŋ sə̀' wà.>> ");
INSERT INTO yam_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yi tsok yà' sə̀' də yà'a cu ŋgòlòo, yà' kà mʉzə̀p mbàm sə̀' jə tse' lò. ");
INSERT INTO yam_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wo kà bàm rìp, kà cə̀k nə̀ ŋgòkə ni kupsə jə tse', kà kùuŋgùp kè a megu-a sə̀ ntʉmbàŋ jə tse'. <<Mʉ̀ də wèeŋ kà bum yè'sə jə vɛ'nə bʉ̀ʉsə̀ mvwe' sə̀ ŋwèe fàa', yi zʉ sə̀' fo'. ");
INSERT INTO yam_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Wèeŋ kə̀ ni-a mvwe' lak sə̀ ghaŋ kè mʉbuk lak nə̀ jo àlɛ' pwe', wèŋ lap kɛ'ca fo', nə ye ndap ŋwə̀ nə̀ yi tse' ntʉm nə̀ bə̀boŋ, nə cum fo'. Mvwe' lak sə̀ mò'fis, wèŋ kà ndap kupsə̀ tè wèŋ tesə mvwe' lak yà'sə. ");
INSERT INTO yam_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mvə̀'nə̀ wèeŋ ni lòmvwe' ndap nə fana wèŋ cepsə wo fo' pwe' də, <Fifi ye bohòwèŋ.> ");
INSERT INTO yam_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","A ye-a ŋga wo jə weŋ co bwìŋ, wèŋ me'rə fa wo fifi awèŋ nə. A kà-a vɛ'nə ye, fifi àwèŋ nə bwi foho və fe'lə bohòwèŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A ye-a ŋga ŋwə̀ nəmòk ka weŋ mvwe' ndap ye kè lak awo dzəm kè də wo kà-a yusə̀ wèŋ sə cèep sə yu'rə̀ fana wèŋ kɛ'sə mak mfə̀mfə̀ə kùu awèŋ fo', nə ca bɛ' mandzə̀. ");
INSERT INTO yam_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mʉ tsə̀' weŋ də a ye-a ŋga bòp lak mòk gʉ-a vɛ'nə fana nùmbu nə̀ wo sak nzeŋgòŋ, boŋ ghak ŋgə' nə̀ lak Sodòm bə Gòmorà nə noŋsə nə̀ njàwo nə.>> ");
INSERT INTO yam_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jisòs à dʉk fa wo də, <<Wèeŋ jəŋ ŋkərə̀ bʉ̀ʉsə̀ mʉ̀ sə tum lòweŋ yè'sə co nsùŋgaŋ mʉtsətsə'rəə furùk wèŋ. Fana a bə̀boŋ də wèeŋ kərə co no, nə kà yumok bʉpsə̀ co bʉ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wèeŋ nə sə kʉk kʉ̀'ʉ, bʉ̀ʉsə̀ bwìiŋ nə ko lo weŋ mʉ kaŋsurù, bʉ̀ʉ sə̀ wo tse' ndap pìriyà wèeŋ nə ləp weŋ mʉnə ndap pìriyàa sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wo nə soŋ dapsə lo weŋ mantombìi ŋkwàha bʉ̀ʉ gomè bə ŋkəŋkum wèŋ bʉ̀ʉ mʉ̀. Anə ye vɛ'nə ya wèeŋ tsoho fa wo nə ye bʉ̀ʉ sə̀ wo ka Nwì riŋ sə wèŋ ncèp nə̀ njàm. ");
INSERT INTO yam_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","A ye-a ŋga wo ko lòwu, kà də wu sə jik də wu nə cep valɛ kènə də wu nə dʉk də yàlɛ dʉk. Mʉ dʉk vɛ'nə bʉ̀ʉsə̀ yusə̀ wu nə cep sə nə və kə̀ cùhu wù ghà nə̀ wù sə də wu cep nə. ");
INSERT INTO yam_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bʉsə̀ yusə̀ wèeŋ nə sə cep sə, nə kà sə̀ yàwèŋ ye. Yòŋsə̀ tɛ̀' awèŋ nə nə sə cep casə bohòwèŋ anə yi. ");
INSERT INTO yam_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","<<Mvə̀k ànə nə ye, bwìiŋ nə fa bwema awo də wo zə yà'wèŋ. Tɛ̀'ɛ nə gʉ bohòbwe awo sə̀' vɛ'nə. Bwe wèeŋ nə gʉŋ tu nə lap mandzə̀ ŋgòzə tɛ̀' awo sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bwìŋ pwe' nə bɛŋ weŋ njo liŋ am sə. Megu də ŋwə̀ nə̀ yi təəŋ-a gʉgʉŋ tə̀tè nə kə ləsə, fana nà'a yi nə̀ yi nə tse' lùŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","A ye-a ŋga wo fa ŋgə' mvwe' lak mok fana wèŋ caŋ lo mvwe' lak mok sə̀ zok. Mʉ dʉk vɛ'nə bʉ̀ʉsə̀ mʉ̀ rì də wèeŋ nə kà fàak awèŋ sə̀ wèŋ tse' ŋgògʉ̀ mvwe' lak Izùrɛ sə mèsə̀ ŋga mʉ̀ʉ mo ŋwè mʉ̀ bwì foho və̀ laŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","<<Wèeŋ yuk, kaco mo sùkuù mòk yam ghak cicà ye yeŋ. Kaco ŋkwɛ̀ŋ mòk yam casə ŋwə̀ nə̀ yi sə fàk ŋkwɛ̀ŋ bohònà' nə yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nə yeè nə vɛ'nə fana mo sùkuù tse' ŋgòkwa ŋga yi kə dzeŋ-a co cicà ye, ŋgà fàk ŋkwɛ̀ŋ kwa ye sə̀' wup, ŋga yi dzèŋ co ŋwə̀ nə̀ yi sə fà' bohònà'. A ye-a də wo to fa ŋwə̀ nə̀ yi tu ndap nə liŋ də Bezebù, ŋkum ze', ye də wo nə to bʉ̀ʉ sə̀ mʉmvwe' ndap ànə lòoŋ bə liŋ sə̀ yà' bʉp càsə sə̀ də Bezebù sə. ");
INSERT INTO yam_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","<<Nə yeè nə vɛ'nə fana kà də wèeŋ wəp ŋwè dʉk. Bʉsə̀ yusə̀ wo sès lok-a yà' pwe' nə yəhə ntsə'mòk jəja. Yusə̀ yà'a sə̀swihì pwe'fo', bwìiŋ nə riŋ yà' ntsə'mòk. ");
INSERT INTO yam_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yusə̀ mʉ̀ tsə̀' fa weŋ ndzə ndzəmə̀ wèŋ tsok yà' maràŋ. Yusə̀ wèŋ yuk yà' mvwe' sə̀swihì, wèŋ fuŋ yà' mʉ ndùndap. ");
INSERT INTO yam_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kà də wèeŋ wəp ŋwə̀ nə̀ aco yi zə ŋgùpni' yò, nə kà yòŋsə̀ zə to nè'e dʉk. Wəp lɛ Nwì nə̀ aco yi gʉ bʉpsə to ni' yòbə yòŋsə̀ yòba fo' mvwe' ŋgə' nə̀ sə misə̀. ");
INSERT INTO yam_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Njoroŋ sə̀ aco wù ywiŋ ba dolà ba yè'e kaco mòk gbʉ tsooŋ sə nze ŋga tɛ̀' awèŋ ka bə zeŋ riŋ yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bohòwù nə̀ wu yòŋwè, riŋtse' də nʉ̀əmtu sə̀ mʉtuhù wèŋ yà'a pwe' yi a ta yà' taa. ");
INSERT INTO yam_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Fana kà də wèeŋ wəp dʉk, bʉ̀ʉsə̀ wèŋ gha' njoroŋ sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","<<Ye də bə bum yè'sə, ŋwə̀ nə̀ yi cep fis-a jəja mvwe' bwìŋ də yi ŋwə̀ àm fana mʉ nə kə dʉk fa yi sə̀' vɛ'nə mantombìi Tɛ̀' àm mʉbu. ");
INSERT INTO yam_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yà' ye sə̀' də a ye-a ŋga ŋwə̀ nəmòk dzeeŋ mʉ mantombìi bwìŋ də yi ka ŋwə̀ àm yeŋ, ye də mʉ nə dzeeŋ yi mantombìi Tɛ̀' am nə̀ yi mʉbu, nə də mʉ̀ ka yi sə̀' riŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","<<Kà də wèeŋ tsərə də yusə̀ mʉ̀ a və̀ ŋgògʉ̀ sə nze fɛɛŋ nə jə və gu fifi dʉk. Mʉ̀ a ka fifi jə və̀, mʉ̀ a jə və̀ fèk dzè'. ");
INSERT INTO yam_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mʉ̀ a və̀ ŋgòlòkoksə mwe ŋgòlʉ̀ bə tɛ̀' ye. Mo nə̀ wà'ŋgwɛ̀ŋ ŋgòlʉ̀ bə ma ye. Yep bwe wèeŋ nə lʉ bə malii awo sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ŋwə̀ nə̀ yi nə bɛŋ wuu nə ye sə̀' ŋwə̀ nə̀ mʉ nda'à wù. ");
INSERT INTO yam_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ŋwə̀ nə̀ wu dzəm-a tɛ̀' yo kè ma yo àlɛ nə casə mvə̀'nə̀ wù dzəm mʉ, ye də wù ka yà'sə kə̀kʉrə̀ ŋgòye ŋwə̀ àm yeŋ. Ye sə̀' də ŋwə̀ nə̀ yi dzəm-a mombam ye kè mo ŋwàŋwè nə casə mʉ ye də yi ka yà'sə kə̀kʉrə̀ ŋgòye ŋwə̀ àm sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ŋwə̀ nə̀ yi kà-a də yi bək jəŋ ntə̀əŋ ye ya yi bɛ' lo mʉ dʉk, ye də yi ka kə̀kʉrə̀ ŋgòye ŋwə̀ àm sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ŋwə̀ nə̀ yi lap-a də yi nə tse' swe'e yòŋsə̀ ye yi fana yi nə bisə nà'. Ŋwə̀ nə̀ yi jə yòŋsə̀ nə̀ nje co yusə̀ wà bʉ̀ʉ mʉ̀ fana yi nə tse' swe'e sə. ");
INSERT INTO yam_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","<<Ŋga ŋwə̀ nəmòok jə-a weŋ nə də <Və bə̀boŋ>, ye də yi dʉk fa yà'sə bohòmʉ̀. Nə ye də ŋwə̀ nə̀ yi dʉk-a mʉ də <Və bə̀boŋ> ye də yi dʉk fa yà'sə bohòŋwə̀ nə̀ yi à tum mʉ nə. ");
INSERT INTO yam_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ŋwə̀ nə̀ yi dʉk fa ŋgà tsòhòbum Nwì də <Və bə̀boŋ>, bʉ̀ʉsə̀ nà'a ŋgà tsòhòbum Nwì fana yi nə tse' lə̀làk sə̀' co ŋgà tsòhòbum Nwì. Ŋwə̀ nə̀ yi dʉk fa-a ŋwə̀ nə̀ yi kə̀kʉrə̀ mʉlisə̀ Nwì də <Və bə̀boŋ> fana yi tse' sə̀' lə̀làk nə̀ co ŋwə̀ nə̀ yi kə̀kʉrə̀ mʉlisə̀ Nwì. ");
INSERT INTO yam_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ŋwə̀ nə̀ yi fa-a bwe yè'e wèŋ mòk ŋgàp ndzəp nə̀ fifi də bʉ̀ʉsə̀ nà'a ŋgà fàk àm fana mʉ tsok fa weŋ zìnə də kaco lə̀làk ŋgə̀ŋgàŋ bisə yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mvə̀k nə̀ Jisòs ànə tip wes ŋgàa fàak ye sə̀ hum-ncòp-ba sə fana yi me'rə mvwe' yà'sə, nə lo. Yi à lòo, nə sə kə yə'rə bwìŋ mʉmvwe' ndaap pìriyà bʉ̀ʉ Jus wèŋ, nə sə tsoho lo fa bwìŋ Ntirə̀ nə̀ Bə̀boŋ nə mʉmvwe' buk lak sə̀ Galìli sə. ");
INSERT INTO yam_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ànə geŋ Jon yuk bə bum sə̀ Jisòs nə̀ yi Ŋkum ŋgà gèm bwìŋ nə à sə gʉ̀ʉ fana yi tirə gesə lo fa nà' yumok cùhù ŋgàa fàak ye mok. Ànə ye yè'sə ŋga Jon nə cu mʉ ndapndzəmə̀. ");
INSERT INTO yam_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jon nə də yà'a kə fek nà' də, <<Wu yà'sə ŋwə̀ nə̀ wo à dʉk də yi nə̀ və̀ə nə kè, vèes kʉk də yi cu ntòzok-ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","À kə̀ dzèeŋ fana Jisòs dʉk fa wo də, <<Wèeŋ du, nə kə tsok fa Jon yusə̀ wèŋ yuk, nə ye sə̀ wèŋ yə bə lis awèŋ. ");
INSERT INTO yam_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bʉ̀ʉ sə̀ wo à loho lis sə yə fe'lə bum sə̀mok, bʉ̀ʉ sə̀ wo ànə sə ka gi sə gìi. Ŋgàa kuturu wèŋ sə gʉŋ, bʉ̀ʉ sə̀ wo à loho ntu' wèŋ sə yuk fe'lə bum. Mʉ̀ sə lòkoksə bwìŋ mvwe' kpʉ, nə sə tsoho fa ŋgàa jìŋ wèŋ Ntirə̀ nə Bə̀boŋ nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nə tsok ləsə fa yi də mʉ̀ dʉk də, rɛŋsi bohòŋwə̀ nə̀ yi ka məmərə̀ sə ntʉʉ̀ yi bʉ̀ʉ mʉ̀ tse' lok.>> ");
INSERT INTO yam_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wo ànə bwi ŋkwɛ̀ŋ də wo lòo, fana Jisòs nə ye ŋgòtsòho fa bʉ̀ʉ sə̀ fo' yumok bə liŋ Jon nə. Yi sə cep də, <<Wèŋ ànə lo ŋgəà fa' ŋgòkʉ̀k ja'a yà? À ye ŋgòkə̀ ja'a ŋwə̀ nəmòk nə̀ yusə̀ bwìŋ cèep, yi sə dzəm kɛ' gu yusə̀ wo cep sə nduk à? Ka lɛ vɛ'nə yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ye də wèŋ à lòŋgòkə̀ yə yè'sə yu yà lɛ? Ànə ye də wèeŋ kə ye ŋwə̀ nəmòk nə̀ yi à nitse' cə̀ək sə̀ bə̀boŋ à? Nə yeè nə sə̀' də nsàap bʉ̀ʉ sə̀ wo nigə̀ cə̀ək sə̀ bə̀boŋ yè'sə kà ŋgəà cugə̀. Wo cugə̀ ma mʉmvwe' nto'o ŋkəŋkum wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ye də wèŋ ànə tesə lo yè'sə ŋgògʉ̀ yà? À ye ŋgòkə yə ŋgà tsòhòbum Nwì à? Ŋ̀, a vɛ'nə zìnə, yi yam gha' ŋgàa tsòhòbum Nwì nsàp nə̀ wèŋ rì yàwèŋ anə laŋ. ");
INSERT INTO yam_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nà'a masinjà nə̀ wo à còm nòŋsə bum mok ndzənə Ŋwàk Nwì bə liŋ ye nə. Wo à còm də, <Yeè, mʉ̀ tumsə lòmasinjà àm kə̀ mantombìi wù. Masinjà àm nə nə gʉ tsə'rə noŋsə fa wu mandzə̀ yo nə.> >> ");
INSERT INTO yam_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Fana Jisòs nə cep mali sə̀mok də, <<Mʉ̀ sə tsə̀' weŋ yusə̀ zìnə də bwe sə̀ wo à dzə wo sə nzeŋgòoŋ fɛŋ pwe'fo', wo ka mòk nə̀ yi càsə Jon ŋgà bàptɛsə bwìŋ ntòdzə. Yi ye-a sə̀' vɛ'nə fana ŋwə̀ nə̀ də yi jə'rə càsə gha' mvwe' gaŋ ŋkum Nwì yi nə yam gha' Jon nə. ");
INSERT INTO yam_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ye jəŋ ghà nə̀ Jon à sə tsòho, nə sə bàptɛsə bwìŋ tè ŋga'a, gaŋ ŋkum Nwì sə sə ni fʉ ntu'ù bwìŋ bə ŋàŋ wùriŋ. Bwìŋ sə lʉ̀ mègù bə ŋàŋ ŋkuŋ nə kə ni fo'. ");
INSERT INTO yam_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Lʉ̀ʉk Musì bə ŋgàa tsòhòbum Nwì wèŋ pwe' à sə cèp sə̀' bə nzak gaŋ Nwì yè'sə tə̀tè ŋkuŋ Jon sə kə və ye maŋkwɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nə ye də a ye-a də wèŋ dzəm bə zeŋ fana Jon nə yà'sə Àlajà nə̀ wo à tsòho də yi nə̀ və̀ ntsə'mòk nə. ");
INSERT INTO yam_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ŋwə̀ nə̀ yi tse'-a ntu' ŋgòyuk bum fo', yi yuk. ");
INSERT INTO yam_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","<<Aco mʉ fʉhʉ ŋgwì bʉ̀ nə̀ niè' nə yè'sə bə yà lɛ-ò? Wo yè'sə co bwe mok sə̀ wo tə mʉntɛɛ̀ŋ, nə sə dʉk fa ŋge' awo sə̀ bə yà'wèeŋ ŋàhagə̀ jap də, ");
INSERT INTO yam_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<Vès yəm ŋkìi sə̀ wo fisgə̀ ŋwàŋwè fo', wèŋ kà dzeŋ nə kà. Vès yəm ŋkìi kpʉ, wèŋ kà mbɛŋ sə̀ kom lok.> ");
INSERT INTO yam_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mʉ̀ dʉk vɛ'nə bʉ̀ʉsə̀ Jon nə ànə və ye, yi kà rùk sə no, nə sə dzə zʉzʉ. Bwìŋ à yə vɛ'nə wo də yi tse' yòŋsə̀ ze' ndzə ni'ì yi anə. ");
INSERT INTO yam_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mʉ̀ʉ mo ŋwè, mʉ̀ a və̀ yàm, mʉ̀ sə zʉ bɛŋ, nə sə no rùk sə̀'. Fana bwìŋ a yə vɛ'nə, wo dʉk də, <Wèeŋ ye ŋgà no jʉ̀hʉ̀ rùk bə tà zʉ bum kà ze' mòok nè'.> Wo to mʉ də ŋge' ŋgàa gʉ̀ bʉp bə ŋgàa ko mbàam tas wèŋ. Mègù də yumok kə̀ lə̀gə̀ ŋkuŋ bwìŋ riŋ də a bə̀boŋ kè bʉp àlɛ.>> ");
INSERT INTO yam_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yà'sə à mèe, Jisòs ye ŋga'a ŋgòyàk buhu lak sə̀ yi à gʉ̀ maŋgəŋgèeŋ ye fo', wo ye nə kà bʉp awo ŋkwɛ̀ŋ bwìŋ fa sə. ");
INSERT INTO yam_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yi sə cep də, <<Lak Corazì bə lak Bèsadà, wèŋ cu bʉp. Mʉ̀ dʉk vɛ'nə bʉ̀ʉsə̀ bʉ̀ʉ lak Tayà bə Sidòŋ wèŋ ànə ye-a nsàap bum sə̀ mʉ̀ à gʉ̀ tsə̀' fa weŋ yà'a wo bwɛ̀rɛ wo a kupsə laŋ. À ye-a wo də wo a ni gàa cə̀k, nə yok və ŋgònìtsə̀' də wo kəàcù laŋ. ");
INSERT INTO yam_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mʉ̀ sə tsə̀' weŋ də nùmbu sak nzak nə̀ kə̀ dzèeŋ, Nwìi nə koksə ghak manziŋ bohòbʉ̀ʉ lak Tayà bə Sidòŋ nə noŋsə wèŋ yè'e. ");
INSERT INTO yam_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Wèŋ bʉ̀ʉ lak Kàpanùm, wèŋ sə nɛ̀ ni' co də wèeŋ nə kok lo mʉbu à? Wèeŋ nə lo tsətsoŋ mvwe' ŋgə' vɛ'ɛ bòŋ. Bum maŋgəŋgèeŋ sə̀ wo à gʉ̀ yà' bohòwèŋ yà'a ànə ye-a mvwe' lak Sodòm də bwɛ̀rɛ lak awo sə cu mali niè' ntòfo'. ");
INSERT INTO yam_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mʉ̀ sə tsə̀' weŋ də nùmbu sak nzak ye nùu, Nwìi nə koksə ghak manziŋ bohòbʉ̀ʉ lak Sodòm wèŋ nə noŋsə wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mvə̀k ànə à ye fana Jisòs cep fis də, <<Mʉ̀ kwasə wu-o, Tɛ̀'. Tà mʉbu bə nə̀ sə nzeŋgòŋ ba fo'. Wù a swìhi gɛsə bum yè'sə bohòŋgàa ŋkərə̀ nə ye bʉ̀ʉ sə̀ aco wo rɛɛŋ bum wèŋ, nə niŋtsok fa yà' bohòbʉ̀ʉ sə̀ wo co bweŋke' wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hòli, mʉ̀ kwasə wu Tɛ̀', bʉ̀ʉsə̀ yà' bòkok wu sə və̀ə wù də wu gʉ yà' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yi cep fe'lə sə̀' də, <<Tɛ̀' am a fa bum pwe'fo' ndzə bohòmʉ̀. Ŋwə̀ nəmòk ka mwe nə riŋ, rì mègù Tɛ̀' nə. Ŋwə̀ nəmòk ka Tɛ̀' nə sə̀' riŋ. Rì mègù yi mwe nə, nə ye bʉ̀ʉ sə̀ mwe nə dzəm də yi niŋ tsok fa yà'wèŋ sə. ");
INSERT INTO yam_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Wèŋ sə̀ wèŋ fàak, nə wo sə, wèeŋ və bohòmʉ. Wèŋ sə̀ wèŋ bə̀k bum sə̀ rə̀rwi', wèeŋ və bohòmʉ̀ sə̀' ya mʉ gʉ weŋ, wèŋ yoŋsə. ");
INSERT INTO yam_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wèeŋ yuŋ nsàp mandzə̀ njàm, nə sə yə'rə jəŋ bum bohòmʉ̀. Bʉsə̀ mʉ fʉ̀ə̀, nə tse' ntʉm nə̀ bə̀boŋ. Wèeŋ gʉ-a vɛ'nə ya wèeŋ nə yoŋsə. ");
INSERT INTO yam_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bʉsə̀ mandzə̀ àm ka gʉgʉŋ yeŋ, nə ye sə̀' də bum sə̀ mʉ nə naaŋ mʉ tuhù wèŋ sə fufup.>> ");
INSERT INTO yam_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nùmbu dzə̀ mòk à ye, Jisòs bə ŋgàa fàak ye wèŋ sə gi ca mvwe' nzum nzaŋ bʉ̀ʉ mok wèŋ. À ye ŋga njè sə ya ŋgàa fàak ye sə wèŋ wùriŋ. Wo ye ŋgòkʉp tu nzaŋ mok də ya wo zʉ. ");
INSERT INTO yam_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bʉ̀ʉ mok wèŋ à ye fo', ŋga wo bʉ̀ʉ Faràsi. Wo ànə ye mvəsə̀ yà' gʉ̀ vɛ'nə fana wo cep bohòJisòs. Wo dʉk fa nà' də, <<Ŋgàa fàak yo wèŋ sə gʉ̀ yusə̀ lʉ̀ʉk avès ka vɛ'nə dzəm. Wo sə kʉp nzaŋ nùmbu dzə̀ bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisòs bʉʉŋ dʉk fa wo də, <<Wèŋ ka yusə̀ Devìd bə bʉ̀ʉ ye wèŋ à gʉ̀ʉ ŋga njè ya wo yà'a ndzənə ŋwàk taŋ yuk à? ");
INSERT INTO yam_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mʉ̀ sə də mvə̀'nə̀ njè ànə yaŋ wo, bə bʉ̀ʉ ye wèŋ kə ni mʉnda'à Nwì, nə yep zʉ ntuk brɛɛd sə̀ wo à nòŋsə ŋgòkùksə Nwì fo' yà'a. Ŋga ànə ye də kaco ŋwè zʉ lok fʉk brɛd ànə yeŋ, tse'ŋga zʉ mègù nà' ŋgàa fa satikà' wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mòok sə̀' də wo à còm ndzənə ŋwàk lʉ̀ʉk Musì də a dzèŋgə̀ nùumbu dzə̀ fana ŋgàa fa satikà' wèŋ sə gʉ̀ fàk mʉ nda'à Nwì, ŋga lʉ̀k sə kà vɛ'nə dzəm, nə kà nzak fo' tse'. Wèŋ ka yà'sə sə̀' yuk yuk à? ");
INSERT INTO yam_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mʉ̀ də mʉ tsok weŋ də yumook yè' sə̀ yà' yam ghak ndap Nwì nə. ");
INSERT INTO yam_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ànə ye-a də wèŋ rì yusə̀ Nwì à cèp də yi kwa ghak ŋga bwìŋ sə koksə manziŋ nə noŋsə ŋga wo sə fa yi satikà'. Wèŋ ànə rɛɛŋ-a ncèp ènə bwɛ̀rɛ də wèŋ ka bʉ̀ʉ sə̀ wo ka jòŋ gʉ də wo bʉp dʉk fa. ");
INSERT INTO yam_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yusə də mʉ̀ʉ mo ŋwè, mʉ Tà nə̀ mʉ̀ tse' ŋàŋ bə nùmbu dzə̀ nə mʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ànə geŋ, yi ye'e me'rə fa'nə, nə kə ni mʉmvwe' ndap pìriyà awo mòk. ");
INSERT INTO yam_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ŋwə̀ nəmòk à ye mbwa nə̀ bo ye à kpʉ ma mò'fis. Bʉ̀ʉ sə̀ fo' sə fek Jisòs dʉk də, <<Co lʉ̀k ka dzəm də wo luŋsə ŋwè nùmbu dzə̀ dzəm à?>> Wo ànə sə fek yi vɛ'nə də ya wo ko yi bə nzak də yi gʉ̀ fàk nùmbu dzə̀. ");
INSERT INTO yam_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yi dʉk fəsə fa yà'wèŋ də, <<A fɛɛŋ ndà nə̀ yi tse'-a nsùŋga ye mò'fis, fana nà' gbʉ ni sənə wʉ ŋga a nùmbu dzə̀, yi me'rə nà' ca, nə kà nà' sə̀ fis-ɛ? ");
INSERT INTO yam_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wèŋ rì yàwèŋ sə̀' də yòŋsə̀ ŋwè gʉ ghak nsùŋgaŋ. Sə tsə̀' yà'sə də aco ŋwè gʉ li bə̀boŋ nùmbu dzə̀ anə.>> ");
INSERT INTO yam_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Fana yi bʉʉŋ dʉk fa ŋgà' nə̀ ŋgà bo bʉp nə də nà'a nɛp fis yak kwiŋ nà' sə. Ŋgà' nə nɛp fis yà', fana yà' gʉŋ sə̀' co ma mòk nə. ");
INSERT INTO yam_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bʉ̀ʉ Faràsi wèŋ à yə vɛ'nə, wo lo yàwo ŋgòkə̀ cu kwe' mʉtuhù yi mvə̀'nə̀ wo nə zə yi. ");
INSERT INTO yam_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisòs ànə riŋ bə zeŋ fana yi coho me'rə fo'. Bwìŋ à yù lòyi sə̀' wùriŋ fana yi gʉ wo yiyaŋ awo me pwe'. ");
INSERT INTO yam_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yi tipsə yà'wèŋ sə̀' də kà də yà'a gʉ co bwìŋ riŋ bə bum sə̀ yi sə gʉ̀ sə dʉk. ");
INSERT INTO yam_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bum yè'sə ànə sə ye vɛ'nə də ya bum sə̀ ŋgà tsòhòbum Nwì nə̀ liŋ yee Ìzayà nà'a à cèep bʉʉŋ və zìnə. ");
INSERT INTO yam_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yi à cèp də Nwì à dʉk də, <<Nè'e ŋgà fàk àm nə̀ mʉ̀ a cokfis yi. Mʉ̀ dzəm yi wùriŋ, ntʉm àm sə kwa bohòyi sə̀' wùriŋ. Mʉ nə fa yi yòŋsə̀ àm sə̀', ya yi tsoho lo fa buhu lak sə̀ sə nzeŋgòŋ sə pwe'fo' mvə̀'nə̀ mʉ̀ sə sak. ");
INSERT INTO yam_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yi nə kà cù sə fenə̀, nə kà bwìŋ sə mandzə̀ bə ŋàŋ sə̀' ko kɛ'cà. ");
INSERT INTO yam_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yi nə ye fʉ̀ə̀ bohòbʉ̀ʉ sə̀ wo jì ŋàŋ, nə sə gʉ bə̀boŋ bohòbʉ̀ʉ sə̀ wo ka tətɛsə̀ tse'. Yi nə təəŋ megu vɛ'nə, nə kà teŋsə̀ tə̀tè zìnə ye nə nə̀ ghak lì ntsə'mòk. ");
INSERT INTO yam_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","A nə ye vɛ'nə fana, bwìŋ pwe' nə naaŋ megu tu mok bohòyi.>> ");
INSERT INTO yam_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ànə geŋ, bʉ̀ʉ səmok wèŋ jəŋ və fa Jisòs ŋwə̀ nəmòk nə̀ yi à loho lis, nə kà cù sə̀' sə cèp. Yi à ye vɛ'nə bʉ̀ʉsə̀ yi à tse' yòŋsə̀ ze' mòk ndzə ni'ì yi. Jisòs à gʉŋsə ŋwə̀ ènə. Lis ye sə à mùhu fana yi cep fe'lə cù sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ŋgo bwìŋ nə̀ à ye fo' nə pwe' à mərə bə nsàp yu nə̀ Jisòs gʉ̀ nə. Wo sə fek kɛ'ca fo' dʉk də, <<Ŋwə̀ ènə ŋgwàaŋ yi nə̀ wo à dʉk də liŋ yee nə̀ ye də Mo Devìd nə àlɛ-ò?>> ");
INSERT INTO yam_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bʉ̀ʉ Faràsi wèŋ à yuk bum yè'sə fana wo dʉk də, <<Yi bɛ' fisgə̀ ze' bə ŋàaŋ sə̀ a fagə̀ yi yà' ŋkum ze' wèŋ, nə̀ liŋ yee Bezebù nà'a.>> ");
INSERT INTO yam_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisòs à rì yusə̀ wo sə tsərə sə, fana yi dʉk fa wo də, <<A ye-a ŋga lak mok gà'a zəzok, nə sə lʉ mòk bə mòk, fana lak yà'sə yà' kà tə̀tè cu. Nə ye sə̀' də buk lak mòok ga'a na bə bòp zəzok, nə sə lʉ mòk bə mòk, nà'a nə gbʉ sə̀' ghà nə. A ye-a sə̀ ndap ŋwè, yà' megu sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ye də a ye-a ŋga Satà bɛ' fis ze' nə̀ Satà nə ye də yà'sə sə niŋtsok də wo ka yà'sə cù mò'fis yeŋ. Ye də gaŋ Satà sə nə gbʉ mvə̀k mwejo. ");
INSERT INTO yam_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A ye-a də mʉ̀ sə bɛ'fis ze' bə ŋàaŋ Bezebù fana bʉ̀ʉ awèŋ wèeŋ bɛ'fisgə̀ yàwo bə ŋàaŋ sə̀ ndà? Nsàp fàk bʉ̀ʉ awèŋ nə, sə nìtsə̀' dʉk də wèeŋ bə jòŋ. ");
INSERT INTO yam_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A ye-a də mʉ̀ sə bɛ'fis yà' bə bo sə̀ Nwì fana ye də gaŋ ŋkum sə̀ Nwì sə yà' kʉəp və̀ bohòwèŋ laŋ. ");
INSERT INTO yam_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kaco ŋwə̀ nəmòk ni to mʉnda'à ŋgà ŋàŋ, nə fis jəŋ lo yumok mbwa yeŋ. Tse'ŋga yi ko kì nòŋsə to ŋgà ŋàŋ nə bə kʉ̀ ŋkuŋ yi ni to ndap nà' nə. ");
INSERT INTO yam_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","<<Ŋwə̀ nə̀ yi ka-a vesi yeŋ, ye də yi ŋwə̀ nə̀ yi sə bɛ̀ŋ mʉ. Ŋwə̀ nə̀ yi sə kà-a vesi bəbɛ' tè'e benə̀, ye də yi sə sɛ̀sə ye sɛ̀sə. ");
INSERT INTO yam_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mʉ̀ sə tsə̀' weŋ də nsàp bʉp nə̀ ŋwè gʉ̀ nà' kè yi cèp cèepə àlɛ' pwe', aco wo nə̀ swi fa yi nà'. Megu də kaco wo nə̀ swi fa yuk ŋwə̀ nə̀ yi bʉpsə liŋ Yòŋsə̀ nə̀ Rərɛŋ nə yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","A ye-a ŋga ŋwə̀ nəmòk cèp yumok sə̀ bʉp bə liŋ am, mʉ̀ʉ mo ŋwè fana aco wo nə̀ swì fa yi yà'. Ŋwə̀ nə̀ yi cep-a ye yusə̀ bʉp bə liŋ Yòŋsə̀ nə̀ Rərɛŋ nə fana wo nə̀ kà yi yà' swì yuk fa mvèsə̀ nə̀ mvèsə̀. ");
INSERT INTO yam_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","<<Wèeŋ riŋ də wu tse'-a tʉ nə̀ bə̀boŋ fana ye də tʉ nə zəm sə̀' nto'o sə̀ bə̀boŋ. A ye-a ŋga tʉ nə nə̀ bʉp, ye də nto'o ye sə nə ye sə̀' sə̀ bʉp. Wo rìgə̀ tʉ bə nsàp nto' nə̀ yi sə zəm. ");
INSERT INTO yam_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wèŋ ŋgwì bwìŋ no, wèŋ tsəm də aco wèŋ cep yusə̀ yà'a bə̀boŋ yè'sə va ŋga wèŋ bʉp vɛ'nə-ɛ. Cùu ŋwèe cèp fis mègù yusə̀ yà' rwiŋ cu sə ntʉʉ̀ yi. ");
INSERT INTO yam_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ŋwə̀ nə̀ yi bə̀boŋ, lòksəgə̀ yusə̀ yà'a bə̀boŋ, nə sə fis və sə̀' zeŋ. Ŋwə̀ nə̀ yi lòksəgə̀ ye bʉp, fis və̀gə̀ ye sə̀' bʉp sə. ");
INSERT INTO yam_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Wèeŋ riŋtse' pap dʉk də, nùmbu nə̀ wo nə̀ sak bwìŋ, ndàaŋwè pwe' nə̀ sak bə ncèep sə̀ yà' à tesə yuk kə̀ cùhù ŋgə̀ŋgàŋ pwe'fo', a dzəm ye sə̀ yi à cèp basə wà pwe'. ");
INSERT INTO yam_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wo nə̀ sak ndàaŋwè pwe' bə yusə̀ yà' tesə tsə sə̀' kə̀ cùhu yi. Anə ye zeŋ sə̀ yà'a nə gʉ wu, wù gbʉ nzak, kè ka' àlɛ.>> ");
INSERT INTO yam_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ŋgàa yə'rə̀ fa bwìŋ lʉ̀k bə bʉ̀ʉ Faràsi mok wèŋ à dʉk fa Jisòs də wo dzəm də nà'a gʉ niŋtsok fa wo yu maŋgəŋgèŋ ya wo ja'a nə riŋ də yi tse' ŋàaŋ sə̀ Nwì a fa yi àlɛ. ");
INSERT INTO yam_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisòs də, <<Kàcò! Ja'a na yòo mvə̀'nə̀ bʉ̀ʉ sə̀ ŋga'a yè'e bʉp, nə kà Nwì sə̀' rì-ɛ̀. Wèŋ fek mʉ də mʉ gʉ yu maŋgəŋgèŋ, mʉ nə kà nà' gʉ. Maŋgəŋgèŋ nə̀ wèeŋ nə ye nə mègù nə̀ nà' à ye bohòŋgà tsòhòbum Nwì nə̀ liŋ yee Jonà nà'a. ");
INSERT INTO yam_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mvə̀'nə̀ Jonà à cu sə və̀ə fuk maràŋ tɛ' ndzəmə̀ sə̀' tɛ' yà'a, mʉ̀ʉ mo ŋwè, mʉ nə cum sə ntònze sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nùmbu nə̀ Nwìi nə̀ sak nzeŋgòŋ fana bʉ̀ʉ lak Nenevì wèeŋ nə lokok sə̀', nə cep fis də wèŋ sə̀ niè' yè'e wèŋ gbʉ̀ nzak. A nə ye vɛ'nə bʉ̀ʉsə̀ Jonà ànə tsoho fa bʉ̀ʉ Nenevì wèŋ fana wo kupsə, nə bwi fa bʉp awo ŋkwɛ̀ŋ. Nə ye də yumook yè' sə̀ yà' yam càsə Jonà nə. ");
INSERT INTO yam_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nùmbu nzak nə ye sə̀', ŋkum nə̀ yi ŋwàŋwè nə̀ yi à tesə və̀ mvwe' lak Sibà nà'a nə̀ lòkok sə̀' mʉ tuhù wèŋ, nə cep fis sə̀' də wèŋ gbʉ̀ nzak. Anə ye vɛ'nə bʉ̀ʉsə̀ yi à lòkok haaŋ mvwe' sə̀ sə̀sap wùriŋ ŋgòkə̀ yu'rə ncèep ŋkərə̀ə sə̀ Sòlomù à sə cèep. Nə ye də yumook yè' sə̀ yà' gʉ ghak Sòlomù nə. ");
INSERT INTO yam_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","<<A yegə̀ də a ye ŋga yòŋsə̀ ze' tesə mè'rə-a ŋwè, yi gì jàm dzoŋ kɛ' mvwe' nze nə̀ jì ndzəp nà'a ŋgòlàp mvwe' ncum. Yi kà mvwe' ncum sə yə, ");
INSERT INTO yam_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","fana yi tsərə də, <Mʉ nə bwi foho lo fe'lə mvwe' ndap àm nə̀ mʉ̀ a tesə və̀ fo' nə.> Yi bwìŋ foho və̀ fo' fana yi yə ŋga nà' nòwà, ŋga wo kùrə rɛŋsə nòŋsə nà' bə̀boŋ làaŋ. ");
INSERT INTO yam_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Fana yi lo, nə kə to jəŋ və fe'lə yòŋsə̀ə ze' mok sə̀ wo bʉp càsə yi wèŋ sàmba, wo kə ni cum fo'. A ye vɛ'nə fana yà' bʉp wesə bohòŋwə̀ ènə mok maŋkwɛ̀ŋ nə noŋsə mvə̀'nə̀ à ye to mantombì. A nə̀ kə̀ ye bohòwèŋ bʉ̀ʉ sə̀ bʉp sə̀ ŋgà'a yè'e sə̀' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yi ànə sə cep mali bohòbʉ̀ʉ sə wèŋ ntòvɛ'nə fana ma ye bə bwema ye wèŋ kə təəŋ sə mbi də wo dzəm də nà'a və bə yà'wèeŋ cep yu səmok. ");
INSERT INTO yam_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ŋwə̀ nəmòk tsok yi də, <<Ma yo bə bwe ma yo wèŋ tə sə mbi də wenə wèeŋ cep.>> ");
INSERT INTO yam_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Fana yi fek ŋwə̀ nə̀ nà' tsə̀' yi nə də, <<Ma am bə bwema am wèeŋ ndà wèŋ?>> ");
INSERT INTO yam_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yi niŋ gesə lo ŋgàa fàak ye sə wèŋ bə bo, nə sə cep də, <<Curə ya' yè'e ma am bə bwema am wèŋ sə. ");
INSERT INTO yam_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ŋwə̀ nə̀ yi gʉ-a yusə̀ tɛ̀' àm mʉbu sə dzəm sə, ye də yi yà'sə moma am, nə ye njɛ̀' am, bə ma am sə̀' yi.>> ");
INSERT INTO yam_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jisòs à tesə tsə mʉnda'à sə̀' nùmbu ànə, nə kə cum ŋgʉ ndzəp Galìli. ");
INSERT INTO yam_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bwìŋ kə maŋ mvwe' sə̀ yi cu sə wùriŋ, fana yi ni cum ye sə mok sənə ŋgwes mòk. Bʉ̀ʉ sə wèŋ pwe' təəŋ yàwo ma mʉ mfèŋ. ");
INSERT INTO yam_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yi sə tsoho fa yà'wèŋ bum ŋkʉ̀ʉŋntɛ̀ŋ bə gbʉ'. Yi à cèp mòk də, <<Ŋgà bì ŋgwìi bum mòk à lo də yi kə ŋwə ŋgwìi bum mok. ");
INSERT INTO yam_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Fana mvə̀'nə̀ yi à sə ŋwə̀ yà', mok gbʉ ŋgʉ mandzə̀ fana swiŋ wèŋ kə te'e zʉ lo yà'. ");
INSERT INTO yam_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ŋgwìi mok gbʉ mvwe' nze lìs. Ncàk kà fo' ŋkʉ̀ʉŋ ye fana yà' to, nə kà mandzə̀ ŋgòsòŋgàŋ tse'. ");
INSERT INTO yam_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nùm à to kok fana yi tɛŋ zə yà'. Mvə̀'nə̀ yà' ànə ka ŋgàŋ bə̀boŋ tse' fana yà' kpʉ. ");
INSERT INTO yam_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ŋgwìi mok gbʉ yàwo mvwe' ndik sə̀ bə njàk. Ndik sə kuk, nə lim te'lə tse' yà'. ");
INSERT INTO yam_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mok à gbʉ̀ yàwo mvwe' nze nə̀ bə̀boŋ, nə zəm ŋgwì. Mok zəm wùriŋ co ŋkʉ̀ mò'fis, mok hum ntùŋfu, mok hum tɛ'. ");
INSERT INTO yam_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ŋwə̀ nə̀ yi tse'-a ntu' ŋgòyuk bum fo', yi yuk-a.>> ");
INSERT INTO yam_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ànə geŋ, ŋgàa fàak ye sə wèŋ kə fek yi də, <<Wù sə cèp mègù bohòwo bə gbʉ' bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yi dʉk fəsə fa yà'wèŋ dʉk də, <<A bʉ̀ʉsə̀ wo ka yàwo mandzə̀ nə̀ Nwì a fa wo co wo rɛɛŋ bum sə̀ yà' cu swìhi mvwe' gaŋ ŋkum Nwì sə tse'. Nwì à fa weŋ yàwèŋ mandzə̀ ànə laŋ. ");
INSERT INTO yam_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yusə də, ŋwə̀ nə̀ yi tse'-a yumok, Nwìi nə jo naaŋ fa fe'lə yi mok sə̀' ya yi tse' ŋkʉ̀ʉŋntɛ̀ŋ. Nə ye də bohòŋwə̀ nə̀ yi ka ye yumok tse', Nwìi nə jəŋ fis gɛsə lo moòm nə̀ yi tse' nə fo'. ");
INSERT INTO yam_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Njo nə̀ mʉ̀ sə cèp bohòwo bə gbʉ' nə də bʉ̀ʉsə̀ wo tse' lis, nə kà bum sə yə, wo tse' ntu', nə kà bum sə̀' sə yuk. Wu tsə̀'-a wo yumok, wo kà sə̀' rɛɛŋ. ");
INSERT INTO yam_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ye də bum sə̀ ŋgà tsòhòbum Nwì nə̀ liŋ yee Ìzayà à cèp yà'a kə̀ kʉ̀rə zìnə mʉtuhù wo. Yusə̀ yi à cèp sə də, <Wèeŋ nə yuk bum, nə kà yà' rɛɛŋ yuk, Wèeŋ nə sə kʉk, nə kà yə. ");
INSERT INTO yam_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bʉsə̀ ntʉm bʉ̀ʉ yè'sə wèŋ a gʉ bʉp laŋ. Ntu' awo loho, fana wo lok lis awo sə̀'. Ka-a vɛ'nə yeŋ də bwɛ̀rɛ wo yə rì bə lis awo, nə yuk bə ntu', Fana nə rɛɛŋ sə ntʉʉ̀ wo, Ya wo bʉʉŋ və bohòmʉ̀, mʉ̀ luŋsə wo.> ");
INSERT INTO yam_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Fana rɛŋsi bohòwèŋ bʉ̀ʉsə̀ lis awèŋ sə yə fana ntu' awèŋ sə yuk bum yo. ");
INSERT INTO yam_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mʉ̀ sə tsə̀' weŋ yè'e yusə̀ yà'a zìnə də ŋgàa tsòhòbum Nwì bə bʉ̀ʉ sə̀ wo kə̀kʉrə̀ bohòNwì wèeŋ vɛ'ɛ wùriŋ sə̀ wo à dzəm co wo ye ja'a bum sə̀ wèŋ sə yə yè'e, nə kà mandzə̀ nə tse'. Wo dzəm sə̀' co də wo yuk bum sə̀ wèŋ sə yuk yè'e, nə kà sə̀' yuk. ");
INSERT INTO yam_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","<<Wèeŋ yuk-a ŋga'a mvə̀'nə̀ mʉ nə tsok rɛŋsə gbʉ' ŋgà bì bum nə. ");
INSERT INTO yam_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ŋwèe yuk ncèp gaŋ ŋkum Nwì, nə kà bə zeŋ rɛɛŋ fana ze' nə və, nə kə jəŋ fis lo yusə̀ wo bì yà' sə ntʉʉ̀ yi sə. Nà'a yà'sə ŋgwìi sə̀ yà' à gbʉ̀ ŋgʉ mandzə̀ sə. ");
INSERT INTO yam_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ŋgwìi sə̀ wo à ŋwə̀ yà' fana yà' gbʉ mʉnə nze nə̀ a fo' bə lìs nə, a ŋwə̀ nə̀ yi yuk ncèp nə fana yi kwa boŋsə toho bə zeŋ vɛ'ɛ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Fana nà' kà ŋgàŋ sə ntʉʉ̀ yi sò. Yi təəŋ moòm ghàr. Ghà nə̀ ŋgə' və̀ bohòyi gbʉ gɛsə lo fo'. ");
INSERT INTO yam_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ŋgwìi sə̀ wo à ŋwə̀ yà' mvwe' ndik sə̀ bə njàk sə, nà'a yi nə̀ yi yuk ncèp nə fana bum nzeŋgòŋ nə ye ntʉm nə̀ ŋgòtse' ghàk wèŋ kə lim te'lə tse' ncèp nə fana nà' kà zəm. ");
INSERT INTO yam_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nə ye də ŋgwìi sə̀ yà' à gbʉ̀ mʉmvwe' nze nə̀ bə̀boŋ sə ŋwə̀ nə̀ yi yuk ncèp nə, yi rɛɛŋ bə zeŋ. Fana yi zəm ŋgwì ghà mòk ŋkʉ̀ mò'fis, mok hum ntùŋfu bə hum tɛ' wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yi à tsə̀' fa fe'lə yà'wèŋ gbʉ' mòk sə̀' də <<Aco wo fʉ'rə kok gaŋ ŋkum sə̀ mʉbu sə bə ŋwə̀ nəmòk nə̀ yi à kə̀ bì ŋgwìi bum sə̀ bə̀boŋ mʉ nzuù yi. ");
INSERT INTO yam_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yi ànə sə nooŋ dzəm lo fana ŋwə̀ nəmòk nə̀ nà'a bɛ̀ŋgə̀ yi kə bi ŋgaŋ sə̀ bʉp sə̀ yà' səsə nzaŋ mvwe' nzaŋ sə̀ yi anə bi sə. Yi bi ŋgaŋ sə vɛ'nə fana yi bɛ' mandzə̀ ye, nə lo yuye. ");
INSERT INTO yam_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ghà nə̀ nzaŋ sə à kùk tə̀tè nə ye ŋgòfis tu fana ŋgaŋ sə lokok sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bwe ŋgàa fàak ŋgà nzum nə kə fek yi də, <Tà, vès də wù à bì mègù mʉ nzuù wù ŋgwìi bum sə̀ bə̀boŋ àlaa. Ŋgaŋ sə̀ bʉp nə və̀ nə fo' fò?> ");
INSERT INTO yam_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ŋgà nzum nə dʉk fəsə fa wo də, <Gʉ̀ yu yà'sə ŋwə̀ nəmòk nə̀ yi ka mʉ dzəm.> Wo fek fe'lə yi dʉk də, <Ye də wù dzəm də vèes lo kə co'rə mak yà' à?> ");
INSERT INTO yam_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yi dzeeŋ də yi ka dzəm. Yi də bʉ̀ʉsə̀ aco ghà nə̀ wo sə də wo cok mak ŋgaŋ sə fana wo co'rə bʉpsə nzaŋ mok bə ŋgaŋ sə̀ yà' səsə nzaŋ sə. ");
INSERT INTO yam_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mè'rə yà'a kuk mvwe' mò'fis vɛ'nə tə̀tè mvə̀k nə̀ ŋgòkʉp yà' kə dzeŋ. Mvə̀k ànə dzèŋ nùu fana mʉ̀ tsok fa ŋgàa kəkʉp sə wèŋ də, <Wèeŋ co'rə be'lə to ntòŋgaŋ sə̀ bʉp yà'a mvwe' mò'fis, nə kiŋ yà' bə mbə̀k bə mbə̀k ya wo tɛŋ yà'. Nə tsok wo sə̀' də wo kʉp naaŋ gesə fa mʉ nzaŋ sə mʉ tà'a mʉ̀.> >> ");
INSERT INTO yam_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisòs à tsə̀' fa mali wo gbʉ' mòk sə̀ də, <<Gaŋ ŋkum sə̀ Nwì sə co ŋgwì tʉ nəmòk nə̀ wo to nà' də mostà, nə̀ ŋwə̀ nəmòk à kə̀ bì nà' mʉ nzuù yi. ");
INSERT INTO yam_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nà' jə'rə càsə ŋgwìi bum sə̀ wo bìgə̀ mʉ nzuù pwe'fo' yi. Ghà nə̀ nà'a kùuk, nà' yam casə mok sə pwe'fo' sə̀' yi. Nà' bʉʉŋ tʉ nə̀ ghaŋ wùriŋ. Swiŋ wèŋ və, nə sə kə ci ndap awo mʉnə ntaŋ ye sə.>> ");
INSERT INTO yam_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yi cep fe'lə gbʉ' mòk də, <<Gaŋ Nwì sə co yis sə̀ ŋwàŋwèe jəgə̀ yà', nə gesə sənə tasàa mfòŋ tɛ', nə top yà' tə̀tè yà' kok pwe' yè'e.>> ");
INSERT INTO yam_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Bum yè'sə pwe'fo', Jisòs à sə tsòho fa gù bʉ̀ʉ sə wèŋ yà' bə gbʉ' bə gbʉ'. Yusə̀ co yi à tsə̀' fa wo jì gbʉ' à ka yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yi à gʉ̀ vɛ'nə ya yusə̀ ŋgà tsòhòbum Nwì à cèp bə liŋ ŋgà gèm bwìiŋ bʉʉŋ və zìnə. Yusə̀ yi à cèp sə də, <<Mʉ nə muk cùu am, nə sə cep bum lòoŋ fo' bə gbʉ' bə gbʉ'. Mʉ nə cep bum sə̀ mvə̀'nə̀ nzeŋgòŋ à yè yèe, yà' sə cum megu mvwe' sə̀swihì.>> ");
INSERT INTO yam_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ànə geŋ, yi me'rə kwe' bʉ̀ nə̀ fo', nə ni lo yuye mʉ nda'à. Ŋgàa fàak ye wèŋ a bɛ' lòyi fo', nə sə fek yi də nà'a tsok rɛŋsə fa wo gbʉ' nə̀ də wo à bì ŋgaŋ sə̀ bʉp mvwe' nzum nà'a. ");
INSERT INTO yam_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yi sə tsòho rɛŋsə fa yà'wèŋ dʉk də, <<Ŋwə̀ nə̀ ŋgà bì ŋgwìi bum sə̀ bə̀boŋ sə, a mʉ̀ʉ mo ŋwè. ");
INSERT INTO yam_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nzum sə nzeŋgòŋ nə, ŋgwìi sə̀ bə̀boŋ sə, a bʉ̀ʉ sə̀ wo cu yàwo mvwe' gaŋ ŋkum Nwì sə fana ŋgaŋ sə̀ bʉp sə yàwo bʉ̀ʉ sə̀ wo cu yàwo ma nə̀ ze'. ");
INSERT INTO yam_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ŋwə̀ nə̀ yi à bì ŋgaŋ sə̀ bʉp sə, a ze' nə bə tu ye. Mvə̀k nə̀ ŋgòkʉp bum sə̀ wo à bì sə yà'a nzeŋgòŋ nə mvə̀'nə̀ nà' mèe, fana ŋgàa kʉp bum sə yà'sə masinjàa Nwì wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mvə̀'nə̀ wo à benə ŋgaŋ sə, nə tɛŋ yà' yà'a, anə ye nùmbu nə̀ nzeŋgòŋ nə mè sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mʉ̀ʉ mo ŋwè, mʉ nə̀ tumsə masinjàa am ŋgòte'e fis yusə̀ yà' cu mvwe' gaŋ sə, sə̀ co yà' jəŋ və bʉp, nə ye bə ŋgàa gʉ̀ bʉp wèŋ pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wo swekfis wes wo vɛ'nə fana wo kə mak gesə lo wo sə mvwe' sə̀ mis sə kʉə. Yà'a mvwe' sə̀ bwìiŋ nə sə waŋ, nə sə zʉ nzòŋ fo'. ");
INSERT INTO yam_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nà'a sə̀' mvə̀k nə̀ bʉ̀ʉ sə̀ wo yàwo kə̀kʉrə̀ ma nə̀ Nwì wèeŋ nə sə to rɛŋ co nùm mvwe' gaŋ tɛ̀' awo. Ŋwə̀ nə̀ yi tse'-a ntu' ŋgòyuk bum bə zeŋ, yi yuk a. ");
INSERT INTO yam_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","<<Gaŋ sə̀ Nwì sə yà'a co yumok sə̀ yà' gʉ ntɛŋ sə̀ yà' à swìhi nòoŋ mvwe' səmok. Ŋwə̀ nəmòk anə kə ye yà' fana yi ses lok yà'. Yi kwa vɛ'ɛ, nə kə caŋ seŋ bum sə̀ yi tse' pwe'fo', nə kə ywiŋ jəŋ nzum sə̀ mvwe' yà'sə. ");
INSERT INTO yam_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","<<Gaŋ sə̀ Nwì sə yà'a sə̀' co ŋgà gì gìi ntɛŋ nə̀ yi à sə làp nsàp lìs mòk nə̀ wo togə̀ nà' də perèl. ");
INSERT INTO yam_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yi ànə ye perèl nə̀ mò'fis nə̀ nà' gʉ ntɛŋ fana yi lo, nə kə seŋ bum ye sə̀ yi tse' sə pwe'fo', nə kə ywiŋ nà' bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","<<Gaŋ sə̀ Nwì sə sə̀' co ram mòk nə̀ wo màk gèsə nà' sə ndzəpə̀ fana nsàap fuk kwəəŋ ni ca zəzok zəzok nduk. ");
INSERT INTO yam_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nà' ànə rwiŋ fana wo fis lo nà' mʉ mfèŋ fana nə cum nze, nə ye ŋgòte'e yà'. Wo sə swèk gèsə lòsə̀ bə̀boŋ sənə yumok, nə sə fis mak sə̀ bʉp sə. ");
INSERT INTO yam_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nùmbu nə̀ nzeŋgòoŋ mèe, anə ye sə̀' vɛ'nə. Masinjàa Nwì wèeŋ nə̀ və̀ə, nə kə gapsə fis bʉ̀ʉ sə̀ wo yàwo kə̀kʉrə̀ ma nə̀ Nwì bə sə̀ wo ka yàwo kə̀kʉrə̀ yeŋ wèŋ zok. ");
INSERT INTO yam_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Wo mak gesə lo bʉ̀ʉ sə̀ wo ka kə̀kʉrə̀ yeŋ sə mvwe' nəmòk nə̀ mis sə kʉə ca. Yà'a mvwe' sə̀ ŋwèe nə sə waŋ, nə sə zʉ nzòŋ ca.>> ");
INSERT INTO yam_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yi fek yà' də yà' rɛɛŋ bə bum sə̀ yi cèp yè'sə pwe'fo' laŋ àlɛ. Wo də hòli. ");
INSERT INTO yam_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yi tsok fa fe'lə yà'wèŋ də, <<Ye də wèŋ rì də ŋgà yə'rə̀ lʉ̀k nə̀ yi a bʉ̀ʉŋ də mʉ yə'rə yi mvə̀'nə̀ gaŋ sə̀ Nwì cu, yi co ŋwə̀ nəmòk nə̀ yi tse' tàap ye. Aco yi fis və to bum sə̀ zəm mʉ tà'a yi, nə fis sə̀ fi sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisòs ànə cep wes gbʉ' yè'sə fana yi me'rə fa'nə, nə lo. ");
INSERT INTO yam_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","À kə̀ dzèŋ la'à yi fana yi kə yə'rə bwìŋ mʉmvwe' ndaap pìriyà àwo wèŋ. Wo à mərə vɛ'ɛ wùriŋ, nə sə cep dʉk də, <<Ŋwə̀ nè'e a jə nsàp ŋkərə̀ nè'e nə ye nsàap fàak sə̀ yà' gʉ wùriŋ yè'e fòvɛ'nə-ɛ? ");
INSERT INTO yam_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nè'e ka mo kapindà nà'a yeŋ-ɛ̀? Nè'e ka yi nə̀ wo to liŋ ma ye də Mèri nà'a yeŋ-ɛ̀? Jem bə Jòsep bə Saimʉ̀ nə ye Judàs wèŋ ka bwema ye wèŋ yeŋ nɛ̀? ");
INSERT INTO yam_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A cugə̀ fɛɛŋ ka sə̀' ves njɛ̀' ye wèŋ pwe' yeŋ nɛ̀? Aco yè'sə ye vɛ'nə va?>> ");
INSERT INTO yam_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Fana wo kà yi mok dzəm. Ànə geŋ Jisòs nə tsok fa ye yà'wèŋ də, <<A yegə̀ də wo jəgə̀ ŋgà tsòhòbum Nwì ma nə̀ yi lòfòpwe' co ŋwè. A kə̀ dzèŋ mvwe' lak ye, nə ye mʉ nda'à yi fana wo kà yi co yumok jə.>> ");
INSERT INTO yam_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yi à ka fàak sə̀ yà' gʉ fa'nə ŋkʉ̀ʉŋ gʉ bʉ̀ʉsə̀ bʉ̀ʉ sə̀ fo' sə wèŋ à ka dzədzəm sə ntʉʉ̀ wo tse'. ");
INSERT INTO yam_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ghà ànə à ye, ŋkum Heròyuk bə bum sə̀ Jisòs sə gʉ̀ʉ sə. ");
INSERT INTO yam_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herònə dʉk fa ncìnda'a ye wèŋ dʉk də, <<A Jon ŋgà bàptɛsə̀ bwìŋ, yi a tesə və̀ fe'lə mvwe' kpʉ yà'sə laŋ. Nà'a njo nə̀ yi sə gʉ̀ to bum maŋgəŋgèŋ sə.>> ");
INSERT INTO yam_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Yusə də Heròà fis jə ŋgwe moma ye Filìp. Yi ànə gʉ vɛ'nə fana Jon sə dʉhʉ gəgeŋ fa yi də, <<Ka bə̀boŋ bohòwù ŋgòjə ŋwà ànə co ŋgwe yo yeŋ.>> Ànə ye vɛ'nə fana Hèrodiyà ŋgwe Filìp nə fimsə mis tə̀tè Herònə ko nisə Jon ndapndzəm. ");
INSERT INTO yam_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yi ànə dzəm də yi zə Jon nə fana yi sə wəp sə̀' bʉ̀ʉsə̀ bwìiŋ dʉkgə̀ də Jon nə ŋgà tsòhòbum Nwì. ");
INSERT INTO yam_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nùmbu nə̀ wo à dzə Herònə à dzèŋ sə̀mok fana mo Hèrodiyà nə nə̀ ŋgwə̀ŋgwɛ̀ŋ à kə̀ kà dzeŋ mvwe' sə̀ bwìŋ à mà cu sə. Yi kaŋ vɛ'ɛ tə̀tè ni' boŋ Herònə. ");
INSERT INTO yam_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herònə kɛŋ də yusə̀ nà' dzəm yà' pwe'fo' yi nə fa tsoŋ nà'. ");
INSERT INTO yam_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mvə̀'nə̀ ma ye tip yi fana yi dʉk fa Herònə də, <<Fa mʉ tu Jon ŋgà bàptɛsə̀ bwìŋ nà'a ŋga'a fɛŋ mʉnə tasà.>> ");
INSERT INTO yam_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Manziŋ à ko ŋkum nə vɛ'ɛ wùriŋ. Fana njo nə̀ yi anə kɛŋ to laŋ, nə ye fe'lə sə̀' bʉ̀ʉ bʉ̀ʉ sə̀ wo mà fo' sə fana yi dʉk də yà'a kə jəŋ və fa nà'. ");
INSERT INTO yam_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yi à tum lòo, wo kə gwɛ' tiŋ fis tu Jon mʉ ndapndzəmə̀ anə. ");
INSERT INTO yam_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Wo jəŋ və yà' mʉnə tasà, nə kə fa mʉŋwà nə. Yi jəŋ yà', nə jəŋ lo fa ma ye. ");
INSERT INTO yam_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ŋgàa fàak Jon nə wèŋ à kə jə vèŋ ni' ye nə, nə kə tuuŋ nà'. Wo à tuuŋ wes, wo lo, nə kə tsok fa Jisòs. ");
INSERT INTO yam_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisòs ànə yuk vɛ'nə fana yi ni ŋgwes mòk, nə lo mvwe' mòk sə̀ bwìiŋ fo' bʉ̀ə̀. Mfèŋ bʉ̀ nə ànə yuk vɛ'nə fana wo tesə mvwe' buhu lak sə̀ yà' kʉəp fo' pwe', nə yuŋ lo yi sə̀' bə kù. ");
INSERT INTO yam_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yi à kə̀ tesə ŋgʉ ndzəp fana yi ye bwìŋ vɛ'ɛ nduk nə̀ nduk. Ntʉm ye rwiŋ bə manziŋ fana yi gʉ mesə fa sə̀ wo tse' yiyaŋ, yiyaŋ awo sə. ");
INSERT INTO yam_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nùm à co fana ŋgàa fàak ye wèŋ və bohòyi, nə kə dʉk fa yi də, <<Yè'e mvwe' sə̀ bwìŋ kà fɛnə cugə̀, nùm nə coònə sə̀' laŋ. A bə̀boŋ də wu dʉk bʉ̀ʉ yè'e wèeŋ lo ndzə ntòlak, nə kə ywiŋ zʉ yumok nja.>> ");
INSERT INTO yam_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisòs dʉk ye də, <<Yà'wèeŋ nə kà lò. Wèeŋ kʉk fa wo yumok wo zʉ.>> ");
INSERT INTO yam_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wo dʉk fa yi də, wo tse' mègù ntuhu brɛd tàŋ bə fuk ba nə̀ ba. ");
INSERT INTO yam_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yi də yà'a jəŋ və fa yi yà' fɛn. ");
INSERT INTO yam_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ànə geŋ yi dʉk fa bʉ̀ʉ sə wèŋ pwe' də yà'a cum nze mʉnə ŋgaŋ. Yi jəŋ kotse' ntuhu brɛd sə̀ tàŋ nə ye fuk sə̀ ba sə, nə kʉk gesə lo mʉbu. Yi kwasə Nwì, nə sə bə'rə yà', nə sə faha ŋgàa fàak ye sə wèŋ. Wo jəŋ, nə gap lo fa maŋgo bʉ̀ nə pwe'. ");
INSERT INTO yam_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wo à zʉ wo pwe', nə ze' bə̀boŋ. Fana wo te'e benə sə̀ yà' à bwehe cu sə, yà' tesə kwès hum-ncòp-ba. ");
INSERT INTO yam_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bʉ̀ʉ sə̀ wo zʉ sə à ye co mbəmbam ncùhù tàŋ. Wù kà bə̀ba bə bweŋke' wèŋ yàwo ta. ");
INSERT INTO yam_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wo à mèsə, Jisòs gʉ də bwe yee ni ŋgwes, nə lo mantombì ŋgòto lòmamòk. Yi cum ye maŋkwɛ̀ŋ, nə cepsə bwìŋ ya wo lo la'à wo. ");
INSERT INTO yam_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yi ànə mam, nə cepsə wo, wo lo. Fana yi lo ye mʉmvwe' nda mòk ŋgòkə̀ gʉ̀ pìriyà mbwa yiìyi. Ndzəm à sə də a seŋ və fana ŋga yi cu mbwa yiìyi. ");
INSERT INTO yam_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mvə̀k ànə à ye ŋga ŋgwes nə lòndzə tsətsə'rə ndzəp anə sə̀sap wùriŋ. Ndzəp sə bwi'lə ŋgwes nə vɛ'ɛ nə̀ bʉp bʉ̀ʉsə̀ fə̀fə̀ à sə və̀ ma nə̀ wo à sə dzəm ŋgòlònə. ");
INSERT INTO yam_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","À kə̀ dzèŋ mvə̀'nə̀ mvəp à yè ŋgòtorə ndzəmə̀ anə fana Jisòs və bohòwo ŋga yi sə gì və̀ ma mʉ ndzəpə̀. ");
INSERT INTO yam_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ŋgàa fàak ye sə ànə ye yi mvə̀'nə̀ yi sə gì mʉ ndzəpə̀ anə fana wʉə ko wo vɛ'ɛ nə̀bʉp. Wo dʉk ŋgwàaŋ də, a maze' mòk, nə kɛ' nooŋ ŋgùŋ. ");
INSERT INTO yam_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ànə geŋ yi to yà'wèŋ sə̀' ntɛ̀ŋ, nə dʉk fa wo də, <<A mʉ̀, wèeŋ kà wəp.>> ");
INSERT INTO yam_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pità cep gesə fa nà' də, <<Tà, a ye-a ŋga də a wù zìnə, wù dʉk mʉ ya mʉ gi və ŋgòkə̀ yə wu sə̀' mʉ ndzəpə̀ anə.>> ");
INSERT INTO yam_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yi dʉk fa nà' də <<Və̀ə.>> Fana Pità nə tesə sə ŋgwesə̀ anə, nə sə gi sə̀' mʉ ndzəpə̀ anə ŋgòkə̀ yə Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ànə geŋ yi ye mvə̀'nə̀ fə̀fə̀ sə fa ŋgə' nə̀ bʉp fana wʉə ko yi, yi ye ŋgòcəəŋ lòsə ndzəpə̀ anə. Yi waŋ torə fis dʉk də, <<Ɛtɛɛ̀, Tà tɛsə mʉ.>> ");
INSERT INTO yam_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisòs fa bo sə̀' ntɛ̀ŋ, nə ko nà'. Yi à sə ko nà' vɛ'nə, yi sə dʉk fa nà' sə̀' dʉk də, <<O' òhoò, dzədzəm yòjə'rə vɛ'ɛ wùriŋ. Wù anə mərə bwi bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wo ànə kə ni sənə ŋgwes nə fana fə̀fə̀ nə teŋsə. ");
INSERT INTO yam_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bʉ̀ʉ sə̀ wo à ye sənə ŋgwes nə pwe'fo' à kùksə yi. Wo dʉk fa yi də, <<Wu mo Nwì zìnə bə zìnə.>> ");
INSERT INTO yam_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wo à to tesə lòmʉmfèŋ fana wo tesə və mvwe' lak Jènesarè. ");
INSERT INTO yam_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bʉ̀ʉ lak sə̀ fo' sə ànə ye riŋ yi fana wo tirə lo mvwe' lak sə̀ yà'a fo' sə pwe'fo', wo sə jəŋ və fa yi ŋgàa yiyaŋ sə̀ fo' sə pwe'. ");
INSERT INTO yam_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wo à jə və̀ yà'wèŋ vɛ'nə fana wo lɛŋ yi də nà'a me'rə ŋgàa yiyaŋ sə wèeŋ jwɛŋ megu cù cə̀k ye ya wo gʉŋ. Bʉ̀ʉ sə̀ wo à jwɛ̀ŋ pwe'fo', à gʉ yu awo. ");
INSERT INTO yam_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ànə geŋ, bʉ̀ʉ Faràsi mok bə ŋgàa yə'rə̀ fa bwìŋ lʉ̀k wèŋ à və̀ bohòJisòs ŋgòfek yi bum səmok. Wo à tesə və̀ mvwe' lak Jòrosalèm. Wo à fek yi dʉk də, ");
INSERT INTO yam_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","<<Ŋgàa fàak yo wèeŋ kà bum lak sə̀ bʉ̀ ŋkwàha bwìŋ wèŋ à nòŋsə yùgə̀ bʉ̀ʉ yà? Vès dʉk vɛ'nə bʉ̀ʉsə̀ wo zʉgə̀ bɛŋ ŋga wo kà bo awo cuk.>> ");
INSERT INTO yam_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yi fek bʉsə ye yà'wèŋ sə̀' də, <<Njo nə̀ wèeŋ kà lʉ̀ʉk Nwì nòŋsə̀gə̀ bʉ̀ʉsə̀ wèŋ dzəm ŋgòbɛ' bum lak awèŋ-e bʉ̀ʉ ya? ");
INSERT INTO yam_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bʉsə̀ Nwì à cèp də, <Wəp ma yo bə tɛ̀' yo. Ŋwə̀ nə̀ yi yò-a ma kè tɛ̀' ye àlɛ, wo zə megu yi zəə.> ");
INSERT INTO yam_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wèŋ cwiŋ bʉsə yàwèŋ dʉk də, a ye-a ŋga ŋwè tse' yumok sə̀ co yi tɛsə ma ye kè tɛ̀' ye bə zeŋ, nə kà yà' tɛsə, nə dʉk fa yà'wèŋ də yusə̀ yi tse' sə a sə̀ Nwì, ye də yi ka nzak bohòma bə tɛ̀' ye nə mok tse'. ");
INSERT INTO yam_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Wèŋ yə mvə̀'nə̀ wèŋ a gʉ̀ bʉ̀sə ncèp Nwì mok yusə̀ wà bʉ̀ʉ bum lak awèŋ nà? ");
INSERT INTO yam_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wèŋ ŋgàa tè'èŋkup wèŋ! Yusə̀ Ìzayà ànə cèp mantombì sə kum weŋ à ye zìnə. Yi à còm də, ");
INSERT INTO yam_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<Bʉ̀ʉ yè'e wèŋ sə kwasə mègù mʉ bə cù wà, fana ntʉm awo ye sə̀sap bohòmʉ̀. ");
INSERT INTO yam_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wo sə kùksə basə mʉ ŋgwàŋ, nə sə yə'rə yusə̀ bwìŋ à cèp wo co yà'a lʉ̀ʉk Nwì.> >> ");
INSERT INTO yam_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ànə geŋ Jisòs to benə və bʉ̀ʉ sə wèŋ pwe'fo' ŋgʉ ni'ì yi, nə dʉk fa yà'wèŋ də, <<Wèeŋ yu'rə nə rɛɛŋ yusə̀ mʉ̀ sə də mʉ tsok weŋ yè'e bə̀boŋ. Yusə də, ");
INSERT INTO yam_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","yusə̀ yà' ni lògə̀ mʉ cùhù ŋwè kəkok kà ŋwè bʉpsə̀gə̀. A bʉpsəgə̀ yi yusə̀ yà' sə tesə tsə mʉ cùhù yi anə tsətsoŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Fana ŋgàa fàak ye wèŋ və, nə kə dʉk fa yi də, <<Wù rì də mvə̀'nə̀ wù cèp vɛ'nə yà'sə, bʉ̀ʉ Faràsi wèŋ jòk bohòwù vɛ'ɛ wùriŋ à?>> ");
INSERT INTO yam_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yi cep fəsə fa yà'wèŋ dʉk də, <<Ŋgwì yu nə̀ tɛ̀' am Nwì a ka nà' yi bi pwe', yi nə cok mak nà' sə nze. ");
INSERT INTO yam_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mè'rə wo vɛ'nə. Wo ka lis tse', nə sə də wo niŋtsok fa bʉ̀ʉ mok wèŋ mandzə̀. Nə ye də a ye-a ŋga ŋgà jì lis sə nìtsə̀' lòfa ŋgà jì lis mòk mandzə̀ fana wo ba fo' nə gbʉ lo sə wʉrə̀.>> ");
INSERT INTO yam_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pità fek nà' də nà'a tsok rɛŋsə fa wo gbʉ' nə̀ də yusə̀ yà'a tesə tsəgə̀ kə̀ cùhù gʉ̀ bʉpsəgə̀ ŋwè nà'a. ");
INSERT INTO yam_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yi fek bʉsə fe'lə Pità nə də, <<Wèeŋ sə̀' ŋgàa kà bum rɛɛŋ mok à? ");
INSERT INTO yam_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wèŋ ka riŋ də yusə̀ yà'a ni lògə̀ mʉ cùhù ŋwè pwe'fo' cà lògə̀ sə və̀ə, nə ca tesə lo sə̀' riŋ à? ");
INSERT INTO yam_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nə ye də yusə̀ yà'a tesə tsəgə̀ mʉ cùhù ŋwèe kokgə̀ yà'sə sə ntʉʉ̀ yi. Yà'a zeŋ sə̀ aco yà' gʉ bʉpsə ŋwè. ");
INSERT INTO yam_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A vɛ'nə bʉ̀ʉsə̀ tsətsərə̀ə sə̀ bʉp sə̀ co ŋgòzə ŋwè, ko nto, kohòsàhà, yə̀, ŋgòci' mvwès, nə ye ŋgòbʉpsə liŋ bwìŋ pwe'fo' tesə kokgə̀ ma sə ntʉʉ̀ ŋwè. ");
INSERT INTO yam_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yà'a bum sə̀ yà'a gʉ̀ bʉpsəgə̀ ŋwè. Ŋgòzʉ yumok bə bo sə̀ wù ka yà' cuk, ka nzak tse'.>> ");
INSERT INTO yam_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ànə geŋ, Jisòs ye'e me'rə mvwe' yà'sə, nə lo mvwe' nzeŋgòŋ nə̀ lak Tayà bə Sidòŋ. ");
INSERT INTO yam_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Fana ŋwà nəmòk nə̀ yi cugə̀ fo' kə̀ tsèŋ yi. Ŋwà nə sə lɛŋ Jisòs nə də, <<Oò, Tà, mo Devìd, koksə-a manziŋ bohòmʉ̀ ɛ̀. Yòŋsə̀ ze' tse' mo àm mòk nə̀ yi nə̀ ŋwàŋwè vɛ'ɛ nsàp nə̀bʉp.>> Ŋwà ènə à sə cèp bum yè'sə vɛ'nə ŋga yi ka ŋwà Jus yeŋ, yi à ye ŋwà lak Kanà. ");
INSERT INTO yam_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yi à sə cèp yè'sə pwe'fo', Jisòs kà cù bohònà' mùk lok. Ŋgàa fàak Jisòs sə wèŋ kə lɛŋ Jisòs də a bə̀boŋ co nà' dʉk ŋwà ènə lo bʉ̀ʉsə̀ nà' sə loksə kɛ'cà wo ntu' wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jisòs nə cèp bwìŋ ye kə də, <<Nwì à tumsə mègù mʉ bohòbʉ̀ʉ Izùrɛ sə̀ wo co nsùŋgaaŋ sə̀ wo a jàm bisə jàmə.>> ");
INSERT INTO yam_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ŋwà nə à və̀ kə̀ təəŋ mali kə̀ mantombìi Jisòs bə tumfərə, nə sə cep də, <<Tà tɛsə mʉ.>> ");
INSERT INTO yam_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisòs cep fe'lə sə̀mok də, <<Ka bə̀boŋ ŋgòjə bɛŋ mwe, nə mak fa ŋgbʉ yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ŋwà nə də, <<Tà, wù rì yo sə̀' də wo fagə̀ bwe bɛŋ, ŋgbʉ sə te'e sə̀ yà' sə gbʉ̀ tsoŋ sə nze sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Fana Jisòs dʉk fa bwi nà' də, <<Kɛ', ŋwà nè'e wù tse' dzədzəm sə ntʉʉ̀ wù vɛ'ɛ wùriŋ. Yusə̀ wù dzəm tse' yà'sə, yà'a nə ye mʉmvə̀'nə̀ wù lɛŋ sə.>> Ànə geŋ yiya mo ŋwà nə à mè mègù sə̀' ghà nà'nə vɛ'ɛ ghes. ");
INSERT INTO yam_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisòs à yè'e mè'rə fa'nə, nə sə gihi ca ŋgʉ ndzəp Galìli. Yi à lò, nə kə kok lo mʉmvwe' nda mòk, nə cum mbwa nze ŋgòyə'rə bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bwìŋ à kpəəŋ və̀ fo' ŋgòkə̀ yə yi vɛ'ɛ sə̀' wùriŋ. Wo à bə̀hə jə və̀ fa yi bʉ̀ʉ sə̀ wo kà gìgə̀ wèŋ, sə̀ wo à kpʉ sa' ni' ma mòk wèŋ, ŋgàa jì lis bə sə̀ wo kà cù cèpgə̀ wèŋ, nə ye bə ŋgàa yiyaŋ zəzok ŋkʉ̀ʉŋntɛ̀ŋ. Wo à bə̀hə jə və̀ yà' vɛ'nə, nə kə təmsə noŋsə ŋgʉ ni'ì Jisòs anə bìkìkìkì. Yi à gʉŋsə yà'wèŋ sə̀' lòoŋ. ");
INSERT INTO yam_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bʉ̀ʉ sə̀ wo à kə̀ mà fo' sə à mərə vɛ'ɛ wùriŋ. Wo à mərə bʉ̀ʉsə̀ wo yə ŋga bʉ̀ʉ sə̀ wo à sə kà cù cèpgə̀ wèŋ cèp cù, sə̀ wo à kpʉ sa' ni' ma mòk wèŋ gʉŋ fe'lə sə̀', sə̀ wo à sə kà gìgə̀ wèŋ gi fe'lə, nə ye bə sə̀ jì lis wèŋ sə ye fe'lə bum sə̀mok. Bʉ̀ʉ sə wèŋ à kùksə liŋ Nwì bʉ̀ʉ Izùrɛ wèŋ bʉ̀ʉ bum sə̀ wo à yə yè'sə. ");
INSERT INTO yam_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Anə geŋ Jisòs to benə ŋgàa fàak ye sə wèŋ ŋgʉ ni'ì yi, nə dʉk fa wo də, <<Manziŋ sə ko mʉ bohòbʉ̀ʉ yè'e cɛ̀bʉ̀ə̀, bʉ̀ʉsə̀ wo cu vesiwèŋ ntinə nùumbu tɛ', nə kà yumok zʉ. Mʉ̀ ka sə̀' dzəm co mʉ̀ dʉk də wo lo njè vɛ'nə sə̀' dzəm, bʉ̀ʉsə̀ aco mòk kə gbʉ njè mandzə̀.>> ");
INSERT INTO yam_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ŋgàa fàak ye sə wèŋ à yuk vɛ'nə, wo fek yi də, <<Aco wo jəŋ bɛŋ ŋgòŋ fɛɛŋ fòco a fa bwìŋ wùriŋ vɛ'ɛ nɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Fana Jisòs fek yà'wèŋ də, yà'wèŋ tse' ntuhu brɛd fa'nə sʉ̀ nɛ? Wo də, <<Vès tse' mègù ntuk sàmba bə bəbwe fuk mok.>> ");
INSERT INTO yam_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Fana Jisòs dʉk fa bʉ̀ʉ sə pwe'fo' də yà'a cum nze. ");
INSERT INTO yam_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yi jəŋ ntuhu brɛd sə̀ sàmba bə fuk sə, nə kotse' yà'. Yi kwasə wes Nwì fana yi bə'rə yà', nə sə fa bohòŋgàa fàak ye sə wèŋ. Wo jəŋ, nə sə fa bwi bʉ̀ʉ sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bʉ̀ʉ sə pwe'fo' à zʉ, nə ze' vɛ'ɛ bə̀boŋ. Wo à te'e benə mfə̀mfòok sə̀ yà' à sə gbʉ̀ sə nze ghà nə̀ wo à sə zʉ sə kwès sàmba. ");
INSERT INTO yam_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bʉ̀ʉ sə̀ wo à zʉ sə à ye bwìŋ ncùhù kwè, wù kà bə̀ba bə bweŋke' wèŋ ta. ");
INSERT INTO yam_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yi ànə gʉ wes bʉ̀ʉ sə wèŋ sam lo fana yi ni fe'lə sə ŋgwesə̀, nə lo yuye mvwe' nzeŋgòŋ lak Màgadàn. ");
INSERT INTO yam_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nùmbu mòk à ye, bʉ̀ʉ Faràsi mok nə ye bʉ̀ʉ Sadusì wèŋ à və̀ də wo kə mumsə ja'a Jisòs. Wo fek yi də nà'a gʉ niŋtsok fa wo maŋgəŋgèŋ mòk nə̀ aco nà' niŋ fa wo də yi tse' ŋàaŋ Nwì. ");
INSERT INTO yam_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Yi dʉk fa yà'wèŋ dʉk də, <<Wèŋ rì mègù ŋgòkʉ̀k gèsə lo mʉbu, nə riŋ də anə ye ŋga'a vɛ'ɛ bə vɛ'ɛ wèŋ. Wèeŋ tesə zəzòŋ nə ye ŋga ntòbu bə̀baŋ fana wèŋ də anə ye ntinə bʉp. Nə̀ nconùum ye ŋga ntòbu bʉ̀ʉŋ bə̀baŋ, wèŋ də anə ye zòŋ bə̀boŋ. Wèŋ riŋ yà'sə, nə kà bum sə̀ yà'a co mvə̀k ŋgònìtsə̀' bum sə̀ niè' riŋ bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wèŋ sə̀ niè' yè'sə, wèeŋ bʉ̀ʉ sə̀ bʉp, ŋgàa kà Nwì rì wèŋ. Wèŋ dʉk mʉ də mʉ gʉ niŋ fa weŋ maŋgəŋgèŋ è? Kàcò. Mʉ nə kà nà' gʉ̀. Maŋgəŋgèŋ nə̀ wèeŋ nə ye mègù nə̀ co à ye bohòŋgà tsòhòbum Nwì nə̀ liŋ yee Jonà nà'a.>> Yi ànə cep wes vɛ'nə, fana yi me'rə yà'wèŋ, nə lo gɛsə yuye. ");
INSERT INTO yam_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bə ŋgàa fàak ye wèŋ à to tesə lònto ndzəp ma nja fana ŋga ŋgàa fàak ye sə swì ŋgòjə tse' lòbrɛd. ");
INSERT INTO yam_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisòs dʉk fa wo də, <<Wèeŋ jəŋ ŋkərə̀ bə nsàap yis bʉ̀ʉ Faràsi bə bʉ̀ʉ Sadusì wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ànə geŋ wo sə cep kɛ' mʉtsətsə'rə̀ə wo anə dʉk də yi dʉk vɛ'nə bʉ̀ʉsə̀ a swì ŋgòjə tse' və̀ brɛd. ");
INSERT INTO yam_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisòs riŋ yusə̀ wo sə cèp sə, nə dʉk fa yà'wèŋ də, <<Kɛ' àmaa, wèŋ ka dzədzəm bə yusə̀ mʉ̀ sə gʉ̀ʉ tse'. Wèŋ sə cèp kɛ' də wèŋ swì ŋgòjə tse' brɛd yè'sə bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Co wèŋ ka yè'e ntòsə̀' rɛɛŋ geŋ nà? Co wèŋ sə kà mvə̀'nə̀ mʉ̀ à fa bwìŋ ncùhù tàŋ ntuhu brɛd sə̀' tàŋ yà'a mok tsərə à? Wo à zʉ yà' vɛ'nə, wèŋ te'e benə fe'lə sə̀ sə nze kwès sʉ̀ nɛ? ");
INSERT INTO yam_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nə ye sə̀' də wèŋ swì ntuhu brɛd sə̀ sàmba sə̀ bwìŋ ncùhù kwè à zʉ yà'a sə̀' ɛ̀? Wo à zʉ wes, wèŋ te'e benə sə̀ sə nze kwès sʉ̀ nɛ? ");
INSERT INTO yam_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Anə gʉ va ŋkuŋ mʉ cèep, wèŋ kà rì də mʉ̀ sə kà yè'sə brɛd nə̀ brɛd nè'e dʉk ɛ? Yusə̀ mʉ̀ sə dʉk sə də, wèeŋ jəŋ ŋkərə̀ bə yis bʉ̀ʉ Faràsi bə bʉ̀ʉ Sadusì wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ànə geŋ fana bwe ye sə wèŋ rɛɛŋ də yi anə sə ka yà'wèŋ də wo jəŋ ŋkərə̀ bə yis sə̀ wo gʉ̀gə̀ brɛd bə zeŋ yè'e dʉk. Wo riŋ də yi anə sə cep yà'sə də wo jəŋ ŋkərə̀ bə bum sə̀ bʉ̀ʉ Faràsi bə bʉ̀ʉ Sadusì wèŋ sə yə'rə fa bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisòs à kə̀ dzèŋ nzeŋgòŋ Sìsàriyà Filìpi fana yi fek ŋgàa fàak ye sə wèŋ də, <<Bwìiŋ dʉkgə̀ də mʉ̀, mo ŋwè, mʉ yè'sə ndà?>> ");
INSERT INTO yam_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wo sə dʉk fa yi də, <<Mok dʉkgə̀ də wu Jon ŋgà bàptɛsə̀ bwìŋ, mok də wu Àlajà, mok də a Jèrèmiyà kè ŋgà tsòhòbum Nwì mòk nə̀ yi à ye fa' àlɛ'.>> ");
INSERT INTO yam_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Fana yi fek mali wo sə̀' də, <<Wèŋ yàwèŋ nɛ? Wèeŋ dʉkgə̀ yàwèŋ də mʉ yè'sə ndà?>> ");
INSERT INTO yam_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimʉ̀ Pità dʉk də, <<Wu Ŋkum ŋgà gèm bwìŋ, nə̀ wo à dʉk nə, nə̀ wu mo Nwì nə̀ yi cu ŋwəm nə.>> ");
INSERT INTO yam_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Fana Jisòs nə dʉk fəsə fa nà' də, <<Rɛŋsi yòSaimʉ̀ mo Jonà. Bʉsə̀ ka wu yè'sə ŋwè tsok fa. Tsə̀' fa wu yà' Tɛ̀' am nə̀ yi cu mʉbu. ");
INSERT INTO yam_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nə ye sə̀' də mʉ̀ sə to fa wu liŋ ŋga'a də Pità (lìs), mʉ nə ci cos àm mʉmvwe' lìs ènə. Ŋàaŋ kpʉ nə kà cos àm nə yumok gʉ̀. ");
INSERT INTO yam_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mʉ nə fa wu ki ncùu gaŋ sə̀ Nwì sə. Yusə̀ wù kì tes yà' sə nze fɛɛŋ nə ye megu mʉbu sə̀' vɛ'nə. Yusə̀ wù fìrə me'rə yà' sə nze nə ye mʉbu sə̀' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Fana yi tipsə ŋgàa fàak ye sə wèŋ vɛ'ɛ gʉgʉŋ də yà'a kà ŋwə̀ nəmòk də yi yè'e ŋkum ŋgà gèm bwìŋ nə̀ wo à dʉk nə tsə̀' fa lok. ");
INSERT INTO yam_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","À yè jə mvə̀k ànə nə lo mantombì, Jisòs yeto ŋgòtsòhòfa ŋgàa fàak ye sə wèŋ jəja də yi nə lo tsoŋ li mvwe' lak Jòrosalèm, nə kə ye ŋgə' fo' wùriŋ. Yi nə ye ŋgə' nə ndzə bohòbʉ̀ ŋkwàha bʉ̀ʉ sə̀ fo' bə ŋgàa fa satikà' sə̀ ghaŋ wèŋ bə ŋgàa yə'rə̀ fa bwìŋ lʉ̀k. Də wo nə zə yi sə̀'. Nùmbu nə̀ tɛ' ye, yi lokok fe'lə mvwe' kpʉ sə̀mok. ");
INSERT INTO yam_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yi ànə dʉk vɛ'nə, Pità ko soŋsə gɛsə lo yi fo', nə sə jwa nà'. Pità nə sə dʉk də, <<Kaco Nwì dzəm yeŋ Tà! Kaco yè'sə ye lok fʉk bohòwù vɛ'nə yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yi bʉʉŋ, nə dʉk fa Pità nə də, <<Coho gɛsə ŋgʉ ni'ì mʉ̀ wùu Satà! Wu yà'sə nsàp yumòk nə̀ nà' sə təhə lok mʉ mandzə̀, bʉ̀ʉsə̀ yusə̀ wù cèp yà'sə, a tsətsərə̀ nə̀ bwìŋ tse' nà' wo, ka nə̀ Nwì yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Fana Jisòs tsok fa ŋgàa fàak ye sə wèŋ də, a ye-a ŋga ŋwə̀ nəmòk dzəm-a ŋgòyù lòyi fana nà'a nə bɛŋ to ntòbum sə̀ ni' nà' sə dzəm yà', nə bək jəŋ ntə̀əŋ nà' ŋkuŋ nə bɛ' lo yi. ");
INSERT INTO yam_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yi də, <<Bʉsə̀ ŋwə̀ nə̀ yi gəhə tse'-a yòŋsə̀ ye fana nà'a nə bisə wà. Nə ye də ŋwə̀ nə̀ yi jə yòŋsə̀ ye co yusə̀ wà bʉ̀ʉ mʉ̀ fana yi nə kə tse' nà'. ");
INSERT INTO yam_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bʉsə̀ swe'e sə̀ ŋwèe nə tse' sə yè'sə yà, ŋga yi tse'-a nzeŋgòŋ nə pwe'fo', nə kə bisə yòŋsə̀ ye ɛ? Kènə yusə̀ aco ŋwè kupsə yà', yà' kʉrə bə yòŋsə̀ ye yè'sə yu yà? ");
INSERT INTO yam_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bʉsə̀ mʉ̀ nə̀ mʉ mo ŋwè, ves masinjàa am wèeŋ nə̀ və̀ bə ŋàaŋ Tɛ̀' am, nə lak ndàaŋwè pwe'fo' mvə̀'nə̀ yi à gʉ̀ fàak ye. ");
INSERT INTO yam_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mʉ̀ sə tsə̀' weŋ yè'e zìnə də bʉ̀ʉ mok wèŋ tə fɛnə sə̀ wo nə kà ntòkpʉ ŋga wo yə mʉ̀ʉ mo ŋwè mvə̀'nə̀ mʉ̀ sə və̀ bə gaŋ ŋkum am sə.>> ");
INSERT INTO yam_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","À cà nùumbu ntùŋfu fana Jisòs to jəŋ Pità bə Jem nə ye Jon nə̀ yi moma Jem nə, bə yà'wèŋ kok lo mʉmvwe' nda mòk nə̀ sə̀sap. Wo à kə̀ cu mègù mbwa woòwo. ");
INSERT INTO yam_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Fana wo ye ŋga nsəsə̀ə Jisòs kupsə bʉʉŋ mok nsàp nə̀ zok. Si ye sə rɛŋ co nùm, cə̀k ye sə rɛŋ co marɛŋ vɛ'ɛ. ");
INSERT INTO yam_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wo ye fe'lə sə̀' ŋga Musì bə Àlajà tesə və̀ mʉbu, nə sə taaŋgàm bə Jisòs nə wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Fana Pità nə dʉk fa Jisòs də, <<Tà, yà' bòvɛ'ɛ wùriŋ mvə̀'nə̀ vesùwèeŋ fɛŋ yè'sə. A ye-a ŋga wù dzəm fana mʉ̀ ci ba'rə tes bwe duŋ fɛŋ tɛ'. Mò'fis nə̀ njò, mòk nə̀ Musì, mòk ye nə̀ Àlajà.>> ");
INSERT INTO yam_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yi ànə sə cep mali ntòfo' fana mbàk mòk nə̀ nà' sə fop vɛ'ɛ wùriŋ à və̀, nə kə təhə lok wo. Wo yuk ŋga ŋgì ŋwə̀ nəmòk sə cep vesə ndzənə mbàk nə də, <<Nè'e mo àm nə̀ mʉ̀ dzəm yi sə ntʉʉ̀ mʉ̀, mʉ kwagə̀ bohòyi wùriŋ. Yusə̀ yi cèp pwe', wèeŋ yuk fa yi.>> ");
INSERT INTO yam_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ŋgàa fàak ye sə wèŋ ànə yuk vɛ'nə fana wʉə ko wo vɛ'ɛ nsàp nə̀ co wù kà cèp to. Wo coho gbʉ fə'ə gesə lo si awo ma sə nze wo pwe'. ");
INSERT INTO yam_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisòs və, nə kə jwɛŋ wo bə bo ye. Yi dʉk fa wo də, <<Wèeŋ kà wəp, wèeŋ lokok mʉtsə̀.>> ");
INSERT INTO yam_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wo à mùk kok lis awo, wo kà ŋwè fo' mok yə. Wo ye megu Jisòs yiìyi. ");
INSERT INTO yam_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mvə̀'nə̀ wo à sə tsə mʉndahà anə fana Jisòs tipsə wo də, <<Wèeŋ kà ŋwə̀ nəmòk bum sə̀ wèŋ yə yè'sə tsə̀' tə̀tè ŋga mʉ̀ʉ mo ŋwè, mʉ̀ lòkok mvwe' kpʉ ŋkuŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ŋgàa fàak ye sə wèŋ à fek yi sə̀' də, <<Njo nə̀ ŋgàa yə'rə̀ fa bwìŋ lʉ̀k wèŋ sə dʉk də Àlajàa nə və tsoŋ ŋkuŋ Krɛst və ŋgòtɛsə ves, a bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yi dʉk fəsə fa yà'wèŋ də, <<A zìnə də Àlajàa nə və. Yi nə və ŋgògʉ̀hʉ tsə'rə fəsə bum pwe'. ");
INSERT INTO yam_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nə ye də mʉ̀ sə tsə̀' weŋ də Àlajà nə à və̀ laŋ, fana wo kà yi rì. Wo à jə yi, nə gʉ yi mvə̀'nə̀ wo dzəm. Nə ye sə̀' də mʉ̀ʉ mo ŋwè, mʉ nə ye ŋgə' ndzə bohòwo sə̀' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ànə geŋ bwe ye sə wèŋ rɛɛŋ bə zeŋ də yi sə dʉk Jon ŋgà bàptɛsə̀ bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wo ànə bwi foho və mvwe' sə̀ bwìŋ à mà cu sə fana ŋwə̀ nəmòk caŋ və bohòyi, nə kə təəŋ fo' bə tumfərə. Ŋwə̀ nə sə cep də, ");
INSERT INTO yam_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","<<Tà, koksə-a manziŋ bohòmo àm ɛ̀. Mo àm nə ŋgà gbʉ̀ nə̀nò'. Yi sə yə ŋgə' bə zeŋ vɛ'ɛ wù kà fʉ̀'. Yi gbʉ̀ yisko'gə̀ mʉ misə̀ riŋ riŋ, nə sə gbʉ ni sə ndzəpə̀ sə̀' riŋ riŋ. ");
INSERT INTO yam_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mʉ̀ jə lòyi bohòŋgàa fàak yo, nà' ghak ŋàŋ mvə̀'nə̀ co wo gʉ nà' me.>> ");
INSERT INTO yam_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisòs ànə yuk vɛ'nə, yi cep də, <<Wèeŋ yè'sə gʉgʉtu, wèŋ ka dzədzəm nə̀ co wèŋ luŋsə ŋwè fo' sə ntʉʉ̀ wèŋ tse'. Mʉ nə cum geŋ vesùwèŋ, nə sə ko ntʉm vɛ'nə tə̀tè kə dzeŋ sè? Wèeŋ jəŋ və fa mʉ yi fɛn.>> ");
INSERT INTO yam_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisòs jwa yòŋsə̀ ze' nə̀ nà' a sə gʉ̀ ŋkuŋ yi sə yaŋ nə fana nà' tesə gɛsə lo ndzə ni'ì yi anə sə̀' ghà ànə. ");
INSERT INTO yam_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ànə geŋ ŋgàa fàak Jisòs sə lo, nə kə fek swihi yi də, <<Vès anə fis fʉk yàvès nà' bʉ̀ə̀ yè'sə bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yi dʉk fa yà'wèŋ də, <<A bʉ̀ʉsə̀ dzədzəm àwèŋ nə̀ ŋgòlùŋsə bwìŋ bə zeŋ nə, nà'a jo. Mʉ̀ sə tsə̀' weŋ sə̀' də a ye-a ŋga wèŋ tse' mègù-a mʉdzədzəm momjo co mvə̀m nzaŋ vɛ'ɛ fana aco wù dʉk fa nda nè'e də, <Coho fa'nə, nə kə təəŋ fa'>, nà' coho lo. Yumok kà sə̀ co wèŋ kà yà' gʉ̀ to mok ye.  ");
INSERT INTO yam_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Aco bɛ'fis to megu nsàp ènə pìriyà bə dzə̀ zʉzʉ ba bwɛ̀rɛ yumok ka mok ye fe'lə.>> ");
INSERT INTO yam_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wo sə kɛ' kɛ'ca nzeŋgòŋ Galìli anə. Ànə geŋ wo və mvwe' mò'fis fana Jisòs dʉk fa bwe ye sə wèŋ dʉk də, <<Wo nə jəŋ mʉ̀ʉ mo ŋwè, nə fa ndzə bohòbwìŋ. ");
INSERT INTO yam_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Wo nə zə mʉ, nùmbu nə̀ tɛ' dzèeŋ, mʉ̀ tesə fe'lə və mvwe' kpʉ sə sə̀mok.>> Bwe ye sə wèŋ ànə yuk vɛ'nə fana manziŋ ko wo vɛ'ɛ nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisòs bə bwe ye sə wèŋ à kə̀ dzèŋ mvwe' lak Kàpanùm, nə cum fo'. Nùmbu mòk à ye bʉ̀ʉ sə̀ wo jəgə̀ mbàam tas sə̀ bwìiŋ là'gə̀ yà' mʉmvwe' ndap Nwì nə̀ ghaŋ nə wèŋ kə fek Pità də, <<Masà àwèŋ nè'e là'gə̀ mbàam yè'sə sə̀ laŋ à?>> ");
INSERT INTO yam_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yi dzəm də, <<Ŋ̀, nà'a là'gə̀ə.>> Ànə geŋ yi bwi lo yuye nda'à wo. À kə̀ dzèeŋ ŋga yi ka yumok ntòcep lok fana Jisòs fek nà' də, <<Wù tsəm yòyè'sə da Pità? Ŋkəŋkum sə̀ sə nze fɛɛŋ ko jəgə̀ mbàam tas awo yè'sə bohòndà wèŋ? Wo jəgə̀ yà' bohòbwe awo kè bohòbʉ̀ʉ sə̀ zok wèŋ nɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Yi dʉk də a yegə̀ bohòbʉ̀ʉ sə̀ yà'wèŋ ka bwe awo yeŋ. Fana Jisòs cep fe'lə sə̀' də, <<Ye də bwe awo ka yàwo nzak tse', ka vɛ'nə yeŋ nà? ");
INSERT INTO yam_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nə yeè nə də ŋgògʉ̀ də ya wo kà jòk fana dù sə mantùŋ. Wu kə̀ dzèŋ ca, wù mak gesə lop sə ndzəpə̀ anə. Fuk nə̀ wu ko to nà' mantombì, wu nə ye mbàm mʉ cùhù yi anə. Wù fis jəŋ mbàm nə, nə kə fa wo ŋgòlà' tiŋ tu yòbə sə̀ yàm bə zeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mvə̀k ànə à ye fana ŋgàa fàak Jisòs sə wèŋ və bohòyi, nə sə fek nà' də, <<Mvə̀'nə̀ gaŋ sə̀ mʉbu cu, nsàp ŋwə̀ nə̀ yi yam gha' mok fo' mantombìi Nwì yi yè'sə ndà lɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jisòs to və mo nəmòk, nə tes nà' mʉtsətsə'rə̀ə yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Fana yi tsok fa yà'wèŋ də, <<Mʉ̀ sə tsə̀' weŋ yè'e zìnə də tse'ŋga wèŋ kupsə, nə ye co bəbweŋke' ŋkuŋ bwɛ̀rɛ wèŋ kà mvwe' gaŋ sə̀ Nwì sə kə̀ ni yuk. ");
INSERT INTO yam_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ŋwə̀ nə̀ yi jə lo-a ni' ye sə nze co mo nè'e fana nà'a yi nə̀ yi yam càsə mok wèŋ mvwe' gaŋ sə̀ Nwì sə yi. ");
INSERT INTO yam_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ŋwə̀ nə̀ yi jə-a nsàp mo nə̀ co nè'nə mʉnə liŋ am fana ye də yi jə yà'sə mʉ̀. ");
INSERT INTO yam_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","<<Nə ye sə̀' də a ye-a ŋga ŋwə̀ mòk gʉ̀ bəbwe sə̀ wo dzəm bohòmʉ̀ yè'sə mòk də yi gʉ bʉp fana boŋ ghak bohòyi co wo jəŋ ŋgòk, nə swi' kə'ə fa ŋwə̀ ànə nà' kə̀ mìhi, nə mak gesə lo yi sə mvwe' ndzəp nə̀ cəco. ");
INSERT INTO yam_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bʉ̀ʉ sə̀ sənə nzeŋgòŋ nə cu bə ŋgə' njo nə̀ mə̀mumsə̀ə sə̀ aco yà' gʉ ŋwè ŋgògʉ̀ bʉp yè'sə cu fo'. Mə̀mumsə̀ə nə və tsooŋ li, megu də a ŋgə' nə̀ bʉp bohòŋwə̀ nə̀ yi sə jə və̀ mə̀mumsə̀ nə. ");
INSERT INTO yam_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nə ye sə̀' də a ye-a ŋga bo yo kè kùu yo àlɛ' sə gʉ̀ wu ŋgògʉ̀ bʉp fana wù gwɛ' tiŋ mak yà'. Bòghak də wu kə ni lak lùŋ bə bo kè kù ma mò'fis nə noŋsə nə̀ ŋgòkə̀ mà' gesə lòwu sənə mis sə̀ yà'a kà liìŋgə̀ bə bo kè kù ma ba fo'. ");
INSERT INTO yam_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nə ye də a ye-a ŋga lis yo sə gʉ̀ wu, wù sə gʉ bʉp fana wù so'rə fis mak yà'. Bòghak co wù kə ni mvwe' lùŋ bə lis ma mò'fis nə noŋsə ŋgòkə̀ ni mvwe' ŋgə' nə̀ sə misə̀ bə lis ma ba fo'. ");
INSERT INTO yam_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","<<Wèeŋ jəŋ ŋkərə̀ də wèeŋ kà bəbweŋke' yè'e wèŋ nə̀ mò'fis co yusə̀ wà jə. Mʉ̀ sə tsə̀' weŋ də mvə̀'nə̀ yà' cu mʉbu, masinjàa bəbweŋke' yè'sə wèeŋ cugə̀ bə Tɛ̀' am wèŋ mvwe' mò'fis nùumbu pwe'fo'.  ");
INSERT INTO yam_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mʉ̀ʉ mo ŋwè, mʉ̀ à və̀ ŋgòkə̀ làp yə bʉ̀ʉ sə̀ wo à bisə. ");
INSERT INTO yam_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","A ye-a wù, wù dʉk bə ncèp nè'e də yà? A ye-a ŋga ŋwə̀ nəmòk tse'-a nsùŋgaaŋ ye ŋkʉ̀ mò'fis, fana nə̀ mò'fis jam bisə ca, yi nə lap lo nə̀ mò'fis, nə me'rə sə̀ hum və̀ke'-ncòp-və̀ke' sə də yà'a sə zʉ tse' ŋgaŋ mʉndahà, ka vɛ'nə ye à? ");
INSERT INTO yam_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nə ye də, a ye-a ŋga yi kə̀ làp yə nà', mʉ tsok weŋ də yi nə kwa ghak bə zeŋ nə noŋsə sə̀ hum və̀ke' ncòp sə̀' və̀ke' sə̀ yà' ka yàwo bisə sə. ");
INSERT INTO yam_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ye də wèeŋ riŋ də tɛ̀' am nə̀ mʉbu nə sə kà dzəm də mʉmweŋke' nə̀ mò'fis bisə dzəm. ");
INSERT INTO yam_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","<<A ye-a ŋga moma yo mòk gʉ̀ wu bʉp, wù lo bohòyi, wenə ye ba, wù tsok fa yi yusə̀ yà' yaaŋ wu wenə sə. A ye-a ŋga yi dzəm yusə̀ wù tsə̀' yi sə, ye də wù ko fəsə və̀ moma yo nə ma ŋkwɛ̀ŋ laŋ. ");
INSERT INTO yam_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A ye-a ŋga yi ka wu njònə yuk fa, wù to jəŋ fe'lə lo ŋwə̀ nəmòk kè bwìŋ ba àlɛ' sə̀mok. Ya yusə̀ wù sə cèp pwe', bʉ̀ʉ yè'sə wèeŋ nə ye yàwo ŋgàa yuk ntu' ŋgòdə wo à yuk yàwo vɛ'ɛ bə vɛ'ɛ. ");
INSERT INTO yam_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A ye-a ŋga yi ka yà'wèŋ sə̀' yuk fa, wu jəŋ lo nzak nə mok mantombìi cos. A ye-a ŋga cos cèep, yi kà sə̀' dzəm malì fana wèŋ jəŋ yi mok co yi pegè kè co ŋgà ko mbàm tas àlɛ'. ");
INSERT INTO yam_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mʉ̀ sə tsə̀' weŋ yè'e zìnə də, a ye-a ŋga wèŋ kì-a yumok sə nze də yà' tə vɛ', wo nə kiŋ yà' mʉbu sə̀' vɛ'nə. Nə ye sə̀' də wèeŋ fìrə-a yumok sə nze, wo nə firə yà' mʉbu anə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mʉ̀ sə tsə̀' fa weŋ mòk sə̀' də a ye-a ŋga wèŋ ba dzəm tse' cù mò'fis bə yà lòoŋ, nə lɛŋ pìriyà bə zeŋ fana tɛ̀' am nə̀ yi cu mʉbu nə nə gʉ fa weŋ yà'. ");
INSERT INTO yam_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Njo nə̀ bwìŋ ba kè tɛ' àlɛ' kə̀ benə-a mvwe' mò'fis bʉ̀ʉ liŋ am fana mʉ nə ye mʉtsətsə'rə̀ə wo anə.>> ");
INSERT INTO yam_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ànə geŋ Pità kə fek Jisòs nə də, <<Tà, aco moma am gʉ mʉ bʉp kɛ̀' sʉ̀, mʉ̀ sə swifa yi-ɛ? Co kɛ̀' sàmba vɛ'ɛ àlɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisòs nə dʉk fa nà' də, <<Mʉ̀ ka də a kɛ̀' sàmba dʉk, a kɛ' hum sàmba bòp sàmba. ");
INSERT INTO yam_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Aco a fʉhʉ gaŋ sə̀ mʉbu sə bə ŋkum mòk nə̀ yi à dzəm də yi taŋ ja'a mbàam ye bə ŋgàa fàak ye ya yi riŋ mvə̀'nə̀ bwe fàak sə wèŋ sə gʉ̀ bə mbàam ye sə. ");
INSERT INTO yam_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yi à yèto ŋgòta ntɛ̀ŋ, wo ko jəŋ və fa yi mòk nə̀ yi tse' ŋkum nə malà' mbàm. ");
INSERT INTO yam_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mvə̀'nə̀ yi ànə ka mbàam sə̀ co yi lak tse' fana ŋkwà' ŋwə̀ ye nə dʉk də wo seŋ yi co ŋkwɛ̀ŋ. Wo seŋ nà' bə ŋgwe nà' nə ye bwe nà' bə bum nà' sə̀ nà' tse' pwe' ya wo lak ka nà' sə fo'. ");
INSERT INTO yam_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ŋgà fàk nə təəŋ tsoŋ sə nze bə tumfərə, nə wup fa ŋkwà' ŋwə̀ ye nə bo vɛ'ɛ wùriŋ. Yi lɛŋ nà' vɛ'ɛ də, <Tà, ko ntʉm, mʉ nə lak wes fa wu mbàam yo pwe', yumook nə kà bisə̀.> ");
INSERT INTO yam_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Manziŋ à ko ŋkwà' ŋwə̀ nə. Yi me'rə ŋgà fàk nə, nə swi fa nà' mbàam sə̀ nà' tse' yi sə. ");
INSERT INTO yam_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ŋgà fàk ànə à tesə tsə ntɛ̀ŋ, yi kʉrə bə ŋgà fàk mòk sə̀' co yi ŋga yi à sə bɛ' megu nà' mbàm ncùhù co tàŋ vɛ'ɛ. Yi tap ko ŋam pik tse' nà' kə̀ mìhi, nə sə dʉk də, <Lak fa mʉ mbàam am sə.> ");
INSERT INTO yam_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ŋgà fàk ènə gbʉ ye sə̀' sə nze, nə sə lɛŋ nà' də, <Kwəkwè', ko-a ntʉm, mʉ nə lak wes fa wu mbàam yo.> ");
INSERT INTO yam_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yi kà dzəm. Yi kə nisə nà' ndapndzəm də tse'ŋga nà' làk yi ŋkuŋ. ");
INSERT INTO yam_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ŋgàa fàak mok sə̀ a yegə̀ bə yà'wèŋ à yə yusə̀ yi gʉ̀ yè'sə fana yà' yaaŋ wo vɛ'ɛ wù kà fʉ̀'. Wo lo, nə kə tsok fa ŋkwà' ŋwə̀ àwo nə bum sə̀ yà' ye yè'sə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Anə geŋ ŋkwà' ŋwə̀ nə to yi və. Yi dʉk fa nà' də, <Wù mo nə̀ bʉp! Mʉ̀ a swìfa wu ka sə̀ wù tse' mʉ yà'a pwe'fo' bʉ̀ʉsə̀ wù a lɛŋ mʉ. ");
INSERT INTO yam_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nə ye də kaco wù koksə manziŋ bohòŋgà fàk mòk sə̀' mvə̀'nə̀ mʉ̀ gʉ̀ bohòwù yà'a yeŋ à?> ");
INSERT INTO yam_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mvə̀'nə̀ ntʉm à sə yaaŋ yi fana ŋkwà' ŋwə̀ ye nə à jə yi, nə fa sə̀' ndzə bohòŋgà yeŋsə bwìŋ ŋgə' də wo nisə nà' ndapndzəm, nə ye də tse'ŋga nà' làk wes fa yi mbàam ye sə sə̀' pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yà'a sə̀' mvə̀'nə̀ Tɛ̀' am nə̀ yi cu mʉbu nə gʉ bohòwèŋ sə̀' vɛ'nə, ŋga a ye-a də wù ka moma yo sə ntʉʉ̀ wù swifa na.>> ");
INSERT INTO yam_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ànə geŋ mvə̀'nə̀ Jisòs ànə cep wes bum yè'sə fana yi ye'e me'rə nzeŋgòŋ Galìli anə. Yi lo mvwe' nzeŋgòŋ Jùdiyà nə̀ nà'a ma ndzə ntondzəp Jòridàŋ. ");
INSERT INTO yam_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bwìŋ à yù lòyi fo' vɛ'ɛ nə̀bʉp, yi gʉ mesə fa wo yiyaŋ awo fo'. ");
INSERT INTO yam_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bʉ̀ʉ Faràsii mok wèŋ à və̀ kə̀ tsèŋ yi də ya wo mumsə ja'a yi. Wo fek yi də, <<Aco lʉ̀k dzəm də ŋwèe mè'rə ŋgwe ye bə njo nə̀ nà' bòyi, ye də yi ka yà'sə bʉp gʉ à?>> ");
INSERT INTO yam_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yi cep fəsə fa wo də, <<Wèŋ a ka mvəsə̀ wo à còm də Nwì ànə gʉ to ŋwè, yi gʉ ŋwə̀mbam bə ŋwàŋwè yà'a ntòtaŋ à? ");
INSERT INTO yam_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yi ànə gʉ wo vɛ'nə fana yi dʉk də, <Nà'a njo nə̀ ŋwèe nə me'rə tɛ̀' ye bə ma ye, nə kə be'lə bə ŋgwe ye. Wo sə̀ ba sə nə ye mok ŋgùpni' nə̀ mò'fis.> ");
INSERT INTO yam_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ye də wo ka mok ba yeŋ fe'lə, wo mok ŋgùpni' nə̀ mò'fis. Ye də yusə̀ Nwì a be'lə yà' mvwe' mò'fis fana ŋwə̀ nəmòk kà də yi gapsə yà' dʉk.>> ");
INSERT INTO yam_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wo fek fe'lə yi də, <<Ànə geŋ Musì nə dʉk də aco ŋwè com fa ŋwà nə ŋwàk nə̀ ŋgònìtsə̀' də yi mè'rə nà' laŋ nə me'rə yi lo ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yi dʉk fa fe'lə yà'wèŋ sə̀mok də, <<Musì à mè'rə də wèeŋ mè'rə yep awèŋ bʉ̀ʉsə̀ ntʉm awèŋ gʉ nə̀bʉp, bwɛ̀rɛ mvə̀'nə̀ yà' à yeto mantombì à ka vɛ'nə yeŋ yuk. ");
INSERT INTO yam_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mʉ̀ sə tsə̀' weŋ sə̀' də a ye-a ŋga ŋwè me'rə ŋgwe ye, ŋga yi ka nà' bʉ̀ʉ njo nə̀ də ŋwà nə sə ko nto me'rə, nə jəŋ fe'lə ŋwà mòk sə̀mok fana ye də yi yà'sə ŋgà ko nto.>> ");
INSERT INTO yam_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ŋgàa fàak ye wèŋ dʉk fa yi də, <<A ye-a ŋga nzak ŋgwe bə ndum mʉ mvə̀k ènə, ye də bòghak co ŋwè kà ŋwàŋwè jə lo'.>> ");
INSERT INTO yam_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yi dʉk fa fe'lə wo də, <<Kaco bwìŋ pwe' dzəm ncèp ènə yeŋ. Aco dzəm megu nà' bʉ̀ʉ sə̀ Nwì a fa wo ncèp nə yi. ");
INSERT INTO yam_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bwìŋ cu yo sə̀ wo à dzə wo ləm. Bwìŋ cu sə̀' yo sə̀ wo à ya' wo ŋkuŋ wo bʉʉŋ ləm. Mook sə̀' yo sə̀ wo bʉ̀sə ni' awo co ləm njo gaŋ ŋkum Nwì. Ŋwə̀ nə̀ yi rì də aco yi dzəm to ncèp ènə fana yi dzəm sə̀ ntɛ̀ŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ànə geŋ wo jəŋ və fa yi bəbweŋke' wèŋ də yi naaŋ fa yà' bo, nə gʉ pìriyà. Ŋgàa fàak ye wèŋ ànə ye vɛ'nə, wo jwa sa'rə bʉ̀ʉ sə də yà'a kà vɛ'nə gʉ̀. ");
INSERT INTO yam_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisòs dʉk də, <<Wèeŋ me'rə bəbweŋke' wèeŋ və bohòmʉ̀, nə kà wo mandzə̀ lok, bʉ̀ʉsə̀ gaŋ ŋkum sə̀ mʉbu sə, tse' yà' nsàap sə̀ co wo yè'sə.>> ");
INSERT INTO yam_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Fana yi naaŋ fa yà'wèŋ bo ye mʉ tuhù, nə se wo ŋkuŋ nə yè'e me'rə lo yuye. ");
INSERT INTO yam_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ŋwə̀ nəmòk və bohòJisòs, nə dʉk fa nà' də, <<Cicà, yusə̀ bə̀boŋ sə̀ co mʉ̀ gʉʉ yè'sə yà, ŋkuŋ ya mʉ nə kə tse' lùŋ nə̀ nà'a nə̀ kà mè ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yi dʉk fəsə fa nà' də, <<Wù sə fek mʉ yòyusə̀ bə̀boŋ sə fe'e nà? Ŋwə̀ nə̀ yi bə̀boŋ mègù nə̀ mò'fis. A ye-a ŋga wù dzəm də wu nə kə tse' lùŋ, wù noŋsə lʉ̀ʉk sə bə̀boŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yi fek mali Jisòs də, <<A yè'sə lʉ̀ʉk sə̀ fòlɛ-ò?>> Jisòs taŋ fa yi də, <<Kà ŋwè zə. Kà nto ko. Kà yə̀ yə̀. Kà gèem mvwès ko. ");
INSERT INTO yam_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wəp tɛ̀' yo bə ma yo, nə dzəm moma yo co mvə̀'nə̀ wu dzəmgə̀ ni' yò.>> ");
INSERT INTO yam_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mʉ wà'ŋwə̀ nə dʉk fa fe'lə nà' də, <<Bum sə̀ wù taŋsə yè'sə pwe', mʉ̀ a gʉ̀ wes yà' laŋ. Yusə̀ mʉ̀ ka yà' ntògʉʉ yè'sə yà?>> ");
INSERT INTO yam_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisòs dʉk fa nà' də <<A ye-a ŋga wù dzəm də wu ye kə̀kʉrə̀ pap, wù lo kə seŋ bum sə̀ wù tse', nə fa ŋgàa jìŋ mbàam sə ya wu nə tse' ghàk mʉbu, nə bɛ' mandzə̀ nə yuŋ və mʉ.>> ");
INSERT INTO yam_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wà'ŋwə̀ nə à yuk vɛ'nə, ŋgùpcù gbʉ yi yə̀k, yi coho lo, bʉ̀ʉsə̀ yi à tse' bum vɛ'ɛ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Fana Jisòs bʉʉŋ dʉk bohòŋgàa fàak ye wèŋ dʉk də, <<Mʉ̀ sə tsə̀' weŋ ŋkèm dʉk də, gʉ wùriŋ bohòŋgà ghàk ŋgòkə̀ ni mvwe' gaŋ Nwì. ");
INSERT INTO yam_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mʉ tsok weŋ sə̀' də joho cà bohònàm nə̀ yi yam co nàmbà'rə̀ nà'a ŋgòcà torə tesə ndzənə wʉ patà', nə noŋsə bohòŋgà ghàk ŋgòni mvwe' gaŋ ŋkum sə̀ mʉbu.>> ");
INSERT INTO yam_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ŋgàa fàak Jisòs sə à yuk vɛ'nə fana və̀m kok wesə wo nə̀bʉp. Wo fek də, <<Ye də aco ŋwə̀ nə̀ yi tse' to lùuŋ yè'sə ndà?>> ");
INSERT INTO yam_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisòs kʉk gesə yà'wèŋ, nə dʉk fa wo də, <<Aco yumok gʉŋ ghak li ŋwè, yumok kà Nwì-e gʉŋ ghak yuk.>> ");
INSERT INTO yam_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ànə geŋ Pità cep fəsə fa nà' də, <<Ja'a na yòo mʉmvə̀'nə̀ vès a mè'rə bum avès pwe' nə̀ pwe', nə bɛ' wu, yusə̀ vèes nə kə tse' sə yè'sə yu yà?>> ");
INSERT INTO yam_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisòs dʉk fa fe'lə wo sə̀' də, <<Mʉ̀ sə tsə̀' weŋ zìnə də, bə nzeŋgòŋ nə̀ fi nə̀ nà'a nə̀ kə̀ ye ntsə'mòk nə fana mʉ̀ʉ mo ŋwè, mʉ nə̀ kə̀ cu mʉnə kapràk àm co ŋkum nə̀ ghaŋ. Wèŋ sə̀ hum-ncòp-ba sə̀ wèŋ a bɛ' mʉ yè'e nə cum sə̀' mʉnə kapràak yàwèŋ. Fana wèŋ sə sak buhu lak Izùrɛ sə̀ hum-ncòp-ba sə. ");
INSERT INTO yam_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nə ye sə̀' də ndàaŋwè pwe' nə̀ yi a me'rə ndap ye, kè bwema ye, kè njɛ̀'ɛgùu ye, kè tɛ̀' ye, kè ma ye, kè bwe nə ye nzum àlɛ' pwe' bʉ̀ʉ liŋ am, yi nə̀ kə̀ tse' fe'lə kɛ̀' ŋkʉ̀ mò'fis. Kà yà'sə mègù, yi nə̀ kə̀ tse' lùŋ nə̀ nà'a nə̀ kà mè nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mvə̀k ànə ye, bwìŋ ŋkʉ̀ʉŋ sə̀ wo ŋga'a mantombìi nə ye mok maŋkwɛ̀ŋ, fana ŋkʉ̀ʉŋ sə̀ wo ŋga'a maŋkwɛ̀ɛŋ nə ye mantombì.>> ");
INSERT INTO yam_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisòs à cèp ncèp mòk də, <<Gaŋ sə̀ Nwì sə yà'a co ŋkwà' ŋwə̀ nəmòk nə̀ yi à yàaŋ tesə ntsə'mòk də yi lo kə lap ŋgàa fàk, ya wo fak mʉnzuù yi. ");
INSERT INTO yam_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yi ànə cep tes bə bʉ̀ʉ sə wèŋ mvə̀' mbàm nə̀ yi nə lak yà' nùmbu nə̀ mò'fis nə fana yi gesə lo yà' mʉnzuù yi anə. ");
INSERT INTO yam_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nùm à sə ye lòco nùm bɛŋ, yi lo nə kə ye fe'lə bʉ̀ʉ səmok, ŋga wo sə təəŋ dzòoŋ mʉ ntɛɛ̀ŋ wà. ");
INSERT INTO yam_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yi dʉk fa yà' də, <Wèeŋ du kə fak mʉ nzuù mʉ̀ sə̀' ya mʉ nə lak weŋ kə̀kʉrə̀.> Ànə geŋ wo lo fo' sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yi à tesə lòfe'lə ŋga nùum maràŋ, nə ye ŋga nùm càsə maràŋ sə̀', nə kə gʉ sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nùm à sə naaŋ lo bə cùu nda, yi lo, nə kə ye mali bʉ̀ʉ mok sə̀' ŋga wo sə təəŋ sə̀' wà anə. Yi fek yà'wèŋ də, <Wèŋ sə təəŋ càsə bʉpsə mvə̀k fɛɛŋ wà vɛ'nə bʉ̀ʉ yà?> ");
INSERT INTO yam_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wo dʉk fa yi də, <A bʉ̀ʉsə̀ ŋwə̀ nəmòk ka ves yumok də vèes gʉ fa.> Yi dʉk fa wo də, <Wèeŋ du kə fak mʉ nzuù mʉ̀ anə sə̀'.> ");
INSERT INTO yam_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nùm à co, yi dʉk fa ŋgà fàk ye nə̀ mantombì də, <To bʉ̀ʉ sə̀ wo fàk sə, nə lak wo. Làk yè jəŋ ŋwə̀ nə̀ yi və̀ lə̀sə maŋkwɛ̀ŋ, nə kə ləsə bə ŋwə̀ nə̀ yi anə və to.> ");
INSERT INTO yam_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bʉ̀ʉ sə̀ wo anə və ŋgòfàak ŋga nùm sə naaŋ lòbə cùu nda à və̀ə, wo lak wo mbàm nə̀ wo làkgə̀ ŋwè ŋga yi fàk yiskok nùmbu mò'fis. ");
INSERT INTO yam_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bʉ̀ʉ sə̀ wo à yèto ŋgòfàk wo sə wèŋ à və̀ə, wo sə tsəm də wo nə lak wo yàwo zok. Wo fa megu yà' sə̀' mvə̀'nə̀ wo làk bʉ̀ʉ mok sə. ");
INSERT INTO yam_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wo ànə jəŋ yà' fana wo ye ŋgòcèp ŋwəm kɛ'cà bə liŋ ŋkwà' ŋwə̀ nə. ");
INSERT INTO yam_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wo sə dʉk də, <Bʉ̀ʉ sə̀ wo və̀ lə̀sə tsə yàwo ŋga'a yè'e fàk mègù ghàr vɛ'ɛ, anə geŋ wù lak wo sə̀' yəyərə̀ bə vès sə̀ vès fàk yə yiskok ŋgə' bə nùm nə̀ nà' sə to barə bwìŋ nè'e.> ");
INSERT INTO yam_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yi dʉk fəsə fa mòk mʉtsətsə'rə̀ə wo anə də, <Ŋge' àm, mʉ̀ ka weŋ bʉp gʉ lok. Mbàm nə̀ mʉ̀ làk weŋ nə ka mvə̀'nə̀ anə cep tes sə yeŋ à? ");
INSERT INTO yam_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jəŋ mbàm yò, nə lo gəe'. Mʉ̀ dzəm mʉ̀ də mʉ fa bʉ̀ʉ sə̀ wo və̀ lə̀sə yè'e sə̀' mvə̀'nə̀ mʉ̀ fa wu. ");
INSERT INTO yam_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","A ye-a ŋga mʉ̀ tse' mbàam am, kaco mʉ̀ gʉ fo' mvə̀'nə̀ mʉ̀ dzəm yeŋ à? Kènə də ntʉm sə yaaŋ wu bʉ̀ʉsə̀ mʉ̀ sə fa bwìŋ mbo-ɛ?> >> ");
INSERT INTO yam_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Fana Jisòs ləsə ncèp nə də, <<Yà'a mvə̀'nə̀ bʉ̀ʉ sə̀ wo maŋkwɛ̀ɛŋ nə̀ kə̀ ye ntsə'mòk mantombì, sə̀ wo à ye mantombì kə ye mok maŋkwɛ̀ŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mvə̀'nə̀ Jisòs à sə kok lòmʉ Jòrosalèm fana yi jəŋ lo ŋgàa fàak ye sə̀ hum-ncòp-ba sə. À kə̀ dzèŋ mandzə̀, yi ləksə gesə yà' ŋgʉʉ̀ŋ jo, nə cep bohòwo də, ");
INSERT INTO yam_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Wèeŋ ye, mvə̀'nə̀ a sə lòmʉ Jòrosalèm yè'e, wo nə fa mʉ̀ʉ mo ŋwè ndzə bohòŋgàa fa satikà' sə̀ ghaŋ bə ŋgàa yə'rə̀ fa bwìŋ lʉ̀k wèŋ. Wo nə sak mʉ, nə dzəm tes də mʉ̀ mègù ŋgà kpʉ. ");
INSERT INTO yam_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wo nə fa mʉ ndzə bohòbʉ̀ lakmvum də ya wo ywi'lə mʉ, ləp mʉ, nə tɛ'lə mʉ mʉ ntə̀əŋ. Nùmbu nə̀ tɛ' dzèeŋ, mʉ̀ lokok mvwe' kpʉ.>> ");
INSERT INTO yam_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ànə geŋ, ma bwe Zebèdi wèŋ à və̀ bə bwe ye sə̀ wo ŋgàa fàak Jisòs ba, nə kə ye Jisòs nə. Yi kə təəŋ kə̀ mantombìi nà' bə tumfərə, nə də yi dzəm ŋgòlɛŋ yumok. ");
INSERT INTO yam_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Fana Jisòs fek ŋwà nə də yusə̀ nà' dzəm yàlɛ? Màmi nə də, <<Kàk fa mʉ-ɛ də ghà nə̀ wu nə̀ ye ŋkum, wu nə jəŋ bwe am sə̀ ba yè'e, nə cumsə mòk ma màk nə cumsə mòk ma ŋkwìip wù-ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisòs nə dʉk fa nà' də, <<Wù ka yusə̀ wù sə fek mʉ də mʉ gʉ yà'sə riŋ. Aco wèŋ ye to ŋgə' nə̀ mʉ nə ye nə à?>> Wo də, <<Ŋ̀, aco vès ye to ŋgə' nə.>> ");
INSERT INTO yam_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yi dʉk fa fe'lə yà'wèŋ də, <<A zìnə də wèeŋ nə ye. Yusə megu də, mʉ̀ ka ŋàaŋ sə̀ ŋgòswe' bʉ̀ʉ sə̀ wo nə cum mʉ ma màk bə ma ŋkwìp mʉ̀ tse'. Mvwe' ncum yà'sə sə̀ bʉ̀ʉ sə̀ Tɛ̀' àm a cok noŋsə wo yi.>> ");
INSERT INTO yam_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bwe ye mok sə̀ hum sə à yuk yu yè'sə fana wo jok bohòbwe ma sə̀ ba sə wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Fana Jisòs to benə və wo pwe', nə tsok wo də, <<Wèŋ rì də, ŋkəŋkum sə̀ wo tse' dzòk sə nzeŋgòŋ fɛɛŋ gʉ̀gə̀ bwìŋ ŋkʉ̀ì'. Bʉ̀ʉ sə̀ yà' tse' ŋàŋ mʉ tùhù wo sə niŋtsok fa wo ŋàŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yè'sə ka tse' ŋgòye bohòwèŋ yàwèŋ vɛ'nə yeŋ. Ŋwə̀ nə̀ yi dzəm-a ŋgòye ŋwə̀ nə̀ ŋkʉ̀ʉŋ mʉtsətsə'rə wèŋ fana yi tse' ŋgòfàk co mweŋke' bohòmok sə lòoŋ fo'. ");
INSERT INTO yam_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nə ye sə̀' də, ŋwə̀ nə̀ yi dzəm-a ŋgòye mantombì yi, yi tse' ŋgòye ŋkwɛ̀ŋ bohòwèŋ pwe'. ");
INSERT INTO yam_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bʉsə̀ mʉ̀ʉ mo ŋwè bə tu am, mʉ̀ à ka də bwìiŋ fak bohòmʉ̀ və. Mʉ̀ à və̀ ŋgòfàk fà'a, nə fa yòŋsə̀ àm ŋgòywiŋ fəsə jə yòŋsə̀ə bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wo à kə̀ dzèŋ Jèrikù nə də wo lo fana bwìŋ yuŋ və Jisòs vɛ'ɛ co wù kà cèp. ");
INSERT INTO yam_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Fana bʉ̀ ŋgàa jì lis mok ba à sə cu ŋgʉ mandzə̀. Wo yuk də Tà Jisòs sə cà yi. Wo waŋ torə fis də, <<Koksə-a manziŋ bohòvès-ɛ̀, mo Devìd!>> ");
INSERT INTO yam_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bʉ̀ʉ sə̀ wo à ye fo' sə wèŋ gham wo, də yà'a cum gəe'. Bʉ̀ʉ sə wèŋ torə ghaha co wo kwɛ'sə wo kə kwɛ'sə. Wo sə torə də, <<Tà, mo Devìd, koksə manziŋ bohòvès.>> ");
INSERT INTO yam_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ànə geŋ Jisòs foho təəŋ, nə to fek yà'wèŋ də, <<Yusə̀ wèŋ dzəm də mʉ gʉ fa weeŋ yè'sə yà?>> ");
INSERT INTO yam_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wo dʉk fa yi də, <<Tà, mùk fa mègù ves lis avès.>> ");
INSERT INTO yam_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Manziŋ à ko Jisòs, yi jwɛŋ lis awo sə bə bo ye. Lis awo sə muhu gu sə̀' ghà ànə, wo gi yuŋ lo Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Wo ànə sə kʉəp lo Jòrosalèm anə fana wo wɛs mvwe' lak Befà. A fo' mvwe' nda nə̀ wo togə̀ nà' də Nda Olìp. Fana Jisòs tumsə lo ŋgàa fàak ye ba. ");
INSERT INTO yam_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Yi tsok yà'wèŋ dʉk də, <<Wèeŋ du mvwe' lak sə̀ ndzə yà'a. Wèeŋ ni kok lòfo' ntɛ̀ŋ, wèŋ ye ŋga wo tsòoŋ tes mvomndè' mòk fo' bə mʉmo ye. Wèŋ fiŋ jəŋ və fa mʉ yà'. ");
INSERT INTO yam_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A ye-a ŋga ŋwə̀ nəmòk fek-a weŋ yumok, wèŋ dʉk yi də, <Tà dzəm də vèes jəŋ və fa yi yà'.> Wèeŋ dʉk-a vɛ'nə, yi nə me'rə weŋ sə̀ ntɛ̀ŋ də wèeŋ lo bə zeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yè'sə à ye vɛ'nə də ya bum sə̀ ŋgà tsòhòbum Nwì à cèp sə bʉʉŋ və zìnə. Yusə̀ yi à cèp sə də, ");
INSERT INTO yam_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Nwì a dʉk də, <<Tsòk fa bʉ̀ʉ sə̀ mvwe' ntòlak Zayòŋ wèŋ də, <Wèeŋ yeè, ŋkum awèŋ sə və̀ bohòweŋ. Yi jə ni' ye sə nze, nə kok cuù nə mʉnə mvomndè', mʉŋgwɛ̀ŋ mvomndè'.> >> ");
INSERT INTO yam_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Fana ŋgàa fàak sə wèŋ lo nə kə gʉ megu sə̀' mvə̀'nə̀ Jisòs ànə tsok wo sə. ");
INSERT INTO yam_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wo jəŋ və mvomndè' nə bə mʉmwe nə. Wo saŋ naaŋ cə̀ək awo mbwa fana yi kok cum mbwa. ");
INSERT INTO yam_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bwìŋ à və̀ ŋkʉ̀ʉŋntɛ̀ŋ, nə sə fweŋ saŋ lo cə̀ək awo sə mandzə̀. Mok wèŋ kə caŋ ci' və mvùu tʉ, nə sə noŋsə lo yà' sə mandzə̀ anə. ");
INSERT INTO yam_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bʉ̀ʉ sə̀ wo à ye mantombì bə maŋkwɛ̀ŋ wèŋ pwe'fo' à sə gùrə. Wo sə dʉk də, <<Hòsanà bohòmo Devìd! Nwìi se yi nə̀ yi və̀ mʉnə liŋ Tà. Hòsanà ye bohòNwì nə̀ yi yam càsə yà lòoŋ fo'.>> ");
INSERT INTO yam_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yi ànə kə ni mʉ ntòlak Jòrosalèm anə fana ntòlak nə curə wʉk. Wo sə fe'rə kɛ'ca də, <<Nè'nə yè'sə ndà?>> ");
INSERT INTO yam_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Fana ŋgo bʉ̀ nə̀ yi à və̀ bə yà'wèŋ nə sə dʉk də, <<Nè'e ŋgà tsòhòbum Nwì nə̀ liŋ yee Jisòs nə. Yi və̀ mvwe' lak Nazàrɛ nə̀ mvwe' nzeŋgòŋ Galìli.>> ");
INSERT INTO yam_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ànə geŋ, Jisòs lo, nə kə ni mʉmvwe' ntòmbi ndap Nwì nə̀ ghaŋ nə. Yi bɛ'fis bʉ̀ʉ sə̀ wo à sə sèŋ bum nə ye sə̀ wo à sə ywiŋ bum mbwa sə pwe'. Yi bwi' kɛ'mak teberə̀ə bʉ̀ʉ sə̀ wo à sə kupsə mbàam awo mbwa sə bə dzòok ŋgàa sèŋ kəkəbʉ̀ŋ wèŋ pwe'. ");
INSERT INTO yam_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yi dʉk fa yà' də, <<Wo à còm nòŋsə ndzənə ŋwàk Nwì sə kum ndap Nwì nə̀ ghaŋ ènə də, <Liŋ ndap àam nə ye də ndap pìriyà.> Fana wèŋ jə bʉsə nà' ndap ŋgàa yə̀ wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Anə geŋ, ŋgàa ləlohòlis bə sə̀ wo kà gìgə̀ wèŋ və kə tseŋ yi mʉ mvwe' ndap Nwì nə̀ ghaŋ nə, yi sə gʉŋsə yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ŋgàa yə'rə̀ fa bwìŋ lʉ̀k bə ŋgàa fa satikà' sə̀ ghaŋ wèŋ à yə nsàap bum maŋgəŋgèeŋ sə̀ yi à sə gʉ̀ʉ fana wo jok. Yusə̀ wo à jòk bʉ̀ʉ zeŋ, mòk à ye mvə̀'nə̀ bweŋke' wèŋ à sə fu fa yi mʉ nda'à Nwì nə̀ ghaŋ nə də, <<Hòsanàa ye bohòmo Devìd.>> ");
INSERT INTO yam_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Fana wo fek yi də, <<Wù sə yuk bum sə̀ bwe yè'e sə cèp sə̀ laŋ à?>> Jisòs dʉk fa wo də, <<Ŋ̀ mʉ̀ sə yuk. Wèŋ ka yusə̀ wo à còm də, <Nwì à fʉ̀hʉ cùu bweŋke' sə̀ wo sə no malì mbwi wèŋ ŋgòkwasə yi bə zeŋ> yà'a taŋ à?>> ");
INSERT INTO yam_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yi ànə me'rə wo fana yi tesə mʉ ntòlak anə, nə lo mvwe' lak Betanì, nə kə nooŋ fo'. ");
INSERT INTO yam_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tsok à rɛŋ, nə̀ zəzòŋ ŋga yi sə bwìŋ foho lòfe'lə mʉ ntòlak anə fana ye mok ŋga njè sə ya yi. ");
INSERT INTO yam_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yi à fəsə lis, nə ye tʉ mòk nə̀ wo togə̀ nà' də fik, ŋga nà' tə ŋgʉ mandzə̀. Yi geŋ fo', nə kə dzeŋ ŋga nà' tse' mègù mvù, nə kà zəm. Fana yi dʉk fa tʉ nə də, <<Wu nə kà mok zəm yuk.>> Yi ànə cep vɛ'nə ntɛ̀ŋ, tʉ nə yum sə̀ ghà ànə. ");
INSERT INTO yam_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ŋgàa fàak ye wèŋ à yə vɛ'nə fana wo mərə vɛ'ɛ wùriŋ də tʉ nə yum tsə mègù ghà nə yè'sə valɛ. ");
INSERT INTO yam_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisòs dʉk fa wo də, <<Mʉ̀ sə tsə̀' weŋ zìnə də a ye-a ŋga wèŋ tse' dzədzəm, nə kà sə mərə̀ kɛ', wèeŋ nə gʉ yusə̀ yà' yam gha' yusə̀ mʉ̀ gʉ̀ bohòtʉ nè'e yè'sə. Aco wèŋ dʉk fa nda nè'e də, <Coho fa'nə, nə kə kəəŋ gbʉ lo sənə ndzəp nà'a;> yà' fak. ");
INSERT INTO yam_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nə ye sə̀' də ŋga wèeŋ tse'-a dzədzəm fana yusə̀ wèŋ lɛŋ yà' bə pìriyà pwe', wèŋ tse' yà'.>> ");
INSERT INTO yam_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisòs à kə̀ foho ni fe'lə mʉmvwe' ntòmbi ndap Nwì nə̀ ghaŋ nə, nə sə yə'rə bwìŋ mbwa sə̀mok. Yi ànə sə yə'rə wo fana ŋgàa fa satikà' sə̀ ghaŋ bə bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ kə tseŋ yi. Wo fek yi də, <<Wù gʉ̀ bum sə̀ wù sə gʉ̀ʉ yè'sə bə ŋàaŋ sə̀ fò? Kènə fa wu ŋàŋ ndà də wu gʉ yà' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yi dʉk fəsə fa yà'wèŋ də, <<Mʉ nə fek weŋ yu səmok yàm sə̀'. A ye-a ŋga wèŋ tsə̀' fa mʉ fana mʉ̀ tsok fa weŋ nsàp ŋàŋ nə̀ mʉ̀ tse' ŋgògʉ̀ bum yè'sə bə zeŋ nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ncèp nə də, ŋàaŋ sə̀ Jon à sə bàptɛsə bwìŋ bə zeŋ yà'a à və̀ bohòNwì kè yà' à tesə bohòbwìŋ-ɛ?>> Wo à yèto ŋgòcèp bə zeŋ mʉtsətsə'rə wo dʉk də, <<A tsok fa yi yè'sə da? Bʉsə̀ a dʉk-a də ŋàaŋ sə à sə və̀ bohòNwì, fana yi nə fek fe'lə ves də, anə geŋ vesùwèŋ kà yusə̀ Jon à sə cèp dzəm bʉ̀ʉ yàlɛ? ");
INSERT INTO yam_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nə ye sə̀' də a dʉk-a də yà' à və̀ bohòbwìŋ fana a sə wəp yusə̀ bwìiŋ nə gʉ sə bʉ̀ʉsə̀ wo dzəm tse' yàwo də Jon nə ŋgà tsòhòbum Nwì.>> ");
INSERT INTO yam_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Fana wo dʉk fa Jisòs də wo ka riŋ. Jisòs dʉk bwi fa wo ye sə̀' də, <<Ye də mʉ nə kà weŋ nsàp ŋàŋ nə̀ mʉ̀ tse' ŋgògʉ̀ bum yè'e bə zeŋ nə sə̀' tsə̀'. ");
INSERT INTO yam_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","<<Wèŋ tsəm bə ncèp nè'e da? Ŋwə̀ nəmòk à ye, yi tse' bwe ye ba. Yi kə dʉk fa nə̀ mantombì nə də, <Mo àm, dù, nə kə fak mʉ nzuù ntinə.> ");
INSERT INTO yam_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mo nə də, <Mʉ nə kà gə̀.> À ye maŋkwɛ̀ŋ yi kupsə ntʉm ye, nə lo. ");
INSERT INTO yam_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Fana yi lo bohòmo ye nə̀ ba, nə dʉk fa nà' sə̀' vɛ'nə. Mo nə də, <Mʉ̀ yuk laŋ pàpa a. Mʉ nə geŋ>, nə kà yuye gə̀. ");
INSERT INTO yam_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sə tsətsə'rəə bwe sə̀ ba yè'sə, ŋwə̀ nə̀ yi à gʉ̀ yusə̀ tɛ̀' à dzəm à ye nə̀ fò?>> Wo də, <<A nə̀ mantombì nà'a.>> Jisòs dʉk fa wo də, <<Mʉ̀ sə tsə̀' weŋ yè'e zìnə də, bʉ̀ʉ sə̀ bʉp sə̀ wo ŋgàa benə̀ mbàam tas bə ŋgàa kohòsàhà wèeŋ nə ni to lo mvwe' gaŋ ŋkum Nwì wo, nə noŋsə wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Njo nə də Jon ŋgà bàptɛsə̀ bwìŋ à və̀, nə sə tsoho fa weŋ mandzə̀ nə̀ nà'a kə̀kʉrə̀ nə, wèŋ kà yi sə̀' yuk fa. Bʉ̀ʉ sə̀ bʉp sə̀ ŋgàa ko tas bə ŋgàa kohòsàhà wèŋ nə dzəm fa yi yusə̀ yi à sə cèp sə. Wèŋ ye bum yè'sə, nə kà də wèeŋ kupsə ntʉʉm awèŋ nə dzəm fa yi sə̀ dʉk.>> ");
INSERT INTO yam_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ànə geŋ Jisòs dʉk wo də, <<Wèeŋ yuk gbʉ' mòk nè' sə̀'. Ŋkwà' ŋwə̀ nəmòk à ye nə̀ yi ànə tse' nzum ndik nəmòk nə̀ wo togə̀ nà' də grep. Nə gʉm yà' bə ŋka', nə tuŋ tsə'rə mvwe' sə̀ wo nə sə nəŋ fis ndzəp ndzənə nto'o greep sə fo', nə ci tes yumok fo' co wu kok cum mbwa, nə sə tək nzum sə, nə tes yà' bohòbʉ̀ʉ səmok, nə ye'e lo gì mvwe' səmok. ");
INSERT INTO yam_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mvə̀k à kʉəp nə̀ ŋgòkwì ŋgwìi bum sə̀ mʉ nzuù anə fana yi tumsə ŋgàa fàak ye wèŋ də wo kə tseŋ bʉ̀ʉ sə̀ wo cu mʉ nzuù anə, nə jəŋ fa yi ŋgwìi bum sə ma njè. ");
INSERT INTO yam_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bʉ̀ʉ sə̀ wo à sə cu mʉ nzuù anə wèŋ sə ko ŋgàa fàak ye sə wèŋ, nə ləp mòk, nə zə mòk, nə təprə mòk bə lìs. ");
INSERT INTO yam_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yi tumsə fe'lə ŋgàa fàak ye mok, wo yam ghak mok sə̀ ye to fa' mantombì sə. Wo gʉ yà'wèŋ sə̀' mvə̀'nə̀ wo ànə gʉ sə̀ mantombì sə. ");
INSERT INTO yam_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Yi tumsə ləsə mok mo ye nə̀ yi à dzə nà' ndzə və̀ə yi. Yi sə dʉk ye də, <Wo nə wəp tsoŋ li nà'.> ");
INSERT INTO yam_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bʉ̀ʉ sə̀ wo à sə cu mʉ nzuù anə à yə mo ye nə fana wo dʉk də, <Nè'e ŋga'a mo ye nə̀ ndzə və̀ə yi, nə̀ ŋkwà' ŋwə̀ nə kà-a ye, yi nə cum mvwe' kùu ye yi nə. Wèeŋ və a zə yi ŋga a tse' bum ye sə vès.> ");
INSERT INTO yam_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wo kə ko fis yi mʉ nzuù anə, nə zə yi. ");
INSERT INTO yam_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nə ye də a ye-a ŋga ŋgà nzum nə və-a, yi nə gʉ bʉ̀ʉ sə̀ wo cugə̀ mʉ nzuù anə va?>> ");
INSERT INTO yam_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wo dʉk yi də, <<Yi nə ko bʉ̀ʉ sə̀ bʉp yè'sə, nə zə yà' vɛ'ɛ jì manziŋ, nə jəŋ nzum nə fa yà' bohòbʉ̀ʉ mok sə̀ wo nə sə fa yi ŋgwìi bum ye ghà nə̀ yà' zəm.>> ");
INSERT INTO yam_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisòs dʉk fa wo də, <<Wèŋ a ka mvə̀'nə̀ wo à còm ndzənə ŋwàk Nwì yà'a taŋ yuk à? Də, <Lìs nə̀ ŋgàa ci ndap wèŋ à dzèeŋ màk nòŋsə nà' də nà'a bʉp nə kə̀ tse' gha' fe'lə fàk mok sə̀' zeŋ. À gʉ̀ yè'sə Tà Nwì, fana yà' ye maŋgəŋgèŋ mʉ lisə̀ vesùwèŋ nə̀bʉp.> ");
INSERT INTO yam_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ye də mʉ̀ sə tsə̀' weŋ yè'e zeŋ də wo nə jəŋ gɛsə mvwe' gaŋ ŋkum Nwì sə bohòwèŋ, nə fa yà' bohòbʉ̀ʉ sə̀ wo nə zəm riŋ ŋgwìi sə.  ");
INSERT INTO yam_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ŋwə̀ nə̀ yi gbʉ̀-a mʉnə lìs ènə, ŋgə̀ŋgàŋ tiiŋ sam zəzok. Nə ye sə̀' də a ye-a ŋga lìs nə gbʉ-a mʉ ni'ì ŋwə̀ nəmòk, nà' gok fam ŋgə̀ŋgàŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ŋgàa fa satikà' sə̀ ghaŋ bə bʉ̀ʉ Faràsi wèŋ à yu'rə wes gbʉ' yè'sə fana wo riŋ də nà' sə cèp yè'sə bohòwo. ");
INSERT INTO yam_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Fana wo lap mandzə̀ də wo ko yi. Wo sə wəp fe'lə bwìŋ, bʉ̀ʉsə̀ bʉ̀ʉ sə wèŋ à jəŋ yi yàwo co ŋgà tsòhòbum Nwì. ");
INSERT INTO yam_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ànə geŋ Jisòs nə tsok fa fe'lə wo gbʉ' mòk sə̀' də, ");
INSERT INTO yam_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Aco wo fʉhʉ gaŋ sə̀ mʉbu sə co bə ŋkum nəmòk nə̀ yi à fʉ̀hʉ gùu mo ye də bwìiŋ kə zʉ fa yi. ");
INSERT INTO yam_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ànə geŋ yi tumsə lo ŋgàa fàak ye wèŋ də yà'a kə to və bʉ̀ʉ sə̀ yi to yà'wèŋ də a ta wo və sə. Wo kà yu awo və̀. ");
INSERT INTO yam_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yi tumsə fe'lə bwe ye mok sə̀mok də wo kə tsok bʉ̀ʉ sə də yi fʉ̀hʉ wes zʉzʉʉ ye laŋ. Də, <Mʉ̀ sʉə ndum mbòoŋ am nə ye mbòoŋ sə̀ mʉ̀ à ya' wo yà'a wèŋ nduk. Mʉ̀ gʉ̀ wes bum pwe'fo' laŋ, wo və nə kə zʉ.> ");
INSERT INTO yam_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bʉ̀ʉ sə wèŋ kà mbɛŋ nə̀ mbɛŋ kom lok. Mòk bɛ' mandzə̀ ye lo nzuù yi, mòk lo mvwe' sèŋ bum ye. ");
INSERT INTO yam_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mok sə̀ wo bwehe cu sə wèŋ ko ŋgàa fàak ye sə, nə tʉksə wo, nə zə wo. ");
INSERT INTO yam_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ŋkum nə à jòk vɛ'ɛ kpʉ nə kpʉ, nə tum sojàa ye wèŋ kə zə bʉ̀ʉ sə̀ wo à zə bwìŋ sə. Sojàa ye sə wèŋ à tɛ̀ŋ və̀psə lak bʉ̀ʉ sə wèŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Fana yi dʉk bwe ye sə wèŋ də, <Mʉ̀ fʉ̀hʉ bum sə̀ mvwe' gùu sə laŋ. Megu də bʉ̀ʉ sə̀ mʉ̀ to wo sə ka bʉ̀ʉ sə̀ anə ye co mʉ̀ to wo sə yeŋ. ");
INSERT INTO yam_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ye də wèeŋ lo sə mandzə̀, ŋwə̀ nə̀ wèŋ yə lòoŋ, wèŋ to wo ŋgòvə̀ mvwe' gùu sə.> ");
INSERT INTO yam_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bwe ye sə wèŋ à lòsə mandzə̀, nə to benə bʉ̀ʉ sə̀ wo yə pwe'. Bʉ̀ʉ sə̀ bə̀boŋ bə sə̀ bʉp wèŋ pwe' nduk. Ndap nə̀ wo à sə gʉ̀ gùu sə mbwa nə à rwiŋ vɛ'ɛ ŋkiŋ bə bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","<<Ŋkum nə à lòdə yi kʉk ja'a bʉ̀ʉ sə̀ wo və̀ sə fana yi ye ŋwə̀ nəmòk mbwa mò'fis nə̀ yi à ka cə̀ək sə̀ wo ni lògə̀ yà' mvwe' gù sə nitse'. ");
INSERT INTO yam_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yi fek nà' də, <Ŋge', wù yè va ŋkuŋ nə kə ni cum fɛŋ jì cə̀k gù ɛ?> Ŋgà' nə cum dədok, nə kà cù mùk. ");
INSERT INTO yam_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Fana ŋkum nə to bʉ̀ʉ sə̀ wo sə fàk bohòyi, nə dʉk fa yà' də, <Wèeŋ ko kiŋ ŋwə̀ nè'e. Wèeŋ kiŋ tasə bo ye bə kùu ye pwe'fo', nə kə mak gesə lo yi mvwe' sə̀ ndzəm sə seŋ fo'. Bwìiŋ nə sə waŋ, nə sə zʉ nzòŋ fo'.> >> ");
INSERT INTO yam_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisòs mesə ncèp nə də, <<Yà'a mvə̀'nə̀ wo a to bwìŋ ŋkʉ̀ʉŋ fana nə cok fis jəŋ megu moòm jo.>> ");
INSERT INTO yam_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ànə geŋ fana bʉ̀ʉ Faràsi wèŋ lo kə cum kwe', nə lap mandzə̀ də ya wo tam Jisòs bə dʉk. ");
INSERT INTO yam_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wo tum be'lə bʉ̀ʉ sə̀ wo fàkgə̀ bohòwo mok bə bʉ̀ʉ Heròwèŋ bohòJisòs anə. Wo kə dʉk yi də, <<Cicà, vès rì də wu ŋwə̀ nə̀ zìnə. Vès rì də wu yə'rə fagə̀ bwìŋ mandzə̀ Nwì bə zìnə, nə kà yusə̀ ŋwèe nə cèp sə̀ wəp, bʉ̀ʉsə̀ wu kà yòdə nè'e ŋwə̀ nə̀ ŋkʉ̀ʉŋ kè nə̀ jo àlɛ' tsərəgə̀. ");
INSERT INTO yam_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tsok-a ves yusə̀ wù tsəm yò. Lʉ̀ʉk vesùwèŋ sə tsə̀' də, a bə̀boŋ ŋgòlàk fa ŋkum Kaisà nə̀ mvwe' lak Rumà mbàam tas kè ka' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wo à sə cèp yè'sə ŋga Jisòs rì wes yusə̀ wo sə lirə ca sə pwe' nə̀ pwe', fana yi fek yà'wèŋ də, <<Wèŋ ŋgàa tè'èŋkup, wèŋ sə də wèeŋ mumsə yè'sə ndà? ");
INSERT INTO yam_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wèeŋ jəŋ və fa a mʉ mbàm nə̀ wèeŋ làkgə̀ tas bə zeŋ nə è.>> Fana wo jəŋ və fa yi mbàm mòk. ");
INSERT INTO yam_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jisòs fek wo də, <<Wo còm naaŋ mʉnə mbàm nə yè'e liŋ ndà, nə ye mbwa yè'e sə̀' si ndà?>> ");
INSERT INTO yam_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wo dʉk də, <<A sə̀ ŋkum Kaisà.>> Fana yi dʉk yà' də, <<Ye də wèeŋ lak fa Kaisà yusə̀ yà'a sə̀ ye, nə lak fa Nwì yusə̀ yà'a sə̀ Nwì.>> ");
INSERT INTO yam_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wo ànə yuk vɛ'nə fana wo mərə vɛ'ɛ, nə bɛ' mandzə̀ àwo, nə lo dədok, nə me'rə tes yi fo'. ");
INSERT INTO yam_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","À ye sə̀' nùmbu ànə, bʉ̀ʉ Sadusì mok wèŋ və bohòJisòs. Wo bòp bʉ̀ nə̀ wo dʉkgə̀ yàwo də kaco ŋwè lokok fe'lə mvwe' kpʉ yeŋ wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wo və kə fek yi də, <<Cicà, Musì à dʉk də, a ye-a ŋga ŋwè jə ŋwàŋwè, nə kpʉ ŋga bə nà' ka bwe tse' fana moma yee nə jəŋ tsoŋ ŋwà nə, ya bə nà'a dzə fa tə̀tà ye nə̀ yi kpʉ nə bwe. ");
INSERT INTO yam_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nə yeè nə də vès tse' bwema mok fɛŋ bwìŋ sàmba. Fana nə̀ mwè nə jəŋ ŋwàŋwè, nə kpʉ me'rə nà' ŋga bə nà' ka mwe tse'. Yi me'rə noŋsə lo fa moma ye ŋwà nə. ");
INSERT INTO yam_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Fana nə̀ ba nə kpʉ sə̀' ŋga bə nà' ka mwe sə̀' tse'. Nə̀ tɛ' kpʉ sə̀' vɛ'nə tə̀tè kə dzeŋ bə nə̀ sàmba nə. ");
INSERT INTO yam_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Wo ànə kpʉ wes pwe' fana ŋwà nə kpʉ ye sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nùmbu nə̀ bwìiŋ kə̀ lòkok mvwe' kpʉ kə dzèŋ nùu, ŋwà nə nə ye yè'sə ŋgwe ndà? Bʉsə̀ wo à tse' yi wo pwe'fo' laŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisòs dʉk fa wo də, <<Wèeŋ ŋgàa jòŋ. A bʉ̀ʉsə̀ wèŋ ka yusə̀ yà' cu ndzənə ŋwàk Nwì riŋ, nə kà ŋàaŋ Nwì sə̀' rì. ");
INSERT INTO yam_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yusə də mvə̀k nə̀ bʉ̀ʉ kpʉkpʉ nə lokok mvwe' kpʉ, wo nə ye co masinjàa Nwì mʉbu, ŋwə̀mbam bə ŋwàŋwèe nə kà gù mok cu fe'lə̀. ");
INSERT INTO yam_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Bə nzak nə̀ ŋgòlòkok mvwe' kpʉ, wèŋ a ka yusə̀ Nwì à cèp bohòwèŋ yà'a taŋ à? ");
INSERT INTO yam_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Yi à dʉk də, <Mʉ Nwì Abràham nə ye Nwì Azìk nə ye Nwì Jàkop>. Nwì à cèp vɛ'nə ŋga wo à kpʉ lòlaŋ. Yà'a sə nìtsə̀' də bʉ̀ʉ yè'sə cu fe'lə ŋwəm, njo nə̀ yi ka Nwì bʉ̀ kpʉkpʉ yeŋ, yi Nwì bʉ̀ʉ sə̀ wo cu ŋwəm. Yà'a mvwe' sə̀ wèeŋ bə jòŋ nə̀bʉp.>> ");
INSERT INTO yam_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bʉ̀ʉ sə wèŋ ànə yuk bum yè'sə fana wo mərə fʉk nsàp yəyə'rə̀ ànə bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bʉ̀ʉ Faràsi wèŋ ànə yuk də Jisòs lok bʉ̀ʉ Sadusì wèŋ cù co wo kà yusə̀ ŋgòcèp fe'lə tse' fana wo baaŋ yàwo sə mvwe' mò'fis. ");
INSERT INTO yam_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Fana mòk mʉtsətsə'rəə wo nə̀ yi ŋwə̀ nə̀ yi rì lʉ̀k wùriŋ fek Jisòs nə yumok ŋgòmùmsə ja'a nà'. ");
INSERT INTO yam_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Yi fek nà' də, <<Cicà, lʉ̀k nə̀ nà' gʉ gha' lʉ̀ʉk mok pwe'fo' yi yè'sə nə̀ fò?>> ");
INSERT INTO yam_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yi dʉk fa nà' də, <<A nə̀ də, <Wù tse' ŋgòdzəm Tà Nwì yòbə ntʉm yòpwe'fo', dzəm yi bə yòŋsə̀ yòpwe'fo', nə dzəm yi bə ŋkərə̀ yòsə̀' pwe'fo' nà'a.> ");
INSERT INTO yam_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nè'e yè'e lʉ̀k nə̀ nà' gʉ càsə mok sə pwe'fo' nə ye nə̀ mantombì sə̀' zeŋ nə. ");
INSERT INTO yam_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Lʉ̀k nə̀ ba nə̀ nà' gʉ càsə nə səsə sə̀' co mòk nə. Nà'a də, <Wu tse' ŋgòdzəm tsə moma yo co wù dzəm ni' yò.> ");
INSERT INTO yam_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bum sə̀ lʉ̀ʉk mok sə cèep, nə ye bə bum sə̀ ŋgàa tsòhòbum Nwì wèŋ à sə cèp pwe'fo' yà' na mègù mʉŋkwɛ̀ɛŋ lʉ̀ʉk sə̀ ba yè'sə.>> ");
INSERT INTO yam_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mvə̀'nə̀ bʉ̀ʉ Faràsi wèŋ sə à baaŋ tə malì ntòmvwe' mò'fis fana Jisòs fek wo yumok. ");
INSERT INTO yam_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Yi à fek wo də, <<Wèŋ tsərə bə ŋwə̀ nə̀ wo to liŋ ye də Ŋkum ŋgà gèm bwìŋ nà'a da? Wèŋ tsəm də yi mo ndà?>> Wo dʉk fa yi də, <<Yi ŋgwì bʉ̀ Devìd.>> ");
INSERT INTO yam_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yi fek fe'lə yà' də, <<Nə ye va ŋkuŋ Devìd nə bə tu ye to bwi ŋwə̀ ènə də Tà ŋga yòŋsə̀ nə̀ Nwì nə à gʉ̀ yi ɛ? ");
INSERT INTO yam_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Devìd nə à cèp də, <Tà Nwì à dʉk fa Tà àm də, <<Cum fɛɛŋ bo ma mà'a mʉ̀ tə̀tè mʉ nə gʉ bʉ̀ʉ sə̀ wo bɛ̀ŋgə̀ wu, wo ye sə mvə̀'kùu wù.>> > ");
INSERT INTO yam_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","A ye-a də Devìd nə sə to nà' də Tà, ye də aco yi ye bwi bohòDevìd anə mwe yè'sə valɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ŋwə̀ nə̀ mò'fis co yi cep fəsə fa nà' yumok à ka yeŋ. Ye jəŋ nùmbu ànə, nə lo mantombì, ŋwè kà co yi fek fe'lə yi yumok mok ghʉ̀sə ja'a lo' fʉ̀'. ");
INSERT INTO yam_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ànə geŋ Jisòs dʉk fa ŋgàa fàak ye bə bʉ̀ʉ sə̀ wo à mà fo' sə wèŋ də, ");
INSERT INTO yam_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<Ŋgàa yə'rə̀ fa bwìŋ lʉ̀k bə bʉ̀ʉ Faràsi wèeŋ wo sə̀ wo tə mvwe' kùu Musì. ");
INSERT INTO yam_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nə ye də bum sə̀ wo tsə̀' weŋ pwe', wèŋ gʉ mvə̀'nə̀ wo dʉk sə. Megu də wèŋ kà də wèeŋ gʉ bɛ' lo mvə̀'nə̀ wo sə gʉ̀ yàwo dʉk. Bʉsə̀ wo tsòhogə̀, nə sə gʉ lo yusə̀ zok. ");
INSERT INTO yam_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wo gʉ̀ fagə̀ bwìŋ lʉ̀k ŋkʉ̀ʉŋ sə̀ yà'a co bum sə̀ rə̀rwi', sə̀ yà'a gʉgʉŋ ŋgòbə̀ə', nə sə naaŋ fa bwìŋ yà' mʉ tuhù, nə kà ndubo nə̀ mò'fis ŋgòjə bə̀' yàwo yà' fəsə̀ ja'à lok. ");
INSERT INTO yam_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wo gʉ̀ mègù bum yàwo də ya bwìiŋ ye wo. Kʉ̀k ja'a yàwèeŋ ncòròok sə̀ mʉ sihì bə ndzə kwiì wo yà'a, mvə̀'nə̀ yà' wə̀rə. Nə ja'a nɛ ncàam sə̀ ndzə cə̀'ə wo mvə̀'nə̀ yà' sàap ɛ̀. ");
INSERT INTO yam_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wo dzəm də wo lòmvwe' nzu yumok fana wo kə cum megu mvwe' sə̀ ya bwìiŋ wəp wo co bʉ̀ʉ sə̀ ghaŋ. Wo dzèŋ mʉmvwe' ndaap pìriyà, wo lap ŋgòcu mʉnə dzòok sə̀ yà' bòghak pwe' wo. ");
INSERT INTO yam_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wo dzəm sə̀' də a dzèŋ mʉ ntɛɛ̀ŋ, bwìŋ sə kə cepsə wo, nə sə to wo mvwe' bwìŋ də cicà, cicà. ");
INSERT INTO yam_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","<<Bohòwèŋ yàwèŋ, wèŋ ka tse' ŋgògʉ̀ ni' awèŋ də bwìiŋ sə to weŋ də cicà, bʉ̀ʉsə̀ wèeŋ pwe'fo' bwema, nə tse' mègù nə cicà nə̀ mò'fis. ");
INSERT INTO yam_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nə ye sə̀' də kà də wèeŋ to ŋwə̀ nəmòk sə nze fɛɛŋ də tɛ̀' awèŋ dʉk, njo nə̀ wèŋ tse' mègù tɛ̀' nə̀ yi mò'fis, yi cu mʉbu. ");
INSERT INTO yam_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nə kà də wèeŋ gʉ bwìŋ də wo sə to weŋ də masà sə̀' dʉk, njo nə̀ wèŋ tse' mègù masà nə̀ mò'fis, yi Ŋkum ŋgà gèm bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ŋwə̀ nə̀ yi də yi nə̀ ghaŋ mʉtsətsə'rə wèŋ pwe' yi, tse' ŋgòye ŋkwɛ̀ŋ àwèŋ. ");
INSERT INTO yam_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ŋwə̀ nə̀ yi koksə lò-a ni' ye mʉtsə̀, Nwìi nə̀ jəŋ tsoŋ və̀ yi sə nze. Ŋwə̀ nə̀ yi jə tse' lo-a ni' ye sə nze, Nwì jə fis kok lòyi mʉtsə̀. ");
INSERT INTO yam_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","<<Wèŋ ŋgàa yə'rə̀ bwìŋ lʉ̀k bə bʉ̀ʉ Faràsi wèŋ, wèeŋ ŋgàa tè'èŋkup. Wèŋ cu bʉp! Wèŋ sə lok fa bwìŋ mandzə̀ nə̀ ŋgòlòmvwe' gaŋ Nwì. Wèŋ sə kà mbwa lò, nə kà bʉ̀ʉ sə̀ wo sə dzəm də wo ni mbwa wèŋ mandzə̀ sə̀' fa.  ");
INSERT INTO yam_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","<<Wèŋ ŋgàa yə'rə̀ fa bwìŋ lʉ̀k bə bʉ̀ʉ Faràsi wèŋ, wèŋ cu bʉp. Wèeŋ ŋgàa tè'èŋkup. Wèŋ sə limzʉ bàa ŋgwemfə wèŋ, nə sə gʉ bʉpsə ndap awo. Wèŋ rì ŋgògʉ̀ basə pìriyàa sə̀ sə̀sap. Ŋgə' nə̀ njàwèeŋ nə̀ kə̀ yam gha' pwe'fo' njo bum yè'sə. ");
INSERT INTO yam_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","<<Tə̀tè'èŋkup ŋgàa yə'rə̀ lʉ̀k bə bʉ̀ʉ Faràsi wèŋ-a, wèŋ cu bə ŋgə' nə̀bʉp. Wèeŋ to càgə̀ sə ndzəpə̀, nə sə gi bə sə nzehè wèŋ pwe'fo' də ya wèeŋ gʉ ŋwə̀ nə̀ mò'fis bɛ' mandzə̀ lʉ̀ʉk Musì. Nə̀ mò'fis bʉ̀ʉŋ fana wèŋ gʉ fe'lə yi sə̀' wèŋ, yi bʉp casə wèŋ sə̀ wèŋ sə lòmvwe' ŋgə' nə̀ sə misə̀ sə kɛ̀' ba. ");
INSERT INTO yam_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","<<Wèŋ sə̀ wèŋ də wèŋ sə nìtsə̀' lòfa bwìŋ mandzə̀ nə ye yàwèŋ sə̀' jì lis, wèŋ cu bʉp. A sə̀' wèŋ sə̀ wèeŋ dʉkgə̀ də a ye-a ŋga ŋwè kɛ̀ŋ ndap Nwì nə̀ ghaŋ nə, ye də yà'sə kà nzak tse'. Nə ye də, a ye-a ŋga ŋwè kɛ̀ŋ bum sə̀ wo à gʉ̀ yà' bə guù sə̀ yà'a mʉ nda'à Nwì anə ŋkuŋ yi gʉ tsoŋ mvə̀'nə̀ yi kɛ̀ŋ sə. ");
INSERT INTO yam_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wèeŋ jì lis nə ye ləm sə̀'. A yè'sə də gʉ gha' nə̀ fò? Bum sə̀ mʉnə ndap Nwì sə, kè ndap Nwì nə̀ ghaŋ nə bə tu ye nə̀ nà' gʉ̀ ŋkuŋ bum sə̀ mbwa sə tse' fàk ɛ? ");
INSERT INTO yam_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wèeŋ dʉkgə̀ sə̀' də, <A ye-a ŋga ŋwè kɛ̀ŋ kàm nə̀ wo à ci ŋgòtɛ̀ŋ fa Nwì bum satikà' mbwa nà'a, yà'sə ka nzak tse', də tse'ŋga yi kɛ̀ŋ bum sə̀ wo naaŋ yà' mbwa sə ŋkuŋ àlɛ yà' tse' fàk.> ");
INSERT INTO yam_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wèeŋ ŋgàa jì lis, gʉ gha' yè'sə nə̀ fò? Bum sə̀ wo fa nə naaŋ yà' mbwa sə kè, kàm nə̀ yi gʉ̀ yi ŋkuŋ bum sə̀ mbwa sə tse' fàk-ɛ? ");
INSERT INTO yam_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yusə də a ye-a ŋga ŋwè kɛ̀ŋ-a kàm ànə, ye də yi kɛ̀ŋ be'lə fo' bə bum sə̀ mbwa sə pwe'. ");
INSERT INTO yam_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nə ye sə̀' də a ye-a ŋga ŋwè kɛ̀ŋ ndap Nwì nə̀ ghaŋ nə fana yi kɛŋ nà' bə Tà ŋgà ndap nə pwe'fo' sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ŋwə̀ nə̀ yi kɛ̀ŋ-a ntòbu, ye də yi kɛ̀ŋ kapràak Nwì bə ŋwə̀ nə̀ yi cugə̀ mbwa nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","<<Wèŋ ŋgàa tè'èŋkup wèŋ, ŋgàa yə'rə̀ bwìŋ lʉ̀k bə bʉ̀ʉ Faràsi wèŋ, wèŋ cu bʉp. Njo nə̀ wèeŋ fagə̀ Nwì bòp mò'fis sənə hum bə bum awèŋ, nə fa tə̀tè bə mvùu bum sə̀ wo lam rə̀msə tsə'rə njàp bə zeŋ wèŋ, nə me'rə noŋsə lʉ̀ʉk sə̀ gʉgʉŋ co ŋgòye yəyərə̀ bohòbwìŋ bə bum pwe', nə tse' koksə̀manziŋ, nə ye ŋwə̀ ŋgà gʉ̀ bum bə mandzə̀ nə̀ zìnə. Anə ye co wèŋ sə gʉ yè'sə, nə sə gʉ mok sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jì lis, ŋgàa nìfa bwìŋ mandzə̀ wèŋ. Wèŋ sə kpès fis màk ndzə̀ nə̀ jo nə̀ wà nè'e, nə sə mi lo nàmbà'rə̀ sə̀' sə və̀ə wèŋ anə. ");
INSERT INTO yam_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","<<Ŋgàa yə'rə̀ bwìŋ lʉ̀k bə bʉ̀ʉ Faràsi wèŋ, wèŋ cu bʉp. Wèeŋ ŋgàa tè'èŋkup, wèeŋ cùkgə̀ yàwèŋ ŋkwɛ̀ɛŋ ŋgàp bə ŋkwɛ̀ɛŋ tasà, fana rwiŋ cum ma ndzə tsətsə'rə̀ wèŋ anə ŋgwap nə ye wa bum bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bʉ̀ʉ Faràsi ŋgàa jì lis wèŋ. Wèeŋ cuk rɛŋsə to ŋgàp awèŋ ma sə ntòŋkuŋ ya ma nə̀ mʉŋkwɛ̀ŋ nə rɛŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","<<Ŋgàa yə'rə̀ bwìŋ lʉ̀k bə bʉ̀ʉ Faràsi wèŋ, wèŋ cu bʉp. Wèŋ mègù co sèe sə̀ wo yok fopsə yà' bə bwɛ̀ŋ, ŋga rwiŋ cu nja vəp bʉ̀ kpʉkpʉ bə bum sə̀ bʉp wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wèŋ sə yəəŋ mʉ lisə̀ bwìŋ co bʉ̀ʉ sə̀ kə̀kʉrə̀ bohòNwì, ŋga wèŋ rwiŋ nja bə tè'èŋkup nə ye bə bʉp. ");
INSERT INTO yam_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","<<Ŋgàa yə'rə̀ bwìŋ lʉ̀k bə bʉ̀ʉ Faràsi weŋ, wèŋ cu bʉp. Wèeŋ ŋgàa tè'èŋkup, njo nə̀ wèeŋ ci tsə'rəgə̀ sèe ŋgàa tsòhòbum Nwì wèŋ, nə sə gʉ tsə'rə bum sə̀ wo à ci tes yà' ŋgòkwasə liŋ bʉ̀ʉ Nwì wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Wèŋ sə cep kə̀ cùhu də, <Vès ànə ye-a ghà nə̀ tɛ̀' avès wèŋ à ye bwɛ̀rɛ vès ànə ka bo mvwe' sə̀ wo à sə zə bʉ̀ ŋgàa tsòhòbum Nwì yà'a fa gèsə̀.> ");
INSERT INTO yam_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wèeŋ to wo də tɛ̀' awèŋ vɛ'nə, ye də wèŋ sə nìŋtsə̀' də wèeŋ bwe bʉ̀ʉ sə̀ wo à zə ŋgàa tsòhòbum Nwì wèŋ sə. ");
INSERT INTO yam_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Wèeŋ geŋ mantombì, nə gʉ wes bum sə̀ tɛ̀' awèŋ ànə gʉ to sə. ");
INSERT INTO yam_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","No, wèŋ ŋgwì bʉ̀ no wèŋ, aco wèŋ tsəm də wèeŋ nə̀ kà mvwe' ŋgə' nə̀ sə misə̀ kə̀ ni anə yè'sə va? ");
INSERT INTO yam_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ye də mʉ̀ tum fa weŋ ŋgàa tsòhòbum Nwì nə ye ŋgàa ŋkərə̀ bə ŋgàa yə'rə̀ bwìŋ lʉ̀k wèŋ. Wèeŋ nə zə mok, wèŋ tɛ'lə mok mʉ ntə̀əŋ, nə ləp mok mʉmvwe' ndaap pìriyà awèŋ. Wèeŋ nə bɛ' tʉksə mok wo caŋ ni mvwe' buk lak nə̀ fòpwe', wèŋ sə yuŋ. ");
INSERT INTO yam_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","A ye vɛ'nə fana ndʉəm bʉ̀ʉ Nwì sə̀ wo à zə wo sə nze fɛɛŋ pwe'fo' nə ye mʉ tuhù wèŋ. Ye jəŋ bə ndʉəm Abè nə̀ wo à zə yi ŋga yi ka yumok riŋ tə̀tè kə dzeŋ mʉ ni'ì Sàkàriyà nə̀ wèŋ à zə yi mʉ ntòndap Nwì nə̀ ghaŋ nə. À ye ŋga yi tə mʉtsətsə'rə̀ə kàm satikà' fo' bə mvwe' rum nə̀ wo togə̀ nà' də ndap nə̀ rərɛŋ nà'a. ");
INSERT INTO yam_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mʉ̀ sə tsə̀' weŋ zìnə də, ŋgə' bʉ̀ʉ yè'sə pwe'fo' nə və mʉ tuhù bʉ̀ʉ sə̀ niè' yè'sə. ");
INSERT INTO yam_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","<<Webee, lak Jòrosalèm, lak Jòrosalèm! Wèeŋ zəgə̀ ŋgàa tsòhòbum Nwì, nə sə tərə ŋgàa gə̀ ntum Nwì wèŋ bə lìs. A yè'sə ghɛ̀' sʉ̀ mvə̀'nə̀ mʉ̀ sə làp də mʉ ko wumsə gesə weŋ ndzə ni'ì mʉ̀ co məma mvəp sə wumsə bwe ye, wèŋ kà dzəm ɛ? ");
INSERT INTO yam_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bo am ka mok bə lak awèŋ yà'sə yeŋ, yà'a mok fə̀əm lak wà. ");
INSERT INTO yam_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mʉ̀ tsə̀' weŋ də ye jəŋ ŋga'a lo mantombì, wèeŋ nə kà mʉ mok yə fe'lə̀ tə̀tè nùmbu nə̀ wèŋ yə fe'lə mʉ, ye mok ŋga wèŋ sə dʉk də, <Nwìi se ŋwə̀ nə̀ yi və̀ mʉnə liŋ sə̀ Tà nə ŋkuŋ.> >> ");
INSERT INTO yam_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisòs à sə ye'e mè'rə mvwe' ndap Nwì nə̀ ghaŋ nə ŋgòlòo fana ŋgàa fàak ye wèŋ və ŋgònì fa yi ndaap Nwì, sə də yi kʉk bʉrə ja'a mvə̀'nə̀ wo à ci bòŋsə yà'. ");
INSERT INTO yam_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jisòs nə cep fəsə fa yà'wèŋ də, <<Wèŋ sə yə bum yè'e pwe'fo', ka vɛ'nə yeŋ nɛ̀? Mʉ̀ sə tsə̀' weŋ zìnə də lìs nə̀ mò'fis nə kà mʉnə mòk fenə naàŋ mam. Wo nə kʉəmsə wes yà' pwe'.>> ");
INSERT INTO yam_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yi ànə geŋ də yi kə cum mʉmvwe' nda Olìp nə fana bwe ye wèŋ və woòwo, nə kə tseŋ yi. Wo sə fek yi də, <<Tsok fa a ves ghà nə̀ bum yè'sə nə ye-ɛ̀. Nə tsok fa ves yusə̀ yà'a nə niŋtsok də wù kʉəp ŋgòbwìŋ və̀ə ya nzeŋgòŋ nə nə me sə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Fana Jisòs nə cep fəsə fa wo də, <<Wèeŋ jəŋ ŋkərə̀ ya ŋwə̀ nəmòok kà weŋ bòrə̀. ");
INSERT INTO yam_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bʉsə̀ bwìiŋ nə və ŋkʉ̀ʉŋ sə̀ wo nə ci' mvwès də, wo Ŋkum ŋgà gèm bwìŋ nə̀ wo à sə dʉk nə wo, nə borə lo bwìŋ vɛ'ɛ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wèeŋ nə sə yuk kɛ'ca də dzè'e fa' mvwe' sə̀sap bə mvwe' jəjo wèŋ nduk. Wèeŋ yuk vɛ'nə, wèŋ kà wəp bʉ̀ʉsə̀ yè'sə nə ye tsoŋ vɛ'nə. Yà'a ye vɛ'nə, kà yà'sə də nze nə mè yà'sə laŋ sə̀' ntòye. ");
INSERT INTO yam_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bʉsə̀ bòp lak nə lʉ bə bòp lak mok. Ŋkum mòk lʉ bə ŋkum mòk sə̀'. Njèe nə ko, nzeŋgòŋ nə sə tsoho kɛ'ca fa' bə ma fa' wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yè'sə pwe'fo' mègù ntòco mvə̀'nə̀ ŋwàŋwèe ghà to ko'gə̀ mwe ntòghàa yè'e. ");
INSERT INTO yam_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","<<Fana wo nə ko weŋ, nə yeŋsə weŋ ŋgə', nə zə weŋ. Lak pwe'fo' nə bɛŋ weŋ bʉ̀ʉsə̀ wèeŋ bwe am. ");
INSERT INTO yam_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mvə̀k ànə ye vɛ'nə, bwìŋ ŋkʉ̀ʉŋ nə caŋ me'rə mandzə̀ njàm nə. Bwìiŋ nə sə seŋ mòk bə mòk, nə sə bɛŋ kɛ'ca mòk bə mòk sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ŋgàa mvwès wèeŋ nə ye sə̀' wùriŋ sə̀ wo nə sə dʉk də wo ŋgàa tsòhòbum Nwì wèŋ. Wo nə borə jəŋ lo bwìŋ vɛ'ɛ nduk. ");
INSERT INTO yam_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mvə̀'nə̀ bwìiŋ dzəmgə̀ mʉʉ nə fi lo mok maŋkwɛ̀ŋ njo nə̀ bʉp yam lòmok mantombì vɛ'ɛ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Megu də ŋwə̀ nə̀ yi təəŋ-a gʉgʉŋ tə̀tè, nə kə ləsə fana yi nə tse' lùŋ. ");
INSERT INTO yam_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ncèp Ntirə̀ nə̀ Bə̀boŋ nə̀ nà' sə tsə̀' bə gaŋ ŋkum yè'sə nə yuhu lo sənə nzeŋgòŋ nə pwe'fo' də ya ndàaŋwè pwe' yuk gesə fə ntu'ù yi ye sə̀'. Yà'a ŋga'a mvə̀'nə̀ nzeŋgòŋ nə nə lə sə.>> ");
INSERT INTO yam_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nùmbu mòok nə̀ kə̀ və̀ nə̀ wèeŋ yə ŋga wo lòkoksə tes bʉp nə̀ nà'a bə jòŋ nə mvwe' sə̀ rərɛŋ, bʉp nə̀ Danà ŋgà tsòhòbum Nwì à cèp nə. (Ŋwə̀ nə̀ yi sə ta ŋwàk nə rɛɛŋ bə zeŋ bə̀boŋ.) ");
INSERT INTO yam_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Wèeŋ yə vɛ'nə, bʉ̀ʉ sə̀ wo cu mvwe' nzeŋgòŋ Jùdiyà wèeŋ caŋ kok lo mʉ ndahà. ");
INSERT INTO yam_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ŋwə̀ nə̀ yi sə cu yòŋsə mʉ ndùndap kà mvə̀k ŋgòsuhu tsə, nə kə jəŋ fis bum ye sə̀ mʉ nda'à yi tse'. ");
INSERT INTO yam_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ŋwə̀ nə̀ yi mʉnə nzum fàak nə kà maŋkwɛ̀ŋ də yi sə kə̀ jə cə̀k fohòlò. ");
INSERT INTO yam_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ho'm, megu də anə ye ŋgə' bohòbàa sə̀ bə zʉm nə ye sə̀ wo sə fa bwe sə̀ lʉə mbwi bə nùumbu yà'sə. ");
INSERT INTO yam_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Wèeŋ lɛŋ Nwì də yi gʉ co wèeŋ kà mvə̀k mbʉ̀ŋ nə̀ bə mbʉəp wùriŋ ca, kè nùmbu dzə̀ àlɛ'. ");
INSERT INTO yam_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Njo nə̀ ŋgə' nə̀ nà'a nə ye mvə̀k ànə nə bʉp vɛ'ɛ nsàp nə̀ nzeŋgòŋ à yè yèe, à ka vɛ'nə ye yuk. Nə ye sə̀' də anə kà vɛ'nə mok sə̀' kə̀ ye yuk fe'lə̀. ");
INSERT INTO yam_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nə ye də Nwì a ka-a nùumbu yà'sə lə̀m ci' fəsə də bwɛ̀rɛ ŋwə̀ nə̀ mò'fis kà bwehe cu lok. Megu də yi nə ci' fəsə yà' lə̀m bʉ̀ʉ tu bʉ̀ʉ ye wèŋ sə̀ yi a cok fis yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","<<A ye-a ŋga ŋwə̀ nəmòk dʉk-a weŋ də <Ŋkum ŋgà gèm bwìŋ nə̀ wo à sə dʉk nə nè'>, kè də, <yi fʉ fa'> àlɛ, kà də wu dzəm swì dʉk. ");
INSERT INTO yam_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bwìiŋ nə sə borə kɛ' də wo Krɛst, nə sə dʉk də wo ŋgàa tsòhòncèp Nwì. Wo nə sə gʉ nsàap bum maŋgəŋgèŋ mok vɛ'ɛ wùriŋ də co wo borə bʉ̀ʉ sə̀ Nwì a cok fis nòŋsə sə bə zeŋ, ŋga wo tse'-a mandzə̀ nə na. ");
INSERT INTO yam_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wèeŋ jəŋ-a ŋkərə̀, mʉ̀ tsə̀' nòŋsə weŋ bum yè'sə ŋga cu ntòcuu. ");
INSERT INTO yam_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ye də a ye-a ŋga ŋwə̀ nəmòk dʉk weŋ də, <Nà' cu ŋgòŋ fa',> kà də wu tesə lo fo' dʉk. Kè wo dʉk-a sə̀ də <Yi cu mà mbwèndap nè'>, wù kà dzəm. ");
INSERT INTO yam_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bʉsə̀ mʉ̀ nə̀ mʉ mo ŋwè, mʉ nə və co mvə̀'nə̀ mbʉ̀ʉŋ ba'a kokgə̀ mà mbwèbu, nə ca bʉʉŋ kə̀ tu bu yè'e. ");
INSERT INTO yam_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mvwe' sə̀ vèŋ ni' kpʉ nooŋ-a sə̀ fòpwe', jìgawà' wèeŋ nə kə benə fo'. ");
INSERT INTO yam_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","<<Ghà nə̀ ŋgə'ə sə̀ yà'a nə̀ ye nùmbu ànə cà wes ntɛ̀ŋ fana nùum nə kɛŋ ndzəm. Ŋwə kà mok sə̀' se, ŋkə̀ŋkàŋ sə gbʉhʉ tsoŋ mʉbu anə fana nsàap ŋàaŋ sə̀ mʉtsə̀ sə tsoho sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mvə̀k mòok nə yəəŋ mʉbu nə̀ nà'a mvə̀k nə̀ njàm, mʉ̀ʉ mo ŋwè, fana ŋgwìi bʉ̀ʉ sə̀ sə nzeŋgòŋ pwe' nə tɛ'. Wo ye ŋga'a mvə̀'nə̀ mʉ̀ʉ mo ŋwè mʉ̀ sə tsə tesə mʉbu ndzənə mbàk bə ŋàŋ, nə sə fom rɛŋ boŋsə nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Fana mʉ nə tumsə masinjàa am sə̀ mʉbu ŋgòto lòbwìŋ bə ntàŋ nə̀ nà' sə cep vɛ'ɛ wùriŋ. Wo to benə və bʉ̀ʉ am sə̀ mʉ̀ à cok fis sə wèŋ ma ŋkùup nzeŋgòŋ sə̀ kwè sə mvwe' mò'fis, ye jəŋ mvwe' sə̀ nzeŋgòŋ nə yeto nə ye mvwe' sə̀ nà' kə̀ lə̀sə. ");
INSERT INTO yam_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","<<Mʉ̀ dzəm də wèeŋ yə'rə jəŋ ŋkərə̀ bohòtʉ fik nà'a. Wu yə ghà nə̀ nà' yè ŋgòfom, nə sə top, fana wù riŋ sə̀' də mvə̀k mbʉ̀ŋ kʉəp laŋ. ");
INSERT INTO yam_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yà' megu sə̀' vɛ'nə də wèeŋ yə bum yè'sə vɛ'nə fana wèŋ riŋ də mo ŋwè kʉəp ŋgòvə̀ laŋ, yi mègù mok ŋgʉ ncù. ");
INSERT INTO yam_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mʉ̀ tsə̀' weŋ zìnə də bʉ̀ʉ sə̀ wo cu ŋga'a yè'e wèeŋ nə kà ntòkpʉ lə̀ wes ŋga bum yè'sə yà' gʉ̀ laŋ. ");
INSERT INTO yam_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ntòbu bə nzeŋgòŋ ba fo' nə̀ cà gɛsə lòwà, ncèp àm kà ye cà yuk. ");
INSERT INTO yam_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","<<Yusə də ŋwè ka nùmbu nə bə mvə̀k nə̀ bum yè'sə nə ye riŋ. A mègù-a masinjàa Nwì mʉbu nə ye Mo ye nə sə̀', wo ka sə̀' riŋ. Rì mègù tɛ̀' nə yiìyi. ");
INSERT INTO yam_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mo ŋwèe və̀ nùmbu nə fana bum pwe' nə ye sə̀' mvə̀'nə̀ yà' ànə ye ghà nə̀ Nuà ànə ye ye nà'a. ");
INSERT INTO yam_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mègù sə̀' mvə̀'nə̀ ànə ye fa' mantombì ŋga ndzəp ànə ka ntòrwiŋ yà'a, bwìŋ à sə zʉ, nə sə no vəpsə. Bʉ̀ʉ mok wèŋ sə geŋ gù tə̀tè nùmbu nə̀ Nuà à ni ŋgwes dzeŋ. ");
INSERT INTO yam_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wo à sə gʉ̀ vɛ'nə, nə kà sə rì tə̀tè ndzəp kə bək wes wo vɛ'ɛ wis. Mʉ̀ʉ mo ŋwè, mʉ nə̀ və̀ ntsə'mòk yà' megu sə̀' mvə̀'nə̀ ànə ye yà'sə. ");
INSERT INTO yam_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nùmbu ànə ye, mbəmbam baa nə sə fàk nzum, wo jəŋ fis lo mòk, nə me'rə mòk. ");
INSERT INTO yam_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bə̀ba baa nə ye mvwe' ŋgòk, nə sə gok bɛŋ, wo jəŋ fis lo mò'fis, nə me'rə mòk fo'. ");
INSERT INTO yam_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ye də wèeŋ sə jəŋ ŋkərə̀, bʉ̀ʉsə̀ wèŋ ka nùmbu nə̀ Tà àwèeŋ nə̀ bwìŋ və̀ nə riŋ. ");
INSERT INTO yam_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wèeŋ riŋtse' yumòk nè' sə̀' də a ye-a ŋga tà ŋgà ndap nə riŋ-a ghà nə̀ ŋgà yə̀ə nə və, bwɛ̀rɛ yi nə so nooŋ tə̀tè tsok rɛŋ ya nà'a kà kə̀ ni. ");
INSERT INTO yam_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ye də wèeŋ cu, wèŋ ye fə̀fʉhʉ̀ ghà yà lòoŋ, bʉ̀ʉsə̀ mo ŋwèe nə̀ və̀ ŋga wèŋ sə kà bə zeŋ tsərə̀. ");
INSERT INTO yam_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","<<Mo fàk nə̀ yi zìnə nə tse' ŋkərə̀ə yè'sə nə̀ fò? A nə̀ masà ye nə à fa bum sə̀ mʉ nda'à yi bohònà', nə dʉk də nà'a nə sə fa bwe ye wèŋ bum zʉzʉ bə mvə̀k nə̀ kə̀kʉrə̀. ");
INSERT INTO yam_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A rɛŋsi bohòmofàk nə̀ masà ye bwì və̀ə, nà' tseŋ yi ŋga yi sə gʉ̀ mvə̀'nə̀ nà' ànə dʉk noŋsə lo yi sə. ");
INSERT INTO yam_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mʉ tsok weŋ zìnə də masà nə nə fa nsàp mofàk ànə ŋàŋ ŋgòkotse' bum ye sə̀ yi tse' pwe'fo' nà'. ");
INSERT INTO yam_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","A ye-a ŋgà fàk nə̀ yi bʉp, yi nə dʉk də, <Masà àm nə nə kà nə̀nàk bwìŋ fohòvə̀.> ");
INSERT INTO yam_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yi yeto ŋgòlə̀p ŋgàa fàak mok sə wèŋ, nə sə zʉ, nə sə no roŋ kɛ'ca bə ŋgàa jʉ̀hʉ̀ rùk wèŋ bəbɛ'. ");
INSERT INTO yam_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Fana masà ŋgà fàk ànə nə bwi və ntsə'mòk nùmbu nə̀ yi sə kà vɛ'nə tsərə̀, nə ye bə mvə̀k nə̀ yi ka bə zeŋ sə̀' riŋ. ");
INSERT INTO yam_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yi nə gbɛ' ci'lə nà' ba, nə be'lə nà' bə ŋgàa tè'èŋkup wèŋ mvwe' mò'fis. Bwìiŋ nə sə waŋ, nə sə zʉ nzòŋ fo'. ");
INSERT INTO yam_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","<<Nùmbu ànə kə̀ ye fana gaŋ ŋkum sə̀ mʉbu sə nə ye co wàhaŋgwɛ̀ŋ sə̀ wo à ye hum yà'a. Wo à jə laàm awo, nə lo ŋgòkə̀ tək ndugù nə̀ yi sə və̀ ŋgòkə̀ jə lo ŋge' awo mòk nùmbu ànə. ");
INSERT INTO yam_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sə̀ tàŋ à ye ləm, sə̀ tàaŋ mok ye yàwo ŋgàa ŋkərə̀. ");
INSERT INTO yam_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sə̀ ləm sə wèŋ à jə laàm awo, nə kà kàràsi jə tse'. ");
INSERT INTO yam_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Sə̀ ŋgàa ŋkərə̀ sə wèŋ à jə tse' kɛ' lòkàràsi awo mok sənə botòrò. ");
INSERT INTO yam_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ndugù nə à ka və toho fana bàa sə wèŋ dzooŋ lo tə̀tè wo dzəmlo. ");
INSERT INTO yam_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","À kə̀ dzèŋ ntəntʉmtsok, wo to fuŋ də, <Ndugù nə və̀ laŋ, wèeŋ tesə və kə tseŋ yi.> ");
INSERT INTO yam_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bàa sə̀ hum sə lokok wo pwe', nə koksə laàm awo sə. ");
INSERT INTO yam_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sə̀ ləm sə dʉk fa sə̀ ŋgàa ŋkərə̀ sə də, <Wèeŋ fa a ves kàràsi awèŋ səmok bʉ̀ʉsə̀ laàm avès sə də a liiŋ.> ");
INSERT INTO yam_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sə̀ ŋgàa ŋkərə̀ sə wèŋ dʉk fəsə fa wo də, <Kàmòk yà'a nə kà bohòvesùwèŋ pwe'fo' kʉ̀rə̀. Bòlɛ co wèŋ lo kə ye bʉ̀ʉ sə̀ wo sə sèŋ sə, nə ywiŋ jəŋ yàwèŋ bohòwo.> ");
INSERT INTO yam_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wo à lòdə wo kə ywiŋ fana ndugù nə və. Ndugù nə jəŋ sə̀ wo à fʉ̀hʉ yàwo laŋ sə, bə yà'wèŋ ni lo mʉmvwe' ndap nə̀ wo sə zʉ gù mbwa nə. Wo à ni lòmbwa, wo ko jəŋ ncù lok mpʉ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","À cu ghàr, bàa mok sə wèŋ bwi və yàwo sə sə̀'. Wo təəŋ sə mbi, nə sə dʉhʉ də, <Tɛ̀'mòk, Tɛ̀'mòk, mùk fa ves ncù.> ");
INSERT INTO yam_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Yi dʉk fəsə gesə fa wo ca də, <Mʉ̀ sə cep yè'e ŋkèm dʉk də, mʉ̀ ka weŋ riŋ.> >> ");
INSERT INTO yam_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisòs à lə̀sə ncèp nə də, <<Ye də wèeŋ sə kʉk-a kʉ̀'ʉ, bʉ̀ʉsə̀ wèŋ ka nùmbu nə kè mvə̀k nə riŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","<<Gaŋ Nwì sə nə ye co mvə̀'nə̀ ŋwə̀ nəmòk à ye ŋga yi də yi lo gì fana yi to benə ŋgàa fàak ye wèŋ. Yi à to wo fana yi fa bum ye pwe'fo' ndzə bohòyà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yi fa mòk bàam mbàm tàŋ, nə fa mòk bàm ba. Yi fa ŋwə̀ nə̀ tɛ' ye bàm mbàm mò'fis. Yi à gàp fa yà'wèŋ yè'sə mvə̀'nə̀ yi riŋ də ŋàaŋ awo sə cu co ŋwè kotse' to sə̀ ye. Yi à fa wes wo vɛ'nə, yi bɛ' mandzə̀, nə lo yuye. ");
INSERT INTO yam_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ŋwə̀ nə̀ yi ànə tse' ye bàam mbàm tàŋ nə à lòntɛ̀ŋ, nə kə gi gìi ntɛŋ bə zeŋ. Yi tse' swe' mbwa sə̀' bàam mbàm tàaŋ mok. ");
INSERT INTO yam_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ŋwə̀ nə̀ yi à tse' ye bàam mbàm ba nə à kə tse' swe'e ye sə̀' bàam mbàm ba. ");
INSERT INTO yam_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nə̀ yi à jə ye bàm mò'fis nə à lò, nə kə tuŋ wʉ, nə ses lok gesə bàm mbàm ŋkwà' ŋwə̀ nə ca. ");
INSERT INTO yam_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","<<Mvə̀k ànə sap fana ŋkwà' ŋwə̀ nə bwìŋ və. Yi kə taŋsə ja'a yusə̀ wo a gʉ̀ bə mbàam sə. ");
INSERT INTO yam_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ŋwə̀ nə̀ yi à tse' ye bàam mbàm tàŋ nə à və̀ə, nə jə və bàam mbàam mok sə̀' tàŋ. Yi dʉk fa ŋkwà' ŋwə̀ nə də, <Tɛ̀'mòk, wù à fa mʉ bàm tàŋ, mʉ̀ a kə̀ tse' fe'lə mok bə zeŋ sə̀' bàm tàŋ.> ");
INSERT INTO yam_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ŋkwà' ŋwə̀ ye nə kwasə nà' də, <Wusùkù' mo àm-a', wù gʉ̀ bə̀boŋ. Wù nì tsə̀' zìnə yòbə mʉyu nə̀ nà'a momjo laŋ. Mʉ nə gʉ wu ŋga'a ŋgòtse' ŋàŋ mʉnə sə̀ yà'a ŋkʉ̀ʉŋ. Və̀ə kə̀ ròŋ ni' bə bum ŋkwà' ŋwə̀ yònə.> ");
INSERT INTO yam_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ŋwə̀ nə̀ yi à tse' ye bàm ba nə à və̀ ye sə̀'. Yi dʉk də, <Tɛ̀'mòk, wù a fa mʉ bàm ba. Yeè, mʉ̀ kə̀ tse' fe'lə və̀ mok bə zeŋ sə̀' bàm baa mok.> ");
INSERT INTO yam_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ŋkwà' ŋwə̀ ye nə kwasə nà' sə̀' də, <Wusùkù' mo àm-a', wù gʉ̀ bə̀boŋ. Wù nì tsə̀' zìnə yo bə yu nə̀ nà'a momjo laŋ. Mʉ nə gʉ wu ŋga'a ŋgòtse' ŋàŋ mʉnə sə̀ yà'a ŋkʉ̀ʉŋ. Və̀ kə̀ ròŋ ni' bə bum ŋkwà' ŋwə̀ yònə.> ");
INSERT INTO yam_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ŋwə̀ nə̀ yi à fa nà' ye bàm mò'fis nə à və̀ ye sə̀'. Yi dʉk fa ŋkwà' ŋwə̀ nə də, <Tɛ̀'mòk, mʉ̀ rì wu rìi də wu ŋwə̀ nə̀ wù gʉ wùriŋ. Wu kʉp zʉgə̀ mvwe' sə̀ wù à ka wù bi, nə kà fo' wù sə̀' fàk. ");
INSERT INTO yam_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mʉ̀ a wəp, fana nə kə tuuŋ mbàam yo sə sə nzehè. Yeè, mbàam yo sə yà'a yè'.> ");
INSERT INTO yam_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ŋkwà' ŋwə̀ nə yak nà' də, <Wù mo nə̀ bʉp ŋgà wɛ' mòk wà. Wù də wù riŋ də mʉ kʉp zʉgə̀ mvwe' sə̀ mʉ̀ à ka fo' bi, nə kà fo' sə̀' fàk, ka vɛ'nə yeŋ à? ");
INSERT INTO yam_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ànə boŋ ghak co wù noŋsə fa mʉ mbàam sə bohòbʉ̀ʉ sə̀ wo fàkgə̀ mʉmvwe' ŋgwa' yà'a. Ya mʉ bwìŋ və̀ə, mʉ tse' mʉswe' mʉnə mbàam am sə.> ");
INSERT INTO yam_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ŋkwà' ŋwə̀ nə də, <Wèeŋ jəŋ fis mbàam sə̀ bohòyi sə, nə fa ŋwə̀ nə̀ yi nə tse' bàam mbàm hum nà'a.> ");
INSERT INTO yam_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yi dʉk fe'lə də, <Ŋwə̀ nə̀ yi tse'-a, wo nə fa yamsə mok, ya yi tse' mok nduk nə̀ nduk. Nə ye də bohòŋwə̀ nə̀ yi ka ye yumok tse' nə, a mègù-a sə̀ mʉyu nə̀ jo nə̀ yi tse' nà' nə, wo nə jəŋ fis gɛsə nà' ndzə bohòyi anə fo'. ");
INSERT INTO yam_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wèeŋ ko jəŋ ŋgà fàk nə̀ bʉp ènə, nə mak gesə lo yi mvwe' sə̀ ndzəm sə kɛ̀ŋ sə mbi yà'a. Bwìiŋ nə sə waŋ, nə sə zʉ nzòŋ ca.> ");
INSERT INTO yam_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","<<Ghà nə mo ŋwèe kə̀ və̀ nùu bə masinjàa ye fana yi kə kok cum mʉnə kapràak ye bə ŋàaŋ ŋkum wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bʉ̀ʉ sə̀ sənə nzeŋgònə pwe' nə kə benə kə̀ mantombìi yi. Wo benə vɛ'nə yi gapsə wo co ganakù' sə gapsə fis ndzə bə nsùŋgaŋ. ");
INSERT INTO yam_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yi nə tes nsùŋgaaŋ sə bo ma màk, nə tes ndzə bo ma ŋkwìp. ");
INSERT INTO yam_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Fana yi nə̀ yi ŋkum nə, nə dʉk fa sə̀ bo ma màk sə wèŋ də, <Wèeŋ və. Tɛ̀' am a sè weŋ yi. Wèeŋ və kə ni cum mvwe' gaŋ ŋkum Nwì sə̀ wo à fʉ̀hʉ noŋsə fa weŋ ŋga wo ka nzeŋgònə ntòfʉk sə. ");
INSERT INTO yam_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bʉsə̀ njè à sə ya mʉ, wèŋ fa mʉ zʉzʉ. Ntʉm à sə sə mʉ, wèŋ nə fa mʉ ndzəp. Mʉ̀ à ye ŋkʉ̀ìŋ, wèŋ nə nisə mʉ mʉ nda'à wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mʉ̀ à ye nswɛ̀'mbwè, wèŋ fa mʉ cə̀k. Mʉ̀ à nòoŋ yiyaŋ, wèŋ sə kə tɛsə mʉ. Mʉ̀ à cu mʉ ndapndzəmə̀, wèŋ sə kə cepsə mʉ.> ");
INSERT INTO yam_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Bʉ̀ʉ sə̀ kə̀kʉrə̀ yà'sə wèeŋ nə cep fəsə fa yi də, <Vès ànə ye wu yè'sə sè ŋga njè sə ya wu, vès nə fa wu zʉzʉ-ɛ Tà? Kè də ŋga ntʉm sə sə wu, vès nə fa wu ndzəp-ɛ? ");
INSERT INTO yam_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wù ànə ye ŋkʉ̀ìŋ fòŋkuŋ vès nisə wu mʉ ndà'à-nɛ, kè də wù ànə ye nswɛ̀'mbwè sè ŋkuŋ vès nə fa wu cə̀k-ɛ? ");
INSERT INTO yam_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nə ye sə̀' də vès ànə ye wu yè'sə ma fòŋga wù sə yayaa, kè ŋga wù cu mʉ ndapndzəmə̀ ŋkuŋ vès kə cepsə wu-ɛ?> ");
INSERT INTO yam_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yi nə cep fəsə fa wo də, <Mʉ̀ sə cep yè'e kek də, bum sə̀ wèŋ à gʉ̀ fa-a bè'lə bwema am yè'e, ye də wèŋ à gʉ̀ fa yà'sə bohòmʉ̀.> ");
INSERT INTO yam_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Fana mʉ yi dʉk fa bʉ̀ʉ sə̀ bo ma ŋkwìpə yi sə wèŋ də, <Coho gɛsə ŋgʉ ni'ì mʉ̀ fo', wèŋ sə̀ Nwì a naaŋ fa weŋ ŋgə' mʉ tuhù. Wèeŋ du sə mvwe' mis nə̀ wo à gʉ̀ nòŋsə fa ze' nə bə masinjàa ye wèŋ nà'a. ");
INSERT INTO yam_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Njè à sə ya mʉ, wèŋ kà mʉ bɛŋ fa. Ntʉm sə sə mʉ, wèŋ kà mʉ ndzəp sə̀' fa. ");
INSERT INTO yam_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mʉ̀ à ye ŋkʉ̀ìŋ, wèŋ kà mʉ mʉ nda'à wèŋ nisə̀. Mʉ̀ ye nswɛ̀'mbwè, wèŋ kà mʉ cə̀k fa. Mʉ̀ sə yaŋ nə ye ŋgà ndapndzəm, wèŋ kà mʉ kə̀ cèpsə̀ lok.> ");
INSERT INTO yam_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Fana wo nə cep fəsə fa yi sə̀' də, <Tà, ànə ye yè'sə sè nə̀ vès à yə wu ŋga njè sə ya wu, kè ŋga ntʉm sə sə wu, kè ŋga wu ŋkʉ̀ìŋ vès kà wu mʉ nda'à vès nisə̀-ɛ? Kènə à ye fònə̀ vès à yə wu ŋga wu nswɛ̀'mbwè, kè ŋga wù sə ya, kè ŋga wù cu ndapndzəm vès kà wu kə̀ cèpsə̀-ɛ?> ");
INSERT INTO yam_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yi dʉk fəsə fa wo də, <Mʉ̀ sə cèp yè'e kek nə̀ kek də, wèŋ ànə ka-a bohòbè'lə̀ moma am nə̀ mò'fis gʉ fa, ye də wèŋ à ka mʉ yà'sə gʉ fa.> ");
INSERT INTO yam_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bʉ̀ʉ yà'sə nə lo sənə ŋgə' nə̀ nà'a kà mègə̀. Bʉ̀ʉ sə̀ wo à sə bɛ' yàwo mandzə̀ Nwì, lo yàwo mvwe' lùŋ nə̀ nà'a nə̀ kà mè yuk.>> ");
INSERT INTO yam_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ghà nə̀ Jisòs ànə tsok wes fa wo bum yè'sə pwe' fana yi bʉʉŋ dʉk fa ŋga'a bohòŋgàa fàak ye wèŋ də, ");
INSERT INTO yam_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<Wèŋ rìŋ də bwehe cu mègù mok nùumbu ba ya ŋkàk Pasobà nə kə dzeŋ. Mvə̀k ànə ye, wo nə fa mʉ̀ʉ mo ŋwè də wo tɛ'lə mʉ mʉntə̀əŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sə̀' mvə̀k ànə, ŋgàa fa satikà' sə̀ ghaŋ bə bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ kə be'lə mʉ ntòmbìi Kayofàs. Kayofàs nə à ye ŋkum ŋgàa fa satikà'. ");
INSERT INTO yam_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Wo à cèp tes fo' mvə̀'nə̀ wo nə borə ko Jisòs, nə zə yi. ");
INSERT INTO yam_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wo dʉk fe'lə sə̀' dʉk də, <<Kaco vesùwèŋ ko yi nùmbu ŋkàk yeŋ, bʉ̀ʉsə̀ bwìŋ nə gham vesùwèŋ ŋga'a.>> ");
INSERT INTO yam_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","À ye ŋga'a ŋga Jisòos mvwe' lak Betanì. Fana yi lo kə cum mʉ nda'à Saimʉ̀ nə̀ yiya kuturu à ko yuk yi mantombì. ");
INSERT INTO yam_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ŋwà nəmòk nikok bə ndo làmindà nə̀ nà' gʉ ntɛŋ vɛ'ɛ wùriŋ. Ŋwà nə jəŋ yà', nə kɛ' tsoŋ fa Jisòs mʉtuhù ŋga yi cu sə zʉ bɛŋ. ");
INSERT INTO yam_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ŋgàa fàak ye wèŋ à yə vɛ'nə fana wo jok də ŋwà nə kɛ̀' bʉpsə yà' vɛ'nə bʉ̀ʉ yàlɛ. ");
INSERT INTO yam_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wo də anə ye co wo seŋ làmindà sə mbàm wùriŋ, nə fa ŋgàa jìŋ wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisòs à rì yusə̀ wo à sə cèp sə, nə dʉk fa yà'wèŋ dʉk də, <<Wèŋ sə fa ŋwà ènə ŋgə' vɛ'nə bʉ̀ʉ yà? Yusə̀ yi gʉ̀ bohòmʉ̀ yè'sə, a bə̀boŋ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wèeŋ nə̀ sə ye maligə̀ ŋgàa jìŋ fo', mʉ nə kà yàm vesùwèŋ cu malì. ");
INSERT INTO yam_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mvə̀k nə̀ yi kɛ̀' tsə fa mʉ làmindà yè'sə mʉni'ì vɛ'nə, yi sə gʉ̀ tsərə yà'sə ŋgùpni' àm nə mvə̀'nə̀ wo nə tuuŋ nà'. ");
INSERT INTO yam_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mʉ tsok fa weŋ ncèp nə̀ nà'a ŋkèm dʉk də, mvwe' sə̀ fòpwe' sə̀ wo nə̀ tsoho Ntirə̀ nə̀ Bə̀boŋ nə sənə nzeŋgònə fana yusə̀ yi gʉ̀ yè'sə wo nə̀ sə tsərə maligə̀ yi bʉ̀ʉ zeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yà'a ŋga'a mvə̀k nə̀ Judàs Iskarəyà nə̀ yi sə̀' mòk mʉŋgorə̀ ŋgàa fàak ye sə̀ hum-ncòp-ba sə à lòo, nə kə ye ŋgàa fa satikà' sə̀ ghaŋ wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Yi fek yà'wèŋ də, <<A ye-a ŋga mʉ̀ ko fa weŋ Jisòs nə, wèŋ fa mʉ yà?>> Wo à làk fa yi mbàm hum tɛ' fo' ndzə bohò. ");
INSERT INTO yam_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","À nə yè jəŋ ŋga'a mvə̀k ànə nə lo mantombì, Judàs sə lap mandzə̀ ŋgòsèŋ Jisòs. ");
INSERT INTO yam_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","À kə̀ dzèŋ nùmbu nə̀ wo à yèto ŋkàk nə̀ wo zʉgə̀ brɛd sə̀ jì yis yà'a fana ŋgàa fàak Jisòs wèŋ və nə kə fek nà' də, nà' dzəm də nà'a nə zʉ ŋkàk nə ma fòlɛ, ya wo kə gʉhʉ tsə'rə mvwe' sə. ");
INSERT INTO yam_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yi dʉk fa yà'wèŋ dʉk də, <<Wèeŋ du ndzə ntòlak, nə dʉk fa ŋgà' nà'a dʉk də, <Cicà də mvə̀k ye kʉ̀rə laŋ, yi bə ŋgàa fàak ye wèeŋ nə zʉ ŋkàk Pasobà mʉnda'à wù.> >> ");
INSERT INTO yam_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ŋgàa fàak ye sə wèŋ à kə̀ gʉ̀ sə̀' mvə̀'nə̀ Jisòs dʉk wo sə. Wo fʉhʉ zʉzʉ Pasobà sə̀ fo'. ");
INSERT INTO yam_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nùm à co, yi bə ŋgàa fàak ye sə̀ hum-ncòp-ba sə wèŋ lo ŋgòzʉ zʉzʉ. ");
INSERT INTO yam_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wo ànə sə zʉ fana yi dʉk fa yà'wèŋ dʉk də, <<Mʉ̀ sə tsə̀' weŋ nè'e ŋkèm dʉk də ŋwə̀ nə̀ mò'fis mʉtsətsə'rə wèŋ fɛɛŋ nə seŋ mʉ.>> ");
INSERT INTO yam_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wo à yuk vɛ'nə, manziŋ ko wo vɛ'ɛ wùriŋ. Wo ye ŋgòfek yi mò'fis, mò'fis, dʉk də, <<Tà, a mʉ̀ à?>> ");
INSERT INTO yam_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yi dʉk fa yà'wèŋ də, <<Ŋwə̀ nə̀ yi fa kʉ̀rə tsə bo ye bə yàm sənə zʉzʉ, a yi nə̀ yi nə seŋ mʉ nə. ");
INSERT INTO yam_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mʉ̀ mo ŋwè, mʉ nə kpʉ lo mvə̀'nə̀ ŋwàk Nwì sə dʉk. Fana ŋgə' nə̀ bʉp cu bohòŋwə̀ nə̀ yi seŋ mʉ ànə. Ànə boŋ ghak bohòŋwə̀ ànə co wo kà yi dzə lok.>> ");
INSERT INTO yam_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judàs nə̀ nà' à sè yi nə fek ye sə̀' də, <<Cicà, a mʉ̀ à?>> Jisòs dʉk fa nà' də, <<Wù cèp mʉmvə̀'nə.>> ");
INSERT INTO yam_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wo ànə sə zʉ fana Jisòs jəŋ brɛd, nə kwasə Nwì, nə bə'rə fa ŋgàa fàak ye sə. Yi dʉk də, <<Wèeŋ jəŋ, nə zʉ. Nè'e ŋgùpni' àm.>> ");
INSERT INTO yam_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ànə geŋ yi jəŋ ŋgàp sə̀'. Yi ànə kwasə wes me Nwì fana yi fa yà'wèŋ də yà'a no. Yi à fa yà' yi sə cep də, <<Wèeŋ no wèŋ pwe'. ");
INSERT INTO yam_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yè'sə ndʉəm am sə̀ yà' sə fè'e ŋgòswì fa bwìŋ bʉp awo. Ndʉəm sə, a zeŋ sə̀ yà' kì ŋge' ndzənə rʉ̀k nə̀ njàm bohòbwìŋ ŋkʉ̀ʉŋ. ");
INSERT INTO yam_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mʉ̀ tsə̀' weŋ də mʉ nə kà rùuk yè'sə vesùwèŋ mok no be'lə̀ yuk tə̀tè nùmbu nə̀ mʉ nə no fe'lə nà' mok fi vesùwèŋ mvwe' gaŋ ŋkum Tɛ̀' àm.>> ");
INSERT INTO yam_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Fana wo yəm ŋkì, nə tesə lo mvwe' nda Olìp. ");
INSERT INTO yam_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ànə geŋ Jisòs tsok fa yà'wèŋ də, <<Bə ndzəm nə̀ ntinə nè'e, wèŋ pwe' nə caŋ me'rə mʉ mʉmʉ̀. Mʉ̀ rìŋ vɛ'nə bʉ̀ʉsə̀ yà' cu ndzənə ŋwàk Nwì də, <Mʉ̀ʉ Nwì, mʉ nə ləp ganakù' nə fana nsùŋgaaŋ sə nə sam wes.> ");
INSERT INTO yam_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Anə ye sə̀' də ghà nə̀ mʉ nə lokok mvwe' kpʉ, mʉ nə lo mantombìi wèŋ mvwe' nzeŋgòŋ Galìli.>> ");
INSERT INTO yam_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yi ànə dʉk vɛ'nə fana Pità cep fəsə fa nà' dʉk də, <<A ye-a ŋga bwìŋ pwe' ca me'rə-a wu sə̀ ca, mʉ nə kà wu yàm ca me'rə yuk.>> ");
INSERT INTO yam_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisòs dʉk fa yi də, <<Mʉ tsok wu ŋkèm dʉk də, bə ndzəm nə̀ ntinə nè'e, ntomvəp sə kə̀ to kàmòk ŋga wù də wù ka mʉ riŋ kɛ̀' tɛ'.>> ");
INSERT INTO yam_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pità nə cep fe'lə sə̀mok dʉk də, <<A mègù-a sə̀ ŋgòkpʉ vesù, kaco mʉ̀ bɛŋ wu yeŋ.>> Ŋgàa fàak ye mok sə wèŋ dʉk sə̀' vɛ'nə, wo pwe'. ");
INSERT INTO yam_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ànə geŋ, Jisòs bə bwe ye sə wèŋ lo mvwe' səmok sə̀ wo togə̀ fo' də Gèsemanì. À kə̀ dzèŋ fo', yi dʉk fa yà'wèŋ dʉk də, <<Wèeŋ cum yàwèŋ mvwe' yè'e ya mʉ sooŋ lo yàm mantombì, nə gʉ pìriyà.>> ");
INSERT INTO yam_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Fana yi jəŋ Pità nə ye bwe Zebèdi ba sə̀', wo lo. Ghà ànə à ye, ntʉm ye ŋgòrwì' yi vɛ'ɛ, yi kà kwəkwa mok tse' lok. ");
INSERT INTO yam_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yi dʉk fa yà' dʉk də, <<Tsətsərə̀ nə̀ bə manziŋ sə ntʉʉ̀ mʉ̀ nə̀ bʉp co mʉ̀ coho gbʉ kpʉ. Vesùwèeŋ cum fɛɛŋ, nə sə so, nə kà lo dzəm.>> ");
INSERT INTO yam_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yi ànə sooŋ lo momjo fana yi gbʉ fə'ə gesə lo si ye sə nze, nə sə gʉ pìriyà. Yi sə cep dʉk də, <<Tɛ̀' àm, a ye-a ŋga mandzə̀ə yo, wù jəŋ gesə lo ŋgàp ŋgə' nè'e bohòmʉ̀ fo'. Mʉ dʉk-a sə̀ vɛ'nə, wù gʉ lɛ mʉmvə̀'nə̀ wù dzəm wù, kà mʉmvə̀'nə̀ mʉ̀ dzəm mʉ̀ gʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ànə geŋ yi bwi foho və, nə kə ye ŋgàa fàak ye sə̀ tɛ' sə ŋga wo sə dzəm lo. Yi yəmsə yà', nə fek Pità də, <<Kaco wèŋ cum to nca vesùwèŋ mvə̀k mwejo yeŋ à? ");
INSERT INTO yam_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Wèeŋ so, nə sə gʉ pìriyà sə̀' ya mə̀mumsə̀ə kà wèŋ gha'. Ntʉm yo, megu də ŋàŋ ka yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yi lo fe'lə sə̀mok ŋgòkə̀ gʉ̀ pìriyà nə̀ kɛ̀' ba. Yi lɛŋ də, <<Tɛ̀' am, a ye-a ŋga wù dʉk də kaco yè'sə ca gɛsə yeŋ tse'ŋga mʉ̀ yə ŋgə' nə ŋkuŋ, fana mʉ̀ dzəm sə̀' cùu yo sə.>> ");
INSERT INTO yam_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ànə geŋ yi bwi foho və fe'lə, nə kə tseŋ yà' ŋga yà' sə dzəm fe'lə sə̀ lo sə. Ànə ye ŋga lo sə ko zə̀m tse' wo lis vɛ'ɛ nsàp nə̀ bə jòŋ. ");
INSERT INTO yam_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Fana yi me'rə fe'lə yà'wèŋ, nə lo ŋgòkə̀ gʉ̀ fe'lə pìriyà sə̀mok nə̀ kɛ̀' tɛ'. Yi sə cep fe'lə gu sə̀' yusə̀ yi anə cep to mantombì. ");
INSERT INTO yam_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yi bwi və fe'lə bohòŋgàa fàak ye sə wèŋ, nə fek yà'wèŋ dʉk də, <<Wèŋ sə nòoŋ yòŋsə malì yu awèŋ fo' à? Wèeŋ ye, mvə̀k kʉ̀rə laŋ nə̀ wo sèŋ mʉ̀ʉ mo ŋwè, mʉ̀ cu mok ndzə bohòbʉ̀ ŋgàa gʉ̀ bʉp wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wèeŋ lokok a lo. Yeè, ŋwə̀ nə̀ yi sèŋ mʉ nə nè'.>> ");
INSERT INTO yam_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","À ye ŋga Jisòs sə cèp malì ntòfo', fana Judàs nə̀ yi ŋgà fàk ye mòk sə̀' nə tesə və bə bʉ̀ʉ səmok vɛ'ɛ wùriŋ ŋga wo rə̀p fèk, nə tse' ntòk. À nə tumsə wo ŋgàa fa satikà' sə̀ ghaŋ bə bʉ̀ʉ sə̀ mantombì. ");
INSERT INTO yam_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ànə ye ŋga ŋwə̀ nə̀ yi ànə seŋ Jisòs nə nə tsok noŋsə fa bʉ̀ʉ sə wèŋ yusə̀ yi nə gʉ laŋ. Yi à dʉk fa yà' də, yà'a yə ŋwə̀ nə̀ yi kə cèpsə nà' bə̀boŋ co ŋge' à lɛ, yà' riŋ də nà'a yi nə, yà' ko nà'. ");
INSERT INTO yam_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judàs nə à və̀ə, yi cà jwaŋ, nə kə ye Jisòs, nə to nà' də <<Cicà, mʉ̀ cepsə wu>> fana nə cepsə nà' co ŋge'. ");
INSERT INTO yam_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisòs fek nà' də, <<Ŋge' àm, wù sə gʉ̀ fɛnə yà?>> Fana bʉ̀ʉ sə wèŋ kə koho tse' Jisòs cʉ̀k. ");
INSERT INTO yam_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ŋwə̀ nəmòk nə̀ yi à ye ye bə Jisòs nə wèŋ à sə̀ co'fis fèk ye, nə gbɛ' tiŋ mak fa ŋkwɛ̀ŋ mòk ntu' sə nze. Ŋwə̀ nə̀ wo à gwɛ̀' ci' yi ntu' nə à ye ŋkwɛ̀ŋ bohòŋkum ŋgà fa satikà'. ");
INSERT INTO yam_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jisòs dʉk fa nà' dʉk də, <<So fəsə gesə fèk nə mà mba'à. Wù rì də ndàaŋwè pwe' nə̀ yi lʉ̀-a bə fèek nə kə̀ kpʉ sə̀' bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wù tsəm də kaco mʉ̀ dʉk fa to tɛ̀' àm də yi tumsə fa mʉ masinjàa ye, bòop sə̀ ghaŋ hum-ncòp-ba ŋgòtɛsə mʉ yeŋ à? ");
INSERT INTO yam_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nə ye də wo à còm nòŋsə ndzənə ŋwàk Nwì də bum yè'sə nə ye tsoŋ vɛ'nə. Mʉ to bwìŋ-a ŋga'a masinjàa Nwì, bum yè'sə ye fe'lə zìnə anə va?>> ");
INSERT INTO yam_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mvə̀k ànə à ye, Jisòs fek bʉ̀ʉ sə wèŋ də <<Wèŋ tesə co wèŋ lòmvwe' bɛ' ŋgà yə̀ bə fèk nə ye ntòk yè'e bʉ̀ʉ mʉ̀ à? Vesùwèeŋ yiskokgə̀ mʉmvwe' ndap Nwì nə̀ ghaŋ səsa, mʉ̀ sə yə'rə bwìŋ, wèŋ kà mʉ ko. ");
INSERT INTO yam_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nə ye də bum yè'sə vɛ'nə pwe'fo' də ya yusə̀ ŋgàa tsòhòbum Nwì wèŋ à còm ndzənə ŋwàk Nwìi ye vɛ'nə.>> Yà'a ŋga'a mvə̀k nə̀ ŋgàa fàak ye sə wèŋ à mè'rə yi, nə caŋ lo wes pwe'. ");
INSERT INTO yam_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Fana bʉ̀ʉ sə̀ wo à ko Jisòs sə à jə lòyi bohòKayofàs, ŋkum ŋgà fa satikà' nə. Bʉ̀ ŋgàa yə'rə̀ fa bwìŋ lʉ̀k bə bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ à benə cu sə̀' fa'nə. ");
INSERT INTO yam_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pità à sə yù və̀ maŋkwɛ̀ŋ moòm sə̀sap tə̀tè kə dzeŋ mvwe' ntòmbi ŋkum ŋgà fa satikà' nə̀ wo də wo nə sak fo' nə. Yi ni lo mbwa, nə kə cum bə ŋgàa kʉ̀k ndap Nwì wèŋ ya yi ye mvə̀'nə̀ bum nə kə lə. ");
INSERT INTO yam_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ŋgàa fa satikà' bə kaŋsurù nə pwe' à sə làp bum sə̀ ŋgònaaŋ mʉ tuhù Jisòs də ya wo zə nà', dzəm ŋga yà'a mvwès. ");
INSERT INTO yam_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wo kà yumok sə̀ yə. Bʉ̀ʉ sə̀ wo à ka yumok sə̀ ye, nə sə kə dzəm borə də wo à yə laŋ wèŋ à ye fo' sə̀' wùriŋ. À kə lə̀ə, ŋgàa ci' mvwèes yè'sə wèŋ à tesə və̀ bwìŋ ba, ");
INSERT INTO yam_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nə dʉk də, <<Vès a yuk bə ntu' avès ŋga ntèrə̀ŋgòŋ nè'nə sə dʉk də, aco yi kʉəmsə mak ndap Nwì nə̀ ghaŋ nə, nə ci wes megu nà' mʉnə nùumbu tɛ'.>> ");
INSERT INTO yam_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ŋkum ŋgà fa satikà' nə à lòkok mʉtsə̀, nə fek Jisòs də, <<Wù ka yumok ŋgòcèep tse' à? Bʉ̀ʉ yè'e sə dʉk də wù a dʉk də ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jisòs cum megu dədok. Ŋgà fa satikà' nə cep fe'lə də, <<Mʉ̀ sə fek wu bə liŋ Nwì nə̀ yi ŋwəm nə zìnə də, wu yè'e mo Nwì, ŋkum ŋgà gèm bwìŋ nə à?>> ");
INSERT INTO yam_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisòs dʉk fa nà' də, <<Wù cèp yà'sə mvə̀'nə. Mʉ̀ sə tsə̀' weŋ zìnə də, ghà nə̀ bum yè'sə mè fana wèŋ ye mʉ̀ʉ mo ŋwè ŋga mʉ cu nze bo ma mà'a Nwì nə̀ ŋgà ŋàŋ, nə ye fe'lə mʉ ŋga mʉ̀ sə tsə və ndzənə mbàk mʉbu.>> ");
INSERT INTO yam_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yi ànə dʉk wes vɛ'nə fana ŋkum ŋgà fa satikà' nə jok, nə soŋ sarə cə̀k nə̀ mʉ ni'ì yi. Yi sə dʉk də, <<Jisòs də nà'a mo Nwì, ye də nà' bʉpsə liŋ Nwì laŋ. Njo nə̀ a lap yis fe'lə ŋwə̀ nəmòk ŋgòkə̀ rɛŋsə fe'lə yumok ka mok yeŋ. Bʉsə̀ bwìŋ yuk wes mvwèes nà' sə mok bə ntu' laŋ. ");
INSERT INTO yam_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Wèŋ dʉk yàwèŋ də yà?>> Bʉ̀ʉ sə wèŋ dʉk də, wo zə mègù yi zəə. ");
INSERT INTO yam_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Fana wo te gesə fa yi nte mʉlisə̀, nə ləp yi. Bʉ̀ʉ mok sə̀ wo à ləp yi sə wèŋ à sə dʉk də, ");
INSERT INTO yam_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","<<Wù də wu Ŋkum ŋgà gèm bwìŋ nə wù, riŋ-a ŋgə̀ŋgàŋ ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ànə ye ŋga Pità cu ye sə mbi fana mʉŋwà nəmòk kə dʉk fa yi də, <<Wù yegə̀ sə̀' weŋ Jisòs nə̀ mvwe' lak Galìli nə.>> ");
INSERT INTO yam_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yi bɛ̀ŋ mantombìi wo anə pwe' də yi ka yusə̀ yà' sə cèp yà'sə riŋ lok. ");
INSERT INTO yam_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yi ànə tesə tsoŋ fa'nə ntɛ̀ŋ, mʉŋwà mòk ye fe'lə yi, nə tsok fa bʉ̀ʉ sə̀ wo tə fo' sə wèŋ də, <<Ŋwə̀ nè'e a ye sə̀' bə Jisòs nə̀ mvwe' lak Nazàrɛ nə.>> ");
INSERT INTO yam_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yi bɛŋ fe'lə nà' sə̀mok, nə kɛŋ də yi ka Jisòs riŋ. ");
INSERT INTO yam_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ànə sap kok ghàr fana bʉ̀ʉ sə̀ wo nə təəŋ fo' sə wèŋ kə dʉk fa Pità nə də nà' gù tsə gù lɛ mòk. Də mvə̀'nə̀ yi sə cep àlɛ, ncèp cù nà' nə sə nìtsə̀' jəja də nà'a mòk. ");
INSERT INTO yam_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yà' à bà vɛ'nə, fana Pità yak ni' ye, nə kɛŋ mok Nwì də, <<Nwìi riŋ yi, mʉ̀ ka ŋwə̀ ànə riŋ.>> Yi à sə cèp wes ntɛ̀ŋ, mvəp to. ");
INSERT INTO yam_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pità tsərə ŋga'a yusə̀ Jisòs ànə cep sə də, <<Ŋkuŋ ntomvəp nə sə to ntinə ŋga wù bɛ̀ŋ fis mʉ kɛ̀' tɛ' də wù ka mʉ riŋ.>> Yi tesə lo sə mbi, nə kə waŋ ca vɛ'ɛ nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nə̀ zəzòŋ à dzèeŋ, ŋgàa fa satikà' sə̀ ghaŋ bə bʉ̀ ŋkwàha bʉ̀ʉ Jus sə wèŋ cum kwe' də wo zə Jisòs. ");
INSERT INTO yam_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wo ko kiŋ yi, nə jəŋ lo fa bohòPalè nə̀ yi ànə ye govənòghà ànə yi nə. ");
INSERT INTO yam_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judàs nə̀ yi à sèŋ Jisòs nə à yə də wo bʉpsə Jisòs fana ntʉm ye bʉʉŋ. Yi və ŋgòfəsə mbàam sə̀ hum tɛ' sə̀ yi à sèŋ Jisòs bə zeŋ sə. Yi à jə və̀ yà' ŋgòfa fəsə bohòŋgàa fa satikà' nə ye ŋkwàha bʉ̀ʉ sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yi à dʉk də, <<Mʉ̀ gʉ̀ bʉp laŋ bʉ̀ʉsə̀ mʉ̀ gʉ̀ də wo zə ŋwə̀ nəmòk ŋgwàŋ ŋga yi ka yumok riŋ lok.>> Bʉ̀ʉ sə wèŋ dʉk fa yi də, <<Yà'sə ka nzak njàvès yeŋ. Wù rì bə zeŋ wù.>> ");
INSERT INTO yam_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yi lo, nə kə mak noŋsə mbàam sə̀ hum tɛ' sə mʉmvwe' ndap Nwì nə̀ ghaŋ nə sə nze. Yi lo, nə kə jəŋ kʉ̀, nə kə kə'ə kpʉ yuye. ");
INSERT INTO yam_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ŋgàa fa satikà' sə wèŋ à kə̀ te' mbàam sə, nə dʉk də, <<Yè'e mbàam ndʉəm ŋwè, fana kaco a gesə yà' sənə bàam mbàam sə̀ mʉnə ndap Nwì yeŋ bʉ̀ʉsə̀ wo dzə̀gə̀ dzə̀ə.>> ");
INSERT INTO yam_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wo à cu kwe', nə jəŋ mbàam sə, nə fa bohòŋgà bom kʉ̀ŋ mòk ŋgòywiŋ jə mvwe' sə̀ wo nə sə tuuŋ ŋkʉ̀ìŋ wèŋ fo'. ");
INSERT INTO yam_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nà'a njo nə̀ wo togə̀ mʉmvwe' ànə də mvwe' nze ndʉəm haaŋ ntinə sə. ");
INSERT INTO yam_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bum yè'sə ànə ye vɛ'nə fana bum sə̀ Jèrèmiyà ŋgà tsòhòbum Nwì à cèp sə bʉʉŋ və zìnə. Yi ànə cep də, <<Wo jə mbàm hum tɛ', mbàam sə̀ bʉ̀ʉ Izùrɛ wèŋ a dzəm də ntɛŋ ŋwèe nə kʉ̀rə vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Wo kə ywiŋ nze bohòŋgà bom kʉ̀ŋ bə zeŋ. Wo à sə ywiŋ vɛ'nə ŋga Tà Nwì à tsə̀' mʉ yi.>> ");
INSERT INTO yam_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisòs ànə təəŋ kə̀ mantombìi Palè nə̀ yi govənònə fana yi fek Jisòs də, <<Wu ŋkum bʉ̀ʉ Jus wèŋ wu à?>> Jisòs cep fəsə fa nà' dʉk də, <<Wù dʉk yà'a mvə̀'nə.>> ");
INSERT INTO yam_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nə ye də mvə̀k nə̀ ŋgàa fa satikà' bə bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ à sə làp yi bə nzak pwe', yi kà cù mùk lok fʉ̀'. ");
INSERT INTO yam_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mvə̀k nə̀ yi à sə cu mègù dədok vɛ'nə fana Palè fek nà' də, <<Wù sə kà bum ŋkʉ̀ʉŋ sə̀ wo sə cèp mʉtuhù wù yè'e yuk à?>> ");
INSERT INTO yam_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jisòs à ka cù ŋgòcèp fəsə muk mali, fana govənònə à mərə vɛ'ɛ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","À sə yegə̀ lə̀lùm mvə̀k ŋkàak Pasobà fana govənònə sə fis me'rə fa bʉ̀ʉ sə wèŋ ŋgà ndapndzəm mò'fis. Yi fis fa megu yà'wèŋ ŋwə̀ nə̀ wo dzəm də yi fis me'rə. ");
INSERT INTO yam_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ànə geŋ ŋga wo tse' ŋgà ndapndzəm mòk nə̀ liŋ yee də Bàrabà. Bwìŋ ŋkʉ̀ʉŋ à rì Bàrabà nə də yi ŋgà ndapndzəm nə̀ bʉp. ");
INSERT INTO yam_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wo ànə kə benə mvwe' mò'fis fana Palè fek wo dʉk də, <<Wèŋ dzəm də mʉ fis me'rə fa weŋ ndà? Bàrabà kè Jisòs nə̀ wo to yi mok də Krɛst nà'a nɛ?>> ");
INSERT INTO yam_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bʉsə̀ yi rì də wo ko jə və̀ Jisòs bohòyi yè'sə ŋga wo à sə bɛ̀ŋ nà' jì njo. ");
INSERT INTO yam_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sə va' mwè, ghà nə̀ Palè nə à cu mʉmvwe' dzə̀' ye nə̀ yi sakgə̀ nzak mbwa nə fana ŋgwe ye tirə vesə fa yi ntirə̀. Ntirə̀ nə à ye də, <<Kà də wu gʉ ŋwə̀ nə̀ yi ka jòŋ tse' ànə yumok dʉk. Mʉ̀ yə nòoŋ lo sə̀ bʉp bʉ̀ʉ yi ntinə wùriŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ŋgàa fa satikà' bə bʉ̀ ŋkwàha bʉ̀ʉ sə wèŋ sə gʉ megu bwìŋ də yà'a dzəm də wo fis me'rə Bàrabà, nə zə Jisòs. ");
INSERT INTO yam_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Govənònə fek fe'lə yà' sə̀mok də, <<Mʉtsətsə'rəə bwìŋ ba yè'e, wèŋ dzəm də mʉ fis me'rə fa weŋ nə̀ fò?>> Bʉ̀ʉ sə pwe' kwi' də <<Bàrabà.>> ");
INSERT INTO yam_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Palè fek fe'lə yà'wèŋ də, <<Wèŋ dzəm də mʉ gʉ bə Jisòs nə̀ wo togə̀ liŋ ye mok də Krɛst nà'a va?>> Bʉ̀ʉ sə pwe' dʉk də, <<Tɛ'lə yi mʉ ntə̀əŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yi də bʉ̀ʉ yà, ŋwə̀ ènə bʉpsə yà? Kàyà', wo sə fuŋ ghaha fuu də, <<Tɛ'lə yi mʉ ntə̀əŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Palè ànə ye də bum sə̀ yi sə cèp sə pwe' sə cà mègù wà co ndzəp, nə sə yəəŋ sə̀' co də ndàaŋ nə tesə fana yi jəŋ ndzəp, nə cuk bo ye mantombìi bʉ̀ʉ sə wèŋ. Yi à sə cùk yà', yi sə kəa njo nje də, <<Bo am ka sənə ndʉəm ŋwə̀ nè'e yeŋ. Wèŋ rì bə zeŋ wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yi ànə dʉk vɛ'nə fana bʉ̀ʉ sə wèŋ pwe'fo' dʉk də, <<Ŋ̀, ndʉəm yee ye mʉ tuhù vès nə ye mʉ tuhù bwe avès wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yi jəŋ Bàrabà, nə fis me'rə fa yà'wèŋ. Yi ləp Jisòs bə ŋkwɛ̀s, nə fa wo də wo kə tɛ'lə nà' mʉ ntə̀əŋ. ");
INSERT INTO yam_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sojàa govənònə wèŋ jəŋ lo Jisòs mʉ nto' govənòanə, nə to benə sojàa mok sə fo' lòoŋ. ");
INSERT INTO yam_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wo fweŋ fis cə̀ək ye, nə ni fa yi mòk nə̀ bə̀baŋ. Cə̀k nə à ye bə̀baŋ co cə̀k ŋkum. ");
INSERT INTO yam_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Wo lim ndik nəmòk nə̀ bə njàk co tàm ŋkum, nə ta fa yi nà' mʉ tuhù. Wo fa yi ntatʉ mòk də yi kotse' ndzə bohòco ntʉmbà ŋkum. Wo sə kə təəŋ mantombìi yi bə tumfərə, nə sə cepsə nà' co ŋkum dʉk də, <<Ŋgə̀ə̀, ŋkum bʉ̀ʉ Jus wèŋ.>> Wo sə ywì'lə yi co ləm. ");
INSERT INTO yam_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Fana wo te yi bə nte, nə jəŋ ntò' nə̀ nà' ànə ye ndzə bohòyi nə, nə ləp yi bə zeŋ mʉtuhù. ");
INSERT INTO yam_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wo ànə ywi'lə kʉrə yi fana wo fweŋ fis cə̀k nə̀ ghaŋ bə̀baŋ nə, nə ni fəsə fa yi cə̀ək ye sə sə̀mok. Wo jə lo yi də wo kə tɛ'lə yi. ");
INSERT INTO yam_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mvə̀'nə̀ wo à sə tesə tsoŋ mʉnto' anə vɛ'ɛ fana wo kʉrə bə ŋgà' nəmòk. Wo tap ko yi fo' bə ŋàŋ də nà'a bək jəŋ ntə̀əŋ Jisòs sə. Liŋ ŋgà' nə à ye Saimʉ̀. Wo to lak ye də Sìrinì. ");
INSERT INTO yam_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wo ànə kə dzeŋ mvwe' mok, wo togə̀ fo' də Gòrìgotà (a yà'a də nzʉ̀ə̀ tu bwìŋ), ");
INSERT INTO yam_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","wo fa yi rùk də yi no ŋga wo tòrə yà' bə yu cʉcʉk. Yi ànə yu'rə ja'a yà' fana yà' ye co yi kà no. ");
INSERT INTO yam_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wo ànə tɛ'lə wes yi fana wo təm gapsə cə̀ək ye sə bə bèŋ. ");
INSERT INTO yam_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wo cum nze, nə sə so nà' fo'. ");
INSERT INTO yam_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wo com naaŋ yak njo kpʉ ye ma mʉ tuhù yi. Yusə̀ wo à còm naaŋ sə à ye də: Ne'e Jisòs ŋkum bʉ̀ʉ Jus wèŋ nə. ");
INSERT INTO yam_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wo à tɛ'lə be'lə yi bə ŋgàa yə̀ə mok wèŋ, wo bwìŋ ba. Mòk bo ma ŋkwìp, mòk ma zʉ. Yi ye ye mʉtsətsə'rə̀. ");
INSERT INTO yam_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bʉ̀ʉ sə̀ wo à sə cà fo' wèŋ à sə yà'rə yi, nə sə mək tu awo dʉk də, ");
INSERT INTO yam_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","<<Nà'a wù nə̀ wù à dʉk də, aco wù kʉəmsə mak ndap Nwì nə̀ ghaŋ, nə ci fəsə wes nà' mʉnə nùumbu tɛ' nə. Tɛsə-a ni' yòɛ̀! A ye-a də wu mo Nwì zìnə, wù suhu tsoŋ na mʉntə̀əŋ fa'nə-le.>> ");
INSERT INTO yam_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ŋgàa fa satikà' bə ŋgàa yə'rə̀ fa bwìŋ lʉ̀k nə ye bə bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ pwe' à ywì'lə yi sə̀'. Wo sə dʉk də, ");
INSERT INTO yam_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","<<Yi tɛsə rì bòŋsə mègù bʉ̀ʉ mok wèŋ, nə kà ni' nə̀ nje tɛsə̀ rì. Yi də yi ŋkum bʉ̀ʉ Izùrɛ wèŋ yi. Yi suhu tsoŋ-a mʉ ntə̀əŋ fa'nə ŋga'a ya vèes dzəm bohòyi. ");
INSERT INTO yam_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yi naaŋgə̀ tu ye bohòNwì. Nwìi tɛsə-a yi ŋga'a ŋga Nwìi dzəmgə̀-a yi na. Bʉsə̀ yi dʉkgə̀ də yi mo Nwì.>> ");
INSERT INTO yam_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bʉ̀ ŋgàa yə̀ə sə̀ wo ànə tɛ'lə be'lə bə yà' sə wèŋ yak yi sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ànə ye ŋga nùum maràŋ kaŋ fana ndzəm seŋ mvwe' nzeŋgòŋ nə pwe' tə̀tè kə dzeŋ co nùm sə̀m. ");
INSERT INTO yam_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","À kə̀ dzèŋ nùm sə̀m anə fana Jisòs waŋ bə ŋgì nə̀ ghaŋ dʉk də, <<Eli, Eli, làma sabatàni?>> A yà'a bə ncèep lak yà'sə də, <<Nwì àm, Nwì àm, wù mà' mʉ bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bʉ̀ʉ mok sə̀ wo à tə fo' à yuk, nə dʉk də, <<Ŋwə̀ ènə sə to Àlajà.>> ");
INSERT INTO yam_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ŋwə̀ nəmòk nə̀ yi à ye sə̀' fo' caŋ ntɛ̀ŋ, nə kə tsəp və yumok co kùsa vɛ'ɛ sənə rùk mòk nə̀ cʉcʉk, nə tse' gesə mʉ cùhù Jisòs bə ntatʉ də nà'a no. ");
INSERT INTO yam_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bʉ̀ʉ mok sə wèŋ dʉk yàwo də, <<Wèeŋ yuk, a ja'a na kèe Àlajà nə və ŋgòkə̀ tɛsə yi àlɛ'.>> ");
INSERT INTO yam_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisòs waŋ fe'lə bə ŋgì nə̀ ghaŋ sə̀mok, nə me'rə yòŋsə̀ ye lo. ");
INSERT INTO yam_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ghà nə̀ yi ànə kpʉ ànə à ye fana cə̀k nə̀ nà' à sə gàpsə rum ndap mòk mʉmvwe' ndap Nwì nə̀ ghaŋ nə à sàha jəŋ mʉtuhù wàrr kə̀ dzèŋ sə mbwèŋ. Nze à tsòho fo', lìs sə voho sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sèe bwìŋ à mùhu sə̀'. Bʉ̀ʉ sə̀ wo à kpʉ ŋga wo bʉ̀ʉ Nwì wèŋ à lòkok mvwe' kpʉ. ");
INSERT INTO yam_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nùmbu nə̀ Jisòs à lòkok mvwe' kpʉ à ye, wo me'rə mvwe' sèe sə, nə lo Jòrosalèm nə̀ nà'a lak sə̀ rərɛŋ sə. Wo à ni mʉ ntòlak anə, bwìŋ ye wo wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ŋkum sojà nə̀ yi à ye fo' bə sojàa mok wèŋ sə̀ wo à sə kʉ̀k Jisòs ànə ye mvə̀'nə̀ nze ànə tsoho, nə ye bə bum sə̀ yà' à ye fo' pwe' fana wʉə ko wo. Wo dʉk də, <<Kɛ', ŋwə̀ ènə nə ye mo Nwì nə̀ zìnə.>> ");
INSERT INTO yam_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bə̀ba mok à ye fo' sə̀' wùriŋ. Wo à təəŋ sə̀sap, nə sə ja'a. Bàa yè'sə wèŋ à yù və̀ Jisòs mvwe' nzeŋgòGalìli, nə sə tɛsə yi. ");
INSERT INTO yam_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mok à ye fo' Mèri Màdàlinà, nə ye Mèri ma Jem bə Jòsep nə ye fe'lə ma bwe Zebèdi. ");
INSERT INTO yam_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nə̀ nconùm à ye fana Jòsep nəmòk nə̀ mvwe' lak Àrìmàtayà və. Yi à ye ŋgà ghàk, nə sə bɛ' lòJisòs sə̀'. ");
INSERT INTO yam_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yi à lòbohòPalè, nə lɛŋ nà' də nà'a fa yi vèŋ ni' Jisòs nə ya yi kə tuuŋ. Palè dzəm, nə dʉk də, wo kə fa nà'. ");
INSERT INTO yam_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jòsep jəŋ vèŋ ni' ye nə, nə lim gesə nà' ndzənə cə̀k nə̀ fi. ");
INSERT INTO yam_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yi jəŋ nà', nə gesə lo mvwe' sèe ye. Sèe sə à ye sə̀ fi ŋga yi tu yà' ndzənə lìs. Yi ànə gesə wes, yi bwi' təhə lok ncùu sèe sə bə ŋkə̀ŋkʉ̀m lìs mòk, nə bɛ' mandzə̀ lo. ");
INSERT INTO yam_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ànə ye ŋga Mèri Màdàlinà bə Mèri mòk nə à sə yə. Wo à cu ma nja vɛ'ɛ, nə sə kʉk gesə lo sèe sə. ");
INSERT INTO yam_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tsok à rɛŋ, ŋga nùmbu nə̀ wo à sə fʉ̀hʉ ŋgòcu dzə̀ càa, fana ŋgàa fa satikà' bə bʉ̀ʉ Faràsi wèŋ baaŋ mvwe' mò'fis, nə kə ye govənòPalè. ");
INSERT INTO yam_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nə dʉk fa nà' də, <<Mbè, vès sə tsərə malì mvə̀'nə̀ ŋwə̀ ènə à sə bòrə kɛ'cà bwìŋ fɛɛŋ də yi nsàp yumòk, nə dʉk də, <A kə̀ dzèŋ nùumbu tɛ' mʉ̀ lokok mvwe' kpʉ sə̀mok.> ");
INSERT INTO yam_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ye də bòco wù fa ŋàŋ, wo sə so sèe ye sə mʉnə nùumbu tɛ' sə. Bʉsə̀ aco ŋgàa fàak ye sə wèŋ kə yə fis lo nooŋ yi ndzəmə̀, nə borə bwìŋ də nà' lòkok mvwe' kpʉ laŋ. Nə ye də wo gʉ-a nsàp yumòk vɛ'nə zìnə, mvwès ènə nə gʉŋ ghak nə̀ nà' à ye mantombì nà'a.>> ");
INSERT INTO yam_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Palè dʉk fa yà'wèŋ dʉk də, <<Wèŋ tse' sojà wèŋ co wo so yo. Wèeŋ du, nə kə so sèe sə nsàp nə̀ wèŋ rì vɛ'ɛ pap nə̀ pap.>> ");
INSERT INTO yam_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ànə geŋ wo lo, nə kə zərə lok ncùu sèe sə mpʉ̀ŋ. Nə jəŋ sojà wèŋ tes fo' də yà'a sə so. ");
INSERT INTO yam_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nùmbu dzə̀ à càa, ŋga tsok sə rɛɛŋ tsə nù Sondè Mèri Màdàlinà bə Mèri mòk lokok də wo kə kʉk ja'a sèe Jisòs sə. ");
INSERT INTO yam_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wo à kə̀ dzèŋ fo', ŋga nze à tsoho. À ye ŋga masinjà Tà Nwì tsə mʉbu, nə kə bwi' gɛsə lìs nə̀ mvwe' ncùu sèe sə fo', nə kok cum yuye mbwa. ");
INSERT INTO yam_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Si ye à sə rɛŋ co mbʉ̀ŋ bà'a yi, cə̀k ye sə fop co mbàk. ");
INSERT INTO yam_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bʉ̀ʉ sə̀ wo à sə sòsèe sə wèŋ à kà bə wʉə vɛ'ɛ, nə bʉʉŋ co bʉ̀ kpʉkpʉ. ");
INSERT INTO yam_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Masinjà Nwì nə à cèp bohòbàa sə wèŋ. Yi dʉk fa yà' də, <<Wèeŋ kà wəp! Mʉ̀ rì də wèŋ sə làp Jisòs nə̀ wo à tɛ'lə yi mʉ ntə̀əŋ nà'a. ");
INSERT INTO yam_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yi ka fɛnə yeŋ. Yi lòkok mvwe' kpʉ laŋ mvə̀'nə̀ yi à dʉk də yi nə lokok yà'a. Wèeŋ və fɛn, nə kə kʉk ja'a yàwèeŋ mvwe' sə̀ yi à nòoŋ nɛ̀. ");
INSERT INTO yam_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wèeŋ caŋ lo-a, nə kə tsok fa ŋgàa fàak ye wèŋ də yi lòkok mvwe' kpʉ laŋ. Yi gə̀ cà nà' mantombìi wèŋ ŋgòlòmvwe' nzeŋgòGalìli. Wèeŋ nə kə tseŋ yi fo'. Wèeŋ tsərə tse' bum sə̀ mʉ̀ tsə̀' weŋ yè'e, nə kà swì.>> ");
INSERT INTO yam_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ànə geŋ wo me'rə mvwe' sèe sə bə caŋ. Wʉə sə ko wo, kwəkwa rwiŋ wo sə ntʉʉ̀ sə̀' dak. Wo sə caŋ lo də wo kə tsok fa ŋgàa fàak ye sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mvə̀'nə̀ wo à sə lòo sə, Jisòs kə tseŋ wo vak, nə dʉk fa yà'wèŋ dʉk də, <<Mʉ̀ cèpsə weŋ.>> Wo à və̀, nə kə kotse' kùu ye, nə kuksə yi. ");
INSERT INTO yam_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisòs nə dʉk fe'lə fa wo dʉk də, <<Wèeŋ kà wəp. Wèeŋ du, nə kə tsok fa bwema am wèŋ də wo lo mvwe' nzeŋgòGalìli, vesi wèeŋ nə yenə fo'.>> ");
INSERT INTO yam_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mvə̀'nə̀ bàa sə wèŋ à sə lòyàwo fana sojàa sə̀ wo à sə sòsèe sə wèŋ mok à lòmvwe' ntòlak nə̀ fo' nə. Nə tsoho fa ŋgàa fa satikà' wèŋ yusə̀ yà' ye sə pwe'. ");
INSERT INTO yam_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ŋgàa fa satikà' sə à kə̀ cu be'lə bə bʉ̀ ŋkwàha bʉ̀ʉ sə̀ fo' sə wèŋ, nə kiŋ cù bə yusə̀ wo nə gʉ. Wo à fa sojàa sə wèŋ mbàm vɛ'ɛ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nə tsok fa yà' də a gə̀ə, yà' tsok də wo ànə dzəm swi lo ndzəmə̀ àlɛ, ŋgàa fàak ye wèŋ kə yə fis bisə lo vè ni' ye nə. ");
INSERT INTO yam_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wo dʉk fe'lə də, <<A ye-a ŋga govənòyuk bum yè'sə fana vèes nə riŋ mvəsə̀ ŋgòtsə̀' yi ya yi dzəm də a zìnə. Wèeŋ kà wəp də wèeŋ nə tse' nzak wəp lok.>> ");
INSERT INTO yam_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bʉ̀ʉ sə̀ wo à sə kʉ̀k sèe sə wèŋ à jə mbàam sə, nə kə gʉ megu sə̀' mvə̀'nə̀ wo anə tsok wo sə. Haaŋ kə dzeŋ ntinə, yà'a yusə̀ bʉ̀ʉ Jus wèeŋ dʉkgə̀ də yà' ànə ye vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ŋgàa fàak Jisòs sə̀ hum-ncòp-mò'fis sə wèŋ à lo mvwe' nzeŋgòGalìli, nə lo mvwe' nda nə̀ Jisòs à tsə̀' wo də wo lo fo' nə. ");
INSERT INTO yam_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wo ànə ye yi, wo kuksə yi. Wo à gʉ̀ vɛ'nə ŋga mok wèŋ sə mərə mali yi ntòmərə. ");
INSERT INTO yam_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Anə geŋ, Jisòs sòoŋ kʉəp və wo, nə cep də, <<Nwì a fa ŋàaŋ sə̀ mʉbu bə sə̀ sə nze pwe' bohòmʉ̀. ");
INSERT INTO yam_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Wèeŋ du lo-a ŋga'a bohòbwìŋ ma fòpwe', nə gʉ bʉsə wo ŋgàa bɛ' mandzə̀ àm. Wèeŋ bàptɛsə wo mʉnə liŋ Tɛ̀', bə liŋ Mwe, nə ye Yòŋsə̀ nə̀ Rərɛŋ nə. ");
INSERT INTO yam_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wèeŋ yə'rə wo ŋgònòŋsə bum sə̀ mʉ̀ a tsə̀' weŋ də wèeŋ nə sə gʉ yà'a pwe'. Fana wèeŋ sə tsərə tse' sə̀' də, mʉ nə sə ye vesùwèŋ nùumbu pwe' tə̀tè nzeŋgòŋ kə me.>>");
INSERT INTO yam_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yè'e mʉmvə̀'nə̀ Ntirə̀ nə̀ Bə̀boŋ nə̀ Jisòs Krɛst mo Nwì à yèto. ");
INSERT INTO yam_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nà' à yèto ŋga Jon tesə və̀ sə ŋgəà. Yi ànə tesə və mvəsə̀ ŋgà tsòhòbum Nwì Ìzayà à còm də, Nwì à dʉk də, <<Yèè, nè'e masinjà àm, mʉ nə tumsə gesə lo yi mantombìi wù ŋgògʉ̀ fʉ̀hʉ fa wu mandzə̀.>> ");
INSERT INTO yam_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yi à còm mok sə̀' də, Ŋgì ŋwə̀ nəmòk sə cèp torə və̀ sə ŋgəà, nə sə yuhu də, <<Gʉ̀ tsə'rə fa Tà mandzə̀ ye, rəŋsə tsə'rə fa yi bwe cwèe mandzə̀ ŋgògì cà ca.>> ");
INSERT INTO yam_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","À ye vɛ'nə, Jon ŋgà bàptɛsə̀ bwìŋ tesə və sə ŋgəà, nə sə tsoho fa bwìŋ ncèp nə də, <<Wèeŋ kupsə, nə bwi fa bʉp awèŋ ŋkwɛ̀ŋ, nə baptɛsə, ya ŋga Nwìi swifa weŋ bʉp awèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Fana bwìŋ à tesə və̀ mvwe' nzeŋgòŋ Jùdiyà bə ntòlak Jòrosalèm pwe'fo' ŋgòkə̀ yuk yusə̀ Jon sə cèp sə. Wo à kəà cù bə bʉp awo sə̀ wo gʉ̀gə̀ə, fana Jon bàptɛsə wo sənə ndzəp Jòridàŋ. ");
INSERT INTO yam_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon à sə ni nsàap cə̀ək sə̀ ŋgàa tsòhòbum Nwì wèŋ. Wo à gʉ̀ yà' bə nwɛ̀ɛs nàm nəmòk nə̀ wo togə̀ nà' də kàme. Yi swi' tse' bə korə ŋgùp sə mbwèe yi. Zʉzʉʉ ye à ye ŋgwim bə nu. ");
INSERT INTO yam_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yi à tsə̀' fa bwìŋ dʉk də, <<Ŋwə̀ nəmòok nə və ma ŋkwɛ̀ɛŋ mʉ̀ nə̀ yi yam càsə mʉ̀ yi. Mʉ̀ ka kə̀kʉrə̀ co mʉ̀ bʉhʉ tsoŋ sə nze ŋgòfìrə kʉ̀ʉ kùuŋgùp ye yeŋ. ");
INSERT INTO yam_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mʉ̀ bàptɛsə mègù weŋ yàm bə ndzəp, fana yi nə baptɛsə weŋ ye bə Yòŋsə̀ nə̀ Rərɛŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","À ka sap Jisòs mè'rə lak Nazàrɛ nə̀ nà'a mvwe' nzeŋgòGalìli, fana Jon bàptɛsə yi sənə ndzəp Jòridàŋ. ");
INSERT INTO yam_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mvə̀'nə̀ Jisòs à tesə kok sə ndzəpə̀ anə ntɛ̀ŋ, yi ye ŋga ntòbu mùhu fana Yòŋsə̀ Nwì sə tsoŋ və bohòyi co kəkəbʉ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ŋgì mòk sə yuhu tsooŋ mʉbu anə dʉk də, <<Wu mo àm nə̀ mʉ̀ dzəm wu sə ntʉʉ̀ mʉ̀ ŋkʉ̀ʉŋntɛ̀ŋ. Mʉ̀ sə kwa bohòwù wùriŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yòŋsə̀ nə gʉ yi sə̀' ntɛ̀ŋ ŋgòlòmvwe' səmok sə ŋgəà. ");
INSERT INTO yam_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yi à cu fo' nùumbu hum kwè, Satà sə mumsə yi. Yi à ye fo' bə nàam ŋgòŋ wèŋ fana masinjàa Nwì sə jəŋ ŋkərə̀ bohòyi. ");
INSERT INTO yam_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A ye ŋga wo nisə Jon ndapndzəm, fana Jisòs lòmvwe' nzeŋgòGalìli, nə sə tsòho Ntirə̀ nə̀ Bə̀boŋ nə̀ nà' və̀ bohòNwì. ");
INSERT INTO yam_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yi sə dʉk də, <<Mvə̀k kʉ̀rə laŋ nə̀ gaŋ ŋkum Nwì kʉəp ŋgòye sə nzeŋgòfɛŋ laŋ. Wèeŋ kupsə, nə bwi fa bʉp awèŋ ŋkwɛ̀ŋ, nə dzəm Ntirə̀ nə̀ Bə̀boŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nùmbu mòk à ye ŋga Jisòs sə gìhi ŋgʉ ndzəp Galìli, yi ye bʉ̀ ŋgàa fu'fuk ba, Saimʉ̀ bə moma ye Andrù ŋga wo sə fu'fuk bə ram. ");
INSERT INTO yam_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisòs dʉk fa wo də, <<Wèeŋ bɛ' və mʉ ya mʉ yə'rə weŋ ŋgòko bwìŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wo ànə yuk vɛ'nə ntɛ̀ŋ, wo me'rə mak noŋsə ram awo sə fo', nə yuŋ lo yi. ");
INSERT INTO yam_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yi à gì lòjo, yi ye fe'lə bwe ŋgà' nəmòk nə̀ wo togə̀ yi də Zebèdi ŋga wo bwìŋ ba, Jem bə moma ye Jon. Yi à kə̀ tsèŋ wo ŋga wo cu sənə ŋgwes, nə sə gʉhʉ tsə'rə ram awo. ");
INSERT INTO yam_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yi à to yà' sə̀', wo bɛ' lòyi, nə me'rə tɛ̀' awo Zebèdi bə ŋgàa fàak awo sə ŋgwesə̀ anə, nə lo bə Jisòs. ");
INSERT INTO yam_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wo à gì lòmvwe' mò'fis, nə kə dzeŋ lak mok sə̀ wo togə̀ fo' də Kàpanùm. Fana nùmbu dzə̀ awo à wɛ̀ɛs, Jisòs lo mvwe' ndap pìriyà bʉ̀ʉ Jus, nə ye ŋgòyə'rə wo ncèp Nwì mbwa. ");
INSERT INTO yam_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bʉsə̀ yi à cèp nsàp nje zok bə ŋàŋ, fana bwìŋ mərə bʉ̀ʉsə̀ wo rì də cicàa sə̀ wo à sə yə'rə lʉ̀k à sə kà vɛ'nə cèpgə̀. ");
INSERT INTO yam_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ŋwə̀ nəmòk à ye mbwa nə̀ yi à tse' yòŋsə̀ ze' ndzə ni'ì yi. Yi ye ŋgòwa torə fis də, ");
INSERT INTO yam_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","<<Jisòs nə̀ mvwe' lak Nazàrɛ, wù tse' yà vesùwèŋ nɛ? Mʉ̀ rì wu bə̀boŋni, wu ŋwə̀ nə̀ rərɛŋ nə̀ wù və̀ bohòNwì. Wù və̀ yè'sə ŋgòzə ves à?>> ");
INSERT INTO yam_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisòs à ghamsə yòŋsə̀ nə, nə dʉk fa yi də, <<Lok cùu yo, nə ca tesə ndzə ni'ì ŋwə̀ ènə.>> ");
INSERT INTO yam_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yòŋsə̀ nə à yuk vɛ'nə ntɛ̀ŋ, yi tsə'rə ŋgà' nə nə̀bʉp, nə waŋ torə vɛ'ɛ, nə tesə ndzə ni'ì ŋgà' nə. ");
INSERT INTO yam_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bwìŋ à mərə vɛ'ɛ nə̀bʉp, nə sə dʉk də, <<Hàva'! Yè'sə yà vɛ'nə ɛ? Nsàp yəyə'rə̀ nə̀ fi və̀ yè' laŋ. Ŋwə̀ nè'e tse' to ŋàŋ ŋgòcèp bohòyòŋsə̀ə ze' wèŋ fana wo yuk cùu ye.>> ");
INSERT INTO yam_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ghàr vɛ'ɛ ŋga liŋ Jisòs ca yuhu mvwe' nzeŋgòGalìli pwe'fo' laŋ. ");
INSERT INTO yam_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisòs bə yà'wèŋ à tesə tsə mʉnə ndap pìriyà nə, fana yi Jisòs nə bə Saimʉ̀ nə ye Andrù, Jem bə Jon wèŋ à lòmvwe' ndap Saimʉ̀ bə Andrù. ");
INSERT INTO yam_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wo à dzèeŋ ŋga malii Saimʉ̀ nòbə yiyaŋ. Wo tsok fa Jisòs vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yi lo, nə kə ko bo nà', nə lokoksə nà' mʉtsə̀, yiya nə me fana yi lokok təəŋ, nə kə lap fa wo zʉzʉ. ");
INSERT INTO yam_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nùmbu ànə à ye ŋga nùm sə co tsə lòo, wo jə və̀ fa Jisòs ŋgàa yiyaŋ pwe', nə jə və fe'lə bʉ̀ʉ sə̀ wo à tse' yòŋsə̀ə ze' ndzə ni'ì wo. ");
INSERT INTO yam_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bwìŋ à tesə bə lak yà'sə pwe', nə kə maŋ mvwe' ntòmbi ànə bìkìkìkì. ");
INSERT INTO yam_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisòs à gʉ̀ bʉ̀ʉ sə̀ wo à tse' nsàap yiyaŋ zok zok wo gʉŋ ŋkʉ̀ʉŋntɛ̀ŋ, nə bɛ' fis ze' ndzə ni'ì wo maŋgəŋgèŋ. Bʉsə̀ ze' sə à rì yi bə̀boŋ fana yi kà yà' mandzə̀ ŋgòtsə̀' fa bwìŋ vɛ'nə fa. ");
INSERT INTO yam_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tsok à kʉəp, ŋga cu ntòbə ndzəm, Jisòs lokok, nə tesə lo mʉmvwe' nəmòk, nə kə gʉ pìriyà fo' yiìyi. ");
INSERT INTO yam_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","À cu ghàr wo kà yi yə, fana Saimʉ̀ bə bʉ̀ʉ səmok sə lap kɛ' ca yi. ");
INSERT INTO yam_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wo à yə yi, wo tsok yi də, <<Bwìŋ sə làp wu maŋgəŋgèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yi dʉk fa yà' də, <<Yusə̀ yà' a jə və̀ mʉ fɛɛŋ, a ŋgòtsòho ncèp Nwì. Vesùwèeŋ lo lɛ mvwe' lak mok sə̀ yà' kʉəp fɛɛŋ yè'e, nə tsoho fo' sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yi à gì dzòoŋ nzeŋgòŋ Galìli pwe', nə sə tsoho kɛ' ncèp Nwì mvwe' ndaap pìriyà, nə sə bɛ'ɛ fis yòŋsə̀ə ze' wèŋ ndzə ni'ì bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nùmbu mòk à ye, ŋgà kuturu nəmòk à və̀ə, nə kə təəŋ mantombìi yi bə tumfərə, nə lɛŋ nà' də nà'a tɛsə yi. Yi dʉk fa Jisòs də, <<Tà, a bò-a wu co wù tɛsə mʉ na, wù gʉ fa mʉ yiya àm nè'e me.>> ");
INSERT INTO yam_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisòs ànə yuk vɛ'nə, ntʉm ye rwiŋ bə manziŋ, fana yi fis bo, nə jwɛŋ nà' bə zeŋ, nə dʉk də, <<Mʉ̀ dzəm laŋ, yiya yònə nà'a me.>> ");
INSERT INTO yam_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yiya nə à mè gù sə̀ ghà ànə fo', yi gʉŋ lo yuye. ");
INSERT INTO yam_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisòs à tipsə yi gʉgʉŋ, nə me'rə yi lo. ");
INSERT INTO yam_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Yi dʉk fa nà' də, <<Dù, nə kà ŋwə̀ nəmòk tsə̀' fa swì. Cà lògù bohòŋgà fa satikà', nə kə ni fa yi ni' yò, ya yi kʉk ja'a də yiya yòmè laŋ àlɛ. Yi kʉ̀' mèsə, wù fa fəfa nə̀ Musì à dʉk nə, ŋgònìŋtsə̀' fa bwìŋ də yiya yònə a mè laŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ŋwə̀ ènə à lòyuye, nə tsoho lo bwìŋ pwe', nə tsoho wesə nsàp nə̀ co Jisòs kà mʉ ntòlak jəja mok gì fe'lə̀. Yi sə cum kɛ' mok mvwe' sə̀ bwìŋ ka fo' yeŋ. Bwìŋ sə və ma nə̀ fòlòoŋ, nə sə kə tseŋ yi fo'. ");
INSERT INTO yam_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","À cà nùumbu jo, Jisòs foho lo mvwe' lak Kàpanùm. Fana bwìŋ yuk lo də yi cu mʉ ntòlak anə. ");
INSERT INTO yam_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bwìŋ və ŋkʉ̀ʉŋ. Ncù à loho mègù bə bwìŋ, fana mandzə̀ kà ŋgòtsèŋ Jisòs ye. Jisòs à sə tsòho fa wo ncèp Nwì. ");
INSERT INTO yam_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bwìŋ kwè və, nə bək və ŋwə̀ nəmòk ŋga ŋgə̀ŋgàŋ à bù'rə bù'rə, ŋgòkə̀ fa Jisòs. ");
INSERT INTO yam_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bʉsə̀ bwìŋ à ye ŋkʉ̀ʉŋ fana wo kà mandzə̀ ŋgòjə lòŋwə̀ nə ŋgʉ ni'ì Jisòs tse'. Fana wo kok mʉ ndùndap, nə cok tosə mvwe' sə̀ Jisòs tə sə. Wo à cok tosə, wo le' gesə ŋwə̀ nə ca bohòJisòs mʉnə kəà. ");
INSERT INTO yam_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisòs à yə də wo tse' dzədzəm də aco yi gʉ yiyaŋ ŋwə̀ nə me. Yi dʉk bohòŋwə̀ nə̀ yi kà gìgə̀ nə də, <<Mo àm, mʉ̀ swìfa wu bʉp yo laŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bʉ̀ ŋgàa yə'rə̀ fa bwìŋ lʉ̀k mok à cu fo'. Wo ànə yuk yusə̀ Jisòs à dʉk, nə tsərə də, ");
INSERT INTO yam_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","<<Aco yi duk vɛ'nə va? Yi sə gʉ̀ bʉpsə liŋ Nwì wà. Mègù Nwì nə̀ aco yi swì fa ŋwè bʉp ye.>> ");
INSERT INTO yam_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisòs riŋ yusə̀ wo sə tsəm sə sə̀ ntɛ̀ŋ, fana yi dʉk fa wo də, <<Wèŋ sə tsəm sə ntʉʉ̀ wèŋ vɛ'nə bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Co joho gha' yè'e nə̀ ŋgòdʉk bohòyi də, <Mʉ̀ swì fa wu bʉp yo laŋ,> kè nə̀ ŋgòdʉk də, <Lòkok mʉtsə̀, nə bək jə kəà yò, nə gi lo yuyo> ɛ? ");
INSERT INTO yam_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Fana mʉ nə niŋ fa weŋ də mʉ̀ʉ mo ŋwè, mʉ̀ tse' ŋàŋ sə nzeŋgòŋ ènə ŋgòswì fa bwìŋ bʉp awo.>> ");
INSERT INTO yam_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Fana yi dʉk fa ŋgà' nə̀ yi kà gìgə̀ nə də, <<Mʉ̀ dʉk wu də lòkok, te' kəà yò, nə lo la'à wù.>> ");
INSERT INTO yam_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mvə̀'nə̀ wo à təəŋ nə sə ja'a mali, fana ŋwə̀ nə te' kəà ye, nə gi lo yuye. Wo mərə pwe', nə kwasə Nwì də, <<Vès ka nsàp yu nè'e ye yuk.>> ");
INSERT INTO yam_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisòs à foho lòsə ŋgʉ ndzəp Galìli. Bwìŋ ŋkʉ̀ʉŋ bɛ' lòyi, fana yi ye ŋgòkə̀ yə'rə yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mvə̀'nə̀ yi à sə gì lòo yi ye ŋwə̀ nə̀ yi kogə̀ mbàam tas, ŋga yi cu mvwe' sə̀ yi fàkgə̀ fàk. Ŋwə̀ ànə à ye Levì mo Alfòs. Jisòs dʉk fa yi də, <<Bɛ' və mʉ.>> Yi lòkok, nə yuŋ lo nà'. ");
INSERT INTO yam_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","À ye ghàr fana Jisòs sə zʉ zʉzʉ mʉmvwe' ndap Levì nə. Bʉ̀ ŋgàa ko tas nə ye bʉ̀ ŋgàa gʉ̀ bʉp ŋkʉ̀ʉŋntɛ̀ŋ à be'lə yi bə ŋgàa fak ye ŋgòzʉ zʉzʉ mvwe' mò'fis. Bʉ̀ʉ sə̀ wo à ye ŋkʉ̀ʉŋ yè'sə wo à sə yù kɛ' yi. ");
INSERT INTO yam_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bʉ̀ ŋgàa yə'rə̀ lʉ̀k mok à ye fo', sə̀ wo à ye bòp bʉ̀ Faràsi wèŋ. Wo à yə ŋga Jisòs sə zʉ bɛŋ bə ŋgàa gʉ̀ bʉp nə ye ŋgàa ko tas. Wo fek bʉ̀ ŋgàa fàak ye də, <<Yi sə zʉ be'lə ye bə ŋgàa gʉ̀ bʉp nə ye ŋgàa ko tas wèŋ bʉ̀ʉ ya?>> ");
INSERT INTO yam_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisòs yuk, nə bʉsə də, <<Bʉ̀ʉ sə̀ wo ka yiyaŋ tse', wo kà doktà làpgə̀, a lap megu doktà ŋwə̀ nə̀ yi sə yaya. Fana bohòmʉ̀ yàm, mʉ̀ à ka njo bʉ̀ʉ sə̀ wo kə̀kʉrə̀ bohòNwì wèŋ və, mʉ̀ à və̀ ŋgòto bʉ̀ ŋgàa gʉ̀ bʉp wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","À ye mvə̀k mòk, bʉ̀ʉ sə̀ wo à sə bɛ' Jon ŋgà bàptɛsə̀ bwìŋ bə bʉ̀ʉ Faràsi wèŋ sə dzə zʉzʉ ya wo kuksə Nwì. Bʉ̀ʉ mok və bohòJisòs, nə fek yi də, <<Bʉ̀ʉ sə̀ wo sə bɛ' Jon ŋgà bàptɛsə̀ bwìŋ nə ye bʉ̀ʉ Faràsi wèŋ sə dzə̀gə̀ zʉzʉ nùumbu mok, bwe yo kà yàwo dzə̀gə̀ bʉ̀ʉ yà lɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisòs cep fəsə fa wo də, <<Aco wo dʉk fa bʉ̀ʉ sə̀ wo və̀ mvwe' sə̀ wo sə zʉ bum gù də wo dzə zʉzʉ anə va? Ka vɛ'nə yeŋ. Mvə̀k nə̀ ndugù nə cu malì bə yà'wèŋ, fana wo nə kà vɛ'nə cu. ");
INSERT INTO yam_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Fana nùmbu nə sə və̀ə nə̀ wo nə jəŋ gɛsə lo ndugù nə, fana wo nə dzə zʉzʉ mvə̀k ànə. ");
INSERT INTO yam_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","<<Yusə də, kaco ŋwè jəŋ cə̀k nə̀ fi, nə te' lok nə̀ nà' və̀p laŋ bə zeŋ yeŋ. Bʉsə̀ nə̀ fi nə nə saha tesə ndzənə nə̀ zəm nə fana yam ghak wesə ŋga'a mvwe' sə̀ nà' saha maŋkwɛ̀ŋ sə. ");
INSERT INTO yam_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yumook sə̀' də wo kà dzə̀ rùk sənə bɛ̀s nə̀ zəm kep gèsə̀gə̀, bʉ̀ʉsə̀ yà'a nə duk, nə vok bɛ̀s nə. Fana rùuk sə nə bʉp bə bɛ̀s nə mwè. Bògha' lɛ də wo gesə dzə̀ rùk sənə bɛ̀s nə̀ fi.>> ");
INSERT INTO yam_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nùmbu dzə̀ mòk à ye, Jisòs gi cà mvwe' nzum nzaŋ mok. Mvə̀'nə̀ ŋgàa fàak ye à sə bɛ' yi fana wo sə kʉp jəŋ tu nzaŋ. ");
INSERT INTO yam_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fana bʉ̀ʉ Faràsi dʉk fa Jisòs də, <<Yeè, lʉ̀k avès ka dzəm də wo gʉ vɛ'nə nùmbu dzə̀ dzəm.>> ");
INSERT INTO yam_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisòs cep fəsə fa wo dʉk də, <<Wèŋ à ka yusə̀ Devìd à gʉ̀ taŋ yà'a yuk à? Mvəsə̀ yi à dzəm yumok ŋgòzʉ ŋga njè à ya yi bə bwe ye wèŋ, ");
INSERT INTO yam_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","fana yi lo kə ni mʉ nda'à Nwì, nə kə jəŋ zʉ ntuk brɛd nə̀ wo à nòŋsə ŋgòkùksə Nwì fo'. Àbiyadà à ye ŋkum bʉ̀ ŋgàa fa satikà' ghà nà'nə yi. Ŋga lʉ̀k avès sə tsə̀' də aco zʉ megu yà' ŋgàa fa satikà' wèŋ fana Devìd zʉ yà', nə fa bʉ̀ʉ ye sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisòs à cèp mèsə ncèp nə dʉk də, <<Nwì à gʉ̀ nùmbu dzə̀ ŋgòtɛsə ŋwè, ka də wo à gʉ̀ ŋwè bʉ̀ʉ nùmbu dzə̀ yeŋ. ");
INSERT INTO yam_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ye də mʉ̀ʉ mo ŋwè, mʉ Tà nə̀ mʉ̀ tse' ŋàŋ bə nùmbu dzə̀ nə mʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nùmbu mòk à ye Jisòs gì bʉ̀ʉŋ və̀ mʉmvwe' ndap pìriyà mòk ŋga ŋwə̀ nəmòok mbwa nə̀ bo ye mok à kpʉ. ");
INSERT INTO yam_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bʉ̀ʉ səmok à ye mʉ ndà'à anə sə̀ wo à dzəm ŋgòlàp Jisòs bə nzak. Fana wo sə kʉk tse' yi də kè yi gʉ̀ bòŋsə-a ŋwə̀ ènə nùmbu dzə̀ àlɛ'. Də ya wo ko yi bə nzak də yi gʉ̀ fàk nùmbu dzə̀. ");
INSERT INTO yam_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yi dʉk fa ŋgà bo bʉp nə də, <<Lòkok və kə̀ təəŋ kù mantombìi mʉ̀ fɛn.>> ");
INSERT INTO yam_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ŋgà' nə à və̀ə, Jisòs fek bʉ̀ʉ mok sə də, <<Yusə̀ lʉ̀k dzəm də aco a gʉ yà' nùmbu dzə̀ə yà? A bə̀boŋ ŋgòtɛsə bwìŋ kè ŋgògʉ̀ bʉp ɛ, a bə̀boŋ ŋgòtɛsə yòŋsə̀ ŋwè kè ŋgòzə nà' ɛ?>> Wo à cu gù dədok, nə kà cù mùk. ");
INSERT INTO yam_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","À bʉp Jisòs. Yi jok bohòwo bʉ̀ʉ nsàap ntʉm sə̀ bʉp sə̀ wo tse' yà', nə dʉk fa ŋwə̀ nə̀ kpʉkpʉ bo nə də, <<Nɛ̀p fis yak a bo yo sə ɛ̀.>> Yi à nɛ̀p fis yà' ntɛ̀ŋ, fana yà' gʉŋ. ");
INSERT INTO yam_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bʉ̀ʉ Faràsi à yə vɛ'nə, fana wo à lòo, nə kə to bʉ̀ʉ mok sə̀ wo ma nə̀ ŋkum Herò, fana bə yà'wèŋ cum kwe' mʉ tuhù yi mvə̀'nə̀ wo nə zə yi. ");
INSERT INTO yam_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisòs bə ŋgàa fàak ye à ye'e lòŋgʉ ndzəp Galìli. Bwìŋ kə tsèŋ wo fo' ŋkʉ̀ʉŋntɛ̀ŋ. Bʉ̀ʉ yè'sə à tesə və̀ mvwe' nzeŋgòGalìli bə Jùdiyà. ");
INSERT INTO yam_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bʉ̀ʉ mok wèŋ à tesə mvwe' lak Jòrosalèm, mok və mvwe' nzeŋgòIdumiyà bə nzeŋgònə̀ ma ndzə nto ndzəp Jòridàŋ. Mok tesə mvwe' sə̀ yà' kʉəp lak Tayà bə Sidòŋ sə̀'. Bʉ̀ʉ yè'sə à və̀ ŋgòyə Jisòs bʉ̀ʉsə̀ wo à yuk yusə̀ yi à sə gʉ̀ʉ. ");
INSERT INTO yam_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bʉ̀ʉ sə à ye wùriŋ, fana yi dʉk ŋgàa fàak ye də wo lap fa yi ŋgwes yi ni ca ŋga wo kà yi sə nze bwì' màk. ");
INSERT INTO yam_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","A ye vɛ'nə bʉ̀ʉsə̀ yi à gʉŋsə ŋgàa yiyaŋ nùmbu ànə ŋkʉ̀ʉŋntɛ̀ŋ. Fana ŋgàa yiyaŋ mok wèŋ sə nik lo gu va' də wo kə jwɛŋ gesə gu yi bə bo. ");
INSERT INTO yam_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","À ye fo' də, bʉ̀ʉ sə̀ wo à tse' yòŋsə̀ə sə̀ bʉp ndzə ni'ì wo yə yi fana wo gbʉ̀ mantombìi yi sə nze, nə sə dʉk də, <<Wùu mo Nwì.>> ");
INSERT INTO yam_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yi sa'rə yòŋsə̀ə ze' sə gʉgʉŋ də wo cum gəe', nə kà də wo tsok bwìŋ də yi mo Nwì wo dʉ'. ");
INSERT INTO yam_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisòs à kok lòmʉ ndahà, nə to benə bʉ̀ʉ sə̀ yi sə dzəm də bə yà'wèeŋ lo, fana wo yuŋ lo yi. ");
INSERT INTO yam_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ànə geŋ, yi swekfis bwìŋ hum-ncòp-ba mʉtsətsə'rəə wo də wo ye ŋgàa ntum ye. Yi dʉk fa yà'wèŋ də yi nə sə cum bə yà'wèŋ, nə tum wo ŋgòtsòho lòncèp nə̀ nje. ");
INSERT INTO yam_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Fana yi fa wo ŋàŋ ŋgòbɛ'fis fa bwìŋ yòŋsə̀ə ze' ndzə ni'ì. ");
INSERT INTO yam_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Liŋ bʉ̀ʉ sə̀ hum-ncòp-ba sə à ye Saimʉ̀ nə̀ yi à to fa nà' liŋ mòk də Pità. ");
INSERT INTO yam_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jem bə moma ye Jon wo à ye bwe Zebèdi. Jisòs à to wo də Bwànàjis. Liŋ ŋge' yà'sə dʉk də, Mbʉ̀ŋ saha. ");
INSERT INTO yam_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nə ye Andrù, Filìp, Bàtòlomì, Màtiyò, Tomos, Jem mo Alfòs, Tàdiyòs, Saimʉ̀ nə̀ yi à ye mòk bə bòp bʉ̀ nə̀ wo to wo də Kenènat, ");
INSERT INTO yam_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nə ye fe'lə Judàs Iskarəyà nə̀ yi à sèŋ Jisòs. ");
INSERT INTO yam_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisòs bə bwe ye à kə̀ ni mʉnə ndap nəmòk, fana bwìŋ yuŋ wo nsàp nə̀ wo làp mandzə̀ ŋgòkə̀ zʉ bɛŋ bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mʉmvə̀'nə̀ yà' à ye vɛ'nə, fana ma ye nə ye bwema ye wèŋ yuk, nə sə və ŋgòkə̀ jə lòyi. Bʉsə̀ bwìŋ à sə dʉhʉ də, <<Ŋkərə̀ nà' sə də a bʉp.>> ");
INSERT INTO yam_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bʉ̀ ŋgàa yə'rə̀ lʉ̀k sə̀ wo à tsə və̀ Jòrosalèm dʉk yàwo də yi tse' ze' Bezebù ndzə ni'ì yi, nə̀ nà'a ŋkum ze' wèŋ. Nà' a fagə̀ yi ŋàŋ fana yi sə bɛ'fis ze' bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","À ye vɛ'nə fana Jisòs to benə bʉ̀ʉ sə ŋgʉ ni'ì yi, nə fek yà' gbʉ' mòk də, <<Aco Satà bɛ'fis ni' ye yè'sə va? ");
INSERT INTO yam_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ŋga wo gàpsə-a lak mòk bə bòp də wo lʉ̀, fana ye də lak yà'sə nə gbʉ. ");
INSERT INTO yam_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ŋga wo gàpsə-a ndap ŋwə̀ nəmòk bə bop zəzok də wo sə lʉ̀, fana ye də ndap ànə nə gbʉ nze sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Megu yà'a sə̀' vɛ'nə də a ye-a ŋga Satà kʉ̀ə̀m bə ndap ye kaco nà' təəŋ yeŋ, nà'a nə gbʉ, nə lə. ");
INSERT INTO yam_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","<<Kaco ŋwə̀ nəmòk ni to mʉnda'à ŋgà ŋàŋ, nə fis jəŋ lo yumok mbwa yeŋ. Tse'ŋga yi ko kì nòŋsə to ŋgà ŋàŋ nə bə kʉ̀ ŋkuŋ yi ni mʉ ndà'à nà' anə. ");
INSERT INTO yam_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","<<Mʉ̀ sə tsə̀' fa weŋ nè'e ŋkèm ncèp dʉk də, nsàap bʉp sə̀ bwìŋ gʉ̀gə̀-a lòoŋ, wo nə tse' sə̀swìfa bə zeŋ, nə ye bə bum sə̀ bʉp sə̀ wo cèpgə̀ə. ");
INSERT INTO yam_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Fana ŋwə̀ nə̀ yi bʉpsə liŋ Yòŋsə̀ nə̀ Rərɛŋ, fana yi nə kà sə̀swìfa tse' yuk, bʉ̀ʉsə̀ yi gʉ̀ yà'sə bʉp nə̀ nà'a nə̀ kà mè yuk.>> ");
INSERT INTO yam_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisòs à dʉk vɛ'nə bʉ̀ʉsə̀ bʉ̀ʉ səmok à dʉk də yi tse' yòŋsə̀ nə̀ bʉp ndzə ni'ì yi. ");
INSERT INTO yam_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma Jisòs bə bwema ye wèŋ à və̀ə, nə kə təəŋ sə ntòmbi, nə dʉk də wo to Jisòs də yi və. ");
INSERT INTO yam_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","À ye ŋga bwìŋ rwiŋ mʉ nda'à anə wùriŋ, fana bʉ̀ʉ yè'sə tsok fa yi də ma ye bə bwema ye wèŋ sə to yi sə ntòmbi. ");
INSERT INTO yam_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mvə̀'nə̀ Jisòs à yuk vɛ'nə, fana yi fek bʉ̀ʉ sə dʉk də, <<Ma am bə bwema am wèeŋ ndà wèŋ?>> ");
INSERT INTO yam_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Fana yi fəsə lis, nə kʉk yak bʉ̀ʉ sə̀ wo curə ya' ŋgʉ ni'ì yi, nə dʉk fa wo də, <<Curə ya' yè'e ma am bə bwema am sə.>> ");
INSERT INTO yam_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nə dʉk fe'lə dʉk də, <<Ŋwə̀ nə̀ fòpwe' nə̀ yi gʉ̀gə̀-a yusə̀ Nwì sə dʉk də yi gʉ̀, fana ye də yi mo tɛ̀' am nə ye njɛ̀' am nə ye ma am sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","À ye nùmbu mòk Jisòs lo ŋgòyə'rə fe'lə bwìŋ ŋgʉ ndzəp Galìli, fana bwìŋ kə benə fo' maŋgəŋgèŋ. Yi ni cum sənə ŋgwes mʉ ndzəpə̀. Bwìŋ təəŋ yàwo mʉ mfèŋ. ");
INSERT INTO yam_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mvə̀'nə̀ yi à sə yə'rə yà', yi sə tsoho fa yà'wèŋ bum ŋkʉ̀ʉŋntɛ̀ŋ. Yi cep yà' bə gbʉ'. Fana yi tsok wo dʉk də, ");
INSERT INTO yam_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","<<Wèeŋ yu'rə bə̀boŋ. Ŋwə̀ nəmòk à lòŋgòŋwə̀ ŋgwìi bum mʉ nzuù. ");
INSERT INTO yam_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ŋgwìi mok gbʉhʉ nooŋ sə mandzə̀. Swiŋ və, nə kə te' zʉ lo yà'. ");
INSERT INTO yam_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mok gbʉ mvwe' lìs ŋga nze ka fo' ŋkʉ̀ʉŋ yeŋ, nə to ca jwaŋ, bʉ̀ʉsə̀ nze à ye fo' jo. ");
INSERT INTO yam_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nùm to, yà' yum, nə kpʉ wes pwe' bʉ̀ʉsə̀ yà' à ka ŋgàŋ sə̀sap so. ");
INSERT INTO yam_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mok gbʉ mvwe' ndik sə̀ bə njàk, ndik sə kuk, nə ram te'lə bʉpsə yà', yà' kà zəm. ");
INSERT INTO yam_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mok à gbʉ̀ mvwe' nze nə̀ bə̀boŋ, nə kuk nə zəm, mok hum tɛ', mok hum ntùŋfu wèŋ, mok zəm ŋkʉ̀ mò'fis.>> ");
INSERT INTO yam_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yi lə̀sə ŋgòcèp də, <<Ŋwə̀ nə̀ wù tse'-a ntu' ŋgòyuk yusə̀ mʉ̀ cèp yè'sə, wù yuk.>> ");
INSERT INTO yam_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisòs à kə̀ cu mègù mok bə bwe ye sə̀ hum-ncòp-ba nə ye bʉ̀ʉ mok sə̀', fana wo ye ŋgòfek yi dʉk də, <<Tsok rɛŋsə fa ves gbʉ' nə̀ wù cèp màk taaŋ nà'a nɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yi dʉk fa yà' də, <<Nwì à gʉ̀ weŋ yàwèŋ ŋgòrì yu səmok bə gaŋ ŋkum ye sə̀ yà'a sə̀swihì bohòbʉ̀ʉ səmok. Fana bʉ̀ʉ sə̀ wo yàwo sə mbi, wo yuk gù yàwo gbʉ' nə. ");
INSERT INTO yam_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Fana wo sə kʉk nə kʉk, nə kà yə rì. Wo sə yuk nə kà rɛɛŋ. Bwɛ̀rɛ wo bʉʉŋ və bohòNwì yi swifa wo.>> ");
INSERT INTO yam_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisòs yèto ŋgòdʉk fa wo də, <<Wèŋ ka gbʉ' nè'e rɛŋ yè'e də wèeŋ nə rɛŋ yuk gbʉ' mok sə̀' laŋ à? ");
INSERT INTO yam_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ŋgà ŋwə̀ŋwə̀ à ŋwə̀ ncèp Nwì sə ntʉʉ̀ bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ntʉm bʉ̀ʉ mook co mandzə̀, wo yuk ncèp Nwì ntɛ̀ŋ, Satà və, nə kə jəŋ gɛsə ncèp nə sə ntʉʉ̀ wo anə. ");
INSERT INTO yam_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bʉ̀ʉ səmok yàwo co ŋgwìi sə̀ yà' à gbʉ̀ mvwe' nze nə̀ bə lìs. Yà'a wo sə̀ wo yuk ncèp Nwì, wo kwa bə zeŋ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mègù də ncèp nə kà sə ntʉʉ̀ wo cəco lò, fana ŋgə' və̀ bohòwo bʉ̀ʉ ncèp Nwì àlaa, wo təəŋ moòm ghàr nə yamak, nə gbʉ gɛsə lo fo'. ");
INSERT INTO yam_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bʉ̀ʉ mok yàwo yè'e co ŋgwìi sə̀ yà' à gbʉ̀ mvwe' ndik. Yè'e bʉ̀ʉ sə̀ wo yuk ncèp Nwì fana, ");
INSERT INTO yam_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bum nzeŋgòŋ kə jipsə tes wo, fana wo swi ncèp nə, nà' kà ŋgwì zəm. Bum sə̀ co ghàk bə bum mok sə̀ bwìŋ sə dzəm yà' sə nzeŋgòŋ anə ŋkʉ̀ʉŋntɛ̀ŋ, yà' kə jipsə ncèp nə. ");
INSERT INTO yam_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ŋgwìi sə̀ yà' à zəm mok hum tɛ', mok hum ntùŋfu, bə ŋkʉ̀ mò'fis wèŋ yà'a, yà'sə ntʉm bʉ̀ʉ səmok sə̀ wo yuk ncèp Nwì, nə dzəm nà' fana nà' ye co wo bì yumok mvwe' nze nə̀ bə̀boŋ fana yà' zəm vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisòs dʉk malì dʉk də, <<Wo bwe'gə̀ laàm, wo tes gesə ma sə ŋkò'o, kè wo tes gesə ma sə mbwè kè ɛ? Hai', ka vɛ'nə yeŋ. Wo tesgə̀ nà' mʉmvwe' dzòk. ");
INSERT INTO yam_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yumok sə̀ yà'a sə̀swihì, də yà'a nə̀ kà kə̀ yəəŋ ka yeŋ. Yè'sə də yusə̀ yà' cu mvwe' ndzəm nə̀ kə̀ və̀ mvwe' marɛŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yi sə dʉk fe'lə mali də, <<Ŋwə̀ nə̀ yi tse'-a ntu' ŋgòyuk bum bə zeŋ, yi yuk.>> ");
INSERT INTO yam_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yi tsok fa malì wo də, <<Njo nə̀ wo nə fʉk fəsə fa wu sə̀' bə nsàp yu nə̀ wu fʉ̀k fagə̀ bwìŋ ca, ghàmòk casə njo nə, fana yu'rə yusə̀ wù yuk bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wo nə fa ŋwə̀ nə̀ yi tse' ŋkʉ̀ʉŋ sə̀mok, fana ŋwə̀ nə̀ yi ka ye tse', wo nə jəŋ gɛsə bwe bè'lə̀ə sə̀ yi tse' sə pwe'.>> ");
INSERT INTO yam_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisòs à dʉk fe'lə mok sə̀' dʉk də, <<Gaŋ ŋkum Nwì sə co nzum ŋwə̀ nə̀ yi à ŋwə̀ nzaŋ mʉ nzuù yi. ");
INSERT INTO yam_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Yi nə dzəm lo, nə sə yəəŋ, nə dzəm lo, nə sə yəəŋ. Ŋgwìi nzaŋ sə to, nə sə kuk. Yi kà yuye yusə̀ yà' gʉ̀ yà' kuk rì. ");
INSERT INTO yam_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nze nə bə tu ye gʉ ntseŋ nə ŋgòkùuk, nə kə tse' mvə̀m. A yəəŋ to ntòntseŋ nə, ghàr tu nə yəəŋ, fana ŋgwì zəm nə gʉŋ. ");
INSERT INTO yam_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yà' gʉŋ ntɛ̀ŋ, yi jəŋ fɛ̀cɛ̀s, nə kə ci', bʉ̀ʉsə̀ mvə̀k nə̀ ŋgòkʉp kʉ̀rə laŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisòs jə və fe'lə ncèp mòk də, <<Aco a fʉ̀hʉ kok gaŋ Nwì sə yè'sə bə yà, kènə aco a fʉhʉ nà' yè'sə bə nsàp gbʉ' nə̀ fò? ");
INSERT INTO yam_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","A co mʉŋgwì tʉ nəmòk nə̀ wo togə̀ nà' də mostà. Wo bìgə̀ nà', nà' jə'rə casə ŋgwìi bum sə nzeŋgòŋ pwe' zeŋ. ");
INSERT INTO yam_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ghàr ŋga nà' kùuk, fana nà' yam casə tʉ pwe' sə̀' yi. Yi fis ma nsàap ntaŋ mok sə̀ ghaŋ. Swiŋ sə kə ci ndap awo mbwa, mvwe' fifi.>> ");
INSERT INTO yam_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisòs à tsòho fa bwìŋ ncèp nə bə nsàap gbʉ' yè'sə ŋkʉ̀ʉŋntɛ̀ŋ ya wo yuk, nə rɛɛŋ bə̀boŋni. ");
INSERT INTO yam_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ghà yà lòoŋ fo' nə̀ yi à sə cèp bohòwo, yi sə cèp megu bə gbʉ'. Fana yi kə̀ cu mègù mok bə ŋgàa fàak ye, yi tsòho rɛŋsə fa wo bum sə làaŋ. ");
INSERT INTO yam_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","À mègù nùmbu ànə ŋga nùm co tsə lòo, Jisòs dʉk fa ŋgàa fàak ye sə dʉk də bə yà'wèeŋ to lo nto ndzəp ma nja. ");
INSERT INTO yam_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bwe ye à ni ŋgwes nə̀ yi ànə ye ca nə. Ŋgwes mok à ye bə nə̀ Jisòs wèŋ nə mʉ ndzəpə̀ anə mvwe' mò'fis. Wo à lòo, nə me'rə bʉ̀ʉ sə̀ wo à ye fo' wùriŋ sə maŋkwɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Fə̀fə̀ nə̀ bʉp à yèto ŋgòcàa, nə sə bwi'lə ŋgwes nə mʉ ndzəpə̀ anə nsàp nə̀ bə jòŋ. Ndzəp ni ca, tə̀tè nà' kʉəp də nà'a rwiŋ. ");
INSERT INTO yam_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","À ye ŋga Jisòs naaŋ tu ye bə pilù, nə sə dzəm yuye lo mà ŋkwɛ̀ɛŋ bʉ̀ʉ sə̀ wo à cu sənə ŋgwes nə. Bwe ye sə yəmsə yi, nə fek yi dʉk də, <<Cicà, wù sə kà mbɛŋ kom yè'e də vèes kpʉ ntɛ̀ŋ à?>> ");
INSERT INTO yam_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yi à lòkok mʉtsə̀, nə dʉk fa fə̀fə̀ nə də, <<Teŋsə, kà mok cà fe'lə̀>>, nə dʉk bohòndzəp nə sə̀' də, <<Naaŋ yòsə̀' gəe'!>> Fə̀fə̀ à dʉk gù dok, fana ci'i təəŋ fo' mok wʉmm. ");
INSERT INTO yam_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A mèe, yi fek bwe ye sə də, <<Wèŋ sə wəp yè'sə yà? Kaco wèŋ fa ntʉm awèŋ bohòmʉ̀ yeŋ à?>> ");
INSERT INTO yam_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Və̀m à kok wo kiŋ, wo mərə, nə sə dʉk də, <<Nè'e nsàp ŋwə̀ nə̀ fò? Fə̀fə̀ bə ndzəp sə yuk yi ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nùmbu ànə à ye Jisòs bə bwe ye wèŋ to tesə lo nto ndzəp Galìli ma nja, nə tesə və ma ndzə nzeŋgòŋ Gerasàn. ");
INSERT INTO yam_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mʉmvə̀'nə̀ Jisòs à tesə sə ŋgwesə̀ anə ntɛ̀ŋ, ŋwə̀ nəmòk nə̀ yi nòoŋ kɛ'gə̀ mvwe' sè və kə tseŋ yi. ");
INSERT INTO yam_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ŋwə̀ ènə à tse' yòŋsə̀ nə̀ bʉp ndzə ni'ì yi, nə sə nòoŋ kɛ'cà mvwe' sə̀ wo tuuŋgə̀ bwìŋ. Mandzə̀ nə̀ co wo ko kiŋ noŋsə yi bə kwaŋ kà mok ye. ");
INSERT INTO yam_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wo à sə kì yi bo bə kù lòoŋfo' kɛ̀' ŋkʉ̀ʉŋntɛ̀ŋ bə kwaŋ, fana yi sə sòoŋ tirə yà' pwe'. Yi à gʉ vɛ'ɛ nsàp nə̀ ŋwè kà yi ko to. ");
INSERT INTO yam_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nə̀ maràŋ bə nə̀ ndzəmə̀ pwe' yi sə jàm kɛ' dzòoŋ mvwe' sè nə ye mʉ ndahà wèŋ. Yi sə waŋ kɛ', nə sə dzəp swɛ'lə ni' ye bə lìs. ");
INSERT INTO yam_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yi à təəŋ, nə ye gesə lo Jisòs, fana yi caŋ lo, nə kə gbʉ təəŋ kù mantombìi nà' bə tumfərə. ");
INSERT INTO yam_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Yi waŋ torə fis bə ŋàŋ dʉk də, <<Jisòs mo Nwì nə̀ ghaŋ, wù sə làp bohòmʉ̀ yà? Mʉ̀ lɛŋ wu mʉnə liŋ Nwì də wu kà mʉ ŋgə' fa.>> ");
INSERT INTO yam_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yi ànə dʉk vɛ'nə bʉ̀ʉsə̀ Jisòs à dʉk fa yi də, <<Wùu yòŋsə̀ nə̀ bʉp, tesə ndzə ni'ì ŋwə̀ ènə.>> ");
INSERT INTO yam_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jisòs fek nà' də, <<Liŋ yoo ndà?>> Yi dʉk də, <<Liŋ aam Bòp, bʉ̀ʉsə̀ vèes ndzə ni'ì ŋwə̀ ènə wùriŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yi lɛŋ Jisòs vɛ'ɛ wùriŋ də nà'a kà yòŋsə̀ə sə̀ bʉp sə mvwe' lak yà'sə bɛ'fis gɛsə̀. ");
INSERT INTO yam_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","À ye ŋga bòp ŋgùnaaŋ mòk nə̀ ghaŋ à sə zʉ mvwe' nda nəmòk fo' wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Fana yòŋsə̀ə sə̀ bʉp sə lɛŋ Jisòs də, nà'a dʉk fa wo də wo kə ni ndzə ni'ì ŋgùnaaŋ sə. ");
INSERT INTO yam_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisòs à dzəm, nə də wo geŋ, fana yòŋsə̀ə sə tesə ndzə ni'ì ŋgà' nə, nə kə ni ndzə ni'ì ŋgùnaaŋ sə. Ŋgùnaaŋ sə à ye fo' co ncùhù ba. Fana wo caŋ durə tsoŋ ndzə baàŋ anə, nə kə gbʉ kpʉ lo wes sənə ndzəp Galìli nə. ");
INSERT INTO yam_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bʉ̀ʉ sə̀ wo à sə gʉmsə ŋgùnaaŋ sə à carə lòo, nə kə tsoho fa bʉ̀ʉ sə̀ mvwe' lak yà'sə pwe'. Fana bwìŋ tesə və ŋgòkə̀ ja'a nsàp yu nə̀ nà' gʉ̀ nə. ");
INSERT INTO yam_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wo à və̀ bohòJisòs, nə ye ŋga ŋwə̀ nə̀ yi anə tse' yòŋsə̀ə sə̀ bʉp ndzə ni'ì yi nə ni tse' cə̀k, nə cum fe'lə bə ŋkərə̀ ye làaŋ. Fana wʉə ko wo nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bʉ̀ʉ sə̀ wo à kə̀ yə, à sə tsòho lòbwìŋ yusə̀ yà' ye bohòŋwə̀ nə̀ yi tse'gə̀ yòŋsə̀ə sə̀ bʉp nə, nə sə tsoho fa bwìŋ yusə̀ yà' gʉ̀ ŋgùnaaŋ sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","À ye vɛ'nə, fana bʉ̀ʉ sə̀ mvwe' lak yà'sə ye ŋgòlɛŋ Jisòs də nà'a me'rə lak awo sə, nə lo. ");
INSERT INTO yam_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mvə̀'nə̀ Jisòs à sə də yi ni lo sə ŋgwesə̀, fana ŋgà' nə̀ yi ànə tse' yòŋsə̀ə sə̀ bʉp nə dʉk fa nà' də bə nà'a lo. ");
INSERT INTO yam_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jisòs à dzèeŋ. Yi dʉk fa nà' də, nà'a lo la'à nà', nə kə tsok fa bwema nà' wèŋ mvəsə̀ Tà Nwì koksə manziŋ bohònà', nə tɛsə̀ nə nà' sə. ");
INSERT INTO yam_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ŋgà' nə à lòmvwe' nze Dìkàpolìs, nə tsoho fa bwìŋ yusə̀ Jisòs gʉ̀ bohòyi. Bʉ̀ʉ sə̀ wo à yuk à mərə nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Fana Jisòs ànə to fe'lə sənə ŋgwes, nə tesə lo ma mòk. À kə̀ dzèŋ fo', bwìŋ à kə̀ tsèŋ yi ŋgʉ ndzəp anə maŋgəŋgèŋ. ");
INSERT INTO yam_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ŋwə̀ nəmòk à və̀ fo' nə̀ wo à sə to yi də Jairòs. Yi ànə ye ŋwə̀ nə̀ mantombì mʉnə ndap pìriyà. Yi à yə Jisòs ntɛ̀ŋ, yi kə gbʉ nooŋ kù mantombìi nà', ");
INSERT INTO yam_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nə lɛŋ yi vɛ'ɛ bə zìnə ye pwe'fo' də, mo ye nə̀ ŋwàŋwè sə də yi kpʉ. Yi dʉk fa nà' də, <<Və̀ə kə̀ jwɛ̀ŋ mo àm nə bə bo yo ya yi gʉŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Fana bə nà' à lòo. Bwìŋ yuŋ fɛ'lə wo sə̀' nduk nsàp nə̀ co wo kà Jisòs yə gèsə lò. ");
INSERT INTO yam_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mvə̀'nə̀ wo à sə lòo, ŋwà mòk à ye nə̀ ndʉəm à sə ca ndzə ni'ì yi mʉnə lùumŋgòŋ hum-ncòp-ba. ");
INSERT INTO yam_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yi à yə ŋgə' cɛ̀bʉ̀ə̀, nə bʉpsə wes mbàam ye bohòŋgàa ncə̀p pwe', nə kà bə̀boŋ tse' lok. Yiyaŋ sə lo megu mantombì nùumbu pwe'. ");
INSERT INTO yam_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Njo à ye də yi ànə yuk nsàp fàk nə̀ Jisòs à sə gʉ̀ʉ, fana yi nik ca mʉtsətsə'rə bwìŋ, nə kə jwɛŋ gesə cə̀k nà'. ");
INSERT INTO yam_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yi à gʉ̀ vɛ'nə bʉ̀ʉsə̀ yi à sə tsərə də, <<Mʉ jwɛŋ mègù-a cə̀k ye bə bo am, yiya àm nə me.>> ");
INSERT INTO yam_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mvə̀'nə̀ yi à jwɛ̀ŋ gèsə nà' ntɛ̀ŋ, ndʉəm sə teŋsə ŋgòca, yi riŋ ndzə ni'ì yi sə̀' də yiyaŋ nə mè laŋ. ");
INSERT INTO yam_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jisòs riŋ ye sə̀' də ŋàaŋ sə̀ yi lùŋsəgə̀ bwìŋ bə zeŋ sə mamòk tesə ndzə ni'ì yi anə. Fana yi bʉʉŋ mʉtsətsə'rə bʉ̀ʉ sə, nə fek wo dʉk də, <<Jwɛ̀ŋ cə̀k àm ndà?>> ");
INSERT INTO yam_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ŋgàa fàak ye dʉk fa yi də, <<Aco wù sə ye mvə̀'nə̀ bwìŋ sə fɛ'lə kɛ'cà vɛ'ɛ, wù sə fek də, jwɛ̀ŋ wu ndà yè'e nsàp nə̀ fò?>> ");
INSERT INTO yam_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jisòs sə kʉksə malì mʉtsətsə'rə bʉ̀ʉ sə də yi ye riŋ tsoŋ ŋwə̀ nə̀ nà' jwɛ̀ŋ yi nə ŋkuŋ. ");
INSERT INTO yam_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ŋwà nə riŋ yusə̀ yà' ànə gʉ bohòyi, fana yi wəp, nə tesə və mantombìi Jisòs, nə sə kaŋ, fana nə gbʉ nooŋ sə nze, nə tsoho fa nà' yusə̀ yi gʉ̀ sə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yi ànə yuk vɛ'nə, yi dʉk fa ŋwà nə dʉk də, <<Mʉmvə̀'nə̀ wù dzəmtse' sə ntʉʉ̀ wù bohòmʉ̀ yà'sə, gʉŋsə wu zeŋ. Lòkok mʉtsə̀, nə lo bə fifi sə ntʉʉ̀ wù. Yiya yònə mè sə̀' laŋ, mo àm.>> ");
INSERT INTO yam_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisòs à sə dʉk də yi cèp mèsə bohòŋwà ènə ntɛ̀ŋ, bwìŋ caŋ və ŋgòtsə̀' fa Jairòs də, mo nà' nə kpʉ laŋ. Nà'a kà cicà nə ŋgə' mok ŋgwàŋ fa yisko'. ");
INSERT INTO yam_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisòs kà yuye yusə̀ wo sə tsə̀' fa Jairòs sə co yumòk jə, nə dʉk fa nà' də, <<Kà yumok wəp, tse' megu yòdzədzəm.>> ");
INSERT INTO yam_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","À ye vɛ'nə, yi kà mok dzəm də bwìŋ ŋkʉ̀ʉŋ yuŋ lo yi mvwe' ndap Jairòs nə dzəm. Yi jəŋ megu bwìŋ tɛ', Pità bə Jem nə ye Jon moma Jem nə. ");
INSERT INTO yam_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wo à kə̀ dzèŋ mvwe' ndap nə, wo ye ŋga bwìŋ sə warə nə sə kɛ' ŋgùŋ nə̀bʉp, nə jip yusə̀ co wo gʉ̀. ");
INSERT INTO yam_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yi à ni lòmʉ nda'à anə, nə fek yà'wèŋ dʉk də, <<Wèŋ sə kɛ̀' dʉksə ŋgù yà? Mo nə ka kpʉ, yi sə dzəm lo.>> ");
INSERT INTO yam_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wo à ywì'lə swee bʉ̀ʉsə̀ yi à dʉk də mo nə sə dzəmlo. Yi bɛ' yà' fo' pwe', nə to ma bə tɛ̀'ɛ mo nə, nə ye bwe ye sə̀ tɛ' sə̀ yi anə və bə yà'wèŋ sə. Wo ni lo mvwe' sə̀ mo nə nòsə. ");
INSERT INTO yam_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yi kotse' bo nà', nə dʉk fa nà' bə ncèep lak nà' də, <<Talità, kumì.>> A yà'a də, <<Njɛ̀'gù, lòkok mʉtsə̀.>> ");
INSERT INTO yam_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mʉŋgwɛŋ nə à lòkok wap kɛ̀' mò'fis, nə gi yuye. À ye ŋga mʉŋgwɛŋ nə lùumŋgòŋ hum-ncòp-ba. Və̀m à ko' bwìŋ vɛ'ɛ kùŋ bə məmərə̀. ");
INSERT INTO yam_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisòs à cèp vɛ'ɛ, nə soŋ wo ntu' də ŋwèe kà ŋwə̀ nəmòk tsə̀' fa swì, nə dʉk də yà'a lap fa nà' yu zʉzʉ. ");
INSERT INTO yam_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisòs à ye'e mè'rə fa'nə, nə lo la'à yi. Bwe ye yuŋ lo yi sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nùmbu dzə̀ à ye, yi sə yə'rə bwìŋ mʉ ndap pìriyà. Bwìŋ à ye mbwa wùriŋ. Mvəsə̀ wo à yuk yusə̀ yi à sə cèep, fana wo mərə nə̀bʉp, nə sə dʉk də, <<Hàva', yi a jə nsàp nè'nə yè'e ma fò? Wo a fa yi yè'e nsàp ŋkərə̀ nə̀ fòvɛ'nə ɛ? Yi sə gʉ̀ bə bum maŋgəŋgèŋ mwè. ");
INSERT INTO yam_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nè'e ka kapindà, mo Mèri yeŋ nɛ̀, tə̀tàa Jem bə Josìs bə Judàs nə ye Saimʉ̀ yeŋ ɛ̀? Cu fɛŋ yè'e ka njɛ̀'ɛ ye yeŋ à?>> Fana wo bɛŋ yi. ");
INSERT INTO yam_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisòs dʉk fa wo də, <<A yegə̀ də wo jəgə̀ ŋgà tsòhòbum Nwì ma nə̀ yi lòfòpwe' co ŋwè. A kə̀ dzèŋ mvwe' lak ye, nə ye mʉ nda'à yi fana wo kà yi co yumok jə. Bwe tɛ̀' nə ye bə bwema ye wèŋ kà yi co yumòk sə̀' jə.>> ");
INSERT INTO yam_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yi à ka mandzə̀ nə̀ co yi gʉ maŋgəŋgèŋ fa'nə tse' lok, megu də yi à bɛŋ naaŋ fa ŋgàa yiyaŋ mok wèŋ bo, fana wo gʉŋ yu awo. Wo à ye mègù moòm jo. ");
INSERT INTO yam_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mʉmvə̀'nə̀ bʉ̀ʉ sə̀ fo' sə à ka dzədzəm bohòJisòs tse', fana yi mərə nə̀bʉp. Fana yi sə yə'rə lòkɛ' bwìŋ mok mvwe' buhu lak sə̀ yà' à ye fo' sə. ");
INSERT INTO yam_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisòs à to be'lə bwe ye sə̀ hum-ncòp-ba sə mvwe' mò'fis, nə tumsə lo wo ba ba, nə fa wo ŋàaŋ sə̀ ŋgògha' yòŋsə̀ə sə̀ bʉp. ");
INSERT INTO yam_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yi dʉk fa yà' dʉk də, <<Wèeŋ cu ŋgòlòo, wèŋ kà yumòk jə tse' lò. Wèŋ jəŋ mègù ntʉmbàŋ, nə kà bɛŋ kè bàm kè mbàm sə bàam cə̀'ə wèŋ jə tse'. ");
INSERT INTO yam_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Wèeŋ so megu kùuŋgùp, nə kà cə̀k nə̀ nini mòk jə tse'.>> ");
INSERT INTO yam_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yi tsok fe'lə wo mok sə̀' dʉk də, <<Mvwe' ndap nə̀ wèŋ nòoŋ fo' wèŋ cum megu mvwe' ndap nà'nə tèè wèŋ mè'rə lak yà'sə. ");
INSERT INTO yam_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ŋga wèŋ lò-a mvwe' səmok, bʉ̀ʉ sə̀ fo' kà weŋ mvwe' ndap awo dzəm, kènə də wo kà yusə̀ wèŋ sə cèep yuk àlɛ', wèŋ me'rə fo', nə kɛ'sə mak mfə̀mfəə kùu awèŋ fo'. Yà'a nə ye yumok ŋgònì tsə̀' də wo à ka weŋ fo' dzəm.>> ");
INSERT INTO yam_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yi ànə dʉk wo vɛ'nə, fana wo lo, nə sə tsoho lo fa bwìŋ də wo kupsə, nə bwi fa bʉp awo ŋkwɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wo à bɛ'fis yòŋsə̀ə ze' ŋkʉ̀ʉŋntɛ̀ŋ, nə yok ŋgàa yiyaŋ ŋkʉ̀ʉŋ bə mve', wo sə gʉŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ŋkum Heròà yuk bum yè'sə sə̀', bʉ̀ʉsə̀ liŋ Jisòs à yuhu mʉmvwe' ànə pwe'fo'. Bʉ̀ʉ səmok à sə dʉk də Jon ŋgà bàptɛsə̀ bwìŋ a tesə və̀ fe'lə mvwe' kpʉ laŋ. Nà'a njo nə̀ yi sə gʉ̀ to bum maŋgəŋgèeŋ yè'sə. ");
INSERT INTO yam_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mok dʉk yàwo də, yi Àlajà. Mok sə dʉk yàwo sə̀' də yi ŋgà tsòhòbum Nwì co sə̀ wo à ye taaŋ mantombì yà'a. ");
INSERT INTO yam_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Heròànə yuk, fana yi dʉk də, a lù Jon nə̀ yi à gwɛ̀' tiŋ nà' tu nà'nə. ");
INSERT INTO yam_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bʉsə̀ Heròbə tu ye à fa ŋàŋ, fana wo ko Jon, nə kiŋ yi bə kʉ̀, nə kə nisə yi ndapndzəm. Heròà gʉ̀ vɛ'nə njo nə̀ Jon nə à ka dzəm də nà'a fep jəŋ Hèrodiyà ŋgwe moma ye Filìp dzəm. ");
INSERT INTO yam_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon à yuk vɛ'nə, yi sə tsoho Heròsəsa də, a bʉp bohònà' ŋgòkə̀ jə ŋgwe moma ye. ");
INSERT INTO yam_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","A ye vɛ'nə, fana Hèrodiyà jok, nə sə rom də yi nə zə Jon. Yi kà mandzə̀ nə sə̀' tse' njo Herò. ");
INSERT INTO yam_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Heròà sə wəp Jon wəpə bʉ̀ʉsə̀ yi à rì də Jon ŋwə̀ nə̀ kə̀kʉrə̀ nə ye rərɛŋ. Fana yi sə nòŋsə Jon nə bə̀boŋ. Yusə̀ Jon cèep, yà' yaaŋ Heròsə ntʉʉ̀ nə̀bʉp. Yi sə dzəm mali co yi yu'rə mali yusə̀ nà' sə cèp sə fo'. ");
INSERT INTO yam_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hèrodiyà à tse' mandzə̀ ye nùmbu nə̀ wo à tse' ŋkàk də nùmbu nə̀ wo à dzə Heròkə̀ dzèeŋ. Heròà gʉ̀ dinà, nə to bʉ̀ ŋgàa fàak gomè sə̀ ghaŋ, bə ŋkum sojà wèŋ, nə ye bʉ̀ʉ sə̀ ghaŋ sə̀ mvwe' nzeŋgòŋ Galìli pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mo Hèrodiyà mòk nə̀ ŋgwə̀ŋgwɛ̀ŋ à kà dzeŋ, boŋ Heròbə bʉ̀ʉ sə̀ yi à to yà' sə pwe'. Fana Heròdʉk fa mo ŋwà nə də yi nə fa nà' nsàp yu nə̀ nà' dzəm lòoŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yi à kɛ̀ŋ vɛ'ɛ nə̀ zìnə də, yusə̀ nà' dzəm pwe', yi nə fa nà', də a ye-a sə̀' də yi gàpsə nze ye mʉtsətsə'rə̀, nə fa nà' ma mok, yi nə fa nà'. ");
INSERT INTO yam_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mo nə yuk vɛ'nə, yi lo, nə kə fek ma ye də, yi kə dʉk də wo fa yi yè'sə yà lɛ. Ma ye nə dʉk də, <<Dù kə̀ dʉk də, tu Jon ŋgà bàptɛsə̀ bwìŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mo nə caŋ foho lo, nə kə dʉk fa Heròdə, <<Mʉ̀ sə dzəm ŋga'a də wu fa mʉ tu Jon ŋgà bàptɛsə̀ bwìŋ mʉnə tasà.>> ");
INSERT INTO yam_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ŋkum nə à yuk vɛ'nə, ŋgùp cù gbʉ̀ yi yə̀k, manziŋ ko yi nə̀bʉp. Mandzə̀ nə̀ co yi bɛ̀ŋ ye sə̀' bʉ̀ə̀ bʉ̀ʉsə̀ yi anə kɛ̀ŋ, bʉ̀ʉ sə̀ yi a to sə pwe' sə yuk. ");
INSERT INTO yam_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Fana ŋkum nə tumsə sojà nə̀ nà'a kʉ̀kgə̀ yi də nà'a kə̀ gwɛ̀' cok və̀ tu Jon jwè. Sojà nə à lòmʉ ndapndzəmə̀ anə, nə kə gwɛ' cok fis və tu Jon sə. ");
INSERT INTO yam_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Yi à jə və̀ yà' mʉnə tasà, nə kə fa mʉŋwà nə. Yi jəŋ, nə kə fa ma ye. ");
INSERT INTO yam_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ŋgàa fàak Jon wèŋ à yuk də wo zə Jon laŋ, wo və, nə kə bək jəŋ lo ve ni' Jon nə, nə kə tuuŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ŋgàa ntum Jisòs à bwìŋ və̀ə, nə kə tseŋ Jisòs, nə tsoho fa yi yusə̀ wo gʉ̀ʉ nə yə'rə fa bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bwìŋ à sə və̀ ŋkʉ̀ʉŋ, nə sə lo ŋkʉ̀ʉŋ nsàp nə̀ Jisòs bə ŋgàa ntum ye à ka mvə̀k ŋgòyòŋsə̀ tse'. Fana yi dʉk fa wo də, <<A lo mvwe' sə̀sap sə̀ anə ye megu fo' vesùwèŋ, ya ŋga a yoŋsə.>> ");
INSERT INTO yam_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Fana wo à mè'rə, nə ni sənə ŋgwes woòwo ŋgòlòmvwe' sə̀ bwìiŋ fo' bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mvəsə̀ wo à sə lòo, bwìŋ sə ye tasə tse' wo, nə sə carə lo sə̀' mvwe' sə̀ wo sə lòo sə, nə kə dzeŋ to fo' ntòwo. Bʉ̀ʉ yè'sə à sə tesə və̀ mvwe' bòop lak zəzok. ");
INSERT INTO yam_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisòs à dʉk də yi tesə sənə ŋgwes, yi ye ŋga bwìŋ təm tə yè' ŋkʉ̀ʉŋ. Fana ntʉm ye rwiŋ bə manziŋ bʉ̀ʉsə̀ wo co nsùŋgaaŋ sə̀ jì ganakù'. Fana yi ye ŋgòyə'rə wo bum ŋkʉ̀ʉŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mvə̀k à càa, ŋgàa fàak ye wèŋ və bohòyi, nə kə dʉk fa yi də, <<Nùm lòlaŋ, fana ka fɛɛŋ la'à ye. ");
INSERT INTO yam_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tumsə bʉ̀ʉ yè'sə wo lo mvwe' nzum nə ye buhu lak sə̀ yà' tərə yà'a ŋgòlàp ywiŋ yumok ŋgòzʉ.>> ");
INSERT INTO yam_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yi dʉk fa wo dʉk də, <<Wèeŋ kʉk fa wo yumok wo zʉ.>> Wo fek yi də, <<Wù dzəm də vèes lo kə bʉpsə bàm mbàm mò'fis, nə ywiŋ bɛŋ ŋgòfa wo à?>> ");
INSERT INTO yam_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yi fek fe'lə wo dʉk də, wo tse' ntuk brɛd sʉ̀ nɛ? Dù nə kə kʉk ɛ. Wo à foho və̀ə, wo dʉk fa yi də, <<Vès tse' ntuk brɛd tàŋ, nə ye fuk ba.>> ");
INSERT INTO yam_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jisòs dʉk fa wo də, <<Cumsə bʉ̀ʉ sə mʉnə nʉ̀əm ŋgaŋ fa'a bə bòp zəzok.>> ");
INSERT INTO yam_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Fana bʉ̀ʉ sə à cu bə bòp zəzok, mok ŋkʉ̀ mò'fis, mok hum tàŋ wèŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Fana Jisòs jəŋ ntuk brɛd sə̀ tàŋ, nə ye fuk sə̀ ba sə. Yi kʉ̀k gesə lis mʉbu, nə kwasə Nwì, nə bək brɛd sə, nə fa ŋgàa fàak ye də yà'a gap fa bʉ̀ʉ sə. Yi à gàpsə fuk sə̀ ba sə sə̀', nə fa wo lòoŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wo à zʉ wo pwe', nə ze' bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ŋgàa fàak ye à te'e benə sə̀ bwehe sə kwès hum-ncòp-ba. ");
INSERT INTO yam_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bʉ̀ʉ sə̀ wo à zʉ sə à ye mbəmbam ncùhù tàŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ànə geŋ, Jisòs gʉ̀ də bwe yee ni ŋgwes, nə lo mantombì ŋgòto lòma ndzə mvwe' lak sə̀ wo togə̀ fo' də Bèsadà. Yi nə cum ye maŋkwɛ̀ŋ, nə cepsə bwìŋ ya wo lo la'à wo. ");
INSERT INTO yam_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yi ànə cepsə wo, wo lo. Fana yi lo ye mʉmvwe' nda mòk ŋgòkə̀ gʉ̀ pìriyà mbwa. ");
INSERT INTO yam_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nùm à co ŋga ndzəm sə seŋ və̀ə, ŋgwes nə ye mok mʉtsətsə'rə ndzəp ŋga Jisòs cu malì mvwe' sə̀ yi anə lo sə yiìyi. ");
INSERT INTO yam_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yi ànə riŋ ye də yà' sə yə ŋgə' bə ŋgwes nə nə̀bʉp, bʉ̀ʉsə̀ fə̀fə̀ à sə və̀ ma nə̀ wo à sə dzəm ŋgòlòo nə. À kə̀ dzèŋ mvə̀'nə̀ mvəp à yè ŋgòtorə ndzəmə̀ anə fana Jisòs və bohòwo ŋga yi sə gì və mʉ ndzəpə̀, nə sə ca lo càa. ");
INSERT INTO yam_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bwe ye sə ànə ye yi mvə̀'nə̀ yi sə gì mʉ ndzəpə̀, fana wʉə ko wo vɛ'ɛ nə̀bʉp. Wo dʉk ŋgwàaŋ də, a maze' mòk, nə kɛ̀' nooŋ ŋgùŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bʉsə̀ wo ànə ye yi, wʉə ko wo lòoŋ fo'. Ànə geŋ yi to yà'wèŋ sə̀' ntɛ̀ŋ, nə dʉk fa wo də, <<A mʉ̀, wèeŋ kà wəp.>> ");
INSERT INTO yam_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yi à ni lòsənə ŋgwes nə, fana fə̀fə̀ nə teŋsə. Bwe ye sə mərə bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bʉsə̀ wo ànə ka nzak ntuhu brɛd sə̀ tàŋ sə riŋ, fana wo kà yè'sə rɛɛ̀ŋ. Ntʉm awo à ye malì gʉgʉŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wo à to tesə lòmʉmfèŋ fana wo tesə və mvwe' lak Jènesarè, fana wo me'rə tes ŋgwes awo sə ŋgʉ ndzəp anə. ");
INSERT INTO yam_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mvə̀'nə̀ wo à tesə sənə ŋgwes nə ntɛ̀ŋ, bwìŋ ye riŋ Jisòs sə̀ ntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Fana wo yeto ŋgòcarə lòla'à wo, nə bək jəŋ və ŋgàa yiyaŋ awo pwe' mʉ ntə̀əŋ, nə sə yuŋ lo kɛ' Jisòs bə zeŋ mʉmvwe' nə̀ wo yuk də yi fo'. ");
INSERT INTO yam_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mvwe' sə̀ Jisòs à sə kɛ' lòpwe', mvwe' mʉbuk lak kè lak sə̀ ghaŋ ɛ̀', wo bəhə noŋsə ŋgàa yiyaŋ awo mvwe' jəja. Mvə̀'nə̀ Jisòs à càa, wo sə lɛŋ yi də nà'a me'rə ŋgàa yiyaŋ sə wèeŋ jwɛŋ megu cù cə̀k ye ya wo gʉŋ. Bʉ̀ʉ sə̀ wo à jwɛ̀ŋ pwe'fo', à gʉ yu awo. ");
INSERT INTO yam_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bʉ̀ʉ Faràsi, nə ye bʉ̀ ŋgàa yə'rə̀ lʉ̀k à tesə mvwe' lak Jòrosalèm, nə kə tseŋ Jisòs, ");
INSERT INTO yam_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","nə ye də ŋgàa fàak Jisòs mok sə zʉ bɛŋ nə kà bo bə mandzə̀ nə̀ bʉ̀ʉ Faràsi dzəmgə̀ə nə cùk. ");
INSERT INTO yam_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bʉsə̀ bʉ̀ʉ Faràsi bə bʉ̀ʉ Jus pwe' cùkgə̀ bo awo bə nsàp mandzə̀ nə̀ tɛ̀' awo sə̀ mantombì à tsə̀' wo ŋkuŋ nə zʉ yumok. ");
INSERT INTO yam_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wo bwi və ntɛŋ, wo kà yumok zʉ tè ŋga wo cùk bo ŋkuŋ. Bum mok sə̀' ŋkʉ̀ʉŋntɛ̀ŋ sə̀ wo à sə yùu, co ŋgòcùk ŋgàp bə kʉ̀ŋ, tasà nə ye dzòho ncum sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","À ye vɛ'nə bʉ̀ʉ Faràsi bə bʉ̀ ŋgàa yə'rə̀ lʉ̀k wèŋ sə fek Jisòs də, ŋgàa fàak nà' sə kà bum lak sə̀ ŋkwàha bwìŋ wèŋ à nòŋsə yù, nə sə zʉ bɛŋ bə bo jep bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisòs dʉk wo də, <<Yusə̀ Ìzayà ànə cep mantombì sə kum weŋ ŋgàa tè'èŋkup à ye zìnə. Yi à còm də, <Bʉ̀ʉ yè'e wəpgə̀ mʉ bə cù, fana ntʉm awo ye mvwe' sə̀sap bohòmʉ̀. ");
INSERT INTO yam_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wo sə kùksə basə mʉ ŋgwàŋ, bʉ̀ʉsə̀ wo sə yə'rə yusə̀ bwìŋ à cèp wo co yà'a lʉ̀ʉk Nwì.> ");
INSERT INTO yam_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Wèŋ mè'rə lʉ̀ʉk sə̀ Nwì sə maŋkwɛ̀ŋ, ŋgòyù bum sə̀ bwìŋ sə dʉk wo gʉgʉŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisòs dʉk malì də, <<Wèŋ tse' nsàp ŋkərə̀ nə̀ ŋgòmè'rə lʉ̀ʉk Nwì, nə kotse' bum lak awèŋ. ");
INSERT INTO yam_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musì à dʉk də, <Wəp ma yo bə tɛ̀' yo. Ŋwə̀ nə̀ yi yò-a ma kè tɛ̀' ye àlɛ, wo zə megu yi zə.> ");
INSERT INTO yam_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Fana wèŋ cwiŋ bʉsə yàwèŋ dʉk də, a ye-a ŋga ŋwè tse' yumok sə̀ co yi tɛsə ma ye bə tɛ̀' ye bə zeŋ, nə kà yà' tɛsə̀, nə dʉk fa yà'wèŋ də, <Yusə̀ mʉ̀ tse' sə Korbàn> (a yà'a dʉk də, yà'a sə̀ Nwì), ");
INSERT INTO yam_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nə kà-a ma bə tɛ̀' mòk sə̀ tɛsə̀, wèŋ sə dʉk də, yi ka nzak tse'. ");
INSERT INTO yam_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nà'a mandzə̀ nə̀ wèŋ sə jəŋ ncèp nə̀ Nwì co yusə̀ ŋgwàŋ bʉ̀ʉ bumlak sə̀ wèŋ yuk jəŋ bohòtɛ̀' awèŋ sə. Bum mok cu sə̀' ŋkʉ̀ʉŋ sə̀ co nè'nə sə̀ wèŋ sə yù tse' yà'.>> ");
INSERT INTO yam_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ànə geŋ Jisòs to benə və bʉ̀ʉ sə wèŋ pwe'fo' ŋgʉ ni'ì yi, nə dʉk fa yà'wèŋ də, <<Wèeŋ yu'rə, nə rɛɛŋ yusə̀ mʉ̀ sə də mʉ tsok weŋ yè'e bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wèeŋ riŋ tse' bə̀boŋ də, yusə̀ yà'a ni lògə̀ ma ndzə ni'ì ŋwè, nə gʉ bʉpsə ŋgə̀ŋgàaŋ bʉ̀ə̀. A bʉpsəgə̀ ŋwè yusə̀ yà' tesə ya' ndzə ni'ì yi tesə. ( ");
INSERT INTO yam_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ŋwə̀ nə̀ yi tse'-a ntu' ŋgòyuk bum fo', yi yuk.)>> ");
INSERT INTO yam_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","À kə̀ dzèŋ ghà nə̀ yi à mè'rə bʉ̀ʉ sə, nə lo mʉ nda'à, fana ŋgàa fàak ye wèŋ və, nə kə fek yi yumok bə gbʉ' nə̀ yi nə cep nə. ");
INSERT INTO yam_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisòs dʉk fa wo də, <<Wèŋ ka sə̀' rɛŋ co bʉ̀ʉ mok à? Wèŋ ka riŋ də yusə̀ yà'a ni lògə̀ ma ndzə ni'ì ŋwè, yà' ka ŋgògʉ̀ bʉpsə yi yeŋ riŋ à? ");
INSERT INTO yam_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Njo nə də yà'a kà ma sə ntʉʉ̀ yi lògə̀. Yà'a lògə̀ ma sə və̀ə, nə ca tesə lo.>> Yi à cèp yè'sə ŋgòtsə̀' də nsàp zʉzʉ nə̀ fòlòoŋ bə̀boŋ co ŋwè zʉ yà'. ");
INSERT INTO yam_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yi sə cèp malì sə̀mok də, <<À gʉ̀ bʉpsəgə̀ ŋwè yusə̀ yà' tesə ya' ndzə ni'ì yi tesə. ");
INSERT INTO yam_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bʉsə̀ bʉp yètogə̀ ma sə ntʉʉ̀ ŋwè. Yi tsərə ŋgònòoŋ ŋwàŋwè, yə̀yə̀, zə ŋwè, nòoŋ ŋgwe ŋwè, ");
INSERT INTO yam_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","waŋ bum ŋwə̀ mòk, ŋkʉ̀ì', ci' mvwès, jì marè'tu, gʉ̀ bʉpsə liŋ ŋwè, nɛ̀ ni', nə ye bum ləm. ");
INSERT INTO yam_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bum sə̀ bʉp yè'e pwe'fo' tesə yakgə̀ ndzə ni'ì ŋwè, nə bʉpsə ŋwə̀ nə.>> ");
INSERT INTO yam_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisòs à mè'rə Galìli, nə lo mvwe' nzeŋgòTayà, nə kə ni cum mʉmvwe' ndap nəmòk də ya bwìiŋ kà rì də yi fo' rì. Fana mandzə̀ kà bohòyi ŋgòswìhi ye. ");
INSERT INTO yam_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Mʉŋwà nəmòk nə̀ yi à tse' yòŋsə̀ nə̀ bʉp à ye mvwe' lak yà'sə. Fana ma ye yuk də Jisòs və̀ ntɛ̀ŋ, yi və bohònà', nə kə gbʉ sə nze, nə sə lɛŋ nà' də nà'a kə bɛ'fis fa yi yòŋsə̀ nə̀bʉp ndzə ni'ì mwe. Yi à sə lɛŋ nà' vɛ'nə ŋga yi ŋwà lakmvum. Yi à ye ŋwà Fònisiyà mvwe' nzeŋgòŋ Siriyà. ");
INSERT INTO yam_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Fana yi dʉk fa ŋwà nə də, <<Ka bə̀boŋ ŋgòjə bɛŋ mwe, nə mak fa ŋgbʉ yeŋ. Bòdə a fa bwe zʉzʉ ŋkuŋ>> ");
INSERT INTO yam_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ŋwà nə dʉk də, <<Tà, wù rì yòsə̀' də wo fagə̀ bwe bɛŋ, ŋgbʉ sə te'e sə̀ yà' sə gbʉ̀ tsoŋ sə nze sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yi dʉk fa fe'lə ŋwà nə dʉk də, <<Dù-a, yòŋsə̀ nə̀ bʉp nə mè'rə mo yònə laŋ, bʉ̀ʉsə̀ wù cèp ncèp nə̀ bə̀boŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yi bwi foho lo, nə kə tseŋ mo ye nə ŋga nà' nòmʉ kèhe ŋga yòŋsə̀ ze' nə lòlòye kwà'kə̀. ");
INSERT INTO yam_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisòs à ye'e Tayà fa'nə, nə lo mvwe' lak Sidòŋ, nə ca lo mvwe' ndzəp Galìli, nə ca mvwe' nzeŋgòDìkàpolìs. ");
INSERT INTO yam_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","À kə̀ dzèŋ fo', wo jəŋ və fa yi ŋwə̀ nəmòk nə̀ yi kà cù bə̀boŋ cèpgə̀ nə kà bum sə̀' sə yuk. Nə lɛŋ yi də yi jwɛŋ nà' bə bo. ");
INSERT INTO yam_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jisòs à jə gɛsə lònà' yiìyi, nə kə so gesə fa yi ndubo fə ntu'ù, nə te nte, nə jwɛŋ lʉm nà' bə zeŋ, ");
INSERT INTO yam_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","nə kʉk gesə lo lis mʉbu, nə som cɛ̀bʉ̀ə̀, nə dʉk bə ŋàŋ də, <<Mùhu.>> A bə ncèep lak sə̀ yi à cèep sə də, <<Efatà.>> ");
INSERT INTO yam_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ntu'u sə à mùhu, lʉm fìiŋ yi, fana yi cep bum làaŋ. ");
INSERT INTO yam_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisòs cep soŋ bʉ̀ʉ sə̀ fo' sə ntu' də wo kà bwìŋ tsə̀' fa. Yi dʉkgə̀ vɛ'nə, wo kà mbɛŋ nə̀ mbɛŋ kom lok, wo sə tsoho lo gù mantombì. ");
INSERT INTO yam_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bwìŋ à mərə cɛ̀bʉ̀ə̀, nə sə dʉhʉ də, <<Yi gʉ̀ bòŋsə bum mbà, yi gʉ ŋgàa jì ntu' yuk bum, nə gʉ ŋgàa jì cù ŋgòcèp cù.>> ");
INSERT INTO yam_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nùmbu mòk à ye sə̀', bwìŋ à baaŋ və̀ mvwe' mò'fis ŋkʉ̀ʉŋntɛ̀ŋ ŋgòyuk Jisòs, fana nə kà yusə̀ ŋgòzʉ tse'. Jisòs to benə ŋgàa fàak ye ŋgʉ ni'ì yi, nə dʉk fa wo də, ");
INSERT INTO yam_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","<<Manziŋ sə ko mʉ bohòbʉ̀ʉ yè'e cɛ̀bʉ̀ə̀ bʉ̀ʉsə̀ wo cu vesiwèŋ ntinə nùumbu tɛ', nə kà yumok zʉ. ");
INSERT INTO yam_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mʉ dʉk-a də wo bwi foho lo ŋga wo ka yumòk zʉ, aco mok kə̀ gbʉ̀ njè mandzə̀ bʉ̀ʉsə̀ mok və̀ mvwe' sə̀sap.>> ");
INSERT INTO yam_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bwe ye sə fek yi də, <<Aco ŋwè jəŋ zʉzʉ ŋgəà fɛɛŋ fòŋkuŋ nə fa bʉ̀ʉ yè'e lòoŋ ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yi fek fe'lə wo də, yà'wèŋ tse' ntuhu brɛd fɛɛŋ sʉ̀ nɛ? Wo dʉk də, mègù sàmba. ");
INSERT INTO yam_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yi jəŋ ntuhu brɛd sə̀ sàmba sə, nə dʉk bwìŋ pwe' cum nze. Yi à kwasə wes Nwì, yi bə'rə yà', nə fa ŋgàa fàak ye də yà'a fa ndàaŋwè pwe'fo' zʉ. ");
INSERT INTO yam_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bwe fuk mok à ye fo' jo sə̀'. Yi jəŋ yà', nə kwasə Nwì, nə dʉk bwe fàak ye də wo fa bʉ̀ʉ sə wo zʉ. ");
INSERT INTO yam_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wo zʉ, nə ze' bə̀boŋni. Fana wo te'e fe'lə sə̀ yà'a nə bwehe sə kwès sàmba. ");
INSERT INTO yam_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bwìŋ à ye co ncùhù kwè sə̀ wo ànə zʉ, fana Jisòs dʉk wo lo. ");
INSERT INTO yam_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bə ŋgàa fàak ye à ni yàwo ŋgwes, nə lo nzeŋgòŋ Dàmànutà. ");
INSERT INTO yam_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bʉ̀ʉ Faràsi mok à və̀ bohòJisòs ŋgòfi'dʉk bə nà'. Fana wo dʉk yi də, yi gʉ maŋgəŋgèŋ mòk nə̀ aco nà' ni tsok fa wo də yi tse' ŋàaŋ Nwì ŋkuŋ ya wo dzəm bohòyi. Bʉsə̀ wo à dzəm ŋgòmùmsə yi. ");
INSERT INTO yam_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","À bʉp Jisòs, fana yi som, nə dʉk də, <<Bʉ sə̀ niè' wèeŋ dzəmgə̀ yàwo də wo ye tsoŋ yumok bə lis ŋkuŋ nə dzəm yè'sə bʉ̀ʉ yà?>> Nə dʉk fe'lə də, <<Bə zìnə àm pwe', mʉ nə kà yumok ŋgònì fa bʉ̀ʉ yè'e gʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Fana yi me'rə wo fo', nə ni sənə ŋgwes ŋgòto lòŋgʉ ndzəp mamòk. ");
INSERT INTO yam_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bwe Jisòs à ye sə ŋgwesə̀ anə, nə tse' megu ntu' brɛd mò'fis bʉ̀ʉsə̀ wo ànə swì ŋgòjə tse' brɛd mok. ");
INSERT INTO yam_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yi dʉk fa wo dʉk də, <<Wèeŋ jəŋ ŋkərə̀ bə nsàap yis bʉ̀ʉ Faràsi nə ye nsàap yis sə̀ ŋkum Herò.>> ");
INSERT INTO yam_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wo sə cep kɛ' mʉtsətsə'rəə wo anə dʉk də yi dʉk vɛ'nə bʉ̀ʉsə̀ wo swì ŋgòjə və̀ brɛd. ");
INSERT INTO yam_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisòs riŋ yusə̀ wo sə cèp sə, nə dʉk fa yà'wèŋ də, <<Wèŋ sə sa' də wèŋ swì ŋgòjə tse' brɛd yè'sə bʉ̀ʉ yà? Wèŋ ka rɛɛŋ mali à? Ntʉm awèŋ cu malì ntògʉgʉŋ à? ");
INSERT INTO yam_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Wèŋ tse' lis, nə kà sə yə, tse' ntu', nə kà bum sə yuk à? Kaco wèŋ tsəmtse' yumok yeŋ à? ");
INSERT INTO yam_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mvə̀'nə̀ mʉ̀ ànə bə'rə fa bwìŋ ncùhù tàŋ ntuhu brɛd sə̀ tàŋ yà'a, bʉ̀ʉ yè'sə à zʉ mèsə, wèŋ te'e sə̀ yà' à bwehe kwès sʉ̀?>> Wo dʉk də, ànə ye kwès hum-ncòp-ba. ");
INSERT INTO yam_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yi fek fe'lə wo də, <<Mvə̀'nə̀ mʉ̀ a bə'rə fa bwìŋ ncùhù kwè ntuhu brɛd sàmba yà'a na, wèŋ te'e kwès sʉ̀ nɛ?>> Wo dʉk də, à ye kwès sàmba. ");
INSERT INTO yam_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Fana yi fek yà' dʉk də, <<Wèŋ ka sə̀' rɛɛŋ mali à?>> ");
INSERT INTO yam_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","À kə̀ dzèŋ mvwe' lak Bèsadà, wo jəŋ və ŋwə̀ nəmòk nə̀ yi kà yəgə̀, nə sə lɛŋ Jisòs də yi jwɛŋ ŋwə̀ ènə bə bo. ");
INSERT INTO yam_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisòs à kotse' nà' bə bo, nə jəŋ fis gɛsə lo nà' mvwe' mʉbuk lak nà'nə. À kə̀ dzèeŋ, yi te gesə fa nà' nte mʉ lisə̀ anə, nə naaŋ fa nà' bo, nə fek nà' də, <<Wù sə yə bum à?>> ");
INSERT INTO yam_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ŋwə̀ nə à dʉk də, <<Ŋ̀, mʉ̀ sə yə bùrə bwìŋ wo co tʉ, nə sə gihi kɛ'.>> ");
INSERT INTO yam_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yi naaŋ fe'lə bo mʉ lisə̀ nà' anə sə̀mok, fana ŋgà' nə kʉk swɛ'lə lis mok bə ŋàŋ. Yà' muhu, yi ye bum mok làaŋ. ");
INSERT INTO yam_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisòs dʉk yi də, <<Dù nda'à wù, nə kà fə ntòlak fa'nə mok ni lo fe'lə̀.>> ");
INSERT INTO yam_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisòs bə bwe ye wèŋ à yè'e lòmvwe' buhu lak mok ŋgʉ lak Sìsàriyà Filìpi. Fana à kə̀ dzèŋ mandzə̀ yi fek yà'wèŋ dʉk də, <<Bwìiŋ dʉkgə̀ də mʉ yè'sə ndà?>> ");
INSERT INTO yam_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mòk dʉk də, <<Bʉ̀ʉ mok dʉkgə̀ də wu Jon ŋgà bàptɛsə̀ bwìŋ, mok dʉkgə̀ də wu Àlajà, fana mok sə dʉk sə̀' də wu ŋgà tsòhòbum Nwì mòk nə̀ yi à ye fa' àlɛ.>> ");
INSERT INTO yam_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","<<Wèŋ yàwèŋ ɛ, wèeŋ dʉkgə̀ yàwèŋ də mʉ ndà?>> Pità dʉk də, <<Wu Ŋkum ŋgà gèm bwìŋ nə̀ wo sə kʉ̀k nə.>> ");
INSERT INTO yam_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jisòs à yuk vɛ'nə, yi tipsə wo də wo kà ŋwə̀ nəmòk tsə̀' fa. ");
INSERT INTO yam_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisòs à yè ŋga'a ŋgòyə'rə ŋgàa fàak ye, nə sə tsoho fa yà' dʉk də, <<Mʉ̀ʉ mo ŋwè, mʉ̀ tse' ŋgòye ŋgə' nə̀bʉp, bʉ̀ʉ sə̀ mantombì bə bʉ̀ ŋgàa fa satikà' nə ye ŋgàa yə'rə̀ lʉ̀k wèeŋ nə bɛŋ mʉ. Wo nə zə mʉ, fana anə ca nùumbu tɛ', mʉ̀ lokok mvwe' kpʉ sə̀mok.>> ");
INSERT INTO yam_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yi à cèp yu yè'sə kwarəŋgaŋ. Fana Pità ko lo gɛsə nà' fo', nə sə jwa nà'. ");
INSERT INTO yam_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jisòs bʉ̀ʉŋ kʉ̀k vèsə ŋgàa fàak ye, nə jwa Pità də, <<Coho gɛsə ŋgʉ ni'ì mʉ̀ wùu Satà. Yusə̀ wù sə cèp yà'sə, a tsətsərə̀ nə̀ bwìŋ tse' nà' wo, ka nə̀ Nwì yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yi to benə bʉ̀ʉ sə nə ye ŋgàa fàak ye wèŋ, nə tsok wo də, <<A ye-a ŋga ŋwə̀ nəmòk dzəm-a ŋgòyù mʉ, yi nə me'rə yusə̀ ni' ye sə dzəm maŋkwɛ̀ŋ, nə bək jəŋ ntə̀əŋ ye, nə yuŋ və mʉ. ");
INSERT INTO yam_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bʉsə̀ ŋwə̀ nə̀ yi gəhə tse'-a yòŋsə̀ ye yi, fana nà'a nə bisə wà. Fana ŋwə̀ nə̀ yi jə yòŋsə̀ yi co yusə̀ wà bʉ̀ʉ mʉ̀ nə ye ncèp àm, fana yi nə tse' yòŋsə̀ ye nə. ");
INSERT INTO yam_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Swe' nə̀ aco ŋwè tse' yà'sə yà ŋga yi tse'-a nzeŋgòŋ nə pwe', nə bisə yòŋsə̀ ye ŋgwàŋ ɛ? ");
INSERT INTO yam_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yusə̀ aco ŋwè kupsə yà' kʉrə bə yòŋsə̀ ye yà? Yumook bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ŋwə̀ nə̀ yi koksə-a marè'tu bohòmʉ̀ nə ye ncèp àm ŋga'a sənə nzeŋgòŋ nə̀ nà' rwiŋ bə ŋkʉ̀ì' nè'e fana ghà nə̀ mʉ̀ʉ mo ŋwè mʉ bwìŋ və̀ bə masinjàa sə̀ rərɛŋ, nə tse' ŋàaŋ sə̀ Tɛ̀' am fa mʉ fana, mʉ̀ koksə marè'tu bohòyi sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Fana Jisòs à tsə̀' fa wo dʉk də, <<Mʉ̀ sə tsə̀' weŋ yè'e zìnə də, bʉ̀ʉ mok tə fɛɛŋ sə̀ wo nə kà kpʉ tə̀tè wo ye gaŋ sə̀ Nwì ŋga yà' və̀ bə ŋàŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","À cà nùumbu ntùŋfu, fana Jisòs to jəŋ Pità bə Jem nə ye Jon, bə yà'wèŋ kok lo mʉmvwe' nda mok nə̀ sə̀sap. Fana wo ye ŋga nsəsə̀ə Jisòs kupsə bʉ̀sə nsàp mòk nə̀ zok. ");
INSERT INTO yam_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Cə̀ək sə̀ yi ni tse' mʉ ni'ì yi à bʉ̀ʉŋ fəfop tap tap. Yumok kà sə nze vɛ'nə fopgə̀. ");
INSERT INTO yam_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wo ye Àlajà bə Musì ŋga wo tesə və̀ mʉbu. Bə Jisòs wèŋ sə taaŋ ŋgàm. ");
INSERT INTO yam_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pità tiŋ wo cù, nə dʉk fa Jisòs dʉk də, <<Cicà, yà' bòvɛ'ɛ wùriŋ mvə̀'nə̀ vesùwèeŋ fɛŋ yè'sə. A ci ba'rə tes bwe duŋ fɛɛŋ nə tɛ', mò'fis nə̀ njò, mòk nə̀ Musì, mòk nə̀ Àlajà.>> ");
INSERT INTO yam_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yi ànə cep tsoŋ gù yè'sə də ncèp kà cù gha'gə̀, bwɛ̀rɛ wʉə ànə ko wo vɛ'ɛ, wo kà yusə̀ ŋgòcèep rì. ");
INSERT INTO yam_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mbàk à və̀ə nə kə̀ təhə lok wo, fana wo yuk ŋga ŋgì mòk cèp vèsə ndzənə mbàk nə dʉk də, <<Nè'e mo àm nə̀ mʉ̀ dzəm yi sə ntʉʉ̀ mʉ̀. Yusə̀ yi cèp pwe', wèeŋ yuk fa yi.>> ");
INSERT INTO yam_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wo à yuk ŋgì ènə vɛ'nə, wo kʉksə kɛ', nə kà ŋwə̀ nəmòk nə̀ zok yə, wo ye megu Jisòs yiìyi. ");
INSERT INTO yam_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mvə̀'nə̀ wo à sə tsooŋ mʉ ndahà, yi tipsə yà' də, yà'a nə kà ŋwə̀ nəmòk yusə̀ yà' yə tsə̀' fa, tè tse'ŋga yi mo ŋwè mʉ̀ lòkok mvwe' kpʉ ŋkuŋ. ");
INSERT INTO yam_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wo à ka ŋwə̀ nəmòk sə tsok fa anə, wo sə cèp ŋwʉ̀rə kɛ' gù woòwo, də yusə̀ yi cèp də ŋgòlòkok mvwe' kpʉ yè'sə da lɛ. ");
INSERT INTO yam_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wo fek Jisòs də, <<Njo nə̀ ŋgàa yə'rə̀ lʉ̀k wèŋ sə dʉk də Àlajàa nə və to tsoŋ yi ŋkuŋ Krɛst və ŋgòtɛsə ves ɛ bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yi dʉk fa yà' də, <<Àlajàa nə və ŋgòkə̀ gʉ̀hʉ tsə'rə fəsə bum pwe'.>> Fana yi fek bwi yà' də njo nə̀ ŋwàk Nwì sə dʉk də mo ŋwèe nə ye ŋgə' nə̀bʉp, wo bɛ̀ŋ yi sə̀' bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","<<Mʉ̀ sə tsə̀' weŋ də, Àlajà nə və̀ laŋ, fana wo ànə jəŋ yi, nə gʉ yi mvə̀'nə̀ wo dzəm sə̀' mvə̀'nə̀ yà' cu ndzənə ŋwàk Nwì.>> ");
INSERT INTO yam_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wo ànə lo, nə kə be'lə bə ŋgàa fàak mok sə lòoŋ, fana wo ye bʉ̀ʉ mok fo' sə̀' wùriŋ. Ŋgàa yə'rə̀ lʉ̀ʉk mok à ye fo', nə sə fi'dʉk bə ŋgàa fàak sə. ");
INSERT INTO yam_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bʉ̀ʉ sə à ye Jisòs ntɛ̀ŋ, fana wo mərə wùriŋ, nə carə lo kə̀ cèpsə nà'. ");
INSERT INTO yam_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisòs fek wo dʉk də, <<Wèŋ anə sə fi'dʉk fɛɛŋ də yà-ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ŋwə̀ nəmòk cep vesə mʉtsətsə'rə bʉ̀ʉ sə də, <<Cicà, mʉ̀ jə və̀ mo àm bohòwù bʉ̀ʉsə̀ yi tse' yòŋsə̀ ze' ndzə ni'ì yi, nə̀ nà'a gʉ̀gə̀ yi yi kà cù sə cèp. ");
INSERT INTO yam_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ghà nə̀ yòŋsə̀ ze' nə yèto ŋgòfa yi ŋgə', fana yi coho gbʉ̀ sə nze, sə sə dùk yi kə̀ cùhu, yi sə zʉ nzòŋ, fana ni' gʉrə yi njək njək. Mʉ̀ dʉk ŋgàa fàak yòdə wo bɛ' fis fa nà', fana wo kà nà' bɛ' fis to.>> ");
INSERT INTO yam_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisòs dʉk fa wo də, <<Ja'a na mvəsə̀ wèŋ mègù sə̀' co bʉ̀ʉ sə̀ wo ka dzədzəm tse' yè'e ɛ. Mʉ nə cum geŋ vesùwèŋ, nə sə ko ntʉm vɛ'nə tə̀tè kə dzeŋ sèŋ? Wèeŋ jəŋ və fa mʉ mo nə fɛn.>> ");
INSERT INTO yam_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Fana wo jə və̀ fa Jisòs mo nə. Ze' nə̀ ndzə ni'ì mo nə à yə Jisòs ntɛ̀ŋ, nà' gʉ yi gbʉ, nə gʉrə. Mo nə coho gbʉ sə nze, nə sə dzərə kɛ' cà sə nze anə, sə sə duk yi kə̀ cùhù. ");
INSERT INTO yam_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisòs fek tɛ̀'ɛ mo nə də nà' à yè ŋgògʉ̀ vɛ'nə sə nɛ? Tɛ̀' nə dʉk də, <<Yà' à yè yi ŋga yi cu ntòmʉmweŋke'. ");
INSERT INTO yam_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A kɛ̀' ŋkʉ̀ʉŋntɛ̀ŋ nə̀ nà'a də nà'a zə yi, nə sə mak gesə yi sə misə̀, nə ye sə ndzəpə̀ sə̀'. Ŋga wù tse'-a mandzə̀ nə, wù koksə manziŋ, nə tɛsə ves.>> ");
INSERT INTO yam_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisòs dʉk də, <<Wù fek mʉ də ŋga mʉ̀ tse'-a mandzə̀ bʉ̀ʉ? Bum pwe' tse' mandzə̀ yo bohòŋwə̀ nə̀ yi tse' dzədzəm.>> ");
INSERT INTO yam_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tɛ̀' ye nə cep fis ye sə̀' mvèsə̀ də, <<Mʉ̀ tse' dzədzəm. Tɛsə mʉ ya ŋga dzədzəm àm nə kuk.>> ");
INSERT INTO yam_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisòs à yə də bwìŋ sə və̀ ghaha ghaha, fana yi jwa yòŋsə̀ ze' nə də, <<Yòŋsə̀ ləm nə ye jì ntu', tesə ndzə ni'ì mo ènə, nə kà ndzə ni'ì yi mok ni yuk fe'lə̀. Mʉ̀ dʉk vɛ'nə mʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yòŋsə̀ nə à wa, nə gʉ mo nə kpʉ swirə nə̀bʉp, nə tesə lo. Mo nə à nòoŋ mègù mok co vèŋ ŋwè, nsàp nə̀ ndàaŋwè pwe' à dʉk də, nà' kpʉ laŋ. ");
INSERT INTO yam_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jisòs à kə̀ kotse' yi bo ŋgòlòkoksə nà', fana yi lòkok mʉtsə̀. ");
INSERT INTO yam_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mvə̀'nə̀ Jisòs à kə̀ ni cu mʉ nda'à, fana ŋgàa fàak ye və, nə sə fek yi də wo fis fʉk nà' yàwo bʉ̀ə̀ yè'sə bʉ̀ʉ yà lɛ? ");
INSERT INTO yam_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisòs dʉk fa wo də, <<Aco bɛ' fis megu nsàp nè'e pìriyà, bwɛ̀rɛ nsàp yumòk ka mok ye fe'lə.>> ");
INSERT INTO yam_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wo à mè'rə mʉmvwe' ànə, nə ca mandzə̀ nə̀ mvwe' nzeŋgòŋ Galìli. Jisòs à ka dzəm də bwìiŋ riŋ mvwe' sə̀ yi cu dzəm. ");
INSERT INTO yam_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bʉsə̀ yi à sə yə'rə ŋgàa fàak ye. Yi à sə yə'rə wo də, <<Wo nə jəŋ mʉ̀ʉ mo ŋwè, nə fa ndzə bohòbʉ̀ʉ sə̀ wo nə zə mʉ, fana nùumbu tɛ' càa, mʉ̀ lokok mvwe' kpʉ.>> ");
INSERT INTO yam_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bwe sə à ka bə yusə̀ yi à cèp yè'sə rɛŋ, nə sə koksə wʉə ŋgòfek rɛŋsə yi. ");
INSERT INTO yam_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jisòs wèŋ à kə̀ dzèŋ mvwe' lak Kàpanùm. Fana wo ni lo mʉ nda'à. Jisòs à cu mbwa, nə sə fek yà'wèŋ də, <<Wèŋ anə sə fenə və fa' mandzə̀ yà'a də yà?>> ");
INSERT INTO yam_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wo cum dədok, nə kà cèp fəsə̀, bʉ̀ʉsə̀ wo anə sə fenə və mandzə̀ anə də ŋwə̀ nə̀ ghaŋ ndà lɛ. ");
INSERT INTO yam_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Fana yi à cu tsoŋ nze, nə to benə bwe ye sə, nə tsok wo dʉk də, <<Ŋwə̀ nə̀ yi dzəm-a ŋgòye mantombì, fana yi tse' ŋgòjə lòni' ye maŋkwɛ̀ŋ, nə sə fak bohòbwìŋ pwe'.>> ");
INSERT INTO yam_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Fana yi ko lòkoksə tes mo nəmòk mʉtsətsə'rə wo, nə sə tsok fa wo ŋga yi le' kotse' mo nə duk də, ");
INSERT INTO yam_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","<<Ŋwə̀ nə̀ yi jə-a nsàp mo nə̀ jo nè'e nə dʉk fa nà' də, <və̀ bə̀boŋ> mʉnə liŋ am, fana ye də yi jə yà'sə mʉ̀. Ŋwə̀ nə̀ yi jə-a mʉ, nə dʉk <Və̀ bə̀boŋ>, fana ye də yi sə kà bohòmʉ̀ dʉk mègù, a bohòŋwə̀ nə̀ yi à tum mʉ nə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon à to Jisòs də, <<Cicà,>> nə tsok nà' dʉk də, <<Vès yə ŋwə̀ nəmòk ŋga yi bɛ' fis yòŋsə̀ ze' mʉnə liŋ yò. Fana vès dʉk yi də yi teŋsə, bʉ̀ʉsə̀ yi ka mòk mʉtsətsə'rə vès yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisòs dʉk ye də, <<Kà də wu gʉ co yi teŋsə dʉk, bʉ̀ʉsə̀ ŋwə̀ nə̀ yi sə gʉ̀-a fàak sə̀ bə ŋàaŋ sə̀ Nwì mʉnə liŋ am, fana ka co ghàr yi bʉʉŋ cep fe'lə yusə̀ bʉp bə liŋ am yeŋ. ");
INSERT INTO yam_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bʉsə̀ ŋwə̀ nə̀ yi sə kà-a ves bɛ̀ŋ, ye də yi vesiwèŋ. ");
INSERT INTO yam_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Zìnə nə də, ŋga ŋwə̀ nəmòk səp fa-a wu ndzəp bʉ̀ʉsə̀ də wu ŋwə̀ə Ŋkum ŋgà gèm bwìŋ, ye də yi nə kə tse' tsoŋ lə̀làk bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","<<Nə ye sə̀' də a ye-a ŋga ŋwə̀ mòk gʉ̀ bəbwe sə̀ wo dzəm bohòmʉ̀ yè'sə mòk də yi gʉ bʉp fana bòŋ ghak co wo jəŋ ŋgòk, nə swi' kə'ə fa ŋwə̀ ànə kə̀ mìhi, nə mak gesə lo yi sə mvwe' ndzəp nə̀ cəco. ");
INSERT INTO yam_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ye də a ye-a ŋga bo yo sə gʉ̀ wu ŋgògʉ̀ bʉp, fana bòŋ də wu gbɛ' tiŋ mak yà'. Bògha' də wu kə ni lak lùŋ bə bo ma mò'fis, nə noŋsə ŋgòkə̀ ni mvwe' ŋgə' nə̀ sənə mis sə̀ yà'a kà liìŋgə̀ bə bo ma ba fo'. ( ");
INSERT INTO yam_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mʉmvwe' ànə ndwiŋ sə̀ yà'a nə sə zʉ bwìŋ fo' kà kpʉgə̀. Fana mis sə kà sə liìŋ.) ");
INSERT INTO yam_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kèe a ye-a ŋga kùu yo sə gʉ̀ wu ŋgògʉ̀ bʉp, fana boŋ də wu gbɛ' tiŋ mak yà'. Bògha' də wu kə̀ ni mvwe' lak lùŋ kù ma mò'fis, nə noŋsə ŋgòkə̀ ni mvwe' ŋgə' nə̀ sə misə̀ nə bə kù ma ba fo'. ");
INSERT INTO yam_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Mʉmvwe' ànə ndwiŋ sə̀ yà'a nə sə zʉ bwìŋ fo' kà kpʉgə̀, fana mis nə kà sə̀' liìgə̀.) ");
INSERT INTO yam_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mok ye sə̀' də a ye-a ŋga lis yo sə gʉ̀ wu ŋgògʉ̀ bʉp, fana boŋ də wù so'rə fis mak ma nà'nə. Bògha' də wu kə ni mvwe' gaŋ Nwì bə lis ma mò'fis, nə noŋsə ŋgòtse' lis ba lòoŋ, nə kə ni bə zeŋ mvwe' ŋgə' nə̀ sə misə̀ nə. ");
INSERT INTO yam_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mʉmvwe' anə ndwiŋ sə̀ yà'a nə sə zʉ bwìŋ fo' kà kpʉgə̀, fana mis sə kà sə̀' liì. ");
INSERT INTO yam_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mis nə lʉmsə ndàaŋwè pwe' co ci'. ");
INSERT INTO yam_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ci' bə̀boŋ. Fana yà'a cwɛ̀'lə-a, aco yà' lʉ̀m fe'lə va? Wèeŋ lʉm co ci', nə cum bə fifi weŋ bwìŋ pwe'.>> ");
INSERT INTO yam_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisòs à mè'rə mʉmvwe' ànə, nə lo mvwe' nzeŋgòŋ Jùdiyà, nə ye ma ndzə nto ndzəp Jòridàŋ nə mamòk. Mvə̀'nə̀ yi ànə ye fo' fana bwìŋ və, nə kə maŋ fo' wùriŋ. Yi yèto ŋgòyə'rə wo mʉmvə̀'nə̀ yi gʉ̀gə̀ səsa. ");
INSERT INTO yam_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bʉ̀ʉ Faràsi mok à və̀ ŋgòkə̀ bʉə yi bə dʉk. Fana wo sə fek yi də, <<Lʉ̀k avès sə tsə̀' də, a bə̀boŋ bohòŋwè ŋgòmè'rə ŋgwe ye àlɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yi fek wo sə̀' də, <<Musì à tsə̀' weŋ də yà?>> ");
INSERT INTO yam_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wo à dʉk də, <<Musì ànə dʉk də, aco ŋwè com fa ŋwà nə ŋwàk nə̀ ŋgònìtsə̀' də yi mè'rə nà' laŋ, nə me'rə nà'.>> ");
INSERT INTO yam_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisòs dʉk fe'lə də, <<Musì à còm vɛ'nə bʉ̀ʉsə̀ ntʉm awèŋ gʉ nə̀bʉp, ");
INSERT INTO yam_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","bwɛ̀rɛ mvə̀'nə̀ Nwì à gʉ̀ to ŋwè, yi gʉ ŋwə̀mbam bə ŋwàŋwè. ");
INSERT INTO yam_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nè'e njo nə̀ ŋwèe nə me'rə tɛ̀' ye bə ma ye, nə kə be'lə bə ŋgwe ye, ");
INSERT INTO yam_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","fana wo sə̀ ba yè'sə nə ye mok ŋgùpni' nə̀ mò'fis. A yà'sə də wo nə kà ba mok ye, wo mok mò'fis. ");
INSERT INTO yam_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ye də yusə̀ Nwì à be'lə yà' mvwe' mò'fis fana ŋwə̀ nəmòk kà də yi gapsə yà' dʉk.>> ");
INSERT INTO yam_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","À kə̀ dzèŋ nda'à, ŋgàa fàak Jisòs sə fek mali yi bə ncèp nə. ");
INSERT INTO yam_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yi dʉk fa yà' dʉk də, <<Ŋwə̀ nə̀ yi mè'rə-a ŋgwe ye, nə jəŋ fe'lə mòk sə̀mok, ye də ŋwə̀ ànə ŋgà ko nto. ");
INSERT INTO yam_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yà' mègù sə̀' yəyərə̀ bohòŋwàŋwè, də a ye-a ŋga yi mè'rə-a ndu ye, nə kə jəŋ fe'lə mòk, ye də ŋwà ànə ko sə̀' nto.>> ");
INSERT INTO yam_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bʉ̀ʉ səmok à sə jə və̀ bweŋke' də Jisòs jwɛŋ yà'wèŋ, nə se yà'wèŋ. Ŋgàa fàak Jisòs wèŋ ànə ye vɛ'nə, wo jwa sa'rə bʉ̀ʉ sə də yà'a kà vɛ'nə gʉ̀. ");
INSERT INTO yam_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisòs à yə vɛ'nə, fana yi jok, nə dʉk fa bwe ye wèŋ sə də, <<Wèeŋ me'rə bəbweŋke' wèeŋ və bohòmʉ̀, nə kà wo mandzə̀ lok. Bʉsə̀ gaŋ ŋkum Nwì sə, tse' yà' nsàap sə̀ co wo yè'sə.>> ");
INSERT INTO yam_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yi dʉk fe'lə də, <<Mʉ̀ sə tsə̀' weŋ yè'e yusə̀ zìnə də, ŋwə̀ nə̀ yi kà-a gaŋ ŋkum Nwì co mʉmweŋke' fa, ye də yi nə kà fo' kə̀ ni yuk.>> ");
INSERT INTO yam_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yi à dʉk vɛ'nə fana yi jəŋ bwe sə, nə naaŋ fa yà' bo ye, nə se yà'. ");
INSERT INTO yam_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","À ye ŋga Jisòs sə dʉk də yi lo gì, ŋwə̀ nəmòk caŋ və̀, nə kə bʉhʉ kə̀ mantombìi yi, nə dʉk fa Jisòs nə də, <<Cicà nə̀ bə̀boŋ, yusə̀ aco mʉ̀ gʉ yà', ya mʉ nə kə tse' lùŋ nə̀ nà'a nə̀ kà mèe yà?>> ");
INSERT INTO yam_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisòs fek nà' də, <<Wù to mʉ də ŋwə̀ nə̀ bə̀boŋ bʉ̀ʉ yà? Ŋwə̀ nə̀ bə̀boŋ bʉ̀ə̀, mègù Nwì yiìyi. ");
INSERT INTO yam_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wù rì yòlʉ̀ʉk sə laŋ. <Kà ŋwè zə, kà sàhà ko, kà yə̀yə̀, kà gèem mvwès ko, kà yu ŋwè limzʉ, wəp ma yo bə tɛ̀' yo.> >> ");
INSERT INTO yam_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ŋwə̀ ènə dʉk fe'lə də, <<Cicà, mʉ̀ à gʉ̀ yè bum sə̀ wù taŋsə yè'sə ŋga mʉ̀ cu ntòmʉwà'ŋwè.>> ");
INSERT INTO yam_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisòs à kʉ̀' nà' jwaaŋ, nə dzəm nà', nə dʉk fa nà' dʉk də, <<Yumok cu malì mò'fis. Dù kə̀ sèŋ bum sə̀ wù tse', nə fa ŋgàa jìŋ wèŋ mbàam sə, ya wu nə tse' ghàk mʉbu, fana nə bɛ' mandzə̀ nə yuŋ və mʉ.>> ");
INSERT INTO yam_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ŋwə̀ ènə à yuk vɛ'nə, fana ŋgùp cù gbʉ̀ yi yə̀k, yi coho lo, bʉ̀ʉsə̀ yi à tse' bum nduk nə̀ nduk. ");
INSERT INTO yam_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisòs à bʉ̀ʉŋ kʉ̀k ŋgàa fàak ye wèŋ, nə dʉk də, <<A gʉgʉŋ bohòŋgà ghàk ŋgòkə̀ ni mvwe' gaŋ ŋkum Nwì.>> ");
INSERT INTO yam_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Və̀m à kok ŋgàa fàak Jisòs bə ncèp ènə kiŋ. Yi sə cep mali də, <<Bwe am, a gʉgʉŋ bohòŋwè ŋgòni mvwe' gaŋ ŋkum Nwì. ");
INSERT INTO yam_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Joho cà bohònàm nə̀ yi yam co nàmbà'rə̀ nà'a ŋgòcà torə tesə ndzənə wʉ patà', nə noŋsə bohòŋgà ghàk ŋgòni mvwe' gaŋ ŋkum Nwì sə.>> ");
INSERT INTO yam_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mvə̀'nə̀ wo à yuk vɛ'nə, və̀m kok wo, wo muu və̀m bʉ̀ə̀, nə sə fehe mok də, <<Ye də ŋwə̀ nə̀ yi tse' to lùuŋ yè'sə ndà?>> ");
INSERT INTO yam_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yi kʉ̀k nà' jwaaŋ, nə dʉk də, <<A ye-a bohòŋwè yà' ye gʉgʉŋ, ka bohòNwì vɛ'nə yeŋ, bʉ̀ʉsə̀ yumok ka Nwì-e gʉŋ ghak yuk.>> ");
INSERT INTO yam_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pità à cèp də, <<Ja'a na yòo, mʉmvə̀'nə̀ vès a mè'rə bum pwe', nə yù lònə wu.>> ");
INSERT INTO yam_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jisòs dʉk də, <<Mʉ̀ sə tsə̀' wu nə̀ zìnə nə, ŋwèe mè'rə-a ndap, bwe tɛ̀', njɛ̀'ɛgù, ma, tɛ̀', bwe, kè nzum ɛ̀, bʉ̀ʉ mʉ̀, nə ye bʉ̀ʉ ncèp Nwì, yi nə ye ŋgə' sə̀' fana mvə̀ək kʉ̀rə nùu yi kə̀ tse' fe'lə yà' vɛ'nə sə̀mok kɛ̀' ŋkʉ̀ mò'fis. Ŋga'a nè'e yi nə tse' ndap, bwe tɛ̀', njɛ̀'gù, ma, tɛ̀', bwe, bə nzum fak, fana mvə̀ək kʉrə nùu, yi tse' lùŋ nə̀ nà'a nə̀ kà mè nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mvə̀k ànə nə ye, bwìŋ ŋkʉ̀ʉŋ sə̀ wo ŋga'a mantombìi nə ye maŋkwɛ̀ŋ. Fana ŋkʉ̀ʉŋ sə̀ wo ŋga'a maŋkwɛ̀ɛŋ nə ye mantombì.>> ");
INSERT INTO yam_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Wo à sə gì sə mandzə̀ ŋgòlòmvwe' lak Jòrosalèm, fana Jisòs to mantombì. Bwe ye wèŋ saha ntʉm nə̀bʉp. Wʉə à sə ko bʉ̀ʉ sə̀ wo à sə yù və̀ yi maŋkwɛ̀ŋ sə sə̀'. Fana yi to benə bwe ye sə̀ hum-ncòp-ba sə mvwe' mò'fis, nə sə tsoho fe'lə wo yusə̀ yà'a nə gʉ yi. ");
INSERT INTO yam_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yi dʉk də, <<Wèeŋ yeè, mvə̀'nə̀ a sə lòmʉ Jòrosalèm yè'e, wo nə fa mʉ̀ʉ mo ŋwè ndzə bohòŋgàa fa satikà' sə̀ ghaŋ bə ŋgàa yə'rə̀ fa bwìŋ lʉ̀k wèŋ. Wo nə sak mʉ, nə dzəm tes də mʉ mègù ŋgà kpʉ. Wo nə fa mʉ ndzə bohòbʉ̀ lakmvum wèŋ. ");
INSERT INTO yam_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wo nə ywi'lə mʉ, nə te mʉ bə nte, ləp mʉ, nə zə mʉ. Fana nùmbu nə̀ tɛ' dzeeŋ, mʉ̀ lokok fe'lə mvwe' kpʉ sə̀mok.>> ");
INSERT INTO yam_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Bwe Zebèdi Jem bə Jon à kə̀ tsèŋ Jisòs, nə dʉk fa nà' də, <<Cicà, vès dzəm də wu gʉ fa ves yumok.>> ");
INSERT INTO yam_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Fana yi fek yà' də, <<Yusə̀ wèŋ dzəm də mʉ gʉ fa weŋ sə yà?>> ");
INSERT INTO yam_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","<<Vès dzəm də ghà nə̀ wu cu mʉnə kapràak yo, wù gʉ ves mòk cum wu mamàk, mòk maŋkwìp.>> ");
INSERT INTO yam_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisòs dʉk də, <<Wèŋ ka yusə̀ wèŋ sə fek yè'sə riŋ. Aco wèŋ ye to ŋgə' nə̀ mʉ nə ye nə à? Kènə aco wèŋ bàptɛsə to bə nsàp mandzə̀ nə̀ wo nə baptɛsə mʉ nə ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wo dʉk də, <<Ŋ̀, aco vès ye to.>> Jisòs dʉk fe'lə də, <<A zìnə wèeŋ nə ye, nə baptɛsə nsàp bàptɛ nə̀ mʉ nə bàptɛsə nə zìnə. ");
INSERT INTO yam_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yusə mègù də, mʉ̀ ka ŋàaŋ sə̀ ŋgòswè' bʉ̀ʉ sə̀ wo nə cum mʉ mamàk bə maŋkwìp mʉ̀ tse'. Mvwe' ncum yà'sə sə̀ bʉ̀ʉ sə̀ Nwì a cok nòŋsə wo yi.>> ");
INSERT INTO yam_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bwe ye mok sə̀ hum à yuk yu yè'sə, fana wo jok bohòJem bə Jon. ");
INSERT INTO yam_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","À ye vɛ'nə, Jisòs to benə wo mvwe' mò'fis, nə dʉk də, <<Wèŋ rì tse' yàwèŋ sə̀' də, bʉ̀ʉ sə̀ wo tse' dzòk sə nzeŋgòŋ fɛɛŋ gʉ̀gə̀ bwìŋ ŋkʉ̀ì'. Bʉ̀ʉ sə̀ ŋkwàha bʉ̀ awo sə niŋtsok fa wo ŋàŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yè'sə ka tse' ŋgòye bohòwèŋ vɛ'nə ye. Ŋwə̀ nə̀ yi dzəm-a ŋgòye ŋwə̀ nə̀ ŋkʉ̀ʉŋ mʉtsətsə'rə wèŋ, fana yi tse' ŋgòfàk co mweŋke' bohòmok sə lòoŋ fo'. ");
INSERT INTO yam_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nə ye sə̀' də ŋwə̀ nə̀ yi dzəm-a ŋgòye mantombì yi, yi tse' ŋgòye co ŋkwɛ̀ŋ bohòwèŋ pwe'. ");
INSERT INTO yam_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bʉsə̀ mʉ̀ʉ mo ŋwè bə tu am, mʉ̀ a ka də bwìŋ fak bohòmʉ̀ və. Mʉ̀ à və̀ ŋgòfà' fà'a, nə fa yòŋsə̀ àm ŋgòywiŋ fəsə jə yòŋsə̀ə bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","À kə̀ dzèŋ mvwe' lak Jèrikù ŋga wo sə mè'rə fo' ŋgòlòmantombì ŋga bwìŋ ŋkʉ̀ʉŋ sə bɛ' lòmalì yi fana ŋwə̀ nəmòk nə̀ wo togə̀ yi də Batimù mo Timayù cu ŋgʉ mandzə̀, nə sə lɛŋ bum ŋga yi kà bum yəgə̀. ");
INSERT INTO yam_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yi à yuk də sə və̀ Jisòs nə̀ mvwe' lak Nazàrɛ ntɛ̀ŋ, yi yèto ŋgòtorə də, <<Jisòs mo ŋkum Devìd, koksə manziŋ bohòmʉ̀-ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bʉ̀ʉ sə̀ wo à ye fo' sə wèŋ ghamsə yi də yi cum gəe'. Yi ghaha wesə ghaha, nə sə cep mok bə ŋàŋ də, <<Mo ŋkum Devìd, koksə manziŋ bohòmʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Fana Jisòs təəŋ, nə dʉk də, <<Wèeŋ to fa mʉ yi.>> Wo kə̀ dʉk fa yi də, <<Marɛŋ si yò, yi sə to wu də wu və.>> ");
INSERT INTO yam_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yi ku fweŋ mak cə̀k nə̀ yi anə təhə tse' mʉ ni'ì yi, nə kurə lòkok kə̀ ye Jisòs. ");
INSERT INTO yam_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisòs fek yi də, <<Yusə̀ wù dzəm də mʉ gʉ fa wu yè'sə yà?>> Yi də <<Cicà, muk fa mègù mʉ lis, ya mʉ ye bum sə̀mok.>> ");
INSERT INTO yam_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisòs dʉk fe'lə fa yi də, <<Mʉmvə̀'nə̀ wù dzəmtse' bohòmʉ̀ sə ntʉʉ̀ wù yà'a, gʉŋsə wu zeŋ. Dù yuyo.>> Lis à mùhu yi fo' ghà ànə, yi sə gi yuŋ lo Jisòs sə mandzə̀. ");
INSERT INTO yam_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wo ànə sə kʉəp lo Jòrosalèm anə fana wo wɛs mvwe' lak Befà bə Betanì. A fo' mvwe' nda Olìp. Fana Jisòs tumsə lo ŋgàa fàak ye ba. ");
INSERT INTO yam_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nə tsok wo də, <<Wèeŋ du mvwe' lak sə̀ ndzə yà'a. Mvə̀'nə̀ wèeŋ ni kok lòfo' ntɛ̀ŋ, wèeŋ nə ye ŋga wo tsòoŋ tes mʉmo mvomndè' mòk fo' nə̀ ŋwè ka mbwa kok yuk. Wèeŋ fiŋ jəŋ və nà'. ");
INSERT INTO yam_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ŋwə̀ nəmòok fek-a weŋ də wèŋ fì nà' bʉ̀ʉ yà, wèŋ tsok yi də, Tà sə dzəm nà', nə ye də, wo nə jəŋ fəsə və nà' mvə̀k momjo ŋga yi mèsə bə zeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wo à lòo, nə kə ye mʉmo mvomndè' nə ŋga wo tsòoŋ tes yi bə tàaŋ ncù. Fana wo yèto ŋgòfìrə nà'. À ye ŋgʉ mandzə̀. ");
INSERT INTO yam_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bʉ̀ʉ səmok sə̀ wo à ye fo' fek wo də yà' sə fìrə mvomndè' nə bʉ̀ʉ yà lɛ? ");
INSERT INTO yam_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wo à cèp mègù yusə̀ Jisòs à dʉk də wo cep sə, bʉ̀ʉ sə me'rə wo lo. ");
INSERT INTO yam_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wo à jə və̀ fa Jisòs mvomndè' nə, nə fweŋ saŋ cə̀ək awo mok mʉ ŋkwɛ̀ɛŋ mvomndè' nə. Yi kok cum mbwa. ");
INSERT INTO yam_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bwìŋ à fweŋ nòŋsə lòcə̀k sə mandzə̀ sə̀'. Bʉ̀ʉ səmok sə kə ci' və mvùu bum, nə sə noŋsə lo sə mandzə̀ anə ŋgòkùksə yi bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bʉ̀ʉ sə̀ wo à ye mantombì bə sə̀ maŋkwɛ̀ŋ lòoŋ ye ŋgòfa gùrə sə dʉk də, <<Hòsanà, Nwìi se yi nə̀ yi və̀ mʉnə liŋ Tà Nwì. ");
INSERT INTO yam_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nwìi se yi nə̀ yi sə və̀ ŋgòkok gaŋ tɛ̀' avès Devìd.>> ");
INSERT INTO yam_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisòs à və̀ Jòrosalèm, nə lo kə ni mʉ nda'à Nwì. Yi kʉksə ja'a bum sə̀ mbwa pwe'. À ye ŋga nùm lòlaŋ, fana bə ŋgàa fàak ye sə̀ hum-ncòp-ba à tesə, nə foho lo yu awo mvwe' lak Betanì. ");
INSERT INTO yam_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tsok à rɛŋ ŋga wo sə bwìŋ foho lòJòrosalèm anə, fana ye mok ŋga njè sə ya Jisòs. ");
INSERT INTO yam_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mvə̀'nə̀ wo à sə və̀ mandzə̀ fana yi ye gesə lo tʉ nəmòk nə̀ wo togə̀ nà' də fik, ŋga nà' təəŋ vesə sə̀sap, nə sə fom bòŋsə nə̀bʉp. Yi geŋ fo' də kè yi nə kə̀ ye ŋga nà' zəm-a àlɛ. Yi a kə̀ dzèŋ fo', yi tsèŋ mègù mvù, bʉ̀ʉsə̀ à ka mvə̀k nə̀ tʉ ànə zəmgə̀ yeŋ. ");
INSERT INTO yam_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yi təəŋ fo', nə dʉk fa tʉ nə də, <<Ŋwə̀ nəmòk nə kà ntò'o yo mok zʉ yuk.>> Ncèp nè'nə cʉəm ni fə ntu'ù ŋgàa fàak ye wèŋ sə. ");
INSERT INTO yam_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wo à kə̀ dzèŋ Jòrosalèm, fana Jisòs ca lo mʉmvwe' ntòmbi ndap Nwì nə̀ ghaŋ nə, nə sə bɛ' fis bʉ̀ʉ sə̀ wo à sə sèeŋ nə sə ywiiŋ bum mbwa pwe'. Yi bwi' mà'rə teberə̀ə bʉ̀ ŋgàa kupsə̀ mbàm wèŋ, nə ye dzòho bʉ̀ʉ sə̀ wo à sə sèŋ kəkəbʉ̀ŋ. Kəkəbʉ̀ʉŋ yà'sə a sə̀ wo à sə fa satikà' bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yi kà mandzə̀ də ŋwə̀ nəmòok bək ca yumok mʉ ndap Nwì nə̀ ghaŋ nə fa lok fʉ̀k. ");
INSERT INTO yam_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yi yèto ŋga'a ŋgòyə'rə bʉ̀ʉ sə də, <<Wo à còm nòŋsə ndzənə ŋwàk Nwì sə kum ndap Nwì nə̀ ghaŋ ènə də, <Liŋ ndap àam də, ndap pìriyà bohòlak pwe'fo'.> Fana wèŋ jə bʉsə nà' ndap ŋgàa yə̀ wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mvə̀'nə̀ ŋgàa fa satikà' bə ŋgàa yə'rə̀ lʉ̀k wèŋ à yuk vɛ'nə, fana wo sə lap mandzə̀ də wo zə yi. Wʉə à sə ko wo fana wo də wo zə nà' vɛ'nə, bʉ̀ʉsə̀ bwìŋ maŋgəŋgèŋ à sə kwa bə nsàp ncèp nə̀ yi à sə cèep nə. ");
INSERT INTO yam_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nùm à co, yi bə bwe fàak ye wèŋ mè'rə mvwe' lak yà'sə, nə lo. ");
INSERT INTO yam_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tsok à rɛŋ nə̀ zəzòŋ ŋga wo sə gì cà sə mandzə̀, wo ye fe'lə tʉ fik nə sə̀mok ŋga nà' kpʉ wes bə ŋgàŋ pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pità tsərə fəsə yusə̀ yà' a ye ŋkwìs sə, nə dʉk fa Jisòs də, <<Cicà, kʉk ja'a na tʉ nə̀ wù a yàk nà' ŋkwìs nə mvəsə̀ nà' kpʉ è.>> ");
INSERT INTO yam_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisòs dʉk bwe ye də, <<A ye-a ŋga wù tse' dzədzəm bə ŋàaŋ Nwì nə̀ zìnə, ");
INSERT INTO yam_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","fana aco wù dʉk bohònda nè'e də, nà'a coho kə gbʉ lòsə ndzəpə̀. Ŋga wù ka məmərə̀ sə ntʉʉ̀ wù tse', nə tse' dzədzəm də yusə̀ wù cèp yè'sə nə fak, yà' fak. ");
INSERT INTO yam_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yà'a yusə̀ ŋga wù sə lɛŋ-a pìriyà, fana wù dzəm tse' də wù tse' yà' laŋ, yusə̀ wù fek pwe' wu nə tse' yà'. ");
INSERT INTO yam_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ye sə̀' də ŋga wù cu-a ŋgòlɛŋ pìriyà, wù swìfa ndàaŋwè pwe' yusə̀ bʉp sə̀ yi a gʉ̀ bohòwù, ya tɛ̀' yo nə̀ mʉbu nə swifa wu bʉp yo sə̀'. ( ");
INSERT INTO yam_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ye sə̀' də wù kà-a bʉ̀ʉ mok swìfa, ye də tɛ̀' yo nə̀ yi cu mʉbu nə kà wu bʉp yo sə̀' swìfa.)>> ");
INSERT INTO yam_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wo à bwì və̀ fe'lə Jòrosalèm, fana mvəsə̀ Jisòs à sə gì cà mʉmvwe' ntòmbi ndap Nwì nə̀ ghaŋ nə, ŋgàa fa satikà' sə̀ ghaŋ bə ŋgàa yə'rə̀ lʉ̀k nə ye bʉ̀ʉ sə̀ kə̀ mantombì wèŋ kə tseŋ yi, ");
INSERT INTO yam_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nə fek yi də, <<Wù sə gʉ̀ bum yè'sə bə ŋàaŋ sə̀ fò? Kènə fa wu ŋàŋ ndà də wu gʉ yà' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisòs dʉk fa fəsə yà'wèŋ də, <<Mʉ nə fek weŋ yu səmok yàm sə̀'. A ye ŋga wèŋ tsə̀' fa-a mʉ yusə̀ mʉ̀ fek sə, mʉ̀ tsok weŋ ŋàaŋ sə̀ mʉ̀ tse' ŋgòkə̀ gʉ̀ bum yè'sə bə zeŋ sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wèeŋ tsok fa a mʉ mvwe' sə̀ Jon ànə jəŋ ŋàaŋ sə̀ ŋgòbàptɛsə bwìŋ. Yi à jə bohòNwì kè bohòbwìŋ ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wo à yèto ŋgòcèp bə zeŋ mʉtsətsə'rə wo də, <<A tsok fa yi yè'sə da? Bʉsə̀ a dʉk-a də ŋàaŋ sə à və̀ bohòNwì, fana yi nə fek fe'lə ves dʉk də, anə geŋ vesùwèŋ kà yusə̀ Jon à sə cèp dzəm bʉ̀ʉ yà lɛ. ");
INSERT INTO yam_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A dʉk-a sə̀' də yà' à və̀ bohòbwìŋ, fana wo nə dʉk da?>> Wo à sə wəp bʉ̀ʉ sə̀ fo' sə bʉ̀ʉsə̀ bwìŋ pwe' à dzəm zìnə də Jòon ŋgà tsòhòbum Nwì. ");
INSERT INTO yam_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Fana wo dʉk fa Jisòs mok də wo ka riŋ. Jisòs dʉk bwìŋ fa wo ye sə̀' də, <<Ye də mʉ nə kà weŋ nsàp ŋàŋ nə̀ mʉ̀ tse' ŋgògʉ̀ bum yè'sə bə zeŋ nə sə̀' tsə̀'.>> ");
INSERT INTO yam_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisòs à tsə̀' fa ŋgàa fàak ye ncèp mòk bə gbʉ' də, <<Ŋwə̀ nəmòk à fàk nzum ŋgwì tʉ nəmòk nə̀ wo togə̀ nà' də grep. Nə gʉm yà' bə ŋka', nə tuŋ tsə'rə mvwe' sə̀ wo kwì nto'o grep sə, wo kə ŋam fis rùk fo', nə ci tes yumok fo' co wu kok cum mbwa, nə sə tək nzum sə. Yi jəŋ nzum sə, nə tes fa bʉ̀ʉ səmok, nə ye'e lo gì mvwe' səmok. ");
INSERT INTO yam_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mvə̀k nə̀ ŋgòkwì grep à kʉ̀rə, fana yi tum gesə ŋgà fàk ye mòk də nà'a geŋ kə jəŋ və ma nje. ");
INSERT INTO yam_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bʉ̀ʉ sə̀ wo à sə fàk nzum sə ko ŋwə̀ nə̀ wo tum yi nə, nə ləp nà', nə tum fəsə nà' botu. ");
INSERT INTO yam_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ŋgà nzum nə tum gesə fe'lə ŋgà fàk ye mòk nə̀ kɛ̀' ba. Wo ko nà', nə ləp to nà' tu, nə yak yi wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yi tumsə fe'lə mòk sə̀mok. Wo ko zə nà'nə. Wo à gʉ̀ vɛ'nə bohòŋgàa fàak ye mok sə̀ yi à tum sə̀' ŋkʉ̀ʉŋntɛ̀ŋ. Wo à lə̀p mok, nə zə mok. ");
INSERT INTO yam_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","À kə̀ bwehe cu mègù mok mo ntʉm ye nə̀ yi à dzə nà' yi. Yi à tum gèsə mo ye nə sə̀', nə sə tsəm ye də wo nə wəp tsoŋ li nà'. ");
INSERT INTO yam_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wo à yə mo ye nə, wo dʉk fa ŋge' awo mok də, <Nè'e ŋga'a mo ye nə̀ ndzə və̀ə yi. Wèeŋ və a zə yi, ya bum yee nə ye mok sə̀ yàvès.> ");
INSERT INTO yam_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","À ye vɛ'nə, fana wo zə yi, nə bək fis vèŋ ye nə mʉ nzuù anə, nə kə mak.>> ");
INSERT INTO yam_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisòs fek də, <<Aco ŋgà nzum nə gʉ yè'sə ŋga'a va? Yi tse' ŋgòkə̀ zə bʉ̀ʉ yà'sə, nə fa nzum sə bohòbʉ̀ʉ mok sə̀ zok. ");
INSERT INTO yam_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wèŋ à ka yusə̀ wo à còm ndzənə ŋwàk Nwì taŋ yuk à? Wo à còm nja də, <Lìs nə̀ ŋgàa ci ndap wèŋ à dzèeŋ nòŋsə nà' də nà'a bʉp nə kə̀ tse' gha' fàk mok sə̀' zeŋ. ");
INSERT INTO yam_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","À gʉ̀ yè'sə Tà Nwì, fana yà' ye maŋgəŋgèŋ mʉ lisə̀ vesùwèŋ nə̀bʉp.> >> ");
INSERT INTO yam_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bʉ̀ʉ Jus sə̀ mantombì à rì də Jisòs màk gbʉ' nè'e bʉ̀ʉ wo, nə lap mandzə̀ də wo ko yi. Fana wo wəp bʉ̀ʉ sə̀ wo à ye fo' maŋgəŋgèŋ sə, fana wo me'rə yi yi lo. ");
INSERT INTO yam_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mvə̀k nəmòk à ye, wo tum vesə bʉ̀ʉ Faràsi bə bʉ̀ʉ ŋkum Heròmok də wo kə̀ tam Jisòs bə dʉk. ");
INSERT INTO yam_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wo kə dʉk fa Jisòs dʉk də, <<Cicà, vès rì də wu cèpgə̀ zìnə, nə kà bwìŋ sə wəp. Wu yə'rəgə̀ yònə̀ zìnə nə̀ Nwì, nə kà də wu wəp də nè'e ŋwə̀ nə̀ ŋkʉ̀ʉŋ dʉk. Vès dzəm də wu tsok a ves, lʉ̀ʉk vesùwèŋ sə tsə̀' də, a bə̀boŋ ŋgòlàk fa ŋkum Kaisà nə̀ mvwe' lak Rumà mbàam tas, kè ka' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jisòs riŋ də yà'wèŋ sə dʉk də wo yu'rə yi cù, fana yi fek yà'wèŋ dʉk də, <<Wèŋ sə də wèeŋ mumsə mʉ bʉ̀ʉ yà? Jəŋ və fa mʉ mbàm mòk, mʉ kʉk bʉrə nà'.>> ");
INSERT INTO yam_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wo jəŋ və fa yi mbàm mòk. Yi kotse' nà', nə fek wo də, <<Wo còm naaŋ mʉnə mbàm nə yè'e liŋ ndà, nə ye mbwa yè'e sə̀' si ndà?>> Wo dʉk də, a sə̀ ŋkum Kaisà. ");
INSERT INTO yam_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Fana Jisòs dʉk də, <<Ŋ̀hŋ̀. Lak fa Kaisà yusə̀ yà'a sə̀ ye, nə lak fa Nwì yusə̀ yà'a sə̀ Nwì.>> Wo ànə yuk vɛ'nə, wo mərə wùriŋ. ");
INSERT INTO yam_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bʉ̀ʉ Sadusì mok wèŋ və bohòJisòs. Wo bòp bʉ̀ nə̀ wo dʉkgə̀ yàwo də kaco ŋwè lokok mvwe' kpʉ yeŋ nà'a. Wo à sə fek Jisòs nə bum mok də, ");
INSERT INTO yam_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","<<Cicà, Musì à còm nə̀m fa ves lʉ̀k mòk də, a ye-a ŋga tə̀tàa ŋwə̀ nəmòk kpʉ me'rə-a ŋgwe ye ŋga bə nà' ka mwe tse', moma yee nə jəŋ tsooŋ ŋwà nə, ya bə nà'a dzə fa tə̀tà ye nə̀ yi a kpʉ nə bwe. ");
INSERT INTO yam_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yumook yè' də bwema mok wèŋ à ye tu awo bwembam sàmba. Fana nə̀ mantombì nə jəŋ ŋwàŋwè, nə kpʉ me'rə nà' ŋga bə nà' ka mwe tse'. ");
INSERT INTO yam_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nə̀ mʉ ŋkwɛ̀ɛŋ yi jəŋ ŋwà nə, nə kpʉ me'rə ŋwà nə jì mwe sə̀'. Moma nə̀ tɛ' ye sə̀' vɛ'nə, ");
INSERT INTO yam_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","nə ye bə mok sə lòoŋ fo'. Bwema sə̀ sàmba pwe' jəŋ ŋwà nə, nə kpʉ me'rə nà' jì mweŋ, wo pwe'. Ànə geŋ ŋwà nə kpʉ ye sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yusə̀ vès dzəm ŋgòrìi sə də, nùmbu nə̀ ŋgòlòkok mvwe' kpʉ dzèŋ nùu, ŋwà nə nə ye ŋgwe ndàlɛ? Bʉsə̀ wo à jə yi wo sàmba pwe'fo'.>> ");
INSERT INTO yam_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisòs dʉk fa wo də, <<Nà'a njo nə̀ wèeŋ jòŋ sə. Wèŋ ka yusə̀ yà' cu ndzənə Ŋwàk Nwì riŋ, nə kà ŋàaŋ Nwì sə̀' rì. ");
INSERT INTO yam_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bʉsə̀ mvə̀'nə̀ bʉ̀ʉ kpʉkpʉʉ nə lokok mvwe' kpʉ, wo nə ye co masinjàa Nwì mʉbu, ŋwə̀mbam bə ŋwàŋwèe nə kà gù mok cu fe'lə̀. ");
INSERT INTO yam_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bə nzak nə̀ ŋgòlòkok mvwe' kpʉ, wèŋ à ka ndzənə ŋwàk Musì sə̀' taŋ à? Mvə̀'nə̀ Nwì à cèp bohòyi ŋga tʉ à sə sə də, <Mʉ̀ʉ Nwì Abràham nə ye Nwì Azìk, nə ye Nwì Jàkop>. Nwì à cèp vɛ'nə ŋga wo à kpʉ lòlaŋ. ");
INSERT INTO yam_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yà'a sə nì tsə̀' də bʉ̀ʉ yè'sə cu fe'lə ŋwəm, njo nə̀ yi Nwì bʉ̀ʉ sə̀ wo cu ŋwəm, yi ka Nwì bʉ̀ kpʉkpʉ yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ŋwə̀ ŋgà yə'rə̀ lʉ̀k mòk à ye fo', nə sə yuk mvəsə̀ wo sə cèep. Yi ye də Jisòs bwìŋ fa bʉ̀ʉ Sadùsì sə ncèp nə bə̀boŋ, fana yi fek nà' gbʉ' nje sə̀' də, <<Lʉ̀k nə̀ nà' yam càsə mok pwe'fo' nə̀ fò?>> ");
INSERT INTO yam_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisòs dʉk də, <<Nə̀ ghaŋ nè'e, <Wèŋ bʉ̀ʉ Izùrɛ, yu'rə. Tà Nwì àvès nə mègù Nwì yi nə̀ mò'fis. ");
INSERT INTO yam_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wù tse' ŋgòdzəm Tà Nwì yòbə ntʉm yòpwe'fo'. Dzəm yi bə yòŋsə̀ yòpwe'fo', nə dzəm yi bə ŋkərə̀ yòsə̀' pwe'fo', nə ye bə ŋàaŋ yò.> ");
INSERT INTO yam_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lʉ̀k nə̀ nà' naaŋ yù lònà'nə nè'e də, <Wù tse' ŋgòdzəm moma yo co mvə̀'nə̀ wù dzəm ni' yò.> Lʉ̀k mòk ka sə̀ ba yè'e mok ghak fe'lə.>> ");
INSERT INTO yam_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ŋgà yə'rə̀ lʉ̀k nə dʉk fa Jisòs dʉk də, <<A bə̀boŋ, cicà, a zìnə mvəsə̀ wù dʉk də, Nwì mègù Nwì yi nə̀ mò'fis, mòk ka ye fe'lə, mègù yi. ");
INSERT INTO yam_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nə ye də, a bə̀boŋ bohòŋwè ŋgòdzəm tsə Nwì bə ntʉm ye pwe', nə kuksə yi bə ŋkərə̀ ye pwe', nə ye bə ŋàaŋ ye pwe', nə dzəm moma ye mvəsə̀ yi dzəm ni' ye. Lʉ̀ʉk sə̀ ba yè'sə yam gha' cà zeŋ, nə nəm bum pwe' sə̀ ŋgòtɛ̀ŋ fa Nwì co satikà'.>> ");
INSERT INTO yam_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mvəsə̀ Jisòs à ye də nà' cèp ncèp ŋkərə̀, fana yi dʉk fa nà' dʉk də, <<Ka sə̀sap bohòwù də ya Nwìi ye ŋkum yòye.>> Yè'sə à mèe, ŋwè kà co yi fek fe'lə yi yumok mok ghʉ̀sə̀ ja'a lo' fʉ̀'. ");
INSERT INTO yam_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mvəsə̀ Jisòs à sə yə'rə mʉ ndap Nwì nə̀ ghaŋ nə, fana yi cep də, <<Ŋgàa yə'rə̀ lʉ̀k wèŋ dʉk də, ŋwə̀ nə̀ wo to liŋ ye də ŋkum ŋgà gèm bwìŋ nə, nə ye megu ŋgwì ŋwə̀ nə̀ yi tesə mvwe' ŋgwì bʉ̀ ŋkum Devìd. ");
INSERT INTO yam_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aco yà' ye vɛ'nə va, bʉ̀ʉsə̀ Devìd à cèp bə liŋ ŋwə̀ ènə mvə̀'nə̀ Yòŋsə̀ nə̀ Rərɛŋ à gʉ̀ yi də, <Tà Nwì à dʉk fa Tà àm də, <<Cum fɛɛŋ bo ma mà'a mʉ̀, tə̀tè mʉ nə gʉ bʉ̀ʉ sə̀ wo bɛ̀ŋgə̀ wu, wo ye sə mvə̀'kùu wù.>> > ");
INSERT INTO yam_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devìd nə to nà' də Tà, ye də aco yi ye bwi bohòDevìd anə mwe yè'sə valɛ?>> Bʉ̀ʉ sə̀ wo à ye fo' maŋgəŋgèŋ sə à yuk yusə̀ Jisòs à cèp sə bə kwəkwa. ");
INSERT INTO yam_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mvə̀'nə̀ yi à sə yə'rə yà'wèŋ, yi dʉk də, <<Jəŋ ŋkərə̀ bə ŋgàa yə'rə̀ lʉ̀k sə̀ wo dzəmgə̀ ŋgògì dzòoŋ bə cə̀ək sə̀ sə̀sap ya bwìiŋ cepsə wo mʉ ntɛɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Wo dzəm dzòok bʉ̀ʉ sə̀ ghaŋ mʉmvwe' ndap pìriyà, nə kə cum megu mvwe' sə̀ ya bwìiŋ wəp wo co bʉ̀ʉ sə̀ ghaŋ mvwe' dinà. ");
INSERT INTO yam_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wo lim zʉgə̀ bàa yepmfə wèŋ, nə sə gʉ bʉpsə ndap awo, nə sə gʉ basə pìriyàa sə̀ sə̀sap ŋgwàŋ. Ŋgə' nə̀ njàwo nə kə yam gha' pwe'fo' yi njo bum yè'sə.>> ");
INSERT INTO yam_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisòs à lò, nə kə cum, nə sə kʉk ja'a mʉmvə̀'nə̀ wo sə fa fəfa mʉ nda'à Nwì. Ŋgàa ghàk wèŋ à sə kə̀ gèsə mbàm sənə ŋkùp nə̀ wo à tes nə ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Fana ŋwà ŋgwemfə nəmòk və, nə kə mak gesə ye ca mànini ba. Wu benə-a yà' ba lòoŋ, yà' ye co penə nə̀ mò'fis. ");
INSERT INTO yam_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Wo à mèsə, Jisòs to benə bwe ye mvwe' mò'fis, nə tsok wo dʉk də, <<Mʉ̀ sə tsə̀' fa weŋ nə̀ zìnə də, ŋwà ŋgwemfə nè'e gèsə mbàm sənə ŋkùp nə, nə ghak bʉ̀ʉ mok sə̀ wo fa pwe'. ");
INSERT INTO yam_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bʉsə̀ bʉ̀ʉ mok yà'a fa mbàam awo, nə tse' malì ghàak mok ŋkʉ̀ʉŋntɛ̀ŋ, nə ye də ŋwà ènə cu bə jìŋ, nə fa wes mʉmbàm zʉ ye pwe'.>> ");
INSERT INTO yam_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisòs bə ŋgàa fàak ye wèŋ à sə tesə tsə mʉ ndap Nwì nə̀ ghaŋ nə vɛ'ɛ ntɛ̀ŋ, fana, ŋgà fàk ye mòk bʉʉŋ kʉk ndap nə, nə dʉk də, <<Yebe mʉ-e, cicà, kʉk ja'a yòo ma nsàap lìis mok ndzənə mbàandap Nwì nə̀ ghaŋ nə mvə̀'nə̀ yà' bòo-ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisòs dʉk fa nà' də, <<Wù yə ndap sə̀ ghaŋ yè'e à? Lìs nə̀ mò'fis nə kà mʉnə mok fa'nə naàŋ mam. Wo nə kʉəmsə wes yà' pwe'.>> ");
INSERT INTO yam_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mvə̀k à cà jo fana Jisòs lo kə cum mʉnə nda nə̀ wo togə̀ nà' də nda Olìp, nə sə kʉk gesə lo ndap Nwì nə̀ ghaŋ nə ndzə Jòrosalèm ma nja vɛ'ɛ. Fana Pità, Jem, Jon bə Andrù wèŋ à və̀ woòwo, nə kə tseŋ yi fo'. ");
INSERT INTO yam_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Wo dʉk fa yi də, nà'a tsok fa wo ghà nə̀ bum yè'sə nə ye nə. <<Nə tsok fa-a ves yusə̀ yà'a nə niŋ tsok də mvə̀k nə̀ bum yè'sə nə ye sə kʉ̀rə laŋ sə.>> ");
INSERT INTO yam_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisòs dʉk wo də, <<Wèeŋ jəŋ ŋkərə̀ ya ŋwə̀ nəmòok kà weŋ bòrə̀. ");
INSERT INTO yam_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bwìiŋ nə və ŋkʉ̀ʉŋ sə̀ wo nə sə ci' mvwès də, wo ŋkum ŋgà gèm bwìŋ nə̀ bwìŋ sə kʉ̀k də yi nə və nə. Wo nə borə bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ŋga wèŋ yuk-a dzè' mvwe' jəjo, nə yuk dzè' mvwe' sə̀sap, wèŋ kà wəp, bʉ̀ʉsə̀ yè'sə nə ye tsoŋ vɛ'nə. Yà'a ye vɛ'nə, kà yà'sə də nze nə mè yà'sə laŋ sə̀' ntòye. ");
INSERT INTO yam_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ŋkuŋ nzeŋgòŋ nə sə me, bòp lak nə lʉ bə bòp lak mok. Ŋkum mòk lʉ bə ŋkum mòk sə̀'. Nze nə nə sə tsoho kɛ'ca fa' bə fa'. Njèe nə ko kɛ'ca sə̀' nə̀bʉp. Yè'sə pwe'fo' mègù ntòco ŋwàŋwèe ghà to ko'gə̀ mwe ntòghàa yè'e. ");
INSERT INTO yam_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","<<Wèŋ tse' ŋgòjə ŋkərə̀ sə̀' bʉ̀ʉsə̀ mvə̀k ànə ye fana wo nə ko lo weŋ mʉ kaŋsurù, nə ləp weŋ mvwe' ndap pìriyà wèŋ. Fana wèeŋ nə kə təəŋ kù mantombìi ŋkwàha bʉ̀ʉ gomè nə ye ŋkum wèŋ bʉ̀ʉ mʉ̀. Anə ye vɛ'nə ya ŋga wèeŋ tse' mandzə̀ nə̀ ŋgòtsə̀' fa wo ncèp nə̀ njàm nə. ");
INSERT INTO yam_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lak sə̀ sə nzeŋgòŋ anə lòoŋ nə yuk to tsooŋ ntòntirə̀ nə̀ bə̀boŋ nə ŋkuŋ nze nə me. ");
INSERT INTO yam_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","A ye ŋga wo ko lòwèŋ mvwe' nzak, fana wèŋ kà də wèeŋ jik də mʉ nə kə cep yè'sə yà dʉk. Mvə̀k nə kʉ̀rə, wù cèp yusə̀ yà' və̀ kə̀ cùhù wù ghà ànə. Bʉsə̀ yusə̀ wu nə cep sə ka yòyeŋ. Yà'a nə və bohòYòŋsə̀ nə̀ Rərɛŋ nə. ");
INSERT INTO yam_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bwìiŋ nə fa bwema awo də wo zə yà' mvə̀k ànə sə̀'. Tɛ̀' awo nə gʉ bwe awo sə̀' vɛ'nə. Bwe nə sə lap mandzə̀ ŋgòzə tɛ̀' awo sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bwìŋ pwe'fo' nə bɛŋ weŋ njo liŋ àm. Megu də ŋwə̀ nə̀ yi təəŋ-a gʉgʉŋ tə̀tè, nə kə ləsə, fana yi nə tse' lùŋ. ");
INSERT INTO yam_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","<<Fana wèeŋ nə ye bʉp nə̀ nà'a bə jòŋ, ŋga nà' ni lòmvwe' sə̀ ànə ye co nà' kà fo' gə̀. (Ŋwə̀ nə̀ yi sə ta, yi rɛɛŋ bə zeŋ.) Fana bʉ̀ʉ sə̀ wo cu mvwe' nzeŋgòŋ Jùdiyà wèŋ caŋ kok lo mʉ ndahà. ");
INSERT INTO yam_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ŋwə̀ nə̀ yi sə cu yòŋsə mʉ ndùndap, kà mvə̀k ŋgòni mʉ nda'à yi ŋgòte' jə yumok mbwa ŋkuŋ nə caŋ tse'. ");
INSERT INTO yam_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ŋwə̀ nə̀ yi mʉnə nzum fàak nə kà maŋkwɛ̀ŋ də yi kə jə cə̀k fohòlò. ");
INSERT INTO yam_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ho'm, megu də anə ye ŋgə' wùriŋ bohòbàa sə̀ bə zʉm, nə ye sə̀ wo sə fa bwe sə̀ lə mbwi bə nùumbu yà'sə. ");
INSERT INTO yam_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wèeŋ lɛŋ Nwì də bum yè'sə kà mvə̀k mbʉ̀ŋ nə̀ bə mbʉəp ye, ");
INSERT INTO yam_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","bʉ̀ʉsə̀ ŋgə' nə̀ nà'a nə ye mvə̀k ànə nə bʉp vɛ'ɛ nsàp nə̀ nzeŋgòŋ à yè yèe, à ka vɛ'nə ye yuk, nə kə dzeŋ nə̀ ŋga'a nè'e, nə ye sə̀' də yumok nə kà vɛ'nə mok sə̀' kə̀ ye yuk. ");
INSERT INTO yam_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tà Nwì a ka-a nùumbu yà'sə lə̀m cì' fəsə də bwɛ̀rɛ ŋwə̀ nə̀ mò'fis kà bwehè cu lok. Megu də yi nə ci' fəsə yà' lə̀m bʉ̀ʉ tu bʉ̀ʉ ye sə̀ yi a swè' nòŋsə wo sə. ");
INSERT INTO yam_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","<<A ye-a ŋga ŋwə̀ nəmòk dʉk-a wu də, <Yeè, ŋkum ŋgà gèm bwìiŋ nɛ̀> kè də <yi fə nà'> à lɛ', kà də wu dzəm swi dʉ'. ");
INSERT INTO yam_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bwìiŋ nə sə borə kɛ' də wo Krɛst, nə sə dʉk də wo ŋgàa tsòhòbum Nwì. Wo nə sə gʉ nsàap bum maŋgəŋgèeŋ mok də co wo borə bʉ̀ʉ sə̀ Nwì à cok fis nòŋsə sə bə zeŋ ŋga wo tse'-a mandzə̀ nə na. ");
INSERT INTO yam_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jəŋ ŋkərə̀, bʉ̀ʉsə̀ mʉ̀ tsə̀' nòŋsə weŋ bum yè'sə ŋga cu ntòcu. ");
INSERT INTO yam_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","<<Nùumbu sə̀ yà'a nə sə və ŋga ŋgə' nə̀ bʉp nə a càa fana nùum nə kɛŋ ndzəm. Ŋwʉ nə kà sa. ");
INSERT INTO yam_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ŋkə̀ŋkàaŋ nə gbʉhʉ tsooŋ mʉbu, nsàap ŋàaŋ mok wèŋ sə̀ mʉbu pwe' nə tsoho. ");
INSERT INTO yam_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Fana mʉ̀ʉ mo ŋwè mʉ nə tesə və ndzənə mbàk bə ŋàaŋ sə̀ ghaŋ, nə sə fom rɛŋ boŋsə nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mʉ nə tumsə gesə masinjàa Nwì mvwe' ŋkùup nzeŋgòŋ sə̀ kwè sə pwe', ŋgòjə benə və̀ bʉ̀ àm mvwe' mò'fis. Wo nə lo mvwe' sə̀ nzeŋgòŋ nə yèto nə ye mvwe' sə̀ nà' kə̀ lə̀sə. ");
INSERT INTO yam_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","<<Mʉ̀ dzəm də wèeŋ yə'rə jəŋ ŋkərə̀ bohòtʉ fik nà'a. Wù yə ghà nə̀ nà' yè ŋgòfom, nə sə top, fana wù riŋ də mvə̀k mbʉ̀ŋ kʉəp laŋ. ");
INSERT INTO yam_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yà' mègù sə̀' vɛ'nə də wu ye-a bum yè'sə vɛ'nə, fana wù riŋ də mo ŋwè kʉəp ŋgòvə̀ laŋ, yi megu mok ŋgʉ ncù. ");
INSERT INTO yam_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mʉ tsə̀' weŋ zìnə də bʉ̀ʉ sə̀ wo cu ŋga'a yè'e wèeŋ nə kà ntòkpʉ wes ŋga bum yè'sə yà' fà' laŋ. ");
INSERT INTO yam_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ntòbu bə nzeŋgòoŋ nə ca gɛsə lo fo', ncèp àm kà ye cà yuk. ");
INSERT INTO yam_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","<<Ŋwə̀ nəmòk ka mvə̀k nə kè nùmbu nə̀ bum yè'sə nə ye riŋ. Masinjà Nwì bə mo Nwì pwe' ka riŋ, mègù tɛ̀' yiìyi nə̀ yi rìi. ");
INSERT INTO yam_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jəŋ ŋkərə̀, nə so bə̀boŋ, bʉ̀ʉsə̀ wù ka mvə̀k nə̀ yà'a nə ye nə riŋ. ");
INSERT INTO yam_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Anə ye co mʉmvə̀'nə̀ ŋwə̀ nəmòok mè'rəgə̀ ndap ye, nə lo gì, nə me'rə fa bum pwe' bohòbʉ̀ ŋgàa fàak ye, nə tsok fa ndàaŋwè pwe' yusə̀ nà'a nə sə gʉ. Fana yi tsok fa ŋgà kʉ̀k ncù də, nà'a sə so bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sò-a, njo nə̀ wèŋ ka ghà nə̀ tà ŋgà ndap nə nə və riŋ. Aco yi və nə̀ nconùm, kè nə̀ ntəntʉmtsok, kè ŋga tsok sə kʉəp ŋgòrɛŋ, kè ŋga nùm sə rɛŋ ko'. ");
INSERT INTO yam_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bwɛ̀rɛ yi vəm tesə və̀-a vak, fana yi tseŋ wu ŋga wù sə dzəmlo. ");
INSERT INTO yam_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sòo. Yusə̀ mʉ̀ cèp bohòwèŋ, a sə̀' yusə̀ mʉ̀ cèp bohòndàaŋwè pwe'.>> ");
INSERT INTO yam_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","À bwehe mègù nùumbu ba ya ŋga ŋkà'a Pasobàa dzeŋ. Mvə̀k ànə dzèŋgə̀ə, wo sə zʉ megu brɛd sə̀ wo ka yiìs nja gesə. Fana ŋgàa fa satikà' bə bʉ̀ ŋgàa yə'rə̀ lʉ̀k wèŋ sə lap mandzə̀ də wo borə ko Jisòs, nə kə zə yi. ");
INSERT INTO yam_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wo dʉk fe'lə sə̀' bə tu awo də, <<Kaco vesùwèŋ ko yi nùmbu satikà' ye, bʉ̀ʉsə̀ bwìiŋ nə gham vesùwèŋ ŋga'a.>> ");
INSERT INTO yam_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","À ye sə̀' ghà nà'nə mvwe' lak Betanì, fana Jisòs sə zʉ zʉzʉ mʉ nda'à Saimʉ̀ nə̀ yi ànə ye to ŋgà kuturu nà'a. Fana ŋwà nəmòk jəŋ və ndo mve' làmindà sə̀ yà' gʉ ntɛŋ cɛ̀bʉ̀ə̀, nə vok cùu ndo nə, nə sə kɛ' tsoŋ fa Jisòs mʉ tuhù yi. ");
INSERT INTO yam_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bʉ̀ʉ mok jòk, nə sə ŋwərə kɛ'ca də, <<Wo gʉ̀ bʉpsə làmindà sə vɛ'nə bʉ̀ʉ yà lɛ? ");
INSERT INTO yam_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Anə boŋ co wo seŋ yà' lɛ ncùhù tɛ', nə gap fa ŋgàa jìŋ wèŋ mbàam sə, nə noŋsə ŋgògʉ̀ bʉpsə yà' vɛ'nə.>> Wo kʉk tʉsə ŋwà nə, nə jwa yi. ");
INSERT INTO yam_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisòs dʉk bwi ye də, <<Wèeŋ me'rə ŋwà nə, nə kà yi ŋgə' fa. Yi gʉ̀ fa mʉ yusə̀ yà' bòvɛ'ɛ maŋgəŋgèŋ. ");
INSERT INTO yam_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wèeŋ nə sə ye maligèŋ ŋgàa jìŋ fo' co wèŋ tɛsə wo ghà yà lòoŋ. Mʉ nə kà yàm vesùwèŋ cu malì. ");
INSERT INTO yam_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ŋwà ènə gʉ̀ yà'sə sə̀' mvə̀k ŋàaŋ ye, ŋgòyok fʉ̀hʉ nòŋsə ni' àm mvə̀'nə̀ wo nə tuuŋ nà'. ");
INSERT INTO yam_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mʉ tsok fa weŋ ncèp nə̀ nà'a ŋkèm dʉk də, mvwe' sə̀ fòpwe' sə̀ wo nə tsoho Ntirə̀ nə̀ Bə̀boŋ nə sənə nzeŋgòŋ nə fana yusə̀ yi gʉ̀ yè'sə wo nə sə tsərə maligə̀ yi bʉ̀ʉ zeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Fana mòk mʉtsətsə'rə̀ ŋgàa fàak ye sə̀ hum-ncòp-ba sə nə̀ liŋ yee Judàs Iskarəyà nà'a à tesə lòŋgòkə̀ sèŋ Jisòs bohòŋgàa fa satikà' wèŋ. ");
INSERT INTO yam_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wo à kwa ŋgòyuk yusə̀ Judàs ànə tsok wo sə nə̀ bʉp, nə kak yi də wo nə fa yi mbàm. Fana Judàs ye ŋga'a ŋgòlàp mandzə̀ nə̀ ŋgòsèŋ Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","À kə̀ dzèŋ nùmbu nə̀ wo à yèto ŋkàk nə̀ wo nə zʉ brɛd sə̀ wo ka yis nja gesə, yè'sə nùmbu nə̀ wo à sə səhə nsùŋgaaŋ ŋkàk pasobà sə̀'. Fana ŋgàa fàak Jisòs kə fek yi də, yi nə dzəm ŋgòzʉ ŋkàk nə ye ma fòlɛ, ya ŋga wo lo kə fʉhʉ tsə'rə mvwe' sə. ");
INSERT INTO yam_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jisòs cok fis ŋgàa fàak ye ba, nə tsok fa wo də, wo lo sə ntòlak. Wo ye ŋwə̀mbam nəmòk ŋga yi bə̀k kʉ̀ʉŋ ndzəp, wo yuŋ lo nà'. ");
INSERT INTO yam_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mvwe' ndap nə̀ yi kə̀ ni mbwa pwe', wo fek ŋgà ndap nə də, Cicà dʉk də wo fek nà' də, rum ndap nə̀ yi bə ŋgàa fàak yee nə zʉ ŋkàk pasobà mbwa fòlɛ? ");
INSERT INTO yam_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Fana yi nə niŋ fa wo rum mòk nə̀ ghaŋ ma mʉ tuhù, nə̀ bə̀boŋ, nə̀ bum mbwa pwe'. Wo fʉhʉ tsə'rə nà'. ");
INSERT INTO yam_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ŋgàa fàak ye sə à lòo, nə kə tseŋ bum pwe' mʉmvə̀'nə̀ Jisòs ànə dʉk sə. Wo fʉhʉ zʉzʉ pasobà sə̀ fo'. ");
INSERT INTO yam_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nùm à co, yi və fo' bə bwe ye sə̀ hum-ncòp-ba sə lòoŋ. ");
INSERT INTO yam_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mvəsə̀ wo à zʉ zʉzʉ, fana Jisòs dʉk də, <<Mʉ̀ sə tsə̀' weŋ də, ŋwə̀ nə̀ mò'fis mʉtsətsə'rə wèŋ fɛɛŋ nə seŋ mʉ, a mòk nə̀ yi sə zʉ be'lə vèsə.>> ");
INSERT INTO yam_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bwe ye sə à yè ŋgòkoksə manziŋ, nə sə dʉhʉ fa yi mò'fis mò'fis dʉk də, <<Anə kà wu lɛ mʉ̀ sèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisòs dʉk fa wo də, <<A mòk mʉtsətsə'rə wèŋ sə̀ hum-ncòp-ba yè'sə, a yi nə̀ yi sə fa kʉ̀rə tsə lòbo sənə ŋgàp vesi nà'a. ");
INSERT INTO yam_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mʉ̀ʉ mo ŋwè, mʉ nə kpʉ lo mvə̀'nə̀ wo à còm nòŋsə ndzənə ŋwàk Nwì sə. Fana ŋgə' nə̀ bʉp cu bohòŋwə̀ nə̀ yi sèŋ mʉ ànə. Ànə boŋ ghak bohòŋwə̀ ànə co wo kà yi dzə lok.>> ");
INSERT INTO yam_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mvə̀'nə̀ wo à sə zʉ fana Jisòs jəŋ brɛd, nə kwasə Nwì, nə bə'rə fa bwe ye sə. Yi dʉk də, <<Wèeŋ jəŋ, nə zʉ. Nè'e ŋgùpni' àm.>> ");
INSERT INTO yam_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yi à jə ŋgàp, nə kwasə Nwì, nə fa wo. Wo no sənə ŋgàp nə̀ mò'fis wo pwe'. ");
INSERT INTO yam_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yi dʉk də, <<Yè'e ndʉəm am sə̀ yà' fè'e bʉ̀ʉ bwìŋ ŋkʉ̀ʉŋ, a zeŋ sə̀ yà' kì ŋge' ndzənə rʉ̀k njàm. ");
INSERT INTO yam_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mʉ̀ sə tsə̀' weŋ də, mʉ nə kà rùk nè'e vesùwèŋ mok no fe'lə̀ tè kə dzeŋ nùmbu nə̀ mʉ nə kə̀ no nà' mok nsàp nə̀ fi mvwe' gaŋ Nwì.>> ");
INSERT INTO yam_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wo à yəm ŋkì, nə tesə lo mvwe' nda Olìp. ");
INSERT INTO yam_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","À kə̀ dzèŋ fo', Jisòs tsok fa bwe ye sə wèŋ dʉk də, <<Wèeŋ nə caŋ me'rə mʉ mʉmʉ̀. Mʉ̀ rì vɛ'nə bʉ̀ʉsə̀ Ŋwàk Nwì sə dʉk sə̀' vɛ'nə də, <Mʉ̀ʉ Nwì, mʉ nə ləp ganakù' nə, fana nsùŋgaaŋ sə nə caŋ sam.> ");
INSERT INTO yam_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Anə ye sə̀' də ghà nə̀ mʉ nə lokok mvwe' kpʉ, fana mʉ nə lo mantombìi wèŋ mvwe' nzeŋgòŋ Galìli.>> ");
INSERT INTO yam_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pità cep fəsə fa yi də, <<A ye-a ŋga bwìŋ pwe' ca mè'rə-a wu sə̀ ca, mʉ nə kà wu yàam ca mè'rə̀.>> ");
INSERT INTO yam_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisòs dʉk fa Pità də, <<Mʉ tsok wu ŋkèm ncèp də, ŋkuŋ mvəp sə to bə ndzəm nə̀ ntinə nè'e kɛ̀' ba, ŋga wù dʉk də wù ka mʉ riŋ kɛ̀' tɛ'.>> ");
INSERT INTO yam_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pità cep fe'lə bə ŋàŋ də, <<À mègù-a sə̀ ŋgòkpʉ vesù, kaco mʉ̀ bɛŋ wu yeŋ.>> Bwe ye mok sə dʉk sə̀' vɛ'nə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wo à kə̀ dzèŋ mvwe' səmok sə̀ wo togə̀ fo' də Gèsemanì, fana Jisòs dʉk fa ŋgàa fàak ye wèŋ sə dʉk də, <<Wèeŋ cum fɛɛŋ ya mʉ kə gʉ pìriyà.>> ");
INSERT INTO yam_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yi jəŋ bwìŋ tɛ', Pità, Jem nə ye Jon də wo yuŋ yi. Tsətsərə̀ nə̀ bʉp yèto ŋgòvə̀ bohòyi, yi kà kwəkwa mok tse' lok, ");
INSERT INTO yam_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","fana yi dʉk fa yà'wèŋ də, <<Tsətsərə̀ nə̀ bə manziŋ sə ntʉʉ̀ mʉ̀ nə̀ bʉp co mʉ̀ coho gbʉ kpʉ. Wèeŋ cum fɛn, nə sə so, nə kà lo dzəm.>> ");
INSERT INTO yam_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yi sooŋ lo mantombì, nə gbʉ sə nze, nə sə lɛŋ pìriyà dʉk də, mandzə̀ mok ye-a yo, yi kà ŋgə' nsàp nà'nə yə. ");
INSERT INTO yam_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yi lɛŋ də, <<Pàpa tɛ̀' àm, yumok kà wu gha'gə̀. Jəŋ gɛsə ŋgàp ŋgə' nə̀ mʉ tuhù mʉ̀ nè'e fo'. Mʉ dʉk-a sə̀ vɛ'nə, wù gʉ lɛ mʉmvə̀'nə̀ wù dzəm wù, kà mʉmvə̀'nə̀ mʉ̀ dzəm mʉ̀ gʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Anə geŋ, yi lo, nə kə tseŋ bwe ye sə̀ yi ànə jəŋ tɛ' sə ŋga wo sə dzəm lo. Yi yəmsə wo, nə dʉk fa Pità də, <<Wù sə dzəm lo à, Saimʉ̀? Kaco wù cum nca mvə̀k mwejo yeŋ à?>> ");
INSERT INTO yam_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yi dʉk fe'lə fa yà'wèŋ də, <<Wèeŋ so, nə sə gʉ pìriyà sə̀' ya mə̀mumsə̀ə kà weŋ gha'. Ntʉm yo, megu də ŋàŋ ka yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yi lo, nə sə kə gʉ malì pìriyà sə̀mok, nə sə cep megu sə̀' yusə̀ yi anə cep mantombì sə. ");
INSERT INTO yam_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ànə geŋ yi bwi foho və fe'lə, nə kə tseŋ yà' ŋga yà' sə dzəm fe'lə sə̀ lo sə. Wo kà yusə̀ co wo cep tse', bʉ̀ʉsə̀ lo ànə sə ko zəm tse' wo lis vɛ'ɛ nsàp nə̀ bə jòŋ. ");
INSERT INTO yam_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yi ànə bwi və nə̀ kɛ̀' tɛ', fana yi dʉk fa wo də, <<Wèŋ sə nòoŋ yòŋsə malì yu awèŋ fo' à? Yà' kʉ̀rə laŋ, mvə̀k nə kə dzèŋ laŋ, wo sèŋ fa mʉ̀ʉ mo ŋwè bohòŋgàa gʉ̀ bʉp wèŋ. ");
INSERT INTO yam_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wèeŋ lokok a lo, yeè, ŋwə̀ nə̀ yi seŋ mʉ̀ nə nè'.>> ");
INSERT INTO yam_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","À ye ŋga Jisòs sə cèp mali ntòfo', fana Judàs nə̀ yi mo fàk ye mòk tesə və bə bʉ̀ʉ səmok ŋga wo rìp fèk, nə tse' ntòk. Ànə tumsə wo ŋgàa fa satikà' sə̀ ghaŋ bə ŋgàa yə'rə̀ lʉ̀k, nə ye bʉ̀ʉ sə̀ mantombì. ");
INSERT INTO yam_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ŋga Judàs ànə tsok nəm wo də wo yə-a ŋga yi kə̀ cepsə ŋwə̀ nəmòk bə̀boŋ co ŋge' àlɛ, wo riŋ də nà'a yi nə. Wo ko lo yi, nə kotse' lo yi cʉ̀k. ");
INSERT INTO yam_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mvə̀'nə̀ Judàs ànə wɛsə və ntɛ̀ŋ, yi ye gesə Jisòs, nə lo kə cepsə nà' co ŋge', nə də, <<Cicà.>> ");
INSERT INTO yam_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Fana wo kə̀ kotse' Jisòs cʉ̀k. ");
INSERT INTO yam_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ŋwə̀ nəmòk nə̀ yi à ye fo' à sə̀ cok fis fèk ye, nə gbɛ' tiŋ mak ntu'u mo ŋkwɛ̀ŋ ŋkum ŋgà fa satikà' mòk sə nze. ");
INSERT INTO yam_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jisòs cèp ye dʉk də, <<Wèŋ tesə co wèŋ sə lo mvwe' bɛ' ŋgà yə̀ bə fèk nə ye ntòk yè'e ŋgòko mʉ̀ à? ");
INSERT INTO yam_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Vesùwèŋ yiskokgə̀ mʉmvwe' ndap Nwì nə̀ ghaŋ nə səsa, mʉ̀ sə yə'rə bwìŋ, wèŋ kà mʉ ko. Yè'e ŋgògʉ̀ də yusə̀ ŋwàk Nwì à cèep ye vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yà'a ŋga'a mvə̀k nə̀ ŋgàa fàak ye sə wèŋ à mè'rə yi, nə caŋ lo wes pwe'. ");
INSERT INTO yam_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mʉ wà'nzùm nəmòk à sə yù Jisòs wèŋ maŋkwɛ̀ŋ ŋga yi lim tse' mègù làba' ye. Wo də wo ko yi ye sə̀' korə. ");
INSERT INTO yam_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mvə̀'nə̀ wo à ko làba' nə, yi swɛ̀'ɛ tesə ye sə, nə caŋ lo nswɛ̀'mbwè. ");
INSERT INTO yam_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wo à jə lòJisòs mvwe' ndap ŋkum ŋgàa fa satikà' ŋga ŋgàa fa satikà'a sə̀ ghaŋ pwe' bə bʉ̀ʉ sə̀ mantombì nə ye ŋgàa yə'rə̀ lʉ̀k wèŋ à kə̀ benə fo'. ");
INSERT INTO yam_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ànə ye ŋga Pità sə yù və̀ maŋkwɛ̀ŋ mwe sə̀sap, nə kə ni sə̀' mʉ ntòmbiì ŋkum ŋgà fa satikà' nə. Yi à kə̀ cu fo', nə sə yuk mis bə bʉ̀ʉ sə̀ wo à sə kʉ̀k ndap Nwì wèŋ. ");
INSERT INTO yam_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ŋgàa fa satikà' sə̀ ghaŋ bə ŋgàa kaŋsurù sə pwe' à sə làp yumok co wo ko Jisòs bə zeŋ ya wo zə yi. Fana wo kà yumok yə. ");
INSERT INTO yam_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bwìŋ à yè ŋgòcì' fa Jisòs mvwès, wo pwe' cep cù zəzok. ");
INSERT INTO yam_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mok lokok, nə ci' fa yi mvwès dʉk də, ");
INSERT INTO yam_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","<<Vès à yuk ŋga yi sə dʉk dɛɛ, yi nə kʉəmsə mak ndap Nwì, nə̀ bwìŋ à ci nè'e, a ca nùumbu tɛ', yi ci mok fo' sə̀' nə̀ bwìŋ ka nà' mok bə bo ci.>> ");
INSERT INTO yam_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wo à cèp-a sə̀ vɛ'nə, yusə̀ wo sə cèp sə ka mvwe' mò'fis ye. ");
INSERT INTO yam_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ŋkum ŋgà fa satikà' nə à lòkok təəŋ mʉtsə̀ kə̀ mantombì wo pwe', nə fek Jisòs də, <<Wù ka yumok ŋgòcèp tse' à? Bʉ̀ʉ yè'e sə dʉk də wù a dʉk da ɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jisòs cum megu dədok. Yi fek fe'lə Jisòs sə̀mok dʉk də, <<Wu ŋkum ŋgà gèm bwìŋ nə ye mo Nwì nə̀ vès sə kʉ̀ksə yi nə àlɛ?>> ");
INSERT INTO yam_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisòs à dzəm də, <<Ŋ̀, a mʉ̀. Wèeŋ nə ye mʉ̀ʉ mo ŋwè ŋga mʉ̀ cu bo mamà'a Nwì nə̀ yi tse' ŋàŋ nə, nə ye fe'lə mʉ ŋga mʉ̀ sə tsə mʉbu ndzənə mbàk.>> ");
INSERT INTO yam_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yi ànə dʉk wes vɛ'nə, fana ŋkum nə jok, nə soŋ sarə cə̀k nə̀ mʉ ni'ì yi, nə dʉk də, <<Njo nə̀ a lap yis fe'lə ŋwə̀ nəmòk ŋgòkə̀ rɛŋsə fe'lə yumok ka mok ye. ");
INSERT INTO yam_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wèŋ yuk nsàp nə̀ yi bʉpsə liŋ Nwì sə laŋ. Wèŋ dʉk yàwèŋ də yà?>> Wo pwe' kiŋ cù də wo zə megu yi zəə. ");
INSERT INTO yam_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mok yèto ŋgòte Jisòs bə nte, nə ləp yi ŋga wo lok tse' yi lis, nə sə fek yi dʉk də, yi riŋ-a ŋwə̀ nə̀ nà' ləp yi nə. Ŋgàa fàk sə̀ wo à sə fàk bohòŋkum ŋgàa fa satikà' à sə lə̀p yi sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","À ye ŋga Pità à cu mali ntòmvwe' ntòmbi nə, fana mʉŋwà nəmòk nə̀ yi fàkgə̀ bohòŋkum ŋgà fa satikà' nə à və̀ fo' ");
INSERT INTO yam_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ŋga Pità sə yuk mis. Yi kʉk ja'a nà' jwaŋ, nə dʉk də, <<Wu yegə̀ sə̀' weŋ Jisòs nə̀ mvwe' lak Nazàrɛ nə.>> ");
INSERT INTO yam_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pità bɛŋ də, <<Mʉ̀ ka yusə̀ wù sə cèp yà'sə riŋ. Yà' sə ka fə ntu'ù mʉ̀ sə̀' rɛɛŋ.>> Yi tesə tsooŋ lo mvwe' ncùu ŋka' ntɛ̀ŋ, fana mvəp to. ");
INSERT INTO yam_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mʉŋwà nə kə ye yi, nə sə tsoho mali fa bʉ̀ʉ sə̀ wo tərə fo' də Pità gù tsə gù mòk. ");
INSERT INTO yam_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yi à bɛ̀ŋ sə̀mok. À sàp ko' jo bʉ̀ʉ sə̀ wo à tərə fo' sə à dʉk fa yi də, <<Kaco wù bɛŋ də wù ka wenə wèŋ ye yeŋ, bʉ̀ʉsə̀ vès rì də wu ŋwə̀ə Galìli.>> ");
INSERT INTO yam_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yà' à bàa Pità yak ni' ye, nə kɛŋ mok Nwì də, <<Nwìi riŋ yi, mʉ̀ ka ŋwə̀ nə̀ wèŋ sə dʉk nà'nə riŋ lok kɛ̀' mò'fis.>> ");
INSERT INTO yam_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ntomvəp to sə̀mok. Fana Pità tsərə mvə̀'nə̀ Jisòs anə dʉk yi də, <<Mvəp nə to kɛ̀' ba ŋga wu bɛŋ mʉ kɛ̀' tɛ' də wù ka mʉ riŋ.>> Fana yi vehe waŋ nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ŋgàa fa satikà' wèŋ bə bʉ̀ʉ sə̀ mantombì nə ye bʉ̀ ŋgàa yə'rə̀ lʉ̀k nə ye fe'lə bʉ̀ʉ sə̀ wo sakgə̀ kaŋsurù wèŋ pwe' à yàaŋ kʉ̀rə nə̀ zəzòŋ, nə cep tes mvwe' mò'fis mvəsə̀ wo nə gʉ bohòJisòs. Fana wo kiŋ Jisòs, nə jəŋ lo yi kə̀ fa bohògovənòPalè. ");
INSERT INTO yam_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Palè à fek yi də, <<Wu ŋkum bʉ̀ʉ Jus wèŋ wu à?>> Jisòs dʉk fa nà' də, <<Wù dʉk yà'a mvə̀'nə.>> ");
INSERT INTO yam_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ŋgàa fa satikà' sə ye ŋgòlàp Jisòs bə nzak cɛ̀bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Palè dʉk fe'lə də, <<Wù sə kà cèp à, yuk a yòo bum sə̀ wo sə cèp bə liŋ yo pwe' ɛ̀?>> ");
INSERT INTO yam_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jisòs à cu mègù dədok. Yà' à ghak Palè mʉ tuhù. ");
INSERT INTO yam_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","À yegə̀ lə̀lùm mvə̀k ŋkà'a Pasobà, fana Palè fis me'rəgə̀ ŋgà ndapndzəm mò'fis nə̀ bwìŋ dzəm də yi me'rə nà'. ");
INSERT INTO yam_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mvə̀k nà'nə à ye ŋga ŋwə̀ nəmòk nə̀ wo togə̀ yi də Bàrabà à ye mʉ ndapndzəmə̀ bə bʉ̀ʉ səmok sə̀ wo à lʉ̀lʉ̀ bə bʉ̀ʉ gomè, nə zə bwìŋ. ");
INSERT INTO yam_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bwìŋ à və̀, nə sə fek Palè də nà'a fis me'rə ŋgà ndapndzəm mòk mvəsə̀ yi gʉ̀gə̀ lə̀lùm sə. ");
INSERT INTO yam_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Fana Palè fek wo də, <<Wèŋ dzəm də mʉ me'rə fa weŋ Jisòs ŋkum bʉ̀ʉ Jus à?>> ");
INSERT INTO yam_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yi fek vɛ'nə bʉ̀ʉsə̀ yi à rì sə ntʉʉ̀ yi də ŋgàa fa satikà' wèŋ ko Jisòs yè'sə ŋga wo à sə ko' mègù ndù. ");
INSERT INTO yam_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ŋgàa fa satikà' sə à yuk vɛ'nə, fana wo fimsə mis dʉk də bʉ̀ʉ sə dʉk Palè fis me'rə fa wo lɛ Bàrabà. ");
INSERT INTO yam_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Palè fek fe'lə bʉ̀ʉ sə də, <<Wèŋ dzəm də mʉ gʉ bə ŋwə̀ nə̀ wèŋ sə to yi də ŋkum bʉ̀ʉ Jus nà'a ye va?>> ");
INSERT INTO yam_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wo kɛ̀' fis bə ŋgùŋ də, <<Tɛ'lə yi mʉ ntə̀əŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Palè fek fe'lə wo də, <<Bʉ̀ʉ yà? Ŋwə̀ ènə gʉ̀ bʉpsə yà?>> Kàyà', wo fuŋ ghaha fuŋ də, <<Tɛ'lə mègù yi mʉ ntə̀əŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yi à dzəm ŋgògʉ̀ ya bʉ̀ʉ sə kwa. Fana yi me'rə Bàrabà, nə ləp Jisòs bə ŋkwɛ̀s, nə fa wo də wo kə tɛ'lə nà' mʉ ntə̀əŋ anə. ");
INSERT INTO yam_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sojàa sə wèŋ jəŋ lo Jisòs mʉnə ntòmbi ntò' Palè nə, nə to benə sojàa mok sə fo' lòoŋ. ");
INSERT INTO yam_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wo nisə fa yi nsàp cə̀k nəmòk sə̀sap bə ncòm bə̀baŋ, nə lim ndik nəmòk nə̀ bə njàk, nə ta fa yi mʉ tuhù co tàm ŋkum. ");
INSERT INTO yam_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wo ye ŋga'a ŋgòcèpsə kɛ' yi co ŋkum, nə sə cep də, <<Ŋgə̀ə̀ ŋkum bʉ̀ʉ Jus.>> ");
INSERT INTO yam_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wo ləp yi bə ntatʉ mʉ tuhù, te'lə fa yi nte mʉ ni'ì, nə sə təəŋ mantombìi yi bə tumfərə də wo sə kùksə yi. ");
INSERT INTO yam_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wo ànə ywi'lə kʉrə yi fana wo fweŋ fis ma sə̀sap cə̀k nə̀ wo anə ni fa yi nə, nə ni fəsə fa yi cə̀ək ye sə sə̀mok, nə jəŋ fis lo yi ŋgòkə̀ tɛ'lə yi mʉ ntə̀əŋ. ");
INSERT INTO yam_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","À kə̀ dzèŋ mandzə̀, wo kʉrə bə ŋgà' nəmòk nə̀ liŋ yee Saimʉ̀ ŋga yi sə və̀ ye mvwe' lak sə və̀ə. Fana wo tap ko yi bə ŋàŋ də nà'a bək ntə̀əŋ Jisòs sə. À ye Saimʉ̀ nə̀ mvwe' lak Sìrinì, tɛ̀'ɛ Àlèsandà bə Rufù. ");
INSERT INTO yam_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wo jəŋ lo Jisòs mvwe' sə̀ wo togə̀ fo' də Gòrìgotà (a yà'a də nzʉ̀ə̀ tu bwìŋ). ");
INSERT INTO yam_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wo lap mandzə̀ də wo fa yi rùk sə̀ wo tòrə yà' bə nsàp ncə̀p nəmòk sə̀ wo togə̀ yà' də meè. ");
INSERT INTO yam_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yà'a ŋga'a mok mvə̀k nə̀ wo à tɛ'lə yi mʉ ntə̀əŋ anə, fana wo jəŋ cə̀ək ye, nə sə təm gàpsə yà' bə bèŋ. ");
INSERT INTO yam_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wo à tɛ'lə yi ŋga a co nùm bɛŋ. ");
INSERT INTO yam_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wo à còm naaŋ njo kpʉ ye də, Ŋkum bʉ̀ʉ Jus. ");
INSERT INTO yam_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wo à tɛ'lə yi nùmbu anə bə ŋgàa yə̀ə mok bwìŋ ba. Mòk mazʉ, mòk maŋkwìp.  ");
INSERT INTO yam_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yè'sə à gʉ̀ ncèp nəmòk nə̀ nà' à ye ndzənə ŋwàk Nwì ŋgòkə̀ ye zìnə də, <<Wo à be'lə yi bə bʉ̀ ŋgàa gʉ̀ bʉp wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bʉ̀ʉ sə̀ wo à sə cà fo' wèŋ à sə yà'rə yi, nə sə mək tu awo dʉk də, <<Ŋ̀hŋ̀, a bə̀boŋ, nà'a wù nə̀ wù à dʉk də aco wù kʉəmsə mak ndap Nwì, nə ci wes fe'lə nà' mʉnə nùumbu tɛ' nə. ");
INSERT INTO yam_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Suhu tsoŋ na mʉ ntə̀əŋ fa' nə, nə tɛsə-a ni' yòɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ŋgàa fa satikà' sə̀ ghaŋ bə ŋgàa yə'rə̀ lʉ̀k wèŋ à sə ywi'lə yi sə̀'. Wo sə dʉhʉ kɛ' ca də, <<Yi tɛsə rì bòŋsə mègù bʉ̀ʉ mok wèŋ, nə kà ni' nə̀ nje tɛsə̀ rì. ");
INSERT INTO yam_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yi dʉkgə̀ də yi Ŋgà gèm bwìŋ nə̀ Nwì à dʉk də yi nə tum vesə nə, də yi ŋkum bʉ̀ʉ Izùrɛ. A ye-a vɛ'nə, wù suhu tsooŋ mʉ ntə̀əŋ ya vèes ye, nə dzəm bohòwù.>> Bʉ̀ʉ sə̀ wo à tɛ'lə be'lə yi bə yà'wèŋ sə, wo à yàk yi sə̀'. ");
INSERT INTO yam_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ànə ye ŋga nùum mok maràŋ kaŋ fana ndzəm seŋ mvwe' nzeŋgòŋ nə pwe' tə̀tè kə̀ dzeŋ co nùm sə̀m. ");
INSERT INTO yam_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","À kə̀ dzèŋ nùm sə̀m, Jisòs waŋ fis bə ŋgì nə̀ ghaŋ də, <<Eloi, Eloi, làma sabatàni?>> A yà'a dʉk də, <<Nwì àm, Nwì àm, wù swì mà' mʉ bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bʉ̀ʉ mok sə̀ wo à ye fo' à yuk, nə dʉk də, <<Wèeŋ yu'rə àwèŋ mvəsə̀ yi sə to Àlajà.>> ");
INSERT INTO yam_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ŋwə̀ nəmòk nə̀ yi à ye sə̀' fo' caŋ kə̀ tsə̀p gesə yumok co kùsa vɛ'ɛ sənə rùuk sə̀ cʉcʉk, nə kə tse' gesə lo mʉ cùhù Jisòs bə ntatʉ. Yi dʉk də, <<Wèeŋ yuk, a ja'a na kèe Àlajàa nə kə jəŋ tsooŋ yi mʉ ntə̀əŋ fa'nə àlɛ'.>> ");
INSERT INTO yam_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jisòs waŋ fe'lə bə ŋàŋ sə̀mok, fana yòŋsə̀ ye me. ");
INSERT INTO yam_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ghà nə̀ yi ànə kpʉ à ye fana cə̀k nə̀ nà' à sə gàpsə rum ndap mòk mʉmvwe' ndap Nwì nə̀ ghaŋ nə à sàha jəŋ mʉ tuhù wàrr, kə̀ dzèŋ sə mbwè. ");
INSERT INTO yam_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ŋkum sojà nə̀ yi à təəŋ fo' mantombìi Jisòs à yə mvəsə̀ nà' wa nə kpʉ, fana yi dʉk də, <<Kɛ', ŋwə̀ ènə nə ye mo Nwì nə̀ zìnə.>> ");
INSERT INTO yam_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bàa səmok à tə fo' mvwe' sə̀sap, nə sə ja'a. À ye mok fo' Mèri Màdàlinà, Sàlomì bə Mèri ma Jem nə̀ mweŋke' bə Josìs. ");
INSERT INTO yam_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bàa yè'sə à yèto ŋgòyù jə Jisòs mvwe' nzeŋgòŋ Galìli, nə sə tɛsə nà'. Bàa səmok à ye fo' sə̀' ŋkʉ̀ʉŋntɛ̀ŋ sə̀ wo à və̀ Jòrosalèm bə yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nconùm nùmbu nə̀ wo à sə fʉ̀hʉ dzə̀ à kə̀ dzèeŋ, ");
INSERT INTO yam_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","fana Jòsep nə̀ mvwe' lak Àrìmàtayà à ko ntʉm, nə kə ye Palè də nà'a fa yi vèŋ Jisòs ya yi kə̀ tuuŋ. Yi à ye ŋwə̀ nə̀ zìnə mvwe' kwe' kaŋsurù awo nə, yi sə tək ŋgòyə mvəsə̀ gaŋ ŋkum Nwìi nə̀ ye. ");
INSERT INTO yam_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Palè vehe ŋgòyuk də Jisòs nə kpʉ laŋ, nə to fek ŋkum sojà də Jisòs nə kpʉ laŋ àlɛ. ");
INSERT INTO yam_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mvə̀'nə̀ yi à yuk wes yusə̀ ŋkum sojà nə à tsə̀' fa yi, fana yi dʉk fa Jòsep də nà'a jəŋ vèŋ ni' Jisòs nə ntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jòsep à lò, nə kə ki tsoŋ fis Jisòs mʉ ntə̀əŋ anə, nə lim gesə nà' ndzənə cə̀k fəfop nə̀ yi ànə ywi, nə tuuŋ nà' ndzənə nsàp sè nə̀ wo ànə tuŋ ndzənə lìs, nə bwi' lok yà' bə ŋkə̀ŋkʉ̀m lìs nəmòk. ");
INSERT INTO yam_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Bə̀ba səmok à ye fo', a ye Mèri Màdàlinà bə Mèri ma Jisòs. Bàa yè'sə à yə mvwe' sə̀ wo à tuuŋ Jisòs sə. ");
INSERT INTO yam_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nùmbu dzə̀ à càa, Mèri Màdàlinà bə Mèri ma Jem nə ye Sàlomì wèŋ à ywi ncə̀əp mok də wo kə yok vèŋ ni' Jisòs bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tsok à rɛŋ ye Sondè ŋga cu ntòzəzòŋ ŋga nùm sə bà tesə ko' sə cùu ndahà, fana wo lo mvwe' sèe sə. ");
INSERT INTO yam_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wo sə dʉhʉ lo mandzə̀ də, ŋwə̀ nə̀ yi nə kə dzərə fis fa wo lìs mvwe' ncùu sèe sə nə ye yè'sə ndà lɛ. ");
INSERT INTO yam_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wo ànə geŋ à, wo ye ŋga wo dzərə gɛsə ma ŋkə̀kʉ̀m lìs nə mvwe' ncùu sèe sə laŋ. Lìs nə à yam vɛ'ɛ nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wo ni lo ca, nə ye wà'ŋwə̀ nəmòk ŋga yi cu mamàk, nə ni tse' cə̀k nə̀ fəfop mʉ ni'ì yi. Fana ntʉm tiŋ wo nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yi dʉk fa bàa sə də, <<Wèeŋ kà wəp, mʉ̀ rì də wèŋ sə làp Jisòs nə̀ mvwe' lak Nazàrɛ nə̀ wo anə tɛ'lə yi mʉ ntə̀əŋ nà'a. Yi ka fɛŋ yeŋ. Yi lòkok mvwe' kpʉ laŋ. Kə̀ kʉ̀k ja'a na yòo mvwe' sə̀ wo a nòŋsə yi sə. ");
INSERT INTO yam_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nə yeè nə vɛ'nə fana wèeŋ du lo kə tsok fa ŋgàa fàak ye bə Pità sə̀' vɛ'nə. Yi gə̀ cà nà' mantombìi wèŋ ŋgòlòmvwe' nzeŋgòŋ Galìli, wèeŋ nə kə ye gu yi fo' mvə̀'nə̀ yi ànə tsok me wèŋ sə.>> ");
INSERT INTO yam_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yi à cèp wes mè vɛ'nə ntɛ̀ŋ, wo carə tesə sənə sèe sə ŋga wo sə kà bə wʉə jìk jìk. Mvə̀'nə̀ wo à sə wəp, fana wo carə lo, nə kà ŋwə̀ nəmòk yumok tsə̀' fa.  ");
INSERT INTO yam_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisòs ànə lòkok nùmbu Sondè anə fana ye to yi Mèri Màdàlinà nə̀ yi à jùm fis fa nà' yòŋsə̀ə ze' sàmba ndzə ni'ì nà'a. ");
INSERT INTO yam_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mèri lo kə tsok fa bʉ̀ʉ sə̀ Jisòs à sə ye bə yà'wèŋ ŋga wo sə tɛ', nə sə waŋ nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mvə̀'nə̀ wo à yuk də yi dʉk də Jisòs lòkok mvwe' kpʉ nə də yi yə nà' bə lis, wo kà yi dzəm fa. ");
INSERT INTO yam_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yà'sə à càa, yi yəəŋ fe'lə bə nsàp mòk bohòbʉ̀ ŋgàa fàak ye bwìŋ ba, ŋga wo sə mè'rə ntòlak Jòrosalèm nə. ");
INSERT INTO yam_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wo bwi lo, nə kə tsok fa mok sə, fana wo kà sə dzəm malì. ");
INSERT INTO yam_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","À ye maŋkwɛ̀ŋ, yi kə niŋ fe'lə ni' ye mok bohòŋgàa fàak ye sə̀ hum-ncòp-mò'fis ŋga wo sə zʉ zʉzʉ, nə jwa wo bʉ̀ʉsə̀ wo à gʉŋsə ntʉm awo nə kà yusə̀ bʉ̀ʉ sə̀ wo à yə yi tsə̀' fa wo sə dzəm. ");
INSERT INTO yam_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Fana yi tsok fa yà' də, <<Wèeŋ du sənə ŋgòŋ nə lòoŋ fo', nə tsoho lo ncèp àm nə bohòndàaŋwè pwe'. ");
INSERT INTO yam_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ndàaŋwè lòoŋ nə̀ yi dzəm-a, nə baptɛsə, yi tse' lùŋ. Ŋwə̀ nə̀ yi kà-a dzəm, ye də Nwìi nə sak yi. ");
INSERT INTO yam_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bʉ̀ʉ sə̀ wo dzəm, wo nə tse' nsàp ŋàŋ nə̀ ŋgògʉ̀ bum ye'e: wo nə bɛ' fis yòŋsə̀ə ze' bə liŋ am. Wo nə cep riŋ ncèep sə̀ fi. ");
INSERT INTO yam_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wo te' tse' a no, kè wo no-a nsàp lik nə̀ fòpwe', yà' kà wo yumok gʉ̀. Wo nə naaŋ fa ŋgàa yiyaŋ bo, wo gʉŋ.>> ");
INSERT INTO yam_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tà Jisòs à cèp wes mè bə yà'wèŋ, fana yi kok lo yuye mʉbu, nə kə cum bo mamà'a Nwì. ");
INSERT INTO yam_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ŋgàa fàak ye à lòo, nə tsoho lo fòpwe'. Tà Jisòs sə fa wo ŋàŋ ŋgògʉ̀ maŋgəŋgèŋ, ya bwìiŋ riŋ də yusə̀ wo sə tsoho sə zìnə.");
INSERT INTO yam_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ŋge' àm Tìyofilò, bwìŋ ŋkʉ̀ʉŋ a mùmsə ja'a ŋgòcòm bum sə̀ Tà Jisòs à gʉ̀ mʉtsətsə'rə̀ə vès. ");
INSERT INTO yam_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wo ànə com bə ncèp nə̀ vès ànə yuk bohòbʉ̀ʉ sə̀ wo à yə bum yè'sə mvəsə̀ yà' ànə yeto, fana wo tsoho fa bwìŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Fana Tìyofilòtà, mvə̀k nə̀ mʉ̀ a lap ja'a bum yè'sə bə ŋkərə̀ nə̀ njàm bə̀boŋ mvə̀'nə̀ yà' à yèto, mʉ̀ dzəm ŋgòcòm fa wu mvə̀'nə̀ yà' ànə ye sə bə mandzə̀ nə̀ yà' ànə ye sə mò'fis mò'fis. ");
INSERT INTO yam_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mʉ̀ sə com yè'sə ya wu riŋ tse' də bum sə̀ wo ànə yə'rə fa wu yà'sə zìnə. ");
INSERT INTO yam_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mvə̀'nə̀ Heròànə ye ŋkum mvwe' lak Jùdiyà fana ŋwə̀ nəmòk à ye mvwe' lak yà'sə nə̀ liŋ ye à ye də Sàkàriyà. Yi à ye ŋgà fa Nwì satikà', nə sə fak bə bòp bʉ̀ ŋgàa fa satikà' sə̀ wo togə̀ wo də Àbijà. Fana liŋ ŋgwe ye à ye Àlisabè. Ŋwà ènə à ye sə̀' ŋgwì bʉ̀ Aròŋ wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sàkàriyà bə Àlisabè à ye kə̀kʉrə̀ mantombìi Nwì, nə sə noŋsə lʉ̀k mvəsə̀ Tà Nwì à fa sə zìnə. ");
INSERT INTO yam_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wo ànə ka bwe tse' bʉ̀ʉsə̀ Àlisabè nə à ye nzeŋ fana wo reŋ ŋkʉ̀ʉŋntɛ̀ŋ, co wo kà mwe mok dzə. ");
INSERT INTO yam_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nùmbu mòk à ye mvə̀k kʉrə bohòbòp bʉ̀ʉ Sàkàriyà ŋgòsə fàk mʉmvwe' ndap Nwì nə̀ ghaŋ nə fana Sàkàriyà sə gʉ fàak ye co ŋgà fa satikà'. ");
INSERT INTO yam_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ànə geŋ wo təm bèŋ mʉmvə̀'nə̀ wo gʉ̀gə̀ yàwo, fana yà' zʉ də Sàkàriyàa ni lo mʉmvwe' ndap Tà Nwì nə̀ ghaŋ nə yi, nə tɛŋ rəmsə làmindà. ");
INSERT INTO yam_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Yi ànə ni lo mʉ ndap Nwì anə ŋgòtɛ̀ŋ làmindà sə fana bwìŋ pwe' sə lɛŋ Nwì ma sə mbi mvə̀' nə̀ wo gʉ̀gə̀ə. ");
INSERT INTO yam_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Fana masinjà Nwì kurə tesə və, nə kə təəŋ kok bo mamàk mvwe' kàm nə̀ Sàkàriyà à sə tɛ̀ŋ fa Nwì làmindà nə. ");
INSERT INTO yam_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sàkàriyà ànə ye masinjà Nwì nə fana yi mərə, nə sə kaŋ bə wʉə. ");
INSERT INTO yam_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Fana masinjà Nwì nə dʉk fa Sàkàriyà də nà'a kà wəp. Nə tsok fa nà' də, <<Nwì a yuk pìriyà yòlaŋ. Nə yeè nə də ŋgwe yo Àlisabèe nə dzə fa wu mombam. Yi dzə nà', wù to liŋ ye də Jon. ");
INSERT INTO yam_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mo ènə nə gʉ wu, wù kwa wùriŋ. Nə ye də bwìŋ ŋkʉ̀ʉŋ nə kwa bʉ̀ʉsə̀ wo dzə yi sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jon nə nə ye ŋwə̀ nə̀ ŋkʉ̀ʉŋ bohòTà Nwì. Yi nə kà rùuk sə̀ gʉgʉŋ no. Yi nə rwiŋ bə Yòŋsə̀ nə̀ Rərɛŋ, ye jəŋ mvə̀k nə̀ wo dzə yi, nə lo mantombì. ");
INSERT INTO yam_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yi nə gʉ ya bʉ̀ʉ Izùrɛ wèeŋ bʉ̀ʉŋ və̀ bohòTà Nwì àwo. ");
INSERT INTO yam_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tà Nwìi nə tum lo yi mantombìi yi bə nsàp yòŋsə̀ nə ye ŋàaŋ sə̀ yi ànə fa Àlajà. Jon nə nə gʉ tɛ̀' wèŋ ŋgòdzəm bwe awo. Yi nə gʉ bʉ̀ ŋgàa loho ntu' wèŋ tsərə ŋgògʉ̀ bə̀boŋ bə ŋkərə̀ nə̀ co bʉ̀ʉ sə̀ wo kə̀kʉrə̀ mʉ lisə̀ Nwì wèeŋ tsərəgə̀ə. Yà'a mvə̀'nə̀ yi gʉ fʉhʉ noŋsə fa Tà Nwì bʉ̀ʉ ye wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ànə geŋ, Sàkàriyà fek masinjà Nwì nə dʉk də, <<Aco mʉ̀ dzəm ncèp ènə yè'sə va? Bʉsə̀ ves ŋgwe am a rèŋ wes ba fo' laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Masinjà Nwì nə dʉk fa Sàkàriyà də, <<A mʉ̀ʉ Gabriyà nə̀ mʉ təəŋgə̀ mantombìi Tà Nwì. Tà Nwì tum mʉ yi, də mʉ və, nə tsok fa wu ntirə̀ nə̀ bə̀boŋ ènə. ");
INSERT INTO yam_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nə ye də, cùu nə loho wu, wù kà cèp to, tè kə wɛs mvə̀k nə̀ Àlisabèe nə dzə mo ànə, bʉ̀ʉsə̀ mʉ̀ tsə̀' wu ntirə̀ nə̀ Tà Nwì nə fana wù kà nà' də a vɛ'nə zìnə dzəm, ŋga yà'a nə ye vɛ'nə ŋga mvə̀k nə dzèeŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mvə̀'nə̀ masinjà Nwì ànə sə tsok fa Sàkàriyà ntirə̀ ènə fana bwìŋ sə tək yi sə ntòmbi, nə sə mərə də yi ka nə̀nàk tesə və bʉ̀ʉ yà lɛ. ");
INSERT INTO yam_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yi ànə tesə və fana yi kà bohòbwìŋ mok cèp to fe'lə̀. Fana wo riŋ də Nwì nì tsə̀' fa yi yumok mʉmvwe' ndap ye nə̀ ghaŋ nə laŋ. Mvə̀'nə̀ yi ànə sə ka cù mok cep to fana yi də yi cep yumok, yi sə ni megu mok bo. ");
INSERT INTO yam_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yi ànə gʉ wes fàha ye mʉmvwe' ndap Nwì nə̀ ghaŋ nə fana yi bwi foho lo nda'à yi. ");
INSERT INTO yam_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ànə ca megu mvə̀k momjo fana ŋgwe ye Àlisabè nə zʉʉŋ, nə sə cum swihi megu mok mʉ nda'à tə̀tè ŋwʉ tàŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Àlisabè nə sə dʉk də, <<Mvə̀k kʉ̀rə, fana Tà Nwì nə tɛsə̀ nə mʉ, nə jəŋ fis gɛsə lo marè'tu àm nə̀ mʉ̀ tse'gə̀ mʉtsətsə'rə bwìŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Bum yè'sə ànə ye ŋga zʉm Àlisabèe ŋwʉ ntùŋfu, fana Nwì tumsə masinjà ye Gabriyà mvwe' mʉntòlak mòk mvwe' nzeŋgòGalìli nə̀ wo togə̀ fo' də Nazàrɛ. ");
INSERT INTO yam_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Də nà'a kə tsok fa mʉwà'ŋgwɛ̀ŋ nə̀ nà'a nə ye ŋgwe Jòsep nà'a yumok. Jòsep nə à ye njàŋ bə ŋgwì bʉ̀ ŋkum Devìd. Liŋ wà'ŋgwɛ̀ŋ nə à ye də Mèri. ");
INSERT INTO yam_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Masinjà Nwì nə à və̀ bohòmo ŋwà nə, nə cepsə nà' dʉk də, <<Fifi ye bohòwù. Tà Nwì cu wèŋ nə, yi nə se wu ŋkʉ̀ʉŋntɛ̀ŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ntʉm à tesə bisə Mèri vɛ'ɛ pwe'. Yi tsərə dʉk də ncèp ènə yè'sə dalɛ. ");
INSERT INTO yam_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Masinjà Nwì nə dʉk fa fe'lə yi də, <<Mèri, kà də wu wəp dʉk, Nwì a ye bə̀boŋ bohòwù ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yeè, wu nə zʉʉŋ, nə dzə mo ŋwə̀mbam. Wo nə to liŋ ye də Jisòs. ");
INSERT INTO yam_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yi nə ye ŋwə̀ nə̀ ghaŋ, fana liŋ ye nə ye də Nwì nə̀ ghaŋ. Tà Nwìi nə gʉ yi kok gaŋ tàcici ye Devìd. ");
INSERT INTO yam_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Fana yi nə ye ŋkum bʉ̀ʉ Jàkop, sə̀ wo sə̀' bʉ̀ʉ Izùrɛ wèŋ wo. Dzə̀' ŋkum ye nə, nə kà kə̀ lə̀ yuk.>> ");
INSERT INTO yam_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mèri fek masinjà Nwì nə dʉk də, <<Mʉ nə zʉʉŋ yè'sə va, ŋga mʉ̀ ka ŋwə̀mbam rì nɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Masinjà nə dʉk fa Mèri də, <<Yòŋsə̀ nə̀ Rərɛŋ nə və bohòwù, fana ŋàaŋ sə̀ Nwì nə̀ ghaŋ nə nə ye bohòwù. Ye də wo nə to mo nə̀ rərɛŋ nè'nə də, mo Nwì. ");
INSERT INTO yam_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tsərə na yòo mo tɛ̀' yo Àlisabè, nə̀ wo togə̀ yi də yi nzeŋ. Yi tse' zʉm ŋga'a ŋwʉ ntùŋfu, ŋga yi a rèeŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bʉsə̀ yusə̀ co Nwì kà gʉ̀ too bʉ̀ə̀.>> ");
INSERT INTO yam_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mèri dʉk də, <<Yumok ka bʉp. Mʉ yè'sə mo fàk Tà Nwì. Nwìi gʉ bohòmʉ̀ mvəsə̀ wù dʉk yà'sə.>> Fana masinjà Nwì nə me'rə Mèri, nə lo. ");
INSERT INTO yam_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A cu momjo fana Mèri fʉhʉ, nə lokok lo nə̀nàk mvwe' lak mok sə̀ yà'a mvwe' nzeŋgòŋ Jùdiyà, nə̀ a fo' bə nda wùriŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","À kə̀ dzèŋ fo' fana yi lo mʉmvwe' ndap Sàkàriyà, nə kə cepsə Àlisabè. ");
INSERT INTO yam_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mèri ànə cepsə Àlisabè nə fana mo nə̀ ndzə və̀ə Àlisabè nə gì tsoho nja. Mo nə à tsoho vɛ'nə fana Àlisabè nə rwiŋ bə Yòŋsə̀ nə̀ Rərɛŋ nə ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Yi cep fa Mèri bə ŋàŋ də, <<Mèri, wu yè'e ŋwà nə̀ Tà Nwì a sè wu mʉtsətsə'rə bə̀ba pwe'. Yi nə se mo nə̀ ndzə və̀ə wù ànə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yi dʉk mali mok sə̀' də, <<Nè'nə yè'sə nsàp yu yà, nə̀ də ma Tà Nwì àm və̀ ŋgòkɛ' yə mʉ ɛ? ");
INSERT INTO yam_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mèri, mvə̀'nə̀ wù cèpsə mʉ fana mo nə̀ ndzə və̀ə mʉ̀ nə tsoho bə kwəkwa. ");
INSERT INTO yam_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nə ye də a rɛŋsi bohòwù bʉ̀ʉsə̀ wù a dzəm də ntirə̀ nə̀ Tà Nwì à tsə̀' fa wu nə, nə ye zìnə.>> ");
INSERT INTO yam_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mèri yəm fəsə fa nà' ndzənə ŋkì də, <<Ntʉm am sə kuksə Tà Nwì ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mʉ̀ sə kwa, bʉ̀ʉsə̀ yi a lùŋsə mʉ. ");
INSERT INTO yam_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nwì a ka mʉ swi, nə tsəm tse' mʉ ŋgà fàk ye nə̀ jo, Fana ye jəŋ ŋga'a bwìŋ pwe' nə sə to mʉ də, ŋgà rɛŋsi. ");
INSERT INTO yam_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","A vɛ'nə bʉ̀ʉ bum maŋgəŋgèeŋ sə̀ Tà Nwì nə̀ ghaŋ nə a gʉ̀ bohòmʉ̀. Fana mʉ̀ sə dʉk də, liŋ yee ye rərɛŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yi koksəgə̀ manziŋ bohòbʉ̀ʉ sə̀ wo wəpgə̀ yi, nə ye bə ŋgwì bʉ̀ awo pwe'. ");
INSERT INTO yam_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nwì a sà bo ye sə̀ yà' tse' ŋàŋ, nə bɛ' samsə bʉ̀ ŋgàa nɛ̀ ni' wèŋ bə bum awo sə̀ wo sə tsəm də wo nə gʉ. ");
INSERT INTO yam_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yi a susə ŋkəŋkum sə̀ ghaŋ mʉmvwe' kapràak awo, nə te' lokoksə bʉ̀ʉ sə̀ wo jəgə̀ ni' àwo sə nze. ");
INSERT INTO yam_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yi a fa bʉ̀ʉ sə̀ njè sə ya wo bum sə̀ bə̀boŋ wùriŋ, nə jum gɛsə lo ŋgàa ghàk wèŋ botu. ");
INSERT INTO yam_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yi a nəmsə yusə̀ yi à kà' bohòtàcicii avès wèŋ, nə tɛsə ŋgàa fàak ye sə̀ wo bʉ̀ʉ Izùrɛ. ");
INSERT INTO yam_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yi à sə nìtsə̀' kosə̀manziŋ ye bohòAbràham, nə ye bohòŋgwì bʉ̀ ye sə̀' nə̀ mvèsə̀.>> ");
INSERT INTO yam_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mèri à cu bə Àlisabè co ŋwʉ tɛ', fana yi bwi foho lo la'à yi. ");
INSERT INTO yam_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mvə̀k ànə kʉrə bohòÀlisabè ŋgòdzə fana yi dzə mombam. ");
INSERT INTO yam_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ŋge' ye bə njə̀njàaŋ ye wèŋ à yuk mvə̀'nə̀ Tà Nwì à gʉ̀ yi bə̀boŋ fana wo kwa yàwo sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mo nə ànə dzeŋ ntɛŋ mò'fis fana wo jəŋ və yi ŋgòkom fa yi tu mbəmbam. Wo də wo nə to fa mo nə liŋ tɛ̀' ye də Sàkàriyà. ");
INSERT INTO yam_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma ye kà vɛ'nə dzəm, nə dʉk də, <<Liŋ mo nə də Jon.>> ");
INSERT INTO yam_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wo dʉk fa yi də, <<Hàva', liŋ njàŋ yòmòk ka vɛ'nə yeŋ yuk.>> ");
INSERT INTO yam_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ànə geŋ, wo gʉ bo ŋgòfek tɛ̀' ye də nà' dzəm də liŋ mo nə nə ye də ndà lɛ. ");
INSERT INTO yam_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sàkàriyà dʉk də wo fa yi ŋwàk. Fana yi com nja də, <<Liŋ mo nə Jon.>> Wo à mərə wes pwe'. ");
INSERT INTO yam_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ye jəŋ sə̀ ghà nà'nə, fana Sàkàriyà ye ŋgòcèp fe'lə cù sə̀mok, nə sə kwasə Nwì. ");
INSERT INTO yam_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wʉə à ko ŋge' ye wèŋ pwe', fana bʉ̀ʉ sə̀ wo à cu mvwe' nda sə̀ mvwe' nzeŋgòŋ Jùdiyà pwe' à yuk bum yè'sə. ");
INSERT INTO yam_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ndàaŋwè pwe' nə̀ yi yuk bum yè'sə à sə tsərə, nə sə muu və̀m də, <<Mo ènə nə ye nsàp ŋwə̀ nə̀ fòlɛ?>> Yà' à sə yəəŋ jəja də, ŋàaŋ Tà Nwìi bohòmo ènə. ");
INSERT INTO yam_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sàkàriyà tɛ̀'ɛ Jon à rwiŋ bə Yòŋsə̀ nə̀ Rərɛŋ nə fana yi cep yusə̀ Nwì fa yi də yi cep. Yi à cèp də, ");
INSERT INTO yam_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","<<Vesùwèeŋ kwasə Tà nə̀ yi Nwì bʉ̀ʉ Izùrɛ wèŋ. Yi a və̀ ŋgòtɛsə bʉ̀ʉ ye wèŋ, nə fiŋ me'rə fis wo sənə ŋgə'. ");
INSERT INTO yam_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yi a fa vesùwèŋ ŋgà gèm bwìŋ nə̀ ghaŋ nə̀ yi ŋgwì bʉ̀ ŋgà fàk ye Devìd. ");
INSERT INTO yam_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yi ànə cep yè'sə taaŋ ntɛ̀ŋ mʉ cùhù ŋgàa tsòhòbum ye sə̀ wo bʉ̀ʉ sə̀ rərɛŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yi à kàk də yi nə fis ves bohòbʉ̀ʉ sə̀ wo bɛ̀ŋgə̀ ves, nə kak də yi nə fis ves ndzə bohòbʉ̀ʉ sə̀ wo dzèeŋgə̀ vesùwèŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yi à kàk fa tàcici avès wèŋ də yi nə koksə manziŋ bohòwo, fana yi noŋsə rʉ̀k ye nə̀ rərɛŋ nə̀ yi à zʉ nə. ");
INSERT INTO yam_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Yi à kɛ̀ŋ bohòTàcici àvès Abràham gʉgʉŋ dʉk də yi nə fis vesùwèŋ ndzə bohòbʉ̀ʉ sə̀ wo bɛ̀ŋgə̀ vesùwèŋ, ya vesùwèeŋ kuksə yi nə kà wəp, ");
INSERT INTO yam_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nə sə fak bohòyi bə ntʉm nə̀ rərɛŋ nə ye kə̀kʉrə̀ mʉ lisə̀ yi nùumbu pwe' sə̀ a cu. ");
INSERT INTO yam_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wù mo àm, wo nə to wu də ŋgà tsòhòbum Nwì nə̀ yi Nwì nə̀ ghaŋ nə. Wu nə sə lo mantombìi Tà ŋgògʉ̀ tsə'rə fa yi mandzə̀ ye nə. ");
INSERT INTO yam_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wu nə tsoho fa bʉ̀ʉ ye wèŋ də yi nə swifa wo bʉp awo, ya ŋga wo nə tse' lùŋ. ");
INSERT INTO yam_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bʉsə̀ Nwì àvèes ŋgà koksə̀manziŋ nə ye ntʉm fə̀fwèŋ. Yi nə gʉ ves ŋgòyə lù nə̀ nje nə ŋga nà' to tsə və̀ mʉ ni'ì vès co nùm, ");
INSERT INTO yam_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nə rɛŋ tsoŋ mʉ tuhù bʉ̀ʉ sə̀ wo cu mvwe' tsə̀tsèŋ kpʉ, ŋga yi sə gʉ̀msə kɛ' ves mvwe' mandzə̀ nə̀ nà' tse' fifi.>> ");
INSERT INTO yam_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mo nə à kuk, nə sə gʉŋ bə ŋgùpni' nə ye bə yòŋsə̀. Yi à sə cugə̀ ŋgəà. Yi à cu mvwe' ànə tə̀tè kə wɛs nùmbu nə̀ yi kʉ̀rə ŋgòtesə və̀ jəja bohòbʉ̀ʉ Izùrɛ wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mvə̀k ànə à ye ŋga ŋkum Kaisà Àgostònə̀ mvwe' nze Rumà dʉk də wo taŋ bʉ̀ʉ ye pwe'. ");
INSERT INTO yam_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mvə̀'nə̀ wo à ta yèto bwìŋ vɛ'nə yè'sə, à ye ŋga govənònə̀ mvwe' nze Sìriyà à ye Kwìrinòs. ");
INSERT INTO yam_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A ye vɛ'nə, fana ndàaŋwè pwe' sə lo ŋgòkə̀ còm liŋ ye mvwe' lak ye sə̀ yi à tesə fo'. ");
INSERT INTO yam_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jòsep à ye'e mè'rə ye lak Nazàrɛ mvwe' nzeŋgòŋ Galìli, ŋgòlòJùdiyà mvwe' buk lak Betèrèhem, mvwe' sə̀ wo à dzə ŋkum Devìd. Jòsep à sə lòfo' bʉ̀ʉsə̀ yi à ye njàŋ bə ŋgwì bʉ̀ ŋkum Devìd nə. ");
INSERT INTO yam_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yi à lòbə Mèri nə̀ yi à sak nà' gù, də bə nà'a kə com liŋ awo. À ye ŋga Mèri nə bə zʉm. ");
INSERT INTO yam_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","À kə̀ dzèŋ fo', fana mvə̀k kʉrə bohòMèri ŋgòdzə. ");
INSERT INTO yam_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mèri dzə mo ŋgwɛ̀ŋ ye, mo ŋwə̀mbam. Yi lim gesə nà' ndzənə cə̀k, nə noŋsə nà' sənə ŋgwes nə̀ wo fagə̀ nàamŋgòŋ wèŋ zʉzʉ ca. Bʉsə̀ mvwe' nòoŋ à ka bohòwo mʉmvwe' ndap nə̀ ŋkʉ̀ìŋ wèeŋ kə nòoŋgə̀ mbwa nə yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ganakùu' mok wèŋ à ye mvwe' lak yà'sə, sə̀ wo à cu nòoŋ ŋgòkʉ̀k nsùŋgaaŋ awo nə̀ ndzəmə̀. ");
INSERT INTO yam_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mvəsə̀ wo à cu fo' fana masinjà Tà Nwì kurə tesə və bohòwo, marɛŋ Tà Nwì nə rɛŋ mvwe' sə̀ wo à ye sə nə̀bʉp. Wo a yə vɛ'nə, wʉə ko wo wùriŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Masinjà Nwì nə dʉk fa wo dʉk də, <<Yeè, wèeŋ kà wəp. Mʉ̀ jə və̀ fa weŋ yè'sə Ntirə̀ nə̀ Bə̀boŋ nə̀ nà'a ye bohòndàaŋwè pwe'fo'. Ntirə̀ nə nà' tse' kwəkwa wùriŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bʉsə̀ nùmbu nə̀ ntinə ènə, wo dzə ŋgà lùŋsə̀ bwìŋ àwèŋ mvwe' lak Devìd. A yi nə̀ yi Ŋkum ŋgà gèm bwìŋ nə ye Tà sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wèeŋ nə kə ye ŋga wo lim mo nəmòk bə cə̀k, nə noŋsə yi sənə ŋgwes, fana wèŋ riŋ də nà'a yi.>> ");
INSERT INTO yam_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wo ànə geŋ də wo kʉk à, wo ye masinjàa Nwì vɛ'ɛ nduk, ŋga wo sə yəm kùksə liŋ Nwì bə ŋkì. ");
INSERT INTO yam_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Wo sə dʉk də, <<Kə̀kùksə̀ə ye bohòNwì nə̀ yi cu mvwe' sə̀ ghaŋ mʉ ntòbu. Fifi ye sə nzeŋgòŋ bohòbʉ̀ʉ sə̀ yi dzəm yà'wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Masinjàa Nwì sə à lògɛsə lòmʉbu. Fana ganakùu' sə wèŋ dʉk də, <<A bə̀boŋ də vesùwèeŋ lo-ɛ mvwe' lak Betèrèhem anə ɛ̀, nə kə ja'a na yusə̀ yà'a fo', sə̀ Tà Nwì tsə̀' fa ves yè'sə.>> ");
INSERT INTO yam_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wo à lòvɛ'ɛ nə̀nàk. À kə̀ dzèeŋ, wo ye Mèri bə Jòsep nə ye mo nə ŋga yi nòsə ŋgwesə̀. ");
INSERT INTO yam_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ganakuu' sə à yə nà' fana wo ye ŋga'a ŋgòtsòho fa bwìŋ yusə̀ wo anə yuk bə liŋ mo nə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bʉ̀ʉ sə̀ wo ànə yuk yusə̀ ganakùu' sə à tsə̀'ə sə à mərə wes pwe' nə̀ pwe'. ");
INSERT INTO yam_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mèri à ko nòŋsə bum yè'sə pwe'fo' sə və̀ə yi, nə sə tsərə bə zeŋ ghà yà lòoŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ganakùu' sə à bwìŋ foho lòo, wo sə kwasə, nə sə kuksə lo liŋ Nwì, bʉ̀ʉ yusə̀ wo yuk nə ye sə. Yà' ànə ye megu sə̀' mʉmvə̀'nə̀ masinjà Nwì anə tsok wo sə. ");
INSERT INTO yam_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","À kə̀ dzèŋ ntɛŋ mò'fis, mvə̀k kʉ̀rə də wo kom fa mo nə tu fana wo to fa yi liŋ də Jisòs. Yè'sə liŋ sə̀ masinjà Nwì ànə to fa yi yà' ŋga wo ka yi ntòzʉʉŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mvə̀k à kʉrə bohòMèri bə Jòsep də wo gʉ yusə̀ lʉ̀ʉk Musì sə dʉk, ya ŋga wo ye yàwo mok sə̀' rərɛŋ. Anə geŋ, wo jə lo mo nə mvwe' lak Jòrosalèm ŋgòkə̀ nì fa yi bohòTà Nwì. ");
INSERT INTO yam_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Wo ànə com noŋsə ndzənə ŋwàk lʉ̀k Tà Nwì dʉk də, <<Wo nə cok noŋsə fa Tà mo tu nə̀ yi ŋwə̀mbam.>> ");
INSERT INTO yam_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wo à lòŋgòfa satikà' nə̀ lʉ̀ʉk Tà Nwì sə dʉk vɛ'nə. Yà'a yè'sə də, <<Wo fa kəkəbʉ̀ŋ kè nsàp swi mòk co kəkəbʉ̀ŋ nà'a ba.>> ");
INSERT INTO yam_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ŋwə̀ nəmòk ànə ye mvwe' lak Jòrosalèm anə nə̀ liŋ ye à ye də Saimʉ̀. Yi à ye ŋwə̀ nə̀ yi kə̀kʉrə̀ mʉ lisə̀ Nwì, nə fa ntʉm ye bohòNwì pwe' nə̀ pwe'. Yi à sə tək ŋgòyə ghà nə̀ Nwìi nə mesə fa bʉ̀ʉ Izùrɛ wèŋ ŋgə' àwo, fana Yòŋsə̀ nə̀ Rərɛŋ sə ye bohòyi sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yòŋsə̀ nə̀ Rərɛŋ nə ànə tsok fa yi də, yi nə kà ntòkpʉ tè yi ye Ŋkum ŋgà gèm bwìŋ nə̀ Tà Nwì ànə kak də yi nə tum vesə nə. ");
INSERT INTO yam_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yòŋsə̀ nə ànə gʉ Saimʉ̀, fana yi lokok lo mʉmvwe' ndap Nwì nə̀ ghaŋ nə. Mvə̀'nə̀ ma bə tɛ̀'ɛ mo nə à jə və̀ Jisòs mʉmvwe' ndap Nwì nə̀ ghaŋ ŋgògʉ̀ yusə̀ lʉ̀k sə dʉk, ");
INSERT INTO yam_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","fana Saimʉ̀ kə le' tse' mo nə ndzə bohòyi, nə kwasə Nwì. ");
INSERT INTO yam_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Yi à cèp də, <<Tà, wù a gʉ̀ yusə̀ wù à cèep fana me'rə a mofàk yoo lo gɛsə bə fifi. ");
INSERT INTO yam_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Bʉsə̀ nə̀ ŋga'a nè'e mʉ̀ yə lù nə̀ njònə laŋ, ");
INSERT INTO yam_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nə̀ wù à fʉ̀hʉ nòŋsə nà' mantombìi bwìŋ pwe' nə. ");
INSERT INTO yam_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nà'a marɛŋ nə̀ ŋgònì fa bʉ̀ lakmvum wèŋ mandzə̀ nə̀ njònə, Nə ye ŋgògʉ̀ ya bwìiŋ wəp bʉ̀ʉ Izùrɛ wèŋ co bʉ̀ʉ sə̀ bwìŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bum sə̀ Saimʉ̀ à cèp sə yà' à gʉ̀ ma mo nə bə tɛ̀'ɛ mo nə wo mərə wùriŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Anə geŋ Saimʉ̀ sè wo, nə dʉk fa Mèri dʉk də, <<Nwì a cok fis mo ènə ŋgògʉ̀ bʉ̀ʉ Izùrɛ wèŋ ŋkʉ̀ʉŋ də wo gbʉ̀, mok lokok. Yi nə ye co yumòk nə̀ ŋgònìtsə̀' bwìŋ mʉmvə̀'nə̀ Nwìi fagə̀ bwìŋ lùŋ. Megu də bwìiŋ nə sə cep bʉp bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Fana tsətsərə̀ə sə̀ yà' cu swìhi sə ntʉʉ̀ bwìŋ ŋkʉ̀ʉŋ nə tesə və jəja. Ntʉm yòo nə yaaŋ co ŋwè sòp nà' bə fèk bʉ̀ʉ mo nə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ŋwà nəmòk ànə ye nə̀ liŋ ye à ye də Àna. Yi ye ŋgà tsòhòbum Nwì. Liŋ tɛ̀' ye à ye də Fanuel. Liŋ bòp lak àwo à ye də Asè. Yi à ye ŋwà nə̀ yi à rèŋ wùriŋ ŋga yi à cu bə ndu ye lùumŋgòŋ sàmba. ");
INSERT INTO yam_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yi à cu co ŋwà ŋgwemfə lùumŋgòŋ hum fwame'-ncòp-kwè. Yi kà ndap Nwì nə̀ ghaŋ nə me'rə yuk. Yi sə dzə̀ zʉzʉ, nə sə lɛŋ pìriyà, nə sə kuksə Nwì nùm bə ndzəm. ");
INSERT INTO yam_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yi à və̀ fo' sə̀ ghà nà'nə, nə kwasə Nwì. Yi sə cep bə nzak mo ènə bohòbʉ̀ʉ sə̀ wo à sə tək ŋgòyə də Nwìi nə fiŋ me'rə bʉ̀ʉ Jòrosalèm yà'a. ");
INSERT INTO yam_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mʉmvə̀'nə̀ wo ànə gʉ wɛs bum sə̀ lʉ̀ʉk Tà Nwì sə dzəm fana wo bwi foho lo mvwe' nzeŋgòŋ Galìli, nə̀ lak awo à ye fo', wo to yà' də Nazàrɛ. ");
INSERT INTO yam_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mo nə à kùk, nə tse' ŋàŋ. Yi à tse' ŋkərə̀, fana Nwì sə sè yi sə̀' wùriŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jòsep bə Mèri à sə cugə̀ mvwe' lak Nazàrɛ anə fana wo sə loho Jòrosalèm lùm bə lùm. Wo à sə lòŋgòkə̀ zʉ ŋkà'a pasobà. ");
INSERT INTO yam_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisòs à dzèŋ lùumŋgòŋ hum-ncòp-ba fana yi yuŋ Mèri bə Jòsep, wo lo mvwe' ŋkàk nə sə̀mok. ");
INSERT INTO yam_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nùmbu ŋkàk nə à càa fana, wo ye ŋgòbwì foho lòla'à wo. Jisòs cum mam ye Jòrosalèm anə. Fana tɛ̀' ye bə ma ye kà bə zeŋ rì. ");
INSERT INTO yam_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wo à sə tsəm yàwo də Jisòos mʉŋgorə̀ bʉ̀ʉ sə̀ wo sə bwì lòo sə. Fana wo gi yiskok tə̀tè nùm co. Wo ye ŋga'a ŋgòlàp yi mʉŋgorə̀ njə̀njàaŋ awo bə ŋge' awo wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wo kà yi yə, fana wo bwi foho lo Jòrosalèm anə ŋgòlàp yi. ");
INSERT INTO yam_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wo lap yi tə̀tè nùmbu nə̀ tɛ' à ye fana wo ye yi ŋga yi cu mʉ ndap Nwì nə̀ ghaŋ nə. A ye ŋga yi cu mʉtsətsə'rə̀ə cicàa bʉ̀ʉ Jus wèŋ. Yi sə yu'rə yusə̀ wo sə cèp sə, nə sə fek yà'wèŋ bum ye sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bʉ̀ʉ sə̀ wo à yuk yusə̀ yi sə cèp sə à mərə wes pwe' bə nsàp ŋkərə̀ nə̀ yi à tse' ŋgòcèp bʉ̀sə fa bʉ̀ʉ sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jòsep bə Mèri à yə yi fana wo mərə wùriŋ. Fana Mèri fek yi də, <<Mo àm, wu gʉ ves yè'e yà vɛ'nə ɛ? Ves tɛ̀' yo lap wu tə̀tè ntʉm tesə lòbisə ves pwe'.>> ");
INSERT INTO yam_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jisòs fek yà'wèŋ də, <<Wèŋ nə sə lap mʉ də yà? Wèŋ nə ka riŋ də mʉ tse' ŋgòcu mʉmvwe' ndap Tɛ̀' am riŋ à?>> ");
INSERT INTO yam_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wo kà ncèp nə̀ yi cèp fa wo nà'nə rɛɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Anə geŋ bə Jisòs wèŋ bwi foho lo Nazàrɛ anə, yi sə yuk dʉk awo. Ma ye à ko nə̀msə bum yè'sə pwe' sə ntʉʉ̀ yi. ");
INSERT INTO yam_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisòs à sə kuk bə ni' nə ye bə ŋkərə̀. Bwìŋ à sə dzəm yi, Nwì dzəm yi sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Bum yè'e à ye ŋga Tìberiyùu ŋkum mvwe' nze Rumà yi lùumŋgòŋ hum-ncòp-tàŋ. Poŋtiyòs Palè ye ye govənòmvwe' nze Jùdiyà, fana Heròye ye ŋgà sak nze Galìli. Moma Herònə̀ liŋ yee Filìp à sə sak ye nze Ìturiyà bə Tràkònitì. Lìsaniyà à sə sak ye nze Abilin. ");
INSERT INTO yam_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anàs bə Kayofàs à ye yàwo ŋkum ŋgàa fa satikà' wèŋ. Ànə geŋ Nwì cèp bohòJon mo Sàkàriyà ŋga yi cu ŋgəà. ");
INSERT INTO yam_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon ànə yuk fana yi lokok nə gi kɛ' mvwe' lak sə̀ yà' kʉəp ŋgʉ ndzəp Jòridàŋ yà'a. Yi à sə tsòho fa bwìŋ dʉk də, <<Wèeŋ kupsə, nə bwi fa bʉp awèŋ ŋkwɛ̀ŋ, nə baptɛsə, ya Nwìi swi fa weŋ bʉp awèŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ìzayà ŋgà tsòhòbum Nwì ànə com bum yè'sə ndzənə ŋwàk ye də, <<Ŋgì ŋwə̀ nəmòk sə cèp torə və̀ sə ŋgəà, nə sə yuhu də, <Gʉ tsə'rə fa Tà Nwì mandzə̀ ye, rəŋsə tsə'rə fa yi bwe cwèe mandzə̀ ŋgògì cà ca.> >> ");
INSERT INTO yam_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wo rwisə tsə'rə ntòŋ pwe', nə fak laŋsə tsə'rə nda sə̀' pwe'. Gʉ mandzə̀ə sə̀ yà'a gəgorə̀ pwe' yà'a ye rərəŋ, nə laŋsə cwèe mandzə̀ə sə̀ yà' ka làaŋ yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Fana bwìŋ pwe'fo' nə ye lù nə̀ Nwìi nə fa bwìŋ. ");
INSERT INTO yam_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mandzə̀ ànə loho vɛ'ɛ bə bʉ̀ʉ sə̀ wo ànə sə və də Jon bàptɛsə wo. Fana Jon dʉk fa wo də, <<Wèŋ ŋgwì bʉ̀ no, tsə̀' weŋ ŋga'a ndà də wèeŋ caŋ, nə swirə ŋgə' nə̀ Nwìi nə̀ fa bwìŋ nə ɛ? ");
INSERT INTO yam_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wèeŋ gʉ yusə̀ aco yà' ni tsok də wèŋ bwì fa bʉp awèŋ ŋkwɛ̀ŋ laŋ. Wèeŋ kà də wèeŋ sə tsərə də aco wèŋ swirə ŋga wèŋ sə dʉhʉ na də, <Tàcici àvès à ye Abràham> dʉk. Bʉsə̀ mʉ tsok fa weŋ də, aco Nwì jəŋ lìis yè'e, nə gʉ fa Abràham bwe bə zeŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yuk-a. Njàm nə nòsə kʉ̀k ŋgògwɛ̀' màk tʉ sə mbwè. Tʉ nə̀ fòpwe' nə̀ nà' ka-a nto'o sə̀ bə̀boŋ zəm, wo gwɛ' mak nà' sə nze, nə te' tɛŋ gesə nà' sə misə̀.>> ");
INSERT INTO yam_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bʉ̀ʉ sə̀ wo ànə yuk ncèp ènə fek yi dʉk də, <<Aco vès gʉ ŋga'a yè'sə va?>> ");
INSERT INTO yam_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon tsok fa wo də, <<Ŋwə̀ nə̀ wù tse' cə̀ək nini ba, wù fa ŋwə̀ nə̀ yi ka mò'fis tse' mòk. Ŋwə̀ nə̀ wù tse' zʉzʉ, wù gapsə weŋ ŋwə̀ nə̀ yi ka tse'.>> ");
INSERT INTO yam_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bʉ̀ʉ sə̀ wo à ye ŋgàa ko mbàam tas mok à və̀, dʉk də Jon bàptɛsə wo. Wo fek Jon nə də, <<Cicà, vèes gʉ va?>> ");
INSERT INTO yam_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yi tsok fa yà'wèŋ də, <<Kà də wèeŋ jəŋ casə fe'lə mbàam ŋwə̀ nəmòk bə mfìp dʉk.>> ");
INSERT INTO yam_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sojàa mok wèŋ à və̀ə, nə fek yi sə̀' dʉk də, <<Vès yàvès ɛ? Vèes nə gʉ va?>> Jon tsok fa yà'wèŋ dʉk də, <<Kà mbàm ŋwə̀ nəmòk bə ŋàŋ fep jə, nə kà ŋwə̀ nəmòk wà na'tse'. Mbàam ŋwʉ àwèeŋ kə̀kʉrə̀ bohòwèŋ>> ");
INSERT INTO yam_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bwìŋ ànə sə kʉk Ŋkum ŋgà gèm bwìŋ nə̀ Nwì à kàk də yi nə tum nə, fana wo à yə Jon, wo ye ŋgòtsərə də kàmòk a yi nə àlɛ. ");
INSERT INTO yam_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yi dʉk fa yà'wèŋ dʉk də, <<Mʉ̀ sə baptɛsə mègù weŋ yàm bə ndzəp, nə yeè nə də, ŋwə̀ nəmòk nə̀ yi yam càsə mʉ nə və, nə̀ mʉ̀ ka kə̀kʉrə̀ ŋgòfìrə fa yi kùuŋgùup ye yeŋ. Yi nə baptɛsə weŋ bə Yòŋsə̀ nə̀ Rərɛŋ, nə ye bə mis. ");
INSERT INTO yam_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yi tse' wàam nzaŋ ye ndzə bohòyi ŋgòcìs nzaŋ bə zeŋ. Yi nə cis wes nzaŋ sə, nə nəmsə yà' mʉ tapə, nə tɛŋ dzə̀dzə̀ə sə sə mvwe' mis nə̀ nà'a kà liìgə̀.>> ");
INSERT INTO yam_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon à sə tip kɛ' bwìŋ bə mandzə̀ zəzok mʉmvə̀'nə̀ yi sə tsòho fa wo Ntirə̀ nə̀ Bə̀boŋ nə. ");
INSERT INTO yam_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yi à cèp bohòŋkum Heròsə̀' də nà' gʉ̀ bʉp wùriŋ bʉ̀ʉsə̀ nà' ànə jəŋ Hèrodiyà nə̀ yi à ye ŋgwe moma ye Filìp. Herònə à gʉ̀ bum mok sə̀ yà' à bʉp sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yi ànə gʉ fe'lə yumòk nə̀ nà' bʉp càsə cù sə̀'. Yu nə̀ yi ànə gʉ nə, à ye də yi à ko lok Jon mʉ ndapndzəmə̀. ");
INSERT INTO yam_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","À ye ŋga Jon bàptɛsə mè bwìŋ pwe', fana Jisòs və, Jon baptɛsə yi sə̀'. Jisòs ànə sə gʉ pìriyà fana ntòbu muhu to. ");
INSERT INTO yam_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Fana Yòŋsə̀ nə̀ Rərɛŋ tsoŋ mʉbu co kəkəbʉ̀ŋ. Nwì cep vesə mʉbu dʉk də, <<Wù mo àm nə̀ mʉ̀ dzəm wu sə ntʉʉ̀ mʉ̀. Mʉ̀ kwa bohòwù wùriŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisòs à yèto fàak ye ŋga yi co lùumŋgòŋ hum tɛ'. Tàcicii ye à ye mʉmvə̀' nè'e. ");
INSERT INTO yam_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","38","Adàm nə ye mo Nwì. Sɛt ye mo Adàm. Enos ye mo Sɛt. Kàyinàn ye mo Enos. Màhalalì ye mo Kàyinàn. Jarè ye mo Màhalalì. Enòk ye mo Jarè. Mɛ̀tuselà ye mo Enòk. Lamɛ̀k ye mo Mɛ̀tuselà. Nuà ye mo Lamɛ̀k. Shem ye mo Nuà. Àrfasà ye mo Shem. Kàyinàn ye mo Àrfasà. Shelà ye mo Kàyinàn. Ebà ye mo Shelà. Pelɛ̀k ye mo Ebà. Ru ye mo Pelɛ̀k. Serù ye mo Ru. Nahòye mo Serù. Terà ye mo Nahò. Abràham ye mo Terà. Azìk ye mo Abràham. Jàkop ye mo Azìk. Judà ye mo Jàkop. Perè ye mo Judà. Hɛsròŋ ye mo Perè. Arnì ye mo Hɛsròŋ. Adimìn ye mo Arnì. Àminadàp ye mo Adimìn. Nasòŋ ye mo Àminadàp. Samòŋ ye mo Nasòŋ. Bowàs ye mo Samòŋ. Obè ye mo Bowàs. Jesì ye mo Obè. Devìd ye mo Jesì. Natàŋ ye mo Devìd. Matatà ye mo Natàŋ. Menà ye mo Matatà. Meleyà ye mo Menà. Èliyakìm ye mo Meleyà. Jonàm ye mo Èliyakìm. Jòsep ye mo Jonàm. Judà ye mo Jòsep. Simiyòŋ ye mo Judà. Levì ye mo Simiyòŋ. Màtat ye mo Levì. Jorìm ye mo Màtat. Èlìyezè ye mo Jorìm. Josuwà ye mo Èlìyezè. Er ye mo Josuwà. Èlmadàm ye mo Er. Kosàm ye mo Èlmadàm. Adì ye mo Kasàm. Melkì ye mo Adì. Nerì ye mo Melkì. Shèyatiyè ye mo Nerì. Zèrubabè ye mo Shèyatiyè. Resà ye mo Zèrubabè. Joanàŋ ye mo Resà. Jodà ye mo Joanàŋ. Josèk ye mo Jodà. Semèŋ ye mo Josèk. Màtàtiyà ye mo Semèŋ. Maàt ye mo Màtàtiyà. Nagè ye mo Maàt. Eslì ye mo Nagè. Nahùm ye mo Eslì. Emòs ye mo Nahùm. Màtàtiyà ye mo Emòs. Jòsep ye mo Màtàtiyà. Janè ye mo Jòsep. Melkì ye mo Janè. Levì ye mo Melkì. Màtat ye mo Levì. Helì ye mo Màtat. Jòsep nə̀ yi à ye mo Helì, yi à ye ŋwə̀ nə̀ bwìŋ sə tsərə də yi tɛ̀'ɛ Jisòs. ");
INSERT INTO yam_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisòs à bwì foho və̀ mvwe' ndzəp Jòridàŋ ŋga yi rwi bə Yòŋsə̀ nə̀ Rərɛŋ. Fana Yòŋsə̀ nə jə lo yi mvwe' səmok sə ŋgəà. ");
INSERT INTO yam_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Satà nə̀ yi ŋkum ze' nə ànə mumsə yi mvwe' yà'sə nùumbu hum kwè. Mvə̀k ànə à ye, yi kà yumok momjo zʉ lok, fana njè yaŋ yi ŋga nùumbu sə̀ hum kwè sə mèe. ");
INSERT INTO yam_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satà nə cep bohòyi dʉk də, <<A ye-a ŋga wu mo Nwì, wù cep-a bohòlìs nè'e ŋga nà'a bʉʉŋ bɛŋ ŋga wu zʉ.>> ");
INSERT INTO yam_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisòs dʉk fa nà' də, <<Wo à còm nòŋsə ndzənə ŋwàk Nwì dʉk də, <Kaco ŋwè cum megu bʉ̀ʉ ŋàaŋ zʉzʉ yeŋ.> >> ");
INSERT INTO yam_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satà jə lo yi mʉ tu nda nəmòk, nə niŋ fa yi lak sə̀ sə nzeŋgòŋ pwe' kɛ̀' mò'fis. ");
INSERT INTO yam_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Yi dʉk də, <<Mʉ nə fa wu ŋàŋ bə lak yè'sə nə ye ghàak sə̀ fòpwe'. Nwì ànə fa yà' pwe' ndzə bòhòmʉ̀ yi, nə yeè nə də, mʉ̀ tse' ŋàaŋ sə̀ ŋgòfa yà' bohòŋwə̀ nə̀ ntʉm àm dzəm. ");
INSERT INTO yam_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bum yè'sə pwe' nə ye yò, ŋga wu kuksə-a mʉ.>> ");
INSERT INTO yam_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisòs dʉk də, <<Cu ndzənə ŋwàk Nwì nə də, <Ŋwè tse' ŋgòkùksə Tà nə̀ yi Nwì ye, nə fak megu sə̀' bohòyi yiìyi.> >> ");
INSERT INTO yam_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Satà jə lo Jisòs mʉ Jòrosalèm, nə kə tes yi mʉ ndùndap Nwì nə̀ ghaŋ nə mvwe' sə̀ yà' sap càsə. Yi dʉk fa Jisòs də, <<A ye-a də wu mo Nwì, wù li gbʉ tsooŋ mʉ ndùndap fɛɛŋ. ");
INSERT INTO yam_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yà' cu ndzənə ŋwàk Nwì də, <Nwìi nə fa masinjàa ye ŋàŋ ŋgòjə ŋkərə̀ bohòwù.> ");
INSERT INTO yam_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Yà' cu nja sə̀' də, <Wo nə kotse' wu mʉtsə̀ bə bo awo, ya wu nə kà kù nə̀ kù ta.> >> ");
INSERT INTO yam_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisòs dʉk fa nà' də, <<Wo də, <Wù ka tse' ŋgòbʉə ja'a Tà nə̀ yi Nwì yòtse'.> >> ");
INSERT INTO yam_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satà nə ànə mumsə wes Jisòs vɛ'nə, fana yi me'rə tse' nà' ghàr. ");
INSERT INTO yam_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Fana Jisòs bwi foho lo mvwe' nzeŋgòŋ Galìli. Ŋàaŋ Yòŋsə̀ nə̀ Rərɛŋ à ye bohòyi. Bwìŋ anə yuk wes nzu Jisòs mvwe' tò'o lak yà'sə pwe'. ");
INSERT INTO yam_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yi a sə yə'rə bʉ̀ʉ sə mʉmvwe' ndap pìriyà bʉ̀ʉ Jus wèŋ, fana bwìŋ pwe' sə kuksə yi. ");
INSERT INTO yam_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisòs ànə bwi foho lo mʉ Nazàrɛ, lak sə̀ yi ànə kuk fo'. À ye nùmbu dzə̀ bʉ̀ʉ Jus, yi lo mʉ ndap pìriyà, sə̀' mvə̀'nə̀ yi ànə sə lo mantombì. Yi lokok təəŋ mʉtsə̀, nə taŋ ndzənə ŋwàk Nwì. ");
INSERT INTO yam_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Wo ànə fa yi ŋwàk Ìzayà, nə̀ yi ànə ye ŋgà tsòhòbum Nwì. Yi fiŋ, nə muk ŋwàk nə, nə ye mvwe' sə̀ wo ànə com nja də, ");
INSERT INTO yam_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","<<Tà Nwì a fa mʉ yòŋsə̀ ye, bʉ̀ʉsə̀ yi a cok fis mʉ də mʉ tsoho fa Ntirə̀ nə̀ Bə̀boŋ bohòbʉ̀ ŋgàa jìŋ wèŋ. Yi a tum mʉ də mʉ kə tsoho fa bʉ̀ʉ sə̀ wo cu ndapndzəm də wo nə fis me'rə wo. Mʉ tsok fa bʉ̀ ŋgàa ntwìlis wèŋ də wo nə ye bum sə̀mok. Mʉ fiŋ me'rə bʉ̀ʉ sə̀ wo cu bə ŋgə'. ");
INSERT INTO yam_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nə tsok fa bwìŋ də lùmŋgòŋ nə̀ Tà Nwìi nə kə luŋsə bʉ̀ʉ ye wèŋ nə və̀ laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yi ànə taŋ mesə vɛ'nə fana yi lok nà', nə fa nà' bohòŋwə̀ nə̀ yi tɛsəgə̀ mʉmvwe' ndap pìriyà nə, nə cum tsoŋ nze, nə ye ŋgòtsòho. Bʉ̀ʉ sə̀ wo ànə ye mʉmvwe' ndap pìriyà nə wèŋ à sə kʉ̀k tse' mègù mok yi. ");
INSERT INTO yam_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yi ye ŋgòtsə̀' fa bʉ̀ʉ sə də, <<Yusə̀ yà'a ndzənə ŋwàk Nwì sə bʉ̀ʉŋ və̀ ntinə zìnə mʉmvə̀'nə̀ wèŋ yuk ŋga mʉ̀ ta yè'sə.>> ");
INSERT INTO yam_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bwìŋ à kwa bohòyi, bə lə̀lʉm ncèep sə̀ yà' à sə tesə kə̀ cùhù yi. Wo sə fe'rə də, <<Nè'e ka mo Jòsep ye àlɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisòs dʉk fa wo də, <<Mʉ̀ riŋ də wèeŋ nə mak fa mʉ gbʉ' nè'e də, <Ŋgà ncə̀p, gʉŋsə-a ni' yò.> A yà'a də, <Wu gʉ̀ bum sə̀ vès a yuk də wù a sə gʉ̀ yà' mvwe' lak Kàpanùm yà'a, mʉ ntòla'à wù fɛɛŋ sə̀'.> >> ");
INSERT INTO yam_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yi dʉk fa fe'lə wo də, <<Mʉ̀ sə tsə̀' fa weŋ nə̀ zìnə də, bʉ̀ʉ sə̀ mʉ ntòlak kà ŋgà tsòhòbum Nwì nə̀ yi tesə sə̀' mvwe' ntòlak ànə co yumok jəgə̀. ");
INSERT INTO yam_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mʉ̀ sə tsə̀' fa weŋ zìnə də, ghà nə̀ Àlajà à cu fo' nà'a, bàa yepmfə à ye mvwe' lak Izùrɛ ŋkʉ̀ʉŋntɛ̀ŋ. Mvə̀k nə̀ mbʉ̀ŋ à sə kà ligə̀ mʉnə lùumŋgòŋ tɛ' bə bwes fana, njè ko nzeŋgòŋ nə pwe'. ");
INSERT INTO yam_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nwì ànə ka Àlajà bohòbàa yepmfə avès ŋgòfa yi zʉzʉ sə̀' tum, yi à tum lònà' bohòŋwà ŋgwemfə nə̀ mvwe' lak Zarefà nə̀ mvwe' nzeŋgòSidòŋ. ");
INSERT INTO yam_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ŋgàa kuturu ànə ye mvwe' lak Izùrɛ sə̀' ŋkʉ̀ʉŋntɛ̀ŋ mʉmvə̀k nə̀ Àlasà ànə cum fo' nà'a. Fana yi ànə ka ŋwə̀ àvès nə̀ mò'fis gʉŋsə, yi à gʉŋsə mègù Namàn nə̀ yi ŋwə̀ Sìriyà.>> ");
INSERT INTO yam_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bʉ̀ʉ sə̀ wo ànə ye mʉmvwe' ndap pìriyà anə, à yuk bum sə̀ Jisòs à cèep fana ntʉm cəp wo nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wo lokok, nə soŋ dapsə fis mʉntòlak anə, nə jəŋ lo yi mʉ tu nda nə̀ wo a ci lak awo mbwa, ya wo dusə mak tsoŋ lo yi sə bamə̀ anə. ");
INSERT INTO yam_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Fana yi swɛ'ɛ tesə ndzə bohòwo anə, nə gi ca mʉtsətsə'rəə wo anə nə lo yuye. ");
INSERT INTO yam_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisòs à lòmvwe' lak Kàpanùm nə̀ mvwe' nzeŋgòGalìli, fana yi sə yə'rə bwìŋ fo' nùmbu dzə̀. ");
INSERT INTO yam_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wo à mərə pwe', bʉ̀ʉsə̀ ncèp nə̀ yi à sə cèp nə, à ye nsàp nə̀ nje zok bə ŋàŋ. ");
INSERT INTO yam_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ŋwə̀ nəmòk ànə ye mʉ ndap pìriyà anə, nə̀ yi à tse' yòŋsə̀ ze' ndzə ni'ì yi. Yi cep torə fis bə ŋàŋ dʉk də, ");
INSERT INTO yam_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","<<Hàva', Jisòs nə̀ mvwe' lak Nazàrɛ, wù tse' yà vesùwèŋ nɛ? Wù və̀ yè'sə ŋgòzə ves à? Mʉ̀ riŋ wu bə̀boŋni, wu mo Nwì nə̀ wu rərɛŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisòs ghamsə yòŋsə̀ nə, nə dʉk fa yi də, <<Lok cùu yò, nə ca tesə ndzə ni'ì ŋwə̀ ènə.>> Ze' nə bwi' mak ŋwə̀ nə sə nze, nə tesə gɛsə lo, nə kà yi yumok gʉ̀. ");
INSERT INTO yam_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bwìŋ à mərə ŋkʉ̀ʉŋntɛ̀ŋ, nə sə fe'rə kɛ'ca də, <<Hàva', yè'sə yà vɛ'nə ɛ? Ŋwə̀ nè'e sə cep bə ncèep sə̀ yà' tse' ŋàŋ, fana yòŋsə̀ ze' sə tesə ndzə ni'ì bwìŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Fana nzu bum sə̀ Jisòs à gʉ̀ yè'sə yuhu lo mvwe' nzeŋgòànə pwe'. ");
INSERT INTO yam_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisòs à mè'rə mʉ ndap pìriyà anə, nə lo mʉ nda'à Saimʉ̀. À ye ŋga mali Saimʉ̀ nə sə ya yiyaŋ wùriŋ. Fana wo tsok fa Jisòs bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yi lo kə təəŋ ŋgʉ kèe nà', nə cep bohòyiya nə. Yiya nə à mè'rə yi ghà nà'nə. Yi lokok, nə lap fa wo zʉzʉ. ");
INSERT INTO yam_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nùm à co, fana bʉ̀ʉ sə̀ wo à tse' ŋge' awo sə̀ wo à tse' yiyaŋ zok zok jə və yà'wèŋ bohòJisòs. Yi jwɛŋ wo bə bo ye, fana yiyaŋ awo me. ");
INSERT INTO yam_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yòŋsə̀ə ze' wèŋ à sə tesə ndzə ni'ì bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ, nə sə cep sa'rə də, <<Wu mo Nwì.>> Jisòs ghamsə yà'wèŋ də yà'wèeŋ kà cèp, bʉ̀ʉsə̀ wo ànə riŋ də a yi Ŋkum ŋgà gèm bwìŋ nə̀ Nwì ànə kak də yi nə tum və nə. ");
INSERT INTO yam_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tsok à rɛŋ, Jisòs me'rə ntòlak nə, nə lo mvwe' səmok yiìyi. Bʉ̀ʉ sə wèŋ ye ŋgòlàp yi. Wo ànə ye yi fana wo lap mandzə̀ ŋgògʉ̀ də yi kà lò. ");
INSERT INTO yam_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yi dʉk fa yà'wèŋ də, <<Mʉ̀ tse' ŋgòtsòho lòNtirə̀ nə̀ Bə̀boŋ nə̀ nà'a bə gaŋ ŋkum Nwì nə mvwe' buhu lak mok sə̀'. Bʉsə̀ yà'a yusə̀ Nwì a tum mʉ də mʉ gʉ sə.>> ");
INSERT INTO yam_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Fana yi sə tsoho kɛ' lo mʉnə ndap pìriyà wèŋ mvwe' nzeŋgòŋ Jùdiyà nə pwe'. ");
INSERT INTO yam_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A ye nùmbu mòk ŋga Jisòs tə ŋgʉ tə̀m Jènesarè fana bwìŋ kə rwiŋ fo' vɛ'ɛ fak fak. Bwìŋ sə nik kʉəp lo ŋgʉ ni'ì yi, ŋgòyuk ncèp Nwì. ");
INSERT INTO yam_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jisòs ye ŋga ŋgwes tə ŋgʉ tə̀m anə ba ŋga ŋgàa ko fuk wèŋ ànə tes yà', nə lo ŋgòcùk ram awo. ");
INSERT INTO yam_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yi ni lo sənə ŋgwes nə̀ Saimʉ̀ ànə tse' nà' yi, nə dʉk nà' də nà'a bwi' gɛsə ŋgwes nə mvwe' ŋgʉ ndzəp nə momjo. Fana yi cum ca, nə sə yə'rə bʉ̀ʉ sə. ");
INSERT INTO yam_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yi à mèsə yəyə'rə̀ nə fana yi dʉk fa Saimʉ̀ də, <<Bwi' lo ŋgwes nə mvwe' sə̀ ndzəp nə cəco ya weŋ ŋge' yòo gesə ram sə ndzəpə̀, nə ko fuk.>> ");
INSERT INTO yam_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimʉ̀ dʉk fa yi də, <<Tɛ̀', vès fuk nòoŋ tè tsok rɛŋ vès kà fuk nə̀ mò'fis ko. Fana bʉ̀ʉsə̀ wù cèp vɛ'nə, mʉ nə mak gesə ram nə sə ndzəpə̀ anə.>> ");
INSERT INTO yam_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wo ànə mak gesə ram nə sə ndzəpə̀ anə, nə ko fuk vɛ'ɛ nə̀bʉp, ram nə ye ŋgòtiŋ. ");
INSERT INTO yam_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Fana wo bak gesə lo fa ŋge' awo sə̀ bə ŋgwes mòk nə bo, də yà'a və kə tɛsə wo. Wo və, nə rusə ŋgwes awo sə bə fuk fana yà' ye ŋgòcəəŋ lòsə ndzəpə̀. ");
INSERT INTO yam_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimʉ̀ ànə yeŋ nsàp fuk nə̀ wo anə ko fana yi gbʉ təəŋ bə tumfərə kù mantombìi Jisòs, nə dʉk fa nà' dʉk də, <<Dù lo yuyo, Tà, bʉ̀ʉsə̀ mʉ ŋwə̀ nə̀ mʉ̀ rwiŋ bə bʉp.>> ");
INSERT INTO yam_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimʉ̀ bə bʉ̀ʉ sə̀ wo ànə ko nsàp fuk nè'nə ànə mərə vɛ'ɛ nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Fana ŋge' ye wèŋ Jem bə Jon, bwe Zebèdi ànə mərə sə̀'. Jisòs tsok fa Saimʉ̀ dʉk də, <<Kà wəp, ye jəŋ ŋga'a wu nə kà fuk mok ko, wu nə sə ko jə və fa mʉ bwìŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bʉ̀ʉ sə bwi' lo ŋgwes sə ndzə ŋgʉ ndzəp anə, nə mak noŋsə yà' mʉmvwe' anə, nə bɛ'lo Jisòs. ");
INSERT INTO yam_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisòs ànə cum bə lak mok fana ŋwə̀ ŋgà kuturu ye yi ŋga yiyaŋ nə à wes yi vɛ'ɛ pwe' nə̀ pwe'. Yi ye Jisòs, fana yi gbʉ bu'rə kù mantombìi nà', nə lɛŋ nà' də, <<Tà, a bò-a wu co wù tɛsə mʉ na, wù gʉ fa mʉ yiya àm nè'e me.>> ");
INSERT INTO yam_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisòs fis bo, nə jwɛŋ nà' bə zeŋ, nə dʉk də, <<Mʉ̀ dzəm laŋ, yiya yònə nà'a me.>> Yiya ye nə à mè mègù fo' sə̀' ghà ànə. ");
INSERT INTO yam_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisòs tipsə yi də, <<Nə kà ŋwə̀ nəmòk tsə̀' fa, du mvwe' ŋgà fa satikà' ya yi nə kʉk ja'a wu, fana wù fa fəfa mvə̀'nə̀ Musì ànə dʉk ŋgònì də yiya nə mè laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Fana nzu nə̀ də Jisòs gʉ̀ yu yè'sə yuhu lo ŋkʉ̀ʉŋntɛ̀ŋ, maŋgòŋ tesə və ŋgòyuk bum sə̀ Jisòs à sə tsòho, nə ye ŋgòfek yi də nà'a mesə fa wo yiyaŋ awo. ");
INSERT INTO yam_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Fana yi sə loho yuye ŋgəà kə̀kɛ̀' ŋgòlɛŋ pìriyà. ");
INSERT INTO yam_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","A ye nùmbu mòk ŋga Jisòs sə yə'rə fa bwìŋ ncèp Nwì, fana bʉ̀ʉ Faràsi bə bʉ̀ʉ sə̀ wo yə'rə fagə̀ bwìŋ lʉ̀ʉk Nwì à ye mʉtsətsə'rə̀ə wo. Wo ànə tesə və pwe' mvwe' nzeŋgòŋ Galìli, Jùdiyà, bə ntòlak Jòrosalèm. Ŋàaŋ Tà Nwì à ye bohòJisòs ŋgòmèsə yiyaŋ. ");
INSERT INTO yam_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bʉ̀ʉ səmok bək və ŋwə̀ nəmòk mʉnə dak, nə̀ yi à tse' yiya nə̀ nà'a bù'rəgə̀ bwìŋ. Wo lap mandzə̀ ŋgònisə lo yi mʉ nda'à anə mantombìi Jisòs. ");
INSERT INTO yam_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bʉsə̀ maŋgo bwìŋ à ye wùriŋ fana wo kà mandzə̀ ŋgòjə lòyi mbwa tse'. Wo bək kok lo ŋgà yiya nə mʉ ndùndap, nə cok tosə mvwe' sə̀ Jisòs tə sə, nə le' gesə tsoŋ ŋwə̀ nə kù mantombìi Jisòs mʉtsətsə'rə̀ə bwìŋ anə. ");
INSERT INTO yam_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisòs à yə də wo tse' dzədzəm nə̀ də aco yi gʉ yiya ŋwə̀ nə me. Yi dʉk bohòŋwə̀ nə̀ yi kà gìgə̀ nə də, <<Mo àm, mʉ̀ swìfa wu bʉp yo laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bʉ̀ ŋgàa yə'rə̀ lʉ̀ʉk Nwì wèŋ bə bʉ̀ʉ Faràsi wèŋ à yu' vɛ'nə wo ye ŋgòŋwʉ̀rə kɛ'cà də, <<Nè'nə ndà nə̀ yi sə bʉpsə liŋ Nwì ɛ? Kaco ŋwè swifa ŋwè bʉp yeŋ, mègù Nwì yiìyi.>> ");
INSERT INTO yam_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisòs à rì bum sə̀ wo ànə sə tsərə sə ntʉʉ̀ wo vɛ'ɛ pwe', nə fek wo dʉk də, <<Wèŋ sə tsərə bum yè'sə sə ntʉʉ̀ wèŋ vɛ'nə bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Co joho gha' yè'e nə̀ ŋgòdʉk də, <mʉ̀ swì fa wu bʉp yòlaŋ>, kè nə̀ ŋgòdʉk də, <Lòkok mʉtsə̀, nə gi lo yuyo> ɛ? ");
INSERT INTO yam_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Fana mʉ nə ni fa weŋ də mʉ̀ʉ mo ŋwè, mʉ̀ tse' ŋàŋ sə nze ŋgòswìfa bwìŋ bʉp awo.>> Fana yi dʉk fa ŋgà' nə̀ yi kà gìgə̀ nə də, <<Mʉ̀ dʉk wu də lòkok, nə te' kà yò, nə lo la'à wù.>> ");
INSERT INTO yam_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yi à cèp vɛ'nə fana ŋwə̀ nə lokok təəŋ kù mantombìi wo ghà ànə. Yi te' lim bək kà ye, nə lo yuye mʉ nda'à yi, nə sə kuksə lo Nwì. ");
INSERT INTO yam_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bwìŋ ànə mərə vɛ'ɛ ŋkʉ̀ʉŋntɛ̀ŋ, nə wəp nə̀bʉp, nə kuksə Nwì dʉk də, <<Vès yə nsàp maŋgəŋgèŋ mòk ntinə.>> ");
INSERT INTO yam_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yè'sə a mè fana Jisòs tesə lo, nə kə ye Levì ŋgà ko mbàm tas mvwe' sə̀ yi fàkgə̀ fo'. Jisòs dʉk fa yi də, <<Bɛ' və mʉ.>> ");
INSERT INTO yam_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levì nə lokok, nə me'rə bum fàak ye pwe', nə bɛ' lo Jisòs. ");
INSERT INTO yam_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Fana Levì nə à kə̀ gʉ̀ fa Jisòs dinà nə̀ ghaŋ mʉ nda'à yi. Ŋgàa ko tas wèŋ ànə və, bə bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ, nə sə zʉ zʉzʉ fo'. ");
INSERT INTO yam_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bʉ̀ʉ Faràsi bə bʉ̀ awo mok sə̀ wo bʉ̀ ŋgàa yə'rə̀ lʉ̀ʉk Nwì wèŋ ànə ye vɛ'nə wo fek ŋgàa fàak Jisòs də, <<Wèŋ sə zʉ be'lə weŋ ŋgàa ko tas nə ye bə bʉ̀ ŋgàa gʉ̀ bʉp wèŋ bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisòs dʉk fəsə fa wo də, <<Bʉ̀ʉ sə̀ wo ka yiyaŋ tse', wo kà doktà làpgə̀, a làpgə̀ doktà ŋwə̀ nə̀ yi sə yaya. ");
INSERT INTO yam_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Fana mʉ̀ a ka njo bʉ̀ʉ sə̀ kə̀kʉrə̀ wèŋ və̀, mʉ̀ a və̀ ŋgòto bʉ̀ ŋgàa gʉ̀ bʉp wèŋ, ya wo nə kupsə ntʉm awo, nə bwi fa bʉp awo ŋkwɛ̀ŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bʉ̀ʉ səmok à fek Jisòs də, <<Ŋgàa fàak Jon dzə̀gə̀ zʉzʉ kə̀kɛ', nə sə gʉ pìriyà, nə ye də ŋgàa fàak bʉ̀ʉ Faràsi wèeŋ gʉ̀gə̀ sə̀' vɛ'nə, ŋgàa fàak yòsə zʉ nə sə no nùumbu pwe' bʉ̀ʉ yà lɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisòs fek wo də, <<Aco wo dʉk fa bʉ̀ʉ sə̀ wo və̀ mvwe' sə̀ wo sə zʉ gù də yà'wèeŋ dzə zʉzʉ ŋga ndugù nə cu fo' nùumbu yà'sə à? Ka vɛ'nə sə̀ yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nə yeè nə də, mvə̀k nəmòk cu nə̀ wo nə jəŋ gɛsə lo ndugù nə, fana bʉ̀ʉ sə nə dzə zʉzʉ mvə̀k ànə.>> ");
INSERT INTO yam_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisòs mak fa wo gbʉ' nè'e də, <<Kaco ŋwè sa jəŋ cə̀k nini nə̀ fi, nə te' lok cə̀k nə̀ zəm bə zeŋ yeŋ. A ye-a vɛ'nə, cə̀k nə̀ fi nə nə sarə ghasə cə̀k nə̀ zəm nə, fana yà' kà kʉ̀rə̀. ");
INSERT INTO yam_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kaco ŋwə̀ nəmòk kep gesə dzə̀ rùk sənə bɛ̀s nə̀ zəm yeŋ. A ye-a ŋga yi gʉ̀ vɛ'nə, dzə̀ rùk nə nə duk, nə vok bɛ̀s nə, rùuk sə maha wà, bɛ̀s nə bʉp sə̀' wà. ");
INSERT INTO yam_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hai', ka vɛ'nə yeŋ, gèsə rùuk sə̀ fi sənə bɛ̀s nə̀ fi.>> ");
INSERT INTO yam_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jisòs dʉk fe'lə sə̀' də, <<Ŋwèe no-a rùuk sə̀ zəm, fana yi nə kà ŋgòno rùuk sə̀ fi dzəm. Anə boŋ ghak gu yi mok rùuk sə̀ zəm sə.>> ");
INSERT INTO yam_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jisòs à gì cà mvwe' nzum nzaŋ mok ŋga a nùmbu dzə̀. Ŋgàa fàak ye kʉp tu nzaŋ mok, nə sə nuk yà' ndzə bohòwo, nə sə zʉ mvə̀əm nzaŋ sə. ");
INSERT INTO yam_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bʉ̀ʉ Faràsi səmok fek wo də, <<Lʉ̀k avès ka də ŋwèe fak nùmbu dzə̀ dzəm, wèŋ sə kʉp nzaŋ ŋga a yà'sə fàk bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisòs fek wo dʉk də, <<Wèŋ ànə ka yusə̀ Devìd bə bʉ̀ʉ ye wèŋ ànə gʉ taaŋ ŋga njè sə ya wo yuk à? ");
INSERT INTO yam_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yi à ni lòmʉ nda'à Nwì, nə jəŋ zʉzʉʉ sə̀ wo à jə və̀ ŋgòkwasə Nwì bə zeŋ, nə zʉ yà', nə fa bʉ̀ʉ ye wèŋ yà' sə̀'. Wo à zʉ vɛ'nə ŋga lʉ̀k sə bɛ̀ŋ də kaco ŋwè zʉ yeŋ, tse'ŋga wu ŋgà fa satikà' ŋkuŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jisòs cep ləsə ncèp nə də, <<Mʉ̀ʉ mo ŋwè, mʉ Tà bə nùmbu dzə̀ nə mʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","À ye nùmbu dzə̀ nəmòk sə̀', Jisòs lo mʉ ndap pìriyà ŋgòtsòho fa bwìŋ ncèp Nwì. Ŋwə̀ nəmòk à ye mʉtsətsə'rə wo anə nə̀ bo ye ànə kpʉ ma màk. ");
INSERT INTO yam_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ànə ye mvə̀k ànə bʉ̀ ŋgàa yə'rə̀ lʉ̀k Nwì bə bʉ̀ʉ Faràsi sə̀ wo à ye fo' sə kʉk gosə kɛ' Jisòs. Wo à sə kʉ̀' ŋgòko yi bə nzak də yi gʉ̀ fàk nùmbu dzə̀. ");
INSERT INTO yam_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Fana Jisòs riŋ yusə̀ wo à sə tsərə sə ntʉʉ̀ wo sə, nə dʉk fa ŋwə̀ nə̀ bo à kpʉ yi nə də, <<Lokok təəŋ və mantombì fɛɛŋ.>> Ŋwə̀ nə lokok təə megu sə̀ vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jisòs dʉk fa wo də, <<Mʉ̀ sə fek yè'e wèŋ dʉk də, lʉ̀k àvès sə dzəm də vesùwèeŋ gʉ nùmbu dzə̀ yà? Nà' sə dʉk də vesùwèeŋ tɛsə ŋwè kè a yeŋsə yi ŋgə' ɛ? Nà' sə dʉk də vesùwèeŋ gem yòŋsə̀ ŋwè kè a mesə nà' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Fana yi kʉk dzooŋ yak wo pwe', nə dʉk fa ŋgà yiya nə də, <<Nèp fis yak kwiŋ yo sə.>> Ŋwə̀ nə à gʉ̀ sə̀ vɛ'nə fana bo ye sə gʉŋ. ");
INSERT INTO yam_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bʉ̀ʉ sə ànə jok vɛ'ɛ wùriŋ, nə sə cep kɛ' ca mʉtsətsə'rə wo yusə̀ aco wo ko Jisòs bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ànə ye mvə̀k ànə fana Jisòs kok lo mʉ tu nda nəmòk, nə lɛŋ Nwì. Yi lɛŋ vɛ'ɛ, tè tsok rɛŋ, yi kà lo dzəm. ");
INSERT INTO yam_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tsok à rɛɛŋ fana, yi to benə ŋgàa fàak ye sə wèŋ mvwe' mò'fis, nə cok fis jəŋ bwìŋ hum-ncòp-ba, nə to yà'wèŋ də ŋgàa ntum. ");
INSERT INTO yam_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Liŋ bʉ̀ʉ sə̀ yi à cokfis sə, à ye Saimʉ̀ nə̀ yi à fa nà' liŋ də Pità bə moma ye Andrù, Jem bə Jon, Filìp bə Bàtòlomì, ");
INSERT INTO yam_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Màtiyò, bə Tomos, Jem mo Alfòs bə Saimʉ̀ nə̀ wo ànə to yi də Zilò, ");
INSERT INTO yam_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judàs mo Jem bə Judàs Iskarəyà nə̀ yi ànə seŋ Jisòs. ");
INSERT INTO yam_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","A ye ŋga Jisòs tsoŋ tesə və mʉ tu nda nə, fana yi kə təəŋ mvwe' nəmòk nə̀ à ye fo' rə̀əm. Yi à ye fo' bə ŋgàa fàak ye wèŋ ŋkʉ̀ʉŋntɛ̀ŋ. Fana bwìŋ tesə və mvwe' nzeŋgòŋ Jùdiyà bə ntòlak Jòrosalèm, nə ye ntòlak Tayà bə Sidòŋ sə̀ yà'a ŋgʉ ndzəp, nə kə maŋ fo'. ");
INSERT INTO yam_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wo ànə və ŋgòyuk yusə̀ Jisòs anə sə yə'rə, nə ye ŋgòlɛŋ Jisòs də nà'a mesə fa wo yiyaŋ awo zok zok sə̀ yà' sə ya wo. Bʉ̀ʉ mok à ye fo' sə̀ wo à tse' yòŋsə̀ə ze' sə̀ yà' sə fa wo ŋgə' fana Jisòs bɛ'fis fa wo yà'. ");
INSERT INTO yam_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Fana bʉ̀ʉ sə pwe' sə lap mandzə̀ ŋgòjwɛ̀ yi, bʉ̀ʉsə̀ ŋàŋ ànə sə tesə ndzə ni'ì yi, nə sə mesə fa wo yiyaŋ awo. ");
INSERT INTO yam_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisòs à kʉ̀k ŋgàa fàak ye, nə dʉk də, <<A rɛŋsi bohòŋgàa jìŋ wèŋ, bʉ̀ʉsə̀ tse' gaŋ sə̀ Nwì nsàap bʉ̀ʉ yè'sə. ");
INSERT INTO yam_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","A rɛŋsi bohòbʉ̀ʉ sə̀ njè sə ya weŋ ŋga'a, bʉ̀ʉsə̀ wèeŋ nə ze' ntsə'mòk. A rɛŋsi bohòwèŋ sə̀ wèŋ sə wa ŋga'a bʉ̀ʉsə̀ wèeŋ nə̀ ywì ntsə'mòk. ");
INSERT INTO yam_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","A rɛŋsi bohòwèŋ sə̀ bwìiŋ nə bɛŋ weŋ, nə sə bɛ' weŋ, nə yak weŋ, nə cep bum sə̀ bʉp bohòwèŋ bʉ̀ʉ mʉ̀ nə̀ mʉ mo ŋwè. ");
INSERT INTO yam_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","A ye ŋga wo gʉ̀ weŋ vɛ'nə, weŋ kwa, nə sə kaŋ dzeŋ, bʉ̀ʉsə̀ wèeŋ nə tse' lə̀là' mʉbu ŋkʉ̀ʉŋntɛ̀ŋ. Wèeŋ riŋ sə̀' də, tàcicii bʉ̀ʉ yè'sə wèŋ ànə gʉ ŋgàa tsòhòbum Nwì wèŋ sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","<<Fana anə bʉp wesə bohòwèŋ ŋgàa ghàk vɛ'ɛ wùriŋ, bʉ̀ʉsə̀ wèŋ a yuk wes lʉ̀m ma njàwèŋ laŋ. ");
INSERT INTO yam_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Anə bʉp bohòwèŋ sə̀ wèŋ cu ŋga'a zəze', bʉ̀ʉsə̀ njèe nə yaŋ weŋ ntsə'mòk. Anə bʉp bohòwèŋ sə̀ wèŋ sə ywì ŋga'a, bʉ̀ʉsə̀ wèeŋ nə tɛ' nə waŋ nùmbu mòk. ");
INSERT INTO yam_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Anə bʉp bohòwèŋ sə̀ bwìŋ pwe' sə gɛ̀ŋ to liŋ awèŋ bə̀boŋ, bʉ̀ʉsə̀ yà'a sə̀' mʉmvə̀'nə̀ tàcici awo wèŋ à sə gɛ̀ŋ liŋ bʉ̀ ŋgàa mvwès sə̀ wo à dʉk də wo ŋgàa tsòhòbum Nwì sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","<<Nə yeè nə də, mʉ̀ sə cèp bohòwèŋ sə̀ wèŋ sə yuk yusə̀ mʉ̀ sə cèp yè'e də, dzəm bʉ̀ʉ sə̀ wo sə bɛ̀ŋ weŋ, nə sə gʉ bə̀boŋ bohòbʉ̀ʉ sə̀ wo sə dzèeŋ weŋ. ");
INSERT INTO yam_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wèeŋ se bʉ̀ʉ sə̀ wo sə yak weŋ, nə lɛŋ fa bʉ̀ʉ sə̀ wo sə fa weŋ ŋgə' pìriyà. ");
INSERT INTO yam_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","A ye-a ŋga ŋwə̀ nəmòk sam wu mbumbuk, wù tse' fa yi mamòk yi ləp sə̀'. A ye-a ŋga ŋwə̀ nəmòk fep jə cə̀k yò, wù me'rə yi fep jəŋ cə̀k yònə̀ ndzə tsətsə'rə̀ sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Fa ndàaŋwè pwe' nə̀ yi lɛŋ yumok bohòwù. A ye-a ŋga ŋwə̀ nəmòk jə yumok sə̀ yà'a sə̀ yò, wù kà də wu fek yi ŋgòfa fəsə wu yà' dʉk. ");
INSERT INTO yam_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mʉmvə̀'nə̀ wù dzəm də bwìiŋ gʉ fa wu fana wù gʉ fa wo sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","<<A ye-a ŋga wù dzəm bʉ̀ʉ sə̀ wo sə dzəm wu, Nwìi nə kwasə wu bʉ̀ʉ yà? Bʉ̀ʉ sə̀ bʉp wèeŋ dzəmgə̀ sə̀' bʉ̀ʉ sə̀ yà' dzəm wo. ");
INSERT INTO yam_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A ye-a ŋga wù gʉ̀ bə̀boŋ bohòŋwə̀ nə̀ yi gʉ̀gə̀ wu bə̀boŋ, Nwì se wu bʉ̀ʉ yà? Bʉ̀ʉ sə̀ bʉp gʉ̀gə̀ sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A ye-a ŋga wù fòsə fa mègù bʉ̀ʉ sə̀ wo nə fòsə fa wu, Nwìi nə kwasə wu bʉ̀ʉ ya? Bʉ̀ʉ sə̀ bʉp wèeŋ fòsə fagə̀ bʉ̀ʉ sə̀ bʉp mok sə̀', də ya wo nə tse' fe'lə yà' maŋkwɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wèeŋ dzəm lɛ bʉ̀ʉ sə̀ wo sə bɛ̀ŋ weŋ, nə gʉ wo bə̀boŋ. Fosə fa wo, nə kà yà' fek fəsə̀. Ya wu nə tse' lə̀là' mʉbu ŋkʉ̀ʉŋntɛ̀ŋ, wù ye sə̀' mo Tà Nwì nə̀ yi Nwì nə̀ ghaŋ nə. Nwìi gʉ̀gə̀ ye bə̀boŋ bohòbʉ̀ʉ sə̀ wo kà yi kwasəgə̀ nə ye bʉ̀ ŋgàa ŋkʉ̀ì' wèŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Wèeŋ sə koksə manziŋ bohòbwìŋ mʉmvə̀'nə̀ Tɛ̀' awèeŋ koksəgə̀ manziŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Fana kà də wèeŋ sak ŋwə̀ nəmòk dʉk, ya Nwìi kà weŋ sə̀' sak. Wèeŋ kà ŋwə̀ nəmòk gʉ̀ bʉpsə̀ ya Nwìi kà weŋ bʉpsə̀. Swifa bwìŋ ya Nwì nə swifa weŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fa, ya ŋga Nwìi nə fa wu sə̀'. Wo nə fa wu bo dak, ŋga wo bɛŋ yà', nə tsərə be'lə mvwe' mò'fis, mamòk kɛ'ɛ lo nze, wù kà mvwe' nə̀ ŋgònə̀msə tse'. Mvə̀'nə̀ wù fʉk fa bwìŋ fana wo nə fʉk fa wu yòsə̀' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ànə geŋ fana Jisòs mak fa wo gbʉ' mòk də, <<Kaco ŋgà ntwìlis niŋ fa ŋgà ntwìlis mok mandzə̀ yeŋ. A ye-a ŋga ŋgà ntwìlis nə gʉ vɛ'nə, wo nə gbʉ ni sə wʉrə̀ wo ba fo'. ");
INSERT INTO yam_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kaco mo nə̀ yi sə yə'rə fàk riŋ casə ŋwə̀ nə̀ nà' sə yə'rə yi nə yeŋ. Yusə də, a ye-a ŋga ŋwə̀ nə̀ yi sə yə'rə fàk mèsə, yi nə riŋ kʉrə megu co ŋwə̀ nə̀ nà' à yə'rə yi nə. ");
INSERT INTO yam_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Njo nə̀ wu kʉ̀kgə̀ mʉjep nə̀ jo nə̀ nà' cu mʉ lisə̀ moma yo, nə swi də bɛ̀s tʉ nə̀ ghaŋ cu mʉ lisə̀ wùu yè'e bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kènə aco wù dʉk fa to moma yo mòk də, <Tse' vèsə lis ya mʉ fis fa wu mʉjep nə̀ mʉ lisə̀ wù> nà'a, ŋga wù sə kà ŋkwʉ̀ŋkwʉ̀ bɛ̀s tʉ nə̀ mʉ lisə̀ wù nà'a yə anə va? Wù ŋgà tè'èŋkup, fis to lɛ ntòjep nə̀ ghaŋ mʉ lisə̀ wù nà'a ŋkuŋ ya wu nə tse' mandzə̀ nə̀ ŋgòyə rì nə̀ jo nə̀ nà' cu mʉ lisə̀ moma yo nə. ");
INSERT INTO yam_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","<<Kaco tʉ nə̀ bə̀boŋ zəm nto' nə̀bʉp yeŋ, nə ye sə̀' də, kaco tʉ nə̀ bʉp zəm nto' nə̀ bə̀boŋ sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bwìiŋ nə riŋ tʉ bə nsàp nto' nə̀ tʉ nə sə zəm. Kaco wù kwiŋ lèmu' mʉnə ntwìnə̀nɛ' yeŋ, nə ye də, kaco wù kwiŋ pià mʉnə tʉ nàk sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ŋwə̀ nə̀ bə̀boŋ cep fis kokgə̀ ncèp nə̀ bə̀boŋ bʉ̀ʉsə̀ ntʉm ye bə̀boŋ. Ŋwə̀ nə̀ bʉp cèp fis kokgə̀ ncèp nə̀ bʉp bʉ̀ʉsə̀ ntʉm ye bʉp. A vɛ'nə bʉ̀ʉsə̀ cùu ŋwèe cep fis mègù yusə̀ yà' rwiŋ cu sə ntʉʉ̀ ŋgə̀ŋgàŋ. ");
INSERT INTO yam_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","<<Wèeŋ togə̀ mʉ də Tà, Tà, nə kà bum sə̀ mʉ̀ sə dʉk də wèeŋ gʉ gʉ̀ bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ŋwə̀ nə̀ yi və̀-a bohòmʉ̀, nə yuk yusə̀ mʉ̀ sə cèep, nə noŋsə yà', fana mʉ tsok fa weŋ nsàp ŋwə̀ nə̀ yi ye nə. ");
INSERT INTO yam_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yi co ŋwə̀ nə̀ yi dzəm ŋgòci ndap, yi tuŋ lo sə nze cəco, nə kə yeto kùmndap sə mʉnə lìs. Fana ndzəp rwiŋ, nə bwi' ndap nə, nà' kà tsòhò, bʉ̀ʉsə̀ yi a ci kùmndap nə bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Fana ŋwə̀ nə̀ yi yuk-a ncèp àm, nə kà yà' nòŋsə̀, ye də yi co ŋwə̀ nə̀ yi à ci ndap ye sə nze wà, nə kà kùmndap bom. Fana ndzəp à rwi, nə bwi' ndap nə, nà' gbʉ ghà ànə. Ndap nə à gbʉ̀ nsàp nə̀ co wù kà cèp to.>> ");
INSERT INTO yam_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","À ye ŋga Jisòs cèp mèsə bum sə̀ yi à tse' ŋgòcèep ŋga bʉ̀ʉ sə sə yuk fana yi lo mvwe' lak Kàpanùm. ");
INSERT INTO yam_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ŋkwà' ŋwə̀ sojà mòk nə̀ mvwe' lak Rumà à ye fo' nə̀ yi à tse' ŋkwɛ̀ŋ ye mòk nə̀ yi à dzəm nà' vɛ'ɛ wùriŋ. Moŋkwɛ̀ŋ ye nə à sə ya vɛ'ɛ co yi kpʉ li. ");
INSERT INTO yam_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ànə geŋ yi yuk nzu bum sə̀ Jisòs à sə gʉ̀ʉ, fana yi tum lo ŋkwàha bʉ̀ʉ Jus mok wèŋ də yà'a kə dʉk Jisòos və kə gʉŋsə ŋkwɛ̀ŋ ye nə. ");
INSERT INTO yam_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wo à lòo, nə kə lɛŋ gbərə Jisòs. Wo dʉk fa yi də, <<Ŋwə̀ ènə kʉ̀rə̀ co wù tɛsə yi, ");
INSERT INTO yam_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","bʉ̀ʉsə̀ yi dzəm bʉ̀ʉ lak avès ŋkʉ̀ʉŋntɛ̀ŋ, nə ci fa ves ndap pìriyà àvès sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Fana Jisòs bə yà'wèŋ lo. À kə̀ kʉəp və̀ mvwe' ndap sojà nə, fana nà' tumsə ŋge' ye mok wèŋ də yà'a kə dʉk fa Jisòs də, <<Tà, kà də wu ye ŋgə' ŋgwàŋ dʉk. Mʉ̀ ka kə̀kʉrə̀ co wù kə ni mʉ nda'à mʉ̀ yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yà'a yusə̀ yà' gʉ̀ ŋkuŋ mʉ̀ kà bohòwù mʉ̀ bə tu am və sə. Cèp mègù lɛ bə cù fana ya mofàk àm nə nə luŋ. ");
INSERT INTO yam_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mʉ̀ rì vɛ'nə bʉ̀ʉsə̀ mʉ yè'sə ŋwə̀ nə̀ mʉ̀ tse' ŋkwàha bʉ̀ʉ mok mantombìi mʉ̀ sə̀ mʉ̀ sə yuk bohòwo sə̀'. Sojàa mok cu sə̀ wo yukgə̀ bohòmʉ̀ sə̀' yo. Aco mʉ̀ to mòk dʉk də, Və̀ə, yi və. Mʉ̀ dʉk fa mòk də, Lòfa', yi geŋ. Nə dʉk fa mali mòk də, Gʉ yu yè'e, yi gʉ yà'.>> ");
INSERT INTO yam_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisòs à yuk vɛ'nə, fana yi mərə bohòŋkwà' ŋwə̀ nə, nə dʉk fa bohòbʉ̀ʉ sə̀ wo à yù və̀ yi fo' sə də, <<Mʉ̀ sə tsə̀' fa weŋ də, a mègù-a sə̀ mʉtsətsə'rəə bʉ̀ʉ Izùrɛ ma, mʉ̀ ka ŋwə̀ nəmòk fo' nə̀ yi tse' nsàp dzədzəm nə̀ ŋkʉ̀ʉŋ ènə vɛ'nə ye yuk.>> ");
INSERT INTO yam_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bʉ̀ʉ sə̀ ŋkwà'ŋwè sojà à tum sə à bwìŋ foho lòo, nə kə ye ŋga mo ye nə cu mok bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","À ka sap fana Jisòs kə ni mvwe' ntòlak mòk nə̀ wo to nà' də Neèn. Ŋgàa fàk ye nə ye bʉ̀ʉ mok wèŋ ŋkʉ̀ʉŋ sə bɛ' lòyi. ");
INSERT INTO yam_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yi à kʉəp və̀ mvwe' ncùu ŋka' lak sə, fana yi ye ŋga wo sə bə̀k və̀ vèŋ ŋwə̀ nəmòk nə̀ ma ye à ye ŋwà ŋgwemfə. Ŋwà nè'nə à tse' mègù mo nə̀ mò'fis ènə ŋga nà'a ŋwə̀mbam. Bwìŋ ŋkʉ̀ʉŋ à və̀ ŋgòtsəpsə yi. ");
INSERT INTO yam_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tà Jisòs à yə ŋwà nə, nə koksə manziŋ bohònà' nə dʉk fa nà' də, <<Tsəp, kà wa.>> ");
INSERT INTO yam_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yi lo, nə kə jwɛŋ ŋkùp nə̀ vèŋ ŋwə̀ nə cu ca nə. Bʉ̀ʉ sə̀ wo à sə bə̀k tse' ŋkùp nə wèŋ à foho təəŋ, fana yi dʉk də, <<Wà'ŋwè, mʉ̀ sə cèp bohòwù də, yə̀ə nə lokok.>> ");
INSERT INTO yam_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ŋwə̀ nə à lòkok cu mʉtsə̀, nə ye ŋgòcèp cù. Jisòs jəŋ yi, nə fa yi bohòma ye. ");
INSERT INTO yam_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wʉə à ko bwìŋ pwe' fana wo kuksə Nwì. Wo sə dʉk də, <<Ŋgà tsòhòbum Nwì mòk nə̀ ghaŋ tesə mʉtsətsə'rə vesùwèŋ laŋ. A yè'sə də Nwì a və̀ ŋgòtɛsə bʉ̀ʉ ye wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nzu bum sə̀ Jisòs à gʉ̀ yè'sə à yuhu mvwe' nzeŋgòŋ Jùdiyà nə ye lak sə̀ yà' kʉəp Jùdiyà pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ŋgàa fàak Jon wèŋ ànə yuk bum sə̀ Jisòs à sə gʉ̀ʉ fana wo və, nə tsok fa Jon. Jon to ŋgàa fàak ye mok ba, ");
INSERT INTO yam_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nə tum wo bohòTà Jisòs də wo kə fek nà' də, <<Wu yà'sə ŋwə̀ nə̀ wo à dʉk də yi nə̀ və̀ə nə, kè vèes sə kʉk də yi cu ntòzok ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wo kə̀ dzèŋ bohòJisòs, fana wo dʉk fa yi də, <<Jon ŋgà bàptɛsə̀ bwìŋ tum və̀ ves də vèes kə fek wu də, wu yè'sə ŋwə̀ nə̀ wo à dʉk də yi nə̀ və̀ə nə, kè vèes kʉk də yi cu ntòzok ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","À ye mègù sə̀' mvə̀k ànə fana Jisòs gʉŋsə bʉ̀ ŋgàa yiyaŋ wèŋ ŋkʉ̀ʉŋntɛ̀ŋ, nə bɛ'fis ze' ndzə ni'ì bwìŋ, nə muk lis bʉ̀ʉ sə̀ yà' ànə loho sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","À kə̀ dzèeŋ fana Jisòs dʉk fa wo də, <<Wèeŋ du, nə kə tsok fa Jon yusə̀ wèŋ yuk, nə ye sə̀ wèŋ yə bə lis awèŋ. Bʉ̀ʉ sə̀ wo à loho lis wèŋ sə yə fe'lə bum sə̀mok, bʉ̀ʉ sə̀ wo ànə sə kà gìgə̀ sə gìi, ŋgàa kuturu wèŋ sə gʉŋ. Bʉ̀ʉ sə̀ wo à loho ntu' wèŋ sə yuk fe'lə bum, mʉ̀ sə lòkoksə bwìŋ mvwe' kpʉ, nə sə tsoho fa ŋgàa jìŋ wèŋ Ntirə̀ nə̀ Bə̀boŋ nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nə tsok ləsə fa yi də mʉ̀ dʉk də, rɛŋsi bohòŋwə̀ nə̀ yi ka məmərə̀ sə ntʉʉ̀ yi bʉ̀ʉ mʉ̀ tse' lok.>> ");
INSERT INTO yam_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ghà nə̀ ŋgàa fàak Jon sə à bwì foho lòfana Jisòs ye ŋgòtsòho fa bʉ̀ʉ sə̀ fo' bə liŋ Jon nə. Yi sə cep də, <<Wèŋ ànə lo ŋgəà fa' ŋgòkə̀ ja'a yà? À ye ŋgòkə̀ ja'a ŋwə̀ nəmòk nə̀ yusə̀ bwìŋ cèep, yi sə dzəm kɛ' gu yusə̀ wo sə cèep sə nduk à? Ka lɛ vɛ'nə yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ye də wèŋ ànə lo ŋgòkə̀ ye yè'sə yu yà lɛ? Ànə ye də wèeŋ kə ye ŋwə̀ nəmòk nə̀ yi à ni tse' cə̀ək sə̀ bə̀boŋ à? Nə yeè nə sə̀' də nsàp bʉ̀ʉ sə̀ wo nigə̀ cə̀ək sə̀ bə̀boŋ, nə sə zʉ ghàk awo yè'sə kà ŋgəà cugə̀. Wo cugə̀ ma mʉmvwe' nto'o ŋkum wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ye də wèŋ ànə tesə lo yè'sə ŋgòyə yà? À ye ŋgòkə̀ yə ŋgà tsòhòbum Nwì à? Ŋ̀, a vɛ'nə zìnə, yi yam gha' ŋgàa tsòhòbum Nwì nsàp nə̀ wèŋ rì yàwèŋ ànə laŋ. ");
INSERT INTO yam_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nà'a yi nə̀ wo à còm nòŋsə bum mok ndzənə ŋwàk Nwì bə liŋ ye nə. Wo à còm yusə̀ Nwì à cèp də, <Nè'e masinjà àm, mʉ nə tum gesə lo yi mantombìi wù ŋgògʉ̀ fʉ̀hʉ tsə'rə fa wu mandzə̀.> >> ");
INSERT INTO yam_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Fana Jisòs nə cep mali sə̀mok də, <<Mʉ̀ sə tsə̀' weŋ də, bwe sə̀ wo à dzə wo sə nzeŋgòoŋ fɛŋ pwe'fo', wo ka mòk nə̀ yi càsə Jon ntòdzə. Yi ye-a sə̀' vɛ'nə fana ŋwə̀ nə̀ də yi jə'rə càsə gha' mvwe' gaŋ ŋkum Nwì yi nə yam ghak Jon nə.>> ");
INSERT INTO yam_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bʉ̀ ŋgàa ko tas bə bʉ̀ʉ sə̀ wo à ye fo' pwe' ànə rɛɛŋ bum yè'sə fana wo kwasə Nwì. Wo ànə kwasə Nwì də fàak sə̀ Jon à gʉ̀ʉ sə yà'a bə̀boŋ. Wo ànə ye bʉ̀ʉ sə̀ wo ànə baptɛsə bohòJon. ");
INSERT INTO yam_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fana bʉ̀ʉ Faràsi bə bʉ̀ ŋgàa yə'rə̀ fa bwìŋ lʉ̀k Nwì wèŋ à bɛ̀ŋ yusə̀ Nwì à fʉ̀hʉ noŋsə fa wo sə, bə mandzə̀ nə̀ də Jon kà wo baptɛsə. ");
INSERT INTO yam_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisòs dʉk də, <<Aco mʉ̀ fʉhʉ kok ŋgwì bʉ̀ʉ sə̀ niè' yè'sə bə yà lɛ-o? Wo səsə yè'sə yà? ");
INSERT INTO yam_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wo yè'sə co bwe mok sə̀ wo tə mʉ ntɛɛ̀ŋ, nə sə dʉk fa ŋge' awo də, <Vès yəm ŋkìi sə̀ wo fisgə̀ ŋwàŋwè fo', wèŋ kà dzèŋ nə kà. Vès yəm ŋkìi kpʉ, wèŋ kà mbɛŋ sə̀' kom lok.> ");
INSERT INTO yam_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mʉ̀ dʉk vɛ'nə bʉ̀ʉsə̀ Jon nə ànə və ye, yi kà rùk sə no, nə sə dzə zʉzʉ. Wèŋ à yə vɛ'nə, wèŋ də yi tse' yòŋsə̀ ze' ndzə ni'ì yi anə. ");
INSERT INTO yam_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mʉ̀ʉ Mo Ŋwè, mʉ̀ a və̀ yàm, mʉ̀ sə zʉ bɛŋ, nə sə no rùk sə̀'. Bwìŋ à yə vɛ'nə, wo dʉk də, <Wèeŋ ye ŋgà no jʉhʉ rùk bə tà zʉ bum, kà ze' mòok nè'.> Wo to mʉ də ŋge' ŋgàa gʉ̀ bʉp bə ŋgàa ko mbàam tas wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mègù də yumok kə̀ lə̀gə̀ ŋkuŋ bwìŋ riŋ də a bə̀boŋ kè bʉp àlɛ'.>> ");
INSERT INTO yam_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ŋwə̀ə Faràsi nəmòk à to Jisòs də nà'a və bə nà'a kə zʉ zʉzʉ mʉ nda'à yi, fana Jisòs lo mʉ nda'à yi anə, nə cum nze də bə yà'wèeŋ zʉ. ");
INSERT INTO yam_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ŋwà nəmòk nə̀ yi à ye ŋwà sàhà mvwe' lak yà'sə yuk də Jisòs sə zʉ zʉzʉ mvwe' ndap ŋwə̀ Faràsi anə. Yi jəŋ və ndo làmindà nə̀ wo ywigə̀ nà' mbàm ŋkʉ̀ʉŋ, ");
INSERT INTO yam_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","nə kə təəŋ kok fʉ ŋkwɛ̀ŋ Jisòs mvwe' kùu ye. Yi ye ŋgòwa, nə sə tsəp kùu Jisòs bə ndzəplis ye sə, nə sə yisə yà' bə nʉ̀əmtu ye. Yi sə kum kùu Jisòs sə bə ŋgùpcù ye, ŋgònìtsə̀' də yi sə wəp nà', nə sə yok yà' bə làmindàa sə. ");
INSERT INTO yam_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ŋwə̀ Faràsi nə̀ yi à to Jisòs nə ànə ye vɛ'nə fana yi dʉk sə və̀ə yi də, <<Ŋwə̀ ènə nə ye-a ŋgà tsòhòbum Nwì, bwɛ̀rɛ yi rì də ŋwà nə̀ nà' sə jwɛ̀ŋ yi ènə ŋwà sàhà laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisòs to yi də, <<Saimʉ̀, mʉ̀ tse' yumok ŋgòtsə̀' fa wu.>> Saimʉ̀ fek bwi ye də, <<Cicà, yusə də yà?>> ");
INSERT INTO yam_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisòs də, <<Ŋgà samsə fa bwìŋ mbàm mòk à tse' ŋgàa kəa ba. Yi sə bɛ' ŋgà kəa mòk bàam mbàm tàŋ, nə bɛ' megu mòk nə ncùhù hum tàŋ. ");
INSERT INTO yam_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wo kà yà' là' to, fana yi swi fa yà' ba fo'. Bohòbʉ̀ʉ sə̀ ba yè'sə, anə dzəm ghak yi nə̀ fò?>> ");
INSERT INTO yam_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yi də, <<Mʉ̀ tsəm də, a ŋwə̀ nə̀ wo swifa yi mbàm ŋkʉ̀ʉŋ nà'a.>> Jisòs də, <<A zìnə.>> ");
INSERT INTO yam_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yi bʉʉŋ kʉk ŋwà nə, nə dʉk fa Saimʉ̀ də, <<Wù sə yə ŋwà nè'e nà? Mʉ̀ və̀ mʉ nda'à wù fɛn, wù kà mʉ ndzəp sə̀ wo cùkgə̀ kù bə zeŋ fa. Fana ŋwà nè'e cùk fa mʉ kùu sə bə ndzəplis ye, nə yisə fa mʉ yà' bə nʉ̀əmtu ye. ");
INSERT INTO yam_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mvəsə̀ wo cèpsəgə̀ ŋwè, nə jwɛŋ yi bə ŋgùpcù yà'a, wù kà mʉ vɛ'nə sə̀' cèpsə̀. Mvə̀'nə̀ yà' yè yèe, yi ka ŋgòjwɛ̀ŋ kùu am bə ŋgùpcù ye teŋsə. ");
INSERT INTO yam_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wù ka tu am bə mve' yok fana ŋwà nè'e yok kùu am bə làmindà. ");
INSERT INTO yam_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ye də mʉ̀ sə tsə̀' wu də, bʉp sə̀ ŋwà nè'e à gʉ̀ yà' ŋkʉ̀ʉŋ sə, wo swìfa yi yà' laŋ. Yè'sə rɛɛŋ də a vɛ'nə bʉ̀ʉ nsàp dzədzəm nə̀ ŋkʉ̀ʉŋ nə̀ yi nìtsə̀' ènə. Fana ŋwə̀ nə̀ wo swìfagə̀ yi momjo, nìtsə̀'gə̀ sə̀' dzədzəm nə̀ momjo.>> ");
INSERT INTO yam_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Fana Jisòs bʉʉŋ dʉk fa ŋwà nə də, <<Mʉ̀ swìfa wu bʉp yo laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bʉ̀ʉ mok sə̀ wo à ye bə Jisòs wèŋ sə à yuk vɛ'nə fana wo sə cèp də, <<Nè'nə yè'sə ndà, nə̀ aco yi swifa ŋwè bʉp ye-ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jisòs tsok fa ŋwà nə də, <<Mvə̀'nə̀ wù fa ntʉm yòbohòmʉ̀ fana yà' fa wù lùŋ. Gèŋ bə̀boŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","À cu momjo fana Jisòs bə ŋgàa fàak ye sə̀ hum-ncòp-ba sə wèŋ à gìhi kɛ' mʉmvwe' buhu lak sə̀ yà' à ye fo' sə. Jisòs sə tsoho Ntirə̀ nə̀ Bə̀boŋ nə̀ nà'a bə gaŋ ŋkum Nwì. ");
INSERT INTO yam_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Fana bə̀ba səmok à sə gì bə Jisòs nə. Bə̀ba yè'sə, Jisòs ànə bɛ'fis fa wo yòŋsə̀ə ze' ndzə ni'ì wo, nə mesə fa wo yiyaŋ awo sə̀'. Mòk à ye fo' Mèri Màdàlinà nə̀ ze' sàmba à tesə ndzə ni'ì yi nà'a. ");
INSERT INTO yam_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Mòk à ye Jòanà nə̀ yi à ye ŋgwe Cuzà, mofàk ŋkum Herò, nə̀ yi à sə kʉ̀kgə̀ lis bə ndap Herò. Sùsanà à ye sə̀' fo', bə bə̀ba səmok ŋkʉ̀ʉŋ. Wo à sə jə bum awo sə̀ wo tse', nə sə tɛsə Jisòs bə ŋgàa fàak ye wèŋ bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bwìŋ à sə və̀ bohòJisòs mvwe' bòop lak zəzok, fana wo à kə̀ màa, Jisòs cèp bohòwo bə gbʉ'. ");
INSERT INTO yam_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Yi à cèp də, <<Ŋgà bì ŋgwìi bum mòk à lòŋgòkə̀ ŋwə̀ ŋgwìi bum ye. Mvə̀'nə̀ yi à sə ŋwə̀ yà' fana ŋgwìi bum mok gbʉ sə mandzə̀. Bwìŋ sə nərə yà' bə kù, fana swiŋ dzooŋ və, nə kə te' zʉ lo yà'. ");
INSERT INTO yam_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mok gbʉ mvwe' lìs, nə to. Mvəsə̀ yà' à sə kùu', fana yà' yum, bʉ̀ʉ jì ndzəp. ");
INSERT INTO yam_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mok gbʉ mvwe' ndik, nə kuk. Yà' kuk bə ndik sə, fana ndik sə lim zə yà', yà' kpʉ. ");
INSERT INTO yam_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mok gbʉ mvwe' nze nə̀ bə̀boŋ, nə kuk, nə zəm ŋgwì co ŋkʉ̀ mò'fis.>> Jisòs ànə dʉk wes vɛ'nə fana yi cep torə fis bə ŋàŋ də, <<Ŋwə̀ nə̀ wù tse'-a ntu' ŋgòyuk yusə̀ mʉ̀ cèp yè'sə, wù yuk.>> ");
INSERT INTO yam_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ànə geŋ ŋgàa fàak ye wèŋ fek yi də gbʉ' ènə yè'sə dalɛ? ");
INSERT INTO yam_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yi dʉk fa yà' də, <<Nwì à gʉ̀ weŋ yàwèŋ ŋgòrì bum səmok bə gaŋ ye sə̀ yà'a sə̀swihì bohòbʉ̀ʉ səmok. Fana bʉ̀ʉ sə̀ wo yàwo sə mbiŋ, wo sə kʉk nə kʉk, nə kà bum sə yə, wo sə yuk nə kà rɛɛŋ. ");
INSERT INTO yam_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","<<Mbwè gbʉ' nə nè'. Ŋgwìi bum sə ncèp nə̀ Nwì. ");
INSERT INTO yam_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ŋgwìi bum sə̀ yà' à gbʉ sə mandzə̀, a bʉ̀ʉ sə̀ wo a yuk ncèp Nwì, Satà və, nə kə jəŋ gɛsə ncèp nə sə ntʉʉ̀ wo, ya kà də wo dzəm ncèp nə, nə tse' lùŋ dʉk. ");
INSERT INTO yam_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mok sə̀ yà' à gbʉ̀ mvwe' lìs, a bʉ̀ʉ sə̀ wo yuk ncèp nə̀ Nwì, nə dzəm bə kwəkwa, fana nà' kà ŋgàŋ sə ntʉʉ̀ wo sò. Yè'e bʉ̀ʉ sə̀ wo dzəmgə̀ mvə̀k momjo, ŋga mə̀mumsə̀ və̀ə fana wo gbʉ gɛsə lo fo'. ");
INSERT INTO yam_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ŋgwìi bum mok sə̀ yà' à gbʉ̀ mvwe' ndik yà'a, a bʉ̀ʉ sə̀ wo yuk, wo cu fana bum nzeŋgòŋ lim te'lə tse' ncèp nə. Bum nzeŋgòŋ sə, a bum sə̀ ŋwè sə tsərə ŋgògʉ̀ yà' nùumbu pwe', bə ntʉm nə̀ ŋgòtse' ghàk, nə ye ntʉm nə̀ ŋgòyu' lʉ̀ʉm sə̀ sənə nzeŋgònə. Yà'a bum sə̀ yà' lim tè'lə tse' ncèp nə fana nà' kà kùk. ");
INSERT INTO yam_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nə ye də, ŋgwìi bum sə̀ yà' à gbʉ̀ yàwo mvwe' nze nə̀ bə̀boŋ, a ntʉʉm bʉ̀ʉ sə̀ wo yuk ncèp Nwì, fana wo ko ntʉm, nə kotse' yà' cʉ̀k bə ntʉm nə̀ zìnə, nə zəm nto'. ");
INSERT INTO yam_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","<<Kaco ŋwè bwe' lam, nə fə'ə lok nà' sənə yumok yeŋ. Kaco yi tes nà' sə mbwè kè sə̀' yeŋ. Yi nə tes nà' mʉnə dak, ya ŋga bwìŋ ni və̀ə, nà' sə rɛɛŋ bohòwo. ");
INSERT INTO yam_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yà' cu sə̀' də yumok sə̀ yà'a sə̀swihì, də yà'a nə kà kə̀ yəə̀ŋ ka yeŋ. Yumok sə̀ də wo fə'ə lok yà' də bwìŋ nə kà yà' jəja yəə bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ye də wèeŋ sə jəŋ ŋkərə̀ mvəsə̀ wèŋ sə yuk bum, bʉ̀ʉsə̀ ŋwə̀ nə̀ yi tse'-a yumok, Nwìi nə jo naaŋ fa fe'lə yi mok sə̀' ya yi tse' ŋkʉ̀ʉŋntɛ̀ŋ. Nə ye də ŋwə̀ nə̀ yi ka ye yumok tse' fana Nwìi nə jəŋ gɛsə nə̀ momjo nə̀ yi tsəm də yi tse' nə.>> ");
INSERT INTO yam_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ma Jisòs bə bwema ye wèŋ à və̀ ŋgòkə̀ yə yi, fana wo kà yi yə, bʉ̀ʉsə̀ bwìŋ à ye fo' ŋkʉ̀ʉŋ. ");
INSERT INTO yam_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wo tsok fa Jisòs də, <<Ma yo bə bwema yo wèŋ tə sə mbiŋ, wo sə dzəm ŋgòyə wu.>> ");
INSERT INTO yam_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisòs dʉk fa wo də, <<Ma am bə bwema am wèeŋ bʉ̀ʉ sə̀ wo yuk ncèp Nwì, nə gʉ sə̀' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nùmbu mòk à ye Jisòs bə ŋgàa fàak ye ni sənə ŋgwes. Yi tsok fa yà' də, <<Vesùwèeŋ to lo ndzə ŋgʉ ndzəp mamòk.>> Mvə̀'nə̀ wo à sə lòo, fana yi dzəm lo. ");
INSERT INTO yam_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wo à sə lòsə ŋgwesə̀ anə fana, fə̀fə̀ nə̀ bʉp tseŋ wo, nə sə ci rwiŋsə ŋgwes nə bə ndzəp, fana nà' ye co nà'a nə cəəŋ. ");
INSERT INTO yam_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wo lo kə to yəmsə Jisòs, nə dʉk fa yi də, <<Tà, vesùwèŋ sə kpʉ yè'e kpʉ.>> Jisòs à lòkok mʉtsə̀, nə dʉk fa fə̀fə̀ nə dʉk də, <<Teŋsə, kà mok cà fe'lə̀,>> nə dʉk bohòndzəp sə̀' dʉk də, <<Naaŋ yòsə̀' gəe'.>> Fə̀fə̀ à dʉk gù dok, fana cì'i təəŋ fo' mok wʉmm. ");
INSERT INTO yam_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Fana yi fek yà' də, <<Kaco wèŋ dzəmtse' bohòmʉ̀ yeŋ yè'sə bʉ̀ʉ yà?>> Ŋgàa fàak ye wèŋ wəp, nə mərə də, <<Nè'e nsàp ŋwə̀ nə̀ fònə̀ yi cèep, fə̀fə̀ bə ndzəp pwe' sə yuk yi-ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Wo à to tesə lònto ndzəp ma nja, nə kə tesə və mvwe' lak Gerasàn. Lak yè'sə yà'a ma ndzə nto ndzəp mvwe' nze Galìli. ");
INSERT INTO yam_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisòs tesə sənə ŋgwes nə, fana yi kʉrə bə ŋwə̀ nəmòk nə̀ yi tesə mvwe' lak yà'sə ŋga nà' tse' yòŋsə̀ə ze' ndzə ni'ì yi. À sàp ŋkʉ̀ʉŋntɛ̀ŋ ŋga ŋwə̀ ènə sə gì ni' to, nə kà nda'à sə cu. Yi sə nooŋ kɛ'lo mvwe' sə̀ wo tuuŋgə̀ bwìŋ. ");
INSERT INTO yam_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yi ànə ye Jisòs fana yi gbʉ tsoŋ sə nze ŋgʉ ni'ì nà', nə sə waŋ furə fis də, <<Jisòs mo Nwì nə̀ ghaŋ, wù sə làp bohòmʉ̀ yà? Mʉ̀ lɛŋ wu də wu kà mʉ ŋgə' fa.>> ");
INSERT INTO yam_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yi à dʉk vɛ'nə bʉ̀ʉsə̀ Jisòs à dʉk fa yòŋsə̀ ze' nə də nà'a tesə ndzə ni'ì yi anə. Ze' nə ànə sə ci' kotse' ŋwə̀ nà'nə kɛ̀' ŋkʉ̀ʉŋntɛ̀ŋ fana wo à sə kì yi bo bə kù lòoŋfo' bə kwaŋ nə sə kʉk yi, fana yi sə sòoŋ tirə yà' pwe' ze' nə sə jamsə lo yi ŋgəà. ");
INSERT INTO yam_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisòs fek yi də, <<Liŋ yoo ndà?>> Yi dʉk də, <<Liŋ aam Bòp.>> Yi dʉk vɛ'nə bʉ̀ʉsə̀ ze' sə à ye ndzə ni'ì yi anə ŋkʉ̀ʉŋ. ");
INSERT INTO yam_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ze' sə lɛŋ Jisòs də nà'a kà wo sə mvwe' wʉ sə̀ cəco yà'a gèsə̀ lò. ");
INSERT INTO yam_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ŋgùnaaŋ mok à ye fo' ŋkʉ̀ʉŋntɛ̀ŋ ŋga wo sə zʉ mvwe' mbwè nda mòk fo'. Fana ze' sə lɛŋ Jisòs də nà'a me'rə wo, wo kə ni ndzə ni'ì ŋgùnaaŋ sə. Jisòs dzəm fa wo. ");
INSERT INTO yam_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ze' sə tesə ndzə ni'ì ŋgà' nə, nə kə ni ndzə ni'ì ŋgùnaaŋ sə. Ŋgùnaaŋ sə à ca du'rə tsoŋ ndzə baàŋ anə, nə kə gbʉ kpʉ lo wes sənə ndzəp Galìli. ");
INSERT INTO yam_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bʉ̀ʉ sə̀ wo à sə gʉ̀msə ŋgùnaaŋ sə à carə lòo, nə kə tsoho fa bʉ̀ʉ sə̀ mvwe' lak yà'sə pwe'. ");
INSERT INTO yam_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Fana bwìŋ tesə və ŋgòkə̀ ja'a nsàp yu nə̀ nà' gʉ̀ nə. Wo à və̀ bohòJisòs, nə ye ŋga ŋwə̀ nə̀ yi ànə tse' yòŋsə̀ ze' ndzə ni'ì yi nə ŋga yi cu kok ŋgʉ ŋki'ì Jisòs, nə ni tse' cə̀k, nə cum fe'lə bə ŋkərə̀ ye bə̀boŋ làaŋ vɛ'. Fana wʉə ko wo nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bʉ̀ʉ sə̀ wo à yə bum yè'sə à tsòho fa bʉ̀ʉ sə̀ wo à və̀ə yusə̀ Jisòs gʉ̀ bohòŋgà' ànə. ");
INSERT INTO yam_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bʉ̀ʉ sə̀ mvwe' ntòlak Gerasàn wèŋ à wəp vɛ'ɛ, nə dʉk fa Jisòs də nà'a lo gɛsə fo'. Yi ni ŋgwes, nə bwi foho lo yuye. ");
INSERT INTO yam_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ŋwə̀ nə̀ ze' à tesə ndzə ni'ì yi nə à lɛŋ Jisòs də bə nà'a lo. ");
INSERT INTO yam_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Jisòs à tum fəsə yi maŋkwɛ̀ŋ, nə tsok fa nà' də, <<Dù la'à wù, nə kə tsok fa bwìŋ yusə̀ Nwì gʉ̀ bohòwù.>> Yi à lòo, nə kə tsok fa bwìŋ mʉ ntòlak pwe' yusə̀ Jisòs gʉ̀ bohòyi sə. ");
INSERT INTO yam_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisòs à to tə̀m nə, nə bwi foho və fana, bòp bʉ̀ nə̀ wo à ye fo' nə à kwa ŋgòyə yi wùriŋ, bʉ̀ʉsə̀ wo à sə tək yi. ");
INSERT INTO yam_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ŋwə̀ nəmòk à və̀ fo' nə̀ wo to yi də Jairòs. Ŋwə̀ ànə ànə ye ŋkwà' ŋwə̀ nəmòk mʉnə ndap pìriyà. Yi à yə Jisòs ntɛ̀ŋ, yi kə gbʉ nooŋ mantombìi nà', nə lɛŋ nà' də nà'a və mʉ ndà'à yi, ");
INSERT INTO yam_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","bʉ̀ʉsə̀ mo ye à ye mvə̀k kpʉkpʉ. Yi à tse' mègù mo nə̀ mò'fis ànə ŋga nà'a ŋwàŋwè. Mo nə à ye lùumŋgòŋ hum-ncòp-ba. Jisòs à lòbə Jairòs nə fana bwìŋ yuŋ yi, nə sə bwi'lə yi nsàp nə̀ co ndùrə̀ to yi. ");
INSERT INTO yam_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ŋwà nəmòk à ye fo' nə̀ ndʉəm à sə ca yi ndzə ni'ì mʉnə lùumŋgòŋ hum-ncòp-ba. Ŋwə̀ nə̀ ŋgòfa yi ncə̀p ŋga yà'a me kà ye. ");
INSERT INTO yam_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yi à nɛɛ və̀ fʉ ŋkwɛ̀ɛŋ Jisòs, nə jwɛŋ gesə cù cə̀k nà' bə bo. Mvə̀'nə̀ yi à jwɛ̀ŋ gèsə nà' ntɛ̀ŋ, ndʉəm sə teŋsə ŋgòca. ");
INSERT INTO yam_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisòs fek də, <<Jwɛ̀ŋ mʉ ndà?>> Bwìŋ pwe' à bɛ̀ɛŋ, fana Pità dʉk də, <<Masà, bwìŋ sə bwi'lə wu ma nə̀ fòpwe'.>> ");
INSERT INTO yam_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jisòs dʉk də, <<Ŋwə̀ nəmòk jwɛ̀ŋ mʉ laŋ. Mʉ̀ yuk ŋga ŋàŋ tesə ndzə ni'ì mʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ŋwà nə riŋ də kaco yi swihi yeŋ. Yi və, nə sə kaŋ, nə bʉhʉ mantombìi Jisòs, nə cep fis mvwe' bwìŋ. Yi tsok fa nà' njo nə̀ yi anə jwɛŋ cə̀k nà' nə, də ndʉəm ye sə cì'i sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisòs dʉk bohòmoŋwà nə də, <<Njɛ̀'gù, dzədzəm yònə̀ wù tse' nə gʉŋsə wu laŋ. Dù, gèŋ bə̀boŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisòs à sə dʉk də yi cep mesə bə ŋwà ènə ntɛ̀ŋ, ŋwə̀ nəmòk caŋ və ŋgòtsə̀' fa Jairòs də mo nà' nə kpʉ laŋ. Də nà'a kà cicà nə ŋgə' mok ŋgwàŋ fa yiskok. ");
INSERT INTO yam_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisòs ànə yuk vɛ'nə, yi dʉk də, <<Kà yumok wəp, tse' megu yòdzədzəm fana mo ŋwà nə nə luŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jisòs à kə̀ dzèŋ mvwe' ndap nə, yi kà dzəm də ŋwə̀ nəmòok ni yuŋ lo yi mʉ nda'à anə dzəm. Yi à dzəm də a ni megu Pità bə Jon bə Jem, nə ye ma bə tɛ̀'ɛ mo nə. ");
INSERT INTO yam_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bwìŋ pwe' à sə wa gùrə kpʉ mo nə. Jisòs dʉk fa wo də, <<Wèeŋ kà wa. Mo nə ka kpʉ, yi sə dzəmlo.>> ");
INSERT INTO yam_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bʉ̀ʉ sə à ywì'lə yi swee, bʉ̀ʉsə̀ wo à rì də mo nə kpʉ laŋ. ");
INSERT INTO yam_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jisòs ko mo ŋwà nə bo, nə dʉk də, <<Mweŋ, lòkok.>> ");
INSERT INTO yam_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yòŋsə̀ mo nə à bwìŋ foho və̀ sə̀mok, fana yi lokok kɛ̀' mò'fis. Jisòs dʉk də wo fa mo nə bɛŋ ya yi zʉ. ");
INSERT INTO yam_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ma bə tɛ̀'ɛ mo nə à mərə wùriŋ. Jisòs dʉk fa wo də wo kà ŋwə̀ nəmòk tsə̀' fa. ");
INSERT INTO yam_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisòs to benə ŋgàa fàak ye sə̀ hum-ncòp-ba, nə fa wo ŋàŋ ŋgòjùm fis yòŋsə̀ə ze' pwe' ndzə ni'ì bwìŋ, nə mesə fa bwìŋ yiyaŋ zəzok. ");
INSERT INTO yam_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Fana yi tum lo wo ŋgòtsòho lògaŋ ŋkum Nwì, nə mesə fa bwìŋ yiyaŋ. ");
INSERT INTO yam_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yi tip wo dʉk də, <<Kà yumok bə gì nè'nə jə lo': ntʉmbàŋ-è', bàm-è', zʉzʉ-è', mbàm-è', nə kà cə̀ək nini ba sə̀' jə tse'. ");
INSERT INTO yam_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","A ye-a ŋga ŋwə̀ nəmòk jəŋ weŋ co ŋkʉ̀ìŋ mʉ nda'à yi, fana wèŋ cum megu bə ndap ànə tè wèŋ me'rə ntòlak anə. ");
INSERT INTO yam_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A ye-a ŋga bʉ̀ʉ sə̀ bə ntòlak ànə ka weŋ mvwe' ndap awo dzəm, mvə̀k nə̀ wèeŋ nə me'rə mvwe' ànə, wèŋ kɛ'sə mak nəm mfə̀mfəə kùu awèŋ fo' ŋgònì tsə̀' də wo à ka weŋ fo' dzəm.>> ");
INSERT INTO yam_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Fana ŋgàa fàak Jisòs sə à gì kɛ'cà bohòbwe buhu lak sə̀ fo' sə pwe', nə sə tsoho lo Ntirə̀ nə̀ Bə̀boŋ nə, nə sə gʉ mesə fa bwìŋ yiyaŋ awo pwe'. ");
INSERT INTO yam_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ànə geŋ, Herònə̀ yi à sə sak Galìli yuk bum sə̀ Jisòs bə ŋgàa fàak ye à sə gʉ̀ yè'sə. Fana ŋkərə̀ jip yi vɛ'ɛ, bʉ̀ʉsə̀ bʉ̀ʉ səmok à sə cèp də, Jon ŋgà bàptɛsə̀ bwìŋ a tesə və̀ fe'lə mvwe' kpʉ. ");
INSERT INTO yam_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Fana bʉ̀ʉ səmok sə dʉk kɛ'cà yàwo də yi Àlajà. Mok sə dʉk yàwo də ŋgà tsòhòbum Nwì mòk nə̀ taŋ a lòkok və̀ mvwe' kpʉ. ");
INSERT INTO yam_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ànə geŋ Heròdʉk də, <<Mʉ̀ ànə gwɛ' cokfis tu Jon sə laŋ, ŋwə̀ nə̀ mʉ̀ sə yuk fe'lə nzu ye yè'sə ndà lɛ?>> Fana yi sə lap mandzə̀ ŋgòyə Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ŋgàa ntum Jisòs à bwìŋ və̀, nə kə tsoho fa Jisòs yusə̀ wo gʉ̀ʉ. Fana yi jəŋ wo, nə lo mvwe' buk lak mòk nə̀ wo to fo' də Bèsadà. ");
INSERT INTO yam_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mvə̀'nə̀ bwìŋ à rì də wo à sə lòsə, wo tesə mvwe' buhu lak sə̀ yà' kʉəp fo', nə yuŋ lo wo bə kù. Yi dʉk fa wo də wo və bə̀boŋ, nə ye ŋgòyə'rə wo bum bə gaŋ ŋkum Nwì. Yi sə mesə fa bʉ̀ʉ sə̀ wo tse' yiyaŋ yiyaŋ awo sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mvə̀k à càa, ŋgàa fàak ye və bohòyi, nə dʉk də, <<Tà, tumsə bʉ̀ʉ yè'sə wo lo mvwe' buhu lak nə ye nzum yà'a, ya wo lap yumok ŋgòzʉ, nə lap mvwe' nòòŋ sə̀'. Bʉsə̀ ka fɛɛŋ la'à yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yi dʉk fa wo dʉk də, <<Wèeŋ kʉk fa wo yumok wo zʉ.>> Wo də, <<Vès tse' mègù ntuhu brɛd tàŋ, nə ye fuk ba. Wù dzəm də vèes lo kə bʉpsə mbàm ŋkʉ̀ʉŋ, nə ywiŋ bɛŋ ŋgòfa wo à?>> ");
INSERT INTO yam_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","À ye ŋga bʉ̀ʉ sə̀ wo cu fo' à ye mbəmbam ncùhù tàŋ. Jisòs dʉk fa ŋgàa fàak ye də, <<Cumsə bʉ̀ʉ sə sə nze bə bòp zəzok hum tàŋ, hum tàŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Fana wo cumsə bʉ̀ʉ sə sə nze bə bòp vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Fana Jisòs jəŋ ntuhu brɛd sə̀ tàŋ, nə ye fuk sə̀ ba sə. Yi kʉk gesə lis mʉbu, nə kwasə Nwì, nə bə'rə brɛɛd sə, nə fa ŋgàa fàak ye də yà'a gap fa bʉ̀ʉ sə. ");
INSERT INTO yam_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wo à zʉ wo pwe', nə ze' bə̀boŋ. Wo te'e benə sə̀ yà' à bwehe cu sə kwès hum-ncòp-ba. ");
INSERT INTO yam_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ànə ye mvə̀k nəmòk ŋga Jisòs cu mègù bə ŋgàa fàak ye fana yi sə gʉ pìriyà. Yi fek wo də, <<Bwìŋ dʉkgə̀ də mʉ yè'sə ndà?>> ");
INSERT INTO yam_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wo dʉk fəsə fa yi də, <<Bʉ̀ʉ mok dʉkgə̀ də, wu Jon ŋgà bàptɛsə̀ bwìŋ. Mok dʉk də wu Àlajà, mok dʉk də wu ŋgà tsòhòbum Nwì mòk nə̀ yi à lòkok və̀ mvwe' kpʉ.>> ");
INSERT INTO yam_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Fana Jisòs fek wo də, <<Wèŋ yàwèŋ nɛ? Wèeŋ dʉkgə̀ yàwèŋ də mʉ yè'sə ndà?>> Fana Pità cep fəsə fa yi də, <<Wu Ŋkum ŋgà gèm bwìŋ nə̀ Nwì ànə dʉk də yi nə tum vèsə nə.>> ");
INSERT INTO yam_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Fana Jisòs tipsə wo bə ŋàŋ də wo kà ŋwə̀ nəmòk tsə̀' fa lok. ");
INSERT INTO yam_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nə tsok fa yà'wèŋ də, <<Mʉ̀ nə̀ mʉ mo ŋwè, mʉ nə ye ŋgə' ŋkʉ̀ʉŋntɛ̀ŋ. Fana ŋkwàha bwìŋ bə ŋgàa fa satikà' sə̀ ghaŋ, nə ye bə bʉ̀ʉ sə̀ wo yə'rəgə̀ lʉ̀ʉk Nwìi nə bɛŋ mʉ. Wo nə zə mʉ, fana nùmbu nə̀ tɛ' ye, mʉ lokok mvwe' kpʉ.>> ");
INSERT INTO yam_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Fana yi dʉk fa bwìŋ də, <<A ye-a ŋga ŋwə̀ nəmòk dzəm-a ŋgòyù lòmʉ, fana yi nə bɛŋ to ntòbum sə̀ ni' ye sə dzəm yà', nə bək jəŋ ntə̀əŋ ye nùumbu pwe' ŋkuŋ nə bɛ' və mʉ. ");
INSERT INTO yam_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bʉsə̀ ŋwə̀ nə̀ yi gəhə tse'-a yòŋsə̀ ye fana nà'a nə bisə wà. Nə ye də ŋwə̀ nə̀ yi jə yòŋsə̀ ye co yusə̀ wà bʉ̀ʉ mʉ̀ fana yi nə kə tse' nà'. ");
INSERT INTO yam_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Swe'e sə̀ ŋwèe nə tse' yà, ŋga yi tse'-a nzeŋgòŋ nə pwe'fo', nə kə bisə tu ye ɛ? ");
INSERT INTO yam_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ŋwə̀ nə̀ yi koksə-a marè'tu bohòmʉ̀ nə ye ncèp àm, mʉ̀ nə̀ mʉ mo ŋwè fana ghà nə̀ mʉ bwì və̀ bə ŋàaŋ sə̀ tɛ̀' am fa mʉ, nə ye bə ŋàaŋ sə̀ Tɛ̀' nə, bə ŋàaŋ masinjàa Nwì sə̀ rərɛŋ fana, mʉ̀ koksə marè'tu bohòyi sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nə yeè nə də, mʉ̀ sə tsə̀' fa weŋ ŋkèm dʉk də, bʉ̀ʉ mok tə fɛɛŋ sə̀ wo nə kà kpʉ tə̀tè wo ye gaŋ sə̀ Nwì ŋga yà' sə sak sənə nzeŋgòŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","À cà co nùumbu fwame', fana Jisòs to jəŋ Pità, bə Jem nə ye Jon, bə yà'wèŋ kok lo mʉmvwe' nda mòk ŋgògʉ̀ pìriyà. ");
INSERT INTO yam_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mvə̀'nə̀ yi à sə lɛŋ Nwì fana nsəsə̀ ye kupsə bʉ̀ʉ nsàp mok nə̀ zok, fana cə̀ək sə̀ yi ni tse' mʉ ni'ì yi à bʉ̀ʉŋ fəfop tap tap. ");
INSERT INTO yam_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Wo ye Àlajà bə Musì ŋga wo tesə və̀ mʉbu, bə Jisòs wèŋ sə taaŋ ŋgàm. ");
INSERT INTO yam_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bʉ̀ʉ yè'sə à tse' nsàap nsəsə̀ə sə̀ co marɛŋ. Wo à sə cèp bə mvə̀'nə̀ yi kʉəp ŋgògʉ̀ yusə̀ Nwì ànə dzəm, də yi nə lo mvwe' lak Jòrosalèm, nə kpʉ. ");
INSERT INTO yam_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","À ye ŋga Pità wèŋ sə dzəmlo. Ànə geŋ, wo lokok, nə ye Jisòs bə bʉ̀ʉ sə̀ ba yè'sə ŋga wo tə fo', ŋga nsəsə̀ ye kupsə vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bʉ̀ʉ sə̀ ba yè'sə à yè ŋgòlòo, Pità dʉk fa Jisòs dʉk də, <<Cicà, yà' bòvɛ'ɛ wùriŋ mvə̀'nə̀ vesùwèeŋ fɛnə yè'sə. A ci ba'rə tes bwe duŋ fɛɛŋ tɛ', mò'fis nə̀ njò, mòk nə̀ Musì, mòk nə̀ Àlajà.>> Yi ànə cep tsoŋ gù yè'sə, nə kà yusə̀ yi sə cèp rì. ");
INSERT INTO yam_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mvə̀'nə̀ yi à sə cèep, mbàk və kə təhə lok wo, fana wʉə ko wo. ");
INSERT INTO yam_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Fana wo yuk ŋga ŋgì mòk cèp vesə ndzənə mbàk nə dʉk də, <<Nè'e mo àm, mʉ̀ a cok fis yi. Yusə̀ yi cèp pwe', wèeŋ yuk yi.>> ");
INSERT INTO yam_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wo à yuk ŋgì ènə vɛ'nə, wo kʉ̀ksə kɛ', nə kà ŋwə̀ nəmòk nə̀ zok yə, wo ye megu Jisòs yiìyi. Wo à sə kà bwìŋ yusə̀ wo à yə yà'sə ghà ànə tsòhòfa. ");
INSERT INTO yam_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tsok à rɛŋ, wo à bwi və̀ə, bwìŋ wùriŋ kə̀ tseŋ yi. ");
INSERT INTO yam_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ŋwə̀ nəmòk cèp vèsə mʉtsətsə'rə bʉ̀ʉ sə də, <<Cicà, kwəkwè', kə kʉk mo àm nə̀ mʉ̀ tse' mègù yi. ");
INSERT INTO yam_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yi tse' yòŋsə̀ ze' ndzə ni'ì yi, nə̀ nà'a kogə̀ yi. Nà'a ko yi, yi sə waŋ nə̀bʉp, fana ni' gʉrə yi njʉk njʉk tè sə dùk yi kə̀ cùhu. Nà' sə sərə yi nə kà ŋgòmè'rə yi dzəm. ");
INSERT INTO yam_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mʉ̀ dʉk ŋgàa fàak yo də wo bɛ' fis nà', fana wo ka nà' bɛ' fis to.>> ");
INSERT INTO yam_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisòs dʉk fa wo də, <<Ja'a na mvəsə̀ wèeŋ yè'sə gʉgʉtu, wèŋ ka dzədzəm sə ntʉʉ̀ wèŋ nə̀ co wèŋ gʉŋsə ŋwè fo' tse' ɛ̀. Mʉ nə cum geŋ vesùwèŋ, nə sə ko ntʉm vɛ'nə kə dzeŋ sèŋ? Jəŋ və fa mʉ mo yònə fɛn.>> ");
INSERT INTO yam_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mvə̀'nə̀ wo à sə jə və̀ mo nə, yòŋsə̀ ze' nə ko yi, fana ni' gʉrə wes yi njək njək. Jisòs jwa yòŋsə̀ ànə, nə gʉŋsə mo nə, nə fa nà' bohòtɛ̀' ye nə. ");
INSERT INTO yam_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bwìŋ pwe' à mərə bə ŋàaŋ Nwì sə̀ wo à yə sə. Mvə̀'nə̀ wo à sə mərə vɛ'nə, Jisòs dʉk fa ŋgàa fàak ye wèŋ də, ");
INSERT INTO yam_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","<<Yuk yusə̀ mʉ nə tsok fa weŋ bə̀boŋ. Wo nə fa mʉ̀ʉ mo ŋwè ndzə bohòbʉ̀ʉ mok.>> ");
INSERT INTO yam_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bwe sə à ka bə yusə̀ yi à cèp yè'sə rɛɛŋ. Yà' ànə ye bohòwo sə̀swihì ya wo kà bə zeŋ rɛɛ̀ŋ, fana wo sə koksə wʉə ŋgòfek rɛŋsə. ");
INSERT INTO yam_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","À ye ŋga'a ŋga wo yè ŋgòfenə də ŋwə̀ nə̀ ghaŋ mʉtsətsə'rə wo ndà lɛ. ");
INSERT INTO yam_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisòs à rì yusə̀ wo à sə tsərə sə ntʉʉ̀ wo bə ncèp ènə, fana yi ko lòkoksə tes mo nəmòk də nà'a kə təəŋ ŋgʉ ni'ì yi. ");
INSERT INTO yam_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Fana yi dʉk fa wo də, <<Ŋwə̀ nə̀ yi jə-a nsàp mo nè'nə mʉnə liŋ am, fana ye də yi jə yà'sə mʉ̀. Ŋwə̀ nə̀ yi jə-a mʉ, nə dʉk <Və̀ bə̀boŋ>, fana ye də yi sə dʉk bohòŋwə̀ nə̀ yi à tum mʉ nə sə̀'. Mʉ̀ sə dʉk yè'sə də ŋwə̀ nə̀ yi maŋkwɛ̀ŋ bohòwèŋ pwe', yi ŋwə̀ nə̀ yi nə̀ mantombì yi.>> ");
INSERT INTO yam_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon à cèp bohòJisòs də, <<Cicà, vès yə ŋwə̀ nəmòk ŋga yi bɛ' fis ze' mʉnə liŋ yò. Fana vès dʉk yi də yi teŋsə, bʉ̀ʉsə̀ yi ka mòk mʉtsətsə'rə̀ə vès yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisòs dʉk ye də, <<Kà də wu gʉ co yi teŋsə dʉk, bʉ̀ʉsə̀ ŋwə̀ nə̀ yi ka weŋ bɛŋ, ye də yi cu venəwèŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mvə̀k ànə kʉrə də Jisòs nə kpʉ ya yi lo mʉbu, yi ko ntʉm, nə lokok bɛ' lo mandzə̀ nə̀ nà' lo Jòrosalèm. ");
INSERT INTO yam_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yi tum lo masinjàa mok mantombì də wo lo mvwe' ntòlak Sàmariyà, nə kə gʉ tsə'rə fa yi bum pwe' ŋkuŋ yi və. ");
INSERT INTO yam_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bʉ̀ʉ Sàmàriyà wèŋ bɛŋ də nà'a kà fo' nooŋ, bʉ̀ʉsə̀ wo à yə də yi sə cà lòJòrosalèm. ");
INSERT INTO yam_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jon bə Jem à yə vɛ'nə, fana wo dʉk də, <<Tà, wù dzəm də vèes lɛŋ pìriyà ya ŋga Nwìi tumsə tsoŋ mis mʉbu ŋgòkə̀ tɛ̀ŋ səsə bʉ̀ʉ yè'sə à?>> ");
INSERT INTO yam_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jisòs bʉʉŋ kʉk ja'a wo, nə jwa wo, nə dʉk də, <<Wèŋ ka nsàp yòŋsə̀ nə̀ wèŋ sə cèp bə zeŋ ànə riŋ. Mʉ̀ nə̀ mʉ mo ŋwè, mʉ̀ a ka ŋgòbʉpsə yòŋsə̀ ŋwè və, mʉ̀ a və̀ ŋgòlùŋsə wo lùŋsə.>> ");
INSERT INTO yam_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ànə geŋ, wo lokok, nə lo mvwe' ntòlak nəmòk. ");
INSERT INTO yam_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wo à sə lòmandzə̀ fana, ŋwə̀ nəmòk cep bohòJisòs də, <<Mʉ̀ dzəm də mʉ nə bɛ'lo wu ma nə̀ fòpwe' nə̀ wù sə lòo.>> ");
INSERT INTO yam_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisòs tsok fa yi də, <<Còp wèŋ tse' mvòk co wo cum ca, swiŋ wèŋ tse' ndap awo, fana mʉ̀ʉ mo ŋwè mʉ̀ ka mvwe' sə̀ co mʉ noŋsə tsoŋ tu am, nə nooŋ yoŋsə tse'.>> ");
INSERT INTO yam_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisòs dʉk bohòŋwə̀ nəmòk də, <<Mʉ̀ dzəm də vesùwèeŋ lo, nə fak mvwe' mò'fis.>> Ŋwə̀ ènə dʉk də, <<Tà, mʉ foho lo-a maŋkwɛ̀ŋ, nə kə tuuŋ tɛ̀'làm ŋkuŋ-ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisòs tsok fa yi də, <<Me'rə bʉ̀ʉ sə̀ wo kpʉ laŋ tuuŋ bʉ̀ kpʉkpʉ awo. Bohòwù yò, dù nə kə tsok ncèp nə də ŋkum Nwì nə yè ŋgòsak sə nzeŋgòŋ laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ŋwə̀ nəmòk à yə Jisòs, yi dʉk də, <<Mʉ nə bɛ' wu Tà, fana mʉ̀ sə fek wu də mʉ lo, nə tsok fa bʉ̀ʉ am də wo cum bə̀boŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisòs tsok fa ŋwə̀ ènə də, <<A ye-a ŋga ŋwè yèto ŋgòfàk bohòNwì, nə sə kʉk lis maŋkwɛ̀ŋ, ye də yi ka kə̀kʉrə̀ ŋgòcu mvwe' gaŋ ŋkum Nwì yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yà'sə ànə ca wes fana Tà Jisòs cokfis bwìŋ hum sàmba-ncòp-ba, nə tumsə lo yà'wèŋ ba, ba. Yi à tumsə lòwo ŋgòlòmvwe' buhu lak, nə ye bə mvwe' sə̀ yi nə sə və fo' sə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yi dʉk fa yà'wèŋ dʉk də, <<Nzum sə̀ ŋgòkʉp sə ŋkʉ̀ʉŋntɛ̀ŋ fana bʉ̀ʉ sə̀ ŋgòfàk fo' sə momjo wùriŋ. Ye də wèeŋ lɛŋ bohòTà ŋgà nzum nə də ya yi tumsə ŋgàa fàk wèŋ, ŋgòkə̀ kʉp nzum ye sə. ");
INSERT INTO yam_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yeè, wèeŋ du, mʉ̀ tumsə lòweŋ co nsùŋgaŋ mʉtsətsə'rəə furùk wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ŋwèe kà posà jə, kà bàm jə, kà kùuŋgùp sə̀' jə; nə kà ŋwè mandzə̀ sə̀' cèpsə̀ lok. ");
INSERT INTO yam_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ndap nə̀ wèŋ ni mbwa pwe'fo', wèŋ cepsə wo də, <Fifi ye bohòndap ènə!> ");
INSERT INTO yam_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wèeŋ dʉk vɛ'nə fana a ye-a ŋga ŋwə̀ ŋgà fifi mbwa fana fifi àwèŋ nə, nə ye bohòyi. A ye-a ŋga ŋwə̀ nə̀ vɛ'nə nə mbwa bʉ̀ə̀ fana fifi àwèŋ nə bwi foho və bohòwèŋ. ");
INSERT INTO yam_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cum megu mʉmvwe' ndap ànə, nə sə zʉ, nə sə no yusə̀ wo fa weŋ, bʉ̀ʉsə̀ ŋwèe fak laŋ, wo lak yi. Kà dʉk də wèeŋ coho nooŋ kupsə kɛ'ca ndap dʉk. ");
INSERT INTO yam_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","A ye ŋga wèŋ kə̀ ni mvwe' ntòlak mòk, wo jəŋ weŋ fo' co bwìŋ fana wèŋ zʉ nsàp yu nə̀ wo fa weŋ lòoŋ fo'. ");
INSERT INTO yam_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wèeŋ gʉŋsə ŋgàa yiyaŋ sə̀ wo cu mvwe' lak yà'sə wèŋ, nə dʉk fa bʉ̀ʉ sə̀ fo' sə wèŋ dʉk də, <Gaŋ ŋkum sə̀ Nwì sə yà' kʉəp və̀ bohòwèŋ laŋ.> ");
INSERT INTO yam_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A ye-a ŋga wèŋ kə̀ ni mvwe' ntòlak nə̀ wo ka wèŋ də wèeŋ və bə̀boŋ dʉk fa fana wèŋ sə gihi kɛ' mvwe' mandzə̀ə sə̀ mʉ ntòlak anə sə, nə sə cep dʉk də, ");
INSERT INTO yam_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","<A megu-a sə̀ mfə̀mfəə sə̀ yà' ko kùu avès mvwe' lak awèŋ yà'sə fana vès kɛ̀'sə nòŋsə yà', yà' sə kʉk weŋ. Wèeŋ riŋtse' də gaŋ ŋkum sə̀ Nwì sə yà' kʉəp və̀ weŋ laŋ.> ");
INSERT INTO yam_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mʉ tsok fa weŋ də, nùmbu nə̀ wo sak nzeŋgònə fana anə boŋ ghak bohòlak Sodòm nə noŋsə nsàp lak ànə. ");
INSERT INTO yam_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","<<Wèŋ bʉ̀ʉ Corazì, wèŋ cu bʉp! Wèŋ bʉ̀ʉ Bèsadà, wèŋ cu sə̀' bʉp! A vɛ'nə bʉ̀ʉsə̀ nsàap bum maŋgəŋgèeŋ sə̀ wo a gʉ̀ tsə̀' fa weŋ yà'a, wo ànə gʉ tsok fa-a yà' bohòbʉ̀ʉ Tayà bə Sidòŋ wèŋ bwɛ̀rɛ də wo a kupsə, nə bwi fa bʉp awo ŋkwɛ̀ŋ tè, nə ni tse' gàa cə̀k, nə yok və. ");
INSERT INTO yam_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nùmbu nə̀ wo nə sak nzeŋgòŋ fana anə boŋ ghak bohòbʉ̀ʉ Tayà bə Sidòŋ nə noŋsə weŋ. ");
INSERT INTO yam_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Wèŋ bʉ̀ʉ Kàpanùm, wèŋ a sə nɛ̀ni' co wèŋ də wèeŋ kok lo mʉbu à? Wèeŋ nə lo tsətsoŋ mvwe' ŋgə' vɛ'ɛ bòŋ. ");
INSERT INTO yam_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","<<Ŋwə̀ nə̀ yi yuk-a weŋ, ye də yi yuk mʉ. Ŋwə̀ nə̀ yi dzeeŋ-a weŋ, ye də yi dzèeŋ mʉ; nə ye də ŋwə̀ nə̀ yi dzeeŋ-a mʉ, ye də ŋgə̀ŋgàŋ dzèeŋ ŋwə̀ nə̀ yi a tum və̀ mʉ nə.>> ");
INSERT INTO yam_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bʉ̀ʉ sə̀ hum sàmba-ncòp-ba sə wèŋ à bwìŋ və̀ bə kwəkwa. Wo à dʉk də, <<Tà, yòŋsə̀ə ze' wèŋ ye bohòvès yusə̀ wà bʉ̀ʉ liŋ yo.>> ");
INSERT INTO yam_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yi dʉk fa yà'wèŋ dʉk də, <<Mʉ̀ yə Satà ŋga yi sə gbʉ̀ tsə mʉbu co mbʉ̀ŋ sə ba'a tsə yi. ");
INSERT INTO yam_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yeè, mʉ̀ a fa weŋ ŋàŋ ŋgògì cà mʉnə no bə ŋgam wèŋ, nə ye ŋàŋ ŋgògha' ŋàaŋ sə̀ bʉ̀ʉ sə̀ wo bɛ̀ŋgə̀ weŋ tse' yà' pwe'fo'. Kaco yumok gʉ lok weŋ yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nə yeè nə də kà də wèeŋ sə kwa də bʉ̀ʉsə̀ ze' wèŋ sə wəp weŋ dʉk, wèeŋ kwa lɛ bʉ̀ʉsə̀ də wo còm nòŋsə liŋ awèŋ mʉbu.>> ");
INSERT INTO yam_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ghà ànə à ye, Yòŋsə̀ nə̀ Rərɛŋ nə gʉ Jisòs yi rwiŋ bə kwəkwa fana yi cep dʉk də, <<Mʉ̀ kwasə wu tɛ̀', nə̀ wu Tà mʉbu bə sə nze nə, bʉ̀ʉsə̀ wù a swìhi gɛsə bum yè'sə bohòŋgàa ŋkərə̀ wèŋ, nə niŋ fa yà' bohòbwe sə̀ lʉə wèŋ. A zìnə Tɛ̀', wù a gʉ̀ yè'sə mʉmvə̀'nə̀ yà' a bòkok wu sə və̀ə wù vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tɛ̀' am a fa wes mʉ bum pwe'fo'. Ŋwə̀ nəmòk ka mwe nə riŋ, rì mègù yi Tɛ̀' nə. Ŋwə̀ nəmòk ka Tɛ̀' nə sə̀' riŋ, rì mègù yi mwe nə, nə ye bʉ̀ʉ sə̀ mwe nə dzəm də yi niŋ tsok fa yà'wèŋ sə.>> ");
INSERT INTO yam_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ànə geŋ yi bʉʉŋ dʉk swihi fa ŋgàa fàak ye sə wèŋ dʉk də, <<A rɛŋsi bohòŋwə̀ nə̀ yi yə bum sə̀ wèŋ sə yə yè'sə! ");
INSERT INTO yam_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mʉ tsok weŋ də ŋgàa tsòhòbum Nwì wèŋ, nə ye bə bʉ̀ ŋkəŋkum wèeŋ ŋkʉ̀ʉŋntɛ̀ŋ sə̀ wo a dzəm ŋgòyə bum sə̀ wèŋ yə yè'sə, nə kà mandzə̀ nə tse'. Wo dzəm ŋgòyuk bum sə̀ wèŋ sə yuk yè'sə, nə kà yà' sə̀' yuk.>> ");
INSERT INTO yam_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ŋgà yə'rə̀ fa bwìŋ lʉ̀k mòk à lòkok də yi bʉə ja'a Jisòs nə fana yi fek nà' də, <<Cicà, yusə̀ aco mʉ̀ gʉ yè'sə yà, ya mʉ kə tse' lùŋ nə̀ nà'a nə̀ kà mè yuk nə ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisòs fek bʉsə bwi nà' də, <<Wo à còm nòŋsə ndzənə lʉ̀k də yà? Wu tagə̀ nja da?>> ");
INSERT INTO yam_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ŋgà' nə dʉk də, <<Wù tse' ŋgòdzəm Tà Nwì yòbə ntʉm yòpwe'fo', dzəm yi bə yòŋsə̀ yòpwe'fo', nə ye bə ŋàaŋ yo pwe', nə ye bə ŋkərə̀ yòsə̀' pwe'fo', fana nə dzəm moma yo co mvə̀'nə̀ wù dzəm ni' yò.>> ");
INSERT INTO yam_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisòs dʉk fa nà' də, <<Wù cèp bə̀boŋ laŋ; gʉ̀ vɛ'nə ya wu nə tse' lùŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ŋgà' nə à dzəm də yi niŋ tsok də yi ŋwə̀ nə̀ bə̀boŋ, fana yi fek fe'lə Jisòs nə də, <<Moma am nə yè'sə ndà?>> ");
INSERT INTO yam_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisòs tsok bʉsə fa yi gbʉ' mòk də, <<Ŋwə̀ nəmòk à tsə mʉ Jòrosalèm ŋgòlòJèrikù. À kə̀ wɛ̀s mandzə̀, ŋgàa yə̀ wèŋ ko fweŋ fis yi cə̀k pwe', nə ləp yi. Wo me'rə mak noŋsə yi ŋga yi sə tʉ̀hʉ mègù mok ŋgwàŋ, nə lo yu awo. ");
INSERT INTO yam_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mvə̀k à càa, ŋgà fa satikà' mòk à sə yù tsə lòsə̀' mandzə̀ ànə. Yi ànə ye nà' ŋga nà' nòo fana yi lək ca yuye ndzə ŋgʉ mandzə̀. ");
INSERT INTO yam_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ŋwə̀ə Levì mòk à gʉ̀ sə̀' vɛ'nə. Yi à kə̀ dzèŋ fo', nə ye ŋgà' nə mvə̀'nə̀ nà' nòo fana yi ca yuye ndzə ŋgʉʉ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ŋwə̀ Sàmàriyà mòk à və̀ ye fo', nə ye nà', fana nə koksə manziŋ bohònà'. ");
INSERT INTO yam_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yi geŋ fo', nə gesə fa nà' mve' bə rùk ndzənə mvwe' nà' sə, nə kiŋ lok fa nà'. Yi le' koksə naaŋ nà' mʉnə nàmbà'rə̀ ye, nə jəŋ lo nà' mvwe' ndap nəmòk nə̀ ŋwèe nòoŋ mbwa yi lak, nə sə jəŋ ŋkərə̀ bohònà' fo'. ");
INSERT INTO yam_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tsok à rɛŋ, yi fis mbàm ncùhù ba, nə fa ŋgà ndap nə. Yi dʉk fa ŋgà ndap nə dʉk də, <Sə kʉk fa mʉ yi bə̀boŋ. Mʉ bwìŋ foho və̀ fana mʉ̀ lak fəsə fa wu mbàam sə̀ wù bʉpsə yà' bʉ̀ʉ yi pwe'.> ");
INSERT INTO yam_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bohòbʉ̀ʉ sə̀ tɛ' yè'sə, wù tsəm də ŋwə̀ nə̀ yi à nìtsə̀' də yi moma bə ŋwə̀ nə̀ ŋgàa yə̀ wèŋ à lə̀p yi nə yè'e nə̀ fò?>> ");
INSERT INTO yam_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yi dʉk də, <<A ŋwə̀ nə̀ yi à tse' koksə̀manziŋ bohònà' nà'a.>> Fana Jisòs dʉk fa nà' dʉk də, <<Dù a, nə kə gʉ yòsə̀' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisòs bə bwe ye wèŋ à sə lòo fana wo kə dzeŋ mvwe' lak mok. Ŋwà mòk à ye fo' nə̀ wo to liŋ ye də Matà. Ŋwà ènə à fa Jisòs mvwe' nòòŋ mʉnda'à yi. ");
INSERT INTO yam_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yi ànə tse' moma ye mòk nə̀ wo to yi də Mèri. Mèri nə à kə̀ cu ŋgʉ ni'ì Tà ànə, nə sə yu'rə yusə̀ nà' sə yə'rə fa bwìŋ sə. ");
INSERT INTO yam_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Matà ye də fàk yam bohòyi wùriŋ fana yi kə dʉk fa Jisòs də, <<Tà, wù yə də moma àm me'rə mʉ mʉmʉ̀, fàk sə ghak mʉ, wù kà mbɛŋ kom à? Tsok fa yi də yi kə tɛsə mʉ.>> ");
INSERT INTO yam_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tà nə dʉk fa nà' də, <<Matà, Matà, wù sə jìk, nə sə ye ŋgə' bə bum ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yu nə̀ nà' tse' gha' fàk, a yu nə̀ mò'fis. Mèri cok jə fis ma nə̀ bə̀boŋ nə laŋ. Kaco mʉ̀ dzəm də ŋwèe fep fis yuk nà' bohòyi yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nùmbu mòk à ye ŋga yi sə lɛŋ pìriyà mʉmvwe' nəmòk, yi ànə mesə fana mo fàk ye mòk və bohòyi, nə dʉk fa yi də, <<Tà, yə'rə fa ves ŋgòlɛŋ pìriyà mʉmvə̀'nə̀ Jon ànə yə'rə fa ŋgàa fàak ye yà'a.>> ");
INSERT INTO yam_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yi dʉk fa wo də, <<Wèeŋ cu ŋgòlɛŋ, wèŋ cep dʉk də: <Tɛ̀', kə̀kùksə̀ə ye bə liŋ yo. Gaŋ ŋkum yo sə və. ");
INSERT INTO yam_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fa ves bɛŋ sə̀ co vès zʉ nùumbu pwe'. ");
INSERT INTO yam_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Swì fa ves bʉp avès, bʉ̀ʉsə̀ vès swì fagə̀ ndàaŋwè pwe' nə̀ yi gʉ̀gə̀ ves bʉp sə̀'. Kà ves mvwe' sə̀ co mə̀mumsə̀ kə tseŋ ves jə lò.> >> ");
INSERT INTO yam_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jisòs dʉk fa bwe ye sə wèŋ də, <<A dʉk-a də ŋwə̀ nəmòok mʉŋgorə̀ wèŋ nə̀ aco yi lokok nə̀ tsətsə'rə̀ə tsok, nə kə dʉk fa ŋge' ye mòk də, <Ŋge' àm, samsə fa mʉ ntuk brɛd tɛ', ");
INSERT INTO yam_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","bʉ̀ʉsə̀ ŋge' àm mòk tesə və̀ gì fana mʉ̀ ka yumok co mʉ̀ fa yi zʉ tse'.> ");
INSERT INTO yam_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yi dʉk vesə mʉnda'à anə də, <Kà mʉ ŋgə' fa nòòŋ, mʉ̀ lok ncù laŋ, ves bwe am wèŋ nònze, kaco mʉ̀ lokok ŋgòfa wu yumok ŋga'a yeŋ.> ");
INSERT INTO yam_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mʉ tsok weŋ də a ye-a sə̀ də yi nə kà ŋgòfa nà' yumok bʉ̀ʉsə̀ nà'a ŋge' ye lòkok fana bʉ̀ʉsə̀ nà' sə lɛŋ malì gʉgʉŋ, yi nə lokok kə fa nà' yusə̀ nà' dzəm sə pwe'. ");
INSERT INTO yam_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mʉ tsok weŋ də, lɛŋ Nwì ya yi nə fa wu, làap ya wu nə tse', kùum ya wo nə muk fa wu. ");
INSERT INTO yam_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bʉsə̀ ŋwə̀ nə̀ yi lɛŋ-a, ŋgə̀ŋgàaŋ nə tse', ŋwə̀ nə̀ yi làp-a, yi nə ye, ŋwə̀ nə̀ yi kum-a, wo nə muk fa ŋwə̀ ànə. ");
INSERT INTO yam_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","A nsàp tɛ̀' nə̀ fònə̀ də a ye-a ŋga mo ye lɛŋ fuk bohòyi, yi kà nà' fuk fa, nə fa nà' no ɛ? ");
INSERT INTO yam_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kènə də yi lɛŋ-a mbùmvəp nà' fa yi ŋgam ɛ? ");
INSERT INTO yam_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A ye-a ŋga wèŋ sə̀ wèeŋ bʉp yè'e riŋ ŋgòfa bwe awèŋ bum sə̀ bə̀boŋ, ye də aco Tɛ̀' nə̀ mʉbu nə, nə fa Yòŋsə̀ nə̀ Rərɛŋ nə bohòbʉ̀ʉ sə̀ wo lɛŋ yi sə wèŋ wùriŋ!>> ");
INSERT INTO yam_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisòs à sə bɛ' fis yòŋsə̀ ze' mòk nə̀ yi gʉ̀gə̀ ŋwè yi kà cù cèp fana ze' nə ànə tesə lòo fana ŋgà' nə ye ŋgòcèp cù, bwìŋ mərə. ");
INSERT INTO yam_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bʉ̀ʉ mok wèŋ dʉk yàwo də, <<Yi bɛ' fisgə̀ ze' sə bə ŋàaŋ Bezebù nə̀ yi ŋkum ze' wèŋ yi nə.>> ");
INSERT INTO yam_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bʉ̀ʉ mok wèŋ sə lap mandzə̀ ŋgòbʉə yi fana wo sə lap də nà'a niŋ tsok fa wo maŋgəŋgèŋ mòk nə̀ nà' tesə ma mʉbu. ");
INSERT INTO yam_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yi riŋ yusə̀ wo sə tsərə sə fana yi dʉk fa wo dʉk də, <<A ye-a ŋga lak mok ga'a-a ba fana ye də yà' kà fàk tse'. Nə ye sə̀' də ndap nə̀ nà' ga'a-a ba, ye də nà'a nə gbʉ. ");
INSERT INTO yam_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ye də a ye-a də Satà gapsə ni' ye bòp ba fana aco gaŋ sə̀ ye sə təəŋ yè'sə va? Bʉsə̀ wèŋ sə dʉk də mʉ̀ sə bɛ'fis ze' bə ŋàaŋ Bezebù. ");
INSERT INTO yam_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A ye-a də mʉ̀ sə bɛ' fis ze' bə ŋàaŋ Bezebù fana bʉ̀ʉ awèŋ wèeŋ bɛ' fisgə̀ yàwo bə ŋàaŋ sə̀ ndà? Nsàp fàk bʉ̀ʉ awèŋ sə, sə nìtsə̀' dʉk də wèeŋ bə jòŋ. ");
INSERT INTO yam_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mvə̀'nə̀ mʉ̀ sə bɛ'fis yà' bə ŋàaŋ sə̀ Nwì fana ye də gaŋ ŋkum sə̀ Nwì sə yà' kʉəp və̀ bohòwèŋ laŋ. ");
INSERT INTO yam_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","<<A ye-a ŋga ŋgà ŋàŋ nə̀ yi tse' bum dzè' ŋap sə sònto' ye yi fana ye də bum ye pwe' cu bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Fana a ye-a ŋga ŋwə̀ nəmòk nə̀ nà' gʉ ghak yi və-a, nə lʉ bə nà', nə ghak yi fana yi nə fep jəŋ bum dzè'e ye sə̀ yi anə sə naaŋ tu bə zeŋ sə, nə gapsə bum ye sə̀ yi tse' sə bə ŋge' ye wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","<<Ŋwə̀ nə̀ yi ka-a vesi yeŋ, ye də yi sə bɛ̀ŋ mʉ. Ŋwə̀ nə̀ yi sə kà-a vesi te'e benə̀ ye də yi sə sɛ̀sə ye sɛ̀sə. ");
INSERT INTO yam_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","<<A ye ŋga yòŋsə̀ ze' tesə ndzə ni'ì ŋwè fana yi gihi ca mvwe' nze jì ndzəp, ŋgòlàp mvwe' sə̀ yi yoŋsə fo'. Yi kà mvwe' sə̀ co yi yoŋsə yə fana yi dʉk də, <Mʉ nə bwi foho lo fe'lə mvwe' ndap àm nə̀ mʉ̀ a tesə fo' nə.> ");
INSERT INTO yam_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yi bwì foho və̀-a, nə ye ŋga wo kùrə nà' nə gʉhʉ tsə'rə nà' bə̀boŋ, ");
INSERT INTO yam_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","fana yi lo, nə kə to jəŋ və yòŋsə̀ə mok sàmba, sə̀ wo bʉp càsə yi wo. Wo nə ni cum mʉmvwe' ndap nə. A ye vɛ'nə fana ncu ŋwə̀ ànə nə̀ maŋkwɛ̀ŋ nə, nə bʉp casə nə̀ ànə ye to mantombì nə.>> ");
INSERT INTO yam_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisòs ànə cep bum yè'sə fana ŋwà nəmòk nə̀ yi ànə ye mʉŋgorə̀ bwìŋ fo' cep fis də, <<A rɛŋsi bohòvə̀əm sə̀ yà' à dzə wu, nə ye mbwi sə̀ wù à no!>> ");
INSERT INTO yam_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yi dʉk bwi ye də, <<Rɛŋsi nə lɛ bohòŋwə̀ nə̀ yi yuk ncèp Nwì, nə noŋsə nà'.>> ");
INSERT INTO yam_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bwìŋ ànə sə yam ghaha fo' ghaha fana Jisòs ye ŋgòcèp də, <<Bʉ̀ʉ sə̀ niè' yè'e wo bʉ̀ʉ sə̀ bʉp, wo sə dzəm ŋgòyə yumok sə̀ maŋgəŋgèŋ. Mʉ nə kà wo maŋgəŋgèŋ gʉ̀ nì tsə̀' fa, anə megu maŋgəŋgèŋ nə̀ Jonà nà'a. ");
INSERT INTO yam_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bʉsə̀ mvə̀'nə̀ Jonà nə ànə ye co maŋgəŋgèŋ mòk ŋgònìŋtsə̀' fa bʉ̀ʉ Nenevì yà'a fana mʉ̀ʉ mo ŋwè, mʉ nə ye sə̀' vɛ'nə bohòbʉ̀ʉ yè'sə. ");
INSERT INTO yam_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nùmbu nzak nə ye, ŋkum nə̀ yi ŋwàŋwè nə̀ yi à tesə və̀ mvwe' lak Sibà nà'a nə cep bʉp bohòbʉ̀ʉ sə̀ ŋga'a yè'sə də wo gbʉ̀ nzak. Bʉsə̀ yi à tesə və̀ mvwe' sə̀ nzeŋgòŋ nə lə̀sə, ŋgòkə̀ yuk nsàp ŋkərə̀ nə̀ Sòlomù à tse' fana yeè, yumok sə̀ yà' ghak Sòlomù nə ŋga'a yè'. ");
INSERT INTO yam_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nùmbu sak nzak ye fana bʉ̀ʉ Nenevì wèeŋ nə lokok dʉk fa bʉ̀ʉ sə̀ niè' yè'sə wèŋ də wo gbʉ̀ nzak. Bʉsə̀ Jonà ànə tsoho, wo kupsə ntʉm; fana yumok sə̀ yà' ghak càsə Jonà nə ŋga'a yè'. ");
INSERT INTO yam_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","<<Wo bwe'-a laàm, kaco wo swihi nà' swìhi kè wo jəŋ nà', nə tes gesə sənə kʉ̀ŋ yeŋ. Wo nə tes nà' mvwe' sə̀ jəja ya bwìŋ sə ni və̀ə wo sə ye marɛŋ nə. ");
INSERT INTO yam_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lis yo marɛŋ nə̀ ndzə ni'ì wù yi. A ye-a ŋga lis yo bə̀boŋ fana ye də ni' yònə, nə̀ rwiŋ bə marɛŋ. Yà'a sə̀' də a ye-a ŋga lis yo ka bə̀boŋ yeŋ fana ye də ni' yòrwiŋ bə mandzəm. ");
INSERT INTO yam_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ye də wèeŋ jəŋ ŋkərə̀, bwɛ̀rɛ marɛŋ nə̀ ndzə ni'ì wèeŋ nə bʉʉŋ mandzəm. ");
INSERT INTO yam_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Fana ye də a ye-a ŋga ni' yòpwe'fo' rwiŋ mègù bə marɛŋ, də mandzəm nja mvwe' mok bʉ̀ə̀, fana ye də nà'a nə ye pwe' marɛŋ anə, co mvə̀'nə̀ marɛŋ laàm rɛŋgə̀ yà'a.>> ");
INSERT INTO yam_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisòs anə sə cep fana ŋwə̀ə Faràsi mòk dʉk nà' də bə nà'a kə zʉ bɛŋ. Fana yi lo kə cum tsoŋ də ya bə nà'a zʉ. ");
INSERT INTO yam_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ŋwə̀ə Faràsi nə à mərə vɛ'ɛ mvəsə̀ yi à yə də Jisòs ànə zʉ ŋga yi ka mvə̀'nə̀ wo cùkgə̀ ŋkuŋ nə sə zʉ yumok sə cuk. ");
INSERT INTO yam_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ànə geŋ Tà Jisòs dʉk fa nà' də, <<Wèŋ bʉ̀ʉ Faràsi, wèeŋ cùkgə̀ yàwèŋ ŋkwɛ̀ɛŋ ŋgàp bə ŋkwɛ̀ɛŋ tasà, fana rwiŋ cum ma sə tsətsə'rə̀ wèŋ anə ŋgwap bə wa bum bwìŋ. ");
INSERT INTO yam_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wèeŋ ləm! Ŋwə̀ nə̀ yi ànə gʉ̀ ŋkwɛ̀ŋ nə à ka ma sə tsətsə'rə̀ sə̀' yi gʉ à? ");
INSERT INTO yam_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wèeŋ fa-a ŋgàa jìŋ wèŋ mbo sənə ŋgàp nə fana ye də yusə̀ yà'a ma nə̀ njàwèŋ pwe' mok rərɛŋ. ");
INSERT INTO yam_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","<<Wèŋ bʉ̀ʉ Faràsi, wèŋ cu bʉp. Wèeŋ jəgə̀ ŋkərə̀ ŋgògàpsə fa Nwì bwe mvùu bum sə̀ jo yè'e pwe'fo' ma nje, nə me'rə noŋsə ŋgòfàk bə zìnə, nə ye ŋgòdzəm Nwì vɛ'nə. Anə ye co wèŋ sə gʉ yà'sə, nə kà mok sə̀' mè'rə̀ màk. ");
INSERT INTO yam_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Wèŋ bʉ̀ʉ Faràsi, wèŋ cu bʉp! Wèeŋ dzèŋ mʉmvwe' ndap pìriyà fana wèŋ sə dzəm dzòok sə̀ bə̀boŋ, wèŋ sə dzəm sə̀' də bwìŋ sə cepsə weŋ mʉntɛɛ̀ŋ bə wəwəp wùriŋ. ");
INSERT INTO yam_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wèŋ cu bʉp bʉ̀ʉsə̀ wèeŋ co sèe sə̀ bwìŋ sə kà yà' yə fana wo sə gi ca mbwa, nə kà rì.>> ");
INSERT INTO yam_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ànə geŋ ŋgà yə'rə̀ fa bwìŋ lʉ̀k mòk dʉk də, <<Cicà, wu cèp vɛ'nə, ye də wù sə yà' vès sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisòs dʉk bwi fa nà' də, <<Wèŋ ŋgàa yə'rə̀ lʉ̀k, wèŋ cu sə̀' bʉp bʉ̀ʉsə̀ wèeŋ jə bum sə̀ yà' rwì' vɛ'ɛ co ŋwè kà bə̀k to, nə sə naaŋ fa bwìŋ. Wèŋ kà yàwèŋ bum sə bə ndubo àwèŋ nə̀ mò'fis jwɛ̀ŋ ja'a lok. ");
INSERT INTO yam_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Wèŋ cu bʉp, bʉ̀ʉsə̀ wèŋ sə ci tsə'rə sèe ŋgàa tsòhòbum Nwì sə̀ ànə zə wo sə̀' tɛ̀' awèŋ. ");
INSERT INTO yam_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ye də wèŋ dzəm də yusə̀ tɛ̀' awèŋ ànə gʉ sə bə̀boŋ bʉ̀ʉsə̀ wo à zə wo fana wèŋ ci yàwèŋ sèe sə. ");
INSERT INTO yam_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ye də nà'a njo nə̀ ŋkərə̀ Nwì sə cèp də, <Mʉ nə tumsə fa wo ŋgàa tsòhòbum Nwì bə ŋgàa ntum wèŋ. Wo nə zə mok, nə yeŋsə mok wèŋ ŋgə'.> ");
INSERT INTO yam_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ya ndʉəm ŋgàa tsòhòbum Nwì wèŋ sə̀ yà' ànə fe'e mvə̀'nə̀ nzeŋgòŋ à yè yèe pwe'fo' nə ye ndzə bohòbʉ̀ʉ sə̀ niè' yè'sə. ");
INSERT INTO yam_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ye jəŋ bə ndʉəm Abè kə dzeŋ mʉ ni'ì Sàkàriyà nə̀ wo à zə yi mʉtsətsə'rə̀ə kàm nə̀ wo tɛ̀ŋgə̀ satikà' mbwa bə mvwe' sə̀ rərɛŋ sə̀ mʉ ndap Nwì nə̀ ghaŋ sə. A zìnə də wo nə fek ndʉəm awo sə bohòbʉ̀ʉ sə̀ niè' yè'sə. ");
INSERT INTO yam_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","<<Ŋgàa yə'rə̀ lʉ̀k, wèŋ cu bʉp, njo nə̀ wèŋ a jə lòksə ki sə̀ ŋgòmùk ncùu ŋkərə̀ bə zeŋ sə. Wèŋ bə tu awèŋ, wèŋ a ka ni, fana nə lok bwi fa bʉ̀ʉ sə̀ wo à sə ni sə mandzə̀.>> ");
INSERT INTO yam_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisòs ànə me'rə fa'nə fana ŋgàa yə'rə̀ lʉ̀k bə bʉ̀ʉ Faràsi sə wèŋ sə sa'rə yi nə nɛ' tse' yi bə cù cʉ̀k, də ya nà'a cep bum ŋkʉ̀ʉŋ. ");
INSERT INTO yam_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Wo sə bʉə yi vɛ'ɛ də ya wo ko yi bə yumok sə̀ bʉp sə̀ yi cèp-a na. ");
INSERT INTO yam_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ghà ànə à ye ŋga bwìŋ kə̀ benə vɛ'ɛ ncùhù ŋkʉ̀ʉŋntɛ̀ŋ, nə sə nəŋ ca mok mʉ ni'ì bə kù fana Jisòs ye ŋgòtsə̀' to fa ŋgàa fàak ye wèŋ də, <<Wèeŋ jəŋ ŋkərə̀ bə yis bʉ̀ʉ Faràsi wèŋ. Mʉ̀ sə dʉk yè'sə mʉmvə̀'nə̀ wo gʉ̀ basə kɛ'gə̀ bum awo yà'a. ");
INSERT INTO yam_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yumok ka sə̀ də bwìŋ à sè'lə lok yà' də wo nə kà yà' yə yeŋ. Yumok ka sə̀ wo a swìhi yà' də bwìiŋ nə kà yà' rìŋ yuk sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ye də yusə̀ wu cèp-a yà' ndzə ndzəmə̀, yà'a nə̀ kə̀ yuhu mvwe' marɛŋ. Yusə̀ ŋwè làrə swìhi yà' mà mbwèndap fana wo nə̀ fu yà' ma mʉ ndùndap. ");
INSERT INTO yam_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","<<Ŋge' am wèŋ, mʉ tsok weŋ də kà də wèeŋ wəp bʉ̀ʉ sə̀ wo zə-a ŋgùpni' fana wo kà yumok ŋgògʉ̀ fe'lə bohòwù tse' yà'a dʉk. ");
INSERT INTO yam_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mʉ tsok fa weŋ ŋwə̀ nə̀ aco wèŋ wəp yi nə. Wəp Nwì nə̀ yi zə wes fana yi tse' mali ŋàŋ ŋgògèsə wu mvwe' ŋgə' nə̀ sə misə̀ nà'a. Mʉ̀ sə tsə̀' weŋ zìnə də wəp yi ànə. ");
INSERT INTO yam_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wo kà ləŋbu tàŋ dolà ba sèŋgə̀ à? Nwìi kà nə̀ mò'fis swìgə̀. ");
INSERT INTO yam_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nʉ̀əmtu sə̀ mʉ tuhù wèŋ yè'e, yi a ta yà' ta. Ye də wu kà yumok wəp, bʉ̀ʉsə̀ wù yam ghak ləŋbu kɛ̀' ŋkʉ̀ʉŋntɛ̀ŋ laŋ. ");
INSERT INTO yam_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","<<Mʉ tsok fa weŋ də ŋwə̀ nə̀ yi cèp fis-a jəja mvwe' bwìŋ də yi ŋwə̀ àm fana mʉ̀ mo ŋwè, mʉ nə̀ kə̀ dʉk fa yi sə̀' vɛ'nə mantombì masinjàa Nwì wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ŋwə̀ nə̀ yi bɛ̀ŋ-a mʉ mantombìi bwìŋ fana mʉ nə̀ kə̀ bɛ̀ŋ yi sə̀' mantombì masinjàa Nwì wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ŋwə̀ nə̀ yi bʉpsə liŋ am, nə̀ mʉ mo ŋwè fana wo nə̀ swì fa yi yà'; ŋwə̀ nə̀ yi bʉpsə-a liŋ Yòŋsə̀ nə̀ Rərɛŋ nə fana kaco wo nə̀ swì fa yuk yi yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","A ye-a ŋga wo jə lo wu mʉmvwe' ndap pìriyà, nə ye bohòbʉ̀ ŋkəŋkum nə ye bə bʉ̀ʉ sə̀ wo sakgə̀ bum wo fana wù kà də wu sə jik də wu nə cep fəsə yàlɛ, kè də wu nə dʉk yè'sə dalɛ dʉk. ");
INSERT INTO yam_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bʉsə̀ Yòŋsə̀ nə̀ Rərɛŋ nə, nə tsok fa wu yusə̀ wu cep sə sə̀ ghà nà'nə.>> ");
INSERT INTO yam_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ŋwə̀ nəmòk à ye mʉtsətsə'rəə bʉ̀ʉ sə̀ wo à benə wùriŋ sə, nə dʉk vesə fa nà' də, <<Cicà, dʉk fa moma am də yi gapsə bum mfə tɛ̀' am vesi.>> ");
INSERT INTO yam_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisòs dʉk fəsə fa nà' də, <<Ŋgàta, ŋwə̀ nə̀ yi a gʉ̀ mʉ də mʉ sak fa weŋ nzak kè mʉ gapsə fa weŋ bum yè'sə ndà?>> ");
INSERT INTO yam_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ànə geŋ yi dʉk fa bʉ̀ʉ sə̀ fo' sə wèŋ də, <<Wèeŋ jəŋ ŋkərə̀ ŋgòwa bum bwìŋ, bʉ̀ʉsə̀ yòŋsə̀ ŋwè ka bʉ̀ʉ bum sə̀ də yi tse' yà' ŋkʉ̀ʉŋntɛ̀ŋ yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Fana yi mak fa wo gbʉ' nè'e də, <<Ŋgà ghàk mòk ànə tse' nzum sə̀ bum ànə tesə mbwa wùriŋ. ");
INSERT INTO yam_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yi ye ŋgòtsərə də, <Mʉ̀ ka mvwe' sə̀ co mʉ noŋsə wes zʉzʉʉ am yè'e tse'. Mʉ nə gʉ kok yè'sə valɛ-ò?> ");
INSERT INTO yam_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yi dʉk də, <Mʉ nə gʉ lɛ vɛ': mʉ nə kʉəmsə mak tàap am, nə ci sə̀ ghaŋ, ya mʉ gesə zʉzʉʉ am bə bum am pwe' mbwa. ");
INSERT INTO yam_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Fana mʉ nə dʉk fa ni' àm dʉk də, mʉ̀ tse' zʉzʉ nduk co mʉ̀ zʉ yà' lùumŋgòŋ ŋkʉ̀ʉŋntɛ̀ŋ; cum yoŋsə yuyo, zʉ, no, nə sə roŋ.> ");
INSERT INTO yam_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ànə geŋ Nwì dʉk fa yi də, <Ləm yu ènə, yòŋsə̀ yòo nə me bə ndzəm nə̀ ntinə nè'e. Bum sə̀ wù fʉ̀hʉ yà'sə nə ye mok sə̀ ndà?> >> ");
INSERT INTO yam_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jisòs dʉk ləsə də, <<Yà'a mʉmvə̀'nə̀ yà' cu vɛ'nə bohòŋwə̀ nə̀ yi kotse' bum ghàk, nə kà ŋgà ghàk bohòma nə̀ Nwì ye.>> ");
INSERT INTO yam_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisòs à dʉk fa bwe ye wèŋ dʉk də, <<Kà də wèeŋ sə jik bə yòŋsə̀ə awèŋ də mʉ nə zʉ kok yàlɛ, kènə bə ni' yòdə wu nə ni kok yàlɛ-òdʉk. ");
INSERT INTO yam_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bʉsə̀ yòŋsə̀ ghak bɛŋ fana ŋgùpni' ghak cə̀k sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wèeŋ kʉk ja'a na ŋwə̀ŋwɛ', wo kà bìgə̀ nə kà sə̀' kʉp loksə̀. Wo ka tàp tse', nə kà zok sə̀' tse', fana Nwì sə fa wo zʉzʉ. Ghak yè'sə wèŋ kè swiŋ ɛ? ");
INSERT INTO yam_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A mʉŋgorə̀ wèŋ ndà, nə̀ də aco yi naaŋ gesə nùumbu mok mʉnə nùumbu ye də bʉ̀ʉsə̀ yi jìk ɛ? ");
INSERT INTO yam_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","A ye-a də kaco wù gʉ to yumok bə nə̀ nà'a jo nà'nə yeŋ, ye də wù sə jik bə mok bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tsərə-a bə nzàamŋgaŋ sə̀ yà'a fomgə̀ yè'e mʉmvə̀'nə̀ yà'a kùkgə̀ ɛ̀. Wo kà ndàp caŋsə̀gə̀, nə kà cə̀k sə̀' ba'. Mʉ tsok fa weŋ də a mègù-a sə̀ Sòlomù, nə̀ yi à tse' bum maŋgəŋgèŋ nà'a, yi à ka cə̀k co mòk nə̀ mò'fis vɛ'nə ni yuk. ");
INSERT INTO yam_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A ye-a ŋga Nwìi ni fagə̀ ŋgaŋ sə̀ yà'a təəŋ fə ŋgəà ntinə, a ye zòŋ ŋga wo tɛ̀ŋ səsə yà' laŋ sə vɛ'nə, ye də aco yi ni fa wesə weŋ cə̀ək yàwèŋ yè'sə nsàp nə̀ fò? Bʉ̀ am a, dzədzəm àwèeŋ momjo! ");
INSERT INTO yam_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kà də wèeŋ sə tsərə də mʉ nə zʉ yà, mʉ nə no yà? Kà də wu sə jik dʉk. ");
INSERT INTO yam_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bʉ̀ʉ sə̀ sə nzeŋgònə làpgə̀ yàwo nsàap bum yà'sə; fana Tɛ̀' awèŋ rìŋ dʉk də wèŋ tse' ŋgòtse' bum yè'sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yusə də wèeŋ lap lɛ gaŋ ye sə, ya bum yè'sə nə ye sə̀' sə̀ yàwèŋ. ");
INSERT INTO yam_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","<<Bwe sə̀ mʉ gʉ̀msəgə̀ weŋ, wèeŋ kà wəp bʉ̀ʉsə̀ Tɛ̀' àwèŋ nə sə dzəm bòŋsə wùriŋ ŋgòfa weŋ gaŋ ŋkum sə̀ ye sə. ");
INSERT INTO yam_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Wèeŋ seŋ bum awèŋ, nə fa mbàam sə bohòŋgàa jìŋ wèŋ. Wèeŋ tse' posàa sə̀ kaco yà' reŋ yuk yeŋ, nə loksə ghàak awèŋ mʉbu mvwe' sə̀ kaco yumok gʉ yà' yeŋ; mvwe' sə̀ kaco ŋgà yə̀ kə dzeŋ to fo' yeŋ, nzək kà yà' sə̀' zʉ bʉpsə̀. ");
INSERT INTO yam_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bʉsə̀ mʉmvwe' nə̀ ghàak yo cu fana ntʉm yòo nə ye sə̀' fo'. ");
INSERT INTO yam_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","<<Wèeŋ cum fə̀fʉhʉ̀, swi' cə̀ək awèŋ sə gamə̀ bə̀boŋ, nə bwe' tse' laàm awèŋ. ");
INSERT INTO yam_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Wèeŋ ye co bʉ̀ʉ sə̀ masà àwo nə lo mvwe' ŋkàha gù ŋgòbwìŋ və̀ə, fana wo sə tək nà' də ya nà'a kùm ncù ntɛ̀ŋ, wo muk fa yi mvèsə̀. ");
INSERT INTO yam_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","A rɛŋsi bohòbwe fàak sə̀ masà nə bwìŋ və̀ə, fana yi tseŋ yà'wèŋ ŋga wo cu nca. Mʉ tsok fa weŋ zìnə də masà nə nə kiŋ tsə'rə cə̀k ye, yà'wèŋ cum nze fana yi fa wo zʉzʉ. ");
INSERT INTO yam_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","A rɛŋsi bohòŋgàa fàak sə̀ yi və-a sə̀ ndzəmə̀ kè tsətsə'rəə tsok àlɛ', nə tseŋ wo ŋga wo cu fə̀fʉhʉ̀. ");
INSERT INTO yam_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wèeŋ riŋtse' yumòk nè' sə̀' də, a ye-a ŋga tà ŋgà ndàp nə riŋ-a ghà nə̀ ŋgà yə̀ə nə və, bwɛ̀rɛ yi kà ndap ye də nà'a ni mbwa mè'rə̀ nòŋsə̀. ");
INSERT INTO yam_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wèeŋ nə sə kʉk yàwèŋ sə̀' kʉ̀'ʉ, bʉ̀ʉsə̀ mʉ̀ʉ mo ŋwè, mʉ nə və ghà nə̀ wèŋ ka vɛ'nə tsərə.>> ");
INSERT INTO yam_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pità à fek də, <<Tà, wù sə màk fa gbʉ' nè'e yè'sə bohòvès kè bohòbwìŋ pwe' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Fana Tà cep də, <<Mofàk nə̀ yi zìnə nə tse' ŋkərə̀ə yè'sə nə̀ fò? A nə̀ masà ye nə a fa bum sə̀ mʉ nda'à yi pwe' bohònà', nə dʉk də, nà'a nə sə fa bwe fàak mok wèŋ bum zʉzʉ bə mvə̀k nə̀ kə̀kʉrə̀. ");
INSERT INTO yam_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","A rɛŋsi bohòmofàk nə̀ masà ye bwìŋ və̀ə, nà' tseŋ yi ŋga yi sə gʉ̀ mvə̀'nə̀ nà' anə dʉk noŋsə lo yi sə. ");
INSERT INTO yam_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mʉ tsok weŋ zìnə də, masà nə nə fa nsàp mofàk ànə ŋàŋ ŋgòkotse' bum ye sə̀ yi tse' pwe'fo' nà'. ");
INSERT INTO yam_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A ye-a ŋga mofàk nə dʉk-a də, <Masà àm nə nə kà ntə̀ntɛ̀ŋ bwìŋ fohòvə̀,> nə yeto ŋgòlə̀p bwe fàak sə̀ mbəmbam bə sə̀ bə̀ba sə wèŋ, nə zʉ, nə no jʉhʉ rùk, ");
INSERT INTO yam_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","fana masà ye nə bwìŋ foho və̀ nùmbu mòk nə̀ mofàk nə nə sə ka tsərə fʉk, nə ye bə mvə̀k nə̀ yi ka sə̀' riŋ, fana masà nə nə gbɛ' ci'lə nà' ba, nə noŋsə be'lə yi bə bʉ̀ʉ sə̀ wo ka zìnə tse'. ");
INSERT INTO yam_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mofàk nə̀ yi riŋ yusə̀ masà ye dzəm də yi gʉ yà', nə kà də yi yeto ŋgògʉ̀ yà' dʉk fana wo nə ləp yi cùu ŋkwɛ̀s ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ŋwə̀ nə̀ yi anə ka ye riŋ, nə gʉ yumok sə̀ co wo ləp yi bʉ̀ʉ zeŋ nə̀ bʉp fana wo nə ləp ghasə yi ye ŋgwàŋ. Ŋwə̀ nə̀ Nwì a fa bohòyi ŋkʉ̀ʉŋ fana Nwìi nə dzəm bohòyi sə̀' ŋkʉ̀ʉŋ. Ŋwə̀ nə̀ Nwì a nòŋsə ndzə bohòyi ŋkʉ̀ʉŋntɛ̀ŋ fana Nwìi nə kʉk bohòyi sə̀' ŋkʉ̀ʉŋntɛ̀ŋ anə. ");
INSERT INTO yam_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","<<Mʉ̀ a və̀ ŋgòkə̀ tɛ̀ŋ gèsə mis sənə nzeŋgònə. Yà' sə bòmʉ də anə ye co mis nə kʉə ŋga'a laŋ. ");
INSERT INTO yam_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mʉ̀ tse' bàptɛ nə̀ ŋgòbàptɛsə nà', tse'ŋga mʉ bàptɛsə wes nà' ŋkuŋ ntʉm fi mʉ! ");
INSERT INTO yam_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Wèŋ tsəm də mʉ̀ a və̀ sə nzeŋgòŋ anə ŋgòjə və̀ fifi à? Hai' ka vɛ'nə yeŋ, mʉ tsok weŋ də mʉ̀ a jə və̀ gə̀gàpsə̀. ");
INSERT INTO yam_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bʉsə̀ ye jəŋ ŋga'a nə lo mantombì, bwìŋ tàŋ sə̀ wo cugə̀ ndap mò'fis nə ga'a. Bwìŋ tɛ' nə tse' cùu sə̀ zok bə bʉ̀ʉ sə̀ ba, sə̀ ba tse' bwi yàwo zok bə sə̀ tɛ'. ");
INSERT INTO yam_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Wo nə ga'a, tɛ̀' wèŋ sə dzeeŋ yusə̀ bwe mbəmbaam awo wèŋ sə tsərə fana bwe mbəmbam sə, sə dzeeŋ sə̀ tɛ̀' wèŋ. Ma sə dzeeŋ sə̀ mo ye nə̀ ŋwàŋwè, mo ŋwàŋwè sə dzeeŋ sə̀ ma. Maligù sə dzeeŋ sə̀ ŋgwegù, ŋgwegù sə dzeeŋ maligù nə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisòs à dʉk fa bwìŋ dʉk də, <<Wèeŋ yəgə̀ ŋga mbàk yəəŋ ma nconùm fana wèŋ də, <Mbʉ̀ʉŋ nə li>, nà' li sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wèeŋ yuk ŋga fə̀fə̀ bwìŋ nə̀ kəkok fana wèŋ dʉk də, <Lùm lòo>, lùm nə lo sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wèŋ ŋgàa tè'èŋkup! Wèŋ rìŋ mègù ŋgòkʉ̀k gèsə mʉbu, nə ye nzeŋgònə, nə sə cep də anə ye ŋga'a vɛ'ɛ, nə kà bum sə̀ yà'a niè' yè'e rɛɛŋ bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","<<Kaco wèŋ bə tu awèŋ sak yusə̀ yà'a kə̀kʉrə̀ yeŋ yè'sə bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","A ye-a ŋga ŋwə̀ nəmòk somsə wu mʉ kot fana wù lap mandzə̀ gʉgʉŋ də wenə mesə nzak nə ŋga wèŋ cu ntòmandzə̀. Ya ŋga yi kà wu bohòŋgà sak nzak jə lò. Bʉsə̀ ŋgà sak nzak nə fa wu bohòŋgàa tàm wèŋ, fana ŋgàa tàam sə nisə wu ndapndzəm. ");
INSERT INTO yam_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mʉ tsok fa weŋ də kaco wù tesə yeŋ, tse'ŋga wù làk wes mbàm nə̀ wo tiŋ fa wu nə pwe'fo'.>> ");
INSERT INTO yam_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ghà ànə à ye fana bʉ̀ʉ mok wèŋ à ye fo' sə̀ wo à tsə̀' fa Jisòs bə nzak bʉ̀ʉ Galìli mok sə̀ Palè à zə yà', ndʉəm awo torə bə ndʉəm nàam sə̀ wo à sʉə yà' ŋgòfa Nwì satikà' bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ànə geŋ Jisòs fek wo də, <<Wèŋ tsəm də bʉ̀ʉsə̀ bʉ̀ʉ Galìlii yà'sə wèŋ kpʉ nsàp kpʉ ŋgə' ànə vɛ'nə ye də wo gʉ̀ ghakgə̀ bʉp wo, nə noŋsə bʉ̀ʉ Galìlii mok sə wèŋ pwe' à? ");
INSERT INTO yam_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Hai' ka vɛ'nə yeŋ. Mʉ tsok weŋ də tse'ŋga wèŋ kupsə, nə bwi fa bʉp awèŋ ŋkwɛ̀ŋ bwɛ̀rɛ wèeŋ nə kpʉ sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bʉ̀ʉ sə̀ hum-ncòp-fwame' sə̀ ndap nə̀ nà' à sàp lòmʉbu wùriŋ à kəəŋ zə wo Silòm yà'a, wèŋ tsəm də wo à sə gʉ̀ bʉp wo, nə ghak casə bʉ̀ʉ sə̀ wo cu mvwe' lak Jòrosalèm pwe' wo à? ");
INSERT INTO yam_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mʉ tsok weŋ də ka vɛ'nə yeŋ. Tse'ŋga wèŋ kupsə, nə bwi fa bʉp awèŋ ŋkwɛ̀ŋ bwɛ̀rɛ wèŋ kpʉ sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ànə geŋ Jisòs tsok fa wo gbʉ' nè'e də, <<Ŋwə̀ nəmòk à bì tes tʉ fik mʉ nzuù yi. Yi sə və fo' də yi kə kwiŋ jəŋ ŋgwìi fik nə fana yi kà nə̀ mò'fis kwì yuk. ");
INSERT INTO yam_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ànə geŋ yi dʉk fa bohòŋwə̀ nə̀ nà'a kʉ̀k fagə̀ yi nzum ye sə də, <A ŋga'a lùumŋgòŋ tɛ' mvə̀'nə̀ mʉ làpgə̀ fik mʉ tʉhʉ̀ fɛɛŋ, nə kà mò'fis yə yuk. Gbɛ̀' màk nà', nà' sə gʉ̀ bʉpsə nze nə fo' wà vɛ'nə bʉ̀ʉ yà?> ");
INSERT INTO yam_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ŋgà kʉ̀k nzum nə dʉk fa nà' də, <Ŋkwà'ŋwè, mè'rə tes nà' lùmŋgòŋ nè'e vɛ'nə ntɛ̀ŋ. Mʉ nə tuŋ mbwè nə, nə gesə gə̀p ca. ");
INSERT INTO yam_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lùmŋgòŋ nə̀ nà' tsə nà'a, a ye-a ŋga nà' zəm fana ye də a bə̀boŋ; nà'a kà-a zəm ŋkuŋ wù gbɛ' mak nà'.> >> ");
INSERT INTO yam_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jisòs à sə yə'rə bwìŋ nùmbu dzə̀ mòk mʉmvwe' ndap pìriyà. ");
INSERT INTO yam_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ŋwà nəmòk à ye fo' nə̀ yi à tse' yòŋsə̀ nə̀ bʉp, nə̀ nà' à sə gʉ̀ yi, yi sə yaaŋ mʉnə lùumŋgòŋ hum-ncòp-fwame'. Ŋwà nə à zòoŋ nsàp nə̀ co yi kà mʉtsə̀ rərəŋ təəŋ lok fʉ̀k. ");
INSERT INTO yam_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisòs ànə ye gesə ŋwà nə fana yi to nà', nə dʉk fa nà' də, <<Mamwe, wù ga'a weŋ yiya yònà'a laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Fana yi naaŋ fa nà' bo, ŋwà nə təəŋ kok mok rərəŋ ghà ànə, nə kwasə Nwì. ");
INSERT INTO yam_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ŋkwà' ŋwə̀ nə̀ mʉmvwe' ndap pìriyà nə à jòk vɛ'ɛ də Jisòs gʉŋsə ŋwè nùmbu dzə̀, nə dʉk fa bʉ̀ʉ sə̀ fo' sə wèŋ də, <<A tse' nùumbu ntùŋfu sə̀ aco a gʉ fàk ca. Wèeŋ sə və nùumbu yà'sə ŋga wo sə gʉŋsə weŋ, kà nùmbu dzə̀ ye.>> ");
INSERT INTO yam_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ànə geŋ Tà Jisòs cep fəsə fa nà' də, <<Wèŋ ŋgàa tè'èŋkup wèŋ! Yè'e ka sə̀ wèŋ sə̀ a yegə̀ nùmbu dzə̀, wèŋ sə fiŋ fis mbòŋ kè mvomdè'e awèŋ mvwe' sə̀ wo tsòoŋ tes yà', nə sə jə lo wo ŋgòno ndzəp sə yeŋ à? ");
INSERT INTO yam_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ye də ŋwà nè'e, nə̀ yi mo Abràham, nə̀ Satà a kìiŋ tse' yi lùumŋgòŋ hum-ncòp-fwame' ènə, kaco wo fiŋ fis yi ye nùmbu dzə̀ yeŋ à?>> ");
INSERT INTO yam_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yi à cèp vɛ'nə fana marè'tu ko bʉ̀ʉ sə̀ wo à sə bɛ̀ŋ yi sə wèŋ pwe'fo'. Bʉ̀ʉ sə̀ wo à ye fo' sə wèŋ à kwa bə nsàap bum maŋgəŋgèeŋ sə̀ yi à gʉ̀ʉ sə pwe'. ");
INSERT INTO yam_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisòs à dʉk mok sə̀' də, <<Gaŋ ŋkum sə̀ Nwì sə yè'sə co yàlɛ-ò? Aco mʉ̀ fʉhʉ kok yà' yè'sə bə yà? ");
INSERT INTO yam_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yà'a co mʉ ŋgwì tʉ mostà nà'a, nə̀ ŋwə̀ nəmòk à jə, nə bi mʉnzuù yi. Nà' kuk bʉʉŋ tʉ nə̀ ghaŋ fana swiŋ wèŋ və kə ci ndap awo mbwa.>> ");
INSERT INTO yam_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisòs nə dʉk sə̀mok də, <<Aco mʉ̀ fʉhʉ kok gaŋ sə̀ Nwì sə yè'sə bə yàlɛ-ò? ");
INSERT INTO yam_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yà' mègù co yis sə̀ ŋwàŋwèe jəgə̀ yà', nə gesə sənə kwèes mfòŋ tɛ', nə top yà' tə̀tè yà' kok pwe' yè'e.>> ");
INSERT INTO yam_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisòs à gì, nə sə ca kɛ' mvwe' buhu lak sə̀ jo bə sə̀ ghaŋ wèŋ ŋgòlòJòrosalèm, fana yi sə yə'rə lo bwìŋ fo' sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ŋwə̀ nəmòk fek yi də, <<Tà, bʉ̀ʉ sə̀ wo nə tse' lùŋ nə̀ nà'a nə̀ kà mè yuk nə, nə ye megu bwìŋ jo à?>> Jisòs nə dʉk fa wo də, ");
INSERT INTO yam_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","<<Nikok mvwe' ncùu ŋka' sə̀ fəferə̀ yà'a, bʉ̀ʉsə̀ bwìŋ ŋkʉ̀ʉŋ nə lap mandzə̀ ŋgòni lòfo', fana wo kà ni to. ");
INSERT INTO yam_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tà ŋgà ndap nə lok ncùu ye fana wèeŋ nə təəŋ sə mbiŋ, nə sə kum ncùu sə. Wèŋ kum yà', nə sə cep də, <Tà mùk fa ves ncù.> Yi nə dʉk fa weŋ də, <Mʉ̀ ka mvwe' sə̀ wèŋ və̀ə riŋ.> ");
INSERT INTO yam_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wèŋ ye ŋga'a ŋgòcèp də, <Vesùwèŋ à sə zʉgə̀, nə sə no sə̀' mvwe' mò'fis; wù à sə yə'rə bwìŋ mvwe' mandzə̀ə sə̀ ntòla'à vès.> ");
INSERT INTO yam_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yi nə cep ye də, <Mʉ̀ tsok fa weŋ də mʉ̀ ka yàm mvwe' sə̀ wèŋ və̀ə riŋ. Wèeŋ coho gɛsə lo ŋgʉ ni'ì mʉ̀ fo', wèŋ ŋgàa gʉ̀ bʉp wèŋ.> ");
INSERT INTO yam_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yà'a mvwe' sə̀ wèeŋ nə waŋ, nə zʉ nzòŋ, ŋga wèŋ yə Abràham bə Azìk bə Jàkop, nə ye ŋgàa tsòhòbum Nwì wèŋ pwe' ŋga wo cu mʉla'à Nwì, fana wèŋ mam yàwèŋ sə mbiŋ. ");
INSERT INTO yam_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bwìiŋ nə tesə və mvwe' ŋkùup nzeŋgòŋ ma kwè fo', nə cum sə zʉ roŋ mʉla'à Nwì anə. ");
INSERT INTO yam_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A kə̀ dzèŋ mvə̀' ànə bʉ̀ʉ mok sə̀ wo ŋga'a maŋkwɛ̀ɛŋ nə kə ye mantombì; mok sə̀ wo ŋga'a mantombìi nə ye mok maŋkwɛ̀ŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mvə̀k ànə à ye, bʉ̀ʉ Faràsi mok wèŋ və kə dʉk fa Jisòs də, <<Lògɛsə fɛnə fo', bʉ̀ʉsə̀ ŋkum Heròsə làp mandzə̀ ŋgòzə wu.>> ");
INSERT INTO yam_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yi dʉk fa yà'wèŋ də, <<Dù kə̀ tsok fa kəkərə̀ còp ànə də mʉ̀ sə bɛ'fis yòŋsə̀ə ze', nə sə luŋsə bwìŋ ntinə bə zòŋ, nùmbu nə̀ tɛ' dzèeŋ fana mʉ̀ mesə fàak am sə. ");
INSERT INTO yam_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Fana mʉ nə sə geŋ mali mantombì ntinə bə zòŋ, nə ye bə nùmbu nə̀ nà' bɛ'ɛ nə sə̀'; bʉ̀ʉsə̀ ka bə̀boŋ ŋgòzə ŋgà tsòhòbum Nwì mvwe' mok sə̀ zok nə casə Jòrosalèm yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Webee, lak Jòrosalèm, lak Jòrosalèm. Wèeŋ zəgə̀ ŋgàa tsòhòbum Nwì wèŋ, nə sə tərə ŋgàa gə̀ ntum Nwì wèŋ bə lìs. A yè'sə ghɛ̀' sʉ̀ mvə̀'nə̀ mʉ̀ sə làp də mʉ ko wumsə gesə weŋ ndzə ni'ì mʉ̀ co məma mvəp sə wumsə bwe ye, wèŋ kà dzəm ɛ? ");
INSERT INTO yam_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bo am ka mok bə lak àwèŋ yà'sə yeŋ. Mʉ tsok weŋ də, ye jəŋ ŋga'a lo mantombì, wèeŋ nə kà mʉ mok yə fe'lə̀ tə̀tè nùmbu nə̀ wèeŋ yə fe'lə mʉ, ye mok ŋga wèŋ sə dʉk də, <Nwìi se ŋwə̀ nə̀ yi və̀ mʉnə liŋ sə̀ Tà nə> ŋkuŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nùmbu dzə̀ mòk à ye, Jisòs lo ŋgòkə̀ zʉ zʉzʉ mʉmvwe' ndap ŋkwà' ŋwə̀ə Faràsi mòk. Fana bwìŋ sə kʉk tse' yi vɛ'ɛ pap. ");
INSERT INTO yam_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ŋwə̀ nəmòk à ye fo' nə̀ yi à tse' yiya kəko'rə̀. ");
INSERT INTO yam_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ànə geŋ Jisòs fek ŋgàa yə'rə̀ lʉ̀k bə bʉ̀ʉ Faràsi wèŋ dʉk də, <<Lʉ̀k dzəm də aco wo gʉŋsə ŋwè nùmbu dzə̀ kè njo-ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bʉ̀ʉ sə wèŋ kà cù mùk. Fana yi gʉŋsə ŋgà' nə, nə me'rə nà' lo. ");
INSERT INTO yam_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yi fek wo də, <<A fɛɛŋ ndà nə̀ a ye-a ŋga mo ye kè mbòye gbʉ̀ ni-a sənə wʉ ndzəp nùmbu dzə̀, yi kà nà' mvèsə̀ fis-ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wo à ka yusə̀ co wo cep fəsə fa yi tse' lok. ");
INSERT INTO yam_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisòs à yə mʉmvə̀'nə̀ bʉ̀ʉ sə̀ wo à to wo mvwe' dinà nə sə swè' mègù mvwe' ncum sə̀ bə̀boŋ fana yi tsok fa yà'wèŋ ncèp nè'e. ");
INSERT INTO yam_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Yi də, <<A ye-a ŋga ŋwè to wu də wu və mvwe' zʉ gùu ye fana kà də wu kʉk mvwe' sə̀ bòghak fo' pwe' zeŋ, nə kə cum fo' dʉk. Bʉsə̀ kàmòk wo to ŋwə̀ nəmòk nə̀ yi ghak wu ye sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yi və̀ə fana ŋwə̀ nə̀ yi to weŋ ba fo' yi nə, nə kə dʉk fa wu də, <Lòkok, nə fa mvwe' yà'sə bohòŋwə̀ nè'e.> Fana marè'tu nə ko wu, wù kə cum mok bə dzòk nə̀ nà' ka bə̀boŋ yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","A bə̀boŋ də wo to-a wu, wù kə cum lɛ bə dzòk nə̀ nà' ka bə̀boŋ wùriŋ yeŋ, ya ŋga ŋwə̀ nə̀ yi to weŋ nə və̀ə fana yi dʉk fa wu də, <Ŋge' àm, lòkok cum lo mʉmvwe' dzə̀' nə̀ bə̀boŋ nè'e.> Yà'sə nə gʉ wu, wù ye co ŋwə̀ nə̀ ghaŋ mʉ lisə̀ bʉ̀ʉ sə̀ wenə wèŋ cu fo' sə. ");
INSERT INTO yam_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bʉsə̀ ŋwə̀ nə̀ yi jə kok lò-a ni' ye mʉbu, wo jəŋ tsoŋ yi sə nze; ŋwə̀ nə̀ yi jə tsoŋ lòni' nje sə nze fana wo jə fis kok yi mʉbu.>> ");
INSERT INTO yam_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisòs dʉk fa ŋwə̀ nə̀ yi to bwìŋ dinà nə ye də, <<A ye-a ŋga wù də wu to bwìŋ mvwe' dinà kè mvwe' ŋkàk àlɛ', kà də wu to ŋge' yo wèŋ kè bwema yo, kè njàaŋ yo wèŋ kè ŋgàa ghàk sə̀ wenə wèŋ nòkʉəp fo' dʉk. Bʉsə̀ wo nə to fəsə wu sə̀' fana ye də wo làk fəsə wu yà'sə laŋ. ");
INSERT INTO yam_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yusə də wu to bwìŋ mvwe' dinà fana wù to ŋgàa jìŋ, ŋgàa jì bo bə sə̀ jì kù, nə ye sə̀ jì lis wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ya Nwìi nə se wu. Bʉsə̀ kaco nsàp bʉ̀ ènə lak fəsə to wu yeŋ. Nwìi nə lak wu ghà nə̀ bʉ̀ʉ sə̀ bə̀boŋ wèŋ lòkok mvwe' kpʉ.>> ");
INSERT INTO yam_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ŋwə̀ nəmòk nə̀ bə yà'wèŋ ànə cum, nə sə zʉ mvwe' mò'fis ànə yuk ncèp ènə fana yi dʉk də, <<A rɛŋsi cɛ̀bʉ̀ə̀ bohòŋwə̀ nə̀ yi nə zʉ ŋkàk nə̀ mʉ la'à Nwì.>> ");
INSERT INTO yam_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisòs nə dʉk fa fe'lə nà' bə gbʉ' də, <<Nùmbu mòk à ye, ŋwə̀ nəmòk to ŋkàk nə̀ ghaŋ, nə to bwìŋ vɛ'ɛ ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mvə̀k ŋkàk nə à kʉ̀rə fana yi tumsə lo mofàk nə̀ nà'a fàkgə̀ bohòyi də nà'a kə tsok fa bʉ̀ʉ sə̀ yi to yà' sə də wo və bʉ̀ʉsə̀ wo fʉ̀hʉ wes bum pwe' laŋ. ");
INSERT INTO yam_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bʉ̀ʉ sə̀ wo à to wo sə pwe' sə dʉhʉ lo də wo nə kà və̀ bʉ̀ʉ vɛ' bə vɛ'. Ŋwə̀ nə̀ wo à to to ntòyi nə à dʉk fa nà' də, <Mʉ̀ ywiŋ nzum am, mʉ̀ də mʉ lo kə kʉk ja'a zeŋ. Mʉ̀ lɛŋ wu, kà jòk.> ");
INSERT INTO yam_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mòk dʉk ye də, <Mʉ̀ ywiŋ ndum mbòŋ hum fana mʉ̀ də mʉ kə kʉk ja'a yà' ŋkuŋ. Kwəkwè' nə kà jòk.> ");
INSERT INTO yam_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mòk dʉk ye də, <Mʉ̀ a bə̀' ŋwàŋwè, fana ye də kaco mʉ̀ geŋ to yà'sə yeŋ.> ");
INSERT INTO yam_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ànə geŋ mofàk ye nə bwi və kə tsok fa masà ye nə. Ŋgà ndap nə jok, nə dʉk fa mofàk ye nə də, <Dù mvwe' mandzə̀ə sə̀ sə ntòlak vɛ'ɛ wàp, nə to və ŋgàa jìŋ bə sə̀ jì bo bə sə̀ jì lis, nə ye sə̀ jì kù wèŋ.> ");
INSERT INTO yam_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mofàk ye nə à və̀, nə dʉk də, <Mʉ̀ gʉ̀ mʉmvə̀'nə̀ wù dʉk sə laŋ fana mvwe' ncum bwehe cu malìi.> ");
INSERT INTO yam_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Masà nə dʉk fa yi də, <Yeè, dù lo sə mandzə̀, nə kʉk bəbwe mandzə̀ə sə̀ ŋgəà pwe', nə to ŋwə̀ nə̀ wu yə pwe' də yi və, ya ndap àm nə rwiŋ.> ");
INSERT INTO yam_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mʉ tsok weŋ də bʉ̀ʉ sə̀ mʉ̀ anə to to wo yà'a, nə̀ mò'fis nə kà zʉzʉʉ am sə zʉ ja'à.>> ");
INSERT INTO yam_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bwìŋ à gì bə Jisòs wùriŋ fana yi tsok fa yà'wèŋ də, ");
INSERT INTO yam_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","<<A ye-a ŋga ŋwè dzəm ŋgòbɛ' və̀ mʉ, fana ŋgə̀ŋgàŋ sə dzəm tɛ̀' ye kè ma ye, kè ŋgwe ye, kè bwe ye, kè bwe tɛ̀' ye, kè njɛ̀', nə ghak casə mʉmvə̀'nə̀ yi dzəm mʉ fana ye də kaco ŋwə̀ ànə ye to mo fàk àm yeŋ. Ŋwèe dzəm-a mʉ fana yi tse' ŋgòdzəm mʉ nə casə mvə̀'nə̀ yi dzəm ni' ye. ");
INSERT INTO yam_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","A ye-a ŋga kaco ŋwè bək jəŋ ntə̀əŋ ye, nə bɛ' və mʉ yeŋ, ye də kaco ŋwə̀ ànə ye to mofàk àm yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","A ye-a ŋga ŋwè dzəm ŋgòci ndap, yi nə cum to ntòsə nze, nə kʉk ja'a də ndap nə nə jəŋ yi mbàm sʉ̀ nɛ ŋkuŋ. Yi nə ja'a də yi tse' mbàam sə̀ aco yi ci wes to ndap nə bə zeŋ àlɛ. ");
INSERT INTO yam_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A ye-a ŋga wù ka vɛ'nə gʉ fana kàmòk aco wù yeto fàak sə, nə kà yà' mèsə̀. A ye-a ŋga wù yèto fàak sə nə kà mèsə̀ fana bʉ̀ʉ sə̀ wo yə wu pwe' nə ywi wu. ");
INSERT INTO yam_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wo nə sə cep kɛ' də, <Ŋwə̀ nè'e a yèto ndap, nə kà nà' ci wes to.> ");
INSERT INTO yam_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","<<A ye-a ŋga ŋkum mòk dzəm ŋgòkə̀ lʉ̀ bə mòk fana yi nə cum to ntònze, nə tsərə bə̀boŋ. A ye-a ŋga ŋkum nə tse' mègù bwìŋ ncùhù hum fana yi nə kʉk ja'a də aco yi kə ghak to ŋkum mòk nə̀ nà' tse' sə̀ nà' bwìŋ ncùhù hum ba nə àlɛ? ");
INSERT INTO yam_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A ye-a ŋga kaco yi ghak to ŋkum mòk nə yeŋ fana yi nə tumsə bʉ̀ʉ ye mok wèŋ ŋga nà' cu ntòmvwe' sə̀sap də wo kə tsok fa nà' də yi sə dzəm ye mok fifi. ");
INSERT INTO yam_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yà'a bohòwèŋ pwe'fo' sə̀' mʉmvə̀'ànə də, wèŋ tse' ŋgòtsərə to bə̀boŋ ŋkuŋ. Wèŋ tse' ŋgòme'rə bum sə̀ wèŋ tse' yà' pwe'fo' ŋkuŋ wèŋ bɛ' və mʉ. A ye-a ŋga wèŋ ka vɛ'nə gʉ kaco wèŋ ye to ŋgàa fàk am yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","<<Ci' yusə̀ bə̀boŋ fana, a ye-a ŋga ci' cwɛ̀'lə bʉp, mandzə̀ nə̀ ŋgògʉ̀ yà' lʉm fe'lə kà mok ye. ");
INSERT INTO yam_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kaco yà' boŋsə ncàk, kè yà' gəpsə yumok sə̀ wù a bì yà' sə̀' yeŋ. Bwìŋ mak megu yà' mà'a. Bʉ̀ʉ sə̀ wèŋ sə yu'rə yusə̀ mʉ̀ sə cèp yè'e, wèŋ yuk nə rɛɛŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ŋgàa ko mbàam tas bə ŋgàa gʉ̀ bʉp mok wèŋ à və̀ ŋgòyu'rə yusə̀ Jisòs à sə cèep sə. ");
INSERT INTO yam_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fana bʉ̀ʉ Faràsi bə ŋgàa yə'rə̀ bwìŋ lʉ̀k wèŋ sə cep ŋwəm kɛ'ca. Wo sə dʉk də <<Ŋwə̀ nè'e sə dzəm ŋgàa gʉ̀ bʉp, nə sə zʉ be'lə bɛŋ bə yà'wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ànə geŋ Jisòs mak fa wo gbʉ' nè'e də, ");
INSERT INTO yam_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","<<A mʉŋgorə̀ wèŋ fɛɛŋ ndà nə̀ də yi tse'-a nsùŋgaŋ ŋkʉ̀ mò'fis, nə̀ mò'fis bisə ca, kaco yi me'rə noŋsə sə̀ hum və̀ke'-ncòp-və̀ke' sə ŋgəà, nə lap lo nə̀ mò'fis nə tə̀tè tse'ŋga yi yə nà' ŋkuŋ yeŋ ndà? ");
INSERT INTO yam_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yi yə nà' fana yi bək naaŋ nà' mʉ ŋkambə̀hə yi, nə sə kwa. ");
INSERT INTO yam_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yi kə̀ dzèŋ lak fana yi to benə ŋge' ye bə bʉ̀ʉ sə̀ wo nòkʉəp yi wèŋ. Yi dʉk fa yà' də, <Vesùwèeŋ kwa bʉ̀ʉsə̀ mʉ̀ a yə nsùŋgaŋ àm nə̀ nà' a bisə nə.> ");
INSERT INTO yam_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mʉ tsok fa weŋ də a ye-a ŋga ŋgà gʉ̀ bʉp nə̀ mò'fis kupsə, nə bwi fa bʉp ŋkwɛ̀ŋ fana kwəkwaa nə ye mʉbu ŋkʉ̀ʉŋntɛ̀ŋ mʉtuhù yi, nə casə bʉ̀ʉ sə̀ hum və̀ke'-ncòp-və̀ke' sə̀ wo yàwo bʉ̀ʉ sə̀ wo kə̀kʉrə̀. ");
INSERT INTO yam_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","<<Kè a dʉk-a də ŋwà nəmòk a tse' mbàam ye hum, fana nə̀ mò'fis bisə ca. Yi nə bwe' laàm ŋgòlàp bə zeŋ, nə kurə ndap nə, nə lap se tə̀tè yi ye nà' ŋkuŋ, ka vɛ'nə yeŋ à? ");
INSERT INTO yam_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yi yə nà' fana yi to benə ŋge' ye bə bʉ̀ʉ sə̀ wo nòkʉəp kok fo' wèŋ. Yi dʉk fa yà'wèŋ də, <Vesùwèeŋ kwa bʉ̀ʉsə̀ mbàm àm nə̀ nà' a bisə nə, mʉ̀ a yə fe'lə nà' laŋ.> ");
INSERT INTO yam_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mʉ tsok fa weŋ də yà' mègù sə̀' vɛ'nə də kwəkwa cu mʉtsətsə'rəə masinjàa Nwì wèŋ ŋga ŋgà gʉ̀ bʉp nə̀ mò'fis kupsə a ntʉm ye na.>> ");
INSERT INTO yam_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisòs à cèp malì gbʉ' mòk sə̀' də, <<Ŋwə̀ nəmòk à tse' bwe ye ba, ŋga wo pwe' mbəmbam. ");
INSERT INTO yam_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nə̀ mweŋke' nə dʉk fa tɛ̀' awo nə də, <Pàpa, fa fis mʉ bum yàm sə̀ yà'a nə̀ kə̀ ye yàm sə ŋga'a.> Ànə geŋ yi gapsə fa yà'wèŋ bum ye sə̀ yi tse' sə. ");
INSERT INTO yam_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","À ka nùumbu ŋkʉ̀ʉŋ sap fana nə̀ mweŋke' nə te'e benə bum sə̀ ye sə pwe', nə bɛ' mandzə̀ nə lo mvwe' lak mok sə̀ sə̀sap. À dzèŋ fo' yi sə zʉ sɛsə bum ye sə bə mandzə̀ njɛsə̀. ");
INSERT INTO yam_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mvə̀'nə̀ yi à wes bum ye sə fana njè nə̀ bʉp ko mvwe' lak yà'sə fana yi ye ŋga'a ŋgòjamə. ");
INSERT INTO yam_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yi lo, nə sə cum mok bə ŋwə̀ nəmòk nə̀ mvwe' yà'sə. Ŋgà' nə à sə tumsə lòyi ŋgòsə fa ŋgùnaaŋ ye wèŋ zʉzʉ. ");
INSERT INTO yam_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Njè sə yaŋ yi vɛ'ɛ co yi zʉ zʉzʉʉ ŋgùnaaŋ sə fana ŋwə̀ nəmòk kà yi yumok fa lok. ");
INSERT INTO yam_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ŋkərə̀ ye ànə foho və fana yi dʉk də, <Bwe sə̀ wo sə fàk bohòtɛ̀' am tse' bɛŋ co wo kà zʉ wes to, mʉ̀ sə də mʉ kpʉ yàm njè. ");
INSERT INTO yam_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mʉ nə lokok lo kə tseŋ tɛ̀' am, ya mʉ nə dʉk fa yi də, <<Pàpa, mʉ̀ a gʉ̀ bʉp bohòNwì nə ye bohòwù sə̀' laŋ. ");
INSERT INTO yam_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mʉ̀ ka mok kə̀kʉrə̀ co wo to fe'lə mʉ də mo yòyeŋ; jəŋ tse' mʉ mok co mo ŋgà fàk yòmòk.> ");
INSERT INTO yam_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ànə geŋ yi lokok lo bohòtɛ̀' ye nə. <<À ye ŋga yi sə və̀ mandzə̀ mweè sə̀sap, ŋga yi ka ntòwɛs fana tɛ̀' ye nə ye gesə lo yi, nə koksə manziŋ bohònà'. Yi caŋ lo, nə kə ko wumsə gesə lo nà' ndzə ni'ì yi, nə cepsə nà' bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mo ye nə dʉk fa yi də, <Pàpa, mʉ̀ a gʉ̀ bʉp bohòNwì, nə ye bohòwù sə̀' laŋ. Mʉ̀ ka mok kə̀kʉrə̀ co wo to fe'lə mʉ də mo yòyeŋ.> ");
INSERT INTO yam_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tɛ̀' ye nə dʉk fa ye bohòŋgàa fàak ye wèŋ də, <Wèeŋ jəŋ və cə̀k nə̀ nà' bògha' pwe' wàp, nə ni gesə fa yi mʉ ni'ì. Wèeŋ gesə fa yi kwàŋ ndzə bohòyi sə̀', nə so fa yi kùuŋgùp sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ya wèeŋ kə jəŋ və mbònə̀ nà' fʉ̀ə̀ càsə pwe' nà'a, nə sʉə ya vesùwèeŋ zʉ nə kwa. ");
INSERT INTO yam_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bʉsə̀ mo àm ènə à kpʉ yè'sə laŋ, nə lùŋ fe'lə̀ nə sə̀mok; yi à bisə laŋ, nə yəə̀ŋ nə sə̀mok.> Wo à yè ŋga'a ŋgòsə kwa. ");
INSERT INTO yam_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","<<Bum yè'sə ànə sə ye vɛ'nə ŋga mo tu ye nə cu ŋgòŋ. Yi ànə və, nə kʉəp və nda'à wo fana yi yuk ŋga bwìŋ sə yəm ŋkì, nə sə kaŋ dzeŋ. ");
INSERT INTO yam_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yi to mo ŋgà fàk tɛ̀' ye nəmòk, nə fek nà' də bʉp yiskok yàlɛ? ");
INSERT INTO yam_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nà' tsok fa yi də, <Moma yo bwìŋ foho və̀ yi, fana tɛ̀' yo sʉə mbònə̀ nà' fʉ̀ə̀ gha' pwe' nə də bʉ̀ʉsə̀ mo ye nə kə̀ tsèŋ yi bə̀boŋ ŋga yumok ka bʉp.> ");
INSERT INTO yam_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yi à yuk vɛ'nə, yi jok, nə də yi kà mʉ nda'à mok ni. Tɛ̀' ye nə tesə və sə mbiŋ, nə sə kə lɛŋ mo tu ye nə. ");
INSERT INTO yam_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mo nə dʉk fa tɛ̀' ye nə də, <Ja'a na yòo lùumŋgòŋ sə̀ mʉ̀ a fàk turə bohòwù, mʉ̀ ka dʉk yo bɛŋ yuk; wù nə kà mʉ mo ndzə mòk də ves ŋge' am wèeŋ kwa bə zeŋ fa yuk. ");
INSERT INTO yam_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Fana mo yònè'e və̀ə, yi a bʉpsə wes mbàm bə bàa sàhà pwe', fana wù sʉə fa yi mbònə̀ nà' fʉ̀ə̀ càsə pwe'!> ");
INSERT INTO yam_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tɛ̀' nə dʉk fa yi də, <Mo àm, wu cugə̀ yòvesù fɛn, fana bum sə̀ mʉ̀ tse' yà' pwe'fo', a sə̀ yò. ");
INSERT INTO yam_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","A kə̀kʉrə̀ co a kaŋ, nə kwa anə, bʉ̀ʉsə̀ moma yònè'e à kpʉ, nə lù nə sə̀mok, yi à bisə mè laŋ nə yəə̀ŋ nə sə̀mok!> >> ");
INSERT INTO yam_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisòs à mà' fa bwe ye wèŋ gbʉ' mòk sə̀mok də, <<Ŋgà ghàk mòk à ye, nə̀ yi à tse' ŋwə̀ nəmòk nə̀ yi à fa bum ye sə̀ yi à tse' pwe' ndzə bohònà'. Bwìŋ sə kə tsoho fa yi də mo fàk ye nə sə njɛsə bum ye sə. ");
INSERT INTO yam_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ŋgà ghàk nə to nà', nə fek nà' də, <Mʉ̀ yuk də wù sə gʉ̀ yà ɛ? Tsok rɛŋsə fa mʉ bə fàak sə̀ wù a gʉ̀ pwe', bʉ̀ʉsə̀ wu nə kà ŋgà fàk àm mok ye fe'lə̀.> ");
INSERT INTO yam_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ŋgà fàk nə tsərə sə ntʉʉ̀ yi də, <Masà àm jə fis-a fàak yè'sə ndzə bohòmʉ̀, mʉ̀ gʉ yè'sə va? Mʉ̀ ka gʉgʉŋ co mʉ̀ tuŋ to nze yeŋ, mʉ dʉk-a də mʉ lɛŋ, yà' ye sə̀' marè'tu. ");
INSERT INTO yam_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mʉ̀ rì yusə̀ mʉ nə gʉ sə laŋ, ya bwìiŋ nə ko mʉ ŋge' ghà nə̀ mʉ̀ mè'rə fàak sə.> ");
INSERT INTO yam_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Fana yi to benə bʉ̀ʉ sə̀ wo tse' masà ye nə kəa pwe'fo'. Yi dʉk fa nə̀ mantombì nə də, <Wù tse' masà àm kəa mbàm sʉ̀?> ");
INSERT INTO yam_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ŋgà' nə dʉk də, <A bʉhʉ mve' ŋkʉ̀ mò'fis.> Ŋgà fàk nə dʉk fa fe'lə nà' də, <Cum nze, nə kòjəŋ ŋwàk nè'e com də a hum tàŋ.> ");
INSERT INTO yam_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Fana yi dʉk fa fe'lə mòk də, <Kəa yò-ɛ sʉ̀?> Nà' də, <A tasàa gòmbì ŋkʉ̀ mò'fis.> Ŋgà fàk nə dʉk fa nà' də, <Kòŋwàk nə̀ njò, nə com gesə nja də a hum fwame'.> ");
INSERT INTO yam_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Masà ye nə à kʉ̀k ja'a mo fàk ye nə, nə kwasə nà' bə nsàp ŋkərə̀ nə̀ nà' tse' nə. Bʉsə̀ wèŋ rì də bʉ̀ʉ sə̀ wo bɛ' megu mandzə̀ nzeŋgòŋ wèŋ rì ŋgòkərə bə bʉ̀ʉ awo nə casə bwe sə̀ wo mvwe' marɛŋ Nwì.>> ");
INSERT INTO yam_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Fana Jisòs dʉk də, <<Wèeŋ sə ko fa ni' awèŋ ŋge' bə ghàha nzeŋgòŋ sə̀ ntɛ̀ŋ, ya ŋga yà'a kà fàk mok kə tse' fana wo ko jəŋ nisə lo weŋ mvwe' lak sə̀ wèeŋ nə cum mam fo' mvèsə̀. ");
INSERT INTO yam_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","<<Ŋwə̀ nə̀ yi ye-a zìnə bə yusə̀ yà'a jo fana yi nə ye zìnə bə yusə̀ yà'a sə̀ ghaŋ sə̀'. Ŋwə̀ nə̀ yi ye-a ye ŋgà mvwès bə yusə̀ jo fana yi nə ye mali ŋgà mvwès bə yusə̀ yà'a sə̀ ghaŋ. ");
INSERT INTO yam_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","A ye-a də wù ka ŋwə̀ nə̀ zìnə bə ghàk nə̀ wà nə̀ sə nzeŋgòŋ nè'e yeŋ, ye də aco fa ghàk nə̀ zìnə nə ndzə bohòwù yè'sə ndà? ");
INSERT INTO yam_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A sə̀' də, a ye-a ŋga wù ka zìnə bə yusə̀ yà'a sə̀ ŋwə̀ nəmòk yeŋ, ŋwə̀ nə̀ yi nə fa wu sə̀ yà'a nə ye sə̀ yò-ɛ ndà? ");
INSERT INTO yam_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kaco ŋwə̀ nə̀ mò'fis fak ŋkwɛ̀ŋ bohòmasà ba yeŋ; yi nə dzəm fis mòk, nə bɛŋ mòk, kènə aco yi sə fàk bohòmòk nə̀ zìnə, nə kà mòk nə co yumok jə. Kaco wù fak bohòNwì, nə fak bohòmbàm yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bʉ̀ʉ Faràsi sə̀ wo à dzəm mbàm wèŋ à yuk bum yè'sə fana wo ywi'lə yi. ");
INSERT INTO yam_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisòs nə dʉk fa ye yà'wèŋ də, <<Yà'a wèŋ sə̀ wèeŋ gʉ̀gə̀ də wèeŋ yəəŋ mʉ lisə̀ bwìŋ co bʉ̀ʉ sə̀ bə̀boŋ, ŋga Nwì rì wes yusə̀ yà' cu sə ntʉʉ̀ wèŋ laŋ; bum sə̀ bwìiŋ tsərə də yà' tse' fàk wùriŋ fana yà'a yusə̀ Nwì bɛ̀ŋ yà'. ");
INSERT INTO yam_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Lʉ̀ʉk Musì bə bum sə̀ ŋgàa tsòhòbum Nwì wèŋ à còom sə à tse' ŋàŋ kə wɛs mvə̀k nə̀ Jon ŋgà bàptɛsə̀ bwìŋ à yèto ye; ye jəŋ mvə̀k ànə fana wo sə tsòho mok Ntirə̀ nə̀ Bə̀boŋ, nə̀ nà'a bə nzak gaŋ ŋkum Nwì fana ndàaŋwè pwe' sə kurə ni fo' bə ŋàŋ. ");
INSERT INTO yam_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A ye-a sə̀' vɛ'nə fana a jəjo bohòntòbu bə nzeŋgòŋ ŋgòcà gɛsə lòfo', nə noŋsə mvə̀m lʉ̀k nə̀ mò'fis ŋgòbʉ̀ʉŋ yusə̀ wà. ");
INSERT INTO yam_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","<<Ŋwə̀ nə̀ yi mè'rə-a ŋgwe ye, nə jəŋ mòk fana ye də ŋgə̀ŋgàŋ ko nto; ŋwə̀ nə̀ yi jə-a ŋwà nə̀ ndum a mè'rə yi fana ye də ŋwə̀ ànə ko sə̀' nto.>> ");
INSERT INTO yam_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisòs à mà' fe'lə gbʉ mòk sə̀' də, <<Ŋgà ghàk nəmòk à ye, yi sə ni megu cə̀ək sə̀ yà' gʉ ntɛŋ, nə sə zʉ megu zʉzʉʉ sə̀ bə̀boŋ nùumbu pwe'. ");
INSERT INTO yam_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ŋgà jìŋ mòk à sə kə̀ nòoŋ mvwe' ncùu ŋka' ye. Ni' ŋgà jìŋ nə à mègù mvwe'è mvwe'. ");
INSERT INTO yam_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yi à sə dzəm də yi sə te'e zʉ zʉzʉʉ sə̀ ŋgà ghàk nə sə zʉ fana yà' sə bəhə gbʉ tsoŋ sə nze sə. Ŋgbʉ à sə və̀ə kə̀ bə̀rə mvwe' ye sə. ");
INSERT INTO yam_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ŋgà jìŋ nə à kpʉ fana masinjàa Nwì wèŋ bək lo yi bohòAbràham. Ŋgà ghàk nə à kpʉ sə̀', wo tuuŋ yi. ");
INSERT INTO yam_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yi a cu mvwe' ŋgə' nə̀ sə misə̀, nə sə ye ŋgə' fo' wùriŋ. Fana yi fəsə kok lis, nə ye gesə lo Abràham mvwe' sə̀sap, bə Lasoròŋgʉ ni'ì nà'. ");
INSERT INTO yam_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yi to fis də, <Tɛ̀' am Abràham, koksə-a manziŋ bohòmʉ̀, nə tum Lasoròyi so gesə ndubo ye sə ndzəpə̀, nə kə fisə fa mʉ lʉm àm bə zeŋ, bʉ̀ʉsə̀ lʉm mis ènə sə tɛŋ barə mʉ wùriŋ.> ");
INSERT INTO yam_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abràham nə dʉk fa nà' də, <Mo àm, wù riŋ də wù à sə tse'gə̀ bum sə̀ bə̀boŋ yo ghà nə̀ wù à cu ntòŋwəm, fana Lasoròsə tse' ye bum sə̀ bʉp. Yi cu ye ŋga'a nè', sə yuk lʉ̀m fana wù sə ye bwi yòmok ŋgə' nə̀ bʉp. ");
INSERT INTO yam_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","A mè'rə-a yà'sə sə̀ vɛ'nə fana wo gʉ̀ maŋkì mòk nə̀ cəco wùriŋ mʉtsətsə'rəə wù bə vès. Wo à gʉ̀ nà' də ya ŋwèe kà ma ndzə̀ bohòwù to lòto, ŋwə̀ nə̀ ma nja kà bohòvès fɛɛŋ sə̀' to ya' və̀ to.> ");
INSERT INTO yam_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ànə geŋ ŋgà' nə dʉk fe'lə də, <Ye də tɛ̀' am, mʉ̀ lɛŋ wu də wu tum gesə lo yi nda'à tɛ̀' am. ");
INSERT INTO yam_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Bwema am sə̀ mbəmbam cu mbwa tu awo tàŋ. Yi tipsə yà'wèŋ bwɛ̀rɛ aco wo kə ni sə̀' mvwe' ŋgə'ə yè'sə.> ");
INSERT INTO yam_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abràham dʉk fa nà' də, <Ŋwàak Musì bə ŋgàa tsòhòbum Nwì wèŋ sə̀ njamòk cu ca, wo yuk bohòyà'.> ");
INSERT INTO yam_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yi dʉk də, <Tɛ̀' am Abràham, ka vɛ'nə yeŋ, bʉ̀ʉsə̀ ŋwə̀ nə̀ yi tesə mvwe' kpʉ kə̀ tsèŋ-a wo yi fana wo nə kupsə li.> ");
INSERT INTO yam_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abràham dʉk də, <A ye-a ŋga wo ka bohòMusì bə ŋgàa tsòhòbum Nwì wèŋ yuk fana ye də ŋwèe lòkok-a sə̀ mvwe' kpʉ, nə geŋ fana kaco wo kupsə wo yeŋ.> >> ");
INSERT INTO yam_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisòs à dʉk fa bwe ye wèŋ də, <<Mə̀mùmsə̀ə nə və tsoŋ li bohòbwìŋ yo; nə ye də a ŋgə' nə̀ bʉp bohòŋwə̀ nə̀ yi sə jə və mə̀mumsə̀ nə. ");
INSERT INTO yam_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Anə boŋ bohònsàp ŋwə̀ ànə co wo swi' fa yi ŋgòk mòk kə̀ mìhi, nə mak gesə lo yi bə zeŋ sə mvwe' ndzəp mòk nə̀ cəco, nə noŋsə nə̀ də yi gʉ bwe yè'e də mòok gʉ bʉp. ");
INSERT INTO yam_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wèeŋ sə jəŋ ŋkərə̀ bə tu awèŋ; a ye-a ŋga moma yo gʉ̀ wu bʉp wù sa'rə yi; a ye-a ŋga yi kupsə ntʉm fana wù swifa yi. ");
INSERT INTO yam_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A ye-a ŋga yi gʉ̀ bʉp bohòwù kɛ̀' sàmba nùmbu nə̀ mò'fis, nə bʉʉŋ dʉk sə̀' kɛ̀' sàmba pwe' də <Swìfa mʉ> fana, wu nə swifa tsoŋ yi.>> ");
INSERT INTO yam_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ŋgàa ntum Jisòs sə wèŋ à dʉk fa Tà də, <<Kùksə fa ves dzədzəm avès co ves naaŋ tu bohòwù.>> ");
INSERT INTO yam_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tà dʉk fa wo də, <<A ye-a ŋga wù tse' mègù-a dzədzəm momjo co mʉ ŋgwì tʉ nə̀ wo togə̀ nà' də mostà nà'a, fana aco wù dʉk fa ntseŋ tʉ càŋ nè'e də, <Coho mvwe' yè'e, nə kə təəŋ ndzə tsətsə'rəə ndzəp nà'a> fana, tʉ nə nə yuk dʉk yònə. ");
INSERT INTO yam_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","<<A dʉk-a də mòk mʉŋgorə̀ wèŋ tse' mofàk ye, nə̀ nà' sə wom fa yi fàk kè də nà' sə gʉ̀msə fa yi nsùŋgaaŋ ye àlɛ. A ye-a ŋga yi bwì foho və̀ ŋgòŋ anə, aco wu nə dʉk fa yi də, <Cà cum nze nə̀nàk, nə zʉ zʉzʉ> à? ");
INSERT INTO yam_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wu nə kà vɛ'nə dʉk. Wu nə dʉk lɛ də, <Lam fa mʉ zʉzʉ am, nə fʉhʉ ŋgòcàsə fa mʉ yà' fana wu nə yoŋsə mʉ̀ zʉ nə no wes yàm ŋkuŋ, wù zʉ nə no yò.> ");
INSERT INTO yam_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yi nə kwasə mofàk nə də bʉ̀ʉsə̀ nà' gʉ̀ mvəsə̀ yi dʉk də nà'a gʉ sə à? Hai' ka ye lok! ");
INSERT INTO yam_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yà' mègù bohòwèŋ yàwèŋ sə̀' vɛ'nə, a ye-a ŋga wèŋ gʉ̀ wes yusə̀ wo dʉk weŋ də wèeŋ gʉ fana wèŋ dʉk megu də, <Vèes yè'sə bwe fàk wà, vès gʉ̀ mègù fàak avès, sə̀ vès tse' ŋgògʉ̀ yà' co bwe fàk.> >> ");
INSERT INTO yam_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mʉmvə̀'nə̀ Jisòs à sə cà ŋgòlòJòrosalèm fana yi ca mʉtsətsə'rəə nzeŋgòŋ Sàmàriyà bə Galìli. ");
INSERT INTO yam_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yi ànə sə ni lo mvwe' mʉbuk lak mòk fana yi kʉrə bə ŋgàa kuturu mok wèŋ bwìŋ hum. Wo ànə sə təəŋ vèsə mvwe' mok mweè sə̀sap, ");
INSERT INTO yam_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","nə sə fuŋ torə fis də, <<Masà, Jisòs, koksə-a manziŋ bohòvès-ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yi ànə ye yà' fana yi dʉk fa wo də, <<Wèeŋ du kə niŋ tsok fa ni' awèŋ sə bohòŋgà fa satikà' ya yi ye weŋ də ni' awèŋ rɛŋ mok laŋ.>> Wo à sə lòo, yiya àwo nə me. ");
INSERT INTO yam_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mòk mʉŋgorə̀ wo anə mò'fis à yə də yiya ye nə mèe fana yi bwi foho və maŋkwɛ̀ŋ, nə sə fuŋ kwasə və Nwì. ");
INSERT INTO yam_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yi kə gbʉ nooŋ sə kùhu Jisòs sə nze, nə sə kwasə nà'. Ŋwə̀ ènə ànə ye ŋwə̀ə Sàmàriyà. ");
INSERT INTO yam_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ànə geŋ Jisòs nə fek də, <<Mʉ̀ gʉŋsə ka bwìŋ hum yeŋ à? Sə̀ və̀ke' fò? ");
INSERT INTO yam_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ye də ŋwə̀ nəmòk ka nə̀ co yi kə kùksə Nwì yeŋ, mègù ŋkʉ̀ìŋ nè'e à?>> ");
INSERT INTO yam_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Fana yi bʉʉŋ dʉk fa ŋgà' nə də, <<Lòkok mʉtsə̀, nə lo yuyo, dzədzəm yògʉŋsə wu laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bʉ̀ʉ Faràsi mok wèŋ à fek Jisòs də gaŋ ŋkum Nwì sə nə̀ kə̀ və̀ yè'sə sèŋ-nɛ? Fana yi dʉk fa yà'wèŋ də, <<Gaŋ sə̀ Nwì sə və̀ə, ŋwè kà yà' bə lis jəja yə. ");
INSERT INTO yam_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kaco bwìiŋ nə dʉk də, <Wèeŋ ye yà'a yè'> kè də, <Wèeŋ ye yà'a yà'> sə̀' yeŋ, bʉ̀ʉsə̀ gaŋ sə̀ Nwì sə yà'a mʉŋgorə̀ wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ànə geŋ Jisòs nə dʉk fa bwe ye wèŋ dʉk də, <<Mvə̀k mòk sə və̀ə nə̀ wèeŋ nə dzəm vɛ'ɛ co wèŋ ye nùmbu mòk nə̀ Mo Ŋwèe nə ye fo' fana wèŋ kà nà' yə. ");
INSERT INTO yam_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bwìiŋ nə sə dʉk fa weŋ də, <Kʉ̀k gèsə ndzə fa', yi nà'>, kè də, <Kʉ̀k gèsə ndzə fɛn, yi nè'> fana wù kà gə̀, nə kà wo sə̀' yù. ");
INSERT INTO yam_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mvə̀'nə̀ mbʉ̀ʉŋ ba'agə̀ mʉbu, nə rɛŋ jəŋ mamòk kə dzeŋ mamòk yà'a fana, nùmbu njàam ye, mʉ̀ʉ mo ŋwè, mʉ nə ye sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Megu də mʉ nə ye tsoŋ ŋgə' ŋkʉ̀ʉŋntɛ̀ŋ, bʉ̀ʉ sə̀ niè' wèŋ bɛŋ mʉ sə̀' ŋkuŋ. ");
INSERT INTO yam_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mvə̀'nə̀ yà' ànə ye mʉnə nùumbu sə̀ Nuà yà'a fana nùumbu sə̀ yàm, mo ŋwèe nə̀ ye sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wo à sə zʉ, sə no, wo sə caŋ gù, nə sə geŋ gù tə̀tè kə wɛs nùmbu nə̀ Nuà ànə ni ŋgwes fana ndzəp rwiŋ və kə zə wes wo pwe'. ");
INSERT INTO yam_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yà'a sə̀' mʉmvə̀'nə̀ Lot ànə ye yà'a. Bwìŋ à sə zʉ, nə sə no, wo sə ywiŋ bum, nə sə seeŋ bum, nə sə bi bum, nə sə ci ndap; ");
INSERT INTO yam_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","fana nùmbu nə̀ Lot ànə tesə gɛsə lo mvwe' lak Sodòm fana mis tsooŋ mʉbu bə nsàp lìs mòk nə̀ nà'a kʉəgə̀ mis maŋgəŋgèŋ, nə kə tɛŋ zə wes wo pwe'. ");
INSERT INTO yam_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nùmbu nə̀ mʉ̀ʉ mo ŋwè mʉ nə yəəŋ fana yà'a nə̀ ye sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","<<Nùmbu ànə ye, ŋwə̀ nə̀ yi cu yòŋsə mʉ ndùndap, ŋga yi tse' bum mʉ nda'à, kà ŋgòkə̀ jə yà' suhù tsə. Ŋwə̀ nə̀ yi mʉnə nzum fàak nə kà maŋkwɛ̀ŋ də yi kə jəŋ bum mʉ nda'à sə̀ fohòlò. ");
INSERT INTO yam_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Wèeŋ sə tsərə tse' yusə̀ yà' ànə ye bohòŋgwe Lot. ");
INSERT INTO yam_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ŋwə̀ nə̀ yi làp-a də yi noŋsə yòŋsə̀ ye fana yi nə bisə nà', fana ŋwə̀ nə̀ yi dzəm-a də yi bisə yòŋsə̀ ye fana yi nə tse' nà'. ");
INSERT INTO yam_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mʉ tsok fa weŋ də nə̀ ndzəmə̀ ànə nə̀ ye ŋga bwìŋ nòbə kè mò'fis ba, wo nə jəŋ fis lo mò'fis, nə me'rə noŋsə mòk fo'. ");
INSERT INTO yam_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bə̀ba nə sə gok bɛŋ mvwe' mò'fis wo ba; wo nə jəŋ fis lo nə̀ mò'fis fana, nə me'rə noŋsə mòk fo'. ( ");
INSERT INTO yam_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mbəmbam baa nə sə fak nzum, wo jəŋ fis lo mòk, nə me'rə mòk.)>> ");
INSERT INTO yam_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ànə geŋ ŋgàa fàak ye sə wèŋ fek yi də, <<Anə ye ma fòTà?>> Yi dʉk fa yà' də, <<Mvwe' sə̀ vè ni' nòoŋ, jìgawà' wèeŋ nə kə benə fo'.>> ");
INSERT INTO yam_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisòs à tsə̀' fa bwe ye wèŋ gbʉ' nè'e də ya yà'a sə lɛŋ pìriyà, nə kà wò. ");
INSERT INTO yam_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","<<Ŋgà sak nzak mòk à ye mvwe' lak mok, nə̀ yi à sə kà Nwì wəpgə̀, nə kà bwìŋ sə̀' wəp. ");
INSERT INTO yam_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ŋwà ŋgwemfə mòk ye mvwe' lak yà'sə sə̀', nə̀ yi à sə və̀gə̀ bohòŋgà sak nzak nə riŋriŋ. Ŋwà nə à sə və̀, nə sə dʉhʉ fa ŋgà' nə dʉk də, <Sak gapsə-a mʉ ves ŋwə̀ nə̀ yi bɛ̀ŋgə̀ mʉ nè'e-nɛ̀.> ");
INSERT INTO yam_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ŋgà' nə à sə bɛ̀ŋ togə̀ ntòbɛ̀ŋnə fana ànə cum kok ghàr ŋgà' nə dʉk sə və̀ə yi də, <A ye-a sə̀ də mʉ kà Nwì wəpgə̀, nə kà bwìŋ sə̀' wəp fana ");
INSERT INTO yam_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","megu bʉ̀ʉsə̀ ŋwà nè'e sə kə̀ fa mʉ ŋgə' wùriŋ, fana mʉ nə sak fa yi nzak ye nə, bwɛ̀rɛ yi sə vəhə mali ŋgòloksə mʉ ntu'.> >> ");
INSERT INTO yam_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Fana Tà Jisòs dʉk fa wo də, <<Wèeŋ yuk-ɛ yàwèeŋ yusə̀ ŋgà sak nzak nə̀ yi ka zìnə tse' nə cèep-ɛ̀. ");
INSERT INTO yam_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ye də kaco Nwì tɛsə bʉ̀ʉ sə̀ yi à co'fis, sə̀ wo sə lɛŋ bohòyi nùm bə ndzəm sə yeŋ àlɛ? Aco yi cum casə mvə̀k ŋga yi ka yà' ntòyuk fa à? ");
INSERT INTO yam_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Hai', mʉ tsok fa weŋ də yi nə təəŋ fa yà' gèm nə sak nzak nə nə̀nàk nə ye kə̀kʉrə̀. A ye-a sə̀ vɛ'nə fana ghà nə̀ mʉ̀ʉ mo ŋwèe nə̀ bwìŋ və̀ə, mʉ nə̀ yə bwìŋ ŋga wo tse' dzədzəm ŋgòlɛŋ Nwì, nə kà wòyo àlɛ-ò?>> ");
INSERT INTO yam_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jisòs à mà' gbʉ' nè'e bohòbʉ̀ʉ mok sə̀ wo à sə tsərə də wo bʉ̀ʉ sə̀ kə̀kʉrə̀ mʉ lisə̀ Nwì fana wo sə jəŋ bʉ̀ʉ mok wèŋ co yusə̀ wà. ");
INSERT INTO yam_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","<<Bwìŋ ba à lòmʉmvwe' ndap Nwì nə̀ ghaŋ ŋgòkə̀ lɛŋ pìriyà. Mòk à ye ŋwə̀ə Faràsi fana mòk ye sə̀ ye ŋgà ko mbàam tas. ");
INSERT INTO yam_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ŋwə̀ə Faràsi nə à təəŋ, nə lɛŋ pìriyà nə̀ nje də, <Mʉ̀ kwasə wu Nwì, bʉ̀ʉsə̀ mʉ̀ ka yàm co bʉ̀ʉ mok wèŋ yà'a yeŋ. Bʉ̀ʉ mok yàwo ŋgàa limzʉ bum bwìŋ, ŋgàa cì' mvwès nə ye ŋgàa kohònto. Mʉ̀ kwasə wu də mʉ̀ ka co ŋgà ko mbàam tas nə̀ yi nè'e sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mʉ jəgə̀ sənə ntɛŋ nə̀ mò'fis nùumbu ba, nə dzə zʉzʉ ŋgòlɛŋ wu. Yusə̀ mʉ̀ tse' pwe', mʉ cokfisgə̀ mamòk ca ŋgòfa wu.> ");
INSERT INTO yam_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ŋgà ko mbàam tas nə ànə təəŋ ye mvwe' sə̀sap. Yi kà lis mʉbu sə̀ kʉ̀k ja'à gèsə̀, yi wa'a tse' bo, nə lɛŋ də, <Nwì, koksə manziŋ bohòmʉ̀ nə̀ mʉ ŋgà gʉ̀ bʉp!> ");
INSERT INTO yam_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mʉ tsok weŋ də ŋwə̀ ènə ànə bwìŋ foho lo la'à yi co ŋwə̀ nə̀ kə̀kʉrə̀ mʉlisə̀ Nwì nə noŋsə mòk nà'a. Bʉsə̀ ŋwə̀ nə̀ yi jə fis kok lò-a ni' ye mʉbu fana wo nə jəŋ tsoŋ lo yi tsətsoŋ; ŋwə̀ nə̀ yi jə tsoŋ lò-a ni' nje sə nze fana wo nə jəŋ fis kok lo yi mʉbu.>> ");
INSERT INTO yam_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wo à sə jə və̀ fa Jisòs bəbweŋke' də ya yi jwɛŋ yà' bə bo nə se yà' fana ŋgàa fàak ye wèŋ ànə ye vɛ'nə, wo jwa sa'rə bʉ̀ʉ sə də yà'a kà vɛ'nə gʉ̀. ");
INSERT INTO yam_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jisòs ànə ye vɛ'nə, yi to bwe sə, nə dʉk də, <<Wèeŋ me'rə bəbweŋke' wèeŋ və bohòmʉ̀, nə kà wo mandzə̀ lok; bʉ̀ʉsə̀ gaŋ ŋkum sə̀ Nwì sə, tse' yà' nsàap sə̀ co wo yè'sə. ");
INSERT INTO yam_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mʉ tsok fa weŋ ŋkèm dʉk də, ŋwə̀ nə̀ yi ka-a gaŋ sə̀ Nwì sə co mvə̀'nə̀ bweŋke' jəgə̀ bum jə ye də kaco ŋgə̀ŋgàŋ kə ni fo' yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ŋkwà' ŋwə̀ bʉ̀ʉ Jus mòk à və̀ kə̀ fek Jisòs də, <<Cicà nə̀ bə̀boŋ, yusə̀ aco mʉ̀ gʉʉ yè'sə yà, ya mʉ nə kə tse' lùŋ nə̀ nà'a nə̀ kà mè-ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisòs dʉk fa nà' dʉk də, <<Wù to mʉ də ŋwə̀ nə̀ bə̀boŋ bʉ̀ʉ yà? Ŋwə̀ nə̀ bə̀boŋ bʉ̀ə̀, mègù Nwì yiìyi. ");
INSERT INTO yam_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wù rì lʉ̀ʉk sə laŋ də, <Kà sàhà ko, kà ŋwè zə, kà yə̀yə̀, kà gèem mvwès ko, nə wəp tɛ̀' yo bə ma yo.> >> ");
INSERT INTO yam_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ŋgà' nə dʉk də, <<Mʉ̀ à gʉ̀ yè bum sə̀ wù taŋsə yè'sə ŋga mʉ̀ cu ntòmʉwà'ŋwè.>> ");
INSERT INTO yam_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisòs ànə yuk vɛ'nə fana yi dʉk fa nà' də, <<Wù sə jamə mok yu nə̀ mò'fis. Lòkə̀ sèŋ bum sə̀ wù tse', nə gapsə fa ŋgàa jìŋ wèŋ mbàam sə, ya wu nə tse' ghàk mʉbu; nə bɛ' mandzə̀ yuŋ və mʉ.>> ");
INSERT INTO yam_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yi ànə yuk vɛ'nə fana ŋgùpcù gbʉ yi yə̀k, bʉ̀ʉsə̀ yi à ye ŋgà ghàk nə̀ wù kà fʉ̀k. ");
INSERT INTO yam_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisòs à kʉ̀k ja'a nà', nə dʉk də, <<Yà' gʉ vɛ'ɛ wùriŋ bohòŋgàa ghàk ŋgòkə̀ ni mvwe' gaŋ Nwì sə! ");
INSERT INTO yam_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Joho cà bohònàm nə̀ yi yam co nàmbà'rə̀ nà'a ŋgòcà torə tesə ndzənə wʉ patà', nə noŋsə bohòŋgà ghàk ŋgòkə̀ ni mvwe' gaŋ sə̀ Nwì sə.>> ");
INSERT INTO yam_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bʉ̀ʉ sə̀ wo à yuk ncèp ènə à dʉk də, <<Ye də aco ŋwə̀ nə̀ yi tse' to lùuŋ yè'sə ndà?>> ");
INSERT INTO yam_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisòs dʉk fəsə də, <<Yusə̀ yà' gʉ bohòŋwè ŋgògʉ̀ to fana aco Nwì gʉ ye yà' yo.>> ");
INSERT INTO yam_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ànə geŋ Pità dʉk də, <<Ja'a na, vès a mè'rə wes ndap avès pwe', nə bɛ' və̀ nə wu.>> ");
INSERT INTO yam_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisòs dʉk də, <<Mʉ̀ sə tsə̀' fa weŋ zìnə də, ŋwə̀ nə̀ yi me'rə-a ndap ye kè ŋgwe ye kè bwema kè tɛ̀' bə ma, kè bwe ye də a njo gaŋ ŋkum sə̀ Nwì sə fana, ");
INSERT INTO yam_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ŋgə̀ŋgàaŋ nə tse' sə̀ yà' càsə yà'sə nie', nə tse' lùŋ nə̀ nà'a nə̀ kà mè nə ntsə'mòk sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisòs ànə jəŋ fəsə gɛsə ŋgàa fàak ye sə̀ hum-ncòp-ba sə wèŋ, nə tsok fa wo də, <<Wèeŋ yeè, vesùwèŋ sə kok lòyè'e mʉ Jòrosalèm, fana bum sə̀ ŋgàa tsòhòbum Nwì wèŋ ànə com bə liŋ am Mo Ŋwèe nə bʉʉŋ və zìnə. ");
INSERT INTO yam_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Wo nə fa mʉ bohòbʉ̀ lakmvum, fana wo ywi'lə mʉ, nə gʉ fa mʉ bum marè'tu wùriŋ, nə te mʉ bə nte. ");
INSERT INTO yam_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wo nə ləp mʉ, nə zə mʉ, mʉ kpʉ fana a kə̀ dzèŋ nùmbu nə̀ tɛ', mʉ luŋ lokok sə̀mok.>> ");
INSERT INTO yam_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ànə geŋ wo kà yusə̀ yi cèp yè'sə rɛɛŋ lok. Ànə ye ŋga ŋkərə̀ awo nsàp nə̀ co wo kà bə ncèp ènə rɛɛ̀ŋ, fana yà' ye bohòwo anə sə̀swihì ŋgòrɛɛŋ yà'. ");
INSERT INTO yam_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisòs nə ànə kʉəp və mvwe' lak Jèrikù fana ŋga ŋgà jì lis mòk cu ŋgʉ mandzə̀ anə, nə sə lɛɛŋ bum. ");
INSERT INTO yam_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yi ànə yuk ŋga bwìŋ sə cà fo' wùriŋ fana yi fek də sə gʉ̀ yàlɛ. ");
INSERT INTO yam_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Fana wo tsok yi də, <<Jisòs nə̀ mvwe' lak Nazàrɛ sə cà yi.>> ");
INSERT INTO yam_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Fana yi waŋ torə fis də, <<Jisòs mo ŋkum Devìd, koksə-a manziŋ bohòmʉ̀-ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bʉ̀ʉ sə̀ wo ànə ye fo' sə wèŋ gham yi də yi cum gəe'. Yi ghaha wesə ye ghaha də, <<Mo Devìd, koksə manziŋ bohòmʉ̀!>> ");
INSERT INTO yam_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ànə geŋ Jisòs foho təəŋ, nə də wo jəŋ və nà'. Nà' ànə kʉəp və fana yi fek ŋgà' nə də, ");
INSERT INTO yam_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","<<Yusə̀ wù dzəm də mʉ gʉ fa wu yè'sə yà?>> Ŋgà' nə dʉk də, <<Tà, mùk fa mègù mʉ lis ya mʉ ye bum sə̀mok.>> ");
INSERT INTO yam_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jisòs nə dʉk fa nà' də, <<Lis yo sə muhu, ntʉm yònə̀ wù fa bohòmʉ̀ gʉŋsə wu laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ànə geŋ lis ye sə muhu sə̀ ghà nə fo' fana yi gi yuŋ lo Jisòs nə, nə sə kuksə Nwì. Bʉ̀ʉ sə̀ wo ànə ye nsàp yu ènə pwe' à kùksə Nwì sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisòs ànə kə ni mvwe' lak Jèrikù, fana nə sə gi ŋgòcà lòo. ");
INSERT INTO yam_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ŋwə̀ nəmòk ànə ye fo' nə̀ liŋ yee də Sàkiyò. Yi ànə ye ŋkum ŋgàa ko mbàam tas mòk nə̀ ghaŋ yi, nə ye sə̀' ŋgà ghàk. ");
INSERT INTO yam_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yi lap co yi ye Jisòs, mandzə̀ kà ye bʉ̀ʉsə̀ bwìŋ à ye fo' wùriŋ fana yi ye bwi ye ŋwə̀ nə̀ lə̀m. ");
INSERT INTO yam_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ànə geŋ yi caŋ lo mantombì, nə kə kok tʉ mòk nə̀ wo to nà' də Sikamòdə ya yi ye nà', bʉ̀ʉsə̀ Jisòs nə ànə ye ŋgòcà ma nà'nə. ");
INSERT INTO yam_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisòs ànə kə wɛs mvwe' sə fana yi kʉk kok gesə lo mbwa, nə dʉk fa nà' də, <<Sàkiyò, suhu tsoŋ mbwa nə̀nàk bʉ̀ʉsə̀ mʉ nə nooŋ ntinə nè'e mʉ nda'à wù.>> ");
INSERT INTO yam_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ànə geŋ yi suhu tsoŋ nə̀nàk, nə kə jəŋ nà' bə kwəkwa. ");
INSERT INTO yam_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bwìŋ ànə ye vɛ'nə fana wo ŋwəm wes wo pwe' də, <<Yi lòŋgòkə̀ nòoŋ bə ŋwə̀ nə̀ yi ŋgà gʉ̀ bʉp.>> ");
INSERT INTO yam_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sàkiyònə lokok dʉk fa Tà nə də, <<Yeè Tà, mʉ nə gapsə bum am mʉtsətsə'rə̀ bə tsətsə'rə̀, nə fa mamòk bohòŋgàa jìŋ wèŋ. A ye-a ŋga mʉ̀ a limzʉ yu ŋwə̀ nəmòk fana mʉ nə lak fəsə fa yi yà' kɛ̀' kwè.>> ");
INSERT INTO yam_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisòs dʉk fa nà' də, <<Lùŋ və̀ mʉmvwe' ndap nè'e ntinə, bʉ̀ʉsə̀ wu mo Abràham sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","A yè'sə də mʉ̀ʉ mo ŋwè, mʉ̀ a və̀ ŋgòkə̀ làp nə luŋsə bʉ̀ʉ sə̀ wo à bisə.>> ");
INSERT INTO yam_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mʉmvə̀'nə̀ bʉ̀ʉ sə wèŋ à sə yu'rə bum yè'sə fana yi tsok fa mali wo gbʉ' mòk. Ànə ye ŋga yi kʉəp lòJòrosalèm fana bʉ̀ʉ sə̀ bə yà'wèŋ à ye sə, à sə tsəm yàwo də gaŋ ŋkum sə̀ Nwì sə nə yəəŋ ghà nà'nə. ");
INSERT INTO yam_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Fana yi dʉk də, <<Ŋwə̀ nəmòk à ye nə̀ yi à tesə mʉ ntòmbii ŋkum. Yi lòmvwe' lak mok sə̀ sə̀sap də wo kə koksə yi gaŋ ya yi bwi və la'à yi. ");
INSERT INTO yam_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yi benə bwe fàak ye wèŋ bwìŋ hum, nə fa wo mbàm ncùhù hum. Yi dʉk fa yà' də yà'a sə ywiŋ seŋ bum bə zeŋ tè yi bwi foho və. ");
INSERT INTO yam_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ànə geŋ bʉ̀ʉ lak ŋkwà' ŋwə̀ nə wèŋ bɛŋ yi. Wo tum lo bʉ̀ʉ mok wèŋ maŋkwɛ̀ɛŋ yi bə ntirə̀ də, <Vès ka dzəm də ŋwə̀ ànə ye ŋkum àvès dzəm.> ");
INSERT INTO yam_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","<<Ànə geŋ wo koksə yi gaŋ sə, yi bwi foho və. Yi to benə bwe fàak sə̀ yi ànə fa wo mbàm sə, də ya yi ja'a də yà' a tse' swe' mbàm sʉ̀ nɛ. ");
INSERT INTO yam_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ŋwə̀ nə̀ mantombì à və̀ə, nə dʉk də, <Tà, mbàm nə̀ wù a fa mʉ mò'fis nə a bʉ̀ʉŋ mok hum.> ");
INSERT INTO yam_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ŋkwà' ŋwə̀ nə kwasə nà' də, <Wusùkù', mo àm-a', wù gʉ̀ bə̀boŋ. Wù nìtsə̀' zìnə yòbə mʉyu nə̀ nà'a momjo laŋ, fana mʉ gʉ wu ŋga'a ŋgòkotse' buhu lak hum.> ");
INSERT INTO yam_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ŋwə̀ nə̀ ba à və̀ə, nə dʉk də, <Tà, mbàm nə̀ mò'fis nə, a bʉ̀ʉŋ mok tàŋ.> ");
INSERT INTO yam_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yi dʉk fa nà' də, <Wù tse' yòsə̀' buhu lak tàŋ.> ");
INSERT INTO yam_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mòk à və̀ sə̀', nə dʉk ye də, <Tà, mbàm yònə nè', mʉ̀ a kì lòksə nà' ndzənə gàcə̀k. ");
INSERT INTO yam_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bʉsə̀ mʉ̀ a sə wəp də wu nsàp ŋwə̀ nə̀ wù gʉ wùriŋ. Wu te'e jəgə̀ yusə̀ wù anə ka noŋsə, nə sə kʉp jəŋ yusə̀ wù à ka wù bi.> ");
INSERT INTO yam_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yi dʉk fəsə fa nà' də, <Mʉmvə̀'nə̀ wù cèp də mʉ nsàp ŋwə̀ nə̀ vɛ'nə yà'sə, mʉ nə sak wu sə̀' vɛ'nə. Wu mo nə̀ bʉp! Wù rìŋ də mʉ ŋwə̀ nə̀ mʉ̀ gʉ wùriŋ, nə̀ mʉ te'e jəgə̀ yusə̀ mʉ̀ à ka noŋsə; mʉ̀ sə kʉp mvwe' sə̀ mʉ̀ à ka bi àlaa? ");
INSERT INTO yam_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nə gʉ va bwɛ̀rɛ wù à kə̀ gèsə fa mʉ mbàm am sə mvwe' ŋgwa' mòk, də ya mʉ və̀ ŋgòjə yà', ŋga mʉ swe' na mbwa-ɛ?> ");
INSERT INTO yam_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yi bʉʉŋ dʉk fa bʉ̀ʉ sə̀ wo à ye fo' sə wèŋ də, <Wèeŋ fep fis jəŋ ncùhù nə̀ bohòyi nə, nə fa nà' bohòŋwə̀ nə̀ yi nə tse' fa' ncùhù hum nà'a.> ");
INSERT INTO yam_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Wo dʉk fa yi də, <Tà, yi tse' ncùhù hum ye laŋ!> ");
INSERT INTO yam_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ŋkwà' ŋwə̀ nə də, <Mʉ tsok fa weŋ də ŋwə̀ nə̀ yi tse'-a yo fana wo nə naaŋ yamsə fa yi mok. Nə ye də bohòŋwə̀ nə̀ yi ka ye yumok tse' nə, a megu-a sə̀ mʉyu nə̀ jo nə̀ yi tse' nà' nə, wo nə jəŋ fis gɛsə nà' ndzə bohòyi anə fo'. ");
INSERT INTO yam_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A ŋga'a mok bohòbʉ̀ʉ sə̀ wo sə bɛ̀ŋ mʉ də mʉ nə kà ŋkum awo ye yè'e wèŋ. Wèeŋ jəŋ və wo fɛn, nə sʉə wo mʉlisə̀ mʉ̀.> >> ");
INSERT INTO yam_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisòs ànə cep wes yè'sə fana yi sə lo mantombì ŋgòkok lòmʉ Jòrosalèm. ");
INSERT INTO yam_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yi à kʉəp və̀ mvwe' lak Befà bə Betanì fana wo wɛsə və mvwe' nda Olìp. Yi tumsə gesə ŋgàa fàak ye ba. ");
INSERT INTO yam_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yi dʉk fa yà'wèŋ də, <<Wèeŋ du mvwe' lak sə̀ ndzə yà'a, wèeŋ sə nikok lòntɛ̀ŋ, wèŋ ye mvomndè' mòk nə̀ ŋwè ka nà' kok yuk; wèŋ fiŋ jəŋ və nà' fɛn. ");
INSERT INTO yam_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A ye-a ŋga ŋwə̀ mòk fek weŋ də wèŋ sə fì nà' bʉ̀ʉ yàlɛ fana wèŋ dʉk fa yi də, <Tà tse' fàk bə zeŋ.> >> ");
INSERT INTO yam_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bʉ̀ʉ sə̀ yi à tum sə à lòo, nə kə ye megu sə̀' mvə̀'nə̀ yi dʉk wo sə. ");
INSERT INTO yam_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mvə̀'nə̀ wo à sə fìrə mvomndè' nə fana ŋwə̀ nə̀ yi tse' nà' nə fek wo də, <<Wèŋ sə fìrə mvomndè' nə bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wo dʉk fa yi də, <<Tà tse' fàk bə zeŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ànə geŋ wo jəŋ və fa Jisòs nà'. Wo fweŋ cə̀ək awo, nə naaŋ fa mvomndè' nə mʉŋkwɛɛ̀ŋ, nə cumsə Jisòs mbwa. ");
INSERT INTO yam_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mʉmvə̀'nə̀ yi à sə kok lònà' fana wo fweŋ noŋsə lo cə̀ək awo sə mandzə̀ anə. ");
INSERT INTO yam_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wo ànə kʉəp və Jòrosalèm, ŋga wo sə suhu tsə mok nda Olìp nə fana maŋgo bʉ̀ nə̀ wo à sə yù yi nə wèŋ ye ŋgòkwa, nə sə fuŋ kuksə Nwì bə nsàap bum maŋgəŋgèeŋ sə̀ wo yə sə. ");
INSERT INTO yam_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wo sə dʉk də, <<Nwìi se ŋkum nə̀ yi və̀ mʉnə liŋ Tà! Fifi ye mʉbu, kə̀kʉ̀ksə̀ə ye bohòNwì nə̀ yi yam càsə yà lòoŋ fo'.>> ");
INSERT INTO yam_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ànə geŋ bʉ̀ʉ Faràsi mok sə̀ wo à ye sə̀' mʉŋgorə̀ anə dʉk fa Jisòs də, <<Cicà, jwa bwe yo yè'e də wo cum gəe'.>> ");
INSERT INTO yam_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisòs dʉk fa wo də, <<Mʉ tsok fa weŋ də wo cu-a gəe', lìis yè'e cep cù.>> ");
INSERT INTO yam_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yi ànə kʉəp və, nə ye ntʉm lak nə fana yi yeto ŋgòwa fa nà' də, ");
INSERT INTO yam_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","<<Anə ye-a ŋga'a də wù riŋ yusə̀ aco yà' jəŋ və fifi bwɛ̀rà. Megu də kaco lis yo ye yà' ŋga'a yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nùmbu mòk sə və̀ bohòwù, nə̀ bʉ̀ʉ sə̀ wo sə bɛ̀ŋ wuu nə və dzè' bohòwù, nə gʉm dzooŋ wu ŋgʉŋ ma nə̀ fòpwe'. ");
INSERT INTO yam_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wo kʉəmsə mak mbàandap yo sə nze, nə le' mak bʉ̀ʉ yo bə bwe yo sə̀ wo cu mʉmvwe' və̀əm ndap yo sə pwe'. Wo nə kà lìs nə̀ mò'fis mʉnə mòk mè'rə naaŋ bʉ̀ʉsə̀ wù à ka ghà nə̀ Nwì à kə̀ kɛ' yə weŋ nə riŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ànə geŋ yi kə ni lo mʉmvwe' ndap Nwì nə̀ ghaŋ nə, nə sə bɛ'fis bʉ̀ʉ sə̀ wo sə sèeŋ bum mbwa. ");
INSERT INTO yam_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yi sə cep də, <<Wo à còm nòŋsə ndzənə ŋwàk Nwì, sə kum ndap Nwì nə̀ ghaŋ ènə də, <Ndap nə̀ njàm nə, nə ye ndap nə̀ ŋgòlɛŋ mbwa pìriyà;> fana wèŋ jə bʉ̀sə nà' ndap ŋgàa yə̀ wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yi à sə yə'rə bwìŋ mʉmvwe' ndap Nwì nə̀ ghaŋ nə nùumbu pwe'. Ŋgàa fa satikà' bə ŋgàa yə'rə̀ fa bwìŋ lʉ̀k bə bʉ̀ʉ sə̀ ghaŋ sə wèŋ sə lap ŋgòzə yi. ");
INSERT INTO yam_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wo kà yusə̀ co wo gʉ sə rì bʉ̀ʉsə̀ bwìŋ pwe' à dzəm tse' mègù ncèp nə̀ nje nə. ");
INSERT INTO yam_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nùmbu mòk à ye ŋga Jisòs sə yə'rə bwìŋ, nə sə tsoho fa wo Ntirə̀ nə̀ Bə̀boŋ nə mʉmvwe' ntòmbi ndap Nwì nə̀ ghaŋ nə fana ŋgàa fa satikà' sə̀ ghaŋ bə ŋgàa yə'rə̀ fa bwìŋ lʉ̀k nə ye bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ kə tseŋ yi. ");
INSERT INTO yam_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Wo à və̀ə, wo fek yi də, <<Vès dzəm ŋgòrì də wù gʉ̀ bum yè'sə bə ŋàaŋ sə̀ fò? Kènə fa wu ŋàŋ ndà də wu gʉ yà' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yi dʉk fa fəsə yà'wèŋ də, <<Mʉ tse' ŋgòfek weŋ yusəmok yàm sə̀', wèeŋ tsok fa mʉ-a də, ");
INSERT INTO yam_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","mvwe' sə̀ Jon ànə jəŋ ŋàaŋ sə̀ ŋgòbàptɛsə bwìŋ fo' yà'a ànə və bohòNwì kè yà' ànə tesə bohòbwìŋ-ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wo à yèto ŋgòcèp bə zeŋ, nə sə fe'rə ni' awo də, <<A tsok fa yi yè'sə da? Bʉsə̀ a dʉk-a də, ŋàaŋ sə à sə və̀ bohòNwì fana yi nə fek fe'lə ves də, ànə geŋ vesùwèŋ kà yusə̀ Jon à sə cèep dzəm bʉ̀ʉ yà lɛ. ");
INSERT INTO yam_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nə ye sə̀' də a ye-a ŋga a dʉk də, ŋàaŋ sə à tesə bohòbwìŋ fana bwìiŋ nə təm ves bə lìs, bʉ̀ʉsə̀ wo à dzəm yàwo zìnə də Jon à ye ŋgà tsòhòbum Nwì.>> ");
INSERT INTO yam_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Fana wo dʉk fa nà' də wo ka mvwe' sə̀ yà' ànə və sə riŋ. ");
INSERT INTO yam_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jisòs dʉk bwi fa wo ye sə̀' də, <<Ye də mʉ nə kà weŋ nsàp ŋàŋ nə̀ mʉ̀ tse' ŋgògʉ̀ bum yè'sə bə zeŋ nə sə̀' tsə̀'.>> ");
INSERT INTO yam_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ànə geŋ Jisòs ye ŋgòtsə̀' fa bʉ̀ʉ sə wèŋ gbʉ' nè'e də, <<Ŋwə̀ nəmòk à bì nzum ye, nə tes yà' bohòbʉ̀ʉ səmok də ya yà'wèeŋ nə sə lak yi. Yi ànə fa wo fana yi ye'e lo mvwe' lak mok, nə kə cum mam fo' mvə̀k sə̀sap. ");
INSERT INTO yam_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mvə̀k nə̀ ŋgòkʉp bum sə̀ mʉnzuù sə ànə kʉrə fana ŋgà nzum nə tum ŋgà fàk ye mòk də nà'a lo bohòbʉ̀ʉ sə̀ mʉnzuù yi sə, də yà'a fa yi ma nje. Bʉ̀ʉ sə wèŋ ləp yi, nə tum fəsə lo yi botu. ");
INSERT INTO yam_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yi tumsə fe'lə ŋgà fàk ye mòk. Wo ləp nà'nə sə̀', nə koksə nà' marè'tu vɛ'ɛ, nə tum fəsə lo nà' sə̀' botu. ");
INSERT INTO yam_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yi tum ŋgà fàk ye mòk sə̀' nə̀ tɛ'. Wo fa nà'nə mvwe', nə bɛ' fis gɛsə yi fo'. ");
INSERT INTO yam_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Fana ŋgà nzum nə dʉk də, <Mʉ gʉ kok yè'sə va? Mʉ tum lɛ mo àm nə̀ mʉ̀ dzəm yi wùriŋ nè'e, kàmòk wo yə-a də a yi, wo nə wəp li tsoŋ yi!> ");
INSERT INTO yam_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bʉ̀ʉ sə̀ mʉnzuù sə wèŋ ànə ye nà' fana wo dʉk mʉŋgorə̀ àwo anə də, <Nè'e ŋga'a monə̀ ndzə və̀ə yi nə̀ ŋkwà' ŋwə̀ nə kà-a ye, yi nə cum mvwe' kùu nà' yi nə. Vesùwèeŋ zə yi, ya bum ye sə ye mok sə̀ yàvès.> ");
INSERT INTO yam_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ànə geŋ wo kə ko fis yi mʉnzuù anə, nə zə yi. Ye də ŋgà nzum nə nə gʉ bohòbʉ̀ʉ yè'sə wèŋ va? ");
INSERT INTO yam_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yi nə və kə zə bʉ̀ʉ sə̀ wo tse' nzum ye sə wèŋ, nə jəŋ fa nzum sə bohòbʉ̀ʉ mok sə̀ zok.>> Bʉ̀ʉ sə wèŋ ànə yuk wes vɛ'nə fana wo dʉk də, <<Nwìi gʉ co yumook kà vɛ'nə ye yuk.>> ");
INSERT INTO yam_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Fana Jisòs kʉk ja'a wo jwaaŋ, nə fek wo də, <<Ye də yusə̀ wo à còm nòŋsə yà' ndzənə ŋwàk Nwì yè'e də yà? Də, <Lìs nə̀ ŋgàa ci ndap wèŋ à dzèeŋ màk nòŋsə nà' də nà'a bʉp nə kə̀ tse' ghak fe'lə fàk mok sə̀' zeŋ.> ");
INSERT INTO yam_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ŋwə̀ nə̀ yi kə̀ gbʉ̀-a mʉnə lìs ànə, ŋgə̀ŋgàŋ tiiŋ sam zəzok, nə ye də a ye-a ŋga nà' gbʉ̀ ŋwə̀ nəmòk mʉni'ì fana nà' gok fam ŋgə̀ŋgàŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ŋgàa yə'rə̀ lʉ̀k bə ŋgàa fa satikà' sə̀ ghaŋ wèŋ sə lap mandzə̀ də wo ko yi ghà nà'nə bʉ̀ʉsə̀ wo à rì də nà' màk fa gbʉ' ànə bohòwo. Fana megu də wo sə wəp də bwìiŋ nə jok. ");
INSERT INTO yam_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ànə geŋ wo sə kʉk yi, nə tum fa yi mfʉəp sə̀ wo sə gʉ borə co wo bʉ̀ʉ sə̀ zìnə. Wo sə gʉ vɛ'nə də ya wo ko yi bə yumok sə̀ yi nə cep, ya wo fa yi bohòŋgàa fàak sə̀ wo tse' ŋàŋ mvwe' nze govənònə̀ fo' nə. ");
INSERT INTO yam_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wo fek yi də, <<Cicà, vès rì tse' də wù sə cèp, nə sə yə'rə fa bwìŋ yusə̀ yà'a zìnə; nə ye sə̀' də wu kà ŋwè gèm ko fagə̀, nə sə yə'rə fa bwìŋ bum sə̀ yà'a bə mandzə̀ Nwì bə zìnə. ");
INSERT INTO yam_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Vès dzəm də wu tsok-a ves, lʉ̀ʉk vesùwèŋ sə tsə̀' də, a bə̀boŋ co vès sə lak fa ŋkum Kaisà nə̀ mvwe' lak Rumà tas kè ka' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yi riŋ də yà' sə bʉə yi fana yi dʉk fa yà' də, ");
INSERT INTO yam_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","<<Wèeŋ jəŋ və fa mʉ-a mbàm mòk ɛ̀. Wo còm naaŋ mʉnə mbàm nə yè'e liŋ ndà, nə ye mbwa yè'e sə̀' si ndà?>> Wo də, <<A sə̀ ŋkum Kaisà.>> ");
INSERT INTO yam_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Fana Jisòs dʉk də, <<Ŋ̀hŋ̀. Làk fa Kaisà yusə̀ yà'a sə̀ ye, nə fa Nwì yusə̀ yà'a sə̀ Nwì.>> ");
INSERT INTO yam_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Fana wo kà yumok sə̀ co wo ko yi bə zeŋ mvwe' bwìŋ də yi cèp vɛ'ɛ tse'. Megu də wo ànə yuk mvə̀'nə̀ nà' cèp fəsə fa wo sə fana wo mərə, cù loho wo. ");
INSERT INTO yam_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bʉ̀ʉ mok sə̀ wo à sə to wo də bʉ̀ʉ Sadusì wèŋ à və̀ kə̀ tsèŋ yi. Bʉ̀ʉ yè'sə wèeŋ bʉ̀ʉ sə̀ wo dʉkgə̀ yàwo də kaco ŋwè lokok fe'lə mvwe' kpʉ yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wo à və̀, nə fek yi də, <<Cicà, Musì à còm nə̀m fa ves lʉ̀k mòk də, a ye-a ŋga tə̀tàa ŋwə̀ nəmòk kpʉ me'rə-a ŋgwe ye ŋga bə nà' ka mwe tse' fana moma yee nə jə tsoŋ ŋwà nə, ya bə nà'a dzə fa tə̀tà ye nə̀ yi kpʉ nə bwe. ");
INSERT INTO yam_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yumook yè' də bwema mok wèŋ à ye tu awo sàmba. Fana nə̀ mwè nə jəŋ ŋwàŋwè, nə kpʉ me'rə nà' ŋga bə nà' ka mwe tse'. ");
INSERT INTO yam_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ŋwə̀ nə̀ ba jəŋ ŋwà nə, nə kpʉ me'rə nà' sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ŋwə̀ nə̀ tɛ' jəŋ bwi ŋwà nə sə̀'. Yà' à mègù vɛ'nə tə̀tè wo sə̀ sàmba sə pwe' à kpʉ wes ŋga nə̀ mò'fis ka mwe bə ŋwà nə dzə. ");
INSERT INTO yam_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","À cu, ŋwà nə kpʉ ye sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ye də nùmbu nə̀ bwìiŋ nə̀ lòkok mvwe' kpʉ nə ye nùu, ŋwà ènə nə̀ ye ŋgwe ndà. Bʉsə̀ wo a jə yi wo sàmba pwe'fo'.>> ");
INSERT INTO yam_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisòs dʉk fa wo də, <<Mbəmbam bə bə̀ba sə̀ niè' cugə̀ co ŋgwe bə ndum. ");
INSERT INTO yam_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Megu də bʉ̀ʉ sə̀ wo kə̀kʉrə̀ ŋgòlòkok mvwe' kpʉ ghà ànə sə nə̀ kà gù mok cu fe'lə̀. ");
INSERT INTO yam_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bʉsə̀ wo mok co masinjàa Nwì nə ye fe'lə bwe Nwì sə̀', njo nə̀ wo a lòkok mvwe' kpʉ. ");
INSERT INTO yam_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musì nə à nìtsə̀' bə tu ye jəja də bwìiŋ nə̀ lòkok mvwe' kpʉ. Mvwe' sə̀ yi à còm bə nzak tʉ nə̀ mis à sə kʉə mbwa nà'a fana yi sə to Tà də nà'a Nwì Abràham, nə ye Nwì Azìk nə ye Nwì Jàkop. Nwì à cèp vɛ'nə ŋga wo à kpʉ lòlaŋ. ");
INSERT INTO yam_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yà'a sə nìtsə̀' də bʉ̀ʉ yè'sə cu fe'lə ŋwəm, njo nə̀ yi ka Nwì bʉ̀ kpʉkpʉ yeŋ, yi Nwì bʉ̀ʉ sə̀ wo cu ŋwəm. Bʉsə̀ bə tsətsərə̀ nə̀ Nwìi də, ndàaŋwè pwe' cu ŋwəm.>> ");
INSERT INTO yam_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ànə geŋ ŋgàa yə'rə̀ fa bwìŋ lʉ̀k mok wèŋ dʉk fa yi də, <<Cicà, yusə̀ wù cèp yà'sə bòwùriŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bʉsə̀ ŋwè à ka nə̀ co nà' fek yi yumok mok ghʉ̀sə ja'a lok fʉ̀k. ");
INSERT INTO yam_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ànə geŋ Jisòs fek wo də, <<Aco wo dʉk də ŋwə̀ nə̀ wo togə̀ yi də <Ŋkum ŋgà gèm bwìŋ> nə ye ŋgwì bʉ̀ Devìd yè'sə va? ");
INSERT INTO yam_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Bʉsə̀ Devìd nə bə tu ye à cèp bə liŋ ŋwə̀ ènə ndzənə ŋwàk Sàam dʉk də, <Tà Nwì à dʉk fa Tà àm də, <<Cum fɛɛŋ bo ma mà'a mʉ̀, ");
INSERT INTO yam_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tə̀tè mʉ nə gʉ bʉ̀ʉ sə̀ wo bɛ̀ŋgə̀ wu, wù nəŋ tes kù mʉ ni'ì wo ànə.>> > ");
INSERT INTO yam_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A ye-a də Devìd nə sə to nà' də Tà, ye də aco yi ye bwi bohòDevìd anə mwe yè'sə valɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Fana yi à cèp fa ŋgàa fàak ye wèŋ ŋga bwìŋ pwe'fo' sə yuk də, ");
INSERT INTO yam_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","<<Wèeŋ jəŋ ŋkərə̀ bə ŋgàa yə'rə̀ lʉ̀k sə̀ wo dzəm ŋgòni tse' cə̀ək sə̀ sə̀sap, nə dzəm də bwìŋ cepsə kɛ'ca wo mʉntɛɛ̀ŋ, nə dzəm mvwe' ncum sə̀ bə̀boŋ mʉmvwe' ndap pìriyà, nə dzəm də a dzèŋ mvwe' ŋkàk, wo cum megu mvwe' sə̀ ya bwìiŋ wəp wo co bʉ̀ʉ sə̀ ghaŋ. ");
INSERT INTO yam_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wo lim zə bum bàa yepmfə wèŋ, nə sə gʉ bʉpsə ndap awo, nə sə gʉ basə pìriyàa sə̀ sə̀sap ŋgwàŋ. Ŋgə' nə̀ njàwo nə kə yam gha' pwe'fo' njo bum yè'sə.>> ");
INSERT INTO yam_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisòs à cu mʉmvwe' ntòmbi ndap Nwì nə̀ ghaŋ, nə kʉk kok mvəsə̀ ŋgàa ghàk wèŋ sə gèsə tsoŋ fəfa awo sənə ŋkùp nə̀ wo gèsəgə̀ ca nə. ");
INSERT INTO yam_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yi ye ŋga ŋwà ŋgwemfə mòk nə̀ yi ŋgà jìŋ gèsə tsə mànini ba. ");
INSERT INTO yam_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Fana yi dʉk də, <<Mʉ tsok weŋ yusə̀ yà'a zìnə də ŋwà ŋgwemfə nə̀ yi ŋgà jìŋ nè'e fa càsə ghak wo pwe' yi. ");
INSERT INTO yam_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bʉsə̀ wo sə fa yàwo ŋga wo tse' ŋkʉ̀ʉŋ, fana ŋwà ŋgà jìŋ nè'e fa wes ye mʉmbàm zʉ nje nə̀ yi tse' nə pwe' nə̀ pwe'.>> ");
INSERT INTO yam_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bʉ̀ʉ mok wèŋ à sə cèp fo' mvə̀'nə̀ də ndap Nwì nə̀ ghaŋ nə bòvɛ'ɛ bə lìis sə̀ wo à ci nà' fo', nə ye bə bum sə̀ wo à fa Nwì ŋgògʉ̀ bòŋsə ndap ye nə fo'. Jisòs dʉk fa wo ye də, ");
INSERT INTO yam_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","<<Bum sə̀ wèŋ sə yə yà' yè'e pwe', nùmbu mòk sə və̀ə nə̀ lìs nə̀ mò'fis nə kà mʉnə mòk fa'nə naaŋ mam. Wo nə kʉəmsə wes yà' pwe'.>> ");
INSERT INTO yam_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Fana wo fek yi də, <<Cicà, tsok fa a ves ghà nə̀ bum yè'sə nə ye-ɛ̀, nə ye sə̀' də yusə̀ yà'a nə niŋtsok də bum yè'sə kʉəp laŋ sə yè'sə yà?>> ");
INSERT INTO yam_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisòs dʉk fa wo də, <<Wèeŋ jəŋ ŋkərə̀ ya ŋwə̀ nəmòok kà weŋ bòrə̀, bʉ̀ʉsə̀ bwìiŋ nə və ŋkʉ̀ʉŋ sə̀ wo nə sə ci' mvwès də, <Mʉ yi nə̀ Nwì à dʉk də yi nə tum nə, mvə̀k nə kʉəp laŋ.> Wèŋ kà wo bɛ' lòswì. ");
INSERT INTO yam_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nə ye də wèeŋ yuk nzak dzè' nə ye bə mvə̀'nə̀ bwìŋ sə kʉ̀əm kɛ' fana wèŋ kà wəp, bʉ̀ʉsə̀ bum yè'sə nə ye to tsoŋ ntòvɛ'nə ŋkuŋ. Bum yè'sə ye-a sə̀' vɛ'nə fana mvə̀'nə̀ bum nə lə nə, nə kà sə̀ ntòkə̀ dzèŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ànə geŋ yi sə tsoho fa mali wo də, <<Bòp lak mook nə lʉ bə bòp lak mok, ŋkum mok lʉ bə ŋkum mok sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nze nə nə sə tsoho vɛ'ɛ wùriŋ fana njè bə ŋgə' ye kɛ' lo mvwe' bòop lak mok zok zok nduk. Fana bum sə̀ co yà' koksə ŋwè wʉə bə bum mok sə̀ yà' sə nìtsə̀' mvə̀k nə̀ də nzeŋgòoŋ nə me wèeŋ nə sə yəəŋ mʉbu wùriŋ. ");
INSERT INTO yam_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ŋkuŋ bum yè'sə nə sə ye fana wo nə ko to ntòwèŋ ŋkuŋ. Wo nə ko weŋ, nə yeŋsə weŋ ŋgə', nə jəŋ lo weŋ mʉmvwe' ndap pìriyà ŋgòsak weŋ, nə jəŋ lo weŋ mʉmvwe' ndapndzəm wèŋ sə̀'. Wo nə kə jəŋ lo weŋ bohòŋkum bə govənòwèŋ pwe'fo' bʉ̀ʉ liŋ am. ");
INSERT INTO yam_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nà'nə nə ye yà'sə sə̀' mandzə̀ bohòwèŋ ŋgòtəəŋ, nə tsoho fa bwìŋ ncèp nə̀ njàm. ");
INSERT INTO yam_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wèeŋ riŋtse' yè'e sə ntʉʉ̀ wèŋ də ŋwèe kà də yi sə tsərə də wu nə sə cep fəsə fa wo yè'sə də yà dʉk. ");
INSERT INTO yam_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bʉsə̀ mʉ nə fa weŋ cù bə ŋkərə̀ nsàp nə̀ wù cèp fana cù loho bʉ̀ʉ sə̀ wo sə bɛ̀ŋ weŋ sə, wo kà yusə̀ ŋgòcèp fe'lə mok rì. ");
INSERT INTO yam_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Anə sə seŋ weŋ bʉ̀ʉ awèŋ co bʉ̀ʉ sə̀ wo dzə wu wo, bə moma yo, nə ye bwe tɛ̀' yo bə ŋge' yo wèŋ. Mook sə̀ wo nə zə weŋ zəə. ");
INSERT INTO yam_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bwìŋ pwe' nə bɛŋ weŋ njo liŋ am sə. ");
INSERT INTO yam_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Megu də, nʉ̀ə̀mtu àwèŋ nə̀ mò'fis nə kà bisə̀. ");
INSERT INTO yam_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wèeŋ təəŋ-a gʉgʉŋ, yà'a mvə̀'nə̀ wèeŋ nə tɛsə yòŋsə̀ə awèŋ sə. ");
INSERT INTO yam_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","<<Ghà nə̀ wèeŋ yə ŋga sojà wèŋ kə̀ gʉm lak Jòrosalèm fana wèŋ riŋ də wo nə kʉəmsə mak yà' mvə̀k momjo. ");
INSERT INTO yam_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Fana bʉ̀ʉ sə̀ wo cu mvwe' lak Jùdiyà wèeŋ caŋ kok lo mʉndahà, bʉ̀ʉ sə̀ wo cu mʉntòlak wèeŋ tesə lo, bʉ̀ʉ sə̀ wo ka mʉntòlak anə yeŋ wèeŋ kà də wo mumsə ŋgòni foho lòmbwa dʉk. ");
INSERT INTO yam_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bʉsə̀ a yà'sə nùumbu là' fəsə fò, ya bum sə̀ wo à còm yà' ndzənə ŋwàk Nwì lòoŋ fo' bʉʉŋ və zìnə. ");
INSERT INTO yam_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ho'm̀, megu də anə ye ŋgə' wùriŋ bohòbàa sə̀ bə zʉm, nə ye sə̀ wo sə fa bwe sə̀ lə mbwi bə nùumbu yà'sə. Ŋgə' nə̀ co wù kà cèep nə ye sə nzeŋgòŋ anə ŋga Nwì jòk bohòbʉ̀ʉ yè'sə wèŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wo nə gbɛ' zə mok wèŋ bə fèk, nə jəŋ lo mok co ŋkwɛ̀ŋ mvwe' bòop lak lòoŋ. Fana bʉ̀ lakmvum wèeŋ nə nəŋrə lak Jòrosalèm bə kù tə̀tè mvə̀k nə̀ Nwì a fa wo kə wɛs. ");
INSERT INTO yam_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","<<Bum mok sə̀ yà' sə nìtsə̀' mvə̀ək nə yəəŋ mʉ nùmə bə ŋwʉ nə ye mʉnə ŋkə̀ŋkàŋ sə̀'. Ma nə̀ sə nze fana bòop lak wèeŋ nə jip, nə wəp mvə̀'nə̀ ndzəp nə̀ ghaŋ cwì, nə sə kɛ'lə li gbʉ. ");
INSERT INTO yam_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bwìiŋ nə sə kpʉ sɛɛŋ bə wʉə mvə̀'nə̀ wo sə tək ŋgòyə yusə̀ yà'a nə ye sə nzeŋgòŋ anə sə, bʉ̀ʉsə̀ ŋàaŋ sə̀ ma mʉbu sə pwe'fo' nə tsoho. ");
INSERT INTO yam_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Fana wo nə ye mʉ̀ʉ mo ŋwè, mvəsə̀ mʉ̀ sə və̀ ndzənə mbàk bə ŋàŋ, nə sə fom rɛŋ boŋsə nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bum yè'sə yè ŋgòkə̀ ye vɛ'nə, fana wèŋ fis kok tu awèŋ mʉtsə̀, nə sə kʉk, bʉ̀ʉsə̀ mvə̀k nə̀ Nwìi nə fiŋ me'rə weŋ mvwe' ŋgə' nə kʉəp yà'sə laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ànə geŋ Jisòs tsok fa wo ncèp nè'e bə gbʉ' də, <<Wèeŋ kʉk ja'a yàwèeŋ tʉ nə̀ wo togə̀ nà' də fik nà'a, nə ye tʉ mok wèŋ lòoŋ-ɛ̀. ");
INSERT INTO yam_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ghà nə̀ wèeŋ yə ŋga yà' yè ŋgòtse' mvù fana wèŋ riŋ də mbʉ̀ŋ kʉəp laŋ. ");
INSERT INTO yam_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yà' mègù sə̀' vɛ'nə də ghà nə̀ wèeŋ yə bum yè'sə ŋga yà' sə ye vɛ'nə fana wèŋ riŋ də gaŋ ŋkum Nwì sə yà' kʉəp və̀ laŋ. ");
INSERT INTO yam_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","<<Mʉ̀ sə tsə̀' weŋ yè'e ŋkèm ncèp də ŋgwì bʉ̀ nə̀ niè' nè'e nə kà kə̀ lə̀ wes ŋga bum yè'sə yà' fà' laŋ. ");
INSERT INTO yam_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ntòbu bə nzeŋgòoŋ nə̀ cà gɛsə lòfo', ncèp nə̀ njàm kà ye cà yuk. ");
INSERT INTO yam_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","<<Wèeŋ sə jəŋ ŋkərə̀ bə tu awèŋ. Kà də wèeŋ me'rə fa ni' awèŋ bohòdinà bə jʉ̀hʉ̀ rùk nə ye bum sə̀ sə nze sə dʉk, bwɛ̀rɛ nùmbu ànə nə kə tseŋ weŋ vak ŋga wèŋ ka riŋ. ");
INSERT INTO yam_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nùmbu ànə nə kə tseŋ ŋwè vak co tam ko wu yi. Bʉsə̀ nùmbu ànə nə və bohònzeŋgòŋ nə lòoŋ fo'. ");
INSERT INTO yam_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wèeŋ sə so bə ghà nə̀ fòpwe'fo', nə sə gʉ pìriyà də wèeŋ tse' ŋàŋ ŋgòca swìrə to bum sə̀ yà'a nə̀ kə̀ ye yè'sə, nə kə təəŋ to mantombìi Mo Ŋwè nə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jisòs à sə yə'rə bwìŋ mʉmvwe' ndap Nwì nə̀ ghaŋ nə nùumbu pwe' fana ndzəm seŋ, yi kok lo kə nooŋ mʉmvwe' nda Olìp nə. ");
INSERT INTO yam_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tsok à sə rɛŋ fana bwìŋ pwe' sə kə tseeŋ yi mʉmvwe' ndap Nwì nə̀ ghaŋ nə ŋgòsə yu'rə yusə̀ yi sə tsòho sə. ");
INSERT INTO yam_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ŋkàha Pasobà, sə̀ wo zʉgə̀ fo' brɛd sə̀ jì yis yà'a ànə kʉəp və ŋga'a mok laŋ. ");
INSERT INTO yam_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Fana ŋgàa fa satikà' sə̀ ghaŋ bə ŋgàa yə'rə̀ fa bwìŋ lʉ̀k wèŋ sə lap mandzə̀ mok ŋgòzə swìhi Jisòs bʉ̀ʉsə̀ wo ànə sə wəp bwìŋ də yà'a nə jok. ");
INSERT INTO yam_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ànə geŋ Satà ni sə ntʉʉ̀ Judàs nə̀ liŋ ye mook də Iskarəyà. Judàs nə à ye sə̀' mòk mʉŋgorə̀ ŋgàa fàak Jisòs sə̀ wo à ye hum-ncòp-ba sə. ");
INSERT INTO yam_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judàs nə à lò, nə kə cep bə ŋgàa fa satikà' sə̀ ghaŋ nə ye bʉ̀ʉ sə̀ mantombì bohòŋgàa tək mʉmvwe' ndap Nwì sə wèŋ mvə̀'nə̀ yi nə seŋ fa wo nà'. ");
INSERT INTO yam_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wo à kwa, nə dʉk də wo fa yi mbàm. ");
INSERT INTO yam_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judàs nə à dzəm, fana nə sə lap mok mandzə̀ nə̀ co yi seŋ Jisòs ŋga bwìŋ ka fo' yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nùmbu nə̀ wo à yèto ŋkàk nə̀ wo zʉgə̀ brɛd sə̀ jì yis nə à dzèeŋ, à ye sə̀' nùmbu nə̀ wo sʉəgə̀ nsùŋgaaŋ ŋkàha Pasobà ŋgòfa Nwì sə. ");
INSERT INTO yam_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ànə geŋ Jisòs tumsə lo Pità bə Jon ŋga yi tipsə wo də, <<Wèeŋ du kə fʉhʉ fa ves ŋkàha Pasobà sə ya vesùwèeŋ kə zʉ yà'.>> ");
INSERT INTO yam_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wo fek yi də, <<Wù dzəm də vèes kə fʉhʉ yè'sə ma fòlɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yi dʉk fa wo də, <<Wèeŋ yu'rə bə̀boŋ. Wèeŋ kə̀ ni lòmʉntòlak anə fana wèŋ ŋwə̀mbam mòok nə kʉrə ŋga yi bə̀k tse' kʉ̀ʉŋ ndzəp; wèŋ bɛ' lo yi mvwe' ndap nə̀ yi nə kə ni fo' nə. ");
INSERT INTO yam_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","A kə̀ dzèŋ fo' fana wèŋ tsok fa ŋgà ndap nə də, <Cicà nə də vèes kə fek wu də rum ndap nə̀ bə bwe ye wèeŋ nə zʉ ŋkàha pasobà mbwa nə fòlɛ?> ");
INSERT INTO yam_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yi nə niŋ fa weŋ rum ndap mòk nə̀ ghaŋ ma mʉtùhù, nə̀ bum pwe' mbwa, fana wèŋ gʉhʉ tsə'rə bum pwe'fo'.>> ");
INSERT INTO yam_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ànə geŋ wo lo, nə kə ye bum sə pwe' mvə̀'nə̀ Jisòs ànə dʉk sə. Wo fʉhʉ zʉzʉ Pasobà sə̀ fo'. ");
INSERT INTO yam_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mvə̀k nə à kʉ̀rə fana Jisòs cum mvwe' ye mʉ teberə̀ ŋgòzʉ bɛŋ bə ŋgàa fàak ye sə̀ wo ŋgàa ntum ye sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yi dʉk fa wo də, <<Mʉ̀ anə dzəm vɛ'ɛ wùriŋ də vesùwèeŋ zʉ be'lə tsoŋ zʉzʉ ŋkàha pasobà yè'sə bəbɛ' ŋkuŋ ya mʉ ye ŋgə'. ");
INSERT INTO yam_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bʉsə̀ mʉ tsok weŋ də mʉ nə kà yà' mok zʉ fe'lə tə̀tè tse'ŋga yusə̀ zʉzʉʉ yè'sə tə bə tu zeŋ sə kə̀ rɛɛŋ nùmbu nə mvwe' gaŋ ŋkum sə̀ Nwì sə ŋkuŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ànə geŋ yi jəŋ ŋgàp, nə kwasə Nwì, fana yi dʉk fa wo də, <<Wèeŋ ko jəŋ, nə gapsə mʉtsətsə'rəə wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bʉsə̀ mʉ tsok weŋ də, ye jəŋ nə̀ ŋga'a nè'e mʉ nə kà rùuk yè'sə mok no fe'lə̀ tə̀tè gaŋ Nwì sə kə wɛs.>> ");
INSERT INTO yam_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Fana yi jəŋ fe'lə brɛd; yi ànə kwasə wes Nwì sə̀mok fana yi fa yà'wèŋ, nə dʉk də, <<Nè'e ŋgùpni' àm nə̀ wo a fa nà' bʉ̀ʉ wèŋ. Wèeŋ sə gʉhʉ vɛ'nə ŋgòsə tsərə tse' mʉ.>> ");
INSERT INTO yam_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yi ànə gʉ megu sə̀' mʉmvə̀' ànə bə ŋgàp nə. Ghà nə̀ wo à zʉ wes zʉzʉ sə fana yi fa wo ŋgàp nə, nə sə cep də, <<Ŋgàp nè'e rʉ̀k nə̀ fi nə̀ nà' kì ŋge' ndzənə ndʉəm am, nə̀ nà'a nə fe'e bʉ̀ʉ wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Megu də wèeŋ kʉk ja'a yàwèeŋ, ŋwə̀ nə̀ yi sèŋ mʉ nə cu be'lə venəwèŋ yè' mʉ teberə̀ anə. ");
INSERT INTO yam_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mʉ̀ʉ Mo Ŋwè, mʉ nə kpʉ lo mvə̀'nə̀ wo ànə dʉk noŋsə sə, megu də ŋwə̀ nə̀ yi sèŋ mʉ nə cu bə ŋgə'.>> ");
INSERT INTO yam_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Fana wo ye ŋgòfe'rə ya' mʉŋgorə̀ wo də ŋwə̀ nə̀ yi nə seŋ nà' nə yè'sə ndàlɛ? ");
INSERT INTO yam_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mʉncèp mòk à tesə mʉŋgorə̀ wo anə sə̀' də ŋwə̀ nə̀ nà' yam càsə mok sə pwe'fo' ndàlɛ? ");
INSERT INTO yam_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Fana Jisòs dʉk fa wo də, <<Ŋkum sə̀ sə nzeŋgòŋ fɛŋ gʉ̀ fagə̀ bʉ̀ʉ awo sə co də wo yàwo bʉ̀ʉ sə̀ ghaŋ. Wo sə dzəm də bwìiŋ sə to wo də ŋgàa fa bwìŋ mbo. ");
INSERT INTO yam_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yà'a kà bohòwèŋ yàwèŋ vɛ'nə ye. Yusə lɛ də ŋwə̀ nə̀ yi ŋwə̀ nə̀ ghaŋ nə ye co mo nə̀ lʉə, fana ŋwə̀ nə̀ yi mantombì yi nə ye co ŋgà fàk bohòmok sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yèè, ŋwə̀ nə̀ ghaŋ yè'sə nə̀ fò, ŋwə̀ nə̀ yi cu ye mʉ teberə̀ kè ŋwə̀ nə̀ yi sə fàk ŋgòcàsə və̀ zʉzʉ mʉ teberə̀ anə-ɛ? A lɛ ŋwə̀ nə̀ yi cu mʉ teberə̀ nə. Fana mʉ yàm bohòwèŋ co ŋwə̀ nə̀ yi sə càsə zʉzʉʉ sə càsə nə. ");
INSERT INTO yam_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","<<Nùumbu sə̀ mʉ̀ a sə tse' ŋgə' sə pwe', wèŋ sə dzəm ŋgòcu malì vesùwèŋ. ");
INSERT INTO yam_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Fana mʉ̀ sə koksə weŋ gaŋ sə̀' mvə̀'nə̀ tɛ̀' am ànə koksə mʉ. ");
INSERT INTO yam_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Wèeŋ nə zʉ mʉ teberə̀ mʉ̀ mvwe' gaŋ am sə. Wèeŋ nə cum mʉmvwe' kapràk, nə sə sak bòop lak Izùrɛ sə̀ yà'a hum-ncòp-ba sə.>> ");
INSERT INTO yam_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Fana Jisòs dʉk fa Pità də <<Saimʉ̀, Saimʉ̀ yu'rə! Satà lɛŋ də yi dzəm ŋgòjə weŋ, nə swek weŋ co wo sə swek gòmbì. ");
INSERT INTO yam_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Megu də mʉ̀ lɛŋ fa wu pìriyà laŋ də ntʉm nə̀ wù tse' ŋgòdzəm tse' bohòmʉ̀ nà'a kà maŋkwɛ̀ŋ bwì foho lò. Nə ye sə̀' də wu bwì və̀ bohòmʉ̀ fana wù gʉ ya bwema yo ye yàwo gʉgʉŋ sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pità nə dʉk fa yi də, <<Tà, a dzəm ye mvwe' ndapndzəm bə mvwe' kpʉ pwe', mʉ nə lo yàm vesù.>> ");
INSERT INTO yam_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yi dʉk fa nà' də, <<Pità, mʉ tsok wu ŋkèm dʉk də, ŋkuŋ mvəp to ntinə ŋga wù dʉk fis kɛ̀' tɛ' laŋ də wù ka mʉ riŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ànə geŋ Jisòs fek wo də, <<Mvə̀'nə̀ mʉ̀ ànə tumsə lo weŋ fa', nə dʉk də wèeŋ nə kà posà mbàm jə, kà bàm jə, nə kà kùuŋgùp sə̀' jə tse' lòyà'a, wèŋ ànə lo, nə kə jamə yumok à?>> Wo à dʉk də, <<Vès à ka yumok jamə.>> ");
INSERT INTO yam_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Fana Jisòs nə dʉk fa wo mok də, <<Ŋwə̀ nə̀ yi tse'-a pùp ye kè bàm àlɛ, yi jəŋ tse' nà' ŋga'a. Ŋwə̀ nə̀ yi ka-a kafà' tse', ŋgə̀ŋgàŋ seŋ cə̀k ye, nə ywiŋ tse' mòk bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mʉ tsok fa weŋ də yusə̀ wo à còm yà' ndzənə ŋwàk Nwì bə liŋ am də, <Wo à ta be'lə yi bə ŋgàa gʉ̀ bʉp wèŋ> yà'a nə bʉʉŋ və tsoŋ zìnə. Njo nə̀ bum sə̀ wo à còm yà' bə liŋ am sə, sə bʉʉŋ və̀ zìnə pwe'fo'.>> ");
INSERT INTO yam_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wo dʉk fa yi də, <<Tà, vès tse' fèk ba.>> Yi dʉk fəsə fa yà' də, <<Yà'sə kə̀kʉrə̀.>> ");
INSERT INTO yam_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ànə geŋ yi lokok ŋgòlòmvwe' nda Olìp sə̀ mvə̀'nə̀ yi lòhogə̀ səsa sə fana bwe ye sə wèŋ sə bɛ' lòyi sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","À kə̀ dzèŋ fo' fana yi tsok yà' də yà'wèeŋ lɛŋ Nwì də ya mə̀mumsə̀ə kà yà' gha'. ");
INSERT INTO yam_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Fana yi sooŋ gɛsə lo ŋgʉ ni'ì yà'wèŋ anə fo' co wù mak lìs kə dzeŋ, nə təəŋ bə tumfərə sə lɛŋ pìriyà. ");
INSERT INTO yam_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Yi lɛŋ dʉk də, <<Tɛ̀', a ye-a ŋga bò-a wu fana wù jəŋ gɛsə lo ŋgàp ŋgə' ènə fo'; mʉ̀ dʉk-a sə̀' vɛ'nə, wù gʉ lɛ mʉmvə̀'nə̀ wù dzəm wù, kà mʉmvə̀'nə̀ mʉ̀ dzəm mʉ̀ gʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ànə geŋ masinjà Nwì mòk tesə və mʉbu, nə kə fa yi ŋàŋ. ");
INSERT INTO yam_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ànə ye ŋga ntʉm sə bʉp yi vɛ'ɛ nsàp nə̀ yi à lɛŋ vɛ'ɛ tə̀tè ndùrə̀ sə cərə yi co sə cərə tsə ndʉəm. ");
INSERT INTO yam_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ànə geŋ yi lokok, nə kə tseŋ bwe ye sə wèŋ ŋga wo wòbə manziŋ wùriŋ, fana nə sə dzəm mok lo. ");
INSERT INTO yam_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yi fek yà'wèŋ də, <<Wèŋ sə dzəm lo yà? Wèeŋ lokok, nə lɛŋ də ya mə̀mumsə̀ə kà weŋ gha'.>> ");
INSERT INTO yam_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisòs ànə sə cep mali ntòfo' fana ma ŋgo bʉ̀ mok tesə və, ŋga Judàs nə̀ yi sə̀' mòk mʉŋgorə̀ bwe ye sə̀ hum-ncòp-ba nə to mantombì yi. Judàs nə lo kə cepsə Jisòs nə co ŋge' vɛ'. ");
INSERT INTO yam_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jisòs fek nà' də, <<Judàs, wù də wu seŋ mʉ̀ʉ mo ŋwè bə cə̀cèpsə̀ à?>> ");
INSERT INTO yam_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bwe Jisòs sə̀ wo ànə ye fo' sə à yə mvə̀'nə̀ bum sə à ye fana wo fek Jisòs də, <<Tà, aco vès gbɛ' bə fèk à?>> ");
INSERT INTO yam_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mòk mʉŋgorə̀ wo anə à gbɛ' cì' màk ntu'u mo ŋgà fàk ŋkum ŋgà fa satikà' mòk. Yi à gbɛ' cì' ntu'u nà' sə̀ bo ma zʉ. ");
INSERT INTO yam_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Fana Jisòs dʉk də, <<Yà' kʉ̀rə vɛ'nə,>> nə jwɛŋ gesə ntu'u sə, fana yà' me. ");
INSERT INTO yam_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ànə geŋ Jisòs cep bohòŋgàa fa satikà' sə̀ ghaŋ sə bə ŋgàa fàak sə̀ wo kʉ̀kgə̀ ndap Nwì nə̀ ghaŋ nə, nə ye bə ŋkwàha bʉ̀ʉ sə̀ wo à tesə və̀ ŋgòko yi sə wèŋ də, <<Wèŋ tesə co wèŋ sə lòmvwe' bɛ' ŋgà yə̀ bə fèk nə ye ntòk yè'e bʉ̀ʉ mʉ̀ à? ");
INSERT INTO yam_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Vesùwèeŋ yiskokgə̀ mʉmvwe' ndap Nwì nə̀ ghaŋ səsa, wèŋ kà mʉ ko. Nə ye də nè'e mok ŋga'a mvə̀k nə̀ njàwèŋ, nə̀ ŋàaŋ ndzəm tse' ŋàŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ànə geŋ wo ko yi, nə jəŋ lo yi mvwe' ndap ŋkum ŋgà fa satikà'. Pità sə yuŋ və wo maŋkwɛ̀ŋ mweè sə̀sap. ");
INSERT INTO yam_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wo à kə̀ fimsə mis mʉ ntòmbi anə, nə cum sə yuk fana Pità nə və kə cum kok ye fo' sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mvə̀'nə̀ mis à sə kʉə rɛɛŋ fana mʉŋwà nəmòk ye yi, nə kʉk kok nà' jwaaŋ, nə dʉk də, <<Ŋwə̀ nè'e yegə̀ sə̀' bə ŋgà' ànə.>> ");
INSERT INTO yam_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Fana Pità nə bɛŋ də, <<Njɛ̀'gù, mʉ̀ ka yi riŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","À cu kok ghàr ŋgà' nəmòk ye yi sə̀', nə dʉk sə̀' də, <<Wu sə̀' ŋwə̀ àwo mòk.>> Pità nə bɛŋ sə̀mok də, <<Hai' mʉ̀ ka mòk yeŋ ŋgàta.>> ");
INSERT INTO yam_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","À sàp kok mok bə̀boŋ ntɛ̀ŋ fana ŋwə̀ nəmòk dʉk fe'lə sə̀mok dʉk də, <<Mʉ̀ rì ŋwə̀ nè'e bə̀boŋ, yi ŋwə̀ə Galìli, yi yegə̀ bə nà'.>> ");
INSERT INTO yam_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pità nə dʉk fe'lə sə̀mok də, <<Ŋgàta, mʉ̀ ka yusə̀ wù sə cèp yà'sə riŋ.>> À ye sə̀' ghà ànə, ŋga yi ka ntòcep wes ntɛ̀ŋ, ntomvəp to. ");
INSERT INTO yam_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Fana Tà Jisòs bʉʉŋ kʉk gesə lo Pità. Pità tsəm kok mvə̀'nə̀ Tà anə dʉk fa yi də, <<Ntomvəp nə sə kə to ntinə ŋga wù bɛ̀ŋ mʉ kɛ̀' tɛ' də wù ka mʉ riŋ sə.>> ");
INSERT INTO yam_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yi tesə lo sə ntòmbiŋ, nə kə waŋ vɛ'ɛ nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ànə ye vɛ'nə fana bʉ̀ʉ sə̀ wo à sə kotse' Jisòs sə wèŋ à sə ywì'lə yi, nə sə ləp yi sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wo lok yi lis, nə sə fek yi də, <<Lə̀p wu ndà, riŋ-a ŋgə̀ŋgàŋ-ɛ̀?>> ");
INSERT INTO yam_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wo à cèp fa yi bum ŋkʉ̀ʉŋntɛ̀ŋ, nə sə yak yi. ");
INSERT INTO yam_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nə̀ zəzòŋ à dzèeŋ fana bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ kə benə ni' mvwe' mò'fis bə ŋgàa fa satikà' sə̀ ghaŋ bə ŋgàa yə'rə̀ bwìŋ lʉ̀k wèŋ pwe'. Fana wo jəŋ lo yi mʉ kaŋsurù wo anə, nə sə cep də, ");
INSERT INTO yam_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","<<A ye-a ŋga wu Ŋkum ŋgà gèm bwìŋ nə wù, wù tsok fa ves.>> Yi dʉk fa yà'wèŋ dʉk də, <<A ye-a ŋga mʉ̀ tsə̀' fa weŋ, kaco wèŋ dzəm yeŋ; ");
INSERT INTO yam_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","nə ye sə̀' də a ye-a ŋga mʉ̀ fek weŋ yumok, kaco wèŋ cep fəsə fa mʉ sə̀ yeŋ. ");
INSERT INTO yam_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Megu də ye jəŋ ŋga'a nə lo mantombì fana mʉ̀ʉ mo ŋwè, mʉ nə cum bo ma mà'a Nwì nə̀ yi tse' ŋàŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Fana wo pwe'fo' fek yi də, <<Ye də wu mo Nwì à?>> Yi dʉk fa yà' də, <<Wèŋ cèp mè laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Fana wo dʉk ŋga'a də, <<A sə làp də a yuk fe'lə yè'sə yà? Vesùwèŋ yuk ncèp jòŋ nə kə̀ cùhu yi bə ntu'u avès laŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ànə geŋ ma ŋgo bʉ̀ nə pwe'fo' lokok, nə jəŋ lo yi mantombìi Palè. ");
INSERT INTO yam_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wo yeto ŋgòto fa yi njo də, <<Vès ko ŋwə̀ nè'e ŋga yi sə jipsə bʉ̀ avès, nə sə dʉk də bwìiŋ kà tas bohòKaisà làk, nə dʉk də yi Ŋkum nə̀ yi ŋgà gèm bwìŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Fana Palè nə fek nà' də, <<Wu ŋkum bʉ̀ʉ Jus wèŋ wù à?>> Jisòs nə cep fəsə fa nà' də, <<Wù dʉk yà'a mvə̀'nə.>> ");
INSERT INTO yam_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Palè bʉʉŋ dʉk fa ŋgàa fa satikà'a sə̀ ghaŋ sə bə bʉ̀ʉ sə̀ fo' sə pwe'fo' də, <<Mʉ̀ ka yàm yusə̀ bʉp sə̀ ŋwə̀ ènə gʉ̀ʉ sə ye.>> ");
INSERT INTO yam_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bʉ̀ʉ sə wèŋ gʉŋ təəŋ mpaaŋ dʉk də, <<Yi sə kʉ̀ə̀msə bwìŋ mvwe' nzeŋgòŋ Jùdiyà nə pwe'fo' bə nsàp mandzə̀ nə̀ yi sə yə'rə wo nə. Yi a yè jə Galìli, nə kə wɛs Jòrosalèm fɛŋ pwe'.>> ");
INSERT INTO yam_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Palè ànə yuk bum yè'sə fana yi fek də, <<Ŋwə̀ ènə yi ŋwə̀ə Galìli àlɛ?>> ");
INSERT INTO yam_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yi ànə rɛɛŋ də Jisòs tesə və̀ mvwe' nze nə̀ tse' fo' ŋkum Heròfana yi tumsə lo nà' bohòHeròanə. Ghà ànə à ye ŋga Herònə cu sə̀' mvwe' lak Jòrosalèm anə. ");
INSERT INTO yam_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heròà yə Jisòs fana yi kwa vɛ'ɛ wùriŋ, bʉ̀ʉsə̀ yà' à sàap mʉmvə̀'nə̀ yi à yuk liŋ nà', nə sə dzəm də yi ye nà'. Yi ànə sə tsəm də Jisòos nə gʉ niŋ fa yi maŋgəŋgèŋ mòk. ");
INSERT INTO yam_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herònə à fek Jisòs bum mok ŋkʉ̀ʉŋntɛ̀ŋ, Jisòs nə kà cù mùk lok. ");
INSERT INTO yam_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ŋgàa fa satikà'a sə̀ ghaŋ bə ŋgàa yə'rə̀ bwìŋ lʉ̀k wèŋ gʉŋ təəŋ megu fo' ŋgòto fa yi njo. ");
INSERT INTO yam_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heròbə sojàa ye wèŋ à bʉ̀sə yi co ləm awo, nə sə ywi'lə yi. Fana wo à nisə fa yi cə̀k mòk nə̀ co cə̀k ŋkum vɛ'ɛ, nə tum fəsə lo yi bohòPalè. ");
INSERT INTO yam_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Heròbə Palè à yè ko jə ŋge' nùmbu ànə; ŋga bə nà' à sə kà ŋge' mantombì yegə̀. ");
INSERT INTO yam_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ànə geŋ Palè nə to benə ŋgàa fa satikà' sə̀ ghaŋ bə njì njìi sə̀ fo', nə ye bə bʉ̀ʉ sə̀ fo' sə wèŋ pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Yi dʉk fa yà'wèŋ də, <<Wèŋ a jə və̀ fa mʉ ŋwə̀ nè'e dʉk də yi sə jə lòwes bwìŋ ma nə̀ bə jòŋ. Mʉmvə̀'nə̀ mʉ̀ kʉ̀k ja'a yi yàm, ŋga wèŋ sə yə sə̀' fana mʉ̀ ka yàm də yi a gʉ̀ bum sə̀ wèŋ sə dʉk yà'sə riŋ. ");
INSERT INTO yam_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heròa ka yumok bʉp bohònà' sə̀' ye bʉ̀ʉsə̀ yi a tumsə fəsə vèsə nà' bohòvès sə̀mok. Yà' nòjəja də ŋwə̀ ènə ka yumok sə̀ bʉp sə̀ co wo zə yi bʉ̀ʉ zeŋ gʉ. ");
INSERT INTO yam_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mʉ nə fa ŋàŋ də wo ləp yi, fana nə me'rə yi.>> ( ");
INSERT INTO yam_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yi sə dʉk vɛ'nə ŋga à ye də nùmbu ŋkàha pasobà sə kə̀ dzèŋgə̀ə fana Palè nə fis me'rə tsoŋ fa wo ŋgà ndapndzəm mò'fis.) ");
INSERT INTO yam_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bʉ̀ʉ sə wèŋ kɛ' tosə ŋgùŋ cù mò'fis də, <<Wèeŋ zə gɛsə lo ŋwə̀ ènə fo', nə fis me'rə fa ves lɛ Bàrabà.>> ");
INSERT INTO yam_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Bàrabà nə à ye ŋwə̀ nəmòk nə̀ wo à nisə yi ndapndzəm bʉ̀ʉsə̀ yi à lʉ̀lʉ̀ bə bʉ̀ʉ gomè nə zə bwìŋ.) ");
INSERT INTO yam_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Palè à cèp bohòwo sə̀mok ŋga yi sə làp mandzə̀ co yi me'rə Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bʉ̀ʉ sə wèŋ sə kɛ'ŋgùŋ də, <<Wèeŋ tɛ'lə yi, wèeŋ tɛ'lə yi mʉntə̀əŋ!>> ");
INSERT INTO yam_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yi fek fis yà'wèŋ nə̀ kɛ̀' tɛ' dʉk də, <<Bʉ̀ʉ yà? Ŋwə̀ ènə gʉ̀ bʉpsə yà? Mʉ̀ ka yàm yumok sə̀ co wo zə yi bʉ̀ʉ zeŋ ye. Mʉ nə ləp yi, nə me'rə yi lo.>> ");
INSERT INTO yam_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bʉ̀ʉ sə wèŋ gʉŋ təəŋ vɛ'ɛ mpaaŋ nə̀ mpaaŋ nə sə kɛ'ŋgùŋ də wo tɛ'lə megu nà' mʉntə̀əŋ. Wo à gʉ̀ vɛ'nə tə̀tè ma nə̀ njàwo nə zʉ. ");
INSERT INTO yam_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ànə geŋ Palè nə cep, nə fa ŋàŋ bə yusə̀ bʉ̀ʉ sə wèŋ à sə dzəm sə. ");
INSERT INTO yam_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yi fis me'rə ŋwə̀ nə̀ wo à nisə yi ndapndzəm njo ndàŋ, nə ye bʉ̀ʉsə̀ yi ànə zə ŋwè nə. Nà'a ŋwə̀ nə̀ wo ànə sə dzəm də nà'a fis me'rə nə, fana nə jəŋ Jisòs, nə fa yà'wèŋ də yà'a gʉ bohònà' mvə̀'nə̀ yà'wèŋ dzəm. ");
INSERT INTO yam_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mʉmvə̀'nə̀ wo à sə jə lòJisòs fana wo kʉrə bə ŋwə̀ nəmòk nə̀ wo to yi də Saimʉ̀, nə̀ mvwe' lak Sìrinì ŋga yi à sə və̀ la'à yi. Wo naaŋ fa yi ntə̀əŋ sə də nà'a bək bɛ' Jisòs bə zeŋ maŋkwɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bwìŋ à sə bɛ' və̀ yi maŋkwɛ̀ŋ anə wùriŋ. Bə̀ba mok à ye fo' sə̀', sə̀ wo à sə koksə manziŋ, nə sə waŋ fa Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ànə geŋ Jisòs nə bʉʉŋ kʉk wo, nə dʉk də, <<Wèŋ njɛ̀'ɛ gùu Jòrosalèm, wèeŋ kà mʉ wa fa, wèeŋ waŋ fa tu awèŋ bə tu bwe awèŋ. ");
INSERT INTO yam_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bʉsə̀ mʉ tsok weŋ də mvə̀k mòk sə və̀ nə̀ wo nə dʉk də, <Rɛŋsi bohòbàa sə̀ wo nzeŋ, nə ye və̀əm sə̀ yà' ka mwe dzə yuk, nə ye fe'lə mbwi sə̀ mwe ka yà' no yuk!> ");
INSERT INTO yam_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nà'a ghà nə̀ bwìiŋ nə dʉk fa nda də, <Kəəŋ gbʉ̀ və̀ mʉ ni'ì vès,> nə dʉk fa nzès də <Kə̀ kəəŋ tsə̀ lok ves.> ");
INSERT INTO yam_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bʉsə̀ a ye-a ŋga bwìŋ sə gʉ̀ bum sə̀ wèŋ sə yə yè'e ŋga tʉ cu lì ntòcə̀còŋ ye də nà'a yum-a, ye wesə yè'sə ŋga'a nsàp nə̀ fò?>> ");
INSERT INTO yam_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bʉ̀ ŋgàa gʉ̀ bʉp mok à ye bwìŋ ba sə̀ wo à sə jə be'lə lòwo də wo kə zə be'lə wo bə Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wo à kə̀ dzèŋ mvwe' sə̀ wo togə̀ fo' Nzʉ̀ə̀ Tu Bwìŋ àwo fana wo tɛ'lə yi mʉ ntə̀əŋ anə fo', bə ŋgàa gʉ̀ bʉp sə wèŋ. Wo à tɛ'lə ŋgà gʉ̀ bʉp mòk bo ma zʉ, mòk bo ma ŋkwìp. ");
INSERT INTO yam_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Fana Jisòs dʉk də, <<Tɛ̀' am, swì fa wo bʉ̀ʉsə̀ wo ka yusə̀ wo sə gʉ̀ sə riŋ.>> Wo sə təm bèŋ də ya wo gapsə cə̀ək ye sə. ");
INSERT INTO yam_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bʉ̀ʉ səmok à təəŋ fo', nə sə kʉk. Bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ à sə ywì'lə yi. Wo sə dʉk də, <<Yi tɛsə riŋ boŋsə megu bʉ̀ʉ mok wèŋ, yi tɛsə-a ni' ye, ŋga a ye-a də yi Ŋkum ŋgà gèm bwìŋ nə̀ Nwì à cok fis, nə tumsə fa ves na!>> ");
INSERT INTO yam_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sojàa sə̀ wo à ye fo' sə à ywì'lə yi sə̀'. Wo sə kə fa yi nsàp rùk mòk nə̀ cəcəp. ");
INSERT INTO yam_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Wo sə cep də, <<A ye-a ŋga wu ŋkum bʉ̀ʉ Jus wèŋ nə, wù tɛsə-a ni' yò!>> ");
INSERT INTO yam_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wo à còm naaŋ yumok ma mʉ tu ntə̀ŋ anə də, Nè'e ŋkum bʉ̀ʉ Jus wèŋ nə. ");
INSERT INTO yam_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ŋgà gʉ̀ bʉp mòk nə̀ yi à kə̀'ə sə̀' mʉntə̀əŋ anə, à yàk yi də, <<Ŋkum ŋgà gèm bwìŋ ka wù nè'e yeŋ à? Tɛsə ni' yò, nə tɛsə ves sə̀'!>> ");
INSERT INTO yam_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mòk nə cep jwa nà' də, <<Wu kà Nwì wəpgə̀ à? Vesùwèŋ pwe'fo' cu sə mvwe' kʉ̀ʉŋ sə̀ mò'fis. ");
INSERT INTO yam_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Vesù sə yə yàvès ŋgə' bə yusə̀ a gʉ̀ yà' laŋ, ŋgà' ènə ka ye yumok gʉ bʉpsə lok.>> ");
INSERT INTO yam_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yi dʉk fa Jisòs nə də, <<Wu kə̀ dzèŋ mvwe' gaŋ ŋkum yo, wù kà mʉ swì.>> ");
INSERT INTO yam_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisòs dʉk fa nà' də, <<Mʉ tsok fa wu ŋkèm dʉk də, wu nə ye vesù ntinə mʉ Pàràde.>> ");
INSERT INTO yam_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ànə ye ŋga nùum mok maràŋ fana ndzəm seŋ mvwe' nzeŋgòŋ nə pwe' tə̀tè kə dzeŋ co nùm sə̀m. ");
INSERT INTO yam_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Fana cə̀k nə̀ nà' à sə gàpsə mbwè ndap mòk mʉmvwe' ndap Nwì nə̀ ghaŋ nə à sàha gà'a tsə ba. ");
INSERT INTO yam_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Fana Jisòs waŋ torə fis mʉtsə̀ də, <<Tɛ̀', mʉ̀ fa yòŋsə̀ àm ndzə bohòwù!>> Yi ànə cep vɛ'nə fana yòŋsə̀ ye me. ");
INSERT INTO yam_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ŋkum sojà mòk ànə ye bum sə̀ yà' ye sə fana yi kwasə Nwì, nə cep də, <<A zìnə də ŋwə̀ ènə nə ka yumok riŋ!>> ");
INSERT INTO yam_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma ŋgo bʉ̀ nə̀ wo à ye fo' nə, ànə ye yusə̀ yà' ye sə pwe' fana wo bwi foho lo la'à wo, ŋga wo wa'a tse' lòbo ndzə ŋgùu wo. ");
INSERT INTO yam_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bʉ̀ʉ sə̀ wo à rì Jisòs nə, bə bə̀ba sə̀ wo à bɛ' və̀ yi mvwe' nzeŋgòGalìli sə wèŋ à kə̀ təəŋ mvwe' mok sə̀sap, nə sə ja'a bum yè'sə. ");
INSERT INTO yam_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ŋwə̀ nəmòk à ye nə̀ liŋ ye à ye də Jòsep, yi à tesə və̀ lak Àrìmàtayà mvwe' nze Jùdiyà. Yi à ye mòk mʉmvwe' kwe' kaŋsurù nə̀ bʉ̀ʉ Jus wèŋ nə, nə ye sə̀' ŋwə̀ nə̀ kə̀kʉrə̀ mʉ lisə̀ Nwì. Yi à sə tək ye gaŋ ŋkum sə̀ Nwì sə. Yi à ka ye bə bum sə̀ wo a cèptes, nə sə gʉ yà' sə dzəm. ");
INSERT INTO yam_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ŋwə̀ ènə à lòbohòPalè, nə kə lɛŋ vèŋ ni' Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Fana yi kə ki tsoŋ nà', nə lim gesə ndzənə cə̀k, nə kə tuuŋ nà' ndzənə sèe sə̀ wo à tu yà' ndzənə lìs. À ye ŋga wo ka ŋwè nja ntòtuuŋ yuk. ");
INSERT INTO yam_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ànə ye nùmbu nə̀ wo à sə fʉ̀hʉ, ya ŋga nùmbu dzə̀ə yeto. ");
INSERT INTO yam_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bə̀ba sə̀ wo à bɛ' və̀ yi mvwe' nze Galìli sə à yù lòo, nə kə ye sèe sə, nə ye mvəsə̀ wo tuuŋ vèŋ ye nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wo à bwìŋ lòo, nə kə fʉhʉ làmindà bə mve' sə̀ wo nə kə yok vèŋ ni' Jisòs bə zeŋ. Nùmbu dzə̀ à ye, wo yoŋsə yiskok mʉmvə̀'nə̀ lʉ̀k sə dʉk vɛ'nə ŋkuŋ nə lo kə̀ yo' yi. ");
INSERT INTO yam_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nù Sondè à ye, bàa sə lo mvwe' sèe sə nə̀ zəzòŋ, ŋga wo kotse' lòmve' sə̀ wo à fʉ̀hʉ yà' sə. ");
INSERT INTO yam_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wo ye ŋga wo dzərə fis lìs nə̀ wo ànə lok ncùu sè sə bə zeŋ nə laŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wo ànə ni lo sənə sèe sə fana wo kà vèŋ ni' Tà Jisòs nə ca yə. ");
INSERT INTO yam_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mʉmvə̀'nə̀ ŋkərə̀ awo à jip fo' fana wo ye bʉ̀ʉ mok fo' ba ŋga wo ni tse' cə̀ək sə̀ fəfəp, yà' sə ba'a vɛ'ɛ. ");
INSERT INTO yam_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wʉə à ko wo, wo gbʉ fə'ə gesə lo si awo sə nze. Fana bʉ̀ʉ sə dʉk fa wo də, <<Wèŋ sə làp ŋwə̀ nə̀ yi cu ye ŋwəm mʉtsətsə'rəə bʉ̀ kpʉkpʉ bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yi ka fɛŋ yeŋ, yi lòkok laŋ. Wèeŋ tsərə yusə̀ yi ànə tsok weŋ ŋga yi cu ntòmvwe' nzeŋgòGalìli yà'a. ");
INSERT INTO yam_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Yi ànə dʉk də, <Wo nə fa tsooŋ mʉ̀ʉ mo ŋwè ndzə bohòŋgàa gʉ̀ bʉp wèŋ, wo tɛ'lə mʉ mʉntə̀əŋ; nùmbu tɛ' ye, mʉ̀ lokok sə̀mok.> >> ");
INSERT INTO yam_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ànə geŋ wo tsərə ncèp ye nə. ");
INSERT INTO yam_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wo à bwìŋ foho və̀ mvwe' sèe sə, wo kə tsok fa bum yè'sə bohòbwe ye sə̀ hum-ncòp-mò'fis sə, bə bʉ̀ʉ mok wèŋ pwe'fo' sə̀'. ");
INSERT INTO yam_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ànə kə tsok fa ŋgàa ntum sə wèŋ bum yè'sə Mèri Màdàlinà bə Jòanà bə Mèri nə̀ ma Jem, nə ye bàa mok wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wo à tsəm də bàa yè'sə sə cèp yusə̀ yà' ka fàk tse' fana wo kà yà'wèŋ dzəm fa. ");
INSERT INTO yam_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pità à lòkok mʉtsə̀, nə caŋ lo mvwe' sèe sə. À kə̀ dzèŋ fo', yi bʉhʉ tsoŋ nze, nə ye megu cə̀ək sə̀ wo à tuuŋ yi bə zeŋ sə, nə kà yumok sə̀ zok yə. Fana yi bwi foho lo lak, nə sə jip bə nsàp yu nə̀ nà' ye ènə wùriŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nùmbu ànə à ye, bʉ̀ʉ səmok à sə lòmvwe' lak mok sə̀ wo to yà' də Emàwùs, ŋga wo bwìŋ ba. Lak Emàwùs sə à ye co kìlometà hum-ncòp-mò'fis ŋgòlòJòrosalèm. ");
INSERT INTO yam_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wo à sə taaŋ lòbə bum sə̀ yà' ye yè'sə pwe'. ");
INSERT INTO yam_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wo ànə sə taaŋ ncèp ènə mvwe' mò'fis fana Jisòs à sòoŋ və̀ fo' sə̀' bə tu ye, bə yà'wèŋ sə lo ca. ");
INSERT INTO yam_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wo ye yi, fana yumok gʉ də wo kà yi rì. ");
INSERT INTO yam_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yi fek yà'wèŋ də, <<Wèŋ sə gì, nə sə taaŋ lo yè'sə yu yà?>> Wo foho təəŋ, nə sə kʉk bə manziŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mòk nə̀ liŋ ye à ye də Klipàs dʉk fa nà' də, <<Co wu yè'e ŋkʉ̀ìŋ mvwe' lak Jòrosalèm, də mègù wù nə̀ wù ka yusə̀ yà' a ye nùumbu yè'e riŋ à?>> ");
INSERT INTO yam_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yi fek fe'lə yà' də, <<A yu yà?>> Wo dʉk fa yi də, <<Bum sə̀ yà' a ye bə liŋ Jisòs nə̀ mvwe' lak Nazàrɛ. Yi à ye ŋgà tsòhòbum Nwì, yi à sə gʉ̀, nə sə cep bum sə̀ yà'a gʉgʉŋ wùriŋ mantombìi Nwì nə ye bwìŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ŋgàa fa satikà' bə bʉ̀ ŋkwàha bʉ̀ avès wèŋ a cèp wo ŋkuŋ wo tɛ'lə zə yi mʉ ntə̀əŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Vès à sə naaŋ yàvès tu də nà'a yi nə̀ yi nə lak tiŋ fis bʉ̀ʉ Izùrɛ. Yà'sə ye-a sə̀' vɛ'nə, a ntinə nùumbu tɛ' nə̀ bum yè'sə a ye. ");
INSERT INTO yam_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Fana bàa səmok sə̀ mʉŋgorə̀ vès kə̀ vèsə nòoŋ ves zooŋ, də wo anə yaaŋ lo nooŋ mvwe' sèe ye sə, ");
INSERT INTO yam_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nə kà vèŋ ni' ye nə yə. Wo bwìŋ və̀, nə sə dʉk də wo ye masinjàa Nwì. Masinjàa Nwì sə tsə̀' fa wo də nà' cu ŋwəm. ");
INSERT INTO yam_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bʉ̀ʉ mok sə̀ anə ye vesi wèŋ lòmvwe' sèe sə, nə ye ŋga yà' mègù mvə̀'nə̀ bàa sə nə cep sə zìnə, fana wo kà yi ye bə lis yə.>> ");
INSERT INTO yam_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jisòs dʉk bʉsə fa yà'wèŋ də, <<Hò! Ləm bʉ̀ʉ yè'e wèŋ; wèŋ tse' ntʉm nə̀ nà' fi bʉp ŋgòdzəm tse' bum sə̀ ŋgàa tsòhòbum Nwì à cèep. ");
INSERT INTO yam_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Yà' ànə ka yeŋ də Ŋkum ŋgà gèm bwìŋ nə nə ye nsàap ŋgə' yè'sə ŋkuŋ nə ca ni mvwe' bòoŋ ye yeŋ à?>> ");
INSERT INTO yam_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Fana yi ye jəŋ mʉ ni'ì Musì bə ŋgàa tsòhòbum Nwì wèŋ, nə tsoho rɛŋsə fa wo bum sə̀ ŋwàk Nwì à sə cèp yà' bə liŋ ye sə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ànə geŋ wo sə kʉəp lo mvwe' lak sə̀ wo à sə lòfo' sə. Yi sə gʉ ye sə co də yi sə cà lòmalì mantombì vɛ'ɛ. ");
INSERT INTO yam_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Fana wo sə lɛŋ nà' də, <<Vesùwèeŋ nooŋ fɛn, bʉ̀ʉsə̀ nùm co wes laŋ, ndzəm sə və̀ə.>> Fana bə yà'wèŋ lo ŋgòkə̀ nòoŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ghà nə̀ bə yà'wèŋ ànə sə zʉ zʉzʉ fana yi jəŋ brɛd sə, nə kwasə Nwì, nə bə'rə fa yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Fana lis awo muhu, wo riŋ yi; yi nom bisə mʉlisə̀ wo mvwe' sə̀ yi anə ye sə wà. ");
INSERT INTO yam_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mòk ye ŋga'a ŋgòfek mòk də, <<Ghà nə̀ yi anə sə cep bohòvesù mandzə̀, nə sə tsoho rɛŋsə fa ves bum sə̀ ndzənə ŋwàk Nwì yà'a, mʉ̀ də ntʉm nə kaŋ ves vɛ'ɛ wùriŋ àlaa?>> ");
INSERT INTO yam_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wo à lòkok mègù sə̀' mvə̀k ànə, nə bwi lo Jòrosalèm. Wo kə tseŋ bwe ye sə̀ hum-ncòp-mò'fis sə wèŋ, ŋga wo cu mvwe' mò'fis bə bʉ̀ʉ mok wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bə yà'wèŋ sə cep də, <<Tà a lòkok laŋ nə̀ zìnə, Saimʉ̀ yə yi bə lis!>> ");
INSERT INTO yam_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Fana wo tsok bwi ŋga'a yusə̀ yà' anə ye mandzə̀, nə ye mvə̀'nə̀ wo anə riŋ nà' ghà nə̀ nà' anə bə'rə brɛd sə. ");
INSERT INTO yam_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mʉmvə̀'nə̀ wo ànə sə cep vɛ'nə fana Jisòs nə bə tu ye tesə təəŋ və mʉtsətsə'rə̀ə wo anə nə dʉk də, <<Fifi ye bohòwèŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wo à vèhe, nə wəp vɛ'ɛ; wo à tsəm də kàmòk wo yə ze'. ");
INSERT INTO yam_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yi dʉk fa yà' də, <<Wèŋ sə wəp yà? Wèŋ sə mərə kɛ' sə ntʉʉ̀ wèŋ bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wèeŋ kʉk ja'a bo am bə kùu am, ya wèeŋ riŋ də a mʉ̀ nə. Wèeŋ jwɛŋ ja'a mʉ bə bo, bʉ̀ʉsə̀ ze' kà njàp bə vəp mvəsə̀ wèŋ yə də mʉ̀ tse' yè'e tse'gə̀.>> ");
INSERT INTO yam_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yi ànə cep vɛ'nə fana yi niŋ fa wo bo ye bə kùu ye wèŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mvə̀'nə̀ wo à ka sə ntʉʉ̀ wo pap ntòdzəm wes bʉ̀ʉsə̀ wo à kwa ti' ləlà, nə sə mərə, fana yi fek yà'wèŋ də, <<Wèŋ tse' yumok fɛɛŋ sə̀ co ŋwè zʉ à?>> ");
INSERT INTO yam_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wo fa yi fuk nə̀ ləla, ");
INSERT INTO yam_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","yi jəŋ nà', nə zʉ mʉlisə̀ wo. ");
INSERT INTO yam_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ànə geŋ yi dʉk fa wo də, <<Yè'e yusə̀ mʉ̀ ànə tsok fa weŋ ŋga mʉ̀ cu ntòvesùwèŋ sə, də yusə̀ wo à còm yà' bə liŋ am ndzənə ŋwàk lʉ̀ʉk Musì, nə ye sə̀ ŋgàa tsòhòbum Nwì bə ŋwàk Sàam wèŋ pwe' nə̀ bʉ̀ʉŋ və̀ tsoŋ zìnə.>> ");
INSERT INTO yam_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Fana yi rɛŋsə ŋkərə̀ə awo ŋgòrì yusə̀ yà' cu ndzənə ŋwàk Nwì. ");
INSERT INTO yam_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yi dʉk də, <<Yè'e mvə̀'nə̀ wo à còm də, Ŋkum ŋgà gèm bwi nə nə ye ŋgə', fana nùmbu nə̀ tɛ' kə̀ dzèŋ fana yi lokok mvwe' kpʉ sə̀mok. ");
INSERT INTO yam_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nə ye sə̀' də, wo nə sə tsoho lo sənə nzeŋgòŋ nə pwe'fo' bə liŋ am ŋga wo yèto ntòmvwe' lak Jòrosalèm. Wo nə sə tsoho lo ncèp nə̀ ŋgòkupsə, nə bwi fa bʉp ŋkwɛ̀ŋ, fana Nwì swi fa ŋwè bʉp ye. ");
INSERT INTO yam_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","A wèŋ sə̀ wèeŋ nə tsok lo bʉ̀ʉ mok, bʉ̀ʉsə̀ wèŋ yə bə lis awèŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wèeŋ ye, mʉ nə tumsə fa weŋ yusə̀ Tɛ̀' am a kàk mʉ yà' sə; fana wèeŋ cum tse' mʉntòlak fa'nə tə̀tè ŋàaŋ sə̀ yà'a nə tsoŋ ma mʉbu sə və bohòwèŋ ŋkuŋ.>> ");
INSERT INTO yam_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ànə geŋ yi jəŋ fis lo yà'wèŋ mʉntòlak anə, bə yà'wèŋ lo tə̀tè kə dzeŋ mvwe' lak Betanì. À kə̀ dzèŋ fo', yi fis kok bo ye mʉtsə̀, nə se wo. ");
INSERT INTO yam_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yi à sə sè wes wo ntɛ̀ŋ fana yi me'rə yà'wèŋ, nə kok lo mʉbu. ");
INSERT INTO yam_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wo à kuksə yi, nə bwi foho lo Jòrosalèm anə bə kwəkwa vɛ'ɛ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wo cum mamgeŋ mʉmvwe' ndap Nwì nə̀ ghaŋ nə, nə sə kuksə Nwì mbwa.");
INSERT INTO yam_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ŋkuŋ Nwì sə gʉ nzeŋgòŋ nə ŋga ŋwə̀ nə̀ wo to liŋ ye də Ncèp nà'a cu ye yo. Ncèp nə ànə sə ye bə Nwì mvwe' mò'fis. Yi ànə ye megu Nwì bə tu ye. ");
INSERT INTO yam_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mvə̀'nə̀ ànə yeto, yi à ye mègù ye sə bə Nwì. ");
INSERT INTO yam_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nwì à gʉ̀ bum pwe' ndzə bohòyi. Yumòk nə̀ yi à ka nà' yi gʉʉ bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lùŋ pwe'fo' à tesə və̀ bohòNcèp ènə. Lùŋ nə̀ yi à fa nə, à ye marɛŋ bohòbwìŋ. ");
INSERT INTO yam_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Marɛŋ nə rɛŋgə̀ mvwe' ndzəm nùumbu pwe', ndzəm nə ka marɛŋ nə ghak yuk. ");
INSERT INTO yam_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ŋwə̀ nəmòk à ye, nə̀ Nwì ànə tumsə və yi nə̀ liŋ ye à ye də Jon. ");
INSERT INTO yam_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yi ànə və ye ŋgòkə̀ tsə̀' rɛŋsə fa bwìŋ marɛŋ nə, ya ndàaŋwè pwe' yuk yusə̀ yi sə cèp sə, nə dzəm bohòmarɛŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yi ànə ka marɛŋ nə yi yeŋ. Yi à və̀ ye ŋgòtsə̀' fa bwìŋ bə marɛŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Marɛŋ nə̀ zìnə, nə̀ nà'a fagə̀ ndàaŋwè pwe' marɛŋ nə à ye ŋgòtesə və̀ sə nzeŋgòŋ anə ghà ànə. ");
INSERT INTO yam_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yi ànə cum sənə nzeŋgòŋ nə̀ yi à gʉ̀ nə, fana bʉ̀ʉ sə̀ wo cu sənə nzeŋgòŋ nə wèŋ kà yi yu awo rì. ");
INSERT INTO yam_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yi à və̀ mvwe' lak ye, bʉ̀ʉ lak ye wèŋ sə kà yi dzəm. ");
INSERT INTO yam_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma nə̀ bohòbòp bʉ̀ nə̀ wo à jə yi, nə dzəm bohòyi sə fana, yi à fa yà'wèŋ mandzə̀ ŋgòbʉ̀ʉŋ bwe sə̀ Nwì. ");
INSERT INTO yam_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wo à bʉ̀ʉŋ bwe ye wèŋ vɛ'nə ŋga ànə gʉ megu Nwì. Ànə ka bʉ̀ʉsə̀ wo à dzə yi mvə̀'nə̀ bwìiŋ dzəgə̀ bwe yà'a yeŋ. Ka də ŋwè à tsərə kok yi sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ncèp nə à bʉ̀ʉŋ ŋwè sə nze fɛn, nə kə cum mʉtsətsə'rəə vès vɛ'nə fana vès ye yi co ŋwə̀ nə̀ ghaŋ nə̀ Tɛ̀' ye Nwì ànə fa bohòmo ye nə̀ mò'fis nə. Yi a nìtsə̀' fa ves mvə̀'nə̀ Nwì cu sə də yi tse' bòvə̀m wùriŋ, nə tse' zìnə sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ànə tsok rɛŋsə fa bwìŋ bə ŋwə̀ ènə yi. Yi à cèp də, <<Nè'e ŋwə̀ nə̀ mʉ̀ ànə tsok fa weŋ fa' də ŋwə̀ nə̀ yi sə və̀ ma ŋkwɛ̀ɛŋ mʉ̀ nə yam casə mʉ bʉ̀ʉsə̀ yi ànə ye fo' ŋga wo kà mʉ ntòdzə lok.>> ");
INSERT INTO yam_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mvə̀'nə̀ yi rwiŋ mègù bə bòvə̀m bohòvès fana yi a sè ves pwe' kə̀kɛ̀'. ");
INSERT INTO yam_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Musì à jə və̀ fa ves lʉ̀ʉk sə̀ Nwì sə yi fana Jisòs Krɛst jəŋ və fa ves ye bòvə̀m nə̀ Nwì nə ye zìnə nə̀ Nwì nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ŋwə̀ nəmòk ka Nwì bə lis ntòye yuk. Mègù mo ye Jisòs Krɛst nə̀ yi co ntʉm Tɛ̀' ye nə, nə̀ yi a rɛŋsə fa ves mvə̀'nə̀ Nwì cu. ");
INSERT INTO yam_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nùmbu mòk à ye, ŋkwàha bʉ̀ʉ Jus sə̀ mvwe' lak Jòrosalèm wèŋ tumsə lo ŋgàa fa Nwì satikà'a mok mʉmvwe' Ndap Nwì nə̀ ghaŋ, bə bʉ̀ʉ Levì wèŋ mok, də yà'a kə fek Jon də nà'a nsàp ŋwə̀ nə̀ fòlɛ? ");
INSERT INTO yam_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon nə dʉk fəsə fa yà'wèŋ də, <<Mʉ̀ ka Ŋkum ŋgà gèm bwìŋ nə̀ Nwì à də yi nə tumsə və̀ ŋgòkə̀ tɛsə bʉ̀ avès nə yeŋ.>> Yi à ka dzeeŋ, yi à cèp fis bum yè'sə yuye jəja mvwe' bwìŋ. ");
INSERT INTO yam_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wo fek fe'lə yi sə̀mok də, <<Ye də wu ndà lɛ, wu Àlajà à?>> Yi dʉk fe'lə sə̀' də, <<Hai', mʉ̀ ka Àlajà sə̀' yeŋ.>> Wo fek mali yi sə̀' ŋkuŋ də, <<Ye də wu ŋgà tsə̀' bum Nwì nə̀ ŋwàk Nwì sə tsə̀' də nà'a nə̀ və̀ə nə à?>> Jon dʉk mali sə̀' də, <<Na'à mʉ̀ yàm. Mʉ̀ ka yi ànə yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Fana wo fek mali yi sə̀ ŋkuŋ də, <<Ye də wu yè'sə ndà lɛ? Bʉsə̀ kaco vès lo ŋga wù ka ves tsok fa yeŋ, ya vèes kə tsok bʉ̀ʉ sə̀ wo tum ves sə. Wù dʉk yòbə tu yòdə wu ndà lɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yi dʉk də, <<Ŋgà tsòhòbum Nwì nə̀ njamòk nə̀ liŋ yee Ìzayà nà'a ànə cep fa' də, <Ŋgì ŋwə̀ nəmòk sə cèp torə və̀ sə ŋgəà də, <<Tà àvès sə və̀ə. Wèeŋ gʉhʉ tsə'rə fa yi mandzə̀ ŋgògì cà ca.>> > Ŋwə̀ nə̀ Ìzayà à sə də ŋgì nà' sə cèp ànə mʉ̀ nə.>> ");
INSERT INTO yam_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bʉ̀ʉ Faràsi mok wèŋ à ye mʉŋgorə̀ bʉ̀ʉ sə̀ wo à kə̀ yə Jon sə. ");
INSERT INTO yam_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Fana wo fek Jon nə də, <<A ye-a ŋga wù ka ŋgà gèm bwìŋ nə yeŋ, kà Àlajà sə̀' ye, nə kà ŋgà tsə̀' bum Nwì nə sə̀' ye, ye də wù sə bàptɛsə bwìŋ bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon dʉk fa yà' də, <<Mʉ̀ sə bàptɛsə mègù yàm bə ndzəp. Ŋwə̀ nəmòk cu mʉtsətsə'rə wèŋ nə̀ wèŋ sə kà yi rì, anə kà sàp ŋga yi yèto fàak ye laŋ. ");
INSERT INTO yam_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ŋwə̀ nə̀ yi sə və̀ ma ŋkwɛ̀ɛŋ mʉ̀ ànə, yi yam càsə mʉ yi. Mʉ̀ ka ŋwə̀ nə̀ co mʉ̀ firə fa yi kʉ̀ʉ kùuŋgùup ye kʉrə.>> ");
INSERT INTO yam_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yè'sə à ye mvwe' lak Betanì. Lak Betanì sə à ye ma ntonùum ndzəp Jòridàŋ. Yà'a mvwe' sə̀ Jon à sə bàptɛsə bwìŋ fo' sə. ");
INSERT INTO yam_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tsok à rɛŋ, Jon ye ŋga Jisòs sə və̀ mvwe' ye sə fana yi cep də, <<Wèeŋ yeè, nè'e ŋwə̀ nə̀ yi mo nsùŋga Nwì nə. Nè'e yi nə̀ Nwìi nə jəŋ yi co ndzə cop, nə yisə fis gɛsə bʉp bwìŋ sə nzeŋgòŋ bə zeŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nè'e yi nə̀ mʉ̀ cèp də ŋwə̀ nəmòk sə və̀ ma ŋkwɛ̀ɛŋ mʉ̀, nə̀ yi yam càsə mʉ nə, bʉ̀ʉsə̀ yi ànə ye fo' ŋga wo ka mʉ ntòdzə. ");
INSERT INTO yam_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mʉ̀ à sə kà yi yàm də nè'e yi nə sə̀ rìgə̀. Ànə ye-a sə̀ vɛ'nə fana njo njàm nə̀ mʉ̀ à sə bàptɛsə bwìŋ nə, à ye də ya bʉ̀ʉ Izùrɛ wèeŋ riŋ yi.>> ");
INSERT INTO yam_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon nə à cèp fe'lə sə̀mok dʉk də, <<Mʉ̀ a yə Yòŋsə̀ Nwì ŋga nà' tsə tesə mʉbu co kəkəbʉ̀ŋ, nə kə naaŋ mʉtuhù Jisòs. ");
INSERT INTO yam_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","À sə kə̀ dzèŋ mvə̀k ànə ŋga mʉ̀ à ka yi yàm də yi ŋwə̀ ànə ntòriŋ. Megu də Nwì nə̀ yi à tum mʉ də mʉ bàptɛsə bwìŋ bə ndzəp nə à tsə̀' mʉ də, a ye ŋga mʉ̀ yə ŋwə̀ nə̀ yòŋsə̀ ye tsoŋ və̀, nə kə naaŋ nà' mʉtuhù àlɛ, mʉ̀ riŋ də nà'a ŋwə̀ nə̀ yi nə baptɛsə bwìŋ bə Yòŋsə̀ nə̀ Rərɛŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mʉ̀ nə sə tsə̀' nə weŋ zìnə àm pwe'fo' də mʉ̀ a yə bum yè'sə laŋ, fana mʉ̀ nə sə tsə̀' nə weŋ jəja də ŋwə̀ ènə, yi mo Nwì nə.>> ");
INSERT INTO yam_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tsok à rɛŋ fe'lə sə̀mok ŋga Jon tə bə ŋgàa fàak ye wèŋ ba. ");
INSERT INTO yam_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yi ye ŋga Jisòs sə càa fana yi cep də, <<Wèeŋ ye, nà'a mo nsùŋgaŋ Nwì nə.>> ");
INSERT INTO yam_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ŋgàa fàak sə̀ ba sə à yuk yusə̀ Jon à cèp sə fana wo lokok, nə bɛ' lo Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisòs à bʉ̀ʉŋ kʉ̀ʉk, nə ye ŋga yà'wèŋ sə yù və̀ yi fana yi fek yà' də, <<Wèŋ sə lòfò?>> Wo dʉk bwi fa nà' yàwo də, <<Cicà, wu cugə̀ ma fò?>> Cicà nə bə ncèep lak awo yà'sə də Rabì. ");
INSERT INTO yam_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jisòs nə dʉk fa wo də, <<Wèeŋ və-a kə ja'a.>> Wo à lòo, nə kə ye mvwe' sə̀ yi cugə̀ sə. Bə yà'wèŋ cum mam fo' ŋga nùm na lòvɛ'ɛ tə̀tè ndzəm kə seŋ tasə cù. ");
INSERT INTO yam_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Bʉ̀ʉ sə̀ ba sə̀ wo ànə yuk ŋga Jon cèp fana wo bɛ' lo Jisòs sə, mòk ànə ye Andrù. Andrù nə à ye moma Saimʉ̀ Pità. ");
INSERT INTO yam_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yi à ca lòo, nə kə ye tə̀tà ye Saimʉ̀, nə tsok nà' də, <<Vès yə Mèzayà nə bə lis laŋ.>> (Mèzayà nə yà'sə də Krɛst. A yà'sə də, Ŋkum ŋgà gèm bwìŋ nə.) ");
INSERT INTO yam_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Fana yi jəŋ və Saimʉ̀ nə, bə nà' kə̀ ye Jisòs. Jisòs kʉk ja'a Saimʉ̀, nə dʉk fa nà' də, <<Wùu Saimʉ̀ mo Jon, wo nə sə to wu mok sə̀' də Kefàs.>> Liŋ sə̀ də Kefàs yà'sə mègù sə̀' co liŋ sə̀ də Pità yà'a. Yà'a də Lìs. ");
INSERT INTO yam_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tsok à rɛŋ sə̀mok fana Jisòs də yi lo yuye mvwe' nzeŋgòGalìli. Ànə geŋ yi ye Filìp, nə dʉk fa nà' də, <<Bɛ' və mʉ.>> ");
INSERT INTO yam_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filìp nə à ye mo lak mvwe' lak Bèsadà, Andrù bə Pità ye sə̀' bwe lak fo'. ");
INSERT INTO yam_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filìp à kə̀ yə Nàtaniyà, nə tsok nà' də, <<Vès yə ŋwə̀ nə̀ Musì à còm bə liŋ ye ndzənə ŋwàk lʉ̀k, ŋgàa tsòhòbum Nwì sə̀ njamòk wèŋ ànə com bə liŋ ye sə̀' nà'a laŋ. A yi Jisòs nə̀ yi tesə və̀ mvwe' lak Nazàrɛ, nə̀ yi mo Jòsep.>> ");
INSERT INTO yam_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nàtaniyà nə dʉk fa nà' də, <<Me'rə mʉ fɛn, wù tsəm də aco yusəmok sə̀ yà' tse' fàk tesə yuk mvwe' lak Nazàrɛ à?>> Filìp də, <<Və̀ kə̀ ja'a bə lis yo.>> ");
INSERT INTO yam_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisòs à yə Nàtaniyà ŋga nà' sə gì və̀ə fana yi cep də, <<Nè'e mo Izùrɛ nə̀ yi zìnə nə, yi ka mʉzə̀p limŋgòŋ tse' lok.>> ");
INSERT INTO yam_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nàtaniyà nə də, <<Hàva', wù riŋ mʉ fò?>> Jisòs dʉk də, <<Ghà nə̀ wù anə sə cum sə mbwè tʉ nə̀ wo togə̀ nà' də fik nà'a, ŋga mʉ̀ yə wu yàm laŋ ŋkuŋ Filìp sə kə to wu.>> ");
INSERT INTO yam_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nàtaniyà dʉk megu mok də, <<Cicà, wu mo Nwì, wu Mèzayà nə̀ yi ŋkum bʉ̀ʉ Izùrɛ wèŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisòs dʉk fa nà' də, <<Wù dzəm yè'sə bʉ̀ʉsə̀ mʉ̀ tsə̀' wu də, mʉ̀ anə ye wu ŋga wù cu sə mbwè tʉ fik sə à? Nà'nə ka yumok yeŋ. Mʉ̀ sə tsə̀' fa wu zìnə də, wu nə ye bum sə̀ yà' yam càsə nà'nə.>> ");
INSERT INTO yam_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yi dʉk fa mali nà' də, <<Wu nə ye ŋga ntòbu mùhu nòto fana masinjàa Nwì wèŋ sə lo kəkok, nə sə tsoŋ tsətsoŋ mʉ tuhù mʉ̀ʉ mo ŋwè.>> ");
INSERT INTO yam_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","À cà nùumbu ba fana bʉ̀ʉ mok də wo gʉ gù mvwe' lak Kanà nə̀ nà'a mvwe' nze Galìli. Ma Jisòs à ye sə̀' fo'. ");
INSERT INTO yam_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Wo à to lòJisòs bə ŋgàa fàak ye wèŋ sə̀' fo'. ");
INSERT INTO yam_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mvə̀'nə̀ wo ànə sə no rùk fo' fana rùuk sə me tiŋ. Ma Jisòs kə dʉk fa nà' də, <<Wo ka rùk mok tse'.>> ");
INSERT INTO yam_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisòs nə dʉk fa fəsə nà' də, <<Nà'a nzak njòma àm a, mvə̀k njàm ka ntòkʉrə.>> ");
INSERT INTO yam_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma ye nə kə dʉk fa ŋgàa fàak sə̀ fo' sə wèŋ də, <<Yusə̀ yi tsə̀'-a weŋ lòoŋ, wèŋ gʉ yà'.>> ");
INSERT INTO yam_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ànə ye ŋga bèe mok tə fo' ntùŋfu, sə̀ wo à gʉ̀ yà' bə lìs. Ànə ye bèe ndzəp sə̀ bʉ̀ʉ Jus wèeŋ cùk rɛŋsəgə̀ bo awo bə zeŋ ya wo ye rərɛŋ mʉ lisə̀ Nwì. Bè nə̀ mò'fis à sə rwiŋ ŋga ndzəp ca co jok kwè kè ntùŋfu àlɛ'. ");
INSERT INTO yam_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisòs dʉk fa wo də, <<Wèeŋ tuk rwiŋsə bèe sə bə ndzəp pwe'fo'.>> Wo tuk rwiŋsə yà' bə ndzəp vɛ'ɛ leer. ");
INSERT INTO yam_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yi dʉk fa fe'lə yà'wèŋ də, <<Wèeŋ səp fis-a yà' ŋga'a, nə fa ŋwə̀ nə̀ yi gàp fa bwìŋ nə.>> Fana wo səp, nə fa lo yi. ");
INSERT INTO yam_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ndìgàp nə à no ja'a ndzəp sə̀ yi bʉ̀sə yà' rùk sə. Yi kà mvwe' sə̀ yà' və̀ə rì. Ŋgàa fàak sə̀ wo ànə tuk ndzəp sə wo riŋ megu wo. Ndìgàp nə to bwi ye ndugù nə. ");
INSERT INTO yam_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Nà' ànə və̀ə, yi dʉk fa nà' də, <<Wo fa togə̀ bwìŋ ntòrùuk sə̀ bə̀boŋ tə̀tè a ye ŋga bwìŋ no ze' ŋkuŋ wo fis və sə̀ yà' ka ŋkʉ̀ʉŋ boŋ. Wù jəə̀ nə yòrùuk sə̀ bə̀boŋ sə, nə tes loksə tə̀tè kə wɛs ŋga'a nà?>> ");
INSERT INTO yam_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nè'e maŋgəŋgèŋ nə̀ Jisòs à gʉ̀ to tsə cap. Yi à gʉ̀ nà' mvwe' lak Kanà nə̀ mvwe' nze Galìli. Yi à nìtsə̀' ŋàaŋ ye bə zeŋ fana ŋgàa fàak ye wèŋ dzəm tsə'rə wesə bohòyi. ");
INSERT INTO yam_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yè'sə ànə me fana Jisòs nə yè'e fa'nə, nə tsooŋ lo mvwe' lak Kàpanùm. Yi à lòfo' bə ma ye, nə ye bwema ye, bə ŋgàa fàak ye wèŋ sə̀'. Wo à kə̀ cu yòŋsə fo' nùumbu mok jo. ");
INSERT INTO yam_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ànə ye ŋga ŋkàk bʉ̀ʉ Jus wèŋ nə̀ wo togə̀ nà' də Pasobà nà'a kəp və̀ə fana Jisòs yè'e, nə kok lo mʉ Jòrosalèm. ");
INSERT INTO yam_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","À kə̀ dzèŋ mʉmvwe' ndap Nwì nə̀ ghaŋ nə fana, yi ye bwìŋ ŋga wo sə sèŋ mbòŋ bə nsùŋgaŋ nə ye kəkəbʉ̀ŋ wèŋ mbwa. Yi ye bʉ̀ ŋgàa kup mbàm wèŋ ŋga wo sə kupsə nsàp mbàm nə̀ co wo fa Nwì fəfa bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yi fʉəp kʉ̀ mòk co ŋkwɛ̀s, nə bɛ' tosə fis bʉ̀ʉ sə wèŋ sə mbiŋ pwe'fo'. Yi bɛ' fis mbòoŋ sə bə nsùŋgaaŋ sə wèŋ mʉmvwe' ntòmbi ndap Nwì nə̀ ghaŋ anə. Yi le' bʉsə mak teberə̀ə kupsə̀ mbàam sə wèŋ tu tsətsoŋ, nə kɛ' sɛsə mbàam awo sə sə nze. ");
INSERT INTO yam_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nə dʉk fa ŋgàa sèŋ kəkəbʉ̀ʉŋ sə wèŋ də, <<Wèeŋ tesə bə yu yè'e sə mbiŋ. Wèŋ ka tse' ŋgòbʉ̀sə ndap Tɛ̀' am də a ndap ntɛŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mvə̀'nə̀ yi à cèp vɛ'nə fana ŋgàa fàak ye wèŋ tsərə kok yusə̀ wo à còm yà' ndzənə ŋwàk Nwì də, <<Nsàp mandzə̀ nə̀ mʉ̀ dzəm ndap yònə gʉ vɛ'ɛ co nà'a nə ləsə mʉ.>> ");
INSERT INTO yam_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ fek yi də, <<Nsàp yu nə̀ aco wù gʉ tsok fa vees yè'sə yà, ya vèes riŋ də wù tse' ŋàaŋ sə̀ ŋgògʉ̀ bum sə̀ wù sə gʉ̀ yè'sə ɛ̀?>> ");
INSERT INTO yam_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisòs dʉk fəsə fa wo də, <<Wèeŋ kʉəmsə mak ndap Nwì nə̀ ghaŋ nè'e, ya mʉ nə ci wes nà' mʉnə nùumbu tɛ'.>> ");
INSERT INTO yam_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bʉ̀ʉ Jus wèŋ sə dʉk də, <<Kwɛ'fò, vès à jə lùumŋgòŋ hum kwè-ncòp-ntùŋfu ŋgòci wes ndap nè'e, wù də wu nə ci wes nà' yòmʉnə nùumbu tɛ' ɛ̀?>> ");
INSERT INTO yam_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ànə ye ŋga yi à sə cèp bə gbʉ', nə sə to də ndap yà'sə ni' ye. ");
INSERT INTO yam_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ghà nə̀ yi ànə lokok mvwe' kpʉ fana ŋgàa fàak ye wèŋ tsərə fe'lə yusə̀ yi à cèp sə fana wo dzəm ncèp nə̀ nà'a ndzənə ŋwàk Nwì nə, nə ye bə ncèp nə̀ Jisòs à cèp nə sə̀' də yà'a zìnə. ");
INSERT INTO yam_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ghà nə̀ yi à ye mvwe' lak Jòrosalèm mvə̀k ŋkà'a pasobà sə, bwìŋ à dzəm bohòyi vɛ'ɛ wùriŋ bʉ̀ʉsə̀ wo à yə maŋgəŋgèeŋ sə̀ yi à sə gʉ̀ʉ. ");
INSERT INTO yam_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Megu də Jisòs kà wo ntʉm ye pap fa, bʉ̀ʉsə̀ yi rì wes bwìŋ pwe'fo' yi. ");
INSERT INTO yam_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yi à ka njo mòk də ŋwèe tsok fa yi də ŋwə̀ nè'e vɛ' bə vɛ' tse', bʉ̀ʉsə̀ yi rì wes yusə̀ yà' cu sə ntʉʉ̀ ŋwè pwe'. ");
INSERT INTO yam_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ŋwə̀ə Faràsi mòk à ye, wo to liŋ ye də Nìkòdemù. Yi à ye ŋkwà'ŋwè bohòbʉ̀ʉ Jus wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ŋwə̀ ènə à və̀ nòoŋ bohòJisòs nə̀ ndzəmə̀, nə dʉk fa nà' də, <<Cicà, vès rì tse' də wu yè'e cicà nə̀ wù a və̀ bohòNwì. Bʉsə̀ kaco ŋwè gʉ to nsàap bum maŋgəŋgèeŋ sə̀ wù sə gʉ̀ yè'e yeŋ, tse'ŋga Nwìi bə ŋgə̀ŋgàŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisòs cep bʉsə fa nà' də, <<Mʉ̀ sə tsə̀' wu yè'e zìnə nə̀ nà'a ŋkèm dʉk də, tse'ŋga wo dzə fe'lə ŋwè sə̀mok, ŋkuŋ yi nə kə ye mvwe' gaŋ ŋkum Nwì.>> ");
INSERT INTO yam_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nìkòdemù nə fek fe'lə yi sə̀mok də, <<Aco wo dzə fe'lə ŋwə̀ nə̀ yi gʉ laŋ yè'sə va? Aco yi ni fe'lə lo ndzə və̀ə ma ye, ya wo dzə fe'lə yi nə̀ kɛ̀' ba à?>> ");
INSERT INTO yam_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisòs dʉk fəsə fa yi də, <<Mʉ̀ sə tsə̀' wu zìnə nə̀ nà'a ŋkèm dʉk də, tse'ŋga wo dzə ŋwè bə ndzəp nə ye bə Yòŋsə̀ nə̀ Rərɛŋ nə ŋkuŋ yi kə ni mvwe' gaŋ ŋkum Nwì. ");
INSERT INTO yam_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ŋwə̀ nə̀ wo a dzə yi bə ŋgùpni', a sə̀' nə̀ bə ŋgùpni'. Ŋwə̀ nə̀ wo a dzə yi bə yòŋsə̀ə, a sə̀' nə bə yòŋsə̀. ");
INSERT INTO yam_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kà də wu mərə bʉ̀ʉsə̀ mʉ̀ dʉk wu də, tse'ŋga wo dzə fe'lə ŋwè nə̀ kɛ̀' ba dʉk. ");
INSERT INTO yam_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fə̀fə̀ə càgə̀ mvə̀'nə̀ yi dzəm, wèŋ sə yuk, nə kà mvwe' sə̀ yi sə yèto və̀ə kè mvwe' nə̀ yi sə lòo ŋgòkə̀ lə̀ə rì. Ŋwə̀ nə̀ wo dzə-a yi bə yòŋsə̀ nə fana yà' ye megu bohòyi sə̀' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nìkòdemù nə fek mali nà' də, <<Aco yè'sə ye vɛ'nə yè'sə valɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisòs dʉk fa fe'lə nà' də, <<Wu yè'e cicà nə̀ ghaŋ mvwe' lak Izùrɛ, nə kà bum yè'e rì vɛ'nə va? ");
INSERT INTO yam_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mʉ̀ tsə̀' fa wu zìnə nə̀ nà'a ŋkèm dʉk də, vès sə tsə̀' fa weŋ bum sə̀ vès rì yà', nə ye yà' bə lis avès fana wèŋ kà ves yà' dzəm fa. ");
INSERT INTO yam_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mʉ tsə̀' fa weŋ bum sə̀ yà'a ma sə nze fɛn, wèŋ kà mʉ yà' dzəm fa, ye də mʉ tsə̀'-a weŋ bum sə̀ ma mʉbu wèŋ dzəm fa mʉ à? ");
INSERT INTO yam_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ŋwə̀ nəmòk nə̀ mò'fis ka mʉbu ntòkok lo yuk. Mègù mʉ̀ʉ mo ŋwè nə̀ mʉ̀ à tesə tsooŋ mbwa. ");
INSERT INTO yam_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Yumook də wo nə fis gesə tsoŋ mʉ̀ʉ mo ŋwè mʉtsə̀, mvə̀'nə̀ Musì ànə fis kok no mʉtsə̀ ghà nə̀ wo ànə ye ŋgəà yà'a ŋkuŋ. ");
INSERT INTO yam_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Də ya ŋga a ye-a sə̀ ndà, ŋga nà' dzəm bohòyi fana nà' tse' lùŋ nə̀ nà'a nə̀ kà kə̀ mè yuk. ");
INSERT INTO yam_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","<<Nwì ànə dzəm bʉ̀ʉ sə̀ sənə nzeŋgòŋ nə vɛ'ɛ wù kà fʉ̀k, nə tumsə vesə kwə'rə̀ mo ye də a ye-a sə̀ ndà ŋga nà' dzəm bohòmo ye nə, ŋgə̀ŋgàaŋ nə kà bisə̀, yi nə tse' lùŋ nə̀ nà'a nə̀ kà mè yuk. ");
INSERT INTO yam_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Njo nə̀ Nwì ànə ka mo ye nə də nà'a və nə kə sak bʉp nzeŋgòŋ nə tum və. Yi à tum nà' də ya nzeŋgòŋ nə pwe' nə luŋ bohònà'. ");
INSERT INTO yam_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ŋwə̀ nə̀ yi dzəm-a bohònà', ye də yi ka nzak tse'. Ŋwə̀ nə̀ yi kà-a bohònà' dzəm ye də yi gbʉ̀ nzak tèè, bʉ̀ʉsə̀ yi ka bə liŋ mo Nwì nə̀ yi mègù mò'fis nə dzəm. ");
INSERT INTO yam_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mvə̀'nə̀ wo sak lə̀sə tes nzak nə də vɛ'. Də marɛŋ a və̀ sənə nzeŋgòŋ nə, bwìŋ dzəm megu ndzəm nə noŋsə marɛŋ nə. Wo gʉ̀ vɛ'nə bʉ̀ʉsə̀ bum sə̀ wo sə gʉ̀ʉ sə bʉp. ");
INSERT INTO yam_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bʉsə̀ ŋwə̀ nə̀ yi gʉ̀gə̀-a ye bʉp, yi kà ŋge' bə marɛŋ yegə̀. Yi sə caŋ marɛŋ caa. Njo nə̀ yi sə wəp də aco bwìŋ ye yusə̀ yi sə gʉ̀ʉ sə. ");
INSERT INTO yam_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ŋwə̀ nə̀ yi gʉ̀gə̀ ye yusə̀ yà'a zìnə tesə və̀gə̀ ye sə mvwe' marɛŋ. Yi tesə və̀gə̀ vɛ'nə də ya bwìŋ ye jəja kwaraŋgaŋ də yusə̀ yi gʉ̀ yà'sə, a bə mandzə̀ Nwì.>> ");
INSERT INTO yam_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yè'sə ànə ca fana Jisòs bə ŋgàa fàak ye wèŋ lo mok mvwe' lak Jùdiyà. Yi bə yà'wèŋ à kə̀ cu mam fo', nə sə baptɛsə bwìŋ fo'. ");
INSERT INTO yam_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon à sə bàptɛsə bwìŋ ye sə̀' mvwe' mok sə̀ wo to fo' də Anòn, mvwe' sə kʉəp lòlak Salèm. Yi à sə bàptɛsə fo' bʉ̀ʉsə̀ ndzəp à ye fo' ŋkʉ̀ʉŋntɛ̀ŋ. Bwìŋ à sə və̀ə, nə sə kə baptɛsə fo'. ");
INSERT INTO yam_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yè'sə ànə ye ŋga wo ka Jon nə ndapndzəm ntòko nisə. ");
INSERT INTO yam_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ànə geŋ, ŋgàa fàak Jon bə ŋwə̀ə Jus mòk wèŋ yèto ŋgòsə fenə bə mandzə̀ nə̀ wo cùk rɛŋsəgə̀ ni' ŋgòbɛ' mandzə̀ Nwì. ");
INSERT INTO yam_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Fana wo və bohòJon, nə kə dʉk fa nà' də, <<Cicà, wù sə tsərə tse' malì ŋwə̀ nə̀ weŋnə à ye mvwe' ŋgʉ ndzəp Jòridàŋ fa' nà'a nà? Yi nə̀ wù sə tsòho fa bwìŋ bə liŋ ye nà'a, yi sə bàptɛsə sə̀' fana bwìŋ sə kpəəŋ lòwes mok bohòyi.>> ");
INSERT INTO yam_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon nə cep fəsə fa yà'wèŋ də, <<Kaco ŋwè tse' to yumok bə bo ye yeŋ. Tse'ŋga Nwì mʉbu fa yi yà' yi ŋkuŋ yi tse' yà'. ");
INSERT INTO yam_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Wèŋ à yuk fa mʉ bə ntu'u awèŋ laŋ mvə̀'nə̀ mʉ̀ à sə dʉk də, mʉ̀ ka yè'sə Ŋkum ŋgà gèm bwìŋ nə mʉ̀ yeŋ. Mʉ̀ mègù yàm ŋwə̀ nə̀ wo a tumsə lòmʉ yàm də mʉ lo tse' mantombìi Krɛst nə. ");
INSERT INTO yam_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Wèŋ rì də ŋwə̀ nə̀ yi tse' ŋgwegù a ndugù nə. Ŋge'e ndugù nə təəŋ kok ŋgʉ ni'ì nà', nə sə kwa wùriŋ mvə̀'nə̀ yi sə yuk ŋgì ndugù nə sə. Yà'a sə̀' mvə̀'nə̀ kwəkwa nə̀ njàm rwiŋ wesə mʉ ŋga'a sə̀' dak. ");
INSERT INTO yam_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A kə̀kʉrə̀ də yi nə sə lo tsoŋ mantombì, mantombì, fana mʉ̀ sə foho lo tsoŋ yàm ma ŋkwɛ̀ŋ, ma ŋkwɛ̀ŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yà' mègù sə̀' də yi nə̀ yi tsə ma mʉtsə̀ə ŋwə̀ nə̀ ghaŋ nə yi. Yi nə̀ yi ŋwə̀ə nzeŋgòoŋ, nzeŋgòŋ nə tse' yi yi, fana yi sə cep megu bə bum sə̀ sə nzeŋgòŋ fɛŋ. Yi nə̀ yi və̀ ye mʉbu nə gha' ndàaŋwè pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yi cèpgə̀ bum sə̀ yi a yə yà' bə lis ye, nə yuk bə ntu'u ye, ŋwə̀ nə̀ mò'fis kà ncèp ye nə dzəm lo' fʉ̀'. ");
INSERT INTO yam_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ŋwə̀ nə̀ yi dzəm-a ncèp ye nə fana yi sə nìtsə̀' fa bwìŋ bə zeŋ yà'sə də Nwìi zìnə. ");
INSERT INTO yam_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","A vɛ'nə bʉ̀ʉsə̀ ŋwə̀ nə̀ Nwì a tumsə və̀ yi nə sə tsòho ncèp nə̀ Nwì. Nwìi fagə̀ yi Yòŋsə̀ nə co wù kà fʉ̀' to. ");
INSERT INTO yam_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tɛ̀' nə dzəm mo ye nə, nə fa wes bum pwe' ndzə bohònà'. ");
INSERT INTO yam_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ŋwə̀ nə̀ yi dzəm-a bohòmo ye nə fana ye də ŋgə̀ŋgàŋ tse' lùŋ nə̀ nà'a nə̀ kà kə̀ mè yuk. Ŋwə̀ nə̀ yi kà-a mo ye nə yuk, yi nə kà lùŋ bə lis yə yuk. Ma nə̀ nje də, jə̀jòk nə̀ nà' cu sə ntʉʉ̀ Nwì naaŋ mʉtuhù ŋwə̀ ànə. ");
INSERT INTO yam_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tà Jisòs à rì də bʉ̀ʉ Faràsi wèŋ yuk də yi bàptɛsə ghak bwìŋ yi nə noŋsə Jon. ");
INSERT INTO yam_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jisòs à sə kà yi bə bo ye bàptɛsə̀. À sə bàptɛsə ŋgàa fàak ye wèŋ.) ");
INSERT INTO yam_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","À ye vɛ'nə, yi ye'e me'rə Jùdiyà anə, nə bwi lo mvwe' nzeŋgòŋ Galìli. ");
INSERT INTO yam_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yi à cu ŋgòlòo, yà' ye də yi nə bɛ' tsoŋ li lɛ mandzə̀ nə̀ nà'a càgə̀ mvwe' nzeŋgòŋ Sàmàriyà nà'a. ");
INSERT INTO yam_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ànə geŋ yi gi ca mvwe' nze Sàmàriyà anə fana yi kə dzeŋ mvwe' mʉbuk lak mòk. Wo to fo' də Sekà. Mʉmvwe' ànə à kʉəp mvwe' nzum sə̀ Jàkop ànə fa fo' bohòmo ye Jòsep njamòk, njamòk. ");
INSERT INTO yam_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ndzəp nə̀ Jàkop nə à tu nà' sə nze, nə sə tuk, à ye sə̀' mʉmvwe' ànə. Jisòs à kə̀ dzèŋ fo' ŋga yi wòbə gì. Yi cum tsoŋ fo' sə nze ŋgʉ ndzəp anə. Ànə ye ŋga nùum co maràŋ. ");
INSERT INTO yam_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ŋwà Sàmàriyà mòk tesə və də yi kə tuk ndzəp. Jisòs dʉk fa nà' də nà'a fa yi ndzəp yi no. ");
INSERT INTO yam_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ànə ye yè'sə ŋga ŋgàa fàak ye sə wèŋ à lòwes ndzə ntòlak ŋgòkə̀ ywi və̀ zʉzʉ. Yi sə cum yòŋsə fo' yiìyi. ");
INSERT INTO yam_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ŋwà Sàmàriyà nə vehe də wete, nə də, <<Ye va ŋkuŋ wù ye yòŋwə̀ə Jus, nə sə fek mʉ ŋwà Sàmàriyà də mʉ fa wu ndzəp-ɛ?>> Yi à sə fek vɛ'nə bʉ̀ʉsə̀ bʉ̀ʉ Jus wèeŋ kà ŋge' bə bʉ̀ʉ Sàmàriyà wèŋ yegə̀. ");
INSERT INTO yam_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisòs dʉk fa ŋwà nə də, <<Anə ye-a də wù riŋ yusə̀ aco Nwì fa yà', nə riŋ ŋwə̀ nə̀ yi sə lɛŋ ndzəp bohòwù ènə, bwɛ̀rɛ wù fek yi də yi fa wu ndzəp. Ya yi fa wu ndzəp nə̀ nà' tse' lùŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ŋwà nə dʉk fa nà' də, <<Tɛ̀'mòk, wù ka yu tuk ndzəp fa'nə tse'. Ndzəp nə nə yeè nə ca sə̀' cəco mwè, ye də wu nə jəŋ ndzəp nə̀ nà' tse' lùŋ ènə ma fò? ");
INSERT INTO yam_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wù sə də, wu dʉk də wù gha' tàcici àvès Jàkop nə̀ yi à fa ves ndzəp ènə, nə no ye nà' sə̀' nà'a nà? Bwe ye bə mbòoŋ ye wèŋ pwe' à sə no sə̀' ndzəp ènə.>> ");
INSERT INTO yam_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisòs nə dʉk fəsə fa nà' də, <<Ŋwə̀ nə̀ yi no-a ndzəp ènə pwe'fo', njè ndzəp nə sə yaŋ fe'lə mali yi sə̀mok. ");
INSERT INTO yam_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ŋwə̀ nə̀ yi no-a ye ndzəp nə̀ mʉ̀ fa yi nà' mʉ̀ fana njè ndzəp nə kà yi mok ya yuk fe'lə̀. Ndzəp nə̀ mʉ̀ fa yi nə nə bʉʉŋ ndzə ni'ì yi co ndzəp nə̀ nà' sə to tesə kok sə nze. Nà'a sə tesə vɛ'nə, nà' ye mok lùŋ nə̀ nà'a nə̀ kà mè yuk.>> ");
INSERT INTO yam_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ŋwà nə də, <<Tɛ̀'mòk fa mʉ-a nsàp ndzəp ànə mʉ no, ya njè ndzəp kà mʉ mok ya yuk, nə ye sə̀' də ya kà də mʉ sə ye ŋgə' də mʉ̀ sə və̀hə fɛŋ ŋgòkə̀ tuk fe'lə ndzəp mok sə̀' dʉk.>> ");
INSERT INTO yam_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisòs dʉk fa fe'lə nà' də, <<Dù kə̀ to ndu yò, ya wenə və.>> ");
INSERT INTO yam_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ŋwà nə də, <<Mʉ̀ ka ndum tse'.>> Jisòs də, <<A zìnə mvə̀'nə̀ wù cèp də wù ka ndum tse' yà'sə. ");
INSERT INTO yam_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mʉ̀ dʉk vɛ'nə bʉ̀ʉsə̀ wù ànə tse' to me ndum tàŋ laŋ. Nə̀ wenə cu ŋga'a nè'e ka ndu yòsə̀' yeŋ. Ye də yusə̀ wù cèp sə a zìnə.>> ");
INSERT INTO yam_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ŋwà nə dʉk də, <<Tɛ̀'mòk, mʉ̀ yə co də wu yè'sə ŋgà tsòhòbum Nwì. ");
INSERT INTO yam_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tàcicii avès wèŋ à sə kùksəgə̀ Nwì mʉmvwe' nda nè'e fana wèŋ bʉ̀ʉ Jus wèŋ sə dʉk yàwèŋ də anə ye co bwìŋ kuksə Nwì mvwe' lak Jòrosalèm ɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisòs dʉk fa fe'lə nà' də, <<Njɛ̀'gù, mʉ tsok fa wu yusə̀ zìnə də, mvə̀k sə və̀ə nə̀ bwìiŋ nə kà Tɛ̀' nə mʉ ndahà fɛŋ kè mvwe' lak Jòrosalèm àlɛ' mok sə kùksə̀ fe'lə̀. ");
INSERT INTO yam_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Wèeŋ kùksəgə̀ yusə̀ wèŋ ka bə zeŋ rɛɛŋ. Vès sə kùksə yàvès yusə̀ vès rɛɛŋ bə zeŋ laŋ bʉ̀ʉsə̀ Nwìi nə tɛsə bwìŋ sə nzeŋgòŋ fɛɛŋ ndzə bohòvès bʉ̀ʉ Jus wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mvə̀k sə və̀ə, aco mʉ̀ dʉk də mvə̀k nə kə̀ dzèŋ laŋ, nə̀ bwìiŋ nə sə kuksə Tɛ̀' nə bə zìnə, nə sə kuksə yi ndzənə yòŋsə̀ sə̀'. Tɛ̀' nə dzəm də nsàp bʉ̀ ànə wèeŋ kùksə yi. ");
INSERT INTO yam_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nwì nə, yi yè'sə yòŋsə̀. Yi fagə̀ bwìŋ yòŋsə̀ yi. Ye də bʉ̀ʉ sə̀ wo dzəm-a ŋgòkùksə yi, wo kuksə yi ndzənə yòŋsə̀ nə ye bə zìnə àwo pwe'.>> ");
INSERT INTO yam_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ŋwà nə dʉk də, <<Mʉ̀ rì də Ŋkum ŋgà gèm bwìŋ nə̀ Nwì à dʉk də yi nə̀ tum və̀ nà' nə, nə və ntsə'mòk. Mʉ̀ sə dʉk yi nə̀ wo togə̀ yi mok sə̀' də Krɛst nà'a. Yi və̀ə, yi nə niŋtsok fa ves bum lòoŋ fo'.>> ");
INSERT INTO yam_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisòs dʉk fa ŋwà nə də, <<Mʉ̀ nə̀ mʉ̀ sə cèp bohòwù ènə, mʉ yi nə.>> ");
INSERT INTO yam_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ŋgàa fàak Jisòs sə wèŋ à bwìŋ foho və̀ sə̀' ghà nà'nə. Wo mərə vɛ'ɛ wùriŋ də nà' sə cèp bə ŋwàŋwè. Nə̀ mò'fis kà ŋwà nə də, nà' dzəm fɛɛŋ yàlɛ sə fek. Nə kà Jisòs də yi sə cèp bə ŋwà ènə bʉ̀ʉ yàlɛ sə̀' fek lok. ");
INSERT INTO yam_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ànə geŋ, ŋwà nə me'rə tes kʉ̀ʉŋ ndzəp ye sə fo', nə lo ndzə ntòlak. Yi à kə̀ dzèeŋ, yi tsoho fa bwìŋ də, ");
INSERT INTO yam_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","<<Wèeŋ və, nə kə ye yàwèeŋ ŋwə̀ nəmòk nə̀ yi taŋsə tsə̀' wes fa mʉ bum sə̀ wo à dzə mʉ dzəə, mʉ̀ gʉ vɛ'ɛ pwe' nə̀ pwe' ɛ̀. Kàmòk yi ŋgwàaŋ Ŋkum ŋgà gèm bwìŋ nə̀ wo dʉkgə̀ də yi nə̀ və̀ə nə àlɛ'.>> ");
INSERT INTO yam_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wo à yuk vɛ'nə, wo tesə mʉ ntòlak anə, nə kə ye Jisòs. ");
INSERT INTO yam_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ànə ye sə̀' ŋga ŋgàa fàak ye sə wèŋ sə dʉk fa yi də, <<Cicà, zʉ-a yumok le.>> ");
INSERT INTO yam_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yi dʉk fa yà' ye də, <<Mʉ̀ tse' bɛŋ yàm sə̀ ŋgòzʉ yo sə̀ wèŋ ka bə zeŋ riŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ŋgàa fàak ye wèŋ sə ye ŋgòfe'rə mʉtsətsə'rəə wo də, <<Ŋwə̀ nəmòk jə və̀ fa yi bɛŋ à?>> ");
INSERT INTO yam_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisòs nə dʉk fa wo də, <<Bɛŋ aam ŋgògʉ̀ fàak sə̀ ŋwə̀ nə̀ yi à tum mʉ nə dzəm də mʉ gʉ. Nə gʉ wes fàak yà'sə. ");
INSERT INTO yam_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Wèeŋ cèpgə̀ ncèp mòk də, <Bwehe cu ŋwʉ kwè ya bum sə̀ wo bì mʉ nzuù yà'a kʉrə ŋgòkʉp.> Mʉ̀ sə tsə̀' weŋ yàm də wèeŋ bʉʉŋ kʉk ja'a yàwèeŋ, nzum sə ŋga'a yè'sə mvə̀k kəkʉp. ");
INSERT INTO yam_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ŋwə̀ nə̀ yi kʉpgə̀ə wo lak yi yèto fàak ye laŋ. Yi sə benə ŋgwìi bum sə̀ yà'a bwìŋ ya wo nə kə tse' lùŋ nə̀ nà'a nə̀ kà mè yuk nə. Ya ŋga ŋwə̀ nə̀ yi à bìi bə nə̀ yi à kʉp ye kʉpə ba fo' nə kwa mvwe' mò'fis. ");
INSERT INTO yam_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yà'sə sə nìtsə̀' də ncèp nə̀ wo cèpgə̀ nà' də, Mòok bìgə̀ ye bìi, mòk kə kʉp ye kʉpə, nà'a zìnə. ");
INSERT INTO yam_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mʉ̀ a tumsə lòweŋ ŋgòkə̀ kʉp bum sə̀ wèŋ à ka fàk. À fàk bʉ̀ʉ sə̀ zok, wèŋ nə kə̀ kʉʉ̀p nə yàwèŋ kʉpə. Wèŋ zʉ yà'sə swek mʉtuhù bʉ̀ʉ mok.>> ");
INSERT INTO yam_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bʉ̀ʉ Sàmàriyà sə̀ mvwe' ntòlak ànə à dzəm bohòyi vɛ'ɛ wùriŋ njo ncèp nə̀ ŋwà nà'a ànə cep fa' də, <<Yi taŋsə tsə̀' wes fa mʉ bum sə̀ wo à dzə mʉ dzəə, mʉ̀ gʉ pwe' nə̀ pwe'>> nà'a. ");
INSERT INTO yam_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bʉ̀ʉ Sàmàriyà sə wèŋ à kə̀ tsèŋ yi, wo ŋwɛ' tse' yi cʉ̀k də nà'a kà ntòlò, də bə yà'wèeŋ cum la'à wo anə ŋkuŋ. Anə geŋ, Jisòs nə cum fo' nùumbu ba. ");
INSERT INTO yam_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mok à dzəm fe'lə bohòyi ŋkʉ̀ʉŋ sə̀mok bʉ̀ʉ bum sə̀ yi sə cèep. ");
INSERT INTO yam_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wo dʉk fa ŋwà nə də, <<Vès sə kà yè'sə mok bʉ̀ʉ ncèp nə̀ wù tsə̀' ves wù nə dzəm mègù. A yè'sə mok bʉ̀ʉsə̀ vès yuk bə ntu'u yàvès, vès nə rì nə də nè'e gù tsə gù yi nə̀ ŋgà lùŋsə̀ nzeŋgòŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nùumbu sə̀ ba sə à càa, yi lo yuye mvwe' nzeŋgòŋ Galìli nə̀ a fo' lak ye. ");
INSERT INTO yam_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisòs nə bə tu ye à sə cèp fis də wo kà ŋgà tsòhòbum Nwì mvwe' lak ye sə̀ wo à dzə yi fo' co ŋwə̀ nə̀ ghaŋ jəgə̀. ");
INSERT INTO yam_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yi à rì vɛ'nə, nə sə lo mali fo'. À kə̀ dzèŋ Galìli anə, bʉ̀ʉ sə̀ fo' sə wèŋ kwa ŋgòyə yi vɛ'ɛ wùriŋ. Wo à gʉ̀ vɛ'nə bʉ̀ʉsə̀ wo ànə lo mvwe' ŋkà' Pasobà nə̀ nà' à ye mvwe' lak Jòrosalèm, nə ye bum sə̀ Jisòs nə à sə gʉ̀ fo' bə lis awo. ");
INSERT INTO yam_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ànə geŋ Jisòs bwi foho lo fe'lə mvwe' lak Kanà nə̀ mvwe' nzeŋgòŋ Galìli, sə̀ mvwe' sə̀ yi à gʉ̀ ndzəp yà' bʉʉŋ rùk sə. Ŋgà fàk gomè mòk à ye fo' nə̀ ghaŋ, ŋga yi cugə̀ mvwe' lak Kàpanùm. Ghà ànə à ye ŋga mo ye nə̀ ŋwə̀mbam nòbə yiyaŋ nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yi ànə yuk də Jisòs mè'rə və̀ Jùdiyà, nə və̀ nə mvwe' nze Galìli fana yi lo, nə kə tseŋ Jisòs nə. Yi sə lɛŋ nà' də bə nà'a lo Kàpanùm mvwe' sə̀ yi cugə̀ə, ya nà'a kə gʉŋsə fa yi mo ye. Ànə ye ŋga mo ye nòvɛ'ɛ mvə̀k kpʉkpʉ. ");
INSERT INTO yam_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisòs dʉk fa nà' də, <<Wèeŋ kà-a yàwèŋ maŋgəŋgèŋ bə lis yə, kaco wèŋ dzəm bohòmʉ̀ yeŋ. Ka vɛ'nə yeŋ à?>> ");
INSERT INTO yam_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ŋgà fàk nə dʉk ye də, <<Tɛ̀'mòk, a lo-a ntɛ̀ŋ na, bwɛ̀rɛ mo àm nə nə kpʉ.>> ");
INSERT INTO yam_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisòs dʉk fa nà' də, <<Dù lo yuyo. Mo yònə gʉ laŋ.>> Ŋgà' nə à dzəm ncèp nə̀ Jisòs cèp fa yi nə, nə bɛ' mandzə̀ ye lo. ");
INSERT INTO yam_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yi à sə lòmandzə̀, yi kʉrə bə ŋgàa fàak sə̀ wo fàkgə̀ bohòyi. Wo tsok fa yi də mo ye nə gʉ laŋ. ");
INSERT INTO yam_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yi fek yà' də, mo nə a lòkok yiya nə ŋga nùum ma fòlɛ. Wo dʉk fa yi də, <<A ye ŋkwìs ŋga nùum maràŋ kaŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tɛ̀' nə tsərə fəsə, nə riŋ də mvə̀k nə̀ wo tsə̀' yi ànə, mègù sə̀' mvə̀k nə̀ Jisòs a dʉk fa yi də, <<Dù lo yuyo. Mo yònə gʉ laŋ>> nə. Ànə geŋ yi dzəm bohòJisòs bə ndap ye pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nè'e ŋga'a maŋgəŋgèŋ nə̀ ba, nə̀ Jisòs à gʉ̀ʉ mvə̀'nə̀ yi ànə me'rə Jùdiyà, nə və mvwe' nzeŋgòŋ Galìli. ");
INSERT INTO yam_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yà'sə ànə me wes fana mvə̀k kʉrə fe'lə nə̀ bʉ̀ʉ Jus wèŋ à tse' ŋkà' mòk Jòrosalèm anə sə̀mok. Jisòs à kok lòmʉ Jòrosalèm anə ye sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Wo à tu nòŋsə tə̀m mòk fo' mvwe' ncùu ŋka' sə̀ nsùŋgaaŋ càgə̀ fo'. Bʉ̀ʉ Hibrù wèeŋ togə̀ tə̀m nə bə ncèep lak awo də, Bèzatà. Wo à ci tes mvwe' mok co mbàndap bòp tàŋ ya bwìiŋ sə caŋ cum nùm fo'. ");
INSERT INTO yam_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ŋgàa yiyaŋ wèŋ à sə nòoŋ fo'. Mok à ye ŋgàa jì lis, mok sə̀ kaco wo gi to yeŋ nə ye bə sə̀ wo à kpʉ yum bo wèŋ. (Wo à sə nòoŋ fo' ŋgòtək ghà nə̀ tə̀m nə nə tsoho. ");
INSERT INTO yam_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bʉsə̀ masinjà Tà Nwì à sə və̀gə̀ fo' ŋga mvə̀k kʉ̀rə, nə gʉ ndzəp nə nà' tsoho. Ghà nə̀ yi tsə̀'rə wes nà' vɛ'nə fana ŋwə̀ nə̀ yi ni lòto-a ca yi, a dzəm ŋga yi tse' nsàp yiya nə̀ fòpwe'fo', nà' me.) ");
INSERT INTO yam_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ŋwə̀ nəmòk à ye fo' nə̀ yi à ye bə yiyaŋ mʉnə lùumŋgòŋ hum tɛ'-ncòp-fwame'. ");
INSERT INTO yam_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Fana Jisòs à dzèŋ fo', yi ye ŋga nà' nòo. Yi riŋ sə̀' də nà' à yə ŋgə' bə yiya nə lùumŋgòŋ wùriŋ fana yi fek nà' də, <<Wù sə dzəm də yiya yòènə me à?>> ");
INSERT INTO yam_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ŋgà' nə dʉk də, <<Tɛ̀'mòk, mʉ̀ ka ŋwə̀ nə̀ co ndzəp nə tsòho wes fana yi le' so gesə mʉ ca tse'. Mʉ dʉkgə̀ də mʉ dap lokok kə ni ca ŋga ŋwə̀ nəmòk kə ni to ca laŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisòs dʉk fa nà' də, <<Lòkok mʉtsə̀, nə lim kəà yò, nə lo.>> ");
INSERT INTO yam_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jisòs ànə cep vɛ'nə ntɛ̀ŋ, ŋgà' nə gʉŋ sə̀' ghà ànə. Yi à lòkok, nə te' lim kəà ye, nə bɛ' mandzə̀ lo yuye. Nùmbu nə̀ Jisòs ànə gʉŋsə ŋwə̀ ànə bə yiyaŋ ènə ànə ye nùmbu dzə̀. ");
INSERT INTO yam_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Fana ŋkwàha bʉ̀ʉ Jus wèŋ à gèŋ də wo ye ŋwə̀ ènə ŋga yi kotse' kəà ye, nə sə gi bə zeŋ fana wo vehe. Wo fek dʉk də, <<Wù ka riŋ də a ntinə nùmbu dzə̀ à? Nsàp yu nə̀ wù gʉ̀ʉ ŋgòbə̀' tse' kɛ' kəà ntinə ènə, lʉ̀k ka bə zeŋ dzəm lok.>> ");
INSERT INTO yam_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ŋwə̀ nə̀ yiya ye à mè nə dʉk fa wo də, <<Ŋwə̀ nə̀ yi anə gʉ ŋkuŋ mʉ̀ gʉŋ nə, nə dʉk fa mʉ yi də mʉ lim jəŋ kəà àm, nə lo bə zeŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wo fek fe'lə nà' sə̀mok də, <<Cèp nsàp ŋgwì yu ànə ndà, də wu lim gi bə kəà ntinə-ɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ŋgà' nə kà ŋwə̀ nə̀ nà' ànə gʉ ŋkuŋ yiya ye me nə rì bʉ̀ʉsə̀ Jisòs nə à ni bisə lòmʉtsətsə'rəə bʉ̀ʉ sə̀ wo mà fo' wùriŋ sə laŋ. ");
INSERT INTO yam_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ànə sap kok fana Jisòs tseŋ ŋwə̀ nə̀ yi ànə gʉŋsə nà' nə mʉmvwe' ndap Nwì nə̀ ghaŋ nə. Yi to nà', nə dʉk fa nà' də, <<Yeè, yiya yònə mè laŋ fana mʉ̀ də mʉ tsok wu də wu jəŋ ŋkərə̀ də wu kà bʉp mok gʉ̀ fe'lə̀, ya ŋgə' nə̀ nà' yam càsə yiya yòànə kà wu mok kə̀ tsèŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ŋgà' nə à bwì foho lò, nə kə tseŋ bʉ̀ ŋkwàha bʉ̀ʉ Jus sə wèŋ, nə tsok wo də liŋ ŋwə̀ nə̀ nà' anə gʉŋsə yi nə də Jisòs. ");
INSERT INTO yam_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yà'a bum sə̀ yà' à gʉ̀ ŋkuŋ bʉ̀ ŋkwàha bʉ̀ʉ Jus sə wèŋ ye ŋga'a ŋgòsə fa kɛ' cà Jisòs ŋgə' də nà' sə gʉŋsə kɛ' bwìŋ nùumbu dzə̀. ");
INSERT INTO yam_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yusə̀ Jisòs à tsə̀' fa bʉ̀ʉ Jus sə wèŋ bə ncèp ènə à ye də, <<Tɛ̀' am fàkgə̀, nə kà dzə̀ jə fana mʉ̀ tse' ŋgòfàk yàm sə̀' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Wo ànə yuk mvə̀'nə̀ Jisòs dʉk vɛ'nə fana bʉ̀ ŋkwàha bʉ̀ʉ Jus sə wèŋ lap ghaha wesə mandzə̀ nə̀ ŋgòzə yi nə ghaha. Wo à gʉ̀ vɛ'nə bʉ̀ʉsə̀ wo à dʉk də, nà' gʉ̀ bʉpsə lʉ̀ʉk awo sə̀ ŋgònòŋsə nùmbu dzə̀, nə ye sə̀' də nà' to Nwì də Tɛ̀'ɛ nà'. Ye də nà' sə fʉhʉ ni' nà' bə Nwì də bə nà'a yəyərə̀. ");
INSERT INTO yam_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisòs ànə cep fəsə fa bʉ̀ʉ yè'sə wèŋ də, <<Mʉ̀ sə tsə̀' weŋ yè'e zìnə nə̀ nà'a ŋkèm ncèp də, kaco Mo Nwì nə gʉ yumok bə tu ye yeŋ. Yi gʉ̀ mègù yusə̀ yi yə ŋga Tɛ̀' ye nə sə gʉʉ. Bʉsə̀ yusə̀ Tɛ̀' sə gʉ̀ pwe'fo', Mo ye nə nə gʉ sə̀' zeŋ. ");
INSERT INTO yam_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tɛ̀' nə dzəm Mo ye nə, nə sə niŋ fa nà' bum sə̀ yi Tɛ̀' nə sə gʉ̀ yà' lòoŋ fo'. Yi nə tsoho fa mali nà' bum sə̀ ghaŋ sə̀ yà' yam càsə sə̀ wèŋ yə laŋ sə. Bum yà'sə nə ye nsàp nə̀ wèeŋ nə sɛɛŋ yà' tə̀tè, nə wo. ");
INSERT INTO yam_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mvə̀'nə̀ Tɛ̀' nə lòkoksəgə̀ bwìŋ mvwe' kpʉ, nə fa wo lùŋ nə̀ zìnə nə fana Mo ye nə mègù sə̀' vɛ'nə. Yi fagə̀ lùŋ nə̀ zìnə nə bohòndàaŋwè pwe' nə̀ yà' bòyi də yi fa nà'. ");
INSERT INTO yam_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nə ye sə̀' də bə ma nə̀ ŋgòsak bwìŋ, Tɛ̀' nə kà yi sakgə̀. Yi a fa ŋàaŋ sə ndzə bohòMo ye nə, də anə sak bwi nà' ŋgòrì də ŋwə̀ nè'e nə cum, nè'e nə kpʉ. ");
INSERT INTO yam_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Yi ànə gʉ vɛ'nə də ya bwìŋ pwe' wəp Mwe nə sə̀' mʉmvə̀'nə̀ wo wəpgə̀ Tɛ̀' nə yà'a. A ye-a ŋga ŋwə̀ nəmòk sə kà Mwe nə wəp, ye də yi sə kà wəp yà'sə Tɛ̀' nə̀ yi ànə tumsə vesə Mo ye sə nzeŋgòŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","<<Mʉ̀ sə tsə̀' weŋ yè'e ŋkèm ncèp nə̀ nà'a zìnə də, a ye-a ŋga ŋwè yuk yusə̀ mʉ̀ sə cèep, nə dzəm bohòŋwə̀ nə̀ yi a tum mʉ nə fana ye də ŋgə̀ŋgàŋ tse' lùŋ nə̀ nà'a nə̀ kà kə̀ mè yuk. Wo nə kà yi mok kə̀ sak, bʉ̀ʉsə̀ yi a càsə mvwe' kpʉ, nə to tesə və mvwe' lùŋ laŋ. ");
INSERT INTO yam_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mʉ̀ sə tsə̀' weŋ yè'e sə̀' ŋkèm ncèp mòk də mvə̀k sə vəə, aco mʉ̀ dʉk də mvə̀k nə kə dzeŋ laŋ, nə̀ bʉ̀ kpʉkpʉ wèeŋ nə yuk ŋgì Mo Nwì. Bʉ̀ʉ sə̀ wo yuk ŋgì ànə, nə tse' lùŋ. ");
INSERT INTO yam_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mvə̀'nə̀ Tɛ̀' nə tse' lùŋ ŋgòfa bwìŋ fana yi a fa mʉ̀ʉ Mo ye nə ŋàaŋ sə̀ ŋgòfa bwìŋ lùŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yi a fa ŋàaŋ sə̀ ŋgòsak bwìŋ sə̀' ndzə bohòMo ye nə, bʉ̀ʉsə̀ a yi ŋwə̀ nə̀ wo togə̀ liŋ ye də Mo ŋwè nə. ");
INSERT INTO yam_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kà də wèeŋ mərə bə bum yè'sə dʉk. Mvə̀k sə kʉəp və̀ə nə̀ bʉ̀ kpʉkpʉ wèeŋ nə yuk ŋgì ye nə. ");
INSERT INTO yam_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Wo yuk nà', wo tesə kok sə mvwe' sè awo sə. Bʉ̀ʉ sə̀ wo ànə gʉ bə̀boŋ wèŋ lokok ŋgòtse' lùŋ nə̀ zìnə nə, sə̀ wo à gʉ̀ yàwo bʉp wèŋ lokok və ya wo sak wo bə bʉp awo sə fana wo ye ŋgə'.>> ");
INSERT INTO yam_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jisòs nə à sə cèp malì mok sə̀' də, <<Kaco mʉ̀ gʉ fʉk yumok bə tu am yeŋ lok, mʉ gʉ mègù yusə̀ ŋwə̀ nə̀ yi à tum mʉ nə dʉk mʉ vɛ'nə. Mʉ sakgə̀ yàm mvə̀'nə̀ yi dʉk yi. Ye də mʉ̀ kà bə jòŋ sə sak bʉ̀ʉsə̀ mʉ̀ sə kà yusə̀ də ya yà'a ye bə̀boŋ bohòmʉ̀ gʉ̀. Mʉ̀ sə gʉ̀ yàm yusə̀ yà'a ye bə̀boŋ bohòŋwə̀ nə yi a tumsə və̀ mʉ nə. ");
INSERT INTO yam_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","<<A ye-a də mʉ̀ sə təəŋ fa ni' àm gèm fana bwìŋ kà də yusə̀ mʉ̀ sə cèp sə zìnə tsərə̀. ");
INSERT INTO yam_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yusə də ŋwə̀ nəmòk nə̀ zook yo nə̀ yi sə cèp bə tu am sə yi. Mʉ̀ rì sə̀' də yusə̀ yi sə cèp bə tu am sə zìnə. ");
INSERT INTO yam_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ma nə̀ bohòwèŋ yàwèŋ, wèŋ ànə tumsə lo bwìŋ fa' bohòŋwə̀ nə̀ wo à sə to yi də Jon nà'a, də yi rɛŋsə weŋ bə liŋ am yè'sə. Ànə geŋ yi tsok rɛŋsə fa weŋ zìnə nə sə̀' laŋ. ");
INSERT INTO yam_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bohòmʉ̀ yàm, mʉ̀ sə kà ŋwè də yi təəŋ fa mʉ ŋgònìtsə̀' də mʉ ŋwə̀ nə̀ zìnə làp. Mʉ̀ sə cèp, nə sə kum gesə lo bə bum sə̀ Jon ànə cep bə liŋ am də ya wèeŋ tse' lùŋ. ");
INSERT INTO yam_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon à ye laàm nə̀ nà' sə kʉə rɛɛŋ vɛ'ɛ njàaŋ. Wèŋ à dzəm ncèp ye nə mʉnə mvə̀k momjo vɛ'ɛ, nə sə kwa bə marɛŋ nə̀ yi ànə fa weŋ nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bum mok cu sə̀ yà' sə nìtsə̀' fa bwìŋ nsàp ŋwə̀ nə̀ mʉ̀ cu nə, sə̀ yà' gʉ ghak bum sə̀ Jon ànə cep bə tu am. Fàak sə̀ Tɛ̀' am a fa mʉ ŋàŋ də mʉ gʉ yà' sə, yà' sə nìtsə̀' fa bwìŋ vɛ'ɛ jəja kwaraŋgaŋ də Tɛ̀' am nə a tumsə və̀ mʉ yi. ");
INSERT INTO yam_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tɛ̀' am nə̀ yi à tum mʉ nə a cèp bum mok bə liŋ am, nə̀ mʉ Mo ye nə̀ yi à tum nə. Wèŋ ka ŋgì ye bə ntu' awèŋ yuk yuk, nə kà si ye bə lis sə̀' yə yuk. ");
INSERT INTO yam_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Fana mòk ye sə̀' də wèŋ kà ncèp ye nə sə ntʉʉ̀ wèŋ sə̀' ko nòŋsə̀. Mʉ̀ sə dʉk vɛ'nə bʉ̀ʉsə̀ wèŋ ka bohòMo ye nə̀ yi tum və̀ nà' nə dzəm. ");
INSERT INTO yam_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Wèeŋ ta ja'agə̀ ŋwàk Nwì nə nùumbu pwe'fo' bʉ̀ʉsə̀ wèŋ rì də aco ŋwàk ènə niŋtsok fa weŋ mandzə̀ nə̀ ŋgòkə̀ tse' lùŋ nə̀ zìnə nə̀ nà'a nə̀ kà mè yuk nə. Mègù sə̀' ŋwàk nə̀ wèeŋ tagə̀ ènə, nə̀ nà' sə cèp bə liŋ am. ");
INSERT INTO yam_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nə ye də wèŋ a bɛ̀ŋ ŋgòvə̀ bohòmʉ̀ ya wèeŋ tse' lùŋ. ");
INSERT INTO yam_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","<<Bohòmʉ̀ yàm, a ye-a ŋga ŋwè kuksə mʉ, mʉ̀ kà fàk bə zeŋ tse'. ");
INSERT INTO yam_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mʉ̀ rì weŋ bə̀boŋ. Mʉ̀ rì də wèŋ ka Nwì sə ntʉʉ̀ wèŋ dzəm. ");
INSERT INTO yam_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mʉ̀ dʉk vɛ'nə bʉ̀ʉsə̀ mʉ̀ a və̀ bohòwèŋ mʉnə liŋ Tɛ̀' am fana wèŋ bɛŋ mʉ̀ nə̀ Tɛ̀' am a tum mʉ yi nə. Nə ye də a ye-a ŋga ŋwə̀ nəmòk və̀-a bohòwèŋ bə liŋ sə̀ ye fana wèŋ ko wumsə gesə nà'nə ndzə ŋgùu wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Wèŋ sə làp mègù mandzə̀ nə̀ də ya bwìiŋ kuksə weŋ. Wèŋ ka mvə̀k nə̀ co də Nwì nə̀ yi mò'fis nə kwa bohòwèŋ yi lap. A ye-a də bum yè'sə vɛ'nə, ye də aco wèŋ dzəm mʉ yè'sə va pip! ");
INSERT INTO yam_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","<<Kà də wèeŋ tsərə də mʉ nə kə jəŋ və nzak mʉ tuhù wèŋ mantombìi Nwì mʉ̀ dʉk. Anə ye bum sə̀ Musì nə̀ wèŋ a fa wes ni' awèŋ bohòyi nə à còom sə. ");
INSERT INTO yam_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wèŋ ànə dzəm-a bohòMusì bə zìnə də bwɛ̀rɛ wèŋ a dzəm bohòmʉ̀ yàm sə̀', bʉ̀ʉsə̀ Musì nə bə tu ye ànə com bum mok bə liŋ am sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","A ye-a də wèŋ ka bum sə̀ Musì ànə com noŋsə lo me mantombì dzəm, ye də aco wèŋ dzəm ncèp nə̀ njàm ŋga'a va?>> ");
INSERT INTO yam_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bum yè'sə ànə ca gesə wes me fana Jisòs nə lokok, nə bwi lo mvwe' nzeŋgòŋ Galìli. Yi à kə̀ dzèŋ fo', yi to ca lo tə̀m Galìli nə mamòk. Wo à sə to tə̀m ènə sə̀' də tə̀m Tìberiyà. ");
INSERT INTO yam_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bwìŋ à sə bɛ' kɛ' cà yi vɛ'ɛ wùriŋ, bʉ̀ʉsə̀ wo yə nsàap maŋgəŋgèeŋ sə̀ yi à sə gʉ̀ bə mandzə̀ nə̀ də yi à sə gʉŋsə bwìŋ bə yiyaŋ awo. ");
INSERT INTO yam_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ànə gèŋ Jisòs bə ŋgàa fàak ye wèŋ kok lo mʉmvwe' nda mòk fo', nə kə cum tsoŋ mbwa nze. ");
INSERT INTO yam_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ànə ye yè'sə ŋga ŋkà' bʉ̀ʉ Jus wèŋ nə̀ wo togə̀ nà' də Pasobà nà'a à kʉəp sə̀' laŋ. ");
INSERT INTO yam_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisòs à kʉ̀ksə, nə ye ŋga bwìŋ sə kok və̀ ŋgòkə̀ tsèŋ yi vɛ'ɛ wùriŋ. Fana yi bʉʉŋ fek Filìp də, <<Vesùwèeŋ nə ywiŋ bɛŋ fò, co a fa bʉ̀ʉ yè'e wèŋ pwe' wo zʉ ze' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jisòs nə à fek yè'sə ŋgòfʉ̀ksə Filìp bwɛ̀rɛ yi à rì yusə̀ aco yi gʉ sə laŋ. ");
INSERT INTO yam_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filìp cep fəsə fa nà' də, <<A ywiŋ-a bɛŋ sə̀ bàam mbàm ba, yà' kà yumok bohòbʉ̀ʉ yè'e səsə̀ lok.>> ");
INSERT INTO yam_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ŋgà fàk Jisòs mòk à ye fo' nə̀ liŋ ye à ye də Andrù. Yi à ye moma Saimʉ̀ Pità. Yi à dʉk fa Jisòs ye də, ");
INSERT INTO yam_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","<<Mʉ mombam mòok fɛɛŋ nə̀ yi tse' ntuhu brɛd tàŋ bə fuk ba. Megu də aco yà'sə ye yà bohòbʉ̀ʉ yè'e pwe' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","À ye ŋga bʉ̀ʉ sə wèŋ kə̀ dzèŋ laŋ fana Jisòs dʉk fa ŋgàa fàak ye wèŋ də yà'a dʉk bʉ̀ʉ sə pwe' cum nze. Ŋgaŋ ànə ye fo' co bwìŋ cum mbwa. Mbəmbaam sə̀ wo à ye mʉmvwe' kwe' ènə à ye co bwìŋ ncùhù tàŋ. ");
INSERT INTO yam_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisòs à jə ntuhu brɛd sə, nə kwasə Nwì bə zeŋ. Fana yi gapsə fa bʉ̀ʉ sə̀ wo à cu nze sə. Yi à gʉ̀ bə fuk sə sə̀' vɛ'nə fana ndàaŋwè pwe' à zʉ tə̀tè nə ze'. ");
INSERT INTO yam_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wo ànə zʉ wes fana Jisòs nə tsok fa ŋgàa fàak ye wèŋ də, <<Wèeŋ benə bwees sə̀ yà' bwehe cu sə mvwe' mò'fis, ya kà də yà'a bʉp wà dʉk.>> ");
INSERT INTO yam_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Fana ŋgàa fàak ye sə wèŋ à benə bwees sə, yà' rwiŋ kwès hum-ncòp-ba. ");
INSERT INTO yam_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bʉ̀ʉ sə wèŋ à yə nsàp maŋgəŋgèŋ nə̀ Jisòs à gʉ̀ʉ nə fana wo dʉk də, <<Nè'e gù tsə mègù ŋgà tsə̀' bum Nwì nə̀ wo à dʉk fa' də Nwìi nə kə tumsə və̀ nà' sə nzeŋgòŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisòs riŋ də wo sə làp də wo ko koksə yi ŋkum bə ŋàŋ fana yi kok lo bisə yuye mʉ ndahà anə yiìyi. ");
INSERT INTO yam_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nùm à co fana ŋgàa fàak Jisòs sə wèŋ tsooŋ lo sə ŋgʉ ndzəp. ");
INSERT INTO yam_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Wo ni ŋgwes, nə ye ŋgòlòo də wo to tesə lo ŋgʉ ndzəp ma mòk mvwe' lak Kàpanùm. Wo à lòtə̀tè ndzəm kə seŋ wo ŋga wo cu ntòmʉtsətsə'rəə ndzəp nə. Yè'sə ànə ye ŋga Jisòs ka ye ntòvə. ");
INSERT INTO yam_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Fə̀fə̀ nə̀ bʉp à yè ŋgòcàa. Fə̀fə̀ nə sə bwi'lə ndzəp nə vɛ'ɛ sə̀' nsàp nə̀ bə jòŋ. ");
INSERT INTO yam_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yè'sə ànə ye ŋga wo mok ndzə tsətsə'rəə ndzəp anə sə̀sap co kìlometà tàŋ kè ntùŋfu àlɛ' fana wo ye ŋga Jisòs sə gì və̀ mʉ ndzəpə̀. Wo à yə vɛ'nə, wʉə ko wo vɛ'ɛ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jisòs nə dʉk fa wo də, <<Wèeŋ kà wəp, a mʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Wo à yuk vɛ'nə, wo dzəm də wo jəŋ nisə yi sə ŋgwesə̀ anə. Ànə ye vɛ'nə fana wo geŋ də wo kʉk à, ŋga wo dzèŋ ndzə ŋgʉ ndzəp nə mvwe' sə̀ wo anə sə lo sə tè. ");
INSERT INTO yam_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tsok à rɛŋ ŋga bʉ̀ʉ sə̀ wo à ye wùriŋ sə wèŋ cu malì ŋgʉ ndzəp nə mamòk anə mvwe' sə̀ Jisòs bə ŋgàa fàak ye wèŋ a mè'rə və̀ sə. Bʉ̀ʉ sə wèŋ riŋ də ŋgwes a ye mègù fo' ŋkwìs mò'fis. Wo tsərə sə̀' də ŋgàa fàak Jisòs wèŋ a lòbə ŋgwes ànə woòwo, a ka bə Jisòs wèŋ lo. ");
INSERT INTO yam_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ŋgwes mok sə̀ zok à tesə və̀ mvwe' lak Tìberiyà. Wo à və̀ə nə kʉəp və mvwe' sə̀ Tà Jisòs ànə fa bwìŋ zʉzʉ ŋga yi kwasə wes Nwì bə zeŋ yà'a. ");
INSERT INTO yam_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Fana bʉ̀ʉ sə wèŋ à yə də Jisòs bə ŋgàa fàak ye wèŋ ka fa'nə mok yeŋ fana wo kpəəŋ ni ŋgwes sə̀ fo' sə, nə sə lo mvwe' lak Kàpanùm. Wo à sə lòfo' də ya ŋga wo kə ye Jisòs. ");
INSERT INTO yam_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wo à kə̀ dzèŋ ŋgʉ ndzəp mamòk anə fana wo ye Jisòs nə fo'. Wo fek yi də, <<Wù və̀ yòfɛɛŋ sèŋ, Cicà?>> ");
INSERT INTO yam_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisòs dʉk fa wo də, <<Mʉ̀ sə tsə̀' weŋ yè'e zìnə nə̀ nà'a ŋkèm ncèp də, wèŋ sə làp mègù mʉ yè'sə njo nə̀ wèŋ a zʉ brɛd yà'a ŋkwìs tə̀tè nə ze'. Njo nə̀ wèŋ sə làp mʉ nə, ka bʉ̀ʉsə̀ də wèŋ a yə nsàap maŋgəŋgèeŋ sə̀ mʉ̀ a gʉ̀ nìtsə̀' fa weŋ fana wèŋ nə rɛɛŋ bə zeŋ yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kà də wèeŋ sə fàk ŋgòtse' nsàp bɛŋ nə̀ nà'a nə ca gɛsə wà nè'e dʉk. Wèeŋ fak lɛ bə nsàp bɛŋ nə̀ nà'a nə kà wà kə̀ cà bʉp, nə̀ aco nà' fa ŋwè lùŋ nə̀ zìnə nə̀ nà'a nə̀ kà mè yuk nə. Nà'a bɛŋ nə̀ aco mʉ̀ʉ mo ŋwè, mʉ̀ fa weŋ nà', a mʉ̀ nə̀ Tɛ̀' am Nwì a fa mvə̀k nə̀ ŋgònìtsə̀' fa kɛ' bwìŋ bə zeŋ də mʉ mo ye nə.>> ");
INSERT INTO yam_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wo fek Jisòs nə də, <<Nsàap fàak sə̀ aco vès gʉ yà' ya Nwìi kwa bohòvèes yè'sə yà?>> ");
INSERT INTO yam_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisòs dʉk fa wo də, <<Nsàp fàk nə̀ aco wèŋ gʉ nə də, wèeŋ dzəm bohòŋwə̀ nə̀ Nwì à tum və̀ə nə.>> ");
INSERT INTO yam_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wo dʉk fa yi də, <<A ye-a vɛ'nə, ye də nsàp yu nə̀ aco wù gʉ, wù bə tu yo, ya vèes ye nə dzəm bohòwùu yè'sə yà? Yusə̀ aco wù gʉ niŋ fa ves sə yà? ");
INSERT INTO yam_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ànə ye njamòk ŋga tàcicii avès wèŋ à sə gì ŋgəà yà'a fana wo sə fa wo nsàp bɛŋ mòk nə̀ wo to nà' də Manà. Yà' mègù mvə̀'nə̀ wo à còm ndzənə ŋwàk Nwì də, <Yi ànə fa wo bɛŋ sə̀ yà' à tsə ma mʉbu də wo sə zʉ.> Ye də aco wù gʉ niŋ fa ves yumook yòvɛ'nə sə̀' à?>> ");
INSERT INTO yam_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ànə geŋ Jisòs dʉk fa wo də, <<Mʉ̀ sə tsə̀' weŋ yè'e zìnə nə̀ nà'a ŋkèm ncèp də, bɛŋ sə̀ Musì ànə fa tàcicii awèŋ yà' ŋgəà sə ànə ka wo yà' yi fa. Tɛ̀' am fagə̀ bwìŋ bɛŋ nə̀ zìnə nə̀ nà' tsə ma mʉbu nə yi. ");
INSERT INTO yam_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bɛŋ nə̀ Nwìi fagə̀ bwìŋ nə, a nə̀ nà'a tsəgə̀ ma mʉbu, nə fa bwìŋ sə nzeŋgòŋ anə lùŋ nə̀ zìnə nə.>> ");
INSERT INTO yam_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wo dʉk fa yi də, <<Tà, fa ves nsàp bɛŋ ànə, nə kà ntsə'mòk càsə̀ yuk.>> ");
INSERT INTO yam_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisòs dʉk fa wo də, <<Mʉ yè'e sə̀' bɛŋ nə̀ nà'a fagə̀ bwìŋ lùŋ nə. Ŋwə̀ nə̀ yi və-a bohòmʉ̀, njè kà ŋgə̀ŋgàŋ mok sə̀' ya fe'lə̀. Ŋwə̀ nə̀ yi dzəm-a bohòmʉ̀ njè ndzəp nə kà yi mok ya yu' fe'lə̀. ");
INSERT INTO yam_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bohòwèŋ yàwèŋ, yà' mègù mvə̀'nə̀ mʉ̀ à tsə̀' weŋ fa' mantombì yà'a də, wèŋ a yə mʉ bə lis awèŋ laŋ fana nə kà bohòmʉ̀ anə dzəm. ");
INSERT INTO yam_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bʉ̀ʉ sə̀ Tɛ̀' am fa mʉ wo də wo ye bʉ̀ʉ am pwe' nə və bohòmʉ̀ anə. Ŋwə̀ nə̀ yi və-a bohòmʉ̀ fana gʉ kpʉ yà, kaco mʉ̀ bɛ' fəsə yuk yi maŋkwɛ̀ŋ yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bʉsə̀ mʉ̀ à tsə mʉbu ŋgòkə̀ gʉ̀ yusə̀ ŋwə̀ nə̀ yi à tum mʉ nə dzəm vɛ'nə. Mʉ̀ à ka ŋgòkə̀ gʉ̀ yusə̀ mʉ̀ dzəm yà' mʉ̀ və. ");
INSERT INTO yam_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yusə̀ ŋwə̀ nə̀ yi à tum mʉ sə dzəm sə də, yòŋsə̀ ŋwə̀ nə̀ mò'fis kà mʉtsətsə'rəə bʉ̀ʉ sə̀ yi fa ndzə bohòmʉ̀ sə bisə̀. Yi dzəm də mʉ gʉ lɛ co wo pwe' lokok və mvwe' lùŋ nùmbu nə̀ nzeŋgòŋ nə mèe. ");
INSERT INTO yam_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yusə̀ yà' bòTɛ̀' am sə də, ŋwə̀ nə̀ yi yə-a nə riŋ mo ye nə, nə dzəm bohònà' fana ŋgə̀ŋgàaŋ nə tse' lùŋ nə̀ nà'a nə̀ kà mè nə. Ye də nùmbu nə̀ nzeŋgòŋ nə mèe, mʉ̀ gʉ ŋwə̀ ànə yi lokok ŋwʉm.>> ");
INSERT INTO yam_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bʉ̀ʉ Jus wèŋ à yè ŋgòcèp ŋwə̀m kɛ'cà bə liŋ Jisòs sə də bʉ̀ʉsə̀ nà' dʉk də, <<Mʉ bɛŋ nə̀ mʉ̀ tsə ma mʉbu.>> ");
INSERT INTO yam_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wo sə cèp də, nè'e ka Jisòs mo Jòsep yeŋ ɛ̀? Mʉ̀ də a rì ma bə tɛ̀' lòoŋ fo' àlaa. Ye də yè va ŋkuŋ yi sə cep də, <<Mʉ̀ tsə ma mʉbu>> ɛ? ");
INSERT INTO yam_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisòs nə dʉk fa wo də, <<Wèeŋ kà də wèeŋ sə cep ŋwəm kɛ'ca mʉtsətsə'rəə wèŋ dʉk. ");
INSERT INTO yam_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kaco ŋwə̀ nəmòk və to bohòmʉ̀ anə yeŋ tse'ŋga Tɛ̀' am nə̀ yi a tumsə və̀ mʉ nə gʉ̀ nà' yi ŋkuŋ yi və bohòmʉ̀ anə. Ŋwə̀ nə̀ yi və-a bohòmʉ̀ fana nùmbu nə̀ nzeŋgòoŋ mee, mʉ̀ lòkoksə yi ŋwəm. ");
INSERT INTO yam_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ŋgàa tsòhòbum Nwì sə̀ njamòk wèŋ ànə com noŋsə njamòk də, <Nwìi nə yə'rə fa bwìŋ bum pwe'fo' yi.> Ye də ŋwə̀ nə̀ yi yuk-a ncèp Tɛ̀' am ènə, nə kotse' nà' sə ntʉʉ̀ yi, fana ŋgə̀ŋgàaŋ nə və bohòmʉ̀. ");
INSERT INTO yam_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mʉ̀ sə kà yè'sə də ŋwə̀ nəmòk a yə yuk Tɛ̀' am nə bə lis laŋ dʉk. À yə yuk mègù yi mʉ̀, nə̀ mʉ̀ à tsooŋ mbwa nə. ");
INSERT INTO yam_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mʉ̀ sə tsə̀' weŋ yè'e zìnə nə̀ nà'a ŋkèm ncèp də ŋwə̀ nə̀ yi dzəm-a bohòmʉ̀ ye də ŋgə̀ŋgàŋ tse' lùŋ nə̀ zìnə nə laŋ. ");
INSERT INTO yam_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mʉ bɛŋ nə̀ mʉ fagə̀ bwìŋ lùŋ nə̀ zìnə nə mʉ̀. ");
INSERT INTO yam_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ŋgòcèp bə nsàp bɛŋ nə̀ wo to nà' də manà, nə̀ tɛ̀'ɛ awèŋ ànə zʉ nà' ŋgəà nə fana, wo ànə zʉ yà' vɛ'nə, nə kpʉ mali gu sə̀' kpʉ. ");
INSERT INTO yam_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bohòma nə̀ bɛŋ nə̀ zìnə nə̀ nà'a tsə ma mʉbu ye də, ŋwə̀ nə̀ yi zʉ-a nà', yi nə kà kpʉ yuk. ");
INSERT INTO yam_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mʉ yàm bɛŋ nə̀ nà'a fagə̀ bwìŋ lùŋ ànə, nə̀ nà' tsə ma mʉbu. A ye-a ŋga ŋwə̀ nəmòk zʉ-a bɛŋ ènə, ye də yi nə cum mamgeŋ fo' mvèsə̀. Bɛŋ nə̀ mʉ̀ sə fa bwìŋ pwe' nà' də wo zʉ ya wo tse' lùŋ nə, a ŋgùpni' àm.>> ");
INSERT INTO yam_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ncèp nə̀ Jisòs à cèp ènə à gʉ̀ bʉ̀ʉ Jus wèŋ sə joho, nə tse' mok mamfenə̀ mʉtsətsə'rəə wo. Wo sə cep də, <<Aco ŋkwà'kʉ̀ nè'e fa ves ŋgùpni' ye də a zʉ nà' yè'sə va?>> ");
INSERT INTO yam_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Fana Jisòs dʉk wo də, <<Mʉ̀ sə tsə̀' weŋ yè'e ŋkèm ncèp dʉk də, a ye-a ŋga ŋwè ka ŋgùpni' àm, nə̀ a mʉ̀ʉ mo ŋwè nə zʉ, nə kà ndʉəm am sə̀' no fana ye də ŋgə̀ŋgàŋ ka lùŋ nə̀ zìnə nə tse'. ");
INSERT INTO yam_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nə ye də bohòŋwə̀ nə̀ yi zʉ ŋgùpni' àm, nə no ndʉəm am sə fana ye də yi tse' lùŋ nə̀ nà'a nə̀ kà mè. Nùmbu nə̀ nzeŋgòoŋ mèe, mʉ̀ lokoksə nsàp ŋwə̀ ànə ŋwəm. ");
INSERT INTO yam_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ŋgùpni' àam bɛŋ nə̀ zìnə nə, ndʉəm am ye sə̀' nəno nə̀ zìnə nə. ");
INSERT INTO yam_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ŋwə̀ nə̀ yi zʉ-a ŋgùpni' àm, nə no ndʉəm am fana ye də ŋgə̀ŋgàaŋ mam mok ndzə ni'ì mʉ̀, mʉ̀ mam ndzə ni'ì ŋgə̀ŋgàŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tɛ̀' am nə̀ yi tse' lùŋ nə a tum və̀ mʉ yi. Lùŋ nə̀ njàm nə̀ mʉ̀ tse' nə a və̀ bohòyi. Ye də ŋwə̀ nə̀ yi zʉ-a ŋgùpni' àm fana ŋgə̀ŋgàaŋ nə tse' jəŋ lùŋ nə bohòmʉ̀ ye sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mʉ tsok fa weŋ sə̀mok də, ŋgùpni' àm nə nà'a bɛŋ nə̀ zìnə nə̀ nà' tsə ma mʉbu. Nà' ka nsàp bɛŋ nə̀ tàcicii avès wèŋ à zʉ nà' ŋgəà nà'a yeŋ. Bʉsə̀ wo ànə zʉ bɛŋ ànə vɛ'nə fana nə kpʉ mali. Ŋwə̀ nə̀ yi zʉ-a ye bɛŋ nə̀ mʉ̀ sə fa yi nà' nə, ye də yi nə kà mok kpʉ fe'lə̀.>> ");
INSERT INTO yam_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisòs à cèp ncèp ènə ŋga yi sə yə'rə bwìŋ mʉmvwe' ndap pìriyà mvwe' lak Kàpanùm. ");
INSERT INTO yam_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ŋgàa fàak Jisòs wèŋ ànə yuk ncèp ènə fana wo dʉk də, <<Kàcò, ncèp ènə gʉ wesə vɛ'ɛ wùriŋ, aco gʉ to mʉmvə̀' ànə yè'sə ndà pip?>> ");
INSERT INTO yam_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisòs nə riŋ ye sə̀' də ŋgàa fàak ye sə wèŋ sə cèp ŋwə̀m kɛ'cà bʉ̀ʉ ncèp ye nə fana yi fek wo də, <<Ncèp ènə gʉ̀ weŋ co wèeŋ me'rə mʉ, nə bwi foho lo yu awèŋ à? ");
INSERT INTO yam_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A ye-a vɛ'nə, ye də a ye-a ŋga wèŋ yə mʉ̀ʉ mo ŋwè ŋga mʉ̀ sə kok lòfe'lə mʉtsə̀ mvwe' sə̀ mʉ̀ ànə ye to sə, wèŋ dʉk wesə mok də yà? ");
INSERT INTO yam_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yòŋsə̀ nə gʉ̀gə̀ yi ŋkuŋ ŋwè cum ŋwəm, ŋgùpni' ka ye yumok ŋgògʉ̀ʉ tse'. Aco wèŋ tse' bum yòŋsə̀ bə bum lùŋ bə ncèp nə̀ mʉ̀ tsə̀' fa weŋ ènə. ");
INSERT INTO yam_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Megu də bʉ̀ʉ mok cu mʉtsətsə'rəə wèŋ sə̀ wo sə kà ncèp ànə dzəm.>> Jisòs à sə cèp bum yè'sə ŋga yi à rì ye bʉ̀ʉ sə̀ wo à ka dzəm, nə riŋ bə ŋwə̀ nə̀ nà'a nə̀ sèŋ yi nə wèŋ mantombì laŋ. ");
INSERT INTO yam_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yi à cèp fe'lə mok sə̀' də, <<Nà'a njo nə̀ mʉ̀ a dʉk weŋ də, kaco ŋwè və bohòmʉ̀ bə tu ye yeŋ, tse' ŋga Tɛ̀' am gʉ̀ yi yi ŋkuŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ye jəŋ fa'nə, bʉ̀ʉ sə̀ wo à sə yù Jisòs sə à mè'rə yi, nə bwi foho lo yu awo vɛ'ɛ ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Fana Jisòs bʉʉŋ fek ŋgàa fàak ye sə̀ yi à cok fis wo hum-ncòp-ba sə wèŋ də, <<Wèŋ yàwèŋ ɛ, wèeŋ bwi foho lo sə̀' à?>> ");
INSERT INTO yam_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimʉ̀ Pità dʉk fa fəsə nà' də, <<Tà, wù tse' ncèp nə̀ nà' tse' lùŋ nə̀ nà'a nə̀ kà mè nə wù. Wù sə fek ves vɛ'nə yè'sə də aco vès yuŋ fe'lə lo ŋga'a mok ndà? ");
INSERT INTO yam_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Vès a dzəm bohòwù, nə riŋ sə̀' də wu ŋwə̀ nə̀ rərɛŋ nə̀ wù a və̀ bohòNwì.>> ");
INSERT INTO yam_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisòs dʉk fa fe'lə wo də, <<Wèŋ sə dʉk vɛ'nə, wèŋ ka riŋ də wèŋ sə̀ mʉ̀ a to fis weŋ hum-ncòp-ba yè'e, mòok ca nə̀ yi ye maze' riŋ à?>> ");
INSERT INTO yam_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yi à sə cèp yè'sə bohòJudàs mo Saimʉ̀ Iskarəyà. Yi à rì də Judàs nə̀ nà'a mòk sə mvwe' ŋgàa fàak ye sə̀ hum-ncòp-ba sə nə seŋ yi nà'. ");
INSERT INTO yam_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bum yè'sə ànə ca wes fana Jisòs sə gihi kɛ' mvwe' nze Galìli. Yi ànə ka ŋgòlòmvwe' nze Jùdiyà dzəm bʉ̀ʉsə̀ bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ à sə làp mandzə̀ də wo zə yi. ");
INSERT INTO yam_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mvə̀k ànə à ye ŋga ŋkà'a bʉ̀ʉ Jus sə̀ wo togə̀ yà' də ŋkà'a Duŋ yà'a kʉəp və̀ sə̀' laŋ. ");
INSERT INTO yam_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Fana bwema Jisòs sə dʉk fa yi də nà'a lokok, nə lo mvwe' nze Jùdiyà, nə kə gʉ nsàap bum maŋgəŋgèeŋ sə̀ yi sə gʉ̀ sə fo', ya bʉ̀ʉ sə̀ wo sə yù mandzə̀ nà' sə̀ wo cu ma nà'nə ye jəŋ yàwo sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wo dʉk fa mali yi sə̀' də, <<Ŋwèe dzəm-a də bwìiŋ riŋ yi, kaco yi sə gʉ swihi kɛ' bum swihi yeŋ. Wù sə gʉ̀ bum yè'sə fana bòdə wu sə gʉ yà' mvwe' jəja ya bwìiŋ ye.>> ");
INSERT INTO yam_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bwema ye wèŋ ma, à sə kà yi sə̀' dzəm. ");
INSERT INTO yam_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisòs nə dʉk fa wo də, <<Mvə̀k nə̀ ŋgòlònə ka bohòmʉ̀ yàm ntòkʉrə. Bohòwèŋ yàwèŋ, mvə̀k nə̀ fòlòoŋ kə̀kʉrə̀. ");
INSERT INTO yam_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bʉ̀ʉ sə̀ sə nzeŋgòŋ sə ka njo mòk ŋgòbɛ̀ŋ weŋ bʉ̀ʉ zeŋ tse'. Bohòmʉ̀ yàm, wo sə bɛ̀ŋ mʉ bʉ̀ʉsə̀ mʉ tsə̀' fagə̀ wo riŋriŋ də wo sə gʉ̀ bʉp. ");
INSERT INTO yam_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Wèeŋ du lo yàwèŋ mvwe' ŋkà' nə ntɛ̀ŋ. Mʉ nə kà yàm ntòkok lòbʉ̀ʉsə̀ mvə̀k njàm nə ka ntòkʉrə.>> ");
INSERT INTO yam_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yi à dʉk vɛ'nə, nə cum mam yuye Galìli anə. ");
INSERT INTO yam_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bwema ye sə wèŋ à lòwes fana yi bɛ' lo yà'wèŋ sə̀'. Yi à sə gì swìhi gorə lòye sə fʉ̀ə̀ fʉ̀ə̀, yi à ka jəja lo. ");
INSERT INTO yam_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ à sə làp yi mvwe' sə̀ wo à tse' ŋkàk sə. Wo sə fe'rə kɛ'cà də, <<Ŋwə̀ ànə yè'sə fòlɛ-ò?>> ");
INSERT INTO yam_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bwìŋ à sə cèp làrə kɛ'cà bə liŋ Jisòs sə wùriŋ. Mok sə dʉk də yi ŋwə̀ nə̀ bə̀boŋ. Mok bɛŋ də a mvwès, də nà' sə jə lòbwìŋ ma nə̀ bə jòŋ wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ŋwè à sə kà bə liŋ ye sə jəja taàŋ bʉ̀ʉsə̀ wo à sə wəp bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ŋkàk nə à kə̀ dzèŋ mok co mʉtsətsə'rə̀ fana Jisòs nə lo ye sə mʉmvwe' ndap Nwì nə̀ ghaŋ nə, nə sə yə'rə bwìŋ mbwa. ");
INSERT INTO yam_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ à yuk, nə mərə vɛ'ɛ wùriŋ. Wo sə cep də, <<Ŋwə̀ ènə a ka ŋwàak lʉ̀k yə'rə, nə sə rì nə bum vɛ'ɛ valɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ànə geŋ Jisòs cep fəsə fa wo də, <<Bum sə̀ mʉ̀ sə yə'rə sə ka sə̀ yàm yeŋ, a sə̀ Nwì nə̀ yi a tum və̀ mʉ nə. ");
INSERT INTO yam_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","A ye-a ŋga ŋwè dzəm də yi gʉ yusə̀ co Nwì kwa bə zeŋ fana aco yi riŋ sə̀' də yusə̀ mʉ̀ sə yə'rə sə və̀ bohòNwì, yà' ka yàm bə ŋàaŋ yàm yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ŋgòcèp bə nsàp ŋwə̀ nə̀ də mʉ yè'e ndàlɛ fana, a ye-a ŋga ŋwè sə cèp-a yumok bə ŋàaŋ sə̀ ye, vesùwèŋ riŋ də yi sə làp yà'sə mandzə̀ də bwìiŋ jəŋ yi co ŋwə̀ nə̀ ghaŋ. Nə ye sə̀' də a ye-a ŋga ŋgə̀ŋgàŋ sə dzəm də wo kuksə ŋwə̀ nə̀ nà' tum yi fana vesùwèŋ riŋ sə̀' də yi ŋwə̀ nə̀ zìnə, yi sə kà bwìŋ yà'sə bəbòrə̀. ");
INSERT INTO yam_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Wèeŋ ja'a-na yàwèŋ sə̀' ɛ̀. Musì ànə fa weŋ lʉ̀k, ka yi yeŋ nɛ̀? Nə ye də ŋwə̀ nə̀ mò'fis mʉtsətsə'rə wèŋ nə̀ yi nòŋsəgə̀ yà' lòoŋ bʉ̀ə̀. Njo nə̀ wèŋ sə làp mandzə̀ də wèeŋ zə mʉ kə bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Fana bʉ̀ʉ sə̀ wo à mà tə fo' sə wèŋ də, <<Hàva', yòŋsə̀ ze' mòk cu ndzə tuhù ŋgà' nè'e tà. Wù sə ŋaŋa kènə, wù yə ŋga sə làp mandzə̀ ŋgòzə wu ndà?>> ");
INSERT INTO yam_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisòs dʉk fa wo də, <<Wèŋ pwe' sə mərə də bʉ̀ʉsə̀ mʉ̀ a gʉ̀ yu maŋgəŋgèŋ nùmbu dzə̀. ");
INSERT INTO yam_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Wèeŋ tsərə-a bə nzak kom fa bwe mbəmbam wèŋ tu ɛ̀. Wèŋ rì də Musì à tsə̀' də wu dzə mombam, nùmbu nə̀ fwame' dzèeŋ, wù kom fa yi tu nùmbu ànə. A zìnə də à ka yè'sə Musì dʉk to. Ànə gʉ to bum yè'sə tàcicii avès sə̀ mantombì ŋkuŋ Musì sə və ye sə. Nə yeè nə də njo nə̀ Musì ànə cep vɛ'nə fana wèŋ sə kom fa wo tu sə bə sə̀ yà' kə̀ kʉ̀rə nùmbu dzə̀ wèŋ pwe', nə kà càsə̀. ");
INSERT INTO yam_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","A ye-a də wèŋ sə kom fa bwe awèŋ tu bə nùumbu dzə̀ wèŋ lòoŋ də ya wèeŋ kà lʉ̀k Musì gʉ̀ bʉpsə̀, ye də mʉ̀ lùŋsə yàm ŋwə̀ nə̀ mim bə tu nùmbu dzə̀, wèŋ jok bohòmʉ̀-ɛ bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A bə̀boŋ də wèeŋ dzəm-a ŋgòsak nzak, wèŋ kà ma mò'fis kʉ̀k mègù. Wèŋ lap ja'a yusə̀ gʉgʉŋ sə̀ yà' cu sə tsətsə'rə̀ ànə pwe' ŋkuŋ nə cep.>> ");
INSERT INTO yam_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bʉ̀ʉ lak Jòrosalèm wèŋ mok à dʉk də, <<Nè'e ka ŋwə̀ nə̀ wo sə làp yi də wo zə yi nə yeŋ à? ");
INSERT INTO yam_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wèeŋ ja'a na yàwèeŋ mvə̀'nə̀ yi tə nè', nə sə cèp nə jəja, ŋwə̀ nəmòk kà yi yumok sə̀ fek lok ɛ̀. Ye də bʉ̀ ŋkwàha bʉ̀ʉ avès wèŋ dzəm mok laŋ də yi yè'sə Ŋkum ŋgà gèm bwìŋ nə kènə va? ");
INSERT INTO yam_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Megu ŋga'a kə də vesùwèŋ rì lak ŋwə̀ ènə mvwe' sə̀ yi və̀ə, ŋga yusə lɛ də Ŋkum nə və-a ye, ŋwè kà mvwe' sə̀ yi a və̀ə sə rì yuk fʉ̀'.>> ");
INSERT INTO yam_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisòs ànə sə yə'rə mʉmvwe' ndap Nwì nə̀ ghaŋ nə fana yi cep torə fis də, <<Wèŋ də wèŋ rì mʉ, nə riŋ bə mvwe' lak am mwè pwe' ɛ̀? Ye də wèeŋ riŋ də mʉ̀ ka fɛɛŋ bə ŋàaŋ yàm və, mʉ̀ və̀ bə liŋ ŋwə̀ nə̀ yi ŋwə̀ nə̀ zìnə nə. Wèŋ ka yi lɛ riŋ. ");
INSERT INTO yam_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Bohòmʉ̀ yàm, mʉ̀ rì yi bʉ̀ʉsə̀ mʉ̀ a tesə və̀ bohòyi, ŋga yi a tum və̀ mʉ sə̀' yi nə.>> ");
INSERT INTO yam_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bwìŋ à yuk bum sə̀ yi à cèp yè'sə, ntʉm yaaŋ mok vɛ'ɛ fana wo lap mandzə̀ də wo ko yi. Mandzə̀ nə̀ co ŋwè kə jwɛŋ gesə fʉk yi bə bo kà ye bʉ̀ʉsə̀ à ye ŋga mvə̀k nə̀ nje nə à ka ntòkʉrə. ");
INSERT INTO yam_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ànə geŋ bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ dzəm bohòyi. Bʉ̀ʉ sə wèŋ sə dʉhʉ də, <<Nè'e gù tsə gù lɛ Ŋkum nə bwɛ̀rɛ nsàp maŋgəŋgèŋ mòk cu fe'lə nə̀ yi ka nà' ntògʉ à?>> ");
INSERT INTO yam_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bʉ̀ʉ Faràsi wèŋ à yuk də bwìŋ sə cèp làrə kɛ' bə liŋ Jisòs nə bə nsàp mandzə̀ ànə fana wo lo kə kiŋ cù bə ŋgàa fa satikà' sə̀ ghaŋ wèŋ mvwe' mò'fis. Bə yà'wèŋ tumsə lo ŋgàa kʉ̀k ndap Nwì wèŋ də yà'a kə ko və Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ànə geŋ Jisòs nə dʉk fa wo də, <<Mʉ nə cum kok vesùwèŋ mvə̀k momjo fana mʉ̀ bwi foho lo fe'lə bohòŋwə̀ nə̀ yi a tum və̀ mʉ nə. ");
INSERT INTO yam_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Wèeŋ nə lap mʉ, wèŋ kà mʉ yə bʉ̀ʉsə̀ mʉ nə ye mvwe' sə̀ co wèŋ kà fo' kə̀ dzèŋ to.>> ");
INSERT INTO yam_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bʉ̀ʉ Jus wèŋ à sə cèp kɛ'cà mʉtsətsə'rə wo də, <<Ŋkwa'kʉ̀ nè'e də yi nə lo bisə mvwe' sə̀ co vesùwèŋ kà yi yə yè'e ŋga a ma fò? A yè'sə də yi nə lo lakmvum nə kə cum bə bʉ̀ʉ avès sə̀ wo curə kɛ' fo', nə sə yə'rə bʉ̀ lakmvum sə wèŋ nà? ");
INSERT INTO yam_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yi cep mok sə̀' də vèes nə lap yi, nə kà yi yə. A nə kà mvwe' sə̀ yi cu sə sə̀' kə̀ dzèŋ to wèŋ, ŋga yi sə cu yà'sə fò? Bum sə̀ yi sə cèp yà' yà'sə dalɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nùmbu cok mbwè ŋkàk à dzèeŋ, nə̀ nà'a nùmbu nə̀ ghaŋ nə. Jisòs lokok nùmbu ànə, nə cep torə də, <<A ye-a ŋga ntʉm sə sə ŋwə̀ nəmòk, ŋgə̀ŋgàŋ və bohòmʉ̀, nə kə no. ");
INSERT INTO yam_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yà'a nə̀ ye mvə̀'nə̀ wo à còm nòŋsə yà' ndzənə ŋwàk Nwì də, <A ye-a ŋga ŋwè dzəm-a bohòmʉ̀, ndzəp nə̀ nà' tse' lùŋ nə nə sə ki tesə ndzə ni'ì ŋgə̀ŋgàŋ nduk yà'a.> >> ");
INSERT INTO yam_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yi ànə sə cep yè'sə bə yòŋsə̀ nə̀ Nwìi fagə̀ ŋwè nà' ŋga ŋwè dzəm bohòyi Jisòs nə. Ghà ànə à ye ŋga bwìŋ ka yòŋsə̀ nə ntòtse' bʉ̀ʉsə̀ Jisòs ànə ka ŋàaŋ ye sə̀ bohòTɛ̀' ye nə ntòjəŋ. ");
INSERT INTO yam_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mʉmvə̀'nə̀ wo à yuk bum sə̀ Jisòs a cèp sə fana bʉ̀ʉ mok mʉtsətsə'rəə ŋgo bʉ̀ nə̀ wo ye fo' nə dʉk yàwo də, <<Zìnə, ŋwə̀ ènə lɛ ŋgà tsə̀' bum Nwì nə̀ yi ànə ye ŋgòkə̀ və̀ə nə.>> ");
INSERT INTO yam_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bòp ma mòk dʉk yàwo sə̀' də, <<Ŋwə̀ ènə Ŋkum ŋgà gèm bwìŋ nə.>> Bòp mòk dʉk yàwo sə̀' də, <<Hai' nà'a ka yi nə yeŋ, bʉ̀ʉsə̀ Ŋkum nə à ka ŋgòtesə mvwe' nze Galìli yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ŋwàk Nwì sə tsə̀' də Ŋkum nə nə tesə mvwe' ŋgwì bʉ̀ Devìd mvwe' lak Betèrèhem. Betèrèhem nə mvwe' sə̀ Devìd nə à sə cugə̀ fo'.>> ");
INSERT INTO yam_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ànə ye vɛ'nə fana bwìŋ ga'a cù ba bʉ̀ʉ Jisòs. ");
INSERT INTO yam_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bʉ̀ʉ mok wèŋ lap mandzə̀ də wo ko yi fana wo kà yi bə bo nə̀ bo jwɛ̀ŋ lok. ");
INSERT INTO yam_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Dògarìi sə wèŋ à bwì foho lòbohòbʉ̀ʉ Faràsi bə ŋgàa fa satikà' sə̀ ghaŋ sə wèŋ bo tu. Fana bʉ̀ ŋkwàha bʉ̀ʉ sə wèŋ fek wo də, <<Wèŋ ka yi ko jə və bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dògarìi sə wèŋ dʉk də, <<Vès ka ŋga ŋwə̀ nəmòk sə cèp nsàap bum mok co ŋgà' ànə yuk yuk.>> ");
INSERT INTO yam_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bʉ̀ʉ Faràsi sə wèŋ dʉk fa yà' də, <<Wotoo, ye də yi bòrə weŋ yàwèŋ sə̀' laŋ à? ");
INSERT INTO yam_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wèŋ yə də ŋwə̀ nə̀ mò'fis mʉtsətsə'rəə bʉ̀ʉ sə̀ mantombì bə bʉ̀ʉ Faràsi wèŋ nə̀ də yi dzəm bohònà' cu yo à? Hai', ka yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Dzəm megu bohòyi anə kwe' bʉ̀ nə̀ wo ka lʉ̀ʉk Musì riŋ yà'a. Wo pwe' cu bohòNwì bʉp.>> ");
INSERT INTO yam_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ŋwə̀ nəmòk nə̀ yi ànə ye mʉtsətsə'rəə bʉ̀ʉ Faràsi sə wèŋ à ye Nìkòdemù nə̀ yi à kə̀ tsèŋ nòoŋ Jisòs ndzəmə̀ fa' nà'a. Nìkòdemù nə cep ye dʉk də, ");
INSERT INTO yam_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","<<A dʉk-a də a bɛ' tse' lʉ̀ʉk avès rərəŋ fana ye də kaco a sak nzak ŋwè ŋga ŋgə̀ŋgàŋ ka fo' sə nze ŋgòcèp ye sə sə̀' yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wo à yuk vɛ'nə wo də, <<Wu cep vɛ'ɛ va co wu sə̀' ŋkwa'kʉ̀ nə̀ mvwe' nze Galìli mòk nə̀ a lak ŋwə̀ nə̀ a sə dʉk ènə ɛ? Dù kə̀ taŋ ja'a tsə'rə ŋwàk Nwì sə̀mok. Yumok ka nja də ŋgà tsə̀' bum Nwìi nə kə̀ tesə mvwe' nzeŋgòŋ Galìli ye yuk.>>  ");
INSERT INTO yam_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ànə geŋ ndàaŋwè pwe' lo la'à yi. ");
INSERT INTO yam_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jisòs lo ye mvwe' nda mòk nə̀ wo togə̀ nà' də nda Olìp. ");
INSERT INTO yam_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tsok à rɛŋ, ŋga cu ntònə̀ zəzòŋ fana Jisòs nə bwi foho lo fe'lə mʉ ndap Nwì nə̀ ghaŋ nə sə̀mok. Bwìŋ pwe' à yù lòyi mbwa. Yi cum tsoŋ nze, nə sə yə'rə wo mʉmvwe' ndap Nwì nə. ");
INSERT INTO yam_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ànə geŋ wo ko jəŋ və ŋwà mòk fo', də wo ko nà' ŋga nà' sə ko nto. Wo fis tes gesə lo yi mantombì mvwe' jəja. Ànə ko jəŋ və yi yè'sə bʉ̀ʉ Faràsi bə ŋgàa yə'rə̀ bwìŋ lʉ̀k wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bʉ̀ʉ sə dʉk fa Jisòs də, <<Cicà, wo ko ŋwà nè'e ŋga yi sə ko nto. ");
INSERT INTO yam_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nə ye də ŋwàk lʉ̀ʉk Musì sə tsə̀' də a ye-a ŋga wo ko ŋwè bə sàhà, wo tərə yi bə lìs tə̀tè ŋgə̀ŋgàŋ kpʉ. A ye-a wù yò, wù dʉk yòbə nsàp ènə da?>> ");
INSERT INTO yam_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wo à sə cèp yè'sə ŋgòyu'rə Jisòs cù. Jisòs à bʉhʉ tsə yuye sə nze, nə sə com sɛsə sənə mfə̀mfə bə ndubo. ");
INSERT INTO yam_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wo sə fek mali yi fo' tə̀tè Jisòs nə cum kok mʉtsə̀, nə dʉk yà' də, <<Ŋwə̀ nəmòok ye-a mʉtsətsə'rə wèŋ fa'nə, nə̀ yi rì də yi ka bʉp tse' fana ŋgə̀ŋgàŋ mak to vesə ŋwà ènə bə lìs yi.>> ");
INSERT INTO yam_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yi dʉk wes vɛ'nə, yi bʉhʉ tsoŋ sə̀' sə nze anə, nə sə com sə̀mok. ");
INSERT INTO yam_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Wo ànə yuk ncèp ènə fana wo ye ŋgòcoho fo' təəŋ, təəŋ mò'fis, mò'fis, nə sə lo. À yè ŋgòtesə lòto ntòsə̀ wo ŋkwàha bwìŋ tə̀tè Jisòs à bwehe cu mègù mok fo' yiìyi bə ŋwà nə mvə̀'nə̀ yi tə kok fo'. ");
INSERT INTO yam_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisòs à lòkok cu kok mʉtsə̀ sə̀mok, nə fek ŋwà nə də, <<Njɛ̀'gù, wo fò? Ŋwə̀ nəmòk ka wu yumok gʉ à?>> ");
INSERT INTO yam_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ŋwà nə dʉk də, <<Tà, ŋwə̀ nə̀ mò'fis ka mʉ yumok gʉ lok.>> Jisòs dʉk fa fe'lə nà' də, <<Mʉ nə kà wu yàm yumok sə̀' gʉ̀. Dù lòyuyo, nə kəa cù bə ŋgògʉ̀ bʉp.>> ");
INSERT INTO yam_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisòs à cèp fe'lə ncèp mòk sə̀' də, <<Mʉ marɛŋ nə̀ sə nzeŋgòŋ nə mʉ̀. A ye-a ŋga ŋwə̀ nəmòk yù və̀ mʉ, ŋgə̀ŋgàaŋ nə tse' marɛŋ nə̀ nà'a lùŋ nə̀ zìnə nə. Yi nə kà sənə mandzəm gì.>> ");
INSERT INTO yam_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bʉ̀ʉ Faràsi wèŋ kə dʉk fa yi də, <<Wù sə ko fa ni' yògèm sə̀' wù. Ye də yusə̀ wù sə cèp yà'sə yà' ka fàk tse'.>> ");
INSERT INTO yam_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisòs nə cep ye də, <<A ye-a sə̀ də mʉ̀ sə ko fa ni' àm gèm sə̀ mʉ̀ fana mʉ̀ riŋ də yusə̀ yà' sə tesə kə̀ cùhu mʉ̀ʉ zìnə. Mʉ̀ dʉk vɛ'nə bʉ̀ʉsə̀ mʉ̀ rì mvwe' sə̀ mʉ̀ a və̀ə, nə riŋ mvwe' sə̀ mʉ̀ sə lòo. Bohòwèŋ yàwèŋ, wèŋ ka fo' riŋ. ");
INSERT INTO yam_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wèŋ bʉ̀ʉ sə̀ sə nzeŋgòŋ fɛɛŋ, wèŋ sə fʉ̀hʉ ja'a bwìŋ mʉmvə̀'nə̀ nzeŋgòŋ nə fʉ̀hʉgə̀ bum yàwo. Bohòmʉ̀ yàm, fàak am ka ŋgòfʉ̀hʉ bwìŋ yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A də mʉ̀ anə dzəm-a ŋgòfʉ̀hʉ ŋwè, yusə̀ mʉ̀ cèp bə liŋ ŋgə̀ŋgàŋ sə ye kə̀kʉrə̀ kap. Yà'a vɛ'nə bʉ̀ʉsə̀ mʉ̀ sə kà mʉmʉ̀ gʉ̀ mègù, mʉ̀ sə gʉ̀ ves ŋàaŋ Tɛ̀' am nə̀ yi à tum mʉ nə. ");
INSERT INTO yam_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yà' cu ndzənə ŋwàk lʉ̀ʉk awèŋ də, a ye-a ŋga bwìŋ ba sə cèp cù mò'fis bə yumok fana ye də yu yà'sə zìnə. ");
INSERT INTO yam_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ye də mʉ̀ tə gèm àm, Tɛ̀' am nə̀ yi à tum mʉ nə tə sə̀' gèem am.>> ");
INSERT INTO yam_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wo fek yi də, <<Tɛ̀' yònə fò?>> Jisòs dʉk fa wo də, <<Wèŋ ka mʉ riŋ, nə kà Tɛ̀' am sə̀' rì. Wèŋ ànə riŋ-a mʉ, bwɛ̀rɛ də wèŋ rì Tɛ̀' am nə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisòs à cèp bum yè'sə ŋga yi cu mʉmvwe' ndap Nwì nə̀ ghaŋ, mvwe' rum nə̀ wo kə̀ fagə̀ mbàam Nwì fo' nə. Yi ànə sə yə'rə bwìŋ vɛ'nə, ŋwə̀ nəmòk à ka yi ko bʉ̀ʉsə̀ mvə̀k nə̀ nje nə à ka ntòkʉrə. ");
INSERT INTO yam_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisòs à cèp fe'lə mok sə̀' də, <<Mʉ nə bisə yu am. Mʉ lòwes fana wèŋ lap mʉ, nə kà mʉ yə. Wèŋ kà mʉ yə vɛ'nə, wèŋ kpʉ maha mok sənə bʉp awèŋ. Wèeŋ nə kà mandzə̀ co wèŋ kə dzeŋ mvwe' sə̀ mʉ̀ lòo sə tse' to.>> ");
INSERT INTO yam_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ŋkwàha bʉ̀ʉ Jus wèŋ sə fek bwi yàwo də, <<Yi də mvwe' sə̀ yi lòo, kaco vès kə dzeŋ to fo' yeŋ, ncèp ànə yà'sə da? A yà'sə də yi nə zə ni' ye à?>> ");
INSERT INTO yam_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisòs dʉk fa wo də, <<Wèeŋ yàwèŋ bʉ̀ʉ sə̀ sə nzeŋgòŋ fɛn, Mʉ yàm ŋwə̀ nə̀ ma mʉbu. ");
INSERT INTO yam_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mʉ̀ tsə̀' weŋ də wèeŋ nə kpʉ maha bʉp sənə bʉp awèŋ. A zìnə də wèeŋ nə kpʉ li sənə bʉp awèŋ anə, ŋga a ye-a də wèŋ ka mʉ də mʉ nsàp ŋwə̀ nə̀ mʉ̀ cu nə jəŋ na.>> ");
INSERT INTO yam_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wo fek fe'lə yi də, <<Wu yè'sə ndà?>> Jisòs dʉk də, <<Mʉ ŋwə̀ nə̀ mʉ tsə̀' fagə̀ weŋ səsa də mʉ yi nə. ");
INSERT INTO yam_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Bum cu wùriŋ sə̀ aco mʉ̀ tsok weŋ də wèŋ gbʉ̀ nzak bə zeŋ. Tɛ̀' am nə̀ yi a tum mʉ nə, yi ŋwə̀ nə̀ zìnə. Bum sə̀ mʉ̀ sə tsòho fa kɛ' bwìŋ yè'e, a bum sə̀ yi a nìtsə̀' fa mʉ yà' yi.>> ");
INSERT INTO yam_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisòs à sə cèp bohòwo, nə sə dʉk də, <<Ŋwə̀ nə̀ nà' à tum mʉ>> fana wo kà yàwo də nà' sə dʉk yà'sə Tɛ̀'ɛ nà' Nwì rɛɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Fana Jisòs dʉk fe'lə də, <<Ghà nə̀ wèeŋ fis gesə lòmʉ̀ʉ Mo Ŋwè mʉtsə̀ ŋkuŋ fana wèŋ riŋ də a mʉ̀ nə. Wèeŋ nə riŋ sə̀' də mʉ kà yumok bə liŋ yàm gʉ̀gə̀. Bum sə̀ mʉ̀ cèp yà' pwe'fo', a sə̀ Tɛ̀' am nìtsə̀' fa mʉ yà' yi ŋkuŋ mʉ̀ cep. ");
INSERT INTO yam_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ŋwə̀ nə̀ yi a tum və̀ mʉ nə, yi cu venə, yi ka mʉ mʉmʉ̀ me'rə mak bʉ̀ʉsə̀ mʉ gʉ̀ mègù yusə̀ yà' sə gʉ yi sə kwa.>> ");
INSERT INTO yam_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yi ànə cep vɛ'nə fana bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ bʉʉŋ dzəm bohòyi. ");
INSERT INTO yam_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ànə geŋ Jisòs nə cep bohòbʉ̀ʉ sə̀ yà'wèŋ dzəm bohòyi sə wèŋ də, <<A ye-a ŋga wèŋ sə bɛ' tse' gù ncèp àm nə fana ye də wèeŋ bwe fàha am zìnə zìnə. ");
INSERT INTO yam_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A ye vɛ'nə fana wèŋ riŋ zìnə nə, zìnə nə nà' fiŋ me'rə weŋ sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bʉ̀ʉ sə wèŋ cep də, <<Vèes ŋgwì bʉ̀ Abràham, vès ka yàvès ŋkwɛ̀ŋ bohòŋwə̀ nəmòk cum yuk. Njo nə̀ wù sə dʉk də wo nə fiŋ me'rə vèes yè'sə nsàp nə̀ fò?>> ");
INSERT INTO yam_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisòs dʉk də, <<Mʉ̀ sə tsə̀' weŋ nè'e ŋkèm ncèp dʉk də, a ye-a ŋga ŋwè gʉ̀gə̀-a bʉp, ye də yi cu yà'sə ŋkwɛ̀ŋ bohòbʉp. ");
INSERT INTO yam_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kaco mo ŋkwɛ̀ŋ cum mamgeŋ mʉ nda'à ŋkwà'ŋwə̀ ye nə̀ mvèsə̀ yeŋ. Ŋwə̀ nə̀ yi nə cum mbwa mvèsəə mo ye. ");
INSERT INTO yam_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ye də a ye-a ŋga mo ye nə fiŋ me'rə wu, ye də wo fìŋ me'rə wu yà'sə laŋ bə nə̀ zìnə. ");
INSERT INTO yam_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mʉ̀ rì laŋ də wèeŋ ŋgwì bʉ̀ Abràham. Megu kə də wèŋ sə làp mandzə̀ də wèeŋ zə mʉ, bʉ̀ʉsə̀ yusə̀ mʉ̀ sə cèep sə sə kà fʉ ntu'ù wèŋ ni lok. ");
INSERT INTO yam_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mʉ̀ sə tsə̀' fa weŋ yusə̀ mʉ̀ a yə yà' bə lis bohòTɛ̀' am, wèŋ sə gʉ yàwèŋ sə̀' bum sə̀ wèŋ a yə'rə jə sə̀' bohòtɛ̀'ɛ àwèŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wo dʉk fa yi də, <<Tàcici àvèes Abràham.>> Jisòs dʉk də, <<Anə ye-a də wèeŋ ŋgwì bʉ̀ Abràham zìnə bwɛ̀rɛ də wèŋ sə gʉ bum sə̀' mvə̀'nə̀ Abràham nə à sə gʉ̀ʉ. ");
INSERT INTO yam_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mʉ̀ sə tsə̀' fa weŋ bum sə̀ zìnə sə̀ Nwì a nìtsə̀' fa mʉ fana wèŋ sə lap kə mandzə̀ də wèeŋ zə mʉ wà ŋga mʉ̀ ka weŋ yumok sə̀ bʉp gʉ. Wèŋ à yuk yuk də Abràham à gʉ̀ yuk nsàp yumòk vɛ'nə à? ");
INSERT INTO yam_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉ tsok fa weŋ də yusə̀ wèŋ sə gʉ̀ yà'sə, a nsàp yu nə̀ Tɛ̀' awèŋ nə̀ zìnə nə gʉ̀gə̀ vɛ'nə.>> Wo dʉk fa yi də, <<Vès ka bwe sàhà yeŋ, Tɛ̀' avèes Nwì yiìyi.>> ");
INSERT INTO yam_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisòs dʉk sə̀' də, <<Ka vɛ'nə yeŋ, bʉ̀ʉsə̀ Nwì anə ye-a Tɛ̀' àwèŋ bwɛ̀rɛ də wèŋ dzəm mʉ yàm sə̀'. Bʉsə̀ mʉ̀ a tesə və̀ bohòNwì. Mʉ̀ a ka bə liŋ yàm və, a bə liŋ ŋwə̀ nə̀ yi a tum və̀ mʉ nə. ");
INSERT INTO yam_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mʉ̀ sə cèp bum, wèŋ kà yà' sə yuk bʉ̀ʉ yà? Wèŋ sə kà yuk bʉ̀ʉsə̀ wèŋ ka wabə ŋgòrɛɛŋ bum sə̀ mʉ̀ sə tsə̀' weŋ bə nsàp ŋwə̀ nə̀ mʉ̀ cu nə. ");
INSERT INTO yam_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Wèeŋ yàwèŋ bwe tɛ̀' àwèŋ nə̀ yi Satà nə. Wèŋ sə dzəm mègù ŋgògʉ̀ bum sə̀ yà' sə bòtɛ̀' àwèŋ nə. Mvə̀'nə̀ à yè yèe, tɛ̀' àwèŋ nə cu mègù ye ŋgà zə bwìŋ haaŋ kə wɛs ntinə. Yi kà yusə̀ zìnə gʉ̀gə̀ bʉ̀ʉsə̀ yi ka zìnə tse' lok fʉk nə̀ mvèsə̀. Yi cu ŋgòcèp sə̀ yumok, yà' megu mvwès pwe' sə̀ mʉmvə̀'nə̀ nsàp ŋwə̀ nə̀ yi cu nə. A yi nə̀ yi à cì' yèto kok mvwès cap yi. ");
INSERT INTO yam_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mʉ̀ sə cèp yàm ŋga'a zìnə fana wèŋ kà mʉ mok dzəm fa. ");
INSERT INTO yam_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Aco ŋwə̀ nəmòk mʉtsətsə'rə wèŋ fa'nə niŋtsok fa mʉ bʉp mòk nə̀ mʉ̀ a gʉ̀ʉ à? Nə yeè nə vɛ'nə, mʉ̀ sə tsə̀' fa weŋ zìnə nə, wèŋ kà mʉ kə dzəm fa bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","A ye-a ŋga ŋwèe ŋwə̀ə Nwì, ŋgə̀ŋgàaŋ nə yuk ncèp nə̀ Nwì nə. Njo nə̀ wèŋ sə kà mʉ yuk nə, bʉ̀ʉsə̀ də wèŋ ka bwe Nwì yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ sə dʉk fa Jisòs də, <<Nà'a nsàp ncèp nə̀ wù cèp ŋkuŋ vès riŋ də, vèes to-a wu də wu ŋwə̀ə Sàmàriyà, nə dʉk də yòŋsə̀ ze' mòk sə ŋaŋsə wu fana ye də vès ka bə jòŋ cep sə.>> ");
INSERT INTO yam_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisòs nə də, <<Ze' mòk sə kà mʉ ŋaŋsə̀ lok. Mʉ̀ sə wəp yàm Tɛ̀' àm fana wèŋ sə kà mʉ yàwèŋ wəp lok. ");
INSERT INTO yam_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mʉ̀ sə kà mʉ̀ də bwìŋ jəŋ mʉ co ŋwə̀ nə̀ ŋkʉ̀ʉŋ làp. Tɛ̀' am nə sə dzəm yi də bwìiŋ jəŋ mʉ vɛ'nə. Ncèp ènə, anə kə̀ sak rɛŋsə nà' ntsə'mòk Tɛ̀' am nə. ");
INSERT INTO yam_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mʉ tsok fa weŋ ŋkèm ncèp dʉk də, a ye-a ŋga ŋwè noŋsə-a ncèp nə̀ njàm nə fana ŋgə̀ŋgàŋ kà kpʉ bə lis yə yuk.>> ");
INSERT INTO yam_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bʉ̀ʉ Jus sə wèŋ dʉk fa fe'lə yi də, <<Ncèep cùu yo sə gʉ̀ yi ŋkuŋ vès riŋ zìnə də, sə ŋaŋsə wu ze'. Abràham à kpʉ, ŋgàa tsòhòbum Nwì wèŋ nə kpʉ lo yàwo sə̀'. Ye də ncèp nə̀ wù cèp də ŋwèe noŋsə-a ncèp yò, ŋgə̀ŋgàŋ kà kpʉ yuk nà'a yà'sə da? ");
INSERT INTO yam_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Co wù gʉ ghak Abràham nə̀ yi à kpʉ nə à? Ŋgàa tsòhòbum Nwì wèŋ à kpʉ yàwo sə̀', wù tsəm də wu yè'sə yu yà?>> ");
INSERT INTO yam_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisòs cep fəsə mok sə̀' də, <<Wèŋ sə tsəm də mʉ̀ sə làp mʉ̀ də bwìiŋ kuksə mʉ co ŋwə̀ nə̀ ŋkʉ̀ʉŋ. A ye-a də mʉ̀ sə dzəm vɛ'nə mʉ̀ anə zìnə, ye də yà' ye yusə̀ wà. A Tɛ̀' am, nə̀ wèŋ sə to yi də yi Nwì àwèŋ nə, yi sə làp də bwìiŋ jəŋ mʉ vɛ'nə yi. ");
INSERT INTO yam_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nə ye də wèŋ sə to-a yi sə̀' də Tɛ̀' awèŋ fana wèŋ ka yi yà'sə riŋ. Mʉ̀ rì yi mʉ̀. A ye-a ŋga mʉ̀ dʉk də mʉ̀ ka yi riŋ fana mʉ̀ ye sə̀' ŋgà cì' mvwès co wèŋ. Mʉ̀ sə tsə̀' weŋ də mʉ̀ riŋ yi, nə sə noŋsə ncèp nə̀ nje nə. ");
INSERT INTO yam_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tàcici awèŋ Abràham ànə kwa də yi nə ye mvə̀k nə̀ njàm nə. Yi ànə ye nà', nə kwa bə zeŋ vɛ'ɛ maŋgəŋgèŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bʉ̀ʉ Jus sə wèŋ dʉk də, <<Wùu mʉmo nè'e, wù ka lùumŋgòŋ hum tàŋ ntòdzeŋ, nə ye va ŋkuŋ wù dʉk də wù à yə Abràham ɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisòs dʉk də, <<Mʉ tsok fa weŋ zìnə nə̀ nà'a ŋkèm ncèp dʉk də, ŋkuŋ wo sə dzə Abràham ŋga <Mʉ̀ nə> mʉ yo.>> ");
INSERT INTO yam_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mvə̀'nə̀ bwìŋ à yuk ŋga yi to liŋ ye də <Mʉ̀ nə> wo te'e lìs də wo təm zə yi bə zeŋ. Yi bisə fo' wà, nə kə yəəŋ mʉmvwe' ndap Nwì nə̀ ghaŋ nə, nə lo yuye. ");
INSERT INTO yam_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nùmbu mòk à ye ŋga Jisòs sə kɛ'kɛ' càa fana yi kə tseŋ ŋwə̀ nəmòk nə̀ wo à dzə yi ŋga yi lohòlis. ");
INSERT INTO yam_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ŋgàa fàak Jisòs ànə ye ŋgà' nə fana wo to Jisòs də, <<Cicà>>, nə fek nà' də, <<Ànə gʉ bʉp yè'sə ndà ŋkuŋ lis ŋwə̀ nè'e loho nɛ? À gʉ̀ bʉp ma ye kè tɛ̀' ye kè yi bə tu ye ɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisòs nə dʉk fa wo də, <<Yiya ènə ka bʉ̀ʉ bʉp nə̀ ŋwə̀ mòk a gʉ̀ yi yeŋ. Lis ŋwə̀ ènə à loho vɛ'nə də ya ŋga bwìiŋ ye ŋàaŋ sə̀ Nwì mʉ ni'ì ŋwə̀ ènə. ");
INSERT INTO yam_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Vesùwèeŋ gʉ tsoŋ fàak ŋwə̀ nə̀ yi tum mʉ nə ŋga cu tse' ntòmarɛŋ. Ndzəm sə və̀ə, nà'a seŋ-na fana, ŋwè kà yumok mok gʉ̀ to. ");
INSERT INTO yam_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mvə̀'nə̀ mʉ̀ cu tse' sənə nzeŋgòŋ nə fana mʉ marɛŋ bohònzeŋgòŋ nə mʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yi ànə cep wes vɛ'nə fana yi te gesə nte sə nze, nə top ncàk mvwe' sə̀ yi te nte sə bə ndubo. Yi jwɛŋ jəŋ ncàak sə, nə yok gesə fa ŋgà' nə̀ jì lis nə mʉlisə̀. ");
INSERT INTO yam_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yi ànə yok wes fana yi dʉk fa nà' də, <<Dù lo sə mvwe' ndzəp Silòm, nə kə kwak si ca.>> (Liŋ sə̀ də Silòm yà'sə də Tumsə.) Ànə geŋ ŋgà' nə lo kə kwak si ye sə ca anə. Yi à kwak, nə bwi foho və ŋga lis mùhu yi laŋ, yi sə ye mok bum. ");
INSERT INTO yam_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bʉ̀ʉ sə̀ wo cu kʉəp mvwe' sə̀ yi cugə̀ bə bʉ̀ʉ sə̀ wo rì yi də yi lɛɛŋgə̀ bum bʉ̀ʉsə̀ yi jì lis wèŋ à yə yi, nə mərə vɛ'ɛ wù kà fʉ̀'. Wo dʉk də, <<Hàva', nè'e ka ŋgà' nə̀ yi cuuŋ mègù mvwe' mò'fis, nə sə lɛɛŋ bum bohòbwìŋ nə yeŋ ɛ̀?>> ");
INSERT INTO yam_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bʉ̀ʉ mok wèŋ də, <<Ŋ̀, a yi;>> mok də, <<Hai' ka yi yeŋ. A ŋwə̀ nəmòk nə̀ yi səsə nà' səsə.>> Wo à sə dʉhʉ vɛ'nə fana ŋgà' nə cep ye sə̀'. Yi dʉk də, <<Mʉ̀ ka sə səsə, mègù mʉ̀ nə.>> ");
INSERT INTO yam_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wo fek yi də, <<Wù gʉ̀ va ŋkuŋ lis yo muhu ɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yi də, <<Ŋwə̀ nə̀ wo togə̀ yi də Jisòs nà'a mùk fa mʉ yà' yi. Yi top ncàk, nə yok fa mʉ yà' fo', nə dʉk mʉ də mʉ kə kwak si am sə sə mvwe' ndzəp Silòm. Mʉ̀ lo, nə kə kwak si sə ca fana lis am sə muhu.>> ");
INSERT INTO yam_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wo fek yi sə̀mok də, <<Ŋwə̀ ànə fò?>> Yi də, <<Mʉ̀ ka riŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ànə geŋ wo ko jəŋ ŋgà' nə̀ wo mùk fa yi lis nə, nə jəŋ lo yi bohòbʉ̀ʉ Faràsi wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yu səmook də, nùmbu nə̀ Jisòs ànə top ncàk, nə muk fa ŋgà' ànə lis bə zeŋ nə à ye nùmbu dzə̀. ");
INSERT INTO yam_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bʉ̀ʉ Faràsi sə wèŋ fek ŋgà' nə yàwo sə̀' də nà' gʉ̀ va ŋkuŋ lis nà' muhu ɛ? Ŋgà' nə də, <<Yi yok fa mʉ lis sə bə ncàk. Mʉ̀ lo, nə kə kwak si fana lis am sə muhu.>> ");
INSERT INTO yam_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bʉ̀ʉ Faràsi mok wèŋ dʉk də, <<Ŋwə̀ nə̀ yi gʉ̀ nsàp yu ènə, ka yi Nwì tumsə, bwɛ̀rɛ yi kà nsàp fàk nə̀ ŋgòkə̀ gʉŋsə ŋwè nùmbu dzə̀ ènə gʉ̀; bʉ̀ʉsə̀ lʉ̀k sə kà vɛ'nə dzəm.>> Bòp bʉ̀ ma mòk dʉk yàwo də, <<Ŋwə̀ ènə ye-a ŋgà gʉ̀ bʉp bwɛ̀rɛ yi gʉ to nsàp maŋgəŋgèŋ ènə ŋga yè va?>> Ànə ye vɛ'nə, bʉ̀ʉ sə wèŋ ga'a mok bòp ba. ");
INSERT INTO yam_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wo fek ŋwə̀ nə̀ yi mùhu lis nə də, <<Wo mùk lis-e sə̀ yò, wù tsərə yòbə ŋwə̀ nə̀ yi mùk fa wu lis ànə da?>> Yi dʉk də, <<Mʉ̀ rì yàm də ŋwə̀ ànə, yi ŋgà tsə̀' bum Nwì.>> ");
INSERT INTO yam_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bʉ̀ʉ Jus yè'sə wèŋ à ka də ŋwə̀ ènə ànə ye to mantombì ŋgà jì lis dzəm. Fana wo kə to və ma bə tɛ̀'ɛ ŋgà' nə. ");
INSERT INTO yam_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma bə tɛ̀' ye nə à kə̀ dzèeŋ fana wo fek yà' də, <<Nè'e mo àwèŋ à? A zìnə də mvə̀'nə̀ wèŋ à dzə yi, yi kà bum yəgə̀ à? Ye də yà' mùhu ŋga'a va?>> ");
INSERT INTO yam_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tɛ̀' bə ma nə dʉk də, <<Vès rì də nè'e mo àvès. Vès rì sə̀' də mvə̀'nə̀ vès à dzə yi, yi kà yumok yəgə̀. ");
INSERT INTO yam_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Megu də vès ka ŋga'a mvə̀'nə̀ yi gʉ̀ ŋkuŋ nə sə yəə̀ nə bum yè'e riŋ. Vès ka ŋwə̀ nə̀ yi mùk fa yi lis sə sə̀' riŋ. Yi ŋwə̀ rìŋsə, aco wèŋ fek yi, yi cep bə cùu ye yi.>> ");
INSERT INTO yam_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ma bə tɛ̀' ye nə à dʉk vɛ'nə bʉ̀ʉsə̀ wo à sə wəp ŋkwàha bʉ̀ʉ Jus wèŋ. Bʉsə̀ ànə ye ŋga bʉ̀ʉ Jus sə wèŋ a cèp tes laŋ də a ye-a ŋga ŋwə̀ nəmòk cèp fis jəja də Jisòos Ŋkum ŋgà gèm bwìŋ nə fana wo bɛ' fis gɛsə ŋgə̀ŋgàŋ mʉmvwe' ndap pìriyà àwo nə. ");
INSERT INTO yam_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nà'a njo nə̀ tɛ̀' ye wèŋ à dʉk də, <<Yi ŋwə̀ nə̀ yi gʉ laŋ, fek yi, yi cep bə cùu ye>> nə. ");
INSERT INTO yam_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ànə geŋ wo to və ŋgà' nə sə̀mok, ŋga'a nə̀ kɛ̀' ba. Wo fek yi də, <<Kuksə Nwì, nə cep zìnə yò. Vès rì yàvès də ŋwə̀ nə̀ wù də yi mùk fa wu lis ànə, yi ŋgà gʉ̀ bʉp.>> ");
INSERT INTO yam_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yi dʉk fa yà' də, <<Kè yi ŋgà gʉ̀ bʉp è, mʉ̀ ka yàm riŋ. Mʉ̀ rì mègù yàm yu nə̀ mò'fis dʉk də, mʉ̀ ànə ye to mantombì ŋgà lohòlis fana ŋga'a nè'e, mʉ̀ sə yə yu am mok bum.>> ");
INSERT INTO yam_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wo fek mali yi sə̀' ŋkuŋ də, <<Yi gʉ̀ fa wu lis sə va ŋkuŋ yà' muhu ɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yi dʉk fa yà' də, <<Mʉ̀ tsə̀' weŋ mvə̀'nə̀ yi gʉ̀ nə fa' laŋ, wèŋ bɛŋ ŋgòdzəm. Wèŋ də mʉ sə tsoho fa mali weŋ sə̀mok bʉ̀ʉ yà? Kàmòk wèeŋ nə sə lap sə̀' mandzə̀ ŋgòbʉ̀ʉŋ bwe ye wèŋ àlɛ'.>> ");
INSERT INTO yam_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yi ànə dʉk wo vɛ'nə fana wo yak yi də, <<Ŋyàm, wu mo ŋgà fàk ye wù, vèes yàvès bwe fàak Musì. ");
INSERT INTO yam_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Vès rì də Nwì ànə cep yuk bə Musì, vès ka mvwe' sə̀ ŋkwa'kʉ̀ ànə tesə və̀ ye yà'sə riŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ŋgà' nə̀ lis mùhu nə à yuk vɛ'nə yi də, <<Kwɛ'fòŋgʉrì! Co ŋwè muk fa mʉ lis vɛ'ɛ, wèŋ dʉk də wèŋ ka mvwe' sə̀ yi tesə və̀ə riŋ ɛ̀? ");
INSERT INTO yam_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Vesùwèŋ rì də kaco Nwì fa ŋàaŋ ye bohòŋwə̀ nə̀ yi ŋgà gʉ̀ bʉp yeŋ. Yi fa mègù ŋàaŋ ye bohòbʉ̀ʉ sə̀ wo kùksəgə̀ yi, nə sə gʉ yi kwa wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nzeŋgòŋ nə à yè yèe, ŋwè ka də wo à dzə ŋwə̀ nəmòk ŋga yi sə kà bum yə fana ŋwə̀ nəmòk kə muk fa yi lis yuk yuk. ");
INSERT INTO yam_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yà' nòjəja də ŋwə̀ ènə tesə və̀ bohòNwì. Anə ka-a vɛ'nə yeŋ bwɛ̀rɛ yi gʉ to nsàp yu nə̀ yi gʉ̀ ènə ŋga yi yè va ŋkuŋ?>> ");
INSERT INTO yam_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bʉ̀ʉ sə wèŋ də, <<Kàcò, wùu mo nə̀ wo à dzə wu sənə bʉp wà, wù sə dʉk də wu yə'rə ves yumok kènə.>> Fana wo bɛ' fis gɛsə yi mʉmvwe' ndap pìriyà àwo nə. ");
INSERT INTO yam_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ànə geŋ Jisòs yuk də wo bɛ' fis nà' mʉmvwe' ndap pìriyà àwo nə laŋ. Yi lap kɛ'cà nà' tə̀tè yi kə tseŋ nà', nə fek nà' də, <<Wù dzəm bohòyi Mo Ŋwè à?>> ");
INSERT INTO yam_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ŋgà' nə dʉk də, <<Tà, Mo Ŋwè nə yè'sə ndà ya mʉ dzəm bohòyi ɛ.>> ");
INSERT INTO yam_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisòs dʉk fa fəsə yi də, <<Wù yə yi laŋ. Wù sə cèp yè'sə sə̀' wenə.>> ");
INSERT INTO yam_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yi à yuk mvə̀'nə̀ Jisòs dʉk vɛ'nə fana yi dʉk də, <<Tà, mʉ̀ dzəm bohòwù.>> Yi à dʉk vɛ'nə, nə təəŋ sə nze kə̀ mantombìi Jisòs anə bə tumfərə. ");
INSERT INTO yam_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisòs nə cep də, <<Mʉ̀ à və̀ sə nzeŋgòŋ fɛŋ ŋgòsak gàpsə bʉ̀ʉ sə̀ wo dzəm bohòNwì bə sə̀ wo ka bohòyi dzəm. Mʉ̀ à və̀ ŋgògʉ̀ bʉ̀ʉ sə̀ wo ləlohòlis wèeŋ ye bum, nə gʉ sə̀ wo tsəm də wo sə yə bum wèeŋ loho lis.>> ");
INSERT INTO yam_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bʉ̀ʉ Faràsi mok wèŋ sə̀ wo à ye fo' ànə yuk ncèp ènə fana wo fek Jisòs nə də, <<Ye də wù sə dʉk yè'e də vèes ləlohòlis à?>> ");
INSERT INTO yam_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisòs dʉk fəsə fa wo də, <<Anə ye-a də wèeŋ ləlohòlis bwɛ̀rɛ də wèŋ ka nzak tse'. Wèŋ nə sə dʉk nə də lis awèŋ cu fo', də wèŋ sə yə bum bə zeŋ fana ye də wèŋ cu bə nzak mʉ tuhù wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","<<Mʉ̀ sə tsə̀' weŋ zìnə nə̀ nà'a ŋkèm ncèp də, a ye-a ŋga ŋwè dzəm ŋgòni mʉmvwe' ŋka' nsùŋgaŋ, yi me'rə noŋsə ncùu sə, nə kə kok ca mvwe' sə̀ zok fana ye də ŋgə̀ŋgàaŋ ŋgà yə̀. ");
INSERT INTO yam_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ŋwə̀ nə̀ yi ni ye mvwe' ncùu ŋka' sə, yi ganakù' nə yi. ");
INSERT INTO yam_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ŋwə̀ nə̀ yi sə sòŋka' sə nə muk fa ŋwə̀ ànə ncùu ŋka' sə. Nsùŋgaaŋ sə̀ ye sə riŋ ŋgì ye mvə̀'nə̀ yi sə to yà' bə liŋ fana yà' sə yuŋ lo yi mvwe' sə̀ yi sə lòo. ");
INSERT INTO yam_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yi fis və̀ wes yà' sə mbiŋ fana yi to mantombì, nsùŋgaaŋ sə yuŋ yi bʉ̀ʉsə̀ wo rì ŋgì ye nə. ");
INSERT INTO yam_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kaco wo yuŋ lo ŋwə̀ nə̀ yi ŋkʉ̀ìŋ yeŋ. Wo nə caŋ nsàp ŋwə̀ ànə caa bʉ̀ʉsə̀ wo ka ŋgì ye nə riŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisòs ànə mak fa wo gbʉ' ènə fana wo kà bə zeŋ rɛɛ̀ŋ lok. ");
INSERT INTO yam_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ànə geŋ fana Jisòs nə dʉk fa wo də, <<Mʉ̀ sə tsə̀' weŋ zìnə nə̀ nà'a ŋkèm ncèp dʉk də mʉ yè'e ncùu ŋka' nsùŋgaaŋ sə. ");
INSERT INTO yam_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bʉ̀ʉ mok sə̀ wo à və̀ to mantombìi mʉ̀ yà'a pwe'fo' ŋgàa yə̀ wèŋ, nsùŋgaaŋ sə wèŋ kà wo sə̀ yuk təp. ");
INSERT INTO yam_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mʉ ncùu sə mʉ̀. Ŋwə̀ nə̀ yi ni cà-a bohòmʉ̀ fana ŋgə̀ŋgàŋ kà ŋgə' mok yə. Yi nə sə nikok, nə sə tesə mvə̀'nə̀ yi dzəm. Yi nə ye ŋgaŋ co yi zʉ, nə zʉ, nə ze'. ");
INSERT INTO yam_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ŋgà yə̀ə və̀gə̀ ye ŋgòyə̀ə, nə zə, nə ye ŋgògʉ̀ bʉpsə bʉpsə. Bohòmʉ̀ yàm, mʉ̀ a və̀ də ya bwìiŋ tse' lùŋ, də ya wo tse' lùŋ ènə nduk nə̀ nduk. ");
INSERT INTO yam_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","<<Mʉ ganakù' nə̀ bə̀boŋ nə. A ye-a də ŋwèe ganakù' nə̀ bə̀boŋ fana yi nə dzəm də yi kpʉ mʉ tuhù nsùŋgaaŋ ye sə. ");
INSERT INTO yam_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ŋwə̀ nə̀ yi sə fàk ye də ya wo lak yi mbàm, yi ka ganakù' nə yi yeŋ, nə kà ŋgà nsùŋgaaŋ sə sə̀' ye fana yi sə fàk mègù ye mbàam ye. Nsàp ŋwə̀ ànə yə-a ŋga nàm nə̀ bʉp sə və̀ə, yi so bo bə caŋ, nə me'rə tes nsùŋgaaŋ sə fo'. Nàm nə̀ bʉp nə nə ko zʉ nsùŋgaaŋ mok, nə bɛ' samsə mok. ");
INSERT INTO yam_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ŋwə̀ nə̀ wo sə làk yi ye mbàm ènə ca vɛ'nə bʉ̀ʉsə̀ ka yi bə nsùŋgaaŋ sə yaaŋ, yà' ka sə̀ ye ndzə bohòyi yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mʉ ganakù' nə̀ bə̀boŋ nə. Mʉ̀ rì nsùŋgaaŋ am, wo riŋ mʉ yàwo sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Yà' mègù co mvə̀'nə̀ Tɛ̀' am rì mʉ, mʉ̀ riŋ yi sə̀'. Mʉ yàm yəyərə̀ ŋgòkpʉ mʉ tuhù nsùŋgaaŋ sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mʉ̀ tse' nsùŋgaaŋ am mok sə̀ wo ka bə bòp nè'e mvwe' mò'fis cum. A bə̀boŋ də mʉ jəŋ benə və tsoŋ wo mvwe' mò'fis. Wo nə yuk ŋgì àm fana wo benə mvwe' mò'fis, nə tse' sə̀' ganakù' nə̀ mò'fis. ");
INSERT INTO yam_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","<<Tɛ̀' am dzəm mʉ bʉ̀ʉsə̀ mʉ̀ sə dzəm də yòŋsə̀ àm nə lo gɛsə ntɛ̀ŋ ya a kə̀ lə̀sə nùu, mʉ tse' fe'lə nà' sə̀mok. ");
INSERT INTO yam_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ka də ŋwə̀ nəmòk sə fèp jə nà' ndzə bohòmʉ̀ anə bə ŋàŋ yeŋ. Mʉ̀ mè'rə nà' mʉ̀ bə bo am. Mʉ̀ tse' ŋàaŋ sə̀ co mʉ̀ fis me'rə yòŋsə̀ àm nə, nə tse' ŋàaŋ sə̀ aco mʉ te' lokoksə fe'lə nà' sə̀'. Tɛ̀' am nə a fa ŋàŋ yi də mʉ gʉ vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yi ànə cep vɛ'nə fana bʉ̀ʉ Jus wèŋ sə̀ wo à yuk ncèp ènə wèŋ à gà'a bòp ba. ");
INSERT INTO yam_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bòp ma mòk à sə dʉk də, <<Ŋgà' ànə ŋgà ŋaŋ, yi tse' yòŋsə̀ ze' ndzə ni'ì yi. Vesùwèŋ sə yu'rə yiskok bohòyi yè'sə yà?>> ");
INSERT INTO yam_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bʉ̀ʉ mok sə dʉk yàwo də, <<A ye-a ŋga ŋwè tse' yòŋsə̀ ze' ndzə ni'ì yi, kaco yi cep to nsàap bum sə̀ ŋwə̀ nè'e sə cèp yè'e lɛ yeŋ. Aco yòŋsə̀ maze' muk to fa bwìŋ lis yè'sə va?>> ");
INSERT INTO yam_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mvə̀k ànə dzeŋ nə̀ ŋgògʉ̀ ŋkà'a sə̀ bʉ̀ʉ Jus wèeŋ togə̀ yà' də Hànukà. Ànə ye mvə̀k mbʉ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mvə̀k ànə à ye nùmbu mòk ŋga Jisòs sə gìhi kɛ'cà sə mandap Nwì nə̀ ghaŋ nə. Wo à sə to mʉmvwe' nə̀ yi à sə gìhi fo' nə də, <<Mbandap nə̀ Sòlomù.>> ");
INSERT INTO yam_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bʉ̀ʉ Jus wèŋ ànə kə maŋ fo' sə̀'. Wo fek yi də, <<Wù dzəm də vèes cum mam kəko' və̀m vɛ'nə tə̀tè kə dzeŋ sè ŋkuŋ ɛ? A ye-a də wu Ŋkum ŋgà gèm bwìŋ nə, wù tsok rɛŋsə fa-a ves le.>> ");
INSERT INTO yam_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisòs dʉk fa wo də, <<Mʉ̀ a tsə̀' weŋ laŋ, megu də wèŋ kà mʉ dzəm fa. Fàak sə̀ mʉ̀ sə gʉ̀ yà' bə liŋ Tɛ̀' am sə, sə nìtsə̀' fa weŋ nsàp ŋwə̀ nə̀ mʉ̀ cu nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bə yà'sə pwe', wèŋ sə kà mʉ də mʉ Ŋkum nə dzəm fa bʉ̀ʉsə̀ wèŋ ka nsùŋgaaŋ am yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nsùŋgaaŋ sə̀ yàm rì ŋgì àm. Mʉ̀ riŋ wo sə̀', fana wo sə bɛ' və mʉ. ");
INSERT INTO yam_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Wo bɛ' və̀ mʉ vɛ'nə, mʉ̀ fa wo lùŋ nə̀ nà'a nə̀ kà mè yuk. Wo nə kà sə̀ kpʉ yuk. Kaco ŋwə̀ nəmòk fep fis to wo ndzə bohòmʉ̀ anə sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tɛ̀' am nə̀ yi a fa yà' ndzə bohòmʉ̀ nə, yi yam càsə ndàaŋwè pwe' yi. Ye də kaco ŋwə̀ nəmòk fep fis to wo ndzə bohòTɛ̀' am nə yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","A vɛ'nə bʉ̀ʉsə̀ mʉ̀, ves Tɛ̀' am nə, vès mègù mò'fis.>> ");
INSERT INTO yam_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ sə à yuk mvə̀'nə̀ yi cèp vɛ'nə fana wo te' lìs sə̀mok də wo təm zə yi fo'. ");
INSERT INTO yam_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisòs a yə vɛ'nə, yi dʉk fa wo də, <<Wèŋ a yə fàak sə̀ bə̀boŋ sə̀ mʉ̀ a gʉ̀ yà' bə liŋ Tɛ̀' am laŋ. Bum sə̀ mʉ̀ a gʉ̀ yà'sə pwe', nə̀ nà'a bʉp nə̀ wèŋ sə də wèeŋ təm zə mʉ bʉ̀ʉ zeŋ nə yè'e nə̀ fò?>> ");
INSERT INTO yam_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bʉ̀ʉ sə wèŋ də, <<Vès sə kà wu bʉ̀ʉ bum sə̀ bə̀boŋ sə̀ wù a gʉ̀ʉ təm zə. Vès də vèes zə wu njo nə̀ wù sə gʉ̀ bʉpsə liŋ Nwì. Wù mègù ŋwè nə̀ ŋwè wà, wù sə lap də wu gʉ ni' yòdə wu Nwì bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisòs dʉk fa wo də, <<Wo à còm nòŋsə yà' ndzənə ŋwàk lʉ̀ʉk awèŋ də, <Mʉ̀ʉ Nwì, mʉ̀ dʉk də wèeŋ nwì wèŋ.> ");
INSERT INTO yam_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Vesùwèŋ rì sə̀' də ŋwàk Nwì nə nà'a zìnə, nà'a kà kupsə̀gə̀. Ye də a ye-a ŋga Nwì dʉk də bʉ̀ʉ sə̀ wo yuk ncèp ye nə wèeŋ sə̀' co yi, ");
INSERT INTO yam_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","njo nə̀ mʉ dʉk yàm də mʉ̀ʉ mo Nwì, wèŋ sə də mʉ̀ gʉ̀ bʉpsə liŋ Nwì nə bʉ̀ʉ yà? Mʉ̀ nə̀ Tɛ̀' am nə a cok noŋsə mʉ, nə tumsə vesə sə nzeŋgòoŋ fɛŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","A ye-a də mʉ̀ sə kà nsàap fàak Tɛ̀' am sə gʉ̀, wèŋ kà mʉ dzəm fa anə ntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","A ye-a ŋga wèŋ yə də mʉ̀ sə gʉ̀ fàak sə̀ Tɛ̀' am sə fana ye də wèeŋ sə dzəm bohòmʉ̀ bʉ̀ʉ fàak sə, ŋga wèŋ sə dzèeŋ-a yusə̀ mʉ̀ sə cèep sə na. Yà'a ye vɛ'nə fana wèŋ rɛɛŋ də Tɛ̀' nə bə Mo ye nə mò'fis, Mo nə ye bwi bə Tɛ̀' nə sə̀' mò'fis.>> ");
INSERT INTO yam_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bʉ̀ʉ sə wèŋ lap də wo ko yi fana Jisòs swɛ'ɛ tesə ndzə bohòwo wà. ");
INSERT INTO yam_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ànə geŋ Jisòs bwi foho lo, nə kə to fe'lə ndzəp Jòridàŋ. Yi lo, nə kə cum mvwe' sə̀ Jon à sə bàptɛsə to bwìŋ fo' yà'a. ");
INSERT INTO yam_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bwìŋ à kə̀ tsèŋ yi fo' vɛ'ɛ wùriŋ. Bʉ̀ʉ sə wèŋ sə dʉhʉ də, <<Jon à ka maŋgəŋgèŋ mòk co nà' gʉ ves a tsəm də a tumsə və̀ yi Nwì gʉ yuk. Megu kə də bum sə̀ yi Jon nə à cèp yà' bə liŋ ŋwə̀ nè'e pwe'fo' a bʉ̀ʉŋ və̀ zìnə laŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ànə geŋ bwìŋ dzəm bohòJisòs fa'nə ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ŋwə̀ nəmòk à ye mvwe' lak Betanì nə̀ liŋ ye à ye də Lasorò. À ye nùmbu mòk yiyaŋ ko yi. À ye ŋga yi tse' njɛ̀'ɛ ye ba. Liŋ awo à ye də Matà bə Mèri. Njɛ̀'ɛ ye sə à sə cugə̀ sə̀' mvwe' lak Betanì anə. ");
INSERT INTO yam_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mèri nə̀ moma ye Lasoròà sə ya ènə, a yi nə̀ yi à yok Tà Jisòs bə làmindà, nə sə yisə fa nà' kù bə nʉ̀əmtu ye nà'a. ");
INSERT INTO yam_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bʉsə̀ Lasoròà sə ya fana Mèri bə Matà tirə gesə lo Jisòs də, <<Tà, ŋge' ntʉm yòLasorònòyiya nə̀ bʉp.>> ");
INSERT INTO yam_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisòs nə ànə yuk ntirə̀ ènə fana yi dʉk də, <<Yiya ènə nə kà bə kpʉ kə̀ lə̀. Yiya ènə və̀ də ya bwìiŋ nə ye ŋàaŋ Nwì bə zeŋ fana nə ye ŋàaŋ Mo Nwì nə sə̀' bə zeŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisòs à dzəm Matà bə moma ye Mèri, nə ye Lasoròsə̀'. ");
INSERT INTO yam_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mvə̀'nə̀ yi à yuk ntirə̀ nə̀ də Lasorònòyiyaŋ fana yi cum mam mali mvwe' sə̀ yi à ye sə mʉnə nùumbu ba sə̀ ŋkuŋ. ");
INSERT INTO yam_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nùumbu sə̀ ba sə à càa fana yi dʉk fa ŋgàa fàak ye sə wèŋ də, <<Vesùwèeŋ bwi foho lo fe'lə mvwe' nze Jùdiyà sə̀mok.>> ");
INSERT INTO yam_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ŋgàa fàak ye sə wèŋ mərə. Wo də, <<A ndòmòk kènə Cicà, bʉ̀ʉ Jus wèŋ a də wo təm zə wu fa'nə bə lìs, wù də a bwi foho lo fo' sə̀ ŋkuŋ ŋgòlàp yà?>> ");
INSERT INTO yam_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisòs dʉk də, <<Tsok rɛŋgə̀ nə̀ zəzòŋ haaŋ nùm kə ca co. Ŋwə̀ nə̀ yi gì-a ŋga cu lì ntòmarɛŋ, yi nə kà nduk gbʉ̀, bʉ̀ʉsə̀ marɛŋ nə̀ sə nzeŋgòŋ nə nà'a bohòyi yo. ");
INSERT INTO yam_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ŋwə̀ nə̀ yi gì ye ndzəmə̀ fana yi nə gbʉ bʉ̀ʉsə̀ yi ka marɛŋ tse'.>> ");
INSERT INTO yam_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yi ànə cep wes vɛ'nə fana yi naaŋ gesə fe'lə mòk sə̀' də, <<Ŋge' àvès Lasoròsə dzəm lo. Mʉ nə geŋ fo' ŋgòyə̀msə yi.>> ");
INSERT INTO yam_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ŋgàa fàak ye sə wèŋ dʉk də, <<Tà, a ye-a də lo ko yi laŋ, ye də yiya ye nə nə me.>> ");
INSERT INTO yam_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Wo à sə dʉk vɛ'nə ŋga wo sə tsəm yàwo ŋgwàaŋ də Jisòs də Lasoròsə dzəm lo nə̀ bwìiŋ dzəmgə̀ nà'a. Kàmfirə Jisòs dʉk ye'e də Lasoròkpʉ ciŋ nə̀ ciŋ. ");
INSERT INTO yam_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ànə geŋ Jisòs tsok rɛŋsə fa wo mok jəja də, <<Lasoròkpʉ laŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yi dʉk fe'lə sə̀' də, <<Mʉ̀ sə kwa də mʉ̀ a ka fo' ye bʉ̀ʉsə̀ bum yè'sə rɛŋsi bohòwèŋ bʉ̀ʉsə̀ yà'a nə gʉ weŋ ŋgònaaŋ tu bohòmʉ̀.>> Fana yi dʉk ləsə də, <<Wèeŋ lokok, a lo kə ye yi.>> ");
INSERT INTO yam_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomos nə̀ wo à sə togə̀ yi də, <<Mofɛs>>, nə̀ yi sə̀' mo fàk Jisòs nə dʉk fa mok sə wèŋ də, <<Wèeŋ ca, a bɛ' lo yi ya a kə kpʉ vesi wèŋ bəbɛ'.>> ");
INSERT INTO yam_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisòs à kə̀ dzèŋ Betanì anə fana wo tsok yi də a ntinə nùumbu kwè mvə̀'nə̀ wo a tuuŋ Lasorò. ");
INSERT INTO yam_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Bʉ̀ʉ Jus wèŋ à ye'e Jòrosalèm, nə və Betanì anə vɛ'ɛ ŋkʉ̀ʉŋntɛ̀ŋ ŋgòkə̀ cèpsə Matà bə Mèri kpʉ moma awo nə. Ŋgòyè'e Jòrosalèm, nə lo Betanì ka sə̀sap yeŋ. Yà' mègù co kìlometà tɛ' vɛ'ɛ. ");
INSERT INTO yam_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Matà à yuk də Jisòs sə və̀ə fana yi tesə, nə kə tseŋ nà' mandzə̀. Mèri à cu mam ye mʉ nda'à. ");
INSERT INTO yam_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matà ànə ye Jisòs fana yi dʉk fa nà' də, <<Tà, a ye-a də wù a ye-a fɛn, də bwɛ̀rɛ moma am a ka kpʉ. ");
INSERT INTO yam_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Fana mʉ̀ rì sə̀' də, a mègù-a sə̀ ŋga'a nè'e aco Nwìi nə fa wu yusə̀ wù fek yi yà' pwe'fo'.>> ");
INSERT INTO yam_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisòs dʉk fa nà' də, <<Moma yo Lasoròo nə lokok mvwe' kpʉ sə.>> ");
INSERT INTO yam_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Matà nə dʉk də, <<Mʉ̀ rì də nùmbu nə̀ nzeŋgòŋ nə nə me ŋga ndàaŋwè pwe' sə lokok mvwe' kpʉ fana yi nə lokok ye sə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisòs dʉk də, <<Mʉ ŋwə̀ nə̀ mʉ lòkoksəgə̀ bwìŋ mvwe' kpʉ, nə ye də mʉ gʉ̀gə̀ də bwìiŋ cum ŋwʉm sə̀' mʉ̀. Ŋwə̀ nə̀ yi dzəm-a bohòmʉ̀, a ye-a sə̀ də yi kpʉ laŋ fana yi nə̀ cum malì fo' ŋwʉm. ");
INSERT INTO yam_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ŋwə̀ nə̀ yi cu-a ŋwəm, nə dzəm bohòmʉ̀ fana ŋgə̀ŋgàaŋ nə kà kpʉ yuk. Wù dzəm laŋ də ncèp ènə zìnə à?>> ");
INSERT INTO yam_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Yi dʉk fa Jisòs nə də, <<A zìnə Tà. Mʉ̀ dzəm laŋ də wu Ŋkum ŋgà gèm bwìŋ nə ye Mo Nwì, nə̀ Nwì à dʉk də yi nə̀ tum vèsə sə nzeŋgòŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matà nə ànə cep wes vɛ'nə fana yi lo, nə kə to moma ye Mèri. Yi larə fa Mèri nə də, <<Cicà və̀ laŋ, yi sə to wu.>> ");
INSERT INTO yam_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mèri ànə yuk vɛ'nə fana yi kurə lokok nə̀nàk, nə kə tseŋ Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ànə ye yà'sə ŋga Jisòs ka mʉ ntòlak anə ntòkə ni. Yi à cu ntòmvwe' sə̀ Matà anə kə tseŋ yi sə. ");
INSERT INTO yam_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bʉ̀ʉ Jus sə̀ bə yà'wèŋ à cu mʉ nda'à, sə̀ wo à və̀ ŋgòcèpsə wo kpʉ sə à yə mvə̀'nə̀ Mèri à kurə tesə fana wo yuŋ yi. Wo à bɛ' lòyi bʉ̀ʉsə̀ wo à sə tsəm də kàmòk yi sə lòŋgòkə̀ wa mvwe' sèe Lasoròsə. ");
INSERT INTO yam_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mèri nə à lò, nə kə dzeŋ mvwe' sə̀ Jisòs cu sə. Yi à yə Jisòs nə fana yi gbʉ tsoŋ sə ŋgʉ kùu nà' anə sə nze, nə sə cep də, <<Tà, wù anə ye-a fɛŋ bwɛ̀rɛ moma am a ka kpʉ.>> ");
INSERT INTO yam_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisòs ye mvə̀'nə̀ Mèri sə wa. Bʉ̀ʉ mok sə̀ wo à ye fo' bə Mèri nə wèŋ sə waŋ kɛ' sə̀' ŋgùŋ fana ntʉm bʉp yi vɛ'ɛ wùriŋ co wù kà fʉ̀'. ");
INSERT INTO yam_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yi fek yà' də, <<Wèŋ a tuuŋ yi ma fò?>> Wo dʉk də, <<Tà, və̀ə kə̀ ja'a yòo mvwe' sə ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisòs waŋ. ");
INSERT INTO yam_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bʉ̀ʉ sə̀ wo à ye fo' sə wèŋ à yə vɛ'nə fana wo dʉk də, <<Wèeŋ ja'a na yàwèeŋ mvə̀'nə̀ yi a dzəm Lasorònə ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bòp bʉ̀ mòk sə dʉk yàwo də, <<Nè'e ka yi nə̀ yi a mùk fa ŋgà' nà'a lis nə yeŋ à? Anə ye co yi kà də Lasorònə kà kpʉ gʉ̀ à?>> ");
INSERT INTO yam_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ntʉm à bʉp malì Jisòs nə wùriŋ sə̀mok fana yi lo mvwe' sə̀ wo a tuuŋ Lasoròsə. Sèe sə à ye co mvòk, wo jəŋ lìs, nə dzərə lok ncùu sə bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","À wɛ̀s fo' Jisòs dʉk fa wo də, <<Wèeŋ dzərə fis gɛsə lìs ànə fo'.>> Matà nə̀ yi njɛ̀'ɛ Lasorònə̀ yi a kpʉ nə dʉk də, <<Anə rəm nə̀ bʉp Tà. Wù rì də a ntinə nùumbu kwè mvə̀'nə̀ wo a tuuŋ yi.>> ");
INSERT INTO yam_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisòs dʉk fa yi də, <<Mʉ̀ anə tsok fa wu fa' də wu dzəm-a bohòmʉ̀, wù ye ŋàaŋ Nwì bə lis àlaa.>> ");
INSERT INTO yam_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wo dzərə fis lìs nə. Jisòs bʉʉŋ kʉk gesə lo mʉbu, nə dʉk də, <<Mʉ̀ kwasə wu Tɛ̀', bʉ̀ʉsə̀ wù yuk mʉ laŋ. ");
INSERT INTO yam_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mʉ̀ rì sə̀' də wu yukgə̀ mʉ ghà nə̀ fòlòoŋ. Megu də mʉ̀ sə cèp nə̀ ŋga'a nè'e njo tu bʉ̀ʉ sə̀ wo tərə yè'e, də ya wo dzəm zìnə də wù a tum və̀ mʉ tsenə anə wù.>> ");
INSERT INTO yam_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yi ànə cep wes me vɛ'nə fana yi cep fe'lə mok bə ŋàŋ də, <<Lasorò, lòkok tesə və.>> ");
INSERT INTO yam_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasorònə̀ yi à kpʉ nə lokok tesə və sə̀ ghà ànə. À ye ŋga wo kì bo ye bə kùu ye wèŋ bə cə̀k. Wo à kì lok si ye bə cə̀k sə̀'. Jisòs nə dʉk fa bʉ̀ʉ sə̀ wo ye fo' sə wèŋ də, <<Wèeŋ fiŋ me'rə yi lo.>> ");
INSERT INTO yam_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bʉ̀ʉ sə̀ wo à bɛ' lòMèri sə pwe'fo' à ye bum sə̀ Jisòs à gʉ̀ sə fana bwìŋ ŋkʉ̀ʉŋ dzəm bohòJisòs nə. ");
INSERT INTO yam_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ànə geŋ bʉ̀ʉ mok wèŋ ye'e jəŋ fo', nə kə tseŋ bʉ̀ʉ Faràsi wèŋ, nə tsoho fa yà' bum sə̀ Jisòs gʉ̀ʉ sə làaŋ. ");
INSERT INTO yam_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wo à yuk yà' fana bʉ̀ʉ Faràsi sə bə ŋgàa fa satikà' sə̀ ghaŋ wèŋ to benə bʉ̀ ŋkwàha bʉ̀ʉ Jus sə fo', bə yà'wèŋ kə cum yiskok kaŋsurù. Wo à kə̀ cu fana wo dʉk də, <<Vesùwèeŋ nə gʉ va? Bʉsə̀ wèŋ rì də ŋgà' ànə sə gʉ̀hʉ bum maŋgəŋgèŋ vɛ'ɛ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","À ye-a ŋga a mè'rə yi də yi sə gʉ mali vɛ'nə fana anə kà tə̀tè ye ŋga bwìŋ pwe'fo' bʉʉŋ dzəm wes bohòyi də yi Ŋkum ŋgà gèm bwìŋ nə zìnə laŋ. A kə̀ ye-a vɛ'nə fana a riŋ də ŋgə' kə̀ tsèŋ ves laŋ bʉ̀ʉsə̀ bʉ̀ʉ lak Rumà wèeŋ nə və kə kʉəmsə mak ndap Nwì àvès nə, nə bʉpsə lak avès sə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ŋwə̀ nəmòk à ye fo' nə̀ liŋ ye à ye də Kayofàs. Yi ànə ye ŋkum ŋgà fa satikà' ghà ànə yi. Yi à lòkok ye, nə cep də, <<Bʉ̀ʉ am, wèŋ ka yusə̀ yà' cu sə tsətsə'rə̀ fɛɛŋ riŋ! ");
INSERT INTO yam_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","A ye-a bə ŋkərə̀ nə̀ njàwèŋ, wèŋ tsəm də ka bə̀boŋ də ŋwə̀ nə̀ mò'fis kpʉ lɛ yi nə noŋsə bwìŋ pwe' tsəm à? Kè bòghak weŋ yàwèŋ də wo zə wes lak àvès sə pwe' ɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Bum sə̀ yi à cèp yè'sə, yi à ka yà' yi tsərə kok, à ye ŋga yà' à və̀ mʉ cùhù yi anə bohòNwì, yi sə cep, nə kà sə rì. Yè'sə ànə sə ye vɛ'nə ŋga Kayofàs cu ŋkum ŋgàa fa satikà' bə mvə̀k ànə yi. Yi à tsə̀' bwìŋ yà'sə yumok sə̀ yà'a nə̀ ye ntsə'mòk. Yusə də Jisòos nə̀ kpʉ mʉ tuhù bʉ̀ʉ Jus wèŋ pwe'. ");
INSERT INTO yam_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yi nə̀ kà bʉ̀ʉ tu bʉ̀ʉ Jus wèŋ woòwo kpʉ mègù. Yi nə kpʉ bʉ̀ʉ tu bwe Nwì sə̀ wo cu lòma nə̀ fòpwe', də ya yi jəŋ benə və yà' mvwe' mò'fis. ");
INSERT INTO yam_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ncèp Kayofàs ènə à gʉ̀ fana ye jəŋ nùmbu ànə, bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ sə lap mandzə̀ ŋgòzə Jisòs. ");
INSERT INTO yam_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ànə ye vɛ'nə, Jisòs kà mvwe' nze Jùdiyà anə mok jəja sə gì fe'lə̀. Yi à mè'rə fa'nə, nə lo mvwe' lak mok sə̀ wo to fo' də Efə̀rèm. Lak yè'sə fo' ŋgəà fana Jisòs bə ŋgàa fàak ye wèŋ sə cum mok fo'. ");
INSERT INTO yam_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Bum yè'sə à ye ŋga mvə̀k ŋkàha Pasobà bʉ̀ʉ Jus wèŋ à sə kʉəp və̀ə. Bʉ̀ʉ Jus sə wèŋ sə kpəəŋ tesə mvwe' buhu lak awo, nə sə kok lo Jòrosalèm anə. Wo à sə lòŋgòkə̀ gʉ̀ rɛŋsə ni' awo mvə̀'nə̀ wo gʉ̀gə̀ə ŋkuŋ ŋkàha sə kə dzeŋ. ");
INSERT INTO yam_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","À ye yè'sə ŋga wo à sə làp Jisòs gʉgʉŋ. Wo à kə̀ kʉ̀rə mʉmvwe' ndap Nwì nə̀ ghaŋ nə fana wo sə mərə də, <<Wèŋ yə va? Sə yəəŋ co yi nə kà mvwe' ŋkàk ènə və̀ kènə da?>> ");
INSERT INTO yam_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mvə̀k ànə à ye ŋga ŋgàa fa satikà' sə̀ ghaŋ bə bʉ̀ʉ Faràsi wèŋ à fa ŋàŋ laŋ də a ye-a ŋga ŋwə̀ nəmòk riŋ mvwe' sə̀ Jisòs cu, nà' kə tsok ya wo kə ko nà' fo'. ");
INSERT INTO yam_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","À bwehe cu mègù mok nùumbu ntùŋfu ya ŋkàha Pasobà sə kʉrə fana Jisòs ye'e lo fe'lə mvwe' lak Betanì sə̀mok, sə̀ a fo' lak Lasorònə̀ Jisòs à lòkoksə yi mvwe' kpʉ nə. ");
INSERT INTO yam_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","À kə̀ dzèŋ fo' fana wo gʉ fa Jisòs bə ŋgàa fàak ye wèŋ dinà. Matà à ye fo', nə sə casə zʉzʉʉ sə. Lasoròà ye sə̀' mòk nə̀ bə Jisòs wèŋ à zʉ fo' bəbɛ' bə bʉ̀ʉ mok wèŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mvə̀'nə̀ wo ànə sə zʉ fana Mèri wɛhɛ və ye sə̀'. Yi à tse' və̀ bə làmindà mok sə̀ yà'a rə̀m bòŋsəgə̀ vɛ'ɛ wùriŋ. Wo à gʉ̀ nsàp làmindà anə bə nsàp nzàamŋgaŋ mòk nə̀ wo togə̀ nà' də, <<Nad.>> Yi à tse' və̀ yà' co botòròmò'fis vɛ'ɛ ŋga yà' gʉ ntɛŋ vɛ'ɛ sə̀' wùriŋ. Yi jəŋ yà', nə fe' fa Jisòs mʉ kùhu, nə sə yisə kùu nà' sə bə nʉ̀əmtu ye. Ndap nə pwe' à rə̀m sàaŋ tə mègù mok làmindàa sə. ");
INSERT INTO yam_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ànə geŋ mo fàk Jisòs mòk nə̀ liŋ yee Judàs Iskarəyà, sə̀ yi nə̀ yi nə seŋ Jisòs nə à dʉk də, ");
INSERT INTO yam_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","<<Kàcò, làmindàa yè'sə co bàam mbàm tɛ'. Anə boŋ ghak co wo seŋ yà', nə fa ŋgàa jìŋ wèŋ mbàam sə.>> ");
INSERT INTO yam_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yi ànə cep yè'sə, ka də bʉ̀ʉsə̀ də yi tse' ntʉm nə̀ bə̀boŋ bohòŋgàa jìŋ wèŋ yeŋ. À ye bʉ̀ʉsə̀ yi ŋgà yə̀. Yi à sə lòksəgə̀ mbàam awo yi fana yi sə yə fis zʉ swihi mok ca. ");
INSERT INTO yam_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jisòs dʉk ye də, <<Wèeŋ mè'rə yi. Yi nòŋsə làmindàa yè'sə ŋgòyok fa mʉ bə mvə̀k nə̀ wo nə tuuŋ mʉ. ");
INSERT INTO yam_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Weŋ ŋgàa jìŋ wèeŋ nə sə yenə mali riŋ, riŋ, fana mʉ̀ kà yàm vesùwèŋ nùumbu pwe' sə yiskok.>> ");
INSERT INTO yam_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bwìŋ à yuk də Jisòs cu Betanì fana bʉ̀ʉ sə̀ wo à kə̀ benə Jòrosalèm sə wèŋ kpəəŋ və fo'. Ka də wo à və̀ mègù yè'sə də wo dzəm ŋgòyə mègù Jisòs yeŋ. Wo à sə dzəm də wo ye ja'a Lasorònə̀ Jisòs à lòkoksə yi mvwe' kpʉ nə. ");
INSERT INTO yam_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mvə̀'nə̀ yà' à ye vɛ'nə fana ŋgàa fa satikà' sə̀ ghaŋ wèŋ sə làp mandzə̀ də wo zə Lasorònə. ");
INSERT INTO yam_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Wo də wo zə yi bʉ̀ʉsə̀ bwìŋ à sə mè'rə ma njàwo, nə sə dzəm mok bohòJisòs bʉ̀ʉ tu Lasorònə. ");
INSERT INTO yam_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tsok à rɛŋ, bʉ̀ʉ sə̀ wo anə maŋ mvwe' lak Jòrosalèm, ŋga wo à və̀ mvwe' ŋkàk sə wèŋ yuk də Jisòs sə və̀ sə̀' Jòrosalèm anə. ");
INSERT INTO yam_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Fana wo gbɛ' jəŋ maŋteŋ, nə lo kə tseŋ yi mandzə̀. Wo sə yəm fuŋ də, <<Hòsanà; wèeŋ ja'a ŋwə̀ nə̀ yi sə və̀ mʉnə liŋ Tà Nwì, Nwìi gʉ yi bə̀boŋ. Wèeŋ ja'a ŋkum bʉ̀ʉ Jus wèŋ, vesùwèeŋ kuksə yi.>> ");
INSERT INTO yam_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yè'sə ànə sə ye ŋga Jisòs anə lap ye mvomndè' mòk, nə kok cum və yuye mbwa. Yà' à mègù mvə̀'nə̀ wo à còm nòŋsə yà' ndzənə ŋwàk Nwì də, ");
INSERT INTO yam_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","<<Ntòlak Zayòŋ, wèeŋ kà wəp. Ŋkum awèŋ sə və̀ə. Yi sə kok cu və̀ mʉnə mvomndè'.>> ");
INSERT INTO yam_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ghà nə̀ bum yè'sə à sə ye sə lòoŋ, ŋgàa fàak ye sə wèŋ kà bə zeŋ sə rɛɛŋ lok. Yà' à kə̀ rɛɛŋ mègù bohòwo ghà nə̀ Jisòs à lòkok mvwe' kpʉ nə kə ye ŋwə̀ nə̀ ghaŋ nə. Yà'a mvə̀k nə̀ wo à tsərə fəsə də wo à còm nòŋsə yà' ndzənə ŋwàk Nwì də bum yè'sə nə kə ye vɛ'nə fana yà' nə yeè nə sə̀' vɛ'nə anə. ");
INSERT INTO yam_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bʉ̀ʉ sə̀ wo à ye sə nze mvwe' sə̀ Jisòs à lòkoksə Lasoròmvwe' kpʉ sə wèŋ à lò, nə sə tsoho lo fa kɛ' bwìŋ yusə̀ wo a yə sə. ");
INSERT INTO yam_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nà'a njo nə̀ bwìŋ à və̀ ŋgòkə̀ tsèŋ Jisòs nə vɛ'ɛ wùriŋ bʉ̀ʉsə̀ wo à yuk nsàp maŋgəŋgèŋ nə̀ nà' à gʉ̀ʉ nə. ");
INSERT INTO yam_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bʉ̀ʉ Faràsi wèŋ à yə mvə̀'nə̀ bwìŋ sə kpəəŋ yù lòJisòs nə fana wo də, <<Vesùwèŋ sə càsə mvə̀k fɛɛŋ wà a ŋgàk, wèeŋ ja'a-a yàwèeŋ mvə̀'nə̀ maŋgòŋ sə yù yi ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mvə̀k ŋkàk ànə à ye, bʉ̀ lakmvum mok wèŋ à və̀ Jòrosalèm ŋgòkə̀ kùksə Nwì mbwa. ");
INSERT INTO yam_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bʉ̀ʉ yè'sə wèŋ à kə̀ tsèŋ ŋgà fàk Jisòs mòk nə̀ wo to yi də Filìp nà'a. Lak Filìp nə à ye Bèsadà nə̀ nà'a mvwe' nzeŋgòŋ Galìli. Wo dʉk fa nà' də, <<Tɛ̀'mòk, vès dzəm də vèes ye Jisòs ya vesi wèeŋ taaŋ gesə mweè jo.>> ");
INSERT INTO yam_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filìp à lò, nə kə tsok fa Andrù, fana bə nà' ye'e ŋga'a bwìŋ ba fo', nə kə tsok fa Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisòs à yè ŋgòtsòho fa wo də, <<Mvə̀k nə kə̀ dzèŋ laŋ nə̀ Nwìi nə niŋtsok fa bwìŋ də mʉ̀ʉ mo ŋwè, mʉ ŋwə̀ nə̀ ghaŋ. ");
INSERT INTO yam_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mʉ̀ sə tsə̀' weŋ nè'e ŋkèm ncèp dʉk də, A ye-a ŋga mvə̀m gòmbì ka sə nze co nà' kpʉ kpʉ nooŋ, ye də nà'a nə cum mam megu mvə̀m nə̀ mò'fis nə. Nə ye də a ye-a ŋga nà' nòoŋ sə nze co nà' kpʉ laŋ, nə to fana nà'a nə tse' fe'lə mvə̀əm mok ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yusə də, ŋwə̀ nə̀ yi dzəm-a yòŋsə̀ ye, ye də yi nə bisə bə zeŋ wà. Fana ŋwə̀ nə̀ yi bɛ̀ŋ-a yòŋsə̀ ye sə nzeŋgòŋ fɛɛŋ fana ye də yi nə tse' mam yòŋsə̀ ye nə fo' nə̀ mvèsə̀. ");
INSERT INTO yam_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ye də, ŋwə̀ nə̀ yi dzəm-a ŋgògʉ̀ fàak am fana yi yuŋ və mʉ. Mvwe' sə̀ mʉ̀ lòpwe', ŋgə̀ŋgàaŋ nə ye fo' vesi. Ŋwə̀ nə̀ yi dzəm-a ŋgòyù və̀ mʉ də ya yi gʉ fàak am fana Tɛ̀' am nə yamsə yi, yi kuk.>> ");
INSERT INTO yam_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisòs à dʉk mok sə̀' də, <<Ntʉm àm sə fa mʉ ŋgə' ŋga'a vɛ'ɛ wùriŋ. Aco mʉ̀ cèp yè'sə də yà? Aco mʉ dʉk fa Tɛ̀' am də yi yep fis ŋgə' nə̀ nà'a ŋga'a mʉ tuhù mʉ̀ ènə fo' à? Megu ŋga'a kə də mʉ̀ ànə və tsenə fɛɛŋ ŋgòyə ŋgə' ènə. ");
INSERT INTO yam_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","A bə̀boŋ co mʉ nə dʉk fa Tɛ̀' am nə də, <Gʉ̀ lɛ yusə̀ co yà'a nə gʉ də bwìiŋ kuksə liŋ yo.> >> Yi ànə dʉk vɛ'nə fana ŋgì mòk cep vesə mʉbu. Ŋgì nə sə cep də, <<Mʉ̀ a gʉ̀ ya bwìŋ kuksə liŋ am sə laŋ, fana mʉ nə gʉ mali yà' sə̀mok.>> ");
INSERT INTO yam_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bʉ̀ʉ sə̀ wo à mà tə fo' sə à yuk ŋgì nə sə̀'. Mok dʉk də, mbʉ̀ŋ kùm yi. Mok dʉk yàwo də, hai', cèp bohòyi masinjà Nwì. ");
INSERT INTO yam_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisòs dʉk fa wo ye də, <<Ŋgì nə̀ wèŋ yuk ànə, nà' ka bʉ̀ʉ tu am cep, nà' cèp bʉ̀ʉ tu awèŋ. ");
INSERT INTO yam_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mvə̀k kʉ̀rə nə̀ wo nə sak nzeŋgòŋ nə laŋ. Mvə̀k kʉ̀rə nə̀ wo nə bwi' mak gɛsə ŋwə̀ nə̀ yi ŋkum sə nzeŋgòŋ fɛŋ yi nə sə̀' laŋ. ");
INSERT INTO yam_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bohòmʉ̀ yàm, wo fis gesə mʉ mʉtsə̀ fana mʉ̀ soŋ və bwìŋ pwe'fo' bohòmʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisòs à cèp ncèp ènə ŋgònìtsə̀' fa bwìŋ nsàp kpʉ nə̀ yi nə kpʉ nà' nə. ");
INSERT INTO yam_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bʉ̀ʉ sə̀ wo à ye fo' wùriŋ sə wèŋ à dʉk fa yi də, <<Wo à còm nòŋsə yà' ndzənə ŋwàk lʉ̀ʉk avès də Ŋkum ŋgà gèm bwìŋ nə, yi nə cum mam nə̀ mvèsə̀. Wù nə sə dʉhʉ̀ nə sə̀ yòdə wo nə fis kok gesə mo ŋwè mʉtsə̀, ŋga mo ŋwə̀ nə̀ wù sə dʉk ènə ndà?>> ");
INSERT INTO yam_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisòs dʉk də, <<Marɛŋ nə nə cum tse' wenə wèŋ mvə̀k momjo wà. Ghà nə̀ marɛŋ nə cu wenə wèŋ ènə fana a bə̀boŋ də wèeŋ gi sooŋ lo mantombì ya ndzəm kà weŋ kə̀ cì'. Bʉsə̀ ŋwə̀ nə̀ yi gìgə̀ ye sənə mandzəm kà mvwe' sə̀ yi sə nə̀ŋ lòkù sə rìgə̀. ");
INSERT INTO yam_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Wèeŋ dzəm bohòmarɛŋ nə ŋga'a nə̀ nà' cu tse' wenə wèŋ ènə, ya wèeŋ ye bʉ̀ʉ marɛŋ nə wèŋ.>> Jisòs ànə cep wes ncèp ènə fana yi lo gɛsə yuye fo'. ");
INSERT INTO yam_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yi ànə gʉ bum maŋgəŋgèŋ ŋga wo sə yə vɛ'ɛ wùriŋ fana wo kà bohòyi anə sə̀ dzəm malì. ");
INSERT INTO yam_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bum yè'sə à kə̀ ye mègù mvə̀'nə̀ ŋgà tsòhòbum Nwì nə̀ liŋ yee Ìzayà ànə cep mantombì fa' yà'a. Yi ànə cep də, <<Tà, ŋwə̀ nə̀ mò'fis a dzəm fʉ̀' ncèp àvès nə ɛ̀? Yà'a sə̀' də ŋwə̀ nə̀ mò'fis ka ŋàaŋ yo sə sə̀' riŋ lok ɛ̀?>> ");
INSERT INTO yam_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bʉ̀ʉ yà'sə wèŋ à ka bohòJisòs dzəm lok sə̀' mvə̀'nə̀ Ìzayà nə ànə com sə̀' də, ");
INSERT INTO yam_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","<<Nwì a lok lis awo sə, ya wo kà bum yə, nə gʉŋsə wo tu sə̀', ya wo kà marɛŋ yə. Wo kà bum yè'sə rɛɛ̀ŋ, fana nə kà mʉ̀ʉ Nwì də ya mʉ luŋsə wo yù və̀.>> ");
INSERT INTO yam_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ìzayà nə à sə cèp yè'sə ŋga yi sə dʉk yè'sə Jisòs, bʉ̀ʉsə̀ yi ànə ye ye də Ŋkum ŋgà gèm bwìŋ nə ŋwə̀ nə̀ ghaŋ. ");
INSERT INTO yam_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bum yè'sə ànə ye-a sə̀ vɛ'nə fana, bwìŋ à ye malì mʉŋgorə̀ bʉ̀ ŋkwàha bʉ̀ʉ Jus sə wèŋ yo, sə̀ wo à dzəm bohòJisòs nə. Megu də wo à sə wəp bʉ̀ʉ Faràsi wèŋ fana wo kà jəja də wo dzəm bohònà' cèp fis. Wo à gʉ̀ vɛ'nə də ya bʉ̀ʉ Faràsi sə wèeŋ kà wo mʉmvwe' ndap pìriyà awo bɛ' fis. ");
INSERT INTO yam_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Wo à dzəm ghak yàwo nə̀ də bwìiŋ kwasə wo nə noŋsə nə̀ də Nwìi kwasə wo yi. ");
INSERT INTO yam_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisòs à cèp fis fe'lə bə ŋàŋ sə̀mok dʉk də, <<Ŋwə̀ nə̀ yi dzəm-a bohòmʉ̀, ye də ŋgə̀ŋgàŋ ka yà'sə bohòmʉ̀ dzəm mègù. Yi dzəm yà'sə bohòŋwə̀ nə yi a tum və̀ mʉ tsenə nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ŋwə̀ nə̀ yi yə-a mʉ, ye də yi yə ŋwə̀ nə̀ yi tumsə və̀ mʉ nə sə̀' laŋ. ");
INSERT INTO yam_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mʉ̀ a və̀ yàm sə nzeŋgòŋ anə co marɛŋ. Ya ŋwə̀ nə̀ yi dzəm-a bohòmʉ̀, ye də yi nə kà sənə mandzəm mok cu malì. ");
INSERT INTO yam_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","A ye-a ŋga ŋwè yuk ncèp àm nə, nə dzeeŋ ŋgòyù nà' fana ye də a nə kà yi mʉ̀ kə̀ sak. Mʉ̀ à ka tsenə ŋgòkə̀ sak bwìŋ və. Mʉ̀ à və̀ yàm də ya bwìiŋ tse' lùŋ. ");
INSERT INTO yam_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ye də ŋwə̀ nə̀ yi dzeeŋ-a mʉ, nə bɛŋ ncèp àm nə fana, yi tse' yusə̀ yà'a nə sak yi nùmbu nə̀ nzeŋgòoŋ nə me. Wo nə jəŋ mègù sə̀ ncèp nə̀ mʉ̀ à cèp nə, nə sak nsàp ŋwə̀ ànə fo'. ");
INSERT INTO yam_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bʉsə̀ yusə̀ mʉ̀ sə cèp sə, mʉ̀ sə kà yà' sə ntʉʉ̀ mʉ̀ bə dzədzəm njàm tsərə̀ kok. Ŋwə̀ nə̀ yi sə tsə̀' mʉ yusə̀ mʉ cep sə, a Tɛ̀' am nə̀ yi a tum və̀ mʉ tsenə nə. ");
INSERT INTO yam_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mʉ̀ rì tse' də lùŋ nə̀ nà'a kà mègə̀ nə tesə və̀gə̀ bohòncèp nə̀ nje nə. Yà'a njo nə̀ mʉ̀ sə tsə̀' fa mègù weŋ yusə̀ Tɛ̀' am a dʉk fa mʉ yi sə.>> ");
INSERT INTO yam_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","À sə kʉəp wesə lòmok nùmbu ŋkàk pasobà nə fana Jisòs riŋ də mvə̀k nje kʉ̀rə ŋgòbwìŋ foho lòbohòTɛ̀' ye nə laŋ. Jisòs ànə dzəm bʉ̀ʉ sə̀ sə nzeŋgòŋ sə̀ wo sə̀ ye wèŋ fana yi dzəm yà' tə̀tè kə ləsə pwe' nə̀ pwe'. ");
INSERT INTO yam_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nconùm à dzèeŋ fana Jisòs bə ŋgàa fàak ye wèŋ kə cum be'lə mvwe' mò'fis, nə sə zʉ zʉzʉ. Yè'sə à ye ŋga Satà ni sə ntʉʉ̀ Judàs mo Saimʉ̀ nə̀ mvwe' lak Iskarəyà nə laŋ, də nà'a seŋ Jisòs. ");
INSERT INTO yam_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisòs à rì sə̀' də Tɛ̀' ye a fa bum pwe'fo' ndzə bohòyi. Yi à rì sə̀' də yi à tesə və̀ bohòNwì, fana yi nə bwi foho lo sə̀' bohòNwì anə. ");
INSERT INTO yam_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yi ànə riŋ vɛ'nə fana mvə̀'nə̀ wo à mà cu fo' fana Jisòs lokok, nə fweŋ fis cə̀ək ye sə̀ mʉ ŋkwɛ̀ŋ. Yi jəŋ tawùrə̀, nə swi' yak nà' sə gamə̀ yi. ");
INSERT INTO yam_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yi jəŋ ndzəp, nə gesə sənə ŋgàp mòk, nə ye ŋgòsə cùhu fa ŋgàa fàak ye wèŋ ŋki' awo bə zeŋ. Yi jəŋ tawùrə̀ nə̀ yi ànə swi' sə gamə̀ nə, nə sə yisə fa yà' ŋki' sə bə zeŋ. ");
INSERT INTO yam_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yi kə wɛs mʉ ni'ì Saimʉ̀ Pità fana Pità nə dʉk də, <<Wù də wu cuk fa mʉ kù ya a gʉ va Tà?>> ");
INSERT INTO yam_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisòs dʉk fa nà' də, <<Wù ka yusə̀ mʉ̀ sə gʉ̀ fa weŋ yè'sə ntòrɛɛŋ. Megu də mvə̀ək nə və nə̀ wèeŋ nə rɛɛŋ bə zeŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pità nə dʉk fa nà' də, <<Kaco mʉ̀ dzəm yuk də wu cuk fa mʉ kù yeŋ.>> Jisòs də, <<A ye-a ŋga mʉ̀ ka wu cuk fa, ye də wù ka yà'sə mok vesù ye.>> ");
INSERT INTO yam_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Fana Pità nə dʉk fa nà' mok kə də, <<A ye-a bìim vɛ'nə, Tà, wù kà mʉ kù cùk mègù fa. Wu cuk fa mʉ bo am bə tu am pwe'fo'.>> ");
INSERT INTO yam_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisòs dʉk fa yi də, <<Ŋwə̀ nə̀ yi cuk-a ni' ye laŋ, ye də yi mok rərɛŋ. Wo nə cuk fa megu ŋwə̀ ànə mok kù. Wèŋ pwe'fo' wèeŋ rərɛŋ, mègù ŋwə̀ nə̀ mò'fis nə̀ yi ka rərɛŋ yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisòs ànə riŋ me ye ŋwə̀ nə̀ nà'a nə seŋ yi nə laŋ. Nà'a njo nə̀ yi à dʉk də wèŋ ka rərɛŋ pwe' yeŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yi ànə cuk wes fa wo kùu awo sə fana yi kə te' ni fe'lə cə̀ək ye sə, nə kə foho cum nze. Fana yi ye ŋgòcèp bohòwo dʉk də, <<Wèŋ rɛɛŋ bə yusə̀ mʉ̀ gʉ̀ fa weŋ yà'sə à? ");
INSERT INTO yam_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Wèeŋ togə̀ mʉ də cicà nə ye də Tà. A bə̀boŋ mvə̀'nə̀ wèeŋ togə̀ mʉ vɛ'nə yà'sə bʉ̀ʉsə̀ mʉ bohòwèŋ mvə̀'nə̀ wèŋ sə to yà'sə anə zìnə. ");
INSERT INTO yam_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mʉ̀ nə̀ mʉ yàm cicà nə ye Tà àwèŋ nə cùk fa-a weŋ kù, ye də wèŋ tse' ŋgòcùhu fa mòk bə mòk kùu yàwo sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mʉ̀ nìtsə̀' fa weŋ yà'sə mandzə̀ mòk nə̀ də wèeŋ gʉ fa mòk bə mòk sə̀' mvə̀'nə̀ mʉ̀ gʉ̀ fa weŋ yà'sə. ");
INSERT INTO yam_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mʉ̀ sə tsə̀' fa weŋ ŋkèm ncèp dʉk də, kaco mo fàk yam ghak ŋwə̀ nə̀ yi sə fàk bohònà' nə yeŋ. Kaco masinjà mòk yam ghak ŋwə̀ nə̀ nà' tum yi nə sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mvə̀'nə̀ wèŋ rì bum yè'sə fana kwəkwaa nə ye bohòwèŋ, ŋga wèŋ sə gʉ̀-a yà' na.>> ");
INSERT INTO yam_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yi à cèp fe'lə ncèp mòk sə̀' də, <<Bum sə̀ mʉ̀ sə cèp yè'sə, mʉ̀ sə kà bohòwèŋ pwe'fo' cèp. Mʉ̀ rì nsàap bʉ̀ʉ yàm sə̀ mʉ̀ a cokfis wo sə mʉ̀. A zìnə də ncèp nə̀ nà' cu ndzənə ŋwàk Nwì nə, nə̀ ye mègù sə̀' mvə̀'nə̀ wo à còm sə də, <Ŋwə̀ nə̀ vesi zʉ be'lə zʉzʉ mvwe' mò'fis nə, nə̀ nə̀ŋ tes fa mʉ kù mʉ tuhù sə̀' yi nə.> ");
INSERT INTO yam_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mʉ̀ sə tsə̀' nòŋsə fa weŋ bum yè'sə ŋga cu ntòcuu, də ya yà'a kə̀ ye sə̀' mvə̀'nə̀ mʉ̀ à tsə̀' weŋ sə fana weŋ riŋ də mʉ ŋwə̀ nə̀ mʉ̀ cu nə. ");
INSERT INTO yam_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mʉ̀ sə tsə̀' weŋ nè'e ŋkèm ncèp dʉk də, ŋwə̀ nə̀ yi jə-a masinjà àm co ŋwè, ye də ŋgə̀ŋgàŋ jə yà'sə mʉ̀. Ŋwə̀ nə̀ yi jə-a mʉ, ye də yi jə yà'sə ŋwə̀ nə̀ yi a tumsə və̀ mʉ sə nzeŋgòŋ fɛŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisòs ànə cep wes ncèp ènə fana ntʉm ye fa ghaha wesə yi ŋgə' vɛ'ɛ wùriŋ. Yi cep fis mok jəja kwaraŋgaŋ də, <<Mʉ̀ sə tsə̀' weŋ nè'e ŋkèm ncèp də, ŋwè cu mʉŋgorə̀ wèŋ mò'fis nə̀ yi nə seŋ mʉ.>> ");
INSERT INTO yam_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ŋgàa fàak ye sə wèŋ à kʉ̀ksə kɛ'ca, nə mərə fʉk ŋwə̀ nə̀ yi də nà'a nə seŋ yi nə bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ànə ye ŋga mo fàk ye nə̀ yi à sə dzəmgə̀ nà' wùriŋ nə yəhə na kok lòŋgʉ ni'ì yi anə. ");
INSERT INTO yam_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimʉ̀ Pità sə gʉ gesə fa nà' bə si də nà'a fek Jisòs nə də ŋwə̀ nə̀ nà' dʉk ànə ndàlɛ. ");
INSERT INTO yam_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Fana ŋgà fàk ye nà'nə sooŋ kʉəp wesə lo ŋgʉ ni'ì Jisòs anə, nə fek nà' də, <<Tà, ŋwə̀ nə̀ wù dʉk ànə ndà lɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisòs dʉk də, <<A ŋwə̀ nə̀ mʉ nə bək jəŋ zʉzʉ, nə tsəp gesə sənə ndzəpnjàp, nə fa yi.>> Fana yi bək jəŋ zʉzʉ, nə tsəp gesə sənə ndzəpnjàp, nə fa Judàs Iskarəyà mo Saimʉ̀. ");
INSERT INTO yam_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judàs à jə yà' ntɛ̀ŋ, Satà ca ni yi sə ntʉʉ̀. Jisòs dʉk fa nà' də, <<Yusə̀ wù sə də wu gʉ sə, gʉ̀ yà' nə̀nàk.>> ");
INSERT INTO yam_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bwe ye sə̀ wo à ye fo' sə pwe' à yuk, nə kà njo nə̀ Jisòs dʉk fa nà' vɛ'nə nə rɛɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judàs nə à ye ŋgà lòksə̀ mbàam awo yi. Mok wèŋ tsəm də kàmòk Jisòs dʉk də nà'a kə ywiŋ və bum sə̀ wo nə zʉ ŋkàk bə zeŋ. Bòp mòk tsərə yàwo də kàmòk Jisòs sə dʉk də nà'a kə gap fa ŋgàa jìŋ wèŋ mbàm. ");
INSERT INTO yam_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ghà nə̀ Judàs nə ànə jəŋ zʉzʉʉ sə̀ Jisòs fa yi sə ntɛ̀ŋ fana yi tesə lo yuye sə mbiŋ. À ye yè'sə ŋga ndzəm seŋ tasə cù laŋ. ");
INSERT INTO yam_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ghà nə̀ Judàs nə ànə tesə lo ye sə fana Jisòs dʉk fa ŋgàa fàak ye wèŋ də, <<Mvə̀k kʉ̀rə ŋga'a mok laŋ nə̀ bwìiŋ nə ye də mo ŋwè nə ŋwə̀ nə̀ ghaŋ. Wo nə ye nsàp ŋwə̀ nə̀ ghaŋ nə̀ Nwì cu sə̀' ndzə ni'ì Mo ŋwè anə. ");
INSERT INTO yam_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mvə̀'nə̀ wo nə ye nsàp ŋwə̀ nə̀ ghaŋ nə̀ Nwì cu ndzə ni'ì mʉ̀ʉ Mo Ŋwè fana Nwìi nə niŋ tsok fa bwìŋ nsàp ŋwə̀ nə̀ ghaŋ nə̀ Mo ye nə cu, Yi nə kà mvə̀k càsə̀. ");
INSERT INTO yam_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","<<Bwe am wèŋ, mvə̀k nə̀ vesùwèeŋ nə cum mvwe' mò'fis ka mok ŋkʉ̀ʉŋ bwehe cum fe'lə. Wèeŋ nə lap mʉ fana yà' megu mvə̀'nə̀ mʉ̀ ànə tsok fa bʉ̀ʉ Jus wèŋ fa' yà'a də, kaco wèŋ kə dzeŋ to mvwe' sə̀ mʉ̀ sə lòo sə yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mʉ fa weŋ lʉ̀k nə̀ fi də, wèeŋ dzəm mòk bə mòk. Nsàp mandzə̀ nə̀ mʉ̀ a dzəm weŋ nà'a, wèeŋ nə dzəm tsoŋ mòk bə mòk sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nsàp dzədzəm ènə nə gʉ yi ŋkuŋ bwìŋ riŋ də wèeŋ bʉ̀ʉ sə̀ wèŋ sə yù mandzə̀ àm.>> ");
INSERT INTO yam_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimʉ̀ Pità à fek yi də, <<Tà, mvwe' sə̀ wù sə lòo sə ma fò?>> Jisòs dʉk də, <<Mvwe' sə̀ mʉ̀ sə lòo sə, kaco wù lo to fo' ŋga'a yeŋ. Mvə̀ək nə və nə̀ wu nə yuŋ və mʉ fo'.>> ");
INSERT INTO yam_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pità dʉk də, <<Wù də kaco mʉ̀ yuŋ lo to wu ŋga'a yeŋ ŋga kotse' mʉ yà ŋkuŋ ɛ Tà? Mʉ yàm kə̀kʉrə̀ ŋgòkpʉ bʉ̀ʉ tu yò.>> ");
INSERT INTO yam_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisòs dʉk fa yi də, <<Wù dʉk də aco wù kpʉ bʉ̀ʉ mʉ̀ ɛ̀? Mʉ tsok wu ŋkèm dʉk də, mvəp nə sə kə to kàmòk, ŋga wù nè'e, wù bɛ̀ŋ fis mʉ kɛ̀' tɛ' laŋ də wù ka mʉ riŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ànə geŋ Jisòs nə dʉk fa ŋgàa fàak ye sə wèŋ də, <<Kà də wèeŋ gʉ də ntʉʉm awèeŋ sə bʉp weŋ dʉk. Wèeŋ fa ntʉʉm awèŋ bohòNwì, nə fa yà' bohòmʉ̀ sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Rum ndap mʉ la'à Tɛ̀' am àwo ŋkʉ̀ʉŋntɛ̀ŋ. Yà' ànə ka-a vɛ'nə yeŋ bwɛ̀rɛ mʉ̀ a tsə̀' fa weŋ. Mʉ̀ sə lòdə ya mʉ kə gʉhʉ tsə'rə noŋsə fa weŋ mvwe' ncum mbwa. ");
INSERT INTO yam_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mʉ lo-a, nə kə gʉhʉ tsə'rə wes fana mʉ̀ foho və, nə kə jəŋ lo weŋ, də ya mvwe' sə̀ mʉ̀ cu sə, wèŋ ye yàwèŋ sə̀' fo'. ");
INSERT INTO yam_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Wèŋ rì mandzə̀ nə̀ ŋgòlòmvwe' sə̀ mʉ̀ sə lòo sə laŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomos dʉk fa yi də, <<Vès ka mvwe' sə̀ wù sə lòo sə riŋ, Tà. Ye də vèes nə riŋ mandzə̀ nə̀ ŋgòkə̀ dzèŋ fo' nə bə yà?>> ");
INSERT INTO yam_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisòs dʉk wo də, <<Mʉ mandzə̀ nə mʉ̀, mʉ zìnə nə sə̀' mʉ̀, nə ye lùŋ nə sə̀' mʉ̀. Kaco ŋwè ca, nə kə ye to si Tɛ̀' am yeŋ, tse'ŋga ŋgə̀ŋgàŋ cà bohòmʉ̀. ");
INSERT INTO yam_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","A ye-a də wèŋ anə riŋ-a mʉ, bwɛ̀rɛ də wèŋ a rì Tɛ̀' am sə̀' laŋ. Ye jəŋ ŋga'a nə lo mantombì, wèŋ rì yi, nə yəə̀ nə yi bə lis sə̀' laŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filìp fek yi də, <<Tà, niŋ fa-a ves Tɛ̀' yo nə ɛ̀? Nà'a mègù yu nə̀ mò'fis nə̀ vèes yə-a yi, yà' kʉrə ves.>> ");
INSERT INTO yam_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisòs dʉk də, <<Nùumbu sə̀ mʉ̀ a cu vesùwèŋ yè'e pwe', wù ka mʉ ntòriŋ à, Filìp? Ŋwə̀ nə̀ yi yə-a mʉ, ye də yi a yə Tɛ̀' am nə laŋ. Ye də wù sə dʉk fe'lə də mʉ niŋ fa weŋ Tɛ̀' am nə-e ŋga'a va? ");
INSERT INTO yam_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Co wù ka sə ntʉʉ̀ wù dzəm də mʉ mo ye nə, mʉ mò'fis bə Tɛ̀' nə, Tɛ̀' nə ye sə̀' mò'fis bə mo ye nə yè'e dzəm à? Ncèp nə̀ mʉ̀ sə cèp fa wèŋ ènə sə kà sə və̀ə mʉ̀ bə tu am tesə kok. Sə gʉ̀ Tɛ̀' am nə̀ yi sə fàk ndzə ni'ì mʉ̀ nə. ");
INSERT INTO yam_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Wèeŋ dzəm ncèp àm nə̀ də mʉ ves Tɛ̀' am mò'fis, Tɛ̀' am ye bwi vesi sə̀' mò'fis nè'e. A ye-a də wèŋ sə kà dzəm də bʉ̀ʉsə̀ mʉ̀ sə cèp yà' sə̀' mʉ̀ bə cùu am fana aco wèŋ dzəm yà' bʉ̀ʉsə̀ wèŋ yə nsàap fàak sə̀ mʉ̀ sə gʉ̀ʉ sə. ");
INSERT INTO yam_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","<<Mʉ tsok fa weŋ ŋkèm ncèp dʉk də, ŋwə̀ nə̀ yi dzəm-a bohòmʉ̀, yi nə gʉ sə̀' nsàap bum sə̀ mʉ̀ sə gʉ̀ʉ. Yi nə gʉ bum sə̀ yà' yam càsə yà'sə sə̀', bʉ̀ʉsə̀ mʉ̀ sə bwìŋ lòyàm bohòTɛ̀' am. ");
INSERT INTO yam_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","A ye-a sə̀ yà, ŋga wèŋ fek yà' bə liŋ am fana mʉ nə gʉ yà'. Mʉ nə gʉ yà' ya ŋga bwìiŋ ye ŋàaŋ sə̀ Tɛ̀' tse' sə ndzənə fàak am sə. ");
INSERT INTO yam_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","A ye-a sə̀ yà, ŋga wèŋ fek mʉ yà' bə liŋ am fana mʉ nə gʉ yà'.>> ");
INSERT INTO yam_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jisòs nə dʉk fe'lə mok sə̀' də, <<A ye-a də wèŋ dzəm mʉ, wèŋ noŋsə lʉ̀ʉk am. ");
INSERT INTO yam_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Fana mʉ nə fek Tɛ̀' am yi tum fa weŋ ŋgà ntip mòk. Ŋgà ntip ènə, a Yòŋsə̀ nə̀ Nwì nə, nà'a yi nə̀ yi nìtsə̀' fagə̀ bwìŋ zìnə nə. Yi nə cum mam wenə wèŋ sə ntʉʉ̀ wèŋ nə̀ mvèsə̀. Kaco bʉ̀ʉ sə̀ sə nzeŋgòŋ fɛɛŋ tse' to yi yeŋ, bʉ̀ʉsə̀ kaco wo ye nà' yeŋ, nə kà yi sə̀' rì. Wèŋ riŋ yi yàwèŋ rìiŋ bʉ̀ʉsə̀ yi cu wenə wèŋ, nə ye də yi nə kə cum mam wenə wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","<<Ye də wèeŋ riŋ tse' də kaco mʉ lo, nə me'rə mak noŋsə weŋ co bwe njìŋ yeŋ. Mʉ nə bwi foho və mali ŋgòkə̀ yə weŋ. ");
INSERT INTO yam_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yusə də, cu mvə̀k momjo ya bʉ̀ʉ sə̀ sənə nzeŋgòŋ nə kà mʉ mok sə yə fe'lə̀. Wèeŋ nə sə ye mali mʉ yàwèŋ yo, bʉ̀ʉsə̀ mʉ̀ cu fo' ŋwəm fana wèeŋ nə cum yàwèŋ sə̀' ŋwəm anə. ");
INSERT INTO yam_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mvə̀k ànə kə̀ dzèŋ nùu fana wèŋ riŋ də mʉ ves Tɛ̀' am mò'fis, wèŋ ye yàwèŋ vesùwèŋ sə̀' mò'fis fana mʉ̀ ye yàm vesùwèŋ sə̀' mò'fis. ");
INSERT INTO yam_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ŋwə̀ nə̀ yi yuk-a lʉ̀ʉk am sə, nə noŋsə yà' fana ye də nà'a yi nə̀ yi dzəm mʉ nə. A ye-a ŋga ŋwè dzəm mʉ, ye də Tɛ̀' aam nə dzəm ŋgə̀ŋgàŋ, mʉ̀ dzəm yi yàm sə̀', nə niŋtsok fa yi ni' àm mvə̀'nə̀ mʉ̀ cu.>> ");
INSERT INTO yam_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ànə geŋ Judàs fek yi də, <<Aco wù yəəŋ megu bohòvès, bʉ̀ʉ sə̀ sə nzeŋgòŋ sə kà wu yàwo yə anə va Tà?>> Ànə cep yè'sə Judàs nə̀ zok, ka Judàs Iskarəyà yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisòs cep fəsə də, <<Ŋwə̀ nə̀ yi dzəm-a mʉ, yi nə noŋsə ncèp àm. Tɛ̀' am nə dzəm yi fana ves Tɛ̀' am nə nə və kə gʉ mvwe' ncum avès ves ŋwə̀ ànə wèŋ bəbɛ'. ");
INSERT INTO yam_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ŋwə̀ nə̀ yi kà mʉ dzəmgə̀ə kà ncèp àm nə sə̀' nòŋsə̀gə̀. Wèeŋ tsərə tse' də ncèp nə̀ mʉ̀ sə tsə̀' weŋ ènə nà' sə kà sə və̀ə mʉ̀ bə tu am tesə kok. A ncèp Tɛ̀' am nə̀ yi a tum və̀ mʉ nə. ");
INSERT INTO yam_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mʉ̀ tsə̀' fa weŋ bum yè'sə ŋga mʉ̀ cu ntòvesùwèŋ. ");
INSERT INTO yam_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Anə ye maŋkwɛ̀ŋ fana Tɛ̀' am nə nə tumsə vesə fa weŋ ŋgà ntip nə ŋgòkə̀ jə mvwe' kùu am. Ŋgà ntip nə, a Yòŋsə̀ nə̀ Rərɛŋ nə. Ghà nə̀ yi və̀ nə, yi nə yə'rə fa weŋ bum, nə gʉ wèŋ tsərə riŋ fəsə bum sə̀ mʉ̀ à tsə̀' weŋ sə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","<<Mvə̀'nə̀ mʉ̀ sə lòŋga'a yè'e fana mʉ̀ fa nòŋsə weŋ fifi. Nsàp fifi nə̀ njàm nə̀ mʉ̀ sə fa weŋ ènə, kaco wèŋ tse' to nà' bohònzeŋgòŋ nè'e yeŋ lok. Wèeŋ kà də wèeŋ sə mərə dʉk. Wèeŋ kà wʉə sə ntʉʉ̀ wèŋ sə̀' tse'. ");
INSERT INTO yam_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Wèŋ yuk mvə̀'nə̀ mʉ̀ tsə̀' fa weŋ də mʉ̀ sə lòo fana nə bwi və kə tseŋ weŋ sə̀mok yà'a laŋ. A ye-a də wèŋ dzəm mʉ, wèŋ kwa də mʉ̀ sə lòŋgòkə̀ yə Tɛ̀' am, bʉ̀ʉsə̀ Tɛ̀' am nə yi yam gha' mʉ yi. ");
INSERT INTO yam_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mʉ̀ sə tsòho fa weŋ bum yè'sə ŋga cu ntòcu, də ya ŋga yà'a kə̀ ye mvə̀'nə̀ mʉ̀ tsə̀' weŋ sə fana wèŋ dzəm də mʉ ŋwə̀ nə̀ zìnə. ");
INSERT INTO yam_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mʉ nə kà vesùwèŋ tə̀tè mok cèp yiskok, bʉ̀ʉsə̀ ŋwə̀ nə̀ yi ŋkum sə nze fɛɛŋ yi nə sə də yi və. Megu də yi ka ŋàŋ bohòmʉ̀ tse'. ");
INSERT INTO yam_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yusə̀ mʉ̀ sə gʉʉ, a bə ŋàaŋ sə̀ Tɛ̀' am a dʉk fa mʉ yi də mʉ gʉ, ya ŋga bwìŋ nə riŋ də mʉ̀ dzəm Tɛ̀' nə. Lòkok, vesùwèeŋ lo mvwe' sə̀ zok.>> ");
INSERT INTO yam_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisòs à tsə̀' fa ŋgàa fàak ye wèŋ ncèp mòk sə̀' dʉk də, <<Mʉ yè'e tʉ grep nə̀ nà'a nə̀ zìnə, Tɛ̀' am ye bwi ye co ŋwə̀ nə̀ yi sə jə ŋkərə̀ bə zeŋ yi. ");
INSERT INTO yam_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","A ye-a ŋga ntaŋ àm mòk sə kà zəm fana yi gbɛ' ci' mak fis nà'. A ye-a nta nə̀ nà' sə zəm fana yi gʉhʉ tsə'rə nà' bə̀boŋ də ya nà'a zəm ghaha wesə ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wèeŋ yàwèŋ mok rərɛŋ co ntaŋ tʉ nə̀ wo gʉhʉ tsə'rə nà' gʉhʉ tsə'rə. Wèŋ rɛŋ vɛ'nə bʉ̀ʉ ncèp am nə̀ mʉ̀ cèp fa wèŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wèeŋ cum mam ndzə ni'ì mʉ̀ ya mʉ cum mam ndzə ni'ì wèŋ sə̀'. A ye-a ŋga ntaŋ ka ndzə ni'ì mantseŋ tʉ nə yeŋ, kaco yi zəm ŋgwì yeŋ. A bohòwèŋ sə̀' vɛ'nə də, a ye-a ŋga wèŋ ka ndzə ni'ì mʉ̀ cum mam, ye də wèeŋ wà. ");
INSERT INTO yam_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","<<Mʉ yàm mantseŋ tʉ nə, wèŋ ye yàwèŋ ntaŋ sə. Ŋwə̀ nə̀ yi cu mam-a ndzə ni'ì mʉ̀, mʉ̀ cum ndzə ni'ì yi sə̀' fana yi nə ye co ntaŋ tʉ nə̀ yi sə zəm ŋgwì wùriŋ. Yumook sə̀' də, a ye-a ŋga mʉ̀ ka ye, kaco wèŋ gʉ to lok fʉ̀k yumok yeŋ. ");
INSERT INTO yam_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ŋwə̀ nə̀ yi kà-a ndzə ni'ì mʉ̀ cu mam fana yi ye co ntaŋ tʉ nə̀ wo màk nà' mà'a. Ntaŋ tʉ nə yum fana wo te'e benə nsàap yà'sə, nə kə tɛŋ sə misə̀, fana yà' sə. ");
INSERT INTO yam_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Wèeŋ cu mam-a ndzə ni'ì mʉ̀, ncèp àm cum sə̀' sə ntʉʉ̀ wèŋ fana yusə̀ wèŋ fek mʉ yà' pwe'fo', wèeŋ nə tse' yà'. ");
INSERT INTO yam_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yusə̀ yà'a gʉ̀gə̀ ŋkuŋ bwìŋ jəŋ Tɛ̀' am də yi kə̀kuk, a ŋga wèeŋ co ntaaŋ tʉ sə̀ wèŋ sə zəm ŋgwì ŋkʉ̀ʉŋ. Yà'sə nə niŋtsok sə̀' jəja də wèeŋ bwe am. ");
INSERT INTO yam_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","<<Mʉ̀ a dzəm weŋ nsàp nə̀ co Tɛ̀' am dzəmgə̀ mʉ. Wèeŋ sə lo mantombì bə nsàp mandzə̀ nə̀ co mʉ̀ sə dzəm mali weŋ. ");
INSERT INTO yam_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","A ye-a ŋga wèŋ sə nòŋsə lʉ̀ʉk am sə fana mʉ nə sə dzəm mali weŋ fo'. Yà' mègù sə̀' mvə̀'nə̀ mʉ̀ a nòŋsə lʉ̀ʉk Tɛ̀' am fana yi sə dzəm mali mʉ sə̀' yè'e. ");
INSERT INTO yam_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mʉ̀ tsə̀' nòŋsə fa weŋ bum yè'e mantombì ya ŋga kwəkwa nə̀ mʉ̀ tse' nə, wèeŋ tse' nà' yàwèŋ sə̀', ya kwəkwa nə̀ njàwèŋ nə nà'a rwiŋ wesə dak nə̀ dak. ");
INSERT INTO yam_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lʉ̀k àm nə̀ mʉ̀ sə fa weŋ nə nè' də, Wèeŋ sə dzəm mòk bə mòk sə̀' mvə̀'nə̀ mʉ̀ a dzəm weŋ. ");
INSERT INTO yam_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","<<Nsàp dzədzəm mòk ka nsàp nè'e mok gʉŋ casə fe'lə nə̀ də ŋwè dzəm ŋge' ye wèŋ vɛ'ɛ tə̀tè nə kə fa ni' ye də yi kpʉ bʉ̀ʉ tu yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","A ye-a ŋga wèŋ sə nòŋsə lʉ̀ʉk am sə fana ye də wèeŋ ŋge' am. ");
INSERT INTO yam_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mʉ nə kà weŋ də ŋkwɛ̀ŋ mok sə to, bʉ̀ʉsə̀ kaco moŋkwɛ̀ŋ riŋ wes yusə̀ ŋkwà' ŋwə̀ ye nə sə gʉ̀ pwe'fo' yeŋ. Mʉ nə to weŋ lɛ də ŋge', bʉ̀ʉsə̀ mʉ̀ a tsòho wes fa weŋ bum sə̀ Tɛ̀' am a tsə̀' mʉ sə pwe' nə̀ pwe'. ");
INSERT INTO yam_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wèŋ a ka mʉ wèŋ cokfis jəŋ, mʉ̀ a cokfis jə weŋ mʉ̀, nə tumsə lo weŋ də wèeŋ lo, nə kə zəm fa mʉ nto' ŋkʉ̀ʉŋ ya nto'o sə cum mali fo'. Wèeŋ gʉ̀ vɛ'nə fana yusə̀ wèŋ fek Tɛ̀' am yà' mʉnə liŋ am pwe'fo', yi nə fa weŋ yà'. ");
INSERT INTO yam_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lʉ̀k àm nə̀ mʉ̀ sə fa weeŋ nè'e də, wèeŋ dzəm mòk bə mòk.>> ");
INSERT INTO yam_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jisòs nə à sə cèp lòmalì mantombì də, <<A ye-a ŋga bʉ̀ʉ sə̀ sənə nzeŋgòŋ nə bɛ̀ŋ weŋ, wèŋ riŋ də wo à bɛ̀ŋ to ntòmʉ̀ ŋkuŋ nə sə bɛŋ weŋ. ");
INSERT INTO yam_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wèŋ ànə ye-a bʉ̀ʉ nzeŋgòŋ sə wèŋ bwɛ̀rɛ bʉ̀ʉ sə̀ sənə nzeŋgòŋ sə wèŋ dzəm weŋ bʉ̀ʉsə̀ də wèeŋ bʉ̀ʉ awo. Megu kə də mʉ̀ a cokfis weŋ mʉtsətsə'rə̀ə bʉ̀ʉ sə̀ sə nzeŋgòŋ sə fana wèŋ ka mok bʉ̀ʉ awo yeŋ. Nà'a njo nə̀ wo sə bɛ̀ŋ weŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Wèeŋ kà də wèeŋ swi ncèp nə̀ mʉ̀ à tsə̀' weŋ fa' nà'a dʉk. Də, kaco mo ŋkwɛ̀ŋ yam ghak ŋwə̀ nə̀ yi sə fàk bohònà' yeŋ. Bʉ̀ʉ sə̀ wo à bɛ̀ŋ mʉʉ nə bɛŋ li weŋ sə̀'. Bʉ̀ʉ sə̀ wo à dzəm ncèp àam, nə dzəm li ncèp awèŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Wo nə gʉ weŋ nsàap bʉp yà'sə pwe' bʉ̀ʉsə̀ də wèeŋ bʉ̀ʉ am, nə ye sə̀' bʉ̀ʉsə̀ də wo ka ŋwə̀ nə̀ yi tumsə və̀ mʉ tsenə nə riŋ. ");
INSERT INTO yam_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ànə ye-a də mʉ̀ a ka yumok bohòwo kə cep bwɛ̀rɛ də bʉp awo kà mʉ tuhù wo ye. Nə ye də nə̀ mʉ̀ a və̀, nə kə tsok wo laŋ fana mandzə̀ nə̀ co wo swihi nə mok bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ŋwə̀ nə̀ yi bɛ̀ŋ-a mʉ, ye də yi bɛ̀ŋ Tɛ̀' am sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ànə ye-a də mʉ̀ à ka nsàap maŋgəŋgèeŋ sə̀ ŋwə̀ nəmòk ka gʉ yuk mʉ lisə̀ wo gʉ, bwɛ̀rɛ də bʉp awo kà mʉ tuhù wo ye. Nə ye də ŋga'a yè'e, wo a yə yà' bə lis awo laŋ, nə sə bɛŋ mali mʉ ves Tɛ̀' am ba fo'. ");
INSERT INTO yam_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Me'rə yà'a ye vɛ'nə ntɛ̀ŋ, ya yà'a kə kʉrə təəŋ mvə̀'nə̀ wo à còm nòŋsə ndzənə ŋwàk Nwì də, <Wo à bɛ̀ŋ mʉ wà jì njo yà'a.> ");
INSERT INTO yam_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","<<Wèeŋ kà swì də ŋgà ntip nə sə və̀ə swì. Ghà nə̀ mʉ̀ lòbohòTɛ̀' am fana mʉ nə tumsə vesə fa weŋ yi. Yi yòŋsə̀ nə̀ yi tesə və̀ bohòTɛ̀' am. Yi nìtsə̀' fagə̀ bwìŋ zìnə nə yi. Yi nə kə təəŋ ma nə̀ njàm, nə sə tsoho fa bwìŋ nsàp ŋwə̀ nə̀ mʉ̀ cu nə. ");
INSERT INTO yam_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Wèeŋ yàwèŋ sə̀' bʉ̀ʉ sə̀ aco wèŋ tsoho fa bwìŋ bə liŋ am sə̀', bʉ̀ʉsə̀ à yè yèe, a sə cu vesùwèŋ mvwe' mò'fis. ");
INSERT INTO yam_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","<<Mʉ̀ tsə̀' fa weŋ bum yè'sə ya ŋga bwìiŋ yè ŋgòfa weŋ ŋgə' fana wèŋ kà maŋkwɛ̀ŋ sòòŋ fohòlò. ");
INSERT INTO yam_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wo nə jum fis weŋ mʉmvwe' ndap pìriyà. Mvə̀k sə və̀ə nə̀ wo nə zə weŋ bə zə mwè nə sə tsəm də wo sə gʉ̀ fàha Nwì. ");
INSERT INTO yam_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wo nə gʉ weŋ nsàap bum yè'sə bʉ̀ʉsə̀ wo ka mʉ ves Tɛ̀' am ba fo' riŋ. ");
INSERT INTO yam_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Megu də mʉ̀ sə tsòho fa weŋ bum yè'sə ŋga cu nto cuu ya ŋga yà'a kə ye nùu, wèŋ tsərə tse' də mʉ̀ ànə tsok weŋ laŋ də a nə̀ ye vɛ'nə. Mʉ̀ à ka weŋ bum yè'e mantombì tsok fa bʉ̀ʉsə̀ mʉ̀ a sə cugə̀ vesùwèŋ. ");
INSERT INTO yam_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","<<Mʉ̀ sə tsə̀' weŋ yà' ŋga'a bʉ̀ʉsə̀ mʉ̀ tə mok ŋgòbwì foho lòyu am bohòŋwə̀ nə̀ yi à tum və̀ mʉ tsenə nə. Mègù kə də wèŋ pwe'fo', ŋwə̀ nə̀ mò'fis sə kà mʉ də mʉ̀ sə lòyè'sə fòlɛ sə̀' fek lok. ");
INSERT INTO yam_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yàwèŋ mègù də bum sə̀ mʉ̀ sə tsə̀' weŋ yè'sə sə gʉ̀ ntʉʉm awèŋ kà kwa. ");
INSERT INTO yam_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mʉ̀ sə tsə̀' weŋ lɛ zìnə də bòghak də mʉ me'rə weŋ nə lo, bʉ̀ʉsə̀ mʉ kà-a lòfana Ŋgà Ntip nə nə kà ŋgòkə cu wenə wèŋ və̀. A ye-a ŋga mʉ̀ lòkə̀ dzèŋ mbwa fana mʉ nə tumsə tsoŋ və yi ŋgòkə̀ cu wenə wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ghà nə̀ yi və̀ə fana yi nə gʉ nzeŋgòŋ nə ŋgòrì ncu nə̀ bʉp nə ye ncu nə̀ kə̀kʉrə̀, nə ye mandzə̀ nə̀ Nwìi nə kə sak nzeŋgòŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yi nə niŋtsok rɛŋsə fa wo də yà'wèeŋ ŋgàa gʉ̀ bʉp bʉ̀ʉsə̀ wo à ka bohòmʉ̀ dzəm. ");
INSERT INTO yam_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yi nə rɛŋsə wo də mʉ ŋwə̀ nə̀ kə̀kʉrə̀. Yi nə tsok rɛŋsə fa wo yè'sə bə mandzə̀ nə̀ də mʉ nə me'rə fɛɛŋ, nə lo bohòTɛ̀' am fana wèŋ kà mʉ mok sə yə fe'lə̀. ");
INSERT INTO yam_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yi nə rɛŋsə fa bwìŋ jòŋ awo bə ma nə̀ sak nzak sə̀' bʉ̀ʉsə̀ bwìiŋ nə ye də nzak ko ŋkum nə̀ yi tse' nzeŋgòŋ yi nə. ");
INSERT INTO yam_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","<<Bum cu wùriŋ sə̀ mʉ̀ ka weŋ ntòtsoho fa, megu də mʉ tsoho fa-a weŋ yà' ŋga'a pwe', yà' ghak weŋ ŋàŋ. ");
INSERT INTO yam_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Megu də ghà nə̀ Yòŋsə̀ nə̀ yi rɛŋsə fagə̀ bwìŋ zìnə nə və̀ə fana yi nə sə gʉmsə lo weŋ mvwe' sə̀ ŋgòrì zìnə nə pwe'. Yi nə kà bum bə tu ye sə cèp, yi nə sə cep bum sə̀ yi yuk və̀ ye yà' sə̀' yu'u. Yi nə tsoho rɛŋsə fa weŋ bum mok sə̀ yà'a nə̀ kə̀ ye ntsə'mòk mantombì sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yòŋsə̀ ànə nə gʉ mʉ, mʉ̀ ye ŋwə̀ nə̀ ghaŋ bʉ̀ʉsə̀ bum sə̀ yi nə niŋ tsoho fa weŋ yà' sə nə tesə bohòmʉ̀. ");
INSERT INTO yam_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bum sə̀ Tɛ̀' am tse' pwe' a sə̀' yàm, fana nà'a njo nə̀ mʉ̀ dʉk weŋ də Ŋgà Ntip nə nə sə tsoho fa weŋ bum sə̀ yà' tesə və̀ bohòmʉ̀ sə.>> ");
INSERT INTO yam_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jisòs à dʉk fa bwe ye wèŋ dʉk də, <<Anə ca mvə̀k momjo wèŋ kà mʉ mok sə yə fe'lə̀. A cà fe'lə mvə̀k momjo sə̀mok fana wèŋ ye fe'lə mʉ.>> ");
INSERT INTO yam_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ŋgàa fàak ye mok wèŋ a fe'rə kɛ'cà mʉŋgorə̀ wo anə də, <<Yi sə cèp yè'sə də yà vɛ'nə ɛ? Yi sə dʉhʉ yusə də, <Mvə̀k momjo wèeŋ nə kà mʉ yə, a kə̀ cà fe'lə mvə̀k momjo sə̀mok fana wèŋ ye mʉ.> Yi cèp vɛ'nə, nə sə dʉk də, <A bʉ̀ʉsə̀ mʉ̀ sə lòbohòTɛ̀' am> wèŋ yè'sə bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ncèp nə̀ yi sə cèp nà' də mvə̀k momjo nə yè'sə dalɛ? Mvə̀k momjo ànə vès ka yàvès bə zeŋ rɛɛŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ànə geŋ Jisòs riŋ də wo sə dzəm ŋgòfek yi yumok fana yi dʉk fa wo də, <<Wèŋ sə mərə yè'e ncèp nə̀ mʉ̀ dʉk fa weŋ də mvə̀k momjo wèeŋ nə kà mʉ mok yə, a cà mvə̀k momjo wèŋ ye fe'lə mʉ sə̀mok nə à? ");
INSERT INTO yam_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mʉ tsok fa weŋ ŋkèm ncèp də, wèeŋ nə waŋ vɛ'ɛ manziìŋ manziŋ, fana bʉ̀ʉ sə̀ sə nzeŋgòŋ sə wèŋ sə kwa ma njàwo kwaa. Ntʉʉm awèeŋ nə bʉp weŋ wùriŋ fana ntʉʉm awèŋ sə̀ yà' bʉp weŋ vɛ'ɛ sə nə bʉʉŋ kwa fe'lə sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Anə ye co ŋwà nə̀ yi sə ghà mwe. A yèto, ntʉm bʉp yi də mvə̀k ŋgə' ye və̀ laŋ. Ghà nə̀ yi dzə wes mo nə fana yi kà ŋgə' nə̀ yi anə ye nə mok tsərə̀. Yi nə sə kwa mok kə kwaa də yi dzə mwe sə nzeŋgòŋ. ");
INSERT INTO yam_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Anə ye bohòwèŋ sə̀' vɛ'nə. Ŋga'a yè'e ntʉʉm awèŋ sə bʉp weŋ, megu kə də ghà nə̀ mʉ nə kə̀ ye fe'lə vesùwèŋ sə̀mok fana wèeŋ nə kwa mvə̀k ànə wùriŋ. Mandzə̀ nə̀ co də ŋwə̀ nəmòk gʉ to də ya wèeŋ kà mok kwa fe'lə̀, kà mok sə̀' ye. ");
INSERT INTO yam_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","<<A kə̀ dzèŋ nùmbu ànə fana yà'a nə rɛɛŋ bohòwèŋ, wèŋ kà mʉ yumok mok fek fe'lə̀. Mʉ tsok fa weŋ ŋkèm ncèp dʉk də, yusə̀ wèeŋ fek-a Tɛ̀' am yà' mʉnə liŋ am pwe', yi nə fa weŋ yà'. ");
INSERT INTO yam_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yà' kə̀ dzèŋ tə̀tè ntinə ŋga wèŋ ka yumok mʉnə liŋ am lɛŋ yuk. Wèeŋ lɛŋ bum bohòTɛ̀' am, ya yi fa weŋ yà', wèŋ kwa tsə'rə boŋsə riŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yi à cèp fe'lə fa ŋgàa fàak ye sə wèŋ də, <<Mʉ̀ sə màk fa mègù weŋ bum bə gbʉ' bə gbʉ'. Mvə̀k sə və̀ə nə̀ mʉ nə kà gbʉ' mok màk fe'lə̀. Mʉ nə tsok rɛŋsə fa weŋ bum sə̀ yà' cu bə liŋ Tɛ̀' am sə mok jəja. ");
INSERT INTO yam_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ghà ànə ye fana wèeŋ nə sə lɛŋ bum bohòTɛ̀' am mok bə cùu awèŋ mʉnə liŋ am. Anə kà mok də mʉ kə lɛŋ fa weŋ mʉ̀ mok ye yiskok. ");
INSERT INTO yam_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tɛ̀' am bə tu ye yi dzəm weŋ bʉ̀ʉsə̀ wèŋ a dzəm mʉ, nə dzəm tse' sə̀' də mʉ̀ à tesə bohòyi. ");
INSERT INTO yam_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","A zìnə, mʉ̀ à tesə və̀ bohòyi ŋkuŋ nə və sə nzeŋgòŋ fɛn; nə̀ ŋga'a nè'e mʉ̀ sə də mʉ me'rə ŋgòŋ nə, nə bwi foho lo fe'lə bohòTɛ̀' am nə.>> ");
INSERT INTO yam_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ànə geŋ fana ŋgàa fàak ye sə wèŋ dzəm fa yi də, <<A vɛ'nə àlaa. Wù cèp nə ŋga'a mok rərɛŋ, wù sə kà gbʉ' mok màk. ");
INSERT INTO yam_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Fana vès rɛɛŋ nə nə̀ ŋga'a də wù riŋ bum pwe'fo'. Njo mòk nə̀ də ŋwèe fek wu yusə̀ yà' cu sə və̀ə yi ŋkuŋ ya wu riŋ yà'a bʉ̀ə̀. Yà'sə gʉ̀ fana vès dzəm zìnə də wù a tesə və̀ bohòNwì.>> ");
INSERT INTO yam_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisòs nə fek wo də, <<Co yà'sə gʉ̀ weŋ ŋkuŋ wèŋ dzəm à? ");
INSERT INTO yam_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wèeŋ yeè, mvə̀k sə və̀ə, aco mʉ̀ dʉk də mvə̀k nə kʉ̀rə laŋ, nə̀ wo nə bɛ' samsə weŋ zəzok fana ndàaŋwè pwe' caŋ lo nda'à yi, wèŋ me'rə tes mʉ mʉmʉ̀. Megu də mʉ nə kà mʉmʉ̀ sə̀ ye bʉ̀ʉsə̀ Tɛ̀' aam nə ye vesi. ");
INSERT INTO yam_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mʉ̀ cèp bum yè'sə bohòwèŋ ya wèeŋ cum mam vesùwèŋ nə tse' fifi. Sənə nzeŋgòŋ nè'e, wèeŋ nə sə tse' megu ca ŋgə'. Megu də wèeŋ ko ntʉm. Mʉ̀ a ghak nzeŋgòŋ nə laŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisòs ànə cep wes bum yè'sə fana yi kʉk gesə lo mʉbu, nə dʉk də, <<Tɛ̀', mvə̀k nə̀ wù à gʉ̀ fʉ̀hʉ nòŋsə nə kə̀ dzèŋ laŋ. Gʉ-a də ya mo yònə tse' kə̀kuksə̀. Mʉ nə gʉ yàm sə̀' co bwìŋ ye ŋàaŋ yo. ");
INSERT INTO yam_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wù a fa mo yònə ŋàŋ mʉtuhù bwìŋ pwe'fo', ya yi fa lùŋ nə̀ nà'a nə̀ kà mè nə bohòbʉ̀ʉ sə̀ wù a cokfis, nə fa ndzə bohòyi sə. ");
INSERT INTO yam_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lùŋ nə̀ nà'a nə̀ kà mè yuk nə, a ŋgòrì wu, nə̀ wu Nwì nə̀ wù mègù mò'fis nə ye zìnə nə, nə ye sə̀' ŋgòrì mʉ̀ʉ Jisòs Krɛst nə̀ wù à tum vèsə sə nzeŋgòŋ nə. ");
INSERT INTO yam_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mʉ̀ a kùksə wu sə nzeŋgòŋ fɛɛŋ. Mʉ̀ a gʉ̀ wes fàak sə̀ wù a tum tsə mʉ də mʉ kə gʉ sə laŋ. ");
INSERT INTO yam_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ye də Tɛ̀', jəŋ lo-a mʉ, ya mʉ kə cum vesù. Gʉ mʉ ya mʉ kə tse' kə̀kuksə̀ mvwe' mò'fis mvə̀'nə̀ vesù ànə tse' to nà' ŋga wù ka nzeŋgòŋ nə ntògʉ lok yà'a. ");
INSERT INTO yam_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","<<Bʉ̀ʉ yo sə̀ wù a cokfis wo sə nzeŋgòŋ, nə fa ndzə bohòmʉ̀ sə, mʉ̀ a gʉ̀ wo ŋgòrì wu sə̀ bòŋ. Wo à ye bʉ̀ʉ sə̀ yò, wù nə jəŋ wo, nə fa ndzə bohòmʉ̀. Wo cu sə nòŋsə ncèp nə̀ njònə sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Wo a rì tse' mok ŋga'a zìnə laŋ də bum sə̀ mʉ̀ tse' yà' pwe'fo' a tesə və̀ bohòwù. ");
INSERT INTO yam_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mʉ̀ a càsə fa wo ncèp nə̀ wù a fa nà' ndzə bohòmʉ̀ nə fana wo a ko jə nà' laŋ nə riŋ zìnə də mʉ̀ a və̀ bohòwù. Wo a dzəm tse' sə̀' də wù a tum vèsə mʉ sə nzeŋgòŋ anə. ");
INSERT INTO yam_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","<<Mʉ̀ sə lɛŋ fa wo. Mʉ̀ sə kà bohòbʉ̀ʉ sə̀ sənə nzeŋgòŋ anə nduk pwe' lɛŋ fa. Mʉ̀ sə lɛŋ fa bʉ̀ʉ sə̀ wù a fa wo ndzə bohòmʉ̀ yè'sə, bʉ̀ʉsə̀ wo bʉ̀ʉ yo wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yàm pwe'fo' sə̀ yò, Yòye bwi pwe'fo' sə̀' sə̀ yàm. Bwìŋ sə yə də mʉ tse' kə̀kuksə̀ bʉ̀ʉ tu awo sə. ");
INSERT INTO yam_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mvə̀k kʉ̀rə ŋga'a nə̀ də mʉ nə bwi foho lo bohòwù laŋ. Mʉ nə me'rə nzeŋgòŋ nə fana wo cum mali yàwo ntòca. Tɛ̀' nə̀ wu rərɛŋ, sə jəŋ ŋkərə̀ bohòwo bə nsàp ŋàŋ yònə̀ wù ànə fa mʉ nə, ya wo cum cù mò'fis sə̀' mvə̀'nə̀ vesùu cù mò'fis yè'e. ");
INSERT INTO yam_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ghà nə̀ mʉ̀ a cu ntòvesi wèŋ, mʉ̀ sə jəŋ ŋkərə̀ bohòwo bə ŋàaŋ yo sə̀ wù à fa ndzə bohòmʉ̀ sə. Mʉ̀ a jə ŋkərə̀ bohòwo bə̀boŋ fana yumok kà wo gʉ̀. Nà'a njo nə̀ mòk a ka mʉtsətsə'rə wo bisə nə. A bisə mègù yi nə̀ yi à ye ŋgòbisə tsə nə. Yi a bisə vɛ'nə ya yusə̀ wo à còm nòŋsə yà' ndzənə ŋwàk Nwì də yà'a nə̀ ye sə kʉrə vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","<<Mʉ̀ sə də mʉ bwi foho lo ŋga'a mok bohòwù. Megu kə də mʉ̀ sə cèp bum yè'e ŋga mʉ̀ cu ntòsə nzeŋgòŋ anə, ya wo kwa sə̀' dak nə̀ dak mvə̀'nə̀ mʉ kwagə̀ yàm. ");
INSERT INTO yam_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mʉ̀ a càsə fa wo ncèp nə̀ njònə laŋ, fana nzeŋgòŋ nə a bɛ̀ŋ wo bʉ̀ʉsə̀ wo ka yàwo mok bʉ̀ʉ nzeŋgòŋ nə yeŋ, sə̀' mvə̀'nə̀ mʉ̀ ka yàm ŋwə̀ə nzeŋgòŋ nə sə̀ ye yè'e. ");
INSERT INTO yam_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ka də mʉ̀ sə lɛŋ yè'sə də wu fis gɛsə wo sə nzeŋgòŋ anə yeŋ. Mʉ̀ sə lɛŋ də wu sə jəŋ ŋkərə̀ bohòwo ya ŋwə̀ nə̀ yi ŋwə̀ nə̀ bʉp nə kà wo yumok bʉp gʉ̀. ");
INSERT INTO yam_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wo ka bʉ̀ʉ nzeŋgòŋ nə yeŋ, sə̀' mʉmvə̀'nə̀ mʉ̀ ka ŋwə̀ə nzeŋgòŋ nə yeŋ yè'e. ");
INSERT INTO yam_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Niŋtsok fa wo zìnə yònə ya wo ye gɛsə yàwo zok co bʉ̀ʉ yo. Ncèp nə̀ njòo zìnə nə. ");
INSERT INTO yam_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mvə̀'nə̀ wù ànə tum gesə lo mʉ sənə nzeŋgòŋ nə fana mʉ̀ sə tum lòwo ca sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mʉ̀ sə nòŋsə ni' àm zok bohòwù bʉ̀ʉ wo ya ŋga wo ye yàwo zok bə ncèp nə̀ njònə̀ zìnə nə. ");
INSERT INTO yam_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","<<Mʉ̀ sə kà bə tu bʉ̀ʉ sə̀ wo fɛɛŋ yè'e lɛŋ mègù, mʉ̀ sə lɛŋ bə tu mok sə̀ wo nə yuk ncèp nə bohòyè'sə wèŋ, nə dzəm bohòmʉ̀ sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mʉ̀ lɛŋ də wo ye pwe' cù mò'fis. Tɛ̀', mʉ̀ lɛŋ də mvə̀'nə̀ vesùu mò'fis yè'e fana wo ye vesùwèŋ sə̀' vɛ'nə. Wo ye vɛ'nə ya bʉ̀ʉ sə̀ sənə nzeŋgòŋ nə riŋ də wù a tum və̀ mʉ sə nze anə. ");
INSERT INTO yam_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mʉ̀ a fa wo sə̀ nsàp kə̀kuk nə̀ wù à fa mʉ nə, də ya wo ye cù mò'fis sə̀' co vesù. ");
INSERT INTO yam_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mʉ nə ye sə ntʉʉ̀ wo, wù ye bwi yòsə ntʉʉ̀ mʉ̀ ya wo pwe' ye cù mò'fis nə̀ mò'fis. A ye vɛ'nə fana nzeŋgòŋ nə riŋ də wù a tum mʉ, nə riŋ sə̀' də wù dzəm bʉ̀ʉ am yè'sə wèŋ sə̀' mvə̀'nə̀ wù dzəm mʉ. ");
INSERT INTO yam_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tɛ̀', bʉ̀ʉ sə̀ wù a fa mʉ yè'sə, mʉ̀ dzəm də wo ye vesi wèŋ mvwe' sə̀ mʉ̀ cu, ya ŋga wo ye kə̀kuk nə̀ wù ànə fa mʉ ŋga wù ka nzeŋgòŋ nə ntògʉ nə. Wù à fa mʉ nsàp kə̀kuk ènə bʉ̀ʉsə̀ wù à dzəm mʉ. ");
INSERT INTO yam_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tɛ̀' nə̀ wu rərəŋ bə mandzə̀ə yo pwe', nzeŋgòŋ nə ka wu riŋ, mʉ̀ rì wu yàm laŋ. Bʉ̀ʉ yo yè'e wèŋ rì sə̀' də wù a tum və̀ mʉ tsenə. ");
INSERT INTO yam_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mʉ̀ a gʉ̀ wo, wo riŋ wu. Mʉ nə sə gʉ mali vɛ'nə ya wo tse' sə̀' nsàp dzədzəm nə̀ wù a tse' bohòmʉ̀ nə, ya ŋga mʉ nə ye sə ntʉʉ̀ wo anə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisòs ànə lɛŋ wes me pìriyà ye nə fana yi jəŋ ŋgàa fàak ye wèŋ bə yà'wèŋ to ndzəp mòk nə̀ wo togə̀ nà' də Kidròŋ, nə tesə lo mvwe' gadì mòk fa'nə. ");
INSERT INTO yam_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judàs nə̀ yi ànə seŋ Jisòs nə à rì mʉmvwe' ànə sə̀' bʉ̀ʉsə̀ Jisòs bə ŋgàa fàak ye wèŋ à sə kə̀ be'ləgə̀ fo'. ");
INSERT INTO yam_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Fana Judàs nə jəŋ ŋgo sojàa bʉ̀ʉ Rumà wèŋ nə ye bə ŋgàa kʉ̀k ndap Nwì nə̀ ghaŋ sə̀ bʉ̀ʉ Faràsi wèŋ à tum wo sə. Bʉ̀ʉ yè'sə wèŋ à bwe' tse' laàm bə kàk wèŋ nduk, nə bəhə tse' lo bum dzè' sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Wo à kə̀ dzèŋ mvwe' sə̀ Jisòs à ye sə fana ŋga yi riŋ yusə̀ yà'a nə gʉ bohòyi sə laŋ. Ànə geŋ yi tesə təəŋ və mantombìi yà'wèŋ, nə fek yà' də, <<Wèŋ sə làp ndà?>> ");
INSERT INTO yam_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wo cep fəsə də, <<Vès sə làp Jisòs nə̀ mvwe' lak Nazàrɛ nà'a.>> Jisòs dʉk fa wo də, <<A mʉ̀.>> Ànə ye yè'sə ŋga Judàs nə̀ yi à sèŋ Jisòs nə tə kok sə̀' fo' bə yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mvə̀'nə̀ Jisòs à dʉk fa wo də, <<A mʉ̀>> sə fana bʉ̀ʉ sə wèŋ sooŋ lo ma ŋkwə̀ŋkwɛ̀ŋ, nə coho gbʉ sə nze. ");
INSERT INTO yam_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yi fek fe'lə yà' sə̀mok də, <<Wèŋ sə làp ndàlɛ?>> Bʉ̀ʉ sə wèŋ cep sə̀' ŋkuŋ də, <<Vès sə làp Jisòs nə̀ mvwe' lak Nazàrɛ.>> ");
INSERT INTO yam_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisòs dʉk də, <<Mʉ̀ tsə̀' weŋ fa' laŋ də a mʉ̀ nə. A ye-a də wèŋ sə làp mʉ fana wèŋ kà-a bʉ̀ʉ yè'e wèŋ yumok gʉ̀, wèŋ me'rə wo lo yàwo sə.>> ");
INSERT INTO yam_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yi à cèp vɛ'nə ya yà'a ye megu sə̀' mvə̀'nə̀ yi ànə cep də, <<Bʉ̀ʉ sə̀ wù a fa wo ndzə bohòmʉ̀ yè'e pwe', nə̀ mò'fis nə kà bisə̀ ja'à.>> ");
INSERT INTO yam_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ànə ye vɛ'nə fana Saimʉ̀ Pità cok fis fèk ye mà mba'à, nə gbɛ' ci' mak fa moŋkwɛ̀ŋ ŋkum ŋgà fa satikà' ntu'u ma zʉ sə nze. Liŋ moŋkwɛ̀ŋ ànə à ye Malekù. ");
INSERT INTO yam_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisòs à yə vɛ'nə fana yi dʉk fa Pità nə də, <<Sòfəsə gesə fèk nə mà mba'à. Wù sə də mʉ kà ŋgə' nə̀ Tɛ̀' am a fa mʉ də mʉ ye nà' nə yə à?>> ");
INSERT INTO yam_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ànə geŋ ŋkwà' ŋwə̀ sojà nə kə jəŋ ŋgo sojà ye wèŋ, bə yà'wèŋ kə ko kiŋ Jisòs nə. Ŋgàa tək mok sə̀ mʉmvwe' ndap Nwì nə̀ ghaŋ nə à tɛsə wo sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Wo à ko yi, nə jəŋ lo to yi ntòbohòAnàs. Anàs ènə à ye tɛ̀'ɛ ŋgwe Kayofàs. Kayofàs nə ànə ye ŋkum ŋgà fa satikà' bə lùmŋgòŋ ànə yi. ");
INSERT INTO yam_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ŋwə̀ nə̀ yi à dʉk fa bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ də, a bə̀boŋ co ŋwə̀ nə̀ mò'fis kpʉ mʉnə tu bwìŋ pwe' nə, à ye sə̀' Kayofàs ènə. ");
INSERT INTO yam_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Mvə̀k ànə à ye, Saimʉ̀ Pità bə mofàk Jisòs nəmòk à yù lòJisòs nə. Ŋkum ŋgàa fa satikà' nə à rì mofàk Jisòs mòk nə fana yi me'rə nà', nà' ni lo mʉmvwe' ntòmbi ye nə. ");
INSERT INTO yam_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pità à təəŋ mam ye mvwe' ncùu ŋka' sə, nə kà fwa ni lò. Ànə geŋ mofàk Jisòs nə̀ ŋgà fa satikà' ànə riŋ nà' nə kə ye mʉŋwà nə̀ yi sə kʉ̀k ncùu sə, bə nà' cep fana wo to nisə lo Pità sə̀' mbwa. ");
INSERT INTO yam_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mvə̀'nə̀ wo à sə də wo ni lo fana mʉŋwà nə̀ yi sə kʉk ncùu sə yi nə dʉk fa Pità də, <<Mʉ̀ kwà' də wu mofàk ŋgà' ànə mòk, kè ka'-ɛ?>> Pità cep fəsə fa nà' də, <<Hai', mʉ̀ ka mòk yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ànə ye ndzəm ànə ŋga mbʉəp sə ko fana bwe fàak ŋgà fa satikà' bə ŋgàa kʉ̀k ndap Nwì nə̀ ghaŋ nə mok wèŋ fimsə mis, nə təəŋ fo' sə yuk. Fana Pità lo kə təəŋ sə̀' bə yà'wèŋ, nə sə yuk ye sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ŋkum ŋgà fa satikà' nə̀ liŋ yee Anàs nà'a à fek Jisòs bum mok bə liŋ ŋgàa fàak nà' nə ye bə yusə̀ nà' sə yə'rə fa bwìŋ sə. ");
INSERT INTO yam_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisòs də, <<Mʉ yə'rəgə̀ bwìŋ jəja mʉmvwe' ndap pìriyà nə ye mʉmvwe' ndap Nwì nə̀ ghaŋ nə, mvwe' sə̀ bʉ̀ʉ Jus wèeŋ kə̀ tɛsgə̀ tu. Mʉ̀ kà yàm yumok mvwe' sə̀swihì cèp yuk. ");
INSERT INTO yam_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ye də wù sə fek fe'lə mʉ yè'sə bʉ̀ʉ yà? To fek lɛ bʉ̀ʉ sə̀ wo à yuk bum sə̀ mʉ cèpgə̀ sə, ya wo tsok fa wu wo. Wo riŋ wes bum sə̀ mʉ cèpgə̀ sə vɛ'ɛ làaŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisòs ànə cep vɛ'nə fana dògarì mòk nə̀ yi à ye fo' ləp sam yi bə bo mpaaŋ. Yi də, <<Kàcò, yà'a mvə̀'nə̀ wo cèpgə̀ bohòŋkum ŋgà fa satikà' vɛ'nə à?>> ");
INSERT INTO yam_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisòs dʉk fa nà' də, <<A ye-a də mʉ̀ cèp bə jòŋ bwɛ̀rɛ də wù dʉk sə̀ də mʉ̀ sə cèp bə jòŋ. A ye-a ŋga yusə̀ mʉ̀ cèp sə mvə̀k nə, wù ləp mʉ kə bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ànə geŋ Anàs tumsə lo Jisòs nə mvə̀'nə̀ wo tasə tse' yi bə kwaŋ bohòKayofàs nə̀ yi sə̀' ŋkum ŋgà fa satikà' mòk. ");
INSERT INTO yam_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimʉ̀ Pità nə à təəŋ, nə sə yuk mali mis sə fana wo dʉk fa yi də, <<Vès kwà' də wu lɛ mo ŋgà fàk ŋgà' ànə mòk kè ka'-ɛ?>> Pità dzeeŋ də, <<Hai' kà mʉ yàm to.>> ");
INSERT INTO yam_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mo ŋkwɛ̀ŋ ŋkum ŋgà fa satikà' mòk, nə̀ yi à ye moma ŋwə̀ nə̀ Pità anə gbɛ̀' tiŋ mak yi ntu' nə cep ye sə̀'. Yi dʉk də, <<Mʉ̀ tsəm də mʉ̀ anə ye wu mʉ gadì bə lis am.>> ");
INSERT INTO yam_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pità nə dzeeŋ fe'lə sə̀mok fana ntomvəp to sə̀' ghà ànə. ");
INSERT INTO yam_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mvəp à sə to nə̀ zəzòŋ fana wo jəŋ fis Jisòs mvwe' ndap Kayofàs, bə yà'wèŋ lo mvwe' nto' Govənònə yi mo lak Rumà. Bʉ̀ʉ Jus wèŋ à ka yàwo mbwa ni bʉ̀ʉsə̀ wo à sə dzəm ŋgònòŋsə ni' awo rərɛŋ ya wo kə zʉ ŋkàk pasobà àwo. ");
INSERT INTO yam_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ànə geŋ GovənòPalè nə kə tseŋ wo sə mbi, nə fek yà'wèŋ də, <<Wèŋ ko və̀ ŋwə̀ nè'e bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wo dʉk fa nà' də, <<Anə ye-a də ŋwə̀ ènə kà ŋwə̀ nə̀ bʉp yeŋ bwɛ̀rɛ də vès kà yi bohòwù fɛɛŋ jə və̀.>> ");
INSERT INTO yam_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Palè nə dʉk fa wo də, <<Wenə wèeŋ foho lo, wèeŋ kə sak yi mvə̀'nə̀ lʉ̀ʉk awèŋ sə dʉk weŋ.>> Wo dʉk fa yi də, <<Vès ka ŋàaŋ sə̀ ŋgòsak nzak kpʉ bwìŋ tse'.>> ");
INSERT INTO yam_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mvə̀'nə̀ wo à gʉ̀ vɛ'nə fana yà' gʉ də Jisòos kpʉ nsàp kpʉ nə̀ yi à tsə̀' fa bwìŋ də yi nə kpʉ nà' nə. ");
INSERT INTO yam_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Palè à bwì foho ni lòmʉ nto', nə to Jisòs də nà'a və. Jisòs à və̀ə, yi fek nà' də, <<Wù də wu ŋkum bʉ̀ʉ Jus ɛ̀?>> ");
INSERT INTO yam_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisòs də, <<Yusə̀ wù sə fek mʉ yè'sə tesə kok sə və̀ə wù kè a cùu bʉ̀ʉ mok wèŋ nɛ̀?>> ");
INSERT INTO yam_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Palè dʉk fəsə fa nà' də, <<Wù yə mʉ co də mʉ ŋwə̀ə Jus à? Ŋgàa fa satikà' sə̀ ghaŋ bə bʉ̀ʉ yo wèŋ jə və̀ wu bohòmʉ̀ fɛŋ wo. Wù gʉ̀ bʉpsə yà, tsok fa mʉ.>> ");
INSERT INTO yam_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisòs də, <<Gaŋ ŋkum sə̀ yàm sə ka sə̀ sə nzeŋgòoŋ fɛŋ yeŋ. Gaŋ yàm sə nə ye-a sə̀ sə nze fɛŋ, bwɛ̀rɛ də bwe fàak am wèŋ lʉ̀ fa mʉ bʉ̀ʉ Jus sə wèŋ də ya wo kà mʉ yumok gʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Palè nə fek nà' də, <<Wù sə də wu ŋkum è kèe yàlɛ?>> Jisòs dʉk də, <<Njo nə̀ mʉ̀ à və̀ sə nzeŋgòŋ fɛŋ bʉ̀ʉ zeŋ nə mègù mò'fis də mʉ niŋtsok fa bwìŋ zìnə nə. Nà'a njo nə̀ wo à dzə mʉ nə. Ŋwə̀ nə̀ yi təəŋ-a ma nə̀ zìnə nə fana yi nə yu'rə bohòmʉ̀ mvə̀'nə̀ mʉ̀ sə cèep.>> ");
INSERT INTO yam_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Palè də, <<Zìnəə yu yà?>> Yi à dʉk wes vɛ'nə fana yi lokok, nə tesə lo sə mbi, nə kə tseŋ bʉ̀ʉ Jus sə̀ wo ca sə. Yi dʉk fa yà'wèŋ də, <<Mʉ̀ ka yàm jòŋ nə̀ ŋgà' ènə gʉ̀ʉ ye.>> ");
INSERT INTO yam_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yi cep fe'lə mok sə̀' də, <<A bum lak awèŋ də ŋkàha pasobàa kə̀ dzèŋgə̀ə, mʉ̀ fis me'rə fa weŋ ŋgà ndapndzəm mòk mò'fis. Ye də wèŋ dzəm də mʉ fis me'rə fa weŋ ŋkum bʉ̀ʉ Jus nə à?>> ");
INSERT INTO yam_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wo à yuk vɛ'nə, wo kɛ'ŋgùŋ dʉk nə̀ bʉp də, <<Vès ka ŋwə̀ ànə dzəm. Fis me'rə fa ves lɛ Bàrabà.>> Bàrabà ènə à ye ncoro' njə̀ nə̀ kpʉ bwìŋ. ");
INSERT INTO yam_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ànə ye vɛ'nə fana Palè gʉ wo jəŋ Jisòs nə, nə ləp nà'. ");
INSERT INTO yam_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sojà wèŋ kə jəŋ ndik sə̀ yà'a njə̀njàk, nə bak yà', nə tes fa Jisòs nə nà' mʉ tuhù co tàm ŋkum. Wo jəŋ cə̀k mòk nə̀ bə̀baŋ, nə ni fa yi nà' co cə̀k ŋkum. ");
INSERT INTO yam_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wo ye ŋgòvə̀hə bohòyi, nə sə cepsə nà' co ŋkum. Wo sə dʉhʉ də, <<Mbè ŋkum bʉ̀ʉ Jus wèŋ.>> Wo ywi'lə yi, nə sə ləp yi bə bo. ");
INSERT INTO yam_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Palè nə à tesə və̀ sə mbi mvwe' sə̀ bʉ̀ʉ Jus wèŋ cu sə sə̀mok. Yi dʉk fa yà' də, <<Wèeŋ yeè, mʉ nə fis və ŋwə̀ ènə sə mbi ya wèeŋ riŋ tse' də mʉ̀ ka yàm yusə̀ yi bʉpsə sə riŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ànə geŋ Jisòs nə tesə tsoŋ ŋga yi ta tse' mali tàm njə̀njàk nə mʉ tuhù yi, nə ni tse' cə̀k ŋkum nə sə̀'. Fana Palè nə dʉk fa wo də, <<Wèeŋ yeè, yi nè'.>> ");
INSERT INTO yam_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ŋgàa fa satikà' sə̀ ghaŋ bə dògarìi sə̀ mʉmvwe' ndap Nwì sə wèŋ à yə yi fana wo kɛ'ŋgùŋ, nə sə dʉk də, <<Wèeŋ tɛ'lə yi mʉ ntə̀əŋ. Wèeŋ tɛ'lə yi mʉ ntə̀əŋ.>> Palè nə dʉk fa wo də, <<Wèeŋ jəŋ lo-a, nə kə tɛ'lə yi wèŋ. Bohòmʉ̀ yàm, mʉ̀ ka yàm bʉp nə̀ yi gʉ̀ʉ ye lok.>> ");
INSERT INTO yam_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bʉ̀ʉ Jus sə wèŋ dʉk də, <<A ye-a bə mandzə̀ lʉ̀ʉk avès fana ŋwə̀ ènə nə kpʉ megu kpʉʉ bʉ̀ʉsə̀ yi sə jə ni' ye də yi mo Nwì.>> ");
INSERT INTO yam_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Palè nə à yuk vɛ'nə fana wʉə ko yi vɛ'ɛ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yi bwi foho və kə ni lo fe'lə mʉ nto' anə bə Jisòs sə̀mok, nə fek nà' də, <<Wù və̀ yè'sə ma fò?>> Jisòs nə kà cù mùk. ");
INSERT INTO yam_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Palè nə fek nà' də, <<Mʉ̀ sə cèep, wù kà cèp à? Wù ka riŋ də mʉ̀ tse' ŋàaŋ sə̀ ŋgòmè'rə wu, wù lo, nə tse' bwi ŋàaŋ sə̀ co mʉ̀ tɛ'lə wu mʉ ntə̀əŋ sə̀' riŋ à?>> ");
INSERT INTO yam_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisòs dʉk fa nà' də, <<Fa wu ŋàaŋ yà'sə Nwì. Anə ka-a vɛ'nə yeŋ bwɛ̀rɛ də wù kà ŋàŋ mʉ tuhù mʉ̀ tse' to. Ŋwə̀ nə̀ yi jə və̀ mʉ, nə kə fa ndzə bohòwù nə gʉ̀ ghak bʉp yi.>> ");
INSERT INTO yam_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Palè ànə yuk ncèp ènə fana yi lap mandzə̀ co yi me'rə Jisòs nə lo. Megu kə də bʉ̀ʉ Jus sə wèŋ sə fuŋ mali fo' də, <<A ye-a ŋga wù me'rə ŋwə̀ ènə fana ye də wù ka mok ŋge' Kaisà, ŋkum nə̀ ghaŋ nə̀ yi tse' vesùwèŋ yi mvwe' lak Rumà nà'a yeŋ. Bʉsə̀ wù riŋ də ŋwə̀ nə̀ yi sə jə-a ni' ye co ŋkum fana ye də yi sə nə̀ŋ fa ŋkum Kaisà kù mʉ tuhù.>> ");
INSERT INTO yam_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Palè nə ànə yuk ncèp ènə fana yi kə fis və Jisòs nə sə mbi, nə ca kok cum mʉmvwe' kapràak ye. Wo à sə to mvwe' kapràak sə də, <<Mbàndap lìs.>> Wo to fo' bə ncèep lak bʉ̀ʉ Hibrù wèŋ də, Gàbàtà. ");
INSERT INTO yam_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bum yè'sə ànə sə ye yè'sə ŋga a nùmbu nə̀ ŋga ndzəm seŋ tsoŋ fana ye dzə̀. Mvə̀k ànə a ye sə̀' ŋga a mvə̀k ŋkàha Pasobà. À sə kʉəp lòco maràŋ fana Palè nə dʉk fa bʉ̀ʉ sə wèŋ də, <<Wèeŋ ja'a ŋkum awèŋ nə nè'.>> ");
INSERT INTO yam_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wo kɛ'ŋgùŋ də, <<Jəŋ gɛsə lo yi fo'. Yi kpʉ megu kpʉʉ. Wèeŋ kə tɛ'lə yi mʉ ntə̀əŋ.>> Palè nə fek wo də, <<Mʉ tɛ'lə ŋkum awèŋ nə mʉ ntə̀əŋ nà?>> Ŋgàa fa satikà' sə̀ ghaŋ wèŋ sə à dʉk yàwo də, <<Vès rì mègù yàvès ŋkum Kaisà yiìyi.>> ");
INSERT INTO yam_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yà'a yusə̀ yà' à gʉ̀ʉ fana Palè me'rə fa wo Jisòs də wo tɛ'lə nà' mʉ ntə̀əŋ. Fana sojàa sə wèŋ jəŋ lo Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yi à bə̀k tse' ntə̀əŋ ye yi mʉ ŋkambə̀hə yi bə tu ye fana bə sojàa sə wèŋ tesə mʉ ntòlak anə, nə lo kə dzeŋ mvwe' mok sə̀ wo togə̀ fo' də, Nzʉ̀ə̀ tu bwìŋ. Wo to fo' bə ncèep lak bʉ̀ʉ Hibrù wèŋ də, <<Gòrìgotà.>> ");
INSERT INTO yam_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yà'a mvwe' sə̀ sojàa sə wèŋ à tɛ'lə yi sə. Wo à tɛ'lə yi bə bʉ̀ʉ mok wèŋ bwìŋ ba. Mòk ye bo ma màk, mòk ye ye bo ma ŋkwìp, Jisòs nə təəŋ ye mʉtsətsə'rə̀. ");
INSERT INTO yam_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Palè ànə com naaŋ yak yumok mʉ tu ntə̀ŋ anə. Yi à còm də, Jisòs nə̀ mvwe' lak Nazàrɛ, ŋkum bʉ̀ʉ Jus wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wo à còm yà' bə ncèep lak zəzok tɛ'. Mòk à ye ncèep lak Hibrù, mòk Rumà nə ye Gris. Bʉ̀ʉ Jus wèŋ a ta yusə̀ wo à còm naaŋ sə vɛ'ɛ bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ, bʉ̀ʉsə̀ mvwe' sə̀ wo ànə tɛ'lə yi sə à kʉəp lòmʉ ntòlak. ");
INSERT INTO yam_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ŋgàa fa satikà'a bʉ̀ʉ Jus sə wèŋ à yə fana wo kə dʉk fa Palè nə də nà'a kà də <<Nè'e Ŋkum bʉ̀ʉ Jus wèŋ>> còm. Wo də nà'a com lɛ də, <<Ŋwə̀ ènə dʉk yi də yi ŋkum bʉ̀ʉ Jus wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Palè nə dʉk wo də, <<Yusə̀ mʉ̀ còm yà' laŋ, ye də yà' mè vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ghà nə̀ sojàa sə wèŋ à tɛ'lə wes yi mʉ ntə̀əŋ anə fana wo jəŋ cə̀ək ye sə, nə gapsə yà' bòp kwè, sojàa sə jəŋ mò'fis, mò'fis. À bwehe cu mègù mok sàro ye, nə̀ nà' à ye lòŋtòŋ, nə kà cù mvwe' sə̀ wo à tè' tè'lə tse'. ");
INSERT INTO yam_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ànə geŋ wo dʉk də, <<Vesùwèeŋ kà nà' sàrə̀ bʉpsə̀. A təm bèŋ fo' ya a riŋ ŋwə̀ nə̀ yi nə zʉ nà'.>> Yè'sə ànə sə ye vɛ'nə fana yà' megu mvə̀'nə̀ wo ànə com yà' ndzənə ŋwàk Nwì sə. Wo ànə com nja də, Wo a jə cə̀ək am, nə gapsə jəŋ yà', nə sə təm bèŋ də ya wo ye ŋwə̀ nə̀ yi nə jəŋ cə̀k àm mòk. Yà'a mvə̀'nə̀ sojàa sə wèŋ à gʉ̀ sə. ");
INSERT INTO yam_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bʉ̀ʉ sə̀ wo à təəŋ kʉəp lòmvwe' ntə̀əŋ sə̀ wo à tɛ'lə Jisòs mbwa sə à ye ma Jisòs nə bə moma ma ye nə nə̀ ŋwàŋwè. Mòk à ye fe'lə fo' Mèri nə̀ yi ŋgwe Klopà bə Mèri nə̀ mvwe' lak Màdàlinà nà'a. ");
INSERT INTO yam_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisòs ànə ye ma ye bə mofàk ye nə̀ yi à sə dzəmgə̀ nà' wùriŋ nə mvə̀'nə̀ wo tə kok fo' fana yi dʉk fa ma ye nə də, <<Màmi, kʉ̀k mo yòo nà'.>> ");
INSERT INTO yam_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nə bʉʉŋ dʉk fa mofàk ye nə sə̀' də, <<Kʉ̀k ma yoo nà'.>> Ye jəŋ mvə̀k ànə, mofàk ye nə à jə lòma Jisòs, nə sə kə cum mok bə nà'. ");
INSERT INTO yam_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yà'sə à mèe, Jisòs riŋ də fàak ye mè mok sə̀ laŋ fana yi dʉk də, <<Njè ndzəp sə ya mʉ.>> Yi ànə cep yè'sə də ya yusə̀ wo à còm nòŋsə yà' ndzənə Ŋwàk Nwì sə bʉʉŋ və zìnə. ");
INSERT INTO yam_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ànə ye ŋga ŋgàp mòk à ye fo' bə rùuk sə̀ cəcəp ca. Fana wo jəŋ kùsa, nə tsəp gesə sənə rùuk sə, nə tse' gesə nà' bə ntatʉ kə̀ cùhu Jisòs anə. ");
INSERT INTO yam_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisòs à no yà' fana yi dʉk də, <<Yà' mè mok laŋ.>> Fana yi zəm tsoŋ tu ye sə nze, nə fis me'rə yòŋsə̀ ye. ");
INSERT INTO yam_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nùmbu ànə à ye nùmbu nə̀ wo à sə fʉ̀hʉ də ndzəm seŋ tsə fana ye dzə̀. Wo à ka dzəm də nùmbu dzə̀ə ye ŋga vèeŋ bwìŋ kə̀ mʉ ntə̀əŋ dzəm. Dzə̀ ànə à ye sə̀' nə̀ ghaŋ wùriŋ. Fana bʉ̀ʉ Jus sə wèŋ kə fek Palè də nà'a fa wo mandzə̀ ya wo kə dzəp kʉ'rə vəp bʉ̀ʉ sə̀ wo tɛ'lə yà'wèŋ sə ya yà'wèeŋ kpʉ toho ŋga wo kə tuuŋ. ");
INSERT INTO yam_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ànə geŋ sojàa sə wèŋ lo kə dzəp kʉ'rə nə̀ mò'fis, nə kə kʉ'rə nə̀ ba, wo sə̀ wo à tɛ'lə wo bə Jisòs wèŋ sə. ");
INSERT INTO yam_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Wo à kə̀ dzèŋ bohòJisòs fana wo ye ŋga yi kpʉ ye sə laŋ, wo me'rə yi, nə kà kùu ye sə mok dzə̀p kʉ'rə̀. ");
INSERT INTO yam_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sojà mòk à jə kòoŋ ye, nə sop Jisòs bə zeŋ fʉ nca mvàa vàap. Ndʉəm bə ndzəp caŋ tesə tsoŋ fo'. ");
INSERT INTO yam_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ŋwə̀ nə̀ yi à yə bum yè'sə bə lis mvə̀'nə̀ yà' ànə ye nə, sə tsə̀' yè'sə yi. Yi sə cèp zìnə, nə riŋ də yi sə cep yusə̀ yà' ànə ye vɛ'nə. Yi sə tsòho fa weŋ bum yè'sə də ya wèeŋ dzəm yàwèŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bum yè'sə à sə ye vɛ'nə ya yà'a kə bʉʉŋ və megu mvə̀'nə̀ wo ànə com ndzənə ŋwàk Nwì sə. Wo à còm də, <<Wo nə kà vəp ye nə̀ mò'fis kʉp.>> ");
INSERT INTO yam_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wo à còm mok mvwe' mòk nja sə̀' də, <<Bwìiŋ nə ye ŋwə̀ nə̀ wo à sòp yi nə.>> ");
INSERT INTO yam_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yà'sə à mèe, fana ŋwə̀ nəmòk nə̀ wo à sə togə̀ yi də Jòsep à və̀ kə̀ ye Palè, nə lɛŋ nà' də yi kə jəŋ vèŋ Jisòs nə. Palè à dzəm, fana yi lo, nə kə jəŋ nà'. Liŋ lak Jòsep ènə à ye də Àrìmàtayà. Yi ànə ye sə̀' ŋwə̀ nə̀ yi à yù mandzə̀ Jisòs, nə sə swihi, swihi bʉ̀ʉsə̀ yi à sə wəp bʉ̀ʉ Jus wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nìkòdemù nə̀ yi ànə kə tseŋ nooŋ Jisòs fa' ndzəmə̀ nà'a à ye sə̀' bə Jòsep nə bəbɛ'. Yi à kə̀ jə və̀ nsàap ncə̀əp mok sə̀ wo to yà' də, <<Me>> bə mòk də, <<Alò>> wèŋ nduk. Ncə̀əp sə à rwì' dzèŋ co kilù hum tàŋ vɛ'ɛ. ");
INSERT INTO yam_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wo à jə vèŋ ni' Jisòs nə, nə lim gesə ndzənə cə̀k bə ncə̀əp sə wèŋ, bʉ̀ʉsə̀ yà'a mvə̀'nə̀ bʉ̀ʉ Jus wèeŋ tuuŋgə̀ bwìŋ vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mvwe' sə̀ wo à tɛ'lə Jisòs mʉ ntə̀əŋ sə, gadì mòk à kʉəp kok fo'. Sè à ye mʉ gadì anə sə̀ wo à ka ŋwə̀ nəmòk ca ntòtuuŋ yuk. ");
INSERT INTO yam_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ànə ye də nùmbu ànə à ye nùmbu nə̀ wo sə fʉ̀hʉ də ndzəm seŋ tsoŋ fana ye dzə̀ fana wo caŋ tuuŋ gesə Jisòs nə mok fa'nə bʉ̀ʉsə̀ mvwe' sə à ye mvwe' jəjo. ");
INSERT INTO yam_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nùmbu nə̀ tɛ' à ye ŋga a nù Sondè, nə̀ zəzòŋ ŋga cu ntòjàrə jàrə fana Mèri nə̀ mvwe' lak Màdalà à lòkok, nə lo mvwe' sèe sə. À kə̀ dzèŋ fo', yi ye ŋga wo dzərə fis gɛsə ma lìs nə̀ wo à lok ncùu sèe sə bə zeŋ nə laŋ. ");
INSERT INTO yam_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yi caŋ bwi foho lo, nə kə tseŋ Saimʉ̀ Pità bə mo fàk Jisòs nə̀ Jisòs à sə dzəmgə̀ yi wùriŋ nə, fana yi tsok yà' də, <<Wo fis gɛsə lòvèŋ ni' Tà nə sə mvwe' sèe sə̀ wo a tuuŋ yi ca sə laŋ. Vès ka mvwe' sə̀ wo jə lòyi sə mok riŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pità bə mo fàk mòk nə caŋ lo mvwe' sèe sə. ");
INSERT INTO yam_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mo fàk mòk nə caŋ ghak Pità, nə lo ye mantombì kə dzeŋ mvwe' sèe sə. ");
INSERT INTO yam_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yi à kə̀ bʉhʉ, nə kʉk gesə sənə sèe sə. Yi ye megu cə̀ək sə̀ wo à lim vèŋ Jisòs bə zeŋ sə, nə kà ca ni lò. ");
INSERT INTO yam_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ànə geŋ Saimʉ̀ Pità nə̀ yi à sə bɛ' və̀ nà' nə à kə̀ dzèŋ ye. Yi ca ni lo sə mvwe' sèe sə jwaŋ. Yi ye cə̀ək sə̀ wo à tuuŋ nà' bə zeŋ sə ŋga yà' nòca. ");
INSERT INTO yam_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Yi ye cə̀k nə̀ wo à lim tu Jisòs bə zeŋ nə ŋga wo lim benə nà' pwe', nà' nooŋ ca zok. ");
INSERT INTO yam_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Fana mo fàk mòk nə̀ yi à kə̀ dzèŋ to fo' yi nə ni lo ca sə̀'. Yi ye, nə dzəm də Jisòs nə lòkok laŋ. ");
INSERT INTO yam_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","À kə̀ dzèŋ haaŋ mvə̀k ànə ŋga wo ka bə ncèp nə̀ wo à còm nà' ndzənə ŋwàk Nwì də Jisòos nə kpʉ, nə lokok nà'a ntòrɛɛŋ. ");
INSERT INTO yam_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ànə geŋ ŋgàa fàak Jisòs yà'sə wèŋ bwi foho lo lak. ");
INSERT INTO yam_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mèri à bwì və̀ mvwe' sèe sə, nə kə təəŋ fo' sə mbiŋ, nə sə waŋ. Yi ànə sə waŋ fana yi bʉhʉ tsoŋ, nə kʉk gesə lo sənə sèe sə. ");
INSERT INTO yam_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Yi ye masinjàa Nwì ba ŋga wo nitse' cə̀ək sə̀ fəfop pup pup. Wo à cu mvwe' sə̀ wo ànə noŋsə vèŋ ni' Jisòs fo' sə. Mòk à cu mvwe' sə̀ tu Jisòs à ye fana mòk cum mvwe' sə̀ kùu ye ànə ye sə. ");
INSERT INTO yam_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wo fek yi də, <<Wù sə wa yà, màmi?>> Yi dʉk fa yà' də, <<Wo jə lòTà àm. Mʉ̀ ka mvwe' sə̀ wo kə̀ nòŋsə yi sə riŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yi ànə cep wes vɛ'nə fana yi bʉʉŋ, nə ye Jisòs ŋga nà' tə kok fo' fana yi kà nà' rì. ");
INSERT INTO yam_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisòs nə fek yi sə̀' də, <<Wù sə wa yà màmi? Wù sə làp ndà?>> À gʉ̀ bohòMèri nə co nà'nə ŋwə̀ nə̀ yi sə kʉ̀k gadì nə̀ fo' nə yi fana Mèri nə dʉk fa nà' də, <<Tɛ̀'mòk, a ye-a ŋga wù jə lòyi wù fana wù kə niŋ fa mʉ mvwe' sə, ya mʉ kə jəŋ yi.>> ");
INSERT INTO yam_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisòs nə to nà' bə liŋ də, <<Mèri.>> Mèri bʉʉŋ, nə cep fa nà' bə ncèep lak Hibrù wèŋ dʉk də, <<Ràbonì.>> Ncèp nə̀ də Ràbonì ànə yà'sə də, <<Cicà àm.>> ");
INSERT INTO yam_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisòs dʉk fa nà' də, <<Kà mʉ koho tse' bʉ̀ʉsə̀ mʉ̀ ka mʉ bohòTɛ̀' am ntòlo. Dù lo, nə kə tsok fa bwema am wèŋ də mʉ̀ tə lə̀lòmʉ la'à Tɛ̀' am, nə̀ yi sə̀' Tɛ̀' àwèŋ nə. A yi nə̀ yi Nwì àm, yi sə̀' Nwì àwèŋ pwe'.>> ");
INSERT INTO yam_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mèri nə à lòo, nə kə tsok fa ŋgàa fàak nà' sə wèŋ də yi yə Tà Jisòs laŋ. Yi à tsòho fa wo yusə̀ nà' à cèp bohòyi sə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","À kə̀ dzèŋ nùmbu ànə, nə̀ ntɛŋ à yèto ànə ŋga a nconùm, ŋgàa fàak Jisòs sə wèŋ kə be'lə cum mʉmvwe' ndap mòk mvwe' mò'fis. Wo ànə lok ncù bʉ̀ʉsə̀ wo à sə wəp bʉ̀ʉ Jus wèŋ. Wo də wo kʉk à, ŋga Jisòs nə tə nè' mʉtsətsə'rə wo anə. Yi cepsə yà' də, <<Fifi ye bohòwèŋ lòoŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jisòs ànə cep wes vɛ'nə fana yi niŋtsok fa wo bo ye bə ncanmvàaŋ ye. Ŋgàa fàak ye sə à yə Tà nə, wo kwa vɛ'ɛ wù kà fʉ̀'. ");
INSERT INTO yam_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisòs nə dʉk fe'lə fa yà' sə̀mok də, <<Fifi ye bohòwèŋ.>> Nə dʉk mok sə̀' də, <<Mvə̀'nə̀ Tɛ̀' am à tum mʉ, mʉ̀ sə tumsə lòweŋ sə̀' vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ànə geŋ yi yoŋsə fa yà'wèŋ yòŋsə̀, nə dʉk də, <<Wèeŋ jəŋ, mʉ̀ yòŋsə̀ fa weŋ Yòŋsə̀ nə̀ Rərɛŋ. ");
INSERT INTO yam_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ye də a ye-a ŋga wèŋ swì fa ŋwə̀ nəmòk bʉp ye fana Nwìi nə swi fa ŋgə̀ŋgàŋ sə̀'. A ye-a ŋga wèŋ ka də wèŋ swì fa yi bʉp ye nə dʉk, fana Nwìi nə kà ŋgə̀ŋgàŋ sə̀' swì fa.>> ");
INSERT INTO yam_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ghà nə̀ Jisòs ànə kə tseŋ me ŋgàa fàak ye wèŋ fa' yà'a à ye ŋga Tomos nə̀ wo togə̀ yi mok də mofɛs nà'a ka ye fo' yeŋ. Yi ànə ye mòk mʉŋgorə̀ wo sə̀ hum-ncòp-ba sə. ");
INSERT INTO yam_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tomos nə à və̀ maŋkwɛ̀ŋ fana wo tsok fa yi də, <<Vès yə Tà àvès nə laŋ.>> Tomos nə dʉk ye də, <<A ye-a ŋga mʉ̀ ka mvwe' mbɛŋ sə̀ wo à ta yi luwa yà'a ye nə kà bə ndubo àm jwɛŋ, nə kà bo am mvwe' sə̀ wo à sòp yi fʉ ncanvàa yà'a sògèsə̀, ye də mʉ nə kà yàm də a zìnə dzəm yuk.>> ");
INSERT INTO yam_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","À kə̀ cà nùumbu fwame' fana ŋgàa fàak Jisòs sə kə benə fe'lə mʉ nda'à sə̀mok. À ye mok ŋga Tomos nə fo' bə yà'wèŋ. Wo ànə lok ncùu sə lo'o fana wo ye ŋga Jisòs nə tə cà mʉtsətsə'rəə wo sə̀mok. Yi cepsə yà' də, <<Fifi ye bohòwèŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yi dʉk fa Tomos də, <<Jwɛŋ ja'a yòo bo am ɛ̀. Jəŋ bo yo, nə jwɛŋ ja'a mvwe' nə̀ fʉ ncanmvàaŋ mʉ̀ nə ɛ̀. Kà də wu sə mərə fe'lə mok dʉk, dzəm lɛ mok dzəmə.>> ");
INSERT INTO yam_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomos dʉk fa nà' də, <<Tà àm, nə ye Nwì àm.>> ");
INSERT INTO yam_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisòs dʉk fa nà' də, <<Wù dzəə̀m nə ŋga'a bʉ̀ʉsə̀ wù yə mʉ bə lis yo. Anə ye rɛŋsi bohòbʉ̀ʉ sə̀ wo ka bə lis ntòye, nə dzəm yà'.>> ");
INSERT INTO yam_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisòs à gʉ̀hʉ maŋgəŋgèeŋ mok mʉ lisə̀ ŋgàa fàak ye sə wèŋ wùriŋ. Wo à ka yà'sə ndzənə ŋwàk nè'e com gesə. ");
INSERT INTO yam_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bum sə̀ wo a còm yà' yè'e, wo à còm də ya wèeŋ dzəm də Jisòos Ŋkum ŋgà gèm bwìŋ nə̀ yi mo Nwì nə. Wèeŋ dzəm bohòyi vɛ'nə fana wèŋ tse' lùŋ nə̀ zìnə nə̀ nà'a bə liŋ ye nə. ");
INSERT INTO yam_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mvə̀k nəmòk à ye sə̀' nə̀ Jisòs ànə niŋ ni' ye bohòŋgàa fàak ye mok wèŋ ŋga wo mvwe' tə̀m Tìberiyà. Yè'e mvə̀'nə̀ yà' ànə ye sə. ");
INSERT INTO yam_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nùmbu mòk à ye ŋga Saimʉ̀ Pità cu mvwe' mò'fis bə Tomos nə̀ wo togə̀ yi mok də mofɛs, bə Nàtaniyà nə̀ yi à və̀ mvwe' lak Kanà nə̀ mvwe' nzeŋgòŋ Galìli. Bwe Zebèdi à ye fo' ba, nə ye mok wèŋ sə̀' bwìŋ ba. ");
INSERT INTO yam_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimʉ̀ Pità à dʉk fa wo də, <<Mʉ̀ sə lòyu am mvwe' fu'fuk.>> Wo dʉk bwi yàwo sə̀' də, <<Vès dzəm ŋgòlòvesùwèŋ bəbɛ'.>> Fana wo tesə lo kə ni ŋgwes mok, nə lo. Wo à fuk nòoŋ tsə ciŋ, ciŋ, nə kà yumok ko. ");
INSERT INTO yam_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tsok à rɛŋ ŋga nùm sə də yi bap kok fana Jisòs nə tesə təəŋ ndzə ŋgʉ ndzəp anə. Wo kà rì də a yi nə rì. ");
INSERT INTO yam_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jisòs nə fek gesə yà' də, <<Ŋgàta, wèŋ ko yumok à?>> Wo də, <<Hai'.>> ");
INSERT INTO yam_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yi dʉk fa yà' də, <<Wèeŋ jəŋ-a ram sə nə mak tsoŋ gesə-a yà' bo ma zʉ, ŋgʉ ŋgwes nə fa'a ɛ̀. Wèeŋ nə ko fuk fo'.>> Fana wo mak gesə ma nə̀ yi dʉk nə. Fuk ni ca nsàp nə̀ à ghak wo ŋgòsə̀ fəsə və̀ ram sə sə ŋgwesə̀ anə. ");
INSERT INTO yam_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mofàk Jisòs nə̀ yi à sə dzəmgə̀ nà' wùriŋ nə à dʉk fa Pità də, <<Nà'nə Tà.>> Pità ànə yuk vɛ'nə fana yi te' ni cə̀ək ye bʉ̀ʉsə̀ à ye ŋga yi a fweŋ cə̀ək ye sə də ya yi gʉ fàk. Ànə geŋ yi li ni sə ndzəpə̀ anə, nə lo kə ye Jisòs. ");
INSERT INTO yam_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bwe ye mok sə wèŋ à cu malì sə ŋgwesə̀ anə. Wo sə və sə̀', nə sə soŋ və ram nə ŋga nà' rwiŋ bə fuk ca wùriŋ. Mvwe' sə̀ wo à ye sə, ŋgòkə̀ dzèŋ mʉ mfèŋ à ka sə̀sap sə̀' yeŋ. Yà' à ye megu co mità ŋkʉ̀ mò'fis. ");
INSERT INTO yam_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wo à kə̀ tesə mʉ mfèŋ fana wo ye ŋga mis sə kə bə fuk ca nə ye bə brɛd sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisòs dʉk fa wo də, <<Wèeŋ fis jə və fuk mok sə̀ wèŋ ko sə fɛn.>> ");
INSERT INTO yam_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimʉ̀ Pità à bwì lòmvwe' ŋgwes nə sə̀mok. Yi soŋ fis və ram nə mʉ mfèŋ. Fuk sə̀ ghaŋ à rwiŋ ca vɛ'ɛ hip. Yà' à ye pwe' ŋkʉ̀ mò'fis bə fuk hum tàŋ-ncòp-tɛ'. Fuk sə à ye ca ŋkʉ̀ʉŋ vɛ'nə, ram nə kà sə̀' sàhà. ");
INSERT INTO yam_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisòs dʉk fa wo də, <<Wèeŋ və kə zʉ.>> Fana wo və. Mʉtsətsə'rəə bwe ye sə pwe', ŋwə̀ nə̀ mò'fis co yi baŋ ntʉm, nə fek-a nà' də, <<Wu yè'sə ndà?>> à ka ye lok. Wo à rì də a Tà nə. ");
INSERT INTO yam_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisòs à kə̀ jə brɛd nə, nə bə'rə gapsə fa wo bə fuk sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ghà nə̀ Jisòs à lòkok mvwe' kpʉ fana nè'e nə̀ kɛ̀' tɛ' mvə̀'nə̀ yi à niŋ fa ni' ye bohòŋgàa fàak ye wèŋ. ");
INSERT INTO yam_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wo ànə zʉ wes fana Jisòs nə fek Pità də, <<Saimʉ̀ mo Jon, wù dzəm mʉ bə ntʉm yòpwe' nə casə yè'e pwe' à?>> Pità də, <<Ŋ̀, Tà, wù rì də mʉ̀ dzəm wu.>> Yi dʉk fa nà' də, <<A ye-a də wù dzəm mʉ fana wu sə kʉk fa mʉ lis bə bwe nsùŋgaaŋ am.>> ");
INSERT INTO yam_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisòs cep fe'lə bohòPità nə, nə̀ kɛ̀' ba də, <<Saimʉ̀ mo Jon, wù dzəm mʉ bə ntʉm yòpwe' à?>> Yi dʉk fəsə fa nà' sə̀mok də, <<Ŋ̀, Tà, wù rì də mʉ̀ dzəm wu.>> Yi dʉk fa nà' sə̀mok də, <<Sə gʉ̀msə fa-a mʉ nsùŋgaaŋ am.>> ");
INSERT INTO yam_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mok nə̀ kɛ̀' tɛ', yi fek nà' sə̀mok də, <<Saimʉ̀ mo Jon, wù dzəm mʉ à?>> Ntʉm bʉp Pità, bʉ̀ʉsə̀ nà' fek fis yi nə̀ kɛ̀' tɛ' də, <<Wù dzəm mʉ àlɛ?>> Pità nə dʉk fa nà' də, <<Tà, wù rì bum pwe'. Wù rì də mʉ̀ dzəm wu.>> Jisòs dʉk fa nà' də, <<Kʉk fa-a mʉ lis bə nsùŋgaaŋ am.>> ");
INSERT INTO yam_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yi cep fe'lə fa nà' sə̀' də, <<Mʉ tsok fa wu ŋkèm ncèp dʉk də, à ye to ŋga wu ntòwà'ŋwè, wù sə kiŋsə ni' yò, nə sə lo yuyo mvwe' sə̀ wù dzəm. Wu rèŋ ntsə'mòk fana wù saŋ bo yo, ŋwə̀ nə̀ zok kiŋsə wu, nə bək jə lo wu mvwe' sə̀ wù ka dzəm.>> ");
INSERT INTO yam_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisòs à cèp yè'sə ŋgòni'tsə̀' fa Pità nsàp kpʉ nə̀ nà'a nə kə kpʉ ŋgògʉ̀ liŋ Nwìi ye kə̀kuk. Yi à cèp wes vɛ'nə fana yi dʉk fa nà' də, <<Yuŋ və mʉ.>> ");
INSERT INTO yam_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pità à bʉ̀ʉŋ kʉ̀k, nə ye mo fàk Jisòs nə̀ Jisòs à sə dzəm nà' wùriŋ nə ŋga nà' sə bɛ' və̀ wo sə̀'. À ye sə̀' yi nə̀ yi ànə yəhə naaŋ lo Jisòs fa' mʉ ni'ì ŋga wo sə zʉ bɛŋ, nə fek nà' də, <<Tà, ŋwə̀ nə̀ yi nə seŋ wu nə ndà lɛ>> nà'a. ");
INSERT INTO yam_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pità ànə ye nà' fana yi fek Jisòs də, <<Tà, ŋwə̀ nè'e ye-ɛ?>> ");
INSERT INTO yam_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisòs dʉk fa fəsə nà' də, <<A ye-a ŋga mʉ̀ də yi cum fo' ŋwəm tə̀tè mʉ̀ bwi və nùu, nzak njòye fo' yà? Bɛ' və̀ mʉ yòfɛŋ ntɛ̀ŋ.>> ");
INSERT INTO yam_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ànə geŋ bʉ̀ʉ ye wèŋ ye ŋgòcèp lòkɛ' də Jisòs dʉk də ŋgà fàk ye nè'e nə kà kpʉ yuk. Megu də Jisòs à ka də nà'a nə kà kpʉ dʉk. Yi à dʉk də, ŋga ni' ye bò-a yi də nà'a cum fo' ŋwəm tə̀tè yi kə bwi və, nzak nà' ye fo' yà lɛ? ");
INSERT INTO yam_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Vès rì də mo fàk nə̀ Jisòs à cèp bum yè'sə bə liŋ ye nə sə tsə̀' faà nə weŋ yà' yi. Yi à còm ŋwàk ènə sə̀' yi. Vès rì sə̀' də yusə̀ yi cèp sə zìnə. ");
INSERT INTO yam_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bum mok cu sə̀ Jisòs à gʉ̀ yà', yà'a vɛ'ɛ wùriŋ. Wo à còm gèsə-a yà' ndzənə ŋwàk mò'fis, mò'fis làaŋ, bwɛ̀rɛ kàmòk ŋwàha sə yam casə nzeŋgòŋ nè'e pwe'.");
INSERT INTO yam_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ŋge' àm Tìyofilò, ŋwàk nə̀ mʉ̀ à còm to fa wu mantombì nà'a, mʉ̀ à còm tsə̀' fa wu nja bum sə̀ Jisòs ànə yeto ŋgògʉ̀ʉ, nə sə yə'rə fa bwìŋ, ");
INSERT INTO yam_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tə̀tè kə dzeŋ nùmbu nə̀ yi à lòmʉbu. Yi à sə lòo ŋga Yòŋsə̀ nə̀ Rərɛŋ nə à gʉ̀ yi, yi tsok noŋsə fa bʉ̀ʉ ye sə̀ yi à cokfis yà' ŋgòye ŋgàa ntum ye sə, bum sə̀ wo nə sə gʉ. ");
INSERT INTO yam_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mvəsə̀ yi à lòkok mvwe' kpʉ, yi à nìŋtsə̀' ni' ye bohòbʉ̀ʉ ye sə wèŋ mʉnə nùumbu hum kwè. Yi à nìtsə̀' ni' ye nə kɛ̀' ŋkʉ̀ʉŋntɛ̀ŋ nsàp nə̀ co məmərə̀ kà ye də yi lòkok laŋ mok ye fe'lə̀. Wo à yə yi, bə yà'wèŋ cep cù, nə sə taaŋ nzak gaŋ ŋkum Nwì. ");
INSERT INTO yam_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bə yà'wèŋ à cu bəbɛ' fana, yi tsok fa wo dʉk də, <<Kà də wèeŋ me'rə Jòrosalèm fɛɛŋ dʉk, wèeŋ cum tək tse' yusə̀ Tɛ̀' à kà' fa weŋ. A zeŋ sə̀ mʉ̀ a tsə̀' weŋ yà'a. ");
INSERT INTO yam_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon à bàptɛsə bwìŋ bə ndzəp, fana a nə kà nùumbu ŋkʉ̀ʉŋ dzeŋ fe'lə ŋga wo bàptɛsə weŋ mok bə Yòŋsə̀ nə̀ Rərɛŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ghà nə̀ bʉ̀ʉ ye sə à kə̀ be'lə bə Jisòs mvwe' mò'fis, fana wo fek yi dʉk də, <<Tà, wu nə fa fəsə ŋàaŋ sə ghà nè'nə bohòbʉ̀ʉ Izùrɛ ya vèes tse' lak sə ves à?>> ");
INSERT INTO yam_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jisòs cep fəsə fa wo də, <<Yà'sə ka nzak njàwèŋ ŋgòrì bə zeŋ yeŋ. Tɛ̀' nə tse' ŋàaŋ yà' sə yi. Yi nòŋsəgə̀ mvə̀k yi yiìyi. ");
INSERT INTO yam_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yusə də wèeŋ nə tse' ŋàŋ ghà nə̀ Yòŋsə̀ nə̀ Rərɛŋ nə və bohòwèŋ, fana wèeŋ nə ye ŋgàa təəŋ ma nə̀ njàm, nə sə tsoho lo ncèp àm mvwe' lak Jòrosalèm, nə ye Jùdiyà bə Sàmàriyà pwe', nə kə dzeŋ mvwe' sə̀ nzeŋgòŋ nə lə̀sə.>> ");
INSERT INTO yam_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yi ànə cep mesə vɛ'nə fana, yi lo mʉbu ŋga wo sə yə yi, fana mbàk kə lok yi, wo kà yi mok yə fe'lə̀. ");
INSERT INTO yam_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mvəsə̀ wo à sə kʉ̀k gèsə lòmalì mʉbu mvəsə̀ yi lòbisə, fana bʉ̀ʉ səmok bwìŋ ba, sə̀ wo à nitse' cə̀ək sə̀ fəfop à kə̀ tesə təəŋ ŋgʉ ni'ì wo. ");
INSERT INTO yam_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bʉ̀ʉ yè'sə fek wo dʉk də, <<Wèŋ bʉ̀ʉ Galìli, njo nə̀ wèŋ tə fɛɛŋ, nə sə kʉk gesə lo mʉbu vɛ'nə yà? Jisòs nə̀ yi me'rə weŋ, nə lònə mʉbu nè'nə, yi nə̀ kə̀ bwìŋ və̀ sə̀' mvəsə̀ wèŋ yə yi lòyà'sə.>> ");
INSERT INTO yam_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ànə ye vɛ'nə, fana wo me'rə mvwe' nda Olìp nə, nə bwi lo Jòrosalèm. Aco kìlometà mò'fis. ");
INSERT INTO yam_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","À kə̀ dzèŋ Jòrosalèm, wo ca kok lo mʉmvwe' rum ndap nə̀ wo cugə̀ mbwa nə. À sə cu fo' Pità bə Jon, Jem bə Andrù, Filìp bə Tomos, Bàtòlomì bə Màtiyò, Jem mo Afòs bə Saimʉ̀ nə̀ wo togə̀ yi də Zilò, nə ye Judàs mo Jem. ");
INSERT INTO yam_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ghà yà lòoŋ wo sə tse' tsətsərə̀ nə̀ mò'fis, nə fa ntʉm awo ŋgòsə gʉ̀hʉ pìriyà. Wo à ye fo' bə bə̀ba wèŋ sə̀', mòk à ye Mèri ma Jisòs bə bwema Jisòs sə̀ mbəmbam wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nùumbu mok à càa, ŋga wo sə cu kwe' fana bʉ̀ʉ sə̀ wo à dzəm Jisòs à ye fo' co ŋkʉ̀ mò'fis bə bwìŋ hum ba. Fana Pità lokok təəŋ mʉtsə̀, nə cep dʉk də, ");
INSERT INTO yam_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","<<Bwema am wèŋ, ŋwàk Nwìi nə ye tsoŋ zìnə mvəsə̀ Yòŋsə̀ nə̀ Rərɛŋ ànə cep casə mʉ cùhù Devìd, sə kum liŋ Judàs, nə̀ yi à nì tsə̀' fa bʉ̀ʉ sə̀ wo à ko Jisòs mandzə̀ nà'a. ");
INSERT INTO yam_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yi Judàs à ye ŋwə̀ àvès mòk nə̀ wo ànə swekfis yi, nə fa yi fàk mʉŋgorə̀ vès anə.>> ");
INSERT INTO yam_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yi à kə ywi nze bə mbàam sə̀ yi à gʉ̀ bʉp, nə tse' yà'. Nə lɛŋ kpʉ ye bə zeŋ, nə gbʉ vehe, nto ye tesə. ");
INSERT INTO yam_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bʉ̀ʉ sə̀ mvwe' lak Jòrosalèm à yuk bə zeŋ pwe', nə to mʉmvwe' nə də Àkèdamà. A yà'a bə ncèep lak awo də, nze ndʉəm.) ");
INSERT INTO yam_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","<<Yà'a yəyərə̀ bə yusə̀ wo à còm yà' ndzənə ŋwàk Sàam də, <Wèeŋ me'rə ndap ye nooŋ to, ŋwə̀ nəmòok kà mbwa cu.> Wo à còm sə̀' də, <Ŋwə̀ nəmòk nə jəŋ fàak sə̀ yi à sə gʉ̀ʉ sə.> ");
INSERT INTO yam_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nə yeè nə də mòok nə ye tsoŋ mò'fis nə̀ yi nə be'lə vesùwèŋ. Ŋwə̀ ènə nə ye ŋwə̀ nə̀ yi a sə yegə̀ vesiwèŋ ghà yà lòoŋ nə̀ Tà Jisòs à sə gìhi kɛ' tsətsoŋ bə kəkok mʉtsətsə'rə̀ə vès, ");
INSERT INTO yam_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ye jəŋ ghà nə̀ Jon à bàptɛsə yi, nə kə dzeŋ nùmbu nə̀ yi à mè'rə ves, nə lo mʉbu. Vesiwèeŋ nə sə tsoho kɛ' fa bwìŋ mvəsə̀ yi a lokok mvwe' kpʉ.>> ");
INSERT INTO yam_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Fana wo cokfis bwìŋ ba, Jòsep nə̀ liŋ yee mok à ye Bàsabà. Wo sə to yi sə̀' də Jostòs. Yi ye bə Màtiyàs. ");
INSERT INTO yam_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Wo gʉ pìriyà dʉk də, <<O Tà, wù rì ntʉm bwìŋ lòoŋ wù. Nìŋ tsok fa-a ves mʉtsətsə'rə bʉ̀ʉ sə̀ ba yè'e nə̀ wù cokfis ");
INSERT INTO yam_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ŋgòjə fàak yè'e co masinjà yo sə̀ Judàs à mè'rə màk, nə lo mvwe' sə̀ yà'a kə̀kʉrə̀ bohòyi ŋgòcu fo' sə.>> ");
INSERT INTO yam_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Fana wo təm bèŋ ya wo riŋ ŋwə̀ nə̀ wo jəŋ nə. Wo à màk bèŋ ko Màtiyàs, fana yi ye ŋga'a mòk nə̀ yi be'lə ŋgàa ntum Jisòs sə̀ hum-ncòp-mò'fis sə. ");
INSERT INTO yam_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nùmbu nə̀ ŋkàha sə̀ wo togə̀ yà' də Pentekòs à dzèeŋ fana yà' ye ŋga bʉ̀ʉ yè'sə wèŋ cu mvwe' mò'fis. ");
INSERT INTO yam_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Wo yuk ntɛ̀ŋ nà, ŋga sə cwì və̀ mʉbu co fə̀fə̀ nə̀ bʉp sə və̀ yi vɛ'ɛ, nə kə ci'lə təəŋ mʉnə ndap nə̀ wo cu mbwa nə dak. ");
INSERT INTO yam_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Fana wo ye yumok co lʉm mis vɛ'ɛ, yà' ga'a naaŋ lo bʉ̀ʉ sə̀ mʉ nda'à anə mʉ tuhù lòoŋfo'. ");
INSERT INTO yam_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wo pwe'fo' rwiŋ bə Yòŋsə̀ nə̀ Rərɛŋ nə, nə ye ŋga'a ŋgòcèp ncèep lak bwìŋ zəzok mvəsə̀ Yòŋsə̀ nə à fa wo ŋàŋ ŋgòcèep. ");
INSERT INTO yam_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mvə̀k ànə à ye ŋga bʉ̀ʉ Jus sə̀ wo wəpgə̀ Nwì à ye mvwe' lak Jòrosalèm sə. Wo à və̀ mvwe' bòop lak zəzok sə̀ yà'a sənə nzeŋgònə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Wo ànə yuk mvəsə̀ yà' sə cwì və̀, fana wo kə caŋ baaŋ mvwe' mò'fis. Wo à mərə cɛ̀bʉ̀ə̀ bʉ̀ʉsə̀ wo à yuk ŋga bʉ̀ʉ sə̀ wo à dzəm Jisòs sə pwe' à sə cèp ncèep lak awo mò'fis mò'fis. ");
INSERT INTO yam_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wo à sɛ̀ɛŋ, nə sə dʉk də, <<Yè'e ka pwe'fo' bʉ̀ʉ Galìli yeŋ nɛ̀? ");
INSERT INTO yam_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","A yè'sə nsàp nə̀ fò, ves yuk ŋga wo sə cep ncèep lak avès pwe' ɛ. ");
INSERT INTO yam_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Vèes fɛɛŋ bʉ̀ʉ Patiyà, Midiyà, nə ye Elàm. Mok və̀ Mèsòpòtemiyà nə ye Kàpàdosiyà, mok Poŋtòs bə Ɛsiyà, ");
INSERT INTO yam_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frijìyà bə Pàmfiliyà, Ijìp nə ye mvwe' nzeŋgòŋ Libiyà nə̀ nà' kʉəp Sìrinì. Mok fɛɛŋ ŋkʉ̀ìŋ sə̀ wo və̀ mvwe' lak Rumà, bʉ̀ʉ Jus nə ye sə̀ wo à bɛ' lòmandzə̀ Nwì bʉ̀ʉ Jus bɛ'lə. ");
INSERT INTO yam_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Bʉ̀ʉ Krit nə ye bʉ̀ʉ Aràb sə̀'. Mvəsə̀ vès və̀ mvwe' sə̀ zəzok vɛ'nə, fana ves yuk ŋga wo sə tsòho bum maŋgəŋgèŋ sə̀ Nwì à gʉ̀ bə ncèep lak avès.>> ");
INSERT INTO yam_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bum yè'sə ànə ghak, nə jipsə tes wo vɛ'nə, fana wo sə fe'rə kɛ'ca ni' awo dʉk də, <<Yè'sə nsàp nə̀ fòvɛ'nə ɛ?>> ");
INSERT INTO yam_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bʉ̀ʉ mok à jə bʉ̀sə yàwo yà' bum ywì'lə nzòŋ. Wo sə ywi'lə wo də yà'wèŋ no jʉ̀hʉ rùk. ");
INSERT INTO yam_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","À ye vɛ'nə, fana Pità bə ŋgàa ntum Jisòs mok sə̀ hum-ncòp-mò'fis sə à lòkok təəŋ mʉtsə̀, nə sə cep gʉgʉŋ də, <<Wèŋ bʉ̀ʉ Jùdiyà nə ye bʉ̀ʉ sə̀ wèŋ cu mvwe' lak Jòrosalèm pwe', wèeŋ yu'rə nə riŋ tse' dʉk də, ");
INSERT INTO yam_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","bʉ̀ʉ yè'sə ka rùk mvəsə̀ wèŋ sə tsərə yà'sə no jʉhʉ. Wèŋ yə yàwèŋ sə̀' də cu ntòzəzòŋ bohòŋwè ŋgòjʉ̀hʉ rùk. ");
INSERT INTO yam_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yè'sə yumok sə̀ ŋgà tsòhòbum Nwì nə̀ liŋ ye à ye də Joɛ̀ nà'a ànə cep noŋsə lo taŋ ntɛ̀ŋ laŋ. ");
INSERT INTO yam_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yi à còm də, <Nwì à dʉk də, <<Nùumbu sə̀ yà'a nə sə ləsə lo fana, mʉ nə fa Yòŋsə̀ àm bohòndàaŋwè pwe'. Wàhaŋgwɛ̀ŋ bə wàhanzùum awèeŋ nə tsoho fa bwìŋ bum Nwì. Bʉ̀ ŋkwàha bwìŋ bə wàhabwìŋ wèeŋ nə ye zìnə bum Nwì ndzənə lo. ");
INSERT INTO yam_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mʉ nə fa yòŋsə̀ àm nə bohòŋgàa fàak am sə̀ mbəmbam bə sə̀ bə̀ba sə̀'. Mvə̀k ànə dzèeŋ fana, wo sə tsoho fa bwìŋ bum Nwì. ");
INSERT INTO yam_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mʉ nə gʉ bum mok sə̀ yà' gʉ vɛ'ɛ maŋgəŋgèŋ yà' yəəŋ mʉbu bə sə nze. Bwìiŋ nə ye ndʉəm bə mis nə ye ndindi nə̀ nà' sə lokok bə ŋàŋ. ");
INSERT INTO yam_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nùum nə seŋ, ŋwə baŋ bʉʉŋ co ndʉəm ŋkuŋ fana nùmbu nə̀ ghaŋ nə̀ Tà nə̀ nà'a nə ye maŋgəŋgèŋ nə dzeŋ. ");
INSERT INTO yam_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Fana ndàaŋwè pwe' nə̀ yi lɛŋ to Tà mʉnə nùumbu yà'sə fana ŋgə̀ŋgàaŋ nə luŋ.>> > ");
INSERT INTO yam_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","<<Wèeŋ yu'rə na ncèp nè'e ɛ̀, bʉ̀ʉ Izùrɛ wèŋ. Jisòs nə̀ mvwe' lak Nazàrɛ ŋwə̀ nə̀ Nwì à cokfis, nə niŋtsok fa weŋ nsàp fàk ye bə maŋgəŋgèeŋ bum mok sə̀ yà' gha' bwìŋ. Nwì à sə gʉ̀ càsə yà' ndzə bohòyi. Wèŋ rì yàwèŋ yu yè'sə sə̀', bʉ̀ʉsə̀ yi ànə gʉ yà' mʉtsətsə'rə wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nwì bə tsətsərə̀ ye nə ye bə ŋkərə̀ nə̀ nje à dzəm kok yi də wo nə fa Jisòs ndzə bohòwèŋ, fana wèŋ fa yi bohòbʉ̀ʉ sə̀ bʉp wo tɛ'lə yi mʉ ntə̀əŋ. Yà'a mvəsə̀ wèŋ à zə yi wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Fana Nwì lokoksə yi mvwe' kpʉ sə̀', nə fiŋ me'rə fis yi mvwe' ŋgə' kpʉ. Mandzə̀ ànə ka nə̀ co kpʉ kotse' mamgeŋ yi yeŋ. ");
INSERT INTO yam_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Devìd ànə cep, nə sə kum liŋ ye dʉk də, <Mʉ̀ yə də Tàa yegə̀ venə ghà yà lòoŋ fo'. Yi tə mʉ bo mamàk ya ŋga ŋgə' kà mʉ gha'. ");
INSERT INTO yam_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nà'a njo nə̀ ntʉm àm tse' kwəkwa, ncèep cù am sə ye lə̀lʉm. Fana mʉ̀ cum sə̀' bə̀boŋ, nə sə naaŋ tu. ");
INSERT INTO yam_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","A bʉ̀ʉsə̀ wùu Nwì, kaco wu me'rə mak noŋsə mʉ mvwe' nzeŋgòŋ yòŋsə̀ə bʉ̀ kpʉkpʉ yeŋ. Kaco wu nə me'rə ŋgùpni' ŋgà fàk yònə̀ zìnə ŋgòbì yeŋ. ");
INSERT INTO yam_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wù a nì tsə̀' fa mʉ mandzə̀ nə̀ ŋgòkə̀ cu ncu nə̀ ŋgòtse' yòŋsə̀ laŋ. Mʉ nə̀ kwa bʉ̀ʉsə̀ wu vesù.> ");
INSERT INTO yam_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","<<Bwema am wèŋ, mʉ̀ rìŋ bə̀boŋni də aco mʉ̀ cep yumok sə̀ zìnə bə liŋ tàcici àvès Devìd. Mvəsə̀ yi ànə cep bum yè'sə, fana yi ànə kpʉ lo yuye laŋ, wo tuuŋ yi, sèe ye sə nòmalì yè' fo' tè ntinə. ");
INSERT INTO yam_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yi à ye ŋgà tsòhòbum Nwì, nə riŋ tse' yusə̀ Nwì ànə kɛŋ də yi nə̀ fa yi. Nwì ànə kak də yi nə kə̀ gʉ̀ ŋwə̀ə nà' mòk ŋgòkok gaŋ ŋkum Devìd. ");
INSERT INTO yam_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tàcici àvès Devìd ànə riŋ yusə̀ Nwì ànə tse' ŋgògʉ̀ fana, mvəsə̀ yi à dʉk də <Wo à ka yi mvwe' nzeŋgòŋ yòŋsə̀ə bʉ̀ kpʉkpʉ me'rə noŋsə, ŋgùpni' ye à ka sə̀' bi> yà'a, yi à sə kà yè'sə bə ni' ye cèp. Yi à sə cèp bə Ŋkum ŋgà gèm bwìŋ nə̀ Nwì à dʉk də yi nə̀ tum vesə nə. ");
INSERT INTO yam_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nwì à lòkoksə Jisòs nə mvwe' kpʉ, fana vès bwe ye pwe' à yə, nə riŋ bə zeŋ də a zìnə. ");
INSERT INTO yam_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yi a lòkok cu lòbo ma màk bohòNwì, nə jəŋ Yòŋsə̀ nə̀ Rərɛŋ bohònà' mvəsə̀ tɛ̀' ànə kak noŋsə, fana yusə̀ wèŋ yə, nə yu'ù nə, sə gʉ̀ yà' yòŋsə̀ ànə nə̀ Jisòs sə fa nà' yi. ");
INSERT INTO yam_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devìd à ka ye mʉbu lo fana, à ye yi nə̀ yi à cèp dʉk də, <Tà Nwì à dʉk bohòTà àm də, <<Cum bo ma mà'a mʉ fɛɛŋ, ");
INSERT INTO yam_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ya mʉ noŋsə bʉ̀ʉ sə̀ wo bɛ̀ŋgə̀ wu sə nze ya wu nəŋ tes kù mʉ ni'ì wo.>> > ");
INSERT INTO yam_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","<<Bʉ̀ʉ Izùrɛ pwe' tse' ŋgòrì tse' pap də Jisòs nə̀ wèŋ à tɛ'lə yi mʉ ntə̀əŋ nə, Nwì a gʉ̀ yi ŋgòye Tà, nə ye fe'lə Ŋkum ŋgà gèm bwìŋ nə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bʉ̀ʉ sə à yuk vɛ'nə fana ntʉm saha wo nə̀bʉp. Wo fek Pità bə ŋgàa ntum Jisòs mok sə wèŋ də, <<Aco vès gʉ yè'sə va, bwema avès wèŋ?>> ");
INSERT INTO yam_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pità tsok wo də, <<Wèeŋ kupsə, nə bwi fa bʉp awèŋ ŋkwɛ̀ŋ, wèŋ lòoŋ, nə baptɛsə mʉnə liŋ Jisòs Krɛst ya ŋga wèeŋ tse' sə̀swìfa bə bʉp awèŋ, ya wèeŋ tse' Yòŋsə̀ nə̀ Rərɛŋ nə̀ nà'a fəfa nə̀ Nwì. ");
INSERT INTO yam_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Wèŋ rì də kə̀kàk ènə nà'a nə̀ njàwèŋ, nə ye bwe awèŋ, nə ye nə̀ bʉ̀ʉ sə̀ wo cu yàwo sə̀sap bohòNwì sə̀'. A yà'sə də nà'a bohòndàaŋwè pwe' nə̀ Tà Nwì a to yi sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pità ànə cep bohòwo vɛ'nə, nə cep bum mok wùriŋ. Yi sə lɛŋ wo də, yà'wèeŋ lap mandzə̀ nə̀ ŋgòca gɛsə mvwe' nsàp ŋgə' nə̀ bʉ̀ ŋgàa ŋkʉ̀ì' wèeŋ nə̀ kə̀ yə nə. ");
INSERT INTO yam_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ à yuk ncèp ye nə, nə dzəm nà', nə baptɛsə sə̀'. Fana bʉ̀ʉ sə̀ wo à be'lə kwe' àwo nùmbu ànə à ye co bwìŋ ncùhù tɛ'. ");
INSERT INTO yam_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wo à jə gha' mvə̀k awo ŋgòyu'rə yusə̀ ŋgàa ntum Jisòs sə à sə yə'rə wo, nə sə be'lə mvwe' mò'fis. Wo sə zʉ bɛŋ Nwì mvwe' mò'fis, nə sə lɛŋ pìriyà. ");
INSERT INTO yam_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ŋgàa ntum Jisòs sə wèŋ à sə gʉ̀ bum sə̀ yà' à sə gha' bwìŋ mʉtuhù wùriŋ fana, wʉə à ko bwìŋ pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bʉ̀ʉ sə̀ wo à dzəm sə pwe' à sə cu mvwe' mò'fis, nə sə be'lə bum awo sə̀ wo à tse' mvwe' mò'fis sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wo à sèŋ bum yà'sə nə sə gapsə mbàam sə mvəsə̀ wo yə də ŋgə̀ŋgàŋ ka tse'. ");
INSERT INTO yam_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nùumbu pwe' wo sə kə be'lə mvwe' kwe' nə̀ mò'fis mʉnə ndap Nwì nə̀ ghaŋ nə̀ nà' à ye Jòrosalèm anə. Wo à sə zʉ bɛŋ awo nda'à wo mvwe' mò'fis bə kwəkwa nə ye ntʉm nə̀ mò'fis. ");
INSERT INTO yam_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Wo sə kuksə Nwì fana bwìŋ pwe'fo' à sə dzəm wo. Tà Nwì à sə jònaaŋ fa wo bʉ̀ʉ sə̀ wo à sə tse' lùŋ nùumbu pwe'. ");
INSERT INTO yam_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nùmbu mòk à ye, ŋga nùm càsə maràŋ fana Pità bə Jon sə lo mʉ ndap Nwì nə̀ ghaŋ nə. À ye ghà nə̀ wo gʉ̀gə̀ pìriyà. ");
INSERT INTO yam_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","À kə̀ dzèŋ mvwe' ncùu ŋka' mok sə̀ wo togə̀ yà' də Ncù sə̀ Bə̀boŋ fana wo tseŋ ŋgà' nəmòk fo' ŋga yi cu fo' nze. Woo kə̀ bə̀hə nòŋsəgə̀ yi fo' də nà'a sə lɛɛŋ mbàm bohòbʉ̀ʉ sə̀ wo sə lòmʉ nda'à Nwì anə. Bʉsə̀ mvə̀'nə̀ wo à dzə yi dzəə, yi à ka gi yuk. ");
INSERT INTO yam_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yi ànə ye Pità bə Jon ŋga wo sə də wo ni lo mʉ ndap Nwì nə̀ ghaŋ nə fana, yi lɛŋ də yà'a fa yi mbàm. ");
INSERT INTO yam_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wo kʉk nà' bə lis rap rap fana Pità dʉk fa nà' dʉk də, <<Kʉk ves.>> ");
INSERT INTO yam_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yi kʉk wo, nə sə tsərə ye də yà'a nə fa yi yumok ŋga'a. ");
INSERT INTO yam_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pità dʉk fa yi də, <<Mʉ̀ ka mbàm ŋgòfa wu tse', mʉ nə fa wu yusə̀ mʉ̀ tse'.>> Fana yi dʉk fa nà' də, <<Mʉnə ŋàaŋ liŋ Jisòs Krɛst nə̀ mvwe' lak Nazàrɛ, lòkok, nə gi.>> ");
INSERT INTO yam_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Fana Pità fa gesə nà' bo mazʉ, nə ko lokoksə nà' mʉtsə̀ ntɛ̀ŋ, fana lis kùu ye bə kùu ye sə pwe'fo' gʉŋ co yi təəŋ. ");
INSERT INTO yam_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yi li mʉtsə̀, nə təəŋ bə tu ye, nə sə gihi kɛ' ca. Bə yà'wèŋ lo kə ni mʉ ndap Nwì nə̀ ghaŋ nə mok bəbɛ'. Yi sə gi, nə sə li, nə sə kwasə Nwì. ");
INSERT INTO yam_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bwìŋ pwe'fo' à yə yi mvəsə̀ yi à sə gìi, nə sə kwasə Nwì. ");
INSERT INTO yam_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Wo ànə geŋ də wo riŋ də a yi nə̀ yi cugə̀ mvwe' ncù ŋka' nə̀ bə̀boŋ nə, nə sə lɛɛŋ bum nə fana wo mərə nsàp yu nə̀ nà' gʉ̀ yi nà'nə nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mvəsə̀ wo à sə tesə tsoŋ fana ŋgà' nə kotse' Pità bə Jon cʉ̀k fana bwìŋ mərə, nə carə və mvwe' sə̀ wo tə sə sə̀'. À ye yè'sə sə mbi mvwe' sə̀ wo togə̀ fo' də mbàndap nə̀ Sòlomù. ");
INSERT INTO yam_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pità à yə bʉ̀ʉ sə̀ wo à sə və̀ fo', fana yi dʉk fa yà'wèŋ dʉk də, <<Bʉ̀ʉ Izùrɛ wèŋ, wèŋ sə mərə yè'sə bʉ̀ʉ yà? Wèŋ sə kʉ̀k sɛɛŋ ves co də vès lòkoksə yi bə ŋàaŋ yàvès, də vès tse' ntʉm sə̀ rərɛŋ yè'sə bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yusə də, Nwì Abràham, Azìk nə ye Jàkop, yi nə̀ yi Nwì tàcici avès à fa ŋàaŋ sə̀ mʉbu bohòmo ye Jisòs. Wèŋ jəŋ yi, nə fa bohòbʉ̀ ŋkwàha bʉ̀ʉ Jus, nə bɛŋ yi mantombì Palè, ŋga Palè nə dʉk laŋ də wo me'rə yi lo. ");
INSERT INTO yam_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yi nə̀ yi à ye rərɛŋ nə ye bə̀boŋ, wèŋ bɛŋ yi, nə dʉk fa Palè də yi me'rə lɛ ŋgà zə bwìŋ. ");
INSERT INTO yam_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Fana wèŋ zə yi nə̀ yi mantombì ŋgòjə lòbwìŋ mvwe' lùŋ. Fana Nwì nə lòkoksə yi mvwe' kpʉ. Vès ye bə lis avès, nə sə tsə̀' fa-à nə bwìŋ. ");
INSERT INTO yam_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ŋàaŋ sə̀ yà' cu ndzənə liŋ Jisòs sə gʉ̀ ŋgà' nə̀ wèŋ sə yə yi, nə riŋ yi nè'e zeŋ ŋkuŋ yi gʉŋ. Njo nə̀ vès a fa ntʉm avès bohòliŋ yà'sə fana yà' gʉŋsə yi mvə̀'nə̀ wèŋ sə yə yi yè'sə. ");
INSERT INTO yam_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Fana nə̀ ŋga'a nè'e bwema am wèŋ, mʉ̀ riŋ tse' dʉk də yusə̀ wèŋ bə bʉ̀ ŋkwàha bʉ̀ʉ awèŋ à gʉ̀ bohòJisòs, à ye ŋga wèŋ sə kà rì. ");
INSERT INTO yam_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nwì ànə tsok casə cùhu ŋgàa tsòhòbum Nwì pwe'fo' taaŋntɛ̀ŋ dʉk də, Ŋkum ŋgà gèm bwìŋ nə nə ye ŋgə'. Fana yi a gʉ̀ yà' ye zìnə bə nsàp mandzə̀ ènə. ");
INSERT INTO yam_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Wèeŋ kupsə-a ŋga'a, nə bʉʉŋ lo bohòTà Nwì ya yi yisə gɛsə fa weŋ bʉp awèŋ sə fo'. ");
INSERT INTO yam_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ya ŋga mvə̀k nə̀ ŋgòcu yòŋsə nə və bohòTà Nwì. Ya ŋga yi tumsə fa weŋ Jisòs, nə̀ yi à kàk nòŋsə ŋgòtumsə fa weŋ nə. ");
INSERT INTO yam_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yi nə cum tsoŋ tse' mʉbu tè mvə̀k kə dzeŋ nə̀ Nwìi nə gʉhʉ tsə'rə fəsə bum pwe'. Yè'e mvəsə̀ Nwì ànə tsok taaŋ ntɛ̀ŋ cùhu bʉ̀ʉ ye sə̀ rərɛŋ sə̀ ŋgàa tsòhòbum Nwì. ");
INSERT INTO yam_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musì ànə dʉk də, <Tà Nwì àwèeŋ nə tumsə fa weŋ ŋgà tsòhòbum Nwì mòk sə̀' mvəsə̀ yi à tumsə mʉ̀ʉ Musì. Yi nə tesə mʉtsətsə'rə bòp bʉ̀ àwèŋ. Wèeŋ nə sə yuk tse' yusə̀ yi nə sə tsok fa weŋ cʉ̀k. ");
INSERT INTO yam_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ŋwə̀ nə̀ yi dʉk-a də yi kà yusə̀ ŋgà tsòhòbum Nwì nə sə cèp yuk, Ye də wo nə fis gɛsə yi mʉŋgorə̀ bʉ̀ʉ Nwì nə̀ mvèsə̀.> ");
INSERT INTO yam_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ŋgàa tsòhòbum Nwì sə̀ wo à tse' ncèp ŋgòcèep à cèp càsə bə bum sə̀ yà'a nə sə ye nùumbu yè'sə sə̀'. Ye jəŋ mʉ ni'ì Samwè nə ye bə sə̀ wo à ye maŋkwɛ̀ɛŋ yi pwe', sə cep vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Wèeŋ ŋgwì bʉ̀ ŋgàa tsòhòbum Nwì sə, nə ye fe'lə sə̀' də wèŋ tse' bo sənə rʉ̀k nə̀ Nwì à zʉ bə tàcici awèŋ sə̀'. Yi à dʉk fa Abràham də, <Mʉ nə se bʉ̀ʉ sə̀ sənə nzeŋgònə pwe' bʉ̀ʉ ŋgwì bʉ̀ yò.> ");
INSERT INTO yam_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nà'a njo nə̀ Nwì à fis ŋgà fàk ye Jisòs, nə fa to nà' mantombì bohòwèŋ ŋgòkə̀ sè weŋ. Yi à sè weŋ bə mandzə̀ nə̀ ŋgògʉ̀ weeŋ bʉʉŋ gɛsə mvwe' mandzə̀ jòoŋ awèŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pità à sə cèp malì bohòbʉ̀ʉ sə̀ fo', ŋga Jon sə̀' fo' fana ŋgàa fa satikà' nə ye ŋkum ŋgàa ntək mʉmvwe' ndap Nwì nə̀ ghaŋ nə bə bʉ̀ʉ Sadusì wèŋ və kə tseŋ wo. ");
INSERT INTO yam_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wo à jòk və̀ də Pità wèŋ à sə yə'rə fa bwìŋ də Jisòs a lòkok mvwe' kpʉ. Wo yə'rə vɛ'nə, yà' sə niŋ tsok də ŋwèe kpʉ-a yi nə lokok fe'lə sə̀mok. ");
INSERT INTO yam_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Fana wo ko wo, nə kə lok noŋsə wo. Wo à nòoŋ nòoŋ mʉ ndapndzəmə̀ anə tè tsok rɛŋ bʉ̀ʉsə̀ à ye ŋga mvə̀k lònə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ànə ye na sə̀' vɛ'nə fana bwìŋ ŋkʉ̀ʉŋ sə̀ wo à yuk ncèp nə à dzəm tse' bə zeŋ. Bʉ̀ʉ sə̀ wo à dzəm sə lòoŋ fo' à ye pwe' co bwìŋ ncùhù tàŋ. ");
INSERT INTO yam_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tsok à rɛŋ fana, bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ à baaŋ və̀ mvwe' lak Jòrosalèm dʉk də wo kə sak yà'wèŋ. Wo à ye bʉ̀ʉ Jus sə̀ mantombì bə ŋgàa yə'rə̀ bwìŋ lʉ̀k. ");
INSERT INTO yam_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Wo ye fo' bə Anàs, ŋkum ŋgàa fa satikà' wèŋ, nə ye fe'lə Kayofàs bə Jon bə Àlèsandà nə ye fe'lə bʉ̀ʉ mok sə̀' sə̀ wo njàŋ bə ŋkum ŋgà fa satikà' nə. ");
INSERT INTO yam_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wo jəŋ və bʉ̀ʉ sə̀ ba sə mantombìi wo, fana wo sə fek yà'wèŋ dʉk də, <<Wèŋ tse' nsàp ŋàŋ nə̀ fòŋgògʉ̀ vɛ'nə-ɛ? Wèŋ sə gʉ̀ vɛ'nə yè'sə bə liŋ ndà?>> ");
INSERT INTO yam_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pità à rwiŋ bə Yòŋsə̀ nə̀ Rərɛŋ nə fana, yi cep fəsə fa wo də, <<Wèŋ bʉ̀ʉ sə̀ mantombì nə ye bʉ̀ ŋkwàha bwìŋ wèŋ, ");
INSERT INTO yam_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","wèŋ sə fek ves yè'sə yusə̀ bə̀boŋ sə̀ vès a gʉ̀ʉ də ŋwə̀ ènə gi sə à? Wèŋ dzəm ŋgòrìŋ də vès a gʉ̀ yi valɛ ŋkuŋ yi gi à? ");
INSERT INTO yam_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Fana wèŋ bə bʉ̀ʉ Izùrɛ pwe' riŋ sə̀' də ŋwə̀ ènə a gʉ, nə təə̀ŋ nə mantombìi wèŋ fɛɛŋ bə ŋàaŋ liŋ Jisòs Krɛst nə̀ mvwe' lak Nazàrɛ. A yi nə̀ wèŋ ànə tɛ'lə yi mʉ ntə̀əŋ, fana Nwì lòkoksə yi mvwe' kpʉ nə. ");
INSERT INTO yam_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","A sə̀' Jisòs nè'nə nə̀ ŋwàk Nwì sə dʉk də, <Lìs nə̀ ŋgàa ci ndap à dzèeŋ màk də nà'a bʉp, kə̀ tse' ghak fe'lə fàk sə̀' zeŋ nə.> ");
INSERT INTO yam_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mandzə̀ nə̀ ŋgòtse' lùŋ megu bə liŋ ye yiìyi. Sənə nzeŋgònə pwe', ŋwə̀nəmòok mok bʉ̀ə̀ nə̀ Nwì a fa bwìŋ də aco a tse' lùŋ bohòyi.>> ");
INSERT INTO yam_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bʉ̀ʉ sə̀ mʉ kaŋsurù sə pwe' à yə nsàp ntʉm nə̀ Pità bə Jon à bàa ŋga wo rì sə̀' də yà'wèeŋ bʉ̀ʉ sə̀ wà sə̀ wo à ka ŋwàk sə̀' riŋ, fana wo mərə nə̀bʉp. Yà'a mvwe' sə̀ wo à rì dʉk də bʉ̀ʉ yè'sə à ye bə Jisòs wèŋ laŋ nə̀ zìnə. ");
INSERT INTO yam_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yusə̀ co wo cep, à ka sə̀' yeŋ, bʉ̀ʉsə̀ ŋwə̀ nə̀ wo à lùŋsə yi nə à tə kok sə̀' fo' ŋgʉ ni'ì Pità bə Jon anə, bwìŋ sə ye yi. ");
INSERT INTO yam_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Fana wo à dʉk fa yà'wèŋ də yà'wèeŋ tesə mʉ kaŋsurù anə. Wo à tesə lo fana wo sə cep mok woòwo. ");
INSERT INTO yam_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wo sə dʉhʉ də <<A gʉ bʉ̀ʉ yè'sə va? Bʉsə̀ bʉ̀ʉ sə̀ wo cu Jòrosalèm fɛɛŋ pwe' riŋ tse' də à gʉ̀ nsàp yu nə̀ nà' gʉ càsə ŋàŋ nè'nə bʉ̀ʉ yè'sə. Mandzə̀ nə̀ co vesùwèŋ dzèeŋ yà' ka yè'sə yeŋ. ");
INSERT INTO yam_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Fana megu də vesùwèeŋ jwa sa'rə wo də wo kà bohòŋwə̀ nəmòk mʉnə liŋ Jisòs mok cèp yuk fe'lə̀, ŋgògʉ̀ də yu yè'sə kà mantombì mok sə yuhù lo'.>> ");
INSERT INTO yam_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Fana wo to fəsə vesə wo mʉ ndapə̀ anə, nə tsok wo də, ŋgòcèp kènə ŋgòyə'rə bwìŋ mʉnə liŋ Jisòos nə kà mok ye yuk fe'lə̀. ");
INSERT INTO yam_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pità bə Jon dʉk fa fe'lə wo də wo kʉk ja'a na yàwo sə̀' də, a yəyərə̀ bohòNwì də wo yuk yà'wèŋ nə noŋsə Nwì àlɛ. ");
INSERT INTO yam_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","<<Kaco vès teŋsə ŋgòcèp yusə̀ vès a yə, nə yuk yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bʉ̀ʉ sə̀ mʉ kaŋsurù sə à jwa sa'rə malì wo gʉgʉŋ, nə me'rə wo lo. Wo lap njo nə̀ co wo fa yà'wèŋ ŋgə' bʉ̀ʉ zeŋ bʉ̀ə̀, bʉ̀ʉsə̀ bwìŋ pwe' à sə kùksə Nwì bə nsàp yu nə̀ nà' ye nà'nə. ");
INSERT INTO yam_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ŋwə̀ nə̀ wo à gʉ̀ gʉŋsə yi nə à càsə lùumŋgòŋ hum kwè. ");
INSERT INTO yam_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Mvəsə̀ wo à mè'rə wo ntɛ̀ŋ, Pità bə Jon bwi lo mvwe' kwe' àwo, nə tsoho fa yà'wèŋ yusə̀ ŋkum ŋgàa fa satikà' sə̀ ghaŋ bə bʉ̀ ŋkwàha bwìŋ wèŋ dʉk sə. ");
INSERT INTO yam_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wo à yuk wes yà' fana wo pwe' be'lə, nə gʉ pìriyà bohòNwì dʉk də, <<O Tà Nwì, ŋgà gʉ̀ ntòbu bə nzeŋgòŋ nə ye ndzəp bə bum sə̀ yà' cu ca lòoŋ. ");
INSERT INTO yam_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","À ye wù nə̀ wù à gʉ̀ tàcici àvès Devìd ŋgòcèp bum yè'e. Yi à ye mo fàk yo, fana Yòŋsə̀ nə̀ Rərɛŋ nə à gʉ̀ yi ŋgòcèp də, <Bʉ̀ lakmvum sə jok bʉ̀ʉ yà? Bʉ̀ʉ sə sə tsərə bum sə̀ yà'a nə kà fàk yè'sə bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bʉ̀ ŋkəŋkum nzeŋgòŋ fʉhʉ ni' awo mvwe' mò'fis ŋgòlʉ̀ Tà Nwì bə Ŋkum ŋgà gèm bwìŋ nə̀ Nwì à cokfis nòŋsə nə.> ");
INSERT INTO yam_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","A zìnə də Heròbə Poŋtiyòs Palè nə ye bʉ̀ʉ Izùrɛ bə bʉ̀ lakmvum wèŋ à cu kwe' nə̀ bʉp mʉ tùhù Jisòs mʉ ntòlak fɛn. Wo à kə̀ cu kwe' mʉ tuhù Jisòs mo yònə̀ rərɛŋ, nə̀ wù à cokfis nòŋsə nə. ");
INSERT INTO yam_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Wo kə be'lə ŋgògʉ̀ bum sə̀ wù ànə dzəm wu. Wù ànə fʉhʉ noŋsə yà' laŋ, nə fa ŋàŋ də bum yè'sə nə ye vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Fana nə̀ ŋga'a nè'e, Tà, kʉk ja'a na bə nsàp ŋgə' nə̀ wo sə dʉk də wo nə fa ves, ya ŋga wu gʉ ves ŋgàa fàak yo baŋ ntʉm ŋgòtsòho ncèp yònə. ");
INSERT INTO yam_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Niŋ-a ŋàaŋ yo sə bə mandzə̀ nə̀ ŋgògʉ̀ bwìŋ gʉŋ nə lokok mvwe' yiyaŋ awo. Gʉ̀ sə̀' də vèes sə gʉ bum bə liŋ Jisòs, mofàk yònə̀ rərɛŋ nə co yà'a sə ghak bwìŋ mʉ tuhù.>> ");
INSERT INTO yam_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Wo ànə lɛŋ mesə fana mvwe' sə̀ wo à ye fo' sə tsoho. Wo pwe'fo' à rwiŋ bə Yòŋsə̀ nə̀ Rərɛŋ nə. Wo yeto ŋgòtsòho ncèp Nwì nə kà wəp. ");
INSERT INTO yam_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bʉ̀ʉ sə̀ wo ànə dzəm bohòJisòs sə pwe' sə tse' ntʉm nə̀ mò'fis. Ŋwə̀ nəmòk nə̀ mò'fis kà dʉk də yusə̀ yi tse' gù sə̀ ye yiìyi dʉk. Wo à sə benə bum awo sə̀ wo à tse' pwe' mvwe' mò'fis. ");
INSERT INTO yam_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ŋgàa ntum yè'sə à sə tsòho bum sə̀ wo à yə, mvəsə̀ Tà Jisòs à lòkok mvwe' kpʉ bə ŋàŋ fana Nwì sə se wo pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ŋwə̀ nəmòk nə̀ də yi à sə jamə də yi ka yumok tse' à ka mʉtsətsə'rə wo anə yeŋ. Bʉ̀ʉ sə̀ wo à tse' nzum bə ndap wèŋ à sèŋ yà', nə jəŋ və mbàam sə̀ wo sèŋ yà' bə zeŋ sə, ");
INSERT INTO yam_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nə fa noŋsə yà' bohòŋgàa ntum sə wèŋ. Fana wo jəŋ mbàam sə, nə sə fa ŋwə̀ nə̀ fòlòoŋ mvəsə̀ wo yə də nà' ka tse'. ");
INSERT INTO yam_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yà'a mvəsə̀ ŋwə̀ nəmòk nə̀ liŋ ye də Jòsep à gʉ̀ sə̀' vɛ'nə. Yi à ye ŋwə̀ə bòp bʉ̀ Levì, fana wo dzə yi dzəə mvwe' lak Sɛprò. Ŋgàa ntum Jisòs à to fa yi liŋ nzùm də Bànabà. Yà'a də: Ŋwə̀ nə̀ yi rì ŋgòcèp fa bwìŋ ncèep kontʉm. ");
INSERT INTO yam_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yi à sèŋ nzum ye, nə jəŋ və mbàam sə, nə kə fa noŋsə yà' bohòŋgàa ntum sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ŋwə̀ nəmòk à ye sə̀' nə̀ liŋ ye à ye də Ànàniyàs. Liŋ ŋgwe à ye Sàferiyà. Wo à sèŋ bum awo mok, ");
INSERT INTO yam_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","nə swihi noŋsə mbàm mamòk, nə jəŋ bwees sə fa lo ŋgàa ntum sə. Ŋgwe ye à rì də nà' swìhi mbàam mok sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Fana yi ànə jəŋ və mbàam sə, Pità fek yi dʉk də, <<Ànàniyàs, wù mè'rə Satà də yi ni sə ntʉʉ̀ wù ŋgògʉ̀ wu də wu kə borə Yòŋsə̀ nə̀ Rərɛŋ nə, nə swihi mbàam sə̀ wù à sèŋ bum sə mamòk bʉ̀ʉ yà? ");
INSERT INTO yam_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mvə̀k nə̀ wù ànə ka bum yà'sə ntòseŋ, yà' à ye sə̀ yò. Wù à sèŋ yà', mbàam sə ye mali sə̀' sə̀ yò. Njo nə̀ wù kə tsərə fe'lə sə ntʉʉ̀ wù də wu gʉ nsàp yu ènə yè'sə bʉ̀ʉ yà? Wù ka nsàp mvwès nè'nə bohòbwìŋ ci' fa, wù ci' fa nà' bohòNwì bə tu ye.>> ");
INSERT INTO yam_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ànàniyàs ànə yuk vɛ'nə ntɛ̀ŋ, yi coho gbʉ sə nze, nə kpʉ. Wʉə à ko bʉ̀ʉ sə̀ wo à yuk yu yè'sə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wàhabwìŋ wèŋ à və̀, nə kə lim fis lo vèŋ ni' ye nə sə mbiŋ, nə kə tuuŋ. ");
INSERT INTO yam_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","À cà awà tɛ' fana ŋgwe ye və sə̀', nə kà rì də yumok gʉ̀ ndu ye rì. ");
INSERT INTO yam_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Yi à kə̀ dzèeŋ, Pità fek yi də, <<Tsòk fa mʉ-ɛ, yè'e mbàam sə̀ wèŋ ndu yòà sèŋ bum sə vɛ'nə pwe'fo' à?>> Ŋgwɛŋ nə də, <<Ŋ̀, yà'a mbàam sə pwe'.>> ");
INSERT INTO yam_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Fana Pità dʉk fa yi də, <<Weŋ ndu yòswi' cù də wèeŋ kə mumsə ja'a Yòŋsə̀ Nwì bʉ̀ʉ yà? Sə nə̀rə və̀ kù kə ncùhù yà'a bʉ̀ʉ sə̀ wo kə tuuŋ və̀ ndu yò. Wo nə bək fis lo wu yòsə̀' ca.>> ");
INSERT INTO yam_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Yi à coho gbʉ nòoŋ tsə mantombìi Pità vɛ'nə ntɛ̀ŋ, nə kpʉ. Wàha bʉ̀ʉ sə à ni ko' və̀ə, nə kə dzeŋ ŋga yi kpʉ laŋ. Wo à bə̀k jə fis nà', nə kə tuuŋ yi ŋgʉ sèe ndu ye nə. ");
INSERT INTO yam_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bʉ̀ʉ cos nə ye bʉ̀ʉ mok sə̀ wo à yuk bum yè'sə, nsàp wʉə mòk à ko wo pwe' nə̀ pwe'. ");
INSERT INTO yam_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ànə gèŋ ŋgàa ntum sə à sə gʉ̀hʉ bum maŋgəŋgèŋ nə ye bum sə̀ bwìŋ sə mərə wùriŋ. Bʉ̀ʉ sə̀ wo à dzəm Jisòs sə pwe' à sə cu kwe' àwo mvwe' mò'fis mvwe' ntòmbi Sòlomù. ");
INSERT INTO yam_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bʉ̀ʉ mok sə̀ wà sə à ka ni' awo co də wo kə̀kʉrə̀ ŋgòbe'lə yà'wèŋ jəŋ lok. Wo à sə kà-a bə yà'wèŋ sə̀' sə tòrə̀ kɛ' fana wo sə kʉk ja'a yà'wèŋ co nsàp bʉ̀ʉ mok sə̀ wo bòntʉm wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bʉ̀ʉ sə̀ wo à dzəm bohòTà Jisòs à sə tùhu və̀, bə̀ba bə mbəmbam wèŋ nduk, nə sə kə be'lə wo. ");
INSERT INTO yam_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mvəsə̀ bwìŋ à yə nsàp yu nə̀ wo à sə gʉ̀ʉ fana, wo bəhə fis və ŋgàa yiyaŋ, nə noŋsə lo wo ŋgʉ mandzə̀ mʉnə kəà bə kè wèŋ də ya Pità gì càa, tsə̀tsèŋ ye ca mʉ ni'ì mok. ");
INSERT INTO yam_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bwìŋ à kwəəŋ tesə və mvwe' bòop lak sə̀ yà'a ŋgʉ Jòrosalèm ŋgòjə və̀ bʉ̀ʉ awo sə̀ wo sə yaya bə bʉ̀ʉ sə̀ wo tse' yòŋsə̀ə ze' ndzə ni'ì wo. Wo à gʉ wes pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","À ye vɛ'nə fana ŋkum ŋgàa fa satikà' bə bʉ̀ʉ ye sə̀ wo mvwe' kwe' bʉ̀ʉ Sadusì wèŋ yeto ŋgòwa yusə̀ ŋgàa ntum sə sə gʉ̀ʉ sə, nə jok wà anə. ");
INSERT INTO yam_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wo ko ŋgàa ntum sə, nə kə nisə wo ndapndzəm. ");
INSERT INTO yam_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nùmbu ànə à ye, nə̀ ndzəmə̀ fana masinjà Tà Nwì və, nə kə muk nooŋ ncùu ndapndzəm sə, nə fis wo. Yi tsok fa yà'wèŋ dʉk də, ");
INSERT INTO yam_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","<<Dù lo, nə kə təəŋ mʉ ndap Nwì nə̀ ghaŋ nə, nə tsoho fa bwìŋ ncèp nə̀ bə lùŋ nə̀ fi ènə.>> ");
INSERT INTO yam_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wo à yuk mvəsə̀ yi à cep sə. Tsok à rɛŋ wo lo mʉ ndap Nwì nə̀ ghaŋ nə, nə sə yə'rə bwìŋ. Ghà ànə à ye fana ŋkum ŋgà fa satikà' nə bə bʉ̀ʉ ye wèŋ à to benə bʉ̀ ŋkwàha bʉ̀ʉ Jus pwe' mvwe' mò'fis də wo cum kaŋsurù. Wo à və̀ wes, wo dʉk gesə lo mvwe' ndapndzəm nə də wo jəŋ və fa wo ŋgàa ntum sə. ");
INSERT INTO yam_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ŋgàa kʉk ŋgàa ndapndzəm sə à kə dzèŋ fana wo kà ŋgàa ntum sə mʉ ndapndzəmə̀ anə yə. Wo bwi lo, nə kə tsok fa bʉ̀ʉ sə̀ mʉ kaŋsurù sə də, ");
INSERT INTO yam_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","<<Vès kə̀ wɛ̀s fo', vès ye ŋga ncùu sə tə ləlok mpaaŋ. Ŋga bʉ̀ʉ sə̀ wo kʉk nòoŋgə̀ ndapndzəm nə ndzəmə̀ tə fo' sə̀' bə̀boŋnì. Vès də vèes muk-a kə ncùu sə fana vès kà ŋwə̀ nə̀ mò'fis mbwa yə.>> ");
INSERT INTO yam_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ŋkum ŋgàa tək ndap Nwì nə̀ ghaŋ nə bə ŋkum ŋgàa fa satikà' sə̀ ghaŋ wèŋ à yuk vɛ'nə fana wo mərə yusə̀ yà'a nə kə ye mantombì sə bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Fana ŋwə̀ nəmòk ni kok və, nə tsok wo də, <<Wèŋ yuk-à, bʉ̀ʉ sə̀ wèŋ a nisə wo ndapndzəm sə, wo cu mʉ ndap Nwì nə̀ ghaŋ nə. Wo sə yə'rə bwìŋ mbwa!>> ");
INSERT INTO yam_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Fana ŋkum nə bə ŋgà tək ndap Nwì nə̀ ghaŋ bə bʉ̀ʉ ye wèŋ à lòkə̀ jə fəsə və̀ ŋgàa ntum sə maŋkwɛ̀ŋ. Wo à ka yà' bə top sə̀ ko bʉ̀ʉsə̀ wo à sə wəp də bwìiŋ tərə wo ŋga'a bə lìs. ");
INSERT INTO yam_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wo à jə və̀ ŋgàa ntum sə, nə dʉk wo təəŋ mʉ kaŋsurù anə. Fana ŋkum ŋgà fa satikà' nə sə cep bohòwo də, ");
INSERT INTO yam_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","<<Vès a cèp bohòwèŋ, nə soŋ weŋ ntu' bʉp bʉp də wèeŋ kà bwìŋ yumok bə liŋ ŋwə̀ ènə mok yə'rə yuk fa fe'lə̀, fana ja'a na yàwèeŋ yusə̀ wèŋ gʉ̀ʉ. Wèŋ gʉ̀ tə̀tè bʉ̀ʉ sə̀ mvwe' lak Jòrosalèm fɛɛŋ lòoŋ yuk wes nsàp yəyə'rə̀ àwèŋ ànə lòoŋ fo'. Wèŋ sə làp mandzə̀ ŋgògʉ̀ də vès à dʉk vès ŋkuŋ wo zə ŋwə̀ ènə!>> ");
INSERT INTO yam_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pità bə ŋgàa ntum mok sə wèŋ à cèp fəsə yàwo dʉk də, <<Vès tse' ŋgòyuk lɛ dʉk nə̀ Nwì, nə me'rə nə̀ bwìŋ. ");
INSERT INTO yam_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nwì tàcici avès à lòkoksə Jisòs mvwe' kpʉ mvəsə̀ wèŋ ànə tɛ'lə yi mʉ ntə̀əŋ, nə zə yi. ");
INSERT INTO yam_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nwì à lòkoksə yi, nə cumsə yi bo ma mà'a yi co ŋwə̀ nə̀ mantombì nə ye ŋgà lùŋsə bwìŋ sə̀'. Yi à gʉ̀ vɛ'nə ŋgòfa mandzə̀ bohòbwe Izùrɛ ŋgòkupsə, nə bwi fa bʉp awo ŋkwɛ̀ŋ ya wo tse' sə̀swìfa bə bʉp awo sə. ");
INSERT INTO yam_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Vès à yə bum yè'sə bə lis avès fana vès tse' ŋgòtsòho fa bwìŋ yà' sə̀'. Yòŋsə̀ nə̀ Rərɛŋ nə sə tsə̀' fa bwìŋ sə̀' də bum yè'sə zìnə.>> ");
INSERT INTO yam_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bʉ̀ʉ kaŋsurù sə à yuk vɛ'nə fana wo jok nə̀bʉp, nə dʉk də wo nə zə yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mòk ànə ye fo' mʉŋwə̀ə Faràsi, wo to yi də Gàmaliyà. Yi à tse' fàak sə̀ ŋgòyə'rə fa bwìŋ lʉ̀k. Yi lokok təəŋ mʉ kaŋsurù anə mʉtsə̀ ŋga yi à ye sə̀' nsàp ŋwə̀ nə̀ bwìiŋ wəpgə̀ yi maŋgəŋgèŋ, fana yi dʉk də wo jəŋ fis gɛsə lo ŋgàa ntum sə sə mbiŋ mvə̀k momjo. ");
INSERT INTO yam_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Yi yeto ŋgòdʉk fa bʉ̀ʉ sə̀ mʉ kaŋsurù anə dʉk də, <<Wèŋ bʉ̀ʉ Izùrɛ, wèeŋ jəŋ ŋkərə̀ bə nsàp yu nə̀ wèŋ sə dʉk də wèeŋ gʉ bʉ̀ʉ yè'e bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mvə̀k mòk à ye fa' nə̀ Tìodàs à və̀ə, nə sə dʉk kɛ'ca də yi ŋwə̀ nəmòk nə̀ ŋkʉ̀ʉŋ. Bʉ̀ʉ sə̀ wo à kpəəŋ yù yi à ye co bwìŋ ŋkʉ̀ kwè. Wo à zə yi fana bʉ̀ʉ sə caŋ sam bisə kɛ' zəzok, yusə̀ wo à sə dʉk də wo gʉ sə kpʉ bisə sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","À ye fe'lə maŋkwɛ̀ŋ, ghà nə̀ wo à sə ta bwìŋ fa' nà'a, Judàs mʉŋwə̀ə Galìli à və̀ ye sə̀'. Bwìŋ à yù yi sə̀' wùriŋ. Wo à zə yi fana bʉ̀ʉ ye sə wèŋ carə sam sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Fana nə̀ ŋga'a nè'e, mʉ̀ sə dʉk də wèeŋ kà bʉ̀ʉ yè'sə yumok gʉ̀. Wèeŋ me'rə wo vɛ'nə, bʉ̀ʉsə̀ a ye-a dʉk də nsàap yusə̀ wo sə tsòho kɛ' yà'sə ye-a yumok sə̀ ŋwè a tsərə kok yà' yi, fana ye də yà'a nə bisə. ");
INSERT INTO yam_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","A ye-a də a yu Nwì, fana mandzə̀ nə̀ co wèŋ ghak wo nə kà ye. Aco yà' ye də wèŋ sə lʉ̀ weŋ Nwì wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gàmaliyà nə à dʉk wes vɛ'nə fana kaŋsurù nə pwe' à dzəm ncèp ye nə. Wo to nisə vesə ŋgàa ntum sə wèŋ mʉ nda'à anə, nə jəŋ ŋkwɛ̀s, nə ləp wo bə zeŋ, nə dʉk fa wo də yà'wèeŋ kà yumok bə liŋ Jisòs mok cep yuk fe'lə̀, nə me'rə wo lo. ");
INSERT INTO yam_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ŋgàa ntum sə wèŋ à sə lo gɛsə mvwe' kaŋsurù nə bə kwəkwa sə ntʉʉ̀ wo nə̀bʉp. Wo à sə kwa də Nwì yə wo də wo yəyərə̀ ŋgòkə̀ yə ŋgə' bə marè'tu bʉ̀ʉ liŋ Jisòs. ");
INSERT INTO yam_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Fana à sə ye nùumbu pwe' wo sə yə'rə bwìŋ mʉ ndap Nwì nə̀ ghaŋ nə bə nda'à bwìŋ wèŋ, nə sə tsoho fa mali bwìŋ Ntirə̀ nə̀ Bə̀boŋ nə də Jisòos Ŋkum ŋgà gèm bwìŋ nə̀ wo sə kʉ̀k nə. ");
INSERT INTO yam_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mvə̀k à sə lòo, bʉ̀ʉ sə̀ wo à sə yù mandzə̀ Jisòs sə yam yàwo sə̀'. À kə̀ dzèŋ nùmbu mòk fana bʉ̀ʉ Jus sə̀ wo à sə cu gù yàwo la'à bə sə̀ wo à kə̀ dzə və̀ wo lakmvum wèŋ kʉəm. Sə̀ wo à dzə wo yàwo lakmvum sə wèŋ à sə cèp ŋwə̀m kɛ'cà dɛɛ, wo sə kà bàa yepmfə awo zʉzʉʉ sə̀ wo gàpgə̀ səsa yà'a fa. ");
INSERT INTO yam_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","À ye vɛ'nə fana ŋgàa ntum sə̀ hum-ncòp-ba sə to benə bʉ̀ʉ Jisòs sə pwe'fo' mvwe' mò'fis. Nə tsok fa yà'wèŋ də, <<Ka bə̀boŋ bohòvès də vèes me'rə ŋgòtsòho ncèp Nwì, nə cum ŋgòkʉ̀k lis mvwe' nzak zʉzʉ yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nə dʉk mali dʉk də, <<Bwema am wèŋ, wèeŋ kʉk mʉtsətsə'rə wèŋ, nə cokfis bwìŋ sàmba. A ye wo sə̀ bwìiŋ jəgə̀ wo co bʉ̀ʉ sə̀ kə̀kʉrə̀, sə̀ wo tse' ŋkərə̀, nə tse' Yòŋsə̀ nə̀ Rərɛŋ sə ntʉʉ̀ wo ya vèes fa wo nsàp fàk ènə. ");
INSERT INTO yam_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ya vèes jəŋ wes mvə̀k njàvès ŋgògʉ̀ pìriyà nə ye ŋgòtsòho ncèp Nwì.>> ");
INSERT INTO yam_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bʉ̀ʉ sə pwe' à kwa bə ncèp nə̀ ŋgàa ntum sə tsərə fa wo ènə. Fana wo cokfis ŋga'a Stefè, yi ŋwə̀ nə̀ yi naaŋgə̀ tu bohòNwì bə̀boŋni, nə tse' Yòŋsə̀ nə̀ Rərɛŋ nə sə̀'. Mok wèŋ à ye Filìp, Pokoròs, Nikanò, Timò, Pàraminà, nə ye Nèkolà nə̀ yi à ye ye ŋwə̀ə Antiyòk, nə bʉʉŋ ŋwə̀ Jus. ");
INSERT INTO yam_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wo à jə və̀ bʉ̀ʉ yè'sə, nə kə fa bohòŋgàa ntum sə wèŋ. Ŋgàa ntum sə à naaŋ fa wo bo mʉ tuhù, nə gʉ pìriyà. ");
INSERT INTO yam_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Fana ncèp Nwì à sə kùk lòmantombì. Bʉ̀ʉ sə̀ wo à sə yù mandzə̀ Jisòs mvwe' lak Jòrosalèm sə à sə yam lòsə̀' mantombì. Ŋgàa fa satikà' wèŋ à ye ŋkʉ̀ʉŋntɛ̀ŋ sə̀ wo à yuk nə dzəm sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefè à ye ŋwə̀ nəmòk nə̀ Nwì à fa yi ntʉm nə̀ bə̀boŋ wùriŋ. Yi à tse' ŋàŋ fana yi gʉ maŋgəŋgèŋ nə ye bum sə̀ co bwìŋ sə mərə mʉtsətsə'rə bʉ̀ʉ sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bʉ̀ʉ mok wèŋ à yè ŋgògʉ̀ də bə yà'wèeŋ kʉəm. Wo à ye bòp bʉ̀ nə̀ wo à sə nigə̀ ndap pìriyà nə̀ wo à sə to nà' də: Bʉ̀ʉ sə̀ wo cu bə tu awo. Bʉ̀ʉ Jus sə̀ wo à ye mbwa à tesə və̀ mvwe' lak Sìrinì bə lak Àlèsandà. Wo yà'sə nə ye bʉ̀ʉ Jus mok sə̀ wo à və̀ yàwo mvwe' nzeŋgòŋ Sìlisiyà bə nzeŋgòŋ Ɛsiyà wèŋ à yè ŋgòkʉ̀ə̀m bə Stefè wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Fana Yòŋsə̀ nə à fa Stefè nsàp ŋkərə̀ mòk vɛ'ɛ co wù kà fʉ̀k. Mvəsə̀ yi ànə sə cep fana wo kà yusə̀ co wo cep fəsə fa yi tse'. ");
INSERT INTO yam_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Fana wo lo kə ywiŋ bʉ̀ʉ səmok cù də yà'wèeŋ dʉk də wo yuk ŋga Stefè sə bʉpsə liŋ Musì nə ye liŋ Nwì. ");
INSERT INTO yam_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nà'a ŋkərə̀ nə̀ wo à gʉ̀ fana ntʉm yaaŋ bwìŋ wo jok. Bʉ̀ʉ sə à jòk wes pwe'fo', nə ye bə bʉ̀ ŋkwàha bʉ̀ʉ sə̀ fo', nə ye ŋgàa yə'rə̀ bwìŋ lʉ̀k wèŋ sə̀'. Wo à və̀ə, nə kə ko lo Stefè mʉ kaŋsurù. ");
INSERT INTO yam_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wo jəŋ və bʉ̀ʉ mok sə̀ wo kə ci' mvwès mʉ tuhù nà'. Wo dʉk də Stefè togə̀ liŋ mvwe' sə̀ rərɛŋ sə̀ wo kùksəgə̀ Nwì fo' sə bʉp riŋ riŋ, nə sə cep bʉp bə lʉ̀ʉk Musì sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Də wo à yuk ŋga yi sə dʉk də Jisòs nè'e nə̀ mvwe' lak Nazàrɛ nə kʉəmsə mak ndap Nwì, nə kupsə bum lak sə̀ Musì à fa wo pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bʉ̀ʉ sə̀ wo à ye mʉ kaŋsurù anə lòoŋfo' à bʉ̀ʉŋ kʉ̀k Stefè bə lis rap rap. Mvəsə̀ wo à sə kʉ̀k yi vɛ'nə fana wo ye ŋga si Stefè sə gʉ̀ co si masinjà Nwì. ");
INSERT INTO yam_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ŋkum ŋgàa fa satikà' nə à fek Stefè də, yu yè'sə zìnə àlɛ. ");
INSERT INTO yam_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefè ye ŋgòcèp fəsə də, <<Bwema nə ye tɛ̀' am wèŋ, wèeŋ yu'rə fa-a mʉ-ɛ. Ghà nə̀ tàcici àvès Abràham à ye mvwe' nzeŋgòŋ Mèsòpòtemiyà ŋkuŋ yi sə ye'e lo ŋgòkə̀ cu mvwe' lak Harà, Nwì nə̀ yi tse' fòwùriŋ nə à kə̀ yəəŋ bohòyi. ");
INSERT INTO yam_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Yi tsok fa nà' də, <Mè'rə bʉ̀ʉ yo, nə ye lak yo yè'e, nə lokok lo mvwe' nze mòk nə̀ zok nə̀ mʉ nə niŋ tsok fa wu.> ");
INSERT INTO yam_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Fana yi ye'e me'rə Càdiyà, nə lo kə cum Harà. Ghà nə̀ tɛ̀'ɛ Abràham à kpʉ, fana Nwì gʉ yi coho və mvwe' lak sə̀ wèŋ cu ŋga'a fo' yè'e. ");
INSERT INTO yam_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nwì à ka Abràham mʉmvwe' mòk fo' də a nə̀ nà' fa lok, à ka yeŋ koo momjo. Nə ye də Nwì ànə kak laŋ də yi nə fa fo' bohònà' nə ye bə ŋgwì bʉ̀ʉ ye sə̀ wo nə sə və maŋkwɛ̀ŋ. Mvə̀k nə̀ Nwì à sə kàk vɛ'nə, à ye ŋga Abràham ka mweŋ ntòtse'. ");
INSERT INTO yam_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yusə̀ Nwì à cèp sə à ye də, <Ŋgwì bʉ̀ yòo nə kə cu mvwe' lak mok sə̀ yà' ka yàwo yeŋ. Wo nə cum ŋkwɛ̀ŋ fo', wo sə fa wo ŋgə' wùriŋ mʉnə lùumŋgòŋ ŋkʉ̀ kwè. ");
INSERT INTO yam_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mʉ nə sak bʉ̀ʉ sə̀ wo nə sə fak fo' bohòyà'wèŋ sə sə̀', fana wo nə me'rə lak yà'sə, nə tesə və, nə sə kuksə mʉ mʉmvwe' nè'e.> ");
INSERT INTO yam_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ànə geŋ, Nwì bə Abràham à zʉ rʉ̀k də yi nə sə riŋ tse' nà' bə nsàp mandzə̀ nə̀ wo komgə̀ tu mbəmbam nà'a. Fana Abràham dzə Azìk, à dzèŋ ntɛŋ mò'fis, yi kom fa nà' tu. Azìk kom bwi fa mo ye Jàkop, fana Jàkop kom bwi fa bwe ye sə̀ hum-ncòp-ba sə̀ wo tàcicii avès. ");
INSERT INTO yam_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","<<Tàcicii avès sə wèŋ à kʉ̀k moma awo Jòsep bə lis sə̀ bʉp jì njo. Wo ko seŋ gesə lo yi də nà'a kə ye ŋkwɛ̀ŋ mvwe' nzeŋgòŋ Ijìp. Ànə ye-a sə̀ vɛ'nə fana, Nwì à ye yo, ");
INSERT INTO yam_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nə sə tɛsə Jòsep nə bə nsàp ŋgə' nə̀ yi à sə yə lòoŋfo'. Ghà nə̀ Jòsep à kə̀ dzèŋ bohòŋkum Ferònə̀ mvwe' nzeŋgòŋ Ijìp nə, Nwì à fa yi cùu sə̀ bə̀boŋ, nə fa yi ŋkərə̀. Feròànə ye vɛ'nə fana yi gʉ nà' ŋwə̀ nə̀ ghaŋ mvwe' nzeŋgòŋ Ijìp nə pwe'. Yi à gʉ̀ nà' ŋwə̀ nə̀ ghaŋ mʉmvwe' nto' ye sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Fana mvə̀k nəmòk à ye, njè ko mvwe' nzeŋgòŋ Ijìp bə nzeŋgòŋ Kanà pwe'. Njè nə à fa bwìŋ ŋgə' vɛ'ɛ wùriŋ. Tàcici avès wèŋ à ka bɛŋ mok sə tse'. ");
INSERT INTO yam_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jàkop ànə geŋ də yi yuk də wo tse' zʉzʉ mvwe' nzeŋgòŋ Ijìp yo fana yi tumsə gesə bwe ye sə̀ wo tàcicii avès sə fo'. Nà'a ghà nə̀ mantombì nə̀ wo à lòto fo'. ");
INSERT INTO yam_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Wo à və̀ nə̀ kɛ̀' ba, fana Jòsep gʉ bwema ye sə wèŋ rì də yi moma yà'wèŋ fana, nə gʉ Feròrì də yà'wèeŋ bʉ̀ʉ lak ye. ");
INSERT INTO yam_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jòsep tirə gesə fa tɛ̀' ye də nà' bə bwe nà' pwe' coho və mvwe' nzeŋgòŋ Ijìp nə. Wo à ye pwe'fo' bwìŋ hum sàmba-ncòp-tàŋ. ");
INSERT INTO yam_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Fana Jàkop coho tsooŋ lo sə Ijìp anə. Yà'a mvwe' sə̀ yi nə ye bwe ye, sə̀ wo tàcicii avès, à kpʉ wes mok fo'. ");
INSERT INTO yam_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mvə̀'nə̀ bwe awo à foho lòKanà wo bə̀hə lo vèeŋ ni' yà'wèŋ sə ŋgòtuuŋ mvwe' sə̀ wo togə̀ fo' də Sekèm. Wo à kə̀ tuuŋ wo fo' sənə sèe sə̀ Abràham à ywiŋ yà' bohòbwe Hamò. ");
INSERT INTO yam_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","<<Mvə̀k à sə kʉrə və̀ də ya Nwìi gʉ yusə̀ yi ànə kak fa Abràham sə, fana ŋga bʉ̀ʉ avès yam mvwe' nzeŋgòŋ Ijìp mok maŋgəŋgèŋ, ");
INSERT INTO yam_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","tèe ŋkum nəmòk nə̀ yi à ka Jòsep rì yuk, kə kok dzə̀' ŋkum mvwe' nzeŋgòŋ Ijìp anə mok yi. ");
INSERT INTO yam_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yi sə borə bʉ̀ʉ avès bə ŋkərə̀, nə sə gʉ tàcici avès wèŋ ŋgə' nə̀bʉp. Yi gʉ də wo kà bwe awo sə̀ lʉə mʉ nda'à nisə̀, də wo me'rə noŋsə bwe sə sə mbiŋ də ya ŋga yà'wèeŋ kpʉ. ");
INSERT INTO yam_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Yà'a sə̀' mvə̀k nə̀ wo à dzə Musì, mwe boŋ. Yi à cu mʉ nda'à tɛ̀' ye ŋwə tɛ'. ");
INSERT INTO yam_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mvə̀k nə̀ wo à kə̀ nòŋsə yi sə mbiŋ fana mo Feròmok nə̀ wà'ŋgwɛ̀ŋ à kə̀ te' jə nà' yuye. Yi sə tək nà' co mo ye. ");
INSERT INTO yam_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Wo à yə'rə yi, yi riŋ ŋkərə̀ə sə̀ yà' cu mvwe' nzeŋgòŋ Ijìp anə pwe' nə̀ pwe'. Yi bʉʉŋ ŋwə̀ nə̀ ghaŋ bə nsàp mandzə̀ nə̀ yi cèp cù, nə sə gʉ bum ye. ");
INSERT INTO yam_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","<<Ghà nə̀ Musì à dzèŋ lùumŋgòŋ hum kwè, fana yi dʉk də yi kə kɛ' ye bʉ̀ʉ ye wèŋ bwe Izùrɛ. ");
INSERT INTO yam_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yi lo, nə kə tseŋ ŋwə̀ ye mòk ŋga ŋwə̀ə Ijìp mòk sə lə̀p nà', fana yi geŋ də yi kə tɛsə nà'. Musì à lə̀p zə ŋwə̀ə Ijìp nə. ");
INSERT INTO yam_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Yi à sə tsərə də bʉ̀ʉ ye wèeŋ nə rɛɛŋ də Nwì tum yi ŋgòkə̀ tɛsə fis wo sənə ŋgə' awo, fana wo kà sə̀' rɛɛŋ. ");
INSERT INTO yam_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tsok à rɛŋ, yi ye bwe Izùrɛ bwìŋ ba ŋga wo sə lʉ̀lʉ̀. Yi geŋ fo', nə sə gʉ mandzə̀ nə̀ co wo kà lʉ̀. Yi fek yà' də, <Wèŋ sə də wèeŋ lʉ yè'sə bʉ̀ʉ yà, ŋge' am wèŋ? Mʉ̀ də wèeŋ bwema mvwe' mò'fis àlaa?> ");
INSERT INTO yam_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Fana nə̀ yi à sə fa mòk ŋgə' yi nə bwi' gɛsə Musì fo', nə dʉk fa nà' də, <Ŋwə̀ nə̀ yi dʉk wu də wu kə kok ŋkum bohòvès nə sak vèes ndà? ");
INSERT INTO yam_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wù də wu zə mʉ mvəsə̀ wù a zə ŋwə̀ə Ijìp ŋkwìs yà'a nà?> ");
INSERT INTO yam_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musì ànə yuk mvəsə̀ nà' cèp vɛ'nə, fana yi caŋ lo, nə kə cum bisə mvwe' lak Midiyà. Yi à cu fo' tè yi dzə bwe mbəmbam ba. ");
INSERT INTO yam_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","<<À cà lùumŋgòŋ hum kwè, fana Musì ye masinjà Nwì mòk bə lis. Nà' à yəəŋ bohòyi ndzənə mis ŋga nà' sə kʉə mʉ tʉhʉ̀ nə kà liìŋ. Mis ènə à kʉə ŋgəà, mvwe' ŋgʉ nda nəmòk nə̀ wo togə̀ nà' də Sinà. ");
INSERT INTO yam_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musì à yə vɛ'nə, nə mərə maŋgəŋgèŋ, fana nə sə gi sooŋ geŋ fo' də yi ye tsə'rə yà' bə̀boŋ. Yi yuk ŋga ŋgì Tà sə cèp də, ");
INSERT INTO yam_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","<A mʉ̀ʉ Nwì tàcicii awèŋ. Nwì Abràham, Azìk bə Jàkop.> Musì à yuk vɛ'nə, yi sə jik bə wʉə vɛ'ɛ kpʉ̀k kpʉ̀k, nə kà lis mok kʉ̀k. ");
INSERT INTO yam_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tà à tsə̀' yi də nà'a cokfis kùuŋgùp nà', bʉ̀ʉsə̀ mvwe' sə̀ nà' tə yà'sə, a fo' nze nə̀ rərɛŋ. ");
INSERT INTO yam_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nə dʉk fe'lə sə̀' dʉk də, <Mʉ̀ kʉ̀k ja'a, nə ye ŋgə' nə̀ bʉ̀ʉ am wèŋ sə yə mvwe' nzeŋgòŋ Ijìp. Mʉ̀ a yuk waŋ awo sə̀' laŋ, fana mʉ̀ nə və̀ə nə də mʉ kə tɛsə wo. Və̀ə, ya mʉ tum gesə wu Ijìp anə.> ");
INSERT INTO yam_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","<<À ye Musì nə̀ bwe Izùrɛ à dzèeŋ yi, nə fek yi də, <Ŋwə̀ nə̀ yi dʉk wu də wu kə ye mantombì bohòvès, nə sak vèes ndà lɛ?> nə. A yi nə̀ Nwì tumsə co ŋwə̀ nə̀ mantombì nə ye ŋwə̀ nə̀ yi fis wo sənə ŋgə'. Nwì à fa càsə yi fàak sə bohòmasinjà Nwì, nə̀ nà' à yəəŋ bohòyi ndzə misə̀ nà'a. ");
INSERT INTO yam_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yi à təəŋ mantombì ŋgòjə fis bʉ̀ʉ sə mvwe' nzeŋgòŋ Ijìp yi. Yi à gʉ̀ maŋgəŋgèŋ nə ye bum sə̀ co bwìŋ mərə mvwe' nzeŋgòŋ Ijìp nə ye mvwe' ndzəp nə̀ wo togə̀ nà' də Ndzəp nə̀ Bə̀baŋ nà'a sə̀'. Mvəsə̀ wo à sə lòo, yi sə gʉhʉ lo mali maŋgəŋgèŋ mvwe' nze nə̀ ŋgəà mʉnə lùumŋgòŋ hum kwè sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","<<Gù sə Musì ènə nə̀ yi à tsə̀' bwe Izùrɛ də, Nwìi nə̀ tumsə fa yà'wèŋ ŋgà tsòhòbum Nwì sə̀' mvəsə̀ nà' a tum vèsə yi Musì nə. Ŋwə̀ ànə nə ye mo nə̀ njàwèŋ. ");
INSERT INTO yam_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","A yi Musì nə̀ bwe Izùrɛ à baaŋ mvwe' nzeŋgòŋ ŋgəà fana yi ye bə yà'wèŋ nə. Yi à ye fo' bə tàcicii avès nə ye bə masinjà Nwì nə̀ nà' à cèp bohòyi mʉnə nda Sinà. Yi à jə ncèp Nwì nə̀ nà' tse' yòŋsə̀ nja nə fa'nə ŋgòcàsə fa vesùwèŋ. ");
INSERT INTO yam_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Tàcicii avès wèŋ à ka ŋgòyuk yusə̀ Musì nə à sə cèep dzəm. Wo me'rə noŋsə yi, nə sə dʉk sə ntʉʉ̀ wo də bòco wo bwi foho lo fe'lə Ijìp anə sə̀mok. ");
INSERT INTO yam_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Fana wo dʉk fa Aròŋ də nà'a gʉ̀ fa wo yumok sə̀ yà'a ye mantombìi wo. Də wo ka yusə̀ yà' gʉ̀ ŋwə̀ nə̀ yi a jə fis və̀ ves mvwe' nzeŋgòŋ Ijìp, nə̀ wo to fa ves yi də Musì ànə riŋ. ");
INSERT INTO yam_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nà'a ŋga'a mvə̀k nə̀ wo à gʉ̀ yumok co nwì awo nà' səsə mo mbòŋ. Wo à sʉə nsùŋgaŋ, nə tɛŋ vəpsə nà', nə kaŋ dzeŋ ŋgòkùksə yusə̀ wo à gʉ̀ wo bə bo awo. ");
INSERT INTO yam_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nwì à mè'rə wo fana wo sə kuksə kɛ' ca lo ŋkə̀ŋkàaŋ sə̀ mʉbu. Yà'a mvəsə̀ wo à còm ndzənə ŋwàk ŋgàa tsòhòbum Nwì də, <Wèŋ bʉ̀ʉ Izùrɛ, nàam sə̀ wèŋ à sə səhə, nə sə gʉhʉ satikà' bə zeŋ ŋgəà yà'a à ka bohòmʉ̀ yeŋ. Wèŋ à gʉ̀ vɛ'nə mʉnə lùumŋgòŋ hum kwè. ");
INSERT INTO yam_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Wèŋ à sə bə̀hə tse' kɛ'cà tàap nwì àwèŋ nə̀ liŋ yee də Molòk, bə mòk nə̀ yi tse' nsəsə̀ ŋkə̀ŋkàŋ nə̀ liŋ yee Refàŋ. Yà'a nwìi sə̀ wèŋ à gʉ̀ bə bo awèŋ də wèeŋ kuksə wo. Mʉ nə me'rə weŋ wo jəŋ casə lo weŋ sə Babilòŋ.> ");
INSERT INTO yam_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","<<Mvəsə̀ tàcicii avès à ye ŋgəà yà'a, fana wo à tse' tàap sə̀ yà' à sə nì tsə̀' fa wo də Nwìi fɛŋ bə yà'wèŋ. Wo à gʉ̀ yà' mvəsə̀ Nwì à dʉk Musìi gʉ yà', mvə̀'nə̀ yi nìŋ tsòho fa nà' sə. ");
INSERT INTO yam_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","À cu fana, tɛ̀'ɛ tàcici avès wèŋ sə fa casə lo nà' bohòbwe awo wèŋ. Ghà nə̀ Josuwà à sə jə lòwo bə ghà nə̀ wo à sə fep jə nze nə bohòbʉ̀ʉ sə̀ Nwì à sə bɛ' gɛsə wo, wo sə bək tse' nà'. Nà' à cu mali fo' tə̀tè Devìd à kə̀ tsèŋ nà'. ");
INSERT INTO yam_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ntʉm Nwì à ye bə̀boŋ bohòDevìd, fana yi fek Nwì də nà'a fa yi mandzə̀ ya yi ci fa Nwìi Jàkop ndap. ");
INSERT INTO yam_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Anə geŋ, kə ci fa yi ndap nə mo ye, Sòlomù. ");
INSERT INTO yam_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","<<Yusə də, Nwì nə̀ yi yam càsə yi, nə kà mʉnə ndap nə̀ bwìŋ gʉ nà' bə bo cugə̀. A mvəsə̀ ŋgà tsòhòbum Nwì à cèp də, ");
INSERT INTO yam_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Tà Nwì dʉk də, <Ntòbu mvwe' dzə̀' ŋkum àm cu, nzeŋgòŋ ye ye mvwe' sə̀ mʉ nə̀ŋ tesgə̀ kùu am. Aco wèŋ ci fa mʉ yàwèeŋ nsàp ndap nə̀ fò? Mvwe' sə̀ co wèŋ fa mʉ, mʉ̀ cum fo' fò? ");
INSERT INTO yam_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mʉ̀ à ka bum yè'e pwe' mʉ̀ gʉ à?> Yè'e yusə̀ Tà Nwì cèep. ");
INSERT INTO yam_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","<<A nsàp gʉtu nə̀ fòbohòwèŋ vɛ'nə ɛ? Ntʉm awèŋ gʉ tsə gʉ̀ co bʉ̀ʉ sə̀ wo à loho ntu', nə kà ncèp Nwì yuk yuk. Weŋ gʉ̀ co tàcicii awèŋ. Wèeŋ dzèeŋgə̀ yusə̀ Yòŋsə̀ nə̀ Rərɛŋ nə cèpgə̀ yà'. ");
INSERT INTO yam_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ŋgà tsòhòbum Nwì mòok yo nə̀ tàcicii awèŋ à ka yi ŋgə' fa yuk à? Wo zə ŋgàa gə̀ ntum Nwì wèŋ sə̀ wo ànə ye taaŋ ntɛ̀ŋ, sə̀ wo à sə cep tsə̀' fa bwìŋ də, mo fàk Nwì nə̀ yi nə sə gʉ yusə̀ Nwì dzəm sə nə və. Nə̀ ŋga'a nè'e, wèŋ a sèŋ yi, nə zə yi. ");
INSERT INTO yam_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","A wèŋ sə̀ masinjàa Nwì à jə və̀ fa weŋ lʉ̀ʉk Nwì, wèŋ kà yà' yù lò.>> ");
INSERT INTO yam_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bʉ̀ʉ sə̀ mʉ kaŋsurù sə wèŋ à yu'rə yusə̀ Stefè à cèp sə, fana wo jok, nə zʉ kpʉ nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stefè à rwiŋ bə Yòŋsə̀ nə̀ Rərɛŋ nə cɛ̀bʉ̀ə̀, fana yi kʉk gesə lo mʉbu, nə ye marɛŋ nə̀ Nwì ŋga nà' sə rɛŋ nə̀bʉp. Yi ye Jisòs ŋga nà' tə Nwì bo ma zʉ. ");
INSERT INTO yam_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Fana yi cep dʉk də, <<Hàwèŋ, ntòbu mùhu nòto fana mʉ̀ yə mo ŋwè ŋga yi tə bo ma zʉ Nwì.>> ");
INSERT INTO yam_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bʉ̀ʉ sə wèŋ à gham, nə sop tse'e ntu'u awo bə nduuŋ bo awo. Wo caŋ be'lə və mvwe' mò'fis ŋgʉ ni'ì yi, ");
INSERT INTO yam_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","nə bək fis mak gɛsə lo yi mʉ ntòlak anə fo', nə sə təprə yi bə lìs. Bʉ̀ʉ sə̀ wo à sə cì' fa Stefè mvwès sə à fweŋ nòŋsə cə̀ək awo bohòwà'nzùm nəmòk, wo togə̀ yi də Sol, də nà'a sə kʉk fa tse' wo. ");
INSERT INTO yam_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Stefè sə waŋ to Tà dʉk də, <<O Tà Jisòs, yòŋsə̀ am nè', jəŋ mʉ.>> Wo sə təprə gu yi vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yi təəŋ bə tumfərə, nə sə waŋ torə fis də, <<Tà, swìfa wo bʉp nə̀ wo gʉ̀ ènə.>> Yi à dʉk wes vɛ'nə ntɛ̀ŋ, fana yòŋsə̀ ye me. ");
INSERT INTO yam_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol à dzəm sə̀' də a bə̀boŋ mvəsə̀ wo zə Stefè vɛ'nə. À yè jəŋ sə̀' nùmbu ànə wo yè ŋgòyeŋsə bʉ̀ʉ cos ŋgə' nə̀ bə ŋgwap mvwe' lak Jòrosalèm pwe'. Bʉ̀ʉ sə̀ wo à dzəm sə à ca sam wes mè vɛ'ɛ pwe' nə̀ pwe'. À bwehe cu mègù mok ŋgàa ntum sə wèŋ, ŋga bwìŋ carə lòwes mvwe' nzeŋgòŋ Jùdiyà nə ye Sàmàriyà. ");
INSERT INTO yam_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bʉ̀ʉ mok sə̀ wo à rì Nwì à kə̀ tuuŋ Stefè, nə waŋ kpʉ ye maŋgəŋgèŋ. ");
INSERT INTO yam_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol à làp mandzə̀ də yi ləsə cos nə kɛ̀' mò'fis. Yi à sə fi lòncùu bwìŋ mò'fis, mò'fis, nə sə ko sooŋ fis lo bə̀ba bə mbəmbam sə̀ wo à dzəm bohòJisòs, nə sə kə nisə wo ndapndzəm. ");
INSERT INTO yam_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mvəsə̀ bʉ̀ʉ sə̀ wo à dzəm sə à ca sam, fana mvwe' sə̀ wo à sə lòpwe' wo sə tsoho lo ncèp nə̀ Jisòs nə fo' sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filìp à lòye mvwe' nzeŋgòŋ Sàmàriyà, nə sə tsoho fa bʉ̀ʉ lak sə fo' sə liŋ Ŋkum ŋgà gèm bwìŋ nə. ");
INSERT INTO yam_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bʉ̀ʉ sə̀ fo' sə à yu'rə bòŋsə ncèp nə wù kà fʉ̀k. Wo à yu'rə, nə sə ye maŋgəŋgèeŋ sə̀ yi à sə gʉ̀hʉ. ");
INSERT INTO yam_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yòŋsə̀ə sə̀ bʉp à tesə ndzə ni'ì bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ, nə sə waŋ sa'rə bə ŋàŋ. Yi à gʉŋsə bʉ̀ʉ sə̀ wo à sə kà ni' awo te' bʉ̀sə̀ lok, bə bʉ̀ʉ sə̀ wo à sə ka bə̀boŋ gì wèŋ maŋgəŋgèŋ. ");
INSERT INTO yam_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Bʉ̀ʉ sə̀ mvwe' nzeŋgòŋ Sàmàriyà sə wèŋ à tse' kwəkwa wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ŋwə̀ nəmòk à ye mvwe' lak yà'sə nə̀ liŋ ye à ye də Saimʉ̀. Yi à cu fo' mweè sə̀sap ntɛ̀ŋ, nə sə məŋsə bʉ̀ʉ sə̀ mvwe' lak yà'sə bə nsàp mfim nje nə̀ yi à sə gʉ̀ʉ. Yi à sə tsòho fa bwìŋ də yi ŋwə̀ nəmòk nə̀ ŋkʉ̀ʉŋ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bʉ̀ʉ sə̀ wo à ye mvwe' lak yà'sə pwe'fo', bə ŋkwàha bwìŋ pwe' à sə kʉ̀k gù lis mok bohòyi. Wo dʉk də ŋàaŋ ye sə nìŋ də yi ŋwə̀ nə̀ wo togə̀ yi də Nwì nə̀ ghaŋ nə, də yi a və̀ ŋgòkɛ' yə wo, nə yəəŋ bohòwo co Saimʉ̀. ");
INSERT INTO yam_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yi à məŋsə wo bə mfiim ye sə tə̀tè wo sə kʉk gu lis mok bohòyi. ");
INSERT INTO yam_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ànə geŋ wo yuk, nə dzəm Ntirə̀ nə̀ Bə̀boŋ nə̀ Filìp à sə tsòho, mvəsə̀ gaŋ Nwìi fàkgə̀ə, nə ye də Jisòos Ŋkum ŋgà gèm bwìŋ nə. Fana wo bàptɛsə. Bə̀ba bə mbəmbam wèŋ à sə bàptɛsə pwe'. ");
INSERT INTO yam_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimʉ̀ bə tu ye à dzəm, nə baptɛsə sə̀'. Yi à sə gìhi mègù mok bə Filìp mvwe' mò'fis. Yi à sə yə nsàap maŋgəŋgèeŋ sə̀ ghaŋ sə̀ Filìp à sə gʉ̀, fana yà' məŋsə yi nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mvə̀k ànə à ye fana ŋgàa ntum sə̀ mvwe' lak Jòrosalèm à yuk də bʉ̀ʉ sə̀ mvwe' nzeŋgòŋ Sàmàriyà a yuk ncèp Nwì, nə dzəm, fana wo tumsə gesə fa wo Pità bə Jon. ");
INSERT INTO yam_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wo à kə̀ dzèŋ fo', fana wo gʉ fa bʉ̀ʉ sə̀ wo a dzəm sə wèŋ pìriyà də ya wo tse' Yòŋsə̀ nə̀ Rərɛŋ nə. ");
INSERT INTO yam_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","À ye vɛ'nə bʉ̀ʉsə̀ à ye ŋga wo ka Yòŋsə̀ nə̀ Rərɛŋ nə ntòtse'. À ye ŋga wo à bàptɛsə gù mʉnə liŋ Tà Jisòs. ");
INSERT INTO yam_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pità bə Jon à naaŋ fa wo bo fana Yòŋsə̀ nə̀ Rərɛŋ nə və bohòwo. ");
INSERT INTO yam_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimʉ̀ à yə də ŋgàa ntum naaŋ fa yà'wèŋ bo ŋkuŋ wo tse' Yòŋsə̀ nə̀ Rərɛŋ nə, fana yi dʉk də yi fa wo mbàm, ");
INSERT INTO yam_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","də ya yà'wèeŋ fa yi nsàp ŋàŋ nə̀ ŋgòjwɛ̀ŋ bwìŋ ŋkuŋ wo tse' Yòŋsə̀ nə̀ Rərɛŋ nà'nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pità à dʉk fa nà' də, <<Wu kpʉ lo bisə bə mbàam yo sə pwe', bə nsàp nə̀ wù tsərə də aco wù ywiŋ ŋàaŋ sə̀ Nwìi fagə̀ yà' yi bə mbàm yà'sə. ");
INSERT INTO yam_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yè'e ka fàak yòyeŋ, wù ka bo sənə fàak yà'sə tse' bʉ̀ʉsə̀ ntʉm yòka rərəŋ mʉ lisə̀ Nwì yeŋ. ");
INSERT INTO yam_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kupsə ntʉm yòbə tsətsərə̀ yònə̀ bʉp nə̀ wù tse' nà'nə, nə lɛŋ Tà də yi swi fa wu bʉ̀ʉsə̀ wù tse' nsàp tsətsərə̀ ànə. ");
INSERT INTO yam_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bʉsə̀ mʉ̀ yə də wu ŋgà sʉə nə̀ bʉp fana bʉp kìtse' wu cʉ̀k.>> ");
INSERT INTO yam_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimʉ̀ dʉk fa Pità bə Jon də, <<Kwəkwè', wèeŋ lɛŋ fa mʉ Tà də nsàp yu nə̀ wèŋ cèp nè'nə kà bohòmʉ̀ və̀.>> ");
INSERT INTO yam_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ànə geŋ ghà nə̀ wo à tsòho wes fa bwìŋ yusə̀ wo rì bə liŋ Tà Jisòs, nə tsoho ncèp nə̀ Jisòs nə sə̀', fana Pità bə Jon bwi foho lo fe'lə Jòrosalèm. Mvəsə̀ wo à sə lòmandzə̀, wo sə tsoho lo kɛ' Ntirə̀ nə̀ Bə̀boŋ nə mvwe' buhu lak zəzok sə̀ yà'a mvwe' nzeŋgòŋ Sàmàriyà. ");
INSERT INTO yam_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Masinjà Tà Nwì à tsə̀' fa Filìp də nà'a fʉhʉ, nə yuŋ tsoŋ lo mandzə̀ nə̀ wu təəŋ Jòrosalèm nə sə kʉk lo ma ntonùm, fana wu ga'a lo bo mamàk ŋgòlòGazà nà'a. Wo à màk mandzə̀ ànə laŋ. ");
INSERT INTO yam_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Filìp à fʉ̀hʉ, nə tsooŋ lo. Ànə ye ŋga ŋwə̀ə Ìtopiyà mòk nə̀ yi ŋwə̀ nə̀ ghaŋ sə bwi foho lòla'à yi. Yi à sə lòksə fagə̀ ŋkum nə̀ mvwe' nzeŋgòŋ Ìtopiyà, nə̀ yi à ye ŋwàŋwè nà'a, mbàam nà' pwe' yi. Bʉ̀ʉ Ìtopiyà wèeŋ togə̀ ŋkuum bə̀ba awo sə də Kandàs. Ŋwə̀ ènə ànə lo Jòrosalèm ŋgòkùksə Nwì, nə sə bwi foho lo sənə makarə̀ ye. Mvəsə̀ nà' à sə dzərə lòo, fana yi sə taŋ ŋwàk nə̀ ŋgà tsòhòbum Nwì Ìzayà à còom. ");
INSERT INTO yam_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yòŋsə̀ nə̀ Rərɛŋ nə à tsə̀' Filìp də nà'a gi sooŋ kʉəp geŋ ŋgʉ makarə̀ nə. ");
INSERT INTO yam_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filìp à ca gə̀ fo', nə yuk ŋga nà' sə ta fis ndzənə ŋwàk nə. Fana yi fek nà' də, nà' sə rɛɛŋ yusə̀ nà' sə ta sə àlɛ? ");
INSERT INTO yam_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ŋwə̀ nə̀ ŋkʉ̀ʉŋ nə à dʉk də, <<Hai', aco mʉ̀ rɛɛŋ va ŋga ŋwə̀ nəmòk ka mʉ tsok rɛŋsə fa-ɛ?>> Fana yi to Filìp də nà'a və bə nà'a kok cum mʉnə makarə̀ nə bəbɛ'. ");
INSERT INTO yam_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mvwe' sə̀ yi à sə ta ndzənə ŋwàk Nwì sə à ye də, <Yi à ye co nsùŋgaŋ nə̀ wo jəŋ lòŋgòsʉə sʉə, kè mʉmo nsùŋgaŋ nə̀ wo sə ci'lə fis nwɛ̀ɛs ye, yi kà cù mùk àlɛ'. ");
INSERT INTO yam_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wo à gʉ̀ fa yi bum marè'tu, nə bɛŋ ŋgògʉ̀ fa yi yusə̀ yà'a zìnə. Ŋwə̀ nə̀ co yi nə riŋ yumok bə ŋgwì bʉ̀ʉ ye bʉ̀ə̀, bʉ̀ʉsə̀ yi à ka sə nze fɛɛŋ tə̀tè cum.> ");
INSERT INTO yam_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ŋwə̀ nə̀ ghaŋ nə à fek Filìp də nà'a tsok fa yi də ŋgà tsòhòbum Nwì à sə cèp yè'sə bə liŋ ndà lɛ. A bə tu nà', kè ŋwə̀ nəmòk nə̀ zok ɛ? ");
INSERT INTO yam_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filìp à yèto ŋgòcèep, yi à yèto bə mvwe' sə̀ wo nə taŋ sə, fana yi tsoho fa nà' Ntirə̀ nə̀ Bə̀boŋ nə̀ bə liŋ Jisòs nə. ");
INSERT INTO yam_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mvəsə̀ wo à sə tsə lòo, fana wo kə dzeŋ mvwe' ndzəp nəmòk, fana ŋwə̀ nə̀ ghaŋ nə fek Filìp dʉk də, <<Ndzəp nè'.>> Nə dʉk fe'lə də <<Kaco mʉ̀ baptɛsə fɛɛŋ yeŋ bʉ̀ʉ yà?>> ( ");
INSERT INTO yam_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filìp dʉk fa nà' də, aco nà' bàptɛsə sə̀' ntɛ̀ŋ, ŋga a ye-a də nà' dzəm yusə̀ yi tsə̀' fa nà' sə bə ntʉm nà' pwe'fo' na. Yi dʉk də yi dzəm bə ntʉm ye pwe'fo' də Jisòs Krɛɛst mo Nwì.) ");
INSERT INTO yam_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ŋwə̀ nə̀ ghaŋ nə à dʉk də wo gʉ ya makarə̀ nə nà'a təəŋ. Fana wo ba fo' Filìp bə ŋwə̀ nə̀ ŋkʉ̀ʉŋ nə à tsə lo sə ndzəpə̀. Filìp bàptɛsə yi. ");
INSERT INTO yam_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wo à sə tesə kok sə ndzəpə̀ anə, fana Yòŋsə̀ Tà Jisòs jəŋ bisə lo Filìp nə. Ŋwə̀ nə̀ ŋkʉ̀ʉŋ nə à ka nà' mok ye fe'lə. Yi sə lo mali yuye, nə sə kwaha lo wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filìp à də yi kʉk ŋga yi yè' mvwe' lak Àzotò. Yi gihi lo kɛ' mvwe' lak sə̀ fo' sə, nə sə tsoho lo Ntirə̀ nə̀ Bə̀boŋ tə̀tè yi à kə̀ dzèŋ mvwe' lak sə̀ wo togə̀ fo' də Sìsàriyà. ");
INSERT INTO yam_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ghà nə̀ bum yè'sə à sə ye vɛ'nə fana Sol sə wəpsə mali bʉ̀ʉ sə̀ wo à sə yù mandzə̀ Tà Jisòs sə də yi nə zə yà'wèŋ. Yi à ye'e lòkə ye ŋkum ŋgà fa satikà', ");
INSERT INTO yam_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nə fek nà' də nà'a fa yi ŋwàk mòk nə̀ ŋgòfa yi ŋàŋ ŋgòko bwìŋ mʉ Dàmaskù. Yi də yi jəŋ nà', nə lo bə zeŋ mvwe' ndaap pìriyàa bʉ̀ʉ Jus sə̀ mʉ Dàmaskù, də yi kə dzeŋ-a mbwa, nə ye ŋga ŋwə̀ nəmòk sə bɛ' mandzə̀ nə̀ Tà Jisòs, fana yi ko wo pwe', bə̀ba kè mbəmbam àlɛ, nə jəŋ və wo Jòrosalèm anə. ");
INSERT INTO yam_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yi à sə lòDàmaskù anə, ŋga yi sə kʉəp lòŋgʉ ntòlak nə ntɛ̀ŋ, yi ye ŋga marɛŋ mòk ba'a tsə mʉbu co mbʉ̀ŋ vɛ'ɛ, nə rɛŋ mvwe' sə̀ yi tə sə vɛ'ɛ paamm. ");
INSERT INTO yam_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Yi gbʉ sə nze, fana nə yuk ŋga ŋgì ŋwə̀ nəmòk sə cèp də, <<Sol, Sol, wù sə fa mʉ ŋgə' bʉ̀ʉ yà?>> ");
INSERT INTO yam_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Yi fek də, <<A wùu ndà Tà?>> Ŋgì ŋgə̀ŋgàŋ dʉk fe'lə də, <<A mʉ̀ʉ Jisòs nə̀ wù sə fa mʉ ŋgə' nə. ");
INSERT INTO yam_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lòkok mʉtsə̀, nə lo mʉ ntòlak anə. A kə dzeŋ fo' ŋkuŋ wo tsok wu yusə̀ wu nə gʉ tsoŋ yà'.>> ");
INSERT INTO yam_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bʉ̀ʉ sə̀ wo à sə gì bə Sol wèŋ à təəŋ fo', nə kà yusə̀ co wo cep tse'. Wo à yuk ŋgì nə, nə kà ŋwə̀ nəmòk yə. ");
INSERT INTO yam_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol à lòkok sə nze, nə də yi muk lis ye, fana yi kà bum yə. Wo à dàsə nisə lòyi Dàmaskù mok bə bo. ");
INSERT INTO yam_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yi à cu fis nùumbu tɛ' ŋga yi sə kà yə. Mʉnə nùumbu sə̀ tɛ' yà'sə pwe' bo bə cùu ye kà kùrə̀, yi kà ndzəp sə̀' no lok. ");
INSERT INTO yam_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ŋgà yù mandzə̀ Jisòs mòk à ye Dàmaskù anə nə̀ wo to liŋ ye də Ànàniyàs. Yi ye yumok co yi yə lo vɛ'ɛ, fana Tà Jisòs to yi nja dʉk də, <<Ànàniyàs.>> Yi dzəm də, <<Tà, mʉ nè'e.>> ");
INSERT INTO yam_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tà nə dʉk fa yi də, <<Fʉ̀hʉ, nə yuŋ lo mandzə̀ nə̀ wo togə̀ nà' də Rərəŋ nà'a. Wu kə dzeŋ mvwe' ndap Judàs, fana wù fek fo' də wù dzəm ŋgòyə Sol nə̀ yi mo nze mvwe' lak Tasò. Yi sə gʉ pìriyà, ");
INSERT INTO yam_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","nə sə ye co lo vɛ'ɛ də yi yə ŋwə̀ nəmòk nə̀ wo to yi də Ànàniyàs və̀ə, nə kə naaŋ fa yi bo də ya yi ye fe'lə bum sə̀mok.>> ");
INSERT INTO yam_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ànàniyàs dʉk də, <<Tà, a bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ sə̀ wo a tsə̀' mʉ nsàap ŋgwap sə̀ ŋwə̀ ènə sə gʉ̀ bohòbʉ̀ʉ yo sə̀ mvwe' lak Jòrosalèm pwe'. ");
INSERT INTO yam_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yi nə və̀ nə Dàmaskù bə ŋàaŋ sə̀ yi a jə bohòŋkum ŋgà fa satikà' də yi ko ndàaŋwè pwe' nə̀ nà' to liŋ yò.>> ");
INSERT INTO yam_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tà à dʉk də, <<Gèŋ ntɛ̀ŋ, bʉ̀ʉsə̀ yi ŋwə̀ nə̀ mʉ̀ a swekfis yi ya bʉ̀ lakmvum, ŋkəkum nə ye bʉ̀ʉ Izùrɛ wèeŋ nə riŋ liŋ am. ");
INSERT INTO yam_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Fana mʉ̀ bə tu am nə niŋ fa yi nsàp ŋgə' nə̀ yi nə ye bʉ̀ʉ mʉ̀ ŋgògʉ̀ də ya bwìiŋ riŋ mʉ.>> ");
INSERT INTO yam_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ànàniyàs à lò, nə kə ni kok mʉ nda'à anə, nə naaŋ fa Sol bo. Nə sə dʉk də, <<Moma am Sol, Tà Jisòs tum vèsə mʉ yi, yi nə̀ yi a yəəŋ bohòwù mandzə̀ ŋga wù sə və̀ fɛɛŋ nà'a. Yi tum mʉ ya wu ye fe'lə bum sə̀mok, nə rwiŋ bə Yòŋsə̀ nə̀ Rərɛŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Yi ànə dʉk wes vɛ'nə ntɛ̀ŋ, fana yumok ye'e gbʉ tsooŋ mʉ lisə̀ Sol anə co bap, fana yi ye fe'lə bum sə̀mok. Yi à lòkok, fana wo bàptɛsə yi. ");
INSERT INTO yam_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Yi a zʉ wes bɛŋ, fana yi tse' fe'lə ŋàŋ sə̀mok. Sol à cu nùumbu mok bə bʉ̀ʉ sə̀ wo à sə yù mandzə̀ Jisòs mvwe' lak Dàmaskù anə. ");
INSERT INTO yam_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mvəsə̀ yi à ye fo', yi à lòmvwe' ndap pìriyà bʉ̀ʉ Jus, nə ye ŋgòtsòho liŋ Jisòs sə̀ ntɛ̀ŋ. Yi dʉk də, Jisòs nə mo Nwì. ");
INSERT INTO yam_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bʉ̀ʉ sə̀ wo à yuk yusə̀ yi à sə cèp sə à mərə lòoŋ. Wo sə fek də, <<Nè'e ka ŋgà' nə̀ yi à ye Jòrosalèm, nə sə zə ndàaŋwè pwe' nə̀ nà' to liŋ yè'sə nə yeŋ à? Yi a və̀ fɛɛŋ ka sə̀' də yi kə ko bwìŋ də ŋga yi jəŋ lo yà' ŋgòfa ŋkum ŋgà fa satikà' nə yeŋ à?>> ");
INSERT INTO yam_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Fana Sol tsoho gʉŋsə ghaha lo wesə mantombì mvəsə̀ yi à sə nì tsə̀' də Jisòos Ŋkum ŋgà gèm bwìŋ nə. Yusə̀ yi à sə cèp sə à rɛɛŋ nòoŋ vɛ'ɛ jəja nsàp nə̀ bʉ̀ʉ Jus sə̀ wo cu Dàmaskù anə jip, nə kà yusə̀ ŋgòcèp fəsə fa yi tse'. ");
INSERT INTO yam_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","À kə̀ dzèŋ nùumbu mok fa'nə, fana bʉ̀ʉ Jus wèŋ kə cum kwe' də wo zə Sol nə. ");
INSERT INTO yam_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ànə geŋ Sol riŋ bə kwe' nə̀ wo à cu nə. Nə̀ maràŋ bə ndzəmə̀ pwe' wo sə so Sol mvwe' ncùu ŋka' sə̀ mvwe' ntòlak nà'nə. ");
INSERT INTO yam_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","À ye nùmbu mòk ŋga ndzəm seŋ, fana bʉ̀ʉ Sol mok kə le' casə yi mvwe' tətoo ŋka' sə ŋkò'o. ");
INSERT INTO yam_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol à lòJòrosalèm, nə lap mandzə̀ də bə bʉ̀ʉ Jisòs wèeŋ ye mvwe' mò'fis. Wo pwe' à sə wəp yi wəpə, nə kà pap də yi mòk nə̀ yi sə yù mandzə̀ Jisòs dzəm. ");
INSERT INTO yam_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Fana Bànabà və ŋgòtɛsə nà'. Yi jəŋ nà', nə jəŋ lo fa bohòŋgàa ntum sə wèŋ. Yi tsoho rɛŋsə fa yà'wèŋ mvəsə̀ Sol à yə Tà Jisòs mʉ mandzə̀ Dàmaskù, nə ye mvəsə̀ Tà à cèp bohònà' sə. Yi à tsə̀' fa yà'wèŋ də Sol a tsòho liŋ Jisòs mʉ Dàmaskù bə ŋàŋ, nə kà ŋwə̀ nəmòk sə̀' wəp. ");
INSERT INTO yam_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","À ye vɛ'nə fana Sol à ye mok bə yà'wèŋ mok mvwe' mò'fis, nə sə gihi lo Jòrosalèm, nə sə tsoho kɛ' ca liŋ Tà Jisòs. Yi à sə tsoho, nə kà ŋwə̀ nəmòk wəp lok. ");
INSERT INTO yam_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yi à cèep, nə sə bwinə ncèp bə bʉ̀ʉ Jus sə̀ wo à sə cèp ncèep lak Gris, fana wo sə lap mandzə̀ də wo zə yi. ");
INSERT INTO yam_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bʉ̀ʉ Jisòs sə wèŋ à rì vɛ'nə, fana wo jəŋ tsoŋ lo nà' sə Sìsàriyà, nə tum gesə lo yi ma Tasò. ");
INSERT INTO yam_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ànə ye vɛ'nə, fana bʉ̀ʉ cos sə̀ mvwe' nzeŋgòŋ Jùdiyà bə Galìli nə ye Sàmàriyà à tse' mok fifi. Coos yè'sə à sə gʉ lòmantombì, nə sə kuk bə bwìŋ sə̀'. Yè'sə à sə ye vɛ'nə bʉ̀ʉsə̀ Yòŋsə̀ nə̀ Rərɛŋ nə à sə tɛsə wo yi mvəsə̀ wo à sə cu, nə sə gʉ bum sə̀ yà' sə niŋ tsok də wo sə wəp Tà. ");
INSERT INTO yam_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pità à sə kɛ' gì nə̀bʉp. À ye nùmbu mòk, fana yi kɛ' lo ŋgòkə̀ cèpsə bʉ̀ʉ Jisòs sə̀ wo cu mvwe' lak səmok, wo to fo' də Lidà. ");
INSERT INTO yam_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","À kə̀ dzèŋ fo', yi ye ŋwə̀ nəmòk nə̀ liŋ nà'a Aniyàs. Ŋwə̀ ènə à sə kà ni' ye te' bʉ̀səgə̀, nə sə nooŋ mam mʉ kèhe lùumŋgòŋ fwame'. ");
INSERT INTO yam_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pità à to yi də Aniyàs, nə dʉk fa nà' də, <<Jisòs Krɛst gʉŋsə wu laŋ. Lòkok mʉtsə̀, nə lim kəà yò.>> Aniyàs lokok ca gu mʉtsə̀ sə̀' kɛ̀' mò'fis. ");
INSERT INTO yam_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bʉ̀ʉ Lidà bə sə̀ wo à sə cu mvwe' mbo' Saròŋ wèŋ pwe' à yə, nə kupsə, nə dzəm Tà. ");
INSERT INTO yam_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ŋwà nəmòk à ye mvwe' lak Jopà nə̀ liŋ ye də Tàbità. Yi à ye sə̀' ŋwà nə̀ yi à sə yù mandzə̀ Jisòs. Bʉ̀ʉ Gris wèeŋ togə̀ yi yàwo də Dokàs. Liŋ ye sə yà'a də ŋgap. Yi à sə gʉ̀ bə̀boŋ, nə sə tɛsə ŋgàa jìŋ, nə kà wò. ");
INSERT INTO yam_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","À ye ghà ànə, yiyaŋ à ko yi, yi kpʉ. Wo à cùk wes yi, wo kə noŋsə yi mvwe' rum mòk mʉtùhù co ma mʉzok vɛ'ɛ. ");
INSERT INTO yam_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopà bə Lidà ka sə̀sap yeŋ, fana ŋgàa yù mandzə̀ Jisòs sə̀ wo à ye Jopà yuk də Pità cu sə Lidà. Wo tumsə gesə bwìŋ ba də wo kə caŋ to Pità də kwəkwè' nà'a caŋ və wàp. ");
INSERT INTO yam_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pità à fʉ̀hʉ, nə lo bə yà'wèŋ. Yi à kə̀ dzèeŋ, fana wo jəŋ lo yi mvwe' rum nə̀ ma mʉbu nə. Bàa yepmfə sə̀ wo à ye fo' lòoŋfo', à və̀, nə sə warə ŋgʉ ni'ì Pità, nə sə niŋ tsoho fa yi cə̀ək sə̀ Tàbità à gʉ̀ fa wo ghà nə̀ yi à cu ntòŋwʉm sə. ");
INSERT INTO yam_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pità à fis bʉ̀ʉ sə̀ mʉ nda'à anə sə mbiŋ pwe', nə təəŋ bə tumfərə, nə sə lɛŋ Nwì. Yi à lɛŋ wes, fana yi bʉʉŋ kʉk vèŋ ni' Tàbità nə, nə dʉk də, <<Tàbità, lòkok mʉtsə̀!>> Tàbità muk lis. Mvəsə̀ yi à yə Pità, fana yi lokok cum mʉtsə̀. ");
INSERT INTO yam_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pità ko nà' bo, nə lokoksə nà' mʉtsə̀. Yi to bʉ̀ʉ sə̀ wo à dzəm, nə ye bàa yepmfə sə wèŋ, nə fa yà'wèŋ Tàbità nə ŋga yi mok ŋwəm. ");
INSERT INTO yam_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Bʉ̀ʉ sə̀ mvwe' lak Jopà pwe' à yuk yu yè'sə, fana bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ dzəm bohòTà Jisòs. ");
INSERT INTO yam_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pità à cu malì Jopà anə mʉnə nùumbu səmok. Yi à sə cu bə ŋgà' nəmòk nə̀ yi sèeŋgə̀ ŋgùp, liŋ yee də Saimʉ̀. ");
INSERT INTO yam_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ŋkum sojà nə̀ mvwe' lak Rumà mòk à ye mvwe' lak Sìsàriyà, liŋ yee də Kònilòs. Yi à tse' bòp sojàa sə̀ mvwe' lak Italì yi. ");
INSERT INTO yam_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yi à sə wəp Nwì nə̀bʉp. Yi à sə kùksə Nwì bə bʉ̀ʉ sə̀ mʉ nda'à yi pwe'. Yi à sə fa bʉ̀ʉ Jus wèŋ mbo wùriŋ, nə sə lɛŋ Nwì sə̀' nùumbu pwe'. ");
INSERT INTO yam_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","À ye nùmbu mòk ŋga nùm càsə maràŋ, fana yi ye yumok co lo vɛ'ɛ. Yi ye masinjà Nwì jəja vɛ'. Nà' to yi bə liŋ də Kònilòs. ");
INSERT INTO yam_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Wʉə ko yi, fana yi kʉk sɛɛŋ tse' nà', nə fek nà' də, <<A yà Tà?>> Masinjà Nwì nə dʉk fa nà' də, <<Nwì a yuk pìriyàa yo, nə ye fa mbo yòsə̀', nə tsərə̀ nə wu. ");
INSERT INTO yam_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Fana nə̀ ŋga'a nè'e, wu tumsə gesə bʉ̀ʉ mok mvwe' lak Jopà ŋgòkə̀ to ŋgà' nəmòk fo' nə̀ liŋ yee Saimʉ̀ Pità. ");
INSERT INTO yam_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yi nòmʉ nda'à Saimʉ̀ nə̀ yi no ŋgʉ ndzəp nə̀ ghaŋ, nə̀ yi sèeŋgə̀ ŋgùp nà'a.>> ");
INSERT INTO yam_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ànə ye vɛ'nə fana, masinjà Nwì nə̀ yi à tsòho fa Kònilòs bum yè'sə, nə lo gɛsə lo yuye. Kònilòs to ŋgàa fàak ye sə̀ mʉ nda'à yi bwìŋ ba. Yi to sojà ye mòk sə̀' nə̀ nà'a wəpgə̀ Nwì. ");
INSERT INTO yam_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Yi à tsòho fa yà'wèŋ yusə̀ yi anə ye sə pwe'fo', nə dʉk fa wo də yà'wèeŋ lo mvwe' lak Jopà anə. ");
INSERT INTO yam_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tsok à rɛŋ ŋga wo sə kʉəp lòJopà anə, fana Pità sə kok lo ye mʉ tu ndap ŋgòkə̀ lɛŋ pìriyà mbwa. À ye ŋga nùum co maràŋ. ");
INSERT INTO yam_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Njè à ya yi, fana yi sə dzəm də yi zʉ yumok. Wo ànə ka zʉzʉ sə̀ nto gʉ wes, fana yi sə ye yumok co lo vɛ'ɛ. ");
INSERT INTO yam_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Yi ye ŋga ntòbu mùhu nòto, fana yumok sə tsoŋ tesə mbwa. Yà' səsə co làba' nə̀ ghaŋ vɛ' ŋga wo kotse' tsə və̀ nà' bə ŋgʉŋgʉŋ sə̀ kwè sə pwe'. ");
INSERT INTO yam_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yusə̀ yà' à ye mʉnə làba' nə à ye nàamŋgòŋ pwe' bə nsàap bum sə̀ jì nɛ̀s co no bə swi wèŋ pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Yi yuk ŋga ŋgì ŋwə̀ nəmòk dʉk vèsə fa yi dʉk də, <<Pità, lòkok, nə sʉə zʉ nàam yè'sə.>> ");
INSERT INTO yam_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Fana Pità cep fəsə gesə ye dʉk də, <<Tà, anə kà vɛ'nə ye yuk, mʉ̀ ka yàm yu səmok sə̀ lʉ̀ʉk yo dzə̀gə̀ yà' dzə̀ə zʉ yuk.>> ");
INSERT INTO yam_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ŋgì ŋwə̀ nə cep sə̀mok də, <<Yusə̀ Nwì a gʉ̀ bòŋsə yà' mok laŋ fana wù kà də wu dzə yà' dʉk.>> ");
INSERT INTO yam_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yu yè'sə à gʉ̀ fis vɛ'nə kɛ̀' tɛ', fana wo jəŋ fəsə lo yu sə mʉbu anə sə̀mok. ");
INSERT INTO yam_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pità à sə mərə dʉk də nsàp lo nə̀ yi yə nè'nə sə nì tsə̀' fa yi yè'sə də yà lɛ, fana ŋga bʉ̀ʉ sə̀ Kònilòs tumsə sə kə̀ dzèŋ kə̀ ncùhù yi sə̀ laŋ. À ye ŋga wo à fe'rə mvwe' ndap Saimʉ̀ nə, nə riŋ nà'. ");
INSERT INTO yam_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Fana wo to fek gesə dʉk də, <<Ŋwə̀ nəmòok fɛnə ŋkʉ̀ìŋ nə̀ liŋ yee də Saimʉ̀ Pità àlɛ-ò?>> ");
INSERT INTO yam_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Wo à sə fek gèsə lòvɛ'nə ŋga Pità sə tsərə malì də yi rɛɛŋ nsàp lo nə̀ nà' kə̀ tàsə yi ènə ŋkuŋ. Yòŋsə̀ Nwì à to yi, nə tsok fa yi də, <<Bʉ̀ʉ səmok sə lap wu fenə bwìŋ tɛ'. ");
INSERT INTO yam_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lòkok mʉtsə̀, nə tsooŋ lo kə tseŋ wo. Wu gʉ̀ə wù kà də wu dzeeŋ ŋgòyù lòwo dʉk bʉ̀ʉsə̀ mʉ̀ dʉk wo mʉ də wo və.>> ");
INSERT INTO yam_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Fana Pità suhu lo, nə kə tseŋ wo. Yi dʉk fa yà'wèŋ dʉk də, <<Ŋwə̀ nə̀ wèŋ sə làap nə mʉ̀. Wèŋ və̀ da?>> ");
INSERT INTO yam_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bʉ̀ʉ sə wèŋ dʉk də, <<Kònilòs nə̀ yi ŋkum sojà tum ves yi. Yi ŋwə̀ nə̀ bə̀boŋ. Yi kùksəgə̀ Nwì, fana bʉ̀ʉ Jus pwe' rì yi bə lak lòoŋ də yi ŋwə̀ nə̀ bə̀boŋ. Masinjà Nwì mòk nə̀ rərɛŋ a tsə̀' yi də yi to və wu nda'à yi ya yi yuk-a yusə̀ wu nə tsok fa yi.>> ");
INSERT INTO yam_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Wo à cèp wes, Pità to nisə wo mʉ nda'à yi, bə yà'wèŋ nooŋnooŋ mbwa tsok rɛŋ. Tsok ànə rɛŋ, fana yi lokok, nə bɛ' mandzə̀ bə yà'wèŋ lo. Bʉ̀ʉ mok sə̀ mvwe' lak Jopà sə̀ wo à dzəm Jisòs à yù lòyi sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wo à gì tsok kə rɛŋ sə̀mok ŋkuŋ fana wo kə dzeŋ mvwe' lak Sìsàriyà anə. À kə̀ dzèŋ fo', wo ye Kònilòs bə njə̀njàaŋ ye nə ye ŋge' ntʉm ye sə̀ yi to yà'wèŋ, ŋga wo cu sə tək Pità. ");
INSERT INTO yam_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pità à sə nikok, fana bə Kònilòs kʉrə. Kònilòs gbʉ cum tsoŋ kù mantombìi nà' sə nze, nə zəm tu ŋgòkùksə nà'. ");
INSERT INTO yam_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pità lòkoksə nà' mʉtsə̀, nə dʉk fa nà' dʉk də, <<Lokok mʉtsə̀, mʉ̀ mègù sə̀' ŋwè co wù.>> ");
INSERT INTO yam_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mvəsə̀ yi à sə cèp malì bohònà' ntòfo', fana yi ni lo mʉ nda'à, nə ye bwìŋ ŋga wo rwiŋ cu mbwa wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Yi dʉk fa yà'wèŋ dʉk də, <<Wèŋ rì yàwèŋ sə̀' dʉk də, wu kʉk ja'a na bə nsàp mandzə̀ nə̀ bʉ̀ʉ Jus wèŋ kùksəgə̀ Nwì, fana ye də kaco ŋwə̀ Jus kə kɛ' ye ŋwè lakmvum ŋkɛ' yeŋ. Kaco bə nà' sə tòrə kɛ' ca nduk sə̀' yeŋ. Mègù dʉk də Nwì a rɛɛŋsə fa mʉ yi dʉk də kà də mʉ tsərə də ŋwə̀ nəmòok nə̀ co mʉ̀ dzeeŋ yi dzèeŋ dʉk. ");
INSERT INTO yam_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nà'a njo nə̀ wo to mʉ, mʉ̀ nə və̀ nə, nə kà dzèèŋ.>> Fana yi dʉk mok dʉk də, <<Mʉ̀ və̀ laŋ, wèŋ to mʉ da?>> ");
INSERT INTO yam_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Yi à fek vɛ'nə, Kònilòs cep də, <<Bə nùm nə̀ ntinə pwe' a nùumbu kwè, nə̀ à ye maràŋ sə̀' mvə̀k nə̀ ŋga'a vɛ' ŋga mʉ̀ cu mʉ nda'à mʉ̀ ŋgòlɛŋ pìriyà nə̀ wo lɛŋgə̀ nà' ŋga nùm càsə maràŋ nà'a. Mʉ̀ kʉk à, ŋwə̀ nəmòk tə kok nè' mantombìi mʉ̀. Yi ni tse' cə̀ək mok yà' sə ba'a nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yi to mʉ bə liŋ də, <Kònilòs.> Nə dʉk fa mʉ dʉk də, <Nwì a yuk pìriyàa yo, nə tsərə fa mbo yòlaŋ. ");
INSERT INTO yam_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ye də tumsə gesə lo ŋwə̀ nəmòk mvwe' lak Jopà yi to fa wu ŋwə̀ nəmòk fo' nə̀ wo togə̀ liŋ ye pwe' də Saimʉ̀ Pità. Yi ŋkʉ̀ìŋ. Yi nòmʉ nda'à Saimʉ̀ nə̀ yi fàkgə̀ bə ŋgùp, nə̀ ndap ye ŋgʉ ndzəp nə̀ ghaŋ.> ");
INSERT INTO yam_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yà'a yusə̀ mʉ̀ a tum gù bwìŋ sə̀' ntɛ̀ŋ də wu və sə. Wù nə gʉ̀ nə bə̀boŋ, nə və̀ nə sə̀'. Vès cu ŋga'a fɛɛŋ mantombìi Tà Nwì pwe'. Vès sə tək wù də wu tsoho fa ves yà pwe' sə̀ Nwì a tsə̀' fa wu də wu cep.>> ");
INSERT INTO yam_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Fana Pità yè ŋgòcèp dʉk də, <<Mʉ̀ rì tse' ŋga'a mok bə nə̀ zìnə dʉk də Nwìi jəgə̀ bwìŋ pwe' yəyərə̀.>> ");
INSERT INTO yam_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yi dʉk də, <<A ye-a sə̀' ndà lòoŋ nə̀ lak ŋgə̀ŋgàaŋ sə̀' fòlòoŋ ŋga yi wəp-a Nwì, nə sə gʉ yusə̀ yà'a kə̀kʉrə̀, fana ye də Nwì dzəm ŋgə̀ŋgàŋ. ");
INSERT INTO yam_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nwì à tsə̀' fa bʉ̀ʉ Izùrɛ ncèp nə̀ nje nə laŋ. Ncèp ye nə à ye Ntirə̀ nə̀ Bə̀boŋ də Jisòs Krɛst nə̀ yi Tà bohòbwìŋ pwe' a jə və̀ fifi. ");
INSERT INTO yam_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Wèŋ rì nsàap bum sə̀ yà' a ye mvwe' nzeŋgòŋ bʉ̀ʉ Izùrɛ wèŋ pwe' yà'a laŋ. Ghà nə̀ Jon à sə tsòho nzak bàptɛ à càa fana Jisòs yeto fàak ye mvwe' nzeŋgòŋ Galìli. ");
INSERT INTO yam_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yà' à ye bə liŋ Jisòs nə̀ mvwe' lak Nazàrɛ nə, mvəsə̀ Nwì à fa yi Yòŋsə̀ nə̀ Rərɛŋ nə ye ŋàŋ fana yi à kɛ'kɛ' càa, nə sə gʉ bə̀boŋ, nə sə gʉŋsə lo bʉ̀ʉ sə̀ wo à cu ndzə bohòŋkum ze', bʉ̀ʉsə̀ Nwì ànə ye bə nà'. ");
INSERT INTO yam_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Bum sə̀ yi à gʉ̀ mvwe' laak bʉ̀ʉ Jus, nə ye Jòrosalèm pwe'fo', vès à yə yà' bə lis avès. Wo à tɛ'lə yi mʉ ntə̀əŋ, nə zə yi. ");
INSERT INTO yam_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Fana nùmbu nə̀ tɛ' à dzèeŋ, Nwì gʉ yi lokok mvwe' kpʉ. Nwì à gʉ̀ də yi niŋ fa bwìŋ ni' ye. ");
INSERT INTO yam_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Yi à ka bohòbwìŋ lòoŋ sə̀' yəəŋ. Yi à yəəŋ mègù bohòvès sə̀ Nwì ànə swek fis ŋgòyə bum yè'sə bə lis avès. Ghà nə̀ yi a lòkok mvwe' kpʉ nə, vesiwèŋ à zʉ zʉzʉ, nə no nəno mvwe' mò'fis. ");
INSERT INTO yam_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Fana yi Jisòs nə à dʉk ves dʉk də vèes tsoho lo fa bwìŋ Ntirə̀ nə̀ Bə̀boŋ nə sə̀'. Nə sə rɛŋsə fa bwìŋ dʉk də a yi nə̀ Nwì a fa yi ŋàaŋ də yi sak bʉ̀ʉ sə̀ wo à kpʉ lòlaŋ, nə ye sə̀ wo cu ntòŋwəm pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bʉ̀ ŋgàa tsòhòbum Nwì sə̀ wo à ye njamòk tsòho nə sə kum liŋ ye. Wo à dʉk də ŋwə̀ nə̀ nà'a dzəm-a bohònà' pwe', Nwìi nə swifa ŋgə̀ŋgàŋ bʉp ye bə ŋàaŋ sə̀ yà' cu ndzənə liŋ ye sə.>> ");
INSERT INTO yam_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mvəsə̀ Pità à sə cèp vɛ'nə, fana Yòŋsə̀ nə̀ Rərɛŋ nə və bohòbʉ̀ʉ sə̀ wo à sə yu'rə ncèp nə̀ Pità à sə cèep nə pwe'. ");
INSERT INTO yam_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bʉ̀ʉ Jus sə̀ wo à dzəm bohòJisòs sə̀ wo à və̀ bə Pità wèŋ mvwe' lak Jopà à mərə nə̀bʉp. Wo à sə mərə də Nwì fa bʉ̀ lakmvum wèŋ Yòŋsə̀ nə̀ Rərɛŋ nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Njo nə̀ wo à yuk mvəsə̀ yà'wèŋ à sə cèp ncèep lak mok sə̀ wo kà yà' yukgə̀ nə sə kùksə Nwì. Fana Pità cep dʉk də, ");
INSERT INTO yam_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","<<Bʉ̀ yè'e wèŋ tse' Yòŋsə̀ nə̀ Rərɛŋ nə sə̀' co vesùwèŋ à tse'. Aco ŋwə̀ nəmòk dzeeŋ də wo kà wo bə ndzəp bàptɛsə̀ à?>> ");
INSERT INTO yam_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Fana yi fa ŋàŋ də wo bàptɛsə yà'wèŋ bə liŋ Jisòs Krɛst. Anə geŋ, wo dʉk fa Pità də bə yà'wèeŋ cum mʉnə nùumbu mok ŋkuŋ. ");
INSERT INTO yam_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yà' à yuhu lòbohòŋgàa ntum Jisòs bə bʉ̀ʉ sə̀ wo à dzəm Jisòs sə mvwe' nze Jùdiyà pwe' də bʉ̀ lakmvum wèŋ a dzəm ncèp Nwì nə sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Fana mvəsə̀ Pità à lo mʉ Jòrosalèm, bʉ̀ʉ mok sə cep də yi ka bə̀boŋ gʉ. À ye bʉ̀ʉ sə̀ wo à sə dzəm də tse'ŋga wo kom fa bʉ̀ lakmvum wèŋ tu mbəmbam ŋkuŋ wo bʉʉŋ bʉ̀ʉ cos yà'a. ");
INSERT INTO yam_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Wo sə dʉk də, yi a kə̀ nòoŋ nda'à nsàap bʉ̀ʉ yè'sə, nə zʉ be'lə zʉzʉ bə yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pità ye ŋga'a ŋgòtsòho fa wo mvəsə̀ yà' a yèto bə yusə̀ yà' a ye pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Yi tsok dʉk də, <<Mʉ̀ à cu ŋgògʉ̀ pìriyà mvwe' ntʉm lak Jopà, fana mʉ̀ ye lo. Mʉ̀ ye ŋga yumok sə tsə mʉbu yà' səsə co làba' nə̀ ghaŋ vɛ'ɛ ŋga wo kotse' tsə yà' bə ŋgʉŋgʉŋ sə̀ kwè sə. Yà' à kə̀ təəŋ kʉəp ŋgʉ ni'ì mʉ̀. ");
INSERT INTO yam_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mʉ̀ kʉk bʉrə yà' bə̀boŋni. Mʉ̀ ye ŋga nsàap nàamŋgòŋ pwe' bə nsàap bum sə̀ jì nɛ̀s co no bə swiŋ wèŋ pwe'fo' cu ca. ");
INSERT INTO yam_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Fana mʉ̀ yuk ŋga ŋgì ŋwə̀ nəmòk dʉk vèsə fa mʉ dʉk də, <Pità, lòkok nə sʉə zʉ nàam yè'sə.> ");
INSERT INTO yam_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mʉ̀ cep fəsə gesə lo dʉk də, <Tà, anə kà vɛ'nə ye yuk. Yumok sə̀ vès rì də wo dzə̀gə̀ yà' dzə̀ə ka mʉ cùhu mʉ̀ yàm ni yuk.> ");
INSERT INTO yam_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ŋgì ŋwə̀ nə cep vesə fe'lə mʉbu anə sə̀mok dʉk də, kà də mʉ dzə yusə̀ Nwì a gʉ̀ bòŋsə yà' laŋ dʉk. ");
INSERT INTO yam_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Yà' à gʉ̀ fis vɛ'nə kɛ̀' tɛ' fana wo jəŋ fəsə lo yà' mʉbu anə sə̀mok. ");
INSERT INTO yam_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","<<À ye sə̀' ghà nà'nə, bwìŋ kə dzeŋ mvwe' ndap àm nə̀ mʉ̀ cugə̀ fo'. Wo à ye tu awo bwìŋ tɛ'. Wo ànə tumsə vesə bʉ̀ʉ yè'sə mvwe' lak Sìsàriyà. ");
INSERT INTO yam_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yòŋsə̀ nə tsok fa mʉ dʉk də, kà də mʉ tse' məmərə̀ ŋgòyù lòwo dʉk. Bwema sə̀ mvwe' lak Jopà sə̀ wo ntùŋfu yè'e à yù lòmʉ Sìsàriyà anə. Vesiwèŋ à lònda'à Kònilòs vès pwe'. ");
INSERT INTO yam_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yi tsoho fa ves mvəsə̀ yi a yə masinjà Nwì ŋga nà' tə mʉ nda'à yi, nə dʉk fa yi dʉk də, <Tumsə gesə lo ŋwə̀ nəmòk mvwe' lak Jopà yi kə to fa wu ŋwə̀ nəmòk fo' nə̀ liŋ ye pwe' də Saimʉ̀ Pità. ");
INSERT INTO yam_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yi nə kə tsok fa wu ntirə̀ nə̀ wu nə tse' lùŋ weŋ ndap yòlòoŋ.> ");
INSERT INTO yam_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Fana mʉ̀ anə sə yeto ŋgòcèp jo ntɛ̀ŋ, Yòŋsə̀ nə̀ Rərɛŋ nə və bohòwo sə̀' mvəsə̀ nà' à və̀ bohòvesùwèŋ taaŋ yà'a. ");
INSERT INTO yam_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Fana mʉ̀ tsərə fəsə yusə̀ Tà à cèp dʉk də, <Jon à bàptɛsə bwìŋ bə ndzəp, fana wo nə baptɛsə weŋ bə Yòŋsə̀ nə̀ Rərɛŋ nə.> ");
INSERT INTO yam_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nòjəja də Nwì à fa bʉ̀ʉ sə̀ wo ka bʉ̀ʉ Jus yeŋ yè'sə wèŋ sə̀' nsàp fəfa nə̀ vesùwèŋ ànə dzəm Tà Jisòs Krɛst yi fa ves nà'a. Anə ye-a vɛ'nə, mʉ̀ ye yàm yè'sə ndà nə̀ co mʉ̀ gʉ də Nwìi kà yuye gʉ̀ ɛ?>> ");
INSERT INTO yam_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bʉ̀ʉ cos sə ànə yuk wes yu yè'sə, fana wo teŋsə ŋgòcèp də Pità a gʉ̀ bʉp. Wo kuksə Nwì də, <<Ye də Nwì a fa bʉ̀ lakmvum mandzə̀ ŋgòkupsə ntʉm, nə luŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bʉ̀ʉ sə̀ wo à dzəm Jisòs à carə sam bʉ̀ʉ ŋgə' nə̀ nà' à lòkok ghà nə̀ wo à zə Stefè nà'a. Mok à ca lòmvwe' sə̀sap co mvwe' nzeŋgòŋ Fònisiyà bə Sɛprònə ye Antiyòk. Wo sə tsoho fa lo gu ncèp nə̀ Jisòs nə bohòbʉ̀ʉ Jus wèŋ woòwo. ");
INSERT INTO yam_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Fana bʉ̀ʉ mok mʉtsətsə'rə wo sə̀ mvwe' lak Sɛpròbə Sìrinì à lòmvwe' lak Antiyòk, nə kə tsoho fa bʉ̀ lakmvum wèŋ Ntirə̀ nə̀ Bə̀boŋ nə̀ nà' sə kùm liŋ Tà Jisòs. ");
INSERT INTO yam_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ŋàaŋ Tà à ye bə yà'wèŋ, fana bʉ̀ʉ sə̀ wo ànə dzəm Ntirə̀ nə, nə bʉʉŋ və bohòTà, à yam wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Bum yè'sə à yuhu lòmvwe' cos nə̀ Jòrosalèm, fana wo tumsə lo ŋwə̀ nəmòk nə̀ wo to yi də Bànabà mvwe' lak Antiyòk anə. ");
INSERT INTO yam_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Yi à kə̀ dzèŋ fo', nə ye mvəsə̀ Nwì a nì bòvə̀m ye bohòyà'wèŋ, fana yi kwa, nə tipsə gʉŋsə wo də yà'wèeŋ təəŋ mali gʉgʉŋ nə ye zìnə bohòTà Jisòs bə ntʉm yà' pwe'. ");
INSERT INTO yam_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bànabà à ye ŋwə̀ nə̀ bə̀boŋ. Yi à rwiŋ bə Yòŋsə̀ nə̀ Rərɛŋ nə, nə nə sə naaŋ tu bohòJisòs ŋkʉ̀ʉŋ sə̀'. Bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ à kupsə, nə dzəm bohòTà Jisòs. ");
INSERT INTO yam_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Anə geŋ Bànabà ye'e lo mvwe' lak Tasòŋgòkə̀ làp Sol. ");
INSERT INTO yam_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Yi à kə̀ yə nà', yi jəŋ fəsə və nà' Antiyòk anə. Bʉ̀ʉ sə̀ ba yè'sə à sə cu bə bʉ̀ʉ sə̀ mʉ cos sə, nə sə yə'rə wo ŋkà'ŋgòŋ mò'fis bə tu. Kwe' bʉ̀ nə̀ wo à sə yə'rə nə à ye nə̀ ghaŋ. Wo à yèto ŋgòto fa ŋgàa yù mandzə̀ Jisòs wèŋ liŋ sə̀ də Krətèŋ yè'e mvwe' lak Antiyòk anə. ");
INSERT INTO yam_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","À ye sə̀' co mvə̀k ànə fana ŋgàa tsòhòbum Nwì mòk nə̀ wo sə cèp bum sə̀ Nwì a tsə̀' fa wo à ye'e Jòrosalèm, nə tsoŋ lo sə Antiyòk anə. ");
INSERT INTO yam_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mòk à ye fo' nə̀ liŋ ye Àgabòs. Yi à cèp bə ŋàaŋ sə̀ à fa yi Yòŋsə̀ nə dʉk də, njè nə̀ bʉp sə və̀ə. Nà'a nə ko nzeŋgòŋ nə lòoŋfo'. (Njè nə à ko ghà nə̀ Kladiyòs à ye ŋkum yi nà'a.) ");
INSERT INTO yam_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ŋgàa yù mandzə̀ Jisòs à cu, nə dzəm mvwe' mò'fis də, ndàaŋwè pwe' jəŋ və yu ye mvəsə̀ yi tse' ŋga wo tɛsə gesə lo bwema awo sə̀ wo Krətèŋ sə̀ yà'wèŋ cu Jùdiyà. ");
INSERT INTO yam_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Wo ànə gʉ vɛ'nə, nə tumsə Bànabà bə Sol də yà'wèeŋ jəŋ lo fa bʉ̀ ŋkwàha bʉ̀ʉ sə̀ mʉ cos mbàam sə. ");
INSERT INTO yam_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","À ye sə̀' co mʉnə mvə̀k nà'nə, fana Herònə̀ yi à ye ŋkum mvwe' lak Izùrɛ yeto ŋgòfa bʉ̀ʉ sə̀ mʉ cos sə wèŋ ŋgə'. ");
INSERT INTO yam_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yi à gwɛ̀' cok tu Jem moma Jon bə fèk. ");
INSERT INTO yam_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yi ànə ye də bʉ̀ʉ Jus wèŋ kwa, fana yi ghaha wesə, nə ko Pità. Yè'sə ànə ye ghà nə̀ wo à sə zʉ ŋkà'a brɛd jì yis yà'a. ");
INSERT INTO yam_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mvə̀'nə̀ Heròànə ko nà', fana wo kə gesə yi mʉ ndapndzəmə̀. Yi fihi sojà wèŋ kwè, kwè, sə̀ kɛ̀' kwè də wo sə kʉk nà'. Heròà sə dʉk də wo nə sak nzak nà' mʉtsətsə'rə bwìŋ ghà nə̀ ŋkà'a Pasobà nə càa. ");
INSERT INTO yam_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pità à sə cu mʉ ndapndzəmə̀ anə, fana bʉ̀ʉ sə̀ mʉ cos à sə lɛŋ fa yi pìriyà bohòNwì bə nə̀ zìnə àwo pwe'. ");
INSERT INTO yam_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nə̀ ndzəmə̀ nə̀ Heròà sə dʉk də tsok rɛŋ fana wo kə sak nzak Pità à ye, wo tsooŋ noŋsə nooŋ Pità nə bə kwaŋ ba. Yi sə nooŋ mʉtsətsə'rəə ŋgàa kʉ̀k ŋgàa ndapndzəm sə̀' ba. Mok à təəŋ lok ncùu ŋka' ndapndzəm sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Anə geŋ, masinjà Tà Nwì və fo'. Marɛŋ mòk rɛŋ mʉ ndapndzəmə̀ anə. Masinjà Nwì nə kum tsə'rə Pità mʉ ŋkambə̀hə. Nà'a yəəŋ, fana yi tsok nà' dʉk də nà'a lokok mʉtsə̀ jwè. Yi à dʉk vɛ'nə ntɛ̀ŋ, kwaŋ sə̀ wo à tsòoŋ Pità bə zeŋ sə fiiŋ. ");
INSERT INTO yam_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Masinjà Nwì nə dʉk də nà'a swi' tsə'rə korə nà' bə kùuŋgùp nà' bə̀boŋ. Pità ànə gʉ wes vɛ'nə, fana yi dʉk fe'lə fa nà' də nà'a ni cə̀k, nə̀ mʉ ŋkwɛ̀ŋ nə və bə nà'a lo. ");
INSERT INTO yam_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pità yuŋ nà', bə nà' tesə lo mʉ ndapndzəmə̀ anə. Yi kà sə rɛɛŋ də yusə̀ masinjà Nwì sə gʉ̀ sə zìnə rɛɛŋ. Yi à sə dʉk ye də, kàmòk yi sə yə ŋgwàaŋ lo. ");
INSERT INTO yam_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bə nà' à dzèŋ mvwe' ntòmbi ŋgàa kʉk ŋgàa ndapndzəm, nə casə nà'nə, nə kə dzeŋ fe'lə mvwe' ntòmbi àwo nə̀ ba. Wo à casə yà'sə, nə kə dzeŋ mvwe' ncùu ŋka' sə̀ wo à gʉ̀ yà' bə ntɛŋ, sə̀ yà'a ŋgòni lòsə ntòlak. Ŋka' sə à muhu bə bo awo. Wo ca tesə lo. Wo à sə yù tsə lòmandzə̀ mòk fo', fana masinjà Nwì nə me'rə Pità fo'. ");
INSERT INTO yam_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nà'a ghà nə̀ Pità à rɛɛŋ bə bum yè'sə, nə dʉk də, <<Mʉ̀ rì nə̀ ŋga'a də yu yè'sə zìnə. Tà Nwì a tumsə masinjà ye, yi kə fis mʉ ndzə bohòHeròbə bʉ̀ʉ Jus wèŋ. Mʉ̀ swìrə yusə̀ wo a sə dʉk də wo nə gʉ mʉ.>> ");
INSERT INTO yam_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Yi à rì bum yè'sə vɛ'nə, fana yi ye'e lo nda'à ma Jon Mak nə̀ liŋ ŋwà nə də Mèri. À ye ŋga bwìŋ à kə̀ benə fo' wùriŋ, nə sə lɛŋ pìriyà. ");
INSERT INTO yam_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pità à kùm ncù ma sə mbiŋ, fana mʉwà'ŋgwɛ̀ŋ mòk nə̀ liŋ yee Rudà à dzəm, nə və. Mʉwà'ŋgwɛ̀ŋ ènə fàkgə̀ fo'. ");
INSERT INTO yam_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Yi à yuk rì ŋgì Pità, nə kwa vɛ'ɛ nə̀bʉp. Yi kà ncùu sə mok mùk, nə caŋ bwi foho lo kə tsok fa bwìŋ dʉk də Pità tə sə mbiŋ. ");
INSERT INTO yam_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wo yak yi dʉk də nà' sə ŋaŋa àlɛ. Yi cep ghaha mali fo' də yusə̀ yi dʉk sə zìnə. Fana wo dʉk də, kàmòk a ca masinjà Nwì nə̀ yi kʉ̀kgə̀ Pità nə. ");
INSERT INTO yam_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ànə ye vɛ'nə Pità sə kum mali ncùu sə fo'. Ànə geŋ wo kə muk yà'. Wo à yə yi, wo mərə nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Yi gʉ bo ye ŋgòtsə̀' wo dʉk də yà'wèeŋ cum gəe'. Yi tsoho rɛŋsə fa yà'wèŋ mvəsə̀ Tà fis yi mʉ ndapndzəmə̀ anə. Yi dʉk də wo kə tsok fa Jem bə bʉ̀ʉ mok sə̀ wo à dzəm Jisòs sə pwe'. Yi dʉk wes vɛ'nə, yi ye'e lo mvwe' səmok. ");
INSERT INTO yam_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tsok à rɛŋ, ŋgàa kʉ̀k ŋgàa ndapndzəm sə wèŋ à jip nsàp nə̀ wù kà fʉ̀k. Wo sə fe'rə ni' awo dʉk də, Pità nə yè'sə fò? ");
INSERT INTO yam_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heròà fa ŋàŋ də wo lap nà'. Wo lap, nə kà yi yə. Yi to ŋgàa kʉ̀k ŋgàa ndapndzəm sə, nə fek wo bum yè'sə. Yi ànə fek wes yà'wèŋ, fana yi fa ŋàŋ də wo zə yà'wèŋ. Yà' à càa, fana Heròye'e me'rə Jùdiyà, nə tsoŋ lo kə cumtse' mok Sìsàriyà. ");
INSERT INTO yam_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ntʉm à sə jòk Heròbohòbʉ̀ʉ Tayà bə Sidòŋ nə̀bʉp, fana wo benə mvwe' mò'fis, nə lo ŋgòkə̀ yə Herònə. Wo à gʉ̀, nə ko to ntòŋkərə̀ ŋwə̀ nəmòk nə̀ liŋ ye də Blatòs. Blatòs nə à ye ŋgà fàk nə̀ ghaŋ mʉ nto' anə yi. Wo lo ŋga'a bohòHerò, nə kə dʉk fa nà' də bə yà'wèeŋ gʉ fifi. Wo à gʉ̀ vɛ'nə bʉ̀ʉsə̀ zʉzʉ sə̀ mvwe' lak awo à sə və̀ mègù mvwe' lak ŋkum ànə. ");
INSERT INTO yam_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","À kə̀ dzèŋ nùmbu mòk nə̀ wo à cok fis, fana Heròà ni cə̀ək ŋkum ye, nə cum mʉnə kapràk ye, nə sə cep bohòbʉ̀ʉ yè'sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Wo à yuk, wo gurə dʉk də, <<Sə cep yè'sə nwì mòk, ka ŋwè yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Masinjà Tà Nwì ləp mak tsooŋ Herònə fo' ghà nə, bʉ̀ʉsə̀ wo à kùksə yi co Nwì, yi kà dzèèŋ. Ŋgìŋgòà lum yi tə̀tè yi kpʉ ŋga dzèŋ nùumbu tàŋ. ");
INSERT INTO yam_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ncèp nə̀ Nwì nə à sə kùk lòmalì mantombì. ");
INSERT INTO yam_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bànabà bə Sol à mèsə fàak awo, nə me'rə Jòrosalèm, nə bwi foho lo fe'lə Antiyòk. Wo à lòbə ŋwə̀ nəmòk nə̀ wo to yi də Jon Mak wèŋ bəbɛ'. ");
INSERT INTO yam_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bwìŋ à ye mvwe' cos nə̀ mvwe' lak Antiyòk sə̀ wo à tse' fàak sə̀ co ŋgàa tsòhòbum Tà Jisòs, bə cicàa sə̀ wo ŋgàa yə'rə̀ bwìŋ ncèp Jisòs. Liŋ mok à ye Bànabà bə Saimʉ̀. (Wo à sə to yi mok də, Najà.) Mòk à ye Lòsiyònə̀ lak yee Sìrinì, mòk ye Manàŋ nə̀ yi à kuk ndzə bohòŋkum Herò, nə ye fe'lə Sol. ");
INSERT INTO yam_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ghà nə̀ wo à sə dzə̀ zʉzʉ ŋgòkùksə Tà, fana wo yuk ŋga Yòŋsə̀ nə̀ Rərɛŋ nə dʉk fa wo dʉk də, <<Wèeŋ cok noŋsə fa mʉ Bànabà bə Sol zok, bʉ̀ʉsə̀ mʉ̀ a to wo, nə fa wo fàak mok sə̀ wo nə fak fa mʉ.>> ");
INSERT INTO yam_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wo à dzə̀ malì zʉzʉ, nə sə lɛŋ pìriyà fana, wo naaŋ fa wo bo, nə se wo də wo lo. ");
INSERT INTO yam_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mvə̀'nə̀ Yòŋsə̀ nə̀ Rərɛŋ nə à tumsə Bànabà bə Sol fana wo tsoŋ lo sə Sèlusiyà, nə kə ni ŋgwes, nə lo mvwe' nze Sɛprò. ");
INSERT INTO yam_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Wo ànə kə dzeŋ mvwe' lak Sàlamì fana wo tsoho kɛ' ca ncèp Nwì fo' mʉnə ndaap pìriyàa bʉ̀ʉ Jus wèŋ. Jon Mak à ye sə̀' bə yà'wèŋ ŋgòtɛsə wo. ");
INSERT INTO yam_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wo à gìhi lòtə̀tè wo kə dzeŋ Pafòs. Wo à kə̀ tsèŋ ŋgà mfim mòk fo' nə̀ liŋ yee də Bàjisòs. Ŋwə̀ ènə à ye ŋwə̀ə Jus, yi sə bòrə bwìŋ də yi ŋgà tsòhòbum Nwì. ");
INSERT INTO yam_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ŋgà mfim nə à ye ŋwə̀ govənònə̀ yi à ye mvwe' lak yà'sə yi nə. Liŋ govənònə à ye də Sejìs Palìs. Yi tse' ŋkərə̀ nə̀bʉp. Ŋwə̀ nə̀ ghaŋ ènə à dzəm ŋgòyuk ncèp Nwì fana, yi to Bànabà bə Sol də wo və. ");
INSERT INTO yam_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Wo à və̀ə, fana ŋgà mfim nə kà ncèp nə̀ Nwì nə dzəm, nə sə lap də Sejìs Palìs nə kà ncèp awo nə sə̀' dzəm. Wo togə̀ Bàjisòs nə də Elemà (ŋgà fe ŋgam) vɛ'nə bə ncèep bʉ̀ʉ Gris. ");
INSERT INTO yam_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","À ye vɛ'nə, fana Sol nə̀ liŋ ye mok də Pol, à kʉ̀k tse' nà' bə lis rap rap. Pol nə à rwiŋ bə Yòŋsə̀ nə̀ Rərɛŋ. ");
INSERT INTO yam_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Yi dʉk fa ŋgà gʉ̀ bum mfim nə də, <<Wù mo ze', yusə̀ yà'a bə̀boŋ pwe' wu bɛ̀ŋgə̀ yòyà' bɛ̀ŋnə. Və̀əm yo yà'a rwiŋ cu gù ca nsàap ŋkərə̀ə sə̀ bʉp nə ye ŋkʉ̀ì'. Wu lapgə̀ bə ŋàaŋ yo pwe' də wu gʉ gorə bʉpsə mandzə̀ nə̀ Tà nə. ");
INSERT INTO yam_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bo Nwìi nə jwɛŋ wu ŋga'a yè'sə. Lis nə loho wu, wù cumtse' ŋga wù sə kà marɛŋ yə.>> Yi ànə cep wes vɛ'nə ntɛ̀ŋ, Elemà ye ŋga yumok lok yi lis co mbàk vɛ'ɛ. Yi sə jam lap kɛ' ca fo' də ŋwə̀ nəmòk ko yi bo. ");
INSERT INTO yam_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mvəsə̀ govənònə à yə vɛ'nə fana yi dzəm bohòJisòs. Ànə ye vɛ'nə yi mərə bə nsàap yusə̀ wo à sə yə'rə fa bwìŋ bə liŋ Tà sə wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol bə bʉ̀ʉ ye sə wèŋ à ye'e Pafòs anə, nə gi bə ŋgwes kə dzeŋ mvwe' lak Pegà, nə̀ nà'a mvwe' nze Pàmfiliyà. Jon Mak à mè'rə wo fo', nə bwi foho lo Jòrosalèm. ");
INSERT INTO yam_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wo à càsə malì Pegà, nə kə dzeŋ Antiyòk nə̀ mvwe' nzeŋgòŋ Pìsidiyà. Nùmbu dzə̀ à ye, wo lo kə ni cum mʉnə ndap pìriyà bʉ̀ʉ Jus. ");
INSERT INTO yam_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ghà nə̀ ŋwə̀ nəmòk ànə taŋ wesə ŋwàk lʉ̀ʉk Musì, bə yusə̀ ŋgàa tsòhòbum Nwì wèŋ à còom fana bʉ̀ʉ sə̀ mantombì mʉnə ndap pìriyà nə wèŋ à tum ŋwè dʉk də nà'a kə ye Bànabà bə Pol. Wo də yi kə dʉk fa yà'wèŋ dʉk də, yà' co bwema, tse'-a ncèp mòk nə̀ bə̀boŋ co wo tipsə bwìŋ bə zeŋ àlɛ', yà' və kə tsok fa wo. ");
INSERT INTO yam_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol à lòkok mʉtsə̀, nə gʉ bo də wo cum gəe', nə sə cep dʉk də, <<Wèeŋ yu'rə fa mʉ, bʉ̀ʉ am bwe Izùrɛ, nə ye wèŋ mok sə̀ wèeŋ kùksəgə̀ Nwì. ");
INSERT INTO yam_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nwì nə̀ bʉ̀ʉ Izùrɛ yè'e kùksəgə̀ yi, à cokfis tàcicii avès, nə gʉ yà'wèŋ yam maŋgəŋgèŋ ghà nə̀ wo ànə ye ŋkʉ̀ìŋ mvwe' nze Ijìp. Nwì à jə fis wo mvwe' nzeŋgòŋ Ijìp anə bə ŋàaŋ ye. ");
INSERT INTO yam_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Mʉnə lùumŋgòŋ hum kwè, yi sə ye bə yà'wèŋ ŋgəà. ");
INSERT INTO yam_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Yi à lə̀sə bʉ̀ ŋkəŋkum sàmba bə lak awo mvwe' nze Kanà. Yi à gʉ̀ bʉ̀ʉ ye wèŋ tse' nze nə fo' mok wo. Bum yè'sə a jə co lùumŋgòŋ ŋkʉ̀ kwè-bə-hum tàŋ. ");
INSERT INTO yam_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ghà ànə à càa, yi fa yà'wèŋ bʉ̀ʉ sə̀ ŋgòtəəŋ mantombì wo tə̀tè kə dzeŋ mvə̀k nə̀ ŋgà tsòhòbum Nwì nə̀ liŋ ye Samwè à ye sə̀' ŋwə̀ nə̀ mantombì. ");
INSERT INTO yam_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","<<Ànə geŋ, wo fek Samwè nə dʉk də wo dzəm ŋkum, fana Nwì fa wo Sol də nà'a ye ŋkum nə nà'. Sol nə à ye ŋkum mʉnə lùumŋgòŋ hum kwè. Yi à ye mo Kis nə̀ mvwe' bòp lak Benjamè. ");
INSERT INTO yam_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ghà nə̀ Nwì ànə susə yi fana Nwì koksə bwi Devìd ŋkum àwo. Nwì à cèp bə liŋ Devìd sə dʉk də, <Mʉ̀ yə də Devìd nə̀ yi mo Jesìi nsàp ŋwə̀ nə̀ mʉ̀ dzəm nə. Yi ŋwə̀ nə̀ yi nə sə gʉ yusə̀ mʉ nə sə dzəm ŋgògʉ̀ pwe'.> ");
INSERT INTO yam_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Devìd nə, Nwì à fis və̀ Jisòs ŋgà lùŋsə̀ bʉ̀ʉ Izùrɛ wèŋ bohòŋgwì bʉ̀ ye nə. Nwì ànə kak tes vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ŋkuŋ Jisòs sə və ŋga Jon à tsòho to fa bʉ̀ʉ Izùrɛ wèŋ pwe'fo' dʉk də yà'a kupsə, nə bwi fa bʉp awo ŋkwɛ̀ŋ, nə baptɛsə. ");
INSERT INTO yam_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon à sə kʉəp ŋgòmèsə fàak ye sə fana, yi fek bʉ̀ʉ sə wèŋ dʉk də, <Wèŋ sə tsəm də mʉ yè'sə ndà? Mʉ̀ ka ŋwə̀ nə̀ wèŋ sə tək nə yeŋ. Yi sə və maŋkwɛ̀ŋ. Mʉ̀ ka kʉrə ŋgòfweŋ fa yi kùuŋgùup ye kʉrə.> ");
INSERT INTO yam_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","<<Bwema am wèŋ sə̀ wèeŋ ŋgwì bʉ̀ʉ Abràham bə wèŋ sə̀ wèŋ ka bʉ̀ʉ Jus yeŋ sə̀ wèeŋ kùksəgə̀ Nwì. Ncèp lùŋ ènə sə və̀ yè'sə bohòvesùwèŋ. ");
INSERT INTO yam_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bʉ̀ʉ sə̀ wo à ye mvwe' lak Jòrosalèm bə ŋkwàha bʉ̀ awo à ka riŋ də ŋwə̀ ànə ŋgà tətɛsə̀ bwìŋ riŋ. Nùumbu dzə̀ à sə ye pwe', wo sə taŋ ncèp nə̀ ŋgàa tsòhòbum Nwì à còm bə liŋ ye, nə kà sə̀' sə rɛɛŋ. Ànə ye-a sə̀' vɛ'nə fana wo à gʉ̀ ncèp ŋgàa tsòhòbum Nwì sə wèŋ ye zìnə mvəsə̀ wo à zə yi sə. ");
INSERT INTO yam_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wo ànə ka njo nə̀ co wo zə yi bə zeŋ sə̀' tse' fana, wo lɛŋ mali Palè ŋgòzə nà'. ");
INSERT INTO yam_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Wo à gʉ̀ wes yusə̀ ŋwàk Nwì à sə cèp bə liŋ ye pwe' fana, wo ki tsoŋ yi mʉ ntə̀əŋ anə, nə tuuŋ yi. ");
INSERT INTO yam_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ànə geŋ, Nwì lokoksə yi mvwe' kpʉ. ");
INSERT INTO yam_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mʉnə nùumbu ŋkʉ̀ʉŋntɛ̀ŋ yi à yəəŋ bohòbʉ̀ʉ sə̀ bə yà'wèŋ à gì yè jə mvwe' nzeŋgòŋ Galìli nə kə dzeŋ Jòrosalèm. Nə̀ ŋga'a nè'e, wo mok bʉ̀ʉ sə̀ wo sə tsoho fa bwìŋ yusə̀ wòà yə. ");
INSERT INTO yam_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","<<Vèes ye' ŋgòtsə̀' fa weŋ Ntirə̀ nə̀ Bə̀boŋ nə də, yusə̀ Nwì ànə kak fa tàcici avès dʉk də yi nə gʉ sə, yi gʉ fa yà' bohòvesùwèŋ sə̀ a ŋgwì bʉ̀ àwo. Yusə̀ yi à gʉ̀ʉ sə də, yi a lòkoksə Jisòs. Yà' cu ndzənə ŋwàk Sàam mbʉ̀p ba vɛ'nə. A nja dʉk də, <Wu mo àm, mʉ ntinə bohòwù Tɛ̀' yò.> ");
INSERT INTO yam_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yusə̀ Nwì ànə cep bə mvə̀'nə̀ yi à lòkoksə nà' mvwe' kpʉ də nà'a nə kà mok bi yuk sə də, <A zìnə də mʉ nə se li wu bə bum sə̀ rərɛŋ sə̀ mʉ̀ à kàk tɛ̀' yòDevìd sə.> ");
INSERT INTO yam_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Mvəsə̀ yi sə cep fe'lə mʉmvwe' nəmòk ndzənə ŋwàk Sam nə dʉk də, <Kaco wu nə me'rə ŋgà fàk yònə̀ yi yukgə̀ dʉk yòbə̀boŋ də yi bi yeŋ.> ");
INSERT INTO yam_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","A rì də Devìd bə tu ye ànə fak bohòNwì mvəsə̀ Nwì à dzəm njamòk anə, nə kpʉ, wo tuuŋ yi ŋgʉ sèe tàcicii ye wèŋ fana ni' ye bi lo. ");
INSERT INTO yam_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nə yeè nə dʉk də, ŋwə̀ nə̀ Nwì ànə lokoksə yi mvwe' kpʉ nə, a yi nə̀ yi à ka ye bi. ");
INSERT INTO yam_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","<<Nə yeè nə dʉk də, wèŋ bwema am pwe'fo', wèŋ tse' ŋgòrì tse' pap də sə̀swìfa nə̀ wo sə tsoho nə, a bʉ̀ʉ liŋ ye. Wèeŋ rì sə̀' dʉk də ŋwə̀ nə̀ yi dzəm-a bohòyi, ye də yi swɛ'ɛ tesə bə bʉp ye laŋ. Yi swɛ'ɛ tesə nsàp nə̀ kaco lʉ̀ʉk Musì fiŋ me'rə to yi vɛ'nə yeŋ. ");
INSERT INTO yam_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Wèeŋ jəŋ ŋkərə̀ ya yusə̀ ŋgàa tsòhòbum Nwì à cèep kà bohòwèŋ kə̀ ye. ");
INSERT INTO yam_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Də, <Wèeŋ yu'rə-a, wèŋ sə̀ wèŋ sə ywì'lə yusə̀ Nwì cèep. Wèeŋ mərə, nə kpʉ. Bʉsə̀ nsàp fàk nə̀ mʉ̀ sə gʉ̀ bə mvə̀k nə̀ wèŋ cu fo' nè'e, A nsàp nə̀ co wèŋ kà də a yusə̀ zìnə dzəm. A ye-a də ŋwə̀ nəmòk à tsə̀' fa weŋ mantombì, wèŋ kà sə̀' dzəm malì.> >> ");
INSERT INTO yam_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol bə Bànabà à sə tesə mʉ ndap pìriyà nə də wo lo fana, bʉ̀ʉ sə wèŋ dʉk fa wo dʉk də, nùmbu dzə̀ mòk nə̀ nà' tsə nà'a dzèeŋ, yà'wèŋ və kə tsoho fa wo bum yè'sə sə̀mok. ");
INSERT INTO yam_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ghà nə̀ bʉ̀ʉ sə wèŋ à sam wes fana bʉ̀ʉ Jus bə bʉ̀ʉ sə̀ wo bʉ̀ʉŋ bʉ̀ʉ Jus wèŋ à yù Pol bə Bànabà ŋkʉ̀ʉŋntɛ̀ŋ. Wo à cèp, nə tipsə yà'wèŋ dʉk də yà'a sə geŋ mantombì bə ntʉm nə̀ də wo rì bòvə̀m nə̀ Nwì. ");
INSERT INTO yam_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nùmbu dzə̀ mòk nə à dzèeŋ, à bwehe gù jo də bwìŋ à tesə mvwe' lak yà'sə pwe'fo' ŋgòkə̀ yuk ncèp nə. ");
INSERT INTO yam_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bʉ̀ʉ Jus wèŋ à yə mvəsə̀ bwìŋ à kə rwiŋ fana, ntʉm kà wo bò. Wo cep də Pol sə ci' mvwès, nə yak nà'. ");
INSERT INTO yam_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pol bə Bànabà cep fis, nə kà wəp dʉk də, <<Anə boŋ tsoŋ dʉk də wèeŋ yuk to ncèp nə̀ Nwì nə wèŋ. Nə yeè nə də mvəsə̀ wèŋ bɛ̀ŋ ncèp nə, ye də wèŋ lɛŋ kpʉ awèŋ wèŋ, də wèŋ ka kʉrə ŋgòkə̀ tse' lùŋ nə̀ nà'a nə̀ kà mè nə. Mvə̀'nə̀ yà'a vɛ'nə fana, vèes nə tsoho fa mok bohòbʉ̀ lakmvum wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ncèp nə̀ Tà fa ves nə nè' də, <Mʉ̀ a nə̀msə weŋ co marɛŋ bohòbʉ̀ lakmvum. Wèeŋ nə ye co mandzə̀ nə̀ nzeŋgòŋ nə pwe' nə yuk ncèp lùŋ bohòwèŋ.> >> ");
INSERT INTO yam_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bʉ̀ lakmvum sə à yuk vɛ'nə, wo kwa, nə kwasə bə ncèp nə̀ Tà nə. Bʉ̀ʉ sə̀ Nwì ànə cok fis də wo nə tse' lùŋ à bʉ̀ʉŋ mok Krətèŋ. ");
INSERT INTO yam_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ncèp nə̀ Tà nə à yuhu mvwe' lak yà'sə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Fana bʉ̀ʉ Jus wèŋ kə caŋsə ncəncàŋ bohòbʉ̀ gʉgʉŋ sə̀ mvwe' lak yà'sə bə bàa sə̀ ghaŋ sə̀ wo kùksəgə̀ Nwì wèŋ. Wo ye ŋgòfa Pol bə Bànabà ŋgə' wùriŋ, nsàp nə̀ wo à lògɛsə mvwe' lak yà'sə maràŋ. ");
INSERT INTO yam_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Wo à kɛ̀'sə màk nòŋsə mfə̀mfəə kù awo fo', ŋgònì tsə̀' bə yusə̀ yà' ànə ye fa'nə sə. Wo à gʉ̀ wes vɛ'nə, wo bɛ' mandzə̀, nə lo mvwe' lak mok sə̀ wo to yà' də Àkonòm. ");
INSERT INTO yam_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bʉ̀ʉ sə̀ wo à sə yù mandzə̀ Jisòs sə̀ wo à ye mvwe' lak Antiyòk à rwiŋ bə kwəkwa nə ye bə Yòŋsə̀ nə̀ Rərɛŋ nə. ");
INSERT INTO yam_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","À kə̀ dzèŋ mvwe' lak Àkonòm anə fana Pol bə Bànabà à kə̀ ni mʉnə ndap pìriyà bʉ̀ʉ Jus wèŋ sə̀' mvə̀'nə̀ wo gʉ̀gə̀ səsa. Wo à tsòho mbwa vɛ'ɛ nsàp mòk fana bʉ̀ʉ Jus bə bʉ̀ lakmvum wèŋ à dzəm wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Fana bʉ̀ʉ Jus sə̀ wo à ka yàwo dzəm sə wèŋ à kə̀ caŋsə fa bʉ̀ lakmvum ncəncàŋ. Fana wo jok, nə bɛŋ bʉ̀ʉ sə̀ wo à dzəm Jisòs sə. ");
INSERT INTO yam_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol bə Bànabà wèŋ à cu fa'nə sə̀sap ntɛ̀ŋ. Wo à sə tsòho liŋ Tà Jisòs, nə kà yumok wəp lok. Tà à sə fa yà'wèŋ ŋàŋ ŋgògʉ̀hʉ bum sə̀ maŋgəŋgèŋ ŋgònì tsə̀' də yusə̀ yà' sə cèep sə kum bə bòvə̀m ye nə zìnə. ");
INSERT INTO yam_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bʉ̀ʉ sə̀ mvwe' lak yà'sə à gà'a bòp ba. Mok ye ma nə̀ bʉ̀ʉ Jus wèŋ fana, mok ye yàwo ma nə̀ ŋgàa ntum sə. ");
INSERT INTO yam_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bʉ̀ lakmvum mok wèŋ à kə̀ be'lə bə ŋkwàha bʉ̀ʉ sə̀ fo' sə, nə kiŋ cù dʉk də wo fa ŋgàa ntum sə wèŋ ŋgə', nə tərə yà' bə lìs. ");
INSERT INTO yam_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ŋgàa ntum sə wèŋ à yuk vɛ'nə fana, wo carə lo mvwe' lak Listà bə Debè sə̀ yà'a mvwe' nze Likaonà. ");
INSERT INTO yam_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Wo à gìhi kɛ' cà mvwe' nze nà'nə nə sə tsoho Ntirə̀ nə̀ Bə̀boŋ nə fo'. ");
INSERT INTO yam_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ŋwə̀ nəmòk à ye mvwe' lak Listà anə nə̀ kùu ye à kpʉ, yi kà sə gì. Mvə̀'nə̀ wo à dzə yi dzə, yi à ka gi yuk. ");
INSERT INTO yam_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Yi à cu fo', nə yuk yusə̀ Pol sə cèep. Pol ye nà', nə riŋ dʉk də nà' tse' dzədzəm də aco yi gʉŋsə nà', fana yi kʉk tse' nà' bə lis, ");
INSERT INTO yam_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","nə cep bə ŋgì nə̀ ghaŋ də, <<Lòkok təəŋ mʉtsə̀ bə kùu yo rərəŋ.>> Ŋgà' nə à li lòkok mʉtsə̀, nə ye ŋgògìhi kɛ' cà fo'. ");
INSERT INTO yam_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kwe' bʉ̀ nə̀ à ye fo' nə à yə yusə̀ Pol à gʉ̀ sə fana, wo yeto ŋgòkɛ'ŋgùŋ bə ncèep lak Likaonà sə, nə sə dʉk də, <<Nwì wèŋ bʉ̀ʉŋ co bwìŋ, nə və̀ə nə ŋgòkə̀ kɛ' yə ves!>> ");
INSERT INTO yam_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Wo to fa yà'wèŋ liŋ nwìi awo mok. Sə̀ Bànabà à ye də Zus, sə̀ Pol ye də Hemès, bʉ̀ʉsə̀ yi ànə ye ŋwə̀ nə̀ yi cèp nə yi. ");
INSERT INTO yam_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tàap nwì nə̀ də Zus nə à tə kʉəp ko' gù sə̀' ŋgʉ lak anə. Ŋwə̀ nə̀ yi fagə̀ satikà' Zus nə à jə və̀ ndu mbòŋ bə mvùu ŋgaŋ mok mvwe' ncùu ŋka' sə. Yi à jə və̀ yà' də wo gʉ satikà' bə zeŋ ŋgòkùksə ŋgàa ntum sə. ");
INSERT INTO yam_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pol bə Bànabà ànə yuk də yà' sə də yà'a gʉ vɛ'nə fana, wo soŋ sarə cə̀ək awo, nə carə ni lo mʉtsətsə'rə bʉ̀ʉ sə, nə sə kɛ'ŋgùŋ də, ");
INSERT INTO yam_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","<<Bʉ̀ʉ yè'e, wèŋ sə gʉ yè'sə yà? Vèes bwìŋ. Vès mègù sə̀' bʉ̀ʉ sə̀ bwìŋ co wèŋ. Vès və̀ fɛɛŋ ŋgòtsə̀' fa weŋ Ntirə̀ nə̀ Bə̀boŋ nə, ya wèeŋ bʉʉŋ gɛsə mvwe' bum sə̀ wà yè'sə, nə yuŋ Nwì nə̀ yi cu ŋwəm. Nwì nə̀ yi à gʉ̀ ntòbu bə nzeŋgòŋ, nə ye ndzəp bə bum sə̀ yà'a ca lòoŋ fo'. ");
INSERT INTO yam_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","À ye taaŋ fa', Nwì me'rə ndàaŋwè pwe' ŋgòyù mandzə̀ nə̀ ŋgə̀ŋgàŋ dzəm. ");
INSERT INTO yam_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Yi à mè'rə-a yà' sə̀' vɛ'nə, fana yi sə niŋ tsok fa mali bwìŋ də yi cu fo' bə nsàap bum sə̀ bə̀boŋ sə̀ yi gʉ̀ fagə̀ bwìŋ. Yi gʉ̀gə̀ mbʉ̀ŋ sə li tsoŋ mʉbu, nə sə gʉ bum zʉ awèŋ gʉŋ bə mvə̀k nə̀ bə̀boŋ. Yi fagə̀ weŋ zʉzʉ, nə sə gʉ ntʉʉm awèŋ rwiŋ bə kwəkwa.>> ");
INSERT INTO yam_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ŋgàa ntum sə wèŋ à cèp-a sə̀' mʉmvə̀k ènə, sə gʉŋ mali bohòbʉ̀ʉ sə nə̀ bʉp co wo teŋsə ŋgògʉ̀ satikà' nə̀ wo ànə dzəm ŋgògʉ̀ fa wo nə. ");
INSERT INTO yam_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","À ka sap fana bʉ̀ʉ Jus mok wèŋ à və̀ mvwe' lak Àkonòm bə Antiyòk. Wo à və̀, nə gʉ bʉ̀ʉ sə pwe' kwəəŋ wes lo ma njàwo. Wo tərə Pol bə lìs, nə soŋ fis gɛsə yi mʉ ntòlak anə, nə sə tsəm yàwo də nà' kpʉ laŋ. ");
INSERT INTO yam_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bʉ̀ʉ sə̀ wo à sə yù mandzə̀ Jisòs à kə̀ benə dzooŋ ŋgʉ ni'ì yi ŋgòkʉ̀k yi fana yi lokok. Yi à lòkok, nə foho lo sə̀' mʉ ntòlak anə. Tsok à rɛŋ, bə Bànabà lo yu awo Debè. ");
INSERT INTO yam_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol bə Bànabà à tsòho Ntirə̀ nə̀ Bə̀boŋ nə mvwe' lak Debè, fana bwìŋ dzəm wùriŋ. Wo ye'e, nə bwi foho lo fe'lə Listà, nə lo Àkonòm, nə lo Antiyòk. ");
INSERT INTO yam_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Wo à gìi, wo sə tipsə gʉŋsə tsə'rə bʉ̀ ŋgàa yù mandzə̀ Jisòs sə də, yà'wèeŋ kotse' mali yusə̀ yà' à dzəmtse' yà' bə liŋ Jisòs yà'a cʉ̀k. Wo à sə tsòho fa bwìŋ dʉk də, <<Vesùwèŋ tse' ŋgòyə ŋgə' wùriŋ ŋkuŋ a kə ni mvwe' gaŋ ŋkum Nwì.>> ");
INSERT INTO yam_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Wo à coho nòŋsə lòŋkwàha bwìŋ mʉnə coos sə lòoŋ fo'. Wo lɛŋ pìriyà, nə dzə zʉzʉ, nə fa bʉ̀ʉ sə bohòTà Jisòs, nə̀ wo à fa ntʉʉm awo bohònà' nə. ");
INSERT INTO yam_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ghà nə̀ wo à càsə nzeŋgòŋ Pìsidiyà fana wo və mvwe' nzeŋgòŋ Pàmfiliyà. ");
INSERT INTO yam_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Wo à tsòho ncèp nə mvwe' lak Pegà, nə ca tsoŋ lo sə mvwe' sə̀ wo togə̀ fo' dʉk də Àtaliyà. ");
INSERT INTO yam_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Wo à mè'rə fo', nə ni ŋgwes, nə bwi foho lo Antiyòk. A sə̀' mvwe' sə̀ cos nə à fa wo bohòNwì ŋgòjə ŋkərə̀ bohòwo bə fàak sə̀ wo a gʉ̀ wes yà' sə. ");
INSERT INTO yam_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","À kə̀ dzèŋ Antiyòk fana wo to benə bʉ̀ʉ sə̀ mʉ cos pwe' mvwe' mò'fis, nə tsoho fa yà'wèŋ yusə̀ Nwì a gʉ̀ bohòwo. Wo tsok fa yà'wèŋ mvəsə̀ Nwì a fa mandzə̀, bʉ̀ lakmvum wèŋ dzəm bohòJisòs yàwo sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Wo à cu mali fo' bə bʉ̀ʉ sə̀ wo à sə yù mandzə̀ Jisòs sə wèŋ sə̀sap ntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bʉ̀ʉ səmok à tesə və̀ mvwe' nzeŋgòŋ Jùdiyà, nə və Antiyòk anə. Wo sə yə'rə fa bwema sə̀ wo à dzəm Jisòs sə dʉk də, <<Kaco wèŋ tse' lùŋ nə̀ nà'a nə̀ kà mè nə yeŋ, tse'ŋga wo kom fa weŋ tu mbəmbam mvəsə̀ Musì à dʉk.>> ");
INSERT INTO yam_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol bə Bànabà bə yà'wèŋ à fenə bə ncèp ènə nə̀bʉp. Wo à kə̀ lə̀sə tes dʉk də Pol bə Bànabà nə ye bʉ̀ʉ səmok sə̀ Antiyòk anə lo Jòrosalèm kə ye ŋgàa ntum bə ŋkwàha bwìŋ mʉ cos bʉ̀ʉ ncèp ènə. ");
INSERT INTO yam_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bʉ̀ʉ cos sə à tumsə wo. Mvə̀'nə̀ wo à sə ca mvwe' nzeŋgòŋ Fònisiyà bə Sàmàriyà fana wo tsok mvəsə̀ bʉ̀ lakmvum wèŋ bʉ̀ʉŋ və̀ ma nə̀ Nwì. Bwema sə̀ fo' à kwa bə ncèp ènə wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Wo à kə̀ dzèŋ Jòrosalèm fana, bʉ̀ʉ cos nə̀ fo' nə dʉk fa wo də wo və bə̀boŋ. Ŋgàa ntum bə bʉ̀ ŋkwàha bwìŋ à dʉk fa wo sə̀' də wo və bə̀boŋ, fana wo tsoho fa yà'wèŋ yusə̀ Nwì a gʉ̀ bohòwo. ");
INSERT INTO yam_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Fana bʉ̀ʉ mok sə̀ wo à dzəm, sə̀ wo yàwo ma bòp bʉ̀ʉ Faràsi wèŋ à lòkok, nə cep dʉk də, <<Wo tse' ŋgòkom fa ndàaŋwè nə̀ yi ka ŋwə̀ Jus yeŋ tu, nə tsok fa wo ŋgòyù lʉ̀k Musì ŋkuŋ yi tse' lùŋ nə̀ nà'a nə̀ kà mè.>> ");
INSERT INTO yam_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ŋgàa ntum sə bə bʉ̀ ŋkwàha bwìŋ wèŋ à kə̀ be'lə mvwe' mò'fis ŋgòtsərə bòŋsə bə ncèp ènə. ");
INSERT INTO yam_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Wo ànə cep ncèp ènə tə̀tè fana Pità lokok, nə dʉk də, <<Bwema am wèŋ, wèŋ rì sə̀' dʉk də mvə̀'nə̀ yà' à yèto, Nwì à cokfis mʉ mʉtsətsə'rə wèŋ ŋgòtsòho fa bʉ̀ lakmvum wèŋ Ntirə̀ nə̀ Bə̀boŋ nə, də ya mʉ tsoho nà', wo yuk, nə dzəm. ");
INSERT INTO yam_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Fana Nwì, yi nə̀ yi rì ntʉʉm bwìŋ pwe'fo' nə à nì tsə̀' də yi jə bʉ̀ʉ sə̀ wo ka bʉ̀ʉ Jus yeŋ sə sə̀'. Yi à nì tsə̀' bə mandzə̀ nə̀ də yi à fa yà'wèŋ Yòŋsə̀ nə̀ Rərɛŋ nə sə̀' mvəsə̀ yi à fa vesùwèŋ. ");
INSERT INTO yam_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yi à ka zəzok mʉtsətsə'rə vesùwèŋ nə ye wo niŋ. Yi à rɛŋsə ntʉʉm awo bʉ̀ʉsə̀ wo à dzəm bohòyi. ");
INSERT INTO yam_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","A ye-a vɛ'nə, nə̀ ŋga'a nè'e wèŋ sə də wèeŋ mumsə Nwì yè'sə bʉ̀ʉ yà? Wèŋ sə mùmsə yi nə sə bə̀k naaŋ fa bʉ̀ ŋgàa yù mandzə̀ Jisòs yè'sə bum mok mʉ tuhù bʉ̀ʉ yà? Tàcicii avès nə ye vesùwèŋ à ka ŋgòbə̀k to yà' wabə. ");
INSERT INTO yam_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ka vɛ'nə bə̀boŋ yeŋ. Vesùwèŋ dzəm, nə tse' lùŋ bʉ̀ʉ bòvə̀m nə̀ Tà Jisòs sə̀' mʉmvə̀'nə̀ wo yàwo sə sə̀'.>> ");
INSERT INTO yam_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Mvə̀'nə̀ wo à yuk vɛ'nə, wo cum gəe'. Pol bə Bànabà ye ŋgòtsòho fa yà'wèŋ nsàap maŋgəŋgèeŋ sə̀ Nwì a fàk fa bʉ̀ lakmvum wèŋ ndzə bohòwo. ");
INSERT INTO yam_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Wo ànə cep wes fana, Jem cep fis ye sə̀' dʉk də, <<Bwema am, wèeŋ yu'rə a. ");
INSERT INTO yam_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimʉ̀ sə cèp rɛŋsə wes tsə gù mvə̀k nə̀ Nwì à yeto ŋgòjə bʉ̀ lakmvum wèŋ co bwìŋ, nə sə cok fis bwìŋ mʉtsətsə'rə yà'wèŋ də yà'a ye bʉ̀ʉ ye. ");
INSERT INTO yam_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Yu yè'sə mègù yəyərə̀ bə yusə̀ ŋgàa tsòhòbum Nwì wèŋ à cèep. Ŋwàk Nwì sə cèp dʉk də, ");
INSERT INTO yam_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","<Anə̀ kə̀ ta, mʉ̀ bwi və, dʉ' mʉ̀ʉ Tà. Mʉ nə lokoksə ndap Devìd nə̀ nà' à gbʉ̀ nə sə̀mok. Mʉ nə fəsə və fə̀əm lak sə, nə ci tsə'rə fe'lə yà' sə̀mok. ");
INSERT INTO yam_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Fana bʉ̀ʉ mok yà'a pwe'fo' nə lap mandzə̀ Tà. Bʉ̀ lakmvum sə̀ mʉ̀ à to wo ŋgòye bʉ̀ʉ sə̀ yàm yà'a. ");
INSERT INTO yam_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","À cèp yè'sə Tà nə̀ yi à gʉ̀ bwìŋ ŋgòrì yè'sə taaŋ ntɛ̀ŋ nə.> >> ");
INSERT INTO yam_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jem dʉk mali dʉk də, <<Bə və̀əm yàm, bʉ̀ʉ sə̀ wo sə bʉʉŋ və̀ bohòNwì ŋga wo bʉ̀ lakmvum yè'sə, ka bə̀boŋ də a fa wo ŋgə' yeŋ. ");
INSERT INTO yam_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Bòlɛ də, vesùwèeŋ com fa wo ŋwàk. A com megu fa wo də wo kà zʉzʉ sə̀ yà'a bʉp bʉ̀ʉsə̀ wo fa yà' bohòrùm zʉ. Wo kà sàhà kè nto sə ko, kà ndʉəm kè nàm nə̀ yi kpʉ bə ndʉəm ye ndzə ni'ì zʉ. ");
INSERT INTO yam_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bʉsə̀ sàp wùriŋ mvəsə̀ wo tagə̀ lʉ̀ʉk Musì mʉmvə̀'ànə mʉnə ndaap pìriyàa bʉ̀ʉ Jus wèŋ nùumbu dzə̀ lòoŋ, nə sə tsoho ncèp ye nə mvwe' buhu lak lòoŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ànə ye vɛ'nə fana, ŋgàa ntum sə bə bʉ̀ ŋkwàha bwìŋ bə bʉ̀ʉ cos nə pwe' à dzəm mvwe' mò'fis dʉk də wo cokfis bʉ̀ʉ səmok mʉnə kwe' àwo, nə tum gesə lo wo Antiyòk anə bə Pol nə ye Bànabà wèŋ bəbɛ'. Wo a cok fis Judàs nə̀ wo to yi mok də Bàsabà, bə Silàs. Bwema sə wèŋ à sə jə bʉ̀ʉ yè'sə co bʉ̀ʉ sə̀ mantombì. ");
INSERT INTO yam_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wo à còm ŋwàk, nə tumsə wo bə zeŋ. Ŋwàk nə à sə cep də vɛ': <<Vès, ŋgàa ntum bə bʉ̀ ŋkwàha bwìŋ sə̀ vèes bwema awèŋ, vès cèpsə vèsə weŋ bə̀boŋni. Wèŋ sə̀ wèŋ cu mvwe' lak Antiyòk bə Sìriyà nə ye Sìlisiyà, sə̀ wèeŋ bʉ̀ lakmvum lòoŋ. ");
INSERT INTO yam_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Vès yuk dʉk də bʉ̀ʉ səmok a tesə mʉŋgorə̀ vès, nə kə fa weŋ ŋgə', nə cep bum mok sə̀ yà' a gʉ̀ ntʉʉm awèŋ ŋgòtse' tsətsərə̀. Yusə dʉk də vès a ka wo də wo kə gʉ vɛ'nə tum. ");
INSERT INTO yam_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Vès a kə̀ cu bwì, nə dzəm sə̀' mvwe' mò'fis də vèes cok fis bʉ̀ʉ mok, nə tum wo bohòwèŋ. Wo nə lo bə Pol nə ye Bànabà wèŋ sə̀ vès dzəm wo nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","A bə nà' nə̀ à bwehe gu jo dʉk də wo à kpʉ bʉ̀ʉsə̀ wo sə fàk bohòJisòs Krɛst nə̀ yi Tà àvès. ");
INSERT INTO yam_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bum sə̀ vès sə com yè'sə, Judàs bə Silàs sə̀ vès sə tumsə wo nə tsoho fa weŋ yà' bə cù sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ves Yòŋsə̀ nə̀ Rərɛŋ nə wèŋ a dzəm mvwe' mò'fis dʉk də vèes kà weŋ ŋgə' mòk wà bə̀k naaŋ fa, mègù dzə̀dzə̀ə sə̀ yà' tse' ŋgòye vɛ'nə yè'e: ");
INSERT INTO yam_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kà zʉzʉ sə̀ wo fa yà' bohòrùm zʉ; kà ndʉəm zʉ; kà nàm nə̀ yi kpʉ bə ndʉəm ye ndzə ni'ì yi zʉ; wèeŋ kà sàhà kè nto sə ko. Wèeŋ gʉ-a mvəsə̀ vès dʉk yè'sə fana, ye də wèŋ gʉ̀ bə̀boŋ. Wèeŋ cum bə̀boŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ànə geŋ, wo tum bʉ̀ʉ sə wo lo Antiyòk anə. À kə̀ dzèŋ fo', wo to benə bʉ̀ʉ sə̀ wo à dzəm sə pwe' mvwe' mò'fis, nə fa yà'wèŋ ŋwàk nə. ");
INSERT INTO yam_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bʉ̀ʉ sə à ta ŋwàk nə, nà' ni wo sə ntʉʉ̀, nə gʉ wo kwa wù kà fʉ̀k. ");
INSERT INTO yam_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judàs bə Silàs à cèp bə bwema sə wèŋ mvə̀k sə̀sap ntɛ̀ŋ. Wo à sə tip gʉŋsə yà' bə̀boŋ. Judàs bə Silàs à ye yàwo sə̀' ŋgàa tsòhòbum Nwì. ");
INSERT INTO yam_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Wo à cu sàp fo' bə̀boŋ tè fana bwema sə wèŋ me'rə wo bə̀boŋ. Wo à bwìŋ foho lòsə̀' bohòbʉ̀ʉ sə̀ yà'wèŋ à tum wo sə. ( ");
INSERT INTO yam_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silàs à dzəm yi, nə kà ye sə bwìŋ lò.) ");
INSERT INTO yam_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol bə Bànabà à cuuŋ Antiyòk anə bòŋ. Wo bə bʉ̀ʉ mok wèŋ à sə yə'rə, nə sə tsoho fa bwìŋ ncèp Tà Jisòs. ");
INSERT INTO yam_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nùmbu nəmòk à kʉ̀rə, Pol dʉk fa Bànabà duk də, <<Vesùu bwi foho lo kɛ'ca mvwe' lak sə̀ vesù à tsòho ncèp nə̀ Tà fo' yà'a pwe', ŋgòkə̀ yə bwema sə wèŋ, nə ja'a də wo sə gʉ̀ valɛ.>> ");
INSERT INTO yam_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bànabà à dzəm də bə Jon Mak wèeŋ lo bəbɛ'. ");
INSERT INTO yam_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pol tsərə ye dʉk də ka vɛ'nə yəyərə̀ yeŋ. Də bʉ̀ʉsə̀ nà' ànə me'rə wo mvwe' nzeŋgòŋ Pàmfiliyà, nə bwi lo yuye ŋga fàk ka ntòme. ");
INSERT INTO yam_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bə nà' à kʉ̀ə̀m fo' tə̀tè swɛ'lə lis fana, wo ga'a. Bànabà à jə Mak, bə nà' ni ŋgwes ŋgòlòmvwe' lak Sɛprò. ");
INSERT INTO yam_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol jəŋ ye Silàs, bə nà' lo yàwo sə̀'. Bwema sə à fa yi bohòTà bə bòvə̀m ye ŋgòjə ŋkərə̀ bohònà'. ");
INSERT INTO yam_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Yi à lòmvwe' nzeŋgòŋ Siriyà bə Sìlisiyà nə sə tip gʉŋsə bʉ̀ʉ cos sə̀ fo' sə. ");
INSERT INTO yam_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol à sə lòmalì, nə kə dzeŋ Debè bə Listà. Ŋwə̀ nəmòk nə̀ yi à sə yùgə̀ mandzə̀ Jisòs à ye fo' nə̀ wo togə̀ yi də Timatì. Ma ye à ye ŋwà Jus nə̀ yi à sə yù mandzə̀ Jisòs sə̀'. Tɛ̀' ye à ye ŋwə̀ Gris. ");
INSERT INTO yam_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bwema sə̀ mvwe' lak Listà bə Àkonòm pwe' à sə cèp dʉk də Timatìi ŋwə̀ nə̀ bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol ànə dzəm də bə Timatì lo fana yi kom fa nà' tu mbəmbam. Yi à gʉ̀ vɛ'nə bʉ̀ʉsə̀ bʉ̀ʉ Jus sə̀ wo à ye mvwe' lak yà'sə pwe' à rì də tɛ̀'ɛ Timatìi ŋwè lakmvum. ");
INSERT INTO yam_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mvə̀'nə̀ wo à sə lòo, wo dzèŋ mvwe' buk lak nə̀ fòpwe', wo tsok fa yà'wèŋ bum sə̀ ŋgàa ntum nə ye bʉ̀ ŋkwàha bwìŋ sə̀ wo cu Jòrosalèm wèŋ à dzəm tes bə zeŋ mvwe' mò'fis sə. Wo tsoho fa bʉ̀ʉ sə də yà'a noŋsə dzə̀dzə̀ə yà'sə bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Fana bʉ̀ʉ cos à gʉ ghaha lòmantombì bə bum sə̀ wo à dzəm tse' yà', nə sə yam lo mantombì nùumbu pwe'. ");
INSERT INTO yam_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ànə geŋ wo yuŋ ca mok mvwe' ndʉ̀rə ŋgòoŋ Frijìyà bə Gàlesiyà bʉ̀ʉsə̀ Yòŋsə̀ nə̀ Rərɛŋ nə à ka wo mandzə̀ co wo tsoho ncèp nə mvwe' nze Ɛsiyà fa. ");
INSERT INTO yam_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Wo à kə̀ dzèŋ mvwe' ndʉ̀rə ŋgòoŋ Mìsiyà fana wo lap mandzə̀ dʉk də wo lo mvwe' nze Bìtiniyà. Yòŋsə̀ Jisòs à ka wo mandzə̀ nə̀ ŋgòlòma nà'nə fa. ");
INSERT INTO yam_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Wo ga'a nə lo mok tə̀tè nə ca mvwe' nzeŋgòŋ Mìsiyà, nə tsoŋ lo sə Truwà. ");
INSERT INTO yam_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nùmbu ànə à ye, Pol ye nooŋ lo. Yi ye ŋwə̀ nəmòk nə̀ mvwe' nzeŋgòŋ Màsìdoniyà ŋga nà' tə, nə sə lɛŋ yi dʉk də, <<Və̀ mvwe' nzeŋgòŋ Màsìdoniyà, nə kə tɛsə ves!>> ");
INSERT INTO yam_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol ànə ye nsàp lo ènə fana, ves fʉhʉ ŋgòye'e lo Màsìdoniyà anə. À ye vɛ'nə bʉ̀ʉsə̀ vès à tsərə sə ntʉʉ̀ vès dʉk də Nwì to ves ŋgòkə̀ tsòho fa bʉ̀ʉ sə̀ fo' sə wèŋ Ntirə̀ nə̀ Bə̀boŋ nə. ");
INSERT INTO yam_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Vès à mè'rə fo', nə ni ŋgwes, nə to yak lo rərəŋ mvwe' lak Sàmòtirès. Tsok à rɛŋ vès lo mvwe' lak Nàpolìs. ");
INSERT INTO yam_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Vès à mè'rə bwì fa'nə, nə lo mvwe' lak Filìpi. Bʉ̀ʉ Rumà wèŋ à sə cu mvwe' lak yà'sə wo. Nà'nə ntʉm lak nə̀ nà'à yèto mvwe' nzeŋgòŋ Màsìdoniyà yi. Vès à cu fo' nùumbu ŋkʉ̀ʉŋntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nùmbu dzə̀ à dzèeŋ, vès tesə mʉ ntòlak anə, nə lo mà ŋgʉ ndzəp. Vès à sə tsərə də vèes nə ye mvwe' sə̀ bʉ̀ʉ Jus wèeŋ gʉ̀gə̀ pìriyà fo'. Vès à cu nze, nə sə taaŋ ves bə̀ba sə̀ wo à kə̀ benə fo'. ");
INSERT INTO yam_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ŋwà nəmòk nə̀ yi à yuk yusə̀ vès à sə cèp sə à ye Lidiyà. Lak ŋwà ènə à ye Tìyatirà. Yi à sə sèeŋ cə̀ək sə̀ ntɛŋ gʉgʉŋ, sə̀ bə̀baŋ zènə zènə yà'a. Yi à ye ŋwà nəmòk nə̀ yi kùksəgə̀ Nwì. Tà Nwì à mùk ntʉm ye yi yu'rə yusə̀ Pol à sə cèp fana, ");
INSERT INTO yam_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","yi bàptɛsə bə bʉ̀ʉ sə̀ mʉ nda'à yi pwe'. Yi to ves nə də a ye-a ŋga vès riŋ-a zìnə dʉk də yi a dzəm bohòTà fana vès və, vesiwèŋ kə cum nda'à yi. Yi à tà' tə mègù vɛ'nə tə̀tè vès dzəm fa yi. ");
INSERT INTO yam_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nùmbu nəmòk à ye ŋga vès sə lo mvwe' sə̀ wo gʉ̀gə̀ pìriyà fana vès kʉrə bə mʉŋwà nəmòk. Mʉŋwà nə ànə ye ŋkwɛ̀ŋ. Yi à tse' yòŋsə̀ nə̀ bʉp ndzə ni'ì yi. Yòŋsə̀ nə sə gʉ yi, yi sə tsoho bum sə̀ yà' cu ntòmantombì. Yi à sə tsòho vɛ'nə, wo sə lak yi mbàm. Yi à sə kap fa bʉ̀ʉ sə̀ wo à tse' yi sə wèŋ mbàm wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Yi à yù lòves Pol wèŋ. Yi sə gurə dʉk də, <<Bʉ̀ʉ yè'e wèeŋ ŋgàa fàak Nwì nə̀ yi Nwì nə̀ ghaŋ nə. Wo sə tsòho fa weŋ mvə̀'nə̀ aco wèŋ tse' lùŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Yi à gʉ̀hʉ vɛ'nə mʉnə nùumbu ŋkʉ̀ʉŋntɛ̀ŋ, tə̀tè ntʉm à yaaŋ Pol yi jok. Fana Pol bʉʉŋ cep bohòyòŋsə̀ nə dʉk də, <<Mʉ̀ sə cep mʉnə ŋàaŋ liŋ Jisòs də wu tesə ndzə ni'ì yi anə.>> Yòŋsə̀ nə à tesə ndzə ni'ì yi anə sə̀' ghà nà'nə. ");
INSERT INTO yam_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mvəsə̀ bʉ̀ʉ sə̀ wo à tse' nà' sə à yə də mandzə̀ mbàm àwo loho laŋ, fana wo tap ko Pol bə Silàs. Wo soŋ jəŋ lo yà'wèŋ mʉ ntɛɛ̀ŋ mvwe' sə̀ wo sakgə̀ nzak. ");
INSERT INTO yam_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wo jəŋ və yà'wèŋ bohòbʉ̀ʉ ŋgàa sak nzak bʉ̀ʉ Rumà wèŋ. Wo tsok fa yà' dʉk də, <<Bʉ̀ʉ yè'e, wo bʉ̀ʉ Jus, nə sə fa ŋgə' mʉ ntòla'à vès. ");
INSERT INTO yam_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wo sə tsòho bum lak sə̀ lʉ̀k avès sə kà vɛ'nə dzəm. Vèes bʉ̀ʉ Rumà fana kaco vès dzəm yà' yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kwe' bʉ̀ nə̀ wo à ye fo' nə pwe' à be'lə ŋgòfa Pol bə Silàs ŋgə'. Ŋgàa sak nzak sə wèŋ à sàrə wes fa Pol bə Silàs cə̀k mʉ ni'ì pwe', nə fa ŋàŋ dʉk də bwìiŋ ləp yà'wèŋ bə ŋkwɛ̀s. ");
INSERT INTO yam_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wo ànə ləp jamsə wo bə̀boŋ fana, wo kə nisə wo ndapndzəm. Wo tsok fa ŋgà kʉ̀k ndapndzəm nə də nà'a lok yà' bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mvə̀'nə̀ ŋgà kʉ̀k ndapndzəm nə à yuk ncèp ènə fana yi gesə yà' bə rum nə̀ mʉtsətsə'rə̀, nə so fa yà'wèŋ ruk. ");
INSERT INTO yam_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","À kə̀ dzèŋ co nə̀ ntəntʉm tsok fana, Pol bə Silàs sə gʉ̀ pìriyà, nə sə yəm fa Nwì ŋkì. Bʉ̀ ŋgàa ndapndzəm mok sə wèŋ sə yu'rə. ");
INSERT INTO yam_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Wo yuk-à, ndapndzəm nə tsoho bə kùum sə pwe'. Nà' tsoho nsàp nə̀ bə jòŋ. Ncùu sə muhu ca sə̀' jwaŋ. Kwaŋ ŋgàa ndapndzəm sə pwe'fo' fweeŋ gbʉ sə nze. ");
INSERT INTO yam_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ŋgà kʉ̀k ndapndzəm nə à yə̀əŋ lòkok, nə ye ŋga ncùu sə nòto. Yi tsəm dʉk də ŋgàa ndapndzəm sə wèŋ tesə lòwes laŋ. Fana yi soŋ cok fis fèk ye də yi zə ni' ye. ");
INSERT INTO yam_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pol gham nà' nsàp nə̀ co ŋgì loho yi, nə sə dʉk də, <<Kà ni' yòwà bʉpsə̀, vès cu fɛnə lòoŋ!>> ");
INSERT INTO yam_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ŋgà kʉ̀k ndapndzəm nə à to də wo jəŋ və fa yi laàm. Yi caŋ ni mbwa, nə kə gbʉ nooŋ ŋgʉ ni'ì Pol bə Silàs sə nze, nə sə kaŋ jìkjìkjìk. ");
INSERT INTO yam_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Fana yi fis yà'wèŋ sə mbiŋ. Yi fek wo dʉk də, <<Tà wèŋ, aco mʉ̀ gʉ yè'sə yà ŋkuŋ ya mʉ tse' lùŋ ɛ?>> ");
INSERT INTO yam_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wo dʉk fa nà' də, <<Dzəm bohòTà Jisòs ya wu nə tse' lùŋ, wù bə ndap yòpwe'.>> ");
INSERT INTO yam_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Wo tsoho fa nà' bə bʉ̀ʉ sə̀ mʉ nda'à yi pwe'fo' ncèp nə̀ Tà nə. ");
INSERT INTO yam_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","À ye sə̀' ghà nà'nə bə ndzəm nà'nə ŋgà kʉ̀k ndapndzəm nə à jə wo, nə kə cuk fa wo mvwe' awo sə làaŋ pwe'fo'. Yi bə ndap ye pwe' à bàptɛsə kɛ̀' mò'fis. ");
INSERT INTO yam_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Yi jəŋ lo Pol bə Silàs mʉ nda'à yi, nə fa yà'wèŋ bɛŋ də yà'a zʉ. Yi bə ndap ye nə pwe' à rwiŋ bə kwəkwa, bʉ̀ʉsə̀ wo a dzəm mok Nwì. ");
INSERT INTO yam_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tsok ànə rɛŋ, nə̀ zəzòŋ fana ŋgàa sak nzak bʉ̀ʉ Rumà wèŋ tum vesə dògarì. Wo fa yà'wèŋ ŋàŋ dʉk də yà'a kə tsok də wo me'rə bʉ̀ʉ yà'sə wèŋ wo lo. ");
INSERT INTO yam_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ŋgà kʉ̀k ndapndzəm nə à kə̀ tsə̀' fa Pol dʉk də, <<Ŋgàa sak nzak sə wèŋ fa vèsə ŋàŋ də wo me'rə weŋ Silàas lo. Aco wèŋ lo yu awèŋ bə fifi.>> ");
INSERT INTO yam_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pol dʉk fa dògarìi sə wèŋ də, <<Wo a ka nzak àvès sə̀' sak lok fana wo ləp ves mʉtsətsə'rə bwìŋ jì njo ŋga vès tse' ŋàaŋ sə̀ bʉ̀ʉ Rumà wèŋ tse'. Wo a nisə ves ndapndzəm, nə sə dzəm də wo me'rə swihi ves swìhi. Kwɛ'fò, anə kà vɛ'nə fàk. Ŋgàa sak nzak bʉ̀ʉ Rumà sə nə və tsooŋ fɛɛŋ bə tu awo, ŋkuŋ nə fis me'rə ves.>> ");
INSERT INTO yam_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Dògarìi sə wèŋ à foho lòo, nə kə tsok fa ŋgàa sak nzak sə cùu Pol sə. Wo ànə yuk dʉk də Pol bə Silàas bʉ̀ʉ Rumà fana wʉə ko wo. ");
INSERT INTO yam_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Wo lo, nə kə lɛŋ sə̀swìfa bohòyà'wèŋ. Wo fis yà'wèŋ mʉ ndapndzəmə̀ anə, nə dʉk fa yà'wèŋ dʉk də aco yà' tesə mʉ ntòlak anə, nə lo. ");
INSERT INTO yam_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pol bə Silàs à tesə mʉ ndapndzəmə̀ anə, nə lo nda'à Lidiyà. À kə̀ dzèŋ fo', wo tseŋ bwema sə̀ wo à dzəm Jisòs. Wo tipsə gʉŋsə yà', nə lo. ");
INSERT INTO yam_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Wo à cà mvwe' lak Àmfìpolìs bə lak Àpòlòniyà, nə dzeŋ Tètàlonikà. Ndap pìriyà bʉ̀ʉ Jus wèŋ à ye fo'. ");
INSERT INTO yam_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Sə̀' mʉ mvə̀'nə̀ Pol gʉ̀hʉ ləəŋgə̀ səsa sə fana, yi à lòmʉmvwe' ndap pìriyà nə. Yi à cu mvwe' lak yà'sə ntɛŋ tɛ'. Nùumbu dzə̀ lòoŋ, yi sə fenə bə bòp bʉ̀ nə̀ fo' bə bum sə̀ yà'a ndzənə ŋwàk Nwì. ");
INSERT INTO yam_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Yi à sə tsòho, nə sə ni tsok fa yà'wèŋ nja dʉk də, <<Ŋkum ŋgà gèm bwìŋ nə̀ Nwì ànə dʉk də yi nə tum nə, à tse' ŋgòyə ŋgə' fana nə kpʉ, nə luŋ sə̀mok. Jisòs nə̀ mʉ̀ tsə̀' weŋ liŋ ye nè'nə, yi Ŋkum ŋgà gèm bwìŋ nə.>> ");
INSERT INTO yam_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mok wèŋ à dzəm, nə be'lə lo mok ma nə̀ Pol bə Silàs. Bòp bʉ̀ nəmòk wùriŋ sə̀ wo à ye bʉ̀ lakmvum, nə sə kuksə Nwì, à dzəm sə̀'. Bə̀ba mok wùriŋ sə̀ wo mantombì à dzəm sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bʉ̀ʉ Jus wèŋ à yè ŋgòwa də bwìŋ sə dzəm vɛ'nə bʉ̀ʉ yà lɛ? Fana wo lo, nə kə to benə ŋgàa gha' ŋgòŋ sə mandzə̀ mvwe' mò'fis. Nà' à ye kwe' nə̀ ŋgògʉ̀ lak sə curə nə̀bʉp. Wo kə ni lap ndap ŋwə̀ nəmòk nə̀ liŋ yee Jasòŋ. Wo à sə làp mandzə̀ nə də wo ye Pol bə Silàs mbwa, nə jəŋ lo yà'wèŋ mvwe' kaŋsurù. ");
INSERT INTO yam_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Wo à ka yà'wèŋ ye, fana wo soŋ jəŋ lo Jasòŋ nə bə bwema mok sə̀ wo à dzəm Jisòs, nə kə fa bohòbʉ̀ʉ ŋgàa sak nzak sə mvwe' ntʉm lak ànə. Wo gurə, nə sə dʉk də, <<Bʉ̀ʉ yè'e wèŋ sə gʉ̀ fana ŋgə' sə tesə ma nə̀ fòlòoŋ. Wo nə və̀ nə ŋga'a mvwe' lak yàvès sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasòŋ ko noŋsə wo mʉ nda'à yi. Wo pwe', nə̀ mò'fis kà lʉ̀ʉk ŋkum àvès nə̀ ghaŋ nə̀ mvwe' lak Rumà sə nòŋsə̀gə̀. Wo sə cèp də ŋkum mòk cu fe'lə nə̀ liŋ yee də Jisòs.>> ");
INSERT INTO yam_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wo ànə cep nsàp ncèp ènə, fana kwe' bʉ̀ nə̀ wo sakgə̀ kaŋsurù bə bʉ̀ʉ mok sə pwe' à ŋàk kɛ'cà maŋgəŋgèŋ. ");
INSERT INTO yam_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bʉ̀ʉ kaŋsurù sə wèŋ à gʉ̀ʉ, fana Jasòŋ bə bʉ̀ʉ ye wèŋ lak mbàm sə̀ wo kogə̀ ŋwè, yi lak yà' ŋkuŋ wo me'rə yi. Wo lak yà' fana wo me'rə yà'wèŋ lo. ");
INSERT INTO yam_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ndzəm à sèŋ ntɛ̀ŋ, bwema sə̀ wo à dzəm sə wèŋ tumsə lo Pol bə Silàs mvwe' lak Berà. Wo à kə̀ dzèŋ fo', wo sə lo mvwe' ndap pìriyà bʉ̀ʉ Jus wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bʉ̀ʉ sə̀ fo' à bòvə̀m nə ghak bʉ̀ʉ sə̀ wo cu mvwe' lak Tètàlonikà wèŋ. Wo à yu'rə ncèp nə bə ntʉm nə̀ kwəkwa wùriŋ. Wo à sə ta ŋwàk Nwì nə nùumbu pwe' də ya ŋga wo riŋ-a yàwo sə̀' dʉk də yusə̀ Pol sə cep sə vɛ'nə nə̀ zìnə àlɛ? ");
INSERT INTO yam_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bʉ̀ʉ sə̀ wo à dzəm à ye cɛ̀bʉ̀ə̀. Bàa mok sə̀ ghaŋ bə mbəmbam wèŋ à dzəm sə̀' ŋga wo à ye bʉ̀ lakmvum ");
INSERT INTO yam_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Bʉ̀ʉ Jus sə̀ mvwe' lak Tètàlonikà wèŋ ànə yuk dʉk də Pol tsoho ncèp Nwì mvwe' lak Berà, fana wo və, nə ye ŋgòfʉəpsə fa bʉ̀ʉ sə̀ fo' sə mbʉəp nə̀ bʉp. ");
INSERT INTO yam_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ànə ye vɛ'nə ntɛ̀ŋ, bwema sə̀ wo à dzəm sə wèŋ jəŋ lo Pol mà ŋgʉ ndzəp də yi lo. Silàs bə Timatì wèŋ à mam yàwo Berà anə. ");
INSERT INTO yam_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bʉ̀ʉ sə̀ wo à sə jə lòPol sə à lòtə̀tè kə dzeŋ mvwe' lak Atèn ŋkuŋ wo bwi foho və fe'lə Berà anə. Pol à dʉk wo də yà'wèeŋ kə tsok Silàs bə Timatì də yà'wèeŋ yuŋ və yi nə̀nàk. ");
INSERT INTO yam_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mvə̀'nə̀ Pol à sə cu mvwe' lak Atèn anə ŋgòtək Silàs bə Timatì, fana ntʉm ye kà sə kwa lok. Yi à sə kà kwəkwa tse' bʉ̀ʉsə̀ yi à sə yə ŋga tàap bumlak co rùm rwiŋ mvwe' ntʉm lak ànə vɛ'ɛ dak. ");
INSERT INTO yam_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yi à lòmʉmvwe' ndap pìriyà bʉ̀ʉ Jus wèŋ, nə sə cep fenə cù mbwa bə bʉ̀ʉ Jus, nə ye bʉ̀ʉ sə̀ wo kùksəgə̀ Nwì ŋga wo bʉ̀ lakmvum sə̀'. Yi sə fenə mʉ ntɛɛ̀ŋ sə̀' nùumbu pwe' bə bʉ̀ʉ sə̀ wo və-a fo' na. ");
INSERT INTO yam_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Yi à sə fenə mok bə cicàa səmok sə̀ wo to wo də Èpàkurà, bə mok də Sìtoɛ̀k wèŋ sə̀'. Mok à sə dʉk də, <<Ŋgà bùp cùu sə̀ wà ènə sə də yi cep yè'sə yà lɛ?>> Mok dʉk yàwo də, <<Yi sə gʉ̀ co yi sə cep bə nsàap nwìi səmok sə̀ yà' ka fɛɛŋ yeŋ.>> Wo à dʉk vɛ'nə bʉ̀ʉsə̀ Pol à sə tsòho bə liŋ Jisòs, nə ye mvəsə̀ ŋgòlòkok mvwe' kpʉ. ");
INSERT INTO yam_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","À ye vɛ'nə fana, wo to lo Pol mvwe' kwe' Àripagù wèŋ. À kə̀ dzèŋ fo', wo dʉk fa nà' dʉk də, wo sə dzəm də wo rɛɛŋ bə nsàp yəyə'rə̀ nə̀ fi nə̀ nà' sə cèp bə zeŋ nè'nə. ");
INSERT INTO yam_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Bum mok sə̀ nà' sə tsòho sə nsàap bum sə̀ wo ka yà' yàwo riŋ yuk, fana wo sə dzəm ŋgòrì də yà'a yà'sə da lɛ? ");
INSERT INTO yam_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Wo sə dʉk vɛ'nə ŋga bwe nze Atèn, nə ye bə bʉ̀ʉ sə̀ wo à coho və̀ fo' və̀ə wèŋ pwe' à sə dzəmgə̀ ŋgòcuuŋ, nə sə yu'rə, nə sə tsoho nzu sə̀ wo yu' tsə yà' ghà nə. ");
INSERT INTO yam_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pol à lòkok təəŋ mʉtsə̀ mvwe' kwe' Àripagù wèŋ nə. Yi dʉk fa yà'wèŋ dʉk də, <<Wèŋ bʉ̀ʉ Atèn, mʉ̀ sə ye də weŋ fa ntʉm awèŋ bohònwìi awèŋ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ye də mʉ̀ sə tsə̀' vɛ'nə bʉ̀ʉsə̀ mʉ̀ ànə sə gi ca, nə sə kʉk ja'a kɛ'ca bum sə̀ wèeŋ kùksəgə̀ yà', fana mʉ̀ ye kàm mòk nə̀ wo còm mbwa dʉk də, <BohòNwì nə̀ wo ka yi riŋ.> Mʉ̀ sə tsə̀' rɛŋsə fa weŋ yè'e yi nə̀ wèŋ a sə kùksə yi ŋga wèŋ ka yi riŋ nə. ");
INSERT INTO yam_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nwì nə̀ yi à gʉ̀ nzeŋgòŋ, nə ye bə bum sə̀ yà'a ca pwe', yi Tà nə̀ mʉbu bə nə̀ sə nze yi. Yi kà mʉnə ndap sə̀ wo ci fa nwì wèŋ yà' bə bo cugə̀. ");
INSERT INTO yam_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ka də yi sə jamə yu səmok sə̀' də aco ŋwè gʉ fa yi sə̀' yeŋ. A vɛ'nə bʉ̀ʉsə̀ a yi nə̀ yi fagə̀ bwìŋ pwe'fo' yòŋsə̀, nə ye bə yà lòoŋ sə̀ bwìŋ dzəm yà'. ");
INSERT INTO yam_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Yi à gʉ̀ fis nsàap bʉ̀ʉ sə̀ wo zəzok sə̀ wo cu mʉ nzeŋgòoŋ fɛɛŋ pwe' ndzənə ŋwə̀ nə̀ mò'fis. Yi à gàpsə ndʉ̀rə ŋgòŋ sə də nsàp bʉ̀ nè'e nə cum fɛŋ bə fa' yi. Yi à fʉ̀hʉ fa bòp lak nə̀ fòpwe' mvə̀k nje ŋgòcu sə̀' yi. ");
INSERT INTO yam_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yi ànə gʉ yè'sə vɛ'nə ya bwìiŋ lap yi. Də mvə̀'nə̀ wo sə lap yi, kàmòk wo nə sə lap ghasə kɛ'cà yi, fana nə ye yi. Nwì ka ye sə̀sap bohòvesùwèŋ lɛ yeŋ. ");
INSERT INTO yam_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ŋwə̀ nəmòk à dʉk də, <A cugə̀ə, nə sə cum ŋwʉm, nə sə gihi kɛ' yè'sə bə ŋàaŋ sə̀ ye.> Yà' mègù sə̀' mʉ mvə̀'nə̀ ŋgàa còm ŋwàk awèŋ mok à còm dʉk də, <Vèes yàvès sə̀' bwe ye.> ");
INSERT INTO yam_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nə yeè nə dʉk də, mvə̀'nə̀ vesùwèeŋ bwe Nwì, a kà də vesùwèeŋ tsərə də yi səsə co yumok sə̀ bwìŋ a jə ŋkərə̀ àwo ŋgògʉ̀ bə ntɛŋ kè lìs àlɛ tsərə̀. ");
INSERT INTO yam_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Yusə̀ bwìŋ à sə gʉ̀ mantombì ŋga wo ka riŋ fana, Nwì a jə càsə yà'sə pwe' co yusə̀ wà. Nə̀ ŋga'a nè'e fana yi sə cèp bohòndàaŋwè nə̀ yi fòpwe' ŋgòkupsə, nə bwi fa bʉp ye ŋkwɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Yè'sə vɛ'nə bʉ̀ʉsə̀ yi a fʉ̀hʉ nòŋsə nùmbu nə̀ yi nə sak nzeŋgòŋ nə pwe'fo'. Səsak ènə nə ye bə zìnə. Yi nə sak bə cùu ŋwə̀ nə̀ yi a cok nòŋsə nà'. Yi a nìtsə̀' dʉk də yè'sə zìnə bə mandzə̀ nə̀ də yi a lòkoksə ŋwə̀ ènə mvwe' kpʉ.>> ");
INSERT INTO yam_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pol ànə cep ncèp nə̀ də ŋgòlòkok mvwe' kpʉ fana bʉ̀ʉ sə̀ wo à sə yu'rə sə ga'a bòp ba. Mok à sə ywì'lə yi co ləm, fana mok dʉk yàwo də, wo sə dzəm ŋgòyuk mali yà' sə̀mok. ");
INSERT INTO yam_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Fana Pol me'rə mvwe' kwe' nə. ");
INSERT INTO yam_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Bʉ̀ʉ mok à be'lə ma nə̀ nje, nə dzəm bohòJisòs. Mòk nə̀ yi à ye mʉŋgorə̀ bʉ̀ʉ sə̀ wo à dzəm sə wèŋ à ye Diyonisù, nə̀ yi à ye ŋwə̀ə kwe' Àripagù nə. Ŋwà mòk à ye sə̀' nə̀ liŋ ye Dàmaris, nə ye bə mok wèŋ sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ghà nə̀ Pol ànə cep mesə mʉ kwe' Àripagù anə, fana kà mok sàp yi yè'e nə lo mvwe' lak Korè. ");
INSERT INTO yam_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","À kə̀ dzèŋ fo', yi tseŋ ŋwə̀ Jus mòk fo'. Liŋ ye à ye də Àkwilà. Wo à dzə yi mvwe' lak Poŋtòs. Ŋwə̀ ènə bə ŋgwe ye Prìsiliyà à mè'rə nzeŋgòŋ Italì, nə və fa'nə sə̀' ghà anə, ŋga ka ntòsàp. Wo ànə yè'e və bʉ̀ʉsə̀ ŋkum Rumà nə̀ wo à sə to yi dʉk də ŋkum Kladiyòs à dʉk də bʉ̀ʉ Jus sə̀ wo cu mvwe' lak Rumà pwe', wo lo. Pol ànə kə ye wo. ");
INSERT INTO yam_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Bə yà'wèŋ à sə cu mvwe' mò'fis bʉ̀ʉsə̀ wo à sə gʉ̀ sə̀' nsàp fàk nə̀ mò'fis. Bə yà'wèŋ à sə gʉ̀hʉ sèeŋ nsàap tàp mok, wo to yà' də teèŋ, nə sə ko mbàm fo'. ");
INSERT INTO yam_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nùumbu dzə̀ à sə ye pwe', Pol lo mʉnə ndap pìriyà bʉ̀ʉ Jus wèŋ. Yi sə lo mbwa ŋgòkə̀ fenə nə cep rɛŋsə bum bə bʉ̀ʉ Jus nə ye bʉ̀ʉ Gris wèŋ də yà'wèeŋ riŋ də yusə̀ yi sə cèep sə zìnə. ");
INSERT INTO yam_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ghà nə̀ Silàs bə Timatì ànə me'rə və nzeŋgòŋ Màsìdoniyà, nə kə tseŋ Pol, fana yi me'rə bo fàak ye sə, nə sə tsoho megu ye mok ncèp nə. Yi sə tsoho fa bʉ̀ʉ Jus wèŋ dʉk də, Jisòs nə Ŋkum ŋgà gèm bwìŋ nə̀ Nwì à dʉk də yi nə tum nə. ");
INSERT INTO yam_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Wo bɛŋ yusə̀ yi sə cèep sə, nə to kɛ'ca liŋ ye bʉp, fana yi satop sə̀' nə̀bʉp, nə sə kɛ'sə mak mfə̀mfə sə̀ ndzənə cə̀ək ye. Yi sə cep bohòyà'wèŋ dʉk də, <<Wèeŋ bisə-a, wèŋ bɛŋ tu awèŋ. Bo yàm ka ca yeŋ. Ye jəŋ nə̀ ŋga'a nè'e nə lo mantombì, mʉ nə sə tsoho fa ncèp nə mok bohòbʉ̀ lakmvum.>> ");
INSERT INTO yam_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Yi à ye'e, nə sə kə cum mʉnə ndap ŋwə̀ nəmòk nə̀ liŋ ye də Titiyòs Jostòs. Ŋwə̀ ènə à ka ŋwə̀ə Jus yeŋ, nə sə kuksə Nwì. Ndap ye nə à təə kəp lògù ŋgʉ ndap pìriyà bʉ̀ʉ Jus wèŋ vɛ'. ");
INSERT INTO yam_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ŋwə̀ nəmòk nə̀ yi à ye ŋwə̀ nə̀ mantombì mʉnə ndap pìriyà bʉ̀ʉ Jus nə, nə̀ liŋ ye à ye Kripòs, à dzəm bohòTà Jisòs bə ndap ye pwe'. Bʉ̀ʉ səmok sə̀' sə̀ mvwe' lak Korè anə ŋkʉ̀ʉŋntɛ̀ŋ à yuk ncèp nə̀ Nwì nə sə̀', nə dzəm, fana nə baptɛsə. ");
INSERT INTO yam_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","À ye nùmbu mòk nə̀ ndzəmə̀ Pol ye lo, fana Tà Jisòs tsok fa yi ndzənə lo sə dʉk də, <<Kà də wu wəp dʉk. Sə tsoho mali, nə kà teŋsə̀. ");
INSERT INTO yam_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Bʉsə̀ mʉ tə vesù. Ŋwə̀ nəmòok nə kà mandzə̀ nə̀ ŋgògʉ̀ wu bʉp tse'. A vɛ'nə bʉ̀ʉsə̀ bwìiŋ mvwe' ntʉm lak ènə ŋkʉ̀ʉŋntɛ̀ŋ sə̀ wo bʉ̀ʉ am.>> ");
INSERT INTO yam_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ànə ye vɛ'nə, Pol cum fo' ŋkà'ŋgòŋ mò'fis bə bwes. Yi sə yə'rə fa bʉ̀ʉ sə̀ fo' sə ncèp nə̀ Nwì. ");
INSERT INTO yam_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ghà nə̀ wo ànə koksə Galiyòdə yi Govənòmvwe' nzeŋgòŋ Gris nə fana bʉ̀ʉ Jus wèŋ kum ni', nə ko lo Pol mʉ kot bohòyi. ");
INSERT INTO yam_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Wo dʉk də, Ŋwə̀ nè'e yi sə làp mandzə̀ ŋgògʉ̀ də bwìiŋ sə kuksə Nwì nsàp mandzə̀ nə̀ lʉ̀k sə kà vɛ'nə dʉk. ");
INSERT INTO yam_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol à sə də yi muk cù ŋgòcèep, fana Galiyòdʉk fa bʉ̀ʉ Jus sə wèŋ dʉk də, <<Anə ye-a dʉk də ŋwə̀ ènə fɛ̀ŋ yumok bwɛ̀rɛ mʉ̀ ko ntʉm nə yu'rə fa weŋ bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Fana wèŋ sə jə və̀ fa mʉ nzak ncèep cù, nə ye bə liŋ bum awèŋ sə̀ wèeŋ toho kɛ'càgə̀ yà', nə ye fe'lə bə lʉ̀ʉk awèŋ wèŋ. Mʉ nə kà yàm yà'sə sak, wèeŋ du, nə kə sak yà' sə wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yi bɛ' fis yà'wèŋ mʉ kot anə. ");
INSERT INTO yam_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Wo pwe' à kə̀ ko ŋwə̀ nəmòk nə̀ liŋ ye à ye də Sostinì. Yi à ye ŋwə̀ nə̀ mantombì mʉnə ndap pìriyà bʉ̀ʉ Jus wèŋ nə yi. Wo à ləp yi sə ntòmbi kot nə. Galiyòkà mbɛŋ nə̀ mbɛŋ kom lok. ");
INSERT INTO yam_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol à cu mali bə bwema sə̀ wo à dzəm sə wèŋ mvwe' lak Korè anə mʉnə nùumbu ŋkʉ̀ʉŋntɛ̀ŋ. Ànə geŋ, yi bə Prìsiliyà nə ye Àkwilà wèŋ me'rə bwema sə, nə kə ni ŋgwes nə̀ nà' à sə lòmvwe' nzeŋgòŋ Sìriyà. À kə̀ dzèŋ mvwe' lak Sèncerì yi su tu ŋgòkə̀ nìŋ də yi rusə kə̀kàk ye nə laŋ. ");
INSERT INTO yam_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Wo à kə̀ dzèŋ mvwe' lak Efesò, fana Pol bə Prìsiliyà nə ye Àkwilà wèŋ ga'a fo'. Yi lo ye sə mʉ ndap pìriyà bʉ̀ʉ Jus wèŋ, nə sə kə ce'e fenə mbwa bə bʉ̀ʉ Jus sə wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wo à dʉk yi dʉk də bə yà'wèeŋ cum fo' sə̀sap ntɛ̀ŋ, fana yi kà dzəm. ");
INSERT INTO yam_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mvə̀'nə̀ yi à sə lòsə, yi dʉk fa bʉ̀ʉ sə wèŋ dʉk də, <<A ye-a ŋga Nwì fa ŋàŋ, fana mʉ̀ bwi və fe'lə sə̀mok, nə kə ye weŋ.>> Yi à cèp wes vɛ'nə, fana yi ni ŋgwes, nə lo yuye. ");
INSERT INTO yam_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Yi à kə̀ wɛ̀s mvwe' lak Sìsàriyà, nə ca lo Jòrosalèm, nə kə cepsə bʉ̀ʉ cos nə̀ fo'. Yi à cèpsə wes yà'wèŋ, fana yi ye'e lo mvwe' lak Antiyòk. ");
INSERT INTO yam_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Yi ànə cum fo' ghàr, fana yi lo nə ca mvwe' nzeŋgòGàlesiyà bə Frijìyà, nə sə tipsə gʉŋsə lo bʉ̀ ŋgàa yù mandzə̀ Jisòs pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ŋwə̀ Jus mòk à ye, wo to yi də Àpolò. Yi à və̀, nə sə cum mvwe' lak Efesòŋga wo à dzə yi mvwe' lak Àlèsandìriyà. Yi à rì ŋgòcèp bòŋsə cù, nə riŋ ŋwàk Nwì sə̀' nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Yi à ye ŋwə̀ nə̀ wo à tsə̀' rɛŋsə fa yi mandzə̀ nə̀ Tà Jisòs. Yi à fa ntʉm ye pwe' ŋgòsə cèp, nə sə yə'rə fa bwìŋ bum sə̀ yà' sə kùm liŋ Jisòs pwe'fo' zìnə. Yumok ye ləlɛ sə̀', nə̀ dʉk də yi à rì mègù bàptɛ nə̀ Jon. ");
INSERT INTO yam_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yi à sə cèp mʉnə ndap pìriyà bʉ̀ʉ Jus wèŋ, nə kà wʉə koksə̀ lok. Prìsiliyà bə Àkwilà à yuk mvəsə̀ yi à sə cèp, fana wo to lo yi nda'à wo. À kə̀ dzèŋ fo', wo tsoho rɛŋsə tsə'rə wesə fa nà' mandzə̀ Nwì yəyərə̀. ");
INSERT INTO yam_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ànə geŋ, Àpolònə dʉk də yi dzəm ŋgòlòmvwe' nzeŋgòŋ Gris, fana bʉ̀ ŋgàa yù mandzə̀ Jisòs mvwe' lak Efesòwèŋ tɛsə yi bə mandzə̀ nə̀ də wo à còm tipsə gèsə lòbwema sə̀ mvwe' nzeŋgòŋ Gris sə wèŋ ŋwàk dʉk də Àpolòo kə̀ dzèeŋ, yà'wèŋ jəŋ nà' bə̀boŋ. Yi ànə kə dzeŋ, fana bum sə̀ yi à sə cèp yà', à tɛsə bwema sə wèŋ wùriŋ. Wo ànə dzəm bʉ̀ʉ bòvə̀m nə̀ Nwì nə. ");
INSERT INTO yam_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Mvə̀'nə̀ yi à sə cèp bə ŋàŋ wùriŋ sə, fana bə bʉ̀ʉ Jus wèŋ fenə, yi ghak yà'wèŋ mʉ lisə̀ bwìŋ jəja. Yi sə taŋ fis ndzənə ŋwàk Nwì dʉk də Jisòos Ŋkum ŋgà gèm bwìŋ nə̀ Nwì à dʉk də yi nə̀ tum vèsə nə. ");
INSERT INTO yam_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Àpolòànə ye mvwe' lak Korè, fana Pol gi ca mvwe' ntònzeŋgòànə, nə kə dzeŋ mvwe' lak Efesò. À kə̀ dzèŋ fo', yi ye bʉ̀ʉ mok sə̀ wo à sə yù mandzə̀ Jisòs. ");
INSERT INTO yam_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Yi fek yà'wèŋ dʉk də, yà' ànə tse' Yòŋsə̀ nə̀ Rərɛŋ nə ghà nə̀ yà'wèŋ ànə dzəm Jisòs laŋ àlɛ? Wo dʉk fa yi dʉk də, <<Vès ka yàvès liŋ yumok dʉk də Yòŋsə̀ nə̀ Rərɛŋ yuk yuk.>> ");
INSERT INTO yam_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pol fek fe'lə wo də, <<Ànə geŋ wèŋ bàptɛsə nsàp bàptɛ yà?>> Wo də ànə ye bàptɛ Jon. ");
INSERT INTO yam_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Yi tsok fe'lə fa yà'wèŋ dʉk də, <<Bàptɛ Jon ànə ye də a bàptɛsə bʉ̀ʉ sə̀ wo à kupsə ntʉm bə bʉp awo sə̀ wo à sə gʉ̀ʉ. Yi Jon nə à tsòho fa bʉ̀ʉ Izùrɛ wèŋ də yà'wèeŋ dzəm bohòŋwə̀ nəmòk nə̀ nà' sə və̀ maŋkwɛ̀ɛŋ yi. Ŋwə̀ nə̀ yi à sə dʉk də wo dzəm nà' nə à ye Jisòs.>> ");
INSERT INTO yam_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Wo ànə geŋ də wo yuk vɛ'nə, fana wo bàptɛsə fe'lə sə̀mok mʉnə liŋ sə̀ Tà Jisòs. ");
INSERT INTO yam_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pol naaŋ fa yà'wèŋ bo, fana Yòŋsə̀ nə̀ Rərɛŋ nə və bohòwo. Wo sə cep ncèep lak mok sə̀ bwìŋ ka yà' riŋ, nə sə tsoho bum mok sə̀ Nwì à sə tsə̀' fa wo. ");
INSERT INTO yam_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wo à ye lòoŋ fo' co bwìŋ hum-ncòp-ba. ");
INSERT INTO yam_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol à lòmʉmvwe' ndap pìriyà bʉ̀ʉ Jus wèŋ. Mʉnə ŋwʉ tɛ', yi sə cep bə bʉ̀ʉ sə wèŋ, nə kà wəp lok. Yi à fenə bə yà'wèŋ, nə sə lap mandzə̀ ŋgògʉ̀ də wo dzəm də yusə̀ yi tsə̀' fa yà'wèŋ bə gaŋ ŋkum Nwìi zìnə. ");
INSERT INTO yam_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Fana mok wèŋ gʉŋ tu nə kà dzəm. Wo cep bum sə̀ bʉp bə ma nə̀ Tà Jisòs ŋga kwe' bwìŋ sə yuk pwe'. Pol jəŋ bʉ̀ʉ sə̀ wo à sə yù mandzə̀ Jisòs sə bə yà'wèŋ lo. Nùumbu pwe' bə yà'wèŋ sə kə cep bum mʉmvwe' ndap mòk nə̀ ghaŋ nə̀ Tìranù à tse' nà' yi. ");
INSERT INTO yam_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Wo à sə gʉ̀hʉ vɛ'nə tə̀tè kə dzeŋ lùumŋgòŋ ba. Fana bʉ̀ʉ sə̀ wo à cu mvwe' nzeŋgòƐsiyà, bʉ̀ʉ Jus bə sə̀ wo bʉ̀ lakmvum wèŋ pwe' à yuk ncèp nə̀ Tà Jisòs. ");
INSERT INTO yam_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nwì à sə gʉ̀ càsə nsàap maŋgəŋgèeŋ mok sə̀ yà' à ka vɛ'nə ye yuk ndzə bohòPol. ");
INSERT INTO yam_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nsàp nə̀ co wo sə jəŋ megu mok gà cə̀k nə̀ yi yìsgə̀ ndùrə̀ bə zeŋ, nə kə jwɛŋ ŋgàa yiyaŋ bə zeŋ, fana wo gʉŋ. Yòŋsə̀ə sə̀ bʉp sə tesə gɛsə ndzə ni'ì wo sə̀'. Wo à sə jə cə̀ək fàak ye sə̀ yi à sə ni tse', nə sə gʉ bə zeŋ sə̀' vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bʉ̀ʉ Jus mok à ye sə̀ wo à sə gìhi kɛ' càa, nə sə bɛ' fis fa bwìŋ yòŋsə̀ə sə̀ bʉp sə̀'. Wo à yè ŋgòmùmsə ja'a də wo sə bɛ' fis yà' bə liŋ Tà Jisòs. Wo dʉk fa yòŋsə̀ə sə̀ bʉp sə dʉk də, <<Mʉ̀ cèp bə ŋàaŋ Jisòs nə̀ Pol sə tsòho nà'a.>> ");
INSERT INTO yam_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ŋwə̀ə Jus nə̀ ŋgà fa satikà' mòk nə̀ ghaŋ à ye nə̀ liŋ yee Sivà. Yi à tse' bwe mbəmbam sàmba sə̀ wo à sə gʉ̀hʉ vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Yòŋsə̀ nə̀ bʉp nə à cèp fəsə fa wo dʉk də, <<Mʉ̀ rì Jisòs, nə riŋ Pol sə̀', a wèŋ ndà?>> ");
INSERT INTO yam_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ŋwə̀ nə̀ yi à tse' yòŋsə̀ nə̀ bʉp ndzə ni'ì yi nə à ko wo nsàp ŋgwap lʉ̀ mok vɛ'ɛ, nə lʉ ghak wo. Wo à carə tesə mʉ nda'à yi anə bə mvwe' bə mvwe'. Wo à ye sə̀' jì cə̀k ŋga yà' sàha wes pwe'. ");
INSERT INTO yam_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bʉ̀ʉ Jus nə ye sə̀ wo bʉ̀ lakmvum sə̀ wo à sə cu mvwe' lak Efesòà yuk yu yè'sə pwe'. Wʉə à ko wo nə̀bʉp. Bwìŋ à kùksə nə sə wəp ghaha lo liŋ Tà Jisòs mantombì. ");
INSERT INTO yam_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bwìŋ wùriŋ sə̀ wo à dzəm Jisòs wèŋ à tesə və̀ mvwe' bwìŋ, nə sə cep fis bʉp sə̀ wo à gʉ̀ jəja. ");
INSERT INTO yam_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bwìŋ ŋkʉ̀ʉŋntɛ̀ŋ sə̀ wo à sə fegə̀ ŋgam wèŋ à jə benə və̀ ŋwàak ŋgam awo mvwe' mò'fis, nə tɛŋ yà' ŋga bwìŋ sə yə pwe'. Wo à ta be'lə mbàam ŋwàak sə pwe', yà' kə dzeŋ bàam mbàm ncùhù hum tàŋ. ");
INSERT INTO yam_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Njo bum sə̀ yà' à sə gʉ wùriŋ yè'sə fana, ncèp nə̀ Tà Jisòs nə à sə yuhu lòmantombì, nə sə yam gʉŋ ghaha ghaha. ");
INSERT INTO yam_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ghà nə̀ bum yè'sə ànə ca wes me vɛ'nə pwe', fana Pol də yi nə lo gì. Yi dʉk də yi nə ca mvwe' nzeŋgòŋ Màsìdoniyà bə Gris, nə kə dzeŋ Jòrosalèm. Yi dʉk sə̀' dʉk də yi kə̀ cu fo', fana yi kə dzeŋ mvwe' lak Rumà sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ànə ye vɛ'nə, fana yi tumsə lo Timatì bə Ɛ̀ratòs mvwe' nzeŋgòŋ Màsìdoniyà. Bʉ̀ʉ sə̀ ba yè'sə à ye bʉ̀ʉ sə̀ wo à sə tɛsə kɛ'cà yi bə bum. Yà'wèŋ à lòo, yi sə cum mali ye sə mvwe' nzeŋgòƐsiyà ŋkuŋ. ");
INSERT INTO yam_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nè'e ŋga'a mvə̀k nə̀ ŋkəŋkɛs ŋgə' mòk nə̀ bʉp à tesə mvwe' lak Efesòanə njo mandzə̀ ma nə̀ Tà Jisòs. ");
INSERT INTO yam_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ŋgà tɛŋlàm nəmòk à ye nə̀ liŋ ye à ye də Dìmàtiròs. Yi à sə tɛ̀ɛŋ fʉ̀'rə bum mok co ndap mòk nə̀ ghaŋ nə̀ nà' à ye ndap nwì nəmòk, nə̀ wo togə̀ nwì nə də Dìyanà. Yi à gʉ̀ nà' bə ntɛŋ nəmòk nə̀ wo togə̀ nà' də sivà. Yusə̀ yi à gʉ̀ sə à sə jə və fa bʉ̀ʉ sə̀ wo à sə fàak sə wèŋ swe' wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ànə geŋ, yi to benə yà'wèŋ pwe' mvwe' mò'fis. Yi to bə bʉ̀ʉ səmok sə̀ nsàp fàak awo sə̀' co sə̀ mok wèŋ sə. Yi dʉk fa yà'wèŋ dʉk də, <<Bʉ̀ʉ am, wèŋ rì də vesùwèeŋ tse' mègù mbàam yàvès bə nsàp fàk nə̀ vesùwèeŋ gʉ̀gə̀ nè'e. ");
INSERT INTO yam_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Fana aco wèŋ yuk nə ye yà'wèeŋ bə lis awèŋ sə̀' nsàp yu nə̀ ŋgà' nə̀ wo to yi də Pol nè'e sə gʉ̀ʉ. Yi sə tsòho kɛ' fa bwìŋ dʉk də, nwìi sə̀ bwìŋ gʉ̀ yà' bə bo ka nwì yeŋ lok nə̀ kɛ̀' mò'fis. Bwìŋ a bʉ̀ʉŋ, nə dzəm ncèp ye nə wùriŋ. Bʉ̀ʉ sə̀ wo dzəm ncèp ye nə, wo mvwe' lak Efesòfɛnə, nə ye bwi ma nə̀ ghaŋ mvwe' nzeŋgòƐsiyà pwe'. ");
INSERT INTO yam_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Yusə̀ mʉ̀ sə yə, a də yà'a nə jəŋ və ŋgə'ə də fàak avès yè'sə nə tse' liŋ sə̀ bʉp. Nə sə yəə̀ŋ nə sə̀' dʉk də ndap nwì avès nə̀ ghaŋ Dìyanà nə kà fàk mok sə̀ tse' fe'lə̀. Mvəsə̀ wo jəgə̀ yi co yu nə̀ yum, yè'e nə bʉp. Ŋga yi nwì nə̀ bʉ̀ʉ Ɛsiyà pwe' nə ye bə nzeŋgònə pwe'fo' kùksə mègù yi.>> ");
INSERT INTO yam_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Mvə̀'nə̀ kwe' bʉ̀ nə à yuk ncèp ènə, fana ntʉm yaaŋ wo. Wo jok, nə ye ŋgòfurə dʉk də, <<Dìyanà nə̀ mvwe' lak Efesòo nwì nə̀ ghaŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mfuŋ à lòbə ntòlak nə pwe'. Bʉ̀ʉ sə wèŋ tap ko bʉ̀ʉ səmok ba sə̀ wo à sə gìgə̀ bə Pol, nə jəŋ lo wo mvwe' nzʉ̀ə̀ nə̀ bʉ̀ lak sə̀ fo' sə kə benəgə̀ fo'. Bʉ̀ʉ sə̀ ba yè'sə, à ye Gayòs bə Àritakò. Wo à ye bwe lak mvwe' nze Màsìdoniyà. ");
INSERT INTO yam_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol à dzəm də yi lo ŋgòkə̀ teŋsə bʉ̀ʉ sə wèŋ bə tu ye, fana bʉ̀ ŋgàa yù mandzə̀ Jisòs wèŋ kà vɛ'nə dzəm. ");
INSERT INTO yam_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ŋge'e Pol mok sə̀ wo à yə bʉ̀ʉ sə̀ ghaŋ mvwe' lak yà'sə wèŋ à tum fa yi ntirə̀. Wo à tirə fa nà' dʉk də, <<Kwəkwè', kà si yo mvwe' nze ènə kə̀ nì vèsə̀.>> ");
INSERT INTO yam_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Bum yè'sə ànə ye co kwe' awo nə sə jam jamə vɛ'ɛ. Bòp bʉ̀ mòk à sə fu sə̀' yusə̀ zok, ma mòk sə fuŋ sə̀' yusə̀ zok. Ànə ye vɛ'nə bʉ̀ʉsə̀ bòp ma nə̀ ghaŋ à ka yusə̀ yà' à jə benə və̀ wo fo' sə̀' riŋ. ");
INSERT INTO yam_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ŋwə̀ nəmòk à ye fo' nə̀ liŋ ye à ye də Àlèsandà, fana bʉ̀ʉ Jus wèŋ tes yi mantombì də nà'a cep fa wo. Àlèsandà gʉ bo də bwìiŋ teŋsə cù, ya yi taŋ njo mʉtsətsə'rə bwìŋ. ");
INSERT INTO yam_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bʉ̀ʉ sə wèŋ ànə ye riŋ də nà'a ŋwə̀ə Jus, fana wo pwe'fo' sə fuŋ benə megu mok yusə̀ mò'fis. Wo à sə furə dʉk də, <<Dìyanà nə̀ mvwe' lak Efesòo nwì nə̀ ghaŋ.>> Wo sə furə vɛ'nə tə̀tè haŋ, nə kà nə̀nàk teŋsə̀. ");
INSERT INTO yam_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ànə geŋ, ŋgà còm bum nə̀ mvwe' lak yà'sə à gʉ̀ bʉ̀ʉ sə wèŋ teŋsə cùu sə. Yi yeto ŋgòcèp dʉk də, <<Wèŋ bʉ̀ʉ Efesò, ndàaŋwè pwe' riŋ dʉk də a nòŋsəgə̀ ndap nə̀ ghaŋ nə̀ nwì Dìyanà nè'e ntʉm lak Efesò, bə lìs ye nə̀ rərɛŋ nə̀ nà' à gbʉ̀ tsə mʉbu. ");
INSERT INTO yam_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kaco ŋwə̀ nəmòk dʉk də yè'sə mvwès yeŋ. Bòco wèŋ ko tsoŋ ntʉm, nə kà yumok co bʉ̀ʉ sə̀ wo ka ŋkərə̀ tse' gʉ̀. ");
INSERT INTO yam_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Wèŋ jə və̀ bʉ̀ʉ yè'e fɛɛŋ wèŋ, ŋga wo ka yumok mʉ nda'à nwì àvès yə fis. Wo ka liŋ ye sə̀' bʉpsə. ");
INSERT INTO yam_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","A ye-a də Dìmàtiròs bə ŋgàa fàak ye wèŋ tse' nzak bə ŋwə̀ nəmòk, fana kot cu yo bə ŋgàa sak nzak sə sə̀'. Yà'a mvwe' sə̀ co ŋwè tsok yusə̀ yà' sə yaaŋ yi bə mòk fo'. ");
INSERT INTO yam_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nə ye sə̀' dʉk də ŋga wèŋ dzəm-a yumok sə̀ zok, fana ye də wo kə cep yà' mvwe' kwe' bʉ̀ nə̀ ghaŋ nə. ");
INSERT INTO yam_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bʉsə̀ yà'a nə bʉp bohòvesùwèŋ. Wo nə ta vesùwèŋ bɛ̀ŋ bə nsàp gham cù nə̀ ghaŋ nə̀ nà' ye ntinə ènə. Kaco ŋwə̀ nəmòk tsok njo mòk bə̀boŋ nə̀ nsàp cù nè'e tesə bʉ̀ʉ zeŋ yeŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Yi ànə cep wes vɛ'nə, fana yi də wo sam. ");
INSERT INTO yam_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ghà nə̀ wo ànə teŋsə ŋgògham cùu sə, fana Pol to benə bʉ̀ʉ sə̀ wo à sə yù mandzə̀ Jisòs wèŋ mvwe' mò'fis. Yi à tipsə wo bə̀boŋ, nə cepsə wo də yi lòo, nə ye'e me'rə lo mvwe' nzeŋgòŋ Màsìdoniyà. ");
INSERT INTO yam_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Yi à cà mvwe' ŋgòoŋ yà'sə, nə sə tipsə bʉ̀ʉ sə wèŋ bə ncèep cùu sə̀ bə̀boŋ wùriŋ, fana nə ca lo və mvwe' nzeŋgòŋ Gris. ");
INSERT INTO yam_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Yi à cu mvwe' lak yè'sə, ŋwə̀ tɛ'. Yi ànə sə gʉhʉ də yi lo mvwe' nzeŋgòŋ Sìriyà. À ye sə̀' ghà nà'nə nə̀ yi à yuk dʉk də bʉ̀ʉ Jus wèŋ sə làp mandzə̀ ŋgòzə yi. Ànə geŋ yi də bògha' də yi bwi foho ca mvwe' nzeŋgòŋ Màsìdoniyà sə̀mok. ");
INSERT INTO yam_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pol nə bə Sòpatà mo Piròs nə̀ mvwe' lak Berà à lòbəbɛ'. Bʉ̀ʉ mok sə̀ bə yà'wèŋ à lòsə̀' à ye Àritakòbə Sèkudù sə̀ lak àwo Tètàlonikà. Gayòs nə̀ lak yee Debè. Nə ye fe'lə Timatì bə bʉ̀ʉ Esiyà mok sə̀ liŋ awo də Tìkikòs bə Tròfimù. ");
INSERT INTO yam_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Wo à lòmantombì, nə kə tək ves mvwe' lak Truwà. ");
INSERT INTO yam_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Vès à cu fo' nùumbu sàmba, ghà nə̀ ŋkà'a zʉ brɛd jì yis à càa, fana vès ni jəŋ ŋgwes mvwe' lak Filìpi. Vès à gì nùumbu tàŋ, nə kə tseŋ wo mvwe' lak Truwà anə. Vès à cu fo' ntɛŋ mò'fis. ");
INSERT INTO yam_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nùmbu nə̀ tsok rɛŋgə̀ ye Sondè à dzèeŋ, fana vès benə və mvwe' mò'fis ŋgòkə̀ zʉ Losopà. À ye nə̀ nconùm. Pol à cèp bohòbʉ̀ʉ sə wèŋ, nə sə tsoho mali fo' tə̀tè kə dzeŋ tsətsə'rə̀ tsok ŋga yi sə tsòho malìi. Ànə ye vɛ'nə bʉ̀ʉsə̀ də tsok rɛŋ, yi me'rə yà'wèŋ, nə lo. ");
INSERT INTO yam_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Laàm à ye mvwe' sə̀ vès à cu kwe' sə wùriŋ. À ye mvwe' rum ndap nə̀ ma mʉ tuhù. ");
INSERT INTO yam_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mʉwà'ŋwə̀ nəmòk à ye fo' nə̀ liŋ yee Ìyutikù. Yi à cu ma mʉ wundù, nə sə yu'rə mvəsə̀ Pol sə cèep sə. Mvəsə̀ Pol à sə tsòho nə kà teŋsə tohò, fana lo ko Ìyutikù nə. Lo sə sə ghaha ghaha tə̀tè yi ànə dzəm lo sə, fana yi ye'e gbʉ tsoŋ mbwa. Yi à gbʉ tsoŋ tè bə rum nə̀ tɛ' mʉbu kə dzeŋ sə nze. Wo à kə̀ te' yi ŋga yi kpʉ laŋ. ");
INSERT INTO yam_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ànə geŋ Pol suhu tsoŋ mbwa, nə kə gbʉ naaŋ nà' mʉ ni'ì. Yi fìrə bo, nə wumsə gesə nà' ndzə ŋgùu yi, nə dʉk də, <<Kà jìk, yi cu ŋwəm.>> ");
INSERT INTO yam_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Fana yi bwi kok lo fe'lə mʉ mvwe' rum nə̀ mʉ tuhù nə sə̀mok. Yi bək zʉ bɛŋ. Yi ànə cep bə yà'wèŋ sə̀sap haaŋ nùm kok, fana Pol bɛ' mandzə̀ nə lo. ");
INSERT INTO yam_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wo à jə fəsə lòmʉwà'ŋwə̀ nə lak ŋwəm. Wo à kwa wù kà fʉ̀k. ");
INSERT INTO yam_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Vès à ni ŋgwes, nə lo mantombì ŋgòlòmvwe' lak Asòs. Yà'a mvwe' sə̀ vès à ye ŋgòkə̀ tsèŋ Pol, ya yi ni ŋgwes nə ye sə̀'. Yi ànə dʉk vɛ'nə bʉ̀ʉsə̀ də yi à sə gì lòye fo' sə kùhu. ");
INSERT INTO yam_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Vesiwèŋ ànə kʉrə Asòs anə, fana vesiwèŋ ni ŋgwes mok bəbɛ', nə lo mvwe' lak Mitilù. ");
INSERT INTO yam_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Vès à gì bə ŋgwes tə̀tè tsok à rɛŋ, vès kə dzeŋ mvwe' lak Ciyòs. À cà gù nùmbu mò'fis, vès lo mvwe' lak Samòs. Tsə' mok à rɛŋ bwi, vès kə dzeŋ Mìlitù anə. ");
INSERT INTO yam_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol ànə dzəm də yi cà mvwe' lak Efesòsə ŋgwesə̀ ya yi kà mvə̀k mvwe' nzeŋgòƐsiyà kə̀ càsə̀. Yi à sə gʉ̀ nə̀nàk ya yi kə dzeŋ Jòrosalèm. Nə ye sə̀' də ŋga mandzə̀ ye-a yo, yi kə ni kʉrə tsooŋ gu nùmbu nə̀ bʉ̀ʉ Jus wèŋ à sə bə̀ŋsə bum. ");
INSERT INTO yam_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pol à cu mvwe' lak Mìlitù, nə tirə gesə lo ntirə̀ mvwe' lak Efesòdə bʉ̀ ŋkwàha bwìŋ mʉnə cos nə̀ fo' kə tseŋ yi. ");
INSERT INTO yam_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Wo ànə kə dzeŋ, fana yi dʉk fa yà'wèŋ dʉk də, <<Wèŋ rì nsàp ncu àm nə̀ mʉ̀ à sə cu ghà nə̀ mʉ à ye vesùwèŋ. Ye jəŋ nùmbu nə̀ mʉ̀ à kə̀ nə̀ to kù mvwe' nzeŋgòƐsiyà. ");
INSERT INTO yam_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mʉ à sə gʉ̀ fàak am co ŋgà fàk Tà Jisòs, nə kà ni' sə nɛ̀. Ghà nəmòk à sə ye, mʉ̀ sə fàk bə ndzəp lis sə̀' ŋga bum sə gʉ bʉp wùriŋ. Yè'sə ànə ye vɛ'nə bʉ̀ʉsə̀ bʉ̀ʉ Jus wèŋ à sə làp mandzə̀ də wo nisə mʉ ŋgə'. ");
INSERT INTO yam_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Wèŋ rì tse' sə̀' dʉk də yusə̀ ya' à ye co yà' tɛsə weŋ pwe', mʉ̀ à sə kà nə̀ mò'fis swìhìgə̀. Yè'sə à sə ye vɛ'nə ghà nə̀ mʉ̀ à sə tsòho fa weŋ, nə sə yə'rə weŋ mvwe' bwìŋ bə nda'à wèŋ mwè. ");
INSERT INTO yam_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mʉ̀ à sə tsòho fa bʉ̀ʉ Jus nə ye sə̀ wo bʉ̀ lakmvum sə̀'. Mʉ̀ sə dʉk fa wo dʉk də wo jəŋ ŋkərə̀, nə bwi fa bʉp awo ŋkwɛ̀ŋ, nə bʉʉŋ və bohòNwì. Nə ye sə̀' dʉk də wo dzəm tse' bohòJisòs nə̀ yi Tà àvès. ");
INSERT INTO yam_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nə̀ ŋga'a nè'e, mʉ̀ sə gʉ̀ tsə mègù yusə̀ Yòŋsə̀ nə̀ Rərɛŋ sə cèep, fana mʉ̀ nə sə lònə Jòrosalèm. Mʉ̀ ka yusə̀ yà'a nə kə gʉ mʉ fo' riŋ. ");
INSERT INTO yam_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nə̀ mò'fis nə̀ mʉ̀ rìi dʉk də, Yòŋsə̀ nə̀ Rərɛŋ nə tsə̀' fa mʉ dʉk də ndapndzəm bə ŋgə' sə tək mʉ mvwe' ntʉm lak nə̀ fòpwe'. ");
INSERT INTO yam_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Fana yusə dʉk də mʉ̀ ka yòŋsə̀ àm co yumok sə̀ yà' tse' fàk bohòmʉ̀ mok jəŋ fe'lə. A vɛ'nə ya ŋga mʉ gʉ wes fàak sə̀ Tà Jisòs nə à fa mʉ də mʉ gʉ sə. Fàak sə, a ŋgòtsə̀' rɛŋsə fa bwìŋ Ntirə̀ nə̀ Bə̀boŋ nə̀ nà'a bòvə̀m nə̀ Nwì. ");
INSERT INTO yam_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","<<Mʉ̀ a gìhi kɛ' cà mʉtsətsə'rə wèŋ pwe', nə sə tsoho fa weŋ mvə̀'nə̀ gaŋ ŋkum Nwì cu. Mʉ̀ sə dʉk də ŋwə̀ nəmòok mʉtsətsə'rə wèŋ nə̀ yi nə ye fe'lə yuk si am bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Fana mʉ̀ sə tsə̀' rɛŋsə fa weŋ ntirə̀ nè'e jəja paamm, də a ye-a ŋga ŋwə̀ nəmòk bisə mʉtsətsə'rə wèŋ fana bo am kà ca ye. ");
INSERT INTO yam_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mʉ̀ ànə tsòho fa weŋ yusə̀ Nwì sə dzəm pwe'fo', nə kà mòk swìhì. ");
INSERT INTO yam_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Wèeŋ jəŋ ŋkərə̀ bə tu awèŋ, nə ye bə bʉ̀ʉ sə̀ Yòŋsə̀ nə̀ Rərɛŋ nə a fa nòŋsə wo ndzə bohòwèŋ. Wèeŋ ye co ganakù' bohòbʉ̀ʉ cos Nwì. Cos nə̀ yi à gʉ̀ nà' bʉʉŋ nje bʉ̀ʉ ndʉəm mo ye nə. ");
INSERT INTO yam_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mʉ̀ rì də ghà nə̀ mʉ lo wes yàm, fana ŋgàa yə'rə̀ fa bwìŋ bum mvwèes nə və mʉtsətsə'rə wèŋ co nàam sə̀ bʉp və̀ wo. Wo və co nàam sə̀ bʉp vɛ'nə, fana wo kà wèŋ sə̀ wèŋ a yə'rə zìnə nə mè'rə̀. ");
INSERT INTO yam_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mvə̀ək nə və nə̀ bòp bʉ̀ àwèŋ mòok nə sə ci' mvwès, ŋgòbòrə lòbʉ̀ʉ sə̀ wo à sə yù mandzə̀ Jisòs ma njàwo. ");
INSERT INTO yam_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Wèeŋ sə so, nə sə tsərə tse' sə̀' dʉk də mʉ̀ à yə ŋgə' ŋkʉ̀ʉŋntɛ̀ŋ ŋgòyə'rə weŋ. Mʉ̀ à yə'rə weŋ pwe' bə ntʉm nə̀ manziŋ wùriŋ vɛ'nə nùm bə ndzəm mʉnə lùumŋgòŋ tɛ'. ");
INSERT INTO yam_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nə̀ ŋga'a nè'e, mʉ me'rə fa weŋ ndzə bohòNwì də yi sə jəŋ ŋkərə̀ bohòwèŋ yi, nə niŋ fa weŋ bòvə̀m ye. Yi tse' ŋàaŋ sə̀ ŋgògʉ̀ wèeŋ kuk lo mantombì, nə se weŋ bə ghàha ye sə̀ yi a nòŋsə fa bohòbʉ̀ʉ ye sə̀ yi à cù' rɛŋsə wo. ");
INSERT INTO yam_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mʉ̀ ka yu ghàha ŋwə̀ nəmòk co mbàm-ɛ̀' kè cə̀k-ɛ̀' waŋ yuk. ");
INSERT INTO yam_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Wèŋ rì yàwèŋ sə̀' də ves ŋge' am wèŋ a sə tse' yusə̀ vès dzəm pwe' ŋga bo am yè'e a fà' wo. ");
INSERT INTO yam_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mʉ̀ a nìŋ tsə̀' fa weŋ bə nsàp mandzə̀ nə̀ fòpwe' laŋ dʉk də vès tse' ŋgòfàk bə ŋàŋ mʉmvə̀' ènə, ŋgòtɛsə ŋgàa jì ŋàŋ. Vèes tsərə tse'gə̀ ncèp nə̀ Tà Jisòs à cèp bə cùu ye də, <Kwəkwa gha' cà ŋgòfa nə noŋsə ŋgòjəjə.> >> ");
INSERT INTO yam_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol ànə cep wes, fana bə yà'wèŋ lòoŋ təəŋ sə nze bə tumfərə, nə gʉ pìriyà. ");
INSERT INTO yam_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Wo à sə warə pwe'fo' mvə̀'nə̀ wo sə ko wumsə gèsə yi ndzə ŋgùu wo, nə sə cepsə yi də nà'a geŋ bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ntʉm à rwì' wesə wo bə ncèp nə̀ yi à cèp dʉk də yà'a nə kà si ye mok yə yuk fe'lə nà'a. Fana bə yà'wèŋ à tsoŋ lo mà mvwe' ŋgwes nə bəbɛ'. ");
INSERT INTO yam_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ànə geŋ, vès cepsə wo də wo cum bə̀boŋ, nə lo yu avès. Vès à to sənə ŋgwes, nə sə lo gu rərəŋ tè vès kə dzeŋ mvwe' lak Kos. Tsok à rɛŋ, vès kə dzeŋ mvwe' lak Rodès. Vès à càsə fa'nə, nə lo mvwe' lak Pàtarà. ");
INSERT INTO yam_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","À kə̀ dzeŋ fo', vès ye ŋgwes mòk nə̀ nà' à sə lòmvwe' nzeŋgòŋ Fònisiyà. Vès à ni nà', nə lo. ");
INSERT INTO yam_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Vès à kə̀ dzèŋ mvwe' sə̀ co vès ye gesə lo lak Sɛpròfana vès bʉʉŋ lo ma zʉ mvwe' nzeŋgòŋ Sìriyà. Vès à tesə sənə ŋgwes nə mvwe' lak Tayà. Yè'e sə̀' mʉmvwe' nə̀ ŋgwes nə à lòŋgòkə̀ fis bum sə̀ yi à bə̀k və̀ sə sə̀' fo'. ");
INSERT INTO yam_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Vès à tsèŋ bʉ̀ʉ səmok sə̀ wo à sə yù mandzə̀ Jisòs sə̀' fo'. Vesiwèŋ à cu ntɛŋ mò'fis. Wo à tsə̀' fa Pol bə ŋàaŋ Yòŋsə̀ Nwì nə dʉk də nà'a kà Jòrosalèm anə lò. ");
INSERT INTO yam_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mvə̀k nə̀ njàvès ŋgòcu venəwèŋ à mèe, fana vès ca bɛ' mandzə̀, nə lo yu avès. Wo à tesə vesiwèŋ mʉ ntòlak anə pwe'fo', wo bə yep awo nə ye bwe awo sə̀', vesiwèŋ pwe' à kə̀ təəŋ bə tumfərə ŋgʉ ndzəp anə mvwe' ŋgwansa, nə gʉ pìriyà. ");
INSERT INTO yam_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Fana vès cepsə ndàaŋwè pwe' də a nə̀ yenə. Vès ni yàvès ŋgwes. Wo bwi lo yàwo lak. ");
INSERT INTO yam_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Vès à mè'rə lak Tayà, fana gì àvès sə lo mali mantombì tè vès kə dzeŋ mvwe' lak Tolemɛ̀s. Vès à cèpsə bwema sə̀ wo cu fa'nə, nə cum vesiwèŋ nùmbu mò'fis. ");
INSERT INTO yam_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tsok à rɛŋ, vès yè'e sə̀' ŋkuŋ nə kə dzeŋ mvwe' lak Sìsàriyà. À kə̀ dzeŋ fo', vès lo mvwe' ndap Filìp nə̀ yi à ye fàŋgəri. Vès à nòoŋ vesiwèŋ. Yi à ye sə̀' mòk mʉtsətsə'rə bʉ̀ʉ sə̀ sàmba sə̀ wo à cokfis wo mvwe' lak Jòrosalèm sə. ");
INSERT INTO yam_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yi à tse' bwe wàhaŋgwɛ̀ŋ kwè sə̀ wo pwe'fo' à ka ndum tse'. Wo à sə tsòho bum sə̀ Nwì à sə tsə̀' fa wo yi. ");
INSERT INTO yam_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Vès ànə cum fo' nùumbu ŋkʉ̀ʉŋntɛ̀ŋ, fana ŋgà tsòhòbum Nwì mòk nə̀ liŋ yee Àgabòs və ye sə̀'. Yi à ye'e və̀ mvwe' nzeŋgòŋ Jùdiyà. ");
INSERT INTO yam_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yi à kə̀ yə ves, nə jəŋ korə Pol, nə swi' kùu ye bə bo ye bə zeŋ. Yi cep dʉk də, <<Yè'e yusə̀ Yòŋsə̀ nə̀ Rərɛŋ nə cèp dʉk də, <Bʉ̀ʉ Jus sə̀ wo cu Jòrosalèem nə swi' ŋwə̀ nə̀ yi tse' korə nè'e mʉ mvə̀k nè'e. Wo swi' wes mè yi, fana wo jəŋ yi, nə fa bohòbʉ̀ lakmvum.> >> ");
INSERT INTO yam_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Vès ànə yuk yu yè'sə, fana vès nə ye bə bʉ̀ʉ mok sə̀ fo' lɛŋ Pol vɛ'ɛ də yi kà Jòrosalèm anə mok gə̀. ");
INSERT INTO yam_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Yi cep fəsə ye dʉk də, <<Hàva', wèŋ sə gʉ̀ yè'sə yà vɛ'nə? Wèŋ sə wa, nə sə gesə fa mʉ wʉə sə ntʉʉ̀ bʉ̀ʉ yà? Mʉ kə̀kʉrə̀ co wo kə kiŋ mʉ Jòrosalèm anə. A dzəm mʉ kpʉ bʉ̀ʉ liŋ Tà Jisòs, yumok kà bʉp.>> ");
INSERT INTO yam_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Mandzə̀ nə̀ co vès gʉ yi dzəm cùu avès à ye bʉ̀ə̀, fana vès me'rə yi. Vès dʉk megu mok dʉk də, <<Bum pwe' ndzə bohòNwì.>> ");
INSERT INTO yam_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Vès ànə casə mʉmvə̀k mòk fo', fana vès te'e benə bum avès, nə ye'e ŋgòlòJòrosalèm anə. ");
INSERT INTO yam_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","À lòbe'lə vès ŋgàa yù mandzə̀ Jisòs mok sə̀ mvwe' nzeŋgòŋ Sìsàriyà. Wo à jə lòves mvwe' ndap ŋwə̀ nə̀ vès ànə ye ŋgòcu nda'à yi. Liŋ yee Nasòŋ. Liŋ lak yee Sɛprò. Yi à dzəm bohòJisòs haaŋ mantombì ntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Vès à kə̀ dzèŋ Jòrosalèm, bwema sə̀ fo' sə wèŋ à cèpsə ves bə̀boŋ wùriŋ. ");
INSERT INTO yam_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Tsok à rɛŋ, vès Pol wèŋ à lòŋgòkə̀ yə Jem. Bʉ̀ ŋkwàha bʉ̀ʉ sə̀ mʉ cos sə pwe' à ye fo' sə nze. ");
INSERT INTO yam_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol à cèpsə wo, nə tsoho fa yà'wèŋ yusə̀ Nwì a gʉ̀ yà' bə fàak sə̀ yi à sə gʉ̀ʉ pwe'fo'. Yusə̀ yi à tsòho sə à ye bum sə̀ Nwì à gʉ̀ bohòbʉ̀ lakmvum wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Wo ànə yuk wes me, fana wo pwe' kuksə Nwì. Fana wo dʉk fa Pol dʉk də, <<Moma àvès, aco wù ye yòsə̀' bə lis yo. Bʉ̀ʉ Jus lòmʉnə ncùhù wùriŋ sə̀ wo à dzəm bohòJisòs, nə sə noŋsə lʉ̀k Musì sə̀' pap. ");
INSERT INTO yam_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bwìŋ à tsòho fa wo yumok bə liŋ yo laŋ. Wo à tsə̀' wo dʉk də wù sə yə'rə fa bʉ̀ʉ Jus sə̀ wo cu lakmvum də wo me'rə mak lʉ̀ʉk Musì. Wo dʉk də wù sə tsòho fa yà'wèŋ də wo kà bwìŋ tu mbəmbam sə kom fa, nə kà bum lak bʉ̀ʉ Jus wèŋ sə̀' gʉ̀. ");
INSERT INTO yam_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Wo nə yuk tsoŋ li dʉk də wù və̀ laŋ. Aco a gʉ yè'sə va? ");
INSERT INTO yam_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Vèes tsok fa wu yusə̀ vès tsəm də aco wù gʉ. Bʉ̀ʉ mook fɛɛŋ bwìŋ kwè sə̀ wo a kàk Nwì. ");
INSERT INTO yam_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Aco wù yuŋ lo wo nə kə gʉ sə̀' mvə̀'nə̀ wo sə kə̀ gʉ̀ bum sə̀ ya wo ye rərɛŋ mʉ lisə̀ Nwì sə. A gə̀ə, wù lak lok yusə̀ wo tse' ŋgòlà'a sə pwe' sə bàa wù, ya ŋga wo nə tse' mandzə̀ nə̀ ŋgòkə̀ sù tu awo sə. Wu gʉ-a vɛ'nə, fana ndàaŋwè pwe' nə riŋ dʉk də yusə̀ wo à yuk bə liŋ yòsə ka zìnə yeŋ. Wo nə dʉk də wù sə yù yòsə̀' lʉ̀ʉk Musì sə. ");
INSERT INTO yam_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nə ye də vès à còm fa bʉ̀ lakmvum sə̀ wo à dzəm Jisòs yà'a ŋwàk. Vès à còm tsə̀' mègù fa wo nja dʉk də vès a dzəm mvwe' mò'fis də wo kà bum rùm zʉ. Nə kà ndʉəm kè nàm nə̀ nà' kpʉ bə ndʉəm ye ndzə ni'ì yi sə̀' zʉ. Nə ye sə̀' də wo kà sàhà kè nto àlɛ' ko.>> ");
INSERT INTO yam_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pol à dzəm, nə jəŋ bʉ̀ʉ sə wèŋ. Tsok à rɛŋ bə yà'wèŋ gʉ bum sə̀ ya wo ye rərɛŋ mʉ lisə̀ Nwì sə, nə lo mʉ ndap Nwì nə̀ ghaŋ nə. Yi à lòmbwa ŋgòkə̀ tsə̀' nòŋsə nùumbu sə̀ yà'a nə ca ŋkuŋ nùmbu nə̀ wo nə fa fəfa mʉnə tu bʉ̀ʉ yè'sə kə dzeŋ. ");
INSERT INTO yam_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nùumbu sə̀ sàmba sə à də a me, fana bʉ̀ʉ Jus mok tesə və mvwe' nze Ɛsiyà, nə kə ye Pol mʉ ndap Nwì nə̀ ghaŋ nə. Bʉ̀ʉ yè'sə caŋsə fa bʉ̀ʉ sə̀ fo' sə pwe' ncəncàŋ wo ko Pol. ");
INSERT INTO yam_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Wo sə fuŋ dʉk də, <<Bʉ̀ʉ Izùrɛ, wèeŋ və kə tɛsə ves. Nè'e ŋwə̀ nə̀ yi gìhi kɛ'gə̀ ma nə̀ fòpwe', nə sə yə'rə fa bwìŋ dʉk də, bʉ̀ʉ Izùrɛ bə lʉ̀ʉk Musì, nə ye ndap Nwì nə̀ ghaŋ nə ka yumok yeŋ nə. Yi jə və bʉ̀ lakmvum, nə kə nisə̀ nə yà' mʉ ndap Nwì nə̀ ghaŋ nə. Mvəsə̀ yi gʉ̀ vɛ'nə, ye də yi gʉ̀ bʉpsə mvwe' sə̀ yà'a rərɛŋ sə yè'sə laŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Wo à dʉk vɛ'nə bʉ̀ʉsə̀ wo à yə nà' bə mʉŋwə̀ə Efesòmòk mʉ ntòlak anə. Wo tsəm ŋgwàaŋ də yi kə̀ nisə nà' mʉ mbwa anə laŋ. Liŋ ŋwə̀ ànə à ye də Tròfimù. ");
INSERT INTO yam_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Lak sə pwe' à curə wʉk. Bwìŋ kə caŋ baaŋ mvwe' mò'fis. Wo ko Pol, nə soŋ fis yi mʉ ndap Nwì nə̀ ghaŋ nə, nə lok ncùu ndap nə. ");
INSERT INTO yam_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bʉ̀ʉ sə wèŋ à sə làp mandzə̀ də wo zə Pol. Sə̀ ghà nà'nə, ntirə̀ lo bohòŋkum sojà bʉ̀ʉ Rumà wèŋ dʉk də cəcuŋ ni mʉ ntòla'à Jòrosalèm pwe' laŋ. ");
INSERT INTO yam_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ŋkum sojà nə lokok gu kɛ̀' mò'fis. Yi to jəŋ bʉ̀ʉ sə̀ mantombì nə ye sojàa mok wèŋ bə yà'wèŋ tsooŋ lo mvwe' sə̀ bʉ̀ʉ sə wèŋ cu sə. Bʉ̀ʉ sə ànə ye yi bə sojàa sə, fana wo kà Pol mok ləp fe'lə̀. ");
INSERT INTO yam_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ŋkum sojà nə à gə̀ mvwe' sə̀ Pol à ye sə, nə ko nà'. Yi fa ŋàŋ dʉk də wo tasə Pol nə bə kwaŋ ba. Fana yi fek bʉ̀ʉ sə də, <<Ŋwə̀ ènə ndà lɛ?>> Nə fek sə̀' də, <<Nà' gʉ̀ bʉpsə yà lɛ?>> ");
INSERT INTO yam_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Fana bʉ̀ʉ mok sə̀ mʉnə ŋgo bʉ̀ʉ sə wèŋ sə cep furə yusə̀ zok, bòp ma mòk sə fuŋ yàwo sə̀' yusə̀ zok. Jijipsə̀ à ye fo' vɛ'ɛ wùriŋ. Bum à jip nsàp nə̀ ŋkum sojà nə kà yusə̀ yà'a nə ye sə pap rì tse'. Ànə ye vɛ'nə, ŋkum sojà nə dʉk bʉ̀ʉ ye wèŋ də yà'a jəŋ lo Pol mvwe' ŋəŋap ndap mòk nə̀ wo à ci tes fa sojà wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Wo à jə kok lògù Pol moòm ghʉ̀k vɛ'ɛ, nə dzeŋ mvwe' mbùhu kùu sə̀ wo à bom ŋgòkok lòmʉ nda'à anə, fana wo le' bək yi mʉ ŋkambə̀ək, bʉ̀ʉsə̀ bʉ̀ʉ sə̀ fo' sə à sə cəp ntʉm nə̀bʉp. ");
INSERT INTO yam_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Wo à sə ywɛ̀' və̀ màŋkwɛ̀ŋ dʉk də, <<A zə yi, a zə yi!>> ");
INSERT INTO yam_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Mvəsə̀ sojàa sə ànə sə dʉk wo nisə gesə Pol mʉmvwe' ŋəŋap ndap nə, fana Pol fek ŋkum sojà nə dʉk də aco yi cep yumok bohònà' àlɛ? Ŋkum sojà nə də, <<Kàmfìrə wù cèp rìgə̀ ncèep lak bʉ̀ʉ Gris. ");
INSERT INTO yam_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ye də wù ka ŋwə̀ə Ijìp nə̀ mʉ̀ sə tsəm də wu zeŋ nə yeŋ à? Bʉsə̀ yi ànə və ghà nəmòk fɛɛŋ, nə ye ndàŋ bə gomè nə̀ fɛn. Yi bək jəŋ lo màkìzaà ŋgəà bwìŋ ncùhù kwè.>> ");
INSERT INTO yam_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol à dʉk fa yi dʉk də, <<Mʉ ŋwə̀ə Jus. Wo à dzə mʉ mvwe' lak Tasònə̀ mvwe' Sìlisiyà. Lak sə bwìŋ rì yà' pwe'fo'.>> Fana yi lɛŋ ŋkum sojà nə dʉk də, <<Kwəkwè', fa mʉ-a mandzə̀ mʉ cep-a bohòbʉ̀ʉ yè'sə-ɛ̀.>> ");
INSERT INTO yam_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ŋkum sojà nə à fa yi mandzə̀ də nà'a cep. Pol à lòkok təəŋ mvwe' yunŋkuu sə̀ wo à bom ŋgòkok lòmʉ nda'à sə, nə sə gʉ bo ye də bwìiŋ teŋsə cù. Bʉ̀ʉ sə à teŋsə, fana Pol cep bohòwo bə ncèep bʉ̀ʉ Jus wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pol à yèto dʉk də, <<Bwe tɛ̀' am nə ye tɛ̀' am wèŋ, wèeŋ yu'rə fa mʉ mvəsə̀ mʉ̀ sə fì'lə ncùu am bohòwèŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Mvəsə̀ wo à yuk ŋga yi sə cep bohòwo bə ncèep bʉ̀ʉ Jus fana ŋwə̀ nə̀ mò'fis kà mok kwis fe'lə̀. Pol sə cep lo mantombì. ");
INSERT INTO yam_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Yi sə dʉk də, <<Mʉ yè'e ŋwə̀ə Jus. Wo à dzə mʉ mvwe' lak Tasònə̀ mvwe' nze Sìlisiyà. Mʉ̀ kuk Jòrosalèm fɛn. Gàmaliyà à yə'rə mʉ yi. Wo à yə'rə fa mʉ lʉ̀ʉk tàcicii avès vɛ'ɛ làaŋ. Mʉ̀ à fa ni' àm ŋgòfàk bohòNwì sə̀' mvə̀'nə̀ wèŋ sə̀ wèeŋ fɛɛŋ ntinə yè'e a fa ni' awèŋ. ");
INSERT INTO yam_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Fana mʉ̀ à yeŋsə bʉ̀ʉ sə̀ wo à sə yù mandzə̀ Jisòs ènə ŋgə' sə̀' wùriŋ. Mʉ̀ à tʉ̀ksə zə mok sə̀' njo mandzə̀ ènə. Mʉ̀ à ko nisə mbəmbam bə bə̀ba wèŋ ndapndzəm sə̀' bʉ̀ʉ zeŋ. ");
INSERT INTO yam_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ŋkum Ŋgàa fa satikà' bə kaŋsurù pwe' rì də yusə̀ mʉ̀ sə cèp yè'sə zìnə. Mʉ̀ ànə fek wo, fana wo à còm fa bwe tɛ̀' avès bʉ̀ʉ Jus sə̀ wo cu Dàmaskù ŋwàk, nə fa mʉ. Mʉ̀ lo mbwa ŋgòkə̀ ko bʉ̀ʉ sə̀ wo à sə yù mandzə̀ ènə. Mʉ̀ à sə lòŋgòkə̀ tsòoŋ wo bə kwaŋ, nə jəŋ və wo Jòrosalèm fɛŋ ŋgòyeŋsə wo ŋgə'. ");
INSERT INTO yam_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","<<Mvəsə̀ mʉ̀ à kʉəp lòDàmaskù anə, ŋga nùum co maràŋ, mʉ̀ ye ŋga marɛŋ mòk rɛɛŋ tsə mʉbu vɛ'ɛ bʉ̀əmm. Nà' rɛɛŋ dzooŋ mvwe' sə̀ mʉ̀ à təəŋ sə pwe'. ");
INSERT INTO yam_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mʉ̀ coho gbʉ sə nze nə yuk ŋga ŋgì ŋwə̀ nəmòk sə cèep. Ŋgì ŋgə̀ŋgàŋ sə dʉk də, <Sol, Sol, wù sə fa mʉ ŋgə' vɛ'nə bʉ̀ʉ yà?> ");
INSERT INTO yam_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mʉ̀ fek gesə yàm sə̀' dʉk də, <A wùu ndà Tà?> Yi cep fəsə fa mʉ də, <A mʉ̀ʉ Jisòs nə̀ mvwe' lak Nazàrɛ nə̀ wù sə yeŋsə yi ŋgə' nə.> ");
INSERT INTO yam_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bʉ̀ʉ sə̀ vesi wèŋ à ye fo' sə, à yə marɛŋ nə sə̀', nə kà ŋgì ŋwə̀ nə̀ nà' à sə cèp bohòmʉ̀ nə yuk. ");
INSERT INTO yam_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mʉ̀ fek fe'lə sə̀mok dʉk də, <Tà, mʉ gʉ va?> Fana Tà nə dʉk fa mʉ dʉk də, <Lòkok mʉtsə̀, nə ni lo mvwe' lak Dàmaskù. Wu kə̀ dzèŋ fo', fana wo nə tsoho fa wu bum pwe' sə̀ Nwì a fʉ̀hʉ nòŋsə də wu gʉ.> ");
INSERT INTO yam_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Lis à loho mʉ njo marɛŋ nə̀ nà' à rɛŋ nə. Bʉ̀ʉ sə̀ vesi wèŋ à ye fo' sə wèŋ à dàsə lòmʉ mʉ ntòlak Dàmaskù anə mok dàsə. ");
INSERT INTO yam_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","<<Ŋwə̀ nəmòk ànə ye, liŋ yee dʉk də Ànàniyàs. Yi à sə wəpgə̀ Nwì, nə sə noŋsə lʉ̀ʉk avès bə̀boŋ. Bʉ̀ʉ Jus sə̀ mvwe' lak Dàmaskù pwe' à sə jəgə̀ yi co ŋwə̀ nə̀ zìnə wù kà fʉ̀k. ");
INSERT INTO yam_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Yi à və̀ kə̀ tsèŋ mʉ. Yi təəŋ kok ŋgʉ ni'ì mʉ̀, nə dʉk fa mʉ dʉk də, <Mo tɛ̀' am Sol, ye fe'lə bum sə̀mok.> Yi ànə sə dʉk wesə vɛ'nə ntɛ̀ŋ, fana lis am sə muhu. Mʉ̀ ye bum sə̀mok, nə kʉk yi. ");
INSERT INTO yam_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Yi dʉk fe'lə fa mʉ dʉk də, <Nwì tàcici avès à cokfis wu də ya wu riŋ yusə̀ yà' cu sə və̀ə yi ŋgògʉ̀ʉ. Yi cokfis wu sə̀' də ya wu ye ja'a Jisòs, ŋgà fàk ye nə̀ rərɛŋ bə lis, nə yuk ŋgì ye mvəsə̀ yi sə cèep bə cùu ye. ");
INSERT INTO yam_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Bʉsə̀ a nə ye wù nə̀ ŋgòtsòho fa bwìŋ pwe' yusə̀ wù a yə nə yuk sə kum liŋ ye. ");
INSERT INTO yam_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nə yeè nə dʉk də cu fe'lə yè'sə yà sə̀mok ɛ? Lòkok ya wo baptɛsə wu, nə to liŋ Tà Jisòs, ya Nwìi cuk mak gɛsə bʉp yo.> ");
INSERT INTO yam_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","<<Ànə geŋ, mʉ̀ bwi foho lo yu am Jòrosalèm. Ghà nə̀ mʉ̀ ànə sə gʉ pìriyà mʉnə ndap Nwì nə̀ ghaŋ nə, fana mʉ̀ ye yumok co lo vɛ'ɛ. ");
INSERT INTO yam_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mʉ̀ ye ndzə loòanə ŋga Tà Jisòs sə dʉk fa mʉ dʉk də, <Gʉ̀ʉ nə tesə lo gɛsə mvwe' lak Jòrosalèm fɛŋ nə nə̀nàk, bʉ̀ʉsə̀ bʉ̀ʉ sə fɛɛŋ nə kà yusə̀ wu nə tsok fa wo bə liŋ am dzəm.> ");
INSERT INTO yam_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mʉ̀ cep fəsə fa yi yàm sə̀' dʉk də, <Tà, wo riŋ vɛ'ɛ bə̀boŋni dʉk də mʉ̀ à sə lògə̀ mʉnə ndap pìriyàa bʉ̀ʉ Jus wèŋ, nə sə ko ləp bʉ̀ʉ sə̀ wo dzəm wu. ");
INSERT INTO yam_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nə ye sə̀' də ghà nə̀ wo à zə Stefè nə̀ yi à sə tsòho bum sə̀ yi à yə bə liŋ yò, mʉ̀ à ye sə̀' fo'. Mʉ̀ à sə dzəm sə̀' də a bə̀boŋ ŋgòzə yi vɛ'nə. Mʉ̀ à sə kʉ̀k fa bʉ̀ʉ sə̀ wo à sə zə yi sə lis bə cə̀ək awo mʉ̀.> ");
INSERT INTO yam_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Mʉ̀ ànə dʉk wes vɛ'nə, fana Tà nə dʉk mʉ də, <Gèŋ ntɛ̀ŋ, bʉ̀ʉsə̀ mʉ nə tumsə lo wu mvwe' sə̀sap, də yi bohòbʉ̀ lakmvum wèŋ.> >> ");
INSERT INTO yam_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bʉ̀ʉ sə wèŋ à sə yu'rə gù sə̀' gəe'. Pol ànə cep nə̀ dʉk də yi sə lo bohòbʉ̀ lakmvum, fana bʉ̀ʉ sə wèŋ kɛ' ŋgùŋ nsàp nə̀ co ntu' loho bwìŋ. Wo sə dʉk də, <<Wèeŋ zə gɛsə lo yi fo', wèeŋ zə yi zə, yi ka tse' ŋgòcu ŋwəm.>> ");
INSERT INTO yam_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wo à sə torə, nə sə wʉŋsə kɛ' cə̀ək awo mʉtsə̀, nə sə ŋwɛ' sɛsə gesə mfə̀mfə mʉbu nduk. ");
INSERT INTO yam_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ŋkum sojà bʉ̀ʉ Rumà wèŋ nə à tsə̀' fa bʉ̀ʉ ye wèŋ də yà'a lok swihi Pol mʉmvwe' ndap nə̀ wo lokgə̀ bwìŋ mbwa nə. Yi à dʉk yà' sə̀' də yà'a ləp nà' bə ŋkwɛ̀s ya nà'a tsok njo nə̀ bwìŋ sə torə nà' ləlà nə. ");
INSERT INTO yam_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Wo ànə kiŋ wes yi də ya wo ləp, fana Pol cep yumok bohòŋkwà' ŋwə̀ sojà nə̀ yi tə fo' nə. Yi à fek nà' dʉk də, <<Lʉ̀k sə dʉk də aco wu ləp ŋwə̀ nə̀ yi mègù yəyərə̀ co mo lak Rumà ŋga wo ka nzak ye də yi gbʉ̀ nzak àlɛ ntòsak à?>> ");
INSERT INTO yam_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ŋkwà' ŋwə̀ nə à yuk vɛ'nə, fana yi bwi foho lo bohòŋkum sojà nə. À kə̀ dzèeŋ, yi fek nà' dʉk də, <<Wù sə də wu gʉ yè'e yà? Ŋwə̀ ènə yi ŋwə̀ə Rumà.>> ");
INSERT INTO yam_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Fana ŋkum sojà nə lo bohòPol, nə fek nà' də, <<Tsok fa mʉ-a zìnə yo, wu ŋwə̀ə Rumà à?>> Pol dzəm də, <<Ŋ̀.>> ");
INSERT INTO yam_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ŋkum sojà nə dʉk fa Pol də, <<Mʉ yè'e sə̀' mòk. Mʉ̀ à làk mbàm wùriŋ ŋkuŋ nə ye mòk.>> Pol dʉk fa nà' də yi ye mòk bʉ̀ʉsə̀ wo à dzə yi, yi ye mo lak fo'. ");
INSERT INTO yam_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bʉ̀ʉ sə̀ wo à yè ŋgòfehe Pol bum səmok ànə yuk vɛ'nə ntɛ̀ŋ, wo bwi foho lo maŋkwɛ̀ŋ nyaap. Wʉə à ko ŋkum sojà nə mvəsə̀ yi à tsòoŋ nà' bə kwaŋ ŋga nà' mègù sə̀' yəyərə̀ bə mo lak Rumà. ");
INSERT INTO yam_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ŋkum sojà nə à sə dzəm tsə malì də yi riŋ tsoŋ njo nə̀ bʉ̀ʉ Jus wèŋ anə sə bɛŋ Pol bʉ̀ʉ zeŋ nə ŋkuŋ. Fana tsok à rɛŋ, yi fweŋ fis fa Pol kwaŋ sə. Yi to benə ŋgàa fa satikà' sə̀ ghaŋ wèŋ bə ŋgàa sak kaŋsurù pwe' mvwe' mò'fis. Ànə geŋ, yi fis tes Pol kù mantombìi yà'wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol sə kʉk tse' bʉ̀ʉ sə̀ mʉ kaŋsurù sə bə lis, nə cep fa yà'wèŋ yumok. Yi à dʉk də, <<Bwema am wèŋ, mʉ̀ ka məmərə̀ sə ntʉʉ̀ mʉ̀ bə ncu àm mantombìi Nwì tse' lok, kə dzeŋ nə̀ mʉ̀ tə ŋga'a nè'e.>> ");
INSERT INTO yam_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Yi ànə cep vɛ'nə, fana ŋkum ŋgàa fa satikà' nə̀ liŋ yee Ànàniyàs à dʉk fa bʉ̀ʉ sə̀ wo à təəŋ kok ŋgʉ ni'ì Pol nə də yà'a sam gesə fa nà' bo mʉ cùhù. ");
INSERT INTO yam_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pol dʉk fa nà' dʉk də, <<Nwìi nə ləp li wu, wù fop co mbàndap nə̀ wo yok basə nà' bə bwɛ̀ŋ wà. Wù cu yà'sə co ŋwə̀ nə̀ yi tse' ŋgòsak mʉ mvəsə̀ lʉ̀k sə dʉk, fana wù sə gʉ bʉpsə fe'lə lʉ̀ʉk sə sə̀' wù. Wù sə gʉ̀ bʉpsə yà' bə mandzə̀ nə̀ wù fa ŋàŋ də wo ləp mʉ.>> ");
INSERT INTO yam_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bʉ̀ʉ sə̀ wo à təə kok ŋgʉ ni'ì Pol sə fek yi dʉk də, <<Wù sə yàk ŋkum ŋgàa fa satikà' nə̀ yi ŋwə̀ə Nwì à?>> ");
INSERT INTO yam_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pol dʉk fa yà'wèŋ dʉk də, <<Bwema am wèŋ na, mʉ̀ anə ka riŋ də yi ŋkum ŋgàa fa satikà' yi riŋ. Ŋwàk Nwì sə cep sə̀' dʉk də, kà də ŋwèe to liŋ ŋwə̀ nə̀ yi tse' bwìŋ yi bʉp dʉk.>> ");
INSERT INTO yam_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol à yə də bʉ̀ʉ mok mʉ kaŋsurù anə à ye bʉ̀ʉ Faràsi, mok bʉ̀ʉ Sadùsi fana yi fuŋ fis də, <<Bwema am wèŋ, mʉ yè'e ŋwə̀ə Faràsi, nə ye sə̀' mo ŋwə̀ə Faràsi. Mʉ̀ cu yè' mʉnə dzə̀' nzak də bʉ̀ʉsə̀ mʉ̀ tsə̀' də bwìiŋ nə̀ lòkok mvwe' kpʉ sə̀mok.>> ");
INSERT INTO yam_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Yi ànə cep wes vɛ'nə ntɛ̀ŋ, fana bʉ̀ʉ Sadusì bə bʉ̀ʉ Faràsi sə wèŋ yeto ŋkʉ̀ə̀m, kwe' awo nə à gà'a mok ba. ");
INSERT INTO yam_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ànə ye vɛ'nə bʉ̀ʉsə̀ bʉ̀ʉ Sadusì wèŋ à sə dʉk yàwo dʉk də ŋwèe nə̀ kà mvwe' kpʉ lòkok yuk. Wo sə dʉk mok sə̀' də, masinjàa Nwì, nə ye bʉ̀ʉ sə̀ wo mègù yàwo yòŋsə̀ ka yeŋ. Bʉ̀ʉ Faràsi wèŋ à ye yàwo bòp bʉ̀ nə̀ wo à dzəm də bum sə̀ tɛ' yè'sə lòoŋfo' yo. ");
INSERT INTO yam_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Cùu sə̀ wo à sə gham fo' sə à yam ghaha lòmantombì. Ŋgàa yə'rə̀ bwìŋ lʉ̀ʉk mok à lòkok, nə cep vɛ'ɛ gʉgʉŋ. Wo à dʉk də, <<Vès ka fɛ̀ŋ nə̀ ŋwə̀ ènə gʉ̀ʉ ye. Kàmòk yòŋsə̀ nəmòk kè masinjà Nwì-è', a tsə̀' yi yumok laŋ zìnə.>> Ŋgàa yə'rə̀ bwìŋ lʉ̀k sə̀ wo à cèp yè'sə à ye yàwo ma bòp nə̀ bʉ̀ʉ Faràsi wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ŋkʉ̀ə̀m nə à kə̀ curə vɛ'ɛ wʉk. Ŋkum sojà nə wəp dʉk də aco yà' ŋwɛ' ci'lə Pol bə bo, fana yi dʉk fa sojàa ye wèŋ də yà'a tsoŋ geŋ ca mvwe' sə̀ bʉ̀ʉ sə tə sə, nə ko lo Pol kə lok swihi mvwe' ŋəŋap ndap sojà wèŋ nə. ");
INSERT INTO yam_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","À ye nòoŋ nùmbu ànə nə̀ ndzəmə̀ fana Tà Jisòs à kə̀ təəŋ kok ŋgʉ ni'ì Pol, nə dʉk fa nà' dʉk də, <<Ko ntʉm. Mvəsə̀ wù a tsə̀' fa bwìŋ liŋ am Jòrosalèm fɛɛŋ, wu nə kə tsok tsoŋ fa bʉ̀ʉ sə̀ mvwe' lak Rumà sə̀' mʉmvə̀k ànə.>> ");
INSERT INTO yam_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Tsok à rɛŋ, fana bʉ̀ʉ Jus mok wèŋ kə be'lə, nə swi' cù mpaaŋ. Wo à kɛ̀ŋ dʉk də wo nə kà yumok kə̀ cùhu wo gesə tse'ŋga wo zə Pol. ");
INSERT INTO yam_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Wo à ye co bwìŋ hum kwè sə̀ wo à swi' cù mvwe' mò'fis sə. ");
INSERT INTO yam_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ànə geŋ, wo lo, nə kə ye ŋgàa fa satikà' sə̀ ghaŋ bə bʉ̀ ŋkwàha bwìŋ wèŋ. Wo tsok fa yà'wèŋ dʉk də, <<Vès kɛ̀ŋ vɛ'ɛ nə̀ zìnə mvwe' mò'fis də vèes nə kà yumok kə̀ cùhu gèsə lok tè vès zə Pol. ");
INSERT INTO yam_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yusə ŋga'a dʉk də wèŋ kaŋsurù wèeŋ tirə gesə fa lo ŋkum sojà bʉ̀ʉ Rumà wèŋ də yi jəŋ tsoŋ və Pol. Tsòk basə fa yi də wèŋ dzəm ŋgòyuk yamsə boŋsə yumok mʉ cùhu Pol anə. Vèes nə fʉhʉ yàvès ŋgòzə yi ŋga yi ka fɛɛŋ ntòkə dzeŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mo njɛ̀'ɛ Pol mòk nə̀ ŋwə̀mbam à yuk bum sə̀ wo à sə dʉk də wo gʉ sə. Yi lo, nə kə ni mʉmvwe' ndap nə̀ wo lok tes Pol mbwa nə, nə tsok fa nà'. ");
INSERT INTO yam_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pol ànə yuk vɛ'nə, yi to ŋkwà' ŋwə̀ sojà nəmòk, nə dʉk nà' də, <<Jəŋ mʉwà'ŋwə̀ nè'e, nə jə lo fa yi bohòŋkum sojà. Yi tse' yusəmok sə̀ yi nə tsok fa nà'.>> ");
INSERT INTO yam_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ŋkwà' ŋwə̀ sojà nə ànə jə lo nà' bohòŋkum sojà nə. Ŋkwà' ŋwə̀ sojà nə dʉk fa ŋkum sojà nə dʉk də, <<Ŋgà ndapndzəm nə̀ liŋ yee Pol nà'a dʉk mʉ yi də mʉ jəŋ və fa wu mʉwà'ŋwə̀ nè'e. Yi də nà' tse' yusəmok ŋgòtsə̀' fa wu.>> ");
INSERT INTO yam_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ŋkum sojà nə ko jəŋ mʉwà'ŋwə̀ nə bə bo, bə nà' sooŋ təəŋ lo mok wo ba-nə̀-ba. Yi fek nà' də, <<Yusə̀ wù də wu tsok fa mʉ sə yà?>> ");
INSERT INTO yam_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Fana yi tsok nà' də, <<Bʉ̀ʉ Jus sə̀ ghaŋ wèŋ kì cù də a ye zòŋ wo dʉk wu də wu jəŋ və Pol mʉ kaŋsurù. Wo də kaŋsurù nə dzəm ŋgòyuk yamsə bum mok bə liŋ Pol nə. ");
INSERT INTO yam_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","A gə̀ə wù kà dzəm, bʉ̀ʉsə̀ bʉ̀ʉ sə̀ wo nə sə nooŋ swihi ŋgòsòyi wo cà bwìŋ hum kwè. Bʉ̀ʉ yè'sə kɛ̀ŋ dʉk də wo nə kà yumok kə̀ cùhu wo gesə lok tè tse'ŋga wo zə Pol. Wo sə tək mègù mok yusə̀ wu nə cep bʉ̀ʉsə̀ wo fʉ̀hʉ cu gu yàwo ŋga'a vɛ'nə.>> ");
INSERT INTO yam_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ŋkum sojà nə à dʉk fa mʉwà'ŋwə̀ nə də nà'a lo, nə dʉk də nà'a kà ŋwə̀ nəmòk də nà'a kə̀ tsə̀' fa yi yu yè'sə laŋ tsə̀' fa swì. ");
INSERT INTO yam_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ànə geŋ ŋkum sojà nə to ŋgàa fàak ye bwìŋ ba. Yi dʉk fa yà'wèŋ dʉk də, <<Wèeŋ lo kə jəŋ sojà ŋkʉ̀ ba ya wenə wèeŋ fʉhʉ ŋgòlòmvwe' nzeŋgòŋ Sìsariyà. Wèeŋ jəŋ sojàa sə̀ ŋgàa nàambà'rə̀ hum sàmba bə sə̀ ŋgàa kòŋ ŋkʉ̀ ba sə̀'. Wèeŋ fʉhʉ də wèeŋ nə lo nooŋ ntinə ndzəmə̀. Wèeŋ nə ye'e co ghà nə̀ bwìŋ sə nòoŋ tsə nze vɛ'ɛ. ");
INSERT INTO yam_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Làp fa Pol nàambà'rə̀ə mok, ya wèeŋ jəŋ lo yi gəe' kə fa bohòGovənòFelìs.>> ");
INSERT INTO yam_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ŋkum sojà nə à còm ŋwàk mòk mʉ mvə̀k nè'e də, ");
INSERT INTO yam_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","<<Sə còm mʉ̀ nə̀ liŋ am Kladiyòs Lìsiyàs. Mʉ̀ sə còm fa govənòFelìs. Tà mayumòk, mʉ̀ cèpsə wu bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bʉ̀ʉ Jus wèŋ a ko ŋgà' nè'e, nə də wo zə nà'. Ves sojàa am wèŋ lo, nə kə ko yi də wo kà yi zə, ŋga mʉ̀ yuk dʉk də yi ŋwə̀ə Rumà. ");
INSERT INTO yam_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mʉ̀ a dzəm ŋgòkə̀ rì tse' yusə̀ yi a gʉ̀ ŋkuŋ yà' yaaŋ wo, fana mʉ̀ jə lo yi sə kaŋsurù àwo. ");
INSERT INTO yam_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mʉ̀ lap ca, nə ye dʉk də yi ka yumok sə̀ co wo zə yi kè wo nisə yi ndapndzəm bʉ̀ʉ zeŋ gʉ. Yusə̀ wo a dʉk də yi a gʉ̀ʉ sə, a bum mok sə̀ bə ma nə̀ lʉ̀ʉk awo. ");
INSERT INTO yam_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Mʉ̀ ànə yuk də bʉ̀ʉ Jus mok wèŋ sə làp mandzə̀ də wo zə yi, fana mʉ̀ də yi lo kə ye wu. Mʉ̀ a tsə̀' fa bʉ̀ʉ sə̀ wo sə làp yi bə nzak sə dʉk də wo kə cep yusə̀ yà' sə yaaŋ wo bohònà' sə mantombìi wù.>> ");
INSERT INTO yam_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sojàa sə à gʉ̀ gù sə̀' mvəsə̀ ŋkum àwo dʉk wo sə. Wo à jə lònòoŋ Pol nùmbu ànə haŋ mvwe' lak səmok sə̀ wo to fo' də Àntipatrì. ");
INSERT INTO yam_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Tsok à rɛŋ, sojàa sə̀ wo à sə gì yàwo sə kùhu sə foho və. Wo me'rə ŋgàa nàambà'rə̀ sə ŋgòlòmalì bə Pol nə wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Wo à jə lòyi mvwe' nzeŋgòŋ Sìsàriyà anə, nə fa ŋwàk nə bohògovənòFelìs nə. Wo fa Pol mok sə̀' ndzə bohòyi. ");
INSERT INTO yam_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","GovənòFelìs à ta ŋwàk nə, nə fek Pol lak nà'. Fana Pol tsok yi də a mvwe' nzeŋgòŋ Sìlisiyà. ");
INSERT INTO yam_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Yi dʉk fa Pol nə dʉk də, <<Mʉ nə yuk nzak yònə ghà nə̀ ŋgàa nzak yo sə wèŋ kə̀ dzèeŋ.>> Fana yi fa ŋàŋ dʉk də wo jəŋ lo Pol mvwe' nto' Herò, nə sə kʉk nà' kʉ̀'ʉ. ");
INSERT INTO yam_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","À cà nùumbu tàŋ, fana Ànàniyàs ŋkum ŋgàa fa satikà' nə bə ŋkwàha bʉ̀ʉ mok wèŋ lo mvwe' lak Sìsàriyà anə. Ŋgà sa'nzak mòk nə̀ liŋ yee Tə̀talòà lòsə̀' bə yà'wèŋ. Wo à kə̀ dzèŋ bohòFelìs, nə tsok yusə̀ yà' sə yaaŋ wo bohòPol sə. ");
INSERT INTO yam_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ghà nə̀ wo ànə jə və Pol, fana Tə̀talòsə tsoho yusə̀ də Pol a gʉ̀ bʉpsə sə mʉmvə̀k nè'e vɛ'ɛ. Yi də, <<Mbè, fifi nə̀ vès tse' nà' sə̀sap nè'e, a bʉ̀ʉsə̀ wù a kotse' ves bə ŋkərə̀. Bum sə kupsə mvwe' lak yè'e wùriŋ ŋgògʉ̀ də lak sə boŋ. ");
INSERT INTO yam_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ghà nə̀ fòlòoŋ vèes dzəmgə̀ nsàp ènə wùriŋ, nə sə kwasə wu vɛ'ɛ wù kà fʉ̀k. ");
INSERT INTO yam_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mʉ̀ ka dzəm də mʉ casə wes wu mvə̀k yòdzəm, fana yu'rə fa-a ves mʉncèp nə̀ vès tse' ŋgòtsə̀' wu nə fʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Vès a yə də ŋgà' nè'e nsàp bəbʉp ŋwə̀ nəmòk vɛ'ɛ nə̀ co ŋwè kà cèp. Mvwe' sə̀ bʉ̀ʉ Jus cu sənə nzeŋgònè'e pwe', yi kə̀ dzèŋ fo', yi gʉ ya yà'wèeŋ yeto ŋgòkʉ̀ə̀m. A sə̀' yi nə̀ yi ŋwə̀ nə̀ mantombì bə kwe' bʉ̀ʉ Nazàrin wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Yi a làp mandzə̀ də yi gʉ bʉpsə ndap Nwì nə̀ ghaŋ nə, fana vès ko yi. (Vès a dʉk də vèes nə sak yi mvəsə̀ lʉ̀ʉk avès sə dʉk. ");
INSERT INTO yam_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Megu dʉk də ŋkum sojà Lìsiyàs à və̀ vɛ'ɛ, nə kə fep fis lo nà' bohòvès anə bə ŋàŋ. ");
INSERT INTO yam_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Lìsiyàs nə dʉk fe'lə sə̀' dʉk də ŋwə̀ nə̀ yumok sə yaaŋ nà' bə ŋgà' ènə pwe' àlɛ, nà'a və kə ye wu.) A ye-a ŋga wù fek-a ŋgà' ènə, wu nə yuk yòsə̀' bə ntu'u yo də yusə̀ vès sə cèp yà' bə liŋ ye yè'sə zìnə.>> ");
INSERT INTO yam_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yi ànə dʉk vɛ'nə, bʉ̀ʉ Jus sə pwe' à dzəm mvwe' mò'fis də yusə̀ nà' cèp sə zìnə. ");
INSERT INTO yam_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ànə geŋ GovənòFelìs nə niŋ fa Pol bə bo də nà'a cep. Pol sə cep də, <<Mʉ̀ rì tse' dʉk də wu a sak lak yè'e lùumŋgòŋ ŋkʉ̀ʉŋntɛ̀ŋ. Mʉ̀ kwa wùriŋ ŋgòkə̀ fi'lə ncùu am kə̀ mantombìi wù. ");
INSERT INTO yam_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ŋgòcèp yusə̀ wu fe'rə-a wù ye zìnə nə də, ka nùumbu hum-ncòp-ba casə mvə̀k nə̀ mʉ̀ à kok lòmʉ Jòrosalèm ŋgòkə̀ kùksə Nwì mbwa. ");
INSERT INTO yam_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bʉ̀ʉ Jus sə à ka mʉ ŋga mʉ̀ sə fi'dʉk ves ŋwə̀ nəmòk mʉ ndap Nwì nə̀ ghaŋ nə ye yuk. Ka sə̀' də wo à yə mʉ ŋga mʉ̀ sə yaŋsə bwìŋ ntʉm mʉ ndap pìriyàa bʉ̀ʉ Jus wèŋ sə̀' yeŋ. Mʉ̀ a ka vɛ'nə mʉmvwe' nəmòk mʉ ntòlak anə sə̀' gʉ lok. ");
INSERT INTO yam_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Yusə̀ co wo niŋ fa wu də bum sə̀ wo tsə̀' wu bə liŋ am fɛɛŋ sə zìnə, sə̀' bʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ncèp nə̀ mʉ nə kà nà' bɛ̀ŋ də, mʉ yùgə̀ yàm mandzə̀ mòk nə̀ wo sə dʉk də nà'a mvwès nà'nə, nə sə kuksə Nwì tàcicii avès bə zeŋ. Bum sə̀ wo à còm yà' ndzənə ŋwàk lʉ̀ʉk Musì bə ŋwàak ŋgàa tsòhòbum Nwì pwe', mʉ dzəmgə̀ yà' də yà'a zìnə. ");
INSERT INTO yam_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Yusə̀ mʉ̀ sə naàŋ tu bə zeŋ ma nə̀ Nwì, mègù sə̀' mvəsə̀ bʉ̀ʉ yè'e wèŋ sə naaŋ tu. Naàŋtu nə dʉk də, ŋwə̀ nə̀ yi gʉ̀gə̀ bə̀boŋ bə nə̀ yi gʉ̀gə̀ bʉp pwe' nə̀ kə̀ lòkok mvwe' kpʉ sə̀mok. ");
INSERT INTO yam_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Fana nà'a njo nə̀ mʉ̀ sə jihi nzòŋ ŋgògʉ̀ də ntʉm àam ye rərɛŋ mantombìi Nwì nə ye mantombìi bwìŋ. ");
INSERT INTO yam_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","<<Yu səmook yè' də, à cà ŋkàhaŋgòŋ wùriŋ ŋga mʉ̀ ka mvwe' lak Jòrosalèm kə dzeŋ yuk. Mʉ̀ a lòmbwa ŋgòfa lòbʉ̀ ŋgàa jìŋ wèŋ mok mbàm, nə ye ŋgòfa satikà' njàm sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Yà'a yusə̀ mʉ̀ ànə sə gʉ ŋkuŋ wo kə tseŋ mʉ mʉ ndap Nwì nə̀ ghaŋ nə sə. Ànə ye ghà nə̀ mʉ̀ ànə gʉ wes bum sə̀ ŋgògʉ̀ yà' ya wu ye mʉ lisə̀ Nwì rərɛŋ. Mʉ̀ à ka fo' ves bwìŋ co cù tesə sə̀' yeŋ. ");
INSERT INTO yam_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","À ye mègù fo' bʉ̀ʉ Jus mok sə̀ wo à tesə mvwe' nzeŋgòƐsiyà. Ànə ye-a dʉk də wo tse' yumok sə̀ yà' sə yaaŋ wo bohòmʉ̀, də wo və̀ wo ŋgòkə̀ tsə̀' fa wu. ");
INSERT INTO yam_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bʉ̀ʉ yè'e tsok-a nsàp bʉp nə̀ kaŋsurù a dʉk də mʉ̀ a gʉ̀ ghà nə̀ mʉ̀ à sə fì'lə ncù am mbwa nə-ɛ̀. ");
INSERT INTO yam_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ka casə ncèp nə̀ mò'fis nə̀ mʉ̀ a dʉk fis dʉk də, <Wèŋ sə sak mʉ yè'e də bʉ̀ʉsə̀ mʉ̀ a cèp də bwìiŋ nə̀ lòkok mvwe' kpʉ sə̀mok.> >> ");
INSERT INTO yam_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","GovənòFelìs à ye ŋwə̀ nəmòk nə̀ yi ànə rɛɛŋ bə nzak mandzə̀ Jisòs làaŋ, fana yi dʉk də yi lok nzak nə laŋ. <<Ghà nə̀ ŋkum sojà Lìsiyàs kə̀ dzèŋ ŋkuŋ, fana mʉ̀ tsok weŋ ŋwə̀ nə̀ yi gbʉ̀ nzak bə nə̀ yi ka gbʉ.>> ");
INSERT INTO yam_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Yi dʉk fa ŋgà fàk nə̀ yi kʉ̀kgə̀ Pol də nà'a sə kʉk Pol nə kʉ̀'ʉ. Nə dʉk fa nà' sə̀' də, nà'a kà Pol cʉ̀k cʉ̀k sə kotse'. Ŋge' ye wèeŋ dzəm-a ŋgòtɛsə yi bə yumok sə̀ yi dzəm yà', fana nà' me'rə wo ntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nùumbu mok ànə ca, fana Felìs nə və bə ŋgwe ye Dròsilà. Ŋgwe ye nə à ye ŋwà Jus. Yi à dʉk də wo jəŋ və Pol. Wo ànə jəŋ və nà', fana yi sə yu'rə mvəsə̀ Pol nə sə tsòho mvəsə̀ ŋgòtse' dzədzəm bohòJisòs Krɛst cu. ");
INSERT INTO yam_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nà' à sə cèp mvəsə̀ ŋgòye ŋwə̀ nə̀ bə̀boŋ, ŋgòkotse' ni' yònə ye bə nùmbu nə̀ Nwìi nə̀ kə̀ sak bwìŋ. Fana wʉə ko yi. Yi dʉk fa Pol nə dʉk də aco nà' lo ntɛ̀ŋ. Yi dʉk nà' də yi nə to fe'lə nà' sə̀mok ghà nə̀ yi tse' mvə̀k. ");
INSERT INTO yam_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Yi ànə sə tsərə sə̀' də kàmòk Pool nə fa yi mbàam mok àlɛ'. Nà'a njo nə̀ yi à sə toho nà' ghà yà lòoŋ, nə sə taaŋ bə nà' sə. ");
INSERT INTO yam_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ànə ca lùumŋgòŋ ba, fana ŋwə̀ nəmòk nə̀ liŋ yee Posòs Fetòs kok dzə̀' govənòFelìs nə mok yi. Felìs ànə sə dzəm də bʉ̀ʉ Jus wèeŋ kwa bohòyi fana, yi me'rə noŋsə Pol nə mʉ ndapndzəmə̀. ");
INSERT INTO yam_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ànə ca gu nùumbu tɛ' mvəsə̀ govənòFetòs à kə̀ cu mvwe' nze nə, fana yi ye'e Sìsàriyà, nə lo mʉ Jòrosalèm. ");
INSERT INTO yam_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","À kə̀ dzèŋ fo', ŋkum ŋgàa fa satikà' bə bʉ̀ʉ Jus sə̀ mantombì wèŋ kə tsoho bum sə̀ yà' sə yaaŋ wo bohòPol. Wo lɛŋ ŋkum Fetòs, ");
INSERT INTO yam_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","də nà'a gʉ wo bə̀boŋ bə ŋgòtum vèsə Pol Jòrosalèm. Wo à dʉk vɛ'nə bʉ̀ʉsə̀ wo a kì cù ŋgòzə nà' mandzə̀. ");
INSERT INTO yam_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fetòs nə də, <<Pol cu ŋgà ndapndzəm mvwe' lak Sìsàriyà. Mvə̀k momjo, mʉ nə sə bwi lo fo'. ");
INSERT INTO yam_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","A ye-a də yi a gʉ̀ bʉpsə yumok, wèeŋ dʉk bʉ̀ʉ awèŋ sə̀ mantombì də vesiwèeŋ lo Sìsàriyà anə, ya wo kə cep yusə̀ yà' sə yaaŋ wo bə ŋgà' ànə.>> ");
INSERT INTO yam_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fetòs à cu fe'lə bə yà'wèŋ co nùumbu fwame' kè hum àlɛ' ŋkuŋ nə yè'e tsooŋ lo yuye sə Sìsàriyà. Tsok ànə rɛŋ, fana yi kə ni cum mʉmvwe' ndap nə̀ yi sakgə̀ nzak mbwa nə, nə fa ŋàŋ dʉk də wo jəŋ nisə və Pol mbwa sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Mvə̀k nə̀ Pol ànə kə dzeŋ, fana bʉ̀ʉ Jus mok wèŋ sə̀ wo à və̀ Jòrosalèm lokok təəŋ dzooŋ yi ghʉ̀r. Wo ye ŋgòcèp bum səmok ŋkʉ̀ʉŋntɛ̀ŋ sə̀ yà' gʉ wù kà fʉ̀k, də Pol a gʉ̀ yà' yi. Yusəmok sə̀ co yà' niŋ tsok də bum sə̀ wo cèp sə zìnə kà sə̀' ye. ");
INSERT INTO yam_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pol fi'lə ncùu ye fo' sə̀' mvèsə̀. Yi dʉk də, <<Mʉ̀ ka yàm-e yumok bə lʉ̀ʉk bʉ̀ʉ Jus gʉ bʉpsə. Mʉ̀ ka yumok bə ndap Nwì nə̀ ghaŋ nə sə̀' bʉpsə, nə kà yumok sə̀ ŋkum bʉ̀ʉ Rumà ka dzəm sə̀' gʉ̀.>> ");
INSERT INTO yam_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fetòs fek Pol nə dʉk də, <<Wu nə dzəm ŋgòkə̀ lòJòrosalèm ya mʉ kə sak wu bə bum sə̀ wo cèp yè'sə fo' à?>> Yi à fek nà' vɛ'nə də ya bʉ̀ʉ Jus wèeŋ kwa bohòyi anə. ");
INSERT INTO yam_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pol cep fəsə fa nà' dʉk də, <<Mʉ̀ tə yàm ma dzə̀' nzak ŋkum bʉ̀ʉ Rumà wèŋ. Mʉ̀ dzəm yàm də wo sak nzak àm fɛn. Mʉ̀ a ka bʉ̀ʉ Jus wèŋ yumok sə̀ co ntʉm yaaŋ wo gʉ. Wù bə tu yòwù riŋ yo sə̀' vɛ'nə bə̀boŋni. ");
INSERT INTO yam_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","A ye-a də mʉ a fɛ̀ŋ lʉ̀k, nə gʉ bʉpsə yumok sə̀ wo tse' ŋgòzə mʉ, fana mʉ̀ sə kà yè'sə mandzə̀ də mʉ caŋ ya wo kà mʉ zə làp. A ye-a də zìnə ka sənə bum sə̀ wo sə cèp bə liŋ am yè'sə yeŋ, fana mandzə̀ nə̀ co ŋwè jəŋ mʉ, nə fa wo ye bʉ̀ə̀. Mʉ̀ dzəm də nzak àm nə lo mantombì bohòŋkum bʉ̀ʉ Rumà wèŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ànə geŋ, Fetòs lam və to ntòbə bʉ̀ʉ ye sə̀ wo tipsəgə̀ yi, fana yi foho və, nə kə dʉk fa Pol nə dʉk də, <<Wù də nzak yòo lo mantombì bohòŋkum bʉ̀ʉ Rumà wèŋ. Mʉ̀ dzəm fa wu sə̀' laŋ. Wu nə lo bohòyi anə.>> ");
INSERT INTO yam_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ntɛŋ mòk à cà, fana ŋkum Àgripà bə njɛ̀' ye nə̀ liŋ yee Benìs à lòŋgòkə̀ cèpsə govənòFetòs. Wo à kə̀ cèpsə nà' mvwe' lak Sìsàriyà. ");
INSERT INTO yam_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Wo à cu fo' mʉnə nùumbu səmok. Fetòs tsoho fa ŋkum Àgripà nə nzak nə̀ Pol nə. Yi tsoho fa nà' dʉk də, <<Ŋwə̀ nəmòok fɛɛŋ nə̀ govənòFelìs à nisə nòŋsə lònà' ndapndzəm. ");
INSERT INTO yam_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Mʉ̀ ànə lo Jòrosalèm, fana ŋgàa fa satikà' sə̀ ghaŋ bə bʉ̀ ŋkwàha bʉ̀ʉ Jus wèŋ tsoho fa mʉ bum sə̀ wo də yi à gʉ̀ bʉpsə. Wo dʉk mʉ də mʉ dʉk də nà' gbʉ̀ nzak laŋ. ");
INSERT INTO yam_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mʉ̀ tsok fa wo də, bʉ̀ʉ Rumà wèeŋ yəgə̀ yàwo də ŋga wo jə və-a ŋwè bə nzak, fana yi sak tsoŋ bə ŋwə̀ nə̀ nà' jə və̀ yi nə si bə si ŋkuŋ. Ya yi cep fis yusə̀ sə və̀ə yi ye sə̀'. Mʉ̀ tsok wo də ka mandzə̀ bʉ̀ʉ Rumà wèŋ ŋgòdʉk də ŋwèe bʉp ŋga wo ka yè'sə ntògʉ yeŋ. ");
INSERT INTO yam_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Wo ànə və fɛnə mʉ̀ gʉ yàm sə̀' nə̀nàk. Bʉsə̀ tsok à rɛŋ ntɛ̀ŋ, mʉ̀ kə cum mvwe' dzə̀' nə̀ mʉ sakgə̀ nzak mbwa, nə də wo jəŋ nisə və yi. ");
INSERT INTO yam_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bʉ̀ʉ sə̀ wo à jə və̀ yi sə wèŋ lokok təəŋ mʉtsə̀ wùrr, nə sə ye ŋgòcèep. Mʉ̀ sə dʉk yàm də wo nə tsok nsàp yumòk nə̀ yi a gʉ̀ bʉpsə nə̀ nà' gʉ wùriŋ. Fana wo kà nsàp yumòk nə̀ yi a gʉ̀ bʉpsə sə̀' tsə̀'. ");
INSERT INTO yam_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bwe bum sə̀ wo à cèp sə à ye kɛ'cà bwe mfi' mok bə mandzə̀ nə̀ wo yùgə̀ Nwì awo wàwawà. Wo sə cep nə sə to liŋ ŋwə̀ nəmòk də Jisòs nə̀ yi à kpʉ lòlaŋ. Pol sə dʉk ye də nà' cu fe'lə ŋwəm sə̀mok. ");
INSERT INTO yam_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Bum yè'sə jipsə tes mʉ, mʉ̀ kà rɛɛŋ lok. Fana mʉ̀ fek Pol nə də yi dzəm də yi lo Jòrosalèm ya wo kə sak bum yè'sə fo' àlɛ? ");
INSERT INTO yam_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pol dʉk ye də yi dzəm də nzak ye nə lo mantombì. Yi də ŋkum bʉ̀ʉ Rumà nə kə sak tiŋ nzak ye nə nà'. Fana mʉ̀ də wo sə kʉk yi co ŋgà ndapndzəm tè mʉ̀ kə tumsə fa lo yi bohòŋkum bʉ̀ʉ Rumà nə.>> ");
INSERT INTO yam_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ŋkum Àgripà nə dʉk fa Fetòs də, yi dzəm ŋgòkə̀ yuk yusə̀ ŋwə̀ ànə sə cèp sə bə ntu'u ye sə̀'. Fetòs də, <<Wu nə yuk yi zòŋ.>> ");
INSERT INTO yam_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Tsok ànə rɛŋ ŋkum Àgripà bə Benìs və kə ni kok bə fòvɛ'ɛ wùriŋ. Wo à və̀ bə ŋkum sojà, nə ye bə bʉ̀ʉ sə̀ ghaŋ sə̀ wo fis tu mvwe' ntʉm lak ànə wèŋ. Fetòs də wo jəŋ nisə kok və Pol mʉ nda'à. ");
INSERT INTO yam_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fetòs cep də, <<Ŋkum Àgripà nə ye ndàaŋwè pwe' nə̀ yi cu fɛɛŋ, vesiwèeŋ yu'rə. Ŋwə̀ nə̀ wèŋ sə yə yi nè'e bʉ̀ʉ Jus pwe' wa dʉk ye, bʉ̀ʉ Jus sə̀ fɛɛŋ bə sə̀ wo cu Jòrosalèm sə̀'. Wo pwe' sə warə və̀ə də nè'e ka ŋwə̀ nə̀ co wo me'rə yi cum ŋwəm yeŋ. ");
INSERT INTO yam_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mʉ̀ kʉk ja'a sə tsətsə'rə̀ anə, nə kà yusəmok sə̀ yi gʉ̀ sə̀ co wo zə yi bʉ̀ʉ zeŋ yə. Yi a dʉk də nzak ye lo mantombì bohòŋkum bʉ̀ʉ Rumà. Mʉ̀ də yi geŋ sə̀' ntɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bohòmʉ̀ yàm, mʉ̀ ka yusəmok vɛ'ɛ pap co mʉ̀ com fa gesə lo ŋkum bʉ̀ʉ Rumà bə liŋ ŋwə̀ nè'e tse'. Nà'a njo nə̀ mʉ̀ jə və̀ yi mantombìi wèŋ nə ye lɛ mantombìi ŋkum Àgripà də yi cep bə cùu ye. Ya wèeŋ kʉk ja'a wes nzak nə, kàmòk mʉ̀ tse' yumok sə̀ mʉ com. ");
INSERT INTO yam_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Bʉsə̀ anə sə yəəŋ co mʉ ləm ŋgòtumsə lòŋgà ndapndzəm ŋga mʉ̀ ka yusə̀ co mʉ̀ tsok də yi gʉ̀ bʉpsə sə jəja kwaraŋgaŋ riŋ na.>> ");
INSERT INTO yam_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Fana Àgripà dʉk fa Pol də nà'a cep yusə̀ nà' tse' ŋgòcèep. Pol sə niiŋ bo, nə sə fi'lə ncù də, ");
INSERT INTO yam_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","<<Mbè ŋkum Àgripà, a bohòmʉ̀ ntinə yè'sə rɛŋsi ŋgòkə̀ təəŋ mantombìi wù ŋgòfì'lə ncùu am bə bum sə̀ bʉ̀ʉ Jus wèŋ də mʉ̀ gʉ̀ yè'sə pwe'fo'. ");
INSERT INTO yam_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Yè'sə zìnə bə nə̀ zìnə bʉ̀ʉsə̀ wù rì tse' mvəsə̀ bʉ̀ʉ Jus wèŋ cu, nə riŋ bum sə̀ wo kà bə zeŋ cù mò'fis yegə̀ bə̀boŋni. Fana mʉ̀ sə lɛŋ wu də wu yu'rə fa mʉ yusə̀ mʉ̀ tse' ŋgòcèp sə fʉ̀ə̀. ");
INSERT INTO yam_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Bʉ̀ʉ Jus wèŋ pwe' riŋ tse' mvəsə̀ mʉ̀ à sə cu ŋga mʉ̀ cu ntòmʉwà'ŋwè. Mvəsə̀ à yèto, wo riŋ tse' mvə̀'nə̀ mʉ̀ à kùk la'à mʉ̀, nə ye Jòrosalèm sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wo riŋ tse' mʉ bə̀boŋni, a ye-a də wo dzəm ŋgòcèp fis zìnə nə na. Mʉ̀ ànə ye mòk mʉŋgorə̀ bʉ̀ʉ Faràsi wèŋ sə̀ wo sə dʉk də wo nòŋsəgə̀ lʉ̀ʉk avès nə ghak ndàaŋwè pwe'. ");
INSERT INTO yam_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Mʉ̀ cu yè' bə nzak bʉ̀ʉsə̀ də mʉ̀ sə naaŋ tu am də Nwìi nə̀ gʉ̀ yusə̀ yi à kàk fa bohòtàcici avès wèŋ sə. ");
INSERT INTO yam_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Gù sə̀' kə̀ka' nə̀ mò'fis ènə nə̀ bòop bʉ̀ʉ avès sə̀ hum-ncòp-ba pwe' sə naaŋ tu də wo nə kə tse'. Wo tsərəgə̀ vɛ'nə mvə̀'nə̀ wo kùksəgə̀ Nwì nùm bə ndzəm. Mbè, bʉ̀ʉ Jus wèŋ sə də wo kə'ə mʉ yè'e bʉ̀ʉ tsətsərə̀ ènə. ");
INSERT INTO yam_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mʉ fek tsoŋ na weŋ bʉ̀ʉ Jus nè'e ŋkuŋ-ɛ̀. Yà'a bohòwèŋ gʉgʉŋ bʉ̀ʉ yà, ŋgòdzəm də aco Nwì lokoksə to ŋwè mvwe' kpʉ ɛ̀? ");
INSERT INTO yam_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mʉ̀ bə tu am à sə tsərəgə̀ də mʉ gʉ bʉpsə liŋ Jisòs nə̀ mvwe' lak Nazàrɛ ènə bə nsàp mandzə̀ nə̀ co mʉ̀ rì ŋgògʉ̀ to pwe'. ");
INSERT INTO yam_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yà'a yusə̀ mʉ̀ à gʉ̀ mvwe' lak Jòrosalèm. Mʉ̀ à lòbohòŋkum ŋgàa fa satikà' wèŋ, wo com ŋwàk ŋgòfa mʉ ŋàŋ də mʉ nisə bʉ̀ʉ Nwì wèŋ ndapndzəm wùriŋ. Wo à sə zə mok wèŋ, mʉ̀ yàm sə̀', mʉ̀ sə dzəm də a vɛ'nə bə̀boŋ. ");
INSERT INTO yam_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","A kɛ̀' ŋkʉ̀ʉŋntɛ̀ŋ sə̀ mʉ̀ à gʉ̀ wo ŋgə' mʉmvwe' ndap pìriyàa bʉ̀ʉ Jus wèŋ. Mʉ̀ lap mandzə̀ nə̀ co mʉ̀ gʉ wo ya wo dʉk də wo kà Jisòs mok dzəm fe'lə. Mʉ̀ à sə jamsəgə̀ wo vɛ'ɛ nsàp nə̀ mʉ̀ ye'e nə lo mvwe' lak sə̀ zok ŋgòyeŋsə wo ŋgə' fo'. ");
INSERT INTO yam_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","<<Nà'a sə̀' njo nə̀ mʉ̀ à ye'e lo mvwe' lak Dàmaskù bə ŋwàk nə̀ də mʉ̀ tse' ŋàaŋ sə̀ ànə fa mʉ yà' ŋgàa fa satikà'a' sə̀ ghaŋ wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mbè, mʉ̀ ànə kə dzeŋ mandzə̀ ŋga nùum maràŋ sak sak, mʉ̀ ye nsàp marɛŋ mòk nə̀ nà' à tsə mʉbu, nà' rɛɛŋ dzooŋ mʉ. Nà' rɛŋ vɛ'ɛ nə casə nùm, nə rɛɛŋ dzooŋ bʉ̀ʉ sə̀ vesi wèŋ à sə gìi sə sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Vès pwe'fo' coho gbʉ sə nze. Fana mʉ̀ yuk ŋga ŋgì ŋwə̀ nəmòk sə to də, <Sol, Sol, wù sə fa mʉ ŋgə' bʉ̀ʉ yà? Wù sə yaŋsə mègù yà'sə ni' yòco mbòŋ nə̀ yi sə tɛ'lə tʉ nə̀ wo tsòoŋ yi fo'.> Ŋgì ŋwə̀ ènə à sə cèp bə ncèep lak bʉ̀ʉ Jus wèŋ. ");
INSERT INTO yam_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mʉ̀ fek də, <A wùu ndà, Tà?> Yi də, <A mʉ̀ʉ Jisòs. Wù sə yeŋsə ŋgə' yà'sə mʉ̀.> ");
INSERT INTO yam_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Yi dʉk fe'lə sə̀' də, <Lòkok təəŋ mʉtsə̀. Mʉ̀ yəəŋ bohòwù ŋgòjə wu co ŋgà fàk àm. Wu nə tsoho fa fe'lə wo bum sə̀ wù yə yà' bohòmʉ̀ ntinə yè'e nə ye sə̀ yà' cu mantombì sə̀ mʉ nə niŋ fa wu. ");
INSERT INTO yam_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mʉ nə tumsə lo wu bohòbʉ̀ʉ Izùrɛ nə ye sə̀ wo bʉ̀ lakmvum sə̀'. Mvəsə̀ wù sə tsòho fa wo bum yè'sə, mʉ nə sə kʉk wu ya wo kà wu bʉp gʉ̀. ");
INSERT INTO yam_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Wu nə muk fa wo lis awo. Wu nə bwi fis və wo mvwe' mandzəm, nə jəŋ və wo mvwe' marɛŋ, nə bwi fis wo mvwe' ŋàaŋ Satà, nə jəŋ və wo mvwe' ŋàaŋ sə̀ Nwì. Ya wo fa ntʉm awo bohòmʉ̀, ŋga Nwìi swifa wo bʉp awo, wo tse' mvwe' ncum awo mʉŋgorə̀ bʉ̀ʉ Nwì sə̀ yi à cùk rɛŋsə nòŋsə.> ");
INSERT INTO yam_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","<<Fana yà'a yusə̀ yà' ànə ye vɛ'nə mbè. Mʉ̀ ànə geŋ, mʉ̀ kà cùu ŋwə̀ nə̀ mʉ̀ à yə ŋga yi tsə mʉbu ènə bɛ̀ŋ. ");
INSERT INTO yam_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mʉ̀ à tsòho dʉk də bwìiŋ nə kupsə, nə bwi fa tsoŋ bʉp awo ŋkwɛ̀ŋ, nə və ma nə̀ Nwì. Wo nə gʉ bum sə̀ yà' sə nìŋ tsə̀' də wo a kupsə laŋ. Mʉ̀ à tsòho yèto mʉmvə̀k ènə mvwe' lak Dàmaskù bə Jòrosalèm, nə tsoho mvwe' nzeŋgòJùdiyà pwe'fo', bə mʉŋgorə̀ bʉ̀ lakmvum sə̀'. ");
INSERT INTO yam_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Bʉ̀ʉ Jus wèŋ à kə̀ ko mʉ ŋga mʉ mʉnda'à Nwì, nə lap mandzə̀ də wo zə mʉ njo ènə. ");
INSERT INTO yam_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Haaŋ kə wɛs ntinə Nwì a tɛsə mʉ. Fana yà'a yusə̀ mʉ̀ tə fɛɛŋ ŋgòtsə̀' zìnə àm bohòbwìŋ pwe', ŋkwà'ŋwè bə mweŋke' pwe' yəyərə̀. Yusə̀ mʉ̀ cèep mègù sə̀' yusə̀ ŋgàa tsòhòbum Nwì bə Musì wèŋ ànə dʉk də yà'a nə̀ kə̀ ye vɛ'nə. ");
INSERT INTO yam_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Dʉk də Ŋkum