﻿USE sofia;
DROP TABLE IF EXISTS sofia.yal_vpl;
CREATE TABLE yal_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yal_vpl WRITE;
INSERT INTO yal_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","A fɔlɔni, Ala yi kore xɔnna nun bɔxɔ xɔnna da. ");
INSERT INTO yal_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Dunuɲa mi yi yitɔnxi nun. A magenla nan yi a ra. Dimin nan yi na fufaan xun ma, koni Alaa Nii Sariɲanxin yi a masigama igen xun ma. ");
INSERT INTO yal_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ala yi a fala, a naxa, “Kɛnɛnna xa mini.” Kɛnɛnna yi mini. ");
INSERT INTO yal_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ala yi a mato, na kɛnɛnna fanxi. Ala yi kɛnɛnna nun dimini taxun. ");
INSERT INTO yal_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ala yi kɛnɛnna xili sa “yanyina.” A yi dimin xili sa “kɔɛna.” Kɔɛ yi so, kuye yi yiba, lɔxɔ singen nan na ra. ");
INSERT INTO yal_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ala yi a fala, a naxa, “Kore walaxan xa lu bɔxɔ igen nun kore igen tagi.” ");
INSERT INTO yal_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Na yi findi naninna ra bɔxɔ igen nun kore igen tagi. A liga na kii nin. ");
INSERT INTO yal_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ala yi naninni ito xili sa “kore xɔnna.” Kɔɛ yi so, kuye yi yiba, lɔxɔ firinden nan na ra. ");
INSERT INTO yal_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ala yi a fala, a naxa, “Bɔxɔ igen xa a malan yire kedenni. Xaren xa maba.” A liga na kii nin. ");
INSERT INTO yal_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ala yi na xaren xili sa “bɔxɔna.” A yi na bɔxɔ igen xili sa “baana.” Ala yi a mato, na fanxi. ");
INSERT INTO yal_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ala yi a fala, a naxa, “Soli seene xa mini bɔxɔn ma. Sansiin birin xa soli, naxan yo naxan, bɔnsɔn kedenni. Sansi xɔnna naxan na sansi bogin kui, a solima nɛn birin nun a bɔnsɔnna.” A liga na kii nin. ");
INSERT INTO yal_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ala yi sansiin birin nasoli bɔxɔn fari. Sansi xɔnna naxan na sansi bogin kui, a yi soli e nun a bɔnsɔnna. Ala yi a mato, na fanxi. ");
INSERT INTO yal_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kɔɛ yi so, kuye yi yiba, lɔxɔ saxanden nan na ra. ");
INSERT INTO yal_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ala yi a fala, a naxa, “Yanban seene xa lu koren ma, yanyin nun kɔɛɛn taxun feen na. Waxatin birin kolonma yanban seene sabun nan na. Xii yo xii, ɲɛɛ yo ɲɛɛ a kolonma yanban seene sabun nan na. ");
INSERT INTO yal_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","E xa dɛgɛ koren ma, e bɔxɔni yalan.” A liga na kii nin. ");
INSERT INTO yal_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ala yi nayiyalanse xungbe firin nafala. Naxan xungbo han, na xa yanyin yamarin naba. Naxan xurun, na xa kɔɛɛn yamarin naba. A yi sarene fan nafala. ");
INSERT INTO yal_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ala yi yanban seene sa koren ma alogo e xa bɔxɔni yalan, ");
INSERT INTO yal_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","e yi yanyin nun kɔɛɛn yamarin naba, e yi dimin nun kɛnɛnni taxun. Ala yi a mato, a fanxi. ");
INSERT INTO yal_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kɔɛ yi so, kuye yi yiba, lɔxɔ naaninden nan na ra. ");
INSERT INTO yal_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ala yi a fala, a naxa, “Igen xa yimaxa niimaseene ra. Xɔline xa tugan kore.” ");
INSERT INTO yal_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ala yi yɛxɛ xungbene da e nun niimaseen birin igeni, naxan yo naxan bɔnsɔn kedenni. A yi xɔline fan da, naxan yo naxan bɔnsɔn keden. Ala yi a mato, a fanxi. ");
INSERT INTO yal_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ala yi barakan sa e fe yi, a yi a fala e xa, a naxa, “Ɛ xa wuya, ɛ yi yiriwa alogo yɛxɛne xa baan nafe. Xɔline fan xa gbo bɔxɔn ma.” ");
INSERT INTO yal_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kɔɛ yi so, kuye yi yiba, lɔxɔ suulunden nan na ra. ");
INSERT INTO yal_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ala yi a fala, a naxa, “Niimaseene xa lu bɔxɔn ma. Birin xa lu e nun a bɔnsɔnna. Xuruseene nun bubuseene nun burunna subene, e birin xa lu e nun e bɔnsɔnna.” A liga na kii nin. ");
INSERT INTO yal_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ala yi burunna subene da naxan yo naxan bɔnsɔn keden. A yi xuruseene da naxan yo naxan bɔnsɔn keden. A yi bubuseene da naxan yo naxan bɔnsɔn keden. Ala yi a mato, a fanxi. ");
INSERT INTO yal_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ala yi a fala, a naxa, “En xa adaman da en yɛtɛ misaala ra en maligan na. A xa sɛnbɛn sɔtɔ yɛxɛne nun xɔline nun xuruseene nun bɔxɔn nun bubuseene xun na.” ");
INSERT INTO yal_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ala yi adaman da a yɛtɛ misaala ra. A e daxi Ala misaala nan na, a e da xɛmɛn nun ɲaxanla. ");
INSERT INTO yal_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ala yi barakan sa e fe yi, a yi a fala e xa, a naxa, “Ɛ wuya ayi, ɛ yi yiriwa alogo bɔxɔn xa rafe. Ɛ sɛnbɛn sɔtɔ bɔxɔn nun yɛxɛne nun xɔline nun bubuseene xun na.” ");
INSERT INTO yal_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ala yi a fala, a naxa, “N bata sansiin birin nun sansi bogin birin fi ɛ ma balon na. ");
INSERT INTO yal_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","N bata sansiin birin fi subene ma naxanye bɔxɔn ma, e nun xɔline nun bubuseene nun niimaseene, naxan yo yengima. Sansiin birin bata findi e balon na.” A liga na kii nin. ");
INSERT INTO yal_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ala yi a daliseene birin mato, a fanxi han! Kɔɛ yi so, kuye yi yiba, lɔxɔ senninden nan na ra. ");
INSERT INTO yal_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kore xɔnna nun bɔxɔ xɔnna daxi na kiini e nun e kui seen birin. ");
INSERT INTO yal_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Lɔxɔ soloferedeni Ala wanla yi kamali. A yi a matabu. ");
INSERT INTO yal_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ala yi barakan sa na lɔxɔ soloferedena fe yi, a xa findi lɔxɔ sariɲanxin na bayo a matabuxi na lɔxɔn nin. A wanla kamalixi na lɔxɔn nin. ");
INSERT INTO yal_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Kore xɔnna nun bɔxɔ xɔnna taruxun ni i ra, e daxi waxatin naxan yi. Marigina Alatala bɔxɔn nun koren nafala waxatin naxan yi, ");
INSERT INTO yal_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","soli se yo mi yi na. Sansi yo mi yi na naxan solixi bɔxɔn ma bayo Marigina Alatala munma yi tule igen nagodo singen. Adaman fan mi yi na naxan bɔxɔn nawalima. ");
INSERT INTO yal_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Koni xuyexuyenna yi minima bɔxɔn fari, a bɔxɔni kun. ");
INSERT INTO yal_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Marigina Alatala yi adaman nafala bɛndɛn na. Na xanbi ra, a yi niin fe a ɲɔɛni, adaman yi findi daɲɔxɔn na. ");
INSERT INTO yal_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Na xanbi Marigina Alatala yi nakɔ faɲin nafala sogeteden mabinni. Na yiren xili Eden. A yi adaman dɔxɔ mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Marigina Alatala yi wudin siyaan birin nasoli mɛnni, wudin naxan tofan, wudin naxan bogi donma a faɲin na. Na yiren tagi, wudi firin yi na yi. Kedenna xili siimaya wudina. A firinden xili fe faɲin nun fe ɲaxin kolon wudina. ");
INSERT INTO yal_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Xuden yi mini Eden nakɔni soli seene xa, a yi taxun, a findi xude naaninna ra. ");
INSERT INTO yal_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Na xude singen xili Pison. A danguma Xawila bɔxɔn birin ma, xɛmaan dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Na xɛmaan fan. Wudi igen xiri ɲaxumɛn fan na, e nun gɛmɛ tofaɲin naxan xili onixin. ");
INSERT INTO yal_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Na xude firinden xili Gihon. A danguma Kusi bɔxɔn birin ma. ");
INSERT INTO yal_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Na xude saxanden xili Tigiri. A danguma Asuri bɔxɔn ma a sogeteden binna ra. Na xude naaninden xili Efirati. ");
INSERT INTO yal_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Marigina Alatala yi adaman dɔxɔ Eden nakɔni nɛn alogo a xa na yiren nawali, a yi a kantan. ");
INSERT INTO yal_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Marigina Alatala yi yamarin so Adama yii, a naxa, “I nɔɛ wudini itoe bogin birin donɲɛ naxan Eden nakɔni, ");
INSERT INTO yal_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","koni i nama fe faɲin nun fe ɲaxin kolon wudin bogin don, bayo i na a don, i faxama nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Marigina Alatala yi a fala, a naxa, “A mi lan xɛmɛn xa lu be a kedenna. N na a mali muxu faɲin dama nɛn a xa.” ");
INSERT INTO yal_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Burunna subene birin e nun xɔline birin Marigina Alatala naxanye rafalaxi bɛndɛn na, a yi e xali adaman fɛma a xa e xili sa. Adaman e xili sa kii naxan yi, na yi findi e xinle ra. ");
INSERT INTO yal_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","A yi xuruseene birin nun xɔline birin nun burunna subene birin xili sa. Koni na waxatini Adaman munma yi a mali muxu faɲin sɔtɔ singen. ");
INSERT INTO yal_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Marigina Alatala yi xixɔnla radangu a ma. A yi a raxi ki faɲi. A to xi, Marigina Alatala yi a ɲɛnsɛn xɔri keden ba. A yi na ragali. ");
INSERT INTO yal_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Na xanbi, na ɲɛnsɛn xɔnna naxan kelixi adaman yi, Marigina Alatala yi na findi ɲaxanla ra, a yi fa a ra adama xɔn. ");
INSERT INTO yal_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adama yi a fala, a naxa, “Iki, ito fataxi n xɔnna nan na. A mɔn fataxi n fatin nin. A xinla falama nɛn ‘ɲaxanla,’ bayo a minixi xɛmɛni nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nanara, xɛmɛna a nga nun a fafe beɲinma, a yi a maso a ɲaxanla ra, e findi fati bɛndɛ kedenna ra. ");
INSERT INTO yal_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Xɛmɛn nun a ɲaxanla magenla nan yi a ra nun, koni e mi yi yagima na ra. ");
INSERT INTO yal_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Saɲin nan yi kɔta Marigina Alatalaa daliseene birin xa. A yi ɲaxanla maxɔdin, a naxa, “Ɲɔndin na a ra ba, Ala bata a fala, fa fala wudi binla naxanye birin Eden nakɔni, ɛ nama e bogin don?” ");
INSERT INTO yal_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ɲaxanla yi a yabi, a naxa, “Wudin naxanye Eden nakɔni, nxu nɔɛ e bogin donɲɛ nɛn, ");
INSERT INTO yal_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","koni wudin naxan Eden nakɔɔn tagiyani, nxu mi nɔɛ na bogin donɲɛ, nxu mi nɔɛ nxu yiin dinɲɛ a ra. Xa na liga nxu faxama nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Saɲin yi a fala ɲaxanla xa, a naxa, “Ɛn-ɛn de! I mi faxama. ");
INSERT INTO yal_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ala a kolon, i na a don, i yɛɛn nabima nɛn. I fama fe faɲin nun fe ɲaxin kolondeni nɛn alo Ala yɛtɛna.” ");
INSERT INTO yal_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ɲaxanla to wudi bogin mato, a tofan, a fan donseen na, a fan xaxili sɔtɔ seen na, a yi a tongo. A yi a don. A yi nde tongo, a sa a so a xɛmɛn yii, naxan yi a fɛma. A fan yi a don. ");
INSERT INTO yal_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Na waxatini e yɛɛn yi rabi. E yi a kolon, a e magenla nan yi a ra. E yi xɔdɛ dɛɛne gira, e yi e dɛgɛ dugin na. ");
INSERT INTO yal_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Na xanbi ra, xɛmɛn nun a ɲaxanla yi Marigina Alatala sigati xuiin mɛ nakɔni ɲinbaridɛɛn foye faɲini. E yi e luxun wudine tagi. ");
INSERT INTO yal_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Marigina Alatala yi a xili, a naxa, “Adama, i minɛn yi?” ");
INSERT INTO yal_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adaman yi a ratin, a naxa, “N bata i xuiin mɛ Eden nakɔni, koni n bata gaxu, bayo n magenla na a ra. Awa, n bata n luxun.” ");
INSERT INTO yal_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ala yi a maxɔdin, a naxa, “Nde a yitaxi i ra a i magenla na a ra? I bata na wudi bogin don ba, n na i yamarixi naxan ma fe ra a i nama a don?” ");
INSERT INTO yal_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adaman yi a yabi, a naxa, “Na ɲaxanla i naxan soxi n yii, na bata na wudi bogin so n yii, n yi a don.” ");
INSERT INTO yal_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Na xanbi, Marigina Alatala yi ɲaxanla maxɔdin, a naxa, “I nanse ligaxi?” Ɲaxanla yi a yabi, a naxa, “Saɲin nan n mayendenxi han n na a don.” ");
INSERT INTO yal_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Awa, Marigina Alatala yi a fala saɲin xa, a naxa, “I to bata ito liga, awa, n fan bata i danga xuruseene nun burunna subene birin tagi. I findima bubuseen nan na i kuiin xun na. I gbangbanna nan donma i ya dunuɲa yi gidini. ");
INSERT INTO yal_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","N bata yaxuyaan naso i tan nun ɲaxanla tagi. N bata a raso i ya diine nun a diine fan tagi. Na ɲaxanla diina i xunni wuruma nɛn, i fan yi a sanna maxɔlɔ.” ");
INSERT INTO yal_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ala yi a fala ɲaxanla xa, a naxa, “I fan, i tɔrɔma nɛn i ya dii barideni. Na tɔrɔn gboma ayi nɛn. I birama nɛn i ya xɛmɛn fɔxɔ ra. A i yamarima nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ala yi a fala Adama xa, a naxa, “I bata bira i ya ɲaxanla fɔxɔ ra. I bata na wudin bogin don, n na i yamarixi wudin naxan ma fe ra, a i nama na don. Iki n bata bɔxɔn danga i ya fe ra. I tɔrɔma nɛn balo sɔtɔdeni i ya dunuɲa yi gidini. ");
INSERT INTO yal_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","N ɲanle nun tansinne raminima nɛn bɔxɔn ma, koni i baloma siseene nan xɔn xɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","I balon sɔtɔma i kuye wolonna nin han i xɛtɛma bɔxɔni waxatin naxan yi, bayo i kelixi na bɔxɔn nin. Bɛndɛn ni i ra, i mɔn xɛtɛma na bɛndɛn nin.” ");
INSERT INTO yal_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adaman yi a ɲaxanla xili sa Nmahawa bayo a findima muxun birin nga nan na. ");
INSERT INTO yal_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Marigina Alatala yi dugin kidi daxina nde dɛgɛ Adama nun a ɲaxanla xa. A yi na ragodo e ma. ");
INSERT INTO yal_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Marigina Alatala yi a fala, a naxa, “Adaman bata findi alo en tan, bayo a bata fe faɲin nun fe ɲaxin kolon. A mi daxa a xa siimaya wudi bogin don, xa na mi a ra a mi faxama nun.” ");
INSERT INTO yal_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Marigina Alatala yi e ramini Eden nakɔni, a e xa sa bɔxɔn nawali e fataxi naxan na. ");
INSERT INTO yal_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","A to Adama kedi, Ala yi maleka gubugubu kanne ti Eden sogeteden binna ra. A mɔn yi silanfanna tɛɛ daxin lu mɛnni naxan a firifirima na longonni kiraan kantan xinla ma siga siimaya wudin yireni. ");
INSERT INTO yal_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adama yi Nmahawa kolon ɲaxanla ra. Nmahawa yi fudikan. E yi diin sɔtɔ naxan xili Kayini. Nmahawa yi a fala, a naxa, “Alatala bata n mali dii xɛmɛn sɔtɔ feen na.” ");
INSERT INTO yal_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Na xanbi, Nmahawa yi Kayini raburunna sɔtɔ dii xɛmɛna, naxan yi xili Habila. Habila, xuruse rabaan nan yi a ra. Kayini, xɛɛ biin nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Na waxatin to dangu, Kayini yi fa sansi bogina ndee ra, a ne ba saraxan na Alatala xa. ");
INSERT INTO yal_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Koni Habila yi fa xuruse dii singen na e nun a turena. Alatala yi Habila nun a saraxan nasuxu, ");
INSERT INTO yal_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","koni a mi Kayini nun a saraxan nasuxu. Awa, Kayini yi xɔlɔ. A yɛtagin yi masara. ");
INSERT INTO yal_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Na xanbi, Alatala yi Kayini maxɔdin, a naxa, “Nanfera i xɔlɔxi? Nanfera i yɛtagin masaraxi? ");
INSERT INTO yal_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Xa i fe faɲin liga, n na rasuxuma nɛn, koni xa i fe ɲaxin liga, yulubina i ya dɛɛn na, a i mamɛlɛnma. I kata, i yi a nɔ.” ");
INSERT INTO yal_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kayini yi a fala a xunyɛn xa, a naxa, “En siga xɛɛn ma.” E to so xɛɛn ma, Kayini yi a xunyɛn Habila suxu. A yi a faxa. ");
INSERT INTO yal_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Na xanbi Alatala yi Kayini maxɔdin, a naxa, “I xunyɛn Habila minɛn yi?” A yi a yabi, a naxa, “N mi a kolon. N tan nan n xunyɛn kantan muxun na ba?” ");
INSERT INTO yal_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ala yi a fala, a naxa, “I nanse ligaxi? I tuli mati. I xunyɛn wunla n gbelegbelema bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","N bata i danga bayo i bata i xunyɛn faxa. N na i kedima nɛn bɔxɔni ito ma i xunyɛn wunla dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","I na bɔxɔn nawali, i mi balon sɔtɔma. I findima sigatiin nan na.” ");
INSERT INTO yal_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayini yi a fala Alatala xa, a naxa, “Na hakɛn goronna gbo n tan xun ma. ");
INSERT INTO yal_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Xa i bata n kedi to, n mi i toma sɔnɔn. N findima sigatiin nan na. Muxun naxan sa n toma, a n faxama nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Alatala yi a yabi, a naxa, “Ɛn-ɛn, xa muxu yo i faxa, n na i gbeen ɲɔxɔma nɛn dɔxɔɲa ma solofere.” Alatala yi taxamasenna sa Kayini ma alogo xa naxan sa a to, a nama a faxa. ");
INSERT INTO yal_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Awa, Kayini yi a makuya Alatala ra. A sa dɔxɔ Nodi bɔxɔni Eden nakɔɔn sogetede binna ra. ");
INSERT INTO yal_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayini yi a ɲaxanla kolon ɲaxanla ra. A ɲaxanla yi fudikan. A yi diin sɔtɔ naxan xili Xanɔki. Kayini yi taan ti na yi. A yi a diin xili sa na taan xun ma. ");
INSERT INTO yal_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Xanɔki nan Yiradi sɔtɔ. Yiradi yi Mehuyayɛli sɔtɔ. Mehuyayɛli yi Metusayɛli sɔtɔ. Metusayɛli yi Lameki sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki yi ɲaxalan firin tongo. Kedenna xili Ada. Boden xili Sila. ");
INSERT INTO yal_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada yi Yabali sɔtɔ. Yabali, xuruse rabane nun bubu kanne baba nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabali xunyɛn xili Yubali. Yubali, konden maxane nun xulen fene baba nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila fan yi diin sɔtɔ. A xili Tubali-Kayini. A tan, xabun nan yi a ra. A yi waliseen sifan birin nafalama sulan na, e nun wurena. Tubali-Kayini xunyɛn ɲaxalanmaan yi xili Nama. ");
INSERT INTO yal_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki yi a fala a ɲaxanle xa, a naxa, “Ada nun Sila, ɛ tuli mati. Lameki a ɲaxanle, ɛ ɛ tuli mati n ma falan na. N bata xɛmɛna nde faxa n gbeen ɲɔxɔn na. N bata na banxulanna faxa bayo a bata n maxɔlɔ. ");
INSERT INTO yal_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Xa Kayini daxa a gbeen ɲɔxɔ dɔxɔɲa ma solofere, Lameki a gbeen ɲɔxɔma nɛn dɔxɔɲa ma tonge solofere e nun solofere.” ");
INSERT INTO yal_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adama yi a ɲaxanla kolon ɲaxanla ra. A yi diin sɔtɔ naxan yi xili Seti. A na xili sa bayo Ala bata a diin Habila ɲɔxɔ so a yii Kayini naxan faxa. ");
INSERT INTO yal_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti fan yi diin sɔtɔ naxan xili Enosi. Na waxatini, muxune yi Alatala xinla binya fɔlɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama bɔnsɔnna taruxun ni ito ra. Ala to Adama da, a a findi a yɛtɛ maligan na, ");
INSERT INTO yal_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","a e da xɛmɛn nun ɲaxanla. A e baraka. A e xili sa “Adamana.” ");
INSERT INTO yal_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adama to fori ɲɛɛ kɛmɛ ɲɛɛ tonge saxan, a yi diin sɔtɔ a yɛtɛ maligan na naxan maso a ra. A yi a xili sa Seti. ");
INSERT INTO yal_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seti bari xanbini, Adama yi bu ɲɛɛ kɛmɛ solomasɛxɛ. A mɔn yi dii xɛmɛn nun dii tɛmɛ gbɛtɛye sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adama a siimayaan yi siga ɲɛɛ kɛmɛ solomanaanin ɲɛɛ tonge saxan. Na xanbi ra, a yi faxa. ");
INSERT INTO yal_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti to bu ɲɛɛ kɛmɛ ɲɛɛ suulun, a yi Enosi bari. ");
INSERT INTO yal_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enosi bari xanbini, Seti yi bu ɲɛɛ kɛmɛ solomasɛxɛ ɲɛɛ solofere. A mɔn yi dii xɛmɛn nun dii tɛmɛ gbɛtɛye sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seti a siimayaan yi siga ɲɛɛ kɛmɛ solomanaanin ɲɛɛ fu nun firin. Na xanbi ra, a yi faxa. ");
INSERT INTO yal_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi to bu ɲɛɛ tonge solomanaanin, a yi Kenan bari. ");
INSERT INTO yal_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan bari xanbini, Enosi yi bu ɲɛɛ kɛmɛ solomasɛxɛ ɲɛɛ fu nun suulun. A mɔn yi dii xɛmɛn nun dii tɛmɛ gbɛtɛye sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosi a siimayaan yi siga ɲɛɛ kɛmɛ solomanaanin ɲɛɛ suulun. Na xanbi ra, a yi faxa. ");
INSERT INTO yal_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan to bu ɲɛɛ tonge solofere, a yi Mahalaleli bari. ");
INSERT INTO yal_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalaleli bari xanbini, Kenan yi bu ɲɛɛ kɛmɛ solomasɛxɛ ɲɛɛ tonge naanin. A mɔn yi dii xɛmɛn nun dii tɛmɛ gbɛtɛye sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan ma siimayaan yi siga ɲɛɛ kɛmɛ solomanaanin ɲɛɛ fu. Na xanbi ra, a yi faxa. ");
INSERT INTO yal_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli to bu ɲɛɛ tonge sennin e nun suulun, a yi Yarɛdi bari. ");
INSERT INTO yal_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yarɛdi bari xanbini, Mahalaleli yi bu ɲɛɛ kɛmɛ solomasɛxɛ ɲɛɛ tonge saxan. A mɔn yi dii xɛmɛn nun dii tɛmɛ gbɛtɛye sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleli a siimayaan yi siga ɲɛɛ kɛmɛ solomasɛxɛ ɲɛɛ tonge solomanaanin ɲɛɛ suulun. Na xanbi ra, a yi faxa. ");
INSERT INTO yal_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yarɛdi to bu ɲɛɛ kɛmɛ ɲɛɛ tonge sennin e nun firin, a yi Xenɔki bari. ");
INSERT INTO yal_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Xenɔki bari xanbini, Yarɛdi yi bu ɲɛɛ kɛmɛ solomasɛxɛ. A mɔn yi dii xɛmɛn nun dii tɛmɛ gbɛtɛye sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yarɛdi a siimayaan yi siga ɲɛɛ kɛmɛ solomanaanin ɲɛɛ tonge sennin e nun firin. Na xanbi ra, a yi faxa. ");
INSERT INTO yal_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Xenɔki to bu ɲɛɛ tonge sennin ɲɛɛ suulun, a yi Matusela bari. ");
INSERT INTO yal_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matusela bari xanbini, Xenɔki yi bira Ala fɔxɔ ra ɲɛɛ kɛmɛ saxan. A mɔn yi dii xɛmɛn nun dii tɛmɛ gbɛtɛye sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Xenɔki a siimayaan yi siga ɲɛɛ kɛmɛ saxan ɲɛɛ tonge sennin e nun suulun. ");
INSERT INTO yal_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Xenɔki yi sigan tima e nun Ala. Na xanbi ra, a mi lu na sɔnɔn, bayo Ala bata a xali, a mi faxa. ");
INSERT INTO yal_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusela to bu ɲɛɛ kɛmɛ ɲɛɛ tonge solomasɛxɛ ɲɛɛ solofere, a yi Lameki bari. ");
INSERT INTO yal_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lameki bari xanbini, Matusela yi bu ɲɛɛ kɛmɛ solofere ɲɛɛ tonge solomasɛxɛ e nun firin. A mɔn yi dii xɛmɛn nun dii tɛmɛ gbɛtɛye sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Matusela a siimayaan yi siga ɲɛɛ kɛmɛ solomanaanin ɲɛɛ tonge sennin e nun solomanaanin. Na xanbi ra, a yi faxa. ");
INSERT INTO yal_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki to bu ɲɛɛ kɛmɛ ɲɛɛ tonge solomasɛxɛ e nun firin, a yi diin sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","A yi a xili sa Nuhan. A yi a fala, a naxa, “A tan nan a ligama en ɲinan en ma tɔrɔn nun en ma wanla ra, bayo Alatala bata bɔxɔn danga.” ");
INSERT INTO yal_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuhan bari xanbini, Lameki yi bu ɲɛɛ kɛmɛ suulun ɲɛɛ tonge solomanaanin ɲɛɛ suulun. A mɔn yi dii xɛmɛn nun dii tɛmɛ gbɛtɛye sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameki a siimayaan yi siga ɲɛɛ kɛmɛ solofere ɲɛɛ tonge solofere e nun solofere. Na xanbi ra, a yi faxa. ");
INSERT INTO yal_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhan to bu ɲɛɛ kɛmɛ suulun, a yi Semi nun Xami nun Yepeti sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Muxune wuya fɔlɔ bɔxɔn fari waxatin naxan yi, e yi dii tɛmɛne bari. ");
INSERT INTO yal_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Daɲɔxɔn naxanye fata Ala konna ra, na ndee yi yabu dii tɛmɛne ra, bayo e tofan. E yi ndee yɛ matongo, e yi e findi e ɲaxanle ra. ");
INSERT INTO yal_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Na xanbi ra, Alatala yi a fala, a naxa, “N mi tinɲɛ n ma Niin xa bu adaman fatini habadan, bayo daliseen na a ra. A mi danguma ɲɛɛ kɛmɛ ɲɛɛ mɔxɔɲɛn na.” ");
INSERT INTO yal_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Na waxatini, e nun waxatin naxan fa na xanbi ra, Nefilimi muxu magaxuxine nan yi na dunuɲa yi. Na daɲɔxɔne nun na dii tɛmɛne nan ne barixi. E findi sofa magaxuxine nan na na waxatine yi e nun xili kanne. ");
INSERT INTO yal_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Alatala yi a to adamadina ɲaxuyaan bata gbo ayi bɔxɔn fari. A miriyane findixi fe kobin nan na waxatin birin. ");
INSERT INTO yal_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Na yi Alatala tɔrɔ han a yi nimisa adaman da feen na. Na yi a bɔɲɛn tɔrɔ. ");
INSERT INTO yal_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Alatala yi a fala, a naxa, “Adaman birin n naxan daxi, n na birin ɲanma nɛn dunuɲa yi. Muxu ba, sube ba, bubuse ba, xɔliin naxan tuganma kore ba, n na birin naxɔrima nɛn dunuɲa yi, bayo n bata nimisa adaman da feen na.” ");
INSERT INTO yal_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Koni, Nuhan yi rafan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuhan bɔnsɔnna taruxun ni ito ra. Muxu tinxinxin nan yi Nuhan na na waxatini. Fɛ yo mi yi a ra. A yi biraxi Ala fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhan dii saxan nan sɔtɔ: Semi nun Xami nun Yepeti. ");
INSERT INTO yal_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Dunuɲa bata yi kala Ala yɛɛ ra yi. A bata yi rafe fe ɲaxin na. ");
INSERT INTO yal_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ala yi dunuɲa to, a kalaxi, muxun birin fe ɲaxin fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Awa, Ala yi a fala Nuhan xa, a naxa, “N waxi adaman birin naxɔri feni dunuɲa yi, bayo dunuɲa bata rafe fe kobin na. N waxi adaman birin nun bɔxɔn birin kala feni. ");
INSERT INTO yal_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Awa, i xa Goferi wudin nafala kunkin na. Konkone xa lu a kui. I dolen sa a kuiin nun a fanna ma. ");
INSERT INTO yal_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","I xa a rafala i kiini: A kuyan xa findi nɔngɔnna yɛ kɛmɛ saxan na, a yigbona tonge suulun, a yitena tonge saxan. ");
INSERT INTO yal_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","I a xunna soon nafala. A xa dangu nɔngɔnna yɛɲa ma keden na. I a dɛɛn ti a dɛxɔn ma. I xa kunkin kuini taxun dɔxɔɲa ma saxan.” ");
INSERT INTO yal_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“N tan igen nadinma nɛn dunuɲa yi. A muxun birin halagi. Niimaseen birin faxama nɛn. ");
INSERT INTO yal_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Koni n bata layirin tongo i xa. I so kunkini ito kui, i tan nun i ya diine nun i ya ɲaxanla, e nun i ya diine ɲaxanle. ");
INSERT INTO yal_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","I xa fa daliseen sifan birin firin firinna ra, a xɛmɛn nun a gilɛna alogo e xa kisi. ");
INSERT INTO yal_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Xɔliin bɔnsɔnna birin firin firin, suben bɔnsɔnna birin firin firin, bubuseen bɔnsɔnna birin firin firin, e fama i xɔn, i yi e rakisi. ");
INSERT INTO yal_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","I xa donseen sifan birin xali kunkin kui. I xa sa a mara i tan xa e nun e fan xa.” ");
INSERT INTO yal_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhan yi a birin liga alo Ala a yamarixi kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Alatala yi a fala Nuhan xa, a naxa, “So kunkin kui, i tan nun i ya denbayaan birin, bayo tinxin muxun nan i ra waxatini ito yi. ");
INSERT INTO yal_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Sube radaxaxi yo sube radaxaxi, i xa na solofere raso kunkin kui, a xɛmɛn nun a gilɛna. Sube raharamuxi yo sube raharamuxi i xa na firin naso, a xɛmɛn nun a gilɛna. ");
INSERT INTO yal_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Xɔliin fan sifan birin, solofere tongo, a xɛmɛn nun a gilɛna, alogo daliseen sifan birin xa lu dunuɲa yi. ");
INSERT INTO yal_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Xi solofere na dangu, n tulen nagodoma bɔxɔn ma nɛn, soge tonge naanin, kɔɛ tonge naanin. N niimaseen naxan birin daxi, na birin halagima nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhan yi na birin liga Alatala a yamari naxan na. ");
INSERT INTO yal_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Fufaan mini waxatin naxan yi, Nuhan ma siimayaan ɲɛɛ kɛmɛ sennin nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhan nun a diine nun a ɲaxanla nun a diine ɲaxanle yi keli igen yɛɛ ra, e yi so kunkin kui. ");
INSERT INTO yal_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Sube radaxaxine nun sube raharamuxine, xɔline nun bubuseene, ");
INSERT INTO yal_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","a xɛmɛn nun a gilɛna, e yi siga Nuhan fɛma firin firin. E yi so kunkin kui alo Ala a yamari Nuhan ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Xii solofere dangu xanbini, na fufaan yi din dunuɲa ra. ");
INSERT INTO yal_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhan ma siimayaan yi ɲɛɛ kɛmɛ sennin, kike firin, xi fu nun solofere. Igen naxan bɔxɔni, na yi te fɔlɔ, e nun igen naxan kore, na fan yi godo fɔlɔ. ");
INSERT INTO yal_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tulen yi fa bɔxɔn ma soge tonge naanin, kɔɛ tonge naanin. ");
INSERT INTO yal_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Na lɔxɔ yɛtɛni, Nuhan nun a diine, Semi nun Xami nun Yepeti e nun a ɲaxanla nun a dii saxanne ɲaxanle, ne birin yi so kunkin kui. ");
INSERT INTO yal_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Burunna suben bɔnsɔnna birin nun xuruseen bɔnsɔnna birin nun bubuseen bɔnsɔnna birin nun xɔliin bɔnsɔnna birin, e yi so kunkin kui. ");
INSERT INTO yal_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Daliseen birin naxan yengima, a firin firin, e yi fa Nuhan fɛma. E yi so kunkin kui. ");
INSERT INTO yal_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Niimaseen birin, a xɛmɛn nun a gilɛna, e yi so kunkin kui alo Ala a yamari Nuhan ma kii naxan yi. Na xanbi ra, Alatala yi dɛɛn balan. ");
INSERT INTO yal_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Xi tonge naanin fufaan yi mini. A yi kunkini te. ");
INSERT INTO yal_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Igen to gbo bɔxɔn ma, kunkin yi dɔxɔ igen fari. ");
INSERT INTO yal_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Igen yi te han a yi sa geyaan birin xun ma dunuɲa yi. ");
INSERT INTO yal_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Igen yi sa geyane xun ma han nɔngɔnna yɛ fu nun naanin. ");
INSERT INTO yal_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Niimaseen naxanye birin yi dunuɲa yi, ne birin yi halagi: xɔli yo, xuruse yo, burunna sube yo, bubuse yo, e nun adamadiin birin. ");
INSERT INTO yal_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Niimaseen naxanye birin yi xaren na, naxanye yengima, ne birin yi halagi. ");
INSERT INTO yal_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Niimaseen naxanye yi bɔxɔ xɔnna ma, na birin yi raxɔri: adamadiine nun subene nun bubuseene e nun xɔline, fɔ Nuhan kedenna, e nun naxanye yi a fɛma kunkin kui. ");
INSERT INTO yal_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Fufaan yi din dunuɲa ra xii kɛmɛ xii tonge suulun. ");
INSERT INTO yal_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Koni Ala yi a xaxili lu Nuhan xɔn ma, e nun burunna subene, e nun xuruseen naxanye yi a fɛma kunkin kui. Ala yi foyen nafa dunuɲa yi. Igen yi godo fɔlɔ. ");
INSERT INTO yal_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Igen naxan yi kelima bɔxɔn bun ma, na yi dan. Igen naxan yi kelima kore, na fan yi dan. ");
INSERT INTO yal_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Lɔxɔ yo lɔxɔ fɔ nde ba igen na. Xii kɛmɛ xii tongo suulunna bun ma, igen yi yelin godɛ. ");
INSERT INTO yal_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Kike soloferen xii fu nun soloferedeni, kunkin yi dɔxɔ geyaan fari, naxan xili Ararati. ");
INSERT INTO yal_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Igen yi lu godɛ han kike fudeni. Kike fuden xii singe lɔxɔni, geyane xunne yi mini kɛnɛnni. ");
INSERT INTO yal_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Xii tonge naanin dangu xanbini, Nuhan yi kunkin foye soden nabi, a bata yi naxan nafala a ma. ");
INSERT INTO yal_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","A yi xaxaan beɲin. Na yi a firifiri, han igen yi yelin godɛ. ");
INSERT INTO yal_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nuhan mɔn yi ganban beɲin, a xa sa igen mato xa a bata godo. ");
INSERT INTO yal_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Koni na ganban mi san tide to, bayo igen yi dinxi dunuɲa birin na. A yi xɛtɛ Nuhan ma kunkin kui. Nuhan yi ganban suxu a yiin na, a a raso kunkin kui. ");
INSERT INTO yal_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","A yi a mamɛ han xii solofere. A mɔn yi ganban beɲin a firindeni. ");
INSERT INTO yal_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ɲinbanna ra ganban yi xɛtɛ Nuhan ma, oliwi wudi binla ɲɔxɔnde xinden suxi a dɛɛ ra. Awa, Nuhan yi a kolon a igen bata ba dunuɲa xun ma. ");
INSERT INTO yal_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","A mɔn yi a mamɛ xi solofere. A mɔn yi ganban beɲin, koni ganban mi xɛtɛ a ma. ");
INSERT INTO yal_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhan ma siimayaan to siga ɲɛɛ kɛmɛ sennin ɲɛɛ keden, kike keden, xi keden, fufaan yi ɲan dunuɲa yi. Nuhan to kunkin xunna ba, a yi a to bɔxɔn maxaraxi. ");
INSERT INTO yal_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kike firin xi mɔxɔɲɛn nun solofere to dangu, bɔxɔn yi xara gben! ");
INSERT INTO yal_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ala yi a fala Nuhan xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ɛ mini kunkin kui, i tan nun i ya ɲaxanla nun i ya diine, e nun i ya diine ɲaxanle. ");
INSERT INTO yal_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","I xa niimaseen birin namini kunkin kui: xɔline nun subene e nun bubuseene, alogo e xa wuya, e xa yiriwa dunuɲa yi.” ");
INSERT INTO yal_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Awa, Nuhan yi mini, e nun a diine nun a ɲaxanla nun a diine ɲaxanle. ");
INSERT INTO yal_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Subene fan yi mini e nun bubuseene nun xɔline. Niimaseen birin, bɔnsɔn yo bɔnsɔn, e mini e danna. ");
INSERT INTO yal_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Na xanbi ra, Nuhan yi saraxa ganden nafala Alatala xinli. A yi sube radaxaxina ndee tongo e nun xɔli radaxaxina ndee. A yi ne ba saraxan na, ne yi sa tɛɛni. ");
INSERT INTO yal_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Tutun to te, Alatala yi na gan xirin mɛ. A yi rafan a ma. A yi a fala a bɔɲɛni, a naxa, “N mi bɔxɔn dangama sɔnɔn adamana fe ra, bayo n na a kolon adama bɔɲɛn mi fan xabu a dii ɲɔrɛya waxatini. N mi niimaseen birin halagima sɔnɔn alo n na singen liga kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Fanni bɔxɔn daxi, xɛɛ bi waxatin nun se xaba waxatina, xunbenla nun kuye wolonna, soge furen nun ɲɛmɛna, yanyin nun kɔɛna, ne waxatine mi fa bama e kiini sɔnɔn.” ");
INSERT INTO yal_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Na xanbi ra, Ala yi barakan sa Nuhan nun a diine fe yi. A yi a fala e xa, a naxa, “Ɛ xa diin bari, ɛ xa wuya, ɛ xa bɔxɔn nafe. ");
INSERT INTO yal_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Suben birin gaxuma ɛ yɛɛ ra nɛn naxanye bɔxɔn ma, xɔliin naxanye birin kore, bubuseen birin, yɛxɛn naxan birin baani, ɛ luma nɛn ne birin xun na. ");
INSERT INTO yal_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Niimaseen naxan birin yengima e findima nɛn ɛ balon na. N sansine so ɛ yii kii naxan yi a singeni, iki n bata niimaseen birin fan so ɛ yii na kiini.” ");
INSERT INTO yal_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Koni ɛ nama sube yifaxin don bayo a niin wunla a yi. ");
INSERT INTO yal_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ɛ dɛntɛgɛn sama n xa niin wunla nan ma fe ra. Suben fan dɛntɛgɛn sama n xa niin wunla nan ma fe ra. Adaman dɛntɛgɛn sama n xa nɛn a adaman boden niin wunla a fe ra. ");
INSERT INTO yal_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Muxun naxan muxun niin bama, muxun nan a fan niin bama, bayo Ala bata adaman da a misaala ra. ");
INSERT INTO yal_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ɛ xa diin bari, ɛ xa wuya, ɛ xa bɔxɔn nafe ɛ yi yiriwa ayi.” ");
INSERT INTO yal_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Na xanbi ra, Ala yi a fala Nuhan xa e nun a diine, ");
INSERT INTO yal_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","a naxa, “N yɛtɛɛn bata layirin tongo ɛ xa e nun ɛ mamandenne, ");
INSERT INTO yal_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","e nun niimaseen naxan birin yi ɛ fɛma kunkin kui: xɔline nun xuruseene nun burunna subene e nun niimaseen naxan birin dunuɲa yi. ");
INSERT INTO yal_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","N bata layirin tongo ɛ xa: fufaan mi niin birin bama sɔnɔn. Fufaan mi dunuɲa birin kalama sɔnɔn.” ");
INSERT INTO yal_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ala yi a fala, a naxa, “N bata layirin tongo ɛ nun ɛ mamandenne xa e nun niimaseen birin xa. ");
INSERT INTO yal_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","N sengunna yitama nɛn koren ma, naxan findima layirin taxamasenna ra n tan nun bɔxɔn tagi. ");
INSERT INTO yal_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","N na tulen sa koren ma, sengunna minima nɛn. ");
INSERT INTO yal_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Na waxatini na layirina fe rabirama n ma nɛn, n layirin naxan tongoxi ɛ xa e nun niimaseen birin xa. N mi niin birin bama dunuɲa yi fufaan na sɔnɔn. ");
INSERT INTO yal_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Sengunna na mini koren ma, n na a to, na layirina fe rabirama n ma nɛn, layirin naxan luma habadan, n layirin naxan tongoxi ɛ xa e nun niimaseen birin xa naxanye dunuɲa yi.” ");
INSERT INTO yal_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Awa, Ala yi a fala Nuhan xa, a naxa, “Sengunni ito findixi layiri taxamasenna nan na, n nun niimaseen birin tagi dunuɲa yi.” ");
INSERT INTO yal_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuhan ma diin naxanye mini kunkin kui, e xili Semi nun Xami nun Yepeti. Kanan kaane baba nan yi Xami ra. ");
INSERT INTO yal_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Muxun naxan birin wuyaxi dunuɲa yi, a kelixi Nuhan ma dii saxanne nin. ");
INSERT INTO yal_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhan xɛɛ rawanla nan yi a ra. A yi manpa binla sansiin si langan kui. ");
INSERT INTO yal_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Na sansiin to bogi, Nuhan yi manpaan nafala, a yi a min, a xunna yi keli. A yi a sa bubun kui a magenla ra. ");
INSERT INTO yal_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Xami, Kanan kaane baba yi a baba magenla to. A yi na fala a tadane xa. ");
INSERT INTO yal_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Semi nun Yepeti yi dugin tongo, e yi siga e xanbiramaan na. E yi dugin sa e baba fari, koni e mi e baba magenla to. ");
INSERT INTO yal_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuhan xunna to dɔxɔ, a keli, a yi a kolon a bolokada naxan ligaxi a ra. ");
INSERT INTO yal_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Nuhan yi a fala, a naxa, “N bata Kanan danga. A findima konyi dɔnxɛn nan na a tadane xa.” ");
INSERT INTO yal_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","A mɔn yi a fala, a naxa, “N bata barikan bira Alatala xa, Semi a Ala. Kanan xa findi Semi a konyin na. ");
INSERT INTO yal_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ala xa Yepeti a bɔxɔn gbo ayi. Yepeti xa lu Semi a bubun kui. Kanan xa findi Yepeti a konyin na.” ");
INSERT INTO yal_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Fufaan ɲan xanbini, Nuhan yi ɲɛɛ kɛmɛ saxan ɲɛɛ tonge suulun sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuhan ma siimayaan yi siga ɲɛɛ kɛmɛ solomanaanin ɲɛɛ tonge suulun. Na xanbi ra, a yi faxa. Nuhan ma diine, Semi nun Xami nun Yepeti a taruxun nan na ra. ");
INSERT INTO yal_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nuhan ma diine bɔnsɔnne taruxun ni i ra, Semi nun Xami nun Yepeti naxanye diine bari fufaan dangu xanbini. ");
INSERT INTO yal_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yepeti a diine xinle ni itoe ra: Gomɛrɛ nun Magogo nun Madayi nun Yawani nun Tubali nun Mesɛki e nun Tirasi. ");
INSERT INTO yal_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomɛrɛ a diine xinle ni itoe ra: Asikenasi nun Rifati nun Togarama. ");
INSERT INTO yal_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawani a diine xinle ni itoe ra: Elisaha nun Tarasisi nun Sipiri nun Rodanimi. ");
INSERT INTO yal_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Muxuni itoe diine yi dɔxɔ fɔxɔ igen dɛ. E na siga dɛnaxan yi, e xabilayaan fɔlɔ mɛnni. Na xabilane yi findi siya gbɛtɛne ra, birin nun e kon xuina. ");
INSERT INTO yal_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Xami a diine xinle ni itoe ra: Kusi nun Misiran nun Puti nun Kanan. ");
INSERT INTO yal_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusi a diine xinle ni itoe ra: Sɛba nun Xawila nun Sabata nun Raama nun Sabiteka. Raama a diine xinle ni itoe ra: Saba e nun Dedan. ");
INSERT INTO yal_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusi fan diin sɔtɔ nɛn naxan xili Nimirodi. Na findi yɛngɛso gbeen nan na dunuɲa yi. ");
INSERT INTO yal_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimirodi fan, donso gbeen nan yi a ra Alatala yɛɛ ra yi. Nanara, muxune a falama, e naxa, “I luxi alo Nimirodi, donso gbeen nan yi a ra Alatala yɛɛ ra yi.” ");
INSERT INTO yal_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","A mangayaan liga nɛn taani itoe ma singen: Babilɔn nun Ereki nun Akadi nun Kalene taan naxan Sinari bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","A yi keli Sinari yi, a yi siga Asiriya bɔxɔni. Mɛnni, a yi taane ti naxanye xili Niniwa nun Rehoboti nun Iri nun Kala ");
INSERT INTO yal_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","e nun Resen, taa gbeen naxan Niniwa nun Kala tagi. ");
INSERT INTO yal_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misiran yi findi muxuni itoe benban na: Ludu kaane nun Anami kaane nun Lehaba kaane nun Nafatu kaane ");
INSERT INTO yal_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","nun Patirusu kaane nun Kasaluxu kaane, Filisitine keli dɛnaxan yi, e nun Kafatoro kaane. ");
INSERT INTO yal_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanan yi findi muxuni itoe baba ra: Sidɔn, a dii singena, e nun Xitine ");
INSERT INTO yal_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","nun Yebusune nun Amorine nun Girigasane ");
INSERT INTO yal_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","nun Xiwine nun Arakane nun Sini kaane ");
INSERT INTO yal_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","nun Arawada kaane nun Sɛmara kaane nun Xamata kaane. Na xanbi ra, Kanan bɔnsɔnne birin yi xuya ayi. ");
INSERT INTO yal_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanan bɔxɔn naninna yi kelixi Sidɔn han sa dɔxɔ Gerari taan na, a yi siga han Gasa, a yi dangu Sodoma nun Gomora nun Adamaha nun Seboyimi yi, han sa dɔxɔ Lasa ra. ");
INSERT INTO yal_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Xami a muxune ni itoe ra, fata e bɔnsɔnna nun e xuiin na e nun e bɔxɔne, e nun e siyane. ");
INSERT INTO yal_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semi, Yepeti tada fan yi diine sɔtɔ. Semi findi Eberi a diine benban nan na. ");
INSERT INTO yal_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semi a diine xinle ni itoe ra: Elan nun Asuri nun Arapaxadi nun Ludu e nun Arami. ");
INSERT INTO yal_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arami a diine xinle ni itoe ra: Yusu nun Xulu nun Geteri e nun Mesɛki. ");
INSERT INTO yal_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arapaxadi yi Selaxa sɔtɔ. Selaxa yi Eberi sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi yi dii firin sɔtɔ. Keden xili Pɛlɛgi bayo dunuɲa yitaxun a waxatin nin. A xunyɛn xili Yokatan. ");
INSERT INTO yal_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokatan ma diine xinle ni itoe ra: Alomodadi nun Selefa nun Xasaramaweti nun Yera ");
INSERT INTO yal_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","nun Hadoran nun Yusali nun Dikila ");
INSERT INTO yal_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","nun Obala nun Abimayele nun Saba ");
INSERT INTO yal_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","nun Ofiri nun Xawila nun Yobabo. Ne birin baba nan yi Yokatan na. ");
INSERT INTO yal_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","E bɔxɔn yi kelixi Mesa sa dɔxɔ han Sefare, naxan geyaan sogeteden binni. ");
INSERT INTO yal_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Semi a diine ni i ra, fata e bɔnsɔnne nun e xuine nun e bɔxɔne nun e siyane ra. ");
INSERT INTO yal_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nuhan ma diine bɔnsɔnne nan ne ra e siyane yɛɛn ma. Fufaan dangu xanbini, bɔnsɔnni itoe yi findi siyane birin na dunuɲa yi. ");
INSERT INTO yal_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Na waxatini, dunuɲa birin yi xui keden nan falama. ");
INSERT INTO yal_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Muxuna ndee to siga sogeteden binni, e yi dɔxɔ Sinari lanbanni. ");
INSERT INTO yal_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","E yi a fala e bode xa, e naxa, “En siga, en xa bitikidin bɔnbɔ, en xa a gan.” E yi bitikidine dɔxɔ gɛmɛne ɲɔxɔni. E yi dolen findi bitikidi dɔxɔ seen na. ");
INSERT INTO yal_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Na xanbi ra, e yi a fala, e naxa, “En siga, en xa taan ti en yɛtɛ xa, e nun sanganso gbeen naxan tema han kore, alogo en xinla xa gbo ayi. Nanara, en nama xuya ayi dunuɲa xun xɔn.” ");
INSERT INTO yal_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Koni Alatala yi godo na taan nun sanganso gbeen matodeni muxune naxan ti. ");
INSERT INTO yal_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Alatala yi a fala, a naxa, “Muxuni itoe, naxanye siya keden, xui keden a ra, xa ne bata wanli ito fɔlɔ, wanla birin e waxi naxan kɛ feni sɔnɔn, e na ligama nɛn. ");
INSERT INTO yal_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","En siga, en godo e xuiin basandeni alogo e nama e bode xuiin mɛ.” ");
INSERT INTO yal_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Alatala yi e raxuya ayi. Na taan ti feen yi dan. ");
INSERT INTO yal_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Na yiren yi xili Babeli, bayo Alatala bata dunuɲa xuine basan e bode ra na yi. Fɔlɔ mɛnni, Alatala yi e raxuya ayi dunuɲa birin ma. ");
INSERT INTO yal_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Semi bɔnsɔnna taruxun ni i ra. Fufaan dangu ɲɛɛn firinna, Semi a siimayaan yi ɲɛɛ kɛmɛ sɔtɔ. A yi a diin sɔtɔ naxan xili Arapaxadi. ");
INSERT INTO yal_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arapaxadi bari xanbini, Semi mɔn yi ɲɛɛ kɛmɛ suulun sɔtɔ. A yi dii xɛmɛne nun dii tɛmɛ gbɛtɛne sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arapaxadi to ɲɛɛ tonge suulun nun suulun sɔtɔ, a yi Selaxa bari. ");
INSERT INTO yal_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","A to Selaxa sɔtɔ, Arapaxadi yi bu ɲɛɛ kɛmɛ naanin ɲɛɛ saxan. A yi dii xɛmɛne nun dii tɛmɛ gbɛtɛne sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selaxa to ɲɛɛ tonge saxan sɔtɔ, a yi Eberi bari. ");
INSERT INTO yal_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","A to Eberi sɔtɔ, Selaxa yi bu ɲɛɛ kɛmɛ naanin ɲɛɛ saxan. A yi dii xɛmɛn nun dii tɛmɛ gbɛtɛne sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberi to ɲɛɛ tonge saxan e nun naanin sɔtɔ, a yi Pɛlɛgi bari. ");
INSERT INTO yal_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","A to Pɛlɛgi sɔtɔ, Eberi yi bu ɲɛɛ kɛmɛ naanin ɲɛɛ tonge saxan. A yi dii xɛmɛn nun dii tɛmɛ gbɛtɛne sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pɛlɛgi to ɲɛɛ tonge saxan sɔtɔ, a yi Rewu bari. ");
INSERT INTO yal_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","A to Rewu sɔtɔ, Pɛlɛgi yi bu ɲɛɛ kɛmɛ firin ɲɛɛ solomanaanin. A yi dii xɛmɛn nun dii tɛmɛ gbɛtɛne sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rewu to ɲɛɛ tonge saxan nun firin sɔtɔ, a yi Serugu bari. ");
INSERT INTO yal_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","A to Serugu sɔtɔ, Rewu yi bu ɲɛɛ kɛmɛ firin ɲɛɛ solofere. A yi dii xɛmɛn nun dii tɛmɛ gbɛtɛne sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugu to ɲɛɛ tonge saxan sɔtɔ, a yi Nahori bari. ");
INSERT INTO yal_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","A to Nahori sɔtɔ, Serugu yi bu ɲɛɛ kɛmɛ firin. A yi dii xɛmɛn nun dii tɛmɛ gbɛtɛne sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahori to ɲɛɛ mɔxɔɲɛn nun solomanaanin sɔtɔ, a yi Tera bari. ");
INSERT INTO yal_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","A to Tera sɔtɔ, Nahori yi bu ɲɛɛ kɛmɛ ɲɛɛ fu nun solomanaanin. A yi dii xɛmɛn nun dii tɛmɛ gbɛtɛne sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera to ɲɛɛ tonge solofere sɔtɔ, a yi Iburama nun Nahori nun Haran bari. ");
INSERT INTO yal_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera bɔnsɔnna taruxun ni i ra. Tera yi Iburama nun Nahori nun Haran bari. Haran yi Loti bari. ");
INSERT INTO yal_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Benun Tera xa faxa, a diin Haran yi faxa Yuru taani Babilɔn bɔxɔni, a barixi dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Iburama nun Nahori yi ɲaxanle futu. Iburama ɲaxanla yi xili Sarayi. Nahori a ɲaxanla xili Milika. Milika baba nan yi Haran na. Haran dii firin nan sɔtɔ, Milika nun Isika. ");
INSERT INTO yal_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Gbantan nan yi Sarayi ra. Dii yo mi yi a yii. ");
INSERT INTO yal_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera yi a denbayaan xali, a dii Iburama, e nun a mamandenna Loti, Haran ma diina, e nun a mamandenna Sarayi, Iburamaa ɲaxanla. E birin yi keli Yuru taani Babilɔn bɔxɔni alogo e xa siga Kanan bɔxɔni. Koni e to Xarani taan li, e yi dɔxɔ mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera yi bu ɲɛɛ kɛmɛ firin ɲɛɛ suulun. A yi faxa Xarani yi. ");
INSERT INTO yal_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Alatala yi a fala Iburama xa, a naxa, “Keli i ya yamanan nun i xabilan nun i babaa genli. I siga na yamanani n naxan yitama i ra. ");
INSERT INTO yal_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","N ni i findima siya gbeen na nɛn. N na i barakama nɛn, n ni i findi xili kanna ra. Muxune fan duban sɔtɔma nɛn i tan barakani. ");
INSERT INTO yal_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Naxan na duba i xa, n fan na kanna barakama nɛn. Naxan na i danga, n fan dangan nagidima na kanna ma nɛn. Dunuɲa xabilane birin duban sɔtɔma nɛn i tan barakani.” ");
INSERT INTO yal_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Awa, a siin ɲɛɛ tonge solofere e nun suulunna sɔtɔ waxatin naxan yi, Iburama yi keli Xarani yi alo Alatala a yitaxi a ra kii naxan yi. Loti fan yi siga Iburama fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","A yi a ɲaxanla Sarayi nun a xunyɛna dii Loti nun a sɔtɔ seen birin, e nun muxune a naxanye sɔtɔxi Xarani yi, a yi ne birin xali. E yi siga Kanan bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Iburama yi dangu bɔxɔn na han a sa wudi bili gbeen li dɛnaxan yi xili Morɛ, Siken bɔxɔni. Na waxatini, Kanan kaane yi dɔxi mɛnni nun. ");
INSERT INTO yal_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Koni Alatala yi a yɛtɛ yita Iburama ra. A yi a fala, a naxa, “N bɔxɔni ito nan fima i yixɛtɛne ma.” Awa, Iburama yi saraxa ganden nafala Alatala xa naxan a yɛtɛ yitaxi a ra. ");
INSERT INTO yal_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","A yi keli mɛnni, a siga geyaan ma, geyaan naxan Betɛli sogeteden binni. A yi bubun ti mɛnni. Betɛli taan yi lu a sogegododeni. Ayi taan yi lu a sogetedeni. A yi saraxa ganden nafala Alatala xa mɛnni. A yi Alatala maxandi a xinla ra. ");
INSERT INTO yal_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Na xanbi ra, a yi siga Negewi tonbonna binni. ");
INSERT INTO yal_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Na waxatini, fitina kamɛn yi so bɔxɔni. Awa, Iburama yi siga Misiran bɔxɔni bayo donse yo mi yi na. ");
INSERT INTO yal_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Benun e xa so Misiran bɔxɔni, Iburama yi a fala a ɲaxanla Sarayi xa, a naxa, “A kolon, ɲaxalan tofaɲin nan i tan na. ");
INSERT INTO yal_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Misiran kaane na i to waxatin naxan yi, e a falama nɛn a n ma ɲaxanla nan i ra. Na xanbi ra, e n faxama nɛn, koni e mi i tan faxɛ. ");
INSERT INTO yal_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","I xa a fala e xa a n xunyɛn nan i tan na, alogo e xa kininkinin n ma i sabun na. Nayi, e mi n faxama i tan ma fe ra.” ");
INSERT INTO yal_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Iburama to Misiran li, Misiran kaane yi a to, a Sarayi ɲaxalan tofaɲin nan a ra. ");
INSERT INTO yal_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Misiran Mangana kuntigine yi ɲaxanla ito matɔxɔ Misiran Mangan xa. Misiran Mangan yi a xali a konni. ");
INSERT INTO yal_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","A yi hinan Iburama ra a ɲaxanla fe ra. Iburama yi xuruse xunxurine nun ɲingene nun sofanle nun konyine nun ɲɔgɔmɛne sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Koni Alatala yi fure ɲaxin sa Misiran Mangan nun a denbayaan ma Sarayi a fe ra, Iburama ɲaxanla. ");
INSERT INTO yal_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Nanara, Misiran Mangan yi Iburama xili. A yi a fala, a naxa, “I nanse ligaxi n na? Nanfera i mi a falaxi n xa i ya ɲaxanla nan a ra. ");
INSERT INTO yal_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nanfera i ya falaxi a i xunyɛn nan a ra han n tan bata a findi n ma ɲaxanla ra? Awa, hɔn, i ya ɲaxanla ni i ra. Ɛ siga!” ");
INSERT INTO yal_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Na xanbi, Misiran Mangan yi yamarin fi a sofane ma lan Iburama a fe ma. E yi a ragbɛngbɛn e nun a ɲaxanla, e nun a yii seen birin. ");
INSERT INTO yal_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Awa, Iburama yi keli Misiran yamanani. A yi siga Negewi tonbonna mabinni e nun a ɲaxanla nun a seen birin, e nun Loti. ");
INSERT INTO yal_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Iburama bata yi findi nafulu kanna ra nun. Xuruseene nun gbetin nun xɛmaan yi a yii. ");
INSERT INTO yal_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","A keli Negewi yi, a yi a masiga han Betɛli taani. Yirena nde yi Betɛli taan nun Ayi taan longonna ra, Iburama bubun yi tixi mɛnna nan singe yi. ");
INSERT INTO yal_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","A saraxa gande singen fan yi mɛnna nin nun. Iburama yi Alatala maxandi a xinla ra mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loti yi biraxi Iburama fɔxɔ ra, xuruseene nun bubune yi a fan yii nun. ");
INSERT INTO yal_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Iburama a xuruse ganla nun Loti a xuruse ganla yi gbo na bɔxɔn xa. E mi yi nɔɛ luyɛ yire kedenni sɔnɔn. ");
INSERT INTO yal_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Sɔnxɔ sɔnxɔn yi mini Iburama xuruse rabane nun Loti a xuruse rabane tagi. Kanan kaane nun Perisi kaane fan yi mɛnni na waxatini. ");
INSERT INTO yal_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Nanara, Iburama yi a fala Loti xa, a naxa, “Sɔnxɔ sɔnxɔn nama bira en tagi e nun en ma xuruse rabane tagi, bayo en tan ngaxakedenmane nan en na. ");
INSERT INTO yal_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Bɔxɔni ito birin i yɛɛ ra. Awa, en xa fata. Xa i siga kɔmɛnna ma, n tan yi siga yiifanna ma. Xa i siga yiifanna ma, n tan yi siga kɔmɛnna ma.” ");
INSERT INTO yal_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti yi a yɛɛn nasiga, a yi sa Yurudɛn mɛrɛn to. Igen yi na nun a faɲin na. Benun Alatala xa Sodoma nun Gomora halagi, na bɔxɔne yi fan han Soyari binni, alo Misiran bɔxɔna, alo Alatala a nakɔ rafalaxina. ");
INSERT INTO yal_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Awa, Loti yi Yurudɛn mɛrɛn sugandi a yɛtɛ xa. A yi siga sogeteden mabinni. E yi fata. ");
INSERT INTO yal_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Iburama yi lu Kanan bɔxɔni. Loti yi lu Yurudɛn mɛrɛn taane tagini. A yi bubun ti Sodoma fɛma. ");
INSERT INTO yal_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodoma kaane bata yi kobi ayi a gbegbe, e bata yi findi yulubi kan belebelen na Alatala yɛɛ ra yi. ");
INSERT INTO yal_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Iburama nun Loti to fata, Alatala yi a fala Iburama xa, a naxa, “I yɛɛn ti sogeteden na, e nun sogegododen na, e nun yiifanna nun kɔmɛnna ma. ");
INSERT INTO yal_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","I bɔxɔn naxan birin toxi, n na a fima i ma nɛn e nun i bɔnsɔnna ma han habadan. ");
INSERT INTO yal_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","N ni i bɔnsɔnna rawuyama ayi nɛn alo gbangbanna naxan bɔxɔn ma. Xa muxun nɔɛ mɛɲɛnsinna tɛngɛ, awa, a nɔɛ nɛn i bɔnsɔnna yatɛn kolonɲɛ. ");
INSERT INTO yal_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Keli, i bɔxɔni siga, a kuye yɛɛn nun a yigbo yɛɛna, i xa a birin mato bayo n na a fima i tan nan ma.” ");
INSERT INTO yal_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Awa, Iburama yi bubun yiren masara. A yi dɔxɔ wudi belebelena nde mabinna ra Mamire nun Xebiron fɛma. A yi saraxa ganden nafala mɛnni Alatala xa. ");
INSERT INTO yal_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Na waxatini, Manga Amirofɛli naxan Babilɔn bɔxɔn ma yo, Manga Ariyoki naxan Elasari bɔxɔn ma yo, Manga Kɛdolama naxan Elan bɔxɔn ma yo, Manga Tidali naxan Goyin bɔxɔn ma yo, manga naaninni itoe yi layirin tongo e bode xa manga suulun ni itoe yɛngɛ feen na. ");
INSERT INTO yal_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Na manga suulunne nan itoe ra: Bera Sodoma mangan nun Birisa Gomora mangan nun Sinabu Adamaha mangan nun Sɛmɛbɛri Seboyimi mangana e nun Bela mangana. Bela mɔn xili Soyari. ");
INSERT INTO yal_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Manga suulunni itoe yi e malan Sidimi lanbanni, Fɔxɔ Daraan dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Xabu ɲɛɛ fu nun firin manga suulunni itoe yi Manga Kɛdolama bun ma, koni a ɲɛɛ fu nun saxanden na, e yi murutɛ. ");
INSERT INTO yal_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","A ɲɛɛ fu nun naanindena, Manga Kɛdolama nun mangan naxanye yi a fɛma, e yi siga yɛngɛ sodeni. E yi siyani itoe birin nɔ yɛngɛni: Refa kaan naxanye yi Asatarɔti-Karinayin yi, Susi kaan naxanye yi Xami yi, Emi kaan naxanye yi Sihawe-Kiriyatayimi yi, ");
INSERT INTO yal_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","e nun Xori kaan naxanye yi geyaan ma Seyiri binni han Eli-Paran tonbonna fɛma. ");
INSERT INTO yal_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Na xanbi e yi xɛtɛ, e yi siga En-Misapati, naxan xili Kadesi. E yi Amalɛkine nɔ e nun Amorin naxanye yi dɔxi Xasasɔn-Tamari yi. ");
INSERT INTO yal_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Na waxatini, Sodoma mangan nun Gomora mangan nun Adamaha mangan nun Seboyimi mangan nun Bela mangan dɛnaxan mɔn xili Soyari, na mangane yi e malan Sidimi lanbanni manga naaninni itoe yɛngɛdeni: ");
INSERT INTO yal_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kɛdolama Elan mangan nun Tidali Goyin mangan nun Amirofɛli Babilɔn mangan nun Ariyoki Elasari mangana. Na manga naaninna yi manga suulunna yɛngɛ. ");
INSERT INTO yal_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Awa, yinle yi Sidimi lanbanni, dolena e kui. Sodoma mangan nun Gomora mangan yi e gi. Yɛngɛsona ndee yi bira yinle ra. Ndee yi e gi siga geyaan fari. ");
INSERT INTO yal_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Na manga naanin naxanye nɔɔn sɔtɔxi, ne yi nafunla nun donseene birin tongo Sodoma taan nun Gomora taani. E yi siga. ");
INSERT INTO yal_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","E yi Iburama xunyɛna dii Loti fan suxu e nun a hɛrisigɛn birin, bayo a yi dɔxi Sodoma taan kui. ");
INSERT INTO yal_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Muxuna nde yi a gi, a sa na feen birin yɛba Iburama Heburu kaan xa. Na waxatini, Iburama yi dɔxi wudi bili belebelen bun ma Mamire Amorin konni. Mamire nun a ngaxakedenne, Esikoli nun Aneri, ne bata yi layirin tongo Iburama xa. ");
INSERT INTO yal_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Iburama to a mɛ, muxune bata a xunyɛna dii xɛmɛ Loti suxu, a yi yɛngɛsone tongo, muxu kɛmɛ saxan muxu fu nun solomasɛxɛ naxanye barixi a sariyan kui, naxanye fatan yɛngɛ sodeni. E yi siga na mangane fɔxɔ ra han taan naxan xili Dan. ");
INSERT INTO yal_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Kɔɛɛn na, Iburama yi a yɛngɛsone yitaxun, e yi na mangane ratɛrɛna yɛngɛn na. E nun a yɛngɛsone yi nɔ na mangane matuntunɲɛ han Xoba, Damasi taan kɔmɛnna ma. ");
INSERT INTO yal_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","A yi fa e hɛrisigɛn birin na, a yi fa a xunyɛna diin Loti fan na, e nun a sɔtɔ seen birin, sa ɲaxanle fari e nun yamaan birin. ");
INSERT INTO yal_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Iburama to xɛtɛ xunna kenla kui, keli Manga Kɛdolama yɛngɛdeni e nun mangan naxanye yi a fɛma, Sodoma mangan yi siga Iburama ralandeni Sihawe lanbanni. Mɛnna xili “Mangana Lanbanna.” ");
INSERT INTO yal_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Na xanbi, Mɛlikisedeki, Salemi mangan yi fa burun nun wudi bogi igen na Iburama xa alo manpana. Kore Xɔnna Ala a saraxaraliin nan yi Mɛlikisedeki ra. ");
INSERT INTO yal_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","A yi duba Iburama xa, a naxa, “Kore Xɔnna Ala naxan koren nun bɔxɔn daxi, na xa Iburama barayi. ");
INSERT INTO yal_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Tantunna Kore Xɔnna Ala xa, naxan i yaxune rayarabixi i xa.” Na waxatini, Iburama yi a se tongoxine birin yaganna fi Mɛlikisedeki ma. ");
INSERT INTO yal_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodoma mangan yi a fala Iburama xa, a naxa, “N ma muxune raxɛtɛ n ma, koni nafunla xa lu i tan xa.” ");
INSERT INTO yal_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Koni Iburama yi a fala Sodoma mangan xa, a naxa, “N bata n kɔlɔ Alatala yi, Kore Xɔnna Ala naxan koren nun bɔxɔn daxi, ");
INSERT INTO yal_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","n mi sese tongɛ naxan findixi i gbeen na, hali lutidina, xa na mi a ra sankidi lutina, alogo i nama a fala sɔnɔn fa fala ‘N tan nan Iburama findi nafulu kanna ra.’ ");
INSERT INTO yal_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","N mi sese tongɛ, fɔ n ma yɛngɛsone naxan donxi e nun naxan findixi e gbeen na. Aneri nun Esikoli nun Mamire e gbeen tongoma nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Na xanbi, Iburama yi fe toon ti alo xiyena, Alatala yi fa a ma, a yi a fala a xa, a naxa, “Iburama i nama gaxu, n tan nan i kantanma. I saran gbeen sɔtɔma nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Iburama yi a yabi, a naxa, “Marigina Alatala, i nanse ɲɛnigexi i naxan soma n yii? Bayo dii yo mi n yii. N mi dii sɔtɔxi naxan n kɛɛn tongoma fɔ n ma walikɛna, Eliyeseri Damasi kaana. ");
INSERT INTO yal_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","I mi dii yo fixi n tan ma. Nanara, n ma walikɛɛn naxan barixi n konni, na nan findima n kɛɛ tongon na.” ");
INSERT INTO yal_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Alatala yi a yabi, a naxa, “Ɛn-ɛn, i ya walikɛɛn mi findima i kɛɛ tongon na de! I bari diin yatin nan fama findideni i kɛɛ tongon na.” ");
INSERT INTO yal_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ala yi Iburama ramini a bubun bun ma, a yi a fala a xa, a naxa, “I yɛɛn nate kore. I sarene tɛngɛ xa i nɔɛ a yatɛn kolonɲɛ.” A mɔn yi a fala a xa, a naxa, “I ne toxi kii naxan yi kuyen ma, i bɔnsɔnna fan wuyama ayi na kiini nɛn, i mi nɔɛ a yatɛn kolonɲɛ.” ");
INSERT INTO yal_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Iburama yi dɛnkɛlɛya Alatala ma, Ala fan yi na yatɛ tinxinna ra a xa. ");
INSERT INTO yal_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ala yi a fala a xa, a naxa, “N tan nan Alatala ra naxan i raminixi Yuru taani Babilɔn bɔxɔni. N na i xali bɔxɔn ma n dɛnaxan fima i ma.” ");
INSERT INTO yal_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Iburama yi a maxɔdin, a naxa, “Marigina Alatala, n na a kolonma di, fa fala n fama na bɔxɔn sɔtɔdeni nɛn?” ");
INSERT INTO yal_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ala yi a fala a xa, a naxa, “Fa ɲinge gilɛn nun sii gilɛn na, e nun yɛxɛɛ kontonna naxanye bata ɲɛɛ saxan saxan ti, e nun ganba gilɛn nun kolokonde diina. I yi e fi n ma.” ");
INSERT INTO yal_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Iburama yi fa na subene ra. A yi ɲingen nun sii gilɛn nun yɛxɛɛ kontonni sɛnsɛn a tagi. A yi na sube dungine sa e dan na, koni a mi xɔline tan yixaba. ");
INSERT INTO yal_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Sɛgɛne yi fa, e godo na sube faxaxine ma. Iburama yi e birin kedi. ");
INSERT INTO yal_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Sogen godomatɔna, xixɔnla yi Iburama suxu kati! Kuyen yi yidimi, dimi magaxuxin yi so. ");
INSERT INTO yal_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ala yi a fala a xa, a naxa, “A kolon yati, i bɔnsɔnna dɔxɔma nɛn yamana gbɛtɛ yi, e konna mi dɛnaxan na. E findima nɛn konyin na na bɔxɔni. E fe xɔlɛn siyaan birin sɔtɔma nɛn ɲɛɛ kɛmɛ naaninna bun ma muxu yiini. ");
INSERT INTO yal_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Koni e na lu siyaan naxan bun konyiyani, n na makitima nɛn. Na xanbi ra, e nɛɛn minima na yamanani, e se faɲin gbegbe xalima nɛn. ");
INSERT INTO yal_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","I tan fama nɛn bɔɲɛ xunbenla sɔtɔdeni, i mɔn siimaya xunkuyen sɔtɔma nɛn, han i sa laxiraya waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","I yixɛtɛn naaninden xɛtɛma nɛn na bɔxɔni, bayo fɔ Amorine e hakɛn na gbo ayi waxatin naxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Sogen to godo, dimin yi so. Na waxatini tɛɛ kɔ seen naxan yi tutin naminima e nun tɛɛ dɛgɛna, a yi dangu sube dungine saden tagi. ");
INSERT INTO yal_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Taxamasenna nan na ra, Alatala yi layirin naxan tongoxi a tan nun Iburama tagi na lɔxɔ yɛtɛni. A yi a fala a xa, a naxa, “N bata yamanani ito fi i bɔnsɔnna ma, keli Misiran baan ma han sa dɔxɔ Efirati baa belebelen na.” ");
INSERT INTO yal_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Siya dɔxɔ wuyaxin nan yi na: Kenine nun Kenisine nun Kadimonne ");
INSERT INTO yal_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","nun Xitine nun Perisine nun Refane ");
INSERT INTO yal_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","nun Amorine nun Kanan kaane nun Girigasane e nun Yebusu kaane. ");
INSERT INTO yal_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarayi, Iburama a ɲaxanla munma yi dii yo bari a xa. Konyi gilɛ Misiran kaana nde yi walima a yii naxan yi xili Hagara. ");
INSERT INTO yal_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarayi yi a fala a xɛmɛn xa, a naxa, “I bata a to, Alatala mi dii bari feen nagidixi n tan ma. Koni yanyina nde n nɔɛ diin sɔtɛ i xa nɛn n ma konyi gilɛn sabun na. Ɛ birin nan lan ɛ xa xi to.” Iburama yi tin Sarayi a falan ma a naxan falaxi a xa. ");
INSERT INTO yal_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarayi yi a konyi gilɛn Hagara Misiran kaan tongo, a yi a so a xɛmɛna Iburama yii, a xa findi a ɲaxanla ra. Iburama bata yi ɲɛɛ fu ti Kanan bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Iburama nun Hagara yi xi yire kedenni, Hagara yi fudikan. Hagara to la a ra fa fala a bata fudikan, a yi yo a kanna ma, a yi a mato a kobin na. ");
INSERT INTO yal_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarayi yi a fala Iburama xa, a naxa, “Konbini ito, n na raxɛtɛma i tan nan ma Hagara naxan saxi n fari! Bayo, n tan nan n ma konyi gilɛn fixi i ma a xa findi i ya ɲaxanla ra. Xabu a la a ra a fudikanna na a ra, a fa fe kobin nan tun yilanma n na. Alatala xa en tan firinna makiti.” ");
INSERT INTO yal_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Iburama yi a ɲaxanla yabi, a naxa, “I ya konyi gilɛn nan a ra. A walima i tan nan yii. I waxi feen naxan birin xɔn ma, a birin liga a ra.” Na waxatini, Sarayi fe kobin birin naxan nafan a ma, a yi a liga Hagara ra. Hagara yi a gi a bun. ");
INSERT INTO yal_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Alatalaa malekan yi naralan Hagara ra xude xunna fɛma Suru kiraan xɔn ma tonbon yireni. ");
INSERT INTO yal_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Malekan yi Hagara maxɔdin, a naxa, “Sarayi a konyi gilɛn Hagara, i kelixi minɛn yi? I sigama minɛn yi?” Hagara yi malekan yabi, a naxa, “N nan n gixi n kanna nan bun ma.” ");
INSERT INTO yal_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Alatalaa malekan yi a fala Hagara xa, a naxa, “I mɔn xa xɛtɛ i kelixi dɛnaxan yi. I mɔn xa i xuru a ma.” ");
INSERT INTO yal_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Alatala a malekan yi a fala a xa, a naxa, “N fama bɔnsɔn wuyaxi fideni nɛn i ma, i mi nɔɛ naxan yatɛn kolonɲɛ.” ");
INSERT INTO yal_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Alatalaa malekan mɔn yi a fala a xa, a naxa, “I fudikanna na a ra iki. I fama diin sɔtɔdeni. I na diin xili sama nɛn Sumayila. Bayo Ala bata i ya tɔrɔ xuiin mɛ marayarabin naxan sama i fari. ");
INSERT INTO yal_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","I ya diin luma nɛn alo burunna sofanla. A birin yɛngɛma nɛn, birin a fan yɛngɛma nɛn. E nun a xunyɛne birin luma nɛn fataxi.” ");
INSERT INTO yal_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagara yi xili sa Alatala xɔn, naxan falan tixi a xa, a naxa, “Ala Naxan N Toma.” A yi a fala, a naxa, “N bata na kanna to, naxan n toma.” ");
INSERT INTO yal_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Na nan a toxi e na xɔɲinna xinla falama, e naxa, “Niin Kanna Naxan N Toxi.” Na xɔɲinna Kadesi nun Bereda nan tagi. ");
INSERT INTO yal_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagara yi diin sɔtɔ Iburama xa. Iburama yi a xili sa Sumayila. ");
INSERT INTO yal_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Iburama bata yi ɲɛɛ tonge solomasɛxɛ e nun ɲɛɛ sennin ti siimayaan na, Hagara yi fa na diin sɔtɔ a xa. ");
INSERT INTO yal_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Iburama to ɲɛɛ tonge solomanaanin ɲɛɛ solomanaanin ti siimayaan na, Alatala yi mini a xa, a fa ito fala a xa, a naxa, “Ala Sɛnbɛ Kanna nan n tan na. I sigati kiin xa kamali n yɛɛ ra yi. ");
INSERT INTO yal_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","N fama layirin tongodeni i tan nun n tan tagi. N mɔn fama nɛn bɔnsɔn gbeen fideni i ma.” ");
INSERT INTO yal_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Iburama yi bira, a a yɛtagin lan bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ala yi a fala a xa, a naxa, “N ma layirin ni i ra n naxan tongoxi i tan nun n tan tagi. I findima nɛn siya wuyaxine benban na. ");
INSERT INTO yal_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","I xinla mi falama sɔnɔn Iburama, i xinla falama nɛn fa fala Iburahima, bayo n na i findima nɛn siya wuyaxine benban na. ");
INSERT INTO yal_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","N na i findima nɛn yama gbeen benban na. I diine sɔtɔma nɛn naxanye findima siya wuyaxine ra. Mangane fan minima nɛn i ya diine tagi. ");
INSERT INTO yal_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","N nan n ma layirin nakamalima nɛn i tan nun n tan tagi, hali i dangu xanbini, e nun i bɔnsɔnne fan yixɛtɛn fan bɔnsɔn bɔnsɔn. A findima habadan layirin nan na. Nayi, n tan nan i ya Ala ra, e nun i bɔnsɔnna hali i dangu xanbini. ");
INSERT INTO yal_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I tan nun i bɔnsɔnna, n fama nɛn bɔxɔn fideni ɛ ma, i findixi xɔɲɛn na dɛnaxan yi iki. Kanan bɔxɔn birin findima nɛn e gbeen na habadan! N tan nan e Ala ra.” ");
INSERT INTO yal_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ala mɔn yi a fala Iburahima xa, a naxa, “I tan nun i bɔnsɔnna fan yixɛtɛn bɔnsɔn bɔnsɔnna, ɛ lan nɛn ɛ xa n ma layirin nakamali. ");
INSERT INTO yal_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","En ma layirin ni i ra, n naxan saxi ɛ ma, ɛ lan ɛ xa naxan nakamali, i tan nun i bɔnsɔnne: Naxan birin findixi xɛmɛn na ɛ tagi, e birin lan nɛn e xa banxulan. ");
INSERT INTO yal_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ɛ xa na banxulanna findi layiri taxamasenna ra ɛ tan nun n tan tagi. ");
INSERT INTO yal_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Keli ɛ tan ma, sa dɔxɔ ɛ bɔnsɔn bɔnsɔnna ra, a birin lan nɛn, naxan yo barin nɛma fa xii solomasɛxɛ ti, a xa banxulan. Na sariyan lan nɛn a xa sa ɛ konyine fan ma naxanye ɛ yii, naxanye barixi ɛ konni, e nun konyin naxanye saraxi bɔxɔ gbɛtɛni, hali a mi fa i bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Na kui, konyin naxanye barixi i konni e nun i naxan fan saraxi, e birin lan nɛn e xa banxulan, alogo n ma layirin taxamasenna xa lu ɛ fatin ma habadan! ");
INSERT INTO yal_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Xɛmɛn naxan na lu a fatin mi banxulanxi, a fama nɛn naminideni ɛ bɔnsɔnni, bayo a mi layirin nakamalixi.” ");
INSERT INTO yal_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Na xanbi, Ala yi a fala Iburahima xa, a naxa, “I nama i ya ɲaxanla xinla fala sɔnɔn de, ‘Sarayi,’ a fa xili nɛn ‘Saran.’ ");
INSERT INTO yal_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","N na a barakama nɛn, a fama dii xɛmɛn barideni nɛn i xa. N na a barakama nɛn, a fama findideni nɛn siya gbeen benban na. Yamana wuyaxin mangane fama minideni nɛn a diine yi.” ");
INSERT INTO yal_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Iburahima yi bira, a yi a yɛtagin lan bɔxɔn ma, a yi gele. A yi a fala a bɔɲɛni, a naxa, “N tan naxan bata ɲɛɛ kɛmɛ ti siimayaan na, n mɔn nɔɛ diin sɔtɛ ba? Saran naxan fan bata ɲɛɛ tonge solomanaanin ti siimayaan na, a fa nɔɛ diin barɛ ba?” ");
INSERT INTO yal_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","A yi a fala Ala xa, a naxa, “I ɲɔxɔ lu Sumayila xɔn ma tun!” ");
INSERT INTO yal_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ala yi a fala, a naxa, “Ɛn-ɛn! I ya ɲaxanla Saran fama dii xɛmɛn barideni nɛn i xa, i naxan xili sama Isiyaga. N nan n ma layirin nakamalima nɛn n tan nun a tan tagi e nun a bɔnsɔnna hali a faxa xanbini. Layirin naxan mi kalama habadan! ");
INSERT INTO yal_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Na xanbi, n bata i ya maxandin nasuxu Sumayila fe ra. N na barakama nɛn, n mɔn dii gbegbe bari feen nagidima a ma nɛn, n bɔnsɔn wuyaxin fima nɛn a ma. A findima nɛn manga dii fu nun firinne baba ra, e nun siya xungbe kanna ra. ");
INSERT INTO yal_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Koni, naxan findixi n ma layirin na, n fama na rakamalideni n tan nun Isiyaga nan tagi. Saran fama nɛn dii xɛmɛn barideni i xa i ɲɔxɔn waxati faraxi.” ");
INSERT INTO yal_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ala to yelin na falɛ, a yi keli Iburahima xun ma. ");
INSERT INTO yal_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Iburahima yi a diin Sumayila tongo e nun a konyin naxanye barixi a konni, e nun a naxanye saraxi. Xɛmɛn naxanye birin a banxini, a yi e birin banxulan na lɔxɔni alo Ala a yamari kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Iburahima siin ɲɛɛ tonge solomanaanin ɲɛɛ solomanaanin nan yi a ra, ");
INSERT INTO yal_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","a dii Sumayila tan bata yi ɲɛɛ fu nun saxan ti, e banxulanxi waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","E yi e birin banxulan lɔxɔ keden ");
INSERT INTO yal_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","e nun xɛmɛn naxanye birin yi Iburahimaa banxini, konyin naxanye barixi a konni, e nun a naxanye fan saraxi keli yamana gbɛtɛ yi. ");
INSERT INTO yal_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Alatala yi mini Iburahima xa Mamire wudi bili gbeen dɛnaxan yi. Na waxatini, Iburahima yi dɔxi a bubun so dɛɛn na, kuye wolon waxatini yanyin na. ");
INSERT INTO yal_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","A yi xɛmɛ saxan to tixi a yɛtagi. A yi keli bubun so dɛɛn na, a siga mafurɛn, a sa na xɛmɛ saxanna ralan. A yi a xinbi sin. ");
INSERT INTO yal_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","A yi a fala muxu keden xa e tagi, a naxa, “N kanna, yandi ɛ nama dangu singe, ɛ xa ɛ madigan n konni. ");
INSERT INTO yal_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","N xa fa igen na ɛ xa alogo ɛ xa ɛ sanne maxa. Ɛ mɔn xa ɛ matabu wudini ito bun ma. ");
INSERT INTO yal_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","N xa fa donseen na ɛ xa alogo ɛ xa fangan sɔtɔ. Na xanbi, ɛ fa siga ɛ sigatini. Amasɔtɔ, ɛ danguma ɛ walikɛɛn konna nin.” Na xɔɲɛne yi a yabi, e naxa, “Awa, i naxan falaxi, a raba.” ");
INSERT INTO yal_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Nanara, Iburahima yi xɛtɛ a mafuraxin na a bubun kui. A yi a fala a ɲaxanla Saran xa, a naxa, “I xɔdɔxɔ. I murutu fuɲi faɲin debedin yɛ saxan nafala burun na.” ");
INSERT INTO yal_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Na xanbi, a yi a gi, a siga ɲinge sansanni, a sa ɲinge dii turaxi keden tongo. A yi na ɲinge diin so a walikɛɛn yii alogo a xa a faxa, a xa a rafala donseen na. ");
INSERT INTO yal_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Na suben to yelin ɲinɲɛ, Iburahima yi a tongo, a a so xɔɲɛne yii, e nun nɔnɔ kɛndɛna sa nɔnɔ xixin fari. E na donseen donma, Iburahima yi ti e fɛma wudin bun ma. ");
INSERT INTO yal_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Na xɔɲɛne yi Iburahima maxɔdin, e naxa, “I ya ɲaxanla Saran minɛn yi?” A yi e yabi, a naxa, “A na yi bubun bun ma.” ");
INSERT INTO yal_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Na xɔɲɛn muxu keden yi a fala Iburahima xa, a naxa, “N mɔn xɛtɛma be i ɲɔxɔn waxati faraxi. Na waxatini i ya ɲaxanla dii xɛmɛn barima nɛn i xa.” Saran yi tixi Iburahima xanbi ra bubun so dɛɛn na, a tuli matixi e falan ti xuiin na. ");
INSERT INTO yal_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Iburahima nun Saran bata yi yelin forideni nun. Saran mi yi nɔɛ diin barɛ. ");
INSERT INTO yal_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","A yi gele a yɛtɛ ma, a naxa, “N tan na sɔtɛ, n bata yelin forɛ? N kanna fan bata findi xɛmɛ fonna ra. N fan sɛwama nɛn dii sɔtɔdeni ba?” ");
INSERT INTO yal_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Alatala yi a fala Iburahima xa, a naxa, “Nanfera Saran gelexi? Nanfera a a falaxi, a tan mi nɔɛ diin barɛ sɔnɔn, bayo a bata fori? ");
INSERT INTO yal_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nanse na Alatala mi nɔɛ naxan ligɛ? N fama nɛn waxati saxini faraxi, Saran yi dii xɛmɛn bari.” ");
INSERT INTO yal_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saran yi gaxu, a yi wulen fala, a naxa, “N mi gelexi de!” A yi a fala a xa, a naxa, “Di! I gelexi nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Na xɔɲɛne yi ti kiraan xɔn ma, e yi e xun sa Sodoma taan ma. Iburahima yi siga e tideni kira yi. ");
INSERT INTO yal_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Alatala yi a fala, a naxa, “N naxan ligama, n nama na luxun Iburahima ma. ");
INSERT INTO yal_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","A fama nɛn findideni siya belebele sɛnbɛmaan na. Dunuɲa siyane birin duban sɔtɔma nɛn a tan barakani. ");
INSERT INTO yal_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","N na a sugandixi nɛn, alogo a xa a diine nun a bɔnsɔnna muxune birin yamari a e xa kiti kɛndɛn sa tinxinni. Na waxatini, n tan Alatala, n fama nɛn n ma layirin nakamalideni n naxan tongoxi Iburahima xa.” ");
INSERT INTO yal_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Alatala yi a fala Iburahima xa, a naxa, “Feen naxan falaxi Sodoma kaane nun Gomora kaane xun ma, fe magaxuxin na a ra. E yulubin bata gbo ayi han, ");
INSERT INTO yal_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","n fama gododeni nɛn, n sa a mato feen naxanye birin falaxi e xun ma, xa a na kiini. Xa e birin na feene fari, n fama a kolondeni nɛn na waxatini.” ");
INSERT INTO yal_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Xɔɲɛ firin yi keli e yi dɛnaxan yi, e yi siga Sodoma taani. Koni Alatala nun Iburahima yi lu yire kedenni. ");
INSERT INTO yal_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Iburahima yi a maso a ra, a yi a fala a xa, a naxa, “I muxu ɲaxine nun tinxin muxune halagɛ e bode xɔn ba? ");
INSERT INTO yal_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Yanyina nde tinxin muxu tonge suulun Sodoma kaane tagi. I na taan kalama nɛn? I mi diɲama Sodoma yamaan ma na tinxin muxu tonge suulunna fe ra ba? ");
INSERT INTO yal_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ɛn-ɛn, a mi lanma i xa na liga! A mi lan i xa muxu ɲaxin nun tinxin muxun faxa kii kedenni. A mi lan kiti kedenna xa sa muxu ɲaxin nun tinxin muxun ma. A mi lan i xa na liga. Naxan dunuɲa birin makitima, a mi a ligama tinxinna kiraan xɔn ma ba?” ");
INSERT INTO yal_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Alatala yi yabin ti, a naxa, “Xa n tinxin muxu tonge suulun li Sodoma taan kui, n diɲama nɛn Sodoma kaane birin ma na muxu tonge suulunna fe ra.” ");
INSERT INTO yal_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Iburahima mɔn yi falan tongo, a naxa, “Marigina, n bata i maxandi i xa diɲa n xa, n xa falani ito ti i xa, bayo n tan kelixi gbangbanna nun bɛndɛn nin. ");
INSERT INTO yal_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Xa i sa a li, tinxin muxu tonge suulun mi na yi, yanyina nde fɔ muxu tonge naanin e nun suulun nan na. I na taan kalɛ bayo muxu suulun bata dasa a ra?” Ala yi a fala, a naxa, “N mi a kalama xa n tinxin muxu tonge naanin e nun suulun li na.” ");
INSERT INTO yal_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Iburahima mɔn yi a fala a xa, a naxa, “Yanyina nde, i muxu tonge naanin nan lima na yi.” A yi a fala, a naxa, “N mi na kalama na muxu tonge naaninna fe ra.” ");
INSERT INTO yal_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Iburahima yi a fala, a naxa, “Marigina, n bata i maxandi, i nama xɔlɔ xa n mɔn falana nde ti i xa. Yanyina nde, i muxu tonge saxan nan lima na yi.” Ala yi a fala a xa, a naxa, “N mi na kalama xa n tinxin muxu tonge saxan li na yi.” ");
INSERT INTO yal_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Iburahima yi a fala, a naxa, “Marigina, i hakɛ lu n xa. Yanyina nde, i muxu mɔxɔɲɛ nan lima na.” Ala yi a fala, a naxa, “N mi na taan kalama na muxu mɔxɔɲɛna fe ra.” ");
INSERT INTO yal_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Iburahima mɔn yi a fala, a naxa, “Marigina, yandi, i nama xɔlɔ. N ma maxɔdin dɔnxɛn ni ito ra. Yanyina nde, i muxu fu nan lima na.” Ala yi a fala Iburahima xa, a naxa, “N mi na taan kalama na muxu fuuna fe ra.” ");
INSERT INTO yal_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","A to yelin falan tiyɛ e nun Iburahima, Alatala yi siga, Iburahima fan yi xɛtɛ a konni. ");
INSERT INTO yal_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ɲinbari waxatini, maleka firin yi so Sodoma taani. Na waxatini, Loti yi dɔxi na taan so dɛɛn na. A to malekane to fɛ, a yi keli, a sa e ralan kiraan xɔn ma. A yi a xinbi sin, a yɛtagin yi lan bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Loti yi a fala e xa, a naxa, “N kanne, yandi, ɛ xa so n konni. Ɛ xa ɛ sanne maxa, ɛ mɔn xa xi be to. Na xanbi, tila xɔtɔnni ɛ nɔɛ sigɛ ɛ sigatini.” Malekane yi a fala, e naxa, “Ɛn-ɛn! Fɔ nxu xa xi taan tagini to kɔɛɛn na.” ");
INSERT INTO yal_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Koni Loti yi a yixɔdɔxɔ han e yi siga a konni. A yi donse faɲin nafala e xa, a yi buru ratetaren gan e xa. E yi e dɛge. ");
INSERT INTO yal_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Sa waxatin mi yi a lixi nun, Sodoma kaane yi Loti a banxin nabilin. Keli banxulanne ma, sa dɔxɔ xɛmɛ fonne ra, e birin yi na nun. ");
INSERT INTO yal_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","E yi Loti xili, e a maxɔdin, e naxa, “Na muxune minɛn yi, naxanye soxi i konni to ɲinbanna ra. E ramini nxu ma, nxu xa nxu makoon naba e ra alo ɲaxanla.” ");
INSERT INTO yal_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti yi mini a banxin kui a ti dɛɛn na, a yi na dɛɛn nagali. ");
INSERT INTO yal_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","A yi a fala e xa, a naxa, “Ɛn-ɛn! Ngaxakedenne, ɛ nama fe ɲaxin liga. ");
INSERT INTO yal_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","N ma dii tɛmɛ firin be naxanye mi xɛmɛ feen kolon. N bata tin a ma, n xa ne sa ɛ sagoni, ɛ xa feen birin liga e ra ɛ waxi naxan xɔn ma, alogo ɛ nama sese liga n ma xɔɲɛne ra, bayo n tan bata findi e yatigin na.” ");
INSERT INTO yal_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Na muxune yi a fala Loti xa, e naxa, “Mini i ya xɔɲɛne nan na nxu yɛtagi. I mi nɔɛ kitin sɛ nxu konni. Xa i mi i kata, nxu fama fe xɔlɛn dɔxɔdeni i ra nɛn dangu e tan na.” E yi sɔnsɔn Loti ra, alogo e xa dɛɛn kala. ");
INSERT INTO yal_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Na maleka firinna yi Loti suxu, e yi a raso banxin kui, e dɛɛn balan e xun ma. ");
INSERT INTO yal_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Malekan yi ganla xunna kala, naxanye yi tixi dɛɛn na, e birin yi findi danxutɔne ra, keli banxulanne ma sa dɔxɔ xɛmɛ fonne ra han e mi yi sese toma fa. Kiraan yi yifu e ma. ");
INSERT INTO yal_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Na maleka firinna yi Loti maxɔdin, e naxa, “Muxuna nde i xa be? Hali a findixi i bitanna nan na, i ya dii xɛmɛne nun i ya dii tɛmɛne, e nun i ya muxune birin, i xa e birin namini taani ito kui ");
INSERT INTO yal_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","bayo nxu fama a halagideni. Alatala bata maxandi xui gbegbe mɛ taa yi kaani itoe wali kobine fe ra. Alatala yi nxu rafa, a nxu xa fa taani ito halagi.” ");
INSERT INTO yal_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Loti yi siga, a a fala a bitanne xa, a naxa, “Ɛ keli be mafurɛn! Alatala fama be kaladeni iki sa.” E yi a miri a sabaan nan na. ");
INSERT INTO yal_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Na subaxan ma, malekane yi digi Loti ra, e yi a fala a xa, e naxa, “Keli! I ya ɲaxanla tongo, e nun i ya dii tɛmɛ firinna naxanye be. Ɛ xa keli be alogo ɛ nama halagi ɛ nun taani ito hakɛ kanne.” ");
INSERT INTO yal_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","A to wa a madigan feni nun, malekan yi Loti suxu a yiin ma, e nun a ɲaxanla, sa a dii tɛmɛ firinna fari. E yi e ramini taan kui, bayo Alatala bata yi kininkinin e ma. ");
INSERT INTO yal_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Malekan to e ramini, keden yi a fala Loti xa, a naxa, “I gi, alogo i niin xa ratanga. I nama i xanbi rato de! I nama i mati taani ito rabilinna yire yo yi. Xa i mi waxi a xɔn i xa halagi, siga na geyane yireni.” ");
INSERT INTO yal_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Loti yi a fala, a naxa, “Ɛn-ɛn, n Marigina, n bata i maxandi, n mi nɔɛ na ligɛ. ");
INSERT INTO yal_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","N na a kolon, i bata hinan n tan i ya walikɛɛn na. I bata kininkinin n ma han! I bata n niin natanga. Koni, n tan mi nɔɛ n giyɛ han geyaan ma, xa na mi a ra n faxama nɛn. ");
INSERT INTO yal_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Yandi, i bata taa xurudini ito to? Na nan masoxi n na. Tin, n xa siga, n xa sa lu na. A lu, n xa siga mɛnni, taa xurudidin na a ra! N niin xa ratanga!” ");
INSERT INTO yal_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malekan yi a fala, a naxa, “N bata tin na birin ma. N mi na taan kalɛ. ");
INSERT INTO yal_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Siga mafurɛn, bayo han i sa soma waxatin naxan yi, n mi nɔɛ fefe ligɛ.” Na nan a toxi, na taan xili saxi Soyari. ");
INSERT INTO yal_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Sogen yi tema waxatin naxan yi, Loti yi so Soyari taan kui. ");
INSERT INTO yal_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Na waxatini, Alatala yi dole tɛɛn nagodo Sodoma taan nun Gomora taan ma. ");
INSERT INTO yal_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","A yi na taane halagi e nun na lanbanna birin, fɔlɔ sansine ma, sa dɔxɔ muxune ra naxanye birin dɔxi na taane kui. ");
INSERT INTO yal_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Loti a ɲaxanla yi a yɛɛn naxɛtɛ a xanbi ra, a yi findi fɔxɔ gɛmɛ tixin na. ");
INSERT INTO yal_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Na subaxan ma, Iburahima yi keli, a a xunsa na yiren ma e nun Alatala e bode to dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","A to a yɛɛn nasiga Sodoma taan nun Gomora taan ma, e nun na taane rabilinna birin, a yi tuti gbeen to, a tema na yi alo sulun tɛɛn tutina. ");
INSERT INTO yal_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ala to yi na taane kalama nun, a yi mirixi Iburahimaa fe ma. Na nan a toxi, Ala yi Loti ratanga na gbalon ma, a yi na taane kalama waxatin naxan yi, Loti yi dɔxi dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti bata yi gaxu lu feen na Soyari taan kui. A yi keli na, a siga geyaan fari a sa dɔxɔ mɛnni e nun a dii tɛmɛ firinna faran yinla kui. ");
INSERT INTO yal_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lɔxɔna nde, a dii tɛmɛ singen yi a fala a xunyɛn xa, a naxa, “En baba bata fori. En dɛnaxan yi, xɛmɛ yo mi be en dɔxɔma naxan xɔn ma alo adaman darixi kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Fa be, en xa dɔlɔn so en baba yii han a xunna yi keli alogo en xa xi a xɔn ma, alogo en xa diin sɔtɔ. Na xa findi a bɔnsɔnna ra.” ");
INSERT INTO yal_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Na kɔɛɛn na, e yi dɔlɔn fi e baba ma, a dii tɛmɛ singen yi xi a baba xɔn ma. A mi a xun ma fe yo kolon, a diin sa waxatina hanma a keli waxatina. ");
INSERT INTO yal_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kuye to yiba, a dii tɛmɛ singen yi a fala a xunyɛn xa, a naxa, “A bata ɲan, n tan nun n baba bata xi yire kedenni to. To kɔɛɛn na, i tan nan nun n baba xima yire kedenni. Na yanyini en nɔɛ bɔnsɔnna fiyɛ a ma.” ");
INSERT INTO yal_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Na kɔɛɛn mɔn na, e yi dɔlɔn fi e baba ma, a xunyɛn fan yi xi a baba xɔn ma. A mi a xun ma fe yo kolon, a diin sa waxatina, e nun a keli waxatina. ");
INSERT INTO yal_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Loti a dii tɛmɛ firinna yi fudikan e baba a diin na. ");
INSERT INTO yal_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Na dii tɛmɛ singen to diin bari, a a xili sa “Moyaba.” Na nan findi Moyaba kaane birin benban na. Han iki e na yi. ");
INSERT INTO yal_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","A dii tɛmɛ firinden fan yi diin bari, a a xili sa “Bɛn-Ami.” Na nan findi Amonine birin benban na. Han iki e na yi. ");
INSERT INTO yal_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Iburahima yi siga Negewi yamanani. A yi dɔxɔ Kadesi nun Suru tagi. Na xanbi ra, a yi siga Gerari taani, a yi waxati ti mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Iburahima yi a ɲaxanla Saran ma fe fala, a naxa, “N xunyɛn ɲaxalanmaan nan a ra.” Abimeleki, Gerari mangan yi Saran tongo. ");
INSERT INTO yal_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kɔɛɛn to so, Abimeleki xima, Ala yi a yɛtɛ yita a ra xiyeni, a naxa, “I faxama nɛn ɲaxanli ito a fe ra, i naxan tongoxi, bayo xɛmɛ taa ra dɔxɔn na a ra.” ");
INSERT INTO yal_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Na waxatini, Abimeleki munma yi a maso a ra. A yi a yabi, a naxa, “N Marigina, i bɔnsɔn tinxinxin kalama nɛn? ");
INSERT INTO yal_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Iburahima a fala nɛn n xa, fa fala ɲaxanli ito a xunyɛn ɲaxalanmaan nan a ra. Ɲaxanla fan yi a fala n xa, a tada nan Iburahima ra. N naxan ligaxi, n na ligaxi n bɔɲɛ fixɛn nan na.” ");
INSERT INTO yal_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Na xiyeni Ala mɔn yi a fala a xa, a naxa, “N tan yati, n na a kolon i feen naxan ligaxi, fe kobi xa mi a ra. N tan nan a ligaxi, i mi nɔxi yulubi ligɛ n na. Na nan a toxi n mi a luxi i xa a findi i ya ɲaxanla ra. ");
INSERT INTO yal_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Iki, ɲaxanli ito raxɛtɛ a xɛmɛn ma. Nabiin nan a ra. A Ala maxandima i xa nɛn alogo i niin xa ratanga. Koni xa i mi a raxɛtɛ a xɛmɛn ma, a kolon, i faxama nɛn i tan nun i ya muxune birin.” ");
INSERT INTO yal_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleki yi keli sinma, a yi a kuntigine birin malan. Feen naxan birin danguxi, a yi a yɛba e xa. E yi gaxu han a dangu ayi. ");
INSERT INTO yal_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimeleki yi Iburahima xili a konni. A yi a maxɔdin, a naxa, “N hakɛn mundun ligaxi i ra, i xa n tan nun n ma yamaan findi yulubi kanne ra? I bata fe liga n na, feen naxan mi lan a xa liga. ");
INSERT INTO yal_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nanfe a ligaxi i xa na raba?” ");
INSERT INTO yal_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Iburahima yi a fala, a naxa, “N na falaxi nɛn, a be kaane mi gaxuxi Ala yɛɛ ra. E n faxama nɛn n ma ɲaxanla fe ra. ");
INSERT INTO yal_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ɲɔndin nan a ra, n xunyɛn na a ra. Nxu birin baba keden, koni nxu nga keden mi a ra. A mɔn findixi n ma ɲaxanla ra. ");
INSERT INTO yal_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ala to n namini n baba konni, n yi a fala n ma ɲaxanla xa, n naxa, ‘I hinanna yitama n na ikiini: En na siga dɛdɛ, i xa a fala a n xunyɛn nan i tan na.’ ” ");
INSERT INTO yal_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimeleki yi yɛxɛɛne nun siine nun ɲingene nun konyi xɛmɛne nun konyi gilɛne tongo, a yi e birin so Iburahima yii. A mɔn yi a ɲaxanla Saran naxɛtɛ a ma. ");
INSERT INTO yal_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","A yi a fala Iburahima xa, a naxa, “N ma bɔxɔn dɛɛn bata rabi i xa. I na wa lu feni dɛdɛ bɔxɔni ito ma, lu mɛnni.” ");
INSERT INTO yal_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A yi a fala Saran xa, a naxa, “N bata gbeti gbanan wuli keden so i tada yii i solona seen na i tan nun i sigati boden birin yɛɛ xɔri alogo i xa xunna kenla sɔtɔ.” ");
INSERT INTO yal_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Iburahima yi Ala maxandi, na waxatini Ala yi Abimeleki rakɛndɛya alogo a ɲaxanla nun a konyi gilɛne xa nɔ diin barideni. ");
INSERT INTO yal_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Alatala bata yi dii baritareyaan nagidi nun Abimeleki a muxune ma Iburahima a ɲaxanla Saran ma fe ra. ");
INSERT INTO yal_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Alatala yi hinan Saran na, a a falan nakamali. ");
INSERT INTO yal_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saran yi fudikan. A yi diin bari Iburahima xa a foriyani Ala waxatin naxan fala a xa. ");
INSERT INTO yal_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Iburahima yi a diin xili sa Isiyaga, Saran naxan sɔtɔxi a xa. ");
INSERT INTO yal_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","A yi a dii Isiyaga banxulan a xii solomasɛxɛde lɔxɔni alo Ala a yamari kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Iburahima bata yi ɲɛɛ kɛmɛ sɔtɔ siimayaan na, Isiyaga bari waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saran yi a fala, a naxa, “Ala bata n nagele sɛwani. Muxun naxanye na n ma dii Isiyaga bari feen mɛ, en birin sɛwama nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","A mɔn yi a fala, a naxa, “Nde yi nɔɛ a falɛ Iburahima xa a lɔxɔna nde fama a lideni, Saran findima nɛn dii ngan na? Koni n tan bata diin bari a xa a xɛmɛ foriyani.” ");
INSERT INTO yal_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Diin to gbo, e yi a dɛɛn ba xiɲɛn na. Iburahima yi sɛwa sumunna belebele yitɔn, a dii Isiyaga dɛɛ ba lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Misiran kaan Hagara diin naxan barixi Iburahima xa, Saran yi na diin to gelɛ. ");
INSERT INTO yal_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","A yi a fala Iburahima xa, a naxa, “Konyi ɲaxanli ito nun a diin kedi. E nun n ma dii Isiyaga nama lu kɛɛ kedenni.” ");
INSERT INTO yal_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Na falan mi rafan Iburahima ma a diina fe ra. ");
INSERT INTO yal_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Koni Ala yi a fala Iburahima xa, a naxa, “I nama xɔlɔ i ya diina fe ra e nun i ya konyi ɲaxanla. Saran na feen naxan birin maxɔdin i ma, a birin liga a xa, bayo naxanye yatɛma i bɔnsɔnna ra, ne minima Isiyaga bɔnsɔnna nin. ");
INSERT INTO yal_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","N siyana nde fan naminima nɛn i ya konyi ɲaxanla diini, bayo i ya diin nan a fan na.” ");
INSERT INTO yal_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Iburahima yi keli subaxan ma. A yi burun nun kidi sagbaan tongo igen yi naxan kui. A yi na birin nate Hagara xun ma, a yi diin so a yii, a yi e birin kedi. Hagara yi a xun ti tonbon yiren na dɛnaxan xili “Bɛriseba.” ");
INSERT INTO yal_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Igen to ɲan a kidi sagbaan kui, a yi a diin sa wudidin bun ma. ");
INSERT INTO yal_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","A yi siga, a sa dɔxɔ a danna xalimakuli wolide keden ɲɔxɔndɔn yi. A yi a fala, a naxa, “N mi nɔɛ n yɛɛn tiyɛ n ma diin faxamatɔɔn na.” A yi siga, a sa dɔxɔ a danna, a yi lu tɛ a ma, a wuga. ");
INSERT INTO yal_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ala yi diin wuga xuiin mɛ kore. Alaa malekan yi Hagara xili, a yi a maxɔdin, a naxa, “Hagara nanse i sɔtɔxi? I nama gaxu bayo Ala bata diin wuga xuiin mɛ kore. ");
INSERT INTO yal_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Keli i ti! I ya diin tongo i yii firinna ra, i xa a suxu, bayo n na a findima siya gbee kanna nan na.” ");
INSERT INTO yal_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ala yi Hagara yɛɛn nabi, a yi xɔɲinna to, igena a kui. A yi na kidi sagbaan tongo, a sa igen sa a kui. A yi igen fi a diin ma. ");
INSERT INTO yal_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ala yi a yengi lu diin xɔn ma han a yi gbo. A yi siga a sa dɔxɔ tonbonni. A yi findi xalimakuli wonla ra. ");
INSERT INTO yal_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","A yi dɔxɔ Paran tonbonni. A nga yi Misiran kaa ɲaxalan keden fen a xa. ");
INSERT INTO yal_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Na waxatini, Abimeleki nun a sofa mangana Pikoli, ne yi fa Iburahima li, e a fala a xa, e naxa, “Ala luxi i xɔn ma i ya feen birin yi. ");
INSERT INTO yal_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","I kɔlɔ n xa Ala xinli, fa fala i mi n yanfɛ, i mi n ma diine yanfɛ, i mi n mamandenne fan yanfɛ. I xa hinan n na e nun bɔxɔni ito muxune, i dɛnaxan yi, alo n na a liga i xa kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Iburahima yi a yabi, a naxa, “N bata n kɔlɔ Ala yi.” ");
INSERT INTO yal_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Iburahima yi a mawuga Abimeleki xa, a walikɛne bata a xɔɲinna ba a yii. ");
INSERT INTO yal_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki yi a yabi, a naxa, “N ma kolon naxan na feen ligaxi i ra. I mi dɛntɛgɛni ito saxi n xa, fɔ to n tan yi fa a kolon.” ");
INSERT INTO yal_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Iburahima yi yɛxɛɛne nun siine nun ɲingene tongo, a yi e so Abimeleki yii. E yi layirin tongo e bode xa. ");
INSERT INTO yal_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Iburahima yi yɛxɛɛ dii solofere tongo, a yi e sa e danna. ");
INSERT INTO yal_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki yi a maxɔdin, a naxa, “Nanfera, i na yɛxɛɛ dii soloferene saxi e danna?” ");
INSERT INTO yal_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iburahima yi a yabi, a naxa, “N ne soma nɛn i yii, alogo i xa a kolon, a n tan nan xɔɲinni ito gexi.” ");
INSERT INTO yal_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Nanara, mɛnna xili saxi Bɛriseba, bayo e firinna birin e kɔlɔ mɛnna nin. ");
INSERT INTO yal_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","E yi layirin tongo e bode xa Bɛriseba. Na dangu xanbini, Abimeleki nun a sofa mangana Pikoli, e yi ti kiraan xɔn ma xɛtɛ Filisiti bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Iburahima yi tamaro wudi bili keden si Bɛriseba bɔxɔn ma. A yi Alatala maxandi a xinla ra, Habadan Ala. ");
INSERT INTO yal_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Iburahima ɲɛɛ wuyaxi ti nɛn Filisiti bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Na feene dangu xanbini, Ala yi Iburahima kɛɲaan fɛsɛfɛsɛ. A yi a xili, a naxa, “Iburahima.” Iburahima yi a ratin, a naxa, “N tan ni i ra.” ");
INSERT INTO yal_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ala yi a fala a xa, a naxa, “I ya diin tongo, Isiyaga, i ya dii keden peena, naxan nafan i ma, i xa a xali Moriya yamanani geyaan fari, n na dɛnaxan yita i ra. I xa a ba n xa saraxa gan daxin na.” ");
INSERT INTO yal_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Subaxan ma, Iburahima yi keli, a yi dɔxɔ seni tɔn a sofanla fari. A yi a walikɛ firin tongo e nun Isiyaga, a diina. Iburahima yi yegeni bɔ naxan findima tɛɛ yitɔn seen na saraxa badeni. A yi siga yireni Ala dɛnaxan yitaxi a ra. ");
INSERT INTO yal_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Na xii saxande lɔxɔni, Iburahima yɛɛn yi ti na yire makuyen na, a sigama dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","A yi a fala a walikɛ firinna xa, a naxa, “Ɛ tan nun sofanla xa lu be. Nxu nun n ma diin sigama geyaan fari Ala batudeni. Na waxatini nxu mɔn xɛtɛma han be.” ");
INSERT INTO yal_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Iburahima yi na yegen dɔxɔ Isiyaga xun ma, a diina. A mɔn yi tɛɛ wolonna nun filɛn xali. E sigan tima e firinna. ");
INSERT INTO yal_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isiyaga yi a baba Iburahima xili, a naxa, “N baba.” A yi a ratin, a naxa, “N tan ni i ra, n ma diina.” Isiyaga yi a baba maxɔdin, a naxa, “N bata a to yegen nun tɛɛ wolonna en yii, koni yɛxɛɛ diin minɛn yi en naxan bama saraxan na?” ");
INSERT INTO yal_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Iburahima yi a yabi, a naxa, “N ma diina, Ala yatin nan yɛxɛɛ diin fima en ma, en naxan bama saraxa gan daxin na.” E sigan tima e firinna. ");
INSERT INTO yal_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","E to e soden li, Ala dɛnaxan yitaxi a ra, Iburahima yi saraxa ganden nafala mɛnni, a yi yegen sa na. A yi a diin xidi, Isiyaga. A yi a rate na saraxa ganden fari, a yi a dɔxɔ yegen fari. ");
INSERT INTO yal_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Na xanbi ra, a yi filɛn tongo, a yi a yiini bandun, a xa a diin kɔɛ raxaba, ");
INSERT INTO yal_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","koni Alatalaa malekan yi a xili kore, a naxa, “Iburahima hɛ, Iburahima hɛ!” Iburahima yi a ratin, a naxa, “N tan ni i ra.” ");
INSERT INTO yal_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malekan yi a fala, a naxa, “Banxulanni ito lu na. I nama fe ɲaxi yo liga a ra. N bata a kolon i gaxuxi Ala yɛɛ ra. N mɔn bata la a ra, i mi tondixi i ya dii kedenna fideni n ma saraxan na.” ");
INSERT INTO yal_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Iburahima yi a yɛɛn naxɛtɛ a xanbi ra, a yi yɛxɛɛ kontonna to fɔtɔnna yii ra, a feri firinna kankanxi ɲansanni. A yi sa na yɛxɛɛ kontonna tongo, a fa a ra. A yi na ba saraxan na a diin ɲɔxɔn na. ");
INSERT INTO yal_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Iburahima yi na yiren xili sa “Alatala nan fama a ra.” Nanara, han iki a falama “Alatala nan fama a ra a geyaan fari.” ");
INSERT INTO yal_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Alatalaa malekan mɔn yi Iburahima xili kore. ");
INSERT INTO yal_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","A yi a fala a xa, a naxa, “N bata n kɔlɔ n yɛtɛni, Alatalaa falan ni ito ra. Bayo i bata ito liga, i mi tondi i ya dii kedenna ma n xa, ");
INSERT INTO yal_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","n na i barakama nɛn han! I bɔnsɔnna wuyama ayi nɛn alo saren naxanye koren ma, xa na mi a ra e wuyama ayi nɛn alo mɛɲɛnsinna naxan malanxi baa dɛɛn na. I bɔnsɔnna e yaxune nɔma nɛn. ");
INSERT INTO yal_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Dunuɲa siyane birin duban sɔtɔma nɛn i tan bɔnsɔnna barakani, bayo i bata n xuiin suxu.” ");
INSERT INTO yal_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Iburahima yi xɛtɛ a walikɛne yireni. E birin yi siga Bɛriseba, bayo Iburahima yi dɔxi mɛnna nin. ");
INSERT INTO yal_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Na feene birin to dangu, Iburahima yi a mɛ, a Milika bata diini itoe bari a xunyɛn Nahori xa: ");
INSERT INTO yal_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","A dii singena Yusu nun na xanbiratɔna Busi nun Arami baba Kɛmuyɛli ");
INSERT INTO yal_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","nun Kesede nun Xaso nun Pilidasi nun Yidilafi e nun Betuyeli. ");
INSERT INTO yal_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuyeli Rebeka nan sɔtɔ. Milika nan na dii solomasɛxɛn bari Iburahima xunyɛ Nahori xa. ");
INSERT INTO yal_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahori a konyi ɲaxanla, na yi xili nɛn Reyuma. A yi diine bari. Na diine yi xili nɛn: Teba nun Gaxami nun Tahaka e nun Maka. ");
INSERT INTO yal_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saran ɲɛɛ kɛmɛ ɲɛɛ mɔxɔɲɛn nun solofere nan sɔtɔ siimayaan na. ");
INSERT INTO yal_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","A yi faxa Kiriyati-Aruba yi, naxan mɔn xili “Xebiron,” Kanan bɔxɔni. Iburahima yi a ɲaxanla saya feen liga, a yi a wuga. ");
INSERT INTO yal_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Iburahima yi keli, a ɲaxalan binbin saxi dɛnaxan yi, a yi siga Xitine fɛma. A yi sa falani ito ti e xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Xɔɲɛn nan n tan na ɛ tagi be. N bata ɛ maxandi, ɛ gaburu yiren fi n ma, n nɔɛ n ma ɲaxanla maluxunɲɛ dɛnaxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Xitine yi a yabi, ");
INSERT INTO yal_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","e naxa, “Nxu kanna, i tuli mati nxu ra a faɲin na! Alaa muxu gbeen nan i ra nxu tagi. I na wa i ya ɲaxanla maluxun feni nxɔ gaburu yire yo yi, i sagoon na a ra. Nxu tan tagi be, muxu yo mi na naxan nɔɛ tondɛ i xa, i ya ɲaxanla maluxundeni a gaburu yireni.” ");
INSERT INTO yal_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Iburahima yi keli. A yi a xinbi sin mɛn kaane xa, Xiti bɔnsɔnna. ");
INSERT INTO yal_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","A yi a fala e xa, a naxa, “Xa ɛ bata tin, n xa nɔ n ma ɲaxanla maluxundeni ɛ gaburu yireni, n fan bata ɛ maxandi ɛ xa nɔ n ma maxandin nadangudeni, Soxara a dii Eferon ma ");
INSERT INTO yal_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","alogo a xa Makipela faranna so n yii. Bayo, n na a kolon a tan nan gbee mɛnna ra, na mɔn a xɛɛn nan dɛxɔn. A xa na sara n ma ɛ yɛɛ xɔri, alogo birin xa a kolon, na bɔxɔn bata findi n ma muxu maluxunden na.” ");
INSERT INTO yal_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eferon Xiti kaan yi tixi a yamaan tagi. A yi Iburahima yabi a xuini texin na alogo Xitine nun muxun naxanye birin yi malanxi taan so dɛɛn na, e xa nɔ a falan namɛdeni. ");
INSERT INTO yal_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Nba, n bata i maxandi, n kanna, i tuli mati n na. Ɛn-ɛn, n bata xɛɛn nun faranni ito fi i ma n bɔnsɔnna yɛɛ xɔri. I ya ɲaxanla maluxun mɛnni.” ");
INSERT INTO yal_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Iburahima mɔn yi a xinbi sin, yamaan birin yɛɛ xɔri. ");
INSERT INTO yal_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","A yi falan ti Eferon xa, a naxa, “I fan xa i tuli mati n na. N ni i ya xɛɛn saren fima nɛn. A rasuxu, yandi, n gbetin naxan soma i yii alogo n xa nɔ n ma ɲaxanla maluxundeni mɛnni.” ");
INSERT INTO yal_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eferon mɔn yi falan tongo, ");
INSERT INTO yal_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","a naxa, “Nba, i tuli mati n na a faɲin na. Bɔxɔn naxan saren lanma gbeti gbanan kɛmɛ naanin ma, sese mi na ra, i tan nun n tan tagi. I ya ɲaxanla maluxun na.” ");
INSERT INTO yal_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Iburahima yi tin Eferon ma falan ma. A yi gbetin tɛngɛ, a naxan ma fe fala a bodene yɛɛ xɔri, Xitine, na gbeti gbanan kɛmɛ naanin yi maliga alo yulane yi darixi a ligɛ kii naxan yi na waxatini. ");
INSERT INTO yal_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Eferon ma xɛɛn naxan yi Makipela yi, Mamire sogetede binna e nun faranna naxan na, e nun wudi binla naxanye birin sixi xɛɛn danne ra, ");
INSERT INTO yal_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ne birin yi findi Iburahima gbeen na. Na Xitine nun muxun naxanye birin yi malanxi taan so dɛɛn na, e birin yi findi na fe serene ra. ");
INSERT INTO yal_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Na birin dangu xanbini, Iburahima yi a ɲaxanla Saran maluxun na faranna ra Makipela xɛɛn ma, naxan Mamire yɛtagi, Xebiron yi, Kanan bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Na xɛɛn nun na faranna yi ba Xitine gbeeyani, a findi Iburahima gbeen na alogo a xa nɔ a muxu faxaxine maluxundeni mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Iburahima bata yi fori. Alatala yi Iburahima baraka kirayaan sifan birin xɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","A walikɛɛn naxan fori dangu a walikɛɛn birin na, naxan yengi luxi a yii seen birin xɔn ma, Iburahima yi a fala na xa, a naxa, “I yiin naso n danban bun ma. ");
INSERT INTO yal_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","N fama i rakɔlɔdeni Alatala yi, kore xɔnna nun bɔxɔ xɔnna Ala, alogo i nama ɲaxanla fen n ma diin xa naxan findɛ Kanan kaan na n dɔxi dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","I sigama n bari bɔxɔn nan ma, n bɔnsɔnni, i mɛnna ɲaxalan keden fen Isiyaga xa, n ma diina.” ");
INSERT INTO yal_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A walikɛɛn yi a yabi, a naxa, “Yanyina nde, na ɲaxanla mi birɛ n fɔxɔ ra fa bɔxɔni ito yi. Fɔ n xa i ya diin xali mɛnni, i ya bɔxɔni, i kelixi dɛnaxan yi ba?” ");
INSERT INTO yal_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Iburahima yi a yabi, a naxa, “I nama n ma diin naxɛtɛ n kelideni de! ");
INSERT INTO yal_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Alatala, Ala Naxan Kore, naxan n tongoxi n bari muxune tagi e nun n bɔnsɔnni, naxan falan tixi n xa, naxan a kɔlɔxi a bɔxɔni ito soma nɛn n bɔnsɔnna yii, a tan yatina a malekan nasigama i yɛ ra nɛn alogo i xa nɔ ɲaxanla sɔtɔdeni n ma diin xa mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Xa ɲaxanla mi fa sa tin birɛ i fɔxɔ ra, i fama nɛn natangadeni n ma kɔlɔn ma, i naxan tongoxi n xa. Koni i nama xɛtɛ n ma diin na mɛnni.” ");
INSERT INTO yal_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Walikɛɛn yi a yiin naso a kanna Iburahima danban bun ma, a yi a kɔlɔ na ma. ");
INSERT INTO yal_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Walikɛɛn yi ɲɔgɔmɛ fu tongo Iburahima a ɲɔgɔmɛne tagi e nun se faɲi gbegbe. A yi keli, a yi siga Nahori a taani, Mesopotamiya yamanan kɔmɛn fɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ɲinbari waxatini, a yi xɔɲinna li naxan gexi taan fari ma. A yi ɲɔgɔmɛne rafelen mɛnni. Ɲaxanle yi fama ige badeni na xɔɲinna nan na. ");
INSERT INTO yal_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","A yi Ala maxandi, a naxa, “Alatala, n kanna Iburahimaa Ala, n bata i maxandi alogo n ma sigatiin xa findi xunna kenla ra n xa to. I xa hinan n kanna Iburahima ra. ");
INSERT INTO yal_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","I bata n to xɔɲinna dɛxɔn ma, taan sungutunne fama ige badeni dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","N sungutunna nde maxɔdinma nɛn, a xa a ige ba seen so n yii, n yi igen min. Xa a li, a n yabi iki, a naxa, ‘I xa igen min, n mɔn xa igen so i ya ɲɔgɔmɛne fan yii,’ n na a kolonma nɛn na waxatini, i ya ɲaxalan sugandixin yatin nan na ra Isiyaga xa, i ya walikɛna. Na waxatini n na a kolonma nɛn, a i bata hinan n kanna ra.” ");
INSERT INTO yal_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Benun a xa yelin na falan tiyɛ, Rebeka yi fa, Betuyeli a dii tɛmɛna, Nahori nun Milika mamandenna. Nahori, Iburahima xunyɛn nan a ra. A fɛɲɛn yi dɔxi a tungunna fari. ");
INSERT INTO yal_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Sungutun tofaɲin nan yi a ra, naxan mi yi xɛmɛ feen kolon. A yi godo xɔɲin dɛɛn na, a yi a fɛɲɛn nafe igen na, a mɔn yi te. ");
INSERT INTO yal_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Iburahimaa walikɛɛn yi a gi, a sa a ralan. A yi a fala a xa, a naxa, “Yandi, a lu n xa igena nde min, naxan i ya fɛɲɛn kui.” ");
INSERT INTO yal_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","A yi a yabi, a naxa, “Nba, igen min.” A yi a fɛɲɛn nagodo a tungunna fari, a yi igen so a yii. ");
INSERT INTO yal_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","A to yelin igen soɛ a yii, a yi a fala a xa, a naxa, “N ni igen bama nɛn i ya ɲɔgɔmɛne fan xa alogo e birin xa wasa igen na.” ");
INSERT INTO yal_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","A yi igen sa xuruse mindeni, a mɔn yi siga a giyɛ a sa ige gbɛtɛ sɛgɛ. Ɲɔgɔmɛne birin yi wasa igen na. ");
INSERT INTO yal_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Xɛmɛni ito yi a dundu, a yi a miri, yanyina nde, Alatala bata n ma sigatiin nasɔnɔya n xa. ");
INSERT INTO yal_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ɲɔgɔmɛne to yelin igen minɲɛ, xɛmɛni ito yi xɛma wuredin so sungutunna yii naxan sama ɲɔɛɛn na, na garamu sennin liyɛ, e nun xɛma yiikɔɛraso firin, naxan garamu kɛmɛ liyɛ. ");
INSERT INTO yal_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A yi a maxɔdin, a naxa, “Nde a dii i tan na? Yandi, a fala n xa, xa yigiyana nde i baba konni, nxu xa xi na to kɔɛɛn na?” ");
INSERT INTO yal_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","A yi a fala a xa, a naxa, “Betuyeli a diin nan n na, Milika nun Nahori mamandenna nan n na.” ");
INSERT INTO yal_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ɲaxanli ito mɔn yi a fala, a naxa, “Nxu konni sɛxɛn nun ɲɔxɔndedɛ gbegbeen na, yigiyaden fan na ɛ luma dɛnaxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Xɛmɛni ito yi a xinbi sin Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","A yi a fala, a naxa, “Alatala, n kanna Iburahimaa Ala, n bata i tantun. I hinanma n kanna Iburahima ra waxatin birin. I ya lannayaan mi kalɛ. N ma sigatini, Alatala, n xunna tixi yiren nan na, dɛnaxan findixi n kanna Iburahima xunyɛn konna ra.” ");
INSERT INTO yal_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Sungutunni ito yi a gi siga a konni, a sa xɔɲɛni ito a fe fala a nga xa. ");
INSERT INTO yal_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka tadana nde yi na naxan xili Laban. A yi mini mafurɛn, a yi siga xɔɲin dɛɛn na xɛmɛn tixi dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","A bata yi ɲɔɛrasoon nun yiikɔɛrasoon to a xunyɛn ɲaxalanmaan yii. A mɔn bata yi a xunyɛn dɛntɛgɛ xuiin mɛ xɛmɛna falana fe ra. A yi siga xɛmɛni ito yireni a tixi xɔɲinna fɛma e nun ɲɔgɔmɛne. ");
INSERT INTO yal_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","A yi a fala a xa, a naxa, “Fa be, Alatala barakan fixi naxan ma. Nanfera i tixi tandeni? N bata banxini tɔn i yigiyadena e nun ɲɔgɔmɛne lan e xa lu dɛnaxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Xɛmɛni ito yi so Laban konni. Laban yi goronna ragodo ɲɔgɔmɛne fari. A sɛxɛn so e yii e nun ɲɔxɔndedɛna e naxan donma. A yi igen fan so xɛmɛni ito yii, e nun muxun naxanye birin biraxi a fɔxɔ ra, alogo e xa e sanne maxa. ");
INSERT INTO yal_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","A yi fa donseen na e xa, koni a yi a fala, a naxa, “N mi n dɛgema singe, fɔ n xa falan ti ɛ xa, n lanma n xa naxan yita ɛ ra.” Laban yi a fala a xa, a naxa, “Falan ti xɛ.” ");
INSERT INTO yal_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Xɛmɛni ito yi a fala, a naxa, “N tan Iburahimaa walikɛɛn nan n na. ");
INSERT INTO yal_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Alatala bata baraka gbegbeen nagidi n kanna Iburahima ma. A bata findi nafulu kanna ra, bayo Ala bata xuruseen sifan birin fi a ma e nun gbetin nun xɛmaan nun walikɛ xɛmɛne nun walikɛ ɲaxanle nun ɲɔgɔmɛne nun sofanle. Ala bata na birin fi a ma. ");
INSERT INTO yal_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","N kanna Iburahima a ɲaxanla Saran, hali a to yi forixi, a yi diin bari a ma. A kɛɛn birin soxi diini ito nan yii.” ");
INSERT INTO yal_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","“Iburahima n nakɔlɔxi nɛn, a naxa, ‘I nama ɲaxanla tongo n ma diin xa naxan findɛ Kanan kaan na n dɔxi dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","I xa siga n baba denbayani n bɔnsɔnni alogo i xa ɲaxanla fen n ma diin xa mɛnni.’ ");
INSERT INTO yal_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Na waxatini, n yi n kanna maxɔdin, n naxa, ‘Xa na ɲaxanla fa tondi biradeni n fɔxɔ ra go?’ ");
INSERT INTO yal_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A yi n yabi, a naxa, ‘N sigan tima Alatala naxan yɛtagi, na fama nɛn a malekan biradeni i fɔxɔ ra alogo i ya sigatiin xa sɔnɔya. I fama nɛn ɲaxanla tongodeni n ma diin xa n bɔnsɔnni, n baba denbayani. ");
INSERT INTO yal_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Na waxatini i na siga n bɔnsɔnna tagi, xa e mi fa sa sungutunna so i yii, i bata ratanga n ma marakɔlɔn ma.’ ” ");
INSERT INTO yal_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“N to xɔɲinna yiren li, n yi maxandin ti, n naxa, ‘Alatala, n kanna Iburahimaa Ala, xa i bata a ɲɛnige n xa, i xa n ma sigatiin nasɔnɔya, ");
INSERT INTO yal_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","i yɛɛn ti n na xɔɲinna dɛxɔn ma. N fama nɛn sungutunna nde maxɔdindeni naxan fama ige badeni, a a xa igen so n yii naxan a fɛɲɛn kui alogo n xa n min. ");
INSERT INTO yal_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Xa a n yabi, a naxa, “Igen min, n na igen bama nɛn i ya ɲɔgɔmɛne fan xa, e min,” n na a kolonma nɛn na waxatini, Alatalaa sungutun sugandixin yatin nan na ra n kanna Iburahima a diin xa.’ ” ");
INSERT INTO yal_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Benun n xa yelin na falan tiyɛ n yɛtɛ ma, Rebeka yi fa, fɛɲɛn dɔxi a tungunna fari. A yi godo xɔɲin dɛɛn na, a yi igen ba. N yi a maxɔdin, n naxa, ‘Yandi igen so n yii, n xa n min.’ ");
INSERT INTO yal_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","A yi a fɛɲɛn nagodo mafurɛn a tungunna fari, a yi a fala n xa, a naxa, ‘Igen min, i na yelin igen minɲɛ, n na igen soma nɛn i ya ɲɔgɔmɛne fan yii.’ N yi n min, a mɔn yi igen so ɲɔgɔmɛne yii. ");
INSERT INTO yal_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","N yi a maxɔdin, n naxa, ‘Nde a dii i tan na?’ A yi n yabi, a naxa, ‘Betuyeli a diin nan n na, Nahori nun Milika mamandenna nan n na.’ N yi xɛma wuredin so a ɲɔɛɛn na, n mɔn yi xɛma yiirasone so a yii kɔɛɛn na. ");
INSERT INTO yal_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","N yi n xinbi sin Alatala yɛtagi. N yi Alatala tantun, n kanna Iburahimaa Ala, bayo a bata n ti kira faɲin xɔn ma alogo n xa n kanna xunyɛna dii ɲaxalanmaan tongo a diin xa. ");
INSERT INTO yal_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Iki, a fala n xa, xa i hinanma n kanna ra lannayani. Xa na mi a ra, n sigama nɛn yire gbɛtɛ yi.” ");
INSERT INTO yal_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban nun Betuyeli yi a yabi, a naxa, “Alatala nan feni itoe ragidixi. Nxu mi na matandɛ. ");
INSERT INTO yal_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka nan tixi i yɛtagi ito ra. A xali i yii, alogo a xa findi i kanna diina ɲaxanla ra, alo Alatala a fala kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Iburahimaa walikɛɛn to na fala xuine mɛ, a yi a xinbi sin Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Na xanbi ra, a yi muran gbeti daxin nun xɛma daxin nun dugine ramini a goronne yɛ, a e so Rebeka yii. A yi Rebeka nga nun a tada fan ki. ");
INSERT INTO yal_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Iburahima a walikɛɛn nun a fɔxɔrabirane, e birin yi e dɛge, e igen min, e yi so e sadeni. E to keli xɔtɔnni, Iburahimaa walikɛɛn yi a fala Rebeka nga nun a tada xa, a naxa, “Ɛ a lu fa n xa xɛtɛ n kanna konni.” ");
INSERT INTO yal_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","E yi a fala, e naxa, “Sungutunni ito xa lu be singen, a xa xii fu ɲɔxɔn liga be waxatini ito yi, na xanbi ra, i siga.” ");
INSERT INTO yal_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Walikɛɛn mɔn yi e yabi, a naxa, “Ɛ nama n makankan be. Alatala bata n ma sigatiin findi n ma xunna kenla ra. Ɛ a lu fa n xa xɛtɛ n kanna konni.” ");
INSERT INTO yal_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","E yi a fala, e naxa, “En sungutunni ito xili ba, en na a maxɔdin, en xa a ɲɛnigen kolon.” ");
INSERT INTO yal_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","E yi Rebeka xili, e yi a maxɔdin, e naxa, “I waxi siga feni ba, ɛ nun xɛmɛni ito?” Rebeka yi a yabi, a naxa, “Ɔn, n waxi siga feni.” ");
INSERT INTO yal_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","E yi e xunyɛn Rebeka so e yii e nun ɲaxanla naxan yi a maxuruma. E nun Iburahima walikɛɛn nun a muxune yi siga. ");
INSERT INTO yal_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","E yi duba Rebeka xa, e naxa, “I tan nxu xunyɛna. Ala xa i yixɛtɛne rawuya ayi han wuli wuli wuyaxi, e nɔɔn sɔtɔ e yaxune xun na.” ");
INSERT INTO yal_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka nun a walikɛ ɲaxanle yi dɔxɔ ɲɔgɔmɛne fari, e yi bira Iburahima a walikɛɛn fɔxɔ ra, e birin yi siga. ");
INSERT INTO yal_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isiyaga bata yi keli Lahayi Royi xɔɲinna yireni. A yi siga Negewi bɔxɔni, a sa dɔxɔ na. ");
INSERT INTO yal_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ɲinbanna nde ra, a minixi a masigadeni, a yi ɲɔgɔmɛne to fɛ. ");
INSERT INTO yal_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka to Isiyaga to, a yi tugan ɲɔgɔmɛne fari, a godo bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","A yi walikɛɛn maxɔdin, a naxa, “Muxun mundun ito ra naxan fama en nalandeni xɛɛn ma?” ");
INSERT INTO yal_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Iburahima a walikɛɛn yi a yabi, a naxa, “N kanna nan na ra.” Nayi, a yi dugin so a yɛtagin xun na. Walikɛni ito yi a fala Isiyaga xa, a feen naxanye birin ligaxi. ");
INSERT INTO yal_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Na xanbi ra, Isiyaga yi Rebeka tongo, a yi a xali bubuna nde kui, a nga Saran yi dɔxi dɛnaxan yi nun. Rebeka yi findi a ɲaxanla ra. A yi a xanu. Isiyaga nga faxa sunun yi ba a ma Rebekaa fe ra. ");
INSERT INTO yal_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Iburahima mɔn yi ɲaxalan gbɛtɛn tongo naxan xili Ketura. ");
INSERT INTO yal_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Na ɲaxanla yi diine bari a xa. Na diine yi xili: Simiran nun Yokan nun Medan nun Midiyan nun Yisebaki e nun Suwa. ");
INSERT INTO yal_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokan yi Saba nun Dedan bari. Dedan yixɛtɛne findixi Asuri kaane nan na, e nun Letusin kaane nun Leyumin kaane. ");
INSERT INTO yal_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyan ma diine nan Efa nun Efere nun Xanɔki nun Abida nun Elida ra. Keturaa diine nan e birin na. ");
INSERT INTO yal_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Seen naxan birin findi Iburahima gbeen na, a yi a birin so Isiyaga yii. ");
INSERT INTO yal_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Naxanye findi a konyi ɲaxanle diine ra, a yi e ki a siimayani. A yi e rasiga yireni, dɛnaxan makuya a dii Isiyaga ra sogetede mabinni. ");
INSERT INTO yal_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Iburahima a siimayaan yi siga han ɲɛɛ kɛmɛ ɲɛɛ tonge solofere e nun suulun. ");
INSERT INTO yal_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","A to siimaya xunkuyen sɔtɔ, a fori ki faɲi, a yi faxa, a yi siga laxira yi. ");
INSERT INTO yal_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","A diine Isiyaga nun Sumayila yi a maluxun faranna ra, Makipela, dɛnaxan yi Eferon ma xɛɛn ma, Soxara a diina, Xiti kaana, Mamire fɛma. ");
INSERT INTO yal_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Iburahima na xɛɛn sara Xitine bɔnsɔnna nan ma. E nun a ɲaxanla Saran, e birin maluxunxi mɛnna nin. ");
INSERT INTO yal_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Iburahima to faxa, Ala yi a dii Isiyaga baraka naxan dɔxɔ Lahayi Royi xɔɲinna fɛma. ");
INSERT INTO yal_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Sumayila bɔnsɔnne xinle nan itoe ra. Saran bata yi a konyi ɲaxanla Misiran kaa Hagara fi Iburahima ma. Hagara yi Sumayila sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Sumayilaa diine xinle ni itoe ra: Nebayoti Sumayilaa dii singen nun Kedari nun Adibeli nun Mibisan nun ");
INSERT INTO yal_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misema nun Duma nun Masa nun ");
INSERT INTO yal_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Xadada nun Tema nun Yeturi nun Nafisi e nun Kedema. Na dii fu nun firinna findi Sumayilaa diine nan na. ");
INSERT INTO yal_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Na muxu keden kedenna, ne findi bɔxɔ mangane nan na. E yi e xinle sa e taane xun ma e nun e muxune. ");
INSERT INTO yal_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sumayilaa siimayaan yi dan ɲɛɛ kɛmɛ ɲɛɛ tonge saxan nun solofere nin. A yi faxa, a siga laxira yi. ");
INSERT INTO yal_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Sumayila bɔnsɔnna yi dɔxɔ na bɔxɔni dɛnaxan yi Xawila nun Suru tagi. Suru yɛɛn nafindixi Misiran nan ma Asuri kiraan na. E yi dɔxi e ngaxakedenne nan dɛxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Isiyaga bɔnsɔnne taruxun ni i ra. Isiyaga findi Iburahima a diin nan na. ");
INSERT INTO yal_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isiyaga to ɲɛɛ tonge naanin sɔtɔ siimayaan na, a yi Rebeka dɔxɔ, Laban xunyɛ ɲaxalanmana, Betuyeli a dii tɛmɛna. Arami kaane nan e ra, e kelixi Padan-Arami nɛn. ");
INSERT INTO yal_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Koni Rebeka mi nɔ diin barɛ a xa. Isiyaga yi Alatala maxandi a ɲaxanla fe ra a xa nɔ dii barideni. Alatala yi a maxandin nasuxu, Rebeka yi fudikan. ");
INSERT INTO yal_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Na diine yi lu yɛngɛ e nga kui. A yi a fala, a naxa, “Nanfera n kuina n tɔrɔma?” A yi Alatala maxɔdin. ");
INSERT INTO yal_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Alatala yi a yabi, a naxa, “Siya dɔxɔde firin nan i kuini. Kedenna sɛnbɛn gboma nɛn boden xa. Tadan luma nɛn a xunyɛna nɔɔn bun ma.” ");
INSERT INTO yal_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","A diin bari waxatin to a li, e yi a to a gulunne nan yi Rebeka kui. ");
INSERT INTO yal_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Diin naxan singe bari muxu gbeela nan yi a ra. Fati ma xabe gbegbe kanna nan yi a ra. E yi a xili sa Esayu. ");
INSERT INTO yal_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Na xanbi ra, a xunyɛn fan yi bari. A yiin naxutuxi a tada Esayu santinban ma. E yi a xili sa Yaxuba. Rebeka na diine barima waxatin naxan yi, Isiyaga ɲɛɛ tonge sennin nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Na dii xɛmɛ firinna yi gbo. Esayu yi findi donso faɲin na naxan yi wulani sigama. Yaxuba findi muxu maxunbelixin nan na, a tan yi luma bubun nan bun ma. ");
INSERT INTO yal_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esayu nan yi rafan Isiyaga ma, a sube faxaxine fe ra, koni Yaxuba nan yi rafan Rebeka ma. ");
INSERT INTO yal_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lɔxɔna nde Yaxuba yi pɔrin nafala. Esayu to so, a xadanxi keli donsoyani. ");
INSERT INTO yal_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","A yi a fala Yaxuba xa, a naxa, “N mi nɔɛ fefe ra iki. A lu n xa pɔri gbeeli ito nde kɔn.” Na nan a toxi a yi xili sa, Edɔn. ");
INSERT INTO yal_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaxuba yi a yabi, a naxa, “I ya foriyaan tiden fi n ma singen.” ");
INSERT INTO yal_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esayu yi a fala, a naxa, “N faxa feni kamɛn nan ma iki. Na foriya tiden nanse fanma n ma?” ");
INSERT INTO yal_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaxuba mɔn yi a fala, a naxa, “Fɔ i xa i kɔlɔ.” Esayu yi a kɔlɔ, a bata a foriya tiden fi a ma. ");
INSERT INTO yal_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yaxuba yi burun nun pɔrin toge daxi so a yii. Esayu yi ne don, a yi a min. A yi siga. Nanara, Esayu mi a foriya tiden yatɛ sese ra. ");
INSERT INTO yal_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kamɛn yi so bɔxɔni, ba a singen na naxan so Iburahima waxatini. Isiyaga yi siga Gerari yi, Filisiti manga Abimeleki konni. ");
INSERT INTO yal_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Alatala yi mini Isiyaga xa. A yi a fala a xa, a naxa, “I nama siga Misiran bɔxɔni de! Lu na bɔxɔni n na dɛnaxan yita i ra. ");
INSERT INTO yal_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","I lu na. En birin na a ra. N ni i barakama nɛn, bayo n fama bɔxɔni ito fideni i tan nun i bɔnsɔnne nan ma. N layirin naxan tongo i baba Iburahima xa, n na rakamalima nɛn. ");
INSERT INTO yal_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","N na i bɔnsɔnna rawuyama ayi nɛn alo saren naxanye kore. N bɔxɔni ito fima nɛn i bɔnsɔnna ma. Dunuɲa siyane birin duban sɔtɔma nɛn i tan bɔnsɔnna barakan nin, ");
INSERT INTO yal_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","bayo Iburahima n xuiin namɛ nɛn, a yi n gelene nun n ma yamarine nun n ma tɔnne nun n ma sariyane suxu.” ");
INSERT INTO yal_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isiyaga yi dɔxɔ Gerari yi. ");
INSERT INTO yal_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Muxun naxanye dɔxi mɛnni, ne yi a maxɔdin a ɲaxanla fe ma. A yi e yabi, a xunyɛn ɲaxalanmaan nan a ra. A mi yi susuɛ a falɛ e xa, a ɲaxanla nan Rebeka ra alogo mɛn kaane nama a faxa. A gaxu a falɛ a ɲaxanla na a ra bayo Rebeka ɲaxalan tofaɲin nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isiyaga to bu na, lɔxɔna nde Abimeleki, Filisitine mangana, na yi a yɛɛn namini banxin foye soden na. A yi a to Isiyaga Rebeka masugusuguma. ");
INSERT INTO yal_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki yi a xili a konni. A yi a fala a xa, a naxa, “I ya ɲaxanla yatin nan ito ra! Nanfera i a falaxi nxu xa, a i xunyɛ ɲaxalanmaan nan a ra?” Isiyaga yi a yabi, a naxa, “N yi gaxuxi nɛn alogo ɛ nama n faxa. Na nan a to, n yi na fala.” ");
INSERT INTO yal_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki mɔn yi a fala, a naxa, “I nanse ligaxi nxu ra? Xa muxuna nde fa mini n ma yamaan tagi go, a yi i ya ɲaxanla kolon ɲaxanla ra? Na waxatini i bata nxu findi yulubi tongone ra.” ");
INSERT INTO yal_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimeleki yi yamarin fi a yamaan birin ma, a naxa, “Muxu yo na maxa xɛmɛni ito nun ɲaxanla ito ra, n na kanna faxama nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Na ɲɛɛn na, Isiyaga yi xɛɛn bi bɔxɔni ito ma. A to na xɛɛn xaba, a yi na ɲɔxɔndɔn kɛmɛ sɔtɔ, bayo Alatala bata a baraka. ");
INSERT INTO yal_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","A hɛrin yi lu xun masɛ, a yi findi nafulu kanna ra. ");
INSERT INTO yal_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","A yi findi yɛxɛɛ gbegbe kanna ra e nun siine nun ɲingene nun konyi wuyaxi kanna. Filisitine yi Isiyaga maxɔxɔlɔn. ");
INSERT INTO yal_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Filisitine yi xɔɲinne birin nafe bɛndɛn na, Isiyaga baba Iburahimaa konyine naxanye ge Iburahima waxatini. ");
INSERT INTO yal_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleki yi a fala Isiyaga xa, a naxa, “I bata sɛnbɛn sɔtɔ be dangu nxu tan na. Fɔ i xa keli be.” ");
INSERT INTO yal_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isiyaga yi keli na, a siga Gerari lanbanni. A sa dɔxɔ mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isiyaga yi xɔɲinne yiba, naxanye yi gexi a baba waxatini. Filisitine na xɔɲinne dutun nɛn Iburahima faxa xanbini. A baba yi na xɔɲinne xinle falama kii naxan yi, Isiyaga mɔn yi ne xinle fala e xun ma na kiini. ");
INSERT INTO yal_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isiyagaa konyine mɔn yi xɔɲin gbɛtɛ ge na lanbanni. E yi tigin li a kui. ");
INSERT INTO yal_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Xuruse rabaan naxanye yi Gerari lanbanni, ne nun Isiyagaa xuruse rabane yi sɔnxɔ na xɔɲinna fe ra. E birin yi a fala, e naxa, “Nxu tan nan gbeen xɔɲinna ra.” Isiyaga yi xɔɲinni ito xili sa Eseki, bayo sɔnxɔn bata bira a fe yi. ");
INSERT INTO yal_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","A konyine mɔn yi xɔɲin gbɛtɛ ge, sɔnxɔn mɔn yi bira na fan ma fe yi. E yi a xili sa Sitina. ");
INSERT INTO yal_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","A yi keli na, a sa xɔɲinna ge yire gbɛtɛ yi. Na xɔɲinna to ge, sɔnxɔn mi bira na tan ma fe yi. E yi na xɔɲinna xili sa, Rehoboti, bayo e naxa, “Alatala bata dɔxɔde gbeen fi en ma. En ma feen bata fan bɔxɔni ito ma.” ");
INSERT INTO yal_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","E yi keli mɛnni, e siga Bɛriseba. ");
INSERT INTO yal_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Alatala yi mini a xa kɔɛɛn na. A yi a fala a xa, a naxa, “I fafe Iburahimaa Ala nan n tan na. I nama gaxu fefe ra, en tan na a ra yiren birin yi. N mɔn i barakama nɛn. N ni i bɔnsɔnna rawuyama ayi nɛn Iburahima fe ra, n ma walikɛna.” ");
INSERT INTO yal_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isiyaga yi saraxa ganden nafala mɛnni, a yi fa Alatala maxandi a xinla ra. A yi a bubuni tɔn mɛnni. A konyine mɔn yi xɔɲinna ge na. ");
INSERT INTO yal_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki yi keli Gerari yi, a yi fa, a e xa e bode to. Axusati yi biraxi a fɔxɔ ra, a maxadi tina, e nun Pikoli, a sofa mangana. ");
INSERT INTO yal_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isiyaga yi a maxɔdin, a naxa, “Ɛ faxi n todeni nanfera? Ɛ bata n naɲaxu han ɛ bata n kedi ɛ konni.” ");
INSERT INTO yal_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","E yi a yabi, e naxa, “Nxu bata a kolon yati a Alatala luxi i xɔn. Nxu mɔn bata a miri, fɔ en xa layirin tongo en bode xa marakɔlɔni. ");
INSERT INTO yal_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","I kɔlɔ nxu xa, a i mi fama fe xɔlɛn ligadeni nxu ra, bayo nxu fan mi fe kobi yo ligaxi i ra. Fɔ nxu to fe faɲin nan tun ligaxi i xa. Nxu mɔn yi i lu, i xa siga bɔɲɛ xunbenli. Waxatini ito yi, Alatala bata i baraka.” ");
INSERT INTO yal_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isiyaga yi donse gbegbeen nafala e xa. E birin yi e dɛge, e yi e min. ");
INSERT INTO yal_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kuye to yiba, e yi e kɔlɔ e bode xa. Isiyaga yi a ɲungu e ma, e yi fata lanni. ");
INSERT INTO yal_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Na lɔxɔni, Isiyagaa konyine yi fa xɔɲinni ito a fe dɛntɛgɛn sadeni a xa e naxan gexi, e naxa, “Nxu bata igen li xɔɲinni ito ra.” ");
INSERT INTO yal_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isiyaga yi na xɔɲinna xili sa Siba. Nanara, han to taani ito xinla falama Bɛriseba. ");
INSERT INTO yal_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esayu to ɲɛɛ tonge naanin sɔtɔ, a yi Yudita dɔxɔ, Beeri a dii tɛmɛna, e nun Basamati, Elon ma dii tɛmɛna. Ne firinna Xiti kaan nan e ra. ");
INSERT INTO yal_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","E yi Isiyaga nun Rebeka nii yiɲaxu e ma. ");
INSERT INTO yal_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isiyaga bata yi fori, a yɛɛne bata yi rafɔrɔ. A mi yi fa nɔɛ sese toɛ. A yi a dii forimana, Esayu, xili, a naxa, “N ma diina.” Esayu yi a ratin, a naxa, “N tan ni i ra.” ");
INSERT INTO yal_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isiyaga yi a fala, a naxa, “I bata a to, n bata fori. N mi a kolon, n faxama waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","I ya sube faxa seene tongo e nun i ya sagbaan nun i ya xanla. I siga donsoyaan na. I sa fa burunna suben na n xa. ");
INSERT INTO yal_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","I xa na suben ɲin n xa a faɲin na alo a rafan n ma kii naxan yi, i fa a ra n xɔn alogo n xa duba i xa benun n xa faxa.” ");
INSERT INTO yal_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Na waxatini, Rebeka yi tuli matixi Isiyaga ra, a falatini Esayu xa. Esayu yi siga burunna ra sube faxadeni a baba xa. ");
INSERT INTO yal_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka yi a fala a diin Yaxuba xa, a naxa, “N bata i baba xuiin mɛ a falani ito tima Esayu xa, ");
INSERT INTO yal_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","a naxa, ‘Sa suben bun n xa, i fa a ra, i yi a ɲin n xa, n xa a don. N na na suben don, n dubama i xa nɛn Alatala yɛtagi benun n xa faxa.’ ");
INSERT INTO yal_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Iki, n ma diina, i tuli mati n na ki faɲi. N ni i yamarima naxan na, i xa na liga. ");
INSERT INTO yal_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Siga xuruseene dɛnaxan yi, i sa fa sii dii faɲin firin na n xa. N xa na rafala a faɲin na alo i baba waxi a xɔn ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","I xa a xali i baba xa alogo a xa duba i tan nan xa benun a xa faxa.” ");
INSERT INTO yal_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yaxuba yi a nga Rebeka yabi, a naxa, “Koni, fati ma xaben kanna nan Esayu ra. N tan fati ma xaben mi n ma. ");
INSERT INTO yal_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","N baba na n masuxu, a kolonma nɛn Esayu xa mi a ra. N findima wule falan nan na a tan yi. Benun n xa duban sɔtɔ, n fama dangan nan sɔtɔdeyi na waxatini.” ");
INSERT INTO yal_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","A nga yi a fala, a naxa, “Ɛn-ɛn, na dangan fama xɛtɛdeni n tan nan ma n ma diina. I naxan ligama, i tuli mati n na. Siga i sa fa na sii dii firinne ra n xa.” ");
INSERT INTO yal_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yaxuba yi siga, a sa fa sii dii firinne ra a nga fɛma. A nga yi na donseen nafala alo a rafan Isiyaga ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Na xanbi ra, Rebeka yi Esayu, a dii singena domaan tongo, domaan naxan fan a dugine yɛ. A yi na ragodo Yaxuba ma, a dii firindena. ");
INSERT INTO yal_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","A yi sii kidine tongo, a yi a diin yiine maxidi e ra e nun a kɔɛna bayo fati ma xabe mi yi a ma. ");
INSERT INTO yal_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","A yi na donseen so a diin Yaxuba yii, e nun buruna a naxan nafalaxi. ");
INSERT INTO yal_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","A yi siga a baba fɛma, a yi a fala a xa, a naxa, “N baba, n tan ni i ra.” A yi a maxɔdin, a naxa, “Nde i tan na, n ma diina?” ");
INSERT INTO yal_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaxuba yi a baba yabi, a naxa, “Esayu nan n na, i ya diin forimana. I naxan maxɔdinxi n na, n bata fa a ra. Yandi, keli, i dɔxɔ, i n ma sube rafalaxin don, alogo i xa duba n xa.” ");
INSERT INTO yal_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isiyaga yi a fala a diin xa, a naxa, “I subeni ito toxi minɛn yi xulɛn, n ma diina?” Yaxuba yi a yabi, a naxa, “Alatala i ya Ala nan a fixi n ma.” ");
INSERT INTO yal_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isiyaga yi a fala Yaxuba xa, a naxa, “I maso n na, n xa i masuxu, n ma diina alogo n xa la a ra a Esayu nan yati i ra, n ma diina.” ");
INSERT INTO yal_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaxuba yi a maso a baba ra. Isiyaga yi a fatin masuxu. A yi a fala, a naxa, “I xuiin maliga Yaxuba xuiin na, koni i yiine tan Esayu yiine nan e ra.” ");
INSERT INTO yal_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","A mi yi nɔɛ Yaxuba kolonɲɛ bayo a yiine xaben yi e ma, alo a tada Esayu yi kii naxan yi. A yi duba a xa. ");
INSERT INTO yal_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","A mɔn yi a maxɔdin, a naxa, “N ma diina Esayu yatin nan i ra?” Yaxuba yi a yabi, a naxa, “Ɔn.” ");
INSERT INTO yal_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isiyaga yi a fala, a naxa, “Fa donseen na, i naxan nafalaxi, n xa a don. N yi duba i xa.” Yaxuba yi donseen so a baba yii. Isiyaga yi a don. A yi wudi bogi igen fan so a yii alo manpana, a yi na fan min. ");
INSERT INTO yal_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Na xanbi ra, a baba Isiyaga yi a fala a xa, a naxa, “I maso n na, i n sunbu, n ma diina.” ");
INSERT INTO yal_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yaxuba yi a maso a ra, a yi a sunbu. Isiyaga yi a dugine xirin mɛ. Awa, na xanbi ra, a yi duba a xa, a naxa, “Yɔ! N ma diin xirin luxi nɛn alo xɛɛna Alatala barakan saxi naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ala xa xiila fi i ma naxan kelima kore. Ala xa dahamu bɔxɔn fi i ma. Ala xa barakan sa i ya xɛɛni. Ala xa wudi bogi igen fi i ma. ");
INSERT INTO yal_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ala xa i dɔxɔ siyane xun na. Ala xa siyane magodo i xa. I xa findi i ngaxakedenne yɛɛratiin na. E birin xa e magodo i bun ma. Muxu yo na i danga, na dangan xa xɛtɛ a kanna ma. Muxu yo na duba i xa, na kanna fan xa duban sɔtɔ.” ");
INSERT INTO yal_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isiyaga to yelin dubadeni Yaxuba xa, a yi mini. A mi bu, Yaxuba tada Esayu fan yi so, sa keli sube bundeni. ");
INSERT INTO yal_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","A fan yi na suben nafala ki faɲi alo a baba waxi a xɔn ma kii naxan yi. A yi fa a ra a baba xa. A yi a fala a baba xa, a naxa, “N baba, keli, i dɔxɔ, i suben don n naxan nafalaxi i xa alogo i xa duba n xa.” ");
INSERT INTO yal_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","A baba Isiyaga yi a maxɔdin, a naxa, “Nde i tan na?” Esayu yi a yabi, a naxa, “Esayu nan n na, i ya diin forimana.” ");
INSERT INTO yal_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Na feen yi Isiyaga yifu ki faɲi. A fatin birin yi xuruxurun a ma. A yi maxɔdinna ti, a naxa, “Koni nde tan faxi suben nafalaxin na n xa, n naxan donxi iki benun i tan xa fa? N bata duba na kanna xa. A tan nan fama duba sɔtɔdeni.” ");
INSERT INTO yal_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esayu to a baba falan mɛ, a bɔɲɛn yi mini, a yi sɔnxɔ gbegbeen nate. A yi a baba mafan, a naxa, “Duba n fan xa, n baba.” ");
INSERT INTO yal_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isiyaga yi a yabi, a naxa, “I xunyɛn bata n mayenden. A tan bata i ya duban sɔtɔ.” ");
INSERT INTO yal_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esayu yi a fala, a naxa, “A xinla yatina a xun ma, Yaxuba. A sanɲa yi firinden ni i ra a n yanfama. A bata n ma foriya tiden tongo. Iki a bata n ma duban fan tongo.” Esayu mɔn yi a fala, a naxa, “Duba yo mi fa i yii sɔnɔn, i lan i xa naxan ti n tan xa?” ");
INSERT INTO yal_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isiyaga yi Esayu yabi, a naxa, “N bata a tan findi i xunna ra, n mɔn bata a ngaxakedenne fan birin so a yii e xa lu a bun ma. N bata baraka gbegbeen fi a ma, e nun wudi bogi ige faɲina. N nɔɛ nanfe ligɛ i tan xa, n ma diina?” ");
INSERT INTO yal_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esayu yi a fala a baba xa, a naxa, “N ba, duba keden peen nan i yii ba? N baba, duba n fan xa.” A yi wuga a xuini texin na. ");
INSERT INTO yal_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","A baba Isiyaga yi a yabi, a naxa, “A kolon, i mi fama bɔxɔ faɲi sɔtɔdeni, hanma xiila naxan kelima kore. ");
INSERT INTO yal_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","I ya silanfanna nan fama i balodeni. I fama walideni i xunyɛn nan bun ma, koni i fama nɛn i yɛtɛ sɔtɔdeni. A nɔɔn naxan sama i ma, i murutɛma nɛn na bun.” ");
INSERT INTO yal_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esayu yi a xunyɛn Yaxuba rafen yɛngɛn na a duban sɔtɔ feen na e baba ra. Esayu yi a fala a bɔɲɛni, a naxa, “N baba na faxa waxatin naxan yi, n Yaxuba faxama nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeka to a dii singen Esayu a natan kolon, a yi a dii firinden Yaxuba xili. A yi a fala a xa, a naxa, “I bata a to, i tada Esayu waxi a gbeen ɲɔxɔ feni i ma, a i faxa. ");
INSERT INTO yal_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Iki i tuli mati n na ki faɲi, n ma diina. Keli be, i siga Xarani yi, n tada Laban konni. ");
INSERT INTO yal_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","I sa lu a konni waxatini ito yi han i tada bɔɲɛn yi godo. ");
INSERT INTO yal_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","I tada bɔɲɛn na godo i ya fe ra waxatin naxan yi, a na ɲinan i liga fɔxɔn na, n na n ɲunguɛ, i fa. N mi waxi fula feni ɛ firinna birin na lɔxɔ kedenni.” ");
INSERT INTO yal_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka yi a fala Isiyaga xa, a naxa, “N niin bata yiɲaxu n ma Xiti kaa ɲaxanle fe ra. Xa a sa a li, Yaxuba fan ɲaxanla tongo bɔxɔni ito ma, na waxatini n ma siimayaan tɔnɔn nanse ra?” ");
INSERT INTO yal_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isiyaga yi Yaxuba xili. A yi duba a xa. A yi yamarini ito so a yii, a naxa, “I nama ɲaxanla dɔxɔ naxan findixi Kanan kaan na de! ");
INSERT INTO yal_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Keli, i siga Padan-Arami yi, i nga baba Betuyeli konni. I sa mɛnna ɲaxanla nde dɔxɔ naxan findɛ Laban ma dii tɛmɛn na, i nga tada xɛmɛmana. ");
INSERT INTO yal_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ala Sɛnbɛ Kanna xa i baraka, Ala xa dii gbegbe fi i ma, alogo i xa findi siya gbegbeen benban na. ");
INSERT INTO yal_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ala xa Iburahima a duban yabi i ma e nun i bɔnsɔnna, alogo bɔxɔni ito xa findi i gbeen na i waxati rabɛ dɛnaxan yi, Ala bɔxɔn naxan fi Iburahima ma.” ");
INSERT INTO yal_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isiyaga yi Yaxuba rasiga Padan-Arami yi, Laban konni, Betuyeli a diina Arami kaana. Laban, Rebeka tada xɛmɛmaan nan yi a ra. Yaxuba nun Esayu nga nan yi Rebeka ra. ");
INSERT INTO yal_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esayu yi a kolon a baba bata duba Yaxuba xa, a a rasiga Padan-Arami yi, a xa sa mɛnna ɲaxanla dɔxɔ. A mɔn yi a mɛ, a baba Isiyaga bata a yamari, a nama ɲaxanla dɔxɔ naxan findɛ Kanan kaan na. ");
INSERT INTO yal_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yaxuba yi a baba nun a nga xuiin binya. A yi siga Padan-Arami yi. ");
INSERT INTO yal_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esayu yi a kolon na waxatini Kanan kaa ɲaxanle mi rafan a baba Isiyaga ma. ");
INSERT INTO yal_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Awa, Esayu yi siga Sumayila konni, Iburahima diina. A yi Sumayilaa dii tɛmɛn Mahalati dɔxɔ, Nebayoti xunyɛ ɲaxalanmana. ");
INSERT INTO yal_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaxuba to keli Bɛriseba yi, siga Xarani yi, ");
INSERT INTO yal_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","kɔɛna a li dɛnaxan yi, a yi xi mɛnni. A yi gɛmɛ keden tongo, a yi a raso a xunna bun ma. A yi a sa mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","A yi xiye sa, sangalanna tixi bɔxɔn fari a xunna texi han kore. Alaa malekane yi teen nun godoni sangalanna ma. ");
INSERT INTO yal_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Alatala yi tixi e xun ma. A yi a fala a xa, a naxa, “N tan nan Alatala ra, i taɲe Iburahima nun Isiyagaa Ala. I saxi bɔxɔn naxan fari ito ra, n ni ito fima i ma nɛn ɛ nun i bɔnsɔnna. ");
INSERT INTO yal_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","I bɔnsɔnna fama wuyadeni nɛn alo gbangbanna. Ɛ bɔxɔn fama nɛn gbodeni ayi keli sogeteden ma han sa dɔxɔ sogegododen na, keli kɔmɛnna ma sa dɔxɔ yiifanna ra. Dunuɲa siyane birin duban sɔtɔma i tan nun i bɔnsɔnna sabun nan na. ");
INSERT INTO yal_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","En birin na a ra i na siga dɛdɛ. N ni i kantanma nɛn i na siga dɛnaxan yi, n ni i raxɛtɛma nɛn bɔxɔni ito ma. N mi i rabeɲinɲɛ. N feen naxan birin layiri tongoxi i xa, n na a birin ligama nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yaxuba yi xulun xixɔnli, a yi a fala, a naxa, “N bata yelin a kolonɲɛ yati, Alatala be yi, koni n mi yi a kolon.” ");
INSERT INTO yal_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","A yi gaxu, a yi a fala, a naxa, “Yire magaxuxin nan be ra. Sese mi a ra fɔ Alaa banxina, e nun kore xɔnna so dɛɛna.” ");
INSERT INTO yal_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","A yi keli xɔtɔn xɔtɔn, a gɛmɛn tongo naxan yi rasoxi a xunna bun ma. A yi a ti taxamasenna ra, a yi turen maso gɛmɛn xunna ma. ");
INSERT INTO yal_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","A yi na yiren xili sa Betɛli. Benun na xa liga, na yiren yi xili nɛn Lusi. ");
INSERT INTO yal_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yaxuba yi a dɛ ti Ala xa, a naxa, “Xa nxu nun Ala na a ra, a tan nan mɔn n kantanma kiraan xɔn ma n sigama dɛnaxan yi, a yi donseen so n yii n naxan donma, a mɔn yi maxidi seen so n yii n naxan soma n ma, ");
INSERT INTO yal_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","xa n xɛtɛ bɔɲɛ xunbenli n baba konni, nayi Alatala findima nɛn n ma Ala ra. ");
INSERT INTO yal_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Gɛmɛni ito, n naxan tixi taxamasenna ra, a findima Alaa banxin nan na. I seen naxan birin fima n ma, n na a yaganna bama nɛn, n na fi i ma.” ");
INSERT INTO yal_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yaxuba to ti kiraan xɔn ma siga sogeteden bɔxɔn mabinni, ");
INSERT INTO yal_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","a yi xɔɲinna to burunna ra. Yɛxɛɛn nun sii kuru saxan yi saxi na xɔɲinna fɛma e igen minma dɛnaxan yi. Gɛmɛ xungbeen nan yi saxi xɔɲinna dɛ ra. ");
INSERT INTO yal_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Na waxatini, e yi darixi xuruseene malanɲɛ na yiren nin. E malanxina, xuruse rabane yi gɛmɛn makutukutu naxan yi saxi xɔɲinna dɛ ra. Xuruseene to yelin ige mindeni, e mɔn yi gɛmɛn naxɛtɛ xɔɲinna dɛ ra. ");
INSERT INTO yal_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaxuba yi xuruse rabane maxɔdin, a naxa, “Ngaxakedenne, ɛ kelixi minɛn yi?” E yi a yabi, e naxa, “Nxu kelixi Xarani taan nin.” ");
INSERT INTO yal_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","A mɔn yi e maxɔdin, a naxa, “Ɛ Laban kolon, Nahori a dii xɛmɛna?” E yi a yabi, e naxa, “Ɔn, nxu a kolon.” ");
INSERT INTO yal_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","A yi e maxɔdin, a naxa, “A di na?” E yi a yabi, e naxa, “Sese mi a toxi. A dii tɛmɛna Rakeli nan fama na ra e nun xuruseene.” ");
INSERT INTO yal_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","A yi a fala e xa, a naxa, “En yanyin nin iki. Xuruseene malan waxatin xa mi a ra iki ba? Ɛ igen fi xuruseene ma mafurɛn, ɛ mɔn yi xɛtɛ e ra e rabadeni.” ");
INSERT INTO yal_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","E yi a fala, e naxa, “Nxu mi nɔɛ fefe ligɛ iki, fɔ xuruseene birin na malan. Na waxatini, nxu fa gɛmɛn ba xɔɲinna dɛ ra a dɛɛn yi balanxi naxan na, nxu fa igen fi xuruseene birin ma.” ");
INSERT INTO yal_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yaxuba to yi na falama e xa, Rakeli fan yi fa a babaa xuruseene ra, bayo xuruse rabaan nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yaxuba to Rakeli to fɛ, Yaxuba nga tada dii tɛmɛna, e nun Laban ma xuruseene, a yi a maso xɔɲinna dɛxɔn. A yi gɛmɛn ba xɔɲinna dɛ ra, a yi igen fi Laban ma xuruseene ma. ");
INSERT INTO yal_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yaxuba yi Rakeli sunbu, a yi wuga, a gbelegbele. ");
INSERT INTO yal_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","A yi a fala Rakeli xa, a a baba bari boden nan a ra, Rebekaa dii xɛmɛna. Rakeli yi giin nakɔ ayi, a sa na yɛba a baba xa. ");
INSERT INTO yal_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban to Yaxuba fe mɛ a xunyɛn ɲaxalanmana diina, a yi siga, a sa a ralan. A yi a sunbu, a a xali banxini. Feen naxan birin Yaxuba sɔtɔ, a yi na yɛba Laban xa. ");
INSERT INTO yal_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban yi a fala a xa, a naxa, “En birin wuli keden fasa keden.” Yaxuba yi kike keden naba Laban konni. ");
INSERT INTO yal_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lɔxɔna nde, Laban yi a fala Yaxuba xa, a naxa, “N bari boden nan i ra, koni sariya yo mi a falaxi i xa wali n xa, a fa lu n mi i saren fi. A fala n xa, a lan n xa i saren fi naxan na.” ");
INSERT INTO yal_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Awa, dii tɛmɛ firin nan yi Laban yii. A dii tɛmɛ singen xili nɛn Leya, a firindena Rakeli. ");
INSERT INTO yal_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya yɛɛne mi yi rayabu, koni Rakeli tan ɲaxalan tofaɲin nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Rakeli nan yi rafan Yaxuba ma ki faɲi. A yi a fala Laban xa, a naxa, “N ɲɛɛ solofere nan walima i xa, alogo i xa i ya dii tɛmɛn firinden Rakeli fi n ma.” ");
INSERT INTO yal_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban yi a fala, a naxa, “Benun n xa n ma diin fi muxu gbɛtɛn ma, n lan n xa a fi i tan nan ma. Lu n konni be.” ");
INSERT INTO yal_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yaxuba yi ɲɛɛ solofere wanla kɛ Laban yii Rakeli a fe ra. Koni na ɲɛɛ soloferen lu nɛn a xa alo xii dando gbansan, bayo a bata yi a xanu. ");
INSERT INTO yal_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Na xanbi ra, Yaxuba yi a fala Laban xa, a naxa, “N ma waxatin bata ɲan. N ma ɲaxanla so n yii fa, n xa a findi n yɛtɛ gbeen na.” ");
INSERT INTO yal_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban yi mɛn kaane birin xili, a e xa fa e dɛgedeni, e sɛwa sumunna raba. ");
INSERT INTO yal_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ɲinbanna ra, a yi Leya tongo, a dii tɛmɛ singena, a yi a so Yaxuba yii. Yaxuba yi a findi a yɛtɛ gbeen na. ");
INSERT INTO yal_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban yi Silipa so a diin Leya yii, a xa findi a konyin na. ");
INSERT INTO yal_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kuye to yiba, Yaxuba yi a to Leya na a ra. A yi a fala Laban xa, a naxa, “I nanse ligaxi n na ito ra? N mi walixi i xa Rakeli xan ma fe ra ba? Nanfera i n mayendenxi?” ");
INSERT INTO yal_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban yi a yabi, a naxa, “Nxu tan ma namunna mi tinɲɛ dii tɛmɛ firinden xa dɔxɔ xɛmɛ taa ra, a singen mi xɛmɛ sɔtɔxi. ");
INSERT INTO yal_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Xunsagini ito liga singen ɛ nun Leya. Xa i tin i mɔn xa ɲɛɛ solofere wanla kɛ n xa, n nan n ma dii tɛmɛ firinden fan fima nɛn i ma, a findi i ya ɲaxanla ra.” ");
INSERT INTO yal_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaxuba yi na liga. E nun Leya to xunsagin naba yire kedenni, Laban yi Rakeli fan fi a ma. ");
INSERT INTO yal_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","A yi Bila tongo a a so Rakeli yii a xa findi a konyin na. ");
INSERT INTO yal_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaxuba mɔn yi Rakeli findi a gbeen na, a yi Rakeli xanu dangu Leya ra. A mɔn yi ɲɛɛ solofere wanla kɛ Laban yii. ");
INSERT INTO yal_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Alatala to a to Leya mi rafanxi Yaxuba ma alo Rakeli, a yi a findi dii barin na. Na waxatini Rakeli tan yi findi gbantan na. ");
INSERT INTO yal_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya to fudikan, a yi diin bari. Na diin yi xili sa Rubɛn. A yi a fala, a naxa, “Alatala bata n ma marayarabin to. Iki n fa rafanma nɛn n ma xɛmɛn ma.” ");
INSERT INTO yal_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","A mɔn yi fudikan dii firinden na. A to na diin bari, a yi a fala, a naxa, “Alatala fan yatina a kolon, a n mi rafan n ma xɛmɛn ma. Na nan a toxi a dii firindeni ito fan fixi n ma.” A yi na diin xili sa Simeyɔn. ");
INSERT INTO yal_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","A mɔn yi fudikan dii saxanden na. A to a bari, a mɔn yi a fala, a naxa, “Awa, iki, fɔ n ma xɛmɛn xa kankan nɛn n ma sɔnɔn, bayo n bata dii saxan sɔtɔ a xa.” Na na a to, e yi a xili sa Lewi. ");
INSERT INTO yal_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","A yi fudikan dii naaninden na. A to na fan bari, a yi a fala, a naxa, “Awa, iki n na Alatala tantunma nɛn.” A yi na diin xili sa Yuda. A dii barin yi dan na dii muxu naaninna ma. ");
INSERT INTO yal_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rakeli to a to, a mi dii barima, a yi a tada maxɔxɔlɔn. A yi a fala Yaxuba xa, a naxa, “Diin fi n fan ma, xa na mi a ra n faxama nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaxuba yi xɔlɔ a falan na. A yi a fala, a naxa, “I a mirixi nɛn a Ala nan n tan na? Ala nan a ligaxi i mi dii barima!” ");
INSERT INTO yal_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rakeli yi a yabi, a naxa, “N ma konyi ɲaxanla Bila tongo alogo a xa diine bari n xa. Na waxatini na tan findɛ n xa sabun na n diin sɔtɔ i xa.” ");
INSERT INTO yal_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","A yi a konyi ɲaxanla Bila tongo, a a so a xɛmɛn Yaxuba yii. Yaxuba yi na kolon ɲaxanla ra. ");
INSERT INTO yal_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila yi fudikan, a yi dii xɛmɛn bari Yaxuba xa. ");
INSERT INTO yal_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rakeli yi a fala, a naxa, “Ala bata n ma kitin sa. A bata n ma falan mɛ. Na nan a toxi a diin fixi n ma.” A yi na diin xili sa Dan. ");
INSERT INTO yal_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rakeli a konyi ɲaxanla Bila mɔn yi fudikan. A yi dii xɛmɛ firinden bari Yaxuba xa. ");
INSERT INTO yal_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rakeli yi a fala, a naxa, “N bata n tada yɛngɛ n sɔbɛɛn birin na, n yi nɔɔn sɔtɔ.” A yi a diin xili sa Nafatali. ");
INSERT INTO yal_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leya to a kolon a mi fa dii barima, a yi a konyi ɲaxanla Silipa tongo, a yi a so Yaxuba yii, a xa findi a ɲaxanla ra. ");
INSERT INTO yal_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Leyaa konyin Silipa yi dii xɛmɛn bari Yaxuba xa. ");
INSERT INTO yal_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya yi a fala, a naxa, “Hɛrin bata fa n ma.” A yi na diin xili sa Gadi. ");
INSERT INTO yal_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Leyaa konyin Silipa yi dii firinden sɔtɔ Yaxuba xa. ");
INSERT INTO yal_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya yi a fala, a naxa, “N bata sɛwa. Iki, ɲaxanle birin a falama nɛn a n bata sɛwa.” A yi a xili sa Aseri. ");
INSERT INTO yal_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Murutu xaba waxatin to a li, Rubɛn yi siga xɛɛn ma. A yi bogisena nde li na, naxan xili marafanna bogisena. A yi fa a ra a nga xa. Nanara, Rakeli yi a fala Leya xa, a naxa, “N bata i maxandi, i ya diina marafan bogisena nde so n yii.” ");
INSERT INTO yal_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya yi a yabi, a naxa, “I bata n ma xɛmɛn ba n yii. Na mi i wasaxi? I mɔn waxi n ma diina marafan bogiseen nan tongo fe yi?” Rakeli yi a fala, a naxa, “To kɔɛɛn na, ɛ nun Yaxuba nan fama xideni i ya diina marafan bogiseen ɲɔxɔn na.” ");
INSERT INTO yal_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yaxuba to so ɲinbanna, sa keli xɛɛn ma, Leya yi a ralan. A yi a fala a xa, a naxa, “I xima n tan nan xɔn ma to kɔɛɛn na. N bata to kɔɛɛn saren fi n ma diina marafan bogiseen na.” Yaxuba mɔn yi Leya kolon ɲaxanla ra na kɔɛɛn na. ");
INSERT INTO yal_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ala yi tin Leyaa maxandin ma, a yi fudikan. Na yi findi a dii suulunden na Yaxuba xa. ");
INSERT INTO yal_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya yi a fala, a naxa, “Ala bata n saren fi n ma konyi ɲaxanla so feen na n ma xɛmɛn yii.” A yi a diin xili sa Isakari. ");
INSERT INTO yal_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya mɔn yi fudikan dii senninden na. A yi na diin bari Yaxuba xa. ");
INSERT INTO yal_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leya yi a fala, a naxa, “Ala bata n ki. Awa, iki n ma xɛmɛna n binyama nɛn, bayo n bata dii sennin bari a xa.” A yi na diin xili sa Sabulon. ");
INSERT INTO yal_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Na xanbi ra, a mɔn yi dii tɛmɛn bari. A yi a xili sa Dina. ");
INSERT INTO yal_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ala yi a yengin nasiga Rakeli ma. A yi a maxandi xuiin namɛ, a yi a findi dii barin na. ");
INSERT INTO yal_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","A yi fudikan, a yi diin bari. A yi a fala, a naxa, “Ala bata n namini yagini ito yi.” ");
INSERT INTO yal_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","A yi na diin xili sa Yusufu. A yi falani ito ti, a naxa, “Alatala mɔn xa dii xɛmɛ gbɛtɛ fan fi n ma.” ");
INSERT INTO yal_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Yusufu to bari, Yaxuba yi a fala Laban xa, a naxa, “A lu n xa xɛtɛ n kon bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","A lu n xa n ma ɲaxanle xali e nun n ma diine, n walixi i xa naxanye fe ra. I a kolon n wanla naxan yatɛn ligaxi i xa.” ");
INSERT INTO yal_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban yi a fala a xa, a naxa, “Diɲa. N bata a kolon yiimatoon xɔn, Alatala barakan saxi n ma fe yi i tan nan sabu ra. ");
INSERT INTO yal_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","A fala n xa n lan n xa i saren fi naxan na. N na a soma i yii nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaxuba yi a fala a xa, a naxa, “I tan yatina a kolon n walixi i xa kii naxan yi han i ya xuruseene bata wuya ayi n tan barakani. ");
INSERT INTO yal_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ndedi nan yi i yii nun benun n xa fa, koni iki, a gbegbe bata sa na fari. Alatala bata barakan sa i ya fe yi xabu n so i konni. N fa wanla nde kɛma n ma denbayaan fan xa waxatin mundun yi?” ");
INSERT INTO yal_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban yi a fala, a naxa, “A lan n xa yoli fi i ma?” Yaxuba yi a yabi, a naxa, “I nama sese fi n ma. Xa i bata tin n feen naxan falaxi i xa, na liga, n fan bata tin n yengi sɛ i ya xuruseene xɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","N sigama nɛn to, n sa i ya xuruseene birin mato. Yɛxɛɛn nun sii makatunxin birin ti e danna e nun naxanye birin fɔrɔ makɛnɛnxi. N saren findima ne nan na. ");
INSERT INTO yal_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","N ma tinxinna fama makɛnɛndeni nɛn i na fa xuruse matodeni waxatin naxan yi. Siin naxanye birin mi makatunxi e nun yɛxɛɛ diin birin fɔrɔ makɛnɛnxi mi naxanye ma, na bata findi muɲan na n mabinni.” ");
INSERT INTO yal_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban yi a fala, a naxa, “N bata tin na ma. I naxan falaxi, en bata lan na ma.” ");
INSERT INTO yal_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Na lɔxɔn yɛtɛni Laban yi sii kɔtɔ maɲingixine nun a makatunxine yɛba. Sii gilɛne fɔrɛ fɔrɛdine naxanye ma e nun fɔrɛ xungbene yi naxanye ma e nun yɛxɛɛ fixɛ makadanxine, a mɔn yi ne birin yɛba. A yi na xuruseene birin taxu a diine ra. ");
INSERT INTO yal_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Na xanbi ra, a yi ne xali yirena nde yi xii saxan sigatiin tiyɛ dɛnaxan yi e nun Yaxuba tagi. Yaxuba yi fa Laban ma xuruse dɔnxɛne raba. ");
INSERT INTO yal_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaxuba yi wudi bili sifa saxan yii xindene gira. A yi e lutine ba e ma alogo maɲingi fixɛn xa makɛnɛn. ");
INSERT INTO yal_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","A yi wudi yiine sa xuruseene mindeni xuruseene yɛtagi bayo e tema e bode ra nɛn e na fa ige mindeni. ");
INSERT INTO yal_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Xuruseene yi te e bode ma wudi yiine yireni, e yi diine xali maɲingi fixɛn nun fɔrɛ fɔrɛdine nun fɔrɛ xungbene saxi e ma. ");
INSERT INTO yal_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaxuba yi xuruse diine yitaxun alogo e xa ti Laban ma xuruseene yɛtagi maɲingin nun ɲingin makɛnɛnxin naxanye ma. Nayi, a yi xuruseene malan a yɛtɛ xa a mi naxanye basan Laban gbeene ra. ");
INSERT INTO yal_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Waxatin birin xuruse sɛnbɛmane nɛma tɛ a gilɛne ra, Yaxuba yi wudi yiine sama nɛn xuruse mindeni alogo e xa te a gilɛne ra wudi yiine yireni. ");
INSERT INTO yal_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Yaxuba mi yi na ligama xuruse xunxurine ra. Na nan a liga xuruse xurine yi findi Laban gbeen na, a sɛnbɛmane yi findi Yaxuba gbeen na. ");
INSERT INTO yal_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yaxuba yi findi nafulu kan gbeen na. A yi xuruse gbegbe sɔtɔ. Konyi xɛmɛne nun konyi gilɛne nun ɲɔgɔmɛne nun sofanle yi lu a yii. ");
INSERT INTO yal_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Na waxatini Yaxuba bata yi Laban ma diine xuiin mɛ e yi naxan falama, e naxa, “Seen naxan birin findixi en baba gbeen na, Yaxuba bata e birin tongo. Na nan a toxi a bata findi nafulu kanna ra.” ");
INSERT INTO yal_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaxuba yatin yi a kolon, a a marafanna mi fa Laban yi sɔnɔn alo a fɔlɔni. ");
INSERT INTO yal_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Alatala yi a fala Yaxuba xa, a naxa, “Xɛtɛ i baba nun i bari bodene bɔxɔni i kelixi dɛnaxan yi. N luma nɛn i xɔn.” ");
INSERT INTO yal_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yaxuba yi Rakeli nun Leya xili. E yi a xuruseene rabama. ");
INSERT INTO yal_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","A yi a fala e xa, a naxa, “N bata a kolon n ma marafanna mi fa ɛ baba yi sɔnɔn alo a fɔlɔni, koni n babaa Ala bata lu n xɔn. ");
INSERT INTO yal_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ɛ a kolon yati, n bata wali ɛ baba xa n fangan birin na. ");
INSERT INTO yal_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","A bata n mayenden a n saranna maxɛtɛ sanɲa yi fu, koni Ala mi tin a fe ɲaxin liga n na. ");
INSERT INTO yal_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Xa ɛ baba fa a fala, a naxa, ‘Fɔrɛ fɔrɛne xuruseen naxanye ma, ne nan findima i gbeen na,’ xuruseene birin yi diin xalima nɛn fɔrɛ fɔrɛne naxanye ma. Xa ɛ baba fa a fala, a naxa, ‘Maɲingin xuruseen naxanye ma, ne nan findima i gbeen na,’ xuruseene birin yi dii maɲingixin nan xalima. ");
INSERT INTO yal_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ala bata ɛ babaa xuruseene ba a yii, a yi e fi n tan ma.” ");
INSERT INTO yal_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Xuruseene yi tema e bode ra waxatin naxan yi, n bata a to xiyeni, xuruse xɛmɛn naxanye texi xuruse gilɛne ra, ne maɲingixi, e mafɔrɔ fɔrɔxi e nun e makatun katunxi. ");
INSERT INTO yal_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","N ma xiyeni, Ala a malekan yi n xili, a naxa, ‘Yaxuba.’ N yi a ratin, n naxa, ‘N tan ni i ra.’ ");
INSERT INTO yal_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","A yi a fala, a naxa, ‘I xunna rakeli, a mato. Xuruse xɛmɛn naxanye birin texi xuruse gilɛne ra, ne maɲingixi, e mafɔrɔ fɔrɔxi e nun e makatun katunxi, bayo Laban naxan birin ligaxi i ra, n na toxi. ");
INSERT INTO yal_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","N tan nan Ala ra naxan fa i ma Betɛli yi, i gɛmɛn tixi taxamasenna ra dɛnaxan yi i layirin tongoxi n xa dɛnaxan yi. Iki, keli bɔxɔni ito ma. I siga na bɔxɔni i barixi dɛnaxan yi.’ ” ");
INSERT INTO yal_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rakeli nun Leya yi Yaxuba yabi, e naxa, “Nxu baba mi kɛɛ yo luxi nxu tan xa! ");
INSERT INTO yal_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Xɔɲɛn xa mi nxu ra nxu baba konni? A bata nxu mati, a mɔn bata nxɔ gbetin fan don. ");
INSERT INTO yal_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ala hɛrisigɛn naxan birin baxi nxu baba yii, a xɛtɛma nɛn nxu ma e nun nxɔ diine. Iki Ala feen naxan birin falaxi i xa, na birin liga.” ");
INSERT INTO yal_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yaxuba yi a ɲaxanle nun a diine rate ɲɔgɔmɛne fari. ");
INSERT INTO yal_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","A xuruseen nun hɛrisigɛn naxan birin sɔtɔ Padan-Arami yi, a yi keli, a yi e birin xali a baba Isiyaga konni Kanan bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban yi a xuruseene xabene maxabama e ma waxatin naxan yi, Rakeli yi a babaa suxurene muɲa. ");
INSERT INTO yal_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaxuba yi Arami kaan Laban mayenden. A siga a mi sese fala a xa. ");
INSERT INTO yal_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","A yi a gi, e nun seen naxan birin findi a gbeen na. A yi Efirati baani gidi. Na xanbi ra, a yi siga Galadi geyaan mabinni. ");
INSERT INTO yal_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","A xii saxande lɔxɔni, muxuna nde yi a fala Laban xa fa fala Yaxuba bata a gi. ");
INSERT INTO yal_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban yi a ngaxakedenne tongo, e yi mini Yaxuba fendeni xii solofere bun ma. E yi e li Galadi geyane binna ra. ");
INSERT INTO yal_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Koni kɔɛɛn na, Ala yi a yɛtɛ yita Arami kaan Laban na xiyeni. A yi a fala a xa, a naxa, “I yɛtɛ ratanga feen sifan birin fala feen na Yaxuba ma.” ");
INSERT INTO yal_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban yi Yaxuba li. A bubun tixi geyaan fari. Laban nun a ngaxakedenne fan yi e gbeen ti Galadi geyaan fari. ");
INSERT INTO yal_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban yi a fala Yaxuba xa, a naxa, “I nanse ligaxi ito ra? Nanfera i n mayendenxi? I bata n ma diine xali alo muxu suxine yɛngɛni. ");
INSERT INTO yal_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nanfera i gixi luxunni? I bata yanfantenyaan liga n na. I mi sese falaxi n xa. Xa i yi n nakolon nun, n yi i matima nɛn sɛwa sigine yi, tanbanna nun konden xuiin na. ");
INSERT INTO yal_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Koni i mi a lu yati n xa n ma diine nun n mamandenne sunbu, n yi n ɲungu e ma. I bata feen liga alo xaxilitarena. ");
INSERT INTO yal_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","N yi nɔɛ fe kobin ligɛ ɛ ra nɛn, koni i babaa Ala bata a fala n xa to kɔɛɛn na, a naxa, ‘I yɛtɛ ratanga feen sifan birin fala feen na Yaxuba ma.’ ");
INSERT INTO yal_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Na bata lan, i sigaxi nɛn bayo i yi kunfaxi siga feen na i baba konni, koni nanfera i n ma suxurene muɲaxi n ma?” ");
INSERT INTO yal_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaxuba yi Laban yabi, a naxa, “N gaxu nɛn n miriyani alogo i nama i ya diine rasuxu n na. ");
INSERT INTO yal_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Koni i na i ya suxurene to n ma muxu yo yii, n na kanna faxama nɛn. Ngaxakedenne birin yɛɛ xɔri, n ma goronna birin mato. Naxan birin findixi i gbeen na, i xa a xali.” Na waxatini Yaxuba mi yi a kolon xa Rakeli a babaa suxurene tongoxi. ");
INSERT INTO yal_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban yi Yaxubaa bubune kui to e nun Leya konni e nun konyi firinne konni, koni a mi sese to. A to mini Leyaa bubuni, a yi so Rakeli fan konni. ");
INSERT INTO yal_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rakeli nan yati suxureni itoe tongoxi. A yi e luxun kirixan bun ma naxan sama ɲɔgɔmɛn fari, a fa dɔxɔ a fari. Laban yi bubun kui to, a mi sese to na kui. ");
INSERT INTO yal_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rakeli yi a fala a baba xa, a naxa, “N baba i nama xɔlɔ n ma xa n mi fa keli i yɛtagi. N kike wanla nin.” Laban fenna sifan birin ti nɛn, koni a mi suxurene to. ");
INSERT INTO yal_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yaxuba yi xɔlɔ, a yi fala xɔlɛn ti Laban ma, a naxa, “N gbalon mundun ligaxi, n hakɛn mundun ligaxi naxan a ligama i xa mini n fendeni kiini ito yi? ");
INSERT INTO yal_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","I bata n ma goronna birin kui to. I gbee seen mundun toxi e kui? A yita n na ngaxakedenne yɛɛ xɔri e nun i fan ngaxakedenne yɛɛ xɔri alogo e xa kitin sa en tagi. ");
INSERT INTO yal_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","N ɲɛɛ mɔxɔɲɛ nan tixi i konni, koni i ya yɛxɛɛn nun sii dii keden mi diin xalixi a faxa n yii. N mɔn mi i ya xuruse yo donxi. ");
INSERT INTO yal_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","N mi faxi xuruse ra i fɛma burunna subene naxan faxaxi. Naxanye yi muɲama kɔɛɛn nun yanyin na, ne bɔnɔn yi luma n tan nan xa bayo i yi e ɲɔxɔn maxilima n na. ");
INSERT INTO yal_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Lɔxɔ yo lɔxɔ kuye wolonna yi n tɔrɔma nɛn yanyin na, xunbenla yi n tɔrɔ kɔɛɛn na, n yɛtɛɛn mi yi nɔɛ xiyɛ. ");
INSERT INTO yal_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","N bata ɲɛɛ mɔxɔɲɛ ti i yii. N ɲɛɛ fu nun naanin wanla kɛxi nɛn alogo n xa i ya dii tɛmɛ firinne dɔxɔ. N mɔn yi ɲɛɛ sennin fan sa a fari i ya xuruseene kantandeni. Koni i bata n saranna maxɛtɛ dɔxɔɲa ma fu. ");
INSERT INTO yal_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Xa n taɲe Iburahimaa Ala, n baba Isiyaga gaxun naxan yɛɛ ra, xa na mi yi a ra nun, n yi kelima nɛn be n yii genla. Koni Ala bata n ma marayarabin to, e nun n yi wali xɔdɛxɛn naxanye ligama, kɔɛ danguxini ito yi, a bata n ma kitin sa.” ");
INSERT INTO yal_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban yi Yaxuba yabi, a naxa, “I ya ɲaxanle, n ma diine nan ne ra. E diine, n gbeen nan ne ra. Xuruseni itoe n gbeen nan e ra, n naxan birin toma ito ra, n tan nan gbee e ra. Koni to xanbi ra, n nɔɛ nanse ligɛ n ma diine nun n mamandenne xa? ");
INSERT INTO yal_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Iki, en xa layiri tongo. Sereyaan xa lu en tagi.” ");
INSERT INTO yal_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yaxuba yi gɛmɛn tongo, a yi a ti taxamasenna ra. ");
INSERT INTO yal_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Na xanbi ra, Yaxuba yi a fala a ngaxakedenne xa, a e xa gɛmɛne matongo. E yi e matongo, e e malan yire kedenni. E yi e dɛge na gɛmɛ malanxine fari. ");
INSERT INTO yal_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban yi na mɛnna xili sa Yegara-Sahaduta. Yaxuba yi mɛn xili sa Galadi. ");
INSERT INTO yal_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban yi a fala, a naxa, “Gɛmɛ malanxini itoe findixi seren nan na i tan nun n tan tagi.” Na nan a toxi mɛnna xili saxi Galadi. ");
INSERT INTO yal_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Mɛn mɔn xili nɛn “Misipa.” Laban mɔn yi a fala, a naxa, “Alatala xa a yengi dɔxɔ en tan firinna a fe xɔn ma, hali en fata xanbini. ");
INSERT INTO yal_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Xa i n ma diine tɔrɔ, xa na mi a ra i ɲaxalan gbɛtɛ dɔxɔ, i lanma i xa xaxinla sɔtɔ, bayo muxun xa mi en tagi seren na. Ala nan yati en firinna seren na.” ");
INSERT INTO yal_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Na xanbi ra, Laban yi a fala Yaxuba xa, a naxa, “I yɛɛn ti gɛmɛ malanxini itoe ra. Taxamaseri gɛmɛni ito mato n naxan tixi en tagi. ");
INSERT INTO yal_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Gɛmɛ malanxini itoe nun taxamaseri gɛmɛni ito findixi serene nan na. N mi lan n xa dangu be ra i ya fe ɲaxina n kui. I fan mi lan i xa dangu gɛmɛ malanxini itoe nun taxamaseri gɛmɛni ito ra n ma fe ɲaxina i kui. ");
INSERT INTO yal_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Iburahimaa Ala nun Nahori a Ala xa findi en tan firinna makitimaan na.” Na waxatini Yaxuba yi a kɔlɔ Ala yi a baba Isiyaga gaxun naxan yɛɛ ra. ");
INSERT INTO yal_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yaxuba yi saraxan ba geyaan fari. A yi a ngaxakedenne birin xili, e xa sa e dɛge. E to yelin e dɛgɛ, e yi xi geyaan fari. ");
INSERT INTO yal_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Laban to keli subaxan ma, a yi a ɲungu a diine ma, e nun a mamandenne. A yi duba e xa. Na xanbi, Laban yi xɛtɛ a konni. ");
INSERT INTO yal_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaxuba yi sigama kiraan xɔn waxatin naxan yi, Alaa malekane yi fa a ma. ");
INSERT INTO yal_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yaxuba to e to, a naxa, “Alaa ganla daaxaden nan ito ra.” A yi na yiren xili sa Maxanayin. ");
INSERT INTO yal_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yaxuba yi xɛrane rasiga a tada Esayu ma Edɔn banxidɛɛn na, Seyiri bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A yi yamarin fi e ma, a naxa, “Ɛ ito nan falama n kanna Esayu xa, ɛ naxa, ‘I ya konyi Yaxuba naxa, n bata lu Laban konni. N bata bu gbeen ti na yi. ");
INSERT INTO yal_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ɲinge gbegbe nan n yii e nun sofanle nun yɛxɛɛne nun siine. Konyi xɛmɛne nun konyi gilɛne n yii. Iki, n xɛrane rasigama i ma alogo i xa marasɛnɛ faɲin fi n ma.’ ” ");
INSERT INTO yal_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Xɛrane yi xɛtɛ, e yi a fala Yaxuba xa, e naxa, “Nxu bata siga. Nxu sa i tada Esayu li na. A fama i ralandeni e nun a banxulan muxu kɛmɛ naanin.” ");
INSERT INTO yal_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Gaxu gbeen yi Yaxuba suxu, a kuisan. Yamaan naxan yi a fɔxɔ ra, a yi e taxun dɔxɔde firin. A yi yɛxɛɛne nun siine yitaxun dɔxɔ firin, e nun ɲingene, e nun ɲɔgɔmɛne. ");
INSERT INTO yal_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","A yi a fala, a naxa, “Xa Esayu yama keden yɛngɛ, yamaan boden xa a gi.” ");
INSERT INTO yal_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Na xanbi Yaxuba yi Ala maxandi, a naxa, “N taɲe Iburahimaa Ala nun n baba Isiyagaa Ala, i bata a fala n xa, i tan Alatala, i naxa ‘Xɛtɛ i ya bɔxɔni, i kon kaane dɛnaxan yi. I na siga, n fe faɲin ligama nɛn i xa.’ ");
INSERT INTO yal_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","N tan xurun. N mi daxa n hinanna nun lannayaan birin sɔtɔ, i naxan nagidixi n ma, i ya walikɛna. N ma dunganna gbansanna nan yi suxi n yii n Yurudɛn baani gidi waxatin naxan yi, koni iki nxu nun yama firin nan xɛtɛma. ");
INSERT INTO yal_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","N natanga n tada Esayu ma, bayo n bata gaxu a yɛɛ ra. N sikɛxi, a nama fa n faxa, e nun ɲaxanle nun diine. ");
INSERT INTO yal_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","I bata a fala n xa, i naxa, ‘N fe faɲin ligama nɛn i xa. N ni i bɔnsɔnna rawuyama ayi nɛn alo fɔxɔ igen mɛɲɛnsinna naxan mi yatɛ.’ ” ");
INSERT INTO yal_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yaxuba yi kɔɛɛn nadangu na. Seen naxan birin yi a yii, a yi sanba seen yɛ mato a naxan soma a tada Esayu yii: ");
INSERT INTO yal_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Sii kɛmɛ firin nun kɔtɔ mɔxɔɲɛ e nun yɛxɛɛ kɛmɛ firin nun konton mɔxɔɲɛ e nun ");
INSERT INTO yal_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ɲɔgɔmɛ gilɛ tonge saxan nun e diine nun ɲinge tonge naanin nun tura fu nun sofali gilɛ mɔxɔɲɛ e nun sofali xɛmɛ fu. ");
INSERT INTO yal_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","A yi xuruseni itoe yitaxun kuru keden keden yɛɛn ma, a nde so a konyine yii. A yi a fala e xa, a naxa, “Ɛ dangu yɛɛn na. Ɛ xa sagaran lu kurune tagi.” ");
INSERT INTO yal_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A yi a konyi singen yamari, a naxa, “Ɛ nun n tada Esayu na naralan, a fama i maxɔdindeni nɛn, a naxa, ‘Ɛ nun nde a ra? I sigan minɛn yi? Nde gbee xuruseni itoe ra naxanye tixi i yɛɛ ra?’ ");
INSERT INTO yal_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","I ya a yabima nɛn, i naxa, ‘I ya konyin Yaxuba nan gbee e ra. A i sanbaxi itoe nan na, n kanna Esayu. A fan nxu fɔxɔ ra.’ ” ");
INSERT INTO yal_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","A yi na yamarin fi a firinde fan ma, e nun a saxandena, e nun muxun naxanye biraxi xuruseene fɔxɔ ra, a naxa, “Xa ɛ nun Esayu naralan waxatin naxan yi, ɛ na nan falama a xa. ");
INSERT INTO yal_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ɛ ito nan sama a fari, ɛ naxa, ‘I ya konyina Yaxuba fama nxu xanbi ra.’ ” Yaxuba yi a fala, a naxa, “Iki n na a bɔɲɛn magodoma seni itoe nan na. Na xanbi n na fa a ma, yanyina nde a n nasɛnɛma nɛn a faɲin na.” ");
INSERT INTO yal_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yaxubaa sanba seene yi ti a yɛɛ ra, a tan yi kɔɛɛn nadangu daaxadeni. ");
INSERT INTO yal_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kɔɛɛn na, Yaxuba yi keli. A yi a ɲaxalan firinne tongo e nun e konyi firinne nun a dii fu nun kedenna. E yi Yaboko xuden gidi. ");
INSERT INTO yal_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","A yi e ragidi Yaboko xuden na e nun a yii seen birin. ");
INSERT INTO yal_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","A keden peen yi lu. Na waxatini, xɛmɛna nde yi mini a ma, e yi gerenna so han kuye yiba waxatini. ");
INSERT INTO yal_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","A to a to, a mi nɔ sɔtɔma Yaxuba ma e gerenni, a yi a garin a wotegelen ma. A wotegelen yi te a kui. ");
INSERT INTO yal_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Xɛmɛn yi a fala, a naxa, “A lu n xa siga, bayo kuye bata yiba.” Yaxuba yi a yabi, a naxa, “N mi i beɲinma, fɔ i duba n xa.” ");
INSERT INTO yal_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Xɛmɛn yi a maxɔdin, a naxa, “I xili di?” Yaxuba yi a yabi, a naxa, “Yaxuba.” ");
INSERT INTO yal_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Xɛmɛn yi a fala, a naxa, “I xili mi falama sɔnɔn Yaxuba. A fa falama nɛn Isirayila, bayo ɛ nun Ala nan gerenna soxi, e nun muxune, i yi nɔɔn sɔtɔ.” ");
INSERT INTO yal_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yaxuba yi maxɔdinna ti, a naxa, “I xili di?” Boden yi a fala, a naxa, “Nanfera i n maxɔdinma n xinla ma?” Na xanbi, a yi duba Yaxuba xa. ");
INSERT INTO yal_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yaxuba yi na yiren xili sa Penuyɛli, bayo Yaxuba a fala nɛn, a naxa, “N bata Ala to yɛɛ nun yɛɛ, a tin n niin yi kisi.” ");
INSERT INTO yal_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Sogen tema waxatin naxan yi, Yaxuba bata yi dangu Penuyɛli ra. A godoma a wotegelen ma. ");
INSERT INTO yal_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Na nan a toxi han iki Isirayila kaane mi fasan donma naxan wotegelen ma, bayo Ala Yaxuba masɔtɔxi a wotegelen fasan nan ma. ");
INSERT INTO yal_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaxuba yi Esayu to fɛ e nun banxulanna muxu kɛmɛ naanin. A yi diine yitaxun Leya nun Rakeli ra e nun konyi gilɛ firinne. ");
INSERT INTO yal_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","A yi konyi gilɛ firinne ti yɛɛn na, e nun e diine. Leya fan yi ti ne xanbi ra e nun a diine. Rakeli nun Yusufu yi lu dɔnxɛn na. ");
INSERT INTO yal_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","A tan yi dangu ne yɛɛ ra, a xinbi sin sanɲa ma solofere benun a xa a tada li. ");
INSERT INTO yal_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Koni Esayu yi a gi a sa Yaxuba ralan. A yi dutun a ma, a fa a sunbu. E birin yi wuga. ");
INSERT INTO yal_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esayu to ɲaxanle nun diine to, a yi maxɔdinna ti, a naxa, “Nde ne ra naxanye biraxi i fɔxɔ ra?” Yaxuba yi a yabi, a naxa, “Ala diin naxanye fixi i ya konyin ma a nɛmaan xɔn ma.” ");
INSERT INTO yal_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Konyi gilɛne yi e maso e nun e diine, e yi e xinbi sin. ");
INSERT INTO yal_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya fan nun a diine yi e maso, e fan yi e xinbi sin. Na xanbi Yusufu fan nun Rakeli yi na liga. ");
INSERT INTO yal_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esayu yi maxɔdinna ti, a naxa, “I nanse ligama xuruseni ito birin na, n naralanxi naxanye ra?” Yaxuba yi a yabi, a naxa, “N waxi nɛn, n kanna xa n nafan.” ");
INSERT INTO yal_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esayu yi a fala, a naxa, “N xunyɛna, hɛrisigɛ gbegbe n fan yii. I gbeen mara.” ");
INSERT INTO yal_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaxuba yi a fala, a naxa, “Ɛn-ɛn, n bata i maxandi, xa i bata n nafan, n na i sanbaxi seen naxanye birin yi, i xa ne rasuxu. N bata i yɛtagin to. Na luxi nɛn n yi alo n na Ala yɛtagi nan toma, bayo i bata n nasɛnɛ ki faɲi. ");
INSERT INTO yal_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","N seen naxanye sanbaxi i ma, e rasuxu. Ala bata hinan n na, a n makoon birin fan.” Yaxuba yi a yixɔdɔxɔ han Esayu yi tin. ");
INSERT INTO yal_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esayu yi a fala, a naxa, “En siga kiraan xɔn ma, n xa sa i mati.” ");
INSERT INTO yal_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yaxuba yi a yabi, a naxa, “N kanna, a kolon diine fe xɔdɔxɔ. Yɛxɛɛ gilɛne nun ɲinge gilɛne xiɲɛn fima e diine ma. Xa en gbɛtɛn e ra lɔxɔ kedenni, ne birin faxama nɛn. ");
INSERT INTO yal_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","N kanna, i tan xa ti yɛɛn na. N tan xa bira n ma xuruseene fɔxɔ ra ndedi ndedi. N xa siga n yeren ma, nxu nun n ma diine han nxu soma i konni waxatin naxan yi Seyiri bɔxɔni.” ");
INSERT INTO yal_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esayu yi a fala, a naxa, “N xa n ma muxuna nde lu i yii be.” Yaxuba yi a fala, a naxa, “Nanfera? N kanna, n tan waxi naxan xɔn, n xa rafan i ma gbansan.” ");
INSERT INTO yal_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Na lɔxɔni, Esayu yi ti Seyiri kiraan xɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaxuba tan yi siga Sukɔti yi. A yi banxi keden ti a yɛtɛ xa, a kulane ti a xuruseene xa. Nanara na yiren xili nɛn Sukɔti. ");
INSERT INTO yal_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaxuba to keli Padan-Arami yi, a yi so kɛndɛyani Siken taani Kanan bɔxɔni. A yi daaxadeni tɔn taan xanbi ra. ");
INSERT INTO yal_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","A bubun yi tixi dɛnaxan yi, a yi bɔxɔn sara Xamori a diine ma, Siken Baba, naxanye singe dɔxɔ Siken yi. A yi na sara gbeti gbanan kɛmɛ ra. ");
INSERT INTO yal_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","A yi saraxa ganden nafala mɛnni. A yi na xili sa “Isirayilaa Ala.” ");
INSERT INTO yal_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Yaxubaa dii tɛmɛn Dina, Leya naxan barixi Yaxuba xa, na yi siga Siken ɲaxanle xɔntɔndeni. ");
INSERT INTO yal_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Xamori a dii xɛmɛn Siken, Xiwin naxan findixi na yamanan mangan na, na to Dina to, a yi fu a ma a yi a rayagi. ");
INSERT INTO yal_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Yaxubaa dii tɛmɛn Dinaa xanuntenyaan yi lu Siken fatini. A yi fala ɲaxumɛne ti a xa. ");
INSERT INTO yal_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","A yi a fala a baba Xamori xa, a naxa, “Dii tɛmɛni ito maxandi n xa alogo n xa a dɔxɔ.” ");
INSERT INTO yal_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaxuba yi a mɛ, a bata a dii tɛmɛn Dina rayagi. Na waxatini, a diine yi sa xɛɛn ma xuruseene fɔxɔ ra. A mi sese fala han ne so waxatini. ");
INSERT INTO yal_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Siken baba Xamori yi siga Yaxuba konni a xa sa falan ti a xa. ");
INSERT INTO yal_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yaxuba a diine to keli xɛɛn ma, e yi na feen mɛ naxan danguxi. E yi e yomayaan to, e bɔɲɛn yi te ki faɲi bayo Siken bata yi fu Yaxuba a dii tɛmɛn ma, a mi lan a xa naxan liga Isirayila bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Xamori yi a fala e xa, a naxa, “Dii tɛmɛni ito rafanxi n ma dii xɛmɛn Siken nan ma a sɔndɔmɛn birin na. Yandi, ɛ xa a fi a ma, a xa findi a ɲaxanla ra. ");
INSERT INTO yal_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","En findi bitanmane ra. Ɛ xa ɛ dii tɛmɛne fi nxu ma alogo nxu xa e dɔxɔ. Nayi, ɛ fan nɔɛ nɛn nxu gbeene dɔxɛ. ");
INSERT INTO yal_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ɛ fama nɛn ludeni nxu dɛxɔn ma, bɔxɔni ito yi rabi ɛ xa. Ɛ nɔɛ dɔxɛ nɛn be, ɛ yulayaan liga alogo ɛ xa hɛrisigɛn sɔtɔ.” ");
INSERT INTO yal_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Siken yi a fala Dina baba nun a tada xa, a naxa, “Ɛ diɲa n ma, ɛ ɲɛnige faɲin ti n xa. Ɛ wama seen naxan xɔn, ɛ xa na fala n xa, n xa a so ɛ yii. ");
INSERT INTO yal_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ɛ nɔɛ futu se gbegbe maxɔdinɲɛ nɛn n ma e nun kiseene. Ɛ na seen naxan birin maxɔdin n ma, n nɔɛ a birin soɛ ɛ yii nɛn alogo n xa dii tɛmɛni ito dɔxɔ.” ");
INSERT INTO yal_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yaxubaa diine yi yanfa falan ti Siken nun a baba Xamori xa, bayo Siken bata yi e xunyɛn Dina rayagi. ");
INSERT INTO yal_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","E yi a fala e xa, e naxa, “Nxu mi nɔɛ nxu xunyɛ ɲaxalanmaan fiyɛ muxun ma naxan mi banxulanxi. A findima yagin nan na nxu xa. ");
INSERT INTO yal_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Xa nxu fa nxu xuiin soma ɛ yii, fɔ en lan ito ma. Xɛmɛn naxan birin ɛ konni, e lan nɛn e xa banxulan alo nxu tan. ");
INSERT INTO yal_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Na waxatini nxu nɔɛ nxɔ dii tɛmɛne fiyɛ ɛ ma nɛn, ɛ yi e dɔxɔ. Nxu fan ɛ gbeene dɔxɔma nɛn, nxu luma ɛ dɛxɔn ma na waxatini, en birin yi findi yama kedenna ra. ");
INSERT INTO yal_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Koni xa ɛ mi fa sa tin ɛ banxulandeni, nxu nxu xunyɛ ɲaxalanmaan nasuxuma nɛn, nxu fa keli be.” ");
INSERT INTO yal_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Xamori nun a dii Siken yi tin falani ito ma. ");
INSERT INTO yal_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Na xɛmɛn mi bu a na feen liga, bayo Yaxuba a dii tɛmɛn bata rafan a ma. A tan nan yi binyaxi dangu a ngaxakedenne birin na. ");
INSERT INTO yal_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Xamori nun Siken yi siga yamaan malandeni taan so dɛɛn na. E yi a fala e yamaan xa, e naxa, ");
INSERT INTO yal_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Muxuni itoe, en ma fe faɲina e kui. E xa lu bɔxɔni ito ma, e yulayaan liga, bayo en ma bɔxɔn gbo. En nɔɛ nɛn e dii tɛmɛne dɔxɛ, en fan en ma dii tɛmɛne fima e ma nɛn. ");
INSERT INTO yal_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Muxuni itoe mi dɔxɔma be, en xa findi yama kedenna ra, fɔ xɛmɛn naxan birin en konni be yi, ne xa banxulan alo e kiinde. ");
INSERT INTO yal_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Xa en bata tin e falan ma, na waxatini e dɔxɔma en konni nɛn. E xuruseene nun e yii seen birin findima en birin gbeen na nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Muxun naxan birin yi na taan so dɛɛn na na lɔxɔni, e birin yi tin Xamori nun a dii Siken ma falan ma. Xɛmɛn naxan birin yi na taan kui, e birin yi banxulan. ");
INSERT INTO yal_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","A xii saxande lɔxɔni, xɛmɛne fatine to yi e xɔlɔma, Yaxubaa dii xɛmɛ firinna Simeyɔn nun Lewi, Dina tada xɛmɛmane, e yi e dɛgɛmane tongo. E yi fu taan ma muxu yo mi sogin e ma, e yi xɛmɛn birin faxa. ");
INSERT INTO yal_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","E yi Xamori nun a dii Siken fan faxa. E yi Dina tongo Siken konni, e yi fa a ra. ");
INSERT INTO yal_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yaxubaa diine yi seen birin tongo faxa muxune xun ma, bayo e bata yi e xunyɛ ɲaxalanmaan nayagi. ");
INSERT INTO yal_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","E yi e yɛxɛɛne tongo e nun e siine nun e ɲingene nun e sofanle, naxanye yi taan kui e nun xɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Nafunla naxan birin yi na, e yi a birin xali. E yi dii tɛmɛne nun ɲaxanle xali. E banxin birin kui geli. ");
INSERT INTO yal_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaxuba yi a fala Simeyɔn nun Lewi xa, a naxa, “Ɛ bata lanbaranna ti n ma. Ɛ bata en naɲaxu Kanan kaane nun Perisi kaane ma alo se kunxin xirina. Muxu wuyaxi mi n yii. E e malanma nɛn n xili ma, e n yɛngɛ, n xabilan birin yi halagi.” ");
INSERT INTO yal_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","E yi a yabi, e naxa, “A mi lan a xa en xunyɛ ɲaxalanmaan findi yalunden na.” ");
INSERT INTO yal_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ala yi a fala Yaxuba xa, a naxa, “Keli, i sa dɔxɔ Betɛli yi. I saraxa ganden nafala n xa mɛnni, n bata yi n yɛtɛ yita i ra dɛnaxan yi, i yi i gima i tada Esayu bun ma waxatin naxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yaxuba yi a fala a denbayaan xa e nun muxun naxanye yi a fɛma, a naxa, “Ɛ xɔɲɛne suxurene yiba, ɛ ɛ yɛtɛ sariɲan, ɛ ɛ dugine fan masara ɛ ma. ");
INSERT INTO yal_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ɛ fa, en siga Betɛli yi. N xa saraxa ganden nafala Ala xa, naxan n malixi n yi lanbaranni waxatin naxan yi. A yi a yengi lu n xɔn ma n ma sigatini.” ");
INSERT INTO yal_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Na waxatini e yi e suxurene birin so Yaxuba yii e nun e tunla soone. Yaxuba yi e birin bitin konden bun ma naxan Siken dɛxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yaxuba nun a diine to keli sigadeni, Ala yi gaxun lu e rabilin taane birin muxune bɔɲɛni, muxu yo mi susu birɛ e fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaxuba nun a fɔxɔrabirane yi siga Lusi yi, naxan mɔn xili Betɛli, Kanan bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","A yi saraxa ganden nafala mɛnni. A yi na saraxa ganden xili sa “Betɛli a Ala,” bayo Ala a yɛtɛ yita a ra mɛnni nɛn, a yi a gima a tada bun waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rebeka a dii masuxun Debora to faxa, e yi a maluxun Betɛli mabinni wariin dɛnaxan yi. Na wariin xili nɛn “wugadena.” ");
INSERT INTO yal_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ala mɔn yi mini Yaxuba xa, a xɛtɛ xanbini Padan-Arami yi. A yi barakan nagidi a ma. ");
INSERT INTO yal_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ala yi a fala a xa, a naxa, “I xili nɛn Yaxuba, koni a mi falama na kiini sɔnɔn. To xanbi ra, i xinla fa falama nɛn Isirayila.” Awa, Ala yi a xili sa Isirayila. ");
INSERT INTO yal_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","A mɔn yi a fala a xa, a naxa, “Ala Sɛnbɛ Kanna nan n na. I xa wuya, i yiriwa alogo i xa findi siyana nde benban na. I mɔn findima nɛn siya wuyaxine benban na. Mangane minima nɛn i bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","N bɔxɔn naxan fi Iburahima nun Isiyaga ma, n na a fi i fan ma. Na dangu xanbini, n na a fima i bɔnsɔnna fan ma nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ala yi keli na, a falan ti Yaxuba xa dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaxuba yi gɛmɛ taxamasenna ti na, a yi turen nun min seen bɔxɔn a ma saraxan na. ");
INSERT INTO yal_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","A yi yireni ito xili sa Betɛli, Ala falan ti a xa dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yaxuba nun a denbayaan to keli Betɛli yi, e mɔn makuya Efarata ra, Rakeli yi diin sɔtɔ. Na dii bari feen yi xɔdɔxɔ ayi. ");
INSERT INTO yal_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Rakeli yi diin barima waxatin naxan yi xɔlɛni, dii rasuxun yi a fala a xa, a naxa, “Hali i mi gaxu, i mɔn xɛmɛn nan barixi.” ");
INSERT INTO yal_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rakeli bata yi lu alo faxa muxuna. A yi a niin makakama waxatin naxan yi, a yi a diin xili sa Benoni. Koni a baba tan yi a xili sa Bunyamin. ");
INSERT INTO yal_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rakeli to faxa, e yi a maluxun Efarata kiraan dɛxɔn ma. Na yiren xili nɛn iki Bɛtɛlɛmi. ");
INSERT INTO yal_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaxuba yi gɛmɛn sa taxamasenna ra a gaburun fari. Han to na gɛmɛn na Rakeli gaburun taxamasenna ra. ");
INSERT INTO yal_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isirayila yi sa a bubun ti Migidali-Ederi xanbi ra. ");
INSERT INTO yal_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isirayila to yi dɔxi na taani, Rubɛn nun Bila yi sa e sa, a baba konyi ɲaxanla. Isirayila yi a kolon. Isirayila dii xɛmɛn fu nun firinna naxanye sɔtɔ: ");
INSERT INTO yal_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leya yi Rubɛn bari dii saran na, na xanbi ra Simeyɔn nun Lewi nun Yuda nun Isakari nun Sabulon. ");
INSERT INTO yal_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rakeli yi Yusufu nun Bunyamin bari. ");
INSERT INTO yal_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rakeli a konyin Bila yi Nafatali nun Dan bari. ");
INSERT INTO yal_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leyaa konyin Silipa yi Gadi nun Aseri bari. Ne birin findixi Yaxubaa diine nan na, a naxanye sɔtɔ Padan-Arami yi. ");
INSERT INTO yal_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yaxuba yi siga a baba Isiyaga konni Mamire, Kiriyati-Aruba mabinni. Mɛn xili nɛn Xebiron, Iburahima nun Isiyaga dɔxɔde fonna. ");
INSERT INTO yal_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isiyaga a siimayaan yi siga ɲɛɛ kɛmɛ ɲɛɛ tonge solomasɛxɛ. ");
INSERT INTO yal_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","A to faxa, a bata yi siimaya xunkuye sɔtɔ, a yi faxa, a siga laxira yi. A dii Esayu nun Yaxuba yi a maluxun. ");
INSERT INTO yal_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esayu, naxan mɔn xili Edɔn, a bɔnsɔnna taruxun ni i ra. ");
INSERT INTO yal_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esayu Kanan ɲaxanle dɔxɔ nɛn: Ada findi Elon ma diin nan na, Xiti kaana, e nun Yoholibama, Anaa dii tɛmɛna, Sibeyon Xiwin mamandenna nan a ra. ");
INSERT INTO yal_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","A yi Sumayila a dii tɛmɛn Basamati fan dɔxɔ, Nebayoti xunyɛ ɲaxalanmana. ");
INSERT INTO yal_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada nan Elifasi sɔtɔ Esayu xa. Reyuli findi Basamati a diin nan na. ");
INSERT INTO yal_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Yoholibama dii xɛmɛ saxan nan bari: Yewusi nun Yalami e nun Kora. Ne birin findi Esayu a diine nan na naxanye barixi Kanan bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esayu yi a ɲaxanle nun a dii tɛmɛne nun a dii xɛmɛne nun a muxune birin tongo, e nun a xuruseene birin e nun a hɛrisigɛn naxan birin sɔtɔ Kanan bɔxɔni. A yi a birin xali bɔxɔ gbɛtɛn ma dɛnaxan makuya a xunyɛ Yaxuba ra, ");
INSERT INTO yal_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","bayo e hɛrisigɛn bata yi gbo ayi. E mi yi nɔɛ luyɛ e bode dɛxɔn ma. E yi dɛnaxan yi e xuruseene birin mi yi nɔɛ balo sɔtɛ mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Na nan a to Esayu, naxan mɔn xili Edɔn, na yi siga a sa dɔxɔ Seyiri geya yireni. ");
INSERT INTO yal_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Edɔn kaane benba Esayu bɔnsɔnna xinle ni itoe ra naxanye yi dɔxi Seyiri geya yireni: ");
INSERT INTO yal_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esayu a diine ni i ra: Elifasi, Ada a dii xɛmɛna, Reyuli, Basamati a dii xɛmɛna. ");
INSERT INTO yal_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifasi a diine ni ito ra: Teman nun Omaru nun Sefo nun Gatami e nun Kenasi. ");
INSERT INTO yal_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timina nan yi Elifasi a konyi ɲaxanla ra. Na Amalɛki bari nɛn Elifasi xa. Esayu nun a ɲaxanla Ada mamandenne ni ito ra. ");
INSERT INTO yal_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reyuli a diine ni i ra: Naxati nun Sera nun Sama e nun Misa. Ne findi Esayu nun a ɲaxanla Basamati mamandenne nan na. ");
INSERT INTO yal_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esayu a ɲaxanla Yoholibama a diine ni i ra: Yewusi nun Yalami e nun Kora. Yoholibama findi Anaa dii tɛmɛn nan na. Ana findi Sibeyon ma dii tɛmɛn nan na. ");
INSERT INTO yal_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Mangan naxanye keli Esayu bɔnsɔnni, ne ni i ra: Elifasi, Esayu a dii singena, na diine ni itoe ra: Manga Teman nun Manga Omaru nun Manga Sefo nun Manga Kenasi ");
INSERT INTO yal_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","nun Manga Kora nun Manga Gatami nun Manga Amalɛki. Mangane nan yi ne ra naxanye fataxi Elifasi ra Edɔn yamanani, Ada mamandenne nan e ra. ");
INSERT INTO yal_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Reyuli, Esayu a diina, a diine ni i ra: Manga Naxati nun Manga Sera nun Manga Sama e nun Manga Misa. Mangane nan yi ne ra naxanye fataxi Reyuli ra Edɔn yamanani, Basamati mamandenne nan e ra. ");
INSERT INTO yal_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Yoholibama, Esayu a ɲaxanla, a diine ni itoe ra: Manga Yewusi nun Manga Yalami nun Manga Kora. Mangane ni itoe ra naxanye fataxi Yoholibama ra, Esayu a ɲaxanla: Yoholibama findi Anaa diin nan na. ");
INSERT INTO yal_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Esayu, naxan mɔn xili Edɔn, na a diine nan ne ra. Mangan naxanye keli Esayu bɔnsɔnni, ne nan ne ra. ");
INSERT INTO yal_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seyiri Xori kaana diine ni itoe ra naxanye yi dɔxi na yamanani: Lotan nun Sobali nun Sibeyon nun Ana ");
INSERT INTO yal_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","nun Dison nun Eseri e nun Disan. Seyiri a diine yi findi Xori mangane ra Edɔn yamanani. ");
INSERT INTO yal_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan ma dii xɛmɛne ni itoe ra: Xori nun Heman. Timina findi Lotan xunyɛ dii tɛmɛn nan na. ");
INSERT INTO yal_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobali a dii xɛmɛne ni itoe ra: Aliban nun Manaxati nun Ebali nun Sefo e nun Onan. ");
INSERT INTO yal_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeyon ma dii xɛmɛne ni ito ra: Aya nun Ana, Ana nan tigi wolonxine to tonbon yireni a to yi Sibeyon ma sofanle rabama. ");
INSERT INTO yal_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana a diine ni itoe ra: Dison nun Yoholibama, Ana a dii tɛmɛna. ");
INSERT INTO yal_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison ma dii xɛmɛne ni itoe ra: Xemadan nun Eseban nun Itiran e nun Keran. ");
INSERT INTO yal_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eseri a dii xɛmɛne ni itoe ra: Bilihan nun Saawan e nun Akan. ");
INSERT INTO yal_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan ma dii xɛmɛne ni itoe ra: Yusu nun Aran. ");
INSERT INTO yal_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Xori kaane mangane ni i ra: Manga Lotan nun Manga Sobali nun Manga Sibeyon nun Manga Ana ");
INSERT INTO yal_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","nun Manga Dison nun Manga Eseri e nun Manga Disan. Xori kaane Mangane findi ne nan na e bɔnsɔn yɛɛn ma Seyiri bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Mangane nan itoe ra naxanye yi Edɔn yamanan xun na benun Isirayila kaane xa mangan dɔxɔ waxatin naxan yi: ");
INSERT INTO yal_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beyori a diin Bela yi findi Edɔn manga singen na, naxan ma taan yi xili Dinhaba. ");
INSERT INTO yal_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela to faxa, Seraa diin Yobabo, Bosara kaan yi findi mangan na. ");
INSERT INTO yal_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabo to faxa, Xusama, naxan yi kelixi Teman yamanani, na yi findi mangan na. ");
INSERT INTO yal_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Xusama to faxa, Bedadaa diin Xadada yi findi mangan na. A tan nan Midiyan kaane nɔ Moyaba bɔxɔni. A taan yi xili nɛn Abiti. ");
INSERT INTO yal_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Xadada to faxa, Samala Masareka kaan yi findi mangan na. ");
INSERT INTO yal_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samala to faxa, Sayuli naxan yi kelixi Rehoboti taani baan dɛ, na yi findi mangan na. ");
INSERT INTO yal_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sayuli to faxa, Akibori a diin Baali-Xanan yi findi mangan na. ");
INSERT INTO yal_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baali-Xanan, Akibori a diin to faxa, Xadada yi findi mangan na. A taan yi xili nɛn Pawu. A ɲaxanla yi xili nɛn Mehetabeli, Matirɛdi a dii tɛmɛna, Mesahabi mamandenna. ");
INSERT INTO yal_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Mangane ni i ra naxanye kelixi Esayu bɔnsɔnni, e bɔnsɔnna nun e yamanan yɛɛn ma. Manga Timina nun Manga Aliwa nun Manga Yetɛti ");
INSERT INTO yal_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","nun Manga Yoholibama nun Manga Ela nun Manga Pinon ");
INSERT INTO yal_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","nun Manga Kenasi nun Manga Teman nun Manga Mibisari ");
INSERT INTO yal_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","nun Manga Magadiyɛli nun Manga Irami. Ne nan yi Edɔn mangane ra e nun e bɔxɔna e yi dɔxi dɛnaxan yi. Esayu a feen nan na ra naxan findixi Edɔn kaane benban na. ");
INSERT INTO yal_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaxuba dɔxɔ nɛn Kanan yamanani, a baba yi dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yaxuba bɔnsɔnne taruxun ni ito ra. Yusufu a dii ɲɔrɛyaan ɲɛɛ fu nun solofere nan yi a ra. A tan nun a tadane yi xuruseene nan kantanma, naxanye nga yi Bila nun Silipa ra, a babaa ɲaxanle. A yi e fe ɲaxine dɛntɛgɛn sama a baba xa. ");
INSERT INTO yal_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yusufu nan yi rafan Isirayila ma dangu a diine birin na, bayo a tan nan sɔtɔ a xɛmɛ foriyani. A yi doma kuye tofaɲin so a yii. ");
INSERT INTO yal_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yusufu tadane to na feen to, a a tan nan nafan e baba ma dangu e birin na, e yi a raɲaxu. Fala faɲi yo mi yi e tagi sɔnɔn. ");
INSERT INTO yal_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yusufu yi xiye sa, a yi a yɛba a tadane xa. E yi a raɲaxu dangu a fɔlɔn na. ");
INSERT INTO yal_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","A yi a fala e xa, a naxa, “Ɛ tuli mati n ma xiyen na, n naxan saxi. ");
INSERT INTO yal_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","En birin yi xɛɛn ma malo raxidideni. Nanunna, n ma malo xidin yi keli, a ti. Ɛ gbee malo xidine yi lu bilinxi n gbee xidin na, e birin yi e xinbi sin n ma malo xidin bun.” ");
INSERT INTO yal_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","A tadane yi a maxɔdin, e naxa, “Ee! I waxi findi feni nxɔ mangan nan na alogo i xa nxu yamari?” E yi a raɲaxu dangu a fɔlɔn na a xiyena fe ra e nun a falana. ");
INSERT INTO yal_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yusufu mɔn yi xiye gbɛtɛ sa, a yi na fan yɛba a tadane xa. A yi a fala, a naxa, “Ɛ ɛ tuli mati, n mɔn bata xiye sa. Sogen nun kiken nun sare fu nun keden yi e xinbi sinma n bun ma.” ");
INSERT INTO yal_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A yi xiyeni ito yɛba a baba nun a tadane xa. A baba yi a kɔnkɔ a ma, a fa a fala a xa, a naxa, “I xiyen naxan saxi iki, nanse na ra? I nga nun i tadane nun n tan, nxu birin fama nxu xinbi sindeni i yɛtagi?” ");
INSERT INTO yal_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","A tadane yi lu a maxɔxɔlɔnɲɛ, koni a baba yi a yengi lu a xiyen xɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Yusufu tadane yi siga Siken yi e babaa xurusene rabadeni. ");
INSERT INTO yal_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isirayila yi a fala Yusufu xa, a naxa, “I tadane bata siga xuruse rabadeni Siken yi. Fa be, n xa i xɛ e ma.” A yi a yabi, a naxa, “Awa.” ");
INSERT INTO yal_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Isirayila yi a fala a xa, a naxa, “Siga mafurɛn, i sa a mato xa i tadane kɛndɛ, xa se mi xuruseene fan toxi, i yi fa na dɛntɛgɛn sa n xa.” A yi a xɛ keli Xebiron lanbanni siga Siken yi. ");
INSERT INTO yal_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Xɛmɛna nde yi a to xɛɛne xun xɔn. Xɛmɛn yi a maxɔdin, a naxa, “I nanse fenma?” ");
INSERT INTO yal_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","A yi a yabi, a naxa, “N na n tadane nan fenma. A fala n xa, yandi, e xurusene rabama dɛnaxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Xɛmɛn yi a fala a xa, a naxa, “E bata keli be, bayo n na e xuiin mɛ nɛn, e yi a falama, a e xa siga Dotan yi.” Yusufu yi bira a tadane funfu xɔn han a sa a tadane li Dotan yi. ");
INSERT INTO yal_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","E to a to wulani, benun a xa maso e ra, e lan a ma, a e xa a faxa. ");
INSERT INTO yal_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","E yi a fala e bode xa, e naxa, “Na xiye saan nan fama iki. ");
INSERT INTO yal_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ɛ fa be, en na a faxa, en na a woli xɔɲinna ra. Nayi, en na keli, en na a falama nɛn, a sube ɲaxin bata a don. Na waxatini en fama a kolondeni nɛn a xiyen findima a xa feen naxan na.” ");
INSERT INTO yal_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubɛn yi na feen mɛ. A yi kata a xa a xunba, a naxa, “En nama a faxa.” ");
INSERT INTO yal_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Rubɛn mɔn yi a fala, a naxa, “Ɛ nama a wunla ramini de! Ɛ a woli xɔɲinni ito ra naxan tonbon yireni ito yi. Muxu yo nama a yiin din a ra.” A yi wama a xunba feni alogo a xa nɔ a xalideni a baba fɛma. ");
INSERT INTO yal_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusufu to so a tadane yireni, a doma kuye tofaɲin naxan yi ragodoxi a ma, e yi na rate a ma. ");
INSERT INTO yal_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","E yi Yusufu tongo, e a woli xɔɲinna ra, ige mi naxan kui. ");
INSERT INTO yal_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Na xanbi, e yi dɔxɔ donse dondeni. E to e yɛɛn nakeli, e yi Sumayila bɔnsɔnna yulane to fɛ. E yi kelixi Galadi yi, wusulanna nun senna nun latikɔnɔnna yi e ɲɔgɔmɛne fari siga Misiran yi. ");
INSERT INTO yal_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda yi a fala a xunyɛne xa, a naxa, “Xa en na en xunyɛn faxa, en yi a wunla luxun, na tɔnɔn mundun en tan ma? ");
INSERT INTO yal_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ɛ fa, en na a mati Sumayila bɔnsɔnna muxune ma, koni en nama en yiin din a ra de! Bayo en xunyɛn na a ra, en wuli keden fasa keden.” A xunyɛne birin yi tin a falan ma. ");
INSERT INTO yal_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Na xanbi, Midiyan yulane danguma, e yi Yusufu rate xɔɲinna ra. E yi Yusufu mati gbeti gbanan mɔxɔɲɛ ra Sumayila bɔnsɔnna muxune ma. E yi a xali Misiran yi. ");
INSERT INTO yal_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubɛn to xɛtɛ xɔɲinna yireni, a mi Yusufu li na sɔnɔn. A yi a domaan birin yibɔ sununi. ");
INSERT INTO yal_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","A yi xɛtɛ a xunyɛne fɛma, a yi a fala, a naxa, “Diidin mi fa na! N tan fa nanse ligama sɔnɔn?” ");
INSERT INTO yal_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","E yi kɔtɔ keden faxa, e yi Yusufu a doma kuye tofaɲin maturuxun na sube wunli. ");
INSERT INTO yal_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Na xanbi, e yi na doma kuye tofaɲin xali e baba fɛma. E yi a fala a xa, e naxa, “Nxu bata ito to. Domani ito mato ba, xa i ya diin gbeen na a ra.” ");
INSERT INTO yal_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yaxuba yi domaan kolon. A yi a fala, a naxa, “N ma diina domaan na a ra! Sube xaɲɛna nde bata a faxa! A bata Yusufu yibɔ!” ");
INSERT INTO yal_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yaxuba yi a dugine yibɔ sununi, a mɔn yi kasa dugin nagodo a ma. A yi a diin ɲan feen liga xii wuyaxi. ");
INSERT INTO yal_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A dii xɛmɛne nun dii tɛmɛne yi siga a madɛndɛndeni, koni a mi tin na ma. A yi a fala, a naxa, “N nan n ma diin saya feen ligama nɛn han n sa a li laxira yi.” A yi lu wugɛ a diina fe ra. ");
INSERT INTO yal_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Midiyan kaane yi Yusufu mati Potifari ma Misiran yi, Misiran Mangana kuntigina nde naxan a kantan tiine xunna. ");
INSERT INTO yal_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Na waxatini, Yuda yi keli a ngaxakedenne xun ma, a siga Adulan kaana nde konni naxan xili Xira. ");
INSERT INTO yal_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yuda yi Suya Kanan kaana dii tɛmɛn to mɛnni. A yi a findi a ɲaxanla ra. E yi lu e bode xɔn. ");
INSERT INTO yal_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","A yi fudikan, a yi dii xɛmɛn bari. E yi na diin xili sa Eri. ");
INSERT INTO yal_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","A mɔn yi fudikan dii firinden na, a yi dii xɛmɛn bari. E yi na diin xili sa Onan. ");
INSERT INTO yal_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Na xanbi, a mɔn yi dii xɛmɛ gbɛtɛ bari, a yi na xili sa Selaxa. Yuda yi Kesibe taan nin a ɲaxanla yi diin barima waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda yi ɲaxanla fen, a a so a dii singen Eri yii. Na ɲaxanla xili Tamari. ");
INSERT INTO yal_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Muxu ɲaxin nan yi Yudaa dii singen Eri ra Alatala yɛɛ ra yi. Alatala yi a faxa. ");
INSERT INTO yal_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Na xanbi Yuda yi a fala Onan xa, a naxa, “I tadaa ɲaxanla tongo, a xa findi i ya ɲaxanla ra. I a xɛmɛ xuriya wanla liga alogo i xa diin fi i tada faxa muxun ma.” ");
INSERT INTO yal_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Koni Onan yi a kolon, a na diin mi yi findɛ a gbeen na. Na nan a liga, a to yi a tada ɲaxanla kolonma ɲaxanla ra, igen naxan minima a fatini, a yi na makala bɔxɔn ma alogo a nama diin bari a tada xa. ");
INSERT INTO yal_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","A yi naxan ligama, na mi yi rafan Alatala ma. Nanara, a yi a faxa. ");
INSERT INTO yal_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Awa, Yuda yi a fala a mamuxun Tamari xa, a naxa, “Lu kaɲayani i baba konni benun n ma dii Selaxa xa gbo waxatin naxan yi.” A yi mirixi nɛn yanyina nde Selaxa fan faxama nɛn alo a tadane faxaxi kii naxan yi. Tamari yi siga a sa lu a baba konni. ");
INSERT INTO yal_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","A mi bu Suya a dii tɛmɛna, Yudaa ɲaxanla yi faxa. Ɲan feen to ba a ra, Yuda yi siga Timana yi e nun a lanfaan Xira Adulan kaana. E yi siga Yuda xuruse yireni, e yi e xabene maxabama dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Muxuna nde yi a fala Tamari xa, a naxa, “I taɲe sigama Timana taani a xurusene xabene maxabadeni.” ");
INSERT INTO yal_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","A yi a kaɲa dugine ba a ma, a yi dugin so a yɛtagin xun na, a sa dɔxɔ Enayin taan so dɛɛn na Timana kiraan xɔn. A bata yi a to Selaxa bata findi banxulanna ra, koni e mi a fi a ma a xa findi a ɲaxanla ra. ");
INSERT INTO yal_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda to a to a dugin soxi a yɛtagin xun na, a yi a miri a yalunden na a ra. ");
INSERT INTO yal_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","A yi a fala a xa kiraan na, a naxa, “En siga, en sa kafu.” A mi yi a kolon a mamuxun na a ra. Koni, Tamari yi Yuda maxɔdin, a naxa, “I nanse fima n ma en na kafu?” ");
INSERT INTO yal_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","A yi a yabi, a naxa, “N sii keden nan tongoma n ma xuruseene tagi, n fa a ra i yɛɛ ra.” A yi a yabi, a naxa, “Awa, tolimana nde lu n yii be singe benun i xa fa siin na waxatin naxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","A yi a maxɔdin, a naxa, “I wama n xa nanse so i yii tolimaan na?” Tamari yi a yabi, a naxa, “I ya taxamasenna nun a lutin nun i ya dunganna so n yii.” A yi na seene so a yii, e fa kafu. Tamari yi fudikan a diin na. ");
INSERT INTO yal_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","A yi xɛtɛ a konni. A yi dugin ba a yɛtagin xun na, a mɔn yi a kaɲa domaan nagodo a ma. ");
INSERT INTO yal_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda yi a lanfa Adulan kaan xɛ sii diin tideni ɲaxanla ma alogo a xa fa seene ra a naxanye so ɲaxanla yii tolimaan na. Koni a mi ɲaxanla to. ");
INSERT INTO yal_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","A yi mɛn kaane maxɔdin, a naxa, “Yalunde ɲaxanla naxan yi kiraan dɛ Enayin taani, na minɛn yi?” E yi a yabi, e naxa, “Yalunde yo mi be.” ");
INSERT INTO yal_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","A yi xɛtɛ Yuda yireni, a fa a fala, a naxa, “N mi a lixi na. Mɛn kaane mɔn bata a fala n xa a yalunde yo mi na e tan konni.” ");
INSERT INTO yal_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda yi a fala, a naxa, “A xa na seene mara. En fan nama en yɛtɛ rayagi. N bata sii diin nasanba a ma, koni i mi a lixi na.” ");
INSERT INTO yal_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kike saxan dangu xanbi, muxuna nde yi a fala Yuda xa, a naxa, “I mamuxun Tamari bata findi yalunden na, a bata fudikan a yalunyani.” Yuda yi a fala, a naxa, “Ɛ a ramini, a gan.” ");
INSERT INTO yal_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","E yi fama a ra waxatin naxan yi, a yi xɛraan nasiga a taɲe ma, a naxa, “Seni itoe mato naxanye n yii. Taxamasenni ito nun a lutin nun dunganni ito na findi muxun naxan gbee ra na nan n nafudikanxi. I lan nɛn i xa a kanna kolon.” ");
INSERT INTO yal_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda yi na feene kolon. A yi a fala, a naxa, “A tinxin dangu n tan na bayo n mi a fixi n ma dii Selaxa ma.” Na xanbi ra, e mi fa kafu. ");
INSERT INTO yal_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","A yi diin barima waxatin naxan yi, e yi a kolon a gulunne nan a kui. ");
INSERT INTO yal_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Diin bari waxatini, keden yi a yiin namini. Dii rasuxun yi a yiin suxu, a gari gbeela xidi a yiin na. A fa a fala, a naxa, “Ito nan singe barixi.” ");
INSERT INTO yal_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Koni na diin yi a yiin naso, a xunyɛn yi bari. Dii rasuxun yi a fala, a naxa, “I yɛtɛ raminixi fangan mundun na iki?” A yi a xili sa Peresi. ");
INSERT INTO yal_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Na xanbi boden fan yi bari gari gbeela xidixi a yiin na. Yuda yi a xili sa Sera. ");
INSERT INTO yal_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Sumayila bɔnsɔnna muxune yi siga Yusufu ra Misiran yamanani. Potifari, Misiran Mangan kantan tiine xunna yi a sara. ");
INSERT INTO yal_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Alatala yi Yusufu xɔn. A yi feen naxanye birin suxuma, ayi birin gasama. A yi lu a kanna Misiran kaan konni. ");
INSERT INTO yal_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","A kanna yi a kolon, a Alatala yi Yusufu xɔn, bayo Alatala bata yi a feen birin nasɔnɔya. ");
INSERT INTO yal_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yusufu yi rafan a kanna ma, a yi a findi a banxi xunna ra. A yi a hɛrisigɛn birin taxu a ra. ");
INSERT INTO yal_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Na xanbi Yusufu to findi a banxi xunna ra e nun a yii seene birin, Alatala yi barakan sa Misiran kaana denbayani Yusufu a fe ra. Alatala yi barakan sa a yii seene birin yi, e nun a banxin nun a xɛɛne. ");
INSERT INTO yal_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Nanara, seen naxanye birin yi Potifari yii, a yi a birin nabeɲin Yusufu yii. A tan mi yi fa a yengi saxi fefe xɔn ma fɔ a yi donseen naxan donma. Yusufu yi tofan han. ");
INSERT INTO yal_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Na feene danguxina, a kanna ɲaxanla yi a yɛɛn ti Yusufu ra. A yi a fala a xa, a naxa, “Fa be, en fa kafu.” ");
INSERT INTO yal_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yusufu yi tondi, a a fala a kanna ɲaxanla xa, a naxa, “Xabu n fa n kanna konni a mi a yengi luxi fefe xɔn ma sɔnɔn a banxini. A bata a yii seene birin taxu n na. ");
INSERT INTO yal_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","A banxin kui be, n tan nan dangu muxun birin na. A mi sese rafisaxi n xa, fɔ i kedenna, bayo i tan bata findi a ɲaxanla ra. Iki, n fe ɲaxi gbee sifani ito ligama nanfera naxan findɛ yulubi feen na Ala yii?” ");
INSERT INTO yal_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Na ɲaxanla yi na falama Yusufu xa lɔxɔ yo lɔxɔ. Koni hali na, Yusufu mi yi a tuli matima e kafu feen miriyaan na. ");
INSERT INTO yal_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lɔxɔna nde, Yusufu yi so banxini wali kɛdeni. Banxi kui konyi yo mi yi na na waxatini. ");
INSERT INTO yal_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Na ɲaxanla yi dutun a domaan ma. A yi a fala a xa, a naxa, “En kafu!” Yusufu yi a ba a domani, a yi a lu ɲaxanla yii. A yi mini a giyɛ tandeni. ");
INSERT INTO yal_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ɲaxanla to a to a bata a gi, a a domaan lu a yii, a mini tanden ma, ");
INSERT INTO yal_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","a yi a banxi kui konyine xili, a fa a fala e xa, a naxa, “Ɛ ito mato, n ma xɛmɛn faxi Heburu nan na a xa fa sabaan so en na. A faxi nɛn n fɛma a nxu xa kafu, koni n yi sɔnxɔn nate. ");
INSERT INTO yal_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","A to n sɔnxɔ xuiin mɛ, a yi a gi, a a domaan lu n dɛxɔn ma. A yi mini a giyɛ tandeni.” ");
INSERT INTO yal_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","A yi Yusufu a domaan namara han a kanna fa waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","A yi feni ito yɛba a xa, a naxa, “I faxi Heburu konyi xɛmɛn naxan na, a faxi nɛn a xa sabaan so n na. ");
INSERT INTO yal_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Koni n to sɔnxɔn nate, a yi a domaan lu n yii, a yi mini a giyɛ tandeni.” ");
INSERT INTO yal_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yusufu kanna to a ɲaxanla falan mɛ, a yi naxan falama a xa iki, a naxa, “A mato, i ya konyin naxan nabaxi n na,” ");
INSERT INTO yal_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","a bɔɲɛn yi te, a xɔlɔ. A yi Yusufu balan mangana kasorasane yi dɛnaxan yi. Koni kasoon na, ");
INSERT INTO yal_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Alatala yi lu Yusufu xɔn ma, a hinan a ra. A yi a ragidi Yusufu ma e nun kaso mangan yi dɛ fan. ");
INSERT INTO yal_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kaso mangan yi kasorasaan birin taxu Yusufu ra. Feen naxan birin yi ligama a yi danguma a tan nan yii. ");
INSERT INTO yal_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kaso mangan mi yi Yusufu a wanla xun matoma a ra, bayo Alatala yi Yusufu xɔn ma. A bata yi a feen birin nasɔnɔya. ");
INSERT INTO yal_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Na xanbi, Misiran Mangana muxun naxan yengi dɔxi a minseen xɔn ma, na nun a buru ganna yi e kanna Misiran Mangan hakɛn tongo. ");
INSERT INTO yal_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Misiran Mangan yi xɔlɔ a banxi kui konyin firinne ma, naxan yengi saxi a minseen xɔn ma e nun naxan a burun ganma. ");
INSERT INTO yal_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","A yi e suxu, a e balan sofane mangana kaso banxini, Yusufu yi dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Sofane mangan yi e taxu Yusufu ra, naxan yi walima e yii. E to waxati ti kasoon na, ");
INSERT INTO yal_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","naxan yengi saxi mangana minseen xɔn ma, e nun naxan burun ganma Misiran mangan xa, e yi xiye sa kasoni kɔɛna nde ra. Na xiye firinna birin nun a bun. ");
INSERT INTO yal_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yusufu yi fa e matodeni xɔtɔnni, a yi e li kuisanxi. ");
INSERT INTO yal_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","A yi Misiran Mangana banxi kui konyini itoe maxɔdin naxanye fan yi kasoni, a naxa, “Nanfera ɛ kuisanxi to?” ");
INSERT INTO yal_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","E yi a yabi, e naxa, “Nxu bata xiyena nde nan sa, koni muxu yo mi be naxan nɔɛ na yɛbɛ.” Yusufu yi a fala e xa, a naxa, “Ɛ mi a kolon Ala nan xiyene bunne kanna ra? Ɛ ɛ xiyene fala n xa.” ");
INSERT INTO yal_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Naxan yengi yi saxi mangana minseen xɔn ma, na yi a xiyen fala Yusufu xa, a naxa, “N tan ma xiyeni, n manpa binla nan to, a tixi n yɛtagi alo ɲaxundan binla, ");
INSERT INTO yal_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","a yii saxan tixi a ma. A to fuga, a fugen yi bogi mɔxine ramini alo ɲaxundan tɔnsɔnne. ");
INSERT INTO yal_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Misiran Mangana igelengenna suxi n yii. N yi manpa bogi mɔxine ba, n yi e bundu Misiran Mangana igelengenna kui, n fa a so a yii.” ");
INSERT INTO yal_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu yi a fala a xa, a naxa, “A bunna ni ito ra: Na yii saxanna naxanye na kiini a xii saxan nan yitaxi. ");
INSERT INTO yal_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Xii saxan na dangu, Misiran Mangana i xunnakelima nɛn, a mɔn yi i raxɛtɛ i ya walide fonni. I mɔn fama nɛn igelengenna sodeni Misiran Mangan yii alo i darixi a ra kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Koni i ɲɔxɔ lu n xɔn ma i na hɛrin sɔtɔ waxatin naxan yi. I xa hinan n na, i xa n ma fe fala Misiran Mangan xa alogo n xa mini kasoni. ");
INSERT INTO yal_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bayo e n tongoxi fangan nan na Heburu bɔxɔni. Be fan, n mi fefe ligaxi naxan a ligɛ n xa kasoon sɔtɔ.” ");
INSERT INTO yal_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Naxan burun ganma mangan xa, a to a to fa fala xiyen bunna fan, a yi a fala Yusufu xa, a naxa, “N tan fan xiye saxi nɛn. Debe saxan dɔxi n xun ma buru fixɛna e kui. ");
INSERT INTO yal_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Deben naxan dɔxi a fari, buru ganna donseen naxan birin nafalama Misiran Mangan xa, ne a kui. Koni xɔline yi fa na donseen donɲɛ naxan dɔxi n xun ma.” ");
INSERT INTO yal_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu yi a fala a xa, a naxa, “Xiyen bunna ni ito ra: Na debe saxanna naxan na kiini, e xii saxan nan yitaxi. ");
INSERT INTO yal_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Xii saxan na dangu, Misiran Mangana i xunna sɛgɛma nɛn i dɛ. A i singanma nɛn wudin na, xɔline yi i suben don.” ");
INSERT INTO yal_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Xii saxande lɔxɔni, Misiran Mangan bari lɔxɔni, a yi sumun belebele yitɔn a kuntigine xa. Naxan yengi saxi mangana minseen xɔn ma, e nun a buru ganna, Misiran Mangan yi e ramini kasoon na, a fa e ra kuntigine yɛtagi. ");
INSERT INTO yal_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Naxan yengi saxi minseen xɔn ma, a yi na raxɛtɛ a walide fonni alogo a mɔn xa minseen so a yii. ");
INSERT INTO yal_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Koni a yi a buru ganna singan wudin na alo Yusufu bata yi a yɛba kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Naxan yengi saxi minse feen xɔn ma, Yusufu a fe mi rabira na ma. A yi ɲinan a xɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ɲɛɛ firin dangu xanbi, Misiran Mangan yi xiye sa. A tixi xude dɛni. ");
INSERT INTO yal_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A yi ɲinge to faɲi tuyanxi solofere to kelɛ xuden kui, e e dɛgema mɛrɛni. ");
INSERT INTO yal_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Na xanbi, ɲinge solofere gbɛtɛ, naxanye to ɲaxu, e doyenxi, ne fan yi keli xuden kui ɲingen bonne dɛxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ɲinge to ɲaxi doyenxi solofereni itoe yi ɲinge to faɲi tuyanxi solofereni itoe don. Nayi, Misiran Mangan yi xulun. ");
INSERT INTO yal_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A mɔn yi xi, a xiye gbɛtɛ sa. ");
INSERT INTO yal_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Tɔnsɔn solofere faɲi rafexine tixi bili kedenna ma. ");
INSERT INTO yal_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Na xanbi, tɔnsɔn solofere gbɛtɛ, naxanye xurun, foyen bata e rafofo ayi, ne tixi tɔnsɔnna bodene dɛxɔn ma. Tɔnsɔn xurunni itoe yi tɔnsɔn nafexi faɲine gerun. Nayi, Misiran Mangan yi xulun. Xiyen nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Xɔtɔnni Misiran Mangan bɔɲɛn yi mini. A yi woyimɛne nun fekolonne birin xili naxanye Misiran yi. A yi xiyeni itoe fala e xa, koni muxu yo mi nɔ xiyene yɛbɛ a xa. ");
INSERT INTO yal_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Na waxatini, naxan yengi saxi mangana minseen xɔn ma, na yi a fala Misiran Mangan xa, a naxa, “N ma kala fonne bata rabira n ma to. ");
INSERT INTO yal_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Misiran Mangan xɔlɔ nɛn a konyine ma waxatina nde yi. A yi n suxu, a n balan sofa mangana kasoon na, nxu nun naxan yi burun ganma mangan xa. ");
INSERT INTO yal_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","A tan nun n tan, nxu birin xiye sa nɛn kɔɛ kedenna ra, xiye firinna birin nun a bun. ");
INSERT INTO yal_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kasoni, nxu nun sofa mangana konyina, Heburu banxulanna nan yi na yi. Nxu yi xiyeni itoe fala a xa, a yi e birin bunna fala nxu xa. Nxu xiyen naxanye saxi, a yi e bunne fala nxu xa. ");
INSERT INTO yal_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","A xiyen yɛba nxu xa kii naxan yi, a mɔn birin ligaxi na kiini nɛn. Misiran Mangan bata n naxɛtɛ n walide fonni. A yi boden fan singan wudin na.” ");
INSERT INTO yal_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Misiran Mangan yi Yusufu xili. E yi a ramini kasoni mafurɛn! A yi a xunna bi, a marabɛri baane yi masara a ma. A fa siga Misiran Mangan fɛma. ");
INSERT INTO yal_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Misiran Mangan yi a fala Yusufu xa, a naxa, “N bata xiye sa. Muxu yo mi nɔxi a yɛbadeni, koni n bata a mɛ a i tan nɔɛ xiyen bunna falɛ, naxan na fala i xa.” ");
INSERT INTO yal_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu yi Misiran Mangan yabi, a naxa, “N tan mi a ra, Ala nan Misiran Mangana a xiyen bun faɲin fima a ma.” ");
INSERT INTO yal_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Misiran Mangan yi a fala Yusufu xa, a naxa, “N xiyeni, n yi tixi xude dɛɛn nin. ");
INSERT INTO yal_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","N yi ɲinge to faɲi tuyanxi solofere to kelɛ xuden kui, e e dɛgema mɛrɛni. ");
INSERT INTO yal_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Nayi, ɲinge solofere gbɛtɛye yi te e xanbi ra, e doyenxi, e to ɲaxu, e xɔsixi. Han to n munma yi na ɲinge to ɲaxi sifan to Misiran bɔxɔn birin ma singen. ");
INSERT INTO yal_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ɲinge xɔsixi to ɲaxine yi ɲinge tuyanxi solofere singene don. ");
INSERT INTO yal_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Koni na xanbi, muxu yo mi nɔɛ a kolonɲɛ xa e bata e don, masɔtɔ e doyen kiin ma mɔn. Nayi, n yi xulun.” ");
INSERT INTO yal_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“N mɔn yi xiye gbɛtɛ sa. Tɔnsɔn nafexi faɲi solofere tixi bili kedenna ma. ");
INSERT INTO yal_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Na xanbi tɔnsɔn solofere gbɛtɛye naxanye xurun, foyen naxanye rafofoxi ayi, ne yi te bodene dɛxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Tɔnsɔn fofone yi tɔnsɔn faɲi soloferene gerun. N bata a fala woyimɛne xa, koni muxu yo mi nɔxi a yɛbadeni n xa.” ");
INSERT INTO yal_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yusufu yi a fala Misiran Mangan xa, a naxa, “I ya xiye firinna birin fe kedenna nan yitaxi. Ala bata i rakolon feen ma a fama naxan ligadeni. ");
INSERT INTO yal_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Na ɲinge to faɲi soloferene nun tɔnsɔn faɲi soloferene, ne ɲɛɛ solofere nan yitaxi na kiini. Xiye keden nan a ra. ");
INSERT INTO yal_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ɲinge xɔsixi to ɲaxi soloferene nun tɔnsɔn fofo soloferene foyen naxanye rafofoxi ayi, ne fan ɲɛɛ solofere fitina kamɛn nan yitaxi. ");
INSERT INTO yal_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","N na a falaxi i xa kii naxan yi, Ala bata na feene yita Misiran Mangan na a fama naxanye ligadeni. ");
INSERT INTO yal_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ɲɛɛ soloferen naxanye fama iki, a findima lugo ɲɛɛne nan na Misiran bɔxɔn xa. ");
INSERT INTO yal_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Na xanbi, ɲɛɛ solofere kamɛn fama nɛn, en ɲinanma nɛn na lugon birin na. Kamɛn Misiran bɔxɔn halagima nɛn. ");
INSERT INTO yal_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Fitina kamɛn findima fe magaxuxin nan na, han muxune birin yi ɲinan lugo ɲɛɛne xɔn bɔxɔni ito yi.” ");
INSERT INTO yal_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“I xiyeni ito saxi nɛn dɔxɔɲa yi firin bayo Ala bata a feen nagidi, a mɔn mi buma a ligadeni. ");
INSERT INTO yal_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Iki mangana, xaxilimaan fen, fe kolonna, i yi a dɔxɔ Misiran bɔxɔn xun na. ");
INSERT INTO yal_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mangana, i xa muxune sugandi naxanye dɔxɔma na wanla xun na lugo ɲɛɛ soloferen bun ma. Se xaba waxatin na a li, naxan yo na maala xidi naanin xaba, a suulundena, a xa fa na ra, a ramara. ");
INSERT INTO yal_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","E xa donseene birin malan lugo ɲɛɛ solofere famatɔɔn bun, e xa a ramara taane kui, Misiran Mangana nɔɔn bun ma. ");
INSERT INTO yal_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Donse maraxini ito fama Misiran bɔxɔn natangadeni kamɛn ma nɛn naxan fama ɲɛɛ soloferen bun ma.” ");
INSERT INTO yal_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Falani ito yi rafan Misiran Mangan nun a kuntigine birin ma. ");
INSERT INTO yal_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Misiran Mangan yi a fala e xa, a naxa, “En nɔɛ muxuna nde sɔtɛ naxan ligaxi alo ito, Alaa Nii Sariɲanxin naxan yi?” ");
INSERT INTO yal_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Misiran Mangan yi a fala Yusufu xa, a naxa, “Bayo Ala bata na feen birin yita i ra, muxu yo mi na naxan xaxili fan alo i tan, naxan fe kolon dangu i ra. ");
INSERT INTO yal_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","I tan nan fama findideni n ma banxi xunna ra. N ma yamaan fama biradeni i ya yamarin nan fɔxɔ ra. N ma manga gbɛdɛn nan tun luma i xun na.” ");
INSERT INTO yal_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Misiran Mangan mɔn yi a fala Yusufu xa, a naxa, “A mato, n bata nɔɔn so i yii Misiran bɔxɔn birin xunna.” ");
INSERT INTO yal_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","A yi a gbeti wuredin ba a yiin na, a yi a so Yusufu yiin na. A yi a marabɛri ba taa dugi faɲin na. A yi xɛma ɲɛrɛn bira a kɔɛ ra. ");
INSERT INTO yal_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A yi a rate sofa wontoron kui, naxan Misiran Mangan wontoron xanbi ra. E yi lu sarinɲɛ a yɛɛ ra, e naxa, “Ɛ xinbi sin!” Misiran mangana a mangayaan taxu a ra na kii nin. ");
INSERT INTO yal_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Misiran Mangan mɔn yi a fala Yusufu xa, a naxa, “N tan nan mangan na. Xa i mi yamarin fi naxan ma, fefe mi ligɛ Misiran bɔxɔ yo ma.” ");
INSERT INTO yal_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Misiran Mangan yi Yusufu xili sa Safanati-Paniya. A yi Potifari a dii tɛmɛna Asenati fi a ma a ɲaxanla ra. Hon taana saraxaraliin nan yi Potifari ra. Yusufu yi xun matoon fɔlɔ Misiran bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu barin bata yi ɲɛɛ tonge saxan ti nun a fa Misiran Mangan yɛtagi waxatin naxan yi, Misiran mangana. A yi keli Misiran Mangan fɛma, a yi bɔxɔn birin yisiga. ");
INSERT INTO yal_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Lugo ɲɛɛ soloferen bun ma, bɔxɔn birin yi rawali ki faɲi. ");
INSERT INTO yal_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusufu yi donseen birin malan naxan sɔtɔxi ɲɛɛ solofereni ito bun ma Misiran bɔxɔn ma. Donseen naxanye sɔtɔxi banxidɛne yi, a yi ne ramara taa gbeene kui. ");
INSERT INTO yal_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu yi donse xɔri gbegbe malan alo baa xɔn mɛɲɛnsinna. A yi gbo ayi, han e fata a tɛngɛn ma bayo a mi yi gasɛ. ");
INSERT INTO yal_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Benun kamɛn ɲɛɛ singen xa a li, Yusufu a ɲaxanla Asenati, Hon taana saraxaraliin Potifari a dii tɛmɛna, na yi dii firin bari. ");
INSERT INTO yal_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu yi dii singen xili sa Manase, a naxa, “Bayo Ala bata a liga n ɲinan n ma tɔrɔyaan birin xɔn, e nun n baba a denbayana.” ");
INSERT INTO yal_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A yi dii firinden xili sa Efirami, a naxa, “Bayo Ala bata n findi wuyalaan na n nayarabi bɔxɔn ma.” ");
INSERT INTO yal_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Lugo ɲɛɛ soloferen yi dangu Misiran bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kamɛ ɲɛɛ soloferen yi a li fɔlɔ alo Yusufu a yɛba kii naxan yi. Kamɛn yi so bɔxɔne birin yi, koni burun yi na Misiran bɔxɔn birin ma. ");
INSERT INTO yal_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kamɛn to Misiran bɔxɔn birin suxu, yamaan yi sɔnxɔn nate Misiran Mangan ma donse feen na. Misiran Mangan yi a fala Misiran kaane birin xa, a naxa, “Ɛ sa a fala Yusufu xa, a na feen naxan fala ɛ xa, ɛ na liga.” ");
INSERT INTO yal_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kamɛn yi din bɔxɔn birin na. Yusufu yi donse ramaradene rabi, a yi donseen sara Misiran kaane ma. Kamɛn yi sɛnbɛn sɔtɔ Misiran bɔxɔn birin ma. ");
INSERT INTO yal_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Muxune yi fa, sa keli yamanane birin yi, e fa donseen sara Yusufu ma Misiran bɔxɔni, bayo kamɛn bata yi sɛnbɛn sɔtɔ yamanane birin yi. ");
INSERT INTO yal_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yaxuba to a mɛ a murutun Misiran yi, a yi a fala a diine xa, a naxa, “Nanfera ɛ dɔxi tun? ");
INSERT INTO yal_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","N bata a mɛ a murutun Misiran yi. Ɛ siga, ɛ sa murutun sara en xa alogo en xa balo, en nama faxa.” ");
INSERT INTO yal_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yusufu tadan muxu fu yi siga donse xɔri saradeni Misiran yi. ");
INSERT INTO yal_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yaxuba mi tin Bunyamin xa bira e fɔxɔ ra, Yusufu xunyɛna. A yi a fala, a naxa, “N bata gaxu fe ɲaxin nama fa a sɔtɔ.” ");
INSERT INTO yal_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Isirayilaa diine yi siga murutu saradeni, e nun muxu gbɛtɛn naxanye yi waxi murutun xɔn, bayo kamɛn bata yi din Kanan bɔxɔn birin na. ");
INSERT INTO yal_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusufu nan yi yamana kanna ra bɔxɔn xun na. A tan nan yi murutun matima yamaan birin ma yamanani. Yusufu tadane yi fa e xinbi sin a bun, e e yɛtagine lan bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu to a tadane to, a yi e kolon, koni a yi a yɛtɛ rasan e ma. A yi falan ti e xa a xɔdɛxɛn na, a fala e xa, a naxa, “Ɛ kelixi minɛn yi?” E yi a yabi, e naxa, “Nxu kelixi Kanan bɔxɔn nan ma fa donse saradeni.” ");
INSERT INTO yal_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufu yi a tadane kolon, koni e tan mi a kolon. ");
INSERT INTO yal_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yusufu a xiyene fe yi rabira a ma a naxanye sa e fe yi. A yi a fala e xa, a naxa, “Yaxune nan ɛ ra. Ɛ faxi yamanan fangatare yirene nan kolonde yi.” ");
INSERT INTO yal_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","E yi a yabi, e naxa, “Ɛn-ɛn, nxu kanna, nxu tan i ya konyine faxi donse saraden nin. ");
INSERT INTO yal_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Xɛmɛ kedenna diine nan nxu ra. Nxu tinxin. Nxu tan i ya konyine, yire mato mi nxu ra.” ");
INSERT INTO yal_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","A yi a fala e xa, a naxa, “Ɛ wule. Ɛ faxi yamanan fangatare yirene nan kolonde yi.” ");
INSERT INTO yal_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","E yi a yabi, e naxa, “Nxu tan, i ya konyine, xɛmɛ kedenna dii muxu fu nun firin nan nxu ra Kanan bɔxɔni. Iki nxu birin ma bolokada nxu baba dɛxɔn. Keden mi fa na.” ");
INSERT INTO yal_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusufu yi a fala e xa, a naxa, “N yi na nan falama ɛ xa, a yire matone nan ɛ ra. ");
INSERT INTO yal_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","N na ɛ kɛɲaan fɛsɛfɛsɛma ito nan na. N bata n kɔlɔ Misiran Mangan siini, ɛ mi minima be xa ɛ bolokadaan mi fa. ");
INSERT INTO yal_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ɛ muxu keden nasiga ɛ yɛ, a xa sa fa ɛ bolokadaan na. Ɛ tan dɔnxɛne sigama kasoon nin. Ɛ falane matoma nɛn, n na a kolonɲɛ xa ɛ ɲɔndin falama, xanamu n bata n kɔlɔ Misiran Mangan siini, yire matone nan ɛ ra.” ");
INSERT INTO yal_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","A yi e birin suxu han xii saxan. ");
INSERT INTO yal_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Xii saxande lɔxɔni, Yusufu yi a fala e xa, a naxa, “Ɛ ito liga alogo ɛ xa kisi. N gaxuma Ala yɛɛ ra. ");
INSERT INTO yal_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Xa tinxin muxun nan ɛ ra, ɛ muxu keden lu kasoon na. Bodene xa donseen xali ɛ denbaya kamɛtɔne xa. ");
INSERT INTO yal_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ɛ sa fa ɛ bolokadaan na n xɔn alogo n xa a kolon xa ɲɔndi falan nan ɛ ra, alogo ɛ nama faxa.” ");
INSERT INTO yal_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","E yi tin na falan ma, koni e bode tagi e naxa, “En tan nan yati findixi sɔnmaan na en xunyɛna a fe ra, bayo en bata a niina a tɔrɔyaan to, a to yi en mafanma kininkininni koni en mi en tuli mati a ra. Na nan a toxi tɔrɔyani ito en lixi.” ");
INSERT INTO yal_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubɛn yi ito sa a fari, a naxa, “N mi yi a fala ɛ xa, ɛ nama fe ɲaxin naba diidini ito ra. Koni ɛ mi ɛ tuli ti. Iki en fa a faxan saren nan fima.” ");
INSERT INTO yal_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","E mi yi a kolon xa Yusufu a mɛma, bayo xui maxɛtɛn yi e tagi. ");
INSERT INTO yal_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu yi a makuya e ra, a wuga. Na xanbi, a yi fa falan tiyɛ e xa. A yi Simeyɔn tongo e tagi, a yi a sa kasoon na e yɛɛ xɔri. ");
INSERT INTO yal_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu yi yamarin fi, a muxune xa a tadane bɛnbɛnle rafe donse xɔnna ra, e mɔn xa e keden kedenna birin ma gbeti sa a bɛnbɛnla kui sa fandana ndee fari e naxanye donɲɛ kira yi. Na yi liga e xa. ");
INSERT INTO yal_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","E yi e murutu goronne sa e sofanle fari, e yi siga. ");
INSERT INTO yal_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","E kɔɛɛn nadangu dɛnaxan yi, keden yi a bɛnbɛnla rabi alogo a xa balon so a sofanla yii. A yi a gbetin to a bɛnbɛnla dɛɛ ra. ");
INSERT INTO yal_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","A yi a fala a ngaxakedenne xa, a naxa, “N ma gbetin bata xɛtɛ n ma. I mi a to n ma bɛnbɛnla kui mɔn?” E bɔɲɛne yi mini. Birin yi a kuisan feen fala a boden xa e naxa, “Ala nanfe ligaxi en na?” ");
INSERT INTO yal_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","E to so e baba Yaxuba konni Kanan bɔxɔni, feen naxanye birin e li, e yi a birin yɛba a xa. ");
INSERT INTO yal_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","E yi a fala, e naxa, “Xɛmɛn naxan na yamana kanna ra, a falan tixi nxu xa a xɔdɛxɛn nan na, a nxu kansun a yire mato nan nxu ra. ");
INSERT INTO yal_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nxu yi a fala a xa, nxu naxa, ‘Nxu tinxin, yire matone mi nxu ra. ");
INSERT INTO yal_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nxu dii fu nun firin na a ra, nxu birin baba keden. Keden mi fa na, nxɔ bolokadana nxu baba fɛma Kanan bɔxɔni.’ ");
INSERT INTO yal_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Xɛmɛni ito naxan yamana kanna ra, na yi a fala nxu xa, a naxa, ‘Ɛ mi a to, a kolonma kii naxan yi a ɛ tinxin. Ɛ muxu keden lu n fɛma. Naxan daxa ɛ denbaya kamɛtɔɔn xa, ɛ na xali. ");
INSERT INTO yal_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ɛ siga, ɛ sa fa ɛ bolokada ra n xa. N na a kolonma nɛn nayi fa fala yire mato mi ɛ ra, ɛ tinxin. Na waxatini, n na ɛ xunyɛn soma ɛ yii nɛn, ɛ yulayaan liga bɔxɔni ito ma.’ ” ");
INSERT INTO yal_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","E to yi e bɛnbɛnle yixɛlɛma, birin ma sare so gbetin yi a bɛnbɛnla kui. E tan nun e baba yi gbetine to, e birin yi gaxu. ");
INSERT INTO yal_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","E baba Yaxuba yi a fala e xa, a naxa, “Ɛ bata n nafula n ma diine ra. Yusufu mi fa na, Simeyɔn fan mi na. Ɛ mɔn waxi Bunyamin nan fan tongo fe yi iki. Na goronna ngaan sama n tan nan xun ma.” ");
INSERT INTO yal_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubɛn yi a fala a baba xa, a naxa, “Xa n mi fa Bunyamin na, i xa n ma dii firinne faxa. A so n yii, n fama a ra nɛn i xa.” ");
INSERT INTO yal_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yaxuba yi a yabi, a naxa, “N ma diin mi sigama ɛ fɔxɔ ra, bayo a tada bata faxa, a kedenna nan fa luxi. Xa fena nde fa a sɔtɔ ɛ sigatini, ɛ n nagodoma nɛn sɔxɔlɛni laxira yi, nxu nun n fuge fixɛne.” ");
INSERT INTO yal_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kamɛn yi fa gbo ayi bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","E to yelin na murutun birin donɲɛ e fa naxan na sa keli Misiran yi, Yaxuba yi a fala a diine xa, a naxa, “Ɛ mɔn xa siga ɛ sa donsena nde sara en xa.” ");
INSERT INTO yal_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuda yi a yabi, a naxa, “Na xɛmɛna nxu rakolonxi nɛn a faɲin na, a naxa, ‘Ɛ mi fa n yɛtagin toma nɛn sɔnɔn fɔ ɛ bolokadaan na taran ɛ yɛ.’ ");
INSERT INTO yal_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Xa i bata tin nxu nun Bunyamin birin xa siga, nxu sigɛ, nxu sa donseen sara i xa. ");
INSERT INTO yal_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Koni xa i mi tin na ma, nxu mi sigɛ, bayo na xɛmɛna a fala nɛn nxu xa, a naxa, ‘Ɛ mi fa n yɛtagin toma fɔ ɛ bolokadaan taran ɛ yɛ.’ ” ");
INSERT INTO yal_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Na waxatini Isirayila yi a fala, a naxa, “Nanfera ɛ fe ɲaxini ito ligaxi n na, ɛ a fala na xɛmɛn xa a ɛ ngaxakedenna nde mɔn na yi?” ");
INSERT INTO yal_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","E yi a yabi, e naxa, “Xɛmɛni ito nxu maxɔdinxi nɛn a gbengbenna ra e nun nxu bari kiin ma. A yi fa a fala, a naxa, ‘Ɛ baba mɔn barixi? Ɛ xunyɛna nde na?’ Nxu fan yi a maxɔdinna birin yabi. Nxu yi a kolonɲɛ ba, a a falɛ, a naxa, ‘Ɛ fa ɛ xunyɛn na?’ ” ");
INSERT INTO yal_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda yi a fala a baba Isirayila xa, a naxa, “A lu nxu nun diin xa siga. Nxu kelima nɛn, nxu siga, nayi en balon sɔtɔma nɛn en mi faxɛ, i tan nun nxɔ diine, e nun nxu tan. ");
INSERT INTO yal_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","N tan nan findixi tolimaan na a funfuni. I fama a maxɔdindeni n tan nan na. Xa n mi fa a ra, n fa a ti i yɛtagi, n bata findi sɔnmaan na i mabinni. ");
INSERT INTO yal_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Anu, xa en mi yi buxi, nxu bata yi siga nun dɔxɔɲa yi firin.” ");
INSERT INTO yal_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","E baba Isirayila yi a fala e xa, a naxa, “Bayo na kiin na a ra, ɛ ito liga: Ɛ yamanan wali xɔnna nde sa ɛ bɛnbɛnle kui sanban na xɛmɛni ito xa, wudi dole senna nde nun kumin nun ture xiri ɲaxumɛne nun latikɔnɔnne nun wudi kɛsɛne nun a tinna nde. ");
INSERT INTO yal_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ɛ xa gbetin dɔxɔde firin tongo. Ɛ siga na gbetin na e naxan sa ɛ bɛnbɛnle dɛ ra. Yanyina nde tantanna na a ra. ");
INSERT INTO yal_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ɛ ɛ xunyɛn tongo, ɛ xɛtɛ xɛmɛni ito fɛma. ");
INSERT INTO yal_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ala Sɛnbɛ Kanna xa a liga, xɛmɛni ito yi kininkinin ɛ ma, a ɛ xunyɛn so ɛ yii e nun Bunyamin. N tan fan, xa n fulama n ma diine ra nɛn, n xa fula.” ");
INSERT INTO yal_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Xɛmɛni itoe yi sanbane yitɔn, e yi gbetin dɔxɔde firin tongo e nun Bunyamin. E yi keli e siga Misiran yi, e sa e yɛtɛ yita Yusufu ra. ");
INSERT INTO yal_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu to e to e nun Bunyamin, a yi a fala a banxi xunna xa, a naxa, “Xɛmɛni itoe raso banxini. Suben faxa, i yi a yitɔn bayo nxu nun xɛmɛni itoe nan nxu dɛgema to yanyin na.” ");
INSERT INTO yal_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Yusufu feen naxanye fala a banxi xunna xa, a ne liga. A yi xɛmɛni itoe mati Yusufu a banxini. ");
INSERT INTO yal_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Gaxun yi e suxu e sa e mati Yusufu a banxini waxatin naxan yi. E yi fa a fala, e naxa, “E faxi en na gbetin nan ma fe ra e naxan sa en ma bɛnbɛnle kui a fɔlɔni. E fama sodeni en xunna, e fa en suxu, e yi en findi konyine ra en nun en ma sofanle.” ");
INSERT INTO yal_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","E yi e maso Yusufu a banxi xunna ra, e yi falan ti a xa banxin so dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","E yi a fala, e naxa, “Yandi n kanna, nxu bata yi siga a singeni donse saradeni. ");
INSERT INTO yal_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Na xanbi, nxu to ti kɔɛɛn na, nxu yi bɛnbɛnle rafulun. Nxu keden kedenna ngaan yi gbetin to nxɔ bɛnbɛnle kui, nxɔ balon saraxi gbetin naxanye yɛtɛ ra. Iki nxu mɔn bata fa na ra. ");
INSERT INTO yal_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nxu mɔn bata fa gbeti gbɛtɛ ra alogo nxu xa donse gbɛtɛ sara. Nxu mi a kolon naxan gbetin sa nxɔ bɛnbɛnle kui.” ");
INSERT INTO yal_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","A yi e yabi, a naxa, “Ɛ bɔɲɛn xa xunbeli, ɛ nama gaxu. Ɛ Ala na a ra, ɛ babaa Ala nan hɛrisigɛn fixi ɛ ma ɛ bɛnbɛnle kui. Ɛ gbetin soxi n yii nɛn.” A yi Simeyɔn namini e ma. ");
INSERT INTO yal_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Xɛmɛni ito yi e raso Yusufu a banxin kui. A yi igen so e yii, e yi e sanne maxa, a yi balon so e sofanle yii. ");
INSERT INTO yal_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","E yi sanba seni tɔn benun Yusufu xa so waxatin naxan yi yanyi tagini, bayo e bata yi a mɛ e e dɛgema mɛnna nin. ");
INSERT INTO yal_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu to so banxini, e yi sanba seene so a yii, e e xinbi sin a yɛtagi. ");
INSERT INTO yal_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusufu yi e maxɔdin e kɛndɛyaan ma. A yi a fala, a naxa, “Ɛ ɛ baba forixin naxan ma fe fala, tana mi a ma? A mɔn barixi?” ");
INSERT INTO yal_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","E yi a yabi, e naxa, “I ya konyina, nxu baba, tana yo mi a ma. A mɔn barixi.” E mɔn yi e xinbi sin a bun. ");
INSERT INTO yal_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu yi a yɛɛn nakeli, a yi a xunyɛn Bunyamin to, a nga a diina. A yi a fala, a naxa, “Ito nan ɛ xunyɛn na ɛ naxan ma fe fala n xa?” A mɔn yi a fala, a naxa, “Ala xa hinan i ra, n ma diina.” ");
INSERT INTO yal_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","A xunyɛn hinanna yi so Yusufu yi, a yi wa wuga feni. A yi keli, a so a xideni, a wuga. ");
INSERT INTO yal_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","A to a yɛɛn naxa, a yi mini. A yi a yixɔdɔxɔ alogo a xa a yɛtɛ nɔ. A yi a fala, a naxa, “Ɛ donseni taxun.” ");
INSERT INTO yal_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","E yi a gbeen sa a danna, a tadane fan yi dɔxɔ e danna. Misiran kaan naxanye yi e dɛgema a xɔn ma ne fan yi lu e danna, bayo Misiran kaane nun Heburu muxune mi yi e dɛgɛ yire kedenni. Misiran kaane e namunna mi yi tinɲɛ na ma feu. ");
INSERT INTO yal_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusufu tadane yi radɔxɔ a yɛtagi e bari yɛɛn ma, fɔlɔ saran ma han bolokadana. E lu e bode matoɛ xaminxin na. ");
INSERT INTO yal_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusufu yi e donseene so e yii. Bunyamin ma donseen yi dangu a tadane gbeen na dɔxɔɲa ma suulun. E birin yi e dɛge, e e min, han e yi wasa. ");
INSERT INTO yal_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusufu yi yamarini ito so a banxi xunna yii, a naxa, “Muxuni itoe e bɛnbɛnle rafe donseen na han e nɔɛ yatɛn naxan xalɛ. I mɔn xa e gbetin sa e bɛnbɛnle dɛ ra. ");
INSERT INTO yal_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","I n ma igelengenna gbeti daxin fan sa e bolokadana bɛnbɛnla dɛ ra, e nun a murutu sara gbetina.” Yusufu feen naxan birin fala a banxi xunna xa, a yi na birin liga. ");
INSERT INTO yal_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kuye to yiba e yi muxuni itoe yiiba. E yi siga e nun e sofanle. ");
INSERT INTO yal_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","E yi mini taani. Koni e mi yi makuyaxi, Yusufu yi a fala a banxi xunna xa, a naxa, “Keli, i siga muxuni itoe fɔxɔ ra, i yi e suxu, i yi a fala e xa, i naxa, ‘Nanfera ɛ fe faɲin ɲɔxɔxi fe kobin na? ");
INSERT INTO yal_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nanfera ɛ n kanna igelengenna muɲaxi a a minma naxan yi, a yiimato sena? Ɛ bata fe ɲaxin liga na yi!’ ” ");
INSERT INTO yal_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Banxi xunna to e yiren li, a yi xɛtɛ falani ito ma e xa. ");
INSERT INTO yal_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","E yi a yabi, e naxa, “Nanfera nxu kanna fala sifani itoe tima? Nxu tan, i ya konyine mi nɔɛ na fe sifan ligɛ. ");
INSERT INTO yal_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nxu gbetin naxan to bɛnbɛnle kui Kanan yi, nxu bata fa a ra. Nayi, nxu gbetin nun xɛmaan muɲama i kanna banxini di? ");
INSERT INTO yal_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","I na se keden peen to i ya konyi kedenna naxan yii, a xa faxa. Nxu tan fan yi findi mangana konyine ra.” ");
INSERT INTO yal_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mangana a banxi xunna yi a fala, a naxa, “Na bata fan, ɛ naxan falaxi na ra, n fan bata tin na ma. N na se keden peen to muxun naxan yii, na tan bata findi n ma konyin na, ɛ tan dɔnxɛne yi yiiba.” ");
INSERT INTO yal_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","E birin yi e bɛnbɛnle ragodo mafurɛn, e yi e rafulun. ");
INSERT INTO yal_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Banxi xunna yi e kui to, fɔlɔ dii saran ma sa dɔxɔ bolokadaan na. Igelengenna yi to Bunyamin ma bɛnbɛnla kui. ");
INSERT INTO yal_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","E yi e domane yibɔ. E birin yi e goronne rate sofanle fari, e mɔn yi xɛtɛ taani. ");
INSERT INTO yal_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda nun a xunyɛne yi xɛtɛ Yusufu a banxini, a mɔn yi dɛnaxan yi. E bira bɔxɔni a yɛtagi, e yɛtagin yi lan bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu yi a fala e xa, a naxa, “Nanfera ɛ ito ligaxi? Ɛ mi a kolon, a n tan muxu sifan nɔɛ feene kolonɲɛ nɛn yiimatoon xɔn?” ");
INSERT INTO yal_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda yi a yabi, a naxa, “N nanse falama n kanna xa? N lan n xa nanse fala? Nxu nɔɛ fixɛ di? Ala bata nxu tan i ya konyine to hakɛn xun ma. Nxu bata findi n kanna konyine ra, nxu nun igelengenna toxi muxun naxan yii.” ");
INSERT INTO yal_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusufu yi a fala, a naxa, “N mi nɔɛ na fe sifan ligɛ! Igelengenna toxi muxun naxan yii, na nan n ma konyin na, koni ɛ tan, ɛ xɛtɛ bɔɲɛ xunbenli ɛ baba fɛma.” ");
INSERT INTO yal_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Na xanbi ra, Yuda yi a maso a ra, a yi a fala a xa, a naxa, “N bata i mafan n kanna, a lu n tan i ya konyin xa falan ti n kanna xa. I bɔɲɛn nama te i ya konyin xili ma, bayo i luxi nɛn alo Misiran Mangana. ");
INSERT INTO yal_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","N kanna bata yi nxu tan i ya konyine maxɔdin, a a fala, a naxa, ‘Ɛ baba na yi, xanamu ɛ xunyɛna?’ ");
INSERT INTO yal_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nxu yi n kanna yabi, nxu naxa, ‘Nxu baba forixin na yi, e nun nxu xunyɛna, a naxan sɔtɔxi xɛmɛ foriyani. A tada bata faxa, a kedenna nan fa luxi a nga a diin na, a rafan a baba ma.’ ” ");
INSERT INTO yal_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“I bata a fala i ya konyine xa, i naxa, ‘Ɛ fa a ra n fɛma alogo n xa a to n yɛɛn na.’ ");
INSERT INTO yal_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nxu yi n kanna yabi, nxu naxa, ‘Dii ɲɔrɛni ito mi kelɛ a baba dɛxɔn ma, xa a keli na, a baba faxama nɛn.’ ");
INSERT INTO yal_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Koni, i yi a fala i ya konyine xa, i naxa, ‘Xa ɛ nun ɛ xunyɛn birin mi fa, ɛ mi n yɛtagin toɛ sɔnɔn.’ ");
INSERT INTO yal_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nxu to siga n baba konni, i ya konyina, nxu yi i tan n kanna dɛntɛgɛn sa a xa.” ");
INSERT INTO yal_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Nxu baba yi a fala, a naxa, ‘Ɛ siga ɛ sa donsena nde sara en xa.’ ");
INSERT INTO yal_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nxu yi a yabi, nxu naxa, ‘Nxu mi nɔɛ sigɛ xa nxu nun nxu xunyɛn birin mi a ra. Nxu sigɛ nɛn xa nxu birin na a ra. Xa na mi a ra nxu mi nɔɛ xɛmɛni ito yɛtagin toɛ.’ ");
INSERT INTO yal_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","I ya konyina, nxu baba a fala nɛn nxu xa, a naxa, ‘Ɛ a kolon n ma ɲaxanla dii xɛmɛ firin nan barixi n xa. ");
INSERT INTO yal_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kedenna kelixi nɛn n xun ma, n mirixi a ma yanyina nde suben bata a yibɔ, bayo han iki n munma a to. ");
INSERT INTO yal_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Xa ɛ ito fan tongo n xun ma, fe ɲaxina nde yi a sɔtɔ, ɛ n nagodoma sɔxɔlɛni nɛn laxira yi nxu nun n ma fuge fixɛne.’ ” ");
INSERT INTO yal_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Iki xa n xɛtɛ n baba yireni, i ya konyina, xa nxu nun diidini ito mi a ra, ");
INSERT INTO yal_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","n baba faxama nɛn bayo a nii lutin nan a diin na, Bunyamin. A na a to diidini ito mi faxi, i ya konyine bata e baba ragodo nayi sɔxɔlɛni laxira yi e nun a fuge fixɛne. ");
INSERT INTO yal_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Bayo, n tan, i ya konyina a yɛtɛ dɔxi nɛn tolimani diidini ito a fe ra. N bata yi a fala n baba xa, n naxa, ‘Xa n mi xɛtɛ a ra i yireni, n findima sɔnmaan nan na n baba mabinni habadan.’ ” ");
INSERT INTO yal_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Iki n bata i mafan, i ya konyin xa lu diidini ito ɲɔxɔni alo n kanna a konyina, alogo diidini ito nun a tadane birin xa siga. ");
INSERT INTO yal_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","N nɔɛ sigɛ n baba yireni di, xa nxu nun diidini ito birin mi a ra? N mi nɔɛ n yɛɛn tiyɛ na sunun na naxan n baba suxɛ.” ");
INSERT INTO yal_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusufu mi yi nɔɛ a yɛtɛ yisuxɛ a walikɛne yɛtagi. A yi sɔnxɔ, a naxa, “Ɛ birin xa mini n xun ma!” Yusufu a yɛtɛ yitama a tadane ra waxatin naxan yi, muxu yo mi yi a fɛma. ");
INSERT INTO yal_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","A yi wuga sɔbɛɛn na. Misiran kaane yi a xuiin mɛ, Misiran Mangana banxin muxune yi a feen mɛ. ");
INSERT INTO yal_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu yi a fala a tadane xa, a naxa, “N tan nan Yusufu ra! N baba mɔn na?” Koni a tadane mi nɔ a yabideni bayo e bata dɛ xara, e yigitɛgɛ a yɛɛ ra. ");
INSERT INTO yal_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufu yi a fala a tadane xa, a naxa, “N bata ɛ maxandi, ɛ ɛ maso n na.” E yi e maso a ra. A yi a fala, a naxa, “N tan nan Yusufu ra, ɛ xunyɛna, ɛ naxan mati Misiran kaane ma konyin na. ");
INSERT INTO yal_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Iki, ɛ bɔɲɛn nama mini, ɛ mɔn nama gaxu n mati feen ma, bayo Ala n xɛxi nɛn ɛ yɛɛ ra alogo n xa ɛ nii ratanga. ");
INSERT INTO yal_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ɛ bata a to, xabu ɲɛɛ firin kamɛn waraxi bɔxɔni, ɲɛɛ suulun mɔn luxi, bɔxɔn mi nɔɛ rawalɛ, sansiin mi nɔɛ xabɛ. ");
INSERT INTO yal_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ala n nasanbaxi nɛn ɛ yɛɛ ra alogo ɛ nun ɛ yixɛtɛne xa kisi dunuɲa yi, maratanga gbeen barakani. ");
INSERT INTO yal_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Nayi, ɛ tan xa mi faxi n na be, koni Ala na a ra. A yi n findi Misiran Mangan baba ra, a banxi mangana, e nun Misiran bɔxɔn birin yamana kanna.” ");
INSERT INTO yal_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ɛ xulun, ɛ siga n baba yireni. Ɛ a fala a xa, ɛ naxa, ‘I ya diin Yusufu ito nan falaxi, Ala bata n findi Misiran bɔxɔn birin mangan na. Fa n fɛma, i nama bu. ");
INSERT INTO yal_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","I luma Gosen bɔxɔn nan ma. I luma n fɛma nɛn, i tan nun i ya diine nun i mamandenne nun i ya xuruse kurun birin, e nun i yii seen birin. ");
INSERT INTO yal_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mɛnni n ni i makoon birin fanma nɛn, bayo ɲɛɛ suulun kamɛn mɔn luxi. Xa na mi a ra i fama nɛn halagideni ɛ nun i ya denbayana, e nun i yii seen birin.’ ” ");
INSERT INTO yal_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Ɛ bata a to ɛ yɛɛn na, n xunyɛn Bunyamin fan bata a to a yɛɛn na, a n tan nan falan tixi ɛ xa. ");
INSERT INTO yal_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ɛ xa n ma mangaya nɔrɔn yɛba n baba xa n naxan yi Misiran bɔxɔni, e nun ɛ feen naxan birin toxi. Ɛ xulun, ɛ fa n baba ra han be.” ");
INSERT INTO yal_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","A yi dutun a xunyɛn Bunyamin ma, a yi wuga. Bunyamin fan yi wuga. ");
INSERT INTO yal_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","A yi a tadane birin sunbu, a wugama. Na birin to ɲan, e nun a tadane yi batu. ");
INSERT INTO yal_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Na feen xibarun yi Misiran Mangana banxin li, a Yusufu tadane bata fa. Na yi rafan Misiran Mangan ma e nun a kuntigine birin. ");
INSERT INTO yal_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Misiran Mangan yi a fala Yusufu xa, a naxa, “A fala i tadane xa, i naxa, ‘Ɛ goronne rate ɛ sofanle fari. Ɛ keli, ɛ siga Kanan bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ɛ sa ɛ baba tongo e nun ɛ denbayane, ɛ fa n fɛma. Se faɲin naxan birin Misiran bɔxɔni, n na a soɛ ɛ yii, ɛ mɔn yi bɔxɔn donse faɲine don.’ ");
INSERT INTO yal_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","N bata i yamari, a fala i tadane xa, i naxa, ‘Ɛ wontorone tongo Misiran bɔxɔni, ɛ diine nun ɛ ɲaxanle xa. Ɛ ɛ baba fan nate, ɛ birin yi fa. ");
INSERT INTO yal_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Hali ɛ nama mɔnɛ ɛ yii seene fe ra, bayo se faɲin naxanye birin Misiran bɔxɔni, a findima nɛn ɛ gbeen na.’ ” ");
INSERT INTO yal_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Isirayila a diine yi na liga. Yusufu yi wontorone so e yii alo Misiran Mangana a fala a xa kii naxan yi. E yi fandan so e yii e naxan donma kira yi. ");
INSERT INTO yal_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A yi domane so e birin yii. A gbeti gbananna kɛmɛ saxan fan so Bunyamin yii e nun doma suulun. ");
INSERT INTO yal_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Se faɲin naxan birin Misiran bɔxɔni, a na ndee rate sofali fu fari, a e sanba a baba ma e nun donse xɔnna nun burun nun fandan birin a baba naxan donɲɛ kira yi, na yi rate sofali gilɛ fu fari. ");
INSERT INTO yal_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Na xanbi ra, a yi a tadane yiiba, e yi siga. A yi a fala e xa, a naxa, “Ɛ nama sɔnxɔ kira yi de!” ");
INSERT INTO yal_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","E yi keli Misiran yi, e te Kanan bɔxɔn ma e baba Yaxuba yireni. ");
INSERT INTO yal_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","E yi a fala a xa, e naxa, “Yusufu mɔn barixi, a tan nan Misiran bɔxɔn birin yamarima.” Koni Yaxuba bɔɲɛn mi sɛwa, bayo a mi laxi e ra. ");
INSERT INTO yal_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Yusufu falan naxanye birin ti e xa, e yi na birin yɛba a xa. Yaxuba yi wontorone to Yusufu naxanye rasanbaxi a ma a xali feen na. Na yi a liga e baba Yaxuba niin yi sɛwa. ");
INSERT INTO yal_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Isirayila yi a fala, a naxa, “N bata sɛwa, n ma diin Yusufu mɔn na. Benun n xa faxa, n sa a toma nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Seen naxan birin yi findixi Isirayila gbeen na, a yi na birin xali a yii. A to Bɛriseba li, a yi saraxan ba a baba Isiyagaa Ala xa. ");
INSERT INTO yal_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Isirayila yi fe toon ti kɔɛɛn na alo xiyena, Ala yi a fala a xa, a naxa, “Yaxuba, Yaxuba!” Isirayila yi a ratin, a naxa, “N tan ni i ra!” ");
INSERT INTO yal_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ala yi a fala, a naxa, “N tan nan Ala ra, i babaa Ala. Hali i nama gaxu siga feen na Misiran yi, bayo n ni i findima siya gbeen nan na mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","En birin nan sigama Misiran yi, n tan nan mɔn fama i raxɛtɛdeni. Yusufu nan i yɛɛne raxima, i na faxa waxatin naxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yaxuba yi keli Bɛriseba yi. Isirayilaa diine yi e baba Yaxuba nun e diine nun e ɲaxanle xali wontorone kui Misiran Mangan naxanye rasanba e ma. ");
INSERT INTO yal_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","E yi e xuruseene tongo e nun e seen naxanye birin sɔtɔ Kanan bɔxɔn ma. Yaxuba yi siga Misiran yi e nun a bɔnsɔnna birin. ");
INSERT INTO yal_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","A yi a dii xɛmɛne xali a yii Misiran yamanani e nun a mamanden xɛmɛne nun a dii tɛmɛne nun a mamanden ɲaxalanmane, e nun a bɔnsɔnna birin. ");
INSERT INTO yal_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Isirayilaa diine xinle ni itoe ra naxanye siga Misiran yi Yaxuba nun a dii xɛmɛne: Yaxuba a dii singen nan Rubɛn na. ");
INSERT INTO yal_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubɛn ma diine: Xanɔki nun Palu nun Xesirɔn e nun Karimi. ");
INSERT INTO yal_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeyɔn ma diine: Yemuyeli nun Yamin nun Ohadi nun Yakin nun Soxara, e nun Sayuli. Sayuli findi Kanan ɲaxanla diin nan na. ");
INSERT INTO yal_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi a diine: Gɛrisɔn nun Kehati e nun Merari. ");
INSERT INTO yal_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yudaa diine: Eri nun Onan nun Selaxa nun Peresi e nun Sera. Koni Eri nun Onan faxa Kanan bɔxɔn nin. Peresi a diine findi Xesirɔn nun Xamuli nan na. ");
INSERT INTO yal_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakari a diine: Tola nun Puwa nun Yobo e nun Simiron. ");
INSERT INTO yal_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sabulon ma diine: Seredi nun Elon e nun Yalele. ");
INSERT INTO yal_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Diine nan ne ra, Leya naxanye bari Yaxuba xa Padan-Arami yi, e nun a dii tɛmɛn Dina. A dii xɛmɛne nun dii tɛmɛne yatɛn birin malanxina, muxu tonge saxan muxu saxan. ");
INSERT INTO yal_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadi a diine: Sifiyɔn nun Xagi nun Suni nun Ɛsibon nun Eriya nun Arodi e nun Areli. ");
INSERT INTO yal_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aseri a diine: Yimina nun Yisiwa nun Yisiwi nun Beriya e nun e magilɛn Sera. Beriya a diine findi Xeberi nun Malikili nan na. ");
INSERT INTO yal_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Silipa, Laban naxan so a dii tɛmɛn Leya yii, na diin naxanye bari Yaxuba xa, na diine nan ne ra. E birin malanxi muxu fu nun sennin. ");
INSERT INTO yal_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rakeli a diine, Yaxuba a ɲaxanla: Yusufu nun Bunyamin. ");
INSERT INTO yal_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Asenati yi dii firin sɔtɔ Yusufu xa Misiran bɔxɔni: Manase nun Efirami. Asenati findi Hon taan saraxaralina dii tɛmɛn nan na, naxan xili Potifari. ");
INSERT INTO yal_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bunyamin ma diine: Bela nun Bekeri nun Asibeli nun Gera nun Naman nun Exi nun Roxi nun Mupin nun Xupimi e nun Arade. ");
INSERT INTO yal_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Rakeli diin naxanye bari Yaxuba xa, na diine nan ne ra. E birin malanxina, muxu fu nun naanin. ");
INSERT INTO yal_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan ma diina: Xusimi. ");
INSERT INTO yal_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafatali a diine: Yaseli nun Guni nun Yeseri e nun Silen. ");
INSERT INTO yal_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bila, Laban naxan so a dii tɛmɛn Rakeli yii, a diin naxanye bari Yaxuba xa ne ni itoe ra. E birin malanxina, muxu solofere. ");
INSERT INTO yal_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yaxuba nun muxun naxanye birin siga Misiran yi, a bɔnsɔnna birin malanxina, muxu tonge sennin e nun sennin, ba a diine e ɲaxanle ra. ");
INSERT INTO yal_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusufu dii xɛmɛ firin nan bari Misiran yi. Yaxuba xabilan muxune yatɛn birin malanxina, naxanye siga Misiran bɔxɔn ma, e muxu tonge solofere nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yaxuba yi Yuda xɛ a yɛɛ ra Yusufu fɛma alogo e birin xa siga Gosen yi. E yi so Gosen bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu yi a yɛngɛso wontoron tongo, a yi siga Gosen yi a baba Isirayila ralandeni. A to a li, a yi filinfilin a ma, a yi bu wugɛ a kɔɛɛn xɔn. ");
INSERT INTO yal_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isirayila yi a fala Yusufu xa, a naxa, “Hali n faxa fa, bayo n bata i yɛtagin to, i mɔn yengima!” ");
INSERT INTO yal_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu yi a fala a tadane xa, e nun a babaa denbayana, a naxa, “N xa siga, n xa sa a fala Misiran Mangan xa, n naxa, ‘N tadane nun n babaa denbayaan naxanye yi dɔxi Kanan bɔxɔni, e birin bata fa n fɛma. ");
INSERT INTO yal_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Muxuni itoe xuruse kantanne nan ne ra. E xuruseene rabama. E bata fa e xuruse kurune ra, siine nun yɛxɛɛne nun ɲingene e nun e yii seen birin.’ ");
INSERT INTO yal_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Misiran Mangan na ɛ xili waxatin naxan yi, a ɛ maxɔdinma nɛn a ɛ wanla nanse a ra. ");
INSERT INTO yal_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ɛ a yabima nɛn, ɛ naxa, ‘Nxu tan i ya konyine xuruse rabaan nan nxu ra, xabu nxu dii ɲɔrɛne han iki, alo nxu baba yi a ma kii naxan yi.’ Na kiini, ɛ fama ludeni Gosen bɔxɔn nan ma, bayo xuruse rabane raɲaxu Misiran kaane ma.” ");
INSERT INTO yal_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusufu yi siga, a sa a fala Misiran Mangan xa, a naxa, “N baba nun n fafaxakedenne bata fa sa keli Kanan bɔxɔn ma, e nun e xuruseene birin nun e yii seene birin. E na yi iki Gosen bɔxɔni.” ");
INSERT INTO yal_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","A yi a tada suulun yita Misiran Mangan na. ");
INSERT INTO yal_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Misiran Mangan yi Yusufu tadane maxɔdin, a naxa, “Ɛ wanla mundun maxaranxi?” E yi Misiran Mangan yabi, e naxa, “Nxu tan i ya konyine xuruse rabane nan nxu ra alo nxu benbane yi a ma kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","E mɔn yi a fala Misiran Mangan xa, e naxa, “Nxu faxi nɛn nxu xa lu bɔxɔni ito ma singen, bayo xuruseene rabade mi i ya konyine yii sɔnɔn. Kamɛn bata gbo ayi Kanan bɔxɔn ma. I ya konyine sago sa e xa lu Gosen bɔxɔni.” ");
INSERT INTO yal_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Misiran Mangan yi a fala Yusufu xa, a naxa, “I baba nun i tadane bata fa i fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Misiran bɔxɔna i sagoni. Yire faɲin fen bɔxɔni ito ma, i baba nun i fafaxakedenne luyɛ dɛnaxan yi. E xa lu Gosen bɔxɔni. Xa i muxu faɲine kolon e yɛ, e findi n ma xuruse kantanne ra.” ");
INSERT INTO yal_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yusufu yi fa a baba ra, a yi a yita Misiran Mangan na. Yaxuba yi duba Misiran Mangan xa. ");
INSERT INTO yal_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Misiran Mangan yi Yaxuba maxɔdin, a naxa, “I ya siimayaan ɲɛɛ yoli a ra iki?” ");
INSERT INTO yal_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaxuba yi Misiran Mangan yabi, a naxa, “N ma siimayaan ɲɛɛ kɛmɛ ɲɛɛ tonge saxan na a ra iki. N siimaya dungi naxasixin nan sɔtɔxi. A yɛtɛ mi masoxi n benbane siimayaan yatɛn na.” ");
INSERT INTO yal_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yaxuba mɔn yi duba Misiran Mangan xa, a fa siga. ");
INSERT INTO yal_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusufu yi bɔxɔ faɲin fi a baba nun a tadane ma alo Misiran Mangana a yamari kii naxan yi. E bɔxɔn naxan sɔtɔ, na fan Misiran bɔxɔn birin xa. A xili Ramisesi. ");
INSERT INTO yal_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","A yi ti a baba nun a tadane nun a babaa denbayaan birin bun ma. ");
INSERT INTO yal_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kamɛn yi ɲaxu ayi, donseen mi yi toma bɔxɔ yo yi, keli Misiran ma dɔxɔ Kanan na. Yamaan yi doyen kamɛn ma. ");
INSERT INTO yal_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Gbetin naxan birin yi na Misiran nun Kanan bɔxɔni, e yi a birin sara murutun na. Yusufu yi na gbetin namara Misiran Mangana banxini. ");
INSERT INTO yal_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Misiran bɔxɔn gbetin nun Kanan bɔxɔn gbetin to ɲan, Misiran kaane yi fa Yusufu fɛma, e yi a fala, e naxa, “Burun so nxu yii! Fɔ nxu faxa i yɛɛ xɔri bayo gbeti mi fa nxu yii sɔnɔn?” ");
INSERT INTO yal_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu yi a fala, a naxa, “Ɛ fa ɛ xuruseene ra, en ɲa a masara burun na bayo gbeti mi fa ɛ yii.” ");
INSERT INTO yal_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","E yi fa e xuruseene ra Yusufu ma. A fan yi donseen so e yii e soone nun siine nun yɛxɛɛne nun ɲingene nun sofanle ɲɔxɔn na. A yi burun taxun e ra e xuruseene masaran na. ");
INSERT INTO yal_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Na ɲɛɛn to dangu, e yi fa a fɛma. E yi a fala a xa, e naxa, “Nxu mi nɔɛ a luxunɲɛ nxɔ mangan ma. Gbeti yo mi nxu yii. Nxɔ xuruseen fan birin nxɔ mangan yii. Nxu gbindine nun nxɔ bɔxɔne gbansanna nan luxi nxɔ mangan xa. ");
INSERT INTO yal_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Fɔ nxu xa faxa i yɛɛ xɔri, nxu tan nun nxɔ bɔxɔne? Nxu tan nun nxɔ bɔxɔne masara burun na, nxu xa findi Misiran Mangana konyine ra, nxu nun nxɔ bɔxɔne. Sansiin so nxu yii, nxu xa a rawali, nxu xa balo alogo nxu nama faxa, bɔxɔn nama rabeɲin.” ");
INSERT INTO yal_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yusufu yi Misiran bɔxɔn birin sara Misiran Mangan xa, bayo Misiran kaane birin e bɔxɔne mati nɛn. Kamɛn bata yi dɔxɔ e yi. Bɔxɔn yi findi Misiran Mangan gbeen na. ");
INSERT INTO yal_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","A yi yamaan findi konyine ra, keli Misiran yamanan bode fɔxɔn ma sa dɔxɔ a naninna boden na. ");
INSERT INTO yal_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Hali na birin to liga, a mi saraxaraline bɔxɔn sara bayo Misiran Mangan bata yi sariya faɲin tongo e fe ra. E mi e bɔxɔne mati bayo Misiran Mangan yi burun taxunma e ra. ");
INSERT INTO yal_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusufu yi a fala yamaan xa, a naxa, “N bata ɛ sara to. Ɛ nun ɛ bɔxɔne luma nɛn Misiran Mangan xa. Ɛ sansine ni itoe ra, ɛ xa bɔxɔne rawali. ");
INSERT INTO yal_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Se xaba waxatini, naxan yo na maala xaba xidi naanin, a suulunden nan soma Misiran Mangan yii. Xidi naaninna, na xa findi sansiin na e nun ɛ balona, ɛ tan nun ɛ diine nun muxun naxanye birin ɛ yii banxine kui.” ");
INSERT INTO yal_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","E yi a fala, e naxa, “I bata nxu ratanga! Nxu bata nxɔ mangana a fe faɲin to a naxan ligaxi nxu xa. Nxu findima Misiran Mangana konyine nan na.” ");
INSERT INTO yal_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusufu yi na findi sariyan na, na nan nakamalixi han to. Misiran bɔxɔni, se xabaxine xidi suulunden findin Misiran Mangan nan gbee ra, fɔ saraxaraline bɔxɔne. Ne mi findixi Misiran Mangan gbeen na. ");
INSERT INTO yal_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isirayila yi dɔxɔ Misiran bɔxɔni Gosen binni. Na bɔxɔn yi findi e gbeen na. E yi findi dii barine ra, e yi wuya ayi. ");
INSERT INTO yal_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaxuba ɲɛɛ fu nun solofere nan liga Misiran bɔxɔni. Yaxuba a siimayaan ɲɛɛ kɛmɛ ɲɛɛ tonge naanin e nun solofere nan sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Isirayilaa siimayaan fa ɲan feni, a yi a dii Yusufu xili, a yi a fala a xa, a naxa, “Xa i wama n nafan feen liga feni, n bata i mafan i yiin naso n danban bun ma, i xa i kɔlɔ n xa. I xa hinan n na lannayani. N bata i maxandi i nama n maluxun Misiran bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","N na laxiraya waxatin naxan yi, i n naminima nɛn Misiran yi, i sa n maluxun n baba gaburun yireni.” Yusufu yi a yabi, a naxa, “I naxan falaxi n xa, n na a ligama nɛn.” ");
INSERT INTO yal_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Isirayila yi a fala, a naxa, “I kɔlɔ n xa.” Yusufu yi a kɔlɔ a xa. Na xanbi, Isirayila yi a xinbi sin Ala yɛtagi a saden xunsaden na. ");
INSERT INTO yal_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Na feen birin to dangu, e yi a fala Yusufu xa, e naxa, “I bata a to, i baba mi yalan.” A yi siga e nun a dii xɛmɛ firinna, Manase nun Efirami. ");
INSERT INTO yal_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","E yi a fala Yaxuba xa, e naxa, “I ya diin Yusufu fama i fɛma.” Isirayila yi fangan sɔtɔ, a keli, a dɔxɔ a saden ma. ");
INSERT INTO yal_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaxuba yi a fala Yusufu xa, a naxa, “Ala Sɛnbɛ Kanna fa nɛn n ma Lusi yi, Kanan bɔxɔni. A yi barakan nagidi n ma. ");
INSERT INTO yal_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","A yi a fala n xa, a naxa, ‘N tan ni i ra. I findima dii barin na nɛn. N na i rawuyama ayi nɛn, siya wuyaxi yi mini i yi. N bɔxɔni ito fima nɛn i bɔnsɔnna ma, hali i dangu xanbini. A findi e gbeen na habadan.’ ” ");
INSERT INTO yal_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Dii firinni itoe i naxanye barixi Misiran yi benun n tan xa fa, n bata e findi n ma diine ra. Efirami nun Manase findima n tan nan gbee ra, alo Rubɛn nun Simeyɔn. ");
INSERT INTO yal_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Koni i diin naxanye barixi ne xanbi ra, i gbeen nan ne ra. E fama nɛn ludeni e tadane bun ma e kɛɛna a fe ra. ");
INSERT INTO yal_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","N to keli Padan yi, Rakeli yi faxa n yii kira yi Kanan bɔxɔni. Na mi yi makuya Efarata ra. N yi a maluxun mɛnni Efarata kiraan na, dɛnaxan xili Bɛtɛlɛmi.” ");
INSERT INTO yal_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isirayila yi Yusufu a diine mato, a a fala, a naxa, “Nde ne ra?” ");
INSERT INTO yal_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu yi a baba yabi, a naxa, “N ma dii xɛmɛne nan e ra Ala naxanye fixi n ma be.” Isirayila naxa, “N bata i mafan, e maso n na alogo n xa duba e xa.” ");
INSERT INTO yal_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yaxuba bata yi yelin forɛ, a yɛɛne mi yi seni gbɛma. A mi yi seen toma ki faɲi. Yusufu yi a diine maso a ra. Isirayila yi a yiin filinfilin e ma, a e sunbu. ");
INSERT INTO yal_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isirayila yi a fala Yusufu xa, a naxa, “N mi yi laxi a ra xa n ni i yɛtagin toɛ sɔnɔn, koni Ala bata a ragidi n bata i ya diine fan to.” ");
INSERT INTO yal_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusufu yi a diine tongo a baba sanna fari, a a xinbi sin a bun ma, a yɛtagin yi lan bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Na xanbi ra, Yusufu yi a dii firinna suxu e yiine ma. A yi Efirami suxu a yiifanna ra, Isirayila kɔmɛnna mabinni. A yi Manase suxu a kɔmɛnna ra, Isirayila yiifanna mabinni. A yi e maso a ra. ");
INSERT INTO yal_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Koni Yaxuba yi a yiifanna sa Efirami xunna fari naxan yi dii ɲɔrɛn na. A yi a kɔmɛnna sa Manase xunna fari naxan yi dii singen na. A a yiine gindingalan. ");
INSERT INTO yal_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","A yi duba Yusufu xa, a naxa, “Ala, n fafane Iburahima nun Isiyaga sigan ti naxan yɛɛ xɔri, Ala naxan n kantanma xabu n bari lɔxɔni han to, ");
INSERT INTO yal_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","malekan naxan n natangaxi fe xɔdɛxɛn ma, na xa dii ɲɔrɛni itoe baraka. N xinla xa fala e xun ma, e nun n baba Iburahima nun Isiyaga. E xa wuya ayi bɔxɔni.” ");
INSERT INTO yal_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu yi a to a baba bata a yiifanna sa Efirami xun ma. Na feen yi raɲaxu a ma. A yi a baba yiin suxu, a a ba Efirami xun ma a yi a sa Manase xun ma. ");
INSERT INTO yal_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufu yi a fala a baba xa, a naxa, “Na kiin xa mi a ra, baba, bayo ito nan fonna ra. I yiifanna sa ito nan xun ma.” ");
INSERT INTO yal_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","A baba yi tondi, a a fala, a naxa, “N na a kolon, n ma diina, n na a kolon. A fan findima nɛn siya gbeen na, koni a xunyɛn nan fama wuyadeni dangu a ra. A xunyɛn bɔnsɔnna findima nɛn siya wuyaxin na.” ");
INSERT INTO yal_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","A yi duba e xa na lɔxɔni, a a fala, a naxa, “Isirayila kaane Ala maxandin ligama ɛ xinle ra nɛn. E fama a faladeni nɛn, e naxa, ‘Ala xa i lu alo Efirami nun Manase.’ ” Na kiini, a yi Efirami rafisa Manase xa. ");
INSERT INTO yal_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Isirayila yi a fala Yusufu xa, a naxa, “I bata a to, n fa faxama nɛn, koni Ala luma nɛn ɛ xɔn, a fama i raxɛtɛdeni nɛn i benbane bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","N kɛɛ keden fima nɛn i ma dangu i tadane ra, n Siken yamanan nan fima i ma n naxan tongo Amorine yii n ma silanfanna nun n ma xanla ra.” ");
INSERT INTO yal_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yaxuba yi a diine xili, a yi a fala e xa, a naxa, “Ɛ malan, n xa feene fala naxanye fama ligadeni ɛ xa waxati famatɔne yi. ");
INSERT INTO yal_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ɛ maso, ɛ tuli mati n na Yaxubaa diine. Ɛ tuli mati ɛ baba Isirayila ra.” ");
INSERT INTO yal_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rubɛn, i tan, n ma dii singena, i tan nan n fangan na, naxan singe n sɛnbɛn mayitaxi. I xunnayeren dangu bodene ra i sɛnbɛn gbo. ");
INSERT INTO yal_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","I yɛ yifuxi alo fufana, i mi fisamantenyaan sɔtɔma bayo i bata i sa i baba a saden ma, i yi a xɔsi.” ");
INSERT INTO yal_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeyɔn nun Lewi ngaxakedenmaan nan e ra. E silanfanna nan e yɛngɛso seen na. ");
INSERT INTO yal_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","N xaxinla nama lu e maxadini, n miriyaan nama lu e malanni, bayo e bata muxune faxa e bɔɲɛ teeni, e bata turane fasane bolon e ɲaxuni. ");
INSERT INTO yal_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","N bata e xɔlɔn danga, bayo e yɛngɛn gidima. N bata e fitinaxin danga, bayo e yɛɛne yixara. N na e raxuyama ayi nɛn Yaxuba bɔnsɔnne yɛ, n mɔn yi e rayensen Isirayila yi.” ");
INSERT INTO yal_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, i xunyɛne i tan nan tantunma. I nɔɔn sɔtɔma nɛn i yaxune xun na. I babaa dii xɛmɛne e xinbi sinma nɛn i xa. ");
INSERT INTO yal_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, yata sɛnbɛmaan nan i ra. N ma diina, i baloma suben nan na. I xinbine yidɔxɔma nɛn, i sa alo yatana, alo yata gilɛna, nde susuɛ i rakelɛ? ");
INSERT INTO yal_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Manga dunganna mi bama Yuda yii. Muxu yo mi manga taxamasenna bama a yii. Han taxamaseri kanna fa waxatin naxan yi, siyane yi xuru a xa. ");
INSERT INTO yal_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","A a sofanla xidima manpa binla nan na, a a sofali diin xidima manpa bili faɲin yiin nan na. A a domaan xama wudi bogi igen nan na alo manpana, a a doma gbeen fan xama bogi se ige gbeela nan na alo wunla. ");
INSERT INTO yal_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A yɛɛne fɔrɔ wudi bogi ige gbeela xa, A ɲinna fixa nɔnɔn xa.” ");
INSERT INTO yal_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sabulon fama dɔxɔdeni baan nan dɛ. A bɔxɔn findima kunki yigiyaden nan na. A naninna Sidɔn dɛxɔnna nan na.” ");
INSERT INTO yal_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakari sɛnbɛn luxi nɛn alo sofanla, naxan a sama a goron bɛnbɛli firinna tagi. ");
INSERT INTO yal_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A saxi bɔxɔn naxan ma, a na yire faɲiyaan to, a tungunni godoma nɛn goronna bun ma, a xuru konyiya wanla bun.” ");
INSERT INTO yal_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan, a a yamaan makitima nɛn, alo Isirayila bɔnsɔnna bonne. ");
INSERT INTO yal_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan luma nɛn alo saɲina kiraan xɔn ma, alo kosona san ma kiraan dɛ. A yi soon santinban xin, soo ragiin yi bira a fari. ");
INSERT INTO yal_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Alatala, n xaxili tixi i ya kisin na!” ");
INSERT INTO yal_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi, yɛngɛsone a yɛngɛma nɛn, koni a tan nan e rabodonma ayi e san xanbi ra.” ");
INSERT INTO yal_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aseri findima donse xɔri kanna nan na naxan kamalixi mangan dɛge seen na.” ");
INSERT INTO yal_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nafatali luma nɛn alo xɛli gilɛn naxan a gima, a fala faɲine tima.” ");
INSERT INTO yal_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yusufu luma nɛn alo wudi bogilana naxan tixi xuden dɛ. A yiine yibandunxi taan nabilinna yinna nan xun ma. ");
INSERT INTO yal_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Xalimakuli wonle yi yɛngɛn gidi a ma xɔlɛni, e xalimakunle woli a ma xɔnnantenyani. ");
INSERT INTO yal_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Koni a fan yi a xanla suxu ken, a yii rafan Yaxubaa Ala Sɛnbɛmaan barakani, Isirayila kantanmana, a kantan fanyena, ");
INSERT INTO yal_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","naxan findixi i fafe a Ala ra, naxan i ratangama, Ala Sɛnbɛ Kanna, naxan i barakama, naxan koren dubane fima i ma, naxan bɔxɔn dubane fima i ma, naxan dii bari dubane ragidima i ma. ");
INSERT INTO yal_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","I babaa dubane baraka dangu baraka feene ra naxanye sɔtɔma geya fonne xɛɛne ma, e dangu habadan geyane se faɲine ra. Ala xa na birin lu Yusufu xun ma, naxan findima a fafaxakedenne yɛɛratiin na.” ");
INSERT INTO yal_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Bunyamin luma nɛn alo kankona. Xɔtɔn yo xɔtɔn fɔ a subena nde suxu, a a don, ɲinbanna ra a a se suxine yitaxun.” ");
INSERT INTO yal_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Isirayila bɔnsɔn fu nun firinne nan ne ra. E babaa duban nan na ra a naxan fala e xa. A duba birin xa, birin nun a duba. ");
INSERT INTO yal_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Na xanbi, a yi a ɲungu a diine ma, a naxa, “N fa sigama nɛn laxira yi. N na faxa, ɛ n maluxun n baba yireni, gaburun naxan Eferon Xiti kaana xɛɛn ma, ");
INSERT INTO yal_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Makipelaa xɛɛn faranna ra, Mamire fɛma, Kanan bɔxɔni. Iburahima na xɛɛn saraxi Eferon Xiti kaan nan ma alogo na xa findi a muxu maluxunden na. ");
INSERT INTO yal_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Iburahima maluxunxi mɛnna nin, e nun a ɲaxanla Saran. Isiyaga fan maluxunxi mɛnni e nun a ɲaxanla Rebeka. N tan fan Leya maluxunxi mɛnni. ");
INSERT INTO yal_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Na xɛɛn nun na faran yinla naxan na yi, e saraxi Xitine nan ma.” ");
INSERT INTO yal_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaxuba to yelin yamarine fiyɛ a diine ma, a yi a sa saden ma. A yi faxa, a siga laxira yi. ");
INSERT INTO yal_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusufu yi a yiin bira a baba kɔɛ, a a sunbu, a wuga. ");
INSERT INTO yal_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Na xanbi Yusufu yi yamarin fi seribane ma a e xa senna raso a baba fatini alogo a nama kun. E yi na liga Isirayila ra ");
INSERT INTO yal_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","xii tonge naanin e namunna kiini. Misiran kaane yi a saya feen liga xii tonge solofere bun. ");
INSERT INTO yal_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Saya feen to ba a ra, Yusufu yi a fala Misiran Mangana yamaan xa, a naxa, “Xa n nɔɛ maxandini ito sɔtɔdeni ɛ sabun na, n bata ɛ maxandi ɛ n ma falan nadangu Misiran Mangan ma. ");
INSERT INTO yal_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","N baba n nakɔlɔ nɛn, a yi a fala, a naxa, ‘N fa faxama nɛn. I n maluxunma gaburun nan na n naxan gexi Kanan bɔxɔni.’ N waxi siga feni n xa sa n baba maluxun. Na waxatini n fama.” ");
INSERT INTO yal_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Misiran Mangan yi a yabi, a naxa, “Siga, i sa i baba maluxun alo a i rakɔlɔxi kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yusufu yi siga a baba maluxundeni e nun Misiran Mangan bundɔxɔne nun Misiran kuntigine ");
INSERT INTO yal_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","nun Yusufu a denbayaan nun a fafaxakedenne nun a babaa denbayana. Dii ɲɔrɛne nun xuruseene gbansan yi lu Gosen bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Yusufu nun wontorone nun e ragi muxune birin yi siga. Na yamaan yi gbo han! ");
INSERT INTO yal_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","E to Atadi lonna yiren li, Yurudɛn xuden kidi ma, e yi wuga gbeen ti e yi saya feene raba sɔxɔlɛni. Yusufu yi sunu a baba ɲan feen na han xii solofere. ");
INSERT INTO yal_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kanan kaane yi na saya feen to naxan ligaxi Atadi lonna ma. E yi a fala, e naxa, “Misiran kaane saya fe gbeen nan ligama.” Nanara, e yi na yiren xili sa “Misiran Saya Fena” Yurudɛn baan kidi ma. ");
INSERT INTO yal_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yaxuba feen naxan yamari a diine ma, e yi na liga. ");
INSERT INTO yal_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","A diine yi a xali Kanan bɔxɔni, e sa a maluxun Makipelaa xɛɛn faran yinla ra, Iburahima xɛɛn naxan sara Eferon Xiti kaan ma alogo na xa findi muxu maluxunden na Mamire dɛxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","E to yelin a baba maluxunɲɛ, Yusufu nun a tadane nun muxun naxanye birin siga a matideni a baba maluxundeni, ne yi xɛtɛ Misiran bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yusufu tadane to a to e baba bata faxa, e yi a fala, e naxa, “Xa Yusufu fa keli en xili ma, en fe ɲaxin naxan birin ligaxi a ra, a a gbeen ɲɔxɔma nɛn en na.” ");
INSERT INTO yal_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Na waxatini e yi siga a faladeni Yusufu xa, e naxa, “I baba yamarini ito nan fi nxu ma benun a xa faxa, ");
INSERT INTO yal_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","a naxa, ‘Ɛ ito fala Yusufu xa: N bata i maxandi, diɲa i tadane gbalo feen ma e nun e hakɛna, bayo e bata fe ɲaxin liga i ra. N bata i maxandi, iki nxu tan i fafe a Ala a walikɛne hakɛne mafelu.’ ” E to na falane ti Yusufu xa, a yi wuga. ");
INSERT INTO yal_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","A tadane yi bira a bun ma, e a fala, e naxa, “Nxu tan ni i ra i ya konyine.” ");
INSERT INTO yal_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yusufu yi a fala e xa, a naxa, “Hali ɛ nama gaxu. N tan xa mi Ala ra. ");
INSERT INTO yal_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ɛ lanxi a ma nɛn ɛ xa fe ɲaxin liga n na, koni Ala yi a maxɛtɛ fe faɲin na alogo feene xa rakamali, nii wuyaxin yi ratanga. ");
INSERT INTO yal_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Iki hali ɛ mi gaxu. N na ɛ makoon birin fanma nɛn e nun ɛ diine.” A fala kɛndɛne yi e bɔɲɛn sa. ");
INSERT INTO yal_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu yi dɔxɔ Misiran yi, a tan nun a denbayana. A yi ɲɛɛ kɛmɛ ɲɛɛ fu sɔtɔ siimayaan na. ");
INSERT INTO yal_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusufu Efirami a diine to nɛn. A yi a yixɛtɛn naaninden to. Manase a dii Makiri a diine, ne birin yi sa a sanna fari e bari waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusufu yi a fala a tadane xa, a naxa, “N fan fa faxama nɛn, koni Ala ɛ malima nɛn yati! A fama nɛn ɛ tongodeni Misiran yi, a ɛ xali na bɔxɔni a dɛnaxan layirin tongo Iburahima nun Isiyaga nun Yaxuba xa.” ");
INSERT INTO yal_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yusufu yi Isirayila a diine rakɔlɔ, a a fala, a naxa, “Ala ɛ malima nɛn yati! Na waxatini, ɛ nɛma kelɛ be, ɛ n xɔnne xali.” ");
INSERT INTO yal_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusufu faxa a ɲɛɛ kɛmɛ ɲɛɛ fuun nan ma. E yi a senna raso a fatini alogo a nama kun, e yi a binbin sa gɛmɛ kankiraan kui Misiran yamanani.");
INSERT INTO yal_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Isirayilaa diin naxanye fa Yaxuba fɔxɔ ra Misiran yi, ne xinle ni itoe ra e nun e denbayane: ");
INSERT INTO yal_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubɛn nun Simeyɔn nun Lewi nun Yuda ");
INSERT INTO yal_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","nun Isakari nun Sabulon nun Bunyamin ");
INSERT INTO yal_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","nun Dan nun Nafatali nun Gadi e nun Aseri. ");
INSERT INTO yal_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Muxu tonge solofere nan mini Yaxuba yi. Yusufu tan yi Misiran yi nun. ");
INSERT INTO yal_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yusufu yi faxa, e nun a ngaxakedenne nun na waxatin muxune birin. ");
INSERT INTO yal_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Isirayilaa diine yi diine bari, e wuya ayi, e yi yamanan nafe. ");
INSERT INTO yal_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Manga nɛnɛna nde yi dɔxɔ Misiran yi, naxan mi yi Yusufu a fe kolon. ");
INSERT INTO yal_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","A yi a fala a yamaan xa, a naxa, “Ɛ a mato, Isirayila yamaan wuyama ayi, e sɛnbɛn gboma ayi en xa. ");
INSERT INTO yal_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","En xa a liga xaxinla ra, alogo e nama wuya ɲaxi ra, alogo xa yɛngɛn keli, e nama sa en yaxune fari, e yi en yɛngɛ, e e gi yamanani.” ");
INSERT INTO yal_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nayi, e yi walikɛ kuntigine dɔxɔ e xunna, e xa e xunna kala wanla tɔrɔn bun ma. E Pitomi nun Ramisesi taane ti, alogo e xa findi se ramaradene ra Misiran mangan xa. ");
INSERT INTO yal_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Koni e nɛma e ɲaxankatama, e wuyama ayi, e gbo ayi. Nayi, Misiran kaane yi gaxu Isirayila bɔnsɔnne yɛɛ ra, ");
INSERT INTO yal_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","e yi e ɲaxankata wanle yi. ");
INSERT INTO yal_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","E yi e xunna kala konyiya wanle ra boro yibodonna nun bitikidi bɔnbɔna. ");
INSERT INTO yal_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Misiran Mangan yi falan ti Sifira nun Puwa xa, Heburune dii rasuxune, ");
INSERT INTO yal_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","a naxa, “Ɛ na Heburu ɲaxanle mali dii barideni, xa xɛmɛn nan a ra, ɛ xa a faxa. Xa ɲaxanla nan a ra, ɛ yi a lu a nii ra.” ");
INSERT INTO yal_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Koni dii rasuxune yi gaxu Ala yɛɛ ra. Misiran Mangan naxan falaxi e xa, e mi tin na ligɛ, e yi dii xɛmɛne lu e nii ra. ");
INSERT INTO yal_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Misiran Mangan yi dii rasuxune xili, a yi a fala e xa, a naxa, “Nanfera ɛ ito ligaxi, ɛ yi dii xɛmɛne lu e nii ra?” ");
INSERT INTO yal_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Dii rasuxune yi Misiran mangan yabi, e naxa, “Heburu ɲaxanle mi liga alo Misiran kaane, e yixɔdɔxɔ, e diin barima nɛn benun dii rasuxune xa fa.” ");
INSERT INTO yal_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ala yi hinan dii rasuxune ra, yamaan yi wuya ayi, a gbo ayi. ");
INSERT INTO yal_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Amasɔtɔ dii rasuxune gaxu nɛn Ala yɛɛ ra, Ala yi e denbayane rawuya ayi. ");
INSERT INTO yal_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Nayi, Misiran mangan yi yamarini ito fi a yamaan birin ma: Xɛmɛn naxan birin barima, ɛ e woli Nila baani. Ɛ ɲaxanle lu e nii ra. ");
INSERT INTO yal_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Xɛmɛna nde yi Lewi bɔnsɔnni, na yi Lewi bɔnsɔnna nde tongo a ɲaxanla ra. ");
INSERT INTO yal_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Na yi fudikan, a yi dii xɛmɛn bari. A to a to, a diin tofan, a yi a luxun kike saxan. ");
INSERT INTO yal_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","A mi yi fa nɔɛ a luxunɲɛ, a yi tanbin deben tongo, a dolen so a ma, a yi a diin sa a kui, a yi sa a dɔxɔ Nila baa igen xun ma gbalan xɔrɛ ra. ");
INSERT INTO yal_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Diin tadan ɲaxalanmaan yi sa ti wulani, a lu diin matoɛ alogo a xa a kolon feen naxan a sɔtɔma. ");
INSERT INTO yal_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Misiran mangana dii tɛmɛn yi godo baani a maxadeni, a fɔxɔrabirane yi e masiga tima Nila baan dɛ. A yi deben to gbalan xɔrɛ ra, a yi a konyi gilɛn nasiga a tongodeni. ");
INSERT INTO yal_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Misiran mangana dii tɛmɛn yi a rabi, a yi a to a dii xɛmɛn nan yi a ra. A wugama. A yi kininkinin a ma. A yi a fala, a naxa, “Heburu kaane diina nde ni ito ra!” ");
INSERT INTO yal_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Nayi, diin tadan ɲaxalanmaan yi a fala Misiran mangana dii tɛmɛn xa, a naxa, “I waxi n xa sa dii ngana nde fen i xa Heburu ɲaxanle yɛ, alogo a xa xiɲɛn fi diini ito ma?” ");
INSERT INTO yal_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Misiran mangana dii tɛmɛn yi a yabi, a naxa, “Awa, siga.” Diin tada yi sa diina nga yɛtɛɛn xili. ");
INSERT INTO yal_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Misiran mangana dii tɛmɛn yi a fala a xa, a naxa, “Diini ito xali, i xiɲɛn fi a ma n xa, n ni i saranna fiyɛ.” Ɲaxanla yi diin tongo, a xiɲɛn fi a ma. ");
INSERT INTO yal_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Diin to gbo, a yi a xali Misiran mangana dii tɛmɛn xɔn, a yi findi a diin na. A yi a xili sa, “Musa” bayo a naxa, “N na a tongoxi igen nan xun ma.” ");
INSERT INTO yal_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Lɔxɔna nde, Musa bata yi kɔxɔ, a siga a ngaxakedenne fɛma, a yi e wali xɔdɛxɛn to. A yi Misiran kaana nde to Heburu kaana nde bɔnbɛ a ngaxakedenne yɛ. ");
INSERT INTO yal_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","A yi a yɛɛ rakoɲin a rabilinni. A to a to muxu yo mi yi na, a yi Misiran kaan faxa. A yi a maluxun ɲɛmɛnsinni. ");
INSERT INTO yal_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Na xɔtɔn bode, a yi mini, a yi Heburu kaa firin to yɛngɛ. Yoo mi yi naxan xa, a a fala na xa, a naxa, “Nanfera i i lanfaan yɛngɛma?” ");
INSERT INTO yal_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Na yi a yabi, a naxa, “Nde i findixi mangan nun kitisaan na nxu xun na? I mirixi n faxa feen nan ma, alo i Misiran kaan faxaxi kii naxan yi ba?” Musa yi gaxu, a naxa, “Muxune bata n ma faxa ti feen kolon!” ");
INSERT INTO yal_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Misiran mangan to na feen mɛ, a yi kata Musa faxa feen na. Koni Musa yi a gi mangan bun, a siga Midiyan yamanani, a sa a matabu xɔɲinna dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Dii tɛmɛ solofere yi Midiyan saraxaraliin yii. Ne yi fa ige badeni, e yi goronne rafe alogo e xa sa e babaa xuruse kurune ramin. ");
INSERT INTO yal_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Xuruse raba gbɛtɛye yi fa, ne yi e kedi. Nayi, Musa yi keli, a e xun mayɛngɛ, a yi igen fi e xuruseene ma. ");
INSERT INTO yal_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","E to xɛtɛ e baba Reyuli konni, a yi e maxɔdin, a naxa, “Nanfera ɛ xɛtɛxi sinma to?” ");
INSERT INTO yal_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","E yi a yabi, e naxa, “Misiran kaana nde nan nxu ratangaxi xuruse rabane ma, a yɛtɛɛn yi igen ba nxu xa, a xuruseene ramin.” ");
INSERT INTO yal_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","A yi a fala a dii tɛmɛne xa, a naxa, “A sa minɛn yi? Nanfera ɛ xɛmɛn na luxi na yi? Ɛ sa a xili alogo a xa fa a dɛge.” ");
INSERT INTO yal_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa yi tin, a xa lu na xɛmɛn konni. Na yi a dii Sefora fi Musa ma a ɲaxanla ra. ");
INSERT INTO yal_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","A dii xɛmɛ keden bari a xa, a yi a xili sa Gɛrisɔmi, bayo a naxa, “N bata findi xɔɲɛn na yamana gbɛtɛni.” ");
INSERT INTO yal_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Waxati xunkuye to dangu, Misiran Mangan yi faxa. Isirayila bɔnsɔnne mɔn yi wugama konyiyaan bun ma, e yi gbelegbelema malina fe ra. E mawuga xuiin yi Ala li. ");
INSERT INTO yal_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ala yi e wuga xuiin mɛ, a yi a xaxili ti a layirin na a naxan xidi Iburahima nun Isiyaga nun Yaxuba xa. ");
INSERT INTO yal_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ala yi Isirayila kaane mato, a a ɲɔxɔ lu e xɔn. ");
INSERT INTO yal_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musa yi findi a bitanna Midiyan saraxarali Yetiro a xuruse rabaan na. A yi xuruseene xali tonbon yiren xanbi ra, a fa Alaa geyaan ma, Horebe yi. ");
INSERT INTO yal_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Alatala malekan yi mini a xa tɛɛn yiyani, fɔtɔndin tagi. Musa yi a mato, tɛɛn yi fɔtɔnni yiren birin yi, koni a mi yi a ganma mumɛ! ");
INSERT INTO yal_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa yi a fala, a naxa, “N xa siga mɛnni alogo n xa kabanako feen mato, feen naxan a ligama fɔtɔndin mi ganma.” ");
INSERT INTO yal_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Alatala to a to, a a sigama a yigbɛdeni, Ala yi a xili fɔtɔnni, a naxa, “Musa! Musa!” Musa yi a ratin, a naxa, “N tan ni i ra!” ");
INSERT INTO yal_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ala yi a fala, a naxa, “I nama i maso be ra, i ya sankidine ba i sanni, amasɔtɔ i tixi dɛnaxan yi, bɔxɔ sariɲanxin na a ra.” ");
INSERT INTO yal_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","A mɔn yi a fala, a naxa, “I benbane Ala nan n na, Iburahimaa Ala nun Isiyagaa Ala nun Yaxubaa Ala.” Musa yi a yɛtagin luxun, bayo a yi gaxuxi Ala to feen na. ");
INSERT INTO yal_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Alatala yi a fala, a naxa, “N bata n ma yamana tɔrɔn to naxan Misiran yi. N bata e wuga xuiin mɛ, e nun muxune e ɲaxankatama kii naxan yi, amasɔtɔ n na e sɔxɔlɛne kolon. ");
INSERT INTO yal_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Nayi, n bata godo alogo n xa e ba Misiran kaane yii. N yi e ba na yamanani, n yi e xali bɔxɔ faɲina nde yi naxan gbo, nɔnɔn nun kumin gbo bɔxɔn naxan yi, Kanan kaane dɔxi dɛnaxan yi, Xitine nun Amorine nun Perisine nun Xiwine e nun Yebusune. ");
INSERT INTO yal_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Iki Isirayila wuga xuiin bata n li, n bata a to Misiran kaane e tɔrɔn kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Nanara, iki, siga! N bata i xɛ Firawona ma alogo i xa Isirayila bɔnsɔnne ramini Misiran yi, n ma yamana.” ");
INSERT INTO yal_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Koni, Musa yi a fala Ala xa, a naxa, “Nde n tan na? N xa siga Firawona fɛma di, alogo n xa Isirayila bɔnsɔnne ramini Misiran yi?” ");
INSERT INTO yal_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ala yi a fala, a naxa, “N luma nɛn i xɔn. Ito findima nɛn taxamasenna ra alogo i xa a kolon, a n tan nan i rasigaxi. I na yamaan namini Misiran yi, ɛ fama n batudeni geyani ito nan fari.” ");
INSERT INTO yal_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa yi a fala Ala xa, a naxa, “Awa, n sigɛ Isirayila kaane fɛma, koni n na a falɛ e xa, n naxa, ‘Ɛ benbane Ala nan n nafaxi ɛ fɛma,’ xa e n maxɔdin fa fala, ‘A xili di?’ n na e yabima di na yi?” ");
INSERT INTO yal_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ala yi a fala Musa xa, a naxa, “N tan na a ra, Ala naxan na yi. I xa Isirayila kaane yabi na kii nin, i naxa, ‘Naxan xili “N Na Yi,” na nan n nafaxi ɛ fɛma.’ ” ");
INSERT INTO yal_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ala mɔn yi a fala Musa xa, a naxa, “A fala Isirayila kaane xa, a n tan, Alatala, e benbane Ala, e nun Iburahimaa Ala, e nun Isiyagaa Ala e nun Yaxubaa Ala, n nan i rafaxi e fɛma. N xinla ni ito ra habadan! E n xili bama ikii nin waxati famatɔne birin yi. ");
INSERT INTO yal_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Siga, i sa Isirayila fonne malan, i yi a fala e xa, a n tan, Alatala, e benbane Ala, Iburahimaa Ala nun Isiyagaa Ala nun Yaxubaa Ala, n tan bata mini i xa. N naxa, ‘N bata n ɲɔxɔ lu ɛ xɔn yati! N bata a to e naxan ligaxi ɛ ra Misiran yi. ");
INSERT INTO yal_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","N bata a ragidi, n na ɛ raminima nɛn Misiran yi, ɛ tɔrɔma dɛnaxan yi. N yi ɛ xali Kanan kaane bɔxɔni, Xitine nun Amorine nun Perisine nun Xiwine e nun Yebusune. Bɔxɔn nan na ra nɔnɔn nun kumin gbo dɛnaxan yi.’ ");
INSERT INTO yal_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","E i xuiin namɛma nɛn. Nayi, ɛ nun Isirayila fonne sigama nɛn Misiran Mangan fɛma, ɛ yi a fala a xa, ɛ naxa, ‘Alatala, Heburu kaane Ala, na bata mini nxu xa. Tin, nxu xa xii saxan siga ti tonbonni, alogo nxu xa saraxane ba Alatala xa, nxɔ Ala.’ ");
INSERT INTO yal_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","N na a kolon Misiran Mangan mi tinɲɛ ɛ yi siga, fɔ sɛnbɛmaan na a karahan. ");
INSERT INTO yal_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Nanara, n na n yiini bandunma nɛn, n Misiran yamanan tɔrɔ kabanakone ra n naxanye ligama e ra. Na xanbi ra, a tinma nɛn ɛ yi siga. ");
INSERT INTO yal_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","N na a ligama nɛn ɛ yi rafan Misiran kaane ma alogo ɛ yii genla nama siga. ");
INSERT INTO yal_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Isirayila ɲaxanle birin e dɔxɔ bode Misiran kaane maxɔdinma nɛn e nun Misiran ɲaxanla naxanye banxin kui a e xa gbeti nun xɛma muranne so e yii, e nun dugine, ɛ naxanye ragodoma ɛ diine ma. Nayi, ɛ Misiran kaane yii gelima nɛn.” ");
INSERT INTO yal_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa yi a yabi, a naxa, “Waxatina nde, e mi lama n na, e mi n xuiin suxuma. E a falama n xa nɛn, e naxa, ‘Alatala mi minixi i xa.’ ” ");
INSERT INTO yal_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Alatala yi a fala a xa, a naxa, “Nanse i yii?” A yi a yabi, a naxa, “Dunganna.” ");
INSERT INTO yal_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ala yi a fala, a naxa, “A bira bɔxɔni.” A yi a bira bɔxɔni, a yi findi saɲin na. Musa yi a gi a bun. ");
INSERT INTO yal_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Alatala yi a fala Musa xa, a naxa, “I yiini bandun, i yi a suxu a xunla ma.” A yi a yiini bandun, a yi a suxu a xunla ma. A mɔn yi findi dunganna ra a yii. ");
INSERT INTO yal_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Alatala yi a fala, a naxa, “I na nan ligama, alogo e xa la a ra a Alatala e benbane Ala bata mini i xa Iburahimaa Ala nun Isiyagaa Ala e nun Yaxubaa Ala.” ");
INSERT INTO yal_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Alatala mɔn yi a fala, a naxa, “I yiin naso i ya domaan bun.” A yi a yiin naso a domaan bun, a mɔn yi a ba na. A to a ba, a yi a to fure ɲaxin bata mini a yiin ma, a yi fixaxi alo balanbalan kɛsɛna. ");
INSERT INTO yal_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ala yi a fala, a naxa, “I mɔn xa i yiin naso i ya domaan bun.” A yi a yiin naso a domaan bun. A to a ba, a yiin mɔn yi xɛtɛ a kiini. ");
INSERT INTO yal_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ala yi a fala, a naxa, “Xa e mi la i ra, e mi i xuiin namɛ taxamaseri singena fe ra, e lama nɛn taxamaseri firinden na. ");
INSERT INTO yal_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Xa e mi la taxamaseri firinne ra, e mi i xuiin namɛ, i igen sɛgɛ Nila baani, i yi a bɔxɔn. I igen naxan tongoma Nila baani, na findima wunla nan na bɔxɔn ma.” ");
INSERT INTO yal_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa yi a fala Alatala xa, a naxa, “Marigina, n mi dɛ bolon. N mi yi dɛ bolon benun i xa falan ti n xa, hali iki n dɛɛn mi falan tima ki faɲi. N mi dɛ mafura falan tiyɛ muxune xa.” ");
INSERT INTO yal_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Alatala yi a fala a xa, a naxa, “Nde muxun dɛɛn nafalaxi? Nde muxun findima bobon na, hanma tuli xɔrina? Nde a findima yɛɛ kanna ra, hanma danxutɔna? N tan Alatala mi a ra ba? ");
INSERT INTO yal_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Nayi, siga, n na i malima nɛn fala tideni. I naxan falama, n ni xaran na ma.” ");
INSERT INTO yal_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Musa yi a fala, a naxa, “Marigina, i muxu gbɛtɛ rasiga.” ");
INSERT INTO yal_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Nayi, Alatala yi xɔlɔ Musa ma han! A yi a fala, a naxa, “I tada mi na ba, Haruna, Lewi bɔnsɔnna muxuna? N na a kolon, a fatan falan tiyɛ. A tan yɛtɛɛn kira yi, a fama i ralandeni. A na i to, a sɛwama nɛn. ");
INSERT INTO yal_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","I falan tima nɛn a xa, a fan yi a rali yamaan ma. N tan ɛ firinna birin malima nɛn falatideni. Ɛ lan ɛ xa naxan liga, n yi ɛ xaran na ma. ");
INSERT INTO yal_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A i ya falan nalima nɛn yamaan ma. A tan yi findi i dɛɛn na, i tan yi lu Ala funfuni a tan xa. ");
INSERT INTO yal_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Koni dunganni ito suxu i yii, alogo i xa kabanako feene liga a xɔn.” ");
INSERT INTO yal_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Musa yi xɛtɛ Yetiro fɛma, a bitanna, a yi a fala a xa, a naxa, “A lu n xa siga ngaxakedenne fɛma naxanye Misiran yi, alogo n xa a to xa e mɔn e nii ra.” Yetiro yi a fala Musa xa, a naxa, “Siga bɔɲɛ xunbenli.” ");
INSERT INTO yal_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Alatala yi a fala Musa xa Midiyan yi, a naxa, “Siga, xɛtɛ Misiran yi, amasɔtɔ naxanye birin yi wama i faxa feni, e bata faxa.” ");
INSERT INTO yal_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musa yi a ɲaxanla nun a diine rate sofanle fari, a xɛtɛ Misiran yamanani. Alaa dunganna yi suxi a yii. ");
INSERT INTO yal_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Alatala yi a fala Musa xa, a naxa, “I na xɛtɛ Misiran yi, n kabanako feen naxanye birin soxi i yii, i xa e liga Firawona yɛtagi. Koni, n tan Firawona bɔɲɛni xɔdɔxɔma nɛn, a mi tinma yamaan yi siga mumɛ! ");
INSERT INTO yal_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","I yi a fala Firawona xa, i naxa, ‘Alatala ito nan falaxi, a naxa: N ma diin nan Isirayila bɔnsɔnna ra, n ma dii singena. ");
INSERT INTO yal_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","N na a falama i xa, n ma diine yiiba, e xa siga, alogo e xa sa n batu. Xa i tondi, n na i ya dii singen faxama nɛn.’ ” ");
INSERT INTO yal_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","E yi sigatini, e yi yigiya yirena nde yi. Alatala yi fa Musa ralan. A yi wama a faxa feni. ");
INSERT INTO yal_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Sefora yi gɛmɛ xɛnxɛn tongo, a yi a diin banxulan, a yi a kidin din Musa sanna ra, a naxa, “Wunla ito bata i makantan, n ma xɛmɛna!” ");
INSERT INTO yal_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Nayi, Ala yi a lu na. A a fala na banxulan feen nan ma, fa fala “Wunla ito bata i makantan, n ma xɛmɛna.” ");
INSERT INTO yal_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Alatala yi a fala Haruna xa, a naxa, “Siga tonbonni Musa ralandeni.” Haruna yi siga, a yi naralan Musa ra Alaa geyaan ma, a yi a sunbu. ");
INSERT INTO yal_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Alatala Musa xɛxi falan naxan birin nalideni, a na birin ma fe fala Haruna xa, e nun kabanako feen naxanye yi yamarixi. ");
INSERT INTO yal_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musa nun Haruna yi siga, e yi Isirayila fonne birin malan. ");
INSERT INTO yal_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Alatala falan naxan ti Musa xa Haruna yi na birin yɛba, a yi kabanakone liga yamaan yɛtagi. ");
INSERT INTO yal_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Yamaan yi la a ra. E to a mɛ a Alatala bata a ɲɔxɔ lu Isirayila kaane xɔn, a bata yi e tɔrɔn to, e yi e xinbi sin, e Ala batu. ");
INSERT INTO yal_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Na xanbi ra, Musa nun Haruna yi siga Firawona fɛma, e a fala a xa, e naxa, “Alatala, Isirayilaa Ala ito nan falaxi, a naxa, ‘N ma yamaan yiiba, e xa siga, alogo e xa sa sanla raba n batu xinla ma tonbonni.’ ” ");
INSERT INTO yal_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Firawona yi e yabi, a naxa, “Nde Alatala ra, n naxan xui suxuma, n yi Isirayila yamaan lu e siga? N mi Alatala kolon. N mi Isirayila yamaan yiibɛ e siga mumɛ!” ");
INSERT INTO yal_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","E yi a fala, e naxa, “Heburune Ala bata mini nxu xa. Tin nxu xa xii saxan siga ti tonbonni. Nxu xa saraxane ba Alatala nxɔ Ala xa, alogo a nama nxu faxa furen na hanma silanfanna ra.” ");
INSERT INTO yal_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Misiran Mangan yi a fala e xa, a naxa, “Musa nun Haruna, nanfera ɛ yamaan bama e wanla ra? Ɛ siga ɛ wanle ra! ");
INSERT INTO yal_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Iki yamani ito bata gbo ayi yamanani, ɛ a wanli kalama a ma!” ");
INSERT INTO yal_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Na lɔxɔn yɛtɛni Firawona yi yamarini ito fi konyi rawanle nun kuntigine ma, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Ɛ nama fa sɛxɛn so yamaan yii alo a fɔlɔni e yi bitikidin bɔnbɔ, koni e tan yɛtɛɛn xa siga sɛxɛ fendeni. ");
INSERT INTO yal_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","E mɔn yi bitikidin xasabin naxan bɔnbɔma a fɔlɔni, ɛ nama tin e nde ba na ra. Bayo salantenne nan e ra, nanara e sɔnxɔma, e naxa, ‘Tin, nxu xa sa saraxane ba nxɔ Ala xa!’ ");
INSERT INTO yal_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Wanla xa fari sa muxuni itoe yii, alogo e xa lu walɛ. Nayi, e mi fa wule falani itoe xuiin namɛma.” ");
INSERT INTO yal_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Konyi rawanle nun kuntigine yi a fala yamaan xa, e naxa, “Firawona naxa, ‘Nxu mi fa sɛxɛ soma ɛ yii. ");
INSERT INTO yal_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ɛ yɛtɛɛn xa sa sɛxɛn fen ɛ a toɛ dɛnaxan yi, koni sese mi bama ɛ wanla ra.’ ” ");
INSERT INTO yal_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Yamaan yi xuya ayi Misiran yamanan birin yi se gbaxa fendeni naxan sɛ sɛxɛn ɲɔxɔni. ");
INSERT INTO yal_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Konyi rawanle yi gbɛtɛnxi e ra, e naxa, “Ɛ xa ɛ soge keden wanla raɲan, alo ɛ yi a ligama kii naxan yi nxu yi fama sɛxɛn na waxatin naxan yi.” ");
INSERT INTO yal_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Firawona konyi rawanle yi Isirayila kuntigine bɔnbɔ, e naxanye dɔxi, e naxa, “Nanfera ɛ mi bitikidin xasabin bɔnbɔxi xoro nun to yi, alo a fɔlɔni?” ");
INSERT INTO yal_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Isirayila kuntigine yi sa e mawuga Firawona xa, e a fala a xa, e naxa, “Nanfera i ya walikɛne suxuma iki? ");
INSERT INTO yal_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","E mi fa sɛxɛn soma i ya walikɛne yii, koni e a falama nxu xa, e naxa, ‘Ɛ bitikidine bɔnbɔ!’ Muxune nxu tan bulanma i ya walikɛne, anu ɛ muxune nan kalan tima.” ");
INSERT INTO yal_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Firawona yi e yabi, a naxa, “Salayana! Salantenne nan ɛ ra! Nanara, ɛ a falama, ‘Tin, nxu xa sa saraxane ba Alatala xa!’ ");
INSERT INTO yal_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Awa iki, ɛ sa wali, e mi fa sɛxɛ soma ɛ yii, anu se mi bama bitikidi xasabi falaxin na.” ");
INSERT INTO yal_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Isirayila kuntigine yi a kolon nayi, a e tɔrɔma nɛn, e to a mɛ fa fala, “Ɛ mi sese bama ɛ soge keden bitikidin xasabin na.” ");
INSERT INTO yal_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","E minimatɔɔn Firawona konni, e yi naralan Musa nun Haruna ra naxanye yi e mamɛma. ");
INSERT INTO yal_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","E yi a fala e xa, e naxa, “Alatala xa ɛ kɛwanle mato, a ɛ makiti! Ɛ bata nxu raɲaxu Firawona ma e nun a kuntigine alo se kunxin xirina. Ɛ bata silanfanna so e yii e xa nxu faxa.” ");
INSERT INTO yal_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa yi xɛtɛ Alatala fɛma, a yi a fala a xa, a naxa, “Marigina, nanfera i fe ɲaxin ligaxi yamani ito ra? Nanfera i n nafaxi? ");
INSERT INTO yal_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Xabu n siga Firawona fɛma fala tideni i xinla ra, a yamani ito tɔrɔma. I munma i ya yamaan xunba, han to!” ");
INSERT INTO yal_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Alatala yi a fala Musa xa, a naxa, “I ya a toma nɛn sɔnɔn n naxan ligama Firawona ra. N na a karahan, a e yiibama nɛn alogo e xa siga. N na a karahan, a e kedima nɛn a yamanani.” ");
INSERT INTO yal_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ala mɔn yi falan ti Musa xa, a naxa, “Alatala nan n tan na. ");
INSERT INTO yal_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","N mini nɛn Iburahima nun Yaxuba nun Isiyaga xa, n yi n xinla falama e xa nɛn, n naxa, ‘Ala Sɛnbɛ Kanna,’ koni n mi yi n xinla falama e xa, a ‘Alatala.’ ");
INSERT INTO yal_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","N mɔn yi layirin xidi nxu tagi, alogo n xa Kanan yamanan so e yii, e yi xɔɲɛyani dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","N bata Isirayila kaane wuga xuiin mɛ, Misiran kaane naxanye suxi konyiyani, n bata n xaxili lu n ma layirin xɔn ma. ");
INSERT INTO yal_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Nanara, a fala Isirayila kaane xa, fa fala, ‘Alatala nan n tan na, n na ɛ raminima nɛn Misiran kaane yamarin bun. N na ɛ xɔrɔyama nɛn e konyiyaan ma, n yi ɛ xunba n sɛnbɛ gbeeni ɲaxankata magaxuxine xɔn Misiran kaane xili ma. ");
INSERT INTO yal_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","N na ɛ findima nɛn n ma yamaan na. N findi ɛ Ala ra, ɛ yi a kolon a Alatala nan n tan na, ɛ Ala, naxan ɛ raminima Misiran kaane yamarin bun ma. ");
INSERT INTO yal_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","N na ɛ xalima nɛn na bɔxɔni, n yi a so ɛ yii ɛ gbeen na, n na n kɔlɔ bɔxɔn naxan ma fe ra, a n na a soma nɛn Iburahima nun Isiyaga nun Yaxuba yii, n tan Alatala.’ ” ");
INSERT INTO yal_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa yi na falan nali Isirayila kaane ma, koni tɔrɔn nun konyiya xɔdɛxɛn mi tin e Musa xuiin namɛ. ");
INSERT INTO yal_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Siga, i sa falan ti Firawona xa, Misiran mangana, alogo a xa Isirayila kaane beɲin, e mini a yamanani.” ");
INSERT INTO yal_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musa yi Alatala yabi, a naxa, “Xa Isirayila kaane mi n xuiin namɛxi, Firawona n xuiin namɛma di, n tan naxan mi dɛ bolon?” ");
INSERT INTO yal_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Alatala yi falan ti Musa nun Haruna xa, a yi yamarine so e yii Isirayila kaane fe yi e nun Firawona fe yi, Misiran mangana, alogo e xa Isirayila kaane ramini Misiran yamanani. ");
INSERT INTO yal_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Isirayila denbaya kanne xinle ni itoe ra: Isirayilaa dii singena Rubɛn, a tan ma diine ni i ra: Xanɔki, Palu, Xesirɔn e nun Karimi. Ne findixi Rubɛn xabila naaninne benbane nan na. ");
INSERT INTO yal_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeyɔn ma diine ni i ra: Yemuyeli, Yamin, Ohadi, Yakin, Soxara, e nun Kanan kaa gilɛna dii xɛmɛ Sayuli. Ne findixi Simeyɔn xabila senninne benbane nan na. ");
INSERT INTO yal_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lewi a diine xinle ni itoe ra e nun e yixɛtɛne: Gɛrisɔn, Kehati e nun Merari. Lewi ɲɛɛ kɛmɛ tonge saxan e nun solofere sɔtɔ nɛn siimayaan na. ");
INSERT INTO yal_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gɛrisɔn ma diine yi findi xabila firin benbane ra: Libini nun Simeyi. ");
INSERT INTO yal_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kehati a diine ni i ra: Amirama, Yisehari, Xebiron e nun Yusiyɛli. Kehati ɲɛɛ kɛmɛ ɲɛɛ tonge saxan e nun saxan sɔtɔ nɛn siimayaan na. ");
INSERT INTO yal_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari a diine ni i ra: Maxali nun Musi. Lewi xabilane benbane nan ne ra mayixɛtɛ yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amirama yi a baba magilɛ Yokebedi tongo a ɲaxanla ra, a yi Haruna nun Musa bari a xa. Amirama yi ɲɛɛ kɛmɛ tonge saxan e nun saxan sɔtɔ siimayaan na. ");
INSERT INTO yal_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yisehari a diine ni i ra: Kora, Nefegi e nun Sikiri. ");
INSERT INTO yal_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Yusiyɛli a diine ni i ra: Mikayeli, Elisafan e nun Sitiri. ");
INSERT INTO yal_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruna yi Aminadabo a dii tɛmɛ Eliseba tongo a ɲaxanla ra. Naxason magilɛn nan yi Eliseba ra. A yi Nadaba nun Abihu nun Eleyasari nun Itamara bari a xa. ");
INSERT INTO yal_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora diine ni i ra: Asiri, Elikana e nun Abiyasafa. Kora xabila saxanne benbane nan ne ra. ");
INSERT INTO yal_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Harunaa dii Eleyasari yi Putiyeli a dii tɛmɛn tongo a ɲaxanla ra, a yi Finexasi bari a xa. Lewi bɔnsɔnna denbaya xunne nan ne ra, e xabila yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","E tan ni i ra Haruna nun Musa, Alatala a fala ne nan xa, a naxa, “Ɛ Isirayila kaane ganle ramini Misiran yi.” ");
INSERT INTO yal_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","E tan nan falan ti Firawona xa, Misiran Mangana, alogo e xa Isirayila kaane ramini Misiran yi. Na Musa nun Haruna nan itoe ra. ");
INSERT INTO yal_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Alatala falan ti nɛn Musa xa Misiran yamanani, ");
INSERT INTO yal_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","a naxa, “N tan nan Alatala ra. A fala Firawona xa, Misiran Mangana, n naxan birin falama i xa.” ");
INSERT INTO yal_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Koni Musa yi a fala Alatala xa, a naxa, “Bayo n dɛɛn mi fatan fala faɲine tiyɛ a xa, Firawona n xuiin namɛma di?” ");
INSERT INTO yal_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Alatala yi a fala Musa xa, a naxa, “A mato, n ni i findima nɛn Ala ra Firawona xa, i tada Haruna luma nɛn alo i ya nabina. ");
INSERT INTO yal_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","N na i yamari naxan na, i na fala, i tada Haruna yi falan ti Firawona xa, alogo a xa tin Isirayila kaane yi mini a yamanani. ");
INSERT INTO yal_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Koni, n tan Firawona bɔɲɛni xɔdɔxɔma nɛn, n yi n ma taxamasenne nun kabanakone rawuya ayi Misiran yamanani. ");
INSERT INTO yal_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Firawona mi ɛ xuiin namɛma mumɛ! N na n sɛnbɛn yitama nɛn Misiran na ɲaxankata magaxuxine yi, n yi n ma ganla ramini Misiran yamanani, Isirayila, n ma yamana. ");
INSERT INTO yal_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Misiran kaane a kolonma nɛn a n tan nan Alatala ra, n na n yiini bandun Misiran kaane xili ma, n yi Isirayila kaane ramini na yi.” ");
INSERT INTO yal_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Alatala naxan yamari, Musa nun Haruna yi na birin liga. ");
INSERT INTO yal_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa siimayaan yi ɲɛɛ tonge solomasɛxɛ, Haruna siimayaan yi ɲɛɛ tonge solomasɛxɛ e nun saxan, e falan ti Firawona xa waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Alatala yi a fala Musa nun Haruna xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Xa Firawona a fala ɛ xa, a naxa, ‘Ɛ kabanako fena nde liga!’ Nayi, i yi a fala Haruna xa, i naxa, ‘I ya dunganna tongo, i yi a bira Firawona yɛtagi.’ A findima nɛn saɲin na.” ");
INSERT INTO yal_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musa nun Haruna yi siga Firawona fɛma, Alatala yamarin naxan soxi e yii, e na liga. Haruna yi a dunganna bira Firawona nun a kuntigine yɛtagi, a findi saɲin na. ");
INSERT INTO yal_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Koni Firawona fan yi fekolonne nun seri kanne nun Misiran woyimɛne xili, ne fan yi na fe sifan liga e dalili feene xɔn. ");
INSERT INTO yal_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","E birin yi e dunganne bira, e findi saɲine ra. Koni Harunaa dunganna yi e dunganne gerun. ");
INSERT INTO yal_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Firawona bɔɲɛn yi xɔdɔxɔ, a mi Musa nun Harunaa falan namɛ alo Alatala a falaxi kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Alatala yi a fala Musa xa, a naxa, “Firawona bɔɲɛni xɔdɔxɔxi, a tondixi yamaan beɲindeni e siga. ");
INSERT INTO yal_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Siga Firawona fɛma xɔtɔnni. A na siga Nila baan dɛ, i siga a ralandeni. Dunganna naxan maxɛtɛ saɲin na i na suxu i yii. ");
INSERT INTO yal_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","I xa a fala Firawona xa, i naxa, ‘Alatala, Heburune Ala, na bata n nafa i fɛma a n xa a fala, a i xa a yamaan yiiba, e xa siga, alogo e xa sa a batu tonbonni koni han to i munma i tuli mati. ");
INSERT INTO yal_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Alatala ito nan falaxi, a naxa, “I fama a kolondeni n ma wanla nan xɔn a Alatala nan n tan na.” Dunganna naxan n yii, n Nila baa igen garinma nɛn na ra, a maxɛtɛ wunla ra. ");
INSERT INTO yal_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Yɛxɛn naxanye Nila baani, ne faxama nɛn. Igeni lɔxɔma nɛn. Misiran kaane mi fa nɔɛ a igen minɲɛ.’ ” ");
INSERT INTO yal_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Alatala yi a fala Musa xa, a naxa, “A fala Haruna xa: i ya dunganna tongo, i yi i yiini bandun Misiran igene xun ma: Baane, xudene, darane, e nun tigine birin. E findima nɛn wunla ra. Wunla luma nɛn Misiran yamanan yiren birin yi, hali ige sase wudi daxine nun fɛɲɛne kui.” ");
INSERT INTO yal_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Alatala yamarin naxan fi Musa nun Haruna ma, e yi na liga. Haruna yi a dunganni te Nila baan xun ma, a yi igen garin Firawona nun a kuntigine yɛtagi. Igen birin yi maxɛtɛ wunla ra. ");
INSERT INTO yal_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Yɛxɛn naxanye yi Nila baani, ne yi faxa. Igen yi lɔxɔ han Misiran kaane mi yi fa nɔɛ baa igen minɲɛ. Wunla yi lu Misiran yamanan yiren birin yi. ");
INSERT INTO yal_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Koni Misiran woyimɛne fan yi na fe sifane liga e dalili feene xɔn. Firawona bɔɲɛn yi xɔdɔxɔ, a mi Musa nun Haruna xuiin namɛ alo Alatala a fala kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Firawona yi xɛtɛ, a siga a banxini, a mi a yengi lu na feene xɔn. ");
INSERT INTO yal_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Misiran kaane birin yi yinle ge Nila baan dɛxɔnni alogo e xa e min, amasɔtɔ e mi yi nɔɛ baa igen minɲɛ. ");
INSERT INTO yal_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Alatala yelin Nila baan findɛ wunla ra waxatin naxan yi, xii solofere yi dangu na xanbi ra. ");
INSERT INTO yal_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Alatala yi a fala Musa xa, a naxa, “Siga Firawona fɛma, i yi a fala a xa, i naxa, ‘Alatala falani ito nan tixi, a naxa: N ma yamaan yiiba, a xa siga alogo e xa sa n batu. ");
INSERT INTO yal_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Xa i tondi e beɲinɲɛ, n na i ya yamanan birin ɲaxankatama nɛn, n xunɲɛne radin a ma. ");
INSERT INTO yal_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Nila baan nafema nɛn xunɲɛne ra. E tema nɛn, e so i ya manga banxin kui, i xideni, i ya sadeni, i ya kuntigine banxine kui, i ya yamana banxine kui, i ya buru gandene yi, e nun i ya buru bɔnbɔdene kui. ");
INSERT INTO yal_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Xunɲɛne tema nɛn i tan nun i ya yamaan nun i ya kuntigine ma.’ ” ");
INSERT INTO yal_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Alatala yi a fala Musa xa, a naxa, “A fala Haruna xa, i naxa, ‘I ya dunganni bandun baane nun xudene nun darane xun ma, i yi xunɲɛne rate Misiran yamanani.’ ” ");
INSERT INTO yal_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Haruna yi a yiini bandun Misiran igene xun ma, xunɲɛne yi te Misiran yamanan birin yi. ");
INSERT INTO yal_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Koni Misiran woyimɛne fan yi na fe sifane liga e dalili feene xɔn. E fan yi xunɲɛne rate Misiran yamanani. ");
INSERT INTO yal_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Firawona yi Musa nun Haruna xili, a naxa, “Ɛ Alatala maxandi n xa alogo a xa xunɲɛne masiga n na, e nun n ma yamaan na. N na i ya yamaan beɲinɲɛ, e siga, alogo e xa sa saraxane ba Alatala xa.” ");
INSERT INTO yal_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Musa yi a fala Firawona xa, a naxa, “Na binyen xa lu i tan xa, i yi a fala, n lan n xa maxandin ti ɛ nun i ya kuntigine xa waxatin naxan yi, e nun i ya yamaan xa, alogo Ala xa xunɲɛne masiga ɛ nun ɛ banxine ra. E yi siga Nila baa igeni.” ");
INSERT INTO yal_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","A yi yabin ti, a naxa, “Tila.” Musa yi a fala, a naxa, “A ligama nɛn na kiini alogo i xa a kolon a muxu yo mi maliga Alatala ra, nxɔ Ala. ");
INSERT INTO yal_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Xunɲɛne e masigama nɛn i ra e nun i ya banxine nun i ya kuntigine nun i ya yamana. E yi lu Nila baani.” ");
INSERT INTO yal_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Musa nun Haruna yi mini Firawona fɛma. Musa yi a xuini te Alatala ma xunɲɛne fe ra, Ala naxanye rafa Firawona ma. ");
INSERT INTO yal_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa yi naxan maxɔdinma, Alatala yi na liga. Xunɲɛne yi faxa banxine kui e nun tandene nun xɛɛne ma. ");
INSERT INTO yal_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","E yi e makɔ, e e sa e bode fari, yamanan xirin yi mini e fe ra. ");
INSERT INTO yal_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Firawona to a to a feene bata mafisa, a bɔɲɛn mɔn yi xɔdɔxɔ. A mi Musa nun Haruna xuiin namɛ, alo Alatala a falaxi kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Alatala yi a fala Musa xa, a naxa, “A fala Haruna xa, i naxa, ‘I ya dunganni bandun, i bɔxɔni garin. Gbangbanna maxɛtɛma nɛn sosone ra Misiran yamanan birin yi.’ ” ");
INSERT INTO yal_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","E yi na liga. Haruna yi a dunganni bandun a yii, a bɔxɔn gbangbanni garin, sosone yi fa muxune nun subene xili ma. Bɔxɔn gbangbanna birin yi maxɛtɛ sosone ra Misiran yamanan birin yi. ");
INSERT INTO yal_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Koni, woyimɛne to kata e xa sosone ramini e dalili feene xɔn, e mi nɔ. Sosone yi muxune nun subene ma. ");
INSERT INTO yal_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Woyimɛne yi a fala Firawona xa, e naxa, “Ala sɛnbɛn nan ito ra!” Koni Firawona bɔɲɛn yi xɔdɔxɔ, a mi a tuli mati Musa nun Haruna ra, alo Alatala a fala kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Alatala yi a fala Musa xa, a naxa, “Keli xɔtɔn, i siga Firawona ralandeni. A sigama nɛn xude dɛni. I yi a fala a xa, i naxa, ‘Alatala falani ito nan tixi, a naxa: N ma yamaan beɲin, e xa siga alogo e xa sa n batu. ");
INSERT INTO yal_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Xa i mi tin n ma yamaan yiibɛ e siga, n xɛnne rafama nɛn i tan nun i ya kuntigine nun i ya yamaan xili ma, e nun i ya banxine kui. Misiran kaane banxine rafema nɛn xɛnne ra, bɔxɔn yi rafe. ");
INSERT INTO yal_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Koni na lɔxɔni, n Gosen yamanan luma nɛn a danna n ma yamaan dɛnaxan yi. Xɛnne mi fama mɛnni, alogo i xa a kolon a n tan Alatala walima yamanani ito yi. ");
INSERT INTO yal_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","N tagi rabaan luma nɛn n ma yamaan nun i ya yamaan tagi. Na kabanako fe taxamasenna ligama nɛn tila.’ ” ");
INSERT INTO yal_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Alatala yi na liga. Xɛri wuyaxi yi so Firawona banxini e nun a kuntigine banxine yi. Misiran yamanan birin yi kala xɛnne ra. ");
INSERT INTO yal_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Firawona yi Musa nun Haruna xili, a naxa, “Ɛ siga, ɛ sa saraxane ba ɛ Ala xa yamanani ito yi.” ");
INSERT INTO yal_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Musa yi a yabi, a naxa, “A mi lan a xa liga na ki. Amasɔtɔ nxu saraxan naxanye bama Alatala xa, nxɔ Ala, ne findɛ fe haramuxin na Misiran kaane yɛɛ ra yi. Xa nxu saraxa haramuxin ba Misiran kaane yɛɛ xɔri, e mi nxu magɔlɔnɲɛ ba? ");
INSERT INTO yal_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nxu xii saxan sigan nan tima tonbonni, nxu yi saraxane ba Alatala xa, nxɔ Ala, alo a nxu yamari kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Firawona yi a fala, a naxa, “N na ɛ yiibama nɛn alogo ɛ xa siga, ɛ yi saraxane ba Alatala xa, ɛ Ala, tonbonni. Koni ɛ nama ɛ makuya. Awa, ɛ xa Ala maxandi n xa.” ");
INSERT INTO yal_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Musa yi a yabi, a naxa, “N kelima nɛn i fɛma, n na Alatala maxandi. Tila, xɛnne masigama nɛn Firawona nun a kuntigine nun a yamaan na. Koni Firawona nama fa yanfan ti, a tondi yamaan yiibɛ siga saraxane badeni Alatala xa.” ");
INSERT INTO yal_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musa yi keli Firawona fɛma, a yi Alatala maxandi. ");
INSERT INTO yal_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Musa naxan maxɔdin, Alatala yi na liga. Xɛnne yi e masiga Firawona ra e nun a kuntigine nun a yamaan na. Keden mi lu. ");
INSERT INTO yal_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Koni Firawona mɔn yi a bɔɲɛni xɔdɔxɔ, a mi tin yamaan yiibɛ. ");
INSERT INTO yal_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Alatala yi a fala Musa xa, a naxa, “Siga Firawona fɛma, i yi a fala a xa, i naxa, ‘Alatala, Heburune Ala ito nan falaxi, a naxa, “N ma yamaan yiiba, e xa siga, alogo e xa sa n batu.” ");
INSERT INTO yal_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Xa i tondi e beɲinɲɛ e xa siga, xa i lu tondɛ, ");
INSERT INTO yal_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Alatala fitina furen nafama nɛn i ya xuruseene ma naxanye xɛɛne ma, soone, sofanle, ɲɔgɔmɛne, ɲingene, yɛxɛɛne e nun siine. ");
INSERT INTO yal_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Koni Alatala Isirayila xuruseene nun Misiran xuruseene tagi rabama nɛn, alogo Isirayila kaane gbeene sese nama faxa.’ ” ");
INSERT INTO yal_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Alatala bata yi waxatin sa, a naxa, “N na ligama nɛn yamanani ito yi tila.” ");
INSERT INTO yal_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Na xɔtɔn bode Alatala yi na liga. Misiran kaane xuruseene birin yi faxa. Koni, Isirayila kaane xuruse keden mi faxa. ");
INSERT INTO yal_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firawona yi xɛrane rasiga, e fa a to a Isirayila xuruse yo mi faxaxi. Koni Firawona bɔɲɛn yi siga xɔdɔxɛ, a mi yamaan yiiba mumɛ, e siga. ");
INSERT INTO yal_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Alatala yi a fala Musa nun Haruna xa, a naxa, “Ɛ yiine rafe sulun tɛɛn xubeni, Musa xa a woli kore Firawona yɛtagi. ");
INSERT INTO yal_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","A xuyama ayi nɛn Misiran yamanan birin xun ma, a findi sete furen na Misiran yamanan muxune nun a subene birin ma.” ");
INSERT INTO yal_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","E yi sulun tɛɛn xuben tongo, e siga Firawona fɛma. Musa yi a woli kore, sete furen yi fa yamanan muxune nun a subene birin ma. ");
INSERT INTO yal_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Koni woyimɛne mi yi nɔɛ tiyɛ Musa yɛtagi, bayo setene yi e ma alo Misiran kaane birin. ");
INSERT INTO yal_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Koni, Alatala yi Firawona bɔɲɛni xɔdɔxɔ, a mi Musa nun Haruna xuiin namɛ mumɛ, alo Alatala naxan fala Musa xa. ");
INSERT INTO yal_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Alatala yi a fala Musa xa, a naxa, “Keli xɔtɔn, i siga Firawona fɛma. I yi a fala a xa fa fala Alatala Heburune Ala ito nan falaxi, a naxa, ‘N ma yamaan yiiba, e xa siga alogo e xa sa n batu. ");
INSERT INTO yal_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Xanamu, n nan n ma fitina feene sɛnbɛ soma nɛn i tan nun i ya kuntigine nun i ya yamaan xili ma, alogo i xa a kolon a n ɲɔxɔn mi na bɔxɔn fari. ");
INSERT INTO yal_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Xa n yi n yiini bandun i ma nun, n yi fitina furen nasigama nɛn i ma nun, i tan nun i ya yamaan birin yi raxɔrima nɛn bɔxɔ xɔnna fari. ");
INSERT INTO yal_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Koni n bata i lu i nii ra, alogo i xa n sɛnbɛn to, n xinla yi rali dunuɲa yiren birin yi. ");
INSERT INTO yal_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Xa i mɔn n ma yamaan makankan, i mi tin e siga, ");
INSERT INTO yal_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","i yanyi tila n balabalan kɛsɛn nagodoma nɛn, naxan ɲɔxɔn munma fa Misiran yi xabu a masɛgɛ lɔxɔni han to. ");
INSERT INTO yal_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Nayi, i ya xuruseene nun i yii seene birin naxanye xɛɛn ma, i xa ne ramara. Bayo balabalan kɛsɛn fama nɛn muxune nun subene birin ma naxanye xɛɛn ma. Naxanye mi rasoxi banxine yi, ne faxama nɛn.’ ” ");
INSERT INTO yal_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Firawona kuntigin naxanye gaxu Alatalaa falan yɛɛ ra, ne yi e konyine nun e xuruseene raso banxine kui. ");
INSERT INTO yal_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Koni naxanye mi e yengi lu Alatalaa falan xɔn, ne yi e walikɛne nun e xuruseene lu xɛɛne ma. ");
INSERT INTO yal_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Alatala yi a fala Musa xa, a naxa, “I yiini te kore, balabalan kɛsɛn xa godo Misiran yamanan yiren birin yi muxune nun subene ma, e nun siseene birin ma Misiran xɛɛne birin yi.” ");
INSERT INTO yal_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa yi a dunganni te kore, Alatala yi galanna nun balabalan kɛsɛn nafa, kuye sarinna yi bɔxɔn li. Awa, Alatala yi balabalan kɛsɛn nafa Misiran yamanani. ");
INSERT INTO yal_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Balabalan kɛsɛn yi fa, kuyen yi sarin, a sɛnbɛn yi gbo ayi, a ɲɔxɔn munma yi fa Misiran yi xabu a findi yamanan na. ");
INSERT INTO yal_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Balabalan kɛsɛne yi muxune nun subene birin magɔlɔn xɛɛne ma, a yi siseene birin kala, a wudine birin yi gira Misiran yamanan birin yi. ");
INSERT INTO yal_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gosen yamanani, Isirayila kaane yi dɛnaxan yi, balabalan kɛsɛ mi fa mɛnni. ");
INSERT INTO yal_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Firawona yi Musa nun Haruna xili, a naxa, “Iki, n bata yulubin liga, Alatala nan tinxin, n tan nun n ma yamaan sɔnna na a ra. ");
INSERT INTO yal_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ɛ Alatala maxandi, nxu bata wasa galanna nun balabalan kɛsɛn na. N na ɛ yiibɛ ɛ siga. Ɛ mi fa makankanma mumɛ!” ");
INSERT INTO yal_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa yi a fala a xa, a naxa, “N na mini taani, n nan n yiine tiyɛ Alatala xa, galanna nun balabalan kɛsɛn yi dan, alogo i xa a kolon a Alatala nan gbee bɔxɔn na. ");
INSERT INTO yal_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Koni n na a kolon i tan nun i ya kuntigine, ɛ mɔn mi gaxuma Marigina Alatala yɛɛ ra.” ");
INSERT INTO yal_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Gɛsɛn nun fundenna nan kala, bayo fundenna yi sabatixi, gɛsɛn yi fugaxi. ");
INSERT INTO yal_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Maala nun murutun mi kala bayo e mi a liin sinma. ");
INSERT INTO yal_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa yi keli Firawona fɛma, a mini taani, a a yiine ti Alatala xa. Galanna nun balabalan kɛsɛn yi dan, tulen mi fa fa bɔxɔn fari. ");
INSERT INTO yal_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Firawona to a to a tulen nun balabalan kɛsɛn nun galanna bata dan, a mɔn yi yulubin liga. A yi a bɔɲɛni xɔdɔxɔ, e nun a kuntigine. ");
INSERT INTO yal_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Firawona bɔɲɛn yi xɔdɔxɔ, a mi tin Isirayila kaane yi siga, alo Alatala a fala yamaan xa kii naxan yi fata Musa ra. ");
INSERT INTO yal_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Alatala yi a fala Musa xa, a naxa, “Siga Firawona fɛma, amasɔtɔ n na a bɔɲɛn xɔdɔxɔma e nun a kuntigine, alogo n xa n ma kabanako feene liga e tagi, ");
INSERT INTO yal_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","alogo i xa a fala i ya diine nun mamandenne xa n Misiran kaane ɲaxankata kii naxan yi, n kabanako feene liga e tagi. Ɛ yi a kolon a Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musa nun Haruna yi siga Firawona fɛma, e yi a fala a xa, e naxa, “Alatala Heburune Ala ito nan falaxi, a naxa, ‘I tondɛ i magodɛ n yɛtagi han waxatin mundun yi? N ma yamaan yiiba, e xa siga, alogo e xa sa n batu. ");
INSERT INTO yal_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Xa i tondi n ma yamaan beɲinɲɛ e xa siga, tila n tuguminne rafama nɛn i ya yamanan yiren birin yi. ");
INSERT INTO yal_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","E dɔxɔma nɛn bɔxɔn birin fari, bɔxɔn mi fa nɔɛ toɛ. Balabalan kɛsɛn naxan luxi ɛ yii, e na nan donma hali wudin naxanye birin xɛɛne ma. ");
INSERT INTO yal_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","E i ya banxine rafema nɛn, e nun i ya kuntigine banxine, e nun Misiran kaane birin ma banxine. I fafane nun ne benbane munma a ɲɔxɔn to xabu e dɔxɔ yamanani ito yi han to.’ ” Musa yi siga, a keli Firawona fɛma. ");
INSERT INTO yal_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Firawona kuntigine yi a fala a xa, e naxa, “Xɛmɛni ito luyɛ alo luti ratixina en yɛɛ ra han waxatin mundun yi? Muxuni itoe yiiba, e xa siga, e xa sa Alatala batu, e Ala. I mɔn mi a to Misiran kala feni?” ");
INSERT INTO yal_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","E yi Musa nun Haruna xili Firawona fɛma. A yi a fala, a naxa, “Ɛ siga Alatala batudeni, ɛ Ala. Koni, nde sigama?” ");
INSERT INTO yal_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa yi a yabi, a naxa, “Nxu nun nxɔ diine nun nxɔ fonne nan sigama, dii xɛmɛne nun dii tɛmɛne, xuruse xunxurine nun a xungbene, amasɔtɔ nxu sa sanla nan nabama Alatalaa binyeni.” ");
INSERT INTO yal_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Firawona yi a fala e xa, a naxa, “Xa n tin, ɛ nun ɛ diine yi siga, fɔ n xa n ɲungu ɛ ma ɲɛ? Bayo ɛ mi fa fama. Ɛ fe ɲaxin nan fɔxɔ ra yati! ");
INSERT INTO yal_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ɛn-ɛn de! Ɛ tan xɛmɛne gbansanna xa siga, ɛ Alatala batu, bayo ɛ na nan maxɔdinxi.” E yi e kedi Firawona yɛtagi. ");
INSERT INTO yal_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Alatala yi a fala Musa xa, a naxa, “I yiini bandun Misiran yamanan xun ma alogo tuguminne xa te Misiran yamanani, e yi siseene birin don xɛɛne ma, balabalan kɛsɛn naxanye birin luxi.” ");
INSERT INTO yal_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa yi a dunganni bandun Misiran yamanan xun ma. Alatala yi foyen nafa na yanyin nun kɔɛɛn birin na keli sogeteden binni. Benun xɔtɔnni, foyen bata fa tuguminne ra. ");
INSERT INTO yal_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Tuguminne yi te Misiran yamanan birin yi, e wara ayi yiren birin yi. A ɲɔxɔn munma yi liga nun, a mɔn mi fa ligama sɔnɔn! ");
INSERT INTO yal_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","E yi lu bɔxɔn birin ma han e na yifɔrɔ. E siseene nun se bogine birin don xɛɛne ma, balabalan kɛsɛn naxanye lu. Ɲingi yo mi lu wudine nun siseene ma Misiran yamanan birin yi. ");
INSERT INTO yal_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Firawona yi Musa nun Haruna xili mafurɛn! A yi a fala e xa, a naxa, “N bata yulubin liga Alatala ra, ɛ Ala, e nun ɛ tan. ");
INSERT INTO yal_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Iki, ɛ mɔn xa n mafelu yulubini ito a fe ra, ɛ Alatala maxandi, ɛ Ala alogo a xa ɲaxankata faxa tiini ito masiga n na.” ");
INSERT INTO yal_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa yi mini Firawona konni, a Alatala maxandi. ");
INSERT INTO yal_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Alatala yi foye gbeen nafa keli sogegododen binni, naxan tuguminne xali, a e woli Gbala Baani, hali tugumin keden mi lu Misiran bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Alatala yi Firawona bɔɲɛn xɔdɔxɔ, a mi tin Isirayila kaane beɲinɲɛ. ");
INSERT INTO yal_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Alatala yi a fala Musa xa, a naxa, “I yiini te kore, dimi gbeen xa sin Misiran yamanan birin yi, han muxune yɛɛne yi rafɔrɔ ayi.” ");
INSERT INTO yal_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa yi a yiini te kore, dimi gbeen yi so Misiran yamanan birin yi, xii saxan. ");
INSERT INTO yal_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Muxu yo mi yi fa a bode toma, muxu yo mi yi kelima a konni na xii saxanna bun ma. Koni kɛnɛnna yi Isirayila kaane konne yi. ");
INSERT INTO yal_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Firawona yi Musa xili, a yi a fala a xa, a naxa, “Ɛ siga ɛ Alatala batu. Ɛ diine xa siga ɛ fɔxɔ ra. Xuruseene nan tun luma be.” ");
INSERT INTO yal_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa yi a yabi, a naxa, “Na mi a ra! Nxu naxan bama saraxan nun saraxa gan daxin na Alatala xa, nxɔ Ala, fɔ i xa na xuruseene so nxu yii. ");
INSERT INTO yal_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nxɔ xuruseene fan sigama nɛn, keden mi luun be, amasɔtɔ nxu makoon ne nan ma nxu nɛma Alatala batuɛ, nxɔ Ala. Benun nxu xa so, nxu mi a kolon nxu naxan nawalima Alatala batudeni.” ");
INSERT INTO yal_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Alatala yi Firawona bɔɲɛn xɔdɔxɔ, a mi tin e beɲinɲɛ e yi siga. ");
INSERT INTO yal_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firawona yi a fala Musa xa, a naxa, “Mini n konni! I yɛtɛ ratanga i fa feen ma n yɛtagi sɔnɔn! I na fa n yɛtagi lɔxɔn naxan yi, i faxama nɛn.” ");
INSERT INTO yal_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa yi a yabi, a naxa, “I bata a fala! N mi fa fama i yɛtagi sɔnɔn!” ");
INSERT INTO yal_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Awa, Alatala bata yi a fala Musa xa, a naxa, “N mɔn fitina fe keden nafama nɛn Firawona ma e nun Misiran yamanana. Na xanbi ra, a ɛ yiibama nɛn alogo ɛ xa keli be. A na tin fa, a yɛtɛna ɛ kedima nɛn be. ");
INSERT INTO yal_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Falan ti yamaan xa alogo xɛmɛne nun ɲaxanle birin xa e dɔxɔ bodene xandi gbeti nun xɛma muranne yi.” ");
INSERT INTO yal_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Alatala bata yi a liga a Isirayila yamaan yi rafan Misiran kaane ma. Firawona kuntigine nun a yamaan bata yi Musa yɛtɛɛn binya Misiran yamanani. ");
INSERT INTO yal_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa yi a fala Firawona xa, a naxa, “Alatala ito nan falaxi, a naxa, ‘Kɔɛ tagini, n danguma nɛn Misiran birin yi. ");
INSERT INTO yal_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Dii singene birin faxama nɛn Misiran yamanani, keli Firawona dii singen ma naxan dɔxi mangayani, han konyi gilɛna dii singen naxan seen dinma, e nun subene birin ma dii singene. ");
INSERT INTO yal_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Wuga xui gbeen tema nɛn Misiran yamanan birin yi, a ɲɔxɔn munma yi liga nun, a mɔn mi fa ligama sɔnɔn. ");
INSERT INTO yal_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Koni Isirayila kaane yɛ, hali baren mi wonwonɲɛ muxun ma hanma suben ma.’ Nayi, ɛ a kolonma nɛn a Alatala Misiran nun Isirayila tagi rabaxi. ");
INSERT INTO yal_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Nayi, i ya kuntigini itoe birin fama nɛn n fɛma, e xinbi sin n yɛtagi, e yi a fala, e naxa, ‘Siga, i tan nun yamaan naxan biraxi i fɔxɔ ra!’ Na xanbi ra, n sigama nɛn.” Musa xɔlɔxi gbeen yi keli Firawona fɛma. ");
INSERT INTO yal_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Alatala yi a fala Musa xa, a naxa, “Firawona mi i xuiin namɛma, alogo n ma kabanako feene xa wuya ayi Misiran yamanani.” ");
INSERT INTO yal_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa nun Haruna yi kabanakoni itoe birin liga Firawona yɛtagi, koni Alatala yi Firawona bɔɲɛn xɔdɔxɔ a mi tin Isirayila kaane beɲinɲɛ e xa mini a yamanani. ");
INSERT INTO yal_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Alatala yi a fala Musa nun Haruna xa Misiran yamanani, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Kikeni ito findima ɛ xa ɲɛɛn kike singen nan na. ");
INSERT INTO yal_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ɛ xa a fala Isirayila yamaan xa, a kikeni ito xii fude lɔxɔni, denbaya kanna birin xa yɛxɛɛ dii keden tongo a denbayaan xa, denbaya yo denbaya yɛxɛɛ dii keden. ");
INSERT INTO yal_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Denbayaan naxan muxuye mi wuya, e mi nɔɛ yɛxɛɛ dii kedenna ɲanɲɛ, e nun e dɔxɔ boden xa yɛxɛɛ diina nde yitaxun alogo yamaan naxan donɲɛ, birin ma denbayaan xa na sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ɛ xa kontonna ɲɛɛ kedenna sugandi fɛ mi naxan na hanma kɔtɔna. ");
INSERT INTO yal_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ɛ xa a ramara han kikeni ito xii fu nun naaninde lɔxɔni, Isirayila kaan birin xa a gbee xuruseen kɔɛ raxaba ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","E yi a wunla tongo, e yi a susan banxine dɛɛne xun ma wudin ma e nun dɛɛn wudi firinne ma e a donma banxin naxan kui. ");
INSERT INTO yal_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Na kɔɛ yɛtɛɛn na, e xa a suben gan, e yi a don e nun ɲɔxɔnde dɛ xɔlɛne nun burun natetarena. ");
INSERT INTO yal_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ɛ nama a suben don a xinden na hanma a ɲinxina, koni a xa gan e nun a xunna nun a sanne nun a kui seene. ");
INSERT INTO yal_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ɛ nama sese lu han xɔtɔnni. Xa nde lu, xɔtɔnni ɛ xa a dɔnxɛn sa tɛɛni. ");
INSERT INTO yal_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ɛ xa a don ikiini: ɛ xa ɛ maxidi, ɛ yi ɛ sankidine so ɛ sanni, ɛ dunganna suxu ɛ yii, ɛ yi a don mafurɛn! Halagi Tiin Dangu Lɔxɔn Sanla na a ra Alatala xa. ");
INSERT INTO yal_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Na kɔɛɛn na, n danguma nɛn Misiran yamanani, n dii singene birin faxama nɛn, muxun nun subena. N Misiran kaane gbee alane birin ɲaxankatama nɛn. Alatala nan n tan na. ");
INSERT INTO yal_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Wunla naxan banxin ma, na findima taxamasenna nan na ɛ xa. N na wunla to, n danguma nɛn ɛ xun ma. Fitina fe mi ɛ liyɛ, n na Misiran yamanan ɲaxankata waxatin naxan yi.” ");
INSERT INTO yal_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ɲɛɛ yo ɲɛɛ sanli ito na feene rabirama ɛ ma nɛn waxati famatɔne yi. Ɛ na sanla rabama nɛn Alatala xa alo habadan sariyana. ");
INSERT INTO yal_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Xii soloferen bun ma, ɛ buru ratetaren donma nɛn. Xii singen na a li, ɛ buru rate seen bama nɛn ɛ banxine kui. Amasɔtɔ naxan na seen don burun nate seen naxan yi, keli xii singen ma han xii soloferede lɔxɔni, n na a kedima nɛn Isirayila yamaan yɛ. ");
INSERT INTO yal_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Lɔxɔ singeni, ɛ malan sariɲanxin tima nɛn. Ɛ nde fan tima nɛn a xii soloferede lɔxɔni. Ɛ nama wali yo kɛ lɔxɔni itoe ma fɔ kudi soona yamaan xa, alogo ɛ xa ɛ dɛge. Ɛ nɔɛ na nan tun ligɛ. ");
INSERT INTO yal_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ɛ xa Buru Ratetaren Sanla raba, amasɔtɔ n na ɛ ganle raminixi Misiran yi na lɔxɔn yɛtɛni. Ɛ xa na lɔxɔn sanla raba alo habadan sariyana ɛ yixɛtɛne birin xa waxati famatɔne yi. ");
INSERT INTO yal_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ɲɛɛn kike singeni, ɛ burun natetaren donma nɛn kiken xii fu nun naaninde lɔxɔn ɲinbanna ra, han xii mɔxɔɲɛn nun kedende lɔxɔn ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Buru rate seen mi luma ɛ banxine kui xii solofere bun ma. Naxan na seen don buru rate seen naxan yi, na kedima nɛn Isirayila yamaan yɛ, xa a findi xɔɲɛn na hanma Isirayila kaana. ");
INSERT INTO yal_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ɛ nama sese don buru rate seen naxan yi. Ɛ banxine yi, ɛ buru ratetaren nan donma.” ");
INSERT INTO yal_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa yi Isirayila fonne birin xili, a a fala e xa, a naxa, “Ɛ siga, ɛ yɛxɛɛn hanma siin tongo ɛ denbayane xa, ɛ a faxa Halagi Tiin Dangu Lɔxɔn Sanla fe ra. ");
INSERT INTO yal_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Na xanbi ra, ɛ hisopi wudi yiin tongo, ɛ a sin wunli, ɛ a susan dɛɛn xun ma wudin nun dɛɛn wudi firinne ma. Ɛ sese nama mini ɛ banxine kui han xɔtɔnni. ");
INSERT INTO yal_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Alatala na dangu yamanani Misiran kaane faxadeni, xa a wunla to dɛɛn xun ma nun a dɛxɔnne ma, Alatala danguma nɛn na banxin xun ma. A mi tinma halagi tiin yi so ɛ banxini ɛ faxadeni.” ");
INSERT INTO yal_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Ɛ yamarini itoe suxuma nɛn alo habadan sariyana ɛ yɛtɛ xa e nun ɛ yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Alatala bɔxɔn naxan soma ɛ yii, a naxan falaxi, ɛ na so mɛnni, ɛ sanli ito raba. ");
INSERT INTO yal_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ɛ diine na ɛ maxɔdin, e naxa, ‘Sariyani ito bunna nanse ra ɛ tan xa?’ ");
INSERT INTO yal_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Ɛ xa e yabi, ɛ naxa, ‘Halagi Tiin Dangu Lɔxɔn Sanla saraxan na a ra Alatala xa, naxan dangu Isirayila kaane banxine xun ma Misiran yi. A to yi Misiran kaane faxama, a yi nxɔ banxine ratanga.’ ” Na xanbi ra, yamaan yi e xinbi sin, e Ala batu. ");
INSERT INTO yal_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Isirayila kaane yi a liga alo Alatala Musa nun Haruna yamari kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kɔɛ tagini, Alatala yi dii singene birin faxa Misiran yi, keli Firawona dii singen ma naxan dɔxi mangayani han kasorasane dii singene kaso banxini, e nun subene dii singene. ");
INSERT INTO yal_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Firawona nun a kuntigine birin yi keli kɔɛɛn na, e nun Misiran kaane birin. Wuga xui gbeen yi te Misiran yi, bayo faxan bata yi ti banxin birin yi. ");
INSERT INTO yal_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Na kɔɛɛn yɛtɛɛn na, Firawona yi Musa nun Haruna xili, a fala e xa, a naxa, “Ɛ keli, ɛ mini n ma yamanani, ɛ tan nun Isirayila kaane! Ɛ siga, ɛ Alatala batu, alo ɛ a falaxi kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ɛ xuruse xunxurine nun a xungbene tongo, alo ɛ a falaxi kii naxan yi. Ɛ siga. Ɛ duba n fan xa.” ");
INSERT INTO yal_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misiran kaane yi Isirayila yamaan nagbɛngbɛn, e yi e kedi yamanani mafurɛn, bayo e yi a falama nɛn, e naxa, “Nxu birin faxama.” ");
INSERT INTO yal_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Isirayila yamaan yi e burun xali benun a xa gan, benun a rate seen xa sa. E buru bɔnbɔ seene mafilin e dugine yi, e e sa e kɔɛ ma, e siga a xalɛ. ");
INSERT INTO yal_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Musa naxan fala, Isirayila kaane yi na liga, e yi Misiran kaane xandi gbetin nun xɛma muranne yi e nun dugine. ");
INSERT INTO yal_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Alatala yi a liga Isirayila yamaan yi rafan Misiran kaane ma, e naxan maxɔdin e na so e yii. E yi Misiran kaane yii geli. ");
INSERT INTO yal_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isirayila xɛmɛ wuli kɛmɛ sennin yi keli e sanna ma Ramisesi taani, siga Sukɔti taani, ba ɲaxanle nun diidine ra. ");
INSERT INTO yal_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Siya gbɛtɛ wuyaxi fan yi siga e fɔxɔ ra. Xuruse kuru gbeen yi e yii a xunxurin nun a xungbene. ");
INSERT INTO yal_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","E yi burudine gan buru ratese mi yi naxanye yi, e keli naxan na Misiran yi, bayo e kedi nɛn Misiran yi. E mi fɛrɛn sɔtɔ, e fandane tongo e yɛtɛ xa. ");
INSERT INTO yal_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isirayila kaane ɲɛɛ kɛmɛ naanin ɲɛɛ tonge saxan nan ti Misiran yi. ");
INSERT INTO yal_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ɲɛɛ kɛmɛ naanin ɲɛɛ tonge saxanden to a li, na lɔxɔ yɛtɛni, Alatala yamaan birin yi mini Misiran yamanani. ");
INSERT INTO yal_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Kɔɛni ito ra waxati famatɔne yi, Isirayila kaane birin xa xi Alatala batuɛ, bayo a e raminixi Misiran yamanani kɔɛɛn nan na. ");
INSERT INTO yal_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Alatala yi a fala Musa nun Haruna xa, a naxa, “Tɔnne ni i ra Halagi Tiin Dangu Lɔxɔn Sanla fe yi: Xɔɲɛ yo nama a don. ");
INSERT INTO yal_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Konyin naxan saraxi, i na na banxulan, ɛ nun na a donɲɛ nɛn. ");
INSERT INTO yal_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","I ya walikɛɛn naxan sare fixi hanma xɔɲɛna, ne nama a don. ");
INSERT INTO yal_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","A donma banxi kedenna nan kui. Ɛ nama a suben namini banxini. Ɛ nama a xɔri yo gira. ");
INSERT INTO yal_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isirayila yamaan birin xa sanli ito liga. ");
INSERT INTO yal_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Xa xɔɲɛna nde i konni naxan wama Halagi Tiin Dangu Lɔxɔn Sanla raba feni Alatala xa, a denbayaan xɛmɛne birin xa banxulan. Nayi, a nɔɛ a ligɛ nɛn alo Isirayila kaana. Koni banxulantare yo nama a don. ");
INSERT INTO yal_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","A tan sariya kedenna na a ra Isirayila kaan nun xɔɲɛn xa ɛ tagi.” ");
INSERT INTO yal_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Alatala naxan yamari Musa nun Haruna ma, Isirayila kaane birin yi na liga na kiini. ");
INSERT INTO yal_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Na lɔxɔn yɛtɛni Alatala yi Isirayila ganla ramini Misiran yamanani e bɔnsɔn yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Dii xɛmɛ singene birin nasariɲan n xa. N gbeen nan dii singene birin na Isirayila kaane yɛ, muxune nun subene.” ");
INSERT INTO yal_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa yi a fala yamaan xa, a naxa, “Lɔxɔni ito xa rabira ɛ ma, ɛ mini lɔxɔni Misiran yi konyiyani! Amasɔtɔ Alatala ɛ raminixi a sɛnbɛn nan na. Ɛ nama buru ratexin don. ");
INSERT INTO yal_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ɛ minima nɛn to, Abiba kiken na. ");
INSERT INTO yal_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Alatala na ɛ rafa Kanan kaane bɔxɔn ma, Xitine nun Amorine nun Xiwine e nun Yebusune yamanana, a bata yi a kɔlɔ bɔxɔn naxan ma fe ra ɛ benbane xa, a xa a so ɛ yii, kumin nun nɔnɔn gbo bɔxɔn naxan yi, ɛ na so mɛnni, ɛ sanli ito rabama nɛn Alatala xa kikeni ito ra. ");
INSERT INTO yal_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Buru ratetaren donma nɛn xii solofere bun ma, xii soloferede lɔxɔni, sanla yi raba Alatala xa. ");
INSERT INTO yal_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ɛ buru ratetaren donma nɛn xii solofere bun ma, donse nama taran ɛ yii buru rate seen naxan yi. Buru rate se yo nama taran ɛ yamanani mumɛ!” ");
INSERT INTO yal_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Ɛ na yɛbama nɛn ɛ diine xa na lɔxɔni, ɛ naxa, ‘Alatala naxan ligaxi en xa, a en namini Misiran yamanani, na nan ma fe a ra.’ ");
INSERT INTO yal_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Sanli ito na nan ma fe rabirama ɛ ma, alo ɛ na taxamasenna xidi ɛ yiin na hanma ɛ sa ɛ tigi ra, alogo Alatalaa sariyan xa lu ɛ dɛ. Bayo Alatala nan ɛ raminixi Misiran yi a sɛnbɛni. ");
INSERT INTO yal_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ɛ xa yamarini ito suxu a waxatini ɲɛɛ yo ɲɛɛ.” ");
INSERT INTO yal_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Alatala na ɛ raso Kanan bɔxɔni, a a so ɛ yii alo a kɔlɔ ɛ xa kii naxan yi e nun ɛ benbane, ");
INSERT INTO yal_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ɛ xa dii singene birin nasariɲan Alatala xa saraxana nde ra. Xuruseene dii xɛmɛ singene birin, Alatala nan gbeen ne ra. ");
INSERT INTO yal_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Xa sofanla dii xɛmɛ singen na a ra, ɛ xa a xunba yɛxɛɛ diin na hanma sii diina. Koni, xa ɛ mi a xunba, ɛ xa a kɔɛɛn gira, ɛ a faxa. Ɛ mɔn xa ɛ dii xɛmɛ singene birin xunba saraxana nde ra. ");
INSERT INTO yal_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ɛ diine na ɛ maxɔdin waxati famatɔne yi, e naxa, ‘Ito bunna nanse ra?’ Ɛ xa e yabi, ɛ naxa, ‘Alatala sɛnbɛn nan en naminixi Misiran yi konyiyani. ");
INSERT INTO yal_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Bayo Firawona yi tondixi en beɲinɲɛ en siga, koni Alatala yi dii singene birin faxa Misiran yamanani, muxun nun subena. Nanara, en xuruse dii xɛmɛ singene birin bama saraxan na Alatala xa, en yi en ma dii xɛmɛ singene birin xunba.’ ");
INSERT INTO yal_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","A luma nɛn alo i na taxamasenna xidi i yiin na hanma i tigi ra, amasɔtɔ Alatala sɛnbɛn nan en naminixi Misiran yi.” ");
INSERT INTO yal_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Firawona to tin yamaan xa siga, Ala mi e ramini Filisitine yamanan kira yisoxin xɔn, bayo Ala a fala nɛn, a naxa, “E na yɛngɛn to, e nɔɛ e miriyane maxɛtɛ nɛn, e xɛtɛ Misiran yi.” ");
INSERT INTO yal_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Koni Ala yi ti yamaan yɛɛ ra tonbon yi kiraan xɔn, Gbala Baan binni. Isirayila kaane yi keli Misiran yi, e yitɔnxi yɛngɛ so xinla ma. ");
INSERT INTO yal_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa yi Yusufu xɔnne tongo, bayo Yusufu bata yi Isirayila kaane rakɔlɔ, a naxa, “Ala a ɲɔxɔ luma ɛ xɔn nɛn yati! Ɛ na keli be, ɛ n xɔnne xali.” ");
INSERT INTO yal_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","E yi keli Sukɔti taani, e yi sa daaxadeni tɔn Etama yi tonbonna danna ra. ");
INSERT INTO yal_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Alatala yi tima nɛn e yɛɛ ra yanyin na kunda yiyani naxan yi kiraan yitama e ra. Kɔɛɛn na, a ti e yɛɛ ra tɛɛ dɛgɛn yiyani a e kirani yalan, alogo e xa sigan ti kɔɛɛn nun yanyin na. ");
INSERT INTO yal_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Kundana, xanamu, tɛɛ dɛgɛn mi yi kelima yamaan yɛɛ ra yanyin nun kɔɛɛn na. ");
INSERT INTO yal_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“A fala Isirayila kaane xa, e xa xɛtɛ, e daaxadeni tɔn Pihahiroti dɛxɔn, Migidoli nun baan tagi. E xa daaxadeni tɔn baan dɛ Baali-Sefɔn yɛtagi. ");
INSERT INTO yal_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Nayi, Firawona a falama nɛn lan Isirayila kaane ma, a naxa, ‘E bata lɔ ayi yamanani, tonbonna e rabilinxi.’ ");
INSERT INTO yal_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","N Firawona bɔɲɛni xɔdɔxɔma nɛn, a bira ɛ fɔxɔ ra. Koni n binyen sɔtɔma Firawona nun a ganla birin xɔn ma nɛn, Misiran kaane yi a kolon a n tan nan Alatala ra.” Isirayila kaane yi na liga. ");
INSERT INTO yal_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Misiran Mangan to a mɛ a yamaan bata a gi. Nayi, Firawona nun a bundɔxɔne miriyaan yi maxɛtɛ. E yi a fala, e naxa, “En nanse ligaxi? En bata Isirayila kaane beɲin e xa siga, e mi fa walima en xa sɔnɔn!” ");
INSERT INTO yal_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Firawona yi a yɛngɛ so wontoroni tɔn, a ganla yi bira a fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","A yi a yɛngɛ so wontoro yɛbaxi kɛmɛ sennin tongo, e nun Misiran wontorone birin. Sofa kuntigine yi ne birin kui. ");
INSERT INTO yal_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Alatala yi Firawona bɔɲɛni xɔdɔxɔ, Misiran Mangana. A yi Isirayila kaane sagatan naxanye yi minima xunna kenli. ");
INSERT INTO yal_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Misiran kaane yi e sagatan, Firawona soone birin nun yɛngɛ so wontorone nun soo ragine, e nun a ganla, e yi Isirayila kaane li malanxi baan dɛ, Pihahiroti binni, Baali-Sefɔn yɛtagi. ");
INSERT INTO yal_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Firawona yi a masoma, Isirayila kaane yi e yɛɛn nasiga, e Misiran kaane to fɛ e fɔxɔ ra. E yi gaxu han! E e xuini te Alatala ma. ");
INSERT INTO yal_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","E a fala Musa xa, e naxa, “Nanfera i faxi nxu ra tonbonni, nxu xa fa faxa be? Gaburu mi yi Misiran yi ba? I nanse dɔxi nxu ra i to nxu baxi Misiran yi? ");
INSERT INTO yal_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Nxu mi ito xan falaxi i xa Misiran yi, ‘A lu nxu xa wali Misiran kaane xa?’ A yi fisa nun nxu xa wali Misiran kaane xa benun nxu xa fa faxa tonbonni.” ");
INSERT INTO yal_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa yi yamaan yabi, a naxa, “Ɛ nama gaxu. Ɛ ɛ raxara, ɛ yi a to Alatala ɛ xunbama kii naxan yi to. Amasɔtɔ ɛ Misiran kaan naxanye toma to, ɛ mi fa ne toma sɔnɔn! ");
INSERT INTO yal_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Alatala yɛngɛn soma nɛn ɛ xa, ɛ ɛ raxara tun!” ");
INSERT INTO yal_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Alatala yi a fala Musa xa, a naxa, “Ɛ mɔn n maxandima be nanfera? A fala Isirayila kaane xa, a e xa siga. ");
INSERT INTO yal_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","I tan xa i ya dunganni te, i yiini bandun baan xun ma, a xa yitaxun firinna ra, alogo Isirayila kaane xa baani gidi a yixaraxina. ");
INSERT INTO yal_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","N tan Misiran kaane bɔɲɛni xɔdɔxɔma nɛn, alogo e xa godo ɛ fɔxɔ ra. N binyen sɔtɔma nɛn Firawona nun a ganla birin xɔn ma, e nun a wontorone nun a soo ragine. ");
INSERT INTO yal_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Misiran kaane a kolonma nɛn a n tan nan Alatala ra. N na nɔ Firawona nun a wontorone nun a soo ragine ra, n binyen sɔtɔma nɛn.” ");
INSERT INTO yal_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ala malekan naxan yi tixi Isirayila ganla yɛɛ ra, na yi siga e xanbi ra. Kundaan naxan yi tixi e yɛɛ ra, na yi sa ti e xanbi ra. ");
INSERT INTO yal_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","A yi ti Misiran nun Isirayila ganle tagi. Kundaan fɔxɔ kedenna yi dimixi, a fɔxɔ kedenna yi kɔɛni yalanma. Nanara, gali firinne mi yi masoma e bode ra kɔɛɛn birin kui. ");
INSERT INTO yal_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa yi a yiini bandun baan xun ma. Na kɔɛɛn birin na, Alatala yi baa igen naxɛtɛ foye gbeen na keli sogetedeni, a yi baani xara. Igen yi bolon. ");
INSERT INTO yal_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Isirayila kaane yi gidi baani xare yireni. Igen yi malanxi alo banxi tunbulunna e yiifanna nun e kɔmɛnna ma. ");
INSERT INTO yal_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Misiran kaane yi e sagatan. Firawona soone birin nun a yɛngɛ so wontorone nun a soo ragine yi bira e fɔxɔ ra baani. ");
INSERT INTO yal_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Subaxa, Alatala yi Misiran ganla mato keli kundaan nun tɛɛ dɛgɛn xun ma, a yi e yifu han! ");
INSERT INTO yal_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","A yi e wontorone sanne ba e bun ma, a yi e sigati raxɔlɔ ayi. Nayi, Misiran kaane yi a fala, e naxa, “En na en gi Isirayila kaane yɛɛ ra, amasɔtɔ Alatala Misiran yɛngɛma e xa.” ");
INSERT INTO yal_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Alatala yi a fala Musa xa, a naxa, “I yiini bandun baan xun ma alogo igen xa sa Misiran kaane xun ma, e nun e wontorone nun e soo ragine.” ");
INSERT INTO yal_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa yi a yiini bandun baan xun ma. Kuye yibani, baan mɔn yi xɛtɛ a kiini. Misiran kaane yi e gima a famatɔɔn yɛɛ ra, koni Alatala yi e radin baani. ");
INSERT INTO yal_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Igen yi xɛtɛ, a sa wontorone nun soo ragine nun Firawona ganla birin xun ma, naxanye godo baani Isirayila kaane fɔxɔ ra. Hali keden mi lu. ");
INSERT INTO yal_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Koni Isirayila kaane sigan ti nɛn igen xare yireni, igen yi malanxi e yiifanna nun e kɔmɛnna ma. ");
INSERT INTO yal_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Na lɔxɔni, Alatala yi Isirayila xunba Misiran kaane yii. Isirayila yi Misiran kaane binbine to baan dɛ. ");
INSERT INTO yal_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Isirayila kaane to Alatala sɛnbɛ gbeen to Misiran kaane xili ma, yamaan yi gaxu Alatala yɛɛ ra, e la a ra, e nun Musa a walikɛna. ");
INSERT INTO yal_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Nayi, Musa nun Isirayila kaane yi bɛtini ito ba Alatala xa. E naxa: N bɛtin bama Alatala xa, amasɔtɔ a gbo mumɛ! A bata soone nun soo ragine radin baani. ");
INSERT INTO yal_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Alatala nan n fangan na, n bɛtin bama naxan xa, a mɔn bata findi n nakisimaan na. N ma Ala nan a ra, n na a tantunma nɛn, n fafe a Ala nan a ra, n na a matɔxɔma nɛn. ");
INSERT INTO yal_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yɛngɛ soon nan Alatala ra, a xili nɛn “Alatala.” ");
INSERT INTO yal_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","A bata Firawona wontorone nun a ganla woli baani, Firawona sofa yɛbaxine bata e mamin Gbala Baani. ");
INSERT INTO yal_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","E bata godo tilinna ma alo gɛmɛne. Fufaan yi sa e xun ma. ");
INSERT INTO yal_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Alatala! I bata i sɛnbɛn yita! Alatala! I yiifanna bata yaxune faxa. ");
INSERT INTO yal_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I bata yaxune rabira i ya gboon nun nɔrɔni. I bata i ya xɔlɔ gbeen nagodo alo tɛɛna a yi e gan alo sɛxɛ xarena. ");
INSERT INTO yal_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","I ɲɔɛ foyen bata igene malan, walanne yi raxara alo banxi kankena. Igene yi raxara baan tilinna xɔnna ma. ");
INSERT INTO yal_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Yaxune yi a falama, e naxa, “N sagatanna tima nɛn, n yi e suxu. N se tongoxine yitaxun, han n wasa e ra, han a dangu ayi. N silanfanna botinma nɛn ayi, n yiin yi e halagi.” ");
INSERT INTO yal_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Koni, i bata i dɛ foyen nafa baa igen bata sa e xun ma. E bata godo ige gbeen bun ma alo wure binyena. ");
INSERT INTO yal_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Alane yɛ, nde luxi alo i tan, Alatala? Nde luxi alo i tan? I gbee nɔrɔn sariɲan! I magaxu! Tantunna i tan nan xa! I kabanakone ligama! ");
INSERT INTO yal_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","I bata i yiini bandun, bɔxɔn yi nxu yaxune gerun. ");
INSERT INTO yal_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","I bata ti i ya yama xunbaxin yɛɛ ra i ya hinanni. I e rasigama nɛn i dɔxɔde sariɲanxini i sɛnbɛni. ");
INSERT INTO yal_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Siyane a mɛma nɛn, e xuruxurun. Kuisanna Filisitine suxuma nɛn. ");
INSERT INTO yal_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edɔn kuntigine gaxuma nɛn. Gaxun Moyaba muxu gbeene suxuma nɛn. Kanan kaane birin sɛnbɛn bata ɲan. ");
INSERT INTO yal_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Gaxun nun kuisanna e suxuma nɛn, e e raxara alo gɛmɛna i sɛnbɛn bun, han i ya yamaan yi dangu, Alatala! Han i ya muxune yi dangu. ");
INSERT INTO yal_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","I e xalima nɛn, i yi e dɔxɔ geyaan fari i naxan findima e kɛɛn na, i tan Alatala luma dɛnaxan yi, i tan Marigin dɛnaxan nafalaxi yire sariɲanxin na. ");
INSERT INTO yal_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Alatala luma nɛn mangayani habadan han habadan! ");
INSERT INTO yal_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Firawona soone nun a wontorone nun a soo ragine to godo baani, Alatala baa igen naxɛtɛ nɛn e xun ma, koni Isirayila kaane yi sigan ti, e baani gidi a yixarena. ");
INSERT INTO yal_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nayi, Haruna xunyɛn Mariyama, nabi ɲaxalanmana, na yi tanbanna suxu a yii. Ɲaxanle birin yi bira a fɔxɔ ra, tanbanne e yii, e bodonma. ");
INSERT INTO yal_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mariyama yi bɛtini ito bama Isirayila ɲaxanle xa, Ɛ bɛtin ba Alatala xa, amasɔtɔ a gbo han! A bata soone nun soo ragine woli baani! ");
INSERT INTO yal_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Musa yi ti Isirayila kaane yɛɛ ra keli Gbala Baani siga Suru tonbonni. Xii saxanna bun ma, e sigan tima tonbonni, e mi ige to. ");
INSERT INTO yal_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","E yi so Mara yi, koni e mi nɔ Mara igen minɲɛ, amasɔtɔ a yi xɔlɔ. Nanara, na yiren yi xili sa “Mara.” ");
INSERT INTO yal_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Yamaan yi lu Musa mafalɛ, e naxa, “Nxu xa nanse min?” ");
INSERT INTO yal_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa yi Alatala maxandi, Alatala yi wudina nde yita a ra, a naxan woli igeni. Igen yi ɲaxunɲɛ ayi. Alatala tɔnna nun sariyan soxi yamaan yii mɛnna nin, a e kɛɲaan fɛsɛfɛsɛ. ");
INSERT INTO yal_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","A yi a fala, a naxa, “Xa ɛ Alatala xuiin namɛ ki faɲi, ɛ Ala, ɛ yi tinxinna liga a yɛɛ ra yi, xa ɛ a yamarine nun tɔnne birin suxu, n mi fitina fe yo rafɛ ɛ ma, n Misiran kaane ɲaxankataxi naxanye ra, amasɔtɔ Alatala nan n tan na, naxan ɛ rakɛndɛyama.” ");
INSERT INTO yal_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","E yi so Elimi yi, tigi fu nun firin yi dɛnaxan yi e nun tugu bili tonge solofere. E yi daaxadeni tɔn mɛnni, igen dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isirayila yamaan birin yi keli Elimi yi, e minin kike firinden xii fu nun suulunde lɔxɔni Misiran yamanani, e fa Sin tonbonni, dɛnaxan Elimi nun Sinayi tagi. ");
INSERT INTO yal_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Isirayila yamaan birin yi lu Musa nun Haruna mafalɛ tonbonni. ");
INSERT INTO yal_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Isirayila kaane yi a fala e xa, e naxa, “Hali Alatala yi nxu faxa Misiran yi nun! Nxu yi dɔxɔma sube tundene fɛma nxu yi donseene don han nxu lugo! Koni ɛ bata fa nxu ra tonbonni be alogo nxu birin xa faxa kamɛn ma.” ");
INSERT INTO yal_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Alatala yi a fala Musa xa, a naxa, “Awa, n na a ligama nɛn donseen yi godo ɛ ma keli kore. Yamaan yi mini lɔxɔ yo lɔxɔ. E naxan donɲɛ lɔxɔn kui, e na yatɛn matongo. N na e kɛɲaan fɛsɛfɛsɛma na kii nin, n xa a to xa e n ma sariyane suxɛ. ");
INSERT INTO yal_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Xii senninde lɔxɔni, e xa a matongo e naxan donɲɛ xii firinna kui, e na rafala burun na.” ");
INSERT INTO yal_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Musa nun Haruna yi a fala Isirayila yamaan birin xa, e naxa, “To ɲinbanna ra, ɛ a kolonma nɛn a Alatala nan ɛ raminixi Misiran yamanani. ");
INSERT INTO yal_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Xɔtɔnni, ɛ Alatala binyen toma nɛn, amasɔtɔ a bata ɛ xuiin mɛ, ɛ Alatala nan mafalama. Nanse nxu tan na ɛ to nxu mafalama?” ");
INSERT INTO yal_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa yi a fala, a naxa, “Alatala suben don daxin soma ɛ yii nɛn to ɲinbanna ra. Xɔtɔnni, a burun so ɛ yii han ɛ lugo. Amasɔtɔ Alatala bata a mafala xuiin mɛ ɛ xɔn ma. Nanse nxu tan na? Ɛ mi nxu tan gbansanna mafalama, fɔ Alatala.” ");
INSERT INTO yal_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musa yi a fala Haruna xa, a naxa, “A fala Isirayila yamaan birin xa, i naxa, ‘Ɛ fa Alatala yɛtagi, amasɔtɔ a bata a mafala xuiin mɛ ɛ xɔn ma.’ ” ");
INSERT INTO yal_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Haruna to yi falan tima Isirayila yamaan birin xa, e yi e firifiri tonbonna binni, Alatalaa nɔrɔn yi mini kɛnɛnni kundani. ");
INSERT INTO yal_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“N bata Isirayila kaane xuiin mɛ. E n mafalama. A fala e xa, i naxa, ‘Ɲinbanna ra, ɛ suben donma nɛn. Xɔtɔnni ɛ lugo burun na. Nayi, ɛ a kolonɲɛ a Alatala nan n tan na, ɛ Ala.’ ” ");
INSERT INTO yal_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ɲinbanna ra, dɔmɛne yi fa e dɔxɔ yamaan daaxaden yiren birin yi. Xɔtɔnni, xiila yi saxi yamaan daaxaden nabilinna birin yi. ");
INSERT INTO yal_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Xiila to yolon, sena nde yi lu malanxi bɔxɔn fari alo bogi seen xɔnna. ");
INSERT INTO yal_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Isirayila kaane to a mato, e a fala e bode xa, e naxa, “Nanse ito ra?” Bayo, e mi yi a kolon naxan a ra. Musa yi a fala e xa, a naxa, “Donseen na a ra Alatala naxan soxi ɛ yii ɛ xa a don.” ");
INSERT INTO yal_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Alatala ito nan yamarixi, a naxa, “Birin nɔɛ naxan donɲɛ a xa na nan matongo. Ɛ xa ligase yɛ keden keden matongo muxune xa naxanye ɛ konne yi.” ");
INSERT INTO yal_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isirayila kaane yi a liga na kiini, nde yi a gbegbe matongo, nde yi ndedi matongo. ");
INSERT INTO yal_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","E yi a maliga liga seen kui. Naxanye a gbegbe matongo, ne mi a gboxi ayi. Naxanye ndedi matongo, a mi dasa ne fan ma. Birin yi a matongoma a makoon naxan ma. ");
INSERT INTO yal_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa yi a fala e xa, a naxa, “Muxu yo nama a dɔnxɛn namara han xɔtɔnni.” ");
INSERT INTO yal_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Koni, ndee mi e tuli mati Musa ra. Ne yi a ramara han xɔtɔnni. Koni kunle yi bira a birin yi, a xirin yi mini fɔlɔ. Nanara, Musa yi xɔlɔ ne ma. ");
INSERT INTO yal_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Xɔtɔn yo xɔtɔn birin yi a matongoma naxan e makoon liyɛ. Sogen na xɔlɔ, donseen yi xulunɲɛ ayi. ");
INSERT INTO yal_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Xii senninde lɔxɔni, e yi lɔxɔ firin daxi matongo, birin liga seen yɛ firin. Yamaan kuntigine birin yi na feen dɛntɛgɛ Musa xa. ");
INSERT INTO yal_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa yi a fala e xa, a naxa, “Alatala ito nan yamarixi. Matabu Lɔxɔn nan tila ra. Matabu sariɲanxin na a ra Alatala xa. Nanara, ɛ lan ɛ xa donseen naxan gan, ɛ na gan. Ɛ lan ɛ xa naxan ɲin, ɛ na ɲin. Naxanye na lu ɛ ne ramara han xɔtɔnni.” ");
INSERT INTO yal_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","E yi a ramara han xɔtɔnni, alo Musa a yamari kii naxan yi. A xirin mi mini, kuli mi bira a yi. ");
INSERT INTO yal_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa yi a fala, a naxa, “Ɛ ito don to, amasɔtɔ Alatalaa Matabu Lɔxɔn nan to ra. To ɛ mi se toma a matongo daxin na. ");
INSERT INTO yal_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ɛ a matongoma nɛn xii sennin, koni xii soloferede lɔxɔni, naxan findin Matabu Lɔxɔn na, se mi taranma na mumɛ!” ");
INSERT INTO yal_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Xii soloferede lɔxɔni, yamaan muxuna ndee yi mini a matongodeni, e mi sese to. ");
INSERT INTO yal_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Nayi, Alatala yi a fala Musa xa, a naxa, “Ɛ tondima n ma yamarine nun sariyane suxɛ han waxatin mundun yi? ");
INSERT INTO yal_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ɛ a kolon a Alatala bata Matabu Lɔxɔn so ɛ yii. Nanara, xii senninde lɔxɔni, a donse lɔxɔ firin daxin soma ɛ yii. Birin xa a raxara xii soloferede lɔxɔna fe ra. Muxu yo nama mini a konni.” ");
INSERT INTO yal_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Yamaan yi a matabu xii soloferede lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isirayila kaane yi na donseen xili sa “Manna donsena.” A yi luxi alo se xɔri fixɛna. A yi ɲaxun alo kumina. ");
INSERT INTO yal_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa yi a fala, a naxa, “Alatala ito nan yamarixi. Manna donseen ligase yɛ keden xa ramara ɛ yixɛtɛne xa, alogo e xa a to n na ɛ baloxi burun naxan na tonbonni, n na ɛ ramini xanbini Misiran yamanani.” ");
INSERT INTO yal_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa yi a fala Haruna xa, a naxa, “Goron keden tongo, i yi a rafe Manna donseen ligase keden na, i yi a sa Alatala yɛtagi, alogo a xa ramara ɛ yixɛtɛne xa.” ");
INSERT INTO yal_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Haruna yi na Manna donseen sa Layiri Kankiraan yɛtagi alo Alatala a yamari Musa ma kii naxan yi, alogo a xa ramara. ");
INSERT INTO yal_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isirayila kaane yi Manna donseen don ɲɛɛ tonge naanin, han e yi so yamanani muxune yi dɔxi dɛnaxan yi. E yi Manna donseen don han e yi Kanan yamanan danna li. ");
INSERT INTO yal_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Na waxatin liga seen yɛ fu yi lanxi Efa liga seen yɛ kedenna nan ma. ");
INSERT INTO yal_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isirayila kaane yamaan birin yi keli Sin tonbonni, e sigan ti yirene yi alo Alatala e yamari kii naxan yi. E yi daaxadeni tɔn Refidimi yi, koni yamaan mi ige min daxi to na yi. ");
INSERT INTO yal_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Nanara, yamaan yi yɛngɛn fen Musa ra. E yi a fala, e naxa, “Ige min daxin so nxu yii!” Musa yi e yabi, a naxa, “Nanfera ɛ n nafenma yɛngɛn na? Nanfera ɛ Alatala matoma bunbani?” ");
INSERT INTO yal_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Min xɔnla nan yi yamaan na mɛnni, e yi lu Musa mafalɛ. E naxa, “Nanfera i nxu raminixi Misiran yi, alogo nxu nun nxɔ diine nun nxɔ xuruseene xa fa faxa be min xɔnla ra?” ");
INSERT INTO yal_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa yi a xuini te Alatala ma, a naxa, “N nanse ligama yamani ito xa? A luxi ndedi, e xa n magɔlɔn.” ");
INSERT INTO yal_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Alatala yi a fala Musa xa, a naxa, “Dangu yamaan yɛɛ ra. Ɛ nun Isirayila fonna ndee xa siga. I xa dunganna suxu i yii i Nila baan garin naxan na. ");
INSERT INTO yal_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","N tima nɛn i yɛɛ ra Horebe fanyen ma. I xa fanyen garin, igen minima nɛn, yamaan yi a min.” Musa yi na liga, Isirayila fonne yɛɛ xɔri. ");
INSERT INTO yal_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","A yi mɛn xili sa “Masa” e nun “Meriba.” Amasɔtɔ Isirayila kaane bata yi matandina ti, e bata yi Alatala mato bunbani, e naxa, “Alatala en yɛ ba? Xa a mi en yɛ?” ");
INSERT INTO yal_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalɛkine yi fa Isirayila yɛngɛdeni Refidimi yi. ");
INSERT INTO yal_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Nayi, Musa yi a fala Yosuwe xa, a naxa, “Xɛmɛna ndee sugandi, i sa Amalɛkine yɛngɛ. Tila, n tima nɛn geyaan xuntagi, Alaa dunganna n yii.” ");
INSERT INTO yal_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosuwe yi Amalɛkine yɛngɛ alo Musa a fala kii naxan yi. Musa, Haruna, e nun Xuru yi te geyaan xuntagi. ");
INSERT INTO yal_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Musa nɛma a yiini tema, Isirayila yi nɔɔn tima. Koni xa a a yiini godo, Amalɛkine yi nɔɔn ti. ");
INSERT INTO yal_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Musa yiine bata yi xadan. E yi gɛmɛn tongo, e na dɔxɔ. Musa yi dɔxɔ a fari. Haruna nun Xuru yi a yiine bun tima, boden fɔxɔ kedenni, boden bode fɔxɔni. A yiine yi kore han kɔɛ yi so. ");
INSERT INTO yal_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yosuwe yi Amalɛkine ganla nɔ silanfanna ra. ");
INSERT INTO yal_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Alatala yi a fala Musa xa, a naxa, “Ito sɛbɛ kɛdin kui, alogo ɲinan nama ti a xɔn. I yi a yɛba Yosuwe xa, bayo n Amalɛkine bama nɛn dunuɲa yi fefe! Ɲinan yi ti e xɔn.” ");
INSERT INTO yal_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa yi saraxa ganden nafala, a yi a xili sa, “Alatala nan n ma yɛngɛ so taxamaseri dugin na.” ");
INSERT INTO yal_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","A mɔn yi a fala, a naxa, “Amasɔtɔ muxune kelixi nɛn Alatala manga gbɛdɛn xili ma, Alatala luma Amalɛkine yɛngɛ nɛn, han mayixɛtɛn nun mayixɛtɛne.” ");
INSERT INTO yal_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Musa bitanna Yetiro, Midiyan saraxaralina, na yi a mɛ Ala naxan birin ligaxi Musa nun Isirayila xa, a yamana. A a mɛ a Alatala bata yi Isirayila ramini Misiran yi. ");
INSERT INTO yal_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Musa bitanna Yetiro yi fa Musaa ɲaxanla Sefora ra, a bata yi naxan lu a yii ");
INSERT INTO yal_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","e nun a dii firinne. Kedenna xili Gɛrisɔmi, bayo Musa bata yi a fala, a naxa, “N bata findi xɔɲɛn na yamana gbɛtɛ yi.” ");
INSERT INTO yal_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Boden yi xili Eliyeseri, bayo a bata yi a fala, a naxa, “N babaa Ala bata n mali, a n natanga Firawonaa silanfanna ma.” ");
INSERT INTO yal_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Musa bitanna Yetiro nun Musaa diine nun a ɲaxanla yi fa Musa fɛma tonbonni, a yi dɔxi dɛnaxan yi Alaa geyaan dɛxɔn ma. ");
INSERT INTO yal_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","A bata yi a fe xibarun nasiga Musa ma, a naxa, “N tan, i bitanna Yetiro, n fama i fɛma, nxu nun i ya ɲaxanla nun a dii firinne.” ");
INSERT INTO yal_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa yi mini a bitanna ralandeni, a yi a xinbi sin, a yi a sunbu. E yi e bode xɔntɔn, e so Musaa bubun kui. ");
INSERT INTO yal_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa yi a yɛba a bitanna xa Alatala naxan ligaxi Firawona nun Misiran kaane ra Isirayila fe ra, e nun tɔrɔn naxan birin e sɔtɔ kira yi, e nun Alatala e xunba kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Alatala naxan birin ligaxi Isirayila xa a to a xunba Misiran kaane yii, Yetiro yi sɛwa ne ra. ");
INSERT INTO yal_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetiro yi a fala, a naxa, “N bata barika bira Alatala xa, naxan ɛ xunbaxi Misiran kaane nun Firawona yii, naxan yamaan baxi Misiran kaane sɛnbɛn bun! ");
INSERT INTO yal_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Iki, n bata a kolon a Alatala sɛnbɛn gbo alane birin xa, amasɔtɔ a bata ito liga ne ra naxanye yi wasoxi Isirayila xili ma.” ");
INSERT INTO yal_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Musa bitanna Yetiro yi saraxa gan daxin nun saraxa gbɛtɛne ba Ala xa. Haruna nun Isirayila fonne birin yi fa buru dondeni Musa bitanna fɛma, Ala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Na xɔtɔn bode, Musa yi dɔxɔ yamaan makitideni. Yamaan yi ti a yɛtagi keli xɔtɔnna ma han ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Musa yi naxan birin ligama yamaan xa, a bitanna to na to, a yi a fala, a naxa, “Nanfe ito ra, i naxan ligama yamaan xa? Nanfera i kedenna kitin sama, yamaan birin yi ti i yɛtagi, keli xɔtɔnni han ɲinbanna ra?” ");
INSERT INTO yal_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa yi a bitanna yabi, a naxa, “Bayo yamaan fama n fɛma Ala sagoon nan maxɔdinde yi. ");
INSERT INTO yal_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Xa fena nde e tagi, e fama nɛn n fɛma, n yi kitin sa, n Alaa tɔnne nun a sariyane yɛba e xa.” ");
INSERT INTO yal_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Musa bitanna yi a fala a xa, a naxa, “I naxan ligama, na mi fan. ");
INSERT INTO yal_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ɛ nun yamani ito ɛ bode raxadanma nɛn, bayo goronni ito gbo i sɛnbɛn xa, i kedenna mi a gasɛ. ");
INSERT INTO yal_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Iki, i tuli mati n xuiin na, n xa i kawandi. Ala xa lu i xɔn! A lan i xa ti Ala yɛtagi yamaan funfuni, i yi Ala maxɔdin e bode matandine fe ra. ");
INSERT INTO yal_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","I xa e xaran tɔnne nun sariyane ma. I kiraan yita e ra e biran naxan fɔxɔ ra, e nun wanle e naxan kɛ. ");
INSERT INTO yal_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Koni i xa muxu kɛndɛne sugandi yamaan yɛ, naxanye gaxuma Ala yɛɛ ra, lannaya muxune, mayifu mi naxanye yi. I yi e findi muxu wuli keden kuntigine ra, hanma muxu kɛmɛ kuntigine, e nun muxu tonge suulun kuntigine, e nun muxu fu kuntigine. ");
INSERT INTO yal_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","E xa yamaan makiti waxatin birin, e yi fa fe xɔdɛxɛne ra i fɛma. Koni feen naxanye mi xɔdɔxɔ, e tan xa ne makiti. Na nde bama nɛn i ya goronna ra, bayo e fan nde tongoma nɛn. ");
INSERT INTO yal_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Xa i na liga, Alaa tinni, i nɔɛ a gasɛ nɛn. Yamani ito birin sigama nɛn e konne yi bɔɲɛ xunbenli.” ");
INSERT INTO yal_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa yi a bitanna xuiin namɛ, a naxan fala, a na liga. ");
INSERT INTO yal_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","A muxu kɛndɛne sugandi Isirayila yi, a yi e findi yama xunne ra, muxu wuli keden kuntigine, muxu kɛmɛ kuntigine, muxu tonge suulun kuntigine, e nun muxu fu kuntigine. ");
INSERT INTO yal_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","E yi yamaan makitima waxatin birin. E yi fama fe xɔdɛxɛne ra Musa fɛma, koni naxanye mi yi xɔdɔxɔ, e tan yɛtɛɛn yi ne makitima nɛn. ");
INSERT INTO yal_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Musa yi tin, a bitanna yi siga a konni. ");
INSERT INTO yal_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Kike saxan to dangu, xabu e mini Misiran yi, na lɔxɔ yɛtɛni, Isirayila kaane yi Sinayi tonbonna li. ");
INSERT INTO yal_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","E to keli Refidimi yi, e yi fa Sinayi tonbonni. Isirayila kaane yi daaxadeni tɔn tonbonni, geyaan san bun. ");
INSERT INTO yal_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa yi te Ala fɛma. Alatala yi Musa xili geyaan xuntagi, a naxa, “Ito fala Yaxuba bɔnsɔnne xa, Isirayila kaane, ");
INSERT INTO yal_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Ɛ yɛtɛɛn bata a to n naxan ligaxi Misiran na, n yi ɛ xali n fɛma alo singbinna soma a diine bun kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Iki, xa ɛ n xuiin suxu ki faɲi, xa ɛ n ma layirin suxu, ɛ findima nɛn n ma yamaan na siyane birin yɛ. N gbeen nan bɔxɔn birin na, ");
INSERT INTO yal_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","koni ɛ findima n xa saraxarali yamaan nan na e nun siya sariɲanxina.’ I falani itoe nan tima Isirayila kaane xa.” ");
INSERT INTO yal_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Musa yi xɛtɛ, a fonne birin xili, a falani itoe birin yɛba e xa, alo Alatala a yamari kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Yamaan birin yi a fala, e naxa, “Alatala naxan birin falaxi nxu na ligama nɛn.” Musa yi sa e falane rali Alatala ma. ");
INSERT INTO yal_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Alatala yi a fala Musa xa, a naxa, “N fama nɛn i ma kunda yiyani, alogo n nɛma falan naxan tiyɛ i xa, yamaan xa a mɛ. Nanara, e lɛ i ra waxatin birin yi.” Musa yi yamana falane radangu Alatala ma. ");
INSERT INTO yal_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Alatala yi a fala Musa xa, a naxa, “Siga yamaan fɛma, e rasariɲan to nun tila yi. E xa e dugine xa. ");
INSERT INTO yal_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","E xa e yitɔn xii saxandena fe ra, bayo na lɔxɔni Alatala godoma nɛn Sinayi geyaan fari, yamaan birin yɛɛ xɔri. ");
INSERT INTO yal_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","I xa danne sa yamaan xa geyaan nabilinni, i yi a fala, i naxa, ‘Ɛ yɛtɛ masuxu te feen na geyaan fari, ɛ nama maso a san bunna ra. Naxan yo na a sanna ti geyaan ma, ɛ xa na kanna faxa. ");
INSERT INTO yal_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ɛ nama ɛ yiin din a ra, koni ɛ a magɔlɔnma nɛn, hanma ɛ a bun xalimakunle ra. Muxu ba, sube ba, a mi kisima.’ Xɔtaan xuiin na mini, muxune yi te geyaan fari.” ");
INSERT INTO yal_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa yi godo yamaan fɛma keli geyaan fari, a yi yamaan nasariɲan, e yi e dugine xa. ");
INSERT INTO yal_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","A yi a fala yamaan xa, a naxa, “Ɛ yitɔn xii saxandena fe ra. Ɛ nama ɛ maso ɲaxalan yo ra.” ");
INSERT INTO yal_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Xii saxande lɔxɔn xɔtɔnni, kuye sarinne yi mini, galanne yi godo, kundaan yi sa geyaan xun ma. Xɔtaan xuiin yi mini han! Yamaan birin yi gaxu. ");
INSERT INTO yal_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa yi yamaan namini e daaxadeni Ala ralandeni, e yi e malan geyaan san bun ma. ");
INSERT INTO yal_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Tutun yi Sinayi geyaan birin xun ma, amasɔtɔ Alatala bata yi godo a ma tɛɛ dɛgɛni. Na tutin yi tema alo sulun tɛɛn tutina, geyaan birin yi xuruxurunma a ɲaxin na. ");
INSERT INTO yal_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Xɔtaan xuiin yi gboma ayi tun! Musa yi falan ti, Ala yi a yabi a xuini texin na. ");
INSERT INTO yal_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Alatala yi godo Sinayi geyaan fari, a yi Musa xili geyaan xuntagi. Musa yi te. ");
INSERT INTO yal_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Alatala yi a fala Musa xa, a naxa, “Godo, a fala yamaan xa e nama kata fa feen na n matodeni, xa na mi a ra e wuyaxi faxama nɛn. ");
INSERT INTO yal_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hali saraxaraliin naxanye e masoma Alatala ra, ne xa e yɛtɛ rasariɲan, alogo Alatala nama e faxa.” ");
INSERT INTO yal_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa yi a fala Alatala xa, a naxa, “Yamaan mi nɔɛ tɛ Sinayi geyaan fari. Amasɔtɔ i bata nxu rakolon, i yi a fala, i naxa, ‘Ɛ danne sa geyaan nabilinni, ɛ xa a rasariɲan.’ ” ");
INSERT INTO yal_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Alatala yi a fala a xa, a naxa, “Godo, i mɔn yi te ɛ nun Haruna. Koni saraxaraline nun yamaan nama kata te feen na Alatala fɛma, alogo n nama e faxa.” ");
INSERT INTO yal_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Musa yi godo yamaan fɛma, a feni itoe fala e xa. ");
INSERT INTO yal_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ala yi falani itoe birin ti, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Alatala nan n tan na, i ya Ala, naxan i raminixi konyiyani Misiran yi.” ");
INSERT INTO yal_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“I nama ala gbɛtɛ batu fɔ n tan.” ");
INSERT INTO yal_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“I nama suxuren nafala hanma sena nde sawurana, seen naxan kore, naxan bɔxɔn ma hanma naxan igeni. ");
INSERT INTO yal_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","I nama i xinbi sin e xa. I nama e batu. Amasɔtɔ n tan, Alatala, i ya Ala, n xɔxɔlɔn. Naxanye na n naɲaxu, n ne hakɛn saranma e diine ra nɛn han mayixɛtɛ saxan hanma naanin. ");
INSERT INTO yal_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Koni naxanye na n xanu, e n ma yamarine suxu, n hinanma ne ra nɛn han mayixɛtɛ wuli keden.” ");
INSERT INTO yal_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“I nama Alatala i ya Ala xinla fala fuuni, amasɔtɔ Alatala na kanna ɲaxankatama nɛn.” ");
INSERT INTO yal_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“I xa Matabu Lɔxɔn binya, i yi a rasariɲan. ");
INSERT INTO yal_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","I xa wali xii sennin bun ma, i yi i ya wanle birin kɛ. ");
INSERT INTO yal_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Koni xii soloferede lɔxɔni, Alatala i ya Alaa Matabu Lɔxɔn nan na ra. I nama wali yo kɛ, i tan ba, i ya dii xɛmɛn ba, i ya dii tɛmɛn ba, i ya konyin ba, i ya xuruse ba, hanma hali xɔɲɛn naxan i konni. ");
INSERT INTO yal_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Amasɔtɔ Alatala koren nun bɔxɔn nun igen daxi xii sennin nan bun, e nun naxan birin e yi. Koni a a matabu nɛn xii soloferedeni. Nanara, Alatala yi barakan sa Matabu Lɔxɔna fe yi, a yi a rasariɲan.” ");
INSERT INTO yal_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“I baba nun i nga binya, alogo i xa siimaya xunkuyen sɔtɔ bɔxɔni, Alatala i ya Ala naxan fima i ma.” ");
INSERT INTO yal_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“I nama faxan ti.” ");
INSERT INTO yal_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“I nama yalunyaan liga.” ");
INSERT INTO yal_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“I nama muɲan ti.” ");
INSERT INTO yal_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“I nama wule seren ba i adamadi boden xili ma.” ");
INSERT INTO yal_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“I nama mila i bodena banxin xɔn hanma i bodena ɲaxanla, hanma a konyina, a ɲingena, a sofanla, hanma i adamadi boden gbee seen naxan birin na.” ");
INSERT INTO yal_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Yamaan birin yi galanna nun xɔtaan xuiin mɛma, e yi tutin toma tɛ. Yamaan yi gaxu e xuruxurun, e yi e makuya. ");
INSERT INTO yal_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","E yi a fala Musa xa, e naxa, “I tan yɛtɛɛn xa falan ti nxu xa, nxu nxu tuli matima nɛn i ra, koni Ala nama falan ti nxu xa alogo nxu nama faxa.” ");
INSERT INTO yal_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa yi a fala yamaan xa, a naxa, “Ɛ nama gaxu. Ala bata fa ɛ kɛɲaan fɛsɛfɛsɛdeni, alogo ɛ xa gaxu a yɛɛ ra, alogo ɛ nama yulubin liga.” ");
INSERT INTO yal_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Yamaan yi lu tixi yire makuyeni, koni Musa yi a maso kundaan na Ala yi dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Alatala yi a fala Musa xa, a a xa a fala Isirayila kaane xa, a naxa, “Ɛ bata a to a n bata falan ti ɛ xa keli kore. ");
INSERT INTO yal_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ɛ nama suxurene rafala, ɛ yi nxu nun ne batu nxu bode xɔn. Ɛ nama gbetin nun xɛma suxurene rafala. ");
INSERT INTO yal_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","I xa saraxa gande bɛndɛ daxini tɔn n xa, i yi saraxa gan daxine nun bɔɲɛ xunbeli saraxane nun xuruse xunxurine nun a xungbene ba a fari. N na dɛnaxan findi n xinla binyaden na, n fama nɛn i ma mɛnni, n yi i baraka. ");
INSERT INTO yal_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Xa i saraxa gande gɛmɛ daxini tɔn n xa, i nama a yitɔn gɛmɛ masolixin na. Amasɔtɔ i ya a masolima waliseen naxan na, na saraxa ganden naxɔsima nɛn. ");
INSERT INTO yal_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","I nama saraxa gande matexin nafala n xa, i yi te te seene ma, alogo i ragenla nama to.” ");
INSERT INTO yal_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“I sariyani itoe nan yɛbama e xa. ");
INSERT INTO yal_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Xa i Heburu konyina nde sara, a walima nɛn ɲɛɛ sennin. Koni ɲɛɛ soloferedeni, a xɔrɔyama nɛn, a mi sese fima. ");
INSERT INTO yal_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Xa a kedenna nan soxi i konni, a kedenna nan sigama. Xa ɲaxanla yi a yii a so waxatini, e nun a ɲaxanla yi siga. ");
INSERT INTO yal_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Xa a kanna nan ɲaxanla so a yii, xa a bata dii xɛmɛne bari hanma dii tɛmɛne, a kanna nan gbee a ɲaxanla nun a diine ra. A kedenna yi siga. ");
INSERT INTO yal_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Xa konyina a fala, a naxa, ‘N kanna rafan n ma, e nun n ma ɲaxanla nun n ma diine, n mi waxi xɔrɔya feni,’ ");
INSERT INTO yal_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","nayi a kanna xa a xali Alaa kitisane yɛtagi. A yi a maso dɛɛn na hanma sɛnbɛtɛnna. A kanna yi a tunla sɔxɔn wuren na. Konyin yi lu a wanla ra tolon!” ");
INSERT INTO yal_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Xa muxuna nde a dii tɛmɛn mati alo konyina, a mi xɔrɔyama alo konyi xɛmɛne. ");
INSERT INTO yal_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Xa a raɲaxu a kanna ma, naxan yi waxi a tongo feni a ɲaxanla ra, a kanna xa tin a baba xa a xunba. A kanna nama a yanfa, a a mati xɔɲɛne ma. ");
INSERT INTO yal_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Xa a fixi a dii xɛmɛn nan ma a ɲaxanla ra, a kanna a suxuma nɛn alo a gbee dii tɛmɛne. ");
INSERT INTO yal_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Xa a ɲaxalan gbɛtɛ tongo, a nama sese ba a singe ra xiina donseen na, hanma a dugin na, hanma xɛmɛ taa sariyana. ");
INSERT INTO yal_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Xa a mi na fe saxanne liga a xa, a nɔɛ sigɛ nɛn, a mi gbeti yo fi.” ");
INSERT INTO yal_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Naxan na muxuna nde bɔnbɔ, a a faxa, ɛ xa na kanna faxa. ");
INSERT INTO yal_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Xa a mi yi kataxi a faxa feen na, koni Ala yi a ragidi na kiini, a xa a gi han n yiren naxan yitɛ i ra a nɔɛ luyɛ dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Koni xa muxuna nde a boden faxa feni tɔn a yi a faxa, hali a sa a singan n ma saraxa ganden na, ɛ xa a ba na, ɛ yi a faxa.” ");
INSERT INTO yal_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Naxan na a baba bɔnbɔ hanma a nga, ɛ xa na kanna faxa.” ");
INSERT INTO yal_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Naxan na muxuna nde suxu, a sa a mati hanma muxune yi a to a yii, ɛ xa na kanna faxa.” ");
INSERT INTO yal_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Naxan na a baba danga hanma a nga, ɛ xa na kanna faxa.” ");
INSERT INTO yal_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Xa muxune yɛngɛ, keden yi gɛmɛn sin a boden ma hanma walisena nde, a mi a faxa, koni a yi a rasa, ");
INSERT INTO yal_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","nayi naxan bɔnbɔn tixi, na mi ɲaxankatama xa boden keli, a yi a masiga ti dunganna ra. Koni a xa a walitareya yikalan saren fi. A yi a dandan han a yi yalan.” ");
INSERT INTO yal_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Xa muxuna nde a konyi xɛmɛn hanma a konyi gilɛn bɔnbɔ wudin na, konyin yi faxa a yii, a kanna hakɛn saranma a ra nɛn. ");
INSERT INTO yal_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Koni xa a konyin bata keli xii keden hanma firin na xanbi ra, a kanna hakɛn mi fa saranma a ra. A bata a yɛtɛ nan bɔnɔ.” ");
INSERT INTO yal_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Xa muxune yɛngɛ, e ɲaxalan fudikanna li, a diin bari benun a waxatin xa a li, koni fe ɲaxi gbɛtɛ mi bira ayi, nayi na ɲaxanla xɛmɛn na seen naxan maxɔdin, kitisane na tin naxan ma, fe kalan xa na fi. ");
INSERT INTO yal_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Koni xa ɲaxanla maxɔlɔxi, niin ɲɔxɔn xa fi niin na, ");
INSERT INTO yal_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","yɛɛn yi ɲɔxɔ yɛɛn na, ɲinna yi ɲɔxɔ ɲinna ra, yiin yi ɲɔxɔ yiin na, sanna yi ɲɔxɔ sanna ra, ");
INSERT INTO yal_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ganna yi ɲɔxɔ ganna ra, maxɔlɔn yi ɲɔxɔ maxɔlɔn na, bɔnbɔn yi ɲɔxɔ bɔnbɔn na.” ");
INSERT INTO yal_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Xa muxuna nde a konyi xɛmɛn hanma a konyi gilɛn yɛɛn garin, a yi a kala, a xɔrɔyama nɛn a yɛɛn saren na. ");
INSERT INTO yal_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Xa a konyi xɛmɛna hanma a konyi gilɛn ɲin keden gira, a xɔrɔyama nɛn a ɲinna saren na.” ");
INSERT INTO yal_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Xa ɲingena nde xɛmɛna hanma ɲaxanla sɔxɔn a fenna ra, a yi faxa, ɲingen magɔlɔnma nɛn han a faxa, a suben nama don. Koni ɲinge kanna hakɛn mi saranma a ra. ");
INSERT INTO yal_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Koni xa ɲingen dari feen nan yi a ra, a kanna bata yi rakolon, koni a mi a xidi, ɲingen yi xɛmɛn hanma ɲaxanla faxa, nayi ɲingen magɔlɔnma nɛn, ɛ yi a kanna fan faxa. ");
INSERT INTO yal_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Koni, xa muxune tinxi a ma, ɲinge kanna xa a niin xunbaan fi, e na naxan yo maxɔdin. ");
INSERT INTO yal_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Sariya keden mɔn sama xa ɲingen bata banxulanna hanma sungutunna faxa. ");
INSERT INTO yal_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Koni xa ɲingen bata konyi xɛmɛn hanma konyi gilɛn faxa, ɲinge kanna xa gbeti gbanan tonge saxan nan so konyi kanna yii, ɲingen yi magɔlɔn.” ");
INSERT INTO yal_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Xa muxuna nde xɔɲinna dɛ raba, hanma a nde ge, a mi a dɛ ragali, xa ɲingena nde bira na ra hanma sofanla, ");
INSERT INTO yal_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","xɔɲin kanna xa ɲingen saren fi, a ɲinge faxaxin tongo.” ");
INSERT INTO yal_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Xa muxu ɲingen ɲinge gbɛtɛ sɔxɔn, a yi faxa, e xa ɲinge ɲɛɲɛn mati e a saren taxun, e ɲinge faxaxin fan taxun. ");
INSERT INTO yal_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Koni xa a kolonxi a a ɲingen dari feen nan yi a ra, a kanna mi a xidi, na kanna xa ɲingen ɲɔxɔn fi ɲingen na, a ɲinge faxaxin tongo a gbeen na.” ");
INSERT INTO yal_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","“Xa muxuna nde ɲingen muɲa hanma yɛxɛɛna, a a kɔɛ raxaba hanma a a mati, a ɲinge suulun nan fima ɲingen ɲɔxɔn na, a yɛxɛɛ naanin fi yɛxɛɛn ɲɔxɔn na.” ");
INSERT INTO yal_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Xa muɲaden natɛrɛna muɲa tideni, e yi a bɔnbɔ, a yi faxa, na mi yatɛma faxa tiin na. ");
INSERT INTO yal_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Koni xa kuyen bata yiba, na yatɛma faxa tiin nan na.” “Muɲaden xa a se muɲaxine ɲɔxɔ, xa sese mi a yii, a yɛtɛɛn xa mati konyin na. ");
INSERT INTO yal_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","A naxan muɲaxi, ɲingena, yɛxɛɛna, hanma sofanla, xa muxune na li a yii, a xa a ɲɔxɔn naxɛtɛ dɔxɔde firin.” ");
INSERT INTO yal_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Xa muxuna nde a xuruseene lu e kalan ti xɛɛna nde ma hanma manpa bili nakɔna nde kui, a xa se kalaxine ɲɔxɔ a gbee se xabaxi faɲine ra.” ");
INSERT INTO yal_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Xa tɛɛn keli, a sɛxɛn li, a sa malo xidine hanma a tixin gan, hanma xɛɛn birin yi gan, naxan tɛɛn soxi a xa se kalaxine ɲɔxɔn fi.” ");
INSERT INTO yal_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Xa muxuna nde gbetina hanma a yii sena nde taxu a lanfaan na a xa ramara, e yi a muɲa na kanna ma, muɲaden xa a ɲɔxɔn naxɛtɛ dɔxɔ firin, xa a to. ");
INSERT INTO yal_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Xa muɲade mi to, banxi kanna xa siga Ala batu yireni, a a kɔlɔ fa fala a mi a lanfaan yii seen tongoxi.” ");
INSERT INTO yal_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","“Matandin naxan keli ɲinge feen ma, sofali fena, yɛxɛɛ fena, dugi fena, hanma seen naxan lɔxi ayi, muxune a falama naxan ma fe yi, e naxa, ‘N gbeen na a ra!’ Se kari dɔxɔ firinne xa siga han Ala batudena. Ala na naxan yalagi, na xa a lanfaan gbeen ɲɔxɔn naxɛtɛ dɔxɔ firin.” ");
INSERT INTO yal_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Xa muxuna nde sofanla, ɲingena, yɛxɛɛna, hanma suben siya gbɛtɛ taxu a lanfaan na, na suben yi faxa, hanma a maxɔlɔ, hanma a muɲa, muxu yo mi a to, ");
INSERT INTO yal_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","marakɔlɔn xa ti Alatala yi na muxu firinne tagi. Naxan suben namaraxi, na xa a kɔlɔ fa fala a mi a lanfaan yii seen tongoxi. Sube kanna xa tin na kɔlɔn ma, hali boden mi a ɲɔxɔn fi. ");
INSERT INTO yal_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Koni xa suben muɲaxi a konna nin, a lanma nɛn a yi a kanna gbeen ɲɔxɔn naxɛtɛ a ma. ");
INSERT INTO yal_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Xa burunna subene bata a subeni bɔ, a xa fa a dɔnxɛn na seren na, naxan faxaxi na ɲɔxɔn nama raxɛtɛ. ");
INSERT INTO yal_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Xa muxuna nde suben xandi a lanfaan ma, suben yi maxɔlɔ hanma a faxa a kanna xanbi, a ɲɔxɔn naxɛtɛma nɛn. ");
INSERT INTO yal_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Xa a kanna yi a dɛxɔn na waxatini, a mi a ɲɔxɔ raxɛtɛma. Xa a a yii toliman nin, naxan a xun yi, a saren nan na ra.” ");
INSERT INTO yal_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","“Xa muxuna nde sungutun nasɔlɔnxin nakunfa naxan mi futuxi, a yi a kolon ɲaxanla ra, a xa a futu seen fi a yi a tongo a ɲaxanla ra. ");
INSERT INTO yal_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Xa a baba tondi a soɛ a yii, a xa sungutun nasɔlɔnxine futu seen xasabin fi gbetin na a baba ma.” ");
INSERT INTO yal_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","“I nama yiimatoon lu a nii ra.” ");
INSERT INTO yal_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Naxan yo nun suben na kafu i xa a faxa.” ");
INSERT INTO yal_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Naxan yo na saraxan ba ala gbɛtɛne xa, ba Alatala kedenna ra, i xa a faxa.” ");
INSERT INTO yal_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“I nama xɔɲɛn tɔrɔ, i nama ɲaxu a ra, amasɔtɔ xɔɲɛn nan yi ɛ ra Misiran yamanani.” ");
INSERT INTO yal_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“I nama ɲaxu kaɲa gilɛn na, hanma kiridina. ");
INSERT INTO yal_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Xa i ɲaxu e ra, e yi e xuini te n ma, n na e xuiin namɛma nɛn yati! ");
INSERT INTO yal_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","N xɔlɔma nɛn, n yi i faxa silanfanna ra, i ya ɲaxanle yi findi kaɲa gilɛne ra, ɛ diine yi findi kiridine ra.” ");
INSERT INTO yal_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","“Xa i gbetin doli yiigelitɔna nde ma n ma yamani, i nama findi doli maxinla ra, i nama tɔnɔ yo fen a ra. ");
INSERT INTO yal_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Xa i i bodena domaan suxu tolimani, i xa a raxɛtɛ a ma benun sogen xa bira. ");
INSERT INTO yal_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Amasɔtɔ xa a sa li, a domaan nan a bitinganna ra, a naxan felenma a ma xunbenli, a xa a sa nanse ma? Xa a n maxandi, n na a xuiin namɛma nɛn. Amasɔtɔ n tan kininkinin.” ");
INSERT INTO yal_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","“I nama Ala rayelefu, i nama i ya yamaan mangan danga.” ");
INSERT INTO yal_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“N gbee naxan i ya se xabaxine nun i ya turen fari i nama bu na fideni n ma. I xa i ya dii xɛmɛ singen so n yii. ");
INSERT INTO yal_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","I mɔn yi i ya ɲingen dii singen so n yii e nun i ya yɛxɛɛna. A xa lu a nga bun xii sennin, a xii soloferedeni, i yi a so n yii.” ");
INSERT INTO yal_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","“N ma muxu sariɲanxine nan ɛ tan na. Nanara, ɛ nama sube yo don burunna subene naxan faxaxi. Ɛ xa a woli barene bun.” ");
INSERT INTO yal_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“I nama wule falane rali muxune ma. I nama kafu fe ɲaxi rabane ma wule seren badeni. ");
INSERT INTO yal_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","I nama bira yamaan fɔxɔ ra fe ɲaxi rabadeni. I nama sa yamaan fari, i wule seren ba alogo kitin nama sa tinxinni. ");
INSERT INTO yal_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","I nama yiigelitɔɔn nafisa bonne xa kitini.” ");
INSERT INTO yal_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Xa i naralan i yaxuna ɲinge tununxin na hanma a sofanla, i xa fa a ra a yɛ ra. ");
INSERT INTO yal_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Xa i i yaxuna sofanla to, a biraxi a goronna bun, i nama a lu na kiini. I xa a mali.” ");
INSERT INTO yal_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“I nama tondi kiti kɛndɛn sɛ tɔrɔ muxun xa a kitini. ");
INSERT INTO yal_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","I xa fata wulen birin ma. I nama sɔntaren hanma tinxin muxun yalagi, a yi faxa. Amasɔtɔ n muxu ɲaxine yalagima nɛn. ");
INSERT INTO yal_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","I nama dimi yi seene rasuxu mayifuni, amasɔtɔ finmase sifani itoe muxune yɛɛne raxima, e tinxin muxune falane maxɛtɛ.” ");
INSERT INTO yal_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“I nama ɲaxu xɔɲɛne ra, bayo i ya a kolon xɔɲɛne tɔrɔyaan naxan yi, amasɔtɔ i findi nɛn xɔɲɛn na Misiran yamanani.” ");
INSERT INTO yal_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“I ya xɛɛne bi ɲɛɛ sennin bun ma, i yi sii seene xaba. ");
INSERT INTO yal_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Koni i nama xɛɛn bi i ya bɔxɔni ɲɛɛ solofereden ma. A xa lu a yɛtɛ ma. Tɔrɔ muxune yi seen sɔtɔ a xɔnni nayi, naxan na lu burunna subene yi na don. I xa na fan liga i ya manpa bili nakɔne nun Oliwi binle ra.” ");
INSERT INTO yal_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“I ya wanla kɛ xii sennin bun. Koni i xa i matabu xii soloferedeni, alogo i ya ɲingen nun i ya sofanla xa e matabu, alogo i ya konyin nun i ya xɔɲɛn xa e matabu.” ");
INSERT INTO yal_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“N naxan birin falaxi, i xa ne suxu ki faɲi! I nama ala gbɛtɛne xinla fala. A nama mini i dɛ mumɛ!” ");
INSERT INTO yal_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Dɔxɔ saxan ɲɛɛn bun, i xa sanle liga n xa. ");
INSERT INTO yal_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","I xa Buru Tetaren Sanla raba. I xa burun tetaren don xii solofere bun, alo n ni i yamari kii naxan yi. Ito liga a waxatini Abiba kiken na, amasɔtɔ i minixi Misiran yi na kiken nan na. Muxu yo nama fa n yɛtagi n kise mi a yii.” ");
INSERT INTO yal_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“I xa Se Xaba Singen sanla raba, i na i ya se bixine xaban fɔlɔ xɛɛn ma waxatin naxan yi. I mɔn xa Se Xaba Dɔnxɛn sanla raba ɲɛɛ raɲanni, i ya bogiseene malanma waxatin naxan yi keli xɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Muxune birin fama nɛn Marigina Alatala yɛtagi dɔxɔɲa ma saxan ɲɛɛn bun.” ");
INSERT INTO yal_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“I na saraxan wunla rali n ma, i nama donse gbɛtɛ sa a fari burun nate seen naxan yi. I nama n ma sanla saraxa subene turen namara han xɔtɔnni. ");
INSERT INTO yal_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","I xa fa i ya xɛɛn bogise singe faɲine ra Alatalaa banxini, i ya Ala.” “I nama sii diin ɲin a nga xiɲɛ igen na.” ");
INSERT INTO yal_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“N malekan xɛma nɛn i yɛɛ ra, a i kantan kira yi, a i rafa na yireni n dɛnaxan yitɔnxi. ");
INSERT INTO yal_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","A liga i yeren ma, i yi a xuiin suxu. I nama murutɛ a ma, amasɔtɔ a mi diɲama i ya matandine ma, bayo n na a xɛxi n xinla nin. ");
INSERT INTO yal_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Koni xa i ya a xuiin namɛ, n naxan birin falama i xa i na liga, n findima nɛn i yaxune yaxun na, e nun i yɛngɛfane yɛngɛfana. ");
INSERT INTO yal_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","N ma malekan tima nɛn i yɛɛ ra, a i xali Amorine nun Xitine nun Perisine nun Kanan kaane nun Xiwine nun Yebusune bɔxɔn ma, n yi e raxɔri.” ");
INSERT INTO yal_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“I nama i xinbi sin e alane bun ma, i nama e batu, i nama bira e namunne fɔxɔ ra. Koni i xa e kala, i yi e kide gɛmɛne yibɔ. ");
INSERT INTO yal_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ɛ xa Alatala batu, ɛ Ala. A barakan sama ɛ donseene nun ɛ igene yi nɛn. N furen masiga ɛ ra. ");
INSERT INTO yal_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ɲaxalan yo kui mi kalama i ya yamanani, ɲaxalan yo mi findɛ gbantan na. N ni i ya siimayaan xɔnkuyama ayi nɛn.” ");
INSERT INTO yal_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“N na n ma yɛɛragaxun nasigama nɛn ɛ yɛɛ ra. I na so yamanan naxan yi, n na muxune yifuma nɛn. N na ɛ yaxune birin xun xanbi soma nɛn ɛ yɛtagi, e yi e gi ɛ bun. ");
INSERT INTO yal_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","N ɲurune rasigama nɛn, e yi Xiwine, Kanan kaane, nun Xitine kedi i yɛɛ ra pon! ");
INSERT INTO yal_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","N mi e birin kedima ɛ yɛɛ ra ɲɛɛ kedenni, xanamu, yamanani gelima nɛn, burunna subene yi wuya ɛ xa. ");
INSERT INTO yal_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","N na e kedima nɛn ɛ yɛtagi ndedi ndedi, han ɛ wuya ayi, yamanan yi findi ɛ gbeen na.” ");
INSERT INTO yal_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“N na ɛ yamanan danne sama nɛn keli Gbala Baani han Filisitine baani, keli tonbonni han Efirati baani. Amasɔtɔ n yamanan muxune sama nɛn i sagoni alogo i xa e kedi i yɛ ra. ");
INSERT INTO yal_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ɛ nun ne nama layirin xidi, e nun e alane fan. ");
INSERT INTO yal_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","E nama dɔxɔ i ya bɔxɔni, alogo e nama i ti yulubin ma. Amasɔtɔ i ye e suxurene batuma nɛn, e suxurene yi lu alo luti ratixina i yɛɛ ra.” ");
INSERT INTO yal_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Alatala yi a fala Musa xa, a naxa, “Te n fɛma, i tan nun Haruna, Nadaba, Abihu nun Isirayila fonna tonge solofere, ɛ yi ɛ xinbi sin wulani. ");
INSERT INTO yal_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Musa kedenna nan a masoma Alatala ra, bonne nama e maso, yamaan nama te a fɔxɔ ra.” ");
INSERT INTO yal_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa yi Alatalaa falane birin yɛba yamaan xa e nun a sariyane birin. Yamaan birin yi a yabi fala kedenna xɔn, e naxa, “Alatala naxan birin falaxi nxu a ligɛ.” ");
INSERT INTO yal_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musa yi Alatalaa falane birin sɛbɛ. Na xanbi ra, a keli xɔtɔn, a yi saraxa gandena nde rafala geyaan san bun, a yi gɛmɛ fu nun firin dɔxɔ Isirayila bɔnsɔn fu nun firinne taxamasenna ra. ");
INSERT INTO yal_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","A yi Isirayila banxulanna ndee rasiga, e xa saraxa gan daxine ba, e yi tura bulanne ba bɔɲɛ xunbeli saraxan na Alatala xa. ");
INSERT INTO yal_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa yi wunla fɔxɔ kedenna sa goronne kui, a fɔxɔ kedenna xuya saraxa ganden ma. ");
INSERT INTO yal_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","A yi Layiri Kɛdin tongo, a a xaran Isirayila birin yɛɛ xɔri. E yi a fala, e naxa, “Alatala naxan birin falaxi nxu a ligɛ, nxu yi a suxu.” ");
INSERT INTO yal_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa yi wunla tongo, a a xuya yamaan ma, a naxa, “Wunli ito nan layiri xidi seen na, Alatala to yamarini itoe fi.” ");
INSERT INTO yal_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa nun Haruna nun Nadaba nun Abihu nun Isirayila fori tonge soloferene yi te. ");
INSERT INTO yal_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","E yi Isirayilaa Ala to tixi gɛmɛ walaxan fari, naxan yi rafalaxi safiri gɛmɛne ra, naxan yi sariɲan alo kore xɔnna. ");
INSERT INTO yal_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Koni, Ala mi fe liga Isirayila yɛɛratini itoe ra. E yi Ala mato, e yi e dɛge, e yi e min. ");
INSERT INTO yal_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Alatala yi a fala Musa xa, a naxa, “Te geyaan fari, i lu n fɛma. N gɛmɛ walaxane soma i yii nɛn, n sariyane nun yamarine sɛbɛ e ma yamaan xaran feen na.” ");
INSERT INTO yal_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musa yi keli, e nun a mali muxun Yosuwe, e yi te Alaa geyaan fari. ");
INSERT INTO yal_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","A yi a fala fonne xa, a naxa, “Ɛ nxu mamɛ be han nxu yi fa ɛ fɛma. Haruna nun Xuru luma nɛn ɛ fɛma. Xa fena nde sa bira ayi, ɛ a fala e xa.” ");
INSERT INTO yal_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musa yi te geyaan fari, kundaan yi so geyaan xun na. ");
INSERT INTO yal_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Alaa nɔrɔn yi godo Sinayi geyaan ma. Kundaan yi so geyaan xun na xii sennin. Xi soloferede lɔxɔni, Alatala yi Musa xili kundani. ");
INSERT INTO yal_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Alatalaa nɔrɔn yi lu Isirayila kaane yɛɛ ra yi alo halagi ti tɛɛn nan dɛgɛma geyaan fari. ");
INSERT INTO yal_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa yi so kundani, a te geyaan fari. Musa yi lu geyaan fari xii tonge naanin kɔɛ tonge naanin. ");
INSERT INTO yal_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“A fala Isirayila kaane xa a e xa fa yii malan seene ra n xɔn. Muxune birin xa fa a ra e ɲɛnige faɲin nan na, i yi a rasuxu n xa. ");
INSERT INTO yal_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","I kiseni itoe nan nasuxuma e ra: Xɛmana, gbetina, sulana, ");
INSERT INTO yal_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","gari mamiloxin nun a gbeela, taa dugi faɲin nun sii xabe dugine, ");
INSERT INTO yal_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","konton kidi magbelixine, sube kidine, kasiya wudina, ");
INSERT INTO yal_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lɛnpu turena, e nun se xiri ɲaxumɛn naxanye sama se masusan tureni, e nun wusulanna, ");
INSERT INTO yal_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","onixin gɛmɛ tofaɲine nun gɛmɛ tofaɲi gbɛtɛye saraxarali domaan nun a kanke masaan nayabuxi naxanye ra. ");
INSERT INTO yal_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","E xa yire sariɲanxin nafala n xa, n luma nɛn e tagi. ");
INSERT INTO yal_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ɛ xa Ala Batu Bubun nafala e nun a waliseene birin alo n na a yitama i ra kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“E xa kasiya wudi kankiraan nafala: A kuyana nɔngɔnna yɛ firin e nun a tagi, a yigbona nɔngɔnna yɛ keden e nun a tagi, a yitena nɔngɔnna yɛ keden e nun a tagi. ");
INSERT INTO yal_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","I xɛma faɲin sa a ma. I xa a sa a kuiin nun a fanna ma. I xa a dɛ kinkin nabilin xɛmaan na. ");
INSERT INTO yal_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","I xa a tongo tamine so yili naaninne rafala xɛmaan na a san naaninne ma, firin fɔxɔ kedenni, firin bode fɔxɔni. ");
INSERT INTO yal_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","I xa kasiya tamine rafala, i xɛmaan sa e ma. ");
INSERT INTO yal_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","I tamine raso xɛma yinle ra kankiraan dɛxɔnne yi, alogo e xa findi kankiraan xali seen na. ");
INSERT INTO yal_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tamine xa lu kankiraan so yinle ra, e nama ba na. ");
INSERT INTO yal_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","I xa Layiri Sereyaan sa kankiraan kui, n naxan soma i yii. ");
INSERT INTO yal_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","I xa xɛma dɛraganla rafala kankiraan ma n solonaden na, a kuyana nɔngɔnna yɛ firin e nun a tagi, a yigbona nɔngɔnna yɛ keden e nun a tagi. ");
INSERT INTO yal_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","I xa maleka gubugubu kan sawura firin nafala xɛma bɔnbɔxin na, e xa ti kankiraan dɛraganla fɔxɔ firinne ma. ");
INSERT INTO yal_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","I xa maleka sawura keden ti fɔxɔ kedenni, i yi a firinden ti bode fɔxɔni. Maleka sawurane nun kankiraan dɛraganla xa findi se kedenna ra. ");
INSERT INTO yal_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Maleka sawurane xa e gubugubune yibandun e xun ma, e yi e felen kankiraan dɛraganla ma. Maleka sawurane xa e yɛɛ rafindi e bode ma e xun sinxina kankiraan dɛraganla ma. ");
INSERT INTO yal_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","I na Layiri Sereyaan sa kankiraan kui, i xa a dɛraganla sa a dɛ ra. ");
INSERT INTO yal_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","N na n yitama i ra mɛnna nin, Layiri Sereya Kankiraan dɛraganla xun ma, maleka gubugubu kan firinne sawurane longonna ra. N na n ma yamarine birin soma i yii mɛnna nin Isirayila kaane xa.” ");
INSERT INTO yal_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“I xa kasiya wudin tabanla rafala: a kuyana nɔngɔnna yɛ firin, a yigbona nɔngɔnna yɛ keden, a yitena nɔngɔnna yɛ keden e nun a tagi. ");
INSERT INTO yal_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","I xa xɛma faɲin sa a ma, i yi a dɛ kinkin nabilin xɛmaan na. ");
INSERT INTO yal_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","I xa farinna sa tabanla ɲinginna ma a rabilinni. Farinni gboon xa lan muxun yii kuiin ma. I yi xɛmaan sa farinna dɛ kinkine ra. ");
INSERT INTO yal_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","I xa a tongo tamine so yili naaninne rafala xɛmaan na tabanla tongon naaninne ma a sanne ma. ");
INSERT INTO yal_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Tamine so yinle luma a dɛ kinkine nan ma, tamine soon naxanye ra tabanla maxali seen na. ");
INSERT INTO yal_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","I xa kasiya tamine rafala, i yi xɛmaan sa e ma, e findi tabanla xali seen na. ");
INSERT INTO yal_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","I xa a goronne nun muranne rafala xɛma faɲin na, e nun a igelengenne, saraxa ige rabɔxɔn goronne. ");
INSERT INTO yal_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Buru Ralixine xa lu tabanli ito fari n yɛtagi waxatin birin.” ");
INSERT INTO yal_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“I xa lɛnpu dɔxɔ seen nafala xɛma bɔnbɔxi faɲin na. A sanna nun a yiine xa rayabu se fuge sawurane ra e birin yi findi se kedenna ra. ");
INSERT INTO yal_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Yii sennin xa ti a fɔxɔ firinne ma, lɛnpu dɔxɔden yire saxan yi lu a fɔxɔ kedenni, a yire saxan a fɔxɔ bodeni. ");
INSERT INTO yal_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Amandi wudi fuge sawura saxan saxan xa lu a yii senninna birin ma a rayabu seen na. ");
INSERT INTO yal_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Se fuge sawura naanin xa lu a binla fan ma. ");
INSERT INTO yal_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Keden xa lu a tangbaxi singen bun ma. Keden yi lu a firinden bun ma, keden yi lu a saxanden bun ma. ");
INSERT INTO yal_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","A fugene, a yiine, nun a binla birin xa findi se kedenna ra. A birin xa rafala xɛma bɔnbɔxi faɲin na. ");
INSERT INTO yal_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","I xa lɛnpu solofere rafala, i yi ne dɔxɔ e dɔxɔdene yi alogo e xa a yɛtagini yalan. ");
INSERT INTO yal_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","A waliseene nun xube kɔ seene fan xa rafala xɛma faɲin na. ");
INSERT INTO yal_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","I xa lɛnpu dɔxɔ seen nun a waliseene rafala xɛma faɲin kilo tonge saxan na.” ");
INSERT INTO yal_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“A liga i yeren ma, i yi e rafala alo n na misaala yitaxi i ra geyaan fari kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“I xa Ala Batu Bubun nafala taa dugi kuye faɲi fu ra, dugi mamiloxin nun a gbeela. E yi rayabu Maleka gubugubu kan sawura sɔxɔnxine ra. ");
INSERT INTO yal_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Dugine birin kuyan nun a yigboon xa lan: a kuyana nɔngɔnna yɛ mɔxɔɲɛn nun solomasɛxɛ, a yigbona nɔngɔnna yɛ naanin. ");
INSERT INTO yal_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","I xa dugi suulun dɛgɛ e bode ra, dugi suulunna bonne fan dɛgɛ e bode ra. ");
INSERT INTO yal_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","I xa luti mamiloxine ti dugi ratugunxine singe ra xiin dɛ kinkin na. I mɔn yi na liga a ratugunxin dɔnxɛ ra xiin na. ");
INSERT INTO yal_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","I xa luti tonge suulun ti dugi ratugunxine singe ra xiin na, i mɔn yi luti tonge suulun ti dugi ratugunxin bonne dɔnxɛ ra xiin fan na. Lutine xa lan e bode ma. ");
INSERT INTO yal_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","I xa suxu se xɛma daxin tonge suulun nafala i yi dugi ratugunxi firinne xidi e bode ra suxu seene ra. Nayi, Ala Batu Bubun yi findi se kedenna ra.” ");
INSERT INTO yal_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“I xa dugi fu nun keden nafala sii xabene ra, e findi Ala Batu Bubun xunna soon na. ");
INSERT INTO yal_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Dugi fu nun kedenne birin xa lan: e kuyan xa findi nɔngɔnna yɛ tonge saxan na, e yigbona nɔngɔnna yɛ naanin. ");
INSERT INTO yal_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","I xa dugi suulun dɛgɛ e bode ra e danna, i senninna bonne fan dɛgɛ e bode ra. I xa a sennindeni sa firinna ra bubun yɛtagi. ");
INSERT INTO yal_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","I xa luti tonge suulun ti dugi ratugunxine singe ra xiin dɛ kinkine ra, i mɔn yi luti tonge suulun ti dugi ratugunxin bonne fan dɔnxɛ ra xiin dɛ kinkine ra. ");
INSERT INTO yal_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","I xa suxu se sula daxi tonge suulun nafala, i yi lutine ti suxu seene ra. Nayi, i yi bubun findi kedenna ra. ");
INSERT INTO yal_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Na dugin tagin naxan minixi bonne xa, na xa singan Ala Batu Bubun xanbi ra. ");
INSERT INTO yal_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Dugi nɔngɔnna yɛ keden naxan minixi Ala Batu Bubun dɛxɔnne yi, na xa singan a dɛxɔnne ra a xunna soon na.” ");
INSERT INTO yal_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“I xa konton kidi magbelixine dɛgɛ e bode ra, i yi e sa bubun birin fari. I mɔn yi sube kidi faɲi gbɛtɛye fan sa na fari.” ");
INSERT INTO yal_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“I xa bubun xunna soon bun tiine rafala kasiya wudine ra. ");
INSERT INTO yal_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Bun tiine xa kuya ayi nɔngɔnna yɛ fu, e yi gbo ayi nɔngɔnna yɛ keden e nun a tagi. ");
INSERT INTO yal_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Bun ti kedenna kui, a xa ti farin firinna ra e bode yɛtagi. I xa bubun bun tiine birin ti na kiini. ");
INSERT INTO yal_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","I xa bun ti mɔxɔɲɛ rafala bubun yiifari fɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","I xa bundɔxɔ gbeti daxi tonge naanin nafala. Bun ti yo bun ti, bundɔxɔ firin. Farin firinne xa sɔti bundɔxɔne kui. ");
INSERT INTO yal_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","I xa bun ti mɔxɔɲɛ ti bubun kɔmɛn fɔxɔni, ");
INSERT INTO yal_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","e nun bundɔxɔ gbeti daxi tonge naanin, bun ti yo bun ti, bundɔxɔ firin. ");
INSERT INTO yal_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","I xa bun ti sennin ti bubun xanbi binni, sogegododen binni. ");
INSERT INTO yal_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","I xa bun ti firin sa a fari bubun xanbi ra tongonne ma. ");
INSERT INTO yal_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Bun ti firin xa ti e bode xɔn mɛnni. E xidi e bode ra keli laben na han e xun tagi. Bubun tongon firinne birin xa ti na kiini. ");
INSERT INTO yal_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","E birin malanxina, bun ti solomasɛxɛ e nun bundɔxɔ fu nun sennin. Bun dɔxɔ firin bun tiine birin bun. ");
INSERT INTO yal_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","I xa kasiya wudi gaalane rafala. Suulun xa lu bubun fɔxɔ kedenna bun tiine suxu seen na, ");
INSERT INTO yal_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","suulun xa lu bode fɔxɔn ma, suulun xa lu bubun xanbi binna ra, sogegododen binni. ");
INSERT INTO yal_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Gaalan tagi xiin bun tiine ma, na xa keli bubun fɔxɔ kedenni siga han bubun bode fɔxɔna. ");
INSERT INTO yal_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","I xa xɛmaan sa bun tiine ma. I xa gaalane so yinle rafala xɛmaan na. I xɛmaan sa gaalane ma.” ");
INSERT INTO yal_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“I xa Ala Batu Bubun ti alo a yitaxi i ra kii naxan yi geyaan fari.” ");
INSERT INTO yal_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“I xa kankiraan yɛ masansan taa dugin nafala gari mamiloxin nun a gbeela ra, a xa rayabu maleka gubugubu kan sawura sɔxɔnxine ra. ");
INSERT INTO yal_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","I xa a singan kasiya sɛnbɛtɛn naanin na xɛma yilɛnlɛnxine saxi naxanye ma, singan se xɛma daxi naxanye ma. E xa ti bundɔxɔ gbeti daxi naanin kui. ");
INSERT INTO yal_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","I xa yɛ masansan dugin singan, i Layiri Sereya Kankiraan nasoon mɛnna nin. Yɛ masansan dugin findima tagi saan nan na yire sariɲanxin nun yire sariɲanxi fisamantenna tagi.” ");
INSERT INTO yal_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“I xa dɛraganla sa Layiri Sereya Kankiraan dɛ ra n solonaden na yire sariɲanxi fisamantenna kui. ");
INSERT INTO yal_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","I xa tabanla ti yɛ masansan dugin yɛtagi, bubun kɔmɛn fɔxɔni. Lɛnpu dɔxɔ seen xa ti tabanla yɛtagi, bubun yiifari fɔxɔn ma.” ");
INSERT INTO yal_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Dugi sɔxɔnna xa taa dugi mamiloxin nun a gbeela sɔxɔn, i yi a singan Ala batu bubun dɛ ra. ");
INSERT INTO yal_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","I xa singan se xɛma daxin nafala dugini ito xa e nun kasiya sɛnbɛtɛn suulun, i xɛma yilɛnlɛnxine sa e ma, i yi bundɔxɔ sula daxin suulun naxulun e xa.” ");
INSERT INTO yal_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“I xa saraxa ganden nafala kasiya wudin na, a kuyan xa lan nɔngɔnna yɛ suulun ma, a yigbona nɔngɔnna yɛ suulun, a yitena nɔngɔnna yɛ saxan. ");
INSERT INTO yal_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","I xa feri keden keden nafala a tongon naaninne ma, e nun a fenne xa findi se kedenna ra i yi sulan sa e ma. ");
INSERT INTO yal_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","I xa a waliseene rafala sulan na: xube sa seene nun xube kɔ seene nun wuli xuya goronne nun sube tongo seene e nun tɛɛ kɔ seene. ");
INSERT INTO yal_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","I xa wure masɔxɔnxin nafala, xuben minin naxan na. I yi tamin so yili naanin nafala sulan na wure masɔxɔnxin tongon naaninne ma. ");
INSERT INTO yal_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","I xa wure masɔxɔnxin sa saraxa ganden dɛ kinkine bun ma a yiteen tagini. ");
INSERT INTO yal_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","I xa kasiya tamine rafala saraxa ganden xa, i yi sulan sa e ma. ");
INSERT INTO yal_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","I xa tamine raso sula yinle ra alogo tamine xa lu saraxa ganden fɔxɔ firinne ma, a xali seen na. ");
INSERT INTO yal_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","I xa saraxa ganden nafala farinne ra, a kui genla yi lu. A xa rafala alo n na a yitaxi i ra kii naxan yi geyaan fari.” ");
INSERT INTO yal_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“I xa Ala Batu Bubun nabilin sansanna ra. Sansanna yiifari fɔxɔn xa kuya han nɔngɔnna yɛ kɛmɛ, a ti taa dugi faɲine ra. ");
INSERT INTO yal_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Sula sɛnbɛtɛn mɔxɔɲɛ xa ti sula bundɔxɔ mɔxɔɲɛ kui, e nun dugi singan se gbeti daxine xa singan gbeti gaalane ra sɛnbɛtɛnne longonne ra. ");
INSERT INTO yal_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Kɔmɛn fɔxɔn sansanna fan xa kuya ayi han nɔngɔnna yɛ kɛmɛ, a fan yi ti taa dugi faɲine ra e nun sula sɛnbɛtɛn mɔxɔɲɛ, sula bundɔxɔ mɔxɔɲɛ e nun dugi singan se gbeti daxine nun gbeti gaalane sɛnbɛtɛnne longonne ra. ");
INSERT INTO yal_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Sogegododen binni, sansanna xa kuya ayi han nɔngɔnna yɛ tonge suulun, a xa ti dugine ra e nun sɛnbɛtɛn fu, e nun bundɔxɔ fu. ");
INSERT INTO yal_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","A sogeteden binni, soden dɛnaxan yi, sansanna mɔn xa kuya ayi han nɔngɔnna yɛ tonge suulun. ");
INSERT INTO yal_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Koni dugine xa singan soden fɔxɔ kedenni, e nun sɛnbɛtɛn saxan nun bundɔxɔ saxan han nɔngɔnna yɛ fu nun suulun. ");
INSERT INTO yal_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Dugine xa singan soden fɔxɔ bodeni, e nun sɛnbɛtɛn saxan e nun e bundɔxɔ saxan han nɔngɔnna fu nun suulun. ");
INSERT INTO yal_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","I xa dɛ raxidi dugin singan sansanna so dɛɛn na, naxan kuya han nɔngɔnna yɛ mɔxɔɲɛ. Dugi sɔxɔnne xa a rafala gari mamiloxin nun a gbeela ra, e nun taa dugi faɲina. Sɛnbɛtɛn naanin nun bundɔxɔ naanin fan xa ti mɛnni. ");
INSERT INTO yal_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Sansanna sɛnbɛtɛnne birin xa ti sula bundɔxɔne kui, e xa tugun e bode ra gaalan gbeti daxine ra dugi singan se gbeti daxine yi singan ne ra. ");
INSERT INTO yal_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Sansanna kuyan xa findi nɔngɔnna yɛ kɛmɛ, a yigbona nɔngɔnna yɛ tonge suulun, a taa dugi faɲine yitena nɔngɔnna yɛ suulun. Sansanna bundɔxɔne findima sulan nan na.” ");
INSERT INTO yal_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","“Se yo naxan nawalima Ala Batu Bubun wanle yi, e nun tamin naxanye gbangbanma bɔxɔni bubun bun tiine xidi seen na, hanma sansanna xidi seen na, ne birin xa rafala sulan na.” ");
INSERT INTO yal_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“I xa Isirayila kaane yamari e xa fa oliwi ture faɲin na i xɔn, alogo lɛnpune xa dɛgɛ waxatin birin. ");
INSERT INTO yal_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Haruna nun a diine xa lɛnpune dɔxɔ Layiri Kankiraan yɛ masansan dugin yɛtagi Naralan Bubun kui. A xa dɛgɛ ɲinbanna ra han xɔtɔnni Alatala yɛtagi. Habadan sariyan nan na ra Isirayila yixɛtɛn muxune birin xa.” ");
INSERT INTO yal_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“I xa i tada Haruna xili e nun a diine Nadaba nun Abihu nun Eleyasari e nun Itamara, e xa wali n xa Isirayila kaane tagi alo saraxaraline. ");
INSERT INTO yal_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","I xa dugi sariɲanxine dɛgɛ i tada Haruna xa alogo a xa binyen nun xunnayerenna sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","I xa falan ti walikɛɛn birin xa naxanye fatan, n bata xaxili faɲin fi naxanye ma fe sifani itoe fe ra. E xa Harunaa dugine dɛgɛ, alogo a xa sariɲan, a yi saraxarali wanle kɛ n xa. ");
INSERT INTO yal_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","E xa marabɛriba sifani itoe nan dɛgɛ: Kanke masaan nun saraxarali domaan nun gubaan nun a doma bun bira faɲin nun namuna e nun tagixidina. E xa marabɛriba sariɲanxini itoe dɛgɛ i tada Haruna nun a diine xa, alogo e xa saraxarali wanle kɛ n xa. ");
INSERT INTO yal_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Dugi sɔxɔnne xa xɛmaan nawali, e nun gari mamiloxin nun a gbeela nun taa dugi faɲina.” ");
INSERT INTO yal_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“E xa saraxarali domaan xɛma daxin dɛgɛ gari mamiloxin nun a gbeela ra, e nun taa dugi faɲina, a findi wali faɲin na. ");
INSERT INTO yal_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","E xa a tungunne dɛgɛ, e lutine ti e xun firinne ma a xidi seen na. ");
INSERT INTO yal_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","A tagixidi faɲin fan dɛgɛma na kii nin: E nun saraxarali domaan xa findi kedenna ra. A rafalama xɛmaan nun gari mamiloxin nun a gbeela nun taa dugi faɲin nan na. ");
INSERT INTO yal_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","I xa onixi gɛmɛ firin tongo, i yi Isirayilaa diine xinle kɛrɛndɛn e ma. ");
INSERT INTO yal_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Xili sennin xa lu gɛmɛ kedenna ma, xili sennin yi lu gɛmɛn boden ma, fata e bari yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","I xa Isirayila kaane xinle kɛrɛndɛn gɛmɛ firinne ma, alo taxamasenna kɛrɛndɛnma kii naxan yi, i yi e sa gɛmɛ suxu se xɛma daxine kui. ");
INSERT INTO yal_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","I xa na gɛmɛ firinne ti saraxarali domaan tungunne ma, alo ɲɔxɔ lu gɛmɛne Isirayilaa diine xɔn. Haruna e xinle xalima nɛn a tungunne ma Alatala fɛma ɲɔxɔ lu feen na e xɔn. ");
INSERT INTO yal_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","I xa gɛmɛne suxu seene rafala xɛmaan na, ");
INSERT INTO yal_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","i yi xɛma faɲin yɔlɔnxɔndi firin singan e ra, naxanye dɛnbɛxi alo luti firin.” ");
INSERT INTO yal_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“I xa kanke masaan dɛgɛ, kitisa sena. A xa findi wali faɲin na. I xa a rafala alo saraxarali domana. A rafala xɛmaan nun gari mamiloxin nun a gbeela nun taa dugi faɲin na. ");
INSERT INTO yal_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","A xa rafala tongon naaninna ra. A xa yisa firinna ra, a kuyan nun a yigbona nɔngɔnna tagi. ");
INSERT INTO yal_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","I xa a rayabu gɛmɛ faɲin kira naanin na. I xa gɛmɛni itoe nan sa a kira singen ma: saridon gɛmɛn nun topasi gɛmɛn nun emerodi gɛmɛna. ");
INSERT INTO yal_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","A kira firindena: esikaribukili gɛmɛn nun safiri gɛmɛn nun dayimu gɛmɛna. ");
INSERT INTO yal_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Kira saxandena: opali gɛmɛn nun agati gɛmɛn nun ametisi gɛmɛna. ");
INSERT INTO yal_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Kira naanindena: kirisoliti gɛmɛn nun onixi gɛmɛn nun yasipi gɛmɛna. Gɛmɛni itoe xa sa gɛmɛ suxu se xɛma daxine kui. ");
INSERT INTO yal_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Gɛmɛ fu nun firinne luma Isirayilaa diine nan xili yi. Gɛmɛ yo gɛmɛ, i xa Isirayila bɔnsɔn keden xinla kɛrɛndɛn a ma taxamasenna ra. ");
INSERT INTO yal_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","I xa xɛma yɔlɔnxɔndine rafala kanke masaan xa, naxanye dɛnbɛxi alo lutina. ");
INSERT INTO yal_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","I xa wuredi digilinxi xɛma daxin firin nafala i yi e so kanke masaan xunne ra. ");
INSERT INTO yal_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","I xa yɔlɔnxɔndine xidi wuredine ra kanke masaan xunne ma, ");
INSERT INTO yal_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","i yi e so suxu se xɛma daxine ra, e yi singan saraxarali domaan tungun firinne ra a kanke ra. ");
INSERT INTO yal_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","I mɔn xa xɛma wuredi digilinxi firin nafala i naxanye singanma kanke masaan sanna bun ma a kui. ");
INSERT INTO yal_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","I mɔn xa xɛma wuredi digilinxi firin nafala i yi e singan saraxarali domaan tungun firinne laben na, a tagixidin faxa ra. ");
INSERT INTO yal_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","I xa kanke masaan wuredine nun saraxarali domaan wuredine xidi e bode ra luti mamiloxin na, alogo kanke masaan nama saraxarali domaan beɲin. ");
INSERT INTO yal_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Haruna na so yire sariɲanxini waxatin naxan yi, a Isirayila diine xinle xalima nɛn a kanke ra kitisa seen ma, kanke masana. Ɲɔxɔ lu feen nan na ra Alatala yɛtagi Isirayila diine xɔn waxatin birin. ");
INSERT INTO yal_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","I xa masɛnsɛn ti seene, Yurima nun Tumin sa kanke masaan yibaan kui. E xa lu Haruna kanke ra a na fa Alatala yɛtagi waxatin naxan yi. Nayi, Haruna Ala sagoon kolon seene xalima nɛn a kanke ra Isirayila kaane xa waxatin birin Alatala yɛtagi.” ");
INSERT INTO yal_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“I xa dugi mamiloxin dɛgɛ gubaan na naxan soma saraxarali domaan fari. ");
INSERT INTO yal_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","A kɔɛɛn xa lu a tagini, i yi dugina nde dɛgɛ a rabilinni alogo a nama bɔ. ");
INSERT INTO yal_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","I xa girenada wudi bogi sawurane dɛgɛ gari mamiloxin nun a gbeela ra a lenbene ma, i yi xɛma talandine singan e longori ra. ");
INSERT INTO yal_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Xɛma talanne xa singan girenada wudi bogi sawurane longori ra gubaan lenben nabilinna birin yi. ");
INSERT INTO yal_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Haruna xa gubaan so a nɛma walɛ waxatin naxan yi alogo a nama faxa. Talanne xuiin minima nɛn a na so yire sariɲanxini waxatin naxan yi Alatala yɛtagi hanma a na mini.” ");
INSERT INTO yal_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“I xa xɛma walaxadin nafala, i yi taxamasenni ito kɛrɛndɛn a ma fa fala, ‘Muxu Sariɲanxina Alatala Xa.’ ");
INSERT INTO yal_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","I yi a xidi luti mamiloxin na namun ma a tigi ra. ");
INSERT INTO yal_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","A luma nɛn Haruna tigi ra, Isirayila kaane hakɛ goronne yi lu Haruna xun ma e naxanye tongoxi saraxa sariɲanxine badeni. A luma nɛn a tigi ra waxatin birin yi alogo e xa rafan Alatala ma.” ");
INSERT INTO yal_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“I xa taa dugi faɲi dɛgɛ doma bun biran na. I yi taa dugi faɲin nafala namun na. Dugi sɔxɔnna xa tagixidin nafala.” ");
INSERT INTO yal_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“I xa dugine dɛgɛ Harunaa diine xa, i yi tagixidine rafala e xa, i yi xun tagixidine rafala e xa alogo e xa binyen nun xunnayerenna sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","I xa i tada Haruna maxidi e nun a diine. I xa e xunne masusan turen na, i yi e findi saraxaraline ra, i yi e rasariɲan alogo e xa saraxarali wanla kɛ n xa. ");
INSERT INTO yal_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","I xa wantanne dɛgɛ e xa, e ragenla nama lu, keli e tagiin ma han e danbane. ");
INSERT INTO yal_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haruna nun a diine xa e so benun e xa siga Naralan Bubun kui, hanma e nɛma maso saraxa ganden na walideni yire sariɲanxini. Nayi, e mi yulubin tongoma e faxa. Habadan sariyan na a ra Haruna xa e nun a yixɛtɛne birin.” ");
INSERT INTO yal_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“I xa saraxaraline rasariɲan ikii nin alogo e xa wanla kɛ n xa: Tura bulan keden tongo e nun konton firin fɛ mi naxanye ra. ");
INSERT INTO yal_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","I xa burun gan murutu fuɲi faɲin na, buru rate se mi naxan yi, i mɔn yi nde gan turen naxan yi e nun buru yilɛnlɛnxine turen saxi naxanye ma. ");
INSERT INTO yal_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","I xa e sa deben kui i yi e rali n ma, e nun turaan nun kontonne. ");
INSERT INTO yal_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","I xa Haruna nun a diine ti Naralan Bubun dɛ ra, i yi e maxa. ");
INSERT INTO yal_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","I xa dugine tongo, i yi doma bun biran nun gubaan nun saraxarali domaan nun kanke masaan nagodo Haruna ma. Saraxarali domaan xidi a tagi, a tagixidi faɲin na. ");
INSERT INTO yal_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","I xa namun so a xun na, i yi taxamaseri sariɲanxin xidi namun na. ");
INSERT INTO yal_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","I xa masusan turen tongo, i yi a sa Haruna xunni, a sugandi feen na. ");
INSERT INTO yal_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","I yi a diine fan nafa, i yi dugine ragodo e ma. ");
INSERT INTO yal_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","I xa e tagi xidi tagixidin na, i yi e xun tagixidine xidi. Habadan sariyan na a ra, saraxaraliyaan bata findi e gbeen na. Na kiini, i xa Haruna nun a diine dɔxɔ saraxaraliyani.” ");
INSERT INTO yal_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“I xa turaan ti Naralan Bubun yɛtagi, Haruna nun a diine xa e yiine sa turaan xunna fari. ");
INSERT INTO yal_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","I xa turaan kɔɛ raxaba Alatala yɛtagi Naralan Bubun so dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","I xa turaan wunla tongo, i yi a sa saraxa ganden tongonne fenne ma i yii sonla ra. I xa wuli dɔnxɛn nabɔxɔn saraxa ganden dɛxɔn ma. ");
INSERT INTO yal_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ɲingen turen naxan birin a fatini e nun farafaran naxan a bɔɲɛn ma e nun a gbingi ra xɛlɛ firinne nun e turene, i yi ne sa tɛɛni saraxa ganden fari.” ");
INSERT INTO yal_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","“Koni i xa turaan suben nun a kidin nun a gbiin woli tɛɛni yamaan daaxaden fari ma. Yulubi xafari saraxan na a ra. ");
INSERT INTO yal_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","I xa konton keden tongo. Haruna nun a diine xa e yiine sa kontonna xunna ma. ");
INSERT INTO yal_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","I xa a kɔɛ raxaba, i yi a wunla tongo, i yi a so saraxa ganden dɛxɔnne birin ma. ");
INSERT INTO yal_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","I xa kontonni bolon dungi dungin na, i yi a kui seene nun a sanne maxa, i ne sa a sube dungine nun a xunna fari. ");
INSERT INTO yal_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","I xa kontonna birin sa tɛɛni saraxa ganden fari. Saraxa gan daxin na a ra Alatala xa, naxan xiri rafan Alatala ma. A ralima Alatala ma tɛɛn nan na.” ");
INSERT INTO yal_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“I xa kontonna firinden tongo, Haruna nun a diine xa e yiine sa kontonna xunna ma. ");
INSERT INTO yal_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","I xa a kɔɛ raxaba, i yi a wunla tongo, i yi a sa Haruna nun a diine yiifari ma tunle ra, e nun e yiifari ma yii konkoribane ra e nun e yiifari ma san konkoribane ra. I yi wunla so saraxa ganden dɛxɔnne birin ma. ");
INSERT INTO yal_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","I xa wunla nde tongo saraxa ganden fari, e nun masusan turena, i yi a xuya Haruna nun a dugine ma, e nun a diine nun e dugine ma. Nayi, Haruna nun a diine nun e dugine sariɲanma nɛn. ");
INSERT INTO yal_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","I xa kontonna turen tongo, e nun a xunla nun turen naxan a kui seene ma e nun farafaran naxan a bɔɲɛn ma e nun a gbingi ra xɛlɛ firinne nun e turena, e nun a yiifari ma danbana. Amasɔtɔ saraxaraliin dɔxɔ kontonna na a ra. ");
INSERT INTO yal_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","I mɔn xa burun natetarena ndee tongo deben kui naxan Alatala yɛtagi: buru xun keden, buru keden naxan nafalaxi turen na e nun burudi keden. ");
INSERT INTO yal_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","I xa ne birin so Haruna nun a diine yii, e yi e mayita Alatala ra kise ralixin na. ");
INSERT INTO yal_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Na xanbi ra, i yi e ba e yii, i yi e sa tɛɛni saraxa ganden fari, e nun saraxa gan daxina. A xirin yi rafan Alatala ma. A ralima Alatala ma tɛɛn nan na. ");
INSERT INTO yal_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","I xa na kontonna firinden kanken tongo i yi a mayita Alatala ra kise ralixin na. Na yi findi i gbeen na. ");
INSERT INTO yal_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","I xa kontonna kanken nun a danban nasariɲan Haruna nun a diine xa, i naxanye ralixi n ma. ");
INSERT INTO yal_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Nanara, Isirayila kaane sube dungini itoe nan soma Haruna nun a yixɛtɛne yii, e na bɔɲɛ xunbeli saraxan ba waxatin naxan yi. Na nan luma Alatala xa.” ");
INSERT INTO yal_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Haruna na faxa, a dugi rasariɲanxine findima a diine nan gbee ra, alogo ne fan xa e so, e fan yi masusan, e dɔxɔ saraxaraliyani. ");
INSERT INTO yal_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Saraxaraliin naxan fama Haruna dangu xanbini, na a dugine soma nɛn xii solofere, benun a xa so Naralan Bubun kui walideni yire sariɲanxini.” ");
INSERT INTO yal_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“I xa saraxaraliin dɔxɔ kontonna tongo, i yi a suben ɲin yire sariɲanxina nde yi. ");
INSERT INTO yal_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Haruna nun a diine yi a don Naralan Bubun so dɛɛn na, e nun burun naxan deben kui. ");
INSERT INTO yal_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","E tan nan se ralixini itoe donma naxanye bata rawali Ala solona feen nun e dɔxɔ feen nun e rasariɲan feen na. Muxu gbɛtɛ nama e don, amasɔtɔ e sariɲan. ");
INSERT INTO yal_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Xa sube dɔnxɛn lu hanma buruna han xɔtɔnni, i xa a woli tɛɛni. A mi donma, amasɔtɔ a sariɲan. ");
INSERT INTO yal_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","I xa a liga Haruna nun a diine xa alo n ni i yamarixi kii naxan yi. I xa xii solofere ti e dɔxɔ feen na. ");
INSERT INTO yal_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","I xa tura keden ba Ala solona seen na lɔxɔ yo lɔxɔ. Na nan saraxa ganden nasariɲanma, i mɔn yi a masusan turen na alogo i xa a rasariɲan. ");
INSERT INTO yal_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","I xa Ala solona xii solofere bun ma. Na xanbi ra, saraxa ganden sariɲanma nɛn fefe! Naxan yo nɛma a yiin dinɲɛ saraxa ganden na fɔ na xa sariɲan.” ");
INSERT INTO yal_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ito nan bama saraxa ganden fari lɔxɔ yo lɔxɔ waxatin birin: yɛxɛɛ dii firin, ɲɛɛ keden kedenna. ");
INSERT INTO yal_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Kedenna xa ba xɔtɔnni, bonna ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Yɛxɛɛ singen xa ba e nun murutu fuɲi faɲin kilo saxan naxan basanxi oliwi ture faɲi litiri keden nun a tagi ra. Wudi bogi igena alo manpana, na litiri keden nun a tagi fan xa bɔxɔn saraxan na. ");
INSERT INTO yal_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Yɛxɛɛn firinden xa ba ɲinbanna ra e nun bogise saraxan nun minse saraxana alo a bama xɔtɔnni kii naxan yi. A xirin yi rafan Ala ma. A ralima Alatala ma tɛɛn nan na. ");
INSERT INTO yal_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Mayixɛtɛ famatɔne xa saraxa gan daxini ito ba waxatin birin Naralan Bubun so dɛɛn na Alatala yɛtagi. N naralanma ɛ ra mɛnna nin n yi falan ti ɛ xa. ");
INSERT INTO yal_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","N naralanma Isirayila kaane ra mɛnna nin, na yiren yi sariɲan n ma nɔrɔn xɔn. ");
INSERT INTO yal_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","N Naralan Bubun nasariɲanma nɛn e nun saraxa gandena. N yi Haruna nun a diine rasariɲan alogo e xa saraxarali wanla kɛ n xa. ");
INSERT INTO yal_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","N luma nɛn Isirayila kaane tagi, n findi e tan ma Ala ra. ");
INSERT INTO yal_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","E a kolonma nɛn a Alatala nan n tan na, e Ala, naxan e raminixi Misiran yi, alogo n xa lu e tagi. Alatala nan n tan na, e Ala.” ");
INSERT INTO yal_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“I xa wusulan ganden nafala kasiya wudin na. ");
INSERT INTO yal_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","A xa kuya yi nɔngɔnna yɛ keden, a yigbona nɔngɔnna yɛ keden, a yitena nɔngɔnna yɛ firin. I xa feri keden nafala a tongon naaninne ma, e nun wusulan ganden yi findi se kedenna ra. ");
INSERT INTO yal_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","I xa xɛma faɲin sa a fanna nun a dɛxɔnne nun a fenne ma, i yi xɛmaan sa a rabilinni a ɲinginne ma. ");
INSERT INTO yal_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","I xa tami raso yinla xɛma daxin firin nafala wusulan ganden ɲinginne bun ma alogo a tongo tamine xa raso a fɔxɔ firinne ra. ");
INSERT INTO yal_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","I xa kasiya wudin nafala tamine ra, i yi xɛmaan sa e ma. ");
INSERT INTO yal_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","I xa wusulan ganden ti dugin yɛtagi Layiri Sereya Kankiraan yɛ masansanxi naxan na, n solonama dɛnaxan yi, n naralanma i ra dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Haruna xa wusulanna gan xɔtɔn yo xɔtɔn, a nɛma lɛnpune yitɔnɲɛ waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","A mɔn xa a gan ɲinbari yo ɲinbari, a nɛma lɛnpune radɛgɛ waxatin naxan yi. Nayi, wusulanna ganma nɛn Alatala yɛtagi waxati famatɔne birin yi. ");
INSERT INTO yal_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ɛ nama wusulanna radaxataren gan saraxa ganden fari, hanma ɛ saraxa gan daxin ba, hanma bogise saraxana, hanma ɛ minse saraxan nabɔxɔn a fari. ");
INSERT INTO yal_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Sanɲa yi keden ɲɛɛn bun ma, Haruna xa yulubi xafari saraxan wunla xuya a fenne ma. Nayi, a a rasariɲan ɲɛɛ yo ɲɛɛ waxati famatɔne yi. A sariɲan Alatala yɛɛ ra yi han!” ");
INSERT INTO yal_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Alatala yi falan ti Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“I na Isirayila kaane matɛngɛ waxatin naxan yi, birin xa a niin xunba saren fi Alatala ma, a nɛma tɛngɛ waxatin naxan yi. Nayi, fitina furen mi yamaan suxɛ. ");
INSERT INTO yal_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Naxan yo na tɛngɛ, na xa gbeti gbanan keden fi naxan lanxi sɛkɛlɛ tagiin ma, wure gbeti fixɛni ligaseen naxan nawalima yire sariɲanxini, naxan lanxi garamu suulun ma. Gbeti gbananni itoe luma Alatala nan xa. ");
INSERT INTO yal_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Isirayila kaan naxanye bata ɲɛɛ mɔxɔɲɛ sɔtɔ, ne birin xa ito fi Alatala ma. ");
INSERT INTO yal_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Se kanna nama nde sa a fari, yiigelitɔɔn nama nde ba gbeti gbanan kedenna ra, bayo ɛ niin xunba saren nan fima Alatala ma. ");
INSERT INTO yal_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","I xa xunba gbetini itoe rasuxu Isirayila kaane yii, i yi a rawali Naralan Bubun wanli. Na findima ɲɔxɔ lu seen nan na Isirayila kaane xɔn Alatala yɛtagi, a yi e niin xunba.” ");
INSERT INTO yal_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Ige ramara se sula daxin nafala maxaden na e nun a bundɔxɔn sula daxin naxan tima a bun. I xa a ti Naralan Bubun nun saraxa ganden tagi, i yi igen sa a kui. ");
INSERT INTO yal_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haruna nun a diine e yiine nun e sanne maxama na igen nan na. ");
INSERT INTO yal_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","E na so Naralan Bubun kui waxatin naxan yi, e xa e maxa, alogo e nama faxa. E na e maso saraxa ganden na saraxa ralideni Alatala ma tɛɛn na, ");
INSERT INTO yal_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","e xa e yiine nun e sanne maxa, alogo e nama faxa. Habadan sariyan na a ra Haruna nun a yixɛtɛne xa waxati famatɔne yi.” ");
INSERT INTO yal_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Wudi se xiri ɲaxumɛni itoe tongo: mirihi latikɔnɔnna kilo suulun, sinamon wudi xiri ɲaxumɛn kilo firin e nun a tagi, xaye xiri ɲaxumɛn kilo firin e nun a tagi, ");
INSERT INTO yal_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","sinamon fuge xaren kilo suulun, e nun oliwi turen litiri sennin. Ɛ xa ne maliga liga seene ra naxanye rawalima yire sariɲanxini. ");
INSERT INTO yal_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ɛ itoe birin basan latikɔnɔnna rafala fena, e findi masusan ture sariɲanxin na naxan xirin ɲaxun.” ");
INSERT INTO yal_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","“I xa Naralan Bubun nun Layiri Sereya Kankiraan masusan na ra, ");
INSERT INTO yal_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","e nun tabanla nun a waliseene, e nun lɛnpu dɔxɔ seen nun a waliseene e nun wusulan gandena, ");
INSERT INTO yal_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","e nun saraxa gan daxin baden nun a waliseene, e nun ige ramara seen nun a bundɔxɔna. ");
INSERT INTO yal_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","I xa ne rasariɲan alogo e xa sariɲan fefe! Naxan yo nɛma a yiin dinɲɛ e ra, fɔ a xa sariɲan nɛn. ");
INSERT INTO yal_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","I xa Haruna nun a diine masusan, i yi e rasariɲan alogo e xa saraxarali wanla kɛ n xa.” ");
INSERT INTO yal_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","I xa a fala Isirayila kaane xa, i naxa, “A findima n ma masusan ture sariɲanxin nan na waxati famatɔne birin yi. ");
INSERT INTO yal_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Muxu yo nama a sugusugu a fatin ma. Muxu yo nama a sifan nafala. A sariɲan, ɛ xa a yatɛ se sariɲanxin na. ");
INSERT INTO yal_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Naxan yo na a sifan nafala hanma a a sa muxu gbɛtɛ ma ba saraxaraline ra, a kedima nɛn yamaan tagi.” ");
INSERT INTO yal_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Alatala yi a fala Musa xa, a naxa, “Se xiri ɲaxumɛne tongo: mirihi latikɔnɔn xaraxin nun onixi gɛmɛ fuɲina e nun galibanun salenna. I mɔn yi wusulan faɲin sa a fari. ");
INSERT INTO yal_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Latikɔnɔn nafalan xa e basan, a findi wusulan xiri ɲaxumɛn na. Fɔxɔn xa sa ayi alogo a xa ramara, a lu sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","I xa na nde findi a fuɲin na, i yi a sa Layiri Kankiraan yɛtagi Naralan Bubuni, n naralanma i ra dɛnaxan yi. A findima ɛ xa se sariɲanxin nan na naxan sariɲan han! ");
INSERT INTO yal_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ɛ nama wusulanni ito ɲɔxɔn nafala ɛ yɛtɛ xa. Ɛ xa a yatɛ se sariɲanxin na Alatala xa. ");
INSERT INTO yal_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Xa muxuna nde wusulan sifani ito rafala alogo a xa a xirin mɛ, a kedima nɛn yamaan tagi.” ");
INSERT INTO yal_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“A mato, n bata Yuri a diin Bɛsalɛli sugandi, Xuru mamandenna Yuda bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","N bata a ralugo Alaa Nii Sariɲanxin nun xaxilimayaan nun kolonna ra alogo a xa fatan wali wuyaxi kɛ, ");
INSERT INTO yal_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","alogo a xa nɔ wali gbeene rakamalideni, a xɛmaan nawali, e nun gbetin nun sulana, ");
INSERT INTO yal_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","a gɛmɛ faɲine masoli a yi e suxu seene yitɔn, a wudin nawali, alogo a xa wali tofaɲine kɛ. ");
INSERT INTO yal_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","N mɔn bata Dan bɔnsɔnna Axisamaki a dii Oholiyabi so a yii a mali muxun na. N mɔn bata a ragidi walikɛne birin xa fatan wanle ra n bata ɛ yamari naxan ma: ");
INSERT INTO yal_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Naralan Bubuna, Layiri Sereya Kankirana Ala solonama dɛnaxan yi, e nun bubun kui seene birin, ");
INSERT INTO yal_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tabanla nun a waliseene, lɛnpu dɔxɔ se xɛma daxin nun a waliseene birin, wusulan gandena, ");
INSERT INTO yal_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","saraxa gan daxin baden nun a waliseene birin, ige ramara seen nun a bundɔxɔna, ");
INSERT INTO yal_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","taa dugine, dugi rasariɲanxine saraxarali Haruna xa, e nun dugine a diine xa saraxarali wanli, ");
INSERT INTO yal_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","masusan turena, e nun wusulan xiri ɲaxumɛna yire sariɲanxin xa. E xa ne birin nafala alo n na e yamarixi i ma kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“A fala Isirayila kaane xa, i naxa, ‘Ɛ Matabu Lɔxɔne suxu. E findima nɛn taxamasenna ra n tan nun ɛ tan tagi waxati famatɔne muxune xa, alogo e xa a kolon a n tan Alatala nan ɛ rasariɲanma. ");
INSERT INTO yal_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ɛ xa Matabu Lɔxɔn suxu, amasɔtɔ a sariɲan ɛ tan yii. Xa naxan mi a suxu, a wali na lɔxɔni, a kedima nɛn a yamani, ɛ yi a faxa. ");
INSERT INTO yal_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","I walima nɛn xii sennin, koni xii soloferede lɔxɔn findima Matabu Lɔxɔn nan na, naxan sariɲan Alatala yɛtagi. Muxu yo na wali Matabu Lɔxɔni ɛ xa a faxa. ");
INSERT INTO yal_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isirayila kaane xa Matabu Lɔxɔn suxu, e yixɛtɛne birin xa Matabu Lɔxɔn sanla raba. Habadan layirin na a ra. ");
INSERT INTO yal_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","A findima taxamasenna nan na n tan nun Isirayila tagi habadan! Amasɔtɔ Alatala bɔxɔn nun koren daxi xii senninna bun, xii soloferede lɔxɔni a yi wanla dan, a yi a matabu.’ ” ");
INSERT INTO yal_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ala to yelin falan tiyɛ Musa xa Sinayi geyaan fari, a yi Layirin Sereya walaxa firinne so a yii, gɛmɛ walaxane Ala naxanye kɛrɛndɛnxi a yiin na. ");
INSERT INTO yal_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Yamaan to a to a Musa yi buma gododeni geyaan fari, e yi e malan Haruna fɛma. E yi a fala a xa, e naxa, “Keli! I yi ala gbɛtɛne rafala en xa naxanye tima en yɛɛ ra! Musa ito, xɛmɛn naxan en naminixi Misiran yamanani, en mi a kolon naxan a sɔtɔxi.” ");
INSERT INTO yal_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Haruna yi a fala e xa, a naxa, “Ɛ xɛmaan tunla soone ba ɛ tunle ra, e nun ɛ ɲaxanle tunle ra, e nun ɛ dii xɛmɛne nun ɛ dii tɛmɛne, ɛ fa e ra n fɛma.” ");
INSERT INTO yal_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","E yi e xɛmaan tunla soone birin ba, e fa e ra Haruna fɛma. ");
INSERT INTO yal_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","A yi e rasuxu e ra, a xɛmane raxulun, a yi e igen nafala ɲinge dii sawuran na kulunden na. E yi a fala, e naxa, “Isirayila! Ɛ gbee alane ni i ra, naxan i raminixi Misiran yamanani!” ");
INSERT INTO yal_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Haruna to na to, a yi saraxa ganden nafala ɲinge dii sawuran yɛtagi. A a rali e ma, a naxa, “Tila, sanla rabama nɛn Alatala xa!” ");
INSERT INTO yal_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Na xɔtɔn bode, e keli sinma, e yi saraxa gan daxine nun bɔɲɛ xunbeli saraxane ba. Yamaan yi dɔxɔ e dɛgeden nun e mindeni, e lu kelɛ, e sabaan so. ");
INSERT INTO yal_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Alatala yi a fala Musa xa, a naxa, “Siga! Godo! Amasɔtɔ i ya yamana, i naxan naminixi Misiran yamanani, e bata kala. ");
INSERT INTO yal_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","E bata kiraan fata xulɛn, n na e yamarixi naxan ma! E bata xɛma raxulunxin nafala ɲinge dii sawura suxuren na, e yi e xinbi sin a bun. E bata saraxane ba a xa, e yi a fala, e naxa, ‘Isirayila! Ɛ gbee alane ni i ra, naxanye i raminixi Misiran yamanani.’ ” ");
INSERT INTO yal_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Alatala yi a fala Musa xa, a naxa, “N bata yamani ito to, yama murutɛxin na a ra. ");
INSERT INTO yal_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Iki i xa i masiga n na. N ma xɔlɔn xa keli e xili ma, n xa e raxɔri. N ni i tan nan bɔnsɔn findima siya gbeen na.” ");
INSERT INTO yal_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Musa yi Alatala mafan, a Ala, a naxa, “Ee! Alatala! I ya xɔlɔn kelima i ya yamaan xili ma nanfera, i naxan naminixi Misiran yamanani i sɛnbɛ gbeen nun i yii barakaxin na? ");
INSERT INTO yal_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Xa i ito liga, Misiran kaane a falɛ nɛn, e naxa, ‘A e raminixi Misiran yi miriya ɲaxin nan ma, alogo a xa sa e faxa geyane ma, a yi e ɲan bɔxɔn fari.’ I ya xɔlɔ gbeen lu! I diɲa! I nama yihadin nagodo i ya yamaan ma! ");
INSERT INTO yal_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Iburahima fe xa rabira i ma, e nun Isiyaga nun Isirayila, i ya walikɛne. I kɔlɔ nɛn i yɛtɛ yi, i naxa, ‘N na ɛ bɔnsɔnna rawuyama ayi nɛn alo saren naxanye kore. N bɔxɔni ito birin soma i bɔnsɔnna yii nɛn n ni i tuli saxi naxan na, a findi e kɛɛn na habadan!’ ” ");
INSERT INTO yal_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Alatala yi diɲa, a mi yihadin nagodo a yamaan ma, a feen naxan falaxi. ");
INSERT INTO yal_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa yi xɛtɛ keli geyaan fari, Layirin Sereya walaxa firinne suxi a yii. Walaxane fɔxɔ firinne birin yi sɛbɛxi. ");
INSERT INTO yal_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ala nan na walaxane rafala. Ala nan yi sɛbɛnla ne tixi, naxanye yi kɛrɛndɛnxi walaxane ma. ");
INSERT INTO yal_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yosuwe to yamaan sɔnxɔ xuiin mɛ, a yi a fala Musa xa, a naxa, “Yɛngɛ so sɔnxɔn tema yamaan daaxadeni!” ");
INSERT INTO yal_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa yi a yabi, “Nɔ tiine sɔnxɔ xui mi ito ra. Muxu bɔnbɔxine sɔnxɔ xui mi ito ra. N tan sigi sa xuiin nan mɛma.” ");
INSERT INTO yal_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","E to maso yamaan daaxaden na, e yi ɲinge dii sawuran to e nun bodonlane. Musa yi xɔlɔ han! Walaxan naxanye yi a yii, a yi ne woli ayi, a yi e yibɔ geyaan san bun. ");
INSERT INTO yal_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","E ɲinge diin naxan nafala, a na tongo, a yi a gan. A yi a findi a fuɲin na, a yi a xuya igen xun ma, a yi Isirayila kaane karahan, e yi a min. ");
INSERT INTO yal_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa yi a fala Haruna xa, a naxa, “Yamani ito nanse ligaxi i ra, alogo i xa ti e yɛɛ ra yulubi gbeeni ito ligadeni?” ");
INSERT INTO yal_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haruna yi a yabi, a naxa, “N kanna nama xɔlɔ! I tan yɛtɛna a kolon, yamani ito ɲaxu. ");
INSERT INTO yal_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","E a falaxi n xa nɛn, e naxa, ‘Alane rafala en xa naxanye tima en yɛɛ ra. Musa ito, xɛmɛn naxan en naminixi Misiran yamanani, en mi a kolon naxan a sɔtɔxi.’ ");
INSERT INTO yal_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","N yi a fala e xa, n naxa, ‘Maxidi se xɛmaan naxanye yii, ne xa e ba!’ E yi e so n yii, n yi e woli tɛɛni, ɲinge diini ito yi mini!” ");
INSERT INTO yal_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa yi a to a yamaan mi yi yagima, a Haruna bata yi tin yamana yɛtɛ suxutareyaan ma, e yi findi magele seen na e yaxune xa. ");
INSERT INTO yal_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musa yi ti yamaan daaxaden so dɛɛn na, a naxa, “Naxanye Alatala xa, ne xa fa n fɛma!” Lewi bɔnsɔnna birin yi e malan a fɛma. ");
INSERT INTO yal_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","A yi a fala e xa, a naxa, “Alatala, Isirayilaa Ala ito nan falaxi, a naxa, ‘Birin xa a silanfanna xidi a tagi. Ɛ yamaan daaxadeni siga, keli fɔxɔ boden ma han bodena, birin xa a ngaxakedenna faxa e nun a lanfaan nun a dɔxɔ bodena.’ ” ");
INSERT INTO yal_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lewi bɔnsɔnna yi Musaa yamarin suxu, na lɔxɔni muxu wuli saxan yi faxa yamaan na. ");
INSERT INTO yal_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa yi a fala, a naxa, “Ɛ bata rasariɲan Alatala xa to, bayo ɛ kelixi ɛ diine nun ɛ ngaxakedenne nan xili ma. A bata ɛ baraka to.” ");
INSERT INTO yal_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Na xɔtɔn bode, Musa yi a fala yamaan xa, a naxa, “Ɛ bata yulubi gbeen liga. Iki n xa te Alatala fɛma. Waxatina nde n na solonama ɛ xa nɛn ɛ yulubine fe ra.” ");
INSERT INTO yal_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musa yi xɛtɛ Alatala fɛma, a naxa, “Yamani ito bata yulubi gbeen liga! E bata xɛmaan nafala suxurene ra. ");
INSERT INTO yal_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Diɲa e yulubine ma! Xa na mi a ra, i xa n tan fan xinla ba i ya kitabu sɛbɛxin kui.” ");
INSERT INTO yal_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Alatala yi a fala Musa xa, a naxa, “Naxan yulubin ligaxi n na, n na nan xili bama n ma kitabun kui. ");
INSERT INTO yal_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Iki siga, i yamaan xali mɛnni n dɛnaxan falaxi. N ma malekan tima nɛn i yɛɛ ra. Koni a waxatin na a li, n na e ɲaxankatama nɛn e yulubine fe ra.” ");
INSERT INTO yal_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Alatala yi yamaan ɲaxankata fitina furen na, amasɔtɔ e bata yi ɲinge dii sawuran nafala, Haruna naxan nafala. ");
INSERT INTO yal_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Alatala yi a fala Musa xa, a naxa, “Siga, keli be, i tan nun yamani ito, i naxan naminixi Misiran yamanani. Ɛ te na bɔxɔni n na n dɛ ti naxan ma fe ra, a n na a soma nɛn Iburahima nun Isiyaga nun Yaxuba yii. N naxa, ‘N na a soma nɛn i bɔnsɔnna yii.’ ");
INSERT INTO yal_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","N malekan nasigama nɛn i yɛɛ ra, alogo a xa Kanan kaane nun Amorine nun Xitine nun Perisine nun Xiwine nun Yebusune kedi i yɛɛ ra. ");
INSERT INTO yal_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ɛ xa te na bɔxɔni kumin nun nɔnɔn gbo dɛnaxan yi. Koni n mi sigama ɛ fɔxɔ ra alogo n nama ɛ faxa kira yi. Amasɔtɔ yama murutɛxin nan ɛ ra.” ");
INSERT INTO yal_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Yamaan to fala xɔdɛxɛni itoe mɛ, e yi sunu, muxu yo mi a maxidi seene so. ");
INSERT INTO yal_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Alatala bata yi a fala Musa xa, a naxa, “A fala Isirayila yamaan xa, i naxa, ‘Yama murutɛxin nan ɛ ra! Xa en birin siga waxatidi tun, n na ɛ raxɔrima nɛn. Iki, ɛ ɛ maxidi seene ba, n xa a ragidi n naxan ligama ɛ ra.’ ” ");
INSERT INTO yal_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Isirayila kaane to yi kelima Horebe geyaan ma, e yi e maxidi seene ba. ");
INSERT INTO yal_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa yi darixi bubun tiyɛ yamaan daaxaden nan fari ma wulani, a yi a xili sa “Naralan Bubuna.” Naxanye birin yi wama Alatala maxɔdin feni, ne yi sigama Naralan bubun nin, naxan yi yamaan daaxaden fari ma. ");
INSERT INTO yal_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Musa nɛma yi sigɛ bubuni, yamaan birin yi kelima nɛn, e ti e bubune dɛ ra, e yɛɛn bira Musa fɔxɔ ra han a so bubuni. ");
INSERT INTO yal_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa nɛma yi soɛ bubuni, kundaan yi godoma nɛn, a ti bubun so dɛɛn na Ala nɛma yi falan tiyɛ Musa xa waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Yamaan na yi kundaan to bubun so dɛɛn na, e yi kelima nɛn, e Ala batu e bubune so dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Alatala yi falan tima Musa xa nɛn yɛɛ nun yɛɛ, alo muxun falan tima a lanfaan xa kii naxan yi. Na xanbi ra, Musa yi xɛtɛma nɛn yamaan daaxadeni, koni Nunu a dii banxulanna naxan yi Musa malima, Yosuwe, na mi yi kelima bubun kui. ");
INSERT INTO yal_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa yi a fala Alatala xa, a naxa, “I a falama n xa, i naxa, ‘Ti yamani ito yɛɛ ra!’ Koni i munma a yita n na i naxan nasigama n fɔxɔ ra. I bata a fala, i naxa, ‘N ni i xinla kolon, i bata n kɛnɛn.’ ");
INSERT INTO yal_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Iki, xa n bata i kɛnɛn, i xa n xaran i ya kirane ma. Nayi, n ni i kolonɲɛ, n yi lu i kɛnɛnɲɛ. A mato, i gbee siyaan nan yamani ito ra.” ");
INSERT INTO yal_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ala yi a yabi, a naxa, “N tan yɛtɛɛn nan i matima, n yi bɔɲɛ xunbenla fi i ma.” ");
INSERT INTO yal_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa yi a fala a xa, a naxa, “Xa en birin mi sigama, i nama nxu rakeli be. ");
INSERT INTO yal_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","A kolonma di nayi, a nxu nun i ya yamaan bata i kɛnɛn, xa en birin mi sigama? I ya yamaan nun bonne tagi rabama di, naxanye birin bɔxɔn fari?” ");
INSERT INTO yal_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Alatala yi a fala Musa xa, a naxa, “I naxan maxɔdinxi n ma, n na a ligama nɛn, amasɔtɔ i bata n kɛnɛn, e nun n ni i xinla kolon.” ");
INSERT INTO yal_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa yi a fala, a naxa, “Awa, i ya nɔrɔn yita n na!” ");
INSERT INTO yal_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Alatala yi a yabi, a naxa, “N na n ma nɛmaan birin nadanguma nɛn i yɛtagi, n yi n xinla fala, ‘Alatala.’ N hinanɲɛ naxan na, n hinanma nɛn na ra, n kininkininɲɛ naxan ma, n kininkininma nɛn na ma. ");
INSERT INTO yal_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Koni, i mi nɔɛ n yɛtagin toɛ, amasɔtɔ muxun mi nɔɛ a toɛ, a lu a nii ra.” ");
INSERT INTO yal_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Alatala yi a fala, a naxa, “I tima nɛn gɛmɛn fari yirena nde yi be. ");
INSERT INTO yal_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","N nɔrɔn nɛma danguɛ, n na i rasoma nɛn gɛmɛ yinla ra, n yi n yiin sansan i ma han n dangu. ");
INSERT INTO yal_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","N na n yiin ba na, i n xanbin toma nɛn, koni n yɛtagin mi nɔɛ toɛ.” ");
INSERT INTO yal_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Alatala yi a fala Musa xa, a naxa, “Gɛmɛ walaxa firin masoli alo a singene, i naxanye yibɔxi. N falane sɛbɛma e ma nɛn naxanye yi bonne ma. ");
INSERT INTO yal_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","I xa i yitɔn xɔtɔnni. I te Sinayi geyaan fari. I fa n nalan mɛnni geyaan xuntagi. ");
INSERT INTO yal_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Muxu yo nama bira i fɔxɔ ra. Muxu yo nama lu geyaan mumɛɛn fari. Hali xuruse kurune nama dangu geyaan san bun.” ");
INSERT INTO yal_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musa yi gɛmɛ walaxa firin masoli alo a singene, a kurun tɛ Sinayi geyaan fari, alo Alatala a yamari kii naxan yi. Gɛmɛ walaxa firinne yi suxi a yii. ");
INSERT INTO yal_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Alatala yi godo kunda yiyani, a ti mɛnni a fɛma, a yi a xinla fala, Alatala. ");
INSERT INTO yal_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","A yi dangu Musa yɛtagi, a naxa, “Alatala! Alatala! Ala naxan kininkinin, a mɔn diɲa. A mi xɔlɔn xulɛn, a hinanna nun a tinxinna gbo. ");
INSERT INTO yal_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","A hinanma nɛn han mayixɛtɛ wuli keden, a diɲa hakɛn nun matandin nun yulubin ma. Koni, a mi yulubi kanna yatɛma tinxinden na mumɛ! A fafane hakɛn saranma nɛn e diine ra han mayixɛtɛ saxan hanma naanin.” ");
INSERT INTO yal_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa yi a xinbi sin bɔxɔni mafurɛn! A Ala batu. ");
INSERT INTO yal_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","A yi a fala, a naxa, “Marigina, xa n bata i kɛnɛn, en birin xa siga. Hali yama murutɛxin na a ra, i xa nxu mafelu nxɔ hakɛne nun yulubine ra, i nxu findi i gbeen na.” ");
INSERT INTO yal_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Alatala yi a yabi, a naxa, “N layirin xidima nɛn en tagi. N kabanakone ligama nɛn Isirayila yamaan birin yɛɛ xɔri naxanye munma liga yamana yo yi dunuɲa yi. Siyaan naxanye birin i rabilinxi, ne n ma kabanako wanla toma nɛn n naxan ligama ɛ xa.” ");
INSERT INTO yal_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“N na i yamarima naxan ma to, i xa na suxu. N Amorine nun Kanan kaane nun Xitine nun Perisine nun Xiwine nun Yebusune kedima nɛn i yɛɛ ra. ");
INSERT INTO yal_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ɛ soma yamanan naxan yi, ɛ nun mɛn kaane nama layiri yo xidi alogo e nama ɛ raso tantanni. ");
INSERT INTO yal_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ɛ xa e saraxa gandene nun e kide gɛmɛne birin kala. Ɛ yi e Asera kide gbindonne sɛgɛ, ɛ yi e suxurene birin gan.” ");
INSERT INTO yal_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ɛ nama ala gbɛtɛ batu, amasɔtɔ Alatala xɔxɔlɔn, a xili nɛn “Ala xɔxɔlɔnxina.” ");
INSERT INTO yal_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ɛ nun yamanani ito muxune nama layiri yo xidi, alogo e nɛma e yɛtɛ xɔsima e alane fɛma, e saraxane ba e xa, e nama ɛ xili. Ɛ nama e saraxane don. ");
INSERT INTO yal_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ɛ nama e dii tɛmɛne tongo ɛ dii xɛmɛne xa e ɲaxanle ra, alogo e dii tɛmɛne nɛma e yɛtɛ raxɔsima e alane fɛma, e nama ɛ diine maxaran e yi bira e fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","I nama suxurene rafala wure raxulunxin na. ");
INSERT INTO yal_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","I xa Buru Tetaren Sanla raba. Xii solofere bun ma, i xa buru ratetaren don alo n ni i yamari kii naxan yi. Ito liga a waxatini Abiba kiken na, amasɔtɔ i minixi Misiran yi na kiken nan na. ");
INSERT INTO yal_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","N gbeen nan dii singene birin na e nun xuruseene dii xɛmɛ singene birin, yɛxɛɛne nun siine nun ɲingene. ");
INSERT INTO yal_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Xa sofali dii xɛmɛ singen na a ra, i xa a xunba yɛxɛɛ diin na hanma sii diina. Koni, xa i mi a xunba, i xa a kɔɛɛn gira, i yi a faxa. I mɔn xa i ya dii xɛmɛ singene birin xunba. Muxu yo nama fa n yɛtagi n kise mi a yii. ");
INSERT INTO yal_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","I walima nɛn xii sennin, i yi i matabu xii soloferede lɔxɔni. I xa i matabu, hali xɛɛ bi waxatin nun se xaba waxatini. ");
INSERT INTO yal_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","I xa Xunsagine Sanla raba, i na se xaban fɔlɔ waxatin naxan yi. I xa Se Xaba Dɔnxɛn sanla raba ɲɛɛ raɲanni. ");
INSERT INTO yal_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Yamaan birin xa fa Marigina Alatala yɛtagi dɔxɔ saxan ɲɛɛn bun ma, Isirayilaa Ala. ");
INSERT INTO yal_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Amasɔtɔ n siyane kedima nɛn i yɛɛ ra, n yi i ya bɔxɔn nagbo ayi alogo muxu yo nama i ya yamanan yɛngɛ, i nɛma sigɛ Alatala i ya Ala yɛtagi waxatin naxan yi, han dɔxɔ saxan ɲɛɛn bun ma. ");
INSERT INTO yal_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","I nama buru ratexin sa saraxa yo fari i naxan bama n xa. I mɔn nama Halagi Tiin Dangu Lɔxɔn Sanla saraxan namara han xɔtɔnni. ");
INSERT INTO yal_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","I xa fa i ya xɛɛn bogise singe faɲine ra Alatalaa banxini, i ya Ala. I nama sii diin ɲin a nga xiɲɛ igen na. ");
INSERT INTO yal_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Alatala yi a fala Musa xa, a naxa, “Falani itoe sɛbɛ, amasɔtɔ n layirin xidima en tagi falani itoe nan xɔn e nun Isirayila kaane.” ");
INSERT INTO yal_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa yi lu Alatala fɛma soge tonge naanin nun kɔɛ tonge naanin. A mi donse don, a mi ige min. Alatala yi layirin falane sɛbɛ walaxane ma, Yamari Fu. ");
INSERT INTO yal_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa to godo Sinayi geyaan fari, Layirin Sereya walaxa firinne suxi a yii, a mi yi a kolon xa a yɛtagin mayilenma, amasɔtɔ a bata yi falan ti Ala xa. ");
INSERT INTO yal_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haruna nun Isirayila kaane birin yi Musa toma, a yɛtagin yi mayilenma. E yi gaxu e masoɛ a ra. ");
INSERT INTO yal_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Musa yi e xili. Nanara, Haruna nun yamaan kuntigine birin yi fa a fɛma, a falan ti e xa. ");
INSERT INTO yal_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Na xanbi ra, Isirayila kaane birin yi e maso Musa ra, a yamarine birin so e yii Alatala naxanye fixi a ma Sinayi geyaan fari. ");
INSERT INTO yal_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa to yelin falan tiyɛ e xa, a yi dugi yalanxin so a yɛtagin xun na. ");
INSERT INTO yal_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Musa nɛma yi fɛ Alatala yɛtagi falatideni a xa, a yi dugin bama nɛn han a yi mini. A to yi minima, a yi a falama nɛn Isirayila kaane xa naxan yi yamarixi. ");
INSERT INTO yal_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Isirayila kaane yi a toma a a yɛtagin mayilenma. Musa yi dugi yalanxin sama nɛn a yɛtagin ma han a yi so falatideni Ala xa. ");
INSERT INTO yal_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa yi Isirayila yamaan birin malan, a yi a fala e xa, a naxa, “Alatalaa yamarine nan itoe ra: ");
INSERT INTO yal_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Xii sennin bun ma, ɛ xa wanla kɛ, koni xii soloferede lɔxɔn sariɲan. Matabu Lɔxɔn na a ra naxan nasariɲanxi Alatala xa. Muxu yo na wali na lɔxɔni ɛ xa a faxa. ");
INSERT INTO yal_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ɛ nama tɛɛn nadɛgɛ ɛ konne yi Matabu Lɔxɔni.” ");
INSERT INTO yal_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa yi a fala Isirayila kaane xa, a naxa, “Alatala ito nan yamarixi: ");
INSERT INTO yal_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Ɛ xa fa yii malan seene ra Alatala xa ɛ ɲɛnige faɲin na: xɛmana, gbetina, sulana, ");
INSERT INTO yal_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","gari mamiloxin nun a gbeela, taa dugi faɲina, e nun sii xabe dugine, ");
INSERT INTO yal_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","konton kidi magbelixine, sube kidine, kasiya wudina, ");
INSERT INTO yal_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lɛnpu turena, se xiri ɲaxumɛne naxan sama se masusan tureni, e nun wusulan xiri ɲaxumɛna, ");
INSERT INTO yal_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","onixi gɛmɛ tofaɲine, e nun gɛmɛ tofaɲin gbɛtɛne saraxarali domaan nun a kanke masaan nayabu seen na.” ");
INSERT INTO yal_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Naxanye birin fatan walideni ɛ yɛ, ne xa fa seni itoe rafaladeni Alatala naxanye yamarixi: ");
INSERT INTO yal_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Ala Batu Bubun nun a xunna sona, a suxu seene, a bun tiine, a gaalane, a sɛnbɛtɛnne, e nun a bundɔxɔne; ");
INSERT INTO yal_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Layiri Kankirana, a tongo tamine, a dɛraganla, e nun a yɛ masansan dugina; ");
INSERT INTO yal_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","tabanla nun a tongo tamine, a waliseene birin, e nun buru ralixina; ");
INSERT INTO yal_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","lɛnpu dɔxɔ seen nun a waliseene, a lɛnpune, e nun a turen naxan bubuni yalanma; ");
INSERT INTO yal_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","wusulan ganden nun a tongo tamine, masusan turena, wusulan xiri ɲaxumɛna, dugin naxan singanxi Ala Batu bubun so dɛɛn na; ");
INSERT INTO yal_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","saraxa gan daxi baden nun a wure masɔxɔnxina, a tongo tamine, e nun a waliseene birin; ige sa se sula daxin nun a bundɔxɔna; ");
INSERT INTO yal_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","sansan dugine, a sɛnbɛtɛnne, e bundɔxɔne, e nun dugin naxan singanxi sansanna so dɛɛn na; ");
INSERT INTO yal_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","tamin naxanye gbangbanma bɔxɔni Ala Batu Bubun xidi seen na, e nun sansanna gbeene nun e lutine; ");
INSERT INTO yal_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","taa dugi naxan soma walideni yire sariɲanxini, dugi rasariɲanxine saraxarali Haruna xa, e nun a diine gbeen naxanye soma saraxa ralideni.” ");
INSERT INTO yal_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Isirayila yamaan birin yi keli Musa fɛma. ");
INSERT INTO yal_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Naxanye birin a ɲɛnige, ne yi fa kiseene ra Alatala xa, Naralan Bubun wanla fe ra, e nun dugi rasariɲanxine rafala fena. ");
INSERT INTO yal_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Xɛmɛn nun ɲaxanla, naxanye ɲɛnigen yi fan, ne yi fa xɛma maxidi seen sifan birin na, tunla soone, wuredine, ɲɛrɛne, e yi e fi Alatala ma kise ralixin na. ");
INSERT INTO yal_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Gari mamiloxin nun a gbeela, taa dugi faɲina, sii xabe dugine, konton kidi magbelixine e nun sube kidine yi naxanye yii, e yi fa ne ra. ");
INSERT INTO yal_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Naxanye yi fama gbetin nun sulan na, ne yi na findi kiseen na Alatala xa. Kasiya wudin yi naxanye yii, ne yi fa ne ra walideni. ");
INSERT INTO yal_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ɲaxalan walikɛne birin yi garini tɔn e fa a ra, a mamiloxin nun a gbeela, hanma taa dugina, e naxanye wurundun. ");
INSERT INTO yal_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ɲaxalan walikɛ gbɛtɛye yi sii xabe dugin wurundun naxanye yi wama a liga feni e nun naxanye fatan. ");
INSERT INTO yal_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Yamaan kuntigine yi fa onixi gɛmɛne ra e nun gɛmɛ tofaɲi gbɛtɛye saraxarali domaan nun kanke masaan nayabu seene ra. ");
INSERT INTO yal_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","E yi fa se xiri ɲaxumɛne nun oliwi turen na lɛnpun nun masusan turena fe ra e nun wusulan xiri ɲaxumɛna. ");
INSERT INTO yal_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isirayila kaa ɲɛnige faɲine birin, xɛmɛn nun ɲaxanla, e birin yi fa e kiseen na Alatala xɔn wanle kɛ feen na Alatala naxanye yamarixi e ma fata Musa ra. ");
INSERT INTO yal_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa yi a fala Isirayila kaane xa, a naxa, “Ɛ a mato, Alatala bata Yuri a dii Bɛsalɛli sugandi, Xuru mamandenna, Yuda bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","A bata a ralugo Alaa Nii Sariɲanxin nun xaxilimayaan nun kolonna ra, alogo a xa fatan wali wuyaxi kɛ, ");
INSERT INTO yal_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","alogo a xa nɔ wali gbeene rakamalideni, a xɛmaan nawali, e nun gbetin nun sulana, ");
INSERT INTO yal_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","a gɛmɛ faɲine masoli, a yi e suxu seene yitɔn, a wudin nawali, alogo a xa wali tofaɲine kɛ. ");
INSERT INTO yal_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ala mɔn bata tin a xa fatan xaranna tiyɛ, e nun Axisamaki a dii Oholiyabi, Dan bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ala bata tin e fatan wanla sifan birin na, e gɛmɛne masoli, e wanle yɛba, e dugine sɔxɔn, a mamiloxin nun a gbeela, e nun taa dugi faɲina. E fatan wanla sifan birin yɛbadeni.” ");
INSERT INTO yal_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bɛsalɛli nun Oholiyabi, e nun walikɛne birin, Alatala xaxilimayaan nun kolonna fi naxanye ma alogo e xa nɔ yire sariɲanxin wanle birin kɛdeni, e xa wanla fɔlɔ alo Alatala a yamarixi kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musa yi Bɛsalɛli nun Oholiyabi xili, e nun walikɛne birin Alatala xaxilimayaan fi naxanye ma, e nun naxanye yi waxi wanle kɛ feni. ");
INSERT INTO yal_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Isirayila kaane fa kiseen naxanye ra yire sariɲanxin ti feen na, Musa yi ne birin taxu walikɛne ra. Muxune mɔn yi fama kiseene ra Musa fɛma xɔtɔn yo xɔtɔn. ");
INSERT INTO yal_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Nayi, muxun naxanye birin yi yire sariɲanxin wanla kɛma, ne birin yi e wanle beɲin e siga, ");
INSERT INTO yal_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","e fa a fala Musa xa, e naxa, “Yamaan fama se wuyaxi ra. E bata a radangu ayi. Alatala naxan yamarixi wanla kɛ feen na, a bata gbo na xa.” ");
INSERT INTO yal_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Musa yi yamarin fi mafurɛn, a xa fala yamaan daaxaden birin yi, a naxa, “Xɛmɛn nun ɲaxanla, muxu yo nama fa kiseene ra yire sariɲanxin wali feen na.” Nayi, e yi ba fɛ kiseene ra. ");
INSERT INTO yal_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Amasɔtɔ kiseen naxanye bata yi sɔtɔ ne yi wanla raɲanɲɛ nɛn. ");
INSERT INTO yal_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Walikɛ xaxilimane yi Ala Batu Bubun nafala taa dugi kuye faɲi fu ra, a mamiloxin nun a gbeela. E yi a rayabu maleka gubugubu kan sawura sɔxɔnxine ra. ");
INSERT INTO yal_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Dugine birin yi lan: a kuyan nɔngɔnna yɛ mɔxɔɲɛn nun solomasɛxɛ, a yigbona nɔngɔnna yɛ naanin. ");
INSERT INTO yal_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","E yi dugi suulun dɛgɛ e bode ra, dugi suulunna bonne fan yi dɛgɛ e bode ra. ");
INSERT INTO yal_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","E yi luti mamiloxine ti dugi ratugunxine singe ra xiin dɛ kinkin na. E mɔn yi na liga a ratugunxin bonne dɔnxɛ ra xiin na. ");
INSERT INTO yal_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","E yi luti tonge suulun ti taa dugi ratugunxine singe ra xiin na, e mɔn yi luti tonge suulun ti taa dugi ratugunxine firinden dɔnxɛ ra xiin na, lutine yi lanxi e bode ma. ");
INSERT INTO yal_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","E yi a suxu seen xɛma daxin tonge suulun nafala, e yi dugi ratugunxi firinne xidi e bode ra suxu seene ra. Ala Batu Bubun yi findi se kedenna ra. ");
INSERT INTO yal_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","E yi dugi fu nun keden nafala sii xabene ra, e findi Ala Batu Bubun xunna soon na. ");
INSERT INTO yal_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Dugi fu nun kedenne birin yi lan. Keden kuya yi nɔngɔnna yɛ tonge saxan. Keden yi gbo nɔngɔnna yɛ naanin. ");
INSERT INTO yal_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","E yi dugi suulun dɛgɛ e bode ra e danna, e dugi senninna bonne fan dɛgɛ e bode ra. ");
INSERT INTO yal_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","E yi luti tonge suulun ti dugi ratugunxine singe ra xiin dɛ kinkine ra, e mɔn yi luti tonge suulun ti dugi ratugunxin bonne fan dɔnxɛ ra xiin dɛ kinkine ra. ");
INSERT INTO yal_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","E yi suxu se sula daxin tonge suulun nafala alogo e xa bubun xidi, a findi kedenna ra. ");
INSERT INTO yal_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","E yi konton kidi magbelixine dɛgɛ e bode ra, e yi e sa bubun birin fari. E mɔn yi sube kidi faɲi gbɛtɛye fan sa na fari. ");
INSERT INTO yal_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","E yi bubun xunna soon bun tiine rafala kasiya wudin na. ");
INSERT INTO yal_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Bun tiine yi kuya nɔngɔnna yɛ fu, e yigbona nɔngɔnna yɛ keden e nun a tagi. ");
INSERT INTO yal_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Bun tiin yi findi farin firinna ra e bode yɛtagi. E yi bubun bun tiine birin ti na kiini. ");
INSERT INTO yal_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","E yi bun ti mɔxɔɲɛ rafala bubun yiifari fɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","E yi bundɔxɔ gbeti daxin tonge naanin nafala bun tiine xa. Bun ti yo bun ti, bundɔxɔ firin. Farin firinne yi sɔti bundɔxɔne kui. ");
INSERT INTO yal_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","E yi bun ti mɔxɔɲɛ ti Ala Batu Bubun kɔmɛn fɔxɔni, ");
INSERT INTO yal_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","e nun bundɔxɔ gbeti daxin tonge naanin, bun ti yo bun ti, bundɔxɔ firin. ");
INSERT INTO yal_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","E yi bun ti sennin ti bubun xanbin na sogegododen binni. ");
INSERT INTO yal_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","E mɔn yi bun ti firin sa a fari bubun xanbi ra tongonne ma. ");
INSERT INTO yal_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Bun ti firin yi ti e bode xɔn mɛnni. E yi xidi e bode ra keli laben na han e xun tagi. Tongon firinne birin yi ti na kiini. ");
INSERT INTO yal_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Nayi, bun ti solomasɛxɛ yi ti na e nun bundɔxɔ fu nun sennin. Bun dɔxɔ firin yi lu bun tiine birin bun. ");
INSERT INTO yal_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","E yi kasiya wudi gaalane rafala: suulun yi lu bubun fɔxɔ kedenna bun tiine suxu seen na, ");
INSERT INTO yal_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","suulun yi lu bode fɔxɔn ma, suulun yi lu bubun xanbi binna ma sogegododen binni. ");
INSERT INTO yal_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Gaalan tagi xiin bun tiine ma, na yi rafala gaalan kedenna ra alogo a xa keli bubun fɔxɔ kedenni siga han bubun bode fɔxɔna. ");
INSERT INTO yal_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","E yi xɛma yilɛnlɛnxine sa bun tiine ma. E yi gaalane so yinle rafala xɛmaan na. E yi xɛma yilɛnlɛnxine sa gaalane ma. ");
INSERT INTO yal_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","E yi kankiraan yɛ masansan taa dugin nafala gari mamiloxin nun a gbeela ra, e yi a rayabu maleka sawura sɔxɔnxine ra. ");
INSERT INTO yal_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","E yi a singan kasiya sɛnbɛtɛn naanin na xɛma yilɛnlɛnxine yi saxi naxanye ma. E yi xɛma singan seene ti e ma. E yi sɛnbɛtɛnne ti bundɔxɔ gbeti daxi naanin kui. ");
INSERT INTO yal_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Dugi sɔxɔnne yi dɛ raxidi taa dugin nafala bubun so dɛɛn na gari mamiloxin nun a gbeela ra. ");
INSERT INTO yal_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","E yi sɛnbɛtɛn suulun gbɛtɛye rafala dugin xa e nun a singan seene. E yi xɛma yilɛnlɛnxine sa sɛnbɛtɛnne xuntagine ma, e bundɔxɔ sula daxi suulun nafala e xa. ");
INSERT INTO yal_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bɛsalɛli yi kasiya wudi kankiraan nafala: A kuyana nɔngɔnna yɛ firin e nun a tagi, a yigbona nɔngɔnna yɛ keden e nun a tagi, a yitena nɔngɔnna yɛ keden e nun a tagi. ");
INSERT INTO yal_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A yi xɛma faɲi yilɛnlɛnxine sa a fanna nun a kuiin ma, a yi a dɛ kinkin fan nabilin xɛmaan na. ");
INSERT INTO yal_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","A yi a tongo tamine so yili naaninne rafala xɛmaan na a san naaninne ma, firin fɔxɔ kedenni, firin bode fɔxɔni. ");
INSERT INTO yal_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","A yi kasiya tami firin nafala, a yi xɛma yilɛnlɛnxine sa e ma. ");
INSERT INTO yal_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","A yi tamine raso xɛma yinle ra kankiraan dɛxɔnne yi, alogo e xa findi kankiraan xali seen na. ");
INSERT INTO yal_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A yi xɛma dɛraganla rafala kankiraan ma, Ala solonadena. A yi kuya nɔngɔnna yɛ firin e nun a tagi, a yi gbo nɔngɔnna yɛ keden e nun a tagi. ");
INSERT INTO yal_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","A yi maleka gubugubu kan sawura firin nafala xɛma bɔnbɔxin na, e ti kankiraan dɛraganla fɔxɔ firinne ma. ");
INSERT INTO yal_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","A maleka sawura keden ti fɔxɔ kedenni, a yi a firinden ti bode fɔxɔni. Maleka sawurane nun kankiraan dɛraganla yi findi se kedenna ra. ");
INSERT INTO yal_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Maleka sawurane gubugubune yi bandunxi e xun ma, e yi felenxi kankiraan dɛraganla ma. Maleka sawurane yɛɛ rafindixi e bode ma, e xun sinxi kankiraan dɛraganla ma. ");
INSERT INTO yal_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","E yi kasiya wudin tabanla rafala: a kuyana nɔngɔnna yɛ firin, a yigbona nɔngɔnna yɛ keden, a yitena nɔngɔnna yɛ keden e nun a tagi. ");
INSERT INTO yal_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","E yi xɛma faɲi yilɛnlɛnxine sa a ma, e a dɛ kinkin nabilin xɛmaan na. ");
INSERT INTO yal_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","E yi farinna sa tabanla ɲinginna ma a rabilinni. Farinni gboon yi lanxi muxun yii kuiin nan ma. E yi xɛmaan sa farinna dɛ kinkine ma. ");
INSERT INTO yal_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","E yi a tongo tamine so yili naaninne rafala xɛmaan na tabanla tongon naaninne ma a sanne ma. ");
INSERT INTO yal_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Tamine so yinle yi lu a dɛ kinkine ra, tamine soon naxanye ra tabanla xali seen na. ");
INSERT INTO yal_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","E yi kasiya tamine rafala, e yi xɛma yilɛnlɛnxine sa e ma, e findi tabanla xali seen na. ");
INSERT INTO yal_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","E yi a goronne nun waliseene rafala xɛma faɲin na, e nun a igelengenne minse saraxane rabɔxɔnma naxanye ra. ");
INSERT INTO yal_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","E yi lɛnpun dɔxɔ seen nafala xɛma bɔnbɔxi faɲin na. A sanna nun a yiine yi rayabu se fuge sawurane ra. Se kedenna nan yi e birin na. ");
INSERT INTO yal_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Yii sennin nan yi tixi a fɔxɔ firinne ma: lɛnpu dɔxɔde yire saxan yi lu a fɔxɔ kedenni, yire saxan a fɔxɔ bodeni. ");
INSERT INTO yal_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Amandi wudi fuge sawura saxan saxan yi rafala a yii senninna birin ma a rayabu seen na. ");
INSERT INTO yal_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Amandi wudi fuge sawura naanin yi rafala a binla fan ma. ");
INSERT INTO yal_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Keden yi rafala a tangbaxi singen bun ma, keden a firinden fan bun ma, e nun keden a saxanden bun. E birin malanxina yii sennin. ");
INSERT INTO yal_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Se kedenna nan yi a se fuge sawurane nun a yiine ra, e birin yi rafalaxi xɛma faɲi bɔnbɔxin nan na. ");
INSERT INTO yal_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","E yi lɛnpu solofere rafala xɛma faɲin na, e nun e waliseene nun xube kɔ seene. ");
INSERT INTO yal_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","E lɛnpun dɔxɔ seen nun a waliseene rafala xɛma faɲin kilo tonge saxan nan na. ");
INSERT INTO yal_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","E yi wusulan ganden nafala kasiya wudin na. A kuyana nɔngɔnna yɛ keden, a yigbona nɔngɔnna yɛ keden, a yitena nɔngɔnna yɛ firin. E yi fenne rafala a tongon naaninne ma. E yi findi se kedenna ra. ");
INSERT INTO yal_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","E yi xɛma faɲi yilɛnlɛnxine sa a fanna nun a dɛxɔnne nun a fenne ma. E yi xɛmaan sa a rabilinni a ɲinginne ma. ");
INSERT INTO yal_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","E yi tami raso yinla xɛma daxin firin firin nafala wusulan ganden ɲinginne bun ma alogo a tongo tamine xa raso a fɔxɔ firinne ra. ");
INSERT INTO yal_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","E yi kasiya wudin nafala tamine ra, e yi xɛma yilɛnlɛnxine sa e ma. ");
INSERT INTO yal_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Wusulan nafalane yi masusan ture sariɲanxin nun wusulan xiri ɲaxumɛn nafala. ");
INSERT INTO yal_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","E yi saraxa ganden nafala kasiya wudin na, a kuyana nɔngɔnna yɛ suulun, a yigbona nɔngɔnna yɛ suulun, a yitena nɔngɔnna yɛ saxan. ");
INSERT INTO yal_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","E yi fenne rafala a tongon naaninne ma. Saraxa ganden nun a fenne yi findi se kedenna ra, e sula yilɛnlɛnxine sa e ma. ");
INSERT INTO yal_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","E yi a waliseene rafala sulan na: xube sa seene nun xube kɔ seene nun wuli xuya goronne nun sube tongo seene, e nun tɛɛ kɔ seene. ");
INSERT INTO yal_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","E yi wure masɔxɔnxin nafala xuben minin naxan na. A yi lu saraxa ganden dɛ kinkine bun ma saraxa gandeni teen tagini. ");
INSERT INTO yal_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","E yi tamin so yili naanin nafala sulan na a wure masɔxɔnxin tongon naaninne ma. ");
INSERT INTO yal_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","E yi kasiya tamine rafala saraxa ganden xa, e sula yilɛnlɛnxine sa e ma. ");
INSERT INTO yal_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","E yi tamine raso sula yinle ra alogo tamine xa lu saraxa ganden fɔxɔ firinne ma a xali seen na. E yi a rafala farinne ra, a kui genla yi lu. ");
INSERT INTO yal_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Walikɛ ɲaxanla naxanye yi Naralan Bubun so dɛɛn na, ne yi e mato kikene so e yii, e yi ige ramara seen nun a bundɔxɔn nafala ne sulan na. ");
INSERT INTO yal_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","E yi Ala Batu Bubun nabilin sansanna ra. Sansanna yiifari fɔxɔn yi kuya ayi han nɔngɔnna yɛ kɛmɛ, a ti taa dugi faɲine ra. ");
INSERT INTO yal_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Sula sɛnbɛtɛn mɔxɔɲɛ yi ti sula bundɔxɔ mɔxɔɲɛ kui. Dugi singan se gbeti daxine yi singan gbeti gaalane ra sɛnbɛtɛnne longonne ra. ");
INSERT INTO yal_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Kɔmɛn fɔxɔn sansanna fan yi kuya ayi han nɔngɔnna yɛ kɛmɛ, a fan yi ti sula sɛnbɛtɛn mɔxɔɲɛ ra e nun sula bundɔxɔ mɔxɔɲɛn e nun dugi singan se gbeti daxine nun gbeti gaalane sɛnbɛtɛnne longonne ra. ");
INSERT INTO yal_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Sansanna yi kuya ayi sogegododen binni han nɔngɔnna yɛ tonge suulun. A yi ti dugine ra e nun sɛnbɛtɛn fu nun bundɔxɔ fu nun dugi singan se gbeti daxine nun gbeti gaalane. ");
INSERT INTO yal_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Sansanna yi kuya ayi a sogeteden binni soden dɛnaxan yi, han nɔngɔnna yɛ tonge suulun. ");
INSERT INTO yal_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Dugine yi singan soden fɔxɔ kedenni, e nun sɛnbɛtɛn saxan nun e bundɔxɔ saxan han nɔngɔnna yɛ fu nun suulun. ");
INSERT INTO yal_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Dugine yi singan soden bode fɔxɔni, e nun sɛnbɛtɛn saxan e nun bundɔxɔ saxan han nɔngɔnna yɛ fu nun suulun. ");
INSERT INTO yal_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Bubun sansanna dugine birin yi rafalaxi taa dugi faɲin nan na. ");
INSERT INTO yal_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Sɛnbɛtɛnne bundɔxɔne birin yi rafalaxi sulan nan na. E dugi singan seene nun gaalane yi rafalaxi gbetin nan na. Gbeti yilɛnlɛnxine yi saxi sɛnbɛtɛnne fan xuntagine ma. Sansanna sɛnbɛtɛnne birin yi tugunxi e bode ra gbeti gaalane nan na. ");
INSERT INTO yal_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Dugi sɔxɔnne yi so dɛɛn dɛ raxidi dugin nafala gari mamiloxin nun a gbeela ra, e nun taa dugi faɲina. A yi kuya han nɔngɔnna yɛ mɔxɔɲɛ. A yi mate han nɔngɔnna yɛ suulun alo sansanna dugin bonne. ");
INSERT INTO yal_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Sɛnbɛtɛn naanin nun bundɔxɔ naanin fan yi ti mɛnni. E dugi singan seene nun gaalane yi rafalaxi gbetin nan na. Gbeti yilɛnlɛnxine yi saxi e xuntagine ma. ");
INSERT INTO yal_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Tami dungin naxanye yi gbangbanma bɔxɔni bubun bun tiine nun sansanna sɛnbɛtɛnne xidi seene ra, ne birin yi rafalaxi sulan nan na. ");
INSERT INTO yal_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Waliseene yatɛne nan itoe ra naxanye rawali Ala Bubun tideni, Layirin Sereyaan bubun naxan kui. Musa nan Lewi bɔnsɔnna muxune yamari, e yi e sɛbɛ saraxarali Harunaa dii Itamara xun matoon bun ma. ");
INSERT INTO yal_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Yuri a dii Bɛsalɛli, Xuru mamandenna Yuda bɔnsɔnni, na yi seen birin nafala Alatala Musa yamari naxanye ma. ");
INSERT INTO yal_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","E nun Oholiyabi nan yi a ra, Axisamaki a diina, Dan bɔnsɔnni. Walikɛɛn nan yi a ra naxan fatan wanle yɛbadeni. Dugi sɔxɔnna nan mɔn yi a ra naxan yi gari mamiloxin nun a gbeela rawalima e nun taa dugi faɲina. ");
INSERT INTO yal_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Xɛma kise ralixin naxanye birin yi rawalima yire sariɲanxin tideni, ne yi lanxi kilo kɛmɛ solomasɛxɛ kilo tonge solofere kilo solofere garamu kɛmɛ saxan nan ma. A maliga yire sariɲanxin ligaseen nan na. ");
INSERT INTO yal_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Yamaan fa gbetin naxan na, na to tɛngɛ, na lan kilo wuli saxan kilo fu nun solofere garamu kɛmɛ solofere nun tonge suulun nan ma. A maliga yire sariɲanxin ligaseen nan na. ");
INSERT INTO yal_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Xɛmɛn naxanye barin bata yi ɲɛɛ mɔxɔɲɛ ti, ne to tɛngɛ, e birin gbeti gbanan keden keden nan fi gbeti gbanan naxan lan garamu suulun ma. A maliga yire sariɲanxin ligaseen nan na. Xɛmɛ wuli kɛmɛ sennin wuli saxan kɛmɛ suulun tonge suulun nan tɛngɛ. ");
INSERT INTO yal_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","E gbetin kilo wuli saxan nan naxulun gbeti bundɔxɔ kɛmɛne rafala seen na yire sariɲanxin nun a yɛ masansan dugin xa, kilo tonge saxan saxan. ");
INSERT INTO yal_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Na gbeti kilo fu nun solofere garamu kɛmɛ solofere tonge suulunna naxan lu, e dugi singan seene nun gaalane rafala na ra, e mɔn yi gbetin sa sɛnbɛtɛnne xuntagine ma. ");
INSERT INTO yal_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Sula kise ralixine lan kilo wuli firin kɛmɛ mɔxɔɲɛn nun naanin nan ma. ");
INSERT INTO yal_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","E yi bundɔxɔne rafala na ra Naralan Bubun soden xa e nun sula saraxa ganden nun a wure masɔxɔnxin nun a goronne birin, ");
INSERT INTO yal_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","sansanna bundɔxɔne, a soden fan gbeene, e nun bubun nun sansanna xidi seen gbangban daxine. ");
INSERT INTO yal_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","E gari mamiloxin nun a gbeela naxanye sɔtɔ, e dugine rafala ne nan na wali kɛ seen na yire sariɲanxini. E mɔn yi doma rasariɲanxine rafala Haruna xa alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","E yi saraxarali doma xɛma daxin nafala gari mamiloxin nun a gbeela ra, e nun taa dugi faɲina. ");
INSERT INTO yal_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","E yi xɛmaan bɔnbɔ han a dɛnfɛtɛn. E yi a yibolon luti xunxurine ra alogo a xa basan gari mamiloxin nun a gbeela ra, e nun taa dugi faɲina, a findi wali tofaɲin na. ");
INSERT INTO yal_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","E yi a tungunne dɛgɛ, e lutine ti e xun firinne ra a xidi seen na. ");
INSERT INTO yal_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","A tagixidi faɲin fan yi dɛgɛ na kiini. E nun saraxarali domaan yi findi se kedenna ra. A rafala xɛmaan na, e nun gari mamiloxin nun a gbeela, e nun taa dugi faɲina alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","E yi onixi gɛmɛne ti gɛmɛ suxu seen xɛma daxine ra, e Isirayilaa diine xinle kɛrɛndɛn onixi gɛmɛne ma a faɲin na. ");
INSERT INTO yal_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","E yi na gɛmɛne ti saraxarali domaan tungunne ma ɲɔxɔ lu feen na Isirayilaa diine xɔn alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","E yi kanke masaan dɛgɛ, kitisa sena. A yi findi wali faɲin na. E yi a dɛgɛ alo saraxarali domana, e a rafala xɛmaan nun gari mamiloxin nun a gbeela nun taa dugi faɲin na. ");
INSERT INTO yal_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","A rafalaxi tongon naaninna ra, alogo a xa yisa firinna ra, a kuyan nun a yigbona nɔngɔnna tagi. ");
INSERT INTO yal_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","E yi a rayabu gɛmɛ faɲin kira naanin na. E gɛmɛni itoe nan sa a kira singen ma: saridon gɛmɛn nun topasi gɛmɛn nun emerodi gɛmɛna. ");
INSERT INTO yal_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","A kiraan firindena: esikaribukili gɛmɛn nun safiri gɛmɛn nun dayimu gɛmɛna. ");
INSERT INTO yal_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Kiraan saxandena: opali gɛmɛn nun agati gɛmɛn nun ametisi gɛmɛna. ");
INSERT INTO yal_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Kiraan naanindena: kirisoliti gɛmɛn nun onixi gɛmɛn nun yasipi gɛmɛna. Gɛmɛni itoe xa sa suxu se xɛma daxine kui. ");
INSERT INTO yal_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Na gɛmɛ fu nun firinne luma Isirayilaa diine nan xili yi. Gɛmɛ yo gɛmɛ, Isirayila bɔnsɔn keden xinla yi kɛrɛndɛn a ma taxamasenna ra. ");
INSERT INTO yal_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","E yi xɛma yɔlɔnxɔndine rafala kanke masaan na, naxanye dɛnbɛxi alo lutina. ");
INSERT INTO yal_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","E yi xidi se xɛma daxi firin nun xɛma wuredi digilinxi firin nafala, e yi wuredine so kanke masaan xunne ra. ");
INSERT INTO yal_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","E yi yɔlɔnxɔndine xidi wuredine ra kanke masaan tungunne ma, ");
INSERT INTO yal_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","yɔlɔnxɔndine yi ti xidi se firinne ra alogo e xa tugun saraxarali domaan tungunne ra a kanke ra. ");
INSERT INTO yal_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","E mɔn yi xɛma wuredi digilinxi firin nafala e naxanye singan kanke masaan san bun ma, kanke masaan dɛ kinkin kui. ");
INSERT INTO yal_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","E yi xɛma wuredi firin nafala, e yi e xidi saraxarali domaan tungun firinne laben na, a tagixidin faxa ra. ");
INSERT INTO yal_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","E yi kanke masaan wuredine nun saraxarali domaan wuredine xidi e bode ra luti mamiloxin na, alogo kanke masaan nama saraxarali domaan beɲin alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Dugi sɔxɔnna nde yi saraxarali domaan gubaan dɛgɛ dugi mamiloxin na. ");
INSERT INTO yal_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","A kɔɛɛn yi lu a tagi, e yi dugina nde dɛgɛ a kɔɛɛn nabilinni alogo a nama bɔ. ");
INSERT INTO yal_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","E yi girenada wudi bogi sawurane dɛgɛ a lenbene ma gari mamiloxin nun a gbeela ra, e nun taa dugi faɲina. ");
INSERT INTO yal_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","E yi xɛma talandine rafala, e yi e xidi a lenbene ma girenada wudi bogine longori ra. ");
INSERT INTO yal_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Xɛma talanne yi xidi girenada bogi sawurane longori ra gubaan lenben nabilinni. A yi na nan soma a nɛma yi walɛ waxatin naxan yi alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Dugi sɔxɔnna nde yi doma bunbirane dɛgɛ taa dugi faɲin na Haruna nun a diine xa, ");
INSERT INTO yal_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","e nun taa dugi namu faɲin nun taa dugi xuntagi xidine nun taa dugi wantan faɲine. ");
INSERT INTO yal_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Dugi sɔxɔnna nde yi taa dugi faɲin nafala tagi xidin na e nun gari mamiloxin nun a gbeela alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","E yi xɛma walaxa xurudin nafala taxamaseri rasariɲanxin na, e yi a sɛbɛ a fari alo taxamasenna fa fala, “Muxu Sariɲanxina Alatala Xa.” ");
INSERT INTO yal_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","E yi a xidi luti mamiloxin na namun tigi ra alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Naralan Bubuna Ala batuma dɛnaxan yi, na wanla birin yi kamali. Isirayila kaane yi a birin kɛ alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","E yi fa bubun na Musa fɛma: bubun nun a waliseene birin, a dugi singan seene nun a bun tiine nun a gaalane nun a sɛnbɛtɛnne nun a bundɔxɔne ");
INSERT INTO yal_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","nun a xunna soon naxan nafala konton sube kidi magbelixine ra, e nun na fan xunna soon naxan nafala kidi faɲine ra nun a yɛ masansan dugin ");
INSERT INTO yal_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","nun Layiri Sereya Kankiraan nun a tongo tamine nun a dɛraganla Ala solonama dɛnaxan yi ");
INSERT INTO yal_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","nun tabanla nun a goronne birin nun Buru Ralixin ");
INSERT INTO yal_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","nun xɛma lɛnpu dɔxɔ seen nun a lɛnpune nun a waliseene nun turen naxan sama a kui ");
INSERT INTO yal_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","nun saraxa gande xɛma daxin nun masusan turen nun wusulan xiri ɲaxumɛn nun bubun soden dɛ raxidi dugin ");
INSERT INTO yal_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","nun saraxa gande sula daxin nun a wure masɔxɔnxin nun a tongo tamine nun a goronne nun ige ramaraden nun a bundɔxɔn ");
INSERT INTO yal_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","nun sansan dugine nun a sɛnbɛtɛnne nun bundɔxɔne nun a soden dɛ raxidi dugin nun sansanna lutine nun xidi seen gbangban tamine nun Naralan Bubuna waliseene birin Ala batuma dɛnaxan yi ");
INSERT INTO yal_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","e nun taa dugi domane saraxaraline xa e nɛma walɛ yire sariɲanxini waxatin naxan yi, saraxarali Harunaa doma rasariɲanxine, e nun a diine gbeene e naxanye soma e nɛma walɛ waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Isirayila kaane bata yi wanla birin kɛ alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa yi na wanla mato, a yi a to fa fala e a kɛxi nɛn alo Alatala a yamari kii naxan yi. Nanara, Musa yi duba e xa. ");
INSERT INTO yal_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Alatala yi falan ti Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Kike singen xii singena, i xa Ala Batu Bubun ti, Naralan Bubuna. ");
INSERT INTO yal_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","I xa Layiri Sereya Kankiraan dɔxɔ a kui, ɛ yi a yɛ masansan dugin na. ");
INSERT INTO yal_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","I xa tabanla xali i yi a dɔxɔ. I xa lɛnpu dɔxɔ seen xali, i yi a lɛnpune yitɔn. ");
INSERT INTO yal_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","I xa wusulan saraxa gande xɛma daxin dɔxɔ Layiri Sereya Kankiraan yɛtagi, i yi dugin singan Ala Batu Bubun soden dɛ ra. ");
INSERT INTO yal_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","I xa saraxa gan daxin baden lu Ala Batu Bubun soden yɛtagi, Naralan Bubuna. ");
INSERT INTO yal_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","I xa ige ramaraden dɔxɔ saraxa ganden nun Naralan Bubun tagi, i yi igen sa a kui. ");
INSERT INTO yal_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","I xa bubun nabilin sansanna ra, i yi dugin singan sansanna soden dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","I xa masusan turen tongo, i yi Ala Batu Bubun masusan e nun a yi seen birin. I xa a rasariɲan e nun a waliseene birin, nayi a sariɲanma nɛn. ");
INSERT INTO yal_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","I xa saraxa gan daxin baden masusan e nun a waliseene birin. I xa saraxa ganden nasariɲan, nayi a sariɲanma nɛn fefe! ");
INSERT INTO yal_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","I xa ige ramaraden masusan e nun a bundɔxɔna, i yi a rasariɲan. ");
INSERT INTO yal_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","I xa fa Haruna nun a dii xɛmɛne ra Naralan Bubun dɛɛn na, i yi e maxa. ");
INSERT INTO yal_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","I dugi rasariɲanxine ragodo Haruna ma, i yi a masusan, i yi a rasariɲan, alogo a xa saraxarali wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","I yi fa a dii xɛmɛne ra, i yi e maxidi dugine yi. ");
INSERT INTO yal_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","I yi e masusan alo i e baba masusan kii naxan yi, alogo e xa saraxarali wanla kɛ n xa. Ne masusanma e so feen nan na saraxaraliyani naxan luma e yixɛtɛne birin xa habadan.” ");
INSERT INTO yal_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa yi Alatalaa yamarine birin liga. ");
INSERT INTO yal_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ɲɛɛ firinden kike singena, kiken xii singena, Ala Batu Bubun yi ti. ");
INSERT INTO yal_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa to Ala Batu Bubun ti, a yi a bundɔxɔne dɔxɔ, a yi a buntine ti e kui, a yi gaalane so e yinle ra, a yi a sɛnbɛtɛnne ti. ");
INSERT INTO yal_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","A yi kidine sa bubun fari a xunna soon na. A na fan xunna soon so a xun na alo Alatala Musa yamari kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","A yi Layiri Sereya gɛmɛ walaxane tongo a e sa Layiri Kankiraan kui. A yi a tongo tamine so yinle ra Layiri Kankiraan ma. A yi kankiraan dɛraganla sa a dɛ ra Ala solonama dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","A yi Layiri Sereya Kankiraan xali Ala Batu Bubun kui, a yi a yɛ masansan dugin singan, alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","A yi tabanla ti Naralan Bubun kui, Ala Batu Bubun kɔmɛn fɔxɔni, kankiraan yɛ masansan dugin fari ma. ");
INSERT INTO yal_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","A yi burune sa tabanla fari Alatala yɛtagi, alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","A yi lɛnpu dɔxɔ seen dɔxɔ Naralan Bubun kui tabanla yɛtagi Ala Batu Bubun yiifari fɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","A yi lɛnpune yitɔn Alatala yɛtagi, alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","A yi wusulan gande xɛma daxin dɔxɔ Naralan Bubun kui, dugin yɛtagi. ");
INSERT INTO yal_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","A yi wusulan xiri ɲaxumɛn gan a fari alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","A yi dugin singan Ala Batu Bubun dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","A yi saraxa gan daxin baden dɔxɔ Ala Batu Bubun soden dɛxɔn, Naralan Bubuna. A saraxa gan daxine ba na fari, e nun bogise saraxane, alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","A yi ige sa seen dɔxɔ Naralan Bubun nun saraxa ganden tagi, a yi maxa igen sa a kui. ");
INSERT INTO yal_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa nun Haruna nun a dii xɛmɛne yi e yiine nun e sanne maxama na igen nan na. ");
INSERT INTO yal_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","E nɛma yi soɛ Naralan Bubun kui, hanma e nɛma e masoɛ saraxa ganden na, e yi e maxama nɛn, alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","A yi sansanna ti Ala Batu Bubun nun saraxa ganden nabilinni, a yi dugin singan sansanna dɛɛn na. Musa yi wanla raɲan na kiini. ");
INSERT INTO yal_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Nayi, kundaan yi so Naralan Bubun xun na, Alatalaa nɔrɔn yi Ala Batu Bubun nafe. ");
INSERT INTO yal_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa mi yi nɔɛ soɛ Naralan Bubuni, bayo kundaan yi a fari, e nun Alatalaa nɔrɔn yi Ala Batu Bubun nafexi. ");
INSERT INTO yal_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Na kundaan nɛma yi kelɛ Ala Batu Bubun xun ma waxati yo yi, Isirayila kaane birin yi sigama nɛn a fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Koni xa kundaan mi yi bama na, e fan mi yi sigama han a yi ba lɔxɔn naxan yi. ");
INSERT INTO yal_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Alatalaa kundaan nan yi Ala Batu Bubun xun ma yanyin na, tɛɛn nan yi basanxi a ra kɔɛɛn na. Isirayila yamaan birin yi a to e sigatiin birin yi.");
INSERT INTO yal_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Alatala yi Musa xili Naralan Bubuni, a yi a fala a xa ");
INSERT INTO yal_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","a a xa falani ito rali Isirayila kaane ma, a naxa, “Xa ɛ tan nde fama saraxan na Alatala xa, a xa findi ɲingen na hanma yɛxɛɛna hanma siina.” ");
INSERT INTO yal_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Xa a ɲingen nan bama saraxa gan daxin na, a xa turaan nan ba fɛ mi naxan na. Na kanna xa fa a ra Naralan Bubun so dɛɛn na alogo Alatala xa a rasuxu. ");
INSERT INTO yal_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","A xa a yiin sa saraxa ɲingen xunna ma. Ala a rasuxuma nɛn, a findi a solona seen na na kanna xa. ");
INSERT INTO yal_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","A xa tura bulanna kɔɛ raxaba Alatala yɛtagi. Saraxaraline xa fa a wunla ra, Harunaa diine. Ne yi a so saraxa ganden dɛxɔnne ma Naralan Bubun so dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Na kanna xa ɲingen budo, a yi a yisɛgɛ dungi dungin na. ");
INSERT INTO yal_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Saraxarali Harunaa diine xa tɛɛn sa saraxa ganden fari, e yegen sa tɛɛn na. ");
INSERT INTO yal_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Saraxaraline, Harunaa diine, ne xa a dungine nun a xunna nun a turene sa yegene fari tɛɛni saraxa ganden fari. ");
INSERT INTO yal_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Na kanna xa ɲingen kui seene nun a sanne yixa, saraxaraliin yi e birin sa tɛɛni saraxa ganden fari. Saraxa gan daxin na a ra naxan nalima tɛɛn na. A xirin nafan Alatala ma.” ");
INSERT INTO yal_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Xa na kanna saraxan findixi yɛxɛɛn nan na hanma siina, a xa kontonna ba fɛ mi naxan na hanma kɔtɔna. ");
INSERT INTO yal_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","A xa a kɔɛ raxaba saraxa ganden kɔmɛn fɔxɔni Alatala yɛtagi. Saraxaraline, Harunaa diine, ne xa a wunla so saraxa ganden dɛxɔnne ma. ");
INSERT INTO yal_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Na kanna xa a yisɛgɛ a dungi dungin na. Saraxaraliin xa a dungine nun a xunna nun a turene sa yegene fari tɛɛni, saraxa ganden fari. ");
INSERT INTO yal_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Na kanna xa a kui seene nun a sanne maxa, saraxaraliin yi a birin xali, a e sa tɛɛni saraxa ganden fari. Saraxa gan daxin na a ra naxan nalima tɛɛn na. A xirin nafan Alatala ma.” ");
INSERT INTO yal_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Xa na kanna saraxan findixi xɔliin nan na naxan bama saraxa gan daxin na Alatala xa, a xa ganban nan ba hanma kolokonde diina. ");
INSERT INTO yal_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Saraxaraliin xa xɔliin xali saraxa ganden fari, a xa a xunna bolonɲɛ a ra, a yi a sa tɛɛni saraxa ganden fari. A yi a wunla rabɔxɔn saraxa ganden dɛxɔnna ma. ");
INSERT INTO yal_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","A xa a xɔsɔn ba e nun a yi seene, a yi e woli saraxa ganden dɛxɔn, sogeteden binni, xube bɔxɔndeni. ");
INSERT INTO yal_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","A xa a yibɔ a gabutɛne tagi, hali a mi e ba e bode ra. Saraxaraliin yi a sa yegene fari tɛɛni saraxa ganden fari. Saraxa gan daxin na a ra naxan nalima tɛɛn na. A xirin nafan Alatala ma.” ");
INSERT INTO yal_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Xa muxuna nde waxi bogise saraxan fi feni Alatala ma, a xa fa murutu fuɲin nan na. A yi turen sa a yi, a wusulanna sa a fari. ");
INSERT INTO yal_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","A xa a xali saraxaraline fɛma, Harunaa diine. A yi a yiin yɛ keden tongo murutu fuɲini, turen saxi naxan yi e nun wusulanna birin. Saraxaraliin xa na sa tɛɛni saraxa ganden fari ɲɔxɔ lu seen na Ala xɔn. Bogise saraxan nan na ra naxan nalima tɛɛn na. A xirin nafan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Haruna nun a diine nan gbee bogise saraxan dɔnxɛn na. A sariɲan han! Amasɔtɔ a baxi saraxane nan na naxanye ralixi tɛɛn na Alatala ma.” ");
INSERT INTO yal_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Xa bogise saraxan na a ra naxan ganxi buru gandeni, a xa findi murutu fuɲi faɲin nan na, a rafala buru xunne ra naxanye bɔnbɔxi turen na hanma buru yilɛnlɛnxine turen saxi naxanye ma. Buru rate seen nama sa ne yi.” ");
INSERT INTO yal_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“Xa bogise saraxan na a ra naxan ganxi tunde dutunna ma, a lan a xa findi murutu fuɲi faɲin nan na naxan bɔnbɔxi turen na. Buru rate seen nama sa a yi. ");
INSERT INTO yal_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","I xa a yibolon, i turen sa a yi. Bogise saraxan na a ra.” ");
INSERT INTO yal_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“Xa i ya bogise saraxan gilinxin na a ra, a xa findi murutu fuɲi faɲin nan na naxan bɔnbɔxi turen na.” ");
INSERT INTO yal_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“Bogise saraxan naxan nafalaxi na seene ra, i xa fa na ra Alatala fɛma, i yi a so saraxaraliin yii, a yi a xali saraxa ganden dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","A nde bama bogise saraxan na nɛn ɲɔxɔ lu seen na Ala xɔn, a na sa tɛɛni saraxa ganden fari. Saraxan na a ra naxan nalima tɛɛn na. A xirin nafan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Haruna nun a diine nan gbee bogise saraxan dɔnxɛn na. A sariɲan han! Amasɔtɔ a baxi saraxane nan na naxanye ralixi tɛɛn na Alatala ma.” ");
INSERT INTO yal_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Ɛ bogise saraxan naxanye fima Alatala ma, ne sese nama rafala buru rate seen na. Ɛ nama sese gan buru rate seen na hanma kumin naxan yi xa bogise saraxan na a ra naxan nalima tɛɛn na Alatala ma. ");
INSERT INTO yal_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ɛ nɔɛ ne fiyɛ nɛn Alatala ma alo bɔxɔn bogise singene saraxana, koni ɛ nama ne gan saraxa ganden fari alo bogise saraxan naxan xiri rafan Ala ma. ");
INSERT INTO yal_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","I xa fɔxɔn sa i ya bogise saraxane birin yi. I nama ɲinan a sa feen na, amasɔtɔ fɔxɔn findixi Alaa Layirin taxamasenna nan na. A xa sa bogise saraxane birin yi.” ");
INSERT INTO yal_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Xa i fa i ya bɔxɔn bogise singene ra Alatala xa bogise saraxan na, i xa se xɔri kɛndɛne nan fi a ma naxanye dinxi, e ganxi. ");
INSERT INTO yal_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","I xa turen nun wusulanna sa a fari. Bogise saraxan na a ra. ");
INSERT INTO yal_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Saraxaraliin xa nde ba se xɔri dinxine nun turen na, a a sa tɛɛni ɲɔxɔ lu seen na Ala xɔn e nun wusulanna birin. Saraxan na a ra naxan nalima Alatala ma tɛɛn na.” ");
INSERT INTO yal_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Xa muxuna nde a ɲingen bama bɔɲɛ xunbeli saraxan na, a xɛmɛna hanma a gilɛna, a xa fa ɲingen na Alatala yɛtagi fɛ mi naxan na. ");
INSERT INTO yal_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","A xa a yiin sa ɲingen xunna ma, a yi a kɔɛ raxaba Naralan Bubun so dɛɛn na. Saraxaraline, Harunaa diine xa a wunla so saraxa ganden dɛxɔnne birin ma. ");
INSERT INTO yal_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","A xa a subeni itoe ba a ra, a ne rali Alatala ma tɛɛn na: turen naxanye buru subene ma, e nun naxanye singanxi e ra, ");
INSERT INTO yal_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","a gbingi ra xɛlɛ firinne, e nun turen naxanye e ma a gbingini, farafaran naxan bɔɲɛn ma naxan nun gbingi ra xɛlɛne bama. ");
INSERT INTO yal_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Harunaa diine xa ne sa tɛɛni saraxa ganden fari, e nun saraxa gan daxin naxanye yegene fari tɛɛni. Saraxan nan na ra naxan nalima tɛɛn na. A xirin nafan Alatala ma.” ");
INSERT INTO yal_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Xa a xuruse xunxurin nan bama bɔɲɛ xunbeli saraxan na Alatala xa, a xa a xɛmɛn hanma a gilɛɛn ba fɛ mi naxan na. ");
INSERT INTO yal_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Xa a yɛxɛɛn ba, a xa a xali Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","A xa a yiin sa xuruseen xunna ma a yi a kɔɛ raxaba Naralan Bubun so dɛɛn na. Harunaa diine xa a wunla so saraxa ganden dɛxɔnne birin ma. ");
INSERT INTO yal_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","A xa a subeni itoe tongo bɔɲɛ xunbeli saraxan na, a ne rali Alatala ma tɛɛn na: a turena, a xunla nun a turene birin, naxan baxi a gbingi xɔnna ma, a turen naxanye birin a buru subene ma e nun naxanye singanxi e ra, ");
INSERT INTO yal_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","a gbingi ra xɛlɛ firinne, e nun turen naxanye e ma a gbingini, farafaran naxan bɔɲɛn ma naxan bama e nun gbingi ra xɛlɛne. ");
INSERT INTO yal_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Saraxaraliin ne sama nɛn tɛɛni saraxa ganden fari. Donseen nan na ra naxan nalixi Alatala ma tɛɛn na.” ");
INSERT INTO yal_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Xa a siin nan bama, a xa a xali Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","A xa a yiin sa xuruseen xunna ma a yi a kɔɛ raxaba Naralan Bubun yɛtagi. Harunaa diine xa a wunla so saraxa ganden dɛxɔnne ma. ");
INSERT INTO yal_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","A xa a subeni itoe tongo, a ne rali Alatala ma tɛɛn na: a turen birin naxanye a buru subene ma e nun naxanye singanxi e ra, ");
INSERT INTO yal_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","a gbingi ra xɛlɛ firinne, e nun turen naxanye e ma a gbingini, farafaran naxan bɔɲɛn ma naxan bama e nun gbingi ra xɛlɛne. ");
INSERT INTO yal_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Saraxaraliin xa ne birin sa tɛɛni saraxa ganden fari. Donseen na a ra naxan nalima tɛɛn na. A xirin nafan Alatala ma. Alatala nan gbee a turen birin na.” ");
INSERT INTO yal_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Habadan sariyan na a ra waxati famatɔne birin yi, ɛ na dɔxɔ dɛdɛ yi: Ɛ nama suben turen don, ɛ nama suben wunla don.” ");
INSERT INTO yal_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","a xa a fala Isirayila kaane xa, a naxa, “Naxan na tantan a yulubin liga, a Alatalaa yamarina nde kala, a xa ito liga: ");
INSERT INTO yal_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Xa saraxaraliin nan yulubin ligaxi naxan masusanxi turen na a findi saraxarali kuntigin na, a yamaan findi yulubi tongon na, a xa fa tura bulanna ra fɛ mi naxan na, a na ba a yulubi xafari saraxan na Alatala xa. ");
INSERT INTO yal_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","A xa turaan xali Naralan Bubun dɛɛn na Alatala yɛtagi. A xa a yiin sa turaan xunna fari, a yi turaan kɔɛ raxaba Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","A yi a wunla nde tongo, a a xali Naralan Bubun kui. ");
INSERT INTO yal_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","A xa a yii sonla sin wunli, a a xuya Alatala yɛtagi dɔxɔɲa ma solofere yire sariɲanxin yɛ masansan dugin yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Saraxaraliin xa wunla nde sa wusulan ganden tongonna fenne ma, naxan Alatala yɛtagi Naralan Bubun kui alogo na wunla xa rali Ala ma. A xa turaan wuli dɔnxɛn nabɔxɔn saraxa gan daxin baden san bunna dɛxɔn ma Naralan Bubun dɛɛn fɛma. ");
INSERT INTO yal_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","A xa turani ito turen birin ba, turen naxanye a buru subene ma hanma naxanye singanxi e ra, ");
INSERT INTO yal_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","a gbingi ra xɛlɛ firinne nun turen naxanye e ma a gbingini, farafaran naxan bɔɲɛn ma naxan bama e nun gbingi ra xɛlɛne. ");
INSERT INTO yal_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","A turen bama nɛn alo turen naxanye bama bɔɲɛ xunbeli saraxana turani. Saraxaraliin xa e sa tɛɛni saraxa ganden fari. ");
INSERT INTO yal_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Koni turaan kidin nun a suben nun a xunna nun a sanne nun a kui seene nun a gbiine, ");
INSERT INTO yal_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","e nun a gbindin dɔnxɛn birin, a xa ne xali yamaan daaxaden fari ma xube bɔxɔndeni dɛnaxan sariɲan. A yi e sa yegene fari tɛɛni, a e gan xube malanxin fari.” ");
INSERT INTO yal_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Xa Isirayila yamaan birin nan Alatalaa yamarina nde kala tantanni, e mi a kolon, e bata findi yulubi tongone ra na yi. ");
INSERT INTO yal_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","E na a kolon a e bata yulubin liga, yamaan xa fa tura bulanna ra, e na ba yulubi xafari saraxan na. E na xalima nɛn Naralan Bubun yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Yamaan fonne xa e yiine sa turaan xunna ma Alatala yɛtagi, e turaan kɔɛ raxaba. ");
INSERT INTO yal_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Saraxarali gbeen xa a wunla nde xali Naralan Bubun kui. ");
INSERT INTO yal_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","A xa a yii sonla sin wunli a a xuya Alatala yɛtagi dɔxɔɲa ma solofere yire sariɲanxin yɛ masansan dugin yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Saraxaraliin xa a wunla nde sa saraxa ganden tongonna fenne ma, naxan Alatala yɛtagi Naralan Bubun kui. A xa a wuli dɔnxɛn nabɔxɔn saraxa gan daxi baden dɛxɔn ma Naralan Bubun dɛɛn fɛma. ");
INSERT INTO yal_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","A xa a turene birin ba, a a sa tɛɛni saraxa ganden fari. ");
INSERT INTO yal_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","A xa na turaan liga alo turaan naxan ba a yɛtɛɛn yulubi xafari saraxan na. Saraxaraliin xa Ala solona e xa na kiini, Ala yi e mafelu. ");
INSERT INTO yal_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","A xa turaan xali yamaan daaxaden fari ma, a yi a sa tɛɛni alo a tura singen liga kii naxan yi. Yamaan yulubi xafari saraxan na ra.” ");
INSERT INTO yal_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Mangan na yulubin liga tantanni, a Alatalaa yamarin kala, a Ala. A bata findi yulubi tongon na. ");
INSERT INTO yal_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","A na a kolon a a bata yulubin liga, a xa fa kɔtɔn na saraxan na, fɛ mi naxan na. ");
INSERT INTO yal_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","A xa a yiin sa kɔtɔn xunna ma, a yi a kɔɛ raxaba, saraxa gan daxine kɔɛ raxaban dɛnaxan yi Alatala yɛtagi. Yulubi xafari saraxan na a ra. ");
INSERT INTO yal_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Saraxaraliin xa a yii sonla sin na wunli, a yi nde sa saraxa gan daxi baden tongonna fenne ma, a yi wuli dɔnxɛn nabɔxɔn saraxa ganden dɛxɔn ma. ");
INSERT INTO yal_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","A xa a turen birin sa tɛɛni saraxa ganden fari, alo bɔɲɛ xunbeli saraxan turen liga kiinde. Saraxaraliin xa Ala solona mangan yulubina fe ra na kiini, Ala yi a mafelu.” ");
INSERT INTO yal_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Xa muxuna nde tantan yamaan yɛ, a yulubin liga, a Alatalaa yamarina nde kala, a bata findi yulubi tongon na. ");
INSERT INTO yal_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","A na a kolon a a bata yulubin liga, a xa fa sii gilɛn na saraxan na fɛ mi naxan na a yulubina fe ra. ");
INSERT INTO yal_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","A xa a yiin sa siin xunna fari naxan bama yulubi xafari saraxan na. A xa a kɔɛ raxaba saraxa gan daxine bama dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Saraxaraliin xa na wunla nde tongo a yii sonla ra, a yi a sa saraxa gan daxi baden tongonna fenne ma, a yi wuli dɔnxɛn nabɔxɔn saraxa ganden dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","A xa a turene birin ba, alo bɔɲɛ xunbeli saraxan turen ba kii naxan yi. A yi a sa tɛɛni saraxa ganden fari, a xirin yi rafan Alatala ma. Saraxaraliin xa Ala solona na kiini, Ala yi na kanna mafelu.” ");
INSERT INTO yal_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Xa a fa yɛxɛɛ diin nan na a yulubi xafari saraxan na, a lan a xa a gilɛɛn nan ba, fɛ mi naxan na. ");
INSERT INTO yal_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","A xa a yiin sa a xunna fari. A xa a kɔɛ raxaba yulubi xafari saraxan na saraxa gan daxine kɔɛ raxaban dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Saraxaraliin xa a wunla nde tongo a yii sonla ra, a yi a sa saraxa gan daxin baden tongonna fenne ma, a yi wuli dɔnxɛn nabɔxɔn saraxa ganden dɛxɔn ma. ");
INSERT INTO yal_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","A xa a turene birin ba, alo yɛxɛɛn naxan ba bɔɲɛ xunbeli saraxan na. Saraxaraliin yi a sa saraxan bonne fari naxanye ralima Alatala ma tɛɛni saraxa ganden fari. Saraxaraliin xa Ala solona na kiini na kanna xa a yulubi ligaxine fe ra, Ala yi a mafelu.” ");
INSERT INTO yal_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Xa yamaan xilixi sereya badeni e yi e rakɔlɔ, xa muxuna nde feen naxan toxi hanma a a kolon, xa a mi sereyaan ba na ma, a bata yulubin liga. A na hakɛn goronna tongoma nɛn. ");
INSERT INTO yal_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Xa muxuna nde a din se haramuxina nde ra, xa a findi sube haramuxi faxaxin na, hanma xuruse haramuxina nde, hanma bubuse haramuxina nde, hali a mi a kolon, a fan mi fa sariɲanxi, a bata yulubin tongo. ");
INSERT INTO yal_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Xa muxuna nde a din se xɔsixina nde ra naxan fataxi adamadiine ra, hali a mi yi a kolon, a na a kolon, a bata findi yulubi tongon na. ");
INSERT INTO yal_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Xa muxuna nde mi a miri, a a kɔlɔ wulen fari, fa fala a fena nde rabama nɛn. Xa a mi a raba, a bata findi yulubi tongon na.” ");
INSERT INTO yal_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Naxan na findi yulubi tongon na na feene yi, na xa a ti a yulubi ligaxin na. ");
INSERT INTO yal_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Na xanbi ra, a xa fa yɛxɛɛ gilɛn na hanma sii gilɛna, a a ba saraxan na Alatala xa a yanginna ra. Nayi, saraxaraliin xa Ala solona a yulubina fe ra.” ");
INSERT INTO yal_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Xa fɛrɛ mi a xa a xuruseen sɔtɔ, a xa fa ganba firin hanma kolokonde firin na, a ne ba saraxan na a yanginna ra Alatala xa, keden yulubi xafarin na, keden saraxa gan daxin na. ");
INSERT INTO yal_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","A xa e xali saraxaraliin fɛma. A xa yulubi xafari saraxan nan singe ba. A xa a kɔɛɛn gira, koni a nama a xunna bolonɲɛ a ra. ");
INSERT INTO yal_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","A xa a wunla nde xuya saraxa ganden dɛxɔnna ma, a wuli dɔnxɛn nabɔxɔn saraxa ganden dɛxɔn. Yulubi xafari saraxan na a ra. ");
INSERT INTO yal_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","A xa xɔliin boden ba saraxa gan daxin na alo sariyana a falaxi kii naxan yi, a yi Ala solona na kanna yulubina fe ra. Ala a mafeluma nɛn.” ");
INSERT INTO yal_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Xa fɛrɛ mi a xa a ganba firin hanma kolokonde firin sɔtɔ, a nɔɛ fɛ murutu fuɲin kilo naanin na nɛn yulubi xafari saraxan na. Koni a nama turen hanma wusulanna sa a yi, bayo yulubi xafari saraxan na a ra. ");
INSERT INTO yal_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","A xa a xali saraxaraliin fɛma, na yi a yiin yɛ keden ba a ra ɲɔxɔ lu seen na Ala xɔn, a yi a sa saraxane fari naxanye ralima Alatala ma tɛɛni saraxa ganden fari. Yulubi xafari saraxan na a ra. ");
INSERT INTO yal_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Saraxaraliin xa Ala solona na kiini na kanna yulubi ligaxine fe ra, Ala yi a mafelu. Saraxaraliin nan gbee saraxan dɔnxɛn na alo a ligan bogise saraxan na kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Xa muxuna nde tinxintareyaan liga, a yulubin liga tantanni a mi Alatala gbee se sariɲanxine fi a ma. A xa fa kontonna ra e nun naxan yɛlan a yanginna ra Alatala xa, fɛ mi naxan na, naxan saren lanxi kala tixin ma, fata yire sariɲanxin gbeti liga seen na. Yangin saraxan nan na ra. ");
INSERT INTO yal_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","A mi se sariɲanxin naxan fixi, a xa a ɲɔxɔn fi, a yi a saren yaganna dɔxɔɲa ma firin sa a fari, a yi a birin so saraxaraliin yii. Saraxaralina Ala solonama nɛn na kanna xa kontonna ra, a naxan bama yangin saraxan na, Ala yi a mafelu.” ");
INSERT INTO yal_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Xa muxuna nde yulubin liga, a Alatalaa yamarina nde kala, hali a mi a kolon, a bata findi yulubi tongon na. A a hakɛn goronna tongoma nɛn. ");
INSERT INTO yal_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","A xa fa kontonna ra saraxaraliin fɛma fɛ mi naxan na yangin saraxan na. A saren xa lan a kala tixin saren ma fata sariyan na saraxaraliin miriyani. Nayi, saraxaralina Ala solonama nɛn a tantanna fe ra, Ala yi a mafelu. ");
INSERT INTO yal_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Yangin saraxan na a ra, bayo na kanna findixi yulubi tongon nan na Alatala mabinni.” ");
INSERT INTO yal_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","“Xa muxuna nde yulubin liga, a yi tinxintareyaan liga Alatala ra, a wulen fala a boden xa a yii sena nde a fe ra, naxan taxuxi a ra hanma a a muɲa, hanma a a kansun, ");
INSERT INTO yal_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","hanma a a dɛ yixalan sena nde a fe ra naxan lɔxi ayi, a yi a to, hanma a a kɔlɔ wuleni, hanma a yulubina nde liga alo adaman dari fena, ");
INSERT INTO yal_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","a na na sifan liga, a bata findi yulubi tongon na. A xa na se muɲaxin naxɛtɛ, hanma a naxan kansunxi, hanma naxan yi taxuxi a ra, hanma a seen naxan toxi naxan yi lɔxi ayi, ");
INSERT INTO yal_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","hanma a wulen falaxi seen naxan ma fe ra. A xa na ɲɔxɔn fi, a yi yaganna dɔxɔɲa ma firin sa a fari, a yi a so a kanna yii na lɔxɔn yɛtɛni a na yangin saraxan ba lɔxɔn naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","A xa fa kontonna ra saraxaraliin fɛma fɛ mi naxan na yangin saraxan na Alatala xa. Na kontonna saren nun kala tixin saren xa lan. ");
INSERT INTO yal_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Saraxaralina Alatala solonama nɛn, a yi a mafelu na feen na, naxan a findixi yulubi tongon na.” ");
INSERT INTO yal_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","a xa yamarini ito fi Haruna nun a diine ma, a naxa, “Sariyan ni i ra saraxa gan daxine fe ra. Saraxa gan daxin xa lu ganɲɛ saraxa ganden fari kɔɛɛn birin na han xɔtɔnni. Tɛɛn nama tu saraxa ganden fari. ");
INSERT INTO yal_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Na xanbi ra, saraxaraliin xa a maxidi taa dugi gubani e nun a taa dugi bunbirana, a saraxan xuben ba saraxa ganden fari tɛɛn naxanye ganxi, a yi e sa saraxa ganden dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Na xanbi ra, a a dugine masara, a xuben xali yamaan daaxaden fari ma yirena nde yi naxan sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Tɛɛn naxan dɛgɛma saraxa ganden fari, na nama tu. Xɔtɔn yo xɔtɔn, saraxaraliin xa yegene fari sa, a yi saraxa gan daxini tɔn tɛɛni, a bɔɲɛ xunbeli saraxane turen sa a fari. ");
INSERT INTO yal_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Tɛɛn xa lu dɛgɛ saraxa ganden fari waxatin birin. A nama tu.” ");
INSERT INTO yal_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","“Sariyan ni i ra bogise saraxana fe ra: Harunaa diine xa fa a ra Alatala yɛtagi, saraxa ganden yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Saraxaraliin xa murutu fuɲin nun turen yiin yɛɲayi keden tongo, e nun wusulanna birin naxan saxi bogise saraxan fari. A yi na sa tɛɛni ɲɔxɔ lu seen na Ala xɔn saraxa ganden fari, a xirin yi rafan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Haruna nun a diine xa na bogise saraxan dɔnxɛn don. E xa a don yirena nde yi naxan sariɲan Naralan Bubun sansanna kui. Buru rate se nama sa a yi. ");
INSERT INTO yal_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","A mi ganma buru rate seen na. N na nan soxi e yii e gbeen na fata ne saraxane ra naxanye ralima n ma tɛɛn na. A sariɲan han! A sariɲan alo yulubi xafari saraxan nun yangin saraxan sariɲan kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Haruna bɔnsɔnna xɛmɛne birin daxa e xa a don. E gbeen na a ra fata saraxane ra naxanye ralima Alatala ma tɛɛn na waxati famatɔne birin yi. Naxan yo nɛma a yiin dinɲɛ a ra fɔ a xa sariɲan.” ");
INSERT INTO yal_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","“Haruna nun a diine na masusan lɔxɔn naxan yi e yi findi saraxaraline ra, e xa murutu fuɲin kilo saxan ba bogise saraxan na Alatala xa, a tagina xɔtɔnni, a tagiin bonna ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Murutu fuɲin lan a bɔnbɔ turen na, na yi gan tunde dutunna ma. Na xanbi ra, na burudin xa yigira dungi dungin na, a rali bogise saraxan na naxan xiri rafan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Haruna bɔnsɔnna naxan findima saraxarali kuntigin na, na xa saraxani ito ba. Habadan sariyan na a ra Alatala yɛtagi, a ganma nɛn fefe! ");
INSERT INTO yal_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Saraxaraliin na fa bogise saraxan naxan na, a ganma nɛn fefe, a nama don.” ");
INSERT INTO yal_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","a a xa a fala Haruna nun a diine xa, a naxa, “Sariyan ni i ra yulubi xafari saraxana fe ra. Yulubi xafari saraxan xa faxa Alatala yɛtagi saraxa gan daxin kɔɛ raxaban dɛnaxan yi. A sariɲan han! ");
INSERT INTO yal_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Saraxaraliin naxan a ralima, na nan a donma. A xa a don Naralan Bubun sansanna kui yirena nde yi naxan sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Naxan yo nɛma a yiin dinɲɛ a suben na fɔ a xa sariɲan nɛn. Xa a wunla xuya dugina nde ma, i xa na dugin xa yire sariɲanxina nde yi. ");
INSERT INTO yal_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","A na ɲin fɛɲɛn naxan kui, i xa na kala. Koni xa a ɲin sula goronna nan kui, a xa maxa, a malinsaxun. ");
INSERT INTO yal_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Xɛmɛn naxanye saraxaralina denbayani, ne nan daxa, e a don. A sariɲan han! ");
INSERT INTO yal_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Koni yulubi xafari saraxan naxan wunla bata xali Naralan Bubun yire sariɲanxin kui Ala solona seen na, na nama don. Na xa sa tɛɛni.” ");
INSERT INTO yal_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Sariyan ni i ra yangin saraxana fe ra. A sariɲan han! ");
INSERT INTO yal_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Yangin saraxan xa faxa saraxa gan daxin kɔɛ raxaban dɛnaxan yi. A wunla yi so saraxa ganden dɛxɔnne birin ma. ");
INSERT INTO yal_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","A turen birin xa ba saraxan na, a xuli turen nun a turen naxanye a buru subene ma, ");
INSERT INTO yal_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","a gbingi ra xɛlɛ firinne nun turen naxanye e ma a gbingini, farafaran naxan bɔɲɛn ma naxan bama e nun gbingi ra xɛlɛne. ");
INSERT INTO yal_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Saraxaraliin xa ne rali Alatala ma tɛɛni saraxa ganden fari. Yangin saraxan na a ra. ");
INSERT INTO yal_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Xɛmɛn naxanye saraxaralina denbayani, ne nan daxa, e a don, koni fɔ a xa don yire sariɲanxina nde yi, bayo a sariɲan han! ");
INSERT INTO yal_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Yangin saraxan nun yulubi xafari saraxan lanxi sariya kedenni ito nan ma: saraxaraliin naxan Ala solonama, a tan nan gbee suben na.” ");
INSERT INTO yal_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","“Saraxaraliin naxan saraxa gan daxin bama muxuna nde xa, a tan nan gbee na kidin na.” ");
INSERT INTO yal_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","“Bogise saraxan naxan birin ganxi buru gandeni, naxan nafalaxi tunde dutunna ma hanma naxan gilinxi, saraxaraliin nan gbee ne ra, naxan saraxan nalixi. ");
INSERT INTO yal_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Bogise saraxan birin naxan basanxi turen na hanma a xarena, Haruna bɔnsɔnne birin nan gbee ne ra.” ");
INSERT INTO yal_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Sariyan ni i ra bɔɲɛ xunbeli saraxana fe ra naxan bama Alatala xa. ");
INSERT INTO yal_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Xa muxuna nde xuruseen bama barika bira seen na, a xa a ba e nun buru xunne buru rate se mi naxanye yi naxanye bɔnbɔxi turen na e nun burudine turen saxi naxanye ma buru rate se mi naxanye yi, e nun buru yilɛnlɛnxin naxanye rafalaxi murutu fuɲin faɲin na naxanye bɔnbɔxi turen na. ");
INSERT INTO yal_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Buru rate seen buru xunna naxanye yi, na ndee xa sa bɔɲɛ xunbeli saraxan fari naxan bama barika bira seen na. ");
INSERT INTO yal_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","A xa nde ba ne keden kedenna ra, a na fi Alatala ma. Na findima saraxaraliin nan gbee ra naxan bɔɲɛ xunbeli saraxan wunla xuyaxi. ");
INSERT INTO yal_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Bɔɲɛ xunbeli saraxan naxan bama barika bira seen na, na suben xa don a ba lɔxɔn nin. Na sese nama ramara han xɔtɔnni.” ");
INSERT INTO yal_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Koni, xa muxuna nde bɔɲɛ xunbeli saraxan bama alogo a xa a dɛ xuiin nakamali hanma a a ba ɲɛnige ma saraxan na, saraxa suben xa don a ba lɔxɔn nin, koni naxan na lu, a nɔɛ na donɲɛ nɛn na xɔtɔn bode. ");
INSERT INTO yal_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Saraxan suben dɔnxɛn naxan na lu a xii saxandeni na xa sa tɛɛni. ");
INSERT INTO yal_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Xa muxuna nde susu a bɔɲɛ xunbeli saraxan suben don a xii saxande lɔxɔni, saraxan mi rasuxuma. Ala mi a yatɛma sese ra, a ba muxun xa bayo a haramuxi. Naxan na a don, a na hakɛn goronna tongoma nɛn. ");
INSERT INTO yal_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Suben naxan na din se haramuxin na, na nama don, a xa sa tɛɛni. Muxun naxan sariɲan, na kanna daxa a saraxa suben don, ");
INSERT INTO yal_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","koni naxan mi sariɲanxi, a yi bɔɲɛ xunbeli saraxa subena nde don Alatala gbeen naxan na, na kedima nɛn a yamani. ");
INSERT INTO yal_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Naxan na a din se haramuxina nde ra, fata adaman na hanma sube haramuxina, hanma xɔsi se haramuxina nde, a yi bɔɲɛ xunbeli saraxa suben don Alatala gbeen naxan na, na kanna kedima nɛn a yamani.” ");
INSERT INTO yal_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","a a xa a fala Isirayila kaane xa, a naxa, “Ɛ nama ɲingen turen don, hanma yɛxɛɛna, hanma siina. ");
INSERT INTO yal_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","I na suben to, a faxaxi hanma burunna subene a yibɔxi, ne turen nɔɛ rawalɛ nɛn se gbɛtɛ ra, koni i nama a don. ");
INSERT INTO yal_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Naxan na na sube sifane turen don naxanye nɔɛ raliyɛ Alatala ma tɛɛn na, na kedima nɛn a yamani. ");
INSERT INTO yal_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ɛ nama xɔliin wunla don hanma suben wunla, ɛ nɛma dɔxi dɛdɛ yi. ");
INSERT INTO yal_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Naxan na wunla nde don, na kedima nɛn a yamani.” ");
INSERT INTO yal_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","a a xa a fala Isirayila kaane xa, a naxa, “Naxan na bɔɲɛ xunbeli saraxan ba, a xa fa a fɔxɔ kedenna ra, a na ba saraxan na Alatala xa. ");
INSERT INTO yal_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","A yɛtɛɛn xa fa na kiseen na naxan nalima Alatala ma tɛɛn na. A xa fa suben turen nun a kanken na. A xa a kanken yita Alatala ra alo se ralixina. ");
INSERT INTO yal_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Saraxaraliin xa turen sa tɛɛni saraxa ganden fari, koni a kanken xa lu Haruna nun a diine xa. ");
INSERT INTO yal_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","I xa bɔɲɛ xunbeli saraxan yiifari ma danban fi saraxaraliin ma kiseen na. ");
INSERT INTO yal_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Haruna bɔnsɔnna naxan bɔɲɛ xunbeli saraxan wunla nun turen nalixi, na nan gbee a yiifari ma danban na. ");
INSERT INTO yal_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Amasɔtɔ Isirayila kaane bɔɲɛ xunbeli saraxan naxanye bama, a kanke ralixin nun a danban naxan fixi, n bata ne so Haruna nun a diine yii, saraxaraline. Isirayila kaane na subene nan soma e yii habadan.” ");
INSERT INTO yal_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“Ito nan findi Haruna nun a diine gbeen na e Alatalaa saraxarali wanla fɔlɔ lɔxɔn naxan yi. A bama ne saraxane ra naxanye ralixi Alatala ma tɛɛn na. ");
INSERT INTO yal_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Alatala na nan yamarixi Isirayila kaane ma, e to masusan lɔxɔn naxan yi. Habadan sariyan na a ra e yixɛtɛne birin xa. ");
INSERT INTO yal_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Sariyane nan ne ra saraxani itoe fe ra: saraxa gan daxina, bogise saraxana, yulubi xafari saraxana, yangin saraxana, saraxaraliin dɔxɔ saraxana e nun bɔɲɛ xunbeli saraxana. ");
INSERT INTO yal_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Alatala na sariyan so Musa yii Sinayi geyaan nan fari, a Isirayila kaane yamari lɔxɔn naxan yi Sinayi tonbonni, a e xa fa e saraxane ra Alatala xa.” ");
INSERT INTO yal_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Haruna nun a diine xili Naralan Bubun so dɛɛn na. I xa fa e dugine nun masusan turen na, e nun turaan naxan bama yulubi xafari saraxan na, e nun konton firin e nun debena buru ratetarene naxan kui. ");
INSERT INTO yal_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","I xa Isirayila yamaan birin malan Naralan Bubun so dɛɛn na.” ");
INSERT INTO yal_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Alatala yamarin naxan fi, Musa yi na liga, yamaan yi e malan Naralan Bubun so dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa yi a fala yamaan xa, a naxa, “Alatala ito nan yamarixi.” ");
INSERT INTO yal_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Musa yi Haruna nun a diine maso, a yi e maxa. ");
INSERT INTO yal_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","A yi dugin nagodo Haruna ma, a yi a tagi xidi tagixidin na, a gubaan nagodo a ma, a saraxarali domaan nagodo a ma, a saraxarali domaan tagi xidi tagixidi faɲin na. ");
INSERT INTO yal_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","A yi kanke masaan bira a kɔɛ, a masɛnsɛn ti seene, Yurima nun Tumin sa na kui. ");
INSERT INTO yal_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","A yi namun so Haruna xun na, a yi xɛma walaxadin sa a tigi yɛɛ ra taxamaseri sariɲanxin na alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Musa yi masusan turen tongo, a Ala batu bubun masusan e nun a yi seen birin. A ne birin nasariɲan. ");
INSERT INTO yal_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","A yi na turena nde xuya saraxa ganden ma dɔxɔɲa ma solofere, a saraxa ganden masusan e nun a goronne birin, e nun ige sa seen nun a dɔxɔ sena, alogo a xa ne rasariɲan. ");
INSERT INTO yal_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","A mɔn yi turen sa Haruna xunni, a a masusan, alogo a xa a rasariɲan. ");
INSERT INTO yal_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","A yi Harunaa diine maso. A yi e dugine ragodo e ma, e nun tagi xidine nun xun tagi xidine, alo Alatala yamarin naxan so Musa yii. ");
INSERT INTO yal_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","A yi fa turaan na yulubi xafari saraxan na, Haruna nun a diine yi e yiine sa turaan xunna fari. ");
INSERT INTO yal_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa yi a kɔɛ raxaba, a a wunla nde tongo, a yi a sa saraxa ganden tongonna fenne ma a yii sonla ra, alogo a xa saraxa ganden nasariɲan. A yi wuli dɔnxɛn nabɔxɔn saraxa ganden dɛxɔn ma. A saraxa ganden nasariɲan na kiini alogo a xa Ala solona mɛnni. ");
INSERT INTO yal_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Musa mɔn yi turen tongo naxanye yi ɲingen buru subene rabilinni, e nun farafaran naxan yi bɔɲɛn fari, e nun a gbingi ra xɛlɛ firinne nun e turene. A yi na birin sa tɛɛni saraxa ganden fari. ");
INSERT INTO yal_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Koni a yi ɲingen gbindin nun a kidin nun a suben nun a gbiine woli tɛɛni yamaan daaxaden fari ma, alo Alatala a yamarin Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Na xanbi ra, a yi fa kontonna ra saraxa gan daxin na. Haruna nun a diine yi e yiine sa a xunna ma. ");
INSERT INTO yal_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa yi a kɔɛ raxaba, a a wunla nde so saraxa ganden dɛxɔnne ma. ");
INSERT INTO yal_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","A yi a yixaba dungi dungin na, a a xunna sa tɛɛni, e nun a dungine nun a turena. ");
INSERT INTO yal_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","A yi a buru subene nun a sanne maxa, a yi kontonna gbindin birin sa tɛɛni saraxa ganden fari saraxa gan daxin na, naxan nalixi Alatala ma tɛɛn na alo a yamari Musa ma kii naxan yi. A xirin yi rafan Ala ma. ");
INSERT INTO yal_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Na xanbi ra, a yi fa kontonna firinden na saraxarali dɔxɔ saraxan na. Haruna nun a diine yi e yiine sa a xunna ma. ");
INSERT INTO yal_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa yi a kɔɛ raxaba, a a wunla nde tongo, a yi a sa Haruna yiifari ma tunla ma. A nde sa a yiifari ma yii konkoribaan nun a san konkoribaan ma. ");
INSERT INTO yal_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","A yi Harunaa diine fan maso, a a wunla nde sa e yiifari ma tunle ma e nun e yiifari ma yii konkoribaan nun san konkoribane. A yi a wunla nde so saraxa ganden dɛxɔnne ma. ");
INSERT INTO yal_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","A a turen tongo, e nun a xuli turena, e nun turen naxanye a buru subene rabilinni, e nun farafaran naxan a bɔɲɛn fari, e nun a gbingi ra xɛlɛ firinne nun e turene, e nun a yiifari ma danbana. ");
INSERT INTO yal_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","A deben tongo buru ratetaren naxan kui, naxan yi Alatala yɛtagi. A yi buru xun keden tongo, e nun buru keden naxan nafalaxi turen na e nun burudi keden. A yi e sa suben turene nun yiifari ma danban fari. ");
INSERT INTO yal_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","A yi e birin so Haruna nun a diine yii, a yi e yite Alatala yɛtagi se ralixin na. ");
INSERT INTO yal_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Na xanbi ra, Musa yi e rasuxu e ra, a yi e sa tɛɛni saraxa ganden fari saraxa gan daxine fari. Saraxarali dɔxɔ saraxan na a ra, naxan xiri rafan Ala ma. A ralima Alatala ma tɛɛn nan na. ");
INSERT INTO yal_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa yi kontonna kanken tongo a yi a yite Alatala yɛtagi se ralixin na. Na yi findi Musa gbeen na alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musa yi masusan turena nde tongo e nun wunla nde naxan yi saraxa ganden fari, a yi a xuya Haruna nun a dugine ma, e nun a diine nun e dugine. Nayi, a yi Haruna nun a dugine rasariɲan, e nun a diine nun e dugine. ");
INSERT INTO yal_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa yi a fala Haruna nun a diine xa, a naxa, “Ɛ suben ɲin Naralan Bubun dɛ ra, ɛ yi a don na, e nun burun naxan deben kui saraxarali dɔxɔ saraxan na, alo n na a yamari kii naxan yi. N naxa, ‘Haruna nun a diine xa a don.’ ");
INSERT INTO yal_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ɛ xa burun nun sube dɔnxɛn woli tɛɛni. ");
INSERT INTO yal_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ɛ nama keli Naralan Bubun dɛ ra xii solofere, han ɛ dɔxɔ fe lɔxɔne yi ɲan bayo ɛ dɔxɔ feene buma nɛn xii solofere. ");
INSERT INTO yal_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Alatala to feene yamarixi nɛn alogo a xa solona ɛ xa. ");
INSERT INTO yal_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Nanara, ɛ xa lu Naralan Bubun dɛɛn na xii solofere, kɔɛɛn nun yanyin na, ɛ yi Alatalaa yamarin suxu, alogo ɛ nama faxa, amasɔtɔ na nan yamarixi n ma.” ");
INSERT INTO yal_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Alatalaa yamarin naxanye birin fi e ma fata Musa ra, Haruna nun a diine yi ne birin liga. ");
INSERT INTO yal_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Xii solomasɛxɛde lɔxɔni, Musa yi Haruna nun a diine xili, e nun Isirayila fonne. ");
INSERT INTO yal_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","A yi a fala Haruna xa, a naxa, “Turaan dii keden tongo i yulubi xafari saraxan na e nun konton keden saraxa gan daxin na, fɛ mi naxanye ra, i fa e ra Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","I yi a fala Isirayila kaane xa, i naxa, ‘Ɛ xa kɔtɔn tongo yulubi xafari saraxan na, e nun turaan diin nun yɛxɛɛ diina ɲɛɛ keden kedenne, fɛ mi naxanye ra saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","e nun turana e nun kontonna bɔɲɛ xunbeli saraxan na, alogo e xa ba saraxan na Alatala yɛtagi, e nun bogise saraxan naxan basanxi turen na. Amasɔtɔ Alatala a nɔrɔn yitama ɛ ra nɛn to.’ ” ");
INSERT INTO yal_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Musa naxan yamari, e na xali Naralan Bubun yɛtagi. Yamaan birin yi e maso, e ti Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa yi a fala, a naxa, “Alatalaa yamarin ni i ra ɛ naxan ligama alogo ɛ xa a nɔrɔn to.” ");
INSERT INTO yal_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa yi a fala Haruna xa, a naxa, “I maso saraxa ganden na. I yi i yulubi xafari saraxan nun saraxa gan daxin ba, i Ala solona i yɛtɛɛn nun yamaan xa. I xa saraxan ba yamaan fan xa alogo i xa Ala solona e xa, alo Alatala a yamarixi kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Haruna yi a maso saraxa ganden na, a yi turaan diin kɔɛ raxaba a yɛtɛ yulubi xafari saraxan na. ");
INSERT INTO yal_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","A diine yi fa a wunla ra a xɔn, a yi a yii sonla sin wunli, a yi a sa saraxa ganden tongonna fenne ma. A yi wuli dɔnxɛn nabɔxɔn saraxa ganden dɛxɔn ma. ");
INSERT INTO yal_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A yi a turen sa tɛɛni saraxa ganden fari, e nun a gbingi ra xɛlɛne nun farafaran naxan a bɔɲɛn fari, e naxanye baxi yulubi xafari saraxani, alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Koni a yi a suben nun a kidin sa tɛɛni yamaan daaxaden fari ma. ");
INSERT INTO yal_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","A yi saraxa gan daxin kɔɛ raxaba. A diine yi a wunla so a yii, a yi a so saraxa ganden dɛxɔnne ma. ");
INSERT INTO yal_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","E yi saraxan dungi keden keden so a yii e nun a xunna, a yi e sa tɛɛni saraxa ganden fari. ");
INSERT INTO yal_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","A yi a buru subene nun a sanne maxa, a yi e sa saraxa gan daxin fari tɛɛni saraxa ganden fari. ");
INSERT INTO yal_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Na xanbi ra, Haruna yi fa yamana saraxan na. A yi yamana yulubi xafari saraxa kɔtɔn tongo, a yi a kɔɛ raxaba. A na ba yulubi xafari saraxan na alo a singen ba kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","A yi fa saraxa gan daxin na, a na ba alo sariyana a falaxi kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","A yi fa bogise saraxan na, a yi a yiin yɛ keden ba a ra, a yi na sa tɛɛni saraxa ganden fari, sa xɔtɔn ma saraxan gan daxin fari. ");
INSERT INTO yal_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","A yi turaan nun kontonna kɔɛ raxaba yamana bɔɲɛ xunbeli saraxan na. A diine yi a wunla so a yii, a yi a so saraxa ganden dɛxɔnne ma. ");
INSERT INTO yal_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","E yi turaan nun kontonna turen tongo, e nun a xuli turena, a ture yirene, a gbingi ra xɛlɛne, e nun farafaran naxan a bɔɲɛn fari, ");
INSERT INTO yal_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","e yi ne sa subene kankene fari. Haruna yi turene sa tɛɛni saraxa ganden fari. ");
INSERT INTO yal_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Haruna yi subene kankene nun e yiifari ma danbane yite Alatala yɛtagi, se ralixin na alo Musa a yamari kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Haruna yi a yiine yite yamaan binni, a duba e xa. A to yulubi xafari saraxan nun saraxa gan daxin nun bɔɲɛ xunbeli saraxan ba, a yi godo. ");
INSERT INTO yal_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa nun Haruna yi so Naralan Bubun kui. E to mini, e duba yamaan xa. Alatalaa nɔrɔn yi godo saraxa gandeni yamaan yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Tɛɛn yi mini Alatala yɛtagi, a saraxan nun turen gan saraxa ganden fari. Yamaan to na to, e sɔnxɔ sɛwani, e yi e xinbi sin, e yɛtagin lan bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Haruna dii firinne, Nadaba nun Abihu, ne yi e wusulan gan seene tongo, e tɛɛn sa e kui, e wusulanna sa a fari. E yi fa tɛɛn na Alatala yɛtagi, naxan mi yi lan, a mi yi naxan yamarixi. ");
INSERT INTO yal_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Nayi, tɛɛn yi mini Alatala yɛtagi, a yi e gan, e faxa Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musa yi a fala Haruna xa, a naxa, “Alatala ɛ rakolonxi nɛn ito ra, a to a fala, a naxa, ‘N na n ma sariɲanna mayitama nɛn n batu muxune tagi. N binyama nɛn yamaan yɛtagi.’ ” Haruna yi lu dunduxi. ");
INSERT INTO yal_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa yi Mikayeli nun Elisafan xili, Haruna sɔxɔ Yusiyɛli a diine, a yi a fala e xa, a naxa, “Ɛ xa ɛ ngaxakedenne binbine xali yamaan daaxaden fari ma, keli yire sariɲanxin yɛtagi.” ");
INSERT INTO yal_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","E yi fa, e yi e xali yamaan daaxaden fari ma, alo Musa e yamari kii naxan yi. Dugine mɔn yi e binbine ma. ");
INSERT INTO yal_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musa yi a fala Haruna nun a diine xa, Eleyasari nun Itamara, a naxa, “Ɛ nama ɛ xunna lu a yitɔntaren na, ɛ to sunuxi. Ɛ nama ɛ dugine yibɔ, alogo ɛ nama faxa, ɛ yi Alatalaa xɔlɔn nafa yamaan birin ma. Alatala ɛ kon kaan naxanye faxaxi tɛɛn na, Isirayila yamaan birin nan ne wugama. ");
INSERT INTO yal_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ɛ nama keli Naralan Bubun so dɛɛn na, alogo ɛ nama faxa, amasɔtɔ Alatalaa masusan turen nan ɛ ma.” Musa naxan fala, e na liga. ");
INSERT INTO yal_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Alatala yi a fala Haruna xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“I na so Naralan Bubun kui, i nama manpaan min, i nama na minse sifan min, i tan nun i ya diine, alogo ɛ nama faxa. A findima habadan sariyan nan na i yixɛtɛne xa waxati famatɔne yi. ");
INSERT INTO yal_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ɛ xa se sariɲanxin nun a haramuxin tagi raba, naxan mi daxa e nun naxan daxa. ");
INSERT INTO yal_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ɛ xa Isirayila kaane xaran tɔnne ma Alatala naxanye fixi e ma fata Musa ra.” ");
INSERT INTO yal_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa yi a fala Haruna nun a diine xa naxanye yi fa luxi, Eleyasari nun Itamara, a naxa, “Bogise saraxan naxan luxi, naxan mi ralixi Alatala ma tɛɛn na, ɛ xa na tongo, ɛ yi a don saraxa ganden fɛma. A nama basan buru rate seen na. A sariɲan fefe! ");
INSERT INTO yal_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ɛ xa a don yirena nde yi naxan sariɲan, amasɔtɔ i gbeen na a ra ɛ nun i ya diine, fata na saraxane ra naxanye ralixi Alatala ma tɛɛn na, bayo na nan yamarixi n ma. ");
INSERT INTO yal_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Koni suben kanken naxan nalixi e nun danban naxan yitexi Ala xa, ɛ nun i ya dii xɛmɛne nun i ya dii tɛmɛne xa ne don yirena nde yi naxan sariɲan. Amasɔtɔ e bata so ɛ yii ɛ gbeen na, naxanye baxi Isirayila kaane bɔɲɛ xunbeli saraxane ra. ");
INSERT INTO yal_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Isirayila kaane lan e xa fa danban na naxan yitexi e nun kanken naxan nalixi Ala ma, sa turene fari naxanye sama tɛɛni, alogo e xa yite Alatala yɛtagi se ralixin na. Habadan sariyan na a ra: I gbeen nan e ra, ɛ nun i ya diine alo Alatala a yamarixi kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Musa yi kɔtɔna fe maxɔdin, naxan baxi yulubi xafari saraxan na. A yi a mɛ a e bata yi a birin sa tɛɛni. Nayi, a yi xɔlɔ Eleyasari nun Itamara ma, Harunaa dii naxanye lu, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Nanfera ɛ mi saraxani ito suben donxi yire sariɲanxini? A sariɲan han! Alatala subeni ito soxi ɛ yii nɛn alogo Isirayila yamana hakɛn xa ba a ma, ɛ yi Alatala solona e xa. ");
INSERT INTO yal_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Amasɔtɔ subeni ito wunla to mi soxi yire sariɲanxin kui, nayi ɛ lan nɛn ɛ kɔtɔn suben don yire sariɲanxini, alo n na a yamari kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Haruna yi a fala Musa xa, a naxa, “I tuli mati. E bata yulubi xafari saraxan nun saraxa gan daxin ba Alatala yɛtagi to lɔxɔni, na kui, i mi a to fe sifan naxan n masɔtɔxi. Na yi Alatala kɛnɛnɲɛ ba, xa n fa yulubi xafari saraxa suben don to?” ");
INSERT INTO yal_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa to na mɛ, na yi a kɛnɛn. ");
INSERT INTO yal_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Alatala yi a fala Musa nun Haruna xa, ");
INSERT INTO yal_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","a e xa a fala Isirayila kaane xa, e naxa, “Bɔxɔn subene birin yɛ, ɛ lan ɛ xa itoe nan don: ");
INSERT INTO yal_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Sube toro kanna naxanye mɔn donseen laxunma, ɛ nɔɛ ne birin donɲɛ nɛn fɔ naxanye toro mi bɔxi ɲaxi ra.” ");
INSERT INTO yal_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“Koni ndee na naxanye donseen laxunma tun, hanma naxanye toro bɔxi tun, ne haramuxin na a ra ɛ tan xa. Ɲɔgɔmɛna, na haramuxi bayo a donseen laxunma, koni a toro mi bɔxi ɲaxi ra. ");
INSERT INTO yal_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Fanyerasiin donseen laxunma, koni a toro mi bɔxi ɲaxi ra. A haramuxin na a ra ɛ tan xa. ");
INSERT INTO yal_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ɲeren donseen laxunma, koni a toro mi bɔxi ɲaxi ra, a haramuxin na a ra ɛ tan xa. ");
INSERT INTO yal_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Xɔsɛn toron bɔxi, koni a mi donse laxunma, a haramuxin na a ra ɛ tan xa. ");
INSERT INTO yal_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ɛ nama e suben don, ɛ nama ɛ yiin din e faxaxin na. E haramuxin na a ra ɛ tan xa.” ");
INSERT INTO yal_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Niimaseen naxanye igeni, ɛ lan ɛ xa xali yɛxɛne don naxanye e bama, fɔxɔ igeni hanma baani. ");
INSERT INTO yal_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Koni niimase xunxuri naxanye fɔxɔ igeni hanma baani, e mi e bama, e xali mi e ma, ɛ nama ne don. E xɔsixin na a ra ɛ tan xa. ");
INSERT INTO yal_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Se xɔsixin nan ne ra ɛ tan xa, ɛ nama e suben don. Ɛ xa e faxaxin yatɛ alo xɔsina. ");
INSERT INTO yal_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Naxanye birin igeni, e mi e bama, e xali mi e ma, se xɔsixin nan ne ra ɛ tan xa.” ");
INSERT INTO yal_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Ɛ xa xɔliini itoe yatɛ alo se xɔsixina, ɛ nama ne don: singbinna nun dugan nun xɔlimangan ");
INSERT INTO yal_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","nun bangaan nun sɛgɛn siyaan birin ");
INSERT INTO yal_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","e nun xaxaan siyaan birin ");
INSERT INTO yal_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","nun dangaranfulen nun kutunxunban nun fɔxɔ ige ma xɔliin nun tɔxɛdi tongon siyaan birin, ");
INSERT INTO yal_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","e nun kunkutunna nun ɲinɲaxan nun fɔtɔnbunsamuran ");
INSERT INTO yal_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","nun toxoroon nun yɛxɛ suxu kankon nun kankanna, ");
INSERT INTO yal_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","e nun yaya xɔnla nun saɲi xɔnla siyaan birin, e nun sarasima xɔnla nun tuyɛna.” ");
INSERT INTO yal_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Gabutɛɛn nun sanne niimase xunxurin naxanye ma, ba xɔline ra, ne xɔsixin na a ra ɛ tan xa. ");
INSERT INTO yal_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Koni, xa na niimase xunxurin sifana nde sanna a ligɛ a tugan, ɛ nɔɛ na donɲɛ nɛn. ");
INSERT INTO yal_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ɛ nɔɛ itoe nan donɲɛ ne yɛ: suɲɛn siyaan birin nun xoxorone nun songolonbalane e nun tuguminne. ");
INSERT INTO yal_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Koni, gabutɛɛn nun sanne niimase xunxuri gbɛtɛ naxanye ma, ɛ xa ne yatɛ se xɔsixine ra. ");
INSERT INTO yal_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ne ɛ raxɔsima nɛn. Naxan yo na a yiin din e faxaxin na, na kanna mi fa sariɲanxi han ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Naxan yo na e faxaxin tongo, na lan a yi a dugine xa. A mi fa sariɲanxi han ɲinbanna ra.” ");
INSERT INTO yal_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Suben naxan birin toro mi bɔxi ɲaxi ra hanma a mi donseen laxunma, ne haramuxin na ra ɛ tan xa. Naxan na a yiin din e faxaxin na, na mi fa sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Sube san naaninna naxanye birin sanna xunduxi, e haramuxin na a ra ɛ tan xa. Naxan yo na a yiin din e faxaxin na, na kanna mi fa sariɲanxi han ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Naxan yo na e faxaxin tongo, na lan a yi a dugine xa, a mi fa sariɲanxi han ɲinbanna ra. E haramuxin na a ra ɛ tan xa.” ");
INSERT INTO yal_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Yili ra seen naxanye bɔxɔn ma, itoe nan haramuxi ɛ tan xa: sulumɛn nun yɛlɛn nun dangen siyaan birin, ");
INSERT INTO yal_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","e nun lɛnnakɔnsaan nun sagadin nun kendemelexaan nun mululuna e nun kolona. ");
INSERT INTO yal_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ne nan haramuxi ɛ xa yili ra seene yɛ bɔxɔn ma. Naxan yo na a yiin din e faxaxin na, na kanna mi fa sariɲanxi han ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","E faxaxin na bira se yo ma, na xɔsima nɛn, xa a findi wudi daxin na, hanma dugina, hanma kidina, hanma bɛnbɛnla. Goron yo naxan nawalɛ wali yo yi, a sama nɛn igeni. A mi fa sariɲanxi han ɲinbanna ra. Na xanbi ra, a yi sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Xa na niimasena nde keden bira fɛɲɛna nde kui, a xɔsima nɛn. Ɛ xa na fɛɲɛn kala. ");
INSERT INTO yal_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Donseen naxan lan a xa don, koni xa na fɛɲɛ kui igen sa a ma, a xɔsima nɛn. Minse yo na min na fɛɲɛn kui, a xɔsixin na a ra. ");
INSERT INTO yal_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","E faxaxin na bira se yo ma, na xɔsima nɛn. Xa buru ganden na a ra hanma tɛɛ yinla fɔ ɛ xa a kala, bayo a xɔsixi. Ɛ xa a yatɛ alo se haramuxina. ");
INSERT INTO yal_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Koni xa a faxaxin bira tigini hanma ige ramaradeni, ne mi xɔsixi. Koni naxan na a yiin din a faxaxin na, na mi fa sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Xa a faxaxin bira sansiin ma naxan lan a si, a mi xɔsixi. ");
INSERT INTO yal_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Koni xa igen bata sa sansiin ma, a faxaxin yi bira a yi, na sansiin bata haramu ɛ xa.” ");
INSERT INTO yal_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Suben naxan lan a xa don, xa na faxa a yɛtɛ ma, naxan na a yiin din a faxaxin na, na mi fa sariɲanxi han ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Naxan na a suben don, na lan a yi a dugine xa, a mi fa sariɲanxi han ɲinbanna ra. Naxan yo na e faxaxin maxali na lan a xa a dugine xa, a mi fa sariɲanxi han ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Ɛ nama niimase xunxuridine don, naxanye bɔxɔn ma. Ne xɔsixin na a ra. ");
INSERT INTO yal_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Niimase xunxurin naxanye birin e bubuma bɔxɔn ma, ɛ nama ne sese don. Xa a bubuma a kuiin ma hanma a sigan tima a san naaninne ra hanma a san wuyaxi, a xɔsixin na a ra. ");
INSERT INTO yal_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Nayi, ɛ nama ɛ yɛtɛ raxɔsi na niimase xunxurine xɔn. Ɛ nama ɛ yɛtɛ raxɔsi e xɔn de! ");
INSERT INTO yal_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Alatala nan n tan na, ɛ Ala. Ɛ xa ɛ yɛtɛ suxu sariɲanna kui, alogo ɛ xa sariɲan, bayo n tan sariɲan. Ɛ nama ɛ yɛtɛ raxɔsi niimase xunxuri yo xɔn naxanye e bubun bɔxɔn ma.” ");
INSERT INTO yal_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","“N tan nan Alatala ra naxan ɛ raminixi Misiran yi alogo n xa findi ɛ Ala ra. Nanara, ɛ xa sariɲan, amasɔtɔ n tan sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Sariyan nan na ra naxan lanxi subene ma, e nun xɔline, e nun niimaseen naxanye birin igeni e nun naxanye bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ɛ xa sube haramuxine nun sube daxaxine tagi raba, naxanye lan e don e nun naxanye mi lan e don.” ");
INSERT INTO yal_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","a a xa a fala Isirayila kaane xa, a naxa, “Xa ɲaxanla nde fudikan, a dii xɛmɛn bari, a mi fa sariɲanxi na feen ma han xii solofere, alo a nɛma a kike wanli. ");
INSERT INTO yal_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Xii solomasɛxɛden lɔxɔni, diin yi banxulan. ");
INSERT INTO yal_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","A mɔn mi sariɲanxi xii tonge saxan nun saxan benun a xa sariɲan wunla ma naxan minixi a ma dii bari waxatini. A nama a yiin din se sariɲanxi yo ra, a nama siga yire sariɲanxini, han a marasariɲan lɔxɔne yi kamali. ");
INSERT INTO yal_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Xa a dii tɛmɛn bari, a mi fa sariɲanxi xunsagi firin, alo a nɛma a kike wanli bayo wunla bata mini a ma. A xa a marasariɲanna legeden xii tonge sennin nun sennin. ");
INSERT INTO yal_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","A marasariɲan lɔxɔne na kamali a dii xɛmɛn xa hanma a dii tɛmɛna, a xa yɛxɛɛ diin ɲɛɛ kedenna saraxa gan daxin xali saraxaraliin fɛma Naralan Bubun dɛɛn na, e nun kolokonde diina hanma ganbana, yulubi xafari saraxan na. ");
INSERT INTO yal_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Saraxaraliin xa na saraxane ba Alatala xa, a yi Ala solona na ɲaxanla xa. A sariɲanma nɛn a wunla ma. Sariyan nan na ra ɲaxanla xa naxan na dii xɛmɛn bari hanma dii tɛmɛna. ");
INSERT INTO yal_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Xa a mi nɔ yɛxɛɛn sɔtɛ, a nɔɛ ganba firin hanma kolokonde dii firin xalɛ nɛn, kedenna xa ba saraxa gan daxin na, bonna yulubi xafari saraxana. Saraxaraliin xa Ala solona a xa, a sariɲanma nɛn.” ");
INSERT INTO yal_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Alatala yi a fala Musa nun Haruna xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Xa muxun fatin yirena nde kusinxi, hanma kafanla a ma hanma fure dɛna nde a fatin ma naxan nɔɛ findɛ fure ɲaxin na dangu muxu gbɛtɛ ma, na xa xali saraxarali Haruna fɛma hanma a diina nde. ");
INSERT INTO yal_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Furen naxan a fatin ma, saraxaraliin xa na mato. Xa furen yiren xabene bata fixa, a dɛɛn yi tilinɲɛ ayi, fure ɲaxin nan na ra. A na yelin a matoɛ, saraxaraliin xa a fala, a na kanna mi sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Xa fure dɛ fixɛna a fatin ma, koni a mi tilin, a fati ma xabe mi fixaxi, saraxaraliin xa furemaan lu a danna xunsagi keden. ");
INSERT INTO yal_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","A xii soloferede lɔxɔni, a yi a mato. Xa a to furen dɛɛn mi masaraxi, a mi gboxi ayi a fatin ma, a mɔn xa furemaan lu a danna xunsagi keden. ");
INSERT INTO yal_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Saraxaraliin xa a mato a xunsagi firinden xii soloferede lɔxɔni. Xa furen bata fisa a mi gboxi ayi a fatin ma, saraxaraliin xa a fala, a na kanna bata sariɲan. Kafanla nan tun na a ra. A xa a dugine xa, a sariɲanma nɛn. ");
INSERT INTO yal_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Koni saraxaraliin yelin xanbini a falɛ a sariɲanxi, xa kafanla fa gbo ayi a fatin ma, na kanna mɔn xa xɛtɛ saraxaraliin fɛma. ");
INSERT INTO yal_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Saraxaraliin mɔn xa a mato. Xa a to kafanla bata gbo ayi a fatin ma, a xa a fala, a na kanna mi sariɲanxi, fure ɲaxin na a ra.” ");
INSERT INTO yal_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Xa fure ɲaxin bata lu muxuna nde fatin ma, e xa a xali saraxaraliin fɛma. ");
INSERT INTO yal_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","A xa a mato. Xa kusindena nde a ma naxan dɛ bata fixa, xa na kusinden bata fati ma xaben fixa, a suben minixi kɛnɛnni, ");
INSERT INTO yal_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","nayi fure ɲaxi kɔxɔxin nan na ra. Saraxaraliin xa a fala, a na kanna mi sariɲanxi. A nama lu a danna matoni, bayo a bata a kolon a mi sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Xa saraxaraliin bata a to a na fure ɲaxin bata gasin namini a fatin birin ma, keli a sanne ma han a xunna, ");
INSERT INTO yal_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","a xa a mato ki faɲi, bayo xa na furena a fatin birin ma, a xa a fala furemaan ma, a sariɲan bayo furen bata yelin xarɛ. ");
INSERT INTO yal_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Koni furen dɛɛn na mini a ma lɔxɔn naxan yi, a mi sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Saraxaraliin na furen dɛɛn to a ma, a xa a fala a ma, a mi sariɲanxi. Fure ɲaxin nan na ra. ");
INSERT INTO yal_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Xa furen dɛɛn xara, na kanna xa siga saraxaraliin fɛma. ");
INSERT INTO yal_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","A xa a mato. Xa furen bata xara, saraxaraliin xa a fala furemaan ma, a bata sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Xa seteen te muxuna nde ma, a yalan, ");
INSERT INTO yal_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","a funfun yi kusin, a fixa hanma a gbeeli, na muxun xa siga saraxaraliin fɛma. ");
INSERT INTO yal_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Saraxaraliin xa a mato. Xa furen funfun tilin, a fati ma xabe bata fixa, saraxaraliin xa a fala, a na kanna mi sariɲanxi. Fure ɲaxin na a ra, naxan minixi seteen funfuni. ");
INSERT INTO yal_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Koni saraxaraliin na a mato, xa a mi fati ma xabe fixɛ to, xa furen funfun mi tilin, a xaraxi, a xa furemaan lu a danna xunsagi keden. ");
INSERT INTO yal_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Xa furen bata gbo ayi fatin ma, saraxaraliin xa a fala na kanna ma, a mi sariɲanxi. Fure ɲaxina nde na a ra. ");
INSERT INTO yal_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Koni xa furen funfun mi masaraxi a mi gboxi ayi, nayi larun nan tun a ra. Saraxaraliin xa a fala na kanna ma a sariɲanxi.” ");
INSERT INTO yal_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Xa muxuna nde fatin ganxi, xa furen dɛɛn fixa hanma a gbeeli, ");
INSERT INTO yal_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","saraxaraliin xa a mato. Xa a fati ma xabene fixa, furen dɛɛn tilin, fure ɲaxina nde nan na ra, naxan bata mini ganden ma. Nayi, saraxaraliin xa a fala na kanna ma a mi sariɲanxi bayo fure ɲaxin na a ra. ");
INSERT INTO yal_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Koni a na a mato, xa saraxaraliin mi fati ma xabe fixɛ to furen yɛ, a dɛɛn mi tilin, a bata xara, saraxaraliin xa na kanna lu a danna xunsagi keden. ");
INSERT INTO yal_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Saraxaraliin xa a mato xii soloferede lɔxɔni. Xa furen bata gbo ayi a fatin ma, saraxaraliin xa a fala na kanna ma, a mi sariɲanxi. Fure ɲaxin na a ra. ");
INSERT INTO yal_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Koni xa furen mi masaraxi, a mi gboxi ayi, a bata xara, gande funfun nan na ra. Saraxaraliin xa a fala, a na kanna sariɲanxi. Gande larun nan na ra.” ");
INSERT INTO yal_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Xa furen lu xɛmɛna nde hanma ɲaxanla nde xunna ma hanma a kenkenna ma, ");
INSERT INTO yal_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","saraxaraliin xa furen mato. Xa a tilin, a xunsɛxɛn hanma a dɛ xaben gbeeli, a xunxurun, saraxaraliin xa a fala na kanna ma, a mi sariɲanxi. Fure ɲaxin na a ra, daxana, naxan a suxi a xunna ma hanma a kenkenna ma. ");
INSERT INTO yal_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Xa saraxaralina a to furen mi tilin, koni a xunsɛxɛ fɔrɛ munma mini, furemaan xa lu a danna xii solofere. ");
INSERT INTO yal_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Saraxaraliin xa a furen mato xii soloferede lɔxɔni. Xa daxaan mi gboxi ayi, a mi tilin, a xunsɛxɛn mi gbeeli, ");
INSERT INTO yal_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","na kanna xa a xunna bi, fɔ furen dɛnaxan ma. Saraxaraliin mɔn xa a lu a danna xunsagi keden. ");
INSERT INTO yal_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Saraxaraliin xa daxaan mato xii soloferede lɔxɔni. Xa a mi gboxi ayi, a mi tilin, saraxaraliin xa a fala na kanna ma, a a sariɲanxi. A xa a dugine xa, a sariɲanma nɛn. ");
INSERT INTO yal_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Koni xa daxaan gbo ayi fatin ma, saraxaraliin yelin xanbini a falɛ a a sariɲanxi, ");
INSERT INTO yal_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","saraxaraliin xa a mato. Xa daxaan bata gbo ayi, hali saraxaraliin mi fa a xunsɛxɛn mato, a mi sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Koni xa a mi gboxi ayi, xa fati ma xabe fɔrɛne bata mini, daxaan bata yalan. A bata sariɲan. Saraxaraliin xa a fala, a sariɲanxi.” ");
INSERT INTO yal_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Xɛmɛna hanma ɲaxanla, xa fixɛ fixɛne a fatin ma, ");
INSERT INTO yal_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","saraxaraliin xa a mato. Xa e mi mɔxi, gasin nan tun na ra. A sariɲan.” ");
INSERT INTO yal_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Xa muxuna nde xun sɛxɛ mi na, teeli kanna na a ra, a sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Xa xunsɛxɛ mi a tigi ra, teeli kanna na a ra, a sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Koni xa furena a teeli hanma a tigi ra naxan fixa hanma a gbeeli, fure ɲaxin nan minixi a ma. ");
INSERT INTO yal_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Saraxaraliin xa a mato. Xa a kusinden to teeli hanma a tigi ra naxan fixa hanma a gbeeli alo fure ɲaxin kii naxan yi, ");
INSERT INTO yal_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","furemaan nan na kanna ra, a mi sariɲanxi. Saraxaraliin xa a fala, a mi sariɲanxi bayo furena a xunna ma.” ");
INSERT INTO yal_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Awa, xa fure ɲaxin naxan ma, na kanna xa dugi yibɔxine ragodo a ma, a xunni tɔntaren yi lu, a a dɛɛn yɛ maluxun, a yi gbelegbele. Sariɲantarena! Sariɲantarena! ");
INSERT INTO yal_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Furen nɛma a ma, a mi sariɲanxi. Nayi, a lan a lu a danna, a xa lu yamaan daaxaden fari ma.” ");
INSERT INTO yal_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Xa dugina nde bata fundu, xuruse xabe dugina hanma taa dugina, ");
INSERT INTO yal_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","a na findi dugi sɔxɔnxin sifa yo ra hanma xuruse xabe dugine hanma se kidine, ");
INSERT INTO yal_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","xa funduden fɔrɔ hanma a gbeeli dugin ma hanma kidin ma hanma dugi sɔxɔnxin ma hanma se kidina nde ma, funɛ ɲaxin na a ra naxan seen kalama. Saraxaraliin xa a mato. ");
INSERT INTO yal_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Funɛn seen naxan ma, saraxaraliin xa na ramara matoni xii solofere. ");
INSERT INTO yal_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Xii soloferede lɔxɔni saraxaraliin xa a mato. Xa funɛn bata gbo ayi na dugin ma hanma dugi sɔxɔnxin ma, hanma se kidin ma, a na rawali kii yo yi, funɛ ɲaxin nan na ra naxan seen kalama, na seen xɔsixi. ");
INSERT INTO yal_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Nayi, saraxaraliin xa na dugin gan, hanma dugi sɔxɔnxina hanma xuruse xabe dugina hanma se kidina, funɛ funfun naxan ma. Amasɔtɔ funɛ ɲaxin na a ra naxan seen kalama. Na seen xa gan. ");
INSERT INTO yal_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Koni xa saraxaralina a mato, xa funɛn mi gboxi ayi na seen ma, ");
INSERT INTO yal_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","funɛn naxan ma, a xa yamarin fi e ma, a e xa na dugin xa. A mɔn yi a ramara xii solofere. ");
INSERT INTO yal_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","E na a xa, saraxaraliin mɔn xa a mato. Xa a to funɛn mi maxɛtɛxi, a mi gboxi ayi, na seen xɔsixi. Xa funɛn bata dugin suxu a yɛ faɲin ma hanma a yɛ ɲaxin ma, a gan daxin na a ra. ");
INSERT INTO yal_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Xa saraxaralina a to funɛn bata ba fɔlɔ, dugin xa xanbini, a xa na funɛ yiren bɔ dugin na, hanma kidina, hanma dugi sɔxɔnxina. ");
INSERT INTO yal_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Koni, xa a mɔn sa dugi sɔxɔnxin suxu hanma se kidina, funɛn nan na ra naxan seen kalama. Nayi, funɛn seen naxan ma, na xa gan. ");
INSERT INTO yal_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Funɛn seen naxan suxi, dugina, hanma dugi sɔxɔnxina, hanma se kidina, koni funɛn funfun bata lɔ ayi, na mɔn xa xa alogo a xa sariɲan.” ");
INSERT INTO yal_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Funɛn bata xuruse xabe dugin naxan suxu hanma taa dugina, hanma dugi gbɛtɛ, hanma se kidina, sariyan nan na ra ne fe yi naxan a yitama a e sariɲan hanma e mi sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Fure ɲaxin muxun naxan ma, na rasariɲanma ikiini: A xa a yita saraxaraliin na. ");
INSERT INTO yal_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Nayi, saraxaraliin xa mini yamaan daaxaden fari ma na kanna matodeni. Xa furemaan bata yiyalan, ");
INSERT INTO yal_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","saraxaraliin xa yamarin fi, e xa fa xɔli ɲɛɲɛ radaxaxi firin na, e nun suman wudin nun gari gbeela nun hisopi wudi yiina nde. ");
INSERT INTO yal_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Saraxaraliin xa yamarin fi, a e xa xɔliin keden kɔɛ raxaba fɛɲɛna nde xun ma, tigi igen naxan kui. ");
INSERT INTO yal_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","A xa xɔli ɲɛɲɛn tongo, e nun suman wudin nun gari gbeela nun hisopi wudi yiina, a yi e rafu xɔliin kɔɛ raxabaxin wunli. ");
INSERT INTO yal_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","A yi a xuya na kanna ma sanɲa ma solofere naxan nasariɲanma fure ɲaxin ma. A yi a fala na kanna ma a a bata sariɲan. A yi xɔli ɲɛɲɛn beɲin burunna ra.” ");
INSERT INTO yal_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Naxan nasariɲanma, na kanna xa a dugine xa, a a fati ma xabene bi, a yi a maxa. Na xanbi ra, a sariɲanma nɛn. Nayi, a nɔɛ soɛ nɛn yamaan daaxadeni, koni a luma nɛn a bubun fari ma xii solofere. ");
INSERT INTO yal_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Xii soloferede lɔxɔni, a mɔn yi a xunsɛxɛne bi, e nun a dɛ xabene, a yɛ gilingilinna xabene, e nun a fati ma xabene birin. A mɔn yi a dugine xa, a a fatin maxa. Na xanbi ra, a sariɲanma nɛn. ");
INSERT INTO yal_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Xii solomasɛxɛdeni, a xa konton firin tongo e nun yɛxɛɛ gilɛna, ɲɛɛ keden kedenne, fɛ mi naxanye ra. A mɔn xa murutu fuɲi faɲin kilo solomanaanin tongo bogise saraxan na turen naxan yi, a turen litiri tagin sa a fari. ");
INSERT INTO yal_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Saraxaraliin naxan na kanna rasariɲanma, na xa e nun a kiseene ti Alatala yɛtagi Naralan Bubun dɛ ra. ");
INSERT INTO yal_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","A xa konton keden tongo, a a ba yangin saraxan na, e nun turen litiri tagi. A xa ne yita Alatala ra saraxa ralixin na. ");
INSERT INTO yal_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","A xa a kontonna kɔɛ raxaba na yire sariɲanxini muxune yulubi xafari saraxane nun saraxa gan daxine kɔɛ raxabama dɛnaxan yi. Saraxaraliin nan gbee yangin saraxan na alo yulubi xafari saraxana. A sariɲan han! ");
INSERT INTO yal_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Saraxaraliin xa yangin saraxan wunla nde tongo, a yi a sa na kanna yiifari ma tunla ma, e nun a yiifari ma yii konkoribaan nun a yiifari ma san konkoribana. ");
INSERT INTO yal_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Na xanbi ra, a mɔn xa saraxa turena nde tongo, a yi a sa a yɛtɛɛn kɔmɛn ma yiini. ");
INSERT INTO yal_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","A xa a yiifari ma yii soli keden sin tureni, a yi a xuya Alatala yɛtagi dɔxɔɲa ma solofere. ");
INSERT INTO yal_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","A mɔn yi ndedi sa na kanna yiifari ma tunla ma, e nun a yiifari ma yii konkoribaan nun a yiifari ma san konkoribana. A yangin saraxan wunla saxi dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ture dɔnxɛn naxan luxi saraxaraliin yii, a xa na sa na kanna xunni, saraxaraliin yi Alatala solona a xa. ");
INSERT INTO yal_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Saraxaraliin xa yulubi xafari saraxan ba, a Ala solona na kanna xa naxan nasariɲanma. Na xanbi ra, a yi saraxa gan daxin kɔɛ raxaba. ");
INSERT INTO yal_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","A yi saraxa gan daxin nun bogise saraxan nali saraxa ganden fari. A yi Ala solona na kanna xa, a yi sariɲan.” ");
INSERT INTO yal_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Xa yiigelitɔɔn nan na kanna ra, a mi nɔɛ saraxane sɔtɛ, a xa konton keden tongo yangin saraxan na, naxan yitama Ala ra solona seen na a xa, e nun murutu fuɲi faɲin bogise saraxan kilo saxan, turen naxan yi, e nun turen litiri tagi, ");
INSERT INTO yal_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","e nun ganba firin hanma kolokonde dii firin, a nɔɛ naxan sɔtɛ. Keden xa findi yulubi xafari saraxan na, bonna saraxa gan daxina. ");
INSERT INTO yal_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Xii solomasɛxɛde lɔxɔni, a xa fa e ra saraxaraliin fɛma Naralan Bubun dɛɛn na Alatala yɛtagi alogo a xa rasariɲan. ");
INSERT INTO yal_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Saraxaraliin xa yangin saraxa yɛxɛɛn nun turen litiri tagin tongo, a yi e yita Alatala ra saraxa ralixin na. ");
INSERT INTO yal_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","A xa yɛxɛɛn kɔɛ raxaba yangin saraxan na. A yi a wunla nde tongo, a a sa na kanna yiifari ma tunla nun a yiifari ma yiin konkoribaan nun a yiifari ma san konkoribaan ma. ");
INSERT INTO yal_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","A yi turena nde sa a yɛtɛɛn kɔmɛn ma yiini. ");
INSERT INTO yal_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","A xa na turena nde xuya Alatala yɛtagi a yiifari ma yii sonla ra sanɲa ma solofere. ");
INSERT INTO yal_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Turen naxan a yiin kui, a xa na ndedi tongo, a yi a sa na kanna yiifari ma tunla ma, e nun a yiifari ma yii konkoribaan nun a yiifari ma san konkoribana. A bata yi yangin saraxan wunla sa dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Turen naxan luxi a yiin kui, a xa na sa na kanna xunni, a yi Alatala solona a xa. ");
INSERT INTO yal_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Saraxaraliin xa ganba keden tongo hanma kolokonde diina, na kanna naxan sɔtɔxi, ");
INSERT INTO yal_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","a yi a ba yulubi xafari saraxan na, a yi xɔliin boden ba saraxa gan daxin na, e nun bogise saraxana. Nayi, a yi Alatala solona na kanna xa.” ");
INSERT INTO yal_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Sariyan nan na ra na kanna xa, fure ɲaxin naxan fatin ma, naxan mi nɔɛ saraxa kamalixin sɔtɛ. ");
INSERT INTO yal_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Alatala yi a fala Musa nun Haruna xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Ɛ na so Kanan yamanani, n naxan soma ɛ yii ɛ kɛɛn na, xa n funɛn sa banxina nde ma na yamanani, ");
INSERT INTO yal_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","banxi kanna xa sa a fala saraxaraliin xa, a naxa, ‘N bata funɛn to n ma banxin ma.’ ");
INSERT INTO yal_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Saraxaraliin xa yamarin fi, a e xa seene ramini banxini benun a xa siga funɛn matodeni, alogo sese nama lu banxini a yi yatɛ se xɔsixin na. Na xanbi ra, saraxaraliin xa so banxini a matodeni.” ");
INSERT INTO yal_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","“A xa funɛn mato. Xa funɛn fɔrɔ hanma a gbeeli, xa yilidine banxin ma, ");
INSERT INTO yal_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","saraxaraliin xa mini banxini, a banxin dɛɛn balan xunsagi keden. ");
INSERT INTO yal_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Xii soloferede lɔxɔni, saraxaraliin mɔn xa fa a mato. Xa funɛn bata gbo ayi banxi ma, ");
INSERT INTO yal_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","saraxaraliin xa yamarin fi, a funɛn gɛmɛn naxanye ma, e xa ne ba na, e yi e woli yirena nde yi taan fari ma naxan mi sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","A xa banxin kuiin birin maxɔlin, e yi a lɔxɔn woli ayi yirena nde yi taan fari ma naxan mi sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Na xanbi ra, e xa gɛmɛ gbɛtɛye tongo. E yi na gɛmɛne masara. E maso se gbɛtɛ tongo, e mɔn yi banxin maso.” ");
INSERT INTO yal_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“E na a gɛmɛ kalaxine ba na, e banxin maxɔlin, a kankene mɔn yi maso, xa funɛn mɔn mini banxin ma, ");
INSERT INTO yal_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","saraxaraliin xa sa a mato. Xa a to funɛn bata gbo ayi banxini, na nan na ra funɛ ɲaxin na a ra naxan seen kalama. Banxin mi sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Banxin xa rabira, a gɛmɛne nun a wudine nun a maso bɛndɛne yi maxali taan fari ma yirena nde yi naxan mi sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Naxan yo na so banxini a balanxi lɔxɔn naxanye yi, na mi fa sariɲanxi han ɲinbanna ra. ");
INSERT INTO yal_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Naxan na a sa hanma a a dɛge na banxini, a xa a dugine xa.” ");
INSERT INTO yal_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Xa saraxaralina a mato, funɛn mi gboxi ayi banxin ma a maso xanbini, a xa a fala a banxin bata sariɲan, amasɔtɔ funɛn bata ɲan na.” ");
INSERT INTO yal_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","“Na kanna xa xɔli firin tongo e nun suman wudina nde nun gari gbeela nun hisopi wudi yiina nde. ");
INSERT INTO yal_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","A xa xɔliin keden kɔɛ raxaba fɛɲɛna nde xun ma tigi igen naxan kui. ");
INSERT INTO yal_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","A yi suman wudin tongo, e nun hisopi wudi yiin nun gari gbeela e nun xɔli ɲɛɲɛna, a ne sin xɔli kɔɛ raxabaxin wunla nun tigi igeni. A yi a xuya banxin ma sanɲa ma solofere. ");
INSERT INTO yal_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","A yi banxin nasariɲan xɔliin wunla ra, e nun tigi igen nun xɔli ɲɛɲɛn nun suman wudin nun hisopi wudina e nun gari gbeela. ");
INSERT INTO yal_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","A xa xɔli ɲɛɲɛn beɲin taan fari ma burunna ra. Nayi, na banxina fe ɲaxin bata ɲan, a yi sariɲan.” ");
INSERT INTO yal_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Sariyane nan ne ra fure ɲaxine fe yi hanma daxana naxanye minin muxun fatin ma, ");
INSERT INTO yal_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","e nun funɛn naxan minin dugin ma hanma banxin ma, ");
INSERT INTO yal_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kusindene, gasine, e nun larune, ");
INSERT INTO yal_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","alogo a xa kolon xa sena nde sariɲan hanma xa a mi sariɲanxi. Sariyan na a ra fure ɲaxin nun funɛ ɲaxina fe yi. ");
INSERT INTO yal_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Alatala yi a fala Musa nun Haruna xa, ");
INSERT INTO yal_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","a e xa a fala Isirayila kaane xa, e naxa, “Xa furen xɛmɛna nde bari boden ma, faxunna naxan minima xɔsin nan na ra. ");
INSERT INTO yal_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Xa a minima hanma a mi tin minɛ, na faxunna bata na kanna xɔsi. ");
INSERT INTO yal_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Nayi, xɛmɛn na a sa saden naxan ma, na xɔsixi. A na dɔxɔ gbɛdɛn naxan ma, na xɔsixi. ");
INSERT INTO yal_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Naxan na a yiin din a saden na, na kanna xa a dugine xa, a yi a maxa. A mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Furemaan bata dɔxɔ gbɛdɛn naxan ma, naxan yo dɔxɔ na ma, na kanna lan a a dugine xa, a yi a maxa, a mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Naxan na a yiin din furemaan na, na kanna lan a xa a dugine xa, a yi a maxa. A mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Xa furemaan dɛ igen namini muxu sariɲanxina nde ma, na kanna lan a a dugine xa, a yi a maxa. A mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Furemaan na dɔxɔ sese fari a siga sigatini, na mi fa sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Furemaan bata dɔxɔ sese ma, naxan yo na a yiin din na ra, na kanna mi fa sariɲanxi han ɲinbanna. Naxan yo na se sifan tongo, na kanna lan a a dugine xa, a yi a maxa, a mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Xa furemaan mi a yiin naxa, a na a yiin din muxu yo ra, na kanna lan a a dugine xa, a yi a maxa. A mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Furemaan na a yiin din fɛɲɛ yo ra, na lan a kala. Xa goronna wudi daxin na a ra, a lan a maxa.” ");
INSERT INTO yal_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Furemaan na yiyalan, na kanna lan a legedenna ti xunsagi keden benun a xa rasariɲan. A xa a dugine xa, a yi a maxa tigi igen na. A sariɲanma nɛn na yi. ");
INSERT INTO yal_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Xii solomasɛxɛde lɔxɔni, a xa ganba firin tongo hanma kolokonde dii firin, a sa e so saraxaraliin yii Alatala yɛtagi Naralan Bubun dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Saraxaraliin xa xɔli keden ba yulubi xafari saraxan na, bonna saraxa gan daxina. Nayi, a yi na kanna rasariɲan Alatala yɛtagi faxunna ma naxan minixi a ma. ");
INSERT INTO yal_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Xa xɛmɛn bari bodeni igen mini, na kanna lan a a gbindin birin maxa, a mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Xa na ige sifan sa dugin ma hanma se kidin ma, na lan a maxa. A mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Xa xɛmɛn nun ɲaxanla kafu, e firinna birin lan e e maxa, e mi fa sariɲanxi han ɲinbanna.” ");
INSERT INTO yal_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Xa ɲaxanla a kike wanli, wunla minima a ma, a mi fa sariɲanxi xunsagi keden. Naxan na a yiin din a ra, a mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","A nɛma a kike wanli, xa a a sa saden ma hanma a dɔxɔ gbɛdɛn ma, na mi fa sariɲanxi. ");
INSERT INTO yal_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Naxan na a yiin din a saden na, na kanna lan a a dugine xa, a yi a maxa, a mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","A na dɔxɔ gbɛdɛn naxan ma, naxan na a yiin din na ra, na kanna lan a a dugine xa, a yi a maxa, a mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Xa sena nde saxi na saden ma hanma gbɛdɛn ma, a yi dɔxi naxan ma, naxan yo na a yiin din na seen na, a mi fa sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Xa e nun xɛmɛna nde kafu, a wunla yi sa xɛmɛn ma, a fan mi sariɲanxi xunsagi keden. A na a sa sade yo ma na xɔsixi.” ");
INSERT INTO yal_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Xa wunla lu minɛ ɲaxanla ma, naxan mi findixi a kike wanla ra, hanma a kike wali waxatin yi xɔnkuya ayi, a mi fa sariɲanxi han wunla yi ɲan alo a nɛma a kike wanli. ");
INSERT INTO yal_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","A na a sa saden naxan ma hanma a dɔxɔ gbɛdɛn naxan ma, na mi sariɲanxi, alo a nɛma a kike wanli. ");
INSERT INTO yal_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Naxan na a yiin din na saden na hanma a dɔxɔ na gbɛdɛn ma, na kanna lan a a dugine xa, a yi a maxa, a mi sariɲanxi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Wuli minin na ɲan, na ɲaxanla lan a legedenna ti xunsagi keden, a sariɲanma nɛn na yi. ");
INSERT INTO yal_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Xii soloferede lɔxɔni, a xa ganba firin hanma kolokonde dii firin tongo, a e xali saraxaraliin fɛma Naralan Bubun dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Saraxaraliin xa xɔliin boden ba yulubi xafari saraxan na, bonna saraxa gan daxina. Na xanbi ra, ɲaxanla wuli minin xɔsin ɲanma nɛn Alatala yɛɛ ra yi.” ");
INSERT INTO yal_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Ɛ xa Isirayila kaane ratanga na feene ma naxanye e xɔsima, alogo e nama n batu bubun naxɔsi naxan e tagi, e yi faxa e xɔsina fe ra.” ");
INSERT INTO yal_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Sariyane nan ne ra feni itoe ma: faxunna na mini xɛmɛn bari boden ma, igen na mini xɛmɛn xɛmɛyani a yi a xɔsi, ");
INSERT INTO yal_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ɲaxanla nɛma a kike wanli, igena nde na mini xɛmɛn hanma ɲaxanla bari bodeni, e nun xɛmɛn naxan kafuma ɲaxanla ma a kike wali waxatini. ");
INSERT INTO yal_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Harunaa dii firinna naxanye siga Alatala yɛtagi, ne faxa xanbini, Alatala yi falan ti Musa xa. ");
INSERT INTO yal_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Alatala yi a fala Musa xa, a naxa, “A fala i tada Haruna xa, a a nama so yire sariɲanxi fisamantenni yɛ yo yɛ, yɛ masansan dugin xanbi ra Layiri Kankiraan yɛtagi, Ala solonama dɛnaxan yi. Xa a na liga, n minima a ma nɛn kundaan yiyani Layiri Kankiraan dɛraganla xun ma, a yi faxa.” ");
INSERT INTO yal_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Haruna xa feni itoe nan liga alogo a xa so yire sariɲanxi fisamantenni: A lan a tura bulanna ba yulubi xafari saraxan na, e nun kontonna saraxa gan daxin na. ");
INSERT INTO yal_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","A lan a yi taa dugi guba sariɲanxin nagodo a ma, a yi a taa dugi wantanna so. A xa a tagi xidi taa dugi tagixidin na, a yi taa dugi namun so. Na dugine sariɲan, nanara a lan a yi a maxa benun a xa e so. ");
INSERT INTO yal_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Isirayila yamaan lan e kɔtɔ firin so a yii yulubi xafari saraxan na, e nun konton keden saraxa gan daxin na. ");
INSERT INTO yal_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Haruna xa turaan ba a yɛtɛna yulubi xafari saraxan na alogo a xa Ala solona a yɛtɛ xa e nun a denbayana. ");
INSERT INTO yal_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Na xanbi ra, a yi kɔtɔ firinne xali Alatala yɛtagi, Naralan Bubun dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","A xa kɔtɔne masɛnsɛn alogo a xa a kolon naxan lan a findi Alatala gbeen na e nun naxan sigan yire ɲaxini. ");
INSERT INTO yal_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Masɛnsɛnna na kɔtɔn naxan suxu Alatala gbeen na, Haruna xa fa na ra, a a ba yulubi xafari saraxan na. ");
INSERT INTO yal_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Masɛnsɛnna na kɔtɔn naxan suxu yire ɲaxin gbeen na, a ɲɛɲɛn nan nalima Alatala ma a solona seen na, e sa a beɲin yire ɲaxini burunna ra. ");
INSERT INTO yal_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Haruna xa fa turaan na, a a ba a yɛtɛna yulubi xafari saraxan na, a Ala solona a yɛtɛ xa e nun a denbayana. A xa na turaan kɔɛ raxaba a yɛtɛna yulubi xafari saraxan na. ");
INSERT INTO yal_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","A xa tɛɛ kɔ seen nafe tɛɛ wolonna ra naxan tongoxi saraxa ganden fari Alatala yɛtagi. A yi wusulan fuɲin yiin yɛ firin tongo, a yi e xali yɛ masansan dugin xanbi ra, yire sariɲanxi fisamantenni. ");
INSERT INTO yal_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","A xa wusulanna sa tɛɛn na Alatala yɛtagi, alogo tutin naxan tema, na xa Layiri Kankiraan dɛraganla luxun alogo a nama faxa. ");
INSERT INTO yal_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","A xa turaan wunla nde tongo a yii sonla ra, a yi a xuya Layiri Kankiraan dɛraganla yɛtagin ma. A mɔn yi a xuya Layiri Kankiraan yɛtagi dɔxɔɲa ma solofere. ");
INSERT INTO yal_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Na xanbi ra, a xa kɔtɔn kɔɛ raxaba yamaan yulubi xafari saraxan na, a yi a wunla xali yɛ masansan dugin xanbi ra, a yi a liga alo turaan wunla, a a xuya Layiri Kankiraan ma e nun a yɛtagi.” ");
INSERT INTO yal_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","“Na kiini, a xa Ala solona yire sariɲanxi fisamantenna xa alogo a xa rasariɲan Isirayila kaane xɔsi feene nun e murutɛ feene nun e yulubine birin ma. A mɔn xa a liga na kiini Naralan Bubun xa, naxan tixi Isirayila kaa xɔsixine tagi. ");
INSERT INTO yal_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Muxu yo nama lu Naralan Bubun kui a na so Ala solonadeni yire sariɲanxi fisamantenni, han a yi mini. A xa Ala solona a yɛtɛɛn xa e nun a denbayaan nun Isirayila yamaan birin.” ");
INSERT INTO yal_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Na xanbi ra, a yi mini, siga saraxa ganden yireni dɛnaxan Alatala yɛtagi. A yi na fan nasariɲan, a turaan nun kɔtɔn wunla sa saraxa ganden tongonna fenne birin ma. ");
INSERT INTO yal_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","A xa wunla xuya a yii sonla ra dɔxɔ solofere saraxa ganden ma, alogo a xa a rasariɲan Isirayila kaane xɔsine ma.” ");
INSERT INTO yal_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Haruna na yelin xɔsine bɛ yire sariɲanxi fisamantenna ma, e nun Naralan Bubuna, e nun saraxa gandena, a xa kɔtɔ ɲɛɲɛn fan maso. ");
INSERT INTO yal_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Haruna xa a yii firinne sa kɔtɔ ɲɛɲɛn xunna fari, a yi Isirayila kaane hakɛne nun murutɛ feene nun yulubine birin fala a ma, a yi e sa kɔtɔn xunna fari. A yi muxuna nde xɛ, alogo a xa sa kɔtɔn beɲin burunna ra, ");
INSERT INTO yal_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","a yi e hakɛne birin xali wulani. A xa kɔtɔn kedi, a siga burunna ra.” ");
INSERT INTO yal_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Na xanbi ra, Haruna xa so Naralan Bubun kui, a yi taa dugine ba a ma, a naxanye so benun a xa so yire sariɲanxini. A xa ne lu na. ");
INSERT INTO yal_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","A xa a maxa yire sariɲanxina nde yi, a yi a dugin bonne ragodo a ma. Na xanbi ra, a xa sa saraxa gan daxi firinna bonne ba a yɛtɛ xa e nun yamaan xa, a Ala solona a yɛtɛ xa e nun yamaan xa. ");
INSERT INTO yal_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","A mɔn xa yulubi xafari saraxan turene sa tɛɛni saraxa ganden fari.” ");
INSERT INTO yal_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Naxan kɔtɔn beɲinxi yire ɲaxini, na lan a yi a dugine xa, a yi a maxa, a fa fa yamaan daaxadeni. ");
INSERT INTO yal_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Turaan nun kɔtɔn naxanye baxi yulubi xafari saraxan na, naxanye wuli rawalixi yire sariɲanxini Ala solona seen na, ne lan e xali yamaan daaxaden fari ma, e kidine nun e suben nun e gbiine yi sa tɛɛni. ");
INSERT INTO yal_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Naxan na e gan, na lan a yi a dugine xa, a yi a maxa. Na xanbi ra, a yi so yamaan daaxadeni.” ");
INSERT INTO yal_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Habadan sariyan na a ra ɛ xa. Kike solofereden xii fuden lɔxɔni, ɛ xa sunna suxu, ɛ tan Isirayila kaane ba, xɔɲɛn naxanye dɔxi ɛ konni ba, ɛ xa wanla birin beɲin. ");
INSERT INTO yal_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Amasɔtɔ Ala solonama ɛ xa na lɔxɔn nin, alogo ɛ xa sariɲan. Nayi, ɛ sariɲanma nɛn ɛ yulubine birin ma Alatala yɛɛ ra yi. ");
INSERT INTO yal_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","A xa findi Matabu Lɔxɔn nun sanla ra. Ɛ xa sunna suxu na lɔxɔni. Habadan sariyan na a ra.” ");
INSERT INTO yal_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“Saraxaraliin naxan bata masusan a sugandi feen na, a dɔxɔ saraxaraliyani a baba funfuni, na nan Ala solonama. A tan nan taa dugi doma rasariɲanxine soma, ");
INSERT INTO yal_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","a Ala solona yire sariɲanxin nun Naralan Bubun nun saraxa ganden nun saraxaraline nun Isirayila yamaan birin xa. ");
INSERT INTO yal_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Habadan sariyan na a ra ɛ xa. Ala solonama Isirayila kaane yulubine birin ma fe ra lɔxɔ kedenni ɲɛɛn bun ma.” E yi a liga alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","a a xa a fala Haruna xa, e nun a diine nun Isirayila kaane birin, a naxa, “Alatala ito nan yamarixi. ");
INSERT INTO yal_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Isirayila kaan naxan na a ɲingen ba saraxan na, hanma yɛxɛɛna hanma siina, yamaan daaxadeni hanma a fari ma, ");
INSERT INTO yal_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","a mi a xali Naralan Bubun so dɛɛn na alogo a xa a rali Alatala ma kiseen na Alatala Batu Bubun yɛtagi, na kanna yatɛma nɛn alo faxa tiina. A bata wunla ramini, na kanna kedima nɛn a yamani. ");
INSERT INTO yal_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Na ma, Isirayila kaane bama nɛn saraxan bɛ burunna ra, e fa e saraxane ra saraxaraliin fɛma Alatala yɛtagi Naralan Bubun dɛɛn na, a yi e ba bɔɲɛ xunbeli saraxan na Alatala xa. ");
INSERT INTO yal_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Saraxaraliin xa a wunla xuya Alatalaa saraxa ganden dɛxɔnna ma Naralan Bubun dɛɛn na, a yi a turene sa tɛɛni, a xirin yi rafan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Nayi, Isirayila kaane nama fa suxure kɔtɔne ki, e tinxintareyaan liga Ala ra naxanye xɔn. Habadan sariyan na a ra e tan xa e nun e yixɛtɛne birin.” ");
INSERT INTO yal_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","A mɔn xa a fala, a naxa, “Isirayila kaan hanma xɔɲɛn naxan dɔxi e tagi, a na saraxa gan daxin ba hanma saraxa gbɛtɛ, ");
INSERT INTO yal_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","xa a mi a xali Naralan Bubun dɛɛn na alogo a xa ba Alatala xa, a kedima nɛn a yamaan yɛ.” ");
INSERT INTO yal_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Isirayila kaan hanma xɔɲɛn naxan dɔxi e tagi, naxan na wunla don, n kelima nɛn na kanna xili ma, n yi a kedi a yamaan yɛ. ");
INSERT INTO yal_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Amasɔtɔ fati bɛndɛn niina a wunla nin. N tan bata wunla findi n solona seen na ɛ niine xa, naxan sama saraxa ganden fari. Amasɔtɔ wunla nan n solonama bayo niina a yi. ");
INSERT INTO yal_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Nanara, n na falama ɛ tan Isirayila kaane xa, ɛ tan sese nama wunla don. Xɔɲɛ yo naxan dɔxi ɛ tagi, e nama wunla don. ");
INSERT INTO yal_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Isirayila kaan hanma xɔɲɛn naxan ɛ tagi, naxan na suben hanma xɔliin faxa donsoyani naxan daxa a don, a xa a wunla dindin bɔxɔni a bɛndɛn sa a yɛ ma. ");
INSERT INTO yal_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Amasɔtɔ suben birin niina a wunla nin. Nanara, n bata a fala Isirayila kaane xa, n naxa, ‘Ɛ nama sube yo wunla don, amasɔtɔ suben birin niina a wunla nin. Naxan yo a don, na kedima nɛn Isirayila yamani.’ ” ");
INSERT INTO yal_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Naxan na suben don naxan faxaxi a yɛtɛ ma hanma sube gbɛtɛ naxan faxaxi, a na findi Isirayila bari diin na hanma xɔɲɛna, na kanna lan a yi a dugine xa, a yi a maxa. A mi fa sariɲanxi han ɲinbanna, na xanbi ra a yi sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Xa a mi a dugine xa, xa a mi a maxa, a na hakɛn goronna tongoma nɛn.” ");
INSERT INTO yal_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","a xa ito nan fala Isirayila kaane xa, a naxa, “Alatala nan n tan na, ɛ Ala. ");
INSERT INTO yal_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ɛ nama Misiran kaane namunne liga, ɛ yi dɔxi dɛnaxan yi, hanma Kanan yamanan namunne, n na ɛ xalima dɛnaxan yi. Ɛ nama e namunne suxu de! ");
INSERT INTO yal_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ɛ xa n ma sariyane nun n ma tɔnne suxu bayo Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","“Ɛ xa n ma tɔnne nun n ma sariyane suxu bayo naxan na e suxu, na kanna nii rakisin sɔtɔma nɛn e xɔn. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Muxu yo nun a bari boden nama kafu. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“I nama i baba rayagi, ɛ nun i nga yi kafu. I nga na a ra. Ɛ nama kafu.” ");
INSERT INTO yal_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“Ɛ nun i baba ɲaxalan gbɛtɛ nama kafu, na i baba rayagɛ nɛn.” ");
INSERT INTO yal_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“Ɛ nun i magilɛn nama kafu, i baba dii tɛmɛna hanma i nga dii tɛmɛna, hali ɛ mi maxuruxi tande kedenna ma.” ");
INSERT INTO yal_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“Ɛ nun i mamandenna nama kafu i ya dii xɛmɛna dii tɛmɛna hanma i ya dii tɛmɛna dii tɛmɛna. Amasɔtɔ na i tan yagɛ nɛn.” ");
INSERT INTO yal_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“Ɛ nun i baba ɲaxalan gbɛtɛ a dii tɛmɛn nama kafu, a naxan barixi i baba ma. I magilɛn na a ra.” ");
INSERT INTO yal_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“Ɛ nun i baba magilɛn nama kafu. I baba bari boden na a ra.” ");
INSERT INTO yal_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“Ɛ nun i nga ngaxakeden ɲaxalanmaan nama kafu. I nga bari boden na a ra.” ");
INSERT INTO yal_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“I nama i baba ngaxakedenna rayagi. Ɛ nun a ɲaxanla yi kafu. I nga xurin na a ra.” ");
INSERT INTO yal_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“Ɛ nun i mamuxun nama kafu. I ya diina ɲaxanla na a ra. Ɛ nama kafu.” ");
INSERT INTO yal_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“Ɛ nun i ngaxakedenna ɲaxanla nama kafu. Na i ngaxakedenna rayagɛ nɛn.” ");
INSERT INTO yal_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“Ɛ nun ɲaxanla nde nama kafu, ɛ nun a dii tɛmɛn fan yi kafu. Ɛ nun a mamandenna nama kafu, a dii xɛmɛna dii tɛmɛna hanma a dii tɛmɛna dii tɛmɛna. I bari boden nan ne ra. Na mi daxa.” ");
INSERT INTO yal_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“I nama i ya ɲaxanla bari boden tongo i ya ɲaxanla ra, i ya ɲaxanla mɔn ɲɛɲɛ, alogo i nama yɛngɛn naso e tagi.” ");
INSERT INTO yal_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Ɛ nun ɲaxanla nama kafu a nɛma a kike wanli, amasɔtɔ a mi sariɲanxi.” ");
INSERT INTO yal_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“Ɛ nun i lanfana ɲaxanla nama kafu, i yi i yɛtɛ xɔsi a xɔn.” ");
INSERT INTO yal_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“I nama i ya dii yo ba saraxan na Mɔlɔkɔ suxure kideni, i yi i ya Ala xili kala. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Ɛ nun xɛmɛn nama kafu alo ɲaxanla. Xɔsi feen nan na ra.” ");
INSERT INTO yal_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“Ɛ nun suben nama kafu, i yi i yɛtɛ xɔsi a xɔn. Ɲaxanla nama a maso suben na e kafu. Fe haramuxin nan na ra.” ");
INSERT INTO yal_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Ɛ nama ɛ xɔsi na kɛwali yo xɔn. Amasɔtɔ n siyaan naxanye kedima ɛ yɛɛ ra, ne e yɛtɛ xɔsi na feene nan xɔn. ");
INSERT INTO yal_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","E kɛwanle bɔxɔ yɛtɛɛn xɔsi nɛn. Nanara, n yi e hakɛne saran e ra, bɔxɔn yi a mɛ e ra. ");
INSERT INTO yal_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Nayi, ɛ tan Isirayila kaane nun xɔɲɛn naxanye ɛ tagi, ɛ xa n ma tɔnne nun sariyane suxu. Ɛ nama xɔsi feni itoe liga de! ");
INSERT INTO yal_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Amasɔtɔ naxanye yi dɔxi bɔxɔni ito yi benun ɛ tan, ne yi feni itoe birin ligama, e bɔxɔn naxɔsi. ");
INSERT INTO yal_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Na bɔxɔn nama a mɛ ɛ fan na ɛ xɔsina fe ra, alo siyaan naxanye yi na benun ɛ tan. ");
INSERT INTO yal_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Nanara, naxan yo na xɔsi feni ito nde liga, na kedima nɛn a yamani. ");
INSERT INTO yal_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Ɛ xa n ma yamarine suxu, ɛ nama namun xɔsixi yo liga naxanye yi ligama mɛnni benun ɛ tan. Ɛ nama ɛ yɛtɛ xɔsi e xɔn. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","a xa ito fala Isirayila kaane xa, a naxa, “Ɛ xa sariɲan, amasɔtɔ n tan sariɲan, n tan, Alatala, ɛ Ala. ");
INSERT INTO yal_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Birin xa a nga nun a baba binya, a yi Matabu Lɔxɔne suxu. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Ɛ nama suxurene batu, ɛ nama wure raxulunxin nafala ala maligane ra. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Ɛ na bɔɲɛ xunbeli saraxan ba Alatala xa, ɛ xa a ba a faɲin na alogo a xa a rasuxu. ");
INSERT INTO yal_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Saraxan suben xa don a faxa lɔxɔni hanma na xɔtɔn bode. Naxan na lu han a xii saxande lɔxɔni, ɛ xa na sa tɛɛni. ");
INSERT INTO yal_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Xa ɛ nde don xii saxande lɔxɔni, na haramuxi, na mi rasuxuma. ");
INSERT INTO yal_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Naxan na a don, na a hakɛn goronna tongoma nɛn. Amasɔtɔ a bata Alatalaa se rasariɲanxin naharamu. Na kanna kedima nɛn a yamani.” ");
INSERT INTO yal_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Ɛ na malo xaban fɔlɔ, ɛ nama maala xaba han xɛɛn xɛdɛɛn xɔn. Ɛ nama tɔnsɔnne makentun naxanye na lu a xɔri ma. ");
INSERT INTO yal_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","I nama sansi bogi dɔnxɛne bolon langani, i nama xɔnne makɔ naxanye yolonxi. I xa ne lu yiigelitɔne nun xɔɲɛne xa. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Ɛ nama muɲan ti. Ɛ nama wulen fala. Ɛ nama ɛ bode yanfa. ");
INSERT INTO yal_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ɛ nama ɛ kɔlɔ n xinli wulen fari, amasɔtɔ i ya Ala nan xili kalama. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“I nama i muxun boden yii seene tongo yanfan xɔn, i yi a ɲaxankata. I nama walikɛɛn saranna ramara i konni han na xɔtɔn bode.” ");
INSERT INTO yal_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“I nama tuli xɔrin konbi, i nama sese sa danxutɔɔn yɛɛ ra naxan a rabirɛ, koni i xa gaxu Ala yɛɛ ra. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Ɛ nama tinxintareya liga kiti sadeni. I nama yiigelitɔɔn nafisa, i nama nafulu kanna rafisa, koni i xa i adamadi boden makiti tinxinni. ");
INSERT INTO yal_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","I nama i adamadi boden mafala yamaan tagi. I nama i adamadi boden tɔɲɛgɛ alogo a xa faxa. Alatala nan n tan na. ");
INSERT INTO yal_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","I nama i ngaxakedenna raɲaxu, koni i xa i adamadi boden maxadi, alogo i nama yulubin tongo a fe ra. ");
INSERT INTO yal_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","I nama i gbeen ɲɔxɔ. I nama yamaan muxuna nde fe xɔnnantenyaan namara i kui. I adamadi boden xanu alo i yɛtɛna. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Ɛ xa n ma tɔnne suxu. I nama sube siya firinne rakafu. I nama sansi siya firinna si xɛɛn ma. I nama gɛsɛ siya firinna dugi sɔxɔnxin so.” ");
INSERT INTO yal_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Xa xɛmɛna nde nun konyi gilɛna nde kafu, muxu gbɛtɛ naxan masuxi a ɲaxanla ra, naxan munma xunba hanma a xɔrɔya, e kala tixin saranma e ra nɛn. Koni e mi faxama, amasɔtɔ a munma yi xunba nɛn. ");
INSERT INTO yal_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Xɛmɛn lan a kontonna xali Alatala yɛtagi Naralan Bubun dɛɛn na a yangin saraxan na. ");
INSERT INTO yal_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Saraxaraliin xa yangin saraxa kontonna findi Alatala solona seen na a yulubi ligaxina fe ra, a yulubin yi xafari.” ");
INSERT INTO yal_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Ɛ na so na yamanani, n na ɛ xalima dɛnaxan yi, ɛ yi bogiseen siyaan birin si, ɛ xa tɔnna dɔxɔ e bogine ra. E haramuxi nɛn ɛ tan xa ɲɛɛ saxan, ɛ nama e don. ");
INSERT INTO yal_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ɲɛɛn naanindeni, bɔxɔn bogine birin nasariɲanma nɛn Alatala tantun seen na. ");
INSERT INTO yal_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ɲɛɛn suulundeni, ɛ nɔɛ e bogine donɲɛ nɛn. Nayi, ɛ bogi se sɔtɔxine sigan gbo ayi nɛn. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Ɛ nama sese don wunla naxan yi. Ɛ nama ɛ yiimato, ɛ nama kɔɛrayaan liga. ");
INSERT INTO yal_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ɛ nama ɛ xunna dɛ bi a radigilinxin na. I nama i dɛ xaben dɛxɔnne bi. ");
INSERT INTO yal_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ɛ nama ɛ fatin mabɔ faxa feen sunun taxamasenna ra. Ɛ nama taxaraan te ɛ fatin ma. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“I nama i ya dii tɛmɛn nayagi i a findi yalunden na, alogo yamanan nama bira yalunyaan fɔxɔ ra, a yi rafe fe ɲaxin na. ");
INSERT INTO yal_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ɛ xa Matabu Lɔxɔne suxu, ɛ yi n ma yire sariɲanxin binya. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Ɛ nama siga koron bɔnbɔne nun yiimatone fɛma, alogo e nama ɛ raxɔsi. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“I xa keli fonna bun binyeni. I xa fonne binya, i yi gaxu i ya Ala yɛɛ ra. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Xa xɔɲɛn fa dɔxɔ ɛ yamanani, ɛ nama ɲaxu a ra, ");
INSERT INTO yal_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","koni ɛ xa a yisuxu alo yamanan bari diina ɛ tagi. I xa a xanu alo i yɛtɛna, amasɔtɔ ɛ findi xɔɲɛn na nɛn Misiran yamanani. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Ɛ nama tinxintareya liga kiti sadeni, hanma se maligadeni, hanma se binyeni ligadeni, hanma se yiligadeni. ");
INSERT INTO yal_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ɛ sikeela xa tinxin. Ɛ nɛma sese maligɛ, ɛ xa ligase kamalixin nawali. Alatala nan n tan na, ɛ Ala, naxan ɛ ramini Misiran yamanani.” ");
INSERT INTO yal_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Ɛ xa n ma tɔnne nun sariyane birin suxu. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Alatala yi a fala Musa xa ");
INSERT INTO yal_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","a a xa a fala Isirayila kaane xa, a naxa, “Isirayila kaan hanma xɔɲɛn naxan dɔxi Isirayila bɔxɔni, xa na nde a diin ba saraxan na Mɔlɔkɔ suxure kideni, yamaan xa a magɔlɔn a faxa. ");
INSERT INTO yal_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","N tan yɛtɛɛn kelima nɛn a xili ma, n yi a ba Isirayila yamaan yɛ. Amasɔtɔ a to a diin ba saraxan na Mɔlɔkɔ suxuren xa, a bata n ma yire sariɲanxin naxɔsi, a yi n xili sariɲanxin kala. ");
INSERT INTO yal_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Xa yamaan bata e yɛɛne raxi na feen ma, e tondi na kanna faxɛ, naxan a diin baxi saraxan na Mɔlɔkɔ xa, ");
INSERT INTO yal_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","n tan yɛtɛɛn kelima nɛn a xili ma e nun a denbayana. N na a kedima nɛn Isirayila yamani e nun naxanye birin biraxi a fɔxɔ ra e n yanfa Mɔlɔkɔ suxure kideni.” ");
INSERT INTO yal_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Xa muxuna nde n yanfa, a bira koron bɔnbɔne nun yiimatone fɔxɔ ra, n kelima nɛn a xili ma, n yi a kedi a yamani. ");
INSERT INTO yal_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ɛ xa ɛ yɛtɛ suxu sariɲanni, alogo ɛ xa sariɲan amasɔtɔ Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","“Ɛ xa n ma tɔnne suxu, ɛ yi e liga. Alatala nan n tan na, naxan ɛ rasariɲanma.” ");
INSERT INTO yal_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Naxan yo na a baba danga hanma a nga, ɛ na kanna faxa. A tan nan a faxa feen nagidixi, bayo a bata a baba danga hanma a nga.” ");
INSERT INTO yal_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Xa xɛmɛna nde yalunya liga e nun xɛmɛ gbɛtɛ a ɲaxanla, a lanfana ɲaxanla, ɛ xa xɛmɛ yalunxin nun ɲaxalan yalunxin firinne birin faxa.” ");
INSERT INTO yal_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“Xa xɛmɛna nde nun a baba ɲaxanla kafu, a bata a baba rayagi. Ɛ xa xɛmɛn nun ɲaxanla firinne birin faxa. E tan yɛtɛɛn nan e faxa feen nagidixi. ");
INSERT INTO yal_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Xa xɛmɛna nde nun a mamuxun kafu, ɛ xa e firinne birin faxa. Amasɔtɔ e bata fe ɲaxin liga. E tan nan e faxa feen nagidixi.” ");
INSERT INTO yal_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“Xa xɛmɛna nde kafu xɛmɛn ma alo muxun kafun ɲaxanla ma kii naxan yi, e firinna birin bata xɔsi feen liga. Ɛ xa e firinna birin faxa. E tan nan e faxa feen nagidixi.” ");
INSERT INTO yal_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“Xa xɛmɛna nde dii tɛmɛ nun a nga fen a ɲaxanla ra, fe ɲaxin nan na ra. Xɛmɛn nun ɲaxanle birin xa gan, alogo na fe ɲaxin nama lu ɛ tagi.” ");
INSERT INTO yal_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“Xa xɛmɛna nde kafu suben ma, ɛ xa a faxa, ɛ yi suben faxa.” ");
INSERT INTO yal_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“Xa ɲaxanla nde a maso suben na e yi kafu, ɛ xa ɲaxanla nun suben faxa. E xa faxa, e tan nan e faxa feen nagidixi.” ");
INSERT INTO yal_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Xa muxuna nde a magilɛn tongo a ɲaxanla ra, a baba a dii tɛmɛna hanma a nga a dii tɛmɛna, e yi kafu, yagin nan na ra. E xa kedi yamaan yɛ. Xɛmɛn bata kafu a magilɛn ma, a tan nan a hakɛn goronna tongoma.” ");
INSERT INTO yal_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“Xa xɛmɛna nde kafu ɲaxanla ma a nɛma a kike wanli, e firinne birin xa kedi yamani bayo e lanxi e yagi feen ma nɛn.” ");
INSERT INTO yal_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Ɛ nun i nga ngaxakedenna hanma i tɛnɛn nama kafu, bayo na i bari boden nayagima nɛn. Ɛ firinna birin ɛ hakɛn goronna tongoma nɛn.” ");
INSERT INTO yal_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“Xa xɛmɛna nde nun a sɔxɔ ɲaxanla kafu, a bata a sɔxɔ rayagi. E firinna nan e hakɛn goronna tongoma, e faxama nɛn e mi dii bari.” ");
INSERT INTO yal_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“Xa xɛmɛna nde a ngaxakedenna ɲaxanla tongo a ɲaxanla ra, xɔsin nan na ra. A bata a ngaxakedenna rayagi. E mi dii barima.” ");
INSERT INTO yal_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Ɛ xa n ma tɔnne nun n ma sariyane birin suxu, ɛ yi e liga, alogo na bɔxɔn nama a mɛ ɛ ra, n na ɛ xalima bɔxɔn naxan yi dɔxɔdeni. ");
INSERT INTO yal_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","N siyaan naxanye kedima ɛ yɛɛ ra, ɛ nama bira ne namunne fɔxɔ ra. Amasɔtɔ e feni itoe birin ligaxi nɛn e yi raɲaxu n ma. ");
INSERT INTO yal_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Koni n na a fala nɛn ɛ xa, n naxa, ‘E bɔxɔn soma ɛ tan nan yii. N na bɔxɔn fima ɛ ma nɛn ɛ kɛɛn na, kumin nun nɔnɔn gbo dɛnaxan yi.’ Alatala nan n tan na, ɛ Ala, naxan ɛ sugandixi siyane tagi. ");
INSERT INTO yal_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Nanara, ɛ xa sube haramuxine nun sube daxaxine tagi raba, e nun xɔli haramuxine nun a daxaxine. Ɛ nama ɛ yɛtɛ xɔsi subeni itoe xɔn, hanma xɔline xɔn, hanma niimaseen naxanye e masigama bɔxɔn ma, n tɔnna saxi naxanye ra a e haramuxi.” ");
INSERT INTO yal_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","“Nayi, ɛ findima n ma yama sariɲanxin na nɛn, amasɔtɔ n tan Alatala sariɲan. N bata ɛ sugandi siyane tagi, alogo ɛ xa findi n gbeen na.” ");
INSERT INTO yal_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Xɛmɛn hanma ɲaxanla naxan ɛ tagi, xa a findi koron bɔnbɔn na hanma yiimatoon na, ɛ xa a magɔlɔn a faxa. A tan nan a faxa feen nagidixi.” ");
INSERT INTO yal_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Alatala yi a fala Musa xa, a a xa a fala saraxaraline xa, Harunaa diine, a naxa, “Saraxaraliin nama a yɛtɛ xɔsi a muxuna nde ɲandeni, a a maso a binbin na. ");
INSERT INTO yal_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Fɔ a muxu kɛndɛne alo itoe: a nga, a baba, a diina, a dii tɛmɛna, a tada hanma a xunyɛna, ");
INSERT INTO yal_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","hanma a magilɛn naxan munma futu, naxan dɔxi a konni bayo xɛmɛn mi a yii. A nɔɛ a yɛtɛ xɔsɛ nɛn e ɲandeni. ");
INSERT INTO yal_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Koni, saraxaraliin naxan tixi yamaan yɛɛ ra, na nama a yɛtɛ xɔsi, a yɛtɛ rayagi. ");
INSERT INTO yal_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Xa sayaan ti, saraxaraline mi lan e e xunne bi, hanma e e dɛ xabene dɛxɔn bi, hanma e e fatin mabɔ. ");
INSERT INTO yal_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","E xa sariɲan e Ala yɛtagi, e nama e Ala xili kala, amasɔtɔ e tan nan saraxane ralima Alatala ma tɛɛn na, naxanye luxi alo e Ala donsena. Nayi, e xa sariɲan. ");
INSERT INTO yal_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","E nama yalunden futu hanma ɲaxanla naxan xɛmɛ feen kolon hanma ɲaxanla naxan ma xɛmɛ a mɛxi a ra. Amasɔtɔ e rasariɲanxin na a ra Ala xa. ");
INSERT INTO yal_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","I xa a yatɛ muxu sariɲanxin na, amasɔtɔ a tan nan saraxane fima Ala ma naxanye luxi alo a donsena. Nanara, ɛ xa a kolon a sariɲan, amasɔtɔ n tan Alatala sariɲan, n tan nan ɛ rasariɲanma. ");
INSERT INTO yal_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Xa saraxaralina diina nde a yɛtɛ rayagi a findi yalunden na, a a baba nan nayagixi. A xa gan.” ");
INSERT INTO yal_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Saraxarali kuntigin naxan bata masusan, a sugandi a ngaxakedenne tagi alogo a xa nɔ dugi rasariɲanxine sodeni, na nama a xunsɛxɛn lu a yitɔntaren na hanma a yi a dugine yibɔ ɲandeni. ");
INSERT INTO yal_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","A nama so binbin xun ma. A nama a yɛtɛ xɔsi hali a baba na a ra hanma a nga. ");
INSERT INTO yal_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","A nama mini yire sariɲanxin kui, hanma a yɛtɛ xɔsi, amasɔtɔ a rasariɲanxi Alaa masusan turen nan na. Alatala nan n tan na. ");
INSERT INTO yal_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","A xa sungutun nasɔlɔnxin tongo a ɲaxanla ra. ");
INSERT INTO yal_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","A nama kaɲa gilɛn tongo, hanma ɲaxanla beɲinxina hanma yalunde xɔsixina, koni a xa sungutun nasɔlɔnxin tongo a yamani, ");
INSERT INTO yal_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","alogo a nama a yixɛtɛne rayagi a yamaan tagi. Alatala nan n tan na naxan a rasariɲanma.” ");
INSERT INTO yal_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","a xa a fala Haruna xa, a naxa, “I yixɛtɛn muxu madɔnxi yo nama wali saraxa rabadeni, a Ala donseen nali a ma. ");
INSERT INTO yal_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Madɔntɔ yo mi daxa a a maso: danxutɔna, lɛbutɛnna, naxan yɛtagi madɔnxi, hanma naxan salen se madɔnxi, ");
INSERT INTO yal_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","sankalatɔna hanma yiikalatɔna, ");
INSERT INTO yal_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","dantɔna hanma tongona, teeli kanna, hanma kafanla muxun naxan ma, hanma naxan tɛgɛnxi. ");
INSERT INTO yal_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Saraxarali Haruna yixɛtɛn madɔnxi yo nama a maso, a yi saraxane rali Alatala ma tɛɛn na. Madɔntɔɔn na a ra, a mi lan a a maso, a Ala donseen nali a ma. ");
INSERT INTO yal_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","A nɔɛ Alaa donse sariɲanxin sifan birin donɲɛ nɛn, hali naxanye sariɲan han. ");
INSERT INTO yal_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Koni a madɔntɔyana fe ra, a mi lan a yi a maso yire sariɲanxin yɛ masansan dugin na hanma saraxa gandena. A nama n ma yire sariɲanxina fe kala. Alatala nan n tan na, naxan saraxaraline rasariɲanma.” ");
INSERT INTO yal_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Musa yi na falane rali Haruna nun a diine ma, e nun Isirayila kaane birin. ");
INSERT INTO yal_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","a xa a fala Haruna nun a diine xa, a Isirayila kaane na saraxa sariɲanxin naxanye fi n ma, e xa ne suxu ki faɲi e don kiin ma alogo e nama n xili sariɲanxin kala. Alatala nan n tan na. ");
INSERT INTO yal_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","A fala e xa, i naxa, “Xa ɛ yixɛtɛ yo mi sariɲan waxati famatɔne yi, a a maso Isirayila kaane saraxane ra e naxanye ralima Alatala ma, na kanna kedima nɛn n yɛtagi. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Xa fure ɲaxin bata mini Haruna yixɛtɛna nde fatin ma, hanma furen yi a bari boden suxu, na mi lan a saraxa sariɲanxine don benun a xa rasariɲan. A mɔn mi sariɲanxi xa a bata a yiin din sena nde ra naxan bata din muxun binbin na, hanma igen sifana nde naxan minixi muxun xɛmɛyani, ");
INSERT INTO yal_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","hanma a na a yiin din bubu seen na hanma muxun naxan mi sariɲan, hanma a findi se xɔsixi yo ra. ");
INSERT INTO yal_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Naxan na a yiin din na se sifan na, na mi fa sariɲanxi han ɲinbanna. A nama saraxa sariɲanxine don, han a yi a fatin birin maxa. ");
INSERT INTO yal_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Sogen na godo, a bata sariɲan. Na xanbi ra, a nɔɛ saraxa sariɲanxine donɲɛ sɔnɔn, amasɔtɔ a balon na a ra. ");
INSERT INTO yal_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","A nama suben don naxan faxaxi a yɛtɛ ma hanma burunna subene naxan yibɔxi, alogo a nama a yɛtɛ xɔsi a xɔn. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Saraxaraline xa n ma yamarine suxu alogo e nama yulubin tongo, e faxa e kalane fe ra. Alatala nan n tan na, naxan e rasariɲanma. ");
INSERT INTO yal_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Muxu yo nama saraxa sariɲanxin don xa a mi saraxaralina denbayani. Hali saraxaralina muxu xilixina hanma a walikɛɛn mi daxa a a don. ");
INSERT INTO yal_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Koni xa saraxaraliin bata konyina nde sara, hanma naxan barixi a konni, na nɔɛ a donɲɛ nɛn. ");
INSERT INTO yal_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Xa muxuna nde saraxaralina dii tɛmɛn dɔxɔ a ɲaxanla ra, saraxarali mi a tan na, dii tɛmɛn nama fa saraxa sariɲanxine don. ");
INSERT INTO yal_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Koni xa saraxaralina dii tɛmɛn findi kaɲa gilɛn na hanma a futun yi kala, dii mi a yii, a xɛtɛ a baba konni alo a to yi dii ɲɔrɛyani, a nɔɛ a baba donseen donɲɛ nɛn. Koni naxan mi saraxaralina denbayani, na nama a don. ");
INSERT INTO yal_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Xa muxuna nde a saraxa sariɲanxin don tantanni, a lan a yi a ɲɔxɔn fi, a mɔn yi yaganna dɔxɔɲa ma firin sa a fari a yanginna ra. ");
INSERT INTO yal_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Saraxaraline nama Isirayila kaane saraxa sariɲanxine kala e naxan bama Alatala xa. ");
INSERT INTO yal_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Xa e tin yamaan yi saraxa sariɲanxine don, e bata e findi yulubi tongone ra, yanginna fima naxan ma fe ra. Alatala nan n tan na, naxan e rasariɲanma.” ");
INSERT INTO yal_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","a xa a fala Haruna nun a diine nun Isirayila kaane birin xa, a naxa, “Isirayila kaan birin hanma xɔɲɛne Isirayila yi, naxan saraxa gan daxin bama Alatala xa, dɛ tiin nakamalina fe ra, hanma ɲɛnige ma saraxana, ");
INSERT INTO yal_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","a lan a yi fa turaan na hanma kontonna, hanma kɔtɔna fɛ mi naxan na. ");
INSERT INTO yal_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Fɛɛn xuruseen naxan na, a mi lan ɛ yi fa na ra, amasɔtɔ a mi rasuxuma ɛ xa. ");
INSERT INTO yal_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Xa muxuna nde fa xuruse gbeen na hanma a xunxurina, bɔɲɛ xunbeli saraxan na Alatala xa, hanma dɛ tiin nakamali saraxana hanma ɲɛnige ma saraxana, fɛ yo nama lu a ra alogo a xa rasuxu. ");
INSERT INTO yal_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Nayi, ɛ nama fa xuruse yɛɛtaren na, ɛ a rali Alatala ma tɛɛn na n ma saraxa ganden fari, hanma naxan madɔnxi, hanma a maxɔlɔxi, hanma furen naxan fatin ma hanma kaban naxan ma. ");
INSERT INTO yal_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ɲingena hanma yɛxɛɛna naxan salen se kuya hanma a dungi, i nɔɛ na bɛ nɛn ɲɛnige ma saraxan na, koni a mi rasuxɛ dɛ tiin nakamali saraxan na. ");
INSERT INTO yal_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ɛ nama fa xuruseen na Alatala xɔn naxan tɛgɛnxi, a dɛlane kalaxi, hanma e baxi na. Ɛ nama na ba saraxan na ɛ yamanani. ");
INSERT INTO yal_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ɛ nama na xuruse sifan nasuxu xɔɲɛne yii, ɛ a ba donse saraxan na ɛ Ala xa. Amasɔtɔ e tɛgɛnxi. Fɛna e ra. E mi rasuxɛ ɛ xa.” ");
INSERT INTO yal_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ɲingena, yɛxɛɛna hanma siin na bari, a xa lu a nga bun xii solofere. Xii solomasɛxɛde lɔxɔni e nun na xanbi ra, a rasuxɛ nɛn saraxan na, naxan nalima Alatala ma tɛɛn na. ");
INSERT INTO yal_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ɲingena hanma yɛxɛɛna, ɛ nama e nun a diin kɔɛ raxaba lɔxɔ kedenni. ");
INSERT INTO yal_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Xa ɛ barika bira saraxan ba Alatala xa, ɛ xa a ba ki faɲi alogo a xa rasuxu. ");
INSERT INTO yal_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","A donma na lɔxɔn yɛtɛɛn nin. Ɛ nama sese lu han xɔtɔnni. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ɛ n ma yamarine suxu ɛ yi e liga. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","“Ɛ nama n xili sariɲanxin kala, alogo n xa lu sariɲanni ɛ tagi, ɛ tan Isirayila kaane. Alatala nan n tan na, naxan ɛ rasariɲanma. ");
INSERT INTO yal_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","N tan nan ɛ ramini Misiran yamanani, n yi findi ɛ Ala ra. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","a xa a fala Isirayila kaane xa, a naxa, “Sali lɔxɔne ni itoe ra Alatala xa, ɛ yamaan xilima malan sariɲanxini waxatin naxan yi. Sali lɔxɔne ni itoe ra n xa. ");
INSERT INTO yal_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ɛ xa wali xii sennin, koni xii soloferede lɔxɔn findixi Matabu Lɔxɔn nan na, malan sariɲanxin tima lɔxɔn naxan ma. Ɛ nama wali yo kɛ. Ɛ xa Matabu Lɔxɔn findi Alatala gbeen na ɛ nɛma dɔxi dɛdɛ yi.” ");
INSERT INTO yal_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Sali lɔxɔn bonne ni i ra Alatala xa. Ɛ xa yamaan xili malan sariɲanxini waxatini itoe yi: ");
INSERT INTO yal_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Kike singen xii fu nun naaninna, fitirin ma, Halagi Tiin Dangu Lɔxɔn Sanla nan na ra Alatala xa. ");
INSERT INTO yal_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Na kiken xii fu nun suulundena, Buru Tetaren Sanla nan na ra Alatala xa. Ɛ xa buru ratetarene don xii solofere. ");
INSERT INTO yal_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Xii singeni, ɛ xa malan sariɲanxin maxili. Na lɔxɔni, ɛ nama ɛ wanle kɛ. ");
INSERT INTO yal_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ɛ xa saraxane rali Alatala ma tɛɛn na xii solofere. Xii soloferede lɔxɔni, ɛ mɔn yi malan sariɲanxin maxili. Na lɔxɔni, ɛ nama ɛ wanle kɛ.” ");
INSERT INTO yal_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","a xa a fala Isirayila kaane xa, a naxa, “N bɔxɔn naxan soma ɛ yii, ɛ na so mɛnni, ɛ se xaban fɔlɔ, ɛ xa fa ɛ bogise singen xidin na saraxaraliin fɛma. ");
INSERT INTO yal_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Saraxaraliin xa a yita Alatala ra Matabu Lɔxɔn xɔtɔn bode, alogo a xa a rasuxu ɛ yii. ");
INSERT INTO yal_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ɛ se xidin yitama Ala ra lɔxɔ naxan yi, ɛ xa yɛxɛɛn ɲɛɛ kedenna ba saraxa gan daxin na Alatala xa, fɛ mi naxan na, ");
INSERT INTO yal_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","e nun bogise saraxana, murutu fuɲin kilo sennin naxan basanxi turen na. Na xa rali Alatala ma tɛɛn na, naxan xiri rafan a ma, e nun minse saraxan wudi bogi igen litiri keden e nun a tagi. ");
INSERT INTO yal_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Burun ba, tɔnsɔn ganxine ba, a xindene ba, ɛ nama se xabaxi yo don benun ɛ xa fa na saraxane ra ɛ Ala xa. Habadan sariyan nan na ra ɛ yixɛtɛne birin xa, ɛ na dɔxɔ dɛdɛ yi.” ");
INSERT INTO yal_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Keli Matabu Lɔxɔn xɔtɔn bode, ɛ malo xidin yitama Ala ra lɔxɔn naxan yi, xunsagi solofere xa dangu. ");
INSERT INTO yal_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Xii tonge suulundeni, Matabu Lɔxɔ solofereden xɔtɔn bode, ɛ mɔn xa bogise xaba nɛnɛn fi Alatala ma bogise saraxan na. ");
INSERT INTO yal_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ɛ xa murutu fuɲin kilo saxan nafala buru ratexin na, ɛ fa na buru xun firin na bogise singe saraxa ralixin na Alatala xa. ");
INSERT INTO yal_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Yamaan mɔn xa kontondi solofere ba saraxan na ɲɛɛ keden kedenne fɛ mi naxanye ra, e nun tura bulan keden nun konton firin, sa bogise saraxa burune fari e nun bogise saraxane nun minse saraxan naxanye daxa. Saraxa gan daxin nan ne ra, naxanye ralima Alatala ma tɛɛn na, e xirin yi rafan a ma. ");
INSERT INTO yal_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na, e nun yɛxɛɛn ɲɛɛ keden kedenna firin bɔɲɛ xunbeli saraxan na. ");
INSERT INTO yal_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Saraxaraliin xa yɛxɛɛ firin nun bogise singen burun yita n na se ralixin na. E rasariɲanma Alatala xa nɛn, e yi so saraxaraliin yii. ");
INSERT INTO yal_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Na lɔxɔn yɛtɛni, ɛ xa yamaan xili malan sariɲanxini. Ɛ nama ɛ wanle kɛ na lɔxɔni. Habadan sariyan na a ra ɛ yixɛtɛne birin xa, ɛ na dɔxɔ dɛdɛ yi. ");
INSERT INTO yal_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Ɛ na malo xaban fɔlɔ, ɛ nama maala xaba han xɛɛn xɛdɛɛn xɔn, ɛ nama tɔnsɔnne makentun naxanye na lu a xɔri ma. I xa ne lu yiigelitɔne xa e nun xɔɲɛne. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","a a xa a fala Isirayila kaane xa, a naxa, “Kike solofereden xii singeni, ɛ xa ɛ matabu na lɔxɔni ɛ yi a binya, ɛ xɔtaan fe, ɛ yamaan xili malan sariɲanxini. ");
INSERT INTO yal_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ɛ nama ɛ wanle kɛ na lɔxɔni, ɛ xa saraxane rali Alatala ma tɛɛn na.” ");
INSERT INTO yal_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Kike solofereden xii fuden xa findi Ala Solona Lɔxɔn na. Ɛ xa malan sariɲanxin ti, ɛ yi sunna suxu, ɛ yi saraxane rali Alatala ma tɛɛn na. ");
INSERT INTO yal_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ɛ nama ɛ wali yo kɛ na lɔxɔni, amasɔtɔ Ala Solona Lɔxɔn na a ra. Alatala solonama ɛ xa na lɔxɔn nin, ɛ Ala. ");
INSERT INTO yal_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Xa naxan yo mi sunna suxu na lɔxɔni, na kedima nɛn a yamani. ");
INSERT INTO yal_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Xa naxan yo wali na lɔxɔni, n na a raxɔrima nɛn a yamaan yɛ. ");
INSERT INTO yal_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ɛ nama wali yo kɛ. Habadan sariyan na a ra ɛ yixɛtɛne birin xa, ɛ na dɔxɔ dɛdɛ yi. ");
INSERT INTO yal_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Matabu Lɔxɔn na a ra ɛ xa e nun sali lɔxɔna. Ɛ xa sunna suxu. Ɛ xa matabu sanla raba keli kiken xii solomanaaninden ɲinbanna ma han na xɔtɔn bode ɲinbanna.” ");
INSERT INTO yal_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","a a xa a fala Isirayila kaane xa, a naxa, “Kike solofereden xii fu nun suulundeni, Bubu Kui Sanla na ra Alatala xinli, han xii solofere. ");
INSERT INTO yal_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Sanla xii singeni, malan sariɲanxin tima nɛn, ɛ nama ɛ wali yo kɛ. ");
INSERT INTO yal_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Xii solofere, ɛ xa saraxane rali Alatala ma tɛɛn na. Xii solomasɛxɛde lɔxɔni, ɛ mɔn xa malan sariɲanxin ti, ɛ mɔn yi saraxane rali Alatala ma tɛɛn na. Malan sariɲanxin na a ra, ɛ nama ɛ wali yo kɛ. ");
INSERT INTO yal_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Sali lɔxɔne nan ne ra Alatala xa, ɛ yamaan xilima malan sariɲanxini lɔxɔn naxanye yi, alogo ɛ xa saraxane rali Alatala ma tɛɛn na, saraxa gan daxine nun bogise saraxane nun saraxa gbɛtɛye, e nun minse saraxane, naxanye daxa sali lɔxɔne yi. ");
INSERT INTO yal_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Saraxani itoe sama Alatalaa Matabu Lɔxɔne saraxane fari nɛn, e nun ɛ kiseene nun ɛ dɛ tiin nakamali saraxane, e nun ɛ ɲɛnige ma saraxane ɛ naxanye birin fima Alatala ma.” ");
INSERT INTO yal_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Kike solofereden xii fu nun suulunde lɔxɔni, ɛ na yelin bogi seene malandeni xɛɛn ma, ɛ xa sanla raba Alatala xa xii solofere. Xii singen nun xii solomasɛxɛden findin Matabu Lɔxɔne nan na. ");
INSERT INTO yal_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Xii singe lɔxɔni, ɛ xa bogise faɲine ba wudine kɔɛ ra, e nun tugu yiine, e nun ɲɔxɔndene, e nun wudi yii gbɛtɛye, ɛ yi sɛwa Alatala yɛtagi ɛ Ala han xii solofere. ");
INSERT INTO yal_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ɛ xa sanli ito raba Alatala xa ɲɛɛ yo ɲɛɛ, xii solofere. Habadan sariyan na a ra ɛ yixɛtɛne birin xa. Ɛ sanla raba ɲɛɛn kike soloferedeni. ");
INSERT INTO yal_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ɛ xa dɔxɔ bubune kui xii solofere. Isirayila bari diine birin xa lu bubune kui, ");
INSERT INTO yal_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","alogo ɛ yixɛtɛne xa a kolon fa fala n na e benbane radɔxɔ nɛn bubune kui, n to ɛ ramini Misiran bɔxɔni. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Musa Alatalaa sali lɔxɔne fala na kii nin Isirayila kaane xa. ");
INSERT INTO yal_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“A yamari Isirayila kaane ma a e xa fa oliwi ture faɲin na i xɔn, alogo lɛnpune xa dɛgɛ waxatin birin. ");
INSERT INTO yal_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Haruna xa a yengi lu lɛnpune xɔn Layiri Kankiraan yɛ masansan dugin fari ma Naralan Bubun kui, alogo e xa dɛgɛ Alatala yɛtagi keli ɲinbanna ma han xɔtɔnni waxatin birin. Habadan sariyan na a ra ɛ yixɛtɛne birin xa. ");
INSERT INTO yal_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Haruna xa a yengi lu lɛnpune xɔn kɔɛɛn birin na naxanye dɔxi lɛnpu dɔxɔ se xɛma daxin fari Alatala yɛtagi.” ");
INSERT INTO yal_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Murutu fuɲin tongo i yi buru fu nun firin nafala. Burune keden kedenna birin binyen xa kilo sennin li. ");
INSERT INTO yal_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","I xa e dɔxɔ yɛlan firin nin xɛma tabanla fari Alatala yɛtagi, sennin sennin yɛ ma. ");
INSERT INTO yal_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","I xa wusulan faɲin sa burune birin fari, naxan nalima Alatala ma tɛɛn na burun ɲɔxɔn na ɲɔxɔ lu seen na Ala xɔn. ");
INSERT INTO yal_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Buruni itoe xa dɔxɔ Alatala yɛtagi Matabu Lɔxɔn birin yi. Habadan layirin na a ra Isirayila kaane xa. ");
INSERT INTO yal_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Burune xa raxɛtɛ Haruna nun a diine ma, e yi e don yire sariɲanxini. Amasɔtɔ se sariɲanxin na a ra na saraxane yɛ, naxanye ralima Alatala ma tɛɛn na, naxanye so saraxaraline yii. Habadan sariyan na a ra.” ");
INSERT INTO yal_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Lɔxɔna nde muxuna nde yi mini Isirayila kaane yɛ, a nga Isirayila kaa, a baba Misiran kaa. Na kanna nun Isirayila kaana nde yi yɛngɛ yamaan daaxadeni. ");
INSERT INTO yal_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Isirayila ɲaxanla diin yi Ala xinla rayelefu, a yi a konbi. A nga yi xili nɛn Selomiti, Dibiri a dii tɛmɛna Dan bɔnsɔnni. Mafurɛn e yi a xali Musa fɛma. ");
INSERT INTO yal_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","E yi a ramara a faɲin na han Alatala yɛtɛɛn yi a fe yɛba e xa. ");
INSERT INTO yal_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Naxan konbin tixi, na ramini yamaan daaxaden fari ma. Naxanye birin a xuiin mɛxi, ne birin xa e yiine ti a xunna ma, yamaan birin yi a magɔlɔn han a faxa. ");
INSERT INTO yal_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","I xa a fala Isirayila kaane xa iki, i naxa, ‘Naxan na Ala konbi, a lan a yi a yulubin goronna tongo. ");
INSERT INTO yal_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Naxan na Alatala xinla rayelefu, na xa faxa, yamaan birin xa a magɔlɔn. Xa a findi xɔɲɛn na hanma Isirayila kaana, a na Alatala xinla rayelefu, a faxama nɛn. ");
INSERT INTO yal_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Naxan na muxuna nde faxa, ɛ xa na kanna faxa. ");
INSERT INTO yal_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Naxan na muxuna nde a suben faxa, a lan a yi a ɲɔxɔn so a yii. Niin ɲɔxɔn xa fi niin na. ");
INSERT INTO yal_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Naxan na a boden maxɔlɔ, a fan xa maxɔlɔ na kiini. ");
INSERT INTO yal_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Maxɔlɔn ɲɔxɔn nan maxɔlɔn na, yɛɛn ɲɔxɔn nan yɛɛn na, ɲinna ɲɔxɔn nan ɲinna ra. A xa maxɔlɔ alo a a ligaxi boden na kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Naxan na suben faxa a lan a yi a ɲɔxɔn fi, koni naxan na muxun faxa a lan a yi faxa. ");
INSERT INTO yal_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Sariya kedenna na a ra ɛ birin xa, xɔɲɛna hanma Isirayila kaana. Alatala nan n tan na, ɛ Ala.’ ” ");
INSERT INTO yal_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Musa yi falan ti Isirayila kaane xa. Xɛmɛn naxan konbin tixi, e yi na xali yamaan daaxaden fari ma, e yi a magɔlɔn, a faxa. Isirayila kaane yi a liga alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Alatala yi a fala Musa xa Sinayi geyaan fari, ");
INSERT INTO yal_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","a xa a fala Isirayila kaane xa, a naxa, “Ɛ na so na bɔxɔni n naxan soma ɛ yii, bɔxɔn yɛtɛɛn xa a matabu Alatala xinli. ");
INSERT INTO yal_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ɛ nɔɛ ɛ xɛɛne biyɛ nɛn ɲɛɛ sennin, ɛ manpa bili nakɔne wali, ɛ yi e bogine malan. ");
INSERT INTO yal_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Koni ɲɛɛ solofereden findin matabu ɲɛɛn nan na Alatala xinli. Ɛ nama ɛ xɛɛne bi hanma ɛ yi ɛ manpa bili nakɔne wali. ");
INSERT INTO yal_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Sansi bogin naxanye na soli e yɛtɛ ma, i tan nama e malan i yɛtɛ xa. I tan nama manpa tɔnsɔn mɔxine malan naxanye bogixi e yɛtɛ ma. Amasɔtɔ matabu ɲɛɛn na ra bɔxɔn xa. ");
INSERT INTO yal_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Koni bɔxɔn na naxan namini matabu ɲɛɛn kui, ɛ birin xa na don, i tan, i ya konyi xɛmɛna, i ya konyi gilɛna, i ya walikɛna, xɔɲɛn naxan luma i konni, ");
INSERT INTO yal_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","e nun i ya xuruseene, e nun hali burunna suben naxanye i ya bɔxɔni. Bɔxɔn na naxan namini, na birin nɔɛ donɲɛ nɛn.” ");
INSERT INTO yal_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Ɛ xa matabu ɲɛɛ solofere tɛngɛ, ɲɛɛ solofere dɔxɔ solofere, alogo matabu ɲɛɛ soloferene xa lan ɲɛɛ tonge naanin e nun solomanaaninna ma. ");
INSERT INTO yal_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Kike solofereden xii fudeni, Ala Solona Lɔxɔna, ɛ xa xɔtane fe yamanan birin yi. ");
INSERT INTO yal_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ɛ ɲɛɛ tonge suulunden nasariɲanma nɛn, ɛ yi a rali yiren birin yi a yamanan muxune birin bata xɔrɔya. Xɔrɔya Ɲɛɛn na a ra ɛ xa, ɛ birin yi xɛtɛ ɛ denbayana bɔxɔn ma ɛ bɔnsɔnne yi. ");
INSERT INTO yal_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ɲɛɛ tonge suulunden findima Xɔrɔya Ɲɛɛn nan na ɛ xa. Ɛ nama ɛ xɛɛne bi, ɛ nama sansi bogine malan naxanye solima e yɛtɛ ma. Ɛ nama manpa bogi tɔnsɔnne malan naxanye bogima e yɛtɛ ma. ");
INSERT INTO yal_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Amasɔtɔ Xɔrɔya Ɲɛɛn nan na ra. A sariɲan ɛ xa. Ɛ na donseen naxan to xɛɛne ma, ɛ xa na don.” ");
INSERT INTO yal_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Na Xɔrɔya Ɲɛɛna, birin xa xɛtɛ a gbee bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Xa ɛ bɔxɔna nde mati hanma ɛ a sara muxuna nde ma, ɛ nama ɲaxu ɛ bode ra. ");
INSERT INTO yal_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","I a saren naxan soma i kon kaan yii, na xa lan na ɲɛɛne yatɛn ma naxan luxi benun Xɔrɔya Ɲɛɛn xa a li. A xa a saren nasuxu i yii naxan lanɲɛ se xaba waxatine yatɛn ma naxanye luxi. ");
INSERT INTO yal_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Xa ɲɛɛ wuyaxi luxi, a saren xa mate na kiini. Xa ɲɛɛ dando nan luxi a xa a saren magodo. Amasɔtɔ a mi bɔxɔn matima, fɔ se xaba waxatine. ");
INSERT INTO yal_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ɛ nama ɲaxu ɛ bode ra, koni ɛ xa gaxu ɛ Ala yɛɛ ra. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Ɛ xa n ma tɔnne nun sariyane suxu. Nayi, ɛ luma nɛn yamanani bɔɲɛ xunbenli. ");
INSERT INTO yal_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Bɔxɔn yi bogi seene fi, ɛ yi ɛ dɛge han ɛ lugo, ɛ lu bɔɲɛ xunbenli. ");
INSERT INTO yal_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Waxatina nde ɛ a falama nɛn, ɛ naxa, ‘En nanse donma ɲɛɛ soloferedeni, xa en mi xɛɛn bi, en mi seen xaba?’ ");
INSERT INTO yal_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","N barakan sama nɛn ɛ feene yi ɲɛɛ sennindeni, alogo ɛ se xabaxin xa ɛ makone birin fan han ɲɛɛ saxan. ");
INSERT INTO yal_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ɲɛɛ solomasɛxɛdeni, ɛ nɛma ɛ xɛɛne bima, ɛ donse ramaraxin nan donma. Ɛ luma a donɲɛ nɛn han ɲɛɛn solomanaaninden se xaba waxatini.” ");
INSERT INTO yal_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Ɛ nama bɔxɔn mati habadanni mumɛ, amasɔtɔ n tan nan gbee bɔxɔn na. Ɛ tan luxi nɛn alo xɔɲɛn naxanye yigiyaxi n konni. ");
INSERT INTO yal_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Nanara, ɛ na yamanan sɔtɔ, ɛ xa sariyan dɔxɔ alogo bɔxɔ matixin xa xunba.” ");
INSERT INTO yal_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Xa i ngaxakedenna findi yiigelitɔɔn na, a yi a bɔxɔna nde mati, a bari bodena nde xa fa a bɔxɔ matixin xunba. ");
INSERT INTO yal_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Xa a bari bode mi na naxan daxa a a xunba, xa a tan yɛtɛɛn bata a xunba fɛrɛn sɔtɔ, ");
INSERT INTO yal_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","a xa ɲɛɛne yatɛ keli a saran ma, a yi na ɲɔxɔn naxɛtɛ a sara muxun ma. Na xanbi, a nɔɛ xɛtɛ nɛn a bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Koni, xa a mi a ɲɔxɔ raxɛtɛ se sɔtɔ, bɔxɔn xa lu a sara muxun yii han Xɔrɔya Ɲɛɛna. Na waxatini a kari singen mɔn xa xɛtɛ a bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Xa muxuna nde a banxin mati taa gbeeni yinna soxi naxan ma, a nɔɛ a xunbɛ nɛn han ɲɛɛ keden a sara xanbini. ");
INSERT INTO yal_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Koni xa banxin mi xunba benun ɲɛɛ keden, a luma nɛn a sara muxun gbeeyani sɔnɔn e nun a yixɛtɛne. A mi a raxɛtɛma Xɔrɔya Ɲɛɛni. ");
INSERT INTO yal_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Koni banxin naxanye taa xunxurine yi naxanye mi rabilinxi yinna ra, ne luma nɛn alo bɔxɔna. E nɔɛ xunbɛ nɛn, e mɔn yi raxɛtɛ e kari singen ma Xɔrɔya Ɲɛɛni.” ");
INSERT INTO yal_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Lewi bɔnsɔnna taane kui, Lewine nɔɛ e banxine xunbɛ nɛn waxatin birin. ");
INSERT INTO yal_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Naxan na Lewi kaana nde a banxin sara, a minima nɛn banxi saraxin nun na taani Xɔrɔya Ɲɛɛni. Amasɔtɔ banxin naxanye Lewi taane yi, ne findixi Lewine nan gbansan gbee ra Isirayila yamanani. ");
INSERT INTO yal_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Koni xɛɛn naxanye e taane rabilinni, ne mi lan e mati, amasɔtɔ Lewine nan gbee e ra habadan!” ");
INSERT INTO yal_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Xa i ngaxakedenna findi yiigelitɔɔn na, naxan dɔxi i fɛma, fɛrɛn mi fa a yii a balo, i lan i yi a maso i ra alo xɔɲɛna alogo a xa lu i fɛma. ");
INSERT INTO yal_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","I nama tɔnɔ yo maxɔdin a ma koni i xa gaxu i ya Ala yɛɛ ra, i ngaxakedenna yi lu i fɛma. ");
INSERT INTO yal_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Xa i a doli gbetini, i nama tɔnɔ sa a fari. Xa i donseen mati a ma, i nama tɔnɔn sɔtɔ a xɔn.” ");
INSERT INTO yal_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","“Alatala nan n tan na, ɛ Ala, naxan ɛ raminixi Misiran bɔxɔni alogo n xa Kanan bɔxɔn so ɛ yii, n yi findi ɛ Ala ra.” ");
INSERT INTO yal_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Xa muxuna nde findi yiigelitɔɔn na i dɛxɔn, a yi a yɛtɛ mati i ma, i nama a ti konyi wanla ra. ");
INSERT INTO yal_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","A xa masuxu i konni alo walikɛna hanma xɔɲɛna. A xa lu i ya wanla ra han Xɔrɔya Ɲɛɛna. ");
INSERT INTO yal_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Na waxatini, e nun a diine yi xɔrɔya, a yi xɛtɛ a xabilani, e nun a benbane bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Amasɔtɔ n ma walikɛne nan Isirayila kaane ra, n naxanye raminixi Misiran yamanani. E nama mati konyiyani. ");
INSERT INTO yal_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","I nama e ɲaxankata, fɔ i xa gaxu i ya Ala yɛɛ ra.” ");
INSERT INTO yal_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Xa ɛ konyi xɛmɛn hanma konyi gilɛn sara, a xa keli siya gbɛtɛne yɛ naxanye ɛ rabilinxi. ");
INSERT INTO yal_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ɛ mɔn nɔɛ xɔɲɛna ndee sarɛ nɛn naxanye dɔxi ɛ yɛ, e nun e xabilan muxuna nde naxanye barixi ɛ yamanani. E yi findi ɛ gbeen na. ");
INSERT INTO yal_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ɛ mɔn nɔɛ e luyɛ ɛ diine yii nɛn ɛ kɛɛn na, alogo e xa lu konyiyani habadan. Koni ɛ ngaxakedenne, Isirayila kaane, ɛ tan sese nama nɔɔn sɔtɔ a ngaxakedenna xun na, a a ɲaxankata.” ");
INSERT INTO yal_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Xa xɔɲɛn findi nafulu kanna ra naxan dɔxi ɛ konni, ɛ ngaxakedenna nde yi findi yiigelitɔɔn na, a a yɛtɛ mati xɔɲɛn ma, hanma xɔɲɛn xabila muxu gbɛtɛ ma, ");
INSERT INTO yal_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","a nɔɛ xunbɛ nɛn a mati xanbini. A ngaxakedenna nde nɔɛ a xunbɛ nɛn, ");
INSERT INTO yal_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","hanma a sɔxɔna, hanma a dunbode, hanma a bari bodena nde a xabilani, na nɔɛ a ligɛ nɛn. A tan yɛtɛɛn nɔɛ a yɛtɛ xunbɛ nɛn, xa a fɛrɛn sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Nayi, e nun a sara muxun xa ɲɛɛne yatɛ keli a sara ɲɛɛn ma han Xɔrɔya Ɲɛɛna. A xa a ɲɔxɔn fi alo walikɛɛn nɔɛ saranna yatɛn naxan sɔtɛ na ɲɛɛne bun. ");
INSERT INTO yal_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ɲɛɛn dɔnxɛn naxanye luxi, xa ne mɔn gbo, a xa ne xasabin gbetin naxɛtɛ nafulu kanna ma a xunba saren na. ");
INSERT INTO yal_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ɲɛɛn naxanye luxi benun Xɔrɔya Ɲɛɛn yi a li, xa ne mi fa gbo, a xa na fan xasabin gbetin naxɛtɛ a xunba saren na. ");
INSERT INTO yal_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","A yisuxuma nɛn a kanna konni alo walikɛɛn naxan sare fixi, a nama a ɲaxankata. ");
INSERT INTO yal_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Xa a mi xunba na kii yo yi, e nun a diine xa xɔrɔya Xɔrɔya Ɲɛɛni. ");
INSERT INTO yal_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Amasɔtɔ n ma walikɛne nan Isirayila kaane ra. N gbee walikɛne nan e ra, n naxanye raminixi Misiran bɔxɔni. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Ɛ nama suxurene rafala. Ɛ nama alana nde sawuran nafala. Ɛ nama gɛmɛn dɔxɔ, ɛ yi a batu. Ɛ nama gɛmɛ masolixin ti ɛ yamanani ɛ yi a batu. Amasɔtɔ Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“Ɛ xa n ma Matabu Lɔxɔne suxu, ɛ yi n ma yire sariɲanxin binya. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Xa ɛ n ma tɔnne nun yamarine suxu, ");
INSERT INTO yal_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","n tulen nafama nɛn ɛ ma a waxatini, bɔxɔn yi balon fi, wudine yi bogi xɛɛne ma. ");
INSERT INTO yal_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Se bɔnbɔ waxatin buma nɛn han bogise bolon waxatina. Bogi seene yi lu bolonɲɛ han xɛɛ bi waxatina. Ɛ dɛgema nɛn han ɛ lugo, ɛ yi lu ɛ bɔxɔni bɔɲɛ xunbenli. ");
INSERT INTO yal_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","N tinma nɛn yamanan yi lu hɛrini. Ɛ na ɛ sa, sese mi ɛ tɔrɛ. N burunna sube xaɲɛne bama nɛn ɛ yamanani, yɛngɛn mi soɛ ɛ konni. ");
INSERT INTO yal_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ɛ ɛ yaxune kedima nɛn, e yi bira ɛ bun yɛngɛni. ");
INSERT INTO yal_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ɛ tan muxu suulun fama nɛn ɛ yaxun muxu kɛmɛ kedideni. Ɛ tan muxu kɛmɛ yi ɛ yaxun wuli fu kedi. Ɛ yaxune birama nɛn ɛ bun yɛngɛni. ");
INSERT INTO yal_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","N fanma nɛn ɛ ra. N yi dii wuyaxi fi ɛ ma, ɛ wuya ayi. N na n ma layirin nakamalima nɛn en tagi. ");
INSERT INTO yal_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ɛ yala malo ramaraxine donma nɛn han malo xaba waxatin mɔn yi a li, ɛ yi a fonna dɔnxɛn woli ayi alogo a nɛnɛn xa ramara. ");
INSERT INTO yal_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","N luma nɛn ɛ yɛ, n mi n mɛ ɛ ra mumɛ! ");
INSERT INTO yal_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","N na n masiga tima nɛn ɛ tagi, n findi ɛ Ala ra. Ɛ yi findi n ma yamaan na. ");
INSERT INTO yal_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Alatala nan n tan na, ɛ Ala, naxan ɛ ramini Misiran bɔxɔni alogo ɛ xa ba Misiran kaane yii. N Misiran konyiyaan goronna ba nɛn ɛ ma, alogo ɛ xa nɔ sigan tiyɛ xunna kenli.” ");
INSERT INTO yal_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Koni, xa ɛ mi n xuiin namɛ, ɛ yamarini itoe birin suxu, ");
INSERT INTO yal_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","xa ɛ n ma tɔnne kala, ɛ yi ɛ mɛ n ma sariyane ra, ɛ mi n ma yamarine birin liga, ɛ n ma layirin kala, ");
INSERT INTO yal_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","nayi, n ni ito nan ligama ɛ ra: N yihadin nagodoma nɛn ɛ ma, e nun fitina furene nun fati mawolonna, naxanye ɛ yɛɛne kalama, e yi ɛ niin ba. Ɛ sansine sima fuuni bayo ɛ yaxune nan e donma. ");
INSERT INTO yal_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","N kelima nɛn ɛ xili ma, alogo ɛ yaxune xa ɛ nɔ. Naxanye ɛ raɲaxuxi, ne yi nɔɔn sɔtɔ ɛ xun na. Ɛ ɛ giyɛ hali muxu yo mi ɛ fɔxɔ ra.” ");
INSERT INTO yal_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Na birin xanbi ra, xa ɛ mi n xuiin namɛ, n na ɛ yulubine saranma ɛ ra nɛn dɔxɔɲa ma solofere. ");
INSERT INTO yal_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","N yi ɛ wason kala, n yi kuyeni xara alo wurena, e nun bɔxɔna alo sulana. ");
INSERT INTO yal_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ɛ sɛnbɛn yi ɲan fuuni, bayo ɛ bɔxɔn mi bogi seene fiyɛ, yamanan wudine mi bogima.” ");
INSERT INTO yal_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Xa ɛ murutɛ n ma, ɛ tondi n xuiin namɛ, n na ɛ tɔrɔne rawuyama ayi nɛn dɔxɔ solofere naxan lanxi ɛ yulubine ma. ");
INSERT INTO yal_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","N burunna subene rafama nɛn ɛ xili ma naxanye ɛ diine faxama, e yi ɛ xuruseene raxɔri. E yi ɛ xurunɲɛ ayi han ɛ kirane yi yigeli.” ");
INSERT INTO yal_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Xa hali na birin ɛ mi xuru n ma, ɛ lu murutɛxi n ma, ");
INSERT INTO yal_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","n yɛtɛɛn kelima nɛn ɛ xili ma, n mɔn yi ɛ tɔrɔne rawuya ayi dɔxɔ solofere. ");
INSERT INTO yal_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","N yɛngɛn nakelima nɛn ɛ tan xili ma, n yi ɛ yulubine saran ɛ ra n ma layirin kala feen na. Ɛ na ɛ luxun ɛ taa ratangaxine yi, n fitina furen nafama nɛn, ɛ yi lu ɛ yaxune yiini. ");
INSERT INTO yal_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","N yi ɛ kuma donseen na, ɲaxalan fu yamaan birin ma burun ganma nɛn buru gande kedenni, e yi ɛ buruni taxun ligase xurudin na, ɛ yi a don koni ɛ mi lugo.” ");
INSERT INTO yal_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Xa hali na birin, ɛ mi n xuiin namɛ, ɛ yi lu murutɛxi n ma, ");
INSERT INTO yal_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","nayi, n kelima nɛn ɛ xili ma, n yi ɛ yulubine saran ɛ ra dɔxɔɲa ma solofere. ");
INSERT INTO yal_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ɛ ɛ diine suben donma nɛn. ");
INSERT INTO yal_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","N yi ɛ taan kidene kala, n yi ɛ wusulan gandene rabira. ");
INSERT INTO yal_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","N yi ɛ taane findi xɔrinxɔrinna ra, ɛ yire sariɲanxine yi raxɔri. Nayi, ɛ saraxane mi fa rafanma n ma. ");
INSERT INTO yal_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","N na ɛ yamanan kalama nɛn. Ɛ yaxune na fa dɔxɔdeni ɛ konne yi, e kabɛma nɛn a kalaxin ma. ");
INSERT INTO yal_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","N na ɛ raxuyama ayi nɛn yamanane yi, n yi bira ɛ fɔxɔ ra silanfanna ra, n yi ɛ sagatan. Ɛ yamanani gelima nɛn, a yi findi taa xɔnne ra.” ");
INSERT INTO yal_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“Nayi, ɛ nɛma ɛ yaxune yii e konni waxatin naxan yi, ɛ yamanani genla yi lu, ɛ bɔxɔn luma nɛn matabuni, matabu waxatine ɲɔxɔn na ɛ mi naxanye suxu. ");
INSERT INTO yal_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","A nɛma rabeɲinxi, a matabun sɔtɔma nɛn, ɛ mi tin naxanye ma ɛ yi dɔxi a yi waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Naxanye na lu e nii ra ɛ yɛ, n na e tunnaxɔlɔma e ma nɛn e yaxune yamanani, han e yi e gi ɲɔxɔnden gbansanna bira xuiin bun alo silanfanna, e bira hali muxe mi e fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","E birama nɛn e bode fari alo e nɛma e giyɛ silanfanna bun, anu muxu yo mi e fɔxɔ ra. Ɛ mi nɔɛ tiyɛ ɛ yaxune yɛɛ ra. ");
INSERT INTO yal_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ɛ faxama nɛn siya gbɛtɛne tagi, ɛ yaxune yamanan yi ɛ don. ");
INSERT INTO yal_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Naxanye na lu ɛ tan yɛ, ne doyenma nɛn han e faxa e yaxune yamanane yi e tan nun e benbane hakɛne fe ra.” ");
INSERT INTO yal_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Koni e na e ti e hakɛne ra e nun e benbane gbeene nun e tinxintareyaan nun e murutɛna, ");
INSERT INTO yal_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","feen naxanye a ligaxi, n yi keli e xili ma, n yi e rasiga e yaxune yamanani, nayi e Ala kolontare bɔɲɛne na xuru, e yi e hakɛne yanginna fi, ");
INSERT INTO yal_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","n na n mirima nɛn layirina feen ma nxu nun Yaxuba tagi, e nun nxu nun Isiyaga, e nun nxu nun Iburahima, n yi n miri yamanana fe ma. ");
INSERT INTO yal_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Koni, fɔ yamanan nabeɲinxin xa lu singe, a yi a matabu e mi na waxatin naxan yi. E e hakɛne yanginna fima nɛn amasɔtɔ e bata e mɛ n ma sariyane nun tɔnne ra. ");
INSERT INTO yal_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Koni, hali e lu e yaxune yamanani, n mi e rabeɲinɲɛ han e yi raxɔri, n yi n ma layirin kala. Amasɔtɔ Alatala nan n tan na, e Ala. ");
INSERT INTO yal_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","N na n mirima nɛn n ma layirin ma, naxan nxu nun e benbane tagi, n naxanye ramini Misiran bɔxɔni siyane yɛtagi, alogo n xa findi e Ala ra. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Alatala tɔnne nun yamarine nun sariyane nan ne ra, a naxanye falaxi Isirayila kaane xa fata Musa ra Sinayi geyaan fari. ");
INSERT INTO yal_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","a xa a fala Isirayila kaane xa, a naxa, “Xa muxuna nde bata a dɛ ti, a muxuna nde fi Alatala ma, a xunbama gbetin nan na naxan lanxi a yatɛn ma. ");
INSERT INTO yal_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Xa xɛmɛn na a ra naxan barin bata ɲɛɛ mɔxɔɲɛ ti han ɲɛɛ tonge sennin, i xa a saren yatɛ gbeti gbanan tonge suulun na, gbeti gbananna naxanye rawalima yire sariɲanxini. ");
INSERT INTO yal_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Xa ɲaxanla na a ra, gbeti gbanan tonge saxan. ");
INSERT INTO yal_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Dii xɛmɛn naxan barin bata ɲɛɛ suulun ti han ɲɛɛ mɔxɔɲɛ, na lanma gbeti gbanan mɔxɔɲɛ nan ma. Dii tɛmɛna, gbeti gbanan fu. ");
INSERT INTO yal_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Dii xɛmɛn naxan barin bata kike kedenna ti han ɲɛɛ suulun, na lanma gbeti gbanan suulun nan ma. Dii tɛmɛna, gbeti gbanan saxan. ");
INSERT INTO yal_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Xɛmɛn naxan bata dangu ɲɛɛ tonge senninna ra, na lanma gbeti gbanan fu nun suulun ma. Ɲaxanla, gbeti gbanan fu. ");
INSERT INTO yal_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Naxan bata a dɛ ti, xa yiigelitɔɔn na a ra, a mi nɔɛ na gbetin yatɛn fiyɛ, a lan a yi na muxun xali saraxaraliin fɛma. Na nɔɛ gbetin xasabina nde falɛ nɛn a nɔɛ naxan fiyɛ.” ");
INSERT INTO yal_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Xa muxuna nde bata a dɛ ti xurusena fe ra naxan nɔɛ bɛ saraxan na Alatala xa, na xuruse sifan na fi Alatala ma, a bata rasariɲan. ");
INSERT INTO yal_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","A mi masarɛ gbɛtɛ ra. A faɲin mi masarɛ a kobin na, a kobin mi masarɛ a faɲin na. Xa a kanna xuruseen masara gbɛtɛ ra, e firinna birin bata rasariɲan. ");
INSERT INTO yal_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Xa suben na a ra naxan haramuxi, naxan mi bɛ saraxan na Alatala xa, a xa xali saraxaraliin fɛma. ");
INSERT INTO yal_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Saraxaraliin xa a saren fala, xa suben fan, hanma a mi fan. A na saren naxan fala, a bata lu na ma. ");
INSERT INTO yal_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Xa a kanna waxi suben xunba feni, a xa a ɲɔxɔn fi a yi yaganna dɔxɔɲa ma firin sa a fari.” ");
INSERT INTO yal_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Xa muxuna nde a banxin fi Alatala ma, saraxaraliin xa a saren fala, xa a fan hanma a mi fan. A na naxan fala, a bata lu na ma. ");
INSERT INTO yal_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Xa a kanna waxi a xunba feni, a xa a ɲɔxɔn fi a yi yaganna dɔxɔɲa ma firin sa a fari. Banxin yi xɛtɛ a kanna ma.” ");
INSERT INTO yal_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Xa muxuna nde a xɛɛn fi Alatala ma, a saren xa fala fata sansiin yatɛn na naxan xuyɛ a ma. Malo bɛnbɛli gbee saxan xuyɛ bɔxɔn naxan ma, na lanma gbeti gbanan tonge suulun nan ma. ");
INSERT INTO yal_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Xa xɛɛn fixi Xɔrɔya Ɲɛɛn nin, a saren luma na kii nin. ");
INSERT INTO yal_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Xa xɛɛn fixi Xɔrɔya Ɲɛɛn xanbin nin, saraxaraliin xa ɲɛɛne yatɛ naxan luxi benun Xɔrɔya Ɲɛɛ famatɔna, a yi nde ba xɛɛn saren na. ");
INSERT INTO yal_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Xa xɛɛ kanna waxi a xunba feni, a xa a ɲɔxɔn fi, a yi yaganna dɔxɔɲa ma firin sa a fari, xɛɛn yi xɛtɛ a kanna ma. ");
INSERT INTO yal_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Xa a mi xɛɛn xunba, a yi a mati muxu gbɛtɛ ma, a mi fa nɔɛ a xunbɛ. ");
INSERT INTO yal_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Xɛɛn na yɛba Xɔrɔya Ɲɛɛni, a bata rasariɲan, a so Alatala yii kiseen na habadan! A findima saraxaraline gbeen nan na. ");
INSERT INTO yal_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Xa muxuna nde xɛɛn fi Alatala ma a naxan saraxi, naxan mi yi a kɛɛni, ");
INSERT INTO yal_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","saraxaraliin xa a saren fala fata ɲɛɛne yatɛn na naxanye luxi benun Xɔrɔya Ɲɛɛna. Na kanna xa a saren fi na lɔxɔ yɛtɛni. A sariɲan Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Xɛɛn naxɛtɛma a kari singen ma nɛn Xɔrɔya Ɲɛɛni, a sara naxan ma, naxan gbee yi a ra nun. ");
INSERT INTO yal_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Na sarene birin falama nɛn fata yire sariɲanxin gbeti gbananna ra, naxan lanxi garamu fu ma.” ");
INSERT INTO yal_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Muxu yo nama a xuruse dii singen fi Alatala ma na kiini, amasɔtɔ Alatala nan gbee dii singene birin na hali ba na feen na. Ɲinge ba, yɛxɛɛ ba, Alatala nan gbee e birin na. ");
INSERT INTO yal_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Xa a findi sube haramuxin dii singen na, a kanna nɔɛ a xunbɛ nɛn. A xa a ɲɔxɔn fi, a yi yaganna dɔxɔɲa ma firin sa a fari. Xa a mi a xunba, a xa a mati a sare falaxin na.” ");
INSERT INTO yal_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Koni, muxun na sese fi Alatala ma habadanni, muxu ba, xuruse ba, a kɛɛ xɛɛn ba, na sese mi sarɛ, a mi xunbɛ. Naxan yo na fi a ma habadanni, na bata sariɲan a xa fefe. ");
INSERT INTO yal_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Hali a findi muxun na naxan fixi Ala ma habadanni, a mi nɔɛ xunbɛ, ɛ xa a faxa.” ");
INSERT INTO yal_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Alatala nan gbee bɔxɔn bogiseene birin yaganna ra. A na keli xɛɛn ma hanma langan kui, a sariɲan Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Xa muxuna nde waxi a yaganna yirena nde xunba feni, fɔ a xa a ɲɔxɔn fi, a yi na yiren yaganna dɔxɔɲa ma firin sa a fari. ");
INSERT INTO yal_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Alatala nan gbee xuruseene birin yaganna ra, a xurin nun a xungbena. Xuruseene na yatɛ, Alatala nan gbee e fudene ra. ");
INSERT INTO yal_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Xuruseene mi yɛbama a faɲin nun a kobin na. Xuruseen nama masara gbɛtɛ ra. Xa a na liga e firinna birin nasariɲanma nɛn, e mi nɔɛ xunbɛ.” ");
INSERT INTO yal_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Alatala na yamarine nan so Musa yii Isirayila kaane xa Sinayi geyaan fari.");
INSERT INTO yal_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Alatala yi falan ti Musa xa Naralan Bubun kui, Sinayi tonbonni, kike firinden lɔxɔ singeni, e minin ɲɛɛ firindeni Misiran bɔxɔni. A yi a fala, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Ɛ nun Haruna xa Isirayila yamaan birin tɛngɛ, ɛ xɛmɛne birin xinle sɛbɛ xabila yɛɛn nun denbaya yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Ɛ xa Isirayila xɛmɛne birin tɛngɛ fata e ganle ra naxanye barin bata dangu ɲɛɛ mɔxɔɲɛn na, naxanye nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Bɔnsɔn yo bɔnsɔn, xabila manga keden xa ɛ mali.” ");
INSERT INTO yal_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Na mali muxune xinle ni itoe ra: Keli Rubɛn bɔnsɔnni, Sedewuri a dii Elisuri. ");
INSERT INTO yal_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Keli Simeyɔn bɔnsɔnni, Surisadayi a dii Selumiyɛli. ");
INSERT INTO yal_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Keli Yuda bɔnsɔnni, Aminadabo a dii Naxason. ");
INSERT INTO yal_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Keli Isakari bɔnsɔnni, Suwari a dii Natanɛli. ");
INSERT INTO yal_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Keli Sabulon bɔnsɔnni, Xelɔn ma dii Eliyabi. ");
INSERT INTO yal_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yusufu a diine bɔnsɔnne: Keli Efirami bɔnsɔnni, Amixudi a dii Elisama. Keli Manase bɔnsɔnni, Pedasuri a dii Gamaliyɛli. ");
INSERT INTO yal_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Keli Bunyamin bɔnsɔnni, Gidewoni a dii Abidan. ");
INSERT INTO yal_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Keli Dan bɔnsɔnni, Amisadayi a dii Axiyeseri. ");
INSERT INTO yal_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Keli Aseri bɔnsɔnni, Okiran ma dii Pagiyɛli. ");
INSERT INTO yal_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Keli Gadi bɔnsɔnni, Dewuyɛli a dii Eliyasafi. ");
INSERT INTO yal_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Keli Nafatali bɔnsɔnni, Enan ma dii Axira. ");
INSERT INTO yal_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Bɔnsɔn mangani itoe nan yi xilixi yamaan yɛ. Ne yi findixi Isirayila gali kuntigine nan na. ");
INSERT INTO yal_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa nun Haruna yi muxuni itoe tongo naxanye xinle yɛbaxi. ");
INSERT INTO yal_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","E yi yamaan birin malan kike firinden xii singen ma. Xɛmɛn naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, e yi ne birin xinle sɛbɛ keden keden yɛ ma kɛdin ma, xabila yɛɛn nun denbaya yɛɛn ma, ");
INSERT INTO yal_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","alo Alatala a yamari Musa ma kii naxan yi. A yi e tɛngɛ Sinayi tonbonni. ");
INSERT INTO yal_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","E yi xɛmɛne birin xinle sɛbɛ keden keden yɛ ma Isirayila a dii singe Rubɛn bɔnsɔnni xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","E muxu wuli tonge naanin wuli sennin kɛmɛ suulun tɛngɛ Rubɛn bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","E yi Simeyɔn bɔnsɔnna xɛmɛne birin xinle sɛbɛ keden keden yɛ ma, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","E muxu wuli tonge suulun wuli solomanaanin kɛmɛ saxan tɛngɛ Simeyɔn bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","E yi Gadi bɔnsɔnna xɛmɛne birin xinle sɛbɛ, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","E muxu wuli tonge naanin wuli suulun kɛmɛ sennin tonge suulun tɛngɛ Gadi bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","E yi Yuda bɔnsɔnna xɛmɛne birin xinle sɛbɛ, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","E muxu wuli tonge solofere wuli naanin kɛmɛ sennin tɛngɛ Yuda bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","E yi Isakari bɔnsɔnna xɛmɛne birin xinle sɛbɛ, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","E muxu wuli tonge suulun wuli naanin kɛmɛ naanin tɛngɛ Isakari bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","E yi Sabulon bɔnsɔnna xɛmɛne birin xinle sɛbɛ, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","E yi muxu wuli tonge suulun wuli solofere kɛmɛ naanin tɛngɛ Sabulon bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Yusufu a diine bɔnsɔnne yɛ: E yi Efirami bɔnsɔnna xɛmɛne birin xinle sɛbɛ, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","E muxu wuli tonge naanin kɛmɛ suulun tɛngɛ Efirami bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","E yi Manase bɔnsɔnna xɛmɛne birin xinle sɛbɛ, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","E muxu wuli tonge saxan wuli firin kɛmɛ firin tɛngɛ Manase bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","E yi Bunyamin bɔnsɔnna xɛmɛne birin xinle sɛbɛ, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","E muxu wuli tonge saxan wuli suulun kɛmɛ naanin tɛngɛ Bunyamin bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","E yi Dan bɔnsɔnna xɛmɛne birin xinle sɛbɛ, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","E muxu wuli tonge sennin wuli firin kɛmɛ solofere tɛngɛ Dan bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","E yi Aseri bɔnsɔnna xɛmɛne birin xinle sɛbɛ, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","E muxu wuli tonge naanin e nun keden kɛmɛ suulun tɛngɛ Aseri bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","E yi Nafatali bɔnsɔnna xɛmɛne birin xinle sɛbɛ, xabila yɛɛn nun denbaya yɛɛn ma, naxanye birin barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","E yi muxu wuli tonge suulun wuli saxan kɛmɛ naanin tɛngɛ Nafatali bɔnsɔnni. ");
INSERT INTO yal_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Musa nun Haruna nun Isirayila yamaan manga fu nun firinna ne xasabin nan yatɛ, bɔnsɔn keden manga keden. ");
INSERT INTO yal_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Isirayila kaane birin yatɛxin denbaya yɛɛn ma, naxanye barin bata yi dangu ɲɛɛ mɔxɔɲɛn na, naxanye yi nɔɛ sofa wanla kɛ, ");
INSERT INTO yal_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ne birin malanxina, muxu wuli kɛmɛ sennin wuli saxan kɛmɛ suulun tonge suulun nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Lewi bɔnsɔnna denbayane tan mi yi tɛngɛxi alo bonne. ");
INSERT INTO yal_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Alatala a fala nɛn Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“I nama Lewi bɔnsɔnna nun Isirayila kaan bonne tɛngɛ e bode xɔn. ");
INSERT INTO yal_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","I xa layiri sereyaan Bubun taxu Lewi bɔnsɔnna muxune ra e nun a muranne nun a seene birin. E xa batu bubun nun a muranne xali. E yi e ɲɔxɔ lu e xɔn, e yi e yamaan daaxadeni tɔn a rabilinni. ");
INSERT INTO yal_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ɛ na keli sigadeni, Lewi bɔnsɔnna muxune nan Ala Batu Bubun wayanma, e mɔn yi a yitɔn ɛ na dɔxɔ daaxaden naxan yi. Xa muxu gbɛtɛ a maso a ra, ɛ xa a faxa. ");
INSERT INTO yal_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Isirayila kaane birin xa e malan e daaxadeni, birin yi dɔxɔ gali yɛɛn ma a taxamasenna bun. ");
INSERT INTO yal_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Lewi bɔnsɔnna muxune tan xa e bubune ti layiri sereyaan bubun nabilinni, e yi e ɲɔxɔ lu a xɔn alogo n ma xɔlɔn nama godo Isirayila yamaan ma.” ");
INSERT INTO yal_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Alatala a yamarin Musa ma kii naxan yi, Isirayila kaane yi na birin liga. ");
INSERT INTO yal_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Alatala yi falan ti Musa nun Haruna xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Isirayila kaane birin xa yamaan daaxadeni tɔn Naralan Bubun nabilinni, koni e nama a yigbɛtɛn. E xa dɔxɔ e bɔnsɔnna nun e denbayaan taxamasenne bun.” ");
INSERT INTO yal_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Yuda bɔnsɔnna nun a ganle xa e daaxadeni tɔn sogeteden binni e taxamasenna bun ma. Aminadabo a dii Naxason nan Yuda mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Muxu wuli tonge solofere wuli naanin kɛmɛ sennin nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Isakari bɔnsɔnna xa e daaxadeni tɔn e dɛxɔn ma. Suwari a dii Natanɛli nan Isakari bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Muxu wuli tonge suulun wuli naanin kɛmɛ naanin nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Sabulon bɔnsɔnna xa daaxa e fan dɛxɔn ma. Xelɔn ma dii Eliyabi nan Sabulon bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Muxu wuli tonge suulun wuli solofere kɛmɛ naanin nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Nayi, xɛmɛn naxanye Yuda yamaan daaxaden ganli, ne birin malanxina, muxu wuli kɛmɛ wuli tonge solomasɛxɛ e nun sennin kɛmɛ naanin. Yamaan na keli, e singen nan sigama.” ");
INSERT INTO yal_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“Rubɛn bɔnsɔnna nun a ganle xa e daaxadeni tɔn yiifari fɔxɔni e taxamasenna bun ma. Sedewuri a dii Elisuri nan Rubɛn bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Muxu wuli tonge naanin wuli sennin kɛmɛ suulun nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simeyɔn bɔnsɔnna xa e daaxadeni tɔn a dɛxɔn ma. Surisadayi a dii Selumiyɛli nan Simeyɔn bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Muxu wuli tonge suulun wuli solomanaanin kɛmɛ saxan nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Gadi bɔnsɔnna xa daaxa na fan dɛxɔn ma. Reyuli a dii Eliyasafi nan Gadi bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Muxu wuli tonge naanin wuli suulun kɛmɛ sennin tonge suulun nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Nayi, xɛmɛn naxanye Rubɛn yamaan daaxaden ganli, ne malanxina, muxu wuli kɛmɛ wuli tonge suulun e nun keden kɛmɛ naanin tonge suulun. Ne nan sigama a firindeni.” ");
INSERT INTO yal_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Na xanbi ra, Lewi bɔnsɔnna muxune yi siga ganla bonne tagi, e nun Naralan Bubuna. E birin sigama e daaxa yɛɛn nan ma, muxun birin nun a tidena, a bɔnsɔnna taxamasenna bun ma.” ");
INSERT INTO yal_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“Efirami bɔnsɔnna nun a ganle xa e daaxadeni tɔn sogegododeni e taxamasenna bun ma. Amixudi a dii Elisama nan Efirami bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Muxu wuli tonge naanin kɛmɛ suulun nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Manase bɔnsɔnna xa daaxa a dɛxɔn ma. Pedasuri a dii Gamaliyɛli nan Manase bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Muxu wuli tonge saxan wuli firin kɛmɛ firin nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Bunyamin bɔnsɔnna xa daaxa na fan dɛxɔn ma. Gidewoni a dii Abidan nan Bunyamin bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Muxu wuli tonge saxan wuli suulun kɛmɛ naanin nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Nayi, xɛmɛn naxanye Efirami yamaan daaxaden ganli, ne malanxina, muxu wuli kɛmɛ wuli solomasɛxɛ muxu kɛmɛ. E tan nan sigama a saxandeni.” ");
INSERT INTO yal_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“Dan bɔnsɔnna nun a ganle xa e daaxadeni tɔn kɔmɛn fɔxɔni e taxamasenna bun ma. Amisadayi a dii Axiyeseri nan Dan bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Muxu wuli tonge sennin wuli firin kɛmɛ solofere nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Aseri bɔnsɔnna xa e daaxadeni tɔn a dɛxɔn ma. Okiran ma dii Pagiyɛli nan Aseri bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Muxu wuli tonge naanin e nun keden kɛmɛ suulun nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Nafatali bɔnsɔnna xa daaxa na fan dɛxɔn ma. Enan ma dii Axira nan Nafatali bɔnsɔnna mangan na. ");
INSERT INTO yal_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Muxu wuli tonge suulun wuli saxan kɛmɛ naanin nan a ganli. ");
INSERT INTO yal_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Nayi, xɛmɛn naxanye Dan ma yamaan daaxaden ganli, ne malanxina, muxu wuli kɛmɛ wuli tonge suulun e nun solofere kɛmɛ sennin. Ne nan sigan dɔnxɛn na, e taxamasenna bun ma.” ");
INSERT INTO yal_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Isirayila kaane nan ne ra naxanye tɛngɛ denbaya yɛɛn ma. Gali daaxadene birin malanxina, muxu wuli kɛmɛ sennin wuli saxan kɛmɛ suulun tonge suulun. ");
INSERT INTO yal_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Lewi bɔnsɔnna muxune mi tɛngɛ Isirayila kaan bonne yɛ, alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Alatala yamarin naxanye birin fi Musa ma Isirayila kaane yi ne birin liga. E yi e daaxaden yɛba e taxamasenne bun ma na kiini, e mɔn yi sigama na kii nin, xabila yɛɛn nun denbaya yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Haruna nun Musaa denbayaan muxune ni i ra, Alatala falan ti Musa xa waxatin naxan yi Sinayi geyaan fari. ");
INSERT INTO yal_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Harunaa diine xinle ni itoe ra: a dii singena Nadaba, Abihu, Eleyasari nun Itamara. ");
INSERT INTO yal_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ne nan yi Harunaa diine ra naxanye masusan alogo e xa dɔxɔ saraxaraliyani, e yi na wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Koni Nadaba nun Abihu faxa nɛn Alatala yɛtagi Sinayi tonbonni, e to fa tɛɛ daxataren na a xa. Dii mi yi e yii, nanara, Eleyasari nun Itamara nan lu saraxarali wanla kɛ e baba Haruna bun ma. ");
INSERT INTO yal_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Lewi bɔnsɔnna maso, i yi e lu saraxarali Haruna sagoni, e lu a wanla ra. ");
INSERT INTO yal_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","E xa Haruna nun yamana wanla kɛ Naralan Bubuni, e Ala Batu bubun wanle kɛ. ");
INSERT INTO yal_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","E yengi dɔxɔma nɛn Naralan Bubun muranne xɔn, e yi Ala Batu Bubun wanle rakamali Isirayila kaane xa. ");
INSERT INTO yal_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","I xa Lewi bɔnsɔnna muxune lu Haruna nun a diine sagoni. E tan nan fima n ma Isirayila kaane yɛ habadan! ");
INSERT INTO yal_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","I xa Haruna nun a diine dɔxɔ saraxaraliyani. Muxu gbɛtɛ na a maso yire sariɲanxin na, ɛ xa a faxa.” ");
INSERT INTO yal_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Alatala mɔn yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“N tan yɛtɛɛn bata Lewi bɔnsɔnna muxune sugandi Isirayila kaane yɛ, e findi n gbeen na Isirayila dii singene ɲɔxɔn na. ");
INSERT INTO yal_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Amasɔtɔ n gbeen nan dii singene birin na. N Misiran dii singene birin faxa lɔxɔni, n yi dii singene birin nasariɲan n yɛtɛ xa Isirayila yi. Muxu ba, xuruse ba, n gbeen nan e ra. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Alatala yi a fala Musa xa Sinayi tonbonni, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“I xa Lewi bɔnsɔnna muxune tɛngɛ, denbaya yɛɛn nun xabila yɛɛn ma. I xa xɛmɛne birin tɛngɛ naxanye barin bata dangu kike kedenna ra.” ");
INSERT INTO yal_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Musa yi e tɛngɛ alo Alatala a yamari kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lewi a diine xinle ni itoe ra: Gɛrisɔn, Kehati e nun Merari. ");
INSERT INTO yal_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gɛrisɔn ma diine findixi xabilani itoe nan benbaye ra: Libini nun Simeyi. ");
INSERT INTO yal_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kehati a diine findixi xabilani itoe nan benbaye ra: Amirama, Yisehari, Xebiron e nun Yusiyɛli. ");
INSERT INTO yal_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari a diine findixi xabilani itoe nan benbaye ra: Maxali nun Musi. Lewi xabilane nan ne ra e nun e denbayane benbane. ");
INSERT INTO yal_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gɛrisɔn findixi Libini nun Simayi xabilane benban nan na. Ne nan Gɛrisɔn xabilane ra. ");
INSERT INTO yal_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","E xɛmɛn naxanye tɛngɛ naxanye barin bata yi dangu kike kedenna ra, e muxu wuli solofere kɛmɛ suulun. ");
INSERT INTO yal_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gɛrisɔn xabilane yi e daaxadeni tɔnma Ala Batu Bubun nan xanbi ra, sogegodode binni. ");
INSERT INTO yal_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliyasafi nan yi Gɛrisɔn xabilane mangan na, Layeli a diina. ");
INSERT INTO yal_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gɛrisɔn xabilane yi e yengi lu Naralan Bubun yireni itoe xɔn: bubun nun a xunna soon kuiin nun a fanna, a so dɛɛn yɛ masansan dugina, ");
INSERT INTO yal_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","sansanna taa dugine naxan Ala Batu Bubun nun saraxa ganden nabilinni, dugin naxan singanxi sansanna dɛɛn na, e nun lutine nun e ti seene birin. ");
INSERT INTO yal_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kehati findixi Amirama nun Yisehari nun Xebiron nun Yusiyɛli xabilane benban nan na. Ne nan Kehati xabilane ra. ");
INSERT INTO yal_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","E xɛmɛn naxanye tɛngɛ naxanye barin bata yi dangu kike kedenna ra, e muxu wuli solomasɛxɛ kɛmɛ sennin. E tan nan e yengi lu yire sariɲanxin xɔn. ");
INSERT INTO yal_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kehati xabilane yi e daaxadeni tɔnma Ala Batu Bubun yiifari fɔxɔn nan ma. ");
INSERT INTO yal_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Elisafan nan yi Kehati xabilane mangan na, Yusiyɛli a diina. ");
INSERT INTO yal_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Kehati xabilane yi e yengi lu muranni itoe xɔn, Layiri Kankirana, tabanla, lɛnpu dɔxɔ sena, saraxa gandene, goronna naxanye rawalima yire sariɲanxini, yɛ masansan dugina, e nun e rawali seene birin. ");
INSERT INTO yal_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Saraxarali Harunaa dii Eleyasari nan yi Lewi bɔnsɔnna muxune birin mangan na. A tan nan yi dɔxi ne xun na naxanye yi e yengi luxi yire sariɲanxin xɔn ma. ");
INSERT INTO yal_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari findixi Maxali nun Musi xabilane benban nan na. Ne nan Merari xabilane ra. ");
INSERT INTO yal_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","E xɛmɛn naxanye tɛngɛ naxanye barin bata yi dangu kike kedenna ra, e muxu wuli sennin kɛmɛ firin. ");
INSERT INTO yal_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Suriyeli nan yi Merari xabilane mangan na, Abixali a diina. E yi e daaxadeni tɔnma Ala Batu Bubun kɔmɛn fɔxɔn nan ma. ");
INSERT INTO yal_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Merari xabilane yi e yengi lu Ala Batu Bubun buntine nun gaalane nun sɛnbɛtɛnne nun bundɔxɔne nun muranne xɔn e nun e ti seene birin, ");
INSERT INTO yal_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","e nun a sansanna sɛnbɛtɛnna naxanye a rabilinni nun e bundɔxɔne nun e gbangban seene nun e lutine. ");
INSERT INTO yal_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa nun Haruna nun a diine yi e daaxadeni tɔnma Naralan Bubun so dɛɛn nan yɛtagi, sogeteden binni. E yi yire sariɲanxin wanle xun matoma a ra Isirayila kaane xa. Xa muxu gbɛtɛ yi a maso yire sariɲanxin na, a yi faxama nɛn. ");
INSERT INTO yal_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Lewi bɔnsɔnna muxune birin Musa nun Haruna naxanye tɛngɛ xabila yɛɛn ma fata Alatalaa yamarin na, xɛmɛn naxanye barin bata yi dangu kike kedenna ra, e malanxina, muxu wuli mɔxɔɲɛn nun firin. ");
INSERT INTO yal_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Alatala yi a fala Musa xa, a naxa, “Dii xɛmɛ singene birin tɛngɛ Isirayila kaane yɛ, naxanye barin bata dangu kike kedenna ra, i yi e xinle sɛbɛ kɛdin ma. ");
INSERT INTO yal_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Lewi bɔnsɔnna muxune so n yii e ɲɔxɔn na e nun e xuruseene Isirayila kaane xuruse dii singene ɲɔxɔn na. Alatala nan n tan na.” ");
INSERT INTO yal_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Musa yi Isirayila kaane dii singene birin tɛngɛ, alo Alatala a yamari kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Dii xɛmɛ singen naxanye birin barin bata yi dangu kike kedenna ra, ne xinle sɛbɛxin lan muxu wuli mɔxɔɲɛn nun firin kɛmɛ firin tonge solofere e nun saxan nan ma. ");
INSERT INTO yal_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Lewi bɔnsɔnna muxune tongo Isirayila kaane dii singene ɲɔxɔn na e nun e xuruseene Isirayila kaane xuruse dii singene ɲɔxɔn na. Lewi bɔnsɔnna muxune xa findi n gbeen na. Alatala nan n tan na. ");
INSERT INTO yal_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Bayo Isirayila dii singene wuya Lewi bɔnsɔnna muxune xa han muxu kɛmɛ firin tonge solofere e nun saxan, ne xunba daxin na a ra. ");
INSERT INTO yal_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Muxu kedenna xunba gbeti gbanan suulun na, gbeti gbananna naxan nawalima yire sariɲanxini, naxan lanxi garamu fu ma. ");
INSERT INTO yal_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","I xa na gbetin so Haruna nun a diine yii dii singene xunba seen na naxanye yi wuyaxi ayi.” ");
INSERT INTO yal_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Naxanye mi yi ɲɔxɔ yibiraxi Lewi bɔnsɔnna muxune ra, Musa yi ne xunba gbetin tongo. ");
INSERT INTO yal_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","A yi Isirayila dii singene gbetin tongo han gbeti gbanan wuli keden kɛmɛ saxan tonge sennin e nun suulun, gbeti gbananna naxan nawalima yire sariɲanxini. ");
INSERT INTO yal_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Nayi, Musa yi xunba gbetin so Haruna nun a diine yii, alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Alatala yi a fala Musa nun Haruna xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Ɛ Kehati xabilan muxune tɛngɛ Lewi yixɛtɛne yɛ xabila yɛɛn nun denbaya yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ɛ xɛmɛne tɛngɛ keli ɲɛɛ tonge saxanna ma han ɲɛɛ tonge suulun, naxanye birin nɔɛ wanla kɛ Naralan Bubuni.” ");
INSERT INTO yal_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Kehati xabilan muxune xa wanli ito nan kɛ Naralan Bubuni: E xa e yengi lu se sariɲanxi fisamantenne xɔn. ");
INSERT INTO yal_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Yamaan na keli sigadeni, Haruna nun a diine xa yɛ masansan dugin ba, e yi a sa Layiri Sereya Kankiraan fari. ");
INSERT INTO yal_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","E yi sube kidi faɲine sa a fari, e mɔn yi dugi mamiloxini bandun ne fan fari. E yi Kankiraan tongo tamine yitɔn. ");
INSERT INTO yal_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","E xa dugi mamiloxi gbɛtɛ sa Buru Rali Tabanla fari, e yi a goronne nun igelengenne nun minse saraxa saseene dɔxɔ na. Buru Ralixin naxanye na waxatin birin, ne xa lu tabanla fari. ");
INSERT INTO yal_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","E xa dugi gbeela so seene birin xunna, e yi sube kidi faɲine so e birin xunna, e mɔn yi tabanla tongo tamine yitɔn. ");
INSERT INTO yal_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","E xa dugi mamiloxin so lɛnpu dɔxɔ seen nun lɛnpune nun e rawali seene nun tɛɛ kɔ seene nun e radɛgɛ turen xun na. ");
INSERT INTO yal_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","E xa ne birin mafilin sube kidi faɲi bitinganni, e mɔn yi e sa e xali wudin fari. ");
INSERT INTO yal_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","E xa dugi mamiloxin so saraxa gande xɛma daxin xun na, e yi sube kidi faɲi bitinganna so na fan xun na. E mɔn yi a tongo tamine yitɔn. ");
INSERT INTO yal_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Muranna naxanye birin nawalima yire sariɲanxini e xa ne malan, e yi e raxidi dugi mamiloxini, e yi kidi faɲi bitinganna so e xun na, e yi e sa e xali wudin fari. ");
INSERT INTO yal_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","E xa xuben ba saraxa gande sula daxin fari, e yi dugi mamiloxin so a xun na. ");
INSERT INTO yal_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","E xa a saraxa waliseene birin dɔxɔ na fari: xube sa seene, suben tongo seene, xube kɔ seene, e nun wuli xuya goronne. E xa sube kidi faɲi bitinganna so e xun na, e mɔn yi saraxa ganden tongo tamine yitɔn. ");
INSERT INTO yal_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Haruna nun a diine na yelin muranne nun goron sariɲanxine xunna soɛ, yamaan na keli sigadeni, Kehati xabilan muxune xa fa, e yi e xali. Koni e nama e yiin din se sariɲanxine ra, alogo e nama faxa. Kehati xabilan muxune xa na seene xali naxanye Naralan Bubun kui. ");
INSERT INTO yal_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Saraxarali Harunaa dii Eleyasari xa a yengi lu lɛnpu turen nun wusulanna nun bogise saraxane nun masusan turen xɔn ma. A yi a yengi lu Ala Batu Bubun yiren birin xɔn ma e nun a kui seene nun muran sariɲanxine nun a goronne birin.” ");
INSERT INTO yal_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Alatala yi a fala Musa nun Haruna xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Ɛ Kehati xabilan muxune ratanga alogo e nama raxɔri Lewi bɔnsɔnna yɛ. ");
INSERT INTO yal_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ɛ ito nan liga e xa alogo e nama faxa e na e maso se sariɲanxi fisamantenne ra waxatin naxan yi: Haruna nun a diine singe xa so yire sariɲanxini, e yi birin ti a wali ra, e nun a lan a xa naxan xali. ");
INSERT INTO yal_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Koni Kehati xabilan muxune nama so yire sariɲanxini, e se sariɲanxi fisamantenne to, hali ndedi, alogo e nama faxa.” ");
INSERT INTO yal_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Gɛrisɔn yixɛtɛne fan tɛngɛ, xabila yɛɛn nun denbaya yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","I xa xɛmɛne tɛngɛ keli ɲɛɛ tonge saxanna ma han ɲɛɛ tonge suulun, naxanye nɔɛ wanla kɛ Naralan Bubuni. ");
INSERT INTO yal_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gɛrisɔn yixɛtɛne xabilane wanle ni i ra e nun e lan e xa goronna naxanye xali: ");
INSERT INTO yal_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","E xa Ala Batu Bubun dugine maxali, e nun Naralan Bubuna, a xunna soona, a kidi faɲin naxanye sama a fari, dugin naxanye singanma Naralan Bubun so dɛɛn na, ");
INSERT INTO yal_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","a sansanna dugin naxanye Ala Batu Bubun nun saraxa ganden nabilinni, dugin naxan singanxi a so dɛɛn na, e nun e lutine nun e singan seene birin. ");
INSERT INTO yal_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gɛrisɔn xabilan muxune xa wali Haruna nun a diine yamarin bun. E tan nan a falama e xa e lan e xa naxan xali. ");
INSERT INTO yal_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gɛrisɔn xabilan muxune wanle nan ne ra Naralan Bubuni. E xa wali saraxarali Harunaa dii Itamaraa yamarin bun.” ");
INSERT INTO yal_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“I xa Merari bɔnsɔnna muxune tɛngɛ xabila yɛɛn nun denbaya yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","I xɛmɛne birin tɛngɛ keli ɲɛɛ tonge saxanna ma han ɲɛɛ tonge suulunna, naxanye nɔɛ wanla kɛ Naralan Bubuni.” ");
INSERT INTO yal_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","“E wanla ni i ra Naralan Bubuni: E xa Ala Batu Bubun bun tiine xali, a gaalane, a sɛnbɛtɛnne, a bundɔxɔne, ");
INSERT INTO yal_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","sansanna sɛnbɛtɛnne naxan bubun nabilinni, e bundɔxɔne, e gbangban wudine nun e lutine, e nun waliseene birin. Ɛ xa xɛmɛn birin goronna so a yii a naxan xalima. ");
INSERT INTO yal_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merari bɔnsɔnna muxune wanle nan ne ra Naralan Bubuni, saraxarali Harunaa dii Itamaraa yamarin bun.” ");
INSERT INTO yal_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa nun Haruna nun yamaan mangane yi Kehati xabilan muxune tɛngɛ xabila yɛɛn nun denbaya yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Xɛmɛn naxanye birin bata yi ɲɛɛ tonge saxanna sɔtɔ han ɲɛɛ tonge suulunna, naxanye birin yi nɔɛ wanla kɛ Naralan Bubuni, ");
INSERT INTO yal_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ne yi tɛngɛ xabila yɛɛn ma, e lan muxu wuli firin kɛmɛ solofere tonge suulun nan ma. ");
INSERT INTO yal_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Kehati xabila xɛmɛne yatɛn nan na ra, naxanye yi walima Naralan Bubuni. Musa nun Haruna yi e birin tɛngɛ alo Alatala a yamari e ma kii naxan yi fata Musa ra. ");
INSERT INTO yal_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gɛrisɔn yixɛtɛne fan yi tɛngɛ xabila yɛɛn nun denbaya yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Xɛmɛn naxanye birin bata yi ɲɛɛ tonge saxanna sɔtɔ han ɲɛɛ tonge suulun, naxanye birin yi nɔɛ wanla kɛ Naralan Bubuni, ");
INSERT INTO yal_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ne yi tɛngɛ xabila yɛɛn ma, e lan muxu wuli firin kɛmɛ sennin tonge saxan nan ma. ");
INSERT INTO yal_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Gɛrisɔn yixɛtɛne yatɛn nan na ra, naxanye yi walima Naralan Bubuni. Musa nun Haruna yi e birin tɛngɛ alo Alatala a yamari kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merari yixɛtɛne fan yi tɛngɛ xabila yɛɛn nun denbaya yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Xɛmɛn naxanye birin bata yi ɲɛɛ tonge saxanna sɔtɔ han ɲɛɛ tonge suulunna, naxanye birin yi nɔɛ wanla kɛ Naralan Bubuni, ");
INSERT INTO yal_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ne yi tɛngɛ xabila yɛɛn ma, e lan muxu wuli saxan kɛmɛ firin nan ma. ");
INSERT INTO yal_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Merari yixɛtɛne yatɛn nan na ra. Musa nun Haruna yi e birin tɛngɛ alo Alatala e yamari kii naxan yi fata Musa ra. ");
INSERT INTO yal_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Musa nun Haruna nun Isirayila mangane yi Lewi bɔnsɔnna muxune birin tɛngɛ xabila yɛɛn nun denbaya yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Xɛmɛn naxanye birin bata yi ɲɛɛ tonge saxanna sɔtɔ han ɲɛɛ tonge suulun, naxanye birin yi Naralan Bubun wanla kɛma, e mɔn yi a xali, ");
INSERT INTO yal_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","e malanxin lan muxu wuli solomasɛxɛ kɛmɛ suulun tonge solomasɛxɛ nan ma. ");
INSERT INTO yal_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","E yi e tɛngɛ alo Alatala e yamari kii naxan yi fata Musa ra. Birin yi ti a wanla ra, e nun a lan a xa goronna naxan maxali, alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Isirayila kaane yamari a e xa na kanna ramini yamaan daaxaden fari ma fure ɲaxin naxan fatin ma hanma faxunna minima muxun naxan bari boden ma hanma naxanye xɔsixi binbin xɔn. ");
INSERT INTO yal_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Xa xɛmɛn na a ra hanma ɲaxanla, ɛ xa e ramini yamaan daaxaden fari ma, alogo e nama daaxaden naxɔsi, n luma ɛ tagi dɛnaxan yi.” ");
INSERT INTO yal_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Isirayila kaane yi na liga, e yi e ramini yamaan daaxaden fari ma, e yi a liga alo Alatala a fala Musa xa kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","a a xa a fala Isirayila kaane xa, a naxa, “Xa xɛmɛna nde hanma ɲaxanla nde hakɛ yo liga muxu gbɛtɛ ra, a bata tinxintareyaan liga Alatala ra. Na kanna bata findi yulubi tongon na. ");
INSERT INTO yal_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Fɔ a xa a ti a hakɛn na nɛn, a yi a se kalaxin ɲɔxɔn naxɛtɛ a kanna ma, a yi a se kalaxin saren yaganna dɔxɔde firin sa a fari. ");
INSERT INTO yal_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Xa se kanna faxa, a bari bode mi na naxan na gbetin nasuxɛ, na seen lan a xɛtɛ Alatala ma, a so saraxaraliin yii, sa kontonna fari Ala solona seen na a xa. ");
INSERT INTO yal_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Isirayila kaane fama saraxa sariɲanxin naxanye ra, saraxaraliin nan gbee ne ra. ");
INSERT INTO yal_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Muxun na naxan nasariɲan, a na ligaxi a yɛtɛ nan xa. Muxun na naxan so saraxaraliin yii, na luma a tan nan yii.” ");
INSERT INTO yal_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","a xa ito fala Isirayila kaane xa, a naxa, “Xa xɛmɛna nde a ɲaxanla mi tinxin, a a xɛmɛn yanfa, ");
INSERT INTO yal_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","e nun xɛmɛ gbɛtɛ yi kafu, xa a xɛmɛn mi a to, ɲaxanla yi a yɛtɛ raxɔsi wundoni, koni xa a li sere mi na, a mi suxu na feen xun na, ");
INSERT INTO yal_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","xa xɔxɔlɔn xaxinla so na xɛmɛni, a sikɛ a ɲaxanla ma, xa a li a xɔsixi hanma a mi a ligaxi, ");
INSERT INTO yal_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","nayi, na xɛmɛn xa a ɲaxanla xali saraxaraliin fɛma. A xa murutu fuɲin kilo saxan xali bogise saraxan na. A nama ture sa na murutuni, a nama wusulan sa a fari, amasɔtɔ xɔxɔlɔnna bogise saraxan na a ra. Marabira seen na a ra hakɛ tongoxin ma. ");
INSERT INTO yal_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Saraxaraliin xa ɲaxanla maso, alogo a xa ti Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","A xa ige rasariɲanxin tongo fɛɲɛna nde kui, a yi Ala Batu Bubun burunburunna sa a yi. ");
INSERT INTO yal_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ɲaxanla naxan tima Alatala yɛtagi, a xa na labaranna ba, a yi bogise saraxan so a yii ɲɔxɔ lu seen na a hakɛn xɔn xɔxɔlɔnna bogise saraxan na. Saraxaraliin xa na ige lɔxɔn suxu a yii, naxan fama dangan na. ");
INSERT INTO yal_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","A xa ɲaxanla rakɔlɔ, a naxa, ‘Xa ɛ nun xɛmɛ gbɛtɛ mi kafuxi, i mi i ya xɛmɛn yanfaxi, i mi xɔsi fe rabaxi xabu i dɔxɔ xɛmɛ taa ra, i xa ratanga dangani ito ma ige lɔxɔni ito fama naxan na. ");
INSERT INTO yal_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Koni xa i bata i ya xɛmɛn yanfa, i yi i yɛtɛ raxɔsi, xa ɛ nun xɛmɛ gbɛtɛ bata kafu xabu i dɔxɔ xɛmɛ taa ra,’ ");
INSERT INTO yal_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","nayi, saraxaraliin xa ɲaxanla rakɔlɔ dangani ito ra, ‘Alatala xa a liga, i doyen, i kuiin yi mate i ra, yamaan yi i danga, e yi i mafala. ");
INSERT INTO yal_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Igeni ito naxan fama dangan na, na xa so i fatini, a yi i kuiin mate i ra, i yi doyen.’ Ɲaxanla xa a ratin, a naxa, ‘Amina, amina!’ ” ");
INSERT INTO yal_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Saraxaraliin xa dangani itoe sɛbɛ walaxana nde ma, a yi e xa ige yilɔxin na. ");
INSERT INTO yal_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","A xa ige xɔlɛn so ɲaxanla yii naxan fama dangan na, a a min, alogo a xa so a fatin xɔn, a xɔlɔ ayi. ");
INSERT INTO yal_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Saraxaraliin xa xɔxɔlɔnna bogise saraxan tongo ɲaxanla yii, a a yita Alatala ra a yii, a yi a xali saraxa ganden dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","A xa a yiin yɛ keden ba a ra, ɲɔxɔ lu seen na Ala xɔn, a yi a sa tɛɛni saraxa ganden fari. Na xanbi ra, ɲaxanla yi igen min. ");
INSERT INTO yal_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Xa a bata a yɛtɛ xɔsi, a a xɛmɛn yanfa, a na igen min naxan fama dangan na, na a tɔrɔma nɛn, a a kuiin mate a ra, a yi doyen. Na ɲaxanla findima nɛn danga muxun na yamaan tagi. ");
INSERT INTO yal_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Koni, xa na ɲaxanla mi a yɛtɛ xɔsixi, a sariɲan, fefe mi a sɔtɔma, a mɔn nɔɛ diine barɛ nɛn. ");
INSERT INTO yal_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Xɔxɔlɔnna sariyan nan na ra ɲaxanla xa naxan bata a xɛmɛn yanfa, a a yɛtɛ xɔsi, ");
INSERT INTO yal_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","hanma xɔxɔlɔn xaxinla na so xɛmɛn naxan yi, a na sogin a ɲaxanla ma. A xa ti Alatala yɛtagi, saraxaraliin yi sariya sɛbɛxini itoe birin nakamali a ma. ");
INSERT INTO yal_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Xɛmɛn mi hakɛ yo tongoxi, koni ɲaxanla a hakɛn goronna tongoma nɛn.” ");
INSERT INTO yal_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","a xa a fala Isirayila kaane xa, a naxa, “Xa xɛmɛna nde hanma ɲaxanla nde a dɛ ti, a a xa lu Alatalaa wanla ra Nasiri muxun na, ");
INSERT INTO yal_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","na kanna xa a mɛ dɔlɔn na e nun na minse sifane, hali manpa muluxunxina. A nama minse yo min naxan nafalaxi manpa bogin na, a nama manpa bogi xinden hanma a xaraxin don. ");
INSERT INTO yal_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","A nɛma a Nasiri dɛ tiin nakamalima, a nama sese don naxan kelixi manpa binle yi, hali a xɔnne hanma a dagina. ");
INSERT INTO yal_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","A nɛma a Nasiri dɛ tiin nakamalima, biden nama a xunna li. A xa lu Alatalaa wanla ra han na waxati falaxin yi kamali. A xa sariɲan, a xa a xunsɛxɛn lu kuyɛ ayi. ");
INSERT INTO yal_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","A nɛma Alatalaa wanla ra, a nama a maso binbin na. ");
INSERT INTO yal_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Hali a baba hanma a nga hanma a ngaxakedenna nde faxa, a nama a yɛtɛ xɔsi, a so binbin xun ma. Amasɔtɔ a xunsɛxɛn findixi taxamasenna nan na, a a tan bata lu Alaa wanla ra. ");
INSERT INTO yal_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","A nɛma Alaa wanla ra waxatin naxan birin yi, a sariɲan Alatala yɛtagi.” ");
INSERT INTO yal_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Xa muxuna nde faxa a fɛma, a xunsɛxɛ ralixin bata raharamu. A xa a xunna bi a rasariɲan lɔxɔni, xii soloferede lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Xii solomasɛxɛde lɔxɔni, a xa ganba firin hanma kolokonde dii firin xali saraxaraliin fɛma Naralan Bubun so dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Saraxaraliin xa keden faxa yulubi xafari saraxan na, bonna saraxa gan daxin na, a Ala solona a xa. Amasɔtɔ a bata lu binbin fɛma. Na lɔxɔni, a mɔn xa a xunna rasariɲan. ");
INSERT INTO yal_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Nayi, na kanna mɔn xa a dɛ ti waxatin dɛ suxu, a yi kontonna ɲɛɛ kedenna ba yangin saraxan na Alatala xa. Waxatin naxan bata yi dangu, na mi a kui, amasɔtɔ a xɔsi nɛn benun a dɛ tiin xa kamali.” ");
INSERT INTO yal_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Sariyan ni ito ra Nasiri dɛ tiin ma. A waxati saxin na kamali, e xa fa a ra Naralan Bubun so dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","A xa fa kiseni itoe ra Alatala yɛtagi: kontonna ɲɛɛ kedenna fɛ mi naxan na saraxa gan daxin na, yɛxɛɛ gilɛn ɲɛɛ kedenna fɛ mi naxan na yulubi xafari saraxan na, e nun konton keden fɛ mi naxan na bɔɲɛ xunbeli saraxan na. ");
INSERT INTO yal_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","A mɔn yi fa na saraxane bogise nun minse saraxane ra e nun burun sangatanna yɛ keden buru rate seen mi naxan yi, e nun buru xunne naxan nafalaxi murutu fuɲi faɲin na naxan basanxi turen na, e nun buru yilɛnlɛnxine turen saxi naxanye ma. ");
INSERT INTO yal_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Saraxaraliin xa ne yita Alatala ra, a yi yulubi xafari saraxan ba e nun saraxa gan daxina. ");
INSERT INTO yal_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","A mɔn xa kontonna ba bɔɲɛ xunbeli saraxan na Alatala xa, e nun buru ratetaren naxanye sangatanna kui e nun bogise saraxane nun minse saraxane. ");
INSERT INTO yal_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Na waxatini, Nasiri muxun xa a xunna bi Naralan Bubun so dɛɛn na bayo a bata yi a xunna fi Ala ma. A yi a xun sɛxɛne sa tɛɛni naxan bɔɲɛ xunbeli saraxan bun. ");
INSERT INTO yal_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Nasiri muxun na a xunna bi, saraxaraliin xa kontonna balaxa ɲinxin so a yii, e nun buru xun keden nun burudi keden keli sangatanna kui, buru rate se mi naxanye yi. ");
INSERT INTO yal_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Saraxaraliin xa e yita Alatala ra se ralixin na. E sariɲan. Saraxaraliin nan gbee e ra, sa danban nun a kanken fari naxanye daxa e yita Ala ra. Na xanbi ra, Nasiri muxun nɔɛ manpaan minɲɛ nɛn.” ");
INSERT INTO yal_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Sariyan nan na ra lan Nasiri muxuna kiseen ma bayo a bata a dɛ ti a a xa lu Alatalaa wanla ra. Xa fɛrɛna a xa, a mɔn nɔɛ nde sɛ a fari. A xa a dɛ tiin nakamali alo Nasiri muxuna sariyana a falaxi kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","a a xa a fala Haruna nun a diine xa, a e xa duba Isirayila kaane xa ikimaan na: ");
INSERT INTO yal_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Alatala xa i baraka, a i kantan! ");
INSERT INTO yal_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Alatala nɔrɔn xa godo i ma, a kininkinin i ma! ");
INSERT INTO yal_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Alatala xa a yengi dɔxɔ i xɔn, a bɔɲɛ xunbenla fi i ma! ");
INSERT INTO yal_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","E na duba Isirayila kaane xa n xinli, n tan e barakama nɛn. ");
INSERT INTO yal_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Musa yelin Ala Batu Bubun tiyɛ lɔxɔn naxan yi, a yi a masusan turen na a rasariɲan xinla ma e nun a muranne birin. A mɔn yi saraxa ganden nun a goronne masusan, a e rasariɲan. ");
INSERT INTO yal_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Nayi, Isirayila mangane yi fa kiseene ra. Denbaya xunne nan yi ne ra naxanye yamaan tɛngɛ, bɔnsɔn mangane. ");
INSERT INTO yal_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","E yi fa e kiseene ra Alatala yɛtagi: Wontoro xunna soxin sennin e nun ɲinge fu nun firin. Manga firin, wontoro keden, manga keden ɲinge keden. E yi fa ne ra Ala Batu Bubun yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Kiseene rasuxu e yii alogo e xa Naralan Bubun wanla kɛ. E xa yitaxun Lewi bɔnsɔnna ra, naxan lanɲɛ e wanle ma.” ");
INSERT INTO yal_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Nayi, Musa yi wontorone nun ɲingene rasuxu, a yi e yitaxun Lewi bɔnsɔnna ra. ");
INSERT INTO yal_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","A yi ɲinge naanin nun wontoro firin so Gɛrisɔn xabilan yii, alogo e wanla xa sɔnɔya. ");
INSERT INTO yal_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","A yi ɲinge solomasɛxɛ nun wontoro naanin so Merari xabilan yii, alogo e wanla xa sɔnɔya. E birin yi walima Itamaraa yamarin bun, saraxarali Harunaa diina. ");
INSERT INTO yal_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Koni, a mi se so Kehati xabilan yii, amasɔtɔ e yi tixi se sariɲanxi fisamantenne maxanla nan na, naxanye tongoma tungunna ma. ");
INSERT INTO yal_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Saraxa ganden masusan lɔxɔn naxan yi turen na alogo a wanla xa fɔlɔ, mangane yi e kiseene xali saraxa ganden yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Alatala yi a fala Musa xa, a naxa, “Lɔxɔ yo lɔxɔ manga keden xa fa a kiseene ra, alogo wanla xa fɔlɔ saraxa ganden yɛtagi.” ");
INSERT INTO yal_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Aminadabo a dii Naxason yi fa Yuda bɔnsɔnna kiseene ra xii singe lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","A kiseene ni i ra: goronna gbeti daxin keden naxan binyen yi lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin keden naxan binyen lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Aminadabo a dii Naxason ma kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Suwari a dii Natanɛli, Isakari bɔnsɔnna mangana, na yi fa a kiseene ra xii firinde lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Suwari a dii Natanɛli a kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Xelɔn ma dii Eliyabi, Sabulon bɔnsɔnna mangana, na yi fa a kiseene ra xii saxande lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Xelɔn ma dii Eliyabi a kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Sedewuri a dii Elisuri, Rubɛn bɔnsɔnna mangana, na yi fa a kiseene ra xii naaninde lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Sedewuri a dii Elisuri a kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Surisadayi a dii Selumiyɛli, Simeyɔn bɔnsɔnna mangana, na yi fa a kiseene ra xii suulunde lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Surisadayi a dii Selumiyɛli a kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Dewuyɛli a dii Eliyasafi, Gadi bɔnsɔnna mangana, na yi fa a kiseene ra xii senninde lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Dewuyɛli a dii Eliyasafi a kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Amixudi a dii Elisama, Efirami bɔnsɔnna mangana, na yi fa a kiseene ra xii soloferede lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Amixudi a dii Elisama kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Pedasuri a dii Gamaliyɛli, Manase bɔnsɔnna mangana, na yi fa a kiseene ra xii solomasɛxɛde lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Pedasuri a dii Gamaliyɛli a kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Gidewoni a dii Abidan, Bunyamin bɔnsɔnna mangana, na yi fa a kiseene ra xii solomanaaninde lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Gidewoni a dii Abidan ma kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Amisadayi a dii Axiyeseri, Dan bɔnsɔnna mangana, na yi fa a kiseene ra xii fude lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Amisadayi a dii Axiyeseri a kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Okiran ma dii Pagiyɛli, Aseri bɔnsɔnna mangana, na yi fa a kiseene ra xii fu nun kedende lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Okiran ma dii Pagiyɛli a kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Enan ma dii Axira, Nafatali bɔnsɔnna mangana, na yi fa a kiseene ra xii fu nun firinde lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","A kiseene ni i ra: goronna gbeti daxin keden naxan lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronna gbeti daxin naxan lanxi garamu kɛmɛ solofere ma naxan nun yire sariɲanxin liga seen binyen lan, e birin nafexi murutu fuɲin na naxan namulanxi turen na bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","xɛma goronna naxan lanxi garamu kɛmɛ ma, a rafexi wusulanna ra, ");
INSERT INTO yal_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","tura bulan keden e nun konton keden nun kontonna ɲɛɛ kedenna saraxa gan daxin na, ");
INSERT INTO yal_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","kɔtɔ keden yulubi xafari saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ɲinge firin e nun konton suulun nun kɔtɔ suulun, e nun yɛxɛɛn ɲɛɛ keden kedenna suulun, bɔɲɛ xunbeli saraxan na. Ne nan findi Enan ma dii Axira a kiseene ra. ");
INSERT INTO yal_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Isirayila denbaya xunne birin ma kiseene ni i ra, e naxanye fi saraxa ganden masusan lɔxɔni alogo a wanla xa fɔlɔ: goronna gbeti daxin fu nun firin, wuli xuya goronna gbeti daxin fu nun firin, xɛma goronna fu nun firin. ");
INSERT INTO yal_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Goronna gbeti daxin keden kedenne birin yi lanxi garamu wuli keden kɛmɛ saxan ma, wuli xuya goronne fan, garamu kɛmɛ solofere. Na seene birin malanxin lanxi gbeti kilo mɔxɔɲɛn nun naanin nan ma naxan nun yire sariɲanxin liga seen binyen lan. ");
INSERT INTO yal_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Goronna xɛma daxin keden kedenne birin yi lanxi garamu kɛmɛ nan ma. E fu nun firinne malanxina, garamu wuli keden kɛmɛ firin. E yi rafexi wusulanna ra. ");
INSERT INTO yal_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","E fa xuruseen naxanye ra saraxa gan daxin na: tura bulan fu nun firin, konton fu nun firin, yɛxɛɛn ɲɛɛ kedenna fu nun firin, e nun e bogise saraxane. E yi fa kɔtɔ fu nun firin na yulubi xafari saraxan na. ");
INSERT INTO yal_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","E fa xuruseen naxanye ra bɔɲɛ xunbeli saraxan na: tura mɔxɔɲɛn nun naanin, konton tonge sennin, kɔtɔ tonge sennin e nun yɛxɛɛn ɲɛɛ keden kedenna tonge sennin. Ne nan findi kiseene ra alogo saraxa ganden wanla xa fɔlɔ a masusan xanbini. ");
INSERT INTO yal_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musa nɛma yi soɛ Naralan Bubuni falatideni Ala xa, a yi Ala xuiin mɛma maleka gubugubu kan sawura firinne nan longori ra Layiri Sereya Kankiraan dɛraganla xun ma, Ala solonadena. A yi falan tima a xa. ");
INSERT INTO yal_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","a xa a fala Haruna xa, a naxa, “I na lɛnpu soloferene dɔxɔ waxatin naxan yi, e lan e yi lɛnpu dɔxɔ seen yɛtagini yalan.” ");
INSERT INTO yal_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Haruna yi na liga. A lɛnpune dɔxɔ alogo e xa e dɔxɔ seen yɛtagini yalan alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Lɛnpune dɔxɔ seen yi rafalaxi xɛma bɔnbɔxin nan na, keli a sanna ma han a fuge sawurane, alo Alatala a yita Musa ra kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Lewi bɔnsɔnna muxune ba Isirayila kaan bonne yɛ, i yi e rasariɲan. ");
INSERT INTO yal_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","I xa e rasariɲan ikiini: I xa marasariɲan igen xuya e ma, na xanbi ra e xa e fati ma xabene birin bi, e yi e dugine xa, alogo e xa sariɲan. ");
INSERT INTO yal_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","E xa tura bulan keden tongo, e nun murutu fuɲin naxan namulanxi turen na a bogise saraxan na, i yi tura bulan gbɛtɛ tongo yulubi xafari saraxan na. ");
INSERT INTO yal_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","I yi Isirayila yamaan birin malan, i yi Lewi bɔnsɔnna muxune xili Naralan Bubun yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","I xa Lewi bɔnsɔnna muxune maso Alatala yɛtagi, Isirayila kaane yi e yiine sa e fari. ");
INSERT INTO yal_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Haruna xa Lewi bɔnsɔnna muxune yita Alatala ra se ralixin na Isirayila kaane tagi alogo e xa Alatala wanla fɔlɔ. ");
INSERT INTO yal_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Na xanbi ra, Lewi bɔnsɔnna muxune xa e yiine sa tura firinna xunne fari. Na keden xa ba Alatala xa yulubi xafari saraxan na, bonna saraxa gan daxin na, Ala solona seen na Lewi bɔnsɔnna muxune xa. ");
INSERT INTO yal_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","I xa Lewi bɔnsɔnna muxune ti Haruna nun a diine yɛtagi, e yi e yita Alatala ra se ralixin na. ");
INSERT INTO yal_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Na kiini, i xa Lewi bɔnsɔnna muxune ba Isirayila kaan bonne tagi, Lewi bɔnsɔnna muxune yi findi n gbeen na. ");
INSERT INTO yal_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","I na Lewi bɔnsɔnna muxune rasariɲan i yi e yita n na se ralixin na, e xa fa e wanle kɛ Naralan Bubuni. ");
INSERT INTO yal_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Amasɔtɔ e bata findi n gbeen na mumɛ! N bata e tongo n gbeen na Isirayila dii xɛmɛ singene birin ɲɔxɔn na. ");
INSERT INTO yal_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Amasɔtɔ n gbeen nan Isirayila dii xɛmɛ singene birin na, a muxune nun a subene. Xabu n Misiran yamanan dii singene faxa lɔxɔni, n bata Isirayila dii singene ramara n yɛtɛ xa. ");
INSERT INTO yal_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Koni n Lewi bɔnsɔnna muxune nan tongoxi alogo e xa Isirayila dii xɛmɛ singene ɲɔxɔ yibira. ");
INSERT INTO yal_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","N ne nan soma Haruna nun a diine yii Isirayila kaane tagi, alogo e xa Naralan Bubun wanle kɛ Isirayila kaane xa, e yi Ala solona e xa. Nayi, fitina fe mi Isirayila kaane sɔtɔma, e na e maso yire sariɲanxin na.” ");
INSERT INTO yal_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa nun Haruna nun Isirayila yamaan birin yi na liga Lewi bɔnsɔnna muxune xa alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lewi bɔnsɔnna muxune yi e yɛtɛ rasariɲan, e e dugine xa. Haruna yi e yita Alatala ra se ralixin na, a yi Ala solona e xa alogo e xa sariɲan. ");
INSERT INTO yal_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Na xanbi ra, Lewi bɔnsɔnna muxune yi fa e wanla fɔlɔ Naralan Bubuni, Haruna nun a diine yamarin bun. E yi a liga Lewi bɔnsɔnna muxune xa alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Lewi bɔnsɔnna muxune luma ikiini: Xɛmɛn naxanye barin bata dangu ɲɛɛ mɔxɔɲɛn nun suulunna ra, ne xa fa walideni Naralan Bubuni. ");
INSERT INTO yal_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Koni, e na ɲɛɛ tonge suulunna sɔtɔ siimayaan na, e xa wanla dan. ");
INSERT INTO yal_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","E nɔɛ e ngaxakedenne maliyɛ nɛn walideni Naralan Bubuni, koni e yɛtɛɛn nama a wanla kɛ. I xa wanle taxu Lewi bɔnsɔnna muxune ra na kiini.” ");
INSERT INTO yal_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Alatala yi falan ti Musa xa Sinayi tonbonni, e minin ɲɛɛn firinden kike singeni Misiran yamanani. A yi a fala, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Isirayila kaane xa Halagi Tiin Dangu Lɔxɔn Sanla raba a waxatini. ");
INSERT INTO yal_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ɛ xa a liga kikeni ito xii fu nun naaninde lɔxɔn ɲinbanna ra, alo a fe yamarine nun a sariyane kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Musa yi na rali Isirayila kaane ma, a e xa Halagi Tiin Dangu Lɔxɔn Sanla raba. ");
INSERT INTO yal_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","E yi na liga kike singen xii fu nun naaninde ɲinbanna ra, Sinayi tonbonni. E yi a birin liga alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Koni, muxuna nde yi na naxanye bata yi e yiin din binbin na. E yi xɔsixi na lɔxɔni, e mi yi nɔɛ Halagi Tiin Dangu Lɔxɔn Sanla rabɛ. E yi siga Musa nun Haruna fɛma, ");
INSERT INTO yal_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","e yi a fala Musa xa, e naxa, “Nxu bata xɔsi binbin xɔn. Koni, nanfera nxu mi nɔɛ nxɔ saraxane bɛ Alatala xa alo Isirayila kaan bonne a waxatini?” ");
INSERT INTO yal_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa yi e yabi, a naxa, “Ɛ diɲa han n xa a kolon Alatala naxan yamarima ɛ fe yi.” ");
INSERT INTO yal_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","a a xa a fala Isirayila kaane xa, a naxa, “Xa ɛ tan nde hanma ɛ yixɛtɛna nde xɔsixi binbin xɔn, hanma xa e sa sigatini, a mɔn nɔɛ Halagi Tiin Dangu Lɔxɔn Sanla rabɛ nɛn Alatala xa. ");
INSERT INTO yal_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","E xa sanla raba kike firinden xii fu nun naaninde lɔxɔn ɲinbanna ra. E yɛxɛɛ diin don e nun buru ratetarene nun ɲɔxɔnde xɔlɛne. ");
INSERT INTO yal_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","E nama sese lu han xɔtɔnni, e nama a xɔnne yigira. E na Halagi Tiin Dangu Lɔxɔn Sanla raba, e xa a yamarine birin suxu. ");
INSERT INTO yal_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Koni xa muxuna nde tondi Halagi Tiin Dangu Lɔxɔn Sanla rabɛ a waxatini, anu a mi xɔsixi, a mi sigatini, a kedima nɛn Isirayila yamani, a to mi saraxan baxi Alatala xa a waxatini. Na kanna a yulubin goronna tongoma nɛn. ");
INSERT INTO yal_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Xɔɲɛn naxanye dɔxi ɛ tagi, xa ne wa Halagi Tiin Dangu Lɔxɔn Sanla raba feni Alatala xa, e lan e yi a sariyane nun a yamarine suxu. Sariyane lan birin xa, Isirayila kaan nun xɔɲɛna.” ");
INSERT INTO yal_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ala Batu Bubun ti lɔxɔn naxan yi, Layiri Sereya Bubuna, kundaan yi so a xun na. Keli ɲinbanna ma han xɔtɔnni, na kundaan yi dɛgɛma nɛn alo tɛɛna. ");
INSERT INTO yal_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Kundaan yi lu a xun ma, koni kɔɛɛn na, a yi lu alo tɛɛna. ");
INSERT INTO yal_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Na kundaan na yi ba bubun xun ma waxati yo yi, Isirayila kaane yi kelima nɛn sigadeni. Kundaan na ti dɛnaxan yi, Isirayila kaane yi e daaxadeni tɔn mɛnni. ");
INSERT INTO yal_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Isirayila kaane yi sigama Alatalaa yamarin nan ma, e mɔn yi e daaxadeni tɔnma Alatalaa yamarin nan ma. Fanni kundaan yi Ala Batu Bubun xun ma, e yi luma daaxadeni nɛn. ");
INSERT INTO yal_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Xa kundaan yi lu Ala Batu Bubun xun ma waxati xunkuye, Isirayila kaane yi Alatalaa yamarin suxuma nɛn. E mi yi sigama. ");
INSERT INTO yal_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Waxatina nde, kundaan yi luma nɛn Ala Batu Bubun xun ma xii dando. E yi luma daaxadeni Alatalaa yamarin nan ma, e yi sigama a yamarin nan ma. ");
INSERT INTO yal_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Waxatina nde kundaan yi luma nɛn yire kedenni keli ɲinbanna ma han na xɔtɔn bode, koni a na yi ba xɔtɔnni tun, e yi sigama nɛn. Kɔɛɛn nun yanyina, kundaan na yi ba, e fan yi kelima nɛn. ");
INSERT INTO yal_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Xa a lu Ala batu bubun xun ma xii firin hanma kike keden, hanma ɲɛɛ keden, Isirayila kaane yi luma nɛn daaxadeni. E mi sigɛ mumɛ, fɔ a na ba waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Isirayila kaane yi daaxama hanma e yi kelima daaxadeni Alatalaa yamarin nan ma. E yi Alatalaa yamarine suxuma, a naxanye fi e ma fata Musa ra. ");
INSERT INTO yal_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Xɔta firin nafala gbeti bɔnbɔxin na yamaan xili sena malanni e nun yamaan nakeli sena sigadeni. ");
INSERT INTO yal_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Na xɔta firinne na fe waxatin naxan yi, yamaan birin xa e malan i fɛma Naralan Bubun so dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Xa xɔta keden nan fe, mangane nan gbansan xa e malan i fɛma, Isirayila xabila xunne. ");
INSERT INTO yal_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Xa xɔtaan bata fe, bɔnsɔnna naxanye dɔxi Naralan Bubun sogetedeni, ne xa keli sigadeni. ");
INSERT INTO yal_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Xɔtaan na fe a firindeni, naxanye dɔxi yamaan daaxaden yiifari fɔxɔni, ne xa keli sigadeni. Xɔta xuiin nan yamaan nakelima sigadeni. ");
INSERT INTO yal_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Xɔtaan xa fe kii gbɛtɛ yi alogo yamaan xa e malan.” ");
INSERT INTO yal_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Saraxarali Harunaa diine nan lan e xɔtaan fe. Habadan sariyan nan na ra ɛ yixɛtɛne birin xa.” ");
INSERT INTO yal_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Ɛ na keli ɛ yaxune yɛngɛdeni naxanye ɛ ɲaxankatama ɛ yamanani, ɛ xa xɔtane fe. Alatala a yengi luma nɛn ɛ xɔn ma, ɛ Ala, a yi ɛ rakisi ɛ yaxune ma. ");
INSERT INTO yal_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ɛ xa xɔtaan fe ɲaxaɲaxa waxatine nun sali lɔxɔne nun kike nɛnɛ sanle birin yi, ɛ nɛma saraxa gan daxine nun bɔɲɛ xunbeli saraxane bɛ waxatin naxan yi. N yi n yengi lu ɛ xɔn. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Kike firinden xii mɔxɔɲɛdeni, e minin ɲɛɛ firindeni Misiran bɔxɔni, kundaan yi ba Layiri Sereya Bubun xun ma. ");
INSERT INTO yal_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Isirayila kaane yi kiraan suxu, e keli Sinayi tonbonni. Kundaan yi siga han a sa ti Paran tonbonni. ");
INSERT INTO yal_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","E keli singen nan yi na ra Alatalaa yamarin ma fata Musa ra. ");
INSERT INTO yal_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yuda bɔnsɔnna ganle nan singe kiraan suxu, e taxamasenna bun. E ganle yi Aminadabo a dii Naxason ma yamarin nan bun. ");
INSERT INTO yal_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Isakari bɔnsɔnna ganla yi Suwari a dii Natanɛli a yamarin nan bun. ");
INSERT INTO yal_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Sabulon bɔnsɔnna ganla yi Xelɔn ma dii Eliyabi a yamarin nan bun. ");
INSERT INTO yal_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ala Batu Bubun yi wayan, Gɛrisɔn yixɛtɛne nun Merari yixɛtɛne yi a xali e yii. ");
INSERT INTO yal_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Rubɛn bɔnsɔnna ganle yi siga e taxamasenna bun Sedewuri a dii Elisuri a yamarin bun. ");
INSERT INTO yal_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simeyɔn bɔnsɔnna ganla yi Surisadayi a dii Selumiyɛli a yamarin nan bun. ");
INSERT INTO yal_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gadi bɔnsɔnna ganla yi Dewuyɛli a dii Eliyasafi a yamarin nan bun. ");
INSERT INTO yal_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kehati xabilan muxune yi siga se sariɲanxine xalɛ Lewi bɔnsɔnna muxun bonne fɔxɔ ra alogo e xa Ala Batu Bubun ti benun se sariɲanxine xa yamaan daaxaden li. ");
INSERT INTO yal_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Efirami bɔnsɔnna ganle yi siga e taxamasenna bun Amixudi a dii Elisama yamarin nan bun. ");
INSERT INTO yal_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manase bɔnsɔnna ganla yi Pedasuri a dii Gamaliyɛli a yamarin nan bun. ");
INSERT INTO yal_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Bunyamin bɔnsɔnna ganla yi Gidewoni a dii Abidan ma yamarin nan bun. ");
INSERT INTO yal_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Dɔnxɛn na, Dan bɔnsɔnna ganle yi siga ganla bonne fɔxɔ rakantanɲɛ e taxamasenna bun, Amisadayi a dii Axiyeseri a yamarin bun. ");
INSERT INTO yal_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Aseri bɔnsɔnna ganle yi Okiran ma dii Pagiyɛli a yamarin nan bun. ");
INSERT INTO yal_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Nafatali bɔnsɔnna ganla yi Enan ma dii Axira yamarin nan bun. ");
INSERT INTO yal_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Isirayila ganle yi yɛbama na kii nin sigatini. ");
INSERT INTO yal_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa yi a fala Reyuli a dii Xobabi xa, Midiyan kaana, Musa bitanna, a naxa, “Nxu sigan yireni Alatala naxan fixi nxu ma. Fa nxu fɔxɔ ra, nxu fe faɲin ligɛ i xa, amasɔtɔ Alatala bata fe faɲine ragidi Isirayila ma.” ");
INSERT INTO yal_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobabi yi a yabi, a naxa, “Ɛn-ɛn. N xɛtɛma n konna nin n ma yamaan dɛnaxan yi.” ");
INSERT INTO yal_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa mɔn yi a fala, a naxa, “Yandi, i nama keli nxu fɛma. I daaxade faɲine kolon tonbonni. I luyɛ alo nxu yɛɛna. ");
INSERT INTO yal_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Xa i nxu mati, en birin nan Alatalaa se faɲine sɔtɔma.” ");
INSERT INTO yal_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Isirayila kaane yi keli Alatalaa geyani, e sigan ti xii saxan. Alatalaa Layiri Kankiraan yi tixi e yɛɛ ra alogo a xa matabu yirena nde fen e xa. ");
INSERT INTO yal_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Alatalaa kundaan yi e xun ma yanyin na, e to yi kelima daaxadeni. ");
INSERT INTO yal_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Layiri Kankiraan na yi keli sigadeni waxati yo yi, Musa yi a falama nɛn, a naxa, “Alatala, keli, i xa i yaxune raxuya ayi, i raɲaxu muxune yi e gi i yɛɛ ra!” ");
INSERT INTO yal_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Layiri Kankiraan yi tima waxatin naxan yi, Musa yi a falama nɛn, a naxa, “Alatala, fa Isirayila kaa wuli wuli wuyaxine tagi!” ");
INSERT INTO yal_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Lɔxɔna nde yamaan yi lu e mawugɛ e tɔrɔne fe ra. Alatala to na mɛ, a yi xɔlɔ, a yi tɛɛn nafa e tagi naxan yamaan daaxaden dɛ kinkina ndee gan. ");
INSERT INTO yal_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Yamaan yi sɔnxɔ Musa ra. Musa yi Alatala maxandi, tɛɛn yi tu. ");
INSERT INTO yal_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","E yi mɛnna xili sa Tabɛra, amasɔtɔ Alatalaa tɛɛn nagodo nɛn mɛnni. ");
INSERT INTO yal_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Lɔxɔna nde xɔɔyin yi muxu kobine suxu yamaan yɛ. Isirayila kaane yɛtɛɛn yi lu wugɛ, e naxa, “En suben don daxin sɔtɛ di? ");
INSERT INTO yal_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nxu nxu mirima yɛxɛne ma nxu naxanye don Misiran yi naxanye sare mi yi fima e nun kɔkunbane nun ɲanle nun sabi dɛɛne nun yabane nun sabi gbɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Iki nxu niin bata yiɲaxu nxu ma, donse yo mi toma fɔ Manna donseni ito!” ");
INSERT INTO yal_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna donseen yi luxi alo se xɔri xunxurin naxanye yɛɛ rafixa alo wudi igena. ");
INSERT INTO yal_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Yamaan yi minima na nan makɔdeyi, e yi a kunba gɛmɛn ma hanma e a din wunla kui. Na xanbi ra, e mɔn yi nɔɛ a ɲinɲɛ nɛn hanma e yi a gan burudine ra. A yi ɲaxun alo burun naxan gilinxi turen na. ");
INSERT INTO yal_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Manna donseen yi godoma kɔɛɛn nan na xiila godo waxatini. ");
INSERT INTO yal_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa yi Isirayila kaane mawuga xuiin mɛ, e yi malanxi denbaya yɛɛn ma e bubune so dɛɛne ra. Alatala yi xɔlɔ han! Musa fan yi kɔntɔfili, ");
INSERT INTO yal_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","a yi a fala Alatala xa, a naxa, “I n tɔrɔma nanfera? Nanfera n mi fa rafan i ma? Nanfera i yamani ito goronna dɔxi n tan xun ma? ");
INSERT INTO yal_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","N tan nan fudi tongoxi yamani ito ra ba? N tan nan e barixi ba? Nanfera i naxa a n xa itoe banba alo dii ngana, han na yamanani i bata e benbane tuli sa naxan na? ");
INSERT INTO yal_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","N suben sɔtɔn minɛn yi yamani ito birin xa? E wugama n fɔxɔ ra, e naxa, ‘Suben so nxu yii!’ ");
INSERT INTO yal_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","N kedenna mi nɔɛ yamani ito goronna tongɛ. A gbo n ma. ");
INSERT INTO yal_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Benun i xa ito liga n na, n faxa keden na! Xa n nafan i ma, i nama tin n xa n ma tɔrɔn to.” ");
INSERT INTO yal_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Alatala yi Musa yabi, a naxa, “Isirayila fonna muxu tonge solofere malan, i naxanye kolon Isirayila yamaan fonne nun kuntigine ra. I fa e ra Naralan Bubuni, alogo e xa ti i dɛxɔn mɛnni. ");
INSERT INTO yal_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","N godoma nɛn i fɛma mɛnni n falan ti i xa. N na n ma Nii Sariɲanxina ndedi bama nɛn i yi, n yi a sa e yi. Nayi, e nɔɛ i maliyɛ nɛn yamani ito goronna tongodeni alogo i kedenna nama fa a tongo. ");
INSERT INTO yal_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","I xa a fala yamaan xa, i naxa, ‘Ɛ ɛ yɛtɛ rasariɲan tilaa fe ra ɛ suben donma waxatin naxan yi. Alatala bata ɛ mawuga xuine mɛ ɛ to a fala, ɛ naxa, “En suben sɔtɔma di? Misiran yamanan nan fisa!” Iki, Alatala suben soma nɛn ɛ yii. Ɛ fan a donma nɛn. ");
INSERT INTO yal_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ɛ mi lɔxɔ keden hanma firin daxin sɔtɛ, hali xi suulun, xii fu, hanma xii mɔxɔɲɛ, ");
INSERT INTO yal_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","koni ɛ suben donma nɛn kike keden, han a mini ɛ ɲɔɛni, a raɲaxu ɛ ma. Amasɔtɔ ɛ bata ɛ mɛ Alatala ra naxan ɛ tagi, ɛ to wuga a yɛtagi, ɛ naxa: Nanfera nxu minixi Misiran yi?’ ” ");
INSERT INTO yal_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musa yi a fala, a naxa, “N tan be xɛmɛ wuli kɛmɛ sennin tagi naxanye sigatini e sanni, anu, i a falama, a i suben soma e yii nɛn kike keden! ");
INSERT INTO yal_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Xa nxu yɛxɛɛn nun siin nun ɲinge kurune birin faxa, ne a liyɛ ba? Xa nxu baan yɛxɛne birin suxu, ne a liyɛ ba?” ");
INSERT INTO yal_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Alatala yi a yabi, a naxa, “N sɛnbɛn go, na mi a liyɛ? I fama a todeni n naxan falaxi xa a ligɛ.” ");
INSERT INTO yal_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Musa yi mini, a yi a fala yamaan xa Alatala naxan falaxi. A yi Isirayila fonna muxu tonge solofere malan Naralan Bubun nabilinni. ");
INSERT INTO yal_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Alatala yi godo kundaan yiyani, e nun Musa yi falan ti. A yi a Nii Sariɲanxina ndedi ba Musa yi, a yi a ragodo fori tonge soloferene ma. Alaa Nii Sariɲanxin to godo e ma, e yi waliyiya falane ti fɔlɔ, koni e mi yanfan. ");
INSERT INTO yal_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Muxu firin, Elidadi nun Medadi, ne yi daaxadeni. E yi yatɛxi fonne ra, koni e mi siga Ala Batu Bubuni. Koni, Alaa Nii Sariɲanxin yi godo e fan ma, e yi waliyiya falane ti fɔlɔ daaxadeni. ");
INSERT INTO yal_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Banxulanna nde yi siga, a a fala Musa xa, a naxa, “Elidadi nun Medadi nabiya falane tima daaxadeni!” ");
INSERT INTO yal_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nunu a dii Yosuwe naxan yi Musa malima xabu a dii ɲɔrɛyani, na yi a xuini te, a naxa, “Musa, n kanna, e rati!” ");
INSERT INTO yal_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Musa yi a yabi, a naxa, “I e maxɔxɔlɔnma n xa nɛn ba? Alatala xa yamaan birin findi nabine ra! Ala xa a Nii Sariɲanxin nagodo e birin ma!” ");
INSERT INTO yal_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Nayi, Musa nun Isirayila fonne yi siga daaxadeni. ");
INSERT INTO yal_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Alatala yi foyen nafa keli baani, naxan fa dɔmɛne ra daaxadeni. E yi godo e sa e bode fari e mate ayi han nɔngɔnna yɛ firin, e siga sɛ daaxaden nabilinni han yanyi keden sigati. ");
INSERT INTO yal_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Yamaan yi fɛriɲɛn e suxɛ, e xi e suxɛ. Na xɔtɔn bode e mɔn yi fɛriɲɛn dɔmɛne suxɛ han birin yi e suxu han kilo wuli keden. E yi e sa daaxaden nabilinni alogo e xa xara. ");
INSERT INTO yal_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Koni suben mɔn yi Isirayila kaane dɛ, benun e xa a ragerun, Alatala yi xɔlɔ e ma, a yi fitina furen nagodo e ma. ");
INSERT INTO yal_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Nanara, e yi mɛnna xili sa Kibiroti-Hatawa. Amasɔtɔ xɔɔyidene maluxun mɛnna nin. ");
INSERT INTO yal_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Isirayila kaane yi keli Kibiroti-Hatawa yi, e yi siga Xaserɔti yi. ");
INSERT INTO yal_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Musa bata yi Kusi ɲaxanla dɔxɔ. Mariyama nun Haruna yi Musa mafala fɔlɔ a ɲaxanla fe ra. ");
INSERT INTO yal_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","E yi a fala, e naxa, “Alatala falan tiin Musa nan gbansan xɔn ba? A mi falan tima en fan xɔn ba?” Alatala yi e xuiin mɛ. ");
INSERT INTO yal_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Anu Musa yi findixi muxu yɛtɛ magodoxin nan na, a yɛtɛ magodoxi dangu birin na bɔxɔ xɔnna fari. ");
INSERT INTO yal_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Alatala yi a fala Musa nun Haruna nun Mariyama xa, a naxa, “Ɛ saxanna birin xa siga Naralan Bubuni!” E birin yi siga. ");
INSERT INTO yal_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Alatala yi godo kundaan yiyani, a yi ti Naralan Bubun so dɛɛn na, a yi Haruna nun Mariyama xili. E birin yi fa. ");
INSERT INTO yal_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Alatala yi a fala e xa, a naxa, “Ɛ tuli mati n xuiin na. Xa n ma nabina nde ɛ tagi, n na n yɛtɛ yitama a ra nɛn fe toone yi alo xiye. N yi falan ti a xa xiyene yi. ");
INSERT INTO yal_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Koni na kii mi a ra n ma walikɛɛn Musa xɔn. A tan nan tɔgɔndiyaxi n ma yamaan birin tagi. ");
INSERT INTO yal_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","N falan fixɛn tima a xa nɛn kɛnɛn nun kɛnɛn! Sandan mi a ra! A tan bata Alatala misaala to. Nayi, nanfera ɛ mi gaxuma n ma walikɛɛn Musa mafalɛ?” ");
INSERT INTO yal_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Alatala xɔlɔxin yi siga. ");
INSERT INTO yal_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Kundaan bama Naralan Bubun xun ma waxatin naxan yi, Mariyama bata yi mafixa gasi fure ɲaxine ra. Haruna yi a mato, furen ɲaxin bata mini a fatin ma. ");
INSERT INTO yal_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","A yi a fala Musa xa, a naxa, “N kanna, yandi, diɲa nxu hakɛn ma nxu naxan ligaxi xaxilitareyani! ");
INSERT INTO yal_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mariyama nama lu alo diin naxan faxaxi barixi, naxan fatin bata kun fɔlɔ a nga fatini.” ");
INSERT INTO yal_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Nayi, Musa yi a xuini te Alatala ma, a naxa, “E Ala! Yandi, a rakɛndɛya!” ");
INSERT INTO yal_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Alatala yi a yabi, a naxa, “Xa a baba yi a dɛ igen xuya a yɛtagi nun, a mi yi yagɛ xunsagi keden ba? A xa ramini daaxaden fari ma xii solofere. Na xanbi ra, a mɔn nɔɛ xɛtɛ nɛn.” ");
INSERT INTO yal_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Nayi, e yi Mariyama ramini daaxaden fari ma xunsagi keden. Isirayila kaane mi siga han a mɔn yi rasuxu. ");
INSERT INTO yal_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Na xanbi ra, e yi keli Xaserɔti yi, e yi daaxa Paran tonbonni. ");
INSERT INTO yal_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Fe rakɔrɔsine rasiga Kanan yamanan matodeni n naxan soma Isirayila kaane yii. Bɔnsɔn yo bɔnsɔn, manga keden xa siga.” ");
INSERT INTO yal_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Musa yi e rasiga Alatalaa yamarin ma, keli Paran tonbonni. Isirayila yɛɛratine nan yi e birin na. ");
INSERT INTO yal_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","E xinle ni itoe ra, Rubɛn bɔnsɔnna: Sakuru a diin Samuwa. ");
INSERT INTO yal_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeyɔn bɔnsɔnna: Xori a diin Safati. ");
INSERT INTO yal_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yuda bɔnsɔnna: Yefune a diin Kalebi. ");
INSERT INTO yal_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isakari bɔnsɔnna: Yusufu a diin Yigali. ");
INSERT INTO yal_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efirami bɔnsɔnna: Nunu a diin Hoseya. ");
INSERT INTO yal_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Bunyamin bɔnsɔnna: Rafu a diin Paliti. ");
INSERT INTO yal_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Sabulon bɔnsɔnna: Sodi a diin Gadiyɛli. ");
INSERT INTO yal_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yusufu a dii Manase bɔnsɔnna: Susi a diin Gadi. ");
INSERT INTO yal_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan bɔnsɔnna: Gemali a diina Amiyɛli. ");
INSERT INTO yal_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aseri bɔnsɔnna: Mikeli a diin Seturi. ");
INSERT INTO yal_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nafatali bɔnsɔnna: Fofisi a diin Naxabi. ");
INSERT INTO yal_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gadi bɔnsɔnna: Make a diin Gewɛli. ");
INSERT INTO yal_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Muxune xinle nan ne ra, Musa naxanye xɛ Kanan yamanan matodeni. Musa yi Nunu a dii Hoseya xili sa “Yosuwe.” ");
INSERT INTO yal_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa to yi e rasigama Kanan yamanan matodeni, a yi a fala e xa, a naxa, “Ɛ mini Negewi nin, siga geya yireni. ");
INSERT INTO yal_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ɛ xa yamanan mato. Ɛ a mato xa muxune sɛnbɛn gbo, xa a mi gbo, xa e wuya, xa e mi wuya. ");
INSERT INTO yal_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ɛ a mato xa e yamanan fan hanma xa a mi fan, xa e taane findixi banxidɛne nan na hanma xa yinne soxi e ma. ");
INSERT INTO yal_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ɛ a mato xa bɔxɔn fan, xa a mi fan, xa wudine na, xa e mi na. Ɛ yixɔdɔxɔ, ɛ fa yamanan wudi bogine ra.” Manpa bili bogi singene waxatin nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Nayi, e yi siga yamanan matodeni, keli Sini tonbonni siga han Rexobo yi, Lebo-Xamata dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","E yi so Negewi yi, e siga han Xebiron yi, Anaki bɔnsɔnna muxune yi dɔxi dɛnaxan yi, Aximan, Sɛsayi, e nun Talamayi. Xebiron bata yi ti ɲɛɛ solofere benun Soyan xa ti Misiran yamanani. ");
INSERT INTO yal_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","E yi siga han Esikoli lanbanni, e manpa bili yiin sɛgɛ tɔnsɔn keden yi singanxi naxan na. E na singan tami kuyen na alogo muxu firin xa a xali e nun girenada nun xɔdɛ bogina ndee. ");
INSERT INTO yal_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","E yi mɛnna xili sa “Esikoli lanbanna” tɔnsɔnna fe ra Isirayila kaane naxan sɛgɛ. ");
INSERT INTO yal_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Xii tonge naanin to dangu, e yi e xun xɛtɛ, sa keli yamana matoni. ");
INSERT INTO yal_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","E yi xɛtɛ Musa nun Haruna nun Isirayila yamaan fɛma Kadesi yi, Paran tonbonni. E yi e dɛntɛgɛ yamaan xa, e mɔn yi yamanan wudi bogine yita e ra. ");
INSERT INTO yal_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","E dɛntɛgɛni ito nan sa Musa xa, e naxa, “Nxu bata siga yamanani i nxu rasiga dɛnaxan yi. Ɲɔndi na a ra, nɔnɔn nun kumin gbo mɛnni! A bogina ndee ni i ra. ");
INSERT INTO yal_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Koni mɛn kaane sɛnbɛn gbo! Yinne soxi e taane ma, e gbo mumɛ! Nxu yɛtɛna Anaki bɔnsɔnna muxune toxi nɛn. ");
INSERT INTO yal_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalɛkine dɔxi Negewi yi. Xitine nun Yebusune nun Amorine dɔxi geya yireni. Kanan kaane dɔxi fɔxɔ igen dɛ e nun Yurudɛn baan xɔn.” ");
INSERT INTO yal_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalebi yi yamaan masabari Musa xa. A yi a fala, a naxa, “En siga yamanan suxudeni, amasɔtɔ en nɔɛ nɛn yati!” ");
INSERT INTO yal_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Koni fe rakɔrɔsi bonne yi a fala, e naxa, “En mi nɔɛ siyani itoe yɛngɛ, amasɔtɔ e sɛnbɛn gbo en xa.” ");
INSERT INTO yal_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","E yamanan naxan mato e na mafala fɔlɔ Isirayila kaane yɛ, e naxa, “Nxu fitina yamanan nan toxi! Mɛn kaane gbo mumɛ! ");
INSERT INTO yal_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nxu Nefilimi muxu magaxuxine nan toxi na! Nxu yi luxi nxu yɛtɛ yɛɛ ra yi alo suɲɛne. E fan nxu toxi na kii nin!” E na falaxi nɛn bayo Anaki bɔnsɔnna fataxi Nefilimi nan na. ");
INSERT INTO yal_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Isirayila kaane yi gbelegbele, e xi wugɛ. ");
INSERT INTO yal_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","E birin yi Musa nun Haruna mafala, yamaan birin yi a fala e xa, e naxa, “A fisa nxu yi faxa Misiran yi hanma tonbonni ito yi! ");
INSERT INTO yal_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nanfera Alatala faxi nxu ra yamanani ito yi alogo nxu xa faxa yɛngɛni? Nxɔ ɲaxanle nun nxɔ diine fama nɛn suxudeni yɛngɛni. A mi fisa en xa xɛtɛ Misiran yamanani ba?” ");
INSERT INTO yal_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","E yi lu a falɛ e bode xa, e naxa, “En yɛɛrati gbɛtɛ sugandi, en yi xɛtɛ Misiran yi!” ");
INSERT INTO yal_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musa nun Haruna yi e yɛtagin lan bɔxɔn ma Isirayila yamaan birin yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Nunu a dii Yosuwe nun Yefune a dii Kalebi, naxanye yi xɛxi fe rakɔrɔsine yɛ, ne yi e dugine yibɔ e ma sununi. ");
INSERT INTO yal_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","E yi a fala Isirayila yamaan birin xa, e naxa, “Nxu yamanan naxan matoxi, a fan han! ");
INSERT INTO yal_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Xa Alatala sa tin, a tiyɛ nɛn en yɛɛ ra siga na yamanani kumin nun nɔnɔn gbo dɛnaxan yi, a yi a so en yii! ");
INSERT INTO yal_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Koni ɛ nama murutɛ Alatala xili ma tun! Ɛ nama gaxu mɛn kaane yɛɛ ra, amasɔtɔ en fama e nɔdeni nɛn fefe! E kantan seen bata e rabeɲin, anu Alatala en tan xɔn. Nayi, ɛ nama gaxu e yɛɛ ra.” ");
INSERT INTO yal_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Koni, yamaan birin yi a falama a e xa e magɔlɔn e yi e faxa. Nanunna, Alatala nɔrɔn yi godo Naralan Bubuni Isirayila kaane birin yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Alatala yi a fala Musa xa, a naxa, “Yamani ito luma n naɲaxuɛ han waxatin mundun? E tondima dɛnkɛlɛyɛ n ma han waxatin mundun yi, hali n to bata kabanako fe wuyaxi liga e tagi? ");
INSERT INTO yal_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","N fitina furen nafama nɛn e ma, n yi e raxɔri. Koni n ni i tan findima nɛn siya gbeen na, naxan sɛnbɛn gbo e xa.” ");
INSERT INTO yal_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa yi Alatala yabi, a naxa, “Koni Misiran kaane a fe mɛma nɛn, bayo i yamani ito raminixi e tagi i sɛnbɛn nan xɔn. ");
INSERT INTO yal_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","E fama nɛn na faladeni be kaane xa. E bata yi a mɛ nun, a i tan, Alatala, i yamani ito xɔn. E bata a kolon a yamani ito i toma yɛɛ nun yɛɛ bayo i nɔrɔn luma e xun ma alo kundaan yiyana. Yanyin na, i ti e yɛɛ ra kundani. Kɔɛn na, i ti alo tɛɛna. ");
INSERT INTO yal_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Xa i yamani ito raxɔri sanɲa yi kedenni, siya gbɛtɛn naxanye birin a fe mɛma, ne a falama nɛn, e naxa, ");
INSERT INTO yal_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Alatala e tuli sa bɔxɔn naxan na, a mi nɔxi e xalɛ mɛnni, na nan a ligaxi a e faxaxi burunna ra.’ ");
INSERT INTO yal_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Nayi, Marigina, i sɛnbɛ gbeen mayita alo i bata naxan fala nxu xa, i naxa, ");
INSERT INTO yal_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","fa fala Alatala mi xɔlɔn xulɛn, a hinanna gbo, a diɲan hakɛn nun matandin bun. Koni, a mi yulubi kanna yatɛma tinxinden na mumɛ! A fafane hakɛn saranma nɛn e diine ra han mayixɛtɛ saxan hanma naanin. ");
INSERT INTO yal_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ala, bayo i ya hinanna gbo, i mɔn xa diɲa i ya yamaan hakɛn ma, alo i e mafeluxi kii naxan yi xabu e sa mini Misiran yamanani han iki.” ");
INSERT INTO yal_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Alatala yi a fala, a naxa, “N bata e mafelu alo i a falaxi kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Koni, habadan Alatala nan n na, n nɔrɔn bɔxɔn birin nafexi, nayi, n bata n kɔlɔ n yɛtɛni: ");
INSERT INTO yal_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Naxanye birin bata n tan nɔrɔn nun n ma kabanako feene to Misiran yi e nun tonbonni, naxanye birin bata n mato bunbani sanɲa yi fu, e tondi n xuiin mɛ, ");
INSERT INTO yal_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ne sese mi na bɔxɔn toma n na e benbane tuli saxi naxan na. Ne sese mi a toɛ naxanye bata n naɲaxu. ");
INSERT INTO yal_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Koni bayo xaxili gbɛtɛ luxi nɛn n ma walikɛɛn Kalebi yi, a n fɔxɔ ra waxatin birin, n na a xalima nɛn na yamanani, a sigaxi naxan matodeni, n yi a so a yixɛtɛne yii e kɛɛn na. ");
INSERT INTO yal_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Bayo Amalɛkine nun Kanan kaane dɔxi lanbanne yi, nayi tila ɛ xɛtɛ, ɛ siga Gbala Baan kiraan xɔn tonbonna binni.” ");
INSERT INTO yal_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Alatala yi a fala Musa nun Haruna xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Yama ɲaxini ito luma n mafalɛ han waxatin mundun yi? N bata Isirayila kaane mawuga xuiin mɛ, e n mafala. ");
INSERT INTO yal_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","A fala e xa, i naxa, ‘Alatalaa falan ni ito ra. Habadan Ala nan n tan na. N bata n kɔlɔ n yɛtɛni, n na a rabama ɛ ra nɛn alo n na a mɛxi ɛ ra kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Naxanye birin barin bata dangu ɲɛɛ mɔxɔɲɛn na, naxanye tɛngɛ, naxanye birin bata n mafala, ɛ faxama nɛn tonbonni ito yi. ");
INSERT INTO yal_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ɛ sese mi soma yamanani, n bata yi ɛ tuli sa naxan na nun, a ɛ dɔxɔma nɛn na, fɔ Yefune a dii Kalebi nun Nunu a dii Yosuwe. ");
INSERT INTO yal_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ɛ diine tan, ɛ a falaxi naxanye ma, a e suxuma nɛn yɛngɛni, n ne nan xalima na yamanani ɛ ɛ mɛxi naxan na, e yi dɔxɔ na. ");
INSERT INTO yal_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Koni ɛ tan faxama nɛn tonbonni ito yi. ");
INSERT INTO yal_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ɛ diine e xuruseene rabama nɛn ɲɛɛ tonge naanin tonbonni, e yi ɛ tinxintareyaan goronna tongo, han ɛ birin yi findi binbine ra tonbonni. ");
INSERT INTO yal_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ɛ xii tonge naanin nan tixi yamanani ito matodeni. Nayi, ɛ ɲɛɛ tonge naanin nan tima ɛ yulubine goronna bun, lɔxɔ keden, ɲɛɛ keden. Nayi, ɛ a kolonma nɛn a n bata keli ɛ xili ma.’ ");
INSERT INTO yal_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","N bata falan ti, n tan Alatala. N fama na nan ligadeni yama ɲaxini ito ra, naxan murutɛxi n xili ma. E birin ɲanma nɛn tonbonni ito yi, e faxa.” ");
INSERT INTO yal_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Musa muxun naxanye rasiga yamanan matodeni, naxanye yamanan mafala ɲaxi ra, e yamaan nadin a xili ma, ");
INSERT INTO yal_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ne yi faxa. Alatala nan e faxa furen na, bayo e fala ɲaxin ti lan yamanana fe ma. ");
INSERT INTO yal_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Naxanye siga yamanan matodeni, Nunu a dii Yosuwe nun Yefune a dii Kalebi nan tun lu e nii ra. ");
INSERT INTO yal_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa to Alaa falane birin nali Isirayila kaane ma, e yi nimisa sɔxɔlɛni. ");
INSERT INTO yal_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Nanara, na xɔtɔn bode, subaxa, e yi kiraan suxu siga geya yireni, e yi a falɛ, e naxa, “En bata keli. En siga na yireni Alatala naxan ma fe falaxi. En bata yulubin liga!” ");
INSERT INTO yal_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Musa yi e maxɔdin, a naxa, “Nanfera ɛ Alatalaa yamarin matandima? Feni ito mi sɔnɔyama! ");
INSERT INTO yal_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Alatala mi luma ɛ xɔn, nayi ɛ nama siga. Ɛ yaxune nama ɛ nɔ. ");
INSERT INTO yal_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amasɔtɔ Amalɛkine nun Kanan kaane ɛ yɛɛ ra, e fama nɛn ɛ faxadeni yɛngɛni. Ɛ bata ɛ xun xanbi so Alatala yi, a mi luyɛ ɛ xɔn.” ");
INSERT INTO yal_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","E yi kankan na ma, e yi te geya yireni, koni Alatalaa Layiri Kankiraan nun Musa lu nɛn daaxadeni. ");
INSERT INTO yal_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Na xanbi ra, Amalɛkine nun Kanan kaane yi godo geyane fari e yi dɔxi dɛnaxanye yi. E yi Isirayila kaane nɔ, e siga e faxɛ han Xoroma yi. ");
INSERT INTO yal_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","a xa a fala Isirayila kaane xa, a naxa, “N yamanan naxan soxi ɛ yii, ɛ na dɔxɔ mɛnni, ");
INSERT INTO yal_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ɛ yi ɲingene hanma siine hanma yɛxɛɛne rali Alatala ma tɛɛn na, saraxa gan daxin na hanma naxan dɛ tiin nakamalima hanma ɲɛnige ma saraxane, hanma sali lɔxɔne gbeene, a xirin nafanma nɛn Alatala ma. ");
INSERT INTO yal_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Naxan na fa a saraxan na Alatala yɛtagi, a xa fa bogise saraxan fan na: murutu fuɲi kilo saxan naxan namulanxi turen litiri keden nun a tagi ra. ");
INSERT INTO yal_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Xa i fa yɛxɛɛ diin na saraxa gan daxin na hanma saraxa gbɛtɛ, i xa wudi bogi igen litiri keden e nun a tagi ba minse saraxan na. ");
INSERT INTO yal_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Xa kontonna na a ra, murutu fuɲin kilo sennin naxan namulanxi ture litiri firinna ra, na nan bogise saraxan na, ");
INSERT INTO yal_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","e nun wudi bogi igen litiri firin minse saraxan na. A ba alogo a xirin xa rafan n tan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Xa tura bulanna nan bama n xa saraxa gan daxin na hanma saraxan naxan dɛ tiin nakamalima, hanma bɔɲɛ xunbeli saraxana Alatala xa, ");
INSERT INTO yal_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","murutu fuɲin kilo solomanaanin namulanxin turen litiri saxanna, na nan bogise saraxan na. ");
INSERT INTO yal_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","I mɔn xa fa wudi bogi igen litiri saxan na minse saraxan na. Saraxan na a ra naxan nalima Alatala ma tɛɛn na, a xirin nafan a ma.” ");
INSERT INTO yal_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“Ɲingene hanma kontonne hanma yɛxɛɛne hanma sii diine, e bama na kii nin. ");
INSERT INTO yal_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Xuruseene na wuya kiki, e keden kedenna birin lan nɛn e ba e nun bogise saraxane. ");
INSERT INTO yal_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Isirayila bari diine birin xa a liga na kii nin, e nɛma saraxane raliyɛ tɛɛn na, naxanye xirin nafan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Xɔɲɛn naxanye dɔxi yamanani hanma naxanye danguma ɛ konni hanma naxanye denbaya bata bu na, ne fan na keli saraxa ralideni Alatala ma tɛɛn na naxan xiri rafan a ma, e xa a liga na kii kedenni. ");
INSERT INTO yal_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Sariyane lan yamaan muxune birin xa, ɛ tan Isirayila bari diine alo xɔɲɛne. Habadan sariyan na a ra ɛ yixɛtɛne birin xa. Ɛ nun xɔɲɛne birin keden Alatala yɛɛ ra yi. ");
INSERT INTO yal_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Sariyane nun yamarine birin lan ɛ nun xɔɲɛne birin xa, naxanye dɔxi ɛ tagi.” ");
INSERT INTO yal_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","a xa a fala Isirayila kaane xa, a naxa, “Ɛ na so yamanani, n na ɛ xalin dɛnaxan yi, ");
INSERT INTO yal_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ɛ nɛma na yamanan donseen donɲɛ, ɛ xa saraxan ba a ra Alatala xa. ");
INSERT INTO yal_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ɛ na ɛ murutu singene din, ɛ yi burudi singen nafala, ɛ na rali n ma saraxan na keli lonna ma. ");
INSERT INTO yal_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Nayi, ɛ xa burudi singen nali Alatala ma saraxan na waxati famatɔne birin yi.” ");
INSERT INTO yal_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Xa ɛ tantan, ɛ mi yamarini ito nde liga, Alatala naxan falaxi Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","a na findi Alatala yamari yo ra a naxan fixi ɛ ma fata Musa ra, fɔlɔ na lɔxɔn ma a fixi naxan yi han waxati famatɔne yi, ");
INSERT INTO yal_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","xa ɛ a ligaxi tantanna nin, yamaan mi a kolon, nayi yamaan birin xa tura bulanna ba saraxa gan daxin na, naxan xiri rafan n tan Alatala ma, e nun bogise saraxan nun minse saraxan naxan lanɲɛ sariyan ma, e nun kɔtɔ keden yulubi xafari saraxan na. ");
INSERT INTO yal_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Saraxaraliin xa Ala solona Isirayila yamaan birin xa, e yi mafelu. Amasɔtɔ tantanna nan yi a ra, e mɔn bata saraxan nali Alatala ma tɛɛn na, e nun yulubi xafari saraxan na e tantanna fe ra. ");
INSERT INTO yal_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Isirayila yamaan nun xɔɲɛn naxanye e tagi, e birin mafeluma nɛn, amasɔtɔ e birin yi na tantanna kui.” ");
INSERT INTO yal_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Xa muxu kedenna nan yulubin ligaxi tantanni, a xa sii gilɛn ɲɛɛ kedenna ba yulubi xafari saraxan na. ");
INSERT INTO yal_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Saraxaraliin xa Alatala solona na kanna xa naxan yulubin ligaxi tantanni, a mafeluma nɛn. ");
INSERT INTO yal_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Isirayila bari diine nun xɔɲɛn naxanye e tagi, naxan na yulubin liga tantanni, na sariya kedenna lan ne birin xa. ");
INSERT INTO yal_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Koni xa Isirayila bari diin hanma xɔɲɛna a rakeli a ma, a yulubin liga, na bata Alatala rayelefu, a kedima nɛn yamani. ");
INSERT INTO yal_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","A bata Alatalaa falan naɲaxu, a a yamarine kala. A xa kedi yamani, a yulubin goronna luma a tan nan ma.” ");
INSERT INTO yal_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Isirayila kaane yi tonbonni waxatin naxan yi, e muxuna nde to yege fenni Matabu Lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","E yi a xali Musa nun Haruna fɛma, e nun yamaan birin. ");
INSERT INTO yal_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","E yi a ramara ki faɲi, alogo sariyan xa sa a yulubin saran feen na a ra. ");
INSERT INTO yal_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Nayi, Alatala yi a fala Musa xa, a naxa, “Muxuni ito xa faxa. Yamaan birin xa a magɔlɔn gɛmɛn na daaxaden fari ma.” ");
INSERT INTO yal_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","E yi na kanna xali daaxaden fari ma, e yi a magɔlɔn han a faxa alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","a xa a fala Isirayila kaane xa, a naxa, “Ɛ ɛ domane rayabu luti dɛnbɛxine ra, ɛ yi e singan ɛ domane dɛ kinkine ra gari mamiloxine ra waxati famatɔne birin yi. ");
INSERT INTO yal_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ɛ na luti dɛnbɛxine to, Alatalaa yamarine birin nabirama ɛ ma nɛn, ɛ yi e liga. Nayi, ɛ mi birɛ ɛ bɔɲɛn nun ɛ yɛɛne kunfa feene fɔxɔ ra, naxanye tinxintareyaan liga Ala ra. ");
INSERT INTO yal_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Nayi, ɛ xaxili luma nɛn n ma yamarine birin xɔn, ɛ yi e suxu, ɛ yi sariɲan ɛ Ala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Alatala nan n tan na, ɛ Ala, naxan ɛ raminixi Misiran yamanani alogo n xa findi ɛ Ala ra. Alatala nan n tan na, ɛ Ala.” ");
INSERT INTO yal_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Xɛmɛna nde yi keli naxan yi xili Kora, Yisehari a diina. Lewi a dii Kehati mamandenna. E nun Rubɛn bɔnsɔnna muxuna ndee nan yi a ra naxanye yi xili Datan nun Abirami, Eliyabi a diine, e nun Hon, Pɛlɛti a diina. ");
INSERT INTO yal_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","E nun Isirayila kaan muxu kɛmɛ firin tonge suulun yi keli Musa xili ma, e birin xili kan yamaan fonne tagi. ");
INSERT INTO yal_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","E yi e malan Musa nun Haruna xili ma, e yi a fala e xa, e naxa, “Ɛ bata a radangu ayi! Yamaan muxune birin sariɲan. Alatala e birin tagi. Nanfera ɛ yɛtɛ yitema Alatala yamaan ma?” ");
INSERT INTO yal_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musa to na falane mɛ, a yi a yɛtagin lan bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","A yi a fala Kora nun a muxune xa, a naxa, “Tila xɔtɔnni, Alatala a yitama nɛn, a gbeen naxan na e nun naxan sariɲan, naxan lan a siga a fɛma. A naxan sugandixi, a na kanna luma nɛn, a yi a maso a ra. ");
INSERT INTO yal_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Nayi, Kora, ɛ nun i ya muxune birin xa ito liga: ɛ wusulan gan seene tongo. ");
INSERT INTO yal_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Tila ɛ tɛɛn sa e kui, ɛ wusulanna sa a fari Alatala yɛtagi. Alatala na naxan sugandi, na nan sariɲan. Ɛ tan Lewi bɔnsɔnna muxune bata a radangu ayi!” ");
INSERT INTO yal_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa mɔn yi a fala Kora xa, a naxa, “Ɛ tuli mati, ɛ tan Lewi bɔnsɔnna muxune! ");
INSERT INTO yal_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Na mi ɛ wasɛ a Isirayilaa Ala bata ɛ sugandi Isirayila kaan bonne tagi, a yi ɛ maso a ra, alogo ɛ xa wali a xa Alatala batu bubuni, ɛ yi ti Isirayila yamaan yɛɛ ra ɛ yi e mali Ala batu feen na? ");
INSERT INTO yal_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","A bata ɛ maso a ra, ɛ nun Lewi bɔnsɔnna muxune birin. Koni, ɛ mɔn kataxi, a xa ɛ findi saraxaraline ra! ");
INSERT INTO yal_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ɛ nun i ya muxune bata ɛ malan Alatala xili ma. Nde Haruna ra feni ito yi ɛ to a mafalama?” ");
INSERT INTO yal_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Na xanbi ra, Musa yi muxuna nde rasiga Datan nun Abirami xilideni, Eliyabi a diine, koni e yi a yabi, e naxa, “Nxu mi fama! ");
INSERT INTO yal_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Na mi i wasaxi ba, i to bata nxu ramini Misiran yamanani kumin nun nɔnɔn gbo dɛnaxan yi alogo i xa nxu faxa tonbonni? I mɔn waxi nxu ɲaxankata feen nin ba? ");
INSERT INTO yal_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","I mi faxi nxu ra bɔxɔ faɲi yi, kumin nun nɔnɔn gbo dɛnaxan yi! I mi xɛɛne nun manpa bili nakɔne soxi nxu yii nxu kɛɛn na mumɛ! I yengi a ma a i nxu mayendenma nɛn alo danxutɔne ba? Nxu mi fama!” ");
INSERT INTO yal_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Na yabin yi Musa xɔlɔ kati, a yi a fala Alatala xa, a naxa, “I nama tin e saraxane ra! Hali sofanla n mi a tongoxi e yii, n munma muxu yo hakɛ tongo e yɛ.” ");
INSERT INTO yal_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa yi a fala Kora xa, a naxa, “Ɛ nun i ya muxune birin xa fa Alatala yɛtagi tila e nun Haruna. ");
INSERT INTO yal_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ɛ birin xa wusulan gan seene tongo, ɛ yi wusulanna sa e kui, ɛ yi a yita Alatala ra. E birin malanxina, wusulan gan seen kɛmɛ firin tonge suulun. I tan nun Haruna fan xa ɛ wusulan gan seen yita Ala ra.” ");
INSERT INTO yal_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","E birin yi e wusulan gan seene tongo, e tɛɛn nun wusulanna sa e kui, e ti Naralan Bubun so dɛɛn na, Musa nun Haruna fɛma. ");
INSERT INTO yal_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora to a fɔxɔrabirane birin malan e xili ma Naralan Bubun so dɛɛn na, Alatala nɔrɔn yi godo yamaan birin yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Alatala yi a fala Musa nun Haruna xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Ɛ masiga yamani ito ra, alogo n xa e halagi iki sa!” ");
INSERT INTO yal_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Musa nun Haruna yi bira, e yi e yɛtagin lan bɔxɔn ma, e yi a fala, e naxa, “Ala, i tan nan niin saxi muxune birin yi, i xɔlɔma nɛn yamaan birin ma ba, anu muxu keden peen nan yulubin ligaxi?” ");
INSERT INTO yal_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“A fala yamaan xa, a e xa e masiga Kora nun Datan nun Abirami bubune ra.” ");
INSERT INTO yal_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa yi keli, a siga Datan nun Abirami binni, Isirayila fonne biraxi a fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","A yi a fala yamaan xa, a naxa, “Ɛ masiga yulubi kanni itoe bubune ra! Ɛ nama ɛ yiin din e yii se yo ra, alogo ɛ fan nama raxɔri e yulubine fe ra.” ");
INSERT INTO yal_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Nayi, yamaan yi e masiga Kora nun Datan nun Abirami bubune ra. Datan nun Abirami yi mini e bubune kui, e ti e dɛ ra, e nun e ɲaxanle nun e diine birin. ");
INSERT INTO yal_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa yi a fala, a naxa, “Ɛ fama a kolondeni a Alatala nan n nafaxi feni itoe birin ligadeni. N tan mi a ra. ");
INSERT INTO yal_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Xa muxuni itoe faxa alo muxune birin faxan kii naxan yi, xa e dunuɲa yi gidin lu alo adamane dari fena, nayi Alatala xa mi n nafaxi. ");
INSERT INTO yal_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Koni xa Alatala kabanako feen liga, xa bɔxɔni bɔ, a yi e nun e yii seene birin gerun, xa e ɲɛɲɛn siga laxira yi, ɛ a kolonma nɛn nayi fa fala muxuni itoe bata Alatala raɲaxu.” ");
INSERT INTO yal_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musa to yelin falan tiyɛ tun, bɔxɔn yi rabi e bun. ");
INSERT INTO yal_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","A yi a raxutu e ma e nun e denbayane, e nun muxun naxanye birin yi Kora fɔxɔ ra e nun e yii seene birin. ");
INSERT INTO yal_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","E ɲɛɲɛne yi siga laxira yi e nun e yii seene birin. Bɔxɔn yi e yɛ maluxun, e lɔ ayi Isirayila yamaan ma. ");
INSERT INTO yal_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","E to e gbelegbele xuiin mɛ, Isirayila kaan naxanye birin yi e rabilinni, ne yi e gi, e naxa, “Bɔxɔn nama en fan gerun de!” ");
INSERT INTO yal_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Alatala yi tɛɛn nagodo, a yi na muxu kɛmɛ firin tonge suulunne birin gan, naxanye fa wusulanna ra. ");
INSERT INTO yal_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“A fala saraxarali Harunaa dii Eleyasari xa, a a xa wusulan gan seene matongo tɛɛ wolonni, a yi tɛɛ wolonne woli ayi yire makuyeni. Amasɔtɔ na wusulan gan seene bata rasariɲan. ");
INSERT INTO yal_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ne yulubitɔ faxaxine gbee wusulan gan wurene xa findi wure dɛnfɛtɛnxine ra e sa saraxa ganden ma bayo e bata rali Alatala ma e yi findi se rasariɲanxin na. E findima taxamasenna nan na Isirayila kaane xa.” ");
INSERT INTO yal_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Muxun naxanye faxa tɛɛni, saraxaralina Eleyasari yi ne gbee sulan wurene malan, a yi e bɔnbɔ han e dɛnfɛtɛn, a e sa saraxa ganden ma. ");
INSERT INTO yal_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Na taxamasenna yi na feen nabirama nɛn Isirayila kaane ma alogo muxu yo nama wusulanna gan Alatala yɛtagi fɔ Haruna yixɛtɛna nde alogo e nama liga alo Kora nun a muxune. A yi liga alo Alatala a fala e xa fata Musa ra kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Na xɔtɔn bode, Isirayila yamaan birin yi lu Musa nun Haruna mafalɛ, e naxa, “Ɛ bata Alatala yamaan faxa.” ");
INSERT INTO yal_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Koni, Isirayila kaane to e malan Musa nun Haruna xili ma, e yi Naralan Bubun binna mato, nanunna, kundaan yi godo a ma, Alatala nɔrɔn yi mini kɛnɛnni. ");
INSERT INTO yal_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Musa nun Haruna yi fa Naralan Bubun yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","“Ɛ masiga yamani ito ra alogo n xa e raxɔri keden na.” Musa nun Haruna yi bira, e yi e yɛtagin lan bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa yi a fala Haruna xa, a naxa, “I ya wusulan gan seen tongo, i wusulanna sa a kui e nun tɛɛ wolonna keli saraxa ganden ma. I i mafura, i siga Ala solonadeni yamaan xa. Alatala xɔlɔn bata yihadin nafa. Fitina furen bata fɔlɔ.” ");
INSERT INTO yal_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Musa naxan fala Haruna yi na liga, a yi a gi yamaan tagi, fitina furen bata yi fɔlɔ dɛnaxan yi. A yi wusulanna gan, a Ala solona e xa. ");
INSERT INTO yal_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","A yi ti faxa muxune nun a ɲɛɲɛne tagi. Nayi, fitina furen yi dan. ");
INSERT INTO yal_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Muxu wuli fu nun naanin kɛmɛ solofere yi faxa, e sa Kora a muxu faxaxine yatɛn fari. ");
INSERT INTO yal_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Yihadin to ɲan, Haruna yi xɛtɛ Musa fɛma Naralan Bubun so dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","“Falan ti Isirayila kaane birin xa, bɔnsɔnne mangane birin xa dungan keden so i yii. I dungan fu nun firin nan tongoma. Birin xinla xa sɛbɛ a dunganna ma. ");
INSERT INTO yal_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Fɔ Lewi bɔnsɔnna, i xa Haruna xinla sɛbɛ na ma. Nayi, dungan keden bɔnsɔn manga keden. ");
INSERT INTO yal_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","I xa na dunganne sa Naralan Bubuni, Layiri Kankiraan yɛtagi n naralanma ɛ ra dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","N naxan sugandixi, na dunganna ɲingine minima a ma nɛn. Nayi, Isirayila kaane mafalan naxan tima ɛ xili ma, n yi na dan.” ");
INSERT INTO yal_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Musa yi falan ti Isirayila kaane xa, bɔnsɔn mangane birin yi dungan keden keden so a yii, dungan fu nun firin. Haruna gbeen yi na yɛ. ");
INSERT INTO yal_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Musa yi e sa Alatala yɛtagi Layiri Sereya Bubun kui. ");
INSERT INTO yal_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Na xɔtɔn bode, Musa to siga Layiri Sereya Bubuni, e yi a to a Haruna dunganna nan ɲingiye minixi, Lewi bɔnsɔnna gbeena, a mɔn fugaxi, a yi Amandi bogi mɔxine ramini! ");
INSERT INTO yal_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Musa yi dunganne birin tongo Alatala fɛma bubuni a e yita Isirayila kaane ra. Birin yi e to, birin yi a gbeen tongo. ");
INSERT INTO yal_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Alatala yi a fala Musa xa, a naxa, “Harunaa dunganna xali Layiri Kankiraan yɛtagi. A xa lu mɛnni taxamasenna ra muxu murutɛxine xa alogo e mafalane xa dan n yɛtagi alogo e nama faxa.” ");
INSERT INTO yal_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Musa yi a liga alo Alatala a yamari a ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Isirayila kaane yi a fala Musa xa, e naxa, “I mi a to, nxu faxamatɔɔn na a ra! Nxu halagima nɛn! Nxu birin halagima nɛn! ");
INSERT INTO yal_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Naxan yo na a maso Alatala Batu Bubun na, na kanna faxama nɛn! Nxu birin faxama nɛn ba?” ");
INSERT INTO yal_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Alatala yi a fala Haruna xa, a naxa, “Xa yire sariɲanxin wanla kala, i tan nun i ya diine nun Lewi bɔnsɔnna muxune, ɛ tan nan a yulubin goronna tongoma. Koni xa saraxarali wanla nan kala, ɛ nun i ya diine nan gbansanna na yulubin goronna tongoma. ");
INSERT INTO yal_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","I ngaxakedenne maso i ra, Lewi bɔnsɔnna muxune, alogo e xa sa ɛ fari, e ɛ mali, ɛ nun i ya diine nɛma ɛ saraxarali wanla kɛma Layiri Sereya Bubun yɛtagi waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","E xa ɛ yamarine suxu, e yi e yengi lu bubun wanle birin xɔn. Koni e nama e maso yire sariɲanxin muranne ra hanma saraxa gandena, alogo ɛ birin nama faxa ɛ bode xɔn. ");
INSERT INTO yal_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","E sama ɛ fari nɛn walideni, e yi e yengi lu Naralan Bubun xɔn e nun a wanle birin. Muxu gbɛtɛ yo nama sa ɛ fari. ");
INSERT INTO yal_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ɛ tan yɛtɛɛn nan ɛ yengi dɔxɔma yire sariɲanxin nun saraxa ganden xɔn alogo Isirayila kaane xa ratanga n ma xɔlɔn ma. ");
INSERT INTO yal_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ɛ mato, n bata ɛ ngaxakeden Lewi bɔnsɔnna muxune sugandi Isirayila kaan bonne yɛ n tan Alatala gbeen na. N bata e taxu ɛ ra alogo e xa Naralan Bubun wanle kɛ. ");
INSERT INTO yal_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Koni i tan Haruna nun i yixɛtɛne, ɛ tan nan gbansan na saraxarali wanla kɛma saraxa ganden yɛtagi e nun yire sariɲanxini yɛ masansan dugin xanbi ra. N tan nan na wanla soxi ɛ yii. Xa muxu gbɛtɛ a maso yire sariɲanxin na, ɛ xa a faxa.” ");
INSERT INTO yal_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Alatala yi a fala Haruna xa, a naxa, “N bata Isirayila kaane saraxane fi ɛ ma, e naxanye ralima n ma. N bata e so i yii i gbeen na e nun i yixɛtɛne birin han habadan. ");
INSERT INTO yal_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Naxan yo mi sama tɛɛni saraxa sariɲanxi fisamantenne yɛ, ɛ gbeen nan ne ra. Isirayila kaane fama naxan birin na, ɛ nun i ya diine gbeen nan ne ra: bogise saraxane nun yulubi xafari saraxane nun yangin saraxane. ");
INSERT INTO yal_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ɛ e don alo se sariɲanxi fisamantenne. Xɛmɛne nan e donma. Ɛ xa e yatɛ se sariɲanxine ra.” ");
INSERT INTO yal_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Naxanye bama Isirayila kaane se ralixine ra ɛ xa, ɛ gbeen nan ne fan na. N bata na so ɛ nun i ya dii xɛmɛne nun i ya dii tɛmɛne yii habadan! Ɛ denbayaan muxun naxanye mi xɔsixi sena nde xɔn, ne nɔɛ a donɲɛ nɛn. ");
INSERT INTO yal_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","N mɔn bata bɔxɔn bogise singene so ɛ yii: oliwi ture faɲin nun manpa faɲi nɛnɛne nun bogise gbɛtɛye, Isirayila kaane naxanye fima n tan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","E fama bɔxɔn bogise singen naxanye ra Alatala xa, ne findima nɛn ɛ gbeene ra. Ɛ denbayaan muxun naxanye mi xɔsixi sena nde xɔn, e nɔɛ a donɲɛ nɛn. ");
INSERT INTO yal_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Isirayila kaane na naxanye birin nali Ala ma kiseen na, ne yi findi ɛ gbeen na. ");
INSERT INTO yal_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Dii singen naxanye birin fixi Alatala ma, muxune nun subene, ɛ gbeen nan ne ra. Koni ɛ xa tin muxune nun sube haramuxine dii singene birin xa xunba gbetin na. ");
INSERT INTO yal_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Dii xɛmɛn kike kedenna xunba saren lanma gbeti gbanan suulun nan ma, naxan lanɲɛ yire sariɲanxin gbananna ma, naxan binya garamu fu. ");
INSERT INTO yal_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Koni, ɲingena, yɛxɛɛna, hanma siin dii singen mi xunbama bayo e sariɲan. Ɛ xa e wunla xuya saraxa ganden fari, ɛ yi e ture yirene rali Alatala ma tɛɛn na, naxan xiri rafan a ma. ");
INSERT INTO yal_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Na xanbi ra, ɛ gbeen nan e subene ra, alo se ralixine kankene nun e yiifari ma danbane findixi ɛ gbeen na kii naxan yi bɔɲɛ xunbeli saraxani. ");
INSERT INTO yal_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Nayi, Isirayila kaane saraxa sariɲanxin naxanye ralixi Alatala ma, n bata ne birin so ɛ nun i ya dii xɛmɛne nun dii tɛmɛne yii ɛ gbeen na waxatin birin. Habadan layirin na a ra Alatala yɛtagi, ɛ nun ɛ yixɛtɛne birin xa.” ");
INSERT INTO yal_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Alatala mɔn yi a fala Haruna xa, a naxa, “N yamanan naxan soxi Isirayila kaane yii, i mi bɔxɔ sɔtɔma na yi. N tan nan findima i gbeen na nafunla funfuni.” ");
INSERT INTO yal_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Ala mɔn yi a fala, a naxa, “N bata Isirayila birin yaganne so Lewi bɔnsɔnna muxune yii e kɛɛn na, e wali saranna ra, e naxan kɛma Naralan Bubuni. ");
INSERT INTO yal_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Isirayila kaan bonne nama fa e maso Naralan Bubun na, alogo e nama findi yulubi tongon na, e yi faxa. ");
INSERT INTO yal_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Lewi bɔnsɔnna muxune nan tun wanle kɛma Naralan Bubuni. Xa wanla kala, e tan nan a yulubin goronna tongoma. Habadan sariyan na a ra ɛ yixɛtɛne birin xa. Lewi bɔnsɔnna muxune mi bɔxɔ sɔtɔma alo Isirayila bɔnsɔnna bonne. ");
INSERT INTO yal_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Koni Isirayila kaane na yaganna naxanye fi Alatala ma, n na soma nɛn Lewi bɔnsɔnna muxune yii. Nanara, n na falaxi a e mi bɔxɔ sɔtɔma alo bɔnsɔnna bonne.” ");
INSERT INTO yal_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","a xa a fala Lewi bɔnsɔnna muxune xa, a naxa, “Isirayila kaane na fa yaganne ra ɛ xɔn, n naxan soxi ɛ yii ɛ kɛɛn na, ɛ fan xa na seene yaganna ba, ɛ yi a fi Alatala ma ɛ yaganna ra. ");
INSERT INTO yal_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Na luxi nɛn ɛ yii alo xɛɛ biin naxan bama a se xabaxine ra hanma a manpa nɛnɛne. ");
INSERT INTO yal_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Nayi, ɛ fan bata saraxan ba Alatala xa fata Isirayila kaane yaganne ra. Ɛ xa Alatala gbeen ba yaganne ra, ɛ yi a so saraxarali Haruna yii. ");
INSERT INTO yal_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Yagan sɔtɔxin naxan fan dangu a birin na, ɛ na nan fima Alatala ma a gbeen na. ");
INSERT INTO yal_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ɛ na a faɲi yiren fi, na yatɛma ɛ xa nɛn alo bonne naxan fima fata e se xabaxine ra hanma e manpa nɛnɛne. ");
INSERT INTO yal_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ɛ nun ɛ denbayane nɔɛ a dɔnxɛne donɲɛ nɛn dɛnaxan na ɛ kɛnɛn. Amasɔtɔ ɛ saranna na ra Naralan Bubun wanla kɛdeni. ");
INSERT INTO yal_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ɛ a faɲi yiren fi, alogo ɛ nama Isirayila kaane saraxa sariɲanxine raxɔsi n yɛɛ ra yi, alogo ɛ nama faxa.” ");
INSERT INTO yal_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Alatala yi a fala Musa nun Haruna xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ito nan daxa sariyan xɔn Alatala naxan yamarixi: A fala Isirayila kaane xa, a e xa fa ɲinge gilɛ gbeela ra i fɛma fɛ mi naxan na, xun xidi yegen munma xidi naxan xunna ma. ");
INSERT INTO yal_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","I xa a so saraxarali Eleyasari yii. A xa a xali daaxaden fari ma, e yi a kɔɛ raxaba a yɛɛ xɔri. ");
INSERT INTO yal_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleyasari xa a wunla nde tongo a yii sonla ra, a yi a xuya Naralan Bubun yɛtagi bɔxɔni dɔxɔɲa ma solofere. ");
INSERT INTO yal_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","E xa ɲinge gilɛn gbindin birin sa tɛɛni a yɛɛ xɔri e nun a kidin nun a suben nun a wunla e nun a gbiine. ");
INSERT INTO yal_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Saraxaraliin xa suman wudin nun hisopi wudin nun yɛxɛɛ xabe gari gbeela woli tɛɛni ɲinge gilɛn fari. ");
INSERT INTO yal_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Na xanbi ra, saraxaraliin xa a dugine xa, a yi a maxa benun a xa siga daaxadeni, koni a luma nɛn xɔsixi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Naxan ɲinge gilɛn sama tɛɛni na fan lan a yi a dugine xa, a yi a maxa, a luma nɛn xɔsixi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Muxun naxan mi xɔsixi, na xa ɲinge gilɛn xuben malan, a yi a sa yire sariɲanxina nde yi daaxaden fari ma. Isirayila yamaan xa a xuben namara marasariɲan igen nafala seen na. Yulubi xafari seen na a ra. ");
INSERT INTO yal_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Naxan na ɲinge gilɛn xuben makɔ, na fan lan a yi a dugine xa, a luma nɛn xɔsixi han ɲinbanna. A findima habadan sariyan nan na Isirayila kaane xa e nun xɔɲɛn naxanye dɔxi e tagi.” ");
INSERT INTO yal_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Naxan yo na a yiin din faxa muxun na, a xɔsixi han xunsagi keden. ");
INSERT INTO yal_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Xii saxanden nun xii soloferedeni, a xa a yɛtɛ rasariɲan na igen nan na, a yi sariɲan. Koni xa a mi a yɛtɛ rasariɲan xii saxanden nun xii soloferedeni, a mi sariɲanma. ");
INSERT INTO yal_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Naxan na a yiin din faxa muxun na, a tondi a yɛtɛ rasariɲanɲɛ, a bata Alatala Batu Bubun naxɔsi. Na kanna kedima nɛn Isirayila yi. Bayo marasariɲan igen mi xuyaxi a ma. A xɔsina a ma.” ");
INSERT INTO yal_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Sariyan ni i ra xa muxun faxa bubuna nde kui: Naxan na so na bubuni e nun naxanye yi na, ne xɔsixi xunsagi keden. ");
INSERT INTO yal_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Xa goronna nde na naxan dɛ mi ragalixi a faɲin na, a kui seene haramuxi. ");
INSERT INTO yal_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Naxan yo a yiin din muxu binbin na burunna ra, naxan faxaxi silanfanna ra hanma a faxa a yɛtɛ ma, hanma naxan yo a yiin din muxun xɔnne ra hanma gaburuna, na kanna luma nɛn xɔsixi han xii solofere. ");
INSERT INTO yal_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Muxu xɔsixin xa rasariɲan ikiini: ɲinge gilɛn naxan baxi yulubi xafarin na, na xubena nde nan tongoma, a yi sa igeni goronna kui. ");
INSERT INTO yal_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Muxu sariɲanxina nde xa hisopi wudi yiin tongo, a yi a sin igeni, a yi a xuya bubun ma muxun faxa dɛnaxan yi, e nun a kuiin birin e nun muxun naxanye yi a kui. A mɔn xa xuya na kanna ma naxan a yiin dinxi muxun xɔnne ra, hanma e muxun naxan faxaxi hanma naxan faxaxi a yɛtɛ ma hanma gaburuna. ");
INSERT INTO yal_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Muxun naxan sariɲan, na xa na igen xuya muxu xɔsixin ma xii saxande lɔxɔn nun xii soloferede lɔxɔni. A yi a rasariɲan xii soloferede lɔxɔni. A xa a dugine xa, a yi a maxa, ɲinbanna ra, a yi sariɲan. ");
INSERT INTO yal_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Koni xa muxun naxan xɔsixi, xa na tondi a rasariɲanɲɛ, a kedima nɛn Isirayila yamaan yɛ. Amasɔtɔ a bata Alatala yire sariɲanxin naxɔsi. Amasɔtɔ marasariɲan igen mi xuyaxi a ma, a luma nɛn xɔsixi. ");
INSERT INTO yal_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Habadan sariyan nan na ra e xa. Naxan na marasariɲan igen xuya gbɛtɛ ma, na kanna lan a yi a dugine xa. Naxan na a yiin din marasariɲan igen na a xɔsixi han ɲinbanna. ");
INSERT INTO yal_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Muxu xɔsixin na a yiin din sese ra, na haramuma nɛn. Naxan yo na a yiin din na se haramuxin na, na fan yɛtɛɛn xɔsixi han ɲinbanna.” ");
INSERT INTO yal_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Isirayila yamaan birin yi fa Sini tonbonni kike singen na, e dɔxɔ Kadesi yi. Mariyama faxa mɛnna nin, e yi a maluxun. ");
INSERT INTO yal_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Bayo igen bata yi ɲan yamaan yii, e yi e malan Musa nun Haruna xili ma. ");
INSERT INTO yal_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","E yi yɛngɛn fen Musa ra e naxa, “A yi fisa nun Alatala xa nxu fan faxa alo nxu lanfane! ");
INSERT INTO yal_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nanfera i faxi nxu ra tonbonni alogo nxu nun nxɔ xuruseene xa fa faxa be, nxu tan Alatalaa yamana? ");
INSERT INTO yal_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Nanfera i nxu raminixi Misiran yi, i fa nxu ra yire xɔdɛxɛni ito yi? Malo ba, xɔdɛ bili ba, manpa bili ba, girenada bogi ba, sese mi be. Hali igen min daxin yatigina, a mi be!” ");
INSERT INTO yal_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa nun Haruna yi keli yamaan fɛma, e yi siga Naralan Bubun so dɛɛn na, e bira, e yi e yɛtagin lan bɔxɔn ma. Alatala nɔrɔn yi godo e fɛma. ");
INSERT INTO yal_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“I ya dunganna tongo. Ɛ nun i tada Haruna xa yamaan malan. Ɛ xa falan ti fanyeni ito xa e yɛɛ xɔri, a igen naminima nɛn. I igen naminima nɛn yamaan xa fanyeni ito yi alogo e nun e xuruseene xa e min.” ");
INSERT INTO yal_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa yi dunganna tongo Alatalaa yire sariɲanxini, alo Ala a yamari kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","E nun Haruna yi yamaan malan fanyen dɛxɔn, Musa yi a fala e xa, a naxa, “Ɛ tan murutɛdene, ɛ tuli mati! Fɔ nxu xa igen namini ɛ xa fanyeni ito yi ba?” ");
INSERT INTO yal_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Musa yi a yiini te, a fanyen garin a dunganna ra sanɲa ma firin. Ige gbeen yi mini mafurɛn! Yamaan yi e min e nun e xuruseene. ");
INSERT INTO yal_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Koni Alatala yi a fala Musa nun Haruna xa, a naxa, “Bayo ɛ mi laxi n na, ɛ mi n binyaxi n ma sariɲanni Isirayila kaane yɛtagi, nanara, ɛ tan xa mi yamani ito xalima yamanani n naxan soxi e yii.” ");
INSERT INTO yal_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Meriba igene yi dɛnaxan yi, Isirayila kaane Alatala matandi nɛn mɛnni, e yi a kolon fa fala a sariɲan. ");
INSERT INTO yal_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa yi xɛrane rasiga Edɔn yi keli Kadesi yi, e naxa, “I ngaxakedenne, Isirayila kaane naxa, ‘Ɛ bata a kolon tɔrɔn naxanye birin nxu lixi. ");
INSERT INTO yal_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nxu benbane godo nɛn Misiran yi, nxu yi dɔxɔ na waxati xunkuye. Misiran kaane yi nxu tɔrɔ e nun nxu benbane. ");
INSERT INTO yal_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Koni nxu to Alatala maxandi, a yi nxu xuiin namɛ. A yi malekan nafa, a yi nxu ramini Misiran yi. Nxu bata fa Kadesi yi, taan naxan i ya bɔxɔn dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tin nxu xa i ya yamanani gidi. Nxu mi danguma xɛɛ bixine yi hanma manpa bili nakɔne yi. Nxu mi xɔɲin ige minɲɛ. Nxu birama kira gbeen nan fɔxɔ ra, nxu mi a fatama nxu yiifanna ma hanma nxu kɔmɛnna ma, han nxu yi i ya yamanan birin yigidi.’ ” ");
INSERT INTO yal_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edɔn kaane yi a yabi, e naxa, “Ɛ nama dangu nxu konni. Xa ɛ a liga, nxu ɛ yɛngɛma nɛn.” ");
INSERT INTO yal_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Isirayila kaane mɔn yi a yabi, e naxa, “Nxu tema kira gbeen nan xɔn! Xa nxu nun nxɔ xuruseene igena nde min ɛ konni, nxu a saren fiyɛ. Nxu waxi a xɔn ma nɛn, a nxu xa dangu nxu sanni ɛ konni gbansan!” ");
INSERT INTO yal_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","E mɔn yi a fala, e naxa, “Ɛ mi danguma!” Edɔn kaane yi mini e ralandeni e nun gali gbee sɛnbɛmana. ");
INSERT INTO yal_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Nayi, Edɔn kaane mi tin a Isirayila kaane xa dangu e yamanani. Isirayila kaane yi kira gbɛtɛ suxu. ");
INSERT INTO yal_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Isirayila yamaan birin yi keli Kadesi yi, siga Horo geyaan ma. ");
INSERT INTO yal_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Alatala yi a fala Musa nun Haruna xa Horo geyaan ma Edɔn yamanan danna ra, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Haruna sigamatɔɔn na a ra laxira yi. N yamanan naxan soxi Isirayila kaane yii, a mi soma na, amasɔtɔ ɛ murutɛ nɛn n ma yamarin ma Meriba igene yi. ");
INSERT INTO yal_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Nayi, Musa, i xa fa Haruna nun a dii Eleyasari ra Horo geyaan xuntagi. ");
INSERT INTO yal_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","I xa Harunaa saraxarali dugine ba a ma, i yi e ragodo a dii Eleyasari ma, bayo Haruna laxirayama mɛnna nin.” ");
INSERT INTO yal_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa yi Alatalaa yamarin suxu. E saxanna birin yi te Horo geyaan fari yamaan yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa yi Harunaa dugine tongo, a yi e ragodo Eleyasari ma. Haruna yi faxa mɛnni, geyaan xuntagi. Na xanbi ra, Musa nun Eleyasari yi godo geyaan ma. ");
INSERT INTO yal_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Isirayila yamaan to a kolon a Haruna bata yi faxa, e birin yi Haruna wuga xii tonge saxan. ");
INSERT INTO yal_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kanan Manga Aradi naxan yi dɔxi Negewi yi, na yi a mɛ a Isirayila fama Atarimi kiraan xɔn. A yi Isirayila yɛngɛ, a yi muxuna ndee suxu. ");
INSERT INTO yal_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Nayi, Isirayila kaane yi dɛ xuini ito tongo Alatala xa, e naxa, “Xa i nɔɔn fi nxu ma siyani ito xun na, nxu e taan birin naxɔrima nɛn fefe!” ");
INSERT INTO yal_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Alatala yi Isirayila kaane xuiin namɛ, a yi Kanan kaane lu e nɔɔn bun ma. Isirayila kaane yi e faxa, e yi e taane kala. E yi mɛnna xili sa Xoroma. ");
INSERT INTO yal_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Isirayila kaane yi keli Horo geyaan ma, e yi siga Gbala Baan kiraan xɔn alogo e xa Edɔn yamanan mabilin. Koni yamaan yi tondi kira yi. ");
INSERT INTO yal_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","E yi lu Ala nun Musa mafalɛ e naxa, “Nanfera i nxu raminixi Misiran yamanani alogo nxu xa fa faxa tonbonni ito yi? Donse mi be! Ige mi be! Nxu mi fa tɔrɔ donseni ito xɔn!” ");
INSERT INTO yal_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Nayi, Alatala yi saɲi xɔlɛne rasiga e xili ma, e Isirayila kaa wuyaxi xin, e faxa. ");
INSERT INTO yal_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Yamaan yi siga Musa fɛma, e yi a fala, e naxa, “Nxu bata yulubin liga nxu to ɛ mafala, i tan nun Alatala! Nayi, i xa Alatala maxandi a xa saɲi xɔlɛni itoe masiga nxu ra.” Musa yi Alatala maxandi yamaan xa. ");
INSERT INTO yal_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Alatala yi a fala Musa xa, a naxa, “Saɲi sawurana nde rafala, i yi a singan tami kuyena nde ra. Naxan yo xinxi, xa a na mato, a kisima nɛn.” ");
INSERT INTO yal_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Nayi, Musa yi sulan saɲin nafala, a yi a singan tami kuyen na. Nayi, saɲin muxun naxan xinxi, xa na kanna yi sulan saɲin mato, a kisima nɛn. ");
INSERT INTO yal_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isirayila kaane yi siga, e sa dɔxɔ Oboti yi. ");
INSERT INTO yal_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","E yi keli Oboti yi, e sa dɔxɔ Ye-Abarimi taa xɔnni tonbonni naxan Moyaba yɛtagi, a sogeteden binni. ");
INSERT INTO yal_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","E yi keli mɛnni, e sa dɔxɔ Serede lanbanni. ");
INSERT INTO yal_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","E yi keli mɛnni, e sa dɔxɔ Arinon baan dɛ, naxan danguma tonbonni Amorine konni. Arinon baan findixi Moyaba danna nan na, Moyaba nun Amorine tagi. ");
INSERT INTO yal_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Nanara, a sɛbɛxi Alatalaa Yɛngɛne Bukun kui, a naxa, “Wahebi taan naxan Sufa yamanani, e nun xudene, Arinon baana, ");
INSERT INTO yal_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","e nun a xudedine naxan tema Ari binni, na findixi Moyaba danna nan na.” ");
INSERT INTO yal_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","E yi keli mɛnni, e siga xɔɲin yireni. Alatala yi a fala Musa xa mɛnni, a naxa, “Yamaan malan n xa igen so e yii.” ");
INSERT INTO yal_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Awa, Isirayila kaane sigini ito sa mɛnna nin: Xɔɲinna, igen namini. En na a sigin nasuxu! ");
INSERT INTO yal_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Mangane bata xɔɲinna ge, yamaan yɛɛratine bata a raba e sɛnbɛn nun e mangaya dunganna ra! E yi keli tonbonni, e siga Matana yi, ");
INSERT INTO yal_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","E yi keli mɛnni, e siga Naxaliyɛli yi. E mɔn yi keli mɛnni, e siga Bamoti yi. ");
INSERT INTO yal_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","E yi keli Bamoti yi, e siga Pisiga geyaan lanbanni Moyaba yamanani tonbonna binni. ");
INSERT INTO yal_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isirayila kaane yi xɛrane rasiga a faladeni Sixɔn xa, Amorine Mangana, e naxa, ");
INSERT INTO yal_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Nxu waxi yamanani gidi feni. Nxu mi kiraan fatama, nxu siga xɛɛne yi hanma manpa bili nakɔne. Nxu mi xɔɲin ige minɲɛ. Nxu luun kira gbeen nan xɔn han nxu yi i ya yamanan birin yigidi.” ");
INSERT INTO yal_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Koni, Sixɔn mi tin e xa dangu a yamanani. A yi a sofane birin malan, e fa Isirayila kaane ralandeni tonbonni. E yi Isirayila yɛngɛ Yahasi yi. ");
INSERT INTO yal_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Isirayila kaane yi e nɔ, e yi e yamanan tongo, keli Arinon baani han Yaboko xudena siga han Amonine yamanan danna bayo Amonine yamanan danna yi makantanxi ki faɲi. ");
INSERT INTO yal_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isirayila yi Amorine taane birin tongo, e dɔxɔ e yi, e nun Xɛsibɔn taan nun a banxidɛne. ");
INSERT INTO yal_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Amasɔtɔ Xɛsibɔn yi findixi Amorine manga Sixɔn ma taan nan na, xabu a Moyaba manga fonna yɛngɛ, a yi a bɔxɔn birin tongo a yii han Arinon baana. ");
INSERT INTO yal_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Nanara, yenle naxa, Ɛ fa Xɛsibɔn yi! A mɔn xa ti. Sixɔn taan mɔn xa yitɔn! ");
INSERT INTO yal_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Amasɔtɔ tɛɛn bata mini Xɛsibɔn yi, Sixɔn taan bata tɛɛ dɛgɛn nafa, a yi Ari taan gan Moyaba yi, e nun mangane Arinon baan faxan na. ");
INSERT INTO yal_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Gbalona i xa Moyaba bɔxɔna! Ɛ bata halagi, Kemosi suxure batune! Ɛ banxulanne bata e gi, ɛ dii tɛmɛne bata findi suxu muxune ra, Amorine Manga Sixɔn yii. ");
INSERT INTO yal_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Koni en tan bata e bɔnbɔ. Xɛsibɔn bata kala siga han Dibon yi. En bata halagin ti siga han Nofa yi, siga han Medeba yi. ");
INSERT INTO yal_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Isirayila kaane yi dɔxɔ Amorine yamanani. ");
INSERT INTO yal_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa yi xɛrane rasiga Yaasɛri taan nakɔrɔsideni wundoni. Isirayila kaane yi na taan suxu e nun a banxidɛne, e yi Amorine kedi na. ");
INSERT INTO yal_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Na xanbi ra, e yi e firifiri, e siga Basan kiraan xɔn. Basan manga Ogo nun a sofa ganla birin yi mini e ralandeni alogo e xa e yɛngɛ Edere yi. ");
INSERT INTO yal_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Alatala yi a fala Musa xa, a naxa, “I nama gaxu a yɛɛ ra! N na a soma nɛn i yii, e nun a sofa ganla birin nun a yamanana. I xa a liga alo i Sixɔn liga kii naxan yi, Amorine mangan naxan yi dɔxi Xɛsibɔn yi.” ");
INSERT INTO yal_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Isirayila kaane yi Ogo faxa, e nun a diine nun a sofa ganla birin. E mi muxu yo lu a nii ra. E yi dɔxɔ a yamanani. ");
INSERT INTO yal_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Isirayila kaane yi siga, e sa dɔxɔ Moyaba mɛrɛmɛrɛne yi, Yurudɛn baan kidi ma Yeriko yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Siporo a dii Balaki yi a to Isirayila kaane naxan birin ligaxi Amorine ra. ");
INSERT INTO yal_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moyaba kaane yi gaxu Isirayila ganla yɛɛ ra, e yigitɛgɛ bayo e yi wuya han! ");
INSERT INTO yal_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moyaba kaane yi a fala Midiyan fonne xa, e naxa, “Yamani ito fama en nabilinna yamanane birin halagideni nɛn alo ɲingen sɛxɛn ɲanma kii naxan yi.” Siporo a dii Balaki nan yi Moyaba mangan na na waxatini. ");
INSERT INTO yal_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","A yi xɛrane rasiga Beyori a dii Balami xilideni Petori yi, Baa Gbeen dɛxɔn, a konna yi dɛnaxan na. E xa sa a fala a xa iki, e naxa, “Siyana nde bata mini Misiran yi, e bata wuya han e bɔxɔn nafe. E bata dɔxɔ n dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Yandi, fa, i fa siyani ito danga n xa, amasɔtɔ e sɛnbɛn gbo n xa. Nayi, waxatina nde n nɔɛ e yɛngɛ nɛn, n yi e kedi n ma yamanani. Amasɔtɔ n na a kolon, i na duba naxan xa, na duban sɔtɔma nɛn. I na naxan danga, na dangan sɔtɔma nɛn.” ");
INSERT INTO yal_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moyaba fonne nun Midiyan fonne yi siga e yi yiimatoon saranna xali e yii. E sa Balami fɛman li, e yi Balaki a falane yɛba a xa. ");
INSERT INTO yal_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","A yi e yabi, a naxa, “Ɛ xi be kɔɛni ito ra, n yi ɛ yabi xɔtɔnni alo Alatala na a fala n xa kii naxan yi.” Moyaba kuntigine yi lu Balami konni. ");
INSERT INTO yal_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ala yi fa Balami fɛma, a yi a fala a xa, a naxa, “Nde muxuni itoe ra naxanye i konni?” ");
INSERT INTO yal_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balami yi Ala yabi, a naxa, “Siporo a dii Balaki Moyaba mangan nan e rafaxi a faladeni n xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Siyana nde bata keli Misiran yi, e bata wuya han e bɔxɔn nafe. Nayi, yandi, fa n mali, i yi e danga n xa. Waxatina nde n nɔɛ e yɛngɛ nɛn, n yi e kedi.’ ” ");
INSERT INTO yal_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ala yi a fala Balami xa, a naxa, “I nama siga e fɔxɔ ra. I nama siyani ito danga, amasɔtɔ n bata barakan sa e fe yi.” ");
INSERT INTO yal_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balami to keli xɔtɔnni, a yi a fala Balaki a kuntigine xa, a naxa, “Ɛ xɛtɛ ɛ konni, amasɔtɔ Alatala mi tinxi n xa siga ɛ fɔxɔ ra.” ");
INSERT INTO yal_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moyaba kuntigine yi keli, e xɛtɛ Balaki fɛma, e yi a fala, e naxa, “Balami mi tinxi fɛ nxu fɔxɔ ra.” ");
INSERT INTO yal_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaki mɔn yi kuntigi gbɛtɛye rasiga naxanye yi wuya bonne xa, e binyen mɔn yi gbo e xa. ");
INSERT INTO yal_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","E yi sa Balami fɛman li. E yi a fala a xa, e naxa, “Siporo a dii Balaki naxa iki: ‘I nama tondi fɛ n konni de! ");
INSERT INTO yal_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Amasɔtɔ n ni i binyama nɛn han! I na naxan fala n na ligama nɛn. Yandi fa, i yi fa siyani ito danga n xa.’ ” ");
INSERT INTO yal_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balami yi Balaki a kuntigine yabi, a naxa, “Hali Balaki a banxin fi n ma naxan nafexi gbetin nun xɛmaan na, n mi nɔɛ Alatalaa yamarin matandɛ fefe ma, n ma Ala. ");
INSERT INTO yal_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Iki yandi, ɛ fan xa xi be to kɔɛni ito ra, n na a kolonɲɛ Alatala mɔn naxan falama n xa.” ");
INSERT INTO yal_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ala yi fa Balami fɛma kɔɛɛn na. A yi a fala a xa, a naxa, “Bayo muxuni itoe faxi i xiliden nin, keli, i yi siga e fɔxɔ ra. Koni n na naxan fala i xa, i xa na nan liga de!” ");
INSERT INTO yal_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Xɔtɔnni Balami yi keli, a yi a sofali gilɛni tɔn, e nun Moyaba kuntigine birin yi siga. ");
INSERT INTO yal_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Koni, Alaa xɔlɔn yi gbo ayi, amasɔtɔ a bata siga. Alatalaa malekan yi ti kiraan na alogo a xa a rati. Balami yi dɔxi a sofali gilɛn fari, a walikɛ firinne yi a fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Sofanla yi Alatalaa malekan to tixi kiraan xɔn, a silanfanna suxi a yii. Sofanla yi kiraan fata a so burunna ra. Balami yi sofanla bɔnbɔ alogo a xa fa kiraan xɔn. ");
INSERT INTO yal_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Alatalaa malekan mɔn yi sa ti kiradin xɔn manpa bili nakɔ firinne longonna ra. Sansanna yi kiraan fɔxɔ firinne birin yi. ");
INSERT INTO yal_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Sofanla to Alatalaa malekan to, a yi a dɛndɛn sansanna ra, a yi Balami sanna gbɛrɛxɛn sansanna ma. Balami mɔn yi a bɔnbɔ. ");
INSERT INTO yal_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Alatalaa malekan mɔn yi siga yɛɛn na pon! A sa ti yire yigbɛtɛnxini, dangude mi yi dɛnaxan kɔmɛnna ma, a mi yi yiifanna ma. ");
INSERT INTO yal_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Sofanla to Alatalaa malekan to, a yi a yigodo Balami bun ma. Balami yi xɔlɔ, a yi sofanla bɔnbɔ a dunganna ra. ");
INSERT INTO yal_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Alatala yi sofanla dɛɛn fulun, sofanla yi a fala Balami xa, a naxa, “N nanse ligaxi i ra, alogo i xa n bɔnbɔ han sanɲa ma saxan?” ");
INSERT INTO yal_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balami yi sofanla yabi, a naxa, “Amasɔtɔ i bata n matandi! Xa silanfanna yi n yii nun, n yi i faxama nɛn iki sa!” ");
INSERT INTO yal_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Sofanla yi a fala Balami xa, a naxa, “I ya sofanla xa mi n tan na ba, i darixi dɔxɛ naxan fari han to? N darixi ito ligɛ i ra ba?” A yi a yabi, a naxa, “Ɛn-ɛn.” ");
INSERT INTO yal_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Alatala yi Balami yɛɛne rabi, a yi Alatalaa malekan to tixi kiraan na, a silanfanna a yii. Balami yi a xinbi sin, a yi a yɛtagin lan bɔxɔn ma. ");
INSERT INTO yal_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Alatalaa malekan yi a maxɔdin, a naxa, “Nanfera i i ya sofanla bɔnbɔxi sanɲa ma saxan? N bata fa, n xa i rati, amasɔtɔ kirani ito i xalin gbalon nin. ");
INSERT INTO yal_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Sofanla bata n to, a yi n dɛ masara sanɲa ma saxan. Xa na mi yi a ra nun, n bata yi i faxa nun, koni n yi a tan luma nɛn a nii ra.” ");
INSERT INTO yal_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balami yi a fala Alatalaa malekan xa, a naxa, “N bata yulubin liga! N mi yi a kolon a i tixi n yɛɛ ra kiraan na. Iki, xa sigatini ito mi rafan i ma, n xa xɛtɛ.” ");
INSERT INTO yal_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Alatalaa malekan yi a fala Balami xa, a naxa, “Siga muxuni itoe fɔxɔ ra. Koni n na naxan fala i xa, i xa na nan fala tun!” Balami nun Balaki a kuntigine yi siga. ");
INSERT INTO yal_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki to a mɛ a Balami bata fa, a yi siga a ralandeni Moyaba taana nde yi naxan Arinon baan dɛ, a yamanan danna ra. ");
INSERT INTO yal_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki yi a fala Balami xa, a naxa, “N mi yi i xilima ba? Nanfera i mi fa n fɛma? I yi mirixi nɛn a n mi nɔɛ i binyɛ ba?” ");
INSERT INTO yal_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balami yi a fala Balaki xa, a naxa, “I mi n to? N bata fa. Koni n nɔɛ nanse falɛ i xa? Ala na naxan fala n xa, fɔ n xa na nan fala.” ");
INSERT INTO yal_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balami nun Balaki yi siga Kiriyati-Husoti yi. ");
INSERT INTO yal_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki yi ɲingene nun yɛxɛɛne ba saraxan na, a yi a subena nde so Balami nun kuntigine yii naxanye yi a fɔxɔ ra. ");
INSERT INTO yal_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Xɔtɔnni, Balaki yi Balami tongo a yi te a ra Bamoti-Baali geyaan fari, a yamaan fɔxɔ kedenna toɛ dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balami yi a fala Balaki xa, a naxa, “Saraxa gande solofere rafala n xa be, i yi tura solofere nun konton solofere yitɔn n xa.” ");
INSERT INTO yal_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balami naxan fala, Balaki yi na liga. Balaki nun Balami yi tura keden nun konton keden ba saraxan na saraxa gandene birin fari. ");
INSERT INTO yal_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balami yi a fala Balaki xa, a naxa, “Ti i ya saraxa gan daxine fɛma be. N tan xa n masiga i ra. Waxatina nde Alatala fama nɛn n fɛma. A na naxan yita n na, n na a ralima i ma nɛn.” A yi siga geyana nde xuntagi. ");
INSERT INTO yal_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ala yi fa Balami ralan. Balami yi a fala a xa, a naxa, “N bata saraxa gande solofere rafala, n bata tura keden nun konton keden ba saraxan na e birin fari.” ");
INSERT INTO yal_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Alatala yi falan so Balami dɛ, a naxa, “Xɛtɛ Balaki fɛma, i yi ito fala a xa.” ");
INSERT INTO yal_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","A yi xɛtɛ a fɛma. A yi tixi a saraxa gan daxine dɛxɔn e nun Moyaba kuntigine birin. ");
INSERT INTO yal_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balami yi waliyiya falane ti, a naxa, Balaki bata n nafa sa keli Arami yi, Moyaba mangan bata n nafa sa keli sogeteden geyane ma. A yi a fala, a naxa, “Fa, i fa Yaxuba bɔnsɔnna danga n xa! I fa gbalo falane ti Isirayila bɔnsɔnna xili ma!” ");
INSERT INTO yal_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Koni, n tan xa ne danga di, Ala mi naxanye dangaxi? N tan xa gbalo falane ti ne xili ma di, Alatala mi gbalon nagidixi naxanye ma? ");
INSERT INTO yal_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","N tixi gɛmɛne xuntagi, n na e toma. N tixi geyane fari, n na e matoma. Yamani ito a danna, a mi siyaan bonne yɛ. ");
INSERT INTO yal_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yaxuba bɔnsɔnna gbo alo gbangbanna, nde nɔɛ Isirayila kaane fɔxɔ kedenna naaninden yatɛ? N fan xa faxa tinxin muxune yɛ, N naɲanna xa liga alo e gbeena! ");
INSERT INTO yal_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki yi a fala Balami xa, a naxa, “I nanse ligaxi n na? N faxi i ra nɛn alogo i xa n yaxune danga, koni i dubama e xa nɛn tun!” ");
INSERT INTO yal_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","A yi a yabi, a naxa, “Alatala naxan soxi n dɛ, n mi lan n na fala ba?” ");
INSERT INTO yal_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaki yi a fala a xa, a naxa, “En siga yire gbɛtɛ yi, i mɔn sa e toɛ dɛnaxan yi. I e fɔxɔ kedenna toma nɛn. I mi a birin toɛ. I yi e danga n xa mɛnni.” ");
INSERT INTO yal_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","A yi a xali Sofimi a xɛɛn ma Pisiga geyaan xuntagi. A yi saraxa gande solofere rafala mɛnni, a yi tura keden nun konton keden ba saraxa gandene birin fari. ");
INSERT INTO yal_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balami yi a fala Balaki xa, a naxa, “Ti i ya saraxa gan daxine dɛxɔn be, n tan xa siga Ala ralandeni mɛnni.” ");
INSERT INTO yal_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Alatala yi fa Balami yɛtagi, a yi falan so a dɛ, a naxa, “Xɛtɛ Balaki fɛma, i yi ito fala a xa.” ");
INSERT INTO yal_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","A yi xɛtɛ a fɛma, a yi tixi a saraxa gan daxine dɛxɔn e nun Moyaba kuntigine. Balaki yi a maxɔdin, a naxa, “Alatala nanse falaxi?” ");
INSERT INTO yal_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balami yi waliyiya falane ti, a naxa, Balaki keli, i n xuiin mɛ! I tuli mati n na Siporo a dii xɛmɛna! ");
INSERT INTO yal_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Muxu mi Ala ra, a wulen fala, Adamadi mi a ra, a nimisa. A naxan falaxi, a mi na ligɛ ba? A na falan naxan ti, a mi na rakamalɛ ba? ");
INSERT INTO yal_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","A duban nan soxi n yii lan e ma. A barakan sa e yi. N mi nɔɛ na maxɛtɛ. ");
INSERT INTO yal_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","A mi fe ɲaxin toma Yaxuba bɔnsɔnni. A mi fe xɔlɛn toma Isirayila yi. Alatala, e Ala e tagi. E fan a mangayaan matɔxɔma. ");
INSERT INTO yal_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ala nan faxi e ra sa keli Misiran yi, a nɔɔn tima e xa alo burunna ɲingena. ");
INSERT INTO yal_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Kɔɛrayaan mi sese nɔɛ Yaxuba bɔnsɔnna xili ma. Serikariyaan mi nɔɛ sese ra Isirayila xili ma. A falama nɛn e ma na waxatini, “A mato, Ala naxan ligama!” ");
INSERT INTO yal_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Siyani ito kelima nɛn alo yatana. E bata e yitɔn alo yatana naxan mi a sama fɔ a na xɔɔyi seen don, fɔ a na sube suxine wunla min. ");
INSERT INTO yal_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaki yi a fala Balami xa, a naxa, “Xa i mi a dangama, hali i nama duba a xa de!” ");
INSERT INTO yal_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balami yi Balaki yabi, a naxa, “N mi yi a fala i xa ba, n naxa, ‘Alatala na naxan fala, n na nan ligama?’ ” ");
INSERT INTO yal_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki yi a fala Balami xa, a naxa, “En siga yire gbɛtɛ yi. Yanyina nde Ala tinma nɛn i xa e danga n xa mɛnni.” ");
INSERT INTO yal_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaki yi Balami xali Peyori geyaan xuntagi, dɛnaxan yɛɛ rafindixi tonbonna ma. ");
INSERT INTO yal_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balami yi a fala Balaki xa, a naxa, “Saraxa gande solofere rafala n xa be, i yi tura keden nun konton keden yitɔn n xa.” ");
INSERT INTO yal_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balami naxan fala, Balaki yi na liga. A yi turaan nun kontonna ba saraxan na saraxa gandene birin fari. ");
INSERT INTO yal_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balami yi a to fa fala a yi rafan Alatala ma a xa duba Isirayila xa. Nayi, a mi kɔɛraya feene rawali alo waxatin danguxine yi. Koni a yi a yɛɛ rafindi tonbonna binni. ");
INSERT INTO yal_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balami to a yɛɛne rakeli, a yi Isirayila kaane to malanxi bɔnsɔn yɛɛn ma. Nayi, Alaa Nii Sariɲanxin yi godo a ma. ");
INSERT INTO yal_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Balami yi waliyiya falane ti, a naxa, N tan Balami, Beyori a dii xɛmɛna, n tan naxan feene fixɛn toma, n ma falan ni i ra: ");
INSERT INTO yal_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","N ni ito nan falama, n tan naxan Alaa falane mɛma, naxan fe toon tima alo xiyene fata Ala Sɛnbɛ Kanna ra, naxan a xinbi sinma, a yɛɛne yi rabi. ");
INSERT INTO yal_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Yaxuba bɔnsɔnna, ɛ tan Isirayila kaane! Ɛ dɔxɔdene tofan! ");
INSERT INTO yal_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","E wuya bɔxɔn fari alo baane, alo nakɔne baan dɛ, alo Alatala sansi xiri faɲin naxanye sixi, alo suman wudine igene dɛ. ");
INSERT INTO yal_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","E ige ramaradene rafema nɛn ken! E sansine ige sa a faɲin na! E mangan gboma nɛn Manga Agaga xa, a mangayaan sɛnbɛn gboma ayi nɛn. ");
INSERT INTO yal_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ala nan faxi e ra sa keli Misiran yi, a nɔɔn tima e xa alo burunna ɲingena. E siyane nɔma nɛn naxanye e yɛngɛma, e yi e bun e xalimakunle ra, e yi e xɔnne yigira. ");
INSERT INTO yal_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","E e sama nɛn alo yatane. Nde susuɛ e rakelɛ? Naxan na duba i xa, Ala xa na kanna baraka! Naxan na i danga, Ala xa na kanna danga! ");
INSERT INTO yal_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaki yi xɔlɔ Balami ma han! A yi a yiine bɔnbɔ, a yi a fala Balami xa, a naxa, “N ni i xilixi nɛn alogo i xa n yaxune danga, koni i tan bata duba e xa sanɲa ma saxan. ");
INSERT INTO yal_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Iki keli be, siga i konni. N yi a ragidixi nɛn n xa i saren fi han, koni Alatala bata i kuma!” ");
INSERT INTO yal_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balami yi Balaki yabi, a naxa, “Anu, n na a fala nɛn i ya xɛrane xa, n naxa, ");
INSERT INTO yal_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Hali Balaki a banxin so n yii naxan nafexi gbetin nun xɛmaan na, n mi nɔɛ Alatalaa yamarin matandɛ fefe ma. Alatala na naxan fala, fɔ n xa na nan fala.’ ");
INSERT INTO yal_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Awa iki, n bata siga n kon kaane fɛma. Koni ɛ tuli mati. N xa i rakolon siyani ito naxan ligama i ya yamaan na waxati famatɔni.” ");
INSERT INTO yal_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Balami yi waliyiya falane ti, a naxa: N tan Balami, Beyori a dii xɛmɛna, n tan naxan feene fixɛn toma, n ma falan ni i ra: ");
INSERT INTO yal_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","N ni ito nan falama, n tan naxan Alaa falane mɛma, naxan Kore Xɔnna Ala wundo feene kolon, naxan fe toon tima alo xiyena fata Ala Sɛnbɛ Kanna ra, naxan a xinbi sinma, a yɛɛne yi rabi. ");
INSERT INTO yal_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","N na a toma, koni iki mi a ra. N na a toma, koni a mɔn makuya. Sarena nde minima nɛn Yaxuba bɔnsɔnni, mangan kelima nɛn Isirayila yamanani. A Moyaba yamanan mangane yɛngɛma nɛn, a Seti bɔnsɔnna nɔ. ");
INSERT INTO yal_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","A Edɔn yamanan tongoma nɛn, e nun Seyiri yamanana, a yaxuna. Koni Isirayila sɛnbɛn gboma ayi nɛn. ");
INSERT INTO yal_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Nɔ tiin minima nɛn Yaxuba bɔnsɔnni, a yi e taane muxu dɔnxɛne raxɔri. ");
INSERT INTO yal_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balami yi Amalɛkine to. A yi waliyiya falan ti, a naxa: Amalɛki nan yi yamana singen na dunuɲa yi, koni dɔnxɛn na, a tununma nɛn habadan! ");
INSERT INTO yal_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","A mɔn yi Keni kaane to. A yi waliyiya falan ti, a naxa: I dɔxɔden natangaxi, alo xɔliin naxan a tɛɛn saxi faranna ra. ");
INSERT INTO yal_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Koni Asuri na ɛ suxu konyiyani, Kenine ɲanma nɛn. ");
INSERT INTO yal_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","A mɔn yi waliyiya falan ti, a naxa: Ee! Ala na ito liga, nde luyɛ a nii ra? ");
INSERT INTO yal_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kunkine kelima nɛn Sipiri yi, e yi Asuri rayarabi, e nun Eberi. Koni e fan faxama nɛn. ");
INSERT INTO yal_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balami yi keli, a xɛtɛ a konni. Balaki fan yi siga. ");
INSERT INTO yal_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Isirayila kaane yi dɔxi Sitimi yi waxatin naxan yi, xɛmɛne yi lu yalunyaan ligɛ e nun Moyaba ɲaxanle. ");
INSERT INTO yal_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","E yi xɛmɛne xilima e suxure kideni. Yamaan yi e dɛge, e yi e xinbi sin e suxurene bun ma. ");
INSERT INTO yal_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Nayi, Isirayila kaane yi Baali-Peyori batu. Nanara, Alatala yi xɔlɔ e ma han! ");
INSERT INTO yal_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Alatala yi a fala Musa xa, a naxa, “Yamaan yɛɛratine birin suxu, i yi e faxa, i yi e singan Alatala yɛtagi sogen na, alogo Alatala xa ba xɔlɔxi Isirayila ma.” ");
INSERT INTO yal_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musa yi a fala Isirayila kitisane xa, a naxa, “Ɛ birin xa muxune faxa naxanye Baali-Peyori batuxi.” ");
INSERT INTO yal_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Isirayila xɛmɛna nde yi fa Midiyan ɲaxanla nde ra a konni, Musa nun Isirayila yamaan birin yɛtagi. Yamaan birin yi wugama Naralan Bubun so dɛɛn na. ");
INSERT INTO yal_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Na ma, Finexasi, Eleyasari a dii xɛmɛna, saraxarali Harunaa dii xɛmɛna, na yi keli yamaan yɛ, a yi tanban tongo. ");
INSERT INTO yal_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","A yi siga Isirayila kaan fɔxɔ ra a bubuni. A yi e firinna sɔxɔn tanban na sanɲa ma kedenni e kuini. Fitina furen naxan yi Isirayila yi, na yi dan. ");
INSERT INTO yal_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Muxu wuli mɔxɔɲɛn nun naanin nan faxa na furen ma. ");
INSERT INTO yal_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finexasi, Eleyasari a dii xɛmɛna, saraxarali Harunaa dii xɛmɛna, na bata n ma xɔlɔn ba Isirayila ma. Amasɔtɔ n ma xɔxɔlɔnna nan soxi a yi. Na ma, n mi Isirayila kaane raxɔrima xɔxɔlɔnni. ");
INSERT INTO yal_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Nanara, i xa a fala a xa, n bata tin bɔɲɛ xunbenla layirin tongɛ a xa. ");
INSERT INTO yal_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Na layirin luma a tan xa nɛn e nun a yixɛtɛne, n yi e findi saraxaraline ra habadan. Amasɔtɔ a kunfa nɛn a Ala xɔn, a yi n solona Isirayila xa.” ");
INSERT INTO yal_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Isirayila xɛmɛn naxan nun Midiyan ɲaxanla faxa, a yi xili nɛn Simiri, Salu a dii xɛmɛna. Simeyɔn bɔnsɔnna denbayana nde kuntigin nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Midiyan ɲaxanla naxan faxa, a yi xili nɛn Kosibi, Suru a dii tɛmɛna. Midiyan xabilana ndee mangan nan yi a ra. ");
INSERT INTO yal_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Ɛ xa Midiyan kaane yatɛ ɛ yaxune ra, ɛ yi e yɛngɛ. ");
INSERT INTO yal_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Amasɔtɔ e bata findi ɛ yaxune ra e to ɛ yanfa Peyori yi, Kosibi a fe yi, e xabila mangana nde a dii tɛmɛna, ɛ naxan faxa, na feen to fitina furen nafa.” ");
INSERT INTO yal_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","Na fitina furen yi dangu. ");
INSERT INTO yal_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","A to dangu, Alatala yi a fala Musa nun Haruna dii Eleyasari xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Ɛ Isirayila yamaan tɛngɛ naxanye barin bata dangu ɲɛɛ mɔxɔɲɛn na, e denbaya yɛɛn ma, naxanye birin nɔɛ yɛngɛn soɛ.” ");
INSERT INTO yal_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa nun saraxarali Eleyasari yi falan ti e xa Moyaba mɛrɛmɛrɛni Yurudɛn baan dɛ Yeriko taan yɛtagi. E naxa, ");
INSERT INTO yal_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Xɛmɛne xa tɛngɛ naxanye barin bata dangu ɲɛɛ mɔxɔɲɛn na, alo Alatala a yamarixi Musa ma kii naxan yi.” Isirayila kaan naxanye minixi Misiran yamanani, ne ni itoe ra: ");
INSERT INTO yal_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Isirayila dii singe Rubɛn yixɛtɛne ni i ra: Xanɔki xabilana, Xanɔki yixɛtɛne; Palu xabilana, Palu yixɛtɛne; ");
INSERT INTO yal_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Xesirɔn xabilana, Xesirɔn yixɛtɛne; e nun Karimi xabilana, Karimi yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Rubɛn xabilane nan ne ra, e malanxina, muxu wuli tonge naanin e nun saxan kɛmɛ solofere tonge saxan. ");
INSERT INTO yal_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Eliyabi nan yi Palu a dii xɛmɛn na. ");
INSERT INTO yal_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliyabi a dii xɛmɛne nan itoe ra: Nemuweli, Datan e nun Abirami. Datan nun Abirami yi findixi yamaan kuntigine nan na naxanye murutɛ Musa nun Haruna xili ma, e sa Kora muxune fari, e to murutɛ Alatala xili ma. ");
INSERT INTO yal_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Bɔxɔn yi rabi, a yi e nun Kora gerun e bode xɔn. Tɛɛn yi a fɔxɔ ra birane muxu kɛmɛ firin tonge suulun gan. Na yi findi misaala ra yamaan xa. ");
INSERT INTO yal_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Koni, Kora yixɛtɛne birin mi faxa. ");
INSERT INTO yal_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeyɔn yixɛtɛne ni i ra xabila yɛɛn ma: Nemuweli xabilana, Nemuweli yixɛtɛne; Yamin xabilana, Yamin yixɛtɛne; Yakin xabilana, Yakin yixɛtɛne; ");
INSERT INTO yal_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Sera xabilana, Sera yixɛtɛne; e nun Sayuli xabilana, Sayuli yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simeyɔn xabilane nan ne ra, e malanxina, muxu wuli mɔxɔɲɛn nun firin kɛmɛ firin. ");
INSERT INTO yal_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gadi yixɛtɛne ni i ra xabila yɛɛn ma: Sefɔn xabilana, Sefɔn yixɛtɛne; Xagi xabilana, Xagi yixɛtɛne; Suni xabilana, Suni yixɛtɛne; ");
INSERT INTO yal_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Osini xabilana, Osini yixɛtɛne; Eriya xabilana, Eriya yixɛtɛne; ");
INSERT INTO yal_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arodi xabilana, Arodi yixɛtɛne; e nun Areli xabilana, Areli yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Gadi xabilane nan ne ra, e malanxina, muxu wuli tonge naanin kɛmɛ suulun. ");
INSERT INTO yal_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Eri nun Onan nan yi Yuda a dii xɛmɛne ra, koni Eri nun Onan bata yi faxa Kanan yamanani. ");
INSERT INTO yal_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Yuda yixɛtɛne ni i ra xabila yɛɛn ma: Selaxa xabilana, Selaxa yixɛtɛne; Peresi xabilana, Peresi yixɛtɛne; e nun Sera xabilana, Sera yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Peresi yixɛtɛne ni i ra xabila yɛɛn ma: Xesirɔn xabilana, Xesirɔn yixɛtɛne; e nun Xamuli xabilana, Xamuli yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Yuda xabilane nan ne ra, e malanxina, muxu wuli tonge solofere wuli sennin kɛmɛ suulun. ");
INSERT INTO yal_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isakari yixɛtɛne ni i ra xabila yɛɛn ma: Tola xabilana, Tola yixɛtɛne; Puwa xabilana, Puwa yixɛtɛne; ");
INSERT INTO yal_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yasubu xabilana, Yasubu yixɛtɛne; e nun Simiron xabilana, Simiron yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Isakari xabilane nan ne ra, e malanxina, muxu wuli tonge sennin wuli naanin kɛmɛ saxan. ");
INSERT INTO yal_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sabulon yixɛtɛne ni i ra xabila yɛɛn ma: Seredi xabilana, Seredi yixɛtɛne; Elon xabilana, Elon yixɛtɛne; e nun Yalele xabilana, Yalele yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Sabulon xabilane nan ne ra, e malanxina, muxu wuli tonge sennin kɛmɛ suulun. ");
INSERT INTO yal_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yusufu yixɛtɛne ni i ra xabila yɛɛn ma: Manase nun Efirami. ");
INSERT INTO yal_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manase yixɛtɛne ni i ra: Makiri xabilana, Makiri yixɛtɛne. Makiri nan Galadi sɔtɔ. E nun Galadi xabilana, Galadi yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Galadi yixɛtɛne ni i ra: Yeseri xabilana, Yeseri yixɛtɛne; Xeleki xabilana, Xeleki yixɛtɛne; ");
INSERT INTO yal_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asirɛli xabilana, Asirɛli yixɛtɛne; Siken xabilana, Siken yixɛtɛne; ");
INSERT INTO yal_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Sɛmida xabilana, Sɛmida yixɛtɛne; e nun Xeferi xabilana, Xeferi yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofexadi, Xeferi a dii xɛmɛn mi dii xɛmɛ sɔtɔ, koni a dii tɛmɛne sɔtɔ nɛn. Selofexadi a dii tɛmɛne xinle ni itoe ra: Maxala, Noha, Xɔgala, Milika e nun Tirisa. ");
INSERT INTO yal_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Manase xabilane nan ne ra, e malanxina, muxu wuli tonge suulun wuli firin kɛmɛ solofere. ");
INSERT INTO yal_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efirami yixɛtɛne ni i ra xabila yɛɛn ma: Sutela xabilana, Sutela yixɛtɛne; Bekeri xabilana, Bekeri yixɛtɛne; e nun Taxani xabilana, Taxani yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sutela yixɛtɛne ni i ra: Eran xabilana, Eran yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Efirami xabilane nan ne ra, e malanxina, muxu wuli tonge saxan wuli firin kɛmɛ suulun. Yusufu yixɛtɛne nan ne ra xabila yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Bunyamin yixɛtɛne ni i ra xabila yɛɛn ma: Bela xabilana, Bela yixɛtɛne; Asibeli xabilana, Asibeli yixɛtɛne; Axirami xabilana, Axirami yixɛtɛne; ");
INSERT INTO yal_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sufami xabilana, Sufami yixɛtɛne; e nun Xufami xabilana, Xufami yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela yixɛtɛne ni i ra: Arade nun Naman. Arade xabilana, Arade yixɛtɛne; e nun Naman xabilana, Naman yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Bunyamin xabilane nan ne ra, e malanxina, muxu wuli tonge naanin wuli suulun kɛmɛ sennin. ");
INSERT INTO yal_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dan yixɛtɛne ni i ra xabila yɛɛn ma: Suxami xabilana, Suxami yixɛtɛne. Dan xabila keden nan yi na ra. ");
INSERT INTO yal_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Suxami xabilan nan na ra, e malanxina muxu wuli tonge sennin wuli naanin kɛmɛ naanin. ");
INSERT INTO yal_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Aseri yixɛtɛne ni i ra xabila yɛɛn ma: Yimina xabilana, Yimina yixɛtɛne; Yisiwi xabilana, Yisiwi yixɛtɛne; e nun Beriya xabilana, Beriya yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beriya yixɛtɛne ni i ra: Xeberi xabilana, Xeberi yixɛtɛne; e nun Malikili xabilana, Malikili yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aseri a dii tɛmɛn yi xili nɛn Sera. ");
INSERT INTO yal_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Aseri xabilane nan ne ra, e malanxina, muxu wuli tonge suulun wuli saxan kɛmɛ naanin. ");
INSERT INTO yal_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nafatali yixɛtɛne ni i ra xabila yɛɛn ma: Yaseli xabilana, Yaseli yixɛtɛne; Guni xabilana, Guni yixɛtɛne; ");
INSERT INTO yal_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yeseri xabilana, Yeseri yixɛtɛne; e nun Silen xabilana, Silen yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Nafatali xabilane nan ne ra, e malanxina, muxu wuli tonge naanin wuli suulun kɛmɛ naanin. ");
INSERT INTO yal_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Isirayila xɛmɛn naxanye yatɛ, muxu wuli kɛmɛ sennin e nun keden kɛmɛ solofere tonge saxan. ");
INSERT INTO yal_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Yamanani taxunma nɛn e tagi e kɛɛn na, fata muxune yatɛn na. ");
INSERT INTO yal_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Naxanye wuya, i xa kɛɛ gbeen so ne yii. Naxanye mi wuya, i xa kɛɛ xurin so ne yii. Birin kɛɛn xa lan muxune yatɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Koni yamanan xa yitaxun masɛnsɛnna nan xɔn. E a sɔtɔma nɛn e kɛɛn na fata e benbane bɔnsɔnne xinle ra. ");
INSERT INTO yal_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Birin kɛɛ bɔxɔni taxunma masɛnsɛnna nan xɔn, bɔnsɔn gbeene nun bɔnsɔn xurine yɛ. ");
INSERT INTO yal_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Lewi bɔnsɔnna muxuni itoe nan tɛngɛ e xabila yɛɛn ma: Gɛrisɔn xabilana, Gɛrisɔn yixɛtɛne; Kehati xabilana, Kehati yixɛtɛne; e nun Merari xabilana, Merari yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Lewi bɔnsɔnna xabila gbɛtɛn ni i ra: Libini xabilana, Xebiron xabilana, Maxali xabilana, Musi xabilana, e nun Kora xabilana. Kehati nan Amirama sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amirama a ɲaxanla yi xili nɛn “Yokebedi,” Lewi a dii tɛmɛna, naxan bari Misiran yi. E nun Amirama nan Haruna nun Musa sɔtɔ, e nun Mariyama, e magilɛna. ");
INSERT INTO yal_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Haruna nan Nadaba nun Abihu nun Eleyasari nun Itamara sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Koni Nadaba nun Abihu faxa nɛn, e to tɛɛ daxataren xali Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","E Lewi xɛmɛn naxanye tɛngɛ, naxanye barin bata yi dangu kike kedenna ra, ne lan muxu wuli mɔxɔɲɛn nun saxan nan ma. E mi tɛngɛ Isirayila kaan bonne yɛ, amasɔtɔ e mi yi lan e xa kɛɛ bɔxɔn sɔtɔ e yɛ. ");
INSERT INTO yal_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Musa nun saraxarali Eleyasari ne nan tɛngɛ Moyaba mɛrɛmɛrɛne yi Yurudɛn baan dɛ Yeriko taan yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Musa nun saraxarali Haruna Isirayila kaan naxanye tɛngɛ Sinayi tonbonni, na sese mi yi itoe yɛ. ");
INSERT INTO yal_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Amasɔtɔ Alatala bata yi a fala ne ma, a e faxama nɛn tonbonni. Keden mi lu fɔ Yefune a dii Kalebi nun Nunu a dii Yosuwe. ");
INSERT INTO yal_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Awa, Selofexadi a dii tɛmɛne yi fa, Xeferi a dii xɛmɛna, Galadi mamandenna. Manase a dii Makiri nan Galadi sɔtɔ Manase bɔnsɔnni, Yusufu a dii xɛmɛna. E xinle ni itoe ra: Maxala nun Noha nun Xɔgala nun Milika e nun Tirisa. ");
INSERT INTO yal_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","E yi fa Naralan Bubun so dɛɛn na Musa nun saraxarali Eleyasari nun mangane nun yamaan birin yɛtagi. E naxa, ");
INSERT INTO yal_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Nxu baba bata faxa tonbonni. A mi yi Kora ganla yɛ naxanye yi murutɛxi Alatala xili ma, koni a faxaxi a yɛtɛɛn yulubin nan ma, dii xɛmɛ mi yi a yii. ");
INSERT INTO yal_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Nanfera nxu baba xinla lɔyɛ ayi a xabilani, bayo dii xɛmɛ to mi a yii ba? Ɛ kɛɛna nde so nxu yii nxu baba ngaxakedenne tagi.” ");
INSERT INTO yal_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Musa yi siga e kiti feen maxɔdinna tideni Alatala ma. ");
INSERT INTO yal_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Selofexadi a dii tɛmɛne ɲɔndi. Kɛɛ bɔxɔna nde so e yii e baba ngaxakedenne tagi. I lan i yi e baba kɛɛn so e yii. ");
INSERT INTO yal_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","A fala Isirayila kaane xa, i naxa, ‘Xa muxuna nde faxa a mi dii xɛmɛ lu, ɛ xa a kɛɛn so a dii tɛmɛn yii. ");
INSERT INTO yal_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Xa dii tɛmɛ mi a yii, ɛ xa a kɛɛn so a ngaxakeden xɛmɛmane yii. ");
INSERT INTO yal_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Xa a ngaxakeden mi na, ɛ xa a kɛɛn so a baba ngaxakeden xɛmɛmane yii. ");
INSERT INTO yal_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Xa a baba ngaxakeden mi na, ɛ xa a kɛɛn so a bari bodena nde yii a xabilani, a yi findi a gbeen na. A findima kiti sa sariyan nan na Isirayila kaane xa, Alatala naxan yamarixi Musa ma.’ ” ");
INSERT INTO yal_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Alatala yi a fala Musa xa, a naxa, “Te Abarimi geyani ito fari, i yi bɔxɔn mato n naxan so Isirayila yii. ");
INSERT INTO yal_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","I na a mato, i laxirayama nɛn, alo i tada Haruna. ");
INSERT INTO yal_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Amasɔtɔ ɛ bata n ma yamarin matandi, yamaan murutɛ waxatin naxan yi Sini tonbonni igen dɛ. I mi n ma sariɲanna binya e yɛtagi, e to yi igen maxɔdinma.” Meriba igene nan yi ne ra Kadesi yi Sini tonbonni. ");
INSERT INTO yal_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa yi a fala Alatala xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Alatala, Ala naxan niin biraxi adamadiine birin yi, i xa muxuna nde ti yamani ito xun na ");
INSERT INTO yal_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","naxan nɔɛ tiyɛ a yɛɛ ra a feen birin yi. Alatalaa yamaan nama lu alo xuruseene xuruse raba mi naxanye xun na.” ");
INSERT INTO yal_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Alatala yi a fala Musa xa, a naxa, “Nunu a dii Yosuwe tongo, n ma Nii Sariɲanxin naxan yi, i yi i yii sa a fari. ");
INSERT INTO yal_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","I yi a ti saraxarali Eleyasari nun yamaan birin yɛtagi, i yi a findi yɛɛratiin na e yɛɛ xɔri. ");
INSERT INTO yal_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","I yi i sɛnbɛna nde so a yii, alogo Isirayila yamaan birin xa a xuiin suxu. ");
INSERT INTO yal_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","A ti saraxarali Eleyasari yɛtagi, alogo a xa kiti sa feen maxɔdinne ti a xa, Yurima masɛnsɛn ti seen na Alatala yɛtagi. Yosuwe nun Isirayila yamaan birin Eleyasari a yamarine suxuma nɛn e feene birin yi.” ");
INSERT INTO yal_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa yi a liga alo Alatala a yamari kii naxan yi. A yi Yosuwe tongo, a yi a ti saraxarali Eleyasari nun yamaan birin yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","A yi a yiine sa a fari, a yi a findi yɛɛratiin na, alo Alatala a fala e xa kii naxan yi fata Musa ra. ");
INSERT INTO yal_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Yamarini ito fi Isirayila kaane ma, i naxa, ‘Ɛ fa n kise donseene ra e waxati saxine yi, naxanye ralima n ma tɛɛn na naxanye xirin nafan n ma.’ ");
INSERT INTO yal_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ito fala e xa, i naxa, ‘Lɔxɔ yo lɔxɔ, ɛ fa yɛxɛɛn ɲɛɛ kedenna firin na Alatala xɔn, fɛ mi naxanye ra saraxa gan daxin na naxan nalima a ma tɛɛn na waxatin birin. ");
INSERT INTO yal_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Yɛxɛɛ keden xa ba xɔtɔnni, a firindena fitirin ma. ");
INSERT INTO yal_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","A bama nɛn e nun a bogise saraxana, murutu fuɲin kilo saxan naxan namulanxi oliwi bogi dinxine turen litiri keden nun a tagiin na. ");
INSERT INTO yal_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Saraxa gan daxini ito bama nɛn waxatin birin alo a liga Sinayi geyaan fari kii naxan yi. A ralima Alatala ma tɛɛn nan na, a xirin yi rafan a ma. ");
INSERT INTO yal_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Yɛxɛɛn bama nɛn e nun a minse saraxana, wudi bogi igen litiri keden e nun a tagi. I xa minse saraxan bɔxɔn Alatala xa yire sariɲanxini. ");
INSERT INTO yal_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Yɛxɛɛn firinden bama fitirin nan ma, e nun a bogise saraxana e nun a minse saraxana alo i naxan bama xɔtɔnni. A ralima Alatala ma tɛɛn nan na, a xirin yi rafan a ma.’ ” ");
INSERT INTO yal_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Matabu Lɔxɔni, yɛxɛɛn ɲɛɛ kedenna firin xa ba saraxan na, fɛ mi naxanye ra, e nun e bogise saraxane, murutu fuɲin kilo sennin naxan namulanxi turen na e nun e minse saraxana. ");
INSERT INTO yal_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Na saraxa gan daxine xa ba Matabu Lɔxɔne birin yi, sa lɔxɔ yo lɔxɔ saraxa gan daxine fari e nun a minse saraxana.’ ” ");
INSERT INTO yal_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Kike nɛnɛn fɔlɔna, ɛ xa tura bulan firin ba saraxa gan daxin na Alatala xa, e nun konton keden nun yɛxɛɛn ɲɛɛ keden kedenna solofere, fɛ mi naxanye ra. ");
INSERT INTO yal_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Xuruseene birin bama nɛn e nun murutu fuɲina naxan namulanxi turen na, bogise saraxana. Ɲinge keden lanma murutu fuɲin kilo solomanaanin nan ma. Kontonna, kilo sennin. ");
INSERT INTO yal_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Konton bulanna, kilo saxan naxan namulanxi turen na bogise saraxan na. Saraxa gan daxin na a ra naxan nalima Alatala ma tɛɛn na, a xirin yi rafan a ma. ");
INSERT INTO yal_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ɲinge keden bama nɛn e nun a minse saraxana, wudi bogi igen litiri saxan. Kontonna gbeena, litiri firin. Yɛxɛɛ diina, litiri keden nun a tagi. Saraxa gan daxin na a ra naxan bama kike nɛnɛne birin na ɲɛɛn bun. ");
INSERT INTO yal_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na Alatala xa, sa lɔxɔ yo lɔxɔ saraxa gan daxine fari e nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Ɲɛɛn kike singen xii fu nun naaninna, ɛ xa Halagi Tiin Dangu Lɔxɔn Sanla raba Alatala xa.’ ” ");
INSERT INTO yal_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","“ ‘Kikeni ito xii fu nun suulunde lɔxɔni, sanla yi fɔlɔ. Ɛ xa buru ratetaren don xii solofere. ");
INSERT INTO yal_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Sanla xii singe lɔxɔni, ɛ xa yamaan xili malan sariɲanxini. Ɛ nama ɛ wanle kɛ na lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Ɛ xa tura bulan firin nun konton keden nun yɛxɛɛn ɲɛɛ keden kedenna solofere ba saraxa gan daxin na fɛ mi naxanye ra. E rali Alatala ma tɛɛn nan na. ");
INSERT INTO yal_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Xuruseene bama nɛn e nun murutu fuɲin naxan namulanxi turen na, bogise saraxana. Ɲinge keden lanma murutu fuɲin kilo solomanaanin nan ma. Kontonna, kilo sennin. ");
INSERT INTO yal_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Yɛxɛɛ soloferene, kilo saxan saxan. ");
INSERT INTO yal_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na Ala solona seen na ɛ xa. ");
INSERT INTO yal_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Na birin sama lɔxɔ yo lɔxɔ saraxan nan fari naxan bama xɔtɔnni. ");
INSERT INTO yal_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Sanla xii soloferene birin yi, ɛ xa na kise donseene nan nali tɛɛn na, e xirin yi rafan Alatala ma, sa lɔxɔ yo lɔxɔ saraxane nun minse saraxane fari. ");
INSERT INTO yal_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Xii soloferede lɔxɔni, ɛ mɔn yi yamaan xili malan sariɲanxini. Ɛ nama ɛ wanle kɛ na lɔxɔni.’ ” ");
INSERT INTO yal_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Se Xaba Singen sali lɔxɔni, ɛ na fa bogise singene saraxane ra Alatala xɔn Xunsagine Sanla waxatini, ɛ xa yamaan xili malan sariɲanxini. Ɛ nama ɛ wanle kɛ. ");
INSERT INTO yal_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Ɛ xa tura bulan firin nun konton keden nun yɛxɛɛn ɲɛɛ keden kedenna solofere ba saraxa gan daxin na, a xirin yi rafan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Xuruseene bama nɛn e nun murutu fuɲin naxan namulanxi turen na, bogise saraxana. Ɲinge keden lanma murutu fuɲin kilo solomanaanin nan ma. Kontonna, kilo sennin. ");
INSERT INTO yal_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Yɛxɛɛ soloferene, kilo saxan saxan. ");
INSERT INTO yal_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na Ala solona seen na ɛ xa. ");
INSERT INTO yal_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Na saraxane bama nɛn e nun e minse saraxane. E sa lɔxɔ yo lɔxɔ saraxa gan daxine nun e bogise saraxane fari. Ɛ xa xuruseene ba fɛ mi naxanye ra e nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Kike solofereden xi singe lɔxɔni, ɛ xa yamaan xili malan sariɲanxini. Ɛ nama ɛ wanle kɛ, koni ɛ xa xɔtane fe na lɔxɔni. ");
INSERT INTO yal_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Ɛ xa tura bulan keden nun konton keden nun yɛxɛɛn ɲɛɛ keden kedenna solofere ba saraxa gan daxin na, fɛ mi naxanye ra. A xirin yi rafan Alatala ma. ");
INSERT INTO yal_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Xuruseene bama nɛn e nun murutu fuɲin naxan namulanxi turen na, bogise saraxana. Ɲinge keden lanma murutu fuɲin kilo solomanaanin nan ma. Kontonna, kilo sennin. ");
INSERT INTO yal_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Yɛxɛɛ soloferene, kilo saxan saxan. ");
INSERT INTO yal_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na Ala solona seen na ɛ xa. ");
INSERT INTO yal_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Saraxan ne sama kike nɛnɛn saraxane nun lɔxɔ yo lɔxɔ saraxane nan fari e nun e bogise saraxane nun minse saraxane naxan falaxi sariyani. Saraxane nan ne ra naxanye nalima Alatala ma tɛɛn na, e xirin yi rafan a ma.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Kike solofereden xii fude lɔxɔni, ɛ xa yamaan xili malan sariɲanxini. Ɛ yi sun. Ɛ nama wali yo kɛ. ");
INSERT INTO yal_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Ɛ xa tura bulan keden nun konton keden nun yɛxɛɛn ɲɛɛ keden kedenna solofere ba saraxa gan daxin na Alatala xa fɛ mi naxanye ra, a xirin yi rafan a ma. ");
INSERT INTO yal_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Xuruseene bama nɛn e nun murutu fuɲin naxan namulanxi turen na, bogise saraxana. Ɲinge keden lanma murutu fuɲin kilo solomanaanin nan ma. Kontonna, kilo sennin. ");
INSERT INTO yal_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Yɛxɛɛ soloferene, kilo saxan saxan. ");
INSERT INTO yal_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na, sa Ala solona saraxan fari e nun lɔxɔ yo lɔxɔ saraxa gan daxine nun e bogise saraxane nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Kike solofereden xii fu nun suulunde lɔxɔni, ɛ xa yamaan xili malan sariɲanxini. Ɛ nama ɛ wanle kɛ. Ɛ xa sanla raba Alatala xa xii solofere. ");
INSERT INTO yal_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Xii singe lɔxɔni, ɛ xa tura bulan fu nun saxan nun konton firin nun yɛxɛɛn ɲɛɛ keden kedenna fu nun naanin ba saraxa gan daxin na Alatala xa, fɛ mi naxanye ra. A ralima a ma tɛɛn nan na, a xirin yi rafan a ma. ");
INSERT INTO yal_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","E bama nɛn e nun murutu fuɲin naxan namulanxi turen na bogise saraxana. Ɲinge keden kilo solomanaanin, kontonna kilo sennin. ");
INSERT INTO yal_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Yɛxɛɛ fu nun naaninne, kilo saxan saxan. ");
INSERT INTO yal_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na, sa lɔxɔ yo lɔxɔ saraxa gan daxine fari e nun e bogise saraxane nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Xii firinde lɔxɔni, ɛ xa tura bulan fu nun firin nun konton firin nun yɛxɛɛn ɲɛɛ keden kedenna fu nun naanin ba fɛ mi naxanye ra. ");
INSERT INTO yal_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","E bama nɛn e nun e bogise saraxane nun e minse saraxane, naxanye lanɲɛ turane nun kontonne nun yɛxɛɛne yatɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na, sa lɔxɔ yo lɔxɔ saraxa gan daxine fari e nun e bogise saraxane nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Xii saxande lɔxɔni, ɛ xa tura bulan fu nun keden nun konton firin nun yɛxɛɛn ɲɛɛ keden kedenna fu nun naanin ba fɛ mi naxanye ra. ");
INSERT INTO yal_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","E bama nɛn e nun e bogise saraxane nun e minse saraxane, naxanye lanɲɛ turane nun kontonne nun yɛxɛɛne yatɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na, sa lɔxɔ yo lɔxɔ saraxa gan daxine fari e nun e bogise saraxane nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Xii naaninde lɔxɔni, ɛ xa tura bulan fu nun konton firin nun yɛxɛɛn ɲɛɛ keden kedenna fu nun naanin ba fɛ mi naxanye ra. ");
INSERT INTO yal_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","E bama nɛn e nun e bogise saraxane nun e minse saraxane, naxanye lanɲɛ turane nun kontonne nun yɛxɛɛne yatɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na, sa lɔxɔ yo lɔxɔ saraxa gan daxine fari e nun e bogise saraxane nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Xii suulunde lɔxɔni, ɛ xa tura bulan solomanaanin nun konton firin nun yɛxɛɛn ɲɛɛ keden kedenna fu nun naanin ba fɛ mi naxanye ra. ");
INSERT INTO yal_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","E bama nɛn e nun e bogise saraxane nun e minse saraxane, naxanye lanɲɛ turane nun kontonne nun yɛxɛɛne yatɛne ma. ");
INSERT INTO yal_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na, sa lɔxɔ yo lɔxɔ saraxa gan daxine fari e nun e bogise saraxane nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Xii senninde lɔxɔni, ɛ xa tura bulan solomasɛxɛ nun konton firin nun yɛxɛɛn ɲɛɛ keden kedenna fu nun naanin ba fɛ mi naxanye ra. ");
INSERT INTO yal_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","E bama nɛn e nun e bogise saraxane nun e minse saraxane, naxanye lanɲɛ turane nun kontonne nun yɛxɛɛne yatɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na, sa lɔxɔ yo lɔxɔ saraxa gan daxine fari e nun e bogise saraxane nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Xii soloferede lɔxɔni, ɛ xa tura bulan solofere nun konton firin nun yɛxɛɛn ɲɛɛ keden kedenna fu nun naanin ba fɛ mi naxanye ra. ");
INSERT INTO yal_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","E bama nɛn e nun e bogise saraxane nun e minse saraxane, naxanye lanɲɛ turane nun kontonne nun yɛxɛɛne yatɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na, sa lɔxɔ yo lɔxɔ saraxa gan daxine fari e nun e bogise saraxane nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Xii solomasɛxɛde lɔxɔni, ɛ xa ɛ malan. Ɛ nama ɛ wanla kɛ. ");
INSERT INTO yal_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Ɛ xa tura keden nun konton keden nun yɛxɛɛn ɲɛɛ keden kedenna solofere ba saraxa gan daxin na fɛ mi naxanye ra. E xa rali Alatala ma tɛɛn na, naxan xiri rafan a ma. ");
INSERT INTO yal_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","E bama nɛn e nun e bogise saraxane nun e minse saraxane, naxanye lanɲɛ turane nun kontonne nun yɛxɛɛne yatɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Ɛ mɔn xa kɔtɔ keden ba yulubi xafari saraxan na, sa lɔxɔ yo lɔxɔ saraxa gan daxine fari e nun e bogise saraxane nun e minse saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Saraxane nan ne ra ɛ lan ɛ xa naxanye ba Alatala xa sali lɔxɔne yi. E sama nɛn ɛ saraxa gan daxine fari, e nun ɛ bogise saraxane nun ɛ minse saraxane nun ɛ bɔɲɛ xunbeli saraxane, ɛ naxanye ba dɛ tiina fe ra hanma ɛ ɲɛnige ma saraxane.’ ” ");
INSERT INTO yal_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Alatala Musa yamari naxanye birin ma, a yi ne birin fala Isirayila kaane xa. ");
INSERT INTO yal_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Musa yi falan ti Isirayila bɔnsɔnne mangane xa, a naxa, “Alatalaa yamarini ito nan fixi: ");
INSERT INTO yal_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Xa xɛmɛna nde a kɔlɔ hanma a a dɛ ti a a xa saraxan ba Alatala xa hanma a xa fena nde raba, a nama a falan kala. A naxan birin falaxi, a xa na raba.” ");
INSERT INTO yal_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","“Xa sungutunna nde a kɔlɔ hanma a a dɛ ti a a saraxan bama Alatala xa, hanma a fena nde rabama nɛn, a mɔn a baba konni, ");
INSERT INTO yal_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","a baba na a mɛ waxatin naxan yi, xa a mi sese fala, a lan a yi a kɔlɔne nun a dɛ ti xuine birin nakamali. ");
INSERT INTO yal_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Koni a baba na a mɛ waxatin naxan yi, xa a mi tin, a mi lan a yi a kɔlɔne nun a dɛ ti xuine rakamali. Alatala diɲama nɛn a ma, bayo a baba mi tinxi.” ");
INSERT INTO yal_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","“Xa sungutunna nde a kɔlɔ hanma a a dɛ ti xaxilitareyani, na xanbi ra a yi futu, ");
INSERT INTO yal_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","a xɛmɛn na a mɛ waxatin naxan yi, xa a mi sese fala, a lan a yi a kɔlɔne nun a dɛ ti xuine rakamali. ");
INSERT INTO yal_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","A xɛmɛn na a mɛ waxatin naxan yi, xa a mi tin, a xa a kɔlɔne nun a xaxilitareya dɛ xuine yikala. Alatala diɲama nɛn ɲaxanla ma.” ");
INSERT INTO yal_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Kaɲa gilɛɛn hanma ɲaxanla naxan xɛmɛn bata a mɛ a ra, xa na nde a kɔlɔ hanma a a dɛ ti a fena nde rabama nɛn, a lan a yi na birin nakamali.” ");
INSERT INTO yal_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","“Xa ɲaxanla bata dɔxɔ xɛmɛ taa ra, a a kɔlɔ hanma a a dɛ ti a fena nde rabama nɛn, ");
INSERT INTO yal_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","a xɛmɛn na a mɛ, xa a mi sese fala a mi tondi, a lan a yi a kɔlɔne nun dɛ ti xuine birin nakamali. ");
INSERT INTO yal_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Koni a xɛmɛn na a mɛ waxatin naxan yi, xa a mi tin, a mi lan a yi a kɔlɔne nun dɛ ti xuine rakamali. Alatala diɲama nɛn a ma, amasɔtɔ a xɛmɛn bata a kala. ");
INSERT INTO yal_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Nayi, a xɛmɛn nɔɛ tinɲɛ nɛn hanma a tondi a kɔlɔne nun a dɛ ti xuine ma. ");
INSERT INTO yal_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","A na a mɛ, xa a xɛmɛn mi sese fala a ɲaxanla xa, a bata tin a kɔlɔne nun dɛ ti xuine birin ma a dunduni. ");
INSERT INTO yal_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Koni xa lɔxɔn bata dangu a xɛmɛna a fe mɛxi naxan yi, a yi fa a ɲaxanla dɛ ti xuine kala, xɛmɛna a ɲaxanla hakɛn goronna tongoma nɛn.” ");
INSERT INTO yal_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Alatala na sariyane nan falaxi Musa xa dɛ tiina fe yi ɲaxalan futuxina fe yi hanma dii tɛmɛn naxan a baba konni. ");
INSERT INTO yal_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Midiyan kaane fe ɲaxin saran e ra, e naxan ligaxi Isirayila kaane ra. Na xanbi ra, i laxirayama nɛn.” ");
INSERT INTO yal_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Nayi, Musa yi a fala yamaan xa, a naxa, “Muxuna ndee xa e yitɔn yɛngɛ so xinla ma ɛ yɛ. E sigama Midiyan kaane nan yɛngɛdeyi, alogo Alatala xa e fe ɲaxine saran e ra. ");
INSERT INTO yal_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Nayi, ɛ xa yɛngɛ soon muxu wuli keden keden tongo Isirayila bɔnsɔnne birin yi.” ");
INSERT INTO yal_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","E yi muxu wuli fu nun firin tongo Isirayila ganle yɛ yɛngɛ so xinla ma. Bɔnsɔn keden, wuli keden. ");
INSERT INTO yal_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa yi e rasiga yɛngɛni, bɔnsɔn yo bɔnsɔn muxu wuli keden, e nun Finexasi, saraxarali Eleyasari a dii xɛmɛna, naxan se rasariɲanxina ndee xali e nun xɔtaan naxanye fema yɛngɛni. ");
INSERT INTO yal_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","E yi siga Midiyan yamanan yɛngɛdeni alo Alatala a yamari Musa ma kii naxan yi. E yi xɛmɛne birin faxa. ");
INSERT INTO yal_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","E Midiyan manga suulun fan faxa, Efi nun Rekemi nun Suru nun Xuru nun Reba. E Beyori a dii Balami fan faxa silanfanna ra. ");
INSERT INTO yal_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","E yi Midiyan ɲaxanle nun e diine tongo, e nun e xuruseene nun e yii seene birin. ");
INSERT INTO yal_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","E yi e taane nun e dɔxɔdene birin gan. ");
INSERT INTO yal_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","E yi se tongoxine birin xali e nun muxune nun xuruseene. ");
INSERT INTO yal_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","E yi fa suxu muxune nun se tongoxine ra Musa nun saraxarali Eleyasari nun Isirayila yamaan fɛma daaxadeni Moyaba mɛrɛmɛrɛni Yurudɛn baan dɛxɔn Yeriko yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa nun saraxarali Eleyasari nun yamaan mangane yi siga e ralandeni daaxaden fari ma. ");
INSERT INTO yal_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa yi xɔlɔ gali kuntigine ma naxanye muxu wuli xun na e nun naxanye muxu kɛmɛ xun na naxanye yi kelima na yɛngɛni. ");
INSERT INTO yal_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musa yi e maxɔdin, a naxa, “Nanfera ɛ ɲaxanle luxi e nii ra? ");
INSERT INTO yal_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","E tan nan Balami a kawandin namɛ, e Isirayila kaane bira tinxintareyani Alatala ra Peyori yi, fitina furen yi so Alatala yamani. ");
INSERT INTO yal_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Iki ɛ dii xɛmɛne birin faxa, e nun ɲaxanla naxanye xɛmɛ feen kolon. ");
INSERT INTO yal_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Koni ɛ nɔɛ sungutun nasɔlɔnxine ramarɛ nɛn ɛ yɛtɛ xa. ");
INSERT INTO yal_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Naxanye birin faxan tixi ɛ yɛ hanma e yiin din muxu faxaxin na, ne xa lu daaxaden fari ma xii solofere. Ɛ lan ɛ yi ɛ rasariɲan xii saxanden nun xii soloferede lɔxɔni e nun ɛ suxu muxune. ");
INSERT INTO yal_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Ɛ mɔn xa dugine rasariɲan, e nun seen naxanye rafalaxi kidin na hanma sii xaben na hanma wudin na.” ");
INSERT INTO yal_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Sofaan naxanye keli yɛngɛni, saraxarali Eleyasari yi a fala ne xa, a naxa, “Alatala ito nan yamarixi Musa ma a sariyani: ");
INSERT INTO yal_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Xɛmaan nun gbetin nun sulan nun wuren nun yɔxɔna, ");
INSERT INTO yal_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","e nun tɛɛn mi naxanye birin ganma, ɛ xa ne rasariɲan tɛɛn nan na. Na xanbi ra, ɛ yi e rasin marasariɲan igeni. Naxanye ganma, ɛ ne rasin marasariɲan igeni gbansan. ");
INSERT INTO yal_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ɛ na ɛ dugine xa xii soloferede lɔxɔni, ɛ sariɲanma nɛn. Nayi, ɛ nɔɛ soɛ nɛn daaxadeni.” ");
INSERT INTO yal_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“I tan nun saraxarali Eleyasari nun yamaan xabila mangane, ɛ muxune nun xuruseene birin tɛngɛ naxanye tongoxi yɛngɛni. ");
INSERT INTO yal_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Na xanbi ra, i xa e yitaxun firinna ra, fɔxɔ kedenna sofane nan gbeen na ra naxanye siga yɛngɛni, fɔxɔ kedenna yamaan dɔnxɛn nan gbeen na ra. ");
INSERT INTO yal_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","I xa ndedi ba sofane gbeen na mudun na Alatala xa: i muxu keden ba muxu kɛmɛ suulunna ra hanma xuruse kɛmɛ suulun e nun ɲingene nun sofanle nun yɛxɛɛne nun siine birin. ");
INSERT INTO yal_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","I xa muduni ito ba e gbeen na, i yi a so saraxarali Eleyasari yii Alatala gbeen na. ");
INSERT INTO yal_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Isirayila yamaan dɔnxɛn gbeen tan, i xa muxu keden ba muxu tonge suulunna ra, hanma xuruse tonge suulun e nun ɲingene nun sofanle nun yɛxɛɛne nun siine birin. I yi e so Lewi bɔnsɔnna muxune yii, Alatala Batu Bubun taxuxi naxanye ra.” ");
INSERT INTO yal_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Musa nun saraxarali Eleyasari yi a liga alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Sofane seen naxanye tongo yɛngɛni, itoe nan lu yɛngɛn xanbini: xuruse xunxuri wuli kɛmɛ sennin wuli tonge solofere wuli suulun, ");
INSERT INTO yal_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ɲinge wuli tonge solofere wuli firin, ");
INSERT INTO yal_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","sofali wuli tonge sennin wuli keden, ");
INSERT INTO yal_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","e nun sungutun nasɔlɔnxi wuli tonge saxan wuli firin. ");
INSERT INTO yal_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Naxan yitaxun yɛngɛsone ra na ni i ra: xuruse xunxuri wuli kɛmɛ saxan wuli tonge saxan e nun solofere kɛmɛ suulun, ");
INSERT INTO yal_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","xuruse xunxurin kɛmɛ sennin tonge solofere e nun suulun yi ba a ra mudun na Alatala xa, ");
INSERT INTO yal_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","e nun ɲinge wuli tonge saxan wuli senninne, ɲinge tonge solofere e nun firin yi ba a ra mudun na Alatala xa, ");
INSERT INTO yal_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","e nun sofali wuli tonge saxan kɛmɛ suulunna, sofali tonge sennin e nun keden yi ba a ra mudun na Alatala xa, ");
INSERT INTO yal_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","e nun muxu wuli fu nun senninna, muxu tonge saxan e nun firin yi ba a ra mudun na Alatala xa. ");
INSERT INTO yal_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Musa yi na mudun so saraxarali Eleyasari yii Alatala gbeen na, alo Alatala a yamari a ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Isirayila yamaan gbeen ni i ra Musa naxan dɔxɔ a danna. ");
INSERT INTO yal_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Yamaan gbeena: xuruse xunxuri wuli kɛmɛ saxan wuli tonge saxan wuli solofere kɛmɛ suulun, ");
INSERT INTO yal_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","e nun ɲinge wuli tonge saxan wuli sennin, ");
INSERT INTO yal_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","e nun sofali wuli tonge saxan kɛmɛ suulun, ");
INSERT INTO yal_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","e nun muxu wuli fu nun sennin. ");
INSERT INTO yal_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Naxan soxi Isirayila kaane yii, Musa yi muxu keden ba muxu tonge suulunna ra, a xuruse keden ba xuruse tonge suulunna ra, alo Alatala a yamari a ma kii naxan yi. A yi e so Lewi bɔnsɔnna muxune yii, Ala Batu Bubun yi taxuxi naxanye ra. ");
INSERT INTO yal_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Ganla kuntigine yi siga Musa fɛma naxanye muxu wuli xun na e nun naxanye muxu kɛmɛ xun na. ");
INSERT INTO yal_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","E yi a fala a xa, e naxa, “Sofaan naxanye nxɔ yamarine bun, nxu bata ne tɛngɛ. Hali keden mi baxi nxu ra. ");
INSERT INTO yal_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Nanara, nxu xɛma seen naxanye sɔtɔxi, nxu bata fa ne ra Alatala xɔn a kiseen na nxu niin xunba saranna ra: kɔɛ birane, yii kɔɛ rasone, yii soli rasone, tunla sone, e nun ɲɛrɛne.” ");
INSERT INTO yal_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa nun saraxarali Eleyasari yi na xɛma muranne birin nasuxu e ra. ");
INSERT INTO yal_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Kuntigin naxanye muxu wuli xun na e nun naxanye muxu kɛmɛ xun na, ne xɛma seene binyan yi sigɛ han kilo kɛmɛ tonge solofere, e naxanye fi Alatala ma. ");
INSERT INTO yal_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Sofane tan yi e se tongoxine ramara e yii. ");
INSERT INTO yal_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa nun saraxarali Eleyasari yi kuntigine xɛmaan tongo, e yi a xali Naralan Bubuni, alogo Alatala xa a ɲɔxɔ lu Isirayila kaane xɔn. ");
INSERT INTO yal_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Xuruse wuyaxi yi Rubɛn nun Gadi bɔnsɔnne yii. E yi a to a Yaasɛri nun Galadi bɔxɔn yi fan e xuruseene xa. ");
INSERT INTO yal_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Nayi, Gadi kaane nun Rubɛn kaane yi fa Musa nun saraxarali Eleyasari nun yamaan mangane fɛma, e yi a fala, e naxa, ");
INSERT INTO yal_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Alatala yamanan naxanye nɔxi Isirayila yamaan xa, Ataroti nun Dibon nun Yaasɛri nun Nimira nun Xɛsibɔn nun Eleyale nun Sebami nun Nebo nun Bewoni, ");
INSERT INTO yal_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","na yamanane fan xuruseene xa, anu xuruseene nxu tan yii han, nxu tan ɛ walikɛne.” ");
INSERT INTO yal_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","E yi a fala, e naxa, “Xa ɛ tinɲɛ nxɔ falan ma, na bɔxɔn xa so nxu yii, ɛ nama nxu xali Yurudɛn baan kidi ma.” ");
INSERT INTO yal_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa yi a fala e xa, a naxa, “Ɛ tan dɔxɔn nɛn be ba, ɛ ngaxakedenne yi siga yɛngɛ sodeni? ");
INSERT INTO yal_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Nanfera ɛ Isirayila kaane tunnaxɔlɔma sigadeni yamanani Alatala naxan soxi e yii? ");
INSERT INTO yal_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ɛ fafane fan na nan liga bonni, n to e rasiga yamanan matodeni keli Kadesi-Barineya yi. ");
INSERT INTO yal_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","E te nɛn han Esikoli mɛrɛmɛrɛni. E to yelin yamanan matoɛ, e yi Isirayila kaane tunnaxɔlɔ e ma alogo e nama siga yamanani Alatala naxan soxi e yii. ");
INSERT INTO yal_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Na lɔxɔni Alatala yi xɔlɔ, a yi a kɔlɔ, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Muxuni itoe naxan minixi Misiran yi, naxanye barin bata dangu ɲɛɛ mɔxɔɲɛn na, ne mi bɔxɔn toma n na n kɔlɔxi naxan so fe ra Iburahima nun Isiyaga nun Yaxuba yii, amasɔtɔ e mi luxi n fɔxɔ ra ki faɲi. ");
INSERT INTO yal_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Fɔ Yefune a dii Kalebi, Kenisi kaana, e nun Nunu a dii Yosuwe, bayo e lu nɛn Alatala fɔxɔ ra ki faɲi.’ ");
INSERT INTO yal_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Alatalaa xɔlɔ gbeen keli nɛn Isirayila kaane xili ma, a yi e rasiga tonbonna xun xɔn ɲɛɛ tonge naanin, han na waxatin muxune birin yi ɲan naxanye fe ɲaxin liga Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Iki ɛ tan yulubi kanne, ɛ faxi ɛ fafane nan ma. Ɛ Alatala raxɔlɔma nɛn Isirayila xili ma dangu e ra. ");
INSERT INTO yal_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Anu, xa ɛ xɛtɛ a fɔxɔ ra, a mɔn yamani ito birin luma nɛn tonbonni, ɛ yi findi yamaan birin halagi xunna ra.” ");
INSERT INTO yal_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Na muxune mɔn yi e maso Musa ra e yi a fala a xa, e naxa, “Nxu waxi sansanne sa feni be nxɔ xuruseene xa nxu yi taane ti nxɔ denbayane xa. ");
INSERT INTO yal_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Na xanbi ra, nxu yɛngɛ so seene tongɛ, nxu yi ti Isirayila kaan bonne yɛɛ ra, nxu yi e xali e yirene yi. Nayi, nxɔ denbayane luma nɛn taa makantanxine kui, e ratanga yamanani ito muxune ma. ");
INSERT INTO yal_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nxu mi xɛtɛ nxu konne yi, fɔ Isirayila kaane birin na dɔxɔ e bɔxɔne yi. ");
INSERT INTO yal_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Nxu mi bɔxɔn sɔtɔma Yurudɛn baan fɔxɔ kedenni alo e tan, bayo nxu bata nxɔ bɔxɔn sɔtɔ be binni baan sogeteden binni.” ");
INSERT INTO yal_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Musa yi a fala e xa, a naxa, “Xa ɛ falani ito liga, xa ɛ yɛngɛ so seene tongo Alatala xa, ");
INSERT INTO yal_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","xa ɛ sofane birin Yurudɛn baan gidi Alatala yɛtagi han a yi a yaxune birin kedi, ");
INSERT INTO yal_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","xa yamanan lu Alatala nɔɔn bun, nayi Alatala nun Isirayila tinma nɛn ɛ yi xɛtɛ be. Nayi, yamanani ito findima nɛn ɛ gbeen na Alatala yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Koni xa ɛ mi na liga, ɛ bata yulubin liga Alatala ra. Ɛ xa a kolon, fa fala ɛ yulubin saranna ɛ lima nɛn. ");
INSERT INTO yal_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Awa, ɛ xa taane ti ɛ denbayane xa, e nun sansanne ɛ xuruse kurune xa, koni ɛ xa ɛ dɛ ti xuine rakamali de!” ");
INSERT INTO yal_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gadi kaane nun Rubɛn kaane yi a fala Musa xa, e naxa, “Nxu tan, i ya walikɛne a ligama nɛn alo i a yamarixi kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nxɔ diine nun nxɔ ɲaxanle nun nxɔ xuruseene birin luma nɛn Galadi taane yi. ");
INSERT INTO yal_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Koni nxu tan i ya walikɛne birin yɛngɛ so seene tongoma nɛn, nxu siga yɛngɛ sodeni Alatala yɛtagi, alo nxu kanna a falaxi kii naxan yi.” ");
INSERT INTO yal_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Musa yi yamarin fi saraxarali Eleyasari ma e nun Nunu a dii Yosuwe ma, e nun Isirayila bɔnsɔn mangane ma e fe ra. ");
INSERT INTO yal_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Musa yi a fala e xa, a naxa, “Xa Gadi kaane nun Rubɛn kaane Yurudɛn baan gidi ɛ fɔxɔ ra, e birin yi yɛngɛ so seene tongo Alatala xa, nayi yamanan na lu ɛ nɔɔn bun, ɛ Galadi yamanan so e yii e gbeen na. ");
INSERT INTO yal_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Koni xa e birin mi gidi ɛ fɔxɔ ra yɛngɛ so seene ra e yii, e xa dɔxɔ ɛ tagi Kanan bɔxɔni.” ");
INSERT INTO yal_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gadi kaane nun Rubɛn kaane yi a fala, e naxa, “Alatala bata naxan fala, nxu tan i ya walikɛne na ligama nɛn. ");
INSERT INTO yal_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nxu gidima nɛn Kanan yamanani Alatala xa yɛngɛ so seene ra nxu yii, koni nxu kɛɛ bɔxɔn sɔtɔma nɛn Yurudɛn baan be binni.” ");
INSERT INTO yal_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Musa yi Amorine manga Sixɔn ma yamanan nun Basan manga Ogo a yamanan so Gadi kaane nun Rubɛn kaane nun Yusufu a dii Manase bɔnsɔnna fɔxɔ kedenna yii, e nun e taane nun bɔxɔn naxanye e rabilinni. ");
INSERT INTO yal_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gadi kaane yi Dibon nun Ataroti nun Aroyeri nun ");
INSERT INTO yal_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atiroti-Sofani nun Yaasɛri nun Yogboha nun ");
INSERT INTO yal_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beti-Nimira nun Beti-Haran ti taa makantanxine ra, e yi xuruse sansanne sa. ");
INSERT INTO yal_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Rubɛn kaane yi Xɛsibɔn ti, e nun Eleyale nun Kiriyatayimi nun ");
INSERT INTO yal_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo nun Baali-Meyɔn, e naxanye xiliye masara, e nun Sibima. E taan naxanye ti e yi ne xili sa. ");
INSERT INTO yal_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Manase a dii Makiri yixɛtɛne yi siga Galadi yi, e yi a suxu, e yi Amorine kedi naxanye yi dɔxi na. ");
INSERT INTO yal_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Nayi, Musa yi Galadi so e yii alogo e xa dɔxɔ na. ");
INSERT INTO yal_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yayiri, Manase yixɛtɛna nde yi siga, a yi taadina ndee suxu, a yi e xili sa “Yayiriya.” ");
INSERT INTO yal_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba yi siga, a yi Kenata suxu e nun a banxidɛne, a yi a xili sa “Nobaya.” ");
INSERT INTO yal_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Isirayila kaane sigadene ni i ra e to mini Misiran yi e gali yɛɛn ma, Musa nun Haruna yamarin bun. ");
INSERT INTO yal_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Musa yi tidene sɛbɛma Alatalaa yamarin nan ma. E sigadene ni i ra, e tide yɛɛn ma. ");
INSERT INTO yal_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","E keli Ramisesi yi kike singen xii fu nun suulundeni Halagi Tiin Dangu Lɔxɔn Sanla kuye baani. Isirayila kaane xɔrɔyaxin yi mini Misiran kaane birin yɛtagi, ");
INSERT INTO yal_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Misiran kaane yi e dii singene binbine maluxunma waxatin naxan yi Alatala naxanye faxa e yɛ. Amasɔtɔ Alatala e alane yalagi nɛn. ");
INSERT INTO yal_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Isirayila kaane yi keli Ramisesi yi, e sa daaxa Sukɔti yi. ");
INSERT INTO yal_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","E yi keli Sukɔti yi, e sa daaxa Etama yi tonbonna danna ra. ");
INSERT INTO yal_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","E yi keli Etama yi, e yi xɛtɛ han Pihahiroti yi, Baali-Sefɔn yɛtagi, e yi sa daaxa Migidoli dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","E yi keli Pihahiroti yi, e yi baan gidi tonbonna binni, e yi xii saxan siga ti Etama tonbonni, e yi sa daaxa Mara yi. ");
INSERT INTO yal_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","E yi keli Mara yi, e siga Elimi yi, tigi fu nun firin e nun tugu bili tonge solofere yi dɛnaxan yi. E yi daaxa mɛnni. ");
INSERT INTO yal_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","E yi keli Elimi yi, e sa daaxa Gbala Baan dɛxɔn. ");
INSERT INTO yal_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","E yi keli Gbala Baani, e sa daaxa Sin tonbonni. ");
INSERT INTO yal_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","E yi keli Sin tonbonni, e sa daaxa Dofika yi. ");
INSERT INTO yal_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","E yi keli Dofika yi, e sa daaxa Alusi yi. ");
INSERT INTO yal_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","E yi keli Alusi yi, e sa daaxa Refidimi yi, yamaan mi min igen sɔtɔ dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","E yi keli Refidimi yi, e sa daaxa Sinayi tonbonni. ");
INSERT INTO yal_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","E yi keli Sinayi tonbonni, e sa daaxa Kibiroti-Hatawa yi. ");
INSERT INTO yal_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","E yi keli Kibiroti-Hatawa yi, e sa daaxa Xaserɔti yi. ");
INSERT INTO yal_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","E yi keli Xaserɔti yi, e sa daaxa Ritima yi. ");
INSERT INTO yal_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","E yi keli Ritima yi, e sa daaxa Rimɔn-Peresi yi. ");
INSERT INTO yal_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","E yi keli Rimɔn-Peresi yi, e sa daaxa Libina yi. ");
INSERT INTO yal_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","E yi keli Libina yi, e sa daaxa Risa yi. ");
INSERT INTO yal_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","E yi keli Risa yi, e sa daaxa Kehelata yi. ");
INSERT INTO yal_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","E yi keli Kehelata yi, e sa daaxa Saferi geyaan ma. ");
INSERT INTO yal_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","E yi keli Saferi geyaan ma, e sa daaxa Harada yi. ");
INSERT INTO yal_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","E yi keli Harada yi, e sa daaxa Makeloti yi. ");
INSERT INTO yal_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","E yi keli Makeloti yi, e sa daaxa Taxati yi. ");
INSERT INTO yal_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","E yi keli Taxati yi, e sa daaxa Tera yi. ");
INSERT INTO yal_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","E yi keli Tera yi, e sa daaxa Mitika yi. ");
INSERT INTO yal_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","E yi keli Mitika yi, e sa daaxa Hasimona yi. ");
INSERT INTO yal_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","E yi keli Hasimona yi, e sa daaxa Moseroti yi. ");
INSERT INTO yal_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","E yi keli Moseroti yi, e sa daaxa Bene-Yakani yi. ");
INSERT INTO yal_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","E yi keli Bene-Yakani yi, e sa daaxa Horo-Gidigadi yi. ");
INSERT INTO yal_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","E yi keli Horo-Gidigadi yi, e sa daaxa Yotobata yi. ");
INSERT INTO yal_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","E yi keli Yotobata yi, e sa daaxa Abirona yi. ");
INSERT INTO yal_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","E yi keli Abirona yi, e sa daaxa Esiyon-Gebere yi. ");
INSERT INTO yal_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","E yi keli Esiyon-Gebere yi, e sa daaxa Kadesi yi Sini tonbonni. ");
INSERT INTO yal_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","E yi keli Kadesi yi, e sa daaxa Horo geyaan ma, Edɔn yamanan danna. ");
INSERT INTO yal_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Saraxarali Haruna yi te Horo geyaan ma, Alatalaa yamarin ma. A sa faxa mɛnni, Isirayila kaane minin ɲɛɛ tonge naanindeni Misiran yi a kike suulunden xii singeni. ");
INSERT INTO yal_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Haruna bata yi ɲɛɛ kɛmɛ mɔxɔɲɛn nun saxan sɔtɔ siimayaan na a faxa waxatin naxan yi Horo geyaan fari. ");
INSERT INTO yal_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Kanan Manga Aradi naxan yi dɔxi Negewi yi Kanan yamanani, na yi Isirayila kaane fa feen mɛ. ");
INSERT INTO yal_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","E yi keli Horo geyaan ma, e sa daaxa Salimona yi. ");
INSERT INTO yal_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","E yi keli Salimona yi, e sa daaxa Punon yi. ");
INSERT INTO yal_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","E yi keli Punon yi, e sa daaxa Oboti yi. ");
INSERT INTO yal_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","E yi keli Oboti yi, e sa daaxa Ye-Abarimi yi Moyaba danna ra. ");
INSERT INTO yal_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","E yi keli Iyimi yi, e sa daaxa Dibon-Gadi yi. ");
INSERT INTO yal_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","E yi keli Dibon-Gadi yi, e sa daaxa Alamɔn-Dibilatayimi yi. ");
INSERT INTO yal_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","E yi keli Alamɔn-Dibilatayimi yi, e sa daaxa Abarimi geyane yi Nebo yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","E yi keli Abarimi geyane yi, e sa daaxa Moyaba mɛrɛmɛrɛne yi, Yurudɛn baan dɛxɔn, Yeriko yɛtagi. ");
INSERT INTO yal_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","E yi daaxa Yurudɛn baan dɛxɔn Moyaba mɛrɛmɛrɛne yi, keli Beti-Yɛsimoti yi han Abeli-Sitimi. ");
INSERT INTO yal_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Alatala yi a fala Musa xa Moyaba mɛrɛmɛrɛne yi Yurudɛn baan dɛxɔn Yeriko yɛtagi, ");
INSERT INTO yal_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","a Musa xa a fala Isirayila kaane xa, a naxa, “Ɛ na Yurudɛn baan gidi, ɛ so Kanan yamanani, ");
INSERT INTO yal_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ɛ xa yamanan muxune birin kedi. Ɛ e suxure gɛmɛne nun suxure wurene kala, e nun e taane kidene. ");
INSERT INTO yal_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Ɛ e yamanan tongo ɛ yi dɔxɔ na, amasɔtɔ n bata a so ɛ yii ɛ gbeen na. ");
INSERT INTO yal_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Ɛ masɛnsɛnna ti, ɛ yamanani taxun bɔnsɔnne ra. Naxanye wuya, ɛ kɛɛ bɔxɔ gbeen so ne yii. Naxanye mi wuya ɛ xa a xurin so ne yii. E na naxan sɔtɔ masɛnsɛnna xɔn, e gbeen nan na ra. Kɛɛ bɔxɔne yitaxunma ɛ fafane bɔnsɔn yɛɛn nan ma. ");
INSERT INTO yal_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Koni xa ɛ mi yamanan muxune birin kedi, ɛ na naxanye lu na, ne ɛ tɔrɔma nɛn alo tansinna ɛ yɛɛne xɔn hanma ɲanla naxanye ɛ fatin masɔxɔnma. E ɛ tɔrɔma nɛn yamanani ɛ dɔxɔma dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Nayi, n naxan nagidixi e ma, na ligama ɛ tan nan na.” ");
INSERT INTO yal_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","a a xa a yamari Isirayila kaane ma, a naxa, “Ɛ na so Kanan yamanani, n bɔxɔn naxan soma ɛ yii ɛ kɛɛn na, na danne ni i ra: ");
INSERT INTO yal_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Ɛ yamanan yiifari fɔxɔn danna findima Sini tonbonna nan na, Edɔn yamanan danna ra. Na danna fɔlɔma Fɔxɔ Daraan yiifari fɔxɔn nin sogeteden binni. ");
INSERT INTO yal_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","A bilinma nɛn Akaribimi geyaan yiifari fɔxɔni, siga Sini binni, dangu Kadesi-Barineya yiifari fɔxɔn ma han Xasari-Adari han Asimon. ");
INSERT INTO yal_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Keli Asimon yi, danna mɔn danguma nɛn sa dɔxɔ Misiran xuden na, a sa dɔxɔ fɔxɔ igen na. ");
INSERT INTO yal_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Sogegodode binni, danna findima fɔxɔ ige gbeen nan na. ");
INSERT INTO yal_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Kɔmɛnna ma, ɛ xa danna sa fɔxɔ ige gbeen nun Horo geyaan tagi. ");
INSERT INTO yal_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Keli Horo geyaan ma, ɛ yi a radangu Lebo-Xamata han Sedadi yi. ");
INSERT INTO yal_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","A yi siga han Sifiron, sa dɔxɔ Xasari-Enan na. Ɛ kɔmɛn ma danna nan na ra. ");
INSERT INTO yal_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Sogeteden binni, ɛ xa danna sa keli Xasari-Enan yi siga Sefami binni. ");
INSERT INTO yal_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Keli mɛnni, a yi siga Ribila binni, Ayin sogeteden binni, sa dɔxɔ tintin yiren na Kinɛrɛti Daraan sogetedeni. ");
INSERT INTO yal_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Danna yi sa dɔxɔ Yurudɛn Baan na siga Fɔxɔ Darani. Ɛ yamanan danne findin ne nan na.” ");
INSERT INTO yal_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Musa yi na yamarine rali Isirayila kaane ma. A mɔn yi a fala e xa, a naxa, “Alatala yamanani ito nan yitaxunma bɔnsɔn solomanaanin nun a tagiin na masɛnsɛnna xɔn. ");
INSERT INTO yal_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Amasɔtɔ Rubɛn bɔnsɔnna nun Gadi bɔnsɔnna nun Manase bɔnsɔnna fɔxɔ kedenna bata yi e kɛɛ bɔxɔn sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Bɔnsɔn firin nun a tagini ito bata e kɛɛ bɔxɔn sɔtɔ Yurudɛn Baan sogeteden binni, Yeriko yɛtagi.” ");
INSERT INTO yal_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Alatala yi a fala Musa xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Saraxarali Eleyasari nun Nunu a dii Yosuwe xa yamanani taxun. ");
INSERT INTO yal_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","I mɔn xa bɔnsɔn manga keden keden sa e fari e malideni.” ");
INSERT INTO yal_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","E xinle ni itoe ra: Yefune a dii Kalebi Yuda bɔnsɔnni, ");
INSERT INTO yal_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Amixudi a dii Semuyɛli Simeyɔn bɔnsɔnni, ");
INSERT INTO yal_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Kisilon ma dii Elidadi Bunyamin bɔnsɔnni, ");
INSERT INTO yal_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Yogili a dii Buki, Dan bɔnsɔn mangana, ");
INSERT INTO yal_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Efodi a dii Xaniyeli, Yusufu a dii Manase bɔnsɔn mangana, ");
INSERT INTO yal_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Sifitan ma dii Kɛmuyɛli, Yusufu a dii Efirami bɔnsɔn mangana, ");
INSERT INTO yal_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Parinaki a dii Elisafan, Sabulon bɔnsɔn mangana, ");
INSERT INTO yal_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Asan ma dii Palitiyɛli, Isakari bɔnsɔn mangana, ");
INSERT INTO yal_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Selomi a dii Axixudi, Aseri bɔnsɔn mangana, ");
INSERT INTO yal_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","e nun Amixudi a dii Pedaheli Nafatali bɔnsɔn mangana. ");
INSERT INTO yal_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Alatala ne nan yamarixi e xa Kanan yamani taxun Isirayila kaane ra. ");
INSERT INTO yal_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Alatala yi a fala Musa xa Moyaba mɛrɛmɛrɛne yi Yurudɛn Baan dɛxɔn Yeriko yɛtagi, a naxa, ");
INSERT INTO yal_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Isirayila kaane yamari a e xa taane ba e kɛɛ bɔxɔne ra e yi e fi Lewi bɔnsɔnna muxune ma, alogo e xa dɔxɔ na. E mɔn yi na taane rabilin xɛɛne so e yii. ");
INSERT INTO yal_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Nayi, Lewi bɔnsɔnna muxune taane sɔtɔma nɛn e dɔxɔdene ra, e yi bɔxɔne sɔtɔ e rabilinni e ɲingene nun e seene nun e xuruseene xa. ");
INSERT INTO yal_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Ɛ bɔxɔn naxanye soma Lewi bɔnsɔnna muxune yii, ne danne nun taane yinne xa makuya e bode ra han nɔngɔnna yɛ wuli keden. ");
INSERT INTO yal_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Taan fɔxɔ naaninne kuyan xa lan, nɔngɔnna yɛ wuli firin sogeteden binni, nɔngɔnna yɛ wuli firin yiifari fɔxɔni, nɔngɔnna yɛ wuli firin sogegododen binni, e nun nɔngɔnna yɛ wuli firin kɔmɛnna ma. Taan xa lu a tagini. E xɛɛne danne sama na kii nin. ");
INSERT INTO yal_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Ɛ taan naxanye soma Lewi bɔnsɔnna muxune yii, ɛ xa sennin sugandi ne yɛ marakisi taane ra alogo muxun naxan na faxan ti, a xa a gi, a siga mɛnna nde yi. Ɛ mɔn xa taa tonge naanin nun firin gbɛtɛye so e yii. ");
INSERT INTO yal_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","A malanxina, ɛ taa tonge naanin nun solomasɛxɛ nan soma Lewi bɔnsɔnna muxune yii e nun e rabilinne xɛɛne. ");
INSERT INTO yal_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Isirayila bɔnsɔnna birin xa taana ndee so e yii naxan nun a bɔnsɔnna lan. Taa gbegbe xa ba bɔnsɔn gbeene bɔxɔne ra, ndedi yi ba bɔnsɔn xurine bɔxɔne ra.” ");
INSERT INTO yal_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Alatala yi a fala Musa xa, ");
INSERT INTO yal_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","a a xa a fala Isirayila kaane xa, a naxa, “Ɛ na Yurudɛn baan gidi ɛ so Kanan yamanani, ");
INSERT INTO yal_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ɛ xa taana ndee sugandi marakisi taane ra. Naxan na faxan ti a mi a rakelixi a ma, a a gima nɛn a siga mɛnna nde yi. ");
INSERT INTO yal_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","A yi ratanga faxa muxun gbeeɲɔxɔ muxun ma mɛnni, alogo a nama faxa benun yamaan yi a makiti. ");
INSERT INTO yal_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Ɛ taan naxanye soma e yii, taa sennin nan findima marakisi taane ra ne yɛ. ");
INSERT INTO yal_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Marakisi taa saxan xa lu Yurudɛn baan sogeteden binni, saxan Kanan yamanani. ");
INSERT INTO yal_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Muxune ratangama nɛn taa senninni itoe yi, Isirayila kaana hanma xɔɲɛn naxan dɔxi Isirayila kaane yɛ. Naxan na faxan ti, a mi a rakeli a ma, fɔ a xa a gi, a siga mɛnna nde yi.” ");
INSERT INTO yal_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Xa muxuna nde faxan ti wure ma seen na, faxa tiin nan na kanna ra. A lan a yi faxa. ");
INSERT INTO yal_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Xa a gɛmɛn tongo naxan muxun faxɛ, a muxuna nde gɔlɔn a ra, a yi a faxa, faxa tiin nan na kanna ra. A lan a yi faxa. ");
INSERT INTO yal_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Xa a wudin tongo naxan muxun faxɛ, a yi muxuna nde bɔnbɔ a ra, a faxa, faxa tiin nan na kanna ra. A lan a yi faxa. ");
INSERT INTO yal_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Faxa muxun gbeeɲɔxɔ muxun nan faxa tiin faxama. A na a to, a xa a faxa. ");
INSERT INTO yal_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Xa muxuna nde a boden nabira, a bata yi a yitɔn xɔnnantenyani, hanma a a rakeli a ma, a yi a gɔlɔn, a yi a faxa, ");
INSERT INTO yal_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","hanma a yi a bɔnbɔ xɔnnantenyani, a yi a faxa, faxa tiin nan na kanna ra. A lan a yi faxa. Faxa muxun gbeeɲɔxɔ muxun na a to, a xa a faxa.” ");
INSERT INTO yal_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Koni xa muxuna nde a boden nabira tantanni, xɔnnantenyaan mi a ra, hanma a a gɔlɔn, a mi a rakeli a ma, ");
INSERT INTO yal_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","hanma a mi a toxi, a yi gɛmɛn nabira a ma naxan a faxɛ, a yi faxa, nayi bayo a yaxu mi a ra, a mi yi waxi fe ɲaxin liga feni a ra, ");
INSERT INTO yal_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","yamaan xa faxa tiin nun faxa muxun gbeeɲɔxɔ muxun makiti na sariyane xɔn. ");
INSERT INTO yal_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Yamaan xa faxa tiin xun mafala faxa muxun gbeeɲɔxɔ muxun xɔn, e mɔn yi a xali marakisi taani a yi dɛnaxan yi. Faxa tiin xa lu marakisi taani han saraxarali kuntigin yi faxa, naxan masusan ture sariɲanxin na. ");
INSERT INTO yal_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Koni xa faxa tiin mini marakisi taan danna ra, a yi dɛnaxan yi ");
INSERT INTO yal_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","faxa muxun gbeeɲɔxɔ muxun yi a to marakisi taan bɔxɔn fari ma, faxa muxun gbeeɲɔxɔ muxun nɔɛ nɛn a faxadeni, a mi yatɛma faxa tiin na. ");
INSERT INTO yal_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Amasɔtɔ faxa tiin lan nɛn a lu marakisi taani han saraxarali kuntigin yi faxa. Fɔ na na faxa a yi nɔ xɛtɛ a bɔxɔne yi.” ");
INSERT INTO yal_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“Ɛ sariyane nan ne ra waxati famatɔne birin yi, ɛ nɛma dɔxi dɛdɛ yi. ");
INSERT INTO yal_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Naxan na muxun faxa, e xa a faxa xa sereyane sereyaan ba a a funfun na a ra. Koni ɛ nama muxu yo faxa sereya kedenna fala xuiin ma.” ");
INSERT INTO yal_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“Ɛ nama gbetin nasuxu faxa tiin xunba saren na naxan lan a faxa. Ɛ xa a faxa. ");
INSERT INTO yal_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Ɛ nama gbetin nasuxu muxun yii naxan bata a gi, a siga marakisi taani, alogo a mɔn xa xɛtɛ, a dɔxɔ a bɔxɔni benun saraxarali kuntigin xa faxa. ");
INSERT INTO yal_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Ɛ nama yamanan naxɔsi ɛ dɔxi dɛnaxan yi. Anu, muxu faxan yamanan xɔsima nɛn. Bɔxɔn mi rasariɲanma faxa tixin ma fɔ faxa tiin na faxa. ");
INSERT INTO yal_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Ɛ nama yamanan naxɔsi ɛ dɔxi dɛnaxan yi, e nun n tan fan dɔxi dɛnaxan yi. Amasɔtɔ Alatala nan n tan na, naxan dɔxi Isirayila kaane tagi.” ");
INSERT INTO yal_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Denbaya xunna ndee yi fa fala tideni Musa nun Isirayila bɔnsɔnne yɛɛratine xa keli Makiri a dii Galadi bɔnsɔnni, Manase mamandenna, Yusufu yixɛtɛne xabilane. ");
INSERT INTO yal_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","E yi a fala, e naxa, “Alatala to a yamari nxu kanna Musa ma a a xa kɛɛ bɔxɔne yitaxun Isirayila kaane ra masɛnsɛnna xɔn, a mɔn a yamarixi a ma nɛn a a xa nxu ngaxakedenna Selofexadi kɛɛn so a dii tɛmɛne yii. ");
INSERT INTO yal_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Iki xa Isirayila bɔnsɔn gbɛtɛ xɛmɛna e futu, e kɛɛ bɔxɔn bama nɛn nxu bɔnsɔnna gbeen na, a sa e bɔnsɔn nɛnɛna bɔxɔn fari. Nayi, kɛɛ bɔxɔn naxan soxi nxu bɔnsɔnna yii masɛnsɛnna xɔn, na nde bama a ra nɛn. ");
INSERT INTO yal_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Nayi, Isirayila Xɔrɔya Ɲɛɛn na a li, e kɛɛ bɔxɔn bama nɛn nxɔ bɔnsɔnna gbeen na, a sa e bɔnsɔn nɛnɛn gbeen fari.” ");
INSERT INTO yal_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Musa yi Alatalaa yamarine rali Isirayila kaane ma, a naxa, “Yusufu a diine bɔnsɔnna muxune ɲɔndi. ");
INSERT INTO yal_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Alatalaa yamarin ni i ra Selofexadi a dii tɛmɛne fe yi: Xɛmɛn naxan na e kɛnɛn e xa dɔxɔ na xɔn, koni a xa findi e baba bɔnsɔnna xabilan muxuna nde nan na, ");
INSERT INTO yal_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","alogo Isirayila kɛɛ bɔxɔne nama keli bɔnsɔn gbɛtɛ yi siga bɔnsɔn gbɛtɛ yi. Isirayila kaane birin xa e benbane bɔnsɔnna kɛɛ bɔxɔn nan sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Xa ɲaxalan yo bɔxɔn sɔtɔ kɛɛn na Isirayila bɔnsɔnna nde yi, a xa dɔxɔ a baba bɔnsɔnna xabilan muxuna nde xɔn, alogo Isirayila kaane birin xa e benbane kɛɛ bɔxɔn sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Isirayila kɛɛ bɔxɔne nama keli bɔnsɔn gbɛtɛ yi siga bɔnsɔn gbɛtɛ yi, Isirayila bɔnsɔnne birin kɛɛ bɔxɔne xa lu e yii.” ");
INSERT INTO yal_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Selofexadi a dii tɛmɛne yi a liga alo Alatala a yamari Musa ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Maxala nun Tirisa nun Xɔgala nun Milika nun Noha nan Selofexadi a dii tɛmɛne ra. E yi dɔxɔ e baba ngaxakedenne dii xɛmɛne xɔn. ");
INSERT INTO yal_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","E dɔxɔ nɛn e baba Yusufu a dii Manase bɔnsɔnna xabilane muxuna ndee xɔn. Na ma, e kɛɛ bɔxɔne yi lu e baba bɔnsɔnna xabilani. ");
INSERT INTO yal_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Yamarine nun sariyane nan ne ra Alatala naxanye fala Isirayila kaane xa fata Musa ra Moyaba mɛrɛmɛrɛne yi Yurudɛn baan dɛxɔn Yeriko yɛtagi.");
INSERT INTO yal_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Falane ni itoe ra, Nabi Musa naxanye fala Isirayila kaane birin xa. Na waxatini, a yi Yurudɛn sogetede mabinna nin, Araba tonbonni Sufi yɛtagi, Paran, Tofeli, Laban, Xaserɔti, nun Disahabi longonne ra. ");
INSERT INTO yal_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Keli Horebe geyaan ma siga Kadesi-Barineya, xii fu nun keden sigatiin na a ra kiraan xɔn ma naxan danguma Seyiri geyane binni. ");
INSERT INTO yal_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","E minin ɲɛɛ tonge naaninden kike fu nun kedenden xii singe lɔxɔni Misiran bɔxɔni, Nabi Musa yi Alatalaa yamarine birin nali Isirayila kaane ma. ");
INSERT INTO yal_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Na waxatini, Musa bata yi Amorine manga Sixɔn nɔ yɛngɛni naxan yi dɔxi Xɛsibɔn yi, e nun Manga Ogo, Basan mangana, naxan yi dɔxi Asatarɔti nun Edere yi. ");
INSERT INTO yal_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Yurudɛn sogeteden mabinni, Moyaba bɔxɔni, Nabi Musa yi Alaa sariyan yɛba e xa, a naxa: ");
INSERT INTO yal_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Alatala en ma Ala ito nan falaxi en xa, Horebe geyaan ma, a naxa, “Ɛ bata bu geyani ito ma. ");
INSERT INTO yal_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Ɛ keli, ɛ siga geyane ma Amorine dɛnaxan yi, mɛnna longonna birin, Araba bɔxɔni, geyane fari, Sefela nun Negewi binni, fɔxɔ ige dɛɛn na, han Kanan bɔxɔni, han Liban yi, sa dɔxɔ Efirati baa gbeen na. ");
INSERT INTO yal_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ɛ xa na bɔxɔn mato, n naxan fixi ɛ ma. Ɛ siga, ɛ xa na tongo, bayo n tan Alatala yati nan n kɔlɔ ɛ benbane xa, Iburahima nun Isiyaga nun Yaxuba, e nun e bɔnsɔnna birin hali e dangu xanbini, a n na bɔxɔn nan soma e yii.” ");
INSERT INTO yal_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Na waxatini, n ni ito nan fala ɛ xa, n naxa, “N tan kedenna mi nɔɛ ɛ goronna tongɛ. ");
INSERT INTO yal_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Alatala ɛ Ala bata ɛ rawuya ayi. Iki ɛ bata wuya ayi alo sarene kore. ");
INSERT INTO yal_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Alatala ɛ benbane Ala xa ɛ rawuya ayi han wuli wuli. A xa ɛ baraka alo a a falaxi kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Koni, n tan kedenna nɔɛ ɛ birin goronna tongɛ di, n yi ɛ kitine birin sa? ");
INSERT INTO yal_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Ɛ xa xɛmɛne sugandi ɛ bɔnsɔnne yi, naxanye xaxili fan, e feene yɛɛ toma, e binyaxi. N ne nan tima yamaan xun na.” ");
INSERT INTO yal_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Ɛ yi n yabi, a n ma falan lanxi. ");
INSERT INTO yal_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Nayi, n yi ɛ yɛɛratine tongo, xɛmɛ xaxilimaan naxanye binyaxi ɛ bɔnsɔnne yɛ. N yi e dɔxɔ muxu wuli xun na hanma muxu kɛmɛ hanma muxu tonge suulun hanma muxu fu. E findi kuntigine ra ɛ bɔnsɔnne tagi. ");
INSERT INTO yal_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Na waxatini, n yi yamarini ito so ɛ kitisane yii. N naxa, “Ɛ xa ɛ tuli mati ɛ bari bodene ra. Ɛ yi e birin makiti tinxinni, ɛ ngaxakedenne tagi e nun e tan nun xɔɲɛne tagi. ");
INSERT INTO yal_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ɛ nama muxu yo rafisa bonne xa kiti sadeni. Ɛ ɛ tuli mati sɛnbɛ kanna nun sɛnbɛtaren fan na. Ɛ nama gaxu muxu yo yɛɛ ra, bayo Ala nan kitisaan na. Xa kitin xɔdɔxɔ ɛ yii, ɛ xa a fala n xa, n tan yi kitin sa.” ");
INSERT INTO yal_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Na kiini n bata yamarine birin yɛba ɛ xa, a lan ɛ xa naxan liga. ");
INSERT INTO yal_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Na to dangu, en bata keli Horebe geyaan ma, en yi dangu tonbon magaxuxin na ɛ dɛnaxan toxi. En yi ti kiraan xɔn siga Amori geyane ma, alo Alatala en ma Ala a yamari en ma kii naxan yi. En yi so Kadesi-Barineya yi. ");
INSERT INTO yal_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","N yi a fala ɛ xa, n naxa, “Ɛ bata Amori geyane li, Alatala en ma Ala dɛnaxan fixi en ma. ");
INSERT INTO yal_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","A mato, Alatala ɛ Ala bata bɔxɔni ito dɔxɔ en yɛɛ ra. Ɛ siga, ɛ xa na tongo alo Alatala ɛ benbane Ala a falaxi ɛ xa kii naxan yi. Ɛ nama gaxu, ɛ nama kuisan.” ");
INSERT INTO yal_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Na waxatini, ɛ birin yi fa n fɛma, ɛ yi a fala n xa, ɛ naxa, “En xa xɛrane rasiga, e xa sa bɔxɔni ito feene rakɔrɔsi. E fa dɛntɛgɛn sa en xa, en lan en xa sigan ti kiraan naxan xɔn e nun en sigama taan naxanye yi.” ");
INSERT INTO yal_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Ɛ miriyaan yi rafan n ma. Nanara, n yi xɛmɛ fu nun firin yɛba ɛ bɔnsɔn keden kedenne tagi. ");
INSERT INTO yal_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","E yi siga geyane yi han e sa Esikoli lanbanna li. E yi na yirene rakɔrɔsi. ");
INSERT INTO yal_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","E yi na bɔxɔn bogi seene ba, e yi fa e yita en na. E yi dɛntɛgɛn sa en xa, e naxa, “Alatala en ma Ala bɔxɔ faɲin nan fixi en ma.” ");
INSERT INTO yal_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Koni ɛ mi tinxi sigɛ, ɛ murutɛ nɛn Alatala ɛ Alaa yamarin bun ma. ");
INSERT INTO yal_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Ɛ yi lu tondi falane tiyɛ ɛ bubune kui. Ɛ naxa, “Alatala en naɲaxuxi, nanara a en naminixi Misiran yi alogo a xa en so Amorine yii e yi en halagi. ");
INSERT INTO yal_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","En sigan minɛn? En ngaxakedenne bata en tunnaxɔlɔ, e naxa, ‘Mɛn kaane fangan gbo en xa! E mɔn kuya en xa. Na taane gbo. Yinna naxanye e rabilinni, ne texi han kore. Nxu bata Anakine yati to na yi.’ ” ");
INSERT INTO yal_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","N yi a fala ɛ xa, n naxa, “Ɛ nama kuisan. Ɛ nama gaxu e yɛɛ ra de! ");
INSERT INTO yal_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Alatala ɛ Ala naxan tima ɛ yɛɛ ra, a tan nan yɛngɛn soma ɛ xa alo a a liga ɛ yɛɛ xɔri kii naxan yi Misiran yi han tonbonni. ");
INSERT INTO yal_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Ɛ bata a to nayi, Alatala ɛ Ala faxi ɛ ra nɛn alo muxuna a diin xalima kii naxan yi ɛ sigatiin birin yi han ɛ yi fa be li.” ");
INSERT INTO yal_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Koni na birin yi, ɛ mi yi laxi Alatala ɛ Ala ra. ");
INSERT INTO yal_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","A tan nan yi tima ɛ yɛɛ ra kiraan xɔn, a daaxadene fen ɛ xa ɛ luma dɛnaxanye yi. Kɔɛɛn na, a kirani yalan tɛɛn na. Yanyin fan na, kundaan yi ti ɛ yɛɛ ra. ");
INSERT INTO yal_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Alatala to ɛ falan mɛ, a xɔlɔ, a yi a kɔlɔ, ");
INSERT INTO yal_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Muxu kobini ito yo mi soɛ bɔxɔ faɲini ito yi, n naxan layirin tongo ɛ benbane xa ");
INSERT INTO yal_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","fɔ Yefune a dii Kalebi, na nan a toma. N na bɔxɔn soma a yii nɛn a naxan yisigaxi e nun a bɔnsɔnna, bayo a lu nɛn Alatalaa kiraan xɔn ken!” ");
INSERT INTO yal_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Alatala bata xɔlɔ n fan ma ɛ tan ma fe ra. A yi a fala, a naxa, “I tan yɛtɛɛn mi soma bɔxɔni ito yi. ");
INSERT INTO yal_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Nunu a dii Yosuwe, i mali muxun nan fama sodeni. I xa a sɛnbɛ so, bayo a tan nan tima Isirayila yɛɛ ra, e bɔxɔni ito sɔtɔ e kɛɛn na. ");
INSERT INTO yal_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Ɛ diine, ɛ a falaxi naxanye ma a e findima nɛn muxu suxine ra, e tan naxanye munma fe kobi nun fe faɲin tagi rabaan kolon, e tan nan soma na bɔxɔni. N na fima e tan nan ma. E tan nan a sɔtɔma e kɛɛn na. ");
INSERT INTO yal_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Koni ɛ tan, ɛ mɔn xa xɛtɛ, ɛ siga tonbonni, siga Gbala Baan kiraan xɔn.” ");
INSERT INTO yal_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Ɛ yi a yabi, ɛ naxa, “Nxu bata findi yulubi kanne ra Alatala yɛɛ ra yi, koni iki nxu xa siga yɛngɛ sodeni, alo Alatala en ma Ala a yamarixi nxu ma kii naxan yi.” Ɛ birin yi ɛ yɛngɛso seene tongo, bayo ɛ a mirixi nɛn a geya bɔxɔni ito masɔtɔn mi xɔdɔxɔ. ");
INSERT INTO yal_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Koni Alatala yi a fala n xa, a naxa, “A fala e xa, i naxa, ‘Ɛ nama siga yɛngɛ sodeni de! N mi luma ɛ xɔn. Ɛ yaxune ɛ nɔma nɛn.’ ” ");
INSERT INTO yal_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","N yi ɛ maxadi na kiini, koni ɛ mi ɛ tuli mati n na. Ɛ yi murutɛ Alatalaa yamarin ma, ɛ yi siga geya yireni wasoni. ");
INSERT INTO yal_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Amorin naxanye yi dɔxi geyane yi, ne yi mini ɛ yɛngɛdeni alo kumi ɲɛɲɛne dinma muxun na kii naxan yi. E yi ɛ kedi, e yi ɛ bɔnbɔ keli Seyiri han Xoroma. ");
INSERT INTO yal_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Ɛ to xɛtɛ, ɛ yi wuga Alatala yɛtagi han! Koni Alatala mi ɛ xuiin namɛ, a mi a tuli mati ɛ xuiin na. ");
INSERT INTO yal_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Ɛ mɔn yi lu Kadesi yi alo ɛ bu na kii naxan yi a singeni. ");
INSERT INTO yal_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Na xanbi ra, nxu yi xɛtɛ tonbonni nxu kiraan suxu naxan danguma Gbala Baani, alo Alatala a fala n xa kii naxan yi. Nxu yi Seyiri geyane mabilin xii wuyaxi bun. ");
INSERT INTO yal_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Alatala yi a fala n xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Ɛ bata bu geyani ito rabilinni. Ɛ firifiri kɔmɛnna ma.” ");
INSERT INTO yal_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","A yi a fala n xa a n xa yamarini ito fi ɛ ma. Ɛ danguma nɛn Seyiri bɔxɔni, ɛ ngaxakedenne dɛnaxan yi, Esayu bɔnsɔnna. E gaxuma nɛn ɛ yɛɛ ra, koni ɛ xa a liga ɛ yeren ma, ");
INSERT INTO yal_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ɛ nama yɛngɛn gidi e ma, bayo n mi sese soma ɛ yii fata e bɔxɔn na, hali san tidena. N bata Seyiri geyane fi Esayu ma. ");
INSERT INTO yal_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Ɛ na donseen nun igen naxan tongo fɔ ɛ xa a saren fi nɛn gbetin na. ");
INSERT INTO yal_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Alatala ɛ Ala bata barakan sa ɛ kɛwanli. A yi a ɲɔxɔ lu ɛ sigatiin xɔn ma ɛ yi tonbonni ito yi waxatin naxan yi. Ɲɛɛ tonge naaninni ito bun ma, Alatala ɛ Ala nan yi ɛ xɔn. Sese mi dasaxi ɛ ma. ");
INSERT INTO yal_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Nanara, en yi dangu en ngaxakedenne bɔxɔn dɛxɔn Esayu bɔnsɔnna naxanye dɔxi Seyiri bɔxɔni. En mɔn yi Araba kiraan suxu, naxan kelima Elati nun Esiyon-Gebere yi. Na xanbi ra, en yi en maxɛtɛ, en yi dangu Moyaba tonbon kiraan xɔn. ");
INSERT INTO yal_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Alatala yi a fala n xa, a naxa, “Ɛ nama yɛngɛn gidi Moyaba kaane ma de! Ɛ nama e fen yɛngɛn na de, bayo n mi e bɔxɔ yo soma ɛ yii e konni. N bata Ari bɔxɔn fi Loti bɔnsɔnna ma. ");
INSERT INTO yal_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Emi kaane nan yi Ari bɔxɔni nun. Siya sɛnbɛmaan nan yi ne ra. E yi wuya, e kuya alo Anaki bɔnsɔnna muxune. ");
INSERT INTO yal_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Muxuna nde yi e yatɛma Refa kaane nan na, alo Anaki bɔnsɔnna muxune, koni Moyaba kaane yi a falama e ma nɛn a ‘Emi kaane.’ ");
INSERT INTO yal_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Xori kaane nan yi dɔxi Seyiri bɔxɔni a singeni. Koni Esayu bɔnsɔnna muxune yi e kedi, e yi e raxɔri. E tan yi dɔxɔ na yi, alo Isirayila kaane fan naxan liga na bɔxɔni Alatala dɛnaxan fi e ma. ");
INSERT INTO yal_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Iki, ɛ keli, ɛ yi Serede xuden gidi.” Nayi, en yi na gidi. ");
INSERT INTO yal_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Ɲɛɛ tonge saxan nun solomasɛxɛ nan dangu xabu en keli Kadesi-Barineya yi, han en Serede xuden gidi waxatin naxan yi. Na lixi, yɛngɛsoon naxanye birin yi na na waxati danguxini nun, ne birin bata yi faxa alo Alatala a kɔlɔ e xa kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Alatala yi keli e xili ma han e birin yi ɲan daaxadeni. ");
INSERT INTO yal_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Na yɛngɛsone to ɲan yamaan yɛ, e faxa, ");
INSERT INTO yal_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Alatala yi a fala n xa, a naxa, ");
INSERT INTO yal_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“To, ɛ danguma nɛn Moyaba danna ra, siga Ari bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Ɛ Amonine lima nɛn na. Ɛ nama yɛngɛn gidi e ma de! Ɛ nama e fen yɛngɛn na, bayo n mi e bɔxɔ yo soma ɛ yii. N na fixi Loti bɔnsɔnna nan ma.” ");
INSERT INTO yal_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Na bɔxɔn fan yi yatɛxi Refa kaane gbeen nan na, bayo Refa kaane yi dɔxi na nun. Amonine yi a falama e ma nɛn a “Samisumi kaane.” ");
INSERT INTO yal_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Siya sɛnbɛmaan nan yi e ra, e yi wuya, e kuya alo Anaki bɔnsɔnna muxune. Koni Alatala yi e halagi Amoni kaane xɔn. Amoni kaane yi e kedi, e yi dɔxɔ e bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Ala bata yi na fe sifan liga Esayu a diine xa naxanye yi dɔxi Seyiri bɔxɔni, a to yi Xori kaane halagima e xɔn. E e kedi nɛn e yi dɔxɔ e funfuni. E dɔxi mɛnni han iki. ");
INSERT INTO yal_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Awi kaane tan, naxanye yi dɔxi taane kui han Gasa, Kafatoro kaane nan ne halagi e to fa keli Kafatoro yi. E yi dɔxɔ e funfuni. ");
INSERT INTO yal_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Ala yi a fala en xa, a naxa, “Ɛ ti kiraan xɔn, ɛ xa Arinon xuden gidi. A mato, n bata Xɛsibɔn manga Sixɔn, Amorin so ɛ yii, e nun a bɔxɔna. Iki, ɛ xa na tongo. Ɛ xa na yɛngɛn nakeli. ");
INSERT INTO yal_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","To, n na ɛ yɛɛragaxun luma nɛn dunuɲa siyane birin yi. E na ɛ xinla mɛ, e xuruxurunma nɛn gaxuni gbirigbiri!” ");
INSERT INTO yal_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","N yi xɛrane rasiga bɔɲɛ xunbeli falane tideni Xɛsibɔn manga Sixɔn xa, keli Kedemoti tonbonni. N naxa, ");
INSERT INTO yal_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Nxu wama i ya bɔxɔni gidi feni. Nxu sigama kira gbeen nan tun xɔn. Nxu mi sigɛ kɔmɛnna ma, nxu mi sigɛ yiifanna ma. ");
INSERT INTO yal_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Nxu na donseen nun igen naxan tongo, nxu a birin saren fima nɛn gbetin na. A lu nxu xa dangu nxu sanni i ya bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Esayu bɔnsɔnna naxanye dɔxi Seyiri bɔxɔni e nun Moyaba kaan naxanye dɔxi Ari bɔxɔni, ne bata yi nxu sago sa a nxu xa dangu e bɔxɔne yi. I fan xa n sago sa alogo nxu xa Yurudɛn baan gidi, nxu yi so bɔxɔni Alatala nxɔ Ala dɛnaxan fixi nxu ma.” ");
INSERT INTO yal_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Koni Xɛsibɔn manga Sixɔn yi tondi nxu dangu feen ma a bɔxɔni, bayo Alatala ɛ Ala bata yi a xaxinla xɔdɔxɔ ayi. A yi a bɔɲɛn balan alogo a xa a so ɛ yii alo a kii naxan yi to. ");
INSERT INTO yal_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Alatala yi a fala n xa, a naxa, “A mato, n bata Sixɔn nun a bɔxɔn so ɛ yii. Ɛ xa sa na tongo ɛ gbeen na.” ");
INSERT INTO yal_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Sixɔn nun a yamaan birin yi fa en yɛngɛdeni Yahasi yi. ");
INSERT INTO yal_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Alatala en ma Ala yi Sixɔn so en yii, en yi a nɔ, e nun a diine nun a yamaan birin. ");
INSERT INTO yal_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","En yi na taane birin suxu, en yi e birin kala. En mɔn yi xɛmɛne nun ɲaxanle nun diine birin faxa. En mi muxu yo lu a nii ra. ");
INSERT INTO yal_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","En mi sese tongo fɔ xuruseene nun se kɛndɛn naxanye yi na taane kui. ");
INSERT INTO yal_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Keli Aroyeri Arinon xuden dɛ, e nun taan naxan na mɛrɛmɛrɛni, siga han Galadi, taa yo mi nɔ sɔtɔ en ma. Alatala en ma Ala e birin so nɛn en yii. ");
INSERT INTO yal_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Koni ɛ mi ɛ masoxi Amonine bɔxɔn na, hanma Yaboko xuden dɛ, hanma taan naxanye na geyane ma alo Alatala a yamari ɛ ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","En yi en maxɛtɛ, en yi te Basan kiraan xɔn. Basan manga Ogo yi mini en yɛngɛdeni Edere yi, e nun a ganla birin. ");
INSERT INTO yal_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Alatala yi a fala n xa, a naxa, “I nama gaxu a yɛɛ ra, bayo n na soma i yii nɛn e nun a ganla birin e nun a bɔxɔna. I bata naxan liga Sixɔn na, Amorine mangana, naxan yi dɔxi Xɛsibɔn, i na nan ligama a fan na.” ");
INSERT INTO yal_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Alatala en ma Ala yi Basan manga Ogo so en yii, e nun a ganla birin. En yi e birin faxa, muxu ɲɛɲɛ yo mi lu. ");
INSERT INTO yal_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Na waxatini, en yi a taane birin suxu. Na taa yo mi lu en mi dɛnaxan suxu. Taa tonge sennin nan yi e ra naxanye yi Arigobi rabilinni Basan manga Ogo a mangayaan bun. ");
INSERT INTO yal_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Na taane birin yi rabilinxi yin matexine nan na. E yi balanxi dɛ wure daxine nan na. Banxidɛ wuyaxi fan yi na naxanye mi yi rabilinxi yinne ra. ");
INSERT INTO yal_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","En yi na taane birin kala fefe, alo en na a liga Xɛsibɔn manga Sixɔn ma bɔxɔn na kii naxan yi. En yi xɛmɛne nun ɲaxanle nun diine birin faxa taane birin yi. ");
INSERT INTO yal_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","En yi seene birin kala fɔ xuruseene nun se kɛndɛne, en naxanye tongo. ");
INSERT INTO yal_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Na waxatini, en yi bɔxɔne birin tongo Yurudɛn sogeteden binni, e ba Amorine manga firinne yii, keli Arinon xudeni han Xerimon geyana. ");
INSERT INTO yal_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Sidɔn kaane a falama na geyaan ma nɛn a “Siriyon.” Amorine tan naxa a “Seniri.” ");
INSERT INTO yal_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","En yi na taane birin tongo na fiili yireni e nun Galadi bɔxɔna e nun Basan bɔxɔn birin, sa dɔxɔ Salaka nun Edere ra. Na taane birin yi Ogo a mangayaan nan bun Basan bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Basan manga Ogo nan keden mi faxa Refa kaane yɛ. A wure saden mɔn Rabaha yi, Amonine manga taana. A kuyana, nɔngɔnna yɛ solomanaanin, a yigbona nɔngɔnna yɛ naanin. ");
INSERT INTO yal_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Na waxatini, en yi na bɔxɔn tongo. Keli Aroyeri yi, sa dɔxɔ Arinon xude dɛɛn na e nun Galadi geyaan fɔxɔ kedenna e nun na taane, n yi na birin so Rubɛn nun Gadi bɔnsɔnna yii. ");
INSERT INTO yal_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","N yi Galadi fɔxɔ boden nun Basan manga Ogo bɔxɔn so Manase bɔnsɔnna fɔxɔ kedenna yii. Arigobi rabilinna bɔxɔn nun Basan bɔxɔn yi yatɛxi Refa kaane bɔxɔn nan na. ");
INSERT INTO yal_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Manase a dii Yayiri yi Arigobi bɔxɔn findi a gbeen na han Gesuri kaane nun Maka kaane bɔxɔne danne. E yi Yayiri xili sa Basan bɔxɔn xun ma. Han iki e a falama Basan bɔxɔn ma nɛn a “Yayiri taana.” ");
INSERT INTO yal_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","N yi Galadi so Makiri yii. ");
INSERT INTO yal_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","N yi Galadi fɔxɔ kedenna so Rubɛn bɔnsɔnna nun Gadi bɔnsɔnna yii han Arinon xudena. Xude wunla nan na danna ra, sa dɔxɔ Yaboko xuden na, Amonine bɔxɔn danna. ");
INSERT INTO yal_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","N mɔn yi Araba bɔxɔn fan so e yii naxan danna lanxi Yurudɛn baan ma keli Kinɛrɛti Darani, sa dɔxɔ Araba Fɔxɔ Ige Daraan na, Pisiga geyaan lanbanni, sogeteden binni. ");
INSERT INTO yal_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Na waxatini n yi yamarini ito fi ɛ ma. N naxa, “Alatala ɛ Ala bata bɔxɔni ito fi ɛ ma alogo a xa findi ɛ gbeen na. Koni ɛ xɛmɛ kɛndɛne birin xa e yitɔn e siga e ngaxakedenne Isirayila kaane yɛɛ ra yɛngɛ sodeni. ");
INSERT INTO yal_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Ɛ ɲaxanle nun ɛ diine nun ɛ xuruseene nan tun luma taane kui n naxan soxi ɛ yii. N na a kolon xuruse wuyaxi ɛ yii. ");
INSERT INTO yal_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Ɛ luma nɛn sofayani han Alatala ɛ Ala yi matabun fi ɛ ngaxakedenne fan ma. Alatala ɛ Ala bɔxɔn fima e ma nɛn Yurudɛn kidi ma. Na waxatini, ɛ birin nɔɛ xɛtɛ nɛn ɛ gbee bɔxɔni n naxan soxi ɛ yii.” ");
INSERT INTO yal_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Na waxatini, n yi yamarin so Yosuwe yii. N yi a fala a xa, n naxa, “I bata feene birin to i yɛɛn na Alatala ɛ Ala naxan ligaxi manga firinni itoe ra. Alatala na ligama nɛn yamanan birin na, i na dangu dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","I nama gaxu e yɛɛ ra, bayo Alatala ɛ Ala nan e yɛngɛma ɛ xa.” ");
INSERT INTO yal_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Na waxatini, n yi Alatala maxandi, n naxa, ");
INSERT INTO yal_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Marigina Alatala, i bata i ya fisamantenyaan nun i sɛnbɛn yita i ya walikɛɛn na. Ala gbɛtɛ yo mi kore xɔnna ma hanma bɔxɔn ma naxan nɔɛ i ya wanle nun i ya kabanakone ligɛ. ");
INSERT INTO yal_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Yandi, tin n xa Yurudɛn baan gidi alogo n xa na bɔxɔ faɲin to naxan a kidi ma, e nun a geya yire faɲina, e nun Liban bɔxɔna.” ");
INSERT INTO yal_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Koni Alatala bata yi xɔlɔ n ma ɛ tan ma fe ra. A mi n xuiin namɛxi. Alatala yi a fala n xa, a naxa, “A lu na ki, i nama fa feni ito fala n xa sɔnɔn. ");
INSERT INTO yal_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Te Pisiga geyaan xuntagi, i yi sogegododen binna mato e nun kɔmɛn fɔxɔn binni, e nun yiifari fɔxɔn binni, e nun sogeteden binni. I xa a mato i yɛtɛ yɛɛn na. Koni i xa a kolon a faɲin na, i mi Yurudɛn baan gidima. ");
INSERT INTO yal_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Yamarin fi Yosuwe ma, i limaniyaan nun sɛnbɛn fi a ma, bayo a tan nan tima yamaan yɛɛ ra Yurudɛn baan gidideni. I bɔxɔn naxan toma, a tan nan a ligama Isirayila yi na bɔxɔn sɔtɔ e kɛɛ bɔxɔn na.” ");
INSERT INTO yal_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Nayi, en yi lu lanbanni Beti-Peyori yɛtagi. ");
INSERT INTO yal_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Iki, Isirayila, ɛ tuli mati. Ɛ xa tɔnne nun sariyane suxu, n na ɛ xaranma naxanye ma iki, alogo ɛ xa siimayaan sɔtɔ, ɛ mɔn xa bɔxɔn sɔtɔ Alatala ɛ benbane Ala naxan fixi ɛ ma. ");
INSERT INTO yal_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ɛ nama sese sa n ma yamarin fari, n naxan falaxi ɛ xa. Ɛ mɔn nama sese ba a ra. Ɛ xa Alatala ɛ Ala yamarine suxu alo n na falama ɛ xa kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Ɛ bata a to ɛ yɛɛne ra Alatala naxan ligaxi Baali-Peyori yi. Alatala ɛ Ala bata muxun birin faxa naxanye Baali suxuren batuxi Peyori yi. ");
INSERT INTO yal_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Koni ɛ tan naxanye biraxi Alatala ɛ Ala fɔxɔ ra, ɛ birin mɔn ɛ nii ra han to. ");
INSERT INTO yal_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Ɛ a kolon, n bata ɛ xaran tɔnne nun sariyane ma alo Alatala n ma Ala a yamarixi n ma kii naxan yi, alogo ɛ xa e suxu na bɔxɔni dɛnaxan findima ɛ gbeen na. ");
INSERT INTO yal_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Ɛ xa e suxu ki faɲi, alogo a xa findi lɔnnin na ɛ xa, e nun xaxili faɲin na siya gbɛtɛne yɛɛ ra yi. Siya gbɛtɛne na sariyani itoe e fe mɛ, e a falama nɛn, e naxa, “Siya gbeeni ito lɔnnixi, e xaxinla fan.” ");
INSERT INTO yal_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Siyaan mundun ma ala masoxi a ra alo Alatala en ma Ala masoxi en na kii naxan yi, en na a maxandi waxatin naxan yi? ");
INSERT INTO yal_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Siya gbeen mundun na alo en tan tɔnne nun sariya tinxinxine naxan yii alo n sariyan naxan soma ɛ yii to? ");
INSERT INTO yal_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Ɛ a liga ɛ yeren ma ɛ siimayaan birin yi, ɛ yi ɛ yɛtɛ ratanga alogo ɛ nama ɲinan na feene xɔn ɛ naxanye toxi. Ne nama ba ɛ bɔɲɛni. Ɛ xa ɛ diine xaran ne ma e nun e fan yixɛtɛne. ");
INSERT INTO yal_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Ɛ miri na lɔxɔn ma ɛ ti Alatala ɛ Ala yɛtagi waxatin naxan yi Horebe geyaan ma. Na lɔxɔni Alatala yi a fala n xa, a naxa, “Yamaan birin xa malan n yɛtagi. N xa n ma sariyan fala e xa alogo e xa gaxu n yɛɛ ra e dunuɲa yi gidini. E mɔn xa e diine fan xaran ne ma.” ");
INSERT INTO yal_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Ɛ yi ɛ maso ɛ ti geyaan san bun. Tɛɛn bata yi geyaan birin suxu, te han kore. Dimin nun tutin nun kundaan yi godo. ");
INSERT INTO yal_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Alatala yi falan ti ɛ xa tɛɛn tagi. Ɛ yi a xuiin mɛ falan tiyɛ, koni ɛ mi a gbindin to. Ɛ yi a xuiin nan tun mɛma. ");
INSERT INTO yal_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","A yi a layirin nali ɛ ma, yamari fune, a naxanye yamarixi ɛ ma a ɛ xa e suxu. A yi ne sɛbɛ gɛmɛ walaxa firinne ma. ");
INSERT INTO yal_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Na waxatini, Alatala yi n yamari, a n xa ɛ xaran tɔnne nun sariyane ma, alogo ɛ xa e suxu bɔxɔni naxan findima ɛ gbeen na, ɛ na Yurudɛn baan gidi. ");
INSERT INTO yal_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Alatala falan ti ɛ xa waxatin naxan yi Horebe geyaan fari, tɛɛn tagi, ɛ mi a gbindin to. Nayi, ɛ xa ɛ yɛtɛ ratanga, ");
INSERT INTO yal_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ɛ nama findi fe kalane ra, ɛ suxuren nafala sena nde sawuran na naxan nun xɛmɛna hanma ɲaxanla maliga, ");
INSERT INTO yal_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","hanma subena naxan bɔxɔn ma, hanma xɔliin naxan kore, ");
INSERT INTO yal_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","hanma bubusena hanma yɛxɛne igeni. ");
INSERT INTO yal_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ɛ nama ɛ yɛɛ rate kore ɛ sogen batu, hanma kikena, hanma sarene. Seen naxanye birin kore, ɛ nama ɛ yigodo ne xa, ɛ nama e batu. Alatala ɛ Ala nan ne soxi siyane birin yii naxanye dunuɲa yi. ");
INSERT INTO yal_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Koni ɛ tan, Alatala bata ɛ ramini Misiran yamanani alo wuren bama sulun tɛɛni kii naxan yi, alogo ɛ xa findi a gbee yamaan na, alo ɛ kii naxan yi to. ");
INSERT INTO yal_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Alatala yi xɔlɔ n ma ɛ fe ra. A yi a kɔlɔ, a n mi Yurudɛn baan gidima, n so bɔxɔ faɲini ito yi Alatala ɛ Ala naxan fi ɛ ma ɛ kɛɛn na. ");
INSERT INTO yal_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","N tan, n faxama bɔxɔni ito nin. N mi Yurudɛn baan gidima. Koni ɛ tan a gidima nɛn, ɛ yi na bɔxɔ faɲin tongo ɛ gbeen na. ");
INSERT INTO yal_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Ɛ a liga ɛ yeren ma alogo ɛ nama ɲinan Alatala ɛ Alaa layirin xɔn a naxan tongoxi ɛ xa. Ɛ nama se maliga suxure yo rafala Alatala ɛ Ala tɔnna saxi naxan na, ");
INSERT INTO yal_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","bayo Alatala ɛ Ala xɔxɔlɔn, a luxi nɛn alo tɛɛn naxan halagin tima. ");
INSERT INTO yal_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Ɛ na diine nun mamandenne sɔtɔ waxatin naxan yi, ɛ na bu na bɔxɔni, xa ɛ kalan ti, ɛ suxuren nafala sena nde maligan na, ɛ fe ɲaxin liga Alatala ɛ Ala yɛtagi naxan a raxɔlɔma, ");
INSERT INTO yal_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","koren nun bɔxɔn nan en serene ra to, ɛ ɲanma nɛn bɔxɔni mafurɛn naxan findima ɛ gbeen na Yurudɛn kidima. Ɛ mi siimaya sɔtɔma. Ɛ halagima nɛn. ");
INSERT INTO yal_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Alatala ɛ raxuyama ayi nɛn siya gbɛtɛne tagi. Ɛ xurunɲɛ ayi ne yɛ Alatala na ɛ xali dɛnaxan yi. ");
INSERT INTO yal_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ɛ suxurene batuma nɛn mɛnni, muxune naxanye rafalama wudin na, hanma gɛmɛn na, suxuren naxanye mi nɔɛ seen toɛ, e mi fe mɛma, e mi e dɛgema, e mi se xirin mɛma. ");
INSERT INTO yal_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Ɛ fama nɛn Alatala ɛ Ala fendeni mɛnni. Ɛ mɔn a toma nɛn, xa ɛ a fen ɛ bɔɲɛn birin na e nun ɛ niin birin yi. ");
INSERT INTO yal_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Ɛ tɔrɔma waxatin naxan yi, na feene birin ɛ lima nɛn. Na waxatini ɛ xɛtɛma nɛn Alatala ɛ Ala ma, ɛ yi a xuiin namɛ. ");
INSERT INTO yal_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Bayo Alatala ɛ Ala, Ala na a ra naxan kininkinin, naxan mi ɛ rabeɲinma, naxan mi ɛ halagima. A mi ɲinanɲɛ layirin xɔn, a a kɔlɔ naxan ma ɛ benbane xa. ");
INSERT INTO yal_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Ɛ miri fe fonne ma naxanye bata dangu, e nun naxanye bata liga xabu Ala Adama daxi bɔxɔn fari waxatin naxan yi. Ɛ miri bɔxɔn yiren birin ma. Fe gbɛtɛ bata liga naxan gbo ito xa ba? Ɛ bata na ɲɔxɔnna mɛ ba? ");
INSERT INTO yal_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Siya gbɛtɛn na ba naxan bata Ala fala xuiin mɛ tɛɛn tagi, a mɔn yi lu a nii ra alo ɛ tan? ");
INSERT INTO yal_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Ala mundun bata siyana nde ba siya gbɛtɛn yii misaale nun taxamasenne nun kabanakone nun yɛngɛne nun sɛnbɛ gbeen nun nɔɔn nun fe magaxuxine xɔn, alo Alatala ɛ Ala feen naxanye birin liga ɛ xa Misiran yamanani ɛ yɛɛ xɔri? ");
INSERT INTO yal_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Na bata fixa ɛ xa alogo ɛ xa la a ra, a Alatala keden peen nan Ala ra, gbɛtɛ mi na fɔ a tan. ");
INSERT INTO yal_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Ɛ bata a xuiin namɛ keli kore alogo a xa ɛ maxuru. A tɛɛ gbeen yita ɛ ra bɔxɔn ma, ɛ mɔn yi a xuiin namɛ tɛɛn tagi. ");
INSERT INTO yal_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","A ɛ benbane xanu nɛn, a yi e bɔnsɔnna fan sugandi hali e dangu xanbini. Na nan a toxi a yi ɛ ramini sɛnbɛn na Misiran yamanani. ");
INSERT INTO yal_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","A yi siyane kedi ɛ xa naxanye sɛnbɛn yi gbo ɛ tan xa. A yi e bɔxɔn so ɛ yii ɛ kɛɛn na alo a kii naxan yi to. ");
INSERT INTO yal_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Ɛ xa a kolon ɛ bɔɲɛni to, a Alatala keden peen nan Ala ra kore xɔnna ma e nun bɔxɔn ma. Gbɛtɛ mi na. ");
INSERT INTO yal_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Ɛ xa a tɔnne nun a yamarine suxu, n naxanye soma ɛ yii to, alogo ɛ xa hɛrin sɔtɔ ɛ tan nun ɛ yixɛtɛne hali ɛ dangu xanbini, alogo ɛ xa siimaya xunkuyen sɔtɔ bɔxɔni Alatala ɛ Ala dɛnaxan fima ɛ ma han habadan. ");
INSERT INTO yal_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Nabi Musa yi taa saxan sugandi Yurudɛn sogeteden binni. ");
INSERT INTO yal_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Ne yi findi marakisi taane ra faxa tiine xa naxanye e boden faxama koni e mi a rakelixi a ma, e mi a yitɔnxi xɔnnantenyani. Na kanna nɔma ludeni taani itoe nde keden yi nɛn alogo a niin xa ratanga gbeeɲɔxɔyaan ma. ");
INSERT INTO yal_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Na taane ni i ra: Bɛsɛri taan naxan tonbonni fiili yireni Rubɛn bɔnsɔnna konni, Ramoti taan naxan Galadi bɔxɔni, Gadi bɔnsɔnna konni, e nun Golan taan naxan Basan bɔxɔni Manase bɔnsɔnna konni. ");
INSERT INTO yal_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Alaa sariyan ni i ra, Nabi Musa naxan nali Isirayila kaane ma. ");
INSERT INTO yal_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Maxadi xuine nun tɔnne nun sariyane ni i ra, Nabi Musa naxan fala Isirayila kaane xa e yi minima Misiran yamanani waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","E yi Yurudɛn kidima mɛrɛmɛrɛne yi Beti-Peyori yɛtagi, Manga Sixɔn ma bɔxɔn ma, Amorine mangana, naxan yi dɔxi Xɛsibɔn yi. Nabi Musa nun Isirayila kaane yi a nɔ e yi minima Misiran bɔxɔni waxatin naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","E yi a bɔxɔn tongo, e nun Ogo a bɔxɔna, Basan mangana. Amorine manga firinne nan yi ne ra Yurudɛn kidima, a sogeteden binni. ");
INSERT INTO yal_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Na bɔxɔn danne ni i ra: Keli Aroyeri yi han Arinon xuden dɛ sa dɔxɔ Xerimon geyaan na, naxan xili Siyon, ");
INSERT INTO yal_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","e nun Araba bɔxɔn birin Yurudɛn kidima a sogeteden binni, a sa dɔxɔ Fɔxɔ Ige Daraan na Pisiga geyaan san bun. ");
INSERT INTO yal_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Nabi Musa yi Isirayila yamaan maxili, a yi a fala e xa, a naxa, “Isirayila kaane, ɛ tuli mati tɔnne nun sariyane ra, n naxanye falama ɛ xa to. Ɛ xa e xaran, ɛ yi e suxu ki faɲi. ");
INSERT INTO yal_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Alatala en ma Ala bata layirin tongo en xa Horebe geyaan ma. ");
INSERT INTO yal_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Alatala nun en benbane xa mi layirini ito xidixi. A xidixi en tan nan birin tagi en tan naxan mɔn en nii ra to. ");
INSERT INTO yal_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Alatala falan ti nɛn ɛ xa keli tɛɛn tagi geyaan ma yɛɛ nun yɛɛ. ");
INSERT INTO yal_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Na waxatini n tan nan yi tima ɛ nun Alatala tagi alogo n xa Alatalaa falane rali ɛ ma, bayo ɛ yi gaxuxi tɛɛn yɛɛ ra. Ɛ mi te geyaan fari.” A yi a fala, a naxa, ");
INSERT INTO yal_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Alatala nan n tan na i ya Ala naxan i raminixi konyiyani Misiran yi.” ");
INSERT INTO yal_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“I nama ala gbɛtɛ batu fɔ n tan.” ");
INSERT INTO yal_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“I nama suxuren nafala hanma sena nde sawurana, seen naxan kore, naxan bɔxɔn ma hanma naxan igeni. ");
INSERT INTO yal_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","I nama i xinbi sin e xa. I nama e batu. Amasɔtɔ n tan, Alatala, i ya Ala, n xɔxɔlɔn. Naxanye na n naɲaxu, n ne hakɛne saranma e diine ra nɛn han mayixɛtɛ saxan hanma naanin. ");
INSERT INTO yal_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Koni naxanye na n xanu, e n ma yamarine suxu, n hinanma ne ra nɛn han mayixɛtɛ wuli keden.” ");
INSERT INTO yal_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“I nama Alatala i ya Ala xinla fala fuuni, amasɔtɔ Alatala na kanna ɲaxankatama nɛn.” ");
INSERT INTO yal_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“I xa Matabu Lɔxɔn binya, i yi a rasariɲan alo Alatala i ya Ala a yamarixi i ma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","I xa wali xii sennin bun ma, i yi i ya wanle birin kɛ. ");
INSERT INTO yal_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Koni xii soloferede lɔxɔni, Alatala i ya Alaa Matabu Lɔxɔn nan na ra. I nama wali yo kɛ, i tan ba, i ya dii xɛmɛn ba, i ya dii tɛmɛn ba, i ya konyin ba, i ya ɲingen ba, i ya sofanla ba, i ya xuruseen birin ba hanma hali xɔɲɛn naxan i konni, alogo i ya walikɛne fan xa e matabu alo i tan. ");
INSERT INTO yal_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","I nama ɲinan a konyin nan yi i ra Misiran yi. Alatala i ya Ala yi i ramini konyiyani a sɛnbɛn nun nɔɔn na. Na nan a toxi n na falaxi i xa, i xa Matabu Lɔxɔn binya.” ");
INSERT INTO yal_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“I baba nun i nga binya alo Alatala i ya Ala a yamarixi i ma kii naxan yi, alogo i xa siimaya xunkuyen nun hɛrin sɔtɔ bɔxɔni Alatala i ya Ala naxan fima i ma.” ");
INSERT INTO yal_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“I nama faxan ti.” ");
INSERT INTO yal_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“I nama yalunyaan liga.” ");
INSERT INTO yal_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“I nama muɲan ti.” ");
INSERT INTO yal_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“I nama wule seren ba i adamadi boden xili ma.” ");
INSERT INTO yal_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“I nama mila i bodena ɲaxanla xɔn hanma a banxina hanma a xɛɛna hanma a konyina hanma a ɲingena hanma a sofanla hanma i adamadi boden gbee seen naxan birin na.” ");
INSERT INTO yal_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Alatala na feene nan falaxi ɛ birin malanxin yɛɛ xɔri, a xui yitexin na, geyaan fari, keli tɛɛn nun dimin nun kundani. A mi sese sa a fari. A yi e sɛbɛ walaxa gɛmɛ daxi firin ma, a yi e so n yii. ");
INSERT INTO yal_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Ɛ xuini ito mɛxi waxatin naxan yi keli dimini tɛɛn tagi geyaan fari, ɛ nun ɛ mangane nun fonne yi fa n fɛma. ");
INSERT INTO yal_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Ɛ yi a fala n xa, ɛ naxa, “Alatala en ma Ala bata a nɔrɔn yita en na e nun a gbona. En bata a xuiin namɛ falan tiyɛ tɛɛn tagi. Nxu bata a kolon to, a Ala nɔɛ falan tiyɛ nɛn muxun na, na kanna mɔn yi lu a nii ra. ");
INSERT INTO yal_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Iki, nanfera en na en masoma faxan na? Tɛɛni ito en faxama nɛn. Xa en mɔn en tuli mati Alatala en ma Ala xuiin na, en faxama nɛn. ");
INSERT INTO yal_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Adamadiin mundun luxi alo en tan naxan bata habadan Ala xuiin mɛ falan tiyɛ tɛɛn tagi, a mɔn yi lu a nii ra? ");
INSERT INTO yal_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","I tan Musa, i maso Alatala en ma Ala ra, i yi i tuli mati a ra. A naxan falama, i xa na radangu nxu ma. Nxu nxu tuli matima i ra nɛn. Nxu mɔn yi a liga.” ");
INSERT INTO yal_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Alatala yi ɛ falan mɛ, ɛ naxan falaxi n xa. A yi a fala n xa, a naxa, “N bata yamaan xuiin mɛ, e naxan falaxi i xa. Ɲɔndin na a ra. ");
INSERT INTO yal_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","A yi lan nun n yɛɛragaxun xa lu e bɔɲɛni waxatin birin, e yi n ma yamarine suxu, alogo e tan nun e bɔnsɔnna xa hɛrin sɔtɔ habadan! ");
INSERT INTO yal_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Siga, i xa sa a fala e xa, a e xa so e bubune kui. ");
INSERT INTO yal_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Koni i tan xa lu n fɛma be. N xa n ma yamarine nun tɔnne nun sariyane birin fala i xa, i lan i xa e xaran naxanye ma, alogo e xa ne suxu e na so bɔxɔni n dɛnaxan fima e ma.” ");
INSERT INTO yal_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Alatala ɛ Ala naxan yamarixi ɛ ma, ɛ xa na liga ki faɲi. Ɛ nama siga kɔmɛn ma, ɛ nama siga yiifanna ma. ");
INSERT INTO yal_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Ɛ xa bira kirani ito nan fɔxɔ ra Alatala en ma Ala naxan yamarixi, alogo ɛ xa lu ɛ nii ra, ɛ sabati, ɛ siimaya xunkuyen sɔtɔ bɔxɔni ɛ dɛnaxan sɔtɔma. ");
INSERT INTO yal_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Yamarine nun tɔnne nun sariyane ni i ra, Alatala ɛ Ala naxan yamarixi n ma alogo n xa ɛ xaran e ma, alogo ɛ xa e suxu bɔxɔni ɛ Yurudɛn gidima naxan sɔtɔdeni. ");
INSERT INTO yal_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Ɛ xa gaxu Alatala en ma Ala yɛɛ ra. Ɛ xa tɔnne nun yamarine birin suxu ɛ siimayaan birin yi, n naxanye soxi ɛ yii, ɛ tan, ɛ diine, e nun ɛ mamandenne, alogo ɛ xa siimaya xunkuyen sɔtɔ. ");
INSERT INTO yal_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Isirayila kaane, ɛ xa ɛ tuli mati falani itoe ra ɛ yi e suxu ki faɲi, alogo ɛ xa hɛrin sɔtɔ, ɛ yi wuya ayi na bɔxɔni nɔnɔn nun kumin gbo dɛnaxan yi, alo Alatala ɛ benbane Ala a falaxi ɛ xa kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Isirayila kaane, ɛ tuli mati. Alatala en ma Ala keden peen na a ra. ");
INSERT INTO yal_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","I xa Alatala i ya Ala xanu i bɔɲɛn birin na e nun i niin birin na e nun i sɛnbɛn birin na. ");
INSERT INTO yal_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","N yamarini itoe naxan fixi i ma iki, e xa lu i bɔɲɛni. ");
INSERT INTO yal_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","I xa i ya diine xaran ne ma waxatin birin. I xa e fe fala i nɛma banxini, i nɛma sigatini, i nɛma i sɛ e nun i nɛma kelɛ. ");
INSERT INTO yal_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","I xa na falane xidi i yiin na, e nun i tigi ra alogo i nama ɲinan e xɔn. ");
INSERT INTO yal_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","I xa e sɛbɛ i ya banxin sɛnbɛtɛnne ma e nun dɛɛne ma. ");
INSERT INTO yal_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Alatala ɛ Ala na ɛ xali bɔxɔni a dɛnaxan soma ɛ yii, alo a a kɔlɔ ɛ benbane Iburahima nun Isiyaga nun Yaxuba xa kii naxan yi, taa belebele tofaɲine dɛnaxan yi ɛ mi naxanye tixi, ");
INSERT INTO yal_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","e nun banxi rafexine hɛrisigɛn sifan birin na ɛ mi naxanye fenxi, e nun xɔɲinne ɛ mi naxanye gexi, e nun manpa bili langane nun oliwi bili langane ɛ mi naxanye sixi, ");
INSERT INTO yal_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ɛ na ɛ dɛge han ɛ yi wasa, ɛ nama ɲinan Alatala ɛ Ala xɔn de, naxan ɛ raminixi konyiyani Misiran yi. ");
INSERT INTO yal_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Ɛ xa Alatala binya ɛ Ala, ɛ yi a keden peen batu. Ɛ xa ɛ kɔlɔ a tan nin. ");
INSERT INTO yal_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Ɛ nama ala gbɛtɛye batu de, ɛ rabilinna muxune naxanye batuma, ");
INSERT INTO yal_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","bayo Alatala ɛ Ala naxan ɛ tagi, na xɔxɔlɔn. Xa na mi a ra a xɔlɔma nɛn ɛ ma, a mɔn yi ɛ faxa. ");
INSERT INTO yal_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Ɛ nama Alatala ɛ Ala mato bunbani de, alo ɛ naxan liga Masa yi. ");
INSERT INTO yal_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Koni ɛ xa Alatala ɛ Alaa yamarine suxu ki faɲi, e nun a maxadi xuine e nun a tɔnne a naxanye yamarixi ɛ ma. ");
INSERT INTO yal_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Ɛ xa tinxinyaan nun fe faɲine liga Alatala yɛɛ ra yi, alogo ɛ xa hɛrin sɔtɔ, ɛ yi bɔxɔ faɲin sɔtɔ Alatala a kɔlɔ naxan na ɛ benbane xa. ");
INSERT INTO yal_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Ɛ ɛ yaxune kedima nɛn alo Alatala a fala kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Ɛ diine na ɛ maxɔdin waxatin naxan yi, e naxa, “Maxadi xuine nun tɔnne nun yamarini itoe bunna nanse ra, Alatala en ma Ala naxan yamarixi en ma?” ");
INSERT INTO yal_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Ɛ e yabima nɛn, ɛ naxa, “Nxu yi findixi Firawonaa konyine nan na Misiran yamanani, koni Alatala yi nxu ramini Misiran yi a sɛnbɛn xɔn. ");
INSERT INTO yal_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Alatala yi taxamasenne nun kabanako belebele magaxuxine liga nxu yɛɛ xɔri Misiran kaane ra, e nun Firawona nun a denbayaan birin. ");
INSERT INTO yal_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","A yi nxu ramini Misiran yi alogo a xa nxu xali bɔxɔni, a a kɔlɔ dɛnaxan ma fe ra en benbane xa, a a soma en yii. ");
INSERT INTO yal_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Alatala yi nxu yamari, a nxu xa sariyani itoe birin suxu nxu yi gaxu Alatala en ma Ala yɛɛ ra alogo nxu xa hɛrin sɔtɔ waxatin birin, nxu yi siimaya faɲin sɔtɔ alo en kii naxan yi iki. ");
INSERT INTO yal_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Xa en yamarini itoe birin suxu ki faɲi Alatala en ma Ala naxanye yamarixi en ma, na findima en ma tinxinyaan nan na.” ");
INSERT INTO yal_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Alatala ɛ Ala na ɛ xali bɔxɔni waxatin naxan yi, a dɛnaxan fima ɛ ma, a siya solofere kedima nɛn: Xitine nun Girigasane nun Amorine nun Kanan kaane nun Perisine nun Xiwine, e nun Yebusune, siya solofere naxanye wuya ɛ xa, e sɛnbɛn mɔn gbo ɛ xa. ");
INSERT INTO yal_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Alatala ɛ Ala na e lu ɛ sagoni waxatin naxan yi, ɛ yi e nɔ, ɛ xa e halagi fefe! Ɛ nama layiri yo xidi, ɛ mɔn nama kininkinin e ma. ");
INSERT INTO yal_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Futun nama so ɛ tagi. Ɛ nama ɛ dii tɛmɛne fi e dii xɛmɛne ma. Ɛ nama ɲaxanle fen e yɛ ɛ dii xɛmɛne ɲaxanle ra. ");
INSERT INTO yal_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Xa na mi a ra xɔɲɛni itoe ɛ diine ratantanma nɛn, e yi se gbɛtɛye batu, Alatala yi xɔlɔ ɛ ma, a yi ɛ halagi mafurɛn! ");
INSERT INTO yal_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ɛ xa ito nan liga e ra: Ɛ xa e saraxa gandene nun e kide gɛmɛne birin kala. Ɛ yi e Asera kide gbindonne sɛgɛ, ɛ yi e suxurene birin gan. ");
INSERT INTO yal_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Bayo ɛ bata findi yama rasariɲanxin na Alatala ɛ Ala xa. Alatala ɛ Ala bata ɛ tan nan sugandi bɔxɔn siyane birin yɛ alogo ɛ xa findi a gbee yamaan na. ");
INSERT INTO yal_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Alatala mi biraxi ɛ fɔxɔ ra, a yi ɛ sugandi, bayo ɛ tan gbo yamaan birin xa. Ɛ tan yi xurun yamaan birin xa. ");
INSERT INTO yal_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Koni Alatala ɛ tan nan xanuxi. A yi a layirin nakamali a naxan tongo, a a kɔlɔ naxan ma ɛ benbane xa. Na nan a toxi a ɛ ramini a sɛnbɛn na konyiyani. A yi ɛ xunba Firawona yii, Misiran mangana. ");
INSERT INTO yal_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Nanara, ɛ xa a kolon, a Alatala ɛ Ala, a tan keden peen nan Ala ra. A tinxin. Naxanye na a xanu, e a yamarin suxu, a a layirin nakamalima ne xa nɛn a hinanni han mayixɛtɛ wuli keden. ");
INSERT INTO yal_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Naxanye na a xɔnnantenya, a ne fan saranna fima nɛn, a yi e halagi. Ala na xɔnnantenyaan saranma nɛn keden na. ");
INSERT INTO yal_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Nayi, i xa n ma yamarine nun tɔnne nun sariyane suxu ki faɲi, n ni yamarixi naxan na to. ");
INSERT INTO yal_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Xa i yamarini itoe ramɛ, i yi e suxu ki faɲi, Alatala i ya Alaa layirin nakamalima i xa nɛn a hinanni, alo a a kɔlɔ i benbane xa kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","A i xanuma nɛn, a barakan sa i ya fe yi, a mɔn yi i wuya ayi. A barakan sama nɛn i ya dii barini e nun i ya xɛɛne bogiseene, maala nun manpa nɛnɛn nun turena, e nun i ya ɲinge diin nun yɛxɛɛ diin naxanye xalin kuruni, na bɔxɔni, a a kɔlɔ naxan ma ɛ benbane xa, a a soma ɛ yii. ");
INSERT INTO yal_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","A ɛ barakama nɛn dangu siyane birin na. Dii baritaren mi luyɛ ɛ tagi, xɛmɛn ba, ɲaxanla ba, hali xuruseene. ");
INSERT INTO yal_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Alatala ɛ ratangama nɛn furen sifan birin ma. A mi fitina fure yo ragidɛ ɛ ma alo ɛ naxanye toxi Misiran yi. Koni a ne rasanbama muxune ma nɛn naxanye na ɛ xɔn. ");
INSERT INTO yal_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Ɛ lan nɛn ɛ xa muxune birin faxa, Alatala ɛ Ala naxanye soma ɛ yii. Ɛ nama kininkinin e ma, ɛ mɔn nama e gbee alane batu, alogo e nama ɛ ratantan. ");
INSERT INTO yal_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Ɛ a mirima nɛn ɛ bɔɲɛni, “Siyani itoe gbo en tan xa. Nxu tan e nɔɔn di?” ");
INSERT INTO yal_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Koni, ɛ nama gaxu e yɛɛ ra. Alatala ɛ Ala naxan ligaxi Firawona nun Misiran bɔxɔn birin na, na xa rabira ɛ ma. ");
INSERT INTO yal_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Ɛ bata fe xɔdɛxɛne to naxanye dɔxi e ra, e nun taxamasenne nun kabanakoon naxanye ligaxi. Ɛ bata Alatala ɛ Ala sɛnbɛn nun nɔɔn to a ɛ ramini naxan na Misiran bɔxɔni. Alatala ɛ Ala na fe sifan ligama nɛn yamanane birin na ɛ gaxuxi naxanye yɛɛ ra. ");
INSERT INTO yal_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Alatala ɛ Ala ɛ luma nɛn alo ɲurun naxanye ɛ yaxune kedima han hali naxanye e luxunxi ɛ ma, ne fan yi halagi. ");
INSERT INTO yal_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Ɛ nama gaxu e yɛɛ ra, bayo Alatala ɛ Ala nan ɛ tagi, a gbo, a magaxu. ");
INSERT INTO yal_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Alatala ɛ Ala siyani itoe kedima nɛn ɛ yɛɛ ra xunxuri yɛɛn ma, ɛ mi nɔɛ e birin faxɛ sanɲa yi kedenni, alogo burunna subene nama wuya ayi, e ɛ tɔrɔ. ");
INSERT INTO yal_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Alatala ɛ Ala e soma nɛn ɛ yii. A yi e yifu han, e halagi. ");
INSERT INTO yal_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","A e mangane soma nɛn ɛ yii, ɛ yi e xinle ralɔ ayi dunuɲa yi. Muxu yo mi nɔɛ tiyɛ ɛ kanke. Ɛ e birin halagima nɛn. ");
INSERT INTO yal_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Ɛ xa e ala sawurane gan. Ɛ nama mila xɛmaan nun gbetin xɔn naxan na suxurene ma. Ɛ nama ne tongo ɛ gbeen na alogo a nama findi luti ratixin na ɛ fan yɛɛ ra. Amasɔtɔ se xɔsixin nan na ra Alatala ɛ Ala yɛɛ ra yi. ");
INSERT INTO yal_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Ɛ nama na suxure sifan naso ɛ banxine yi de, alogo ɛ fan nama halagi alo e tan. Ɛ xa ne raɲaxu bayo e haramuxi. ");
INSERT INTO yal_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Ɛ xa yamarini itoe birin suxu n naxanye yamarima ɛ ma to alogo ɛ xa siimaya faɲin sɔtɔ, ɛ yi wuya ayi. Ɛ yi na bɔxɔn sɔtɔ Alatala a kɔlɔxi naxan ma fe ra, a a soma nɛn ɛ benbane yii. ");
INSERT INTO yal_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Ɛ ɛ miri sigati xunkuyen ma Alatala ɛ Ala naxan nagidi ɛ ma tonbonni ɲɛɛ tonge naanin bun alogo a xa ɛ findi muxu yɛtɛ magodoxine ra. A mɔn xa ɛ kɛɲaan fɛsɛfɛsɛ, alogo a xa a kolon feen naxan ɛ sɔndɔmɛni, xa ɛ a yamarine suxɛ, hanma xa ɛ mi e suxɛ. ");
INSERT INTO yal_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","A ɛ findi muxu yɛtɛ magodoxine ra nɛn, a yi ɛ rakamɛ. A mɔn yi Manna donseen so ɛ yii, ɛ nun ɛ benbane mi yi donseen naxan kolon. Na birin alogo a xa a yita ɛ ra, a muxun mi balon donseen xan gbansan na, fɔ Alatala falan naxanye birin tima. ");
INSERT INTO yal_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Ɲɛɛ tonge naaninni itoe bun, ɛ domane mi kalaxi, ɛ sanne mi kusinxi. ");
INSERT INTO yal_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Ɛ xa a kolon a Alatala ɛ Ala ɛ maxuruma nɛn alo diin fafe a maxuruma kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Ɛ xa Alatala ɛ Alaa yamarine birin suxu, ɛ bira a kirane fɔxɔ ra, ɛ mɔn yi gaxu a yɛɛ ra. ");
INSERT INTO yal_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Alatala ɛ Ala ɛ xalima nɛn bɔxɔ faɲini xudene nun darane dɛnaxan yi. Tigi ige gbeen minima na bɔxɔn lanbanne nun a geyane yi. ");
INSERT INTO yal_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Murutun nun fundenna nun manpa binle nun xɔdɛ binle nun girenada binle nun oliwi turene nun kumin gbo na bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Burun mi ɲanma na bɔxɔni, sese mi fa dasama ɛ ma. Ɛ nɔɛ wuren bɛ nɛn gɛmɛni, wure gbeela fan yi sɔtɔ geyane yi. ");
INSERT INTO yal_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Ɛ na ɛ dɛge han ɛ yi lugo, ɛ xa barika bira Alatala ɛ Ala xa bɔxɔ faɲini ito a fe ra. ");
INSERT INTO yal_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Ɛ a liga ɛ yeren ma de! Ɛ nama ɲinan Alatala ɛ Ala xɔn, ɛ yi tondi a yamarine nun sariyane nun tɔnne suxɛ, n naxanye yamarima ɛ ma to. ");
INSERT INTO yal_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Ɛ na ɛ dɛge han ɛ yi lugo, ɛ na banxi faɲine ti, ɛ yi dɔxɔ mɛnni, ");
INSERT INTO yal_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ɛ ɲingene nun siine nun yɛxɛɛne na wuya ayi, ɛ gbetin nun ɛ xɛmaan na gbo ayi, ɛ hɛrisigɛn birin na gbo, ");
INSERT INTO yal_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ɛ xa a liga ɛ yeren ma alogo ɛ nama waso han ɛ yi ɲinan Alatala ɛ Ala xɔn, naxan ɛ ramini konyiyani Misiran bɔxɔni. ");
INSERT INTO yal_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","A bata ɛ radangu tonbon gbee magaxuxin na, saɲi xɔlɛne nun tanle dɛnaxan yi, igen mi bɔxɔn naxan yi. A yi igen namini fanyeni ɛ xa. ");
INSERT INTO yal_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","A yi Manna donseen so ɛ yii tonbonni ɛ benbane mi yi donseen naxan kolon, alogo a xa ɛ findi muxu yɛtɛ magodoxine ra, a yi ɛ kɛɲaan fɛsɛfɛsɛ, a yi nɔ fe faɲi ligadeni ɛ xa. ");
INSERT INTO yal_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Ɛ nama a miri, a ɛ hɛrisigɛni ito sɔtɔxi ɛ sɛnbɛn nun ɛ fangan nan xɔn. ");
INSERT INTO yal_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Ɛ xaxili lu Alatala ɛ Ala xɔn, bayo a tan nan sɛnbɛni ito fima ɛ ma alogo ɛ xa na hɛrisigɛn birin sɔtɔ. A a layirin nakamalima iki alo a a kɔlɔ ɛ benbane xa kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Xa ɛ ɲinan Alatala ɛ Ala xɔn, xa ɛ bira ala gbɛtɛye fɔxɔ ra, xa ɛ ɛ xinbi sin e xa, ɛ yi e batu, n xa a fala ɛ xa to, ɛ halagima nɛn. ");
INSERT INTO yal_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Ɛ halagima nɛn alo Alatala siya gbɛtɛne halagima ɛ yɛɛ ra kii naxan yi iki, bayo ɛ mi ɛ tuli matixi Alatala ɛ Ala a xuiin na. ");
INSERT INTO yal_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Isirayila kaane, ɛ tuli mati. Iki, ɛ Yurudɛn baan gidima nɛn. Ɛ siyane kedima nɛn naxanye gbo ɛ xa, e sɛnbɛn dangu ɛ ra. Ɛ yi e taane tongo naxanye yinne mate han kore. ");
INSERT INTO yal_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Mɛn kaane gbo, e kuya. Anaki bɔnsɔnna muxune nan ne ra, ɛ naxanye fe kolon. Ɛ bata a mɛ, muxune naxa, “Nde nɔɛ tiyɛ Anaki bɔnsɔnna kanke?” ");
INSERT INTO yal_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Ɛ xa a kolon iki, a Alatala ɛ Ala nan tima ɛ yɛɛ ra, alo tɛɛn naxan seen birin ganma. A tan nan e halagima, a e yarabima nɛn ɛ xa. Ɛ yi e kedi, ɛ yi e ɲan mafurɛn alo Alatala ɛ Ala a fala ɛ xa kii naxan yi. ");
INSERT INTO yal_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Alatala ɛ Ala na e kedi ɛ yɛɛ ra waxatin naxan yi, ɛ nama ɛ yɛtɛ matɔxɔ fa fala, “Alatala n nafaxi be bɔxɔni ito masɔtɔden ni bayo n tinxin.” Na mi a ra. Alatala siya gbɛtɛne kedima ɛ yɛɛ ra e kɛwali ɲaxine nan ma fe ra. ");
INSERT INTO yal_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Ɛ nama a miri, a ɛ fama e bɔxɔn sɔtɔdeni ɛ tinxinna nun ɛ lannayaan nan ma. Alatala siyani itoe kedima ɛ yɛɛ ra e kɛwali ɲaxine nan ma, alogo a xa a kɔlɔ xuiin nakamali, a naxan fala ɛ benbane Iburahima nun Isiyaga nun Yaxuba xa. ");
INSERT INTO yal_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Ɛ xa a kolon, a Alatala ɛ Ala mi bɔxɔ faɲini ito soxi ɛ yii ɛ gbeen na ɛ tinxinna xan ma fe ra. Amasɔtɔ yama murutɛxin nan ɛ ra. ");
INSERT INTO yal_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Na feen xa rabira ɛ ma ɛ Alatala ɛ Ala raxɔlɔ kii naxan yi tonbonni. Ɛ nama ɲinan na xɔn de! Xabu ɛ keli Misiran yi, han ɛ so be, ɛ yi murutɛma Alatala ɛ Ala xili ma. ");
INSERT INTO yal_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Ɛ Alatala raxɔlɔ nɛn Horebe geyaan fari han a yi wa ɛ faxa feni. ");
INSERT INTO yal_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","N to te geyaan fari alogo n xa walaxa gɛmɛ daxine tongo naxan findixi layirin na en nun Alatala tagi, n yi yanyi tonge naanin nun kɔɛ tonge naanin ti geyaan fari, n mi donseen don, n mi igen fan min. ");
INSERT INTO yal_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Alatala yi walaxa gɛmɛ daxi firin so n yii, a naxan sɛbɛ a yɛtɛ yiin na. Alatala yamarin naxanye fala ɛ xa tɛɛn tagi ɛ yi malanxi waxatin naxan yi geyaan fari, ne birin yi sɛbɛxi walaxane ma. ");
INSERT INTO yal_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Yanyi tonge naanin nun kɔɛ tonge naanin to dɛfe, Alatala yi walaxa gɛmɛ daxi firinne so n yii a layirin na. ");
INSERT INTO yal_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Alatala yi a fala n xa, a naxa, “Keli, i xa godo maf